﻿USE sofia;
DROP TABLE IF EXISTS sofia.amh_vpl;
CREATE TABLE amh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES amh_vpl WRITE;
INSERT INTO amh_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","የዳዊት ልጅ የአብርሃም ልጅ የኢየሱስ ክርስቶስ ትውልድ መጽሐፍ። ");
INSERT INTO amh_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","አብርሃም ይስሐቅን ወለደ፤ ይስሐቅም ያዕቆብን ወለደ፤ ያዕቆብም ይሁዳንና ወንድሞቹን ወለደ፤ ");
INSERT INTO amh_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ይሁዳም ከትዕማር ፋሬስንና ዛራን ወለደ፤ ፋሬስም ኤስሮምን ወለደ፤ ");
INSERT INTO amh_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ኤስሮምም አራምን ወለደ፤ አራምም አሚናዳብን ወለደ፤ አሚናዳብም ነአሶንን ወለደ፤ ነአሶንም ሰልሞንን ወለደ፤ ");
INSERT INTO amh_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ሰልሞንም ከራኬብ ቦኤዝን ወለደ፤ ቦኤዝም ከሩት ኢዮቤድን ወለደ፤ ኢዮቤድም እሴይን ወለደ፤ ");
INSERT INTO amh_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","እሴይም ንጉሥ ዳዊትን ወለደ። ");
INSERT INTO amh_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ሰሎሞንም ሮብዓምን ወለደ፤ ሮብዓምም አቢያን ወለደ፤ አቢያም አሣፍን ወለደ፤ ");
INSERT INTO amh_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","አሣፍም ኢዮሣፍጥን ወለደ፤ ኢዮሣፍጥም ኢዮራምን ወለደ፤ ኢዮራምም ዖዝያንን ወለደ፤ ");
INSERT INTO amh_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ዖዝያንም ኢዮአታምን ወለደ፤ ኢዮአታምም አካዝን ወለደ፤ ");
INSERT INTO amh_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","አካዝም ሕዝቅያስን ወለደ፤ ሕዝቅያስም ምናሴን ወለደ፤ ምናሴም አሞፅን ወለደ፤ ");
INSERT INTO amh_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","አሞፅም ኢዮስያስን ወለደ፤ ኢዮስያስም በባቢሎን ምርኮ ጊዜ ኢኮንያንንና ወንድሞቹን ወለደ። ");
INSERT INTO amh_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ከባቢሎንም ምርኮ በኋላ ኢኮንያን ሰላትያልን ወለደ፤ ሰላትያልም ዘሩባቤልን ወለደ፤ ");
INSERT INTO amh_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ዘሩባቤልም አብዩድን ወለደ፤ አብዩድም ኤልያቄምን ወለደ፤ ኤልያቄምም አዛርን ወለደ፤ ");
INSERT INTO amh_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","አዛርም ሳዶቅን ወለደ፤ ሳዶቅም አኪምን ወለደ፤ አኪምም ኤልዩድን ወለደ፤ ");
INSERT INTO amh_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ኤልዩድም አልዓዛርን ወለደ፤ አልዓዛርም ማታንን ወለደ፤ ማታንም ያዕቆብን ወለደ፤ ");
INSERT INTO amh_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ያዕቆብም ክርስቶስ የተባለውን ኢየሱስን የወለደች የማርያምን እጮኛ ዮሴፍን ወለደ። ");
INSERT INTO amh_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","እንግዲህ ትውልድ ሁሉ ከአብርሃም እስከ ዳዊት አሥራ አራት ትውልድ፥ ከዳዊትም እስከ ባቢሎን ምርኮ አሥራ አራት ትውልድ፥ ከባቢሎንም ምርኮ እስከ ክርስቶስ አሥራ አራት ትውልድ ነው። ");
INSERT INTO amh_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","የኢየሱስ ክርስቶስም ልደት እንዲህ ነበረ። እናቱ ማርያም ለዮሴፍ በታጨች ጊዜ ሳይገናኙ ከመንፈስ ቅዱስ ፀንሳ ተገኘች። ");
INSERT INTO amh_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","እጮኛዋ ዮሴፍም ጻድቅ ሆኖ ሊገልጣት ስላልወደደ በስውር ሊተዋት አሰበ። ");
INSERT INTO amh_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","እርሱ ግን ይህን ሲያስብ፥ እነሆ የጌታ መልአክ በሕልም ታየው፥ እንዲህም አለ። የዳዊት ልጅ ዮሴፍ ሆይ፥ ከእርስዋ የተፀነሰው ከመንፈስ ቅዱስ ነውና እጮኛህን ማርያምን ለመውሰድ አትፍራ። ");
INSERT INTO amh_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ልጅም ትወልዳለች፤ እርሱ ሕዝቡን ከኃጢአታቸው ያድናቸዋልና ስሙን ኢየሱስ ትለዋለህ። ");
INSERT INTO amh_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","በነቢይ ከጌታ ዘንድ። ");
INSERT INTO amh_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","እነሆ፥ ድንግል ትፀንሳለች ልጅም ትወልዳለች፥ ስሙንም አማኑኤል ይሉታል የተባለው ይፈጸም ዘንድ ይህ ሁሉ ሆኖአል፥ ትርጓሜውም። እግዚአብሔር ከእኛ ጋር የሚል ነው። ");
INSERT INTO amh_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ዮሴፍም ከእንቅልፉ ነቅቶ የጌታ መልአክ እንዳዘዘው አደረገ፤ እጮኛውንም ወሰደ፤ ");
INSERT INTO amh_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","የበኩር ልጅዋንም እስክትወልድ ድረስ አላወቃትም፤ ስሙንም ኢየሱስ አለው። ");
INSERT INTO amh_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","3","ንጉሡ ሄሮድስም ሰምቶ ደነገጠ፥ ኢየሩሳሌምም ሁሉ ከእርሱ ጋር፤ ");
INSERT INTO amh_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","የካህናትንም አለቆች የሕዝቡንም ጻፎች ሁሉ ሰብስቦ ክርስቶስ ወዴት እንዲወለድ ጠየቃቸው። ");
INSERT INTO amh_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","7","ከዚህ በኋላ ሄሮድስ ሰብአ ሰገልን በስውር ጠርቶ ኮከቡ የታየበትን ዘመን ከእነርሱ በጥንቃቄ ተረዳ፥ ");
INSERT INTO amh_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ወደ ቤተ ልሔምም እነርሱን ሰድዶ። ሂዱ፥ ስለ ሕፃኑ በጥንቃቄ መርምሩ፤ ባገኛችሁትም ጊዜ እኔ ደግሞ መጥቼ እንድሰግድለት ንገሩኝ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","እነርሱም ንጉሡን ሰምተው ሄዱ፤ እነሆም፥ በምሥራቅ ያዩት ኮከብ ሕፃኑ ባለበት ላይ መጥቶ እስኪቆም ድረስ ይመራቸው ነበር። ");
INSERT INTO amh_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ኮከቡንም ባዩ ጊዜ በታላቅ ደስታ እጅግ ደስ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ወደ ቤትም ገብተው ሕፃኑን ከእናቱ ከማርያም ጋር አዩት፥ ወድቀውም ሰገዱለት፥ ሣጥኖቻቸውንም ከፍተው እጅ መንሻ ወርቅና ዕጣን ከርቤም አቀረቡለት። ");
INSERT INTO amh_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ወደ ሄሮድስም እንዳይመለሱ በሕልም ተረድተው በሌላ መንገድ ወደ አገራቸው ሄዱ። ");
INSERT INTO amh_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","እነርሱም ከሄዱ በኋላ እነሆ፥ የጌታ መልአክ በሕልም ለዮሴፍ ታይቶ። ሄሮድስ ሕፃኑን ሊገድለው ይፈልገዋልና ተነሣ፥ ሕፃኑንና እናቱንም ይዘህ ወደ ግብፅ ሽሽ፥ እስክነግርህም ድረስ በዚያ ተቀመጥ አለው። ");
INSERT INTO amh_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","16","ከዚህ በኋላ ሄሮድስ ሰብአ ሰገል እንደ ተሣለቁበት ባየ ጊዜ እጅግ ተቆጣና ልኮ ከሰብአ ሰገል እንደ ተረዳው ዘመን በቤተ ልሔምና በአውራጃዋ የነበሩትን፥ ሁለት ዓመት የሆናቸውን ከዚያም የሚያንሱትን ሕፃናት ሁሉ አስገደለ። ");
INSERT INTO amh_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","19","ሄሮድስም ከሞተ በኋላ፥ እነሆ፥ የጌታ መልአክ በግብፅ ለዮሴፍ በሕልም ታይቶ። ");
INSERT INTO amh_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","የሕፃኑን ነፍስ የፈለጉት ሞተዋልና ተነሣ፥ ሕፃኑን እናቱንም ይዘህ ወደ እስራኤል አገር ሂድ አለ። ");
INSERT INTO amh_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","እርሱም ተነሥቶ ሕፃኑንና እናቱን ያዘና ወደ እስራኤል አገር ገባ። ");
INSERT INTO amh_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","በአባቱም በሄሮድስ ፈንታ አርኬላዎስ በይሁዳ እንደ ነገሠ በሰማ ጊዜ፥ ወደዚያ መሄድን ፈራ፤ በሕልምም ተረድቶ ወደ ገሊላ አገር ሄደ፤ ");
INSERT INTO amh_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","በነቢያት። ናዝራዊ ይባላል የተባለው ይፈጸም ዘንድ፥ ናዝሬት ወደምትባል ከተማ መጥቶ ኖረ። ");
INSERT INTO amh_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","3","በነቢዩ በኢሳይያስ። የጌታን መንገድ አዘጋጁ ጥርጊያውንም አቅኑ እያለ በምድረ በዳ የሚጮህ ሰው ድምፅ የተባለለት ይህ ነውና። ");
INSERT INTO amh_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ራሱም ዮሐንስ የግመል ጠጉር ልብስ ነበረው፥ በወገቡም ጠፍር ይታጠቅ ነበር፤ ምግቡም አንበጣና የበረሀ ማር ነበረ። ");
INSERT INTO amh_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ያን ጊዜ ኢየሩሳሌም ይሁዳም ሁሉ በዮርዳኖስም ዙሪያ ያለ አገር ሁሉ ወደ እርሱ ይወጡ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ኃጢአታቸውንም እየተናዘዙ በዮርዳኖስ ወንዝ ከእርሱ ይጠመቁ ነበር። ");
INSERT INTO amh_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ዳሩ ግን ከፈሪሳውያንና ከሰዱቃውያን ብዙዎች ወደ ጥምቀቱ ሲመጡ ባየ ጊዜ፥ እንዲህ አላቸው። እናንተ የእፉኝት ልጆች፥ ከሚመጣው ቍጣ እንድትሸሹ ማን አመለከታችሁ? ");
INSERT INTO amh_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","እንግዲህ ለንስሐ የሚገባ ፍሬ አድርጉ፤ ");
INSERT INTO amh_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","በልባችሁም። አብርሃም አባት አለን እንደምትሉ አይምሰላችሁ፤ እላችኋለሁና። ከነዚህ ድንጋዮች ለአብርሃም ልጆች ሊያስነሣለት እግዚአብሔር ይችላል። ");
INSERT INTO amh_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","አሁንስ ምሳር በዛፎች ሥር ተቀምጦአል፤ እንግዲህ መልካም ፍሬ የማያደርግ ዛፍ ሁሉ ይቈረጣል ወደ እሳትም ይጣላል። ");
INSERT INTO amh_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","እኔስ ለንስሐ በውኃ አጠምቃችኋለሁ፤ ጫማውን እሸከም ዘንድ የማይገባኝ ከእኔ በኋላ የሚመጣው ግን ከእኔ ይልቅ ይበረታል፤ እርሱ በመንፈስ ቅዱስ በእሳትም ያጠምቃችኋል፤ ");
INSERT INTO amh_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","መንሹም በእጁ ነው፥ አውድማውንም ፈጽሞ ያጠራል፥ ስንዴውንም በጎተራው ይከታል፥ ገለባውን ግን በማይጠፋ እሳት ያቃጥለዋል። ");
INSERT INTO amh_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ያን ጊዜ ኢየሱስ በዮሐንስ ሊጠመቅ ከገሊላ ወደ ዮርዳኖስ መጣ። ");
INSERT INTO amh_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ዮሐንስ ግን። እኔ በአንተ ልጠመቅ ያስፈልገኛል አንተም ወደ እኔ ትመጣለህን? ብሎ ይከለክለው ነበር። ");
INSERT INTO amh_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ኢየሱስም መልሶ። አሁንስ ፍቀድልኝ፤ እንዲህ ጽድቅን ሁሉ መፈጸም ይገባናልና አለው። ያን ጊዜ ፈቀደለት። ");
INSERT INTO amh_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ኢየሱስም ከተጠመቀ በኋላ ወዲያው ከውኃ ወጣ፤ እነሆም፥ ሰማያት ተከፈቱ የእግዚአብሔርም መንፈስ እንደ ርግብ ሲወርድ በእርሱ ላይም ሲመጣ አየ፤ ");
INSERT INTO amh_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","እነሆም፥ ድምፅ ከሰማያት መጥቶ። በእርሱ ደስ የሚለኝ የምወደው ልጄ ይህ ነው አለ። ");
INSERT INTO amh_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ከዚያ ወዲያ ኢየሱስ ከዲያብሎስ ይፈተን ዘንድ መንፈስ ወደ ምድረ በዳ ወሰደው፥ ");
INSERT INTO amh_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","አርባ ቀንና አርባ ሌሊትም ከጦመ በኋላ ተራበ። ");
INSERT INTO amh_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ፈታኝም ቀርቦ። የእግዚአብሔር ልጅ ከሆንህ፥ እነዚህ ድንጋዮች እንጀራ እንዲሆኑ በል አለው። ");
INSERT INTO amh_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","እርሱም መልሶ። ሰው ከእግዚአብሔር አፍ በሚወጣ ቃል ሁሉ እንጂ በእንጀራ ብቻ አይኖርም ተብሎ ተጽፎአል አለው። ");
INSERT INTO amh_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ከዚህ በኋላ ዲያቢሎስ ወደ ቅድስት ከተማ ወሰደውና እርሱን በመቅደስ ጫፍ ላይ አቁሞ። ");
INSERT INTO amh_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","መላእክቱን ስለ አንተ ያዝልሃል እግርህንም በድንጋይ ከቶ እንዳትሰናከል በእጃቸው ያነሡሃል ተብሎ ተጽፎአልና የእግዚአብሔር ልጅስ ከሆንህ፥ ወደ ታች ራስህን ወርውር አለው። ");
INSERT INTO amh_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ኢየሱስም። ጌታን አምላክህን አትፈታተነው ተብሎ ደግሞ ተጽፎአል አለው። ");
INSERT INTO amh_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ደግሞ ዲያቢሎስ እጅግ ረጅም ወደ ሆነ ተራራ ወሰደው፥ የዓለምንም መንግሥታት ሁሉ ክብራቸውንም አሳይቶ። ");
INSERT INTO amh_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ወድቀህ ብትሰግድልኝ ይህን ሁሉ እሰጥሃለሁ አለው። ");
INSERT INTO amh_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ያን ጊዜ ኢየሱስ። ሂድ፥ አንተ ሰይጣን ለጌታህ ለአምላክህ ስገድ እርሱንም ብቻ አምልክ ተብሎ ተጽፎአልና አለው። ");
INSERT INTO amh_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ያን ጊዜ ዲያቢሎስ ተወው፥ እነሆም፥ መላእክት ቀርበው ያገለግሉት ነበር። ");
INSERT INTO amh_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ኢየሱስም ዮሐንስ አልፎ እንደ ተሰጠ በሰማ ጊዜ ወደ ገሊላ ፈቀቅ ብሎ ሄደ። ");
INSERT INTO amh_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ናዝሬትንም ትቶ በዛብሎንና በንፍታሌም አገር በባሕር አጠገብ ወደ አለችው ወደ ቅፍርናሆም መጥቶ ኖረ። ");
INSERT INTO amh_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","17","የተባለው ይፈጸም ዘንድ ይህ ሆነ። ከዚያ ዘመን ጀምሮ ኢየሱስ። መንግሥተ ሰማያት ቀርባለችና ንስሐ ግቡ እያለ ይሰብክ ጀመር። ");
INSERT INTO amh_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","በገሊላ ባሕር አጠገብ ሲመላለስም ሁለት ወንድማማች ጴጥሮስ የሚሉትን ስምዖንን ወንድሙንም እንድርያስን መረባቸውን ወደ ባሕር ሲጥሉ አየ፥ ዓሣ አጥማጆች ነበሩና። ");
INSERT INTO amh_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","እርሱም። በኋላዬ ኑና ሰዎችን አጥማጆች እንድትሆኑ አደርጋችኋለሁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ወዲያውም መረባቸውን ትተው ተከተሉት። ");
INSERT INTO amh_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ከዚያም እልፍ ብሎ ሌሎችን ሁለት ወንድማማች የዘብዴዎስን ልጅ ያዕቆብን ወንድሙንም ዮሐንስን ከአባታቸው ከዘብዴዎስ ጋር በታንኳ መረባቸውን ሲያበጁ አየ፤ ጠራቸውም። ");
INSERT INTO amh_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","እነርሱም ወዲያው ታንኳይቱንና አባታቸውን ትተው ተከተሉት። ");
INSERT INTO amh_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ኢየሱስም በምኩራቦቻቸው እያስተማረ የመንግሥትንም ወንጌል እየሰበከ በሕዝብም ያለውን ደዌና ሕማም ሁሉ እየፈወሰ በገሊላ ሁሉ ይዞር ነበር። ");
INSERT INTO amh_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ዝናውም ወደ ሶርያ ሁሉ ወጣ፤ በልዩ ልዩ ደዌና ሥቃይም ተይዘው የታመሙትን ሁሉ አጋንንትም ያደሩባቸውን በጨረቃም የሚነሣባቸውን ሽባዎችንም ወደ እርሱ አመጡ፥ ፈወሳቸውም። ");
INSERT INTO amh_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ከገሊላም ከአሥሩ ከተማም ከኢየሩሳሌምም ከይሁዳም ከዮርዳኖስም ማዶ ብዙ ሕዝብ ተከተሉት። ");
INSERT INTO amh_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ሕዝቡንም አይቶ ወደ ተራራ ወጣ፤ በተቀመጠም ጊዜ ደቀ መዛሙርቱ ወደ እርሱ ቀረቡ፤ ");
INSERT INTO amh_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","አፉንም ከፍቶ አስተማራቸው እንዲህም አለ። ");
INSERT INTO amh_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","በመንፈስ ድሆች የሆኑ ብፁዓን ናቸው፥ መንግሥተ ሰማያት የእነርሱ ናትና። ");
INSERT INTO amh_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","የሚያዝኑ ብፁዓን ናቸው፥ መፅናናትን ያገኛሉና። ");
INSERT INTO amh_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","የዋሆች ብፁዓን ናቸው፥ ምድርን ይወርሳሉና። ");
INSERT INTO amh_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ጽድቅን የሚራቡና የሚጠሙ ብፁዓን ናቸው፥ ይጠግባሉና። ");
INSERT INTO amh_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","የሚምሩ ብፁዓን ናቸው፥ ይማራሉና። ");
INSERT INTO amh_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ልበ ንጹሖች ብፁዓን ናቸው፥ እግዚአብሔርን ያዩታልና። ");
INSERT INTO amh_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","የሚያስተራርቁ ብፁዓን ናቸው፥ የእግዚአብሔር ልጆች ይባላሉና። ");
INSERT INTO amh_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ስለ ጽድቅ የሚሰደዱ ብፁዓን ናቸው፥ መንግሥተ ሰማያት የእነርሱ ናትና። ");
INSERT INTO amh_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ሲነቅፉአችሁና ሲያሳድዱአችሁ በእኔም ምክንያት ክፉውን ሁሉ በውሸት ሲናገሩባችሁ ብፁዓን ናችሁ። ");
INSERT INTO amh_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ዋጋችሁ በሰማያት ታላቅ ነውና ደስ ይበላችሁ፥ ሐሴትም አድርጉ፤ ከእናንተ በፊት የነበሩትን ነቢያትን እንዲሁ አሳድደዋቸዋልና። ");
INSERT INTO amh_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","እናንተ የምድር ጨው ናችሁ፤ ጨው አልጫ ቢሆን ግን በምን ይጣፍጣል? ወደ ውጭ ተጥሎ በሰው ከመረገጥ በቀር ወደ ፊት ለምንም አይጠቅምም። ");
INSERT INTO amh_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","እናንተ የዓለም ብርሃን ናችሁ። በተራራ ላይ ያለች ከተማ ልትሰወር አይቻላትም። ");
INSERT INTO amh_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","መብራትንም አብርተው ከዕንቅብ በታች አይደለም እንጂ በመቅረዙ ላይ ያኖሩታል በቤት ላሉት ሁሉም ያበራል። ");
INSERT INTO amh_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","መልካሙን ሥራችሁን አይተው በሰማያት ያለውን አባታችሁን እንዲያከብሩ ብርሃናችሁ እንዲሁ በሰው ፊት ይብራ። ");
INSERT INTO amh_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","እኔ ሕግንና ነቢያትን ለመሻር የመጣሁ አይምሰላችሁ፤ ልፈጽም እንጂ ለመሻር አልመጣሁም። ");
INSERT INTO amh_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","እውነት እላችኋለሁ፥ ሰማይና ምድር እስኪያልፍ ድረስ፥ ከሕግ አንዲት የውጣ ወይም አንዲት ነጥብ ከቶ አታልፍም፥ ሁሉ እስኪፈጸም ድረስ። ");
INSERT INTO amh_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","እንግዲህ ከነዚህ ከሁሉ ካነሱት ትእዛዛት አንዲቱን የሚሽር ለሰውም እንዲሁ የሚያስተምር ማንም ሰው በመንግሥተ ሰማያት ከሁሉ ታናሽ ይባላል፤ የሚያደርግ ግን የሚያስተምርም ማንም ቢሆን እርሱ በመንግሥተ ሰማያት ታላቅ ይባላል። ");
INSERT INTO amh_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","እላችኋለሁና። ጽድቃችሁ ከጻፎችና ከፈሪሳውያን ጽድቅ ካልበለጠ፥ ወደ መንግሥተ ሰማያት ከቶ አትገቡም። ");
INSERT INTO amh_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","ለቀደሙት። አትግደል እንደ ተባለ ሰምታችኋል፤ የገደለም ሁሉ ፍርድ ይገባዋል። ");
INSERT INTO amh_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","እኔ ግን እላችኋለሁ፥ በወንድሙ ላይ የሚቆጣ ሁሉ ፍርድ ይገባዋል፤ ወንድሙንም ጨርቃም የሚለው ሁሉ የሸንጎ ፍርድ ይገባዋል፤ ደንቆሮ የሚለውም ሁሉ የገሃነመ እሳት ፍርድ ይገባዋል። ");
INSERT INTO amh_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","እንግዲህ መባህን በመሠዊያው ላይ ብታቀርብ፥ በዚያም ወንድምህ አንዳች በአንተ ላይ እንዳለው ብታስብ፥ ");
INSERT INTO amh_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","በዚያ በመሠዊያው ፊት መባህን ትተህ ሂድ፥ አስቀድመህም ከወንድምህ ጋር ታረቅ፥ በኋላም መጥተህ መባህን አቅርብ። ");
INSERT INTO amh_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","አብረኸው በመንገድ ሳለህ ከባላጋራህ ጋር ፈጥነህ ተስማማ፤ ባላጋራ ለዳኛ እንዳይሰጥህ ዳኛም ለሎሌው፥ ወደ ወህኒም ትጣላለህ፤ ");
INSERT INTO amh_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","እውነት እልሃለሁ፥ የመጨረሻዋን ሳንቲም እስክትከፍል ድረስ ከቶ ከዚያ አትወጣም። ");
INSERT INTO amh_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","አታመንዝር እንደ ተባለ ሰምታችኋል። ");
INSERT INTO amh_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","እኔ ግን እላችኋለሁ፥ ወደ ሴት ያየ ሁሉ የተመኛትም ያን ጊዜ በልቡ ከእርስዋ ጋር አመንዝሮአል። ");
INSERT INTO amh_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ቀኝ ዓይንህም ብታሰናክልህ አውጥተህ ከአንተ ጣላት፤ ሙሉ ሰውነትህ በገሃነም ከሚጣል ይልቅ ከአካላትህ አንድ ቢጠፋ ይሻልሃልና። ");
INSERT INTO amh_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ቀኝ እጅህም ብታሰናክልህ ቆርጠህ ከአንተ ጣላት፤ ሙሉ ሰውነትህ በገሃነም ከሚጣል ይልቅ ከአካላትህ አንድ ቢጠፋ ይሻላልና። ");
INSERT INTO amh_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ሚስቱን የሚፈታት ሁሉ የፍችዋን ጽሕፈት ይስጣት ተባለ። ");
INSERT INTO amh_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","እኔ ግን እላችኋለሁ፥ ያለ ዝሙት ምክንያት ሚስቱን የሚፈታ ሁሉ አመንዝራ ያደርጋታል፥ የተፈታችውንም የሚያገባ ሁሉ ያመነዝራል። ");
INSERT INTO amh_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ደግሞ ለቀደሙት። በውሸት አትማል ነገር ግን መሐላዎችህን ለጌታ ስጥ እንደተባለ ሰምታችኋል። ");
INSERT INTO amh_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","እኔ ግን እላችኋለሁ። ከቶ አትማሉ፤ በሰማይ አይሆንም የእግዚአብሔር ዙፋን ነውና፤ ");
INSERT INTO amh_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","በምድርም አይሆንም የእግሩ መረገጫ ናትና፤ በኢየሩሳሌምም አይሆንም የታላቁ ንጉሥ ከተማ ናትና፤ ");
INSERT INTO amh_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","በራስህም አትማል፥ አንዲቱን ጠጉር ነጭ ወይም ጥቁር ልታደርግ አትችልምና። ");
INSERT INTO amh_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ነገር ግን ቃላችሁ አዎን አዎን ወይም አይደለም አይደለም ይሁን፤ ከነዚህም የወጣ ከክፉው ነው። ");
INSERT INTO amh_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","ዓይን ስለ ዓይን ጥርስም ስለ ጥርስ እንደ ተባለ ሰምታችኋል። ");
INSERT INTO amh_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","እኔ ግን እላችኋለሁ፥ ክፉውን አትቃወሙ፤ ዳሩ ግን ቀኝ ጉንጭህን በጥፊ ለሚመታህ ሁሉ ሁለተኛውን ደግሞ አዙርለት፤ ");
INSERT INTO amh_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","እንዲከስህም እጀ ጠባብህንም እንዲወስድ ለሚወድ መጎናጸፊያህን ደግሞ ተውለት፤ ");
INSERT INTO amh_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ማንም ሰው አንድ ምዕራፍ ትሄድ ዘንድ ቢያስገድድህ ሁለተኛውን ከእርሱ ጋር ሂድ። ");
INSERT INTO amh_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ለሚለምንህ ስጥ፥ ከአንተም ይበደር ዘንድ ከሚወደው ፈቀቅ አትበል። ");
INSERT INTO amh_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","ባልንጀራህን ውደድ ጠላትህንም ጥላ እንደ ተባለ ሰምታችኋል። ");
INSERT INTO amh_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","46","የሚወዱአችሁን ብትወዱ ምን ዋጋ አላችሁ? ቀራጮችስ ያንኑ ያደርጉ የለምን? ");
INSERT INTO amh_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ወንድሞቻችሁንም ብቻ እጅ ብትነሡ ምን ብልጫ ታደርጋላችሁ? አሕዛብስ ያንኑ ያደርጉ የለምን? ");
INSERT INTO amh_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","እንግዲህ የሰማዩ አባታችሁ ፍጹም እንደ ሆነ እናንተ ፍጹማን ሁኑ። ");
INSERT INTO amh_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ለሰዎች ትታዩ ዘንድ ምጽዋታችሁን በፊታቸው እንዳታደርጉ ተጠንቀቁ፤ ያለዚያ በሰማያት ባለው አባታችሁ ዘንድ ዋጋ የላችሁም። ");
INSERT INTO amh_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","እንግዲህ ምጽዋት ስታደርግ፥ ግብዞች በሰው ዘንድ ሊከበሩ በምኩራብ በመንገድም እንደሚያደርጉ በፊትህ መለከት አታስነፋ፤ እውነት እላችኋለሁ፥ ዋጋቸውን ተቀብለዋል። ");
INSERT INTO amh_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","5","ስትጸልዩም እንደ ግብዞች አትሁኑ፤ ለሰው ይታዩ ዘንድ በምኩራብና በመንገድ ማዕዘን ቆመው መጸለይን ይወዳሉና፤ እውነት እላችኋለሁ፥ ዋጋቸውን ተቀብለዋል። ");
INSERT INTO amh_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","አንተ ግን ስትጸልይ፥ ወደ እልፍኝህ ግባ መዝጊያህንም ዘግተህ በስውር ላለው አባትህ ጸልይ፤ በስውር የሚያይ አባትህም በግልጥ ይከፍልሃል። ");
INSERT INTO amh_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","አሕዛብም በመናገራቸው ብዛት እንዲሰሙ ይመስላቸዋልና ስትጸልዩ እንደ እነርሱ በከንቱ አትድገሙ። ");
INSERT INTO amh_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ስለዚህ አትምሰሉአቸው፤ ሳትለምኑት አባታችሁ የሚያስፈልጋችሁን ያውቃልና። ");
INSERT INTO amh_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","እንግዲህ እናንተስ እንዲህ ጸልዩ። በሰማያት የምትኖር አባታችን ሆይ፥ ");
INSERT INTO amh_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ስምህ ይቀደስ፤ መንግሥትህ ትምጣ፤ ፈቃድህ በሰማይ እንደ ሆነች እንዲሁ በምድር ትሁን፤ ");
INSERT INTO amh_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","የዕለት እንጀራችንን ዛሬ ስጠን፤ ");
INSERT INTO amh_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","እኛም ደግሞ የበደሉንን ይቅር እንደምንል በደላችንን ይቅር በለን፤ ");
INSERT INTO amh_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ከክፉም አድነን እንጂ ወደ ፈተና አታግባን፤ መንግሥት ያንተ ናትና ኃይልም ክብርም ለዘለዓለሙ፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ለሰዎች ኃጢአታቸውን ይቅር ብትሉ፥ የሰማዩ አባታችሁ እናንተን ደግሞ ይቅር ይላችኋልና፤ ");
INSERT INTO amh_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ለሰዎች ግን ኃጢአታቸውን ይቅር ባትሉ፥ አባታችሁም ኃጢአታችሁን ይቅር አይላችሁም። ");
INSERT INTO amh_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","ስትጦሙም፥ እንደ ግብዞች አትጠውልጉ፤ ለሰዎች እንደ ጦመኛ ሊታዩ ፊታቸውን ያጠፋሉና፤ እውነት እላችኋለሁ፥ ዋጋቸውን ተቀብለዋል። ");
INSERT INTO amh_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","19","ብልና ዝገት በሚያጠፉት ሌቦችም ቆፍረው በሚሠርቁት ዘንድ ለእናንተ በምድር ላይ መዝገብ አትሰብስቡ፤ ");
INSERT INTO amh_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ነገር ግን ብልም ዝገትም በማያጠፉት ሌቦችም ቆፍረው በማይሠርቁት ዘንድ ለእናንተ በሰማይ መዝገብ ሰብስቡ፤ ");
INSERT INTO amh_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","መዝገብህ ባለበት ልብህ ደግሞ በዚያ ይሆናልና። ");
INSERT INTO amh_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","የሰውነት መብራት ዓይን ናት። ዓይንህ እንግዲህ ጤናማ ብትሆን፥ ሰውነትህ ሁሉ ብሩህ ይሆናል፤ ");
INSERT INTO amh_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ዓይንህ ግን ታማሚ ብትሆን፥ ሰውነትህ ሁሉ የጨለመ ይሆናል። እንግዲህ በአንተ ያለው ብርሃን ጨለማ ከሆነ፥ ጨለማውስ እንዴት ይበረታ! ");
INSERT INTO amh_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","ለሁለት ጌቶች መገዛት የሚቻለው ማንም የለም፤ ወይም አንዱን ይጠላል ሁለተኛውንም ይወዳል፤ ወይም ወደ አንዱ ይጠጋል ሁለተኛውንም ይንቃል፤ ለእግዚአብሔርና ለገንዘብ መገዛት አትችሉም። ");
INSERT INTO amh_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ስለዚህ እላችኋለሁ፥ ስለ ነፍሳችሁ በምትበሉትና በምትጠጡት፥ ወይም ስለ ሰውነታችሁ በምትለብሱት አትጨነቁ፤ ነፍስ ከመብል ሰውነትም ከልብስ አይበልጥምን? ");
INSERT INTO amh_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ወደ ሰማይ ወፎች ተመልከቱ፤ አይዘሩም አያጭዱምም በጎተራም አይከቱም፥ የሰማዩ አባታችሁም ይመግባቸዋል፤ እናንተ ከእነርሱ እጅግ አትበልጡምን? ");
INSERT INTO amh_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ከእናንተ ተጨንቆ በቁመቱ ላይ አንድ ክንድ መጨመር የሚችል ማን ነው? ");
INSERT INTO amh_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ስለ ልብስስ ስለ ምን ትጨነቃላችሁ? የሜዳ አበቦች እንዴት እንዲያድጉ ልብ አድርጋችሁ ተመልከቱ፤ ");
INSERT INTO amh_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","አይደክሙም አይፈትሉምም፤ ነገር ግን እላችኋለሁ፥ ሰሎሞንስ እንኳ በክብሩ ሁሉ ከነዚህ እንደ አንዱ አልለበሰም። ");
INSERT INTO amh_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","እግዚአብሔር ግን ዛሬ ያለውን ነገም ወደ እቶን የሚጣለውን የሜዳን ሣር እንዲህ የሚያለብሰው ከሆነ፥ እናንተ እምነት የጎደላችሁ፥ እናንተንማ ይልቁን እንዴት? ");
INSERT INTO amh_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","እንግዲህ። ምን እንበላለን? ምንስ እንጠጣለን? ምንስ እንለብሳለን? ብላችሁ አትጨነቁ፤ ");
INSERT INTO amh_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ይህንስ ሁሉ አሕዛብ ይፈልጋሉ፤ ይህ ሁሉ እንዲያስፈልጋችሁ የሰማዩ አባታችሁ ያውቃልና። ");
INSERT INTO amh_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ነገር ግን አስቀድማችሁ የእግዚአብሔርን መንግሥት ጽድቁንም ፈልጉ፥ ይህም ሁሉ ይጨመርላችኋል። ");
INSERT INTO amh_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ነገ ለራሱ ይጨነቃልና ለነገ አትጨነቁ፤ ለቀኑ ክፋቱ ይበቃዋል። ");
INSERT INTO amh_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","3","በወንድምህም ዓይን ያለውን ጉድፍ ስለምን ታያለህ፥ በዓይንህ ግን ያለውን ምሰሶ ስለ ምን አትመለከትም? ");
INSERT INTO amh_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ወይም ወንድምህን። ከዓይንህ ጉድፍ ላውጣ ፍቀድልኝ እንዴትስ ትለዋለህ? እነሆም፥ በዓይንህ ምሰሶ አለ። ");
INSERT INTO amh_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","አንተ ግብዝ፥ አስቀድመህ ከዓይንህ ምሰሶውን አውጣ፥ ከዚያም በኋላ ከወንድምህ ዓይን ጉድፉን ታወጣ ዘንድ አጥርተህ ታያለህ። ");
INSERT INTO amh_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","በእግራቸው እንዳይረግጡት ተመልሰውም እንዳይነክሱአችሁ፥ የተቀደሰውን ለውሾች አትስጡ፥ ዕንቁዎቻችሁንም በእሪያዎች ፊት አትጣሉ። ");
INSERT INTO amh_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ለምኑ፥ ይሰጣችሁማል፤ ፈልጉ፥ ታገኙማላችሁ፤ መዝጊያን አንኳኩ፥ ይከፈትላችሁማል። ");
INSERT INTO amh_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","የሚለምነው ሁሉ ይቀበላልና፥ የሚፈልገውም ያገኛል፥ መዝጊያንም ለሚያንኳኳ ይከፈትለታል። ");
INSERT INTO amh_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ወይስ ከእናንተ፥ ልጁ እንጀራ ቢለምነው፥ ድንጋይን የሚሰጠው ከእናንተ ማን ሰው ነው? ");
INSERT INTO amh_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ዓሣስ ቢለምነው እባብን ይሰጠዋልን? ");
INSERT INTO amh_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","እንኪያስ እናንተ ክፉዎች ስትሆኑ ለልጆቻችሁ መልካም ስጦታ መስጠትን ካወቃችሁ፥ በሰማያት ያለው አባታችሁ ለሚለምኑት እንዴት አብልጦ መልካም ነገርን ይሰጣቸው? ");
INSERT INTO amh_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","እንግዲህ ሰዎች ሊያደርጉላችሁ የምትወዱትን ሁሉ እናንተ ደግሞ እንዲሁ አድርጉላቸው፤ ሕግም ነቢያትም ይህ ነውና። ");
INSERT INTO amh_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","በጠበበው ደጅ ግቡ፤ ወደ ጥፋት የሚወስደው ደጅ ሰፊ፥ መንገዱም ትልቅ ነውና፥ ወደ እርሱም የሚገቡ ብዙዎች ናቸው፤ ");
INSERT INTO amh_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ወደ ሕይወት የሚወስደው ደጅ የጠበበ፥ መንገዱም የቀጠነ ነውና፥ የሚያገኙትም ጥቂቶች ናቸው። ");
INSERT INTO amh_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","የበግ ለምድ ለብሰው ከሚመጡባችሁ በውሥጣቸው ግን ነጣቂዎች ተኵላዎች ከሆኑ ከሐሰተኞች ነቢያት ተጠንቀቁ። ");
INSERT INTO amh_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ከፍሬያቸው ታውቋቸዋላችሁ። ከእሾህ ወይን ከኩርንችትስ በለስ ይለቀማልን? ");
INSERT INTO amh_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","እንዲሁ መልካም ዛፍ ሁሉ መልካም ፍሬ ያደርጋል፥ ክፉም ዛፍ ክፉ ፍሬ ያደርጋል። ");
INSERT INTO amh_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","መልካም ዛፍ ክፉ ፍሬ ማፍራት፥ ወይም ክፉ ዛፍ መልካም ፍሬ ማፍራት አይቻለውም። ");
INSERT INTO amh_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","መልካም ፍሬ የማያደርግ ዛፍ ሁሉ ይቆረጣል ወደ እሳትም ይጣላል። ");
INSERT INTO amh_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ስለዚህም ከፍሬያቸው ታውቋቸዋላችሁ። ");
INSERT INTO amh_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","በሰማያት ያለውን የአባቴን ፈቃድ የሚያደርግ እንጂ፥ ጌታ ሆይ፥ ጌታ ሆይ፥ የሚለኝ ሁሉ መንግሥተ ሰማያት የሚገባ አይደለም። ");
INSERT INTO amh_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","በዚያ ቀን ብዙዎች። ጌታ ሆይ፥ ጌታ ሆይ፥ በስምህ ትንቢት አልተናገርንምን፥ በስምህስ አጋንንትን አላወጣንምን፥ በስምህስ ብዙ ተአምራትን አላደረግንምን? ይሉኛል። ");
INSERT INTO amh_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","የዚያን ጊዜም። ከቶ አላወቅኋችሁም፤ እናንተ ዓመፀኞች፥ ከእኔ ራቁ ብዬ እመሰክርባቸዋለሁ። ");
INSERT INTO amh_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ስለዚህ ይህን ቃሌን ሰምቶ የሚያደርገው ሁሉ ቤቱን በዓለት ላይ የሠራ ልባም ሰውን ይመስላል። ");
INSERT INTO amh_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ዝናብም ወረደ ጎርፍም መጣ ነፋስም ነፈሰ ያንም ቤት ገፋው፥ በዓለት ላይም ስለ ተመሠረተ አልወደቀም። ");
INSERT INTO amh_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ይህንም ቃሌን ሰምቶ የማያደርገው ሰው ሁሉ ቤቱን በአሸዋ ላይ የሠራ ሰነፍ ሰውን ይመስላል። ");
INSERT INTO amh_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ዝናብም ወረደ ጎርፍም መጣ ነፋስም ነፈሰ ያንም ቤት መታው፥ ወደቀም፥ አወዳደቁም ታላቅ ሆነ። ");
INSERT INTO amh_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ኢየሱስም ይህን ነገር በጨረሰ ጊዜ ሕዝቡ በትምህርቱ ተገረሙ፤ እንደ ጻፎቻቸው ሳይሆን ");
INSERT INTO amh_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","እንደ ባለ ሥልጣን ያስተምራቸው ነበርና። ");
INSERT INTO amh_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ከተራራም በወረደ ጊዜ ብዙ ሕዝብ ተከተሉት። ");
INSERT INTO amh_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","እነሆም፥ ለምጻም ቀርቦ። ጌታ ሆይ፥ ብትወድስ ልታነጻኝ ትችላለህ እያለ ሰገደለት። ");
INSERT INTO amh_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","እጁንም ዘርግቶ ዳሰሰውና። እወዳለሁ፥ ንጻ አለው። ወዲያውም ለምጹ ነጻ። ");
INSERT INTO amh_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ኢየሱስም። ለማንም እንዳትናገር ተጠንቀቅ፥ ነገር ግን ሄደህ ራስህን ለካህን አሳይ፥ ለእነርሱም ምስክር እንዲሆን ሙሴ ያዘዘውን መባ አቅርብ አለው። ");
INSERT INTO amh_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ወደ ቅፍርናሆምም በገባ ጊዜ የመቶ አለቃ ወደ እርሱ ቀርቦ። ጌታ ሆይ፥ ");
INSERT INTO amh_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ብላቴናዬ ሽባ ሆኖ እጅግ እየተሣቀየ በቤት ተኝቶአል ብሎ ለመነው። ");
INSERT INTO amh_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ኢየሱስም። እኔ መጥቼ እፈውሰዋለሁ አለው። ");
INSERT INTO amh_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","የመቶ አለቃውም መልሶ። ጌታ ሆይ፥ በቤቴ ጣራ ከታች ልትገባ አይገባኝም፤ ነገር ግን ቃል ብቻ ተናገር፥ ብላቴናዬም ይፈወሳል። ");
INSERT INTO amh_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","እኔ ደግሞ ለሌሎች ተገዥ ነኝና፥ ከእኔም በታች ጭፍራ አለኝ፤ አንዱንም። ሂድ ብለው ይሄዳል፥ ሌላውንም። ና ብለው ይመጣል፥ ባሪያዬንም። ይህን አድርግ ብለው ያደርጋል አለው። ");
INSERT INTO amh_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ኢየሱስም ሰምቶ ተደነቀና ለተከተሉት እንዲህ አለ። እውነት እላችኋለሁ፥ በእስራኤል እንኳ እንዲህ ያለ ትልቅ እምነት አላገኘሁም። ");
INSERT INTO amh_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","እላችኋለሁም፥ ብዙዎች ከምሥራቅና ከምዕራብ ይመጣሉ ከአብርሃምና ከይስሐቅ ከያዕቆብም ጋር በመንግሥተ ሰማያት ይቀመጣሉ፤ ");
INSERT INTO amh_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","የመንግሥት ልጆች ግን በውጭ ወደ አለው ጨለማ ይጣላሉ፤ በዚያ ልቅሶና ጥርስ ማፋጨት ይሆናል። ");
INSERT INTO amh_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ኢየሱስም ለመቶ አለቃ። ሂድና እንዳመንህ ይሁንልህ አለው። ብላቴናውም በዚያች ሰዓት ተፈወሰ። ");
INSERT INTO amh_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ኢየሱስም ወደ ጴጥሮስ ቤት ገብቶ አማቱን በንዳድ ታማ ተኝታ አያት፤ ");
INSERT INTO amh_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","እጅዋንም ዳሰሰ፥ ንዳዱም ለቀቃት፤ ተነሥታም አገለገለቻቸው። ");
INSERT INTO amh_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","18","ኢየሱስም ብዙ ሰዎች ሲከቡት አይቶ ወደ ማዶ እንዲሻገሩ አዘዘ። ");
INSERT INTO amh_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","አንድ ጻፊም ቀርቦ። መምህር ሆይ፥ ወደምትሄድበት ሁሉ እከተልሃለሁ አለው። ");
INSERT INTO amh_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ኢየሱስም። ለቀበሮዎች ጉድጓድ ለሰማይም ወፎች መሳፈሪያ አላቸው፥ ለሰው ልጅ ግን ራሱን የሚያስጠጋበት የለውም አለው። ");
INSERT INTO amh_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ከደቀ መዛሙርቱም ሌላው። ጌታ ሆይ፥ አስቀድሜ እንድሄድ አባቴን እንድቀብር ፍቀድልኝ አለው። ");
INSERT INTO amh_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ኢየሱስም። ተከተለኝ፥ ሙታናቸውንም እንዲቀብሩ ሙታንን ተዋቸው አለው። ");
INSERT INTO amh_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ወደ ታንኳም ሲገባ ደቀ መዛሙርቱ ተከተሉት። ");
INSERT INTO amh_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","እነሆም፥ ማዕበሉ ታንኳይቱን እስኪደፍናት ድረስ በባሕር ታላቅ መናወጥ ሆነ፤ እርሱ ግን ተኝቶ ነበር። ");
INSERT INTO amh_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ደቀ መዛሙርቱም ቀርበው። ጌታ ሆይ፥ አድነን፥ ጠፋን እያሉ አስነሡት። ");
INSERT INTO amh_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","እርሱም። እናንተ እምነት የጎደላችሁ፥ ስለ ምን ትፈራላችሁ? አላቸው፤ ከዚህ በኋላ ተነሥቶ ነፋሱንና ባሕሩን ገሠጸ፥ ታላቅ ጸጥታም ሆነ። ");
INSERT INTO amh_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ሰዎቹም። ነፋሳትና ባሕርስ ስንኳ የሚታዘዙለት፥ ይህ እንዴት ያለ ሰው ነው? እያሉ ተደነቁ። ");
INSERT INTO amh_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ወደ ማዶም ወደ ጌርጋሴኖን አገር በመጣ ጊዜ፥ አጋንንት ያደሩባቸው ሁለት ሰዎች ከመቃብር ወጥተው ተገናኙት፤ እነርሱም ሰው በዚያ መንገድ ማለፍ እስኪሳነው ድረስ እጅግ ክፉዎች ነበሩ። ");
INSERT INTO amh_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","እነሆም። ኢየሱስ ሆይ፥ የእግዚአብሔር ልጅ፥ ከአንተ ጋር ምን አለን? ጊዜው ሳይደርስ ልትሣቅየን ወደዚህ መጣህን? እያሉ ጮኹ። ");
INSERT INTO amh_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ከእነርሱም ርቆ የብዙ እሪያ መንጋ ይሰማራ ነበር። ");
INSERT INTO amh_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","አጋንንቱም። ታወጣንስ እንደሆንህ፥ ወደ እሪያው መንጋ ስደደን ብለው ለመኑት። ሂዱ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","እነርሱም ወጥተው ወደ እሪያዎቹ ሄዱና ገቡ፤ እነሆም፥ የእሪያዎቹ መንጋ ሁሉ ከአፋፉ ወደ ባሕር እየተጣደፉ ሮጡ በውኃም ውስጥ ሞቱ። ");
INSERT INTO amh_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","እረኞችም ሸሹ፥ ወደ ከተማይቱም ሄደው ነገሩን ሁሉ አጋንንትም በአደሩባቸው የሆነውን አወሩ። ");
INSERT INTO amh_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","እነሆም፥ ከተማው ሁሉ ኢየሱስን ሊገናኝ ወጣ፥ ባዩትም ጊዜ ከአገራቸው እንዲሄድላቸው ለመኑት። ");
INSERT INTO amh_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","በታንኳም ገብቶ ተሻገረና ወደ ገዛ ከተማው መጣ። ");
INSERT INTO amh_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","እነሆም፥ በአልጋ የተኛ ሽባ ወደ እርሱ አመጡ። ኢየሱስም እምነታቸውን አይቶ ሽባውን። አንተ ልጅ፥ አይዞህ፥ ኃጢአትህ ተሰረየችልህ አለው። ");
INSERT INTO amh_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","እነሆም፥ ከጻፎቹ አንዳንዱ በልባቸው። ይህስ ይሳደባል አሉ። ");
INSERT INTO amh_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ኢየሱስም አሳባቸውን አውቆ እንዲህ አለ። ስለ ምን በልባችሁ ክፉ ታስባላችሁ? ");
INSERT INTO amh_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ኃጢአትህ ተሰረየችልህ ከማለት ወይስ። ተነሣና ሂድ ከማለት ማናቸው ይቀላል? ");
INSERT INTO amh_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ነገር ግን በምድር ላይ ኃጢአትን ያስተሰርይ ዘንድ ለሰው ልጅ ሥልጣን እንዳለው እንድታውቁ፥ በዚያን ጊዜ ሽባውን። ተነሣ፤ አልጋህን ተሸከምና ወደ ቤትህ ሂድ አለው። ");
INSERT INTO amh_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ተነሥቶም ወደ ቤቱ ሄደ። ");
INSERT INTO amh_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ሕዝቡም አይተው ተደነቁ፥ ለሰውም እንዲህ ያለ ሥልጣን የሰጠ እግዚአብሔርን አከበሩ። ");
INSERT INTO amh_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ኢየሱስም ከዚያ አልፎ በመቅረጫው ተቀምጦ የነበረ ማቴዎስ የሚባል አንድ ሰው አየና። ተከተለኝ አለው። ተነሥቶም ተከተለው። ");
INSERT INTO amh_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","በቤቱም በማዕድ ተቀምጦ ሳለ፥ እነሆ፥ ብዙ ቀራጮችና ኃጢአተኞች መጥተው ከኢየሱስና ከደቀ መዛሙርቱ ጋር አብረው ተቀመጡ። ");
INSERT INTO amh_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ፈሪሳውያንም አይተው ደቀ መዛሙርቱን። መምህራችሁ ከቀራጮችና ከኃጢአተኞች ጋር አብሮ ስለ ምን ይበላል? አሉአቸው። ");
INSERT INTO amh_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ኢየሱስም ሰምቶ። ሕመምተኞች እንጂ ባለ ጤናዎች ባለ መድኃኒት አያስፈልጋቸውም፤ ");
INSERT INTO amh_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ነገር ግን ሄዳችሁ። ምሕረትን እወዳለሁ መሥዋዕትንም አይደለም ያለው ምን እንደ ሆነ ተማሩ፤ ኃጢአተኞችን ወደ ንስሐ እንጂ ጻድቃንን ልጠራ አልመጣሁምና አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","በዚያን ጊዜ የዮሐንስ ደቀ መዛሙርት ወደ እርሱ ቀርበው። እኛና ፈሪሳውያን፥ ብዙ ጊዜ የምንጦመው፥ ደቀ መዛሙርትህ ግን የማይጦሙት ስለ ምንድር ነው? አሉት። ");
INSERT INTO amh_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ኢየሱስም እንዲህ አላቸው። ሚዜዎች ሙሽራው ከእነርሱ ጋር ሳለ ሊያዝኑ ይችላሉን? ነገር ግን ሙሽራው ከእነርሱ የሚወሰድበት ወራት ይመጣል፥ በዚያ ጊዜም ይጦማሉ። ");
INSERT INTO amh_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","በአረጀ ልብስ አዲስ እራፊ የሚያኖር የለም፤ መጣፊያው ልብሱን ይቦጭቀዋልና፥ መቀደዱም የባሰ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","በአረጀ አቁማዳ አዲስ የወይን ጠጅ የሚያኖር የለም፤ ቢደረግ ግን፥ አቁማዳው ይፈነዳል፥ የወይን ጠጁም ይፈሳል አቁማዳውም ይጠፋል፤ ነገር ግን አዲሱን የወይን ጠጅ በአዲስ አቁማዳ ያኖረዋል፥ ሁለቱም ይጠባበቃሉ። ");
INSERT INTO amh_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ይህንም ሲነግራቸው፥ አንድ መኰንን መጥቶ። ልጄ አሁን ሞተች፤ ነገር ግን መጥተህ እጅህን ጫንባት፥ በሕይወትም ትኖራለች እያለ ሰገደለት። ");
INSERT INTO amh_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ኢየሱስም ተነሥቶ ከደቀ መዛሙርቱ ጋር ተከተለው። ");
INSERT INTO amh_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","እነሆም፥ ከአሥራ ሁለት ዓመት ጀምሮ ደም የሚፈስሳት ሴት በኋላው ቀርባ የልብሱን ጫፍ ዳሰሰች፤ ");
INSERT INTO amh_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","በልብዋ። ልብሱን ብቻ የዳሰስሁ እንደ ሆነ፥ እድናለሁ ትል ነበረችና። ");
INSERT INTO amh_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ኢየሱስም ዘወር ብሎ አያትና። ልጄ ሆይ፥ አይዞሽ፤ እምነትሽ አድኖሻል አላት። ሴቲቱም ከዚያች ሰዓት ጀምራ ዳነች። ");
INSERT INTO amh_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ኢየሱስም ወደ መኰንኑ ቤት በደረሰ ጊዜ፥ እምቢልተኞችንና የሚንጫጫውን ሕዝብ አይቶ። ");
INSERT INTO amh_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ብላቴናይቱ ተኝታለች እንጂ አልሞተችምና ፈቀቅ በሉ አላቸው። በጣምም ሳቁበት። ");
INSERT INTO amh_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ሕዝቡን ግን ከአስወጡ በኋላ ገብቶ እጅዋን ያዛት፥ ብላቴናይቱም ተነሣች። ");
INSERT INTO amh_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ያም ዝና ወደዚያ አገር ሁሉ ወጣ። ");
INSERT INTO amh_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ኢየሱስም ከዚያ ሲያልፍ ሁለት ዕውሮች። የዳዊት ልጅ ሆይ፥ ማረን ብለው እየጮሁ ተከተሉት። ");
INSERT INTO amh_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ወደ ቤትም በገባ ጊዜ ዕውሮቹ ወደ እርሱ ቀረቡ፥ ኢየሱስም። ይህን ማድረግ እንድችል ታምናላችሁን? አላቸው። አዎን፥ ጌታ ሆይ አሉት። ");
INSERT INTO amh_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","በዚያን ጊዜ። እንደ እምነታችሁ ይሁንላችሁ ብሎ ዓይኖቻቸውን ዳሰሰ። ");
INSERT INTO amh_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ዓይኖቻቸውም ተከፈቱ። ");
INSERT INTO amh_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ኢየሱስም። ማንም እንዳያውቅ ተጠንቀቁ ብሎ በብርቱ አዘዛቸው። እነርሱ ግን ወጥተው በዚያ አገር ሁሉ ስለ እርሱ አወሩ። ");
INSERT INTO amh_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","እነርሱም ሲወጡ እነሆ፥ ጋኔን ያደረበትን ዲዳ ሰው ወደ እርሱ አመጡ። ");
INSERT INTO amh_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ጋኔኑንም ካወጣው በኋላ ዲዳው ተናገረ። ሕዝቡም። እንዲህ ያለ በእስራኤል ዘንድ ከቶ አልታየም እያሉ ተደነቁ። ");
INSERT INTO amh_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ፈሪሳውያን ግን። በአጋንንት አለቃ አጋንንትን ያወጣል አሉ። ");
INSERT INTO amh_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ኢየሱስም በምኩራቦቻቸው እያስተማረ፥ የመንግሥትንም ወንጌል እየሰበከ፥ በሕዝብም ያለውን ደዌና ሕማም ሁሉ እየፈወሰ፥ በከተማዎችና በመንደሮች ሁሉ ይዞር ነበር። ");
INSERT INTO amh_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ብዙ ሕዝብም ባየ ጊዜ፥ እረኛ እንደ ሌላቸው በጎች ተጨንቀው ተጥለውም ነበርና አዘነላቸው። ");
INSERT INTO amh_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","በዚያን ጊዜ ደቀ መዛሙርቱን። መከሩስ ብዙ ነው፥ ሠራተኞች ግን ጥቂቶች ናቸው፤ ");
INSERT INTO amh_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","እንግዲህ የመከሩን ጌታ ወደ መከሩ ሠራተኞች እንዲልክ ለምኑት አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","አሥራ ሁለቱን ደቀ መዛሙርቱን ወደ እርሱ ጠርቶ፥ እንዲያወጡአቸው በርኩሳን መናፍስት ላይ ደዌንና ሕማምንም ሁሉ እንዲፈውሱ ሥልጣን ሰጣቸው። ");
INSERT INTO amh_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","የአሥራ ሁለቱም ሐዋርያት ስም ይህ ነው፤ መጀመሪያው ጴጥሮስ የተባለው ስምዖን ወንድሙ እንድርያስም፥ የዘብዴዎስ ልጅ ያዕቆብም ወንድሙ ዮሐንስም፥ ");
INSERT INTO amh_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ፊልጶስም በርተሎሜዎስም፥ ቶማስም ቀራጩ ማቴዎስም፥ የእልፍዮስ ልጅ ያዕቆብም ታዴዎስም የተባለው ልብድዮስ፥ ");
INSERT INTO amh_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ቀነናዊውም ስምዖን ደግሞም አሳልፎ የሰጠው የአስቆሮቱ ይሁዳ። ");
INSERT INTO amh_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","እነዚህን አሥራ ሁለቱን ኢየሱስ ላካቸው፥ አዘዛቸውም፥ እንዲህም አለ። በአሕዛብ መንገድ አትሂዱ፥ ወደ ሳምራውያንም ከተማ አትግቡ፤ ");
INSERT INTO amh_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ይልቅስ የእስራኤል ቤት ወደሚሆኑ ወደ ጠፉት በጎች ሂዱ እንጂ። ");
INSERT INTO amh_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ሄዳችሁም። መንግሥተ ሰማያት ቀርባለች ብላችሁ ስበኩ። ");
INSERT INTO amh_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ድውዮችን ፈውሱ፤ ሙታንን አስነሡ፤ ለምጻሞችን አንጹ፤ አጋንንትን አውጡ፤ በከንቱ ተቀበላችሁ፥ በከንቱ ስጡ። ");
INSERT INTO amh_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ወርቅ ወይም ብር ወይም ናስ በመቀነታችሁ፥ ");
INSERT INTO amh_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ወይም ለመንገድ ከረጢት ወይም ሁለት እጀ ጠባብ ወይም ጫማ ወይም በትር አታግኙ፤ ለሠራተኛ ምግቡ ይገባዋልና። ");
INSERT INTO amh_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","በምትገቡባትም በማናቸይቱም ከተማ ወይም መንደር፥ በዚያ የሚገባው ማን እንደ ሆነ በጥንቃቄ መርምሩ፤ እስክትወጡም ድረስ በዚያ ተቀመጡ። ");
INSERT INTO amh_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ወደ ቤትም ስትገቡ ሰላምታ ስጡ፤ ");
INSERT INTO amh_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ቤቱም የሚገባው ቢሆን ሰላማችሁ ይድረስለት፤ ባይገባው ግን ሰላማችሁ ይመለስላችሁ። ");
INSERT INTO amh_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ከማይቀበላችሁም ቃላችሁንም ከማይሰሙ ሁሉ፥ ከዚያ ቤት ወይም ከዚያች ከተማ ስትወጡ የእግራችሁን ትቢያ አራግፉ። ");
INSERT INTO amh_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","እውነት እላችኋለሁ፥ በፍርድ ቀን ከዚያች ከተማ ይልቅ ለሰዶምና ለገሞራ አገር ይቀልላቸዋል። ");
INSERT INTO amh_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","እነሆ፥ እኔ እንደ በጎች በተኵላዎች መካከል እልካችኋለሁ፤ ስለዚህ እንደ እባብ ልባሞች እንደ ርግብም የዋሆች ሁኑ። ");
INSERT INTO amh_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ነገር ግን ወደ ሸንጎ አሳልፈው ይሰጡአችኋል፥ በምኩራቦቻቸውም ይገርፉአችኋልና ከሰዎች ተጠበቁ፤ ");
INSERT INTO amh_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ለእነርሱና ለአሕዛብም ምስክር እንዲሆን፥ ስለ እኔ ወደ ገዥዎች ወደ ነገሥታትም ትወሰዳላችሁ። ");
INSERT INTO amh_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","አሳልፈውም ሲሰጡአችሁ፥ የምትናገሩት በዚያች ሰዓት ይሰጣችኋልና እንዴት ወይስ ምን እንድትናገሩ አትጨነቁ፤ ");
INSERT INTO amh_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","በእናንተ የሚናገር የአባታችሁ መንፈስ ነው እንጂ፥ የምትናገሩ እናንተ አይደላችሁምና። ");
INSERT INTO amh_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","ወንድምም ወንድሙን፥ አባትም ልጁን ለሞት አሳልፎ ይሰጣል፥ ልጆችም በወላጆቻቸው ላይ ይነሣሉ ይገድሉአቸውማል። ");
INSERT INTO amh_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","በሁሉም ስለ ስሜ የተጠላችሁ ትሆናላችሁ፤ እስከ መጨረሻ የሚጸና ግን እርሱ ይድናል። ");
INSERT INTO amh_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","በአንዲቱ ከተማም መከራ ቢያሳዩአችሁ ወደ ሌላይቱ ሽሹ፤ እውነት እላችኋለሁና፥ የሰው ልጅ እስኪመጣ ድረስ የእስራኤልን ከተማዎች አትዘልቁም። ");
INSERT INTO amh_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ደቀ መዝሙር ከመምህሩ፥ ባሪያም ከጌታው አይበልጥም። ");
INSERT INTO amh_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ደቀ መዝሙር እንደ መምህሩ፥ ባሪያም እንደ ጌታው መሆኑ ይበቃዋል። ባለቤቱን ብዔል ዜቡል ካሉት፥ ቤተሰዎቹንማ እንዴት አብዝተው አይሉአቸው! ");
INSERT INTO amh_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","እንግዲህ አትፍሩአቸው፤ የማይገለጥ የተከደነ፥ የማይታወቅም የተሰወረ ምንም የለምና። ");
INSERT INTO amh_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","በጨለማ የምነግራችሁን በብርሃን ተናገሩ፤ በጆሮም የምትሰሙትን በሰገነት ላይ ስበኩ። ");
INSERT INTO amh_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ሥጋንም የሚገድሉትን ነፍስን ግን መግደል የማይቻላቸውን አትፍሩ፤ ይልቅስ ነፍስንም ሥጋንም በገሃነም ሊያጠፋ የሚቻለውን ፍሩ። ");
INSERT INTO amh_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ሁለት ድንቢጦች በአምስት ሳንቲም ይሸጡ የለምን? ከእነርሱም አንዲቱ ያለ አባታችሁ ፈቃድ በምድር ላይ አትወድቅም። ");
INSERT INTO amh_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","የእናንተስ የራሳችሁ ጠጉር ሁሉ እንኳ ተቈጥሮአል። ");
INSERT INTO amh_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","እንግዲህ አትፍሩ ከብዙ ድንቢጦች እናንተ ትበልጣላችሁ። ");
INSERT INTO amh_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","ስለዚህ በሰው ፊት ለሚመሰክርልኝ ሁሉ እኔ ደግሞ በሰማያት ባለው በአባቴ ፊት እመሰክርለታለሁ፤ ");
INSERT INTO amh_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","በሰው ፊትም የሚክደኝን ሁሉ እኔ ደግሞ በሰማያት ባለው በአባቴ ፊት እክደዋለሁ። ");
INSERT INTO amh_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","በምድር ላይ ሰላምን ለማምጣት የመጣሁ አይምሰላችሁ፤ ሰይፍን እንጂ ሰላምን ለማምጣት አልመጣሁም። ");
INSERT INTO amh_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ሰውን ከአባቱ፥ ሴት ልጅንም ከእናትዋ፥ ምራትንም ከአማትዋ እለያይ ዘንድ መጥቻለሁና፤ ");
INSERT INTO amh_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ለሰውም ቤተ ሰዎቹ ጠላቶች ይሆኑበታል። ");
INSERT INTO amh_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ከእኔ ይልቅ አባቱን ወይም እናቱን የሚወድ ለእኔ ሊሆን አይገባውም፤ ከእኔ ይልቅም ወንድ ልጁን ወይም ሴት ልጁን የሚወድ ለእኔ ሊሆን አይገባውም፤ ");
INSERT INTO amh_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","መስቀሉንም የማይዝ በኋላዬም የማይከተለኝ ለእኔ ሊሆን አይገባውም። ");
INSERT INTO amh_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ነፍሱን የሚያገኝ ያጠፋታል፥ ነፍሱንም ስለ እኔ የሚያጠፋ ያገኛታል። ");
INSERT INTO amh_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","እናንተን የሚቀበል እኔን ይቀበላል፥ እኔንም የሚቀበል የላከኝን ይቀበላል። ");
INSERT INTO amh_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ነቢይን በነቢይ ስም የሚቀበል የነቢይን ዋጋ ይወስዳል፥ ጻድቅንም በጻድቅ ስም የሚቀበል የጻድቁን ዋጋ ይወስዳል። ");
INSERT INTO amh_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ማንም ከእነዚህ ከታናናሾቹ ለአንዱ ቀዝቃዛ ጽዋ ውኃ ብቻ በደቀ መዝሙር ስም የሚያጠጣ፥ እውነት እላችኋለሁ፥ ዋጋው አይጠፋበትም። ");
INSERT INTO amh_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ኢየሱስም አሥራ ሁለቱን ደቀ መዛሙርቱን ማዘዝ በፈጸመ ጊዜ በከተሞቻቸው ሊያስተምርና ሊሰብክ ከዚያ አለፈ። ");
INSERT INTO amh_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ዮሐንስም በወህኒ ሳለ የክርስቶስን ሥራ ሰምቶ ከደቀ መዛሙርቱ ሁለት ላከና። ");
INSERT INTO amh_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","የሚመጣው አንተ ነህን? ወይስ ሌላ እንጠብቅ? አለው። ");
INSERT INTO amh_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ኢየሱስም መልሶ እንዲህ አላቸው። ሄዳችሁ ያያችሁትን የሰማችሁትንም ለዮሐንስ አውሩለት፤ ");
INSERT INTO amh_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ዕውሮች ያያሉ አንካሶችም ይሄዳሉ፥ ለምጻሞችም ይነጻሉ ደንቆሮችም ይሰማሉ፥ ሙታንም ይነሣሉ ");
INSERT INTO amh_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ለድሆችም ወንጌል ይሰበካል፤ በእኔም የማይሰናከለው ሁሉ ብፁዕ ነው። ");
INSERT INTO amh_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","እነዚያም ሲሄዱ ኢየሱስ ለሕዝቡ ስለ ዮሐንስ ሊናገር ጀመረ እንዲህም አለ። ምን ልታዩ ወደ ምድረ በዳ ወጣችሁ? ");
INSERT INTO amh_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ነፋስ የሚወዘውዘውን ሸምበቆን? ወይስ ምን ልታዩ ወጣችሁ? ቀጭን ልብስ የለበሰ ሰውን? እነሆ፥ ቀጭን ልብስ የለበሱ በነገሥታት ቤት አሉ። ");
INSERT INTO amh_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ወይስ ምን ልታዩ ወጣችሁ? ነቢይን? አዎን እላችኋለሁ፥ ከነቢይም የሚበልጠውን። ");
INSERT INTO amh_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","እነሆ፥ መንገድህን በፊትህ የሚጠርግ መልክተኛዬን በፊትህ እልካለሁ ");
INSERT INTO amh_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ተብሎ የተጻፈለት ይህ ነውና። እውነት እላችኋለሁ፥ ከሴቶች ከተወለዱት መካከል ከመጥምቁ ዮሐንስ የሚበልጥ አልተነሣም፤ በመንግሥተ ሰማያት ግን ከሁሉ የሚያንሰው ይበልጠዋል። ");
INSERT INTO amh_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ከመጥምቁም ከዮሐንስ ዘመን ጀምሮ እስከ ዛሬ ድረስ መንግሥተ ሰማያት ትገፋለች፥ ግፈኞችም ይናጠቋታል። ");
INSERT INTO amh_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ነቢያት ሁሉና ሕጉ እስከ ዮሐንስ ድረስ ትንቢት ተናገሩ፤ ");
INSERT INTO amh_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ልትቀበሉትስ ብትወዱ፥ ይመጣ ዘንድ ያለው ኤልያስ ይህ ነው። ");
INSERT INTO amh_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","የሚሰማ ጆሮ ያለው ይስማ። ");
INSERT INTO amh_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ነገር ግን ይህን ትውልድ በምን እመስለዋለሁ? በገበያ የሚቀመጡትን ልጆች ይመስላሉ፥ እነርሱም ባልንጀሮቻቸውን እየጠሩ። ");
INSERT INTO amh_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","እንቢልታ ነፋንላችሁ ዘፈንም አልዘፈናችሁም ሙሾ አወጣንላችሁ ዋይ ዋይም አላላችሁም ይሉአቸዋል። ");
INSERT INTO amh_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ዮሐንስ ሳይበላና ሳይጠጣ መጣ፥ እነርሱም። ጋኔን አለበት አሉት። ");
INSERT INTO amh_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","የሰው ልጅ እየበላና እየጠጣ መጣ፥ እነርሱም። እነሆ፥ በላተኛና የወይን ጠጅ ጠጭ፥ የቀራጮችና የኃጢአተኞች ወዳጅ ይሉታል። ጥበብም በልጆችዋ ጸደቀች። ");
INSERT INTO amh_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","በዚያን ጊዜ የሚበዙ ተአምራት የተደረገባቸውን ከተማዎች ንስሐ ስላልገቡ ሊነቅፋቸው ጀመረ እንዲህም አለ። ");
INSERT INTO amh_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ወዮልሽ ኮራዚ፤ ወዮልሽ ቤተ ሳይዳ፤ በእናንተ የተደረገው ተአምራት በጢሮስና በሲዶና ተደርጎ ቢሆን፥ ማቅ ለብሰው አመድም ነስንሰው ከብዙ ጊዜ በፊት ንስሐ በገቡ ነበርና። ");
INSERT INTO amh_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ነገር ግን እላችኋለሁ፥ በፍርድ ቀን ከእናንተ ይልቅ ለጢሮስና ለሲዶና ይቀልላቸዋል። ");
INSERT INTO amh_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","አንቺም ቅፍርናሆም፥ እስከ ሰማይ ከፍ አልሽን? ወደ ሲኦል ትወርጃለሽ፤ በአንቺ የተደረገው ተአምራት በሰዶም ተደርጎ ቢሆን፥ እስከ ዛሬ በኖረች ነበርና። ");
INSERT INTO amh_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ነገር ግን እላችኋለሁ፥ በፍርድ ቀን ከአንቺ ይልቅ ለሰዶም አገር ይቀልላታል። ");
INSERT INTO amh_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","በዚያን ጊዜ ኢየሱስ መልሶ እንዲህ አለ። አባት ሆይ፥ የሰማይና የምድር ጌታ፥ ይህን ከጥበበኞችና ከአስተዋዮች ሰውረህ ለሕፃናት ስለ ገለጥህላቸው አመሰግንሃለሁ፤ ");
INSERT INTO amh_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","አዎን፥ አባት ሆይ፥ ፈቃድህ በፊትህ እንዲህ ሆኖአልና። ");
INSERT INTO amh_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ሁሉ ከአባቴ ዘንድ ተሰጥቶኛል፤ ከአብ በቀር ወልድን የሚያውቅ የለም፥ ከወልድም በቀር ወልድም ሊገለጥለት ከሚፈቅድ በቀር አብን የሚያውቅ የለም። ");
INSERT INTO amh_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","እናንተ ደካሞች ሸክማችሁ የከበደ ሁሉ፥ ወደ እኔ ኑ፥ እኔም አሳርፋችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ቀንበሬን በላያችሁ ተሸከሙ ከእኔም ተማሩ፥ እኔ የዋህ በልቤም ትሑት ነኝና፥ ለነፍሳችሁም ዕረፍት ታገኛላችሁ፤ ");
INSERT INTO amh_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ቀንበሬ ልዝብ ሸክሜም ቀሊል ነውና። ");
INSERT INTO amh_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","በዚያን ጊዜ ኢየሱስ በሰንበት ቀን በእርሻ መካከል አለፈ፤ ደቀ መዛሙርቱም ተራቡና እሸት ይቀጥፉ ይበሉም ጀመር። ");
INSERT INTO amh_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ፈሪሳውያንም አይተው። እነሆ፥ ደቀ መዛሙርትህ በሰንበት ማድረግ ያልተፈቀደውን ያደርጋሉ አሉት። ");
INSERT INTO amh_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","5","ካህናትም በሰንበት በመቅደስ ሰንበትን እንዲያረክሱ ኃጢአትም እንዳይሆንባቸው በሕጉ አላነበባችሁምን? ");
INSERT INTO amh_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ነገር ግን እላችኋለሁ፥ ከመቅደስ የሚበልጥ ከዚህ አለ። ");
INSERT INTO amh_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ምሕረትን እወዳለሁ መሥዋዕትንም አይደለም ያለው ምን እንደሆነ ብታውቁስ ኃጢአት የሌለባቸውን ባልኰነናችሁም ነበር። ");
INSERT INTO amh_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","የሰው ልጅ የሰንበት ጌታ ነውና። ");
INSERT INTO amh_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ከዚያም አልፎ ወደ ምኩራባቸው ገባ። ");
INSERT INTO amh_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","እነሆም፥ እጁ የሰለለች ሰው ነበረ፤ ይከሱትም ዘንድ። በሰንበት መፈወስ ተፈቅዶአልን? ብለው ጠየቁት። ");
INSERT INTO amh_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","እርሱ ግን። ከእናንተ አንድ በግ ያለው በሰንበት በጉድጓድ ቢወድቅበት፥ ይዞ የማያወጣው ሰው ማን ነው? ");
INSERT INTO amh_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","እንግዲህ ሰው ከበግ ይልቅ እንደምን አይበልጥም! ስለዚህ በሰንበት መልካም መሥራት ተፈቅዶአል አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ከዚያም በኋላ ሰውየውን። እጅህን ዘርጋ አለው። ዘረጋትም፥ እንደ ሁለተኛይቱም ደህና ሆነች። ");
INSERT INTO amh_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ፈሪሳውያን ግን ወጥተው እንዴት አድርገው እንዲያጠፉት ተማከሩበት። ");
INSERT INTO amh_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ኢየሱስም አውቆ ከዚያ ፈቀቅ አለ። ብዙ ሰዎችም ተከተሉት፥ ሁሉንም ፈወሳቸው፥ እንዳይገልጡትም አዘዛቸው፤ ");
INSERT INTO amh_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","18","እነሆ የመረጥሁት ብላቴናዬ፥ ነፍሴ ደስ የተሰኘችበት ወዳጄ፤ መንፈሴን በእርሱ ላይ አኖራለሁ፥ ፍርድንም ለአሕዛብ ያወራል። ");
INSERT INTO amh_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","አይከራከርም አይጮህምም፥ ድምፁንም በአደባባይ የሚሰማ የለም። ");
INSERT INTO amh_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ፍርድን ድል ለመንሣት እስኪያወጣ፥ የተቀጠቀጠን ሸምበቆ አይሰብርም የሚጤስን የጥዋፍ ክርም አያጠፋም። ");
INSERT INTO amh_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","አሕዛብም በስሙ ተስፋ ያደርጋሉ። ");
INSERT INTO amh_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ከዚህም በኋላ ጋኔን ያደረበትን ዕውር ዲዳም ወደ እርሱ አመጡ፤ ዕውሩም ዲዳውም እስኪያይና እስኪናገር ድረስ ፈወሰው። ");
INSERT INTO amh_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ሕዝቡም ሁሉ ተገረሙና። እንጃ ይህ ሰው የዳዊት ልጅ ይሆንን? አሉ። ");
INSERT INTO amh_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ፈሪሳውያን ግን ሰምተው። ይህ በብዔል ዜቡል በአጋንንት አለቃ ካልሆነ በቀር አጋንንትን አያወጣም አሉ። ");
INSERT INTO amh_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ኢየሱስ ግን አሳባቸውን አውቆ እንዲህ አላቸው። እርስ በርስዋ የምትለያይ መንግሥት ሁላ ትጠፋለች፥ እርስ በርሱ የሚለያይ ከተማም ሁሉ ወይም ቤት አይቆምም። ");
INSERT INTO amh_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ሰይጣንም ሰይጣንን የሚያወጣ ከሆነ፥ እርስ በርሱ ተለያየ፥ እንግዲህ መንግሥቱ እንዴት ትቆማለች? ");
INSERT INTO amh_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","እኔስ በብዔል ዜቡል አጋንንትን የማወጣ ከሆንሁ፥ ልጆቻችሁ በማን ያወጡአቸዋል? ስለዚህ እነርሱ ፈራጆች ይሆኑባችኋል። ");
INSERT INTO amh_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","እኔ ግን በእግዚአብሔር መንፈስ አጋንንትን የማወጣ ከሆንሁ፥ እንግዲህ የእግዚአብሔር መንግሥት ወደ እናንተ ደርሳለች። ");
INSERT INTO amh_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ወይስ ሰው አስቀድሞ ኃይለኛውን ሳያስር ወደ ኃይለኛው ቤት ገብቶ እቃውን ሊነጥቀው እንዴት ይችላል? ከዚያም ወዲያ ቤቱን ይበዘብዛል። ");
INSERT INTO amh_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ከእኔ ጋር ያልሆነ ይቃወመኛል፥ ከእኔ ጋርም የማያከማች ይበትናል። ");
INSERT INTO amh_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ስለዚህ እላችኋለሁ፥ ኃጢአትና ስድብ ሁሉ ለሰዎች ይሰረይላቸዋል፥ ነገር ግን መንፈስ ቅዱስን ለሰደበ አይሰረይለትም። ");
INSERT INTO amh_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","በሰው ልጅ ላይ ቃል የሚናገር ሁሉ ይሰረይለታል፤ በመንፈስ ቅዱስ ላይ ግን የሚናገር ሁሉ በዚህ ዓለም ቢሆን ወይም በሚመጣው አይሰረይለትም። ");
INSERT INTO amh_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","ዛፍ ከፍሬዋ ትታወቃለችና ዛፍዋን መልካም፥ ፍሬዋንም መልካም አድርጉ፥ ወይም ዛፍዋን ክፉ ፍሬዋንም ክፉ አድርጉ። ");
INSERT INTO amh_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","እናንተ የእፉኝት ልጆች፥ ክፉዎች ስትሆኑ መልካም ለመናገር እንዴት ትችላላችሁ? በልብ ሞልቶ ከተረፈው አፍ ይናገራልና። ");
INSERT INTO amh_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","መልካም ሰው ከልቡ መልካም መዝገብ መልካም ነገርን ያወጣል፥ ክፉ ሰውም ከክፉ መዝገብ ክፉ ነገርን ያወጣል። ");
INSERT INTO amh_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","እኔ እላችኋለሁ፥ ሰዎች ስለሚናገሩት ስለ ከንቱ ነገር ሁሉ በፍርድ ቀን መልስ ይሰጡበታል፤ ");
INSERT INTO amh_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ከቃልህ የተነሣ ትጸድቃለህና ከቃልህም የተነሣ ትኰነናለህ። ");
INSERT INTO amh_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","በዚያን ጊዜ ከጻፎችና ከፈሪሳውያን አንዳንዶቹ መለሱና። መምህር ሆይ፥ ከአንተ ምልክት እንድናይ እንወዳለን አሉ። ");
INSERT INTO amh_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","እርሱ ግን መልሶ እንዲህ አላቸው። ክፉና አመንዝራ ትውልድ ምልክት ይሻል፥ ከነቢዩም ከዮናስ ምልክት በቀር ምልክት አይሰጠውም። ");
INSERT INTO amh_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ዮናስ በዓሣ አንባሪ ሆድ ሦስት ቀንና ሦስት ሌሊት እንደ ነበረ፥ እንዲሁ የሰው ልጅ በምድር ልብ ሦስት ቀንና ሦስት ሌሊት ይኖራል። ");
INSERT INTO amh_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","የነነዌ ሰዎች በፍርድ ቀን ከዚህ ትውልድ ጋር ተነሥተው ይፈርዱበታል፤ በዮናስ ስብከት ንስሐ ገብተዋልና፥ እነሆም፥ ከዮናስ የሚበልጥ ከዚህ አለ። ");
INSERT INTO amh_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ንግሥተ ዓዜብ በፍርድ ቀን ከዚህ ትውልድ ጋር ተነሥታ ትፈርድበታለች፤ የሰሎሞንን ጥበብ ለመስማት ከምድር ዳር መጥታለችና፥ እነሆም፥ ከሰሎሞን የሚበልጥ ከዚህ አለ። ");
INSERT INTO amh_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ርኩስ መንፈስ ግን ከሰው በወጣ ጊዜ፥ ዕረፍት እየፈለገ ውኃ በሌለበት ቦታ ያልፋል፥ አያገኝምም። ");
INSERT INTO amh_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","በዚያን ጊዜም። ወደ ወጣሁበት ቤቴ እመለሳለሁ ይላል፤ ቢመጣም ባዶ ሆኖ ተጠርጎና አጊጦ ያገኘዋል። ");
INSERT INTO amh_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ከዚያ ወዲያ ይሄድና ከእርሱ የከፉትን ሰባት ሌሎችን አጋንንት ከእርሱ ጋር ይወስዳል፥ ገብተውም በዚያ ይኖራሉ፤ ለዚያም ሰው ከፊተኛው ይልቅ የኋለኛው ይብስበታል። ለዚህ ክፉ ትውልድ ደግሞ እንዲሁ ይሆንበታል። ");
INSERT INTO amh_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ገናም ለሕዝቡ ሲናገር፥ እነሆ፥ እናቱና ወንድሞቹ ሊነጋገሩት ፈልገው በውጭ ቆመው ነበር። ");
INSERT INTO amh_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","አንዱም። እነሆ፥ እናትህና ወንድሞችህ ሊነጋገሩህ ፈልገው በውጭ ቆመዋል አለው። ");
INSERT INTO amh_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","እርሱ ግን ለነገረው መልሶ። እናቴ ማን ናት? ወንድሞቼስ እነማን ናቸው? አለው። ");
INSERT INTO amh_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","እጁንም ወደ ደቀ መዛሙርቱ ዘርግቶ። እነሆ እናቴና ወንድሞቼ፤ ");
INSERT INTO amh_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","በሰማያት ያለውን የአባቴን ፈቃድ የሚያደርግ ሁሉ፥ እርሱ ወንድሜ እኅቴም እናቴም ነውና አለ። ");
INSERT INTO amh_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","በዚያን ቀን ኢየሱስ ከቤት ወጥቶ በባሕር አጠገብ ተቀመጠ፤ ");
INSERT INTO amh_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","እርሱም በታንኳ ገብቶ እስኪቀመጥ ድረስ ብዙ ሰዎች ወደ እርሱ ተሰበሰቡ፥ ሕዝቡም ሁሉ በወደቡ ቆመው ነበር። ");
INSERT INTO amh_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","በምሳሌም ብዙ ነገራቸው እንዲህም አላቸው። እነሆ፥ ዘሪ ሊዘራ ወጣ። ");
INSERT INTO amh_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","እርሱም ሲዘራ አንዳንዱ በመንገድ ዳር ወደቀ፥ ወፎችም መጥተው በሉት። ");
INSERT INTO amh_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ሌላውም ብዙ መሬት በሌለበት በጭንጫ ላይ ወደቀ፤ ጥልቅ መሬትም ስላልነበረው ወዲያው በቀለ፥ ");
INSERT INTO amh_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ፀሐይ በወጣ ጊዜ ግን ጠወለገ፥ ሥርም ስላልነበረው ደረቀ። ");
INSERT INTO amh_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ሌላውም በእሾህ መካከል ወደቀ፥ እሾህም ወጣና አነቀው። ");
INSERT INTO amh_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ሌላውም በመልካም መሬት ወደቀ፤ አንዱም መቶ፥ አንዱም ስድሳ፥ አንዱም ሠላሳ ፍሬ ሰጠ። ");
INSERT INTO amh_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","የሚሰማ ጆሮ ያለው ይስማ። ");
INSERT INTO amh_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ደቀ መዛሙርቱም ቀርበው። ስለ ምን በምሳሌ ትነግራቸዋለህ? አሉት። ");
INSERT INTO amh_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","እርሱም መልሶ እንዲህ አላቸው። ለእናንተ የመንግሥተ ሰማያትን ምሥጢር ማወቅ ተሰጥቶአችኋል፥ ለእነርሱ ግን አልተሰጣቸውም። ");
INSERT INTO amh_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ላለው ይሰጠዋልና ይበዛለትማል፤ ከሌለው ግን ያው ያለው እንኳ ይወሰድበታል። ");
INSERT INTO amh_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ስለዚህ እያዩ ስለማያዩ እየሰሙም ስለማይሰሙ ስለማያስተውሉም በምሳሌ እነግራቸዋለሁ። ");
INSERT INTO amh_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","መስማት ትሰማላችሁና አታስተውሉም፥ ማየትም ታያላችሁና አትመለከቱም። ");
INSERT INTO amh_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","በዓይናቸው እንዳያዩ፥ በጆሮአቸውም እንዳይሰሙ፥ በልባቸውም እንዳያስተውሉ፥ ተመልሰውም እንዳልፈውሳቸው፥ የዚህ ሕዝብ ልብ ደንድኖአልና ጆሮአቸውም ደንቁሮአል ዓይናቸውንም ጨፍነዋል የሚል የኢሳይያስ ትንቢት በእነርሱ ይፈጸማል። ");
INSERT INTO amh_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","የእናንተ ግን ዓይኖቻችሁ ስለሚያዩ ጆሮቻችሁም ስለሚሰሙ ብፁዓን ናቸው። ");
INSERT INTO amh_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","እውነት እላችኋለሁ፥ ብዙዎች ነቢያትና ጻድቃን የምታዩትን ሊያዩ ተመኝተው አላዩም፥ የምትሰሙትንም ሊሰሙ ተመኝተው አልሰሙም። ");
INSERT INTO amh_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","እንግዲህ እናንተ የዘሪውን ምሳሌ ስሙ። ");
INSERT INTO amh_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","የመንግሥትን ቃል ሰምቶ በማያስተውል ሁሉ፥ ክፉው ይመጣል፥ በልቡ የተዘራውንም ይነጥቃል፤ በመንገድ ዳር የተዘራው ይህ ነው። ");
INSERT INTO amh_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","በጭንጫ ላይ የተዘራውም ይህ ቃሉን ሰምቶ ወዲያው በደስታ የሚቀበለው ነው፤ ");
INSERT INTO amh_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ነገር ግን ለጊዜው ነው እንጂ በእርሱ ሥር የለውም፥ በቃሉ ምክንያትም መከራ ወይም ስደት በሆነ ጊዜ ወዲያው ይሰናከላል። ");
INSERT INTO amh_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","በእሾህ መካከል የተዘራውም ይህ ቃሉን የሚሰማ ነው፥ የዚህም ዓለም አሳብና የባለጠግነት መታለል ቃሉን ያንቃል፥ የማያፈራም ይሆናል። ");
INSERT INTO amh_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","በመልካም መሬት የተዘራውም ይህ ቃሉን ሰምቶ የሚያስተውል ነው፤ እርሱም ፍሬ ያፈራል አንዱም መቶ አንዱም ስድሳ አንዱም ሠላሳ ያደርጋል። ");
INSERT INTO amh_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ሌላ ምሳሌ አቀረበላቸው እንዲህም አለ። መንግሥተ ሰማያት በእርሻው መልካም ዘርን የዘራን ሰው ትመስላለች። ");
INSERT INTO amh_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ሰዎቹ ሲተኙ ግን ጠላቱ መጣና በስንዴው መካከል እንክርዳድን ዘርቶ ሄደ። ");
INSERT INTO amh_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ስንዴውም በበቀለና በአፈራ ጊዜ እንክርዳዱ ደግሞ ያን ጊዜ ታየ። ");
INSERT INTO amh_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","የባለቤቱም ባሮች ቀርበው። ጌታ ሆይ፥ መልካምን ዘር በእርሻህ ዘርተህ አልነበርህምን? እንክርዳዱንስ ከወዴት አገኘ? አሉት። ");
INSERT INTO amh_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","እርሱም። ጠላት ይህን አደረገ አላቸው። ባሮቹም። እንግዲህ ሄደን ብንለቅመው ትወዳለህን? አሉት። ");
INSERT INTO amh_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","እርሱ ግን። እንክርዳዱን ስትለቅሙ ስንዴውን ከእርሱ ጋር እንዳትነቅሉት አይሆንም። ");
INSERT INTO amh_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ተዉአቸው፤ እስከ መከር ጊዜ አብረው ይደጉ፤ በመከር ጊዜም አጫጆችን። እንክርዳዱን አስቀድማችሁ ልቀሙ በእሳትም ለማቃጠል በየነዶው እሰሩ፥ ስንዴውን ግን በጎተራዬ ክተቱ እላለሁ አለ። ");
INSERT INTO amh_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ሌላ ምሳሌ አቀረበላቸው እንዲህም አለ። መንግሥተ ሰማያት ሰው ወስዶ በእርሻው የዘራትን የሰናፍጭ ቅንጣት ትመስላለች፤ ");
INSERT INTO amh_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","እርስዋም ከዘር ሁሉ ታንሳለች፥ በአደገች ጊዜ ግን፥ ከአታክልቶች ትበልጣለች የሰማይም ወፎች መጥተው በቅርንጫፎችዋ እስኪሰፍሩ ድረስ ዛፍ ትሆናለች። ");
INSERT INTO amh_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ሌላ ምሳሌ ነገራቸው እንዲህም አለ። መንግሥተ ሰማያት ሁሉ እስኪቦካ ድረስ ሴት ወስዳ በሦስት መስፈሪያ ዱቄት የሸሸገችውን እርሾ ትመስላለች። ");
INSERT INTO amh_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","36","በዚያን ጊዜ ሕዝቡን ትቶ ወደ ቤት ገባ። ደቀ መዛሙርቱም ወደ እርሱ ቀርበው። የእርሻውን እንክርዳድ ምሳሌ ተርጕምልን አሉት። ");
INSERT INTO amh_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","እርሱም መልሶ እንዲህ አላቸው። መልካምን ዘር የዘራው የሰው ልጅ ነው፤ እርሻውም ዓለም ነው፤ ");
INSERT INTO amh_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","መልካሙም ዘር የመንግሥት ልጆች ናቸው፤ ");
INSERT INTO amh_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","እንክርዳዱም የክፉው ልጆች ናቸው፥ የዘራውም ጠላት ዲያብሎስ ነው፤ መከሩም የዓለም መጨረሻ ነው፥ አጫጆችም መላእክት ናቸው። ");
INSERT INTO amh_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","እንግዲህ እንክርዳድ ተለቅሞ በእሳት እንደሚቃጠል፥ በዓለም መጨረሻ እንዲሁ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","የሰው ልጅ መላእክቱን ይልካል፥ ከመንግሥቱም እንቅፋትን ሁሉ ዓመፃንም የሚያደርጉትን ይለቅማሉ፥ ");
INSERT INTO amh_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ወደ እቶነ እሳትም ይጥሉአቸዋል፤ በዚያ ልቅሶና ጥርስ ማፋጨት ይሆናል። ");
INSERT INTO amh_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","በዚያን ጊዜ ጻድቃን በአባታቸው መንግሥት እንደ ፀሐይ ይበራሉ። የሚሰማ ጆሮ ያለው ይስማ። ");
INSERT INTO amh_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","ደግሞ መንግሥተ ሰማያት በእርሻ ውስጥ የተሰወረውን መዝገብ ትመስላለች፤ ሰውም አግኝቶ ሰወረው፥ ከደስታውም የተነሣ ሄዶ ያለውን ሁሉ ሸጠና ያን እርሻ ገዛ። ");
INSERT INTO amh_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ደግሞ መንግሥተ ሰማያት መልካምን ዕንቁ የሚሻ ነጋዴን ትመስላለች፤ ");
INSERT INTO amh_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ዋጋዋም እጅግ የበዛ አንዲት ዕንቁ በአገኘ ጊዜ ሄዶ ያለውን ሁሉ ሸጠና ገዛት። ");
INSERT INTO amh_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ደግሞ መንግሥተ ሰማያት ወደ ባሕር የተጣለች ከሁሉም ዓይነት የሰበሰበች መረብን ትመስላለች፤ ");
INSERT INTO amh_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","በሞላችም ጊዜ ወደ ወደቡ አወጡአት፥ ተቀምጠውም መልካሙን ለቅመው በዕቃዎች ውስጥ አከማቹ ክፉውን ግን ወደ ውጭ ጣሉት። ");
INSERT INTO amh_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","በዓለም መጨረሻ እንዲሁ ይሆናል፤ መላእክት መጥተው ኃጢአተኞችን ከጻድቃን መካከል ይለዩአቸዋል፥ ወደ እቶነ እሳትም ይጥሉአቸዋል፤ ");
INSERT INTO amh_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","በዚያ ልቅሶና ጥርስ ማፋጨት ይሆናል። ");
INSERT INTO amh_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ኢየሱስም። ይህን ሁሉ አስተዋላችሁን? አላቸው አዎን አሉት። ");
INSERT INTO amh_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","እርሱም። ስለዚህ የመንግሥተ ሰማያት ደቀ መዝሙር የሆነ ጻፊ ሁሉ ከመዝገቡ አዲሱንና አሮጌውን የሚያወጣ ባለቤትን ይመስላል አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ኢየሱስም እነዚህም ምሳሌዎች ከጨረሰ በኋላ ከዚያ ሄደ። ");
INSERT INTO amh_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ወደ ገዛ አገሩም መጥቶ እስኪገረሙ ድረስ በምኩራባቸው ያስተምራቸው ነበር፤ እንዲህም አሉ። ይህን ጥበብና ተአምራት ይህ ከወዴት አገኘው? ");
INSERT INTO amh_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ይህ የጸራቢ ልጅ አይደለምን? እናቱስ ማርያም ትባል የለምን? ወንድሞቹስ ያዕቆብና ዮሳ ስምዖንም ይሁዳም አይደሉምን? ");
INSERT INTO amh_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","እኅቶቹስ ሁሉ በእኛ ዘንድ ያሉ አይደሉምን? እንኪያስ ይህን ሁሉ ከወዴት አገኘው? ተሰናከሉበትም። ");
INSERT INTO amh_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ኢየሱስ ግን። ነቢይ ከገዛ አገሩና ከገዛ ቤቱ በቀር ሳይከበር አይቀርም አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","በአለማመናቸውም ምክንያት በዚያ ብዙ ተአምራት አላደረገም። ");
INSERT INTO amh_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","በዚያ ዘመን የአራተኛው ክፍል ገዥ ሄሮድስ የኢየሱስን ዝና ሰማ፥ ");
INSERT INTO amh_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ለሎሌዎቹም። ይህ መጥምቁ ዮሐንስ ነው፤ እርሱ ከሙታን ተነሥቶአል፥ ስለዚህም ኃይል በእርሱ ይደረጋል አለ። ");
INSERT INTO amh_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ሄሮድስ በወንድሙ በፊልጶስ ሚስት በሄሮድያዳ ምክንያት ዮሐንስን አስይዞ አሳስሮት በወህኒ አኑሮት ነበርና፤ ");
INSERT INTO amh_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ዮሐንስ። እርስዋ ለአንተ ትሆን ዘንድ አልተፈቀደም ይለው ነበርና። ");
INSERT INTO amh_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ሊገድለውም ወዶ ሳለ፥ ሕዝቡ እንደ ነቢይ ስለ አዩት ፈራቸው። ");
INSERT INTO amh_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ነገር ግን ሄሮድስ የተወለደበት ቀን በሆነ ጊዜ፥ የሄሮድያዳ ልጅ በመካከላቸው ዘፈነች ሄሮድስንም ደስ አሰኘችው፤ ");
INSERT INTO amh_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ስለዚህም የምትለምነውን ሁሉ እንዲሰጣት በመሐላ ተስፋ አደረገላት። ");
INSERT INTO amh_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","እርስዋም በእናትዋ ተመክራ። የመጥምቁን የዮሐንስን ራስ በዚህ በወጭት ስጠኝ አለችው። ");
INSERT INTO amh_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ንጉሡም አዘነ፥ ነገር ግን ስለ መሐላው ከእርሱም ጋር ተቀምጠው ስላሉት ሰዎች እንዲሰጡአት አዘዘ፤ ");
INSERT INTO amh_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ልኮም የዮሐንስን ራስ በወህኒ አስቆረጠው። ");
INSERT INTO amh_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ራሱንም በወጭት አምጥተው ለብላቴናይቱ ሰጡአት፥ ወደ እናትዋም ወሰደችው። ");
INSERT INTO amh_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ደቀ መዛሙርቱም ቀርበው በድኑን ወሰዱና ቀበሩት፥ መጥተውም ለኢየሱስ አወሩለት። ");
INSERT INTO amh_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ኢየሱስም በሰማ ጊዜ ከዚያ ብቻውን ወደ ምድረ በዳ በታንኳ ፈቀቅ አለ፤ ሕዝቡም ሰምተው ከከተማዎቹ በእግር ተከተሉት። ");
INSERT INTO amh_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ወጥቶም ብዙ ሕዝብ አየና አዘነላቸው ድውዮቻቸውንም ፈወሰ። ");
INSERT INTO amh_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","በመሸም ጊዜ ደቀ መዛሙርቱ ወደ እርሱ ቀርበው። ቦታው ምድረ በዳ ነው አሁንም ሰዓቱ አልፎአል፤ ወደ መንደሮች ሄደው ለራሳቸው ምግብ እንዲገዙ ሕዝቡን አሰናብት አሉት። ");
INSERT INTO amh_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ኢየሱስም። እናንተ የሚበሉትን ስጡአቸው እንጂ ሊሄዱ አያስፈልግም አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","እነርሱም። ከአምስት እንጀራና ከሁለት ዓሣ በቀር በዚህ የለንም አሉት። ");
INSERT INTO amh_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","እርሱም። እነዚያን ወደዚህ አምጡልኝ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ሕዝቡም በሣር ላይ እንዲቀመጡ አዘዘ፥ አምስቱንም እንጀራና ሁለቱን ዓሣ ይዞ ወደ ሰማይ አሻቅቦ አየና ባረከ፥ እንጀራውንም ቆርሶ ለደቀ መዛሙርቱ ሰጠ፥ ደቀ መዛሙርቱም ለሕዝቡ። ");
INSERT INTO amh_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ሁሉም በልተው ጠገቡ፥ የተረፈውንም ቁርስራሽ አሥራ ሁለት መሶብ ሙሉ አነሡ። ");
INSERT INTO amh_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ከሴቶችና ከልጆችም በቀር የበሉት አምስት ሺህ ወንዶች ያህሉ ነበር። ");
INSERT INTO amh_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ወዲያውም ሕዝቡን ሲያሰናብት ሳለ፥ ደቀ መዛሙርቱ በታንኳይቱ ገብተው ወደ ማዶ እንዲቀድሙት ግድ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ሕዝቡንም አሰናብቶ ይጸልይ ዘንድ ብቻውን ወደ ተራራ ወጣ። በመሸም ጊዜ ብቻውን በዚያ ነበረ። ");
INSERT INTO amh_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ታንኳይቱም አሁን በባሕር መካከል ሳለች፥ ነፋስ ከወደ ፊት ነበርና በማዕበል ትጨነቅ ነበር። ");
INSERT INTO amh_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ከሌሊቱም በአራተኛው ክፍል ኢየሱስ በባሕር ላይ እየሄደ ወደ እነርሱ መጣ። ");
INSERT INTO amh_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ደቀ መዛሙርቱም በባሕር ላይ ሲሄድ ባዩት ጊዜ። ምትሐት ነው ብለው ታወኩ በፍርሃትም ጮኹ። ");
INSERT INTO amh_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ወዲያውም ኢየሱስ ተናገራቸውና። አይዞአችሁ፥ እኔ ነኝ፤ አትፍሩ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ጴጥሮስም መልሶ። ጌታ ሆይ፥ አንተስ ከሆንህ በውኃው ላይ ወደ አንተ እንድመጣ እዘዘኝ አለው። ");
INSERT INTO amh_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","እርሱም። ና አለው። ጴጥሮስም ከታንኳይቱ ወርዶ ወደ ኢየሱስ ሊደርስ በውኃው ላይ ሄደ። ");
INSERT INTO amh_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ነገር ግን የነፋሱን ኃይል አይቶ ፈራ፥ ሊሰጥምም በጀመረ ጊዜ። ጌታ ሆይ፥ አድነኝ ብሎ ጮኸ። ");
INSERT INTO amh_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ወዲያውም ኢየሱስ እጁን ዘርግቶ ያዘውና። አንተ እምነት የጎደለህ፥ ስለምን ተጠራጠርህ? አለው። ");
INSERT INTO amh_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ወደ ታንኳይቱም በወጡ ጊዜ ነፋሱ ተወ። ");
INSERT INTO amh_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","በታንኳይቱም የነበሩት። በእውነት የእግዚአብሔር ልጅ ነህ ብለው ሰገዱለት። ");
INSERT INTO amh_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ተሻግረውም ወደ ጌንሴሬጥ ምድር መጡ። ");
INSERT INTO amh_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","የዚያ ቦታ ሰዎችም ባወቁት ጊዜ በዙርያው ወዳለ አገር ሁሉ ላኩ፥ ሕመምተኞችንም ሁሉ ወደ እርሱ አመጡ፤ ");
INSERT INTO amh_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","የልብሱንም ጫፍ ብቻ ሊዳስሱ ይለምኑት ነበር፤ የዳሰሱትም ሁሉ ዳኑ። ");
INSERT INTO amh_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","በዚያን ጊዜ ጻፎችና ፈሪሳውያን ከኢየሩሳሌም ወደ ኢየሱስ ቀረቡና። ");
INSERT INTO amh_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","ደቀ መዛሙርትህ ስለ ምን የሽማግሎችን ወግ ይተላለፋሉ? እንጀራ ሲበሉ እጃቸውን አይታጠቡምና አሉት። ");
INSERT INTO amh_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","እርሱም መልሶ እንዲህ አላቸው። እናንተስ ስለ ወጋችሁ የእግዚአብሔርን ትእዛዝ ስለ ምን ትተላለፋላችሁ? ");
INSERT INTO amh_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","እግዚአብሔር። አባትህንና እናትህን አክብር፤ ደግሞ። አባቱን ወይም እናቱን የሰደበ ፈጽሞ ይሙት ብሎአልና፤ ");
INSERT INTO amh_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","እናንተ ግን። አባቱን ወይም እናቱን። ከእኔ የምትጠቀምበት መባ ነው የሚል ሁሉ፥ ");
INSERT INTO amh_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","አባቱን ወይም እናቱን አያከብርም ትላላችሁ፤ ስለ ወጋችሁም የእግዚአብሔርን ቃል ሻራችሁ። ");
INSERT INTO amh_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","እናንተ ግብዞች፥ ኢሳይያስ ስለ እናንተ። ");
INSERT INTO amh_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ይህ ሕዝብ በከንፈሩ ያከብረኛል፥ ልቡ ግን ከእኔ በጣም የራቀ ነው፤ ");
INSERT INTO amh_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","የሰውም ሥርዓት የሆነ ትምህርት እያስተማሩ በከንቱ ያመልኩኛል ብሎ በእውነት ትንቢት ተናገረ። ");
INSERT INTO amh_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ሕዝቡንም ጠርቶ። ስሙ አስተውሉም፤ ");
INSERT INTO amh_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ሰውን የሚያረክሰው ወደ አፍ የሚገባ አይደለም፥ ከአፍ የሚወጣው ግን ሰውን የሚያረክሰው ይህ ነው አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","በዚያን ጊዜ ደቀ መዛሙርቱ ቀርበው። ፈሪሳውያን ይህን ቃል ሰምተው እንደ ተሰናከሉ አወቅህን? አሉት። ");
INSERT INTO amh_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","እርሱ ግን መልሶ። የሰማዩ አባቴ ያልተከለው ተክል ሁሉ ይነቀላል። ");
INSERT INTO amh_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ተዉአቸው፤ ዕውሮችን የሚመሩ ዕውሮች ናቸው፤ ዕውርም ዕውርን ቢመራው ሁለቱም ወደ ጉድጓድ ይወድቃሉ አለ። ");
INSERT INTO amh_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ጴጥሮስም መልሶ። ምሳሌውን ተርጕምልን አለው። ");
INSERT INTO amh_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ኢየሱስም እንዲህ አለ። እናንተ ደግሞ እስካሁን የማታስተውሉ ናችሁን? ");
INSERT INTO amh_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ወደ አፍ የሚገባ ሁሉ ወደ ሆድ አልፎ ወደ እዳሪ እንዲጣል አትመለከቱምን? ");
INSERT INTO amh_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ከአፍ የሚወጣ ግን ከልብ ይወጣል፥ ሰውንም የሚያረክሰው ያ ነው። ");
INSERT INTO amh_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ከልብ ክፉ አሳብ፥ መግደል፥ ምንዝርነት፥ ዝሙት፥ መስረቅ፥ በውሸት መመስከር፥ ስድብ ይወጣልና። ");
INSERT INTO amh_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ሰውን የሚያረክሰው ይህ ነው እንጂ፥ ባልታጠበ እጅ መብላትስ ሰውን አያረክሰውም። ");
INSERT INTO amh_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ኢየሱስም ከዚያ ወጥቶ ወደ ጢሮስና ወደ ሲዶና አገር ሄደ። ");
INSERT INTO amh_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","እነሆም፥ ከነናዊት ሴት ከዚያ አገር ወጥታ። ጌታ ሆይ፥ የዳዊት ልጅ፥ ማረኝ፤ ልጄን ጋኔን ክፉኛ ይዞአታል ብላ ጮኸች። ");
INSERT INTO amh_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","እርሱ ግን አንዳች አልመለሰላትም። ደቀ መዛሙርቱም ቀርበው። በኋላችን ትጮኻለችና አሰናብታት እያሉ ለመኑት። ");
INSERT INTO amh_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","እርሱም መልሶ። ከእስራኤል ቤት ለጠፉት በጎች በቀር አልተላክሁም አለ። ");
INSERT INTO amh_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","እርስዋ ግን መጥታ። ጌታ ሆይ፥ እርዳኝ እያለች ሰገደችለት። ");
INSERT INTO amh_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","እርሱ ግን መልሶ። የልጆችን እንጀራ ይዞ ለቡችሎች መጣል አይገባም አለ። ");
INSERT INTO amh_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","እርስዋም። አዎን ጌታ ሆይ፤ ቡችሎችም እኮ ከጌቶቻቸው ማዕድ የወደቀውን ፍርፋሪ ይበላሉ አለች። ");
INSERT INTO amh_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","በዚያን ጊዜ ኢየሱስ መልሶ። አንቺ ሴት፥ እምነትሽ ታላቅ ነው፤ እንደወደድሽ ይሁንልሽ አላት። ልጅዋም ከዚያች ሰዓት ጀምሮ ዳነች። ");
INSERT INTO amh_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ኢየሱስም ከዚያ አልፎ ወደ ገሊላ ባሕር አጠገብ መጣ፥ ወደ ተራራም ወጥቶ በዚያ ተቀመጠ። ");
INSERT INTO amh_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ብዙ ሕዝብም አንካሶችን፥ ዕውሮችንም፥ ዲዳዎችንም፥ ጉንድሾችንም፥ ሌሎችንም ብዙ ይዘው ወደ እርሱ ቀረቡ፥ በኢየሱስም እግር አጠገብ ጣሉአቸው፤ ፈወሳቸውም፤ ");
INSERT INTO amh_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ስለዚህም ሕዝቡ ዲዳዎች ሲናገሩ፥ ጉንድሾችም ሲድኑ፥ አንካሶችም ሲሄዱ፥ ዕውሮችም ሲያዩ አይተው ተደነቁ፤ የእስራኤልንም አምላክ አከበሩ። ");
INSERT INTO amh_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ኢየሱስም ደቀ መዛሙርቱን ጠርቶ። ሕዝቡ ከእኔ ጋር እስካሁን ሦስት ቀን ውለዋልና የሚበሉት ስለ ሌላቸው አዝንላቸዋለሁ፤ በመንገድም እንዳይዝሉ ጦማቸውን ላሰናብታቸው አልወድም አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ደቀ መዛሙርቱም። ይህን ያህል ሕዝብ የሚያጠግብ ይህን ያህል እንጀራ በምድረ በዳ ከወዴት እናገኛለን? አሉት። ");
INSERT INTO amh_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ኢየሱስም። ስንት እንጀራ አላችሁ? አላቸው። እነርሱም። ሰባት፥ ጥቂትም ትንሽ ዓሣ አሉት። ");
INSERT INTO amh_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ሕዝቡም በምድር ላይ እንዲቀመጡ አዘዘ፤ ");
INSERT INTO amh_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ሰባቱንም እንጀራ ዓሣውንም ይዞ አመሰገነ ቈርሶም ለደቀ መዛሙርቱ ሰጠ፥ ደቀ መዛሙርቱም ለሕዝቡ። ");
INSERT INTO amh_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ሁሉም በሉና ጠገቡ፥ የተረፈውንም ቁርስራሽ ሰባት ቅርጫት ሙሉ አነሡ። ");
INSERT INTO amh_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","የበሉትም ከሴቶችና ከልጆች በቀር አራት ሺህ ወንዶች ነበሩ። ");
INSERT INTO amh_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ሕዝቡንም ካሰናበተ በኋላ ወደ ታንኳይቱ ገብቶ ወደ መጌዶል አገር መጣ። ");
INSERT INTO amh_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ፈሪሳውያንና ሰዱቃውያንም ቀርበው ሲፈትኑት ከሰማይ ምልክት እንዲያሳያቸው ለመኑት። ");
INSERT INTO amh_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","እርሱ ግን መልሶ እንዲህ አላቸው። በመሸ ጊዜ። ሰማዩ ቀልቶአልና ብራ ይሆናል ትላላችሁ፤ ");
INSERT INTO amh_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ማለዳም። ሰማዩ ደምኖ ቀልቶአልና ዛሬ ይዘንባል ትላላችሁ። የሰማዩን ፊትማ መለየት ታውቃላችሁ፥ የዘመኑንስ ምልክት መለየት አትችሉምን? ");
INSERT INTO amh_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ክፉና አመንዝራ ትውልድ ምልክት ይሻል፥ ከነቢዩም ከዮናስ ምልክት በቀር ምልክት አይሰጠውም። ትቶአቸውም ሄደ። ");
INSERT INTO amh_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ደቀ መዛሙርቱም ወደ ማዶ በመጡ ጊዜ እንጀራ መያዝን ረሱ። ");
INSERT INTO amh_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ኢየሱስም። ከፈሪሳውያንና ከሰዱቃውያን እርሾ ተጠንቀቁና ተጠበቁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","እነርሱም። እንጀራ ባንይዝ ነው ብለው እርስ በርሳቸው ተነጋገሩ። ");
INSERT INTO amh_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ኢየሱስም አውቆ እንዲህ አላቸው። እናንተ እምነት የጐደላችሁ፥ እንጀራ ስለ ሌላችሁ ስለ ምን እርስ በርሳችሁ ትነጋገራላችሁ? ገና አታስተውሉምን? ");
INSERT INTO amh_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ለአምስቱ ሺህ አምስቱ እንጀራ፥ ስንት መሶብም እንዳነሣችሁ ትዝ አይላችሁምን? ");
INSERT INTO amh_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ወይስ ለአራቱ ሺህ ሰባቱ እንጀራ፥ ስንት ቅርጫትም እንዳነሣችሁ ትዝ አይላችሁምን? ");
INSERT INTO amh_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ከፈሪሳውያንና ከሰዱቃውያን እርሾ እንድትጠበቁ ብዬ ስለ እንጀራ እንዳልተናገርኋችሁ እንዴት አታስተውሉምን? ");
INSERT INTO amh_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","እነርሱም ከፈሪሳውያንና ከሰዱቃውያን ትምህርት እንጂ ከእንጀራ እርሾ እንዲጠበቁ እንዳላላቸው ያን ጊዜ አስተዋሉ። ");
INSERT INTO amh_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ኢየሱስም ወደ ፊልጶስ ቂሣርያ አገር በደረሰ ጊዜ ደቀ መዛሙርቱን። ሰዎች የሰውን ልጅ ማን እንደ ሆነ ይሉታል? ብሎ ጠየቀ። ");
INSERT INTO amh_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","እነርሱም። አንዳንዱ መጥምቁ ዮሐንስ፥ ሌሎችም ኤልያስ፥ ሌሎችም ኤርምያስ ወይም ከነቢያት አንዱ ነው ይላሉ አሉት። ");
INSERT INTO amh_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","እርሱም። እናንተስ እኔን ማን እንደ ሆንሁ ትላላችሁ? አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ስምዖን ጴጥሮስም መልሶ። አንተ ክርስቶስ የሕያው እግዚአብሔር ልጅ ነህ አለ። ");
INSERT INTO amh_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ኢየሱስም መልሶ እንዲህ አለው። የዮና ልጅ ስምዖን ሆይ፥ በሰማያት ያለው አባቴ እንጂ ሥጋና ደም ይህን አልገለጠልህምና ብፁዕ ነህ። ");
INSERT INTO amh_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","እኔም እልሃለሁ፥ አንተ ጴጥሮስ ነህ፥ በዚችም ዓለት ላይ ቤተ ክርስቲያኔን እሠራለሁ፥ የገሃነም ደጆችም አይችሉአትም። ");
INSERT INTO amh_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","የመንግሥተ ሰማያትንም መክፈቻዎች እሰጥሃለሁ፤ በምድር የምታስረው ሁሉ በሰማያት የታሰረ ይሆናል፥ በምድርም የምትፈታው ሁሉ በሰማያት የተፈታ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ያን ጊዜም እርሱ ክርስቶስ እንደ ሆነ ለማንም እንዳይነግሩ ደቀ መዛሙርቱን አዘዛቸው። ");
INSERT INTO amh_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ከዚያን ቀን ጀምሮ ኢየሱስ ወደ ኢየሩሳሌም ይሄድ ዘንድ ከሽማግሎችና ከካህናት አለቆች ከጻፎችም ብዙ መከራ ይቀበልና ይገደል ዘንድ በሦስተኛውም ቀን ይነሣ ዘንድ እንዲገባው ለደቀ መዛሙርቱ ይገልጥላቸው ጀመር። ");
INSERT INTO amh_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ጴጥሮስም ወደ እርሱ ወስዶ። አይሁንብህ ጌታ ሆይ፤ ይህ ከቶ አይደርስብህም ብሎ ሊገሥጸው ጀመረ። ");
INSERT INTO amh_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","እርሱ ግን ዘወር ብሎ ጴጥሮስን። ወደ ኋላዬ ሂድ፥ አንተ ሰይጣን፤ የሰውን እንጂ የእግዚአብሔርን አታስብምና ዕንቅፋት ሆነህብኛል አለው። ");
INSERT INTO amh_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","በዚያን ጊዜ ኢየሱስ ለደቀ መዛሙርቱ እንዲህ አለ። እኔን መከተል የሚወድ ቢኖር፥ ራሱን ይካድ መስቀሉንም ተሸክሞ ይከተለኝ። ");
INSERT INTO amh_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ነፍሱን ሊያድን የሚወድ ሁሉ ያጠፋታል፤ ስለ እኔ ግን ነፍሱን የሚያጠፋ ሁሉ ያገኛታል። ");
INSERT INTO amh_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ሰው ዓለሙን ሁሉ ቢያተርፍ ነፍሱንም ቢያጐድል ምን ይጠቅመዋል? ወይስ ሰው ስለ ነፍሱ ቤዛ ምን ይሰጣል? ");
INSERT INTO amh_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","የሰው ልጅ ከመላእክቱ ጋር በአባቱ ክብር ይመጣ ዘንድ አለውና፤ ያን ጊዜም ለሁሉ እንደ ሥራው ያስረክበዋል። ");
INSERT INTO amh_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","እውነት እላችኋለሁ፥ የሰው ልጅ በመንግሥቱ ሲመጣ እስኪያዩ ድረስ እዚህ ከሚቆሙት ሞትን የማይቀምሱ አንዳንድ አሉ። ");
INSERT INTO amh_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ከስድስት ቀንም በኋላ ኢየሱስ ጴጥሮስንና ያዕቆብን ወንድሙንም ዮሐንስን ይዞ ወደ ረጅም ተራራ ብቻቸውን አወጣቸው። ");
INSERT INTO amh_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","በፊታቸውም ተለወጠ፥ ፊቱም እንደ ፀሐይ በራ፥ ልብሱም እንደ ብርሃን ነጭ ሆነ። ");
INSERT INTO amh_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","እነሆም፥ ሙሴና ኤልያስ ከእርሱ ጋር ሲነጋገሩ ታዩአቸው። ");
INSERT INTO amh_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ጴጥሮስም መልሶ ኢየሱስን። ጌታ ሆይ፥ በዚህ መሆን ለእኛ መልካም ነው፤ ብትወድስ፥ በዚህ ሦስት ዳስ አንዱን ለአንተ አንዱንም ለሙሴ አንዱንም ለኤልያስ እንሥራ አለ። ");
INSERT INTO amh_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","እርሱም ገና ሲናገር፥ እነሆ፥ ብሩህ ደመና ጋረዳቸው፥ እነሆም፥ ከደመናው። በእርሱ ደስ የሚለኝ የምወደው ልጄ ይህ ነው፤ እርሱን ስሙት የሚል ድምፅ መጣ። ");
INSERT INTO amh_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ደቀ መዛሙርቱም ሰምተው በፊታቸው ወደቁ እጅግም ፈርተው ነበር። ");
INSERT INTO amh_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ኢየሱስም ቀርቦ ዳሰሳቸውና። ተነሡ አትፍሩም አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ዓይናቸውንም አቅንተው ሲያዩ ከኢየሱስ ብቻ በቀር ማንንም አላዩም። ");
INSERT INTO amh_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ከተራራውም በወረዱ ጊዜ ኢየሱስ። የሰው ልጅ ከሙታን እስኪነሣ ድረስ ያያችሁትን ለማንም አትንገሩ ብሎ አዘዛቸው። ");
INSERT INTO amh_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ደቀ መዛሙርቱም። እንግዲህ ጻፎች። ኤልያስ አስቀድሞ ሊመጣ ይገባዋል ስለ ምን ይላሉ? ብለው ጠየቁት። ");
INSERT INTO amh_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ኢየሱስም መልሶ። ኤልያስማ አስቀድሞ ይመጣል ሁሉንም ያቀናል፤ ");
INSERT INTO amh_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ነገር ግን እላችኋለሁ፥ ኤልያስ ከዚህ በፊት መጣ፤ የወደዱትንም ሁሉ አደረጉበት እንጂ አላወቁትም፤ እንዲሁም ደግሞ የሰው ልጅ ከእነርሱ መከራ ይቀበል ዘንድ አለው አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","በዚያን ጊዜ ደቀ መዛሙርቱ ስለ መጥምቁ ስለ ዮሐንስ እንደ ነገራቸው አስተዋሉ። ");
INSERT INTO amh_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ወደ ሕዝቡም ሲደርሱ አንድ ሰው ወደ እርሱ ቀረበና ተንበርክኮ። ጌታ ሆይ፥ ልጄን ማርልኝ፥ በጨረቃ እየተነሣበት ክፉኛ ይሣቀያልና፤ ");
INSERT INTO amh_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ብዙ ጊዜ በእሳት ብዙ ጊዜም በውኃ ይወድቃልና። ");
INSERT INTO amh_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ወደ ደቀ መዛሙርትህም አመጣሁት ሊፈውሱትም አቃታቸው አለው። ");
INSERT INTO amh_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ኢየሱስም መልሶ። የማታምን ጠማማ ትውልድ ሆይ፥ እስከ መቼ ከእናንተ ጋር እኖራለሁ? እስከ መቼስ እታገሣችኋለሁ? ወደዚህ ወደ እኔ አምጡት አለ። ");
INSERT INTO amh_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ኢየሱስም ገሠጸው ጋኔኑም ከእርሱ ወጣ፥ ብላቴናውም ከዚያች ሰዓት ጀምሮ ተፈወሰ። ");
INSERT INTO amh_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ከዚህ በኋላ ደቀ መዛሙርቱ ብቻቸውን ወደ ኢየሱስ ቀረቡና። እኛ ልናወጣው ያልቻልን ስለ ምን ነው? አሉት። ");
INSERT INTO amh_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ኢየሱስም። ስለ እምነታችሁ ማነስ ነው፤ እውነት እላችኋለሁ፥ የሰናፍጭ ቅንጣት የሚያህል እምነት ቢኖራችሁ፥ ይህን ተራራ። ከዚህ ወደዚያ እለፍ ብትሉት ያልፋል፤ የሚሳናችሁም ነገር የለም። ");
INSERT INTO amh_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ይህ ዓይነት ግን ከጸሎትና ከጦም በቀር አይወጣም አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","በገሊላም ሲመላለሱ ኢየሱስ። የሰው ልጅ በሰዎች እጅ አልፎ ይሰጥ ዘንድ አለው፥ ይገድሉትማል፥ ");
INSERT INTO amh_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","በሦስተኛውም ቀን ይነሣል አላቸው። እጅግም አዘኑ። ");
INSERT INTO amh_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ወደ ቅፍርናሆምም በመጡ ጊዜ ግብር የሚቀበሉ ሰዎች ወደ ጴጥሮስ ቀረቡና። መምህራችሁ ሁለቱን ዲናር*ፍ1* አይገብርምን? አሉት። ");
INSERT INTO amh_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","አዎን ይገብራል አለ። ወደ ቤትም በገባ ጊዜ ኢየሱስ አስቀድሞ። ስምዖን ሆይ፥ ምን ይመስልሃል? የምድር ነገሥታት ቀረጥና ግብር ከማን ይቀበላሉ? ከልጆቻቸውን ወይስ ከእንግዶች? አለው። ");
INSERT INTO amh_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ጴጥሮስም። ከእንግዶች ባለው ጊዜ ኢየሱስ። እንኪያስ ልጆቻቸው ነጻ ናቸው። ");
INSERT INTO amh_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ነገር ግን እንዳናሰናክላቸው፥ ወደ ባሕር ሂድና መቃጥን ጣል፥ መጀመሪያም የሚወጣውን ዓሣ ውሰድና አፉን ስትከፍት እስታቴር*ፍ2* ታገኛለህ፤ ያን ወስደህ ስለ እኔና ስለ አንተ ስጣቸው አለው። ");
INSERT INTO amh_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","በዚያች ሰዓት ደቀ መዛሙርቱ ወደ ኢየሱስ ቀርበው። በመንግሥተ ሰማያት ከሁሉ የሚበልጥ ማን ይሆን? አሉት። ");
INSERT INTO amh_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ሕፃንም ጠርቶ በመካከላቸው አቆመ ");
INSERT INTO amh_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","እንዲህም አለ። እውነት እላችኋለሁ፥ ካልተመለሳችሁ እንደ ሕፃናትም ካልሆናችሁ፥ ወደ መንግሥተ ሰማያት ከቶ አትገቡም። ");
INSERT INTO amh_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","እንግዲህ እንደዚህ ሕፃን ራሱን የሚያዋርድ ሁሉ፥ በመንግሥተ ሰማያት የሚበልጥ እርሱ ነው። ");
INSERT INTO amh_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","እንደዚህም ያለውን አንድ ሕፃን በስሜ የሚቀበል ሁሉ እኔን ይቀበላል፤ ");
INSERT INTO amh_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","በእኔም ከሚያምኑ ከነዚህ ከታናናሾቹ አንዱን የሚያሰናክል ሁሉ፥ የወፍጮ ድንጋይ በአንገቱ ታስሮ ወደ ጥልቅ ባሕር መስጠም ይሻለው ነበር። ");
INSERT INTO amh_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ወዮ ለዓለም ስለ ማሰናከያ፤ ማሰናከያ ሳይመጣ አይቀርምና፥ ነገር ግን በእርሱ ጠንቅ ማሰናከያ ለሚመጣበት ለዚያ ሰው ወዮለት። ");
INSERT INTO amh_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","እጅህ ወይም እግርህ ብታሰናክልህ፥ ቈርጠህ ከአንተ ጣላት፤ ሁለት እጅ ወይም ሁለት እግር ኖሮህ ወደ ዘላለም እሳት ከምትጣል ይልቅ አንካሳ ወይም ጉንድሽ ሆነህ ወደ ህይወት መግባት ይሻልሀል። ");
INSERT INTO amh_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ዓይንህ ብታሰናክልህ አውጥተህ ከአንተ ጣላት፤ ሁለት ዓይን ኖሮህ ወደ ገሃነመ እሳት ከምትጣል ይልቅ አንዲት ዓይን ኖራህ ወደ ሕይወት መግባት ይሻልሃል። ");
INSERT INTO amh_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ከነዚህ ከታናናሾቹ አንዱን እንዳትንቁ ተጠንቀቁ፤ መላእክቶቻቸው በሰማያት ዘወትር በሰማያት ያለውን የአባቴን ፊት ያያሉ እላችኋለሁና። ");
INSERT INTO amh_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","የሰው ልጅ የጠፋውን ለማዳን መጥቶአልና። ");
INSERT INTO amh_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ምን ይመስላችኋል? ለአንድ ሰው መቶ በጎች ቢኖሩት ከእነርሱም አንዱ ቢባዝን፥ ዘጠና ዘጠኙን በተራራ ትቶ ሄዶም የባዘነውን አይፈልግምን? ");
INSERT INTO amh_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ቢያገኘውም፥ እውነት እላችኋለሁ፥ ካልባዘኑቱ ከዘጠና ዘጠኙ ይልቅ በእርሱ ደስ ይለዋል። ");
INSERT INTO amh_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","እንደዚሁ ከእነዚህ ከታናናሾቹ አንዱ እንዲጠፋ በሰማያት ያለው አባታችሁ ፈቃድ አይደለም። ");
INSERT INTO amh_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ወንድምህም ቢበድልህ፥ ሄደህ አንተና እርሱ ብቻችሁን ሆናችሁ ውቀሰው። ቢሰማህ፥ ወንድምህን ገንዘብ አደረግኸው፤ ");
INSERT INTO amh_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ባይሰማህ ግን፥ በሁለት ወይም በሦስት ምስክር አፍ ነገር ሁሉ እንዲጸና፥ ዳግመኛ አንድ ወይም ሁለት ከአንተ ጋር ውሰድ፤ ");
INSERT INTO amh_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","እነርሱንም ባይሰማ፥ ለቤተ ክርስቲያን ንገራት፤ ደግሞም ቤተ ክርስቲያንን ባይሰማት፥ እንደ አረመኔና እንደ ቀራጭ ይሁንልህ። ");
INSERT INTO amh_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","እውነት እላችኋለሁ፥ በምድር የምታስሩት ሁሉ በሰማይ የታሰረ ይሆናል፥ በምድርም የምትፈቱት ሁሉ በሰማይ የተፈታ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ደግሞ እላችኋለሁ፥ ከእናንተ ሁለቱ በምድር በማናቸውም በሚለምኑት ነገር ሁሉ ቢስማሙ በሰማያት ካለው ከአባቴ ዘንድ ይደረግላቸዋል። ");
INSERT INTO amh_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ሁለት ወይም ሦስት በስሜ በሚሰበሰቡበት በዚያ በመካከላቸው እሆናለሁና። ");
INSERT INTO amh_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","በዚያን ጊዜ ጴጥሮስ ወደ እርሱ ቀርቦ። ጌታ ሆይ፥ ወንድሜ ቢበድለኝ ስንት ጊዜ ልተውለት? እስከ ሰባት ጊዜን? አለው። ");
INSERT INTO amh_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ኢየሱስ እንዲህ አለው። እስከ ሰባ ጊዜ ሰባት እንጂ እስከ ሰባት ጊዜ አልልህም። ");
INSERT INTO amh_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ስለዚህ መንግሥተ ሰማያት ባሮቹን ሊቈጣጠር የወደደን ንጉሥ ትመስላለች። ");
INSERT INTO amh_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","መቈጣጠርም በጀመረ ጊዜ፥ እልፍ መክሊት ዕዳ ያለበትን አንድ ሰው ወደ እርሱ አመጡ። ");
INSERT INTO amh_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","የሚከፍለውም ቢያጣ፥ እርሱና ሚስቱ ልጆቹም ያለውም ሁሉ እንዲሸጥና ዕዳው እንዲከፈል ጌታው አዘዘ። ");
INSERT INTO amh_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ስለዚህ ባሪያው ወድቆ ሰገደለትና። ጌታ ሆይ፥ ታገሠኝ፥ ሁሉንም እከፍልሃለሁ አለው። ");
INSERT INTO amh_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","የዚያም ባሪያ ጌታ አዘነለትና ለቀቀው፥ ዕዳውንም ተወለት። ");
INSERT INTO amh_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","ነገር ግን ያ ባሪያ ወጥቶ ከባልንጀሮቹ ከባሮቹ መቶ ዲናር ዕዳ ያለበትን አንዱን አገኘና። ዕዳህን ክፈለኝ ብሎ ያዘና አነቀው። ");
INSERT INTO amh_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ስለዚህ ባልንጀራው ባሪያ ወድቆ። ታገሠኝ፥ ሁሉንም እከፍልሃለሁ ብሎ ለመነው። ");
INSERT INTO amh_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","እርሱም አልወደደም፥ ግን ሄዶ ዕዳውን እስኪከፍል ድረስ በወኅኒ አኖረው። ");
INSERT INTO amh_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ባልንጀሮቹ የሆኑ ባሮችም ያደረገውን አይተው እጅግ አዘኑ፥ መጥተውም የሆነውን ሁሉ ለጌታቸው ገለጡ። ");
INSERT INTO amh_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ከዚያ ወዲያ ጌታው ጠርቶ። አንተ ክፉ ባሪያ፥ ስለ ለመንኸኝ ያን ዕዳ ሁሉ ተውሁልህ፤ ");
INSERT INTO amh_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","እኔ እንደ ማርሁህ ባልንጀራህ የሆነውን ያን ባሪያ ልትምረው ለአንተስ አይገባህምን? አለው። ");
INSERT INTO amh_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ጌታውም ተቈጣና ዕዳውን ሁሉ እስኪከፍለው ድረስ ለሚሣቅዩት አሳልፎ ሰጠው። ");
INSERT INTO amh_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ከእናንተ እያንዳንዱ ወንድሙን ከልቡ ይቅር ካላለ፥ እንዲሁ ደግሞ የሰማዩ አባቴ ያደርግባችኋል። ");
INSERT INTO amh_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ኢየሱስም ይህን ነገር ከፈጸመ በኋላ፥ ከገሊላ ሄዶ ወደ ይሁዳ አውራጃ ወደ ዮርዳኖስ ማዶ መጣ። ");
INSERT INTO amh_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ብዙ ሕዝብም ተከተሉት፥ በዚያም ፈወሳቸው። ");
INSERT INTO amh_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ፈሪሳውያንም ወደ እርሱ ቀረቡና ሲፈትኑት። ሰው በሆነው ምክንያት ሁሉ ሚስቱን ሊፈታ ተፈቅዶለታልን? አሉት። ");
INSERT INTO amh_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","እርሱ ግን መልሶ እንዲህ አለ። ፈጣሪ በመጀመሪያ ወንድና ሴት አደረጋቸው፥ ");
INSERT INTO amh_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","አለም። ስለዚህ ሰው አባቱንና እናቱን ይተዋል፥ ከሚስቱም ጋር ይተባበራል፥ ሁለቱም አንድ ሥጋ ይሆናሉ የሚለውን ቃል አላነበባችሁምን? ");
INSERT INTO amh_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ስለዚህ አንድ ሥጋ ናቸው እንጂ ወደ ፊት ሁለት አይደሉም። እግዚአብሔር ያጣመረውን እንግዲህ ሰው አይለየው። ");
INSERT INTO amh_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","እነርሱም። እንኪያስ ሙሴ የፍችዋን ጽሕፈት ሰጥተው እንዲፈቱአት ስለ ምን አዘዘ? አሉት። ");
INSERT INTO amh_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","እርሱም። ሙሴስ ስለ ልባችሁ ጥንካሬ ሚስቶቻችሁን ትፈቱ ዘንድ ፈቀደላችሁ፤ ከጥንት ግን እንዲህ አልነበረም። ");
INSERT INTO amh_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","እኔ ግን እላችኋለሁ፥ ያለ ዝሙት ምክንያት ሚስቱን ፈትቶ ሌላዪቱን የሚያገባ ሁሉ ያመነዝራል፥ የተፈታችውንም የሚያገባ ያመነዝራል አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ደቀ መዛሙርቱም። የባልና የሚስት ሥርዓት እንዲህ ከሆነ መጋባት አይጠቅምም አሉት። ");
INSERT INTO amh_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","እርሱ ግን። ይህ ነገር ለተሰጣቸው ነው እንጂ ለሁሉ አይደለም፤ ");
INSERT INTO amh_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","በእናት ማኅፀን ጃንደረቦች ሆነው የተወለዱ አሉ፥ ሰውም የሰለባቸው ጃንደረቦች አሉ፥ ስለ መንግሥተ ሰማያትም ራሳቸውን የሰለቡ ጃንደረቦች አሉ። ሊቀበለው የሚችል ይቀበለው አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","በዚያን ጊዜ እጁን እንዲጭንባቸውና እንዲጸልይ ሕፃናትን ወደ እርሱ አመጡ፤ ደቀ መዛሙርቱም ገሠጹአቸው። ");
INSERT INTO amh_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ነገር ግን ኢየሱስ። ሕፃናትን ተዉአቸው፥ ወደ እኔም ይመጡ ዘንድ አትከልክሉአቸው፤ መንግሥተ ሰማያት እንደነዚህ ላሉ ናትና አለ፤ ");
INSERT INTO amh_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","እጁንም ጫነባቸውና ከዚያ ሄደ። ");
INSERT INTO amh_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","እነሆም፥ አንድ ሰው ቀርቦ። መምህር ሆይ፥ የዘላለምን ሕይወት እንዳገኝ ምን መልካም ነገር ላድርግ? አለው። ");
INSERT INTO amh_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","እርሱም። ስለ መልካም ነገር ለምን ትጠይቀኛለህ? መልካም የሆነ አንድ ነው፤ ወደ ሕይወት መግባት ብትወድ ግን ትእዛዛትን ጠብቅ አለው። ");
INSERT INTO amh_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","እርሱም። የትኞችን? አለው። ኢየሱስም። አትግደል፥ አታመንዝር፥ አትስረቅ፥ በሐሰት አትመስክር፥ ");
INSERT INTO amh_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","አባትህንና እናትህን አክብር፥ ባልንጀራህንም እንደ ራስህ ውደድ አለው። ");
INSERT INTO amh_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ጐበዙም። ይህንማ ሁሉ ከሕፃንነቴ ጀምሬ ጠብቄአለሁ፥ ደግሞስ የሚጐድለኝ ምንድር ነው? አለው። ");
INSERT INTO amh_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ኢየሱስም። ፍጹም ልትሆን ብትወድ፥ ሂድና ያለህን ሸጠህ ለድሆች ስጥ፥ መዝገብም በሰማያት ታገኛለህ፥ መጥተህም ተከተለኝ አለው። ");
INSERT INTO amh_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ጐበዙም ይህን ቃል በሰማ ጊዜ ብዙ ንብረት ነበረውና እያዘነ ሄደ። ");
INSERT INTO amh_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ኢየሱስም ለደቀ መዛሙርቱ። እውነት እላችኋለሁ፥ ለባለጠጋ ወደ መንግሥተ ሰማያት መግባት ጭንቅ ነው። ");
INSERT INTO amh_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ዳግመኛም እላችኋለሁ፥ ባለጠጋ ወደ እግዚአብሔር መንግሥት ከሚገባ ግመል በመርፌ ቀዳዳ ቢገባ ይቀላል አለ። ");
INSERT INTO amh_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ደቀ መዛሙርቱም ሰምተው እጅግ ተገረሙና። እንኪያስ ማን ሊድን ይችላል? አሉ። ");
INSERT INTO amh_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ኢየሱስም እነርሱን ተመልክቶ። ይህ በሰው ዘንድ አይቻልም በእግዚአብሔር ዘንድ ግን ሁሉ ይቻላል አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","በዚያን ጊዜ ጴጥሮስ መልሶ። እነሆ፥ እኛ ሁሉን ትተን ተከተልንህ፤ እንኪያስ ምን እናገኝ ይሆን? አለው። ");
INSERT INTO amh_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ኢየሱስም እንዲህ አላቸው። እውነት እላችኋለሁ፥ እናንተስ የተከተላችሁኝ፥ በዳግመኛ ልደት የሰው ልጅ በክብሩ ዙፋን በሚቀመጥበት ጊዜ፥ እናንተ ደግሞ በአሥራ ሁለቱ የእስራኤል ነገድ ስትፈርዱ በአሥራ ሁለት ዙፋን ትቀመጣላችሁ። ");
INSERT INTO amh_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ስለ ስሜም ቤቶችን ወይም ወንድሞችን ወይም እኅቶችን ወይም አባትን ወይም እናትን ወይም ሚስትን ወይም ልጆችን ወይም እርሻን የተወ ሁሉ መቶ እጥፍ ይቀበላል የዘላለምንም ሕይወት ይወርሳል። ");
INSERT INTO amh_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ነገር ግን ብዙዎቹ ፊተኞች ኋለኞች፥ ኋለኞችም ፊተኞች ይሆናሉ። ");
INSERT INTO amh_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","መንግሥተ ሰማያት ለወይኑ አትክልት ሠራተኞችን ሊቀጥር ማልዶ የወጣ ባለቤት ሰውን ትመስላለችና። ");
INSERT INTO amh_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ሠራተኞችንም በቀን አንድ ዲናር ተስማምቶ ወደ ወይኑ አትክልት ሰደዳቸው። ");
INSERT INTO amh_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","በሦስት ሰዓትም ወጥቶ ሥራ የፈቱ ሌሎችን በአደባባይ ቆመው አየ፥ ");
INSERT INTO amh_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","እነዚያንም። እናንተ ደግሞ ወደ ወይኔ አትክልት ሂዱ የሚገባውንም እሰጣችኋለሁ አላቸው። እነርሱም ሄዱ። ");
INSERT INTO amh_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ደግሞም በስድስትና በዘጠኝ ሰዓት ወጥቶ እንዲሁ አደረገ። ");
INSERT INTO amh_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","በአሥራ አንደኛውም ሰዓት ወጥቶ ሌሎችን ቆመው አገኘና። ሥራ ፈትታችሁ ቀኑን ሁሉ በዚህ ስለ ምን ትቆማላችሁ? አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","የሚቀጥረን ስለ አጣን ነው አሉት። እርሱም። እናንተ ደግሞ ወደ ወይኔ አትክልት ሂዱ የሚገባውንም ትቀበላላችሁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","በመሸም ጊዜ የወይኑ አትክልት ጌታ አዛዡን። ሠራተኞችን ጥራና ከኋለኞች ጀምረህ እስከ ፊተኞች ድረስ ደመወዝ ስጣቸው አለው። ");
INSERT INTO amh_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","በአሥራ አንደኛው ሰዓትም የገቡ መጥተው እያንዳንዳቸው አንድ ዲናር ተቀበሉ። ");
INSERT INTO amh_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ፊተኞችም በመጡ ጊዜ አብዝተው የሚቀበሉ መስሎአቸው ነበር፤ እነርሱም ደግሞ እያንዳንዳቸው አንድ ዲናር ተቀበሉ። ");
INSERT INTO amh_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","13","እርሱ ግን መልሶ ከእነርሱ ለአንዱ እንዲህ አለው። ወዳጄ ሆይ፥ አልበደልሁህም በአንድ ዲናር አልተስማማኸኝምን? ");
INSERT INTO amh_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ድርሻህን ውሰድና ሂድ፤ እኔ ለዚህ ለኋለኛው እንደ አንተ ልሰጠው እወዳለሁ፤ በገንዘቤ የወደድሁትን አደርግ ዘንድ መብት የለኝምን? ");
INSERT INTO amh_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ወይስ እኔ መልካም ስለ ሆንሁ ዓይንህ ምቀኛ ናትን? ");
INSERT INTO amh_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","እንዲሁ ኋለኞች ፊተኞች፥ ፊተኞችም ኋለኞች ይሆናሉ፤ የተጠሩ ብዙዎች፥ የተመረጡ ግን ጥቂቶች ናቸውና። ");
INSERT INTO amh_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ኢየሱስም ወደ ኢየሩሳሌም ሊወጣ ሳለ፥ በመንገድ አሥራ ሁለቱን ደቀ መዛሙርት ብቻቸውን ወደ እርሱ አቅርቦ። ");
INSERT INTO amh_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","እነሆ፥ ወደ ኢየሩሳሌም እንወጣለን፥ የሰው ልጅም ለካህናት አለቆችና ለጻፎች ይሰጣል፤ የሞት ፍርድም ይፈርዱበታል፥ ");
INSERT INTO amh_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ሊዘባበቱበትም ሊገርፉትም ሊሰቅሉትም ለአሕዛብ አሳልፈው ይሰጡታል፥ በሦስተኛውም ቀን ይነሣል አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","በዚያን ጊዜ የዘብዴዎስ ልጆች እናት ከልጆችዋ ጋር እየሰገደችና አንድ ነገር እየለመነች ወደ እርሱ ቀረበች። ");
INSERT INTO amh_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","እርሱም። ምን ትፈልጊያለሽ? አላት። እርስዋም። እነዚህ ሁለቱ ልጆቼ አንዱ በቀኝህ አንዱም በግራህ በመንግሥትህ እንዲቀመጡ እዘዝ አለችው። ");
INSERT INTO amh_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ኢየሱስ ግን መልሶ። የምትለምኑትን አታውቁም። እኔ ልጠጣው ያለውን ጽዋ ልትጠጡ እኔም የምጠመቀውን ጥምቀት ልትጠመቁ ትችላላችሁን? አለ። እንችላለን አሉት። ");
INSERT INTO amh_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","እርሱም። ጽዋዬንስ ትጠጣላችሁ፤ በቀኝና በግራ መቀመጥ ግን ከአባቴ ዘንድ ለተዘጋጀላቸው ነው እንጂ እኔ የምሰጥ አይደለሁም አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","አሥሩም ሰምተው በሁለቱ ወንድማማች ተቈጡ። ");
INSERT INTO amh_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ኢየሱስ ግን ወደ እርሱ ጠርቶ እንዲህ አላቸው። የአሕዛብ አለቆች እንዲገዙአቸው ታላላቆቹም በላያቸው እንዲሠለጥኑ ታውቃላችሁ። ");
INSERT INTO amh_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","በእናንተስ እንዲህ አይደለም፤ ነገር ግን ማንም ከእናንተ ታላቅ ሊሆን የሚወድ የእናንተ አገልጋይ ይሁን፥ ");
INSERT INTO amh_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ከእናንተም ማንም ፊተኛ ሊሆን የሚወድ የእናንተ ባሪያ ይሁን፤ ");
INSERT INTO amh_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","እንዲሁም የሰው ልጅ ሊያገለግል ነፍሱንም ለብዙዎች ቤዛ ሊሰጥ እንጂ እንዲያገለግሉት አልመጣም። ");
INSERT INTO amh_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ከኢያሪኮም ሲወጡ ብዙ ሕዝብ ተከተሉት። ");
INSERT INTO amh_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","እነሆም፥ ሁለት ዕውሮች በመንገድ ዳር ተቀምጠው፥ ኢየሱስ እንዲያልፍ በሰሙ ጊዜ። ጌታ ሆይ፥ የዳዊት ልጅ፥ ማረን ብለው ጮኹ። ");
INSERT INTO amh_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ሕዝቡም ዝም እንዲሉ ገሠጹአቸው፤ እነርሱ ግን። ጌታ ሆይ፥ የዳዊት ልጅ፥ ማረን እያሉ አብዝተው ጮኹ። ");
INSERT INTO amh_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ኢየሱስም ቆሞ ጠራቸውና። ምን ላደርግላችሁ ትወዳላችሁ? አለ። ");
INSERT INTO amh_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ጌታ ሆይ፥ ዓይኖቻችን ይከፈቱ ዘንድ አሉት። ");
INSERT INTO amh_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ኢየሱስም አዘነላቸውና ዓይኖቻቸውን ዳሰሰ፥ ወዲያውም አዩና ተከተሉት። ");
INSERT INTO amh_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ወደ ኢየሩሳሌምም ቀርበው ወደ ደብረ ዘይት ወደ ቤተ ፋጌ ሲደርሱ፥ ያንጊዜ ኢየሱስ ከደቀ መዛሙርቱ ሁለት ላከ፥ ");
INSERT INTO amh_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","እንዲህም አላቸው። በፊታችሁ ወዳለችው መንደር ሂዱ፥ በዚያን ጊዜም የታሰረችን አህያ ውርንጫም ከእርስዋ ጋር ታገኛላችሁ፤ ፈትታችሁ አምጡልኝ። ");
INSERT INTO amh_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ማንም አንዳች ቢላችሁ። ለጌታ ያስፈልጉታል በሉ፤ ወዲያውም ይሰዳቸዋል። ");
INSERT INTO amh_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","6","ደቀ መዛሙርቱም ሄደው ኢየሱስ እንዳዘዛቸው አደረጉ፥ ");
INSERT INTO amh_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","አህያይቱንና ውርንጫዋንም አመጡለት፥ ልብሳቸውንም በእነርሱ ላይ ጫኑ፥ ተቀመጠባቸውም። ");
INSERT INTO amh_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ከሕዝቡም እጅግ ብዙዎች ልብሳቸውን በመንገድ ላይ አነጠፉ፥ ሌሎችም ከዛፍ ጫፍ ጫፉን እየቈረጡ በመንገድ ላይ ያነጥፉ ነበር። ");
INSERT INTO amh_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","የሚቀድሙትም ሕዝብ የሚከተሉትም። ሆሣዕና ለዳዊት ልጅ በጌታ ስም የሚመጣ የተባረከ ነው፤ ሆሣዕና በአርያም እያሉ ይጮኹ ነበር። ");
INSERT INTO amh_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ወደ ኢየሩሳሌምም በገባ ጊዜ መላው ከተማ። ይህ ማን ነው? ብሎ ተናወጠ። ");
INSERT INTO amh_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ሕዝቡም። ይህ ከገሊላ ናዝሬት የመጣ ነቢዩ ኢየሱስ ነው አሉ። ");
INSERT INTO amh_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ኢየሱስም ወደ መቅደስ ገባና በመቅደስ የሚሸጡትንና የሚገዙትን ሁሉ አወጣ፥ የገንዘብ ለዋጮችንም ገበታዎች የርግብ ሻጮችንም ወንበሮች ገለበጠና። ");
INSERT INTO amh_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ቤቴ የጸሎት ቤት ትባላለች ተብሎ ተጽፎአል፥ እናንተ ግን የወንበዶች ዋሻ አደረጋችኋት አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","በመቅደስም ዕውሮችና አንካሶች ወደ እርሱ ቀረቡና ፈወሳቸው። ");
INSERT INTO amh_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ነገር ግን የካህናት አለቆችና ጻፎች ያደረገውን ድንቃ ድንቅ በመቅደስም። ሆሣዕና ለዳዊት ልጅ እያሉ የሚጮኹትን ልጆች ባዩ ጊዜ፥ ተቈጥተው። ");
INSERT INTO amh_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","እነዚህ የሚሉትን አትሰማምን? አሉት። ኢየሱስም። እሰማለሁ፤ ከሕፃናትና ከሚጠቡት አፍ ምስጋናን ለራስህ አዘጋጀህ የሚለውን ቃል ከቶ አላነበባችሁምን? አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ትቶአቸውም ከከተማ ወደ ቢታንያ ወጣ በዚያም አደረ። ");
INSERT INTO amh_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","በማለዳም ወደ ከተማ ሲመለስ ተራበ። ");
INSERT INTO amh_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","በመንገድም አጠገብ በለስ አይቶ ወደ እርስዋ መጣ፤ ከቅጠልም ብቻ በቀር ምንም አላገኘባትምና። ለዘላለሙ ፍሬ አይገኝብሽ አላት። በለሲቱም ያንጊዜውን ደረቀች። ");
INSERT INTO amh_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ደቀ መዛሙርቱም ይህን አይተው። በለሲቱ ያንጊዜውን እንዴት ደረቀች? ብለው ተደነቁ። ");
INSERT INTO amh_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ኢየሱስም መልሶ። እውነት እላችኋለሁ፥ እምነት ቢኖራችሁ ባትጠራጠሩም፥ በበለሲቱ እንደ ሆነባት ብቻ አታደርጉም፤ ነገር ግን ይህን ተራራ እንኳ። ተነቅለህ ወደ ባሕር ተወርወር ብትሉት ይሆናል፤ ");
INSERT INTO amh_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","አምናችሁም በጸሎት የምትለምኑትን ሁሉ ትቀበላላችሁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ወደ መቅደስም ገብቶ ሲያስተምር የካህናት አለቆችና የሕዝብ ሽማግሎች ወደ እርሱ ቀረቡና። በምን ሥልጣን እነዚህን ታደርጋለህ? ይህንስ ሥልጣን ማን ሰጠህ? አሉት። ");
INSERT INTO amh_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ኢየሱስም መልሶ። እኔ ደግሞ አንዲት ነገር እጠይቃችኋለሁ፤ እናንተም ያችን ብትነግሩኝ እኔ ደግሞ እነዚህን በምን ሥልጣን እንዳደርግ እነግራችኋለሁ፤ ");
INSERT INTO amh_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","የዮሐንስ ጥምቀት ከወዴት ነበረች? ከሰማይን ወይስ ከሰው? አላቸው። እነርሱም እርስ በርሳቸው ሲነጋገሩ። ከሰማይ ብንል። እንኪያስ ስለ ምን አላመናችሁበትም? ይለናል፤ ");
INSERT INTO amh_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ከሰው ግን ብንል፥ ዮሐንስን ሁሉም እንደ ነቢይ ያዩታልና ሕዝቡን እንፈራለን አሉ። ");
INSERT INTO amh_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ለኢየሱስም መልሰው። አናውቅም አሉት። እርሱም ደግሞ። እኔም በምን ሥልጣን እነዚህን እንዳደርግ አልነግራችሁም አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ነገር ግን ምን ይመስላችኋል? አንድ ሰው ሁለት ልጆች ነበሩት፤ ወደ አንደኛው ቀርቦ። ልጄ ሆይ፥ ዛሬ ሂድና በወይኔ አትክልት ሥራ አለው። ");
INSERT INTO amh_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","እርሱም መልሶ። አልወድም አለ፤ ኋላ ግን ተጸጸተና ሄደ። ");
INSERT INTO amh_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ወደ ሁለተኛውም ቀርቦ እንዲሁ አለው እርሱም መልሶ። እሺ ጌታዬ አለ፤ ነገር ግን አልሄደም። ");
INSERT INTO amh_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ከሁለቱ የአባቱን ፈቃድ ያደረገ ማን ነው? ፊተኛው አሉት። ኢየሱስ እንዲህ አላቸው። እውነት እላችኋለሁ፥ ቀራጮችና ጋለሞቶች ወደ እግዚአብሔር መንግሥት በመግባት ይቀድሙአችኋል። ");
INSERT INTO amh_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ዮሐንስ በጽድቅ መንገድ መጥቶላችሁ ነበርና፥ አላመናችሁበትም፤ ቀራጮችና ጋለሞቶች ግን አመኑበት፤ እናንተም ይህን አይታችሁ ታምኑበት ዘንድ በኋላ ንስሐ አልገባችሁም። ");
INSERT INTO amh_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ሌላ ምሳሌ ስሙ። የወይን አትክልት የተከለ ባለቤት ሰው ነበረ፤ ቅጥርም ቀጠረለት፥ መጥመቂያም ማሰለት፥ ግንብም ሠራና ለገበሬዎች አከራይቶ ወደ ሌላ አገር ሄደ። ");
INSERT INTO amh_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","የሚያፈራበትም ጊዜ ሲቀርብ፥ ፍሬውን ሊቀበሉ ባሮቹን ወደ ገበሬዎች ላከ። ");
INSERT INTO amh_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ገበሬዎቹም ባሮቹን ይዘው አንዱን ደበደቡት አንዱንም ገደሉት ሌላውንም ወገሩት። ");
INSERT INTO amh_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ደግሞ ከፊተኞች የሚበዙ ሌሎች ባሮችን ላከ፥ እንዲሁም አደረጉባቸው። ");
INSERT INTO amh_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","በኋላ ግን። ልጄንስ ያፍሩታል ብሎ ልጁን ላከባቸው። ");
INSERT INTO amh_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ገበሬዎቹ ግን ልጁን ባዩ ጊዜ እርስ በርሳቸው። ወራሹ ይህ ነው፤ ኑ፥ እንግደለውና ርስቱን እናግኝ ተባባሉ። ");
INSERT INTO amh_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ይዘውም ከወይኑ አትክልት አወጡና ገደሉት። ");
INSERT INTO amh_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","እንግዲህ የወይኑ አትክልት ጌታ በሚመጣ ጊዜ በእነዚህ ገበሬዎች ምን ያደርግባቸዋል? ");
INSERT INTO amh_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","እነርሱም። ክፉዎችን በክፉ ያጠፋቸዋል፥ የወይኑንም አትክልት ፍሬውን በየጊዜው ለሚያስረክቡ ለሌሎች ገበሬዎች ይሰጠዋል አሉት። ");
INSERT INTO amh_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ኢየሱስ እንዲህ አላቸው። ግንበኞች የናቁት ድንጋይ እርሱ የማዕዘን ራስ ሆነ፤ ይህም ከጌታ ዘንድ ሆነ፥ ለዓይኖቻችንም ድንቅ ነው የሚለውን ከቶ በመጽሐፍ አላነበባችሁምን? ");
INSERT INTO amh_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","ስለዚህ እላችኋለሁ፥ የእግዚአብሔር መንግሥት ከእናንተ ትወሰዳለች ፍሬዋንም ለሚያደርግ ሕዝብ ትሰጣለች። ");
INSERT INTO amh_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","በዚህም ድንጋይ ላይ የሚወድቅ ይቀጠቀጣል፤ ድንጋዩ ግን የሚወድቅበትን ሁሉ ይፈጨዋል። ");
INSERT INTO amh_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","የካህናት አለቆችና ፈሪሳውያንም ምሳሌዎቹን ሰምተው ስለ እነርሱ እንደ ተናገረ አስተዋሉ፤ ");
INSERT INTO amh_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ሊይዙትም ሲፈልጉት ሳሉ ሕዝቡ እንደ ነቢይ ስላዩት ፈሩአቸው። ");
INSERT INTO amh_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ኢየሱስም መለሰ ደግሞም በምሳሌ ነገራቸው እንዲህም አለ። ");
INSERT INTO amh_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","መንግሥተ ሰማያት ለልጁ ሰርግ ያደረገ ንጉሥን ትመስላለች። ");
INSERT INTO amh_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","የታደሙትንም ወደ ሰርጉ ይጠሩ ዘንድ ባሮቹን ላከ ሊመጡም አልወደዱም። ");
INSERT INTO amh_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ደግሞ ሌሎችን ባሮች ልኮ። የታደሙትን። እነሆ፥ ድግሴን አዘጋጀሁ፥ ኮርማዎቼና የሰቡት ከብቶቼ ታርደዋል፥ ሁሉም ተዘጋጅቶአል፤ ወደ ሰርጉ ኑ በሉአቸው አለ። ");
INSERT INTO amh_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","እነርሱ ግን ቸል ብለው አንዱ ወደ እርሻው፥ ሌላውም ወደ ንግዱ ሄደ፤ ");
INSERT INTO amh_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","የቀሩትም ባሮቹን ይዘው አንገላቱአቸው ገደሉአቸውም። ");
INSERT INTO amh_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ንጉሡም ተቈጣ፥ ጭፍሮቹንም ልኮ እነዚያን ገዳዮች አጠፋ፤ ከተማቸውንም አቃጠለ። ");
INSERT INTO amh_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","በዚያን ጊዜ ባሮቹን። ሰርጉስ ተዘጋጅቶአል፥ ነገር ግን የታደሙት የማይገባቸው ሆኑ፤ ");
INSERT INTO amh_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","እንግዲህ ወደ መንገድ መተላለፊያ ሄዳችሁ ያገኛችሁትን ሁሉ ወደ ሰርጉ ጥሩ አለ። ");
INSERT INTO amh_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","እነዚያም ባሮች ወደ መንገድ ወጥተው ያገኙትን ሁሉ ክፉዎችንም በጎዎችንም ሰበሰቡ፤ የሰርጉንም ቤት ተቀማጮች ሞሉት። ");
INSERT INTO amh_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","ንጉሡም የተቀመጡትን ለማየት በገባ ጊዜ በዚያ የሰርግ ልብስ ያለበሰ አንድ ሰው አየና። ወዳጄ ሆይ፥ ");
INSERT INTO amh_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","የሰርግ ልብስ ሳትለብስ እንዴት ወደዚህ ገባህ? አለው እርሱም ዝም አለ። ");
INSERT INTO amh_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","በዚያን ጊዜ ንጉሡ አገልጋዮቹን። እጁንና እግሩን አስራችሁ በውጭ ወዳለው ጨለማ አውጡት፤ በዚያ ልቅሶና ጥርስ ማፋጨት ይሆናል አለ። ");
INSERT INTO amh_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","የተጠሩ ብዙዎች፥ የተመረጡ ግን ጥቂቶች ናቸውና። ");
INSERT INTO amh_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ስለዚህ ፈሪሳውያን ሄዱና እንዴት አድርገው በነገር እንዲያጠምዱት ተማከሩ። ");
INSERT INTO amh_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ደቀ መዛሙርታቸውንም ከሄሮድስ ወገን ጋር ላኩበት፥ እነርሱም። መምህር ሆይ፥ እውነተኛ እንደ ሆንህ በእውነትም የእግዚአብሔርን መንገድ እንድታስተምር እናውቃለን፥ ለማንምም አታደላም፥ የሰውን ፊት አትመለከትምና፤ ");
INSERT INTO amh_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","እንግዲህ ምን ይመስልሃል? ንገረን ለቄሣር ግብር መስጠት ተፈቅዶአልን ወይስ አልተፈቀደም? አሉት። ");
INSERT INTO amh_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ኢየሱስም ክፋታቸውን አውቆ። እናንተ ግብዞች፥ ስለ ምን ትፈትኑኛላችሁ? ");
INSERT INTO amh_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","የግብሩን ብር አሳዩኝ አለ። እነርሱም ዲናር አመጡለት። ");
INSERT INTO amh_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","እርሱም። ይህች መልክ ጽሕፈቲቱስ የማን ናት? አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","የቄሣር ነው አሉት። በዚያን ጊዜ። እንኪያስ የቄሣርን ለቄሣር የእግዚአብሔርንም ለእግዚአብሔር አስረክቡ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ይህንም ሰምተው ተደነቁ፥ ትተውትም ሄዱ። ");
INSERT INTO amh_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","በዚያን ቀን። ትንሣኤ ሙታን የለም የሚሉ ሰዱቃውያን ወደ እርሱ ቀረቡ፥ ");
INSERT INTO amh_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","እንዲህም ብለው ጠየቁት። መምህር ሆይ፥ ሙሴ አንድ ሰው ልጅ ሳይወልድ ሲሞት ወንድሙ ሚስቱን አግብቶ ለወንድሙ ዘር ይተካ አለ። ");
INSERT INTO amh_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ሰባት ወንድማማች በእኛ ዘንድ ነበሩ፤ ፊተኛውም ሚስት አግብቶ ሞተ፥ ዘርም ስለሌለው ሚስቱን ለወንድሙ ተወለት፤ ");
INSERT INTO amh_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","እንዲሁ ደግሞ ሁለተኛው ሦስተኛውም፥ እስከ ሰባተኛው ድረስ። ");
INSERT INTO amh_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ከሁሉም በኋላ ሴቲቱ ሞተች። ");
INSERT INTO amh_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ሁሉ አግብተዋታልና በትንሣኤ ቀንስ፥ ከሰባቱ ለማናቸው ሚስት ትሆናለች? ");
INSERT INTO amh_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ኢየሱስም መልሶ እንዲህ አላቸው። መጻሕፍትንና የእግዚአብሔርን ኃይል አታውቁምና ትስታላችሁ። ");
INSERT INTO amh_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","በትንሣኤስ እንደ እግዚአብሔር መላእክት በሰማይ ይሆናሉ እንጂ አያገቡም አይጋቡምም። ");
INSERT INTO amh_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","33","ሕዝቡም ይህን ሰምተው በትምህርቱ ተገረሙ። ");
INSERT INTO amh_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ፈሪሳውያንም ሰዱቃውያንን ዝም እንዳሰኛቸው በሰሙ ጊዜ አብረው ተሰበሰቡ። ");
INSERT INTO amh_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ከእነርሱም አንድ ሕግ አዋቂ ሊፈትነው። ");
INSERT INTO amh_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","መምህር ሆይ፥ ከሕግ ማናቸይቱ ትእዛዝ ታላቅ ናት? ብሎ ጠየቀው። ");
INSERT INTO amh_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ኢየሱስም እንዲህ አለው። ጌታ አምላክህን በፍጹም ልብህ በፍጹም ነፍስህም በፍጹም አሳብህም ውደድ። ");
INSERT INTO amh_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ታላቂቱና ፊተኛይቱ ትእዛዝ ይህች ናት። ");
INSERT INTO amh_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ሁለተኛይቱም ይህችን ትመስላለች፥ እርስዋም። ባልንጀራህን እንደ ነፍስህ ውደድ የምትለው ናት። ");
INSERT INTO amh_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","በእነዚህ በሁለቱ ትእዛዛት ሕጉም ሁሉ ነቢያትም ተሰቅለዋል። ");
INSERT INTO amh_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","45","ዳዊትስ ጌታ ብሎ ከጠራው፥ እንዴት ልጁ ይሆናል? አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","አንድም ቃል ስንኳ ይመልስለት ዘንድ የተቻለው የለም፥ ከዚያ ቀንም ጀምሮ ወደ ፊት ማንም ሊጠይቀው አልደፈረም። ");
INSERT INTO amh_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","በዚያን ጊዜ ኢየሱስ ለሕዝቡና ለደቀ መዛሙርቱ እንዲህ ብሎ ነገራቸው። ");
INSERT INTO amh_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","ጻፎችና ፈሪሳውያን በሙሴ ወንበር ተቀምጠዋል። ");
INSERT INTO amh_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ስለዚህ ያዘዙአችሁን ሁሉ አድርጉ ጠብቁትም፥ ነገር ግን እየተናገሩ አያደርጉትምና እንደ ሥራቸው አታድርጉ። ");
INSERT INTO amh_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ከባድና አስቸጋሪ ሸክም ተብትበው በሰው ትከሻ ይጭናሉ፥ እነርሱ ግን በጣታቸው ስንኳ ሊነኩት አይወዱም። ");
INSERT INTO amh_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ለሰውም እንዲታዩ ሥራቸውን ሁሉ ያደርጋሉ፤ ስለዚህ አሽንክታባቸውን ያሰፋሉ ዘርፉንም ያስረዝማሉ፥ ");
INSERT INTO amh_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","በምሳም የከበሬታ ስፍራ፥ በምኵራብም የከበሬታ ወንበር፥ ");
INSERT INTO amh_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","በገበያም ሰላምታና። መምህር ሆይ መምህር ሆይ ተብለው እንዲጠሩ ይወዳሉ። ");
INSERT INTO amh_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","እናንተ ግን። መምህር ተብላችሁ አትጠሩ፤ መምህራችሁ አንድ ስለ ሆነ እናንተም ሁላችሁ ወንድማማች ናችሁ። ");
INSERT INTO amh_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","አባታችሁ አንዱ እርሱም የሰማዩ ነውና በምድር ላይ ማንንም። አባት ብላችሁ አትጥሩ። ");
INSERT INTO amh_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ሊቃችሁ አንድ እርሱም ክርስቶስ ነውና። ሊቃውንት ተብላችሁ አትጠሩ። ");
INSERT INTO amh_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ከእናንተም የሚበልጠው አገልጋያችሁ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ራሱን ከፍ የሚያደርግ ሁሉ ይዋረዳል፥ ራሱንም የሚያዋርድ ሁሉ ከፍ ይላል። ");
INSERT INTO amh_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","እናንተ ግብዞች ጻፎችና ፈሪሳውያን፥ መንግሥተ ሰማያትን በሰው ፊት ስለምትዘጉ፥ ወዮላችሁ እናንተ አትገቡም የሚገቡትንም እንዳይገቡ ትከለክላላችሁ። ");
INSERT INTO amh_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","እናንተ ግብዞች ጻፎችና ፈሪሳውያን፥ በጸሎት ርዝመት እያመካኛችሁ የመበለቶችን ቤት ስለምትበሉ፥ ወዮላችሁ፤ ስለዚህ የባሰ ፍርድ ትቀበላላችሁ። ");
INSERT INTO amh_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","እናንተ ግብዞች ጻፎችና ፈሪሳውያን፥ አንድ ሰው ልታሳምኑ በባሕርና በደረቅ ስለምትዞሩ፥ በሆነም ጊዜ ከእናንተ ይልቅ ሁለት እጥፍ የባሰ የገሃነም ልጅ ስለምታደርጉት፥ ወዮላችሁ። ");
INSERT INTO amh_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","እናንተ። ማንም በቤተ መቅደስ የሚምል ምንም የለበትም፤ ማንም በቤተ መቅደስ ወርቅ የሚምል ግን በመሐላው ይያዛል የምትሉ፥ ዕውሮች መሪዎች፥ ወዮላችሁ። ");
INSERT INTO amh_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","እናንተ ደንቆሮዎችና ዕውሮች፥ ማናቸው ይበልጣል? ወርቁ ነውን? ወይስ ወርቁን የቀደሰው ቤተ መቅደስ? ");
INSERT INTO amh_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ደግማችሁም። ማንም በመሠዊያው የሚምል ምንም የለበትም፤ ማንም በላዩ ባለው መባ የሚምል ግን በመሐላው ይያዛል ትላላችሁ። ");
INSERT INTO amh_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","እናንተ ደንቆሮዎችና ዕውሮች፥ ማናቸው ይበልጣል? መባው ነውን? ወይስ መባውን የሚቀድሰው መሠዊያው? ");
INSERT INTO amh_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","እንግዲህ በመሠዊያው የሚምለው በእርሱና በእርሱ ላይ ባለው ሁሉ ይምላል፤ ");
INSERT INTO amh_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","በቤተ መቅደስም የሚምለው በእርሱና በእርሱ በሚኖረው ይምላል፤ ");
INSERT INTO amh_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","በሰማይም የሚምለው በእግዚአብሔር ዙፋንና በእርሱ ላይ በተቀመጠው ይምላል። ");
INSERT INTO amh_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","እናንተ ግብዞች ጻፎችና ፈሪሳውያን፥ ከአዝሙድና ከእንስላል ከከሙንም አሥራት ስለምታወጡ፥ ፍርድንና ምሕረትን ታማኝነትንም፥ በሕግ ያለውን ዋና ነገር ስለምትተዉ፥ ወዮላችሁ፤ ሌላውን ሳትተዉ ይህን ልታደርጉ ይገባችሁ ነበር። ");
INSERT INTO amh_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","እናንተ ዕውሮች መሪዎች፥ ትንኝን የምታጠሩ ግመልንም የምትውጡ። ");
INSERT INTO amh_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","እናንተ ግብዞች ጻፎችና ፈሪሳውያን፥ በውስጡ ቅሚያና ስስት ሞልቶ ሳለ የጽዋውንና የወጭቱን ውጭ ስለምታጠሩ፥ ወዮላችሁ። ");
INSERT INTO amh_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","አንተ ዕውር ፈሪሳዊ፥ ውጭው ደግሞ ጥሩ እንዲሆን አስቀድመህ የጽዋውንና የወጭቱን ውስጡን አጥራ። ");
INSERT INTO amh_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","እናንተ ግብዞች ጻፎችና ፈሪሳውያን፥ በውጭ አምረው የሚታዩ በውስጡ ግን የሙታን አጥንት ርኩሰትም ሁሉ የተሞሉ በኖራ የተለሰኑ መቃብሮችን ስለምትመስሉ፥ ወዮላችሁ። ");
INSERT INTO amh_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","እንዲሁ እናንተ ደግሞ በውጭ ለሰው እንደ ጻድቃን ትታያላችሁ፥ በውስጣችሁ ግን ግብዝነትና ዓመፀኝነት ሞልቶባችኋል። ");
INSERT INTO amh_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","እናንተ ግብዞች ጻፎችና ፈሪሳውያን፥ የነቢያትን መቃብር ስለምትሠሩ የጻድቃንንም መቃብር ስለምታስጌጡና። ");
INSERT INTO amh_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","በአባቶቻችን ዘመን ኖረን በሆነስ በነቢያት ደም ባልተባበርናቸውም ነበር ስለምትሉ፥ ወዮላችሁ። ");
INSERT INTO amh_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","እንግዲያስ የነቢያት ገዳዮች ልጆች እንደሆናችሁ በራሳችሁ ላይ ትመሰክራላችሁ። ");
INSERT INTO amh_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","እናንተ ደግሞ የአባቶቻችሁን መስፈሪያ ሙሉ። ");
INSERT INTO amh_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","እናንተ እባቦች፥ የእፉኝት ልጆች፥ ከገሃነም ፍርድ እንዴት ታመልጣላችሁ? ");
INSERT INTO amh_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ስለዚህ፥ እነሆ፥ ነቢያትንና ጥበበኞችን ጻፎችንም ወደ እናንተ እልካለሁ፤ ከእነርሱም ትገድላላችሁ ትሰቅሉማላችሁ፥ ከእነርሱም በምኵራባችሁ ትገርፋላችሁ ከከተማም ወደ ከተማ ታሳድዳላችሁ፤ ");
INSERT INTO amh_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ከጻድቁ ከአቤል ደም ጀምሮ በቤተ መቅደስና በመሠዊያው መካከል እስከ ገደላችሁት እስከ በራክዩ ልጅ እስከ ዘካርያስ ደም ድረስ በምድር ላይ የፈሰሰው የጻድቅ ደም ሁሉ ይደርስባችሁ ዘንድ። ");
INSERT INTO amh_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","እውነት እላችኋለሁ፥ ይህ ሁሉ በዚህ ትውልድ ላይ ይደርሳል። ");
INSERT INTO amh_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ኢየሩሳሌም ኢየሩሳሌም ሆይ፥ ነቢያትን የምትገድል ወደ እርስዋ የተላኩትንም የምትወግር፥ ዶሮ ጫጩቶችዋን ከክንፎችዋ በታች እንደምትሰበስብ ልጆችሽን እሰበስብ ዘንድ ስንት ጊዜ ወደድሁ! አልወደዳችሁምም። ");
INSERT INTO amh_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","እነሆ፥ ቤታችሁ የተፈታ ሆኖ ይቀርላችኋል። ");
INSERT INTO amh_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","እላችኋለሁና፥ በጌታ ስም የሚመጣ የተባረከ ነው እስክትሉ ድረስ ከእንግዲህ ወዲህ አታዩኝም። ");
INSERT INTO amh_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ኢየሱስም ከመቅደስ ወጥቶ ሄደ፥ ደቀ መዛሙርቱም የመቅደሱን ግንቦች ሊያሳዩት ቀረቡ። ");
INSERT INTO amh_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","እርሱ ግን መልሶ። ይህን ሁሉ ታያላችሁን? እውነት እላችኋለሁ፥ ድንጋይ በድንጋይ ላይ ሳይፈርስ በዚህ አይቀርም አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","እርሱም በደብረ ዘይት ተቀምጦ ሳለ፥ ደቀ መዛሙርቱ ለብቻቸው ወደ እርሱ ቀርበው። ንገረን፥ ይህ መቼ ይሆናል? የመምጣትህና የዓለም መጨረሻ ምልክቱስ ምንድር ነው? አሉት። ");
INSERT INTO amh_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ኢየሱስም መልሶ እንዲህ አላቸው። ማንም እንዳያስታችሁ ተጠንቀቁ። ");
INSERT INTO amh_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ብዙዎች። እኔ ክርስቶስ ነኝ እያሉ በስሜ ይመጣሉና፤ ብዙዎችንም ያስታሉ። ");
INSERT INTO amh_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ጦርንም የጦርንም ወሬ ትሰሙ ዘንድ አላችሁ፤ ይህ ሊሆን ግድ ነውና ተጠበቁ፥ አትደንግጡ፤ ዳሩ ግን መጨረሻው ገና ነው። ");
INSERT INTO amh_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ሕዝብ በሕዝብ ላይ መንግሥትም በመንግሥት ላይ ይነሣልና፥ ራብም ቸነፈርም የምድርም መናወጥ በልዩ ልዩ ስፍራ ይሆናል፤ ");
INSERT INTO amh_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","እነዚህም ሁሉ የምጥ ጣር መጀመሪያ ናቸው። ");
INSERT INTO amh_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","በዚያን ጊዜ ለመከራ አሳልፈው ይሰጡአችኋል ይገድሉአችሁማል፥ ስለ ስሜም በአሕዛብ ሁሉ የተጠላችሁ ትሆናላችሁ። ");
INSERT INTO amh_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","በዚያን ጊዜም ብዙዎች ይሰናከላሉ እርስ በርሳቸውም አሳልፈው ይሰጣጣሉ እርስ በርሳቸውም ይጣላሉ፤ ");
INSERT INTO amh_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ብዙ ሐሰተኞች ነቢያትም ይነሣሉ ብዙዎችንም ያስታሉ፤ ");
INSERT INTO amh_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ከዓመፃም ብዛት የተነሣ የብዙ ሰዎች ፍቅር ትቀዘቅዛለች። ");
INSERT INTO amh_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","እስከ መጨረሻ የሚጸና ግን እርሱ ይድናል። ");
INSERT INTO amh_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ለአሕዛብም ሁሉ ምስክር እንዲሆን ይህ የመንግሥት ወንጌል በዓለም ሁሉ ይሰበካል፥ በዚያን ጊዜም መጨረሻው ይመጣል። ");
INSERT INTO amh_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","እንግዲህ በነቢዩ በዳንኤል የተባለውን የጥፋትን ርኩሰት በተቀደሰችው ስፍራ ቆሞ ስታዩ፥ አንባቢው ያስተውል፥ ");
INSERT INTO amh_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","በዚያን ጊዜ በይሁዳ ያሉት ወደ ተራራዎች ይሽሹ፥ ");
INSERT INTO amh_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","በሰገነትም ያለ በቤቱ ያለውን ሊወስድ አይውረድ፥ ");
INSERT INTO amh_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","በእርሻም ያለ ልብሱን ይወስድ ዘንድ ወደ ኋላው አይመለስ። ");
INSERT INTO amh_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","በዚያችም ወራት ለርጉዞችና ለሚያጠቡ ወዮላቸው። ");
INSERT INTO amh_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ነገር ግን ሽሽታችሁ በክረምት ወይም በሰንበት እንዳይሆን ጸልዩ፤ ");
INSERT INTO amh_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","በዚያን ጊዜ ከዓለም መጀመሪያ ጀምሮ እስከ ዛሬ ድረስ ያልሆነ እንግዲህም ከቶ የማይሆን ታላቅ መከራ ይሆናልና። ");
INSERT INTO amh_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","እነዚያ ቀኖችስ ባያጥሩ ሥጋ የለበሰ ሁሉ ባልዳነም ነበር፤ ነገር ግን እነዚያ ቀኖች ስለ ተመረጡት ሰዎች ያጥራሉ። ");
INSERT INTO amh_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","በዚያን ጊዜ ማንም። እነሆ፥ ክርስቶስ ከዚህ አለ ወይም። ከዚያ አለ ቢላችሁ አትመኑ፤ ");
INSERT INTO amh_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ሐሰተኞች ክርስቶሶችና ሐሰተኞች ነቢያት ይነሣሉና፥ ቢቻላቸውስ የተመረጡትን እንኳ እስኪያስቱ ድረስ ታላላቅ ምልክትና ድንቅ ያሳያሉ። ");
INSERT INTO amh_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","እነሆ፥ አስቀድሜ ነገርኋችሁ። ");
INSERT INTO amh_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","እንግዲህ። እነሆ፥ በበረሀ ነው ቢሉአችሁ፥ አትውጡ፤ እነሆ፥ በእልፍኝ ነው ቢሉአችሁ፥ አትመኑ፤ ");
INSERT INTO amh_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","መብረቅ ከምሥራቅ ወጥቶ እስከ ምዕራብ እንደሚታይ፥ የሰው ልጅ መምጣት እንዲሁ ይሆናልና፤ ");
INSERT INTO amh_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","በድን ወዳለበት በዚያ አሞራዎች ይሰበሰባሉ። ");
INSERT INTO amh_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ከዚያች ወራትም መከራ በኋላ ወዲያው ፀሐይ ይጨልማል፥ ጨረቃም ብርሃንዋን አትሰጥም፥ ከዋክብትም ከሰማይ ይወድቃሉ፥ ");
INSERT INTO amh_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","የሰማያትም ኃይላት ይናወጣሉ። በዚያን ጊዜም የሰው ልጅ ምልክት በሰማይ ይታያል፥ በዚያን ጊዜም የምድር ወገኖች ሁሉ ዋይ ዋይ ይላሉ፥ የሰው ልጅንም በኃይልና በብዙ ክብር በሰማይ ደመና ሲመጣ ያዩታል፤ ");
INSERT INTO amh_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","መላእክቱንም ከታላቅ መለከት ድምፅ ጋር ይልካቸዋል፥ ከሰማያትም ዳርቻ እስከ ዳርቻው ከአራቱ ነፋሳት ለእርሱ የተመረጡትን ይሰበስባሉ። ");
INSERT INTO amh_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ምሳሌውንም ከበለስ ተማሩ፤ ጫፍዋ ሲለሰልስ ቅጠልዋም ሲያቈጠቍጥ፥ ያን ጊዜ በጋ እንደ ቀረበ ታውቃላችሁ፤ ");
INSERT INTO amh_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","እንዲሁ እናንተ ደግሞ ይህን ሁሉ ስታዩ በደጅ እንደ ቀረበ እወቁ። ");
INSERT INTO amh_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","እውነት እላችኋለሁ፥ ይህ ሁሉ እስኪሆን ድረስ ይህ ትውልድ አያልፍም። ");
INSERT INTO amh_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ሰማይና ምድር ያልፋሉ፥ ቃሌ ግን አያልፍም። ");
INSERT INTO amh_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ስለዚያች ቀንና ስለዚያች ሰዓት ግን ከአባት ብቻ በቀር የሰማይ መላእክትም ቢሆኑ ልጅም ቢሆን የሚያውቅ የለም። ");
INSERT INTO amh_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","የኖኅ ዘመን እንደ ነበረ የሰው ልጅ መምጣት እንዲሁ ይሆናልና። ");
INSERT INTO amh_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","በዚያች ወራት ከጥፋት ውኃ በፊት፥ ኖኅ ወደ መርከብ እስከገባበት ቀን ድረስ፥ ሲበሉና ሲጠጡ ሲያገቡና ሲጋቡም እንደ ነበሩ፥ ");
INSERT INTO amh_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","የጥፋት ውኃም መጥቶ ሁሉን እስከ ወሰደ ድረስ እንዳላወቁ፥ የሰው ልጅ መምጣት ደግሞ እንዲሁ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","በዚያን ጊዜ ሁለት ሰዎች በእርሻ ይሆናሉ፤ አንዱ ይወሰዳል አንዱም ይቀራል፤ ");
INSERT INTO amh_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ሁለት ሴቶች በወፍጮ ይፈጫሉ፤ አንዲቱ ትወሰዳለች አንዲቱም ትቀራለች። ");
INSERT INTO amh_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ጌታችሁ በምን ሰዓት እንዲመጣ አታውቁምና እንግዲህ ንቁ። ");
INSERT INTO amh_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ያን ግን እወቁ፤ ባለቤት ከሌሊቱ በየትኛው ክፍል ሌባ እንዲመጣ ቢያውቅ ኖሮ፥ በነቃ ቤቱም ሊቈፈር ባልተወም ነበር። ");
INSERT INTO amh_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ስለዚህ እናንተ ደግሞ ተዘጋጅታችሁ ኑሩ፥ የሰው ልጅ በማታስቡበት ሰዓት ይመጣልና። ");
INSERT INTO amh_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","እንኪያስ ምግባቸውን በጊዜው ይሰጣቸው ዘንድ ጌታው በቤተ ሰዎች ላይ የሾመው ታማኝና ልባም ባሪያ ማን ነው? ");
INSERT INTO amh_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ጌታው መጥቶ እንዲህ ሲያደርግ የሚያገኘው ያ ባሪያ ብፁዕ ነው፤ ");
INSERT INTO amh_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","እውነት እላችኋለሁ፥ ባለው ሁሉ ላይ ይሾመዋል። ");
INSERT INTO amh_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ያ ክፉ ባሪያ ግን። ጌታዬ እስኪመጣ ይዘገያል ብሎ በልቡ ቢያስብ፥ ");
INSERT INTO amh_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ባልንጀሮቹን ባሮች ሊመታ ቢጀምር ከሰካሮችም ጋር ቢበላና ቢጠጣ፥ ");
INSERT INTO amh_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","የዚያ ባሪያ ጌታ ባልጠበቃት ቀን ባላወቃትም ሰዓት ይመጣል፥ ");
INSERT INTO amh_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ከሁለትም ይሰነጥቀዋል፥ እድሉንም ከግብዞች ጋር ያደርግበታል፤ በዚያ ልቅሶና ጥርስ ማፋጨት ይሆናል። ");
INSERT INTO amh_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","በዚያን ጊዜ መንግሥተ ሰማያት መብራታቸውን ይዘው ሙሽራውን ሊቀበሉ የወጡ አሥር ቆነጃጅትን ትመስላለች። ");
INSERT INTO amh_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ከእነርሱም አምስቱ ሰነፎች አምስቱም ልባሞች ነበሩ። ");
INSERT INTO amh_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ሰነፎቹ መብራታቸውን ይዘው ከእነርሱ ጋር ዘይት አልያዙምና፤ ");
INSERT INTO amh_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ልባሞቹ ግን ከመብራታቸው ጋር በማሰሮአቸው ዘይት ያዙ። ");
INSERT INTO amh_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ሙሽራውም በዘገየ ጊዜ ሁሉ እንቅልፍ እንቅልፍ አላቸውና ተኙ። ");
INSERT INTO amh_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","እኩል ሌሊትም ሲሆን። እነሆ፥ ሙሽራው ይመጣል፥ ትቀበሉት ዘንድ ውጡ የሚል ውካታ ሆነ። ");
INSERT INTO amh_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","በዚያን ጊዜ እነዚያ ቆነጃጅት ሁሉ ተነሡና መብራታቸውን አዘጋጁ። ");
INSERT INTO amh_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ሰነፎቹም ልባሞቹን። መብራታችን ሊጠፋብን ነው፤ ከዘይታችሁ ስጡን አሉአቸው። ");
INSERT INTO amh_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ልባሞቹ ግን መልሰው። ምናልባት ለእኛና ለእናንተ ባይበቃስ፤ ይልቅስ ወደሚሸጡት ሄዳችሁ ለራሳችሁ ግዙ አሉአቸው። ");
INSERT INTO amh_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ሊገዙም በሄዱ ጊዜ ሙሽራው መጣ፥ ተዘጋጅተው የነበሩትም ከእርሱ ጋር ወደ ሰርግ ገቡ፥ ደጁም ተዘጋ። ");
INSERT INTO amh_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","በኋላም ደግሞ የቀሩቱ ቈነጃጅት መጡና። ጌታ ሆይ ጌታ ሆይ፥ ክፈትልን አሉ። ");
INSERT INTO amh_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","እርሱ ግን መልሶ። እውነት እላችኋለሁ፥ አላውቃችሁም አለ። ");
INSERT INTO amh_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ቀኒቱንና ሰዓቲቱን አታውቁምና እንግዲህ ንቁ። ");
INSERT INTO amh_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ወደ ሌላ አገር የሚሄድ ሰው ባሮቹን ጠርቶ ያለውን ገንዘብ እንደ ሰጣቸው እንዲሁ ይሆናልና፤ ");
INSERT INTO amh_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ለእያንዳንዱ እንደ ዓቅሙ፥ ለአንዱ አምስት መክሊት ለአንዱ ሁለት ለአንዱም አንድ ሰጠና ወደ ሌላ አገር ወዲያው ሄደ። ");
INSERT INTO amh_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","አምስት መክሊትም የተቀበለው ሄዶ ነገደበት ሌላም አምስት አተረፈ፤ ");
INSERT INTO amh_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","እንዲሁም ሁለት የተቀበለው ሌላ ሁለት አተረፈ። ");
INSERT INTO amh_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","አንድ የተቀበለው ግን ሄዶ ምድርን ቈፈረና የጌታውን ገንዘብ ቀበረ። ");
INSERT INTO amh_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ከብዙ ዘመንም በኋላ የእነዚያ ባሮች ጌታ መጣና ተቆጣጠራቸው። ");
INSERT INTO amh_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","አምስት መክሊት የተቀበለውም ቀረበና ሌላ አምስት መክሊት አስረክቦ። ጌታ ሆይ፥ አምስት መክሊት ሰጥተኸኝ ነበር፤ እነሆ፥ ሌላ አምስት መክሊት አተረፍሁበት አለ። ");
INSERT INTO amh_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ጌታውም። መልካም፥ አንተ በጎ ታማኝም ባሪያ፤ በጥቂቱ ታምነሃል፥ በብዙ እሾምሃለሁ፤ ወደ ጌታህ ደስታ ግባ አለው። ");
INSERT INTO amh_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ሁለት መክሊትም የተቀበለው ደግሞ ቀርቦ። ጌታ ሆይ፥ ሁለት መክሊት ሰጥተኸኝ ነበር፤ እነሆ፥ ሌላ ሁለት መክሊት አተረፍሁበት አለ። ");
INSERT INTO amh_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ጌታውም። መልካም፥ አንተ በጎ፥ ታማኝም ባሪያ፤ በጥቂቱ ታምነሃል፥ በብዙ እሾምሃለሁ፥ ወደ ጌታህ ደስታ ግባ አለው። ");
INSERT INTO amh_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","አንድ መክሊትም የተቀበለው ደግሞ ቀርቦ። ጌታ ሆይ፥ ካልዘራህባት የምታጭድ ካልበተንህባትም የምትሰበስብ ጨካኝ ሰው መሆንህን አውቃለሁ፤ ");
INSERT INTO amh_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ፈራሁም ሄጄም መክሊትህን በምድር ቀበርሁት፤ እነሆ፥ መክሊትህ አለህ አለ። ");
INSERT INTO amh_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ጌታውም መልሶ እንዲህ አለው። አንተ ክፉና ሃኬተኛ ባሪያ፥ ካልዘራሁባት እንዳጭድ ካልበተንሁባትም እንድሰበስብ ታውቃለህን? ");
INSERT INTO amh_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ስለዚህ ገንዘቤን ለለዋጮች አደራ ልትሰጠው በተገባህ ነበር፥ እኔም መጥቼ ያለኝን ከትርፉ ጋር እወስደው ነበር። ");
INSERT INTO amh_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ስለዚህ መክሊቱን ውሰዱበት አሥር መክሊትም ላለው ስጡት፤ ");
INSERT INTO amh_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ላለው ሁሉ ይሰጠዋልና ይበዛለትማል፤ ከሌለው ግን ያው ያለው እንኳ ይወሰድበታል። ");
INSERT INTO amh_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","የማይጠቅመውንም ባሪያ በውጭ ወዳለው ጨለማ አውጡት፤ በዚያ ልቅሶና ጥርስ ማፋጨት ይሆናል። ");
INSERT INTO amh_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","የሰው ልጅ በክብሩ በሚመጣበት ጊዜ ከእርሱም ጋር ቅዱሳን መላእክቱ ሁሉ፥ በዚያን ጊዜ በክብሩ ዙፋን ይቀመጣል፤ ");
INSERT INTO amh_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","አሕዛብም ሁሉ በፊቱ ይሰበሰባሉ፤ እረኛም በጎቹን ከፍየሎች እንደሚለይ እርስ በርሳቸው ይለያቸዋል፥ ");
INSERT INTO amh_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","በጎችን በቀኙ ፍየሎችንም በግራው ያቆማቸዋል። ");
INSERT INTO amh_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ንጉሡም በቀኙ ያሉትን እንዲህ ይላቸዋል። እናንተ የአባቴ ቡሩካን፥ ኑ፤ ዓለም ከተፈጠረበት ጊዜ ጀምሮ የተዘጋጀላችሁን መንግሥት ውረሱ። ");
INSERT INTO amh_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ተርቤ አብልታችሁኛልና፥ ተጠምቼ አጠጥታችሁኛልና፥ እንግዳ ሆኜ ተቀብላችሁኛልና፥ ታርዤ አልብሳችሁኛልና፥ ");
INSERT INTO amh_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ታምሜ ጠይቃችሁኛልና፥ ታስሬ ወደ እኔ መጥታችኋልና። ");
INSERT INTO amh_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ጻድቃንም መልሰው ይሉታል። ጌታ ሆይ፥ ተርበህ አይተን መቼ አበላንህስ? ወይስ ተጠምተህ አይተን መቼ አጠጣንህ? ");
INSERT INTO amh_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","እንግዳ ሆነህስ አይተን መቼ ተቀበልንህ? ወይስ ታርዘህ አይተን መቼ አለበስንህ? ");
INSERT INTO amh_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ወይስ ታመህ ወይስ ታስረህ አይተን መቼ ወደ አንተ መጣን? ");
INSERT INTO amh_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ንጉሡም መልሶ። እውነት እላችኋለሁ፥ ከሁሉ ከሚያንሱ ከእነዚህ ወንድሞቼ ለአንዱ እንኳ ስላደረጋችሁት ለእኔ አደረጋችሁት ይላቸዋል። ");
INSERT INTO amh_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","በዚያን ጊዜ በግራው ያሉትን ደግሞ ይላቸዋል። እናንተ ርጉማን፥ ለሰይጣንና ለመላእክቱ ወደ ተዘጋጀ ወደ ዘላለም እሳት ከእኔ ሂዱ። ");
INSERT INTO amh_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ተርቤ አላበላችሁኝምና፥ ተጠምቼ አላጠጣችሁኝምና፥ እንግዳ ሆኜ አልተቀበላችሁኝምና፥ ");
INSERT INTO amh_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ታርዤ አላለበሳችሁኝምና፥ ታምሜ ታስሬም አልጠየቃችሁኝምና። ");
INSERT INTO amh_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","እነርሱ ደግሞ ይመልሱና። ጌታ ሆይ፥ ተርበህ ወይስ ተጠምተህ ወይስ እንግዳ ሆነህ ወይስ ታርዘህ ወይስ ታመህ ወይስ ታስረህ መቼ አይተን አላገለገልንህም? ይሉታል። ");
INSERT INTO amh_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ያን ጊዜ። እውነት እላችኋለሁ፥ ከሁሉ ከሚያንሱ ከእነዚህ ለአንዱ ስላላደረጋችሁት ለእኔ ደግሞ አላደረጋችሁትም ብሎ ይመልስላቸዋል። ");
INSERT INTO amh_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","እነዚያም ወደ ዘላለም ቅጣት፥ ጻድቃን ግን ወደ ዘላለም ሕይወት ይሄዳሉ። ");
INSERT INTO amh_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ኢየሱስም እነዚህን ቃሎች ሁሉ በፈጸመ ጊዜ፥ ");
INSERT INTO amh_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","ለደቀ መዛሙርቱ። ከሁለት ቀን በኋላ ፋሲካ እንዲሆን ታውቃላችሁ፥ የሰው ልጅም ሊሰቀል አልፎ ይሰጣል አለ። ");
INSERT INTO amh_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","በዚያን ጊዜ የካህናት አለቆች የሕዝብም ሽማግሎች ቀያፋ በሚባለው በሊቀ ካህናቱ ግቢ ተሰበሰቡ፥ ");
INSERT INTO amh_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ኢየሱስንም በተንኰል ሊያስይዙት ሊገድሉትም ተማከሩ፤ ");
INSERT INTO amh_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ነገር ግን። በሕዝቡ ዘንድ ሁከት እንዳይነሣ በበዓል አይሁን አሉ። ");
INSERT INTO amh_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ኢየሱስም በቢታንያ በለምጻሙ በስምዖን ቤት ሳለ፥ ");
INSERT INTO amh_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","አንዲት ሴት ዋጋው እጅግ የበዛ ሽቱ የሞላው የአልባስጥሮስ ብልቃጥ ይዛ ወደ እርሱ ቀረበች በማዕድም ተቀምጦ ሳለ በራሱ ላይ አፈሰሰችው። ");
INSERT INTO amh_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ደቀ መዛሙርቱም ይህን አይተው ተቈጡና። ይህ ጥፋት ለምንድር ነው? ");
INSERT INTO amh_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ይህ በብዙ ዋጋ ተሽጦ ለድሆች ሊሰጥ ይቻል ነበርና አሉ። ");
INSERT INTO amh_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ኢየሱስም ይህን አውቆ እንዲህ አላቸው። መልካም ሥራ ሠርታልኛለችና ሴቲቱንስ ስለ ምን ታደክሙአታላችሁ? ");
INSERT INTO amh_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ድሆች ሁልጊዜ ከእናንተ ጋር ይኖራሉና፥ እኔ ግን ሁልጊዜ ከእናንተ ጋር አልኖርም፤ ");
INSERT INTO amh_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","እርስዋ ይህን ሽቱ በሰውነቴ ላይ አፍስሳ ለመቃብሬ አደረገች። ");
INSERT INTO amh_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","እውነት እላችኋለሁ፥ ይህ ወንጌል በዓለም ሁሉ በማናቸውም ስፍራ በሚሰበክበት እርስዋ ያደረገችው ደግሞ ለእርስዋ መታሰቢያ እንዲሆን ይነገራል። ");
INSERT INTO amh_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","በዚያን ጊዜ የአስቆሮቱ ይሁዳ የሚባለው ከአሥራ ሁለቱ አንዱ ወደ ካህናት አለቆች ሄዶ። ");
INSERT INTO amh_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ምን ልትሰጡኝ ትወዳላችሁ እኔም አሳልፌ እሰጣችኋለሁ? እነርሱም ሠላሳ ብር መዘኑለት። ");
INSERT INTO amh_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ከዚያችም ሰዓት ጀምሮ አሳልፎ ሊሰጠው ምቹ ጊዜ ይሻ ነበር። ");
INSERT INTO amh_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","በቂጣው በዓል በመጀመሪያ ቀን ደቀ መዛሙርቱ ወደ ኢየሱስ ቀርበው። ፋሲካን ትበላ ዘንድ ወዴት ልናሰናዳልህ ትወዳለህ አሉት። ");
INSERT INTO amh_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","እርሱም። ወደ ከተማ ከእገሌ ዘንድ ሄዳችሁ። መምህር። ጊዜዬ ቀርቦአል፤ ከደቀ መዛሙርቴ ጋር ከአንተ ዘንድ ፋሲካን አደርጋለሁ ይላል በሉት አለ። ");
INSERT INTO amh_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ደቀ መዛሙርቱም ኢየሱስ እንዳዘዛቸው አደረጉ ፋሲካንም አሰናዱ። ");
INSERT INTO amh_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","በመሸም ጊዜ ከአሥራ ሁለቱ ደቀ መዛሙርቱ ጋር በማዕድ ተቀመጠ። ");
INSERT INTO amh_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ሲበሉም። እውነት እላችኋለሁ፥ ከእናንተ አንዱ እኔን አሳልፎ ይሰጣል አለ። ");
INSERT INTO amh_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","እጅግም አዝነው እያንዳንዱ። ጌታ ሆይ፥ እኔ እሆንን? ይሉት ጀመር። ");
INSERT INTO amh_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","እርሱም መልሶ። ከእኔ ጋር እጁን በወጭቱ ያጠለቀ፥ እኔን አሳልፎ የሚሰጥ እርሱ ነው። ");
INSERT INTO amh_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","የሰው ልጅስ ስለ እርሱ እንደ ተጻፈ ይሄዳል፥ ነገር ግን የሰው ልጅ አልፎ ለሚሰጥበት ለዚያ ሰው ወዮለት፤ ያ ሰው ባልተወለደ ይሻለው ነበር አለ። ");
INSERT INTO amh_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","አሳልፎ የሚሰጠው ይሁዳም መልሶ። መምህር ሆይ፥ እኔ እሆንን? አለ፤ አንተ አልህ አለው። ");
INSERT INTO amh_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ሲበሉም ኢየሱስ እንጀራን አንሥቶ ባረከ ቈርሶም ለደቀ መዛሙርቱ ሰጠና። እንካችሁ፥ ብሉ ይህ ሥጋዬ ነው አለ። ");
INSERT INTO amh_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ጽዋንም አንሥቶ አመስግኖም ሰጣቸው እንዲህም አለ። ሁላችሁ ከእርሱ ጠጡ፤ ");
INSERT INTO amh_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ስለ ብዙዎች ለኃጢአት ይቅርታ የሚፈስ የአዲስ ኪዳን ደሜ ይህ ነው። ");
INSERT INTO amh_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ነገር ግን እላችኋለሁ፥ በአባቴ መንግሥት ከእናንተ ጋር ከዚህ ከወይን ፍሬ አዲሱን እስከምጠጣበት እስከዚያ ቀን ድረስ ከዛሬ ጀምሬ አልጠጣውም። ");
INSERT INTO amh_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","መዝሙርም ከዘመሩ በኋላ ወደ ደብረ ዘይት ወጡ። ");
INSERT INTO amh_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","በዚያን ጊዜ ኢየሱስ። በዚች ሌሊት ሁላችሁ በእኔ ትሰናከላላችሁ፤ እረኛውን እመታለሁ የመንጋውም በጎች ይበተናሉ የሚል ተጽፎአልና፤ ");
INSERT INTO amh_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ከተነሣሁ በኋላ ግን ወደ ገሊላ እቀድማችኋለሁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ጴጥሮስም መልሶ። ሁሉም በአንተ ቢሰናከሉ እኔ ከቶ አልሰናከልም አለው። ");
INSERT INTO amh_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ኢየሱስ። እውነት እልሃለሁ፥ በዚች ሌሊት ዶሮ ሳይጮኽ ሦስት ጊዜ ትክደኛለህ አለው። ");
INSERT INTO amh_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ጴጥሮስ። ከአንተ ጋር መሞት እንኳ የሚያስፈልገኝ ቢሆን፥ ከቶ አልክድህም አለው። ደቀ መዛሙርቱ ሁሉ ደግሞ እንደዚሁ አሉ። ");
INSERT INTO amh_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","በዚያን ጊዜ ኢየሱስ ከእነርሱ ጋር ጌቴሴማኒ ወደምትባል ስፍራ መጣ ደቀ መዛሙርቱንም። ወዲያ ሄጄ ስጸልይ ሳለ በዚህ ተቀመጡ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ጴጥሮስንም ሁለቱንም የዘብዴዎስን ልጆች ወስዶ ሊያዝን ሊተክዝም ጀመር። ");
INSERT INTO amh_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ነፍሴ እስከ ሞት ድረስ እጅግ አዘነች፤ በዚህ ቆዩ ከእኔም ጋር ትጉ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ጥቂትም ወደ ፊት እልፍ ብሎ በፊቱ ወደቀና ሲጸልይ። አባቴ፥ ቢቻልስ፥ ይህች ጽዋ ከእኔ ትለፍ፤ ነገር ግን አንተ እንደምትወድ ይሁን እንጂ እኔ እንደምወድ አይሁን አለ። ");
INSERT INTO amh_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ወደ ደቀ መዛሙርቱም መጣ፤ ተኝተውም አገኛቸውና ጴጥሮስን። እንዲሁም ከእኔ ጋር አንዲት ሰዓት እንኳ ልትተጉ አልቻላችሁምን? ");
INSERT INTO amh_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ወደ ፈተና እንዳትገቡ ትጉና ጸልዩ፤ መንፈስስ ተዘጋጅታለች ሥጋ ግን ደካማ ነው አለው። ");
INSERT INTO amh_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ደግሞ ሁለተኛ ሄዶ ጸለየና። አባቴ፥ ይህች ጽዋ ሳልጠጣት ታልፍ ዘንድ የማይቻል እንደ ሆነ፥ ፈቃድህ ትሁን አለ። ");
INSERT INTO amh_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ደግሞም መጥቶ ዓይኖቻቸው በእንቅልፍ ከብደው ነበርና ተኝተው አገኛቸው። ");
INSERT INTO amh_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ደግሞም ትቶአቸው ሄደ፥ ሦስተኛም ያንኑ ቃል ደግሞ ጸለየ። ");
INSERT INTO amh_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ከዚያ ወዲያ ወደ ደቀ መዛሙርቱ መጥቶ። እንግዲህስ ተኙ ዕረፉም፤ እነሆ፥ ሰዓቲቱ ቀርባለች የሰው ልጅም በኃጢአተኞች እጅ አልፎ ይሰጣል። ");
INSERT INTO amh_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ተነሡ፥ እንሂድ፤ እነሆ፥ አሳልፎ የሚሰጠኝ ቀርቦአል አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ይህንም ገና ሲናገር፥ እነሆ፥ ከአሥራ ሁለቱ አንዱ ይሁዳ መጣ፥ ከእርሱም ጋር ብዙ ሕዝብ ሰይፍና ጐመድ ይዘው ከካህናት አለቆችና ከሕዝቡ ሽማግሎች ዘንድ መጡ። ");
INSERT INTO amh_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","አሳልፎ የሚሰጠውም። የምስመው እርሱ ነው፤ ያዙት ብሎ ምልክት ሰጥቶአቸው ነበር። ");
INSERT INTO amh_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ወዲያውም ወደ ኢየሱስ ቀረበና። መምህር ሆይ፥ ሰላም ለአንተ ይሁን ብሎ ሳመው። ");
INSERT INTO amh_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ኢየሱስም። ወዳጄ ሆይ፥ ለምን ነገር መጣህ? አለው። በዚያን ጊዜ ቀረቡ እጃቸውንም በኢየሱስ ላይ ጭነው ያዙት። ");
INSERT INTO amh_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","እነሆም፥ ከኢየሱስ ጋር ከነበሩት አንዱ እጁን ዘርግቶ ሰይፉን መዘዘና የሊቀ ካህናቱን ባሪያ መትቶ ጆሮውን ቈረጠው። ");
INSERT INTO amh_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","በዚያን ጊዜ ኢየሱስ እንዲህ አለው። ሰይፍ የሚያነሡ ሁሉ በሰይፍ ይጠፋሉና ሰይፍህን ወደ ስፍራው መልስ። ");
INSERT INTO amh_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ወይስ አባቴን እንድለምን እርሱም አሁን ከአሥራ ሁለት ጭፍሮች የሚበዙ መላእክት እንዲሰድልኝ የማይቻል ይመስልሃልን? ");
INSERT INTO amh_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","እንዲህ ከሆነስ። እንደዚህ ሊሆን ይገባል የሚሉ መጻሕፍት እንዴት ይፈጸማሉ? ");
INSERT INTO amh_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","በዚያን ሰዓት ኢየሱስ ለሕዝቡ። ወንበዴን እንደምትይዙ ሰይፍና ጐመድ ይዛችሁ ልትይዙኝ ወጣችሁን? በመቅደስ ዕለት ዕለት እያስተማርሁ ከእናንተ ጋር ስቀመጥ ሳለሁ አልያዛችሁኝም። ");
INSERT INTO amh_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ነገር ግን ይህ ሁሉ የሆነ የነቢያት መጻሕፍት ይፈጸሙ ዘንድ ነው አለ። በዚያን ጊዜ ደቀ መዛሙርቱ ሁሉ ትተውት ሸሹ። ");
INSERT INTO amh_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ኢየሱስን የያዙትም ጻፎችና ሽማግሎች ወደ ተከማቹበት ወደ ሊቀ ካህናቱ ወደ ቀያፋ ወሰዱት። ");
INSERT INTO amh_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ጴጥሮስ ግን እስከ ሊቀ ካህናቱ ግቢ ድረስ ሩቅ ሆኖ ተከተለው፥ የነገሩንም ፍጻሜ ያይ ዘንድ ወደ ውስጥ ገብቶ ከሎሌዎቹ ጋር ተቀመጠ። ");
INSERT INTO amh_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","የካህናት አለቆችና ሽማግሎች ሸንጐውም ሁሉ እንዲገድሉት በኢየሱስ ላይ የሐሰት ምስክር ይፈልጉ ነበር፥ አላገኙም፤ ");
INSERT INTO amh_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ብዙም የሐሰት ምስክሮች ምንም ቢቀርቡ አላገኙም። ");
INSERT INTO amh_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","በኋላም ሁለት ቀርበው። ይህ ሰው። የእግዚአብሔርን ቤተ መቅደስ አፍርሼ በሦስት ቀን ልሠራው እችላለሁ ብሎአል አሉ። ");
INSERT INTO amh_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ሊቀ ካህናቱም ተነሥቶ። እነዚህ ለሚመሰክሩብህ አንድ ስንኳ አትመልስምን? አለው። ");
INSERT INTO amh_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ኢየሱስ ግን ዝም አለ። ሊቀ ካህናቱም። አንተ የእግዚአብሔር ልጅ ክርስቶስ የሆንህ እንደ ሆነ እንድትነግረን በሕያው እግዚአብሔር አምልሃለሁ አለው። ");
INSERT INTO amh_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ኢየሱስም። አንተ አልህ ነገር ግን እላችኋለሁ፥ ከእንግዲህ ወዲህ የሰው ልጅ በኃይል ቀኝ ሲቀመጥ በሰማይም ደመና ሲመጣ ታያላችሁ አለው። ");
INSERT INTO amh_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","በዚያን ጊዜ ሊቀ ካህናቱ ልብሱን ቀዶ። ተሳድቦአል እንግዲህ ወዲህ ምስክሮች ስለ ምን ያስፈልገናል? እነሆ፥ ስድቡን አሁን ሰምታችኋል፤ ምን ይመስላችኋል? አለ። ");
INSERT INTO amh_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","እነርሱም። ሞት ይገባዋል ብለው መለሱ። ");
INSERT INTO amh_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","በዚያን ጊዜ በፊቱ ተፉበት፤ ጐሰሙትም፥ ሌሎችም በጥፊ መትተው። ክርስቶስ ሆይ፥ በጥፊ የመታህ ማን ነው? ");
INSERT INTO amh_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ትንቢት ተናገርልን አሉ። ");
INSERT INTO amh_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ጴጥሮስም ከቤት ውጭ በአጥሩ ግቢ ተቀምጦ ነበር፤ አንዲት ገረድም ወደ እርሱ ቀርባ። አንተ ደግሞ ከገሊላው ከኢየሱስ ጋር ነበርህ አለችው። ");
INSERT INTO amh_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","እርሱ ግን። የምትዪውን አላውቀውም ብሎ በሁሉ ፊት ካደ። ");
INSERT INTO amh_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ወደ በሩም ሲወጣ ሌላይቱ አየችውና በዚያ ላሉት። ይህ ደግሞ ከናዝሬቱ ከኢየሱስ ጋር ነበረ አለች። ");
INSERT INTO amh_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ዳግመኛም ሲምል። ሰውየውን አላውቀውም ብሎ ካደ። ");
INSERT INTO amh_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ጥቂትም ቈይተው በዚያ ቆመው የነበሩ ቀርበው ጴጥሮስን። አነጋገርህ ይገልጥሃልና በእውነት አንተ ደግሞ ከእነርሱ ወገን ነህ አሉት። ");
INSERT INTO amh_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","በዚያን ጊዜ። ሰውየውን አላውቀውም ብሎ ሊራገምና ሊምል ጀመረ። ወዲያውም ዶሮ ጮኸ። ");
INSERT INTO amh_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ጴጥሮስም። ዶሮ ሳይጮኽ ሦስት ጊዜ ትክደኛለህ ያለው የኢየሱስ ቃል ትዝ አለው፤ ወደ ውጭም ወጥቶ መራራ ልቅሶ አለቀሰ። ");
INSERT INTO amh_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ሲነጋም የካህናት አለቆችና የሕዝቡ ሽማግሎች ሁሉ ሊገድሉት በኢየሱስ ላይ ተማከሩ፤ ");
INSERT INTO amh_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","አስረውም ወሰዱት፥ ለገዢው ለጴንጤናዊው ጲላጦስም አሳልፈው ሰጡት። ");
INSERT INTO amh_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","በዚያን ጊዜ አሳልፎ የሰጠው ይሁዳ እንደ ተፈረደበት አይቶ ተጸጸተ፥ ሠላሳውንም ብር ለካህናት አለቆችና ለሽማግሎች መልሶ። ");
INSERT INTO amh_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ንጹሕ ደም አሳልፌ በመስጠቴ በድያለሁ አለ። እነርሱ ግን። እኛስ ምን አግዶን? አንተው ተጠንቀቅ አሉ። ");
INSERT INTO amh_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ብሩንም በቤተ መቅደስ ጥሎ ሄደና ታንቆ ሞተ። ");
INSERT INTO amh_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","የካህናት አለቆችም ብሩን አንሥተው። የደም ዋጋ ነውና ወደ መባ ልንጨምረው አልተፈቀደም አሉ። ");
INSERT INTO amh_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ተማክረውም የሸክላ ሠሪውን መሬት ለእንግዶች መቃብር ገዙበት። ");
INSERT INTO amh_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ስለዚህ ያ መሬት እስከ ዛሬ ድረስ የደም መሬት ተባለ። ");
INSERT INTO amh_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","በዚያን ጊዜ በነቢዩ በኤርምያስ የተባለው። ከእስራኤል ልጆችም አንዳንዶቹ የገመቱትን፥ የተገመተውን ዋጋ ሠላሳ ብር ያዙ፥ ");
INSERT INTO amh_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ጌታም እንዳዘዘኝ ስለ ሸክላ ሠሪ መሬት ሰጡት። የሚል ተፈጸመ። ");
INSERT INTO amh_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ኢየሱስም በገዢው ፊት ቆመ፤ ገዢውም። የአይሁድ ንጉሥ አንተ ነህን? ብሎ ጠየቀው፤ ኢየሱስም። አንተ አልህ አለው። ");
INSERT INTO amh_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","የካህናት አለቆችም ሽማግሎችም ሲከሱት ምንም አልመለሰም። ");
INSERT INTO amh_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","በዚያን ጊዜ ጲላጦስ። ስንት ያህል እንዲመሰክሩብህ አትሰማምን? አለው። ");
INSERT INTO amh_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ገዢውም እጅግ እስኪደነቅ ድረስ አንዲት ቃል ስንኳ አልመለሰለትም። ");
INSERT INTO amh_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","በዚያም በዓል ሕዝቡ የወደዱትን አንድ እስረኛ ሊፈታላቸው ለገዢው ልማድ ነበረው። ");
INSERT INTO amh_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","በዚያን ጊዜም በርባን የሚባል በጣም የታወቀ እስረኛ ነበራቸው። ");
INSERT INTO amh_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","እንግዲህ እነርሱ ተሰብስበው ሳሉ ጲላጦስ። በርባንን ወይስ ክርስቶስ የተባለውን ኢየሱስን ማንኛውን ልፈታላችሁ ትወዳላችሁ? አላቸው፤ ");
INSERT INTO amh_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","በቅንዓት አሳልፈው እንደ ሰጡት ያውቅ ነበርና። ");
INSERT INTO amh_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","እርሱም በፍርድ ወንበር ተቀምጦ ሳለ ሚስቱ። ስለ እርሱ ዛሬ በሕልም እጅግ መከራ ተቀብያለሁና በዚያ ጻድቅ ሰው ምንም አታድርግ ብላ ላከችበት። ");
INSERT INTO amh_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","የካህናት አለቆችና ሽማግሎች ግን በርባንን እንዲለምኑ ኢየሱስን ግን እንዲያጠፉ ሕዝቡን አባበሉ። ");
INSERT INTO amh_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ገዢውም መልሶ። ከሁለቱ ማንኛውን ልፈታላችሁ ትወዳላችሁ? አላቸው፤ እነርሱም። በርባንን አሉ። ");
INSERT INTO amh_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ጲላጦስ። ክርስቶስ የተባለውን ኢየሱስን እንግዲህ ምን ላድርገው? አላቸው፤ ሁሉም። ይሰቀል አሉ። ");
INSERT INTO amh_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ገዢውም። ምን ነው? ያደረገው ክፋት ምንድር ነው? አለ፤ እነርሱ ግን። ይሰቀል እያሉ ጩኸት አበዙ። ");
INSERT INTO amh_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ጲላጦስም ሁከት እንዲጀመር እንጂ አንዳች እንዳይረባ ባየ ጊዜ፥ ውኃ አንሥቶ። እኔ ከዚህ ጻድቅ ሰው ደም ንጹሕ ነኝ፤ እናንተ ተጠንቀቁ ሲል በሕዝቡ ፊት እጁን ታጠበ። ");
INSERT INTO amh_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ሕዝቡም ሁሉ መልሰው። ደሙ በእኛና በልጆቻችን ላይ ይሁን አሉ። ");
INSERT INTO amh_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","በዚያን ጊዜ በርባንን ፈታላቸው፥ ኢየሱስን ግን ገርፎ ሊሰቀል አሳልፎ ሰጠ። ");
INSERT INTO amh_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","በዚያን ጊዜ የገዢው ወታደሮች ኢየሱስን ወደ ገዢው ግቢ ውስጥ ወሰዱት ጭፍራውንም ሁሉ ወደ እርሱ አከማቹ። ");
INSERT INTO amh_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ልብሱንም ገፈው ቀይ ልብስ አለበሱት፥ ");
INSERT INTO amh_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ከእሾህም አክሊል ጎንጉነው በራሱ ላይ፥ በቀኝ እጁም መቃ አኖሩ፥ በፊቱም ተንበርክከው። የአይሁድ ንጉሥ ሆይ፥ ሰላም ለአንተ ይሁን እያሉ ዘበቱበት፤ ");
INSERT INTO amh_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ተፉበትም መቃውንም ይዘው ራሱን መቱት። ");
INSERT INTO amh_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ከዘበቱበትም በኋላ ቀዩን ልብስ ገፈፉት፥ ልብሱንም አለበሱት ሊሰቅሉትም ወሰዱት። ");
INSERT INTO amh_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ሲወጡም ስምዖን የተባለው የቀሬናን ሰው አገኙ፤ እርሱንም መስቀሉን ይሸከም ዘንድ አስገደዱት። ");
INSERT INTO amh_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ትርጓሜው የራስ ቅል ስፍራ ወደሚሆን ጎልጎታ ወደሚባለው ስፍራ በደረሱ ጊዜም፥ ");
INSERT INTO amh_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","በሐሞት የተደባለቀ የወይን ጠጅ ሊጠጣ አቀረቡለት፤ ቀምሶም ሊጠጣው አልወደደም። ");
INSERT INTO amh_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ከሰቀሉትም በኋላ ልብሱን ዕጣ ጥለው ተካፈሉ፥ ");
INSERT INTO amh_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","በዚያም ተቀምጠው ይጠብቁት ነበር። ");
INSERT INTO amh_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ይህ ኢየሱስ የአይሁድ ንጉሥ ነው የሚል የክሱን ጽሕፈት ከራሱ በላይ አኖሩ። ");
INSERT INTO amh_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","በዚያን ጊዜ ሁለት ወንበዶች አንዱ በቀኝ አንዱም በግራ ከእርሱ ጋር ተሰቀሉ። ");
INSERT INTO amh_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","የሚያልፉትም ራሳቸውን እየነቀነቁ ይሰድቡት ነበርና። ");
INSERT INTO amh_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ቤተ መቅደስን የምታፈርስ በሦስት ቀንም የምትሠራው፥ ራስህን አድን፤ የእግዚአብሔር ልጅስ ከሆንህ ከመስቀል ውረድ አሉት። ");
INSERT INTO amh_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","እንዲሁም ደግሞ የካህናት አለቆች ከጻፎችና ከሽማግሎች ጋር እየዘበቱበት እንዲህ አሉ። ");
INSERT INTO amh_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","ሌሎችን አዳነ፥ ራሱን ሊያድን አይችልም፤ የእስራኤል ንጉሥ ከሆነ፥ አሁን ከመስቀል ይውረድ እኛም እናምንበታለን። ");
INSERT INTO amh_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","በእግዚአብሔር ታምኖአል፤ የእግዚአብሔር ልጅ ነኝ ብሎአልና ከወደደውስ አሁን ያድነው። ");
INSERT INTO amh_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ከእርሱ ጋር የተሰቀሉት ወንበዶች ደግሞ ያንኑ እያሉ ይነቅፉት ነበር። ");
INSERT INTO amh_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ከስድስት ሰዓትም ጀምሮ እስከ ዘጠኝ ሰዓት ድረስ በምድር ሁሉ ላይ ጨለማ ሆነ። ");
INSERT INTO amh_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","በዘጠኝ ሰዓትም ኢየሱስ። ኤሎሄ ኤሎሄ ላማ ሰበቅታኒ? ብሎ በታላቅ ድምፅ ጮኸ። ይህም። አምላኬ አምላኬ፥ ስለ ምን ተውኸኝ? ማለት ነው። ");
INSERT INTO amh_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","በዚያም ከቆሙት ሰዎች ሰምተው። ይህስ ኤልያስን ይጠራል አሉ። ");
INSERT INTO amh_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ወዲያውም ከእነርሱ አንዱ ሮጠ፤ ሰፍነግም ይዞ ሆምጣጤ ሞላበት፥ በመቃም አድርጎ አጠጣው። ");
INSERT INTO amh_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ሌሎቹ ግን። ተው፥ ኤልያስ መጥቶ ያድነው እንደ ሆነ እንይ አሉ። ");
INSERT INTO amh_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ኢየሱስም ሁለተኛ በታላቅ ድምፅ ጮኾ ነፍሱን ተወ። ");
INSERT INTO amh_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","እነሆም፥ የቤተ መቅደስ መጋረጃ ከላይ እስከ ታች ከሁለት ተቀደደ፥ ምድርም ተናወጠች፥ ዓለቶችም ተሰነጠቁ፤ ");
INSERT INTO amh_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","መቃብሮችም ተከፈቱ፥ ተኝተው ከነበሩትም ከቅዱሳን ብዙ ሥጋዎች ተነሡ፤ ");
INSERT INTO amh_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ከትንሣኤውም በኋላ ከመቃብሮች ወጥተው ወደ ቅድስት ከተማ ገቡና ለብዙዎች ታዩ። ");
INSERT INTO amh_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","የመቶ አለቃም ከእርሱም ጋር ኢየሱስን የሚጠብቁ መናወጡንና የሆነውን ነገር አይተው። ይህ በእውነት የእግዚአብሔር ልጅ ነበረ ብለው እጅግ ፈሩ። ");
INSERT INTO amh_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ኢየሱስን እያገለገሉ ከገሊላ የተከተሉት ብዙ ሴቶች በሩቅ ሆነው ሲመለከቱ በዚያ ነበሩ፤ ");
INSERT INTO amh_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ከእነርሱም መግደላዊት ማርያምና የያዕቆብና የዮሳ እናት ማርያም የዘብዴዎስም የልጆቹ እናት ነበሩ። ");
INSERT INTO amh_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","በመሸም ጊዜ ዮሴፍ የተባለው ባለ ጠጋ ሰው ከአርማትያስ መጣ፥ እርሱም ደግሞ የኢየሱስ ደቀ መዝሙር ነበረ፤ ");
INSERT INTO amh_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ይኸውም ወደ ጲላጦስ ቀርቦ የኢየሱስን ሥጋ ለመነው። ");
INSERT INTO amh_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ጲላጦስም እንዲሰጡት አዘዘ። ዮሴፍም ሥጋውን ይዞ በንጹሕ በፍታ ከፈነው፥ ");
INSERT INTO amh_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ከዓለት በወቀረው በአዲሱ መቃብርም አኖረው፥ በመቃብሩም ደጃፍ ታላቅ ድንጋይ አንከባሎ ሄደ። ");
INSERT INTO amh_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","መግደላዊት ማርያምም ሁለተኛይቱም ማርያም በመቃብሩ አንጻር ተቀምጠው በዚያ ነበሩ። ");
INSERT INTO amh_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","በማግሥቱም ከመዘጋጀት በኋላ በሚሆነው ቀን፥ የካህናት አለቆችና ፈሪሳውያን ወደ ጲላጦስ ተሰበሰቡና። ");
INSERT INTO amh_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ጌታ ሆይ፥ ያ አሳች በሕይወቱ ገና ሳለ። ከሦስት ቀን በኋላ እነሣለሁ እንዳለ ትዝ አለን። ");
INSERT INTO amh_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","እንግዲህ ደቀ መዛሙርቱ መጥተው በሌሊት እንዳይሰርቁት ለሕዝቡም። ከሙታን ተነሣ እንዳይሉ፥ የኋለኛይቱ ስሕተት ከፊተኛይቱ ይልቅ የከፋች ትሆናለችና መቃብሩ እስከ ሦስተኛ ቀን ድረስ እንዲጠበቅ እዘዝ አሉት። ");
INSERT INTO amh_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ጲላጦስም። ጠባቆች አሉአችሁ፤ ሄዳችሁ እንዳወቃችሁ አስጠብቁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","እነርሱም ሄደው ከጠባቆች ጋር ድንጋዩን አትመው መቃብሩን አስጠበቁ። ");
INSERT INTO amh_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","በሰንበትም መጨረሻ መጀመሪያው ቀን ሲነጋ መግደላዊት ማርያምና ሁለተኛይቱ ማርያም መቃብሩን ሊያዩ መጡ። ");
INSERT INTO amh_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","እነሆም፥ የጌታ መልአክ ከሰማይ ስለ ወረደ ታላቅ የምድር መናወጥ ሆነ፤ ቀርቦም ድንጋዩን አንከባሎ በላዩ ተቀመጠ። ");
INSERT INTO amh_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","መልኩም እንደ መብረቅ ልብሱም እንደ በረዶ ነጭ ነበረ። ");
INSERT INTO amh_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ጠባቆቹም እርሱን ከመፍራት የተነሣ ተናወጡ እንደ ሞቱም ሆኑ። ");
INSERT INTO amh_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","መልአኩም መልሶ ሴቶቹን አላቸው። እናንተስ አትፍሩ የተሰቀለውን ኢየሱስን እንድትሹ አውቃለሁና፤ ");
INSERT INTO amh_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","እንደ ተናገረ ተነሥቶአልና በዚህ የለም፤ የተኛበትን ስፍራ ኑና እዩ። ");
INSERT INTO amh_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ፈጥናችሁም ሂዱና። ከሙታን ተነሣ፥ እነሆም፥ ወደ ገሊላ ይቀድማችኋል በዚያም ታዩታላችሁ ብላችሁ ለደቀ መዛሙርቱ ንገሩአቸው። ");
INSERT INTO amh_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","እነሆም፥ ነገርኋችሁ። በፍርሃትና በታላቅ ደስታም ፈጥነው ከመቃብር ሄዱ፥ ለደቀ መዛሙርቱም ሊያወሩ ሮጡ። ");
INSERT INTO amh_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","እነሆም፥ ኢየሱስ አገኛቸውና። ደስ ይበላችሁ አላቸው። እነርሱም ቀርበው እግሩን ይዘው ሰገዱለት። ");
INSERT INTO amh_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","በዚያን ጊዜ ኢየሱስ። አትፍሩ፤ ሄዳችሁ ወደ ገሊላ እንዲሄዱ ለወንድሞቼ ተናገሩ፥ በዚያም ያዩኛል አላቸው። ");
INSERT INTO amh_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ሲሄዱም ሳሉ እነሆ፥ ከጠባቆቹ አንዳንድ ወደ ከተማ መጥተው የሆነውን ሁሉ ለካህናት አለቆች አወሩ። ");
INSERT INTO amh_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ከሽማግሎች ጋርም ተሰብስበው ተማከሩና ለጭፍሮች ብዙ ገንዘብ ሰጥተዋቸው። ");
INSERT INTO amh_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","እኛ ተኝተን ሳለን ደቀ መዛሙርቱ በሌሊት መጥተው ሰረቁት በሉ። ");
INSERT INTO amh_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ይህም በገዢው ዘንድ የተሰማ እንደ ሆነ፥ እኛ እናስረዳዋለን እናንተም ያለ ሥጋት እንድትሆኑ እናደርጋለን አሉአቸው። ");
INSERT INTO amh_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","እነርሱም ገንዘቡን ተቀብለው እንደ አስተማሩአቸው አደረጉ። ይህም ነገር በአይሁድ ዘንድ እስከ ዛሬ ድረስ ሲወራ ይኖራል። ");
INSERT INTO amh_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","አሥራ አንዱ ደቀ መዛሙርት ግን ኢየሱስ ወዳዘዛቸው ተራራ ወደ ገሊላ ሄዱ፥ ");
INSERT INTO amh_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ባዩትም ጊዜ ሰገዱለት፤ የተጠራጠሩ ግን ነበሩ። ");
INSERT INTO amh_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","20","ኢየሱስም ቀረበና እንዲህ ብሎ ተናገራቸው። ሥልጣን ሁሉ በሰማይና በምድር ተሰጠኝ። ");
INSERT INTO amh_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","የእግዚአብሔር ልጅ የኢየሱስ ክርስቶስ ወንጌል መጀመሪያ። ");
INSERT INTO amh_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","4","ዮሐንስ በምድረ በዳ እያጠመቀ የንስሐንም ጥምቀት ለኃጢአት ስርየት እየሰበከ መጣ። ");
INSERT INTO amh_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","የይሁዳም አገር ሁሉ የኢየሩሳሌምም ሰዎች ሁሉ ወደ እርሱ ይወጡ ነበር፥ ኃጢአታቸውንም እየተናዘዙ በዮርዳኖስ ወንዝ ከእርሱ ይጠመቁ ነበር። ");
INSERT INTO amh_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ዮሐንስም የግመል ጠጉር ለብሶ በወገቡ ጠፍር ይታጠቅ አንበጣና የበረሀ ማርም ይበላ ነበር። ");
INSERT INTO amh_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ተጎንብሼ የጫማውን ጠፍር መፍታት የማይገባኝ ከእኔ የሚበረታ በኋላዬ ይመጣል። ");
INSERT INTO amh_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","እኔ በውኃ አጠመቅኋችሁ እርሱ ግን በመንፈስ ቅዱስ ያጠምቃችኋል እያለ ይሰብክ ነበር። ");
INSERT INTO amh_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","በዚያ ወራትም ኢየሱስ ከገሊላ ናዝሬት መጥቶ ከዮሐንስ በዮርዳኖስ ወንዝ ተጠመቀ። ");
INSERT INTO amh_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ወዲያውም ከውኃው በወጣ ጊዜ ሰማያት ሲቀደዱ መንፈስም እንደ ርግብ ሲወርድበት አየና። የምወድህ ልጄ አንተ ነህ፥ ");
INSERT INTO amh_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","በአንተ ደስ ይለኛል የሚል ድምፅ ከሰማያት መጣ። ");
INSERT INTO amh_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ወዲያውም መንፈስ ወደ ምድረ በዳ አወጣው። ");
INSERT INTO amh_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","በምድረ በዳም ከሰይጣን እየተፈተነ አርባ ቀን ሰነበተ ከአራዊትም ጋር ነበረ፥ መላእክቱም አገለገሉት። ");
INSERT INTO amh_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","16","በገሊላ ባሕርም አጠገብ ሲያልፍ ስምዖንን ወንድሙንም እንድርያስን መረባቸውን ወደ ባሕር ሲጥሉ አየ፥ ዓሣ አጥማጆች ነበሩና። ");
INSERT INTO amh_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ኢየሱስም። በኋላዬ ኑና ሰዎችን አጥማጆች እንድትሆኑ አደርጋችኋለሁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ወዲያውም መረባቸውን ትተው ተከተሉት። ");
INSERT INTO amh_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ከዚያም ጥቂት እልፍ ብሎ የዘብዴዎስን ልጅ ያዕቆብን ወንድሙንም ዮሐንስን ደግሞ በታንኳ ላይ መረባቸውን ሲያበጁ አየ። ");
INSERT INTO amh_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ወዲያውም ጠራቸው አባታቸውንም ዘብዴዎስን ከሞያተኞቹ ጋር በታንኳ ላይ ትተው ተከትለውት ሄዱ። ");
INSERT INTO amh_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ወደ ቅፍርናሆምም ገቡ፤ ወዲያውም በሰንበት ወደ ምኵራብ ገብቶ አስተማረ። ");
INSERT INTO amh_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","እንደ ባለ ሥልጣን ያስተምራቸው ነበር እንጂ እንደ ጻፎች አይደለምና በትምህርቱ ተገረሙ። ");
INSERT INTO amh_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","በዚያን ጊዜም በምኩራባቸው ርኵስ መንፈስ ያለው ሰው ነበረ፤ ");
INSERT INTO amh_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","እርሱም። የናዝሬቱ ኢየሱስ ሆይ፥ ከአንተ ጋር ምን አለን? ልታጠፋን መጣህን? ማን እንደ ሆንህ አውቄአለሁ፥ የእግዚአብሔር ቅዱሱ ብሎ ጮኸ። ");
INSERT INTO amh_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ኢየሱስም። ዝም በል ከእርሱም ውጣ ብሎ ገሠጸው። ");
INSERT INTO amh_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ርኵሱም መንፈስ አንፈራገጠውና በታላቅ ድምፅ ጮኾ ከእርሱ ወጣ። ");
INSERT INTO amh_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ሁሉም። ይህ ምንድር ነው? በሥልጣን ርኵሳን መናፍስትን ያዝዛል፤ እነርሱም ይታዘዙለታልና ይህ አዲስ ትምህርት ምንድር ነው? ብለው እስኪጠያየቁ ድረስ አደነቁ። ");
INSERT INTO amh_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ዝናውም ወዲያው በየስፍራው ወደ ገሊላ ዙሪያ ሁሉ ወጣ። ");
INSERT INTO amh_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ወዲያውም ከምኵራብ ወጥቶ ከያዕቆብና ከዮሐንስ ጋር ወደ ስምዖንና ወደ እንድርያስ ቤት ገባ። ");
INSERT INTO amh_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","የስምዖንም አማት በንዳድ ታማ ተኝታ ነበር፥ ስለ እርስዋም ወዲያው ነገሩት። ");
INSERT INTO amh_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ቀርቦም እጅዋን ይዞ አስነሣት ንዳዱም ወዲያው ለቀቃትና አገለገለቻቸው። ");
INSERT INTO amh_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ፀሐይም ገብቶ በመሸ ጊዜ፥ የታመሙትንና አጋንንት ያደረባቸውን ሁሉ ወደ እርሱ አመጡ፤ ");
INSERT INTO amh_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ከተማይቱም ሁላ በደጅ ተሰብስባ ነበር። ");
INSERT INTO amh_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","በልዩ ልዩ ደዌም የታመሙትን ብዙዎችን ፈወሰ፥ ብዙዎችንም አጋንንት አወጣ፥ አጋንንትም ክርስቶስ መሆኑን አውቀው ነበርና ሊናገሩ አልፈቀደላቸውም። ");
INSERT INTO amh_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ማለዳም ተነሥቶ ገና ሌሊት ሳለ ወጣ ወደ ምድረ በዳም ሄዶ በዚያ ጸለየ። ");
INSERT INTO amh_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ስምዖንና ከእርሱ ጋር የነበሩትም ገሥግሠው ተከተሉት፥ ");
INSERT INTO amh_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ባገኙትም ጊዜ። ሁሉ ይፈልጉሃል አሉት። ");
INSERT INTO amh_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","እርሱም። በዚያ ደግሞ ልሰብክ ወደ ሌላ ስፍራ በቅርብ ወዳሉ መንደሮች እንሂድ ስለዚህ ወጥቻለሁና አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","በምኵራባቸውም እየሰበከ አጋንንትንም እያወጣ ወደ ገሊላ ሁሉ መጣ። ");
INSERT INTO amh_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ለምጻምም ወደ እርሱ መጥቶ ተንበረከከና። ብትወድስ ልታነጻኝ ትችላለህ ብሎ ለመነው። ");
INSERT INTO amh_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ኢየሱስም አዘነለት እጁንም ዘርግቶ ዳሰሰውና። እወድዳለሁ፤ ንጻ አለው። ");
INSERT INTO amh_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","በተናገረም ጊዜ ለምጹ ወዲያው ለቀቀውና ነጻ። ");
INSERT INTO amh_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","በብርቱም ተናግሮ ወዲያው አወጣው፤ ");
INSERT INTO amh_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ለማንም አንዳች እንዳትናገር ተጠንቀቅ፥ ነገር ግን ሄደህ ራስህን ለካህን አሳይ ለእነርሱም ምስክር እንዲሆን ስለ መንጻትህ ሙሴ ያዘዘውን አቅርብ አለው። ");
INSERT INTO amh_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","እርሱ ግን ሲወጣ ብዙ ሊሰብክና ነገሩን ሊያወራ ጀመረ፥ ስለዚህም ኢየሱስ ተገልጦ ወደ ከተማ መግባት ወደ ፊት ተሳነው፥ ነገር ግን በውጭ በምድረ በዳ ይኖር ነበር፤ ከየስፍራውም ወደ እርሱ ይመጡ ነበር። ");
INSERT INTO amh_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ከጥቂት ቀን በኋላ ወደ ቅፍርናሆም ደግሞ ገብቶ በቤት እንደ ሆነ ተሰማ። ");
INSERT INTO amh_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","በደጅ ያለው ስፍራም እስኪጠባቸው ድረስ ብዙ ሰዎች ተሰበሰቡ፤ ቃሉንም ይነግራቸው ነበር። ");
INSERT INTO amh_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","አራት ሰዎችም የተሸከሙትን ሽባ አመጡለት። ");
INSERT INTO amh_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ስለ ሕዝቡም ብዛት ወደ እርሱ ማቅረብ ቢያቅታቸው እርሱ ያለበትን የቤቱን ጣራ አነሡ፥ ነድለውም ሽባው የተኛበትን አልጋ አወረዱ። ");
INSERT INTO amh_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ኢየሱስም እምነታቸውን አይቶ ሽባውን። አንተ ልጅ፥ ኃጢአትህ ተሰረየችልህ አለው። ");
INSERT INTO amh_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ከጻፎችም አንዳንዶቹ በዚያ ተቀምጠው ነበር በልባቸውም። ይህ ሰው ስለ ምን እንደዚህ ያለ ስድብ ይናገራል? ");
INSERT INTO amh_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ከአንዱ ከእግዚአብሔር በቀር ኃጢአት ሊያስተሰርይ ማን ይችላል? ብለው አሰቡ። ");
INSERT INTO amh_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ወዲያውም ኢየሱስ በልባቸው እንዲህ እንዳሰቡ በመንፈስ አውቆ እንዲህ አላቸው። በልባችሁ ይህን ስለ ምን ታስባላችሁ? ");
INSERT INTO amh_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ሽባውን። ኃጢአትህ ተሰረየችልህ ከማለት ወይስ። ተነሣ አልጋህንም ተሸከምና ሂድ ከማለት ማናቸው ይቀላል? ");
INSERT INTO amh_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ነገር ግን ለሰው ልጅ በምድር ላይ ኃጢአትን ሊያስተሰርይ ሥልጣን እንዳለው እንድታውቁ፤ ");
INSERT INTO amh_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","ሽባውን። አንተን እልሃለሁ፥ ተነሣ፥ አልጋህን ተሸከምና ወደ ቤትህ ሂድ አለው። ");
INSERT INTO amh_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ተነሥቶም ወዲያው አልጋውን ተሸክሞ በሁሉ ፊት ወጣ፥ ስለዚህም ሰዎች ሁሉ ተገረሙና። እንዲህ ያለ ከቶ አላየንም ብለው እግዚአብሔርን አከበሩ። ");
INSERT INTO amh_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ደግሞም በባሕር አጠገብ ወጣ፤ ሕዝቡም ሁሉ ወደ እርሱ መጡና አስተማራቸው። ");
INSERT INTO amh_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ሲያልፍም በመቅረጫው ተቀምጦ የነበረውን የእልፍዮስን ልጅ ሌዊን አየና። ተከተለኝ አለው። ተነሥቶም ተከተለው። ");
INSERT INTO amh_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","በቤቱም በማዕድ ተቀምጦ ሳለ፥ ብዙ ቀራጮችና ኃጢአተኞች ከኢየሱስና ከደቀ መዛሙርቱ ጋር ተቀመጡ፤ ብዙ ነበሩ ይከተሉትም ነበር። ");
INSERT INTO amh_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ጻፎችና ፈሪሳውያንም ከቀራጮችና ከኃጢአተኞች ጋር ሲበላ አይተው ለደቀ መዛሙርቱ። ከቀራ ጮችና ከኃጢአተኞች ጋር የሚበላና የሚጠጣ ስለ ምንድር ነው? አሉ። ");
INSERT INTO amh_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ኢየሱስም ሰምቶ። ሕመምተኞች እንጂ ብርቱዎች ባለ መድኃኒት አያስፈልጋቸውም ኃጢአተኞችን እንጂ ጻድቃንን ልጠራ አልመጣሁም አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","የዮሐንስ ደቀ መዛሙርትና ፈሪሳውያን ይጦሙ ነበር። መጥተውም። የዮሐንስና የፈሪሳውያን ደቀ መዛሙርት የሚጦሙት የአንተ ደቀ መዛሙርት ግን የማይጦሙት ስለ ምንድር ነው? አሉት። ");
INSERT INTO amh_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ኢየሱስም አላቸው። ሙሽራው ከእነርሱ ጋር ሳለ ሚዜዎች ሊጦሙ ይችላሉን? ሙሽራው ከእነርሱ ጋር ሳለ ሊጦሙ አይችሉም። ");
INSERT INTO amh_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ነገር ግን ሙሽራው ከእነርሱ የሚወሰድበት ወራት ይመጣል፥ በዚያ ወራትም ይጦማሉ። ");
INSERT INTO amh_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","በአረጀ ልብስ አዲስ እራፊ የሚጥፍ የለም፤ ቢደረግ ግን፥ አዲሱ መጣፊያ አሮጌውን ይቦጭቀዋል፥ መቀደዱም የባሰ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","በአረጀ አቁማዳም አዲስ የወይን ጠጅ የሚያኖር የለም፤ ቢደረግ ግን፥ የወይን ጠጁ አቁማዳውን ያፈነዳል የወይኑም ጠጅ ይፈሳል አቁማዳውም ይጠፋል አዲሱን የወይን ጠጅ ግን በአዲስ አቁማዳ ያኖራሉ። ");
INSERT INTO amh_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","በሰንበትም በእርሻ መካከል ሲያልፍ ደቀ መዛሙርቱ እየሄዱ እሸት ይቀጥፉ ጀመር። ");
INSERT INTO amh_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ፈሪሳውያንም። እነሆ፥ በሰንበት ያልተፈቀደውን ስለ ምን ያደርጋሉ? አሉት። ");
INSERT INTO amh_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","እርሱም። ዳዊት ባስፈለገውና በተራበ ጊዜ፥ እርሱ አብረውት ከነበሩት ጋር ያደረገውን፥ አብያተር ሊቀ ካህናት በነበረ ጊዜ ወደ እግዚአብሔር ቤት እንደ ገባ፥ ");
INSERT INTO amh_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ከካህናት በቀር መብላት ያልተፈቀደውን የመሥዋዕትን እንጀራ እንደ በላ፥ ከእርሱም ጋር ለነበሩት እንደ ሰጣቸው ከቶ አላነበባችሁምን? አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ደግሞ። ሰንበት ስለ ሰው ተፈጥሮአል እንጂ ሰው ስለ ሰንበት አልተፈጠረም፤ ");
INSERT INTO amh_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","እንዲሁም የሰው ልጅ ለሰንበት እንኳ ጌታዋ ነው አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ደግሞም ወደ ምኵራብ ገባ፥ በዚያም እጁ የሰለለች ሰው ነበር፤ ");
INSERT INTO amh_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ሊከሱትም፥ በሰንበት ይፈውሰው እንደ ሆነ ይጠባበቁት ነበር። ");
INSERT INTO amh_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","እጁ የሰለለችውንም ሰው። ተነሥተህ ወደ መካከል ና አለው። ");
INSERT INTO amh_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","በሰንበት በጎ ማድረግ ተፈቅዶአልን? ወይስ ክፉ? ነፍስ ማዳን ወይስ መግደል? አላቸው፤ እነርሱም ዝም አሉ። ");
INSERT INTO amh_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ስለ ልባቸውም ድንዛዜ አዝኖ ዙሪያውን እየተመለከተ በቍጣ አያቸው፥ ሰውየውንም። እጅህን ዘርጋ አለው። ");
INSERT INTO amh_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ዘረጋትም፥ እጁም ዳነች። ፈሪሳውያንም ወጥተው ወዲያው እንዴት አድርገው እንዲያጠፉት ከሄሮድስ ወገን ጋር ተማከሩበት። ");
INSERT INTO amh_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ኢየሱስም ከደቀ መዛሙርቱ ጋር ወደ ባህር ፈቀቅ አለ፤ ከገሊላ የመጡም ብዙ ሰዎች ተከተሉት፤ ");
INSERT INTO amh_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","እንዴት ትልቅ ነገርም እንዳደረገው ሰምተው ብዙ ሰዎች ከይሁዳ ከኢየሩሳሌምም ከኤዶምያስም ከዮርዳኖስ ማዶም ከጢሮስና ከሲዶና ምድርም ወደ እርሱ መጡ። ");
INSERT INTO amh_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ሰዎቹም እንዳያጋፉት ታንኳን ያቆዩለት ዘንድ ደቀ መዛሙርቱን አዘዛቸው፤ ");
INSERT INTO amh_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ብዙ ሰዎችን አድኖ ነበርና፥ ስለዚህም ሥቃይ ያለባቸው ሁሉ እንዲዳስሱት ይወድቁበት ነበር። ");
INSERT INTO amh_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ርኵሳን መናፍስትም ባዩት ጊዜ በፊቱ ተደፍተው። አንተ የእግዚአብሔር ልጅ ነህ እያሉ ጮኹ። ");
INSERT INTO amh_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","እንዳይገልጡትም በጣም አዘዛቸው። ");
INSERT INTO amh_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ወደ ተራራም ወጣ፥ ራሱም የወደዳቸውን ወደ እርሱ ጠራ፥ ወደ እርሱም ሄዱ። ");
INSERT INTO amh_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ከእርሱም ጋር እንዲኖሩና ለመስበክ እንዲልካቸው፥ ");
INSERT INTO amh_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ድውዮችንም ሊፈውሱ አጋንንትንም ሊያወጡ ሥልጣን ይሆንላቸው ዘንድ አሥራ ሁለት አደረገ፤ ");
INSERT INTO amh_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ስምዖንንም ጴጥሮስ ብሎ ሰየመው፤ ");
INSERT INTO amh_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","የዘብዴዎስንም ልጅ ያዕቆብን የያዕቆብንም ወንድም ዮሐንስን ቦአኔርጌስ ብሎ ሰየማቸው፥ የነጎድጓድ ልጆች ማለት ነው፤ ");
INSERT INTO amh_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","እንድርያስንም ፊልጶስንም በርተሎሜውስንም ማቴዎስንም ቶማስንም የእልፍዮስን ልጅ ያዕቆብንም ታዴዎስንም ቀነናዊውንም ስምዖንን፥ ");
INSERT INTO amh_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","አሳልፎ የሰጠውንም የአስቆሮቱን ይሁዳን። ");
INSERT INTO amh_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ወደ ቤትም መጡ፤ እንጀራም መብላት ስንኳ እስኪሳናቸው ድረስ እንደ ገና ብዙ ሰዎች ተሰበሰቡ። ");
INSERT INTO amh_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ዘመዶቹም ሰምተው። አበደ ብለዋልና ሊይዙት ወጡ። ");
INSERT INTO amh_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ከኢየሩሳሌም የወረዱ ጻፎችም። ብዔል ዜቡል አለበት፤ ደግሞ። በአጋንንት አለቃ አጋንንትን ያወጣል ብለው ተናገሩ። ");
INSERT INTO amh_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","እነርሱንም ወደ እርሱ ጠርቶ በምሳሌ አላቸው። ሰይጣን ሰይጣንን ሊያወጣው እንዴት ይችላል? ");
INSERT INTO amh_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","መንግሥትም እርስ በርስዋ ከተለያየች ያች መንግሥት ልትቆም አትችልም፤ ");
INSERT INTO amh_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ቤትም እርስ በርሱ ከተለያየ ያ ቤት ሊቆም አይችልም። ");
INSERT INTO amh_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ሰይጣንም ራሱን ተቃውሞ ከተለያየ፥ መጨረሻ ይሆንበታል እንጂ ሊቆም አይችልም። ");
INSERT INTO amh_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ነገር ግን አስቀድሞ ኃይለኛውን ሳያስር ወደ ኃይለኛው ቤት ገብቶ ዕቃውን ሊበዘብዝ የሚችል የለም፥ ከዚያም ወዲያ ቤቱን ይበዘብዛል። ");
INSERT INTO amh_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","እውነት እላችኋለሁ፥ ለሰው ልጆች ኃጢአት ሁሉ የሚሳደቡትም ስድብ ሁሉ ይሰረይላቸዋል፤ ");
INSERT INTO amh_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","በመንፈስ ቅዱስ ላይ የሚሳደብ ሁሉ ግን የዘላለም ኃጢአት ዕዳ ይሆንበታል እንጂ ለዘላለም አይሰረይለትም። ");
INSERT INTO amh_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ርኵስ መንፈስ አለበት ይሉ ነበርና። ");
INSERT INTO amh_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","እናቱና ወንድሞቹም መጡ በውጭም ቆመው ወደ እርሱ ልከው አስጠሩት። ");
INSERT INTO amh_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ብዙ ሰዎችም በዙሪያው ተቀምጠው ነበሩና። እነሆ፥ እናትህ ወንድሞችህም በውጭ ቆመው ይፈልጉሃል አሉት። ");
INSERT INTO amh_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","መልሶም። እናቴ ማን ናት? ወንድሞቼስ እነ ማን ናቸው? አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","በዙሪያው ተቀምጠው ወደ ነበሩትም ተመለከተና። እነሆ እናቴ ወንድሞቼም። ");
INSERT INTO amh_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","የእግዚአብሔርን ፈቃድ የሚያደርግ ሁሉ፥ እርሱ ወንድሜ ነው እኅቴም እናቴም አለ። ");
INSERT INTO amh_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ደግሞም በባሕር ዳር ሊያስተምር ጀመረ። እጅግ ብዙ ሰዎችም ወደ እርሱ ስለ ተሰበሰቡ እርሱ በታንኳ ገብቶ በባሕር ላይ ተቀመጠ፤ ሕዝቡም ሁሉ በባሕር ዳር በምድር ላይ ነበሩ። ");
INSERT INTO amh_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","በምሳሌም ብዙ ያስተምራቸው ነበር፥ በትምህርቱም አላቸው። ስሙ። ");
INSERT INTO amh_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","5","ሌላውም ብዙ መሬት በሌለበት በጭንጫ ላይ ወደቀና ጥልቅ መሬት ስላልነበረው ወዲያው በቀለ፤ ");
INSERT INTO amh_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ፀሐይም ሲወጣ ጠወለገ፥ ሥርም ስላልነበረው ደረቀ። ");
INSERT INTO amh_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ሌላውም በእሾህ መካከል ወደቀ፥ እሾህም ወጣና አነቀው፥ ፍሬም አልሰጠም። ");
INSERT INTO amh_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ሌላውም በመልካም መሬት ላይ ወደቀና ወጥቶ አድጎ ፍሬ ሰጠ፥ አንዱም ሠላሳ አንዱም ስድሳ አንዱም መቶ አፈራ። ");
INSERT INTO amh_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","የሚሰማ ጆሮ ያለው ይስማ አለ። ");
INSERT INTO amh_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ብቻውንም በሆነ ጊዜ፥ በዙሪያው የነበሩት ከአሥራ ሁለቱ ጋር ስለ ምሳሌው ጠየቁት። ");
INSERT INTO amh_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","13","አላቸውም። ይህን ምሳሌ አታውቁምን? እንዴትስ ምሳሌዎቹን ሁሉ ታውቃላችሁ? ");
INSERT INTO amh_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ዘሪው ቃሉን ይዘራል። ቃልም በተዘራበት በመንገድ ዳር የሆኑት እነዚህ ናቸው፥ ");
INSERT INTO amh_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","በሰሙት ጊዜም ሰይጣን ወዲያው መጥቶ በልባቸው የተዘራውን ቃል ይወስዳል። ");
INSERT INTO amh_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","እንዲሁም በጭንጫ ላይ የተዘሩት እነዚህ ናቸው፥ ቃሉንም ሰምተው ወዲያው በደስታ ይቀበሉታል፥ ");
INSERT INTO amh_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ለጊዜውም ነው እንጂ በእነርሱ ሥር የላቸውም፥ ኋላም በቃሉ ምክንያት መከራ ወይም ስደት በሆነ ጊዜ ወዲያው ይሰናከላሉ። ");
INSERT INTO amh_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","በእሾህም የተዘሩት ሌሎች ናቸው፥ ቃሉን የሰሙት እነዚህ ናቸው፥ ");
INSERT INTO amh_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","የዚህም ዓለም አሳብና የባለጠግነት ማታለል የሌላውም ነገር ምኞት ገብተው ቃሉን ያንቃሉ፥ የማያፈራም ይሆናል። ");
INSERT INTO amh_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","በመልካምም መሬት የተዘሩት ቃሉን ሰምተው የሚቀበሉት አንዱም ሠላሳ አንዱም ስድሳ አንዱም መቶ ፍሬ የሚያፈሩት እነዚህ ናቸው። ");
INSERT INTO amh_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","እንዲህም አላቸው። መብራትን ከዕንቅብ ወይስ ከአልጋ በታች ሊያኖሩት ያመጡታልን? በመቅረዝ ላይ ሊያኖሩት አይደለምን? ");
INSERT INTO amh_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","እንዲገለጥ ባይሆን የተሰወረ የለምና፤ ወደ ግልጥ እንዲመጣ እንጂ የተሸሸገ የለም። ");
INSERT INTO amh_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","የሚሰማ ጆሮ ያለው ቢኖር ይስማ። ");
INSERT INTO amh_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","አላቸውም። ምን እንድትሰሙ ተጠበቁ። በምትሰፍሩበት መስፈሪያ ይሰፈርላችኋል ለእናንተም ይጨመርላችኋል። ");
INSERT INTO amh_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ላለው ይሰጠዋልና፤ ከሌለውም ያው ያለው እንኳ ይወሰድበታል። ");
INSERT INTO amh_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","እርሱም አለ። በምድር ዘርን እንደሚዘራ ሰው የእግዚአብሔር መንግሥት እንደዚህ ናት ሌሊትና ቀን ይተኛልም ይነሣልም፥ ");
INSERT INTO amh_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","እርሱም እንዴት እንደሚሆን ሳያውቅ ዘሩ ይበቅላል ያድግማል። ");
INSERT INTO amh_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ምድሪቱም አውቃ በመጀመሪያ ቡቃያ ኋላም ዛላ ኋላም በዛላው ፍጹም ሰብል ታፈራለች። ");
INSERT INTO amh_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ፍሬ ግን ሲበስል መከር ደርሶአልና ወዲያው ማጭድ ይልካል። ");
INSERT INTO amh_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","እርሱም አለ። የእግዚአብሔርን መንግሥት በምን እናስመስላታለን? ወይስ በምን ምሳሌ እንመስላታለን? ");
INSERT INTO amh_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","እንደ ሰናፍጭ ቅንጣት ናት፥ እርስዋም በምድር በተዘራች ጊዜ በምድር ካለ ዘር ሁሉ ታንሳለች፤ በተዘራችም ጊዜ ትወጣለች ከአትክልትም ሁሉ የምትበልጥ ትሆናለች፥ ");
INSERT INTO amh_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","የሰማይ ወፎችም በጥላዋ ሊሰፍሩ እስኪችሉ ታላላቅ ቅርንጫፎች ታደርጋለች። ");
INSERT INTO amh_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","መስማትም በሚችሉበት መጠን እነዚህን በሚመስል በብዙ ምሳሌ ቃሉን ይነግራቸው ነበር፤ ያለ ምሳሌ ግን አልነገራቸውም፥ ");
INSERT INTO amh_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ለብቻቸውም ሲሆኑ ነገሩን ሁሉ ለገዛ ደቀ መዛሙርቱ ይፈታላቸው ነበር። ");
INSERT INTO amh_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","በዚያም ቀን በመሸ ጊዜ። ወደ ማዶ እንሻገር አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ሕዝቡንም ትተው በታንኳ እንዲያው ወሰዱት፥ ሌሎች ታንኳዎችም ከእርሱ ጋር ነበሩ። ");
INSERT INTO amh_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ብርቱ ዐውሎ ነፋስም ተነሣና ውኃ በታንኳይቱ እስኪሞላ ድረስ ማዕበሉ በታንኳይቱ ይገባ ነበር። ");
INSERT INTO amh_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","እርሱም በስተኋላዋ ትራስ ተንተርሶ ተኝቶ ነበር፤ አንቅተውም። መምህር ሆይ፥ ስንጠፋ አይገድህምን? አሉት። ");
INSERT INTO amh_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ነቅቶም ነፋሱን ገሠጸው ባሕሩንም። ዝም በል፥ ፀጥ በል አለው። ነፋሱም ተወ ታላቅ ፀጥታም ሆነ። ");
INSERT INTO amh_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","እንዲህ የምትፈሩ ስለ ምን ነው? እንዴትስ እምነት የላችሁም? አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","እጅግም ፈሩና። እንግዲህ ነፋስም ባሕርም የሚታዘዙለት ይህ ማን ነው? ተባባሉ። ");
INSERT INTO amh_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ወደ ባሕር ማዶም ወደ ጌርጌሴኖን አገር መጡ። ");
INSERT INTO amh_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ከታንኳይቱም በወጣ ጊዜ፥ ርኵስ መንፈስ የያዘው ሰው ከመቃብር ወጥቶ ወዲያው ተገናኘው፤ ");
INSERT INTO amh_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","እርሱም በመቃብር ይኖር ነበር፥ በሰንሰለትም ስንኳ ማንም ሊያስረው በዚያን ጊዜ አይችልም ነበር፤ ");
INSERT INTO amh_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ብዙ ጊዜ በእግር ብረትና በሰንሰለት ይታሰር ነበርና ዳሩ ግን ሰንሰለቱን ይበጣጥስ እግር ብረቱንም ይሰባብር ነበር፥ ሊያሸንፈውም የሚችል አልነበረም፤ ");
INSERT INTO amh_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ሁልጊዜም ሌሊትና ቀን በመቃብርና በተራራ ሆኖ ይጮኽ ነበር ሰውነቱንም በድንጋይ ይቧጭር ነበር። ");
INSERT INTO amh_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ኢየሱስንም ከሩቅ ባየ ጊዜ ሮጦ ሰገደለት፥ ");
INSERT INTO amh_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","በታላቅ ድምፅም እየጮኸ። የልዑል እግዚአብሔር ልጅ ኢየሱስ ሆይ፥ ከአንተ ጋር ምን አለኝ? እንዳታሠቃየኝ በእግዚአብሔር አምልሃለሁ አለ፤ ");
INSERT INTO amh_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","አንተ ርኵስ መንፈስ፥ ከዚህ ሰው ውጣ ብሎት ነበርና። ");
INSERT INTO amh_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ስምህ ማን ነው? ብሎ ጠየቀው። ብዙዎች ነንና ስሜ ሌጌዎን ነው አለው፥ ");
INSERT INTO amh_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ከአገርም ውጭ እንዳይሰዳቸው አጥብቆ ለመነው። ");
INSERT INTO amh_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","በዚያም በተራራ ጥግ ብዙ የእሪያ መንጋ ይሰማራ ነበርና። ");
INSERT INTO amh_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ወደ እሪያዎቹ እንድንገባ ስደደን ብለው ለመኑት። ");
INSERT INTO amh_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ኢየሱስም ፈቀደላቸው። ርኵሳን መናፍስቱም ወጥተው ወደ እሪያዎቹ ገቡ፥ ሁለት ሺህም የሚያህል መንጋ ከአፋፉ ወደ ባሕር ተጣደፉና በባሕር ሰጠሙ። ");
INSERT INTO amh_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","እረኞቹም ሸሽተው በከተማውና በአገሩ አወሩ፤ ነገሩም ምን እንደ ሆነ ለማየት መጡ። ");
INSERT INTO amh_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ወደ ኢየሱስም መጡ፥ አጋንንትም ያደሩበትን ሌጌዎንም የነበረበትን ሰው ተቀምጦ ለብሶም ልቡም ተመልሶ አዩና ፈሩ። ");
INSERT INTO amh_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ያዩት ሰዎችም አጋንንት ላደሩበት ሰው የሆነውንና ስለ እሪያዎቹ ተረኩላቸው። ");
INSERT INTO amh_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ከአገራቸውም እንዲሄድላቸው ይለምኑት ጀመር። ");
INSERT INTO amh_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ወደ ታንኳይቱም በገባ ጊዜ አጋንንት አድረውበት የነበረው ሰው ከእርሱ ጋር እንዲኖር ለመነው። ");
INSERT INTO amh_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ኢየሱስም አልፈቀደለትም፥ ነገር ግን። ወደ ቤትህ በቤተ ሰዎችህ ዘንድ ሄደህ ጌታ እንዴት ያለ ታላቅ ነገር እንዳደረገልህ እንዴትስ እንደ ማረህ አውራላቸው አለው። ");
INSERT INTO amh_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ሄዶም ኢየሱስ እንዴት ያለ ታላቅ ነገር እንዳደረገለት አሥር ከተማ በሚባል አገር ይሰብክ ጀመር፥ ሁሉም ተደነቁ። ");
INSERT INTO amh_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ኢየሱስም ደግሞ በታንኳይቱ ወደ ማዶ ከተሻገረ በኋላ ብዙ ሰዎች ወደ እርሱ ተሰበሰቡ፥ በባሕርም አጠገብ ነበረ። ");
INSERT INTO amh_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ኢያኢሮስ የተባለ ከምኵራብ አለቆች አንዱ መጣ፤ ባየውም ጊዜ በእግሩ ላይ ወደቀና። ");
INSERT INTO amh_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ታናሽቱ ልጄ ልትሞት ቀርባለችና እንድትድንና በሕይወት እንድትኖር መጥተህ እጅህን ጫንባት ብሎ አጥብቆ ለመነው። ");
INSERT INTO amh_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ከእርሱም ጋር ሄደ። ብዙ ሕዝብም ተከተሉት አጋፉትም። ");
INSERT INTO amh_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ከአሥራ ሁለት ዓመትም ጀምሮ ደም የሚፈሳት ሴት ነበረች፥ ");
INSERT INTO amh_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ከብዙ ባለ መድኃኒቶችም ብዙ ተሠቃየች፤ ገንዘብዋንም ሁሉ ከስራ ባሰባት እንጂ ምንም አልተጠቀመችም፤ ");
INSERT INTO amh_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","የኢየሱስንም ወሬ ሰምታ በስተኋላው በሰዎች መካከል መጥታ ልብሱን ዳሰሰች። ");
INSERT INTO amh_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ልብሱን ብቻ የዳሰስሁ እንደ ሆነ እድናለሁ ብላለችና። ");
INSERT INTO amh_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ወዲያውም የደምዋ ምንጭ ደረቀ ከሥቃይዋም እንደዳነች በሰውነትዋ አወቀች። ");
INSERT INTO amh_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ወዲያውም ኢየሱስ ከእርሱ ኃይል እንደ ወጣ በገዛ ራሱ አውቆ በሕዝቡ መካከል ዘወር ብሎ። ልብሴን የዳሰሰ ማን ነው? አለ። ");
INSERT INTO amh_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ደቀ መዛሙርቱም። ሕዝቡ ሲያጋፉህ እያየህ። ማን ዳሰሰኝ ትላለህን? አሉት። ");
INSERT INTO amh_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ይህንም ያደረገችውን ለማየት ዘወር ብሎ ይመለከት ነበር። ");
INSERT INTO amh_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ሴቲቱ ግን የተደረገላትን ስላወቀች፥ እየፈራች እየተንቀጠቀጠችም፥ መጥታ በፊቱ ተደፋች እውነቱንም ሁሉ ነገረችው። ");
INSERT INTO amh_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","እርሱም። ልጄ ሆይ፥ እምነትሽ አድኖሻል፤ በሰላም ሂጂ ከሥቃይሽም ተፈወሽ አላት። ");
INSERT INTO amh_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","እርሱም ገና ሲናገር ከምኵራብ አለቃው ቤት ዘንድ የመጡት። ልጅህ ሞታለች፤ ስለ ምን መምህሩን አሁን ታደክመዋለህ? አሉት። ");
INSERT INTO amh_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ኢየሱስ ግን የተናገሩትን ቃል አድምጦ ለምኵራቡ አለቃ። እመን ብቻ እንጂ አትፍራ አለው። ");
INSERT INTO amh_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ከጴጥሮስም ከያዕቆብም ከያዕቆብም ወንድም ከዮሐንስ በቀር ማንም እንዲከተለው አልፈቀደም። ");
INSERT INTO amh_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ወደ ምኵራቡ አለቃ ቤትም መጥቶ ሰዎች ሲንጫጩና ሲያለቅሱ ዋይታም ሲያበዙ አየ፤ ");
INSERT INTO amh_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ገብቶም። ስለ ምን ትንጫጫላችሁ ታለቅሳላችሁም? ብላቴናይቱ ተኝታለች እንጂ አልሞተችም አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","በጣምም ሳቁበት። እርሱ ግን ሁሉን አስወጥቶ የብላቴናይቱን አባትና እናትም ከእርሱ ጋር የነበሩትንም ይዞ ብላቴናይቱ ወዳለችበት ገባ። ");
INSERT INTO amh_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","የብላቴናይቱንም እጅ ይዞ። ጣሊታ ቁሚ አላት፤ ፍችውም አንቺ ብላቴና ተነሽ እልሻለሁ ነው። ");
INSERT INTO amh_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ብላቴናይቱም የአሥራ ሁለት ዓመት ልጅ ነበረችና ወዲያው ቆማ ተመላለሰች። ወዲያውም ታላቅ መገረም ተገረሙ። ");
INSERT INTO amh_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ይህንም ማንም እንዳያውቅ አጥብቆ አዞአቸው። የምትበላውን ስጡአት አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ከዚያም ወጥቶ ወደ ገዛ አገሩ መጣ ደቀ መዛሙርቱም ተከተሉት። ");
INSERT INTO amh_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ሰንበትም በሆነ ጊዜ በምኵራብ ያስተምር ጀመር፤ ብዙዎችም ሰምተው ተገረሙና። እነዚህን ነገሮች ይህ ከወዴት አገኛቸው? ለዚህ የተሰጠችው ጥበብ ምንድር ናት? በእጁም የሚደረጉ እንደነዚህ ያሉ ተአምራት ምንድር ናቸው? ");
INSERT INTO amh_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ይህስ ጸራቢው የማርያም ልጅ የያቆብም የዮሳም የይሁዳም የስምዖንም ወንድም አይደለምን? እኅቶቹስ በዚህ በእኛ ዘንድ አይደሉምን? አሉ፤ ይሰናከሉበትም ነበር። ");
INSERT INTO amh_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ኢየሱስም። ነቢይ ከገዛ አገሩና ከገዛ ዘመዶቹ ከገዛ ቤቱም በቀር ሳይከበር አይቀርም አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","በዚያም በጥቂቶች ድውዮች ላይ እጁን ጭኖ ከመፈወስ በቀር፥ ተአምር ሊያደርግ ምንም አልቻለም። ");
INSERT INTO amh_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ስለ አለማመናቸውም ተደነቀ። በመንደሮችም እያስተማረ ይዞር ነበር። ");
INSERT INTO amh_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","አስራ ሁለቱንም ወደ እርሱ ጠራ ሁለት ሁለቱንም ይልካቸው ጀመር፥ በርኵሳን መናፍስትም ላይ ሥልጣን ሰጣቸው፥ ");
INSERT INTO amh_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ለመንገድም ከበትር በቀር እንጀራም ቢሆን ከረጢትም ቢሆን መሐለቅም በመቀነታቸው ቢሆን እንዳይዙ አዘዛቸው። ");
INSERT INTO amh_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","በእግራችሁ ጫማ አድርጉ እንጂ ሁለት እጀ ጠባብ አትልበሱ አለ። ");
INSERT INTO amh_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","በማናቸውም ስፍራ ወደ ቤት ብትገቡ ከዚያ እስክትወጡ ድረስ በዚያው ተቀመጡ። ");
INSERT INTO amh_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ከማይቀበሉአችሁና ከማይሰሙአችሁ ስፍራ ሁሉ፥ ከዚያ ወጥታችሁ ምስክር ይሆንባቸው ዘንድ ከእግራችሁ በታች ያለውን ትቢያ አራግፉ። እውነት እላችኋለሁ፥ ከዚያች ከተማ ይልቅ ለሰዶምና ለገሞራ በፍርድ ቀን ይቀልላቸዋል አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ወጥተውም ንስሐ እንዲገቡ ሰበኩ፥ ብዙ አጋንንትንም አወጡ፥ ");
INSERT INTO amh_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ብዙ ድውዮችንም ዘይት እየቀቡ ፈወሱአቸው። ");
INSERT INTO amh_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ስሙም ተገልጦአልና ንጉሡ ሄሮድስ በሰማ ጊዜ። መጥምቁ ዮሐንስ ከሙታን ተነሥቶአል ስለዚህም ኃይል በእርሱ ይደረጋል አለ። ");
INSERT INTO amh_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ሌሎችም። ኤልያስ ነው አሉ፤ ሌሎችም። ከነቢያት እንደ አንዱ ነቢይ ነው አሉ። ");
INSERT INTO amh_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ሄሮድስ ግን ሰምቶ። እኔ ራሱን ያስቈረጥሁት ዮሐንስ ይህ ነው እርሱ ከሙታን ተነሥቶአል አለ። ");
INSERT INTO amh_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ሄሮድስ የወንድሙን የፊልጶስን ሚስት ሄሮድያዳን አግብቶ ነበርና በእርስዋ ምክንያት ራሱ ልኮ ዮሐንስን አስይዞ በወኅኒ አሳስሮት ነበር፤ ");
INSERT INTO amh_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ዮሐንስ ሄሮድስን። የወንድምህ ሚስት ለአንተ ልትሆን አልተፈቀደም ይለው ነበርና። ");
INSERT INTO amh_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ሄሮድያዳ ግን ተቃውማው ልትገድለው ትፈልግ ነበር አልቻለችም፤ ");
INSERT INTO amh_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ሄሮድስ ዮሐንስ ጻድቅና ቅዱስ ሰው እንደ ሆነ አውቆ ይፈራውና ይጠባበቀው ነበር፤ እርሱንም ሰምቶ በብዙ ነገር ያመነታ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","በደስታም ይሰማው ነበር። ሄሮድስም በተወለደበት ቀን ለመኳንንቱና ለሻለቆቹ ለገሊላም ሹማምንት ግብር ባደረገ ጊዜ ምቹ ቀን ሆነላትና ");
INSERT INTO amh_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","የሄሮድያዳ ልጅ ገብታ ስትዘፍን ሄሮድስንና ከእርሱ ጋር የተቀመጡትን ደስ አሰኘቻቸው። ንጉሡም ብላቴናይቱን። የምትወጂውን ሁሉ ለምኚኝ እሰጥሽማለሁ አላት፤ ");
INSERT INTO amh_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","የመንግሥቴ እኩሌታ ስንኳ ቢሆን የምትለምኚውን ሁሉ እሰጥሻለሁ ብሎ ማለላት። ");
INSERT INTO amh_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ወጥታም ለእናትዋ። ምን ልለምነው? አለች። እርስዋም። የመጥምቁን የዮሐንስን ራስ አለች። ");
INSERT INTO amh_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ወዲያውም ፈጥና ወደ ንጉሡ ገብታ። የመጥምቁን የዮሐንስን ራስ በወጭት አሁን ልትሰጠኝ እወዳለሁ ብላ ለመነችው። ");
INSERT INTO amh_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ንጉሡም እጅግ አዝኖ ስለ መሐላው ከእርሱም ጋር ስለ ተቀመጡት ሊነሣት አልወደደም። ");
INSERT INTO amh_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ወዲያውም ንጉሡ ባለ ወግ ልኮ ራሱን እንዲያመጣ አዘዘው። ሄዶም በወኅኒ ራሱን ቈረጠ፥ ");
INSERT INTO amh_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ራሱንም በወጭት አምጥቶ ለብላቴናይቱ ሰጣት፥ ብላቴናይቱም ለእናትዋ ሰጠች። ");
INSERT INTO amh_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ደቀ መዛሙርቱም ሰምተው መጡ በድኑንም ወስደው ቀበሩት። ");
INSERT INTO amh_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ሐዋርያትም ወደ ኢየሱስ ተሰብስበው ያደረጉትንና ያስተማሩትን ሁሉ ነገሩት። ");
INSERT INTO amh_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","እናንት ራሳችሁ ብቻችሁን ወደ ምድረ በዳ ኑና ጥቂት ዕረፉ አላቸው፤ የሚመጡና የሚሄዱ ብዙዎች ነበሩና፥ ለመብላት እንኳ ጊዜ አጡ። ");
INSERT INTO amh_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","በታንኳውም ብቻቸውን ወደ ምድረ በዳ ሄዱ። ");
INSERT INTO amh_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ሰዎችም ሲሄዱ አዩአቸው ብዙዎችም አወቁአቸውና ከከተሞች ሁሉ በእግር እየሮጡ ወዲያ ቀደሙአቸው ወደ እርሱም ተሰበሰቡ። ");
INSERT INTO amh_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ኢየሱስም ወጥቶ ብዙ ሕዝብ አየና እረኛ እንደሌላቸው በጎች ስለ ነበሩ አዘነላቸው፥ ብዙም ነገር ያስተምራቸው ጀመር። ");
INSERT INTO amh_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","በዚያን ጊዜም ብዙ ሰዓት ካለፈ በኋላ ደቀ መዛሙርቱ ወደ እርሱ ቀርበው። ቦታው ምድረ በዳ ነው አሁንም መሽቶአል፤ ");
INSERT INTO amh_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","የሚበሉት የላቸውምና በዙሪያ ወዳሉ ገጠሮችና መንደሮች ሄደው እንጀራ ለራሳቸው እንዲገዙ አሰናብታቸው አሉት። ");
INSERT INTO amh_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","እርሱ ግን መልሶ። እናንተ የሚበሉትን ስጡአቸው አላቸው። ሄደን እንጀራ በሁለት መቶ ዲናር እንግዛላቸውን? እንዲበሉም እንስጣቸውን? አሉት። ");
INSERT INTO amh_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","እርሱም። ስንት እንጀራ አላችሁ? ሂዱና እዩ አላቸው። ባወቁም ጊዜ። አምስት፥ ሁለትም ዓሣ አሉት። ");
INSERT INTO amh_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ሁሉንም በየክፍሉ በለመለመ ሣር ላይ እንዲያስቀምጡአቸው አዘዛቸው። ");
INSERT INTO amh_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","መቶ መቶውና አምሳ አምሳው እየሆኑ በተራ በተራ ተቀመጡ። ");
INSERT INTO amh_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","አምስቱንም እንጀራ ሁለቱንም ዓሣ ይዞ ወደ ሰማይ አሻቅቦ አየና ባረከ፥ እንጀራውንም ቈርሶ እንዲያቀርቡላቸው ለደቀ መዛሙርቱ ሰጠ፥ ");
INSERT INTO amh_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ሁለቱን ዓሣ ደግሞ ለሁሉ ከፈለ። ሁሉም በልተው ጠገቡ፤ ");
INSERT INTO amh_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ከቍርስራሹም አሥራ ሁለት መሶብ የሞላ አነሡ ከዓሣውም ደግሞ። ");
INSERT INTO amh_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","እንጀራውንም የበሉት ወንዶቹ አምስት ሺህ ነበሩ። ");
INSERT INTO amh_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ወዲያውም ሕዝቡን ሲያሰናብት ሳለ ደቀ መዛሙርቱ በታንኳ ገብተው ወደ ማዶ ወደ ቤተ ሳይዳ እንዲቀድሙት ግድ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ካሰናበታቸውም በኋላ ሊጸልይ ወደ ተራራ ወጣ። ");
INSERT INTO amh_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","በመሸም ጊዜ ታንኳይቱ በባሕር መካከል ሳለች እርሱ ብቻውን በምድር ላይ ነበረ። ");
INSERT INTO amh_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ነፋስ ወደ ፊታቸው ነበረና እየቀዘፉ ሲጨነቁ አይቶ፥ ከሌሊቱ በአራተኛው ክፍል በባሕር ላይ እየሄደ ወደ እነርሱ መጣ፤ ሊያልፋቸውም ይወድ ነበር። ");
INSERT INTO amh_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","እነርሱ ግን በባሕር ላይ ሲሄድ ባዩት ጊዜ ምትሀት መሰላቸውና ጮኹ፥ ");
INSERT INTO amh_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ሁሉ አይተውታልና፥ ታወኩም። ወዲያውም ተናገራቸውና። አይዞአችሁ፤ እኔ ነኝ፥ አትፍሩ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ወደ እነርሱም ወደ ታንኳይቱ ገባ፥ ነፋሱም ተወ፤ በራሳቸውም ያለ መጠን እጅግ ተገረሙ፤ ");
INSERT INTO amh_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ስለ እንጀራው አላስተዋሉምና፤ ነገር ግን ልባቸው ደንዝዞ ነበር። ");
INSERT INTO amh_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ተሻግረውም ወደ ምድር ወደ ጌንሴሬጥ ደረሱ ታንኳይቱንም አስጠጉ። ");
INSERT INTO amh_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ከታንኳይቱም ሲወጡ ወዲያው አውቀውት ");
INSERT INTO amh_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","በዚያች አገር ሁሉ ዙሪያ ሮጡና እርሱ እንዳለ ወደ ሰሙበት ስፍራ ሕመምተኞችን በአልጋ ላይ ያመጡ ጀመር። ");
INSERT INTO amh_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","በገባበትም ስፍራ ሁሉ፥ መንደርም ከተማም ገጠርም ቢሆን፥ በገበያ ድውዮችን ያኖሩ ነበር፤ የልብሱንም ጫፍ እንኳ ሊዳስሱ ይለምኑት ነበር የዳሰሱትም ሁሉ ዳኑ። ");
INSERT INTO amh_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ፈሪሳውያንና ከጻፎች ወገን ከኢየሩሳሌም የመጡትም ወደ እርሱ ተሰበሰቡ። ");
INSERT INTO amh_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ከደቀ መዛሙርቱም አንዳንድ በርኵስ ማለት ባልታጠበ እጅ እንጀራ ሲበሉ አዩ። ");
INSERT INTO amh_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ፈሪሳውያንና አይሁድም ሁሉ የሽማግሎችን ወግ ሲጠብቁ እጃቸውን ደኅና አድርገው ሳይታጠቡ አይበሉምና፥ ");
INSERT INTO amh_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ከገበያም ተመልሰው ካልታጠቡ አይበሉም፥ ጽዋንም ማድጋንም የናስ ዕቃንም አልጋንም እንደ ማጠብ ሌላ ነገር ሊጠብቁት የተቀበሉት ብዙ አለ። ");
INSERT INTO amh_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ፈሪሳውያንም ጻፎችም። ደቀ መዛሙርትህ እንደ ሽማግሌዎች ወግ ስለ ምን አይሄዱም? ነገር ግን እጃቸውን ሳይታጠቡ እንጀራ ይበላሉ ብለው ጠየቁት። ");
INSERT INTO amh_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","እርሱ ግን እንዲህ አላቸው። ኢሳይያስ ስለ እናንተ ስለ ግብዞች። ይህ ሕዝብ በከንፈሩ ያከብረኛል ልቡ ግን ከእኔ በጣም የራቀ ነው፤ ");
INSERT INTO amh_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","የሰውም ሥርዓት የሆነ ትምህርት እያስተማሩ በከንቱ ያመልኩኛል ተብሎ እንደ ተጻፈ በእውነት ትንቢት ተናገረ። ");
INSERT INTO amh_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","የእግዚአብሔርን ትእዛዝ ትታችሁ ጽዋን ማድጋንም እንደ ማጠብ የሰውን ወግ ትጠብቃላችሁ፥ ይህንም የመሰለ ብዙ ሌላ ነገር ታደርጋላችሁ። ");
INSERT INTO amh_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","እንዲህም አላቸው። ወጋችሁን ትጠብቁ ዘንድ የእግዚአብሔርን ትእዛዝ እጅግ ንቃችኋል። ");
INSERT INTO amh_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ሙሴ። አባትህንና እናትህን አክብር፤ ደግሞ። አባቱን ወይም እናቱን የሰደበ ፈጽሞ ይሙት ብሎአልና። ");
INSERT INTO amh_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","እናንተ ግን ትላላችሁ። ሰው አባቱን ወይም እናቱን። ከእኔ የምትጠቀምበት ነገር ሁሉ ቍርባን ማለት መባ ነው ቢል፥ ");
INSERT INTO amh_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ለአባቱና ለእናቱ ምንም እንኳ ሊያደርግ ወደ ፊት አትፈቅዱለትም፤ ");
INSERT INTO amh_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ባስተላለፋችሁትም ወግ የእግዚአብሔርን ቃል ትሽራላችሁ፤ እንደዚሁም ይህን የሚመስል ብዙ ነገር ታደርጋላችሁ። ");
INSERT INTO amh_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ደግሞም ሕዝቡን ጠርቶ። ሁላችሁ እኔን ስሙ አስተውሉም። ");
INSERT INTO amh_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ከሰው የሚወጡት ሰውን የሚያረክሱ ናቸው እንጂ ከሰው ውጭ የሚገባውስ ሊያረክሰው የሚችል ምንም የለም። ");
INSERT INTO amh_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","የሚሰማ ጆሮ ያለው ቢኖር ይስማ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ከሕዝቡ ዘንድ ወደ ቤት ከገባ በኋላ ደቀ መዛሙርቱ ምሳሌውን ጠየቁት። ");
INSERT INTO amh_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","እርሱም። እናንተ ደግሞ እንደዚህ የማታስተውሉ ናችሁን? ከውጭ ወደ ሰው የሚገባ ሊያረክሰው ምንም እንዳይችል አትመለከቱምን? ");
INSERT INTO amh_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ወደ ሆድ ገብቶ ወደ እዳሪ ይወጣል እንጂ ወደ ልብ አይገባምና፤ መብልን ሁሉ እያጠራ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","እርሱም አለ። ከሰው የሚወጣው ሰውን የሚያረክስ ያ ነው። ");
INSERT INTO amh_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ከውስጥ ከሰው ልብ የሚወጣ ክፉ አሳብ፥ ");
INSERT INTO amh_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ዝሙት፥ መስረቅ፥ መግደል፥ ምንዝርነት፥ መጐምጀት፥ ክፋት፥ ተንኰል፥ መዳራት፥ ምቀኝነት፥ ስድብ፥ ትዕቢት፥ ስንፍና ናቸውና፤ ");
INSERT INTO amh_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ይህ ክፉው ሁሉ ከውስጥ ይወጣል ሰውን ያረክሰዋል። ");
INSERT INTO amh_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ከዚያም ተነሥቶ ወደ ጢሮስና ወደ ሲዶና አገር ሄደ። ወደ ቤትም ገብቶ ማንም እንዳያውቅበት ወደደ ሊሰወርም አልተቻለውም፤ ");
INSERT INTO amh_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ወዲያው ግን ታናሺቱ ልጅዋ ርኵስ መንፈስ ያደረባት አንዲት ሴት ስለ እርሱ ሰምታ መጣችና በእግሩ ላይ ተደፋች ");
INSERT INTO amh_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ሴቲቱም ግሪክ፥ ትውልድዋም ሲሮፊኒቃዊት ነበረች፤ ከልጅዋ ጋኔን ያወጣላት ዘንድ ለመነችው። ");
INSERT INTO amh_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ኢየሱስ ግን። ልጆቹ በፊት ይጠግቡ ዘንድ ተዪ የልጆቹን እንጀራ ይዞ ለቡችሎች መጣል አይገባምናአላት። ");
INSERT INTO amh_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","እርስዋም መልሳ። አዎን፥ ጌታ ሆይ፥ ቡችሎች እንኳ ከማዕድ በታች ሆነው የልጆችን ፍርፋሪ ይበላሉ አለችው። ");
INSERT INTO amh_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","እርሱም። ስለዚህ ቃልሽ ሂጂ ጋኔኑ ከልጅሽ ወጥቶአል አላት። ");
INSERT INTO amh_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ወደ ቤትዋም ሄዳ ጋኔኑ ወጥቶ ልጅዋም በአልጋ ላይ ተኝታ አገኘች። ");
INSERT INTO amh_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ደግሞም ከጢሮስ አገር ወጥቶ በሲዶና አልፎ አሥር ከተማ በሚባል አገር መካከል ወደ ገሊላ ባሕር መጣ። ");
INSERT INTO amh_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ደንቆሮና ኰልታፋም የሆነ ሰው ወደ እርሱ አመጡ፥ ");
INSERT INTO amh_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","እጁንም ይጭንበት ዘንድ ለመኑት። ከሕዝቡም ለይቶ ለብቻው ወሰደው፥ ጣቶቹንም በጆሮቹ አገባ እንትፍም ብሎ መላሱን ዳሰሰ፤ ");
INSERT INTO amh_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ወደ ሰማይም አሻቅቦ አይቶ ቃተተና። ኤፍታህ አለው፥ እርሱም ተከፈት ማለት ነው። ");
INSERT INTO amh_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ወዲያውም ጆሮቹ ተከፈቱ የመላሱም እስራት ተፈታ አጥርቶም ተናገረ። ");
INSERT INTO amh_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ለማንም አትንገሩ ብሎ አዘዛቸው እነርሱ ግን ባዘዛቸውም መጠን ይልቅ እጅግ አወሩት። ");
INSERT INTO amh_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ያለ መጠንም ተገረሙና። ሁሉን ደኅና አድርጎአል፤ ደንቆሮችም እንዲሰሙ ዲዳዎችም እንዲናገሩ ያደርጋል አሉ። ");
INSERT INTO amh_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","በዚያ ወራት ደግሞ ብዙ ሕዝብ ነበረ የሚበሉትም ስለሌላቸው ደቀ መዛሙርቱን ጠርቶ። ");
INSERT INTO amh_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","ሕዝቡ ከእኔ ጋር እስካሁን ሦስት ቀን ውለዋልና የሚበሉት ስለሌላቸው አዝንላቸዋለሁ፤ ");
INSERT INTO amh_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ከእነርሱም አንዳንዶቹ ከሩቅ መጥተዋልና ጦማቸውን ወደ ቤታቸው ባሰናብታቸው በመንገድ ይዝላሉ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ደቀ መዛሙርቱም። በዚህ በምድረ በዳ እንጀራ ከየት አግኝቶ ሰው እነዚህን ማጥገብ ይችላል? ብለው መለሱለት። ");
INSERT INTO amh_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","እርሱም። ስንት እንጀራ አላችሁ? ብሎ ጠየቃቸው፥ እነርሱም። ሰባት አሉት። ");
INSERT INTO amh_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ሕዝቡም በምድር እንዲቀመጡ አዘዘ። ሰባቱንም እንጀራ ይዞ አመሰገነ፥ ቈርሶም እንዲያቀርቡላቸው ለደቀ መዛሙርቱ ሰጠ፥ ለሕዝቡም አቀረቡ። ");
INSERT INTO amh_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ጥቂትም ትንሽ ዓሣ ነበራቸው፤ ባረከውም ይህንም ደግሞ እንዲያቀርቡላቸው አዘዘ። ");
INSERT INTO amh_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","በሉም ጠገቡም፥ የተረፈውንም ቍርስራሽ ሰባት ቅርጫት አነሡ። ");
INSERT INTO amh_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","የበሉትም አራት ሺህ ያህል ነበሩ። ");
INSERT INTO amh_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","አሰናበታቸውም። ወዲያውም ከደቀ መዛሙርቱ ጋር ወደ ታንኳይቱ ገብቶ ወደ ዳልማኑታ አገር መጣ። ");
INSERT INTO amh_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ፈሪሳውያንም ወጡና ሊፈትኑት ከሰማይ ምልክት ከእርሱ ፈልገው ከእርሱ ጋር ይከራከሩ ጀመር። ");
INSERT INTO amh_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","በመንፈሱም እጅግ ቃተተና። ይህ ትውልድ ስለ ምን ምልክት ይፈልጋል? እውነት እላችኋለሁ፥ ለዚህ ትውልድ ምልክት አይሰጠውም አለ። ");
INSERT INTO amh_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ትቶአቸውም እንደ ገና ወደ ታንኳይቱ ገብቶ ወደ ማዶ ሄደ። ");
INSERT INTO amh_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","እንጀራ መያዝም ረሱ፥ ለእነርሱም ከአንድ እንጀራ በቀር በታንኳይቱ አልነበራቸውም። ");
INSERT INTO amh_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","እርሱም። ተጠንቀቁ፤ ከፈሪሳውያንና ከሄሮድስ እርሾ ተጠበቁ ብሎ አዘዛቸው። ");
INSERT INTO amh_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","እርስ በርሳቸውም። እንጀራ ስለሌለን ይሆናል ብለው ተነጋገሩ። ");
INSERT INTO amh_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ኢየሱስም አውቆ እንዲህ አላቸው። እንጀራ ስለሌላችሁ ስለ ምን ትነጋገራላችሁ? ገና አልተመለከታችሁምን? አላስተዋላችሁምን? ");
INSERT INTO amh_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ልባችሁስ ደንዝዞአልን? ዓይን ሳላችሁ አታዩምን? ጆሮስ ሳላችሁ አትሰሙምን? ትዝስ አይላችሁምን? ");
INSERT INTO amh_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","አምስቱን እንጀራ ለአምስት ሺህ በቈረስሁ ጊዜ፥ ቍርስራሹ የሞላ ስንት መሶብ አነሣችሁ? እነርሱም። አሥራ ሁለት አሉት። ");
INSERT INTO amh_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ሰባቱን እንጀራስ ለአራት ሺህ በቈረስሁ ጊዜ፥ ቍርስራሹ የሞላ ስንት ቅርጫት አነሣችሁ? እነርሱም። ሰባት አሉት። ");
INSERT INTO amh_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ገና አላስተዋላችሁምን? አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ወደ ቤተ ሳይዳም መጡ። ዕውርም አመጡለት፥ እንዲዳስሰውም ለመኑት። ");
INSERT INTO amh_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ዕውሩንም እጁን ይዞ ከመንደር ውጭ አወጣው፥ በዓይኑም ተፍቶበት እጁንም ጭኖበት። አንዳች ታያለህን ብሎ ጠየቀው። ");
INSERT INTO amh_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","አሻቅቦም። ሰዎች እንደ ዛፍ ሲመላለሱ አያለሁ አለ። ");
INSERT INTO amh_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ከዚህም በኋላ ደግሞ እጁን በዓይኑ ላይ ጫነበት አጥርቶም አየና ዳነም ከሩቅም ሳይቀር ሁሉን ተመለከተ። ");
INSERT INTO amh_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ወደ ቤቱም ሰደደውና። ወደ መንደሩ አትግባ በመንደሩም ለማንም አንዳች አትናገር አለው። ");
INSERT INTO amh_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ኢየሱስና ደቀ መዛሙርቱም በፊልጶስ ቂሣርያ ወዳሉ መንደሮች ወጡ በመንገድም። ሰዎች እኔ ማን እንደ ሆንሁ ይላሉ? ብሎ ደቀ መዛሙርቱን ጠየቃቸው። ");
INSERT INTO amh_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","እነርሱም። መጥምቁ ዮሐንስ፥ ሌሎችም ኤልያስ፥ ሌሎችም ከነቢያት አንዱ ብለው ነገሩት። ");
INSERT INTO amh_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","እናንተስ እኔ ማን እንደ ሆንሁ ትላላችሁ? ብሎ ጠየቃቸው። ጴጥሮስም። አንተ ክርስቶስ ነህ ብሎ መለሰለት። ");
INSERT INTO amh_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ስለ እርሱም ለማንም እንዳይናገሩ አዘዛቸው። ");
INSERT INTO amh_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","የሰው ልጅ ብዙ መከራ ሊቀበል፥ ከሽማግሌዎችም ከካህናት አለቆችም ከጻፎችም ሊጣል፥ ሊገደልም ከሦስት ቀንም በኋላ ሊነሣ እንዲገባው ያስተምራቸው ጀመር፤ ቃሉንም ገልጦ ይናገር ነበር። ");
INSERT INTO amh_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ጴጥሮስም ወደ እርሱ ወስዶ ይገሥጸው ጀመር። ");
INSERT INTO amh_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","እርሱ ግን ዘወር አለ ደቀ መዛሙርቱንም አይቶ ጴጥሮስን ገሠጸውና። ወደ ኋላዬ ሂድ፥ አንተ ሰይጣን፤ የሰውን እንጂ የእግዚአብሔርን ነገር አታስብምና አለው። ");
INSERT INTO amh_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ሕዝቡንም ከደቀ መዛሙርቱ ጋር ጠርቶ እንዲህ አላቸው። በኋላዬ ሊመጣ የሚወድ ቢኖር፥ ራሱን ይካድ መስቀሉንም ተሸክሞ ይከተለኝ። ");
INSERT INTO amh_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ነፍሱን ሊያድን የሚወድ ሁሉ ያጠፋታልና፥ ስለ እኔና ስለ ወንጌል ነፍሱን የሚያጠፋ ሁሉ ግን ያድናታል። ");
INSERT INTO amh_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ሰው ዓለምን ሁሉ ቢያተርፍ ነፍሱንም ቢያጐድል ምን ይጠቅመዋል? ");
INSERT INTO amh_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ሰውስ ስለ ነፍሱ ቤዛ ምን ይሰጣል? ");
INSERT INTO amh_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","በዚህም በዘማዊና በኃጢአተኛ ትውልድ መካከል በእኔና በቃሌ የሚያፍር ሁሉ፥ የሰው ልጅ ደግሞ በአባቱ ክብር ከቅዱሳን መላእክት ጋር በመጣ ጊዜ በእርሱ ያፍርበታል። ");
INSERT INTO amh_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","እውነት እላችኋለሁ፥ በዚህ ከቆሙት ሰዎች የእግዚአብሔር መንግሥት በኃይል ስትመጣ እስኪያዩ ድረስ፥ ሞትን የማይቀምሱ አንዳንዶች አሉ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ከስድስት ቀንም በኋላ ኢየሱስ ጴጥሮስንና ያዕቆብን ዮሐንስንም ይዞ ወደ ረጅም ተራራ ብቻቸውን አወጣቸው። በፊታቸውም ተለወጠ፥ ልብሱም አንጸባረቀ፤ ");
INSERT INTO amh_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","አጣቢም በምድር ላይ እንደዚያ ሊያነጣው እስከማይችል በጣም ነጭ ሆነ። ");
INSERT INTO amh_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ኤልያስና ሙሴም ታዩአቸው፥ ከኢየሱስም ጋር ይነጋገሩ ነበር። ");
INSERT INTO amh_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ጴጥሮስም መልሶ ኢየሱስን። መምህር ሆይ፥ በዚህ መሆን ለእኛ መልካም ነውና አንድ ለአንተ አንድም ለሙሴ አንድም ለኤልያስ ሦስት ዳሶች እንሥራ አለው። ");
INSERT INTO amh_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","እጅግ ስለ ፈሩ የሚለውን አያውቅም ነበር። ");
INSERT INTO amh_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ደመናም መጥቶ ጋረዳቸው፥ ከደመናውም። የምወደው ልጄ ይህ ነው፥ እርሱን ስሙት የሚል ድምፅ መጣ። ");
INSERT INTO amh_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ድንገትም ዞረው ሲመለከቱ ከእነርሱ ጋር ከኢየሱስ ብቻ በቀር ማንንም አላዩም። ");
INSERT INTO amh_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ከተራራውም ሲወርዱ የሰው ልጅ ከሙታን እስኪነሣ ድረስ ያዩትን ለማንም እንዳይነግሩ አዘዛቸው። ");
INSERT INTO amh_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ቃሉንም ይዘው። ከሙታን መነሣት ምንድር ነው? እያሉ እርስ በርሳቸው ተጠያየቁ። ");
INSERT INTO amh_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","እነርሱም። ኤልያስ አስቀድሞ ሊመጣ እንዲገባው ጻፎች ስለ ምን ይላሉ? ብለው ጠየቁት። ");
INSERT INTO amh_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","እርሱም መልሶ። ኤልያስማ አስቀድሞ ይመጣል ሁሉንም ያቀናናል፤ ስለ ሰው ልጅም እንዴት ተብሎ ተጽፎአል? ብዙ መከራ እንዲቀበል እንዲናቅም። ");
INSERT INTO amh_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ነገር ግን እላችኋለሁ፥ ኤልያስ ደግሞ መጥቶአል፥ ስለ እርሱም እንደ ተጸፈ የወደዱትን ሁሉ አደረጉበት አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ወደ ደቀ መዛሙርቱም በመጣ ጊዜ ብዙ ሕዝብ ሲከብቡአቸው ጻፎችም ከእነርሱ ጋር ሲከራከሩ አየ። ");
INSERT INTO amh_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ወዲያውም ሕዝቡ ሁሉ ባዩት ጊዜ ደነገጡ፥ ወደ እርሱም ሮጠው እጅ ነሡት። ");
INSERT INTO amh_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ጻፎችንም። ስለ ምን ከእነርሱ ጋር ትከራከራላችሁ? ብሎ ጠየቃቸው። ");
INSERT INTO amh_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ከሕዝቡ አንዱ መልሶ። መምህር ሆይ፥ ዲዳ መንፈስ ያደረበትን ልጄን ወደ አንተ አምጥቼአለሁ፤ ");
INSERT INTO amh_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","በያዘውም ስፍራ ሁሉ ይጥለዋል፤ አረፋም ይደፍቃል፥ ጥርሱንም ያፋጫል ይደርቃልም፤ እንዲያወጡለትም ለደቀ መዛሙርትህ ነገርኋቸው፥ አልቻሉምም አለው። ");
INSERT INTO amh_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","እርሱም መልሶ። የማታምን ትውልድ ሆይ፥ እስከመቼ ከእናንተ ጋር እኖራለሁ? እስከ መቼስ እታገሣችኋለሁ? ወደ እኔ አምጡት አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ወደ እርሱም አመጡት። እርሱንም ባየ ጊዜ ያ መንፈስ ወዲያው አንፈራገጠው፤ ወደ ምድርም ወድቆ አረፋ እየደፈቀ ተንፈራፈረ። ");
INSERT INTO amh_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","አባቱንም። ይህ ከያዘው ስንት ዘመን ነው? ብሎ ጠየቀው። እርሱም። ከሕፃንነቱ ጀምሮ ነው፤ ");
INSERT INTO amh_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ብዙ ጊዜም ሊያጠፋው ወደ እሳትም ወደ ውኃም ጣለው፤ ቢቻልህ ግን እዘንልን እርዳንም አለው። ");
INSERT INTO amh_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ኢየሱስም። ቢቻልህ ትላለህ፤ ለሚያምን ሁሉ ይቻላል አለው። ");
INSERT INTO amh_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ወዲያውም የብላቴናው አባት ጮኾ። አምናለሁ፤ አለማመኔን እርዳው አለ። ");
INSERT INTO amh_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ኢየሱስም ሕዝቡ እንደ ገና ሲራወጥ አይቶ ርኵሱን መንፈስ ገሠጸና። አንተ ዲዳ ደንቆሮም መንፈስ፥ እኔ አዝሃለሁ፥ ከእርሱ ውጣ እንግዲህም አትግባበት አለው። ");
INSERT INTO amh_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ጮኾም እጅግም አንፈራግጦት ወጣ፤ ብዙዎችም። ሞተ እስኪሉ ድረስ እንደ ሙት ሆነ። ");
INSERT INTO amh_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ኢየሱስ ግን እጁን ይዞ አስነሣው ቆመም። ");
INSERT INTO amh_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ወደ ቤትም ከገባ በኋላ ደቀ መዛሙርቱ። እኛ ልናወጣው ያልቻልን ስለ ምንድር ነው? ብለው ብቻውን ጠየቁት። ");
INSERT INTO amh_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ይህ ወገን በጸሎትና በጦም ካልሆነ በምንም ሊወጣ አይችልም አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","32","እነርሱም ነገሩን አላስተዋሉም፥ እንዳይጠይቁትም ፈሩ። ");
INSERT INTO amh_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ወደ ቅፍርናሆምም መጣ። በቤትም ሆኖ። በመንገድ እርስ በርሳችሁ ምን ተነጋገራችሁ? ብሎ ጠየቃቸው። ");
INSERT INTO amh_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","እነርሱ ግን በመንገድ። ከሁሉ የሚበልጥ ማን ይሆን? ተባብለው ነበርና ዝም አሉ። ");
INSERT INTO amh_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ተቀምጦም አሥራ ሁለቱን ጠርቶ። ሰው ፊተኛ ሊሆን ቢወድ ከሁሉ በኋላ የሁሉም አገልጋይ ይሁን አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ሕፃንም ይዞ በመካከላቸው አቆመው አቅፎም። ");
INSERT INTO amh_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","እንደዚህ ካሉ ሕፃናት አንዱን በስሜ የሚቀበል ሁሉ እኔን ይቀበላል፤ የሚቀበለኝም ሁሉ የላከኝን እንጂ እኔን አይቀበልም አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ዮሐንስ መልሶ። መምህር ሆይ፥ አንድ ሰው በስምህ አጋንንትን ሲያወጣ አየነው፥ ");
INSERT INTO amh_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ስለማይከተለንም ከለከልነው አለው። ኢየሱስ ግን አለ። በስሜ ተአምር ሠርቶ በቶሎ በእኔ ላይ ክፉ መናገር የሚችል ማንም የለምና አትከልክሉት፤ ");
INSERT INTO amh_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","የማይቃወመን እርሱ ከእኛ ጋር ነውና። ");
INSERT INTO amh_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","የክርስቶስ ስለ ሆናችሁ በስሜ ጽዋ ውኃ የሚያጠጣችሁ ሁሉ፥ ዋጋው እንዳይጠፋበት እውነት እላችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","በእኔም ከሚያምኑት ከእነዚህ ከታናናሾቹ አንዱን የሚያሰናክል ሁሉ ትልቅ የወፍጮ ድንጋይ በአንገቱ ታስሮ ወደ ባሕር ቢጣል ይሻለው ነበር። ");
INSERT INTO amh_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","49","ሰው ሁሉ በእሳት ይቀመማልና፥ መሥዋዕትም ሁሉ በጨው ይቀመማል። ");
INSERT INTO amh_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ጨው መልካም ነው፤ ጨው ግን አልጫ ቢሆን በምን ታጣፍጡታላችሁ? በነፍሳችሁ ጨው ይኑርባችሁ፥ እርስ በርሳችሁም ተስማሙ። ");
INSERT INTO amh_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ከዚያም ተነሥቶ በዮርዳኖስ ማዶ ወደ ይሁዳ አገር መጣ፥ ደግሞም ብዙ ሰዎች ወደ እርሱ ተሰበሰቡ እንደ ልማዱም ደግሞ ያስተምራቸው ነበር። ");
INSERT INTO amh_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ፈሪሳውያንም ቀርበው። ሰው ሚስቱን ሊፈታ ተፈቅዶለታልን? ብለው ሊፈትኑት ጠየቁት። ");
INSERT INTO amh_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","እርሱ ግን መልሶ። ሙሴ ምን አዘዛችሁ? አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","እነርሱም። ሙሴስ የፍችዋን ጽሕፈት ጽፎ እንዲፈታት ፈቀደ አሉ። ");
INSERT INTO amh_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ኢየሱስም መልሶ እንዲህ አላቸው። ስለ ልባችሁ ጥንካሬ ይህችን ትእዛዝ ጻፈላችሁ። ");
INSERT INTO amh_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ከፍጥረት መጀመሪያ ግን እግዚአብሔር ወንድና ሴት አደረጋቸው፤ ");
INSERT INTO amh_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ስለዚህ ሰው አባቱንና እናቱን ይተዋል ከሚስቱም ጋር ይተባበራል፥ ");
INSERT INTO amh_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ሁለቱም አንድ ሥጋ ይሆናሉ፤ ስለዚህ አንድ ሥጋ ናቸው እንጂ ወደ ፊት ሁለት አይደሉም። ");
INSERT INTO amh_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","እግዚአብሔር ያጣመረውን እንግዲህ ሰው አይለየው። ");
INSERT INTO amh_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","በቤትም ደግሞ ደቀ መዛሙርቱ ስለዚህ ነገር ጠየቁት። ");
INSERT INTO amh_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","እርሱም። ሚስቱን ፈትቶ ሌላ የሚያገባ ሁሉ በእርስዋ ላይ ያመነዝራል፤ ");
INSERT INTO amh_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","እርስዋም ባልዋን ፈትታ ሌላ ብታገባ ታመነዝራለች አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","እንዲዳስሳቸውም ሕፃናትን ወደ እርሱ አመጡ፤ ደቀ መዛሙርቱም ያመጡአቸውን ገሠጹአቸው። ");
INSERT INTO amh_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ኢየሱስ ግን አይቶ ተቈጣና። ሕፃናትን ወደ እኔ ይመጡ ዘንድ ተዉ አትከልክሉአቸው፤ የእግዚአብሔር መንግሥት እንደነዚህ ላሉት ናትና። ");
INSERT INTO amh_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","እውነት እላችኋለሁ፤ የእግዚአብሔርን መንግሥት እንደ ሕፃን የማይቀበላት ሁሉ ከቶ አይገባባትም አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","አቀፋቸውም እጁንም ጭኖ ባረካቸው። ");
INSERT INTO amh_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","እርሱም በመንገድ ሲወጣ አንድ ሰው ወደ እርሱ ሮጦ ተንበረከከለትና። ቸር መምህር ሆይ፥ የዘላለም ሕይወትን እወርስ ዘንድ ምን ላድርግ? ብሎ ጠየቀው። ");
INSERT INTO amh_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ኢየሱስም። ስለ ምን ቸር ትለኛለህ? ከአንዱ ከእግዚአብሔር በቀር ቸር ማንም የለም። ");
INSERT INTO amh_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ትእዛዛትን ታውቃለህ፤ አታመንዝር፥ አትግደል፥ አትስረቅ፥ በሐሰት አትመስክር፥ አታታልል፥ አባትህንና እናትህን አክብር አለው። ");
INSERT INTO amh_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","እርሱም መልሶ። መምህር ሆይ፥ ይህን ሁሉ ከሕፃንነቴ ጀምሬ ጠብቄአለሁ አለው። ");
INSERT INTO amh_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ኢየሱስም ወደ እርሱ ተመልክቶ ወደደውና። አንድ ነገር ጐደለህ፤ ሂድ፥ ያለህን ሁሉ ሽጠህ ለድሆች ስጥ፥ በሰማይም መዝገብ ታገኛለህ፥ መስቀሉንም ተሸክመህ ና፥ ተከተለኝ አለው። ");
INSERT INTO amh_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ነገር ግን ስለዚህ ነገር ፊቱ ጠቈረ፥ ብዙ ንብረት ነበረውና እያዘነም ሄደ። ");
INSERT INTO amh_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ኢየሱስም ዘወር ብሎ አይቶ ደቀ መዛሙርቱን። ገንዘብ ላላቸው ወደ እግዚአብሔር መንግሥት መግባት እንዴት ጭንቅ ይሆናል አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ደቀ መዛሙርቱም እነዚህን ቃሎች አደነቁ። ኢየሱስም ደግሞ መልሶ። ልጆች ሆይ፥ በገንዘብ ለሚታመኑ ወደ እግዚአብሔር መንግሥት መግባት እንዴት ጭንቅ ነው። ");
INSERT INTO amh_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ባለ ጠጋ ወደ እግዚአብሔር መንግሥት ከሚገባ ግመል በመርፌ ቀዳዳ ቢያልፍ ይቀላል አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","እነርሱም ያለ መጠን ተገረሙና እርስ በርሳቸው። እንግዲያ ማን ሊድን ይችላል? ተባባሉ። ");
INSERT INTO amh_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ኢየሱስም ተመለከታቸውና። ይህ በእግዚአብሔር ዘንድ እንጂ በሰው ዘንድ አይቻልም፤ በእግዚአብሔር ዘንድ ሁሉ ይቻላልና አለ። ");
INSERT INTO amh_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ጴጥሮስም። እነሆ፥ እኛ ሁሉን ትተን ተከተልንህ ይለው ጀመር። ");
INSERT INTO amh_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ኢየሱስም መልሶ እንዲህ አለ። እውነት እላችኋለሁ፥ ስለ እኔና ስለ ወንጌል ቤትን ወይም ወንድሞችን ወይም እኅቶችን ወይም አባትን ወይም እናትን ወይም ሚስትን ወይም ልጆችን ወይም እርሻን የተወ፥ ");
INSERT INTO amh_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","አሁን በዚህ ዘመን ከስደት ጋር ቤቶችን ወንድሞችንና እኅቶችንም እናቶችንም ልጆችንም እርሻንም መቶ እጥፍ፥ በሚመጣውም ዓለም የዘላለም ሕይወት የማይቀበል ማንም የለም። ");
INSERT INTO amh_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ግን ብዙ ፊተኞች ኋለኞች ኋለኞችም ፊተኞች ይሆናሉ። ");
INSERT INTO amh_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ወደ ኢየሩሳሌምም ሊወጡ በመንገድ ነበሩ፥ ኢየሱስም ይቀድማቸው ነበርና ተደነቁ፤ የተከተሉትም ይፈሩ ነበር። ደግሞም አሥራ ሁለቱን ወደ እርሱ አቅርቦ ይደርስበት ዘንድ ያለውን ይነግራቸው ጀመር። ");
INSERT INTO amh_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","እነሆ፥ ወደ ኢየሩሳሌም እንወጣለን፥ የሰው ልጅም ለካህናት አለቆችና ለጻፎች አልፎ ይሰጣል፥ የሞት ፍርድም ይፈርዱበታል፥ ለአሕዛብም አሳልፈው ይሰጡታል፥ ");
INSERT INTO amh_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ይዘብቱበትማል ይተፉበትማል ይገርፉትማል ይገድሉትማል፥ በሦስተኛውም ቀን ይነሣል አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","የዘብዴዎስ ልጆች ያዕቆብና ዮሐንስም ወደ እርሱ ቀርበው። መምህር ሆይ፥ የምንለምንህን ሁሉ እንድታደርግልን እንወዳለን አሉት። ");
INSERT INTO amh_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","እርሱም። ምን ላደርግላችሁ ትወዳላችሁ? አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","እነርሱም። በክብርህ ጊዜ አንዳችን በቀኝ አንዳችንም በግራህ መቀመጥን ስጠን አሉት። ");
INSERT INTO amh_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ኢየሱስ ግን። የምትለምኑትን አታውቁም። እኔ የምጠጣውን ጽዋ ልትጠጡ፥ እኔ የምጠመቀውንስ ጥምቀት ልትጠመቁ ትችላላችሁን? አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","እነርሱም። እንችላለን አሉት። ኢየሱስም። እኔ የምጠጣውን ጽዋ ትጠጣላችሁ፥ እኔ የምጠመቀውንም ጥምቀት ትጠመቃላችሁ፤ ");
INSERT INTO amh_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","በቀኝና በግራ መቀመጥ ግን ለተዘጋጀላቸው ነው እንጂ የምሰጥ እኔ አይደለሁም አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","አሥሩም ሰምተው በያዕቆብና በዮሐንስ ይቈጡ ጀመር። ");
INSERT INTO amh_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ኢየሱስም ወደ እርሱ ጠርቶ እንዲህ አላቸው። የአሕዛብ አለቆች ተብሎ የምታስቡት እንዲገዙአቸው ታላላቆቻቸውም በላያቸው እንዲሠለጥኑ ታውቃላችሁ። ");
INSERT INTO amh_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","በእናንተስ እንዲህ አይደለም፤ ነገር ግን ማንም ከእናንተ ታላቅ ሊሆን የሚወድ የእናንተ አገልጋይ ይሁን፥ ");
INSERT INTO amh_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ከእናንተም ማንም ፊተኛ ሊሆን የሚወድ የሁሉ ባሪያ ይሁን፤ ");
INSERT INTO amh_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","እንዲሁ የሰው ልጅም ሊያገለግልና ነፍሱን ለብዙዎች ቤዛ ሊሰጥ እንጂ እንዲያገለግሉት አልመጣም። ");
INSERT INTO amh_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ወደ ኢያሪኮም መጡ። ከደቀ መዛሙርቱና ከብዙ ሕዝብ ጋር ከኢያሪኮ ሲወጣ የጤሜዎስ ልጅ ዕውሩ በርጤሜዎስ እየለመነ በመንገድ ዳር ተቀምጦ ነበር። ");
INSERT INTO amh_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","የናዝሬቱ ኢየሱስም እንደ ሆነ በሰማ ጊዜ። የዳዊት ልጅ ኢየሱስ ሆይ፥ ማረኝ እያለ ይጮኽ ጀመር። ");
INSERT INTO amh_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ብዙዎችም ዝም እንዲል ገሠጹት፤ እርሱ ግን። የዳዊት ልጅ ሆይ፥ ማረኝ እያለ አብዝቶ ጮኸ። ");
INSERT INTO amh_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ኢየሱስም ቆመና። ጥሩት አለ። ዕውሩንም። አይዞህ፥ ተነሣ፥ ይጠራሃል ብለው ጠሩት። ");
INSERT INTO amh_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","እርሱም እየዘለለ ተነሣና ልብሱን ጥሎ ወደ ኢየሱስ መጣ። ");
INSERT INTO amh_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ኢየሱስም መልሶ። ምን ላደርግልህ ትወዳለህ? አለው። ዕውሩም። መምህር ሆይ፥ አይ ዘንድ አለው። ");
INSERT INTO amh_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ኢየሱስም። ሂድ፤ እምነትህ አድኖሃል አለው። ወዲያውም አየ በመንገድም ተከተለው። ");
INSERT INTO amh_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ወደ ኢየሩሳሌምም ከደብረ ዘይት አጠገብ ወዳሉቱ ወደ ቤተ ፋጌና ወደ ቢታንያ በቀረቡ ጊዜ፥ ከደቀ መዛሙርቱ ሁለቱን ልኮ። ");
INSERT INTO amh_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","በፊታችሁ ወዳለችው መንደር ሂዱ፥ ወዲያውም ወደ እርስዋ ገብታችሁ ከሰው ማንም ገና ያልተቀመጠበት ውርንጫ ታስሮ ታገኛላችሁ፤ ፈትታችሁ አምጡልኝ። ");
INSERT INTO amh_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ማንም። ስለ ምን እንዲህ ታደርጋላችሁ? ቢላችሁ። ለጌታ ያስፈልገዋል በሉት፥ ወዲያውም ደግሞ ወደዚህ ይሰደዋል አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ሄዱም ውርንጫውንም በመንገድ መተላለፊያ በደጅ ውጭ ታስሮ አገኙት፥ ፈቱትም። ");
INSERT INTO amh_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","በዚያም ከቆሙት አንዳንዶቹ። ውርንጫውን የምትፈቱት ምን ልታደርጉት ነው አሉአቸው። ");
INSERT INTO amh_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","እነርሱም ኢየሱስ እንዳዘዘ አሉአቸው፤ ተዉአቸውም። ");
INSERT INTO amh_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ውርንጫውንም ወደ ኢየሱስ አመጡት፥ ልብሳቸውንም በላዩ ጣሉ፥ ተቀመጠበትም። ");
INSERT INTO amh_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ብዙ ሰዎችም ልብሳቸውን በመንገድ ላይ አነጠፉ፥ ሌሎችም ከዛፍ ቅጠሎችን እየቈረጡ ያነጥፉ ነበር። ");
INSERT INTO amh_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","የሚቀድሙትም የሚከተሉትም። ሆሣዕና፤ በጌታ ስም የሚመጣ የተባረከ ነው፤ ");
INSERT INTO amh_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","በጌታ ስም የምትመጣ የአባታችን የዳዊት መንግሥት የተባረከች ናት፤ ሆሣዕና በአርያም እያሉ ይጮኹ ነበር። ");
INSERT INTO amh_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ኢየሱስም ወደ ኢየሩሳሌም ወደ መቅደስ ገባ፤ ዘወር ብሎም ሁሉን ከተመለከተ በኋላ፥ ጊዜው መሽቶ ስለ ነበረ ከአሥራ ሁለቱ ጋር ወደ ቢታንያ ወጣ። ");
INSERT INTO amh_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","በማግሥቱም ከቢታንያ ሲወጡ ተራበ። ");
INSERT INTO amh_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ቅጠልም ያላት በለስ ከሩቅ አይቶ ምናልባት አንዳች ይገኝባት እንደ ሆነ ብሎ መጣ፥ ነገር ግን የበለስ ወራት አልነበረምና መጥቶ ከቅጠል በቀር ምንም አላገኘባትም። ");
INSERT INTO amh_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","መልሶም። ከአሁን ጀምሮ ለዘላለም ማንም ከአንቺ ፍሬ አይብላ አላት። ደቀ መዛሙርቱም ሰሙ። ");
INSERT INTO amh_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ወደ ኢየሩሳሌምም መጡ። ወደ መቅደስም ገብቶ በመቅደስ የሚሸጡትንና የሚገዙትን ያወጣ ጀመር፥ የገንዘብ ለዋጮችንም ገበታዎች የርግብ ሻጭዎችንም ወንበሮች ገለበጠ፤ ");
INSERT INTO amh_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ዕቃም ተሸክሞ ማንም በመቅደስ ሊያልፍ አልፈቀደም። ");
INSERT INTO amh_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","አስተማራቸውም። ቤቴ ለአሕዛብ ሁሉ የጸሎት ቤት ትባላለች ተብሎ የተጻፈ አይደለምን? እናንተ ግን የወንበዶች ዋሻ አደረጋችኋት አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","የካህናት አለቆችም ጻፎችም ሰምተው፥ ሕዝቡ ሁሉ በትምህርቱ ይገረሙ ስለ ነበር ይፈሩት ነበርና እንዴት አድርገው እንዲያጠፉት ፈለጉ። ");
INSERT INTO amh_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ማታ ማታም ከከተማ ወደ ውጭ ይወጣ ነበር። ");
INSERT INTO amh_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ማለዳም ሲያልፉ በለሲቱን ከሥርዋ ደርቃ አዩአት። ");
INSERT INTO amh_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ጴጥሮስም ትዝ ብሎት። መምህር ሆይ፥ እነሆ፥ የረገምሃት በለስ ደርቃለች አለው። ");
INSERT INTO amh_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ኢየሱስም መልሶ እንዲህ አላቸው። በእግዚአብሔር እመኑ። ");
INSERT INTO amh_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","እውነት እላችኋለሁ፥ ማንም ያለው ነገር እንዲደረግለት ቢያምን በልቡ ሳይጠራጠር፥ ይህን ተራራ። ተነቅለህ ወደ ባሕር ተወርወር ቢል ይሆንለታል። ");
INSERT INTO amh_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ስለዚህ እላችኋለሁ፥ የጸለያችሁትን የለመናችሁትንም ሁሉ እንዳገኛችሁት እመኑ፥ ይሆንላችሁማል። ");
INSERT INTO amh_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ለጸሎትም በቆማችሁ ጊዜ፥ በሰማያት ያለው አባታችሁ ደግሞ ኃጢአታችሁን ይቅር እንዲላችሁ፥ በማንም ላይ አንዳች ቢኖርባችሁ ይቅር በሉት። ");
INSERT INTO amh_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","እናንተ ግን ይቅር ባትሉ በሰማያት ያለው አባታችሁም ኃጢአታችሁን ይቅር አይላችሁም። ");
INSERT INTO amh_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ደግሞም ወደ ኢየሩሳሌም መጡ። እርሱም በመቅደስ ሲመላለስ፥ የካህናት አለቆችና ጻፎች ሽማግሌዎችም ወደ እርሱ መጥተው። ");
INSERT INTO amh_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","እነዚህን በምን ሥልጣን ታደርጋለህ? ወይስ እነዚህን ለማድረግ ይህን ሥልጣን ማን ሰጠህ? አሉት። ");
INSERT INTO amh_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ኢየሱስም። እኔም አንዲት ነገር እጠይቃችኋለሁ፥ እናንተም መልሱልኝ፥ እኔም በምን ሥልጣን እነዚህን እንዳደርግ እነግራችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","የዮሐንስ ጥምቀት ከሰማይ ነበረችን ወይስ ከሰው? መልሱልኝ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","እርስ በርሳቸውም ሲነጋገሩ። ከሰማይ ነው ብንል። እንግዲያውስ ስለ ምን አላመናችሁበትም? ይለናል፤ ");
INSERT INTO amh_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ነገር ግን። ከሰው ነው እንበልን? አሉ፤ ሁሉ ዮሐንስን በእውነት እንደ ነቢይ ያዩት ነበርና ሕዝቡን ፈሩ። ");
INSERT INTO amh_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ለኢየሱስም መልሰው። አናውቅም አሉት ኢየሱስም። እኔም በምን ሥልጣን እነዚህን እንዳደርግ አልነግራችሁም አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","በምሳሌም ይነግራቸው ጀመር። አንድ ሰው የወይን አትክልት ተከለ፥ ቅጥርም ቀጠረለት፥ መጥመቂያም ማሰለት፥ ግንብም ሠራና ለገበሬዎች አከራይቶ ወደ ሌላ አገር ሄደ። ");
INSERT INTO amh_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","በጊዜውም ከወይን አትክልት ፍሬ ከገበሬዎቹ እንዲቀበል አንድ ባሪያ ወደ ገበሬዎቹ ላከ፤ ");
INSERT INTO amh_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ይዘውም ደበደቡት ባዶውንም ሰደዱት። ");
INSERT INTO amh_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ዳግመኛም ሌላውን ባሪያ ወደ እነርሱ ላከ እርሱንም ወግረው ራሱን አቈሰሉት አዋርደውም ሰደዱት። ");
INSERT INTO amh_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ሌላውንም ላከ፤ እርሱንም ገደሉት፥ ከሌሎችም ከብዙዎች አንዳንዱን ደበደቡ አንዳንዱንም ገደሉ። ");
INSERT INTO amh_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","የሚወደው አንድ ልጅ ገና ነበረው፤ ልጄንስ ያፍሩታል ብሎ እርሱን ከሁሉ በኋላ ወደ እነርሱ ላከ። ");
INSERT INTO amh_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","እነዚያ ገበሬዎች ግን እርስ በርሳቸው። ወራሹ ይህ ነው፤ ኑ፥ እንግደለው፥ ርስቱም ለኛ ይሆናል ተባባሉ። ");
INSERT INTO amh_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ይዘውም ገደሉት፥ ከወይኑም አትክልት ወደ ውጭ ጣሉት። ");
INSERT INTO amh_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","እንግዲህ የወይኑ አትክልት ጌታ ምን ያደርጋል? ይመጣል ገበሬዎቹንም ያጠፋል፥ የወይኑንም አትክልት ለሌሎች ይሰጣል። ");
INSERT INTO amh_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","12","ምሳሌውንም ስለ እነርሱ እንደ ተናገረ አውቀዋልና ሊይዙት ፈለጉ፥ ነገር ግን ሕዝቡን ፈሩ። ትተውትም ሄዱ። ");
INSERT INTO amh_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","በንግግርም ሊያጠምዱት ከፈሪሳውያንና ከሄሮድስ ወገን የሆኑትን ወደ እርሱ ላኩ። ");
INSERT INTO amh_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","መጥተውም። መምህር ሆይ፥ የሰውን ፊት ሳትመለከት በእውነት የእግዚአብሔር መንገድ ታስተምራለህና እውነተኛ እንደ ሆንህ ለማንምም እንዳታደላ እናውቃለን፤ ለቄሣር ግብር መስጠት ተፈቅዶአልን ወይስ አልተፈቀደም? እንስጥን ወይስ አንስጥ? አሉት። ");
INSERT INTO amh_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","እርሱ ግን ግብዝነታቸውን አውቆ። ለምን ትፈትኑኛላችሁ? አየው ዘንድ አንድ ዲናር አምጡልኝ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","እነርሱም አመጡለት። ይህች መልክ ጽሕፈቲቱስ የማን ናት? አላቸው፤ እነርሱም። የቄሣር ናት አሉት። ");
INSERT INTO amh_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ኢየሱስም መልሶ። የቄሣርን ለቄሣር የእግዚአብሔርንም ለእግዚአብሔር አስረክቡ አላቸው። በእርሱም ተደነቁ። ");
INSERT INTO amh_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ትንሣኤ ሙታን የለም የሚሉ ሰዱቃውያን ወደ እርሱ መጥተው ጠየቁት እንዲህም አሉት። ");
INSERT INTO amh_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","መምህር ሆይ፥ ሙሴ። የአንድ ሰው ወንድም ሚስቱን ትቶ ልጅ ሳያስቀር ቢሞት፥ ወንድሙ ሚስቱን አግብቶ ለወንድሙ ዘር ይተካ ብሎ ጻፈልን። ");
INSERT INTO amh_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ሰባት ወንድማማቾች ነበሩ፤ ፊተኛውም ሚስት አግብቶ ዘር ሳያስቀር ሞተ፤ ");
INSERT INTO amh_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ሁለተኛውም አገባት፥ ዘርም ሳይተው ሞተ፤ ሦስተኛውም እንዲሁ፤ ");
INSERT INTO amh_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ሰባቱም አገቡአት፥ ዘርም አላስቀሩም። ከሁሉም በኋላ ሴቲቱ ደግሞ ሞተች። ");
INSERT INTO amh_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ሰባቱ አግብተዋታልና በትንሣኤ ቀን ሲነሡ ከእነርሱ ለማናቸው ሚስት ትሆናለች? ");
INSERT INTO amh_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ኢየሱስም መልሶ እንዲህ አላቸው። መጻሕፍትንና የእግዚአብሔርን ኃይል አታውቁምና ስለዚህ የምትስቱ አይደለምን? ");
INSERT INTO amh_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ከሙታንስ ሲነሡ በሰማያት እንዳሉ መላእክት ይሆናሉ እንጂ አያገቡም፥ አይጋቡምም። ");
INSERT INTO amh_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ስለ ሙታን ግን እንዲነሡ እግዚአብሔር። እኔ የአብርሃም አምላክ የይስሐቅም አምላክ የያዕቆብም አምላክ ነኝ እንዳለው በሙሴ መጽሐፍ በቍጥቋጦው ዘንድ የተጻፈውን አላነበባችሁምን? ");
INSERT INTO amh_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","የሕያዋን አምላክ ነው እንጂ የሙታን አይደለም። እንግዲህ እጅግ ትስታላችሁ። ");
INSERT INTO amh_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ከጻፎችም አንዱ ቀርቦ ሲከራከሩ ሰማና መልካም አድርጎ እንደ መለሰላቸው አስተውሎ። ከሁሉ ፊተኛይቱ ትእዛዝ ማናቸይቱ ናት? ብሎ ጠየቀው። ");
INSERT INTO amh_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ኢየሱስም መልሶ እንዲህ አለው። ከትእዛዛቱ ሁሉ ፊተኛይቱ። እስራኤል ሆይ፥ ስማ፤ ጌታ አምላካችን አንድ ጌታ ነው፥ ");
INSERT INTO amh_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","አንተም በፍጹም ልብህ በፍጹምም ነፍስህ በፍጹምም አሳብህ በፍጹምም ኃይልህ ጌታ አምላክህን ውደድ የምትል ናት። ፊተኛይቱ ትእዛዝ ይህች ናት። ");
INSERT INTO amh_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ሁለተኛይቱም። ባልንጀራህን እንደ ራስህ ውደድ የምትል እርስዋን የምትመስል ይህች ናት። ከእነዚህ የምትበልጥ ሌላ ትእዛዝ የለችም። ");
INSERT INTO amh_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ጻፊውም። መልካም ነው፥ መምህር ሆይ፤ አንድ ነው ከእርሱም በቀር ሌላ የለም ብለህ በእውነት ተናገርህ፤ ");
INSERT INTO amh_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","በፍጹም ልብ በፍጹም አእምሮም በፍጹም ነፍስም በፍጹም ኃይልም እርሱን መውደድ፥ ባልንጀራንም እንደ ራስ መውደድ በሙሉ ከሚቃጠል መሥዋዕትና ከሌላው መሥዋዕት ሁሉ የሚበልጥ ነው አለው። ");
INSERT INTO amh_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ኢየሱስም በአእምሮ እንደ መለሰ አይቶ። አንተ ከእግዚአብሔር መንግሥት የራቅህ አይደለህም አለው። ከዚህም በኋላ ማንም ሊጠይቀው አልደፈረም። ");
INSERT INTO amh_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ኢየሱስም በመቅደስ ሲያስተምር መልሶ እንዲህ አለ። ጻፎች ክርስቶስ የዳዊት ልጅ ነው እንዴት ይላሉ? ");
INSERT INTO amh_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ዳዊት ራሱ በመንፈስ ቅዱስ። ጌታ ጌታዬን። ጠላቶችህን የእግርህ መረገጫ እስካደርግልህ ድረስ በቀኜ ተቀመጥ አለው አለ። ");
INSERT INTO amh_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ዳዊትም ራሱ ጌታ አለው፤ እንዴትስ ልጁ ይሆናል? ብዙ ሕዝብም በደስታ ይሰሙት ነበር። ");
INSERT INTO amh_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","40","የመበለቶችን ቤት የሚበሉ ጸሎታቸውንም በማስረዘም የሚያመካኙ እነዚህ የባሰ ፍርድ ይቀበላሉ። ");
INSERT INTO amh_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ኢየሱስም በመዝገብ አንጻር ተቀምጦ ሕዝቡ በመዝገብ ውስጥ ገንዘብ እንዴት እንዲጥሉ ያይ ነበር፤ ብዙ ባለ ጠጎችም ብዙ ይጥሉ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","አንዲትም ድሀ መበለት መጥታ አንድ ሳንቲም የሚያህሉ ሁለት ናስ ጣለች። ");
INSERT INTO amh_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ደቀ መዛሙርቱንም ጠርቶ። እውነት እላችኋለሁ፥ በመዝገብ ውስጥ ከሚጥሉት ሁሉ ይልቅ ይህች ድሀ መበለት አብልጣ ጣለች፤ ");
INSERT INTO amh_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ሁሉ ከትርፋቸው ጥለዋልና፥ ይህች ግን ከጕድለትዋ የነበራትን ሁሉ ትዳርዋን ሁሉ ጣለች አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","እርሱም ከመቅደስ ሲወጣ ከደቀ መዛሙርቱ አንዱ። መምህር ሆይ፥ እንዴት ያሉ ድንጋይዎችና እንዴት ያሉ ሕንጻዎች እንደ ሆኑ እይ አለው። ");
INSERT INTO amh_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ኢየሱስም መልሶ። እነዚህን ታላላቅ ሕንጻዎች ታያለህን? ድንጋይ በድንጋይ ላይ ሳይፈርስ በዚህ አይቀርም አለው። ");
INSERT INTO amh_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","በመቅደስም ትይዩ በደብረ ዘይት ተቀምጦ ሳለ፥ ጴጥሮስና ያዕቆብ ዮሐንስም እንድርያስም። ");
INSERT INTO amh_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ንገረን፥ ይህ መቼ ይሆናል? ይህስ ሁሉ ይፈጸም ዘንድ እንዳለው ምልክቱ ምንድር ነው? ብለው ለብቻቸው ጠየቁት። ");
INSERT INTO amh_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ኢየሱስም መልሶ እንዲህ ይላቸው ጀመር። ማንም እንዳያስታችሁ ተጠንቀቁ። ");
INSERT INTO amh_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ብዙዎች። እኔ ነኝ እያሉ በስሜ ይመጣሉና፥ ብዙዎችንም ያስታሉ። ");
INSERT INTO amh_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ጦርንም የጦርንም ወሬ በሰማችሁ ጊዜ አትደንግጡ፤ ይህ ሊሆን ግድ ነውና፥ ነገር ግን መጨረሻው ገና ነው። ");
INSERT INTO amh_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ሕዝብ በሕዝብ ላይ መንግሥትም በመንግሥት ላይ ይነሣልና፤ በልዩ ልዩ ስፍራ የምድር መናወጥ ይሆናል፤ ራብ ይሆናል፤ እነዚህ የምጥ ጣር መጀመሪያ ናቸው። ");
INSERT INTO amh_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","እናንተ ግን ለራሳችሁ ተጠንቀቁ፤ ወደ ሸንጎ አሳልፈው ይሰጡአችኋል በምኵራብም ትገረፋላችሁ ምስክርም ይሆንባቸው ዘንድ ስለ እኔ በገዥዎችና በነገሥታት ፊት ትቆማላችሁ። ");
INSERT INTO amh_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","አስቀድሞም ወንጌል ለአሕዛብ ሁሉ ይሰበክ ዘንድ ይገባል። ");
INSERT INTO amh_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ሲጐትቱአችሁና አሳልፈው ሲሰጡአችሁም ምን እንድትናገሩ አስቀድማችሁ አትጨነቁ፥ ዳሩ ግን በዚያች ሰዓት የሚሰጣችሁን ተናገሩ፤ የሚነግረው መንፈስ ቅዱስ ነው እንጂ እናንተ አይደላችሁምና። ");
INSERT INTO amh_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ወንድምም ወንድሙን አባትም ልጁን ለሞት አሳልፎ ይሰጣል፥ ልጆችም በወላጆቻቸው ላይ ይነሣሉ። ይገድሉአቸውማል፤ ");
INSERT INTO amh_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","በሁሉም ዘንድ ስለ ስሜ የተጠላችሁ ትሆናላችሁ፤ እስከ መጨረሻ የሚጸና ግን እርሱ ይድናል። ");
INSERT INTO amh_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ነገር ግን በነቢዩ በዳንኤል የተባለውን የጥፋት ርኵሰት በማይገባው ስፍራ ቆሞ ብታዩ፥ አንባቢው ያስተውል፥ በዚያን ጊዜ በይሁዳ ያሉ ወደ ተራሮች ይሽሹ፥ ");
INSERT INTO amh_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","በሰገነትም ያለ ወደ ቤት አይውረድ ከቤቱም አንዳች ይወስድ ዘንድ አይግባ፥ ");
INSERT INTO amh_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","በእርሻም ያለ ልብሱን ይወስድ ዘንድ ወደ ኋላው አይመለስ። ");
INSERT INTO amh_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","በዚያን ወራትም ለርጉዞችና ለሚያጠቡ ወዮላቸው። ");
INSERT INTO amh_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ነገር ግን ሽሽታችሁ በክረምት እንዳይሆን ጸልዩ፤ ");
INSERT INTO amh_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","በዚያን ወራት እግዚአብሔር ከፈጠረው ከፍጥረት መጀመሪያ ጀምሮ እስከ አሁን ድረስ ያልሆነ ደግሞም የማይሆን የመከራ ዓይነት ይሆናልና። ");
INSERT INTO amh_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ጌታስ ወራቶቹን ባያሳጥር፥ ሥጋ የለበሰ ሁሉ ባልዳነም፤ ነገር ግን ስለ መረጣቸው ምርጦች ወራቶቹን አሳጠረ። ");
INSERT INTO amh_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","በዚያን ጊዜም ማንም። እነሆ፥ ክርስቶስ ከዚህ አለ፥ ወይም። እነሆ፥ ከዚያ አለ ቢላችሁ አትመኑ፤ ");
INSERT INTO amh_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ሐሰተኞች ክርስቶሶችና ሐሰተኞች ነቢያት ይነሣሉና፥ ቢቻላቸውስ የተመረጡትን እንኳ ያስቱ ዘንድ ምልክትና ድንቅ ያደርጋሉ። ");
INSERT INTO amh_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","እናንተ ግን ተጠንቀቁ፤ እነሆ፥ አስቀድሜ ሁሉን ነገርኋችሁ። ");
INSERT INTO amh_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","በዚያን ወራት ግን ከዚያ መከራ በኋላ ፀሐይ ይጨልማል ጨረቃም ብርሃንዋን አትሰጥም፥ ");
INSERT INTO amh_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ከዋክብትም ከሰማይ ይወድቃሉ፥ የሰማያትም ኃይላት ይናወጣሉ። ");
INSERT INTO amh_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","በዚያን ጊዜም የሰው ልጅ በብዙ ኃይልና ክብር በደመና ሲመጣ ያዩታል። ");
INSERT INTO amh_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","በዚያን ጊዜም መላእክትን ይልካል ከአራቱ ነፋሳትም ከምድር ዳርቻ እስከ ሰማይ ዳርቻ የተመረጡትን ይሰበስባቸዋል። ");
INSERT INTO amh_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ምሳሌውንም ከበለስ ተማሩ፤ ጫፍዋ ሲለሰልስ ቅጠልዋም ሲያቈጠቍጥ፥ ያን ጊዜ በጋ እንደ ቀረበ ታውቃላችሁ፤ ");
INSERT INTO amh_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","እንዲሁ ደግሞ እናንተ ይህን ሁሉ መሆኑን ስታዩ ቀርቦ በደጅ እንደ ሆነ እወቁ። ");
INSERT INTO amh_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","እውነት እላችኋለሁ፥ ይህ ሁሉ እስኪሆን ድረስ ይህ ትውልድ አያልፍም። ");
INSERT INTO amh_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ሰማይና ምድር ያልፋሉ ቃሌ ግን አያልፍም። ");
INSERT INTO amh_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ስለዚያች ቀን ወይም ስለዚያች ሰዓት ግን የሰማይ መላእክትም ቢሆኑ ልጅም ቢሆን ከአባት በቀር የሚያውቅ የለም። ");
INSERT INTO amh_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ጊዜው መቼ እንዲሆን አታውቁምና ተጠንቀቁ፤ ትጉ፤ ጸልዩም። ");
INSERT INTO amh_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ቤቱን ትቶ ወደ ሌላ አገር እንደ ሄደ ሰው ነው፥ ለባሮቹም ሥልጣን ለእያንዳንዱም ሥራውን ሰጥቶ በረኛውን እንዲተጋ አዘዘ። ");
INSERT INTO amh_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","እንግዲህ በማታ ቢሆን ወይም በእኩለ ሌሊት ወይም ዶሮ ሲጮኽ ወይም በማለዳ ቢሆን ባለቤቱ መቼ እንዲመጣ አታውቁምና ");
INSERT INTO amh_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ድንገት መጥቶ ተኝታችሁ እንዳያገኛችሁ ስለዚህ ትጉ። ");
INSERT INTO amh_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ለእናንተም የምነግራችሁ ለሁሉ እላለሁ፤ ትጉ። ");
INSERT INTO amh_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ከሁለት ቀን በኋላ ፋሲካና የቂጣ በዓል ነበረ። የካህናት አለቆችም ጻፎችም እንዴት አድርገው በተንኰል እንደሚይዙትና እንደሚገድሉት ይፈልጉ ነበር። ");
INSERT INTO amh_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","የሕዝብ ሁከት እንዳይሆን በበዓል አይሁን ይሉ ነበርና። ");
INSERT INTO amh_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","እርሱም በቢታንያ በለምጻሙ በስምዖን ቤት በነበረ ጊዜ፥ በማዕድ ተቀምጦ ሳለ፥ አንዲት ሴት ዋጋው እጅግ የከበረ ጥሩ ናርዶስ ሽቱ የመላበት የአልባስጥሮስ ቢልቃጥ ይዛ መጣች፤ ቢልቃጡንም ሰብራ በራሱ ላይ አፈሰሰችው። ");
INSERT INTO amh_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","አንዳንዶችም። ይህ የሽቱ ጥፋት ለምንድር ነው? ");
INSERT INTO amh_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ይህ ሽቱ ከሦስት መቶ ዲናር በሚበልጥ ዋጋ ተሽጦ ለድሆች ሊሰጥ ይቻል ነበርና ብለው በራሳቸው ይቈጡ ነበር፤ እርስዋንም ነቀፉአት። ");
INSERT INTO amh_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ኢየሱስ ግን እንዲህ አለ። ተዉአት፤ ስለ ምን ታደክሙአታላችሁ? መልካም ሥራ ሠርታልኛለች። ");
INSERT INTO amh_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ድሆች ሁልጊዜ ከእናንተ ጋር ይኖራሉና፥ በማናቸውም በወደዳችሁት ጊዜ መልካም ልታደርጉላቸው ትችላላችሁ፥ እኔ ግን ሁልጊዜ ከእናንተ ጋር አልኖርም። ");
INSERT INTO amh_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","የተቻላትን አደረገች፤ አስቀድማ ለመቃብሬ ሥጋዬን ቀባችው። ");
INSERT INTO amh_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","እውነት እላችኋለሁ፥ ይህ ወንጌል በዓለሙ ሁሉ በሚሰበክበት በማናቸውም ስፍራ፥ እርስዋ ያደረገችው ደግሞ ለእርስዋ መታሰቢያ ሊሆን ይነገራል። ");
INSERT INTO amh_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ከአሥራ ሁለቱም አንዱ የአስቆሮቱ ይሁዳ አሳልፎ ሊሰጠው ወደ ካህናት አለቆች ሄደ። ");
INSERT INTO amh_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ሲሰሙም ደስ አላቸው ብርም ይሰጡት ዘንድ ተስፋ ሰጡት። በሚመች ጊዜም እንዴት አድርጎ አሳልፎ እንዲሰጠው ይፈልግ ነበር። ");
INSERT INTO amh_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ፋሲካን በሚያርዱበት በቂጣ በዓል መጀመሪያ ቀን ደቀ መዛሙርቱ። ፋሲካን ትበላ ዘንድ ወዴት ሄደን ልናሰናዳ ትወዳለህ? አሉት። ");
INSERT INTO amh_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ከደቀ መዛሙርቱም ሁለት ላከ እንዲህም አላቸው። ወደ ከተማ ሂዱ፥ ማድጋ ውኃ የተሸከመ ሰውም ይገናኛችኋል፤ ");
INSERT INTO amh_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ተከተሉት፥ የሚገባበትንም የቤቱን ጌታ። መምህሩ። ከደቀ መዛሙርቴ ጋር ፋሲካን የምበላበት የእንግዳ ቤት ወዴት ነው? ይላል በሉት። ");
INSERT INTO amh_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","እርሱም በደርብ ላይ ያለውን የተሰናዳና የተነጠፈ ታላቅ አዳራሽ ያሳያችኋል፤ ");
INSERT INTO amh_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","በዚያም አሰናዱልን። ደቀ መዛሙርቱም ወጡ ወደ ከተማም ሄደው እንዳላቸው አገኙ፥ ፋሲካንም አሰናዱ። ");
INSERT INTO amh_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","በመሸም ጊዜ ከአሥራ ሁለቱ ጋር መጣ። ");
INSERT INTO amh_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ተቀምጠውም ሲበሉ ኢየሱስ። እውነት እላችኋለሁ፥ ከእናንተ አንዱ፥ እርሱም ከእኔ ጋር የሚበላው አሳልፎ ይሰጠኛል አለ። ");
INSERT INTO amh_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","እነርሱም ያዝኑ፥ እያንዳንዳቸውም። እኔ እሆንን? ይሉት ጀመር። ");
INSERT INTO amh_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","እርሱም መልሶ። ከአሥራ ሁለቱ አንዱ ከእኔ ጋር ወደ ወጭቱ እጁን የሚያጠልቀው ነው። ");
INSERT INTO amh_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","የሰው ልጅስ ስለ እርሱ እንደ ተጻፈ ይሄዳል፤ ነገር ግን የሰው ልጅ አልፎ ለሚሰጥበት ለዚያ ሰው ወዮለት፤ ያ ሰው ባልተወለደ ይሻለው ነበር አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ሲበሉም ኢየሱስ እንጀራን አንሥቶ ባረከ ቈርሶም ሰጣቸውና። እንካችሁ፤ ይህ ሥጋዬ ነው አለ። ");
INSERT INTO amh_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ጽዋንም አንሥቶ አመስግኖም ሰጣቸው፥ ሁሉም ከእርሱ ጠጡ። ");
INSERT INTO amh_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","እርሱም። ይህ ስለ ብዙዎች የሚፈስ የአዲስ ኪዳን ደሜ ነው። ");
INSERT INTO amh_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","እውነት እላችኋለሁ፥ በእግዚአብሔር መንግሥት ከወይኑ ፍሬ አዲሱን እስከምጠጣበት እስከዚያ ቀን ድረስ ደግሞ አልጠጣውም አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","መዝሙርም ከዘመሩ በኋላ ወደ ደብረ ዘይት ወጡ። ");
INSERT INTO amh_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ኢየሱስም። በዚች ሌሊት ሁላችሁ በእኔ ትሰናከላላችሁ፤ እረኛዉን እመታለሁ በጎችም ይበተናሉ የሚል ተጽፎአልና። ");
INSERT INTO amh_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ነገር ግን ከተነሣሁ በኋላ ወደ ገሊላ እቀድማችኋለሁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ጴጥሮስም። ሁሉም ቢሰናከሉ እኔ ግን ከቶ አልሰናከልም አለው። ");
INSERT INTO amh_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ኢየሱስም። እውነት እልሃለሁ፥ ዛሬ በዚች ሌሊት ዶሮ ሁለት ጊዜ ሳይጮኽ ሦስት ጊዜ ትክደኛለህ አለው። ");
INSERT INTO amh_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","እርሱም ቃሉን አበርትቶ። ከአንተ ጋር የምሞት እንኳ ቢሆን ከቶ አልክድህም አለ። ሁሉም ደግሞ እንደዚሁ አሉ። ");
INSERT INTO amh_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ጌቴሴማኒ ወደምትባልም ስፍራ መጡ፥ ደቀ መዛሙርቱንም። ስጸልይ ሳለሁ፥ በዚህ ተቀመጡ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ጴጥሮስንና ያዕቆብን ዮሐንስንም ከእርሱ ጋር ወሰደ፤ ሊደነግጥም ሊተክዝም ጀመረና። ");
INSERT INTO amh_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ነፍሴ እስከ ሞት ድረስ እጅግ አዘነች፤ በዚህ ቈዩ ትጉም አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ጥቂትም ወደ ፊት እልፍ ብሎ በምድርም ወድቆ፥ ይቻልስ ቢሆን ሰዓቲቱ ከእርሱ እንድታልፍ ጸለየና። ");
INSERT INTO amh_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","አባ አባት ሆይ፥ ሁሉ ይቻልሃል፤ ይህችን ጽዋ ከእኔ ውሰድ፤ ነገር ግን አንተ የምትወደው እንጂ እኔ የምወደው አይሁን አለ። ");
INSERT INTO amh_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","መጣም ተኝተውም አገኛቸው፥ ጴጥሮስንም። ስምዖን ሆይ፥ ተኝተሃልን? አንዲት ሰዓት ስንኳ ልትተጋ አልቻልህምን? ");
INSERT INTO amh_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ወደ ፈተና እንዳትገቡ ትጉ ጸልዩም፤ መንፈስስ ተዘጋጅታለች፥ ሥጋ ግን ደካማ ነው አለው። ");
INSERT INTO amh_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ደግሞም ሄዶ ያንኑ ቃል ጸለየ። ");
INSERT INTO amh_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ደግሞም መጥቶ ዓይኖቻቸው በእንቅልፍ ከብደው ነበርና ተኝተው አገኛቸው፥ የሚመልሱለትንም አላወቁም። ");
INSERT INTO amh_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ሦስተኛም መጥቶ። እንግዲህስ ተኙ ዕረፉም፤ ይበቃል፤ ሰዓቲቱ ደረሰች፤ እነሆ፥ የሰው ልጅ በኃጢአተኞች እጅ አልፎ ይሰጣል። ");
INSERT INTO amh_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ተነሡ፥ እንሂድ፤ እነሆ፥ አሳልፎ የሚሰጠኝ ቀርቦአል አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ወዲያውም ገና ሲናገር ከአሥራ ሁለቱ አንዱ ይሁዳ መጣ፥ ከእርሱም ጋር ብዙ ሰዎች ሰይፍና ጐመድ ይዘው ከካህናት አለቆችና ከጻፎች ከሽማግሌዎችም ዘንድ መጡ። ");
INSERT INTO amh_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","አሳልፎ የሚሰጠውም። የምስመው እርሱ ነው፤ ያዙት ተጠንቅቃችሁም ውሰዱት ብሎ ምልክት ሰጥቶአቸው ነበር። ");
INSERT INTO amh_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","መጥቶም ወዲያው ወደ እርሱ ቀረበና። መምህር ሆይ፥ መምህር ሆይ፥ ብሎ ሳመው፤ ");
INSERT INTO amh_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","እነርሱም እጃቸውን በእርሱ ላይ ጭነው ያዙት። ");
INSERT INTO amh_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","በአጠገብ ከቆሙት ግን አንዱ ሰይፉን መዞ የሊቀ ካህናቱን ባሪያ መታ ጆሮውንም ቈረጠ። ");
INSERT INTO amh_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ኢየሱስም መልሶ። ወንበዴ እንደምትይዙ ሰይፍና ጐመድ ይዛችሁ ልትይዙኝ መጣችሁን? ");
INSERT INTO amh_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","በመቅደስ ዕለት ዕለት እያስተማርሁ ከእናንተ ጋር ስኖር አልያዛችሁኝም፤ ነገር ግን መጻሕፍት ይፈጸሙ ዘንድ ይህ ሆነ አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ሁሉም ትተውት ሸሹ። ");
INSERT INTO amh_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ዕርቃኑን በነጠላ የሸፈነ አንድ ጎበዝ ይከተለው ነበር፥ ");
INSERT INTO amh_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ጎበዛዝቱም ያዙት፤ እርሱ ግን ነጠላውን ትቶ ዕራቁቱን ሸሸ። ");
INSERT INTO amh_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ኢየሱስንም ወደ ሊቀ ካህናቱ ወሰዱት፥ የካህናት አለቆችም ሁሉ ሽማግሌዎችም ጻፎችም ተሰበሰቡ። ");
INSERT INTO amh_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ጴጥሮስም እስከ ሊቀ ካህናቱ ግቢ ውስጥ በሩቁ ተከተለው፥ ከሎሌዎችም ጋር ተቀምጦ እሳት ይሞቅ ነበር። ");
INSERT INTO amh_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","የካህናት አለቆችም ሸንጎውም ሁሉ እንዲገድሉት በኢየሱስ ላይ ምስክር ይፈልጉ ነበር፥ አላገኙምም፤ ");
INSERT INTO amh_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ብዙዎች በሐሰት ይመሰክሩበት ነበርና፥ ምስክርነታቸው ግን አልተሰማማም። ");
INSERT INTO amh_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","59","ምስክርነታቸውም እንዲሁ እንኳ አልተሰማማም። ");
INSERT INTO amh_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ሊቀ ካህናቱም በመካከላቸው ተነሥቶ። አንዳች አትመልስምን? እነዚህስ በአንተ ላይ የሚመሰክሩብህ ምንድር ነው? ብሎ ኢየሱስን ጠየቀው። ");
INSERT INTO amh_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","እርሱ ግን ዝም አለ አንዳችም አልመለሰም። ደግሞ ሊቀ ካህናቱ ጠየቀውና። የቡሩክ ልጅ ክርስቶስ አንተ ነህን? አለው። ");
INSERT INTO amh_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ኢየሱስም። እኔ ነኝ፤ የሰው ልጅም በኃይል ቀኝ ሲቀመጥ በሰማይም ደመና ሲመጣ ታያላችሁ አለ። ");
INSERT INTO amh_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ሊቀ ካህናቱም ልብሱን ቀደደና። ከእንግዲህ ወዲህ ምስክሮችን ምን ያስፈልገናል? ");
INSERT INTO amh_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ስድቡን ሰማችሁ፤ ምን ይመስላችኋል? አለ። እነርሱም ሁሉ። ሞት ይገባዋል ብለው ፈረዱበት። ");
INSERT INTO amh_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","አንዳንዶችም ይተፉበት ፊቱንም ሸፍነው ይጐስሙትና። ትንቢት ተናገር ይሉት ጀመር፤ ሎሌዎችም በጥፊ እየመቱ ወሰዱት። ");
INSERT INTO amh_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ጴጥሮስም በግቢ ውስጥ ወደ ታች ሳለ ከሊቀ ካህናቱ ገረዶች አንዲቱ መጣች፥ ");
INSERT INTO amh_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ጴጥሮስም እሳት ሲሞቅ አይታ ተመለከተችውና። አንተ ደግሞ ከናዝሬቱ ከኢየሱስ ጋር ነበርህ አለችው። ");
INSERT INTO amh_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","እርሱ ግን። የምትዪውን አላውቅም አላስተውልምም ብሎ ካደ። ወደ ውጭም ወደ ደጅ ወጣ፤ ዶሮም ጮኸ። ");
INSERT INTO amh_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ገረዲቱም አይታው በዚያ ለቆሙት። ይህም ከእነርሱ ወገን ነው ስትል ሁለተኛ ትነግራቸው ጀመር። ");
INSERT INTO amh_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","እርሱም ደግሞ ካደ። ጥቂት ቈይተውም በዚያ የቆሙት ዳግመኛ ጴጥሮስን። የገሊላ ሰው ነህና ከእነርሱ ወገን በእውነት ነህ አሉት። ");
INSERT INTO amh_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","እርሱ ግን። ይህን የምትሉትን ሰው አላውቀውም ብሎ ይረገምና ይምል ጀመር። ወዲያውም ዶሮ ሁለተኛ ጮኸ። ");
INSERT INTO amh_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ጴጥሮስንም ኢየሱስ። ዶሮ ሁለት ጊዜ ሳይጮኽ ሦስት ጊዜ ትክደኛለህ ያለው ቃል ትዝ አለው፤ ነገሩንም አስቦ አለቀሰ። ");
INSERT INTO amh_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ወዲያውም ማለዳ የካህናት አለቆች ከሽማግሌዎችና ከጻፎች ከሸንጎውም ሁሉ ጋር ከተማከሩ በኋላ፥ ኢየሱስን አሳስረው ወሰዱትና ለጲላጦስ አሳልፈው ሰጡት። ");
INSERT INTO amh_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ጲላጦስም። አንተ የአይሁድ ንጉሥ ነህን? ብሎ ጠየቀው። እርሱም። አንተ አልህ ብሎ መለሰለት። ");
INSERT INTO amh_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","የካህናት አለቆችም ብዙ ያሳጡት ነበር፤ እርሱ ግን ምንም አልመለሰም። ");
INSERT INTO amh_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ጲላጦስም ደግሞ። አንዳች አትመልስምን? እነሆ፥ በስንት ነገር ያሳጡሃል ብሎ ጠየቀው። ");
INSERT INTO amh_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ኢየሱስም ከዚያ በኋላ ጲላጦስ እስኪደነቅ ድረስ ምንም አልመለሰም። ");
INSERT INTO amh_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","በዚያም በዓል የለመኑትን አንድ እስረኛ ይፈታላቸው ነበር። ");
INSERT INTO amh_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","በዓመፅም ነፍስ ከገደሉት ከዓመፀኞች ጋር የታሰረ በርባን የተባለ ነበረ። ");
INSERT INTO amh_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ሕዝቡም ወጥተው እንደ ልማዱ ያደርግላቸው ዘንድ እየጮኹ ይለምኑት ጀመር። ");
INSERT INTO amh_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ጲላጦስም። የአይሁድን ንጉሥ እፈታላችሁ ዘንድ ትወዳላችሁን? ብሎ መለሰላቸው፤ ");
INSERT INTO amh_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","የካህናት አለቆች በቅንዓት አሳልፈው እንደ ሰጡት ያውቅ ነበርና። ");
INSERT INTO amh_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","የካህናት አለቆች ግን በርባንን በእርሱ ፈንታ ይፈታላቸው ዘንድ ሕዝቡን አወኩአቸው። ");
INSERT INTO amh_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ጲላጦስም ዳግመኛ መልሶ። እንግዲህ የአይሁድ ንጉሥ የምትሉትን ምን ላደርገው ትወዳላችሁ? አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","እነርሱም ዳግመኛ። ስቀለው እያሉ ጮኹ። ");
INSERT INTO amh_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ጲላጦስም። ምን ነው? ያደረገው ክፋት ምንድር ነው? አላቸው። እነርሱ ግን። ስቀለው እያሉ ጩኸት አበዙ። ");
INSERT INTO amh_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ጲላጦስም የሕዝቡን ፈቃድ ሊያደርግ ወዶ በርባንን ፈታላቸው፥ ኢየሱስንም ገርፎ እንዲሰቀል አሳልፎ ሰጠ። ");
INSERT INTO amh_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ወታደሮችም ፕራይቶሪዮን ወደሚባል ግቢ ውስጥ ወሰዱት፥ ጭፍራውንም ሁሉ በአንድነት ጠሩ። ");
INSERT INTO amh_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ቀይ ልብስም አለበሱት፥ የእሾህ አክሊልም ጎንጉነው ደፉበት፤ ");
INSERT INTO amh_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","የአይሁድ ንጉሥ ሆይ፥ ሰላም ለአንተ ይሁን እያሉ እጅ ይነሱት ጀመር፤ ");
INSERT INTO amh_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ራሱንም በመቃ መቱት ተፉበትም፥ ተንበርክከውም ሰገዱለት። ");
INSERT INTO amh_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ከተዘባበቱበትም በኋላ ቀዩን ልብስ ገፈፉት፥ ልብሱንም አለበሱት፥ ሊሰቅሉትም ወሰዱት። ");
INSERT INTO amh_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","አንድ መንገድ አላፊም የአሌክስንድሮስና የሩፎስ አባት ስምዖን የተባለ የቀሬና ሰው ከገጠር ሲመጣ መስቀሉን ይሸከም ዘንድ አስገደዱት። ");
INSERT INTO amh_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ትርጓሜውም የራስ ቅል ስፍራ ወደሚሆን ጎልጎታ ወደተባለ ስፍራ ወሰዱት። ");
INSERT INTO amh_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ከርቤም የተቀላቀለበትን የወይን ጠጅ እንዲጠጣ ሰጡት፤ እርሱ ግን አልተቀበለም። ");
INSERT INTO amh_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ሰቀሉትም፥ ልብሱንም ማን ማን እንዲወስድ ዕጣ ተጣጥለው ተካፈሉ። ");
INSERT INTO amh_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","በሰቀሉትም ጊዜ ሦስት ሰዓት ነበረ። ");
INSERT INTO amh_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","የክሱ ጽሕፈትም። የአይሁድ ንጉሥ የሚል ተጽፎ ነበር። ");
INSERT INTO amh_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ከእርሱም ጋር ሁለት ወንበዶች አንዱን በቀኙ አንዱንም በግራው ሰቀሉ። ");
INSERT INTO amh_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","መጽሐፍም። ከአመፀኞች ጋር ተቆጠረ ያለው ተፈጸመ። ");
INSERT INTO amh_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","የሚያልፉትም ራሳቸውን እየነቀነቁ ይሰድቡት ነበርና። ዋ፥ ቤተ መቅደስን የምታፈርስ በሦስት ቀንም የምትሠራ፥ ");
INSERT INTO amh_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ከመስቀል ወርደህ ራስህን አድን አሉ። ");
INSERT INTO amh_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","እንዲሁም የካህናት አለቆች ደግሞ ከጻፎች ጋር እርስ በርሳቸው እየተዘባበቱ። ሌሎችን አዳነ፤ ራሱን ሊያድን አይችልም፤ ");
INSERT INTO amh_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","አይተን እናምን ዘንድ የእስራኤል ንጉሥ ክርስቶስ አሁን ከመስቀል ይውረድ አሉ። ከእርሱም ጋር የተሰቀሉት ይነቅፉት ነበር። ");
INSERT INTO amh_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ስድስት ሰዓትም በሆነ ጊዜ፥ እስከ ዘጠኝ ሰዓት በምድር ሁሉ ላይ ጨለማ ሆነ። ");
INSERT INTO amh_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","በዘጠኝ ሰዓትም ኢየሱስ። ኤሎሄ፥ ኤሎሄ፥ ላማ ሰበቅታኒ? ብሎ በታላቅ ድምፅ ጮኸ፤ ትርጓሜውም አምላኬ፥ አምላኬ፥ ለምን ተውኸኝ? ማለት ነው። ");
INSERT INTO amh_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","በዚያም ከቆሙት ሰዎች ሰምተው። እነሆ፥ ኤልያስን ይጠራል አሉ። ");
INSERT INTO amh_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","አንዱም ሮጦ ሆምጣጤ በሰፍነግ ሞላ በመቃም አድርጎ። ተዉ፤ ኤልያስ ሊያወርደው ይመጣ እንደ ሆነ እንይ እያለ አጠጣው። ");
INSERT INTO amh_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ኢየሱስም በታላቅ ድምፅ ጮኸ ነፍሱንም ሰጠ። ");
INSERT INTO amh_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","የቤተ መቅደስም መጋረጃ ከላይ እስከ ታች ከሁለት ተቀደደ። ");
INSERT INTO amh_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","በዚያም በአንጻሩ የቆመ የመቶ አለቃ እንደዚህ ጮኾ ነፍሱን እንደ ሰጠ ባየ ጊዜ። ይህ ሰው በእውነት የእግዚአብሔር ልጅ ነበረ አለ። ");
INSERT INTO amh_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","42","አሁንም በመሸ ጊዜ የሰንበት ዋዜማ የሆነ የማዘጋጀት ቀን ስለ ነበረ፥ የከበረ አማካሪ የሆነ የአርማትያስ ዮሴፍ መጣ፥ ");
INSERT INTO amh_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","እርሱም ደግሞ የእግዚአብሔርን መንግሥት ይጠባበቅ ነበር፤ ደፍሮም ወደ ጲላጦስ ገባና የኢየሱስን ሥጋ ለመነው። ");
INSERT INTO amh_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ጲላጦስም አሁኑን እንዴት ሞተ ብሎ ተደነቀ፥ የመቶ አለቃውንም ጠርቶ ከሞተ ቆይቶአልን? ብሎ ጠየቀው፤ ");
INSERT INTO amh_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ከመቶ አለቃውም ተረድቶ በድኑን ለዮሴፍ ሰጠው። ");
INSERT INTO amh_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","በፍታም ገዝቶ አውርዶም በበፍታ ከፈነው ከዓለትም በተወቀረ መቃብር አኖረው፥ በመቃብሩ ደጃፍም ድንጋይ አንከባለለ። ");
INSERT INTO amh_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","መግደላዊትም ማርያም የዮሳም እናት ማርያም ወዴት እንዳኖሩት ይመለከቱ ነበር። ");
INSERT INTO amh_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ሰንበትም ካለፈ በኋላ መግደላዊት ማርያም የያዕቆብም እናት ማርያም ሰሎሜም መጥተው ሊቀቡት ሽቱ ገዙ። ");
INSERT INTO amh_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ከሳምንቱም በፊተኛው ቀን እጅግ በማለዳ ፀሐይ ከወጣ በኋላ ወደ መቃብር መጡ። ");
INSERT INTO amh_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","እርስ በርሳቸውም። ድንጋዩን ከመቃብር ደጃፍ ማን ያንከባልልልናል? ይባባሉ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ድንጋዩ እጅግ ትልቅ ነበርና፤ አሻቅበውም አይተው ድንጋዩ ተንከባሎ እንደ ነበር ተመለከቱ። ");
INSERT INTO amh_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ወደ መቃብሩም ገብተው ነጭ ልብስ የተጎናጸፈ ጎልማሳ በቀኝ በኩል ተቀምጦ አዩና ደነገጡ። ");
INSERT INTO amh_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","እርሱ ግን። አትደንግጡ፤ የተሰቀለውን የናዝሬቱን ኢየሱስን ትፈልጋላችሁ፤ ተነሥቶአል፥ በዚህ የለም፤ እነሆ እርሱን ያኖሩበት ስፍራ። ");
INSERT INTO amh_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ነገር ግን ሄዳችሁ ለደቀ መዛሙርቱ ለጴጥሮስም። ወደ ገሊላ ይቀድማችኋል፤ እንደ ነገራችሁ በዚያ ታዩታላችሁ ብላችሁ ንገሩአቸው አላቸው። ");
INSERT INTO amh_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","መንቀጥቀጥና መደንገጥ ይዞአቸው ነበርና ወጥተው ከመቃብር ሸሹ፤ ይፈሩ ነበርና ለማንም አንዳች አልነገሩም። እነርሱም ያዘዛቸውን ሁሉ ለጴጥሮስና ከእርሱ ጋር ላሉት በአጭሩ ተናገሩ። ከዚህም በኋላ ኢየሱስ ራሱ ለዘላለም ድኅነት የሆነውን የማይለወጠውን ቅዱስ ወንጌል ከፀሐይ መውጫ እስከ መጥለቂያው ድረስ በእጃቸው ላከው። ");
INSERT INTO amh_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ከሳምንቱም በመጀመሪያው ቀን ማልዶ በተነሣ ጊዜ፥ አስቀድሞ ሰባት አጋንንት ላወጣላት ለመግደላዊት ማርያም ታየ። ");
INSERT INTO amh_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","እርስዋ ሄዳ ከእርሱ ጋር ሆነው ለነበሩት ሲያዝኑና ሲያለቅሱ ሳሉ አወራችላቸው፤ ");
INSERT INTO amh_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","እነርሱም ሕያው እንደ ሆነ ለእርስዋም እንደ ታያት ሲሰሙ አላመኑም። ");
INSERT INTO amh_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ከዚህም በኋላ ከእነርሱ ለሁለቱ ወደ ባላገር ሲሄዱ በመንገድ በሌላ መልክ ተገለጠ፤ ");
INSERT INTO amh_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","እነርሱም ሄደው ለሌሎቹ አወሩ፤ እነዚያንም ደግሞ አላመኑአቸውም። ");
INSERT INTO amh_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ኋላም በማዕድ ተቀምጠው ሳሉ ለአሥራ አንዱ ተገለጠ፥ ተነሥቶም ያዩትን ስላላመኑአቸው አለማመናቸውንና የልባቸውን ጥንካሬ ነቀፈ። ");
INSERT INTO amh_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","እንዲህም አላቸው። ወደ ዓለም ሁሉ ሂዱ ወንጌልንም ለፍጥረት ሁሉ ስበኩ። ");
INSERT INTO amh_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ያመነ የተጠመቀም ይድናል፥ ያላመነ ግን ይፈረድበታል። ");
INSERT INTO amh_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ያመኑትንም እነዚህ ምልክቶች ይከተሉአቸዋል፤ በስሜ አጋንንትን ያወጣሉ፤ በአዲስ ቋንቋ ይናገራሉ፤ እባቦችን ይይዛሉ፥ ");
INSERT INTO amh_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","የሚገድልም ነገር ቢጠጡ አይጎዳቸውም፤ እጃቸውን በድውዮች ላይ ይጭናሉ እነርሱም ይድናሉ። ");
INSERT INTO amh_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ጌታ ኢየሱስም ከእነርሱ ጋር ከተናገረ በኋላ ወደ ሰማይ ዐረገ በእግዚአብሔርም ቀኝ ተቀመጠ። ");
INSERT INTO amh_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","እነርሱም ወጥተው በየስፍራው ሁሉ ሰበኩ፥ ጌታም ከእነርሱ ጋር ይሠራ ነበር፥ በሚከተሉትም ምልክቶች ቃሉን ያጸና ነበር። ");
INSERT INTO amh_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","5","በይሁዳ ንጉሥ በሄሮድስ ዘመን ከአብያ ክፍል የሆነ ዘካርያስ የሚባል አንድ ካህን ነበረ፤ ሚስቱም ከአሮን ልጆች ነበረች፥ ስምዋም ኤልሳቤጥ ነበረ። ");
INSERT INTO amh_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ሁለቱም በጌታ ትእዛዝና ሕግጋት ሁሉ ያለ ነቀፋ እየሄዱ በእግዚአብሔር ፊት ጻድቃን ነበሩ። ");
INSERT INTO amh_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ኤልሳቤጥም መካን ነበረችና ልጅ አልነበራቸውም፤ ሁለቱም በዕድሜያቸው አርጅተው ነበር። ");
INSERT INTO amh_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","እርሱም በክፍሉ ተራ በእግዚአብሔር ፊት ሲያገለግል፥ ");
INSERT INTO amh_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","እንደ ካህናት ሥርዓት ወደ ጌታ ቤተ መቅደስ ገብቶ ለማጠን ዕጣ ደረሰበት። ");
INSERT INTO amh_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","በዕጣንም ጊዜ ሕዝቡ ሁሉ በውጭ ቆመው ይጸልዩ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","የጌታም መልአክ በዕጣኑ መሠዊያ ቀኝ ቆሞ ታየው። ");
INSERT INTO amh_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ዘካርያስም ባየው ጊዜ ደነገጠ፥ ፍርሃትም ወደቀበት። ");
INSERT INTO amh_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","መልአኩም እንዲህ አለው። ዘካርያስ ሆይ፥ ጸሎትህ ተሰምቶልሃልና አትፍራ ሚስትህ ኤልሳቤጥም ወንድ ልጅ ትወልድልሃለች፥ ስሙንም ዮሐንስ ትለዋለህ። ");
INSERT INTO amh_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ደስታና ተድላም ይሆንልሃል፥ በመወለዱም ብዙዎች ደስ ይላቸዋል። ");
INSERT INTO amh_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","በጌታ ፊት ታላቅ ይሆናልና፥ የወይን ጠጅና የሚያሰክር መጠጥ አይጠጣም፤ ገናም በእናቱ ማኅፀን ሳለ መንፈስ ቅዱስ ይሞላበታል፤ ");
INSERT INTO amh_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ከእስራኤልም ልጆች ብዙዎችን ወደ ጌታ ወደ አምላካቸው ይመልሳል። ");
INSERT INTO amh_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","እርሱም የተዘጋጁትን ሕዝብ ለጌታ እንዲያሰናዳ፥ የአባቶችን ልብ ወደ ልጆች የማይታዘዙትንም ወደ ጻድቃን ጥበብ ይመልስ ዘንድ በኤልያስ መንፈስና ኃይል በፊቱ ይሄዳል። ");
INSERT INTO amh_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ዘካርያስም መልአኩን። እኔ ሽማግሌ ነኝ ምስቴም በዕድሜዋ አርጅታለችና ይህን በምን አውቃለሁ? አለው። ");
INSERT INTO amh_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","መልአኩም መልሶ። እኔ በእግዚአብሔር ፊት የምቆመው ገብርኤል ነኝ፥ እንድናገርህም ይህችንም የምሥራች እንድሰብክልህ ተልኬ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","እነሆም፥ በጊዜው የሚፈጸመውን ቃሌን ስላላመንህ፥ ይህ ነገር እስከሚሆን ቀን ድረስ ዲዳ ትሆናለህ መናገርም አትችልም አለው። ");
INSERT INTO amh_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ሕዝቡም ዘካርያስን ይጠብቁት ነበር፤ በቤተ መቅደስም ውስጥ ስለ ዘገየ ይደነቁ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","በወጣም ጊዜ ሊነግራቸው አልቻለም፥ በቤተ መቅደስም ራእይ እንዳየ አስተዋሉ፤ እርሱም ይጠቅሳቸው ነበር፤ ድዳም ሆኖ ኖረ። ");
INSERT INTO amh_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","የማገልገሉም ወራት ሲፈጸም ወደ ቤቱ ሄደ። ");
INSERT INTO amh_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","26","በስድስተኛውም ወር መልአኩ ገብርኤል ናዝሬት ወደምትባል ወደ ገሊላ ከተማ፥ ");
INSERT INTO amh_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ከዳዊት ወገን ለሆነው ዮሴፍ ለሚባል ሰው ወደ ታጨች ወደ አንዲት ድንግል ከእግዚአብሔር ዘንድ ተላከ፥ የድንግሊቱም ስም ማርያም ነበረ። ");
INSERT INTO amh_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","መልአኩም ወደ እርስዋ ገብቶ። ደስ ይበልሽ፥ ጸጋ የሞላብሽ ሆይ፥ ጌታ ከአንቺ ጋር ነው፤ አንቺ ከሴቶች መካከል የተባረክሽ ነሽ አላት። ");
INSERT INTO amh_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","እርስዋም ባየችው ጊዜ ከንግግሩ በጣም ደነገጠችና። ይህ እንዴት ያለ ሰላምታ ነው? ብላ አሰበች። ");
INSERT INTO amh_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","መልአኩም እንዲህ አላት። ማርያም ሆይ፥ በእግዚአብሔር ፊት ጸጋ አግኝተሻልና አትፍሪ። ");
INSERT INTO amh_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","እነሆም፥ ትፀንሻለሽ ወንድ ልጅም ትወልጃለሽ፥ ስሙንም ኢየሱስ ትዪዋለሽ። ");
INSERT INTO amh_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","እርሱ ታላቅ ይሆናል የልዑል ልጅም ይባላል፥ ጌታ አምላክም የአባቱን የዳዊትን ዙፋን ይሰጠዋል፤ ");
INSERT INTO amh_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","በያዕቆብ ቤትም ላይ ለዘለላም ይነግሣል፥ ለመንግሥቱም መጨረሻ የለውም። ");
INSERT INTO amh_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ማርያምም መልአኩን። ወንድ ስለማላውቅ ይህ እንዴት ይሆናል? አለችው። ");
INSERT INTO amh_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","መልአኩም መልሶ እንዲህ አላት። መንፈስ ቅዱስ በአንቺ ላይ ይመጣል፥ የልዑልም ኃይል ይጸልልሻል ስለዚህ ደግሞ ከአንቺ የሚወለደው ቅዱስ የእግዚአብሔር ልጅ ይባላል። ");
INSERT INTO amh_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","እነሆም ዘመድሽ ኤልሳቤጥ፥ እርስዋ ደግሞ በእርጅናዋ ወንድ ልጅ ፀንሳለች፥ ለእርስዋም መካን ትባል ለነበረችው ይህ ስድስተኛ ወር ነው፤ ");
INSERT INTO amh_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ለእግዚአብሔር የሚሳነው ነገር የለምና። ");
INSERT INTO amh_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ማርያምም። እነሆኝ የጌታ ባሪያ እንደ ቃልህ ይሁንልኝ አለች። መልአኩም ከእርስዋ ሄደ። ");
INSERT INTO amh_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ማርያምም በዚያ ወራት ተነሥታ ወደ ተራራማው አገር ወደ ይሁዳ ከተማ ፈጥና ወጣች፥ ");
INSERT INTO amh_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ወደ ዘካርያስም ቤት ገብታ ኤልሳቤጥን ተሳለመቻት። ");
INSERT INTO amh_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ኤልሳቤጥም የማርያምን ሰላምታ በሰማች ጊዜ ፅንሱ በማኅፀንዋ ውስጥ ዘለለ፤ በኤልሳቤጥም መንፈስ ቅዱስ ሞላባት፥ ");
INSERT INTO amh_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","በታላቅ ድምፅም ጮኻ እንዲህ አለች። አንቺ ከሴቶች መካከል የተባረክሽ ነሽ፥ የማኅፀንሽም ፍሬ የተባረከ ነው። ");
INSERT INTO amh_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","የጌታዬ እናት ወደ እኔ ትመጣ ዘንድ እንዴት ይሆንልኛል? ");
INSERT INTO amh_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","እነሆ፥ የሰላምታሽ ድምጽ በጆሮዬ በመጣ ጊዜ ፅንሱ በማኅፀኔ በደስታ ዘሎአልና። ");
INSERT INTO amh_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ከጌታ፤ የተነገረላት ቃል ይፈጸማልና ያመነች ብፅዕት ናት። ");
INSERT INTO amh_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ማርያምም እንዲህ አለች። ");
INSERT INTO amh_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ነፍሴ ጌታን ታከብረዋለች፥ መንፈሴም በአምላኬ በመድኃኒቴ ሐሴት ታደርጋለች፤ ");
INSERT INTO amh_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","የባሪያይቱን ውርደት ተመልክቶአልና። እነሆም፥ ከዛሬ ጀምሮ ትውልድ ሁሉ ብፅዕት ይሉኛል፤ ");
INSERT INTO amh_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ብርቱ የሆነ እርሱ በእኔ ታላቅ ሥራ አድርጎአልና፤ ስሙም ቅዱስ ነው። ");
INSERT INTO amh_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ምሕረቱም ለሚፈሩት እስከ ትውልድና ትውልድ ይኖራል። ");
INSERT INTO amh_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","በክንዱ ኃይል አድርጎአል፤ ትዕቢተኞችን በልባቸው አሳብ በትኖአል፤ ");
INSERT INTO amh_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ገዥዎችን ከዙፋናቸው አዋርዶአል፤ ትሑታንንም ከፍ አድርጎአል፤ ");
INSERT INTO amh_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","የተራቡትን በበጎ ነገር አጥግቦአል፤ ባለ ጠጎችንም ባዶአቸውን ሰዶአቸዋል። ");
INSERT INTO amh_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","56","ማርያምም ሦስት ወር የሚያህል በእርስዋ ዘንድ ተቀመጠች ወደ ቤትዋም ተመለሰች። ");
INSERT INTO amh_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","የኤልሳቤጥም የመውለጃዋ ጊዜ ደረሰ፥ ወንድ ልጅም ወለደች። ");
INSERT INTO amh_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ጎረቤቶችዋም ዘመዶችዋም ጌታ ምሕረቱን እንዳገነነላት ሰምተው ከእርስዋ ጋር ደስ አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","በስምንተኛውም ቀን ሕፃኑን ሊገርዙት መጡ፥ በአባቱም ስም ዘካርያስ ሊሉት ወደዱ። ");
INSERT INTO amh_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","እናቱ ግን መልሳ። አይሆንም፥ ዮሐንስ ይባል እንጂ አለች። ");
INSERT INTO amh_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","እነርሱም። ከወገንሽ ማንም በዚህ ስም የተጠራ የለም አሉአት። ");
INSERT INTO amh_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","አባቱንም ማን ሊባል እንዲወድ ጠቀሱት። ");
INSERT INTO amh_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ብራናም ለምኖ። ስሙ ዮሐንስ ነው ብሎ ጻፈ። ሁሉም አደነቁ። ");
INSERT INTO amh_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ያንጊዜም አፉ ተከፈተ መላሱም ተፈታ እግዚአብሔርንም እየባረከ ተናገረ። ");
INSERT INTO amh_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ለጎረቤቶቻቸውም ሁሉ ፍርሃት ሆነ፤ ይህም ሁሉ ነገር በይሁዳ በተራራማው አገር ሁሉ ተወራ፤ ");
INSERT INTO amh_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","የሰሙትም ሁሉ። እንኪያ ይህ ሕፃን ምን ይሆን? እያሉ በልባቸው አኖሩት፤ የጌታ እጅ ከእርሱ ጋር ነበረችና። ");
INSERT INTO amh_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","አባቱ ዘካርያስም መንፈስ ቅዱስ ሞላበትና ትንቢት ተናገረ እንዲህም አለ። ");
INSERT INTO amh_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","የእስራኤል ጌታ አምላክ ይባረክ፥ ጐብኝቶ ለሕዝቡ ቤዛ አድርጎአልና፤ ");
INSERT INTO amh_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","71","ማዳኑም ከወደረኞቻችንና ከሚጠሉን ሁሉ እጅ ነው፤ ");
INSERT INTO amh_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","76","ደግሞም አንተ ሕፃን ሆይ፥ የልዑል ነቢይ ትባላለህ፥ መንገዱን ልትጠርግ በጌታ ፊት ትሄዳለህና፤ ");
INSERT INTO amh_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","እንደዚህም የኃጢአታቸው ስርየት የሆነውን የመዳን እውቀት ለሕዝቡ ትሰጣለህ፤ ");
INSERT INTO amh_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ይህም ከላይ የመጣ ብርሃን በጐበኘበት በአምላካችን ምሕረትና ርኅራኄ ምክንያት ነው፤ ");
INSERT INTO amh_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ብርሃኑም በጨለማና በሞት ጥላ ተቀምጠው ላሉት ያበራል እግሮቻችንንም በሰላም መንገድ ያቀናል። ");
INSERT INTO amh_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ሕፃኑም አደገ በመንፈስም ጠነከረ፥ ለእስራኤልም እስከ ታየበት ቀን ድረስ በምድረ በዳ ኖረ። ");
INSERT INTO amh_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","በዚያም ወራት ዓለሙ ሁሉ እንዲጻፍ ከአውግስጦስ ቄሣር ትእዛዝ ወጣች። ");
INSERT INTO amh_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ቄሬኔዎስ በሶርያ አገር ገዥ በነበረ ጊዜ ይህ የመጀመሪያ ጽሕፈት ሆነ። ");
INSERT INTO amh_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ሁሉም እያንዳንዱ ይጻፍ ዘንድ ወደ ከተማው ሄደ። ");
INSERT INTO amh_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","6","በዚያም ሳሉ የመውለጃዋ ወራት ደረሰ፥ ");
INSERT INTO amh_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","የበኵር ልጅዋንም ወለደች፥ በመጠቅለያም ጠቀለለችው፤ በእንግዶችም ማደሪያ ስፍራ ስላልነበራቸው በግርግም አስተኛችው። ");
INSERT INTO amh_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","በዚያም ምድር መንጋቸውን በሌሊት ሲጠብቁ በሜዳ ያደሩ እረኞች ነበሩ። ");
INSERT INTO amh_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","እነሆም፥ የጌታ መልአክ ወደ እነርሱ ቀረበ የጌታ ክብርም በዙሪያቸው አበራ፥ ታላቅ ፍርሃትም ፈሩ። ");
INSERT INTO amh_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","መልአኩም እንዲህ አላቸው። እነሆ፥ ለሕዝቡ ሁሉ የሚሆን ታላቅ ደስታ የምሥራች እነግራችኋለሁና አትፍሩ፤ ");
INSERT INTO amh_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ዛሬ በዳዊት ከተማ መድኃኒት እርሱም ክርስቶስ ጌታ የሆነ ተወልዶላችኋልና። ");
INSERT INTO amh_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ይህም ምልክት ይሆንላችኋል፤ ሕፃን ተጠቅልሎ በግርግምም ተኝቶ ታገኛላችሁ። ");
INSERT INTO amh_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ድንገትም ብዙ የሰማይ ሠራዊት ከመልአኩ ጋር ነበሩ። እግዚአብሔርንም እያመሰገኑ። ");
INSERT INTO amh_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","ክብር ለእግዚአብሔር በአርያም ይሁን ሰላምም በምድር ለሰውም በጎ ፈቃድ አሉ። ");
INSERT INTO amh_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","መላእክትም ከእነርሱ ተለይተው ወደ ሰማይ በወጡ ጊዜ፥ እረኞቹ እርስ በርሳቸው። እንግዲህ እስከ ቤተ ልሔም ድረስ እንሂድ እግዚአብሔርም የገለጠልንን ይህን የሆነውን ነገር እንይ ተባባሉ። ");
INSERT INTO amh_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ፈጥነውም መጡ ማርያምንና ዮሴፍን ሕፃኑንም በግርግም ተኝቶ አገኙ። ");
INSERT INTO amh_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","አይተውም ስለዚህ ሕፃን የተነገረላቸውን ነገር ገለጡ። ");
INSERT INTO amh_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","የሰሙትን ሁሉ እረኞቹ በነገሩአቸው ነገር አደነቁ፤ ");
INSERT INTO amh_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ማርያም ግን ይህን ነገር ሁሉ በልብዋ እያሰበች ትጠብቀው ነበር። ");
INSERT INTO amh_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","እረኞችም እንደ ተባለላቸው ስለ ሰሙትና ስላዩት ሁሉ እግዚአብሔርን እያመሰገኑና እያከበሩ ተመለሱ። ");
INSERT INTO amh_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ሊገርዙት ስምንት ቀን በሞላ ጊዜ፥ በማኅፀን ሳይረገዝ በመልአኩ እንደ ተባለ፥ ስሙ ኢየሱስ ተብሎ ተጠራ። ");
INSERT INTO amh_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","25","እነሆም፥ በኢየሩሳሌም ስምዖን የሚባል ሰው ነበረ፥ ይህም ሰው የእስራኤልን መጽናናት ይጠባበቅ ነበር፤ ጻድቅና ትጉህም ነበረ፥ መንፈስ ቅዱስም በእርሱ ላይ ነበረ። ");
INSERT INTO amh_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","በጌታም የተቀባውን ሳያይ ሞትን እንዳያይ በመንፈስ ቅዱስ ተረድቶ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","በመንፈስም ወደ መቅደስ ወጣ፤ ወላጆቹም እንደ ሕጉ ልማድ ያደርጉለት ዘንድ ሕፃኑን ኢየሱስን በአስገቡት ጊዜ፥ ");
INSERT INTO amh_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","እርሱ ደግሞ ተቀብሎ አቀፈው እግዚአብሔርንም እየባረከ እንዲህ አለ። ");
INSERT INTO amh_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","ጌታ ሆይ፥ አሁን እንደ ቃልህ ባሪያህን በሰላም ታሰናብተዋለህ፤ ");
INSERT INTO amh_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","32","ይህም ለአሕዛብ ሁሉን የሚገልጥ ብርሃን ለሕዝብህም ለእስራኤል ክብር ነው። ");
INSERT INTO amh_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ዮሴፍና እናቱም ስለ እርሱ በተባለው ነገር ይደነቁ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","36","ከአሴር ወገንም የምትሆን የፋኑኤል ልጅ ሐና የምትባል አንዲት ነቢይት ነበረች፤ እርስዋም ከድንግልናዋ ጀምራ ከባልዋ ጋር ሰባት ዓመት ኖረች፤ ");
INSERT INTO amh_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","እርስዋም ሰማኒያ አራት ዓመት ያህል መበለት ሆና በጣም አርጅታ ነበር፤ በጾምና በጸሎትም ሌሊትና ቀን እያገለገለች ከመቅደስ አትለይም ነበር። ");
INSERT INTO amh_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","በዚያችም ሰዓት ቀርባ እግዚአብሔርን አመሰገነች፤ የኢየሩሳሌምንም ቤዛ ለሚጠባበቁ ሁሉ ስለ እርሱ ትናገር ነበር። ");
INSERT INTO amh_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ሁሉንም እንደ ጌታ ሕግ ከፈጸሙ በኋላ፥ ወደ ገሊላ ወደ ከተማቸው ወደ ናዝሬት ተመለሱ። ");
INSERT INTO amh_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ሕፃኑም አደገ፥ ጥበብም ሞልቶበት በመንፈስ ጠነከረ፤ የእግዚአብሔርም ጸጋ በእርሱ ላይ ነበረ። ");
INSERT INTO amh_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ወላጆቹም በያመቱ በፋሲካ በዓል ወደ ኢየሩሳሌም ይወጡ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","የአሥራ ሁለት ዓመት ልጅ በሆነ ጊዜ፥ እንደ በዓሉ ሥርዓት ወደ ኢየሩሳሌም ወጡ፤ ");
INSERT INTO amh_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ቀኖቹንም ከፈጸሙ በኋላ፥ ሲመለሱ ብላቴናው ኢየሱስ በኢየሩሳሌም ቀርቶ ነበር፥ ዮሴፍም እናቱም አላወቁም ነበር። ");
INSERT INTO amh_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ከመንገደኞች ጋር የነበረ ስለ መሰላቸው የአንድ ቀን መንገድ ሄዱ፥ ከዘመዶቻቸውም ከሚያውቋቸውም ዘንድ ፈለጉት፤ ");
INSERT INTO amh_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ባጡትም ጊዜ እየፈለጉት ወደ ኢየሩሳሌም ተመለሱ። ");
INSERT INTO amh_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ከሦስት ቀንም በኋላ በመምህራን መካከል ተቀምጦ ሲሰማቸውም ሲጠይቃቸውም በመቅደስ አገኙት፤ ");
INSERT INTO amh_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","የሰሙትም ሁሉ በማስተዋሉና በመልሱ ተገረሙ። ");
INSERT INTO amh_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ባዩትም ጊዜ ተገረሙ፥ እናቱም። ልጄ ሆይ፥ ለምን እንዲህ አደረግህብን? እነሆ፥ አባትህና እኔ እየተጨነቅን ስንፈልግህ ነበርን አለችው። ");
INSERT INTO amh_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","እርሱም። ስለ ምን ፈለጋችሁኝ? በአባቴ ቤት እሆን ዘንድ እንዲገባኝ አላወቃችሁምን? አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","እነርሱም የተናገራቸውን ነገር አላስተዋሉም። ");
INSERT INTO amh_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ከእነርሱም ጋር ወርዶ ወደ ናዝሬት መጣ፥ ይታዘዝላቸውም ነበር። እናቱም ይህን ነገር ሁሉ በልብዋ ትጠብቀው ነበር። ");
INSERT INTO amh_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ኢየሱስም ደግሞ በጥበብና በቁመት በሞገስም በእግዚአብሔርና በሰው ፊት ያድግ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ጢባርዮስ ቄሣርም በነገሠ በአሥራ አምስተኛይቱ ዓመት፥ ጴንጤናዊው ጲላጦስም በይሁዳ ሲገዛ፥ ሄሮድስም በገሊላ የአራተኛው ክፍል ገዥ፥ ወንድሙ ፊልጶስም በኢጡርያስ በጥራኮኒዶስም አገር የአራተኛው ክፍል ገዥ፥ ሊሳኒዮስም በሳቢላኒስ የአራተኛው ክፍል ገዥ ሆነው ሳሉ፥ ");
INSERT INTO amh_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ሐናና ቀያፋም ሊቃነ ካህናት ሳሉ፥ የእግዚአብሔር ቃል ወደ ዘካርያስ ልጅ ወደ ዮሐንስ በምድረ በዳ መጣ። ");
INSERT INTO amh_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","7","ስለዚህ ከእርሱ ሊጠመቁ ለወጡት ሕዝብ እንዲህ ይላቸው ነበር። እናንተ የእፉኝት ልጆች፥ ከሚመጣው ቍጣ እንድትሸሹ ማን አመለከታችሁ? ");
INSERT INTO amh_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","እንግዲህ ለንስሐ የሚገባ ፍሬ አድርጉ፤ በልባችሁም። አብርሃም አባት አለን ማለትን አትጀምሩ፤ ከእነዚህ ድንጋዮች ለአብርሃም ልጆች ሊያስነሣለት እግዚአብሔር እንዲችል እላችኋለሁና። ");
INSERT INTO amh_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","አሁንስ ምሳር ደግሞ በዛፎች ሥር ተቀምጦአል፤ እንግዲህ መልካም ፍሬ የማያደርግ ዛፍ ሁሉ ይቆረጣል ወደ እሳትም ይጣላል። ");
INSERT INTO amh_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ሕዝቡም። እንግዲህ ምን እናድርግ? ብለው ይጠይቁት ነበር። ");
INSERT INTO amh_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","መልሶም። ሁለት ልብስ ያለው ለሌለው ያካፍል፥ ምግብም ያለው እንዲሁ ያድርግ ይል ነበር። ");
INSERT INTO amh_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ቀራጮችም ደግሞ ሊጠመቁ መጥተው። መምህር ሆይ፥ ምን እናድርግ? አሉት። ");
INSERT INTO amh_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ከታዘዘላችሁ አብልጣችሁ አትውሰዱ አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ጭፍሮችም ደግሞ። እኛ ደግሞ ምን እናድርግ? ብለው ይጠይቁት ነበር። እርሱም። በማንም ግፍ አትሥሩ ማንንም በሐሰት አትክሰሱ፥ ደመወዛችሁም ይብቃችሁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ሕዝቡም ሲጠብቁ ሳሉ ሁሉም በልባቸው ስለ ዮሐንስ። ይህ ክርስቶስ ይሆንን? ብለው ሲያስቡ ነበር፥ ");
INSERT INTO amh_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ዮሐንስ መልሶ። እኔስ በውኃ አጠምቃችኋለሁ፤ ነገር ግን የጫማውን ጠፍር መፍታት ከማይገባኝ ከእኔ የሚበረታ ይመጣል፤ እርሱ በመንፈስ ቅዱስና በእሳት ያጠምቃችኋል፤ ");
INSERT INTO amh_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","መንሹም በእጁ ነው፥ አውድማውንም ፈጽሞ ያጠራል፥ ስንዴውንም በጎተራው ይከታል፥ ገለባውን ግን በማይጠፋ እሳት ያቃጥለዋል አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ስለዚህ ሕዝቡን በብዙ ሌላ ምክር እየመከራቸው ወንጌልን ይሰብክላቸው ነበር፤ ");
INSERT INTO amh_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","የአራተኛው ክፍል ገዥ ሄሮድስ ግን፥ ስለ ሄሮድያዳ ስለ ወንድሙ ስለ ፊልጶስ ሚስትና ሄሮድስ ስላደረገው ሌላ ክፋት ሁሉ ዮሐንስ ስለ ገሠጸው፥ ");
INSERT INTO amh_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ይህን ደግሞ ከሁሉ በላይ ጨምሮ ዮሐንስን በወኅኒ አገባው። ");
INSERT INTO amh_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ሕዝቡም ሁሉ ከተጠመቁ በኋላ ኢየሱስ ደግሞ ተጠመቀ። ሲጸልይም ሰማይ ተከፈተ፥ ");
INSERT INTO amh_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","መንፈስ ቅዱስም በአካል መልክ እንደ ርግብ በእርሱ ላይ ወረደ፤ የምወድህ ልጄ አንተ ነህ፥ በአንተ ደስ ይለኛል የሚል ድምፅም ከሰማይ መጣ። ");
INSERT INTO amh_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ኢየሱስም ሊያስተምር ሲጀምር ዕድሜው ሠላሳ ዓመት ያህል ሆኖት ነበር እንደመሰላቸው የዮሴፍ ልጅ ሆኖ፥ የኤሊ ልጅ፥ ");
INSERT INTO amh_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","የማቲ ልጅ፥ የሌዊ ልጅ፥ የሚልኪ ልጅ፥ ");
INSERT INTO amh_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","የዮና ልጅ፥ የዮሴፍ ልጅ፥ የማታትዩ ልጅ፥ የአሞጽ ልጅ፥ የናሆም ልጅ፥ የኤሲሊም ልጅ ");
INSERT INTO amh_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","የናጌ ልጅ፥ የማአት ልጅ፥ የማታትዩ ልጅ የሴሜይ ልጅ፥ የዮሴፍ ልጅ፥ ");
INSERT INTO amh_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","የዮዳ ልጅ፥ የዮናን ልጅ፥ የሬስ ልጅ፥ የዘሩባቤል ልጅ፥ የሰላትያል ልጅ፥ የኔሪ ልጅ፥ ");
INSERT INTO amh_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","የሚልኪ ልጅ፥ የሐዲ ልጅ፥ የዮሳስ ልጅ፥ የቆሳም ልጅ፥ የኤልሞዳም ልጅ፥ የኤር ልጅ፥ ");
INSERT INTO amh_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","የዮሴዕ ልጅ፥ የኤልዓዘር ልጅ የዮራም ልጅ፥ የማጣት ልጅ፥ የሌዊ ልጅ፥ ");
INSERT INTO amh_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","የስምዖን ልጅ፥ የይሁዳ ልጅ፥ የዮሴፍ ልጅ፥ ");
INSERT INTO amh_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","የዮናን ልጅ፥ የኤልያቄም ልጅ፥ የሜልያ ልጅ፥ የማይናን ልጅ፥ የማጣት ልጅ፥ የናታን ልጅ ");
INSERT INTO amh_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","የዳዊት ልጅ፥ የእሴይ ልጅ፥ የኢዮቤድ ልጅ፥ የቦዔዝ ልጅ፥ የሰልሞን ልጅ፥ ");
INSERT INTO amh_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","የነአሶን ልጅ፥ የአሚናዳብ ልጅ፥ የአራም ልጅ፥ የአሮኒ ልጅ፥ የኤስሮም ልጅ፥ ");
INSERT INTO amh_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","የፋሬስ ልጅ፥ የይሁዳ ልጅ፥ የያዕቆብ ልጅ፥ የይስሐቅ ልጅ፥ የአብርሃም ልጅ፥ የታራ ልጅ፥ ");
INSERT INTO amh_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","የናኮር ልጅ፥ የሴሮህ ልጅ፥ የራጋው ልጅ፥ የፋሌቅ ልጅ፥ የአቤር ልጅ፥ የሳላ ልጅ፥ ");
INSERT INTO amh_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","የቃይንም ልጅ፥ የአርፋክስድ ልጅ፥ የሴም ልጅ፥ የኖኅ ልጅ፥ የላሜህ ልጅ፥ ");
INSERT INTO amh_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","የማቱሳላ ልጅ፥ የሄኖክ ልጅ፥ የያሬድ ልጅ፥ ");
INSERT INTO amh_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","የመላልኤል ልጅ፥ የቃይናን ልጅ፥ የሄኖስ ልጅ፥ የሴት ልጅ፥ የአዳም ልጅ፥ የእግዚአብሔር ልጅ። ");
INSERT INTO amh_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ኢየሱስም መንፈስ ቅዱስ መልቶበት ከዮርዳኖስ ተመለሰ፥ በመንፈስም ወደ ምድረ በዳ ተመርቶ፥ ");
INSERT INTO amh_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","አርባ ቀን ከዲያብሎስ ተፈተነ። በነዚያም ቀኖች ምንም አልበላም፥ ከተጨረሱም በኋላ ተራበ። ");
INSERT INTO amh_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ዲያብሎስም። የእግዚአብሔር ልጅ ከሆንህ፥ ይህን ድንጋይ። እንጀራ ሁን ብለህ እዘዝ አለው። ");
INSERT INTO amh_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ኢየሱስም። ሰው በእግዚአብሔር ቃል ሁሉ እንጂ በእንጀራ ብቻ አይኖርም ተብሎ ተጽፎአል ብሎ መለሰለት። ");
INSERT INTO amh_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ዲያብሎስም ረጅም ወደ ሆነ ተራራ አውጥቶ የዓለምን መንግሥታት ሁሉ በቅጽበት አሳየው። ");
INSERT INTO amh_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ዲያብሎስም። ይህ ሥልጣን ሁሉ ክብራቸውም ለእኔ ተሰጥቶአል ለምወደውም ለማንም እሰጠዋለሁና ለአንተ እሰጥሃለሁ፤ ");
INSERT INTO amh_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ስለዚህ አንተ በእኔ ፊት ብትሰግድ፥ ሁሉ ለአንተ ይሆናል አለው። ");
INSERT INTO amh_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ኢየሱስም መልሶ። ለጌታ ለአምላክህ ስገድ እርሱንም ብቻ አምልክ ተብሎ ተጽፎአል አለው። ");
INSERT INTO amh_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","12","ኢየሱስም መልሶ። ጌታን አምላክህን አትፈታተነው ተብሎአል አለው። ");
INSERT INTO amh_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ዲያቢሎስም ፈተናውን ሁሉ ከጨረሰ በኋላ እስከ ጊዜው ከእርሱ ተለየ። ");
INSERT INTO amh_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ኢየሱስም በመንፈስ ኃይል ወደ ገሊላ ተመለሰ፤ ስለ እርሱም በዙሪያው ባለችው አገር ሁሉ ዝና ወጣ። ");
INSERT INTO amh_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","እርሱም በምኵራባቸው ያስተምር፥ ሁሉም ያመሰግኑት ነበር። ");
INSERT INTO amh_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ወዳደገበትም ወደ ናዝሬት መጣ፤ እንደ ልማዱም በሰንበት ቀን ወደ ምኵራብ ገባ፥ ሊያነብም ተነሣ። ");
INSERT INTO amh_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","20","መጽሐፉንም ጠቅልሎ ለአገልጋዩ ሰጠውና ተቀመጠ፤ በምኵራብም የነበሩት ሁሉ ትኵር ብለው ይመለከቱት ነበር። ");
INSERT INTO amh_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","እርሱም። ዛሬ ይህ መጽሐፍ በጆሮአችሁ ተፈጸመ ይላቸው ጀመር። ");
INSERT INTO amh_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ሁሉም ይመሰክሩለት ነበር ከአፉም ከሚወጣው ከጸጋው ቃል የተነሣ እየተደነቁ። ይህ የዮሴፍ ልጅ አይደለምን? ይሉ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","እርሱም። ያለ ጥርጥር ይህን ምሳሌ። ባለ መድኃኒት ሆይ፥ ራስህን ፈውስ፤ በቅፍርናሆም እንዳደረግኸው የሰማነውን ሁሉ በዚህ በገዛ አገርህ ደግሞ አድርግ ትሉኛላችሁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","እንዲህም አለ። እውነት እላችኋለሁ፥ ነቢይ በገዛ አገሩ ከቶ አይወደድም። ");
INSERT INTO amh_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ነገር ግን እውነት እላችኋለሁ፥ በኤልያስ ዘመን ሦስት ዓመት ከስድስት ወር ሰማይ ተዘግቶ ሳለ በምድር ሁሉ ብርቱ ራብ በነበረ ጊዜ፥ በእስራኤል ብዙ መበለቶች ነበሩ፤ ");
INSERT INTO amh_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ኤልያስም በሲዶና አገር ወዳለች ወደ ሰራፕታ ወደ አንዲት መበለት እንጂ ከእነርሱ ወደ አንዲቱ አልተላከም። ");
INSERT INTO amh_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","በነቢዩ በኤልሳዕ ዘመንም በእስራኤል ብዙ ለምጻሞች ነበሩ፥ ከሶርያዊው ከንዕማን በቀር ከእነርሱ አንድ ስንኳ አልነጻም። ");
INSERT INTO amh_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","በምኵራብም የነበሩ ሁሉ ይህን ሰምተው ቍጣ ሞላባቸው፥ ተነሥተውም ከከተማ ወደ ውጭ አወጡት፥ ");
INSERT INTO amh_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ይጥሉትም ዘንድ ከተማቸው ተሠርታባት ወደ ነበረች ወደ ተራራው አፋፍ ወሰዱት፤ ");
INSERT INTO amh_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","እርሱ ግን በመካከላቸው አልፎ ሄደ። ");
INSERT INTO amh_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ወደ ገሊላ ከተማም ወደ ቅፍርናሆም ወረደ። በሰንበትም ያስተምራቸው ነበር፤ ");
INSERT INTO amh_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ቃሉ በሥልጣን ነበርና በትምህርቱ ተገረሙ። ");
INSERT INTO amh_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","በምኵራብም የርኵስ ጋኔን መንፈስ ያደረበት ሰው ነበረ፥ በታላቅ ድምፅም ጮኾ። ");
INSERT INTO amh_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ተው፥ የናዝሬቱ ኢየሱስ ሆይ፥ ከአንተ ጋር ምን አለን? ልታጠፋን መጣህን? ማን እንደ ሆንህ አውቄሃለሁ፥ አንተ የእግዚአብሔር ቅዱሱ አለ። ");
INSERT INTO amh_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ኢየሱስም። ዝም በል ከእርሱም ውጣ ብሎ ገሠጸው። ጋኔኑም በመካከላቸው ጥሎት ሳይጐዳው ከእርሱ ወጣ። ");
INSERT INTO amh_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ሁሉንም መደነቅ ያዛቸው፥ እርስ በርሳቸውም። ይህ ቃል ምንድር ነው? በሥልጣንና በኃይል ርኵሳን መናፍስትን ያዝዛልና፥ ይወጡማል ብለው ተነጋገሩ። ");
INSERT INTO amh_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ዝናም በዙሪያው ባለች አገር ወደ ስፍራው ሁሉ ስለ እርሱ ወጣ። ");
INSERT INTO amh_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","በምኵራብም ተነሥቶ ወደ ስምዖን ቤት ገባ። የስምዖንም አማት በብርቱ ንዳድ ታማ ነበር ስለ እርስዋም ለመኑት። ");
INSERT INTO amh_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","በአጠገብዋም ቆሞ ንዳዱን ገሠጸውና ለቀቃት፤ ያንጊዜውንም ተነሥታ አገለገለቻቸው። ");
INSERT INTO amh_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ፀሐይም በገባ ጊዜ በልዩ ልዩ ደዌ የተያዙ በሽተኞችን ሁሉ ወደ እርሱ አመጡአቸው፤ እርሱም በእያንዳቸው ላይ እጁን ጭኖ ፈወሳቸው። ");
INSERT INTO amh_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","አጋንንትም ደግሞ። አንተ ክርስቶስ የእግዚአብሔር ልጅ ነህ እያሉ እየጮኹም ከብዙዎች ይወጡ ነበር፤ ገሠጻቸውም ክርስቶስም እንደ ሆነ አውቀውት ነበርና እንዲናገሩ አልፈቀደላቸውም። ");
INSERT INTO amh_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","በጸባም ጊዜ ወጥቶ ወደ ምድረ በዳ ሄደ፤ ሕዝቡም ይፈልጉት ነበር፤ ወደ እርሱም መጡ፥ ከእነርሱም ተለይቶ እንዳይሄድ ሊከለክሉት ወደዱ። ");
INSERT INTO amh_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","እርሱ ግን። ስለዚህ ተልኬአለሁና ለሌሎቹ ከተማዎች ደግሞ የእግዚአብሔርን መንግሥት ወንጌል እሰብክ ዘንድ ይገባኛል አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","በገሊላም ምኵራቦች ይሰብክ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ሕዝቡም የእግዚአብሔርን ቃል እየሰሙ ሲያስጠብቡት ሳሉ፥ እርሱ ራሱ በጌንሳሬጥ ባሕር ዳር ቆሞ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","በባሕር ዳርም ቆመው የነበሩትን ሁለት ታንኳዎች አየ፤ ዓሣ አጥማጆች ግን ከእነርሱ ውስጥ ወጥተው መረቦቻቸውን ያጥቡ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ከታንኳዎቹም የስምዖን ወደ ነበረች ወደ አንዲቱ ገብቶ ከምድር ጥቂት ፈቀቅ እንዲያደርጋት ለመነው፤ በታንኳይቱም ተቀምጦ ሕዝቡን ያስተምር ነበር። ");
INSERT INTO amh_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ነገሩንም ከጨረሰ በኋላ፥ ስምዖንን። ወደ ጥልቁ ፈቀቅ በል መረቦቻችሁንም ለማጥመድ ጣሉ አለው። ");
INSERT INTO amh_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ስምዖንም መልሶ። አቤቱ፥ ሌሊቱን ሁሉ አድረን ስንደክም ምንም አልያዝንም፤ ነገር ግን በቃልህ መረቦቹን እጥላለሁ አለው። ");
INSERT INTO amh_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ይህንም ባደረጉ ጊዜ እጅግ ብዙ ዓሣ ያዙ፤ መረቦቻቸውም ተቀደዱ። ");
INSERT INTO amh_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","በሌላ ታንኳም የነበሩትን ጓደኞቻቸውን መጥተው እንዲያግዙአቸው ጠቀሱ፤ መጥተውም ሁለቱ ታንኳዎች እስኪሰጥሙ ድረስ ሞሉአቸው። ");
INSERT INTO amh_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ስምዖን ጴጥሮስ ግን ባየ ጊዜ በኢየሱስ ጕልበት ላይ ወድቆ። ጌታ ሆይ፥ እኔ ኃጢአተኛ ነኝና ከኔ ተለይ አለው። ");
INSERT INTO amh_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ስላጠመዱት ዓሣ እርሱ ከእርሱ ጋርም የነበሩ ሁሉ ተደንቀዋልና፥ ");
INSERT INTO amh_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","እንዲሁም ደግሞ የስምዖን ባልንጀሮች የነበሩ የዘብዴዎስ ልጆች ያዕቆብና ዮሐንስም ተደነቁ። ኢየሱስም ስምዖንን። አትፍራ፤ ከእንግዲህ ወዲህ ሰውን የምታጠምድ ትሆናለህ አለው። ");
INSERT INTO amh_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ታንኳዎችንም ወደ ምድር አድርሰው ሁሉን ትተው ተከተሉት። ");
INSERT INTO amh_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ከከተማዎችም በአንዲቱ ሳለ፥ እነሆ፥ ለምጽ የሞላበት ሰው ነበረ፤ ኢየሱስንም አይቶ በፊቱ ወደቀና። ጌታ ሆይ፥ ብትወድስ፥ ልታነጻኝ ትችላለህ ብሎ ለመነው። ");
INSERT INTO amh_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","እጁንም ዘርግቶ ዳሰሰውና። እወዳለሁ፥ ንጻ አለው፤ ወዲያውም ለምጹ ለቀቀው። ");
INSERT INTO amh_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","እርሱም ለማንም እንዳይናገር አዘዘው፥ ነገር ግን። ሄደህ ራስህን ለካህን አሳይ፥ ለእነርሱም ምስክር እንዲሆን ስለ መንጻትህ ሙሴ እንዳዘዘ መሥዋዕት አቅርብ አለው። ");
INSERT INTO amh_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ወሬው ግን አብዝቶ ወጣ፥ ብዙ ሕዝብም ሊሰሙትና ከደዌአቸው ሊፈወሱ ይሰበሰቡ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ነገር ግን እርሱ ወደ ምድረ በዳ ፈቀቅ ብሎ ይጸልይ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","አንድ ቀንም ያስተምር ነበር፤ ከገሊላና ከይሁዳ መንደሮችም ሁሉ ከኢየሩሳሌምም መጥተው የነበሩ ፈሪሳውያንና የሕግ መምህራን ይቀመጡ ነበር፤ እርሱም እንዲፈውስ የጌታ ኃይል ሆነለት። ");
INSERT INTO amh_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","እነሆም፥ አንድ ሽባ በአልጋ ተሸክመው አመጡ፤ አግብተውም በፊቱ ሊያኖሩት ይሹ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ስለ ሕዝቡም ብዛት እንዴት አድርገው እንዲያገቡት ሲያቅታቸው፥ ወደ ሰገነቱ ወጡ የጣራውንም ጡብ አሳልፈው በመካከል በኢየሱስ ፊት ከነአልጋው አወረዱት። ");
INSERT INTO amh_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","እምነታቸውንም አይቶ። አንተ ሰው፥ ኃጢአትህ ተሰረየችልህ አለው። ");
INSERT INTO amh_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ጻፎችና ፈሪሳውያንም። ይህ የሚሳደብ ማን ነው? ከአንዱ ከእግዚአብሔር በቀር ኃጢአት ሊያስተሰርይ ማን ይችላል? ብለው ያስቡ ጀመር። ");
INSERT INTO amh_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ኢየሱስም አሳባቸውን እያወቀ መልሶ። በልባችሁ ምን ታስባላችሁ? ");
INSERT INTO amh_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ኃጢአትህ ተሰረየችልህ ከማለት ወይስ። ተነሣና ሂድ ከማለት ማናቸው ይቀላል? ");
INSERT INTO amh_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ነገር ግን በምድር ላይ ኃጢአት ሊያስተሰርይ ለሰው ልጅ ሥልጣን እንዳለው እንድታውቁ ብሎ፥ ሽባውን። አንተን እልሃለሁ፥ ነተሣ፥ አልጋህን ተሸክመህ ወደ ቤትህ ሂድ አለው። ");
INSERT INTO amh_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","በዚያን ጊዜም በፊታቸው ተነሣ፥ ተኝቶበትም የነበረውን ተሸክሞ እግዚአብሔርን እያመሰገነ ወደ ቤቱ ሄደ። ");
INSERT INTO amh_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ሁሉንም መገረም ያዛቸው፥ እግዚአብሔርንም አመስግነው። ዛሬስ ድንቅ ነገር አየን እያሉ ፍርሃት ሞላባቸው። ");
INSERT INTO amh_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ከዚህም በኋላ ወጥቶ ሌዊ የሚባል ቀራጭ በመቅረጫው ተቀምጦ ተመለከተና። ተከተለኝ አለው። ");
INSERT INTO amh_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ሁሉንም ተወ፤ ተነሥቶም ተከተለው። ");
INSERT INTO amh_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ሌዊም በቤቱ ታላቅ ግብዣ አደረገለት፤ ከእነርሱም ጋር በማዕድ ተቀምጠው የነበሩ ከቀራጮችና ከሌሎች ሰዎች ብዙ ሕዝብ ነበሩ። ");
INSERT INTO amh_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ፈሪሳውያንና ጻፎቻቸውም በደቀ መዛሙርቱ ላይ። ስለ ምን ከቀራጮችና ከኃጢአተኞች ጋር ትበላላችሁ ትጠጡማላችሁ? ብለው አንጐራጐሩ። ");
INSERT INTO amh_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ኢየሱስም መልሶ። ሕመምተኞች እንጂ ባለ ጤናዎች ባለ መድኃኒት አያስፈልጋቸውም፤ ");
INSERT INTO amh_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ኃጢአተኞችን ወደ ንስሐ እንጂ ጻድቃንን ልጠራ አልመጣሁም አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","እነርሱም። የዮሐንስ ደቀ መዛሙርት ስለ ምን ብዙ ይጦማሉ ጸሎትስ ስለ ምን ያደርጋሉ፥ ደግሞም የፈሪሳውያን ደቀ መዛሙርት ስለ ምን እንደዚሁ ያደርጋሉ፤ የአንተ ደቀ መዛሙርት ግን ይበላሉ ይጠጣሉም? አሉት። ");
INSERT INTO amh_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ኢየሱስም። ሙሽራው ከእነርሱ ጋር ሳለ ሚዜዎችን ልታስጦሙ ትችላላችሁን? ");
INSERT INTO amh_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ነገር ግን ወራት ይመጣል፥ ሙሽራውም ከእነርሱ ሲወሰድ ያንጊዜ፥ በዚያ ወራት ይጦማሉ አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ደግሞም ምሳሌ እንዲህ ሲል ነገራቸው። የአዲስ ልብስ እራፊ ባረጀ ልብስ ላይ የሚያኖር የለም፤ ቢደረግ ግን አዲሱን ይቀደዋል ደግሞም አዲስ እራፊ ለአሮጌው አይስማማውም። ");
INSERT INTO amh_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ባረጀ አቁማዳም አዲስ የወይን ጠጅ የሚያኖር የለም፤ ቢደረግ ግን አዲሱ የወይን ጠጅ አቁማዳውን ያፈነዳል፥ እርሱም ይፈሳል አቁማዳውም ይጠፋል። ");
INSERT INTO amh_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","አዲሱን የወይን ጠጅ ግን በአዲስ አቁማዳ ማኖር ይገባል፥ ሁለቱም ይጠባበቃሉ። ");
INSERT INTO amh_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","አሮጌ የወይን ጠጅ ሲጠጣ አዲሱን የሚሻ ማንም የለም፤ አሮጌው ይጣፍጣል ይላልና። ");
INSERT INTO amh_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","በሰንበትም በእርሻ መካከል ያልፍ ነበር ደቀ መዛሙርቱም እሸት ይቀጥፉ በእጃቸውም እያሹ ይበሉ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ከፈሪሳውያን ግን አንዳንዶቹ። በሰንበት ሊያደርግ ያልተፈቀደውን ስለ ምን ታደርጋላችሁ? አሉአቸው። ");
INSERT INTO amh_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","5","የሰው ልጅ የሰንበት ጌታ ነው አላቸውም። ");
INSERT INTO amh_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","በሌላው ሰንበትም ወደ ምኵራብ ገብቶ አስተማረ፤ በዚያም ቀኝ እጁ የሰለለች ሰው ነበረ፤ ");
INSERT INTO amh_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ጻፎችና ፈሪሳውያንም መክሰሻ ሊያገኙበት በሰንበት ይፈውስ እንደ ሆነ ይጠባበቁት ነበር። ");
INSERT INTO amh_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","እርሱ ግን አሳባቸውን አውቆ እጁ የሰለለችውን ሰው። ተነሣና በመካከል ቁም አለው፤ ተነሥቶም ቆመ። ");
INSERT INTO amh_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ኢየሱስም። እጠይቃችኋለሁ፤ በሰንበት በጎ ማድረግ ተፈቅዶአልን ወይስ ክፉ? ነፍስ ማዳንን ወይስ መግደል? አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ሁላቸውንም ዙሪያውን አየና ሰውዬውን። እጅህን ዘርጋ አለው። እርሱም እንዲህ አደረገ፥ እጁም እንደ ሁለተኛይቱ ዳነች። ");
INSERT INTO amh_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","እነርሱም ቍጣ ሞላባቸው፥ በኢየሱስም ምን እንዲያደርጉበት እርስ በርሳቸው ተባባሉ። ");
INSERT INTO amh_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","በነዚህም ወራት ይጸልይ ዘንድ ወደ ተራራ ወጣ፥ ሌሊቱንም ሁሉ ወደ እግዚአብሔር ሲጸልይ አደረ። ");
INSERT INTO amh_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","በነጋም ጊዜ ደቀ መዛሙርቱን ጠራ፥ ከእነርሱም አሥራ ሁለት መረጠ ደግሞም ሐዋርያት ብሎ ሰየማቸው፤ ");
INSERT INTO amh_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","እነርሱም፥ ጴጥሮስ ብሎ እንደ ገና የሰየመው ስምዖን፥ ወንድሙም እንድርያስ፥ ያዕቆብም ዮሐንስም፥ ፊልጶስም በርተሎሜዎስም፥ ");
INSERT INTO amh_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ማቴዎስም ቶማስም፥ የእልፍዮስ ልጅ ያዕቆብም ቀናተኛ የሚባለው ስምዖንም፥ ");
INSERT INTO amh_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","የያዕቆብ ይሁዳም፥ አሳልፎ የሰጠውም የአስቆሮቱ ይሁዳ ናቸው። ");
INSERT INTO amh_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ከእነርሱም ጋር ወርዶ በተካከለ ስፍራ ቆመ፥ ከደቀ መዛሙርቱም ወገን ብዙ ሕዝብ ነበረ፥ ደግሞም ሊሰሙትና ከደዌአቸው ሊፈወሱ ከይሁዳ ሁሉ ከኢየሩሳሌምም ከጢሮስና ከሲዶና ባሕር ዳርም የመጡ ብዙ ሰዎች ነበሩ፤ ");
INSERT INTO amh_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ከርኵሳንም መናፍስት ይሠቃዩ የነበሩት ተፈወሱ፤ ");
INSERT INTO amh_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ከእርሱም ኃይል ወጥቶ ሁሉን ይፈውስ ነበርና ሕዝቡ ሁሉ ሊዳስሱት ይሹ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","እርሱም ወደ ደቀ መዛሙርቱ ዓይኑን አነሣ እንዲህም አላቸው። እናንተ ድሆች ብፁዓን ናችሁ፥ የእግዚአብሔር መንግሥት የእናንተ ነውና። ");
INSERT INTO amh_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","እናንተ አሁን የምትራቡ ብፁዓን ናችሁ፥ ትጠግባላችሁና። እናንተ አሁን የምታለቅሱ ብፁዓን ናችሁ፥ ትስቃላችሁና። ");
INSERT INTO amh_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ሰዎች ስለ ሰው ልጅ ሲጠሉአችሁ ሲለዩአችሁም ሲነቅፉአችሁም ስማችሁንም እንደ ክፉ ሲያወጡ፥ ብፁዓን ናችሁ። ");
INSERT INTO amh_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","እነሆ፥ ዋጋችሁ በሰማይ ታላቅ ነውና በዚያን ቀን ደስ ይበላችሁ ዝለሉም፤ አባቶቻቸው ነቢያትን እንዲህ ያደርጉባቸው ነበርና። ");
INSERT INTO amh_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ነገር ግን እናንተ ባለ ጠጎች ወዮላችሁ፥ መጽናናታችሁን ተቀብላችኋልና። ");
INSERT INTO amh_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","እናንተ አሁን የጠገባችሁ ወዮላችሁ፥ ትራባላችሁና። እናንተ አሁን የምትስቁ ወዮላችሁ፥ ታዝናላችሁና ታለቅሱማላችሁ። ");
INSERT INTO amh_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ሰዎች ሁሉ መልካም ሲናገሩላችሁ፥ ወዮላችሁ፤ አባቶቻቸው ለሐሰተኞች ነቢያት እንዲሁ ያደርጉላቸው ነበርና። ");
INSERT INTO amh_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ነገር ግን ለእናንተ ለምትሰሙ እላችኋለሁ፥ ጠላቶቻችሁን ውደዱ፥ ለሚጠሉአችሁ መልካም አድርጉ፥ ");
INSERT INTO amh_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","የሚረግሙአችሁንም መርቁ፥ ስለሚበድሉአችሁም ጸልዩ። ");
INSERT INTO amh_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ጕንጭህን ለሚመታህ ደግሞ ሁለተኛውን ስጠው፥ መጐናጸፊያህንም ለሚወስድ እጀ ጠባብህን ደግሞ አትከልክለው። ");
INSERT INTO amh_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ለሚለምንህ ሁሉ ስጥ፥ ገንዘብህንም የሚወስድ እንዲመልስ አትጠይቀው። ");
INSERT INTO amh_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ሰዎችም ሊያደርጉላችሁ እንደምትወዱ እናንተ ደግሞ እንዲሁ አድርጉላቸው። ");
INSERT INTO amh_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","የሚወዱአችሁንማ ብትወዱ፥ ምን ምስጋና አላችሁ? ኃጢአተኞች ደግሞ የሚወዱአቸውን ይወዳሉና። ");
INSERT INTO amh_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","መልካምም ለሚያደርጉላችሁ መልካም ብታደርጉ፥ ምን ምስጋና አላችሁ? ኃጢአተኞች ደግሞ ያን ያደርጋሉና። ");
INSERT INTO amh_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","እንድትወስዱባቸው ተስፋ ለምታደርጉአቸው ብታበድሩ፥ ምን ምስጋና አላችሁ? ኃጢአተኞች ደግሞ በትክክል እንዲቀበሉ ለኃጢአተኞች ያበድራሉ። ");
INSERT INTO amh_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ነገር ግን ጠላቶቻችሁን ውደዱ፤ መልካም አድርጉ፤ ምንም ተስፋ ሳታደርጉም አበድሩ፥ ዋጋችሁም ታላቅ ይሆናል፥ የልዑልም ልጆች ትሆናላችሁ፥ እርሱ ለማያመሰግኑ ለክፉዎችም ቸር ነውና። ");
INSERT INTO amh_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","አባታችሁ ርኅሩኅ እንደ ሆነ ርኅሩኆች ሁኑ። ");
INSERT INTO amh_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","አትፍረዱ አይፈረድባችሁምም፤ አትኰንኑ አትኰነኑምም። ይቅር በሉ ይቅርም ትባላላችሁ። ");
INSERT INTO amh_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ስጡ ይሰጣችሁማል፤ በምትሰፍሩበት መስፈሪያ ተመልሶ ይሰፈርላችኋልና፥ የተጨቈነና የተነቀነቀ የተትረፈረፈም መልካም መስፈሪያ በእቅፋችሁ ይሰጣችኋል። ");
INSERT INTO amh_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ምሳሌም አላቸው። ዕውር ዕውርን ሊመራ ይችላልን? ሁለቱ በጕድጓድ አይወድቁምን? ");
INSERT INTO amh_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ደቀ መዝሙር ከመምህሩ አይበልጥም፤ ፈጽሞ የተማረ ሁሉ ግን እንደ መምህሩ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","በወንድምህም ዓይን ያለውን ጉድፍ ስለ ምን ታያለህ፥ በራስህ ዓይን ግን ያለውን ምሰሶ ስለ ምን አትመለከትም? ");
INSERT INTO amh_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","በዓይንህ ያለውን ምሰሶ ራስህ ሳታይ፥ እንዴት ወንድምህን። ወንድሜ ሆይ፥ በዓይንህ ያለውን ጉድፍ ላውጣ ፍቀድልኝ ልትል ትችላለህ? አንተ ግብዝ፥ አስቀድመህ ከዓይንህ ምሰሶውን አውጣ ከዚያም በኋላ በወንድምህ ዓይን ያለውን ጉድፍ ታወጣ ዘንድ አጥርተህ ታያለህ። ");
INSERT INTO amh_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ክፉ ፍሬ የሚያደርግ መልካም ዛፍ የለምና፥ እንዲሁም መልካም ፍሬ የሚያደርግ ክፉ ዛፍ የለም። ");
INSERT INTO amh_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ዛፍ ሁሉ ከፍሬው ይታወቃልና፤ ከእሾህ በለስ አይለቅሙም፥ ከአጣጥ ቍጥቋጦም ወይን አይቈርጡም። ");
INSERT INTO amh_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","በልብ ሞልቶ ከተረፈው አፉ ይናገራልና መልካም ሰው ከልብ መልካም መዝገብ መልካሙን ያወጣል፥ ክፉ ሰውም ከልብ ክፉ መዝገብ ክፉውን ያወጣል። ");
INSERT INTO amh_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","ስለ ምን። ጌታ ሆይ፥ ጌታ ሆይ፥ ትሉኛላችሁ፥ የምለውንም አታደርጉም? ");
INSERT INTO amh_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ወደ እኔ የሚመጣ ሁሉ ቃሌንም ሰምቶ የሚያደርገው፥ ማንን እንዲመስል አሳያችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ቤት ሲሠራ አጥልቆ የቆፈረ በዓለት ላይም የመሠረተ ሰውን ይመስላል፤ ጐርፍም በመጣ ጊዜ ወንዙ ያን ቤት ገፋው፥ በዓለት ላይም ስለ ተመሠረተ ሊያናውጠው አልቻለም። ");
INSERT INTO amh_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ሰምቶ የማያደርገው ግን ያለ መሠረት በምድር ላይ ቤቱን የሠራ ሰውን ይመስላል፤ ወንዙም ገፋው ወዲያውም ወደቀ የዚያ ቤት አወዳደቅም ታላቅ ሆነ። ");
INSERT INTO amh_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ቃሉን ሁሉ በሕዝብ ጆሮዎች በጨረሰ ጊዜ ወደ ቅፍርናሆም ገባ። ");
INSERT INTO amh_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","አንድ የመቶ አለቃም ነበረ፤ የሚወደውም ባሪያው ታሞ ሊሞት ቀርቦ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ስለ ኢየሱስም በሰማ ጊዜ የአይሁድን ሽማግሎች ወደ እርሱ ላከና መጥቶ ባሪያውን እንዲያድን ለመነው። ");
INSERT INTO amh_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","እነርሱም ወደ ኢየሱስ መጥተው። ይህን ልታደርግለት ይገባዋል፤ ");
INSERT INTO amh_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ሕዝባችንን ይወዳልና ምኵራብም ራሱ ሠርቶልናል ብለው አጽንተው ለመኑት። ");
INSERT INTO amh_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ኢየሱስም ከእነርሱ ጋር ሄደ። አሁንም ወደ ቤቱ በቀረበ ጊዜ የመቶው አለቃ ወዳጆቹን ወደ እርሱ ላከ፤ አለውም። ጌታ ሆይ በቤቴ ጣራ በታች ልትገባ አይገባኝምና አትድከም፤ ");
INSERT INTO amh_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ስለዚህም ወደ አንተ ልመጣ እንዲገባኝ ሰውነቴን አልቈጠርሁትም፤ ነገር ግን ቃል ተናገር፥ ብላቴናዬም ይፈወሳል። ");
INSERT INTO amh_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","እኔ ደግሞ ከሌሎች በታች የምገዛ ሰው ነኝ፥ ከእኔም በታች ወታደሮች አሉኝ፥ አንዱንም። ሂድ ብለው ይሄዳል፥ ሌላውንም። ና ብለው ይመጣል፥ ባሪያዬንም። ይህን አድርግ ብለው ያደርጋል። ");
INSERT INTO amh_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ኢየሱስም ይህን ሰምቶ በእርሱ ተደነቀ፥ ዘወርም ብሎ ለተከተሉት ሕዝብ። እላችኋለሁ፥ በእስራኤልስ እንኳ እንዲህ ያለ ትልቅ እምነት አላገኘሁም አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","የተላኩትም ወደ ቤት ተመልሰው ባሪያውን ባለ ጤና ሆኖ አገኙት። ");
INSERT INTO amh_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","በነገውም ናይን ወደምትባል ወደ አንዲት ከተማ ሄደ፥ ደቀ መዛሙርቱም ብዙ ሕዝብም ከእርሱ ጋር አብረው ሄዱ። ");
INSERT INTO amh_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ወደ ከተማይቱም በር በቀረበ ጊዜ፥ እነሆ፥ የሞተ ሰው ተሸክመው አወጡ፤ እርሱም ለእናቱ አንድ ልጅ ነበረ፥ እርስዋም መበለት ነበረች፥ ብዙም የከተማ ሕዝብ ከእርስዋ ጋር አብረው ነበሩ። ");
INSERT INTO amh_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ጌታም ባያት ጊዜ አዘነላትና። አታልቅሽ አላት። ");
INSERT INTO amh_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ቀርቦም ቃሬዛውን ነካ፥ የተሸከሙትም ቆሙ፤ አለውም። አንተ ጐበዝ፥ እልሃለሁ፥ ተነሣ። ");
INSERT INTO amh_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","የሞተውም ቀና ብሎ ተቀመጠ ሊናገርም ጀመረ፥ ለእናቱም ሰጣት። ");
INSERT INTO amh_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ሁሉንም ፍርሃት ያዛቸውና። ታላቅ ነቢይ በእኛ መካከል ተነሥቶአል፥ ደግሞ። እግዚአብሔር ሕዝቡን ጐበኘ እያሉ እግዚአብሔርን አመሰገኑ። ");
INSERT INTO amh_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ይህም ዝና ስለ እርሱ በይሁዳ ሁሉ በዙሪያውም ባለች አገር ሁሉ ወጣ። ");
INSERT INTO amh_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ደቀ መዛሙርቱም ለዮሐንስ እነዚህን ሁሉ አወሩ። ");
INSERT INTO amh_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ዮሐንስም ከደቀ መዛሙርቱ ሁለት ወደ እርሱ ጠርቶ። የሚመጣው አንተ ነህን ወይስ ሌላውን እንጠብቅ? ብሎ ወደ ኢየሱስ ላከ። ");
INSERT INTO amh_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ሰዎቹም ወደ እርሱ መጥተው። መጥምቁ ዮሐንስ። የሚመጣው አንተ ነህን ወይስ ሌላውን እንጠብቅ? ብሎ ወደ አንተ ላከን አሉት። ");
INSERT INTO amh_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","በዚያች ሰዓት ከደዌና ከሥቃይ ከክፉዎች መናፍስትም ብዙዎችን ፈወሰ፥ ለብዙ ዕውሮችም ማየትን ሰጠ። ");
INSERT INTO amh_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ኢየሱስም መልሶ። ሄዳችሁ ያያችሁትን የሰማችሁትንም ለዮሐንስ አውሩለት፤ ዕውሮች ያያሉ፥ አንካሶችም ይሄዳሉ፥ ለምጻሞችም ይነጻሉ፥ ደንቆሮዎችም ይሰማሉ፥ ሙታንም ይነሣሉ፥ ለድሆችም ወንጌል ይሰበካል፤ ");
INSERT INTO amh_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","በእኔም የማይሰናከለው ሁሉ ብፁዕ ነው አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","የዮሐንስ መልክተኞችም ከሄዱ በኋላ፥ ለሕዝቡ ስለ ዮሐንስ ይናገር ጀመር እንዲህም አለ። ምን ልታዩ ወደ ምድረ በዳ ወጣችሁ? ነፋስ የሚወዘውዘውን ሸምበቆን? ወይስ ምን ልታዩ ወጣችሁ? ");
INSERT INTO amh_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ቀጭን ልብስ የለበሰውን ሰውን? እነሆ፥ ጌጠኛ ልብስ የሚለብሱና በቅምጥልነት የሚኖሩ በነገሥታት ቤት አሉ። ");
INSERT INTO amh_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ወይስ ምን ልታዩ ወጣችሁ? ነቢይን? አዎን እላችኋለሁ፥ ከነቢይም የሚበልጠውን። ");
INSERT INTO amh_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","እነሆ፥ መንገድህን በፊትህ የሚጠርግ መልክተኛዬን በፊትህ እልካለሁ ተብሎ የተጻፈለት ይህ ነው። ");
INSERT INTO amh_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","እላችኋለሁ፥ ከሴቶች ከተወለዱት መካከል ከመጥምቁ ዮሐንስ የሚበልጥ ማንም የለም፤ በእግዚአብሔር መንግሥት ግን ከሁሉ የሚያንሰው ይበልጠዋል። ");
INSERT INTO amh_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","የሰሙትም ሕዝብ ሁሉ ቀራጮች እንኳ ሳይቀሩ በዮሐንስ ጥምቀት ተጠምቀው እግዚአብሔርን አጸደቁ፤ ");
INSERT INTO amh_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ፈሪሳውያንና ሕግ አዋቂዎች ግን በእርሱ ስለ አልተጠመቁ የእግዚአብሔርን ምክር ከራሳቸው ጣሉ። ");
INSERT INTO amh_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","እንግዲህ የዚችን ትውልድ ሰዎች በምን አስመስላቸዋለሁ? ማንንስ ይመስላሉ? ");
INSERT INTO amh_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","በገበያ የሚቀመጡትን ልጆች ይመስላሉ፥ እርስ በርሳቸውም እየተጠራሩ። እንቢልታ ነፋንላችሁ አልዘፈናችሁምም፤ ሙሾ አወጣንላችሁ አላለቀሳችሁምም ይላል። ");
INSERT INTO amh_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","መጥምቁ ዮሐንስ እንጀራ ሳይበላ የወይን ጠጅም ሳይጠጣ መጥቶ ነበርና። ጋኔን አለበት አላችሁት። ");
INSERT INTO amh_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","የሰው ልጅ እየበላና እየጠጣ መጥቶአልና። እነሆ፥ በላተኛና የወይን ጠጅ ጠጭ፥ የቀራጮችና የኃጢአተኞች ወዳጅ አላችሁት። ");
INSERT INTO amh_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ጥበብም ለልጆችዋ ሁሉ ጸደቀች። ");
INSERT INTO amh_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ከፈሪሳውያንም አንድ ከእርሱ ጋር ይበላ ዘንድ ለመነው፤ በፈሪሳዊው ቤትም ገብቶ በማዕድ ተቀመጠ። ");
INSERT INTO amh_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","እነሆም በዚያች ከተማ ኃጢአተኛ የነበረች አንዲት ሴት፤ በፈሪሳዊው ቤት በማዕድ እንደ ተቀመጠ ባወቀች ጊዜ፥ ሽቱ የሞላበት የአልባስጥሮስ ቢልቃጥ አመጣች። ");
INSERT INTO amh_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","በስተ ኋላውም በእግሩ አጠገብ ቆማ እያለቀሰች በእንባዋ እግሩን ታርስ ጀመረች፥ በራስ ጠጕርዋም ታብሰው እግሩንም ትስመው ሽቱም ትቀባው ነበረች። ");
INSERT INTO amh_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","የጠራው ፈሪሳዊም አይቶ። ይህስ ነቢይ ቢሆን፥ ይህች የምትዳስሰው ሴት ማን እንደ ሆነች እንዴትስ እንደ ነበረች ባወቀ ነበር፥ ኃጢአተኛ ናትና ብሎ በልቡ አሰበ። ");
INSERT INTO amh_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ኢየሱስም መልሶ። ስምዖን ሆይ፥ የምነግርህ ነገር አለኝ አለው። እርሱም። መምህር ሆይ፥ ተናገር አለ። ");
INSERT INTO amh_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ለአንድ አበዳሪ ሁለት ተበዳሪዎች ነበሩት በአንዱ አምስት መቶ ዲናር ነበረበት በሁለተኛውም አምሳ። ");
INSERT INTO amh_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","የሚከፍሉትም ቢያጡ ለሁለቱም ተወላቸው። እንግዲህ ከእነርሱ አብልጦ የሚወደው ማንኛው ነው? ");
INSERT INTO amh_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ስምዖንም መልሶ። ብዙ የተወለቱ ይመስለኛል አለ። እርሱም። በእውነት ፈረድህ አለው። ");
INSERT INTO amh_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ወደ ሴቲቱም ዘወር ብሎ ስምዖንን እንዲህ አለው። ይህችን ሴት ታያለህን? እኔ ወደ ቤትህ ገባሁ፥ ውኃ ስንኳ ለእግሬ አላቀረብህልኝም፤ እርስዋ ግን በእንባዋ እግሬን አራሰች በጠጕርዋም አበሰች። ");
INSERT INTO amh_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","አንተ አልሳምኸኝም፤ እርስዋ ግን ከገባሁ ጀምራ እግሬን ከመሳም አላቋረጠችም። ");
INSERT INTO amh_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","አንተ ራሴን ዘይት አልቀባኸኝም፤ እርስዋ ግን እግሬን ሽቱ ቀባች። ");
INSERT INTO amh_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ስለዚህ እልሃለሁ፥ እጅግ ወዳለችና ብዙ ያለው ኃጢአትዋ ተሰርዮላታል፤ ጥቂት ግን የሚሰረይለት ጥቂት ይወዳል። ");
INSERT INTO amh_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","እርስዋንም። ኃጢአትሽ ተሰርዮልሻል አላት። ");
INSERT INTO amh_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ከእርሱም ጋር በማዕድ ተቀምጠው የነበሩት በልባቸው። ኃጢአትን እንኳ የሚያስተሰርይ ይህ ማን ነው? ይሉ ጀመር። ");
INSERT INTO amh_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ሴቲቱንም። እምነትሽ አድኖሻል፤ በሰላም ሂጂ አላት። ");
INSERT INTO amh_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ከዚህም በኋላ እየሰበከና ስለ እግዚአብሔር መንግሥት የምሥራች እየተናገረ በየከተማይቱ በየመንደሩም ያልፍ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","አሥራ ሁለቱም ከእርሱ ጋር ነበሩ፥ ከክፉዎች መናፍስትና ከደዌም ተፈውሰው የነበሩ አንዳንድ ሴቶች፤ እነርሱም ሰባት አጋንንት የወጡላት መግደላዊት የምትባል ማርያም፥ ");
INSERT INTO amh_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","የሄሮድስ አዛዥ የኩዛ ሚስት ዮሐናም ሶስናም ብዙዎች ሌሎችም ሆነው በገንዘባቸው ያገለግሉት ነበር። ");
INSERT INTO amh_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ብዙ ሕዝብም በተሰበሰቡ ጊዜ ከከተማዎችም ሁሉ ወደ እርሱ በመጡ ጊዜ በምሳሌ እንዲህ ሲል ተናገራቸው። ");
INSERT INTO amh_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","ዘሪ ዘሩን ሊዘራ ወጣ። ሲዘራም አንዳንዱ በመንገድ ዳር ወደቀ ተረገጠም፥ የሰማይ ወፎችም በሉት። ");
INSERT INTO amh_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ሌላውም በዓለት ላይ ወደቀ፥ በበቀለም ጊዜ እርጥበት ስላልነበረው ደረቀ። ");
INSERT INTO amh_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ሌላውም በእሾህ መካከል ወደቀ፥ እሾሁም አብሮ በቀለና አነቀው። ");
INSERT INTO amh_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ሌላውም በመልካም መሬት ላይ ወደቀ፤ በበቀለም ጊዜ መቶ እጥፍ አፈራ። ይህን በተናገረ ጊዜ። የሚሰማ ጆሮ ያለው ይስማ ብሎ ጮኸ። ");
INSERT INTO amh_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ደቀ መዛሙርቱም። ይህ ምሳሌ ምንድር ነው? ብለው ጠየቁት። ");
INSERT INTO amh_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","እርሱም እንዲህ አለ። ለእናንተ የእግዚአብሔርን መንግሥት ምሥጢር ማወቅ ተሰጥቶአችኋል፤ ለሌሎች ግን እያዩ እንዳያዩ እየሰሙም እንዳያስተውሉ በምሳሌ ነው። ");
INSERT INTO amh_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ምሳሌው ይህ ነው። ዘሩ የእግዚአብሔር ቃል ነው። ");
INSERT INTO amh_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","በመንገድ ዳርም ያሉት የሚሰሙ ናቸው፤ ከዚህ በኋላም ዲያብሎስ ይመጣል አምነውም እንዳይድኑ ቃሉን ከልባቸው ይወስዳል። ");
INSERT INTO amh_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","በዓለት ላይም ያሉት ሲሰሙ ቃሉን በደስታ የሚቀበሉ ናቸው፤ እነርሱም ለጊዜው ብቻ ያምናሉ እንጂ በፈተና ጊዜ የሚክዱ ሥር የሌላቸው ናቸው። ");
INSERT INTO amh_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","በእሾህ መካከልም የወደቀ እነዚህ የሚሰሙት ናቸው፤ መንገዳቸውንም ሄደው በሕይወት ዘመን በአሳብና በባለ ጠግነት ምቾት ይታነቃሉ፥ ሙሉ ፍሬም አያፈሩም። ");
INSERT INTO amh_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","በመልካም መሬት ላይም የወደቀ እነርሱ በመልካምና በበጎ ልብ ቃሉን ሰምተው የሚጠብቁት በመጽናትም ፍሬ የሚያፈሩ ናቸው። ");
INSERT INTO amh_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","መብራትንም አብርቶ በዕቃ የሚከድነው ወይም ከአልጋ በታች የሚያኖረው የለም፥ የሚገቡት ሰዎች ብርሃኑን እንዲያዩ በመቅረዝ ላይ ያኖረዋል እንጂ። ");
INSERT INTO amh_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","የማይገለጥ የተሰወረ የለምና፥ የማይታወቅም ወደ ግልጥም የማይመጣ የተሸሸገ የለም። ");
INSERT INTO amh_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","እንግዲህ እንዴት እንድትሰሙ ተጠበቁ፤ ላለው ሁሉ ይሰጠዋልና፥ ከሌለውም ሁሉ፥ ያው ያለው የሚመስለው እንኳ ይወሰድበታል። ");
INSERT INTO amh_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","እናቱና ወንድሞቹም ወደ እርሱ መጡ፥ ከሕዝቡም ብዛት የተነሣ ሊያገኙት አልተቻላቸውም። ");
INSERT INTO amh_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","እናትህና ወንድሞችህ ሊያዩህ ወድደው በውጭ ቆመዋል ብለው ነገሩት። ");
INSERT INTO amh_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","እርሱም መልሶ። እናቴና ወንድሞቼስ የእግዚአብሔርን ቃል ሰምተው የሚያደርጉት እነዚህ ናቸው አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ከዕለታቱም በአንዱ እርሱ ከደቀ መዛሙርቱ ጋር ወደ ታንኳ ገብቶ። ወደ ባሕር ማዶ እንሻገር አላቸው፤ ተነሡም። ");
INSERT INTO amh_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ሲሄዱም አንቀላፋ። ዓውሎ ነፋስም በባሕር ላይ ወረደ፥ ውኃውም ታንኳይቱን ይሞላ ነበርና ይጨነቁ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ቀርበውም። አቤቱ፥ አቤቱ ጠፋን እያሉ አስነሡት። እርሱም ነቅቶ ነፋሱንና የውኃውን ማዕበል ገሠጻቸው፤ ተዉም፥ ጽጥታም ሆነ። ");
INSERT INTO amh_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","እርሱም። እምነታችሁ የት ነው? አላቸው። ፈርተውም ተደነቁ፥ እርስ በርሳቸውም። እንዲህ ነፋሳትንና ውኃን እንኳ የሚያዝ ለእርሱም የሚታዘዙለት ይህ ማን ነው? አሉ። ");
INSERT INTO amh_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","በገሊላም አንጻር ወዳለችው ወደ ጌርጌሴኖን አገር በታንኳ ደረሱ። ");
INSERT INTO amh_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ወደ ምድርም በወጣ ጊዜ አጋንንት ያደሩበት አንድ ሰው ከከተማ ወጥቶ ተገናኘው፥ ከብዙ ዘመንም ጀምሮ ልብስ ሳይለብስ በመቃብር እንጂ በቤት አይኖርም ነበር። ");
INSERT INTO amh_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ኢየሱስንም ባየ ጊዜ ጮኾ በፊቱ ተደፋ በታላቅ ድምፅም። የልዑል እግዚአብሔር ልጅ ኢየሱስ ሆይ፥ ከአንተ ጋር ምን አለኝ? እንዳትሣቀየኝ እለምንሃለሁ አለ። ");
INSERT INTO amh_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ርኵሱን መንፈስ ከሰውዬው እንዲወጣ ያዘው ነበርና። ብዙ ዘመንም ይዞት ነበርና፥ በሰንሰለትና በእግር ብረትም ታስሮ ይጠበቅ ነበር፤ እስራቱንም ሰብሮ በጋኔኑ ወደ ምድረ በዳ ይነዳ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ኢየሱስም። ስምህ ማን ነው? ብሎ ጠየቀው። እርሱም ብዙዎች አጋንንት ገብተውበት ነበርና። ሌጌዎን አለው። ");
INSERT INTO amh_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ወደ ጥልቁም ሊሄዱ እንዳያዛቸው ለመኑት። ");
INSERT INTO amh_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","በዚያም በተራራው የብዙ እሪያ መንጋ ይሰማሩ ነበር፤ ወደ እነርሱም ሊገቡ እንዲፈቅድላቸው ለመኑት፤ ፈቀደላቸውም። ");
INSERT INTO amh_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","አጋንንትም ከሰውዬው ወጥተው ወደ እሪያዎች ገቡ፥ መንጋውም ከአፋፉ ወደ ባሕር ተጣደፉና ሰጠሙ። ");
INSERT INTO amh_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","እረኞችም የሆነውን ባዩ ጊዜ ሸሽተው በከተማውና በአገሩ አወሩት። ");
INSERT INTO amh_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","የሆነውን ነገር ሊያዩ ወጥተውም ወደ ኢየሱስ መጡ፥ አጋንንትም የወጡለትን ሰው ለብሶ ልቡም ተመልሶ በኢየሱስ እግር አጠገብ ተቀምጦ አገኙትና ፈሩ። ");
INSERT INTO amh_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ያዩትም ደግሞ አጋንንት ያደሩበት ሰው እንዴት እንደ ዳነ አወሩላቸው። ");
INSERT INTO amh_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","በዙሪያውም በጌርጌሴኖን አገር ያሉት ሕዝብ ሁሉ ታላቅ ፍርሃት ይዞአቸዋልና ከእነርሱ እንዲሄድ ለመኑት በታንኳም ገብቶ ተመለሰ። ");
INSERT INTO amh_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","አጋንንት የወጡለት ሰውም ከእርሱ ጋር ይኖር ዘንድ ለመነው፤ ");
INSERT INTO amh_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ነገር ግን። ወደ ቤትህ ተመለስ፥ እግዚአብሔር እንዴት ያለ ታላቅ ነገር እንዳደረግልህ ንገር ብሎ አሰናበተው። ኢየሱስም እንዴት ያለ ታላቅ ነገር እንዳደረገለት በከተማው ሁሉ እየሰበከ ሄደ። ");
INSERT INTO amh_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ኢየሱስም በተመለሰ ጊዜ ሁሉ ይጠብቁት ነበርና ሕዝቡ ተቀበሉት። ");
INSERT INTO amh_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","እነሆም፥ ኢያኢሮስ የሚባል ሰው መጣ፥ እርሱም የምኵራብ አለቃ ነበረ በኢየሱስም እግር ላይ ወድቆ ወደ ቤቱ እንዲገባ ለመነው፤ ");
INSERT INTO amh_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","አሥራ ሁለት ዓመት የሆናት አንዲት ሴት ልጅ ነበረችውና፤ እርስዋም ለሞት ቀርባ ነበረች። ሲሄድም ሕዝቡ ያጨናንቁት ነበር። ");
INSERT INTO amh_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ከአሥራ ሁለት ዓመትም ጀምሮ ደም የሚፈሳት ሴት ነበረች፥ ትዳርዋንም ሁሉ ለባለመድኃኒቶች ከስራ ማንም ሊፈውሳት አልተቻለውም። ");
INSERT INTO amh_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","በኋላውም ቀርባ የልብሱን ጫፍ ዳሰሰች፥ የደምዋም ፈሳሽ በዚያን ጊዜ ቆመ። ");
INSERT INTO amh_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ኢየሱስም። የዳሰሰኝ ማን ነው? አለ። ሁሉም በካዱ ጊዜ፥ ጴጥሮስና ከእርሱ ጋር የነበሩት። አቤቱ፥ ሕዝቡ ያጫንቁሃልና ያጋፉህማል፤ የዳሰሰኝ ማን ነው ትላለህን? አሉ። ");
INSERT INTO amh_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ኢየሱስ ግን። አንድ ሰው ዳስሶኛል፥ ኃይል ከእኔ እንደ ወጣ እኔ አውቃለሁና አለ። ");
INSERT INTO amh_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ሴቲቱም እንዳልተሰወረች ባየች ጊዜ እየተንቀጠቀጠች መጥታ በፊቱ ተደፋች፥ በምን ምክንያትም እንደ ዳሰሰችው ፈጥናም እንደ ተፈወሰች በሕዝቡ ሁሉ ፊት አወራች። ");
INSERT INTO amh_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","እርሱም። ልጄ ሆይ፥ እምነትሽ አድኖሻል፤ በሰላም ሂጂ አላት። ");
INSERT INTO amh_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","እርሱም ገና ሲናገር አንድ ሰው ከምኵራብ አለቃው ቤት መጥቶ። ልጅህ ሞታለች፤ እንግዲህ መምህሩን አታድክም አለ። ");
INSERT INTO amh_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ኢየሱስ ግን ሰምቶ። አትፍራ፤ እመን ብቻ ትድንማለች ብሎ መለሰለት። ");
INSERT INTO amh_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ወደ ቤትም ሲገባ ከጴጥሮስና ከያዕቆብ ከዮሐንስም ከብላቴናይቱም አባትና እናት በቀር ማንም ከእርሱ ጋር ይገባ ዘንድ አልፈቀደም። ");
INSERT INTO amh_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ሁሉም እያለቀሱላት ዋይ ዋይ ይሉ ነበር። እርሱ ግን። አታልቅሱ፤ ተኝታለች እንጂ አልሞተችም አለ። ");
INSERT INTO amh_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","እንደ ሞተችም አውቀው በጣም ሳቁበት። ");
INSERT INTO amh_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","እርሱ ግን እጅዋን ይዞ። አንቺ ብላቴና፥ ተነሺ ብሎ ጮኸ። ");
INSERT INTO amh_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ነፍስዋም ተመለሰች፥ ፈጥናም ቆመች፥ የምትበላውንም እንዲሰጡአት አዘዘ። ");
INSERT INTO amh_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ወላጆችዋም ተገረሙ፤ እርሱ ግን የሆነውን ለማንም እንዳይነግሩ አዘዛቸው። ");
INSERT INTO amh_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","አሥራ ሁለቱንም ሐዋርያት በአንድነት ወደ እርሱ ጠርቶ በአጋንንት ሁሉ ላይ ደዌንም ይፈውሱ ዘንድ ኃይልና ሥልጣን ሰጣቸው፤ ");
INSERT INTO amh_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","የእግዚአብሔርንም መንግሥት እንዲሰብኩና ድውዮችን እንዲፈውሱ ላካቸው፥ ");
INSERT INTO amh_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","እንዲህም አላቸው። በትርም ቢሆን፥ ከረጢትም ቢሆን፥ እንጀራም ቢሆን፥ ብርም ቢሆን ለመንገድ ምንም አትያዙ፥ ሁለት እጀ ጠባብም አይሁንላችሁ። ");
INSERT INTO amh_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","በማናቸውም በምትገቡበት ቤት በዚያ ተቀመጡ ከዚያም ውጡ። ");
INSERT INTO amh_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ማናቸውም የማይቀበሉአችሁ ቢሆኑ፥ ከዚያ ከተማ ወጥታችሁ ምስክር እንዲሆንባቸው ከእግራችሁ ትቢያ አራግፉ። ");
INSERT INTO amh_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ወጥተውም ወንጌልን እየሰበኩና በስፍራው ሁሉ እየፈወሱ በየመንደሩ ያልፉ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","የአራተኛው ክፍል ገዥ ሄሮድስም የተደረገውን ነገር ሁሉ ሰምቶ፥ አንዳንድ ሰዎች። ");
INSERT INTO amh_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ዮሐንስ ከሙታን ተነሣ፥ ሌሎችም። ኤልያስ ተገለጠ፥ ሌሎችም። ከቀደሙት ነቢያት አንዱ ተነሥቶአል ይሉ ስለ ነበሩ አመነታ። ");
INSERT INTO amh_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ሄሮድስም። ዮሐንስንስ እኔ ራሱን አስቈረጥሁት፤ ይህ እንዲህ ያለ ነገር የምሰማበት ማን ነው? አለ። ሊያየውም ይሻ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ሐዋርያትም ተመልሰው ያደረጉትን ሁሉ ነገሩት። ከእርሱ ጋርም ወስዶአቸው ቤተ ሳይዳ ከምትባል ከተማ አጠገብ ወደ ምድረ በዳ ለብቻው ፈቀቅ አለ። ");
INSERT INTO amh_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ሕዝቡም አውቀው ተከተሉት፤ ተቀብሎአቸውም ስለ እግዚአብሔር መንግሥት ይነግራቸው ነበር፥ መፈወስ ያስፈለጋቸውንም ፈወሳቸው። ");
INSERT INTO amh_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ቀኑም ይመሽ ጀመር፤ አሥራ ሁለቱም ቀርበው። በዚህ በምድረ በዳ ነንና በዙሪያችን ወዳሉ መንደሮችና ገጠሮች ሄደው እንዲያድሩና ምግብ እንዲያገኙ ሕዝቡን አሰናብት አሉት። ");
INSERT INTO amh_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","እርሱ ግን። እናንተ የሚበሉትን ስጡአቸው አላቸው። እነርሱም። ሄደን ለዚህ ሁሉ ሕዝብ ምግብ ካልገዛን፥ ከአምስት እንጀራና ከሁለት ዓሣ የሚበልጥ የለንም አሉት፤ ");
INSERT INTO amh_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","አምስት ሺህ ሰዎች ያህሉ ነበርና። ለደቀ መዛሙርቱ። በየክፍሉ አምሳ አምሳውን አስቀምጡአቸው አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","እንዲህም አደረጉ ሁሉንም አስቀመጡአቸው። ");
INSERT INTO amh_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","አምስቱንም እንጀራና ሁለቱን ዓሣ ይዞ፥ ወደ ሰማይ አሻቅቦ አየና ባረካቸው ቆርሶም ለሕዝቡ እንዲያቀርቡ ለደቀ መዛርሙርቱ ሰጠ። ");
INSERT INTO amh_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ሁሉም በልተው ጠገቡ፥ ከእነርሱም የተረፈውን ቍርስራሽ አሥራ ሁለት መሶብ ወሰዱ። ");
INSERT INTO amh_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ለብቻውም ሲጸልይ ደቀ መዛሙርቱ ከእርሱ ጋር ነበሩና። ሕዝቡ እኔ ማን እንደ ሆንሁ ይላሉ? ብሎ ጠየቃቸው። ");
INSERT INTO amh_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","እነርሱም መልሰው። መጥምቁ ዮሐንስ፥ ሌሎችም። ኤልያስ፥ ሌሎችም። ከቀደሙት ነቢያት አንዱ ተነሥቶአል ይላሉ አሉት። ");
INSERT INTO amh_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","እናንተስ እኔ ማን እንደ ሆንሁ ትላላችሁ? አላቸው። ጴጥሮስም መልሶ። ከእግዚአብሔር የተቀባህ ነህ አለ። ");
INSERT INTO amh_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","23","ለሁሉም እንዲህ አላቸው። በኋላዬ ሊመጣ የሚወድ ቢኖር፥ ራሱን ይካድ መስቀሉንም ዕለት ዕለት ተሸክሞ ይከተለኝ። ");
INSERT INTO amh_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ነፍሱን ሊያድን የሚወድ ሁሉ ያጠፋታልና፤ ስለ እኔ ነፍሱን የሚያጠፋ ሁሉ ግን እርሱ ያድናታል። ");
INSERT INTO amh_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ሰው ዓለሙን ሁሉ አትርፎ ራሱን ቢያጠፋ ወይም ቢያጐድል ምን ይጠቅመዋል? ");
INSERT INTO amh_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","በእኔና በቃሌ የሚያፍር ሁሉ፥ የሰው ልጅ በክብሩ በአባቱና በቅዱሳን መላእክቱ ክብርም ሲመጣ በእርሱ ያፍርበታል። ");
INSERT INTO amh_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","እውነት እላችኋለሁ፥ በዚህ ከሚቆሙት ሰዎች የእግዚአብሔርን መንግሥት እስኪያዩ ድረስ ሞትን የማይቀምሱ አንዳንድ አሉ። ");
INSERT INTO amh_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ከዚህም ቃል በኋላ ስምንት ቀን ያህል ቈይቶ ጴጥሮስንና ዮሐንስን ያዕቆብንም ይዞ ሊጸልይ ወደ ተራራ ወጣ። ");
INSERT INTO amh_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ሲጸልይም የፊቱ መልክ ተለወጠ፤ ልብሱም ተብለጭልጮ ነጭ ሆነ። ");
INSERT INTO amh_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","እነሆም፥ ሁለት ሰዎች እነርሱም ሙሴና ኤልያስ ከእርሱ ጋር ይነጋገሩ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","በክብርም ታይተው በኢየሩሳሌም ሊፈጽም ስላለው ስለ መውጣቱ ይናገሩ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ነገር ግን ጴጥሮስንና ከእርሱ ጋር የነበሩት እንቅልፍ ከበደባቸው፤ ነቅተው ግን ክብሩንና ከእርሱ ጋር ቆመው የነበሩትን ሁለት ሰዎች አዩ። ");
INSERT INTO amh_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ከእርሱም ሲለዩ ጴጥሮስ ኢየሱስን። አቤቱ፥ በዚህ መሆን ለእኛ መልካም ነውና አንድ ለአንተ አንድም ለሙሴ አንድም ለኤልያስ ሦስት ዳሶች እንሥራ አለው፤ የሚለውንም አያውቅም ነበር። ");
INSERT INTO amh_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ይህንም ሲናገር ደመና መጣና ጋረዳቸው፤ ወደ ደመናውም ሲገቡ ሳሉ ፈሩ። ");
INSERT INTO amh_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ከደመናውም። የመረጥሁት ልጄ ይህ ነው፥ እርሱን ስሙት የሚል ድምፅ መጣ። ");
INSERT INTO amh_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ድምፁም ከመጣ በኋላ ኢየሱስ ብቻውን ሆኖ ተገኘ። እነርሱም ዝም አሉ ካዩትም ነገር በዚያ ወራት ምንም ለማንም አላወሩም። ");
INSERT INTO amh_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","በነገውም ከተራራ ሲወርዱ ብዙ ሕዝብ ተገናኙት። ");
INSERT INTO amh_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","እነሆም፥ ከሕዝቡ አንድ ሰው እንዲህ እያለ ጮኸ። መምህር ሆይ፥ ለእኔ አንድ ልጅ ነውና ልጄን እንድታይልኝ እለምንሃለሁ። ");
INSERT INTO amh_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","እነሆም፥ ጋኔን ይይዘዋል፥ ድንገትም ይጮኻል አረፋም እያስደፈቀው ያንፈራግጠዋል፥ እየቀጠቀጠም በጭንቅ ይለቀዋል፤ ");
INSERT INTO amh_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ደቀ መዛሙርትህንም እንዲያወጡት ለመንሁ፥ አልቻሉምም። ");
INSERT INTO amh_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ኢየሱስም መልሶ። እናንተ የማታምን ጠማማ ትውልድ፥ እስከ መቼ ከእናንተ ጋር እኖራለሁ? እስከ መቼስ እታገሣችኋለሁ? ልጅህን ወደዚህ አምጣው አለ። ");
INSERT INTO amh_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ሲቀርብም ጋኔኑ ጣለውና አንፈራገጠው፤ ኢየሱስ ግን ርኵሱን መንፈስ ገሥጾ ብላቴናውን ፈወሰው ለአባቱም መለሰው። ");
INSERT INTO amh_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ሁሉም ከእግዚአብሔር ታላቅነት የተነሣ ተገረሙ። ሁሉም ኢየሱስ ባደረገው ሁሉ ሲደነቁ፥ ");
INSERT INTO amh_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","ለደቀ መዛሙርቱ። የሰው ልጅ በሰው እጅ ይሰጥ ዘንድ አለውና እናንተ ይህን ቃል በጆሮአችሁ አኑሩ አለ። ");
INSERT INTO amh_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","እነርሱ ግን ይህን ነገር አላስተዋሉም፥ እንዳይገባቸውም ተሰውሮባቸው ነበር፤ ስለዚህ ነገርም እንዳይጠይቁት ፈሩ። ");
INSERT INTO amh_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ከእነርሱም ማን እንዲበልጥ ክርክር ተነሣባቸው። ");
INSERT INTO amh_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ኢየሱስም የልባቸውን አሳብ አውቆ ሕፃንን ያዘ፤ በአጠገቡም አቁሞ። ");
INSERT INTO amh_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ማንም ይህን ሕፃን በስሜ የሚቀበል እኔን ይቀበላል፤ የሚቀበለኝም ሁሉ የላከኝን ይቀበላል፤ ከሁላችሁ የሚያንስ እርሱ ታላቅ ነውና አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ዮሐንስም መልሶ። አቤቱ፥ አንድ ሰው በስምህ አጋንንትን ሲያወጣ አየነው፥ ከእኛ ጋርም ስለማይከተል ከለከልነው አለው። ");
INSERT INTO amh_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ኢየሱስ ግን። የማይቃወማችሁ ከእናንተ ጋር ነውና አትከልክሉት አለው። ");
INSERT INTO amh_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","የሚወጣበትም ወራት በቀረበ ጊዜ ወደ ኢየሩሳሌም ለመሄድ ፊቱን አቀና፥ ");
INSERT INTO amh_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","በፊቱም መልክተኞችን ሰደደ። ሄደውም ሊያሰናዱለት ወደ አንድ ወደ ሳምራውያን መንደር ገቡ፤ ");
INSERT INTO amh_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ፊቱም ወደ ኢየሩሳሌም እንደሚሄድ ስለ ነበረ አልተቀበሉትም። ");
INSERT INTO amh_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ደቀ መዛሙርቱም ያዕቆብና ዮሐንስ አይተው። ጌታ ሆይ፥ ኤልያስ ደግሞ እንዳደረገ እሳት ከሰማይ ወርዶ ያጥፋቸው እንል ዘንድ ትወዳለህን? አሉት። ");
INSERT INTO amh_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","እርሱ ግን ዘወር ብሎ ገሠጻቸውና። ምን ዓይነት መንፈስ እንደ ሆነላችሁ አታውቁም፤ ");
INSERT INTO amh_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","የሰው ልጅ የሰውን ነፍስ ሊያድን እንጂ ሊያጠፋ አልመጣም አለ። ወደ ሌላ መንደርም ሄዱ። ");
INSERT INTO amh_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","እነርሱም በመንገድ ሲሄዱ አንድ ሰው። ጌታ ሆይ፥ ወደ ምትሄድበት ሁሉ እከተልሃለሁ አለው። ");
INSERT INTO amh_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ኢየሱስም። ለቀበሮዎች ጕድጓድ ለሰማይም ወፎች መሳፈሪያ አላቸው፥ ለሰው ልጅ ግን ራሱን የሚያስጠጋበት የለውም አለው። ");
INSERT INTO amh_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ሌላውንም። ተከተለኝ አለው። እርሱ ግን። ጌታ ሆይ፥ አስቀድሜ ልሂድና አባቴን እቀብር ዘንድ ፍቀድልኝ አለ። ");
INSERT INTO amh_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ኢየሱስም። ሙታናቸውን እንዲቀብሩ ሙታንን ተዋቸው፤ አንተስ ሄደህ የእግዚአብሔርን መንግሥት ስበክ አለው። ");
INSERT INTO amh_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ደግሞ ሌላው። ጌታ ሆይ፥ እከተልሃለሁ፤ ነገር ግን አስቀድሜ ከቤቴ ሰዎች እንድሰናበት ፍቀድልኝ አለ። ");
INSERT INTO amh_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ኢየሱስ ግን። ማንም ዕርፍ በእጁ ይዞ ወደ ኋላ የሚመለከት ለእግዚአብሔር መንግሥት የተገባ አይደለም አለው። ");
INSERT INTO amh_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ከዚህም በኋላ ጌታ ሌሎቹን ሰብዓ ሾመ፥ ሁለት ሁለትም አድርጎ እርሱ ሊሄድበት ወዳለው ከተማና ስፍራ ሁሉ በፊቱ ላካቸው። ");
INSERT INTO amh_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","አላቸውም። መከሩስ ብዙ ነው፥ ሠራተኞች ግን ጥቂቶች ናቸው፤ እንግዴህ የመከሩን ጌታ ለመከሩ ሠራተኞች እንዲልክ ለምኑት። ");
INSERT INTO amh_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ሂዱ፤ እነሆ፥ እንደ በጎች በተኵላዎች መካከል እልካችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ኮረጆም ከረጢትም ጫማም አትያዙ፤ በመንገድም ለማንም እጅ አትንሡ። ");
INSERT INTO amh_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ወደምትገቡበት ቤት ሁሉ አስቀድማችሁ። ሰላም ለዚህ ቤት ይሁን በሉ። ");
INSERT INTO amh_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","በዚያም የሰላም ልጅ ቢኖር፥ ሰላማችሁ ያድርበታል፤ አለዚያም ይመለስላችኋል። ");
INSERT INTO amh_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","በዚያም ቤት ከእነርሱ ዘንድ ካለው እየበላችሁና እየጠጣችሁ ተቀመጡ፤ ለሠራተኛ ደመወዙ ይገባዋልና። ከቤት ወደ ቤት አትተላለፉ። ");
INSERT INTO amh_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ወደምትገቡባትም ከተማ ሁሉ ቢቀበሉአችሁ፥ ያቀረቡላችሁን ብሉ፤ ");
INSERT INTO amh_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","በእርስዋም ያሉትን ድውዮችን ፈውሱና። የእግዚአብሔር መንግሥት ወደ እናንተ ቀረበች በሉአቸው። ");
INSERT INTO amh_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ነገር ግን ወደምትገቡባት ከተማ ሁሉ ባይቀበሉአችሁ፥ ወደ አደባባይዋ ወጥታችሁ። ");
INSERT INTO amh_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","ከከተማችሁ የተጣበቀብንን ትቢያ እንኳን እናራግፍላችኋለን፤ የእግዚአብሔር መንግሥት ግን ወደ እናንተ እንደ ቀረበች ይህን እወቁ በሉ። ");
INSERT INTO amh_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","እላችኋለሁ፥ በዚያን ቀን ከዚያች ከተማ ይልቅ ለሰዶም ይቀልላታል። ");
INSERT INTO amh_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ወዮልሽ ኮራዚን፥ ወዮልሽ ቤተ ሳይዳ፤ በእናንተ የተደረገው ተአምራት በጢሮስና በሲዶና ተደርጎ ቢሆን፥ ማቅ ለብሰው በአመድም ተቀምጠው ከብዙ ጊዜ በፊት ንስሐ በገቡ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ነገር ግን በፍርድ ከእናንተ ይልቅ ለጢሮስና ለሲዶና ይቀልላቸዋል። ");
INSERT INTO amh_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","አንቺም ቅፍርናሆም፥ እስከ ሰማይ ከፍ አልሽን? ወደ ሲኦል ትወርጃለሽ። ");
INSERT INTO amh_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","የሚሰማችሁ እኔን ይሰማል፥ እናንተንም የጣለ እኔን ይጥላል፤ እኔንም የጣለ የላከኝን ይጥላል። ");
INSERT INTO amh_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ሰብዓውም በደስታ ተመልሰው። ጌታ ሆይ፥ አጋንንት ስንኳ በስምህ ተገዝተውልናል አሉት። ");
INSERT INTO amh_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","እንዲህም አላቸው ሰይጣንን እንደ መብረቅ ከሰማይ ሲወድቅ አየሁ። ");
INSERT INTO amh_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","እነሆ፥ እባቡንና ጊንጡን ትረግጡ ዘንድ፥ በጠላትም ኃይል ሁሉ ላይ ሥልጣን ሰጥቻችኋለሁ፥ የሚጐዳችሁም ምንም የለም። ");
INSERT INTO amh_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ነገር ግን መናፍስት ስለ ተገዙላችሁ በዚህ ደስ አይበላችሁ፥ ስማችሁ ግን በሰማያት ሰለ ተጻፈ ደስ ይበላችሁ። ");
INSERT INTO amh_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","በዚያን ሰዓት ኢየሱስ በመንፈስ ቅዱስ ሐሤት አደረገና። የሰማይና የምድር ጌታ አባት ሆይ፥ ይህን ከጥበበኞችና ከአስተዋዮች ሰውረህ ለሕፃናት ስለ ገለጥህላቸው አመሰግናለሁ፤ አዎን አባት ሆይ፥ ፈቃድህ በፊትህ እንዲህ ሆኖአልና። ");
INSERT INTO amh_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ሁሉ ከአባቴ ዘንድ ተሰጥቶኛል፥ ወልድንም ማን እንደ ሆነ ከአብ በቀር የሚያውቅ የለም፥ አብንም ማን እንደ ሆነ ከወልድ በቀር ወልድም ሊገልጥለት ከሚፈቅድ በቀር የሚያውቅ የለም አለ። ");
INSERT INTO amh_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ወደ ደቀ መዛሙርቱም ዘወር ብሎ ለብቻቸው። የምታዩትን የሚያዩ ዓይኖች ብፁዓን ናቸው። ");
INSERT INTO amh_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","እላችኋለሁና፥ እናንተ የምታዩትን ብዙዎች ነቢያትና ነገሥታት ሊያዩ ወደዱ አላዩምም፥ የምትሰሙትንም ሊሰሙ ወድደው አልሰሙም አለ። ");
INSERT INTO amh_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","እነሆም፥ አንድ ሕግ አዋቂ ሊፈትነው ተነሥቶ። መምህር ሆይ፥ የዘላለምን ሕይወት እንድወርስ ምን ላድርግ? አለው። ");
INSERT INTO amh_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","እርሱም በሕግ የተጻፈው ምንድር ነው? እንዴትስ ታነባለህ? አለው። ");
INSERT INTO amh_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","እርሱም መልሶ። ጌታ አምላክህን በፍጹም ልብህ በፍጹም ነፍስህም በፍጹም ኃይልህም በፍጹም አሳብህም ውደድ፥ ባልንጀራህንም እንደ ራስህ ውደድ አለው። ");
INSERT INTO amh_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ኢየሱስም። እውነት መለስህ፤ ይህን አድርግ በሕይወትም ትኖራለህ አለው። ");
INSERT INTO amh_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","እርሱ ግን ራሱን ሊያጸድቅ ወድዶ ኢየሱስን። ባልንጀራዬስ ማን ነው? አለው። ");
INSERT INTO amh_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ኢየሱስም መልሶ እንዲህ አለ። አንድ ሰው ከኢየሩሳሌም ወደ ኢያሪኮ ወረደ በወንበዴዎችም እጅ ወደቀ፤ እነርሱም ደግሞ ገፈፉት ደበደቡትም በሕይወትና በሞት መካከልም ትተውት ሄዱ። ");
INSERT INTO amh_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ድንገትም አንድ ካህን በዚያ መንገድ ወረደ አይቶትም ገለል ብሎ አለፈ። ");
INSERT INTO amh_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","እንዲሁም ደግሞ አንድ ሌዋዊ ወደዚያ ስፍራ መጣና አይቶት ገለል ብሎ አለፈ። ");
INSERT INTO amh_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","አንድ ሳምራዊ ግን ሲሄድ ወደ እርሱ መጣ አይቶትም አዘነለት፥ ");
INSERT INTO amh_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ቀርቦም ዘይትና የወይን ጠጅ በቍስሎቹ ላይ አፍስሶ አሰራቸው፥ በራሱ አህያም ላይ አስቀምጦት ወደ እንግዶች ማደርያ ወሰደው ጠበቀውም። ");
INSERT INTO amh_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","በማግሥቱም ሁለት ዲናር አውጥቶ ለባለቤቱ ሰጠና። ጠብቀው፥ ከዚህም በላይ የምትከስረውን ሁሉ እኔ ስመለስ እከፍልሃለሁ አለው። ");
INSERT INTO amh_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","እንግዲህ ከነዚህ ከሦስቱ በወንበዴዎች እጅ ለወደቀው ባልንጀራ የሆነው ማንኛው ይመስልሃል? ");
INSERT INTO amh_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","እርሱም። ምሕረት ያደረገለት አለ። ኢየሱስም። ሂድ አንተም እንዲሁ አድርግ አለው። ");
INSERT INTO amh_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ሲሄዱም እርሱ ወደ አንዲት መንደር ገባ፤ ማርታ የተባለች አንዲት ሴትም በቤትዋ ተቀበለችው። ");
INSERT INTO amh_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ለእርስዋም ማርያም የምትባል እኅት ነበረቻት፥ እርስዋም ደግሞ ቃሉን ልትሰማ በኢየሱስ እግር አጠገብ ተቀምጣ ነበረች። ");
INSERT INTO amh_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ማርታ ግን አገልግሎት ስለ በዛባት ባከነች፤ ቀርባም። ጌታ ሆይ፥ እኔ እንድሠራ እኅቴ ብቻዬን ስትተወኝ አይገድህምን? እንኪያስ እንድታግዘኝ ንገራት አለችው። ");
INSERT INTO amh_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ኢየሱስም መልሶ። ማርታ፥ ማርታ፥ በብዙ ነገር ትጨነቂአለሽ ትታወኪማለሽ፥ ");
INSERT INTO amh_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","የሚያስፈልገው ግን ጥቂት ወይም አንድ ነገር ነው፤ ማርያምም መልካም ዕድልን መርጣለች ከእርስዋም አይወሰድባትም አላት። ");
INSERT INTO amh_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","እርሱም በአንድ ስፍራ ይጸልይ ነበር፥ በጨረሰም ጊዜ ከደቀ መዛሙርቱ አንዱ። ጌታ ሆይ፥ ዮሐንስ ደቀ መዛሙርቱን እንዳስተማረ እንጸልይ ዘንድ አስተምረን አለው። ");
INSERT INTO amh_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","አላቸውም። ስትጸልዩ እንዲህ በሉ። በሰማያት የምትኖር አባታችን ሆይ፤ ስምህ ይቀደስ፤ መንግሥትህ ትምጣ፤ ፈቃድህ በሰማይ እንደ ሆነች እንዲሁ በምድር ትሁን፤ ");
INSERT INTO amh_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","የዕለት እንጀራችንን ዕለት ዕለት ስጠን፤ ");
INSERT INTO amh_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ኃጢአታችንንም ይቅር በለን፥ እኛ ደግሞ የበደሉንን ሁሉ ይቅር ብለናልና፤ ከክፉ አድነን እንጂ ወደ ፈተና አታግባን። ");
INSERT INTO amh_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","እንዲህም አላቸው። ከእናንተ ማናቸውም ወዳጅ ያለው፥ በእኩል ሌሊትስ ወደ እርሱ ሄዶ። ወዳጄ ሆይ፥ ሦስት እንጀራ አበድረኝ፥ ");
INSERT INTO amh_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","አንድ ወዳጄ ከመንገድ ወደ እኔ መጥቶ የማቀርብለት የለኝምና ይላልን? ");
INSERT INTO amh_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ያም ከውስጥ መልሶ። አታድክመኝ፤ አሁን ደጁ ተቈልፎአል ልጆቼም ከእኔ ጋር በአልጋ ላይ አሉ፤ ተነሥቼ ልሰጥህ አልችልም ይላልን? ");
INSERT INTO amh_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","እላችኋለሁ፥ ወዳጅ ስለ ሆነ ተነሥቶ ባይሰጠው እንኳ፥ ስለ ንዝነዛው ተነስቶ የሚፈልገውን ሁሉ ይሰጠዋል። ");
INSERT INTO amh_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","እኔም እላችኋለሁ። ለምኑ፥ ይሰጣችሁማል፤ ፈልጉ፥ ታገኙማላችሁ፤ መዝጊያን አንኳኩ፥ ይከፍትላችሁማል። ");
INSERT INTO amh_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","የሚለምን ሁሉ ይቀበላልና፥ የሚፈልግም ያገኛል፥ መዝጊያውንም ለሚያንኳኳው ይከፈትለታል። ");
INSERT INTO amh_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","አባት ከሆናችሁ ከእናንተ ከማንኛችሁም ልጁ እንጀራ ቢለምነው፥ እርሱም ድንጋይ ይሰጠዋልን? ዓሣ ደግሞ ቢለምነው በዓሣ ፋንታ እባብ ይሰጠዋልን? ");
INSERT INTO amh_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ወይስ እንቍላል ቢለምነው ጊንጥ ይሰጠዋልን? ");
INSERT INTO amh_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","እንኪያስ እናንተ ክፉዎች ስትሆኑ ለልጆቻችሁ መልካም ስጦታ መስጠት ካወቃችሁ፥ በሰማይ ያለው አባት ለሚለምኑት እንዴት አብልጦ መንፈስ ቅዱስን ይሰጣቸው? ");
INSERT INTO amh_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ዲዳውንም ጋኔን ያወጣ ነበር፤ ጋኔኑም ከወጣ በኋላ ዲዳው ተናገረ ሕዝቡም ተደነቁ፤ ");
INSERT INTO amh_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ነገር ግን ከእነርሱ አንዳንዱ። በብዔል ዜቡል በአጋንንት አለቃ አጋንንትን ያወጣል አሉ። ");
INSERT INTO amh_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ሌሎችም ሲፈትኑት ከሰማይ ምልክት ከእርሱ ይፈልጉ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","እርሱ ግን አሳባቸውን አውቆ እንዲህ አላቸው። እርስ በርስዋ የምትለያይ መንግሥት ሁሉ ትጠፋለች፤ ቤትም በቤት ላይ ይወድቃል። ");
INSERT INTO amh_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","እኔ አጋንንትን በብዔል ዜቡል እንዳወጣ ትላላችሁና ሰይጣን ደግሞ እርስ በርሱ ከተለያየ መንግሥቱ እንዴት ትቆማለች? ");
INSERT INTO amh_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","እኔስ በብዔል ዜቡል አጋንንትን የማወጣ ከሆንሁ፥ ልጆቻችሁ በማን ያወጡአቸዋል? ስለዚህ እነርሱ ፈራጆች ይሆኑባችኋል። ");
INSERT INTO amh_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","እኔ ግን በእግዚአብሔር ጣት አጋንንትን የማወጣ ከሆንሁ፥ እንግዲህ የእግዚአብሔር መንግሥት ወደ እናንተ ደርሳለች። ");
INSERT INTO amh_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ኃይለኛ ሰው ጋሻና ጦር ይዞ የራሱን ግቢ ቢጠብቅ፥ ያለው ገንዘቡ በሰላም ይሆናል፤ ");
INSERT INTO amh_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ከእርሱ ይልቅ የሚበረታ መጥቶ ሲያሸንፈው ግን፥ ታምኖበት የነበረውን ጋሻና ጦር ይወስድበታል ምርኮውንም ያካፍላል። ");
INSERT INTO amh_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ከእኔ ጋር ያልሆነ ይቃወመኛል፥ ከእኔ ጋርም የማያከማች ይበትናል። ");
INSERT INTO amh_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","ርኵስ መንፈስ ከሰው በወጣ ጊዜ ዕረፍትን እየፈለገ ውኃ በሌለበት ቦታ ያልፋል፤ ባያገኝም። ወደ ወጣሁበት ቤቴ እመለሳለሁ ይላል፤ ");
INSERT INTO amh_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ሲመጣም ተጠርጎ አጊጦም ያገኘዋል። ");
INSERT INTO amh_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ከዚያ ወዲያ ይሄድና ከእርሱ የከፉትን ሌሎችን ሰባት አጋንንት ከእርሱ ጋር ይይዛል፥ ገብተውም በዚያ ይኖራሉ፤ ለዚያም ሰው ከፊተኛው ይልቅ የኋለኛው ይብስበታል። ");
INSERT INTO amh_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ይህንም ሲናገር፥ ከሕዝቡ አንዲት ሴት ድምፅዋን ከፍ አድርጋ። የተሸከመችህ ማኅፀንና የጠባሃቸው ጡቶች ብፁዓን ናቸው አለችው። ");
INSERT INTO amh_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","እርሱ ግን። አዎን፥ ብፁዓንስ የእግዚአብሔርን ቃል ሰምተው የሚጠብቁት ናቸው አለ። ");
INSERT INTO amh_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ብዙ ሕዝብም በተሰበሰቡ ጊዜ እንዲህ ይል ጀመር። ይህ ትውልድ ክፉ ነው፤ ምልክት ይፈልጋል፥ ከነቢዩም ከዮናስ ምልክት በቀር ምልክት አይሰጠውም። ");
INSERT INTO amh_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ዮናስ ለነነዌ ሰዎች ምልክት እንደ ሆናቸው፥ እንዲሁ ደግሞ የሰው ልጅ ለዚህ ትውልድ ምልክት ይሆናል። ");
INSERT INTO amh_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ንግሥተ አዜብ በፍርድ ከዚህ ትውልድ ሰዎች ጋር ተነሥታ ትፈርድባቸዋለች፤ የሰሎሞንን ጥበብ ለመስማት ከምድር ዳር መጥታለችና፥ እነሆም፥ ከሰሎሞን የሚበልጥ ከዚህ አለ። ");
INSERT INTO amh_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","የነነዌ ሰዎች በፍርድ ከዚህ ትውልድ ጋር ተነሥተው ይፈርዱበታል፤ በዮናስ ስብከት ንስሐ ገብተዋልና፥ እነሆም፥ ከዮናስ የሚበልጥ ከዚህ አለ። ");
INSERT INTO amh_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","መብራትንም አብርቶ በስውር ወይም በእንቅብ በታች የሚያኖረው የለም፥ የሚገቡ ሰዎች ብርሃኑን እንዲያዩ በመቅረዝ ላይ ያኖረዋል እንጂ። ");
INSERT INTO amh_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","የሰውነትህ መብራት ዓይንህ ናት። ዓይንህ ጤናማ በሆነች ጊዜ ሰውነትህ ሁሉ ደግሞ ብሩህ ይሆናል። ዓይንህ ታማሚ በሆነች ጊዜ ግን ሰውነትህ ደግሞ የጨለመ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","እንግዲህ በአንተ ያለው ብርሃን ጨለማ እንዳይሆን ተመልከት። ");
INSERT INTO amh_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","እንግዲህ ሰውነትህ ሁሉ የጨለማ ቍራጭ የሌለበት ብሩህ ቢሆን፥ መብራት በደመቀ ብርሃን እንደሚያበራልህ በጭራሽ ብሩህ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ይህንንም ሲናገር አንድ ፈሪሳዊ ከእርሱ ጋር ምሳ ይበላ ዘንድ ለመነው ገብቶም ተቀመጠ። ");
INSERT INTO amh_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ከምሳም በፊት አስቀድሞ እንዳልታጠበ ባየው ጊዜ ፈሪሳዊው ተደነቀ። ");
INSERT INTO amh_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ጌታም እንዲህ አለው። አሁን እናንተ ፈሪሳውያን የጽዋውንና የወጭቱን ውጭ ታጠራላችሁ፥ ውስጣችሁ ግን ቅሚያና ክፋት ሞልቶበታል ");
INSERT INTO amh_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","እናንት ደንቆሮዎች፥ የውጭውን የፈጠረ የውስጡን ደግሞ አልፈጠረምን? ");
INSERT INTO amh_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ነገር ግን በውስጥ ያለውን ምጽዋት አድርጋችሁ ስጡ፥ እነሆም፥ ሁሉ ንጹሕ ይሆንላችኋል። ");
INSERT INTO amh_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ነገር ግን እናንተ ፈሪሳውያን፥ ከአዝሙድና ከጤና አዳም ከአትክልትም ሁሉ አሥራት ስለምታወጡ፥ ፍርድንና እግዚአብሔርን መውደድ ስለምትተላለፉ፥ ወዮላችሁ፤ ነገር ግን ሌላውን ሳትተዉ ይህን ልታደርጉት ይገባችሁ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","እናንተ ፈሪሳውያን፥ በምኵራብ የከበሬታ ወንበር በገበያም ሰላምታ ስለምትወዱ፥ ወዮላችሁ። ");
INSERT INTO amh_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","እናንተ ግብዞች ጻፎችና ፈሪሳውያን፥ ሰዎች ሳያውቁ በላዩ የሚሄዱበት የተሰወረ መቃብር ስለምትመስሉ፥ ወዮላችሁ። ");
INSERT INTO amh_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ከሕግ አዋቂዎችም አንዱ መልሶ። መምህር ሆይ፥ ይህን ማለትህ እኛን ደግሞ መስደብህ ነው አለው። ");
INSERT INTO amh_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","እርሱም እንዲህ አለ። እናንተ ደግሞ ሕግ አዋቂዎች፥ አስቸጋሪ ሸክም ለሰዎች ስለምታሸክሙ፥ ራሳችሁም በአንዲት ጣታችሁ ስንኳ ሸክሙን ስለማትነኩት፥ ወዮላችሁ። ");
INSERT INTO amh_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","አባቶቻችሁ የገደሉአቸውን የነቢያትን መቃብር ስለምትሠሩ፥ ወዮላችሁ። ");
INSERT INTO amh_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","እንግዲህ ለአባቶቻችሁ ሥራ ትመሰክራላችሁ ትስማማላችሁም፤ እነርሱ ገድለዋቸዋልና፥ እናንተም መቃብራቸውን ትሠራላችሁ። ");
INSERT INTO amh_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ስለዚህ ደግሞ የእግዚአብሔር ጥበብ እንዲህ አለች። ወደ እነርሱ ነቢያትንና ሐዋርያትን እልካለሁ፥ ከእነርሱም ይገድላሉ ያሳድዱማል፥ ");
INSERT INTO amh_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ዓለም ከተፈጠረ ጀምሮ የፈሰሰው የነቢያት ሁሉ ደም፥ ");
INSERT INTO amh_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ከአቤል ደም ጀምሮ በመሠዊያውና በቤተ መቅደስ መካከል እስከ ጠፋው እስከ ዘካርያስ ደም ድረስ፥ ከዚህ ትውልድ እንዲፈለግ አዎን እላችኋለሁ፥ ከዚህ ትውልድ ይፈለጋል። ");
INSERT INTO amh_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","54","እናንተ ሕግ አዋቂዎች፥ የእውቀትን መክፈቻ ስለ ወሰዳችሁ፥ ወዮላችሁ ራሳችሁ አልገባችሁም የሚገቡትንም ከለከላችሁ። ");
INSERT INTO amh_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","በዚያን ጊዜ የሕዝብ አእላፍ እርስ በርሳቸው እስኪረጋገጡ ድረስ ተሰብስበው ሳሉ፥ ለደቀ መዛሙርቱ እንዲህ ይል ጀመር። አስቀድማችሁ ከፈሪሳውያን እርሾ ተጠበቁ፥ እርሱም ግብዝነት ነው። ");
INSERT INTO amh_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ነገር ግን የማይገለጥ የተከደነ፥ የማይታወቅም የተሰወረ ምንም የለም። ");
INSERT INTO amh_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ስለዚህ በጨለማ የምትናገሩት ሁሉ በብርሃን ይሰማል፥ በእልፍኝም ውስጥ በጆሮ የምትናገሩት በሰገነት ላይ ይሰበካል። ");
INSERT INTO amh_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ለእናንተም ለወዳጆቼ እላችኋለሁ፥ ሥጋን የሚገድሉትን በኋላም አንድ ስንኳ የሚበልጥ ሊያደርጉ የማይችሉትን አትፍሩ። ");
INSERT INTO amh_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","እኔ ግን የምትፈሩትን አሳያችኋለሁ፤ ከገደለ በኋላ ወደ ገሃነም ለመጣል ሥልጣን ያለውን ፍሩ። አዎን እላችኋለሁ፥ እርሱን ፍሩ። ");
INSERT INTO amh_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","አምስት ድንቢጦች በአሥር ሳንቲም ይሸጡ የለምን? ከእነርሱም አንዲቱ ስንኳ በእግዚአብሔር ፊት አትረሳም። ");
INSERT INTO amh_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ነገር ግን የእናንተ የራሳችሁ ጠጕር ሁሉ እንኳ የተቈጠረ ነው፤ እንግዲያስ አትፍሩ ከብዙ ድንቢጦች ትበልጣላችሁ። ");
INSERT INTO amh_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","እላችሁማለሁ፥ በሰው ፊት የሚመሰክርልኝ ሁሉ፥ የሰው ልጅ ደግሞ በእግዚአብሔር መላእክት ፊት ይመሰክርለታል፤ ");
INSERT INTO amh_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","በሰውም ፊት የሚክደኝ በእግዚአብሔር መላእክት ፊት ይካዳል። ");
INSERT INTO amh_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","በሰው ልጅም ላይ ቃል የሚናገር ሁሉ ይሰረይለታል፤ መንፈስ ቅዱስን የሚሰድብ ግን አይሰረይለትም። ");
INSERT INTO amh_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ወደ ምኵራቦችና ወደ መኳንንቶችም ወደ ገዢዎችም ሲጐትቱአችሁ፥ እንዴት ወይም ምን እንድትመልሱ ወይም እንድትናገሩ አትጨነቁ፤ ");
INSERT INTO amh_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","መንፈስ ቅዱስ በዚያች ሰዓት ልትናገሩ የሚገባችሁን ያስተምራችኋልና። ");
INSERT INTO amh_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ከሕዝቡም አንድ ሰው። መምህር ሆይ፥ ርስቱን ከእኔ ጋር እንዲካፈል ለወንድሜ ንገረው አለው። ");
INSERT INTO amh_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","እርሱም። አንተ ሰው፥ ፈራጅና አካፋይ በላያችሁ አንድሆን ማን ሾመኝ? አለው። ");
INSERT INTO amh_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","የሰው ሕይወት በገንዘቡ ብዛት አይደለምና ተጠንቀቁ፥ ከመጐምጀትም ሁሉ ተጠበቁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ምሳሌም ነገራቸው እንዲህ ሲል። አንድ ባለ ጠጋ ሰው እርሻ እጅግ ፍሬያም ሆነችለት። ");
INSERT INTO amh_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","እርሱም። ፍሬዬን የማከማችበት ስፍራ አጥቻለሁና ምን ላድርግ? ብሎ በልቡ አሰበ። ");
INSERT INTO amh_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","እንዲህ አደርጋለሁ፤ ጐተራዬን አፍርሼ ሌላ የሚበልጥ እሠራለሁ፥ በዚያም ፍሬዬንና በረከቴን ሁሉ አከማቻለሁ፤ ");
INSERT INTO amh_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ነፍሴንም። አንቺ ነፍሴ፥ ለብዙ ዘመን የሚቀር ብዙ በረከት አለሽ፤ ዕረፊ፥ ብዪ፥ ጠጪ፥ ደስ ይበልሽ እላታለሁ አለ። ");
INSERT INTO amh_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","እግዚአብሔር ግን። አንተ ሰነፍ፥ በዚች ሌሊት ነፍስህን ከአንተ ሊወስዱአት ይፈልጓታል፤ ይህስ የሰበሰብኸው ለማን ይሆናል? አለው። ");
INSERT INTO amh_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ለራሱ ገንዘብ የሚያከማች፥ በእግዚአብሔር ዘንድም ባለ ጠጋ ያልሆነ እንዲህ ነው። ");
INSERT INTO amh_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ለደቀ መዛሙርቱም እንዲህ አለ። ስለዚህ እላችኋለሁ፥ ለነፍሳችሁ በምትበሉት ወይም ለሰውነታችሁ በምትለብሱት አትጨነቁ። ");
INSERT INTO amh_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ነፍስ ከመብል ሰውነትም ከልብስ ይበልጣልና። ");
INSERT INTO amh_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ቍራዎችን ተመልከቱ፤ አይዘሩም አያጭዱምም፥ ዕቃ ቤትም ወይም ጎተራ የላቸውም፥ እግዚአብሔርም ይመግባቸዋል፤ እናንተስ ከወፎች እንዴት ትበልጣላችሁ? ");
INSERT INTO amh_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ከእናንተ ተጨንቆ በቁመቱ ላይ አንድ ክንድ መጨመር የሚችል ማን ነው? ");
INSERT INTO amh_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","እንግዲህ ትንሹን ነገር ስንኳ የማትችሉ ከሆናችሁ፥ ስለ ምን በሌላ ትጨነቃላችሁ? ");
INSERT INTO amh_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","አበቦችን እንዴት እንዲያድጉ ተመልከቱ፤ አይደክሙም አይፈትሉምም፤ ነገር ግን እላችኋለሁ፥ ሰሎሞንስ እንኳ በክብሩ ሁሉ ከእነዚህ እንደ አንዲቱ አለበሰም። ");
INSERT INTO amh_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","እግዚአብሔር ግን ዛሬ ያለውን ነገም ወደ እቶን የሚጣለውን በሜዳ የሆነውን ሣር እንዲህ የሚያለብሰው ከሆነ፥ እናንተ እምነት የጐደላችሁ፥ እናንተንማ ይልቁን እንዴት? ");
INSERT INTO amh_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","እናንተም የምትበሉትን የምትጠጡትንም አትፈልጉ፥ አታወላውሉም፤ ");
INSERT INTO amh_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ይህንስ ሁሉ በዓለም ያሉ አሕዛብ ይፈልጉታልና፤ የእናንተም አባት ይህ እንዲያስፈልጋችሁ ያውቃል። ");
INSERT INTO amh_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ዳሩ ግን መንግሥቱን ፈልጉ ይህም ሁሉ ይጨመርላችኋል። ");
INSERT INTO amh_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","አንተ ታናሽ መንጋ፥ መንግሥትን ሊሰጣችሁ የአባታችሁ በጎ ፈቃድ ነውና አትፍሩ። ");
INSERT INTO amh_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ያላችሁን ሽጡ ምጽዋትም ስጡ፤ ሌባ በማይቀርብበት ብልም በማያጠፋበት በሰማያት የማያልቅ መዝገብ የሚሆኑትን የማያረጁትንም ኮረጆዎች ለራሳችሁ አድርጉ፤ ");
INSERT INTO amh_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","መዝገባችሁ ባለበት ልባችሁ ደግሞ በዚያ ይሆናልና። ");
INSERT INTO amh_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ወገባችሁ የታጠቀ መብራታችሁም የበራ ይሁን፤ ");
INSERT INTO amh_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","እናንተም ጌታቸው መጥቶ ደጁን ሲያንኳኳ ወዲያው እንዲከፍቱለት ከሰርግ እስኪመለስ ድረስ የሚጠብቁ ሰዎችን ምሰሉ ");
INSERT INTO amh_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ጌታቸው በመጣ ጊዜ ሲተጉ የሚያገኛቸው እነዚያ ባሪያዎች ብፁዓን ናቸው፤ እውነት እላችኋለሁ፥ ታጥቆ በማዕድ ያስቀምጣቸዋል ቀርቦም ያገለግላቸዋል። ");
INSERT INTO amh_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ከሌሊቱም በሁለተኛው ወይም በሦስተኛው ክፍል መጥቶ እንዲሁ ቢያገኛቸው፥ እነዚያ ባሪያዎች ብፁዓን ናቸው። ");
INSERT INTO amh_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ይህን ግን እወቁ ባለቤት በምን ሰዓት ሌባ እንዲመጣ ቢያውቅ ኖሮ፥ በነቃ፥ ቤቱም እንዲቆፈር ባልፈቀደም ነበር። ");
INSERT INTO amh_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","እናንተ ደግሞ ተዘጋጅታችሁ ኑሩ፥ የሰው ልጅ በማታስቡበት ሰዓት ይመጣልና። ");
INSERT INTO amh_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ጴጥሮስም። ጌታ ሆይ፥ ይህን ምሳሌ ለእኛ ወይስ ደግሞ ለሁሉ ትናገራለህን? አለው። ");
INSERT INTO amh_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ጌታም አለ። እንኪያስ ምግባቸውን በጊዜው ይሰጣቸው ዘንድ ጌታው በቤተ ሰዎቹ ላይ የሚሾመው ታማኝና ልባም መጋቢ ማን ነው? ");
INSERT INTO amh_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ጌታው መጥቶ እንዲህ ሲያደርግ የሚያገኘው ያ ባሪያ ብፁዕ ነው። ");
INSERT INTO amh_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","እውነት እላችኋለሁ፥ ባለው ሁሉ ላይ ይሾመዋል። ");
INSERT INTO amh_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ያ ባሪያ ግን። ጌታዬ እስኪመጣ ይዘገያል ብሎ በልቡ ቢያስብ ሎሌዎችንና ገረዶችንም ይመታ ይበላም ይጠጣም ይሰክርም ዘንድ ቢጀምር፥ ");
INSERT INTO amh_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","የዚያ ባሪያ ጌታ ባልጠበቃት ቀን ባላወቃትም ሰዓት ይመጣል፥ ከሁለትም ይሰነጥቀዋል እድሉንም ከማይታመኑ ጋር ያደርጋል። ");
INSERT INTO amh_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","የጌታውንም ፈቃድ አውቆ ያልተዘጋጀ እንደ ፈቃዱም ያላደረገ ያ ባሪያ እጅግ ይገረፋል፤ ");
INSERT INTO amh_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ያላወቀ ግን መገረፍ የሚገባውንም ያደረገ ጥቂት ይገረፋል። ብዙም ከተሰጠው ሰው ሁሉ ከእርሱ ብዙ ይፈለግበታል፥ ብዙ አደራም ከተሰጠው ከእርሱ አብዝተው ይሹበታል። ");
INSERT INTO amh_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","በምድር ላይ እሳት ልጥል መጣሁ፥ አሁንም የነደደ ከሆነ ዘንድ ምን እፈልጋለሁ? ");
INSERT INTO amh_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ነገር ግን የምጠመቃት ጥምቀት አለችኝ፥ እስክትፈጸምም ድረስ እንዴት እጨነቃለሁ? ");
INSERT INTO amh_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","በምድር ላይ ሰላምንም ለመስጠት የመጣሁ ይመስላችኋልን? እላችኋለሁ፥ አይደለም፥ መለያየትን እንጂ። ");
INSERT INTO amh_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ከአሁን ጀምሮ በአንዲት ቤት አምስት ሰዎች ይኖራሉና፤ ሦስቱም በሁለቱ ላይ ሁለቱም በሦስቱ ላይ ተነሥተው ይለያያሉ። ");
INSERT INTO amh_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","አባት በልጁ ላይ ልጅም በአባቱ ላይ፥ እናት በልጅዋ ላይ ልጅዋም በእናትዋ ላይ፥ አማት በምራትዋ ላይ ምራትም በአማትዋ ላይ ተነሥተው ይለያያሉ። ");
INSERT INTO amh_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ደግሞም ሕዝቡን እንዲህ አለ። ደመና ከምዕራብ ሲወጣ ባያችሁ ጊዜ፥ ወዲያው። ዝናብ ይመጣል ትላላችሁ፥ እንዲሁም ይሆናል፤ ");
INSERT INTO amh_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","በአዜብም ነፋስ ሲነፍስ። ትኩሳት ይሆናል ትላላችሁ፥ ይሆንማል። ");
INSERT INTO amh_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","እናንት ግብዞች፥ የምድሩንና የሰማዩን ፊት ልትመረምሩ ታውቃላችሁ፥ ነገር ግን ይህን ዘመን የማትመረምሩ እንዴት ነው? ");
INSERT INTO amh_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ራሳችሁ ደግሞ ጽድቅን የማትፈርዱ ስለ ምን ነው? ");
INSERT INTO amh_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ከባላጋራህ ጋር ወደ ሹም ብትሄድ፥ ወደ ዳኛ እንዳይጐትትህ ዳኛውም ለሎሌው አሳልፎ እንዳይሰጥህ ሎሌውም በወኅኒ እንዳይጥልህ፥ ገና በመንገድ ሳለህ ከባላጋራህ እንድትታረቅ ትጋ። ");
INSERT INTO amh_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","እልሃለሁ፥ የመጨረሻዋን ግማሽ ሳንቲም እስክትከፍል ድረስ ከዚያ ከቶ አትወጣም። ");
INSERT INTO amh_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","በዚያን ጊዜም ሰዎች መጥተው ጲላጦስ ደማቸውን ከመሥዋዕታቸው ጋር ስላደባለቀው ስለ ገሊላ ሰዎች አወሩለት። ");
INSERT INTO amh_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ኢየሱስም መልሶ እንዲህ አላቸው። እነዚህ የገሊላ ሰዎች ይህ ስለ ደረሰባቸው ከገሊላ ሰዎች ሁሉ ይልቅ ኃጢአተኞች የሆኑ ይመስሉአችኋልን? ");
INSERT INTO amh_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","እላችኋለሁ፥ አይደለም፤ ነገር ግን ንስሐ ባትገቡ ሁላችሁ እንዲሁ ትጠፋላችሁ። ");
INSERT INTO amh_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ወይስ በሰሌሆም ግንቡ የወደቀባቸውና የገደላቸው እነዚያ አሥራ ስምንት ሰዎች በኢየሩሳሌም ከሚኖሩት ሁሉ ይልቅ በደለኞች ይመስሉአችኋልን? አይደለም፥ እላችኋለሁ፤ ");
INSERT INTO amh_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ነገር ግን ንስሐ ባትገቡ ሁላችሁ እንደዚሁ ትጠፋላችሁ። ");
INSERT INTO amh_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ይህንም ምሳሌ አለ። ለአንድ ሰው በወይኑ አትክልት የተተከለች በለስ ነበረችው፥ ፍሬም ሊፈልግባት መጥቶ ምንም አላገኘም። ");
INSERT INTO amh_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","የወይን አትክልት ሠራተኛውንም። እነሆ፥ ከዚህች በለስ ፍሬ ልፈልግ ሦስት ዓመት እየመጣሁ ምንም አላገኘሁም፤ ቍረጣት፤ ስለ ምን ደግሞ መሬቱን ታጐሳቍላለች? አለው። ");
INSERT INTO amh_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","እርሱ ግን መልሶ። ጌታ ሆይ፥ ዙሪያዋን እስክኰተኵትላትና ፋንድያ እስካፈስላት ድረስ በዚች ዓመት ደግሞ ተዋት። ");
INSERT INTO amh_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ወደ ፊትም ብታፈራ፥ ደኅና ነው፤ ያለዚያ ግን ትቈርጣታለህ አለው። ");
INSERT INTO amh_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","በሰንበትም በአንድ ምኵራብ ያስተምር ነበር። ");
INSERT INTO amh_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","እነሆም፥ ከአሥራ ስምንት ዓመት ጀምሮ የድካም መንፈስ ያደረባት ሴት ነበረች፥ እርስዋም ጐባጣ ነበረች ቀንታም ልትቆም ከቶ አልተቻላትም። ");
INSERT INTO amh_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ኢየሱስም ባያት ጊዜ ጠራትና። አንቺ ሴት፥ ከድካምሽ ተፈትተሻል አላት፥ እጁንም ጫነባት፤ ");
INSERT INTO amh_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ያን ጊዜም ቀጥ አለች፥ እግዚአብሔርንም አመሰገነች። ");
INSERT INTO amh_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","የምኵራብ አለቃ ግን ኢየሱስ በሰንበት ስለ ፈወሰ ተቈጥቶ መለሰና ሕዝቡን። ሊሠራባቸው የሚገባ ስድስት ቀኖች አሉ፤ እንግዲህ በእነርሱ መጥታችሁ ተፈወሱ እንጂ በሰንበት አይደለም አለ። ");
INSERT INTO amh_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ጌታም መልሶ። እናንተ ግብዞች፥ ከእናንተ እያንዳንዱ በሰንበት በሬውን ወይስ አህያውን ከግርግሙ ፈትቶ ውኃ ሊያጠጣው ይወስደው የለምን? ");
INSERT INTO amh_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ይህችም የአብርሃም ልጅ ሆና ከአሥራ ስምንት ዓመት ጀምሮ ሰይጣን ያሰራት በሰንበት ቀን ከዚህ እስራት ልትፈታ አይገባምን? አለው። ");
INSERT INTO amh_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ይህንም ሲናገር ሳለ የተቃወሙት ሁሉ አፈሩ፤ ከእርሱም በተደረገው ድንቅ ሁሉ ሕዝቡ ሁሉ ደስ አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","እርሱም። የእግዚአብሔር መንግሥት ምን ትመስላለች፥ በምንስ አስመስላታለሁ? ");
INSERT INTO amh_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ሰው ወስዶ በአትክልቱ የጣላትን የሰናፍጭ ቅንጣት ትመስላለች፤ አደገችም ታላቅ ዛፍም ሆነች፥ የሰማይ ወፎችም በቅርንጫፎችዋ ሰፈሩ አለ። ");
INSERT INTO amh_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ደግሞም፥ የእግዚአብሔርን መንግሥት በምን አስመስላታለሁ? ");
INSERT INTO amh_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ሴት ወስዳ ሁሉ እስኪቦካ ድረስ በሦስት መስፈሪያ ዱቄት የሸሸገችውን እርሾ ትመስላለች አለ። ");
INSERT INTO amh_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ወደ ኢየሩሳሌም ሲሄድ ከተማዎችንና መንደሮችን እያስተማረ ያልፍ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","አንድ ሰውም። ጌታ ሆይ፥ የሚድኑ ጥቂቶች ናቸውን? አለው። እርሱም እንዲህ አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","በጠበበው በር ለመግባት ተጋደሉ፤ እላችኋለሁና፥ ብዙዎች ሊገቡ ይፈልጋሉ አይችሉምም። ");
INSERT INTO amh_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ባለቤቱ ተነሥቶ በሩን ከቈለፈ በኋላ፥ እናንተ በውጭ ቆማችሁ። ጌታ ሆይ፥ ጌታ ሆይ፥ ክፈትልን እያላችሁ በሩን ልታንኳኩ ትጀምራላችሁ እርሱም መልሶ። ከወዴት እንደ ሆናችሁ አላውቃችሁም ይላችኋል። ");
INSERT INTO amh_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","በዚያን ጊዜም። በፊትህ በላን ጠጣንም በአደባባያችንም አስተማርህ ልትሉ ትጀምራላችሁ፤ ");
INSERT INTO amh_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","እርሱም። እላችኋለሁ፥ ከወዴት እንደ ሆናችሁ አላውቃችሁም፤ ሁላችሁ ዓመፀኞች፥ ከእኔ ራቁ ይላችኋል። ");
INSERT INTO amh_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","አብርሃምንና ይስሐቅን ያዕቆብንም ነቢያትንም ሁሉ በእግዚአብሔር መንግሥት ባያችሁ ጊዜ፥ እናንተ ግን ወደ ውጭ ተጥላችሁ ስትቀሩ፥ በዚያ ልቅሶና ጥርስ ማፋጨት ይሆናል። ");
INSERT INTO amh_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ከምሥራቅና ከምዕራብም ከሰሜንና ከደቡብም ይመጣሉ፥ በእግዚአብሔርም መንግሥት በማዕድ ይቀመጣሉ። ");
INSERT INTO amh_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","እነሆም፥ ከኋለኞች ፊተኞች የሚሆኑ አሉ፥ ከፊተኞችም ኋለኞች የሚሆኑ አሉ። ");
INSERT INTO amh_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","በዚያን ሰዓት ከፈሪሳውያን አንዳንዱ ቀርበው። ሄሮድስ ሊገድልህ ይወዳልና ከዚህ ውጣና ሂድ አሉት። ");
INSERT INTO amh_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","እንዲህም አላቸው። ሄዳችሁ ለዚያች ቀበሮ። እነሆ፥ ዛሬና ነገ አጋንንትን አወጣለሁ በሽተኞችንም እፈውሳለሁ፥ በሦስተኛውም ቀን እፈጸማለሁ በሉአት። ");
INSERT INTO amh_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ዳሩ ግን ነቢይ ከኢየሩሳሌም ውጭ ይጠፋ ዘንድ አይገባውምና ዛሬና ነገ ከነገ በስቲያም ልሄድ ያስፈልገኛል። ");
INSERT INTO amh_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ኢየሩሳሌም፥ ኢየሩሳሌም፥ ነቢያትን የምትገድል ወደ እርስዋ የተላኩትንም የምትወግር፥ ዶሮ ጫጩቶችዋን በክንፎችዋ በታች እንደምትሰበስብ ልጆችሽን እሰበስብ ዘንድ ስንት ጊዜ ወደድሁ፥ እናንተም አልወደዳችሁም። ");
INSERT INTO amh_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","እነሆ፥ ቤታችሁ የተፈታ ሆኖ ይቀርላችኋል። እላችኋለሁም፥ በጌታ ስም የሚመጣ የተባረከ ነው እስክትሉ ድረስ ከእንግዲህ ወዲህ አታዩኝም። ");
INSERT INTO amh_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","በሰንበትም ከፈሪሳውያን አለቆች ወደ አንዱ ቤት እንጀራ ሊበላ በገባ ጊዜ እነርሱ ይጠባበቁት ነበር። ");
INSERT INTO amh_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","እነሆም፥ ሆዱ የተነፋ ሰው በፊቱ ነበረ። ");
INSERT INTO amh_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ኢየሱስም መልሶ። በሰንበት መፈወስ ተፈቅዶአልን ወይስ አልተፈቀደም? ብሎ ለሕግ አዋቂዎችና ለፈሪሳውያን ተናገረ። ");
INSERT INTO amh_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","እነርሱ ግን ዝም አሉ። ይዞም ፈወሰውና አሰናበተው። ");
INSERT INTO amh_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ከእናንተ አህያው ወይስ በሬው በጕድጓድ ቢወድቅ በሰንበት ወዲያው የማያወጣው ማን ነው? አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ስለዚህ ነገርም ሊመልሱለት አልተቻላቸውም። ");
INSERT INTO amh_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","የታደሙትንም የከበሬታ ስፍራ እንደ መረጡ ተመልክቶ ምሳሌ ነገራቸው እንዲህ ሲል። ");
INSERT INTO amh_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ማንም ለሰርግ ቢጠራህ በከበሬታ ስፍራ አትቀመጥ፤ ምናልባት ከአንተ ይልቅ የከበረ ተጠርቶ ይሆናልና አንተን እርሱንም የጠራ መጥቶ። ");
INSERT INTO amh_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ለዚህ ስፍራ ተውለት ይልሃል፥ በዚያን ጊዜም እያፈርህ በዝቅተኛው ስፍራ ልትሆን ትጀምራለህ። ");
INSERT INTO amh_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ነገር ግን በተጠራህ ጊዜ፥ የጠራህ መጥቶ። ወዳጄ ሆይ፥ ወደ ላይ ውጣ እንዲልህ፥ ሄደህ በዝቅተኛው ስፍራ ተቀመጥ፤ ያን ጊዜም ከአንተ ጋር በተቀመጡት ሁሉ ፊት ክብር ይሆንልሃል። ");
INSERT INTO amh_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ራሱን ከፍ የሚያደርግ ሁሉ ይዋረዳልና፥ ራሱንም የሚያዋርድ ከፍ ይላል። ");
INSERT INTO amh_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","የጠራውንም ደግሞ እንዲህ አለው። ምሳ ወይም እራት ባደረግህ ጊዜ፥ እነርሱ ደግሞ በተራቸው ምናልባት እንዳይጠሩህ ብድራትም እንዳይመልሱልህ፥ ወዳጆችህንና ወንድሞችህን ዘመዶችህንም ባለ ጠጎች ጎረቤቶችህንም አትጥራ። ");
INSERT INTO amh_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ነገር ግን ግብዣ ባደረግህ ጊዜ ድሆችንና ጕንድሾችን አንካሶችንም ዕውሮችንም ጥራ፤ ");
INSERT INTO amh_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","የሚመልሱት ብድራት የላቸውምና ብፁዕ ትሆናለህ፤ በጻድቃን ትንሣኤ ይመለስልሃልና። ");
INSERT INTO amh_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ከተቀመጡትም አንዱ ይህን ሰምቶ። በእግዚአብሔር መንግሥት እንጀራ የሚበላ ብፁዕ ነው አለው። ");
INSERT INTO amh_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","እርሱ ግን እንዲህ አለው። አንድ ሰው ታላቅ እራት አድርጎ ብዙዎችን ጠራ፤ ");
INSERT INTO amh_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","በእራትም ሰዓት የታደሙትን። አሁን ተዘጋጅቶአልና ኑ እንዲላቸው ባሪያውን ላከ። ");
INSERT INTO amh_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ሁላቸውም በአንድነት ያመካኙ ጀመር። የፊተኛው። መሬት ገዝቼአለሁ ወጥቼም ላየው በግድ ያስፈልገኛል፤ ይቅር እንድትለኝ እለምንሃለሁ አለው። ");
INSERT INTO amh_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ሌላውም። አምስት ጥምድ በሬዎች ገዝቼአለሁ ልፈትናቸውም እሄዳለሁ፤ ይቅር እንድትለኝ እለምንሃለሁ አለው። ");
INSERT INTO amh_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ሌላውም። ሚስት አግብቼአለሁ ስለዚህም ልመጣ አልችልም አለው። ");
INSERT INTO amh_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ባሪያውም ደርሶ ይህን ለጌታው ነገረው። በዚያን ጊዜ ባለቤቱ ተቆጥቶ ባሪያውን። ወደ ከተማ ጎዳናና ወደ ስላች ፈጥነህ ውጣ ድሆችንና ጕንድሾችን አንካሶችንና ዕውሮችንም ወደዚህ አግባ አለው። ");
INSERT INTO amh_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ባሪያውም። ጌታ ሆይ፥ እንዳዘዝኸኝ ተደርጎአል፥ ገናም ስፍራ አለ አለው። ");
INSERT INTO amh_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ጌታውም ባሪያውን። ቤቴ እንዲሞላ ወደ መንገድና ወደ ቅጥር ውጣና ይገቡ ዘንድ ግድ በላቸው፤ ");
INSERT INTO amh_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","እላችኋለሁና፥ ከታደሙት ከእነዚያ ሰዎች አንድ ስንኳ እራቴን አይቀምስም አለው። ");
INSERT INTO amh_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ብዙም ሕዝብ ከእርሱ ጋር ይሄዱ ነበር፥ ዘወር ብሎም እንዲህ አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ማንም ወደ እኔ የሚመጣ ቢኖር አባቱንና እናቱን ሚስቱንም ልጆቹንም ወንድሞቹንም እኅቶቹንም የራሱን ሕይወት ስንኳ ሳይቀር ባይጠላ፥ ደቀ መዝሙሬ ሊሆን አይችልም። ");
INSERT INTO amh_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ማንም መስቀሉን ተሸክሞ በኋላዬ የማይመጣ፥ ደቀ መዝሙሬ ሊሆን አይችልም። ");
INSERT INTO amh_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ከእናንተ ግንብ ሊሠራ የሚወድ ለመደምደሚያ የሚበቃ ያለው እንደ ሆነ አስቀድሞ ተቀምጦ ከሳራውን የማይቈጥር ማን ነው? ");
INSERT INTO amh_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ያለዚያ መሠረቱን ቢመሠርት፥ ሊደመድመውም ቢያቅተው፥ ያዩት ሁሉ። ");
INSERT INTO amh_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ይህ ሰው ሊሠራ ጀምሮ ሊደመድመው አቃተው ብለው ሊዘብቱበት ይጀምራሉ። ");
INSERT INTO amh_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ወይም ሌላውን ንጉሥ በጦርነት ሊጋጠም የሚሄድ፥ ከሁለት እልፍ ጋር የሚመጣበትን በአንድ እልፍ ሊገናኝ የሚችል እንደ ሆነ አስቀድሞ ተቀምጦ የማያስብ ንጉሥ ማን ነው? ");
INSERT INTO amh_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ባይሆንስ ሌላው ገና ሩቅ ሳለ መልክተኞች ልኮ ዕርቅ ይለምናል። ");
INSERT INTO amh_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","እንግዲህ እንደዚሁ ማንም ከእናንተ ያለውን ሁሉ የማይተው ደቀ መዝሙሬ ሊሆን አይችልም። ");
INSERT INTO amh_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ጨው መልካም ነው፤ ጨው አልጫ ቢሆን ግን በምን ይጣፈጣል? ");
INSERT INTO amh_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ለምድር ቢሆን ለፍግ መቈለያም ቢሆን አይረባም፤ ወደ ውጭ ይጥሉታል። የሚሰማ ጆሮ ያለው ይስማ። ");
INSERT INTO amh_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ቀራጮችና ኃጢአተኞችም ሁሉ ሊሰሙት ወደ እርሱ ይቀርቡ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ፈሪሳውያንና ጻፎችም። ይህስ ኃጢአተኞችን ይቀበላል ከእነርሱም ጋር ይበላል ብለው እርስ በርሳቸው አንጐራጐሩ። ");
INSERT INTO amh_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ይህንም ምሳሌ ነገራቸው እንዲህ ሲል። ");
INSERT INTO amh_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","መቶ በግ ያለው ከእነርሱም አንዱ ቢጠፋ፥ ዘጠና ዘጠኙን በበረሃ ትቶ የጠፋውን እስኪያገኘው ድረስ ሊፈልገው የማይሄድ ከእናንተ ማን ነው? ");
INSERT INTO amh_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ባገኘውም ጊዜ ደስ ብሎት በጫንቃው ይሸከመዋል፤ ");
INSERT INTO amh_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ወደ ቤትም በመጣ ጊዜ ወዳጆቹንና ጐረቤቶቹን በአንድነት ጠርቶ። የጠፋውን በጌን አግኝቼዋለሁና ከእኔ ጋር ደስ ይበላችሁ ይላቸዋል። ");
INSERT INTO amh_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","እላችኋለሁ፥ እንዲሁ ንስሐ ከማያስፈልጋቸው ከዘጠና ዘጠኝ ጻድቃን ይልቅ ንስሐ በሚገባ በአንድ ኃጢአተኛ በሰማይ ደስታ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ወይም አሥር ድሪም ያላት አንድ ድሪም ቢጠፋባት፥ መብራት አብርታ ቤትዋንም ጠርጋ እስክታገኘው ድረስ አጥብቃ የማትፈልግ ሴት ማን ናት? ");
INSERT INTO amh_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ባገኘችውም ጊዜ ወዳጆችዋንና ጐረቤቶችዋን በአንድነት ጠርታ። የጠፋውን ድሪሜን አግኝቼዋለሁና ከእኔ ጋር ደስ ይበላችሁ ትላቸዋለች። ");
INSERT INTO amh_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","እላችኋለሁ፥ እንዲሁ ንስሐ በሚገባ በአንድ ኃጢአተኛ በእግዚአብሔር መላእክት ፊት ደስታ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","እንዲህም አለ። አንድ ሰው ሁለት ልጆች ነበሩት። ");
INSERT INTO amh_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ከእነርሱም ታናሹ አባቱን። አባቴ ሆይ፥ ከገንዘብህ የሚደርሰኝን ክፍል ስጠኝ አለው። ገንዘቡንም አካፈላቸው። ");
INSERT INTO amh_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ከጥቂት ቀንም በኋላ ታናሹ ልጅ ገንዘቡን ሁሉ ሰብስቦ ወደ ሩቅ አገር ሄደ፥ ከዚያም እያባከነ ገዘቡን በተነ። ");
INSERT INTO amh_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ሁሉንም ከከሰረ በኋላ በዚያች አገር ጽኑ ራብ ሆነ፥ እርሱም ይጨነቅ ጀመር። ");
INSERT INTO amh_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ሄዶም ከዚያች አገር ሰዎች ከአንዱ ጋር ተዳበለ፥ እርሱም እሪያ ሊያሰማራ ወደ ሜዳ ሰደደው። ");
INSERT INTO amh_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","እሪያዎችም ከሚበሉት አሰር ሊጠግብ ይመኝ ነበር፥ የሚሰጠውም አልነበረም። ");
INSERT INTO amh_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ወደ ልቡም ተመልሶ እንዲህ አለ። እንጀራ የሚተርፋቸው የአባቴ ሞያተኞች ስንት ናቸው? እኔ ግን ከዚህ በራብ እጠፋለሁ። ");
INSERT INTO amh_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ተነሥቼም ወደ አባቴ እሄዳለሁና። አባቴ ሆይ፥ በሰማይና በፊትህ በደልሁ፥ ");
INSERT INTO amh_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ወደ ፊትም ልጅህ ልባል አይገባኝም፤ ከሞያተኞችህ እንደ አንዱ አድርገኝ እለዋለሁ። ");
INSERT INTO amh_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ተነሥቶም ወደ አባቱ መጣ። እርሱም ገና ሩቅ ሳለ አባቱ አየውና አዘነለት፥ ሮጦም አንገቱን አቀፈውና ሳመው። ");
INSERT INTO amh_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ልጁም። አባቴ ሆይ፥ በሰማይና በፊትህ በደልሁ፥ ወደ ፊትም ልጅህ ልባል አይገባኝም አለው። ");
INSERT INTO amh_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","አባቱ ግን ባሪያዎቹን አለ። ፈጥናችሁ ከሁሉ የተሻለ ልብስ አምጡና አልብሱት፥ ለእጁ ቀለበት ለእግሩም ጫማ ስጡ፤ ");
INSERT INTO amh_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","የሰባውን ፊሪዳ አምጥታችሁ እረዱት፥ እንብላም ደስም ይበለን፤ ");
INSERT INTO amh_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ይህ ልጄ ሞቶ ነበርና ደግሞም ሕያው ሆኖአል፤ ጠፍቶም ነበር ተገኝቶአልም። ደስም ይላቸው ጀመር። ");
INSERT INTO amh_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ታላቁ ልጁ በእርሻ ነበረ፤ መጥቶም ወደ ቤት በቀረበ ጊዜ የመሰንቆና የዘፈን ድምፅ ሰማ፤ ");
INSERT INTO amh_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ከብላቴናዎችም አንዱን ጠርቶ። ይህ ምንድር ነው? ብሎ ጠየቀ። ");
INSERT INTO amh_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","እርሱም። ወንድምህ መጥቶአልና በደኅና ስላገኘው አባትህ የሰባውን ፊሪዳ አረደለት አለው። ");
INSERT INTO amh_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ተቈጣም ሊገባም አልወደደም፤ አባቱም ወጥቶ ለመነው። ");
INSERT INTO amh_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","እርሱ ግን መልሶ አባቱን። እነሆ፥ ይህን ያህል ዓመት እንደ ባሪያ ተገዝቼልሃለሁ ከትእዛዝህም ከቶ አልተላለፍሁም፤ ለእኔም ከወዳጆቼ ጋር ደስ እንዲለኝ አንድ ጥቦት ስንኳ አልሰጠኸኝም፤ ");
INSERT INTO amh_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ነገር ግን ገንዘብህን ከጋለሞቶች ጋር በልቶ ይህ ልጅህ በመጣ ጊዜ፥ የሰባውን ፊሪዳ አረድህለት አለው። ");
INSERT INTO amh_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","እርሱ ግን። ልጄ ሆይ፥ አንተ ሁልጊዜ ከእኔ ጋር ነህ፥ ለእኔም የሆነ ሁሉ የአንተ ነው፤ ");
INSERT INTO amh_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ዳሩ ግን ይህ ወንድምህ ሞቶ ነበረ ሕያው ስለ ሆነ ጠፍቶም ነበር ስለ ተገኘ ደስ እንዲለን ፍሥሐም እንድናደርግ ይገባናል አለው። ");
INSERT INTO amh_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ደግሞም ለደቀ መዛሙርቱ እንዲህ አለ። መጋቢ የነበረው አንድ ባለ ጠጋ ሰው ነበረ፥ በእርሱ ዘንድ። ይህ ሰው ያለህን ይበትናል ብለው ከሰሱት። ");
INSERT INTO amh_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ጠርቶም። ይህ የምሰማብህ ምንድር ነው? ወደ ፊት ለእኔ መጋቢ ልትሆን አትችልምና የመጋቢነትህን ሂሳብ አስረክበኝ አለው። ");
INSERT INTO amh_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","መጋቢውም በልቡ። ጌታዬ መጋቢነቱን ከእኔ ይወስዳልና ምን ላድርግ? ለመቈፈር ኃይል የለኝም፥ መለመንም አፍራለሁ። ");
INSERT INTO amh_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ከመጋቢነቱ ብሻር በቤታቸው እንዲቀበሉኝ የማደርገውን አውቃለሁ አለ። ");
INSERT INTO amh_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","የጌታውንም ባለ ዕዳዎች እያንዳንዳቸውን ጠርቶ የፊተኛውን። ለጌታዬ ምን ያህል ዕዳ አለብህ? አለው። ");
INSERT INTO amh_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","እርሱም። መቶ ማድጋ ዘይት አለ። ደብዳቤህን እንካ ፈጥነህም ተቀምጠህ አምሳ ብለህ ጻፍ አለው። ");
INSERT INTO amh_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","በኋላም ሌላውን። አንተስ ስንት ዕዳ አለብህ? አለው። እርሱም። መቶ ጫን ስንዴ አለ። ደብዳቤህን እንካ ሰማንያ ብለህም ጻፍ አለው። ");
INSERT INTO amh_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ጌታውም ዓመፀኛውን መጋቢ በልባምነት ስላደረገ አመሰገነው የዚህ ዓለም ልጆች ለትውልዳቸው ከብርሃን ልጆች ይልቅ ልባሞች ናቸውና። ");
INSERT INTO amh_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","እኔም እላችኋለሁ፥ የዓመፃ ገንዘብ ሲያልቅ በዘላለም ቤቶች እንዲቀበሉአችሁ፥ በእርሱ ወዳጆችን ለራሳችሁ አድርጉ። ");
INSERT INTO amh_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ከሁሉ በሚያንስ የታመነ በብዙ ደግሞ የታመነ ነው፥ ከሁሉ በሚያንስም የሚያምፅ በብዙ ደግሞ ዓመፀኛ ነው። ");
INSERT INTO amh_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","እንግዲያስ በዓመፃ ገንዘብ ካልታመናችሁ፥ እውነተኛውን ገንዘብ ማን አደራ ይሰጣችኋል? ");
INSERT INTO amh_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","በሌላ ሰው ገንዘብ ካልታመናችሁ፥ የእናንተን ማን ይሰጣችኋል? ");
INSERT INTO amh_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","ለሁለት ጌቶች መገዛት የሚቻለው ባርያ ማንም የለም፤ ወይም አንዱን ይጠላልና ሁለተኛውንም ይወዳል፥ ወይም ወደ አንዱ ይጠጋል ሁለተኛውንም ይንቃል። ለእግዚአብሔርና ለገንዘብ መገዛት አትችሉም። ");
INSERT INTO amh_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ገንዘብንም የሚወዱ ፈሪሳውያን ይህን ሁሉ ሰምተው ያፌዙበት ነበር። ");
INSERT INTO amh_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","እንዲህም አላቸው። ራሳችሁን በሰው ፊት የምታጸድቁ እናንተ ናችሁ፥ ነገር ግን እግዚአብሔር ልባችሁን ያውቃል፤ በሰው ዘንድ የከበረ በእግዚአብሔር ፊት ርኵሰት ነውና። ");
INSERT INTO amh_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ሕግና ነቢያት እስከ ዮሐንስ ነበሩ፤ ከዚያ ጀምሮ የእግዚአብሔር መንግሥት ይሰበካል፤ ሁሉም ወደ እርስዋ በኃይል ይገቡባታል። ");
INSERT INTO amh_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ነገር ግን ከሕግ አንዲት ነጥብ ከምትወድቅ ሰማይና ምድር ሊያልፍ ይቀላል። ");
INSERT INTO amh_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ሚስቱንም የሚፈታ ሁሉ ሌላይቱንም የሚያገባ ያመነዝራል፥ ከባልዋም የተፈታችውን የሚያገባ ያመነዝራል። ");
INSERT INTO amh_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ቀይ ልብስና ቀጭን የተልባ እግር የለበሰ አንድ ባለ ጠጋ ሰው ነበረ፥ ዕለት ዕለትም እየተመቸው በደስታ ይኖር ነበር። ");
INSERT INTO amh_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","አልዓዛርም የሚባል አንድ ድሀ በቍስል ተወርሶ በደጁ ተኝቶ ነበር፥ ");
INSERT INTO amh_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ከባለ ጠጋውም ማዕድ ከሚወድቀው ፍርፋሪ ሊጠግብ ይመኝ ነበር፤ ውሾች እንኳ መጥተው ቍስሎቹን ይልሱ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ድሀውም ሞተ፥ መላእክትም ወደ አብርሃም እቅፍ ወሰዱት፤ ባለ ጠጋው ደግሞ ሞተና ተቀበረ። ");
INSERT INTO amh_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","በሲኦልም በሥቃይ ሳለ አሻቅቦ አብርሃምን በሩቅ አየ አልዓዛርንም በእቅፉ። ");
INSERT INTO amh_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","እርሱም እየጮኸ። አብርሃም አባት ሆይ፥ ማረኝ፥ በዚህ ነበልባል እሣቀያለሁና የጣቱን ጫፍ በውኃ ነክሮ መላሴን እንዲያበርድልኝ አልዓዛርን ስደድልኝ አለ። ");
INSERT INTO amh_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","አብርሃም ግን። ልጄ ሆይ፥ አንተ በሕይወትህ ሳለህ መልካም እንደ ተቀበልህ አስብ አልዓዛርም እንዲሁ ክፉ፤ አሁን ግን እርሱ በዚህ ይጽናናል አንተም ትሣቀያለህ። ");
INSERT INTO amh_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ከዚህም ሁሉ ጋር ከዚህ ወደ እናንተ ሊያልፉ የሚፈልጉ እንዳይችሉ፥ ወዲያ ያሉ ደግሞ ወደ እኛ እንዳይሻገሩ በእኛና በእናንተ መካከል ታላቅ ገደል ተደርጎአል አለ። ");
INSERT INTO amh_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","እርሱም። እንኪያስ፥ አባት ሆይ፥ ወደ አባቴ ቤት እንድትሰደው እለምንሃለሁ፤ አምስት ወንድሞች አሉኝና፤ ");
INSERT INTO amh_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","እነርሱ ደግሞ ወደዚህ ሥቃይ ስፍራ እንዳይመጡ ይመስክርላቸው አለ። ");
INSERT INTO amh_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","አብርሃም ግን። ሙሴና ነቢያት አሉአቸው፤ እነርሱን ይስሙ አለው። ");
INSERT INTO amh_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","እርሱም። አይደለም፥ አብርሃም አባት ሆይ፥ ነገር ግን ከሙታን አንዱ ቢሄድላቸው ንስሐ ይገባሉ አለ። ");
INSERT INTO amh_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ሙሴንና ነቢያትንም የማይሰሙ ከሆነ፥ ከሙታንም እንኳ አንድ ቢነሣ አያምኑም አለው። ");
INSERT INTO amh_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ለደቀ መዛሙርቱም እንዲህ አለ። መሰናክል ግድ ሳይመጣ አይቀርም፥ ነገር ግን መሰናክሉን ለሚያመጣው ወዮለት፤ ");
INSERT INTO amh_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ከእነዚህ ከታናናሾች አንዱን ከማሰናከል ይልቅ የወፍጮ ድንጋይ በአንገቱ ታስሮ ወደ ባሕር ቢጣል ይጠቅመው ነበር። ");
INSERT INTO amh_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ለራሳችሁ ተጠንቀቁ። ወንድምህ ቢበድልህ ገሥጸው፥ ቢጸጸትም ይቅር በለው። ");
INSERT INTO amh_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","በቀንም ሰባት ጊዜ እንኳ ቢበድልህ በቀንም ሰባት ጊዜ። ተጸጸትሁ እያለ ወደ አንተ ቢመለስ፥ ይቅር በለው። ");
INSERT INTO amh_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ሐዋርያትም ጌታን። እምነት ጨምርልን አሉት። ");
INSERT INTO amh_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ጌታም አለ። የሰናፍጭ ቅንጣት የሚያህል እምነት ቢኖራችሁ፥ ይህን ሾላ። ተነቅለህ ወደ ባሕር ተተከል ብትሉት፥ ይታዘዝላችሁ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ከእናንተም የሚያርስ ወይም ከብትን የሚጠብቅ ባሪያ ያለው፥ ከእርሻ ሲመለስ። ወዲያው ቅረብና በማዕድ ተቀመጥ የሚለው ማን ነው? ");
INSERT INTO amh_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","የምበላውን እራቴን አሰናዳልኝ፥ እስክበላና እስክጠጣ ድረስ ታጥቀህ አገልግለኝ፥ በኋላም አንተ ብላና ጠጣ የሚለው አይደለምን? ");
INSERT INTO amh_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ያንን ባሪያ ያዘዘውን ስላደረገ ያመሰግነዋልን? ");
INSERT INTO amh_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","እንዲሁ እናንተ ደግሞ የታዘዛችሁትን ሁሉ ባደረጋችሁ ጊዜ። የማንጠቅም ባሪያዎች ነን፥ ልናደርገው የሚገባንን አድርገናል በሉ። ");
INSERT INTO amh_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ወደ ኢየሩሳሌምም ሲሄድ በገሊላና በሰማርያ መካከል አለፈ። ");
INSERT INTO amh_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ወደ አንዲት መንደርም ሲገባ በሩቅ የቆሙት አሥር ለምጻሞች ተገናኙት፤ ");
INSERT INTO amh_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","እነርሱም እየጮኹ። ኢየሱስ ሆይ፥ አቤቱ፥ ማረን አሉ። ");
INSERT INTO amh_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","አይቶም። ሂዱ፥ ራሳችሁን ለካህናት አሳዩ አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","እነሆም፥ ሲሄዱ ነጹ። ከእነርሱም አንዱ እንደ ተፈወሰ ባየ ጊዜ በታላቅ ድምፅ እግዚአብሔርን እያከበረ ተመለሰ፥ ");
INSERT INTO amh_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","እያመሰገነውም በእግሩ ፊት በግንባሩ ወደቀ፤ እርሱም ሳምራዊ ነበረ። ");
INSERT INTO amh_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ኢየሱስም መልሶ። አሥሩ አልነጹምን? ዘጠኙስ ወዴት አሉ? ");
INSERT INTO amh_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ከዚህ ከልዩ ወገን በቀር እግዚአብሔርን ሊያከብሩ የተመለሱ አልተገኙም አለ። ");
INSERT INTO amh_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","እርሱንም። ተነሣና ሂድ፤ እምነትህ አድኖሃል አለው። ");
INSERT INTO amh_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ፈሪሳውያንም። የእግዚአብሔር መንግሥት መቼ ትመጣለች ብለው ቢጠይቁት፥ መልሶ። የእግዚአብሔር መንግሥት በመጠባበቅ አትመጣም፤ ");
INSERT INTO amh_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ደግሞም። እንኋት በዚህ ወይም። እንኋት በዚያ አይሉአትም። እነሆ፥ የእግዚአብሔር መንግሥት በመካከላችሁ ናትና አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ለደቀ መዛሙርቱም እንዲህ አለ። ከሰው ልጅ ቀኖች አንዱን ልታዩ የምትመኙበት ወራት ይመጣል አታዩትምም። ");
INSERT INTO amh_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","እነርሱም። እነሆ በዚህ፥ ወይም። እነሆ በዚያ ይሉአችኋል፤ አትሂዱ አትከተሉአቸውም። ");
INSERT INTO amh_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","መብረቅ በርቆ ከሰማይ በታች ካለ ከአንድ አገር ከሰማይ በታች ወዳለው ወደ ሌላ አገር እንደሚያበራ፥ የሰው ልጅ በቀኑ እንዲህ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","አስቀድሞ ግን ብዙ መከራ እንዲቀበል ከዚህም ትውልድ እንዲጣል ይገባዋል። ");
INSERT INTO amh_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","በኖኅ ዘመንም እንደ ሆነ፥ በሰው ልጅ ዘመን ደግሞ እንዲሁ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ኖኅ ወደ መርከብ እስከ ገባበት ቀን ድረስ፥ ይበሉና ይጠጡ ያገቡና ይጋቡም ነበር፥ የጥፋት ውኃም መጣ ሁሉንም አጠፋ። ");
INSERT INTO amh_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","እንዲሁ በሎጥ ዘመን እንደ ሆነ፤ ይበሉ ይጠጡም ይገዙም ይሸጡም ይተክሉም ቤትም ይሠሩ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ሎጥ ከሰዶም በወጣበት ቀን ግን ከሰማይ እሳትና ዲን ዘነበ ሁሉንም አጠፋ። ");
INSERT INTO amh_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","የሰው ልጅ በሚገለጥበት ቀን እንዲሁ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","በዚያም ቀን በሰገነት ያለ በቤቱ ያለውን ዕቃ ሊወስድ አይውረድ፥ እንዲሁም በእርሻ ያለ ወደ ኋላው አይመለስ። ");
INSERT INTO amh_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","የሎጥን ሚስት አስቡአት። ");
INSERT INTO amh_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ነፍሱን ሊያድን የሚፈልግ ሁሉ ያጠፋታል፥ ነፍሱንም የሚያጠፋ ሁሉ በሕይወት ይጠብቃታል። ");
INSERT INTO amh_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","እላችኋለሁ፥ በዚያች ሌሊት ሁለት ሰዎች በአንድ አልጋ ይሆናሉ፤ አንዱ ይወሰዳል ሁለተኛውም ይቀራል። ");
INSERT INTO amh_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ሁለት ሴቶች በአንድ ወፍጮ ይፈጫሉ፤ አንዲቱ ትወሰዳለች ሁለተኛይቱም ትቀራለች። ");
INSERT INTO amh_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ሁለት ሰዎች በእርሻ ይሆናሉ፤ አንዱ ይወሰዳል ሁለተኛውም ይቀራል። ");
INSERT INTO amh_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","መልሰውም። ጌታ ሆይ፥ ወዴት ነው? አሉት። እርሱም። ሥጋ ወዳለበት በዚያ አሞራዎች ይሰበሰባሉ አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ሳይታክቱም ዘወትር ሊጸልዩ እንዲገባቸው የሚል ምሳሌን ነገራቸው፥ ");
INSERT INTO amh_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","እንዲህ ሲል። በአንዲት ከተማ እግዚአብሔርን የማይፈራ ሰውንም የማያፍር አንድ ዳኛ ነበረ። ");
INSERT INTO amh_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","በዚያችም ከተማ አንዲት መበለት ነበረች፥ ወደ እርሱም እየመጣች። ከባላጋራዬ ፍረድልኝ ትለው ነበር። ");
INSERT INTO amh_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","አያሌ ቀንም አልወደደም፤ ከዚህ በኋላ ግን በልቡ። ምንም እግዚአብሔርን ባልፈራ ሰውንም ባላፍር፥ ");
INSERT INTO amh_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ይህች መበለት ስለምታደክመኝ ሁልጊዜም እየመጣች እንዳታውከኝ እፈርድላታለሁ አለ። ");
INSERT INTO amh_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ጌታም አለ። ዓመፀኛው ዳኛ ያለውን ስሙ። ");
INSERT INTO amh_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","እግዚአብሔር እንኪያስ ቀንና ሌሊት ወደ እርሱ ለሚጮኹ ለሚታገሣቸውም ምርጦቹ አይፈርድላቸውምን? ");
INSERT INTO amh_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","እላችኋለሁ፥ ፈጥኖ ይፈርድላቸዋል። ነገር ግን የሰው ልጅ በመጣ ጊዜ በምድር እምነትን ያገኝ ይሆንን? ");
INSERT INTO amh_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ጻድቃን እንደ ሆኑ በራሳቸው ለሚታመኑና ሌሎቹን ሁሉ በጣም ለሚንቁ ይህን ምሳሌ ነገራቸው፥ ");
INSERT INTO amh_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","እንዲህ ሲል። ሁለት ሰዎች ሊጸልዩ ወደ መቅደስ ወጡ፥ አንዱ ፈሪሳዊ ሁለተኛውም ቀራጭ። ");
INSERT INTO amh_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ፈሪሳዊም ቆሞ በልቡ ይህን ሲጸልይ። እግዚአብሔር ሆይ፥ እንደ ሌላ ሰው ሁሉ፥ ቀማኞችና ዓመፀኞች አመንዝሮችም፥ ወይም እንደዚህ ቀራጭ ስላልሆንሁ አመሰግንሃለሁ፤ ");
INSERT INTO amh_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","በየሳምንቱ ሁለት ጊዜ እጦማለሁ፥ ከማገኘውም ሁሉ አሥራት አወጣለሁ አለ። ");
INSERT INTO amh_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ቀራጩ ግን በሩቅ ቆሞ ዓይኖቹን ወደ ሰማይ ሊያነሣ እንኳ አልወደደም፥ ነገር ግን። አምላክ ሆይ፥ እኔን ኃጢአተኛውን ማረኝ እያለ ደረቱን ይደቃ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","እላችኋለሁ፥ ከዚያ ይልቅ ይህ ጻድቅ ሆኖ ወደ ቤቱ ተመለሰ፤ ራሱን ከፍ የሚያደርግ ሁሉ ይዋረዳልና፥ ራሱን ግን የሚያዋርድ ከፍ ይላል። ");
INSERT INTO amh_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","እንዲዳስሳቸውም ሕፃናትን ደግሞ ወደ እርሱ አመጡ፤ ደቀ መዛሙርቱም አይተው ገሠጹአቸው። ");
INSERT INTO amh_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ኢየሱስ ግን ሕፃናትን ወደ እርሱ ጠርቶ። ሕፃናት ወደ እኔ ይመጡ ዘንድ ተዉአቸው አትከልክሉአቸውም፤ የእግዚአብሔር መንግሥት እንደ እነዚህ ላሉት ናትና። ");
INSERT INTO amh_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","እውነት እላችኋለሁ፥ የእግዚአብሔርን መንግሥት እንደ ሕፃን የማይቀበላት ሁሉ ከቶ አይገባባትም አለ። ");
INSERT INTO amh_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ከአለቆችም አንዱ። ቸር መምህር፥ የዘላለምን ሕይወት እንድወርስ ምን ላድርግ? ብሎ ጠየቀው። ");
INSERT INTO amh_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ኢየሱስም። ስለ ምን ቸር ትለኛለህ? ከአንዱ ከእግዚአብሔር በቀር ቸር ማንም የለም። ");
INSERT INTO amh_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ትእዛዛቱን ታውቃለህ፥ አታመንዝር፥ አትግደል፥ አትስረቅ፥ በሐሰት አትመስክር፥ አባትህንና እናትህን አክብር አለው። ");
INSERT INTO amh_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","እርሱም። ይህን ሁሉ ከሕፃንናቴ ጀምሬ ጠብቄአለሁ አለ። ");
INSERT INTO amh_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ኢየሱስም ይህን ሰምቶ። አንዲት ገና ቀርታሃለች፤ ያለህን ሁሉ ሽጠህ ለድሆች ስጥ፥ በሰማይም መዝገብ ታገኛለህ፥ መጥተህም ተከተለኝ አለው። ");
INSERT INTO amh_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","እርሱ ግን ይህን ሰምቶ እጅግ ባለ ጠጋ ነበርና ብዙ አዘነ። ");
INSERT INTO amh_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ኢየሱስም ብዙ እንዳዘነ አይቶ። ገንዘብ ላላቸው ወደ እግዚአብሔር መንግሥት መግባት እንዴት ጭንቅ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ባለ ጠጋ ወደ እግዚአብሔር መንግሥት ከሚገባ ይልቅ ግመል በመርፌ ቀዳዳ ሊገባ ይቀላል አለ። ");
INSERT INTO amh_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","የሰሙትም። እንግዲህ ማን ሊድን ይችላል? አሉ። ");
INSERT INTO amh_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","እርሱ ግን። በሰው ዘንድ የማይቻል በእግዚአብሔር ዘንድ ይቻላል አለ። ");
INSERT INTO amh_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ጴጥሮስም። እነሆ፥ እኛ ሁሉን ትተን ተከተልንህ አለ። ");
INSERT INTO amh_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","እርሱም። እውነት እላችኋለሁ፥ ስለ እግዚአብሔር መንግሥት ቤትን ወይም ወላጆችን ወይም ወንድሞችን ወይም ሚስትን ወይም ልጆችን የተወ፥ ");
INSERT INTO amh_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","በዚህ ዘመን ብዙ እጥፍ በሚመጣውም ዓለም የዘላለምን ሕይወት የማይቀበል ማንም የለም አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","አሥራ ሁለቱንም ወደ እርሱ አቅርቦ እንዲህ አላቸው። እነሆ፥ ወደ ኢየሩሳሌም እንወጣለን፥ ስለ ሰው ልጅም በነቢያት የተጻፈው ሁሉ ይፈጸማል። ");
INSERT INTO amh_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ለአሕዛብ አሳልፈው ይሰጡታልና፥ ይዘብቱበትማል ያንገላቱትማል ይተፉበትማል፤ ");
INSERT INTO amh_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ከገረፉትም በኋላ ይገድሉታል፥ በሦስተኛውም ቀን ይነሣል። ");
INSERT INTO amh_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","እነርሱም ከዚህ ነገር ምንም አላስተዋሉም፥ ይህም ቃል ተሰውሮባቸው ነበር፥ የተናገረውንም አላወቁም። ");
INSERT INTO amh_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ወደ ኢያሪኮም በቀረበ ጊዜ አንድ ዕውር እየለመነ በመንገድ ዳር ተቀምጦ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ሕዝብም ሲያልፍ ሰምቶ። ይህ ምንድር ነው? ብሎ ጠየቀ። ");
INSERT INTO amh_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","እነርሱም። የናዝሬቱ ኢየሱስ ያልፋል ብለው አወሩለት። ");
INSERT INTO amh_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","እርሱም። የዳዊት ልጅ፥ ኢየሱስ ሆይ፥ ማረኝ እያለ ጮኸ። ");
INSERT INTO amh_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","በስተ ፊት ይሄዱ የነበሩትም ዝም እንዲል ገሠጹት፤ እርሱ ግን። የዳዊት ልጅ ሆይ፥ ማረኝ እያለ አብዝቶ ጮኸ። ");
INSERT INTO amh_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ኢየሱስም ቆሞ ወደ እርሱ እንዲያመጡት አዘዘ። በቀረበም ጊዜ። ምን ላደርግልህ ትወዳለህ? ብሎ ጠየቀው። ");
INSERT INTO amh_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","እርሱም። ጌታ ሆይ፥ አይ ዘንድ ነው አለው። ");
INSERT INTO amh_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ኢየሱስም። እይ፤ እምነትህ አድኖሃል አለው። ");
INSERT INTO amh_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","በዚያን ጊዜም አየ፥ እግዚአብሔንም እያከበረ ተከተለው። ሕዝቡም ሁሉ አይተው እግዚአብሔርን አመሰገኑ። ");
INSERT INTO amh_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","3","ኢየሱስንም የትኛው እንደ ሆነ ሊያይ ይፈልግ ነበር፤ ቁመቱም አጭር ነበረና ስለ ሕዝቡ ብዛት አቃተው። ");
INSERT INTO amh_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","በዚያችም መንገድ ያልፍ ዘንድ አለውና ያየው ዘንድ ወደ ፊት ሮጦ በአንድ ሾላ ላይ ወጣ። ");
INSERT INTO amh_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ኢየሱስም ወደዚያ ስፍራ በደረሰ ጊዜ፥ አሻቅቦ አየና። ዘኬዎስ ሆይ፥ ዛሬ በቤትህ እውል ዘንድ ይገባኛልና ፈጥነህ ውረድ አለው። ");
INSERT INTO amh_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ፈጥኖም ወረደ በደስታም ተቀበለው። ");
INSERT INTO amh_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ሁሉም አይተው። ከኃጢአተኛ ሰው ጋር ሊውል ገባ ብለው አንጐራጐሩ። ");
INSERT INTO amh_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ዘኬዎስ ግን ቆሞ ጌታን። ጌታ ሆይ፥ ካለኝ ሁሉ እኵሌታውን ለድሆች እሰጣለሁ፤ ማንንም በሐሰት ከስሼ እንደ ሆንሁ አራት እጥፍ እመልሳለሁ አለው። ");
INSERT INTO amh_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ኢየሱስም። እርሱ ደግሞ የአብርሃም ልጅ ነውና ዛሬ ለዚህ ቤት መዳን ሆኖለታል፤ ");
INSERT INTO amh_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","የሰው ልጅ የጠፋውን ሊፈልግና ሊያድን መጥቶአለና አለው። ");
INSERT INTO amh_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","እነርሱም ይህን ሲሰሙ፥ ወደ ኢየሩሳሌም መቅረቡ ስለ ሆነ የእግዚአብሔርም መንግሥት ፈጥኖ ሊገለጥ እንዳለው ስለ መሰላቸው ምሳሌ ጭምር ተናገረ። ");
INSERT INTO amh_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ስለዚህም እንዲህ አላቸው። አንድ መኰንን ለራሱ መንግሥትን ይዞ ሊመለሰ ወደ ሩቅ አገር ሄደ። ");
INSERT INTO amh_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","አሥር ባሪያዎችንም ጠርቶ አሥር ምናን ሰጣቸውና። እስክመጣ ድረስ ነግዱ አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","የአገሩ ሰዎች ግን ይጠሉት ነበርና። ይህ በላያችን ሊነግሥ አንወድም ብለው በኋላው መልክተኞችን ላኩ። ");
INSERT INTO amh_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","መንግሥትንም ይዞ በተመለሰ ጊዜ፥ ገንዘብ የሰጣቸውን እነዚህን ባሪያዎች ነግደው ምን ያህል እንዳተረፉ ያውቅ ዘንድ እንዲጠሩለት አዘዘ። ");
INSERT INTO amh_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","የፊተኛውም ደርሶ። ጌታ ሆይ፥ ምናንህ አሥር ምናን አተረፈ አለው። ");
INSERT INTO amh_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","እርሱም። መልካም፥ አንተ በጎ ባሪያ፥ በጥቂት የታመንህ ስለ ሆንህ በአሥር ከተማዎች ላይ ሥልጣን ይሁንልህ አለው። ");
INSERT INTO amh_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ሁለተኛውም መጥቶ። ጌታ ሆይ፥ ምናንህ አምስት ምናን አተረፈ አለው። ");
INSERT INTO amh_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ይህንም ደግሞ። አንተም በአምስት ከተማዎች ላይ ሁን አለው። ");
INSERT INTO amh_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ሌላውም መጥቶ። ጌታ ሆይ፥ በጨርቅ ጠቅልዬ የጠበቅኋት ምናንህ እነሆ፤ ");
INSERT INTO amh_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ፈርቼሃለሁና፥ ጨካኝ ሰው ስለ ሆንህ፤ ያላኖርኸውን ትወስዳለህ ያልዘራኸውንም ታጭዳለህ አለው። ");
INSERT INTO amh_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","እርሱም። አንተ ክፉ ባሪያ፥ አፍህ በተናገረው እፈርድብሃለሁ። እኔ ያላኖርሁትን የምወስድና ያልዘራሁትን የማጭድ ጨካኝ ሰው እንደ ሆንሁ አወቅህ፤ ምን ነው ገንዘቤን ለለዋጮች አደራ ያልሰጠኸው? ");
INSERT INTO amh_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","እኔም መጥቼ ከትርፉ ጋር እወስደው ነበር አለው። ");
INSERT INTO amh_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","በዚያም ቆመው የነበሩትን። ምናኑን ውሰዱበት አሥሩ ምናን ላለውም ስጡት አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","እነርሱም። ጌታ ሆይ፥ አሥር ምናን አለው አሉት። ");
INSERT INTO amh_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","እላችኋለሁ፥ ላለው ሁሉ ይሰጠዋል፥ ከሌለው ግን ያው ያለው ስንኳ ይወሰድበታል። ");
INSERT INTO amh_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ነገር ግን እነዚያን በላያቸው ልነግሥ ያልወደዱትን ጠላቶቼን ወደዚህ አምጡአቸው በፊቴም እረዱአቸው። ");
INSERT INTO amh_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ይህንም ከተናገረ በኋላ፥ ወደ ኢየሩሳሌም ሲወጣ ይቀድማቸው ነበር። ");
INSERT INTO amh_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ደብረ ዘይትም በሚባል ተራራ አጠገብ ወዳሉት ወደ ቤተ ፋጌና ወደ ቢታንያ በቀረበ ጊዜ፥ ከደቀ መዛሙርቱ ሁለቱን ላከና። ");
INSERT INTO amh_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","በፊታችሁ ወዳለችው መንደር ሂዱ፥ ወደ እርስዋም ገብታችሁ ከሰው ማንም ገና ያልተቀመጠበት ውርንጫ ታስሮ ታገኛላችሁ፥ ፈትታችሁም አምጡት። ");
INSERT INTO amh_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ማንም። ስለ ምን ትፈቱታላችሁ? ብሎ ቢጠይቃችሁ፥ እንዲሁ። ለጌታ ያስፈልገዋል በሉ አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","የተላኩትም ሄደው እንዳላቸው አገኙ። ");
INSERT INTO amh_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","እነርሱም ውርንጫውን ሲፈቱ ጌቶቹ። ውርንጫውን ስለ ምን ትፈቱታላችሁ? አሉአቸውም ");
INSERT INTO amh_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","እነርሱም። ለጌታ ያስፈልገዋል አሉ። ");
INSERT INTO amh_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ወደ ኢየሱስም አመጡት፥ በውርንጫውም ላይ ልብሳቸውን ጭነው ኢየሱስን አስቀመጡት። ");
INSERT INTO amh_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ሲሄድም ልብሳቸውን በመንገድ ያነጥፉ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ወደ ደብረ ዘይት ቍልቍለትም አሁን በቀረበ ጊዜ፥ ደቀ መዛሙርቱ ሁላቸው ደስ እያላቸው ተአምራትን ሁሉ ስላዩ በታላቅ ድምፅ እግዚአብሔርን ሊያመሰግኑ ጀምረው። ");
INSERT INTO amh_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","በጌታ ስም የሚመጣ ንጉሥ የተባረከ ነው፤ በሰማይ ሰላም በአርያምም ክብር አሉ። ");
INSERT INTO amh_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ከሕዝብም መካከል ከፈሪሳውያን አንዳንዱ። መምህር ሆይ፥ ደቀ መዛሙርትህን ገሥጻቸው አሉት። ");
INSERT INTO amh_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","መልሶም። እላችኋለሁ፥ እነዚህ ዝም ቢሉ ድንጋዮች ይጮኻሉ አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ሲቀርብም ከተማይቱን አይቶ አለቀሰላት፥ ");
INSERT INTO amh_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","እንዲህ እያለ። ለሰላምሽ የሚሆነውን በዚህ ቀን አንቺስ ስንኳ ብታውቂ፤ አሁን ግን ከዓይንሽ ተሰውሮአል። ");
INSERT INTO amh_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ወራት ይመጣብሻልና፥ ጠላቶችሽም ቅጥር ይቀጥሩብሻል ይከቡሻልም በየበኵሉም ያስጨንቁሻል፤ ");
INSERT INTO amh_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","አንቺንም በአንቺም ውስጥ የሚኖሩትን ልጆችሽን ወደ ታች ይጥላሉ፥ በአንቺ ውስጥም ድንጋይ በድንጋይ ላይ አይተዉም፥ የመጐብኘትሽን ዘመን አላወቅሽምና። ");
INSERT INTO amh_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ወደ መቅደስም ገብቶ በእርሱ የሚሸጡትን የሚገዙትንም ያወጣ ጀመር፤ ");
INSERT INTO amh_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","እርሱም። ቤቴ የጸሎት ቤት ይሆናል ተብሎ ተጽፎአል፤ እናንተ ግን የወንበዴዎች ዋሻ አደረጋችሁት አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ዕለት ዕለትም በመቅደስ ያስተምር ነበር፤ ነገር ግን የካህናት አለቆችና ጻፎች የሕዝቡ ታላላቆችም ሊገድሉት ይፈልጉ ነበር፥ ");
INSERT INTO amh_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","የሚያደርጉበትንም አጡ፤ ሕዝቡ ሁሉ ሲሰሙት ተንጠልጥለውበት ነበርና። ");
INSERT INTO amh_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","አንድ ቀንም ሕዝቡን በመቅደስ ሲያስተምር ወንጌልንም ሲሰብክላቸው፥ የካህናት አለቆችና ጻፎች ከሽማግሌዎች ጋር ወደ እርሱ ቀረቡና። ");
INSERT INTO amh_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","እስኪ ንገረን፤ እነዚህን በምን ሥልጣን ታደርጋለህ ወይስ ይህን ሥልጣን የሰጠህ ማን ነው? ብለው ተናገሩት። ");
INSERT INTO amh_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","መልሶም። እኔ ደግሞ አንዲት ነገር እጠይቃችኋለሁ፥ እናንተም ንገሩኝ፤ ");
INSERT INTO amh_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","የዮሐንስ ጥምቀት ከሰማይ ነበረችን ወይስ ከሰው? አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","እርስ በርሳቸውም ሲነጋገሩ። ከሰማይ ብንል። ስለ ምን አላመናችሁበትም? ይለናል፤ ");
INSERT INTO amh_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ከሰው ብንል ግን ሕዝቡ ሁሉ ይወግሩናል፤ ዮሐንስ ነቢይ እንደ ነበረ ሁሉ ያምኑ ነበርና አሉ። ");
INSERT INTO amh_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","መልሰውም። ከወዴት እንደ ሆነ አናውቅም አሉት። ");
INSERT INTO amh_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ኢየሱስም። እኔም በምን ሥልጣን እነዚህን እንዳደርግ አልነግራችሁም አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ይህንም ምሳሌ ለሕዝቡ ይላቸው ጀመር። አንድ ሰው የወይን አትክልት ተከለ ለገበሬዎችም አከራይቶ ለብዙ ዘመን ወደ ሌላ አገር ሄደ። ");
INSERT INTO amh_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","በጊዜውም ከወይኑ አትክልት ፍሬ እንዲሰጡት አንድ ባሪያ ወደ ገበሬዎች ላከ፤ ገበሬዎቹ ግን ደበደቡት ባዶውንም ሰደዱት። ");
INSERT INTO amh_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ጨምሮም ሌላውን ባሪያ ላከ፤ እነርሱም ያን ደግሞ ደበደቡት አዋርደውም ባዶውን ሰደዱት። ");
INSERT INTO amh_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ጨምሮም ሦስተኛውን ላከ፤ እነርሱም ይህን ደግሞ አቍሰለው አወጡት። ");
INSERT INTO amh_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","የወይኑም አትክልት ጌታ። ምን ላድርግ? የምወደውን ልጄን እልካለሁ፤ ምናልባት እርሱን አይተው ያፍሩታል አለ። ");
INSERT INTO amh_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ገበሬዎቹ ግን አይተውት እርስ በርሳቸው ሲነጋገሩ። ወራሹ ይህ ነው፤ ርስቱ ለእኛ እንዲሆን ኑ እንግደለው አሉ። ");
INSERT INTO amh_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ከወይኑም አትክልት ወደ ውጭ አውጥተው ገደሉት። እንግዲህ የወይኑ አትክልት ጌታ ምን ያደርጋቸዋል? ");
INSERT INTO amh_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ይመጣል እነዚህንም ገበሬዎች ያጠፋል፥ የወይኑንም አትክልት ለሌሎች ይሰጣል። ይህንም በሰሙ ጊዜ። ይህስ አይሁን አሉ። ");
INSERT INTO amh_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","እርሱ ግን ወደ እነርሱ ተመልክቶ። እንግዲህ። ግንበኞች የናቁት ድንጋይ እርሱ የማዕዘን ራስ ሆነ ተብሎ የተጻፈው ይህ ምንድር ነው? ");
INSERT INTO amh_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","በዚያም ድንጋይ ላይ የሚወድቅ ሁሉ ይቀጠቀጣል፤ የሚወድቅበትን ሁሉ ግን ይፈጨዋል አለ። ");
INSERT INTO amh_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","የካህናት አለቆችና ጻፎችም ይህን ምሳሌ በእነርሱ ላይ እንደ ተናገረ አውቀው በዚያች ሰዓት እጃቸውን ሊጭኑበት ፈለጉ ነገር ግን ሕዝቡን ፈሩ። ");
INSERT INTO amh_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ሲጠባበቁም ወደ ገዢ ግዛትና ሥልጣን አሳልፈው እንዲሰጡት ጻድቃን መስለው በቃሉ የሚያጠምዱትን ሸማቂዎች ሰደዱበት። ");
INSERT INTO amh_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ጠይቀውም። መምህር ሆይ፥ እውነትን እንድትናገርና እንድታስተምር ለሰው ፊትም እንዳታደላ እናውቃለን፥ በእውነት የእግዚአብሔርን መንገድ ታስተምራለህ እንጂ፤ ");
INSERT INTO amh_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ለቄሣር ግብር ልንሰጥ ተፈቅዶአልን? ወይስ አልተፈቀደም? አሉት። ");
INSERT INTO amh_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","እርሱ ግን ተንኰላቸውንም ተመልክቶ። ስለ ምን ትፈትኑኛላችሁ? አንድ ዲናር አሳዩኝ፤ ");
INSERT INTO amh_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","መልኩ ጽሕፈቱስ የማን ነው? አላቸው። መልሰውም። የቄሣር ነው አሉት። ");
INSERT INTO amh_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","እርሱም። እንኪያስ የቄሣርን ለቄሣር የእግዚአብሔርንም ለእግዚአብሔር አስረክቡ አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","በሕዝቡም ፊት በቃሉ ሊያጠምዱት አልቻሉም በመልሱም እየተደነቁ ዝም አሉ። ");
INSERT INTO amh_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ትንሣኤ ሙታንንም የሚክዱ ከሰዱቃውያን አንዳንዶቹ ቀርበው ጠየቁት፥ ");
INSERT INTO amh_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","እንዲህ ሲሉ። መምህር ሆይ፥ ሙሴ። ሚስት ያለችው የአንድ ሰው ወንድም ልጅ ሳይወልድ ቢሞት፥ ወንድሙ ሚስቱን አግብቶ ለወንድሙ ዘር ይተካ ብሎ ጻፈልን። ");
INSERT INTO amh_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","እንግዲያስ ሰባት ወንድማማች ነበሩ፤ የፊተኛውም ሚስት አግብቶ ልጅ ሳይወልድ ሞተ፤ ");
INSERT INTO amh_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","32","ከሁሉም በኋላ ሴቲቱ ደግሞ ሞተች። ");
INSERT INTO amh_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","እንግዲህ ሰባቱ አግብተዋታልና ሴቲቱ በትንሣኤ ከእነርሱ ለማንኛቸው ሚስት ትሆናለች? ");
INSERT INTO amh_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ኢየሱስም መልሶ እንዲህ አላቸው። የዚህ ዓለም ልጆች ያገባሉ ይጋባሉም፥ ");
INSERT INTO amh_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ያን ዓለምና ከሙታን ትንሣኤ ሊያገኙ የሚገባቸው እነዚያ ግን አያገቡም አይጋቡምም፥ እንደ መላእክት ናቸውና፥ ");
INSERT INTO amh_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ሊሞቱም ወደ ፊት አይቻላቸውም፥ የትንሣኤም ልጆች ስለ ሆኑ የእግዚአብሔር ልጆች ናቸው። ");
INSERT INTO amh_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ሙታን እንዲነሡ ግን ሙሴ ደግሞ በቍጥቋጦው ዘንድ ጌታን የአብርሃም አምላክ የይስሐቅም አምላክ የያዕቆብም አምላክ በማለቱ አስታወቀ፤ ");
INSERT INTO amh_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ሁሉ ለእርሱ ሕያዋን ስለ ሆኑ፥ የሕያዋን አምላክ ነው እንጂ የሙታን አይደለም። ");
INSERT INTO amh_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ከጻፎችም አንዳንዶቹ መልሰው። መምህር ሆይ፥ መልካም ተናገርህ አሉት። ");
INSERT INTO amh_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ወደ ፊትም አንድ ነገር ስንኳ ሊጠይቁት አልደፈሩም። ");
INSERT INTO amh_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","እንዲህም አላቸው። ክርስቶስ የዳዊት ልጅ ነው እንዴት ይላሉ? ");
INSERT INTO amh_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","44","እንግዲህ ዳዊት። ጌታ ብሎ ይጠራዋል፥ እንዴትስ ልጁ ይሆናል? ");
INSERT INTO amh_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ሕዝቡም ሁሉ ሲሰሙ ደቀ መዛሙርቱን። ");
INSERT INTO amh_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","ረጃጅም ልብስ ለብሰው መዞር ከሚፈልጉ፥ በገበያም ሰላምታ፥ በምኵራብም የከበሬታ ወንበር፥ በምሳም የከበሬታ ስፍራ ከሚወዱ ከጻፎች ተጠበቁ፤ ");
INSERT INTO amh_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","የመበለቶችን ቤት የሚበሉ ጸሎታቸውንም በማስረዘም የሚያመካኙ፥ እነዚህ የባሰ ፍርድ ይቀበላሉ አለ። ");
INSERT INTO amh_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ዓይኑንም አንሥቶ መባቸውን በመዝገብ የሚጥሉ ባለ ጠጎችን አየ። ");
INSERT INTO amh_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","አንዲትም ድሀ መበለት ሁለት ሳንቲም በዚያ ስትጥል አየና። ");
INSERT INTO amh_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","እውነት እላችኋለሁ፥ ይህች ድሀ መበለት ከሁሉ ይልቅ አብልጣ ጣለች፤ ");
INSERT INTO amh_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","እነዚህ ሁሉ ከትርፋቸው ወደ እግዚአብሔር መዝገብ ጥለዋልና፤ ይህች ግን ከጕድለትዋ የነበራትን ትዳርዋን ሁሉ ጣለች አለ። ");
INSERT INTO amh_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","አንዳንዶቹም ስለ መቅደስ በመልካም ድንጋይና በተሰጠው ሽልማት እንዳጌጠ ሲነጋገሩ። ይህማ የምታዩት ሁሉ፥ ");
INSERT INTO amh_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ድንጋይ በድንጋይ ላይ ሳይፈርስ በዚህ የማይቀርበት ዘመን ይመጣል አለ። ");
INSERT INTO amh_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","እነርሱም። መምህር ሆይ፥ እንግዲህ ይህ መቼ ይሆናል? ይህስ ይሆን ዘንድ እንዳለው ምልክቱ ምንድር ነው? ብለው ጠየቁት። ");
INSERT INTO amh_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","እንዲህም አለ። እንዳትስቱ ተጠንቀቁ፤ ብዙዎች። እኔ ነኝ፥ ዘመኑም ቀርቦአል እያሉ በስሜ ይመጣሉና፤ እነርሱን ተከትላችሁ አትሂዱ። ");
INSERT INTO amh_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ጦርንና ሁከትንም በሰማችሁ ጊዜ አትደንግጡ፤ ይህ አስቀድሞ ይሆን ዘንድ ግድ ነውና፥ ነገር ግን መጨረሻው ወዲያው አይሆንም። ");
INSERT INTO amh_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","በዚያን ጊዜ እንዲህ አላቸው። ሕዝብ በሕዝብ ላይ፥ መንግሥትም በመንግሥት ላይ ይነሣል፤ ");
INSERT INTO amh_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ታላቅም የምድር መናወጥና በልዩ ልዩ ስፍራ ቸነፈር ራብም ይሆናል፤ የሚያስፈራም ነገር ከሰማይም ታላቅ ምልክት ይሆናል። ");
INSERT INTO amh_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ከዚህም ሁሉ በፊት እጃቸውን በላያችሁ ይጭናሉ ያሳድዱአችሁማል፤ ስለ ስሜም ወደ ምኵራብና ወደ ወኅኒ አሳልፈው ይሰጡአችኋል፥ ወደ ነገሥታትና ወደ ገዥዎችም ይወስዱአችኋል፤ ");
INSERT INTO amh_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ይህም ለምስክርነት ይሆንላችኋል። ");
INSERT INTO amh_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ሰለዚህ እንዴት እንድትመልሱ አስቀድማችሁ እንዳታስቡ በልባችሁ አኑሩት፤ ");
INSERT INTO amh_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ወደረኞቻችሁ ሁሉ ሊቃወሙና ሊከራከሩ የማይችሉትን አፍና ጥበብ እሰጣችኋለሁና። ");
INSERT INTO amh_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ወላጆችም ስንኳ ወንድሞችም ዘመዶችም ወዳጆችም አሳልፈው ይሰጡአችኋል፥ ከእናንተም አንዳንዱን ይገድላሉ፤ ");
INSERT INTO amh_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","በሁሉም ስለ ስሜ የተጠላችሁ ትሆናላችሁ። ");
INSERT INTO amh_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ከራሳችሁም አንዲት ጠጉር ስንኳ አትጠፋም፤ ");
INSERT INTO amh_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","በመታገሣችሁም ነፍሳችሁን ታገኛላችሁ። ");
INSERT INTO amh_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ኢየሩሳሌም ግን በጭፍራ ተከባ ስታዩ በዚያን ጊዜ ጥፋትዋ እንደ ቀረበ እወቁ። ");
INSERT INTO amh_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","የዚያን ጊዜ በይሁዳ ያሉ ወደ ተራራዎች ይሽሹ፥ በመካከልዋም ያሉ ከእርስዋ ፈቀቅ ይበሉ፥ በገጠር ያሉም ወደ እርስዋ አይግቡ፤ ");
INSERT INTO amh_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","የተጻፈው ሁሉ እንዲፈጸም ይህ የበቀል ጊዜ ነውና። ");
INSERT INTO amh_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","በዚያን ወራት ለእርጕዞችና ለሚያጠቡ ወዮላቸው፤ ታላቅ ችግር በምድር ላይ፥ በዚህም ሕዝብ ላይ ቍጣ ይሆናልና፤ ");
INSERT INTO amh_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","በሰይፍ ስለትም ይወድቃሉ፤ ወደ አሕዛብ ሁሉም ይማረካሉ፤ የአሕዛብም ዘመን እስኪፈጸም ድረስ ኢየሩሳሌም በአሕዛብ የተረገጠች ትሆናለች። ");
INSERT INTO amh_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","በፀሐይና በጨረቃም በከዋክብትም ምልክት ይሆናል፤ በምድር ላይም አሕዛብ ከባሕሩና ከሞገዱም ድምፅ የተነሣ እያመነቱ ይጨነቃሉ፤ ");
INSERT INTO amh_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ሰዎችም ከፍርሃትና በዓለም የሚመጣበትን ከመጠበቅ የተነሣ ይደክማሉ፤ የሰማያት ኃይላት ይናወጣሉና። ");
INSERT INTO amh_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","በዚያን ጊዜም የሰው ልጅ በኃይልና በብዙ ክብር በደመና ሲመጣ ያዩታል። ");
INSERT INTO amh_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ይህም ሊሆን ሲጀምር ቤዛችሁ ቀርቦአልና አሻቅባችሁ ራሳችሁን አንሡ። ");
INSERT INTO amh_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ምሳሌንም ነገራቸው እንዲህ ሲል። በለስንና ዛፎችን ሁሉ እዩ፤ ");
INSERT INTO amh_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ሲያቈጠቍጡ ተመልክታችሁ በጋ አሁን እንደ ቀረበ ራሳችሁ ታውቃላችሁ። ");
INSERT INTO amh_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","እንዲሁ ደግሞ እናንተ ይህ ሁሉ መሆኑን ስታዩ የእግዚአብሔር መንግሥት እንደ ቀረበች እወቁ። ");
INSERT INTO amh_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","እውነት እላችኋለሁ፥ ይህ ሁሉ እስኪሆን ድረስ ይህ ትውልድ አያልፍም። ");
INSERT INTO amh_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ሰማይና ምድር ያልፋሉ ቃሌ ግን አያልፍም። ");
INSERT INTO amh_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ነገር ግን ልባችሁ በመጠጥ ብዛትና በስካር ስለ ትዳርም በማሰብ እንዳይከብድ፥ ያ ቀንም በድንገት እንዳይመጣባችሁ ለራሳችሁ ተጠንቀቁ፤ ");
INSERT INTO amh_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","በምድር ሁሉ ላይ በሚቀመጡ ሁሉ እንደ ወጥመድ ይደርስባቸዋልና። ");
INSERT INTO amh_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","እንግዲህ ሊመጣ ካለው ከዚህ ሁሉ ለማምለጥ፥ በሰው ልጅም ፊት ለመቆም እንድትችሉ ስትጸልዩ ሁል ጊዜ ትጉ። ");
INSERT INTO amh_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ዕለት ዕለትም በመቅደስ ያስተምር ነበር፥ ሌሊት ግን ደብረ ዘይት ወደምትባል ተራራ ወጥቶ ያድር ነበር። ");
INSERT INTO amh_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ሕዝቡም ሁሉ ይሰሙት ዘንድ ማልደው በመቅደስ ወደ እርሱ ይመጡ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ፋሲካም የሚባለው የቂጣ በዓል ቀረበ። ");
INSERT INTO amh_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","የካህናት አለቆችና ጻፎችም እንዴት እንዲያጠፉት ይፈልጉ ነበር፤ ሕዝቡን ይፈሩ ነበርና። ");
INSERT INTO amh_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ሰይጣንም ከአሥራ ሁለቱ ቍጥር አንዱ በነበረው የአስቆሮቱ በሚባለው በይሁዳ ገባ፤ ");
INSERT INTO amh_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ሄዶም እንዴት አሳልፎ እንዲሰጣቸው ከካህናት አለቆችና ከመቅደስ አዛዦች ጋር ተነጋገረ። ");
INSERT INTO amh_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","እነርሱም ደስ አላቸው፥ ገንዘብም ሊሰጡት ተዋዋሉ። ");
INSERT INTO amh_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","እሺም አለ፥ ሕዝብም በሌለበት አሳልፎ እንዲሰጣቸው ምቹ ጊዜ ይፈልግ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ፋሲካንም ሊያርዱበት የሚገባው የቂጣ በዓል ደረሰ፤ ");
INSERT INTO amh_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ጴጥሮስንና ዮሐንስንም። ፋሲካን እንድንበላ ሄዳችሁ አዘጋጁልን ብሎ ላካቸው። ");
INSERT INTO amh_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","እነርሱም። ወዴት እናዘጋጅ ዘንድ ትወዳለህ? አሉት። ");
INSERT INTO amh_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","እርሱም አላቸው። እነሆ፥ ወደ ከተማ ስትገቡ ማድጋ ውኃ የተሸከመ ሰው ይገናኛችኋል፤ ወደ ሚገባበት ቤት ተከተሉት፤ ");
INSERT INTO amh_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ለባለቤቱም። መምህሩ። ከደቀ መዛሙርቴ ጋር ፋሲካን የምበላበት የእንግዳ ቤት ክፍል ወዴት ነው? ይልሃል በሉት፤ ");
INSERT INTO amh_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ያም በደርብ ላይ ያለውን የተነጠፈ ታላቅ አዳራሽ ያሳያችኋል፤ በዚያም አሰናዱልን። ");
INSERT INTO amh_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ሄደውም እንዳላቸው አገኙና ፋሲካን አሰናዱ። ");
INSERT INTO amh_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ሰዓቱም በደረሰ ጊዜ ከአሥራ ሁለቱ ሐዋርያት ጋር በማዕድ ተቀመጠ። ");
INSERT INTO amh_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","እርሱም። ከመከራዬ በፊት ከእናንተ ጋር ይህን ፋሲካ ልበላ እጅግ እመኝ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","እላችኋለሁና፥ በእግዚአብሔር መንግሥት እስኪፈጸም ድረስ፥ ወደ ፊት ከዚህ አልበላም አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ጽዋንም ተቀበለ አመስግኖም። ይህን እንካችሁ በመካከላችሁም ተካፈሉት፤ ");
INSERT INTO amh_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","እላችኋለሁና፥ የእግዚአብሔር መንግሥት እስክትመጣ ድረስ ከአሁን ጀምሮ ከወይኑ ፍሬ አልጠጣም አለ። ");
INSERT INTO amh_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","እንጀራንም አንሥቶ አመሰገነ ቆርሶም ሰጣቸውና። ስለ እናንተ የሚሰጠው ሥጋዬ ይህ ነው፤ ይህን ለመታሰቢያዬ አድርጉት አለ። ");
INSERT INTO amh_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","እንዲሁም ከእራት በኋላ ጽዋውን አንሥቶ እንዲህ አለ። ይህ ጽዋ ስለ እናንተ በሚፈሰው በደሜ የሚሆን አዲስ ኪዳን ነው። ");
INSERT INTO amh_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ነገር ግን አሳልፎ የሚሰጠኝ እጅ እነሆ በማዕድ ከእኔ ጋር ናት። ");
INSERT INTO amh_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","የሰው ልጅስ እንደ ተወሰነው ይሄዳል፥ ነገር ግን አልፎ ለሚሰጥበት ለዚያ ሰው ወዮለት። ");
INSERT INTO amh_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ከእነርሱም ይህን ሊያደርግ ያለው ማን እንደ ሆነ እርስ በርሳቸው ይጠያየቁ ጀመር። ");
INSERT INTO amh_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ደግሞም ማናቸውም ታላቅ ሆኖ እንዲቈጠር በመካከላቸው ክርክር ሆነ። ");
INSERT INTO amh_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","እንዲህም አላቸው። የአሕዛብ ነገሥታት ይገዙአቸዋል፥ በላያቸውም የሚሠለጥኑት ቸርነት አድራጊዎች ይባላሉ። ");
INSERT INTO amh_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","እናንተ ግን እንዲህ አትሁኑ፤ ነገር ግን ከእናንተ ታላቅ የሆነ በመካከላችሁ እንደ ታናሽ፥ የሚገዛም እንደሚያገለግል ይሁን። ");
INSERT INTO amh_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","በማዕድ የተቀመጠ ወይስ የሚያገለግል ማናቸው ታላቅ ነው? የተቀመጠው አይደለምን? እኔ ግን በመካከላችሁ እንደሚያገለግል ነኝ። ");
INSERT INTO amh_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ነገር ግን እናንተ በፈተናዎቼ ከእኔ ጋር ጸንታችሁ የኖራችሁ ናችሁ፤ ");
INSERT INTO amh_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","31","ጌታም። ስምዖን ስምዖን ሆይ፥ እነሆ፥ ሰይጣን እንደ ስንዴ ሊያበጥራችሁ ለመነ፤ ");
INSERT INTO amh_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","እኔ ግን እምነትህ እንዳይጠፋ ስለ አንተ አማለድሁ፤ አንተም በተመለስህ ጊዜ ወንድሞችህን አጽና አለ። ");
INSERT INTO amh_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","እርሱም። ጌታ ሆይ፥ ወደ ወኅኒም ወደ ሞትም ከአንተ ጋር ለመሄድ የተዘጋጀሁ ነኝ አለው። ");
INSERT INTO amh_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","እርሱ ግን። ጴጥሮስ ሆይ፥ እልሃለሁ፥ እንዳታውቀኝ ሦስት ጊዜ እስክትክደኝ ድረስ ዛሬ ዶሮ አይጮኽም አለው። ");
INSERT INTO amh_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ደግሞም። ያለ ኮረጆና ያለ ከረጢት ያለ ጫማም በላክኋችሁ ጊዜ፥ አንዳች ጐደለባችሁን? አላቸው። እነርሱም። አንዳች እንኳ አሉ። ");
INSERT INTO amh_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","እርሱም። አሁን ግን ኮረጆ ያለው ከእርሱ ጋር ይውሰድ፥ ከረጢትም ያለው እንዲሁ፤ የሌለውም ልብሱን ሽጦ ሰይፍ ይግዛ። ");
INSERT INTO amh_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","እላችኋለሁና፥ ይህ። ከዓመፀኞች ጋር ተቈጠረ ተብሎ የተጻፈው በእኔ ሊፈጸም ግድ ነው፤ አዎን፥ ስለ እኔ የሚሆነው አሁን ይፈጸማልና አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","እነርሱም። ጌታ ሆይ፥ እነሆ፥ በዚህ ሁለት ሰይፎች አሉ አሉት። እርሱም። ይበቃል አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ወጥቶም እንደ ልማዱ ወደ ደብረ ዘይት ሄደ፤ ደቀ መዛሙርቱም ደግሞ ተከተሉት። ");
INSERT INTO amh_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ወደ ስፍራውም ደርሶ። ወደ ፈተና እንዳትገቡ ጸልዩ አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ከእነርሱም የድንጋይ ውርወራ የሚያህል ራቀ፥ ተንበርክኮም። አባት ሆይ፥ ");
INSERT INTO amh_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ብትፈቅድ ይህችን ጽዋ ከእኔ ውሰድ፤ ነገር ግን የእኔ ፈቃድ አይሁን የአንተ እንጂ እያለ ይጸልይ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ከሰማይም መጥቶ የሚያበረታ መልአክ ታየው። ");
INSERT INTO amh_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","በፍርሃትም ሲጣጣር አጽንቶ ይጸልይ ነበር፤ ወዙም በምድር ላይ እንደሚወርድ እንደ ደም ነጠብጣብ ነበረ። ");
INSERT INTO amh_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ከጸሎትም ተነሥቶ ወደ ደቀ መዛሙርቱ መጣና ከኀዘን የተነሣ ተኝተው ሲያገኛቸው። ");
INSERT INTO amh_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ስለ ምን ትተኛላችሁ? ወደ ፈተና እንዳትገቡ ተነሥታችሁ ጸልዩ አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ገናም ሲናገር እነሆ፥ ሰዎች መጡ፤ ከአሥራ ሁለቱ አንዱም ይሁዳ የሚባለው ይቀድማቸው ነበር፥ ሊስመውም ወደ ኢየሱስ ቀረበ። ");
INSERT INTO amh_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ኢየሱስ ግን። ይሁዳ ሆይ፥ በመሳም የሰውን ልጅ አሳልፈህ ትሰጣለህን? አለው። ");
INSERT INTO amh_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","በዙሪያውም የነበሩት የሚሆነውን ባዩ ጊዜ። ጌታ ሆይ፥ በሰይፍ እንምታቸውን? አሉት። ");
INSERT INTO amh_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ከእነርሱም አንዱ የሊቀ ካህናቱን ባሪያ መትቶ ቀኝ ጆሮውን ቈረጠው። ");
INSERT INTO amh_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ኢየሱስ ግን መልሶ። ይህንስ ፍቀዱ አለ፤ ጆሮውንም ዳስሶ ፈወሰው። ");
INSERT INTO amh_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ኢየሱስም ወደ እርሱ ለመጡበት ለካህናት አለቆችና ለመቅደስ አዛዦች ለሽማግሌዎችም። ወንበዴን እንደምትይዙ ሰይፍና ጐመድ ይዛችሁ ወጣችሁን? ");
INSERT INTO amh_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","በመቅደስ ዕለት ዕለት ከእናንተ ጋር ስሆን እጆቻችሁን አልዘረጋችሁብኝም፤ ይህ ግን ጊዜያችሁና የጨለማው ሥልጣን ነው አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ይዘውም ወሰዱት ወደ ሊቀ ካህናት ቤትም አገቡት፤ ጴጥሮስም ርቆ ይከተለው ነበር። ");
INSERT INTO amh_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","በግቢ መካከልም እሳት አንድደው በአንድነት ተቀምጠው ሳሉ ጴጥሮስ በመካከላቸው ተቀመጠ። ");
INSERT INTO amh_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","በብርሃኑም በኩል ተቀምጦ ሳለ አንዲት ገረድ አየችውና ትኵር ብላ። ይህ ደግሞ ከእርሱ ጋር ነበረ አለች። ");
INSERT INTO amh_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","እርሱ ግን። አንቺ ሴት፥ አላውቀውም ብሎ ካደ። ");
INSERT INTO amh_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ከጥቂት ጊዜም በኋላ ሌላው አይቶት። አንተ ደግሞ ከእነርሱ ወገን ነህ አለው። ጴጥሮስ ግን። አንተ ሰው፥ እኔ አይደለሁም አለ። ");
INSERT INTO amh_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","አንድ ሰዓትም የሚያህል ቆይቶ ሌላው አስረግጦ። እርሱ የገሊላ ሰው ነውና በእውነት ይህ ደግሞ ከእርሱ ጋር ነበረ አለ። ");
INSERT INTO amh_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ጴጥሮስ ግን። አንተ ሰው፥ የምትለውን አላውቅም አለ። ያን ጊዜም ገና ሲናገር ዶሮ ጮኸ። ");
INSERT INTO amh_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ጌታም ዘወር ብሎ ጴጥሮስን ተመለከተው፤ ጴጥሮስም። ዛሬ ዶሮ ሳይጮኽ ሦስት ጊዜ ትክደኛለህ እንዳለው የጌታ ቃል ትዝ አለው። ");
INSERT INTO amh_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ጴጥሮስም ወደ ውጭ ወጥቶ ምርር ብሎ አለቀሰ። ");
INSERT INTO amh_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ኢየሱስንም የያዙት ሰዎች ይዘብቱበትና ይደበድቡት ነበር፤ ");
INSERT INTO amh_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ሸፍነውም ፊቱን ይመቱት ነበርና። በጥፊ የመታህ ማን ነው? ትንቢት ተናገር እያሉ ይጠይቁት ነበር። ");
INSERT INTO amh_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ሌላም ብዙ ነገር እየተሳደቡ በእርሱ ላይ ይናገሩ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","በነጋም ጊዜ የሕዝቡ ሽማግሌዎችና የካህናት አለቆች ጻፎችም ተሰብስበው ወደ ሸንጎአቸው ወሰዱትና ");
INSERT INTO amh_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ክርስቶስ አንተ ነህን? ንገረን አሉት። እርሱ ግን እንዲህ አላቸው። ብነግራችሁ አታምኑም፤ ");
INSERT INTO amh_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ብጠይቅም አትመልሱልኝም አትፈቱኝምም። ");
INSERT INTO amh_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ነገር ግን ከአሁን ጀምሮ የሰው ልጅ በእግዚአብሔር ኃይል ቀኝ ይቀመጣል። ");
INSERT INTO amh_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ሁላቸውም። እንግዲያስ አንተ የእግዚአብሔር ልጅ ነህን? አሉት። እርሱም። እኔ እንደ ሆንሁ እናንተ ትላላችሁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","እነርሱም። ራሳችን ከአፉ ሰምተናልና ከእንግዲህ ወዲህ ምን ምስክር ያስፈልገናል? አሉ። ");
INSERT INTO amh_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ሁሉም በሞላው ተነሥተው ወደ ጲላጦስ ወሰዱትና። ");
INSERT INTO amh_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ይህ ሕዝባችንን ሲያጣምም ለቄሣርም ግብር እንዳይሰጥ ሲከለክል ደግሞም። እኔ ክርስቶስ ንጉሥ ነኝ ሲል አገኘነው ብለው ይከሱት ጀመር። ");
INSERT INTO amh_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ጲላጦስም። አንተ የአይሁድ ንጉሥ ነህን? ብሎ ጠየቀው። እርሱም መልሶ። አንተ አልህ አለው። ");
INSERT INTO amh_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ጲላጦስም ለካህናት አለቆችና ለሕዝቡ። በዚህ ሰው አንድ በደል ስንኳ አላገኘሁበትም አለ። ");
INSERT INTO amh_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","እነርሱ ግን አጽንተው። ከገሊላ ጀምሮ እስከዚህ ድረስ በይሁዳ ሁሉ እያስተማረ ሕዝቡን ያውካል አሉ። ");
INSERT INTO amh_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ጲላጦስ ግን። ገሊላ ሲሉ በሰማ ጊዜ። የገሊላ ሰው ነውን? ብሎ ጠየቀ፤ ");
INSERT INTO amh_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ከሄሮድስም ግዛት እንደ ሆነ ባወቀ ጊዜ ወደ ሄሮድስ ሰደደው፤ እርሱ ደግሞ በዚያ ጊዜ በኢየሩሳሌም ነበረና። ");
INSERT INTO amh_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ሄሮድስም ኢየሱስን ባየው ጊዜ እጅግ ደስ አለው፤ ስለ እርሱ ስለ ሰማ ከብዙ ጊዜ ጀምሮ ሊያየው ይመኝ ነበርና፥ ምልክትም ሲያደርግ ሊያይ ተስፋ ያደርግ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","በብዙ ቃልም ጠየቀው፤ እርሱ ግን አንድ ስንኳ አልመለሰለትም። ");
INSERT INTO amh_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","የካህናት አለቆችና ጻፎችም አጽንተው ሲከሱት ቆመው ነበር። ");
INSERT INTO amh_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ሄሮድስም ከሠራዊቱ ጋር ናቀው ዘበተበትም፥ የጌጥ ልብስም አልብሶ ወደ ጲላጦስ መልሶ ሰደደው። ");
INSERT INTO amh_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ሄሮድስና ጲላጦስም በዚያን ቀን እርስ በርሳቸው ወዳጆች ሆኑ፥ ቀድሞ በመካከላቸው ጥል ነበረና። ");
INSERT INTO amh_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ጲላጦስም፥ የካህናትን አለቆችና መኳንንትን ሕዝቡንም በአንድነት ጠርቶ እንዲህ አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ሕዝቡን ያጣምማል ብላችሁ ይህን ሰው ወደ እኔ አመጣችሁት፤ እነሆም፥ በፊታችሁ መርምሬ ከምትከሱበት ነገር አንድ በደል ስንኳ በዚህ ሰው አላገኘሁበትም። ");
INSERT INTO amh_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ሄሮድስም ደግሞ ምንም አላገኘም፤ ወደ እኛ መልሶታልና፤ እነሆም፥ ለሞት የሚያደርሰው ምንም አላደረገም፤ ");
INSERT INTO amh_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","18","ሁላቸውም በአንድነት። ይህን አስወግድ፥ በርባንንም ፍታልን እያሉ ጮኹ፤ ");
INSERT INTO amh_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","እርሱም ሁከትን በከተማ አንሥቶ ሰውን ስለ ገደለ በወኅኒ ታስሮ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ጲላጦስም ኢየሱስን ሊፈታ ወድዶ ዳግመኛ ተናገራቸው፤ ");
INSERT INTO amh_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ነገር ግን እነርሱ። ስቀለው ስቀለው እያሉ ይጮኹ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ሦስተኛም። ምን ነው? ያደረገውስ ክፋት ምንድር ነው? ለሞት የሚያደርሰው በደል አላገኘሁበትም፤ ስለዚህ ቀጥቼ እፈታዋለሁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","እነርሱ ግን እንዲሰቀል በታላቅ ድምፅ አጽንተው ለመኑት። የእነርሱ ጩኸትና የካህናት አለቆችም ቃል በረታ። ");
INSERT INTO amh_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ጲላጦስም ልመናቸው እንዲሆንላቸው ፈረደበት። ");
INSERT INTO amh_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ያንን የለመኑትንም፥ ስለ ሁከት ሰውንም ስለ መግደል በወኅኒ ታስሮ የነበረውን አስፈታላቸው፥ ኢየሱስን ግን ለፈቃዳቸው አሳልፎ ሰጠው። ");
INSERT INTO amh_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","በወሰዱትም ጊዜ ስምዖን የተባለ የቀሬናን ሰው ከገጠር ሲመጣ ይዘው ከኢየሱስ በኋላ መስቀሉን እንዲሸከም ጫኑበት። ");
INSERT INTO amh_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ዋይ ዋይ ከሚሉና ሙሾ ከሚያወጡ ሴቶችና ከሕዝቡ እጅግ ብዙዎች ተከተሉት። ");
INSERT INTO amh_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","30","በዚያን ጊዜ ተራራዎችን። በላያችን ውደቁ፥ ኮረብቶችንም። ሰውሩን ይሉ ዘንድ ይጀምራሉ፤ ");
INSERT INTO amh_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","በእርጥብ እንጨት እንዲህ የሚያደርጉ ከሆኑ፥ በደረቀውስ እንዴት ይሆን? ");
INSERT INTO amh_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ሌሎችንም ሁለት ክፉ አድራጊዎች ደግሞ ከእርሱ ጋር ይገድሉ ዘንድ ወሰዱ። ");
INSERT INTO amh_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ቀራንዮም ወደሚባል ስፍራ በደረሱ ጊዜ፥ በዚያ እርሱን ክፉ አድራጊዎቹንም አንዱን በቀኝ ሁለተኛውንም በግራ ሰቀሉ። ");
INSERT INTO amh_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ኢየሱስም። አባት ሆይ፥ የሚያደርጉትን አያውቁምና ይቅር በላቸው አለ። ልብሱንም ተካፍለው ዕጣ ተጣጣሉበት። ");
INSERT INTO amh_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ሕዝቡም ቆመው ይመለከቱ ነበር። መኳንንቱም ደግሞ። ሌሎችን አዳነ፤ እርሱ በእግዚአብሔር የተመረጠው ክርስቶስ ከሆነ፥ ራሱን ያድን እያሉ ያፌዙበት ነበር። ");
INSERT INTO amh_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ጭፍሮችም ደግሞ ወደ እርሱ ቀርበው ሆምጣጤም አምጥተው። ");
INSERT INTO amh_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","አንተስ የአሁድ ንጉሥ ከሆንህ፥ ራስህን አድን እያሉ ይዘብቱበት ነበር። ");
INSERT INTO amh_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ይህ የአይሁድ ንጉሥ ነው ተብሎ በግሪክና በሮማይስጥ በዕብራይስጥም ፊደል የተጻፈ ጽሕፈት ደግሞ በእርሱ ላይ ነበረ። ");
INSERT INTO amh_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ከተሰቀሉት ከክፉ አድራጊዎቹም አንዱ። አንተስ ክርስቶስ አይደለህምን? ራስህንም እኛንም አድን ብሎ ሰደበው። ");
INSERT INTO amh_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ሁለተኛው ግን መልሶ። አንተ እንደዚህ ባለ ፍርድ ሳለህ እግዚአብሔርን ከቶ አትፈራውምን? ");
INSERT INTO amh_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ስለ አደረግነውም የሚገባንን እንቀበላለንና በእኛስ እውነተኛ ፍርድ ነው፤ ይህ ግን ምንም ክፋት አላደረገም ብሎ ገሠጸው። ");
INSERT INTO amh_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ኢየሱስንም። ጌታ ሆይ፥ በመንግሥትህ በመጣህ ጊዜ አስበኝ አለው። ");
INSERT INTO amh_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ኢየሱስም። እውነት እልሃለሁ፥ ዛሬ ከእኔ ጋር በገነት ትሆናለህ አለው። ");
INSERT INTO amh_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ስድስት ሰዓትም ያህል ነበረ፥ ጨለማም እስከ ዘጠኝ ሰዓት በምድር ሁሉ ላይ ሆነ፥ ፀሐይም ጨለመ፥ ");
INSERT INTO amh_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","የቤተ መቅደስም መጋረጃ ከመካከሉ ተቀደደ። ");
INSERT INTO amh_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ኢየሱስም በታላቅ ድምፅ ጮኾ። አባት ሆይ፥ ነፍሴን በእጅህ አደራ እሰጣለሁ አለ። ይህንም ብሎ ነፍሱን ሰጠ። ");
INSERT INTO amh_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","የመቶ አለቃውም የሆነውን ነገር ባየ ጊዜ። ይህ ሰው በእውነት ጻድቅ ነበረ ብሎ እግዚአብሔርን አከበረ። ");
INSERT INTO amh_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ይህንም ለማየት ተከማችተው የነበሩ ሕዝብ ሁሉ፥ የሆነውን ባዩ ጊዜ፥ ደረታቸውን እየደቁ ተመለሱ። ");
INSERT INTO amh_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","የሚያውቁቱ ግን ሁሉ ከገሊላ የተከተሉት ሴቶችም ይህን እያዩ በሩቅ ቆመው ነበር። ");
INSERT INTO amh_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","እነሆም፥ በጎና ጻድቅ ሰው የሸንጎ አማካሪም የሆነ ዮሴፍ የሚባል ሰው ነበረ፤ ");
INSERT INTO amh_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ይህም በምክራቸውና በሥራቸው አልተባበረም ነበር፤ አርማትያስም ከምትባል ከአይሁድ ከተማ ሆኖ እርሱ ደግሞ የእግዚአብሔርን መንግሥት ይጠባበቅ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ይኸውም ወደ ጲላጦስ ቀርቦ የኢየሱስን ሥጋ ለመነው፤ ");
INSERT INTO amh_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","አውርዶም በተልባ እግር ልብስ ከፈነው፥ ማንም ገና ባልተቀበረበት ከዓለትም በተወቀረ መቃብር አኖረው። ");
INSERT INTO amh_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","የመዘጋጀት ቀንም ነበረ፤ ሰንበትም ሊጀምር ነበረ። ");
INSERT INTO amh_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ከገሊላም ከእርሱ ጋር የመጡት ሴቶች ተከትለው መቃብሩን ሥጋውንም እንዴት እንዳኖሩት አዩ። ");
INSERT INTO amh_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ተመልሰውም ሽቱና ቅባት አዘጋጁ። በሰንበትም እንደ ትእዛዙ ዐረፉ። ");
INSERT INTO amh_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ነገር ግን ከሳምንቱ በመጀመሪያው ቀን ያዘጋጁትን ሽቱ ይዘው ከእነርሱም ጋር አንዳንዶቹ ወደ መቃብሩ እጅግ ማልደው መጡ። ");
INSERT INTO amh_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ድንጋዩንም ከመቃብሩ ተንከባሎ አገኙት፥ ");
INSERT INTO amh_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ገብተውም የጌታን የኢየሱስን ሥጋ አላገኙም። ");
INSERT INTO amh_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","እነርሱም በዚህ ሲያመነቱ፥ እነሆ፥ ሁለት ሰዎች የሚያንጸባርቅ ልብስ ለብሰው ወደ እነርሱ ቀረቡ፤ ");
INSERT INTO amh_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ፈርተውም ፊታቸውን ወደ ምድር አቀርቅረው ሳሉ፥ እንዲህ አሉአቸው። ሕያውን ከሙታን መካከል ስለ ምን ትፈልጋላችሁ? ተነሥቶአል እንጂ በዚህ የለም። ");
INSERT INTO amh_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","10","ይህንም ለሐዋርያት የነገሩአቸው መግደላዊት ማርያምና ዮሐና የያዕቆብም እናት ማርያም ከእነርሱም ጋር የነበሩት ሌሎች ሴቶች ነበሩ። ");
INSERT INTO amh_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ይህም ቃል ቅዠት መስሎ ታያቸውና አላመኑአቸውም። ");
INSERT INTO amh_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ጴጥሮስ ግን ተነሥቶ ወደ መቃብር ሮጠ፤ በዚያም ዝቅ ብሎ ሲመለከት የተልባ እግር ልብስን ብቻ አየ፤ በሆነውም ነገር እየተደነቀ ወደ ቤቱ ሄደ። ");
INSERT INTO amh_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","እነሆም፥ ከእነርሱ ሁለቱ በዚያ ቀን ከኢየሩሳሌም ስድሳ ምዕራፍ ያህል ወደሚርቅ ኤማሁስ ወደሚባል መንደር ይሄዱ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ስለዚህም ስለ ሆነው ነገር ሁሉ እርስ በርሳቸው ይነጋገሩ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ሲነጋገሩና ሲመራመሩም፥ ኢየሱስ ራሱ ቀርቦ ከእነርሱ ጋር ይሄድ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ነገር ግን እንዳያውቁት ዓይናቸው ተይዞ ነበር። ");
INSERT INTO amh_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","እርሱም። እየጠወለጋችሁ ስትሄዱ፥ እርስ በርሳችሁ የምትነጋገሩአቸው እነዚህ ነገሮች ምንድር ናቸው? አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ቀለዮጳ የሚባልም አንዱ መልሶ። አንተ በኢየሩሳሌም እንግዳ ሆነህ ለብቻህ ትኖራለህን? በእነዚህ ቀኖች በዚያ የሆነውን ነገር አታውቅምን? አለው። ");
INSERT INTO amh_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","እርሱም። ይህ ምንድር ነው? አላቸው። እነርሱም እንዲህ አሉት። በእግዚአብሔርና በሕዝቡ ሁሉ ፊት በሥራና በቃል ብርቱ ነቢይ ስለ ነበረው ስለ ናዝሬቱ ስለ ኢየሱስ፤ ");
INSERT INTO amh_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","እርሱንም የካህናት አለቆችና መኳንንቶቻችን ለሞት ፍርድ እንዴት አሳልፈው እንደ ሰጡትና እንደ ሰቀሉት ነው። ");
INSERT INTO amh_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","እኛ ግን እስራኤልን እንዲቤዥ ያለው እርሱ እንደ ሆነ ተስፋ አድርገን ነበር፤ ደግሞም ከዚህ ሁሉ ጋር ይህ ከሆነ ዛሬ ሦስተኛው ቀን ነው። ");
INSERT INTO amh_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ደግሞም ከእኛ ውስጥ ማልደው ከመቃብሩ ዘንድ የነበሩት አንዳንድ ሴቶች አስገረሙን፤ ");
INSERT INTO amh_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ሥጋውንም ባጡ ጊዜ። ሕያው ነው የሚሉ የመላእክትን ራእይ ደግሞ አየን ሲሉ መጥተው ነበር። ");
INSERT INTO amh_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ከእኛም ጋር ከነበሩት ወደ መቃብር ሄደው ሴቶች እንደ ተናገሩት ሆኖ አገኙት፥ እርሱን ግን አላዩትም። ");
INSERT INTO amh_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","እርሱም። እናንተ የማታስተውሉ፥ ነቢያትም የተናገሩትን ሁሉ ልባችሁ ከማመን የዘገየ፤ ");
INSERT INTO amh_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ክርስቶስ ይህን መከራ ይቀበል ዘንድና ወደ ክብሩ ይገባ ዘንድ ይገባው የለምን? አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ከሙሴና ከነቢያት ሁሉ ጀምሮ ስለ እርሱ በመጻሕፍት ሁሉ የተጻፈውን ተረጐመላቸው። ");
INSERT INTO amh_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ወደሚሄዱበትም መንደር ቀረቡ፥ እርሱም ሩቅ የሚሄድ መሰላቸው። ");
INSERT INTO amh_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","እነርሱ። ከእኛ ጋር እደር፥ ማታ ቀርቦአልና ቀኑም ሊመሽ ጀምሮአል ብለው ግድ አሉት፤ ከእነርሱም ጋር ሊያድር ገባ። ");
INSERT INTO amh_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ከእነርሱም ጋር በማዕድ ተቀምጦ ሳለ እንጀራውን አንሥቶ ባረከው፥ ቈርሶም ሰጣቸው፤ ");
INSERT INTO amh_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ዓይናቸውም ተከፈተ፥ አወቁትም፤ እርሱም ከእነርሱ ተሰወረ። ");
INSERT INTO amh_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","እርስ በርሳቸውም። በመንገድ ሲናገረን መጻሕፍትንም ሲከፍትልን ልባችን ይቃጠልብን አልነበረምን? ተባባሉ። ");
INSERT INTO amh_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","35","እነርሱም በመንገድ የሆነውን እንጀራውንም በቈረሰ ጊዜ እንዴት እንደ ታወቀላቸው ተረኩላቸው። ");
INSERT INTO amh_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ይህንም ሲነጋገሩ ኢየሱስ ራሱ በመካከላቸው ቆሞ። ሰላም ለእናንተ ይሁን አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ነገር ግን ደነገጡና ፈሩ መንፈስም ያዩ መሰላቸው። ");
INSERT INTO amh_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","እርሱም። ስለ ምን ትደነግጣላችሁ? ስለ ምንስ አሳብ በልባችሁ ይነሣል? ");
INSERT INTO amh_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","እኔ ራሴ እንደ ሆንሁ እጆቼንና እግሮቼን እዩ፤ በእኔ እንደምታዩት፥ መንፈስ ሥጋና አጥንት የለውምና እኔን ዳስሳችሁ እዩ አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ይህንም ብሎ እጆቹንና እግሮቹን አሳያቸው። ");
INSERT INTO amh_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","እነርሱም ከደስታ የተነሣ ገና ስላላመኑ ሲደነቁ ሳሉ። በዚህ አንዳች የሚበላ አላችሁን? አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","እነርሱም ከተጠበሰ ዓሣ አንድ ቁራጭ፥ ከማር ወለላም ሰጡት፤ ");
INSERT INTO amh_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ተቀብሎም በፊታቸው በላ። ");
INSERT INTO amh_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","እርሱም። ከእናንተ ጋር ሳለሁ በሙሴ ሕግና በነቢያት በመዝሙራትም ስለ እኔ የተጻፈው ሁሉ ይፈጸም ዘንድ ይገባል ብዬ የነገርኋችሁ ቃሌ ይህ ነው አላቸው። ");
INSERT INTO amh_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","በዚያን ጊዜም መጻሕፍትን ያስተውሉ ዘንድ አእምሮአቸውን ከፈተላቸው፤ ");
INSERT INTO amh_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","እንዲህም አላቸው። ክርስቶስ መከራ ይቀበላል በሦስተኛውም ቀን ከሙታን ይነሣል፥ ");
INSERT INTO amh_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","በስሙም ንስሐና የኃጢአት ስርየት ከኢየሩሳሌም ጀምሮ በአሕዛብ ሁሉ ይሰበካል ተብሎ እንዲሁ ተጽፎአል። ");
INSERT INTO amh_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","እናንተም ለዚህ ምስክሮች ናችሁ። ");
INSERT INTO amh_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","እነሆም፥ አባቴ የሰጠውን ተስፋ እኔ እልክላችኋለሁ፤ እናንተ ግን ከላይ ኃይል እስክትለብሱ ድረስ በኢየሩሳሌም ከተማ ቆዩ። ");
INSERT INTO amh_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","እስከ ቢታንያም አወጣቸው እጆቹንም አንሥቶ ባረካቸው። ");
INSERT INTO amh_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ሲባርካቸውም ከእነርሱ ተለየ ወደ ሰማይም ዐረገ። ");
INSERT INTO amh_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","እነርሱም፤ ሰገዱለትና በብዙ ደስታ ወደ ኢየሩሳሌም ተመለሱ፥ ");
INSERT INTO amh_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ዘወትርም እግዚአብሔርን እያመሰገኑና እየባረኩ በመቅደስ ኖሩ። ");
INSERT INTO amh_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","በመጀመሪያው ቃል ነበረ፥ ቃልም በእግዚአብሔር ዘንድ ነበረ፥ ቃልም እግዚአብሔር ነበረ። ");
INSERT INTO amh_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ይህ በመጀመሪያው በእግዚአብሔር ዘንድ ነበረ። ");
INSERT INTO amh_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ሁሉ በእርሱ ሆነ፥ ከሆነውም አንዳች ስንኳ ያለ እርሱ አልሆነም። ");
INSERT INTO amh_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","በእርሱ ሕይወት ነበረች፥ ሕይወትም የሰው ብርሃን ነበረች። ");
INSERT INTO amh_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ብርሃንም በጨለማ ይበራል፥ ጨለማም አላሸነፈውም። ");
INSERT INTO amh_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ከእግዚአብሔር የተላከ ስሙ ዮሐንስ የሚባል አንድ ሰው ነበረ፤ ");
INSERT INTO amh_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ሁሉ በእርሱ በኩል እንዲያምኑ ይህ ስለ ብርሃን ይመሰክር ዘንድ ለምስክር መጣ። ");
INSERT INTO amh_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ስለ ብርሃን ሊመሰክር መጣ እንጂ፥ እርሱ ብርሃን አልነበረም። ");
INSERT INTO amh_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ለሰው ሁሉ የሚያበራው እውነተኛው ብርሃን ወደ ዓለም ይመጣ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","በዓለም ነበረ፥ ዓለሙም በእርሱ ሆነ፥ ዓለሙም አላወቀውም። ");
INSERT INTO amh_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","የእርሱ ወደ ሆነው መጣ፥ የገዛ ወገኖቹም አልተቀበሉትም። ");
INSERT INTO amh_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ለተቀበሉት ሁሉ ግን፥ በስሙ ለሚያምኑት ለእነርሱ የእግዚአብሔር ልጆች ይሆኑ ዘንድ ሥልጣንን ሰጣቸው፤ ");
INSERT INTO amh_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","እነርሱም ከእግዚአብሔር ተወለዱ እንጂ ከደም ወይም ከሥጋ ፈቃድ ወይም ከወንድ ፈቃድ አልተወለዱም። ");
INSERT INTO amh_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ቃልም ሥጋ ሆነ፤ ጸጋንና እውነትንም ተመልቶ በእኛ አደረ፥ አንድ ልጅም ከአባቱ ዘንድ እንዳለው ክብር የሆነው ክብሩን አየን። ");
INSERT INTO amh_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ዮሐንስ ስለ እርሱ መሰከረ እንዲህም ብሎ ጮኸ። ከእኔ በኋላ የሚመጣው እርሱ ከእኔ በፊት ነበረና ከእኔ ይልቅ የከበረ ሆኖአል፤ ስለ እርሱ ያልሁት ይህ ነበረ። ");
INSERT INTO amh_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","እኛ ሁላችን ከሙላቱ ተቀብለን በጸጋ ላይ ጸጋ ተሰጥቶናልና ሕግ በሙሴ ተሰጥቶ ነበርና፤ ");
INSERT INTO amh_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ጸጋና እውነት ግን በኢየሱስ ክርስቶስ ሆነ። ");
INSERT INTO amh_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","መቼም ቢሆን እግዚአብሔርን ያየው አንድ ስንኳ የለም፤ በአባቱ እቅፍ ያለ አንድ ልጁ እርሱ ተረከው። ");
INSERT INTO amh_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","አይሁድም። አንተ ማን ነህ? ብለው ይጠይቁት ዘንድ ከኢየሩሳሌም ካህናትንና ሌዋውያንን በላኩበት ጊዜ፥ የዮሐንስ ምስክርነት ይህ ነው። ");
INSERT INTO amh_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","መሰከረም አልካደምም፤ እኔ ክርስቶስ አይደለሁም ብሎ መሰከረ። ");
INSERT INTO amh_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","እንኪያስ ማን ነህ? ኤልያስ ነህን? ብለው ጠየቁት። አይደለሁም አለ። ነቢዩ ነህን? አይደለሁም ብሎ መለሰ። ");
INSERT INTO amh_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","እንኪያስ። ማን ነህ? ለላኩን መልስ እንድንሰጥ፤ ስለራስህ ምን ትላለህ? አሉት። ");
INSERT INTO amh_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","እርሱም። ነቢዩ ኢሳይያስ እንዳለ። የጌታን መንገድ አቅኑ ብሎ በምድረ በዳ የሚጮኽ ሰው ድምፅ እኔ ነኝ አለ። ");
INSERT INTO amh_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","26","ዮሐንስ መልሶ። እኔ በውኃ አጠምቃለሁ፤ ዳሩ ግን እናንተ የማታውቁት በመካከላችሁ ቆሞአል፤ ");
INSERT INTO amh_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","እኔ የጫማውን ጠፍር ልፈታ የማይገባኝ፥ ከእኔ በኋላ የሚመጣው ከእኔ ይልቅ የሚከብር ይህ ነው አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ይህ ነገር ዮሐንስ ያጠምቅበት በነበረው በዮርዳኖስ ማዶ በቢታንያ በቤተ ራባ ሆነ። ");
INSERT INTO amh_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","በነገው ዮሐንስ ኢየሱስን ወደ እርሱ ሲመጣ አይቶ እንዲህ አለ። እነሆ የዓለምን ኃጢአት የሚያስወግድ የእግዚአብሔር በግ። ");
INSERT INTO amh_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","አንድ ሰው ከእኔ በኋላ ይመጣል፥ ከእኔም በፊት ነበርና ከእኔ ይልቅ የከበረ ሆኖአል ብዬ ስለ እርሱ ያልሁት ይህ ነው። ");
INSERT INTO amh_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","እኔም አላውቀውም ነበር፥ ዳሩ ግን ለእስራኤል ይገለጥ ዘንድ ስለዚህ በውኃ እያጠመቅሁ እኔ መጣሁ። ");
INSERT INTO amh_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ዮሐንስም እንዲህ ብሎ መሰከረ። መንፈስ ከሰማይ እንደ ርግብ ሆኖ ሲወርድ አየሁ፤ በእርሱ ላይም ኖረ። ");
INSERT INTO amh_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","እኔም አላውቀውም ነበር፥ ዳሩ ግን በውኃ አጠምቅ ዘንድ የላከኝ እርሱ። መንፈስ ሲወርድበትና ሲኖርበት የምታየው፥ በመንፈስ ቅዱስ የሚያጠምቅ እርሱ ነው አለኝ። ");
INSERT INTO amh_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","እኔም አይቻለሁ እርሱም የእግዚአብሔር ልጅ እንደ ሆነ መስክሬአለሁ። ");
INSERT INTO amh_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","በነገው ደግሞ ዮሐንስ ከደቀ መዛሙርቱም ሁለት ቆመው ነበር፥ ");
INSERT INTO amh_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ኢየሱስም ሲሄድ ተመልክቶ። እነሆ የእግዚአብሔር በግ አለ። ");
INSERT INTO amh_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ሁለቱም ደቀ መዛሙርት ሲናገር ሰምተው ኢየሱስን ተከተሉት። ");
INSERT INTO amh_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","40","መጥታችሁ እዩ አላቸው። መጥተው የሚኖርበትን አዩ፥ በዚያም ቀን በእርሱ ዘንድ ዋሉ፤ አሥር ሰዓት ያህል ነበረ። ");
INSERT INTO amh_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ከዮሐንስ ዘንድ ሰምተው ከተከተሉት ከሁለቱ አንዱ የስምዖን ጴጥሮስ ወንድም እንድርያስ ነበረ። ");
INSERT INTO amh_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","እርሱ አስቀድሞ የራሱን ወንድም ስምዖንን አገኘውና። መሢሕን አግኝተናል አለው፤ ትርጓሜውም ክርስቶስ ማለት ነው። ");
INSERT INTO amh_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ወደ ኢየሱስም አመጣው። ኢየሱስም ተመልክቶ። አንተ የዮና ልጅ ስምዖን ነህ፤ አንተ ኬፋ ትባላለህ አለው፤ ትርጓሜው ጴጥሮስ ማለት ነው። ");
INSERT INTO amh_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","በነገው ኢየሱስ ወደ ገሊላ ሊወጣ ወደደ፥ ፊልጶስንም አገኘና። ተከተለኝ አለው። ");
INSERT INTO amh_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ፊልጶስም ከእንድርያስና ከጴጥሮስ ከተማ ከቤተ ሳይዳ ነበረ። ");
INSERT INTO amh_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ፊልጶስ ናትናኤልን አግኝቶ። ሙሴ በሕግ ነቢያትም ስለ እርሱ የጻፉትን የዮሴፍን ልጅ የናዝሬቱን ኢየሱስን አግኝተነዋል አለው። ");
INSERT INTO amh_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ናትናኤልም። ከናዝሬት መልካም ነገር ሊወጣ ይችላልን? አለው። ፊልጶስ። መጥተህ እይ አለው። ");
INSERT INTO amh_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ኢየሱስ ናትናኤልን ወደ እርሱ ሲመጣ አይቶ ስለ እርሱ። ተንኰል የሌለበት በእውነት የእስራኤል ሰው እነሆ አለ። ");
INSERT INTO amh_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ናትናኤልም። ከወዴት ታውቀኛለህ? አለው። ኢየሱስም መልሶ። ፊልጶስ ሳይጠራህ፥ ከበለስ በታች ሳለህ፥ አየሁህ አለው። ");
INSERT INTO amh_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ናትናኤልም መልሶ። መምህር ሆይ፥ አንተ የእግዚአብሔር ልጅ ነህ፤ አንተ የእስራኤል ንጉሥ ነህ አለው። ");
INSERT INTO amh_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ኢየሱስም መልሶ። ከበለስ በታች አየሁህ ስላልሁህ አመንህን? ከዚህ የሚበልጥ ነገር ታያለህ አለው። ");
INSERT INTO amh_vpl VALUES ("JN1_52","073_1_52","JHN","1","52","52","እውነት እውነት እላችኋለሁ፥ ሰማይ ሲከፈት የእግዚአብሔርም መላእክት በሰው ልጅ ላይ ሲወጡና ሲወርዱ ታያላችሁ አለው። ");
INSERT INTO amh_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","በሦስተኛውም ቀን በገሊላ ቃና ሰርግ ነበረ፥ የኢየሱስም እናት በዚያ ነበረች፤ ");
INSERT INTO amh_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ኢየሱስም ደግሞ ደቀ መዛሙርቱም ወደ ሰርጉ ታደሙ። ");
INSERT INTO amh_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","የወይን ጠጅም ባለቀ ጊዜ የኢየሱስ እናት። የወይን ጠጅ እኮ የላቸውም አለችው። ");
INSERT INTO amh_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ኢየሱስም። አንቺ ሴት፥ ከአንቺ ጋር ምን አለኝ? ጊዜዬ ገና አልደረሰም አላት። ");
INSERT INTO amh_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","እናቱም ለአገልጋዮቹ። የሚላችሁን ሁሉ አድርጉ አለቻቸው። ");
INSERT INTO amh_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","አይሁድም እንደሚያደርጉት የማንጻት ልማድ ስድስት የድንጋይ ጋኖች በዚያ ተቀምጠው ነበር፥ እያንዳንዳቸውም ሁለት ወይም ሦስት እንስራ ይይዙ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ኢየሱስም። ጋኖቹን ውኃ ሙሉአቸው አላቸው። እስከ አፋቸውም ሙሉአቸው አላቸው። እስከ አፋቸውም ሞሉአቸው። ");
INSERT INTO amh_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","አሁን ቀድታችሁ ለአሳዳሪው ስጡት አላቸው፤ ሰጡትም። ");
INSERT INTO amh_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","አሳዳሪውም የወይን ጠጅ የሆነውን ውሃ በቀመሰ ጊዜ ከወዴት እንደ መጣ አላወቀም፤ ውኃውን የቀዱት አገልጋዮች ግን ያውቁ ነበር፤ አሳዳሪው ሙሽራውን ጠርቶ። ");
INSERT INTO amh_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ሰው ሁሉ አስቀድሞ መልካሙን የወይን ጠጅ ያቀርባል፥ ከሰከሩም በኋላ መናኛውን፤ አንተስ መልካሙን የወይን ጠጅ እስከ አሁን አቆይተሃል አለው። ");
INSERT INTO amh_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ኢየሱስ ይህን የምልክቶች መጀመሪያ በገሊላ ቃና አደረገ፤ ክብሩንም ገለጠ፥ ደቀ መዛሙርቱም በእርሱ አመኑ። ");
INSERT INTO amh_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ከዚህ በኋላ ከእናቱና ከወንድሞቹ ከደቀ መዛሙርቱም ጋር ወደ ቅፍርናሆም ወረደ፥ በዚያም ጥቂት ቀን ኖሩ። ");
INSERT INTO amh_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","የአይሁድ ፋሲካም ቀርቦ ነበር፥ ኢየሱስም ወደ ኢየሩሳሌም ወጣ። ");
INSERT INTO amh_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","በመቅደስም በሬዎችንና በጎችን ርግቦችንም የሚሸጡትን ገንዘብ ለዋጮችንም ተቀምጠው አገኘ፤ ");
INSERT INTO amh_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","የገመድም ጅራፍ አበጅቶ ሁሉን በጎችንም በሬዎችንም ከመቅደስ አወጣቸው፥ የለዋጮችንም ገንዘብ አፈሰሰ ገበታዎቻቸውንም ገለበጠ፥ ");
INSERT INTO amh_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ርግብ ሻጪዎችንም። ይህን ከዚህ ውሰዱ፤ የአባቴን ቤት የንግድ ቤት አታድርጉት አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ደቀ መዛሙርቱም። የቤትህ ቅናት ይበላኛል ተብሎ እንደ ተጻፈ አሰቡ። ");
INSERT INTO amh_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ስለዚህ አይሁድ መልሰው። ይህን ስለምታደርግ ምን ምልክት ታሳየናለህ? አሉት። ");
INSERT INTO amh_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ኢየሱስም መልሶ። ይህን ቤተ መቅደስ አፍርሱት፥ በሦስት ቀንም አነሣዋለሁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ስለዚህ አይሁድ። ይህ ቤተ መቅደስ ከአርባ ስድስት ዓመት ጀምሮ ይሠራ ነበር፥ አንተስ በሦስት ቀን ታነሣዋለህን? አሉት። ");
INSERT INTO amh_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","እርሱ ግን ስለ ሰውነቱ ቤተ መቅደስ ይል ነበር። ");
INSERT INTO amh_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ስለዚህ ከሙታን ከተነሣ በኋላ ደቀ መዛሙርቱ ይህን እንደ ተናገረ አሰቡና መጽሐፍንና ኢየሱስ የተናገረውን ቃል አመኑ። ");
INSERT INTO amh_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","25","በፋሲካ በዓልም በኢየሩሳሌም ሳለ፥ ያደረገውን ምልክት ባዩ ጊዜ ብዙ ሰዎች በስሙ አመኑ፤ ");
INSERT INTO amh_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ከፈሪሳውያንም ወገን የአይሁድ አለቃ የሆነ ኒቆዲሞስ የሚባል አንድ ሰው ነበረ፤ እርሱም በሌሊት ወደ ኢየሱስ መጥቶ። ");
INSERT INTO amh_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","መምህር ሆይ፥ እግዚአብሔር ከእርሱ ጋር ከሆነ በቀር አንተ የምታደርጋቸውን እነዚህን ምልክቶች ሊያደርግ የሚችል የለምና መምህር ሆነህ ከእግዚአብሔር ዘንድ እንደ መጣህ እናውቃለን አለው። ");
INSERT INTO amh_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ኢየሱስም መልሶ። እውነት እውነት እልሃለሁ፥ ሰው ዳግመኛ ካልተወለደ በቀር የእግዚአብሔርን መንግሥት ሊያይ አይችልም አለው። ");
INSERT INTO amh_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ኒቆዲሞስም። ሰው ከሸመገለ በኋላ እንዴት ሊወለድ ይችላል? ሁለተኛ ወደ እናቱ ማኅፀን ገብቶ ይወለድ ዘንድ ይችላልን? አለው። ");
INSERT INTO amh_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ኢየሱስም መለሰ፥ እንዲህ ሲል። እውነት እውነት እልሃለሁ፥ ሰው ከውኃና ከመንፈስ ካልተወለደ በቀር ወደ እግዚአብሔር መንግሥት ሊገባ አይችልም። ");
INSERT INTO amh_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ከሥጋ የተወለደ ሥጋ ነው፥ ከመንፈስም የተወለደ መንፈስ ነው። ");
INSERT INTO amh_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ዳግመኛ ልትወለዱ ያስፈልጋችኋል ስላልሁህ አታድንቅ። ");
INSERT INTO amh_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ነፋስ ወደሚወደው ይነፍሳል፥ ድምፁንም ትሰማለህ፥ ነገር ግን ከወዴት እንደ መጣ ወዴትም እንዲሄድ አታውቅም፤ ከመንፈስ የተወለደ ሁሉ እንዲሁ ነው። ");
INSERT INTO amh_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ኒቆዲሞስ መልሶ። ይህ እንዴት ሊሆን ይችላል? አለው። ");
INSERT INTO amh_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ኢየሱስም መልሶ እንዲህ አለው። አንተ የእስራኤል መምህር ስትሆን ይህን አታውቅምን? ");
INSERT INTO amh_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","እውነት እውነት እልሃለሁ፥ የምናውቀውን እንናገራለን ያየነውንም እንመሰክራለን፥ ምስክራችንንም አትቀበሉትም። ");
INSERT INTO amh_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ስለ ምድራዊ ነገር በነገርኋችሁ ጊዜ ካላመናችሁ፥ ስለ ሰማያዊ ነገር ብነግራችሁ እንዴት ታምናላችሁ? ");
INSERT INTO amh_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ከሰማይም ከወረደ በቀር ወደ ሰማይ የወጣ ማንም የለም፥ እርሱም በሰማይ የሚኖረው የሰው ልጅ ነው። ");
INSERT INTO amh_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","16","በእርሱ የሚያምን ሁሉ የዘላለም ሕይወት እንዲኖረው እንጂ እንዳይጠፋ እግዚአብሔር አንድያ ልጁን እስኪሰጥ ድረስ ዓለሙን እንዲሁ ወዶአልና። ");
INSERT INTO amh_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ዓለም በልጁ እንዲድን ነው እንጂ፥ በዓለም እንዲፈርድ እግዚአብሔር ወደ ዓለም አልላከውምና። ");
INSERT INTO amh_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","በእርሱ በሚያምን አይፈረድበትም፤ በማያምን ግን በአንዱ በእግዚአብሔር ልጅ ስም ስላላመነ አሁን ተፈርዶበታል። ");
INSERT INTO amh_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ብርሃንም ወደ ዓለም ስለ መጣ ሰዎችም ሥራቸው ክፉ ነበርና ከብርሃን ይልቅ ጨለማን ስለ ወደዱ ፍርዱ ይህ ነው። ");
INSERT INTO amh_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ክፉ የሚያደርግ ሁሉ ብርሃንን ይጠላልና፥ ሥራውም እንዳይገለጥ ወደ ብርሃን አይመጣም፤ ");
INSERT INTO amh_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","እውነትን የሚያደርግ ግን ሥራው በእግዚአብሔር ተደርጎ እንደ ሆነ ይገለጥ ዘንድ ወደ ብርሃን ይመጣል። ");
INSERT INTO amh_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ከዚህ በኋላ ኢየሱስ ከደቀ መዛሙርቱ ጋር ወደ ይሁዳ አገር መጣ፥ በዚያም ከእነርሱ ጋር ተቀምጦ ያጠምቅ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ዮሐንስም ደግሞ በሳሌም አቅራቢያ በሄኖን በዚያ ብዙ ውኃ ነበርና ያጠምቅ ነበር፥ ");
INSERT INTO amh_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","እየመጡም ይጠመቁ ነበር ዮሐንስ ገና ወደ ወኅኒ አልተጨመረም ነበርና። ");
INSERT INTO amh_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ስለዚህም በዮሐንስ ደቀ መዛሙርትና በአይሁድ መካከል ስለ ማንጻት ክርክር ሆነ። ");
INSERT INTO amh_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ወደ ዮሐንስም መጥተው። መምህር ሆይ፥ በዮርዳኖስ ማዶ ከአንተ ጋር የነበረው አንተም የመሰከርህለት፥ እነሆ፥ እርሱ ያጠምቃል ሁሉም ወደ እርሱ ይመጣሉ አሉት። ");
INSERT INTO amh_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ዮሐንስ መለሰ፥ እንዲህ ሲል። ከሰማይ ካልተሰጠው ሰው እንዳች ሊቀበል አይችልም። ");
INSERT INTO amh_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","እናንተ። እኔ ክርስቶስ አይደለሁም፥ ነገር ግን። ከእርሱ በፊት ተልኬአለሁ እንዳልሁ ራሳችሁ ትመሰክሩልኛላችሁ። ");
INSERT INTO amh_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ሙሽራይቱ ያለችው እርሱ ሙሽራ ነው፤ ቆሞ የሚሰማው ሚዜው ግን በሙሽራው ድምጽ እጅግ ደስ ይለዋል። እንግዲህ ይህ ደስታዬ ተፈጸመ። ");
INSERT INTO amh_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","እርሱ ሊልቅ እኔ ግን ላንስ ያስፈልጋል። ");
INSERT INTO amh_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ከላይ የሚመጣው ከሁሉ በላይ ነው፤ ከምድር የሚሆነው የምድር ነው የምድሩንም ይናገራል። ከሰማይ የሚመጣው ከሁሉ በላይ ነው። ");
INSERT INTO amh_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ያየውንና የሰማውንም ይህን ይመሰክራል፥ ምስክሩንም የሚቀበለው የለም። ");
INSERT INTO amh_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ምስክሩን የተቀበለ እግዚአብሔር እውነተኛ እንደ ሆነ አተመ። ");
INSERT INTO amh_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","እግዚአብሔር የላከው የእግዚአብሔርን ቃል ይናገራልና፤ እግዚአብሔር መንፈሱን ሰፍሮ አይሰጥምና። ");
INSERT INTO amh_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","አባት ልጁን ይወዳል ሁሉንም በእጁ ሰጥቶታል። ");
INSERT INTO amh_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","በልጁ የሚያምን የዘላለም ሕይወት አለው፤ በልጁ የማያምን ግን የእግዚአብሔር ቍጣ በእርሱ ላይ ይኖራል እንጂ ሕይወትን አያይም። ");
INSERT INTO amh_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","እንግዲህ። ኢየሱስ ከዮሐንስ ይልቅ ደቀ መዛሙርት ያደርጋል ያጠምቅማል ማለትን ፈሪሳውያን እንደ ሰሙ ጌታ ባወቀ ጊዜ፥ ");
INSERT INTO amh_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","4","በሰማርያም ሊያልፍ ግድ ሆነበት። ");
INSERT INTO amh_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ስለዚህ ያዕቆብ ለልጁ ለዮሴፍ በሰጠው ስፍራ አጠገብ ወደምትሆን ሲካር ወደምትባል የሰማርያ ከተማ መጣ፤ ");
INSERT INTO amh_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","በዚያም የያዕቆብ ጕድጓድ ነበረ። ኢየሱስም መንገድ ከመሄድ ደክሞ በጕድጓድ አጠገብ እንዲህ ተቀመጠ፤ ጊዜውም ስድስት ሰዓት ያህል ነበረ። ");
INSERT INTO amh_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ከሰማርያ አንዲት ሴት ውኃ ልትቀዳ መጣች። ኢየሱስም። ውኃ አጠጪኝ አላት፤ ");
INSERT INTO amh_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ደቀ መዛሙርቱ ምግብ ሊገዙ ወደ ከተማ ሄደው ነበርና። ");
INSERT INTO amh_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ስለዚህ ሳምራዊቲቱ። አንተ የይሁዳ ሰው ስትሆን ሳምራዊት ሴት ከምሆን ከእኔ መጠጥ እንዴት ትለምናለህ? አለችው፤ አይሁድ ከሳምራውያን ጋር አይተባበሩም ነበርና። ");
INSERT INTO amh_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ኢየሱስ መልሶ። የእግዚአብሔርን ስጦታና። ውኃ አጠጪኝ የሚልሽ ማን መሆኑንስ ብታውቂ፥ አንቺ ትለምኚው ነበርሽ የሕይወትም ውኃ ይሰጥሽ ነበር አላት። ");
INSERT INTO amh_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ሴቲቱ። ጌታ ሆይ፥ መቅጃ የለህም ጕድጓዱም ጥልቅ ነው፤ እንግዲህ የሕይወት ውኃ ከወዴት ታገኛለህ? ");
INSERT INTO amh_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","በእውኑ አንተ ይህን ጕድጓድ ከሰጠን ከአባታችን ከያዕቆብ ትበልጣለህን? ራሱም ልጆቹም ከብቶቹም ከዚህ ጠጥተዋል አለችው። ");
INSERT INTO amh_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ኢየሱስም መልሶ። ከዚህ ውኃ የሚጠጣ ሁሉ እንደ ገና ይጠማል፤ ");
INSERT INTO amh_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","እኔ ከምሰጠው ውኃ የሚጠጣ ሁሉ ግን ለዘላለም አይጠማም፥ እኔ የምሰጠው ውኃ በእርሱ ውስጥ ለዘላለም ሕይወት የሚፈልቅ የውኃ ምንጭ ይሆናል እንጂ አላት። ");
INSERT INTO amh_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ሴቲቱ። ጌታ ሆይ፥ እንዳልጠማ ውኃም ልቀዳ ወደዚህ እንዳልመጣ ይህን ውኃ ስጠኝ አለችው። ");
INSERT INTO amh_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ኢየሱስም። ሂጂና ባልሽን ጠርተሽ ወደዚህ ነዪ አላት። ");
INSERT INTO amh_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ሴቲቱ መልሳ። ባል የለኝም አለችው። ኢየሱስ። ባል የለኝም በማለትሽ መልካም ተናገርሽ፤ ");
INSERT INTO amh_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","አምስት ባሎች ነበሩሽና፥ አሁን ከአንቺ ጋር ያለው ባልሽ አይደለም፤ በዚህስ እውነት ተናገርሽ አላት። ");
INSERT INTO amh_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ሴቲቱ። ጌታ ሆይ፥ አንተ ነቢይ እንደ ሆንህ አያለሁ። ");
INSERT INTO amh_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","አባቶቻችን በዚህ ተራራ ሰገዱ፤ እናንተም። ሰው ሊሰግድበት የሚገባው ስፍራ በኢየሩሳሌም ነው ትላላችሁ አለችው። ");
INSERT INTO amh_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ኢየሱስም እንዲህ አላት። አንቺ ሴት፥ እመኚኝ፥ በዚህ ተራራ ወይም በኢየሩሳሌም ለአብ የማትሰግዱበት ጊዜ ይመጣል። ");
INSERT INTO amh_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","እናንተስ ለማታውቁት ትሰግዳላችሁ፤ እኛ መዳን ከአይሁድ ነውና ለምናውቀው እንሰግዳለን። ");
INSERT INTO amh_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ነገር ግን በእውነት የሚሰግዱ ለአብ በመንፈስና በእውነት የሚሰግዱበት ጊዜ ይመጣል አሁንም ሆኖአል፤ አብ ሊሰግዱለት እንደ እነዚህ ያሉትን ይሻልና፤ ");
INSERT INTO amh_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","እግዚአብሔር መንፈስ ነው፥ የሚሰግዱለትም በመንፈስና በእውነት ሊሰግዱለት ያስፈልጋቸዋል። ");
INSERT INTO amh_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ሴቲቱ። ክርስቶስ የሚባል መሲሕ እንዲመጣ አውቃለሁ፤ እርሱ ሲመጣ ሁሉን ይነግረናል አለችው። ");
INSERT INTO amh_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ኢየሱስ። የምናገርሽ እኔ እርሱ ነኝ አላት። ");
INSERT INTO amh_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","በዚያም ጊዜ ደቀ መዛሙርቱ መጡና ከሴት ጋር በመነጋገሩ ተደነቁ፤ ነገር ግን። ምን ትፈልጊያለሽ? ወይም። ስለ ምን ትናገራታለህ? ያለ ማንም አልነበረም። ");
INSERT INTO amh_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ሴቲቱም እንስራዋን ትታ ወደ ከተማ ሄደች ለሰዎችም። ");
INSERT INTO amh_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ያደረግሁትን ሁሉ የነገረኝን ሰው ኑና እዩ፤ እንጃ እርሱ ክርስቶስ ይሆንን? አለች። ");
INSERT INTO amh_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ከከተማ ወጥተው ወደ እርሱ ይመጡ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ይህም ሲሆን ሳለ ደቀ መዛሙርቱ። መምህር ሆይ፥ ብላ ብለው ለመኑት። ");
INSERT INTO amh_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","እርሱ ግን። እናንተ የማታውቁት የምበላው መብል ለእኔ አለኝ አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ስለዚህ ደቀ መዛሙርቱ። የሚበላው አንዳች ሰው አምጥቶለት ይሆንን? ተባባሉ። ");
INSERT INTO amh_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ኢየሱስም እንዲህ አላቸው። የእኔስ መብል የላከኝን ፈቃድ አደርግ ዘንድ ሥራውንም እፈጽም ዘንድ ነው። ");
INSERT INTO amh_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","እናንተ። ገና አራት ወር ቀርቶአል መከርም ይመጣል ትሉ የለምን? እነሆ እላችኋለሁ፥ ዓይናችሁን አንሡ አዝመራውም አሁን እንደ ነጣ እርሻውን ተመልከቱ። ");
INSERT INTO amh_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","የሚያጭድ ደመወዝን ይቀበላል፥ የሚዘራና የሚያጭድም አብረው ደስ እንዲላቸው ለዘላለም ሕይወት ፍሬን ይሰበስባል። ");
INSERT INTO amh_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","አንዱ ይዘራል አንዱም ያጭዳል የሚለው ቃል በዚህ እውነት ሆኖአልና። ");
INSERT INTO amh_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","እኔም እናንተ ያልደከማችሁበትን ታጭዱ ዘንድ ሰደድኋችሁ፤ ሌሎች ደከሙ እናንተም በድካማቸው ገባችሁ። ");
INSERT INTO amh_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ሴቲቱም። ያደረግሁትን ሁሉ ነገረኝ ብላ ስለ መሰከረችው ቃል ከዚያች ከተማ የሰማርያ ሰዎች ብዙ አመኑበት። ");
INSERT INTO amh_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","የሰማርያ ሰዎችም ወደ እርሱ በመጡ ጊዜ በእነርሱ ዘንድ እንዲኖር ለመኑት፤ በዚያም ሁለት ቀን ያህል ኖረ። ");
INSERT INTO amh_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ስለ ቃሉ ከፊተኞች ይልቅ ብዙ ሰዎች አመኑ፤ ");
INSERT INTO amh_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ሴቲቱንም። አሁን የምናምን ስለ ቃልሽ አይደለም፥ እኛ ራሳችን ሰምተነዋልና፤ እርሱም በእውነት ክርስቶስ የዓለም መድኃኒት እንደ ሆነ እናውቃለን ይሉአት ነበር። ");
INSERT INTO amh_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ከሁለቱ ቀኖችም በኋላ ከዚያ ወጥቶ ወደ ገሊላ ሄደ። ");
INSERT INTO amh_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ነቢይ በገዛ አገሩ እንዳይከበር ኢየሱስ ራሱ መስክሮአልና። ");
INSERT INTO amh_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ወደ ገሊላም በመጣ ጊዜ፥ የገሊላ ሰዎች ራሳቸው ደግሞ ለበዓል መጥተው ነበርና በበዓል በኢየሩሳሌም ያደረገውን ሁሉ ስላዩ ተቀበሉት። ");
INSERT INTO amh_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ኢየሱስም ውኃውን የወይን ጠጅ ወዳደረገባት ወደ ገሊላ ቃና ዳግመኛ መጣ። በቅፍርናሆምም ልጁ የታመመበት ከንጉሥ ቤት አንድ ሹም ነበረ። ");
INSERT INTO amh_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","እርሱም ኢየሱስ ከይሁዳ ወደ ገሊላ እንደ መጣ ሰምቶ ልጁ ሊሞት ስላለው ወደ እርሱ ሄደ ወርዶም እንዲፈውስለት ለመነው። ");
INSERT INTO amh_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ስለዚህም ኢየሱስ። ምልክትና ድንቅ ነገር ካላያችሁ ከቶ አታምኑም አለው። ");
INSERT INTO amh_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ሹሙም። ጌታ ሆይ፥ ብላቴናዬ ሳይሞት ውረድ አለው። ");
INSERT INTO amh_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ኢየሱስም። ሂድ፤ ልጅህ በሕይወት አለ አለው። ሰውዬውም ኢየሱስ የነገረውን ቃል አምኖ ሄደ። ");
INSERT INTO amh_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","እርሱም ሲወርድ ሳለ ባሮቹ ተገናኙትና። ብላቴናህ በሕይወት አለ ብለው ነገሩት። ");
INSERT INTO amh_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","እርሱም በጎ የሆነበትን ሰዓት ጠየቃቸው፤ እነርሱም። ትናንት በሰባት ሰዓት ንዳዱ ለቀቀው አሉት። ");
INSERT INTO amh_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","አባቱም ኢየሱስ። ልጅህ በሕይወት አለ ባለው በዚያ ሰዓት እንደ ሆነ አወቀ፤ እርሱም ከቤተ ሰዎቹ ሁሉ ጋር አመነ። ");
INSERT INTO amh_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ይህም ደግሞ ኢየሱስ ከይሁዳ ወደ ገሊላ መጥቶ ያደረገው ሁለተኛ ምልክት ነው። ");
INSERT INTO amh_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ከዚህ በኋላ የአይሁድ በዓል ነበረ፥ ኢየሱስም ወደ ኢየሩሳሌም ወጣ። ");
INSERT INTO amh_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","በኢየሩሳሌምም በበጎች በር አጠገብ በዕብራይስጥ ቤተ ሳይዳ የምትባል አንዲት መጠመቂያ ነበረች፤ አምስትም መመላለሻ ነበረባት። ");
INSERT INTO amh_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","በእነዚህ ውስጥ የውኃውን መንቀሳቀስ እየጠበቁ በሽተኞችና ዕውሮች አንካሶችም ሰውነታቸውም የሰለለ ብዙ ሕዝብ ይተኙ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","አንዳንድ ጊዜ የጌታ መልአክ ወደ መጠመቂያይቱ ወርዶ ውኃውን ያናውጥ ነበርና፤ እንግዲህ ከውኃው መናወጥ በኋላ በመጀመሪያ የገባ ከማናቸው ካለበት ደዌ ጤናማ ይሆን ነበር። ");
INSERT INTO amh_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","በዚያም ከሠላሳ ስምንት ዓመት ጀምሮ የታመመ አንድ ሰው ነበረ፤ ");
INSERT INTO amh_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ኢየሱስ ይህን ሰው ተኝቶ ባየ ጊዜ፥ እስከ አሁን ብዙ ዘመን እንዲሁ እንደ ነበረ አውቆ። ልትድን ትወዳለህን? አለው። ");
INSERT INTO amh_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ድውዩም። ጌታ ሆይ፥ ውኃው በተናወጠ ጊዜ በመጠመቂያይቱ ውስጥ የሚያኖረኝ ሰው የለኝም ነገር ግን እኔ ስመጣ ሳለሁ ሌላው ቀድሞኝ ይወርዳል ብሎ መለሰለት። ");
INSERT INTO amh_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ኢየሱስ። ተነሣና አልጋህን ተሸክመህ ሂድ አለው። ");
INSERT INTO amh_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ወዲያውም ሰውዬው ዳነ አልጋውንም ተሸክሞ ሄደ። ");
INSERT INTO amh_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ያም ቀን ሰንበት ነበረ። ስለዚህ አይሁድ የተፈወሰውን ሰው። ሰንበት ነው አልጋህንም ልትሸከም አልተፈቀደልህም አሉት። ");
INSERT INTO amh_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","እርሱ ግን። ያዳነኝ ያ ሰው። አልጋህን ተሸክመህ ሂድ አለኝ ብሎ መለሰላቸው። ");
INSERT INTO amh_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","እነርሱም። አልጋህን ተሸክመህ ሂድ ያለህ ሰው ማን ነው? ብለው ጠየቁት። ");
INSERT INTO amh_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ዳሩ ግን በዚያ ስፍራ ሕዝብ ሰለ ነበሩ ኢየሱስ ፈቀቅ ብሎ ነበርና የተፈወሰው ሰው ማን እንደ ሆነ አላወቀም። ");
INSERT INTO amh_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ከዚህ በኋላ ኢየሱስ በመቅደስ አገኘውና። እነሆ፥ ድነሃል፤ ከዚህ የሚብስ እንዳይደርስብህ ወደ ፊት ኃጢአት አትሥራ አለው። ");
INSERT INTO amh_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ሰውዬው ሄዶ ያዳነው ኢየሱስ እንደ ሆነ ለአይሁድ ነገረ። ");
INSERT INTO amh_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ስለዚህም በሰንበት ይህን ስላደረገ አይሁድ ኢየሱስን ያሳድዱት ነበር ሊገድሉትም ይፈልጉ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ኢየሱስ ግን። አባቴ እስከ ዛሬ ይሠራል እኔም ደግሞ እሠራለሁ ብሎ መለሰላቸው። ");
INSERT INTO amh_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","እንግዲህ ሰንበትን ስለ ሻረ ብቻ አይደለም፥ ነገር ግን ደግሞ ራሱን ከእግዚአብሔር ጋር አስተካክሎ። እግዚአብሔር አባቴ ነው ስላለ፥ ስለዚህ አይሁድ ሊገድሉት አብዝተው ይፈልጉት ነበር። ");
INSERT INTO amh_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ስለዚህ ኢየሱስ መለሰ እንዲህም አላቸው። እውነት እውነት እላችኋለሁ፥ አብ ሲያደርግ ያየውን ነው እንጂ ወልድ ከራሱ ሊያደርግ ምንም አይችልም፤ ያ የሚያደርገውን ሁሉ ወልድ ደግሞ ይህን እንዲሁ ያደርጋልና። ");
INSERT INTO amh_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","አብ ወልድን ይወዳልና፥ የሚያደርገውንም ሁሉ ያሳየዋል፤ እናንተም ትደነቁ ዘንድ ከዚህ የሚበልጥ ሥራ ያሳየዋል። ");
INSERT INTO amh_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","አብ ሙታንን እንደሚያነሣ ሕይወትም እንደሚሰጣቸው፥ እንዲሁ ወልድ ደግሞ ለሚወዳቸው ሕይወትን ይሰጣቸዋል። ");
INSERT INTO amh_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","24","እውነት እውነት እላችኋለሁ፥ ቃሌን የሚሰማ የላከኝንም የሚያምን የዘላለም ሕይወት አለው፥ ከሞትም ወደ ሕይወት ተሻገረ እንጂ ወደ ፍርድ አይመጣም። ");
INSERT INTO amh_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","እውነት እውነት እላችኋለሁ፥ ሙታን የእግዚአብሔርን ልጅ ድምፅ የሚሰሙበት ሰዓት ይመጣል እርሱም አሁን ነው፤ የሚሰሙትም በሕይወት ይኖራሉ። ");
INSERT INTO amh_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","አብ በራሱ ሕይወት እንዳለው እንዲሁ ደግሞ ለወልድ በራሱ ሕይወት እንዲኖረው ሰጥቶታልና። ");
INSERT INTO amh_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","የሰው ልጅም ስለ ሆነ ይፈርድ ዘንድ ሥልጣን ሰጠው። ");
INSERT INTO amh_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","30","እኔ ከራሴ አንዳች ላደርግ አይቻለኝም፤ እንደ ሰማሁ እፈርዳለሁ ፍርዴም ቅን ነው፥ የላከኝን ፈቃድ እንጂ ፈቃዴን አልሻምና። ");
INSERT INTO amh_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","እኔ ስለ እኔ ስለ ራሴ ብመሰክር ምስክሬ እውነት አይደለም፤ ");
INSERT INTO amh_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ስለ እኔ የሚመሰክር ሌላ ነው፥ እርሱም ስለ እኔ የሚመሰክረው ምስክር እውነት እንደ ሆነ አውቃለሁ። ");
INSERT INTO amh_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","እናንተ ወደ ዮሐንስ ልካችኋል እርሱም ለእውነት መስክሮአል። ");
INSERT INTO amh_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","እኔ ግን ከሰው ምስክር አልቀበልም፥ እናንተ እንድትድኑ ይህን እላለሁ እንጂ። ");
INSERT INTO amh_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","እርሱ የሚነድና የሚያበራ መብራት ነበረ፥ እናንተም ጥቂት ዘመን በብርሃኑ ደስ ሊላችሁ ወደዳችሁ። ");
INSERT INTO amh_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","እኔ ግን ከዮሐንስ ምስክር የሚበልጥ ምስክር አለኝ፤ አብ ልፈጽመው የሰጠኝ ሥራ፥ ይህ የማደርገው ሥራ፥ አብ እንደ ላከኝ ስለ እኔ ይመሰክራልና። ");
INSERT INTO amh_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","የላከኝ አብም እርሱ ስለ እኔ መስክሮአል። ድምፁን ከቶ አልሰማችሁም፥ መልኩንም አላያችሁም፤ ");
INSERT INTO amh_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","እርሱም የላከውን እናንተ አታምኑምና በእናንተ ዘንድ የሚኖር ቃሉ የላችሁም። ");
INSERT INTO amh_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","እናንተ በመጻሕፍት የዘላለም ሕይወት እንዳላችሁ ይመስላችኋልና እነርሱን ትመረምራላችሁ፤ እነርሱም ስለ እኔ የሚመሰክሩ ናቸው፤ ");
INSERT INTO amh_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ነገር ግን ሕይወት እንዲሆንላችሁ ወደ እኔ ልትመጡ አትወዱም። ");
INSERT INTO amh_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","43","እኔ በአባቴ ስም መጥቻለሁ አልተቀበላችሁኝምም፤ ሌላው በራሱ ስም ቢመጣ እርሱን ትቀበሉታላችሁ። ");
INSERT INTO amh_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","እናንተ እርስ በርሳችሁ ክብር የምትቀባበሉ ከአንዱም ከእግዚአብሔር ያለውን ክብር የማትፈልጉ፥ እንዴት ልታምኑ ትችላላችሁ? ");
INSERT INTO amh_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","እኔ በአብ ዘንድ የምከሳችሁ አይምሰላችሁ፤ የሚከሳችሁ አለ፤ እርሱም ተስፋ የምታደርጉት ሙሴ ነው። ");
INSERT INTO amh_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ሙሴንስ ብታምኑት እኔን ባመናችሁ ነበር፤ እርሱ ስለ እኔ ጽፎአልና። ");
INSERT INTO amh_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","መጻሕፍትን ካላመናችሁ ግን ቃሌን እንዴት ታምናላችሁ? ");
INSERT INTO amh_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ከዚህ በኋላ ኢየሱስ ወደ ገሊላ ባሕር ማዶ ተሻገረ፤ እርሱም የጥብርያዶስ ባሕር ነው። ");
INSERT INTO amh_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","በበሽተኞችም ያደረገውን ምልክቶች ስላዩ ብዙ ሕዝብ ተከተሉት። ");
INSERT INTO amh_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ኢየሱስም ወደ ተራራ ወጣና በዚያ ከደቀ መዛሙርቱ ጋር ተቀመጠ። ");
INSERT INTO amh_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","የአይሁድ በዓልም ፋሲካ ቀርቦ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ኢየሱስም ዓይኖቹን አንሥቶ ብዙ ሕዝብ ወደ እርሱ ሲመጣ አየና ፊልጶስን። እነዚህ እንዲበሉ እንጀራ ከወዴት እንገዛለን? አለው። ");
INSERT INTO amh_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ራሱ ሊያደርግ ያለውን ያውቅ ነበርና ሊፈትነው ይህን ተናገረ። ");
INSERT INTO amh_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ፊልጶስ። እያንዳንዳቸው ትንሽ ትንሽ እንኳ እንዲቀበሉ የሁለት መቶ ዲናር እንጀራ አይበቃቸውም ብሎ መለሰለት። ");
INSERT INTO amh_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ከደቀ መዛሙርቱ አንዱ የስምዖን ጴጥሮስ ወንድም እንድርያስ። ");
INSERT INTO amh_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","አምስት የገብስ እንጀራና ሁለት ዓሣ የያዘ ብላቴና በዚህ አለ፤ ነገር ግን እነዚህን ለሚያህሉ ሰዎች ይህ ምን ይሆናል? አለው። ");
INSERT INTO amh_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ኢየሱስም። ሰዎቹን እንዲቀመጡ አድርጉ አለ። በዚያም ስፍራ ብዙ ሣር ነበረበት። ወንዶችም ተቀመጡ ቍጥራቸውም አምስት ሺህ የሚያህል ነበር። ");
INSERT INTO amh_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ኢየሱስም እንጀራውን ያዘ፥ አመስግኖም ለደቀ መዛሙርቱ ሰጠ፥ ደቀ መዛሙርቱም ለተቀመጡት ሰዎች ሰጡአቸው እንዲሁም ከዓሣው በፈለጉት መጠን። ");
INSERT INTO amh_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ከጠገቡም በኋላ ደቀ መዛሙርቱን። አንድ ስንኳ እንዳይጠፋ የተረፈውን ቍርስራሽ አከማቹ አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ሰለዚህ አከማቹ፥ ከበሉትም ከአምስቱ የገብስ እንጀራ የተረፈውን ቍርስራሽ አሥራ ሁለት መሶብ ሞሉ። ");
INSERT INTO amh_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ከዚህ የተነሣ ሰዎቹ ኢየሱስ ያደረገውን ምልክት ባዩ ጊዜ። ይህ በእውነት ወደ ዓለም የሚመጣው ነቢይ ነው አሉ። ");
INSERT INTO amh_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","በዚህም ምክንያት ኢየሱስ ያነግሡት ዘንድ ሊመጡና ሊነጥቁት እንዳላቸው አውቆ ደግሞ ወደ ተራራ ብቻውን ፈቀቅ አለ። ");
INSERT INTO amh_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","በመሸም ጊዜ ደቀ መዛሙርቱ ወደ ባሕር ወረዱ፥ ");
INSERT INTO amh_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","በታንኳም ገብተው በባሕር ማዶ ወደ ቅፍርናሆም ይመጡ ነበር። አሁንም ጨልሞ ነበር፤ ኢየሱስም ገና ወደ እነርሱ አልመጣም ነበር፤ ");
INSERT INTO amh_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ብርቱ ነፋስም ስለ ነፈሰ ባሕሩ ተናወጠ። ");
INSERT INTO amh_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ሀያ አምስት ወይም ሠላሳ ምዕራፍ ከቀዘፉ በኋላም፥ ኢየሱስ በባሕር ላይ እየሄደ ወደ ታንኳይቱ ሲቀርብ አይተው ፈሩ። ");
INSERT INTO amh_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","እርሱ ግን። እኔ ነኝ፤ አትፍሩ አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ስለዚህ በታንኳይቱ ሊቀበሉት ወደዱ፤ ወዲያውም ታንኳይቱ ወደሚሄዱበት ምድር ደረሰች። ");
INSERT INTO amh_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","በነገው በባሕር ማዶ ቆመው የነበሩ ሕዝቡ ከአንዲት ጀልባ በቀር በዚያ ሌላ ጀልባ እንዳልነበረች፥ ደቀ መዛሙርቱም ለብቻቸው እንደ ሄዱ እንጂ ኢየሱስ ከደቀ መዛሙርቱ ጋር ወደ ታንኳይቱ እንዳልገባ አዩ፤ ");
INSERT INTO amh_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ዳሩ ግን ሌሎች ጀልባዎች ጌታ የባረከውን እንጀራ ወደ በሉበት ስፍራ አጠገብ ከጥብርያዶስ መጡ። ");
INSERT INTO amh_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ሕዝቡም ኢየሱስ ወይም ደቀ መዛሙርቱ በዚያ እንዳልነበሩ ባዩ ጊዜ፥ ራሳቸው በጀልባዎቹ ገብተው ኢየሱስን እየፈለጉ ወደ ቅፍርናሆም መጡ። ");
INSERT INTO amh_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","በባሕር ማዶም ሲያገኙት። መምህር ሆይ፥ ወደዚህ መቼ መጣህ? አሉት። ");
INSERT INTO amh_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ኢየሱስም መልሶ። እውነት እውነት እላችኋለሁ፥ የምትፈልጉኝ እንጀራን ስለ በላችሁና ስለ ጠገባችሁ ነው እንጂ ምልክቶችን ስላያችሁ አይደለም። ");
INSERT INTO amh_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ለሚጠፋ መብል አትሥሩ፤ ነገር ግን ለዘላለም ሕይወት ለሚኖር መብል የሰው ልጅ ለሚሰጣችሁ ሥሩ፤ እርሱን እግዚአብሔር አብ አትሞታልና። ");
INSERT INTO amh_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","እንግዲህ። የእግዚአብሔርን ሥራ እንድንሠራ ምን እናድርግ? አሉት። ");
INSERT INTO amh_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ኢየሱስ መልሶ። ይህ የእግዚአብሔር ሥራ እርሱ በላከው እንድታምኑ ነው አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","እንግዲህ። እንኪያ አይተን እንድናምንህ አንተ ምን ምልክት ታደርጋለህ? ምንስ ትሠራለህ? ");
INSERT INTO amh_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ይበሉ ዘንድ ከሰማይ እንጀራ ሰጣቸው ተብሎ እንደ ተጻፈ አባቶቻችን በምድረ በዳ መና በሉ አሉት። ");
INSERT INTO amh_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ኢየሱስም። እውነት እውነት እላችኋለሁ፥ እውነተኛ እንጀራ ከሰማይ የሚሰጣችሁ አባቴ ነው እንጂ ከሰማይ እንጀራ የሰጣችሁ ሙሴ አይደለም፤ ");
INSERT INTO amh_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","የእግዚአብሔር እንጀራ ከሰማይ የሚወርድ ለዓለምም ሕይወትን የሚሰጥ ነውና አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ስለዚህ። ጌታ ሆይ፥ ይህን እንጀራ ዘወትር ስጠን አሉት። ");
INSERT INTO amh_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ኢየሱስም እንዲህ አላቸው። የሕይወት እንጀራ እኔ ነኝ፤ ወደ እኔ የሚመጣ ከቶ አይራብም በእኔ የሚያምንም ሁልጊዜ ከቶ አይጠማም። ");
INSERT INTO amh_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ነገር ግን አይታችሁኝ እንዳላመናችሁ አልኋችሁ። ");
INSERT INTO amh_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","አብ የሚሰጠኝ ሁሉ ወደ እኔ ይመጣል፥ ወደ እኔም የሚመጣውን ከቶ ወደ ውጭ አላወጣውም፤ ");
INSERT INTO amh_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ፈቃዴን ለማድረግ አይደለም እንጂ የላከኝን ፈቃድ ለማድረግ ከሰማይ ወርጃለሁና። ");
INSERT INTO amh_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ከሰጠኝም ሁሉ አንድን ስንኳ እንዳላጠፋ በመጨረሻው ቀን እንዳስነሣው እንጂ የላከኝ የአብ ፈቃድ ይህ ነው። ");
INSERT INTO amh_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ልጅንም አይቶ በእርሱ የሚያምን ሁሉ የዘላለም ሕይወትን እንዲያገኝ የአባቴ ፈቃድ ይህ ነው፥ እኔም በመጨረሻው ቀን አስነሣዋለሁ። ");
INSERT INTO amh_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","እንግዲህ አይሁድ። ከሰማይ የወረደ እንጀራ እኔ ነኝ ስላለ ስለ እርሱ አንጐራጐሩና። ");
INSERT INTO amh_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","አባቱንና እናቱን የምናውቃቸው ይህ የዮሴፍ ልጅ ኢየሱስ አይደለምን? እንግዲህ። ከሰማይ ወርጃለሁ እንዴት ይላል? አሉ። ");
INSERT INTO amh_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ኢየሱስ መለሰ አላቸውም። እርስ በርሳችሁ አታንጐራጕሩ። ");
INSERT INTO amh_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","የላከኝ አብ ከሳበው በቀር ወደ እኔ ሊመጣ የሚችል የለም፥ እኔም በመጨረሻው ቀን አስነሣዋለሁ። ");
INSERT INTO amh_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ሁሉም ከእግዚአብሔር የተማሩ ይሆናሉ ተብሎ በነቢያት ተጽፎአል፤ እንግዲህ ከአብ የሰማ የተማረም ሁሉ ወደ እኔ ይመጣል። ");
INSERT INTO amh_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","አብን ያየ ማንም የለም፤ ከእግዚአብሔር ከሆነ በቀር፥ እርሱ አብን አይቶአል። ");
INSERT INTO amh_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","እውነት እውነት እላችኋለሁ በእኔ የሚያምን የዘላለም ሕይወት አለው። ");
INSERT INTO amh_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","የሕይወት እንጀራ እኔ ነኝ። ");
INSERT INTO amh_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","አባቶቻችሁ በምድረ በዳ መና በሉ ሞቱም፤ ");
INSERT INTO amh_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ሰው ከእርሱ በልቶ እንዳይሞት ከሰማይ አሁን የወረደ እንጀራ ይህ ነው። ");
INSERT INTO amh_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ከሰማይ የወረደ ሕያው እንጀራ እኔ ነኝ፤ ሰው ከዚህ እንጀራ ቢበላ ለዘላለም ይኖራል፤ እኔም ስለ ዓለም ሕይወት የምሰጠው እንጀራ ሥጋዬ ነው። ");
INSERT INTO amh_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","እንግዲህ አይሁድ። ይህ ሰው ሥጋውን ልንበላ ይሰጠን ዘንድ እንዴት ይችላል? ብለው እርስ በርሳቸው ተከራከሩ። ");
INSERT INTO amh_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ስለዚህ ኢየሱስ እንዲህ አላቸው። እውነት እውነት እላችኋለሁ፥ የሰውን ልጅ ሥጋ ካልበላችሁ ደሙንም ካልጠጣችሁ በራሳችሁ ሕይወት የላችሁም። ");
INSERT INTO amh_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ሥጋዬን የሚበላ ደሜንም የሚጠጣ የዘላለም ሕይወት አለው፥ እኔም በመጨረሻው ቀን አስነሣዋለሁ። ");
INSERT INTO amh_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ሥጋዬ እውነተኛ መብል ደሜም እውነተኛ መጠጥ ነውና። ");
INSERT INTO amh_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ሥጋዬን የሚበላ ደሜንም የሚጠጣ በእኔ ይኖራል እኔም በእርሱ እኖራለሁ። ");
INSERT INTO amh_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ሕያው አብ እንደ ላከኝ እኔም ከአብ የተነሣ ሕያው እንደምሆን፥ እንዲሁ የሚበላኝ ደግሞ ከእኔ የተነሣ ሕያው ይሆናል። ");
INSERT INTO amh_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ከሰማይ የወረደ እንጀራ ይህ ነው፤ አባቶቻችሁ መና በልተው እንደ ሞቱ አይደለም፤ ይህን እንጀራ የሚበላ ለዘላለም ይኖራል ");
INSERT INTO amh_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","በቅፍርናሆም ሲያስተምር ይህን በምኵራብ አለ። ");
INSERT INTO amh_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ከደቀ መዛሙርቱም ብዙዎች በሰሙ ጊዜ። ይህ የሚያስጨንቅ ንግግር ነው፤ ማን ሊሰማው ይችላል? አሉ። ");
INSERT INTO amh_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ኢየሱስ ግን ደቀ መዛሙርቱ ስለዚህ እንዳንጐራጐሩ በልቡ አውቆ አላቸው። ይህ ያሰናክላችኋልን? ");
INSERT INTO amh_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","እንግዲህ የሰው ልጅ አስቀድሞ ወደ ነበረበት ሲወጣ ብታዩ እንዴት ይሆናል? ");
INSERT INTO amh_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ሕይወትን የሚሰጥ መንፈስ ነው፤ ሥጋ ምንም አይጠቅምም፤ እኔ የነገርኋችሁ ቃል መንፈስ ነው ሕይወትም ነው። ");
INSERT INTO amh_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ነገር ግን ከእናንተ የማያምኑ አሉ። ኢየሱስ የማያምኑት እነማን እንደ ሆኑ አሳልፎ የሚሰጠውም ማን እንደ ሆነ ከመጀመሪያ ያውቅ ነበርና። ");
INSERT INTO amh_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ደግሞ። ስለዚህ አልኋችሁ፥ ከአብ የተሰጠው ካልሆነ ወደ እኔ ሊመጣ የሚችል የለም አለ። ");
INSERT INTO amh_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ከዚህም የተነሣ ከደቀ መዛሙርቱ ብዙዎች ወደ ኋላ ተመለሱ፤ ወደ ፊትም ከእርሱ ጋር አልሄዱም። ");
INSERT INTO amh_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ኢየሱስም ለአሥራ ሁለቱ። እናንተ ደግሞ ልትሄዱ ትወዳላችሁን? አለ። ");
INSERT INTO amh_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ስምዖን ጴጥሮስ። ጌታ ሆይ፥ ወደ ማን እንሄዳለን? አንተ የዘላለም ሕይወት ቃል አለህ፤ ");
INSERT INTO amh_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","እኛስ አንተ ክርስቶስ የሕያው የእግዚአብሔር ልጅ እንደ ሆንህ አምነናል አውቀናልም ብሎ መለሰለት። ");
INSERT INTO amh_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ኢየሱስም። እኔ እናንተን አሥራ ሁለታችሁን የመረጥኋችሁ አይደለምን? ከእናንተም አንዱ ዲያብሎስ ነው ብሎ መለሰላቸው። ");
INSERT INTO amh_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ስለ ስምዖንም ልጅ ስለ አስቆሮቱ ይሁዳ ተናገረ፤ ከአሥራ ሁለቱ አንዱ የሆነ እርሱ አሳልፎ ይሰጠው ዘንድ አለውና። ");
INSERT INTO amh_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ከዚህም በኋላ ኢየሱስ አይሁድ ሊገድሉት ይፈልጉ ስለ ነበር በይሁዳ ሊመላለስ አይወድም ነበርና በገሊላ ይመላለስ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","የአይሁድም የዳስ በዓል ቀርቦ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","እንግዲህ ወንድሞቹ። ደቀ መዛሙርትህ ደግሞ የምታደርገውን ሥራ እንዲያዩ ከዚህ ተነሣና ወደ ይሁዳ ሂድ፤ ");
INSERT INTO amh_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ራሱ ሊገለጥ እየፈለገ በስውር የሚሠራ የለምና። እነዚህን ብታደርግ ራስህን ለዓለም ግለጥ አሉት። ");
INSERT INTO amh_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ወንድሞቹ ስንኳ አላመኑበትም ነበርና። ");
INSERT INTO amh_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ኢየሱስም እንዲህ አላቸው። ጊዜዬ ገና አልደረሰም፥ ጊዜያችሁ ግን ዘወትር የተመቸ ነው። ");
INSERT INTO amh_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ዓለም እናንተን ሊጠላ አይቻለውም፤ እኔ ግን ሥራው ክፉ መሆኑን እመሰክርበታለሁና እኔን ይጠላኛል። ");
INSERT INTO amh_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","እናንተ ወደዚህ በዓል ውጡ፤ እኔስ ጊዜዬ ገና ስላልተፈጸመ ወደዚህ በዓል ገና አልወጣም። ");
INSERT INTO amh_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ይህንም አላቸውና በገሊላ ቀረ። ");
INSERT INTO amh_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ወንድሞቹ ግን ወደ በዓሉ ከወጡ በኋላ በዚያን ጊዜ እርሱ ደግሞ በግልጥ ሳይሆን ተሰውሮ ወጣ። ");
INSERT INTO amh_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","አይሁድም። እርሱ ወዴት ነው? እያሉ በበዓሉ ይፈልጉት ነበር። ");
INSERT INTO amh_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","በሕዝብም መካከል ስለ እርሱ ብዙ ማንጐራጐር ነበረ፤ አንዳንዱም። ደግ ሰው ነው፤ ሌሎች ግን። አይደለም፥ ሕዝቡን ግን ያስታል ይሉ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ዳሩ ግን አይሁድን ስለ ፈሩ ማንም ስለ እርሱ በግልጥ አይናገርም ነበር። ");
INSERT INTO amh_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","አሁንም በበዓሉ እኩሌታ ኢየሱስ ወደ መቅደስ ወጥቶ ያስተምር ነበር። ");
INSERT INTO amh_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","አይሁድም። ይህ ሰው ሳይማር መጻሕፍትን እንዴት ያውቃል? ብለው ይደነቁ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ስለዚህ ኢየሱስ መለሰ እንዲህም አላቸው። ትምህርቴስ ከላከኝ ነው እንጂ ከእኔ አይደለም፤ ");
INSERT INTO amh_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ፈቃዱን ሊያደርግ የሚወድ ቢኖር፥ እርሱ ይህ ትምህርት ከእግዚአብሔር ቢሆን ወይም እኔ ከራሴ የምናገር ብሆን ያውቃል። ");
INSERT INTO amh_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ከራሱ የሚናገር የራሱን ክብር ይፈልጋል፤ የላከውን ክብር የሚፈልግ ግን እርሱ እውነተኛ ነው በእርሱም ዓመፃ የለበትም። ");
INSERT INTO amh_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ሙሴ ሕግን አልሰጣችሁምን? ከእናንተ ግን ሕግን የሚያደርግ አንድ ስንኳ የለም። ልትገድሉኝ ስለ ምን ትፈልጋላችሁ? ");
INSERT INTO amh_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ሕዝቡ መለሱና። ጋኔን አለብህ፤ ማን ሊገድልህ ይፈልጋል? አሉት። ");
INSERT INTO amh_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ኢየሱስ መለሰ አላቸውም። አንድ ሥራ አደረግሁ ሁላችሁም ታደንቃላችሁ። ");
INSERT INTO amh_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ስለዚህ ሙሴ መገረዝን ሰጣችሁ፤ ከአባቶችም ነው እንጂ ከሙሴ አይደለም፤ በሰንበትም ሰውን ትገርዛላችሁ። ");
INSERT INTO amh_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","የሙሴ ሕግ እንዳይሻር ሰው በሰንበት መገረዝን የሚቀበል ከሆነስ ሰውን ሁለንተናውን በሰንበት ጤናማ ስላደረግሁ ትቈጡኛላችሁን? ");
INSERT INTO amh_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ቅን ፍርድ ፍረዱ እንጂ በመልክ አትፍረዱ። ");
INSERT INTO amh_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","እንግዲህ ከኢየሩሳሌም ሰዎች አንዳንዶቹ እንዲህ አሉ። ሊገድሉት የሚፈልጉት ይህ አይደለምን? ");
INSERT INTO amh_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","እነሆም፥ በግልጥ ይናገራል አንዳችም አይሉትም። አለቆቹ ይህ ሰው በእውነት ክርስቶስ እንደ ሆነ በእውነት አወቁን? ");
INSERT INTO amh_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ነገር ግን ይህን ከወዴት እንደ ሆነ አውቀናል፤ ክርስቶስ ሲመጣ ግን ከወዴት እንደ ሆነ ማንም አያውቅም። ");
INSERT INTO amh_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","እንግዲህ ኢየሱስ በመቅደስ ሲያስተምር። እኔንም ታውቁኛላችሁ ከወዴትም እንደ ሆንሁ ታውቃላችሁ፤ እኔም በራሴ አልመጣሁም ነገር ግን እናንተ የማታውቁት የላከኝ እውነተኛ ነው፤ ");
INSERT INTO amh_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","እኔ ግን ከእርሱ ዘንድ ነኝ እርሱም ልኮኛልና አውቀዋለሁ ብሎ ጮኸ። ");
INSERT INTO amh_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ስለዚህ ሊይዙት ይፈልጉ ነበር፤ ነገር ግን ጊዜው ገና ስላልደረሰ ማንም እጁን አልጫነበትም። ");
INSERT INTO amh_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ከሕዝቡ ግን ብዙዎች አመኑበትና። ክርስቶስ በመጣ ጊዜ ይህ ካደረጋቸው ምልክቶች ይልቅ ያደርጋልን? አሉ። ");
INSERT INTO amh_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ፈሪሳውያንም ሕዝቡ ሰለ እርሱ እንደዚህ ሲያንጐራጕሩ ሰሙ፤ የካህናት አለቆችም ፈሪሳውያም ሊይዙት ሎሌዎችን ላኩ። ");
INSERT INTO amh_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ኢየሱስም። ገና ጥቂት ጊዜ ከእናንተ ጋር እቆያለሁ ወደ ላከኝም እሄዳለሁ። ");
INSERT INTO amh_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ትፈልጉኛላችሁ አታገኙኝምም፤ እኔም ወዳለሁበት እናንተ ልትመጡ አትችሉም አለ። ");
INSERT INTO amh_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","እንግዲህ አይሁድ። እኛ እንዳናገኘው ይህ ወዴት ይሄድ ዘንድ አለው? በግሪክ ሰዎች መካከል ተበትነው ወደሚኖሩት ሊሄድና የግሪክን ሰዎች ሊያስተምር አለውን? ");
INSERT INTO amh_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","እርሱ። ትፈልጉኛላችሁ አታገኙኝምም እኔም ወዳለሁበት እናንተ ልትመጡ አትችሉም የሚለው ይህ ቃል ምንድር ነው? ብለው እርስ በርሳቸው ተነጋገሩ። ");
INSERT INTO amh_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ከበዓሉም በታላቁ በኋለኛው ቀን ኢየሱስ ቆሞ። ማንም የተጠማ ቢኖር ወደ እኔ ይምጣና ይጠጣ። ");
INSERT INTO amh_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","በእኔ የሚያምን መጽሐፍ እንዳለ፥ የሕይወት ውኃ ወንዝ ከሆዱ ይፈልቃል ብሎ ጮኸ። ");
INSERT INTO amh_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ይህን ግን በእርሱ የሚያምኑ ሊቀበሉት ስላላቸው ስለ መንፈስ ተናገረ፤ ኢየሱስ ገና ስላልከበረ መንፈስ ገና አልወረደም ነበርና። ");
INSERT INTO amh_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ስለዚህ ከሕዝቡ አያሌ ሰዎች ይህን ቃል ሲሰሙ። ይህ በእውነት ነቢዩ ነው አሉ፤ ");
INSERT INTO amh_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ሌሎች። ይህ ክርስቶስ ነው አሉ፤ ሌሎች ግን። ክርስቶስ በእውኑ ከገሊላ ይመጣልን? ");
INSERT INTO amh_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ክርስቶስ ከዳዊት ዘር ዳዊትም ከነበረባት መንደር ከቤተ ልሔም እንዲመጣ መጽሐፍ አላለምን? አሉ። ");
INSERT INTO amh_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","እንግዲህ ከእርሱ የተነሣ በሕዝቡ መካከል መለያየት ሆነ፤ ");
INSERT INTO amh_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ከእነርሱም አንዳንዶቹ ሊይዙት ወደዱ ነገር ግን እጁን ማንም አልጫነበትም። ");
INSERT INTO amh_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ሎሌዎቹም ወደ ካህናት አለቆችና ወደ ፈሪሳውያን መጡ፤ እነዚያም። ያላመጣችሁት ስለ ምን ነው? አሉአቸው። ");
INSERT INTO amh_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ሎሌዎቹ። እንደዚህ ሰው ማንም እንዲሁ ከቶ አልተናገረም ብለው መለሱ። ");
INSERT INTO amh_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","እንግዲህ ፈሪሳውያን። እናንተ ደግሞ ሳታችሁን? ");
INSERT INTO amh_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ከአለቆች ወይስ ከፈሪሳውያን በእርሱ ያመነ አለን? ");
INSERT INTO amh_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ነገር ግን ሕግን የማያውቀው ይህ ሕዝብ ርጉም ነው ብለው መለሱላቸው። ");
INSERT INTO amh_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ከእነርሱ አንዱ በሌሊት ቀድሞ ወደ እርሱ መጥቶ የነበረ ኒቆዲሞስ። ");
INSERT INTO amh_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","ሕጋችን አስቀድሞ ከእርሱ ሳይሰማ ምንስ እንዳደረገ ሳያውቅ በሰው ይፈርዳልን? አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","እነርሱም መለሱና። አንተም ደግሞ ከገሊላ ነህን? ነቢይ ከገሊላ እንዳይነሣ መርምርና እይ አሉት። ");
INSERT INTO amh_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","እያንዳንዱም ወደ ቤቱ ሄደ። ");
INSERT INTO amh_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ኢየሱስ ግን ወደ ደብረ ዘይት ሄደ። ");
INSERT INTO amh_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ማለዳም ደግሞ ወደ መቅደስ ደረሰ ሕዝቡም ሁሉ ወደ እርሱ መጡ። ተቀምጦም ያስተምራቸው ነበር። ");
INSERT INTO amh_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ጻፎችና ፈሪሳውያንም በምንዝር የተያዘችን ሴት ወደ እርሱ አመጡ በመካከልም እርሱዋን አቁመው። ");
INSERT INTO amh_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","መምህር ሆይ፥ ይህች ሴት ስታመነዝር ተገኝታ ተያዘች። ");
INSERT INTO amh_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ሙሴም እንደነዚህ ያሉት እንዲወገሩ በሕግ አዘዘን፤ አንተስ ስለ እርስዋ ምን ትላለህ? አሉት። ");
INSERT INTO amh_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","የሚከሱበትንም እንዲያገኙ ሊፈትኑት ይህን አሉ። ኢየሱስ ግን ጐንበስ ብሎ በጣቱ በምድር ላይ ጻፈ፤ ");
INSERT INTO amh_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","መላልሰው በጠየቁት ጊዜ ግን ቀና ብሎ። ከእናንተ ኃጢአት የሌለበት አስቀድሞ በድንጋይ ይውገራት አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ደግሞም ጐንበስ ብሎ በጣቱ በምድር ላይ ጻፈ። ");
INSERT INTO amh_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","እነርሱም ይህን ሲሰሙ ሕሊናቸው ወቀሳቸውና ከሽማግሌዎች ጀምረው እስከ ኋለኞች አንድ አንድ እያሉ ወጡ፤ ኢየሱስም ብቻውን ቀረ ሴቲቱም በመካከል ቆማ ነበረች። ");
INSERT INTO amh_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ኢየሱስም ቀና ብሎ ከሴቲቱ በቀር ማንንም ባላየ ጊዜ። አንቺ ሴት፥ እነዚያ ከሳሾችሽ ወዴት አሉ? የፈረደብሽ የለምን? አላት። ");
INSERT INTO amh_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","እርስዋም። ጌታ ሆይ፥ አንድ ስንኳ አለች። ኢየሱስም። እኔም አልፈርድብሽም፤ ሂጂ ከአሁንም ጀምሮ ደግመሽ ኃጢአት አትሥሪ አላት። ");
INSERT INTO amh_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ደግሞም ኢየሱስ። እኔ የዓለም ብርሃን ነኝ፤ የሚከተለኝ የሕይወት ብርሃን ይሆንለታል እንጂ በጨለማ አይመላለስም ብሎ ተናገራቸው። ");
INSERT INTO amh_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ፈሪሳውያንም። አንተ ስለ ራስህ ትመሰክራለህ፤ ምስክርነትህ እውነት አይደለም አሉት። ");
INSERT INTO amh_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ኢየሱስ መለሰ አላቸውም። እኔ ስለ ራሴ ምንም እንኳ ብመሰክር ከወዴት እንደመጣሁ ወዴትም እንድሄድ አውቃለሁና ምስክርነቴ እውነት ነው፤ እናንተ ግን ከወዴት እንደ መጣሁ ወዴትም እንድሄድ አታውቁም። ");
INSERT INTO amh_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","እናንተ ሥጋዊ ፍርድን ትፈርዳላችሁ፤ እኔ በአንድ ሰው ስንኳ አልፈርድም። ");
INSERT INTO amh_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","የላከኝ አብ ከእኔ ጋር ነው እንጂ ብቻዬን አይደለሁምና እኔ ብፈርድ ፍርዴ እውነት ነው። ");
INSERT INTO amh_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","የሁለት ሰዎችም ምስክርነት እውነት እንደ ሆነ በሕጋችሁ ተጽፎአል። ");
INSERT INTO amh_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ስለ ራሴ የምመሰክር እኔ ነኝ፥ የላከኝም አብ ስለ እኔ ይመሰክራል። ");
INSERT INTO amh_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","እንግዲህ። አባትህ ወዴት ነው? አሉት። ኢየሱስ መልሶ። እኔንም ወይም አባቴንም አታውቁም፤ እኔንስ ብታውቁኝ አባቴን ደግሞ ባወቃችሁ ነበር አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ኢየሱስ በመቅደስ ሲያስተምር በግምጃ ቤት አጠገብ ይህን ነገር ተናገረ፤ ጊዜው ገና አልደረሰምና ማንም አልያዘውም። ");
INSERT INTO amh_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ኢየሱስም ደግሞ። እኔ እሄዳለሁ ትፈልጉኛላችሁም በኃጢአታችሁም ትሞታላችሁ እኔ ወደምሄድበት እናንተ ልትመጡ አትችሉም አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","አይሁድም። እኔ ወደ ምሄድበት እናንተ ልትመጡ አትችሉም ማለቱ ራሱን ይገድላልን? እንጃ አሉ። ");
INSERT INTO amh_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","እናንተ ከታች ናችሁ፥ እኔ ከላይ ነኝ፤ እናንተ ከዚህ ዓለም ናችሁ፥ እኔ ከዚህ ዓለም አይደለሁም። ");
INSERT INTO amh_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","እንግዲህ። በኃጢአታችሁ ትሞታላችሁ አልኋችሁ፤ እኔ እንደሆንሁ ባታምኑ በኃጢአታችሁ ትሞታላችሁና አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","እንግዲህ። አንተ ማን ነህ? አሉት። ኢየሱስም። ከመጀመሪያ ለእናንተ የተናገርሁት ነኝ። ");
INSERT INTO amh_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ስለ እናንተ የምናገረው የምፈርደውም ብዙ ነገር አለኝ፤ ዳሩ ግን የላከኝ እውነተኛ ነው እኔም ከእርሱ የሰማሁትን ይህን ለዓለም እናገራለሁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ስለ አብ እንደ ነገራቸው አላስተዋሉም። ");
INSERT INTO amh_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ስለዚህም ኢየሱስ። የሰውን ልጅ ከፍ ከፍ ባደረጋችሁት ጊዜ እኔ እሆን ዘንድ አባቴም እንዳስተማረኝ እነዚህን እናገር ዘንድ እንጂ ከራሴ አንዳች እንዳላደርግ በዚያን ጊዜ ታውቃላችሁ። ");
INSERT INTO amh_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","የላከኝም ከእኔ ጋር ነው፤ እኔ ደስ የሚያሰኘውን ዘወትር አደርጋለሁና አብ ብቻዬን አይተወኝም አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ይህን ሲናገር ብዙዎች በእርሱ አመኑ። ");
INSERT INTO amh_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ኢየሱስም ያመኑትን አይሁድ። እናንተ በቃሌ ብትኖሩ በእውነት ደቀ መዛሙርቴ ናችሁ፤ ");
INSERT INTO amh_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","እውነትንም ታውቃላችሁ እውነትም አርነት ያወጣችኋል አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","እነርሱም መልሰው። የአብርሃም ዘር ነን ለአንድም ስንኳ ከቶ ባሪያዎች አልሆንም፤ አንተ። አርነት ትወጣላችሁ እንዴት ትላለህ? አሉት። ");
INSERT INTO amh_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ኢየሱስ መለሰ፥ እንዲህ ሲል። እውነት እውነት እላችኋለሁ፥ ኃጢአት የሚያደርግ ሁሉ የኃጢአት ባርያ ነው። ");
INSERT INTO amh_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ባርያም ለዘላለም በቤት አይኖርም፤ ልጁ ለዘላለም ይኖራል። ");
INSERT INTO amh_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","እንግዲህ ልጁ አርነት ቢያወጣችሁ በእውነት አርነት ትወጣላችሁ። ");
INSERT INTO amh_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","የአብርሃም ዘር መሆናችሁንስ አውቃለሁ ነገር ግን ቃሌ በእናንተ አይኖርምና ልትገድሉኝ ትፈልጋላችሁ። ");
INSERT INTO amh_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","እኔ በአባቴ ዘንድ ያየሁትን እናገራለሁ፤ እናንተም ደግሞ በአባታችሁ ዘንድ ያያችሁትን ታደርጋላችሁ። ");
INSERT INTO amh_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","መልሰውም። አባታችንስ አብርሃም ነው አሉት። ኢየሱስም። የአብሃም ልጆች ብትሆኑ የአብርሃምን ሥራ ባደረጋችሁ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ነገር ግን አሁን ከእግዚእብሔር የሰማሁትን እውነት የነገርኋችሁን ሰው ልትገድሉኝ ትፈልጋላችሁ፤ አብርሃም እንዲህ አላደረገም። ");
INSERT INTO amh_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","እናንተ የአባታችሁን ሥራ ታደርጋላችሁ አላቸው። እኛስ ከዝሙት አልተወለድንም አንድ አባት አለን እርሱም እግዚአብሔር ነው አሉት። ");
INSERT INTO amh_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ኢየሱስም አላቸው። እግዚአብሔርስ አባታችሁ ከሆነ በወደዳችሁኝ ነበር፤ እኔ ከእግዚአብሔር ወጥቼ መጥቻለሁና፤ እርሱ ላከኝ እንጂ ከራሴ አልመጣሁምና። ");
INSERT INTO amh_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ንግግሬን የማታስተውሉ ስለ ምንድር ነው? ቃሌን ልትሰሙ ስለማትችሉ ነው። ");
INSERT INTO amh_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","እናንተ ከአባታችሁ ከዲያብሎስ ናችሁ የአባታችሁንም ምኞት ልታደርጉ ትወዳላችሁ። እርሱ ከመጀመሪያ ነፍሰ ገዳይ ነበረ፤ እውነትም በእርሱ ስለ ሌለ በእውነት አልቆመም። ሐሰትን ሲናገር ከራሱ ይናገራል፥ ሐሰተኛ የሐሰትም አባት ነውና። ");
INSERT INTO amh_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","እኔ ግን እውነትን የምናገር ስለ ሆንሁ አታምኑኝም። ");
INSERT INTO amh_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ከእናንተ ስለ ኃጢአት የሚወቅሰኝ ማን ነው? እውነት የምናገር ከሆንሁ እናንተ ስለ ምን አታምኑኝም? ");
INSERT INTO amh_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ከእግዚአብሔር የሆነ የእግዚአብሔርን ቃል ይሰማል፤ እናንተ ከእግዚአብሔር አይደላችሁምና ስለዚህ አትሰሙም። ");
INSERT INTO amh_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","አይሁድ መልሰው። ሳምራዊ እንደ ሆንህ ጋኔንም እንዳለብህ በማለታችን እኛ መልካም እንል የለምን? አሉት። ");
INSERT INTO amh_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ኢየሱስም መለሰ፥ እንዲህ ሲል። እኔስ ጋኔን የለብኝም ነገር ግን አባቴን አከብራለሁ እናንተም ታዋርዱኛላችሁ። ");
INSERT INTO amh_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","እኔ ግን የራሴን ክብር አልፈልግም፤ የሚፈልግ የሚፈርድም አለ። ");
INSERT INTO amh_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","እውነት እውነት እላችኋለሁ፥ ቃሌን የሚጠብቅ ቢኖር ለዘላለም ሞትን አያይም። ");
INSERT INTO amh_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","አይሁድ። ጋኔን እንዳለብህ አሁን አወቅን። አብርሃም ስንኳ ሞተ ነቢያትም፤ አንተም። ቃሌን የሚጠብቅ ቢኖር ለዘላለም ሞትን አይቀምስም ትላለህ። ");
INSERT INTO amh_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","በእውኑ አንተ ከሞተው ከአባታችን ከአብርሃም ትበልጣለህን? ነቢያትም ሞቱ፤ ራስህን ማንን ታደርጋለህ? አሉት። ");
INSERT INTO amh_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ኢየሱስም መለሰ አለም። እኔ ራሴን ባከብር ክብሬ ከንቱ ነው፤ የሚያከብረኝ እናንተ አምላካችን የምትሉት አባቴ ነው፤ ");
INSERT INTO amh_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","አላወቃችሁትምም፥ እኔ ግን አውቀዋለሁ። አላውቀውም ብል እንደ እናንተ ሐሰተኛ በሆንሁ፤ ዳሩ ግን አውቀዋለሁ ቃሉንም እጠብቃለሁ። ");
INSERT INTO amh_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","አባታችሁ አብርሃም ቀኔን ያይ ዘንድ ሐሤት አደረገ፥ አየም ደስም አለው። ");
INSERT INTO amh_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","አይሁድም። ገና አምሳ ዓመት ያልሆነህ አብርሃምን አይተሃልን? አሉት። ");
INSERT INTO amh_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ኢየሱስም። እውነት እውነት እላችኋለሁ፥ አብርሃም ሳይወለድ እኔ አለሁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ስለዚህ ሊወግሩት ድንጋይ አነሡ፤ ኢየሱስ ግን ተሰወራቸው ከመቅደስም ወጥቶ በመካከላቸው አልፎ ሄደ። ");
INSERT INTO amh_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ሲያልፍም ከመወለዱ ጀምሮ ዕውር የሆነውን ሰው አየ። ");
INSERT INTO amh_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ደቀ መዛሙርቱም። መምህር ሆይ፥ ይህ ሰው ዕውር ሆኖ እንዲወለድ ኃጢአት የሠራ ማን ነው? እርሱ ወይስ ወላጆቹ? ብለው ጠየቁት። ");
INSERT INTO amh_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ኢየሱስም እንዲህ ብሎ መለሰ። የእግዚአብሔር ሥራ በእርሱ እንዲገለጥ ነው እንጂ እርሱ ወይም ወላጆቹ ኃጢአት አልሠሩም። ");
INSERT INTO amh_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ቀን ሳለ የላከኝን ሥራ ላደርግ ይገባኛል፤ ማንም ሊሠራ የማይችልባት ሌሊት ትመጣለች። ");
INSERT INTO amh_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","በዓለም ሳለሁ የዓለም ብርሃን ነኝ። ");
INSERT INTO amh_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ይህን ብሎ ወደ መሬት እንትፍ አለ በምራቁም ጭቃ አድርጎ በጭቃው የዕውሩን ዓይኖች ቀባና። ");
INSERT INTO amh_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ሂድና በሰሊሆም መጠመቂያ ታጠብ አለው፤ ትርጓሜው የተላከ ነው። ስለዚህ ሄዶ ታጠበ እያየም መጣ። ");
INSERT INTO amh_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ጐረቤቶቹም ቀድሞም ሲለምን አይተውት የነበሩ። ይህ ተቀምጦ ይለምን የነበረ አይደለምን? አሉ። ");
INSERT INTO amh_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ሌሎች። እርሱ ነው አሉ፤ ሌሎች። አይደለም እርሱን ይመስላል እንጂ አሉ፤ እርሱ። እኔ ነኝ አለ። ");
INSERT INTO amh_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ታድያ። ዓይኖችህ እንዴት ተከፈቱ? አሉት። ");
INSERT INTO amh_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","እርሱ መልሶ። ኢየሱስ የሚባለው ሰው ጭቃ አድርጎ አይኖቼን ቀባና። ወደ ሰሊሆም መጠመቂያ ሄደህ ታጠብ አለኝ፤ ሄጄ ታጥቤም አየሁ አለ። ");
INSERT INTO amh_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ያ ሰው ወዴት ነው? አሉት። አላውቅም አለ። ");
INSERT INTO amh_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","በፊት ዕውር የነበረውን ሰው ወደ ፈሪሳውያን ወሰዱት። ");
INSERT INTO amh_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ኢየሱስም ጭቃ አድርጎ ዓይኖቹን የከፈተበት ቀን ሰንበት ነበረ። ");
INSERT INTO amh_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ስለዚህ ፈሪሳውያን ደግሞ እንዴት እንዳየ እንደ ገና ጠየቁት። እርሱም። ጭቃ በዓይኖቼ አኖረ ታጠብሁም አያለሁም አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ከፈሪሳውያንም አንዳንዶቹ። ይህ ሰው ሰንበትን አያከብርምና ከእግዚአብሔር አይደለም አሉ። ሌሎች ግን። ኃጢአትኛ ሰው እንደነዚህ ያሉ ምልክቶች ሊያደርግ እንዴት ይችላል? አሉ። ");
INSERT INTO amh_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","በመካከላቸውም መለያየት ሆነ። ከዚህም የተነሣ ዕውሩን። አንተ ዓይኖችህን ስለ ከፈተ ስለ እርሱ ምን ትላለህ? ደግሞ አሉት። እርሱም። ነቢይ ነው አለ። ");
INSERT INTO amh_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","አይሁድ የዚያን ያየውን ወላጆች እስኪጠሩ ድረስ ዕውር እንደ ነበረ እንዳየም ስለ እርሱ አላመኑም፥ ");
INSERT INTO amh_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","እነርሱንም። እናንተ ዕውር ሆኖ ተወለደ የምትሉት ልጃችሁ ይህ ነውን? ታድያ አሁን እንዴት ያያል? ብለው ጠየቁአቸው። ");
INSERT INTO amh_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ወላጆቹም መልሰው። ይህ ልጃችን እንደ ሆነ ዕውርም ሆኖ እንደ ተወለደ አናውቃለን፤ ");
INSERT INTO amh_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ዳሩ ግን አሁን እንዴት እንዳየ አናውቅም፥ ወይም ዓይኖቹን ማን እንደ ከፈተ እኛ አናውቅም፤ ጠይቁት እርሱ ሙሉ ሰው ነው፤ እርሱ ስለ ራሱ ይናገራል አሉ። ");
INSERT INTO amh_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ወላጆቹ አይሁድን ስለ ፈሩ ይህን አሉ፤ እርሱ ክርስቶስ ነው ብሎ የሚመሰክር ቢኖር ከምኵራብ እንዲያወጡት አይሁድ ከዚህ በፊት ተስማምተው ነበርና። ");
INSERT INTO amh_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ስለዚህ ወላጆቹ። ሙሉ ሰው ነው፥ ጠይቁት አሉ። ");
INSERT INTO amh_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ስለዚህ ዕውር የነበረውን ሰው ሁለተኛ ጠርተው። እግዚአብሔርን አክብር፤ ይህ ሰው ኃጢአተኛ መሆኑን እኛ እናውቃለን አሉት። ");
INSERT INTO amh_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","እርሱም መልሶ። ኃጢአተኛ መሆኑን አላውቅም፤ ዕውር እንደ ነበርሁ አሁንም እንዳይ ይህን አንድ ነገር አውቃለሁ አለ። ");
INSERT INTO amh_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ደግመውም። ምን አደረገልህ? እንዴትስ ዓይኖችህን ከፈተ? አሉት። ");
INSERT INTO amh_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","እርሱም መልሶ። አስቀድሜ ነገርኋችሁ አልሰማችሁምም፤ ስለ ምን ዳግመኛ ልትሰሙ ትወዳላችሁ? እናንተ ደግሞ ደቀ መዛሙርቱ ልትሆኑ ትወዳላችሁን? አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ተሳድበውም። አንተ የእርሱ ደቀ መዝሙር ነህ፥ እኛ ግን የሙሴ ደቀ መዛሙርት ነን፤ ");
INSERT INTO amh_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","እግዚአብሔር ሙሴን እንደ ተናገረው እኛ እናውቃለን፥ ይህ ሰው ግን ከወዴት እንደ ሆነ አናውቅም አሉት። ");
INSERT INTO amh_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ሰውዬው መለሰ እንዲህም አላቸው። ከወዴት እንደ ሆነ እናንተ አለማወቃችሁ ይህ ድንቅ ነገር ነው፥ ዳሩ ግን ዓይኖቼን ከፈተ። ");
INSERT INTO amh_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","እግዚአብሔርን የሚፈራ ፈቃዱንም የሚያደርግ ቢኖር ያንን እግዚአብሔር ይሰማዋል እንጂ ኃጢአተኞችን እንዳይሰማ እናውቃለን። ");
INSERT INTO amh_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ዕውር ሆኖ የተወለደውን ዓይኖች ማንም እንደ ከፈተ ዓለም ከተፈጠረ ጀምሮ አልተሰማም፤ ");
INSERT INTO amh_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ይህ ሰው ከእግዚአብሔር ባይሆን ምንም ሊያደርግ ባልቻለም ነበር። ");
INSERT INTO amh_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","መልሰው። አንተ ሁለንተናህ በኃጢአት ተወለድህ፥ አንተም እኛን ታስተምረናለህን? አሉት። ወደ ውጭም አወጡት። ");
INSERT INTO amh_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ኢየሱስም ወደ ውጭ እንዳወጡት ሰማ ሲያገኘውም። አንተ በእግዚአብሔር ልጅ ታምናለህን? አለው። ");
INSERT INTO amh_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","እርሱም መልሶ። ጌታ ሆይ፥ በእርሱ አምን ዘንድ ማን ነው? አለ። ");
INSERT INTO amh_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ኢየሱስም። አይተኸዋልም ከአንተ ጋርም የሚናገረው እርሱ ነው አለው። ");
INSERT INTO amh_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","እርሱም። ጌታ ሆይ፥ አምናለሁ አለ፤ ሰገደለትም። ");
INSERT INTO amh_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ኢየሱስም። የማያዩ እንዲያዩ የሚያዩም እንዲታወሩ እኔ ወደዚህ ዓለም ለፍርድ መጣሁ አለ። ");
INSERT INTO amh_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ከፈሪሳውያንም ከእርሱ ጋር የነበሩት ይህን ሰምተው። እኛ ደግሞ ዕውሮች ነንን? አሉት። ");
INSERT INTO amh_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ኢየሱስም አላቸው። ዕውሮችስ ብትሆኑ ኃጢአት ባልሆነባችሁም ነበር፤ አሁን ግን። እናያለን ትላላችሁ፤ ኃጢአታችሁ ይኖራል። ");
INSERT INTO amh_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","እውነት እውነት እላችኋለሁ፥ ወደ በጎች በረት በበሩ የማይገባ በሌላ መንገድ ግን የሚወጣ እርሱ ሌባ ወንበዴም ነው፤ ");
INSERT INTO amh_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","በበሩ የሚገባ ግን የበጎች እረኛ ነው። ");
INSERT INTO amh_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ለእርሱ በረኛው ይከፍትለታል፤ በጎቹም ድምፁን ይሰሙታል፥ የራሱንም በጎች በየስማቸው ጠርቶ ይወስዳቸዋል። ");
INSERT INTO amh_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","የራሱንም ሁሉ ካወጣቸው በኋላ በፊታቸው ይሄዳል፥ በጎቹም ድምፁን ያውቃሉና ይከተሉታል፤ ");
INSERT INTO amh_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ከሌላው ግን ይሸሻሉ እንጂ አይከተሉትም፥ የሌሎችን ድምፅ አያውቁምና። ");
INSERT INTO amh_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ኢየሱስ ይህን ምሳሌ ነገራቸው፤ እነርሱ ግን የነገራቸው ምን እንደ ሆነ አላስተዋሉም። ");
INSERT INTO amh_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ኢየሱስም ደግሞ አላቸው። እውነት እውነት እላችኋለሁ፥ እኔ የበጎች በር ነኝ። ");
INSERT INTO amh_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ከእኔ በፊት የመጡ ሁሉ ሌቦችና ወንበዴዎች ናቸው፤ ዳሩ ግን በጎቹ አልሰሙአቸውም። ");
INSERT INTO amh_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","በሩ እኔ ነኝ፤ በእኔ የሚገባ ቢኖር ይድናል፥ ይገባልም ይወጣልም መሰማሪያም ያገኛል። ");
INSERT INTO amh_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ሌባው ሊሰርቅና ሊያርድ ሊያጠፋም እንጂ ስለ ሌላ አይመጣም፤ እኔ ሕይወት እንዲሆንላቸው እንዲበዛላቸውም መጣሁ። ");
INSERT INTO amh_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","መልካም እረኛ እኔ ነኝ። መልካም እረኛ ነፍሱን ስለ በጎቹ ያኖራል። ");
INSERT INTO amh_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","እረኛ ያልሆነው በጎቹም የእርሱ ያልሆኑ ሞያተኛ ግን ተኵላ ሲመጣ ባየ ጊዜ በጎቹን ትቶ ይሸሻል፤ ተኵላም ይነጥቃቸዋል በጎቹንም ይበትናቸዋል። ");
INSERT INTO amh_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ሞያተኛ ስለ ሆነ ለበጎቹም ስለማይገደው ሞያተኛው ይሸሻል። ");
INSERT INTO amh_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","16","ከዚህም በረት ያልሆኑ ሌሎች በጎች አሉኝ፤ እነርሱን ደግሞ ላመጣ ይገባኛል ድምፄንም ይሰማሉ፥ አንድም መንጋ ይሆናሉ እረኛውም አንድ። ");
INSERT INTO amh_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ነፍሴን ደግሞ አነሣት ዘንድ አኖራለሁና ስለዚህ አብ ይወደኛል። ");
INSERT INTO amh_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","እኔ በፈቃዴ አኖራታለሁ እንጂ ከእኔ ማንም አይወስዳትም። ላኖራት ሥልጣን አለኝ ደግሞም ላነሣት ሥልጣን አለኝ ይህችን ትእዛዝ ከአባቴ ተቀበልሁ። ");
INSERT INTO amh_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","እንግዲህ ከዚህ ቃል የተነሣ በአይሁድ መካከል እንደ ገና መለያየት ሆነ። ");
INSERT INTO amh_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ከእነርሱም ብዙዎች። ጋኔን አለበት አብዶአልም፤ ስለ ምንስ ትሰሙታላችሁ? አሉ። ");
INSERT INTO amh_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ሌሎችም። ይህ ጋኔን ያለበት ሰው ቃል አይደለም፤ ጋኔን የዕውሮችን ዓይኖች ሊከፍት ይችላልን? አሉ። ");
INSERT INTO amh_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","በኢየሩሳሌምም የመቅደስ መታደስ በዓል ሆነ፤ ");
INSERT INTO amh_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ክረምትም ነበረ። ኢየሱስም በመቅደስ በሰሎሞን ደጅ መመላለሻ ይመላለስ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","አይሁድም እርሱን ከበው። እስከ መቼ ድረስ በጥርጣሪ ታቆየናለህ? አንተ ክርስቶስ እንደ ሆንህ ገልጠህ ንገረን አሉት። ");
INSERT INTO amh_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ኢየሱስም መለሰላቸው፥ እንዲህ ሲል። ነገርኋችሁ አታምኑምም እኔ በአባቴ ስም የማደርገው ሥራ ይህ ስለ እኔ ይመሰክራል፤ ");
INSERT INTO amh_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","እናንተ ግን እንደ ነገርኋችሁ ከበጎቼ ስላልሆናችሁ አታምኑም። ");
INSERT INTO amh_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","በጎቼ ድምፄን ይሰማሉ እኔም አውቃቸዋለሁ ይከተሉኝማል፤ ");
INSERT INTO amh_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","እኔም የዘላለም ሕይወትን እሰጣቸዋለሁ፥ ለዘላለምም አይጠፉም፥ ከእጄም ማንም አይነጥቃቸውም። ");
INSERT INTO amh_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","የሰጠኝ አባቴ ከሁሉ ይበልጣል፥ ከአባቴም እጅ ሊነጥቃቸው ማንም አይችልም። ");
INSERT INTO amh_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","እኔና አብ አንድ ነን። ");
INSERT INTO amh_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","አይሁድ ሊወግሩት ደግመው ድንጋይ አነሡ። ");
INSERT INTO amh_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ኢየሱስ። ከአባቴ ብዙ መልካም ሥራ አሳየኋችሁ፤ ከእነርሱ ስለ ማናቸው ሥራ ትወግሩኛላችሁ? ብሎ መለሰላቸው። ");
INSERT INTO amh_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","አይሁድም። ስለ መልካም ሥራ አንወግርህም፤ ስለ ስድብ፤ አንተም ሰው ስትሆን ራስህን አምላክ ስለ ማድረግህ ነው እንጂ ብለው መለሱለት። ");
INSERT INTO amh_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ኢየሱስም እንዲህ ብሎ መለሰላቸው። እኔ። አማልክት ናችሁ አልሁ ተብሎ በሕጋችሁ የተጻፈ አይደለምን? ");
INSERT INTO amh_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","መጽሐፉ ሊሻር አይቻልምና እነዚያን የእግዚአብሔር ቃል የመጣላቸውን አማልክት ካላቸው፥ ");
INSERT INTO amh_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","የእግዚአብሔር ልጅ ነኝ ስላልሁ እናንተ አብ የቀደሰውን ወደ ዓለምም የላከውን። ትሳደባለህ ትሉታላችሁን? ");
INSERT INTO amh_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","እኔ የአባቴን ሥራ ባላደርግ አትመኑኝ፤ ");
INSERT INTO amh_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ባደርገው ግን፥ እኔን ስንኳ ባታምኑ አብ በእኔ እንደ ሆነ እኔም በአብ እንደ ሆንሁ ታውቁና ታስተውሉ ዘንድ ሥራውን እመኑ። ");
INSERT INTO amh_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","እንግዲህ ደግመው ሊይዙት ፈለጉ፤ ከእጃቸውም ወጣ። ");
INSERT INTO amh_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ዮሐንስም በመጀመሪያ ያጠምቅበት ወደ ነበረው ስፍራ ወደ ዮርዳኖስ ማዶ እንደ ገና ሄደ በዚያም ኖረ። ");
INSERT INTO amh_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ብዙ ሰዎችም ወደ እርሱ መጥተው። ዮሐንስ አንድ ምልክት ስንኳ አላደረገም፥ ነገር ግን ዮሐንስ ስለዚህ ሰው የተናገረው ሁሉ እውነት ነበረ አሉ። ");
INSERT INTO amh_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","በዚያም ብዙዎች በእርሱ አመኑ። ");
INSERT INTO amh_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ከማርያምና ከእኅትዋ ከማርታ መንደር ከቢታንያ የሆነ አልዓዛር የሚባል አንድ ሰው ታሞ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ማርያምም ጌታን ሽቱ የቀባችው እግሩንም በጠጕርዋ ያበሰችው ነበረች፤ ወንድምዋም አልዓዛር ታሞ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ስለዚህ እኅቶቹ ጌታ ሆይ፥ እነሆ የምትወደው ታሞአል ብለው ወደ እርሱ ላኩ። ");
INSERT INTO amh_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ኢየሱስም ሰምቶ። ይህ ህመም የእግዚአብሔር ልጅ በእርሱ ይከብር ዘንድ ስለ እግዚአብሔር ክብር ነው እንጂ ለሞት አይደለም አለ። ");
INSERT INTO amh_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ኢየሱስም ማርታንና እኅትዋን አልዓዛርንም ይወድ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","እንደ ታመመም በሰማ ጊዜ ያን ጊዜ በነበረበት ስፍራ ሁለት ቀን ዋለ፤ ");
INSERT INTO amh_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ከዚህም በኋላ ለደቀ መዛሙርቱ። ወደ ይሁዳ ደግሞ እንሂድ አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ደቀ መዛሙርቱ። መምህር ሆይ፥ አይሁድ ከጥቂት ጊዜ በፊት ሊወግሩህ ይፈልጉ ነበር፥ ደግሞም ወደዚያ ትሄዳለህን? አሉት። ");
INSERT INTO amh_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ኢየሱስም መልሶ። ቀኑ አሥራ ሁለት ሰዓት አይደለምን? በቀን የሚመላለስ ቢኖር የዚህን ዓለም ብርሃን ያያልና አይሰናከልም፤ ");
INSERT INTO amh_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","በሌሊት የሚመላለስ ቢኖር ግን ብርሃን በእርሱ ስለ ሌለ ይሰናከላል አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ይህን ተናገረ፤ ከዚህም በኋላ። ወዳጃችን አልዓዛር ተኝቶአል፤ ነገር ግን ከእንቅልፉ ላስነሣው እሄዳለሁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","እንግዲህ ደቀ መዛሙርቱ። ጌታ ሆይ፥ ተኝቶስ እንደ ሆነ ይድናል አሉት። ");
INSERT INTO amh_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ኢየሱስስ ስለ ሞቱ ተናግሮ ነበር፤ እነርሱ ግን ስለ እንቅልፍ መተኛት እንደ ተናገረ መሰላቸው። ");
INSERT INTO amh_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","እንግዲህ ያን ጊዜ ኢየሱስ በግልጥ። አልዓዛር ሞተ፤ ");
INSERT INTO amh_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","እንድታምኑም በዚያ ባለመኖሬ ስለ እናንተ ደስ ይለኛል፤ ነገር ግን ወደ እርሱ እንሂድ አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ስለዚህ ዲዲሞስ የሚሉት ቶማስ ለባልንጀሮቹ ለደቀ መዛሙርት። ከእርሱ ጋር እንሞት ዘንድ እኛ ደግሞ እንሂድ አለ። ");
INSERT INTO amh_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ኢየሱስም በመጣ ጊዜ በመቃብር እስከ አሁን አራት ቀን ሆኖት አገኘው። ");
INSERT INTO amh_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ቢታንያም አሥራ አምስት ምዕራፍ ያህል ለኢየሩሳሌም ቅርብ ነበረች። ");
INSERT INTO amh_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ከአይሁድም ብዙዎች ስለ ወንድማቸው ሊያጽናኑአቸው ወደ ማርታና ወደ ማርያም መጥተው ነበር። ");
INSERT INTO amh_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ማርታም ኢየሱስ እንደ መጣ በሰማች ጊዜ ልትቀበለው ወጣች፤ ማርያም ግን በቤት ተቀምጣ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ማርታም ኢየሱስን። ጌታ ሆይ፥ አንተ በዚህ ኖረህ ብትሆን ወንድሜ ባልሞተም ነበር፤ ");
INSERT INTO amh_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","አሁንም ከእግዚአብሔር የምትለምነውን ሁሉ እግዚአብሔር እንዲሰጥህ አውቃለሁ አለችው። ");
INSERT INTO amh_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ኢየሱስም። ወንድምሽ ይነሣል አላት። ");
INSERT INTO amh_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ማርታም። በመጨረሻው ቀን በትንሣኤ እንዲነሣ አውቃለሁ አለችው። ");
INSERT INTO amh_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ኢየሱስም። ትንሣኤና ሕይወት እኔ ነኝ፤ የሚያምንብኝ ቢሞት እንኳ ሕያው ይሆናል፤ ");
INSERT INTO amh_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ሕያው የሆነም የሚያምንብኝም ሁሉ ለዘላለም አይሞትም፤ ይህን ታምኚያለሽን? አላት። ");
INSERT INTO amh_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","እርስዋም። አዎን ጌታ ሆይ፤ አንተ ወደ ዓለም የሚመጣው ክርስቶስ የእግዚአብሔር ልጅ እንደ ሆንህ እኔ አምናለሁ አለችው። ");
INSERT INTO amh_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ይህንም ብላ ሄደች እኅትዋንም ማርያምን በስውር ጠርታ። መምህሩ መጥቶአል ይጠራሽማል አለቻት። ");
INSERT INTO amh_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","እርስዋም በሰማች ጊዜ ፈጥና ተነሣች ወደ እርሱም መጣች፤ ");
INSERT INTO amh_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ኢየሱስም ማርታ በተቀበለችበት ስፍራ ነበረ እንጂ ገና ወደ መንደሩ አልገባም ነበር። ");
INSERT INTO amh_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ሲያጽናኑአት ከእርስዋ ጋር በቤት የነበሩ አይሁድም ማርያም ፈጥና እንደ ተነሣችና እንደ ወጣች ባዩ ጊዜ፥ ወደ መቃብር ሄዳ በዚያ ልታለቅስ መስሎአቸው ተከተሉአት። ");
INSERT INTO amh_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ማርያምም ኢየሱስ ወዳለበት መጥታ ባየችው ጊዜ በእግሩ ላይ ወድቃ። ጌታ ሆይ፥ አንተ በዚህ ኖረህ ብትሆን ወንድሜ ባልሞተም ነበር አለችው። ");
INSERT INTO amh_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ኢየሱስም እርስዋ ስታለቅስ ከእርስዋም ጋር የመጡት አይሁድ ሲያለቅሱ አይቶ በመንፈሱ አዘነ በራሱም ታወከ፤ ");
INSERT INTO amh_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ወዴት አኖራችሁት? አለም። እነርሱም። ጌታ ሆይ፥ መጥተህ እይ አሉት። ");
INSERT INTO amh_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ኢየሱስም እንባውን አፈሰሰ። ");
INSERT INTO amh_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ስለዚህ አይሁድ። እንዴት ይወደው እንደ ነበረ እዩ አሉ። ");
INSERT INTO amh_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ከእነርሱ ግን አንዳንዶቹ። ይህ የዕውሩን ዓይኖች የከፈተ ይህን ደግሞ እንዳይሞት ያደርግ ዘንድ ባልቻለም ነበርን? አሉ። ");
INSERT INTO amh_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ኢየሱስም በራሱ አዝኖ ወደ መቃብሩ መጣ፤ እርሱም ዋሻ ነበረ፤ ድንጋይም ተገጥሞበት ነበር። ");
INSERT INTO amh_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ኢየሱስ። ድንጋዩን አንሡ አለ። የሞተውም እኅት ማርታ። ጌታ ሆይ፥ ከሞተ አራት ቀን ሆኖታልና አሁን ይሸታል አለችው። ");
INSERT INTO amh_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ኢየሱስ። ብታምኚስ የእግዚአብሔርን ክብር እንድታዪ አልነገርሁሽምን? አላት። ");
INSERT INTO amh_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ድንጋዩንም አነሡት። ኢየሱስም ዓይኖቹን ወደ ላይ አንሥቶ። አባት ሆይ፥ ስለ ሰማኸኝ አመሰግንሃለሁ። ");
INSERT INTO amh_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ሁልጊዜም እንድትሰማኝ አወቅሁ፤ ነገር ግን አንተ እንደ ላክኸኝ ያምኑ ዘንድ በዚህ ዙሪያ ስለ ቆሙት ሕዝብ ተናገርሁ አለ። ");
INSERT INTO amh_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ይህንም ብሎ በታላቅ ድምፅ። አልዓዛር ሆይ፥ ወደ ውጭ ና ብሎ ጮኸ። ");
INSERT INTO amh_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","የሞተውም እጆቹና እግሮቹ በመግነዝ እንደ ተገነዙ ወጣ፤ ፈቱም በጨርቅ እንደ ተጠመጠመ ነበር። ኢየሱስም። ፍቱትና ይሂድ ተዉት አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ስለዚህ ወደ ማርያም ከመጡት፥ ኢየሱስም ያደረገውን ካዩት ከአይሁድ ብዙዎች በእርሱ አመኑ፤ ");
INSERT INTO amh_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ከእነርሱ አንዳንዶቹ ግን ወደ ፈሪሳውያን ሄደው ኢየሱስ ያደረገውን ነገሩአቸው። ");
INSERT INTO amh_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","እንግዲህ የካህናት አለቆችና ፈሪሳውያን ሸንጎ ሰብስበው። ምን እናድርግ? ይህ ሰው ብዙ ምልክቶች ያደርጋልና። ");
INSERT INTO amh_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","እንዲሁ ብንተወው ሁሉ በእርሱ ያምናሉ፤ የሮሜም ሰዎች መጥተው አገራችንን ወገናችንንም ይወስዳሉ አሉ። ");
INSERT INTO amh_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","በዚያችም ዓመት ሊቀ ካህናት የነበረ ቀያፋ የሚሉት ከእነርሱ አንዱ። እናንተ ምንም አታውቁም፤ ");
INSERT INTO amh_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ሕዝቡም ሁሉ ከሚጠፋ አንድ ሰው ስለ ሕዝቡ ይሞት ዘንድ እንዲሻለን አታስቡም አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ይህንም የተናገረ ከራሱ አይደለም፥ ነገር ግን በዚያች ዓመት ሊቀ ካህናት ነበረና ኢየሱስ ስለ ሕዝቡ ሊሞት እንዳለው ትንቢት ተናገረ፤ ");
INSERT INTO amh_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ስለ ሕዝቡም ሁሉ አይደለም፥ ነገር ግን የተበተኑትን የእግዚአብሔርን ልጆች ደግሞ በአንድነት እንዲሰበስባቸው ነው እንጂ። ");
INSERT INTO amh_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","እንግዲህ ከዚያ ቀን ጀምረው ሊገድሉት ተማከሩ። ");
INSERT INTO amh_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ከዚያ ወዲያም ኢየሱስ በአይሁድ መካከል ተገልጦ አልተመላለሰም፤ ነገር ግን ከዚያ በምድረ በዳ አጠገብ ወዳለች ምድር፥ ኤፍሬም ወደምትባል ከተማ ሄደ፤ በዚያም ከደቀ መዛሙርቱ ጋር ተቀመጠ። ");
INSERT INTO amh_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","የአይሁድም ፋሲካ ቀርቦ ነበር። ብዙ ሰዎችም ራሳቸውን ያነጹ ዘንድ ከፋሲካ በፊት ከአገሩ ወደ ኢየሩሳሌም ወጡ። ");
INSERT INTO amh_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ኢየሱስንም ይፈልጉት ነበር፤ በመቅደስም ቆመው እርስ በርሳቸው። ምን ይመስላችኋል? ወደ በዓሉ አይመጣም ይሆንን? ተባባሉ። ");
INSERT INTO amh_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","የካህናት አለቆችም ፈሪሳውያንም ይይዙት ዘንድ እርሱ ያለበትን ስፍራ የሚያውቀው ሰው ቢኖር እንዲያመለክታቸው አዘው ነበር። ");
INSERT INTO amh_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ከፋሲካም በፊት በስድስተኛው ቀን ኢየሱስ ከሙታን ያስነሣው አልዓዛር ወደ ነበረበት ወደ ቢታንያ መጣ። ");
INSERT INTO amh_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","በዚያም እራት አደረጉለት፤ ማርታም ታገለግል ነበር፤ አልዓዛር ግን ከእርሱ ጋር ከተቀመጡት አንዱ ነበረ። ");
INSERT INTO amh_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ማርያምም ዋጋው እጅግ የከበረ የጥሩ ናርዶስ ሽቱ ንጥር ወስዳ የኢየሱስን እግር ቀባች፤ በጠጕርዋም እግሩን አበሰች፤ ቤቱም ከናርዶስ ሽቱ ሞላ። ");
INSERT INTO amh_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ነገር ግን ከደቀ መዛሙርቱ አንዱ አሳልፎ ሊሰጠው ያለው የስምዖን ልጅ የአስቆሮቱ ይሁዳ። ");
INSERT INTO amh_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ይህ ሽቱ ለሦስት መቶ ዲናር ተሽጦ ለድሆች ያልተሰጠ ስለ ምን ነው? አለ። ");
INSERT INTO amh_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ይህንም የተናገረ ሌባ ስለ ነበረ ነው እንጂ ለድሆች ተገድዶላቸው አይደለም፤ ከረጢትም ይዞ በውስጡ ከሚገባው ይወስድ ስለ ነበረ ነው። ");
INSERT INTO amh_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ኢየሱስም። ለምቀበርበት ቀን እንድትጠብቀው ተውአት፤ ");
INSERT INTO amh_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ድሆችስ ሁልጊዜ ከእናንተ ጋር ይኖራሉና፥ እኔ ግን ሁልጊዜ ከእናንተ ጋር አልኖርም አለ። ");
INSERT INTO amh_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ከአይሁድም ብዙ ሕዝብ በዚያ እንደ ነበረ አውቀው መጡ፥ ከሙታንም ያስነሣውን አልዓዛርን ደግሞ እንዲያዩ ነበረ እንጂ ስለ ኢየሱስ ብቻ አይደለም። ");
INSERT INTO amh_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","የካህናት አለቆችም አልዓዛርን ደግሞ ሊገድሉት ተማከሩ፥ ");
INSERT INTO amh_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ከአይሁድ ብዙዎች ከእርሱ የተነሣ ሄደው በኢየሱስ ያምኑ ነበርና። ");
INSERT INTO amh_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","በማግሥቱ ወደ በዓሉ መጥተው የነበሩ ብዙ ሕዝብ ኢየሱስ ወደ ኢየሩሳሌም እንዲመጣ በሰሙ ጊዜ፥ ");
INSERT INTO amh_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","የዘንባባ ዛፍ ዝንጣፊ ይዘው ሊቀበሉት ወጡና። ሆሣዕና፤ በጌታ ስም የሚመጣ የእስራኤል ንጉሥ የተባረከ ነው እያሉ ጮኹ። ");
INSERT INTO amh_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","16","ደቀ መዛሙርቱም ይህን ነገር በመጀመሪያ አላስተዋሉም፤ ነገር ግን ኢየሱስ ከከበረ በኋላ በዚያን ጊዜ ይህ ስለ እርሱ እንደ ተጻፈ ይህንም እንዳደረጉለት ትዝ አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","አልዓዛርንም ከመቃብር ጠርቶ ከሙታን ሲያስነሣው ከእርሱ ጋር የነበሩት ሕዝብ ይመሰክሩለት ነበር። ");
INSERT INTO amh_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ስለዚህ ደግሞ ሕዝቡ ይህን ምልክት እንዳደረገ ስለ ሰሙ ሊቀበሉት ወጡ። ");
INSERT INTO amh_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ሰለዚህ ፈሪሳውያን እርስ በርሳቸው። አንድ ስንኳ ልታደርጉ እንዳይቻላችሁ ታያላችሁን? እነሆ፥ ዓለሙ በኋላው ተከትሎት ሄዶአል ተባባሉ። ");
INSERT INTO amh_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","በበዓሉም ሊሰግዱ ከወጡት አንዳንዶቹ የግሪክ ሰዎች ነበሩ፤ ");
INSERT INTO amh_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","እነርሱም ከገሊላ ቤተ ሳይዳ ወደሚሆን ወደ ፊልጶስ መጥተው። ጌታ ሆይ፥ ኢየሱስን ልናይ እንወዳለን ብለው ለመኑት። ");
INSERT INTO amh_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ፊልጶስም መጥቶ ለእንድርያስ ነገረው፤ እንድርያስና ፊልጶስ መጥተው ለኢየሱስ ነገሩት። ");
INSERT INTO amh_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ኢየሱስም መለሰላቸው፥ እንዲህ ሲል። የሰው ልጅ ይከብር ዘንድ ሰዓቱ ደርሶአል። ");
INSERT INTO amh_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","እውነት እውነት እላችኋለሁ፥ የስንዴ ቅንጣት በምድር ወድቃ ካልሞተች ብቻዋን ትቀራለች፤ ብትሞት ግን ብዙ ፍሬ ታፈራለች። ");
INSERT INTO amh_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ነፍሱን የሚወድ ያጠፋታል፥ ነፍሱንም በዚህ ዓለም የሚጠላ ለዘላለም ሕይወት ይጠብቃታል። ");
INSERT INTO amh_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","የሚያገለግለኝ ቢኖር ይከተለኝ፥ እኔም ባለሁበት አገልጋዬ ደግሞ በዚያ ይሆናል፤ የሚያገለግለኝም ቢኖር አብ ያከብረዋል። ");
INSERT INTO amh_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","አሁን ነፍሴ ታውካለች ምንስ እላለሁ? አባት ሆይ፥ ከዚህ ሰዓት አድነኝ። ነገር ግን ስለዚህ ወደዚህ ሰዓት መጣሁ። ");
INSERT INTO amh_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","አባት ሆይ፥ ስምህን አክብረው። ስለዚህም። አከበርሁት ደግሞም አከብረዋለሁ የሚል ድምፅ ከሰማይ መጣ። ");
INSERT INTO amh_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","በዚያ ቆመው የነበሩትም ሕዝብ በሰሙ ጊዜ። ነጐድጓድ ነው አሉ፤ ሌሎች። መልአክ ተናገረው አሉ። ");
INSERT INTO amh_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ኢየሱስም መለሰ፥ እንዲህ ሲል። ይህ ድምፅ ስለ እናንተ መጥቶአል እጂ ስለ እኔ አይደለም። ");
INSERT INTO amh_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","አሁን የዚህ ዓለም ፍርድ ደርሶአል፤ አሁን የዚህ ዓለም ገዥ ወደ ውጭ ይጣላል፤ ");
INSERT INTO amh_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","እኔም ከምድር ከፍ ከፍ ያልሁ እንደ ሆነ ሁሉን ወደ እኔ እስባለሁ። ");
INSERT INTO amh_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","በምን ዓይነትም ሞት ይሞት ዘንድ እንዳለው ሲያመለክታቸው ይህን ተናገረ። ");
INSERT INTO amh_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","እንግዲህ ሕዝቡ። እኛስ ክርስቶስ ለዘላለም እንዲኖር ከሕጉ ሰምተናል፤ አንተስ የሰው ልጅ ከፍ ከፍ ይል ዘንድ እንዲያስፈልገው እንዴት ትላላህ? ይህ የሰው ልጅ ማን ነው? ብለው መለሱለት። ");
INSERT INTO amh_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ኢየሱስም። ገና ጥቂት ጊዜ ብርሃን ከእናንተ ጋር ነው። ጨለማ እንዳይደርስባችሁ ብርሃን ሳለላችሁ ተመላለሱ፤ በጨለማም የሚመላለስ ወዴት እንዲሄድ አያውቅም። ");
INSERT INTO amh_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","የብርሃን ልጆች እንድትሆኑ ብርሃን ሳለላችሁ በብርሃኑ እመኑ አላቸው። ኢየሱስም ይህን ተናግሮ ሄደና ተሰወረባቸው። ");
INSERT INTO amh_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","41","ክብሩን ስለ አየ ኢሳይያስ ይህን አለ፥ ስለ እርሱም ተናገረ። ");
INSERT INTO amh_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ከዚህም ጋር ከአለቆች ደግሞ ብዙዎች በእርሱ አመኑ፤ ነገር ግን ከምኵራብ እንዳያስወጡአቸው በፈሪሳውያን ምክንያት አልመሰከሩለትም፤ ");
INSERT INTO amh_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ከእግዚአብሔር ክብር ይልቅ የሰውን ክብር ወደዋልና። ");
INSERT INTO amh_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ኢየሱስም ጮኸ፥ እንዲህም አለ። በእኔ የሚያምን በላከኝ ማመኑ ነው እንጂ በእኔ አይደለም፤ ");
INSERT INTO amh_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","እኔንም የሚያይ የላከኝን ያያል። ");
INSERT INTO amh_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","በእኔ የሚያምን ሁሉ በጨለማ እንዳይኖር እኔ ብርሃን ሆኜ ወደ ዓለም መጥቻለሁ። ");
INSERT INTO amh_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ዓለምን ላድን እንጂ በዓለም ልፈርድ አልመጣሁምና ቃሌን ሰምቶ የማይጠብቀው ቢኖር የምፈርድበት እኔ አይደለሁም። ");
INSERT INTO amh_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","የሚጥለኝ ቃሌንም የማይቀበለው እርሱ የሚፈርድበት አለው፤ እኔ የተናገርሁት ቃል እርሱ በመጨረሻው ቀን ይፈርድበታል። ");
INSERT INTO amh_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","እኔ ከራሴ አልተናገርሁምና፤ ነገር ግን የላከኝ አብ እርሱ የምለውን የምናገረውንም ትእዛዝ ሰጠኝ። ");
INSERT INTO amh_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ትእዛዙም የዘላለም ሕይወት እንደ ሆነች አውቃለሁ። ስለዚህ እኔ የምናገረውን አብ እንደ ነገረኝ እንዲሁ እናገራለሁ። ");
INSERT INTO amh_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ኢየሱስም ከፋሲካ በዓል በፊት፥ ከዚህ ዓለም ወደ አብ የሚሄድበት ሰዓት እንደ ደረሰ አውቆ፥ በዚህ ዓለም ያሉትን ወገኖቹን የወደዳቸውን እስከ መጨረሻ ወደዳቸው። ");
INSERT INTO amh_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","እራትም ሲበሉ ዲያብሎስ በስምዖን ልጅ በአስቆሮቱ በይሁዳ ልብ አሳልፎ እንዲሰጠው አሳብ ካገባ በኋላ፥ ");
INSERT INTO amh_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ኢየሱስ አብ ሁሉን በልጁ እንደ ሰጠው ከእግዚአብሔርም እንደ ወጣ ወደ እግዚአብሔርም እንዲሄድ አውቆ፥ ");
INSERT INTO amh_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ከእራት ተነሣ ልብሱንም አኖረ፥ ማበሻም ጨርቅ ወስዶ ታጠቀ፤ ");
INSERT INTO amh_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","በኋላም በመታጠቢያው ውኃ ጨመረ፥ የደቀ መዛሙርቱንም እግር ሊያጥብና በታጠቀበትም ማበሻ ጨርቅ ሊያብስ ጀመረ። ");
INSERT INTO amh_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ወደ ስምዖን ጴጥሮስም መጣ፤ እርሱም። ጌታ ሆይ፥ አንተ የእኔን እግር ታጥባለህን? አለው። ");
INSERT INTO amh_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ኢየሱስም መልሶ። እኔ የማደርገውን አንተ አሁን አታውቅም፥ በኋላ ግን ታስተውለዋለህ አለው። ");
INSERT INTO amh_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ጴጥሮስም። የእኔን እግር ለዘላለም አታጥብም አለው። ኢየሱስም። ካላጠብሁህ፥ ከእኔ ጋር ዕድል የለህም ብሎ መለሰለት። ");
INSERT INTO amh_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ስምዖን ጴጥሮስም። ጌታ ሆይ፥ እጄንና ራሴን ደግሞ እንጂ እግሬን ብቻ አይደለም አለው። ");
INSERT INTO amh_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ኢየሱስም። የታጠበ እግሩን ከመታጠብ በቀር ሌላ አያስፈልገውም፥ ሁለንተናው ግን ንጹሕ ነው፤ እናንተም ንጹሐን ናችሁ፥ ነገር ግን ሁላችሁ አይደላችሁም አለው። ");
INSERT INTO amh_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","አሳልፎ የሚሰጠውን ያውቅ ነበርና፤ ስለዚህ። ሁላችሁ ንጹሐን አይደላችሁም አለው። ");
INSERT INTO amh_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","እግራቸውንም አጥቦ ልብሱንም አንሥቶ ዳግመኛ ተቀመጠ፥ እንዲህም አላቸው። ያደረግሁላችሁን ታስተውላላችሁን? ");
INSERT INTO amh_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","እናንተ መምህርና ጌታ ትሉኛላችሁ፤ እንዲሁ ነኝና መልካም ትላላችሁ። ");
INSERT INTO amh_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","እንግዲህ እኔ ጌታና መምህር ስሆን እግራችሁን ካጠብሁ፥ እናንተ ደግሞ እርስ በርሳችሁ እግራችሁን ትተጣጠቡ ዘንድ ይገባችኋል። ");
INSERT INTO amh_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","እኔ ለእናንተ እንዳደረግሁ እናንተ ደግሞ ታደርጉ ዘንድ ምሳሌ ሰጥቻችኋለሁና። ");
INSERT INTO amh_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","እውነት እውነት እላችኋለሁ፥ ባሪያ ከጌታው አይበልጥም። መልእክተኛም ከላከው አይበልጥም። ");
INSERT INTO amh_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ይህን ብታውቁ፥ ብታደርጉትም ብፁዓን ናችሁ። ");
INSERT INTO amh_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ስለ ሁላችሁ አልናገርም፤ እኔ የመረጥኋቸውን አውቃለሁ፤ ነገር ግን መጽሐፍ። እንጀራዬን የሚበላ በእኔ ላይ ተረከዙን አነሣብኝ ያለው ይፈጸም ዘንድ ነው። ");
INSERT INTO amh_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","በሆነ ጊዜ እኔ እንደ ሆንሁ ታምኑ ዘንድ፥ ከአሁን ጀምሬ አስቀድሞ ሳይሆን እነግራችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","እውነት እውነት እላችኋለሁ፥ ማናቸውን የምልከውን የሚቀበል እኔን ይቀበላል፥ እኔንም የሚቀበል የላከኝን ይቀበላል። ");
INSERT INTO amh_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ኢየሱስ ይህን ብሎ በመንፈሱ ታወከ መስክሮም። እውነት እውነት እላችኋለሁ፥ ከእናንተ አንዱ አሳልፎ ይሰጠኛል አለ። ");
INSERT INTO amh_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ደቀ መዛሙርቱ ስለ ማን እንደ ተናገረ አመንትተው እርስ በርሳቸው ተያዩ። ");
INSERT INTO amh_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ኢየሱስም ይወደው የነበረ ከደቀ መዛሙርቱ አንዱ በኢየሱስ ደረት ላይ ተጠጋ፤ ");
INSERT INTO amh_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ስለዚህ ስምዖን ጴጥሮስ እርሱን ጠቅሶ። ስለማን እንደ ተናገረ ንገረን አለው። ");
INSERT INTO amh_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","እርሱም በኢየሱስ ደረት እንዲህ ተጠግቶ። ጌታ ሆይ፥ ማን ነው? አለው። ");
INSERT INTO amh_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ኢየሱስም። እኔ ቍራሽ አጥቅሼ የምሰጠው እርሱ ነው ብሎ መለሰለት። ቍራሽም አጥቅሶ ለአስቆሮቱ ለስምዖን ልጅ ለይሁዳ ሰጠው። ");
INSERT INTO amh_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ቍራሽም ከተቀበለ በኋላ ያን ጊዜ ሰይጣን ገባበት። እንግዲህ ኢየሱስ። የምታደርገውን ቶሎ ብለህ አድርግ አለው። ");
INSERT INTO amh_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ነገር ግን ከተቀመጡት ስለ ምን ይህን እንዳለው ማንም አላወቀም፤ ");
INSERT INTO amh_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ይሁዳ ከረጢቱን የያዘ ስለ ሆነ፥ ኢየሱስ። ለበዓሉ የሚያስፈልገንን ግዛ፥ ወይም ለድሆች ምጽዋት እንዲሰጥ ያለው ለአንዳንዱ መስሎአቸው ነበርና። ");
INSERT INTO amh_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","እርሱም ቍራሹን ከተቀበለ በኋላ ወዲያው ወጣ፤ ሌሊትም ነበረ። ");
INSERT INTO amh_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ከወጣም በኋላ ኢየሱስ እንዲ አለ። አሁን የሰው ልጅ ከበረ እግዚአብሔርም ሰለ እርሱ ከበረ፤ ");
INSERT INTO amh_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","እግዚአብሔር ስለ እርሱ የከበረ ከሆነ፥ እግዚአብሔር ደግሞ እርሱን ራሱን ያከብረዋል ወዲያውም ያከብረዋል። ");
INSERT INTO amh_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ልጆች ሆይ፥ ገና ጥቂት ጊዜ ከእናንተ ጋር ነኝ፤ ትፈልጉኛላችሁ፤ ለአይሁድም። እኔ ወደምሄድበት እናንተ ልትመጡ አይቻላችሁም እንዳልኋቸው፥ አሁን ለእናንተ ደግሞ እላችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","እርስ በርሳችሁ ትዋደዱ ዘንድ፥ እንደ ወደድኋችሁ እናንተ ደግሞ እርስ በርሳችሁ ትዋደዱ ዘንድ አዲስ ትእዛዝ እሰጣችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","እርስ በርሳችሁ ፍቅር ቢኖራችሁ፥ ደቀ መዛሙርቴ እንደ ሆናችሁ ሰዎች ሁሉ በዚህ ያውቃሉ። ");
INSERT INTO amh_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ስምዖን ጴጥሮስም። ጌታ ሆይ፥ ወዴት ትሄዳለህ? አለው። ኢየሱስም። ወደምሄድበት አሁን ልትከተለኝ አትችልም፥ ነገር ግን በኋላ ትከተለኛለህ ብሎ መለሰለት። ");
INSERT INTO amh_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ጴጥሮስም። ጌታ ሆይ፥ አሁን ልከተልህ አለመቻሌ ስለ ምንድር ነው? ነፍሴን ስንኳ ስለ አንተ እሰጣለሁ አለው። ");
INSERT INTO amh_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ኢየሱስም እንዲህ ብሎ መለሰለት። ነፍስህን ስለ እኔ ትሰጣለህን? እውነት እውነት እልሃለሁ፥ ሦስት ጊዜ እስክትክደኝ ድረስ ዶሮ አይጮኽም። ");
INSERT INTO amh_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ልባችሁ አይታወክ፤ በእግዚአብሔር እመኑ፥ በእኔም ደግሞ እመኑ። ");
INSERT INTO amh_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","በአባቴ ቤት ብዙ መኖሪያ አለ፤ እንዲህስ ባይሆን ባልኋችሁ ነበር፤ ስፍራ አዘጋጅላችሁ ዘንድ እሄዳለሁና፤ ");
INSERT INTO amh_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ሄጄም ስፍራ ባዘጋጅላችሁ፥ እኔ ባለሁበት እናንተ ደግሞ እንድትሆኑ ሁለተኛ እመጣለሁ ወደ እኔም እወስዳችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ወደምሄድበትም ታውቃላችሁ፥ መንገዱንም ታውቃላችሁ። ");
INSERT INTO amh_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ቶማስም። ጌታ ሆይ፥ ወደምትሄድበት አናውቅም፤ እንዴትስ መንገዱን እናውቃለን? አለው። ");
INSERT INTO amh_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ኢየሱስም። እኔ መንገድና እውነት ሕይወትም ነኝ፤ በእኔ በቀር ወደ አብ የሚመጣ የለም። ");
INSERT INTO amh_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","እኔንስ ብታውቁኝ አባቴን ደግሞ ባወቃችሁ ነበር። ከአሁንም ጀምራችሁ ታውቁታላችሁ አይታችሁትማል አለው። ");
INSERT INTO amh_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ፊልጶስ። ጌታ ሆይ፥ አብን አሳየንና ይበቃናል አለው። ");
INSERT INTO amh_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ኢየሱስም አለው። አንተ ፊልጶስ፥ ይህን ያህል ዘመን ከእናንተ ጋር ስኖር አታውቀኝምን? እኔን ያየ አብን አይቶአል፤ እንዴትስ አንተ። አብን አሳየን ትላለህ? ");
INSERT INTO amh_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","እኔ በአብ እንዳለሁ አብም በእኔ እንዳለ አታምንምን? እኔ የምነግራችሁን ቃል ከራሴ አልናገረውም፤ ነገር ግን በእኔ የሚኖረው አብ እርሱ ሥራውን ይሠራል። ");
INSERT INTO amh_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","እኔ በአብ እንዳለሁ አብም በእኔ እንዳለ እመኑኝ፤ ባይሆንስ ስለ ራሱ ስለ ሥራው እመኑኝ። ");
INSERT INTO amh_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","እውነት እውነት እላችኋለሁ፥ በእኔ የሚያምን እኔ የማደርገውን ሥራ እርሱ ደግሞ ያደርጋል፤ ከዚህም የሚበልጥ ያደርጋል፥ ");
INSERT INTO amh_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","እኔ ወደ አብ እሄዳለሁና፤ አብም ስለ ወልድ እንዲከበር በስሜ የምትለምኑትን ሁሉ አደርገዋለሁ። ");
INSERT INTO amh_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ማናቸውንም ነገር በስሜ ብትለምኑ እኔ አደርገዋለሁ። ");
INSERT INTO amh_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","17","እርሱም ዓለም የማያየውና የማያውቀው ስለ ሆነ ሊቀበለው የማይቻለው የእውነት መንፈስ ነው፤ ነገር ግን ከእናንተ ዘንድ ስለሚኖር በውሥጣችሁም ስለሚሆን እናንተ ታውቃላችሁ። ");
INSERT INTO amh_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ወላጆች እንደ ሌላቸው ልጆች አልተዋችሁም፤ ወደ እናንተ እመጣለሁ። ");
INSERT INTO amh_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ገና ጥቂት ዘመን አለ ከዚህም በኋላ ዓለም አያየኝም፤ እናንተ ግን ታዩኛላችሁ፤ እኔ ሕያው ነኝና እናንተ ደግሞ ሕያዋን ትሆናላችሁ። ");
INSERT INTO amh_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","እኔ በአባቴ እንዳለሁ እናንተም በእኔ እንዳላችሁ እኔም በእናንተ እንዳለሁ በዚያን ቀን ታውቃላችሁ። ");
INSERT INTO amh_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ትእዛዜ በእርሱ ዘንድ ያለችው የሚጠብቃትም የሚወደኝ እርሱ ነው፤ የሚወደኝንም አባቴ ይወደዋል እኔም እወደዋለሁ ራሴንም እገልጥለታለሁ። ");
INSERT INTO amh_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","የአስቆሮቱ ያይደለ ይሁዳ። ጌታ ሆይ፥ ለዓለም ሳይሆን ራስህን ለእኛ ልትገልጥ ያለህ እንዴት ነው? አለው። ");
INSERT INTO amh_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ኢየሱስም መለሰ አለውም። የሚወደኝ ቢኖር ቃሌን ይጠብቃል፤ አባቴም ይወደዋል ወደ እርሱም እንመጣለን በእርሱም ዘንድ መኖሪያ እናደርጋለን። ");
INSERT INTO amh_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","የማይወደኝ ቃሌን አይጠብቅም፤ የምትሰሙትም ቃል የላከኝ የአብ ነው እንጂ የእኔ አይደለም። ");
INSERT INTO amh_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ከእናንተ ዘንድ ስኖር ይህን ነግሬአችኋለሁ፤ ");
INSERT INTO amh_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","አብ በስሜ የሚልከው ግን መንፈስ ቅዱስ የሆነው አጽናኝ እርሱ ሁሉን ያስተምራችኋል እኔም የነገርኋችሁን ሁሉ ያሳስባችኋል። ");
INSERT INTO amh_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ሰላምን እተውላችኋለሁ፥ ሰላሜን እሰጣችኋለሁ፤ እኔ የምሰጣችሁ ዓለም እንደሚሰጥ አይደለም። ልባችሁ አይታወክ አይፍራም። ");
INSERT INTO amh_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","እኔ እሄዳለሁ ወደ እናንተም እመጣለሁ እንዳልኋችሁ ሰማችሁ። የምትወዱኝስ ብትሆኑ ከእኔ አብ ይበልጣልና ወደ አብ በመሄዴ ደስ ባላችሁ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ከሆነም በኋላ ታምኑ ዘንድ አሁን አስቀድሞ ሳይሆን። ነግሬአችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ከእንግዲህ ወዲህ ከእናንተ ጋር ብዙ አልናገርም፥ የዚህ ዓለም ገዥ ይመጣልና፤ በእኔ ላይም አንዳች የለውም፤ ");
INSERT INTO amh_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ነገር ግን አብን እንድወድ ዓለም ሊያውቅ፥ አብም እንዳዘዘኝ፥ እንዲሁ አደርጋለሁ። ተነሡ፤ ከዚህ እንሂድ። ");
INSERT INTO amh_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","እውነተኛ የወይን ግንድ እኔ ነኝ፤ ገበሬውም አባቴ ነው። ");
INSERT INTO amh_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ፍሬ የማያፈራውን በእኔ ያለውን ቅርንጫፍ ሁሉ ያስወግደዋል፤ ፍሬ የሚያፈራውንም ሁሉ አብዝቶ እንዲያፈራ ያጠራዋል። ");
INSERT INTO amh_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","እናንተ ስለ ነገርኋችሁ ቃል አሁን ንጹሐን ናችሁ፤ ");
INSERT INTO amh_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","በእኔ ኑሩ እኔም በእናንተ። ቅርንጫፍ በወይኑ ግንድ ባይኖር ከራሱ ፍሬ ሊያፈራ እንዳይቻለው፥ እንዲሁ እናንተ ደግሞ በእኔ ባትኖሩ አትችሉም። ");
INSERT INTO amh_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","እኔ የወይን ግንድ ነኝ እናንተም ቅርንጫፎች ናችሁ። ያለ እኔ ምንም ልታደርጉ አትችሉምና በእኔ የሚኖር እኔም በእርሱ፥ እርሱ ብዙ ፍሬ ያፈራል። ");
INSERT INTO amh_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","በእኔ የማይኖር ቢሆን እንደ ቅርንጫፍ ወደ ውጭ ይጣላል ይደርቅማል፤ እነርሱንም ሰብስበው ወደ እሳት ይጥሉአቸዋል፥ ያቃጥሉአቸውማል። ");
INSERT INTO amh_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","በእኔ ብትኖሩ ቃሎቼም በእናንተ ቢኖሩ የምትወዱትን ሁሉ ለምኑ ይሆንላችሁማል። ");
INSERT INTO amh_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ብዙ ፍሬ ብታፈሩና ደቀ መዛሙርቴ ብትሆኑ በዚህ አባቴ ይከበራል። ");
INSERT INTO amh_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","አብ እንደ ወደደኝ እኔ ደግሞ ወደድኋችሁ፤ በፍቅሬ ኑሩ። ");
INSERT INTO amh_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","እኔ የአባቴን ትእዛዝ እንደ ጠበቅሁ በፍቅሩም እንደምኖር፥ ትእዛዜን ብትጠብቁ በፍቅሬ ትኖራላችሁ። ");
INSERT INTO amh_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ደስታዬም በእናንተ እንዲሆን ደስታችሁም እንዲፈጸም ይህን ነግሬአችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","እኔ እንደ ወደድኋችሁ እርስ በርሳችሁ ትዋደዱ ዘንድ ትእዛዜ ይህች ናት። ");
INSERT INTO amh_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ነፍሱን ስለ ወዳጆቹ ከመስጠት ይልቅ ከዚህ የሚበልጥ ፍቅር ለማንም የለውም። ");
INSERT INTO amh_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","እኔ ያዘዝኋችሁን ሁሉ ብታደርጉ እናንተ ወዳጆቼ ናችሁ። ");
INSERT INTO amh_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ከእንግዲህ ወዲህ ባሮች አልላችሁም፤ ባርያ ጌታው የሚያደርገውን አያውቅምና፤ ወዳጆች ግን ብያችኋለሁ፥ ከአባቴ የሰማሁትን ሁሉ ለእናንተ አስታውቄአችኋለሁና። ");
INSERT INTO amh_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","እኔ መረጥኋችሁ እንጂ እናንተ አልመረጣችሁኝም፤ አብም በስሜ የምትለምኑትን ሁሉ እንዲሰጣችሁ፥ ልትሄዱና ፍሬ ልታፈሩ ፍሬአችሁም ሊኖር ሾምኋችሁ። ");
INSERT INTO amh_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","እርስ በርሳችሁ እንድትዋደዱ ይህን አዛችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ዓለም ቢጠላችሁ ከእናንተ በፊት እኔን እንደ ጠላኝ እወቁ። ");
INSERT INTO amh_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ከዓለምስ ብትሆኑ ዓለም የራሱ የሆነውን ይወድ ነበር፤ ነገር ግን እኔ ከዓለም መረጥኋችሁ እንጂ ከዓለም ስለ አይደላችሁ ስለዚህ ዓለም ይጠላችኋል። ");
INSERT INTO amh_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ባርያ ከጌታው አይበልጥም ብዬ የነገርኋችሁን ቃል አስቡ። እኔን አሳደውኝ እንደ ሆኑ እናንተን ደግሞ ያሳድዱአችኋል፤ ቃሌን ጠብቀው እንደ ሆኑ ቃላችሁን ደግሞ ይጠብቃሉ። ");
INSERT INTO amh_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ዳሩ ግን የላከኝን አያውቁምና ይህን ሁሉ ሰለ ስሜ ያደርጉባችኋል። ");
INSERT INTO amh_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","እኔ መጥቼ ባልነገርኋቸውስ ኃጢአት ባልሆነባቸውም ነበር፤ አሁን ግን ለኃጢአታቸው ምክንያት የላቸውም። ");
INSERT INTO amh_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","እኔን የሚጠላ አባቴን ደግሞ ይጠላል። ");
INSERT INTO amh_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ሌላ ሰው ያላደረገውን ሥራ በመካከላቸው ባላደረግሁ፥ ኃጢአት ባልሆነባቸውም ነበር፤ አሁን ግን እኔንም አባቴንም አይተውማል ጠልተውማል። ");
INSERT INTO amh_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ነገር ግን በሕጋቸው። በከንቱ ጠሉኝ ተብሎ የተጻፈው ቃል ይፈጸም ዘንድ ነው። ");
INSERT INTO amh_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ዳሩ ግን እኔ ከአብ ዘንድ የምልክላችሁ አጽናኝ እርሱም ከአብ የሚወጣ የእውነት መንፈስ በመጣ ጊዜ፥ እርሱ ስለ እኔ ይመሰክራል፤ ");
INSERT INTO amh_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","እናንተም ደግሞ ከመጀመሪያ ከእኔ ጋር ኖራችኋልና ትመሰክራላችሁ። ");
INSERT INTO amh_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","እንዳትሰናከሉ ይህን ተናግሬአችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ከምኵራባቸው ያወጡአችኋል፤ ከዚህ በላይ ደግሞ የሚገድላችሁ ሁሉ እግዚአብሔርን እንደሚያገለግል የሚመስልበት ጊዜ ይመጣል። ");
INSERT INTO amh_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ይህንም የሚያደርጉባችሁ አብንና እኔን ስላላወቁ ነው። ");
INSERT INTO amh_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ነገር ግን ጊዜው ሲደርስ እኔ እንደ ነገርኋችሁ ታስቡ ዘንድ ይህን ተናግሬአችኋለሁ። ከእንናንተም ጋር ስለ ነበርሁ በመጀመሪያ ይህን አልነገርኋችሁም። ");
INSERT INTO amh_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","አሁን ግን ወደ ላከኝ እሄዳለሁ ከእናንተም። ወዴት ትሄዳለህ? ብሎ የሚጠይቀኝ የለም። ");
INSERT INTO amh_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ነገር ግን ይህን ስለ ተናገርኋችሁ ኀዘን በልባችሁ ሞልቶአል። ");
INSERT INTO amh_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","እኔ ግን እውነት እነግራችኋለሁ፤ እኔ እንድሄድ ይሻላችኋል። እኔ ባልሄድ አጽናኙ ወደ እናንተ አይመጣምና፤ እኔ ብሄድ ግን እርሱን እልክላችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","እርሱም መጥቶ ስለ ኃጢአት ስለ ጽድቅም ስለ ፍርድም ዓለምን ይወቅሳል፤ ");
INSERT INTO amh_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","11","ስለ ፍርድም፥ የዚህ ዓለም ገዥ ስለ ተፈረደበት ነው። ");
INSERT INTO amh_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","የምነግራችሁ ገና ብዙ አለኝ፥ ነገር ግን አሁን ልትሸከሙት አትችሉም። ");
INSERT INTO amh_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ግን እርሱ የእውነት መንፈስ በመጣ ጊዜ ወደ እውነት ሁሉ ይመራችኋል፤ የሚሰማውን ሁሉ ይናገራል እንጂ ከራሱ አይነግርምና፤ የሚመጣውንም ይነግራችኋል። ");
INSERT INTO amh_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","እርሱ ያከብረኛል፥ ለእኔ ካለኝ ወስዶ ይነግራችኋልና። ");
INSERT INTO amh_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ለአብ ያለው ሁሉ የእኔ ነው፤ ስለዚህ። ለእኔ ካለኝ ወስዶ ይነግራችኋል አልሁ። ");
INSERT INTO amh_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","ጥቂት ጊዜ አለ፥ አታዩኝምም፤ ደግሞም ጥቂት ጊዜ አለ፥ ታዩኛላችሁም፥ እኔ ወደ አብ እሄዳለሁና። ");
INSERT INTO amh_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ከደቀ መዛሙርቱም አንዳንዶቹ እርስ በርሳቸው። ጥቂት ጊዜ አለ፥ አታዩኝምም፤ ደግሞም ጥቂት ጊዜ አለ፥ ታዩኛላችሁም፤ ደግሞ። ወደ አብ እሄዳለሁና የሚለን ይህ ምንድር ነው? ተባባሉ። ");
INSERT INTO amh_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","እንግዲህ። ጥቂት የሚለው ይህ ምንድር ነው? የሚናገረውን አናውቅም አሉ። ");
INSERT INTO amh_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ኢየሱስም ሊጠይቁት እንደ ወደዱ አውቆ እንዲህ አላቸው። ጥቂት ጊዜ አለ፥ አታዩኝምም፤ ደግሞም ጥቂት ጊዜ አለ፥ ታዩኛላችሁ ስላልሁ፥ ስለዚህ እርስ በርሳችሁ ትመራመራላችሁን? ");
INSERT INTO amh_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","እውነት እውነት እላችኋለሁ፥ እናንተ ታለቅሳለችሁ ሙሾም ታወጣላችሁ፥ ዓለም ግን ደስ ይለዋል፤ እናንተም ታዝናላችሁ፥ ነገር ግን ኀዘናችሁ ወደ ደስታ ይለወጣል። ");
INSERT INTO amh_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ሴት በምትወልድበት ጊዜ ወራትዋ ስለ ደረሰ ታዝናለች፤ ነገር ግን ሕፃን ከወለደች በኋላ፥ ሰው በዓለም ተወልዶአልና ስለ ደስታዋ መከራዋን ኋላ አታስበውም። ");
INSERT INTO amh_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","እንግዲህ እናንተ ደግሞ አሁን ታዝናላችሁ፤ ነገር ግን እንደ ገና አያችኋለሁ ልባችሁም ደስ ይለዋል፥ ደስታችሁንም የሚወስድባችሁ የለም። ");
INSERT INTO amh_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","በዚያን ቀንም ከእኔ አንዳች አትለምኑም። እውነት እውነት እላችኋለሁ፥ አብ በስሜ የምትለምኑትን ሁሉ ይሰጣችኋል። ");
INSERT INTO amh_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","እስከ አሁን በስሜ ምንም አልለመናችሁም፤ ደስታችሁ ፍጹም እንዲሆን ለምኑ ትቀበሉማላችሁ። ");
INSERT INTO amh_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ይህን በምሳሌ ነግሬአችኋለሁ፤ ነገር ግን ስለ አብ ለእናንተ በግልጥ የምናገርበት እንጂ ከዚያ ወዲያ በምሳሌ የማልናገርበት ሰዓት ይመጣል። ");
INSERT INTO amh_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","በዚያን ቀን በስሜ ትለምናላችሁ፤ እኔም ስለ እናንተ አብን እንድለምን የምላችሁ አይደለሁም፤ ");
INSERT INTO amh_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","እናንተ ስለ ወደዳችሁኝ ከእግዚአብሔርም ዘንድ እኔ እንደ ወጣሁ ስላመናችሁ አብ እርሱ ራሱ ይወዳችኋልና። ");
INSERT INTO amh_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ከአብ ወጥቼ ወደ ዓለም መጥቻለሁ፤ ደግሞ ዓለምን እተወዋለሁ ወደ አብም እሄዳለሁ። ");
INSERT INTO amh_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ደቀ መዛሙርቱ። እነሆ፥ አሁን በግልጥ ትናገራለህ በምሳሌም ምንም አትነግርም። ");
INSERT INTO amh_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ሁሉን እንድታውቅ ማንምም ሊጠይቅህ እንዳትፈልግ አሁን እናውቃለን፤ ስለዚህ ከእግዚአብሔር እንደ ወጣህ እናምናለን አሉት። ");
INSERT INTO amh_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ኢየሱስም እንዲህ ብሎ መለሰላቸው። አሁን ታምናላችሁን? ");
INSERT INTO amh_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","እነሆ፥ እያንዳንዳችሁ ወደ ቤት የምትበታተኑበት እኔንም ለብቻዬ የምትተዉበት ሰዓት ይመጣል፥ አሁንም ደርሶአል፤ ነገር ግን አብ ከእኔ ጋር ስለ ሆነ ብቻዬን አይደለሁም። ");
INSERT INTO amh_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","በእኔ ሳላችሁ ሰላም እንዲሆንላችሁ ይህን ተናግሬአችኋለሁ። በዓለም ሳላችሁ መከራ አለባችሁ፤ ነገር ግን አይዞአችሁ፤ እኔ ዓለምን አሸንፌዋለሁ። ");
INSERT INTO amh_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","3","እውነተኛ አምላክ ብቻ የሆንህ አንተን የላክኸውንም ኢየሱስ ክርስቶስን ያውቁ ዘንድ ይህች የዘላለም ሕይወት ናት። ");
INSERT INTO amh_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","እኔ ላደርገው የሰጠኸኝን ሥራ ፈጽሜ በምድር አከበርሁህ፤ ");
INSERT INTO amh_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","አሁንም፥ አባት ሆይ፥ ዓለም ሳይፈጠር በአንተ ዘንድ በነበረኝ ክብር አንተ በራስህ ዘንድ አክብረኝ። ");
INSERT INTO amh_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ከዓለም ለሰጠኸኝ ሰዎች ስምህን ገለጥሁላቸው። የአንተ ነበሩ ለእኔም ሰጠሃቸው፤ ");
INSERT INTO amh_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ቃልህንም ጠብቀዋል። የሰጠኸኝ ሁሉ ከአንተ እንደ ሆነ አሁን ያውቃሉ፤ ");
INSERT INTO amh_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","የሰጠኸኝን ቃል ሰጥቻቸዋለሁና፤ እነርሱም ተቀበሉት፥ ከአንተም ዘንድ እንደ ወጣሁ በእውነት አወቁ፥ አንተም እንደ ላክኸኝ አመኑ። ");
INSERT INTO amh_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","እኔ ስለ እነዚህ እለምናለሁ፤ ስለ ዓለም አልለምንም ስለ ሰጠኸኝ እንጂ፤ የአንተ ናቸውና፤ ");
INSERT INTO amh_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","የእኔም የሆነ ሁሉ የአንተ ነው የአንተውም የእኔ ነው፤ እኔም ስለ እነርሱ ከብሬአለሁ። ");
INSERT INTO amh_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ከዚህም በኋላ በዓለም አይደለሁም፥ እነርሱም በዓለም ናቸው፥ እኔም ወደ አንተ እመጣለሁ። ቅዱስ አባት ሆይ፥ እነዚህን የሰጠኸኝን እንደ እኛ አንድ እንዲሆኑ በስምህ ጠብቃቸው። ");
INSERT INTO amh_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ከእነርሱ ጋር በዓለም ሳለሁ የሰጠኸኝን በስምህ እኔ እጠብቃቸው ነበር፤ ጠበቅኋቸውም መጽሐፉም እንዲፈጸም ከጥፋት ልጅ በቀር ከእነርሱ ማንም አልጠፋም። ");
INSERT INTO amh_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","አሁንም ወደ አንተ እመጣለሁ፤ በእነርሱም ዘንድ ደስታዬ የተፈጸመ እንዲሆንላቸው ይህን በዓለም እናገራለሁ። ");
INSERT INTO amh_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","እኔ ቃልህን ሰጥቻቸዋለሁ፤ እኔም ከዓለም እንዳይደለሁ ከዓለም አይደሉምና ዓለም ጠላቸው። ");
INSERT INTO amh_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ከክፉ እንድትጠብቃቸው እንጂ ከዓለም እንድታወጣቸው አልለምንም። ");
INSERT INTO amh_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","እኔ ከዓለም እንዳይደለሁ ከዓለም አይደሉም። ");
INSERT INTO amh_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","በእውነትህ ቀድሳቸው፤ ቃልህ እውነት ነው። ");
INSERT INTO amh_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ወደ ዓለም እንደ ላክኸኝ እንዲሁ እኔ ወደ ዓለም ላክኋቸው፤ ");
INSERT INTO amh_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","እነርሱም ደግሞ በእውነት የተቀደሱ እንዲሆኑ እኔ ራሴን ስለ እነርሱ እቀድሳለሁ። ");
INSERT INTO amh_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","24","አባት ሆይ፥ ዓለም ሳይፈጠር ስለ ወደድኸኝ የሰጠኸኝን ክብሬን እንዲያዩ እኔ ባለሁበት የሰጠኸኝ እነርሱ ደግሞ ከእኔ ጋር ይሆኑ ዘንድ እወዳለሁ። ");
INSERT INTO amh_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ጻድቅ አባት ሆይ፥ ዓለም አላወቀህም፥ እኔ ግን አወቅሁህ እነዚህም አንተ እንደ ላክኸኝ አወቁ፤ ");
INSERT INTO amh_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","እኔንም የወደድህባት ፍቅር በእነርሱ እንድትሆን እኔም በእነርሱ፥ ስምህን አስታወቅኋቸው አስታውቃቸውማለሁ። ");
INSERT INTO amh_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ኢየሱስም ይህን ብሎ አትክልት ወዳለበት ስፍራ ወደ ቄድሮን ወንዝ ማዶ ከደቀ መዛሙርቱ ጋር ወጣ፤ እርሱም ደቀ መዛሙርቱም በዚያ ገቡ። ");
INSERT INTO amh_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ኢየሱስም ደቀ መዛሙርቱም ብዙ ጊዜ ወደዚያ ስለ ተሰበሰቡ አሳልፎ የሰጠው ይሁዳ ደግሞ ስፍራውን ያውቅ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ስለዚህ ይሁዳ ጭፍሮችንና ከካህናት አለቆች ከፈሪሳውያንም ሎሌዎችን ተቀብሎ በችቦና በፋና በጋሻ ጦርም ወደዚያ መጣ። ");
INSERT INTO amh_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ኢየሱስም የሚመጣበትን ሁሉ አውቆ ወጣና። ማንን ትፈልጋላችሁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","የናዝሬቱን ኢየሱስን ብለው መለሱለት። ኢየሱስ። እኔ ነኝ አላቸው። አሳልፎ የሰጠውም ይሁዳ ደግሞ ከእነርሱ ጋር ቆሞ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","እንግዲህ። እኔ ነኝ ባላቸው ጊዜ ወደ ኋላ አፈግፍገው በምድር ወደቁ። ");
INSERT INTO amh_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ደግሞም። ማንን ትፈልጋላችሁ? ብሎ ጠየቃቸው። እነርሱም። የናዝሬቱን ኢየሱስን አሉት። ");
INSERT INTO amh_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ኢየሱስ መልሶ። እኔ ነኝ አልኋችሁ፤ እንግዲህ እኔን ትፈልጉ እንደ ሆናችሁ እነዚህ ይሂዱ ተዉአቸው አለ፤ ");
INSERT INTO amh_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ይህም። ከእነዚህ ከሰጠኸኝ አንዱን ስንኳ አላጠፋሁም ያለው ቃል ይፈጸም ዘንድ ነው። ");
INSERT INTO amh_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ስምዖን ጴጥሮስም ሰይፍ ስለ ነበረው መዘዘው፥ የሊቀ ካህናቱንም ባርያ መትቶ ቀኝ ጆሮውን ቈረጠ፤ የባርያውም ስም ማልኮስ ነበረ። ");
INSERT INTO amh_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ኢየሱስም ጴጥሮስን። ሰይፍህን ወደ ሰገባው ክተተው፤ አብ የሰጠኝን ጽዋ አልጠጣትምን? አለው። ");
INSERT INTO amh_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","እንግዲህ የሻለቃውና ጭፍሮቹ የአይሁድም ሎሌዎች ኢየሱስን ይዘው አሰሩት፥ ");
INSERT INTO amh_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","አስቀድመውም ወደ ሐና ወሰዱት፤ በዚያች ዓመት ሊቀ ካህናት ለነበረው ለቀያፋ አማቱ ነበርና። ");
INSERT INTO amh_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ቀያፋም። አንድ ሰው ስለ ሕዝብ ይሞት ዘንድ ይሻላል ብሎ ለአይሁድ የመከራቸው ነበረ። ");
INSERT INTO amh_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ስምዖን ጴጥሮስም ሌላውም ደቀ መዝሙር ኢየሱስን ተከተሉ። ያም ደቀ መዝሙር በሊቀ ካህናቱ ዘንድ የታወቀ ነበረ፥ ወደ ሊቀ ካህናቱም ግቢ ከኢየሱስ ጋር ገባ፤ ");
INSERT INTO amh_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ጴጥሮስ ግን በውጭ በበሩ ቆሞ ነበር። እንግዲህ በሊቀ ካህናቱ ዘንድ የታወቀው ሌላው ደቀ መዝሙር ወጣ ለበረኛይቱም ነግሮ ጴጥሮስን አስገባው። ");
INSERT INTO amh_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","በረኛ የነበረችይቱም ገረድ ጴጥሮስን። አንተ ደግሞ ከዚህ ሰው ደቀ መዛሙርት አንዱ አይደለህምን? አለችው። እርሱ። አይደለሁም አለ። ");
INSERT INTO amh_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ብርድ ነበረና ባሮችና ሎሌዎች የፍም እሳት አንድደው ቆሙ ይሞቁም ነበር፤ ጴጥሮስም ደግሞ ከእነርሱ ጋር ቆሞ ይሞቅ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ሊቀ ካህናቱም ኢየሱስን ስለ ደቀ መዛሙርቱና ስለ ትምህርቱ ጠየቀው። ");
INSERT INTO amh_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ኢየስስም መልሶ። እኔ በግልጥ ለዓለም ተናገርሁ፤ አይሁድ ሁሉ በሚሰበሰቡበት በምኵራብና በመቅደስ እኔ ሁልጊዜ አስተማርሁ፥ በስውርም ምንም አልተናገርሁም። ");
INSERT INTO amh_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ስለምን ትጠይቀኛለህ? ለእነርሱ የተናገርሁትን የሰሙትን ጠይቅ፤ እነሆ፥ እነዚህ እኔ የነገርሁትን ያውቃሉ አለው። ");
INSERT INTO amh_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ይህንም ሲል በዚያ ቆሞ የነበረው ከሎሌዎች አንዱ። ለሊቀ ካህናቱ እንዲህ ትመልሳለህን? ብሎ ኢየሱስን በጥፊ መታው። ");
INSERT INTO amh_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ኢየሱስም መልሶ። ክፉ ተናግሬ እንደ ሆንሁ ስለ ክፉ መስክር፤ መልካም ተናግሬ እንደ ሆንሁ ግን ሰለ ምን ትመታኛለህ? አለው። ");
INSERT INTO amh_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ስለዚህ ሐና እንደ ታሰረ ወደ ሊቀ ካህናቱ ወደ ቀያፋ ሰደደው። ");
INSERT INTO amh_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ስምዖን ጴጥሮስም ቆሞ እሳት ይሞቅ ነበር። እንግዲህ። አንተ ደግሞ ከደቀ መዛሙርቱ አይደለህምን? አሉት። እርሱም። አይደለሁም ብሎ ካደ። ");
INSERT INTO amh_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ጴጥሮስ ጆሮውን የቈረጠው ዘመድ የሆነ ከሊቀ ካህናቱ ባሮች አንዱ። በአትክልቱ ከእርሱ ጋር እኔ አይቼህ አልነበረምን? አለው። ");
INSERT INTO amh_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ጴጥሮስም እንደ ገና ካደ፥ ወዲያውም ዶሮ ጮኸ። ");
INSERT INTO amh_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ኢየሱስንም ከቀያፋ ወደ ገዡ ግቢ ወሰዱት፤ ማለዳም ነበረ፤ እነርሱም የፋሲካ በግ ይበሉ ዘንድ እንጂ እንዳይረክሱ ወደ ገዡ ግቢ አልገቡም። ");
INSERT INTO amh_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ስለዚህ ጲላጦስ ወደ ውጭ ወደ እነርሱ ወጥቶ። ይህን ሰው ስለ ምን ትከሱታላችሁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","እነርሱም መልሰው። ይህስ ክፉ አድራጊ ባይሆን ወደ አንተ አሳልፈን ባልሰጠነውም ነበር አሉት። ");
INSERT INTO amh_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ጲላጦስም። እናንተ ወስዳችሁ እንደ ሕጋችሁ ፍረዱበት አላቸው። አይሁድም። ለእኛስ ማንንም ልንገድል አልተፈቀደልንም አሉት፤ ");
INSERT INTO amh_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ኢየሱስ በምን ዓይነት ሞት ሊሞት እንዳለው ሲያመለክት የተናገረው ቃል ይፈጸም ዘንድ ነው። ");
INSERT INTO amh_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ጲላጦስም እንደ ገና ወደ ገዡ ግቢ ገባና ኢየሱስን ጠርቶ። የአይሁድ ንጉሥ አንተ ነህን? አለው። ");
INSERT INTO amh_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ኢየሱስም መልሶ። አንተ ይህን የምትለው ከራስህ ነውን ወይስ ሌሎች ስለ እኔ ነገሩህን? አለው። ");
INSERT INTO amh_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ጲላጦስ መልሶ። እኔ አይሁዳዊ ነኝን? ወገኖችህና የካህናት አለቆች ለእኔ አሳልፈው ሰጡህ፤ ምን አድርገሃል? አለው። ");
INSERT INTO amh_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ኢየሱስም መልሶ። መንግሥቴ ከዚህ ዓለም አይደለችም፤ መንግሥቴስ ከዚህ ዓለም ብትሆን፥ ወደ አይሁድ እንዳልሰጥ ሎሌዎቼ ይዋጉልኝ ነበር፤ አሁን ግን መንግሥቴ ከዚህ አይደለችም አለው። ");
INSERT INTO amh_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ጲላጦስም። እንግዲያ ንጉሥ ነህን? አለው። ኢየሱስም መልሶ። እኔ ንጉሥ እንደ ሆንሁ አንተ ትላለህ። እኔ ለእውነት ልመሰክር ስለዚህ ተወልጃለሁ ስለዚህም ወደ ዓለም መጥቻለሁ፤ ከእውነት የሆነ ሁሉ ድምፄን ይሰማል አለው። ");
INSERT INTO amh_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ጲላጦስ። እውነት ምንድር ነው? አለው። ይህንም ብሎ ዳግመኛ ወደ አይሁድ ወጥቶ። እኔስ አንዲት በደል ስንኳ አላገኘሁበትም። ");
INSERT INTO amh_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ነገር ግን በፋሲካ አንድ ልፈታላችሁ ልማድ አላችሁ፤ እንግዲህ የአይሁድን ንጉሥ ልፈታላችሁ ትወዳላችሁን? አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ሁሉም ደግመው። በርባንን እንጂ ይህን አይደለም እያሉ ጮኹ። በርባን ግን ወንበዴ ነበረ። ");
INSERT INTO amh_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","በዚያን ጊዜም ጲላጦስ ኢየሱስን ይዞ ገረፈው። ");
INSERT INTO amh_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ወታደሮችም ከእሾህ አክሊል ጐንጕነው በራሱ ላይ አኖሩ ቀይ ልብስም አለበሱት፤ ");
INSERT INTO amh_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","እየቀረቡም። የአይሁድ ንጉሥ ሆይ፥ ሰላም ለአንተ ይሁን ይሉት ነበር፤ ");
INSERT INTO amh_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","በጥፊም ይመቱት ነበር። ጲላጦስም ደግሞ ወደ ውጭ ወጥቶ። እነሆ፥ አንዲት በደል ስንኳ እንዳላገኘሁበት ታውቁ ዘንድ እርሱን ወደ ውጭ አወጣላችኋለሁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ኢየሱስም የእሾህ አክሊል ደፍቶ ቀይ ልብስም ለብሶ ወደ ውጭ ወጣ። ");
INSERT INTO amh_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ጲላጦስም። እነሆ ሰውዬው አላቸው። የካህናት አለቆችና ሎሌዎች ባዩትም ጊዜ። ስቀለው ስቀለው እያሉ ጮኹ። ጲላጦስም። እኔስ አንዲት በደል ስንኳ አላገኘሁበትምና እናንተ ወስዳችሁ ስቀሉት አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","አይሁድም መልሰው። እኛ ሕግ አለን፥ እንደ ሕጋችንም ሊሞት ይገባዋል፥ ራሱን የእግዚአብሔር ልጅ አድርጎአልና አሉት። ");
INSERT INTO amh_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ስለዚህ ጲላጦስ ይህን ነገር በሰማ ጊዜ እግጅ ፈራ፤ ");
INSERT INTO amh_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ተመልሶም ወደ ገዡ ግቢ ገባና ኢየሱስን። አንተ ከወዴት ነህ? አለው። ኢየሱስ ግን አንድ እንኳ አልመለሰለትም። ");
INSERT INTO amh_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ስለዚህ ጲላጦስ። አትነግረኝምን? ልሰቅልህ ሥልጣን እንዳለኝ ወይም ልፈታህ ሥልጣን እንዳለኝ አታውቅምን? አለው። ");
INSERT INTO amh_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ኢየሱስም መልሶ። ከላይ ካልተሰጠህ በቀር በእኔ ላይ ምንም ሥልጣን ባልነበረህም፤ ስለዚህ ለአንተ አሳልፎ የሰጠኝ ኃጢአቱ የባሰ ነው አለው። ");
INSERT INTO amh_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ከዚህ በኋላ ጲላጦስ ሊፈታው ፈለገ፤ ነገር ግን አይሁድ። ይህንስ ብትፈታው የቄሣር ወዳጅ አይደለህም፤ ራሱን ንጉሥ የሚያደርግ ሁሉ የቄሣር ተቃዋሚ ነው እያሉ ጮኹ። ");
INSERT INTO amh_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ጲላጦስም ይህን ነገር ሰምቶ ኢየሱስን ወደ ውጭ አወጣው፥ በዕብራይስጥም ገበታ በተባለው ጸፍጸፍ በሚሉት ስፍራ በፍርድ ወንበር ተቀመጠ። ");
INSERT INTO amh_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ለፋሲካም የማዘጋጀት ቀን ነበረ፤ ስድስት ሰዓትም የሚያህል ነበረ፤ አይሁድንም። እነሆ ንጉሣችሁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","እነርሱ ግን። አስወግደው፥ አስወግደው፥ ስቀለው እያሉ ጮኹ። ጲላጦስም። ንጉሣችሁን ልስቀለውን? አላቸው። የካህናት አለቆችም። ከቄሣር በቀር ሌላ ንጉሥ የለንም ብለው መለሱለት። ");
INSERT INTO amh_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ስለዚህ በዚያን ጊዜ እንዲሰቀል አሳልፎ ሰጣቸው። ");
INSERT INTO amh_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ኢየሱስንም ይዘው ወሰዱት፤ መስቀሉንም ተሸክሞ በዕብራይስጥ ጎልጎታ ወደ ተባለው የራስ ቅል ስፍራ ወደሚሉት ወጣ። ");
INSERT INTO amh_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","በዚያም ሰቀሉት፥ ከእርሱም ጋር ሌሎች ሁለት፥ አንዱን በዚህ አንዱን በዚያ ኢየሱስንም በመካከላቸው ሰቀሉ። ");
INSERT INTO amh_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ጲላጦስም ደግሞ ጽሕፈት ጽፎ በመስቀሉ ላይ አኖረው፤ ጽሕፈቱም። የአይሁድ ንጉሥ የናዝሬቱ ኢየሱስ የሚል ነበረ። ");
INSERT INTO amh_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ኢየሱስም የተሰቀለበት ስፍራ ለከተማ ቅርብ ነበረና ከአይሁድ ብዙዎች ይህን ጽሕፈት አነበቡት፤ በዕብራይስጥና በሮማይስጥ በግሪክም ተጽፎ ነበር። ");
INSERT INTO amh_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ስለዚህ የአይሁድ ካህናት አለቆች ጲላጦስን። እርሱ። የአይሁድ ንጉስ ነኝ እንዳለ እንጂ የአይሁድ ንጉሥ ብለህ አትጻፍ አሉት። ");
INSERT INTO amh_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ጲላጦስም። የጻፍሁትን ጽፌአለሁ ብሎ መለሰ። ");
INSERT INTO amh_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ጭፍሮችም ኢየሱስን በሰቀሉት ጊዜ ልብሶቹን ወስደው ለእያንዳንዱ ጭፍራ አንድ ክፍል ሆኖ በአራት ከፋፈሉት፤ እጀጠባቡን ደግሞ ወሰዱ። እጀ ጠባቡም ከላይ ጀምሮ ወጥ ሆኖ የተሠራ ነበረ እንጂ የተሰፋ አልነበረም። ");
INSERT INTO amh_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ስለዚህ እርስ በርሳቸው። ለማን እንዲሆን በእርሱ ዕጣ እንጣጣልበት እንጂ አንቅደደው ተባባሉ። ይህም። ልብሴን እርስ በርሳቸው ተከፋፈሉ በእጀ ጠባቤም ዕጣ ተጣጣሉበት የሚለው የመጽሐፍ ቃል ይፈጸም ዘንድ ነው። ");
INSERT INTO amh_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ጭፍሮችም እንዲህ አደረጉ። ነገር ግን በኢየሱስ መስቀል አጠገብ እናቱ፥ የእናቱም እኅት፥ የቀለዮጳም ሚስት ማርያም፥ መግደላዊትም ማርያም ቆመው ነበር። ");
INSERT INTO amh_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ኢየሱስም እናቱን ይወደው የነበረውንም ደቀ መዝሙር በአጠገቡ ቆሞ ባየ ጊዜ እናቱን። አንቺ ሴት፥ እነሆ ልጅሽ አላት። ");
INSERT INTO amh_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ከዚህ በኋላ ደቀ መዝሙሩን። እናትህ እነኋት አለው። ከዚህም ሰዓት ጀምሮ ደቀ መዝሙሩ ወደ ቤቱ ወሰዳት። ");
INSERT INTO amh_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ከዚህ በኋላ ኢየሱስ አሁን ሁሉ እንደተፈጸመ አውቆ የመጽሐፉ ቃል ይፈጸም ዘንድ። ተጠማሁ አለ። ");
INSERT INTO amh_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","በዚያም ሆምጣጤ የሞላበት ዕቃ ተቀምጦ ነበር፤ እነርሱም ሆምጣጤውን በሰፍነግ ሞልተው በሁሶፕም አድርገው ወደ አፉ አቀረቡለት። ");
INSERT INTO amh_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ኢየሱስም ሆምጣጤውን ከተቀበለ በኋላ። ተፈጸመ አለ፥ ራሱንም አዘንብሎ ነፍሱን አሳልፎ ሰጠ። ");
INSERT INTO amh_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","አይሁድም የማዘጋጀት ቀን ስለ ሆነ ያ ሰንበት ትልቅ ነበረና ሥጋቸው በሰንበት በመስቀል ላይ እንዳይኖር፥ ጭናቸውን ሰብረው እንዲያወርዱአቸው ጲላጦስን ለመኑት። ");
INSERT INTO amh_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ጭፍሮችም መጥተው የፊተኛውን ጭን ከእርሱም ጋር የተሰቀለውን የሌላውን ጭን ሰበሩ፤ ");
INSERT INTO amh_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ወደ ኢየሱስ በመጡ ጊዜ ግን እርሱ ፈጽሞ እንደ ሞተ አይተው ጭኑን አልሰበሩም፤ ");
INSERT INTO amh_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ነገር ግን ከጭፍሮች አንዱ ጎኑን በጦር ወጋው፤ ወዲያውም ደምና ውኃ ወጣ። ");
INSERT INTO amh_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ያየውም መስክሮአል፤ ምስክሩም እውነት ነው፤ እናንተም ደግሞ ታምኑ ዘንድ እርሱ እውነት እንዲናገር ያውቃል። ");
INSERT INTO amh_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ይህ የሆነ። ከእርሱ አጥንት አይሰበርም የሚል የመጽሐፉ ቃል እንዲፈጸም ነው። ");
INSERT INTO amh_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ደግሞም ሌላው መጽሐፍ። የወጉትን ያዩታል ይላል። ");
INSERT INTO amh_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ከዚህም በኋላ አይሁድን ስለ ፈራ በስውር የኢየሱስ ደቀ መዝሙር የነበረ የአርማትያስ ዮሴፍ የኢየሱስን ሥጋ ሊወስድ ጲላጦስን ለመነ፤ ጲላጦስም ፈቀደለት። ስለዚህም መጥቶ የኢየሱስን ሥጋ ወሰደ። ");
INSERT INTO amh_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ደግሞም አስቀድሞ በሌሊት ወደ ኢየሱስ መጥቶ የነበረ ኒቆዲሞስ መቶ ንጥር የሚያህል የከርቤና የእሬት ቅልቅል ይዞ መጣ። ");
INSERT INTO amh_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","የኢየሱስንም ሥጋ ወስደው እንደ አይሁድ አገናነዝ ልማድ ከሽቱ ጋር በተልባ እግር ልብስ ከፈኑት። ");
INSERT INTO amh_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","በተሰቀለበትም ስፍራ አትክልት ነበረ፥ በአትክልቱም ማንም ገና ያልተቀበረበት አዲስ መቃብር ነበረ። ");
INSERT INTO amh_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ስለዚህ መቃብሩ ቅርብ ነበረና ስለ አይሁድ ማዘጋጀት ቀን ኢየሱስን በዚያ አኖሩት። ");
INSERT INTO amh_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ከሳምንቱም በፊተኛው ቀን መግደላዊት ማርያም ገና ጨለማ ሳለ ማለዳ ወደ መቃብር መጣች ድንጋዩም ከመቃብሩ ተፈንቅሎ አየች። ");
INSERT INTO amh_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","እየሮጠችም ወደ ስምዖን ጴጥሮስና ኢየሱስ ይወደው ወደ ነበረው ወደ ሌላው ደቀ መዝሙር መጥታ። ጌታን ከመቃብር ወስደውታል ወዴትም እንዳኖሩት አናውቅም አለቻቸው። ");
INSERT INTO amh_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ስለዚህ ጴጥሮስና ሌላው ደቀ መዝሙር ወጥተው ወደ መቃብሩ ሄዱ። ");
INSERT INTO amh_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ሁለቱም አብረው ሮጡ፤ ሌላው ደቀ መዝሙርም ከጴጥሮስ ይልቅ ፈጥኖ ወደ ፊት ሮጠና አስቀድሞ ከመቃብሩ ደረሰ፤ ");
INSERT INTO amh_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ዝቅም ብሎ ቢመለከት የተልባ እግሩን ልብስ ተቀምጦ አየ፥ ነገር ግን አልገባም። ");
INSERT INTO amh_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ስምዖን ጴጥሮስም ተከትሎት መጣ ወደ መቃብሩም ገባ፤ የተልባ እግሩን ልብስ ተቀምጦ አየ፥ ");
INSERT INTO amh_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ደግሞም በራሱ የነበረውን ጨርቅ ለብቻው በአንድ ስፍራ ተጠምጥሞ እንደ ነበረ እንጂ ከተልባ እግሩ ልብስ ጋር ተቀምጦ እንዳልነበረ አየ። ");
INSERT INTO amh_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","በዚያን ጊዜ አስቀድሞ ወደ መቃብር የመጣውም ሌላው ደቀ መዝሙር ደግሞ ገባ፥ አየም፥ አመነም፤ ");
INSERT INTO amh_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ከሙታን ይነሣ ዘንድ እንዲገባው የሚለውን የመጽሐፉን ቃል ገና አላወቁም ነበርና። ");
INSERT INTO amh_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ደቀ መዛሙርቱም ወደ ቤታቸው ደግሞ ሄዱ። ");
INSERT INTO amh_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ማርያም ግን እያለቀሰች ከመቃብሩ በስተ ውጭ ቆማ ነበር። ስታለቅስም ወደ መቃብር ዝቅ ብላ ተመለከተች፤ ");
INSERT INTO amh_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ሁለት መላእክትም ነጭ ልብስ ለብሰው የኢየሱስ ሥጋ ተኝቶበት በነበረው አንዱ በራስጌ ሌላውም በእግርጌ ተቀምጠው አየች። ");
INSERT INTO amh_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","እነርሱም። አንቺ ሴት፥ ስለ ምን ታለቅሻለሽ? አሉአት። እርስዋም። ጌታዬን ወስደውታል ወዴትም እንዳኖሩት አላውቅም አለቻቸው። ");
INSERT INTO amh_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ይህንም ብላ ወደ ኋላ ዘወር ስትል ኢየሱስን ቆሞ አየችው፤ ኢየሱስም እንደ ሆነ አላወቀችም። ");
INSERT INTO amh_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ኢየሱስም። አንቺ ሴት፥ ስለ ምን ታለቅሻለሽ? ማንንስ ትፈልጊያለሽ? አላት። እርስዋም የአትክልት ጠባቂ መስሎአት። ጌታ ሆይ፥ አንተ ወስደኸው እንደ ሆንህ ወዴት እንዳኖርኸው ንገረኝ እኔም እወስደዋለሁ አለችው። ");
INSERT INTO amh_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ኢየሱስም። ማርያም አላት። እርስዋ ዘወር ብላ በዕብራይስጥ። ረቡኒ አለችው፤ ትርጓሜውም። መምህር ሆይ ማለት ነው። ");
INSERT INTO amh_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ኢየሱስም። ገና ወደ አባቴ አላረግሁምና አትንኪኝ፤ ነገር ግን ወደ ወንድሞቼ ሄደሽ። እኔ ወደ አባቴና ወደ አባታችሁ ወደ አምላኬና ወደ አምላካችሁ ዓርጋለሁ ብለሽ ንገሪአቸው አላት። ");
INSERT INTO amh_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","መግደላዊት ማርያም መጥታ ጌታን እንዳየች ይህንም እንዳላት ለደቀ መዛሙርቱ ነገረች። ");
INSERT INTO amh_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ያም ቀን እርሱም ከሳምንቱ ፊተኛው በመሸ ጊዜ፥ ደቀ መዛሙርቱ ተሰብስበው በነበሩበት፥ አይሁድን ስለ ፈሩ ደጆቹ ተዘግተው ሳሉ፥ ኢየሱስ መጣ፤ በመካከላቸውም ቆሞ። ሰላም ለእናንተ ይሁን አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ይህንም ብሎ እጆቹንም ጎኑንም አሳያቸው። ደቀ መዛሙርቱም ጌታን ባዩ ጊዜ ደስ አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ኢየሱስም ዳግመኛ። ሰላም ለእናንተ ይሁን፤ አብ እንደ ላከኝ እኔ ደግሞ እልካችኋለሁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ይህንም ብሎ እፍ አለባቸውና። መንፈስ ቅዱስን ተቀበሉ። ");
INSERT INTO amh_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ኃጢአታቸውን ይቅር ያላችኋቸው ሁሉ ይቀርላቸዋል፤ የያዛችሁባቸው ተይዞባቸዋል አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ነገር ግን ከአሥራ ሁለቱ አንዱ ዲዲሞስ የሚሉት ቶማስ ኢየሱስ በመጣ ጊዜ ከእነርሱ ጋር አልነበረም። ");
INSERT INTO amh_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ሌሎቹም ደቀ መዛሙርቱ። ጌታን አይተነዋል አሉት። እርሱ ግን። የችንካሩን ምልክት በእጆቹ ካላየሁ ጣቴንም በችንካሩ ምልክት ካላገባሁ እጄንም በጎኑ ካላገባሁ አላምንም አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ከስምንት ቀን በኋላም ደቀ መዛሙርቱ ደግመው በውስጥ ነበሩ፥ ቶማስም ከእነርሱ ጋር ነበረ። ደጆች ተዘግተው ሳሉ ኢየሱስ መጣ፤ በመካከላቸውም ቆሞ። ሰላም ለእናንተ ይሁን አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ከዚያም በኋላ ቶማስን። ጣትህን ወደዚህ አምጣና እጆቼን እይ፤ እጅህንም አምጣና በጎኔ አግባው፤ ያመንህ እንጂ ያላመንህ አትሁን አለው። ");
INSERT INTO amh_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ቶማስም። ጌታዬ አምላኬም ብሎ መለሰለት። ");
INSERT INTO amh_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ኢየሱስም። ስለ አየኸኝ አምነሃል፤ ሳያዩ የሚያምኑ ብፁዓን ናቸው አለው። ");
INSERT INTO amh_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ኢየሱስም በዚህ መጽሐፍ ያልተጻፈ ሌላ ብዙ ምልክት በደቀ መዛሙርቱ ፊት አደረገ፤ ");
INSERT INTO amh_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ነገር ግን ኢየሱስ እርሱ ክርስቶስ የእግዚአብሔር ልጅ እንደ ሆነ ታምኑ ዘንድ፥ አምናችሁም በስሙ ሕይወት ይሆንላችሁ ዘንድ ይህ ተጽፎአል። ");
INSERT INTO amh_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ከዚህ በኋላ ኢየሱስ በጥብርያዶስ ባሕር አጠገብ ለደቀ መዛሙርቱ እንደ ገና ተገለጠላቸው፤ ");
INSERT INTO amh_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","እንዲህም ተገለጠ። ስምዖን ጴጥሮስና ዲዲሞስ የሚባለው ቶማስ ከገሊላ ቃና የሆነ ናትናኤልም የዘብዴዎስም ልጆች ከደቀ መዛሙርቱም ሌሎች ሁለት በአንድነት ነበሩ። ");
INSERT INTO amh_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ስምዖን ጴጥሮስ። ዓሣ ላጠምድ እሄዳለሁ አላቸው። እነርሱም። እኛም ከአንተ ጋር እንመጣለን አሉት። ወጥተውም ወደ ታንኳይቱ ገቡ በዚያችም ሌሊት ምንም እላጠመዱም። ");
INSERT INTO amh_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","በነጋም ጊዜ ኢየሱስ በባሕር ዳር ቆመ፤ ደቀ መዛሙርቱ ግን ኢየሱስ መሆኑን አላወቁም። ");
INSERT INTO amh_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ኢየሱስም። ልጆች ሆይ፥ አንዳች የሚበላ አላችሁን? አላቸው። የለንም ብለው መለሱለት። ");
INSERT INTO amh_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","እርሱም። መረቡን በታንኳይቱ በስተ ቀኝ ጣሉት ታገኙማላችሁ አላቸው። ስለዚህ ጣሉት፤ በዚህም ጊዜ ከዓሣው ብዛት የተነሣ ሊጐትቱት አቃታቸው። ");
INSERT INTO amh_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ኢየሱስ ይወደው የነበረውም ደቀ መዝሙር ጴጥሮስን። ጌታ እኮ ነው አለው። ስለዚህ ስምዖን ጴጥሮስ ጌታ መሆኑን በሰማ ጊዜ ዕራቁቱን ነበረና ልብሱን ታጥቆ ወደ ባሕር ራሱን ጣለ። ");
INSERT INTO amh_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ሌሎቹ ደቀ መዛሙርት ግን ከምድር ሁለት መቶ ክንድ ያህል እንጂ እጅግ አልራቁም ነበርና ዓሣ የሞላውን መረብ እየሳቡ በጀልባ መጡ። ");
INSERT INTO amh_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ወደ ምድርም በወጡ ጊዜ ፍምና ዓሣ በላዩ ተቀምጦ እንጀራም አዩ። ");
INSERT INTO amh_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ኢየሱስም። አሁን ካጠመዳችሁት ዓሣ አምጡ አላቸው። ");
INSERT INTO amh_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ስምዖን ጴጥሮስም ወደ ጀልባይቱ ገብቶ መቶ አምሳ ሦስት ታላላቅ ዓሦች ሞልቶ የነበረውን መረብ ወደ ምድር ጐተተ፤ ይህንም ያህል ብዙ ሲሆን መረቡ አልተቀደደም። ");
INSERT INTO amh_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ኢየሱስም። ኑ፥ ምሳ ብሉ አላቸው። ከደቀ መዛሙርቱ አንድ ስንኳ። አንተ ማን ነህ? ብሎ ሊመረምረው የደፈረ አልነበረም፤ ጌታ መሆኑን አውቀው ነበርና። ");
INSERT INTO amh_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ኢየሱስም መጣና እንጀራ አንሥቶ ሰጣቸው፥ እንዲሁም ዓሣውን። ");
INSERT INTO amh_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ኢየሱስ ከሙታን ከተነሣ በኋላ ለደቀ መዛሙርቱ ሲገለጥላቸው ይህ ሦስተኛው ጊዜ ነበረ። ");
INSERT INTO amh_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ምሳ ከበሉ በኋላም ኢየሱስ ስምዖን ጴጥሮስን። የዮና ልጅ ስምዖን ሆይ፥ ከእነዚህ ይልቅ ትወደኛለህን? አለው። አዎን ጌታ ሆይ፥ እንድወድህ አንተ ታውቃለህ አለው። ግልገሎቼን አሰማራ አለው። ");
INSERT INTO amh_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ደግሞ ሁለተኛ። የዮና ልጅ ስምዖን ሆይ፥ ትወደኛለህን? አለው። አዎን ጌታ ሆይ፥ እንድወድህ አንተ ታውቃለህ አለው። ");
INSERT INTO amh_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ጠቦቶቼን ጠብቅ አለው። ሦስተኛ ጊዜ። የዮና ልጅ ስምዖን ሆይ፥ ትወደኛለህን? አለው። ሦስተኛ። ትወደኛለህን? ስላለው ጴጥሮስ አዘነና። ጌታ ሆይ፥ አንተ ሁሉን ታውቃለህ፤ እንድወድህ አንተ ታውቃለህ አለው። ኢየሱስም። በጎቼን አሰማራ። ");
INSERT INTO amh_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","እውነት እውነት እልሃለሁ፥ አንተ ጐልማሳ ሳለህ ወገብህን በገዛ ራስህ ታጥቀህ ወደምትወደው ትሄድ ነበር፤ ነገር ግን በሸመገልህ ጊዜ እጆችህን ትዘረጋለህ፥ ሌላውም ያስታጥቅሃል ወደማትወደውም ይወስድሃል አለው። ");
INSERT INTO amh_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","በምን ዓይነት ሞት እግዚአብሔርን ያከብር ዘንድ እንዳለው ሲያመለክት ይህን አለ። ይህንም ብሎ። ተከተለኝ አለው። ");
INSERT INTO amh_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ጴጥሮስም ዘወር ብሎ ኢየሱስ ይወደው የነበረውን ደቀ መዝሙር ሲከተለው አየ፤ እርሱም ደግሞ በእራት ጊዜ በደረቱ ተጠግቶ። ጌታ ሆይ፥ አሳልፎ የሚሰጥህ ማን ነው? ያለው ነበረ። ");
INSERT INTO amh_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ጴጥሮስም ይህን አይቶ ኢየሱስን። ጌታ ሆይ፥ ይህስ እንዴት ይሆናል? አለው። ");
INSERT INTO amh_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ኢየሱስም። እስክመጣ ድረስ ይኖር ዘንድ ብወድስ፥ ምን አግዶህ? አንተ ተከተለኝ አለው። ");
INSERT INTO amh_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ስለዚህ። ያ ደቀ መዝሙር አይሞትም የሚለው ይህ ነገር ወደ ወንድሞች ወጣ፤ ነገር ግን ኢየሱስ። እስክመጣ ድረስ ይኖር ዘንድ ብወድስ ምን አግዶህ? አለው እንጂ አይሞትም አላለውም። ");
INSERT INTO amh_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ስለ እነዚህም የመሰከረ ይህንንም ጽፎ ያለ ይህ ደቀ መዝሙር ነው፥ ምስክሩም እውነት እንደ ሆነ እናውቃለን። ");
INSERT INTO amh_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ኢየሱስም ያደረገው ብዙ ሌላ ነገር ደግሞ አለ፤ ሁሉ በእያንዳንዱ ቢጻፍ ለተጻፉት መጻሕፍት ዓለም ራሱ ባልበቃቸውም ይመስለኛል። ");
INSERT INTO amh_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","3","ደግሞ አርባ ቀን እየታያቸው ስለ እግዚአብሔርም መንግሥት ነገር እየነገራቸው፥ በብዙ ማስረጃ ከሕማማቱ በኋላ ሕያው ሆኖ ለእነርሱ ራሱን አሳያቸው። ");
INSERT INTO amh_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ከእነርሱም ጋር አብሮ ሳለ ከኢየሩሳሌም እንዳይወጡ አዘዛቸው፥ ነገር ግን። ከእኔ የሰማችሁትን አብ የሰጠውን የተስፋ ቃል ጠብቁ፤ ");
INSERT INTO amh_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ዮሐንስ በውኃ አጥምቆ ነበርና፥ እናንተ ግን ከጥቂት ቀን በኃላ በመንፈስ ቅዱስ ትጠመቃላችሁ አለ። ");
INSERT INTO amh_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","እነርሱም በተሰበሰቡ ጊዜ። ጌታ ሆይ፥ በዚህ ወራት ለእስራኤል መንግሥትን ትመልሳለህን? ብለው ጠየቁት። ");
INSERT INTO amh_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","እርሱም። አብ በገዛ ሥልጣኑ ያደረገውን ወራትንና ዘመናትን ታውቁ ዘንድ ለእናንተ አልተሰጣችሁም፤ ");
INSERT INTO amh_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ነገር ግን መንፈስ ቅዱስ በእናንተ ላይ በወረደ ጊዜ ኃይልን ትቀበላላችሁ፥ በኢየሩሳሌምም በይሁዳም ሁሉ በሰማርያም እስከ ምድር ዳርም ድረስ ምስክሮቼ ትሆናላችሁ አለ። ");
INSERT INTO amh_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ይህንም ከተናገረ በኋላ እነርሱ እያዩት ከፍ ከፍ አለ፤ ደመናም ከዓይናቸው ሰውራ ተቀበለችው። ");
INSERT INTO amh_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","እርሱም ሲሄድ ወደ ሰማይ ትኵር ብለው ሲመለከቱ ሳሉ፥ እነሆ፥ ነጫጭ ልብስ የለበሱ ሁለት ሰዎች በአጠገባቸው ቆሙ፤ ");
INSERT INTO amh_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ደግሞም። የገሊላ ሰዎች ሆይ፥ ወደስማይ እየተመለከታችሁ ስለ ምን ቆማችኋል? ይህ ከእናንተ ወደ ሰማይ የወጣው ኢየሱስ ወደ ሰማይ ሲሄድ እንዳያችሁት፥ እንዲሁ ይመጣል አሉአቸው። ");
INSERT INTO amh_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","በዚያን ጊዜ ደብረ ዘይት ከሚባለው ተራራ ወደ ኢየሩሳሌም ተመለሱ፥ እርሱም ከኢየሩሳሌም የሰንበት መንገድ ያህል የራቀ ነው። ");
INSERT INTO amh_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","በገቡም ጊዜ ወደሚኖሩበት ሰገነት ወጡ፥ ጴጥሮስና ዮሐንስም፥ ያዕቆብም፥ እንድርያስም፥ ፊልጶስም፥ ቶማስም፥ በርተሎሜዎስም፥ ማቴዎስም፥ የእልፍዮስ ልጅ ያዕቆብም፥ ቀናተኛ የሚባለው ስምዖንም፥ የያዕቆብ ልጅ ይሁዳም። ");
INSERT INTO amh_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","እነዚህ ሁሉ ከሴቶችና ከኢየሱስ እናት ከማርያም ከወንድሞቹም ጋር በአንድ ልብ ሆነው ለጸሎት ይተጉ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","በዚህም ወራት ጴጥሮስ መቶ ሀያ በሚያህል በሰዎች ማኅበር አብረው በነበሩ በወንድሞቹ መካከል ተነሥቶ አለ። ");
INSERT INTO amh_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ወንድሞች ሆይ፥ ኢየሱስን ለያዙት መሪ ስለሆናቸው ስለ ይሁዳ መንፈስ ቅዱስ አስቀድሞ በዳዊት አፍ የተናገረው የመጽሐፍ ቃል ይፈጸም ዘንድ ይገባ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ከእኛ ጋር ተቈጥሮ ነበርና፥ ለዚህም አገልግሎት ታድሎ ነበርና። ");
INSERT INTO amh_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ይህም ሰው በዓመፅ ዋጋ መሬት ገዛ በግንባሩም ተደፍቶ ከመካከሉ ተሰነጠቀ አንጀቱም ሁሉ ተዘረገፈ፤ ");
INSERT INTO amh_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","በኢየሩሳሌምም ለሚኖሩ ሁሉ ታወቀ፤ ስለዚህም ያ መሬት በቋንቋቸው አኬልዳማ ተብሎ ተጠራ፥ እርሱም የደም መሬት ማለት ነው። ");
INSERT INTO amh_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","በመዝሙር መጽሐፍ። መኖሪያው ምድረ በዳ ትሁን የሚኖርባትም አይኑር፤ ደግሞም። ሹመቱን ሌላ ይውሰዳት ተብሎ ተጽፎአልና። ");
INSERT INTO amh_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","23","ኢዮስጦስም የሚሉትን በርስያን የተባለውን ዮሴፍንና ማትያስን ሁለቱን አቆሙ። ");
INSERT INTO amh_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","26","ዕጣም ተጣጣሉላቸው፥ ዕጣውም ለማትያስ ወደቀና ከአሥራ አንዱ ሐዋርያት ጋር ተቈጠረ። ");
INSERT INTO amh_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","በዓለ ኀምሳ የተባለውም ቀን በደረሰ ጊዜ፥ ሁሉም በአንድ ልብ ሆነው አብረው ሳሉ፥ ");
INSERT INTO amh_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ድንገት እንደሚነጥቅ ዓውሎ ነፋስ ከሰማይ ድምፅ መጣ፥ ተቀምጠው የነበሩበትንም ቤት ሁሉ ሞላው። ");
INSERT INTO amh_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","እንደ እሳትም የተከፋፈሉ ልሳኖች ታዩአቸው፤ በያንዳንዳቸውም ላይ ተቀመጡባቸው። ");
INSERT INTO amh_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","በሁሉም መንፈስ ቅዱስ ሞላባቸው፥ መንፈስም ይናገሩ ዘንድ እንደ ሰጣቸው በሌላ ልሳኖች ይናገሩ ጀመር። ");
INSERT INTO amh_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ከሰማይም በታች ካሉ ሕዝብ ሁሉ በጸሎት የተጉ አይሁድ በኢየሩሳሌም ይኖሩ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ይህም ድምፅ በሆነ ጊዜ ሕዝብ ሁሉ ተሰበሰቡ፥ እያንዳንዱም በገዛ ቋንቋው ሲናገሩ ይሰማ ስለ ነበር የሚሉትን አጡ። ");
INSERT INTO amh_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ተገርመውም ተደንቀውም እንዲህ አሉ። እነሆ፥ እነዚህ የሚናገሩት ሁሉ የገሊላ ሰዎች አይደሉምን? ");
INSERT INTO amh_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","እኛም እያንዳንዳችን የተወለድንበትን የገዛ ቋንቋችንን እንዴት እንሰማለን? ");
INSERT INTO amh_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","የጳርቴና የሜድ የኢላሜጤም ሰዎች፥ በሁለት ወንዝም መካከል በይሁዳም በቀጰዶቅያም በጳንጦስም በእስያም፥ ");
INSERT INTO amh_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","በፍርግያም በጵንፍልያም በግብፅም በቀሬናም በኩል ባሉት በሊቢያ ወረዳዎች የምንኖር፥ በሮሜም የምንቀመጥ፥ አይሁድም ወደ ይሁዲነትም የገባን፥ ");
INSERT INTO amh_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","የቀርጤስና የዓረብ ሰዎች፥ የእግዚአብሔርን ታላቅ ሥራ በልሳኖቻችን ሲናገሩ እንሰማቸዋለን። ");
INSERT INTO amh_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ሁሉም ተገረሙና አመንትተው እርስ በርሳቸው። እንጃ ይህ ምን ይሆን? አሉ። ");
INSERT INTO amh_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ሌሎች ግን እያፌዙባቸው። ጉሽ የወይን ጠጅ ጠግበዋል አሉ። ");
INSERT INTO amh_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ነገር ግን ጴጥሮስ ከአሥራ አንዱ ጋር ቆመ፥ ድምፁንም ከፍ አድርጎ እንዲህ ሲል ተናገራቸው። አይሁድ በኢየሩሳሌምም የምትኖሩ ሁላችሁ፥ ይህ በእናንተ ዘንድ የታወቀ ይሁን፥ ቃሎቼንም አድምጡ። ");
INSERT INTO amh_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ለእናንተ እንደ መሰላችሁ እነዚህ የሰከሩ አይደሉም፥ ከቀኑ ሦስተኛ ሰዓት ነውና፤ ");
INSERT INTO amh_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ነገር ግን ይህ በነቢዩ በኢዩኤል የተባለው ነው። ");
INSERT INTO amh_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","እግዚአብሔር ይላል። በመጨረሻው ቀን እንዲህ ይሆናል፤ ሥጋ በለበሰ ሁሉ ላይ ከመንፈሴ አፈሳለሁ፤ ወንዶችና ሴቶች ልጆቻችሁም ትንቢት ይናገራሉ፥ ጎበዞቻችሁም ራእይ ያያሉ፥ ሽማግሌዎቻችሁም ሕልም ያልማሉ፤ ");
INSERT INTO amh_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ደግሞም በዚያች ወራት በወንዶችና በሴቶች ባሪያዎቼ ላይ ከመንፈሴ አፈሳለሁ ትንቢትም ይናገራሉ። ");
INSERT INTO amh_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ድንቆችን በላይ በሰማይ፥ ምልክቶችንም በታች በምድር እሰጣለሁ፤ ደምም እሳትም የጢስ ጭጋግም ይሆናል፤ ");
INSERT INTO amh_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ታላቅ የሆነ የተሰማም የጌታ ቀን ሳይመጣ ፀሐይ ወደ ጨለማ ጨረቃም ወደ ደም ይለወጣሉ። ");
INSERT INTO amh_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","የጌታን ስም የሚጠራም ሁሉ ይድናል። ");
INSERT INTO amh_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","የእስራኤል ሰዎች ሆይ፥ ይህን ቃል ስሙ፤ ራሳችሁ እንደምታውቁ፥ የናዝሬቱ ኢየሱስ እግዚአብሔር በመካከላችሁ በእርሱ በኩል ባደረገው ተአምራትና በድንቆች በምልክቶችም ከእግዚአብሔር ዘንድ ለእናንተ የተገለጠ ሰው ነበረ፤ ");
INSERT INTO amh_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","እርሱንም በእግዚአብሔር በተወሰነው አሳቡና በቀደመው እውቀቱ ተሰጥቶ በዓመፀኞች እጅ ሰቅላችሁ ገደላችሁት። ");
INSERT INTO amh_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","እግዚአብሔር ግን የሞትን ጣር አጥፍቶ አስነሣው፥ ሞት ይይዘው ዘንድ አልቻለምና። ");
INSERT INTO amh_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ዳዊት ስለ እርሱ እንዲህ ይላልና። ጌታን ሁልጊዜ በፊቴ አየሁት፥ እንዳልታወክ በቀኜ ነውና። ");
INSERT INTO amh_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ስለዚህ ልቤን ደስ አለው፥ ልሳኔም ሐሤት አደረገ፥ ደግሞም ሥጋዬ በተስፋ ያድራል፤ ");
INSERT INTO amh_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ነፍሴን በሲኦል አትተዋትምና፥ ቅዱስህንም መበስበስን ያይ ዘንድ አትሰጠውም። ");
INSERT INTO amh_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","የሕይወትን መንገድ አስታወቅኸኝ፤ ከፊትህ ጋር ደስታን ትሞላብኛለህ። ");
INSERT INTO amh_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ወንድሞች ሆይ፥ ስለ አባቶች አለቃ ስለ ዳዊት እንደ ሞተም እንደ ተቀበረም ለእናንተ በግልጥ እናገር ዘንድ ፍቀዱልኝ፤ መቃብሩም እስከ ዛሬ በእኛ ዘንድ ነው። ");
INSERT INTO amh_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ነቢይ ስለ ሆነ፥ ከወገቡም ፍሬ በዙፋኑ ያስቀምጥ ዘንድ እግዚአብሔር መሐላ እንደ ማለለት ስለ አወቀ፥ ");
INSERT INTO amh_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ስለ ክርስቶስ ትንሣኤ አስቀድሞ አይቶ፥ ነፍሱ በሲኦል እንዳልቀረች ሥጋውም መበስበስን እንዳላየ ተናገረ። ");
INSERT INTO amh_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ይህን ኢየሱስን እግዚአብሔር አስነሣው ለዚህም ነገር እኛ ሁላችን ምስክሮች ነን፤ ");
INSERT INTO amh_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ስለዚህ በእግዚአብሔር ቀኝ ከፍ ከፍ ብሎና የመንፈስ ቅዱስን የተስፋ ቃል ከአብ ተቀብሎ ይህን እናንተ አሁን የምታዩትንና የምትሰሙትን አፈሰሰው። ");
INSERT INTO amh_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","36","አለ። እንግዲህ ይህን እናንተ የሰቀላችሁትን ኢየሱስን እግዚአብሔር ጌታም ክርስቶስም እንዳደረገው የእስራኤል ወገን ሁሉ በእርግጥ ይወቅ። ");
INSERT INTO amh_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ይህንም በሰሙ ጊዜ ልባቸው ተነካ፥ ጴጥሮስንና ሌሎችንም ሐዋርያት። ወንድሞች ሆይ፥ ምን እናድርግ? አሉአቸው። ");
INSERT INTO amh_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ጴጥሮስም። ንስሐ ግቡ፥ ኃጢአታችሁም ይሰረይ ዘንድ እያንዳንዳችሁ በኢየሱስ ክርስቶስ ስም ተጠመቁ፤ የመንፈስ ቅዱስንም ስጦታ ትቀበላላችሁ። ");
INSERT INTO amh_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","የተስፋው ቃል ለእናንተና ለልጆቻችሁ ጌታ አምላካችንም ወደ እርሱ ለሚጠራቸው በሩቅ ላሉ ሁሉ ነውና አላቸው። ");
INSERT INTO amh_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","በብዙ ሌላ ቃልም መሰከረና። ከዚህ ጠማማ ትውልድ ዳኑ ብሎ መከራቸው። ");
INSERT INTO amh_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ቃሉንም የተቀበሉ ተጠመቁ፥ በዚያም ቀን ሦስት ሺህ የሚያህል ነፍስ ተጨመሩ፤ ");
INSERT INTO amh_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","በሐዋርያትም ትምህርትና በኅብረት እንጀራውንም በመቍረስ በየጸሎቱም ይተጉ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ነገር ግን በሰው ሁሉ ፍርሀት ሆነ፤ በሐዋርያትም እጅ ብዙ ድንቅና ምልክት ተደረገ። ");
INSERT INTO amh_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ያመኑትም ሁሉ አብረው ነበሩ፤ ");
INSERT INTO amh_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ያላቸውንም ሁሉ አንድነት አደረጉ። መሬታቸውንና ጥሪታቸውንም እየሸጡ፥ ማንኛውም እንደሚፈልግ ለሁሉ ያካፍሉት ነበር። ");
INSERT INTO amh_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","በየቀኑም በአንድ ልብ ሆነው በመቅደስ እየተጉ በቤታቸውም እንጀራ እየቈረሱ፥ በደስታና በጥሩ ልብ ምግባቸውን ይመገቡ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","እግዚአብሔርንም እያመሰገኑ በሕዝብ ሁሉ ፊት ሞገስ ነበራቸው። ጌታም የሚድኑትን ዕለት ዕለት በእነርሱ ላይ ይጨምር ነበር። ");
INSERT INTO amh_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ጴጥሮስና ዮሐንስም በጸሎት ጊዜ በዘጠኝ ሰዓት ወደ መቅደስ ይወጡ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ወደ መቅደስም ከሚገቡት ምጽዋት ይለምን ዘንድ፥ ሰዎች ተሸክመው መልካም በሚሉአት በመቅደስ ደጅ በየቀኑ ያስቀምጡት የነበሩ ከእናቱ ማኅፀን ጀምሮ አንካሳ የሆነ አንድ ሰው ነበረ። ");
INSERT INTO amh_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","እርሱም ጴጥሮስና ዮሐንስ ወደ መቅደስ ሊገቡ እንዳላቸው ባየ ጊዜ፥ ምጽዋትን ለመናቸው። ");
INSERT INTO amh_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ጴጥሮስም ከዮሐንስ ጋር ትኵር ብሎ ወደ እርሱ ተመልክቶ። ወደ እኛ ተመልከት አለው። ");
INSERT INTO amh_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","እርሱም አንድ ነገር ከእነርሱ እንዲቀበል ሲጠብቅ ወደ እነርሱ ተመለከተ። ");
INSERT INTO amh_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ጴጥሮስ ግን። ብርና ወርቅ የለኝም፤ ይህን ያለኝን ግን እሰጥሃለሁ፤ በናዝሬቱ በኢየሱስ ክርስቶስ ስም ተነሣና ተመላለስ አለው። ");
INSERT INTO amh_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","በቀኝ እጁም ይዞ አስነሣው፤ በዚያን ጊዜም እግሩና ቍርጭምጭምቱ ጸና፥ ");
INSERT INTO amh_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ወደ ላይ ዘሎም ቆመ፥ ይመላለስም ጀመር፤ እየተመላለሰም እየዘለለም እግዚአብሔርንም እያመሰገነ ከእነርሱ ጋር ወደ መቅደስ ገባ። ");
INSERT INTO amh_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ሕዝቡም ሁሉ እግዚአብሔርን እያመሰገነ ሲመላለስ አዩት፤ ");
INSERT INTO amh_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","መልካምም በሚሉአት በመቅደስ ደጅ ስለ ምጽዋት ተቀምጦ የነበረው እርሱ እንደ ሆነ አወቁት፤ በእርሱም ከሆነው የተነሣ መደነቅና መገረም ሞላባቸው። ");
INSERT INTO amh_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","እርሱም ጴጥሮስንና ዮሐንስን ይዞ ሳለ፥ ሕዝቡ ሁሉ እየተደነቁ የሰሎሞን ደጅ መመላለሻ በሚባለው አብረው ወደ እነርሱ ሮጡ። ");
INSERT INTO amh_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ጴጥሮስም አይቶ ለሕዝቡ እንዲህ ሲል መለሰ። የእስራኤል ሰዎች ሆይ፥ በዚህ ስለ ምን ትደነቃላችሁ? ወይስ በገዛ ኃይላችን ወይስ እግዚአብሔርን በመፍራታችን ይህ ይመላለስ ዘንድ እንዳደረግነው ስለ ምን ትኵር ብላችሁ ታዩናላችሁ? ");
INSERT INTO amh_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","የአብርሀምና የይስሐቅ የያዕቆብም አምላክ፥ የአባቶቻችን አምላክ፥ እናንተ አሳልፋችሁ የሰጣችሁትንና ሊፈታው ቈርጦ ሳለ በጲላጦስ ፊት የካዳችሁትን ብላቴናውን ኢየሱስን አከበረው። ");
INSERT INTO amh_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","እናንተ ግን ቅዱሱን ጻድቁንም ክዳችሁ ነፍሰ ገዳዩን ሰው ይሰጣችሁ ዘንድ ለመናችሁ፥ ");
INSERT INTO amh_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","የሕይወትንም ራስ ገደላችሁት፤ እርሱን ግን እግዚአብሔር ከሙታን አስነሣው፥ ለዚህም ነገር እኛ ምስክሮች ነን። ");
INSERT INTO amh_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","በስሙም በማመን ይህን የምታዩትንና የምታውቁትን የእርሱ ስም አጸናው፥ በእርሱም በኩል የሆነው እምነት በሁላችሁ ፊት ይህን ፍጹም ጤና ሰጠው። ");
INSERT INTO amh_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","አሁንም፥ ወንድሞቼ ሆይ፥ እናንተ እንደ አለቆቻችሁ ደግሞ ባለማወቅ እንዳደረጋችሁት አውቄአለሁ፤ ");
INSERT INTO amh_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","እግዚአብሔር ግን ክርስቶስ መከራ እንዲቀበል አስቀድሞ በነቢያት ሁሉ አፍ የተናገረውን እንዲሁ ፈጸመው። ");
INSERT INTO amh_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","21","እግዚአብሔር ከጥንት ጀምሮ በቅዱሳን ነቢያቱ አፍ የተናገረው፥ ነገር ሁሉ እስከሚታደስበት ዘመን ድረስ ሰማይ ይቀበለው ዘንድ ይገባልና። ");
INSERT INTO amh_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ሙሴም ለአባቶች። ጌታ አምላክ እኔን እንዳስነሣኝ ነቢይን ከወንድሞቻችሁ ያስነሣላችኋል፤ በሚነግራችሁ ሁሉ እርሱን ስሙት። ");
INSERT INTO amh_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ያንም ነቢይ የማትሰማው ነፍስ ሁሉ ከሕዝብ ተለይታ ትጠፋለች አለ። ");
INSERT INTO amh_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ሁለተኛም ከሳሙኤል ጀምሮ ከእርሱም በኋላ የተናገሩት ነቢያት ሁሉ ደግሞ ስለዚህ ወራት ተናገሩ። ");
INSERT INTO amh_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","እናንተ የነቢያት ልጆችና እግዚአብሔር ለአብርሃም። በዘርህ የምድር ወገኖች ሁሉ ይባረካሉ ብሎ፥ ከአባቶቻችን ጋር ያደረገው የኪዳን ልጆች ናችሁ። ");
INSERT INTO amh_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ለእናንተ አስቀድሞ እግዚአብሔር ብላቴናውን አስነሥቶ፥ እያንዳንዳችሁን ከክፋታችሁ እየመለሰ ይባርካችሁ ዘንድ፥ ሰደደው። ");
INSERT INTO amh_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ለሕዝቡም ሲናገሩ የካህናት አለቆችና የመቅደስ አዛዥ ሰዱቃውያንም፥ ");
INSERT INTO amh_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ሕዝቡን ስለ አስተማሩና በኢየሱስ የሙታንን ትንሣኤ ስለ ሰበኩ ተቸግረው፥ ወደ እነርሱ ቀረቡ፥ ");
INSERT INTO amh_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","እጃቸውንም ጭነውባቸው አሁን መሽቶ ነበርና እስከ ማግሥቱ ድረስ በወኅኒ አኖሩአቸው። ");
INSERT INTO amh_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ነገር ግን ቃሉን ከሰሙት ብዙዎች አመኑ፥ የወንዶችም ቍጥር አምስት ሺህ ያህል ሆነ። ");
INSERT INTO amh_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","7","እነርሱንም በመካከል አቁመው። በምን ኃይል ወይስ በማን ስም እናንተ ይህን አደረጋችሁ? ብለው ጠየቁአቸው። ");
INSERT INTO amh_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","በዚያን ጊዜ ጴጥሮስ መንፈስ ቅዱስንም ተሞልቶ እንዲህ አላቸው። እናንተ የሕዝብ አለቆችና ሽማግሌዎች፥ ");
INSERT INTO amh_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","እኛ ዛሬ ለድውዩ ሰው ስለ ተደረገው መልካም ሥራ ይህ በምን እንደዳነ ብንመረመር፥ ");
INSERT INTO amh_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","እናንተ በሰቀላችሁት እግዚአብሔርም ከሙታን ባስነሣው በናዝሬቱ በኢየሱስ ክርስቶስ ስም ይህ ደኅና ሆኖ በፊታችሁ እንደ ቆመ፥ ለእናንተ ለሁላችሁ ለእስራኤልም ሕዝብ ሁሉ የታወቀ ይሁን። ");
INSERT INTO amh_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","እናንተ ግንበኞች የናቃችሁት፥ የማዕዘን ራስ የሆነው ይህ ድንጋይ ነው። ");
INSERT INTO amh_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","መዳንም በሌላ በማንም የለም፤ እንድንበት ዘንድ የሚገባን ለሰዎች የተሰጠ ስም ከሰማይ በታች ሌላ የለምና። ");
INSERT INTO amh_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ጴጥሮስና ዮሐንስም በግልጥ እንደ ተናገሩ ባዩ ጊዜ፥ መጽሐፍን የማያውቁና ያልተማሩ ሰዎች እንደ ሆኑ አስተውለው አደነቁ፥ ከኢየሱስም ጋር እንደ ነበሩ አወቁአቸው፤ ");
INSERT INTO amh_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","የተፈወሰውንም ሰው ከእነርሱ ጋር ቆሞ ሲያዩ የሚመልሱትን አጡ። ");
INSERT INTO amh_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ከሸንጎም ወደ ውጭ ይወጡ ዘንድ አዝዘው። በእነዚህ ሰዎች ምን እንሥራ? ");
INSERT INTO amh_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","የታወቀ ምልክት በእነርሱ እጅ እንደ ተደረገ በኢየሩሳሌም ለሚኖሩ ሁሉ ተገልጦአልና፥ እንሸሽገው ዘንድ አንችልም፤ ");
INSERT INTO amh_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ነገር ግን በሕዝቡ ዘንድ አብዝቶ እንዳይስፋፋ፥ ከእንግዲህ ወዲህ ለማንም ሰው በዚህ ስም እንዳይናገሩ እየዛትን እንዘዛቸው ብለው እርስ በርሳቸው ተማከሩ። ");
INSERT INTO amh_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ጠርተውም በኢየሱስ ስም ፈጽመው እንዳይናገሩና እንዳያስተምሩ አዘዙአቸው። ");
INSERT INTO amh_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ጴጥሮስና ዮሐንስ ግን መልሰው። እግዚአብሔርን ከመስማት ይልቅ እናንተን እንሰማ ዘንድ በእግዚአብሔር ፊት የሚገባ እንደ ሆነ ቍረጡ፤ ");
INSERT INTO amh_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","እኛስ ያየነውንና የሰማነውን ከመናገር ዝም ማለት አንችልም አሉአቸው። ");
INSERT INTO amh_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","እነርሱም እንደ ምን እንደሚቀጡ ምክንያት ስላላገኙባቸው፥ እንደ ገና ዝተው ከሕዝቡ የተነሣ ፈቱአቸው፤ ሰዎች ሁሉ ስለ ሆነው ነገር እግዚአብሔርን ያከብሩ ነበርና። ");
INSERT INTO amh_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ይህ የመፈወስ ምልክት የተደረገለት ሰው ከአርባ ዓመት ይበልጠው ነበርና። ");
INSERT INTO amh_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ተፈትተውም ወደ ወገኖቻቸው መጡና የካህናት አለቆችና ሽማግሌዎች ያሉአቸውን ሁሉ ነገሩአቸው። ");
INSERT INTO amh_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","እነርሱም በሰሙ ጊዜ በአንድ ልብ ሆነው ወደ እግዚአብሔር ድምፃቸውን ከፍ አደረጉ እንዲህም አሉ። ጌታ ሆይ፥ አንተ ሰማዩንና ምድሩን ባሕሩንም በእነርሱም የሚኖረውን ሁሉ የፈጠርህ፥ ");
INSERT INTO amh_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","በመንፈስ ቅዱስም በብላቴናህ በአባታችን በዳዊት አፍ። አሕዛብ ለምን አጕረመረሙ? ሕዝቡስ ከንቱን ነገር ለምን አሰቡ? ");
INSERT INTO amh_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","የምድር ነገሥታት ተነሡ አለቆችም በጌታና በተቀባው ላይ አብረው ተከማቹ ብለህ የተናገርህ አምላክ ነህ። ");
INSERT INTO amh_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","31","ከጸለዩም በኋላ ተሰብስበው የነበሩበት ስፍራ ተናወጠ፥ በሁሉም መንፈስ ቅዱስ ሞላባቸው፥ የእግዚአብሔርንም ቃል በግልጥ ተናገሩ። ");
INSERT INTO amh_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ያመኑትም ሕዝብ አንድ ልብ አንዲትም ነፍስ ነበሩአቸው፥ ገንዘባቸውም ሁሉ በአንድነት ነበረ እንጂ ካለው አንድ ነገር ስንኳ የራሱ እንደ ሆነ ማንም አልተናገረም። ");
INSERT INTO amh_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ሐዋርያትም የጌታን የኢየሱስ ክርስቶስን ትንሣኤ በታላቅ ኃይል ይመሰክሩ ነበር፤ በሁሉም ላይ ታላቅ ጸጋ ነበረባቸው። ");
INSERT INTO amh_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","በመካከላቸው አንድ ስንኳ ችግረኛ አልነበረምና፤ መሬት ወይም ቤት ያላቸው ሁሉ እየሸጡ የተሸጠውን ዋጋ ያመጡ ነበርና፥ ");
INSERT INTO amh_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","በሐዋርያትም እግር አጠገብ ያኖሩ ነበር፤ ማናቸውም እንደሚፈልግ መጠን ለእያንዳንዱ ያካፍሉት ነበር። ");
INSERT INTO amh_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ትውልዱም የቆጵሮስ ሰው የነበረ አንድ ሌዋዊ ዮሴፍ የሚሉት ነበረ፥ እርሱም በሐዋርያት በርናባስ ተባለ ትርጓሜውም የመጽናናት ልጅ ነው፤ ");
INSERT INTO amh_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","እርሻም ነበረውና ሽጦ ገንዘቡን አምጥቶ ከሐዋርያት እግር አጠገብ አኖረው። ");
INSERT INTO amh_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ሐናንያም የተባለ አንድ ሰው ሰጲራ ከተባለች ከሚስቱ ጋር መሬት ሸጠ፥ ");
INSERT INTO amh_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ሚስቱም ደግሞ ስታውቅ ከሽያጩ አስቀረና እኩሌታውን አምጥቶ በሐዋርያት እግር አጠገብ አኖረው። ");
INSERT INTO amh_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ጴጥሮስም። ሐናንያ ሆይ፥ መንፈስ ቅዱስን ታታልልና ከመሬቱ ሽያጭ ታስቀር ዘንድ ሰይጣን በልብህ ስለ ምን ሞላ? ");
INSERT INTO amh_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ሳትሸጠው የአንተ አልነበረምን? ከሸጥኸውስ በኋላ በሥልጣንህ አልነበረምን? ይህን ነገር ስለ ምን በልብህ አሰብህ? እግዚአብሔርን እንጂ ሰውን አልዋሸህም አለው። ");
INSERT INTO amh_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ሐናንያም ይህን ቃል ሰምቶ ወደቀ ሞተም፤ በሰሙትም ሁሉ ላይ ታላቅ ፍርሃት ሆነ። ");
INSERT INTO amh_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ጐበዞችም ተነሥተው ከፈኑት አውጥተውም ቀበሩት። ");
INSERT INTO amh_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ከሦስት ሰዓት ያህል በኋላም ሚስቱ የሆነውን ሳታውቅ ገባች። ");
INSERT INTO amh_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ጴጥሮስም መልሶ። እስቲ ንገሪኝ፥ መሬታችሁን ይህን ለሚያህል ሸጣችሁትን? አላት። እርስዋም። አዎን፥ ይህን ለሚያህል ነው አለች። ");
INSERT INTO amh_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ጴጥሮስም። የጌታን መንፈስ ትፈታተኑ ዘንድ ስለ ምን ተስማማችሁ? እነሆ፥ ባልሽን የቀበሩት ሰዎች እግር በደጅ ነው አንቺንም ያወጡሻል አላት። ");
INSERT INTO amh_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ያን ጊዜም በእግሩ አጠገብ ወደቀች ሞተችም፤ ጐበዞችም ሲገቡ ሞታ አገኙአት አውጥተውም በባልዋ አጠገብ ቀበሩአት። ");
INSERT INTO amh_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","በቤተ ክርስቲያን ሁሉና ይህንም በሰሙ ሁሉ ላይ ታላቅ ፍርሃት ሆነ። ");
INSERT INTO amh_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","በሐዋርያትም እጅ ብዙ ምልክትና ድንቅ በሕዝብ መካከል ይደረግ ነበር፤ ሁሉም በአንድ ልብ ሆነው በሰሎሞን ደጅ መመላለሻ ነበሩ። ");
INSERT INTO amh_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ከሌሎችም አንድ ስንኳ ሊተባበራቸው የሚደፍር አልነበረም፥ ");
INSERT INTO amh_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ሕዝቡ ግን ያከብሩአቸው ነበር፤ የሚያምኑትም ከፊት ይልቅ ለጌታ ይጨመሩለት ነበር፤ ወንዶችና ሴቶችም ብዙ ነበሩ። ");
INSERT INTO amh_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ስለዚህም ጴጥሮስ ሲያልፍ ጥላውም ቢሆን ከእነርሱ አንዱን ይጋርድ ዘንድ ድውያንን ወደ አደባባይ አውጥተው በአልጋና በወሰካ ያኖሩአቸው ነበር። ");
INSERT INTO amh_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ደግሞም በኢየሩሳሌም ዙሪያ ካለችው ከተማ ድውያንንና በርኵሳን መናፍስት የተሣቀዩትን እያመጡ ብዙ ሰዎች ይሰበስቡ ነበር፤ ሁሉም ይፈወሱ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ሊቀ ካህናቱ ግን የሰዱቃውያን ወገን ሆነውም ከእርሱ ጋር የነበሩት ሁሉ ተነሡ ቅንዓትም ሞላባቸው። ");
INSERT INTO amh_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","በሐዋርያትም ላይ እጃቸውን ጭነው በሕዝቡ ወኅኒ ውስጥ አኖሩአቸው። ");
INSERT INTO amh_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","የጌታ መልአክ ግን በሌሊት የወኅኒውን ደጅ ከፍቶ አወጣቸውና። ");
INSERT INTO amh_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","ሂዱና ቆማችሁ የዚህን ሕይወት ቃል ሁሉ ለሕዝብ በመቅደስ ንገሩ አላቸው። ");
INSERT INTO amh_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","በሰሙም ጊዜ ማልደው ወደ መቅደስ ገብተው አስተማሩ። ግን ሊቀ ካህናቱና ከእርሱ ጋር የነበሩት መጥተው ሸንጎውንና የእስራኤልን ልጆች ሽማግሌዎች ሁሉ በአንድነት ጠሩ፥ ያመጡአቸውም ዘንድ ወደ ወኅኒ ላኩ። ");
INSERT INTO amh_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","24","የመቅደስ አዛዥና የካህናት አለቆችም ይህን ነገር በሰሙ ጊዜ። እንጃ ይህ ምን ይሆን? እያሉ ስለ እነርሱ አመነቱ። ");
INSERT INTO amh_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","አንድ ሰውም መጥቶ። እነሆ፥ በወኅኒ ያኖራችኋቸው ሰዎች እየቆሙ ሕዝቡንም እያስተማሩ በመቅደስ ናቸው ብሎ አወራላቸው። ");
INSERT INTO amh_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","በዚያን ጊዜ አዛዡ ከሎሌዎች ጋር ሄዶ አመጣቸው፥ በኃይል ግን አይደለም፤ ሕዝቡ እንዳይወግሩአቸው ይፈሩ ነበርና። ");
INSERT INTO amh_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","አምጥተውም በሸንጎ አቆሙአቸው። ");
INSERT INTO amh_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ሊቀ ካህናቱም። በዚህ ስም እንዳታስተምሩ አጥብቀን አላዘዝናችሁምን? እነሆም፥ ኢየሩሳሌምን በትምህርታችሁ ሞልታችኋል፤ የዚያንም ሰው ደም በእኛ ታመጡብን ዘንድ ታስባላችሁ ብሎ ጠየቃቸው። ");
INSERT INTO amh_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ጴጥሮስና ሐዋርያትም መልሰው አሉ። ከሰው ይልቅ ለእግዚአብሔር ልንታዘዝ ይገባል። ");
INSERT INTO amh_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","እናንተ በእንጨት ላይ ሰቅላችሁ የገደላችሁትን ኢየሱስን የአባቶቻችን አምላክ አስነሣው፤ ");
INSERT INTO amh_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ይህን እግዚአብሔር፥ ለእስራኤል ንስሐን የኃጢአትንም ስርየት ይሰጥ ዘንድ፥ ራስም መድኃኒትም አድርጎ በቀኙ ከፍ ከፍ አደረገው። ");
INSERT INTO amh_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","እኛም ለዚህ ነገር ምስክሮች ነን፥ ደግሞም እግዚአብሔር ለሚታዘዙት የሰጠው መንፈስ ቅዱስ ምስክር ነው። ");
INSERT INTO amh_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","እነርሱም ሲሰሙ በጣም ተቈጡ ሊገድሉአቸውም አሰቡ። ");
INSERT INTO amh_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ነገር ግን በሕዝብ ሁሉ ዘንድ የከበረ የሕግ መምህር ገማልያል የሚሉት አንድ ፈሪሳዊ በሸንጎ ተነሥቶ ሐዋርያትን ጥቂት ፈቀቅ እንዲያደርጉአቸው አዘዘ፥ ");
INSERT INTO amh_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","እንዲህም አላቸው። የእስራኤል ሰዎች ሆይ፥ ስለ እነዚህ ሰዎች ምን እንደምታደርጉ ለራሳችሁ ተጠንቀቁ። ");
INSERT INTO amh_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ከዚህ ወራት አስቀድሞ ቴዎዳስ። እኔ ታላቅ ነኝ ብሎ ተነሥቶ ነበርና፥ አራት መቶ የሚያህሉ ሰዎችም ከእርሱ ጋር ተባበሩ፤ እርሱም ጠፋ የሰሙትም ሁሉ ተበተኑ እንደ ምናምንም ሆኑ። ");
INSERT INTO amh_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ከዚህ በኋላ ሰዎች በተጻፉበት ዘመን የገሊላው ይሁዳ ተነሣ ብዙ ሰዎችንም አሸፍቶ አስከተለ፤ እርሱም ጠፋ የሰሙትም ሁሉ ተበታተኑ። ");
INSERT INTO amh_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","አሁንም እላችኋለሁ። ከእነዚህ ሰዎች ተለዩ ተዉአቸውም፤ ይህ አሳብ ወይም ይህ ሥራ ከሰው እንደ ሆነ ይጠፋልና፤ ");
INSERT INTO amh_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ከእግዚአብሔር እንደ ሆነ ግን ታጠፉአቸው ዘንድ አይቻላችሁም፥ በእርግጥ ከእግዚአብሔር ጋር ስትጣሉ ምናልባት እንዳትገኙ። ");
INSERT INTO amh_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ሰሙትም፥ ሐዋርያትንም ወደ እነርሱ ጠርተው ገረፉአቸው፥ በኢየሱስም ስም እንዳይናገሩ አዝዘው ፈቱአቸው። ");
INSERT INTO amh_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","እነርሱም ስለ ስሙ ይናቁ ዘንድ የተገባቸው ሆነው ስለ ተቈጠሩ ከሸንጎው ፊት ደስ እያላቸው ወጡ፤ ");
INSERT INTO amh_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ዕለት ዕለትም በመቅደስና በቤታቸው ስለ ኢየሱስ እርሱ ክርስቶስ እንደ ሆነ ማስተማርንና መስበክን አይተዉም ነበር። ");
INSERT INTO amh_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","በዚህም ወራት ደቀ መዛሙርት እየበዙ ሲሄዱ ከግሪክ አገር መጥተው የነበሩት አይሁድ በይሁዳ ኖረው በነበሩት አይሁድ አንጐራጐሩባቸው፥ በየቀኑ በተሠራው አገልግሎት መበለቶቻቸውን ችላ ይሉባቸው ነበርና። ");
INSERT INTO amh_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","አሥራ ሁለቱም ደቀ መዛሙርት ሁሉን ጠርተው እንዲህ አሉአቸው። የእግዚአብሔር ቃል ትተን ማዕድን እናገለግል ዘንድ የሚገባ ነገር አይደለም። ");
INSERT INTO amh_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ወንድሞች ሆይ፥ በመልካም የተመሰከረላቸውን መንፈስ ቅዱስና ጥበብም የሞላባቸውን ሰባት ሰዎች ከእናንተ ምረጡ፥ ለዚህም ጉዳይ እንሾማቸዋለን፤ ");
INSERT INTO amh_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","እኛ ግን ለጸሎትና ቃሉን ለማገልገል እንተጋለን። ");
INSERT INTO amh_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ይህም ቃል ሕዝብን ሁሉ ደስ አሰኛቸው፤ እምነትና መንፈስ ቅዱስም የሞላበትን ሰው እስጢፋኖስን ፊልጶስንም ጵሮኮሮስንም ኒቃሮናንም ጢሞናንም ጳርሜናንም ወደ ይሁዲነት ገብቶ የነበረውን የአንጾኪያውን ኒቆላዎስንም መረጡ። ");
INSERT INTO amh_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","በሐዋርያትም ፊት አቆሙአቸው፥ ከጸለዩም በኋላ እጃቸውን ጫኑባቸው። ");
INSERT INTO amh_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","የእግዚአብሔርም ቃል እየሰፋ ሄደ፥ በኢየሩሳሌምም የደቀ መዛሙርት ቍጥር እጅግ እየበዛ ሄደ፤ ከካህናትም ብዙ ሰዎች ለሃይማኖት የታዘዙ ሆኑ። ");
INSERT INTO amh_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","እስጢፋኖስም ጸጋንና ኃይልን ተሞልቶ በሕዝቡ መካከል ድንቅንና ታላቅ ምልክትን ያደርግ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","የነፃ ወጪዎች ከተባለችው ምኵራብም ከቀሬናና ከእስክንድርያም ሰዎች ከኪልቅያና ከእስያም ከነበሩት አንዳንዶቹ ተነሥተው እስጢፋኖስን ይከራከሩት ነበር፤ ");
INSERT INTO amh_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ይናገርበት የነበረውንም ጥበብና መንፈስ ይቃወሙ ዘንድ አልቻሉም። ");
INSERT INTO amh_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","በዚያን ጊዜ። በሙሴ ላይ በእግዚአብሔርም ላይ የስድብን ነገር ሲናገር ሰምተነዋል የሚሉ ሰዎችን አስነሡ። ");
INSERT INTO amh_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ሕዝቡንና ሽማግሌዎችንም ጻፎችንም አናደዱ፥ ቀርበውም ያዙት ወደ ሸንጎም አመጡትና። ");
INSERT INTO amh_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ይህ ሰው በዚህ በተቀደሰው ስፍራ በሕግም ላይ የስድብን ነገር ለመናገር አይተውም፤ ");
INSERT INTO amh_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ይህ የናዝሬቱ ኢየሱስ ይህን ስፍራ ያፈርሰዋል ሙሴም ያስተላለፈልንን ሥርዓት ይለውጣል ሲል ሰምተነዋልና የሚሉ የሐሰት ምስክሮችን አቆሙ። ");
INSERT INTO amh_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","በሸንጎም የተቀመጡት ሁሉ ትኵር ብለው ሲመለከቱት እንደ መልአክ ፊት ሆኖ ፊቱን አዩት። ");
INSERT INTO amh_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ሊቀ ካህናቱም። ይህ ነገር እንዲህ ነውን? አለው፤ ");
INSERT INTO amh_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","እርሱም እንዲህ አለ። ወንድሞችና አባቶች ሆይ፥ ስሙ። የክብር አምላክ ለአባታችን ለአብርሃም በካራን ሳይቀመጥ ገና በሁለት ወንዝ መካከል ሳለ ታየና። ");
INSERT INTO amh_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ከአገርህና ከዘመዶችህም ወጥተህ ወደማሳይህ ወደ ማንኛውም ምድር ና አለው። ");
INSERT INTO amh_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","በዚያን ጊዜ ከከለዳውያን አገር ወጥቶ በካራን ተቀመጠ። ከዚያም አባቱ ከሞተ በኋላ እናንተ ዛሬ ወደምትኖሩባት ወደዚች አገር አወጣው። ");
INSERT INTO amh_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","በዚችም የእግር ጫማ ስንኳ የሚያህል ርስት አልሰጠውም፤ ነገር ግን ልጅ ሳይኖረው ለእርሱ ከእርሱም በኋላ ለዘሩ ርስት አድርጎ ይሰጠው ዘንድ ተስፋ ሰጠው። ");
INSERT INTO amh_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","እግዚአብሔርም ዘሩ በሌላ አገር መጻተኞች እንዲሆኑ አራት መቶ ዓመትም ባሪያዎች እንዲያደርጉአቸው እንዲያስጨንቁአቸውም እንዲህ ተናገረ፤ ");
INSERT INTO amh_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ደግሞም እግዚአብሔር። እንደ ባሪያዎች በሚገዙአቸው ሕዝብ ላይ እኔ እፈርድባቸዋለሁ፥ ከዚህም በኋላ ይወጣሉ በዚህም ስፍራ ያመልኩኛል አለ። ");
INSERT INTO amh_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","የመገረዝንም ኪዳን ሰጠው፤ እንዲሁም ይስሐቅን ወለደ በስምንተኛውም ቀን ገረዘው ይስሐቅም ያዕቆብን ያዕቆብም አሥራ ሁለቱን የአባቶችን አለቆች። ");
INSERT INTO amh_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","የአባቶችም አለቆች በዮሴፍ ቀንተው ወደ ግብፅ ሸጡት፤ እግዚአብሔርም ከእርሱ ጋር ነበረ፥ ");
INSERT INTO amh_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ከመከራውም ሁሉ አወጣው፥ በግብፅ ንጉሥ በፈርዖንም ፊት ሞገስንና ጥበብን ሰጠው፥ በግብፅና በቤቱ ሁሉ ላይም ቢትወደድ አድርጎ ሾመው። ");
INSERT INTO amh_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","በግብፅና በከነዓንም አገር ሁሉ ራብና ብዙ ጭንቅ መጣ፥ አባቶቻችንም ምግብን አላገኙም። ");
INSERT INTO amh_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ያዕቆብም በግብፅ እህል መኖሩን በሰማ ጊዜ በመጀመሪያ አባቶቻችንን ሰደዳቸው፤ ");
INSERT INTO amh_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","በሁለተኛውም ዮሴፍ ለወንድሞቹ ታወቀ፥ የዮሴፍም ትውልድ በፈርዖን ዘንድ ተገለጠ። ");
INSERT INTO amh_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ዮሴፍም አባቱን ያዕቆብንና ሰባ አምስት ነፍስ የነበረውን ቤተ ዘመድ ሁሉ ልኮ አስጠራ። ");
INSERT INTO amh_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ያዕቆብም ወደ ግብፅ ወረደ እርሱም ሞተ አባቶቻችንም፤ ");
INSERT INTO amh_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ወደ ሴኬምም አፍልሰው አብርሃም ከሴኬም አባት ከኤሞር ልጆች በብር በገዛው መቃብር ቀበሩአቸው። ");
INSERT INTO amh_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","19","እርሱም ወገናችንን ተተንኵሎ ሕፃናትን በሕይወት እንዳይጠብቁ ወደ ውጭ ይጥሉ ዘንድ አድርጎ አባቶቻችንን አስጨነቀ። ");
INSERT INTO amh_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","በዚያን ጊዜ ሙሴ ተወለደ በእግዚአብሔርም ፊት ያማረ ነበር፤ በአባቱ ቤትም ሦስት ወር አደገ፤ ");
INSERT INTO amh_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","በተጣለም ጊዜ የፈርዖን ልጅ አነሣችው ልጅም ይሆናት ዘንድ አሳደገችው። ");
INSERT INTO amh_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ሙሴም የግብፆችን ጥበብ ሁሉ ተማረ፥ በቃሉና በሥራውም የበረታ ሆነ። ");
INSERT INTO amh_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ነገር ግን አርባ ዓመት ሲሞላው ወንድሞቹን የእስራኤልን ልጆች ይጐበኝ ዘንድ በልቡ አሰበ። ");
INSERT INTO amh_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","አንዱም ሲበደል አይቶ ረዳው፥ የግብፅን ሰውም መትቶ ለተገፋው ተበቀለ። ");
INSERT INTO amh_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ወንድሞቹም እግዚአብሔር በእጁ መዳንን እንዲሰጣቸው የሚያስተውሉ ይመስለው ነበር፥ እነርሱ ግን አላስተዋሉም። ");
INSERT INTO amh_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","በማግሥቱም እርስ በርሳቸው ሲጣሉ አገኛቸው፥ ሊያስታርቃቸውም ወዶ። ሰዎች ሆይ፥ እናንተስ ወንድማማች ናችሁ፤ ስለ ምን እርስ በርሳችሁ ትበዳደላላችሁ? አላቸው። ");
INSERT INTO amh_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ያም ባልንጀራውን የሚበድል ግን። አንተን በእኛ ላይ ሹምና ፈራጅ እንድትሆን የሾመህ ማን ነው? ");
INSERT INTO amh_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ወይስ ትናንትና የግብፁን ሰው እንደ ገደልኸው ልትገድለኝ ትወዳለህን? ብሎ ገፋው። ");
INSERT INTO amh_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ሙሴም ከዚህ ነገር የተነሣ ሸሽቶ በምድያም አገር መጻተኛ ሆኖ ኖረ፤ በዚያም ሁለት ልጆች ወለደ። ");
INSERT INTO amh_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","አርባ ዓመትም ሲሞላ የጌታ መልአክ በሲና ተራራ ምድረ በዳ በቍጥቋጦ መካከል በእሳት ነበልባል ታየው። ");
INSERT INTO amh_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","33","ጌታም። የቆምህባት ስፍራ የተቀደሰች ምድር ናትና የእግርህን ጫማ አውልቅ። ");
INSERT INTO amh_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","በግብፅ ያሉትን የሕዝቤን መከራ ፈጽሜ አይቼ መቃተታቸውንም ሰምቼ ላድናቸው ወረድሁ፤ አሁንም ና፥ ወደ ግብፅ እልክሃለሁ አለው። ");
INSERT INTO amh_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ሹምና ፈራጅ እንድትሆን የሾመህ ማን ነው? ብለው የካዱትን፥ ይህን ሙሴን በቍጥቋጦው በታየው በመልአኩ እጅ እግዚአብሔር ሹምና ቤዛ አድርጎ ላከው። ");
INSERT INTO amh_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ይህ ሰው በግብፅ ምድርና በኤርትራ ባሕር በምድረ በዳም አርባ ዓመት ድንቅና ምልክት እያደረገ አወጣቸው። ");
INSERT INTO amh_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ይህ ሰው ለእስራኤል ልጆች። እግዚአብሔር ከወንድሞቻችሁ እንደ እኔ ያለ ነቢይ ያስነሣላችኋል፤ እርሱን ስሙት ያላቸው ሙሴ ነው። ");
INSERT INTO amh_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ይህ ሰው በሲና ተራራ ከተናገረው መልአክና ከአባቶቻችን ጋር በምድረ በዳ በማኅበሩ ውስጥ የነበረው ነው፤ ይሰጠንም ዘንድ ሕይወት ያላቸውን ቃላት ተቀበለ፤ ");
INSERT INTO amh_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ለእርሱም አባቶቻችን ሊታዘዙት አልወደዱም፤ ነገር ግን ገፉት በልባቸውም ወደ ግብፅ ተመለሱ፤ ");
INSERT INTO amh_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","አሮንንም። በፊታችን የሚሄዱ አማልክት ሥራልን፤ ይህ ከግብፅ ምድር ያወጣን ሙሴ ምን እንደ ሆነ አናውቅምና አሉት። ");
INSERT INTO amh_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","በዚያም ወራት ጥጃ አደረጉ ለጣዖቱም መሥዋዕት አቀረቡ፥ በእጃቸውም ሥራ ደስ አላቸው። ");
INSERT INTO amh_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","እግዚአብሔር ግን ዘወር አለ የሰማይንም ጭፍራ ያመልኩ ዘንድ አሳልፎ ሰጣቸው፥ በነቢያትም መጽሐፍ። እናንተ የእስራኤል ቤት፥ አርባ ዓመት በምድረ በዳ የታረደውን ከብትና መሥዋዕትን አቀረባችሁልኝን? ");
INSERT INTO amh_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ትሰግዱላቸውም ዘንድ የሠራችኋቸውን ምስሎች እነርሱንም የሞሎክን ድንኳንና ሬምፉም የሚሉትን የአምላካችሁን ኮከብ አነሣችሁ፤ እኔም ከባቢሎን ወዲያ እሰዳችኋለሁ ተብሎ እንዲህ ተጽፎአል። ");
INSERT INTO amh_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","እንዳየው ምስል አድርጎ ይሠራት ዘንድ ሙሴን ተናግሮ እንዳዘዘው፥ የምስክር ድንኳን ከአባቶቻችን ዘንድ በምድረ በዳ ነበረች፤ ");
INSERT INTO amh_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","አባቶቻችንም ደግሞ በተራ ተቀብለው እግዚአብሔር በፊታቸው ያወጣቸውን የአሕዛብን አገር በያዙት ጊዜ ከኢያሱ ጋር አገቡአት፥ እስከ ዳዊት ዘመንም ድረስ ኖረች። ");
INSERT INTO amh_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","እርሱም በእግዚአብሔር ፊት ሞገስ አግኝቶ ለያዕቆብ አምላክ ማደሪያን ያገኝ ዘንድ ለመነ። ");
INSERT INTO amh_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ነገር ግን ሰሎሞን ቤት ሠራለት። ");
INSERT INTO amh_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","51","እናንተ አንገተ ደንዳኖች ልባችሁና ጆሮአችሁም ያልተገረዘ፥ እናንተ ሁልጊዜ መንፈስ ቅዱስን ትቃወማላችሁ፤ አባቶቻችሁ እንደ ተቃወሙት እናንተ ደግሞ። ");
INSERT INTO amh_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","54","ይህንም በሰሙ ጊዜ በልባቸው በጣም ተቈጡ ጥርሳቸውንም አፋጩበት። ");
INSERT INTO amh_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","መንፈስ ቅዱስንም ተሞልቶ ወደ ሰማይ ትኵር ብሎ ሲመለከት የእግዚአብሔርን ክብር ኢየሱስንም በእግዚአብሔር ቀኝ ቆሞ አየና። ");
INSERT INTO amh_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","እነሆ፥ ሰማያት ተከፍተው የሰው ልጅም በእግዚአብሔር ቀኝ ቆሞ አያለሁ አለ። ");
INSERT INTO amh_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","በታላቅ ድምፅም እየጮኹ ጆሮአቸውን ደፈኑ፥ በአንድ ልብ ሆነውም ወደ እርሱ ሮጡ፥ ");
INSERT INTO amh_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ከከተማም ወደ ውጭ አውጥተው ወገሩት። ምስክሮችም ልብሳቸውን ሳውል በሚሉት በአንድ ጎበዝ እግር አጠገብ አኖሩ። ");
INSERT INTO amh_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","እስጢፋኖስም። ጌታ ኢየሱስ ሆይ፥ ነፍሴን ተቀበል ብሎ ሲጠራ ይወግሩት ነበር። ");
INSERT INTO amh_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ተንበርክኮም። ጌታ ሆይ፥ ይህን ኃጢአት አትቍጠርባቸው ብሎ በታላቅ ድምፅ ጮኸ። ይህንም ብሎ አንቀላፋ። ሳውልም በእርሱ መገደል ተስማምቶ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","በዚያን ቀንም በኢየሩሳሌም ባለች ቤተ ክርስቲያን ላይ ታላቅ ስደት ሆነ፤ ሁሉም ከሐዋርያትም በቀር ወደ ይሁዳና ወደ ሰማርያ አገሮች ተበተኑ። ");
INSERT INTO amh_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","በጸሎትም የተጉ ሰዎች እስጢፋኖስን ቀበሩት ታላቅ ልቅሶም አለቀሱለት። ");
INSERT INTO amh_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ሳውል ግን ቤተ ክርስቲያንን ያፈርስ ነበር፤ ወደ ሁሉም ቤት እየገባ ወንዶችንም ሴቶችንም እየጐተተ ወደ ወኅኒ አሳልፎ ይሰጥ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","የተበተኑትም ቃሉን እየሰበኩ ዞሩ። ");
INSERT INTO amh_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ፊልጶስም ወደ ሰማርያ ከተማ ወርዶ ክርስቶስን ሰበከላቸው። ");
INSERT INTO amh_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ሕዝቡም የፊልጶስን ቃል በሰሙ ጊዜ ያደርጋት የነበረውንም ምልክት ባዩ ጊዜ፥ የተናገረውን በአንድ ልብ አደመጡ። ");
INSERT INTO amh_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ርኵሳን መናፍስት በታላቅ ድምፅ እየጮኹ ከብዙ ሰዎች ይወጡ ነበርና፤ ብዙም ሽባዎችና አንካሶች ተፈወሱ፤ ");
INSERT INTO amh_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","በዚያችም ከተማ ታላቅ ደስታ ሆነ። ");
INSERT INTO amh_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ሲሞን የሚሉት አንድ ሰው ግን። እኔ ታላቅ ነኝ ብሎ፥ እየጠነቈለ የሰማርያንም ወገን እያስገረመ ቀድሞ በከተማ ነበረ። ");
INSERT INTO amh_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ከታናናሾችም ጀምሮ እስከ ታላላቆቹ ድረስ። ታላቁ የእግዚአብሔር ኃይል ይህ ነው እያሉ ሁሉ ያደምጡት ነበር። ");
INSERT INTO amh_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ከብዙ ዘመንም ጀምሮ በጥንቈላ ስላስገረማቸው ያደምጡት ነበር። ");
INSERT INTO amh_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ነገር ግን ስለ እግዚአብሔር መንግሥትና ስለ ኢየሱስ ክርስቶስ ስም እየሰበከላቸው ፊልጶስን ባመኑት ጊዜ፥ ወንዶችም ሴቶችም ተጠመቁ። ");
INSERT INTO amh_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ሲሞንም ደግሞ ራሱ አመነ፤ ተጠምቆም ከፊልጶስ ጋር ይተባበር ነበር፤ የሚደረገውንም ምልክትና ታላቅ ተአምራት ባየ ጊዜ ተገረመ። ");
INSERT INTO amh_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","በኢየሩሳሌምም የነበሩት ሐዋርያት የሰማርያ ሰዎች የእግዚአብሔርን ቃል እንደተቀበሉ ሰምተው ጴጥሮስንና ዮሐንስን ሰደዱላቸው። ");
INSERT INTO amh_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","እነርሱም በወረዱ ጊዜ መንፈስ ቅዱስን ይቀበሉ ዘንድ ጸለዩላቸው፤ ");
INSERT INTO amh_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","በጌታ በኢየሱስ ስም ብቻ ተጠምቀው ነበር እንጂ ከእነርሱ በአንዱ ላይ ስንኳ ገና አልወረደም ነበርና። ");
INSERT INTO amh_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","በዚያን ጊዜ እጃቸውን ጫኑባቸው መንፈስ ቅዱስንም ተቀበሉ። ");
INSERT INTO amh_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ሲሞንም በሐዋርያት እጅ መጫን መንፈስ ቅዱስ እንዲሰጥ ባየ ጊዜ፥ ገንዘብ አመጣላቸውና። ");
INSERT INTO amh_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","እጄን የምጭንበት ሁሉ መንፈስ ቅዱስን ይቀበል ዘንድ ለእኔ ደግሞ ይህን ሥልጣን ስጡኝ አለ። ");
INSERT INTO amh_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ጴጥሮስ ግን እንዲህ አለው። የእግዚአብሔርን ስጦታ በገንዘብ እንድታገኝ አስበሃልና ብርህ ከአንተ ጋር ይጥፋ። ");
INSERT INTO amh_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ልብህ በእግዚአብሔር ፊት የቀና አይደለምና ከዚህ ነገር ዕድል ወይም ፈንታ የለህም። ");
INSERT INTO amh_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","እንግዲህ ስለዚህ ክፋትህ ንሰሐ ግባ፥ ምናልባትም የልብህን አሳብ ይቅር ይልህ እንደ ሆነ ወደ እግዚአብሔር ለምን፤ ");
INSERT INTO amh_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","በመራራ መርዝና በዓመፅ እስራት እንዳለህ አይሃለሁና። ");
INSERT INTO amh_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ሲሞንም መልሶ። ካላችሁት አንዳች እንዳይደርስብኝ እናንተው ወደ ጌታ ለምኑልኝ አላቸው። ");
INSERT INTO amh_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","እነርሱም ከመሰከሩና የጌታን ቃል ከተናገሩ በኋላ ወደ ኢየሩሳሌም ተመለሱ፤ በሳምራውያን በብዙ መንደሮችም ወንጌልን ሰበኩ። ");
INSERT INTO amh_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","የጌታም መልአክ ፊልጶስን። ተነሥተህ በደቡብ በኩል ከኢየሩሳሌም ወደ ጋዛ ወደሚያወርደው ምድረ በዳ ወደ ሆነ መንገድ ሂድ አለው። ");
INSERT INTO amh_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ተነሥቶም ሄደ። እነሆም፥ ህንደኬ የተባለች የኢትዮጵያ ንግሥት አዛዥና ጃንደረባ የነበረ በገንዘብዋም ሁሉ የሠለጠነ አንድ የኢትዮጵያ ሰው ሊሰግድ ወደ ኢየሩሳሌም መጥቶ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ሲመለስም በሰረገላ ተቀምጦ የነቢዩን የኢሳይያስን መጽሐፍ ያነብ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","መንፈስም ፊልጶስን። ወደዚህ ሰረገላ ቅረብና ተገናኝ አለው። ");
INSERT INTO amh_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ፊልጶስም ሮጦ የነቢዩን የኢሳይያስን መጽሐፍ ሲያነብ ሰማና። በውኑ የምታነበውን ታስተውለዋለህን? አለው። ");
INSERT INTO amh_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","እርሱም። የሚመራኝ ሳይኖር ይህ እንዴት ይቻለኛል? አለው። ወጥቶም ከእርሱ ጋር ይቀመጥ ዘንድ ፊልጶስን ለመነው። ");
INSERT INTO amh_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ያነበውም የነበረ የመጽሐፉ ክፍል ይህ ነበረ፤ እንደ በግ ወደ መታረድ ተነዳ፥ የበግ ጠቦትም በሸላቹ ፊት ዝም እንደሚል፥ እንዲሁ አፉን አልከፈተም። ");
INSERT INTO amh_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","በውርደቱ ፍርዱ ተወገደ፤ ሕይወቱ ከምድር ተወግዳለችና ትውልዱንስ ማን ይናገራል? ");
INSERT INTO amh_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ጃንደረባውም ለፊልጶስ መልሶ። እባክህ፥ ነቢዩ ይህን ስለ ማን ይናገራል? ስለ ራሱ ነውን ወይስ ስለ ሌላ? አለው። ");
INSERT INTO amh_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ፊልጶስም አፉን ከፈተ፥ ከዚህም መጽሐፍ ጀምሮ ስለ ኢየሱስ ወንጌልን ሰበከለት። ");
INSERT INTO amh_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","በመንገድም ሲሄዱ ወደ ውኃ ደረሱ፤ ጃንደረባውም። እነሆ ውኃ፤ እንዳልጠመቅ የሚከለክለኝ ምንድር ነው? አለው። ");
INSERT INTO amh_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ፊልጶስም። በፍጹም ልብህ ብታምን፥ ተፈቅዶአል አለው። መልሶም። ኢየሱስ ክርስቶስ የእግዚአብሔር ልጅ እንደ ሆነ አምናለሁ አለ። ");
INSERT INTO amh_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ሰረገላውም ይቆም ዘንድ አዘዘ፥ ፊልጶስና ጃንደረባው ሁለቱም ወደ ውኃ ወረዱ፥ አጠመቀውም። ");
INSERT INTO amh_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ከውኃውም ከወጡ በኋላ የጌታ መንፈስ ፊልጶስን ነጠቀው፤ ጃንደረባውም ሁለተኛ አላየውም፥ ደስ ብሎት መንገዱን ይሄድ ነበርና። ");
INSERT INTO amh_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ፊልጶስ ግን በአዛጦን ተገኘ፥ ወደ ቂሣርያም እስኪመጣ ድረስ እየዞረ በከተማዎች ሁሉ ወንጌልን ይሰብክ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ሳውል ግን የጌታን ደቀ መዛሙርት እንዲገድላቸው ገና እየዛተ ወደ ሊቀ ካህናት ሄደ፥ ");
INSERT INTO amh_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","በዚህ መንገድ ያሉትንም ሰዎች ወንዶችንም ሴቶችንም ቢያገኝ፥ እያሰረ ወደ ኢየሩሳሌም ያመጣቸው ዘንድ በደማስቆ ላሉት ምኵራቦች ደብዳቤ ከእርሱ ለመነ። ");
INSERT INTO amh_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ሲሄድም ወደ ደማስቆ በቀረበ ጊዜ ድንገት በእርሱ ዙሪያ ከሰማይ ብርሃን አንጸባረቀ፤ ");
INSERT INTO amh_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","በምድርም ላይ ወድቆ ሳለ። ሳውል ሳውል፥ ስለ ምን ታሳድደኛለህ? የሚለውን ድምፅ ሰማ። ");
INSERT INTO amh_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ጌታ ሆይ፥ ማን ነህ? አለው። እርሱም። አንተ የምታሳድደኝ እኔ ኢየሱስ ነኝ፤ የመውጊያውን ብረት ብትቃወም ለአንተ ይብስብሃል አለው። ");
INSERT INTO amh_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","እየተንቀጠቀጠና እየተደነቀ። ጌታ ሆይ፥ ምን አደርግ ዘንድ ትወዳለህ? አለው። ጌታም። ተነሥተህ ወደ ከተማ ግባና ታደርገው ዘንድ የሚያስፈልግህን ይነግሩሃል አለው። ");
INSERT INTO amh_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ከእርሱም ጋር በመንገድ የሄዱ ሰዎች ድምፁን እየሰሙ ማንን ግን ሳያዩ እንደ ዲዳዎች ቁሙ። ");
INSERT INTO amh_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ሳውልም ከምድር ተነሣ፥ አይኖቹም በተከፈቱ ጊዜ ምንም አላየም፤ እጁንም ይዘው እየመሩ ወደ ደማስቆ አገቡት። ");
INSERT INTO amh_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ሳያይም ሦስት ቀን ኖረ፤ አልበላምም አልጠጣምም። ");
INSERT INTO amh_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","በደማስቆም ሐናንያ የሚሉት አንድ ደቀ መዝሙር ነበረ፥ ጌታም በራእይ። ሐናንያ ሆይ፥ አለው። እርሱም። ጌታ ሆይ፥ እነሆኝ አለ። ");
INSERT INTO amh_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ጌታም። ተነሥተህ ቅን ወደ ሚባለው መንገድ ሂድ፥ በይሁዳ ቤትም ሳውል የሚሉትን አንድ የጠርሴስ ሰው ፈልግ፤ ");
INSERT INTO amh_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","እነሆ፥ እርሱ ይጸልያልና፤ ሐናንያ የሚሉትም ሰው ገብቶ ደግሞ እንዲያይ እጁን ሲጭንበት አይቶአል አለው። ");
INSERT INTO amh_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ሐናንያም መልሶ። ጌታ ሆይ፥ በኢየሩሳሌም በቅዱሳንህ ላይ ስንት ክፉ እንዳደረገ ስለዚህ ሰው ከብዙዎች ሰምቼአለሁ፤ ");
INSERT INTO amh_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","በዚህም ስምህን የሚጠሩትን ሁሉ ለማሰር ከካህናት አለቆች ሥልጣን አለው አለ። ");
INSERT INTO amh_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ጌታም። ይህ በአሕዛብም በነገሥታትም በእስራኤልም ልጆች ፊት ስሜን ይሸከም ዘንድ ለእኔ የተመረጠ ዕቃ ነውና ሂድ፤ ");
INSERT INTO amh_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ስለ ስሜ ስንት መከራ ሊቀበል እንዲያስፈልገው እኔ አመለክተዋለሁና አለው። ");
INSERT INTO amh_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ሐናንያም ሄዶ ወደ ቤቱ ገባ፥ እጁንም ጭኖበት። ወንድሜ ሳውል ሆይ፥ ጌታ፥ እርሱም በመጣህበት መንገድ የታየህ ኢየሱስ ነው፥ ደግሞ ታይ ዘንድና መንፈስ ቅዱስ ይሞላብህ ዘንድ ላከኝ አለ። ");
INSERT INTO amh_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ወዲያውም እንደ ቅርፊት ያለ ከዓይኑ ወደቀ፥ ያን ጊዜም ደግሞ አየ፤ ተነሥቶም ተጠመቀ፥ ");
INSERT INTO amh_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","መብልም በልቶ በረታ። በደማስቆም ካሉት ደቀ መዛሙርት ጋር ጥቂት ቀን ኖረ። ");
INSERT INTO amh_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ወዲያውም ስለ ኢየሱስ ክርስቶስ እርሱ የእግዚአብሔር ልጅ እንደ ሆነ በምኵራቦቹ ሰበከ። ");
INSERT INTO amh_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","የሰሙትም ሁሉ ተገረሙና። ይህ በኢየሩሳሌም ይህን ስም የሚጠሩትን ያጠፋ አይደለምን? ስለዚህስ ታስረው ወደ ካህናት አለቆች ይወስዳቸው ዘንድ ወደዚህ አልመጣምን? አሉ። ");
INSERT INTO amh_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ሳውል ግን እየበረታ ሄደ፥ በደማስቆም ለተቀመጡት አይሁድ ይህ ክርስቶስ እንደ ሆነ አስረድቶ መልስ ያሳጣቸው ነበር። ");
INSERT INTO amh_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ብዙ ቀንም ሲሞላ አይሁድ ሊገድሉት ተማከሩ፤ ");
INSERT INTO amh_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ሳውል ግን አሳባቸውን አወቀ። ይገድሉትም ዘንድ በሌሊትና በቀን የከተማይቱን በር ሁሉ ይጠቀብቁ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ደቀ መዛሙርት ግን በሌሊት ወስደው በቅጥር ላይ አሳልፈው በቅርጫት አወረዱት። ");
INSERT INTO amh_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ሳውልም ወደ ኢየሩሳሌም በደረሰ ጊዜ ከደቀ መዛሙርት ጋር ይተባበር ዘንድ ሞከረ፤ ሁሉም ደቀ መዝሙር እንደ ሆነ ስላላመኑ ፈሩት። ");
INSERT INTO amh_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","በርናባስ ግን ወስዶ ወደ ሐዋርያት አገባውና ጌታን በመንገድ እንዴት እንዳየውና እንደ ተናገረው በደማስቆም በኢየሱስ ስም ደፍሮ እንዴት እንደ ነገረ ተረከላቸው። ");
INSERT INTO amh_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","በጌታም በኢየሱስ ስም ደፍሮ እየተናገረ በኢየሩሳሌም ሲወጣና ሲገባ ከእነርሱ ጋር ነበረ፤ ");
INSERT INTO amh_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ከግሪክ አገርም መጥተው ከነበሩት አይሁድ ጋር ይነጋገርና ይከራከር ነበር፤ እነርሱ ግን ሊገድሉት ፈለጉ። ");
INSERT INTO amh_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ወንድሞችም ይህን ባወቁ ጊዜ ወደ ቂሣርያ ወሰዱት ወደ ጠርሴስም ሰደዱት። ");
INSERT INTO amh_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","በይሁዳም ሁሉና በገሊላ በሰማርያም የነበሩት አብያተ ክርስቲያናት በሰላም ኖሩ ታነጹም፤ በእግዚአብሔርም ፍርሃትና በመንፈስ ቅዱስ መጽናናት እየሄዱ ይበዙ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ጴጥሮስም በየስፍራው ሁሉ ሲዞር በልዳ ወደሚኖሩ ቅዱሳን ደግሞ ወረደ። ");
INSERT INTO amh_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","በዚያም ከስምንት ዓመት ጀምሮ በአልጋ ላይ ተኝቶ የነበረውን ኤንያ የሚሉትን አንድ ሰው አገኘ፤ እርሱም ሽባ ነበረ። ");
INSERT INTO amh_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ጴጥሮስም። ኤንያ ሆይ፥ ኢየሱስ ክርስቶስ ይፈውስሃል፤ ተነሣ ለራስህም አንጥፍ አለው። ");
INSERT INTO amh_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ወዲያውም ተነሣ። በልዳና በሰሮናም የሚኖሩ ሁሉ እርሱን አይተው ወደ ጌታ ዘወር አሉ። ");
INSERT INTO amh_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","በኢዮጴም ጣቢታ የሚሉአት አንዲት ደቀ መዝሙር ነበረች፥ ትርጓሜውም ዶርቃ ማለት ነው፤ እርስዋም መልካም ነገር የሞላባት ምጽዋትም የምታደርግ ነበረች። ");
INSERT INTO amh_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","በዚያም ወራት ታመመችና ሞተች፤ አጥበውም በሰገነት አኖሩአት። ");
INSERT INTO amh_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ልዳም ለኢዮጴ ቅርብ ናትና ደቀ መዛሙርት ጴጥሮስ በዚያ እንዳለ ሰምተው፥ ወደ እነርሱ ከመምጣት እንዳይዘገይ እየለመኑ ሁለት ሰዎች ወደ እርሱ ላኩ። ");
INSERT INTO amh_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ጴጥሮስም ተነሥቶ ከእነርሱ ጋር መጣ፤ በደረሰም ጊዜ በሰገነት አወጡት መበለቶችም ሁሉ እያለቀሱ ዶርቃ ከእነርሱ ጋር ሳለች ያደረገቻቸውን ቀሚሶችንና ልብሶችን ሁሉ እያሳዩት በፊቱ ቆሙ። ");
INSERT INTO amh_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ጴጥሮስም ሁሉን ወደ ውጭ አስወጥቶ ተንበርክኮም ጸለየ፥ ወደ ሬሳውም ዘወር ብሎ። ጣቢታ ሆይ፥ ተነሺ አላት። እርስዋም ዓይኖችዋን ከፈተች ጴጥሮስንም ባየች ጊዜ ተቀመጠች። ");
INSERT INTO amh_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","እጁንም ለእርስዋ ሰጥቶ አስነሣት፤ ቅዱሳንንና መበለቶችንም ጠራ ሕያውም ሆና በፊታቸው አቆማት። ");
INSERT INTO amh_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ይህም በኢዮጴ ሁሉ የታወቀ ሆነ፥ ብዙ ሰዎችም በጌታ አመኑ። ");
INSERT INTO amh_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","በኢዮጴም ስምዖን ከሚሉት ከአንድ ቍርበት ፋቂ ጋር አያሌ ቀን ኖረ። ");
INSERT INTO amh_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","በቂሣርያም ኢጣሊቄ ለሚሉት ጭፍራ የመቶ አለቃ የሆነ ቆርኔሌዎስ የሚሉት አንድ ሰው ነበረ። ");
INSERT INTO amh_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","እርሱም ከቤተ ሰዎቹ ሁሉ ጋር እግዚአብሔርን የሚያመልክና የሚፈራ ለሕዝብም እጅግ ምጽዋት የሚያደርግ ወደ እግዚአብሔርም ሁልጊዜ የሚጸልይ ነበረ። ");
INSERT INTO amh_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ከቀኑም ዘጠኝ ሰዓት ያህል። ቆርኔሌዎስ ሆይ የሚለው የእግዚአብሔር መልአክ ወደ እርሱ ሲገባ በራእይ በግልጥ አየው። ");
INSERT INTO amh_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","እርሱም ትኵር ብሎ ሲመለከተው ደንግጦ። ጌታ ሆይ፥ ምንድር ነው? አለ። መልአኩም አለው። ጸሎትህና ምጽዋትህ በእግዚአብሔር ፊት ለመታሰቢያ እንዲሆን አረገ። ");
INSERT INTO amh_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","አሁንም ወደ ኢዮጴ ሰዎችን ልከህ ጴጥሮስ የሚባለውን ስምዖንን አስመጣ። ");
INSERT INTO amh_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","እርሱ ቤቱ በባሕር አጠገብ ባለው በቍርበት ፋቂው በስምዖን ዘንድ እንግድነት ተቀምጦአል፤ ልታደርገው የሚገባህን እርሱ ይነግርሃል። ");
INSERT INTO amh_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","የተናገረውም መልአክ በሄደ ጊዜ፥ ከሎሎዎቹ ሁለቱን፥ ከማይለዩትም ጭፍሮቹ እግዚአብሔርን የሚያመልክ አንዱን ወታደር ጠርቶ፥ ");
INSERT INTO amh_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ነገሩን ሁሉ ተረከላቸው ወደ ኢዮጴም ላካቸው። ");
INSERT INTO amh_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","እነርሱም በነገው ሲሄዱ ወደ ከተማም ሲቀርቡ፥ ጴጥሮስ በስድስት ሰዓት ያህል ይጸልይ ዘንድ ወደ ጣራው ወጣ። ");
INSERT INTO amh_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ተርቦም ሊበላ ወደደ፤ ሲያዘጋጁለት ሳሉም ተመስጦ መጣበት፤ ");
INSERT INTO amh_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ሰማይም ተከፍቶ በአራት ማዕዘን የተያዘ ታላቅ ሸማ የሚመስል ዕቃ ወደ ምድር ሲወርድ አየ፤ ");
INSERT INTO amh_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","በዚያውም አራት እግር ያላቸው ሁሉ አራዊትም በምድርም የሚንቀሳቀሱት የሰማይ ወፎችም ነበሩበት። ");
INSERT INTO amh_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ጴጥሮስ ሆይ፥ ተነሣና አርደህ ብላ የሚልም ድምፅ ወደ እርሱ መጣ። ");
INSERT INTO amh_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ጴጥሮስ ግን። ጌታ ሆይ፥ አይሆንም፤ አንዳች ርኵስ የሚያስጸይፍም ከቶ በልቼ አላውቅምና አለ። ");
INSERT INTO amh_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ደግሞም ሁለተኛ። እግዚአብሔር ያነጻውን አንተ አታርክሰው የሚል ድምፅ ወደ እርሱ መጣ። ");
INSERT INTO amh_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ይህም ሦስት ጊዜ ሆነ፥ ወዲያውም ዕቃው ወደ ሰማይ ተወሰደ። ");
INSERT INTO amh_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ጴጥሮስም ስላየው ራእይ። ምን ይሆን? ብሎ በልቡ ሲያመነታ፥ እነሆ፥ ቆርኔሌዎስ የላካቸው ሰዎች ስለ ስምዖን ቤት ጠይቀው ወደ ደጁ ቀረቡ፤ ");
INSERT INTO amh_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ድምፃቸውንም ከፍ አድርገው። ጴጥሮስ የተባለው ስምዖን በዚህ እንግድነት ተቀምጦአልን? ብለው ይጠይቁ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ጴጥሮስም ስለ ራእዩ ሲያወጣ ሲያወርድ ሳለ፥ መንፈስ። እነሆ፥ ሦስት ሰዎች ይፈልጉሃል፤ ");
INSERT INTO amh_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ተነሥተህ ውረድ፥ እኔም ልኬአቸዋለሁና ሳትጠራጠር ከእነርሱ ጋር ሂድ አለው። ");
INSERT INTO amh_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ጴጥሮስም ወደ ሰዎቹ ወርዶ። እነሆ፥ የምትፈልጉኝ እኔ ነኝ፤ የመጣችሁበትስ ምክንያት ምንድር ነው? አላቸው። ");
INSERT INTO amh_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","እነርሱም። ጻድቅ ሰው እግዚአብሔርንም የሚፈራ በአይሁድም ሕዝብ ሁሉ የተመሰከረለት የመቶ አለቃ ቆርኔሌዎስ ወደ ቤቱ ያስመጣህ ዘንድ ከአንተም ቃልን ይሰማ ዘንድ ከቅዱስ መልአክ ተረዳ አሉት። ");
INSERT INTO amh_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","እርሱም ወደ ውስጥ ጠርቶ እንድግድነት ተቀበላቸው። በነገውም ተነሥቶ ከእነርሱ ጋር ወጣ፥ በኢዮጴም ከነበሩት ወንድሞች አንዳንዶቹ ከእርሱ ጋር አብረው ሄዱ። ");
INSERT INTO amh_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","በነገውም ወደ ቂሣርያ ገቡ፤ ቆርኔሌዎስም ዘመዶቹንና የቅርብ ወዳጆቹን በአንድነት ጠርቶ ይጠባበቃቸው ነበር። ");
INSERT INTO amh_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ጴጥሮስም በገባ ጊዜ ቆርኔሌዎስ ተገናኝቶ ከእግሩ በታች ወደቀና ሰገደለት። ");
INSERT INTO amh_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ጴጥሮስ ግን። ተነሣ፤ እኔ ራሴ ደግሞ ሰው ነኝ ብሎ አስነሣው። ");
INSERT INTO amh_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ከእርሱም ጋር እየተነጋገረ ገባ፥ ብዙዎችም ተከማችተው አግኝቶ። ");
INSERT INTO amh_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","አይሁዳዊ ሰው ከሌላ ወገን ጋር ይተባበር ወይም ይቃረብ ዘንድ እንዳልተፈቀደ እናንተ ታውቃላችሁ፤ ለእኔ ግን እግዚአብሔር ማንንም ሰው ርኵስና የሚያስጸይፍ ነው እንዳልል አሳየኝ፤ ");
INSERT INTO amh_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ስለዚህም ደግሞ ብትጠሩኝ ሳልከራከር መጣሁ። አሁንም በምን ምክንያት አስመጣችሁኝ? ብዬ እጠይቃችኋለሁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ቆርኔሌዎስም እንዲህ አለው። በዚች ሰዓት የዛሬ አራት ቀን የዘጠኝ ሰዓት ጸሎት በቤቴ እጸልይ ነበር፤ እነሆም፥ የሚያንጸባርቅ ልብስ የለበሰ ሰው በፊቴ ቆመና። ");
INSERT INTO amh_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ቆርኔሌዎስ ሆይ፥ በእግዚአብሔር ፊት ጸሎትህ ተሰማ ምጽዋትህም ታሰበ። ");
INSERT INTO amh_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","እንግዲህ ወደ ኢዮጴ ልከህ ጴጥሮስ የተባለውን ስምዖንን አስጠራ፤ እርሱ በቍርበት ፋቂው በስምዖን ቤት በባሕር አጠገብ እንግድነት ተቀምጦአል አለኝ። ");
INSERT INTO amh_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ስለዚህ ያን ጊዜ ወደ አንተ ላክሁ፥ አንተም በመምጣትህ መልካም አድርገሃል። እንግዲህ አንተ ከእግዚአብሔር ዘንድ የታዘዝኸውን ሁሉ እንድንሰማ እኛ ሁላችን አሁን በእግዚአብሔር ፊት በዚህ አለን። ");
INSERT INTO amh_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","36","የሁሉ ጌታ በሚሆን በኢየሱስ ክርስቶስ ሰላምን እየሰበከ ይህን ቃል ወደ እስራኤል ልጆች ላከ። ");
INSERT INTO amh_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ዮሐንስ ከሰበከው ጥምቀት በኋላ ከገሊላ ጀምሮ በይሁዳ ሁሉ የሆነውን ነገር እናንተ ታውቃላችሁ። ");
INSERT INTO amh_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","እግዚአብሔር የናዝሬቱን ኢየሱስን በመንፈስ ቅዱስ በኃይልም ቀባው፥ እርሱም መልካም እያደረገ ለዲያብሎስም የተገዙትን ሁሉ እየፈወሰ ዞረ፥ እግዚአብሔር ከእርሱ ጋር ነበረና፤ ");
INSERT INTO amh_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","እኛም በአይሁድ አገርና በኢየሩሳሌም ባደረገው ነገር ሁሉ ምስክሮች ነን፤ እርሱንም በእንጨት ላይ ሰቅለው ገደሉት። ");
INSERT INTO amh_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","እርሱን እግዚአብሔር በሦስተኛው ቀን አስነሣው ይገለጥም ዘንድ ሰጠው፤ ");
INSERT INTO amh_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ይኸውም ለሕዝብ ሁሉ አይደለም ነገር ግን በእግዚአብሔር አስቀድሞ የተመረጡ ምስክሮች ለሆንን ለእኛ ነው እንጂ፤ ከሙታንም ከተነሣ በኋላ ከእርሱ ጋር የበላን የጠጣንም እኛ ነን። ");
INSERT INTO amh_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ለሕዝብም እንድንሰብክና በሕያዋንና በሙታን ሊፈርድ በእግዚአብሔር የተወሰነ እርሱ እንደ ሆነ እንመሰክር ዘንድ አዘዘን። ");
INSERT INTO amh_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","በእርሱ የሚያምን ሁሉ በስሙ የኃጢአቱን ስርየት እንዲቀበል ነቢያት ሁሉ ይመሰክሩለታል። ");
INSERT INTO amh_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ጴጥሮስ ይህን ነገር ገና ሲናገር ቃሉን በሰሙት ሁሉ ላይ መንፈስ ቅዱስ ወረደ። ");
INSERT INTO amh_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ከጴጥሮስም ጋር የመጡት ሁሉ ከተገረዙት ወገን የሆኑ ምዕመናን በአሕዛብ ላይ ደግሞ የመንፈስ ቅዱስ ስጦታ ስለ ፈሰሰ ተገረሙ፤ ");
INSERT INTO amh_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","በልሳኖች ሲናገሩ እግዚአብሔርንም ሲያከብሩ ሰምተዋቸዋልና። ");
INSERT INTO amh_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","በዚያን ጊዜ ጴጥሮስ መልሶ። እነዚህ እንደ እኛ ደግሞ መንፈስ ቅዱስን የተቀበሉ እንዳይጠመቁ ውኃን ይከለክላቸው ዘንድ የሚችል ማን ነው? አለ። ");
INSERT INTO amh_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","በኢየሱስ ክርስቶስ ስምም ይጠመቁ ዘንድ አዘዛቸው። ከዚህ በኋላ ጥቂት ቀን እንዲቀመጥ ለመኑት። ");
INSERT INTO amh_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ሐዋርያትና በይሁዳም የነበሩት ወንድሞች አሕዛብ ደግሞ የእግዚአብሔርን ቃል እንደ ተቀበሉ ሰሙ። ");
INSERT INTO amh_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ጴጥሮስም ወደ ኢየሩሳሌም በወጣ ጊዜ ከተገረዙት ወገን የሆኑት ሰዎች ከእርሱ ጋር ተከራክረው። ");
INSERT INTO amh_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ወዳልተገረዙ ሰዎች ገብተህ ከእነርሱ ጋር በላህ አሉት። ");
INSERT INTO amh_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ጴጥሮስ ግን ከመጀመሪያው ጀምሮ በተራ ገለጠላቸው እንዲህም አለ። ");
INSERT INTO amh_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","እኔ በኢዮጴ ከተማ ስጸልይ ሳለሁ ተመስጬ ራእይን አየሁ፤ ታላቅ ሸማ የመሰለ ዕቃ በአራት ማዕዘን ተይዞ ከሰማይ ወረደና ወደ እኔ መጣ፤ ");
INSERT INTO amh_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ይህንም ትኵር ብዬ ስመለከት አራት እግር ያላቸውን የምድር እንስሶች አራዊትንም ተንቀሳቃሾችንም የሰማይ ወፎችንም አየሁ። ");
INSERT INTO amh_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ጴጥሮስ ሆይ፥ ተነሣና አርደህ ብላ የሚለኝንም ድምፅ ሰማሁ። ");
INSERT INTO amh_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","እኔም። ጌታ ሆይ፥ አይሆንም፤ ርኵስ ወይም የሚያስጸይፍ ከቶ ወደ አፌ ገብቶ አያውቅምና አልሁ። ");
INSERT INTO amh_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ሁለተኛም። እግዚአብሔር ያነጻውን አንተ አታርክሰው የሚል ድምፅ ከሰማይ መለሰልኝ። ");
INSERT INTO amh_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ይህም ሦስት ጊዜ ሆነ እንደ ገናም ሁሉ ወደ ሰማይ ተሳበ። ");
INSERT INTO amh_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","እነሆም፥ ያን ጊዜ ሦስት ሰዎች ከቂሣርያ ወደ እኔ ተልከው ወዳለሁበት ቤት ቀረቡ። ");
INSERT INTO amh_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","መንፈስም ሳልጠራጠር ከእነርሱ ጋር እሄድ ዘንድ ነገረኝ። እነዚህም ስድስቱ ወንድሞች ደግሞ ከእኔ ጋር መጡ ወደዚያ ሰውም ቤት ገባን። ");
INSERT INTO amh_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","እርሱም መልአክ በቤቱ ቆሞ እንዳየና። ወደ ኢዮጴ ሰዎች ልከህ ጴጥሮስ የተባለውን ስምዖንን አስመጣ፤ ");
INSERT INTO amh_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","እርሱም አንተና የቤትህ ሰዎች ሁሉ የምትድኑበትን ነገር ይነግርሃል እንዳለው ነገረን። ");
INSERT INTO amh_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ለመናገርም በጀመርሁ ጊዜ መንፈስ ቅዱስ ለእኛ ደግሞ በመጀመሪያ እንደ ወረደ ለእነርሱ ወረደላቸው። ");
INSERT INTO amh_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ዮሐንስ በውኃ አጠመቀ እናንተ ግን በመንፈስ ቅዱስ ትጠመቃላችሁ ያለውም የጌታ ቃል ትዝ አለኝ። ");
INSERT INTO amh_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","እንግዲህ እግዚአብሔር በጌታ በኢየሱስ ክርስቶስ ላመነው ለእኛ ደግሞ እንደ ሰጠን ያን ስጦታ ለእነርሱ ከሰጠ፥ እግዚአብሔርን ለመከልከል እችል ዘንድ እኔ ማን ነበርሁ? ");
INSERT INTO amh_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ይህን በሰሙ ጊዜም ዝም አሉና። እንኪያስ እግዚአብሔር ለአሕዛብ ደግሞ ለሕይወት የሚሆን ንስሐን ሰጣቸው እያሉ እግዚአብሔርን አከበሩ። ");
INSERT INTO amh_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","በእስጢፋኖስም ላይ በተደረገው መከራ የተበተኑት እስከ ፊንቄ እስከ ቆጵሮስም እስከ አንጾኪያም ድረስ ዞሩ፥ ቃሉንም ለአይሁድ ብቻ እንጂ ለአንድ ስንኳ አይናገሩም ነበር። ");
INSERT INTO amh_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ከእነርሱ ግን የቆጵሮስና የቀሬና ሰዎች የነበሩት አንዳንዶቹ ወደ አንጾኪያ መጥተው የጌታን የኢየሱስን ወንጌል እየሰበኩ ለግሪክ ሰዎች ተናገሩ። ");
INSERT INTO amh_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","የጌታም እጅ ከእነርሱ ጋር ነበረ፤ ቍጥራቸውም እጅግ የሚሆን ሰዎች አምነው ወደ ጌታ ዘወር አሉ። ");
INSERT INTO amh_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ወሬውም በኢየሩሳሌም ባለችው ቤተ ክርስቲያን ስለ እነርሱ ተሰማ፥ በርናባስንም ወደ አንጾኪያ ላኩት፤ ");
INSERT INTO amh_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","እርሱም መጥቶ የእግዚአብሔርን ጸጋ ባየ ጊዜ ደስ አለው፥ ሁሉንም በልባቸው ፈቃድ በጌታ ጸንተው ይኖሩ ዘንድ መከራቸው፤ ");
INSERT INTO amh_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ደግ ሰውና መንፈስ ቅዱስ እምነትም የሞላበት ነበረና። ብዙ ሕዝብም ወደ ጌታ ተጨመሩ። ");
INSERT INTO amh_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","በርናባስም ሳውልን ሊፈልግ ወደ ጠርሴስ መጣ፤ ");
INSERT INTO amh_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ባገኘውም ጊዜ ወደ አንጾኪያ አመጣው። በቤተ ክርስቲያንም አንድ ዓመት ሙሉ ተሰበሰቡ፥ ብዙ ሕዝብንም አስተማሩ፤ ደቀ መዛሙርትም መጀመሪያ በአንጾኪያ ክርስቲያን ተባሉ። ");
INSERT INTO amh_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","በዚያም ወራት ነቢያት ከኢየሩሳሌም ወደ አንጾኪያ ወረዱ፤ ");
INSERT INTO amh_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ከእነርሱም አጋቦስ የሚሉት አንድ ሰው ተነሥቶ በዓለም ሁሉ ታላቅ ራብ ሊሆን እንዳለው በመንፈስ አመለከተ፤ ይህም በቀላውዴዎስ ቄሣር ዘመን ሆነ። ");
INSERT INTO amh_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ደቀ መዛሙርትም እያንዳንዳቸው እንደ ችሎታቸው መጠን አዋጥተው በይሁዳ ለሚኖሩት ወንድሞች እርዳታን ይልኩ ዘንድ ወሰኑ፤ ");
INSERT INTO amh_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","እንዲህም ደግሞ አደረጉ፥ በበርናባስና በሳውልም እጅ ወደ ሽማግሌዎቹ ሰደዱት። ");
INSERT INTO amh_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","በዚያም ዘመን ንጉሡ ሄሮድስ መከራ ያጸናባቸው ዘንድ ከቤተ ክርስቲያኑ በአንዳንዶቹ ላይ እጁን ጫነባቸው። ");
INSERT INTO amh_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","የዮሐንስንም ወንድም ያዕቆብን በሰይፍ ገደለው። ");
INSERT INTO amh_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","አይሁድንም ደስ እንዳሰኛቸው አይቶ ጨምሮ ጴጥሮስን ደግሞ ያዘው። የቂጣ በዓልም ወራት ነበረ። ");
INSERT INTO amh_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","በያዘውም ጊዜ ወደ ወኅኒ አገባው ከፋሲካም በኋላ ወደ ሕዝብ ያወጣው ዘንድ አስቦ እያንዳንዱ አራት ወታደሮች ሆነው እንዲጠብቁት ለአራት ጭፍራ ክፍል አሳልፎ ሰጠው። ");
INSERT INTO amh_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ጴጥሮስም በወኅኒ ይጠበቅ ነበር፤ ነገር ግን በቤተ ክርስቲያን ስለ እርሱ ወደ እግዚአብሔር ጸሎት አጥብቆ ይደረግ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ሄሮድስም ሊያወጣው ባሰበ ጊዜ፥ በዚያች ሌሊት ጴጥሮስ በሁለት ሰንሰለት ታስሮ ከሁለት ወታደሮች መካከል ተኝቶ ነበር፤ ጠባቂዎችም በደጁ ፊት ሆነው ወኅኒውን ይጠብቁ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","እነሆም፥ የጌታ መልአክ ቀረበ በቤትም ውስጥ ብርሃን በራ፤ ጴጥሮስንም ጎድኑን መትቶ አነቃውና። ፈጥነህ ተነሣ አለው። ሰንሰለቶቹም ከእጁ ወደቁ። ");
INSERT INTO amh_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","መልአኩም። ታጠቅና ጫማህን አግባ አለው፥ እንዲሁም አደረገ። ");
INSERT INTO amh_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ልብስህንም ልበስና ተከተለኝ አለው። ወጥቶም ተከተለው፤ ራእይንም የሚያይ ይመስለው ነበር እንጂ በመልአኩ የሚደረገው ነገር እውነት እንደ ሆነ አላወቀም። ");
INSERT INTO amh_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","የመጀመሪያውንና የሁለተኛውንም ዘብ አልፈው ወደ ከተማ ወደሚያወጣው ወደ ብረቱ መዝጊያ ደረሱ፤ እርሱም አውቆ ተከፈተላቸው፤ ወጥተውም አንዲት ስላች አለፉ ወዲያውም መልአኩ ከእርሱ ተለየ። ");
INSERT INTO amh_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ጴጥሮስም ወደ ልቡ ተመልሶ። ጌታ መልአኩን ልኮ ከሄሮድስ እጅና የአይሁድ ሕዝብ ይጠብቁት ከነበረው ሁሉ እንደ አዳነኝ አሁን በእውነት አወቅሁ አለ። ");
INSERT INTO amh_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ባስተዋለም ጊዜ እጅግ ሰዎች ተከማችተው ይጸልዩበት ወደ ነበረው ማርቆስ ወደ ተባለው ወደ ዮሐንስ እናት ወደ ማርያም ቤት መጣ። ");
INSERT INTO amh_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ጴጥሮስም የደጁን መዝጊያ ባንኳኳ ጊዜ ሮዴ የሚሉአት አንዲት ገረድ ትሰማ ዘንድ ቀረበች፤ ");
INSERT INTO amh_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","የጴጥሮስ ድምፅ መሆኑንም ባወቀች ጊዜ ከደስታዋ የተነሣ ደጁን አልከፈተችም፥ ነገር ግን ወደ ውስጥ ሮጣ ጴጥሮስ በደጅ ፊት ቆሞ እንዳለ አወራች። ");
INSERT INTO amh_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","እነርሱም። አብደሻል አሉአት። እርስዋ ግን እንዲሁ እንደ ሆነ ታስረግጥ ነበር። እነርሱም። መልአኩ ነው አሉ። ");
INSERT INTO amh_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ጴጥሮስ ግን ማንኳኳቱን አዘወተረ፤ ከፍተውም አዩትና ተገረሙ። ");
INSERT INTO amh_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ግን ዝም እንዲሉ በእጁ ጠቅሶ ጌታ ከወኅኒ እንዴት እንዳወጣው ተረከላቸውና። ይህን ለያዕቆብና ለወንድሞች ንገሩ አላቸው። ወጥቶም ወደ ሌላ ስፍራ ሄደ። ");
INSERT INTO amh_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","በነጋም ጊዜ። ጴጥሮስን ምን አግኝቶት ይሆን? ብለው በጭፍሮች ዘንድ ብዙ ሁከት ሆነ። ");
INSERT INTO amh_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ሄሮድስም አስፈልጎ ባጣው ጊዜ ጠባቂዎችን መረመረ ይገድሉአቸውም ዘንድ አዘዘ፤ ከይሁዳም ወደ ቂሣርያ ወርዶ በዚያ ተቀመጠ። ");
INSERT INTO amh_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ከጢሮስና ከሲዶና ሰዎችም ጋር ተጣልቶ ነበር፤ በአንድ ልብ ሆነውም ወደ እርሱ መጡ፥ የንጉሥንም ቢትወደድ ብላስጦስን እሺ አሰኝተው ዕርቅ ለመኑ፥ አገራቸው ከንጉሥ አገር ምግብ ያገኝ ነበረና። ");
INSERT INTO amh_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","በተቀጠረ ቀንም ሄሮድስ ልብሰ መንግሥቱን ለብሶ በዙፋን ተቀመጠ እነርሱንም ተናገራቸው፤ ");
INSERT INTO amh_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ሕዝቡም። የእግዚአብሔር ድምፅ ነው የሰውም አይደለም ብለው ጮኹ። ");
INSERT INTO amh_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ለእግዚአብሔርም ክብር ስላልሰጠ ያን ጊዜ የጌታ መልአክ መታው በትልም ተበልቶ ሞተ። ");
INSERT INTO amh_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","የእግዚአብሔር ቃል ግን ያድግና ይበዛ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","በርናባስና ሳውልም አገልግሎታቸውን ፈጽመው ከኢየሩሳሌም ተመለሱ፥ ማርቆስ የተባለውን ዮሐንስንም ከእነርሱ ጋር ይዘውት መጡ። ");
INSERT INTO amh_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","በአንጾኪያም ባለችው ቤተ ክርስቲያን ነቢያትና መምህራን ነበሩ፤ እነርሱም በርናባስ፥ ኔጌር የተባለው ስምዖንም፥ የቀሬናው ሉክዮስም፥ የአራተኛው ክፍል ገዥ የሄሮድስም ባለምዋል ምናሔ፥ ሳውልም ነበሩ። ");
INSERT INTO amh_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","እነዚህም ጌታን ሲያመልኩና ሲጦሙ መንፈስ ቅዱስ። በርናባስንና ሳውልን ለጠራኋቸው ሥራ ለዩልኝ አለ። ");
INSERT INTO amh_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","በዚያን ጊዜም ከጦሙ ከጸለዩም እጃቸውንም ከጫኑ በኋላ አሰናበቱአቸው። ");
INSERT INTO amh_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","እነርሱም በመንፈስ ቅዱስ ተልከው ወደ ሴሌውቅያ ወረዱ፤ ከዚያም በመርከብ ወደ ቆጵሮስ ሄዱ። ");
INSERT INTO amh_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","በስልማናም በነበሩ ጊዜ በአይሁድ ምኵራቦች የእግዚአብሔርን ቃል ሰበኩ፤ አገልጋይም ዮሐንስ ነበራቸው። ");
INSERT INTO amh_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ደሴቲቱንም ሁሉ እስከ ጳፉ በዞሩ ጊዜ፥ በርያሱስ የሚሉትን ጠንቋይና ሐሰተኛ ነቢይ የሆነውን አንድ አይሁዳዊ ሰው አገኙ፤ ");
INSERT INTO amh_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","እርሱም አስተዋይ ሰው ከሆነው ሰርግዮስ ጳውሎስ ከሚባለው አገረ ገዥ ጋር ነበረ። ይህም በርናባስንና ሳውልን ወደ እርሱ ጠርቶ የእግዚአብሔርን ቃል ሊሰማ ፈለገ። ");
INSERT INTO amh_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ጠንቋዩ ግን ኤልማስ፥ ስሙ እንዲሁ ይተረጐማልና፥ አገረ ገዡን ከማመን ሊያጣምም ፈልጎ ተቃወማቸው። ");
INSERT INTO amh_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ጳውሎስ የተባለው ሳውል ግን መንፈስ ቅዱስን ተሞልቶ ትኵር ብሎ ሲመለከተው። ");
INSERT INTO amh_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","አንተ ተንኰል ሁሉ ክፋትም ሁሉ የሞላብህ፥ የዲያብሎስ ልጅ፥ የጽድቅም ሁሉ ጠላት፥ የቀናውን የጌታን መንገድ ከማጣመም አታርፍምን? ");
INSERT INTO amh_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","አሁንም፥ እነሆ፥ የጌታ እጅ በአንተ ላይ ናት፥ ዕውርም ትሆናለህ እስከ ጊዜውም ፀሐይን አታይም አለው። ያን ጊዜም ጭጋግና ጨለማ ወደቀበት፥ በእጁም የሚመራውን እየዞረ ፈለገ። ");
INSERT INTO amh_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","በዚያን ጊዜ አገረ ገዡ የተደረገውን ባየ ጊዜ ከጌታ ትምህርት የተነሣ ተገርሞ አመነ። ");
INSERT INTO amh_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ጳውሎስም ከጓደኞቹ ጋር ከጳፉ ተነሥቶ የጵንፍልያ ወደምትሆን ወደ ጴርጌን መጣ፤ ዮሐንስም ከእነርሱ ተለይቶ ወደ ኢየሩሳሌም ተመለሰ። ");
INSERT INTO amh_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","እነርሱ ግን ከጴርጌን አልፈው የጲስድያ ወደምትሆን ወደ አንጾኪያ ደረሱ፤ በሰንበትም ቀን ወደ ምኵራብ ገብተው ተቀመጡ። ");
INSERT INTO amh_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ሕግና ነቢያትም ከተነበቡ በኋላ የምኵራቡ አለቆች። ወንድሞች ሆይ፥ ሕዝብን የሚመክር ቃል እንዳላችሁ ተናገሩ ብለው ላኩባቸው። ");
INSERT INTO amh_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ጳውሎስም ተነሣና በእጁ ጠቅሶ እንዲህ አለ። የእስራኤል ሰዎችና እግዚአብሔርን የምትፈሩት ሆይ፥ ስሙ። ");
INSERT INTO amh_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","የዚህ የእስራኤል ሕዝብ አምላክ አባቶቻችንን መርጦ በግብፅ አገር በእንግድነት ሳሉ ሕዝቡን ከፍ ከፍ አደረጋቸው፥ ከፍ ባለችውም ክንዱ ከዚያ አወጣቸው። ");
INSERT INTO amh_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","በበረሀም አርባ ዓመት ያህል መገባቸው። ");
INSERT INTO amh_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","በከነዓንም አገር ሰባት አሕዛብን አጥፍቶ ምድራቸውን አወረሳቸው። ");
INSERT INTO amh_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ከዚህም በኋላ እስከ ነቢዩ እስከ ሳሙኤል ድረስ አራት መቶ አምሳ ዓመት ያህል መሳፍንትን ሰጣቸው። ");
INSERT INTO amh_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ከዚያም ወዲያ ንጉሥን ያነግሥላቸው ዘንድ ለመኑ፥ እግዚአብሔርም ከብንያም ወገን የሚሆን ሰው የቂስን ልጅ ሳኦልን አርባ ዓመት ሰጣቸው፤ ");
INSERT INTO amh_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","እርሱንም ከሻረው በኋላ ዳዊትን በእነርሱ ላይ እንዲነግሥ አስነሣው፥ ሲመሰክርለትም። እንደ ልቤ የሆነ ሰው ፈቃዴንም ሁሉ የሚያደርግ የእሴይን ልጅ ዳዊትን አገኘሁ አለ። ");
INSERT INTO amh_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ከዚህም ሰው ዘር እግዚአብሔር እንደ ተስፋው ቃል ለእስራኤል መድኃኒትን እርሱም ኢየሱስን አመጣ። ");
INSERT INTO amh_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ከመምጣቱ በፊት ዮሐንስ አስቀድሞ ለእስራኤል ሕዝብ ሁሉ የንስሐን ጥምቀት ሰብኮ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ዮሐንስም ሩጫውን ሲፈጽም ሳለ። እኔ ማን እንደ ሆንሁ ታስባላችሁ? እኔስ እርሱን አይደለሁም፤ ነገር ግን እነሆ፥ የእግሩን ጫማ እፈታ ዘንድ ከማይገባኝ ከእኔ በኋላ ይመጣል ይል ነበር። ");
INSERT INTO amh_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","እናንተ ወንድሞቻችን፥ የአብርሃም ዘር ልጆች ከእናንተ መካከልም እግዚአብሔርን የምትፈሩ ሆይ፥ ለእናንተ የዚህ የመዳን ቃል ተላከ። ");
INSERT INTO amh_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","በኢየሩሳሌም የሚኖሩ ሰዎችና አለቆቻቸው እርሱንና በየሰንበቱ የሚነበቡትን የነቢያትን ድምፆች ስላላወቁ በፍርዳቸው ፈጽመዋልና፤ ");
INSERT INTO amh_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ለሞትም የሚያደርስ ምክንያት አንድ ስንኳ ባያገኙበት፥ ይገድለው ዘንድ ጲላጦስን ለመኑት፤ ");
INSERT INTO amh_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ስለ እርሱም የተጻፈውን ሁሉ በፈጸሙ ጊዜ ከእንጨት አውርደው በመቃብር አኖሩት። ");
INSERT INTO amh_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","እግዚአብሔር ግን ከሙታን አስነሣው፤ ");
INSERT INTO amh_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","በሕዝብም ዘንድ ምስክሮቹ ለሆኑት ከእርሱ ጋር ከገሊላ ወደ ኢየሩሳሌም ለወጡት ብዙ ቀን ታያቸው። ");
INSERT INTO amh_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","እኛም ለአባቶች የተሰጠውን ተስፋ የምስራቹን ለእናንተ እንሰብካለን፤ ");
INSERT INTO amh_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ይህን ተስፋ እግዚአብሔር በሁለተኛው መዝሙር ደግሞ። አንተ ልጄ ነህ እኔ ዛሬ ወለድሁህ ተብሎ እንደ ተጻፈ፥ ኢየሱስን አስነሥቶ ለእኛ ለልጆቻቸው ፈጽሞአልና። ");
INSERT INTO amh_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","እንደገናም ወደ መበስበስ እንዳይመለስ ከሙታን እንደ አስነሣው፥ እንዲህ። የታመነውን የዳዊትን ቅዱስ ተስፋ እሰጣችኋለሁ ብሎአል። ");
INSERT INTO amh_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ደግሞ በሌላ ስፍራ። ቅዱስህን መበስበስን ያይ ዘንድ አትሰጠውም ይላልና። ");
INSERT INTO amh_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ዳዊትም በራሱ ዘመን የእግዚአብሔርን አሳብ ካገለገለ በኋላ አንቀላፋ፥ ከአባቶቹም ጋር ተጨምሮ መበስበስን አየ፤ ");
INSERT INTO amh_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ይህ እግዚአብሔር ያስነሣው ግን መበስበስን አላየም። ");
INSERT INTO amh_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","42","በወጡም ጊዜ ይህን ነገር በሚመጣው ሰንበት ይነግሩአቸው ዘንድ ለመኑአቸው። ");
INSERT INTO amh_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ጉባኤውም ከተፈታ በኋላ ከአይሁድና ወደ ይሁዲነት ገብተው ከሚያመልኩ ብዙዎች ጳውሎስንና በርናባስን ተከተሉአቸው፥ እነርሱም ሲነግሩአቸው በእግዚአብሔር ጸጋ ጸንተው እንዲኖሩ አስረዱአቸው። ");
INSERT INTO amh_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","በሁለተኛውም ሰንበት ከጥቂቶቹ በቀር የከተማው ሰው ሁሉ የእግዚአብሔርን ቃል ይሰሙ ዘንድ ተሰበሰቡ። ");
INSERT INTO amh_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","አይሁድም ብዙ ሕዝብ ባዩ ጊዜ ቅንዓት ሞላባቸው፥ እየተሳደቡም ጳውሎስ የተናገረውን ቃል ተቃወሙ። ");
INSERT INTO amh_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ጳውሎስና በርናባስም ገልጠው። የእግዚአብሔር ቃል አስቀድሞ ለእናንተ ይነገር ዘንድ ያስፈልጋል፤ ከገፋችሁትና የዘላለም ሕይወት እንዳይገባችሁ በራሳችሁ ከፈረዳችሁ ግን፥ እነሆ፥ ወደ አሕዛብ ዘወር እንላለን። ");
INSERT INTO amh_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","እንዲሁ ጌታ። እስከ ምድር ዳርቻ ድረስ ለማዳን ትሆን ዘንድ ለአሕዛብ ብርሃን አድርጌሃለሁ ብሎ አዞናልና አሉ። ");
INSERT INTO amh_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","አሕዛብም ሰምተው ደስ አላቸው የእግዚአብሔርንም ቃል አከበሩ፥ ለዘላለም ሕይወትም የተዘጋጁ ሁሉ አመኑ፤ ");
INSERT INTO amh_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","የጌታም ቃል በአገሩ ሁሉ ተስፋፋ። ");
INSERT INTO amh_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","አይሁድ ግን የሚያመልኩትን የከበሩትንም ሴቶችና የከተማውን መኳንንት አወኩ፥ በጳውሎስና በበርናባስም ላይ ስደትን አስነሥተው ከአገራቸው አወጡአቸው። ");
INSERT INTO amh_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","እነርሱ ግን የእግራቸውን ትቢያ አራግፈውባቸው ወደ ኢቆንዮን መጡ። ");
INSERT INTO amh_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","በደቀ መዛሙርትም ደስታና መንፈስ ቅዱስ ሞላባቸው። ");
INSERT INTO amh_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","በኢቆንዮንም እንደ ቀድሞ ወደ አይሁድ ምኵራብ ገብተው ከአይሁድና ከግሪክ ሰዎች ብዙ እስኪያምኑ ድረስ ተናገሩ። ");
INSERT INTO amh_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ያላመኑት አይሁድ ግን የአሕዛብን ልብ በወንድሞች ላይ አነሣሡ አስከፉም። ");
INSERT INTO amh_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ምልክትና ድንቅ በእጃቸው ይደረግ ዘንድ እየሰጠ ለጸጋው ቃል ስለ መሰከረው ስለ ጌታ ገልጠው እየተናገሩ ረጅም ወራት ተቀመጡ። ");
INSERT INTO amh_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","የከተማውም ሕዝብ ተከፍለው እኵሌቶቹ ከአይሁድ እኵሌቶቹም ከሐዋርያት ጋር ሆኑ። ");
INSERT INTO amh_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","አሕዛብና አይሁድ ግን ከአለቆቻቸው ጋር ሊያንገላቱአቸውና ሊወግሩአቸው ባሰቡ ጊዜ፥ ");
INSERT INTO amh_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","አውቀው ልስጥራንና ደርቤን ወደሚባሉት ወደ ሊቃኦንያ ከተማዎች በእነርሱም ዙሪያ ወዳለው አገር ሸሹ፤ ");
INSERT INTO amh_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","በዚያም ወንጌልን ይሰብኩ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","በልስጥራንም እግሩ የሰለለ፥ ከእናቱም ማኅፀን ጀምሮ አንካሳ የሆነ፥ ከቶም ሄዶ የማያውቅ አንድ ሰው ተቀምጦ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ይህም ሰው ጳውሎስ ሲናገር ይሰማ ነበር፤ እርሱም ትኵር ብሎ ተመለከተውና ይድን ዘንድ እምነት እንዳለው ባየ ጊዜ፥ ");
INSERT INTO amh_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","በታላቅ ድምፅ። ቀጥ ብለህ በእግርህ ቁም አለው። ብድግ ብሎም ተንሥቶ ይመላለስ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ሕዝቡም ጳውሎስ ያደረገውን ባዩ ጊዜ ድምፃቸውን ከፍ አድርገው በሊቃኦንያ ቋንቋ። አማልክት ሰዎችን መስለው ወደ እኛ ወርደዋል አሉ፤ ");
INSERT INTO amh_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","በርናባስንም ድያ አሉት፤ ጳውሎስንም እርሱ በመናገር ዋና ስለ ነበረ ሄርሜን አሉት። ");
INSERT INTO amh_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","በከተማውም ፊት ቤተ መቅደስ ያለው የድያ ካህን ኮርማዎችንና የአበባን አክሊሎች ወደ ደጃፍ አምጥቶ ከሕዝቡ ጋር ሆኖ ሊሠዋላቸው ወደደ። ");
INSERT INTO amh_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ሐዋርያት በርናባስና ጳውሎስ ግን ይህን በሰሙ ጊዜ ልብሳቸውን ቀደው ወደ ሕዝቡ መካከል እየጮኹ ሮጡ፥ ");
INSERT INTO amh_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","እንዲህም አሉ። እናንተ ሰዎች፥ ይህን ስለ ምን ታደርጋላችሁ? እኛ ደግሞ እንደ እናንተ የምንሰማ ሰዎች ነን፥ ከዚህም ከንቱ ነገር ሰማይንና ምድርን ባሕርንም በእነርሱም ያለውን ሁሉ ወደ ፈጠረ ወደ ሕያው እግዚአብሔር ዘወር ትሉ ዘንድ ወንጌልን እንሰብካለን። ");
INSERT INTO amh_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","እርሱ ባለፉት ትውልዶች አሕዛብን ሁሉ በገዛ ራሳቸው ጐዳና ይሄዱ ዘንድ ተዋቸው። ");
INSERT INTO amh_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ከዚህም ሁሉ ጋር መልካም ሥራ እየሠራ፥ ከሰማይ ዝናብን ፍሬ የሚሆንበትንም ወራት ሲሰጠን፥ ልባችንንም በመብልና በደስታ ሲሞላው ራሱን ያለ ምስክር አልተወም። ");
INSERT INTO amh_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ይህንም ብለው እንዳይሠዉላቸው ሕዝቡን በጭንቅ አስተዉአቸው። ");
INSERT INTO amh_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","አይሁድ ግን ከአንጾኪያና ከኢቆንዮን መጡ፤ ሕዝቡንም አባብለው ጳውሎስን ወገሩ የሞተም መስሎአቸው ከከተማ ወደ ውጭ ጐተቱት። ");
INSERT INTO amh_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ደቀ መዛሙርት ግን ከበውት ሳሉ፥ ተነስቶ ወደ ከተማ ገባ። በነገውም ከበርናባስ ጋር ወደ ደርቤን ወጣ። ");
INSERT INTO amh_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","23","በየቤተ ክርስቲያኑም ሽማግሌዎችን ከሾሙላቸው በኋላ ጦመውም ከጸለዩ በኋላ፥ ላመኑበት ለጌታ አደራ ሰጡአቸው። ");
INSERT INTO amh_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","በጲስድያም አልፈው ወደ ጵንፍልያ መጡ፥ ");
INSERT INTO amh_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","በጴርጌንም ቃሉን ከተናገሩ በኋላ ወደ አጣልያ ወረዱ፥ ");
INSERT INTO amh_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ከዚያም ስለ ፈጸሙት ሥራ ለእግዚአብሔር ጸጋ አደራ ወደ ተሰጡበት ወደ አንጾኪያ በመርከብ ሄዱ። ");
INSERT INTO amh_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","በደረሱም ጊዜ ቤተ ክርስቲያኑን ሰብስበው እግዚአብሔር ከእነርሱ ጋር ያደረገውን ሁሉ ለአሕዛብም የሃይማኖትን ደጅ እንደ ከፈተላቸው ተናገሩ። ");
INSERT INTO amh_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ከደቀ መዛሙርትም ጋር አያሌ ቀን ተቀመጡ። ");
INSERT INTO amh_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","አንዳንዶችም ከይሁዳ ወረዱና። እንደ ሙሴ ሥርዓት ካልተገረዛችሁ ትድኑ ዘንድ አትችሉም ብለው ወንድሞችን ያስተምሩ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","በእነርሱና በጳውሎስ በበርናባስም መካከል ብዙ ጥልና ክርክር በሆነ ጊዜ፥ ስለዚህ ክርክር ጳውሎና በርናባስ ከእነርሱም አንዳንዶች ሌሎች ሰዎች ወደ ሐዋርያት ወደ ሽማግሌዎችም ወደ ኢየሩሳሌም ይወጡ ዘንድ ተቈረጠ። ");
INSERT INTO amh_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ቤተ ክርስቲያኑም በመንገድ እየረዳቸው እነርሱ የአሕዛብን መመለስ እየተረኩ በፊንቄና በሰማርያ አለፉ፥ ወንድሞችንም ሁሉ እጅግ ደስ አሰኙአቸው። ");
INSERT INTO amh_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ወደ ኢየሩሳሌምም በደረሱ ጊዜ ቤተ ክርስቲያንና ሐዋርያት ሽማግሌዎችም ተቀበሉአቸው፥ እግዚአብሔርም ከእነርሱ ጋር ያደረገውን ሁሉ አወሩ። ");
INSERT INTO amh_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ከፈሪሳውያን ወገን ግን ያመኑት አንዳንዶቹ ተነሥተው። ትገርዙአቸው ዘንድና የሙሴን ሕግ እንዲጠብቁ ታዙአቸው ዘንድ ይገባል አሉ። ");
INSERT INTO amh_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ሐዋርያትና ሽማግሌዎችም ስለዚህ ነገር ለመማከር ተሰበሰቡ። ");
INSERT INTO amh_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ከብዙ ክርክርም በኋላ ጴጥሮስ ተነሥቶ እንዲህ አላቸው ወንድሞች ሆይ፥ አሕዛብ ከአፌ የወንጌልን ቃል ሰምተው ያምኑ ዘንድ እግዚአብሔር በመጀመሪያው ዘመን ከእናንተ እኔን እንደ መረጠኝ እናንተ ታውቃላችሁ። ");
INSERT INTO amh_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ልብንም የሚያውቅ አምላክ ለእኛ ደግሞ እንደ ሰጠን መንፈስ ቅዱስን በመስጠት መሰከረላቸው፤ ");
INSERT INTO amh_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ልባቸውንም በእምነት ሲያነጻ በእኛና በእነርሱ መካከል አንዳች አልለየም። ");
INSERT INTO amh_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","እንግዲህ አባቶቻችንና እኛ ልንሸከመው ያልቻልነውን ቀንበር በደቀ መዛሙርት ጫንቃ ላይ በመጫን እግዚአብሔርን አሁን ስለ ምን ትፈታተናላችሁ? ");
INSERT INTO amh_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ነገር ግን በጌታ በኢየሱስ ክርስቶስ ጸጋ እንደ እነርሱ ደግሞ እንድን ዘንድ እናምናለን። ");
INSERT INTO amh_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ሕዝቡም ሁሉ ዝም አሉ፥ በርናባስና ጳውሎስም እግዚአብሔር በእጃቸው በአሕዛብ መካከል ያደረገውን ምልክትና ድንቅ ሁሉ ሲተርኩላቸው ይሰሙ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","እነርሱም ዝም ካሉ በኋላ ያዕቆብ እንዲህ ብሎ መለሰ። ወንድሞች ሆይ፥ ስሙኝ። ");
INSERT INTO amh_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","እግዚአብሔር ለስሙ የሚሆንን ወገን ከአሕዛብ ይወስድ ዘንድ አስቀድሞ እንዴት እንደ ጐበኘ ስምዖን ተርኮአል። ");
INSERT INTO amh_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ከዚህም ጋር የነቢያት ቃል ይሰማማል፥ እንዲህ ተብሎ እንደ ተጻፈ። ");
INSERT INTO amh_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","18","ከጥንት ጀምሮ ሥራው ሁሉ በእግዚአብሔር ዘንድ የታወቀ ነው። ");
INSERT INTO amh_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ስለዚህ ከአሕዛብ ወደ እግዚአብሔር የዞሩትን እንዳናስቸግራቸው፥ ");
INSERT INTO amh_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ነገር ግን ከጣዖት ርኵሰትና ከዝሙት ከታነቀም ከደምም ይርቁ ዘንድ እንድንጽፍላቸው እቈርጣለሁ። ");
INSERT INTO amh_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ሙሴስ ከቀደሙት ትውልድ ጀምሮ በሰንበት በሰንበት በምኵራቦቹ ሲያነቡ በየከተማው እርሱን የሚሰብኩ አሉት። ");
INSERT INTO amh_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ያን ጊዜ ሐዋርያትና ሽማግሌዎች ከቤተ ክርስቲያኑ ሁሉ ጋር ከእነርሱ የተመረጡትን ሰዎች ከጳውሎስና ከበርናባስ ጋር ወደ አንጾኪያ ይልኩ ዘንድ ፈቀዱ፤ እነርሱም በወንድሞች መካከል ዋናዎች ሆነው በርስያን የተባለው ይሁዳና ሲላስ ነበሩ። ");
INSERT INTO amh_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","እንዲህም ጽፈው በእነርሱ እጅ ላኩ። ሐዋርያትና ሽማግሌዎች ወንድሞችም በአንጾኪያና በሶርያ በኪልቅያም ለሚኖሩ ከአሕዛብ ወገን ለሆኑ ወንድሞች ሰላምታ ያቀርባሉ። ");
INSERT INTO amh_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ያላዘዝናቸው ሰዎች ከእኛ ወጥተው። ትገረዙ ዘንድና ሕግን ትጠብቁ ዘንድ ይገባችኋል ብለው ልባችሁን እያወኩ በቃል እንዳናወጡአችሁ ስለ ሰማን፥ ");
INSERT INTO amh_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","27","ራሳቸውም ደግሞ በቃላቸው ያንኑ ይነግሩአችሁ ዘንድ ይሁዳንና ሲላስን ልከናል። ");
INSERT INTO amh_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","30","እነርሱም ተሰናብተው ወደ አንጾኪያ ወረዱ፥ ሕዝቡንም ሰብስበው ደብዳቤውን ሰጡአቸው። ");
INSERT INTO amh_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ባነበቡትም ጊዜ ከምክሩ የተነሣ ደስ አላቸው። ");
INSERT INTO amh_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ይሁዳና ሲላስም ደግሞ ነቢያት ነበሩና ወንድሞችን በብዙ ቃል መክረው አጸኑአቸው። ");
INSERT INTO amh_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","አያሌ ቀንም ከተቀመጡ በኋላ ከወንድሞች በሰላም ተሰናብተው ወደ ሐዋርያት ሄዱ። ");
INSERT INTO amh_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ሲላስ ግን በዚያ ይኖር ዘንድ ፈቀደ። ");
INSERT INTO amh_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ጳውሎስና በርናባስም ከሌሎች ከብዙ ሰዎች ጋር ደግሞ የጌታን ቃል እያስተማሩና ወንጌልን እየሰበኩ በአንጾኪያ ይቀመጡ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ከጥቂት ቀንም በኋላ ጳውሎስ በርናባስን። ተመልሰን የጌታን ቃል በተናገርንበት በየከተማው ሁሉ ወንድሞችን እንጐብኛቸው፥ እንዴት እንዳሉም እንወቅ አለው። ");
INSERT INTO amh_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","በርናባስም ማርቆስ የተባለውን ዮሐንስን ደግሞ ከእነርሱ ጋር ይወስድ ዘንድ አሰበ፤ ");
INSERT INTO amh_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ጳውሎስ ግን ይህን ከእነርሱ ጋር ሊወስድ አልፈቀደም፥ ከእነርሱ ዘንድ ከጵንፍልያ ተለይቶ ነበርና፥ ወደ ሥራም ከእነርሱ ጋር አልመጣም ነበርና። ");
INSERT INTO amh_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ስለዚህም እርስ በርሳቸው እስኪለያዩ ድረስ መከፋፋት ሆነ፥ በርናባስም ማርቆስን ይዞ በመርከብ ወደ ቆጵሮስ ሄደ። ");
INSERT INTO amh_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ጳውሎስ ግን ሲላስን መረጠ፥ ወንድሞችም ለእግዚአብሔር ጸጋ አደራ ከሰጡት በኋላ ወጣ፤ ");
INSERT INTO amh_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","አብያተ ክርስትያናትንም እያጸና በሶርያና በኪልቅያ ይዞር ነበር። ");
INSERT INTO amh_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ወደ ደርቤንና ወደ ልስጥራንም ደረሰ። እነሆም፥ በዚያ የአንዲት ያመነች አይሁዳዊት ልጅ ጢሞቴዎስ የሚባል አንድ ደቀ መዝሙር ነበረ፤ አባቱ ግን የግሪክ ሰው ነበረ። ");
INSERT INTO amh_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ለእርሱም በልስጥራንና በኢቆንዮን ያሉ ወንድሞች መሰከሩለት። ");
INSERT INTO amh_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ጳውሎስ ይህ ከእርሱ ጋር ይወጣ ዘንድ ወደደ፥ በእነዚያም ስፍራዎች ስለ ነበሩ አይሁድ ይዞ ገረዘው፤ አባቱ የግሪክ ሰው እንደ ሆነ ሁሉ ያውቁ ነበርና። ");
INSERT INTO amh_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","በከተማዎችም ሲዞሩ በኢየሩሳሌም የነበሩት ሐዋርያትና ሽማግሌዎች የቈረጡትን ሥርዓት ይጠብቁ ዘንድ ሰጡአቸው። ");
INSERT INTO amh_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","አብያተ ክርስቲያናትም በሃያማኖት ይበረቱ ነበር፥ በቍጥርም ዕለት ዕለት ይበዙ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","በእስያም ቃሉን እንዳይናገሩ መንፈስ ቅዱስ ስለ ከለከላቸው በፍርግያና በገላትያ አገር አለፉ፤ ");
INSERT INTO amh_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","በሚስያም አንጻር በደረሱ ጊዜ ወደ ቢታንያ ይሄዱ ዘድን ሞከሩ፥ የኢየሱስ መንፈስም አልፈቀደላቸውም፤ ");
INSERT INTO amh_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","በሚስያም አጠገብ አልፈው ወደ ጢሮአዳ ወረዱ። ");
INSERT INTO amh_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ራእይም ለጳውሎስ በሌሊት ታየው፤ አንድ የመቄዶንያ ሰው። ወደ መቄዶንያ ተሻገርና እርዳን እያለ ቆሞ ሲለምነው ነበር። ");
INSERT INTO amh_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ራእዩንም ካየ በኋላ ወዲያው ወደ መቄዶንያ ልንወጣ ፈለግን፥ ወንጌልን እንሰብክላቸው ዘንድ እግዚአብሔር እንደ ጠራን መስሎናልና። ");
INSERT INTO amh_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ከጢሮአዳም ተነሥተን በቀጥታ ወደ ሳሞትራቄ በነገውም ወደ ናጱሌ በመርከብ ሄድን፤ ");
INSERT INTO amh_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ከዚያም ወደ ፊልጵስዩስ ደረስን፤ እርስዋም የመቄዶንያ ከተማ ሆና የወረዳ ዋና ከተማና ቅኝ አገር ናት፤ በዚህችም ከተማ አንዳንድ ቀን እንቀመጥ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","በሰንበት ቀንም ከከተማው በር ውጭ የጸሎት ስፍራ በዚያ መሆኑን ስላሰብን ወደ ወንዝ አጠገብ ወጣን፤ ተቀምጠንም ለተሰበሰቡት ሴቶች ተናገርን። ");
INSERT INTO amh_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ከትያጥሮን ከተማም የመጣች ቀይ ሐር ሻጭ እግዚአብሔርን የምታመልክ ልድያ የሚሉአት አንዲት ሴት ትሰማ ነበረች፤ ጳውሎስም የሚናገረውን ታዳምጥ ዘንድ ጌታ ልብዋን ከፈተላት። ");
INSERT INTO amh_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","እርስዋም ከቤተ ሰዎችዋ ጋር ከተጠመቀች በኋላ። በጌታ የማምን እንድሆን ከፈረዳችሁልኝ፥ ወደ ቤቴ ገብታችሁ ኑሩ ብላ ለመነችን፤ በግድም አለችን። ");
INSERT INTO amh_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ወደ ጸሎት ስፍራም ስንሄድ፥ የምዋርተኝነት መንፈስ የነበረባት ለጌቶችዋም እየጠነቈለች ብዙ ትርፍ ታመጣ የነበረች አንዲት ገረድ አገኘችን። ");
INSERT INTO amh_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","እርስዋ ጳውሎስንና እኛን እየተከተለች። የመዳንን መንገድ የሚነግሩአችሁ እነዚህ ሰዎች የልዑል አምላክ ባሪያዎች ናቸው ብላ ትጮኽ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ይህንም እጅግ ቀን አደረገች። ጳውሎስ ግን ተቸገረና ዘወር ብሎ መንፈሱን። ከእርስዋ እንድትወጣ በኢየሱስ ክርስቶስ ስም አዝሃለሁ አለው፤ በዚያም ሰዓት ወጣ። ");
INSERT INTO amh_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ጌቶችዋም የትርፋቸው ተስፋ እንደ ወጣ ባዩ ጊዜ ጳውሎስንና ሲላስን ይዘው ወደ ገበያ በሹማምት ፊት ጐተቱአቸው፤ ");
INSERT INTO amh_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ወደ ገዢዎችም አቅርበው። እነዚህ ሰዎች አይሁድ ሆነው ከተማችንን እጅግ ያናውጣሉ። ");
INSERT INTO amh_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","እኛም የሮሜ ሰዎች ሆነን እንቀበላቸውና እናደርጋቸው ዘንድ ያልተፈቀደልንን ልማዶች ይናገራሉ አሉ። ");
INSERT INTO amh_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ሕዝቡም አብረው ተነሡባቸው፥ ገዢዎቹም ልብሳቸውን ገፈው በበትር ይመቱአቸው ዘንድ አዘዙ፤ ");
INSERT INTO amh_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","በብዙም ከደበደቡአቸው በኋላ ወደ ወኅኒ ጣሉአቸው፥ የወኅኒውንም ጠባቂ ተጠንቅቆ እንዲጠብቃቸው አዘዙት። ");
INSERT INTO amh_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","እርሱም የዚህን ዓይነት ትእዛዝ ተቀብሎ ወደ ውስጠኛው ወኅኒ ጣላቸው፥ እግራቸውንም በግንድ አጣብቆ ጠረቃቸው። ");
INSERT INTO amh_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","በመንፈቀ ሌሊት ግን ጳውሎስና ሲላስ እየጸለዩ እግዚአብሔርን በዜማ ያመሰግኑ ነበር፥ እስረኞቹም ያደምጡአቸው ነበር ");
INSERT INTO amh_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ድንገትም የወኅኒው መሠረት እስኪናወጥ ድረስ ታላቅ የምድር መንቀጥቀጥ ሆነ፤ በዚያን ጊዜም ደጆቹ ሁሉ ተከፈቱ የሁሉም እስራት ተፈታ። ");
INSERT INTO amh_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","የወኅኒውም ጠባቂ ከእንቅልፉ ነቅቶ የወኅኒው ደጆች ተከፍተው ባየ ጊዜ፥ እስረኞቹ ያመለጡ መስሎት ራሱን ይገድል ዘንድ አስቦ ሰይፉን መዘዘ። ");
INSERT INTO amh_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ጳውሎስ ግን በታላቅ ድምፅ። ሁላችን ከዚህ አለንና በራስህ ክፉ ነገር አታድርግ ብሎ ጮኸ። ");
INSERT INTO amh_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","መብራትም ለምኖ ወደ ውስጥ ሮጠ፥ እየተንቀጠቀጠም ከጳውሎስና ከሲላስ ፊት ተደፋ፤ ");
INSERT INTO amh_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ወደ ውጭም አውጥቶ። ጌቶች ሆይ፥ እድን ዘንድ ምን ማድረግ ይገባኛል? ኣላቸው። ");
INSERT INTO amh_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","እነርሱም። በጌታ በኢየሱስ ክርስቶስ እመን አንተና ቤተ ሰዎችህ ትድናላችሁ አሉት። ");
INSERT INTO amh_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ለእርሱና በቤቱም ላሉት ሁሉ የእግዚአብሔርን ቃል ተናገሩአቸው። ");
INSERT INTO amh_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","በሌሊትም በዚያች ሰዓት ወስዶ ቍስላቸውን አጠበላቸው፥ ያን ጊዜውንም እርሱ ከቤተ ሰዎቹ ሁሉ ጋር ተጠመቀ፤ ");
INSERT INTO amh_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ወደ ቤቱም አውጥቶ ማዕድ አቀረበላቸው፥ በእግዚአብሔርም ስላመነ ከቤተ ሰዎቹ ሁሉ ጋር ሐሤት አደረገ። ");
INSERT INTO amh_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","በነጋም ጊዜ ገዢዎቹ። እነዚያን ሰዎች ፍታቸው ብለው ሎሌዎቻቸውን ላኩ። ");
INSERT INTO amh_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","የወኅኒውም ጠባቂ። ትፈቱ ዘንድ ገዢዎቹ ልከዋል፤ እንግዲህ አሁን ወጥታችሁ በሰላም ሂዱ ብሎ ይህን ቃል ለጳውሎስ ነገረው። ");
INSERT INTO amh_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ጳውሎስ ግን። እኛ የሮሜ ሰዎች ስንሆን ያለ ፍርድ በሕዝብ ፊት ደብድበው በወኅኒ ጣሉን፤ አሁንም በስውር ይጥሉናልን? አይሆንም ራሳቸው ግን መጥተው ያውጡን አላቸው። ");
INSERT INTO amh_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ሎሌዎቹም ይህን ነገር ለገዢዎች ነገሩ። የሮሜ ሰዎችም እንደ ሆኑ በሰሙ ጊዜ ፈሩ፤ ");
INSERT INTO amh_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","መጥተውም ማለዱአቸው፥ አውጥተውም ከከተማ ይወጡ ዘንድ ለመኑአቸው። ");
INSERT INTO amh_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ከወኅኒውም ወጥተው ወደ ልድያ ቤት ገቡ፥ ወንድሞችንም ባዩ ጊዜ አጽናኑአቸውና ሄዱ። ");
INSERT INTO amh_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","በአንፊጶልና በአጶሎንያም ካለፉ በኋላ ወደ ተሰሎንቄ መጡ፥ በዚያም የአይሁድ ምኵራብ ነበረ። ");
INSERT INTO amh_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ጳውሎስም እንደ ልማዱ ወደ እነርሱ ገባ፥ ሦስት ሰንበትም ያህል ከእነርሱ ጋር ከመጻሕፍት እየጠቀሰ ይነጋገር ነበር፤ ");
INSERT INTO amh_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ሲተረጉምም ክርስቶስ መከራ እንዲቀበልና ከሙታን እንዲነሣ ይገባው ዘንድ እያስረዳ። ይህ እኔ የምሰብክላችሁ ኢየሱስ እርሱ ክርስቶስ ነው ይል ነበር። ");
INSERT INTO amh_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ከእነርሱም አንዳንዶቹ ተረድተው ከሚያመልኩም ከግሪክ ሰዎች ብዙ ከከበሩትም ሴቶች ጥቂቶች ያይደሉ፥ ከጳውሎስና ከሲላስ ጋር ተባበሩ። ");
INSERT INTO amh_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","አይሁድ ግን ቀንተው ከሥራ ፈቶች ክፉ ሰዎችን አመጡ ሕዝብንም ሰብስበው ከተማውን አወኩ፥ ወደ ሕዝብም ያወጡአቸው ዘንድ ፈልገው ወደ ኢያሶን ቤት ቀረቡ፤ ");
INSERT INTO amh_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ባላገኙአቸውም ጊዜ ኢያሶንንና ከወንድሞች አንዳንዶችን ወደ ከተማው አለቆች ጎትተው። ዓለምን ያወኩ እነዚህ ወደዚህ ደግሞ መጥተዋል፥ ኢያሶንም ተቀብሎአቸዋል፤ ");
INSERT INTO amh_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","እነዚህም ሁሉ። ኢየሱስ የሚሉት ሌላ ንጉሥ አለ እያሉ የቄሣርን ትእዛዝ ይቃወማሉ ብለው ጮኹ። ");
INSERT INTO amh_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ሕዝቡና የከተማውም አለቆች ይህን ነገር በሰሙ ጊዜ ታወኩ፥ ");
INSERT INTO amh_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ከኢያሶንና ከሌሎቹም ዋስ ተቀብለው ለቀቁአቸው። ");
INSERT INTO amh_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ወዲያውም ወንድሞች ጳውሎስንና ሲላስን በሌሊት ወደ ቤርያ ሰደዱአቸው፥ በደረሱም ጊዜ ወደ አይሁድ ምኵራብ ገቡ፤ ");
INSERT INTO amh_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","እነዚህም በተሰሎንቄ ከሚኖሩት ይልቅ ልበ ሰፊዎች ነበሩና። ነገሩ እንደዚሁ ይሆንን? ብለው ዕለት ዕለት መጻሕፍትን እየመረመሩ ቃሉን በሙሉ ፈቃድ ተቀበሉ። ");
INSERT INTO amh_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ስለዚህም ከእነርሱ ብዙ፥ ከግሪኮችም የከበሩት ሴቶችና ወንዶች ጥቂት ያይደሉ፥ አመኑ። ");
INSERT INTO amh_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","በተሰሎንቄ ያሉት አይሁድ ግን ጳውሎስ በቤርያ ደግሞ የእግዚአብሔርን ቃል እንደ ሰበከ ባወቁ ጊዜ፥ ወደዚያው ደግሞ መጡና ሕዝቡን አወኩ። ");
INSERT INTO amh_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","በዚያን ጊዜም ወንድሞቹ ወዲያው ጳውሎስን እስከ ባሕር ድረስ ይሄድ ዘንድ ሰደዱት፤ ሲላስና ጢሞቴዎስም በዚያው ቀሩ። ");
INSERT INTO amh_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ጳውሎስን የሸኙት ግን እስከ አቴና አደረሱት፥ እንደሚቻላቸውም በፍጥነት ወደ እርሱ ይመጡ ዘንድ ወደ ሲላስና ወደ ጢሞቴዎስ ትእዛዝ ተቀብለው ሄዱ። ");
INSERT INTO amh_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ጳውሎስም በአቴና ሲጠብቃቸው ሳለ፥ በከተማው ጣዖት መሙላቱን እየተመለከተ መንፈሱ ተበሳጨበት። ");
INSERT INTO amh_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ስለዚህም በምኵራብ ከአይሁድና እግዚአብሔርን ከሚያመልኩ ሰዎች ጋር በየቀኑም በገበያ ከሚያገኛቸው ጋር ይነጋገር ነበር። ");
INSERT INTO amh_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ከኤፊቆሮስ ወገንና ኢስጦኢኮችም ከተባሉት ፈላስፎች አንዳንዶቹ ከእርሱ ጋር ተገናኙ። አንዳንዶቹም። ይህ ለፍላፊ ምን ሊናገር ይወዳል? አሉ፤ ሌሎችም የኢየሱስንና የትንሣኤውን ወንጌል ስለ ሰበከላቸው። አዲሶችን አማልክት የሚያወራ ይመስላል አሉ። ");
INSERT INTO amh_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","21","የአቴና ሰዎች ሁሉና በዚያ የኖሩ እንግዶች አዲስ ነገርን ከመናገርና ከመስማት በቀር በሌላ ጉዳይ አይውሉም ነበርና። ");
INSERT INTO amh_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ጳውሎስም በአርዮስፋጎስ መካከል ቆሞ እንዲህ አለ። የአቴና ሰዎች ሆይ፥ እናንተ በሁሉ ነገር አማልክትን እጅግ እንደምትፈሩ እመለከታለሁ። ");
INSERT INTO amh_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","የምታመልኩትን እየተመለከትሁ ሳልፍ። ለማይታወቅ አምላክ የሚል ጽሕፈት ያለበትን መሠዊያ ደግሞ አግኝቼአለሁና። እንግዲህ ይህን ሳታውቁ የምታመልኩትን እኔ እነግራችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ዓለሙንና በእርሱ ያለውን ሁሉ የፈጠረ አምላክ እርሱ የሰማይና የምድር ጌታ ነውና እጅ በሠራው መቅደስ አይኖርም፤ ");
INSERT INTO amh_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","እርሱም ሕይወትንና እስትንፋስን ሁሉንም ለሁሉ ይሰጣልና አንዳች እንደሚጎድለው በሰው እጅ አይገለገልም። ");
INSERT INTO amh_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","28","ከእናንተ ከባለ ቅኔዎች አንዳንዶች ደግሞ። እኛ ደግሞ ዘመዶቹ ነንና ብለው እንደ ተናገሩ፥ በእርሱ ሕያዋን ነንና እንንቀሳቀሳለን እንኖርማለን። ");
INSERT INTO amh_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","እንግዲህ የእግዚአብሔር ዘመዶች ከሆንን፥ አምላክ በሰው ብልሃትና አሳብ የተቀረጸውን ወርቅ ወይም ብር ወይም ድንጋይ እንዲመስል እናስብ ዘንድ አይገባንም። ");
INSERT INTO amh_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","እንግዲህ እግዚአብሔር ያለማወቅን ወራት አሳልፎ አሁን በየቦታቸው ንስሐ ይገቡ ዘንድ ሰውን ሁሉ ያዛል፤ ");
INSERT INTO amh_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ቀን ቀጥሮአልና፥ በዚያም ቀን ባዘጋጀው ሰው እጅ በዓለሙ ላይ በጽድቅ ሊፈርድ አለው፤ ስለዚህም እርሱን ከሙታን በማስነሣቱ ሁሉን አረጋግጦአል። ");
INSERT INTO amh_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","የሙታንንም ትንሣኤ በሰሙ ጊዜ እኵሌቶቹ አፌዙበት፥ እኵሌቶቹ ግን። ስለዚህ ነገር ሁለተኛ እንሰማሃለን አሉት። ");
INSERT INTO amh_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","እንዲሁም ጳውሎስ ከመካከላቸው ወጣ። ");
INSERT INTO amh_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","አንዳንዶች ወንዶች ግን ተባብረው አመኑ፤ ከእነርሱ ደግሞ በአርዮስፋጎስ ያለው የፍርድ ቤት ፈራጅ ዲዮናስዮስ ደማሪስ የሚሉአትም አንዲት ሴት ሌሎችም ከእነርሱ ጋር ነበሩ። ");
INSERT INTO amh_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ከዚህም በኋላ ጳውሎስ ከአቴና ወጥቶ ወደ ቆሮንቶስ መጣ። ");
INSERT INTO amh_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","በወገኑም የጳንጦስ ሰው የሚሆን አቂላ የሚሉትን አንድ አይሁዳዊ አገኘ፤ እርሱም ከጥቂት ጊዜ በፊት ከሚስቱ ከጵርስቅላ ጋር ከኢጣልያ መጥቶ ነበር፥ አይሁድ ከሮሜ ይወጡ ዘንድ ቀላውዴዎስ አዞ ነበርና፤ ወደ እነርሱ ቀረበ፥ ");
INSERT INTO amh_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ሥራቸውም አንድ ስለ ነበረ በእነርሱ ዘንድ ተቀምጦ በአንድ ላይ ሠሩ፤ ሥራቸው ድንኳን መስፋት ነበረና። ");
INSERT INTO amh_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","በየሰንበቱም ሁሉ በምኵራብ ይነጋገር ነበር፥ አይሁድንና የግሪክንም ሰዎች ያስረዳ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ሲላስና ጢሞቴዎስም ከመቄዶንያ በወረዱ ጊዜ፥ ጳውሎስ ኢየሱስ እርሱ ክርስቶስ እንደ ሆነ ለአይሁድ እየመሰከረ ለቃሉ ይተጋ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ነገር ግን በተቃወሙትና በተሳደቡ ጊዜ፥ ልብሱን እያራገፈ። ደማችሁ በራሳችሁ ነው፤ እኔ ንጹሕ ነኝ ከእንግዲህ ወዲህ ወደ አሕዛብ እሄዳለሁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ከዚያም ወጥቶ ኢዮስጦስ ወደሚባል እግዚአብሔርን ወደሚያመልክ ሰው ቤት ገባ ቤቱም በምኩራብ አጠገብ ነበረ። ");
INSERT INTO amh_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","የምኵራብ አለቃ ቀርስጶስም ከቤተ ሰዎቹ ሁሉ ጋር በጌታ አመነ፥ ከቆሮንቶስ ሰዎችም ብዙ በሰሙ ጊዜ አምነው ተጠመቁ። ");
INSERT INTO amh_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","11","በመካከላቸውም የእግዚአብሔርን ቃል እያስተማረ ዓመት ከስድስት ወር ተቀመጠ። ");
INSERT INTO amh_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ጋልዮስም በአካይያ አገረ ገዥ በነበረ ጊዜ፥ አይሁድ በአንድ ልብ ሆነው በጳውሎስ ላይ ተነሡ፥ ወደ ፍርድ ወንበርም አምጥተው። ");
INSERT INTO amh_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ይህ ሕግን ተቃውሞ እግዚአብሔርን ያመልኩት ዘንድ ሰዎችን ያባብላል አሉ። ");
INSERT INTO amh_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ጳውሎስም አፉን ሊከፍት ባሰበ ጊዜ፥ ጋልዮስ አይሁድን። አይሁድ ሆይ፥ ዓመፅ ወይም ክፉ በደል በሆነ እንድታገሣችሁ በተገባኝ፤ ");
INSERT INTO amh_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ስለ ቃልና ስለ ስሞች ስለ ሕጋችሁም የምትከራከሩ ከሆነ ግን፥ ራሳችሁ ተጠንቀቁ እኔ በዚህ ነገር ፈራጅ እሆን ዘንድ አልፈቅድምና አላቸው። ");
INSERT INTO amh_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ከፍርድ ወንበርም ፊት አስወጣቸው። ");
INSERT INTO amh_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","የግሪክ ሰዎችም ሁሉ የምኩራብ አለቃ ሶስቴንስን ይዘው በወንበሩ ፊት መቱት፤ በእነዚህም ነገሮች ጋልዮስ ግድ የለውም ነበር። ");
INSERT INTO amh_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ከዚህም በኋላ ጳውሎስ እጅግ ቀን ተቀምጦ ወንድሞቹንም ተሰናብቶ በመርከብ ወደ ሶርያ ሄደ፤ ስለትም ነበረበትና ራሱን በክንክራኦስ ተላጨ፤ ጵርስቅላና አቂላም ከእርሱ ጋር ነበሩ። ");
INSERT INTO amh_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ወደ ኤፌሶንም በደረሱ ጊዜ እነዚያን ከዚያ ተዋቸው፥ ራሱ ግን ወደ ምኵራብ ገብቶ ከአይሁድ ጋር ይነጋገር ነበር። ");
INSERT INTO amh_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","እነርሱም ብዙ ጊዜ እንዲቀመጥላቸው ሲለምኑት እሺ አላለም፤ ");
INSERT INTO amh_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ነገር ግን ሲሰናበታቸው። የሚመጣውን በዓል በኢየሩሳሌም አደርግ ዘንድ ይገባኛል እግዚአብሔር ቢፈቅድ ግን ወደ እናንተ ደግሞ እመለሳለሁ አላቸው። ከኤፌሶንም በመርከብ ተነሣ። ");
INSERT INTO amh_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ወደ ቂሣርያም በደረሰ ጊዜ ወጥቶ ለቤተ ክርስቲያን ሰላምታ ከሰጠ በኋላ ወደ አንጾኪያ ወረደ። ");
INSERT INTO amh_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ጥቂት ቀንም ቆይቶ ወጣ፥ ደቀ መዛሙርትንም ሁሉ እያጸና በገላትያ አገርና በፍርግያ በተራ አለፈ። ");
INSERT INTO amh_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","በወገኑም የእስክንድርያ ሰው የሆነ ነገር አዋቂ የነበረ አጵሎስ የሚሉት አንድ አይሁዳዊ ሰው ወደ ኤፌሶን ወረደ፤ እርሱም በመጻሕፍት እውቀት የበረታ ነበረ። ");
INSERT INTO amh_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","እርሱ የጌታን መንገድ የተማረ ነበረ፥ የዮሐንስንም ጥምቀት ብቻ አውቆ በመንፈስ ሲቃጠል ስለ ኢየሱስ ይናገርና በትክክል ያስተምር ነበር። ");
INSERT INTO amh_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","እርሱም በምኵራብ ገልጦ ይናገር ጀመር። ጵርስቅላና አቂላም በሰሙት ጊዜ፥ ወስደው የእግዚአብሔርን መንገድ ከፊት ይልቅ በትክክል ገለጡለት። ");
INSERT INTO amh_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","እርሱም ወደ አካይያ ማለፍ በፈቀደ ጊዜ፥ ወንድሞቹ አጸናኑት፥ ይቀበሉትም ዘንድ ወደ ደቀ መዛሙርት ጻፉለት፤ በደረሰም ጊዜ አምነው የነበሩትን በጸጋ እጅግ ይጠቅማቸው ነበር፤ ");
INSERT INTO amh_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ኢየሱስ እርሱ ክርስቶስ እንደ ሆነ ከመጻሕፍት እየገለጠ ለአይሁድ በሁሉ ፊት በጽኑ ያስረዳቸው ነበርና። ");
INSERT INTO amh_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","አጵሎስም በቆሮንቶስ ሳለ ጳውሎስ በላይኛው አገር አልፎ ወደ ኤፌሶን መጣ፥ ");
INSERT INTO amh_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","አንዳንድ ደቀ መዛሙርትንም አገኘ። ባመናችሁ ጊዜ መንፈስ ቅዱስን ተቀበላችሁን? አላቸው። እነርሱም። አልተቀበልንም መንፈስ ቅዱስ እንዳለ ስንኳ አልሰማንም አሉት። ");
INSERT INTO amh_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","እንኪያ በምን ተጠመቃችሁ? አላቸው። እነርሱም። በዮሐንስ ጥምቀት አሉት። ");
INSERT INTO amh_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ጳውሎስም። ዮሐንስስ ከእርሱ በኋላ በሚመጣው በኢየሱስ ክርስቶስ ያምኑ ዘንድ ለሕዝብ እየተናገረ በንስሐ ጥምቀት አጠመቀ አላቸው። ");
INSERT INTO amh_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ይህንም በሰሙ ጊዜ በጌታ በኢየሱስ ስም ተጠመቁ፤ ");
INSERT INTO amh_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ጳውሎስም እጁን በጫነባቸው ጊዜ መንፈስ ቅዱስ ወረደባቸው በልሳኖችም ተናገሩ፥ ትንቢትም ተናገሩ። ");
INSERT INTO amh_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ሰዎቹም ሁሉ አሥራ ሁለት ያህሉ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ወደ ምኵራብም ገብቶ ስለ እግዚአብሔር መንግሥት እየተነጋገረና እያስረዳቸው ሦስት ወር ያህል በግልጥ ይናገር ነበር። ");
INSERT INTO amh_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","አንዳንዶች ግን እልከኞች ሆነው በሕዝብ ፊት መንገዱን እየሰደቡ ባላመኑ ጊዜ፥ ከእነርሱ ርቆ ደቀ መዛሙርትን ለየ፥ ጢራኖስም በሚሉት በትምህርት ቤት ዕለት ዕለት ይነጋገር ነበር። ");
INSERT INTO amh_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","በእስያም የኖሩት ሁሉ አይሁድም የግሪክ ሰዎችም የጌታን ቃል እስኪሰሙ ድረስ ሁለት ዓመት ያህል እንዲህ ሆነ። ");
INSERT INTO amh_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","እግዚአብሔርም በጳውሎስ እጅ የሚያስገርም ተአምራት ያደርግ ነበር፤ ስለዚህም ከአካሉ ጨርቅ ወይም ልብስ ወደ ድውዮች ይወስዱ ነበር፥ ");
INSERT INTO amh_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ደዌያቸውም ይለቃቸው ነበር ክፉዎች መናፍስትም ይወጡ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","አጋንንትንም እያወጡ ይዞሩ ከነበሩት አይሁድ አንዳንዶች። ጳውሎስ በሚሰብከው በኢየሱስ እናምላችኋለን እያሉ ክፉዎች መናፍስት ባሉባቸው ላይ የጌታን የኢየሱስን ስም ይጠሩባቸው ዘንድ ሞከሩ። ");
INSERT INTO amh_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","የካህናትም አለቃ ለሆነ አስቄዋ ለሚሉት ለአንድ አይሁዳዊ ይህን ያደረጉ ሰባት ልጆች ነበሩት። ");
INSERT INTO amh_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ክፉው መንፈስ ግን መልሶ። ኢየሱስንስ አውቀዋለሁ ጳውሎስንም አውቀዋለሁ፤ እናንተሳ እነማን ናችሁ? አላቸው። ");
INSERT INTO amh_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ክፉው መንፈስም ያለበት ሰው ዘለለባቸው ቆስለውም ከዚያ ቤት ዕራቁታቸውን እስኪሸሹ ድረስ በረታባቸው አሸነፋቸውም። ");
INSERT INTO amh_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ይህም በኤፌሶን በሚኖሩት ሁሉ በአይሁድና በግሪክ ሰዎች ዘንድ የታወቀ ሆነ፥ በሁላቸውም ላይ ፍርሃት ወደቀባቸው፥ የጌታም የኢየሱስ ስም ተከበረ፤ ");
INSERT INTO amh_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","አምነውም ከነበሩት እጅግ ሰዎች ያደረጉትን እየተናዘዙና እየተናገሩ ይመጡ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ከአስማተኞችም ብዙዎቹ መጽሐፋቸውን ሰብስበው በሰው ሁሉ ፊት አቃጠሉት፤ ዋጋውም ቢታሰብ አምሳ ሺህ ብር ሆኖ ተገኘ። ");
INSERT INTO amh_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","እንዲህም የጌታ ቃል በኃይል ያድግና ያሸንፍ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ይህም በተፈጸመ ጊዜ ጳውሎስ። ወደዚያ ደርሼ ሮሜን ደግሞ አይ ዘንድ ይገባኛል ብሎ በመቄዶንያና በአካይያ አልፎ ወደ ኢየሩሳሌም እንዲሄድ በመንፈስ አሰበ። ");
INSERT INTO amh_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ከሚያገለግሉትም ሁለቱን ጢሞቴዎስንና ኤርስጦንን ወደ መቄዶንያ ልኮ ራሱ በእስያ ጥቂት ቀን ቆየ። ");
INSERT INTO amh_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","በዚያም ጊዜ ስለዚህ መንገድ ብዙ ሁከት ሆነ። ");
INSERT INTO amh_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ብር ሠሪ የሆነ ድሜጥሮስ የሚሉት አንድ ሰው የአርጤምስን ቤተ መቅደስ ምስሎች በብር እየሠራ ለአንጥረኞች እጅግ ትርፍ ያገኝ ነበርና፤ ");
INSERT INTO amh_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","እነዚህንም ይህንም የሚመስለውን ሥራ የሠሩትን ሰብስቦ እንዲህ አላቸው። ሰዎች ሆይ፥ ትርፋችን በዚህ ሥራ እንደ ሆነ ታውቃላችሁ። ");
INSERT INTO amh_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ይህም ጳውሎስ። በእጅ የተሠሩቱ አማልክት አይደሉም ብሎ፥ በኤፌሶን ብቻ ሳይሆን ከጥቂት ክፍል በቀር በእስያ ሁሉ ብዙ ሕዝብን እንደ አስረዳና እንደ አሳተ አይታችኋል ሰምታችሁማል። ");
INSERT INTO amh_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ሥራችንም እንዲናቅ ብቻ አይደለም፥ እስያ ሁሉ ዓለሙም የሚያመልካት የታላቂቱ አምላክ የአርጤምስ መቅደስ ምናምን ሆኖ እንዲቆጠር እንጂ፥ ታላቅነትዋም ደግሞ እንዳይሻር ያስፈራል። ");
INSERT INTO amh_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ይህንም በሰሙ ጊዜ ቍጣ ሞላባቸው። የኤፌሶን አርጤምስ ታላቅ ናት እያሉም ጮኹ። ");
INSERT INTO amh_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ከተማውም በሙሉው ተደባለቀ፥ የመቄዶንያም ሰዎች የጳውሎስን ጓደኞች ጋይዮስንና አርስጥሮኮስን ከእነርሱ ጋር ነጥቀው በአንድ ልብ ሆነው ወደ ጨዋታ ስፍራ ሮጡ። ");
INSERT INTO amh_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ጳውሎስም ወደ ሕዝቡ ይገባ ዘንድ በፈቀደ ጊዜ ደቀ መዛሙርት ከለከሉት። ");
INSERT INTO amh_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ከእስያም አለቆች ወዳጆቹ የሆኑት አንዳንዶች ደግሞ ወደ እርሱ ልከው ወደ ጨዋታ ስፍራ ራሱን እንዳይሰጥ ለመኑት። ");
INSERT INTO amh_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ወዲያና ወዲህም እያሉ ይጮኹ ነበር፤ በጉባኤው ድብልቅልቅ ሆኖ የሚበልጡት ስንኳ ስለ ምን እንደተሰበሰቡ አላወቁም ነበርና። ");
INSERT INTO amh_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","አይሁድም ሲያቀርቡት፥ እስክንድሮስን ከሕዝቡ መካከል ወደ ፊት ገፉት፤ እስክንድሮስም በእጁ ጠቅሶ በሕዝብ ፊት እንዲምዋገትላቸው ወደደ። ");
INSERT INTO amh_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","አይሁዳዊ ግን እንደ ሆነ ባወቁ ጊዜ፥ ሁሉ በአንድ ድምፅ። የኤፌሶን አርጤምስ ታላቅ ናት እያሉ ሁለት ሰዓት ያህል ጮኹ። ");
INSERT INTO amh_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","የከተማይቱም ጸሐፊ ሕዝቡን ጸጥ አሰኝቶ እንዲህ አለ። የኤፌሶን ሰዎች ሆይ፥ የኤፌሶን ከተማ ለታላቂቱ አርጤምስ ከሰማይም ለወረደው ጣዖትዋ የመቅደስ ጠባቂ መሆንዋን የማያውቅ ሰው ማን ነው? ");
INSERT INTO amh_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ይህንም የሚክደው ከሌለ፥ ጸጥ እንድትሉና አንዳች በችኮላ እንዳታደርጉ ይገባል። ");
INSERT INTO amh_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","የመቅደስን ዕቃ ያልሰረቁ አምላካችንንም ያልሰደቡ እነዚህን ሰዎች አምጥታችኋቸዋልና። ");
INSERT INTO amh_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ድሜጥሮስና ከእርሱ ጋር ያሉት አንጥረኞች ግን በሰው ላይ ነገር እንዳላቸው፥ የመጋቢያ ቀንና አገረ ገዢዎች አሉ፤ እርስ በርሳቸው ይምዋገቱ። ");
INSERT INTO amh_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ስለ ሌላ ነገር እንደ ሆነ ግን አንዳች ብትፈልጉ፥ በተደነገገው ጉባኤ ይፈታል። ");
INSERT INTO amh_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ዛሬ ስለ ተደረገው። ሁከት ነው ሲሉ እንዳይከሱን ያስፈራልና፤ ስለዚህም ስብሰባ ምላሽ መስጠት አንችልም፥ ምክንያት የለምና። ");
INSERT INTO amh_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ይህንም ብሎ ጉባኤውን ፈታው። ");
INSERT INTO amh_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ሁከቱም ከቀረ በኋላ ጳውሎስ ደቀ መዛሙርቱን አስመጥቶ መከራቸው፥ ተሰናብቶአቸውም ወደ መቄዶንያ ይሄድ ዘንድ ወጣ። ");
INSERT INTO amh_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ያንም አገር እያለፈ በብዙ ቃል ከመከራቸው በኋላ ወደ ግሪክ አገር መጣ። ");
INSERT INTO amh_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","በዚያም ሦስት ወር ተቀምጦ ወደ ሶርያ በመርከብ ሊሄድ ባሰበ ጊዜ፥ አይሁድ ሴራ ስላደረጉበት በመቄዶንያ አልፎ ይመለስ ዘንድ ቆረጠ። ");
INSERT INTO amh_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","የሸኙትም የቤርያው ሱሲጳጥሮስ ከተሰሎንቄ ሰዎችም አርስጥሮኮስና ሲኮንዱስ የደርቤኑም ጋይዮስና ጢሞቴዎስ የእስያ ሰዎችም ቲኪቆስ ጥሮፊሞስም ነበሩ፤ ");
INSERT INTO amh_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","እነዚህም ወደ ፊታችን አልፈው በጢሮአዳ ቆዩን። ");
INSERT INTO amh_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","እኛ ግን ከቂጣ በዓል ቀን በኋላ ከፊልጵስዩስ በመርከብ ተነሥተን በአምስት ቀን ወደ ጢሮአዳ ወደ እነርሱ ደረስንና በዚያ ሰባት ቀን ተቀመጥን። ");
INSERT INTO amh_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ከሳምንቱም በመጀመሪያ ቀን እንጀራ ለመቁረስ ተሰብስበን ሳለን፥ ጳውሎስ በነገው ሊሄድ ስላሰበ ከእነርሱ ጋር ይነጋገር ነበር፥ እስከ መንፈቀ ሌሊትም ነገሩን አስረዘመ። ");
INSERT INTO amh_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ተሰብስበንም በነበርንበት ሰገነት እጅግ መብራት ነበረ። ");
INSERT INTO amh_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","አውጤኪስ የሚሉትም አንድ ጎበዝ በመስኮት ተቀምጦ ታላቅ እንቅልፍ አንቀላፍቶ ነበር፤ ጳውሎስም ነገርን ባስረዘመ ጊዜ እንቅልፍ ከብዶት ከሦስተኛው ደርብ ወደ ታች ወደቀ፥ ሞቶም አነሡት። ");
INSERT INTO amh_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ጳውሎስም ወርዶ በላዩ ወደቀ፥ አቅፎም። ነፍሱ አለችበትና አትንጫጩ አላቸው። ");
INSERT INTO amh_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ወጥቶም እንጀራ ቆርሶም በላ፤ ብዙ ጊዜም እስኪነጋ ድረስ ተነጋገረ እንዲህም ሄደ። ");
INSERT INTO amh_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ብላቴናውንም ደኅና ሆኖ ወሰዱት እጅግም ተጽናኑ። ");
INSERT INTO amh_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","እኛ ግን ጳውሎስን ከዚያ እንቀበለው ዘንድ ስላለን ወደ መርከብ ቀድመን ሄድንና ወደ አሶን ተነሣን፤ እርሱ በመሬት ይሄድ ዘንድ ስላሰበ እንደዚህ አዞ ነበርና። ");
INSERT INTO amh_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","በአሶንም ባገኘን ጊዜ ተቀብለነው ወደ ሚጢሊኒ መጣን፤ ");
INSERT INTO amh_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","በማግሥቱም ከዚያ በባሕር ተነሥተን በኪዩ ፊት ለፊት ደረስን፥ በነገውም ወደ ሳሞን ተሻገርን በትሮጊሊዮም አድረን በማግሥቱ ወደ ሚሊጢን መጣን። ");
INSERT INTO amh_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ጳውሎስ በእስያ እጅግ እንዳይቀመጥ ኤፌሶንን ይተው ዘንድ ቆርጦ ነበርና ቢቻለውም በዓለ ኀምሳን በኢየሩሳሌም ይውል ዘንድ ይቸኩል ነበርና። ");
INSERT INTO amh_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ከሚሊጢንም ወደ ኤፌሶን ልኮ የቤተክርስቲያንን ሽማግሌዎች አስጠራቸው፤ ");
INSERT INTO amh_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","22","አሁንም፥ እነሆ፥ እኔ በመንፈስ ታስሬ ወደ ኢየሩሳሌም እሄዳለሁ፥ በዚያም የሚያገኘኝ ምን እንደ ሆነ አላውቅም፤ ");
INSERT INTO amh_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ነገር ግን መንፈስ ቅዱስ። እስራትና መከራ ይቆይሃል ብሎ በየከተማው ሁሉ ይመሰክርልኛል። ");
INSERT INTO amh_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ነገር ግን ሩጫዬንና ከጌታ ከኢየሱስ የተቀበልሁትን አገልግሎት እርሱም የእግዚአብሔርን ጸጋ ወንጌልን መመስከር እፈጽም ዘንድ ነፍሴን በእኔ ዘንድ እንደማትከብር እንደ ከንቱ ነገር እቆጥራለሁ። ");
INSERT INTO amh_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","አሁንም፥ እነሆ፥ እኔ የእግዚአብሔርን መንግሥት እየሰበክሁ በመካከላችሁ የዞርሁ ሁላችሁ ከእንግዲህ ወዲህ ፊቴን እንዳትዩ አውቃለሁ። ");
INSERT INTO amh_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ስለዚህ እኔ ከሰው ሁሉ ደም ንጹሕ እንደ ሆንሁ ዛሬ በዚች ቀን እመሰክርላችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","የእግዚአብሔርን ምክር ሁሉ ነግሬአችኋለሁና፥ ምንም አላስቀረሁባችሁም። ");
INSERT INTO amh_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","በገዛ ደሙ የዋጃትን የእግዚአብሔርን ቤተ ክርስቲያን ትጠብቁአት ዘንድ መንፈስ ቅዱስ እናንተን ጳጳሳት አድርጎ ለሾመባት ለመንጋው ሁሉና ለራሳችሁ ተጠንቀቁ። ");
INSERT INTO amh_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","31","ስለዚህ ሦስት ዓመት ሌሊትና ቀን በእንባ እያንዳንዳችሁን ከመገሠጽ እንዳላቋረጥሁ እያሰባችሁ ትጉ። ");
INSERT INTO amh_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","አሁንም ለእግዚአብሔርና ያንጻችሁ ዘንድ በቅዱሳንም ሁሉ መካከል ርስትን ይሰጣችሁ ዘንድ ለሚችል ለጸጋው ቃል አደራ ሰጥቻችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ከማንም ብር ወይም ወርቅ ወይም ልብስ አልተመኘሁም፤ ");
INSERT INTO amh_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","እነዚህ እጆቼ በሚያስፈልገኝ ነገር ለእኔና ከእኔ ጋር ላሉት እንዳገለገሉ እናንተ ታውቃላችሁ። ");
INSERT INTO amh_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","እንዲሁ እየደከማችሁ ድውዮችን ልትረዱና እርሱ ራሱ። ከሚቀበል ይልቅ የሚሰጥ ብፁዕ ነው እንዳለ የጌታን የኢየሱስን ቃል ልታስቡ ይገባችሁ ዘንድ በሁሉ አሳየኋችሁ። ");
INSERT INTO amh_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ይህንም ብሎ ተንበርክኮ ከሁላቸው ጋር ጸለየ። ");
INSERT INTO amh_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ሁሉም እጅግ አለቀሱ፥ ጳውሎስንም አንገቱን አቅፈው ይስሙት ነበር፤ ");
INSERT INTO amh_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ይልቁንም። ከእንግዲህ ወዲህ ፊቴን አታዩም ስላላቸው ነገር እጅግ አዘኑ። እስከ መርከብም ድረስ ሸኙት። ");
INSERT INTO amh_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ከእነርሱም ተለይተን ተነሣን፤ በቀጥታም ሄደን ወደ ቆስ በነገውም ወደ ሩድ ከዚያም ወደ ጳጥራ መጣን፤ ");
INSERT INTO amh_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ወደ ፊንቄም የሚሻገር መርከብ አግኝተን ገባንና ተነሣን። ");
INSERT INTO amh_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ቆጵሮስንም ባየናት ጊዜ በስተ ግራችን ተውናት ወደ ሶርያም ሄደን ወደ ጢሮስ ደረስን፥ መርከቡ ሸክሙን በዚያ የሚያራግፍ ነበርና። ");
INSERT INTO amh_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ደቀ መዛሙርትንም ባገኘን ጊዜ በዚያ ሰባት ቀን ተቀመጥን፤ እነርሱም ጳውሎስን ወደ ኢየሩሳሌም እንዳይወጣ በመንፈስ አሉት። ");
INSERT INTO amh_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ጊዜውንም በፈጸምን ጊዜ ወጥተን ሄድን፤ ሁላቸውም ከሚስቶቻቸውና ከልጆቻቸው ጋር እስከ ከተማው ውጭ ድረስ ሸኙን፥ በባሕሩም ዳር ተንበርክከን ጸለይን፤ ");
INSERT INTO amh_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","እርስ በርሳችንም ተሰነባብተን ወደ መርከብ ወጣን፥ እነዚያም ወደ ቤታቸው ተመለሱ። ");
INSERT INTO amh_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","እኛም የባሕሩን መንገድ ጨርሰን ከጢሮስ ወደ አካ ደረስን፥ ለወንድሞችም ሰላምታ ሰጥተን ከእነርሱ ዘንድ አንድ ቀን ተቀመጥን። ");
INSERT INTO amh_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","በነገውም ወጥተን ወደ ቂሣርያ መጣን፥ ከሰባቱም አንድ በሚሆን በወንጌላዊው ፊልጶስ ቤት ገብተን በእርሱ ዘንድ ተቀመጥን። ");
INSERT INTO amh_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ለእርሱም ትንቢት የሚናገሩ አራት ደናግል ሴቶች ልጆች ነበሩት። ");
INSERT INTO amh_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","አያሌ ቀንም ተቀምጠን ሳለን ነቢይ የነበረ አጋቦስ የሚሉት አንድ ሰው ከይሁዳ ወረደ። ");
INSERT INTO amh_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ወደ እኛም መጣና የጳውሎስን መታጠቂያ ወስዶ የገዛ እጁንና እግሩን አስሮ። እንዲሁ መንፈስ ቅዱስ። ይህ መታጠቂያ ያለውን ሰው አይሁድ በኢየሩሳሌም እንደዚህ ያስሩታል በአሕዛብም እጅ አሳልፈው ይሰጡታል ይላል አለ። ");
INSERT INTO amh_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ይህንም በሰማን ጊዜ እኛም በዚያ የሚኖሩትም ወደ ኢየሩሳሌም እንዳይወጣ ለመንነው። ");
INSERT INTO amh_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ጳውሎስ ግን መልሶ። እያለቀሳችሁ ልቤንም እየሰበራችሁ ምን ማድረጋችሁ ነው? እኔ ስለ ጌታ ስለ ኢየሱስ ስም በኢየሩሳሌም ለመሞት እንኳ ተሰናድቼአለሁ እንጂ ለእስራት ብቻ አይደለም አለ። ");
INSERT INTO amh_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ምክርንም ሊቀበል እምቢ ባለ ጊዜ። የጌታ ፈቃድ ይሁን ብለን ዝም አልን። ");
INSERT INTO amh_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ከዚህም ቀን በኋላ ተዘጋጅተን ወደ ኢየሩሳሌም ወጣን። ");
INSERT INTO amh_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","በቂሣርያም ከነበሩ ደቀ መዛሙርት አንዳንዶች ደግሞ ከእኛ ጋር መጡ፥ እነርሱም ወደምናድርበት ወደ ቀደመው ደቀ መዝሙር ወደ ቆጵሮሱ ምናሶን ወደሚሉት ቤት መሩን። ");
INSERT INTO amh_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ወደ ኢየሩሳሌም በደረስን ጊዜ ወንድሞች በደስታ ተቀበሉን። ");
INSERT INTO amh_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","በነገውም ጳውሎስ ከእኛ ጋር ወደ ያዕቆብ ዘንድ ገባ ሽማግሌዎችም ሁሉ መጡ። ");
INSERT INTO amh_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ሰላምታም ካቀረበላቸው በኋላ በእርሱ ማገልገል እግዚአብሔር በአሕዛብ መካከል ያደረገውን በእያንዳንዱ ተረከላቸው። ");
INSERT INTO amh_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","እነርሱም በሰሙ ጊዜ እግዚአብሔርን አመሰገኑ አሉትም። ወንድም ሆይ፥ በአይሁድ መካከል አምነው የነበሩት ስንት አእላፋት እንደ ሆኑ ታያለህ፤ ሁላቸውም ለሕግ የሚቀኑ ናቸው። ");
INSERT INTO amh_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ልጆቻቸውንም እንዳይገርዙ በሥርዓትም እንዳይሄዱ ብለህ በአሕዛብ መካከል ያሉት አይሁድ ሁሉ ሙሴን ይክዱ ዘንድ እንድታስተምር ስለ አንተ ነግረዋቸዋል። ");
INSERT INTO amh_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","እንግዲህ ምን ይሁን? የአንተን መምጣት ይሰማሉና ብዙዎች የግድ ሳይሰበሰቡ አይቀሩም። ");
INSERT INTO amh_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","እንግዲህ ይህን የምንልህን አድርግ፤ ስለት ያለባቸው አራት ሰዎች በእኛ ዘንድ አሉ። ");
INSERT INTO amh_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","እነዚህንም ይዘህ ከእነርሱ ጋር ንጻ፥ ራሳቸውንም እንዲላጩ ገንዘብ ክፈልላቸው፤ ሁሉም ስለ አንተ የተማሩት ከንቱ እንደ ሆነና አንተ ራስህ ደግሞ ሕጉን እየጠበቅህ በሥርዓት እንድትመላለስ ያውቃሉ። ");
INSERT INTO amh_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","አምነው ስለ ነበሩ አሕዛብ ግን ለጣዖት ከተሠዋ ከደምም ከታነቀም ከዝሙትም ነፍሳቸውን እንዲጠብቁ ፈርደን እኛ ጽፈንላቸዋል። ");
INSERT INTO amh_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","በዚያን ጊዜ ጳውሎስ ሰዎችን ይዞ በማግሥቱ ከእነርሱ ጋር እየነጻ፥ መንጻታቸውን የሚፈጽሙበትን ቀን አስታውቆ ወደ መቅደስ ገባ። በዚያም ቀን ስለ እያንዳንዳቸው መሥዋዕትን አቀረቡ። ");
INSERT INTO amh_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","29","በፊት የኤፌሶኑን ጥሮፊሞስን ከእርሱ ጋር በከተማ አይተውት ነበርና ጳውሎስም ወደ መቅደስ ያገባው መስሎአቸው ነው። ");
INSERT INTO amh_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ከተማውም ሁሉ ታወከ ሕዝቡም ሁሉ ተሰበሰቡ ጳውሎስንም ይዘው ከመቅደስ ውጭ ጎተቱት፥ ወዲያውም ደጆች ተዘጉ። ");
INSERT INTO amh_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ሊገድሉትም ሲፈልጉ። ኢየሩሳሌም ፈጽማ ታወከች የሚል ወሬ ወደ ጭፍራው ሻለቃ ወጣ፤ ");
INSERT INTO amh_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","እርሱም ያን ጊዜ ወታደሮችን ከመቶ አለቆች ጋር ይዞ እየሮጠ ወረደባቸው፤ እነርሱም የሻለቃውንና ወታደሮችን ባዩ ጊዜ ጳውሎስን መምታት ተዉ። ");
INSERT INTO amh_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","በዚያን ጊዜም የሻለቃው ቀርቦ ያዘውና በሁለት ሰንሰለት ይታሰር ዘንድ አዞ ማን እንደ ሆነና ምን እንዳደረገ ጠየቀ። ");
INSERT INTO amh_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ሕዝቡም እኵሌቶቹ እንዲህ እኵሌቶቹም እንዲያ እያሉ ይጮኹ ነበር፤ ስለ ጫጫታውም እርግጡን ማወቅ ባልተቻለ ጊዜ፥ ወደ ወታደሮች ሰፈር ይወስዱት ዘንድ አዘዘ። ");
INSERT INTO amh_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ወደ ደረጃውም በደረሰ ጊዜ ስለ ሕዝቡ ግፊያ ወታደሮች እንዲሸከሙት ሆነ፤ ");
INSERT INTO amh_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ብዙ ሕዝብ። አስወግደው እያሉና እየጮኹ ይከተሉ ነበርና። ");
INSERT INTO amh_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ወደ ሰፈርም ሊያገቡት በቀረቡ ጊዜ፥ ጳውሎስ የሻለቃውን። አንድ ነገር ብነግርህ ትፈቅዳለህን? አለው። እርሱም። የግሪክ ቋንቋ ታውቃለህን? ");
INSERT INTO amh_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","አንተ ከዚህ ዘመን አስቀድሞ ከነፍሰ ገዳዮቹ አራቱን ሺህ ሰዎች አሸፍተህ ወደ ምድረ በዳ ያወጣህ የግብፅ ሰው አይደለህምን? አለ። ");
INSERT INTO amh_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ጳውሎስ ግን። እኔስ አይሁዳዊ በኪልቅያ ያለው የጠርሴስ ሰው ሆኜ ስመ ጥር በሆነ ከተማ የምኖር ነኝ፤ ለሕዝቡ እናገር ዘንድ እንድትፈቅድልኝ እለምንሃለሁ አለ። ");
INSERT INTO amh_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","በፈቀደለትም ጊዜ ጳውሎስ በደረጃው ላይ ቆሞ በእጁ ወደ ሕዝቡ ጠቀሰ እጅግም ጸጥታ በሆነ ጊዜ በዕብራይስጥ ቋንቋ እየተናገረ እንዲህ አለ። ");
INSERT INTO amh_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","እናንተ ወንድሞች አባቶችም፥ አሁን ለእናንተ ነገሬን ስገልጥ ስሙኝ። ");
INSERT INTO amh_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","በዕብራይስጥም ቋንቋ ሲናገር በሰሙ ጊዜ ከፊት ይልቅ ዝም አሉ። እርሱም አለ። ");
INSERT INTO amh_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","እኔ የኪልቅያ በምትሆን በጠርሴስ የተወለድሁ፥ በዚችም ከተማ በገማልያል እግር አጠገብ ያደግሁ፥ የአባቶችንም ሕግ ጠንቅቄ የተማርሁ፥ ዛሬውንም እናንተ ሁሉ እንድትሆኑ ለእግዚአብሔር ቀናተኛ የሆንሁ አይሁዳዊ ሰው ነኝ ");
INSERT INTO amh_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ወንዶችንም ሴቶችንም እያሰርሁ ወደ ወኅኒም አሳልፌ እየሰጠሁ ይህን መንገድ እስከ ሞት ድረስ አሳደድሁ። ");
INSERT INTO amh_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","እንዲህም ሊቀ ካህናቱ ደግሞ ሽማግሌዎቹም ሁሉ ይመሰክሩልኛል፤ ከእነርሱ ደግሞ መልእክትን ለወንድሞቻቸው ተቀብዬ፥ በደማስቆ ያሉትን ደግሞ ታስረው እንዲቀጡ ወደ ኢየሩሳሌም ላመጣ ወደዚያ እሄድ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","ስሄድም ወደ ደማስቆ በቀረብሁ ጊዜ፥ ቀትር ሲሆን ድንገት ከሰማይ ታላቅ ብርሃን በዙሪያዬ አንጸባረቀ፤ ");
INSERT INTO amh_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","በምድርም ላይ ወድቄ። ሳውል ሳውል፥ ስለ ምን ታሳድደኛለህ? የሚለኝን ድምፅ ሰማሁ። ");
INSERT INTO amh_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","እኔም መልሼ። ጌታ ሆይ፥ አንተ ማን ነህ? አልሁ። እርሱም። አንተ የምታሳድደኝ የናዝሬቱ ኢየሱስ እኔ ነኝ አለኝ። ");
INSERT INTO amh_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ከእኔ ጋር የነበሩትም ብርሃኑን አይተው ፈሩ፥ የሚናገረኝን የእርሱን ድምፅ ግን አልሰሙም። ");
INSERT INTO amh_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ጌታ ሆይ፥ ምን ላድርግ? አልሁት። ጌታም። ተነሥተህ ወደ ደማስቆ ሂድና ታደርገው ዘንድ ስለ ታዘዘው ሁሉን በዚያ ይነግሩሃል አለኝ። ");
INSERT INTO amh_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ከዚያ ብርሃንም ክብር የተነሣ ማየት ባይሆንልኝ ከእኔ ጋር የነበሩት ሰዎች እጄን ይዘው እየመሩኝ ወደ ደማስቆ ደረስሁ። ");
INSERT INTO amh_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","በዚያም የኖሩት አይሁድ ሁሉ የመሰከሩለት እንደ ሕጉም በጸሎት የተጋ ሐናንያ የሚሉት አንድ ሰው ነበረ። ");
INSERT INTO amh_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","እርሱም ወደ እኔ መጥቶ በአጠገቤም ቆሞ። ወንድሜ ሳውል ሆይ፥ እይ አለኝ። እኔም ያን ጊዜውን ወደ እርሱ አየሁ። ");
INSERT INTO amh_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","እርሱም አለኝ። የአባቶቻችን አምላክ ፈቃዱን ታውቅ ዘንድና ጻድቁን ታይ ዘንድ ከአፉም ድምፅን ትሰማ ዘንድ አስቀድሞ መርጦሃል ");
INSERT INTO amh_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ባየኸውና በሰማኸው በሰው ሁሉ ፊት ምስክር ትሆንለታለህና። ");
INSERT INTO amh_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","አሁንስ ለምን ትዘገያለህ? ተነሣና ስሙን እየጠራህ ተጠመቅ ከኃጢአትህም ታጠብ። ");
INSERT INTO amh_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ወደ ኢየሩሳሌምም ከተመለሱ በኋላ በመቅደስ ስጸልይ ተመስጦ መጣብኝ፥ ");
INSERT INTO amh_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","እርሱም። ፍጠን ከኢየሩሳሌምም ቶሎ ውጣ፥ ስለ እኔ የምትመሰክረውን አይቀበሉህምና ሲለኝ አየሁት። ");
INSERT INTO amh_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","እኔም። ጌታ ሆይ፥ በአንተ የሚያምኑትን በምኵራብ ሁሉ እኔ በወኅኒ አገባና እደበድብ እንደ ነበርሁ እነርሱ ያውቃሉ፤ ");
INSERT INTO amh_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","የሰማዕትህንም የእስጢፋኖስን ደም ባፈሰሱ ጊዜ፥ ራሴ ደግሞ በአጠገባቸው ስቆም ተስማምቼ የገዳዮችን ልብስ እጠብቅ ነበር አልሁ። ");
INSERT INTO amh_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","እርሱም። ሂድ፥ እኔ ወደ አሕዛብ ከዚህ ወደ ሩቅ እልክሃለሁና አለኝ። ");
INSERT INTO amh_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","እስከዚህም ቃል ድረስ ይሰሙት ነበር፥ ድምፃቸውንም ከፍ አድርገው። እንደዚህ ያለውን ሰው ከምድር አስወግደው፥ በሕይወት ይኖር ዘንድ አይገባውምና አሉ። ");
INSERT INTO amh_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ሲጮኹና ልብሳቸውን ሲወረውሩ ትቢያንም ወደ ላይ ሲበትኑ፥ ");
INSERT INTO amh_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","የሻለቃው ወደ ሰፈሩ እንዲያገቡት አዘዘ፥ እንደዚህም የጮኹበትን ምክንያት ያውቅ ዘንድ። እየገረፋችሁ መርምሩት አላቸው። ");
INSERT INTO amh_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","በጠፍርም በገተሩት ጊዜ ጳውሎስ በአጠገቡ የቆመውን የመቶ አለቃ። የሮሜን ሰው ያለ ፍርድ ትገርፉ ዘንድ ተፈቅዶላችኋልን? አለው። ");
INSERT INTO amh_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","የመቶ አለቃውም በሰማ ጊዜ ወደ ሻለቃው ቀርቦ። ይህ ሰው ሮማዊ ነውና ታደርገው ዘንድ ካለህ ተጠበቅ ብሎ ነገረው። ");
INSERT INTO amh_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","የሻለቃውም ቀርቦ። አንተ ሮማዊ ነህን? ንገረኝ አለው፤ እርሱም። አዎን አለ። ");
INSERT INTO amh_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","የሻለቃውም መልሶ። እኔ ይህን ዜግነት በብዙ ገንዘብ አገኘሁት አለ። ጳውሎስም። እኔ ግን በእርስዋ ተወለድሁ አለ። ");
INSERT INTO amh_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ስለዚህም ሊመረምሩት ያሰቡት ከእርሱ ወዲያው ተለዩ፤ የሻለቃውም ደግሞ ሮማዊ መሆኑን ባወቀ ጊዜ ፈራ፥ አሳስሮት ነበርና። ");
INSERT INTO amh_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","በማግሥቱም አይሁድ የከሰሱት በምን ምክንያት እንደ ሆነ እርግጡን ያውቅ ዘንድ አስቦ ፈታው፥ የካህናት አለቆችና ሸንጎውም ሁሉ ይሰበሰቡ ዘንድ አዘዘ፥ ጳውሎስንም አውርዶ በፊታቸው አቆመው። ");
INSERT INTO amh_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ጳውሎስም ሸንጎውን ትኵር ብሎ ተመልክቶ። ወንድሞች ሆይ፥ እኔ እስከዚች ቀን ድረስ በመልካም ሕሊና ሁሉ በእግዚአብሔር ፊት ኖሬአለሁ አለ። ");
INSERT INTO amh_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ሊቀ ካህናቱም ሐናንያ አፉን ይመቱት ዘንድ በአጠገቡ ቆመው የነበሩትን አዘዘ። ");
INSERT INTO amh_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","በዚያን ጊዜ ጳውሎስ። አንተ በኖራ የተለሰነ ግድግዳ፥ እግዚአብሔር አንተን ይመታ ዘንድ አለው፤ አንተ በሕግ ልትፈርድብኝ ተቀምጠህ ሳለህ ያለ ሕግ እመታ ዘንድ ታዛለህን? አለው። ");
INSERT INTO amh_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","በአጠገቡ የቆሙትም። የእግዚአብሔርን ሊቀ ካህናት ትሳደባለህን? አሉት። ");
INSERT INTO amh_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ጳውሎስም። ወንድሞች ሆይ፥ ሊቀ ካህናት መሆኑን ባላውቅ ነው፤ በሕዝብህ አለቃ ላይ ክፉ ቃል አትናገር ተብሎ ተጽፎአልና አላቸው። ");
INSERT INTO amh_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ጳውሎስ ግን እኵሌቶቹ ሰዱቃውያን እኵሌቶቹም ፈሪሳውያን መሆናቸውን አይቶ። ወንድሞች ሆይ፥ እኔ ፈሪሳዊ የፈሪሳዊም ልጅ ነኝ፤ ስለ ተስፋና ስለ ሙታን መነሣት ይፈርዱብኛል ብሎ በሸንጎው ጮኸ። ");
INSERT INTO amh_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ይህንም ባለ ጊዜ በፈሪሳውያንና በሰዱቃውያን መካከል ጥል ሆነ ሸንጎውም ተለያየ። ");
INSERT INTO amh_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ሰዱቃውያን። ትንሣኤም መልአክም መንፈስም የለም የሚሉ ናቸውና፤ ፈሪሳውያን ግን ሁለቱን ያምናሉ። ");
INSERT INTO amh_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ታላቅ ጩኸትም ሆነ፥ ከፈሪሳውያንም ወገን የሆኑት ጻፎች ተነሥተው። በዚህ ሰው ላይ ምንም ክፉ ነገር አላገኘንበትም፤ መንፈስ ወይስ መልአክ ተናግሮት ይሆን? ብለው ተከራከሩ። ");
INSERT INTO amh_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ብዙ ጥልም በሆነ ጊዜ የሻለቃው ጳውሎስን እንዳይገነጣጥሉት ፈርቶ ጭፍሮቹ ወርደው ከመካከላቸው እንዲነጥቁት ወደ ሰፈሩም እንዲያገቡት አዘዘ። ");
INSERT INTO amh_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","በሁለተኛውም ሌሊት ጌታ በአጠገቡ ቆሞ። ጳውሎስ ሆይ፥ በኢየሩሳሌም ስለ እኔ እንደ መሰከርህ እንዲሁ በሮሜም ትመሰክርልኝ ዘንድ ይገባሃልና አይዞህ አለው። ");
INSERT INTO amh_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","በጠባም ጊዜ አይሁድ ጳውሎስን እስኪገድሉት ድረስ እንዳይበሉና እንዳይጠጡ በመሐላ ተስማሙ። ");
INSERT INTO amh_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ይህንም ሴራ ያደረጉት ሰዎች ከአርባ ይበዙ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","እነርሱም ወደ ካህናት አለቆችና ወደ ሽማግሌዎቹ መጥተው። ጳውሎስን እስክንገድል ድረስ ምንም እንዳንቀምስ ተረጋግመን ተማምለናል። ");
INSERT INTO amh_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","እንግዲህ አሁን እናንተ ከሸንጎው ጋር ሆናችሁ ስለ እርሱ አጥብቃችሁ እንደምትመረምሩ መስላችሁ ወደ እናንተ እንዲያወርደው ለሻለቃው አመልክቱት፤ እኛም ሳይቀርብ እንድንገድለው የተዘጋጀን ነን አሉአቸው። ");
INSERT INTO amh_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","የጳውሎስ የእኅቱ ልጅ ግን ደባቸውን በሰማ ጊዜ፥ መጥቶ ወደ ሰፈሩ ገባና ለጳውሎስ ነገረው። ");
INSERT INTO amh_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ጳውሎስም ከመቶ አለቆች አንዱን ጠርቶ። ይህን ብላቴና ወደ ሻለቃው ውሰድ፥ የሚያወራለት ነገር አለውና አለው። ");
INSERT INTO amh_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","እርሱም ይዞት ወደ ሻለቃው ወሰደውና። ይህ ብላቴና የሚነግርህ ነገር ስላለው እስረኛው ጳውሎስ ጠርቶ ወደ አንተ እንድወስደው ለመነኝ አለው። ");
INSERT INTO amh_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","የሻለቃውም እጁን ይዞ ፈቀቅ አለና ለብቻው ሆኖ። የምታወራልኝ ነገር ምንድር ነው? ብሎ ጠየቀው። ");
INSERT INTO amh_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","እርሱም። አይሁድ ስለ ጳውሎስ ከፊት ይልቅ አጥብቀህ እንደምትመረምር መስለህ፥ ነገ ወደ ሸንጎ ታወርደው ዘንድ ሊለምኑህ ተስማምተዋል። ");
INSERT INTO amh_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","እንግዲህ አንተ በጅ አትበላቸው፤ እስኪገድሉት ድረስ እንዳይበሉና እንዳይጠጡ ተማምለው ከእነርሱ ከአርባ የሚበዙ ሰዎች ያደቡበታልና፤ አሁንም የተዘጋጁ ናቸው የአንተንም ምላሽ ይጠብቃሉ አለው። ");
INSERT INTO amh_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","የሻለቃውም። ይህን ነገር ለእኔ ማመልከትህን ለማንም እንዳትገልጥ ብሎ ካዘዘ በኋላ ብላቴናውን አሰናበተው። ");
INSERT INTO amh_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ከመቶ አለቆቹም ሁለት ጠርቶ። ወደ ቂሣርያ ይሄዱ ዘንድ ሁለት መቶ ወታደሮችንና ሰባ ፈረሰኞችን ሁለት መቶም ባለ ጦር መሣሪያዎችን ከሌሊቱ በሦስተኛው ሰዓት አዘጋጁ አላቸው። ");
INSERT INTO amh_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ጳውሎስንም ወደ አገረ ገዡ ወደ ፊልክስ በደኅና እንዲያደርሱት የሚያስቀምጡበትን ከብት ያዘጋጁ ዘንድ አዘዛቸው። ");
INSERT INTO amh_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ደብዳቤም ጻፈ እንዲህ የሚል። ");
INSERT INTO amh_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","ከቀላውዴዎስ ሉስዮስ ወደ ክቡር አገረ ገዡ ወደ ፊልክስ፤ ሰላም ለአንተ ይሁን። ");
INSERT INTO amh_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ይህን ሰው አይሁድ ይዘው ሊገድሉት ባሰቡ ጊዜ ከጭፍሮቹ ጋር ደርሼ አዳንሁት፥ ሮማዊ እንደ ሆነ አውቄ ነበርና። ");
INSERT INTO amh_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","የሚከሰስበትንም ምክንያት አውቅ ዘንድ አስቤ ወደ ሸንጎአቸው አወረድሁት፤ ");
INSERT INTO amh_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","በሕጋቸውም ስለ መከራከር እንደ ከሰሱት አገኘሁ እንጂ ለሞት ወይም ለእስራት የሚያደርስ ክስ አይደለም። ");
INSERT INTO amh_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","በዚህም ሰው አይሁድ ሴራ እንዲያደርጉበት ባመለከቱኝ ጊዜ ያን ጊዜውን ወደ አንተ ሰደድሁት፥ ከሳሾቹንም ደግሞ በፊትህ ይከሱት ዘንድ አዘዝኋቸው። ደኅና ሁን። ");
INSERT INTO amh_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ወታደሮቹም እንደ ታዘዙት ጳውሎስን ይዘው በሌሊት ወደ አንቲጳጥሪስ አደረሱት፤ ");
INSERT INTO amh_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","በነገውም ከእርሱ ጋር ይሄዱ ዘንድ ፈረሰኞችን ትተው ወደ ሰፈር ተመለሱ። ");
INSERT INTO amh_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","እነዚያም ወደ ቂሣርያ ገብተው ደብዳቤውን ለአገረ ገዡ በሰጡ ጊዜ ጳውሎስን ደግሞ በፊቱ አቆሙት። ");
INSERT INTO amh_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ካነበበውም በኋላ የወዴት አውራጃ እንደ ሆነ ጠየቀው፤ የኪልቅያ ሰው መሆኑንም ባወቀ ጊዜ። ");
INSERT INTO amh_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ከሳሾችህ ደግሞ ሲመጡ እሰማሃለሁ አለው፤ በሄሮድስም ግቢ ውስጥ ይጠብቁት ዘንድ አዘዘ። ");
INSERT INTO amh_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ከአምስት ቀንም በኋላ ሊቀ ካህናቱ ሐናንያ ከሽማግሌዎችና ጠርጠሉስ ከሚሉት ከአንድ ጠበቃ ጋር ወረደ፤ እነርሱም ስለ ጳውሎስ ለአገረ ገዡ አመለከቱት። ");
INSERT INTO amh_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","4","ነገር ግን እጅግ እንዳላቆይህ በቸርነትህ በአጭሩ ትሰማን ዘንድ እለምንሃለሁ። ");
INSERT INTO amh_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ይህ ሰው በሽታ ሆኖ በዓለም ባሉት አይሁድ ሁሉ ሁከት ሲያስነሣ፥ የመናፍቃን የናዝራውያን ወገን መሪ ሆኖ አግኝተነዋልና፤ ");
INSERT INTO amh_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","መቅደስንም ደግሞ ሊያረክስ ሲሞክር ያዝነው፥ እንደ ሕጋችንም እንፈርድበት ዘንድ ወደድን። ");
INSERT INTO amh_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ነገር ግን የሻለቃው ሉስዮስ መጥቶ በብዙ ኃይል ከእጃችን ወሰደው፥ ");
INSERT INTO amh_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ከሳሾቹንም ወደ አንተ ይመጡ ዘንድ አዘዘ፤ አንተም ራስህ እርሱን መርምረህ እኛ ስለምንከስበት ነገር ሁሉ ልታውቅ ትችላለህ። ");
INSERT INTO amh_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","አይሁድም ደግሞ። ይህ ነገር እንዲሁ ነው እያሉ ተስማሙ። ");
INSERT INTO amh_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ገዡም በጠቀሰው ጊዜ ጳውሎስ መለሰ እንዲህ ሲል። ከብዙ ዘመን ጀምረህ ለዚህ ሕዝብ አንተ ፈራጅ እንደ ሆንህ አውቃለሁና ደስ እያለኝ ስለ እኔ ነገር እመልሳለሁ፤ ");
INSERT INTO amh_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","እሰግድ ዘንድ ወደ ኢየሩሳሌም ከወጣሁ ከአሥራ ሁለት ቀን እንዳይበልጥ ልታውቀው ትችላለህ። ");
INSERT INTO amh_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ከአንድም ስንኳ ስነጋገር ወይም ሕዝብን ስሰበስብ በመቅደስ ቢሆን በምኵራብም ቢሆን በከተማም ቢሆን አላገኙኝም። ");
INSERT INTO amh_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","አሁንም ስለሚከሱኝ ያስረዱህ ዘንድ አይችሉም። ");
INSERT INTO amh_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ነገር ግን ይህን እመሰክርልሃለሁ፤ በሕጉ ያለውን በነቢያትም የተጻፉትን ሁሉ አምኜ የአባቶቼን አምላክ እነርሱ ኑፋቄ ብለው እንደሚጠሩት መንገድ አመልካለሁ፤ ");
INSERT INTO amh_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","እነዚህም ራሳቸው ደግሞ የሚጠብቁት፥ ጻድቃንም ዓመፀኞችም ከሙታን ይነሡ ዘንድ እንዳላቸው ተስፋ በእግዚአብሔር ዘንድ አለኝ። ");
INSERT INTO amh_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ስለዚህ እኔ ደግሞ በእግዚአብሔርና በሰው ፊት ሁልጊዜ ነውር የሌለባት ሕሊና ትኖረኝ ዘንድ እተጋለሁ። ");
INSERT INTO amh_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","ከብዙ ዓመትም በኋላ ለሕዝቤ ምጽዋትና መሥዋዕት አደርግ ዘንድ መጣሁ፤ ");
INSERT INTO amh_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ይህንም ሳደርግ ሳለሁ ሕዝብ ሳይሰበሰብ ሁከትም ሳይሆን በመቅደስ ስነጻ አገኙኝ። ");
INSERT INTO amh_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ነገር ግን በእኔ ላይ ነገር ያላቸው እንደ ሆነ፥ በፊትህ መጥተው ይከሱኝ ዘንድ የሚገባቸው ከእስያ የመጡ አንዳንድ አይሁድ አሉ። ");
INSERT INTO amh_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","22","ፊልክስ ግን የመንገዱን ነገር አጥብቆ አውቆአልና። የሻለቃው ሉስዮስ በወረደ ጊዜ ነገራችሁን እቆርጣለሁ ብሎ ወደ ፊት አዘገያቸው። ");
INSERT INTO amh_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","የመቶውንም አለቃ ጳውሎስን ሲጠብቅ እንዲያደላለት፥ ከወዳጆቹም ማንም ሲያገለግለው ወይም ወደ እርሱ ሲመጣ እንዳይከለክልበት አዘዘው። ");
INSERT INTO amh_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ከጥቂት ቀንም በኋላ ፊልክስ አይሁዳዊት ከነበረች ድሩሲላ ከሚሉአት ከሚስቱ ጋር መጥቶ ጳውሎስን አስመጣ፥ በኢየሱስ ክርስቶስም ስለ ማመን የሚናገረውን ሰማው። ");
INSERT INTO amh_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","እርሱም ስለ ጽድቅና ራስን ስለ መግዛት ስለሚመጣውም ኵነኔ ሲነጋገር ሳለ፥ ፊልክስ ፈርቶ። አሁንስ ሂድ፥ በተመቸኝም ጊዜ ልኬ አስጠራሃለሁ ብሎ መለሰለት። ");
INSERT INTO amh_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ያን ጊዜም ደግሞ እንዲፈታው ጳውሎስ ገንዘብ ይሰጠው ዘንድ ተስፋ አደረገ፤ ስለዚህ ደግሞ ብዙ ጊዜ እያስመጣ ያነጋግረው ነበር። ");
INSERT INTO amh_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ሁለት ዓመትም ከሞላ በኋላ ጶርቅዮስ ፊስጦስ በፊልክስ ፈንታ ተተካ። ፊልክስም አይሁድን ደስ ያሰኝ ዘንድ ወዶ ጳውሎስን እንደ ታሰረ ተወው። ");
INSERT INTO amh_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ፊስጦስም ወደ አውራጃው ገብቶ ከሦስት ቀን በኋላ ከቂሣርያ ወደ ኢየሩሳሌም ወጣ። ");
INSERT INTO amh_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","የካህናቱ አለቆችና የአይሁድም ታላላቆች በጳውሎስ ላይ አመለከቱ፥ ");
INSERT INTO amh_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ጳውሎስንም ሲቃወም እንዲያደላላቸው እየለመኑ፥ በመንገድ ሸምቀው ይገድሉት ዘንድ አስበው ወደ ኢየሩሳሌም እንዲያስመጣው ማለዱት። ");
INSERT INTO amh_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ፊስጦስ ግን ጳውሎስ በቂሳርያ እንዲጠበቅ እርሱም ራሱ ወደዚያ ፈጥኖ ይሄድ ዘንድ እንዳለው መለሰላቸው፤ ");
INSERT INTO amh_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","እንግዲህ በዚህ ሰው ክፋት ቢሆን ከእናንተ ዘንድ ያሉት ባለ ስልጣኖች ከእኔ ጋር ወርደው ይክሰሱት አላቸው። ");
INSERT INTO amh_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","በእነርሱም ዘንድ ከስምንት ወይም ከአስር የማይበልጥ ቀን ተቀምጦ ወደ ቂሳርያ ወረደ፤ በነገውም በፍርድ ወንበር ተቀምጦ ጳውሎስን ያመጡት ዘንድ አዘዘ። ");
INSERT INTO amh_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","በቀረበም ጊዜ ከኢየሩሳሌም የወረዱት አይሁድ ከበውት ቆሙ፥ ይረቱበትም ዘንድ የማይችሉትን ብዙና ከባድ ክስ አነሱበት፤ ");
INSERT INTO amh_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ጳውሎስም ሲምዋገት። የአይሁድን ህግ ቢሆን መቅደስንም ቢሆን ቄሳርንም ቢሆን አንዳች ስንኳ አልበደልሁም አለ። ");
INSERT INTO amh_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ፊስጦስ ግን አይሁድን ደስ ያሰኝ ዘንድ ወዶ ጳውሎስን። ወደ ኢየሩሳሌም ወጥተህ ስለዚህ ነገር ከዚያው በፊቴ ትፋረድ ዘንድ ትወዳለህን? ብሎ መለሰለት። ");
INSERT INTO amh_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ጳውሎስ ግን። እፋረድበት ዘንድ በሚገባኝ በቄሳር ፍርድ ወንበር ፊት ቆሜአለሁ። አንተው ደግሞ ፈጽመህ እንደምታውቅ አይሁድን ምንም አልበደልሁም። ");
INSERT INTO amh_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","እንግዲህ በድዬ ወይም ሞት የሚገባውን ነገር አድርጌ እንደ ሆነ ከሞት ልዳን አልልም፤ እነዚህ የሚከሱኝ ክስ ከንቱ እንደሆነ ግን ለእነርሱ አሳልፎ ይሰጠኝ ዘንድ ማንም አይችልም፤ ወደ ቄሳር ይግባኝ ብዬአለሁ አለ። ");
INSERT INTO amh_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","በዚያን ጊዜ ፊስጦስ ከአማካሪዎቹ ጋር ተማክሮ። ወደ ቄሳር ይግባኝ ብለሃል፤ ወደ ቄሳር ትሄዳለህ ብሎ መለሰለት። ");
INSERT INTO amh_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ከጥቂት ቀንም በኋላ ንጉሡ አግሪጳ በርኒቄም ለፊስጦስ ሰላምታ እንዲያቀርቡ ወደ ቂሳርያ ወረዱ። ");
INSERT INTO amh_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","በዚያውም ብዙ ቀን ስለተቀመጡ ፊስጦስ የጳውሎስን ነገር ለንጉሡ እንዲህ ብሎ ገለጠ። ፊልክስ አስሮ የተወው አንድ ሰው በዚህ አለ፤ ");
INSERT INTO amh_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","በኢየሩሳሌምም ሳለሁ የካህናት አለቆችና የአይሁድ ሽማግሌዎች እፈርድበት ዘንድ እየለመኑ ስለ እርሱ አመለከቱኝ። ");
INSERT INTO amh_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","እኔም። ተከሳሹ በከሳሾቹ ፊት ለፊት ሳይቆም ለተከሰሰበትም መልስ ይሰጥ ዘንድ ፈንታ ሳያገኝ፥ ማንንም ቢሆን አሳልፎ መስጠት የሮማውያን ሥርዓት አይደለም ብዬ መለስሁላቸው። ");
INSERT INTO amh_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ስለዚህም በዚህ በተሰበሰቡ ጊዜ፥ ሳልዘገይ በማግሥቱ በፍርድ ወንበር ተቀምጬ ያንን ሰው ያመጡት ዘንድ አዘዝሁ። ");
INSERT INTO amh_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ከሳሾቹም በቆሙ ጊዜ እኔ ያሰብሁትን ክፉ ነገር ክስ ምንም አላመጡበትም፤ ");
INSERT INTO amh_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ነገር ግን ስለ ገዛ ሃይማኖታቸውና ጳውሎስ። ሕያው ነው ስለሚለው ስለ ሞተው ኢየሱስ ስለ ተባለው ከእርሱ ጋር ይከራከሩ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","እኔም ይህን ነገር እንዴት እንድመረምር አመንትቼ። ወደ ኢየሩሳሌም ሄደህ በዚህ ነገር ከዚያ ልትፋረድ ትወዳለህን? አልሁት። ");
INSERT INTO amh_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ጳውሎስ ግን አውግስጦስ ቄሣር እስኪቈርጥ ድረስ እንዲጠበቅ ይግባኝ ባለ ጊዜ፥ ወደ ቄሣር እስክሰደው ድረስ ይጠበቅ ዘንድ አዘዝሁ። ");
INSERT INTO amh_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","አግሪጳም ፊስጦስን። ያንንስ ሰው እኔ ዳግም እኮ እሰማው ዘንድ እወድ ነበር አለው። እርሱም። ነገ ትሰማዋለህ አለው። ");
INSERT INTO amh_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","በነገውም አግሪጳና በርኒቄ በብዙ ግርማ መጥተው ከሻለቆችና ከከተማው ታላላቆች ጋር ወደ ፍርድ ቤት ገቡ፤ ፊስጦስም ባዘዘ ጊዜ ጳውሎስን አመጡት። ");
INSERT INTO amh_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ፊስጦስም አለ። አግሪጳ ንጉሥ ሆይ እናንተም ከእኛ ጋር ያላችሁ ሰዎች ሁሉ፥ ከእንግዲህ ወዲህ በሕይወት ይኖር ዘንድ እንዳይገባው እየጮኹ የአይሁድ ሕዝብ ሁሉ በኢየሩሳሌም በዚህም ስለ እርሱ የለመኑኝን ይህን ሰው ታዩታላችሁ። ");
INSERT INTO amh_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","እኔ ግን ሞት የሚገባውን ነገር እንዳላደረገ አስተዋልሁ፥ እርሱም ወደ አውግስጦስ ይግባኝ ስላለ እሰደው ዘንድ ቈረጥሁ። ");
INSERT INTO amh_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ስለ እርሱም ወደ ጌታዬ የምጽፈው እርግጥ ነገር የለኝም፤ ስለዚህ ከተመረመረ በኋላ የምጽፈውን ነገር አገኝ ዘንድ በፊታችሁ ይልቁንም በፊትህ፥ ንጉሥ አግሪጳ ሆይ፥ አመጣሁት፤ ");
INSERT INTO amh_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","እስረኛ ሲላክ የተከሰሰበትን ምክንያት ደግሞ አለማመልከት ሞኝነት መስሎኛልና። ");
INSERT INTO amh_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","አግሪጳም ጳውሎስን። ስለ ራስህ ትናገር ዘንድ ተፈቅዶልሃል አለው። በዚያን ጊዜ ጳውሎስ እጁን ዘርግቶ መለሰ እንዲህ ሲል። ");
INSERT INTO amh_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","4","ከመጀመሪያ አንሥቶ በሕዝቤ መካከል በኢየሩሳሌም የሆነውን፥ ከታናሽነቴ ጀምሬ የኖርሁትን ኑሮዬን አይሁድ ሁሉ ያውቃሉ፤ ");
INSERT INTO amh_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ሊመሰክሩ ይወዱ እንደ ሆነ፥ በአምልኮአችን ከሁሉ ይልቅ ሕግን በመጠንቀቅ እንደሚተጋ ወገን ፈሪሳዊ ሆኜ እንደኖርሁ ከጥንት ጀምረው አውቀውኛልና። ");
INSERT INTO amh_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","አሁንም ከእግዚአብሔር ዘንድ ለአባቶቻችን ስለ ተሰጠው ስለ ተስፋ ቃል አለኝታ ልፋረድ ቆሜአለሁ። ");
INSERT INTO amh_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ወደዚህም ወደ ተስፋ ቃል አሥራ ሁለቱ ወገኖቻችን ሌሊትና ቀን በትጋት እያመለኩ ይደርሱ ዘንድ አለኝታ አላቸው፤ ስለዚህም አለኝታ፥ ንጉሥ አግሪጳ ሆይ፥ ከአይሁድ እከሰሳለሁ። ");
INSERT INTO amh_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","እግዚአብሔር ሙታንን የሚያስነሣ እንደ ሆነ ስለ ምን በእናንተ ዘንድ የማይታመን ነገር ሆኖ ይቈጠራል? ");
INSERT INTO amh_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","እኔም ራሴ የናዝሬቱን የኢየሱስን ስም የሚቃወም እጅግ ነገር አደርግ ዘንድ እንዲገባኝ ይመስለኝ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ይህንም ደግሞ በኢየሩሳሌም አደረግሁት፤ ከካህናት አለቆችም ሥልጣን ተቀብዬ እኔ ከቅዱሳን ብዙዎችን በወኅኒ አሳሰርኋቸው፥ ሲገድሉአቸውም አብሬ ተቸሁ። ");
INSERT INTO amh_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","በምኵራብም ሁሉ ብዙ ጊዜ እየቀጣሁ ይሰድቡት ዘንድ ግድ አልኋቸው፤ ያለ ልክ ስቈጣባቸውም እስከ ውጭ አገር ከተማዎች ድረስ እንኳ አሳድድ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ስለዚህም ነገ ከካህናት አለቆች ሥልጣንና ትእዛዝ ተቀብዬ ወደ ደማስቆ ስሄድ፥ ");
INSERT INTO amh_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ንጉሥ ሆይ፥ በመንገድ ሳለሁ እኩል ቀን ሲሆን በዙሪያዬና ከእኔ ጋር በሄዱት ዙሪያ ከፀሐይ ብሩህነት የበለጠ ብርሃን ከሰማይ ሲበራ አየሁ፤ ");
INSERT INTO amh_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ሁላችንም በምድር ላይ በወደቅን ጊዜ። ሳውል ሳውል፥ ስለ ምን ታሳድደኛለህ? የመውጊያውን ብረት ብትቃወም ለአንተ ይብስብሃል የሚል ድምፅ በዕብራይስጥ ቋንቋ ሲናገረኝ ሰማሁ። ");
INSERT INTO amh_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","እኔም። ጌታ ሆይ፥ ማንነህ? አልሁ። እርሱም አለኝ። አንተ የምታሳድደኝ እኔ ኢየሱስ ነኝ። ");
INSERT INTO amh_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ነገር ግን ተነሣና በእግርህ ቁም፤ ስለዚህ እኔን ባየህበት ነገር ለአንተም በምታይበት ነገር አገልጋይና ምስክር ትሆን ዘንድ ልሾምህ ታይቼልሃለሁና። ");
INSERT INTO amh_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","19","ንጉሥ አግሪጳ ሆይ፥ ስለዚህ ከሰማይ የታየኝን ራእይ እምቢ አላልሁም። ");
INSERT INTO amh_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ነገር ግን አስቀድሜ በደማስቆ ላሉት በኢየሩሳሌምም በይሁዳም አገር ሁሉ ለአሕዛብም ንስሐ ይገቡ ዘንድና ለንስሐ የሚገባ ነገር እያደረጉ ወደ እግዚአብሔር ዘወር ይሉ ዘንድ ተናገርሁ። ");
INSERT INTO amh_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ስለዚህ አይሁድ በመቅደስ ያዙኝ ሊገድሉኝም ሞከሩ። ");
INSERT INTO amh_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","24","እንዲህም ብሎ ስለ ራሱ ሲመልስ ፊስጦስ በታላቅ ድምፅ። ጳውሎስ ሆይ፥ አብድሃል እኮ፤ ብዙ ትምህርትህ ወደ እብደት ያዞርሃል አለው። ");
INSERT INTO amh_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ጳውሎስ ግን እንዲህ አለ። ክቡር ፊስጦስ ሆይ፥ የእውነትንና የአእምሮን ነገር እናገራለሁ እንጂ እብደትስ የለብኝም። ");
INSERT INTO amh_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","በእርሱ ፊት ደግሞ በግልጥ የምናገረው ንጉሥ ይህን ነገር ያውቃል፤ ከዚህ ነገር አንዳች እንዳይሰወርበት ተረድቼአለሁና፤ ይህ በስውር የተደረገ አይደለምና። ");
INSERT INTO amh_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ንጉሥ አግሪጳ ሆይ፥ ነቢያትን ታምናለህን? እንድታምናቸው አውቃለሁ። ");
INSERT INTO amh_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","አግሪጳም ጳውሎስን። በጥቂት ክርስቲያን ልታደርገኝ ትወዳለህ አለው። ");
INSERT INTO amh_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ጳውሎስም። በጥቂት ቢሆን ወይም በብዙ አንተ ብቻ አይደለህም ነገር ግን ዛሬ የሚሰሙኝ ሁሉ ደግሞ ከዚህ እስራቴ በቀር እንደ እኔ ይሆኑ ዘንድ ወደ እግዚአብሔር እለምናለሁ አለው። ");
INSERT INTO amh_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ንጉሡም አገረ ገዡም በርኒቄም ከእነርሱም ጋር ተቀምጠው የነበሩት ተነሡ፥ ");
INSERT INTO amh_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ፈቀቅ ብለውም እርስ በርሳቸው። ይህ ሰው እንኳንስ ለሞት ለእስራትም የሚገባ ምንም አላደረገ ብለው ተነጋገሩ። ");
INSERT INTO amh_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","አግሪጳም ፈስጦስን። ይህ ሰው እኮ ወደ ቄሣር ይግባኝ ባይል ይፈታ ዘንድ ይቻል ነበር አለው። ");
INSERT INTO amh_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ወደ ኢጣሊያም በመርከብ እንሄድ ዘንድ በተቈረጠ ጊዜ፥ ጳውሎስንና ሌሎችን እስረኞች ከአውግስጦስ ጭፍራ ለነበረ ዩልዮስ ለሚሉት ለመቶ አለቃ አሳልፈው ሰጡአቸው። ");
INSERT INTO amh_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","በእስያም ዳርቻ ወዳሉ ስፍራዎች ይሄድ ዘንድ ባለው በአድራሚጢስ መርከብ ገብተን ተነሣን፤ የመቄዶንያም ሰው የሆነ የተሰሎንቄው አርስጥሮኮስ ከእኛ ጋር ነበረ። ");
INSERT INTO amh_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","በነገውም ወደ ሲዶና ስንደርስ ዩልዮስ ለጳውሎስ ቸርነት አድርጎ እርዳታቸውን ይቀበል ዘንድ ወደ ወዳጆቹ እንዲሄድ ፈቀደለት። ");
INSERT INTO amh_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ከዚያም ተነሥተን ነፋሱ ፊት ለፊት ነበረና በቆጵሮስ ተተግነን ሄድን፤ ");
INSERT INTO amh_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","በኪልቅያና በጵንፍልያም አጠገብ ያለውን ባሕር ከተሻገርን በኋላ በሉቅያ ወዳለ ወደ ሙራ ደረስን። ");
INSERT INTO amh_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","የመቶ አለቃውም በዚያ ወደ ኢጣሊያ የሚሄድ የእስክንድርያውን መርከብ አግኝቶ ወደ እርሱ አገባን። ");
INSERT INTO amh_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ብዙ ቀንም እያዘገምን ሄደን በጭንቅ ወደ ቀኒዶስ አንጻር ደረስን፤ ነፋስም ስለ ከለከለን በቀርጤስ ተተግነን በሰልሙና አንጻር ሄድን፤ ");
INSERT INTO amh_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","በጭንቅም ጥግ ጥጉን አልፈን ለላሲያ ከተማ ወደ ቀረበች መልካም ወደብ ወደሚሉአት ስፍራ መጣን። ");
INSERT INTO amh_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ብዙ ጊዜም ካለፈ በኋላ፥ የጦም ወራት አሁን አልፎ ስለ ነበረ በመርከብ ለመሄድ አሁን የሚያስፈራ ነበርና ጳውሎስ። ");
INSERT INTO amh_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","እናንተ ሰዎች ሆይ፥ ይህ ጕዞ በጥፋትና በብዙ ጕዳት እንዲሆን አያለሁ፤ ጥፋቱም በገዛ ሕይወታችን ነው እንጂ በጭነቱና በመርከቡ ብቻ አይደለም ብሎ መከራቸው። ");
INSERT INTO amh_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","የመቶ አለቃው ግን ጳውሎስ ከተናገረው ይልቅ የመርከብ መሪውንና የመርከቡን ባለቤት ያምን ነበር። ");
INSERT INTO amh_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ያም ወደብ ይከርሙበት ዘንድ የማይመች ስለ ሆነ፥ የሚበዙቱ ቢቻላቸው በሰሜንና በደቡብ ምዕራብ ትይዩ ወዳለው ፍንቄ ወደሚሉት ወደ ቀርጤስ ወደብ ደርሰው ይከርሙ ዘንድ ከዚያ እንዲነሡ መከሩ። ");
INSERT INTO amh_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ልከኛም የደቡብ ነፋስ በነፈሰ ጊዜ፥ እንዳሰቡት የሆነላቸው መስሎአቸው ተነሡ በቀርጤስም አጠገብ ጥግ ጥጉን አለፉ። ");
INSERT INTO amh_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ነገር ግን እጅግ ሳይዘገይ አውራቂስ የሚሉት ዓውሎ ነፋስ ከዚያ ወረደባቸው፤ ");
INSERT INTO amh_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","መርከቡም ተነጥቆ ነፋሱን ሲቃወም መሄድ ስላልቻለ ለቀነው ተነዳን። ");
INSERT INTO amh_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ቄዳ በሚሉአትም ደሴት በተተገንን ጊዜ ታንኳይቱን ለመግዛት በጭንቅ ቻልን፤ ");
INSERT INTO amh_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ወደ ላይም ካወጡአት በኋላ መርከቡን በገመድ አስታጥቀው አጸኑ፤ ስርቲስም ወደሚሉት ወደ አሸዋ እንዳይወድቁ ፈርተው ሸራውን አውርደው እንዲሁ ተነዱ። ");
INSERT INTO amh_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ነፋሱም በርትቶ ሲያስጨንቀን በማንግሥቱ ከጭነቱ ወደ ባሕር ይጥሉ ነበር፥ ");
INSERT INTO amh_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","በሦስተኛውም ቀን የመርከቡን ዕቃ በእጃችን ወረወርን። ");
INSERT INTO amh_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ብዙ ቀንም ፀሐይን ከዋክብትንም ሳናይ ትልቅ ነፋስም ሲበረታብን ጊዜ፥ ወደ ፊት እንድናለን የማለት ተስፋ ሁሉ ተቈረጠ። ");
INSERT INTO amh_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ሳይበሉም ብዙ ቀን ከቆዩ በኋላ፥ ያን ጊዜ ጳውሎስ በመካከላቸው ቆሞ እንዲህ አለ። እናንተ ሰዎች ሆይ፥ ሰምታችሁኝ በሆነ ኖሮ ከቀርጤስ እንዳትነሡ ይህንም ጥፋትና ጕዳት እንዳታገኙ ይገባችሁ ነበር። ");
INSERT INTO amh_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","አሁንም። አይዞአችሁ ብዬ እመክራችኋለሁ፤ ይህ መርከብ እንጂ ከእናንተ አንድ ነፍስ እንኳ አይጠፋምና። ");
INSERT INTO amh_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","የእርሱ የምሆንና ደግሞ የማመልከው የእግዚአብሔር መልአክ በዚች ሌሊት በአጠገቤ ቆሞ ነበርና፥ እርሱም። ");
INSERT INTO amh_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ጳውሎስ ሆይ፥ አትፍራ፤ በቄሣር ፊት ልትቆም ይገባሃል፤ እነሆም፥ እግዚአብሔር ከአንተ ጋር የሚሄዱትን ሁሉ ሰጥቶሃል አለኝ። ");
INSERT INTO amh_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ስለዚህ እናንተ ሰዎች ሆይ፥ አይዞአችሁ፤ እንደ ተናገረኝ እንዲሁ እንዲሆን እግዚአብሔርን አምናለሁና። ");
INSERT INTO amh_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ነገር ግን ወደ አንዲት ደሴት እንድንወድቅ ያስፈልገናል። ");
INSERT INTO amh_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","በአሥራ አራተኛውም ሌሊት በአድርያ ባሕር ወዲህና ወዲያ ስንነዳ፥ መርከበኞች በእኩለ ሌሊት ወደ አንድ ምድር የቀረቡ መሰላቸው። ");
INSERT INTO amh_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","መለኪያ ገመድም ቢጥሉ ሀያ በሰው ቁመት አገኙ ጥቂትም ቆይተው ሁለተኛ ቢጥሉ አሥራ አምስት በሰው ቁመት አገኙ፤ ");
INSERT INTO amh_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ድንጋያማም ወደ ሆነ ስፍራ እንዳይወድቁ ፈርተው፥ ከመርከቡ በስተኋላ አራት መልሕቅ አወረዱ፥ ቀንም እንዲሆን ተመኙ። ");
INSERT INTO amh_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","መርከበኞቹም ከመርከቡ ይሸሹ ዘንድ ፈልገው ከመርከቡ በስተ ፊት መልሕቅ መጣል እንዳላቸው አመካኝተው ታንኳይቱን ወደ ባሕር ባወረዱ ጊዜ፥ ");
INSERT INTO amh_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ጳውሎስ ለመቶ አለቃውና ለወታደሮቹ። እነዚህ በመርከቡ ካልቆዩ እናንተ ትድኑ ዘንድ አትችሉም አላቸው። ");
INSERT INTO amh_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ያን ጊዜ ወታደሮቹ የታንኳይቱን ገመድ ቈርጠው ትወድቅ ዘንድ ተዉአት። ");
INSERT INTO amh_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ቀንም ሲነጋ ጳውሎስ ምግብ ይበሉ ዘንድ ሁሉን ይለምን ነበር፥ እንዲህም አላቸው። እየጠበቃችሁ ምንም ሳትቀበሉ ጦማችሁን ከሰነበታችሁ ዛሬ አሥራ አራተኛ ቀናችሁ ነው። ");
INSERT INTO amh_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ሰለዚህ ምግብ ትበሉ ዘንድ እለምናችኋለሁ፤ ይህ ለደኅንነታችሁ ይሆናልና፤ ከእናንተ ከአንዱ የራስ ጠጕር እንኳ አትጠፋምና። ");
INSERT INTO amh_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ይህንም ብሎ እንጀራን ይዞ በሁሉ ፊት እግዚአብሔርን አመሰገነ ቈርሶም ይበላ ዘንድ ጀመረ። ");
INSERT INTO amh_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ሁለም ተጽናንተው ራሳቸው ደግሞ ምግብ ተቀበሉ። ");
INSERT INTO amh_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","በመርከቡም ያለን ሁላችን ሁለት መቶ ሰባ ስድስት ነፍስ ነበርን። ");
INSERT INTO amh_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","በልተውም በጠገቡ ጊዜ ስንዴውን ወደ ባሕር እየጣሉ መርከቡን አቃለሉት። ");
INSERT INTO amh_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","በነጋም ጊዜ ምድሩን አላወቁትም፥ ነገር ግን የአሸዋ ዳር ያለውን የባሕር ስርጥ ተመለከቱ፥ ቢቻላቸውም መርከቡን ወደዚያ ይገፉ ዘንድ ቈረጡ። ");
INSERT INTO amh_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","መልሕቆቹንም ፈትተው በባሕር ተዉአቸው፥ ያን ጊዜም የመቅዘፊያውን ማሠሪያ ፈቱት፤ ታናሹንም ሸራ ለነፋስ ከፍ አድርገው ወደ ዳር አቅንተው ይሄዱ ዘንድ ጀመሩ። ");
INSERT INTO amh_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ነገር ግን ሁለት ባሕር በተገናኙበት ስፍራ ወድቀው መርከቡን በዲብ ላይ ነዱ፤ በስተ ፊቱም ተተክሎ የማይነቃነቅ ሆነ፥ በስተ ኋላው ግን ከማዕበሉ ግፊያ የተነሣ ይሰበር ነበር። ");
INSERT INTO amh_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ወታደሮቹም ከእስረኞች አንድ ስንኳ ዋኝቶ እንዳያመልጥ ይገድሉአቸው ዘንድ ተማከሩ። ");
INSERT INTO amh_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","የመቶ አለቃው ግን ጳውሎስን ያድነው ዘንድ አስቦ ምክራቸውን ከለከለ፤ ዋና የሚያውቁትም ከመርከብ ራሳቸውን እየወረወሩ አስቀድመው ወደ ምድር ይወጡ ዘንድ፥ ");
INSERT INTO amh_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","የቀሩትም እኵሌቶቹ በሳንቃዎች ላይ እኵሌቶቹም በመርከቡ ስባሪ ይወጡ ዘንድ አዘዘ። እንዲሁም ሁሉ በደኅና ወደ ምድር ደረሱ። ");
INSERT INTO amh_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","በደኅና ከደረስን በኋላ በዚያን ጊዜ ደሴቲቱ መላጥያ እንድትባል አወቅን። ");
INSERT INTO amh_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","አረማውያንም የሚያስገርም ቸርነት አደረጉልን፤ ዝናብ ስለ ሆነም ስለ ብርዱም እሳት አንድደው ሁላችንን ተቀበሉን። ");
INSERT INTO amh_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ጳውሎስ ግን ብዙ ጭራሮ አከማችቶ ወደ እሳት ሲጨምር እፉኝት ከሙቀት የተነሣ ወጥታ እጁን ነደፈችው። ");
INSERT INTO amh_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","አረማውያንም እባብ በእጁ ተንጠልጥላ ባዩ ጊዜ፥ እርስ በርሳቸው። ይህ ሰው በእርግጥ ነፍሰ ገዳይ ነው፥ ከባሕርም ስንኳ በደኅና ቢወጣ የእግዚአብሔር ፍርድ በሕይወት ይኖር ዘንድ አልተወውም አሉ። ");
INSERT INTO amh_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","እርሱ ግን እባቢቱን ወደ እሳት አራገፋት አንዳችም አልጐዳችውም፤ ");
INSERT INTO amh_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","እነርሱም። ሊያብጥ ወይም ወዲያው ሞቶ ሊወድቅ ነው ብለው ይጠባበቁት ነበር ብዙ ጊዜ ግን ሲጠባበቁ በእርሱ ላይ የሚያስገርም ነገር ምንም ባላዩ ጊዜ። ይህስ አምላክ ነው ብለው አሳባቸውን ለወጡ። ");
INSERT INTO amh_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","በዚያም ስፍራ አጠገብ ፑፕልዮስ የሚሉት የደሴት አለቃ መሬት ነበረ፥ እርሱም እንግድነት ተቀብሎን ሦስት ቀን በፍቅር አሳደረን። ");
INSERT INTO amh_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","የፑፕልዮስም አባት በንዳድና በተቅማጥ ታሞ ተኝቶ ነበር፤ ጳውሎስም ወደ እርሱ ገብቶ ጸለየለት እጁንም በላዩ ጭኖ ፈወሰው። ");
INSERT INTO amh_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ይህም በሆነ ጊዜ የቀሩት ደግሞ በደሴቲቱ ደዌ የነበረባቸው እየመጡ ተፈወሱ፤ ");
INSERT INTO amh_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","በብዙ ክብርም ደግሞ አከበሩን፥ በተነሣንም ጊዜ በመርከብ ላይ የሚያስፈልገንን ነገር አኖሩልን። ");
INSERT INTO amh_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ከሦስት ወርም በኋላ በደሴቲቱ ከርሞ በነበረው በእስክንድርያው መርከብ ተነሣን፥ በእርሱም የዲዮስቆሮስ አላማ ነበረበት። ");
INSERT INTO amh_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ወደ ሰራኩስም በገባን ጊዜ ሦስት ቀን ተቀመጥን፤ ");
INSERT INTO amh_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ከዚያም እየተዛወርን ወደ ሬጊዩም ደረስን። ከአንድ ቀን በኋላም የደቡብ ነፋስ በነፈሰ ጊዜ በሁለተኛው ቀን ወደ ፑቲዮሉስ መጣን። ");
INSERT INTO amh_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","በዚያም ወንድሞችን አግኝተን በእነርሱ ዘንድ ሰባት ቀን እንድንቀመጥ ለመኑን፤ እንዲሁም ወደ ሮሜ መጣን። ");
INSERT INTO amh_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ከዚያም ወንድሞች ስለ እኛ ሰምተው እስከ አፍዩስ ፋሩስና ሦስት ማደሪያ እስከሚባለው ሊቀበሉን ወጡ፥ ጳውሎስም ባያቸው ጊዜ እግዚአብሔርን አመሰገነ ልቡም ተጽናና። ");
INSERT INTO amh_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ወደ ሮሜም በገባን ጊዜ ጳውሎስ ከሚጠብቀው ወታደር ጋር ለብቻው ይቀመጥ ዘንድ ተፈቀደለት። ");
INSERT INTO amh_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ከሦስት ቀንም በኋላ ጳውሎስ የአይሁድን ታላላቆች ወደ እርሱ ጠራ፤ በተሰበሰቡም ጊዜ እንዲህ አላቸው። ወንድሞች ሆይ፥ እኔ ሕዝቡን ወይም የአባቶችን ሥርዓት የሚቃወም አንዳች ሳላደርግ፥ ከኢየሩሳሌም እንደ ታሰርሁ በሮማውያን እጅ አሳልፈው ሰጡኝ። ");
INSERT INTO amh_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","እነርሱም መርምረው ለሞት የሚገባ ምክንያት ስላልነበረብኝ ሊፈቱኝ አሰቡ፤ ");
INSERT INTO amh_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","አይሁድ ግን በተቃወሙ ጊዜ፥ ወደ ቄሣር ይግባኝ እንድል ግድ ሆነብኝ እንጂ ሕዝቤን የምከስበት ነገር ኖሮኝ አይደለም። ");
INSERT INTO amh_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ስለዚህም ምክንያት አያችሁና እነግራችሁ ዘንድ ጠራኋችሁ፤ ስለ እስራኤል ተስፋ ይህን ሰንሰለት ለብሻለሁና። ");
INSERT INTO amh_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","እነርሱም። እኛ ከይሁዳ ስለ አንተ ደብዳቤ አልተቀበልንም፥ ከወንድሞችም አንድ ስንኳ መጥቶ ስለ አንተ ክፉ ነገር አላወራልንም ወይም አልተናገረብህም። ");
INSERT INTO amh_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ነገር ግን ስለዚህ ወገን በየስፍራው ሁሉ እንዲቃወሙ በእኛ ዘንድ ታውቆአልና የምታስበውን ከአንተ እንሰማ ዘንድ እንፈቅዳለን አሉት። ");
INSERT INTO amh_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ቀንም ቀጥረውለት ብዙ ሆነው ወደ መኖሪያው ወደ እርሱ መጡ፤ ስለ እግዚአብሔር መንግሥትም እየመሰከረ ስለ ኢየሱስም ከሙሴ ሕግና ከነቢያት ጠቅሶ እያስረዳቸው፥ ከጥዋት ጀምሮ እስከ ማታ ድረስ ይገልጥላቸው ነበር። ");
INSERT INTO amh_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","እኵሌቶቹም የተናገረውን አመኑ፥ እኵሌቶቹ ግን አላመኑም፤ ");
INSERT INTO amh_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","እርስ በርሳቸውም ባልተስማሙ ጊዜ፥ ጳውሎስ አንዲት ቃል ከተናገረ በኋላ ሄዱ፤ እንዲህም አለ። መንፈስ ቅዱስ በነቢዩ በኢሳይያስ ለአባቶቻችን። ");
INSERT INTO amh_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","ወደዚህ ሕዝብ ሂድና። መስማትን ትሰማላችሁና አታስተውሉም፥ ማየትንም ታያላችሁና አትመለከቱም፤ ");
INSERT INTO amh_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","በዓይናቸው እንዳያዩ በጆሮአቸው እንዳይሰሙ በልባቸውም እንዳያስተውሉ ተመልሰውም እንዳልፈውሳቸው፥ የዚህ ሕዝብ ልብ ደንድኖአል ጆሮአቸውም ደንቁሮአል ዓይናቸውንም ጨፍነዋል በላቸው ");
INSERT INTO amh_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ሲል መልካም ተናገረ። እንግዲህ ይህ የእግዚአብሔር ደኅንነት ለአሕዛብ እንደ ተላከ በእናንተ ዘንድ የታወቀ ይሁን፤ እነርሱ ደግሞ ይሰሙታል። ");
INSERT INTO amh_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ይህንም በተናገረ ጊዜ አይሁድ እርስ በርሳቸው እጅግ እየተከራከሩ ሄዱ። ");
INSERT INTO amh_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ጳውሎስም በተከራየው ቤት ሁለት ዓመት ሙሉ ተቀመጠ፥ ወደ እርሱም የሚመጡትን ሁሉ ይቀበል ነበር፤ ");
INSERT INTO amh_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ማንም ሳይከለክለው የእግዚአብሔርን መንግሥት እየሰበከ ስለ ጌታ ስለ ኢየሱስ ክርስቶስ እጅግ ገልጦ ያስተምር ነበር። ");
INSERT INTO amh_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","5","በእርሱም ስለ ስሙ በአሕዛብ ሁሉ መካከል ከእምነት የሚነሣ መታዘዝ እንዲገኝ ጸጋንና ሐዋርያነትን ተቀበልን፤ ");
INSERT INTO amh_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","በእነርሱም መካከል የኢየሱስ ክርስቶስ ልትሆኑ የተጠራችሁ እናንተ ደግሞ ናችሁ። ");
INSERT INTO amh_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","በእግዚአብሔር ለተወደዳችሁና ቅዱሳን ልትሆኑ ለተጠራችሁ በሮሜ ላላችሁት ሁሉ፥ ከእግዚአብሔር ከአባታችን ከጌታም ከኢየሱስ ክርስቶስ ጸጋና ሰላም ለእናንተ ይሁን። ");
INSERT INTO amh_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","እምነታችሁ በዓለም ሁሉ ስለ ተሰማች አስቀድሜ ስለ ሁላችሁ አምላኬን በኢየሱስ ክርስቶስ አመሰግናለሁ። ");
INSERT INTO amh_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","11","ትጸኑ ዘንድ መንፈሳዊ ስጦታ እንዳካፍላችሁ ላያችሁ እናፍቃለሁና፤ ");
INSERT INTO amh_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ይህንም ማለቴ በመካከላችን ባለች በእናንተና በእኔ እምነት አብረን በእናንተ እንድንጽናና ነው። ");
INSERT INTO amh_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ወንድሞች ሆይ፥ በሌሎቹ አሕዛብ ደግሞ እንደ ሆነ በእናንተም ፍሬ አገኝ ዘንድ ብዙ ጊዜ ወደ እናንተ ልመጣ እንዳሰብሁ እስከ አሁን ግን እንደ ተከለከልሁ ታውቁ ዘንድ እወዳለሁ። ");
INSERT INTO amh_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ለግሪክ ሰዎችና ላልተማሩም፥ ለጥበበኞችና ለማያስተውሉም ዕዳ አለብኝ፤ ");
INSERT INTO amh_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ስለዚህም በሚቻለኝ መጠን በሮሜ ላላችሁ ለእናንተ ደግሞ ወንጌልን ልሰብክ ተዘጋጅቼአለሁ። ");
INSERT INTO amh_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","በወንጌል አላፍርምና፤ አስቀድሞ ለአይሁዳዊ ደግሞም ለግሪክ ሰው፥ ለሚያምኑ ሁሉ የእግዚአብሔር ኃይል ለማዳን ነውና። ");
INSERT INTO amh_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ጻድቅ በእምነት ይኖራል ተብሎ እንደ ተጻፈ የእግዚአብሔር ጽድቅ ከእምነት ወደ እምነት በእርሱ ይገለጣልና። ");
INSERT INTO amh_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","እውነትን በዓመፃ በሚከለክሉ ሰዎች በኃጢአተኝነታቸውና በዓመፃቸው ሁሉ ላይ የእግዚአብሔር ቍጣ ከሰማይ ይገለጣልና፤ ");
INSERT INTO amh_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","እግዚአብሔር ስለ ገለጠላቸው፥ ስለ እግዚአብሔር ሊታወቅ የሚቻለው በእነርሱ ዘንድ ግልጥ ነውና። ");
INSERT INTO amh_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","22","ጥበበኞች ነን ሲሉ ደንቆሮ ሆኑ፥ ");
INSERT INTO amh_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","የማይጠፋውንም የእግዚአብሔር ክብር በሚጠፋ ሰውና በወፎች አራት እግር ባላቸውም በሚንቀሳቀሱትም መልክ መስለው ለወጡ። ");
INSERT INTO amh_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ስለዚህ እርስ በርሳቸው ሥጋቸውን ሊያዋርዱ እግዚአብሔር በልባቸው ፍትወት ወደ ርኵስነት አሳልፎ ሰጣቸው፤ ");
INSERT INTO amh_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ይህም የእግዚአብሔርን እውነት በውሸት ስለ ለወጡ በፈጣሪም ፈንታ የተፈጠረውን ስላመለኩና ስላገለገሉ ነው፤ እርሱም ለዘላለም የተባረከ ነው፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ስለዚህ እግዚአብሔር ለሚያስነውር ምኞት አሳልፎ ሰጣቸው፤ ሴቶቻቸውም ለባሕርያቸው የሚገባውን ሥራ ለባሕርያቸው በማይገባው ለወጡ፤ ");
INSERT INTO amh_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","እንዲሁም ወንዶች ደግሞ ለባሕርያቸው የሚገባውን ሴቶችን መገናኘት ትተው እርስ በርሳቸው በፍትወታቸው ተቃጠሉ፤ ወንዶችም በወንዶች ነውር አድርገው በስሕተታቸው የሚገባውን ብድራት በራሳቸው ተቀበሉ። ");
INSERT INTO amh_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","እግዚአብሔርን ለማወቅ ባልወደዱት መጠን እግዚአብሔር የማይገባውን ያደርጉ ዘንድ ለማይረባ አእምሮ አሳልፎ ሰጣቸው፤ ");
INSERT INTO amh_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ዓመፃ ሁሉ፥ ግፍ፥ መመኘት፥ ክፋት ሞላባቸው፤ ቅናትን፥ ነፍስ መግደልን፥ ክርክርን፥ ተንኰልን፥ ክፉ ጠባይን ተሞሉ፤ የሚያሾከሹኩ፥ ");
INSERT INTO amh_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ሐሜተኞች፥ አምላክን የሚጠሉ፥ የሚያንገላቱ፥ ትዕቢተኞች፥ ትምክህተኞች፥ ክፋትን የሚፈላለጉ፥ ለወላጆቻቸው የማይታዘዙ፥ ");
INSERT INTO amh_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","የማያስተውሉ፥ ውል የሚያፈርሱ፥ ፍቅር የሌላቸው፥ ምሕረት ያጡ ናቸው፤ ");
INSERT INTO amh_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","እንደነዚህ ለሚያደርጉት ሞት ይገባቸዋል የሚለውን የእግዚአብሔርን ሕግ እያወቁ እነዚህን ከሚያደርጉ ጋር ይስማማሉ እንጂ አድራጊዎች ብቻ አይደሉም። ");
INSERT INTO amh_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ስለዚህ፥ አንተ የምትፈርድ ሰው ሁሉ ሆይ፥ የምታመካኘው የለህም፤ በሌላው በምትፈርድበት ነገር ራስህን ትኰንናለህና፤ አንተው ፈራጁ እነዚያን ታደርጋለህና። ");
INSERT INTO amh_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","እንደዚህም በሚያደርጉት ላይ የእግዚአብሔር ፍርድ እውነተኛ እንደ ሆነ እናውቃለን። ");
INSERT INTO amh_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","አንተም እንደዚህ በሚያደርጉ የምትፈርድ ያንም የምታደርግ ሰው ሆይ፥ አንተ ከእግዚአብሔር ፍርድ የምታመልጥ ይመስልሃልን? ");
INSERT INTO amh_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ወይስ የእግዚአብሔር ቸርነት ወደ ንስሐ እንዲመራህ ሳታውቅ የቸርነቱንና የመቻሉን የትዕግሥቱንም ባለጠግነት ትንቃለህን? ");
INSERT INTO amh_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ነገር ግን እንደ ጥንካሬህና ንስሐ እንደማይገባ ልብህ የእግዚአብሔር ቅን ፍርድ በሚገለጥበት በቍጣ ቀን ቍጣን በራስህ ላይ ታከማቻለህ። ");
INSERT INTO amh_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","እርሱ ለእያንዳንዱ እንደ ሥራው ያስረክበዋል፤ ");
INSERT INTO amh_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","በበጎ ሥራ በመጽናት ምስጋናንና ክብርን የማይጠፋንም ሕይወት ለሚፈልጉ የዘላለምን ሕይወት ይሰጣቸዋል፤ ");
INSERT INTO amh_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ለዓመፃ በሚታዘዙ እንጂ ለእውነት በማይታዘዙትና በአድመኞች ላይ ግን ቍጣና መቅሠፍት ይሆንባቸዋል። ");
INSERT INTO amh_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ክፉውን በሚያደርግ ሰው ነፍስ ሁሉ መከራና ጭንቀት ይሆንበታል፥ አስቀድሞ በአይሁዳዊ ደግሞም በግሪክ ሰው፤ ");
INSERT INTO amh_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ነገር ግን በጎ ሥራ ለሚያደርጉ ሁሉ ምስጋናና ክብር ሰላምም ይሆንላቸዋል፥ አስቀድሞ ለአይሁዳዊ ደግሞም ለግሪክ ሰው። ");
INSERT INTO amh_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","እግዚአብሔር ለሰው ፊት አያዳላምና። ");
INSERT INTO amh_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ያለ ሕግ ኃጢአት ያደረጉ ሁሉ ያለ ሕግ ደግሞ ይጠፋሉና፤ ሕግም ሳላቸው ኃጢአት ያደረጉ ሁሉ በሕግ ይፈረድባቸዋል፤ ");
INSERT INTO amh_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","በእግዚአብሔር ፊት ሕግን የሚያደርጉት ይጸድቃሉ እንጂ ሕግን የሚሰሙ ጻድቃን አይደሉምና። ");
INSERT INTO amh_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ሕግ የሌላቸው አሕዛብ ከባሕርያቸው የሕግን ትእዛዝ ሲያደርጉ፥ እነዚያ ሕግ ባይኖራቸው እንኳ ለራሳቸው ሕግ ናቸውና፤ ");
INSERT INTO amh_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","እነርሱም ሕሊናቸው ሲመሰክርላቸው፥ አሳባቸውም እርስ በርሳቸው ሲካሰስ ወይም ሲያመካኝ በልባቸው የተጻፈውን የሕግ ሥራ ያሳያሉ። ");
INSERT INTO amh_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ይህም እግዚአብሔር በኢየሱስ ክርስቶስ እኔ በወንጌል እንዳስተማርሁ በሰው ዘንድ የተሰወረውን በሚፈርድበት ቀን ይሆናል። ");
INSERT INTO amh_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","አንተ ግን አይሁዳዊ ብትባል በሕግም ብትደገፍ በእግዚአብሔርም ብትመካ፥ ");
INSERT INTO amh_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ፈቃዱንም ብታውቅ ከሕግም ተምረህ የሚሻለውን ፈትነህ ብትወድ፤ ");
INSERT INTO amh_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","21","እንግዲህ አንተ ሌላውን የምታስተምር ራስህን አታስተምርምን? አትስረቅ ብለህ የምትሰብክ ትሰርቃለህን? ");
INSERT INTO amh_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","አታመንዝር የምትል ታመነዝራለህን? ጣዖትን የምትጸየፍ ቤተ መቅደስን ትዘርፋለህን? ");
INSERT INTO amh_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","በሕግ የምትመካ ሕግን በመተላለፍ እግዚአብሔርን ታሳፍራለህን? ");
INSERT INTO amh_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","በእናንተ ሰበብ የእግዚአብሔር ስም በአሕዛብ መካከል ይሰደባልና ተብሎ እንደ ተጻፈ። ");
INSERT INTO amh_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ሕግን ብታደርግ መገረዝስ ይጠቅማል፤ ሕግን ተላላፊ ብትሆን ግን መገረዝህ አለ መገረዝ ሆኖአል። ");
INSERT INTO amh_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","እንግዲህ ያልተገረዘ ሰው የሕግን ሥርዓት ቢጠብቅ አለመገረዙ እንደ መገረዝ ሆኖ አይቈጠርለትምን? ");
INSERT INTO amh_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ከፍጥረቱም ያልተገረዘ ሕግን የሚፈጽም ሰው የሕግ መጽሐፍና መገረዝ ሳለህ ሕግን በምትተላለፈው በአንተ ይፈርድብሃል። ");
INSERT INTO amh_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","በግልጥ አይሁዳዊ የሆነ አይሁዳዊ አይደለምና፥ በግልጥ በሥጋ የሚደረግ መገረዝም መገረዝ አይደለምና፤ ");
INSERT INTO amh_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ዳሩ ግን በስውር አይሁዳዊ የሆነ አይሁዳዊ ነው፥ መገረዝም በመንፈስ የሚደረግ የልብ መገረዝ ነው እንጂ በመጽሐፍ አይደለም፤ የእርሱ ምስጋና ከእግዚአብሔር ነው እንጂ ከሰው አይደለም። ");
INSERT INTO amh_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","እንግዲህ የአይሁዳዊ ብልጫው ምንድር ነው? ወይስ የመገረዝ ጥቅሙ ምንድር ነው? በሁሉ ነገር ብዙ ነው። ");
INSERT INTO amh_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","አስቀድሞ የእግዚአብሔር ቃላት አደራ ተሰጡአቸው። ታዲያ ምንድር ነው? ");
INSERT INTO amh_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","የማያምኑ ቢኖሩ አለማመናቸው የእግዚአብሔርን ታማኝነት ያስቀራልን? ");
INSERT INTO amh_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","እንዲህ አይሁን፤ በቃልህ ትጸድቅ ዘንድ ወደ ፍርድ በገባህም ጊዜ ትረታ ዘንድ ተብሎ እንደ ተጻፈ፥ ሰው ሁሉ ውሸተኛ ከሆነ እግዚአብሔር እውነተኛ ይሁን። ");
INSERT INTO amh_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ነገር ግን ዓመፃችን የእግዚአብሔርን ጽድቅ የሚያስረዳ ከሆነ ምን እንላለን? ቍጣን የሚያመጣ እግዚአብሔር ዓመፀኛ ነውን? እንደ ሰው ልማድ እላለሁ። ");
INSERT INTO amh_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","እንዲህ አይሁን፤ እንዲህ ቢሆን እግዚአብሔር በዓለም እንዴት ይፈርዳል? ");
INSERT INTO amh_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","በእኔ ውሸት ግን የእግዚአብሔር እውነት ለክብሩ ከላቀ ስለምን በእኔ ደግሞ እንደ ኃጢአተኛ ገና ይፈርድብኛል? ");
INSERT INTO amh_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ስለ ምንስ መልካም እንዲመጣ ክፉ አናደርግም? እንዲሁ ይሰድቡናልና አንዳንዱም እንዲሁ እንድንል ይናገራሉና። የእነርሱም ፍርድ ቅን ነው። ");
INSERT INTO amh_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","እንግዲህ ምን ይሁን? ከእነርሱ እንበልጣለንን? ከቶ አይደለም፤ አይሁድም የግሪክ ሰዎችም ሁሉ ከኃጢአት በታች እንደ ሆኑ አስቀድመን ከሰናቸዋልና፤ ");
INSERT INTO amh_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","እንዲህ ተብሎ እንደ ተጻፈ። ");
INSERT INTO amh_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ጻድቅ የለም አንድ ስንኳ፤ አስተዋይም የለም፤ እግዚአብሔርንም የሚፈልግ የለም፤ ሁሉ ተሳስተዋል፥ ");
INSERT INTO amh_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","በአንድነትም የማይጠቅሙ ሆነዋል፤ ቸርነት የሚያደርግ የለም፥ አንድ ስንኳ የለም። ");
INSERT INTO amh_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ጕሮሮአቸው እንደ ተከፈተ መቃብር ነው፥ በመላሳቸውም ሸንግለዋል፤ የእባብ መርዝ ከከንፈሮቻቸው በታች አለ፤ ");
INSERT INTO amh_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","አፋቸውም እርግማንና መራርነት ሞልቶበታል፤ ");
INSERT INTO amh_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","እግሮቻቸው ደምን ለማፍሰስ ፈጣኖች ናቸው፤ ");
INSERT INTO amh_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ጥፋትና ጉስቁልና በመንገዳቸው ይገኛል፥ ");
INSERT INTO amh_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","19","አፍም ሁሉ ይዘጋ ዘንድ ዓለምም ሁሉ ከእግዚአብሔር ፍርድ በታች ይሆን ዘንድ ሕግ የሚናገረው ሁሉ ከሕግ በታች ላሉት እንዲናገር እናውቃለን፤ ");
INSERT INTO amh_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ይህም የሕግን ሥራ በመሥራት ሥጋ የለበሰ ሁሉ በእርሱ ፊት ስለማይጸድቅ ነው፤ ኃጢአት በሕግ ይታወቃልና። ");
INSERT INTO amh_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","አሁን ግን በሕግና በነቢያት የተመሰከረለት የእግዚአብሔር ጽድቅ ያለ ሕግ ተገልጦአል፥ ");
INSERT INTO amh_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","እርሱም፥ ለሚያምኑ ሁሉ የሆነ፥ በኢየሱስ ክርስቶስ በማመን የሚገኘው የእግዚአብሔር ጽድቅ ነው፤ ልዩነት የለምና፤ ");
INSERT INTO amh_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ሁሉ ኃጢአትን ሠርተዋልና የእግዚአብሔርም ክብር ጎድሎአቸዋል፤ ");
INSERT INTO amh_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","በኢየሱስ ክርስቶስም በሆነው ቤዛነት በኩል እንዲያው በጸጋው ይጸድቃሉ። ");
INSERT INTO amh_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","እርሱንም እግዚአብሔር በእምነት የሚገኝ በደሙም የሆነ ማስተስሪያ አድርጎ አቆመው፤ ይህም በፊት የተደረገውን ኃጢአት በእግዚአብሔር ችሎታ ስለ መተው ጽድቁን ያሳይ ዘንድ ነው፥ ");
INSERT INTO amh_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ራሱም ጻድቅ እንዲሆን በኢየሱስም የሚያምነውን እንዲያጸድቅ አሁን በዚህ ዘመን ጽድቁን ያሳይ ዘንድ ነው። ");
INSERT INTO amh_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ትምክህት እንግዲህ ወዴት ነው? እርሱ ቀርቶአል። በየትኛው ሕግ ነው? በሥራ ሕግ ነውን? አይደለም፥ በእምነት ሕግ ነው እንጂ። ");
INSERT INTO amh_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ሰው ያለ ሕግ ሥራ በእምነት እንዲጸድቅ እንቆጥራለንና። ");
INSERT INTO amh_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","31","እንግዲህ ሕግን በእምነት እንሽራለንን? አይደለም፤ ሕግን እናጸናለን እንጂ። ");
INSERT INTO amh_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","እንግዲህ በሥጋ አባታችን የሆነ አብርሃም ምን አገኘ እንላለን? ");
INSERT INTO amh_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","አብርሃም በሥራ ጸድቆ ቢሆን የሚመካበት አለውና፥ ነገር ግን በእግዚአብሔር ዘንድ አይደለም። ");
INSERT INTO amh_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","መጽሐፍስ ምን አለ? አብርሃምም እግዚአብሔርን አመነ ጽድቅም ሆኖ ተቈጠረለት። ");
INSERT INTO amh_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","ለሚሠራ ደመወዝ እንደ ዕዳ ነው እንጂ እንደ ጸጋ አይቈጠርለትም፤ ");
INSERT INTO amh_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","ነገር ግን ለማይሠራ፥ ኃጢአተኛውንም በሚያደድቅ ለሚያምን ሰው እምነቱ ጽድቅ ሆኖ ይቆጠርለታል። ");
INSERT INTO amh_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","እንደዚህ ዳዊት ደግሞ እግዚአብሔር ያለ ሥራ ጽድቅን ስለሚቆጥርለት ስለ ሰው ብፅዕና ይናገራል እንዲህ ሲል። ");
INSERT INTO amh_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","ዓመፃቸው የተሰረየላቸው ኃጢአታቸውም የተከደነላቸው ብፁዓን ናቸው፤ ");
INSERT INTO amh_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ጌታ ኃጢአቱን የማይቆጥርበት ሰው ብፁዕ ነው። ");
INSERT INTO amh_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","እንግዲህ ይህ ብፅዕና ስለ መገረዝ ተነገረ? ወይስ ደግሞ ስለ አለመገረዝ? እምነቱ ለአብርሃም ጽድቅ ሆኖ ተቆጠረለት እንላለንና። ");
INSERT INTO amh_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","እንዴት ተቆጠረለት? ተገርዞ ሳለ ነውን? ወይስ ሳይገረዝ? ተገርዞስ አይደለም፥ ሳይገረዝ ነበር እንጂ። ");
INSERT INTO amh_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","ሳይገረዝም በነበረው እምነት ያገኘው የጽድቅ ማኅተም የሆነ የመገረዝን ምልክት ተቀበለ፤ ይህም እነርሱ ደግሞ ጻድቃን ሆነው ይቆጠሩ ዘንድ ሳይገረዙ ለሚያምኑ ሁሉ አባት እንዲሆን ነው፥ ");
INSERT INTO amh_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ለተገረዙትም አባት እንዲሆን ነው፤ ይኸውም ለተገረዙት ብቻ አይደለም ነገር ግን አባታችን አብርሃም ሳይገረዝ የነበረውን የእምነቱን ፍለጋ ደግሞ ለሚከተሉ ነው። ");
INSERT INTO amh_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","የዓለምም ወራሽ እንዲሆን ለአብርሃምና ለዘሩ የተሰጠው የተስፋ ቃል በእምነት ጽድቅ ነው እንጂ በሕግ አይደለም። ");
INSERT INTO amh_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ከሕግ የሆኑትስ ወራሾች ከሆኑ እምነት ከንቱ ሆኖአል የተስፋውም ቃል ተሽሮአል፤ ");
INSERT INTO amh_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ሕጉ መቅሠፍትን ያደርጋልና፤ ነገር ግን ሕግ በሌለበት መተላለፍ የለም። ");
INSERT INTO amh_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","18","ዘርህ እንዲሁ ሊሆን ነው እንደ ተባለ፥ ተስፋ ባልሆነው ጊዜ የብዙ አሕዛብ አባት እንዲሆን ተስፋ ይዞ አመነ። ");
INSERT INTO amh_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","የመቶ ዓመትም ሽማግሌ ስለ ሆነ እንደ ምውት የሆነውን የራሱን ሥጋና የሳራ ማኅፀን ምውት መሆኑን በእምነቱ ሳይደክም ተመለከተ፤ ");
INSERT INTO amh_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","22","ስለዚህ ደግሞ ጽድቅ ሆኖ ተቆጠረለት። ");
INSERT INTO amh_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","25","ነገር ግን። ተቈጠረለት የሚለው ቃል ስለ እርሱ ብቻ የተጻፈ አይደለም፥ ስለ እኛም ነው እንጂ፤ ");
INSERT INTO amh_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","እንግዲህ በእምነት ከጸደቅን በእግዚአብሔር ዘንድ በጌታችን በኢየሱስ ክርስቶስ ሰላምን እንያዝ፤ ");
INSERT INTO amh_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","በእርሱም ደግሞ ወደ ቆምንበት ወደዚህ ጸጋ በእምነት መግባትን አግኝተናል፤ በእግዚአብሔር ክብርም ተስፋ እንመካለን። ");
INSERT INTO amh_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","5","በተሰጠንም በመንፈስ ቅዱስ የእግዚአብሔር ፍቅር በልባችን ስለ ፈሰሰ ተስፋ አያሳፍርም። ");
INSERT INTO amh_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ገና ደካሞች ሳለን ክርስቶስ ዘመኑ ሲደርስ ስለ ኃጢአተኞች ሞቶአልና። ");
INSERT INTO amh_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ስለ ጻድቅ የሚሞት በጭንቅ ይገኛልና፤ ስለ ቸር ሰው ግን ሊሞት እንኳ የሚደፍር ምናልባት ይገኝ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","ነገር ግን ገና ኃጢአተኞች ሳለን ክርስቶስ ስለ እኛ ሞቶአልና እግዚአብሔር ለእኛ ያለውን የራሱን ፍቅር ያስረዳል። ");
INSERT INTO amh_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ይልቁንስ እንግዲህ አሁን በደሙ ከጸደቅን በእርሱ ከቍጣው እንድናለን። ");
INSERT INTO amh_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ጠላቶች ሳለን ከእግዚአብሔር ጋር በልጁ ሞት ከታረቅን፥ ይልቁንም ከታረቅን በኋላ በሕይወቱ እንድናለን፤ ");
INSERT INTO amh_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ይህም ብቻ አይደለም፥ ነገር ግን አሁን መታረቁን ባገኘንበት በጌታችን በኢየሱስ ክርስቶስ በኩል በእግዚአብሔር ደግሞ እንመካለን። ");
INSERT INTO amh_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","ስለዚህ ምክንያት ኃጢአት በአንድ ሰው ወደ ዓለም ገባ በኃጢአትም ሞት፥ እንደዚሁም ሁሉ ኃጢአትን ስላደረጉ ሞት ለሰው ሁሉ ደረሰ፤ ");
INSERT INTO amh_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ሕግ እስከ መጣ ድረስ ኃጢአት በዓለም ነበረና ነገር ግን ሕግ በሌለበት ጊዜ ኃጢአት አይቈጠርም፤ ");
INSERT INTO amh_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ነገር ግን በአዳም መተላለፍ ምሳሌ ኃጢአትን ባልሠሩት ላይ እንኳ፥ ከአዳም ጀምሮ እስከ ሙሴ ድረስ ሞት ነገሠ፤ አዳም ይመጣ ዘንድ ላለው ለእርሱ አምሳሉ ነውና። ");
INSERT INTO amh_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","ነገር ግን ስጦታው እንደ በደሉ መጠን እንደዚያው አይደለም፤ በአንድ ሰው በደል ብዙዎቹ ሞተዋልና፥ ነገር ግን የእግዚአብሔር ጸጋና በአንድ ሰው በኢየሱስ ክርስቶስ ጸጋ የሆነው ስጦታ ከዚያ ይልቅ ለብዙዎች በዛ። ");
INSERT INTO amh_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","አንድ ሰውም ኃጢአትን በማድረጉ እንደ ሆነው መጠን እንደዚያው ስጦታው አይደለም፤ ፍርድ ከአንድ ሰው ለኵነኔ መጥቶአልና፥ ስጦታው ግን በብዙ በደል ለማጽደቅ መጣ። ");
INSERT INTO amh_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","በአንዱም በደል ሞት በአንዱ በኩል ከነገሠ፥ ይልቁን የጸጋን ብዛትና የጽድቅን ስጦታ ብዛት የሚቀበሉ በአንዱ በኢየሱስ ክርስቶስ በኩል በሕይወት ይነግሣሉ። ");
INSERT INTO amh_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","እንግዲህ በአንድ በደል ምክንያት ፍርድ ለኵነኔ ወደ ሰው ሁሉ እንደ መጣ፥ እንዲሁም በአንድ ጽድቅ ምክንያት ስጦታው ሕይወትን ለማጽደቅ ወደ ሰው ሁሉ መጣ። ");
INSERT INTO amh_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","21","በአንዱ ሰው አለመታዘዝ ብዙዎች ኃጢአተኞች እንደ ሆኑ፥ እንዲሁ ደግሞ በአንዱ መታዘዝ ብዙዎች ጻድቃን ይሆናሉ። ");
INSERT INTO amh_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","እንግዲህ ምን እንላለን? ጸጋ እንዲበዛ በኃጢአት ጸንተን እንኑርን? አይደለም። ");
INSERT INTO amh_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","ለኃጢአት የሞትን እኛ ወደ ፊት እንዴት አድርገን በእርሱ እንኖራለን? ");
INSERT INTO amh_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ወይስ ከክርስቶስ ኢየሱስ ጋር አንድ እንሆን ዘንድ የተጠመቅን ሁላችን ከሞቱ ጋር አንድ እንሆን ዘንድ እንደ ተጠመቅን አታውቁምን? ");
INSERT INTO amh_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","እንግዲህ ክርስቶስ በአብ ክብር ከሙታን እንደ ተነሣ እንዲሁ እኛም በአዲስ ሕይወት እንድንመላለስ፥ ከሞቱ ጋር አንድ እንሆን ዘንድ በጥምቀት ከእርሱ ጋር ተቀበርን። ");
INSERT INTO amh_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ሞቱንም በሚመስል ሞት ከእርሱ ጋር ከተባበርን ትንሣኤውን በሚመስል ትንሣኤ ደግሞ ከእርሱ ጋር እንተባበራለን፤ ");
INSERT INTO amh_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ከእንግዲህስ ወዲያ ለኃጢአት እንዳንገዛ የኃጢአት ሥጋ ይሻር ዘንድ አሮጌው ሰዋችን ከእርሱ ጋር እንደ ተሰቀለ እናውቃለን፤ የሞተስ ከኃጢአቱ ጸድቋልና። ");
INSERT INTO amh_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","9","ክርስቶስ ከሙታን ተነሥቶ ወደ ፊት እንዳይሞት ሞትም ወደ ፊት እንዳይገዛው እናውቃለንና። ");
INSERT INTO amh_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","መሞትን አንድ ጊዜ ፈጽሞ ለኃጢአት ሞቶአልና፤ በሕይወት መኖርን ግን ለእግዚአብሔር ይኖራል። ");
INSERT INTO amh_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","እንዲሁም እናንተ ደግሞ ለኃጢአት እንደ ሞታችሁ፥ ግን በክርስቶስ ኢየሱስ በጌታችን ሆናችሁ ለእግዚአብሔር ሕያዋን እንደ ሆናችሁ ራሳችሁን ቈጠሩ። ");
INSERT INTO amh_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","እንግዲህ ለምኞቱ እንድትታዘዙ በሚሞት ሥጋችሁ ኃጢአት አይንገሥ፤ ");
INSERT INTO amh_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ብልቶቻችሁንም የዓመፃ የጦር ዕቃ አድርጋችሁ ለኃጢአት አታቅርቡ፥ ነገር ግን ከሙታን ተለይታችሁ በሕይወት እንደምትኖሩ ራሳችሁን ለእግዚአብሔር አቅርቡ፥ ብልቶቻችሁንም የጽድቅ የጦር ዕቃ አድርጋችሁ ለእግዚአብሔር አቅርቡ። ");
INSERT INTO amh_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ኃጢአት አይገዛችሁምና፤ ከጸጋ በታች እንጂ ከሕግ በታች አይደላችሁምና። ");
INSERT INTO amh_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","እንግዲህ ምን ይሁን? ከጸጋ በታች እንጂ ከሕግ በታች ስላይደለን ኃጢአትን እንሥራን? አይደለም። ");
INSERT INTO amh_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ለመታዘዝ ባሪያዎች እንድትሆኑ ራሳችሁን ለምታቀርቡለት፥ ለእርሱ ለምትታዘዙለት ባሪያዎች እንደ ሆናችሁ አታውቁምን? ወይም ለሞት የኃጢአት ባሪያዎች ወይም ለጽድቅ የመታዘዝ ባሪያዎች ናችሁ። ");
INSERT INTO amh_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","19","ስለ ሥጋችሁ ድካም እንደ ሰው ልማድ እላለሁ። ብልቶቻችሁ ዓመፃ ሊያደርጉ ለርኵስነትና ለዓመፃ ባሪያዎች አድርጋችሁ እንዳቀረባችሁ፥ እንደዚሁ ብልቶቻችሁ ሊቀደሱ ለጽድቅ ባሪያዎች አድርጋችሁ አሁን አቅርቡ። ");
INSERT INTO amh_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","የኃጢአት ባሪያዎች ሳላችሁ ከጽድቅ ነፃ ነበራችሁና። ");
INSERT INTO amh_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","እንግዲህ ዛሬ ከምታፍሩበት ነገር ያን ጊዜ ምን ፍሬ ነበራችሁ? የዚህ ነገር መጨረሻው ሞት ነውና። ");
INSERT INTO amh_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","አሁን ግን ከኃጢአት አርነት ወጥታችሁ ለእግዚአብሔርም ተገዝታችሁ፥ ልትቀደሱ ፍሬ አላችሁ፤ መጨረሻውም የዘላለም ሕይወት ነው። ");
INSERT INTO amh_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","የኃጢአት ደመወዝ ሞት ነውና፤ የእግዚአብሔር የጸጋ ስጦታ ግን በክርስቶስ ኢየሱስ በጌታችን የዘላለም ሕይወት ነው። ");
INSERT INTO amh_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ወንድሞች ሆይ፥ ሕግን ለሚያውቁ እናገራለሁና ሰው ባለበት ዘመን ሁሉ ሕግ እንዲገዛው አታውቁምን? ");
INSERT INTO amh_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ያገባች ሴት ባልዋ በሕይወት ሲኖር ከእርሱ ጋር በሕግ ታስራለችና፤ ባልዋ ቢሞት ግን ስለ ባል ከሆነው ሕግ ተፈትታለች። ");
INSERT INTO amh_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ስለዚህ ባልዋ በሕይወት ሳለ ለሌላ ወንድ ብትሆን አመንዝራ ትባላለች፤ ባልዋ ቢሞት ግን ከሕጉ አርነት ወጥታለችና ለሌላ ወንድ ብትሆን አመንዝራ አይደለችም። ");
INSERT INTO amh_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","እንዲሁ፥ ወንድሞቼ ሆይ፥ እናንተ ደግሞ በክርስቶስ ሥጋ ለሕግ ተገድላችኋል፤ ለእግዚአብሔር ፍሬ እንድናፈራ፥ እናንተ ለሌላው፥ ከሙታን ለተነሣው፥ ለእርሱ ትሆኑ ዘንድ። ");
INSERT INTO amh_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","በሥጋ ሳለን በሕግ የሚሆን የኃጢአት መሻት ለሞት ፍሬ ሊያፈራ በብልቶቻችን ይሠራ ነበርና፤ ");
INSERT INTO amh_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","አሁን ግን ለእርሱ ለታሰርንበት ስለ ሞትን፥ ከሕግ ተፈትተናል፥ ስለዚህም በአዲሱ በመንፈስ ኑሮ እንገዛለን እንጂ በአሮጌው በፊደል ኑሮ አይደለም። ");
INSERT INTO amh_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","እንግዲህ ምን እንላለን? ሕግ ኃጢአት ነውን? አይደለም፤ ነገር ግን በሕግ ባይሆን ኃጢአትን ባላወቅሁም ነበር፤ ሕጉ። አትመኝ ባላለ ምኞትን ባላወቅሁም ነበርና። ");
INSERT INTO amh_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","ኃጢአት ግን ምክንያት አግኝቶ ምኞትን ሁሉ በትእዛዝ ሠራብኝ፤ ኃጢአት ያለ ሕግ ምውት ነውና። ");
INSERT INTO amh_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","እኔም ዱሮ ያለ ሕግ ሕያው ነበርሁ፤ ትእዛዝ በመጣች ጊዜ ግን ኃጢአት ሕያው ሆነ እኔም ሞትሁ፤ ");
INSERT INTO amh_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ለሕይወትም የተሰጠችውን ትእዛዝ እርስዋን ለሞት ሆና አገኘኋት፤ ");
INSERT INTO amh_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ኃጢአት ምክንያት አግኝቶ በትእዛዝ አታሎኛልና በእርስዋም ገድሎኛል። ");
INSERT INTO amh_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ስለዚህ ሕጉ ቅዱስ ነው ትእዛዚቱም ቅድስትና ጻድቅት በጎም ናት። ");
INSERT INTO amh_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","እንግዲህ በጎ የሆነው ነገር ለእኔ ሞት ሆነብኝን? አይደለም፥ ነገር ግን ኃጢአት ሆነ፤ ኃጢአትም በትእዛዝ ምክንያት ያለ ልክ ኃጢአተኛ ይሆን ዘንድ፥ ኃጢአትም እንዲሆን ይገለጥ ዘንድ በጎ በሆነው ነገር ለእኔ ሞትን ይሠራ ነበር። ");
INSERT INTO amh_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ሕግ መንፈሳዊ እንደ ሆነ እናውቃለንና፤ እኔ ግን ከኃጢአት በታች ልሆን የተሸጥሁ የሥጋ ነኝ። ");
INSERT INTO amh_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","የማደርገውን አላውቅምና፤ የምጠላውን ያን አደርጋለሁና ዳሩ ግን የምወደውን እርሱን አላደርገውም። ");
INSERT INTO amh_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","የማልወደውን ግን የማደርግ ከሆንሁ ሕግ መልካም እንደ ሆነ እመሰክራለሁ። ");
INSERT INTO amh_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","እንደዚህ ከሆነ ያን የማደርገው አሁን እኔ አይደለሁም፥ በእኔ የሚያድር ኃጢአት ነው እንጂ። ");
INSERT INTO amh_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","በእኔ ማለት በሥጋዬ በጎ ነገር እንዳይኖር አውቃለሁና፤ ፈቃድ አለኝና፥ መልካሙን ግን ማድረግ የለኝም። ");
INSERT INTO amh_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","የማልወደውን ክፉን ነገር አደርጋለሁና ዳሩ ግን የምወደውን በጎውን ነገር አላደርገውም። ");
INSERT INTO amh_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","የማልወደውን የማደርግ ከሆንሁ ግን ያን የማደርገው አሁን እኔ አይደለሁም፥ በእኔ የሚኖር ኃጢአት ነው እንጂ። ");
INSERT INTO amh_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","እንግዲያስ መልካሙን አደርግ ዘንድ ስወድ በእኔ ክፉ እንዲያድርብኝ ሕግን አገኛለሁ። ");
INSERT INTO amh_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","በውስጡ ሰውነቴ በእግዚአብሔር ሕግ ደስ ይለኛልና፥ ");
INSERT INTO amh_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ነገር ግን በብልቶቼ ከአእምሮዬ ሕግ ጋር የሚዋጋውንና በብልቶቼ ባለ በኃጢአት ሕግ የሚማርከኝን ሌላ ሕግ አያለሁ። ");
INSERT INTO amh_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","እኔ ምንኛ ጎስቋላ ሰው ነኝ! ለዚህ ሞት ከተሰጠ ሰውነት ማን ያድነኛል? ");
INSERT INTO amh_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","በኢየሱስ ክርስቶስ በጌታችን ለእግዚአብሔር ምስጋና ይሁን። እንግዲያስ እኔ በአእምሮዬ ለእግዚአብሔር ሕግ፥ በሥጋዬ ግን ለኃጢአት ሕግ እገዛለሁ። ");
INSERT INTO amh_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","እንግዲህ በክርስቶስ ኢየሱስ ላሉት አሁን ኵነኔ የለባቸውም። ");
INSERT INTO amh_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","በክርስቶስ ኢየሱስ ያለው የሕይወት መንፈስ ሕግ ከኃጢአትና ከሞት ሕግ አርነት አውጥቶኛልና። ");
INSERT INTO amh_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","5","እንደ ሥጋ ፈቃድ የሚኖሩ የሥጋን ነገር ያስባሉና፥ እንደ መንፈስ ፈቃድ የሚኖሩ ግን የመንፈስን ነገር ያስባሉ። ");
INSERT INTO amh_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ስለ ሥጋ ማሰብ ሞት ነውና፥ ስለ መንፈስ ማሰብ ግን ሕይወትና ሰላም ነው። ");
INSERT INTO amh_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","ስለ ሥጋ ማሰብ በእግዚአብሔር ዘንድ ጥል ነውና፤ ለእግዚአብሔር ሕግ አይገዛምና፥ መገዛትም ተስኖታል፤ ");
INSERT INTO amh_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","በሥጋ ያሉትም እግዚአብሔርን ደስ ሊያሰኙት አይችሉም። ");
INSERT INTO amh_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","እናንተ ግን የእግዚአብሔር መንፈስ በእናንተ ዘንድ ቢኖር፥ በመንፈስ እንጂ በሥጋ አይደላችሁም። የክርስቶስ መንፈስ የሌለው ከሆነ ግን ይኸው የእርሱ ወገን አይደለም። ");
INSERT INTO amh_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ክርስቶስ በእናንተ ውስጥ ቢሆን ሰውነታችሁ በኃጢአት ምክንያት የሞተ ነው፥ መንፈሳችሁ ግን በጽድቅ ምክንያት ሕያው ነው። ");
INSERT INTO amh_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ነገር ግን ኢየሱስን ከሙታን ያስነሣው የእርሱ መንፈስ በእናንተ ዘንድ ቢኖር፥ ክርስቶስ ኢየሱስን ከሙታን ያስነሣው እርሱ በእናንተ በሚኖረው በመንፈሱ፥ ለሚሞተው ሰውነታችሁ ደግሞ ሕይወትን ይሰጠዋል። ");
INSERT INTO amh_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","እንግዲህ፥ ወንድሞች ሆይ፥ ዕዳ አለብን፥ እንደ ሥጋ ፈቃድ ግን እንኖር ዘንድ ለሥጋ አይደለም። ");
INSERT INTO amh_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","እንደ ሥጋ ፈቃድ ብትኖሩ ትሞቱ ዘንድ አላችሁና፤ በመንፈስ ግን የሰውነትን ሥራ ብትገድሉ በሕይወት ትኖራላችሁ። ");
INSERT INTO amh_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","በእግዚአብሔር መንፈስ የሚመሩ ሁሉ እነዚህ የእግዚአብሔር ልጆች ናቸውና። ");
INSERT INTO amh_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","አባ አባት ብለን የምንጮኽበትን የልጅነት መንፈስ ተቀበላችሁ እንጂ እንደገና ለፍርሃት የባርነትን መንፈስ አልተቀበላችሁምና። ");
INSERT INTO amh_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","የእግዚአብሔር ልጆች መሆናችንን ያ መንፈስ ራሱ ከመንፈሳችን ጋር ይመሰክራል። ");
INSERT INTO amh_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ልጆች ከሆንን ወራሾች ደግሞ ነን፤ ማለት የእግዚአብሔር ወራሾች ነን፥ አብረንም ደግሞ እንድንከበር አብረን መከራ ብንቀበል ከክርስቶስ ጋር አብረን ወራሾች ነን። ");
INSERT INTO amh_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","ለእኛም ይገለጥ ዘንድ ካለው ክብር ጋር ቢመዛዘን የአሁኑ ዘመን ሥቃይ ምንም እንዳይደለ አስባለሁ። ");
INSERT INTO amh_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","የፍጥረት ናፍቆት የእግዚአብሔርን ልጆች መገለጥ ይጠባበቃልና። ");
INSERT INTO amh_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","ፍጥረት ለከንቱነት ተገዝቶአልና፥ በተስፋ ስላስገዛው ነው እንጂ በፈቃዱ አይደለም፤ ");
INSERT INTO amh_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ተስፋውም ፍጥረት ራሱ ደግሞ ከጥፋት ባርነት ነፃነት ወጥቶ ለእግዚአብሔር ልጆች ወደሚሆን ክብር ነፃነት እንዲደርስ ነው። ");
INSERT INTO amh_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","ፍጥረት ሁሉ እስከ አሁን ድረስ አብሮ በመቃተትና በምጥ መኖሩን እናውቃለንና። ");
INSERT INTO amh_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","እርሱም ብቻ አይደለም፥ ነገር ግን የመንፈስ በኵራት ያለን ራሳችን ደግሞ የሰውነታችን ቤዛ የሆነውን ልጅነት እየተጠባበቅን ራሳችን በውስጣችን እንቃትታለን። ");
INSERT INTO amh_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","በተስፋ ድነናልና፤ ነገር ግን ተስፋ የሚደረግበቱ ነገር ቢታይ ተስፋ አይደለም፤ የሚያየውንማ ማን ተስፋ ያደርገዋል? ");
INSERT INTO amh_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","የማናየውን ግን ተስፋ ብናደርገው በትዕግሥት እንጠባበቃለን። ");
INSERT INTO amh_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","እንዲሁም ደግሞ መንፈስ ድካማችንን ያግዛል፤ እንዴት እንድንጸልይ እንደሚገባን አናውቅምና፥ ነገር ግን መንፈስ ራሱ በማይነገር መቃተት ይማልድልናል፤ ");
INSERT INTO amh_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ልብንም የሚመረምረው የመንፈስ አሳብ ምን እንደ ሆነ ያውቃል፥ እንደ እግዚአብሔር ፈቃድ ስለ ቅዱሳን ይማልዳልና። ");
INSERT INTO amh_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","እግዚአብሔርንም ለሚወዱት እንደ አሳቡም ለተጠሩት ነገር ሁሉ ለበጎ እንዲደረግ እናውቃለን። ");
INSERT INTO amh_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ልጁ በብዙ ወንድሞች መካከል በኵር ይሆን ዘንድ፥ አስቀድሞ ያወቃቸው የልጁን መልክ እንዲመስሉ አስቀድሞ ደግሞ ወስኖአልና፤ ");
INSERT INTO amh_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","አስቀድሞም የወሰናቸውን እነዚህን ደግሞ ጠራቸው፤ የጠራቸውንም እነዚህን ደግሞ አጸደቃቸው፤ ያጸደቃቸውንም እነዚህን ደግሞ አከበራቸው። ");
INSERT INTO amh_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","እንግዲህ ስለዚህ ነገር ምን እንላለን? እግዚአብሔር ከእኛ ጋር ከሆነ ማን ይቃወመናል? ");
INSERT INTO amh_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ለገዛ ልጁ ያልራራለት ነገር ግን ስለ ሁላችን አሳልፎ የሰጠው ያው ከእርሱ ጋር ደግሞ ሁሉን ነገር እንዲያው እንዴት አይሰጠንም? ");
INSERT INTO amh_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","እግዚአብሔር የመረጣቸውን ማን ይከሳቸዋል? የሚያጸድቅ እግዚአብሔር ነው፥ የሚኰንንስ ማን ነው? ");
INSERT INTO amh_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","የሞተው፥ ይልቁንም ከሙታን የተነሣው፥ በእግዚአብሔር ቀኝ ያለው፥ ደግሞ ስለ እኛ የሚማልደው ክርስቶስ ኢየሱስ ነው። ");
INSERT INTO amh_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","ከክርስቶስ ፍቅር ማን ይለየናል? መከራ፥ ወይስ ጭንቀት፥ ወይስ ስደት፥ ወይስ ራብ፥ ወይስ ራቁትነት፥ ወይስ ፍርሃት፥ ወይስ ሰይፍ ነውን? ");
INSERT INTO amh_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","ስለ አንተ ቀኑን ሁሉ እንገደላለን፥ እንደሚታረዱ በጎች ተቆጠርን ተብሎ እንደ ተጻፈ ነው። ");
INSERT INTO amh_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","በዚህ ሁሉ ግን በወደደን በእርሱ ከአሸናፊዎች እንበልጣለን። ");
INSERT INTO amh_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","ሞት ቢሆን፥ ሕይወትም ቢሆን፥ መላእክትም ቢሆኑ፥ ግዛትም ቢሆን፥ ያለውም ቢሆን፥ የሚመጣውም ቢሆን፥ ኃይላትም ቢሆኑ፥ ");
INSERT INTO amh_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ከፍታም ቢሆን፥ ዝቅታም ቢሆን፥ ልዩ ፍጥረትም ቢሆን በክርስቶስ ኢየሱስ በጌታችን ካለ ከእግዚአብሔር ፍቅር ሊለየን እንዳይችል ተረድቼአለሁ። ");
INSERT INTO amh_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","3","በሥጋ ዘመዶቼ ስለ ሆኑ ስለ ወንድሞቼ ከክርስቶስ ተለይቼ እኔ ራሴ የተረገምሁ እንድሆን እጸልይ ነበርና። ");
INSERT INTO amh_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","እነርሱ እስራኤላውያን ናቸውና፥ ልጅነትና ክብር ኪዳንም የሕግም መሰጠት የመቅደስም ሥርዓት የተስፋውም ቃላት ለእነርሱ ናቸውና፤ ");
INSERT INTO amh_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","አባቶችም ለእነርሱ ናቸውና፤ ከእነርሱም ክርስቶስ በሥጋ መጣ፥ እርሱም ከሁሉ በላይ ሆኖ ለዘላለም የተባረከ አምላክ ነው፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ነገር ግን የእግዚአብሔር ቃል የተሻረ አይደለም። እነዚህ ከእስራኤል የሚወለዱ ሁሉ እስራኤል አይደሉምና፤ የአብርሃምም ዘር ስለሆኑ ሁላቸው ልጆች አይደሉም፥ ");
INSERT INTO amh_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ነገር ግን። በይስሐቅ ዘር ይጠራልሃል ተባለ። ");
INSERT INTO amh_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","ይህም፥ የተስፋ ቃል ልጆች ዘር ሆነው ይቆጠራሉ እንጂ እነዚህ የሥጋ ልጆች የሆኑ የእግዚአብሔር ልጆች አይደሉም ማለት ነው። ");
INSERT INTO amh_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ይህ። በዚህ ጊዜ እመጣለሁ ለሳራም ልጅ ይሆንላታል የሚል የተስፋ ቃል ነውና። ");
INSERT INTO amh_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","ይህ ብቻ አይደለም፥ ነገር ግን ርብቃ ደግሞ ከአንዱ ከአባታችን ከይስሐቅ በፀነሰች ጊዜ፥ ");
INSERT INTO amh_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","ልጆቹ ገና ሳይወለዱ፥ በጎ ወይም ክፉ ምንም ሳያደርጉ፥ ከጠሪው እንጂ ከሥራ ሳይሆን በምርጫ የሚሆን የእግዚአብሔር አሳብ ይጸና ዘንድ፥ ");
INSERT INTO amh_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ለእርስዋ። ታላቁ ለታናሹ ይገዛል ተባለላት። ");
INSERT INTO amh_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ያዕቆብን ወደድሁ ኤሳውን ግን ጠላሁ ተብሎ እንደ ተጻፈ ነው። ");
INSERT INTO amh_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","እንግዲህ ምን እንላለን? በእግዚአብሔር ዘንድ ዓመፃ አለ ወይ? አይደለም። ");
INSERT INTO amh_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","ለሙሴ። የምምረውን ሁሉ እምረዋለሁ ለምራራለትም ሁሉ እራራለታለሁ ይላልና። ");
INSERT INTO amh_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","እንግዲህ ምሕረት ለወደደ ወይም ለሮጠ አይደለም፥ ከሚምር ከእግዚአብሔር ነው እንጂ። ");
INSERT INTO amh_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","መጽሐፍ ፈርዖንን። ኃይሌን በአንተ አሳይ ዘንድ ስሜም በምድር ሁሉ ይነገር ዘንድ ለዚህ አስነሣሁህ ይላልና። ");
INSERT INTO amh_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","እንግዲህ የሚወደውን ይምረዋል፥ የሚወደውንም እልከኛ ያደርገዋል። ");
INSERT INTO amh_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","እንግዲህ ስለ ምን እስከ አሁን ድረስ ይነቅፋል? ፈቃዱንስ የሚቃወም ማን ነው? ትለኝ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ነገር ግን፥ አንተ ሰው ሆይ፥ ለእግዚአብሔር የምትመልስ ማን ነህ? ሥራ ሠሪውን። ስለ ምን እንዲህ አድርገህ ሠራኸኝ ይለዋልን? ");
INSERT INTO amh_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ወይም ሸክላ ሠሪ ከአንዱ ጭቃ ክፍል አንዱን ዕቃ ለክብር አንዱንም ለውርደት ሊሠራ በጭቃ ላይ ሥልጣን የለውምን? ");
INSERT INTO amh_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","24","የምሕረቱ ዕቃዎችም ከአይሁድ ብቻ አይደሉም፥ ነገር ግን ከአሕዛብ ደግሞ የጠራን እኛ ነን። ");
INSERT INTO amh_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","እንዲሁ ደግሞ በሆሴዕ። ሕዝቤ ያልሆነውን ሕዝቤ ብዬ፥ ያልተወደደችውንም የተወደደችው ብዬ እጠራለሁ፤ ");
INSERT INTO amh_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","እናንተ ሕዝቤ አይደላችሁም በተባለላቸውም ስፍራ በዚያ የሕያው እግዚአብሔር ልጆች ተብለው ይጠራሉ ይላል። ");
INSERT INTO amh_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","29","ኢሳይያስም እንደዚሁ። ጌታ ፀባዖት ዘር ባላስቀረልን እንደ ሰዶም በሆንን ገሞራንም በመሰልን ነበር ብሎ አስቀድሞ ተናገረ። ");
INSERT INTO amh_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","እንግዲህ ምን እንላለን? ጽድቅን ያልተከተሉት አሕዛብ ጽድቅን አገኙ፥ እርሱ ግን ከእምነት የሆነ ጽድቅ ነው፤ ");
INSERT INTO amh_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","33","እስራኤል ግን የጽድቅን ሕግ እየተከተሉ ወደ ሕግ አልደረሱም። ");
INSERT INTO amh_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","ወንድሞች ሆይ፥ የልቤ በጎ ፈቃድና ስለ እስራኤል ወደ እግዚአብሔር ልመናዬ እንዲድኑ ነው። ");
INSERT INTO amh_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","በእውቀት አይቅኑ እንጂ ለእግዚአብሔር እንዲቀኑ እመሰክርላቸዋለሁና። ");
INSERT INTO amh_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","የእግዚአብሔርን ጽድቅ ሳያውቁ የራሳቸውንም ጽድቅ ሊያቆሙ ሲፈልጉ፥ ለእግዚአብሔር ጽድቅ አልተገዙም። ");
INSERT INTO amh_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","የሚያምኑ ሁሉ ይጸድቁ ዘንድ ክርስቶስ የሕግ ፍጻሜ ነውና። ");
INSERT INTO amh_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ሙሴ ከሕግ የሆነውን ጽድቅ የሚያደርገው ሰው በእርሱ በሕይወት እንዲኖር ጽፎአልና። ");
INSERT INTO amh_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","ከእምነት የሆነ ጽድቅ ግን እንዲህ ይላል። በልብህ። ማን ወደ ሰማይ ይወጣል? አትበል፤ ይህ ክርስቶስን ለማውረድ ነው፤ ");
INSERT INTO amh_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ወይም። በልብህ። ወደ ጥልቁ ማን ይወርዳል? አትበል፤ ይህ ክርስቶስን ከሙታን ለማውጣት ነው። ");
INSERT INTO amh_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","ነገር ግን ምን ይላል? በአፍህ በልብህም ሆኖ ቃሉ ቀርቦልሃል፤ ይህም የምንሰብከው የእምነት ቃል ነው። ");
INSERT INTO amh_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","ኢየሱስ ጌታ እንደ ሆነ በአፍህ ብትመሰክር እግዚአብሔርም ከሙታን እንዳስነሣው በልብህ ብታምን ትድናለህና፤ ");
INSERT INTO amh_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","ሰው በልቡ አምኖ ይጸድቃልና በአፉም መስክሮ ይድናልና። ");
INSERT INTO amh_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","መጽሐፍ። በእርሱ የሚያምን ሁሉ አያፍርም ይላልና። ");
INSERT INTO amh_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","በአይሁዳዊና በግሪክ ሰው መካከል ልዩነት የለምና፤ አንዱ ጌታ የሁሉ ጌታ ነውና፥ ለሚጠሩትም ሁሉ ባለ ጠጋ ነው፤ ");
INSERT INTO amh_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","የጌታን ስም የሚጠራ ሁሉ ይድናልና። ");
INSERT INTO amh_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","እንግዲህ ያላመኑበትን እንዴት አድርገው ይጠሩታል? ባልሰሙትስ እንዴት ያምናሉ? ያለ ሰባኪስ እንዴት ይሰማሉ? ");
INSERT INTO amh_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","መልካሙን የምሥራች የሚያወሩ እግሮቻቸው እንዴት ያማሩ ናቸው ተብሎ እንደ ተጻፈ ካልተላኩ እንዴት ይሰብካሉ? ");
INSERT INTO amh_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","ነገር ግን ሁሉ ለምሥራቹ ቃል አልታዘዙም። ኢሳይያስ። ጌታ ሆይ፥ ምስክርነታችንን ማን አመነ? ብሎአልና። ");
INSERT INTO amh_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","እንግዲያስ እምነት ከመስማት ነው መስማትም በእግዚአብሔር ቃል ነው። ");
INSERT INTO amh_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ዳሩ ግን። ባይሰሙ ነው ወይ? እላለሁ። በእውነት። ድምፃቸው በምድር ሁሉ ላይ ቃላቸውም እስከ ዓለም ዳርቻ ወጣ። ");
INSERT INTO amh_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ነገር ግን። እስራኤል ባያውቁ ነው ወይ? እላለሁ። ሙሴ አስቀድሞ። እኔ ሕዝብ በማይሆነው አስቀናችኋለሁ በማያስተውልም ሕዝብ አስቆጣችኋለሁ ");
INSERT INTO amh_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ብሎአል። ኢሳይያስም ደፍሮ። ላልፈለጉኝ ተገኘሁ፥ ላልጠየቁኝም ተገለጥሁ አለ። ");
INSERT INTO amh_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","ስለ እስራኤል ግን። ቀኑን ሁሉ ወደማይታዘዝና ወደሚቃወም ሕዝብ እጆቼን ዘረጋሁ ይላል። ");
INSERT INTO amh_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","እንግዲህ። እግዚአብሔር ሕዝቡን ጣላቸውን? እላለሁ። አይደለም እኔ ደግሞ እስራኤላዊና ከአብርሃም ዘር ከብንያምም ወገን ነኝና። ");
INSERT INTO amh_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","እግዚአብሔር አስቀድሞ ያወቃቸውን ሕዝብ አልጣላቸውም። መጽሐፍ ስለ ኤልያስ በተጻፈው የሚለውን፥ በእግዚአብሔር ፊት እስራኤልን እንዴት እንደሚከስ፥ አታውቁምን? ");
INSERT INTO amh_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ጌታ ሆይ፥ ነቢያትህን ገደሉ መሠዊያዎችህንም አፈረሱ እኔም ብቻዬን ቀረሁ ነፍሴንም ይሹአታል። ");
INSERT INTO amh_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ነገር ግን አምላካዊ መልስ ምን አለው? ለበአል ያልሰገዱትን ሰባት ሺህ ሰዎች ለእኔ አስቀርቼአለሁ። ");
INSERT INTO amh_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","እንደዚሁም በአሁን ዘመን ደግሞ በጸጋ የተመረጡ ቅሬታዎች አሉ። ");
INSERT INTO amh_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","በጸጋ ከሆነ ግን ከሥራ መሆኑ ቀርቶአል፤ ጸጋ ያለዚያ ጸጋ መሆኑ ቀርቶአል። ");
INSERT INTO amh_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","እንግዲህ ምንድር ነው? እስራኤል የሚፈልጉትን አላገኙትም፤ የተመረጡት ግን አገኙት፤ ");
INSERT INTO amh_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ሌሎቹም ደነዘዙ፤ እንዲሁም። ዓይኖቻቸው እንዳያዩ ጆሮቻቸውም እንዳይሰሙ እግዚአብሔር የእንቅልፍ መንፈስን እስከ ዛሬ ድረስ ሰጣቸው ተብሎ ተጽፎአል። ዳዊትም። ");
INSERT INTO amh_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ማዕዳቸው ወጥመድና አሽክላ ማሰናከያም ፍዳም ይሁንባቸው፤ ");
INSERT INTO amh_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ዓይኖቻቸው እንዳያዩ ይጨልሙ፥ ጀርባቸውንም ዘወትር አጉብጥ ብሎአል። ");
INSERT INTO amh_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","እንግዲህ። የተሰናከሉ እስኪወድቁ ድረስ ነውን? እላለሁ። አይደለም፤ ነገር ግን እነርሱን ያስቀናቸው ዘንድ በእነርሱ በደል መዳን ለአሕዛብ ሆነ። ");
INSERT INTO amh_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","ዳሩ ግን በደላቸው ለዓለም ባለ ጠግነት መሸነፋቸውም ለአሕዛብ ባለ ጠግነት ከሆነ፥ ይልቁንስ መሙላታቸው እንዴት ይሆን? ");
INSERT INTO amh_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","15","የእነርሱ መጣል ለዓለም መታረቅ ከሆነ ከሙታን ከሚመጣ ሕይወት በቀር መመለሳቸው ምን ይሆን? ");
INSERT INTO amh_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","በኵራቱም ቅዱስ ከሆነ ብሆው ደግሞ ቅዱስ ነው፤ ሥሩም ቅዱስ ከሆነ ቅርንጫፎቹ ደግሞ ቅዱሳን ናቸው። ");
INSERT INTO amh_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","ነገር ግን ከቅርንጫፎች አንዳንዱ ቢሰበሩ አንተም የበረሀ ወይራ የሆንህ በመካከላቸው ገብተህ ከእነርሱ ጋር የወይራ ዘይት ከሚወጣው ሥር ተካፋይ ከሆንህ፥ በቅርንጫፎች ላይ አትመካ፤ ");
INSERT INTO amh_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ብትመካባቸው ግን ሥሩ አንተን ይሸከምሃል እንጂ ሥሩን የምትሸከም አንተ አይደለህም። ");
INSERT INTO amh_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","እንግዲህ። እኔ እንድገባ ቅርንጫፎች ተሰበሩ ትል ይሆናል። ");
INSERT INTO amh_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","መልካም፤ እነርሱ ከአለማመን የተነሣ ተሰበሩ አንተም ከእምነት የተነሣ ቆመሃል። ፍራ እንጂ የትዕቢትን ነገር አታስብ። ");
INSERT INTO amh_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","እግዚአብሔር እንደ ተፈጠሩት ለነበሩት ቅርንጫፎች የራራላቸው ካልሆነ ለአንተ ደግሞ አይራራልህምና። ");
INSERT INTO amh_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","እንግዲህ የእግዚአብሔርን ቸርነትና ጭከና ተመልከት፤ ጭከናው በወደቁት ላይ ነው፥ በቸርነቱ ግን ጸንተህ ብትኖር የእግዚአብሔር ቸርነት በአንተ ላይ ነው፤ ያለዚያ አንተ ደግሞ ትቆረጣለህ። ");
INSERT INTO amh_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","እነዚያም ደግሞ በአለማመናቸው ጸንተው ባይኖሩ በዛፉ ውስጥ ይገባሉ፤ እግዚአብሔር መልሶ ሊያገባቸው ይችላልና። ");
INSERT INTO amh_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","አንተ በፍጥረቱ የበረሀ ከነበረ ወይራ ተቆርጠህ እንደ ፍጥረትህ ሳትሆን በመልካም ወይራ ከገባህ፥ ይልቁንስ እነዚያ በፍጥረታቸው ያሉት ቅርንጫፎች በራሳቸው ወይራ እንዴት አይገቡም? ");
INSERT INTO amh_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","ወንድሞች ሆይ፥ ልባሞች የሆናችሁ እንዳይመስላችሁ ይህን ምሥጢር ታውቁ ዘንድ እወዳለሁ፤ የአሕዛብ ሙላት እስኪገባ ድረስ ድንዛዜ በእስራኤል በአንዳንድ በኩል ሆነባቸው፤ ");
INSERT INTO amh_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","እንደዚሁም እስራኤል ሁሉ ይድናል፤ እንዲህ ተብሎ እንደ ተጻፈ። መድኃኒት ከጽዮን ይወጣል ከያዕቆብም ኃጢአተኛነትን ያስወግዳል። ");
INSERT INTO amh_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ኃጢአታቸውንም ስወስድላቸው ከእነርሱ ጋር የምገባው ኪዳን ይህ ነው። ");
INSERT INTO amh_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","በወንጌልስ በኩል ስለ እናንተ ጠላቶች ናቸው፥ በምርጫ በኩል ግን ስለ አባቶች ተወዳጆች ናቸው፤ ");
INSERT INTO amh_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","እግዚአብሔር በጸጋው ስጦታና በመጥራቱ አይጸጸትምና። ");
INSERT INTO amh_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","እናንተም ቀድሞ ለእግዚአብሔር እንዳልታዘዛችሁ፥ አሁን ግን ከአለመታዘዛቸው የተነሣ ምሕረት እንዳገኛችሁ፥ ");
INSERT INTO amh_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","እንዲሁ በተማራችሁበት ምሕረት እነርሱ ደግሞ ምሕረትን ያገኙ ዘንድ እነዚህ ደግሞ አሁን አልታዘዙም። ");
INSERT INTO amh_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","እግዚአብሔር ሁሉን ይምር ዘንድ ሁሉን በአለመታዘዝ ዘግቶታልና። ");
INSERT INTO amh_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","የእግዚአብሔር ባለ ጠግነትና ጥበብ እውቀቱም እንዴት ጥልቅ ነው፤ ፍርዱ እንዴት የማይመረመር ነው፥ ለመንገዱም ፍለጋ የለውም። ");
INSERT INTO amh_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","የጌታን ልብ ያወቀው ማን ነው? ");
INSERT INTO amh_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ወይስ አማካሪው ማን ነበር? ወይስ ብድራቱን ይመልስ ዘንድ ለእርሱ አስቀድሞ የሰጠው ማን ነው? ");
INSERT INTO amh_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ሁሉ ከእርሱና በእርሱ ለእርሱም ነውና፤ ለእርሱ ለዘላለም ክብር ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","እንግዲህ፥ ወንድሞች ሆይ፥ ሰውነታችሁን እግዚአብሔርን ደስ የሚያሰኝና ሕያው ቅዱስም መሥዋዕት አድርጋችሁ ታቀርቡ ዘንድ በእግዚአብሔር ርኅራኄ እለምናችኋለሁ፥ እርሱም ለአእምሮ የሚመች አገልግሎታችሁ ነው። ");
INSERT INTO amh_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","የእግዚአብሔር ፈቃድ እርሱም በጎና ደስ የሚያሰኝ ፍጹምም የሆነው ነገር ምን እንደ ሆነ ፈትናችሁ ታውቁ ዘንድ በልባችሁ መታደስ ተለወጡ እንጂ ይህን ዓለም አትምሰሉ። ");
INSERT INTO amh_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","እግዚአብሔር ለእያንዳንዱ የእምነትን መጠን እንዳካፈለው፥ እንደ ባለ አእምሮ እንዲያስብ እንጂ ማሰብ ከሚገባው አልፎ በትዕቢት እንዳያስብ በመካከላችሁ ላለው ለእያንዳንዱ በተሰጠኝ ጸጋ እናገራለሁ። ");
INSERT INTO amh_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","በአንድ አካል ብዙ ብልቶች እንዳሉን፥ የብልቶቹም ሁሉ ሥራ አንድ እንዳይደለ፥ ");
INSERT INTO amh_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","እንዲሁ ብዙዎች ስንሆን በክርስቶስ አንድ አካል ነን፥ እርስ በርሳችንም እያንዳንዳችን የሌላው ብልቶች ነን። ");
INSERT INTO amh_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","እንደ ተሰጠንም ጸጋ ልዩ ልዩ ስጦታ አለን፤ ትንቢት ቢሆን እንደ እምነታችን መጠን ትንቢት እንናገር፤ ");
INSERT INTO amh_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","አገልግሎት ቢሆን በአገልግሎታችን እንትጋ፤ የሚያስተምርም ቢሆን በማስተማሩ ይትጋ፤ ");
INSERT INTO amh_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","የሚመክርም ቢሆን በመምከሩ ይትጋ፤ የሚሰጥ በልግስና ይስጥ፤ የሚገዛ በትጋት ይግዛ፤ የሚምር በደስታ ይማር። ");
INSERT INTO amh_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","ፍቅራችሁ ያለ ግብዝነት ይሁን። ክፉውን ነገር ተጸየፉት፤ ከበጎ ነገር ጋር ተባበሩ፤ ");
INSERT INTO amh_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","በወንድማማች መዋደድ እርስ በርሳችሁ ተዋደዱ፤ እርስ በርሳችሁ ተከባበሩ፤ ");
INSERT INTO amh_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","ለሥራ ከመትጋት አትለግሙ፤ በመንፈስ የምትቃጠሉ ሁኑ፤ ለጌታ ተገዙ፤ ");
INSERT INTO amh_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","በተስፋ ደስ ይበላችሁ፤ በመከራ ታገሡ፤ በጸሎት ጽኑ፤ ");
INSERT INTO amh_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","ቅዱሳንን በሚያስፈልጋቸው እርዱ፤ እንግዶችን ለመቀበል ትጉ። ");
INSERT INTO amh_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","የሚያሳድዱአችሁን መርቁ፥ መርቁ እንጂ አትርገሙ። ");
INSERT INTO amh_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ደስ ከሚላቸው ጋር ደስ ይበላችሁ፥ ከሚያለቅሱም ጋር አልቅሱ። ");
INSERT INTO amh_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","እርስ በርሳችሁ በአንድ አሳብ ተስማሙ፤ የትዕቢትን ነገር አታስቡ፥ ነገር ግን የትሕትናን ነገር ለመሥራት ትጉ። ልባሞች የሆናችሁ አይምሰላችሁ። ");
INSERT INTO amh_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","ለማንም ስለ ክፉ ፈንታ ክፉን አትመልሱ፤ በሰው ሁሉ ፊት መልካም የሆነውን አስቡ። ");
INSERT INTO amh_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ቢቻላችሁስ በእናንተ በኩል ከሰው ሁሉ ጋር በሰላም ኑሩ። ");
INSERT INTO amh_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ተወዳጆች ሆይ፥ ራሳችሁ አትበቀሉ፥ ለቍጣው ፈንታ ስጡ እንጂ፤ በቀል የእኔ ነው፥ እኔ ብድራቱን እመልሳለሁ ይላል ጌታ ተብሎ ተጽፎአልና። ");
INSERT INTO amh_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ጠላትህ ግን ቢራብ አብላው፤ ቢጠማ አጠጣው፤ ይህን በማድረግህ በራሱ ላይ የእሳት ፍም ትከምራለህና። ");
INSERT INTO amh_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","ክፉውን በመልካም አሸንፍ እንጂ በክፉ አትሸነፍ። ");
INSERT INTO amh_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","ነፍስ ሁሉ በበላይ ላሉት ባለ ሥልጣኖች ይገዛ። ከእግዚአብሔር ካልተገኘ በቀር ሥልጣን የለምና፤ ያሉትም ባለ ሥልጣኖች በእግዚአብሔር የተሾሙ ናቸው። ");
INSERT INTO amh_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ስለዚህ ባለ ሥልጣንን የሚቃወም የእግዚአብሔርን ሥርዓት ይቃወማል፤ የሚቃወሙትም በራሳቸው ላይ ፍርድን ይቀበላሉ። ");
INSERT INTO amh_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","ገዥዎች ለክፉ አድራጊዎች እንጂ መልካም ለሚያደርጉ የሚያስፈሩ አይደሉምና። ባለ ሥልጣንን እንዳትፈራ ትወዳለህን? መልካሙን አድርግ ከእርሱም ምስጋና ይሆንልሃል፤ ");
INSERT INTO amh_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","ለመልካም ነገር ለአንተ የእግዚአብሔር አገልጋይ ነውና። በከንቱ ግን ሰይፍ አይታጠቅምና ክፉ ብታደርግ ፍራ፤ ቍጣውን ለማሳየት ክፉ አድራጊውን የሚበቀል የእግዚአብሔር አገልጋይ ነውና። ");
INSERT INTO amh_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ስለዚህ ስለ ቍጣው ብቻ አይደለም ነገር ግን ስለ ሕሊና ደግሞ መገዛት ግድ ነው። ");
INSERT INTO amh_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ስለዚህ ደግሞ ትገብራላችሁና፤ በዚህ ነገር የሚተጉ የእግዚአብሔር አገልጋዮች ናቸውና። ");
INSERT INTO amh_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","ለሁሉ የሚገባውን አስረክቡ፤ ግብር ለሚገባው ግብርን፥ ቀረጥ ለሚገባው ቀረጥን፥ መፈራት ለሚገባው መፈራትን፥ ክብር ለሚገባው ክብርን ስጡ። ");
INSERT INTO amh_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","እርስ በርሳችሁ ከመዋደድ በቀር ለማንም ዕዳ አይኑርባችሁ፥ ሌላውን የሚወድ ሕግን ፈጽሞታልና። ");
INSERT INTO amh_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","አታመንዝር፥ አትግደል፥ አትስረቅ፥ በውሸት አትመስክር፥ አትመኝ የሚለው ከሌላይቱ ትእዛዝ ሁሉ ጋር በዚህ። ባልንጀራህን እንደ ነፍስህ ውደድ በሚለው ቃል ተጠቅልሎአል። ");
INSERT INTO amh_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","ፍቅር ለባልንጀራው ክፉ አያደርግም፤ ስለዚህ ፍቅር የሕግ ፍጻሜ ነው። ");
INSERT INTO amh_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","ከእንቅልፍ የምትነሡበት ሰዓት አሁን እንደ ደረሰ ዘመኑን እወቁ፤ ካመንንበት ጊዜ ይልቅ መዳናችን ዛሬ ወደ እኛ ቀርቦአልና። ");
INSERT INTO amh_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","ሌሊቱ አልፎአል፥ ቀኑም ቀርቦአል። እንግዲህ የጨለማውን ሥራ አውጥተን የብርሃንን ጋሻ ጦር እንልበስ። ");
INSERT INTO amh_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","በቀን እንደምንሆን በአገባብ እንመላለስ፤ በዘፈንና በስካር አይሁን፥ በዝሙትና በመዳራት አይሁን፥ በክርክርና በቅናት አይሁን፤ ");
INSERT INTO amh_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ነገር ግን ጌታን ኢየሱስ ክርስቶስን ልበሱት፤ ምኞቱንም እንዲፈጽም ለሥጋ አታስቡ። ");
INSERT INTO amh_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","በእምነት የደከመውንም ተቀበሉት፥ በአሳቡም ላይ አትፍረዱ። ");
INSERT INTO amh_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","ሁሉን ይበላ ዘንድ እንደ ተፈቀደለት የሚያምን አለ፥ ደካማው ግን አትክልት ይበላል። ");
INSERT INTO amh_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","የሚበላ የማይበላውን አይናቀው የማይበላውም በሚበላው አይፍረድ፥ እግዚአብሔር ተቀብሎታልና። ");
INSERT INTO amh_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","አንተ በሌላው ሎሌ የምትፈርድ ማን ነህ? እርሱ ቢቆም ወይም ቢወድቅ ለገዛ ጌታው ነው፤ ነገር ግን እግዚአብሔር ሊያቆመው ይችላልና ይቆማል። ");
INSERT INTO amh_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","ይህ ሰው አንድ ቀን ከሌላ ቀን እንዲሻል ያስባል፥ ያ ግን ቀን ሁሉ አንድ እንደ ሆነ ያስባል፤ እያንዳንዱ በገዛ አእምሮው አጥብቆ ይረዳ። ");
INSERT INTO amh_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","ቀንን የሚያከብር ለጌታ ብሎ ያከብራል፤ የሚበላም እግዚአብሔርን ያመሰግናልና ለጌታ ብሎ ይበላል፤ የማይበላም ለጌታ ብሎ አይበላም እግዚአብሔርንም ያመሰግናል። ");
INSERT INTO amh_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","ከእኛ አንድ ስንኳ ለራሱ የሚኖር የለምና፥ ለራሱም የሚሞት የለም፤ ");
INSERT INTO amh_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","በሕይወት ሆነን ብንኖር ለጌታ እንኖራለንና፥ ብንሞትም ለጌታ እንሞታለን። እንግዲህ በሕይወት ሆነን ብንኖር ወይም ብንሞት የጌታ ነን። ");
INSERT INTO amh_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","ስለዚህ ነገር ሙታንንም ሕያዋንንም ይገዛ ዘንድ ክርስቶስ ሞቶአልና ሕያውም ሆኖአልና። ");
INSERT INTO amh_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","አንተም በወንድምህ ላይ ስለ ምን ትፈርዳለህ? ወይስ አንተ ደግሞ ወንድምህን ስለ ምን ትንቃለህ? ሁላችን በክርስቶስ ፍርድ ወንበር ፊት እንቆማለንና። ");
INSERT INTO amh_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","እኔ ሕያው ነኝ፥ ይላል ጌታ፥ ጉልበት ሁሉ ለእኔ ይንበረከካል መላስም ሁሉ እግዚአብሔርን ያመሰግናል ተብሎ ተጽፎአልና። ");
INSERT INTO amh_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","እንግዲያስ እያንዳንዳችን ስለ ራሳችን ለእግዚአብሔር መልስ እንሰጣለን። ");
INSERT INTO amh_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","እንግዲህ ከዛሬ ጀምሮ እርስ በርሳችን አንፈራረድ፤ ይልቁን ግን ለወንድም እንቅፋትን ወይም ማሰናከያን ማንም እንዳያኖርበት ይህን ቍረጡ። ");
INSERT INTO amh_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","በራሱ ርኵስ የሆነ ነገር እንደ ሌለ በጌታ በኢየሱስ ሆኜ አውቄአለሁ ተረድቼአለሁም፤ ነገር ግን ምንም ርኵስ እንዲሆን ለሚቆጥር ለእርሱ ርኵስ ነው። ");
INSERT INTO amh_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","ወንድምህንም በመብል ምክንያት የምታሳዝን ከሆንህ እንግዲህ በፍቅር አልተመላለስህም። ክርስቶስ ስለ እርሱ የሞተለትን እርሱን በመብልህ አታጥፋው። ");
INSERT INTO amh_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","እንግዲህ ለእናንተ ያለው መልካም ነገር አይሰደብ፤ ");
INSERT INTO amh_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","የእግዚአብሔር መንግሥት ጽድቅና ሰላም በመንፈስ ቅዱስም የሆነ ደስታ ናት እንጂ መብልና መጠጥ አይደለችምና። ");
INSERT INTO amh_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","እንደዚህ አድርጎ ለክርስቶስ የሚገዛ እግዚአብሔርን ደስ ያሰኛልና፥ በሰውም ዘንድ የተመሰገነ ነው። ");
INSERT INTO amh_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","እንግዲያስ ሰላም የሚቆምበትን እርስ በርሳችንም የምንታነጽበትን እንከተል። ");
INSERT INTO amh_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","በመብል ምክንያት የእግዚአብሔርን ሥራ አታፍርስ። ሁሉ ንጹሕ ነው፥ በመጠራጠር የተበላ እንደ ሆነ ግን ለዚያ ሰው ክፉ ነው። ");
INSERT INTO amh_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","ሥጋን አለመብላት ወይንንም አለመጠጣት ወንድምህም የሚሰናከልበትን አለማድረግ መልካም ነው። ");
INSERT INTO amh_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","ለአንተ ያለህ እምነት በእግዚአብሔር ፊት ለራስህ ይሁንልህ። ፈትኖ መልካም እንዲሆን በሚቈጥረው ነገር በራሱ ላይ የማይፈርድ ብፁዕ ነው። ");
INSERT INTO amh_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","የሚጠራጠረው ግን ቢበላ በእምነት ስላልሆነ ተኮንኖአል፤ በእምነትም ያልሆነ ሁሉ ኃጢአት ነው። ");
INSERT INTO amh_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","እኛም ኃይለኞች የሆንን የደካሞችን ድካም እንድንሸከም ራሳችንንም ደስ እንዳናሰኝ ይገባናል። ");
INSERT INTO amh_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","እያንዳንዳችን እንድናንጸው እርሱን ለመጥቀም ባልንጀራችንን ደስ እናሰኝ። ");
INSERT INTO amh_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","ክርስቶስ ራሱን ደስ አላሰኘምና፤ ነገር ግን። አንተን የነቀፉበት ነቀፋ ወደቀብኝ ተብሎ እንደ ተጻፈ ሆነበት። ");
INSERT INTO amh_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","በመጽናትና መጻሕፍት በሚሰጡት መጽናናት ተስፋ ይሆንልን ዘንድ አስቀድሞ የተጻፈው ሁሉ ለትምህርታችን ተጽፎአልና። ");
INSERT INTO amh_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","7","ስለዚህ ክርስቶስ ለእግዚአብሔር ክብር እንደ ተቀበላችሁ እንዲሁ እርስ በርሳችሁ ተቀባበሉ። ");
INSERT INTO amh_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","10","ደግሞም። አሕዛብ ሆይ፥ ከሕዝቡ ጋር ደስ ይበላችሁ ይላል። ");
INSERT INTO amh_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","ደግሞም። እናንተ አሕዛብ ሁላችሁ፥ ጌታን አመስግኑ ሕዝቦቹም ሁሉ ይወድሱት ይላል። ");
INSERT INTO amh_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","ደግሞም ኢሳይያስ። የእሴይ ሥር አሕዛብንም ሊገዛ የሚነሣው ይሆናል፤ በእርሱ አሕዛብ ተስፋ ያደርጋሉ ይላል። ");
INSERT INTO amh_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","የተስፋ አምላክም በመንፈስ ቅዱስ ኃይል በተስፋ እንድትበዙ በማመናችሁ ደስታንና ሰላምን ሁሉ ይሙላባችሁ። ");
INSERT INTO amh_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","እኔም ራሴ ደግሞ፥ ወንድሞቼ ሆይ፥ በበጎነት ራሳችሁ እንደ ተሞላችሁ፥ እውቀትም ሁሉ እንደ ሞላባችሁ፥ እርስ በርሳችሁም ደግሞ ልትገሠጹ እንዲቻላችሁ ስለ እናንተ ተረድቼአለሁ። ");
INSERT INTO amh_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","17","እንግዲህ ከእግዚአብሔር ዘንድ በሚሆን ነገር በክርስቶስ ኢየሱስ ትምክህት አለኝ። ");
INSERT INTO amh_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","20","እንዲሁም በሌላው ሰው መሠረት ላይ እንዳልሠራ የክርስቶስ ስም በተጠራበት ስፍራ ሳይሆን ወንጌልን ለመስበክ ተጣጣርሁ፤ ");
INSERT INTO amh_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ነገር ግን። ስለ እርሱ ያልተወራላቸው ያያሉ፥ ያልሰሙም ያስተውላሉ ተብሎ እንደ ተጻፈ ነው። ");
INSERT INTO amh_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","ስለዚህ ደግሞ ወደ እናንተ እንዳልመጣ ብዙ ጊዜ ተከለከልሁ። ");
INSERT INTO amh_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","አሁን ግን በዚህ አገር ስፍራ ወደ ፊት ስለሌለኝ፥ ከብዙ ዓመትም ጀምሬ ወደ እናንተ ልመጣ ናፍቆት ስላለኝ፥ ");
INSERT INTO amh_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ወደ እስጳንያ በሄድሁ ጊዜ ሳልፍ እናንተን እንዳይ፥ አስቀድሜም ጥቂት ብጠግባችሁ ወደዚያ በጉዞዬ እንድትረዱኝ ተስፋ አደርጋለሁ። ");
INSERT INTO amh_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","አሁን ግን ቅዱሳንን ለማገልገል ወደ ኢየሩሳሌም እሄዳለሁ። ");
INSERT INTO amh_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","መቄዶንያና አካይያ በኢየሩሳሌም ቅዱሳን መካከል ያሉትን ድሆች ይረዱ ዘንድ ወደዋልና። ");
INSERT INTO amh_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ወደዋልና፥ የእነርሱም ባለ ዕዳዎች ናቸው፤ አሕዛብ በእነርሱ መንፈሳዊ ነገርን ተካፋዮች ከሆኑ በሥጋዊ ነገር ደግሞ ያገለግሉአቸው ዘንድ ይገባቸዋልና። ");
INSERT INTO amh_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","እንግዲህ ይህን ፈጽሜ ይህን ፍሬ ካተምሁላቸው በኋላ በእናንተ በኩል አልፌ ወደ እስጳንያ እሄዳለሁ፤ ");
INSERT INTO amh_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","ወደ እናንተም ስመጣ በክርስቶስ በረከት ሙላት እንድመጣ አውቃለሁ። ");
INSERT INTO amh_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","ወንድሞች ሆይ፥ ስለ እኔ ወደ እግዚአብሔር እየጸለያችሁ ከእኔ ጋር ትጋደሉ ዘንድ በጌታችን በኢየሱስ ክርስቶስና በመንፈስ ፍቅር እለምናችኋለሁ፤ ");
INSERT INTO amh_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","33","የሰላምም አምላክ ከሁላችሁ ጋር ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","በክንክራኦስ ባለች ቤተ ክርስቲያን አገልጋይ የምትሆን እኅታችንን ፌቤንን አደራ ብያችኋለሁ፤ ");
INSERT INTO amh_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ለቅዱሳን እንደሚገባ በጌታ ተቀበሉአት፥ እርስዋ ለብዙዎች ለእኔም ለራሴ ደጋፊ ነበረችና፥ ከእናንተም በምትፈልገው በማናቸውም ነገር እርዱአት። ");
INSERT INTO amh_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","በክርስቶስ ኢየሱስ አብረውኝ ለሚሠሩ ለጵርስቅላና ለአቂላ ሰላምታ አቅርቡልኝ፤ ");
INSERT INTO amh_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","እነርሱም ስለ ነፍሴ ነፍሳቸውን ለሞት አቀረቡ፥ የአሕዛብም አብያተ ክርስቲያናት ሁሉ የሚያመሰግኑአቸው ናቸው እንጂ እኔ ብቻ አይደለሁም፤ ");
INSERT INTO amh_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","በቤታቸውም ላለች ቤተ ክርስቲያን ሰላምታ አቅርቡልኝ። ከእስያ ለክርስቶስ በኵራት ለሆነው ለምወደው ለአጤኔጦን ሰላምታ አቅርቡልኝ። ");
INSERT INTO amh_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","ስለ እናንተ ብዙ ለደከመች ለማርያ ሰላምታ አቅርቡልኝ። ");
INSERT INTO amh_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","በሐዋርያት መካከል ስመ ጥሩዎች ለሆኑ፥ ደግሞም ክርስቶስን በማመን ለቀደሙኝ፥ አብረውኝም ለታሰሩ ለዘመዶቼ ለአንዲራኒቆንና ለዩልያን ሰላምታ አቅርቡልኝ። ");
INSERT INTO amh_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","በጌታ ለምወደው ለጵልያጦን ሰላምታ አቅርቡልኝ። ");
INSERT INTO amh_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","በክርስቶስ አብሮን ለሚሠራ ለኢሩባኖን ለምወደውም ለስንጣክን ሰላምታ አቅርቡልኝ። ");
INSERT INTO amh_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","በክርስቶስ መሆኑ ተፈትኖ ለተመሰገነው ለኤጤሌን ሰላምታ አቅርቡልኝ። ከአርስጣባሉ ቤተ ሰዎች ላሉት ሰላምታ አቅርቡልኝ። ");
INSERT INTO amh_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","ለዘመዴ ለሄሮድዮና ሰላምታ አቅርቡልኝ። ከንርቀሱ ቤተ ሰዎች በጌታ ላሉት ሰላምታ አቅርቡልኝ። ");
INSERT INTO amh_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","በጌታ ሆነው ለሚደክሙ ለፕሮፊሞናና ለጢሮፊሞሳ ሰላምታ አቅርቡልኝ። በጌታ እጅግ ለደከመች ለተወደደች ለጠርሲዳ ሰላምታ አቅርቡልኝ። ");
INSERT INTO amh_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","በጌታ ሆኖ ለታወቀ ለሩፎን ለእኔና ለእርሱም እናት ሰላምታ አቅርቡልኝ። ");
INSERT INTO amh_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","ለአስቀሪጦንና ለአፍለሶንጳ ለሄሮሜንም ለጳጥሮባም ለሄርማንም ከእነርሱም ጋር ላሉ ወንድሞች ሰላምታ አቅርቡልኝ። ");
INSERT INTO amh_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","ለፍሌጎንና ለዩልያ ለኔርያና ለእኅቱም ለአልንጦንም ከእነርሱ ጋር ላሉ ቅዱሳን ሁሉ ሰላምታ አቅርቡልኝ። ");
INSERT INTO amh_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","በተቀደሰ አሳሳም እርስ በርሳችሁ ሰላምታ ተሰጣጡ። የክርስቶስ አብያተ ክርስቲያናት ሁሉ ሰላምታ ያቀርቡላችኋል። ");
INSERT INTO amh_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","ነገር ግን፥ ወንድሞች ሆይ፥ እናንተ የተማራችሁትን ትምህርት የሚቃወሙትን መለያየትንና ማሰናከያን የሚያደርጉትን ሰዎች እንድትመለከቱ እለምናችኋለሁ፥ ከእነርሱ ዘንድ ፈቀቅ በሉ፤ ");
INSERT INTO amh_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","እንዲህ ያሉት ለገዛ ሆዳቸው እንጂ ለጌታችን ለኢየሱስ ክርስቶስ አይገዙምና፥ በመልካምና በሚያቆላምጥ ንግግርም ተንኮል የሌለባቸውን ሰዎች ልብ ያታልላሉ። ");
INSERT INTO amh_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","መታዘዛችሁ ለሁሉ ተወርቶአልና፤ እንግዲህ በእናንተ ደስ ይለኛል፤ ነገር ግን ለበጎ ነገር ጥበበኞች ለክፉም የዋሆች እንድትሆኑ እወዳለሁ። ");
INSERT INTO amh_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","የሰላምም አምላክ ሰይጣንን ከእግራችሁ በታች ፈጥኖ ይቀጠቅጠዋል። የጌታችን የኢየሱስ ክርስቶስ ጸጋ ከእናንተ ጋር ይሁን። ");
INSERT INTO amh_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","አብሮኝ የሚሠራ ጢሞቴዎስ ዘመዶቼም ሉቂዮስና ኢያሶን ሱሲጴጥሮስም ሰላምታ ያቀርቡላችኋል። ");
INSERT INTO amh_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","ይህን መልእክት የጻፍሁ እኔ ጤርጥዮስ በጌታ ሰላምታ አቀርብላችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","የእኔና የቤተ ክርስቲያን ሁሉ አስተናጋጅ ጋይዮስ ሰላምታ ያቀርብላችኋል። የከተማው መጋቢ ኤርስጦስ ወንድማችንም ቁአስጥሮስ ሰላምታ ያቀርቡላችኋል። ");
INSERT INTO amh_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","የጌታችን የኢየሱስ ክርስቶስ ጸጋ ከሁላችሁ ጋር ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","27","ብቻውን ጥበብ ላለው ለእግዚአብሔር በኢየሱስ ክርስቶስ እስከ ዘላለም ድረስ ክብር ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","በእግዚአብሔር ፈቃድ የኢየሱስ ክርስቶስ ሐዋርያ ሊሆን የተጠራ ጳውሎስ ወንድሙም ሶስቴንስ፥ ");
INSERT INTO amh_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","በቆሮንቶስ ላለች ለእግዚአብሔር ቤተ ክርስቲያን፥ በክርስቶስ ኢየሱስ ለተቀደሱት፥ የእነርሱና የእኛ ጌታ የሆነውን የጌታችንን የኢየሱስ ክርስቶስን ስም በየስፍራው ከሚጠሩት ሁሉ ጋር ቅዱሳን ለመሆን ለተጠሩት፤ ");
INSERT INTO amh_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","ከእግዚአብሔር ከአባታችን ከጌታም ከኢየሱስ ክርስቶስ ጸጋና ሰላም ለእናንተ ይሁን። ");
INSERT INTO amh_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","በክርስቶስ ኢየሱስ ስላመናችሁ በተሰጣችሁ በእግዚአብሔር ጸጋ ምክንያት ሁልጊዜ ስለ እናንተ አምላክን አመሰግናለሁ፤ ");
INSERT INTO amh_vpl VALUES ("C11_5","076_1_5","1CO","1","5","7","እንደዚህ የጌታችንን የኢየሱስ ክርስቶስን መገለጥ ስትጠባበቁ አንድ የጸጋ ስጦታ እንኳ አይጎድልባችሁም፤ ");
INSERT INTO amh_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","እርሱም ደግሞ በጌታችን በኢየሱስ ክርስቶስ ቀን ያለ ነቀፋ እንድትሆኑ እስከ ፍጻሜ ድረስ ያጸናችኋል። ");
INSERT INTO amh_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","ወደ ልጁ ወደ ጌታችን ወደ ኢየሱስ ክርስቶስ ኅብረት የጠራችሁ እግዚአብሔር የታመነ ነው። ");
INSERT INTO amh_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","ነገር ግን፥ ወንድሞች ሆይ፥ ሁላችሁ አንድ ንግግር እንድትናገሩ በአንድ ልብና በአንድ አሳብም የተባበራችሁ እንድትሆኑ እንጂ መለያየት በመካከላችሁ እንዳይሆን በጌታችን በኢየሱስ ክርስቶስ ስም እለምናችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","ወንድሞቼ ሆይ፥ በመካከላችሁ ክርክር እንዳለ ስለ እናንተ የቀሎዔ ቤተ ሰዎች አስታውቀውኛልና። ");
INSERT INTO amh_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","ይህንም እላለሁ። እያንዳንዳችሁ። እኔ የጳውሎስ ነኝ፥ እኔስ የአጵሎስ ነኝ፥ እኔ ግን የኬፋ ነኝ፥ እኔስ የክርስቶስ ነኝ ትላላችሁ። ");
INSERT INTO amh_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ክርስቶስ ተከፍሎአልን? ጳውሎስስ ስለ እናንተ ተሰቀለን? ወይስ በጳውሎስ ስም ተጠመቃችሁን? ");
INSERT INTO amh_vpl VALUES ("C11_14","076_1_14","1CO","1","14","16","የእስጢፋኖስንም ቤተ ሰዎች ደግሞ አጥምቄአለሁ፤ ጨምሬ ሌላ አጥምቄ እንደ ሆነ አላውቅም። ");
INSERT INTO amh_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ለማጥመቅ ክርስቶስ አልላከኝምና፥ ወንጌልን ልሰብክ እንጂ፤ የክርስቶስ መስቀል ከንቱ እንዳይሆን በቃል ጥበብ አይደለም። ");
INSERT INTO amh_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","የመስቀሉ ቃል ለሚጠፉት ሞኝነት፥ ለእኛ ለምንድን ግን የእግዚአብሔር ኃይል ነውና። ");
INSERT INTO amh_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","የጥበበኞችን ጥበብ አጠፋለሁ የአስተዋዮችንም ማስተዋል እጥላለሁ ተብሎ ተጽፎአልና። ");
INSERT INTO amh_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ጥበበኛ የት አለ? ጻፊስ የት አለ? የዚች ዓለም መርማሪስ የት አለ? እግዚአብሔር የዚችን ዓለም ጥበብ ሞኝነት እንዲሆን አላደረገምን? ");
INSERT INTO amh_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","በእግዚአብሔር ጥበብ ምክንያት ዓለም እግዚአብሔርን በጥበብዋ ስላላወቀች፥ በስብከት ሞኝነት የሚያምኑትን ሊያድን የእግዚአብሔር በጎ ፈቃድ ሆኖአልና። ");
INSERT INTO amh_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","መቼም አይሁድ ምልክትን ይለምናሉ የግሪክ ሰዎችም ጥበብን ይሻሉ፥ ");
INSERT INTO amh_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","እኛ ግን የተሰቀለውን ክርስቶስን እንሰብካለን፤ ይህም ለአይሁድ ማሰናከያ ለአሕዛብም ሞኝነት ነው፥ ");
INSERT INTO amh_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","ለተጠሩት ግን፥ አይሁድ ቢሆኑ የግሪክ ሰዎችም ቢሆኑ፥ የእግዚአብሔር ኃይልና የእግዚአብሔር ጥበብ የሆነው ክርስቶስ ነው። ");
INSERT INTO amh_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","ከሰው ይልቅ የእግዚአብሔር ሞኝነት ይጠበባልና፥ የእግዚአብሔርም ድካም ከሰው ይልቅ ይበረታልና። ");
INSERT INTO amh_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","ወንድሞች ሆይ፥ መጠራታችሁን ተመልከቱ፤ እንደ ሰው ጥበብ ጥበበኞች የሆኑ ብዙዎች፥ ኀያላን የሆኑ ብዙዎች፥ ባላባቶች የሆኑ ብዙዎች አልተጠሩም። ");
INSERT INTO amh_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ነገር ግን እግዚአብሔር ጥበበኞችን እንዲያሳፍር የዓለምን ሞኝ ነገር መረጠ፤ ብርቱንም ነገር እንዲያሳፍር እግዚአብሔር የዓለምን ደካማ ነገር መረጠ፤ ");
INSERT INTO amh_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","እግዚአብሔርም የሆነውን ነገር እንዲያጠፋ የዓለምን ምናምንቴ ነገር የተናቀውንም ነገር ያልሆነውንም ነገር መረጠ፥ ");
INSERT INTO amh_vpl VALUES ("C11_29","076_1_29","1CO","1","29","31","ሥጋን የለበሰ ሁሉ በእግዚአብሔር ፊት እንዳይመካ። ");
INSERT INTO amh_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","እኔም፥ ወንድሞች ሆይ፥ ወደ እናንተ በመጣሁ ጊዜ በቃልና በጥበብ ብልጫ ለእግዚአብሔር ምስክርነቴን ለእናንተ እየነገርሁ አልመጣሁም። ");
INSERT INTO amh_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","በመካከላችሁ ሳለሁ ከኢየሱስ ክርስቶስ በቀር እርሱም እንደተሰቀለ ሌላ ነገር እንዳላውቅ ቆርጬ ነበርና። ");
INSERT INTO amh_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","እኔም በድካምና በፍርሃት በብዙ መንቀጥቀጥም በእናንተ ዘንድ ነበርሁ፤ ");
INSERT INTO amh_vpl VALUES ("C12_4","076_2_4","1CO","2","4","6","በበሰሉት መካከል ግን ጥበብን እንናገራለን፥ ነገር ግን የዚችን ዓለም ጥበብ አይደለም የሚሻሩትንም የዚችን ዓለም ገዦች ጥበብ አይደለም፤ ");
INSERT INTO amh_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","ነገር ግን እግዚአብሔር አስቀድሞ ከዘመናት በፊት ለክብራችን የወሰነውን፥ ተሰውሮም የነበረውን የእግዚአብሔርን ጥበብ በምሥጢር እንናገራለን። ");
INSERT INTO amh_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ከዚችም ዓለም ገዦች አንዱ እንኳ ይህን ጥበብ አላወቀም፤ አውቀውስ ቢሆኑ የክብርን ጌታ ባልሰቀሉትም ነበር፤ ");
INSERT INTO amh_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","ነገር ግን። ዓይን ያላየችው ጆሮም ያልሰማው በሰውም ልብ ያልታሰበው እግዚአብሔር ለሚወዱት ያዘጋጀው ተብሎ እንድተጻፈ፥ እንዲህ እንናገራለን። ");
INSERT INTO amh_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","መንፈስም የእግዚአብሔርን ጥልቅ ነገር ስንኳ ሳይቀር ሁሉን ይመረምራልና ለእኛ እግዚአብሔር በመንፈሱ በኩል ገለጠው። ");
INSERT INTO amh_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","በእርሱ ውስጥ ካለው ከሰው መንፈስ በቀር ለሰው ያለውን የሚያውቅ ሰው ማን ነው? እንዲሁም ደግሞ ከእግዚአብሔር መንፈስ በቀር ለእግዚአብሔር ያለውን ማንም አያውቅም። ");
INSERT INTO amh_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","እኛ ግን ከእግዚአብሔር እንዲያው የተሰጠንን እናውቅ ዘንድ ከእግዚአብሔር የሆነውን መንፈስ እንጂ የዓለምን መንፈስ አልተቀበልንም። ");
INSERT INTO amh_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","መንፈሳዊውን ነገር ከመንፈሳዊው ነገር ጋር አስተያይተን መንፈስ በሚያስተምረን ቃል ይህን ደግሞ እንናገራለን እንጂ የሰው ጥበብ በሚያስተምረን ቃል አይደለም። ");
INSERT INTO amh_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","ለፍጥረታዊ ሰው የእግዚአብሔር መንፈስ ነገር ሞኝነት ነውና አይቀበለውም፤ በመንፈስም የሚመረመር ስለ ሆነ ሊያውቀው አይችልም። ");
INSERT INTO amh_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","መንፈሳዊ ሰው ግን ሁሉን ይመረምራል ራሱ ግን በማንም አይመረመርም። ");
INSERT INTO amh_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","እንዲያስተምረው የጌታን ልብ ማን አውቆት ነው? እኛ ግን የክርስቶስ ልብ አለን። ");
INSERT INTO amh_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","እኔም፥ ወንድሞች ሆይ፥ የሥጋ እንደ መሆናችሁ፥ በክርስቶስም ሕፃናት እንደ መሆናችሁ እንጂ መንፈሳውያን እንደ መሆናችሁ ልናገራችሁ አልቻልሁም። ");
INSERT INTO amh_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","ገና ጽኑ መብል ለመብላት አትችሉም ነበርና ወተት ጋትኋችሁ፤ ");
INSERT INTO amh_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","ገና ሥጋውያን ናችሁና እስከ አሁን ድረስ ገና አትችሉም። ቅናትና ክርክር ስለሚገኝባችሁ ሥጋውያን መሆናችሁ አይደላችሁምን? እንደ ሰው ልማድስ አትመላለሱምን? ");
INSERT INTO amh_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","አንዱ። እኔ የጳውሎስ ነኝ፥ ሁለተኛውም። እኔ የአጵሎስ ነኝ ቢል ሰዎች ብቻ መሆናችሁ አይደለምን? ");
INSERT INTO amh_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","አጵሎስ እንግዲህ ምንድር ነው? ጳውሎስስ ምንድር ነው? በእነርሱ እጅ ያመናችሁ አገልጋዮች ናቸው፤ ለእያንዳንዳቸውም ጌታ እንደ ሰጣቸው ያገለግላሉ። ");
INSERT INTO amh_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","እኔ ተከልሁ አጵሎስም አጠጣ ነገር ግን እግዚአብሔር ያሳድግ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","እንግዲያስ የሚያሳድግ እግዚአብሔር እንጂ የሚተክል ቢሆን ወይም የሚያጠጣ ቢሆን አንዳች አይደለም። ");
INSERT INTO amh_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","የሚተክልና የሚያጠጣ አንድ ናቸው፥ ነገር ግን እያንዳንዱ እንደ ራሱ ድካም መጠን የራሱን ደመወዝ ይቀበላል። ");
INSERT INTO amh_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","የእግዚአብሔር እርሻ ናችሁ፤ የእግዚአብሔር ሕንፃ ናችሁ፤ ከእርሱ ጋር አብረን የምንሠራ ነንና። ");
INSERT INTO amh_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","የእግዚአብሔር ጸጋ እንደ ተሰጠኝ መጠን እንደ ብልሃተኛ የአናጺ አለቃ መሠረትን መሠረትሁ፥ ሌላውም በላዩ ያንጻል። እያንዳንዱ ግን በእርሱ ላይ እንዴት እንዲያንጽ ይጠንቀቅ። ");
INSERT INTO amh_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","ከተመሠረተው በቀር ማንም ሌላ መሠረት ሊመሠርት አይችልምና፥ እርሱም ኢየሱስ ክርስቶስ ነው። ");
INSERT INTO amh_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","ማንም ግን በዚህ መሠረት ላይ በወርቅ ቢሆን በብርም በከበረ ድንጋይም በእንጨትም በሣርም ወይም በአገዳ ቢያንጽ፥ የእያንዳንዱ ሥራ ይገለጣል፤ ");
INSERT INTO amh_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","በእሳት ስለሚገለጥ ያ ቀን ያሳያልና፥ የእያንዳንዱም ሥራ እንዴት መሆኑን እሳቱ ይፈትነዋል። ");
INSERT INTO amh_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","ማንም በእርሱ ላይ ያነጸው ሥራ ቢጸናለት ደመወዙን ይቀበላል፤ ");
INSERT INTO amh_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","የማንም ሥራ የተቃጠለበት ቢሆን ይጎዳበታል፥ እርሱ ራሱ ግን ይድናል ነገር ግን በእሳት እንደሚድን ይሆናል። ");
INSERT INTO amh_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","የእግዚአብሔር ቤተ መቅደስ እንደ ሆናችሁ የእግዚአብሔርም መንፈስ እንዲኖርባችሁ አታውቁምን? ");
INSERT INTO amh_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ማንም የእግዚአብሔርን ቤተ መቅደስ ቢያፈርስ እግዚአብሔር እርሱን ያፈርሰዋል፤ የእግዚአብሔር ቤተ መቅደስ ቅዱስ ነውና፥ ያውም እናንተ ናችሁ። ");
INSERT INTO amh_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","ማንም ራሱን አያታልል፤ ከእናንተ ማንም በዚች ዓለም ጥበበኛ የሆነ ቢመስለው ጥበበኛ ይሆን ዘንድ ሞኝ ይሁን። ");
INSERT INTO amh_vpl VALUES ("C13_19","076_3_19","1CO","3","19","21","ስለዚህም ማንም በሰው አይመካ። ነገር ሁሉ የእናንተ ነውና፤ ");
INSERT INTO amh_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","ጳውሎስ ቢሆን አጵሎስም ቢሆን ኬፋም ቢሆን ዓለምም ቢሆን ሕይወትም ቢሆን ሞትም ቢሆን ያለውም ቢሆን የሚመጣውም ቢሆን፥ ");
INSERT INTO amh_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","ሁሉ የእናንተ ነው፥ እናንተም የክርስቶስ ናችሁ ክርስቶስም የእግዚአብሔር ነው። ");
INSERT INTO amh_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","እንዲሁ ሰው እኛን እንደ ክርስቶስ ሎሌዎችና እንደ እግዚአብሔር ምሥጢር መጋቢዎች ይቍጠረን። ");
INSERT INTO amh_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","እንደዚህም ሲሆን፥ በመጋቢዎች ዘንድ የታመነ ሆኖ መገኘት ይፈለጋል። ");
INSERT INTO amh_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","ነገር ግን በእናንተ ዘንድ ወይም በሌላ ሰው ዘንድ ብፈረድ ለእኔ ምንም አይደለም፤ እኔም በራሴ እንኳ አልፈርድም፤ ");
INSERT INTO amh_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","በራሴ ላይ ምንም አላውቅምና፥ ነገር ግን በዚህ አልጸድቅም፤ እኔን የሚፈርድ ግን ጌታ ነው። ");
INSERT INTO amh_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","ስለዚህም በጨለማ የተሰወረውን ደግሞ ወደ ብርሃን የሚያወጣ የልብንም ምክር የሚገልጥ ጌታ እስኪመጣ ድረስ ጊዜው ሳይደርስ አንዳች አትፍረዱ፤ በዚያን ጊዜም ለእያንዳንዱ ምስጋናው ከእግዚአብሔር ዘንድ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","ወንድሞች ሆይ፥ ስለ አንዱ በአንዱ ላይ አንዳችሁም እንዳይታበዩ። ከተጻፈው አትለፍ የሚለውን በእኛ ትማሩ ዘንድ፥ ይህን በእናንተ ምክንያት ስለ ራሴና ስለ አጵሎስ እንደ ምሳሌ ተናገርሁ። ");
INSERT INTO amh_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","አንተ እንድትበልጥ ማን አድርጎሃል? ያልተቀበልኸውስ ምን አለህ? የተቀበልህ ከሆንህ ግን እንዳልተቀበልህ የምትመካ ስለ ምንድር ነው? ");
INSERT INTO amh_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","አሁን ጠግባችኋል፤ አሁንስ ባለ ጠጎች ሆናችኋል፤ ያለ እኛ ነግሣችኋል፤ እኛ ደግሞ ከእናንተ ጋር እንድንነግሥ ብትነግሡ መልካም ይሆን ነበር። ");
INSERT INTO amh_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","ለዓለም ለመላእክትም ለሰዎችም መጫወቻ ሆነናልና፤ እግዚአብሔር እኛን ሐዋርያቱን ሞት እንደ ተፈረደባቸው ሰዎች ከሁሉ ይልቅ የኋለኞች እንዳደረገን ይመስለኛልና። ");
INSERT INTO amh_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","እኛ ስለ ክርስቶስ ሞኞች ነን እናንተ ግን በክርስቶስ ልባሞች ናችሁ፤ እኛ ደካሞች ነን እናንተ ግን ኃይለኞች ናችሁ፤ እናንተ የከበራችሁ ናችሁ እኛ ግን የተዋረድን ነን። ");
INSERT INTO amh_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","እስከዚህ ሰዓት ድረስ እንራባለን፥ እንጠማለን፥ እንራቆታለን፥ እንጐሰማለን፥ እንንከራተታለን፥ ");
INSERT INTO amh_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","በገዛ እጃችን እየሠራን እንደክማለን፤ ሲሰድቡን እንመርቃለን፥ ሲያሳድዱን እንታገሣለን፥ ክፉ ሲናገሩን እንማልዳለን፤ ");
INSERT INTO amh_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","እስከ አሁን ድረስ የዓለም ጥራጊ የሁሉም ጉድፍ ሆነናል። ");
INSERT INTO amh_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","እንደምወዳችሁ ልጆቼ አድርጌ ልገሥጻችሁ እንጂ ላሳፍራችሁ ይህን አልጽፍም። ");
INSERT INTO amh_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","በክርስቶስ አእላፍ ሞግዚቶች ቢኖሩአችሁ ብዙ አባቶች የሉአችሁም እኔ በክርስቶስ ኢየሱስ በወንጌል ወልጄአችኋለሁና። ");
INSERT INTO amh_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","እንግዲህ እኔን የምትመስሉ ሁኑ ብዬ እለምናችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ስለዚህ የምወደውንና የታመነውን በጌታ ልጄ የሆነውን ጢሞቴዎስን ልኬላችኋለሁ፥ እኔም በየስፍራው በአብያተ ክርስቲያናት ሁሉ እንደማስተምር በክርስቶስ ኢየሱስ የሚሆነውን መንገዴን እርሱ ያሳስባችኋል። ");
INSERT INTO amh_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","አንዳንዱ ግን ወደ እናንተ የማልመጣ እየመሰላቸው የታበዩ አሉ፤ ");
INSERT INTO amh_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","ነገር ግን ጌታ ቢፈቅድ ፈጥኜ ወደ እናንተ እመጣለሁ፥ የትዕቢተኞችንም ኃይል አውቃለሁ እንጂ ቃላቸውን አይደለም፤ ");
INSERT INTO amh_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","የእግዚአብሔር መንግሥት በኃይል ነው እንጂ በቃል አይደለምና። ");
INSERT INTO amh_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","ምን ትወዳላችሁ? በበትር ወይስ በፍቅርና በየውሃት መንፈስ ልምጣባችሁን? ");
INSERT INTO amh_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","በአጭር ቃል በእናንተ መካከል ዝሙት እንዳለ ይወራል የዚያም ዓይነት ዝሙት በአሕዛብስ እንኳ የማይገኝ ነው፥ የአባቱን ሚስት ያገባ ሰው ይኖራልና። ");
INSERT INTO amh_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","እናንተም ታብያችኋል፤ ይልቅስ እንድታዝኑ አይገባችሁምን? ይህን ሥራ የሠራው ከመካከላችሁ ይወገድ። ");
INSERT INTO amh_vpl VALUES ("C15_3","076_5_3","1CO","5","3","5","መንፈሱ በጌታ በኢየሱስ ቀን ትድን ዘንድ እንደዚህ ያለው ለሥጋው ጥፋት ለሰይጣን እንዲሰጥ ፍርዴ ነው። ");
INSERT INTO amh_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","መመካታችሁ መልካም አይደለም። ጥቂት እርሾ ሊጡን ሁሉ እንዲያቦካ አታውቁምን? ");
INSERT INTO amh_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","እንግዲህ ያለ እርሾ እንዳላችሁ አዲሱን ሊጥ ትሆኑ ዘንድ አሮጌውን እርሾ አስወግዱ። ፋሲካችን ክርስቶስ ታርዶአልና፤ ");
INSERT INTO amh_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ስለዚህ በቅንነትና በእውነት ቂጣ በዓልን እናድርግ እንጂ በአሮጌ እርሾ በክፋትና በግፍ እርሾም አይደለም። ");
INSERT INTO amh_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","ከሴሰኞች ጋር እንዳትተባበሩ በመልእክቴ ጻፍሁላችሁ። ");
INSERT INTO amh_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","በጠቅላላው የዚህን ዓለም ሴሰኞችን፥ ወይም ገንዘብን የሚመኙትን ነጣቂዎችንም፥ ወይም ጣዖትን የሚያመልኩትን አላልሁም፤ ይህስ ቢሆን ከዓለም ልትወጡ ይገባችሁ ነበር። ");
INSERT INTO amh_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","አሁን ግን ወንድሞች ከሚባሉት አንዱ ሴሰኛ ወይም ገንዘብን የሚመኝ ወይም ጣዖትን የሚያመልክ ወይም ተሳዳቢ ወይም ሰካር ወይም ነጣቂ ቢሆን ከእርሱ ጋር እንዳትተባበሩ እጽፍላችኋለሁ፤ እንደነዚህ ካለው ጋር መብል እንኳን አትብሉ። ");
INSERT INTO amh_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","በውጭ ባሉ ሰዎች ላይ መፍረድ ምን አግዶኝ? በውስጥ ባሉ ሰዎች ላይ እናንተ አትፈርዱምን? ");
INSERT INTO amh_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","በውጭ ባሉቱ ግን እግዚአብሔር ይፈርድባቸዋል። ክፉውን ከመካከላችሁ አውጡት። ");
INSERT INTO amh_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","ከእናንተ አንዱ ከባልንጀራው ጋር ሙግት ቢኖረው በቅዱሳን ፊት በመፋረድ ፋንታ በዓመፀኞች ፊት ሊፋረድ ይደፍራልን? ");
INSERT INTO amh_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ቅዱሳን በዓለም ላይ እንዲፈርዱ አታውቁምን? በዓለምስ ላይ ብትፈርዱ ከሁሉ ይልቅ ትንሽ ስለሚሆን ነገር ልትፈርዱ አትበቁምን? ");
INSERT INTO amh_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","የትዳር ጉዳይ ይቅርና በመላእክት እንኳ እንድንፈርድ አታውቁምን? ");
INSERT INTO amh_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","እንግዲህ ስለ ትዳር ጉዳይ የፍርድ ቤት ቢያስፈልጋችሁ በቤተ ክርስቲያን የተናቁትን ሰዎች ፈራጆች አድርጋችሁ ታስቀምጣላችሁን? ");
INSERT INTO amh_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","አሳፍራችሁ ዘንድ ይህን እላለሁ። እንደዚህ ነውን? በወንድሞች መካከል ሽማግሌ ሊሆን የሚችል አንድ አስተዋይ ሰው በእናንተ ዘንድ አይገኝምን? ");
INSERT INTO amh_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","ነገር ግን ወንድም ወንድሙን ይከሳል፥ ይህም በማያምኑ ፊት ይደረጋልን? ");
INSERT INTO amh_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","እንግዲህ ፈጽሞ የእርስ በርስ ሙግት እንዳለባችሁ በእናንተ ጉድለት ነው። ብትበደሉ አይሻልምን? ብትታለሉስ አይሻልምን? ");
INSERT INTO amh_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","ነገር ግን እናንተ ትበድላላችሁ ታታልሉማላችሁ፥ ያውም ወንድሞቻችሁን። ");
INSERT INTO amh_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ወይስ ዓመፀኞች የእግዚአብሔርን መንግሥት እንዳይወርሱ አታውቁምን? አትሳቱ፤ ሴሰኞች ቢሆን ወይም ጣዖትን የሚያመልኩ ወይም አመንዝሮች ወይም ቀላጮች ወይም ከወንድ ጋር ዝሙት የሚሠሩ ");
INSERT INTO amh_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ወይም ሌቦች ወይም ገንዘብን የሚመኙ ወይም ሰካሮች ወይም ተሳዳቢዎች ወይም ነጣቂዎች የእግዚአብሔርን መንግሥት አይወርሱም። ");
INSERT INTO amh_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","ከእናንተም አንዳንዶቹ እንደ እነዚህ ነበራችሁ፤ ነገር ግን በጌታ በኢየሱስ ክርስቶስ ስም በአምላካችንም መንፈስ ታጥባችኋል፥ ተቀድሳችኋል፥ ጸድቃችኋል። ");
INSERT INTO amh_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","ሁሉ ተፈቅዶልኛል፥ ሁሉ ግን አይጠቅምም። ሁሉ ተፈቅዶልኛል፥ በእኔ ላይ ግን አንድ ነገር እንኳ አይሠለጥንብኝም። ");
INSERT INTO amh_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","መብል ለሆድ ነው፥ ሆድም ለመብል ነው፤ እግዚአብሔር ግን ይህንም ያንም ያጠፋቸዋል። ሥጋ ግን ለጌታ ነው እንጂ ለዝሙት አይደለም፤ ጌታም ለሥጋ ነው፤ ");
INSERT INTO amh_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","እግዚአብሔርም ጌታንም አስነሣ እኛንም በኃይሉ ያስነሣናል። ");
INSERT INTO amh_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","ሥጋችሁ የክርስቶስ ብልቶች እንደ ሆነ አታውቁምን? እንግዲህ የክርስቶስን ብልቶች ወስጄ የጋለሞታ ብልቶች ላድርጋቸውን? አይገባም። ");
INSERT INTO amh_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","ወይስ ከጋለሞታ ጋር የሚተባበር አንድ ሥጋ እንዲሆን አታውቁምን? ሁለቱ አንድ ሥጋ ይሆናሉ ተብሎአልና። ");
INSERT INTO amh_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","ከጌታ ጋር የሚተባበር ግን አንድ መንፈስ ነው። ");
INSERT INTO amh_vpl VALUES ("C16_18","076_6_18","1CO","6","18","20","ከዝሙት ሽሹ። ሰው የሚያደርገው ኃጢአት ሁሉ ከሥጋ ውጭ ነው፤ ዝሙትን የሚሠራ ግን በገዛ ሥጋው ላይ ኃጢአትን ይሠራል። ");
INSERT INTO amh_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","ስለ ጻፋችሁልኝስ ነገር፥ ከሴት ጋር አለመገናኘት ለሰው መልካም ነው። ");
INSERT INTO amh_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","ነገር ግን ስለ ዝሙት ጠንቅ ለእያንዳንዱ ለራሱ ሚስት ትኑረው ለእያንዳንዲቱ ደግሞ ለራስዋ ባል ይኑራት። ");
INSERT INTO amh_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","ባል ለሚስቱ የሚገባትን ያድርግላት፥ እንደዚሁም ደግሞ ሚስቲቱ ለባልዋ። ");
INSERT INTO amh_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ሚስት በገዛ ሥጋዋ ላይ ሥልጣን የላትም፥ ሥልጣን ለባልዋ ነው እንጂ፤ እንዲሁም ደግሞ ባል በገዛ ሥጋው ላይ ሥልጣን የለውም፥ ሥልጣን ለሚስቱ ነው እንጂ። ");
INSERT INTO amh_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ለጸሎት ትተጉ ዘንድ ተስማምታችሁ ለጊዜው ካልሆነ በቀር፥ እርስ በርሳችሁ አትከላከሉ፤ ራሳችሁን ስለ አለመግዛት ሰይጣን እንዳይፈታተናችሁ ደግሞ አብራችሁ ሁኑ። ");
INSERT INTO amh_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","ዳሩ ግን ይህን እንደ ፈቃድ እላለሁ እንጂ እንደ ትእዛዝ አይደለም። ");
INSERT INTO amh_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","ሰው ሁሉ እንደ እኔ ሊሆን እወዳለሁና፤ ነገር ግን እያንዳንዱ ከእግዚአብሔር ለራሱ የጸጋ ስጦታ አለው፥ አንዱ እንደዚህ ሁለተኛውም እንደዚያ። ");
INSERT INTO amh_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","ላላገቡና ለመበለቶች ግን እላለሁ። እንደ እኔ ቢኖሩ ለእነርሱ መልካም ነው፤ ");
INSERT INTO amh_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","ነገር ግን በምኞት ከመቃጠል መጋባት ይሻላልና ራሳቸውን መግዛት ባይችሉ ያግቡ። ");
INSERT INTO amh_vpl VALUES ("C17_10","076_7_10","1CO","7","10","12","ሌሎችንም እኔ እላለሁ፥ ጌታም አይደለም፤ ከወንድሞች ወገን ያላመነች ሚስት ያለችው ቢኖር እርስዋም ከእርሱ ጋር ልትቀመጥ ብትስማማ፥ አይተዋት፤ ");
INSERT INTO amh_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","ያላመነ ባል ያላት ሚስትም ብትኖር ይህ ከእርስዋ ጋር ሊቀመጥ ቢስማማ፥ አትተወው። ");
INSERT INTO amh_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","ያላመነ ባል በሚስቱ ተቀድሶአልና፥ ያላመነችም ሚስት በባልዋ ተቀድሳለች፤ አለዚያ ልጆቻችሁ ርኵሳን ናቸው፤ አሁን ግን የተቀደሱ ናቸው። ");
INSERT INTO amh_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","የማያምን ግን ቢለይ ይለይ፤ ወንድም ቢሆን ወይም እኅት እንዲህ በሚመስል ነገር አይገዙም፤ እግዚአብሔር ግን በሰላም ጠርቶናል። ");
INSERT INTO amh_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","አንቺ ሴት፥ ባልሽን ታድኚ እንደ ሆንሽ ምን ታውቂአለሽ? ወይስ አንተ ሰው፥ ሚስትህን ታድን እንደ ሆንህ ምን ታውቃለህ? ");
INSERT INTO amh_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","ብቻ ለእያንዳንዱ እግዚአብሔር እንደ ከፈለለት እያንዳንዱም እግዚአብሔር እንደ ጠራው እንዲሁ ይመላለስ። እንዲሁም በአብያተ ክርስቲያናት ሁሉ እደነግጋለሁ። ");
INSERT INTO amh_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ማንም ተገርዞ ሳለ ተጠርቶ እንደ ሆነ፥ ወደ አለመገረዝ አይመለስ፤ ማንም ሳይገረዝ ተጠርቶ እንደ ሆነ አይገረዝ። ");
INSERT INTO amh_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","መገረዝ ቢሆን አለመገረዝም ቢሆን ከንቱ ነው፥ የእግዚአብሔርን ትእዛዝ መጠበቅ ነው እንጂ። ");
INSERT INTO amh_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","እያንዳንዱ በተጠራበት መጠራት እንደዚሁ ይኑር። ");
INSERT INTO amh_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","ባሪያ ሆነህ ተጠርተህ እንደ ሆነ አይገድህም፤ አርነት ልትወጣ ቢቻልህ ግን አርነትን ተቀበል። ");
INSERT INTO amh_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","ባሪያ ሆኖ በጌታ የተጠራ የጌታ ነጻ ነውና፤ እንዲሁም ነጻ ሆኖ የተጠራ የክርስቶስ ባሪያ ነው። ");
INSERT INTO amh_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","በዋጋ ተገዝታችኋል፤ የሰው ባሪያዎች አትሁኑ። ");
INSERT INTO amh_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","ወንድሞች ሆይ፥ እያንዳንዱ በተጠራበት እንደዚሁ ሆኖ በእግዚአብሔር ዘንድ ይኑር። ");
INSERT INTO amh_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","ስለ ደናግልም የጌታ ትእዛዝ የለኝም፥ ነገር ግን የታመንሁ እሆን ዘንድ ከጌታ ምሕረትን የተቀበልሁ እንደ መሆኔ ምክር እመክራለሁ። ");
INSERT INTO amh_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","እንግዲህ ስለ አሁኑ ችግር ይህ መልካም ይመስለኛል፤ ሰው እንዲህ ሆኖ ቢኖር መልካም ነው። ");
INSERT INTO amh_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","በሚስት ታስረህ እንደ ሆንህ መፋታትን አትሻ፤ በሚስት አልታሰርህ እንደ ሆንህ ሚስትን አትሻ። ");
INSERT INTO amh_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","ብታገባ ግን ኃጢአት አትሠራም ድንግሊቱም ብታገባ ኃጢአት አትሠራም፤ ነገር ግን እንዲህ በሚያደርጉ በሥጋቸው ላይ መከራ ይሆንባቸዋል፥ እኔም እራራላችሁ ነበር። ");
INSERT INTO amh_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","ዳሩ ግን፥ ወንድሞች ሆይ፥ ይህን እናገራለሁ፤ ዘመኑ አጭር ሆኖአል፤ ከእንግዲህ ወዲህ ሚስቶች ያሉአቸው እንደሌላቸው ይሁኑ፥ ");
INSERT INTO amh_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","የሚያለቅሱም እንደማያለቅሱ፥ ደስ የሚላቸውም ደስ እንደማይላቸው፥ ");
INSERT INTO amh_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","የሚገዙም ምንም እንደሌላቸው፥ በዚችም ዓለም የሚጠቀሙ በሙሉ እንደማይጠቀሙባት ይሁኑ፤ የዚች ዓለም መልክ አላፊ ነውና። ");
INSERT INTO amh_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","ነገር ግን ያለ አሳብ ልትኖሩ እወዳለሁ። ያላገባው ጌታን እንዴት ደስ እንዲያሰኘው የጌታን ነገር ያስባል፤ ");
INSERT INTO amh_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","ያገባው ግን ሚስቱን እንዴት ደስ እንዲያሰኛት የዓለምን ነገር ያስባል፥ ልቡም ተከፍሎአል። ");
INSERT INTO amh_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","ያልተጋባች ሴትና ድንግል በሥጋም በነፍስም እንዲቀደሱ የጌታን ነገር ያስባሉ፤ የተጋባች ግን ባልዋን እንዴት ደስ እንድታሰኘው የዓለምን ነገር ታስባለች። ");
INSERT INTO amh_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","ይህንም ለራሳችሁ ጥቅም እላለሁ፤ በአገባብ እንድትኖሩ ሳትባክኑም በጌታ እንድትጸኑ ነው እንጂ ላጠምዳችሁ ብዬ አይደለም። ");
INSERT INTO amh_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","ዳሩ ግን ማግባት ወደሚገባው ዕድሜ በደረሰ ጊዜ ስለ ድንግልናው ያፈረ ሰው ቢኖር፥ የወደደውን ያድርግ፤ ኃጢአት የለበትም፤ ይጋቡ። ");
INSERT INTO amh_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","ሳይናወጥ በልቡ የጸና ግን ግድ የለበትም፥ የወደደውን እንዲያደርግ ተፈቅዶለታል፤ ድንግልናውንም በልቡ ይጠብቅ ዘንድ ቢጸና፥ መልካም አደረገ። ");
INSERT INTO amh_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","እንዲሁም ድንግልን ያገባ መልካም አደረገ ያላገባም የተሻለ አደረገ። ");
INSERT INTO amh_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","ሴት ባልዋ በሕይወት ሳለ የታሰረች ናት፤ ባልዋ ቢሞት ግን በጌታ ይሁን እንጂ የወደደችውን ልታገባ ነጻነት አላት። ");
INSERT INTO amh_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","እንደ ምክሬ ግን እንዳለች ብትኖር ደስተኛ ናት፤ እኔም ደግሞ የእግዚአብሔር መንፈስ በእኔ ያለ ይመስለኛል። ");
INSERT INTO amh_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","ለጣዖት ስለ ተሠዋ ሥጋም፥ ሁላችን እውቀት እንዳለን እናውቃለን። እውቀት ያስታብያል ፍቅር ግን ያንጻል። ");
INSERT INTO amh_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","ማንም አንዳች የሚያውቅ ቢመስለው ሊያውቅ እንደሚገባው ገና አላወቀም፤ ");
INSERT INTO amh_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","ማንም ግን እግዚአብሔርን ቢወድ እርሱ በእርሱ ዘንድ የታወቀ ነው። ");
INSERT INTO amh_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","እንግዲህ ለጣዖት የተሠዋውን ሥጋ ስለ መብላት፥ ጣዖት ሁሉ በዓለም ከንቱ እንደ ሆነ ከአንዱም በቀር ማንም አምላክ እንደሌለ እናውቃለን። ");
INSERT INTO amh_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","መቼም ብዙ አማልክትና ብዙ ጌቶች አሉ፤ ነገር ግን በሰማይ ሆነ በምድርም ሆነ አማልክት የተባሉ ምንም ቢኖሩ፥ ");
INSERT INTO amh_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ለእኛስ ነገር ሁሉ ከእርሱ የሆነ እኛም ለእርሱ የሆንን አንድ አምላክ አብ አለን፥ ነገር ሁሉም በእርሱ በኩል የሆነ እኛም በእርሱ በኩል የሆንን አንድ ጌታ ኢየሱስ ክርስቶስ አለን። ");
INSERT INTO amh_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","ነገር ግን ይህ እውቀት በሁሉ ዘንድ አይገኝም፤ አንዳንዶች ግን ጣዖትን እስከ አሁን ድረስ ስለ ለመዱ። ለጣዖት የተሠዋ ነው ብለው ይበላሉና ሕሊናቸው ደካማ ስለ ሆነ ይረክሳል። ");
INSERT INTO amh_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","መብል ግን ወደ እግዚአብሔር አያቀርበንም፤ ባንበላም ምንም አይጎድለንም ብንበላም ምንም አይተርፈንም። ");
INSERT INTO amh_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","ዳሩ ግን ይህ መብታችሁ ለደካሞች ዕንቅፋት እንዳይሆንባቸው ተጠንቀቁ። ");
INSERT INTO amh_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","አንተ እውቀት ያለህ በጣዖት ቤት በማዕድ ስትቀመጥ አንድ ሰው ቢያይህ፥ ደካማ ሰው ቢሆን ለጣዖት የተሠዋውን ለመብላት ሕሊናው አይታነጽበትምን? ");
INSERT INTO amh_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","በአንተ እውቀትም ይህ ደካማ ይጠፋል፥ እርሱም ክርስቶስ የሞተለት ወንድም ነው። ");
INSERT INTO amh_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","እንዲህም ወንድሞችን እየበደላችሁ ደካማም የሆነውን ሕሊናቸውን እያቆሰላችሁ ክርስቶስን ትበድላላችሁ። ");
INSERT INTO amh_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","ስለዚህም መብል ወንድሜን የሚያሰናክለው ከሆነ፥ ወንድሜን እንዳላሰናክለው ለዘላለም ከቶ ሥጋ አልበላም። ");
INSERT INTO amh_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","እኔ ነጻ አይደለሁምን? ሐዋርያስ አይደለሁምን? ጌታችንን ኢየሱስ ክርስቶስንስ አላየሁትምን? እናንተስ በጌታ ሥራዬ አይደላችሁምን? ");
INSERT INTO amh_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","የሐዋርያነቴ ማኅተም በጌታ እናንተ ናችሁና ለሌሎች ሐዋርያ ባልሆን ለእናንተስ ምንም ቢሆን ሐዋርያ ነኝ። ");
INSERT INTO amh_vpl VALUES ("C19_3","076_9_3","1CO","9","3","5","እንደ ሌሎቹ ሐዋርያትና እንደ ጌታ ወንድሞች እንደ ኬፋም፥ እኅት ሚስታችንን ይዘን ልንዞር መብት የለንምን? ");
INSERT INTO amh_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","ወይስ ሥራን ለመተው መብት የሌለን እኔና በርናባስ ብቻ ነን? ");
INSERT INTO amh_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","ከቶ በገዛ ገንዘቡ በወታደርነት የሚያገለግል ማን ነው? ወይስ ወይን ተክሎ ፍሬውን የማይበላ ማን ነው? ወይስ መንጋ እየጠበቀ ከመንጋው ወተት የማይጠጣ ማን ነው? ");
INSERT INTO amh_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","ይህን በሰው ሥልጣን ብቻ እላለሁን? ");
INSERT INTO amh_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","ሕግስ ደግሞ ያን አይልምን? የሚያበራየውን በሬ አፉን አትሰር ተብሎ በሙሴ ሕግ ተጽፎአልና። እግዚአብሔርስ ስለ በሬዎች ይገደዋልን? ");
INSERT INTO amh_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","ይህን የሚለው ፈጽሞ ስለ እኛ አይደለምን? የሚያርስ በተስፋ ሊያርስ የሚያበራይም እንዲካፈል በተስፋ ሊያበራይ ስለሚገባው በእውነት ስለ እኛ ተጽፎአል። ");
INSERT INTO amh_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","እኛ መንፈሳዊን ነገር የዘራንላችሁ ከሆንን የእናንተን የሥጋዊን ነገር እኛ ብናጭድ ትልቅ ነገር ነውን? ");
INSERT INTO amh_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","ሌሎች በእናንተ ላይ ይህን መብት የሚካፈሉ ከሆኑ እኛማ ይልቁን እንዴታ? ነገር ግን የክርስቶስን ወንጌል እንዳንከለክል በሁሉ እንታገሣለን እንጂ በዚህ መብት አልተጠቀምንም። ");
INSERT INTO amh_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","በመቅደስ ነገር የሚያገለግሉ ከመቅደስ የሆነውን ነገርን እንዲመገቡ፥ በመሠዊያውም የሚጸኑ ከመሠዊያው እንዲካፈሉ አታውቁምን? ");
INSERT INTO amh_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","እንዲሁ ደግሞ ወንጌልን የሚሰብኩ ከወንጌል ቀለብ እንዲቀበሉ ጌታ ደንግጎአል። ");
INSERT INTO amh_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","እኔ ግን ከእነዚህ ሁሉ ምንም አልተጠቀምሁም። እንዲህ እንዲሆንልኝ ይህን አልጽፍም፤ ማንም ትምክህቴን ከንቱ ከሚያደርግብኝ ሞት ይሻለኛልና። ");
INSERT INTO amh_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","ወንጌልን ብሰብክ እንኳ የምመካበት የለኝም፤ ግድ ደርሶብኝ ነውና፤ ወንጌልንም ባልሰብክ ወዮልኝ። ");
INSERT INTO amh_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ይህን በፈቃዴ ባደርገው ደመወዝ አለኝና፤ ያለ ፈቃዴ ግን ባደርገው መጋቢነት በአደራ ተሰጥቶኛል። ");
INSERT INTO amh_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","እንግዲህ ደመወዜ ምንድር ነው? ወንጌልን እየሰበክሁ በወንጌል ካለኝ መብት በሙሉ እንዳልጠቀም ወንጌልን ያለ ዋጋ ብናገር ነው። ");
INSERT INTO amh_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","ከሰው ሁሉ አርነት የወጣሁ ስሆን የሚበልጡትን እንድጠቅም እንደ ባሪያ ራሴን ለሁሉ አስገዛለሁ። ");
INSERT INTO amh_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","አይሁድንም እጠቅም ዘንድ ከአይሁድ ጋር እንደ አይሁዳዊ ሆንሁ፤ ከሕግ በታች ያሉትን እጠቅም ዘንድ፥ እኔ ራሴ ከሕግ በታች ሳልሆን፥ ከሕግ በታች ላሉት ከሕግ በታች እንዳለሁ ሆንሁ፤ ");
INSERT INTO amh_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","ሕግ የሌላቸውን እጠቅም ዘንድ፥ ያለ እግዚአብሔር ህግ ሳልኖር ነገር ግን በክርስቶስ ሕግ በታች ሳለሁ፥ ሕግ ለሌላቸው ሕግ እንደ ሌለኝ ሆንሁ፤ ");
INSERT INTO amh_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","ደካሞችን እጠቅም ዘንድ ለደካሞች እንደ ደካማ ሆንሁ፤ በሁሉ መንገድ አንዳንዶችን አድን ዘንድ፥ ከሁሉ ጋር በሁሉ ነገር እንደ እነርሱ ሆንሁ። ");
INSERT INTO amh_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","በወንጌልም ማኅበረተኛ እሆን ዘንድ ስለ ወንጌል ሁሉን አደርጋለሁ። ");
INSERT INTO amh_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","በእሽቅድምድም ስፍራ የሚሮጡት፥ ሁሉ እንዲሮጡ ነገር ግን አንዱ ብቻ ዋጋውን እንዲቀበል አታውቁምን? እንዲሁም ታገኙ ዘንድ ሩጡ። ");
INSERT INTO amh_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","የሚታገልም ሁሉ በነገር ሁሉ ሰውነቱን ይገዛል፤ እነዚያም የሚጠፋውን አክሊል ሊያገኙ ነው፥ እኛ ግን የማይጠፋውን። ");
INSERT INTO amh_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","ስለዚህ እኔ ያለ አሳብ እንደሚሮጥ ሁሉ እንዲሁ አልሮጥም፥ ነፋስን እንደሚጎስም ሁሉ እንዲሁ አልጋደልም፤ ");
INSERT INTO amh_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ነገር ግን ለሌሎች ከሰበክሁ በኋላ ራሴ የተጣልሁ እንዳልሆን ሥጋዬን እየጎሰምሁ አስገዛዋለሁ። ");
INSERT INTO amh_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","ወንድሞች ሆይ፥ ይህን ታውቁ ዘንድ እወዳለሁ። አባቶቻችን ሁሉ ከደመና በታች ነበሩ ሁሉም በባሕር መካከል ተሻገሩ፤ ");
INSERT INTO amh_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","ሁሉም ሙሴን ይተባበሩ ዘንድ በደመናና በባሕር ተጠመቁ፤ ");
INSERT INTO amh_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","ሁሉም ያን መንፈሳዊ መብል በሉ ሁሉም ያን መንፈሳዊ መጠጥ ጠጡ፤ ");
INSERT INTO amh_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ይከተላቸው ከነበረው ከመንፈሳዊ ዓለት ጠጥተዋልና፥ ያም ዓለት ክርስቶስ ነበረ። ");
INSERT INTO amh_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","እግዚአብሔር ግን ከእነርሱ በሚበዙት ደስ አላለውም፥ በምድረ በዳ ወድቀዋልና። ");
INSERT INTO amh_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","እነዚህም ክፉ ነገር እንደ ተመኙ እኛ ደግሞ እንዳንመኝ ይህ ምሳሌ ሆነልን። ");
INSERT INTO amh_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","ሕዝብም ሊበሉ ሊጠጡም ተቀመጡ ሊዘፍኑም ተነሡ ተብሎ እንደ ተጻፈ ከእነርሱ አንዳንዶቹ እንዳደረጉት ጣዖትን የምታመልኩ አትሁኑ። ");
INSERT INTO amh_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","ከእነርሱም አንዳንዶቹ እንደ ሴሰኑ በአንድ ቀንም ሁለት እልፍ ከሦስት ሺህ እንደ ወደቁ አንሴስን። ");
INSERT INTO amh_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","ከእነርሱም አንዳንዶቹ ጌታን እንደ ተፈታተኑት በእባቦቹም እንደ ጠፉ ጌታን አንፈታተን። ");
INSERT INTO amh_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","ከእነርሱም አንዳንዶቹ እንዳንጎራጎሩ በሚያጠፋውም እንደ ጠፉ አታንጐርጕሩ። ");
INSERT INTO amh_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","ይህም ሁሉ እንደ ምሳሌ ሆነባቸው፥ እኛንም የዘመናት መጨረሻ የደረሰብንን ሊገሥጸን ተጻፈ። ");
INSERT INTO amh_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","ስለዚህ እንደ ቆመ የሚመስለው እንዳይወድቅ ይጠንቀቅ። ");
INSERT INTO amh_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","ለሰው ሁሉ ከሚሆነው በቀር ምንም ፈተና አልደረሰባችሁም፤ ነገር ግን ከሚቻላችሁ መጠን ይልቅ ትፈተኑ ዘንድ የማይፈቅድ እግዚአብሔር የታመነ ነው፥ ትታገሡም ዘንድ እንድትችሉ ከፈተናው ጋር መውጫውን ደግሞ ያደርግላችኋል። ");
INSERT INTO amh_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","ስለዚህ፥ ወዳጆቼ ሆይ፥ ጣዖትን ከማምለክ ሽሹ። ");
INSERT INTO amh_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","ልባሞች እንደ መሆናችሁ እላለሁ፤ በምለው ነገር እናንተ ፍረዱ። ");
INSERT INTO amh_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","የምንባርከው የበረከት ጽዋ ከክርስቶስ ደም ጋር ኅብረት ያለው አይደለምን? የምንቆርሰውስ እንጀራ ከክርስቶስ ሥጋ ጋር ኅብረት ያለው አይደለምን? ");
INSERT INTO amh_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","አንድ እንጀራ ስለ ሆነ፥ እኛ ብዙዎች ስንሆን አንድ ሥጋ ነን፤ ሁላችን ያን አንዱን እንጀራ እንካፈላለንና። ");
INSERT INTO amh_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","በሥጋ የሆነውን እስራኤል ተመልከቱ፤ መሥዋዕቱን የሚበሉ የመሠዊያው ማኅበረተኞች አይደሉምን? ");
INSERT INTO amh_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","እንግዲህ ምን እላለሁ? ለጣዖት የተሠዋ ምናምን ነው እላለሁን? ወይስ ጣዖት ምናምን እንዲሆን እላለሁን? ");
INSERT INTO amh_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","አይደለም፤ ነገር ግን አሕዛብ የሚሠዉት ለአጋንንት እንዲሆን እንጂ ለእግዚአብሔር እንዳይሠዉ እላለሁ፤ ከአጋንንትም ጋር ማኅበረተኞች እንድትሆኑ አልወድም። ");
INSERT INTO amh_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","የጌታን ጽዋና የአጋንንትን ጽዋ ልትጠጡ አትችሉም፤ ከጌታ ማዕድና ከአጋንንት ማዕድ ልትካፈሉ አትችሉም። ");
INSERT INTO amh_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","ወይስ ጌታን እናስቀናውን? እኛስ ከእርሱ ይልቅ እንበረታለንን? ");
INSERT INTO amh_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","ሁሉ ተፈቅዶልኛል፥ ሁሉ ግን የሚጠቅም አይደለም፤ ሁሉ ተፈቅዶልኛል፥ ነገር ግን ሁሉ የሚያንጽ አይደለም። ");
INSERT INTO amh_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","እያንዳንዱ የባልንጀራውን ጥቅም እንጂ አንድ ስንኳ የራሱን ጥቅም አይፈልግ። ");
INSERT INTO amh_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","በሥጋ ገበያ የሚሸጠውን ሁሉ ከሕሊና የተነሣ ሳትመራመሩ ብሉ፤ ");
INSERT INTO amh_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","ምድርና በእርስዋ የሞላባት ሁሉ የጌታ ነውና። ");
INSERT INTO amh_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","ከማያምኑ ሰዎች አንዱም ቢጠራችሁ ልትሄዱም ብትወዱ ከሕሊና የተነሣ ሳትመራመሩ የሚያቀርቡላችሁን ሁሉ ብሉ። ");
INSERT INTO amh_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","ማንም ግን። ይህ ለጣዖት የተሠዋ ነው ቢላችሁ ከዚያ ካስታወቃችሁና ከሕሊና የተነሣ አትብሉ፤ ");
INSERT INTO amh_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","ስለ ባልንጀራህ ሕሊና እንጂ ስለ ገዛ ሕሊናህ አልናገርም። አርነቴ በሌላ ሰው ሕሊና የሚፈርድ Avረ ስለ ምንድር ነው? ");
INSERT INTO amh_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","እኔም በጸጋ ብበላ፥ በነገሩ ስለማመሰግንበት ስለ ምን እሰደባለሁ? ");
INSERT INTO amh_vpl VALUES ("C110_31","076_10_31","1CO","10","31","33","እንግዲህ የምትበሉ ወይም የምትጠጡ ብትሆኑ ወይም ማናቸውን ነገር ብታደርጉ ሁሉን ለእግዚአብሔር ክብር አድርጉት። ");
INSERT INTO amh_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","እኔ ክርስቶስን እንደምመስል እኔን ምሰሉ። ");
INSERT INTO amh_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","ወንድሞች ሆይ፥ በሁሉ ስለምታስቡኝና አሳልፌ እንደ ሰጠኋችሁ ወግን ፈጽማችሁ ስለ ያዛችሁ አመሰግናችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","ነገር ግን የወንድ ሁሉ ራስ ክርስቶስ፥ የሴትም ራስ ወንድ፥ የክርስቶስም ራስ እግዚአብሔር እንደ ሆነ ልታውቁ እወዳለሁ። ");
INSERT INTO amh_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","ራሱን ተከናንቦ የሚጸልይ ወይም ትንቢት የሚናገር ወንድ ሁሉ ራሱን ያዋርዳል። ");
INSERT INTO amh_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","ራስዋን ሳትሸፍን ግን የምትጸልይ ወይም ትንቢት የምትናገር ሴት ሁሉ ራስዋን ታዋርዳለች፤ እንደ ተላጨች ያህል አንድ ነውና። ");
INSERT INTO amh_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","ሴትም ራስዋን ባትሸፍን ጠጉርዋን ደግሞ ትቆረጥ፤ ለሴት ግን ጠጉርዋን መቆረጥ ወይም መላጨት የሚያሳፍር ከሆነ ራስዋን ትሸፍን። ");
INSERT INTO amh_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","ወንድ የእግዚአብሔር ምሳሌና ክብር ስለ ሆነ ራሱን መከናነብ አይገባውም፤ ሴት ግን የወንድ ክብር ናት። ");
INSERT INTO amh_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","ሴት ከወንድ ናት እንጂ ወንድ ከሴት አይደለምና። ");
INSERT INTO amh_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","ሴት ስለ ወንድ ተፈጠረች እንጂ ወንድ ስለ ሴት አልተፈጠረምና። ");
INSERT INTO amh_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","ስለዚህ ሴት ከመላእክት የተነሣ በራስዋ ሥልጣን ሊኖራት ይገባል። ");
INSERT INTO amh_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","ነገር ግን በጌታ ዘንድ ሴት ያለ ወንድ ወንድም ያለ ሴት አይሆንም። ");
INSERT INTO amh_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","ሴት ከወንድ እንደ ሆነች እንዲሁ ወንድ ደግሞ በሴት ነውና፤ ሁሉም ከእግዚአብሔር ነው። ");
INSERT INTO amh_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","በእናንተ በራሳችሁ መካከል ፍረዱ፤ ሴት ራስዋን ሳትሸፍን ወደ እግዚአብሔር ልትጸልይ ይገባታልን? ");
INSERT INTO amh_vpl VALUES ("C111_14","076_11_14","1CO","11","14","16","ዳሩ ግን ማንም ሊከራከር ቢፈቅድ፥ እኛ ወይም የእግዚአብሔር አብያተ ክርስቲያናት እንዲህ ያለ ልማድ የለንም። ");
INSERT INTO amh_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","ነገር ግን በምትሰበሰቡበት ጊዜ ለሚከፋ እንጂ ለሚሻል ስላልሆነ ይህን ትእዛዝ ስሰጥ የማመሰግናችሁ አይደለም። ");
INSERT INTO amh_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","በመጀመሪያ ወደ ማኅበር ስትሰበሰቡ በመካከላችሁ መለያየት እንዳለ እሰማለሁና፥ በአንድ በኩልም አምናለሁ። ");
INSERT INTO amh_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","በእናንተ ዘንድ የተፈተኑት እንዲገለጡ በመካከላችሁ ወገኖች ደግሞ ሊሆኑ ግድ ነውና። ");
INSERT INTO amh_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","እንግዲህ አብራችሁ ስትሰበሰቡ የምትበሉት የጌታ እራት አይደለም፤ ");
INSERT INTO amh_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","በመብላት ጊዜ እያንዳንዱ የራሱን እራት ይበላልና፥ አንዱም ይራባል አንዱ ግን ይሰክራል። ");
INSERT INTO amh_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","የምትበሉባቸውና የምትጠጡባቸው ቤቶች የላችሁምን? ወይስ የእግዚአብሔርን ማኅበር ትንቃላችሁን አንዳችም የሌላቸውን ታሳፍራላችሁን? ምን ልበላችሁ? በዚህ ነገር ላመስግናችሁን? አላመሰግናችሁም። ");
INSERT INTO amh_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","ለእናንተ ደግሞ አሳልፌ የሰጠሁትን እኔ ከጌታ ተቀብያለሁና፤ ");
INSERT INTO amh_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","ጌታ ኢየሱስ አልፎ በተሰጠበት በዚያች ሌሊት እንጀራን አንሥቶ አመሰገነ፥ ቆርሶም። እንካችሁ ብሉ፤ ይህ ስለ እናንተ የሚሆን ሥጋዬ ነው፤ ይህን ለመታሰቢያዬ አድርጉት አለ። ");
INSERT INTO amh_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","እንደዚሁም ከእራት በኋላ ጽዋውን ደግሞ አንሥቶ። ይህ ጽዋ በደሜ የሚሆን አዲስ ኪዳን ነው፤ በጠጣችሁት ጊዜ ሁሉ ይህን ለመታሰቢያዬ አድርጉት አለ። ");
INSERT INTO amh_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","ይህን እንጀራ በበላችሁ ጊዜ ሁሉ፥ ይህንም ጽዋ በጠጣችሁ ጊዜ ሁሉ ጌታ እስኪመጣ ድረስ ሞቱን ትናገራላችሁና። ");
INSERT INTO amh_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","ስለዚህ ሳይገባው ይህን እንጀራ የበላ ወይም የጌታን ጽዋ የጠጣ ሁሉ የጌታ ሥጋና ደም ዕዳ አለበት። ");
INSERT INTO amh_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","ሰው ግን ራሱን ይፈትን፥ እንዲሁም ከእንጀራው ይብላ ከጽዋውም ይጠጣ፤ ");
INSERT INTO amh_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","ሳይገባው የሚበላና የሚጠጣ የጌታን ሥጋ ስለማይለይ ለራሱ ፍርድ ይበላልና፥ ይጠጣልምና። ");
INSERT INTO amh_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","ስለዚህ በእናንተ ዘንድ የደከሙና የታመሙ ብዙዎች አሉ አያሌዎችም አንቀላፍተዋል። ");
INSERT INTO amh_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","ራሳችንን ብንመረምር ግን ባልተፈረደብንም ነበር፤ ");
INSERT INTO amh_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","ነገር ግን በተፈረደብን ጊዜ ከዓለም ጋር እንዳንኮነን በጌታ እንገሠጻለን። ");
INSERT INTO amh_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","ስለዚህ፥ ወንድሞቼ ሆይ፥ ለመብላት በተሰበሰባችሁ ጊዜ እርስ በርሳችሁ ተጠባበቁ። ");
INSERT INTO amh_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","ማንም የራበው ቢኖር ለፍርድ እንዳትሰበሰቡ በቤቱ ይብላ። የቀረውንም ነገር በመጣሁ ጊዜ እደነግጋለሁ። ");
INSERT INTO amh_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","ስለ መንፈሳዊ ነገርም፥ ወንድሞች ሆይ፥ ታውቁ ዘንድ እወዳለሁ። ");
INSERT INTO amh_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","አሕዛብ ሳላችሁ በማናቸውም ጊዜ እንደምትመሩ ድምፅ ወደሌላቸው ወደ ጣዖታት እንደ ተወሰዳችሁ ታውቃላችሁ። ");
INSERT INTO amh_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","ስለዚህ ማንም በእግዚአብሔር መንፈስ ሲናገር። ኢየሱስ የተረገመ ነው የሚል እንደሌለ፥ በመንፈስ ቅዱስም ካልሆነ በቀር። ኢየሱስ ጌታ ነው ሊል አንድ እንኳ እንዳይችል አስታውቃችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","የጸጋም ስጦታ ልዩ ልዩ ነው መንፈስ ግን አንድ ነው፤ ");
INSERT INTO amh_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","አገልግሎትም ልዩ ልዩ ነው ጌታም አንድ ነው፤ ");
INSERT INTO amh_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","አሠራርም ልዩ ልዩ ነው፥ ሁሉን በሁሉ የሚያደርግ እግዚአብሔር ግን አንድ ነው። ");
INSERT INTO amh_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","ነገር ግን መንፈስ ቅዱስን መግለጥ ለእያንዳንዱ ለጥቅም ይሰጠዋል። ");
INSERT INTO amh_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","ለአንዱ ጥበብን መናገር በመንፈስ ይሰጠዋልና፥ ለአንዱም በዚያው መንፈስ እውቀትን መናገር ይሰጠዋል፥ ");
INSERT INTO amh_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","ለአንዱም በዚያው መንፈስ እምነት፥ ለአንዱም በአንዱ መንፈስ የመፈወስ ስጦታ፥ ለአንዱም ተአምራትን ማድረግ፥ ");
INSERT INTO amh_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","ለአንዱም ትንቢትን መናገር፥ ለአንዱም መናፍስትን መለየት፥ ለአንዱም በልዩ ዓይነት ልሳን መናገር፥ ለአንዱም በልሳኖች የተነገረውን መተርጎም ይሰጠዋል፤ ");
INSERT INTO amh_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","ይህን ሁሉ ግን ያ አንዱ መንፈስ እንደሚፈቅድ ለእያንዳንዱ ለብቻው እያካፈለ ያደርጋል። ");
INSERT INTO amh_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","አካልም አንድ እንደ ሆነ ብዙም ብልቶች እንዳሉበት ነገር ግን የአካል ብልቶች ሁሉ ብዙዎች ሳሉ አንድ አካል እንደ ሆኑ፥ ክርስቶስ ደግሞ እንዲሁ ነው፤ ");
INSERT INTO amh_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","አይሁድ ብንሆን የግሪክ ሰዎችም ብንሆን ባሪያዎችም ብንሆን ጨዋዎችም ብንሆን እኛ ሁላችን በአንድ መንፈስ አንድ አካል እንድንሆን ተጠምቀናልና። ሁላችንም አንዱን መንፈስ ጠጥተናል። ");
INSERT INTO amh_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","አካል ብዙ ብልቶች እንጂ አንድ ብልት አይደለምና። ");
INSERT INTO amh_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","እግር። እኔ እጅ አይደለሁምና የአካል ክፍል አይደለሁም ብትል፥ ይህን በማለትዋ የአካል ክፍል መሆንዋ ይቀራልን? ");
INSERT INTO amh_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","ጆሮም። እኔ ዓይን አይደለሁምና የአካል ክፍል አይደለሁም ቢል፥ ይህን በማለቱ የአካል ክፍል መሆኑ ይቀራልን? ");
INSERT INTO amh_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","አካል ሁሉ ዓይን ቢሆን መስማት ወዴት በተገኘ? ሁሉም መስማት ቢሆን ማሽተት ወዴት በተገኘ? ");
INSERT INTO amh_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","አሁን ግን እግዚአብሔር እንደ ወደደ ብልቶችን እያንዳንዳቸው በአካል አድርጎአል። ");
INSERT INTO amh_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","ሁሉም አንድ ብልት ቢሆንስ አካል ወዴት በሆነ? ");
INSERT INTO amh_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","ዳሩ ግን አሁን ብልቶች ብዙዎች ናቸው አካል ግን አንድ ነው። ");
INSERT INTO amh_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","ዓይን እጅን። አታስፈልገኝም ልትለው አትችልም፥ ወይም ራስ ደግሞ እግሮችን። አታስፈልጉኝም ሊላቸው አይችልም። ");
INSERT INTO amh_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","ነገር ግን ደካሞች የሚመስሉ የአካል ብልቶች ይልቁን የሚያስፈልጉ ናቸው፤ ");
INSERT INTO amh_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","ከአካልም ብልቶች ያልከበሩ ሆነው የሚመስሉን በሚበዛ ክብር እናለብሳቸዋለን፥ በምናፍርባቸውም ብልቶቻችን ክብር ይጨመርላቸዋል፤ ");
INSERT INTO amh_vpl VALUES ("C112_24","076_12_24","1CO","12","24","26","አንድም ብልት ቢሣቀይ ብልቶች ሁሉ ከእርሱ ጋር ይሣቀያሉ፤ አንድ ብልትም ቢከበር ብልቶች ሁሉ ከእርሱ ጋር ደስ ይላቸዋል። ");
INSERT INTO amh_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","እናንተም የክርስቶስ አካል ናችሁ እያንዳንዳችሁም ብልቶች ናችሁ። ");
INSERT INTO amh_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","እግዚአብሔርም በቤተ ክርስቲያን አንዳንዶቹን አስቀድሞ ሐዋርያትን፥ ሁለተኛም ነቢያትን፥ ሦስተኛም አስተማሪዎችን፥ ቀጥሎም ተአምራት ማድረግን፥ ቀጥሎም የመፈወስን ስጦታ፥ እርዳታንም፥ አገዛዝንም፥ የልዩ ልዩ ዓይነት ልሳኖችንም አድርጎአል። ");
INSERT INTO amh_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","ሁሉ ሐዋርያት ናቸውን? ሁሉስ ነቢያት ናቸውን? ሁሉስ አስተማሪዎች ናቸውን? ሁሉስ ተአምራትን ይሠራሉን? ");
INSERT INTO amh_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","ሁሉስ የመፈወስ ስጦታ አላቸውን? ሁሉስ በልሳኖች ይናገራሉን? ሁሉስ ይተረጉማሉን? ");
INSERT INTO amh_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","ነገር ግን የሚበልጠውን የጸጋ ስጦታ በብርቱ ፈልጉ። ደግሞም ከሁሉ የሚበልጥ መንገድ አሳያችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","በሰዎችና በመላእክት ልሳን ብናገር ፍቅር ግን ከሌለኝ እንደሚጮኽ ናስ ወይም እንደሚንሽዋሽዋ ጸናጽል ሆኜአለሁ። ");
INSERT INTO amh_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","ትንቢትም ቢኖረኝ ምሥጢርንም ሁሉና እውቀትን ሁሉ ባውቅ፥ ተራሮችንም እስካፈልስ ድረስ እምነት ሁሉ ቢኖረኝ ፍቅር ግን ከሌለኝ ከንቱ ነኝ። ");
INSERT INTO amh_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","ድሆችንም ልመግብ ያለኝን ሁሉ ባካፍል፥ ሥጋዬንም ለእሳት መቃጠል አሳልፌ ብሰጥ ፍቅር ግን ከሌለኝ ምንም አይጠቅመኝም። ");
INSERT INTO amh_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","ፍቅር ይታገሣል፥ ቸርነትንም ያደርጋል፤ ፍቅር አይቀናም፤ ፍቅር አይመካም፥ አይታበይም፤ ");
INSERT INTO amh_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","የማይገባውን አያደርግም፥ የራሱንም አይፈልግም፥ አይበሳጭም፥ በደልን አይቆጥርም፤ ");
INSERT INTO amh_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","ከእውነት ጋር ደስ ይለዋል እንጂ ስለ ዓመፃ ደስ አይለውም፤ ");
INSERT INTO amh_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","ሁሉን ይታገሣል፥ ሁሉን ያምናል፥ ሁሉን ተስፋ ያደርጋል፥ በሁሉ ይጸናል። ");
INSERT INTO amh_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","ፍቅር ለዘወትር አይወድቅም፤ ትንቢት ቢሆን ግን ይሻራል፤ ልሳኖች ቢሆኑ ይቀራሉ፤ እውቀትም ቢሆን ይሻራል። ");
INSERT INTO amh_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","ከእውቀት ከፍለን እናውቃለንና፥ ከትንቢትም ከፍለን እንናገራለንና፤ ");
INSERT INTO amh_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","ፍጹም የሆነ ሲመጣ ግን ተከፍሎ የነበረው ይሻራል። ");
INSERT INTO amh_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","ልጅ ሳለሁ እንደ ልጅ እናገር ነበር፥ እንደ ልጅም አስብ ነበር፥ እንደ ልጅም እቈጥር ነበር፤ ጎልማሳ ሆኜ ግን የልጅነትን ጠባይ ሽሬአለሁ። ");
INSERT INTO amh_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","ዛሬስ በመስተዋት በድንግዝግዝ እንደምናይ ነን በዚያን ጊዜ ግን ፊት ለፊት እናያለን፤ ዛሬስ ከእውቀት ከፍዬ አውቃለሁ በዚያን ጊዜ ግን እኔ ደግሞ እንደ ታወቅሁ አውቃለሁ። ");
INSERT INTO amh_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","እንዲህም ከሆነ፥ እምነት ተስፋ ፍቅር እነዚህ ሦስቱ ጸንተው ይኖራሉ፤ ከእነዚህም የሚበልጠው ፍቅር ነው። ");
INSERT INTO amh_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","ፍቅርን ተከታተሉ፥ መንፈሳዊ ስጦታንም ይልቁንም ትንቢት መናገርን በብርቱ ፈልጉ። ");
INSERT INTO amh_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","በልሳን የሚናገርስ ለእግዚአብሔር እንጂ ለሰው አይናገርም፤ የሚያስተውለው የለምና፥ በመንፈስ ግን ምሥጢርን ይናገራል፤ ");
INSERT INTO amh_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","ትንቢትን የሚናገር ግን ለማነጽና ለመምከር ለማጽናናትም ለሰው ይናገራል። ");
INSERT INTO amh_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","በልሳን የሚናገር ራሱን ያንጻል፤ ትንቢትን የሚናገር ግን ማኅበሩን ያንጻል። ");
INSERT INTO amh_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","ሁላችሁ በልሳኖች ልትናገሩ እወድ ነበር፥ ትንቢትን ልትናገሩ ግን ከዚህ ይልቅ እወዳለሁ፤ ማኅበሩ ይታነጽ ዘንድ ንግግሩን ባይተረጐም በልሳኖች ከሚናገር ትንቢትን የሚናገር ይበልጣል። ");
INSERT INTO amh_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","አሁን ግን፥ ወንድሞች ሆይ፥ ወደ እናንተ መጥቼ በልሳኖች ብናገር፥ በመግለጥ ወይም በእውቀት ወይም በትንቢት ወይም በትምህርት ካልነገርኋችሁ ምን እጠቅማችኋለሁ? ");
INSERT INTO amh_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","ነፍስ የሌለበት ነገር እንኳ ዋሽንትም ክራርም ቢሆን ድምፅ ሲሰጥ የድምፁን ልዩነት ባይገልጥ በዋሽንት የሚነፋው ወይስ በክራር የሚመታው መዝሙር እንዴት ይታወቃል? ");
INSERT INTO amh_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","ደግሞም መለከት የማይገለጥን ድምፅ ቢሰጥ ለጦርነት ማን ይዘጋጃል? ");
INSERT INTO amh_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","እንዲሁ እናንተ ደግሞ የተገለጠውን ቃል በአንደበት ባትናገሩ ሰዎች የምትናገሩትን እንዴት አድርገው ያስተውሉታል? ለነፋስ የምትናገሩ ትሆናላችሁና። ");
INSERT INTO amh_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","በዓለም ምናልባት ቁጥር የሌለው የቋንቋ ዓይነት ይኖራል ቋንቋም የሌለው ሕዝብ የለም፤ ");
INSERT INTO amh_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","እንግዲህ የቋንቋውን ፍች ባላውቅ ለሚናገረው እንግዳ እሆናለሁ፥ የሚናገረውም ለእኔ እንግዳ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","እንዲሁ ደግሞ እናንተ መንፈሳዊ ስጦታን በብርቱ የምትፈልጉ ከሆናችሁ ቤተ ክርስቲያንን ለማነጽ እንዲበዛላችሁ ፈልጉ። ");
INSERT INTO amh_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","ስለዚህ በልሳን የሚናገር እንዲተረጉም ይጸልይ። ");
INSERT INTO amh_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","በልሳን ብጸልይ መንፈሴ ይጸልያል አእምሮዬ ግን ያለ ፍሬ ነው። ");
INSERT INTO amh_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","እንግዲህ ምንድር ነው? በመንፈስ እጸልያለሁ በአእምሮም ደግሞ እጸልያለሁ፤ በመንፈስ እዘምራለሁ በአእምሮም ደግሞ እዘምራለሁ። ");
INSERT INTO amh_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","እንዲያማ ካልሆነ፥ አንተ በመንፈስ ብትባርክ ባልተማሩት ስፍራ የተቀመጠው የምትለውን ካላወቀ እንዴት አድርጎ ለምስጋናህ አሜን ይላል? ");
INSERT INTO amh_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","አንተማ መልካም ታመሰግናለህ፥ ሌላው ግን አይታነጽበትም። ");
INSERT INTO amh_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","ከሁላችሁ ይልቅ በልሳኖች እናገራለሁና እግዚአብሔርን አመሰግናለሁ፤ ");
INSERT INTO amh_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","ነገር ግን ሌሎችን ደግሞ አስተምር ዘንድ በማኅበር እልፍ ቃላት በልሳን ከመናገር ይልቅ አምስት ቃላት በአእምሮዬ ልናገር እወዳለሁ። ");
INSERT INTO amh_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","ወንድሞች ሆይ፥ በአእምሮ ሕፃናት አትሁኑ፤ ለክፋት ነገር ሕፃናት ሁኑ እንጂ በአእምሮ የበሰሉ ሁኑ። ");
INSERT INTO amh_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","ሌሎችን ልሳኖች በሚናገሩ ሰዎችና በሌላ አንደበት ለዚህ ሕዝብ እነግራቸዋለሁ፥ እንዲህም ቢሆን አይሰሙኝም ይላል ጌታ ተብሎ በሕግ ተጽፎአል። ");
INSERT INTO amh_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","እንግዲያስ በልሳኖች መናገር ለማያምኑ ምልክት ነው እንጂ ለሚያምኑ አይደለም፥ ትንቢት ግን ለሚያምኑ እንጂ ለማያምኑ አይደለም። ");
INSERT INTO amh_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","እንግዲህ ማኅበር ሁሉ አብረው ቢሰበሰቡ ሁሉም በልሳኖች ቢናገሩና ያልተማሩ ወይም የማያምኑ ሰዎች ቢገቡ። አብደዋል አይሉምን? ");
INSERT INTO amh_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","ሁሉ ትንቢት ቢናገሩ ግን የማያምን ወይም ያልተማረ ሰው ቢገባ በሁሉ ይወቀሳል፥ በሁሉም ይመረመራል፤ ");
INSERT INTO amh_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","በልቡም የተሰወረ ይገለጣል እንዲሁም። እግዚአብሔር በእውነት በመካከላቸው ነው ብሎ እየተናገረ በፊቱ ወድቆ ለእግዚአብሔር ይሰግዳል። ");
INSERT INTO amh_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","እንግዲህ፥ ወንድሞች ሆይ፥ ምንድር ነው? በምትሰበሰቡበት ጊዜ ለእያንዳንዱ መዝሙር አለው፥ ትምህርት አለው፥ መግለጥ አለው፥ በልሳን መናገር አለው፥ መተርጐም አለው፤ ሁሉ ለማነጽ ይሁን። ");
INSERT INTO amh_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","በልሳን የሚናገር ቢኖር ሁለት ወይም ቢበዛ ሦስት ሆነው በተራቸው ይናገሩ አንዱም ይተርጉም፤ ");
INSERT INTO amh_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","የሚተረጉም ባይኖር ግን በማኅበር መካከል ዝም ይበልና ለራሱና ለእግዚአብሔር ይናገር። ");
INSERT INTO amh_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","ነቢያትም ሁለት ወይም ሦስት ሆነው ይናገሩ ሌሎችም ይለዩአቸው፤ ");
INSERT INTO amh_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","በዚያ ለሚቀመጥ ለሌላ ግን አንድ ነገር ቢገለጥለት ፊተኛው ዝም ይበል። ");
INSERT INTO amh_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","ሁሉም እንዲማሩ ሁሉም እንዲመከሩ ሁላችሁ በእያንዳንዳችሁ ትንቢት ልትናገሩ ትችላላችሁ። ");
INSERT INTO amh_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","የነቢያትም መናፍስት ለነቢያት ይገዛሉ፤ ");
INSERT INTO amh_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","እግዚአብሔርስ የሰላም አምላክ ነው እንጂ የሁከት አምላክ አይደለምና፤ በቅዱሳንም አብያተ ክርስቲያናት ሁሉ እንዲህ ነው። ");
INSERT INTO amh_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","ሴቶች በማኅበር ዝም ይበሉ፤ ሕግ ደግሞ እንደሚል እንዲገዙ እንጂ እንዲናገሩ አልተፈቀደላቸውምና። ");
INSERT INTO amh_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","ለሴት በማኅበር መካከል መናገር ነውር ነውና፥ ምንም ሊማሩ ቢወዱ በቤታቸው ባሎቻቸውን ይጠይቁ። ");
INSERT INTO amh_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","ምን ነው? የእግዚአብሔር ቃል የወጣ ከእናንተ ነውን? ወይስ ወደ እናንተ ብቻ ደርሶአልን? ");
INSERT INTO amh_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","ማንም ነቢይ ወይም መንፈሳዊ የሆነ ቢመስለው ይህች የጻፍሁላችሁ የጌታ ትእዛዝ እንደ ሆነች ይወቅ፤ ");
INSERT INTO amh_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","ማንም የማያውቅ ቢኖር ግን አይወቅ። ");
INSERT INTO amh_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","ስለዚህ፥ ወንድሞች ሆይ፥ ትንቢት ለመናገር በብርቱ ፈልጉ፥ በልሳኖች ከመናገርም አትከልክሉ፤ ");
INSERT INTO amh_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","ነገር ግን ሁሉ በአገባብና በሥርዓት ይሁን። ");
INSERT INTO amh_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","ወንድሞች ሆይ፥ የሰበክሁላችሁን ደግሞም የተቀበላችሁትን በእርሱም ደግሞ የቆማችሁበትን በእርሱም ደግሞ የምትድኑበትን ወንጌል አሳስባችኋለሁ፤ ");
INSERT INTO amh_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","በከንቱ ካላመናችሁ በቀር፥ ብታስቡት፥ በምን ቃል እንደ ሰበክሁላችሁ አሳስባችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","እኔ ደግሞ የተቀበልሁትን ከሁሉ በፊት አሳልፌ ሰጠኋችሁ እንዲህ ብዬ። መጽሐፍ እንደሚል ክርስቶስ ስለ ኃጢአታችን ሞተ፥ ተቀበረም፥ ");
INSERT INTO amh_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","መጽሐፍም እንደሚል በሦስተኛው ቀን ተነሣ፥ ");
INSERT INTO amh_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","ለኬፋም ታየ በኋላም ለአሥራ ሁለቱ፤ ");
INSERT INTO amh_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","ከዚያም በኋላ ከአምስት መቶ ለሚበዙ ወንድሞች በአንድ ጊዜ ታየ፤ ከእነርሱም የሚበዙቱ እስከ አሁን አሉ አንዳንዶች ግን አንቀላፍተዋል፤ ");
INSERT INTO amh_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","ከዚያም በኋላ ለያዕቆብ ኋላም ለሐዋርያት ሁሉ ታየ፤ ");
INSERT INTO amh_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","ከሁሉም በኋላ እንደ ጭንጋፍ ለምሆን ለእኔ ደግሞ ታየኝ። ");
INSERT INTO amh_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","እኔ ከሐዋርያት ሁሉ የማንስ ነኝና፥ የእግዚአብሔርን ቤተ ክርስቲያን ስላሳደድሁ ሐዋርያ ተብዬ ልጠራ የማይገባኝ፤ ");
INSERT INTO amh_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","ነገር ግን በእግዚአብሔር ጸጋ የሆንሁ እኔ ነኝ፤ ለእኔም የተሰጠኝ ጸጋው ከንቱ አልነበረም ከሁላቸው ይልቅ ግን ደከምሁ፥ ዳሩ ግን ከእኔ ጋር ያለው የእግዚአብሔር ጸጋ ነው እንጂ እኔ አይደለሁም። ");
INSERT INTO amh_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","እንግዲህስ እኔ ብሆን እነርሱም ቢሆኑ እንዲሁ እንሰብካለን እንዲሁም አመናችሁ። ");
INSERT INTO amh_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","ክርስቶስ ከሙታን እንደ ተነሣ የሚሰበክ ከሆነ ግን ከእናንተ አንዳንዶቹ። ትንሣኤ ሙታን የለም እንዴት ይላሉ? ");
INSERT INTO amh_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","ትንሣኤ ሙታንስ ከሌለ ክርስቶስ አልተነሣማ፤ ");
INSERT INTO amh_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","ክርስቶስም ካልተነሣ እንግዲያስ ስብከታችን ከንቱ ነው እምነታችሁም ደግሞ ከንቱ ናት፤ ");
INSERT INTO amh_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","ደግሞም። ክርስቶስን አስነሥቶታል ብለን በእግዚአብሔር ላይ ስለ መሰከርን ሐሰተኞች የእግዚአብሔር ምስክሮች ሆነን ተገኝተናል፤ ሙታን ግን የማይነሡ ከሆነ እርሱን አላስነሣውም። ");
INSERT INTO amh_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","ሙታን የማይነሡ ከሆነ ክርስቶስ አልተነሣማ፤ ");
INSERT INTO amh_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","ክርስቶስም ካልተነሣ እምነታችሁ ከንቱ ናት፤ እስከ አሁን ድረስ በኃጢአታችሁ አላችሁ። ");
INSERT INTO amh_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","እንግዲያስ በክርስቶስ ያንቀላፉት ደግሞ ጠፍተዋላ። ");
INSERT INTO amh_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","በዚች ሕይወት ብቻ ክርስቶስን ተስፋ ያደረግን ከሆነ፥ ከሰው ሁሉ ይልቅ ምስኪኖች ነን። ");
INSERT INTO amh_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","አሁን ግን ክርስቶስ ላንቀላፉት በኩራት ሆኖ ከሙታን ተነሥቶአል። ");
INSERT INTO amh_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","ሞት በሰው በኩል ስለ መጣ ትንሣኤ ሙታን በሰው በኩል ሆኖአልና። ");
INSERT INTO amh_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","ሁሉ በአዳም እንደሚሞቱ እንዲሁ ሁሉ በክርስቶስ ደግሞ ሕያዋን ይሆናሉና። ");
INSERT INTO amh_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","ነገር ግን እያንዳንዱ በራሱ ተራ ይሆናል፤ ክርስቶስ እንደ በኩራት ነው፥ በኋላም በመምጣቱ ለክርስቶስ የሆኑት ናቸው፤ ");
INSERT INTO amh_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","በኋላም፥ መንግሥቱን ለእግዚአብሔር ለአባቱ አሳልፎ በሰጠ ጊዜ አለቅነትንም ሁሉና ሥልጣንን ሁሉ ኃይልንም በሻረ ጊዜ፥ ፍጻሜ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","ጠላቶቹን ሁሉ ከእግሩ በታች እስኪያደርግ ድረስ ሊነግሥ ይገባዋልና። ");
INSERT INTO amh_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","የኋለኛው ጠላት የሚሻረው ሞት ነው፤ ");
INSERT INTO amh_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","ሁሉን ከእግሩ በታች አስገዝቶአልና። ነገር ግን። ሁሉ ተገዝቶአል ሲል፥ ሁሉን ካስገዛለት በቀር መሆኑ ግልጥ ነው። ");
INSERT INTO amh_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","ሁሉ ከተገዛለት በኋላ ግን እግዚአብሔር ሁሉ በሁሉ ይሆን ዘንድ በዚያን ጊዜ ልጁ ራሱ ደግሞ ሁሉን ላስገዛለት ይገዛል። ");
INSERT INTO amh_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","እንዲያማ ካልሆነ፥ ስለ ሙታን የሚጠመቁ ምን ያደርጋሉ? ሙታንስ ከቶ የማይነሡ ከሆነ፥ ስለ እነርሱ የሚጠመቁ ስለ ምንድር ነው? ");
INSERT INTO amh_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","እኛስ ዘወትር በሚያስፈራ ኑሮ የምንኖር ስለ ምንድር ነው? ");
INSERT INTO amh_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","በጌታችን በክርስቶስ ኢየሱስ ባለኝ በእናንተ ትምክህት እየማልሁ፥ ወንድሞች ሆይ፥ ዕለት ዕለት እሞታለሁ። ");
INSERT INTO amh_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","እንደ ሰው በኤፌሶን ከአውሬ ጋር ከታገልሁ፥ ሙታንስ የማይነሡ ከሆነ፥ ምን ይጠቅመኛል? ነገ እንሞታለንና እንብላና እንጠጣ። ");
INSERT INTO amh_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","አትሳቱ፤ ክፉ ባልንጀርነት መልካሙን አመል ያጠፋል። ");
INSERT INTO amh_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","በጽድቅ ንቁ ኃጢአትንም አትሥሩ፤ እግዚአብሔርን የማያውቁ አሉና፤ አሳፍራችሁ ዘንድ ይህን እላለሁ። ");
INSERT INTO amh_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","ነገር ግን ሰው። ሙታን እንዴት ይነሣሉ? በምንስ ዓይነት አካል ይመጣሉ? የሚል ይኖር ይሆናል። ");
INSERT INTO amh_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","አንተ ሞኝ፥ አንተ የምትዘራው ካልሞተ ሕያው አይሆንም፤ ");
INSERT INTO amh_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","የምትዘራውም፥ ስንዴ ቢሆን ከሌላም ዓይነት የአንዱ ቢሆን፥ ቅንጣት ብቻ ነው እንጂ የምትዘራው የሚሆነውን አካል አይደለም፤ ");
INSERT INTO amh_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","እግዚአብሔር ግን እንደ ወደደ አካልን ይሰጠዋል ከዘሮችም ለእያንዳንዱ የገዛ አካሉን ይሰጠዋል። ");
INSERT INTO amh_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","ሥጋ ሁሉ አንድ አይደለም፥ የሰው ሥጋ ግን አንድ ነው፥ የእንስሳም ሥጋ ሌላ ነው፥ የወፎችም ሥጋ ሌላ ነው፥ የዓሣም ሥጋ ሌላ ነው። ");
INSERT INTO amh_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","ደግሞ ሰማያዊ አካል አለ፥ ምድራዊም አካል አለ፤ ነገር ግን የሰማያዊ አካል ክብር ልዩ ነው፥ የምድራዊም አካል ክብር ልዩ ነው። ");
INSERT INTO amh_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","የፀሐይ ክብር አንድ ነው የጨረቃም ክብር ሌላ ነው የከዋክብትም ክብር ሌላ ነው፤ በክብር አንዱ ኮከብ ከሌላው ኮከብ ይለያልና። ");
INSERT INTO amh_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","የሙታን ትንሣኤ ደግሞ እንዲሁ ነው። በመበስበስ ይዘራል፥ ባለመበስበስ ይነሣል፤ ");
INSERT INTO amh_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","በውርደት ይዘራል፥ በክብር ይነሣል፤ በድካም ይዘራል፥ በኃይል ይነሣል፤ ");
INSERT INTO amh_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","ፍጥረታዊ አካል ይዘራል፥ መንፈሳዊ አካል ይነሣል። ፍጥረታዊ አካል ካለ መንፈሳዊ አካል ደግሞ አለ። ");
INSERT INTO amh_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","እንዲሁ ደግሞ። ፊተኛው ሰው አዳም ሕያው ነፍስ ሆነ ተብሎ ተጽፎአል፤ ኋለኛው አዳም ሕይወትን የሚሰጥ መንፈስ ሆነ። ");
INSERT INTO amh_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","ነገር ግን አስቀድሞ ፍጥረታዊው ቀጥሎም መንፈሳዊው ነው እንጂ መንፈሳዊው መጀመሪያ አይደለም። ");
INSERT INTO amh_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","የፊተኛው ሰው ከመሬት መሬታዊ ነው፤ ሁለተኛው ሰው ከሰማይ ነው። ");
INSERT INTO amh_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","መሬታዊው እንደ ሆነ መሬታውያን የሆኑት ደግሞ እንዲሁ ናቸው፥ ሰማያዊው እንደ ሆነ ሰማያውያን የሆኑት ደግሞ እንዲሁ ናቸው። ");
INSERT INTO amh_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","የዚያንም የመሬታዊውን መልክ እንደ ለበስን የሰማያዊውን መልክ ደግሞ እንለብሳለን። ");
INSERT INTO amh_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","ነገር ግን፥ ወንድሞች ሆይ፥ ይህን እላለሁ። ሥጋና ደም የእግዚአብሔርን መንግሥት ሊወርሱ አይችሉም፥ የሚበሰብሰውም የማይበሰብሰውን አይወርስም። ");
INSERT INTO amh_vpl VALUES ("C115_51","076_15_51","1CO","15","51","53","ይህ የሚበሰብሰው የማይበሰብሰውን ሊለብስ ይህም የሚሞተው የማይሞተውን ሊለብስ ይገባዋልና። ");
INSERT INTO amh_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","ዳሩ ግን ይህ የሚበሰብሰው የማይበሰብሰውን ሲለብስ ይህም የሚሞተው የማይሞተውን ሲለብስ፥ በዚያን ጊዜ። ሞት ድል በመነሣት ተዋጠ ተብሎ የተጻፈው ቃል ይፈጸማል። ");
INSERT INTO amh_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","ሞት ሆይ፥ መውጊያህ የት አለ? ሲኦል ሆይ፥ ድል መንሣትህ የት አለ? ");
INSERT INTO amh_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","የሞት መውጊያ ኃጢአት ነው የኃጢአትም ኃይል ሕግ ነው፤ ");
INSERT INTO amh_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","ነገር ግን በጌታችን በኢየሱስ ክርስቶስ በኩል ድል መንሣትን ለሚሰጠን ለእግዚአብሔር ምስጋና ይሁን። ");
INSERT INTO amh_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","ስለዚህ፥ የተወደዳችሁ ወንድሞቼ ሆይ፥ ድካማችሁ በጌታ ከንቱ እንዳይሆን አውቃችኋልና የምትደላደሉ፥ የማትነቃነቁም፥ የጌታም ሥራ ሁልጊዜ የሚበዛላችሁ ሁኑ። ");
INSERT INTO amh_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","ለቅዱሳንም ገንዘብን ስለ ማዋጣት፥ ለገላትያ አብያተ ክርስቲያናት እንደ ደነገግሁት እናንተ ደግሞ እንዲሁ አድርጉ። ");
INSERT INTO amh_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","እኔ ስመጣ ይህ የገንዘብ ማዋጣት ያን ጊዜ እንዳይሆን፥ ከእናንተ እያንዳንዱ በየሳምንቱ በፊተኛው ቀን እንደ ቀናው መጠን እያስቀረ በቤቱ ያስቀምጥ። ");
INSERT INTO amh_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","ስመጣም ማናቸውም ቢሆኑ የታመኑ የሚመስሉአችሁ ሰዎች ቸርነታችሁን ወደ ኢየሩሳሌም ያደርሱ ዘንድ ደብዳቤ ሰጥቼ እልካቸዋለሁ፤ ");
INSERT INTO amh_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","እኔ ደግሞ ልሄድ የሚገባኝ ብሆን ከእኔ ጋር አብረው ይሄዳሉ። ");
INSERT INTO amh_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","በመቄዶንያም ሳልፍ ወደ እናንተ እመጣለሁ፤ በመቄዶንያ አድርጌ አልፋለሁና፤ ");
INSERT INTO amh_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","እናንተም ወደምሄድበት ወደ ማናቸውም ስፍራ በጉዞዬ እንድትረዱኝ ምናልባት በእናንተ ዘንድ እቆይ ወይም እከርም ይሆናል። ");
INSERT INTO amh_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","አሁን እግረ መንገዴን ሳልፍ ልጎበኛችሁ አልወድምና፤ ጌታ ቢፈቅደው የሆነውን ዘመን በእናንተ ዘንድ ልሰነብት ተስፋ አደርጋለሁና። ");
INSERT INTO amh_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","በኤፌሶን ግን እስከ በዓለ ኀምሳ ድረስ እሰነብታለሁ። ");
INSERT INTO amh_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","ሥራ የሞላበት ትልቅ በር ተከፍቶልኛልና ተቃዋሚዎችም ብዙ ናቸው። ");
INSERT INTO amh_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","ጢሞቴዎስም የመጣ እንደ ሆነ በእናንተ ዘንድ ያለ ፍርሃት እንዲኖር ተጠንቀቁ፤ እንደ እኔ ደግሞ የጌታን ሥራ ይሠራልና፤ እንግዲህ ማንም አይናቀው። ");
INSERT INTO amh_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","ነገር ግን ከወንድሞቹ ጋር እጠብቀዋለሁና ወደ እኔ ይመጣ ዘንድ በሰላም በጉዞው እርዱት። ");
INSERT INTO amh_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","ስለ ወንድማችን ስለ አጵሎስ ግን ከወንድሞቹ ጋር ወደ እናንተ ሊሄድ እጅግ አድርጌ ለምኜው ነበር፤ ዛሬም ለመምጣት ከቶ ፈቃድ አልነበረውም፥ ሲመቸው ግን ይመጣል። ");
INSERT INTO amh_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","ንቁ፥ በሃይማኖት ቁሙ፥ ጎልምሱ ጠንክሩ። ");
INSERT INTO amh_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","በእናንተ ዘንድ ሁሉ በፍቅር ይሁን። ");
INSERT INTO amh_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","ወንድሞች ሆይ፥ የእስጢፋኖስ ቤተ ሰዎች የአካይያ በኩራት እንደ ሆኑ ቅዱሳንንም ለማገልገል ራሳቸውን እንደ ሰጡ ታውቃላችሁ፤ ");
INSERT INTO amh_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","እንደ እነርሱ ላሉትና አብሮ ለሚሠራ ለሚደክምም ሁሉ እናንተም እንድትገዙ እለምናችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","በእስጢፋኖስና በፈርዶናጥስ በአካይቆስም መምጣት ደስ ይለኛል፥ እናንተ ስለሌላችሁ የጎደለኝን ፈጽመዋልና፤ መንፈሴንና መንፈሳችሁን አሳርፈዋልና። ");
INSERT INTO amh_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","እንግዲህ እንደነዚህ ያሉትን እወቁአቸው። ");
INSERT INTO amh_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","የእስያ አብያተ ክርስቲያናት ሰላምታ ያቀርቡላችኋል። አቂላና ጵርስቅላ በቤታቸው ካለች ቤተ ክርስቲያን ጋር በጌታ እጅግ ሰላምታ ያቀርቡላችኋል። ");
INSERT INTO amh_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","ወንድሞች ሁሉ ሰላምታ ያቀርቡላችኋል። በተቀደሰ አሳሳም እርስ በርሳችሁ ሰላምታ ተሰጣጡ። ");
INSERT INTO amh_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","እኔ ጳውሎስ ይህን ሰላምታ በገዛ እጄ ጽፌአለሁ። ");
INSERT INTO amh_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","ጌታን ኢየሱስ ክርስቶስን የማይወድ ቢኖር የተረገመ ይሁን። ጌታችን ሆይ፥ ና። ");
INSERT INTO amh_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","የጌታ የኢየሱስ ክርስቶስ ጸጋ ከእናንተ ጋር ይሁን። ");
INSERT INTO amh_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","ፍቅሬ በክርስቶስ ኢየሱስ ከሁላችሁ ጋር ነው። አሜን። ");
INSERT INTO amh_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","በእግዚአብሔር ፈቃድ የኢየሱስ ክርስቶስ ሐዋርያ የሆነ ጳውሎስ ወንድሙም ጢሞቴዎስ፥ በአካይያ አገር ሁሉ ከሚኖሩ ቅዱሳን ሁሉ ጋር በቆሮንቶስ ላለች ለእግዚአብሔር ቤተ ክርስቲያን፤ ");
INSERT INTO amh_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","ከእግዚአብሔር ከአባታችን ከጌታም ከኢየሱስ ክርስቶስ ጸጋና ሰላም ለእናንተ ይሁን። ");
INSERT INTO amh_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","የርኅራኄ አባት የመጽናናትም ሁሉ አምላክ የሆነ የጌታችን የኢየሱስ ክርስቶስ አምላክና አባት ይባረክ። ");
INSERT INTO amh_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","እርሱ በመከራችን ሁሉ ያጽናናናል፥ ስለዚህም እኛ ራሳችን በእግዚአብሔር በምንጽናናበት መጽናናት በመከራ ሁሉ ያሉትን ማጽናናት እንችላለን። ");
INSERT INTO amh_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","የክርስቶስ ሥቃይ በእኛ ላይ እንደ በዛ፥ እንዲሁ መጽናናታችን ደግሞ በክርስቶስ በኩል ይበዛልናልና። ");
INSERT INTO amh_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","ዳሩ ግን መከራ ብንቀበል፥ ስለ መጽናናታችሁና ስለ መዳናችሁ ነው፤ ብንጽናናም፥ እኛ ደግሞ የምንሣቀይበት በዚያ ሥቃይ በመጽናት ስለሚደረግ ስለ መጽናናታችሁ ነው። ");
INSERT INTO amh_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","ተስፋችንም ስለ እናንተ ጽኑ ነው፤ ሥቃያችንን እንደ ተካፈላችሁ እንዲሁም መጽናናታችንን ደግሞ እንድትካፈሉ እናውቃለንና። ");
INSERT INTO amh_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","በእስያ ስለ ደረሰብን መከራችን፥ ወንድሞች ሆይ፥ ታውቁ ዘንድ እንወዳለንና፤ ስለ ሕይወታችን እንኳ ተስፋ እስክንቆርጥ ድረስ ከዓቅማችን በላይ ያለ ልክ ከብዶብን ነበር፤ ");
INSERT INTO amh_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","አዎን፥ ሙታንን በሚያነሣ በእግዚአብሔር እንጂ በራሳችን እንዳንታመን፥ እኛ ራሳችን የሞትን ፍርድ በውስጣችን ሰምተን ነበር። ");
INSERT INTO amh_vpl VALUES ("C21_10","077_1_10","2CO","1","10","12","ትምክህታችን ይህ ነውና፤ በእግዚአብሔር ጸጋ እንጂ በሥጋዊ ጥበብ ሳይሆን፥ በእግዚአብሔር ቅድስናና ቅንነት በዚህ ዓለም ይልቁንም በእናንተ ዘንድ እንደኖርን የሕሊናችን ምስክርነት ነው። ");
INSERT INTO amh_vpl VALUES ("C21_13","077_1_13","2CO","1","13","15","በዚህም ታምኜ፥ ሁለተኛ ጸጋ ታገኙ ዘንድ አስቀድሜ ወደ እናንተ እንድመጣ፥ ");
INSERT INTO amh_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","በእናንተም መካከል ወደ መቄዶንያ እንዳልፍ ደግሞም ከመቄዶንያ ወደ እናንተ መጥቼ ወደ ይሁዳ በጉዞዬ እንድትረዱኝ አሰብሁ። ");
INSERT INTO amh_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","እንግዲህ ይህን ሳስብ ያን ጊዜ ቅሌትን አሳየሁን? ወይስ በእኔ ዘንድ አዎን አዎን አይደለም አይደለም ማለት እንዲሆን ያን የማስበው በዓለማዊ ልማድ ነውን? ");
INSERT INTO amh_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","እግዚአብሔር ግን የታመነ ነው፥ ለእናንተም የሚነገረው ቃላችን አዎንና አይደለም አይሆንም። ");
INSERT INTO amh_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","በእኛ ማለት በእኔና በስልዋኖስ በጢሞቴዎስም በመካከላችሁ የተሰበከ የእግዚአብሔር ልጅ ኢየሱስ ክርስቶስ አዎንና አይደለም አልነበረም፥ ነገር ግን በእርሱ አዎን ሆኖአል። ");
INSERT INTO amh_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","እግዚአብሔር ለሰጠው የተስፋ ቃል ሁሉ አዎን ማለት በእርሱ ነውና፥ ስለዚህ ለእግዚአብሔር ስለ ክብሩ በእኛ የሚነገረው አሜን በእርሱ ደግሞ ነው። ");
INSERT INTO amh_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","በክርስቶስም ከእናንተ ጋር የሚያጸናንና የቀባን እግዚአብሔር ነው፥ ");
INSERT INTO amh_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","ደግሞም ያተመን የመንፈሱንም መያዣ በልባችን የሰጠን እርሱ ነው። ");
INSERT INTO amh_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","እኔ ግን ልራራላችሁ ስል እንደ ገና ወደ ቆሮንቶስ እንዳልመጣሁ በነፍሴ ላይ እግዚአብሔርን ምስክር እጠራለሁ። ");
INSERT INTO amh_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","ለደስታችሁ ከእናንተ ጋር የምንሠራ ነን እንጂ፥ በእምነታችሁ በእናንተ ላይ የምንገዛ አይደለንም። በእምነታችሁ ቆማችኋልና። ");
INSERT INTO amh_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","ነገር ግን ዳግመኛ በኀዘን ወደ እናንተ እንዳልመጣ ስለ እኔ ቆረጥሁ። ");
INSERT INTO amh_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","እኔስ ባሳዝናችሁ፥ እንግዲያስ በእኔ ምክንያት ከሚያዝን በቀር ደስ የሚያሰኘኝ ማን ነው? ");
INSERT INTO amh_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","ደስ ሊያሰኙኝ ከሚገባቸውም በመምጣቴ ኀዘን እንዳይሆንብኝ ይህንኑ ጻፍሁላችሁ፥ ደስታዬ የሁላችሁ ደስታ ነው ብዬ በሁላችሁ ታምኜአለሁና። ");
INSERT INTO amh_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","በብዙ መከራና ከልብ ጭንቀት በብዙም እንባ ጽፌላችሁ ነበርና፤ ይህም እናንተን አብዝቼ የምወድበትን ፍቅር እንድታውቁ እንጂ እንዳሳዝናችሁ አይደለም። ");
INSERT INTO amh_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","ነገር ግን ማንም አሳዝኖ ቢሆን፥ እንዳልከብድባችሁ፥ በክፍል ሁላችሁን እንጂ እኔን ያሳዘነ አይደለም። ");
INSERT INTO amh_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","እንደዚህ ላለ ሰው ይህ ከእናንተ የምትበዙት የቀጣችሁት ቅጣት ይበቃዋልና እንደዚህ ያለው ከልክ በሚበዛ ኀዘን እንዳይዋጥ፥ ");
INSERT INTO amh_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","ይልቅ ተመልሳችሁ ይቅር ማለትና ማጽናናት ይገባችኋል። ");
INSERT INTO amh_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","ስለዚህ ከእርሱ ጋር ፍቅርን እንድታጸኑ እለምናችኋለሁ፤ ");
INSERT INTO amh_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","ስለዚህ ደግሞ ጽፌ ነበርና፤ በሁሉ የምትታዘዙ እንደ ሆናችሁ የእናንተን መፈተን አውቅ ዘንድ አሳቤ ነበር። ");
INSERT INTO amh_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","እናንተ ግን ይቅር የምትሉትን እኔ ደግሞ ይቅር እለዋለሁ፤ እኔም ይቅር ካልሁ፥ ይቅር ያልሁትን ስለ እናንተ በክርስቶስ ፊት ይቅር ብዬአለሁ፥ ");
INSERT INTO amh_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","በሰይጣን እንዳንታለል፤ የእርሱን አሳብ አንስተውምና። ");
INSERT INTO amh_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","ስለ ክርስቶስም ወንጌል ወደ ጢሮአዳ በመጣሁ ጊዜ፥ ለጌታ ሥራ በር ምንም ቢከፈትልኝ፥ ቲቶን ወንድሜን ስላላገኘሁት መንፈሴ ዕረፍት አልነበረውም፥ ");
INSERT INTO amh_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","ነገር ግን ከእነርሱ ተሰናብቼ ወደ መቄዶንያ ወጣሁ። ");
INSERT INTO amh_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","ነገር ግን በክርስቶስ ሁልጊዜ ድል በመንሣቱ ለሚያዞረን በእኛም በየስፍራው ሁሉ የእውቀቱን ሽታ ለሚገልጥ ለአምላክ ምስጋና ይሁን፤ ");
INSERT INTO amh_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","በሚድኑቱና በሚጠፉቱ ዘንድ ለእግዚአብሔር የክርስቶስ መዓዛ ነንና፤ ");
INSERT INTO amh_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","ለእነዚህ ለሞት የሚሆን የሞት ሽታ ለእነዚያም ለሕይወት የሚሆን የሕይወት ሽታ ነን። ለዚህም ነገር የሚበቃ ማን ነው? ");
INSERT INTO amh_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","የእግዚአብሔርን ቃል ቀላቅለው እንደሚሸቃቅጡት እንደ ብዙዎቹ አይደለንምና፤ በቅንነት ግን ከእግዚአብሔር እንደ ተላክን በእግዚአብሔር ፊት በክርስቶስ ሆነን እንናገራለን። ");
INSERT INTO amh_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","እንደ ገና ራሳችንን ልናመሰግን እንጀምራለንን? ወይስ እንደ ሌሎች የማመስገኛ መልእክት ወደ እናንተ ወይስ ከእናንተ ያስፈልገን ይሆንን? ");
INSERT INTO amh_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","ሰዎች ሁሉ የሚያውቁትና የሚያነቡት በልባችን የተጻፈ መልእክታችን እናንተ ናችሁ። ");
INSERT INTO amh_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","እናንተም በሕያው እግዚአብሔር መንፈስ እንጂ በቀለም አይደለም፥ ሥጋ በሆነ በልብ ጽላት እንጂ በድንጋይ ጽላት ያልተጻፈ፥ በእኛም የተገለገለ የክርስቶስ መልእክት እንደ ሆናችሁ የተገለጠ ነው። ");
INSERT INTO amh_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","በክርስቶስም በኩል ወደ እግዚአብሔር እንዲህ ያለ እምነት አለን። ");
INSERT INTO amh_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","ብቃታችን ከእግዚአብሔር ነው እንጂ፥ በገዛ እጃችን እንደሚሆን አንዳችን እንኳ ልናስብ ራሳችን የበቃን አይደለንም፤ ");
INSERT INTO amh_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","እርሱም ደግሞ በመንፈስ እንጂ በፊደል ለማይሆን ለአዲስ ኪዳን አገልጋዮች እንሆን ዘንድ አበቃን፤ ፊደል ይገድላልና መንፈስ ግን ሕይወትን ይሰጣል። ");
INSERT INTO amh_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","ዳሩ ግን የእስራኤል ልጆች ስለዚያ ስለ ተሻረው ስለ ፊቱ ክብር የሙሴን ፊት ትኩር ብለው መመልከት እስኪሳናቸው ድረስ፥ ያ በፊደላት በድንጋዮች ላይ የተቀረጸ የሞት አገልግሎት በክብር ከሆነ፥ ");
INSERT INTO amh_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","የመንፈስ አገልግሎት እንዴት ይልቅ በክብር አይሆንም? ");
INSERT INTO amh_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","የኵነኔ አገልግሎት ክብር ከሆነ፥ ይልቅ የጽድቅ አገልግሎት በክብር አብዝቶ ይበልጣልና። ");
INSERT INTO amh_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","ያ የከበረ እንኳ እጅግ በሚበልጠው ክብር ምክንያት በዚህ ነገር ክብሩን አጥቶአልና። ");
INSERT INTO amh_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","ያ ይሻር የነበረው በክብር ከሆነ፥ ጸንቶ የሚኖረውማ እጅግ ይልቅ በክብር ሆኖአልና። ");
INSERT INTO amh_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","እንግዲህ እንዲህ ያለ ተስፋ ካለን እጅግ ገልጠን እንናገራለን፥ ");
INSERT INTO amh_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","የዚያንም ይሻር የነበረውን መጨረሻ ትኵር ብለው የእስራኤል ልጆች እንዳይመለከቱ፥ በፊቱ መጋረጃ እንዳደረገ እንደ ሙሴ አይደለንም። ");
INSERT INTO amh_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","ነገር ግን አሳባቸው ደነዘዘ። ብሉይ ኪዳን ሲነበብ ያ መጋረጃ ሳይወሰድ እስከ ዛሬ ድረስ ይኖራልና፤ በክርስቶስ ብቻ የተሻረ ነውና። ");
INSERT INTO amh_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","ነገር ግን እስከ ዛሬ ድረስ የሙሴ መጻሕፍት በተነበቡ ጊዜ ሁሉ ያ መጋረጃ በልባቸው ይኖራል፤ ");
INSERT INTO amh_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","ወደ ጌታ ግን ዘወር ባለ ጊዜ ሁሉ መጋረጃው ይወሰዳል። ");
INSERT INTO amh_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","ጌታ ግን መንፈስ ነው፤ የጌታም መንፈስ ባለበት በዚያ አርነት አለ። ");
INSERT INTO amh_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","እኛም ሁላችን በመጋረጃ በማይከደን ፊት የጌታን ክብር እንደ መስተዋት እያብለጨለጭን መንፈስ ከሚሆን ጌታ እንደሚደረግ ያን መልክ እንመስል ዘንድ ከክብር ወደ ክብር እንለወጣለን። ");
INSERT INTO amh_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","ስለዚህ ምክንያት ምሕረት እንደ ተሰጠን መጠን ይህ አገልግሎት ስላለን አንታክትም። ");
INSERT INTO amh_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","ነገር ግን የሚያሳፍረውን ስውር ነገር ጥለናልና በተንኮል አንመላለስም የእግዚአብሔርንም ቃል በውሸት አንቀላቅልም፤ እውነትን በመግለጥ ግን በእግዚአብሔር ፊት ለሰው ሕሊና ሁሉ ራሳችንን እናመሰግናለን። ");
INSERT INTO amh_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","ወንጌላችን የተከደነ ቢሆን እንኳ የተከደነባቸው ለሚጠፉ ነው። ");
INSERT INTO amh_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","ለእነርሱም የእግዚአብሔር ምሳሌ የሆነ የክርስቶስ የክብሩ ወንጌል ብርሃን እንዳያበራላቸው፥ የዚህ ዓለም አምላክ የማያምኑትን አሳብ አሳወረ። ");
INSERT INTO amh_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","ክርስቶስ ኢየሱስን ጌታ እንደ ሆነ እንጂ ራሳችንን አንሰብክምና፥ ስለ ኢየሱስም ራሳችንን ለእናንተ ባሪያዎች እናደርጋለን። ");
INSERT INTO amh_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","በክርስቶስ ፊት የእግዚአብሔርን የክብሩን እውቀት ብርሃን እንዲሰጥ በልባችን ውስጥ የበራ። በጨለማ ብርሃን ይብራ ያለ እግዚአብሔር ነውና። ");
INSERT INTO amh_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","ነገር ግን የኃይሉ ታላቅነት ከእግዚአብሔር እንጂ ከእኛ እንዳይሆን ይህ መዝገብ በሸክላ ዕቃ ውስጥ አለን፤ ");
INSERT INTO amh_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","በሁሉ እንገፋለን እንጂ አንጨነቅም፤ እናመነታለን እንጂ ተስፋ አንቆርጥም፤ ");
INSERT INTO amh_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","እንሰደዳለን እንጂ አንጣልም፤ እንወድቃለን እንጂ አንጠፋም፤ ");
INSERT INTO amh_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","የኢየሱስ ሕይወት ደግሞ በሥጋችን ይገለጥ ዘንድ ሁልጊዜ የኢየሱስን መሞት በሥጋችን ተሸክመን እንዞራለን። ");
INSERT INTO amh_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","የኢየሱስ ሕይወት ደግሞ በሚሞት ሥጋችን ይገለጥ ዘንድ እኛ ሕያዋን የሆንን ከኢየሱስ የተነሣ ዘወትር ለሞት አልፈን እንሰጣለንና። ");
INSERT INTO amh_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","ስለዚህ ሞቱ በእኛ ሕይወቱም በእናንተ ይሠራል። ");
INSERT INTO amh_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","ነገር ግን። አመንሁ ስለዚህም ተናገርሁ ተብሎ እንደ ተጻፈ ያው አንዱ የእምነት መንፈስ ስላለን፥ እኛ ደግሞ እናምናለን ስለዚህም እንናገራለን፤ ");
INSERT INTO amh_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","ጌታን ኢየሱስን ያስነሣው እኛን ደግሞ ከኢየሱስ ጋር እንዲያስነሣን ከእናንተም ጋር እንዲያቀርበን እናውቃለንና። ");
INSERT INTO amh_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","በብዙዎች በኩል የተትረፈረፈው ጸጋ ለእግዚአብሔር ክብር ምስጋናን ያበዛ ዘንድ፥ ሁሉ ስለ እናንተ ነውና። ");
INSERT INTO amh_vpl VALUES ("C24_16","077_4_16","2CO","4","16","18","ስለዚህም አንታክትም፥ ነገር ግን የውጭው ሰውነታችን ቢጠፋ እንኳ የውስጡ ሰውነታችን ዕለት ዕለት ይታደሳል። ");
INSERT INTO amh_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","ድንኳን የሚሆነው ምድራዊ መኖሪያችን ቢፈርስ፥ በሰማይ ያለ በእጅ ያልተሠራ የዘላለም ቤት የሚሆን ከእግዚአብሔር የተሠራ ሕንጻ እንዳለን እናውቃለንና። ");
INSERT INTO amh_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","በዚህ ውስጥ በእውነት እንቃትታለንና፥ ");
INSERT INTO amh_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","ከሰማይም የሚሆነውን መኖሪያችንን እንድንለብስ እንናፍቃለንና ለብሰን ራቁታችንን አንገኝም። ");
INSERT INTO amh_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","በእውነትም የሚሞተው በሕይወት ይዋጥ ዘንድ ልንለብስ እንጂ ልንገፈፍ የማንወድ ስለ ሆነ፥ በድንኳኑ ያለን እኛ ከብዶን እንቃትታለን። ");
INSERT INTO amh_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","ነገር ግን ለዚሁ የሠራን እግዚአብሔር ነው እርሱም የመንፈሱን መያዣ ሰጠን። ");
INSERT INTO amh_vpl VALUES ("C25_6","077_5_6","2CO","5","6","8","ታምነናል ይልቁንም ከሥጋ ተለይተን በስደት መኖር በጌታም ዘንድ ማደር ደስ ይለናል። ");
INSERT INTO amh_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","ስለዚህ ደግሞ ብናድር ወይም ተለይተን ብንሆን እርሱን ደስ የምናሰኝ ልንሆን እንቀናለን። ");
INSERT INTO amh_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","መልካም ቢሆን ወይም ክፉ እንዳደረገ፥ እያንዳንዱ በሥጋው የተሠራውን በብድራት ይቀበል ዘንድ ሁላችን በክርስቶስ በፍርድ ወንበር ፊት ልንገለጥ ይገባናልና። ");
INSERT INTO amh_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","እንግዲህ የጌታን ፍርሃት አውቀን ሰዎችን እናስረዳለን ለእግዚአብሔር ግን የተገለጥን ነን፤ በሕሊናችሁም ደግሞ የተገለጥን እንደ ሆንን ተስፋ አደርጋለሁ። ");
INSERT INTO amh_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","በመልክ እንጂ በልብ ለማይመኩ የምትመልሱላቸው መልስ እንዲኖራችሁ፥ በእኛ ልትመኩ ምክንያት እንሰጣችኋለን እንጂ ራሳችንን ደግሞ ለእናንተ የምናመሰግን አይደለንም። ");
INSERT INTO amh_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","እብዶች ብንሆን፥ ለእግዚአብሔር ነው፤ ባለ አእምሮዎች ብንሆን፥ ለእናንተ ነው። ");
INSERT INTO amh_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","ይህን ስለቆረጥን የክርስቶስ ፍቅር ግድ ይለናልና፤ አንዱ ስለ ሁሉ ሞተ፤ እንግዲያስ ሁሉ ሞቱ፤ ");
INSERT INTO amh_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","በሕይወትም ያሉት ስለ እነርሱ ለሞተውና ለተነሣው እንጂ ወደ ፊት ለራሳቸው እንዳይኖሩ ስለ ሁሉ ሞተ። ");
INSERT INTO amh_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","ስለዚህ እኛ ከአሁን ጀምሮ ማንንም በሥጋ እንደሚሆን አናውቅም፤ ክርስቶስንም በሥጋ እንደ ሆነ ያወቅነው ብንሆን እንኳ፥ አሁን ግን ከእንግዲህ ወዲህ እንደዚህ አናውቀውም። ");
INSERT INTO amh_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","ስለዚህ ማንም በክርስቶስ ቢሆን አዲስ ፍጥረት ነው፤ አሮጌው ነገር አልፎአል፤ እነሆ፥ ሁሉም አዲስ ሆኖአል። ");
INSERT INTO amh_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","ነገር ግን የሆነው ሁሉ፥ በክርስቶስ ከራሱ ጋር ካስታረቀን የማስታረቅም አገልግሎት ከሰጠን፥ ከእግዚአብሔር ነው፤ ");
INSERT INTO amh_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","እግዚአብሔር በክርስቶስ ሆኖ ዓለሙን ከራሱ ጋር ያስታርቅ ነበርና፥ በደላቸውን አይቆጥርባቸውም ነበር፤ በእኛም የማስታረቅ ቃል አኖረ። ");
INSERT INTO amh_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","እንግዲህ እግዚአብሔር በእኛ እንደሚማልድ ስለ ክርስቶስ መልክተኞች ነን፤ ከእግዚአብሔር ጋር ታረቁ ብለን ስለ ክርስቶስ እንለምናለን። ");
INSERT INTO amh_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","እኛ በእርሱ ሆነን የእግዚአብሔር ጽድቅ እንሆን ዘንድ ኃጢአት ያላወቀውን እርሱን ስለ እኛ ኃጢአት አደረገው። ");
INSERT INTO amh_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","አብረንም እየሠራን የእግዚአብሔርን ጸጋ በከንቱ እንዳትቀበሉ ደግሞ እንለምናለን፤ ");
INSERT INTO amh_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","በተወደደ ሰዓት ሰማሁህ በመዳንም ቀን ረዳሁህ ይላልና፤ እነሆ፥ የተወደደው ሰዓት አሁን ነው፤ እነሆ፥ የመዳን ቀን አሁን ነው። ");
INSERT INTO amh_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","አገልግሎታችንም እንዳይነቀፍ በአንዳች ነገር ማሰናከያ ከቶ አንሰጥም። ");
INSERT INTO amh_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","ነገር ግን በሁሉ እንደ እግዚአብሔር አገልጋዮች ራሳችንን እናማጥናለን፤ ");
INSERT INTO amh_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","በብዙ መጽናት፥ በመከራ፥ በችግር፥ በጭንቀት፥ በመገረፍ፥ በወኅኒ፥ በሁከት፥ በድካም፥ እንቅልፍ በማጣት፥ ");
INSERT INTO amh_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","በመጦም፥ በንጽህና፥ በእውቀት፥ በትዕግሥት፥ በቸርነት፥ በመንፈስ ቅዱስ፥ ግብዝነት በሌለው ፍቅር፥ በእውነት ቃል፥ ");
INSERT INTO amh_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","በእግዚአብሔር ኃይል፥ ለቀኝና ለግራ በሚሆን በጽድቅ የጦር ዕቃ፥ በክብርና በውርደት፥ ");
INSERT INTO amh_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","በክፉ ወሬና በመልካም ወሬ ራሳችንን እናማጥናለን፤ አሳቾች ስንባል እውነተኞች ነን፤ ");
INSERT INTO amh_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","ያልታወቁ ስንባል የታወቅን ነን፤ የምንሞት ስንመስል እነሆ ሕያዋን ነን፤ የተቀጣን ስንሆን አንገደልም፤ ");
INSERT INTO amh_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","ኀዘንተኞች ስንሆን ዘወትር ደስ ይለናል፤ ድሆች ስንሆን ብዙዎችን ባለ ጠጎች እናደርጋለን፤ አንዳች የሌለን ስንሆን ሁሉ የእኛ ነው። ");
INSERT INTO amh_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","እናንተ የቆሮንቶስ ሰዎች ሆይ፥ አፋችን ለእናንተ ተከፍቶአል ልባችንም ሰፍቶላችኋል፤ ");
INSERT INTO amh_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","በእኛ አልጠበባችሁም በሆዳችሁ ግን ጠቦባችኋል፤ ");
INSERT INTO amh_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","ልጆቼ እንደ መሆናችሁ ግን እላችኋለሁ፥ እናንተ ደግሞ ብድራት መልሳችሁልን ተስፋፉ። ");
INSERT INTO amh_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","ከማያምኑ ጋር በማይመች አካሄድ አትጠመዱ፤ ጽድቅ ከዓመፅ ጋር ምን ተካፋይነት አለውና? ብርሃንም ከጨለማ ጋር ምን ኅብረት አለው? ");
INSERT INTO amh_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","ክርስቶስስ ከቤልሆር ጋር ምን መስማማት አለው? ወይስ የሚያምን ከማያምን ጋር ምን ክፍል አለው? ");
INSERT INTO amh_vpl VALUES ("C26_16","077_6_16","2CO","6","16","18","ለእግዚአብሔር ቤተ መቅደስም ከጣዖት ጋር ምን መጋጠም አለው? እኛ የሕያው እግዚአብሔር ቤተ መቅደስ ነንና እንዲሁም እግዚአብሔር ተናገረ እንዲህ ሲል። በእነርሱ እኖራለሁ በመካከላቸውም እመላለሳለሁ፥ አምላካቸውም እሆናለሁ እነርሱም ሕዝቤ ይሆናሉ። ");
INSERT INTO amh_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","እንግዲህ፥ ወዳጆች ሆይ፥ የዚህ ተስፋ ቃል ካለን፥ በእግዚአብሔር ፍርሃት ቅድስናን ፍጹም እያደረግን ሥጋንና መንፈስን ከሚያረክስ ሁሉ ራሳችንን እናንጻ። ");
INSERT INTO amh_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","በልባችሁ ስፍራ አስፉልን፤ ማንንም አልበደልንም፥ ማንንም አላጠፋንም፥ ማንንም አላታለልንም። ");
INSERT INTO amh_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","ለኵነኔ አልልም፤ በአንድነት ለመሞትና በአንድነት ለመኖር በልባችን እንዳላችሁ አስቀድሜ ብዬአለሁና። ");
INSERT INTO amh_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","ስለ እናንተ እምነቴ ታላቅ ነው፥ በእናንተ ምክንያት ትምክህቴ ታላቅ ነው፤ መጽናናት ሞልቶብኛል፤ በመከራችን ሁሉ ደስታዬ ከመጠን ይልቅ ይበዛል። ");
INSERT INTO amh_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","ወደ መቄዶንያም በመጣን ጊዜ፥ በሁሉ ነገር መከራን ተቀበልን እንጂ ሥጋችን ዕረፍት አልነበረውም፤ በውጭ ጠብ ነበረ፥ በውስጥ ፍርሃት ነበረ። ");
INSERT INTO amh_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","ነገር ግን ኀዘንተኞችን የሚያጽናና አምላክ በቲቶ መምጣት አጽናናን፤ ");
INSERT INTO amh_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","በመምጣቱም ብቻ አይደለም ነገር ግን ናፍቆታችሁንና ልቅሶአችሁን ስለ እኔም ቅንዓታችሁን ሲናገረን በእናንተ ላይ በተጽናናበት መጽናናት ደግሞ ነው፤ ስለዚህም ከፊት ይልቅ ደስ አለን። ");
INSERT INTO amh_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","በመልእክቴ ያሳዘንኋችሁ ብሆን እንኳ አልጸጸትም፤ የተጸጸትሁ ብሆን እንኳ፥ ያ መልእክት ጥቂት ጊዜ ብቻ እንዳሳዘናችሁ አያለሁና አሁን ለንስሐ ስላዘናችሁ ደስ ብሎኛል እንጂ ስላዘናችሁ አይደለም፤ ");
INSERT INTO amh_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","በምንም ከእኛ የተነሣ እንዳትጎዱ እንደ እግዚአብሔር ፈቃድ አዝናችኋልና። ");
INSERT INTO amh_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","እንደ እግዚአብሔር ፈቃድ የሆነ ኀዘን ጸጸት የሌለበትን፥ ወደ መዳንም የሚያደርሰውን ንስሐ ያደርጋልና፤ የዓለም ኀዘን ግን ሞትን ያመጣል። ");
INSERT INTO amh_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","እነሆ፥ ይህ እንደ እግዚአብሔር ፈቃድ የሆነ ኀዘን እንዴት ያለ ትጋት፥ እንዴት ያለ መልስ፥ እንዴት ያለ ቁጣ፥ እንዴት ያለ ፍርሃት፥ እንዴት ያለ ናፍቆት፥ እንዴት ያለ ቅንዓት፥ እንዴት ያለ በቀል በመካከላችሁ አደረገ። በዚህ ነገር ንጹሐን እንደ ሆናችሁ በሁሉ አስረድታችኋል። ");
INSERT INTO amh_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","እንግዲያስ የጻፍሁላችሁ ብሆን እንኳ፥ ስለ እኛ ያላችሁ ትጋታችሁ ከእናንተ ዘንድ በእግዚአብሔር ፊት እንዲገለጥ እንጂ፥ ስለ በዳዩ ወይም ስለ ተበዳዩ አልጻፍሁም። ስለዚህ ተጽናንተናል። ");
INSERT INTO amh_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","በመጽናናታችንም ስለ ቲቶ ደስታ አብልጦ ደስ አለን፥ መንፈሱ በሁላችሁ ዐርፎአልና፤ ");
INSERT INTO amh_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","ለእርሱ በምንም ስለ እናንተ የተመካሁ እንደ ሆነ አላፈርሁምና፥ ነገር ግን ሁሉን ለእናንተ በእውነት እንደ ተናገርን፥ እንደዚህ ደግሞ ትምክህታችን በቲቶ ፊት እውነት ሆነ። ");
INSERT INTO amh_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","ስለዚህም በፍርሃትና በመንቀጥቀጥ እንዴት እንደተቀበላችሁት፥ የሁላችሁን መታዘዝ እያሰበ ፍቅሩ በእናንተ ላይ እጅግ በዝቶአል። ");
INSERT INTO amh_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","በነገር ሁሉ ተማምኜባችኋለሁና ደስ ይለኛል። ");
INSERT INTO amh_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","ወንድሞች ሆይ፥ ለመቄዶንያ አብያተ ክርስቲያናት የተሰጠውን የእግዚአብሔርን ጸጋ እናስታውቃችኋለን፤ ");
INSERT INTO amh_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","በብዙ መከራ ተፈትነው ሳሉ የደስታቸው ብዛትና የድህነታቸው ጥልቅነት የልግስናቸውን ባለ ጠግነት አብዝቶአል፤ ");
INSERT INTO amh_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","እንደ ዓቅማቸው መጠን ከዓቅማቸውም የሚያልፍ እንኳ ወደው እንደ ሰጡ እመሰክርላቸዋለሁና። ");
INSERT INTO amh_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","ለቅዱሳን በሆነው አገልግሎት እንዲተባበሩ ይህን ቸርነት በብዙ ልመና ከእኛ ይለምኑ ነበር፥ ");
INSERT INTO amh_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","አስቀድመውም በእግዚአብሔር ፈቃድ ራሳቸውን ለጌታ ለእኛም ሰጡ እንጂ እንዳሰብን አይደለም። ");
INSERT INTO amh_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","ስለዚህም ቲቶ አስቀድሞ እንደ ጀመረ እንዲሁ ደግሞ ይህን ቸር ሥራ ደግሞ በእናንተ ዘንድ ሊፈጽም ለመንን። ");
INSERT INTO amh_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","ነገር ግን በነገር ሁሉ፥ በእምነትና በቃል በእውቀትም በትጋትም ሁሉ ለእኛም በፍቅራችሁ እንደ ተረፋችሁ፥ በዚህ ቸር ሥራ ደግሞ ትረፉ። ");
INSERT INTO amh_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","ትእዛዝ እንደምሰጥ አልልም፥ ነገር ግን በሌሎች ትጋት በኩል የፍቅራችሁን እውነተኛነት ደግሞ ልመረምር እላለሁ፤ ");
INSERT INTO amh_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","የጌታችንን የኢየሱስ ክርስቶስን ቸር ስጦታ አውቃችኋልና፤ ሀብታም ሲሆን፥ እናንተ በእርሱ ድህነት ባለ ጠጎች ትሆኑ ዘንድ ስለ እናንተ ድሀ ሆነ። ");
INSERT INTO amh_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","በዚህም ነገር ምክር እሰጣለሁ፤ ከአምና ጀምራችሁ ለማድረግ ብቻ ያይደለ ነገር ግን ለማሰብ ደግሞ አስቀድማችሁ የጀመራችሁት ይህ ይጠቅማችኋልና፤ ");
INSERT INTO amh_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","አሁንም ለማሰብ በጎ ፈቃድ እንደ ነበረ፥ እንዲሁ እንዳላችሁ መጠን መፈጸም ደግሞ ይሆን ዘንድ፥ ማድረጉን ደግሞ ፈጽሙ። ");
INSERT INTO amh_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","በጎ ፈቃድ ቢኖር፥ እንዳለው መጠን የተወደደ ይሆናል እንጂ እንደሌለው መጠን አይደለም። ");
INSERT INTO amh_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","ለሌሎች ዕረፍት ለእናንተም መከራ እንዲሆን አይደለም፥ ትክክል እንዲሆን ነው እንጂ፤ ");
INSERT INTO amh_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","የእነርሱ ትርፍ ደግሞ የእናንተን ጉድለት እንዲሞላ በአሁኑ ጊዜ የእናንተ ትርፍ የእነርሱን ጉድለት ይሙላ፤ በትክክል እንዲሆን፥ እንዲህ ተብሎ እንደ ተጻፈ። ");
INSERT INTO amh_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","ብዙ ያከማቸ አላተረፈም፥ ጥቂትም ያከማቸ አላጎደለም። ");
INSERT INTO amh_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","ነገር ግን በቲቶ ልብ ስለ እናንተ ያንን ትጋት የሰጠ አምላክ ይመስገን፤ ");
INSERT INTO amh_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","ምክራችንን ተቀብሎአልና፥ ትጋት ግን ስለ በዛበት ወዶ ወደ እናንተ ይወጣል። ");
INSERT INTO amh_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","ከእርሱም ጋር ስለ ወንጌል ስብከት በአብያተ ክርስቲያናት ሁሉ የተመሰገነውን ወንድም እንልካለን፤ ");
INSERT INTO amh_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","ይህም ብቻ አይደለም ነገር ግን የጌታን የራሱን ክብርና የእኛን በጎ ፈቃድ ለማሳየት በምናገለግለው በዚህ ቸር ሥራ ከእኛ ጋር እንዲጓደድ በአብያተ ክርስቲያናት ደግሞ ተመረጠ። ");
INSERT INTO amh_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","ስለምናገለግለው ስለዚህ ለጋስ ስጦታ ማንም እንዳይነቅፈን እንጠነቀቃለን፤ ");
INSERT INTO amh_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","በጌታ ፊት ብቻ ያይደለ ነገር ግን በሰው ፊት ደግሞ መልካም የሆነውን እናስባለንና። ");
INSERT INTO amh_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","ብዙ ጊዜም በብዙ ነገር መርምረን ትጉ እንደ ሆነ ያገኘነውን፥ አሁንም በእናንተ እጅግ ስለሚታመን ከፊት ይልቅ እጅግ ትጉ የሚሆነውን ወንድማችንን ከእነርሱ ጋር እንልካለን። ");
INSERT INTO amh_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","ስለ ቲቶ የሚጠይቅ ቢኖር ስለ እናንተ አብሮኝ የሚሠራ ባልንጀራዬ ነው፤ ስለ ወንድሞቻችን የሚጠይቅ ቢኖርም የአብያተ ክርስቲያናት መልእክተኞችና የክርስቶስ ክብር ናቸው። ");
INSERT INTO amh_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","እንግዲህ የፍቅራችሁንና ስለ እናንተ ያለውን የትምክህታችንን መግለጫ በአብያተ ክርስቲያናት ፊት ለእነርሱ ግለጡ። ");
INSERT INTO amh_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","ለቅዱሳን ስለሚሆነው አገልግሎት ልጽፍላችሁ አያስፈልግምና፤ ");
INSERT INTO amh_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","በጎ ፈቃዳችሁን አውቄአለሁና፤ ስለዚህም። አካይያ ከአምና ጀምሮ ተዘጋጅቶአል ብዬ ለመቄዶንያ ሰዎች በእናንተ እመካለሁ፥ ቅንዓታችሁም የሚበዙቱን አነሣሥቶአል። ");
INSERT INTO amh_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","ነገር ግን ለእነርሱ እንዳልሁ፥ የተዘጋጃችሁ ትሆኑ ዘንድ በዚህም ነገር ስለ እናንተ ያለው ትምክህታችን ከንቱ እንዳይሆን ወንድሞችን እልካለሁ፤ ");
INSERT INTO amh_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","ምናልባት የመቄዶንያ ሰዎች ከእኔ ጋር ቢመጡ፥ ያልተዘጋጃችሁም ሆናችሁ ቢያገኙአችሁ፥ እናንተ እንድታፍሩ አላልንም እኛ ግን በዚህ እምነታችን እንድናፍር አይሁን። ");
INSERT INTO amh_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","እንግዲህ እንደ በረከት ሆኖ ከስስት የማይሆን ይህ የተዘጋጀ ይሆን ዘንድ አስቀድመው ወደ እናንተ መጥተው፥ አስቀድማችሁ ተስፋ የሰጣችሁትን በረከት አስቀድመው እንዲፈጽሙ ወንድሞችን እለምን ዘንድ እንዲያስፈልገኝ አሰብሁ። ");
INSERT INTO amh_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","ይህንም እላለሁ። በጥቂት የሚዘራ በጥቂት ደግሞ ያጭዳል፥ በበረከትም የሚዘራ በበረከት ደግሞ ያጭዳል። ");
INSERT INTO amh_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","እግዚአብሔር በደስታ የሚሰጠውን ይወዳልና እያንዳንዱ በልቡ እንዳሰበ ይስጥ፥ በኀዘን ወይም በግድ አይደለም። ");
INSERT INTO amh_vpl VALUES ("C29_8","077_9_8","2CO","9","8","10","ለዘሪ ዘርን ለመብላትም እንጀራን በብዙ የሚሰጥ እርሱም የምትዘሩትን ዘር ይሰጣችኋል ያበረክትላችሁማል፥ የጽድቃችሁንም ፍሬ ያሳድጋል፤ ");
INSERT INTO amh_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","በእኛ በኩል ለእግዚአብሔር የምስጋና ምክንያት የሚሆነውን ልግስና ሁሉ እንድታሳዩ በሁሉ ነገር ባለ ጠጎች ትሆናላችሁ። ");
INSERT INTO amh_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","የዚህ ረድኤት አገልግሎት ለቅዱሳን የሚጎድላቸውን በሙሉ የሚሰጥ ብቻ አይደለምና፥ ነገር ግን ደግሞ በብዙ ምስጋና ለእግዚአብሔር ይበዛል፤ ");
INSERT INTO amh_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","በዚህ አገልግሎት ስለ ተፈተናችሁ፥ በክርስቶስ ወንጌል በማመናችሁ ስለሚሆን መታዘዝ እነርሱንና ሁሉንም ስለምትረዱበት ልግስና እግዚአብሔርን ያከብራሉ፥ ");
INSERT INTO amh_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","ራሳቸውም ስለ እናንተ ሲያማልዱ፥ በእናንተ ላይ ከሚሆነው ከሚበልጠው ከእግዚአብሔር ጸጋ የተነሣ ይናፍቁአችኋል። ");
INSERT INTO amh_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","ስለማይነገር ስጦታው እግዚአብሔር ይመስገን። ");
INSERT INTO amh_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","እኔም ራሴ ጳውሎስ፥ በእናንተ ዘንድ ፊት ለፊት ሳለሁ ትሑት የሆንሁ፥ ከእናንተ ግን ብርቅ የምደፍራችሁ፥ በክርስቶስ የዋህነትና ገርነት እመክራችኋለሁ፤ ");
INSERT INTO amh_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","በዓለማዊ ልማድ እንደምንመላለስ በሚቆጥሩን በአንዳንዶች ላይ አምኜ ልደፍር አስባለሁ፥ በዚያ እምነት ግን ከእናንተ ጋር ሆኜ እንዳልደፍር እለምንችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","በሰው ልማድ ምንም እንኳ የምንመላለስ ብንሆን፥ እንደ ሰው ልማድ አንዋጋም፤ ");
INSERT INTO amh_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","የጦር ዕቃችን ሥጋዊ አይደለምና፥ ምሽግን ለመስበር ግን በእግዚአብሔር ፊት ብርቱ ነው፤ ");
INSERT INTO amh_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","የሰውንም አሳብ በእግዚአብሔርም እውቀት ላይ የሚነሣውን ከፍ ያለውን ነገር ሁሉ እናፈርሳለን ለክርስቶስም ለመታዘዝ አእምሮን ሁሉ እንማርካለን፥ ");
INSERT INTO amh_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","መታዘዛችሁም በተፈጸመች ጊዜ አለመታዘዝን ሁሉ ልንበቀል ተዘጋጅተናል። ");
INSERT INTO amh_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","በፊታችሁ ያለውን ተመልከቱ። ማንም የክርስቶስ መሆኑን ተረድቶ ቢሆን፥ ይህን እንደ ገና በራሱ ይቁጠረው፤ እርሱ የክርስቶስ እንደ ሆነ እኛ ደግሞ እንዲሁ ነን። ");
INSERT INTO amh_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","ጌታ እናንተን ለማነጽ እንጂ እናንተን ለማፍረስ ያይደለ በሰጠው በሥልጣናችን ከፊት ይልቅ ብመካ እንኳ አላፍርም። ");
INSERT INTO amh_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","በመልእክቶቼ የማስደነግጣችሁ አይምሰላችሁ። ");
INSERT INTO amh_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","መልእክቶቹስ ከባድና ኃይለኛ ናቸው፥ ሰውነቱ ግን ሲታይ ደካማ ነው፥ ንግግሩም የተናቀ ነው ይላሉና። ");
INSERT INTO amh_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","እንዲሁ የሚል ይህን ይቁጠረው፤ በሩቅ ሳለን በመልእክታችን በኩል በቃል እንዳለን፥ በፊቱ ደግሞ ሳለን በሥራ እንዲሁ ነን። ");
INSERT INTO amh_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","ራሳቸውን ከሚያመሰግኑ ከአንዳንዶች ጋር ራሳችንን ልንቆጥር ወይም ራሳችንን ልናስተያይ አንደፍርምና፤ ነገር ግን እነርሱ ራሳቸውን ከራሳቸው ጋር ሲያመዛዝኑ፥ ራሳቸውንም ከራሳቸው ጋር ሲያስተያዩ፥ አያስተውሉም። ");
INSERT INTO amh_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","እኛ ግን እግዚአብሔር እንደ ወሰነልን እስከ እናንተ እንኳ እንደሚደርስ እንደ ክፍላችን ልክ እንጂ ያለ ልክ አንመካም። ");
INSERT INTO amh_vpl VALUES ("C210_14","077_10_14","2CO","10","14","18","ወደ እናንተ እንደማንደርስ አድርገን ከመጠን አናልፍምና፥ የክርስቶስን ወንጌል በመስበክ እስከ እናንተ እንኳ ደርሰናልና፤ ");
INSERT INTO amh_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","በጥቂቱ ሞኝነቴ ብትታገሡኝ መልካም ይሆን ነበር፤ ቢሆንም በእርግጥ ታገሡኝ። ");
INSERT INTO amh_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","በእግዚአብሔር ቅንዓት እቀናላችኋለሁና፥ እንደ ንጽሕት ድንግል እናንተን ለክርስቶስ ላቀርብ ለአንድ ወንድ አጭቻችኋለሁና፤ ");
INSERT INTO amh_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","ነገር ግን እባብ በተንኮሉ ሔዋንን እንዳሳታት፥ አሳባችሁ ተበላሽቶ ለክርስቶስ ከሚሆን ቅንነትና ንጽሕና ምናልባት እንዳይለወጥ ብዬ እፈራለሁ። ");
INSERT INTO amh_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","የሚመጣውም ያልሰበክነውን ሌላ ኢየሱስ ቢሰብክ፥ ወይም ያላገኛችሁትን ልዩ መንፈስ ወይም ያልተቀበላችሁትን ልዩ ወንጌል ብታገኙ፥ በመልካም ትታገሡታላችሁ። ");
INSERT INTO amh_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","ከእነዚህ ከዋነኞቹ ሐዋርያት በአንድ ነገር እንኳ እንደ ጎደልሁ ራሴን አልቆጥርም። ");
INSERT INTO amh_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","በአነጋገሬ ያልተማርሁ ብሆን እንኳ፥ በእውቀት ግን እንዲህ አይደለሁም። ነገር ግን በሰው ሁሉ መካከል በነገር ሁሉ ተገልጠንላችኋል። ");
INSERT INTO amh_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","ወይስ የእግዚአብሔርን ወንጌል ያለ ደመወዝ ስለ ሰበክሁላችሁ፥ እናንተ ከፍ እንድትሉ ራሴን እያዋረድሁ ኃጢአት አድርጌ ይሆንን? ");
INSERT INTO amh_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","እናንተን ለማገልገል ደመወዝ እየተቀበልሁ ሌሎችን አብያተ ክርስቲያናት ዘረፍሁ። ");
INSERT INTO amh_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","ከእናንተም ጋር ሳለሁ በጎደለኝ ጊዜ፥ በማንም አልከበድሁበትም፤ ከመቄዶንያ የመጡት ወንድሞች የጎደለኝን በሙሉ ሰጥተዋልና፤ በነገርም ሁሉ እንዳልከብድባችሁ ተጠነቀቅሁ እጠነቀቅማለሁ። ");
INSERT INTO amh_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","የክርስቶስ እውነት በእኔ እንዳለ፥ ይህ ትምክህት በእኔ ዘንድ በአካይያ አገር አይከለከልም። ");
INSERT INTO amh_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","ስለ ምን? ስለማልወዳችሁ ነውን? እግዚአብሔር ያውቃል። ");
INSERT INTO amh_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","ነገር ግን በዚያ በሚመኩበት እንደ እኛ ሆነው ሊገኙ፥ ምክንያትን ከሚፈልጉቱ ምክንያትን እቆርጥ ዘንድ አሁን የማደርገውን ከዚህ ወዲህ ደግሞ አደርጋለሁ። ");
INSERT INTO amh_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","እንደ እነዚህ ያሉ ሰዎች የክርስቶስን ሐዋርያት እንዲመስሉ ራሳቸውን እየለወጡ፥ ውሸተኞች ሐዋርያትና ተንኮለኞች ሠራተኞች ናቸውና። ");
INSERT INTO amh_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","ይህም ድንቅ አይደለም፤ ሰይጣን ራሱ የብርሃንን መልአክ እንዲመስል ራሱን ይለውጣልና። ");
INSERT INTO amh_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","እንግዲህ አገልጋዮቹ ደግሞ የጽድቅን አገልጋዮች እንዲመስሉ ራሳቸውን ቢለውጡ ታላቅ ነገር አይደለም፤ ፍጻሜአቸውም እንደ ሥራቸው ይሆናል። ");
INSERT INTO amh_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","እንደ ገና እላለሁ። ለማንም ሰው ሞኝ የሆንሁ አይምሰለው፤ ያለዚያ ግን እኔ ደግሞ ጥቂት እመካ ዘንድ እንደ ሞኝ እንኳ ሆኜ ተቀበሉኝ። ");
INSERT INTO amh_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","እንደዚህ ታምኜ ስመካ የምናገረው፥ በሞኝነት እንጂ ጌታ እንዳዘዘኝ አልናገርም። ");
INSERT INTO amh_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","ብዙዎች በዓለማዊ ነገር ስለሚመኩ እኔ ደግሞ እመካለሁ። ");
INSERT INTO amh_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","ልባሞች ስለምትሆኑ በደስታ ሞኞችን ትታገሣላችሁና፤ ");
INSERT INTO amh_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","ማንም ባሪያዎች ቢያደርጋችሁ፥ ማንም ቢበላችሁ፥ ማንም ቢቀማችሁ፥ ማንም ቢኮራባችሁ፥ ማንም ፊታችሁን በጥፊ ቢመታችሁ ትታገሣላችሁና። ");
INSERT INTO amh_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","ደካሞች መስለን እንደ ነበርን በውርደት እላለሁ። ነገር ግን በሞኝነት እላለሁ፤ ማንም በሚደፍርበት እኔ ደግሞ እደፍርበታለሁ። ");
INSERT INTO amh_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","ዕብራውያን ናቸውን? እኔ ደግሞ ነኝ። የእስራኤል ወገን ናቸውን? እኔ ደግሞ ነኝ። የአብርሃም ዘር ናቸውን? እኔ ደግሞ ነኝ። የክርስቶስ አገልጋዮች ናቸውን? ");
INSERT INTO amh_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","እንደ እብድ ሰው እላለሁ፤ እኔ እበልጣለሁ፤ በድካም አብዝቼ፥ በመገረፍ አብዝቼ፥ በመታሰር አትርፌ፥ በመሞት ብዙ ጊዜ ሆንሁ። ");
INSERT INTO amh_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","አይሁድ አንድ ሲጎድል አርባ ግርፋት አምስት ጊዜ ገረፉኝ። ");
INSERT INTO amh_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","ሦስት ጊዜ በበትር ተመታሁ፤ አንድ ጊዜ በድንጋይ ተወገርሁ፤ መርከቤ ሦስት ጊዜ ተሰበረ፤ ሌሊትና ቀን በባሕር ውስጥ ኖርሁ። ");
INSERT INTO amh_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","ብዙ ጊዜ በመንገድ ሄድሁ፤ በወንዝ ፍርሃት፥ በወንበዴዎች ፍርሃት፥ በወገኔ በኩል ፍርሃት፥ በአሕዛብ በኩል ፍርሃት፥ በከተማ ፍርሃት፥ በምድረ በዳ ፍርሃት፥ በባሕር ፍርሃት፥ በውሸተኞች ወንድሞች በኩል ፍርሃት ነበረብኝ፤ ");
INSERT INTO amh_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","በድካምና በጥረት ብዙ ጊዜም እንቅልፍ በማጣት፥ በራብና በጥም ብዙ ጊዜም በመጦም፥ በብርድና በራቁትነት ነበርሁ። ");
INSERT INTO amh_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","የቀረውንም ነገር ሳልቆጥር፥ ዕለት ዕለት የሚከብድብኝ የአብያተ ክርስቲያናት ሁሉ አሳብ ነው። ");
INSERT INTO amh_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","የሚደክም ማን ነው፥ እኔም አልደክምምን? የሚሰናከል ማን ነው፥ እኔም አልናደድምን? ");
INSERT INTO amh_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","ትምክህት የሚያስፈልግ ከሆነ፥ ከድካሜ በሚሆነው ነገር እመካለሁ። ");
INSERT INTO amh_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","ለዘላለም የተባረከ የጌታችን የኢየሱስ ክርስቶስ አምላክና አባት እንዳልዋሽ ያውቃል። ");
INSERT INTO amh_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","በደማስቆ አርስጦስዮስ ከተባለ ንጉሥ በታች የሆነ የሕዝብ ገዥ ሊይዘኝ እየወደደ የደማስቆ ሰዎችን ከተማ ያስጠብቅ ነበር፥ ");
INSERT INTO amh_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","በቅጥሩም ባለ መስኮት በቅርጫት አወረዱኝና ከእጁ አመለጥሁ። ");
INSERT INTO amh_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","ትምክህት የሚያስፈልግ ነው፤ አይጠቅምም ነገር ግን ከጌታ ወዳለው ራእይና መገለጥ እመጣለሁ። ");
INSERT INTO amh_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","ሰውን በክርስቶስ አውቃለሁ፥ በሥጋ እንደ ሆነ አላውቅም ወይም ከሥጋ ውጭ እንደ ሆነ አላውቅም፥ እግዚአብሔር ያውቃል፤ እንዲህ ያለው ሰው ከአሥራ አራት ዓመት በፊት እስከ ሦስተኛው ሰማይ ድረስ ተነጠቀ። ");
INSERT INTO amh_vpl VALUES ("C212_3","077_12_3","2CO","12","3","3","እንዲህ ያለውንም ሰው አውቃለሁ፥ በሥጋ እንደ ሆነ ወይም ያለ ሥጋ እንደ ሆነ አላውቅም፥ እግዚአብሔር ያውቃል፤ ");
INSERT INTO amh_vpl VALUES ("C212_4","077_12_4","2CO","12","4","4","ወደ ገነት ተነጠቀ፥ ሰውም ሊናገር የማይገባውን የማይነገረውን ቃል ሰማ። ");
INSERT INTO amh_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","እንደዚህ ስላለው እመካለሁ፥ ስለ ራሴ ግን ከድካሜ በቀር አልመካም። ");
INSERT INTO amh_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","ልመካ ብወድስ ሞኝ አልሆንም፥ እውነትን እላለሁና፤ ነገር ግን ማንም ከሚያይ ከእኔም ከሚሰማ የምበልጥ አድርጎ እንዳይቆጥረኝ ትቼአለሁ። ");
INSERT INTO amh_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","ስለዚህም በመገለጥ ታላቅነት እንዳልታበይ የሥጋዬ መውጊያ፥ እርሱም የሚጎስመኝ የሰይጣን መልእክተኛ ተሰጠኝ፤ ይኸውም እንዳልታበይ ነው። ");
INSERT INTO amh_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","ስለዚህ ነገር ከእኔ እንዲለይ ሦስት ጊዜ ጌታን ለመንሁ። ");
INSERT INTO amh_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","እርሱም። ጸጋዬ ይበቃሃል፥ ኃይሌ በድካም ይፈጸማልና አለኝ። እንግዲህ የክርስቶስ ኃይል ያድርብኝ ዘንድ በብዙ ደስታ በድካሜ ልመካ እወዳለሁ። ");
INSERT INTO amh_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","ስለዚህ ስለ ክርስቶስ በድካም በመንገላታትም በችግርም በስደትም በጭንቀትም ደስ ይለኛል፤ ስደክም ያን ጊዜ ኃይለኛ ነኝና። ");
INSERT INTO amh_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","በመመካቴ ሞኝ ሆኜአለሁ፤ እናንተ ግድ አላችሁኝ፤ እናንተ እኔን ልታመሰግኑ ይገባ ነበርና። እኔ ምንም ባልሆን እንኳ፥ ከዋነኞቹ ሐዋርያት በምንም አልጎድልምና። ");
INSERT INTO amh_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","በእርግጥ የሐዋርያነት ምልክት በመካከላችሁ በምልክትና በድንቅ ነገር በተአምራትም በሁሉ ትዕግሥት ተደረገ። ");
INSERT INTO amh_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","እኔ ራሴ ካልከበድሁባችሁ ከዚህ በቀር፥ ከሌላ ቤተ ክርስቲያን ያነሳችሁበት በምን እኮ ነው? ይህን በደሌን ይቅር በሉልኝ። ");
INSERT INTO amh_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","እነሆ፥ ወደ እናንተ እመጣ ዘንድ ስዘጋጅ ይህ ሦስተኛዬ ነው፤ አልከብድባችሁምም፥ እናንተን እንጂ ያላችሁን አልፈልግምና። ወላጆች ለልጆች እንጂ ልጆች ለወላጆች ገንዘብ ሊያከማቹ አይገባቸውምና። ");
INSERT INTO amh_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","እኔ ግን ስለ ነፍሳችሁ በብዙ ደስታ ገንዘቤን እከፍላለሁ፥ ራሴን እንኳ እከፍላለሁ። ከመጠን ይልቅ ብወዳችሁ በዚህ ልክ ፍቅራችሁ የሚያንስ ነውን? ");
INSERT INTO amh_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","ይሁን እንጂ እኔ አልከበድሁባችሁም፤ ነገር ግን ሸንጋይ ሆኜ በተንኰል ያዝኋችሁ። ");
INSERT INTO amh_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","ወደ እናንተ ከላክኋቸው በአንዱ ስንኳ አታለልኋችሁን? ");
INSERT INTO amh_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","ቲቶን መከርሁት ከእርሱም ጋር ወንድሙን ላክሁት፤ ቲቶስ አታለላችሁን? በአንድ መንፈስ አልተመላለስንምን? በአንድ ፍለጋስ አልተመላለስንም? ");
INSERT INTO amh_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","ለእናንተ ስለ ራሳችን እንድንመልስ ሁልጊዜ ይመስላችኋልን? በእግዚአብሔር ፊት በክርስቶስ ሆነን እንናገራለን፤ ነገር ግን፥ ወዳጆች፥ እናንተን ልናንጻችሁ ሁሉን እንናገራለን። ");
INSERT INTO amh_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","ስመጣ፥ እንደምወደው ሳትሆኑ አገኛችሁ ይሆናል እኔም እንደምትወዱት ሳልሆን ታገኙኝ ይሆናል ብዬ እፈራለሁና፤ ምናልባት ክርክር ቅንዓትም ቁጣም አድመኝነትም ሐሜትም ማሾክሾክም ኩራትም ሁከትም ይሆናሉ፤ ");
INSERT INTO amh_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","እንደ ገና ስመጣ በእናንተ ዘንድ አምላኬ እንዲያዋርደኝ፥ አስቀድመውም ኃጢአት ከሠሩትና ስላደረጉት ርኵሰትና ዝሙት መዳራትም ንስሐ ካልገቡት ወገን ስለ ብዙዎች ምናልባት አዝናለሁ ብዬ እፈራለሁ። ");
INSERT INTO amh_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","ወደ እናንተ ስመጣ ይህ ሦስተኛዬ ነው፤ ሁሉ ነገር በሁለትና በሦስት ምስክር አፍ ይጸናል። ");
INSERT INTO amh_vpl VALUES ("C213_2","077_13_2","2CO","13","2","4","በድካም ተሰቅሎአልና፥ ነገር ግን በእግዚአብሔር ኃይል በሕይወት ይኖራል። እኛ ደግሞ ከእርሱ ጋር እንደክማለንና፥ ነገር ግን ስለ እናንተ በሆነ በእግዚአብሔር ኃይል ከእርሱ ጋር በሕይወት እንኖራለን። ");
INSERT INTO amh_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","በሃይማኖት ብትኖሩ ራሳችሁን መርምሩ፤ ራሳችሁን ፈትኑ፤ ወይስ ምናልባት የማትበቁ ባትሆኑ፥ ኢየሱስ ክርስቶስ በእናንተ ውስጥ እንዳለ ስለ እናንተ አታውቁምን? ");
INSERT INTO amh_vpl VALUES ("C213_6","077_13_6","2CO","13","6","6","እኛ ግን የማንበቃ እንዳይደለን ልታውቁ ተስፋ አደርጋለሁ። ");
INSERT INTO amh_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","ክፉ ነገርንም ከቶ እንዳታደርጉ ወደ እግዚአብሔር እንጸልያለን፤ እኛ የምንበቃ ሆነን እንገለጥ ዘንድ አይደለም ነገር ግን እኛ ምንም እንደማንበቃ ብንሆን፥ እናንተ መልካሙን ታደርጉ ዘንድ ነው። ");
INSERT INTO amh_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","ለእውነት እንጂ በእውነት ላይ ምንም ለማድረግ አንችልምና። ");
INSERT INTO amh_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","እኛ ስንደክም እናንተም ኃይለኞች ስትሆኑ ደስ ብሎናልና፤ እናንተ ፍጹማን ትሆኑ ዘንድ ለዚህ ደግሞ እንጸልያለን። ");
INSERT INTO amh_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","ስለዚህ ጌታ ለማፍረስ ያይደለ ለማነጽ እንደ ሰጠኝ ሥልጣን፥ ከእናንተ ጋር ሳለሁ በቁርጥ እንዳልሠራ በሩቅ ሆኜ ይህን እጽፋለሁ። ");
INSERT INTO amh_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","በቀረውስ፥ ወንድሞች ሆይ፥ ደኅና ሁኑ። ፍጹማን ሁኑ፥ ምክሬን ስሙ፥ በአንድ ልብ ሁኑ፥ በሰላም ኑሩ፥ የፍቅርና የሰላምም አምላክ ከእናንተ ጋር ይሆናል። ");
INSERT INTO amh_vpl VALUES ("C213_12","077_13_12","2CO","13","12","12","በተቀደሰ አሳሳም እርስ በርሳችሁ ሰላምታ ተሰጣጡ። ");
INSERT INTO amh_vpl VALUES ("C213_13","077_13_13","2CO","13","13","13","ቅዱሳን ሁሉ ሰላምታ ያቀርቡላችኋል። ");
INSERT INTO amh_vpl VALUES ("C213_14","077_13_14","2CO","13","14","14","የጌታ የኢየሱስ ክርስቶስ ጸጋ የእግዚአብሔርም ፍቅር የመንፈስ ቅዱስም ኅብረት ከሁላችሁ ጋር ይሁን። አሜን። ");
INSERT INTO amh_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","3","ከእግዚአብሔር ከአባታችን ከጌታችንም ከኢየሱስ ክርስቶስ ጸጋና ሰላም ለእናንተ ይሁን። ");
INSERT INTO amh_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","ክፉ ከሆነ ከአሁኑ ዓለም ያድነን ዘንድ እንደ አምላካችንና እንደ አባታችን ፈቃድ ስለ ኃጢአታችን ራሱን ሰጠ። ");
INSERT INTO amh_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","ለአብ ከዘላለም እስከ ዘላለም ክብር ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","በክርስቶስ ጸጋ እናንተን ከጠራችሁ ከእርሱ ወደ ልዩ ወንጌል እንዲህ ፈጥናችሁ እንዴት እንዳለፋችሁ እደነቃለሁ፤ ");
INSERT INTO amh_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","እርሱ ግን ሌላ ወንጌል አይደለም፤ የሚያናውጡአችሁ የክርስቶስንም ወንጌል ሊያጣምሙ የሚወዱ አንዳንዶች አሉ እንጂ። ");
INSERT INTO amh_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","ነገር ግን እኛ ብንሆን ወይም ከሰማይ መልአክ፥ ከሰበክንላችሁ ወንጌል የሚለይ ወንጌልን ቢሰብክላችሁ፥ የተረገመ ይሁን። ");
INSERT INTO amh_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","አስቀድመን እንዳልን እንዲሁ አሁን ሁለተኛ እላለሁ፥ ከተቀበላችሁት የተለየውን ማንም ቢሰብክላችሁ የተረገመ ይሁን። ");
INSERT INTO amh_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","ሰውን ወይስ እግዚአብሔርን አሁን እሺ አሰኛለሁን? ወይም ሰውን ደስ ላሰኝ እፈልጋለሁን? አሁን ሰውን ደስ ባሰኝ የክርስቶስ ባሪያ ባልሆንሁም። ");
INSERT INTO amh_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","ወንድሞች ሆይ፥ በእኔ የተሰበከ ወንጌል እንደ ሰው እንዳይደለ አስታውቃችኋለሁ፤ ");
INSERT INTO amh_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","ኢየሱስ ክርስቶስ ገልጦልኛል እንጂ እኔ ከሰው አልተቀበልሁትም አልተማርሁትምም። ");
INSERT INTO amh_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","በአይሁድ ሥርዓት በፊት እንዴት እንደ ኖርሁ ሰምታችኋልና፤ የእግዚአብሔርን ቤተ ክርስቲያን ያለ ልክ አሳድድና አጠፋ ነበር፥ ");
INSERT INTO amh_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","ለአባቶችም ወግ ከመጠን ይልቅ እየቀናሁ በወገኔ ዘንድ በዘመኔ ካሉት ብዙዎችን በአይሁድ ሥርዓት እበልጥ ነበር። ");
INSERT INTO amh_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","17","ከእኔም በፊት ሐዋርያት ወደ ነበሩት ወደ ኢየሩሳሌም አልወጣሁም፥ ነገር ግን ወደ ዓረብ አገር ሄድሁ እንደ ገናም ወደ ደማስቆ ተመለስሁ። ");
INSERT INTO amh_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","ከዚህ ወዲያ ከሦስት ዓመት በኋላ ኬፋን ልጠይቅ ወደ ኢየሩሳሌም ወጥቼ ከእርሱ ጋር አሥራ አምስት ቀን ሰነበትሁ፤ ");
INSERT INTO amh_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","ነገር ግን ከጌታ ወንድም ከያዕቆብ በቀር ከሐዋርያት ሌላ አላየሁም። ");
INSERT INTO amh_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","ስለምፅፍላችሁም ነገር፥ እነሆ፥ በእግዚአብሔር ፊት ሐሰት አልናገርም። ");
INSERT INTO amh_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","ከዚያ ወዲያ ወደ ሶርያና ወደ ኪልቅያ አገር መጣሁ። ");
INSERT INTO amh_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","በክርስቶስም ያሉት የይሁዳ ማኅበሮች ፊቴን አያውቁም ነበር፤ ");
INSERT INTO amh_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","ነገር ግን። ቀድሞ እኛን ያሳድድ የነበረ፥ እርሱ በፊት ያጠፋው የነበረውን ሃይማኖት አሁን ይሰብካል ተብሎ ሲነገር ይሰሙ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","ስለ እኔም እግዚአብሔርን ያከብሩ ነበር። ");
INSERT INTO amh_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","ከዚያ ወዲያ ከአሥራ አራት ዓመት በኋላ ከበርናባስ ጋር ቲቶን ደግሞ ይዤ ወደ ኢየሩሳሌም ሁለተኛ ወጣሁ፤ ");
INSERT INTO amh_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","እንደ ተገለጠልኝም ወጣሁ፤ ምናልባትም በከንቱ እንዳልሮጥ ወይም በከንቱ ሮጬ እንዳልሆን በአሕዛብ መካከል የምሰብከውን ወንጌል አስታወቅኋቸው፤ ዋኖች ግን መስለው ለሚታዩ ለብቻቸው አስታወቅኋቸው። ");
INSERT INTO amh_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","ነገር ግን ከእኔ ጋር የነበረ ቲቶ እንኳ የግሪክ ሰው ሲሆን ይገረዝ ዘንድ ግድ አላሉትም፤ ");
INSERT INTO amh_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","ነገር ግን ባሪያዎች ሊያደርጉን በክርስቶስ ኢየሱስ ያለንን አርነታችንን ይሰልሉ ዘንድ ሾልከው በስውር ስለ ገቡ ስለ ሐሰተኞች ወንድሞች ነበረ። ");
INSERT INTO amh_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","የወንጌልም እውነት በእናንተ ዘንድ ጸንቶ እንዲኖር ለአንድ ሰዓት እንኳ ለቅቀን አልተገዛንላቸውም። ");
INSERT INTO amh_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","አለቆች የመሰሉት ግን፥ በፊት ማን እንደ ነበሩ አይገደኝም፤ እግዚአብሔር የሰውን ፊት አይቶ አያደላም፤ አለቆች የመሰሉት አንዳች እንኳ አልጨመሩልኝምና፥ ");
INSERT INTO amh_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","ተመልሰው ግን ጴጥሮስ ለተገረዙት የሆነው ወንጌል አደራ እንደ ተሰጠው እንዲሁ ለእኔ ላልተገረዙት የሆነው ወንጌል አደራ እንደ ተሰጠኝ አዩ፤ ");
INSERT INTO amh_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","ለተገረዙት ሐዋርያ እንዲሆን ለጴጥሮስ የሠራለት፥ ለእኔ ደግሞ ለአሕዛብ ሐዋርያ እንድሆን ሠርቶአልና። ");
INSERT INTO amh_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","ደግሞ የተሰጠኝን ጸጋ አውቀው፥ አዕማድ መስለው የሚታዩ ያዕቆብና ኬፋ ዮሐንስም እኛ ወደ አሕዛብ እነርሱም ወደ ተገረዙት ይሄዱ ዘንድ ለእኔና ለበርናባስ ቀኝ እጃቸውን ሰጡን፤ ");
INSERT INTO amh_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","ድሆችን እናስብ ዘንድ ብቻ ለመኑን፥ ይህንም ደግሞ ላደርግ ተጋሁ። ");
INSERT INTO amh_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","ነገር ግን ኬፋ ወደ አንጾኪያ በመጣ ጊዜ ፊት ለፊት ተቃወምሁት፥ ይፈረድበት ዘንድ ይገባ ነበርና። ");
INSERT INTO amh_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","አንዳንድ ከያዕቆብ ዘንድ ሳይመጡ ከአሕዛብ ጋር አብሮ ይበላ ነበርና፤ በመጡ ጊዜ ግን ከተገረዙት ወገን ያሉትን ፈርቶ ያፈገፍግ ነበርና ከእነርሱ ተለየ። ");
INSERT INTO amh_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","የቀሩትም አይሁድ ደግሞ፥ በርናባስ ስንኳ በግብዝነታቸው እስከ ተሳበ ድረስ፥ ከእርሱ ጋር አብረው ግብዞች ሆኑ። ");
INSERT INTO amh_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","ነገር ግን እንደ ወንጌል እውነት በቅንነት እንዳልሄዱ ባየሁ ጊዜ በሁሉ ፊት ኬፋን። አንተ አይሁዳዊ ሳለህ በአይሁድ ኑሮ ያይደለ በአሕዛብ ኑሮ ብትኖር፥ አሕዛብ በአይሁድ ኑሮ ሊኖሩ እንዴት ግድ አልሃቸው? አልሁት። ");
INSERT INTO amh_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","እኛ በፍጥረት አይሁድ ነን ኃጢአተኞችም የሆኑ አሕዛብ አይደለንም፤ ");
INSERT INTO amh_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","ነገር ግን ሰው በኢየሱስ ክርስቶስ በማመን እንዲጸድቅ እንጂ በሕግ ሥራ እንዳይሆን አውቀን፥ ሥጋን የለበሰ ሁሉ በሕግ ሥራ ስለማይጸድቅ፥ እኛ ራሳችን በሕግ ሥራ ሳይሆን በክርስቶስ እምነት እንጸድቅ ዘንድ በክርስቶስ ኢየሱስ አምነናል። ");
INSERT INTO amh_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","ነገር ግን በክርስቶስ ልንጸድቅ የምንፈልግ ስንሆን ራሳችን ደግሞ ኃጢአተኞች ሆነን ከተገኘን፥ እንግዲያስ ክርስቶስ የኃጢአት አገልጋይ ነዋ? አይደለም። ");
INSERT INTO amh_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","ያፈረስሁትን ይህን እንደ ገና የማንጽ ከሆንሁ ራሴ ሕግ ተላላፊ እንድሆን አስረዳለሁና። ");
INSERT INTO amh_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","እኔ ለእግዚአብሔር ሕያው ሆኜ እኖር ዘንድ በሕግ በኩል ለሕግ ሞቼ ነበርና። ");
INSERT INTO amh_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","ከክርስቶስ ጋር ተሰቅዬአለሁ፤ እኔም አሁን ሕያው ሆኜ አልኖርም ክርስቶስ ግን በእኔ ይኖራል፤ አሁንም በሥጋ የምኖርበት ኑሮ በወደደኝና ስለ እኔ ራሱን በሰጠው በእግዚአብሔር ልጅ ላይ ባለ እምነት የምኖረው ነው። ");
INSERT INTO amh_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","የእግዚአብሔርን ጸጋ አልጥልም፤ ጽድቅስ በሕግ በኩል ከሆነ እንኪያስ ክርስቶስ በከንቱ ሞተ። ");
INSERT INTO amh_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","የማታስተውሉ የገላትያ ሰዎች ሆይ፥ በዓይናችሁ ፊት ኢየሱስ ክርስቶስ እንደ ተሰቀለ ሆኖ ተሥሎ ነበር፤ ለእውነት እንዳትታዘዙ አዚም ያደረገባችሁ ማን ነው? ");
INSERT INTO amh_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","ይህን ብቻ ከእናንተ እንድማር እወዳለሁ፤ በሕግ ሥራ ወይም ከእምነት ጋር በሆነ መስማት መንፈስን ተቀበላችሁን? ");
INSERT INTO amh_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","እንዲህን የማታስተውሉ ናችሁ? በመንፈስ ጀምራችሁ አሁን በሥጋ ትፈጽማላችሁን? ");
INSERT INTO amh_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","በውኑ ከንቱ እንደ ሆነስ እንደዚህ ያለ መከራ በከንቱ ተቀበላችሁን? ");
INSERT INTO amh_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","እንግዲህ መንፈስን የሚሰጣችሁ በእናንተም ዘንድ ተአምራት የሚያደርግ፥ በሕግ ሥራ ነውን ወይስ ከእምነት ጋር በሆነ መስማት ነው? ");
INSERT INTO amh_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","እንዲሁ አብርሃም በእግዚአብሔር አመነና ጽድቅ ሆኖ ተቆጠረለት። ");
INSERT INTO amh_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","እንኪያስ ከእምነት የሆኑት እነዚህ የአብርሃም ልጆች እንደ ሆኑ እወቁ። ");
INSERT INTO amh_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","መጽሐፍም እግዚአብሔር አሕዛብን በእምነት እንዲያጸድቅ አስቀድሞ አይቶ። በአንተ አሕዛብ ሁሉ ይባረካሉ ብሎ ወንጌልን ለአብርሃም አስቀድሞ ሰበከ። ");
INSERT INTO amh_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","እንደዚህ ከእምነት የሆኑት ካመነው ከአብርሃም ጋር ይባረካሉ። ");
INSERT INTO amh_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","ከሕግ ሥራ የሆኑት ሁሉ በእርግማን በታች ናቸውና፤ በሕግ መጽሐፍ በተጻፉት ሁሉ ጸንቶ የማይኖር የማያደርግም ሁሉ የተረገመ ነው ተብሎ ተጽፎአልና። ");
INSERT INTO amh_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","ጻድቅ በእምነት ይኖራል ተብሎአልና ማንም በእግዚአብሔር ፊት በሕግ እንዳይጸድቅ ግልጥ ነው። ");
INSERT INTO amh_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","ሕግም ከእምነት አይደለም ነገር ግን። የሚያደርገው ይኖርበታል ተብሎአል። ");
INSERT INTO amh_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","በእንጨት የሚሰቀል ሁሉ የተረገመ ነው ተብሎ ተጽፎአልና ክርስቶስ ስለ እኛ እርግማን ሆኖ ከሕግ እርግማን ዋጀን፤ ");
INSERT INTO amh_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","የመንፈስን ተስፋ በእምነት እንድንቀበል፥ የአብርሃም በረከት ወደ አሕዛብ በኢየሱስ ክርስቶስ ይደርስላቸው ዘንድ። ");
INSERT INTO amh_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","ወንድሞች ሆይ፥ እንደ ሰው ልማድ እላለሁ። የሰው ስንኳ ቢሆን እርግጠኛውን ኪዳን ማንም አይንቅም ወይም አይጨምርበትም። ");
INSERT INTO amh_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","ለአብርሃምና ለዘሩም የተስፋው ቃል ተነገረ። ስለ ብዙዎች እንደሚነገር። ለዘሮቹም አይልም፤ ስለ አንድ እንደሚነገር ግን። ለዘርህም ይላል፥ እርሱም ክርስቶስ። ");
INSERT INTO amh_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","ይህንም እላለሁ፤ ከአራት መቶ ሠላሳ ዓመት በኋላ የተሰጠው ሕግ አስቀድሞ በእግዚአብሔር የተረጋገጠውን ኪዳን የተስፋውን ቃል እስኪሽር ድረስ አያፈርስም። ");
INSERT INTO amh_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","ርስቱ በሕግ ቢሆንስ እንግዲያስ በተስፋ ቃል አይሆንም፤ በተስፋ ቃል ግን እግዚአብሔር ለአብርሃም ሰጥቶአል። ");
INSERT INTO amh_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","እንግዲህ ሕግ ምንድር ነው? ተስፋው የተሰጠው ዘር እስኪመጣ ድረስ በመካከለኛ እጅ በመላእክት በኩል ስለ ሕግ መተላለፍ ተጨመረ። ");
INSERT INTO amh_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","መካከለኛውም ለአንድ ብቻ አይደለም እግዚአብሔር ግን አንድ ነው። ");
INSERT INTO amh_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","እንግዲህ ሕግ የእግዚአብሔርን የተስፋ ቃል የሚቃወም ነውን? አይደለም። ሕያው ሊያደርግ የሚቻለው ሕግ ተሰጥቶ ቢሆንስ በእውነት ጽድቅ ከሕግ በሆነ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","ነገር ግን በኢየሱስ ክርስቶስ ከማመን የሆነው የተስፋ ቃል ለሚያምኑ ይሰጥ ዘንድ መጽሐፍ ከኃጢአት በታች ሁሉን ዘግቶታል። ");
INSERT INTO amh_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","እምነትም ሳይመጣ ሊገለጥ ላለው እምነት ተዘግተን ከሕግ በታች እንጠበቅ ነበር። ");
INSERT INTO amh_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","እንደዚህ በእምነት እንጸድቅ ዘንድ ሕግ ወደ ክርስቶስ የሚያመጣ ሞግዚታችን ሆኖአል፤ ");
INSERT INTO amh_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","እምነት ግን መጥቶአልና ከእንግዲህ ወዲህ ከሞግዚት በታች አይደለንም። ");
INSERT INTO amh_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","በእምነት በኩል ሁላችሁ በክርስቶስ ኢየሱስ የእግዚአብሔር ልጆች ናችሁና፤ ");
INSERT INTO amh_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","ከክርስቶስ ጋር አንድ ትሆኑ ዘንድ የተጠመቃችሁ ሁሉ ክርስቶስን ለብሳችኋልና። ");
INSERT INTO amh_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","አይሁዳዊ ወይም የግሪክ ሰው የለም፥ ባሪያ ወይም ጨዋ ሰው የለም፥ ወንድም ሴትም የለም፤ ሁላችሁ በክርስቶስ ኢየሱስ አንድ ሰው ናችሁና። ");
INSERT INTO amh_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","እናንተም የክርስቶስ ከሆናችሁ እንኪያስ የአብርሃም ዘር እንደ ተስፋውም ቃል ወራሾች ናችሁ። ");
INSERT INTO amh_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","ነገር ግን እላለሁ፥ ወራሹ ሕፃን ሆኖ ባለበት ዘመን ሁሉ፥ ምንም የሁሉ ጌታ ቢሆን ከቶ ከባሪያ አይለይም፥ ");
INSERT INTO amh_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","ነገር ግን አባቱ እስከ ቀጠረለት ቀን ድረስ ከጠባቂዎችና ከመጋቢዎች በታች ነው። ");
INSERT INTO amh_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","እንዲሁ እኛ ደግሞ ሕፃናት ሆነን ሳለን ከዓለም መጀመሪያ ትምህርት በታች ተገዝተን ባሪያዎች ነበርን፤ ");
INSERT INTO amh_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","ነገር ግን የዘመኑ ፍጻሜ በደረሰ ጊዜ እግዚአብሔር ከሴት የተወለደውን ከሕግም በታች የተወለደውን ልጁን ላከ፤ ");
INSERT INTO amh_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","እንደ ልጆች እንሆን ዘንድ፥ ከሕግ በታች ያሉትን ይዋጅ ዘንድ። ");
INSERT INTO amh_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","ልጆችም ስለ ሆናችሁ እግዚአብሔር አባ አባት ብሎ የሚጮኽ የልጁን መንፈስ በልባችሁ ውስጥ ላከ። ");
INSERT INTO amh_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","ስለዚህ ከእንግዲህ ወዲህ ልጅ ነህ እንጂ ባሪያ አይደለህም፤ ልጅም ከሆንህ ደግሞ በክርስቶስ የእግዚአብሔር ወራሽ ነህ። ");
INSERT INTO amh_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","ነገር ግን በዚያን ጊዜ እግዚአብሔርን ሳታውቁ በባሕርያቸው አማልክት ለማይሆኑ ባሪያዎች ሆናችሁ ተገዛችሁ፤ ");
INSERT INTO amh_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","አሁን ግን እግዚአብሔርን ስታውቁ ይልቅስ በእግዚአብሔር ስትታወቁ እንደ ገና ወደ ደካማ ወደሚናቅም ወደ መጀመሪያ ትምህርት እንዴት ትመለሳላችሁ? እንደ ገና ባሪያዎች ሆናችሁ ዳግመኛ ለዚያ ልትገዙ ትወዳላችሁን? ");
INSERT INTO amh_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","ቀንንና ወርን ዘመንንም ዓመትንም በጥንቃቄ ትጠብቃላችሁ። ");
INSERT INTO amh_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","ምናልባት በከንቱ ለእናንተ ደክሜአለሁ ብዬ እፈራችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","ወንድሞች ሆይ፥ እኔ ደግሞ እንደ እናንተ ሆኜአለሁና። እንደ እኔ ሁኑ ብዬ እለምናችኋለሁ። አንዳችም አልበደላችሁኝም። ");
INSERT INTO amh_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","በመጀመሪያ ወንጌልን በሰበክሁላችሁ ጊዜ ከሥጋ ድካም የተነሣ እንደ ነበረ ታውቃላችሁ፥ ");
INSERT INTO amh_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","በሥጋዬም ፈተና የሆነባችሁን ነገር አልናቃችሁትምና አልተጸየፋችሁትም ነገር ግን እንደ እግዚአብሔር መልአክ አዎን እንደ ክርስቶስ ኢየሱስ ተቀበላችሁኝ። ");
INSERT INTO amh_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","እንግዲህ ደስ ማሰኘታችሁ ወዴት አለ? ቢቻልስ ዓይኖቻችሁን አውጥታችሁ በሰጣችሁኝ ብዬ እመሰክርላችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","እንኪያስ እውነቱን ስለ ነገርኋችሁ ጠላት ሆንሁባችሁን? ");
INSERT INTO amh_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","በብርቱ ይፈልጉአችኋል፥ ለመልካም አይደለም ነገር ግን በብርቱ ትፈልጉአቸው ዘንድ በውጭ ሊያስቀሩአችሁ ይወዳሉ። ");
INSERT INTO amh_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","ነገር ግን ከእናንተ ዘንድ በምኖርበት ጊዜ ብቻ ሳይሆን ሁልጊዜ በመልካም ነገር ተፈላጊ ብትሆኑ መልካም ነው። ");
INSERT INTO amh_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","ልጆቼ ሆይ፥ ክርስቶስ በእናንተ እስኪሣል ድረስ ዳግመኛ ስለ እናንተ ምጥ ይዞኛል። ");
INSERT INTO amh_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","ስለ እናንተ አመነታለሁና አሁን በእናንተ ዘንድ ሆኜ ድምፄን ልለውጥ በወደድሁ። ");
INSERT INTO amh_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","እናንተ ከሕግ በታች ልትኖሩ የምትወዱ፥ ሕጉን አትሰሙምን? እስኪ ንገሩኝ። ");
INSERT INTO amh_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","አንዱ ከባሪያይቱ አንዱም ከጨዋይቱ የሆኑ ሁለት ልጆች ለአብርሃም እንደ ነበሩት ተጽፎአልና። ");
INSERT INTO amh_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","ነገር ግን የባሪያይቱ ልጅ እንደ ሥጋ ተወልዶአል፥ የጨዋይቱ ግን በተስፋው ቃል ተወልዶአል። ");
INSERT INTO amh_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","ይህም ነገር ምሳሌ ነው፤ እነዚህ ሴቶች እንደ ሁለቱ ኪዳኖች ናቸውና። ከደብረ ሲና የሆነችው አንዲቱ ለባርነት ልጆችን ትወልዳለች፥ እርስዋም አጋር ናት። ");
INSERT INTO amh_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","ይህችም አጋር በዓረብ ምድር ያለችው ደብረ ሲና ናት፤ አሁንም ያለችውን ኢየሩሳሌምን ትመስላለች፥ ከልጆችዋ ጋር በባርነት ናትና። ");
INSERT INTO amh_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","ላይኛይቱ ኢየሩሳሌም ግን በነጻነት የምትኖር ናት እርስዋም እናታችን ናት። ");
INSERT INTO amh_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","አንቺ የማትወልጅ መካን፥ ደስ ይበልሽ፤ አንቺ አምጠሽ የማታውቂ፥ እልል በዪና ጩኺ፤ ባል ካላቱ ይልቅ የብቸኛይቱ ልጆች በዝተዋልና ተብሎ ተጽፎአል። ");
INSERT INTO amh_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","እኛም፥ ወንድሞች ሆይ፥ እንደ ይስሐቅ የተስፋ ቃል ልጆች ነን። ");
INSERT INTO amh_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","ነገር ግን እንደ ሥጋ የተወለደው እንደ መንፈስ የተወለደውን በዚያን ጊዜ እንዳሳደደው ዛሬም እንዲሁ ነው። ");
INSERT INTO amh_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","ነገር ግን መጽሐፍ ምን ይላል? የባሪያይቱ ልጅ ከጨዋይቱ ልጅ ጋር አይወርስምና ባሪያይቱን ከልጅዋ ጋር አውጣት። ");
INSERT INTO amh_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","ስለዚህ፥ ወንድሞች ሆይ፥ የጨዋይቱ ልጆች ነን እንጂ የባሪያይቱ አይደለንም። ");
INSERT INTO amh_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","በነጻነት ልንኖር ክርስቶስ ነጻነት አወጣን፤ እንግዲህ ጸንታችሁ ቁሙ እንደ ገናም በባርነት ቀንበር አትያዙ። ");
INSERT INTO amh_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","እነሆ፥ እኔ ጳውሎስ እላችኋለሁ። ብትገረዙ ክርስቶስ ምንም አይጠቅማችሁም። ");
INSERT INTO amh_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","ሕግንም ሁሉ እንዲፈጽም ግድ አለበት ብዬ ለሚገረዙት ሁሉ ለእያንዳንዶች ደግሜ እመሰክራለሁ። ");
INSERT INTO amh_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","በሕግ ልትጸድቁ የምትፈልጉ ከክርስቶስ ተለይታችሁ ከጸጋው ወድቃችኋል። ");
INSERT INTO amh_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","እኛ በመንፈስ ከእምነት የጽድቅን ተስፋ እንጠባበቃለንና። ");
INSERT INTO amh_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","በክርስቶስ ኢየሱስ ሆኖ፥ በፍቅር የሚሠራ እምነት እንጂ መገረዝ ቢሆን ወይም አለመገረዝ አይጠቅምምና። ");
INSERT INTO amh_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","በመልካም ትሮጡ ነበር፤ ለእውነት እንዳትታዘዙ ማን ከለከላችሁ? ");
INSERT INTO amh_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","ይህ ማባበል ከሚጠራችሁ አልወጣም። ጥቂት እርሾ ሊጡን ሁሉ ያቦካል። ");
INSERT INTO amh_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","11","ነገር ግን፥ ወንድሞች ሆይ፥ እኔ ገና እስከ አሁን መገረዝን ብሰብክ እስከ አሁን ድረስ ለምን ያሳድዱኛል? እንኪያስ የመስቀል ዕንቅፋት ተወግዶአል። ");
INSERT INTO amh_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","የሚያውኩአችሁ ይቆረጡ። ");
INSERT INTO amh_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","ወንድሞች ሆይ፥ እናንተ ለአርነት ተጠርታችኋልና፤ ብቻ አርነታችሁ ለሥጋ ምክንያትን አይስጥ፥ ነገር ግን በፍቅር እርስ በርሳችሁ እንደ ባሪያዎች ሁኑ። ");
INSERT INTO amh_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","ሕግ ሁሉ በአንድ ቃል ይፈጸማልና፥ እርሱም። ባልንጀራህን እንደ ራስህ ውደድ የሚል ነው። ");
INSERT INTO amh_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","ነገር ግን እርስ በርሳችሁ ብትነካከሱ ብትበላሉ እርስ በርሳችሁ እንዳትጠፋፉ ተጠንቀቁ። ");
INSERT INTO amh_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","ነገር ግን እላለሁ፥ በመንፈስ ተመላለሱ፥ የሥጋንም ምኞት ከቶ አትፈጽሙ። ");
INSERT INTO amh_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","ሥጋ በመንፈስ ላይ መንፈስም በሥጋ ላይ ይመኛልና፥ እነዚህም እርስ በርሳቸው ይቀዋወማሉ፤ ስለዚህም የምትወዱትን ልታደርጉ አትችሉም። ");
INSERT INTO amh_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","በመንፈስ ብትመሩ ግን ከሕግ በታች አይደላችሁም። ");
INSERT INTO amh_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","የሥጋ ሥራም የተገለጠ ነው እርሱም ዝሙት፥ ርኵሰት፥ ");
INSERT INTO amh_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","መዳራት፥ ጣዖትን ማምለክ፥ ምዋርት፥ ጥል፥ ክርክር፥ ቅንዓት፥ ቁጣ፥ አድመኛነት፥ ");
INSERT INTO amh_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","መለያየት፥ መናፍቅነት፥ ምቀኝነት፥ መግደል፥ ስካር፥ ዘፋኝነት፥ ይህንም የሚመስል ነው። አስቀድሜም እንዳልሁ፥ እንደዚህ ያሉትን የሚያደርጉ የእግዚአብሔርን መንግሥት አይወርሱም። ");
INSERT INTO amh_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","የመንፈስ ፍሬ ግን ፍቅር፥ ደስታ፥ ሰላም፥ ትዕግሥት፥ ቸርነት፥ በጎነት፥ እምነት፥ የውሃት፥ ራስን መግዛት ነው። ");
INSERT INTO amh_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","እንደዚህ ያሉትን የሚከለክል ሕግ የለም። ");
INSERT INTO amh_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","የክርስቶስ ኢየሱስም የሆኑቱ ሥጋን ከክፉ መሻቱና ከምኞቱ ጋር ሰቀሉ። ");
INSERT INTO amh_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","በመንፈስ ብንኖር በመንፈስ ደግሞ እንመላለስ። ");
INSERT INTO amh_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","እርስ በርሳችን እየተነሣሣንና እየተቀናናን በከንቱ አንመካ። ");
INSERT INTO amh_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","ወንድሞች ሆይ፥ ሰው በማናቸውም በደል ስንኳ ቢገኝ፥ መንፈሳውያን የሆናችሁ እናንተ እንደዚህ ያለውን ሰው በየውሃት መንፈስ አቅኑት፤ አንተ ደግሞ እንዳትፈተን ራስህን ጠብቅ። ");
INSERT INTO amh_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","ከእናንተ እያንዳንዱ የአንዱን ሸክም ይሸከም እንዲሁም የክርስቶስን ሕግ ፈጽሙ። ");
INSERT INTO amh_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","አንዱ ምንም ሳይሆን ምንም የሆነ ቢመስለው ራሱን ያታልላልና። ");
INSERT INTO amh_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","ነገር ግን እያንዳንዱ የገዛ ራሱን ሥራ ይፈትን፥ ከዚያም በኋላ ስለ ሌላው ሰው ያልሆነ ስለ ራሱ ብቻ የሚመካበትን ያገኛል፤ ");
INSERT INTO amh_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","እያንዳንዱ የገዛ ራሱን ሸክም ሊሸከም ነውና። ");
INSERT INTO amh_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","ነገር ግን ቃሉን የሚማር ከሚያስተምረው ጋር መልካምን ነገር ሁሉ ይከፋፈል። ");
INSERT INTO amh_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","አትሳቱ፤ እግዚአብሔር አይዘበትበትም። ሰው የሚዘራውን ሁሉ ያንኑ ደግሞ ያጭዳልና፤ ");
INSERT INTO amh_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","በገዛ ሥጋው የሚዘራ ከሥጋ መበስበስን ያጭዳልና፥ በመንፈስ ግን የሚዘራው ከመንፈስ የዘላለምን ሕይወት ያጭዳል። ");
INSERT INTO amh_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","ባንዝልም በጊዜው እናጭዳለንና መልካም ሥራን ለመሥራት አንታክት። ");
INSERT INTO amh_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","እንግዲያስ ጊዜ ካገኘን ዘንድ ለሰው ሁሉ ይልቁንም ለሃይማኖት ቤተ ሰዎች መልካም እናድርግ። ");
INSERT INTO amh_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","እንዴት ባሉ ታላላቆች ፊደላት በእጄ እንደ ጻፍሁላችሁ እዩ። ");
INSERT INTO amh_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","በሥጋ መልካም ሆነው ሊታዩ የሚወዱ ሁሉ እንድትገረዙ ግድ አሉአችሁ፥ ነገር ግን ስለ ክርስቶስ መስቀል እንዳይሰደዱ ብቻ ነው። ");
INSERT INTO amh_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","በሥጋችሁ እንዲመኩ ልትገረዙ ይወዳሉ እንጂ የተገረዙቱ ራሳቸው እንኳ ሕግን አይጠብቁም። ");
INSERT INTO amh_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","ነገር ግን ዓለም ለእኔ የተሰቀለበት እኔም ለዓለም የተሰቀልሁበት ከጌታችን ከኢየሱስ ክርስቶስ መስቀል በቀር ሌላ ትምክህት ከእኔ ይራቅ። ");
INSERT INTO amh_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","በክርስቶስ ኢየሱስ አዲስ ፍጥረት መሆን ይጠቅማል እንጂ መገረዝ ቢሆን ወይም አለመገረዝ አይጠቅምምና። ");
INSERT INTO amh_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","በዚህም ሥርዓት በሚመላለሱ ሁሉ ላይ በእግዚአብሔር እስራኤልም ላይ ሰላምና ምሕረት ይሁን። ");
INSERT INTO amh_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","እኔ የኢየሱስን ማኅተም በሥጋዬ ተሸክሜአለሁና ከእንግዲህ ወዲህ አንድ ስንኳ አያድክመኝ። ");
INSERT INTO amh_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","ወንድሞች ሆይ፥ የጌታችን የኢየሱስ ክርስቶስ ጸጋ ከመንፈሳችሁ ጋር ይሁን። አሜን። ");
INSERT INTO amh_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","በእግዚአብሔር ፈቃድ የኢየሱስ ክርስቶስ ሐዋርያ የሆነ ጳውሎስ፥ በኤፌሶን ላሉት ቅዱሳን በክርስቶስ ኢየሱስም ላሉት ምእመናን፤ ");
INSERT INTO amh_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","ከእግዚአብሔር ከአባታችን ከጌታም ከኢየሱስ ክርስቶስ ጸጋና ሰላም ለእናንተ ይሁን። ");
INSERT INTO amh_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","በክርስቶስ በሰማያዊ ስፍራ በመንፈሳዊ በረከት ሁሉ የባረከን የጌታችን የኢየሱስ ክርስቶስ አምላክና አባት ይባረክ። ");
INSERT INTO amh_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","ዓለም ሳይፈጠር፥ በፊቱ ቅዱሳንና ነውር የሌለን በፍቅር እንሆን ዘንድ በክርስቶስ መረጠን። ");
INSERT INTO amh_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","በበጎ ፈቃዱ እንደ ወደደ፥ በኢየሱስ ክርስቶስ ሥራ ለእርሱ ልጆች ልንሆን አስቀድሞ ወሰነን። ");
INSERT INTO amh_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","በውድ ልጁም እንዲያው የሰጠን የጸጋው ክብር ይመሰገን ዘንድ ይህን አደረገ። ");
INSERT INTO amh_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","በውድ ልጁም፥ እንደ ጸጋው ባለ ጠግነት መጠን፥ በደሙ የተደረገ ቤዛነታችንን አገኘን እርሱም የበደላችን ስርየት። ");
INSERT INTO amh_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","ጸጋውንም በጥበብና በአእምሮ ሁሉ አበዛልን። ");
INSERT INTO amh_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","በክርስቶስ ለማድረግ እንደ ወደደ እንደ አሳቡ፥ የፈቃዱን ምሥጢር አስታውቆናልና፤ ");
INSERT INTO amh_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","በዘመን ፍጻሜ ይደረግ ዘንድ ያለው አሳቡም በሰማይና በምድር ያለውን ሁሉ በክርስቶስ ለመጠቅለል ነው። ");
INSERT INTO amh_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","እንደ ፈቃዱ ምክር ሁሉን የሚሠራ እንደ እርሱ አሳብ፥ አስቀድመን የተወሰንን በክርስቶስ ደግሞ ርስትን ተቀበልን። ");
INSERT INTO amh_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","ይኸውም፥ በክርስቶስ አስቀድመን ተስፋ ያደረግን እኛ ለክብሩ ምስጋና እንሆን ዘንድ ነው። ");
INSERT INTO amh_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","እናንተም ደግሞ የእውነትን ቃል፥ ይኸውም የመዳናችሁን ወንጌል፥ ሰምታችሁ ደግሞም በክርስቶስ አምናችሁ፥ በተስፋው መንፈስ በመንፈስ ቅዱስ ታተማችሁ፤ ");
INSERT INTO amh_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","እርሱም የርስታችን መያዣ ነው፥ ለእግዚአብሔር ያለውን ሁሉ እስኪዋጅ ድረስ፥ ይህም ለክብሩ ምስጋና ይሆናል። ");
INSERT INTO amh_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","ስለዚህ እኔ ደግሞ በእናንተ ዘንድ ስለሚሆን በጌታ በኢየሱስ ስለ ማመንና ለቅዱሳን ሁሉ ስለሚሆን መውደድ ሰምቼ፥ ");
INSERT INTO amh_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","ስለ እናንተ እያመሰገንሁ ስጸልይ ስለ እናንተ ማሳሰብን አልተውም፤ ");
INSERT INTO amh_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","የክብር አባት የጌታችን የኢየሱስ ክርስቶስ አምላክ እርሱን በማወቅ የጥበብንና የመገለጥን መንፈስ እንዲሰጣችሁ እለምናለሁ። ");
INSERT INTO amh_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","22","ሁሉንም ከእግሩ በታች አስገዛለት ከሁሉ በላይም ራስ እንዲሆን ለቤተ ክርስቲያን ሰጠው። ");
INSERT INTO amh_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","እርስዋም አካሉና ሁሉን በሁሉ የሚሞላ የእርሱ ሙላቱ ናት። ");
INSERT INTO amh_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","3","በእነዚህም ልጆች መካከል እኛ ሁላችን ደግሞ፥ የሥጋችንንና የልቡናችንን ፈቃድ እያደረግን፥ በሥጋችን ምኞት በፊት እንኖር ነበርን እንደ ሌሎቹም ደግሞ ከፍጥረታችን የቁጣ ልጆች ነበርን። ");
INSERT INTO amh_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","ነገር ግን እግዚአብሔር በምሕረቱ ባለ ጠጋ ስለ ሆነ፥ ");
INSERT INTO amh_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","ከወደደን ከትልቅ ፍቅሩ የተነሣ በበደላችን ሙታን እንኳ በሆንን ጊዜ ከክርስቶስ ጋር ሕይወት ሰጠን፥ በጸጋ ድናችኋልና፥ ");
INSERT INTO amh_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","8","ጸጋው በእምነት አድኖአችኋልና፤ ይህም የእግዚአብሔር ስጦታ ነው እንጂ ከእናንተ አይደለም፤ ");
INSERT INTO amh_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","ማንም እንዳይመካ ከሥራ አይደለም። ");
INSERT INTO amh_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","እኛ ፍጥረቱ ነንና፤ እንመላለስበት ዘንድ እግዚአብሔር አስቀድሞ ያዘጋጀውን መልካሙን ሥራ ለማድረግ በክርስቶስ ኢየሱስ ተፈጠርን። ");
INSERT INTO amh_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","ስለዚህ እናንተ አስቀድሞ በሥጋ አሕዛብ የነበራችሁ፥ በሥጋ በእጅ የተገረዙ በተባሉት ያልተገረዙ የተባላችሁ፥ ይህን አስቡ፤ ");
INSERT INTO amh_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","በዚያ ዘመን ከእስራኤል መንግሥት ርቃችሁ ለተስፋውም ቃል ኪዳን እንግዶች ሆናችሁ በዚህም ዓለም ተስፋን አጥታችሁ ከእግዚአብሔርም ተለይታችሁ ያለ ክርስቶስ ነበራችሁ። ");
INSERT INTO amh_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","አሁን ግን እናንተ በፊት ርቃችሁ የነበራችሁ በክርስቶስ ኢየሱስ ሆናችሁ በክርስቶስ ደም ቀርባችኋል። ");
INSERT INTO amh_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","16","ጥልንም በመስቀሉ ገድሎ በእርሱ ሁለታቸውን በአንድ አካል ከእግዚአብሔር ጋር ያስታርቅ ዘንድ ነው። ");
INSERT INTO amh_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","መጥቶም ርቃችሁ ለነበራችሁ ለእናንተ ሰላምን፥ ቀርበው ለነበሩትም ሰላምን የምስራች ብሎ ሰበከ፤ ");
INSERT INTO amh_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","በእርሱ ሥራ ሁላችን በአንድ መንፈስ ወደ አብ መግባት አለንና። ");
INSERT INTO amh_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","እንግዲያስ ከእንግዲህ ወዲህ ከቅዱሳን ጋር ባላገሮችና የእግዚአብሔር ቤተ ሰዎች ናችሁ እንጂ እንግዶችና መጻተኞች አይደላችሁም። ");
INSERT INTO amh_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","በሐዋርያትና በነቢያት መሠረት ላይ ታንጻችኋል፥ የማዕዘኑም ራስ ድንጋይ ክርስቶስ ኢየሱስ ነው፤ ");
INSERT INTO amh_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","በእርሱም ሕንጻ ሁሉ እየተጋጠመ በጌታ ቅዱስ ቤተ መቅደስ እንዲሆን ያድጋል፤ ");
INSERT INTO amh_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","በእርሱም እናንተ ደግሞ ለእግዚአብሔር መኖሪያ ለመሆን በመንፈስ አብራችሁ ትሠራላችሁ። ");
INSERT INTO amh_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","ስለዚህም አሕዛብ ስለ ሆናችሁ ስለ እናንተ የክርስቶስ ኢየሱስ እስር የሆንሁ እኔ ጳውሎስ ለእግዚአብሔር እንበረከካለሁ። ");
INSERT INTO amh_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","ለእናንተ ስለ ተሰጠኝ ስለ እግዚአብሔር ጸጋ መጋቢነት በእርግጥ ሰምታችኋል፤ ");
INSERT INTO amh_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","አስቀድሜ በአጭሩ እንደ ጻፍሁ፥ ይህን ምሥጢር በመግለጥ አስታወቀኝ፤ ");
INSERT INTO amh_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","ይህንም ስታነቡ የክርስቶስን ምሥጢር እንዴት እንደማስተውል ልትመለከቱ ትችላላችሁ፤ ");
INSERT INTO amh_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","7","እንደ ኃይሉ ሥራ እንደ ተሰጠኝም እንደ እግዚአብሔር ጸጋ ስጦታ መጠንየወንጌል አገልጋይ ሆንሁለት። ");
INSERT INTO amh_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","10","ብዙ ልዩ ልዩ የእግዚአብሔር ጥበብ አሁን በቤተ ክርስቲያን በኩል በሰማያዊ ስፍራ ውስጥ ላሉት አለቆችና ሥልጣናት ትታወቅ ዘንድ፤ ");
INSERT INTO amh_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","ይህም በክርስቶስ ኢየሱስ በጌታችን የፈጸመው የዘላለም አሳብ ነበረ፥ ");
INSERT INTO amh_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","በእርሱም ዘንድ ባለ እምነታችን በኩል በመታመን ድፍረትና መግባት በእርሱ አለን። ");
INSERT INTO amh_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","ስለዚህ ስለ እናንተ ስላለ መከራዬ እንዳትታክቱ እለምናችኋለሁ፥ ክብራችሁ ነውና። ");
INSERT INTO amh_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","20","እንግዲህ በእኛ እንደሚሠራው ኃይል መጠን ከምንለምነው ወይም ከምናስበው ሁሉ ይልቅ እጅግ አብልጦ ሊያደርግ ለሚቻለው፥ ");
INSERT INTO amh_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","ለእርሱ በቤተ ክርስቲያን በክርስቶስ ኢየሱስ እስከ ትውልዶች ሁሉ ከዘላለም እስከ ዘላለም ክብር ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","እንግዲህ በጌታ እስር የሆንሁ እኔ በተጠራችሁበት መጠራታችሁ እንደሚገባ ትመላለሱ ዘንድ እለምናችኋለሁ፤ ");
INSERT INTO amh_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","በትሕትና ሁሉና በየዋህነት በትዕግሥትም፤ እርስ በርሳችሁ በፍቅር ታገሡ፤ ");
INSERT INTO amh_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","በሰላም ማሰሪያ የመንፈስን አንድነት ለመጠበቅ ትጉ። ");
INSERT INTO amh_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","በመጠራታችሁ በአንድ ተስፋ እንደ ተጠራችሁ አንድ አካልና አንድ መንፈስ አለ፤ ");
INSERT INTO amh_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","አንድ ጌታ አንድ ሃይማኖት አንዲት ጥምቀት፤ ");
INSERT INTO amh_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","ከሁሉ በላይ የሚሆን በሁሉም የሚሠራ በሁሉም የሚኖር አንድ አምላክ የሁሉም አባት አለ። ");
INSERT INTO amh_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","ነገር ግን እንደ ክርስቶስ ስጦታ መጠን ለእያንዳንዳችን ጸጋ ተሰጠን። ");
INSERT INTO amh_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","ስለዚህ። ወደ ላይ በወጣ ጊዜ ምርኮን ማረከ ለሰዎችም ስጦታን ሰጠ ይላል። ");
INSERT INTO amh_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","ወደ ምድር ታችኛ ክፍል ደግሞ ወረደ ማለት ካልሆነ፥ ይህ ወጣ ማለትስ ምን ማለት ነው? ");
INSERT INTO amh_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","ይህ የወረደው ሁሉን ይሞላ ዘንድ ከሰማያት ሁሉ በላይ የወጣው ደግሞ ያው ነው። ");
INSERT INTO amh_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","እርሱም አንዳንዶቹ ሐዋርያት፥ ሌሎቹም ነቢያት፥ ሌሎቹም ወንጌልን ሰባኪዎች፥ ሌሎቹም እረኞችና አስተማሪዎች እንዲሆኑ ሰጠ፤ ");
INSERT INTO amh_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","14","እንደ ስሕተት ሽንገላ ባለ ተንኮል በሰዎችም ማታለል ምክንያት በትምህርት ነፋስ ሁሉ እየተፍገመገምን ወዲያና ወዲህም እየተንሳፈፍን ሕፃናት መሆን ወደ ፊት አይገባንም፥ ");
INSERT INTO amh_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","ነገር ግን እውነትን በፍቅር እየያዝን በነገር ሁሉ ወደ እርሱ ራስ ወደሚሆን ወደ ክርስቶስ እንደግ፤ ");
INSERT INTO amh_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","ከእርሱም የተነሣ አካል ሁሉ እያንዳንዱ ክፍል በልክ እንደሚሠራ፥ በተሰጠለት በጅማት ሁሉ እየተጋጠመና እየተያያዘ፥ ራሱን በፍቅር ለማነጽ አካሉን ያሳድጋል። ");
INSERT INTO amh_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","እንግዲህ አሕዛብ ደግሞ በአእምሮአቸው ከንቱነት እንደሚመላለሱ ከእንግዲህ ወዲህ እንዳትመላለሱ እላለሁ በጌታም ሆኜ እመሰክራለሁ። ");
INSERT INTO amh_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","እነርሱ ባለማወቃቸው ጠንቅ በልባቸውም ደንዳንነት ጠንቅ ልቡናቸው ጨለመ፥ ከእግዚአብሔርም ሕይወት ራቁ፤ ");
INSERT INTO amh_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","ደንዝዘውም በመመኘት ርኵሰትን ሁሉ ለማድረግ ራሳቸውን ወደ ሴሰኝነት አሳልፈው ሰጡ። ");
INSERT INTO amh_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","እናንተ ግን ክርስቶስን እንደዚህ አልተማራችሁም፤ ");
INSERT INTO amh_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","በእርግጥ ሰምታችሁታልና፥ እውነትም በኢየሱስ እንዳለ በእርሱ ተምራችኋል፤ ");
INSERT INTO amh_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","ፊተኛ ኑሮአችሁን እያሰባችሁ እንደሚያታልል ምኞት የሚጠፋውን አሮጌውን ሰው አስወግዱ፥ ");
INSERT INTO amh_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","በአእምሮአችሁም መንፈስ ታደሱ፥ ");
INSERT INTO amh_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","ለእውነትም በሚሆኑ ጽድቅና ቅድስና እንደ እግዚአብሔር ምሳሌ የተፈጠረውን አዲሱን ሰው ልበሱ። ");
INSERT INTO amh_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","ስለዚህ ውሸትን አስወግዳችሁ፥ እርስ በርሳችን ብልቶች ሆነናልና እያንዳንዳችሁ ከባልንጀሮቻችሁ ጋር እውነትን ተነጋገሩ። ");
INSERT INTO amh_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","ተቆጡ ኃጢአትንም አታድርጉ፤ ");
INSERT INTO amh_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","በቁጣችሁ ላይ ፀሐይ አይግባ፥ ለዲያብሎስም ፈንታ አትስጡት። ");
INSERT INTO amh_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","የሰረቀ ከእንግዲህ ወዲህ አይስረቅ፥ ነገር ግን በዚያ ፈንታ ለጎደለው የሚያካፍለው እንዲኖርለት በገዛ እጆቹ መልካምን እየሠራ ይድከም። ");
INSERT INTO amh_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","ለሚሰሙት ጸጋን ይሰጥ ዘንድ፥ እንደሚያስፈልግ ለማነጽ የሚጠቅም ማናቸውም በጎ ቃል እንጂ ክፉ ቃል ከአፋችሁ ከቶ አይውጣ። ");
INSERT INTO amh_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","ለቤዛም ቀን የታተማችሁበትን ቅዱሱን የእግዚአብሔርን መንፈስ አታሳዝኑ። ");
INSERT INTO amh_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","መራርነትና ንዴት ቁጣም ጩኸትም መሳደብም ሁሉ ከክፋት ሁሉ ጋር ከእናንተ ዘንድ ይወገድ። ");
INSERT INTO amh_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","እርስ በርሳችሁም ቸሮችና ርኅሩኆች ሁኑ፥ እግዚአብሔርም ደግሞ በክርስቶስ ይቅር እንዳላችሁ ይቅር ተባባሉ። ");
INSERT INTO amh_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","እንግዲህ እንደ ተወደዱ ልጆች እግዚአብሔርን የምትከተሉ ሁኑ፥ ");
INSERT INTO amh_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","ክርስቶስም ደግሞ እንደ ወደዳችሁ ለእግዚአብሔርም የመዓዛ ሽታ የሚሆንን መባንና መሥዋዕትን አድርጎ ስለ እናንተ ራሱን አሳልፎ እንደ ሰጠ በፍቅር ተመላለሱ። ");
INSERT INTO amh_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","ለቅዱሳን እንደሚገባ ግን ዝሙትና ርኵሰት ሁሉ ወይም መመኘት በእናንተ ዘንድ ከቶ አይሰማ፤ ");
INSERT INTO amh_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","የሚያሳፍር ነገርም የስንፍና ንግግርም ወይም ዋዛ የማይገቡ ናቸውና አይሁኑ፥ ይልቁን ምስጋና እንጂ። ");
INSERT INTO amh_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","ይህን እወቁ፤ አመንዝራም ቢሆን ወይም ርኵስ ወይም የሚመኝ እርሱም ጣዖትን የሚያመልክ በክርስቶስና በእግዚአብሔር መንግሥት ርስት የለውም። ");
INSERT INTO amh_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","ከዚህ የተነሣ በማይታዘዙት ልጆች ላይ የእግዚአብሔር ቁጣ ይመጣልና ማንም በከንቱ ንግግር አያታልላችሁ። ");
INSERT INTO amh_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","እንግዲህ ከእነርሱ ጋር ተካፋዮች አትሁኑ፤ ");
INSERT INTO amh_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","ቀድሞ ጨለማ ነበራችሁና፥ አሁን ግን በጌታ ብርሃን ናችሁ፤ ");
INSERT INTO amh_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","11","ፍሬም ከሌለው ከጨለማ ሥራ ጋር አትተባበሩ፥ ይልቁን ግለጡት እንጂ፥ ");
INSERT INTO amh_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","እነርሱ በስውር ስለሚያደርጉት መናገር እንኳ ነውር ነውና፤ ");
INSERT INTO amh_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","ሁሉ ግን በብርሃን ሲገለጥ ይታያል፤ የሚታየው ሁሉ ብርሃን ነውና። ");
INSERT INTO amh_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","ስለዚህ። አንተ የምትተኛ ንቃ ከሙታንም ተነሣ ክርስቶስም ያበራልሃል ይላል። ");
INSERT INTO amh_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","እንግዲህ እንደ ጥበበኞች እንጂ ጥበብ እንደሌላቸው ሳይሆን እንዴት እንድትመላለሱ በጥንቃቄ ተጠበቁ፤ ");
INSERT INTO amh_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","ቀኖቹ ክፉዎች ናቸውና ዘመኑን ዋጁ። ");
INSERT INTO amh_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","ስለዚህ የጌታ ፈቃድ ምን እንደ ሆነ አስተውሉ እንጂ ሞኞች አትሁኑ። ");
INSERT INTO amh_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","መንፈስ ይሙላባችሁ እንጂ በወይን ጠጅ አትስከሩ ይህ ማባከን ነውና፤ ");
INSERT INTO amh_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","በመዝሙርና በዝማሬ በመንፈሳዊም ቅኔ እርስ በርሳችሁ ተነጋገሩ፤ ለጌታ በልባችሁ ተቀኙና ዘምሩ፤ ");
INSERT INTO amh_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","ሁልጊዜ ስለ ሁሉ በጌታችን በኢየሱስ ክርስቶስ ስም አምላካችንንና አባታችንን ስለ ሁሉ አመስግኑ። ");
INSERT INTO amh_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","ለእያንዳንዳችሁ በክርስቶስ ፍርሃት የተገዛችሁ ሁኑ። ");
INSERT INTO amh_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","ሚስቶች ሆይ፥ ለጌታ እንደምትገዙ ለባሎቻችሁ ተገዙ፤ ");
INSERT INTO amh_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","ክርስቶስ ደግሞ የቤተ ክርስቲያን ራስ እንደ ሆነ እርሱም አካሉን የሚያድን እንደ ሆነ ባል የሚስት ራስ ነውና። ");
INSERT INTO amh_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","ዳሩ ግን ቤተ ክርስቲያን ለክርስቶስ እንደምትገዛ እንዲሁ ሚስቶች ደግሞ በሁሉ ለባሎቻቸው ይገዙ። ");
INSERT INTO amh_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","27","እድፈት ወይም የፊት መጨማደድ ወይም እንዲህ ያለ ነገር ሳይሆንባት ቅድስትና ያለ ነውር ትሆን ዘንድ ክብርት የሆነችን ቤተ ክርስቲያን ለራሱ እንዲያቀርብ ፈለገ። ");
INSERT INTO amh_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","እንዲሁም ባሎች ደግሞ እንደ ገዛ ሥጋቸው አድርገው የገዛ ሚስቶቻቸውን ሊወዱአቸው ይገባቸዋል። የገዛ ሚስቱን የሚወድ ራሱን ይወዳል፤ ");
INSERT INTO amh_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","31","ስለዚህ ሰው አባቱንና እናቱን ይተዋል ከሚስቱም ጋር ይተባበራል ሁለቱም አንድ ሥጋ ይሆናሉ። ");
INSERT INTO amh_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","ይህ ምሥጢር ታላቅ ነው፥ እኔ ግን ይህን ስለ ክርስቶስና ስለ ቤተ ክርስቲያን እላለሁ። ");
INSERT INTO amh_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","ሆኖም ከእናንተ ደግሞ እያንዳንዱ የገዛ ሚስቱን እንዲህ እንደ ራሱ አድርጎ ይውደዳት፥ ሚስቱም ባልዋን ትፍራ። ");
INSERT INTO amh_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","ልጆች ሆይ፥ ለወላጆቻችሁ በጌታ ታዘዙ፥ ይህ የሚገባ ነውና። ");
INSERT INTO amh_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","4","እናንተም አባቶች ሆይ፥ ልጆቻችሁን በጌታ ምክርና በተግሣጽ አሳድጉአቸው እንጂ አታስቆጡአቸው። ");
INSERT INTO amh_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","ባሪያዎች ሆይ፥ ለክርስቶስ እንደምትታዘዙ በፍርሃትና በመንቀጥቀጥ በልባችሁ ቅንነት በሥጋ ጌቶቻችሁ ለሆኑ ታዘዙ፤ ");
INSERT INTO amh_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","የእግዚአብሔርን ፈቃድ እንደሚያደርጉ እንደ ክርስቶስ ባሪያዎች እንጂ ለሰው ደስ እንደምታሰኙ ለታይታ የምትገዙ አትሁኑ። ");
INSERT INTO amh_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","ለሰው ሳይሆን ለጌታ እንደምትገዙ በትጋትና በበጎ ፈቃድ ተገዙ፤ ");
INSERT INTO amh_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","ባሪያ ቢሆን ወይም ጨዋ ሰው፥ እያንዳንዱ የሚያደርገውን መልካም ነገር ሁሉ ከጌታ በብድራት እንዲቀበለው ታውቃላችሁና። ");
INSERT INTO amh_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","እናንተም ጌቶች ሆይ፥ ዛቻውን ትታችሁ እንዲሁ አድርጉላቸው፥ በእነርሱና በእናንተ ላይ የሚገዛው ጌታ በሰማይ እንዳለ ለሰው ፊትም እንዳያደላ ታውቃላችሁና። ");
INSERT INTO amh_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","በቀረውስ በጌታና በኃይሉ ችሎት የበረታችሁ ሁኑ። ");
INSERT INTO amh_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","የዲያብሎስን ሽንገላ ትቃወሙ ዘንድ እንዲቻላችሁ የእግዚአብሔርን ዕቃ ጦር ሁሉ ልበሱ። ");
INSERT INTO amh_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","መጋደላችን ከደምና ከሥጋ ጋር አይደለምና፥ ከአለቆችና ከሥልጣናት ጋር ከዚህም ከጨለማ ዓለም ገዦች ጋር በሰማያዊም ስፍራ ካለ ከክፋት መንፈሳውያን ሠራዊት ጋር ነው እንጂ። ");
INSERT INTO amh_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","ስለዚህ በክፉው ቀን ለመቃወም፥ ሁሉንም ፈጽማችሁ ለመቆም እንድትችሉ የእግዚአብሔርን ዕቃ ጦር ሁሉ አንሡ። ");
INSERT INTO amh_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","16","በሁሉም ላይ ጨምራችሁ የሚንበለበሉትን የክፉውን ፍላጻዎች ሁሉ ልታጠፉ የምትችሉበትን የእምነትን ጋሻ አንሡ፤ ");
INSERT INTO amh_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","የመዳንንም ራስ ቁር የመንፈስንም ሰይፍ ያዙ እርሱም የእግዚአብሔር ቃል ነው። ");
INSERT INTO amh_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","በጸሎትና በልመናም ሁሉ ዘወትር በመንፈስ ጸልዩ፤ በዚህም አሳብ ስለ ቅዱሳን ሁሉ እየለመናችሁ በመጽናት ሁሉ ትጉ፤ ");
INSERT INTO amh_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","ደግሞ የወንጌልን ምሥጢር በግልጥ እንዳስታውቅ አፌን በመክፈት ቃል ይሰጠኝ ዘንድ ስለ እኔ ለምኑ፤ ");
INSERT INTO amh_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","ስለ ወንጌልም በሰንሰለት መልእክተኛ የሆንሁ፥ መናገር እንደሚገባኝ ስለ እርሱ በግልጥ እናገር ዘንድ ለምኑ። ");
INSERT INTO amh_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","ነገር ግን እናንተ ደግሞ እንዴት እንዳለሁ ኑሮዬን እንድታውቁ የተወደደ ወንድምና በጌታ የታመነ አገልጋይ ቲኪቆስ ሁሉን ያስታውቃችኋል፤ ");
INSERT INTO amh_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","ወሬአችንን እንድታውቁና ልባችሁን እንዲያጽናና ወደ እናንተ የምልከው ስለዚህ ምክንያት ነው። ");
INSERT INTO amh_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","ከእግዚአብሔር አብ ከጌታም ከኢየሱስ ክርስቶስ ሰላምና ፍቅር ከእምነት ጋር ለወንድሞች ይሁን። ");
INSERT INTO amh_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","ጌታችንን ኢየሱስ ክርስቶስን ባለመጥፋት ከሚወዱ ሁሉ ጋር ጸጋ ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","የኢየሱስ ክርስቶስ ባሪያዎች የሆኑ ጳውሎስና ጢሞቴዎስ በፊልጵስዩስ ለሚኖሩ ከኤጲስ ቆጶሳትና ከዲያቆናት ጋር በክርስቶስ ኢየሱስ ላሉት ቅዱሳን ሁሉ፤ ");
INSERT INTO amh_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","ከእግዚአብሔር ከአባታችን ከጌታም ከኢየሱስ ክርስቶስ ጸጋና ሰላም ለእናንተ ይሁን። ");
INSERT INTO amh_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","6","በእናንተ መልካምን ሥራ የጀመረው እስከ ኢየሱስ ክርስቶስ ቀን ድረስ እንዲፈጽመው ይህን ተረድቼአለሁና፤ ");
INSERT INTO amh_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","በእስራቴም ወንጌልንም መመከቻና መጽኛ በማድረግ ሁላችሁ ከእኔ ጋር በጸጋ ተካፋዮች ስለ ሆናችሁ፥ በልቤ ትኖራላችሁና ስለ ሁላችሁ ይህን ላስብ ይገባኛል። ");
INSERT INTO amh_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","በክርስቶስ ኢየሱስ ፍቅር ሁላችሁን እንዴት እንድናፍቃችሁ እግዚአብሔር ምስክሬ ነውና። ");
INSERT INTO amh_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","12","ነገር ግን፥ ወንድሞች ሆይ፥ ይህ የደረሰብኝ በእውነት ወንጌልን ለማስፋት እንደ ሆነ ታውቁ ዘንድ እወዳለሁ። ");
INSERT INTO amh_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","ስለዚህም እስራቴ ስለ ክርስቶስ እንዲሆን በንጉሥ ዘበኞች ሁሉና በሌሎች ሁሉ ዘንድ ተገልጦአል፥ ");
INSERT INTO amh_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","በጌታም ካሉት ወንድሞች የሚበዙት ስለ እስራቴ ታምነው የእግዚአብሔርን ቃል እንዲነግሩ ያለ ፍርሃት ከፊት ይልቅ ይደፍራሉ። ");
INSERT INTO amh_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","አንዳንዶች ከቅንአትና ከክርክር እንኳ ሌሎች ግን ከበጎ ፈቃድ የተነሣ ክርስቶስን ይሰብኩታል፤ ");
INSERT INTO amh_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","እነዚህ ወንጌልን መመከቻ ለማድረግ እንደ ተሾምሁ አውቀው በፍቅር ይሰብካሉ፥ ");
INSERT INTO amh_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","እነዚያ ግን በእስራቴ ላይ መከራን ሊያመጡብኝ መስሎአቸው፥ ለወገናቸው የሚጠቅም ፈልገው በቅን አሳብ ሳይሆኑ ስለ ክርስቶስ ያወራሉ። ");
INSERT INTO amh_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","ምን አለ? ቢሆንም በሁሉ ጎዳና፥ በማመካኘት ቢሆን ወይም በቅንነት ቢሆን፥ ክርስቶስ ይሰበካል ስለዚህም ደስ ብሎኛል። ");
INSERT INTO amh_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","ወደ ፊትም ደግሞ ደስ ይለኛል፤ ይህ በጸሎታችሁና በኢየሱስ ክርስቶስ መንፈስ መሰጠት ለመዳኔ እንዲሆንልኝ አውቃለሁና፥ ");
INSERT INTO amh_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","ይህ ናፍቆቴ ተስፋዬም ነውና፤ በአንድ ነገር እንኳ አላፍርም ነገር ግን በህይወት ብኖር ወይም ብሞት፥ ክርስቶስ በግልጥነት ሁሉ እንደ ወትሮው አሁን ደግሞ በስጋዬ ይከብራል። ");
INSERT INTO amh_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","ለእኔ ሕይወት ክርስቶስ፥ ሞትም ጥቅም ነውና። ");
INSERT INTO amh_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","ነገር ግን በስጋ መኖር ለእኔ የሥራ ፍሬ ቢሆን፥ ምን እንድመርጥ ኣላስታውቅም። ");
INSERT INTO amh_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","በእነዚህም በሁለቱ እጨነቃለሁ፤ ልሄድ ከክርስቶስም ጋር ልኖር እናፍቃለሁ፥ ከሁሉ ይልቅ እጅግ የሚሻል ነውና፤ ");
INSERT INTO amh_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","ነገር ግን በሥጋ መኖሬ ስለ እናንተ እጅግ የሚያስፈልግ ነው። ");
INSERT INTO amh_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","27","ይሁን እንጂ፥ መጥቼ ባያችሁ ወይም ብርቅ፥ በአንድ ልብ ስለ ወንጌል ሃይማኖት አብራችሁ እየተጋደላችሁ፥ በአንድ መንፈስ እንድትቆሙ ስለ ኑሮአችሁ እሰማ ዘንድ፥ ለክርስቶስ ወንጌል እንደሚገባ ኑሩ። ");
INSERT INTO amh_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","በአንድም ነገር እንኳ በተቃዋሚዎች አትደንግጡ፤ ይህም ለእነርሱ የጥፋት፥ ለእናንተ ግን የመዳን ምልክት ነው፥ ይህም ከእግዚአብሔር ነው፤ ");
INSERT INTO amh_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","ይህ ስለ ክርስቶስ ተሰጥቶአችኋልና፤ ስለ እርሱ መከራ ደግሞ ልትቀበሉ እንጂ በእርሱ ልታምኑ ብቻ አይደለም፤ ");
INSERT INTO amh_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","በእኔ ያያችሁት አሁንም በእኔ እንዳለ የምትሰሙት፥ ያው መጋደል ደርሶባችኋልና። ");
INSERT INTO amh_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","በክርስቶስም አንዳች ምክር ቢሆን፥ የፍቅር መጽናናት ቢሆን፥ የመንፈስ ኅብረት ቢሆን፥ ምሕረትና ርኅራኄ ቢሆኑ፥ ደስታዬን ፈጽሙልኝ፤ ");
INSERT INTO amh_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","በአንድ አሳብ ተስማሙ፥ አንድ ፍቅር አንድም ልብ አንድም አሳብ ይሁንላችሁ፤ ");
INSERT INTO amh_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","ለወገኔ ይጠቅማል በማለት ወይም በከንቱ ውዳሴ ምክንያት አንድ እንኳ አታድርጉ፥ ነገር ግን እያንዳንዱ ባልንጀራው ከራሱ ይልቅ እንዲሻል በትሕትና ይቍጠር፤ ");
INSERT INTO amh_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","እያንዳንዱ ለራሱ የሚጠቅመውን አይመልከት፥ ለባልንጀራው ደግሞ እንጂ። ");
INSERT INTO amh_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","በክርስቶስ ኢየሱስ የነበረ ይህ አሳብ በእናንተ ዘንድ ደግሞ ይሁን። ");
INSERT INTO amh_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","እርሱ በእግዚአብሔር መልክ ሲኖር ሳለ ከእግዚአብሔር ጋር መተካከልን መቀማት እንደሚገባ ነገር አልቈጠረውም፥ ");
INSERT INTO amh_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","ነገር ግን የባሪያን መልክ ይዞ በሰውም ምሳሌ ሆኖ ራሱን ባዶ አደረገ፥ ");
INSERT INTO amh_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","በምስሉም እንደ ሰው ተገኝቶ ራሱን አዋረደ፥ ለሞትም ይኸውም የመስቀል ሞት እንኳ የታዘዘ ሆነ። ");
INSERT INTO amh_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","በዚህ ምክንያት ደግሞ እግዚአብሔር ያለ ልክ ከፍ ከፍ አደረገው፥ ከስምም ሁሉ በላይ ያለውን ስም ሰጠው፤ ");
INSERT INTO amh_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","ይህም በሰማይና በምድር ከምድርም በታች ያሉት ሁሉ በኢየሱስ ስም ይንበረከኩ ዘንድ፥ ");
INSERT INTO amh_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","መላስም ሁሉ ለእግዚአብሔር አብ ክብር ኢየሱስ ክርስቶስ ጌታ እንደ ሆነ ይመሰክር ዘንድ ነው። ");
INSERT INTO amh_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","ስለዚህ፥ ወዳጆቼ ሆይ፥ ሁልጊዜ እንደ ታዘዛችሁ፥ በእናንተ ዘንድ በመኖሬ ብቻ ሳይሆን ይልቁን አሁን ስርቅ፥ በፍርሃትና በመንቀጥቀጥ የራሳችሁን መዳን ፈጽሙ፤ ");
INSERT INTO amh_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","ስለ በጎ ፈቃዱ መፈለግንም ማድረግንም በእናንተ የሚሠራ እግዚአብሔር ነውና። ");
INSERT INTO amh_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","16","በእነርሱም መካከል የሕይወትን ቃል እያቀረባችሁ በዓለም እንደ ብርሃን ትታያላችሁ፥ ስለዚህም በከንቱ እንዳልሮጥሁ በከንቱም እንዳልደከምሁ በክርስቶስ ቀን የምመካበት ይሆንልኛል። ");
INSERT INTO amh_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","ነገር ግን በእምነታችሁ መሥዋዕትና አገልግሎት ተጨምሬ ሕይወቴ እንኳ ቢፈስ፥ ደስ ብሎኛል፤ ከሁላችሁም ጋር አብሬ ደስ ብሎኛል፤ ");
INSERT INTO amh_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","እናንተም ደግሞ እንዲሁ ደስ ይበላችሁ ከእኔም ጋር አብራችሁ ደስ ይበላችሁ። ");
INSERT INTO amh_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","ነገር ግን ኑሮአችሁን ሳውቅ እኔ ደግሞ ደስ እንዲለኝ ፈጥኜ ጢሞቴዎስን ልልክላችሁ በጌታ በኢየሱስ ተስፋ አደርጋለሁ። ");
INSERT INTO amh_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","እንደ እርሱ ያለ፥ ስለ ኑሮአችሁ በቅንነት የሚጨነቅ፥ ማንም የለኝምና፤ ");
INSERT INTO amh_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","ሁሉ የራሳቸውን ይፈልጋሉና፥ የክርስቶስ ኢየሱስን አይደለም። ");
INSERT INTO amh_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","ነገር ግን ልጅ ለአባቱ እንደ ሚያገለግል ከእኔ ጋር ሆኖ ለወንጌል እንደ አገለገለ መፈተኑን ታውቃላችሁ። ");
INSERT INTO amh_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","እንግዲህ እንዴት እንደምሆን ባየሁ ጊዜ፥ እርሱን ቶሎ እንድልክ ተስፋ አደርጋለሁ፤ ");
INSERT INTO amh_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","ራሴ ደግሞ ግን ፈጥኜ እንድመጣ በጌታ ታምኜአለሁ። ");
INSERT INTO amh_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","ነገር ግን ወንድሜንና ከእኔ ጋር አብሮ ሠራተኛ ወታደርም የሚሆነውን፥ የእናንተ ግን መልእክተኛ የሆነውና የሚያስፈልገኝን የሚያገለግለውን አፍሮዲጡን እንድልክላችሁ በግድ አስባለሁ፤ ");
INSERT INTO amh_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","ሁላችሁን ይናፍቃልና፥ እንደ ታመመም ስለ ሰማችሁ ይተክዛል። ");
INSERT INTO amh_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","በእውነት ታሞ ለሞት እንኳ ቀርቦ ነበርና፤ ነገር ግን እግዚአብሔር ማረው፥ ኀዘን በኀዘን ላይ እንዳይጨመርብኝ ለእኔ ደግሞ እንጂ ለእርሱ ብቻ አይደለም። ");
INSERT INTO amh_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","እንግዲህ እንደ ገና ስታዩት ደስ እንዲላችሁ ለእኔም ኀዘኔ እንዲቃለል በብዙ ፍጥነት እልከዋለሁ። ");
INSERT INTO amh_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","እንግዲህ በሙሉ ደስታ በጌታ ተቀበሉት፥ እርሱን የሚመስሉትንም አክብሩአቸው፤ ");
INSERT INTO amh_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","በእኔ ዘንድ ካላችሁ አገልግሎት እናንተ ስለሌላችሁ የጎደለኝን እንዲፈጽም፥ በነፍሱ ተወራርዶ ከጌታ ሥራ የተነሣ እስከ ሞት ቀርቦአልና። ");
INSERT INTO amh_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","በቀረውስ፥ ወንድሞቼ ሆይ፥ በጌታ ደስ ይበላችሁ። ስለ አንድ ነገር መልሼ ልጽፍላችሁ እኔን አይታክተኝም ለእናንተ ግን ደኅና ነው። ");
INSERT INTO amh_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","ከውሾች ተጠበቁ፥ ከክፉዎችም ሠራተኞች ተጠበቁ፥ ከሐሰተኛም መገረዝ ተጠበቁ። ");
INSERT INTO amh_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","እኛ በመንፈስ እግዚአብሔርን የምናመልክ በክርስቶስ ኢየሱስም የምንመካ በሥጋም የማንታመን እኛ የተገረዝን ነንና። ");
INSERT INTO amh_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","እኔ ግን በሥጋ ደግሞ የምታመንበት አለኝ። ሌላ ሰው ማንም ቢሆን በሥጋ የሚታመንበት እንዳለው ቢመስለው፥ እኔ እበልጠዋለሁ። ");
INSERT INTO amh_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","በስምንተኛው ቀን የተገረዝሁ፥ ከእስራኤል ትውልድ፥ ከብንያም ወገን፥ ከዕብራውያን ዕብራዊ ነኝ፤ ስለ ሕግ ብትጠይቁ፥ ፈሪሳዊ ነበርሁ፤ ");
INSERT INTO amh_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","ስለ ቅንዓት ብትጠይቁ፥ ቤተ ክርስቲያንን አሳዳጅ ነበርሁ፤ በሕግ ስለሚገኝ ጽድቅ ብትጠይቁ፥ ያለ ነቀፋ ነበርሁ። ");
INSERT INTO amh_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","ነገር ግን ለእኔ ረብ የነበረውን ሁሉ ስለ ክርስቶስ እንደ ጉዳት ቈጥሬዋለሁ። ");
INSERT INTO amh_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","12","አሁን እንዳገኘሁ ወይም አሁን ፍጹም እንደ ሆንሁ አይደለም፥ ነገር ግን ስለ እርሱ በክርስቶስ ኢየሱስ የተያዝሁበትን ያን ደግሞ እይዛለሁ ብዬ እፈጥናለሁ። ");
INSERT INTO amh_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","ወንድሞች ሆይ፥ እኔ ገና እንዳልያዝሁት እቈጥራለሁ፤ ነገር ግን አንድ ነገር አደርጋለሁ፤ በኋላዬ ያለውን እየረሳሁ በፊቴ ያለውን ለመያዝ እዘረጋለሁ፥ ");
INSERT INTO amh_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","በክርስቶስ ኢየሱስ ከፍ ከፍ ያለውን የእግዚአብሔርን መጥራት ዋጋ እንዳገኝ ምልክትን እፈጥናለሁ። ");
INSERT INTO amh_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","እንግዲህ ፍጹማን የሆንን ሁላችን ይህን እናስብ፤ በአንዳች ነገርም ልዩ አሳብ ቢኖራችሁ፥ እግዚአብሔር ይህን ደግሞ ይገልጥላችኋል፤ ");
INSERT INTO amh_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","ሆኖም በደረስንበት በዚያ እንመላለስ። ");
INSERT INTO amh_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","ወንድሞች ሆይ፥ እኔን የምትመስሉ ሁኑ፥ እኛም እንደ ምሳሌ እንደምንሆንላችሁ፥ እንዲሁ የሚመላለሱትን ተመልከቱ። ");
INSERT INTO amh_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","ብዙዎች ለክርስቶስ መስቀል ጠላቶቹ ሆነው ይመላለሳሉና፤ ብዙ ጊዜ ስለ እነርሱ አልኋችሁ፥ አሁንም እንኳ እያለቀስሁ እላለሁ። ");
INSERT INTO amh_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","መጨረሻቸው ጥፋት ነው፥ ሆዳቸው አምላካቸው ነው፥ ክብራቸው በነውራቸው ነው፥ አሳባቸው ምድራዊ ነው። ");
INSERT INTO amh_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","እኛ አገራችን በሰማይ ነውና፥ ከዚያም ደግሞ የሚመጣ መድኃኒትን እርሱንም ጌታን ኢየሱስ ክርስቶስን እንጠባበቃለን፤ ");
INSERT INTO amh_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","እርሱም ሁሉን እንኳ ለራሱ ሊያስገዛ እንደሚችልበት አሠራር፥ ክቡር ሥጋውን እንዲመስል የተዋረደውን ሥጋችንን ይለውጣል። ");
INSERT INTO amh_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","ስለዚህ፥ የምወዳችሁና የምናፍቃችሁ፥ ደስታዬና አክሊሌ የምትሆኑ ወንድሞቼ ሆይ፥ እንዲሁ በጌታ ቁሙ፥ ወዳጆች ሆይ። ");
INSERT INTO amh_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","በአንድ አሳብ በጌታ እንዲስማሙ ኤዎድያንን እመክራለሁ ሲንጤኪንንም እመክራለሁ። ");
INSERT INTO amh_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","አንተም ደግሞ በሥራዬ አብረህ የተጠመድህ እውነተኛ ሆይ፥ እንድታግዛቸው እለምንሃለሁ፤ ስሞቻቸው በሕይወት መጽሐፍ ከተጻፉት ከቀሌምንጦስና ደግሞ ከእኔ ጋር አብረው ከሠሩት ከሌሎቹ ጋር በወንጌል ከእኔ ጋር አብረው ተጋድለዋልና። ");
INSERT INTO amh_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","ሁልጊዜ በጌታ ደስ ይበላችሁ፤ ደግሜ እላለሁ፥ ደስ ይበላችሁ። ");
INSERT INTO amh_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","ገርነታችሁ ለሰው ሁሉ ይታወቅ። ");
INSERT INTO amh_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","ጌታ ቅርብ ነው። በነገር ሁሉ በጸሎትና በምልጃ ከምስጋና ጋር በእግዚአብሔር ዘንድ ልመናችሁን አስታውቁ እንጂ በአንዳች አትጨነቁ። ");
INSERT INTO amh_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","አእምሮንም ሁሉ የሚያልፍ የእግዚአብሔር ሰላም ልባችሁንና አሳባችሁን በክርስቶስ ኢየሱስ ይጠብቃል። ");
INSERT INTO amh_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","በቀረውስ፥ ወንድሞች ሆይ፥ እውነተኛ የሆነውን ነገር ሁሉ፥ ጭምትነት ያለበትን ነገር ሁሉ፥ ጽድቅ የሆነውን ነገር ሁሉ፥ ንጹሕ የሆነውን ነገር ሁሉ፥ ፍቅር ያለበትን ነገር ሁሉ፥ መልካም ወሬ ያለበትን ነገር ሁሉ፥ በጎነት ቢሆን ምስጋናም ቢሆን፥ እነዚህን አስቡ፤ ");
INSERT INTO amh_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","ከእኔ የተማራችሁትንና የተቀበላችሁትን የሰማችሁትንም ያያችሁትንም እነዚህን አድርጉ፤ የሰላምም አምላክ ከእናንተ ጋር ይሆናል። ");
INSERT INTO amh_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","ነገር ግን አሁን ከጊዜ በኋላ ስለ እኔ እንደ ገና ልታስቡ ስለ ጀመራችሁ፥ በጌታ እጅግ ደስ ይለኛል፤ ጊዜ አጣችሁ እንጂ፥ ማሰብስ ታስቡ ነበር። ");
INSERT INTO amh_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","ይህን ስል ስለ ጉድለት አልልም፤ የምኖርበት ኑሮ ይበቃኛል ማለትን ተምሬአለሁና። ");
INSERT INTO amh_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","መዋረድንም አውቃለሁ መብዛትንም አውቃለሁ፤ በእያንዳንዱ ነገር በነገርም ሁሉ መጥገብንና መራብንም መብዛትንና መጉደልን ተምሬአለሁ። ");
INSERT INTO amh_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","ኃይልን በሚሰጠኝ በክርስቶስ ሁሉን እችላለሁ። ");
INSERT INTO amh_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","ሆኖም በመከራዬ ከእኔ ጋር ስለ ተካፈላችሁ መልካም አደረጋችሁ። ");
INSERT INTO amh_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","የፊልጵስዩስ ሰዎች ሆይ፥ ወንጌል በመጀመሪያ ሲሰበክ፥ ከመቄዶንያ በወጣሁ ጊዜ፥ ከእናንተ ብቻ በቀር ሌላ ቤተ ክርስቲያን በመስጠትና በመቀበል ስሌት ከእኔ ጋር እንዳልተካፈለች እናንተ ደግሞ ታውቃላችሁ፤ ");
INSERT INTO amh_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","በተሰሎንቄ እንኳ ሳለሁ፥ አንድ ጊዜና ሁለት ጊዜ ያስፈለገኝን ሰዳችሁልኝ ነበርና። ");
INSERT INTO amh_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","በስሌታችሁ የሚበዛውን ፍሬ እንጂ ስጦታውን ፈላጊ አይደለሁም። ");
INSERT INTO amh_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","ነገር ግን ሁሉ አለኝ ይበዛልኝማል፤ የመዓዛ ሽታና የተወደደ መሥዋዕት የሚሆነውን ለእግዚአብሔርም ደስ የሚያሰኘውን ስጦታችሁን ከአፍሮዲጡ ተቀብዬ ተሞልቼአለሁ። ");
INSERT INTO amh_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","አምላኬም እንደ ባለ ጠግነቱ መጠን በክብር በክርስቶስ ኢየሱስ የሚያስፈልጋችሁን ሁሉ ይሞላባችኋል። ");
INSERT INTO amh_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","ለአምላካችንና ለአባታችንም እስከ ዘላለም ድረስ ክብር ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","ለቅዱሳን ሁሉ በክርስቶስ ኢየሱስ ሰላምታ አቅርቡ። ከእኔ ጋር ያሉቱ ወንድሞች ሰላምታ ያቀርቡላችኋል። ");
INSERT INTO amh_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","ቅዱሳን ሁሉ ይልቁንም ከቄሣር ቤት የሆኑቱ ሰላምታ ያቀርቡላችኋል። ");
INSERT INTO amh_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","የጌታችን የኢየሱስ ክርስቶስ ጸጋ ከመንፈሳችሁ ጋር ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","በእግዚአብሔር ፈቃድ የኢየሱስ ክርስቶስ ሐዋርያ የሆነ ጳውሎስ ጢሞቴዎስም ወንድሙ፥ ");
INSERT INTO amh_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","በቈላስይስ ለሚኖሩ ቅዱሳንና በክርስቶስ ለታመኑ ወንድሞች፤ ከእግዚአብሔር ከአባታችን ከጌታም ከኢየሱስ ክርስቶስ ጸጋና ሰላም ይሁን። ");
INSERT INTO amh_vpl VALUES ("CL1_3","081_1_3","COL","1","3","6","ይህም በዓለም ሁሉ ደግሞ እንዳለ ወደ እናንተ ደርሶአል፥ እግዚአብሔርንም ጸጋ በእውነት ከሰማችሁበትና ካወቃችሁበት ቀን ጀምሮ፥ በእናንተ ደግሞ እንዳለ እንዲህ በዓለም ፍሬ ያፈራል ያድግማል። ");
INSERT INTO amh_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","ከተወደደ ከእኛም ጋር አብሮ ባሪያ ከሆነው ከኤጳፍራ እንዲህ ተማራችሁ፥ እርሱም ስለ እናንተ ታማኝ የክርስቶስ አገልጋይ ነው። ");
INSERT INTO amh_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","ደግሞም በመንፈስ ስለሚሆን ስለ ፍቅራችሁ አስታወቀን። ");
INSERT INTO amh_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","ስለዚሁ እኛ ደግሞ ይህን ከሰማንበት ቀን ጀምረን የፈቃዱ እውቀት መንፈሳዊ ጥበብንና አእምሮን ሁሉ እንዲሞላባችሁ እየለመንን፥ ስለ እናንተ ጸሎትን አልተውንም። ");
INSERT INTO amh_vpl VALUES ("CL1_10","081_1_10","COL","1","10","12","ከደስታም ጋር በሁሉ ለመጽናትና ለመታገሥ እንደ ክብሩ ጉልበት መጠን በኃይል ሁሉ እየበረታችሁ፥ በቅዱሳንም ርስት በብርሃን እንድንካፈል ያበቃንን አብን እያመሰገናችሁ፥ በነገር ሁሉ ደስ ልታሰኙ ለጌታ እንደሚገባ ትመላለሱ ዘንድ እንለምናለን። ");
INSERT INTO amh_vpl VALUES ("CL1_13","081_1_13","COL","1","13","17","እርሱም ከሁሉ በፊት ነው ሁሉም በእርሱ ተጋጥሞአል። ");
INSERT INTO amh_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","እርሱም የአካሉ ማለት የቤተ ክርስቲያን ራስ ነው። እርሱም በሁሉ ፊተኛ ይሆን ዘንድ፥ መጀመሪያ ከሙታንም በኵር ነው። ");
INSERT INTO amh_vpl VALUES ("CL1_19","081_1_19","COL","1","19","23","ይህም፥ ተመሥርታችሁና ተደላድላችሁ ከሰማችሁትም ከወንጌል ተስፋ ሳትናወጡ፥ በሃይማኖት ጸንታችሁ ብትኖሩ ይሆናል። ያም ወንጌል ከሰማይ በታች ባለው ፍጥረት ሁሉ ዘንድ የተሰበከ ነው፥ እኔም ጳውሎስ የእርሱ አገልጋይ ሆንሁ። ");
INSERT INTO amh_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","አሁን በመከራዬ ስለ እናንተ ደስ ይለኛል፥ ስለ አካሉም ማለት ስለ ቤተ ክርስቲያን በሥጋዬ በክርስቶስ መከራ የጐደለውን እፈጽማለሁ። ");
INSERT INTO amh_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","ስለ እናንተ እንደ ተሰጠኝ እንደ እግዚአብሔር መጋቢነት፥ የእግዚአብሔርን ቃል ፈጽሜ እንድሰብክ እኔ የቤተ ክርስቲያን አገልጋይ ሆንሁ። ");
INSERT INTO amh_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","ይህም ቃል ከዘላለምና ከትውልዶች ጀምሮ ተሰውሮ የነበረ ምሥጢር ነው፥ አሁን ግን ለቅዱሳኑ ተገልጦአል። ");
INSERT INTO amh_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","ለእነርሱም እግዚአብሔር በአሕዛብ ዘንድ ያለው የዚህ ምሥጢር ክብር ባለ ጠግነት ምን እንደ ሆነ ሊያስታውቅ ወደደ፥ ምሥጢሩም የክብር ተስፋ ያለው ክርስቶስ በእናንተ ዘንድ መሆኑ ነው። ");
INSERT INTO amh_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","እኛም በክርስቶስ ፍጹም የሚሆን ሰውን ሁሉ እናቀርብ ዘንድ ሰውን ሁሉ እየገሠጽን ሰውንም ሁሉ በጥበብ ሁሉ እያስተማርን የምንሰብከው እርሱ ነው። ");
INSERT INTO amh_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","ለዚህም ነገር ደግሞ፥ በእኔ በኃይል እንደሚሠራ እንደ አሠራሩ እየተጋደልሁ፥ እደክማለሁ። ");
INSERT INTO amh_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","ስለ እናንተና በሎዶቅያ ስላሉት ፊቴንም በሥጋ ስላላዩት ሁሉ እንዴት ያለ ትልቅ መጋደል እንዳለኝ ልታውቁ እወዳለሁና። ");
INSERT INTO amh_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","ልባቸው እንዲጸናና፥ በፍቅርም ተባብረው በማስተዋል ወደሚገኝበት ወደ መረዳት ባለ ጠግነት ሁሉ እንዲደርሱ የእግዚአብሔርንም ምሥጢር እርሱንም ክርስቶስን እንዲያውቁ እጋደላለሁ። ");
INSERT INTO amh_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","የተሰወረ የጥበብና የእውቀት መዝገብ ሁሉ በእርሱ ነውና። ");
INSERT INTO amh_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","ማንም በሚያባብል ቃል እንዳያስታችሁ ይህን እላለሁ። ");
INSERT INTO amh_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","በሥጋ ምንም እንኳ ብርቅ፥ በመንፈስ ከእናንተ ጋር ነኝና፥ ሥርዓታችሁንም በክርስቶስም ያለውን የእምነታችሁን ጽናት እያየሁ ደስ ይለኛል። ");
INSERT INTO amh_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","እንግዲህ ጌታን ክርስቶስ ኢየሱስን እንደ ተቀበላችሁት በእርሱ ተመላለሱ። ");
INSERT INTO amh_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","ሥር ሰዳችሁ በእርሱ ታነጹ፥ እንደ ተማራችሁም በሃይማኖት ጽኑ፥ ምስጋናም ይብዛላችሁ። ");
INSERT INTO amh_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","እንደ ክርስቶስ ትምህርት ሳይሆን፥ እንደ ሰው ወግና እንደ ዓለማዊ እንደ መጀመሪያ ትምህርት ባለ በፍልስፍና በከንቱም መታለል ማንም እንዳይማርካችሁ ተጠበቁ። ");
INSERT INTO amh_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","በእርሱ የመለኮት ሙላት ሁሉ በሰውነት ተገልጦ ይኖራልና። ");
INSERT INTO amh_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","ለአለቅነትና ለሥልጣንም ሁሉ ራስ በሆነ በእርሱ ሆናችሁ ተሞልታችኋል። ");
INSERT INTO amh_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","የሥጋንም ሰውነት በመገፈፍ፥ በክርስቶስ መገረዝ፥ በእጅ ባልተደረገ መገረዝ በእርሱ ሆናችሁ ደግሞ ተገረዛችሁ። ");
INSERT INTO amh_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","በጥምቀትም ከእርሱ ጋር ተቀብራችሁ፥ በጥምቀት ደግሞ፥ ከሙታን ባስነሣው በእግዚአብሔር አሠራር በማመናችሁ፥ ከእርሱ ጋር ተነሣችሁ። ");
INSERT INTO amh_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","እናንተም በበደላችሁና ሥጋችሁን ባለመገረዝ ሙታን በሆናችሁ ጊዜ፥ ከእርሱ ጋር ሕይወትን ሰጣችሁ። በደላችሁን ሁሉ ይቅር አላችሁ። ");
INSERT INTO amh_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","በእኛ ላይ የነበረውን የሚቃወመንንም በትእዛዛት የተጻፈውን የዕዳ ጽሕፈት ደመሰሰው። እርሱንም በመስቀል ጠርቆ ከመንገድ አስወግዶታል። ");
INSERT INTO amh_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","አለቅነትንና ሥልጣናትን ገፎ፥ ድል በመንሣት በእርሱ እያዞራቸው በግልጥ አሳያቸው። ");
INSERT INTO amh_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","እንግዲህ በመብል ወይም በመጠጥ ወይም ስለ በዓል ወይም ስለ ወር መባቻ ወይም ስለ ሰንበት ማንም አይፍረድባችሁ። ");
INSERT INTO amh_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","እነዚህ ሊመጡ ያሉት ነገሮች ጥላ ናቸውና፥ አካሉ ግን የክርስቶስ ነው። ");
INSERT INTO amh_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","ትሕትናንና የመላእክትን አምልኮ እየወደደ፥ ባላየውም ያለ ፈቃድ እየገባ፥ በሥጋዊም አእምሮ በከንቱ እየታበየ ማንም አይፍረድባችሁ። ");
INSERT INTO amh_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","እንደዚህ ያለ ሰው ራስ ወደሚሆነው አይጠጋም፥ ከእርሱም አካል ሁሉ በጅማትና በማሰሪያ ምግብን እየተቀበለ እየተጋጠመም፥ እግዚአብሔር በሚሰጠው ማደግ ያድጋል። ");
INSERT INTO amh_vpl VALUES ("CL2_20","081_2_20","COL","2","20","22","እንደ ሰው ሥርዓትና ትምህርት። አትያዝ፥ አትቅመስ፥ አትንካ ለሚሉት ትእዛዛት በዓለም እንደምትኖሩ ስለ ምን ትገዛላችሁ? እነዚህ ሁሉ በመደረግ ሊጠፉ ተወስነዋልና። ");
INSERT INTO amh_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","ይህ እንደ ገዛ ፈቃድህ በማምለክና በትሕትና ሥጋንም በመጨቆን ጥበብ ያለው ይመስላል፥ ነገር ግን ሥጋ ያለ ልክ እንዳይጠግብ ለመከልከል ምንም አይጠቅምም። ");
INSERT INTO amh_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","እንግዲህ ከክርስቶስ ጋር ከተነሣችሁ፥ ክርስቶስ በእግዚአብሔር ቀኝ ተቀምጦ ባለበት በላይ ያለውን እሹ። ");
INSERT INTO amh_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","በላይ ያለውን አስቡ እንጂ በምድር ያለውን አይደለም። ");
INSERT INTO amh_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","ሞታችኋልና፥ ሕይወታችሁም በእግዚአብሔር ከክርስቶስ ጋር ተሰውሮአልና። ");
INSERT INTO amh_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","ሕይወታችሁ የሆነ ክርስቶስ በሚገለጥበት ጊዜ፥ በዚያን ጊዜ እናንተ ደግሞ ከእርሱ ጋር በክብር ትገለጣላችሁ። ");
INSERT INTO amh_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","እንግዲህ በምድር ያሉቱን ብልቶቻችሁን ግደሉ፥ እነዚህም ዝሙትና ርኵሰት ፍትወትም ክፉ ምኞትም ጣኦትንም ማምለክ የሆነ መጎምጀት ነው። ");
INSERT INTO amh_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","በእነዚህም ጠንቅ የእግዚአብሔር ቍጣ በማይታዘዙ ልጆች ላይ ይመጣል። ");
INSERT INTO amh_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","እናንተም ደግሞ ትኖሩባቸው በነበራችሁ ጊዜ፥ በፊት በእነዚህ ተመላለሳችሁ። ");
INSERT INTO amh_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","አሁን ግን እናንተ ደግሞ ቍጣንና ንዴትን ክፋትንም፥ ከአፋችሁም ስድብን የሚያሳፍርንም ንግግር እነዚህን ሁሉ አስወግዱ። ");
INSERT INTO amh_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","እርስ በርሳችሁ ውሸት አትነጋገሩ፥ አሮጌውን ሰው ከሥራው ጋር ገፋችሁታልና፥ ");
INSERT INTO amh_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","የፈጠረውንም ምሳሌ እንዲመስል እውቀትን ለማግኘት የሚታደሰውን አዲሱን ሰው ለብሳችሁታል። ");
INSERT INTO amh_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","በዚያም የግሪክ ሰው አይሁዳዊም የተገረዘም ያልተገረዘም አረማዊም እስኩቴስም ባሪያም ጨዋ ሰውም መሆን አልተቻለም፥ ነገር ግን ክርስቶስ ሁሉ ነው፥ በሁሉም ነው። ");
INSERT INTO amh_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","እንግዲህ እንደ እግዚአብሔር ምርጦች ቅዱሳን ሆናችሁ የተወደዳችሁም ሆናችሁ፥ ምሕረትን፥ ርኅራኄን፥ ቸርነትን፥ ትህትናን፥ የዋህነትን፥ ትዕግሥትን ልበሱ። ");
INSERT INTO amh_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","እርስ በርሳችሁ ትዕግሥትን አድርጉ፥ ማንም በባልንጀራው ላይ የሚነቅፈው ነገር ካለው፥ ይቅር ተባባሉ። ክርስቶስ ይቅር እንዳላችሁ እናንተ ደግሞ እንዲሁ አድርጉ። ");
INSERT INTO amh_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","በእነዚህም ሁሉ ላይ የፍጻሜ ማሰሪያ የሆነውን ፍቅርን ልበሱት። ");
INSERT INTO amh_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","በአንድ አካልም የተጠራችሁለት ደግሞ የክርስቶስ ሰላም በልባችሁ ይግዛ። የምታመሰግኑም ሁኑ። ");
INSERT INTO amh_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","የእግዚአብሔር ቃል በሙላት ይኑርባችሁ። በጥበብ ሁሉ እርስ በርሳችሁ አስተምሩና ገሥጹ። በመዝሙርና በዝማሬ በመንፈሳዊም ቅኔ በጸጋው በልባችሁ ለእግዚአብሔር ዘምሩ። ");
INSERT INTO amh_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","እግዚአብሔር አብን በእርሱ እያመሰገናችሁ፥ በቃል ቢሆን ወይም በሥራ የምታደርጉትን ሁሉ በጌታ በኢየሱስ ስም አድርጉት። ");
INSERT INTO amh_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","ሚስቶች ሆይ፥ በጌታ እንደሚገባ ለባሎቻችሁ ተገዙ። ");
INSERT INTO amh_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","ባሎች ሆይ፥ ሚስቶቻችሁን ውደዱ መራራም አትሁኑባቸው። ");
INSERT INTO amh_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","ልጆች ሆይ፥ ይህ ለጌታ ደስ የሚያሰኝ ነውና በሁሉ ለወላጆቻችሁ ታዘዙ። ");
INSERT INTO amh_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","አባቶች ሆይ፥ ልባቸው እንዳይዝል ልጆቻችሁን አታበሳጩአቸው። ");
INSERT INTO amh_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","ባሪያዎች ሆይ፥ በቅን ልብ ጌታን እየፈራችሁ እንጂ፥ ለሰው ደስ እንደምታሰኙ ለታይታ የምትገዙ ሳትሆኑ፥ በሥጋ ጌቶቻችሁ ለሆኑ በሁሉ ታዘዙ። ");
INSERT INTO amh_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","ለሰው ሳይሆን ለጌታ እንደምታደርጉ፥ የምታደርጉትን ሁሉ በትጋት አድርጉት፥ ");
INSERT INTO amh_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","ከጌታ የርስትን ብድራት እንድትቀበሉ ታውቃላችሁና። የምታገለግሉት ጌታ ክርስቶስ ነውና። ");
INSERT INTO amh_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","የሚበድልም የበደለውን በብድራት ይቀበላል፥ ለሰው ፊትም አድልዎ የለም። ");
INSERT INTO amh_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","ጌቶች ሆይ፥ እናንተ ደግሞ በሰማይ ጌታ እንዳላችሁ ታውቃላችሁና ለባሪያዎቻችሁ በጽድቅና በቅንነት አድርጉላቸው። ");
INSERT INTO amh_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","ከማመስገን ጋር በጸሎት እየነቃችሁ ለእርሱ ትጉ። ");
INSERT INTO amh_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","በዚያን ጊዜም ስለ እርሱ ደግሞ የታሰርሁበትን የክርስቶስን ምሥጢር እንድንነግር እግዚአብሔር የቃሉን ደጅ ይከፍትልን ዘንድ ስለ እኛ ደግሞ ጸልዩ። ");
INSERT INTO amh_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","ልናገር እንደሚገባኝ ያህል እገልጠው ዘንድ ጸልዩልኝ። ");
INSERT INTO amh_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","ዘመኑን እየዋጃችሁ፥ በውጭ ባሉቱ ዘንድ በጥበብ ተመላለሱ። ");
INSERT INTO amh_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","ለእያንዳንዱ እንዴት እንድትመልሱ እንደሚገባችሁ ታውቁ ዘንድ ንግግራችሁ ሁልጊዜ፥ በጨው እንደ ተቀመመ፥ በጸጋ ይሁን። ");
INSERT INTO amh_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","የተወደደ ወንድምና የታመነ አገልጋይ በጌታም አብሮኝ ባሪያ የሆነ ቲኪቆስ ኑሮዬን ሁሉ ያስታውቃችኋል። ");
INSERT INTO amh_vpl VALUES ("CL4_8","081_4_8","COL","4","8","12","ከእናንተ የሆነ የክርስቶስ ባሪያ ኤጳፍራ ሰላምታ ያቀርብላችኋል። በእግዚአብሔር ፈቃድ ሁሉ ተረድታችሁና ፍጹማን ሆናችሁ እንድትቆሙ፥ ሁልጊዜ ስለ እናንተ በጸሎቱ ይጋደላል። ");
INSERT INTO amh_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","ስለ እናንተ በሎዶቅያም በኢያራ ከተማም ስላሉቱ እጅግ እንዲቀና እመሰክርለታለሁና። ");
INSERT INTO amh_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","የተወደደው ባለ መድኃኒቱ ሉቃስ ዴማስም ሰላምታ ያቀርቡላችኋል። ");
INSERT INTO amh_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","በሎዶቅያ ላሉቱ ወንድሞችና ለንምፉን በቤቱም ላለች ቤተ ክርስቲያን ሰላምታ አቅርቡልን። ");
INSERT INTO amh_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","ይህችም መልእክት በእናንተ ዘንድ ከተነበበች በኋላ፥ በሎዶቅያ ሰዎች ማኅበር ደግሞ እንድትነበብ አድርጉ። ከሎዶቅያም የምትገኘውን መልእክት እናንተ ደግሞ አንብቡ። ");
INSERT INTO amh_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","ለአክሪጳም። በጌታ የተቀበልኸውን አገልግሎት እንድትፈጽሙው ተጠንቀቅ በሉልኝ። ");
INSERT INTO amh_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","በገዛ እጄ የተጻፈ የእኔ የጳውሎስ ሰላምታ ይህ ነው። እስራቴን አስቡ። ጸጋ ከእናንተ ጋር ይሁን። ");
INSERT INTO amh_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","ጳውሎስና ስልዋኖስ ጢሞቴዎስም፥ በእግዚአብሔር አብ በጌታ በኢየሱስ ክርስቶስም ወደምትሆን ወደ ተሰሎንቄ ሰዎች ቤተ ክርስቲያን፤ ከእግዚአብሔር ከአባታችን ከጌታ ከኢየሱስ ክርስቶስም ጸጋ ሰላምም ለእናንተ ይሁን። ");
INSERT INTO amh_vpl VALUES ("H11_2","082_1_2","1TH","1","2","4","በእግዚአብሔር የምትወደዱ ወንድሞች ሆይ፥ እንደ ተመረጣችሁ አውቀናልና። ");
INSERT INTO amh_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","ወንጌላችን በኃይልና በመንፈስ ቅዱስ በብዙ መረዳትም እንጂ በቃል ብቻ ወደ እናንተ አልመጣምና፤ በእናንተ ዘንድ ስለ እናንተ እንዴት እንደ ነበርን ታውቃላችሁ። ");
INSERT INTO amh_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","ደግሞ እናንተ ቃሉን በብዙ መከራ ከመንፈስ ቅዱስ ደስታ ጋር ተቀብላችሁ፥ እኛንና ጌታን የምትመስሉ ሆናችሁ፤ ");
INSERT INTO amh_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","ስለዚህም በመቄዶንያና በአካይያ ላሉት ምእመናን ሁሉ ምሳሌ ሆናችሁላቸው። ");
INSERT INTO amh_vpl VALUES ("H11_8","082_1_8","1TH","1","8","10","ከእናንተ ወጥቶ የጌታ ቃል በመቄዶንያና በአካይያ ብቻ አልተሰማምና፥ ነገር ግን ምንም እንድንናገር እስከማያስፈልግ ድረስ፥ በእግዚአብሔር ዘንድ የሚሆን እምነታችሁ በሁሉ ስፍራ ተወርቶአል። ");
INSERT INTO amh_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","ወንድሞች ሆይ፥ ራሳችሁ ወደ እናንተ መግባታችን ከንቱ እንዳልሆነ ታውቃላችሁና። ");
INSERT INTO amh_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","ነገር ግን እንደምታውቁት በፊልጵስዩስ አስቀድመን መከራ ተቀብለን ተንገላትተንም፥ በብዙ ገድል የእግዚአብሔርን ወንጌል ለእናንተ እንናገር ዘንድ በአምላካችን ደፈርን። ");
INSERT INTO amh_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","ልመናችን ከስሕተት ወይም ከርኵሰት ወይም ከተንኰል አልነበረምና፤ ");
INSERT INTO amh_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","ነገር ግን ወንጌልን አደራ ይሰጠን ዘንድ እግዚአብሔር የታመንን ሆነን እንዳገኘን መጠን፥ እንዲሁ እንናገራለን፥ ልባችንን የሚመረምር እግዚአብሔርን እንጂ ሰውን ደስ እንደምናሰኝ አይደለም። ");
INSERT INTO amh_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","እንደምታውቁ፥ እያቈላመጥን ከቶ አልተናገርንም፥ እግዚአብሔርም እንደሚመሰክር እያመካኘን በመጐምጀት አልሠራንም፤ ");
INSERT INTO amh_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","የክርስቶስም ሐዋርያት እንደ መሆናችን ልንከብድባችሁ ስንችል፥ ከእናንተ ቢሆን ወይም ከሌሎች ክብርን ከሰው አልፈለግንም። ");
INSERT INTO amh_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","ነገር ግን ሞግዚት የራስዋን ልጆች እንደምትከባከብ፥ በመካከላችሁ የዋሆች ሆንን፤ ");
INSERT INTO amh_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","እንዲሁም እያፈቀርናችሁ የእግዚአብሔርን ወንጌል ለማካፈል ብቻ ሳይሆን የገዛ ነፍሳችንን ደግሞ እናካፍላችሁ ዘንድ በጎ ፈቃዳችን ነበረ፥ ለእኛ የተወደዳችሁ ሆናችሁ ነበርና። ");
INSERT INTO amh_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","ወንድሞች ሆይ፥ ድካማችንና ጥረታችን ትዝ ይላችኋልና፤ ከእናንተ በአንዱ ስንኳ እንዳንከብድበት ሌሊትና ቀን እየሠራን፥ የእግዚአብሔርን ወንጌል ለእናንተ ሰበክን። ");
INSERT INTO amh_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","በእናንተ በምታምኑ ዘንድ በእንዴት ያለ ቅድስናና ጽድቅ ነቀፋም በሌለበት ኑሮ እንደ ሄድን፥ እናንተና እግዚአብሔር ምስክሮች ናችሁ፤ ");
INSERT INTO amh_vpl VALUES ("H12_11","082_2_11","1TH","2","11","13","ስለዚህም የመልእክትን ቃል እርሱም የእግዚአብሔር ቃል ከእኛ በተቀበላችሁ ጊዜ፥ በእውነት እንዳለ በእናንተ በምታምኑ ደግሞ እንደሚሠራ እንደ እግዚአብሔር ቃል እንጂ እንደ ሰው ቃል አድርጋችሁ ስላልተቀበላችሁት፥ እኛ ደግሞ እግዚአብሔርን ሳናቋርጥ እናመሰግናለን። ");
INSERT INTO amh_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","እናንተ፥ ወንድሞች ሆይ፥ በይሁዳ የሚኖሩትን በክርስቶስ ኢየሱስ ያሉትን የእግዚአብሔርን ማኅበሮች የምትመስሉ ሆናችኋልና፤ እነርሱ ከአይሁድ መከራ እንደ ተቀበሉ፥ እናንተ ደግሞ ያንን መከራ ከአገራችሁ ሰዎች ተቀብላችኋልና። ");
INSERT INTO amh_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","እነዚያም ጌታን ኢየሱስን ደግሞ ገደሉ ነቢያትንም እኛንም አሳደዱ፥ እግዚአብሔርንም ደስ አያሰኙም፥ ሰዎችንም ሁሉ ይቃወማሉ፥ ");
INSERT INTO amh_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","ሁልጊዜ ኃጢአታቸውን ይፈጽሙ ዘንድ አሕዛብ እንዲድኑ እንዳንናገራቸው ይከለክሉናልና። ነገር ግን ቍጣው ወደ እነርሱ ፈጽሞ ደርሶአል። ");
INSERT INTO amh_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","እኛ ግን፥ ወንድሞች ሆይ፥ በልብ ያይደለ ፊት ለፊት ለጥቂት ጊዜ አጥተናችሁ፥ በብዙ ናፍቆት ፊታችሁን ለማየት እጅግ ሞከርን፤ ");
INSERT INTO amh_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","ወደ እናንተ ልንመጣ ወደን ነበርና፥ እኔ ጳውሎስም አንድና ሁለት ጊዜ፥ ሰይጣን ግን አዘገየን። ");
INSERT INTO amh_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","ተስፋችን ወይስ ደስታችን ወይስ የትምክህታችን አክሊል ማን ነው? በጌታችን በኢየሱስ ፊት በመምጣቱ እናንተ አይደላችሁምን? ");
INSERT INTO amh_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","እናንተ ክብራችን ደስታችንም ናችሁና። ");
INSERT INTO amh_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","ስለዚህ ወደ ፊት እንታገሥ ዘንድ ባልተቻለን ጊዜ፥ በአቴና ብቻችንን ልንቀር በጎ ፈቃዳችን ሆነ። ");
INSERT INTO amh_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","ስለ እምነታችሁም እንዲያጸናችሁና እንዲመክራችሁ ወንድማችንን የእግዚአብሔርንም አገልጋይ ከእኛ ጋርም አብሮ በክርስቶስ ወንጌል የሚሠራውን ጢሞቴዎስን ላክነው፤ ");
INSERT INTO amh_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","በዚህ መከራ ማንም እንዳይናውጥ፥ ለዚህ እንደ ተመረጥን ራሳችሁ ታውቃላችሁና። ");
INSERT INTO amh_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","በእውነት ከእናንተ ጋር ሳለን፥ መከራ እንቀበል ዘንድ እንዳለን አስቀድመን እንነግራችሁ ነበር፤ እንዲሁም ደግሞ ሆነ፥ ይህንም ታውቃላችሁ። ");
INSERT INTO amh_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","ስለዚህ እኔ ደግሞ ወደ ፊት እታገሥ ዘንድ ባልተቻለኝ ጊዜ። ፈታኝ ምናልባት ፈትኖአቸዋል ድካማችንም ከንቱ ሆኖአል ብዬ እምነታችሁን ለማወቅ ላክሁ። ");
INSERT INTO amh_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","አሁን ግን ጢሞቴዎስ ከእናንተ ዘንድ ወደ እኛ መጥቶ ስለ እምነታችሁና ስለ ፍቅራችሁ የምስራች ብሎ በነገረን ጊዜ፥ እኛም እናያችሁ ዘንድ እንደምንናፍቅ ታዩን ዘንድ እየናፈቃችሁ ሁልጊዜ በመልካም እንደምታስቡን በነገረን ጊዜ፥ ");
INSERT INTO amh_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","ስለዚህ፥ ወንድሞች ሆይ፥ በእምነታችሁ በኩል በችግራችንና በመከራችን ሁሉ ስለ እናንተ ተጽናናን፤ ");
INSERT INTO amh_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","እናንተ በጌታ ጸንታችሁ ብትቆሙ፥ አሁን በሕይወት እንኖራለንና። ");
INSERT INTO amh_vpl VALUES ("H13_9","082_3_9","1TH","3","9","13","አምላካችንና አባታችን ራሱ ጌታችንም ኢየሱስ ክርስቶስ ወደ እናንተ መንገዳችንን ያቅና፤ ");
INSERT INTO amh_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","እንግዲህ በቀረውስ፥ ወንድሞች ሆይ፥ ልትመላለሱ እግዚአብሔርንም ደስ ልታሰኙ እንዴት እንደሚገባችሁ ከእኛ ዘንድ እንደ ተቀበላችሁ፥ እናንተ ደግሞ እንደምትመላለሱ፥ ከፊት ይልቅ ትበዙ ዘንድ በጌታ በኢየሱስ እንለምናችኋለን እንመክራችሁማለን። ");
INSERT INTO amh_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","በጌታ በኢየሱስ የትኛውን ትእዛዝ እንደ ሰጠናችሁ ታውቃላችሁና። ");
INSERT INTO amh_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","ይህ የእግዚአብሔር ፈቃድ እርሱም መቀደሳችሁ ነውና፤ ");
INSERT INTO amh_vpl VALUES ("H14_4","082_4_4","1TH","4","4","6","አስቀድመን ደግሞ እንዳልናችሁና እንደ መሰከርንላችሁ፥ ጌታ ስለዚህ ነገር ሁሉ የሚበቀል ነውና ማንም በዚህ ነገር አይተላለፍ ወንድሙንም አያታልል። ");
INSERT INTO amh_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","ለርኵሰት ሳይሆን እግዚአብሔር በቅድስና ጠርቶናልና። ");
INSERT INTO amh_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","እንግዲህ የሚጥል ሰውን የጣለ አይደለም፥ መንፈስ ቅዱስን በእናንተ እንዲኖር የሰጠውን እግዚአብሔርን ነው እንጂ። ");
INSERT INTO amh_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","እናንተ ራሳችሁ እርስ በርሳችሁ ልትዋደዱ በእግዚአብሔር ተምራችኋልና ስለ ወንድማማች መዋደድ ማንም ይጽፍላችሁ ዘንድ አያስፈልጋችሁም፤ ");
INSERT INTO amh_vpl VALUES ("H14_10","082_4_10","1TH","4","10","13","ነገር ግን፥ ወንድሞች ሆይ፥ ተስፋ እንደሌላቸው እንደ ሌሎች ደግሞ እንዳታዝኑ፥ አንቀላፍተው ስላሉቱ ታውቁ ዘንድ እንወዳለን። ");
INSERT INTO amh_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","ኢየሱስ እንደ ሞተና እንደ ተነሣ ካመንን፥ እንዲሁም በኢየሱስ ያንቀላፉቱን እግዚአብሔር ከእርሱ ጋር ያመጣቸዋልና። ");
INSERT INTO amh_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","በጌታ ቃል የምንላችሁ ይህ ነውና፤ እኛ ሕያዋን ሆነን ጌታ እስኪመጣ ድረስ የምንቀር ያንቀላፉቱን አንቀድምም፤ ");
INSERT INTO amh_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","ጌታ ራሱ በትእዛዝ በመላእክትም አለቃ ድምፅ በእግዚአብሔርም መለከት ከሰማይ ይወርዳልና፥ በክርስቶስም የሞቱ አስቀድመው ይነሣሉ፤ ");
INSERT INTO amh_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","ከዚያም በኋላ እኛ ሕያዋን ሆነን የምንቀረው፥ ጌታን በአየር ለመቀበል ከእነርሱ ጋር በደመና እንነጠቃለን፤ እንዲሁም ሁልጊዜ ከጌታ ጋር እንሆናለን። ");
INSERT INTO amh_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","ስለዚህ እርስ በርሳችሁ በዚህ ቃል ተጽናኑ። ");
INSERT INTO amh_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","ወንድሞች ሆይ፥ ስለ ዘመናትና ስለ ወራት ምንም እንዲጻፍላችሁ አያስፈልጋችሁም፤ ");
INSERT INTO amh_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","የጌታ ቀን፥ ሌባ በሌሊት እንደሚመጣ፥ እንዲሁ ይመጣ ዘንድ ራሳችሁ አጥብቃችሁ አውቃችኋልና። ");
INSERT INTO amh_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","ሰላምና ደኅንነት ነው ሲሉ ያን ጊዜ ምጥ እርጕዝን እንደሚይዛት ጥፋት በድንገት ይመጣባቸዋል ከቶም አያመልጡም። ");
INSERT INTO amh_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","እናንተ ግን፥ ወንድሞች ሆይ፥ ቀኑ እንደ ሌባ ይደርስባችሁ ዘንድ በጨለማ አይደላችሁም፥ ");
INSERT INTO amh_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","ሁላችሁ የብርሃን ልጆች የቀንም ልጆች ናችሁና። እኛ ከሌሊት ወይም ከጨለማ አይደለንም፤ ");
INSERT INTO amh_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","እንግዲያስ እንንቃ በመጠንም እንኑር እንጂ እንደ ሌሎች አናንቀላፋ። ");
INSERT INTO amh_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","የሚያንቀላፉ በሌሊት ያንቀላፋሉና፥ የሚሰክሩም በሌሊት ይሰክራሉና፤ ");
INSERT INTO amh_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","እኛ ግን ከቀን ስለ ሆንን፥ የእምነትንና የፍቅርን ጥሩር የመዳንንም ተስፋ እንደ ራስ ቁር እየለበስን በመጠን እንኑር፤ ");
INSERT INTO amh_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","እግዚአብሔር ለቍጣ አልመረጠንምና፥ በጌታችን በኢየሱስ ክርስቶስ መዳንን ለማግኘት ነው እንጂ። ");
INSERT INTO amh_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","የምንነቃም ብንሆን፥ የምናንቀላፋም ብንሆን፥ ከእርሱ ጋር አብረን በሕይወት እንኖር ዘንድ ስለ እኛ ሞተ። ");
INSERT INTO amh_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","ስለዚህ እናንተ ደግሞ እንደምታደርጉ፥ እርስ በርሳችሁ ተመካከሩ አንዱም አንዱም ሌላውን ያንጸው። ");
INSERT INTO amh_vpl VALUES ("H15_12","082_5_12","1TH","5","12","14","ወንድሞች ሆይ፥ እንመክራችኋለን፤ ያለ ሥርዓት የሚሄዱትን ገሥጹአቸው፤ ድፍረት የሌላቸውን አጽኑአቸው፤ ለደካሞች ትጉላቸው፤ ሰውን ሁሉ ታገሡ። ");
INSERT INTO amh_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","ማንም ለሌላው በክፉ ፈንታ ክፉ እንዳይመልስ ተጠንቀቁ፥ ነገር ግን ሁልጊዜ እርስ በርሳችሁ ለሁሉም መልካሙን ለማድረግ ትጉ። ");
INSERT INTO amh_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","ሁልጊዜ ደስ ይበላችሁ፤ ");
INSERT INTO amh_vpl VALUES ("H15_17","082_5_17","1TH","5","17","19","መንፈስን አታጥፉ፤ ");
INSERT INTO amh_vpl VALUES ("H15_20","082_5_20","1TH","5","20","22","ከማናቸውም ዓይነት ክፉ ነገር ራቁ። ");
INSERT INTO amh_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","የሰላምም አምላክ ራሱ ሁለንተናችሁን ይቀድስ፤ መንፈሳችሁም ነፍሳችሁም ሥጋችሁም ጌታችን ኢየሱስ ክርስቶስ በመጣ ጊዜ ያለ ነቀፋ ፈጽመው ይጠበቁ። ");
INSERT INTO amh_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","የሚጠራችሁ የታመነ ነው፥ እርሱም ደግሞ ያደርገዋል። ");
INSERT INTO amh_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","ወንድሞች ሆይ፥ ስለ እኛ ጸልዩ። ");
INSERT INTO amh_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","ከወንድሞች ሁሉ ጋር በተቀደሰ አሳሳም ሰላምታ ተሰጣጡ። ");
INSERT INTO amh_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","ይህ መልእክት ለቅዱሳን ወንድሞች ሁሉ እንዲነበብ በጌታ አምላችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","የጌታችን የኢየሱስ ክርስቶስ ጸጋ ከእናንተ ጋር ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","ጳውሎስና ስልዋኖስ ጢሞቴዎስም፥ በእግዚአብሔር በአባታችን በጌታ በኢየሱስ ክርስቶስም ወደምትሆን ወደ ተሰሎንቄ ሰዎች ቤተ ክርስቲያን፤ ");
INSERT INTO amh_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","ከእግዚአብሔር ከአባታችን ከጌታ ከኢየሱስ ክርስቶስም ጸጋ ሰላምም ለእናንተ ይሁን። ");
INSERT INTO amh_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","ወንድሞች ሆይ፥ እምነታችሁ እጅግ ስለሚያድግ የሁላችሁም የእያንዳንዳችሁ ፍቅር እርስ በርሳችሁ ስለሚበዛ፥ ሁልጊዜ ስለ እናንተ እግዚአብሔርን እንደሚገባ ልናመሰግን ግድ አለብን፤ ");
INSERT INTO amh_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","ስለዚህ በምትታገሱበት በስደታችሁና በመከራችሁ ሁሉ ከመጽናታችሁና ከእምነታችሁ የተነሣ በእግዚአብሔር አብያተ ክርስቲያናት ስለ እናንተ ራሳችን እንመካለን። ");
INSERT INTO amh_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","ስለ እርሱ ደግሞ መከራ ለምትቀበሉለት ለእግዚአብሔር መንግሥት የምትበቁ ሆናችሁ ትቈጠሩ ዘንድ፥ ይህ የእግዚአብሔር ቅን ፍርድ ምልክት ነው። ");
INSERT INTO amh_vpl VALUES ("H21_6","083_1_6","2TH","1","6","12","እግዚአብሔርን የማያውቁትን፥ ለጌታችንም ለኢየሱስ ክርስቶስ ወንጌል የማይታዘዙትን ይበቀላል፤ ");
INSERT INTO amh_vpl VALUES ("H22_1","083_2_1","2TH","2","1","3","ማንም በማናቸውም መንገድ አያስታችሁ፤ ክህደቱ አስቀድሞ ሳይመጣና የዓመፅ ሰው እርሱም የጥፋት ልጅ ሳይገለጥ፥ አይደርስምና። ");
INSERT INTO amh_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","እኔ እግዚአብሔር ነኝ ብሎ አዋጅ እየነገረ በእግዚአብሔር ቤተ መቅደስ እስኪቀመጥ ድረስ፥ አምላክ ከተባለው ሁሉ፥ ሰዎችም ከሚያመልኩት ሁሉ በላይ ራሱን ከፍ ከፍ የሚያደርገው ተቃዋሚ እርሱ ነው። ");
INSERT INTO amh_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","ገና ከእናንተ ጋር ሳለሁ፥ ይህን እንዳልኋችሁ ትዝ አይላችሁምን? ");
INSERT INTO amh_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","በገዛ ራሱ ጊዜም ይገለጥ ዘንድ፥ የሚከለክለውን አሁን ታውቃላችሁ። ");
INSERT INTO amh_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","የዓመፅ ምሥጢር አሁን ይሠራልና፤ ብቻ ከመንገድ እስኪወገድ ድረስ አሁን የሚከለክል አለ። ");
INSERT INTO amh_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","በዚያም ጊዜ ጌታ ኢየሱስ በአፉ መንፈስ የሚያጠፋው፥ ሲመጣም በመገለጡ የሚሽረው ዓመፀኛ ይገለጣል፤ ");
INSERT INTO amh_vpl VALUES ("H22_9","083_2_9","2TH","2","9","13","እኛ ግን፥ በጌታ የተወደዳችሁ ወንድሞች ሆይ፥ ሁልጊዜ ስለ እናንተ እግዚአብሔርን ልናመሰግን ግድ አለብን፥ እግዚአብሔር በመንፈስ መቀደስ እውነትንም በማመን ለመዳን እንደ በኵራት መርጦአችኋልና፤ ");
INSERT INTO amh_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","ለዚህም የጌታችንን የኢየሱስ ክርስቶስን ክብር ለማግኘት በወንጌላችን ጠራችሁ። ");
INSERT INTO amh_vpl VALUES ("H22_15","083_2_15","2TH","2","15","17","እንግዲያስ፥ ወንድሞች ሆይ፥ ጸንታችሁ ቁሙ፥ በቃላችንም ቢሆን ወይም በመልእክታችን የተማራችሁትን ወግ ያዙ። ");
INSERT INTO amh_vpl VALUES ("H23_1","083_3_1","2TH","3","1","3","ነገር ግን የሚያጸናችሁ ከክፉውም የሚጠብቃችሁ ጌታ የታመነ ነው። ");
INSERT INTO amh_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","የምናዛችሁንም አሁን እንድታደርጉ ወደ ፊትም ደግሞ እንድታደርጉ ስለ እናንተ በጌታ ታምነናል። ");
INSERT INTO amh_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","ጌታም ወደ እግዚአብሔር ፍቅር ወደ ክርስቶስም ትዕግሥት ልባችንን ያቅናው። ");
INSERT INTO amh_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","ወንድሞች ሆይ፥ ከእኛ እንደ ተቀበለው ወግ ሳይሆን ያለ ሥርዓት ከሚሄድ ወንድም ሁሉ ትለዩ ዘንድ በጌታችን በኢየሱስ ክርስቶስ ስም እናዛችኋለን። ");
INSERT INTO amh_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","እኛን ልትመስሉ እንዴት እንደሚገባችሁ ራሳችሁ ታውቃላችሁና፤ በእናንተ ዘንድ ያለ ሥርዓት አልሄድንምና፤ ");
INSERT INTO amh_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","ከእናንተ ዘንድ በአንዱ ስንኳ እንዳንከብድበት፥ ሌሊትና ቀን በድካምና በጥረት እየሠራን እንኖር ነበር እንጂ፥ ከማንም እንጀራን እንዲያው አልበላንም። ");
INSERT INTO amh_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","ይህም እኛን ልትመስሉ ራሳችንን እንደ ምሳሌ እንሰጣችሁ ዘንድ ነበር እንጂ፥ ያለ ሥልጣን ስለ ሆንን አይደለም። ");
INSERT INTO amh_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","ደግሞ ከእናንተ ጋር ሳለን። ሊሠራ የማይወድ አይብላ ብለን አዘናችሁ ነበርና። ");
INSERT INTO amh_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","ሥራ ከቶ ሳይሠሩ፥ በሰው ነገር እየገቡ፥ ያለ ሥርዓት ከእናንተ ዘንድ ስለሚሄዱ ስለ አንዳንዶች ሰምተናልና። ");
INSERT INTO amh_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","እንደነዚህ ያሉትንም በጸጥታ እየሠሩ የገዛ እንጀራቸውን ይበሉ ዘንድ በጌታችን በኢየሱስ ክርስቶስ እናዛቸዋለን እንመክራቸውማለን። ");
INSERT INTO amh_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","እናንተ ግን፥ ወንድሞች ሆይ፥ መልካም ሥራን ለመሥራት አትታክቱ። ");
INSERT INTO amh_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","በዚህ መልእክት ለተላከ ቃላችን የማይታዘዝ ማንም ቢኖር፥ ይህን ተመልከቱት፥ ያፍርም ዘንድ ከእርሱ ጋር አትተባበሩ። ");
INSERT INTO amh_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","ነገር ግን እንደ ወንድም ገሥጹት እንጂ እንደ ጠላት አትቍጠሩት። ");
INSERT INTO amh_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","የሰላምም ጌታ ራሱ በሁሉ መንገድ ዘወትር ሰላምን ይስጣችሁ። ጌታ ከሁላችሁ ጋር ይሁን። ");
INSERT INTO amh_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","በገዛ እጄ የተጻፈ የእኔ የጳውሎስ ሰላምታ ይህ ነው፤ የመልእክቴ ሁሉ ማስረጃ ይህ ነው፤ እንዲህ እጽፋለሁ። ");
INSERT INTO amh_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","የጌታችን የኢየሱስ ክርስቶስ ጸጋ ከሁላችሁ ጋር ይሁን። ");
INSERT INTO amh_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","መድኃኒታችን እግዚአብሔር ተስፋችንም ኢየሱስ ክርስቶስ እንዳዘዘው ትእዛዝ የኢየሱስ ክርስቶስ ሐዋርያ የሆነ ጳውሎስ፥ ");
INSERT INTO amh_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","በእምነት እውነተኛ ልጄ ለሆነ ለጢሞቴዎስ፤ ከእግዚአብሔር ከአባታችን ከክርስቶስ ኢየሱስም ከጌታችን ጸጋና ምሕረት ሰላምም ይሁን። ");
INSERT INTO amh_vpl VALUES ("T11_3","084_1_3","1TI","1","3","5","የትእዛዝ ፍጻሜ ግን ከንጹሕ ልብና ከበጎ ሕሊና ግብዝነትም ከሌለበት እምነት የሚወጣ ፍቅር ነው፤ ");
INSERT INTO amh_vpl VALUES ("T11_6","084_1_6","1TI","1","6","8","ነገር ግን ሰው እንደሚገባ ቢሰራበት ሕግ መልካም እንደ ሆነ እናውቃለን፤ ");
INSERT INTO amh_vpl VALUES ("T11_9","084_1_9","1TI","1","9","12","ለአገልግሎቱ ሾሞኝ ታማኝ አድርጎ ስለ ቈጠረኝ፥ ኃይል የሰጠኝን ክርስቶስ ኢየሱስን ጌታችንን አመሰግናለሁ፤ ");
INSERT INTO amh_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","አስቀድሞ ተሳዳቢና አሳዳጅ አንገላችም ምንም ብሆን፥ ይህን አደረገልኝ፤ ነገር ግን ሳላውቅ ባለማመን ስላደረግሁት ምህረትን አገኘሁ፥ ");
INSERT INTO amh_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","የጌታችንም ጸጋ በክርስቶስ ኢየሱስ ካሉ ከእምነትና ከፍቅር ጋር አብልጦ በዛ። ");
INSERT INTO amh_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","ኃጢአተኞችን ሊያድን ክርስቶስ ኢየሱስ ወደ ዓለም መጣ የሚለው ቃል የታመነና ሁሉ እንዲቀበሉት የተገባ ነው፤ ከኃጢአተኞችም ዋና እኔ ነኝ፤ ");
INSERT INTO amh_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","ስለዚህ ግን፥ የዘላለምን ሕይወት ለማግኘት በእርሱ ያምኑ ዘንድ ላላቸው ሰዎች ምሳሌ እንድሆን፥ ኢየሱስ ክርስቶስ ዋና በምሆን በእኔ ላይ ትዕግስቱን ሁሉ ያሳይ ዘንድ፥ ምህረትን አገኘሁ። ");
INSERT INTO amh_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","ብቻውን አምላክ ለሚሆን ለማይጠፋው ለማይታየውም ለዘመናት ንጉሥ ምስጋናና ክብር እስከ ዘላለም ድረስ ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","ጢሞቴዎስ ልጄ ሆይ፥ አስቀድሞ ስለ አንተ እንደ ተነገረው ትንቢት፥ በእርሱ መልካም ጦርነት ትዋጋ ዘንድ ይህችን ትእዛዝ አደራ እሰጥሃለሁ፤ ");
INSERT INTO amh_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","እምነትና በጎ ሕሊና ይኑርህ፥ አንዳንዶች ሕሊናን ጥለው፥ መርከብ አለ መሪ እንደሚጠፋ፥ በእምነት ነገር ጠፍተዋልና፤ ");
INSERT INTO amh_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","ከእነዚያም፥ እንዳይሳደቡ ይማሩ ዘንድ ለሰይጣን አሳልፌ የሰጠኋቸው፥ ሄሜኔዎስና እስክንድሮስ ናቸው። ");
INSERT INTO amh_vpl VALUES ("T12_1","084_2_1","1TI","2","1","5","አንድ እግዚአብሔር አለና፥ በእግዚአብሔርና በሰውም መካከል ያለው መካከለኛው ደግሞ አንድ አለ፥ እርሱም ሰው የሆነ ክርስቶስ ኢየሱስ ነው፤ ");
INSERT INTO amh_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","ራሱንም ለሁሉ ቤዛ ሰጠ፥ ይህም በገዛ ዘመኑ ምስክርነቱ ነበረ፤ ");
INSERT INTO amh_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","እኔም ለዚህ ነገር አዋጅ ነጋሪና ሐዋርያ በእምነትና በእውነትም የአሕዛብ አስተማሪ ለመሆን ተሾምሁ፤ እውነት እናገራለሁ፤ አልዋሽም። ");
INSERT INTO amh_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","እንግዲህ ወንዶች በስፍራ ሁሉ አለ ቍጣና አለ ክፉ አሳብ የተቀደሱትን እጆች እያነሱ እንዲጸልዩ እፈቅዳለሁ። ");
INSERT INTO amh_vpl VALUES ("T12_9","084_2_9","1TI","2","9","11","ሴት በነገር ሁሉ እየተገዛች በዝግታ ትማር፤ ");
INSERT INTO amh_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","ሴት ግን በዝግታ ትኑር እንጂ ልታስተምር ወይም በወንድ ላይ ልትሰለጥን አልፈቅድም። ");
INSERT INTO amh_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","አዳም ቀድሞ ተፈጥሮአልና፥ በኋላም ሔዋን ተፈጠረች። ");
INSERT INTO amh_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","የተታለለም አዳም አይደለም፥ ሴቲቱ ግን ተታልላ በመተላለፍ ወደቀች፤ ");
INSERT INTO amh_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","ነገር ግን በእምነትና በፍቅር በቅድስናም ራሳቸውን እየገዙ ቢኖሩ በመውለድ ትድናለች። ");
INSERT INTO amh_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","ማንም ኤጲስ ቆጶስነትን ቢፈልግ መልካምን ሥራ ይመኛል የሚለው ቃል የታመነ ነው። ");
INSERT INTO amh_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","እንግዲህ ኤጲስ ቆጶስ እንዲህ ሊሆን ይገባዋል፤ የማይነቀፍ፥ የአንዲት ሚስት ባል፥ ልከኛ፥ ራሱን የሚገዛ፥ እንደሚገባው የሚሰራ፥ እንግዳ ተቀባይ፥ ለማስተማር የሚበቃ፥ ");
INSERT INTO amh_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","የማይሰክር፥ የማይጨቃጨቅ ነገር ግን ገር የሆነ፥ የማይከራከር፥ ገንዘብን የማይወድ፥ ");
INSERT INTO amh_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","ልጆቹን በጭምትነት ሁሉ እየገዛ የራሱን ቤት በመልካም የሚያስተዳድር፤ ");
INSERT INTO amh_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","ሰው ግን የራሱን ቤት እንዲያስተዳድር ባያውቅ፥ የእግዚአብሔርን ቤተ ክርስቲያን እንዴት ይጠብቃታል? ");
INSERT INTO amh_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","በትዕቢት ተነፍቶ በዲያቢሎስ ፍርድ እንዳይወድቅ፥ አዲስ ክርስቲያን አይሁን። ");
INSERT INTO amh_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","በዲያቢሎስ ነቀፋና ወጥመድም እንዳይወድቅ፥ በውጭ ካሉት ሰዎች ደግሞ መልካም ምስክር ሊኖረው ይገባዋል። ");
INSERT INTO amh_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","እንዲሁም ዲያቆናት ጭምቶች፥ በሁለት ቃል የማይናገሩ፥ ለብዙ ወይን ጠጅ የማይጎመጁ፥ ");
INSERT INTO amh_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","ነውረኛ ረብ የማይወዱ፥ በንጹሕ ሕሊና የሃይማኖትን ምሥጢር የሚይዙ ሊሆኑ ይገባቸዋል። ");
INSERT INTO amh_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","እነዚህም ደግሞ አስቀድሞ ይፈተኑ፥ ከዚያም በኋላ ያለ ነቀፋ ቢሆኑ በዲቁና ሥራ ያገልግሉ። ");
INSERT INTO amh_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","እንዲሁም ሴቶች ጭምቶች፥ የማያሙ፥ ልከኞች፥ በነገር ሁሉ የታመኑ ሊሆኑ ይገባቸዋል። ");
INSERT INTO amh_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","ዲያቆናት ልጆቻቸውንና የራሳቸውን ቤቶች በመልካም እየገዙ እያንዳንዳቸው የአንዲት ሴት ባሎች ይሁኑ። ");
INSERT INTO amh_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","በዲቁና ሥራ በመልካም ያገለገሉ ለራሳቸው ትልቅ ማዕርግና በክርስቶስ ኢየሱስ ባለው እምነት ብዙ ድፍረት ያገኛሉ። ");
INSERT INTO amh_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","ፈጥኜ ወደ አንተ እንድመጣ ተስፋ አድርጌ ይህን እጽፍልሃለሁ። ");
INSERT INTO amh_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","ብዘገይ ግን፥ በእግዚአብሔር ማደሪያ ቤት መኖር እንዴት እንደሚገባ ታውቅ ዘንድ እጽፍልሃለሁ፤ ቤቱም የእውነት ዓምድና መሠረት፥ የሕያው እግዚአብሔር ቤተ ክርስቲያን ነው። ");
INSERT INTO amh_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","እግዚአብሔርንም የመምሰል ምሥጢር ያለ ጥርጥር ታላቅ ነው፤ በሥጋ የተገለጠ፥ በመንፈስ የጸደቀ፥ ለመላእክት የታየ፥ በአሕዛብ የተሰበከ፥ በዓለም የታመነ፥ በክብር ያረገ። ");
INSERT INTO amh_vpl VALUES ("T14_1","084_4_1","1TI","4","1","3","እነዚህ ውሸተኞች መጋባትን ይከለክላሉ፥ አምነውም እውነትን የሚያውቁ ከምስጋና ጋር ይቀበሉ ዘንድ እግዚአብሔር ከፈጠረው መብል እንዲርቁ ያዝዛሉ። ");
INSERT INTO amh_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","እግዚአብሔር የፈጠረው ሁሉ መልካም ነውና፥ ከምስጋናም ጋር ቢቀበሉት የሚጣል ምንም የለም፤ ");
INSERT INTO amh_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","በእግዚአብሔር ቃልና በጸሎት የተቀደሰ ነውና። ");
INSERT INTO amh_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","ስለዚህ ወንድሞችን ብታሳስብ፥ በእምነትና በተከተልኸው በመልካም ትምህርት ቃል የምትመገብ የኢየሱስ ክርስቶስ መልካም አገልጋይ ትሆናለህ። ");
INSERT INTO amh_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","ነገር ግን ለዚህ ዓለም ከሚመችና የአሮጊቶችን ሴቶች ጨዋታ ከሚመስለው ተረት ራቅ። እግዚአብሔርን ለመምሰል ግን ራስህን አስለምድ። ");
INSERT INTO amh_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","ሰውነትን ለሥጋዊ ነገር ማስለመድ ለጥቂት ይጠቅማልና፤ እግዚአብሔርን መምሰል ግን የአሁንና የሚመጣው ሕይወት ተስፋ ስላለው፥ ለነገር ሁሉ ይጠቅማል። ");
INSERT INTO amh_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","ይህ ቃል የታመነ ሁሉም እንዲቀበሉት የተገባ ነው፤ ");
INSERT INTO amh_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","ይህን ለማግኘት እንደክማለንና፥ ስለዚህም እንሰደባለን፤ ይህም ሰውን ሁሉ ይልቁንም የሚያምኑትን በሚያድን በሕያው አምላክ ተስፋ ስለምናደርግ ነው። ");
INSERT INTO amh_vpl VALUES ("T14_11","084_4_11","1TI","4","11","13","እስክመጣ ድረስ ለማንበብና ለመምከር ለማስተማርም ተጠንቀቅ። ");
INSERT INTO amh_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","በትንቢት ከሽማግሌዎች እጅ መጫን ጋር የተሰጠህን፥ በአንተ ያለውን የጸጋ ስጦታ ቸል አትበል። ");
INSERT INTO amh_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","ማደግህ በነገር ሁሉ እንዲገለጥ ይህን አስብ፥ ይህንም አዘውትር። ");
INSERT INTO amh_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","ለራስህና ለትምህርትህ ተጠንቀቅ፥ በእነዚህም ጽና፤ ይህን ብታደርግ፥ ራስህንም የሚሰሙህንም ታድናለህና። ");
INSERT INTO amh_vpl VALUES ("T15_1","084_5_1","1TI","5","1","3","በእውነት ባልቴቶች የሆኑትን ባልቴቶች አክብር። ");
INSERT INTO amh_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","ማንም ባልቴት ግን ልጆች ወይም የልጅ ልጆች ቢኖሩአት፥ እነርሱ አስቀድመው ለገዛ ቤተ ሰዎቻቸው እግዚአብሔርን መምሰል ያሳዩ ዘንድ፥ ለወላጆቻቸውም ብድራትን ይመልሱላቸው ዘንድ ይማሩ፤ ይህ በእግዚአብሔር ፊት መልካምና የተወደደ ነውና። ");
INSERT INTO amh_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","ብቻዋንም ኖራ በእውነት ባልቴት የምትሆን በእግዚአብሔር ተስፋ ታደርጋለች፥ ሌትና ቀንም በልመና በጸሎትም ጸንታ ትኖራለች፤ ");
INSERT INTO amh_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","ቅምጥሊቱ ግን በሕይወትዋ ሳለች የሞተች ናት። ");
INSERT INTO amh_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","ያለ ነቀፋ እንዲሆኑ ይህን ደግሞ እዘዝ። ");
INSERT INTO amh_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","ነገር ግን ለእርሱ ስለ ሆኑት ይልቁንም ስለ ቤተ ሰዎቹ የማያስብ ማንም ቢሆን፥ ሃይማኖትን የካደ ከማያምንም ሰው ይልቅ የሚከፋ ነው። ");
INSERT INTO amh_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","ባልቴት በመዝገብ ብትጻፍ ዕድሜዋ ከስድሳ ዓመት እንዳያንስ፥ የአንድም ባል ሚስት የነበረች እንድትሆን ያስፈልጋል፤ ");
INSERT INTO amh_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","ልጆችን በማሳደግ እንግዶችንም በመቀበል፥ የቅዱሳንንም እግሮች በማጠብ፥ የተጨነቁትንም በመርዳት በጎንም ሥራ ሁሉ በመከተል፥ ይህን መልካም ሥራ በማድረግ የተመሰከረላት ልትሆን ይገባል። ");
INSERT INTO amh_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","ባል የሞተባቸውን ቆነጃጅት ግን አትቀበል፤ በክርስቶስ ላይ ተነሥተው ሲቀማጠሉ ሊያገቡ ይወዳሉና፤ ");
INSERT INTO amh_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","የፊተኛውንም እምነታቸውን ስለ ናቁ ይፈረድባቸዋል፤ ");
INSERT INTO amh_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","ከዚህም ጋር ቤት ለቤት እየዞሩ ሥራን መፍታት ደግሞ ይማራሉ፥ የማይገባውንም እየተናገሩ ለፍላፊዎችና በነገር ገቢዎች ይሆናሉ እንጂ፥ ሥራ ፈቶች ብቻ አይደሉም። ");
INSERT INTO amh_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","እንግዲህ ቆነጃጅት ሊያገቡ፥ ልጆችንም ሊወልዱ፥ ቤቶቻቸውንም ሊያስተዳድሩ፥ ተቃዋሚውም የሚሳደብበትን አንድን ምክንያት ስንኳ እንዳይሰጡ እፈቅዳለሁ፤ ");
INSERT INTO amh_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","ከአሁን በፊት አንዳንዶች ሰይጣንን እንዲከተሉ ፈቀቅ ብለዋልና። ");
INSERT INTO amh_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","ባልቴቶች ያሉት የሚያምን ቢሆን ወይም የምታምን ብትሆን፥ ይርዱአቸው፥ ቤተ ክርስቲያንም እውነተኞችን ባልቴቶች እንድትረዳ አይክበዱባት። ");
INSERT INTO amh_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","በመልካም የሚያስተዳድሩ ሽማግሌዎች፥ ይልቁንም በመስበክና በማስተማር የሚደክሙት፥ እጥፍ ክብር ይገባቸዋል። ");
INSERT INTO amh_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","መጽሐፍ። የሚያበራየውን በሬ አፉን አትሰር፥ ደግሞ። ለሠራተኛ ደመወዙ ይገባዋል ይላልና። ");
INSERT INTO amh_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","ከሁለት ወይም ከሦስት ምስክር በቀር በሽማግሌ ላይ ክስ አትቀበል። ");
INSERT INTO amh_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","ሌሎቹ ደግሞ እንዲፈሩ፥ ኃጢአት የሚሰሩትን በሁሉ ፊት ገሥጻቸው። ");
INSERT INTO amh_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","አንድን እንኳ በአድልዎ ሳታደርግ፥ እነዚህን ያለ መዘንበል እንድትጠብቅ በእግዚአብሔርና በጌታ በኢየሱስ ክርስቶስ በተመረጡትም መላእክት ፊት እመክርሃለሁ። ");
INSERT INTO amh_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","በማንም ላይ ፈጥነህ እጆችህን አትጫን፥ በሌሎችም ኃጢአት አትተባበር፤ ራስህን በንጽህና ጠብቅ። ");
INSERT INTO amh_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","ስለ ሆድህና ስለ በሽታህ ብዛት ጥቂት የወይን ጠጅ ጠጣ እንጂ፥ ወደ ፊት ውኃ ብቻ አትጠጣ። ");
INSERT INTO amh_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","የአንዳንዶች ሰዎች ኃጢአት የተገለጠ ነው ፍርድንም ያመለክታል፥ ሌሎችን ግን ይከተላቸዋል፤ ");
INSERT INTO amh_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","እንዲሁ መልካም ሥራ ደግሞ የተገለጠ ነው፥ ያልተገለጠም ከሆነ ሊሰወር አይችልም። ");
INSERT INTO amh_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","የእግዚአብሔር ስምና ትምህርቱ አንዳይሰደብ፥ ከቀንበር በታች ያሉቱ ባሪያዎች ሁሉ ለገዙአቸው ጌቶች ክብር ሁሉ እንደ ተገባቸው ይቍጠሩአቸው። ");
INSERT INTO amh_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","የሚያምኑም ጌቶች ያሉአቸው፥ ወንድሞች ስለ ሆኑ አይናቁአቸው፥ ነገር ግን በመልካም ሥራቸው የሚጠቅሙ የሚያምኑና የተወደዱ ስለ ሆኑ፥ ከፊት ይልቅ ያገልግሉ። ");
INSERT INTO amh_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","እነዚህን አስተምርና ምከር። ማንም ልዩ ትምህርት የሚያስተምር ከጌታችንም ከኢየሱስ ክርስቶስ በሆነው ጤናማ ቃልና እግዚአብሔርን ለመምሰል በሚስማማ ትምህርት የማይጠጋ ቢሆን፥ ");
INSERT INTO amh_vpl VALUES ("T16_4","084_6_4","1TI","6","4","6","ኑሮዬ ይበቃኛል ለሚለው ግን እግዚአብሔርን መምሰል እጅግ ማትረፊያ ነው፤ ");
INSERT INTO amh_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","ወደ ዓለም ምንም እንኳ አላመጣንምና፥ ");
INSERT INTO amh_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","አንዳችንም ልንወስድ አይቻለንም፤ ምግብና ልብስ ከኖረን ግን፥ እርሱ ይበቃናል። ");
INSERT INTO amh_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","ዳሩ ግን ባለ ጠጎች ሊሆኑ የሚፈልጉ በጥፋትና በመፍረስ ሰዎችን በሚያሰጥምና በሚያሰንፍ በሚጎዳም በብዙ ምኞትና በፈተና በወጥመድም ይወድቃሉ። ");
INSERT INTO amh_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","ገንዘብን መውደድ የክፋት ሁሉ ሥር ነውና፥ አንዳንዶች ይህን ሲመኙ፥ ከሃይማኖት ተሳስተው በብዙ ሥቃይ ራሳቸውን ወጉ። ");
INSERT INTO amh_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","አንተ ግን፥ የእግዚአብሔር ሰው ሆይ፥ ከዚህ ሽሽ፤ ጽድቅንና እግዚአብሔርን መምሰል እምነትንም ፍቅርንም መጽናትንም የዋህነትንም ተከታተል። ");
INSERT INTO amh_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","መልካሙን የእምነት ገድል ተጋደል፥ የተጠራህለትንም በብዙም ምስክሮች ፊት በመልካም መታመን የታመንህለትን የዘላለምን ሕይወት ያዝ። ");
INSERT INTO amh_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","ሁሉን በሕይወት በሚጠብቅ በእግዚአብሔር ፊት፥ በጴንጤናዊውም በጲላጦስ ዘንድ መልካሙን መታመን በመሰከረ በክርስቶስ ኢየሱስ ፊት አዝሃለሁ፤ ");
INSERT INTO amh_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","ጌታችን ኢየሱስ ክርስቶስ እስኪገለጥ ድረስ ያለ እድፍና ያለ ነቀፋ ሆነህ ትእዛዙን ጠብቅ፤ ");
INSERT INTO amh_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","ያንም መገለጡን በራሱ ጊዜ ብፁዕና ብቻውን የሆነ ገዥ፥ የነገሥታት ንጉሥና የጌቶች ጌታ፥ ያሳያል። ");
INSERT INTO amh_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","እርሱ ብቻ የማይሞት ነው፤ ማንም ሊቀርበው በማይችል ብርሃን ይኖራል፤ አንድ ሰው እንኳ አላየውም ሊያይም አይቻለውም፤ ለእርሱ ክብርና የዘላለም ኃይል ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","በአሁኑ ዘመን ባለ ጠጎች የሆኑት የትዕቢትን ነገር እንዳያስቡ፥ ደስም እንዲለን ሁሉን አትርፎ በሚሰጠን በሕያው እግዚአብሔር እንጂ በሚያልፍ ባለ ጠግነት ተስፋ እንዳያደርጉ እዘዛቸው። ");
INSERT INTO amh_vpl VALUES ("T16_18","084_6_18","1TI","6","18","20","ጢሞቴዎስ ሆይ፥ በውሸት እውቀት ከተባለ ለዓለም ከሚመች ከከንቱ መለፍለፍና መከራከር እየራቅህ፥ የተሰጠህን አደራ ጠብቅ፤ ");
INSERT INTO amh_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","ይህ እውቀት አለን ብለው፥ አንዳንዶች ስለ እምነት ስተዋልና። ጸጋ ከአንተ ጋር ይሁን። ");
INSERT INTO amh_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","በክርስቶስ ኢየሱስ እንደሚሆን የሕይወት ተስፋ፥ በእግዚአብሔር ፈቃድ የኢየሱስ ክርስቶስ ሐዋርያ የሆነ ጳውሎስ፥ ");
INSERT INTO amh_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","ለተወደደው ልጄ ለጢሞቴዎስ፤ ከእግዚአብሔር አብ ከጌታችንም ከክርስቶስ ኢየሱስ ጸጋና ምሕረት ሰላምም ይሁን። ");
INSERT INTO amh_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","ሌትና ቀን በልመናዬ ሳላቋርጥ ስለማስብህ እንደ አባቶቼ አድርጌ በንጹሕ ሕሊና የማመልከውን እግዚአብሔርን አመሰግናለሁ፤ ");
INSERT INTO amh_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","እንባህን እያሰብሁ በደስታ እሞላ ዘንድ ላይህ እናፍቃለሁ። ");
INSERT INTO amh_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","በአንተ ያለውን ግብዝነት የሌለበትን እምነትህን አስባለሁ፤ ይህም እምነት ቀድሞ በአያትህ በሎይድ በእናትህም በኤውንቄ ነበረባቸው፥ በአንተም ደግሞ እንዳለ ተረድቼአለሁ። ");
INSERT INTO amh_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","ስለዚህ ምክንያት፥ እሳት እንደሚያቀጣጥል ሰው፥ እጆቼን በመጫኔ በአንተ ያለውን የእግዚአብሔርን ስጦታ እንድታነሣሣ አሳስብሃለሁ። ");
INSERT INTO amh_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","እግዚአብሔር የኃይልና የፍቅር ራስንም የመግዛት መንፈስ እንጂ የፍርሃት መንፈስ አልሰጠንምና። ");
INSERT INTO amh_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","እንግዲህ በጌታችን ምስክርነት ወይም በእስረኛው በእኔ አትፈር፥ ነገር ግን እንደ እግዚአብሔር ኃይል መጠን ስለ ወንጌል አብረኸኝ መከራን ተቀበል፤ ");
INSERT INTO amh_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","ያዳነን በቅዱስም አጠራር የጠራን እግዚአብሔር ነውና፥ ይህም እንደ ራሱ አሳብና ጸጋ መጠን ነው እንጂ እንደ ሥራችን መጠን አይደለም፤ ይህም ጸጋ ከዘላለም ዘመናት በፊት በክርስቶስ ኢየሱስ ተሰጠን፥ ");
INSERT INTO amh_vpl VALUES ("T21_10","085_1_10","2TI","1","10","12","ስለዚህም ምክንያት ይህን መከራ ደግሞ ተቀብዬአለሁ፥ ነገር ግን አላፍርበትም፤ ያመንሁትን አውቃለሁና፥ የሰጠሁትንም አደራ እስከዚያ ቀን ድረስ ሊጠብቅ እንዲችል ተረድቼአለሁ። ");
INSERT INTO amh_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","በክርስቶስ ኢየሱስ ባለ እምነትና ፍቅር አድርገህ፥ ከእኔ የሰማኸውን ጤናማ ቃል ምሳሌ ያዝ፤ ");
INSERT INTO amh_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","መልካሙን አደራ በእኛ በሚኖረው በመንፈስ ቅዱስ ጠብቅ። ");
INSERT INTO amh_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","በእስያ ያሉቱ ሁሉ ከእኔ ፈቀቅ እንዳሉ ታውቃለህ፥ ከእነርሱም ፊሎጎስና ሄርዋጌኔስ ናቸው። ");
INSERT INTO amh_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","ጌታ ልሄኔሲፎሩ ቤተ ሰዎች ምሕረትን ይስጥ፥ ብዙ ጊዜ አሳርፎኛልና፤ ");
INSERT INTO amh_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","በሰንሰለቴም አላፈረበትም፥ ነገር ግን በሮሜ ባደረ ጊዜ ፈልጎ ፈልጎ አገኘኝ፤ ");
INSERT INTO amh_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","በዚያን ቀን ከጌታ ምሕረትን እንዲያገኝ ጌታ ይስጠው፤ በኤፌሶንም እንዴት እንዳገለገለኝ አንተ በደኅና ታውቃለህ። ");
INSERT INTO amh_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","እንግዲህ፥ ልጄ ሆይ፥ አንተ በክርስቶስ ኢየሱስ ባለው ጸጋ በርታ። ");
INSERT INTO amh_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","ብዙ ሰዎች የመሰከሩለትን ከእኔም የሰማኸውን ሌሎችን ደግሞ ሊያስተምሩ ለሚችሉ ለታመኑ ሰዎች አደራ ስጥ። ");
INSERT INTO amh_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","እንደ ኢየሱስ ክርስቶስ በጎ ወታደር ሆነህ፥ አብረኸኝ መከራ ተቀበል። ");
INSERT INTO amh_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","የሚዘምተው ሁሉ ለጦር ያስከተተውን ደስ ያሰኝ ዘንድ ትዳር በሚገኝበት ንግድ ራሱን አያጠላልፍም። ");
INSERT INTO amh_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","ደግሞም በጨዋታ የሚታገል ማንም ቢሆን፥ እንደሚገባ አድርጎ ባይታገል፥ የድሉን አክሊል አያገኝም። ");
INSERT INTO amh_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","የሚደክመው ገበሬ ፍሬውን ከሚበሉት መጀመሪያ እንዲሆን ይገባዋል። ");
INSERT INTO amh_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","የምለውን ተመልከት፤ ጌታም በነገር ሁሉ ማስተዋልን ይስጥህ። ");
INSERT INTO amh_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","በወንጌል እንደምሰብከው፥ ከሙታን የተነሣውን፥ ከዳዊት ዘርም የሆነውን ኢየሱስ ክርስቶስን አስብ፤ ");
INSERT INTO amh_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","ይህንም በመስበክ እንደ ክፉ አድራጊ እስክታሰር ድረስ መከራ እቀበላለሁ፥ የእግዚአብሔር ቃል ግን አይታሰርም። ");
INSERT INTO amh_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","ስለዚህ እነርሱ ደግሞ በክርስቶስ ኢየሱስ ያለውን መዳን ከዘላለም ክብር ጋር እንዲያገኙ ስለ ተመረጡት በነገር ሁሉ እጸናለሁ። ");
INSERT INTO amh_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","ቃሉ የታመነ ነው እንዲህ የሚለው። ከእርሱ ጋር ከሞትን፥ ከእርሱ ጋር ደግሞ በሕይወት እንኖራለን፤ ");
INSERT INTO amh_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","ብንጸና፥ ከእርሱ ጋር ደግሞ እንነግሣለን፤ ብንክደው፥ እርሱ ደግሞ ይክደናል፤ ");
INSERT INTO amh_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","ባናምነው፥ እርሱ የታመነ ሆኖ ይኖራል፤ ራሱን ሊክድ አይችልምና። ");
INSERT INTO amh_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","ይህን አሳስባቸው፥ በቃልም እንዳይጣሉ በእግዚአብሔር ፊት ምከራቸው፥ ይህ ምንም የማይረባ የሚሰሙትንም የሚያፈርስ ነውና። ");
INSERT INTO amh_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","የእውነትን ቃል በቅንነት የሚናገር የማያሳፍርም ሠራተኛ ሆነህ፥ የተፈተነውን ራስህን ለእግዚአብሔር ልታቀርብ ትጋ። ");
INSERT INTO amh_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","ነገር ግን ለዓለም ከሚመች ከከንቱ መለፍለፍ ራቅ፤ ኃጢአተኝነታቸውን ከፊት ይልቅ ይጨምራሉና፥ ቃላቸውም እንደ ጭንቁር ይባላል፤ ");
INSERT INTO amh_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","ከእነርሱም ሄሜኔዎስና ፊሊጦስ ናቸው፤ ");
INSERT INTO amh_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","እነዚህም። ትንሣኤ ከአሁን በፊት ሆኖአል እያሉ፥ ስለ እውነት ስተው፥ የአንዳንዶችን እምነት ይገለብጣሉ። ");
INSERT INTO amh_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","ሆኖም። ጌታ ለእርሱ የሆኑትን ያውቃል፥ ደግሞም። የጌታን ስም የሚጠራ ሁሉ ከዓመፅ ይራቅ የሚለው ማኅተም ያለበት የተደላደለ የእግዚአብሔር መሠረት ቆሞአል። ");
INSERT INTO amh_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","በትልቅም ቤት የእንጨትና የሸክላ ዕቃ ደግሞ አለ እንጂ የወርቅና የብር ዕቃ ብቻ አይደለም፥ እኵሌቶቹም ለክብር፥ እኵሌቶቹም ለውርደት ይሆናሉ፤ ");
INSERT INTO amh_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","እንግዲህ ማንም ራሱን ከእነዚህ ቢያነጻ፥ ለክብር የሚሆን የተቀደሰም ለጌታውም የሚጠቅም ለበጎም ሥራ ሁሉ የተዘጋጀ ዕቃ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","ከክፉ የጎልማሳነት ምኞት ግን ሽሽ፥ በንጹሕም ልብ ጌታን ከሚጠሩ ጋር ጽድቅን እምነትን ፍቅርን ሰላምን አጥብቀህ ተከተል። ");
INSERT INTO amh_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","ነገር ግን ጠብን እንዲያመጣ አውቀህ ከሰነፎችና ካልተማሩ ምርመራ ራቅ፤ ");
INSERT INTO amh_vpl VALUES ("T22_24","085_2_24","2TI","2","24","26","የጌታም ባሪያ ለሰው ሁሉ ገር ለማስተማርም የሚበቃ ለትዕግሥትም የሚጸና ሊሆን እንጂ ሊጣላ አይገባውም። ");
INSERT INTO amh_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","ነገር ግን በመጨረሻው ቀን የሚያስጨንቅ ዘመን እንዲመጣ ይህን እወቅ። ");
INSERT INTO amh_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","ሰዎች ራሳቸውን የሚወዱ ይሆናሉና፥ ገንዘብን የሚወዱ፥ ትምክህተኞች፥ ትዕቢተኞች፥ ተሳዳቢዎች፥ ለወላጆቻቸው የማይታዘዙ፥ የማያመሰግኑ፥ ");
INSERT INTO amh_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","ቅድስና የሌላቸው፥ ፍቅር የሌላቸው፥ ዕርቅን የማይሰሙ፥ ሐሜተኞች፥ ራሳቸውን የማይገዙ፥ ጨካኞች፥ መልካም የሆነውን የማይወዱ፥ ");
INSERT INTO amh_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","ከዳተኞች፥ ችኩሎች፥ በትዕቢት የተነፉ፥ ከእግዚአብሔር ይልቅ ተድላን የሚወዱ ይሆናሉ፤ ");
INSERT INTO amh_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","የአምልኮት መልክ አላቸው ኃይሉን ግን ክደዋል፤ ከእነዚህ ደግሞ ራቅ። ");
INSERT INTO amh_vpl VALUES ("T23_6","085_3_6","2TI","3","6","8","ኢያኔስና ኢያንበሬስም ሙሴን እንደ ተቃወሙት፥ እንዲሁ እነዚህ ደግሞ አእምሮአቸው የጠፋባቸው ስለ እምነትም የተጣሉ ሰዎች ሆነው፥ እውነትን ይቃወማሉ። ");
INSERT INTO amh_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","ዳሩ ግን የእነዚያ ሞኝነት ደግሞ ግልጥ እንደ ሆነ፥ ሞኝነታቸው ለሁሉ ይገለጣልና ከፊት ይልቅ አይቀናላቸውም። ");
INSERT INTO amh_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","አንተ ግን ትምህርቴንና አካሄዴን አሳቤንም እምነቴንም ትዕግሥቴንም ፍቅሬንም መጽናቴንም ስደቴንም መከራዬንም ተከተልህ፤ ");
INSERT INTO amh_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","በአንጾኪያና በኢቆንዮን በልስጥራንም የሆነብኝን የታገሥሁትንም ስደት ታውቃለህ፤ ጌታም ከሁሉ አዳነኝ። ");
INSERT INTO amh_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","በእውነትም በክርስቶስ ኢየሱስ እግዚአብሔርን እየመሰሉ ሊኖሩ የሚወዱ ሁሉ ይሰደዳሉ። ");
INSERT INTO amh_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","ነገር ግን ክፉዎች ሰዎችና አታላዮች፥ እያሳቱና እየሳቱ፥ በክፋት እየባሱ ይሄዳሉ። ");
INSERT INTO amh_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","አንተ ግን በተማርህበትና በተረዳህበት ነገር ጸንተህ ኑር፥ ከማን እንደ ተማርኸው ታውቃለህና፤ ");
INSERT INTO amh_vpl VALUES ("T23_15","085_3_15","2TI","3","15","17","ከሕፃንነትህም ጀምረህ ክርስቶስ ኢየሱስን በማመን፥ መዳን የሚገኝበትን ጥበብ ሊሰጡህ የሚችሉትን ቅዱሳን መጻሕፍትን አውቀሃል። ");
INSERT INTO amh_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","በእግዚአብሔር ፊት በሕያዋንና በሙታንም ሊፈርድ ባለው በጌታ በኢየሱስ ክርስቶስ ፊት፥ በመገለጡና በመንግሥቱም እመክርሃለሁ፤ ");
INSERT INTO amh_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","ቃሉን ስበክ፥ በጊዜውም አለጊዜውም ጽና፥ ፈጽመህ እየታገሥህና እያስተማርህ፥ ዝለፍና ገሥጽ ምከርም። ");
INSERT INTO amh_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","ሕይወት የሚገኝበትን ትምህርት የማይታገሡበት ዘመን ይመጣልና፤ ነገር ግን ጆሮቻቸውን የሚያሳክክ ስለ ሆነ፥ እንደ ገዛ ምኞታቸው ለራሳቸው አስተማሪዎችን ያከማቻሉ። ");
INSERT INTO amh_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","እውነትንም ከመስማት ጆሮቻቸውን ይመልሳሉ፥ ወደ ተረትም ፈቀቅ ይላሉ። ");
INSERT INTO amh_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","አንተ ግን ነገርን ሁሉ በልክ አድርግ፥ መከራን ተቀበል፥ የወንጌል ሰባኪነትን ሥራ አድርግ፥ አገልግሎትህን ፈጽም። ");
INSERT INTO amh_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","በመሥዋዕት እንደሚደረግ፥ የእኔ ሕይወት ይሠዋልና፥ የምሄድበትም ጊዜ ደርሶአል። ");
INSERT INTO amh_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","መልካሙን ገድል ተጋድዬአለሁ፥ ሩጫውን ጨርሼአለሁ፥ ሃይማኖትን ጠብቄአለሁ፤ ");
INSERT INTO amh_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","ወደ ፊት የጽድቅ አክሊል ተዘጋጅቶልኛል፥ ይህንም ጻድቅ ፈራጅ የሆነው ጌታ ያን ቀን ለእኔ ያስረክባል፥ ደግሞም መገለጡን ለሚወዱት ሁሉ እንጂ ለእኔ ብቻ አይደለም። ");
INSERT INTO amh_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","በቶሎ ወደ እኔ እንድትመጣ ትጋ፤ ");
INSERT INTO amh_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","ዴማስ የአሁኑን ዓለም ወዶ ትቶኛልና፥ ወደ ተሰሎንቄም ሄዶአል፤ ቄርቂስም ወደ ገላትያ ቲቶም ወደ ድልማጥያ ሄደዋል፤ ");
INSERT INTO amh_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","ሉቃስ ብቻ ከእኔ ጋር አለ። ማርቆስ ለአገልግሎት ብዙ ይጠቅመኛልና ይዘኸው ከአንተ ጋር አምጣው። ");
INSERT INTO amh_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","ቲኪቆስን ግን ወደ ኤፌሶን ላክሁት። ");
INSERT INTO amh_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","ስትመጣ በጢሮአዳ ከአክርጳ ዘንድ የተውሁትን በርኖሱንና መጻሕፍቱን ይልቁንም በብራና የተጻፉትን አምጣልኝ። ");
INSERT INTO amh_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","የናስ አንጥረኛው እስክንድሮስ እጅግ ከፋብኝ፤ ጌታ እንደ ሥራው ይመልስለታል። ");
INSERT INTO amh_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","አንተም ደግሞ ከእርሱ ተጠበቅ፥ የምንናገረውን እጅግ ተቃውሞአልና። ");
INSERT INTO amh_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","በፊተኛው ሙግቴ አንድ ስንኳ አልደረሰልኝም፥ ሁሉም ተዉኝ እንጂ፤ ይህንም አይቍጠርባቸው፤ ");
INSERT INTO amh_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","ዳሩ ግን የስብከቱ ሥራ በእኔ እንዲፈጸም አሕዛብም ሁሉ እንዲሰሙት፥ ጌታ በእኔ አጠገብ ቆሞ አበረታኝ፥ ከአንበሳ አፍም ዳንሁ። ");
INSERT INTO amh_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","ጌታም ከክፉ ነገር ሁሉ ያድነኛል ለሰማያዊውም መንግሥት ይጠብቀኛል፤ ለእርሱ ከዘላለም እስከ ዘላለም ክብር ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","ለጵርስቅላና ለአቂላ ለሄኔሲፎሩም ቤተ ሰዎች ሰላምታ አቅርብልኝ። ");
INSERT INTO amh_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","ኤርስጦስ በቆሮንቶስ ቀረ፥ ጥሮፊሞስን ግን ታሞ በሚሊጢን ተውሁት። ");
INSERT INTO amh_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","ከክረምት በፊት እንድትመጣ ትጋ። ኤውግሎስና ጱዴስ ሊኖስም ቅላውዲያም ወንድሞችም ሁሉ ሰላምታ ያቀርቡልሃል። ");
INSERT INTO amh_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","ጌታ ኢየሱስ ክርስቶስ ከመንፈስህ ጋር ይሁን። ጸጋ ከእናንተ ጋር ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","3","በዘመኑም ጊዜ፥ መድኃኒታችን እግዚአብሔር እንዳዘዘ፥ ለእኔ አደራ በተሰጠኝ ስብከት ቃሉን ገለጠ፤ ");
INSERT INTO amh_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","በሃይማኖት ኅብረት እውነተኛ ልጄ ለሚሆን ለቲቶ፤ ከእግዚአብሔር አብ ከመድኃኒታችንም ከጌታ ከኢየሱስ ክርስቶስ ጸጋና ምሕረት ሰላምም ይሁን። ");
INSERT INTO amh_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","ስለዚህ ምክንያት የቀረውን እንድታደራጅ በየከተማውም፥ እኔ አንተን እንዳዘዝሁ፥ ሽማግሌዎችን እንድትሾም በቀርጤስ ተውሁህ፤ ");
INSERT INTO amh_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","የማይነቀፍና የአንዲት ሚስት ባል የሚሆን፥ የሚያምኑም ልጆች ያሉት፥ ስለ መዳራትም ወይም ስለ አለመታዘዝ የማይከሰስ ማንም ቢኖር፥ ሹመው። ");
INSERT INTO amh_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","ኤጲስ ቆጶስ፥ እንደ እግዚአብሔር መጋቢ፥ የማይነቀፍ ሊሆን ይገባዋልና፤ የማይኮራ፥ የማይቆጣ፥ የማይሰክር፥ የማይጨቃጨቅ፥ ነውረኛ ረብ የማይወድ፥ ");
INSERT INTO amh_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","ነገር ግን እንግዳ ተቀባይ፥ በጎ የሆነውን ነገር የሚወድ፥ ጠንቃቃ፥ ጻድቅ፥ ቅዱስ፥ ራሱን የሚገዛ ይሁን፤ ");
INSERT INTO amh_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","ሕይወት በሚገኝበት ትምህርት ደግሞ ሊመክር ተቃዋሚዎቹንም ሊወቅስ ይችል ዘንድ፥ እንደተማረው በታመነ ቃል ይጽና። ");
INSERT INTO amh_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","የማይታዘዙና ከንቱ የሚናገሩ የሚያታልሉ ይልቁንም ከተገረዙት ወገን የሚሆኑ ብዙ ናቸውና፤ ");
INSERT INTO amh_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","እነዚህም ስለ ነውረኛ ረብ የማይገባውን እያስተማሩ ቤቶችን በሞላው ስለ ሚገለብጡ፥ አፋቸውን መዝጋት ይገባል። ");
INSERT INTO amh_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","የገዛ ራሳቸው ነቢይ የሆነ ከእነርሱ አንዱ። የቀርጤስ ሰዎች ዘወትር ውሸተኞች፥ ክፉዎች አራዊት፥ በላተኞች፥ ሥራ ፈቶች ናቸው ብሎአል። ");
INSERT INTO amh_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","15","ሁሉ ለንጹሖች ንጹሕ ነው፤ ለርኵሳንና ለማያምኑ ግን ንጹሕ የሆነ ምንም የለም፥ ነገር ግን አእምሮአቸውም ሕሊናቸውም ረክሶአል። ");
INSERT INTO amh_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","እግዚአብሔርን እንዲያውቁ በግልጥ ይናገራሉ፥ ዳሩ ግን የሚያስጸይፉና የማይታዘዙ ለበጎ ሥራም ሁሉ የማይበቁ ስለ ሆኑ፥ በሥራቸው ይክዱታል። ");
INSERT INTO amh_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","አንተ ግን ሕይወት ለሚገኝበት ትምህርት የሚገባውን ተናገር። ");
INSERT INTO amh_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","ሽማግሌዎች ልከኞች፥ ጭምቶች፥ ራሳቸውን የሚገዙ፥ በእምነትና በፍቅር በመጽናትም ጤናሞች እንዲሆኑ ምከራቸው፤ ");
INSERT INTO amh_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","እንዲሁም አሮጊቶች ሴቶች አካሄዳቸው ለቅዱስ አገልግሎት የሚገባ፥ የማያሙ፥ ለብዙ ወይን ጠጅ የማይገዙ፥ በጎ የሆነውን ነገር የሚያስተምሩ ይሁኑ፤ ");
INSERT INTO amh_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","6","ጎበዞችም እንዲሁ ራሳቸውን እንዲገዙ ምከራቸው። ");
INSERT INTO amh_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","11","ሰዎችን ሁሉ የሚያድን የእግዚአብሔር ጸጋ ተገልጦአልና፤ ");
INSERT INTO amh_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","14","መድኃኒታችንም ከዓመፅ ሁሉ እንዲቤዠን፥ መልካሙንም ለማድረግ የሚቀናውን ገንዘቡም የሚሆነውን ሕዝብ ለራሱ እንዲያነጻ፥ ስለ እኛ ነፍሱን ሰጥቶአል። ");
INSERT INTO amh_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","ይህን በሙሉ ሥልጣን ተናገርና ምከር ገሥጽም፤ ማንም አይናቅህ። ");
INSERT INTO amh_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","3","እኛ ደግሞ አስቀድመን የማናስተውል ነበርንና፤ የማንታዘዝ፥ የምንስት፥ ለምኞትና ለልዩ ልዩ ተድላ እንደ ባሪያዎች የምንገዛ፥ በክፋትና በምቀኝነት የምንኖር፥ የምንጣላ፥ እርስ በርሳችን የምንጠላላ ነበርን። ");
INSERT INTO amh_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","ነገር ግን የመድኃኒታችን የእግዚአብሔር ቸርነትና ሰውን መውደዱ በተገለጠ ጊዜ፥ ");
INSERT INTO amh_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","እንደ ምሕረቱ መጠን ለአዲስ ልደት በሚሆነው መታጠብና በመንፈስ ቅዱስ በመታደስ አዳነን እንጂ፥ እኛ ስላደረግነው በጽድቅ ስለ ነበረው ሥራ አይደለም፤ ");
INSERT INTO amh_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","8","ቃሉ የታመነ ነው። እግዚአብሔርንም የሚያምኑት በመልካም ሥራ በጥንቃቄ እንዲጸኑ፥ እነዚህን አስረግጠህ እንድትናገር እፈቅዳለሁ። ይህ መልካምና ለሰዎች የሚጠቅም ነው፤ ");
INSERT INTO amh_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","ነገር ግን ሞኝነት ካለው ምርመራና ከትውልዶች ታሪክ ከክርክርም ስለ ሕግም ከሚሆን ጠብ ራቅ፤ የማይጠቅሙና ከንቱዎች ናቸውና፤ ");
INSERT INTO amh_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","12","አርጢሞንን ወይም ቲኪቆስን ወደ አንተ ስልክ፥ ወደ ኒቆጵልዮን ወደ እኔ እንድትመጣ ትጋ፤ በዚያ ልከርም ቈርጬአለሁና። ");
INSERT INTO amh_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","ሕግ አዋቂውን ዜማስንና አጵሎስን ምንም እንዳይጎድልባቸው በጉዞአቸው ተግተህ እርዳ። ");
INSERT INTO amh_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","ከወገናችንም ያሉት ደግሞ ፍሬ ቢሶች ሆነው እንዳይቀሩ፥ የግድ ስለሚያስፈልገው ነገር በመልካም ሥራ እንዲጸኑ ይማሩ። ");
INSERT INTO amh_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","ከእኔ ጋር ያሉት ሁሉ ሰላምታ ያቀርቡልሃል። በእምነት ለሚወዱን ሰላምታ አቅርብልን። ጸጋ ከሁላችሁ ጋር ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","የክርስቶስ ኢየሱስ እስር ጳውሎስ ወንድሙም ጢሞቴዎስ፥ ለተወደደውና አብሮን ለሚሠራ ለፊልሞና፥ ");
INSERT INTO amh_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","ለእኅታችንም ለአፍብያ፥ ከእኛም ጋር አብሮ ወታደር ለሆነ ለአርክጳ፥ በቤትህም ላለች ቤተ ክርስቲያን፤ ");
INSERT INTO amh_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","ከእግዚአብሔር ከአባታችን ከጌታም ከኢየሱስ ክርስቶስ ጸጋና ሰላም ለእናንተ ይሁን። ");
INSERT INTO amh_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","6","የእምነትህም ኅብረት፥ በእኛ ዘንድ ያለውን በጎ ነገር ሁሉ በማወቅ፥ ለክርስቶስ ኢየሱስ ፍሬ እንዲያፈራ እለምናለሁ፤ ");
INSERT INTO amh_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","የቅዱሳን ልብ በአንተ ስራ ስለ ዐረፈ፥ ወንድሜ ሆይ፥ በፍቅርህ ብዙ ደስታንና መጽናናትን አግኝቼአለሁና። ");
INSERT INTO amh_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","ስለዚህ የሚገባውን አዝህ ዘንድ በክርስቶስ ምንም እንኳ ብዙ ድፍረት ቢኖረኝ፥ ");
INSERT INTO amh_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","ይልቁንም እንደዚህ የሆንሁ እኔ ጳውሎስ ሽማግሌው፥ አሁንም ደግሞ የኢየሱስ ክርስቶስ እስር የሆንሁ፥ ስለ ፍቅር እለምናለሁ። ");
INSERT INTO amh_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","12","እርሱን እልከዋለሁ፤ ");
INSERT INTO amh_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","አንተም ልቤ እንደሚሆን ተቀበለው። እኔስ በወንጌል እስራት ስለ አንተ እንዲያገለግለኝ ለራሴ ላስቀረው እፈቅድ ነበር፥ ");
INSERT INTO amh_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","ነገር ግን በጎነትህ በፈቃድህ እንጂ በግድ እንዳይሆን፥ ሳልማከርህ ምንም እንኳ ላደርግ አልወደድሁም። ");
INSERT INTO amh_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","ተቀብለህ ለዘላለም እንድትይዘው ስለዚህ ምናልባት ለጊዜው ተለይቶሃልና፤ ");
INSERT INTO amh_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","ከእንግዲህ ወዲህ እንደ ባሪያ አይሆንም፥ ነገር ግን ለእኔ በተለየ የተወደደ ወንድም ከሆነ፥ ለአንተማ ይልቅ በስጋውም በጌታም ዘንድ ከባሪያ የሚሻል የተወደደ ወንድም እንዴት አይሆንም። ");
INSERT INTO amh_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","እንግዲህ እንደ ባልንጀራ ብትቈጥረኝ፥ እንደ እኔ አድርገህ ተቀበለው። ");
INSERT INTO amh_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","በአንዳች ነገር የበደለህ ቢኖር ግን ወይም ብድር ያለበት እንደሆነ፥ ይህን በእኔ ላይ ቍጠር፤ ");
INSERT INTO amh_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","እኔ ጳውሎስ። እኔ እመልሰዋለሁ ብዬ በእጄ እጽፋለሁ፤ ከዚህም በላይ ለእኔ የራስህ ደግሞ ብድር እንዳለብህ አልልህም። ");
INSERT INTO amh_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","አዎን፥ ወንድሜ ሆይ፥ በጌታ እኔ እንድጠቀምብህ ይሁን፤ በክርስቶስ ልቤን አሳርፍልኝ። ");
INSERT INTO amh_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","ከምልህ ይልቅ አብልጠህ እንድታደርግ አውቄ እንድትታዘዝም ታምኜ እጽፍልሃለሁ። ");
INSERT INTO amh_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","ደግሞ ከዚህም ጋር የማስተናገጃ ቤት አዘጋጅልኝ፤ በጸሎታችሁ ለእናንተ እንድሰጥ ተስፋ አደርጋለሁና። ");
INSERT INTO amh_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","በክርስቶስ ኢየሱስ ከእኔ ጋር የታሰረ ኤጳፍራ ");
INSERT INTO amh_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","አብረውኝም የሚሰሩ ማርቆስና አርስጥሮኮስ ዴማስም ሉቃስም ሰላምታ ያቀርቡልሃል። ");
INSERT INTO amh_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","የጌታችን የኢሱስ ክርስቶስ ጸጋ ከመንፈሳችሁ ጋር ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("HB1_1","088_1_1","HEB","1","1","1","ከጥንት ጀምሮ እግዚአብሔር በብዙ ዓይነትና በብዙ ጎዳና ለአባቶቻችን በነቢያት ተናግሮ፥ ");
INSERT INTO amh_vpl VALUES ("HB1_2","088_1_2","HEB","1","2","2","ሁሉን ወራሽ ባደረገው ደግሞም ዓለማትን በፈጠረበት በልጁ በዚህ ዘመን መጨረሻ ለእኛ ተናገረን፤ ");
INSERT INTO amh_vpl VALUES ("HB1_3","088_1_3","HEB","1","3","3","እርሱም የክብሩ መንጸባረቅና የባሕርዩ ምሳሌ ሆኖ፥ ሁሉን በስልጣኑ ቃል እየደገፈ፥ ኃጢአታችንን በራሱ ካነጻ በኋላ በሰማያት በግርማው ቀኝ ተቀመጠ፤ ");
INSERT INTO amh_vpl VALUES ("HB1_4","088_1_4","HEB","1","4","4","ከመላእክት ይልቅ እጅግ የሚበልጥ ስምን በወረሰ መጠን እንዲሁ ከእነርሱ አብዝቶ ይበልጣል። ");
INSERT INTO amh_vpl VALUES ("HB1_5","088_1_5","HEB","1","5","5","ከመላእክትስ። አንተ ልጄ ነህ፥ እኔ ዛሬ ወልጄሃለሁ፥ ደግሞም። እኔ አባት እሆነዋለሁ እርሱም ልጅ ይሆነኛል ");
INSERT INTO amh_vpl VALUES ("HB1_6","088_1_6","HEB","1","6","6","ያለው ከቶ ለማን ነው? ደግሞም በኵርን ወደ ዓለም ሲያገባ። የእግዚአብሔር መላእክት ሁሉም ለእርሱ ይስገዱ ይላል። ");
INSERT INTO amh_vpl VALUES ("HB1_7","088_1_7","HEB","1","7","7","ስለ መላእክትም። መላእክቱን መናፍስት አገልጋዮቹንም የእሳት ነበልባል የሚያደርግ ");
INSERT INTO amh_vpl VALUES ("HB1_8","088_1_8","HEB","1","8","8","ይላል፤ ስለ ልጁ ግን። አምላክ ሆይ፥ ዙፋንህ እስከ ዘላለም ድረስ ይኖራል፤ የመንግሥትህ በትር የቅንነት በትር ነው። ");
INSERT INTO amh_vpl VALUES ("HB1_9","088_1_9","HEB","1","9","9","ጽድቅን ወደድህ ዓመፅንም ጠላህ፤ ስለዚህ እግዚአብሔር አምላክህ ከጓደኞችህ ይልቅ በደስታ ዘይት ቀባህ ");
INSERT INTO amh_vpl VALUES ("HB1_10","088_1_10","HEB","1","10","10","ይላል። ደግሞ። ጌታ ሆይ፥ አንተ ከጥንት ምድርን መሠረትህ፥ ሰማዮችም የእጆችህ ሥራ ናቸው፤ ");
INSERT INTO amh_vpl VALUES ("HB1_11","088_1_11","HEB","1","11","11","እነርሱም ይጠፋሉ አንተ ግን ጸንተህ ትኖራለህ፤ ሁሉም እንደ ልብስ ያረጃሉ፥ ");
INSERT INTO amh_vpl VALUES ("HB1_12","088_1_12","HEB","1","12","12","እንደ መጎናጸፊያም ትጠቀልላቸዋለህ ይለወጡማል፤ አንተ ግን አንተ ነህ፥ ዓመቶችህም ከቶ አያልቁም ");
INSERT INTO amh_vpl VALUES ("HB1_13","088_1_13","HEB","1","13","13","ይላል። ነገር ግን ከመላእክት። ጠላቶችህን የእግርህ መረገጫ እስካደርግልህ ድረስ በቀኜ ተቀመጥ ");
INSERT INTO amh_vpl VALUES ("HB1_14","088_1_14","HEB","1","14","14","ከቶ ለማን ብሎአል? ሁሉ መዳንን ይወርሱ ዘንድ ስላላቸው ለማገዝ የሚላኩ የሚያገለግሉም መናፍስት አይደሉምን? ");
INSERT INTO amh_vpl VALUES ("HB2_1","088_2_1","HEB","2","1","1","ስለዚህ ከሰማነው ነገር ምናልባት እንዳንወሰድ፥ ለእርሱ አብልጠን ልንጠነቀቅ ያስፈልገናል። ");
INSERT INTO amh_vpl VALUES ("HB2_2","088_2_2","HEB","2","2","2","በመላእክት የተነገረው ቃል ጽኑ ከሆነ፥ መተላለፍና አለመታዘዝም ሁሉ የጽድቅን ብድራት ከተቀበለ፥ እኛስ እንዲህ ያለውን ታላቅ መዳን ቸል ብንለው፥ እንዴት እናመልጣለን? ");
INSERT INTO amh_vpl VALUES ("HB2_3","088_2_3","HEB","2","3","3","ይህ በጌታ በመጀመሪያ የተነገረ ነበርና፥ የሰሙትም ለእኛ አጸኑት፥ ");
INSERT INTO amh_vpl VALUES ("HB2_4","088_2_4","HEB","2","4","4","እግዚአብሔርም እርሱ ራሱ እንደ ፈቀደ በምልክትና በድንቅ ነገር በልዩ ልዩ ተአምራትም፥ መንፈስ ቅዱስንም በማደል አብሮ መሰከረለት። ");
INSERT INTO amh_vpl VALUES ("HB2_5","088_2_5","HEB","2","5","5","ስለ እርሱ የምንናገርበትን የሚመጣውን ዓለም ለመላእክት ያስገዛው አይደለምና። ");
INSERT INTO amh_vpl VALUES ("HB2_6","088_2_6","HEB","2","6","6","ነገር ግን አንዱ በአንድ ስፍራ። ታስበው ዘንድ ሰው ምንድር ነው? ወይስ ትጎበኘው ዘንድ የሰው ልጅ ምንድር ነው? ");
INSERT INTO amh_vpl VALUES ("HB2_7","088_2_7","HEB","2","7","7","ከመላእክት ይልቅ በጥቂት አሳነስኸው፤ የክብርና የምስጋና ዘውድ ጫንህለት፥ በእጆችህም ሥራ ላይ ሾምኸው፤ ");
INSERT INTO amh_vpl VALUES ("HB2_8","088_2_8","HEB","2","8","8","ሁሉን ከእግሮቹ በታች አስገዛህለት ብሎ መሰከረ። ሁሉን ከእርሱ በታች ባስገዛ ጊዜ ያልተገዛለት ምንም አልተወምና። አሁን ግን ሁሉ እንደ ተገዛለት ገና አናይም፤ ");
INSERT INTO amh_vpl VALUES ("HB2_9","088_2_9","HEB","2","9","9","ነገር ግን በእግዚአብሔር ጸጋ ስለ ሰው ሁሉ ሞትን ይቀምስ ዘንድ፥ ከመላእክት ይልቅ በጥቂት አንሶ የነበረውን ኢየሱስን ከሞት መከራ የተነሣ የክብርና የምስጋናን ዘውድ ተጭኖ እናየዋለን። ");
INSERT INTO amh_vpl VALUES ("HB2_10","088_2_10","HEB","2","10","10","ብዙ ልጆችን ወደ ክብር ሲያመጣ የመዳናቸውን ራስ በመከራ ይፈጽም ዘንድ፥ ከእርሱ የተነሣ ሁሉ በእርሱም ሁሉ ለሆነ፥ ለእርሱ ተገብቶታልና። ");
INSERT INTO amh_vpl VALUES ("HB2_11","088_2_11","HEB","2","11","13","ስለዚህም ምክንያት። ስምህን ለወንድሞቼ እነግራቸዋለሁ በማኅበርም መካከል በዜማ አመሰግንሃለሁ፤ ደግሞም። እኔ በእርሱ እታመናለሁ፤ ደግሞም። እነሆኝ እኔን እግዚአብሔር የሰጠኝንም ልጆች ሲል ወንድሞች ብሎ ሊጠራቸው አያፍርም። ");
INSERT INTO amh_vpl VALUES ("HB2_14","088_2_14","HEB","2","14","16","የአብርሃምን ዘር ይዞአል እንጂ የያዘው የመላእክትን አይደለም። ");
INSERT INTO amh_vpl VALUES ("HB2_17","088_2_17","HEB","2","17","17","ስለዚህ የሕዝብን ኃጢአት ለማስተስረይ፥ ለእግዚአብሔር በሆነው ነገር ሁሉ የሚምርና የታመነ ሊቀ ካህናት እንዲሆን፥ በነገር ሁሉ ወንድሞቹን ሊመስል ተገባው። ");
INSERT INTO amh_vpl VALUES ("HB2_18","088_2_18","HEB","2","18","18","እርሱ ራሱ ተፈትኖ መከራን ስለ ተቀበለ የሚፈተኑትን ሊረዳቸው ይችላልና። ");
INSERT INTO amh_vpl VALUES ("HB3_1","088_3_1","HEB","3","1","1","ስለዚህ፥ ከሰማያዊው ጥሪ ተካፋዮች የሆናችሁ ቅዱሳን ወንድሞች ሆይ፥ የሃይማኖታችንን ሐዋርያና ሊቀ ካህናት ኢየሱስ ክርስቶስን ተመልከቱ፤ ");
INSERT INTO amh_vpl VALUES ("HB3_2","088_3_2","HEB","3","2","2","ሙሴ ደግሞ በቤቱ ሁሉ የታመነ እንደሆነ፥ እርሱ ለሾመው የታመነ ነበረ። ");
INSERT INTO amh_vpl VALUES ("HB3_3","088_3_3","HEB","3","3","3","ቤትን የሚያዘጋጀው ከቤቱ ይልቅ የሚበልጥ ክብር እንዳለው መጠን፥ እንዲሁ እርሱ ከሙሴ ይልቅ የሚበልጥ ክብር የተገባው ሆኖ ተቆጥሮአልና። ");
INSERT INTO amh_vpl VALUES ("HB3_4","088_3_4","HEB","3","4","4","እያንዳንዱ ቤት በአንድ ሰው ተዘጋጅቶአልና፥ ሁሉን ያዘጋጀ ግን እግዚአብሔር ነው። ");
INSERT INTO amh_vpl VALUES ("HB3_5","088_3_5","HEB","3","5","5","ሙሴስ በኋላ ስለሚነገረው ነገር ምስክር ሊሆን በቤቱ ሁሉ እንደ ሎሌ የታመነ ነበረ፥ ክርስቶስ ግን እንደ ልጅ በቤቱ ላይ የታመነ ነው፤ ");
INSERT INTO amh_vpl VALUES ("HB3_6","088_3_6","HEB","3","6","6","እኛም የምንደፍርበትን የምንመካበትንም ተስፋ እስከ መጨረሻው አጽንተን ብንጠብቅ ቤቱ ነን። ");
INSERT INTO amh_vpl VALUES ("HB3_7","088_3_7","HEB","3","7","7","ስለዚህ መንፈስ ቅዱስ እንደሚል። ");
INSERT INTO amh_vpl VALUES ("HB3_8","088_3_8","HEB","3","8","10","ስለዚህ ያን ትውልድ ተቆጥቼ። ዘወትር በልባቸው ይስታሉ መንገዴን ግን አላወቁም አልሁ፤ ");
INSERT INTO amh_vpl VALUES ("HB3_11","088_3_11","HEB","3","11","11","እንዲሁ። ወደ ዕረፍቴ አይገቡም ብዬ በቍጣዬ ማልሁ። ");
INSERT INTO amh_vpl VALUES ("HB3_12","088_3_12","HEB","3","12","12","ወንድሞች ሆይ፥ ምናልባት ሕያው እግዚአብሔርን የሚያስክዳችሁ ክፉና የማያምን ልብ ከእናንተ በአንዳችሁ እንዳይኖር ተጠንቀቁ፤ ");
INSERT INTO amh_vpl VALUES ("HB3_13","088_3_13","HEB","3","13","13","ነገር ግን ከእናንተ ማንም በኃጢአት መታለል እልከኛ እንዳይሆን፥ ዛሬ ተብሎ ሲጠራ ሳለ፥ በእያንዳንዱ ቀን እርስ በርሳችሁ ተመካከሩ፤ ");
INSERT INTO amh_vpl VALUES ("HB3_14","088_3_14","HEB","3","14","14","የመጀመሪያ እምነታችንን እስከ መጨረሻው አጽንተን ብንጠብቅ፥ የክርስቶስ ተካፋዮች ሆነናልና፤ ");
INSERT INTO amh_vpl VALUES ("HB3_15","088_3_15","HEB","3","15","15","እየተባለ። ዛሬ ድምጹን ብትሰሙት፥ በማስመረር እንደሆነ ልባችሁን እልከኛ አታድርጉ። ");
INSERT INTO amh_vpl VALUES ("HB3_16","088_3_16","HEB","3","16","16","ሰምተው ያስመረሩት እነማን ነበሩ? በሙሴ ተመርተው ከግብጽ የወጡ ሁሉ አይደሉምን? ");
INSERT INTO amh_vpl VALUES ("HB3_17","088_3_17","HEB","3","17","17","አርባ አመትም የተቆጣባቸው እነማን ነበሩ? ሬሳቸው በምድረ በዳ የወደቀ፥ ኃጢአትን ያደረጉት እነርሱ አይደሉምን? ");
INSERT INTO amh_vpl VALUES ("HB3_18","088_3_18","HEB","3","18","18","ካልታዘዙትም በቀር ወደ እረፍቱ እንዳይገቡ የማለባቸው እነማን ነበሩ? ");
INSERT INTO amh_vpl VALUES ("HB3_19","088_3_19","HEB","3","19","19","ባለማመናቸውም ጠንቅ ሊገቡ እንዳልተቻላቸው እናያለን። ");
INSERT INTO amh_vpl VALUES ("HB4_1","088_4_1","HEB","4","1","1","እንግዲህ ወደ ዕረፍቱ ለመግባት ተስፋ ገና ቀርቶልን ከሆነ፥ ምናልባት ከእናንተ ማንም የማይበቃ መስሎ እንዳይታይ እንፍራ። ");
INSERT INTO amh_vpl VALUES ("HB4_2","088_4_2","HEB","4","2","2","ለእነዚያ ደግሞ እንደ ተነገረ ለእኛ የምስራች ተሰብኮልናልና፤ ዳሩ ግን የሰሙት ቃል ከሰሚዎቹ ጋር በእምነት ስላልተዋሐደ አልጠቀማቸውም። ");
INSERT INTO amh_vpl VALUES ("HB4_3","088_4_3","HEB","4","3","3","ሥራው ዓለም ከተፈጠረ ጀምሮ ምንም እንኳ ቢፈጸም። እንዲህ። ወደ ዕረፍቴ አይገቡም ብዬ በቁጣዬ ማልሁ እንዳለ፥ እኛስ ያመንን ወደ ዕረፍቱ እንገባለን። ");
INSERT INTO amh_vpl VALUES ("HB4_4","088_4_4","HEB","4","4","4","ስለ ሰባተኛው ቀን በአንድ ስፍራ። እግዚአብሔርም በሰባተኛው ቀን ከሥራው ሁሉ ዐረፈ ብሎአልና፤ ");
INSERT INTO amh_vpl VALUES ("HB4_5","088_4_5","HEB","4","5","5","በዚህ ስፍራም ደግሞ። ወደ ዕረፍቴ አይገቡም። ");
INSERT INTO amh_vpl VALUES ("HB4_6","088_4_6","HEB","4","6","6","እንግዲህ አንዳንዶች በዚያ እንዲገቡ ስለ ቀሩ፥ ቀድሞም የምስራች የተሰበከላቸው ባለመታዘዝ ጠንቅ ስላልገቡ። ");
INSERT INTO amh_vpl VALUES ("HB4_7","088_4_7","HEB","4","7","7","ዛሬ ድምፁን ብትሰሙት ልባችሁን እልከኛ አታድርጉ በፊት እንደ ተባለ፥ ይህን ከሚያህል ዘመን በኋላ በዳዊት ሲናገር። ዛሬ ብሎ አንድ ቀን እንደ ገና ይቀጥራል። ");
INSERT INTO amh_vpl VALUES ("HB4_8","088_4_8","HEB","4","8","8","ኢያሱ አሳርፎአቸው ኖሮ ቢሆንስ፥ ከዚያ በኋላ ስለ ሌላ ቀን ባልተናገረ ነበር። ");
INSERT INTO amh_vpl VALUES ("HB4_9","088_4_9","HEB","4","9","9","እንግዲያስ የሰንበት ዕረፍት ለእግዚአብሔር ሕዝብ ቀርቶላቸዋል። ");
INSERT INTO amh_vpl VALUES ("HB4_10","088_4_10","HEB","4","10","10","ወደ ዕረፍቱ የገባ፥ እግዚአብሔር ከሥራው እንዳረፈ፥ እርሱ ደግሞ ከሥራው አርፎአልና። ");
INSERT INTO amh_vpl VALUES ("HB4_11","088_4_11","HEB","4","11","11","እንግዲህ እንደዚያ እንደ አለመታዘዝ ምሳሌ ማንም እንዳይወድቅ ወደዚያ ዕረፍት ለመግባት እንትጋ። ");
INSERT INTO amh_vpl VALUES ("HB4_12","088_4_12","HEB","4","12","12","የእግዚአብሔር ቃል ሕያው ነውና፥ የሚሠራም፥ ሁለትም አፍ ካለው ሰይፍ ሁሉ ይልቅ የተሳለ ነው፥ ነፍስንና መንፈስንም ጅማትንና ቅልጥምንም እስኪለይ ድረስ ይወጋል፥ የልብንም ስሜትና አሳብ ይመረምራል፤ ");
INSERT INTO amh_vpl VALUES ("HB4_13","088_4_13","HEB","4","13","13","እኛን በሚቆጣጠር በእርሱ ዓይኖቹ ፊት ሁሉ ነገር የተራቆተና የተገለጠ ነው እንጂ፥ በእርሱ ፊት የተሰወረ ፍጥረት የለም። ");
INSERT INTO amh_vpl VALUES ("HB4_14","088_4_14","HEB","4","14","14","እንግዲህ በሰማያት ያለፈ ትልቅ ሊቀ ካህናት የእግዚአብሔር ልጅ ኢየሱስ ስላለን፥ ጸንተን ሃይማኖታችንን እንጠብቅ። ");
INSERT INTO amh_vpl VALUES ("HB4_15","088_4_15","HEB","4","15","15","ከኃጢአት በቀር በነገር ሁሉ እንደ እኛ የተፈተነ ነው እንጂ፥ በድካማችን ሊራራልን የማይችል ሊቀ ካህናት የለንም። ");
INSERT INTO amh_vpl VALUES ("HB4_16","088_4_16","HEB","4","16","16","እንግዲህ ምሕረትን እንድንቀበል በሚያስፈልገንም ጊዜ የሚረዳንን ጸጋ እንድናገኝ ወደ ጸጋው ዙፋን በእምነት እንቅረብ። ");
INSERT INTO amh_vpl VALUES ("HB5_1","088_5_1","HEB","5","1","1","ሊቀ ካህናት ሁሉ ስለ ኃጢአት መባንና መስዋዕትን ሊያቀርብ ከሰው ተመርጦ ለእግዚአብሔር በሆነው ነገር ሁሉ ስለ ሰው ይሾማልና፤ ");
INSERT INTO amh_vpl VALUES ("HB5_2","088_5_2","HEB","5","2","2","እርሱ ራሱም ደግሞ ድካምን ስለሚለብስ፥ ላልተማሩትና ለሚስቱት ሊራራላቸው ይችላል፤ ");
INSERT INTO amh_vpl VALUES ("HB5_3","088_5_3","HEB","5","3","3","በዚህም ምክንያት ስለ ሕዝብ እንደሚያቀርብ እንዲሁ ስለ ራሱ ደግሞ መስዋዕትን ስለ ኃጢአት ሊያቀርብ ይገባዋል። ");
INSERT INTO amh_vpl VALUES ("HB5_4","088_5_4","HEB","5","4","4","እንደ አሮንም በእግዚአብሔር ከተጠራ በቀር ማንም ክብሩን ለራሱ የሚወስድ የለም። ");
INSERT INTO amh_vpl VALUES ("HB5_5","088_5_5","HEB","5","5","5","እንዲሁ ክርስቶስ ደግሞ ሊቀ ካህናት ሊሆን ራሱን አላከበረም ነገር ግን። አንተ ልጄ ነህ እኔ ዛሬ ወልጄሃለሁ ያለው እርሱ ነው፤ ");
INSERT INTO amh_vpl VALUES ("HB5_6","088_5_6","HEB","5","6","6","እንደዚህም በሌላ ስፍራ ደግሞ። አንተ እንደ መልከ ጼዴቅ ሹመት ለዘላለም ካህን ነህ ይላል። ");
INSERT INTO amh_vpl VALUES ("HB5_7","088_5_7","HEB","5","7","7","እርሱም በስጋው ወራት ከሞት ሊያድነው ወደሚችል ከብርቱ ጩኸትና ከእንባ ጋር ጸሎትንና ምልጃን አቀረበ፥ እግዚአብሔርንም ስለ መፍራቱ ተሰማለት፤ ");
INSERT INTO amh_vpl VALUES ("HB5_8","088_5_8","HEB","5","8","8","ምንም ልጅ ቢሆን፥ ከተቀበለው መከራ መታዘዝን ተማረ፤ ");
INSERT INTO amh_vpl VALUES ("HB5_9","088_5_9","HEB","5","9","11","ስለ እርሱም የምንናገረው ብዙ ነገር አለን፥ ጆሮቻችሁም ስለ ፈዘዙ በቃል ልንተረጕመው ጭንቅ ነው። ");
INSERT INTO amh_vpl VALUES ("HB5_12","088_5_12","HEB","5","12","12","ከጊዜው የተነሳ አስተማሪዎች ልትሆኑ ሲገባችሁ፥ አንድ ሰው ስለ እግዚአብሔር ቃላት መጀመሪያ ያለውን የሕፃንነትን ትምህርት እንዲያስተምራችሁ እንደ ገና ያስፈልጋችኋልና፤ የሚያስፈልጋችሁም ወተት ነው እንጂ ጠንካራ ምግብ አይደለም። ");
INSERT INTO amh_vpl VALUES ("HB5_13","088_5_13","HEB","5","13","13","ወተት የሚጋት ሁሉ ሕፃን ስለ ሆነ የጽድቅን ቃል አያውቅምና፤ ");
INSERT INTO amh_vpl VALUES ("HB5_14","088_5_14","HEB","5","14","14","ጠንካራ ምግብ ግን መልካሙንና ክፉውን ለመለየት በስራቸው የለመደ ልቡና ላላቸው ለፍጹማን ሰዎች ነው። ");
INSERT INTO amh_vpl VALUES ("HB6_1","088_6_1","HEB","6","1","3","እግዚአብሔርም ቢፈቅድ ይህን እናደርጋለን። ");
INSERT INTO amh_vpl VALUES ("HB6_4","088_6_4","HEB","6","4","4","አንድ ጊዜ ብርሃን የበራላቸውን ሰማያዊውንም ስጦታ የቀመሱትን ከመንፈስ ቅዱስም ተካፋዮች ሆነው የነበሩትን ");
INSERT INTO amh_vpl VALUES ("HB6_5","088_6_5","HEB","6","5","5","መልካሙንም የእግዚአብሔርን ቃልና ሊመጣ ያለውን የዓለም ኃይል የቀመሱትን ");
INSERT INTO amh_vpl VALUES ("HB6_6","088_6_6","HEB","6","6","6","በኋላም የካዱትን እንደገና ለንስሐ እነርሱን ማደስ የማይቻል ነው፤ ለራሳቸው የእግዚአብሔርን ልጅ ይሰቅሉታልና ያዋርዱትማልና። ");
INSERT INTO amh_vpl VALUES ("HB6_7","088_6_7","HEB","6","7","7","ብዙ ጊዜ በእርስዋ ላይ የሚወርደውን ዝናብ የምትጠጣ መሬት፥ ለሚያርሱአትም ደግሞ የምትጠቅምን አትክልት የምታበቅል፥ ከእግዚአብሔር በረከትን ታገኛለችና፤ ");
INSERT INTO amh_vpl VALUES ("HB6_8","088_6_8","HEB","6","8","8","እሾህና ኵርንችትን ግን ብታወጣ፥ የተጣለች ናት ለመረገምም ትቀርባለች፥ መጨረሻዋም መቃጠል ነው። ");
INSERT INTO amh_vpl VALUES ("HB6_9","088_6_9","HEB","6","9","9","ስለ እናንተ ግን፥ ወዳጆች ሆይ፥ ምንም እንኳ እንዲሁ ብንናገር፥ አብልጦ የሚሻለውና ለመዳን የሚሆነው እንዲሆንላችሁ ተረድተናል። ");
INSERT INTO amh_vpl VALUES ("HB6_10","088_6_10","HEB","6","10","10","እግዚአብሔር፥ ቅዱሳንን ስላገለገላችሁ እስከ አሁንም ስለምታገለግሉአቸው፥ ያደረጋችሁትን ሥራ ለስሙም ያሳያችሁትን ፍቅር ይረሳ ዘንድ ዓመፀኛ አይደለምና። ");
INSERT INTO amh_vpl VALUES ("HB6_11","088_6_11","HEB","6","11","15","እንዲሁም እርሱ ከታገሰ በኋላ ተስፋውን አገኘ። ");
INSERT INTO amh_vpl VALUES ("HB6_16","088_6_16","HEB","6","16","16","ሰዎች ከእነርሱ በሚበልጠው ይምላሉና፥ ለማስረዳትም የሆነው መሐላ የሙግት ሁሉ ፍጻሜ ይሆናል፤ ");
INSERT INTO amh_vpl VALUES ("HB6_17","088_6_17","HEB","6","17","19","ይህም ተስፋ እንደ ነፍስ መልሕቅ አለን እርሱም እርግጥና ጽኑ የሆነ ወደ መጋረጃውም ውስጥ የገባ ነው፤ ");
INSERT INTO amh_vpl VALUES ("HB6_20","088_6_20","HEB","6","20","20","በዚያም ኢየሱስ እንደ መልከ ጼዴቅ ሹመት ለዘላለም ሊቀ ካህናት የሆነው፥ ስለ እኛ ቀዳሚ ሆኖ ገባ። ");
INSERT INTO amh_vpl VALUES ("HB7_1","088_7_1","HEB","7","1","1","የሳሌም ንጉሥና የልዑል እግዚአብሔር ካህን የሆነ ይህ መልከ ጼዴቅ አብርሃም ነገሥታትን ገድሎ ሲመለስ ከእርሱ ጋር ተገናኝቶ ባረከው፤ ");
INSERT INTO amh_vpl VALUES ("HB7_2","088_7_2","HEB","7","2","2","ለእርሱም ደግሞ አብርሃም ከሁሉ አስራትን አካፈለው። የስሙም ትርጓሜ በመጀመሪያ የጽድቅ ንጉሥ ነው፥ ኋላም ደግሞ የሳሌም ንጉሥ ማለት የሰላም ንጉሥ ነው። ");
INSERT INTO amh_vpl VALUES ("HB7_3","088_7_3","HEB","7","3","3","አባትና እናት የትውልድም ቍጥር የሉትም፥ ለዘመኑም ጥንት ለህይወቱም ፍጻሜ የለውም፥ ዳሩ ግን በእግዚአብሔር ልጅ ተመስሎ ለዘላለም ካህን ሆኖ ይኖራል። ");
INSERT INTO amh_vpl VALUES ("HB7_4","088_7_4","HEB","7","4","4","የአባቶች አለቃ አብርሃም ከዘረፋው የሚሻለውን አስራት የሰጠው ይህ ሰው እንዴት ትልቅ እንደ ነበረ እስኪ ተመልከቱ። ");
INSERT INTO amh_vpl VALUES ("HB7_5","088_7_5","HEB","7","5","5","ከሌዊ ልጆችም ክህነትን የሚቀበሉት ከህዝቡ ማለት ከወንድሞቻቸው፥ እነርሱ ምንም ከአብርሃም ወገብ ቢወጡ፥ ከእነርሱ አሥራትን በሕግ እንዲያስወጡ ትእዛዝ አላቸው፤ ");
INSERT INTO amh_vpl VALUES ("HB7_6","088_7_6","HEB","7","6","6","ትውልዱ ከእነርሱ የማይቈጠረው ግን ከአብርሃም አሥራትን አውጥቶአል፥ የተስፋ ቃል የነበረውንም ባርኮአል። ");
INSERT INTO amh_vpl VALUES ("HB7_7","088_7_7","HEB","7","7","7","ትንሹም በታላቁ እንዲባረክ ክርክር የሌለበት ነገር ነው። ");
INSERT INTO amh_vpl VALUES ("HB7_8","088_7_8","HEB","7","8","8","በዚህስ የሚሞቱ ሰዎች አሥራትን ያስወጣሉ፥ በዚያ ግን የሚያስወጣ በሕይወት እንዲኖር የተመሰከረለት እርሱ ነው። ");
INSERT INTO amh_vpl VALUES ("HB7_9","088_7_9","HEB","7","9","9","ይህንም ለማለት ሲፈቀድ፥ አሥራትን የሚያስወጣ ሌዊ እንኳ በአብርሃም እጅ አሥራትን ሰጥቶአል፤ ");
INSERT INTO amh_vpl VALUES ("HB7_10","088_7_10","HEB","7","10","10","መልከ ጼዴቅ በተገናኘው ጊዜ ገና በአባቱ ወገብ ነበረና። ");
INSERT INTO amh_vpl VALUES ("HB7_11","088_7_11","HEB","7","11","11","እንግዲህ ህዝቡ በሌዊ ክህነት የተመሠረተን ሕግ ተቀብለዋልና በዚያ ክህነት ፍጹምነት የተገኘ ቢሆን፥ እንደ አሮን ሹመት የማይቈጠር፥ እንደ መልከ ጼዴቅ ሹመት ግን የሆነ ሌላ ካህን ሊነሳ ወደፊት ስለ ምን ያስፈልጋል? ");
INSERT INTO amh_vpl VALUES ("HB7_12","088_7_12","HEB","7","12","12","ክህነቱ ሲለወጥ፥ ሕጉ ደግሞ ሊለወጥ የግድ ነውና። ");
INSERT INTO amh_vpl VALUES ("HB7_13","088_7_13","HEB","7","13","13","ይህ ነገር የተነገረለት እርሱ በሌላ ወገን ተካፍሎአልና፥ ከዚያም መሠዊያውን ያገለገለ ማንም የለም፤ ");
INSERT INTO amh_vpl VALUES ("HB7_14","088_7_14","HEB","7","14","14","ጌታችን ከይሁዳ ነገድ እንደወጣ የተገለጠ ነውና፥ ስለዚህም ነገድ ሙሴ ምንም እንኳ ስለ ክህነት አልተናገረም። ");
INSERT INTO amh_vpl VALUES ("HB7_15","088_7_15","HEB","7","15","17","አንተ እንደ መልከ ጼዴቅ ሹመት ለዘላለም ካህን ነህ ብሎ ይመሰክራልና። ");
INSERT INTO amh_vpl VALUES ("HB7_18","088_7_18","HEB","7","18","22","እንዲሁ ኢየሱስ ለሚሻል ኪዳን ዋስ ሆኖአል። ");
INSERT INTO amh_vpl VALUES ("HB7_23","088_7_23","HEB","7","23","23","እነርሱም እንዳይኖሩ ሞት ስለ ከለከላቸው ካህናት የሆኑት ብዙ ናቸው፤ ");
INSERT INTO amh_vpl VALUES ("HB7_24","088_7_24","HEB","7","24","24","እርሱ ግን ለዘላለም የሚኖር ስለሆነ የማይለወጥ ክህነት አለው፤ ");
INSERT INTO amh_vpl VALUES ("HB7_25","088_7_25","HEB","7","25","25","ስለ እነርሱም ሊያማልድ ዘወትር በሕይወት ይኖራልና ስለዚህ ደግሞ በእርሱ ወደ እግዚአብሔር የሚመጡትን ፈጽሞ ሊያድናቸው ይችላል። ");
INSERT INTO amh_vpl VALUES ("HB7_26","088_7_26","HEB","7","26","26","ቅዱስና ያለ ተንኮል ነውርም የሌለበት ከኃጢአተኞችም የተለየ ከሰማያትም ከፍ ከፍ ያለ፥ እንደዚህ ያለ ሊቀ ካህናት ይገባልና፤ ");
INSERT INTO amh_vpl VALUES ("HB7_27","088_7_27","HEB","7","27","27","እርሱም እንደነዚያ ሊቃነ ካህናት አስቀድሞ ስለ ራሱ ኃጢአት በኋላም ስለ ሕዝቡ ኃጢአት ዕለት ዕለት መሥዋዕትን ሊያቀርብ አያስፈልገውም፤ ራሱን ባቀረበ ጊዜ ይህን አንድ ጊዜ ፈጽሞ አድርጎአልና። ");
INSERT INTO amh_vpl VALUES ("HB7_28","088_7_28","HEB","7","28","28","ሕጉ ድካም ያላቸውን ሰዎች ሊቀ ካህናት አድርጎ ይሾማልና፤ ከሕግ በኋላ የመጣ የመሐላው ቃል ግን ለዘላለም ፍጹም የሆነውን ልጅ ይሾማል። ");
INSERT INTO amh_vpl VALUES ("HB8_1","088_8_1","HEB","8","1","1","ከተናገርነውም ዋና ነገሩ ይህ ነው፤ በሰማያት በግርማው ዙፋን ቀኝ የተቀመጠ እንዲህ ያለ ሊቀ ካህናት አለን፤ ");
INSERT INTO amh_vpl VALUES ("HB8_2","088_8_2","HEB","8","2","2","እርሱም የመቅደስና የእውነተኛይቱ ድንኳን አገልጋይ ነው፥ እርስዋም በሰው ሳይሆን በጌታ የተተከለች ናት። ");
INSERT INTO amh_vpl VALUES ("HB8_3","088_8_3","HEB","8","3","3","ሊቀ ካህናት ሁሉ መባንና መሥዋዕትን ሊያቀርብ ይሾማልና፤ ስለዚህም ለዚህ ደግሞ የሚያቀርበው አንዳች ሊኖረው የግድ ነው። ");
INSERT INTO amh_vpl VALUES ("HB8_4","088_8_4","HEB","8","4","4","እንግዲህ በምድር ቢኖርስ፥ እንደ ሕግ መባን የሚያቀርቡት ስላሉ፥ ካህን እንኳ ባልሆነም፤ ");
INSERT INTO amh_vpl VALUES ("HB8_5","088_8_5","HEB","8","5","5","እነርሱም ሙሴ ድንኳኒቱን ሊሠራ ሳለ እንደ ተረዳ፥ ለሰማያዊ ነገር ምሳሌና ጥላ የሚሆነውን ያገለግላሉ። በተራራው እንደ ተገለጠልህ ምሳሌ ሁሉን ታደርግ ዘንድ ተጠንቀቅ ብሎት ነበርና። ");
INSERT INTO amh_vpl VALUES ("HB8_6","088_8_6","HEB","8","6","6","አሁን ግን በሚሻል ተስፋ ቃል በተመሠረተ በሚሻል ኪዳን ደግሞ መካከለኛ እንደሚሆን በዚያ ልክ እጅግ የሚሻል አገልግሎት አግኝቶአል። ");
INSERT INTO amh_vpl VALUES ("HB8_7","088_8_7","HEB","8","7","7","ፊተኛው ኪዳን ነቀፋ ባይኖረው፥ ለሁለተኛው ስፍራ ባልተፈለገም ነበር። ");
INSERT INTO amh_vpl VALUES ("HB8_8","088_8_8","HEB","8","8","8","እነርሱን እየነቀፈ ይላቸዋልና። እነሆ፥ ከእስራኤል ቤትና ከይሁዳ ቤት ጋር አዲስ ኪዳን የምገባበት ወራት ይመጣል ይላል ጌታ፤ ");
INSERT INTO amh_vpl VALUES ("HB8_9","088_8_9","HEB","8","9","9","ከግብፅ አገር አወጣቸው ዘንድ እጃቸውን በያዝሁበት ቀን ከአባቶቻቸው ጋር እንደገባሁት ኪዳን አይደለም፤ እነርሱ በኪዳኔ አልጸኑምና፥ እኔም ቸል አልኋቸው ይላል ጌታ። ");
INSERT INTO amh_vpl VALUES ("HB8_10","088_8_10","HEB","8","10","10","ከዚያ ወራት በኋላ ከእስራኤል ቤት ጋር የምገባው ቃል ኪዳን ይህ ነውና ይላል ጌታ፤ ሕጌን በልቡናቸው አኖራለሁ በልባቸውም እጽፈዋለሁ፥ እኔም አምላክ እሆንላቸዋለሁ እነርሱም ሕዝብ ይሆኑልኛል። ");
INSERT INTO amh_vpl VALUES ("HB8_11","088_8_11","HEB","8","11","11","እያንዳንዱም ጐረቤቱን እያንዳንዱም ወንድሙን። ጌታን እወቅ ብሎ አያስተምርም ከታናሹ ጀምሮ እስከ ታላቁ ድረስ ሁሉ ያውቁኛልና። ");
INSERT INTO amh_vpl VALUES ("HB8_12","088_8_12","HEB","8","12","12","ዓመፃቸውን እምራቸዋለሁና፥ ኃጢአታቸውንም ደግሜ አላስብም። ");
INSERT INTO amh_vpl VALUES ("HB8_13","088_8_13","HEB","8","13","13","አዲስ በማለቱ ፊተኛውን አስረጅቶአል፤ አሮጌና ውራጅ የሆነውስ ሊጠፋ ቀርቦአል። ");
INSERT INTO amh_vpl VALUES ("HB9_1","088_9_1","HEB","9","1","1","ፊተኛይቱም ደግሞ የአገልግሎት ስርዓትና የዚህ ዓለም የሆነው መቅደስ ነበራት። ");
INSERT INTO amh_vpl VALUES ("HB9_2","088_9_2","HEB","9","2","2","የመጀመሪያይቱ ድንኳን ተዘጋጅታ ነበርና፥ በእርስዋም ቅድስት በምትባለው ውስጥ መቅረዙና ጠረጴዛው የመስዋዕቱም ኅብስት ነበረባት፤ ");
INSERT INTO amh_vpl VALUES ("HB9_3","088_9_3","HEB","9","3","3","ከሁለተኛውም መጋረጃ ወዲያ ቅድስተ ቅዱሳን የምትባለው ድንኳን ነበረች፥ ");
INSERT INTO amh_vpl VALUES ("HB9_4","088_9_4","HEB","9","4","4","በዚያም ውስጥ የወርቅ ማዕጠንት ነበረ ሁለንተናዋም በወርቅ የተለበጠች የኪዳን ታቦት፤ በእርስዋም ውስጥ መና ያለባት የወርቅ መሶብና የበቀለች የአሮን በትር የኪዳኑም ጽላት ነበሩ፥ ");
INSERT INTO amh_vpl VALUES ("HB9_5","088_9_5","HEB","9","5","5","በላይዋም ማስተስሪያውን የሚጋርዱ የክብር ኪሩቤል ነበሩ፤ ስለ እነዚህም ስለ እያንዳንዳቸው ልንናገር አሁን አንችልም። ");
INSERT INTO amh_vpl VALUES ("HB9_6","088_9_6","HEB","9","6","6","ይህም እንደዚህ ተዘጋጅቶ ሳለ፥ ካህናት አገልግሎታቸውን እየፈጸሙ ዘወትር በፊተኛይቱ ድንኳን ይገቡባታል፤ ");
INSERT INTO amh_vpl VALUES ("HB9_7","088_9_7","HEB","9","7","7","በሁለተኛይቱ ግን ሊቀ ካህናት ብቻውን በዓመት አንድ ጊዜ ይገባባታል፥ እርሱም ሰለ ራሱና ስለ ሕዝቡ ስሕተት የሚያቀርበውን ደም ሳይዝ አይገባም፤ ");
INSERT INTO amh_vpl VALUES ("HB9_8","088_9_8","HEB","9","8","8","ፊተኛይቱም ድንኳን በዚህ ገና ቆማ ሳለች፥ ወደ ቅድስት የሚወስደው መንገድ ገና እንዳልተገለጠ መንፈስ ቅዱስ ያሳያል። ");
INSERT INTO amh_vpl VALUES ("HB9_9","088_9_9","HEB","9","9","11","ነገር ግን ክርስቶስ ይመጣ ዘንድ ላለው መልካም ነገር ሊቀ ካህናት ሆኖ፥ በምትበልጠውና በምትሻለው በእጆችም ባልተሠራች ማለት ለዚህ ፍጥረት ባልሆነች ድንኳን፥ ");
INSERT INTO amh_vpl VALUES ("HB9_12","088_9_12","HEB","9","12","12","የዘላለምን ቤዛነት አግኝቶ አንድ ጊዜ ፈጽሞ ወደ ቅድስት በገዛ ደሙ ገባ እንጂ በፍየሎችና በጥጆች ደም አይደለም። ");
INSERT INTO amh_vpl VALUES ("HB9_13","088_9_13","HEB","9","13","13","የኮርማዎችና የፍየሎች ደም በረከሱትም ላይ የተረጨ የጊደር አመድ ሥጋን ለማንጻት የሚቀድሱ ከሆኑ፥ ");
INSERT INTO amh_vpl VALUES ("HB9_14","088_9_14","HEB","9","14","14","ነውር የሌለው ሆኖ በዘላለም መንፈስ ራሱን ለእግዚአብሔር ያቀረበ የክርስቶስ ደም እንዴት ይልቅ ሕያውን እግዚአብሔርን ልታመልኩ ከሞተ ሥራ ሕሊናችሁን ያነጻ ይሆን? ");
INSERT INTO amh_vpl VALUES ("HB9_15","088_9_15","HEB","9","15","15","ስለዚህም የፊተኛው ኪዳን ሲጸና ሕግን የተላለፉትን የሚቤዥ ሞት ስለ ሆነ፥ የተጠሩት የዘላለምን ርስት የተስፋ ቃል እንዲቀበሉ እርሱ የአዲስ ኪዳን መካከለኛ ነው። ");
INSERT INTO amh_vpl VALUES ("HB9_16","088_9_16","HEB","9","16","16","ኑዛዜ ያለ እንደሆነ የተናዛዡን ሞት ማርዳት የግድ ነውና፤ ");
INSERT INTO amh_vpl VALUES ("HB9_17","088_9_17","HEB","9","17","17","ሰው ሲሞት ኑዛዜው ይጸናልና፥ ተናዛዡ በሕይወት ሲኖር ግን ከቶ አይጠቅምም። ");
INSERT INTO amh_vpl VALUES ("HB9_18","088_9_18","HEB","9","18","18","ስለዚህም ፊተኛው ኪዳን እንኳ ያለ ደም አልተመረቀም። ");
INSERT INTO amh_vpl VALUES ("HB9_19","088_9_19","HEB","9","19","21","እንዲሁም በድንኳኒቱና በማገልገያው ዕቃ ሁሉ ደምን ረጨ። ");
INSERT INTO amh_vpl VALUES ("HB9_22","088_9_22","HEB","9","22","22","እንደ ሕጉም ከጥቂቶች በቀር ነገር ሁሉ በደም ይነጻል፥ ደምም ሳይፈስ ስርየት የለም። ");
INSERT INTO amh_vpl VALUES ("HB9_23","088_9_23","HEB","9","23","23","እንግዲህ በሰማያት ያሉትን የሚመስለው ነገር በዚህ ሊነጻ እንጂ በሰማያት ያሉቱ ራሳቸው ከእርሱ ይልቅ በሚበልጥ መስዋዕት ሊነጹ የግድ ነበረ። ");
INSERT INTO amh_vpl VALUES ("HB9_24","088_9_24","HEB","9","24","24","ክርስቶስ በእጅ ወደ ተሰራች፥ የእውነተኛይቱ ምሳሌ ወደ ምትሆን ቅድስት አልገባምና፥ ነገር ግን በእግዚአብሔር ፊት ስለ እኛ አሁን ይታይ ዘንድ ወደ እርስዋ ወደ ሰማይ ገባ። ");
INSERT INTO amh_vpl VALUES ("HB9_25","088_9_25","HEB","9","25","25","ሊቀ ካህናትም በየዓመቱ የሌላውን ደም ይዞ ወደ ቅድስት እንደሚገባ፥ ራሱን ብዙ ጊዜ ሊያቀርብ አልገባም፤ ");
INSERT INTO amh_vpl VALUES ("HB9_26","088_9_26","HEB","9","26","26","እንዲህ ቢሆንስ፥ ዓለም ከተፈጠረ ጀምሮ ብዙ ጊዜ መከራ ሊቀበል ባስፈለገው ነበር፤ አሁን ግን በዓለም ፍጻሜ ራሱን በመሠዋት ኃጢአትን ሊሽር አንድ ጊዜ ተገልጦአል። ");
INSERT INTO amh_vpl VALUES ("HB9_27","088_9_27","HEB","9","27","27","ለሰዎችም አንድ ጊዜ መሞት ከእርሱ በኋላም ፍርድ እንደ ተመደበባቸው፥ ");
INSERT INTO amh_vpl VALUES ("HB9_28","088_9_28","HEB","9","28","28","እንዲሁ ክርስቶስ ደግሞ፥ የብዙዎችን ኃጢአት ሊሸከም አንድ ጊዜ ከተሰዋ በኋላ፥ ያድናቸው ዘንድ ለሚጠባበቁት ሁለተኛ ጊዜ ያለ ኃጢአት ይታይላቸዋል። ");
INSERT INTO amh_vpl VALUES ("HB10_1","088_10_1","HEB","10","1","1","ሕጉ ሊመጣ ያለው የበጎ ነገር እውነተኛ አምሳል ሳይሆን የነገር ጥላ አለውና፥ ስለዚህም በየዓመቱ ዘወትር በሚያቀርቡት በዚያ መሥዋዕት የሚቀርቡትን ሊፈጽም ከቶ አይችልም። ");
INSERT INTO amh_vpl VALUES ("HB10_2","088_10_2","HEB","10","2","2","እንደዚህማ ባይሆን፥ የሚያመልኩት አንድ ጊዜ ነጽተው ከዚያ በኋላ በሕሊናቸው ኃጢአትን ስላላወቁ ማቅረብን በተዉ አልነበረምን? ");
INSERT INTO amh_vpl VALUES ("HB10_3","088_10_3","HEB","10","3","3","ነገር ግን በዚያ መሥዋዕት በየዓመቱ የኃጢአት መታሰቢያ አለ፤ ");
INSERT INTO amh_vpl VALUES ("HB10_4","088_10_4","HEB","10","4","4","የኮርማዎችና የፍየሎች ደም ኃጢአትን እንዲያስወግድ የማይቻል ነውና። ");
INSERT INTO amh_vpl VALUES ("HB10_5","088_10_5","HEB","10","5","5","ስለዚህ ወደ ዓለም ሲገባ። መሥዋዕትንና መባን አልወደድህም ሥጋን ግን አዘጋጀህልኝ፤ ");
INSERT INTO amh_vpl VALUES ("HB10_6","088_10_6","HEB","10","6","6","በሙሉ በሚቃጠል መሥዋዕትና ሰለ ኃጢአት በሚሰዋ መሥዋዕት ደስ አላለህም። ");
INSERT INTO amh_vpl VALUES ("HB10_7","088_10_7","HEB","10","7","7","በዚያን ጊዜ። እነሆ፥ በመጽሐፍ ጥቅልል ስለ እኔ እንደ ተጻፈ፥ አምላኬ ሆይ፥ ፈቃድህን ላደርግ መጥቼአለሁ አልሁ ");
INSERT INTO amh_vpl VALUES ("HB10_8","088_10_8","HEB","10","8","8","ይላል። በዚህ ላይ። መሥዋዕትንና መባን በሙሉ የሚቃጠል መሥዋዕትንም ስለ ኃጢአትም የሚሰዋ መሥዋዕትን አልወደድህም በእርሱም ደስ አላለህም ብሎ፥ እነዚህም እንደ ሕግ የሚቀርቡት ናቸው፥ ");
INSERT INTO amh_vpl VALUES ("HB10_9","088_10_9","HEB","10","9","9","ቀጥሎ። እነሆ፥ አምላኬ ሆይ፥ ፈቃድህን ላደርግ መጥቼአለሁ ብሎአል። ሁለተኛውንም ሊያቆም የፊተኛውን ይሽራል። ");
INSERT INTO amh_vpl VALUES ("HB10_10","088_10_10","HEB","10","10","10","በዚህም ፈቃድ የኢየሱስ ክርስቶስን ሥጋ አንድ ጊዜ ፈጽሞ በማቅረብ ተቀድሰናል። ");
INSERT INTO amh_vpl VALUES ("HB10_11","088_10_11","HEB","10","11","11","ሊቀ ካህናትም ሁሉ ዕለት ዕለት እያገለገለ ኃጢአትን ሊያስወግዱ ከቶ የማይችሉትን እነዚያን መሥዋዕቶች ብዙ ጊዜ እያቀረበ ቆሞአል፤ ");
INSERT INTO amh_vpl VALUES ("HB10_12","088_10_12","HEB","10","12","12","እርሱ ግን ስለ ኃጢአት አንድን መሥዋዕት ለዘላለም አቅርቦ በእግዚአብሔር ቀኝ ተቀመጠ፥ ");
INSERT INTO amh_vpl VALUES ("HB10_13","088_10_13","HEB","10","13","13","ጠላቶቹም የእግሩ መረገጫ እስኪደረጉ ድረስ ወደ ፊት ይጠብቃል። ");
INSERT INTO amh_vpl VALUES ("HB10_14","088_10_14","HEB","10","14","14","አንድ ጊዜ በማቅረብ የሚቀደሱትን የዘላለም ፍጹማን አድርጎአቸዋልና። ");
INSERT INTO amh_vpl VALUES ("HB10_15","088_10_15","HEB","10","15","17","ብሎ ከተናገረ በኋላ፥ ኃጢአታቸውንና ዓመጻቸውንም ደግሜ አላስብም ይላል። ");
INSERT INTO amh_vpl VALUES ("HB10_18","088_10_18","HEB","10","18","18","የእነዚህም ስርየት ባለበት ዘንድ፥ ከዚህ ወዲህ ስለ ኃጢአት ማቅረብ የለም። ");
INSERT INTO amh_vpl VALUES ("HB10_19","088_10_19","HEB","10","19","21","በእግዚአብሔርም ቤት ላይ የሆነ ታላቅ ካህን ስላለን፥ ");
INSERT INTO amh_vpl VALUES ("HB10_22","088_10_22","HEB","10","22","22","ከክፉ ሕሊና ለመንጻት ልባችንን ተረጭተን ሰውነታችንንም በጥሩ ውኃ ታጥበን በተረዳንበት እምነት በቅን ልብ እንቅረብ፤ ");
INSERT INTO amh_vpl VALUES ("HB10_23","088_10_23","HEB","10","23","23","የተስፋን ቃል የሰጠው የታመነ ነውና እንዳይነቃነቅ የተስፋችንን ምስክርነት እንጠብቅ፤ ");
INSERT INTO amh_vpl VALUES ("HB10_24","088_10_24","HEB","10","24","24","ለፍቅርና ለመልካምም ሥራ እንድንነቃቃ እርስ በርሳችን እንተያይ፤ ");
INSERT INTO amh_vpl VALUES ("HB10_25","088_10_25","HEB","10","25","25","በአንዳንዶችም ዘንድ ልማድ እንደ ሆነው፥ መሰብሰባችንን አንተው እርስ በርሳችን እንመካከር እንጂ፤ ይልቁንም ቀኑ ሲቀርብ እያያችሁ አብልጣችሁ ይህን አድርጉ። ");
INSERT INTO amh_vpl VALUES ("HB10_26","088_10_26","HEB","10","26","26","የእውነትን እውቀት ከተቀበልን በኋላ ወደን ኃጢአት ብናደርግ ከእንግዲህ ወዲህ ስለ ኃጢአት መሥዋዕት አይቀርልንምና፥ ");
INSERT INTO amh_vpl VALUES ("HB10_27","088_10_27","HEB","10","27","27","የሚያስፈራ ግን የፍርድ መጠበቅ ተቃዋሚዎችንም ሊበላ ያለው የእሳት ብርታት አለ። ");
INSERT INTO amh_vpl VALUES ("HB10_28","088_10_28","HEB","10","28","28","የሙሴን ሕግ የናቀ ሰው ሁለት ወይም ሦስት ቢመሰክሩበት ያለ ርኅራኄ ይሞታል፤ ");
INSERT INTO amh_vpl VALUES ("HB10_29","088_10_29","HEB","10","29","29","የእግዚአብሔርን ልጅ የረገጠ ያንንም የተቀደሰበትን የኪዳኑን ደም እንደ ርኵስ ነገር የቆጠረ የጸጋውንም መንፈስ ያክፋፋ፥ እንዴት ይልቅ የሚብስ ቅጣት የሚገባው ይመስላችኋል? ");
INSERT INTO amh_vpl VALUES ("HB10_30","088_10_30","HEB","10","30","30","በቀል የእኔ ነው፥ እኔ ብድራትን እመልሳለሁ ያለውን እናውቃለንና፤ ደግሞም። ጌታ በሕዝቡ ይፈርዳል። ");
INSERT INTO amh_vpl VALUES ("HB10_31","088_10_31","HEB","10","31","31","በሕያው እግዚአብሔር እጅ መውደቅ የሚያስፈራ ነው። ");
INSERT INTO amh_vpl VALUES ("HB10_32","088_10_32","HEB","10","32","34","የሚበልጥና ለዘወትር የሚኖር ገንዘብ በሰማይ ራሳችሁ እንዳላችሁ አውቃችሁ፥ በእስራቴ ራራችሁልኝ የገንዘባችሁንም ንጥቂያ በደስታ ተቀበላችሁ። ");
INSERT INTO amh_vpl VALUES ("HB10_35","088_10_35","HEB","10","35","35","እንግዲህ ታላቅ ብድራት ያለውን ድፍረታችሁን አትጣሉ። ");
INSERT INTO amh_vpl VALUES ("HB10_36","088_10_36","HEB","10","36","36","የእግዚአብሔርን ፈቃድ አድርጋችሁ የተሰጣችሁን የተስፋ ቃል እንድታገኙ መጽናት ያስፈልጋችኋልና። ");
INSERT INTO amh_vpl VALUES ("HB10_37","088_10_37","HEB","10","37","37","ገና በጣም ጥቂት ጊዜ ነው፥ ሊመጣ ያለውም ይመጣል አይዘገይምም፤ ");
INSERT INTO amh_vpl VALUES ("HB10_38","088_10_38","HEB","10","38","38","ጻድቅ ግን በእምነት ይኖራል ወደ ኋላም ቢያፈገፍግ፥ ነፍሴ በእርሱ ደስ አይላትም። ");
INSERT INTO amh_vpl VALUES ("HB10_39","088_10_39","HEB","10","39","39","እኛ ግን ነፍሳቸውን ሊያድኑ ከሚያምኑቱ ነን እንጂ ወደ ጥፋት ከሚያፈገፍጉ አይደለንም። ");
INSERT INTO amh_vpl VALUES ("HB11_1","088_11_1","HEB","11","1","1","እምነትም ተስፋ ስለምናደርገው ነገር የሚያስረግጥ፥ የማናየውንም ነገር የሚያስረዳ ነው። ");
INSERT INTO amh_vpl VALUES ("HB11_2","088_11_2","HEB","11","2","2","ለሽማግሌዎች የተመሰከረላቸው በዚህ ነውና። ");
INSERT INTO amh_vpl VALUES ("HB11_3","088_11_3","HEB","11","3","3","ዓለሞች በእግዚአብሔር ቃል እንደ ተዘጋጁ፥ ስለዚህም የሚታየው ነገር ከሚታዩት እንዳልሆነ በእምነት እናስተውላለን። ");
INSERT INTO amh_vpl VALUES ("HB11_4","088_11_4","HEB","11","4","4","አቤል ከቃየል ይልቅ የሚበልጥን መሥዋዕት ለእግዚአብሔር በእምነት አቀረበ፥ በዚህም፥ እግዚአብሔር ስለ ስጦታው ሲመሰክር፥ እርሱ ጻድቅ እንደ ሆነ ተመሰከረለት፤ ሞቶም ሳለ በመሥዋዕቱ እስከ አሁን ይናገራል። ");
INSERT INTO amh_vpl VALUES ("HB11_5","088_11_5","HEB","11","5","5","ሄኖክ ሞትን እንዳያይ በእምነት ተወሰደ፥ እግዚአብሔርም ስለ ወሰደው አልተገኘም። ሳይወሰድ እግዚአብሔርን ደስ እንዳሰኘ ተመስክሮለታልና፤ ");
INSERT INTO amh_vpl VALUES ("HB11_6","088_11_6","HEB","11","6","6","ያለ እምነትም ደስ ማሰኘት አይቻልም፤ ወደ እግዚአብሔር የሚደርስ እግዚአብሔር እንዳለ ለሚፈልጉትም ዋጋ እንዲሰጥ ያምን ዘንድ ያስፈልገዋልና። ");
INSERT INTO amh_vpl VALUES ("HB11_7","088_11_7","HEB","11","7","7","ኖኅ ገና ስለማይታየው ነገር ተረድቶ እግዚአብሔርን እየፈራ ቤተ ስዎቹን ለማዳን መርከብን በእምነት አዘጋጀ፥ በዚህም ዓለምን ኰነነ፥ በእምነትም የሚገኘውን ጽድቅ ወራሽ ሆነ። ");
INSERT INTO amh_vpl VALUES ("HB11_8","088_11_8","HEB","11","8","8","አብርሃም የተባለው ርስት አድርጎ ሊቀበለው ወዳለው ስፍራ ለመውጣት በእምነት ታዘዘ፥ ወዴትም እንደሚሄድ ሳያውቅ ወጣ። ");
INSERT INTO amh_vpl VALUES ("HB11_9","088_11_9","HEB","11","9","9","ለእንግዶች እንደሚሆን በተስፋ ቃል በተሰጠው አገር በድንኳን ኖሮ፥ ያን የተስፋ ቃል አብረውት ከሚወርሱ ከይስሐቅና ከያዕቆብ ጋር፥ እንደ መጻተኛ በእምነት ተቀመጠ፤ ");
INSERT INTO amh_vpl VALUES ("HB11_10","088_11_10","HEB","11","10","10","መሠረት ያላትን፥ እግዚአብሔር የሠራትንና የፈጠራትን ከተማ ይጠብቅ ነበርና። ");
INSERT INTO amh_vpl VALUES ("HB11_11","088_11_11","HEB","11","11","11","ተስፋ የሰጠው የታመነ እንደ ሆነ ስለ ቈጠረች፥ ሣራ ራስዋ ደግሞ ዕድሜዋ እንኳ ካለፈ በኋላ ዘርን ለመፅነስ ኃይልን በእምነት አገኘች። ");
INSERT INTO amh_vpl VALUES ("HB11_12","088_11_12","HEB","11","12","12","ስለዚህ ደግሞ በብዛታቸው እንደ ሰማይ ኮከብ እንደማይቈጠርም በባሕር ዳር እንዳለ አሸዋ የነበሩት የሞተን ሰው እንኳ ከመሰለው ከአንዱ ተወለዱ። ");
INSERT INTO amh_vpl VALUES ("HB11_13","088_11_13","HEB","11","13","13","እነዚህ ሁሉ አምነው ሞቱ፥ የተሰጣቸውን የተስፋ ቃል አላገኙምና፤ ዳሩ ግን ከሩቅ ሆነው አዩትና ተሳለሙት፥ በምድሪቱም እንግዶችና መጻተኞች እንዲሆኑ ታመኑ። ");
INSERT INTO amh_vpl VALUES ("HB11_14","088_11_14","HEB","11","14","14","እንዲህ የሚሉት ለእነርሱ የሚሆነውን አገር እንዲፈልጉ ያመለክታሉና። ");
INSERT INTO amh_vpl VALUES ("HB11_15","088_11_15","HEB","11","15","15","ያን የወጡበትን አገር አስበው ቢሆኑ፥ ሊመለሱ ጊዜ በሆነላቸው ነበር፤ ");
INSERT INTO amh_vpl VALUES ("HB11_16","088_11_16","HEB","11","16","16","አሁን ግን የሚበልጠውን እርሱም ሰማያዊ አገር ይናፍቃሉ። ስለዚህ እግዚአብሔር አምላካቸው ተብሎ ሊጠራ በእነርሱ አያፍርም፥ ከተማን አዘጋጅቶላቸዋልና። ");
INSERT INTO amh_vpl VALUES ("HB11_17","088_11_17","HEB","11","17","19","እግዚአብሔር ከሙታን እንኳ ሊያስነሣው እንዲቻለው አስቦአልና፥ ከዚያም ደግሞ በምሳሌ አገኘው። ");
INSERT INTO amh_vpl VALUES ("HB11_20","088_11_20","HEB","11","20","20","ይስሐቅ ሊመጣ ስላለው ነገር ያዕቆብንና ዔሳውን በእምነት ባረካቸው። ");
INSERT INTO amh_vpl VALUES ("HB11_21","088_11_21","HEB","11","21","21","ያዕቆብ ሲሞት በእምነት የዮሴፍን ልጆች እያንዳንዳቸው ባረካቸው፥ በዘንጉም ጫፍ ተጠግቶ ሰገደ። ");
INSERT INTO amh_vpl VALUES ("HB11_22","088_11_22","HEB","11","22","22","ዮሴፍ ወደ ሞት ቀርቦ ሳለ በእምነት ስለ እስራኤል ልጆች መውጣት አስታወሰ፥ ስለ አጥንቱም አዘዛቸው። ");
INSERT INTO amh_vpl VALUES ("HB11_23","088_11_23","HEB","11","23","23","ሙሴ ከተወለደ በኋላ ወላጆቹ ያማረ ሕፃን መሆኑን አይተው በእምነት ሦስት ወር ሸሸጉት የንጉሥንም አዋጅ አልፈሩም። ");
INSERT INTO amh_vpl VALUES ("HB11_24","088_11_24","HEB","11","24","24","ሙሴ ካደገ በኋላ የፈርዖን የልጅ ልጅ እንዳይባል በእምነት እምቢ አለ፤ ");
INSERT INTO amh_vpl VALUES ("HB11_25","088_11_25","HEB","11","25","27","የንጉሡን ቍጣ ሳይፈራ የግብፅን አገር የተወ በእምነት ነበር፤ የማይታየውን እንደሚያየው አድርጎ ጸንቶአልና። ");
INSERT INTO amh_vpl VALUES ("HB11_28","088_11_28","HEB","11","28","28","አጥፊው የበኵሮችን ልጆች እንዳይነካ ፋሲካንና ደምን መርጨትን በእምነት አደረገ። ");
INSERT INTO amh_vpl VALUES ("HB11_29","088_11_29","HEB","11","29","29","በደረቅ ምድር እንደሚያልፉ በኤርትራ ባሕር በእምነት ተሻገሩ፥ የግብፅ ሰዎች ግን ሲሞክሩ ተዋጡ። ");
INSERT INTO amh_vpl VALUES ("HB11_30","088_11_30","HEB","11","30","30","የኢያሪኮ ቅጥር ሰባት ቀን ከዞሩበት በኋላ በእምነት ወደቀ። ");
INSERT INTO amh_vpl VALUES ("HB11_31","088_11_31","HEB","11","31","31","ጋለሞታይቱ ረዓብ ሰላዮችን በሰላም ስለ ተቀበለቻቸው ከማይታዘዙ ጋር በእምነት አልጠፋችም። ");
INSERT INTO amh_vpl VALUES ("HB11_32","088_11_32","HEB","11","32","32","እንግዲህ ምን እላለሁ? ስለ ጌዴዎንና ስለ ባርቅ ስለ ሶምሶንም ስለ ዮፍታሔም ስለ ዳዊትና ስለ ሳሙኤልም ስለ ነቢያትም እንዳልተርክ ጊዜ ያጥርብኛልና። ");
INSERT INTO amh_vpl VALUES ("HB11_33","088_11_33","HEB","11","33","33","እነርሱ በእምነት መንግሥታትን ድል ነሡ፥ ጽድቅን አደረጉ፥ የተሰጠውን የተስፋ ቃል አገኙ፥ ");
INSERT INTO amh_vpl VALUES ("HB11_34","088_11_34","HEB","11","34","34","የአንበሶችን አፍ ዘጉ፥ የእሳትን ኃይል አጠፉ፥ ከሰይፍ ስለት አመለጡ፥ ከድካማቸው በረቱ፥ በጦርነት ኃይለኞች ሆኑ፥ የባዕድ ጭፍሮችን አባረሩ። ");
INSERT INTO amh_vpl VALUES ("HB11_35","088_11_35","HEB","11","35","35","ሴቶች ሙታናቸውን በትንሣኤ ተቀበሉ፤ ሌሎችም መዳንን ሳይቀበሉ የሚበልጠውን ትንሣኤ እንዲያገኙ እስከ ሞት ድረስ ተደበደቡ፤ ");
INSERT INTO amh_vpl VALUES ("HB11_36","088_11_36","HEB","11","36","36","ሌሎችም መዘበቻ በመሆንና በመገረፍ ከዚህም በላይ በእስራትና በወኅኒ ተፈተኑ፤ ");
INSERT INTO amh_vpl VALUES ("HB11_37","088_11_37","HEB","11","37","37","በድንጋይ ተወግረው ሞቱ፥ ተፈተኑ፥ በመጋዝ ተሰነጠቁ፥ በሰይፍ ተገድለው ሞቱ፥ ሁሉን እያጡ መከራን እየተቀበሉ እየተጨነቁ የበግና የፍየል ሌጦ ለብሰው ዞሩ፤ ");
INSERT INTO amh_vpl VALUES ("HB11_38","088_11_38","HEB","11","38","40","ዓለም አልተገባቸውምና በምድረ በዳና በተራራ፥ በዋሻና በምድር ጕድጓድ ተቅበዘበዙ። ");
INSERT INTO amh_vpl VALUES ("HB12_1","088_12_1","HEB","12","1","3","በነፍሳችሁ ዝላችሁ እንዳትደክሙ፥ ከኃጢአተኞች በደረሰበት እንዲህ ባለ መቃወም የጸናውን አስቡ። ");
INSERT INTO amh_vpl VALUES ("HB12_4","088_12_4","HEB","12","4","4","ከኃጢአት ጋር እየተጋደላችሁ ገና ደምን እስከ ማፍሰስ ድረስ አልተቃወማችሁም፤ ");
INSERT INTO amh_vpl VALUES ("HB12_5","088_12_5","HEB","12","5","7","ለመቀጣት ታገሡ፤ እግዚአብሔር እንደ ልጆች ያደርግላችኋልና፤ አባቱ የማይቀጣው ልጅ ማን ነው? ");
INSERT INTO amh_vpl VALUES ("HB12_8","088_12_8","HEB","12","8","8","ነገር ግን ሁሉ የቅጣት ተካፋይ ሆኖአልና ያለ ቅጣት ብትኖሩ ዲቃላዎች እንጂ ልጆች አይደላችሁም። ");
INSERT INTO amh_vpl VALUES ("HB12_9","088_12_9","HEB","12","9","9","ከዚህም በላይ የቀጡን የሥጋችን አባቶች ነበሩን እናፍራቸውም ነበር፤ እንዴትስ ይልቅ ለመናፍስት አባት አብልጠን ልንገዛና በሕይወት ልንኖር በተገባን? ");
INSERT INTO amh_vpl VALUES ("HB12_10","088_12_10","HEB","12","10","10","እነርሱ መልካም ሆኖ እንደ ታያቸው ለጥቂት ቀን ይቀጡን ነበርና፥ እርሱ ግን ከቅድስናው እንድንካፈል ለጥቅማችን ይቀጣናል። ");
INSERT INTO amh_vpl VALUES ("HB12_11","088_12_11","HEB","12","11","11","ቅጣት ሁሉ ለጊዜው የሚያሳዝን እንጂ ደስ የሚያሰኝ አይመስልም፥ ዳሩ ግን በኋላ ለለመዱት የሰላምን ፍሬ እርሱም ጽድቅን ያፈራላቸዋል። ");
INSERT INTO amh_vpl VALUES ("HB12_12","088_12_12","HEB","12","12","12","ስለዚህ የላሉትን እጆች የሰለሉትንም ጉልበቶች አቅኑ፤ ");
INSERT INTO amh_vpl VALUES ("HB12_13","088_12_13","HEB","12","13","13","ያነከሰውም እንዲፈወስ እንጂ እንዳይናጋ፥ ለእግራችሁ ቅን መንገድ አድርጉ። ");
INSERT INTO amh_vpl VALUES ("HB12_14","088_12_14","HEB","12","14","14","ከሰው ሁሉ ጋር ሰላምን ተከታተሉ ትቀደሱም ዘንድ ፈልጉ፥ ያለ እርሱ ጌታን ሊያይ የሚችል የለምና። ");
INSERT INTO amh_vpl VALUES ("HB12_15","088_12_15","HEB","12","15","15","የእግዚአብሔር ጸጋ ለማንም እንዳይጎድለው፥ ብዙዎቹም የሚረክሱበት አንድ መራራ ሥር ወደ ላይ በቅሎ እንዳያስጨንቅ፥ ሴሰኛም የሚሆን እንዳይገኝ፥ ");
INSERT INTO amh_vpl VALUES ("HB12_16","088_12_16","HEB","12","16","16","ወይም ስለ አንድ መብል በኵርነቱን እንደ ሸጠ እንደ ዔሳው ለዚህ ዓለም የሚመች ሰው እንዳይሆን ተጠንቀቁ። ");
INSERT INTO amh_vpl VALUES ("HB12_17","088_12_17","HEB","12","17","17","ከዚያ በኋላ እንኳ በረከቱን ሊወርስ በወደደ ጊዜ እንደ ተጣለ ታውቃላችሁና፤ በእንባ ተግቶ ምንም ቢፈልገው ለንስሐ ስፍራ አላገኘምና። ");
INSERT INTO amh_vpl VALUES ("HB12_18","088_12_18","HEB","12","18","18","ሊዳሰስ ወደሚችል ወደሚቃጠልም እሳት ወደ ጭጋግም ወደ ጨለማም ወደ ዐውሎ ነፋስም ወደ መለከት ድምፅም ወደ ቃሎችም ነገር አልደረሳችሁምና፤ ");
INSERT INTO amh_vpl VALUES ("HB12_19","088_12_19","HEB","12","19","19","ያንም ነገር የሰሙት ሌላ ቃል እንዳይጨመርባቸው ለመኑ፤ ");
INSERT INTO amh_vpl VALUES ("HB12_20","088_12_20","HEB","12","20","20","እንስሳ እንኳ ተራራውን ቢነካ ተወግሮ ይሙት የምትለውን ትእዛዝ ሊታገሡ አልቻሉምና፤ ");
INSERT INTO amh_vpl VALUES ("HB12_21","088_12_21","HEB","12","21","21","ሙሴም። እጅግ እፈራለሁ እንቀጠቀጥማለሁ እስኪል ድረስ የሚታየው እጅግ የሚያስፈራ ነበር፤ ");
INSERT INTO amh_vpl VALUES ("HB12_22","088_12_22","HEB","12","22","22","ነገር ግን ወደ ጽዮን ተራራና ወደ ሕያው እግዚአብሔር ከተማ ደርሳችኋል፥ ወደ ሰማያዊቱም ኢየሩሳሌም፥ በደስታም ወደ ተሰበሰቡት ወደ አእላፋት መላእክት፥ ");
INSERT INTO amh_vpl VALUES ("HB12_23","088_12_23","HEB","12","23","23","በሰማያትም ወደ ተጻፉ ወደ በኵራት ማኅበር፥ የሁሉም ዳኛ ወደሚሆን ወደ እግዚአብሔር፥ ፍጹማንም ወደ ሆኑት ወደ ጻድቃን መንፈሶች፥ ");
INSERT INTO amh_vpl VALUES ("HB12_24","088_12_24","HEB","12","24","24","የአዲስም ኪዳን መካከለኛ ወደሚሆን ወደ ኢየሱስ፥ ከአቤልም ደም ይልቅ የሚሻለውን ወደሚናገር ወደ መርጨት ደም ደርሳችኋል። ");
INSERT INTO amh_vpl VALUES ("HB12_25","088_12_25","HEB","12","25","25","ለሚናገረው እምቢ እንዳትሉ ተጠንቀቁ፤ እነዚያ በምድር ላስረዳቸው እምቢ ባሉ ጊዜ ካላመለጡ፥ ከሰማይ ከመጣው ፈቀቅ የምንል እኛስ እንዴት እናመልጣለን? ");
INSERT INTO amh_vpl VALUES ("HB12_26","088_12_26","HEB","12","26","26","በዚያም ጊዜ ድምፁ ምድርን አናወጠ፥ አሁን ግን። አንድ ጊዜ ደግሜ እኔ ሰማይን አናውጣለሁ እንጂ ምድርን ብቻ አይደለም ብሎ ተስፋ ሰጥቶአል። ");
INSERT INTO amh_vpl VALUES ("HB12_27","088_12_27","HEB","12","27","27","ዳሩ ግን። አንድ ጊዜ ደግሜ የሚል ቃል፥ የማይናወጡት ጸንተው እንዲኖሩ፥ የሚናወጡት የተፈጠሩ እንደሚሆኑ ይለወጡ ዘንድ ያሳያል። ");
INSERT INTO amh_vpl VALUES ("HB12_28","088_12_28","HEB","12","28","28","ስለዚህ የማይናወጥን መንግሥት ስለምንቀበል በማክበርና በፍርሃት እግዚአብሔርን ደስ እያሰኘን የምናመልክበትን ጸጋ እንያዝ፤ ");
INSERT INTO amh_vpl VALUES ("HB12_29","088_12_29","HEB","12","29","29","አምላካችን በእውነት የሚያጠፋ እሳት ነውና። ");
INSERT INTO amh_vpl VALUES ("HB13_1","088_13_1","HEB","13","1","3","ከእነርሱ ጋር እንደ ታሰረ ሆናችሁ እስሮችን አስቡ፥ የተጨነቁትንም ራሳችሁ ደግሞ በሥጋ እንዳለ ሆናችሁ አስቡ። ");
INSERT INTO amh_vpl VALUES ("HB13_4","088_13_4","HEB","13","4","4","መጋባት በሁሉ ዘንድ ክቡር መኝታውም ንጹሕ ይሁን፤ ሴሰኞችንና አመንዝሮችን ግን እግዚአብሔር ይፈርድባቸዋል። ");
INSERT INTO amh_vpl VALUES ("HB13_5","088_13_5","HEB","13","5","5","አካሄዳችሁ ገንዘብን ያለ መውደድ ይሁን፥ ያላችሁም ይብቃችሁ፤ እርሱ ራሱ። አልለቅህም ከቶም አልተውህም ብሎአልና፤ ");
INSERT INTO amh_vpl VALUES ("HB13_6","088_13_6","HEB","13","6","6","ስለዚህ በድፍረት። ጌታ ይረዳኛልና አልፈራም፤ ሰው ምን ያደርገኛል? እንላለን። ");
INSERT INTO amh_vpl VALUES ("HB13_7","088_13_7","HEB","13","7","7","የእግዚአብሔርን ቃል የተናገሩአችሁን ዋኖቻችሁን አስቡ፥ የኑሮአቸውንም ፍሬ እየተመለከታችሁ በእምነታቸው ምሰሉአቸው። ");
INSERT INTO amh_vpl VALUES ("HB13_8","088_13_8","HEB","13","8","8","ኢየሱስ ክርስቶስ ትናንትና ዛሬ እስከ ለዘላለምም ያው ነው። ");
INSERT INTO amh_vpl VALUES ("HB13_9","088_13_9","HEB","13","9","9","ልዩ ልዩ ዓይነት በሆነ በእንግዳ ትምህርት አትወሰዱ፤ ልባችሁ በጸጋ ቢጸና መልካም ነው እንጂ በመብል አይደለም፤ በዚህ የሚሠሩባት አልተጠቀሙምና። ");
INSERT INTO amh_vpl VALUES ("HB13_10","088_13_10","HEB","13","10","10","መሠዊያ አለን፥ ከእርሱም ሊበሉ ድንኳኒቱን የሚያገለግሉ መብት የላቸውም። ");
INSERT INTO amh_vpl VALUES ("HB13_11","088_13_11","HEB","13","11","11","ሊቀ ካህናት ስለ ኃጢአት ወደ ቅድስት የእንስሶችን ደም ያቀርባልና፤ ሥጋቸው ግን ከሰፈሩ ውጭ ይቃጠላል። ");
INSERT INTO amh_vpl VALUES ("HB13_12","088_13_12","HEB","13","12","12","ስለዚህ ኢየሱስ ደግሞ በገዛ ደሙ ሕዝቡን እንዲቀድስ ከበር ውጭ መከራን ተቀበለ። ");
INSERT INTO amh_vpl VALUES ("HB13_13","088_13_13","HEB","13","13","13","እንግዲህ ነቀፌታውን እየተሸከምን ወደ እርሱ ወደ ሰፈሩ ውጭ እንውጣ፤ ");
INSERT INTO amh_vpl VALUES ("HB13_14","088_13_14","HEB","13","14","14","በዚህ የምትኖር ከተማ የለችንምና፥ ነገር ግን ትመጣ ዘንድ ያላትን እንፈልጋለን። ");
INSERT INTO amh_vpl VALUES ("HB13_15","088_13_15","HEB","13","15","15","እንግዲህ ዘወትር ለእግዚአብሔር የምስጋናን መሥዋዕት፥ ማለት ለስሙ የሚመሰክሩ የከንፈሮችን ፍሬ፥ በእርሱ እናቅርብለት። ");
INSERT INTO amh_vpl VALUES ("HB13_16","088_13_16","HEB","13","16","16","ነገር ግን መልካም ማድረግን ለሌሎችም ማካፈልን አትርሱ፤ እንዲህ ያለው መሥዋዕት እግዚአብሔርን ደስ ያሰኘዋልና። ");
INSERT INTO amh_vpl VALUES ("HB13_17","088_13_17","HEB","13","17","17","ለዋኖቻችሁ ታዘዙና ተገዙ፤ እነርሱ ስሌትን እንደሚሰጡ አድርገው፥ ይህንኑ በደስታ እንጂ በኃዘን እንዳያደርጉት፥ ይህ የማይጠቅማችሁ ነበርና፥ ስለ ነፍሳችሁ ይተጋሉ። ");
INSERT INTO amh_vpl VALUES ("HB13_18","088_13_18","HEB","13","18","18","ጸልዩልን፤ በነገር ሁሉ በመልካም እንድንኖር ወደን፥ መልካም ሕሊና እንዳለን ተረድተናልና። ");
INSERT INTO amh_vpl VALUES ("HB13_19","088_13_19","HEB","13","19","19","ይልቁንም ፈጥኜ እንድመለስላችሁ ይህን ታደርጉ ዘንድ አጥብቄ እለምናችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("HB13_20","088_13_20","HEB","13","20","20","በዘላለም ኪዳን ደም ለበጎች ትልቅ እረኛ የሆነውን ጌታችንን ኢየሱስን ከሙታን ያወጣው የሰላም አምላክ፥ ");
INSERT INTO amh_vpl VALUES ("HB13_21","088_13_21","HEB","13","21","21","በኢየሱስ ክርስቶስ በኩል በፊቱ ደስ የሚያሰኘውን በእናንተ እያደረገ፥ ፈቃዱን ታደርጉ ዘንድ በመልካም ሥራ ሁሉ ፍጹማን ያድርጋችሁ፤ ለእርሱ እስከ ዘላለም ድረስ ክብር ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("HB13_22","088_13_22","HEB","13","22","22","ወንድሞች ሆይ፥ የምክርን ቃል እንድትታገሡ እመክራችኋለሁ፥ በጥቂት ቃል ጽፌላችኋለሁና። ");
INSERT INTO amh_vpl VALUES ("HB13_23","088_13_23","HEB","13","23","23","ወንድማችን ጢሞቴዎስ እንደ ተፈታ እወቁ፥ ቶሎ ብሎም ቢመጣ ከእርሱ ጋር አያችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("HB13_24","088_13_24","HEB","13","24","24","ለዋኖቻችሁ ሁሉና ለቅዱሳን ሁሉ ሰላምታ አቅርቡልኝ። ከኢጣልያ የሆኑቱ ሰላምታ ያቀርቡላችኋል። ");
INSERT INTO amh_vpl VALUES ("HB13_25","088_13_25","HEB","13","25","25","ጸጋ ከሁላችሁ ጋር ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","የእግዚአብሔርና የጌታ የኢየሱስ ክርስቶስ ባሪያ ያዕቆብ ለተበተኑ ለአሥራ ሁለቱ ወገኖች፤ ሰላም ለእናንተ ይሁን። ");
INSERT INTO amh_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","4","ትዕግሥትም ምንም የሚጎድላችሁ ሳይኖር ፍጹማንና ምሉዓን ትሆኑ ዘንድ ሥራውን ይፈጽም። ");
INSERT INTO amh_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","ከእናንተ ግን ማንም ጥበብ ቢጎድለው፥ ሳይነቅፍ በልግስና ለሁሉ የሚሰጠውን እግዚአብሔርን ይለምን፥ ለእርሱም ይሰጠዋል። ");
INSERT INTO amh_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","ነገር ግን በምንም ሳይጠራጠር በእምነት ይለምን፤ የሚጠራጠር ሰው በነፋስ የተገፋና የተነቃነቀ የባሕርን ማዕበል ይመስላልና። ");
INSERT INTO amh_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","11","ፀሐይ ከትኵሳት ጋር ይወጣልና፥ ሣርንም ያጠወልጋልና፥ አበባውም ይረግፋልና፥ የመልኩም ውበት ይጠፋልና፤ እንዲሁ ደግሞ ባለ ጠጋው በመንገዱ ይዝላል። ");
INSERT INTO amh_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","በፈተና የሚጸና ሰው የተባረከ ነው፤ ከተፈተነ በኋላ ለሚወዱት ተስፋ ስለ እርሱ የሰጣቸውን የሕይወትን አክሊል ይቀበላልና። ");
INSERT INTO amh_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","ማንም ሲፈተን። በእግዚአብሔር እፈተናለሁ አይበል፤ እግዚአብሔር በክፉ አይፈተንምና፤ እርሱ ራሱስ ማንንም አይፈትንም። ");
INSERT INTO amh_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","ነገር ግን እያንዳንዱ በራሱ ምኞት ሲሳብና ሲታለል ይፈተናል። ");
INSERT INTO amh_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","ከዚህ በኋላ ምኞት ፀንሳ ኃጢአትን ትወልዳለች፤ ኃጢአትም ካደገች በኋላ ሞትን ትወልዳለች። ");
INSERT INTO amh_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","የተወደዳችሁ ወንድሞቼ ሆይ፥ አትሳቱ። ");
INSERT INTO amh_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","በጎ ስጦታ ሁሉ ፍጹምም በረከት ሁሉ ከላይ ናቸው፥ መለወጥም በእርሱ ዘንድ ከሌለ በመዞርም የተደረገ ጥላ በእርሱ ዘንድ ከሌለ ከብርሃናት አባት ይወርዳሉ። ");
INSERT INTO amh_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","ለፍጥረቱ የበኵራት ዓይነት እንድንሆን በእውነት ቃል አስቦ ወለደን። ");
INSERT INTO amh_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","ስለዚህ፥ የተወደዳችሁ ወንድሞቼ ሆይ፥ ሰው ሁሉ ለመስማት የፈጠነ ለመናገርም የዘገየ ለቍጣም የዘገየ ይሁን፤ ");
INSERT INTO amh_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","የሰው ቍጣ የእግዚአብሔርን ጽድቅ አይሠራምና። ");
INSERT INTO amh_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","ስለዚህ ርኵሰትን ሁሉ የክፋትንም ትርፍ አስወግዳችሁ፥ ነፍሳችሁን ማዳን የሚችለውን በውስጣችሁም የተተከለውን ቃል በየዋህነት ተቀበሉ። ");
INSERT INTO amh_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","ቃሉን የምታደርጉ ሁኑ እንጂ ራሳችሁን እያሳታችሁ የምትሰሙ ብቻ አትሁኑ። ");
INSERT INTO amh_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","ቃሉን የሚሰማ የማያደርገውም ቢኖር የተፈጥሮ ፊቱን በመስተዋት የሚያይን ሰው ይመስላል፤ ");
INSERT INTO amh_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","ራሱን አይቶ ይሄዳልና፥ ወዲያውም እንደ ምን እንደ ሆነ ይረሳል። ");
INSERT INTO amh_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","ነገር ግን ነጻ የሚያወጣውን ፍጹሙን ሕግ ተመልክቶ የሚጸናበት፥ ሥራንም የሚሠራ እንጂ ሰምቶ የሚረሳ ያልሆነው፥ በሥራው የተባረከ ይሆናል። ");
INSERT INTO amh_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","አንደበቱን ሳይገታ ልቡን እያሳተ እግዚአብሔርን የሚያመልክ የሚመስለው ማንም ቢኖር የእርሱ አምልኮ ከንቱ ነው። ");
INSERT INTO amh_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","ንጹሕ የሆነ ነውርም የሌለበት አምልኮ በእግዚአብሔር አብ ዘንድ ይህ ነው፤ ወላጆች የሌላቸውን ልጆች ባልቴቶችንም በመከራቸው መጠየቅ፥ በዓለምም ከሚገኝ እድፍ ሰውነቱን መጠበቅ ነው። ");
INSERT INTO amh_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","ወንድሞቼ ሆይ፥ በክብር ጌታ በጌታችን በኢየሱስ ክርስቶስ ያለውን እምነት ለሰው ፊት በማድላት አትያዙ። ");
INSERT INTO amh_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","የወርቅ ቀለበት ያደረገና የጌጥ ልብስ የለበሰ ሰው ወደ ጉባኤአችሁ ቢገባ፥ እድፍ ልብስም የለበሰ ድሀ ሰው ደግሞ ቢገባ፥ ");
INSERT INTO amh_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","የጌጥ ልብስም የለበሰውን ተመልክታችሁ። አንተስ በዚህ በመልካም ስፍራ ተቀመጥ ብትሉት፥ ድሀውንም። አንተስ ወደዚያ ቁም ወይም ከእግሬ መረገጫ በታች ተቀመጥ ብትሉት፥ ራሳችሁን መለያየታችሁ አይደለምን? ");
INSERT INTO amh_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","ክፉ አሳብ ያላቸውም ዳኞች መሆናችሁ አይደለምን? ");
INSERT INTO amh_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","የተወደዳችሁ ወንድሞቼ ሆይ፥ ስሙ፤ እግዚአብሔር በእምነት ባለ ጠጎች እንዲሆኑ ለሚወዱትም ተስፋ ስለ እርሱ የሰጣቸውን መንግሥት እንዲወርሱ የዚህን ዓለም ድሆች አልመረጠምን? ");
INSERT INTO amh_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","እናንተ ግን ድሆችን አዋረዳችሁ። ባለ ጠጎቹ የሚያስጨንቁአችሁ አይደሉምን? ወደ ፍርድ ቤትም የሚጎትቱአችሁ እነርሱ አይደሉምን? ");
INSERT INTO amh_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","የተጠራችሁበትን መልካሙን ስም የሚሰድቡ እነርሱ አይደሉምን? ");
INSERT INTO amh_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","ነገር ግን መጽሐፍ። ባልንጀራህን እንደ ራስህ ውደድ እንደሚል የንጉሥን ሕግ ብትፈጽሙ መልካም ታደርጋላችሁ፤ ");
INSERT INTO amh_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","ለሰው ፊት ግን ብታደሉ ኃጢአትን ትሠራላችሁ፥ ሕግም እንደ ተላላፊዎች ይወቅሳችኋል። ");
INSERT INTO amh_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","ሕግን ሁሉ የሚጠብቅ፥ ነገር ግን በአንዱ የሚሰናከል ማንም ቢኖር በሁሉ በደለኛ ይሆናል፤ አታመንዝር ያለው ደግሞ። አትግደል ብሎአልና፤ ");
INSERT INTO amh_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","ባታመነዝርም፥ ነገር ግን ብትገድል፥ ሕግን ተላላፊ ሆነሃል። ");
INSERT INTO amh_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","በነጻነት ሕግ ፍርድን ይቀበሉ ዘንድ እንዳላቸው ሰዎች እንዲህ ተናገሩ፥ እንዲህም አድርጉ። ");
INSERT INTO amh_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","ምሕረትን ለማያደርግ ምሕረት የሌለበት ፍርድ ይሆናልና፤ ምሕረትም በፍርድ ላይ ይመካል። ");
INSERT INTO amh_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","ወንድሞቼ ሆይ፥ እምነት አለኝ የሚል፥ ሥራ ግን የሌለው ሰው ቢኖር ምን ይጠቅመዋል? እምነቱስ ሊያድነው ይችላልን? ");
INSERT INTO amh_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","ወንድም ወይም እኅት ራቁታቸውን ቢሆኑ የዕለት ምግብንም ቢያጡ፥ ");
INSERT INTO amh_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","ከእናንተ አንዱም። በደኅና ሂዱ፥ እሳት ሙቁ፥ ጥገቡም ቢላቸው ለሰውነት ግን የሚያስፈልጉትን ባትሰጡአቸው ምን ይጠቅማቸዋል? ");
INSERT INTO amh_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","እንደዚሁም ሥራ የሌለው እምነት ቢኖር በራሱ የሞተ ነው። ");
INSERT INTO amh_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","ነገር ግን አንድ ሰው። አንተ እምነት አለህ እኔም ሥራ አለኝ፤ እምነትህን ከሥራህ ለይተህ አሳየኝ፥ እኔም እምነቴን በሥራዬ አሳይሃለሁ ይላል። ");
INSERT INTO amh_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","እግዚአብሔር አንድ እንደ ሆነ አንተ ታምናለህ፤ መልካም ታደርጋለህ፤ አጋንንት ደግሞ ያምናሉ ይንቀጠቀጡማል። ");
INSERT INTO amh_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","አንተ ከንቱ ሰው፥ እምነት ከሥራ ተለይቶ የሞተ መሆኑን ልታውቅ ትወዳለህን? ");
INSERT INTO amh_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","አባታችን አብርሃም ልጁን ይስሐቅን በመሠዊያው ባቀረበ ጊዜ በሥራ የጸደቀ አልነበረምን? ");
INSERT INTO amh_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","እምነት ከሥራው ጋር አብሮ ያደርግ እንደ ነበረ፥ በሥራም እምነት እንደ ተፈጸመ ትመለከታለህን? ");
INSERT INTO amh_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","መጽሐፍም። አብርሃምም እግዚአብሔርን አመነ ጽድቅም ሆኖ ተቈጠረለት ያለው ተፈጸመ፤ የእግዚአብሔርም ወዳጅ ተባለ። ");
INSERT INTO amh_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","ሰው በእምነት ብቻ ሳይሆን በሥራ እንዲጸድቅ ታያላችሁ። ");
INSERT INTO amh_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","እንደዚሁም ጋለሞታይቱ ረዓብ ደግሞ መልእክተኞቹን ተቀብላ በሌላ መንገድ በሰደደቻቸው ጊዜ በሥራ አልጸደቀችምን? ");
INSERT INTO amh_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","ከነፍስ የተለየ ሥጋ የሞተ እንደ ሆነ እንዲሁ ደግሞ ከሥራ የተለየ እምነት የሞተ ነው። ");
INSERT INTO amh_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","ወንድሞቼ ሆይ፥ ከእናንተ ብዙዎቹ አስተማሪዎች አይሁኑ፥ የባሰውን ፍርድ እንድንቀበል ታውቃላችሁና። ");
INSERT INTO amh_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","ሁላችን በብዙ ነገር እንሰናከላለንና፤ በቃል የማይሰናከል ማንም ቢኖር እርሱ ሥጋውን ሁሉ ደግሞ ሊገታ የሚችል ፍጹም ሰው ነው። ");
INSERT INTO amh_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","እነሆ፥ ፈረሶች ይታዘዙልን ዘንድ ልጓም በአፋቸው ውስጥ እናገባለን፥ ሥጋቸውንም ሁሉ እንመራለን። ");
INSERT INTO amh_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","እነሆ፥ መርከቦች ደግሞ ይህን ያህል ታላቅ ቢሆኑ በዐውሎ ነፋስም ቢነዱ፥ የመሪ ፈቃድ ወደሚወደው ስፍራ እጅግ ታናሽ በሆነ መቅዘፊያ ይመራሉ። ");
INSERT INTO amh_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","እንዲሁም አንደበት ደግሞ ትንሽ ብልት ሆኖ በታላላቅ ነገር ይመካል። እነሆ፥ ትንሽ እሳት እንዴት ያለ ትልቅ ጫካ ያቃጥላል። ");
INSERT INTO amh_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","አንደበትም እሳት ነው። አንደበት በብልቶቻችን መካከል ዓመፀኛ ዓለም ሆኖአል፤ ሥጋን ሁሉ ያሳድፋልና፥ የፍጥረትንም ሩጫ ያቃጥላል፥ በገሃነምም ይቃጠላል። ");
INSERT INTO amh_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","የአራዊትና የወፎች የተንቀሳቃሾችና በባሕር ያለ የፍጥረት ወገን ሁሉ በሰው ይገራል፥ ደግሞ ተገርቶአል፤ ");
INSERT INTO amh_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","ነገር ግን አንደበትን ሊገራ ማንም ሰው አይችልም፤ የሚገድል መርዝ የሞላበት ወላዋይ ክፋት ነው። ");
INSERT INTO amh_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","በእርሱ ጌታንና አብን እንባርካለን፤ በእርሱም እንደ እግዚአብሔር ምሳሌ የተፈጠሩትን ሰዎች እንረግማለን፤ ");
INSERT INTO amh_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","ከአንድ አፍ በረከትና መርገም ይወጣሉ። ወንድሞቼ ሆይ፥ ይህ እንዲህ ሊሆን አይገባም። ");
INSERT INTO amh_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","ምንጭስ ከአንድ አፍ የሚጣፍጥንና የሚመርን ውኃ ያመነጫልን? ");
INSERT INTO amh_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","ወንድሞቼ ሆይ፥ በለስ ወይራን ወይስ ወይን በለስን ልታፈራ ትችላለችን? ከጨው ውኃም ጣፋጭ ውኃ አይወጣም። ");
INSERT INTO amh_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","ከእናንተ ጥበበኛና አስተዋይ ማን ነው? በመልካም አንዋዋሩ ስራውን በጥበብ የዋህነት ያሳይ። ");
INSERT INTO amh_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","ነገር ግን መራራ ቅንዓትና አድመኛነት በልባችሁ ቢኖርባችሁ፥ አትመኩ በእውነትም ላይ አትዋሹ። ");
INSERT INTO amh_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","ይህ ጥበብ ከላይ የሚወርድ አይደለም፤ ነገር ግን የምድር ነው፥ የሥጋም ነው፥ የአጋንንትም ነው፤ ");
INSERT INTO amh_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","ቅንዓትና አድመኛነት ባሉበት ስፍራ በዚያ ሁከትና ክፉ ስራ ሁሉ አሉና። ");
INSERT INTO amh_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","ላይኛይቱ ጥበብ ግን በመጀመሪያ ንጽሕት ናት፥ በኋላም ታራቂ፥ ገር፥ እሺ ባይ ምሕረትና በጎ ፍሬ የሞላባት፥ ጥርጥርና ግብዝነት የሌለባት ናት። ");
INSERT INTO amh_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","የጽድቅም ፍሬ ሰላምን ለሚያደርጉት ሰዎች በሰላም ይዘራል። ");
INSERT INTO amh_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","በእናንተ ዘንድ ጦርና ጠብ ከወዴት ይመጣሉ? በብልቶቻችሁ ውስጥ ከሚዋጉ ከእነዚህ ከምቾቶቻችሁ አይደሉምን? ");
INSERT INTO amh_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","ትመኛላችሁ ለእናንተም አይሆንም፤ ትገድላላችሁ በብርቱም ትፈልጋላችሁ፥ ልታገኙም አትችሉም፤ ትጣላላችሁ ትዋጉማላችሁ ነገር ግን አትለምኑምና ለእናንተ አይሆንም፤ ");
INSERT INTO amh_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","ትለምናላችሁ፥ በምቾቶቻችሁም ትከፍሉ ዘንድ በክፉ ትለምናላችሁና አትቀበሉም። ");
INSERT INTO amh_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","አመንዝሮች ሆይ፥ ዓለምን መውደድ ለእግዚአብሔር ጥል እንዲሆን አታውቁምን? እንግዲህ የዓለም ወዳጅ ሊሆን የሚፈቅድ ሁሉ የእግዚአብሔር ጠላት ሆኖአል። ");
INSERT INTO amh_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","ወይስ መጽሐፍ። በእኛ ዘንድ ያሳደረው መንፈስ በቅንዓት ይመኛል ያለው በከንቱ እንደ ተናገረ ይመስላችኋልን? ");
INSERT INTO amh_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","ነገር ግን ጸጋን አብልጦ ይሰጣል፤ ስለዚህ። እግዚአብሔር ትዕቢተኞችን ይቃወማል፥ ለትሑታን ግን ጸጋን ይሰጣል ይላል። ");
INSERT INTO amh_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","እንግዲህ ለእግዚአብሔር ተገዙ፤ ዲያብሎስን ግን ተቃወሙ ከእናንተም ይሸሻል፤ ");
INSERT INTO amh_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","ወደ እግዚአብሔር ቅረቡ ወደ እናንተም ይቀርባል። እናንተ ኃጢአተኞች፥ እጆቻችሁን አንጹ፤ ሁለት አሳብም ያላችሁ እናንተ፥ ልባችሁን አጥሩ። ");
INSERT INTO amh_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","ተጨነቁና እዘኑ አልቅሱም፤ ሳቃችሁ ወደ ኀዘን ደስታችሁም ወደ ትካዜ ይለወጥ። ");
INSERT INTO amh_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","በጌታ ፊት ራሳችሁን አዋርዱ ከፍ ከፍም ያደርጋችኋል። ");
INSERT INTO amh_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","ወንድሞች ሆይ፥ እርስ በርሳችሁ አትተማሙ። ወንድሙን የሚያማ በወንድሙም የሚፈርድ ሕግን ያማል በሕግም ይፈርዳል፤ በሕግም ብትፈርድ ፈራጅ ነህ እንጂ ሕግን አድራጊ አይደለህም። ");
INSERT INTO amh_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","ሕግን የሚሰጥና የሚፈርድ አንድ ነው፤ እርሱም ሊያድን ሊያጠፋም የሚችል ነው፤ በሌላው ግን የምትፈርድ አንተ ማን ነህ? ");
INSERT INTO amh_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","አሁንም። ዛሬ ወይም ነገ ወደዚህ ከተማ እንሄዳለን በዚያም ዓመት እንኖራለን እንነግድማለን እናተርፍማለን የምትሉ እናንተ፥ ተመልከቱ፥ ነገ የሚሆነውን አታውቁምና። ");
INSERT INTO amh_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","ሕይወታችሁ ምንድር ነው? ጥቂት ጊዜ ታይቶ ኋላ እንደሚጠፋ እንፍዋለት ናችሁና። ");
INSERT INTO amh_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","በዚህ ፈንታ። ጌታ ቢፈቅድ ብንኖርም ይህን ወይም ያን እናደርጋለን ማለት ይገባችኋል። ");
INSERT INTO amh_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","አሁን ግን በትዕቢታችሁ ትመካላችሁ፤ እንደዚህ ያለ ትምክህት ሁሉ ክፉ ነው። ");
INSERT INTO amh_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","እንግዲህ በጎ ለማድረግ አውቆ ለማይሠራው ኃጢአት ነው። ");
INSERT INTO amh_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","አሁንም እናንተ ባለ ጠጎች፥ ስለሚደርስባችሁ ጭንቅ ዋይ ዋይ እያላችሁ አልቅሱ። ");
INSERT INTO amh_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","ሀብታችሁ ተበላሽቶአል፥ ልብሳችሁም በብል ተበልቶአል። ");
INSERT INTO amh_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","ወርቃችሁም ብራችሁም ዝጎአል፥ ዝገቱም ምስክር ይሆንባችኋል ሥጋችሁንም እንደ እሳት ይበላል። ለኋለኛው ቀን መዝገብን አከማችታችኋል። ");
INSERT INTO amh_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","እነሆ፥ እርሻችሁን ያጨዱት የሠራተኞች ደመወዝ በእናንተ ተቀምቶ ይጮኻል፥ የአጫጆችም ድምፅ ወደ ጌታ ፀባዖት ጆሮ ገብቶአል። ");
INSERT INTO amh_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","በምድር ላይ ተቀማጥላችኋል በሴሰኝነትም ኖራችኋል፤ ለእርድ ቀን እንደሚያወፍር ልባችሁን አወፍራችኋል። ");
INSERT INTO amh_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","ጻድቁን ኰንናችሁታል ገድላችሁትማል፤ እናንተን አይቃወምም። ");
INSERT INTO amh_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","እንግዲህ፥ ወንድሞች ሆይ፥ ጌታ እስኪመጣ ድረስ ታገሡ። እነሆ፥ ገበሬው የፊተኛውንና የኋለኛውን ዝናብ እስኪቀበል ድረስ እርሱን እየታገሠ የከበረውን የመሬት ፍሬ ይጠብቃል። ");
INSERT INTO amh_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","እናንተ ደግሞ ታገሡ፥ ልባችሁንም አጽኑ፤ የጌታ መምጣት ቀርቦአልና። ");
INSERT INTO amh_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","ወንድሞች ሆይ፥ እንዳይፈረድባችሁ እርስ በርሳችሁ አታጉረምርሙ፤ እነሆ፥ ፈራጅ በደጅ ፊት ቆሞአል። ");
INSERT INTO amh_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","ወንድሞች ሆይ፥ የመከራና የትዕግሥት ምሳሌ የሆኑትን በጌታ ስም የተናገሩትን ነቢያትን ተመልከቱ። ");
INSERT INTO amh_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","እነሆ፥ በትዕግሥት የጸኑትን ብፁዓን እንላቸዋለን፤ ኢዮብ እንደ ታገሠ ሰምታችኋል፥ ጌታም እንደ ፈጸመለት አይታችኋል፤ ጌታ እጅግ የሚምር የሚራራም ነውና። ");
INSERT INTO amh_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","ከሁሉም በፊት፥ ወንድሞቼ ሆይ፥ በሰማይ ቢሆን በምድርም ቢሆን በሌላ መሐላም ቢሆን በምንም አትማሉ፤ ነገር ግን ከፍርድ በታች እንዳትወድቁ ነገራችሁ አዎን ቢሆን አዎን ይሁን፥ አይደለምም ቢሆን አይደለም ይሁን። ");
INSERT INTO amh_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","ከእናንተ መከራን የሚቀበል ማንም ቢኖር እርሱ ይጸልይ፤ ደስ የሚለውም ማንም ቢኖር እርሱ ይዘምር። ");
INSERT INTO amh_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","ከእናንተ የታመመ ማንም ቢኖር የቤተ ክርስቲያንን ሽምግሌዎች ወደ እርሱ ይጥራ፤ በጌታም ስም እርሱን ዘይት ቀብተው ይጸልዩለት። ");
INSERT INTO amh_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","የእምነትም ጸሎት ድውዩን ያድናል ጌታም ያስነሣዋል፤ ኃጢአትንም ሠርቶ እንደ ሆነ ይሰረይለታል። ");
INSERT INTO amh_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","እርስ በርሳችሁ በኃጢአታችሁ ተናዘዙ። ትፈወሱም ዘንድ እያንዳንዱ ስለ ሌላው ይጸልይ፤ የጻድቅ ሰው ጸሎት በሥራዋ እጅግ ኃይል ታደርጋለች። ");
INSERT INTO amh_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","ኤልያስ እንደ እኛ የሆነ ሰው ነበረ፥ ዝናብም እንዳይዘንብ አጥብቆ ጸለየ፥ በምድርም ላይ ሦስት ዓመት ከስድስት ወር አልዘነበም፤ ሁለተኛም ጸለየ፥ ");
INSERT INTO amh_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","ሰማዩም ዝናብን ሰጠ ምድሪቱም ፍሬዋን አበቀለች። ");
INSERT INTO amh_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","ወንድሞቼ ሆይ፥ ከእናንተ ማንም ከእውነት ቢስት አንዱም ቢመልሰው፥ ");
INSERT INTO amh_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","ኃጢአተኛን ከተሳሳተበት መንገድ የሚመልሰው ነፍሱን ከሞት እንዲያድን፥ የኃጢአትንም ብዛት እንዲሸፍን ይወቅ። ");
INSERT INTO amh_vpl VALUES ("P11_1","090_1_1","1PE","1","1","10","ለእናንተም ስለሚሰጠው ጸጋ ትንቢት የተናገሩት ነቢያት ስለዚህ መዳን ተግተው እየፈለጉ መረመሩት፤ ");
INSERT INTO amh_vpl VALUES ("P11_11","090_1_11","1PE","1","11","11","በእነርሱም የነበረ የክርስቶስ መንፈስ፥ ስለ ክርስቶስ መከራ ከእርሱም በኋላ ስለሚመጣው ክብር አስቀድሞ እየመሰከረ፥ በምን ወይም እንዴት ባለ ዘመን እንዳመለከተ ይመረምሩ ነበር። ");
INSERT INTO amh_vpl VALUES ("P11_12","090_1_12","1PE","1","12","12","ለእነርሱም ከሰማይ በተላከ በመንፈስ ቅዱስ ወንጌልን የሰበኩላችሁ ሰዎች አሁን ባወሩላችሁ ነገር እናንተን እንጂ ራሳቸውን እንዳላገለገሉ ተገለጠላቸው፤ ይህንም ነገር መላእክቱ ሊመለከቱ ይመኛሉ። ");
INSERT INTO amh_vpl VALUES ("P11_13","090_1_13","1PE","1","13","13","ስለዚህ የልቡናችሁን ወገብ ታጥቃችሁና በመጠን ኖራችሁ፥ ኢየሱስ ክርስቶስ ሲገለጥ የምታገኙትን ጸጋ ፈጽማችሁ ተስፋ አድርጉ። ");
INSERT INTO amh_vpl VALUES ("P11_14","090_1_14","1PE","1","14","14","እንደሚታዘዙ ልጆች ባለማወቃችሁ አስቀድሞ የኖራችሁበትን ምኞት አትከተሉ። ");
INSERT INTO amh_vpl VALUES ("P11_15","090_1_15","1PE","1","15","17","ለሰው ፊትም ሳያደላ በእያንዳንዱ ላይ እንደ ሥራው የሚፈርደውን አባት ብላችሁ ብትጠሩ በእንግድነታችሁ ዘመን በፍርሃት ኑሩ። ");
INSERT INTO amh_vpl VALUES ("P11_18","090_1_18","1PE","1","18","22","ለእውነት እየታዘዛችሁ ግብዝነት ለሌለበት ለወንድማማች መዋደደ ነፍሳችሁን አንጽታችሁ እርስ በርሳችሁ ከልባችሁ አጥብቃችሁ ተዋደዱ። ");
INSERT INTO amh_vpl VALUES ("P11_23","090_1_23","1PE","1","23","23","ዳግመኛ የተወለዳችሁት ከሚጠፋ ዘር አይደለም፥ በሕያውና ለዘላለም በሚኖር በእግዚአብሔር ቃል ከማይጠፋ ዘር ነው እንጂ። ");
INSERT INTO amh_vpl VALUES ("P11_24","090_1_24","1PE","1","24","24","ሥጋ ሁሉ እንደ ሣር ክብሩም ሁሉ እንደ ሣር አበባ ነውና፤ ሣሩ ይጠወልጋል አበባውም ይረግፋል፤ ");
INSERT INTO amh_vpl VALUES ("P11_25","090_1_25","1PE","1","25","25","የጌታ ቃል ግን ለዘላለም ይኖራል። በወንጌልም የተሰበከላችሁ ቃል ይህ ነው። ");
INSERT INTO amh_vpl VALUES ("P12_1","090_2_1","1PE","2","1","1","እንግዲህ ክፋትን ሁሉ ተንኰልንም ሁሉ ግብዝነትንም ቅንዓትንም ሐሜትንም ሁሉ አስወግዳችሁ፥ ");
INSERT INTO amh_vpl VALUES ("P12_2","090_2_2","1PE","2","2","4","በሰውም ወደ ተጣለ በእግዚአብሔር ዘንድ ግን ወደ ተመረጠና ክቡር ወደ ሆነው ወደ ሕያው ድንጋይ ወደ እርሱ እየቀረባችሁ፥ ");
INSERT INTO amh_vpl VALUES ("P12_5","090_2_5","1PE","2","5","5","እናንተ ደግሞ እንደ ሕያዋን ድንጋዮች ሆናችሁ፥ በኢየሱስ ክርስቶስ ለእግዚአብሔር ደስ የሚያሰኝ መንፈሳዊ መሥዋዕትን ታቀርቡ ዘንድ ቅዱሳን ካህናት እንድትሆኑ መንፈሳዊ ቤት ለመሆን ተሠሩ። ");
INSERT INTO amh_vpl VALUES ("P12_6","090_2_6","1PE","2","6","6","በመጽሐፍ። እነሆ፥ የተመረጠና የከበረን የማዕዘን ራስ ድንጋይ በጽዮን አኖራለሁ በእርሱም የሚያምን አያፍርም ተብሎ ተጽፎአልና። ");
INSERT INTO amh_vpl VALUES ("P12_7","090_2_7","1PE","2","7","7","እንግዲህ ክብሩ ለእናንተ ለምታምኑት ነው፤ ለማያምኑ ግን አናጢዎች የጣሉት ድንጋይ እርሱ የማዕዘን ራስ የዕንቅፋትም ድንጋይ የማሰናከያም ዓለት ሆነ፤ ");
INSERT INTO amh_vpl VALUES ("P12_8","090_2_8","1PE","2","8","8","የማያምኑ ስለ ሆኑ በቃሉ ይሰናከሉበታልና፤ ለዚህ ደግሞ የተመደቡ ናቸው። ");
INSERT INTO amh_vpl VALUES ("P12_9","090_2_9","1PE","2","9","9","እናንተ ግን ከጨለማ ወደሚደነቅ ብርሃኑ የጠራችሁን የእርሱን በጎነት እንድትናገሩ የተመረጠ ትውልድ፥ የንጉሥ ካህናት፥ ቅዱስ ሕዝብ፥ ለርስቱ የተለየ ወገን ናችሁ፤ ");
INSERT INTO amh_vpl VALUES ("P12_10","090_2_10","1PE","2","10","10","እናንተ ቀድሞ ወገን አልነበራችሁም አሁን ግን የእግዚአብሔር ወገን ናችሁ፤ እናንተ ምሕረት ያገኛችሁ አልነበራችሁም አሁን ግን ምሕረትን አግኝታችኋል። ");
INSERT INTO amh_vpl VALUES ("P12_11","090_2_11","1PE","2","11","11","ወዳጆች ሆይ፥ ነፍስን ከሚዋጋ ሥጋዊ ምኞት ትርቁ ዘንድ እንግዶችና መጻተኞች እንደ መሆናችሁ እለምናችኋለሁ፤ ");
INSERT INTO amh_vpl VALUES ("P12_12","090_2_12","1PE","2","12","12","ስለሚመለከቱት ስለ መልካም ሥራችሁ፥ ክፉ እንደምታደርጉ በዚያ እናንተን በሚያሙበት ነገር፥ በሚጎበኝበት ቀን እግዚአብሔርን ያከብሩት ዘንድ በአሕዛብ መካከል ኑሮአችሁ መልካም ይሁን። ");
INSERT INTO amh_vpl VALUES ("P12_13","090_2_13","1PE","2","13","13","ስለ ጌታ ብላችሁ ለሰው ሥርዓት ሁሉ ተገዙ፤ ለንጉሥም ቢሆን፥ ከሁሉ በላይ ነውና፤ ");
INSERT INTO amh_vpl VALUES ("P12_14","090_2_14","1PE","2","14","14","ለመኳንንትም ቢሆን፥ ክፉ የሚያደርጉትን ለመቅጣት በጎም የሚያደርጉትን ለማመስገን ከእርሱ ተልከዋልና ተገዙ። ");
INSERT INTO amh_vpl VALUES ("P12_15","090_2_15","1PE","2","15","15","በጎ እያደረጋችሁ፥ የማያውቁትን ሞኞች ዝም ታሰኙ ዘንድ እንዲህ የእግዚአብሔር ፈቃድ ነውና፤ ");
INSERT INTO amh_vpl VALUES ("P12_16","090_2_16","1PE","2","16","16","አርነት ወጥታችሁ እንደ እግዚአብሔር ባሪያዎች ሁኑ እንጂ ያ አርነት ለክፋት መሸፈኛ እንዲሆን አታድርጉ። ");
INSERT INTO amh_vpl VALUES ("P12_17","090_2_17","1PE","2","17","17","ሁሉን አክብሩ፥ ወንድሞችን ውደዱ፥ እግዚአብሔርን ፍሩ፥ ንጉሥን አክብሩ። ");
INSERT INTO amh_vpl VALUES ("P12_18","090_2_18","1PE","2","18","18","ሎሌዎች ሆይ፥ ለበጎዎችና ለገሮች ጌቶቻችሁ ብቻ ሳይሆን ለጠማሞች ደግሞ በፍርሃት ሁሉ ተገዙ። ");
INSERT INTO amh_vpl VALUES ("P12_19","090_2_19","1PE","2","19","19","በግፍ መከራን የሚቀበል ሰው እግዚአብሔርን እያሰበ ኃዘንን ቢታገሥ ምስጋና ይገባዋልና። ");
INSERT INTO amh_vpl VALUES ("P12_20","090_2_20","1PE","2","20","20","ኃጢአት አድርጋችሁ ስትጎሰሙ ብትታገሡ፥ ምን ክብር አለበት? ነገር ግን መልካም አድርጋችሁ መከራን ስትቀበሉ ብትታገሡ፥ ይህ ነገር በእግዚአብሔር ዘንድ ምስጋና ይገባዋል። ");
INSERT INTO amh_vpl VALUES ("P12_21","090_2_21","1PE","2","21","21","የተጠራችሁለት ለዚህ ነውና፤ ክርስቶስ ደግሞ ፍለጋውን እንድትከተሉ ምሳሌ ትቶላችሁ ስለ እናንተ መከራን ተቀብሎአልና። ");
INSERT INTO amh_vpl VALUES ("P12_22","090_2_22","1PE","2","22","22","እርሱም ኃጢአት አላደረገም፥ ተንኰልም በአፉ አልተገኘበትም፤ ");
INSERT INTO amh_vpl VALUES ("P12_23","090_2_23","1PE","2","23","23","ሲሰድቡት መልሶ አልተሳደበም መከራንም ሲቀበል አልዛተም፥ ነገር ግን በጽድቅ ለሚፈርደው ራሱን አሳልፎ ሰጠ፤ ");
INSERT INTO amh_vpl VALUES ("P12_24","090_2_24","1PE","2","24","24","ለኃጢአት ሞተን ለጽድቅ እንድንኖር፥ እርሱ ራሱ በሥጋው ኃጢአታችንን በእንጨት ላይ ተሸከመ፤*ፍ1* ");
INSERT INTO amh_vpl VALUES ("P12_25","090_2_25","1PE","2","25","25","በመገረፉ ቁስል ተፈወሳችሁ። እንደ በጎች ትቅበዘበዙ ነበርና፥ አሁን ግን ወደ ነፍሳችሁ እረኛና ጠባቂ ተመልሳችኋል። ");
INSERT INTO amh_vpl VALUES ("P13_1","090_3_1","1PE","3","1","3","ለእናንተም ጠጕርን በመሸረብና ወርቅን በማንጠልጠል ወይም ልብስን በመጎናጸፍ በውጭ የሆነ ሽልማት አይሁንላችሁ፥ ");
INSERT INTO amh_vpl VALUES ("P13_4","090_3_4","1PE","3","4","4","ነገር ግን በእግዚአብሔር ፊት ዋጋው እጅግ የከበረ የዋህና ዝግተኛ መንፈስ ያለውን የማይጠፋውን ልብስ ለብሶ የተሰወረ የልብ ሰው ይሁንላችሁ። ");
INSERT INTO amh_vpl VALUES ("P13_5","090_3_5","1PE","3","5","5","እንዲህ በቀድሞ ዘመን በእግዚአብሔር ተስፋ ያደረጉት ቅዱሳት ሴቶች ደግሞ ለባሎቻቸው ሲገዙ ተሸልመው ነበርና፤ ");
INSERT INTO amh_vpl VALUES ("P13_6","090_3_6","1PE","3","6","6","እንዲሁም ሣራ ለአብርሃም። ጌታ ብላ እየጠራችው ታዘዘችለት፤ እናንተም ከሚያስደነግጥ ነገር አንዳች እንኳ ሳትፈሩ መልካም ብታደርጉ ልጆችዋ ናችሁ። ");
INSERT INTO amh_vpl VALUES ("P13_7","090_3_7","1PE","3","7","7","እንዲሁም፥ እናንተ ባሎች ሆይ፥ ደካማ ፍጥረት ስለ ሆኑ ከሚስቶቻችሁ ጋር በማስተዋል አብራችሁ ኑሩ፤ ጸሎታችሁ እንዳይከለከል አብረው ደግሞ የሕይወትን ጸጋ እንደሚወርሱ አድርጋችሁ አክብሩአቸው። ");
INSERT INTO amh_vpl VALUES ("P13_8","090_3_8","1PE","3","8","8","በመጨረሻው ሁላችሁ በአንድ ልብ ሁኑ፥ የሌላው መከራ ለእናንተ እንደሚሆን አድርጉ፥ እንደወንድሞች ተዋደዱ፥ ርኅሩኆችና ትሑታን ሁኑ፤ ");
INSERT INTO amh_vpl VALUES ("P13_9","090_3_9","1PE","3","9","9","ክፉን በክፉ ፈንታ ወይም ስድብን በስድብ ፈንታ አትመልሱ በዚህ ፈንታ ባርኩ እንጂ፥ በረከትን ልትወርሱ ለዚህ ተጠርታችኋልና። ");
INSERT INTO amh_vpl VALUES ("P13_10","090_3_10","1PE","3","10","10","ሕይወትን ሊወድ መልካሞችንም ቀኖች ሊያይ የሚፈልግ ሰው፥ መላሱን ከክፉ ከንፈሮቹንም ተንኰልን ከመናገር ይከልክል፤ ");
INSERT INTO amh_vpl VALUES ("P13_11","090_3_11","1PE","3","11","11","ከክፉ ፈቀቅ ይበል፥ መልካምንም ያድርግ፥ ሰላምን ይሻ ይከተለውም፤ ");
INSERT INTO amh_vpl VALUES ("P13_12","090_3_12","1PE","3","12","12","የጌታ ዓይኖች ወደ ጻድቃን ናቸውና፥ ጆሮዎቹም ለጸሎታቸው ተከፍተዋል፥ የጌታ ፊት ግን ክፉ ነገርን በሚያደርጉ ላይ ነው። ");
INSERT INTO amh_vpl VALUES ("P13_13","090_3_13","1PE","3","13","13","በጎንም ለማድረግ ብትቀኑ የሚያስጨንቃችሁ ማን ነው? ");
INSERT INTO amh_vpl VALUES ("P13_14","090_3_14","1PE","3","14","14","ነገር ግን ስለ ጽድቅ እንኳ መከራን ብትቀበሉ ብፁዓን ናችሁ። ማስፈራራታቸውንም አትፍሩ አትናወጡም፥ ");
INSERT INTO amh_vpl VALUES ("P13_15","090_3_15","1PE","3","15","15","ዳሩ ግን ጌታን እርሱም ክርስቶስ በልባችሁ ቀድሱት። በእናንተ ስላለ ተስፋ ምክንያትን ለሚጠይቁዋችሁ ሁሉ መልስ ለመስጠት ዘወትር የተዘጋጃችሁ ሁኑ፥ ነገር ግን በየዋህነትና በፍርሃት ይሁን። ");
INSERT INTO amh_vpl VALUES ("P13_16","090_3_16","1PE","3","16","16","በክርስቶስ ያለውን መልካሙን ኑሮአችሁን የሚሳደቡ ሰዎች ክፉን እንደምታደርጉ በሚያሙበት ነገር እንዲያፍሩ በጎ ሕሊና ይኑራችሁ። ");
INSERT INTO amh_vpl VALUES ("P13_17","090_3_17","1PE","3","17","17","የእግዚአብሔር ፈቃድ እንዲህ ቢሆን፥ ክፉ ስለ ማድረግ ሳይሆን በጎ ስለ ማድረግ መከራን ብትቀበሉ ይሻላችኋልና። ");
INSERT INTO amh_vpl VALUES ("P13_18","090_3_18","1PE","3","18","18","ክርስቶስ ደግሞ ወደ እግዚአብሔር እንዲያቀርበን እርሱ ጻድቅ ሆኖ ስለ ዓመፀኞች አንድ ጊዜ በኃጢአት ምክንያት ሞቶአልና፤ በሥጋ ሞተ በመንፈስ ግን ሕያው ሆነ፥ ");
INSERT INTO amh_vpl VALUES ("P13_19","090_3_19","1PE","3","19","19","በእርሱም ደግሞ ሄዶ በወኅኒ ለነበሩ ነፍሳት ሰበከላቸው፤ ");
INSERT INTO amh_vpl VALUES ("P13_20","090_3_20","1PE","3","20","20","ጥቂቶች ማለት ስምንት ነፍስ በውኃ የዳኑበት መርከብ ሲዘጋጅ፥ የእግዚአብሔር ትዕግሥት በኖኅ ዘመን በቈየ ጊዜ ቀድሞ አልታዘዙም። ");
INSERT INTO amh_vpl VALUES ("P13_21","090_3_21","1PE","3","21","21","ይህም ውኃ ደግሞ ማለት ጥምቅት ምሳሌው ሆኖ አሁን ያድነናል፥ የሰውነትን እድፍ ማስወገድ አይደለም፥ ለእግዚአብሔር የበጎ ሕሊና ልመና ነው እንጂ፥ ይህም በኢየሱስ ክርስቶስ ትንሣኤ ነው፤ ");
INSERT INTO amh_vpl VALUES ("P13_22","090_3_22","1PE","3","22","22","እርሱም መላእክትና ሥልጣናት ኃይላትም ከተገዙለት በኋላ ወደ ሰማይ ሄዶ በእግዚአብሔር ቀኝ አለ። ");
INSERT INTO amh_vpl VALUES ("P14_1","090_4_1","1PE","4","1","3","የአሕዛብን ፈቃድ ያደረጋችሁበት በመዳራትና በሥጋ ምኞትም በስካርም በዘፈንም ያለ ልክም በመጠጣት ነውርም ባለበት በጣዖት ማምለክ የተመላለሳችሁበት ያለፈው ዘመን ይበቃልና። ");
INSERT INTO amh_vpl VALUES ("P14_4","090_4_4","1PE","4","4","4","በዚህም ነገር ወደዚያ መዳራት ብዛት ከእነርሱ ጋር ስለማትሮጡ እየተሳደቡ ይደነቃሉ፤ ");
INSERT INTO amh_vpl VALUES ("P14_5","090_4_5","1PE","4","5","5","ግን እነርሱ በሕያዋንና በሙታን ላይ ሊፈርድ ለተዘጋጀው መልስ ይሰጣሉ። ");
INSERT INTO amh_vpl VALUES ("P14_6","090_4_6","1PE","4","6","6","እንደሰዎች በሥጋ እንዲፈረድባቸው በመንፈስ ግን እንደ እግዚአብሔር እንዲኖሩ ስለዚህ ምክንያት ወንጌል ለሙታን ደግሞ ተሰብኮላቸው ነበርና። ");
INSERT INTO amh_vpl VALUES ("P14_7","090_4_7","1PE","4","7","7","ዳሩ ግን የነገር ሁሉ መጨረሻ ቀርቦአል። እንግዲህ እንደ ባለ አእምሮ አስቡ፥ ");
INSERT INTO amh_vpl VALUES ("P14_8","090_4_8","1PE","4","8","8","ትጸልዩም ዘንድ በመጠን ኑሩ፤ ፍቅር የኃጢአትን ብዛት ይሸፍናልና ከሁሉ በፊት እርስ በርሳችሁ አጥብቃችሁ ተዋደዱ። ");
INSERT INTO amh_vpl VALUES ("P14_9","090_4_9","1PE","4","9","9","ያለ ማንጐራጐር እርስ በርሳችሁ እንግድነትን ተቀባበሉ፤ ");
INSERT INTO amh_vpl VALUES ("P14_10","090_4_10","1PE","4","10","10","ልዩ ልዩን የእግዚአብሔርን ጸጋ ደጋግ መጋቢዎች እንደ መሆናችሁ፥ እያንዳንዳችሁ የጸጋን ስጦታ እንደ ተቀበላችሁ መጠን በዚያው ጸጋ እርስ በርሳችሁ አገልግሉ፤ ");
INSERT INTO amh_vpl VALUES ("P14_11","090_4_11","1PE","4","11","11","ማንም ሰው የሚናገር ቢሆን፥ እንደ እግዚአብሔር ቃል ይናገር፤ የሚያገለግልም ቢሆን፥ እግዚአብሔር በሚሰጠኝ ኃይል ነው ብሎ ያገልግል፤ ክብርና ሥልጣን እስከ ዘላለም ድረስ ለእርሱ በሚሆነው በኢየሱስ ክርስቶስ በኩል እግዚአብሔር በነገር ሁሉ ይከብር ዘንድ፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("P14_12","090_4_12","1PE","4","12","12","ወዳጆች ሆይ፥ በእናንተ መካከል እንደ እሳት ሊፈትናችሁ ስለሚሆነው መከራ ድንቅ ነገር እንደ መጣባችሁ አትደነቁ፤ ");
INSERT INTO amh_vpl VALUES ("P14_13","090_4_13","1PE","4","13","13","ነገር ግን ክብሩ ሲገለጥ ደግሞ ሐሤት እያደረጋችሁ ደስ እንዲላችሁ፥ በክርስቶስ መከራ በምትካፈሉበት ልክ ደስ ይበላችሁ። ");
INSERT INTO amh_vpl VALUES ("P14_14","090_4_14","1PE","4","14","14","ስለ ክርስቶስ ስም ብትነቀፉ የክብር መንፈስ የእግዚአብሔር መንፈስ በእናንተ ላይ ያርፋልና ብፁዓን ናችሁ። ");
INSERT INTO amh_vpl VALUES ("P14_15","090_4_15","1PE","4","15","15","ከእናንተ ማንም ነፍሰ ገዳይ ወይም ሌባ ወይም ክፉ አድራጊ እንደሚሆን ወይም በሌሎች ጒዳይ እንደሚገባ ሆኖ መከራን አይቀበል፤ ");
INSERT INTO amh_vpl VALUES ("P14_16","090_4_16","1PE","4","16","16","ክርስቲያን እንደሚሆን ግን መከራን ቢቀበል ስለዚህ ስም እግዚአብሔርን ያመስግን እንጂ አይፈር። ");
INSERT INTO amh_vpl VALUES ("P14_17","090_4_17","1PE","4","17","17","ፍርድ ከእግዚአብሔር ቤት ተነሥቶ የሚጀመርበት ጊዜ ደርሶአልና፤ አስቀድሞም በእኛ የሚጀመር ከሆነ ለእግዚአብሔር ወንጌል የማይታዘዙ መጨረሻቸው ምን ይሆን? ");
INSERT INTO amh_vpl VALUES ("P14_18","090_4_18","1PE","4","18","18","ጻድቅም በጭንቅ የሚድን ከሆነ ዓመፀኛውና ኃጢአተኛው ወዴት ይታይ ዘንድ አለው? ");
INSERT INTO amh_vpl VALUES ("P14_19","090_4_19","1PE","4","19","19","ስለዚህ ደግሞ እንደ እግዚአብሔር ፈቃድ መከራን የሚቀበሉ፥ መልካምን እያደረጉ ነፍሳቸውን ለታመነ ፈጣሪ አደራ ይስጡ። ");
INSERT INTO amh_vpl VALUES ("P15_1","090_5_1","1PE","5","1","1","እንግዲህ እኔ፥ ከእነርሱ ጋር ሽማግሌ የክርስቶስም መከራ ምስክር ደግሞም ሊገለጥ ካለው ክብር ተካፋይ የሆንሁ፥ በመካከላቸው ያሉትን ሽማግሌዎች እመክራቸዋለሁ፤ ");
INSERT INTO amh_vpl VALUES ("P15_2","090_5_2","1PE","5","2","2","በእናንተ ዘንድ ያለውን የእግዚአብሔርን መንጋ ጠብቁ፤ እንደ እግዚአብሔር ፈቃድ በውድ እንጂ በግድ ሳይሆን፥ በበጎ ፈቃድ እንጂ መጥፎውን ረብ በመመኘት ሳይሆን ጐብኙት፤ ");
INSERT INTO amh_vpl VALUES ("P15_3","090_5_3","1PE","5","3","3","ለመንጋው ምሳሌ ሁኑ እንጂ ማኅበሮቻችሁን በኃይል አትግዙ፤ ");
INSERT INTO amh_vpl VALUES ("P15_4","090_5_4","1PE","5","4","4","የእረኞችም አለቃ በሚገለጥበት ጊዜ የማያልፈውን የክብርን አክሊል ትቀበላላችሁ። ");
INSERT INTO amh_vpl VALUES ("P15_5","090_5_5","1PE","5","5","5","እንዲሁም፥ ጐበዞች ሆይ፥ ለሽማግሌዎች ተገዙ፤ ሁላችሁም እርስ በርሳችሁ እየተዋረዳችሁ ትሕትናን እንደ ልብስ ታጠቁ፥ እግዚአብሔር ትዕቢተኞችን ይቃወማልና፥ ለትሑታን ግን ጸጋን ይሰጣል። ");
INSERT INTO amh_vpl VALUES ("P15_6","090_5_6","1PE","5","6","6","እንግዲህ በጊዜው ከፍ እንዲያደርጋችሁ ከኃይለኛው ከእግዚአብሔር እጅ በታች ራሳችሁን አዋርዱ፤ ");
INSERT INTO amh_vpl VALUES ("P15_7","090_5_7","1PE","5","7","7","እርሱ ስለ እናንተ ያስባልና የሚያስጨንቃችሁን ሁሉ በእርሱ ላይ ጣሉት። ");
INSERT INTO amh_vpl VALUES ("P15_8","090_5_8","1PE","5","8","8","በመጠን ኑሩ ንቁም፥ ባላጋራችሁ ዲያብሎስ የሚውጠውን ፈልጎ እንደሚያገሣ አንበሳ ይዞራልና፤ ");
INSERT INTO amh_vpl VALUES ("P15_9","090_5_9","1PE","5","9","9","በዓለም ያሉት ወንድሞቻችሁ ያን መከራ በሙሉ እንዲቀበሉ እያወቃችሁ በእምነት ጸንታችሁ ተቃወሙት። ");
INSERT INTO amh_vpl VALUES ("P15_10","090_5_10","1PE","5","10","10","በክርስቶስ ኢየሱስ ወደ ዘላለም ክብሩ የጠራችሁ የጸጋ ሁሉ አምላክ ለጥቂት ጊዜ መከራን ከተቀበላችሁ በኋላ ራሱ ፍጹማን ያደርጋችኋል ያጸናችሁምል ያበረታችሁማል። ");
INSERT INTO amh_vpl VALUES ("P15_11","090_5_11","1PE","5","11","11","ለእርሱ ክብርና ኃይል እስከዘላለም ድረስ ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("P15_12","090_5_12","1PE","5","12","12","እየመከርኋችሁና የምትቆሙባት ጸጋ እውነትኛ የእግዚአብሔር ጸጋ እንድትሆን እየመሰከርሁላችሁ፥ የታመነ ወንድም እንደ ሆነ በቈጠርሁት በስልዋኖስ እጅ በአጭሩ ጽፌላችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("P15_13","090_5_13","1PE","5","13","13","ከእናንተ ጋር ተመርጣ በባቢሎን ያለች ቤተ ክርስቲያን ልጄም ማርቆስ ሰላምታ ያቀርቡላችኋል። ");
INSERT INTO amh_vpl VALUES ("P15_14","090_5_14","1PE","5","14","14","በፍቅር አሳሳም እርስ በርሳችሁ ሰላምታ ተሰጣጡ። በክርስቶስ ላላችሁ ለሁላችሁ ሰላም ይሁን። አሜን። ");
INSERT INTO amh_vpl VALUES ("P21_1","091_1_1","2PE","1","1","1","የኢየሱስ ክርስቶስ ባሪያና ሐዋርያ የሆነ ስምዖን ጴጥሮስ፥ በአምላካችንና በመድኃኒታችን በኢየሱስ ክርስቶስ ጽድቅ ካገኘነው ጋር የተካከለ የክብር እምነትን ላገኙ፤ ");
INSERT INTO amh_vpl VALUES ("P21_2","091_1_2","2PE","1","2","4","ስለ ክፉ ምኞት በዓለም ካለው ጥፋት አምልጣችሁ ከመለኮት ባሕርይ ተካፋዮች በተስፋ ቃል እንድትሆኑ፥ በእነዚያ ክብርና በጎነት የተከበረና እጅግ ታላቅ የሆነ ተስፋን ሰጠን። ");
INSERT INTO amh_vpl VALUES ("P21_5","091_1_5","2PE","1","5","5","ስለዚህም ምክንያት ትጋትን ሁሉ እያሳያችሁ በእምነታችሁ በጎነትን ጨምሩ፥ ");
INSERT INTO amh_vpl VALUES ("P21_6","091_1_6","2PE","1","6","6","በበጎነትም እውቀትን፥ በእውቀትም ራስን መግዛት፥ ራስንም በመግዛት መጽናትን፥ በመጽናትም እግዚአብሔርን መምሰል፥ ");
INSERT INTO amh_vpl VALUES ("P21_7","091_1_7","2PE","1","7","7","እግዚአብሔርንም በመምሰል የወንድማማችን መዋደድ፥ በወንድማማችም መዋደድ ፍቅርን ጨምሩ። ");
INSERT INTO amh_vpl VALUES ("P21_8","091_1_8","2PE","1","8","8","እነዚህ ነገሮች ለእናንተ ሆነው ቢበዙ፥ በጌታችን በኢየሱስ ክርስቶስ እውቀት ሥራ ፈቶችና ፍሬ ቢሶች እንዳትሆኑ ያደርጉአችኋልና፤ ");
INSERT INTO amh_vpl VALUES ("P21_9","091_1_9","2PE","1","9","9","እነዚህ ነገሮች የሌሉት ዕውር ነውና፥ በቅርብም ያለውን ብቻ ያያል፥ የቀደመውንም ኃጢአቱን መንጻት ረስቶአል። ");
INSERT INTO amh_vpl VALUES ("P21_10","091_1_10","2PE","1","10","10","ስለዚህ፥ ወንድሞች ሆይ፥ መጠራታችሁንና መመረጣችሁን ታጸኑ ዘንድ ከፊት ይልቅ ትጉ፤ እነዚህን ብታደርጉ ከቶ አትሰናከሉምና። ");
INSERT INTO amh_vpl VALUES ("P21_11","091_1_11","2PE","1","11","11","እንዲሁ ወደ ዘላለሙ ወደ ጌታችንና መድኃኒታችን ወደ ኢየሱስ ክርስቶስ መንግሥት መግባት በሙላት ይሰጣችኋልና። ");
INSERT INTO amh_vpl VALUES ("P21_12","091_1_12","2PE","1","12","12","ስለዚህ እነዚህን ነገሮች ምንም ብታውቁ በእናንተም ዘንድ ባለ እውነት ምንም ብትጸኑ፥ ስለ እነዚህ ዘወትር እንዳሳስባችሁ ቸል አልልም። ");
INSERT INTO amh_vpl VALUES ("P21_13","091_1_13","2PE","1","13","13","ሁልጊዜም በዚህ ማደሪያ ሳለሁ በማሳሰቤ ላነቃችሁ የሚገባኝ ይመስለኛል። ");
INSERT INTO amh_vpl VALUES ("P21_14","091_1_14","2PE","1","14","14","ጌታችን ኢየሱስ ክርስቶስ እንዳመለከተኝ ከዚህ ማደሪያዬ መለየቴ ፈጥኖ እንዲሆን አውቃለሁና። ");
INSERT INTO amh_vpl VALUES ("P21_15","091_1_15","2PE","1","15","15","ከመውጣቴም በኋላ እነዚህን ነገሮች እንድታስቡ በየጊዜው ትችሉ ዘንድ እተጋለሁ። ");
INSERT INTO amh_vpl VALUES ("P21_16","091_1_16","2PE","1","16","16","የእርሱን ግርማ አይተን እንጂ በብልሃት የተፈጠረውን ተረት ሳንከተል የጌታችንን የኢየሱስ ክርስቶስን ኃይልና መምጣት አስታወቅናችሁ። ");
INSERT INTO amh_vpl VALUES ("P21_17","091_1_17","2PE","1","17","17","ከገናናው ክብር። በእርሱ ደስ የሚለኝ የምወደው ልጄ ይህ ነው የሚል ያ ድምፅ በመጣለት ጊዜ ከእግዚአብሔር አብ ክብርንና ምስጋናን ተቀብሎአልና፤ ");
INSERT INTO amh_vpl VALUES ("P21_18","091_1_18","2PE","1","18","18","እኛም በቅዱሱ ተራራ ከእርሱ ጋር ሳለን ይህን ድምፅ ከሰማይ ሲወርድ ሰማን። ");
INSERT INTO amh_vpl VALUES ("P21_19","091_1_19","2PE","1","19","19","ከእርሱም ይልቅ እጅግ የጸና የትንቢት ቃል አለን፤ ምድርም እስኪጠባ ድረስ የንጋትም ኮከብ በልባችሁ እስኪወጣ ድረስ፥ ሰው በጨለማ ስፍራ የሚበራን መብራት እንደሚጠነቀቅ ይህን ቃል እየጠነቀቃችሁ መልካም ታደርጋላችሁ። ");
INSERT INTO amh_vpl VALUES ("P21_20","091_1_20","2PE","1","20","20","ይህን በመጀመሪያ እወቁ፤ በመጽሐፍ ያለውን ትንቢት ሁሉ ማንም ለገዛ ራሱ ሊተረጉም አልተፈቀደም፤ ");
INSERT INTO amh_vpl VALUES ("P21_21","091_1_21","2PE","1","21","21","ትንቢት ከቶ በሰው ፈቃድ አልመጣምና፥ ዳሩ ግን በእግዚአብሔር ተልከው ቅዱሳን ሰዎች በመንፈስ ቅዱስ ተነድተው ተናገሩ። ");
INSERT INTO amh_vpl VALUES ("P22_1","091_2_1","2PE","2","1","1","ነገር ግን ሐሰተኞች ነቢያት ደግሞ በሕዝቡ መካከል ነበሩ እንዲሁም በመካከላችሁ ደግሞ ሐሰተኞች አስተማሪዎች ይሆናሉ፤ እነርሱም የዋጃቸውን ጌታ እንኳ ክደው የሚፈጥንን ጥፋት በራሳቸው ላይ እየሳቡ የሚያጠፋ ኑፋቄን አሹልከው ያገባሉ፤ ");
INSERT INTO amh_vpl VALUES ("P22_2","091_2_2","2PE","2","2","2","ብዙዎችም በመዳራታቸው ይከተሉአቸዋል በእነርሱም ጠንቅ የእውነት መንገድ ይሰደባል። ");
INSERT INTO amh_vpl VALUES ("P22_3","091_2_3","2PE","2","3","3","ገንዘብንም በመመኘት በተፈጠረ ነገር ይረቡባችኋል፤ ፍርዳቸውም ከጥንት ጀምሮ አይዘገይም ጥፋታቸውም አያንቀላፋም። ");
INSERT INTO amh_vpl VALUES ("P22_4","091_2_4","2PE","2","4","4","እግዚአብሔር ኃጢአትን ላደረጉ መላእክት ሳይራራላቸው ወደ ገሃነም ጥሎ በጨለማ ጉድጓድ ለፍርድ ሊጠበቁ አሳልፎ ከሰጣቸው፥ ");
INSERT INTO amh_vpl VALUES ("P22_5","091_2_5","2PE","2","5","5","ለቀደመውም ዓለም ሳይራራ ከሌሎች ሰባት ጋር ጽድቅን የሚሰብከውን ኖኅን አድኖ በኃጢአተኞች ዓለም ላይ የጥፋትን ውኃ ካወረደ፥ ");
INSERT INTO amh_vpl VALUES ("P22_6","091_2_6","2PE","2","6","6","ኃጢአትንም ያደርጉ ዘንድ ላሉት ምሳሌ አድርጎ ከተማዎችን ሰዶምንና ገሞራን አመድ እስኪሆኑ ድረስ አቃጥሎና ገልብጦ ከፈረደባቸው፥ ");
INSERT INTO amh_vpl VALUES ("P22_7","091_2_7","2PE","2","7","11","ዳሩ ግን መላእክት በኃይልና በብርታት ከእነርሱ ይልቅ ምንም ቢበልጡ በጌታ ፊት በእነርሱ ላይ የስድብን ፍርድ አያመጡም። ");
INSERT INTO amh_vpl VALUES ("P22_12","091_2_12","2PE","2","12","12","እነዚህ ግን ለመጠመድና ለመጥፋት በፍጥረታቸው እንደ ተወለዱ አእምሮ እንደ ሌላቸው እንስሶች ሆነው፥ በማያውቁት ነገር እየተሳደቡ በጥፋታቸው ይጠፋሉ፤ ");
INSERT INTO amh_vpl VALUES ("P22_13","091_2_13","2PE","2","13","13","የዓመፃቸውን ደመወዝ ይቀበላሉ። በቀን ሲዘፍኑ እንደ ተድላ ይቆጥሩታል፤ ነውረኞችና ርኵሳን ሆነው ከእናንተ ጋር ሲጋበዙ በፍቅር ግብዣ ይዘፍናሉ፤ ");
INSERT INTO amh_vpl VALUES ("P22_14","091_2_14","2PE","2","14","14","ምንዝር የሞላባቸው ኃጢአትንም የማይተዉ ዓይኖች አሉአቸው፤ የማይጸኑትን ነፍሳት ያታልላሉ፤ መመኘትን የለመደ ልብ አላቸው፤ የተረገሙ ናቸው። ");
INSERT INTO amh_vpl VALUES ("P22_15","091_2_15","2PE","2","15","15","ቅንን መንገድ ትተው ተሳሳቱ፤ የባሶርን ልጅ የበለዓምን መንገድ ተከተሉ፤ እርሱ የዓመፃን ደመወዝ ወደደ፥ ");
INSERT INTO amh_vpl VALUES ("P22_16","091_2_16","2PE","2","16","16","ነገር ግን ስለ መተላለፉ ተዘለፈ፤ ቃል የሌለው አህያ በሰው ቃል ተናግሮ የነቢዩን እብድነት አገደ። ");
INSERT INTO amh_vpl VALUES ("P22_17","091_2_17","2PE","2","17","17","ድቅድቅ ጨለማ ለዘላለም የተጠበቀላቸው እነዚህ ውኃ የሌለባቸው ምንጮች በዐውሎ ነፋስም የተነዱ ደመናዎች ናቸው። ");
INSERT INTO amh_vpl VALUES ("P22_18","091_2_18","2PE","2","18","18","ከንቱና ከመጠን ይልቅ ታላቅ የሆነውን ቃል ይናገራሉና፥ በስሕተትም ከሚኖሩት አሁን የሚያመልጡትን በሥጋ ሴሰኛ ምኞት ያታልላሉ። ");
INSERT INTO amh_vpl VALUES ("P22_19","091_2_19","2PE","2","19","19","ራሳቸው የጥፋት ባሪያዎች ሆነው። አርነት ትወጣላችሁ እያሉ ተስፋ ይሰጡአቸዋል፤ ሰው ለተሸነፈበት ለእርሱ ተገዝቶ ባሪያ ነውና። ");
INSERT INTO amh_vpl VALUES ("P22_20","091_2_20","2PE","2","20","20","በጌታችንና በመድኃኒታችን በኢየሱስ ክርስቶስ እውቀት ከዓለም ርኵሰት ካመለጡ በኋላ ዳግመኛ በእርስዋ ተጠላልፈው የተሸነፉ ቢሆኑ፥ ከፊተኛው ኑሮአቸው ይልቅ የኋለኛው የባሰ ሆኖባቸዋል። ");
INSERT INTO amh_vpl VALUES ("P22_21","091_2_21","2PE","2","21","21","አውቀዋት ከተሰጣቸው ከቅድስት ትእዛዝ ከሚመለሱ የጽድቅን መንገድ ባላወቋት በተሻላቸው ነበርና። ");
INSERT INTO amh_vpl VALUES ("P22_22","091_2_22","2PE","2","22","22","ውሻ ወደ ትፋቱ ይመለሳል፥ ደግሞ። የታጠበች እርያ በጭቃ ለመንከባለል ትመለሳለች እንደሚባል እውነተኞች ምሳሌዎች ሆኖባቸዋል። ");
INSERT INTO amh_vpl VALUES ("P23_1","091_3_1","2PE","3","1","3","በመጨረሻው ዘመን እንደ ራሳቸው ምኞት የሚመላለሱ ዘባቾች በመዘበት እንዲመጡ ይህን በፊት እወቁ፤ ");
INSERT INTO amh_vpl VALUES ("P23_4","091_3_4","2PE","3","4","4","እነርሱም። የመምጣቱ የተስፋ ቃል ወዴት ነው? አባቶች ከሞቱባት ጊዜ፥ ከፍጥረት መጀመሪያ ይዞ ሁሉ እንዳለ ይኖራልና ይላሉ። ");
INSERT INTO amh_vpl VALUES ("P23_5","091_3_5","2PE","3","5","5","ሰማያት ከጥንት ጀምረው ምድርም በእግዚአብሔር ቃል ከውኃ ተጋጥማ በውኃ መካከል እንደ ነበሩ ወደው አያስተውሉምና፤ ");
INSERT INTO amh_vpl VALUES ("P23_6","091_3_6","2PE","3","6","6","በዚህም ምክንያት ያን ጊዜ የነበረ ዓለም በውኃ ሰጥሞ ጠፋ፤ ");
INSERT INTO amh_vpl VALUES ("P23_7","091_3_7","2PE","3","7","7","አሁን ያሉ ሰማያትና ምድር ግን እግዚአብሔርን የማያመልኩት ሰዎች እስከሚጠፉበት እስከ ፍርድ ቀን ድረስ ተጠብቀው በዚያ ቃል ለእሳት ቀርተዋል። ");
INSERT INTO amh_vpl VALUES ("P23_8","091_3_8","2PE","3","8","8","እናንተ ግን ወዳጆች ሆይ፥ በጌታ ዘንድ አንድ ቀን እንደ ሺህ ዓመት፥ ሺህ ዓመትም እንደ አንድ ቀን እንደ ሆነ ይህን አንድ ነገር አትርሱ። ");
INSERT INTO amh_vpl VALUES ("P23_9","091_3_9","2PE","3","9","9","ለአንዳንዶች የሚዘገይ እንደሚመስላቸው ጌታ ስለ ተስፋ ቃሉ አይዘገይም፥ ነገር ግን ሁሉ ወደ ንስሐ እንዲደርሱ እንጂ ማንም እንዳይጠፋ ወዶ ስለ እናንተ ይታገሣል። ");
INSERT INTO amh_vpl VALUES ("P23_10","091_3_10","2PE","3","10","10","የጌታው ቀን ግን እንደ ሌባ ሆኖ ይመጣል፤ በዚያም ቀን ሰማያት በታላቅ ድምፅ ያልፋሉ፥ የሰማይም ፍጥረት በትልቅ ትኵሳት ይቀልጣል፥ ምድርም በእርስዋም ላይ የተደረገው ሁሉ ይቃጠላል። ");
INSERT INTO amh_vpl VALUES ("P23_11","091_3_11","2PE","3","11","13","ነገር ግን ጽድቅ የሚኖርባትን አዲስ ሰማይና አዲስ ምድር እንደ ተስፋ ቃሉ እንጠብቃለን። ");
INSERT INTO amh_vpl VALUES ("P23_14","091_3_14","2PE","3","14","14","ስለዚህ፥ ወዳጆች ሆይ፥ ይህን እየጠበቃችሁ ያለ ነውርና ያለ ነቀፋ ሆናችሁ በሰላም በእርሱ እንድትገኙ ትጉ፥ ");
INSERT INTO amh_vpl VALUES ("P23_15","091_3_15","2PE","3","15","15","የጌታችንም ትዕግሥት መዳናችሁ እንደ ሆነ ቍጠሩ። እንዲህም የተወደደው ወንድማችን ጳውሎስ ደግሞ እንደ ተሰጠው ጥበብ መጠን ጻፈላችሁ፥ በመልእክቱም ሁሉ ደግሞ እንደ ነገረ ስለዚህ ነገር ተናገረ። ");
INSERT INTO amh_vpl VALUES ("P23_16","091_3_16","2PE","3","16","16","በእነዚያ ዘንድ ለማስተዋል የሚያስቸግር ነገር አለ፥ ያልተማሩትና የማይጸኑትም ሰዎች ሌሎችን መጻሕፍት እንደሚያጣምሙ እነዚህን ደግሞ ለገዛ ጥፋታቸው ያጣምማሉ። ");
INSERT INTO amh_vpl VALUES ("P23_17","091_3_17","2PE","3","17","17","እንግዲህ እናንተ፥ ወዳጆች ሆይ፥ ይህን አስቀድማችሁ ስለምታውቁ፥ በዓመፀኞቹ ስሕተት ተስባችሁ ከራሳችሁ ጽናት እንዳትወድቁ ተጠንቀቁ፤ ");
INSERT INTO amh_vpl VALUES ("P23_18","091_3_18","2PE","3","18","18","ነገር ግን በጌታችንና በመድኃኒታችን በኢየሱስ ክርስቶስ ጸጋና እውቀት እደጉ። ለእርሱ አሁንም እስከ ዘላለምም ቀን ድረስ ክብር ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("J11_1","092_1_1","1JN","1","1","1","ስለ ሕይወት ቃል ከመጀመሪያው የነበረውንና የሰማነውን በዓይኖቻችንም ያየነውን የተመለከትነውንም እጆቻችንም የዳሰሱትን እናወራለን፤ ");
INSERT INTO amh_vpl VALUES ("J11_2","092_1_2","1JN","1","2","2","ሕይወትም ተገለጠ አይተንማል እንመሰክርማለን፥ ከአብ ዘንድ የነበረውንም ለእኛም የተገለጠውን የዘላለምን ሕይወት እናወራላችኋለን፤ ");
INSERT INTO amh_vpl VALUES ("J11_3","092_1_3","1JN","1","3","3","እናንተ ደግሞ ከእኛ ጋር ኅብረት እንዲኖራችሁ ያየነውንና የሰማነውን ለእናንተ ደግሞ እናወራላችኋለን። ኅብረታችንም ከአባት ጋር ከልጁም ከኢየሱስ ክርስቶስ ጋር ነው። ");
INSERT INTO amh_vpl VALUES ("J11_4","092_1_4","1JN","1","4","4","ደስታችሁም እንዲፈጸም ይህን እንጽፍላችኋለን። ");
INSERT INTO amh_vpl VALUES ("J11_5","092_1_5","1JN","1","5","5","ከእርሱም የሰማናት ለእናንተም የምናወራላችሁ መልእክት። እግዚአብሔር ብርሃን ነው ጨለማም በእርሱ ዘንድ ከቶ የለም የምትል ይህች ናት። ");
INSERT INTO amh_vpl VALUES ("J11_6","092_1_6","1JN","1","6","6","ከእርሱ ጋር ኅብረት አለን ብንል በጨለማም ብንመላለስ እንዋሻለን እውነትንም አናደርግም፤ ");
INSERT INTO amh_vpl VALUES ("J11_7","092_1_7","1JN","1","7","7","ነገር ግን እርሱ በብርሃን እንዳለ በብርሃን ብንመላለስ ለእያንዳንዳችን ኅብረት አለን፥ የልጁም የኢየሱስ ክርስቶስ ደም ከኃጢአት ሁሉ ያነጻናል። ");
INSERT INTO amh_vpl VALUES ("J11_8","092_1_8","1JN","1","8","8","ኃጢአት የለብንም ብንል ራሳችንን እናስታለን፥ እውነትም በእኛ ውስጥ የለም። ");
INSERT INTO amh_vpl VALUES ("J11_9","092_1_9","1JN","1","9","9","በኃጢአታችን ብንናዘዝ ኃጢአታችንን ይቅር ሊለን ከዓመፃም ሁሉ ሊያነጻን የታመነና ጻድቅ ነው። ");
INSERT INTO amh_vpl VALUES ("J11_10","092_1_10","1JN","1","10","10","ኃጢአትን አላደረግንም ብንል ሐሰተኛ እናደርገዋለን ቃሉም በእኛ ውስጥ የለም። ");
INSERT INTO amh_vpl VALUES ("J12_1","092_2_1","1JN","2","1","1","ልጆቼ ሆይ፥ ኃጢአትን እንዳታደርጉ ይህን እጽፍላችኋለሁ። ማንም ኃጢአትን ቢያደርግ ከአብ ዘንድ ጠበቃ አለን እርሱም ጻድቅ የሆነ ኢየሱስ ክርስቶስ ነው። ");
INSERT INTO amh_vpl VALUES ("J12_2","092_2_2","1JN","2","2","2","እርሱም የኃጢአታችን ማስተስሪያ ነው፥ ለኃጢአታችንም ብቻ አይደለም፥ ነገር ግን ለዓለሙ ሁሉ ኃጢአት እንጂ። ");
INSERT INTO amh_vpl VALUES ("J12_3","092_2_3","1JN","2","3","3","ትእዛዛቱንም ብንጠብቅ በዚህ እንዳወቅነው እናውቃለን። ");
INSERT INTO amh_vpl VALUES ("J12_4","092_2_4","1JN","2","4","4","አውቄዋለሁ የሚል ትእዛዛቱንም የማይጠብቅ ውሸተኛ ነው እውነትም በእርሱ ውስጥ የለም። ");
INSERT INTO amh_vpl VALUES ("J12_5","092_2_5","1JN","2","5","5","ቃሉን ግን የሚጠብቅ ሁሉ በእርሱ የእግዚአብሔር ፍቅር በእውነት ተፈጽሞአል። በእርሱ እንዳለን በዚህ እናውቃለን፤ ");
INSERT INTO amh_vpl VALUES ("J12_6","092_2_6","1JN","2","6","6","በእርሱ እኖራለሁ የሚል እርሱ እንደ ተመላለሰ ራሱ ደግሞ ሊመላለስ ይገባዋል። ");
INSERT INTO amh_vpl VALUES ("J12_7","092_2_7","1JN","2","7","7","ወንድሞች ሆይ፥ ከመጀመሪያ የነበረቻችሁ አሮጌ ትእዛዝ እንጂ የምጽፍላችሁ አዲስ ትእዛዝ አይደለችም፤ አሮጌይቱ ትእዛዝ የሰማችኋት ቃል ናት። ");
INSERT INTO amh_vpl VALUES ("J12_8","092_2_8","1JN","2","8","8","ዳግመኛ አዲስ ትእዛዝን እጽፍላችኋለሁ፥ ይህም ነገር በእርሱ በእናንተም እውነተኛ ነው፤ ጨለማው ያልፋልና እውነተኛውም ብርሃን አሁን ይበራል። ");
INSERT INTO amh_vpl VALUES ("J12_9","092_2_9","1JN","2","9","9","በብርሃን አለሁ የሚል ወንድሙንም የሚጠላ እስከ አሁን በጨለማ አለ። ");
INSERT INTO amh_vpl VALUES ("J12_10","092_2_10","1JN","2","10","10","ወንድሙንም የሚወድ በብርሃን ይኖራል ማሰናከያም የለበትም፤ ");
INSERT INTO amh_vpl VALUES ("J12_11","092_2_11","1JN","2","11","11","ወንድሙን የሚጠላ ግን በጨለማ አለ፥ በጨለማም ይመላለሳል፥ የሚሄድበትንም አያውቅም፥ ጨለማው ዓይኖቹን አሳውሮታልና። ");
INSERT INTO amh_vpl VALUES ("J12_12","092_2_12","1JN","2","12","12","ልጆች ሆይ፥ ኃጢአታችሁ ስለ ስሙ ተሰርዮላችኋልና እጽፍላችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("J12_13","092_2_13","1JN","2","13","13","አባቶች ሆይ፥ ከመጀመሪያ የነበረውን አውቃችኋልና እጽፍላችኋለሁ። ጎበዞች ሆይ፥ ክፉውን አሸንፋችኋልና እጽፍላችኋለሁ። ልጆች ሆይ፥ አብን አውቃችኋልና እጽፍላችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("J12_14","092_2_14","1JN","2","14","14","አባቶች ሆይ፥ ከመጀመሪያ የነበረውን አውቃችኋልና እጽፍላችኋለሁ። ጐበዞች ሆይ፥ ብርቱዎች ስለ ሆናችሁ የእግዚአብሔርም ቃል በእናንተ ስለሚኖር ክፉውንም ስለ አሸነፋችሁ እጽፍላችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("J12_15","092_2_15","1JN","2","15","17","ዓለሙም ምኞቱም ያልፋሉ፤ የእግዚአብሔርን ፈቃድ የሚያደርግ ግን ለዘላለም ይኖራል። ");
INSERT INTO amh_vpl VALUES ("J12_18","092_2_18","1JN","2","18","18","ልጆች ሆይ፥ መጨረሻው ሰዓት ነው፥ የክርስቶስም ተቃዋሚ ይመጣ ዘንድ እንደ ሰማችሁ አሁን እንኳ ብዙዎች የክርስቶስ ተቃዋሚዎች ተነሥተዋል፤ ስለዚህም መጨረሻው ሰዓት እንደ ሆነ እናውቃለን። ");
INSERT INTO amh_vpl VALUES ("J12_19","092_2_19","1JN","2","19","19","ከእኛ ዘንድ ወጡ፥ ዳሩ ግን ከእኛ ወገን አልነበሩም፤ ከእኛ ወገንስ ቢሆኑ ከእኛ ጋር ጸንተው በኖሩ ነበር፤ ነገር ግን ሁሉ ከእኛ ወገን እንዳልሆኑ ይገለጡ ዘንድ ወጡ። ");
INSERT INTO amh_vpl VALUES ("J12_20","092_2_20","1JN","2","20","20","እናንተም ከቅዱሱ ቅባት ተቀብላችኋል፥ ሁሉንም ታውቃላችሁ። ");
INSERT INTO amh_vpl VALUES ("J12_21","092_2_21","1JN","2","21","21","እውነትን የምታውቁ ስለ ሆናችሁ፥ ውሸትም ሁሉ ከእውነት እንዳልሆነ ስለምታውቁ እንጂ እውነትን ስለማታውቁ አልጽፍላችሁም። ");
INSERT INTO amh_vpl VALUES ("J12_22","092_2_22","1JN","2","22","22","ክርስቶስ አይደለም ብሎ ኢየሱስን ከሚክድ በቀር ውሸተኛው ማን ነው? አብንና ወልድን የሚክድ ይህ የክርስቶስ ተቃዋሚ ነው። ");
INSERT INTO amh_vpl VALUES ("J12_23","092_2_23","1JN","2","23","23","ወልድን የሚክድ ሁሉ አብ እንኳ የለውም፤ በወልድ የሚታመን አብ ደግሞ አለው። ");
INSERT INTO amh_vpl VALUES ("J12_24","092_2_24","1JN","2","24","24","እናንተስ ከመጀመሪያ የሰማችሁት በእናንተ ጸንቶ ይኑር። ከመጀመሪያ የሰማችሁት በእናንተ ቢኖር፥ እናንተ ደግሞ በወልድና በአብ ትኖራላችሁ። ");
INSERT INTO amh_vpl VALUES ("J12_25","092_2_25","1JN","2","25","25","እርሱም የሰጠን ተስፋ ይህ የዘላለም ሕይወት ነው። ");
INSERT INTO amh_vpl VALUES ("J12_26","092_2_26","1JN","2","26","26","ስለሚያስቱአችሁ ሰዎች ይህን ጽፌላችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("J12_27","092_2_27","1JN","2","27","27","እናንተስ ከእርሱ የተቀበላችሁት ቅባት በእናንተ ይኖራል፥ ማንም ሊያስተምራችሁ አያስፈልጋችሁም፤ ነገር ግን የእርሱ ቅባት ስለ ሁሉ እንደሚያስተምራችሁ፥ እውነተኛም እንደ ሆነ ውሸትም እንዳልሆነ፥ እናንተንም እንዳስተማራችሁ፥ በእርሱ ኑሩ። ");
INSERT INTO amh_vpl VALUES ("J12_28","092_2_28","1JN","2","28","28","አሁንም፥ ልጆች ሆይ፥ በሚገለጥበት ጊዜ እምነት እንዲሆንልን በመምጣቱም በእርሱ ፊት እንዳናፍር በእርሱ ኑሩ። ");
INSERT INTO amh_vpl VALUES ("J12_29","092_2_29","1JN","2","29","29","ጻድቅ እንደ ሆነ ካወቃችሁ ጽድቅን የሚያደርግ ሁሉ ከእርሱ እንደ ተወለደ እወቁ። ");
INSERT INTO amh_vpl VALUES ("J13_1","092_3_1","1JN","3","1","1","የእግዚአብሔር ልጆች ተብለን ልንጠራ አብ እንዴት ያለውን ፍቅር እንደ ሰጠን እዩ፥ እንዲሁም ነን። ስለዚህ ምክንያት ዓለም እርሱን ስላላወቀው እኛን አያውቀንም። ");
INSERT INTO amh_vpl VALUES ("J13_2","092_3_2","1JN","3","2","2","ወዳጆች ሆይ፥ አሁን የእግዚአብሔር ልጆች ነን፥ ምንም እንደምንሆን ገና አልተገለጠም። ዳሩ ግን ቢገለጥ እርሱ እንዳለ እናየዋለንና እርሱን እንድንመስል እናውቃለን። ");
INSERT INTO amh_vpl VALUES ("J13_3","092_3_3","1JN","3","3","3","በእርሱም ይህን ተስፋ የሚያደርግ ሁሉ እርሱ ንጹሕ እንደ ሆነ ራሱን ያነጻል። ");
INSERT INTO amh_vpl VALUES ("J13_4","092_3_4","1JN","3","4","4","ኃጢአትን የሚያደርግ ሁሉ ዓመፅን ደግሞ ያደርጋል፥ ኃጢአትም ዓመፅ ነው። ");
INSERT INTO amh_vpl VALUES ("J13_5","092_3_5","1JN","3","5","5","እርሱም ኃጢአትን ሊያስወግድ እንደ ተገለጠ ታውቃላችሁ፥ በእርሱም ኃጢአት የለም። ");
INSERT INTO amh_vpl VALUES ("J13_6","092_3_6","1JN","3","6","6","በእርሱ የሚኖር ሁሉ ኃጢአትን አያደርግም፤ ኃጢአትን የሚያደርግ ሁሉ አላየውም አላወቀውምም። ");
INSERT INTO amh_vpl VALUES ("J13_7","092_3_7","1JN","3","7","7","ልጆች ሆይ፥ ማንም አያስታችሁ፤ እርሱ ጻድቅ እንደ ሆነ ጽድቅን የሚያደርግ ጻድቅ ነው። ");
INSERT INTO amh_vpl VALUES ("J13_8","092_3_8","1JN","3","8","8","ኃጢአትን የሚያደርግ ከዲያብሎስ ነው፥ ዲያብሎስ ከመጀመሪያ ኃጢአትን ያደርጋልና። ");
INSERT INTO amh_vpl VALUES ("J13_9","092_3_9","1JN","3","9","9","ስለዚህ የዲያብሎስን ሥራ እንዲያፈርስ የእግዚአብሔር ልጅ ተገለጠ። ከእግዚአብሔር የተወለደ ሁሉ ኃጢአትን አያደርግም፥ ዘሩ በእርሱ ይኖራልና፤ ከእግዚአብሔርም ተወልዶአልና ኃጢአትን ሊያደርግ አይችልም። ");
INSERT INTO amh_vpl VALUES ("J13_10","092_3_10","1JN","3","10","10","የእግዚአብሔር ልጆችና የዲያብሎስ ልጆች በዚህ የተገለጡ ናቸው፤ ጽድቅን የማያደርግና ወንድሙን የማይወድ ሁሉ ከእግዚአብሔር አይደለም። ");
INSERT INTO amh_vpl VALUES ("J13_11","092_3_11","1JN","3","11","11","ከመጀመሪያ የሰማችኋት መልእክት። እርስ በርሳችን እንዋደድ የምትል ይህች ናትና፤ ");
INSERT INTO amh_vpl VALUES ("J13_12","092_3_12","1JN","3","12","12","ከክፉው እንደ ነበረ ወንድሙንም እንደ ገደለ እንደ ቃየል አይደለም፤ ስለ ምንስ ገደለው? የገዛ ሥራው ክፉ፥ የወንድሙም ሥራ ጽድቅ ስለ ነበረ ነው። ");
INSERT INTO amh_vpl VALUES ("J13_13","092_3_13","1JN","3","13","13","ወንድሞች ሆይ፥ ዓለም ቢጠላችሁ አትደነቁ። ");
INSERT INTO amh_vpl VALUES ("J13_14","092_3_14","1JN","3","14","14","እኛ ወንድሞችን የምንወድ ስለ ሆንን ከሞት ወደ ሕይወት እንደ ተሻገርን እናውቃለን፤ ወንድሙን የማይወድ በሞት ይኖራል። ");
INSERT INTO amh_vpl VALUES ("J13_15","092_3_15","1JN","3","15","15","ወንድሙን የሚጠላ ሁሉ ነፍሰ ገዳይ ነው፥ ነፍሰ ገዳይም የሆነ ሁሉ የዘላለም ሕይወት በእርሱ እንዳይኖር ታውቃላችሁ። ");
INSERT INTO amh_vpl VALUES ("J13_16","092_3_16","1JN","3","16","16","እርሱ ስለ እኛ ነፍሱን አሳልፎ ሰጥቶአልና በዚህ ፍቅርን አውቀናል፤ እኛም ስለ ወንድሞቻችን ነፍሳችንን አሳልፈን እንድንሰጥ ይገባናል። ");
INSERT INTO amh_vpl VALUES ("J13_17","092_3_17","1JN","3","17","17","ነገር ግን የዚህ ዓለም ገንዘብ ያለው፥ ወንድሙም የሚያስፈልገው ሲያጣ አይቶ ያልራራለት ማንም ቢሆን፥ የእግዚአብሔር ፍቅር በእርሱ እንዴት ይኖራል? ");
INSERT INTO amh_vpl VALUES ("J13_18","092_3_18","1JN","3","18","18","ልጆቼ ሆይ፥ በሥራና በእውነት እንጂ በቃልና በአንደበት አንዋደድ። ");
INSERT INTO amh_vpl VALUES ("J13_19","092_3_19","1JN","3","19","21","ወዳጆች ሆይ፥ ልባችንስ ባይፈርድብን በእግዚአብሔር ዘንድ ድፍረት አለን፥ ");
INSERT INTO amh_vpl VALUES ("J13_22","092_3_22","1JN","3","22","22","ትእዛዙንም የምንጠብቅና በፊቱ ደስ የሚያሰኘውን የምናደርግ ስለሆንን የምንለምነውን ሁሉ ከእርሱ እናገኛለን። ");
INSERT INTO amh_vpl VALUES ("J13_23","092_3_23","1JN","3","23","23","ትእዛዚቱም ይህች ናት፥ በልጁ በኢየሱስ ክርስቶስ ስም እናምን ዘንድ፥ ትእዛዝንም እንደ ሰጠን እርስ በርሳችን እንዋደድ ዘንድ። ");
INSERT INTO amh_vpl VALUES ("J13_24","092_3_24","1JN","3","24","24","ትእዛዙንም የሚጠብቅ በእርሱ ይኖራል እርሱም ይኖርበታል፤ በዚህም በእኛ እንዲኖር ከሰጠን ከመንፈሱ እናውቃለን። ");
INSERT INTO amh_vpl VALUES ("J14_1","092_4_1","1JN","4","1","1","ወዳጆች ሆይ፥ መንፈስን ሁሉ አትመኑ፥ ነገር ግን መናፍስት ከእግዚአብሔር ሆነው እንደ ሆነ መርምሩ፤ ብዙዎች ሐሰተኞች ነቢያት ወደ ዓለም ወጥተዋልና። ");
INSERT INTO amh_vpl VALUES ("J14_2","092_4_2","1JN","4","2","2","የእግዚአብሔርን መንፈስ በዚህ ታውቃላችሁ፤ ኢየሱስ ክርስቶስ በሥጋ እንደ መጣ የሚታመን መንፈስ ሁሉ ከእግዚአብሔር ነው፥ ");
INSERT INTO amh_vpl VALUES ("J14_3","092_4_3","1JN","4","3","3","ኢየሱስ ክርስቶስም በሥጋ እንደ መጣ የማይታመን መንፈስ ሁሉ ከእግዚአብሔር አይደለም፤ ይህም የክርስቶስ ተቃዋሚው መንፈስ ነው፤ ይህም እንዲመጣ ሰምታችኋል፥ አሁንም እንኳ በዓለም አለ። ");
INSERT INTO amh_vpl VALUES ("J14_4","092_4_4","1JN","4","4","4","ልጆች ሆይ፥ እናንተ ከእግዚአብሔር ናችሁ አሸንፋችኋቸውማል፥ በዓለም ካለው ይልቅ በእናንተ ያለው ታላቅ ነውና። ");
INSERT INTO amh_vpl VALUES ("J14_5","092_4_5","1JN","4","5","5","እነርሱ ከዓለም ናቸው፤ ስለዚህ ከዓለም የሆነውን ይናገራሉ ዓለሙም ይሰማቸዋል። ");
INSERT INTO amh_vpl VALUES ("J14_6","092_4_6","1JN","4","6","6","እኛ ከእግዚአብሔር ነን፤ እግዚአብሔርን የሚያውቅ ይሰማናል፤ ከእግዚአብሔር ያልሆነ አይሰማንም። የእውነትን መንፈስና የስሕተትን መንፈስ በዚህ እናውቃለን። ");
INSERT INTO amh_vpl VALUES ("J14_7","092_4_7","1JN","4","7","7","ወዳጆች ሆይ፥ ፍቅር ከእግዚአብሔር ስለ ሆነ፥ የሚወደውም ሁሉ ከእግዚአብሔር ስለ ተወለደ እግዚአብሔርንም ስለሚያውቅ፥ እርስ በርሳችን እንዋደድ። ");
INSERT INTO amh_vpl VALUES ("J14_8","092_4_8","1JN","4","8","8","ፍቅር የሌለው እግዚአብሔርን አያውቅም፥ እግዚአብሔር ፍቅር ነውና። ");
INSERT INTO amh_vpl VALUES ("J14_9","092_4_9","1JN","4","9","9","በዚህ የእግዚአብሔር ፍቅር በእኛ ዘንድ ተገለጠ፥ በእርሱ በኩል በሕይወት እንኖር ዘንድ እግዚአብሔር አንድ ልጁን ወደ ዓለም ልኮታልና። ");
INSERT INTO amh_vpl VALUES ("J14_10","092_4_10","1JN","4","10","10","ፍቅርም እንደዚህ ነው፤ እግዚአብሔር እርሱ ራሱ እንደ ወደደን ስለ ኃጢአታችንም ማስተስሪያ ይሆን ዘንድ ልጁን እንደ ላከ እንጂ እኛ እግዚአብሔርን እንደ ወደድነው አይደለም። ");
INSERT INTO amh_vpl VALUES ("J14_11","092_4_11","1JN","4","11","11","ወዳጆች ሆይ፥ እግዚአብሔር እንዲህ አድርጎ ከወደደን እኛ ደግሞ እርስ በርሳችን ልንዋደድ ይገባናል። ");
INSERT INTO amh_vpl VALUES ("J14_12","092_4_12","1JN","4","12","12","እግዚአብሔርን ማንም ከቶ አላየውም፤ እርስ በርሳችን ብንዋደድ እግዚአብሔር በእኛ ይኖራል ፍቅሩም በእኛ ፍጹም ሆኖአል። ");
INSERT INTO amh_vpl VALUES ("J14_13","092_4_13","1JN","4","13","13","ከመንፈሱ ስለ ሰጠን፥ በእርሱ እንድንኖር እርሱም በእኛ እንዲኖር በዚህ እናውቃለን። ");
INSERT INTO amh_vpl VALUES ("J14_14","092_4_14","1JN","4","14","14","እኛም አይተናል አባትም ልጁን የዓለም መድኃኒት ሊሆን እንደ ላከው እንመሰክራለን። ");
INSERT INTO amh_vpl VALUES ("J14_15","092_4_15","1JN","4","15","15","ኢየሱስ የእግዚአብሔር ልጅ እንደ ሆነ በሚታመን ሁሉ እግዚአብሔር በእርሱ ይኖራል እርሱም በእግዚአብሔር ይኖራል። ");
INSERT INTO amh_vpl VALUES ("J14_16","092_4_16","1JN","4","16","16","እኛም እግዚአብሔር ለእኛ ያለውን ፍቅር አውቀናል አምነንማል። እግዚአብሔር ፍቅር ነው፥ በፍቅርም የሚኖር በእግዚአብሔር ይኖራል እግዚአብሔርም በእርሱ ይኖራል። ");
INSERT INTO amh_vpl VALUES ("J14_17","092_4_17","1JN","4","17","17","በፍርድ ቀን ድፍረት ይሆንልን ዘንድ ፍቅር በዚህ ከእኛ ጋር ተፈጽሞአል፤ እርሱ እንዳለ እኛ ደግሞ እንዲሁ በዚህ ዓለም ነንና። ");
INSERT INTO amh_vpl VALUES ("J14_18","092_4_18","1JN","4","18","18","ፍጹም ፍቅር ፍርሃትን አውጥቶ ይጥላል እንጂ በፍቅር ፍርሃት የለም፥ ፍርሃት ቅጣት አለውና፤ የሚፈራም ሰው ፍቅሩ ፍጹም አይደለም። ");
INSERT INTO amh_vpl VALUES ("J14_19","092_4_19","1JN","4","19","19","እርሱ አስቀድሞ ወዶናልና እኛ እንወደዋለን። ");
INSERT INTO amh_vpl VALUES ("J14_20","092_4_20","1JN","4","20","20","ማንም። እግዚአብሔርን እወዳለሁ እያለ ወንድሙን ቢጠላ ሐሰተኛ ነው፤ ያየውን ወንድሙን የማይወድ ያላየውን እግዚአብሔርን ሊወደው እንዴት ይችላል? ");
INSERT INTO amh_vpl VALUES ("J14_21","092_4_21","1JN","4","21","21","እግዚአብሔርንም የሚወድ ወንድሙን ደግሞ እንዲወድ ይህች ትእዛዝ ከእርሱ አለችን። ");
INSERT INTO amh_vpl VALUES ("J15_1","092_5_1","1JN","5","1","1","ክርስቶስ ነው ብሎ በኢየሱስ የሚያምን ሁሉ ከእግዚአብሔር ተወልዶአል፥ ወላጁንም የሚወድ ሁሉ ከእርሱ የተወለደውን ደግሞ ይወዳል። ");
INSERT INTO amh_vpl VALUES ("J15_2","092_5_2","1JN","5","2","2","እግዚአብሔርን ስንወድ ትእዛዛቱንም ስናደርግ የእግዚአብሔርን ልጆች እንድንወድ በዚህ እናውቃለን። ");
INSERT INTO amh_vpl VALUES ("J15_3","092_5_3","1JN","5","3","3","ትእዛዛቱን ልንጠብቅ የእግዚአብሔር ፍቅር ይህ ነውና፤ ትእዛዛቱም ከባዶች አይደሉም። ");
INSERT INTO amh_vpl VALUES ("J15_4","092_5_4","1JN","5","4","4","ከእግዚአብሔር የተወለደ ሁሉ ዓለምን ያሸንፋልና፤ ዓለምንም የሚያሸንፈው እምነታችን ነው። ");
INSERT INTO amh_vpl VALUES ("J15_5","092_5_5","1JN","5","5","5","ኢየሱስም የእግዚአብሔር ልጅ እንደ ሆነ ከሚያምን በቀር ዓለምን የሚያሸንፍ ማን ነው? ");
INSERT INTO amh_vpl VALUES ("J15_6","092_5_6","1JN","5","6","6","በውኃና በደም የመጣ ይህ ነው እርሱም ኢየሱስ ክርስቶስ፤ በውኃውና በደሙ እንጂ በውኃው ብቻ አይደለም። ");
INSERT INTO amh_vpl VALUES ("J15_7","092_5_7","1JN","5","7","7","መንፈስም እውነት ነውና የሚመሰክረው መንፈስ ነው። ");
INSERT INTO amh_vpl VALUES ("J15_8","092_5_8","1JN","5","8","8","የሚመሰክሩት መንፈሱና ውኃው ደሙም ሦስት ናቸውና፤ ሦስቱም በአንድ ይስማማሉ። ");
INSERT INTO amh_vpl VALUES ("J15_9","092_5_9","1JN","5","9","9","የሰውን ምስክር ብንቀበል የእግዚአብሔር ምስክር ከእርሱ ይልቅ ይበልጣል፤ ስለ ልጁ የመሰከረው የእግዚአብሔር ምስክር ይህ ነውና። ");
INSERT INTO amh_vpl VALUES ("J15_10","092_5_10","1JN","5","10","10","በእግዚአብሔር ልጅ የሚያምን በነፍሱ ምስክር አለው፤ በእግዚአብሔር የማያምን እግዚአብሔር ስለ ልጁ የመሰከረውን ምስክር ስላላመነ ሐሰተኛ አድርጎታል። ");
INSERT INTO amh_vpl VALUES ("J15_11","092_5_11","1JN","5","11","11","እግዚአብሔርም የዘላለምን ሕይወት እንደ ሰጠን ይህም ሕይወት በልጁ እንዳለ ምስክሩ ይህ ነው። ");
INSERT INTO amh_vpl VALUES ("J15_12","092_5_12","1JN","5","12","12","ልጁ ያለው ሕይወት አለው፤ የእግዚአብሔር ልጅ የሌለው ሕይወት የለውም። ");
INSERT INTO amh_vpl VALUES ("J15_13","092_5_13","1JN","5","13","13","የዘላለም ሕይወት እንዳላችሁ ታውቁ ዘንድ በእግዚአብሔር ልጅ ስም ለምታምኑ ይህን ጽፌላችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("J15_14","092_5_14","1JN","5","14","14","በእርሱ ዘንድ ያለን ድፍረት ይህ ነው፤ እንደ ፈቃዱ አንዳች ብንለምን ይሰማናል። ");
INSERT INTO amh_vpl VALUES ("J15_15","092_5_15","1JN","5","15","15","የምንለምነውንም ሁሉ እንዲሰማልን ብናውቅ ከእርሱ የለመነውን ልመና እንደ ተቀበልን እናውቃለን። ");
INSERT INTO amh_vpl VALUES ("J15_16","092_5_16","1JN","5","16","16","ማንም ወንድሙን ሞት የማይገባውን ኃጢአት ሲያደርግ ቢያየው ይለምን፥ ሞትም የማይገባውን ኃጢአት ላደረጉት ሕይወት ይሰጥለታል። ሞት የሚገባው ኃጢአት አለ፤ ስለዚያ እንዲጠይቅ አልልም። ");
INSERT INTO amh_vpl VALUES ("J15_17","092_5_17","1JN","5","17","17","ዓመፃ ሁሉ ኃጢአት ነው፥ ሞትም የማይገባው ኃጢአት አለ። ");
INSERT INTO amh_vpl VALUES ("J15_18","092_5_18","1JN","5","18","18","ከእግዚአብሔር የተወለደ ሁሉ ኃጢአትን እንዳያደርግ፥ ነገር ግን ከእግዚአብሔር የተወለደው ራሱን እንዲጠብቅ ክፉውም እንዳይነካው እናውቃለን። ");
INSERT INTO amh_vpl VALUES ("J15_19","092_5_19","1JN","5","19","19","ከእግዚአብሔር እንደ ሆንን ዓለምም በሞላው በክፉው እንደ ተያዘ እናውቃለን። ");
INSERT INTO amh_vpl VALUES ("J15_20","092_5_20","1JN","5","20","20","የእግዚአብሔርም ልጅ እንደ መጣ፥ እውነተኛም የሆነውን እናውቅ ዘንድ ልቡናን እንደ ሰጠን እናውቃለን፤ እውነተኛም በሆነው በእርሱ አለን፥ እርሱም ልጁ ኢየሱስ ክርስቶስ ነው። እርሱ እውነተኛ አምላክና የዘላለም ሕይወት ነው። ");
INSERT INTO amh_vpl VALUES ("J15_21","092_5_21","1JN","5","21","21","ልጆች ሆይ፥ ከጣዖታት ራሳችሁን ጠብቁ። ");
INSERT INTO amh_vpl VALUES ("J21_1","093_1_1","2JN","1","1","3","ከእግዚአብሔር አብና ከአብ ልጅ ከኢየሱስ ክርስቶስ ጸጋና ምሕረት ሰላምም በእውነትና በፍቅር ከእኛ ጋር ይሆናሉ። ");
INSERT INTO amh_vpl VALUES ("J21_4","093_1_4","2JN","1","4","4","ትእዛዝን ከአብ እንደ ተቀበልን ከልጆችሽ በእውነት የሚሄዱ አንዳንዶችን ስለ አገኘኋቸው እጅግ ደስ ብሎኛል። ");
INSERT INTO amh_vpl VALUES ("J21_5","093_1_5","2JN","1","5","5","አሁንም፥ እመቤት ሆይ፥ እርስ በርሳችን እንድንዋደድ እለምንሻለሁ፤ ይህች ከመጀመሪያ በእኛ ዘንድ የነበረች ትእዛዝ ናት እንጂ አዲስ ትእዛዝን እንደምጽፍልሽ አይደለም። ");
INSERT INTO amh_vpl VALUES ("J21_6","093_1_6","2JN","1","6","6","እንደ ትእዛዛቱም እንሄድ ዘንድ ይህ ፍቅር ነው፤ ከመጀመሪያ እንደ ሰማችሁ፥ በእርስዋ ትሄዱ ዘንድ ትእዛዙ ይህች ናት። ");
INSERT INTO amh_vpl VALUES ("J21_7","093_1_7","2JN","1","7","7","ብዙ አሳቾች ወደ ዓለም ገብተዋልና እነርሱም ኢየሱስ ክርስቶስ በሥጋ እንደ መጣ የማያምኑ ናቸው፤ ይህ አሳቹና የክርስቶስ ተቃዋሚው ነው። ");
INSERT INTO amh_vpl VALUES ("J21_8","093_1_8","2JN","1","8","8","ሙሉ ደመወዝን እንድትቀበሉ እንጂ የሠራችሁትን እንዳታጠፉ ለራሳችሁ ተጠንቀቁ። ");
INSERT INTO amh_vpl VALUES ("J21_9","093_1_9","2JN","1","9","9","ለሚወጣ ሁሉ በክርስቶስም ትምህርት ለማይኖር ሰው አምላክ የለውም፤ በክርስቶስ ትምህርት ለሚኖር አብና ወልድ አሉት። ");
INSERT INTO amh_vpl VALUES ("J21_10","093_1_10","2JN","1","10","10","ማንም ወደ እናንተ ቢመጣ ይህንም ትምህርት ባያመጣ በቤታችሁ አትቀበሉት ሰላምም አትበሉት፤ ");
INSERT INTO amh_vpl VALUES ("J21_11","093_1_11","2JN","1","11","11","ሰላም የሚለው ሰው በክፉ ሥራው ይካፈላልና። ");
INSERT INTO amh_vpl VALUES ("J21_12","093_1_12","2JN","1","12","12","እንድጽፍላችሁ የምፈልገው ብዙ ነገር ሳለኝ በወረቀትና በቀለም ልጽፈው አልወድም፥ ዳሩ ግን ደስታችሁ ፍጹም እንዲሆን ወደ እናንተ ልመጣ አፍ ለአፍም ልናገራችሁ ተስፋ አደርጋለሁ። ");
INSERT INTO amh_vpl VALUES ("J21_13","093_1_13","2JN","1","13","13","የተመረጠችው የእኅትሽ ልጆች ሰላምታ ያቀርቡልሻል። ");
INSERT INTO amh_vpl VALUES ("J31_1","094_1_1","3JN","1","1","1","ሽማግሌው በእውነት እኔ ለምወደው ለተወደደው ለጋይዮስ። ");
INSERT INTO amh_vpl VALUES ("J31_2","094_1_2","3JN","1","2","2","ወዳጅ ሆይ፥ ነፍስህ እንደሚከናወን፥ በነገር ሁሉ እንዲከናወንልህና ጤና እንዲኖርህ እጸልያለሁ። ");
INSERT INTO amh_vpl VALUES ("J31_3","094_1_3","3JN","1","3","3","ወንድሞች መጥተው አንተ በእውነት እንደምትሄድ ስለ እውነትህ ሲመሰክሩ እጅግ ደስ ብሎኛልና። ");
INSERT INTO amh_vpl VALUES ("J31_4","094_1_4","3JN","1","4","4","ልጆቼ በእውነት እንዲሄዱ ከመስማት ይልቅ የሚበልጥ ደስታ የለኝም። ");
INSERT INTO amh_vpl VALUES ("J31_5","094_1_5","3JN","1","5","5","ወዳጅ ሆይ፥ ምንም እንግዶች ቢሆኑ፥ ለወንድሞች በምታደርገው ሁሉ የታመነ ሥራ ትሠራለህ፥ እነርሱም በማኅበር ፊት ስለ ፍቅርህ መስክረዋል፤ ");
INSERT INTO amh_vpl VALUES ("J31_6","094_1_6","3JN","1","6","6","ለእግዚአብሔር እንደሚገባ አድርገህ በጉዞአቸው ብትረዳ መልካም ታደርጋለህ፤ ");
INSERT INTO amh_vpl VALUES ("J31_7","094_1_7","3JN","1","7","7","ከአሕዛብ አንዳች ሳይቀበሉ ስለ ስሙ ወጥተዋልና። ");
INSERT INTO amh_vpl VALUES ("J31_8","094_1_8","3JN","1","8","8","እንግዲህ ከእውነት ጋር አብረን እንድንሠራ እኛ እንዲህ ያሉትን በእንግድነት ልንቀበል ይገባናል። ");
INSERT INTO amh_vpl VALUES ("J31_9","094_1_9","3JN","1","9","9","ወደ ቤተ ክርስቲያን ጻፍሁ፤ ዳሩ ግን ዋናቸው ሊሆን የሚወድ ዲዮጥራጢስ አይቀበለንም። ");
INSERT INTO amh_vpl VALUES ("J31_10","094_1_10","3JN","1","10","10","ስለዚህ፥ እኔ ብመጣ፥ በእኛ ላይ በክፉ ቃል እየለፈለፈ የሚያደርገውን ሥራውን አሳስባለሁ፤ ይህም ሳይበቃው እርሱ ራሱ ወንድሞችን አይቀበልም፥ ሊቀበሉአቸውም የሚወዱትን ከልክሎ ከቤተ ክርስቲያን ያወጣቸዋል። ");
INSERT INTO amh_vpl VALUES ("J31_11","094_1_11","3JN","1","11","11","ወዳጅ ሆይ፥ በጎ የሆነውን እንጂ ክፉን አትምሰል። በጎ የሚያደርግ ከእግዚአብሔር ነው፤ ክፉን የሚያደርግ ግን እግዚአብሔርን አላየውም። ");
INSERT INTO amh_vpl VALUES ("J31_12","094_1_12","3JN","1","12","12","ለድሜጥሮስ ሁሉ ይመሰክሩለታል፥ እውነት ራስዋም ትመሰክርለታለች፤ እኛም ደግሞ እንመሰክርለታለን፥ ምስክርነታችንም እውነት እንደ ሆነ ታውቃላችሁ። ");
INSERT INTO amh_vpl VALUES ("J31_13","094_1_13","3JN","1","13","15","ልጽፍልህ የምፈልገው ብዙ ነገር ነበረኝ፥ ዳሩ ግን በቀለምና በብርዕ ልጽፍልህ አልወድም፤ ");
INSERT INTO amh_vpl VALUES ("JD1_1","095_1_1","JUD","1","1","1","የኢየሱስ ክርስቶስ ባሪያ የያዕቆብም ወንድም የሆነ ይሁዳ፥ በእግዚአብሔር አብ ተወደው ለኢየሱስ ክርስቶስም ተጠብቀው ለተጠሩ፤ ");
INSERT INTO amh_vpl VALUES ("JD1_2","095_1_2","JUD","1","2","2","ምሕረትና ሰላም ፍቅርም ይብዛላችሁ። ");
INSERT INTO amh_vpl VALUES ("JD1_3","095_1_3","JUD","1","3","3","ወዳጆች ሆይ፥ ስለምንካፈለው ስለ መዳናችን ልጽፍላችሁ እጅግ ተግቼ ሳለሁ፥ ለቅዱሳን አንድ ጊዜ ፈጽሞ ስለ ተሰጠ ሃይማኖት እንድትጋደሉ እየመከርኋችሁ እጽፍላችሁ ዘንድ ግድ ሆነብኝ። ");
INSERT INTO amh_vpl VALUES ("JD1_4","095_1_4","JUD","1","4","4","ከብዙ ጊዜ በፊት ለዚህ ፍርድ የተጻፉ አንዳንዶች ሰዎች ሾልከው ገብተዋልና፤ ኃጢአተኞች ሆነው የአምላካችንን ጸጋ በሴሰኝነት ይለውጣሉ ንጉሣችንንና ጌታችንንም ብቻውን ያለውን ኢየሱስ ክርስቶስን ይክዳሉ። ");
INSERT INTO amh_vpl VALUES ("JD1_5","095_1_5","JUD","1","5","5","ዳሩ ግን ሁሉን አንድ ጊዜ ፈጽሞ ምንም የተማራችሁ ብትሆኑ ጌታ ከግብፅ አገር ሕዝቡን አድኖ የማያምኑትን በኋላ እንዳጠፋቸው ላሳስባችሁ እወዳለሁ። ");
INSERT INTO amh_vpl VALUES ("JD1_6","095_1_6","JUD","1","6","6","መኖሪያቸውንም የተዉትን እንጂ የራሳቸውን አለቅነት ያልጠበቁትን መላእክት በዘላለም እስራት ከጨለማ በታች እስከ ታላቁ ቀን ፍርድ ድረስ ጠብቆአቸዋል። ");
INSERT INTO amh_vpl VALUES ("JD1_7","095_1_7","JUD","1","7","7","እንዲሁም እንደ እነርሱ ዝሙትን ያደረጉና ሌላን ሥጋ የተከተሉ ሰዶምና ገሞራ በዙሪያቸውም የነበሩ ከተማዎች በዘላለም እሳት እየተቀጡ ምሳሌ ሆነዋል። ");
INSERT INTO amh_vpl VALUES ("JD1_8","095_1_8","JUD","1","8","8","እንዲሁም እነዚህ ሰዎች ደግሞ እያለሙ ሥጋቸውን ያረክሳሉ ጌትነትንም ይጥላሉ ሥልጣን ያላቸውንም ይሳደባሉ። ");
INSERT INTO amh_vpl VALUES ("JD1_9","095_1_9","JUD","1","9","9","የመላእክት አለቃ ሚካኤል ግን ከዲያብሎስ ጋር በተከራከረ ጊዜ ስለ ሙሴ ሥጋ ሲነጋገር። ጌታ ይገሥጽህ አለው እንጂ የስድብን ፍርድ ሊናገረው አልደፈረም። ");
INSERT INTO amh_vpl VALUES ("JD1_10","095_1_10","JUD","1","10","10","እነዚህ ግን የማያውቁትን ሁሉ ይሳደባሉ፥ አእምሮም እንደሌላቸው እንስሶች በፍጥረታቸው በሚያውቁት ሁሉ በእርሱ ይጠፋሉ። ");
INSERT INTO amh_vpl VALUES ("JD1_11","095_1_11","JUD","1","11","11","ወዮላቸው፥ በቃየል መንገድ ሄደዋልና ስለ ደመወዝም ለበለዓም ስሕተት ራሳቸውን አሳልፈው ሰጥተዋል በቆሬም መቃወም ጠፍተዋል። ");
INSERT INTO amh_vpl VALUES ("JD1_12","095_1_12","JUD","1","12","12","እነዚህ ከእናንተ ጋር ሲጋበዙ በፍቅር ግብዣችሁ እንደ እድፍ ናቸው፤ እንደ እረኞች ያለ ፍርሃት ራሳቸውን ይጠብቃሉ፤ በነፋስ የተወሰዱ ውኃ የሌለባቸው ደመናዎች፥ ፍሬ የማያፈሩ ሁለት ጊዜ የሞቱ ከነሥራቸው የተነቀሉ በበጋ የደረቁ ዛፎች፥ ");
INSERT INTO amh_vpl VALUES ("JD1_13","095_1_13","JUD","1","13","13","የገዛ ነውራቸውን አረፋ እየደፈቁ ጨካኝ የባሕር ማዕበል፥ ድቅድቅ ጨለማ ለዘላለም የተጠበቀላቸው የሚንከራተቱ ከዋክብት ናቸው። ");
INSERT INTO amh_vpl VALUES ("JD1_14","095_1_14","JUD","1","14","16","እነዚህ እንደ ምኞታቸው እየሄዱ የሚያንጎራጉሩና ስለ ዕድላቸው የሚያጕረመርሙ ናቸው፥ እንዲረባቸውም ለሰው ፊት እያደሉ አፋቸው ከመጠን ይልቅ ታላቅ ቃል ይናገራል። ");
INSERT INTO amh_vpl VALUES ("JD1_17","095_1_17","JUD","1","17","17","እናንተ ግን፥ ወዳጆች ሆይ፥ በጌታችን በኢየሱስ ክርስቶስ ሐዋርያት ቀድሞ የተነገረውን ቃል አስቡ፤ ");
INSERT INTO amh_vpl VALUES ("JD1_18","095_1_18","JUD","1","18","18","እነርሱ። በመጨረሻው ዘመን በኃጢአተኝነት እንደ ገዛ ምኞታቸው እየሄዱ ዘባቾች ይሆናሉ ብለዋችኋልና። ");
INSERT INTO amh_vpl VALUES ("JD1_19","095_1_19","JUD","1","19","19","እነዚህ የሚያለያዩ ሥጋውያንም የሆኑ መንፈስም የሌላቸው ሰዎች ናቸው። ");
INSERT INTO amh_vpl VALUES ("JD1_20","095_1_20","JUD","1","20","20","እናንተ ግን፥ ወዳጆች ሆይ፥ ከሁሉ ይልቅ በተቀደሰ ሃይማኖታችሁ ራሳችሁን ለማነጽ እየተጋችሁ በመንፈስ ቅዱስም እየጸለያችሁ፥ ");
INSERT INTO amh_vpl VALUES ("JD1_21","095_1_21","JUD","1","21","21","ወደ ዘላለም ሕይወት የሚወስደውን የጌታችንን የኢየሱስ ክርስቶስን ምሕረት ስትጠባበቁ በእግዚአብሔር ፍቅር ራሳችሁን ጠብቁ። ");
INSERT INTO amh_vpl VALUES ("JD1_22","095_1_22","JUD","1","22","22","አንዳንዶች ተከራካሪዎችንም ውቀሱ፥ አንዳንዶችንም ከእሳት ነጥቃችሁ አድኑ፥ ");
INSERT INTO amh_vpl VALUES ("JD1_23","095_1_23","JUD","1","23","23","አንዳንዶችንም በሥጋ የረከሰውን ልብስ እንኳ እየጠላችሁ በፍርሃት ማሩ። ");
INSERT INTO amh_vpl VALUES ("JD1_24","095_1_24","JUD","1","24","24","ሳትሰናከሉም እንዲጠብቃችሁ፥ በክብሩም ፊት በደስታ ነውር የሌላችሁ አድርጎ እንዲያቆማችሁ ለሚችለው ");
INSERT INTO amh_vpl VALUES ("JD1_25","095_1_25","JUD","1","25","25","ብቻውን ለሆነ አምላክና መድኃኒታችን ከዘመን ሁሉ በፊት አሁንም እስከ ዘላለምም ድረስ በጌታችን በኢየሱስ ክርስቶስ ክብርና ግርማ ኃይልም ሥልጣንም ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("RV1_1","096_1_1","REV","1","1","1","ቶሎ ይሆን ዘንድ የሚገባውን ነገር ለባሪያዎቹ ያሳይ ዘንድ እግዚአብሔር ለኢየሱስ ክርስቶስ የሰጠው በእርሱም የተገለጠው ይህ ነው፥ ኢየሱስም በመልአኩ ልኮ ለባሪያው ለዮሐንስ አመለከተ፥ ");
INSERT INTO amh_vpl VALUES ("RV1_2","096_1_2","REV","1","2","2","እርሱም ለእግዚአብሔር ቃልና ለኢየሱስ ክርስቶስ ምስክር ላየውም ሁሉ መሰከረ። ");
INSERT INTO amh_vpl VALUES ("RV1_3","096_1_3","REV","1","3","3","ዘመኑ ቀርቦአልና የሚያነበው፥ የትንቢቱን ቃል የሚሰሙትና በውስጡ የተጻፈውን የሚጠብቁት ብፁዓን ናቸው። ");
INSERT INTO amh_vpl VALUES ("RV1_4","096_1_4","REV","1","4","6","መንግሥትም ለአምላኩና ለአባቱም ካህናት እንድንሆን ላደረገ፥ ለእርሱ ከዘላለም እስከ ዘላለም ድረስ ክብርና ኃይል ይሁን፤ አሜን። ");
INSERT INTO amh_vpl VALUES ("RV1_7","096_1_7","REV","1","7","7","እነሆ፥ ከደመና ጋር ይመጣል፤ ዓይንም ሁሉ የወጉትም ያዩታል፥ የምድርም ወገኖች ሁሉ ስለ እርሱ ዋይ ዋይ ይላሉ። አዎን፥ አሜን። ");
INSERT INTO amh_vpl VALUES ("RV1_8","096_1_8","REV","1","8","8","ያለውና የነበረው የሚመጣውም ሁሉንም የሚገዛ ጌታ አምላክ። አልፋና ዖሜጋ እኔ ነኝ ይላል። ");
INSERT INTO amh_vpl VALUES ("RV1_9","096_1_9","REV","1","9","9","እኔ ወንድማችሁ የሆንሁ ከእናንተም ጋር አብሬ መከራውንና መንግሥቱን የኢየሱስ ክርስቶስንም ትዕግሥት የምካፈል ዮሐንስ ስለ እግዚአብሔር ቃልና ስለ ኢየሱስ ምስክር ፍጥሞ በምትባል ደሴት ነበርሁ። ");
INSERT INTO amh_vpl VALUES ("RV1_10","096_1_10","REV","1","10","10","በጌታ ቀን በመንፈስ ነበርሁ፥ በኋላዬም የመለከትን ድምፅ የሚመስል ትላቅ ድምፅ ሰማሁ፥ ");
INSERT INTO amh_vpl VALUES ("RV1_11","096_1_11","REV","1","11","11","እንዲሁም። የምታየውን በመጽሐፍ ጽፈህ ወደ ኤፌሶንና ወደ ሰምርኔስ ወደ ጴርጋሞንም ወደ ትያጥሮንም ወደ ሰርዴስም ወደ ፊልድልፍያም ወደ ሎዶቅያም በእስያ ወዳሉት ወደ ሰባቱ አብያተ ክርስቲያናት ላክ አለኝ። ");
INSERT INTO amh_vpl VALUES ("RV1_12","096_1_12","REV","1","12","12","የሚናገረኝንም ድምፅ ለማየት ዘወር አልሁ፤ ዘወርም ብዬ ሰባት የወርቅ መቅረዞች አየሁ፥ ");
INSERT INTO amh_vpl VALUES ("RV1_13","096_1_13","REV","1","13","13","በመቅረዞቹም መካከል የሰው ልጅ የሚመስለውን አየሁ፥ እርሱም እስከ እግሩ ድረስ ልብስ የለበሰው ደረቱንም በወርቅ መታጠቂያ የታጠቀ ነበር። ");
INSERT INTO amh_vpl VALUES ("RV1_14","096_1_14","REV","1","14","14","ራሱና የራሱ ጠጕርም እንደ ነጭ የበግ ጠጕር እንደ በረዶም ነጭ ነበሩ፥ ዓይኖቹም እንደ እሳት ነበልባል ነበሩ፤ ");
INSERT INTO amh_vpl VALUES ("RV1_15","096_1_15","REV","1","15","15","እግሮቹም በእቶን የነጠረ የጋለ ናስ ይመስሉ ነበር፥ ድምፁም እንደ ብዙ ውኃዎች ድምፅ ነበረ። ");
INSERT INTO amh_vpl VALUES ("RV1_16","096_1_16","REV","1","16","16","በቀኝ እጁም ሰባት ከዋክብት ነበሩት፥ ከአፉም በሁለት ወገን የተሳለ ስለታም ሰይፍ ወጣ፤ ፊቱም በኃይል እንደሚበራ እንደ ፀሐይ ነበረ። ");
INSERT INTO amh_vpl VALUES ("RV1_17","096_1_17","REV","1","17","17","ባየሁትም ጊዜ እንደ ሞተ ሰው ሆኜ ከእግሩ በታች ወደቅሁ። ቀኝ እጁንም ጫነብኝ እንዲህም አለኝ። አትፍራ፤ ፊተኛውና መጨረሻው ሕያውም እኔ ነኝ፥ ");
INSERT INTO amh_vpl VALUES ("RV1_18","096_1_18","REV","1","18","18","ሞቼም ነበርሁ እነሆም፥ ከዘላለም እስከ ዘላለም ድረስ ሕያው ነኝ፥ የሞትና የሲኦልም መክፈቻ አለኝ። ");
INSERT INTO amh_vpl VALUES ("RV1_19","096_1_19","REV","1","19","19","እንግዲህ ያየኸውን አሁንም ያለውን ከዚህም በኋላ ይሆን ዘንድ ያለውን ጻፍ። ");
INSERT INTO amh_vpl VALUES ("RV1_20","096_1_20","REV","1","20","20","በቀኝ እጄ ያየሃቸው የሰባቱ ከዋክብትና የሰባቱ የወርቅ መቅረዞች ምሥጢር ይህ ነው፤ ሰባቱ ከዋክብት የሰባቱ አብያተ ክርስቲያናት መላእክት ናቸው፥ ሰባቱም መቅረዞች ሰባቱ አብያተ ክርስቲያናት ናቸው። ");
INSERT INTO amh_vpl VALUES ("RV2_1","096_2_1","REV","2","1","1","በኤፌሶን ወዳለው ወደ ቤተ ክርስቲያን መልአክ እንዲህ ብለህ ጻፍ። በቀኝ እጁ ሰባቱን ከዋክብት የያዘው በሰባቱም የወርቅ መቅረዞች መካከል የሚሄደው እንዲህ ይላል። ");
INSERT INTO amh_vpl VALUES ("RV2_2","096_2_2","REV","2","2","2","ሥራህንና ድካምህን ትዕግሥትህንም አውቃለሁ፤ ክፉዎችንም ልትታገሥ እንዳትችል፥ እንዲሁም ሳይሆኑ። ሐዋርያት ነን የሚሉቱን መርምረህ ሐሰተኞች ሆነው እንዳገኘሃቸው አውቃለሁ፤ ");
INSERT INTO amh_vpl VALUES ("RV2_3","096_2_3","REV","2","3","3","ታግሠህማል፥ ስለ ስሜም ብለህ ጸንተህ አልደከምህም። ");
INSERT INTO amh_vpl VALUES ("RV2_4","096_2_4","REV","2","4","4","ዳሩ ግን የምነቅፍብህ ነገር አለኝ የቀደመውን ፍቅርህን ትተሃልና። ");
INSERT INTO amh_vpl VALUES ("RV2_5","096_2_5","REV","2","5","5","እንግዲህ ከወዴት እንደ ወደቅህ አስብ ንስሐም ግባ የቀደመውንም ሥራህን አድርግ፤ አለዚያ እመጣብሃለሁ ንስሐም ባትገባ መቅረዝህን ከስፍራው እወስዳለሁ። ");
INSERT INTO amh_vpl VALUES ("RV2_6","096_2_6","REV","2","6","6","ነገር ግን ይህ አለህ፤ እኔ ደግሞ የምጠላውን የኒቆላውያንን ሥራ ጠልተሃልና። ");
INSERT INTO amh_vpl VALUES ("RV2_7","096_2_7","REV","2","7","7","መንፈስ ለአብያተ ክርስቲያናት የሚለውን ጆሮ ያለው ይስማ። ድል ለነሣው በእግዚአብሔር ገነት ካለው ከሕይወት ዛፍ እንዲበላ እሰጠዋለሁ። ");
INSERT INTO amh_vpl VALUES ("RV2_8","096_2_8","REV","2","8","8","በሰምርኔስም ወዳለው ወደ ቤተ ክርስቲያን መልአክ እንዲህ ብለህ ጻፍ። ሞቶ የነበረው ሕያውም የሆነው ፊተኛውና መጨረሻው እንዲህ ይላል። ");
INSERT INTO amh_vpl VALUES ("RV2_9","096_2_9","REV","2","9","9","መከራህንና ድህነትህን አውቃለሁ፥ ነገር ግን ባለ ጠጋ ነህ፤ የሰይጣንም ማኅበር ናቸው እንጂ አይሁድ ሳይሆኑ። አይሁድ ነን የሚሉት የሚሳደቡትን ስድብ አውቃለሁ። ");
INSERT INTO amh_vpl VALUES ("RV2_10","096_2_10","REV","2","10","10","ልትቀበለው ያለህን መከራ አትፍራ። እነሆ፥ እንድትፈተኑ ዲያብሎስ ከእናንተ አንዳንዶቻችሁን በወኅኒ ሊያገባችሁ አለው፥ አሥር ቀንም መከራን ትቀበላላችሁ። እስከሞት ድረስ የታመንህ ሁን የሕይወትንም አክሊል እሰጥሃለሁ። ");
INSERT INTO amh_vpl VALUES ("RV2_11","096_2_11","REV","2","11","11","መንፈስ ለአብያተ ክርስቲያናት የሚለውን ጆሮ ያለው ይስማ። ድል የነሣው በሁለተኛው ሞት አይጐዳም። ");
INSERT INTO amh_vpl VALUES ("RV2_12","096_2_12","REV","2","12","12","በጴርጋሞንም ወዳለው ወደ ቤተ ክርስቲያን መልአክ እንዲህ ብለህ ጻፍ። በሁለት ወገን የተሳለ ስለታም ሰይፍ ያለው እንዲህ ይላል። ");
INSERT INTO amh_vpl VALUES ("RV2_13","096_2_13","REV","2","13","13","የሰይጣን ዙፋን ባለበት የምትኖርበትን አውቃለሁ፤ ስሜንም ትጠብቃለህ፥ ሰይጣንም በሚኖርበት፥ በእናንተ ዘንድ የተገደለው የታመነው ምስክሬ አንቲጳስ በነበረበት ዘመን እንኳ ሃይማኖቴን አልካድህም። ");
INSERT INTO amh_vpl VALUES ("RV2_14","096_2_14","REV","2","14","14","ዳሩ ግን ለጣዖት የታረደውን እንዲበሉና እንዲሴስኑ በእስራኤል ልጆች ፊት ማሰናከያን ሊያኖርባቸው ባላቅን ያስተማረ የበልዓምን ትምህርት የሚጠብቁ በዚያ ከአንተ ጋር ስላሉ፥ የምነቅፍብህ ጥቂት ነገር አለኝ። ");
INSERT INTO amh_vpl VALUES ("RV2_15","096_2_15","REV","2","15","15","እንዲሁ የኒቆላውያንን ትምህርት እንደ እነዚህ የሚጠብቁ ሰዎች ከአንተ ጋር ደግሞ አሉ። ");
INSERT INTO amh_vpl VALUES ("RV2_16","096_2_16","REV","2","16","16","እንግዲህ ንስሐ ግባ፤ አለዚያ ፈጥኜ እመጣብሃለሁ፥ በአፌም ሰይፍ እዋጋቸዋለሁ። ");
INSERT INTO amh_vpl VALUES ("RV2_17","096_2_17","REV","2","17","17","መንፈስ ለአብያተ ክርስቲያናት የሚለውን ጆሮ ያለው ይስማ። ድል ለነሣው ከተሰወረ መና እሰጠዋለሁ፥ ነጭ ድንጋይንም እሰጠዋለሁ፥ በድንጋዩም ላይ ከተቀበለው በቀር አንድ ስንኳ የሚያውቀው የሌለ አዲስ ስም ተጽፎአል። ");
INSERT INTO amh_vpl VALUES ("RV2_18","096_2_18","REV","2","18","18","በትያጥሮንም ወዳለው ወደ ቤተ ክርስቲያን መልአክ እንዲህ ብለህ ጻፍ። እንደ እሳት ነበልባል የሆኑ ዓይኖች ያሉት በእቶንም የነጠረ የጋለ ናስ የሚመስሉ እግሮች ያሉት የእግዚአብሔር ልጅ እንዲህ ይላል። ");
INSERT INTO amh_vpl VALUES ("RV2_19","096_2_19","REV","2","19","19","ሥራህንና ፍቅርህን እምነትህንም አገልግሎትህንም ትዕግሥትህንም ከፊተኛውም ሥራህ ይልቅ የኋለኛው እንዲበዛ አውቃለሁ። ");
INSERT INTO amh_vpl VALUES ("RV2_20","096_2_20","REV","2","20","20","ዳሩ ግን። ነቢይ ነኝ የምትለውን ባሪያዎቼንም እንዲሴስኑና ለጣዖት የታረደውን እንዲበሉ የምታስተምረውንና የምታስተውን ያችን ሴት ኤልዛቤልን ስለምትተዋት የምነቅፍብህ ነገር አለኝ፤ ");
INSERT INTO amh_vpl VALUES ("RV2_21","096_2_21","REV","2","21","21","ንስሐም እንድትገባ ጊዜ ሰጠኋት ከዝሙትዋም ንስሐ እንድትገባ አልወደደችም። ");
INSERT INTO amh_vpl VALUES ("RV2_22","096_2_22","REV","2","22","22","እነሆ፥ በአልጋ ላይ እጥላታለሁ፥ ከእርስዋም ጋር የሚያመነዝሩትን ከሥራዋ ንስሐ ባይገቡ በታላቅ መከራ እጥላቸዋለሁ፤ ");
INSERT INTO amh_vpl VALUES ("RV2_23","096_2_23","REV","2","23","23","ልጆችዋንም በሞት እገድላቸዋለሁ፤ አብያተ ክርስቲያናትም ሁሉ ኵላሊትንና ልብን የምመረምር እኔ እንደ ሆንሁ ያውቃሉ፥ ለእያንዳንዳችሁም እንደ ሥራችሁ እሰጣችኋለሁ። ");
INSERT INTO amh_vpl VALUES ("RV2_24","096_2_24","REV","2","24","24","ዳሩ ግን ይህን ትምህርት ለማትይዙ ሁሉ የሰይጣንንም ጥልቅ ነገር እነርሱ እንደሚሉት ለማታውቁ ለእናንተ በትያጥሮን ለቀራችሁት እላለሁ፤ ሌላ ሸክም አልጭንባችሁም፥ ");
INSERT INTO amh_vpl VALUES ("RV2_25","096_2_25","REV","2","25","25","ነገር ግን እስክመጣ ድረስ ያላችሁን ጠብቁ። ");
INSERT INTO amh_vpl VALUES ("RV2_26","096_2_26","REV","2","26","28","የንጋትንም ኮከብ እሰጠዋለሁ። ");
INSERT INTO amh_vpl VALUES ("RV2_29","096_2_29","REV","2","29","29","መንፈስ ለአብያተ ክርስቲያናት የሚለውን ጆሮ ያለው ይስማ። ");
INSERT INTO amh_vpl VALUES ("RV3_1","096_3_1","REV","3","1","1","በሰርዴስም ወዳለው ወደ ቤተ ክርስቲያን መልአክ እንዲህ ብለህ ጻፍ። ሰባቱ የእግዚአብሔር መናፍስትና ሰባቱ ከዋክብት ያሉት እንዲህ ይላል። ሥራህን አውቃለሁ ሕያው እንደ መሆንህ ስም አለህ ሞተህማል። ");
INSERT INTO amh_vpl VALUES ("RV3_2","096_3_2","REV","3","2","2","ሥራህን በአምላኬ ፊት ፍጹም ሆኖ አላገኘሁትምና የነቃህ ሁን፥ ሊሞቱም ያላቸውን የቀሩትን ነገሮች አጽና። ");
INSERT INTO amh_vpl VALUES ("RV3_3","096_3_3","REV","3","3","3","እንግዲህ እንዴት እንደ ተቀበልህና እንደ ሰማህ አስብ፥ ጠብቀውም ንስሐም ግባ። እንግዲያስ ባትነቃ እንደ ሌባ እመጣብሃለሁ በማናቸውም ሰዓት እንድመጣብህ ከቶ አታውቅም። ");
INSERT INTO amh_vpl VALUES ("RV3_4","096_3_4","REV","3","4","4","ነገር ግን ልብሳቸውን ያላረከሱ በሰርዴስ ጥቂት ሰዎች ከአንተ ጋር አሉ፥ የተገባቸውም ስለ ሆኑ ነጭ ልብስ ለብሰው ከእኔ ጋር ይሄዳሉ። ");
INSERT INTO amh_vpl VALUES ("RV3_5","096_3_5","REV","3","5","5","ድል የነሣው እንዲሁ በነጭ ልብስ ይጐናጸፋል፥ ስሙንም ከሕይወት መጽሐፍ አልደመስስም፥ በአባቴና በመላእክቱም ፊት ለስሙ እመሰክርለታለሁ። ");
INSERT INTO amh_vpl VALUES ("RV3_6","096_3_6","REV","3","6","6","መንፈስ ለአብያተ ክርስቲያናት የሚለውን ጆሮ ያለው ይስማ። ");
INSERT INTO amh_vpl VALUES ("RV3_7","096_3_7","REV","3","7","7","በፊልድልፍያም ወዳለው ወደ ቤተ ክርስቲያን መልአክ እንዲህ ብለህ ጻፍ። የዳዊት መክፈቻ ያለው፤ የሚከፍት፥ የሚዘጋም የሌለ፤ የሚዘጋ፥ የሚከፍትም የሌለ፤ ቅዱስና እውነተኛ የሆነው እርሱ እንዲህ ይላል። ");
INSERT INTO amh_vpl VALUES ("RV3_8","096_3_8","REV","3","8","8","ሥራህን አውቃለሁ፤ እነሆ፥ በአንተ ፊት የተከፈተ በር ሰጥቼአለሁ ማንምም ሊዘጋው አይችልም፤ ኃይልህ ምንም ትንሽ ቢሆን ቃሌን ጠብቀሃልና፥ ስሜንም አልካድህምና። ");
INSERT INTO amh_vpl VALUES ("RV3_9","096_3_9","REV","3","9","9","እነሆ፥ አይሁድ ሳይሆኑ። አይሁድ ነን ከሚሉ ነገር ግን ከሚዋሹ ከሰይጣን ማኅበር አንዳንዶችን እሰጥሃለሁ እነሆ፥ መጥተው በእግሮችህ ፊት ይሰግዱ ዘንድ እኔም እንደ ወደድሁህ ያውቁ ዘንድ አደርጋቸዋለሁ። ");
INSERT INTO amh_vpl VALUES ("RV3_10","096_3_10","REV","3","10","10","የትዕግሥቴን ቃል ስለ ጠበቅህ እኔ ደግሞ በምድር የሚኖሩትን ይፈትናቸው ዘንድ በዓለም ሁሉ ላይ ሊመጣ ካለው ከፈተናው ሰዓት እጠብቅሃለሁ። ");
INSERT INTO amh_vpl VALUES ("RV3_11","096_3_11","REV","3","11","11","እነሆ፥ ቶሎ ብዬ እመጣለሁ፤ ማንም አክሊልህን እንዳይወስድብህ ያለህን አጽንተህ ያዝ። ");
INSERT INTO amh_vpl VALUES ("RV3_12","096_3_12","REV","3","12","12","ድል የነሣው በአምላኬ መቅደስ ዓምድ እንዲሆን አደርገዋለሁ፥ ወደ ፊትም ከዚያ ከቶ አይወጣም፤ የአምላኬን ስምና የአምላኬን ከተማ ስም፥ ማለት ከሰማይ ከአምላኬ ዘንድ የምትወርደውን አዲሲቱን ኢየሩሳሌምን፥ አዲሱንም ስሜን በእርሱ ላይ እጽፋለሁ። ");
INSERT INTO amh_vpl VALUES ("RV3_13","096_3_13","REV","3","13","13","መንፈስ ለአብያተ ክርስቲያናት የሚለውን ጆሮ ያለው ይስማ። ");
INSERT INTO amh_vpl VALUES ("RV3_14","096_3_14","REV","3","14","14","በሎዶቅያም ወዳለው ወደ ቤተ ክርስቲያን መልአክ እንዲህ ብለህ ጻፍ። አሜን የሆነው፥ የታመነውና እውነተኛው ምስክር፥ በእግዚአብሔርም ፍጥረት መጀመሪያ የነበረው እንዲህ ይላል። ");
INSERT INTO amh_vpl VALUES ("RV3_15","096_3_15","REV","3","15","15","በራድ ወይም ትኩስ እንዳይደለህ ሥራህን አውቃለሁ። በራድ ወይም ትኩስ ብትሆንስ መልካም በሆነ ነበር። ");
INSERT INTO amh_vpl VALUES ("RV3_16","096_3_16","REV","3","16","16","እንዲሁ ለብ ስላልህ በራድም ወይም ትኩስ ስላልሆንህ ከአፌ ልተፋህ ነው። ");
INSERT INTO amh_vpl VALUES ("RV3_17","096_3_17","REV","3","17","17","ሀብታም ነኝና ባለጠጋ ሆኜአለሁ አንድም ስንኳ አያስፈልገኝም የምትል ስለ ሆንህ፥ ጐስቋላና ምስኪንም ድሀም ዕውርም የተራቆትህም መሆንህን ስለማታውቅ፥ ");
INSERT INTO amh_vpl VALUES ("RV3_18","096_3_18","REV","3","18","18","ባለ ጠጋ እንድትሆን በእሳት የነጠረውን ወርቅ፥ ተጐናጽፈህም የራቁትነትህ ኃፍረት እንዳይገለጥ ነጭ ልብስን፥ እንድታይም ዓይኖችህን የምትኳለውን ኵል ከእኔ ትገዛ ዘንድ እመክርሃለሁ። ");
INSERT INTO amh_vpl VALUES ("RV3_19","096_3_19","REV","3","19","19","እኔ የምወዳቸውን ሁሉ እገሥጻቸዋለሁ እቀጣቸውማለሁ፤ እንግዲህ ቅና ንስሐም ግባ። ");
INSERT INTO amh_vpl VALUES ("RV3_20","096_3_20","REV","3","20","20","እነሆ በደጅ ቆሜ አንኳኳለሁ፤ ማንም ድምፄን ቢሰማ ደጁንም ቢከፍትልኝ፥ ወደ እርሱ እገባለሁ ከእርሱም ጋር እራት እበላለሁ እርሱም ከእኔ ጋር ይበላል። ");
INSERT INTO amh_vpl VALUES ("RV3_21","096_3_21","REV","3","21","21","እኔ ደግሞ ድል እንደ ነሣሁ ከአባቴም ጋር በዙፋኑ ላይ እንደተቀመጥሁ፥ ድል ለነሣው ከእኔ ጋር በዙፋኔ ላይ ይቀመጥ ዘንድ እሰጠዋለሁ። ");
INSERT INTO amh_vpl VALUES ("RV3_22","096_3_22","REV","3","22","22","መንፈስ ለአብያተ ክርስቲያናት የሚለውን ጆሮ ያለው ይስማ። ");
INSERT INTO amh_vpl VALUES ("RV4_1","096_4_1","REV","4","1","1","ከዚያ በኋላም አየሁ፥ እነሆም በሰማይ የተከፈተ ደጅ፥ እንደ መለከትም ሆኖ ሲናገረኝ የሰማሁት ፊተኛው ድምፅ። ወደዚህ ውጣና ከዚህ በኋላ ሊሆን የሚያስፈልገውን ነገር አሳይሃለሁ አለ። ");
INSERT INTO amh_vpl VALUES ("RV4_2","096_4_2","REV","4","2","2","ወዲያው በመንፈስ ነበርሁ፤ እነሆም፥ ዙፋን በሰማይ ቆሞአል በዙፋኑም ላይ ተቀማጭ ነበረ፤ ");
INSERT INTO amh_vpl VALUES ("RV4_3","096_4_3","REV","4","3","3","ተቀምጦም የነበረው በመልኩ የኢያስጲድንና የሰርዲኖን ዕንቍ ይመስል ነበር። በመልኩም መረግድን የመሰለ ቀስተ ደመና በዙፋኑ ዙሪያ ነበረ። ");
INSERT INTO amh_vpl VALUES ("RV4_4","096_4_4","REV","4","4","4","በዙፋኑ ዙሪያም ሀያ አራት ዙፋኖች ነበሩ፥ በዙፋኖቹም ላይ ነጭ ልብስ ለብሰው በራሳቸውም የወርቅ አክሊል ደፍተው ሀያ አራት ሽማግሌዎች ተቀምጠው ነበር። ");
INSERT INTO amh_vpl VALUES ("RV4_5","096_4_5","REV","4","5","5","ከዙፋኑም መብረቅና ድምፅ ነጐድጓድም ይወጣል፤ በዙፋኑም ፊት ሰባት የእሳት መብራቶች ይበሩ ነበር፥ እነርሱም ሰባቱ የእግዚአብሔር መናፍስት ናቸው። ");
INSERT INTO amh_vpl VALUES ("RV4_6","096_4_6","REV","4","6","6","በዙፋኑም ፊት ብርሌ የሚመስል የብርጭቆ ባሕር ነበረ። በዙፋኑም መካከል በዙፋኑም ዙሪያ፥ በፊትና በኋላ ዓይኖች የሞሉአቸው አራት እንስሶች ነበሩ። ");
INSERT INTO amh_vpl VALUES ("RV4_7","096_4_7","REV","4","7","7","ፊተኛውም እንስሳ አንበሳን ይመስላል፥ ሁለተኛውም እንስሳ ጥጃን ይመስላል፥ ሦስተኛውም እንስሳ እንደ ሰው ፊት ነበረው፥ አራተኛውም እንስሳ የሚበረውን ንስር ይመስላል። ");
INSERT INTO amh_vpl VALUES ("RV4_8","096_4_8","REV","4","8","8","አራቱም እንስሶች እያንዳንዳቸው ስድስት ክንፎች አሉአቸው፥ በዙሪያቸውና በውስጣቸውም ዓይኖች ሞልተውባቸዋል፤ ቅዱስ፥ ቅዱስ፥ ቅዱስ፥ የነበረውና ያለ የሚመጣውም ሁሉንም የሚገዛ ጌታ አምላክ እያሉ ቀንና ሌሊት አያርፉም። ");
INSERT INTO amh_vpl VALUES ("RV4_9","096_4_9","REV","4","9","11","እንስሶቹም በዙፋን ላይ ለተቀመጠው ከዘላለምም እስከ ዘላለም በሕይወት ለሚኖረው ለእርሱ ክብርና ውዳሴ ምስጋናም በሰጡት ጊዜ፥ ");
INSERT INTO amh_vpl VALUES ("RV5_1","096_5_1","REV","5","1","1","በዙፋኑ ላይም በተቀመጠው በቀኝ እጁ ላይ በውስጥና በኋላ የተጻፈበት በሰባትም ማኅተም የተዘጋ መጽሐፍን አየሁ። ");
INSERT INTO amh_vpl VALUES ("RV5_2","096_5_2","REV","5","2","2","ብርቱም መልአክ። መጽሐፉን ይዘረጋ ዘንድ ማኅተሞቹንም ይፈታ ዘንድ የሚገባው ማን ነው? ብሎ በታላቅ ድምፅ ሲያውጅ አየሁ። ");
INSERT INTO amh_vpl VALUES ("RV5_3","096_5_3","REV","5","3","3","በሰማይም ቢሆን በምድርም ላይ ቢሆን ከምድርም በታች ቢሆን መጽሐፉን ሊዘረጋ ወይም ሊመለከተው ማንም አልተቻለውም። ");
INSERT INTO amh_vpl VALUES ("RV5_4","096_5_4","REV","5","4","4","መጽሐፉን ሊዘረጋ ወይም ሊመለከተው የሚገባው ማንም ስላልተገኘ እጅግ አለቀስሁ። ");
INSERT INTO amh_vpl VALUES ("RV5_5","096_5_5","REV","5","5","5","ከሽማግሌዎቹም አንዱ። አታልቅስ፤ እነሆ፥ ከይሁዳ ነገድ የሆነው አንበሳ እርሱም የዳዊት ሥር መጽሐፉን ይዘረጋ ዘንድ ሰባቱንም ማኅተም ይፈታ ዘንድ ድል ነሥቶአል አለኝ። ");
INSERT INTO amh_vpl VALUES ("RV5_6","096_5_6","REV","5","6","6","በዙፋኑና በአራቱ እንስሶች መካከልም በሽማግሌዎችም መካከል እንደ ታረደ በግ ቆሞ አየሁ፥ ሰባትም ቀንዶችና ሰባት ዓይኖች ነበሩት እነርሱም ወደ ምድር ሁሉ የተላኩ የእግዚአብሔር መናፍስት ናቸው። ");
INSERT INTO amh_vpl VALUES ("RV5_7","096_5_7","REV","5","7","7","መጥቶም በዙፋን ላይ ከተቀመጠ ከዚያ ከቀኝ እጁ መጽሐፉን ወሰደው። ");
INSERT INTO amh_vpl VALUES ("RV5_8","096_5_8","REV","5","8","8","መጽሐፉንም በወሰደ ጊዜ አራቱ እንስሶችና ሀያ አራቱ ሽማግሌዎች በበጉ ፊት ወደቁ፥ እያንዳንዳቸውም በገናንና የቅዱሳን ጸሎት የሆነ ዕጣን የሞላበትን የወርቅ ዕቃ ያዙ። ");
INSERT INTO amh_vpl VALUES ("RV5_9","096_5_9","REV","5","9","11","አየሁም፥ በዙፋኑም በእንስሶቹም በሽማግሌዎቹም ዙሪያ የብዙ መላእክትን ድምፅ ሰማሁ፤ ቍጥራቸውም አእላፋት ጊዜ አእላፋትና ሺህ ጊዜ ሺህ ነበር፥ ");
INSERT INTO amh_vpl VALUES ("RV5_12","096_5_12","REV","5","12","12","በታላቅም ድምፅ። የታረደው በግ ኃይልና ባለ ጠግነት ጥበብም ብርታትም ክብርም ምስጋናም በረከትም ሊቀበል ይገባዋል አሉ። ");
INSERT INTO amh_vpl VALUES ("RV5_13","096_5_13","REV","5","13","13","በሰማይና በምድርም ከምድርም በታች በባሕርም ላይ ያለ ፍጥረት ሁሉ በእነርሱም ውስጥ ያለ ሁሉ። በረከትና ክብር ምስጋናም ኃይልም ከዘላለም እስከ ዘላለም በዙፋኑ ላይ ለተቀመጠው፥ ለበጉም ይሁን ሲሉ ሰማሁ። ");
INSERT INTO amh_vpl VALUES ("RV5_14","096_5_14","REV","5","14","14","አራቱም እንስሶች። አሜን አሉ፥ ሽማግሌዎቹም ወድቀው ሰገዱ። ");
INSERT INTO amh_vpl VALUES ("RV6_1","096_6_1","REV","6","1","1","በጉም ከሰባቱ ማኅተም አንዱን በፈታ ጊዜ አየሁ፥ ከአራቱም እንስሶች አንዱ ነጐድጓድ በሚመስል ድምፅ። መጥተህ እይ ሲል ሰማሁ። ");
INSERT INTO amh_vpl VALUES ("RV6_2","096_6_2","REV","6","2","2","አየሁም፥ እነሆም፥ አምባላይ ፈረስ ወጣ፥ በእርሱም ላይ የተቀመጠው ቀስት ነበረው፥ አክሊልም ተሰጠው፥ ድልም እየነሣ ወጣ ድል ለመንሣት። ");
INSERT INTO amh_vpl VALUES ("RV6_3","096_6_3","REV","6","3","3","ሁለተኛውንም ማኅተም በፈታ ጊዜ ሁለተኛው እንስሳ። መጥተህ እይ ሲል ሰማሁ። ");
INSERT INTO amh_vpl VALUES ("RV6_4","096_6_4","REV","6","4","4","ሌላም ዳማ ፈረስ ወጣ፥ በእርሱም ላይ ለተቀመጠው ሰላምን ከምድር ይወስድ ዘንድ ሰዎችም እርስ በርሳቸው እንዲተራረዱ ሥልጣን ተሰጠው፥ ታላቅም ሰይፍ ተሰጠው። ");
INSERT INTO amh_vpl VALUES ("RV6_5","096_6_5","REV","6","5","5","ሦስተኛውንም ማኅተም በፈታ ጊዜ ሦስተኛው እንስሳ። መጥተህ እይ ሲል ሰማሁ። አየሁም፥ እነሆም፥ ጕራቻ ፈረስ ወጣ፥ በእርሱም ላይ የተቀመጠው በእጁ ሚዛን ያዘ። ");
INSERT INTO amh_vpl VALUES ("RV6_6","096_6_6","REV","6","6","6","በአራቱም እንስሶች መካከል ድምፅ። አንድ እርቦ ስንዴ በዲናር ሦስት እርቦ ገብስም በዲናር፥ ዘይትንና ወይንንም አትጕዳ ሲል ሰማሁ። ");
INSERT INTO amh_vpl VALUES ("RV6_7","096_6_7","REV","6","7","7","አራተኛውንም ማኅተም በፈታ ጊዜ የአራተኛው እንስሳ ድምፅ። መጥተህ እይ ሲል ሰማሁ። ");
INSERT INTO amh_vpl VALUES ("RV6_8","096_6_8","REV","6","8","8","አየሁም፥ እነሆም፥ ሐመር ፈረስ ወጣ፥ በእርሱም ላይ የተቀመጠው ስሙ ሞት ነበረ። ሲኦልም ተከተለው፤ በሰይፍና በራብም በሞትም በምድርም አራዊት ይገድሉ ዘንድ ከምድር በአራተኛዋ እጅ ላይ ሥልጣን ተሰጣቸው። ");
INSERT INTO amh_vpl VALUES ("RV6_9","096_6_9","REV","6","9","9","አምስተኛውንም ማኅተም በፈታ ጊዜ፥ ስለ እግዚአብሔር ቃልና ስለ ጠበቁት ምስክር የታረዱትን የሰዎች ነፍሳት ከመሠዊያ በታች አየሁ። ");
INSERT INTO amh_vpl VALUES ("RV6_10","096_6_10","REV","6","10","10","በታላቅ ድምፅም እየጮኹ። ቅዱስና እውነተኛ ጌታ ሆይ፥ እስከ መቼ ድረስ አትፈርድም ደማችንንስ በምድር በሚኖሩት ላይ እስከ መቼ አትበቀልም? አሉ። ");
INSERT INTO amh_vpl VALUES ("RV6_11","096_6_11","REV","6","11","11","ለእያንዳንዳቸውም ነጭ ልብስ ተሰጣቸው፥ እንደ እነርሱም ደግሞ ይገደሉ ዘንድ ያላቸው የባሪያዎች ባልንጀራዎቻቸውና የወንድሞቻቸው ቍጥር እስኪፈጸም ድረስ፥ ገና ጥቂት ዘመን እንዲያርፉ ተባለላቸው። ");
INSERT INTO amh_vpl VALUES ("RV6_12","096_6_12","REV","6","12","12","ስድስተኛውንም ማኅተም በፈታ ጊዜ አየሁ፥ ታላቅም የምድር መናወጥ ሆነ፥ ፀሐይም እንደ ማቅ ጠጕር ጥቁር ሆነ፥ ጨረቃም በሞላው እንደ ደም ሆነ፥ ");
INSERT INTO amh_vpl VALUES ("RV6_13","096_6_13","REV","6","13","13","በለስም በብርቱ ነፋስ ተናውጣ ቃርያዋን ፍሬ እንደምትጥል የሰማይ ከዋክብት ወደ ምድር ወደቁ፥ ");
INSERT INTO amh_vpl VALUES ("RV6_14","096_6_14","REV","6","14","14","ሰማይም እንደ መጽሐፍ ተጠቅልሎ አለፈ፥ ተራራዎችና ደሴቶችም ሁሉ ከስፍራቸው ተወሰዱ። ");
INSERT INTO amh_vpl VALUES ("RV6_15","096_6_15","REV","6","15","15","የምድርም ነገሥታትና መኳንንት ሻለቃዎችም ባለ ጠጋዎችም ኃይለኛዎችም ባሪያዎችም ጌቶችም ሁሉ በዋሾችና በተራራዎች ዓለቶች ተሰወሩ፥ ");
INSERT INTO amh_vpl VALUES ("RV6_16","096_6_16","REV","6","16","16","ተራራዎችንና ዓለቶችንም። በላያችን ውደቁ በዙፋንም ከተቀመጠው ፊት ከበጉም ቍጣ ሰውሩን፤ ");
INSERT INTO amh_vpl VALUES ("RV6_17","096_6_17","REV","6","17","17","ታላቁ የቁጣው ቀን መጥቶአልና፥ ማንስ ሊቆም ይችላል? አሉአቸው። ");
INSERT INTO amh_vpl VALUES ("RV7_1","096_7_1","REV","7","1","1","ከዚህም በኋላ በአራቱ በምድር ማዕዘን ቆመው አራት መላእክት አየሁ፥ እነርሱም ነፋስ በምድር ቢሆን ወይም በባሕር ወይም በማንም ዛፍ እንዳይነፍስ አራቱን የምድር ነፋሳት ያዙ። ");
INSERT INTO amh_vpl VALUES ("RV7_2","096_7_2","REV","7","2","2","የሕያው አምላክ ማኅተም ያለውም ሌላ መልአክ ከፀሐይ መውጫ ሲወጣ አየሁ፥ ምድርንና ባሕርንም ሊጐዱ ለተሰጣቸው ለአራቱ መላእክት በታላቅ ድምፅ እየጮኸ። ");
INSERT INTO amh_vpl VALUES ("RV7_3","096_7_3","REV","7","3","3","የአምላካችንን ባሪያዎች ግምባራቸውን እስክናትማቸው ድረስ ምድርን ቢሆን ወይም ባሕርን ወይም ዛፎችን አትጕዱ አላቸው። ");
INSERT INTO amh_vpl VALUES ("RV7_4","096_7_4","REV","7","4","4","የታተሙትንም ቍጥር ሰማሁ፤ ከእስራኤል ልጆች ነገድ ሁሉ የታተሙት መቶ አርባ አራት ሺህ ነበሩ። ");
INSERT INTO amh_vpl VALUES ("RV7_5","096_7_5","REV","7","5","5","ከይሁዳ ነገድ አሥራ ሁለት ሺህ ታተሙ፥ ከሮቤል ነገድ አሥራ ሁለት ሺህ፥ ከጋድ ነገድ አሥራ ሁለት ሺህ፥ ");
INSERT INTO amh_vpl VALUES ("RV7_6","096_7_6","REV","7","6","6","ከአሴር ነገድ አሥራ ሁለት ሺህ፥ ከንፍታሌም ነገድ አሥራ ሁለት ሺህ፥ ");
INSERT INTO amh_vpl VALUES ("RV7_7","096_7_7","REV","7","7","7","ከምናሴ ነገድ አሥራ ሁለት ሺህ፥ ከስምዖን ነገድ አሥራ ሁለት ሺህ፥ ከሌዊ ነገድ አሥራ ሁለት ሺህ፥ ከይሳኮር ነገድ አሥራ ሁለት ሺህ፥ ");
INSERT INTO amh_vpl VALUES ("RV7_8","096_7_8","REV","7","8","8","ከዛብሎን ነገድ አሥራ ሁለት ሺህ፥ ከዮሴፍ ነገድ አሥራ ሁለት ሺህ፥ ከብንያም ነገድ አሥራ ሁለት ሺህ ታተሙ። ");
INSERT INTO amh_vpl VALUES ("RV7_9","096_7_9","REV","7","9","9","ከዚህ በኋላ አየሁ፥ እነሆም፥ አንድ እንኳ ሊቆጥራቸው የማይችል ከሕዝብና ከነገድ ከወገንም ከቋንቋም ሁሉ እጅግ ብዙ ሰዎች ነበሩ፤ ነጭ ልብስም ለብሰው የዘንባባንም ዝንጣፊዎች በእጆቻቸው ይዘው በዙፋኑና በበጉ ፊት ቆሙ፤ ");
INSERT INTO amh_vpl VALUES ("RV7_10","096_7_10","REV","7","10","10","በታላቅም ድምፅ እየጮሁ። በዙፋኑ ላይ ለተቀመጠው ለአምላካችንና ለበጉ ማዳን ነው አሉ። ");
INSERT INTO amh_vpl VALUES ("RV7_11","096_7_11","REV","7","11","11","መላእክቱም ሁሉ በዙፋኑና በሽማግሌዎቹ በአራቱም እንስሶቹ ዙሪያ ቆመው ነበር፤ በዙፋኑም ፊት በግምባራቸው ተደፉ፥ ለእግዚአብሔርም እየሰገዱ። ");
INSERT INTO amh_vpl VALUES ("RV7_12","096_7_12","REV","7","12","12","አሜን፥ በረከትና ክብር ጥበብም ምስጋናም ውዳሴም ኃይልም ብርታትም ከዘላለም እስከ ዘላለም ድረስ ለአምላካችን ይሁን፤ አሜን አሉ። ");
INSERT INTO amh_vpl VALUES ("RV7_13","096_7_13","REV","7","13","13","ከሽማግሌዎቹም አንዱ ተመልሶ። እነዚህ ነጩን ልብስ የለበሱ እነማን ናቸው? ከወዴትስ መጡ? አለኝ። ");
INSERT INTO amh_vpl VALUES ("RV7_14","096_7_14","REV","7","14","14","እኔም። ጌታ ሆይ፥ አንተ ታውቃለህ አልሁት። አለኝም። እነዚህ ከታላቁ መከራ የመጡ ናቸው፥ ልብሳቸውንም አጥበው በበጉ ደም አነጹ። ");
INSERT INTO amh_vpl VALUES ("RV7_15","096_7_15","REV","7","15","15","ስለዚህ በእግዚአብሔር ዙፋን ፊት አሉ፥ ሌሊትና ቀንም በመቅደሱ ያመልኩታል፥ በዙፋኑም ላይ የተቀመጠው በእነርሱ ላይ ያድርባቸዋል። ");
INSERT INTO amh_vpl VALUES ("RV7_16","096_7_16","REV","7","16","16","ከእንግዲህ ወዲህ አይራቡም፥ ከእንግዲህም ወዲህ አይጠሙም፥ ፀሐይም ትኵሳትም ሁሉ ከቶ አይወርድባቸውም፤ ");
INSERT INTO amh_vpl VALUES ("RV7_17","096_7_17","REV","7","17","17","በዙፋኑ መካከል ያለው በጉ እረኛቸው ይሆናልና፥ ወደ ሕይወትም ውኃ ምንጭ ይመራቸዋልና፤ እግዚአብሔርም እንባዎችን ሁሉ ከዓይናቸው ያብሳል። ");
INSERT INTO amh_vpl VALUES ("RV8_1","096_8_1","REV","8","1","1","ሰባተኛውንም ማኅተም በፈታ ጊዜ እኵል ሰዓት የሚያህል ዝምታ በሰማይ ሆነ። ");
INSERT INTO amh_vpl VALUES ("RV8_2","096_8_2","REV","8","2","2","በእግዚአብሔርም ፊት የሚቆሙትን ሰባቱን መላእክት አየሁ፥ ሰባትም መለከት ተሰጣቸው። ");
INSERT INTO amh_vpl VALUES ("RV8_3","096_8_3","REV","8","3","3","ሌላም መልአክ መጣና የወርቅ ጥና ይዞ በመሰዊያው አጠገብ ቆመ፤ በዙፋኑም ፊት ባለው በወርቅ መሰዊያ ላይ ለቅዱሳን ሁሉ ጸሎት እንዲጨምረው ብዙ ዕጣን ተሰጠው። ");
INSERT INTO amh_vpl VALUES ("RV8_4","096_8_4","REV","8","4","4","የዕጣኑም ጢስ ከቅዱሳን ጸሎት ጋር ከመልአኩ እጅ በእግዚአብሔር ፊት ወጣ። ");
INSERT INTO amh_vpl VALUES ("RV8_5","096_8_5","REV","8","5","5","መልአኩም ጥናውን ይዞ የመሰዊያውን እሳት ሞላበት ወደ ምድርም ጣለው፤ ነጐድጓድና ድምፅም መብረቅም መናወጥም ሆነ። ");
INSERT INTO amh_vpl VALUES ("RV8_6","096_8_6","REV","8","6","6","ሰባቱንም መለከት የያዙ ሰባቱ መላእክት ሊነፉ ተዘጋጁ። ");
INSERT INTO amh_vpl VALUES ("RV8_7","096_8_7","REV","8","7","7","ፊተኛውም መልአክ ነፋ፤ ደምም የተቀላቀለበት በረዶና እሳት ሆነ፥ ወደ ምድርም ተጣለ፤ የምድርም ሲሶው ተቃጠለ የዛፎችም ሲሶው ተቃጠለ የለመለመም ሣር ሁሉ ተቃጠለ። ");
INSERT INTO amh_vpl VALUES ("RV8_8","096_8_8","REV","8","8","8","ሁለተኛውም መልአክ ነፋ፤ በእሳት የሚቃጠል ታላቅ ተራራን የሚመስል ነገር በባሕር ተጣለ፤ የባሕርም ሲሶው ደም ሆነ ");
INSERT INTO amh_vpl VALUES ("RV8_9","096_8_9","REV","8","9","9","በባሕርም ከሚኖሩ ሕይወት ካላቸው ፍጥረቶች ሲሶው ሞተ የመርከቦችም ሲሶው ጠፋ። ");
INSERT INTO amh_vpl VALUES ("RV8_10","096_8_10","REV","8","10","10","ሦስተኛውም መልአክ ነፋ፤ እንደ ችቦም የሚቃጠል ታላቅ ኮከብ ከሰማይ ወደቀ፥ በወንዞችና በውኃም ምንጮች ሲሶ ላይ ወደቀ። የኮከቡም ስም እሬቶ ይባላል። ");
INSERT INTO amh_vpl VALUES ("RV8_11","096_8_11","REV","8","11","11","የውኃውም ሲሶ መራራ ሆነ መራራም ስለተደረገ በውኃው ጠንቅ ብዙ ሰዎች ሞቱ። ");
INSERT INTO amh_vpl VALUES ("RV8_12","096_8_12","REV","8","12","12","አራተኛውም መልአክ ነፋ፤ የፀሐይ ሲሶና የጨረቃ ሲሶ የከዋክብትም ሲሶ ተመታ፥ የእነዚህ ሲሶ ይጨልም ዘንድ፥ የቀንም ሲሶው እንዳያበራ፥ እንዲሁም የሌሊት። ");
INSERT INTO amh_vpl VALUES ("RV8_13","096_8_13","REV","8","13","13","አየሁም፥ አንድም ንስር በሰማይ መካከል እየበረረ በታላቅ ድምፅ። ሊነፉ ያላቸው የሦስቱ መላእክት መለከት ስለሚቀረው ድምፅ በምድር ላይ ለሚኖሩት ወዮላቸው፥ ወዮላቸው፥ ወዮላቸው ሲል ሰማሁ። ");
INSERT INTO amh_vpl VALUES ("RV9_1","096_9_1","REV","9","1","1","አምስተኛውም መልአክ ነፋ፤ ከሰማይም ወደ ምድር ወድቆ የነበረ ኮከብ አየሁ፥ የጥልቁም ጕድጓድ መክፈቻ ተሰጠው። ");
INSERT INTO amh_vpl VALUES ("RV9_2","096_9_2","REV","9","2","2","የጥልቁንም ጕድጓድ ከፈተው፤ ጢስም ከታላቅ እቶን እንደሚወጣ ጢስ ሆኖ ከጕድጓዱ ወጣ ፀሐይና አየርም በጕድጓዱ ጢስ ጨለሙ። ");
INSERT INTO amh_vpl VALUES ("RV9_3","096_9_3","REV","9","3","3","ከጢሱም አንበጣዎች ወደ ምድር ወጡ፥ የምድርም ጊንጦች ሥልጣን እንዳላቸው ሥልጣን ተሰጣቸው። ");
INSERT INTO amh_vpl VALUES ("RV9_4","096_9_4","REV","9","4","4","የእግዚአብሔርም ማኅተም በግምባራቸው ከሌለባቸው ሰዎች በቀር በምድር ያለውን ሣር ቢሆንም ወይም ማናቸውንም የለመለመ ነገር ወይም ማናቸውንም ዛፍ እንዳይጐዱ ተባለላቸው። ");
INSERT INTO amh_vpl VALUES ("RV9_5","096_9_5","REV","9","5","5","አምስትም ወር ሊሣቅዩአቸው ተሰጣቸው እንጂ ሊገድሉአቸው አይደለም፤ እነርሱም የሚሣቅዩት ሥቃይ ጊንጥ ሰውን ነድፎ እንደሚሣቅይ ነው። ");
INSERT INTO amh_vpl VALUES ("RV9_6","096_9_6","REV","9","6","6","በዚያም ወራት ሰዎች ሞትን ይፈልጋሉ አያገኙትምም፥ ሊሞቱም ይመኛሉ ሞትም ከእነርሱ ይሸሻል። ");
INSERT INTO amh_vpl VALUES ("RV9_7","096_9_7","REV","9","7","7","የአንበጣዎቹም መልክ ለጦርነት እንደ ተዘጋጁ ፈረሶች ነው፥ በራሳቸውም ላይ ወርቅ እንደሚመስሉ አክሊሎች ነበሩአቸው፥ ፊታቸውም እንደ ሰው ፊት ነበረ፤ ");
INSERT INTO amh_vpl VALUES ("RV9_8","096_9_8","REV","9","8","8","የሴቶችን ጠጕር የሚመስል ጠጕር ነበራቸው፥ ጥርሳቸውም እንደ አንበሳ ጥርስ ነበረ፥ ");
INSERT INTO amh_vpl VALUES ("RV9_9","096_9_9","REV","9","9","9","የብረት ጥሩር የሚመስልም ጥሩር ነበራቸው፥ የክንፋቸውም ድምፅ ወደ ጦርነት እንደሚጋልቡ እንደ ብዙ ፈረሶች ሰረገላዎች ድምፅ ነበረ። ");
INSERT INTO amh_vpl VALUES ("RV9_10","096_9_10","REV","9","10","10","እንደ ጊንጥም ጅራት ያለ ጅራት አላቸው በጅራታቸውም መውጊያ አለ፥ ሰዎችንም አምስት ወር እንዲጐዱ ሥልጣን አላቸው። ");
INSERT INTO amh_vpl VALUES ("RV9_11","096_9_11","REV","9","11","11","በእነርሱም ላይ ንጉሥ አላቸው እርሱም የጥልቅ መልአክ ነው፥ ስሙም በዕብራይስጥ አብዶን በግሪክም አጶልዮን ይባላል። ");
INSERT INTO amh_vpl VALUES ("RV9_12","096_9_12","REV","9","12","12","ፊተኛው ወዮ አልፎአል፤ እነሆ፥ ከዚህ በኋላ ገና ሁለት ወዮ ይመጣል። ");
INSERT INTO amh_vpl VALUES ("RV9_13","096_9_13","REV","9","13","13","ስድስተኛውም መልአክ ነፋ፤ በእግዚአብሔርም ፊት ካለ በወርቅ ከተሠራ መሠዊያ ቀንዶች አንድ ድምፅ ሰማሁ፥ ");
INSERT INTO amh_vpl VALUES ("RV9_14","096_9_14","REV","9","14","14","መለከትም ያለውን ስድስተኛውን መልአክ። በታላቁ ወንዝ በኤፍራጥስ የታሰሩትን አራቱን መላእክት ፍታቸው አለው። ");
INSERT INTO amh_vpl VALUES ("RV9_15","096_9_15","REV","9","15","15","የሰዎችንም ሲሶ እንዲገድሉ ለሰዓቱና ለቀኑ ለወሩም ለዓመቱም ተዘጋጅተው የነበሩ አራቱ መላእክት ተፈቱ። ");
INSERT INTO amh_vpl VALUES ("RV9_16","096_9_16","REV","9","16","16","የፈረሰኞችም ጭፍራ ቁጥር እልፍ ጊዜ እልፍ፥ እልፍ ጊዜ እልፍ ነበረ፤ ቁጥራቸውን ሰማሁ። ");
INSERT INTO amh_vpl VALUES ("RV9_17","096_9_17","REV","9","17","17","ፈረሶቹንና በእነርሱም ላይ የተቀመጡትን እንዲሁ በራእይ አየሁ፤ እሳትና ያክንት ዲንም የሚመስል ጥሩር ነበራቸው፤ የፈረሶቹም ራስ እንደ አንበሳ ራስ ነበረ፥ ከአፋቸውም እሳትና ጢስ ዲንም ወጣ። ");
INSERT INTO amh_vpl VALUES ("RV9_18","096_9_18","REV","9","18","18","ከአፋቸውም በወጡት በእሳቱና በጢሱ በዲኑም በእነዚህ ሦስት መቅሰፍቶች የሰዎቹ ሲሶ ተገደለ። ");
INSERT INTO amh_vpl VALUES ("RV9_19","096_9_19","REV","9","19","19","የፈረሶቹ ሥልጣን በአፋቸውና በጅራታቸው ነውና፤ ጅራታቸው እባብን ይመስላልና፥ ራስም አላቸው በእርሱም ይጐዳሉ። ");
INSERT INTO amh_vpl VALUES ("RV9_20","096_9_20","REV","9","20","20","በእነዚህም መቅሠፍቶች ያልተገደሉት የቀሩቱ ሰዎች ለአጋንንትና ያዩ ወይም ይሰሙ ወይም ይሄዱ ዘንድ ለማይችሉ ከወርቅና ከብር ከናስም ከድንጋይም ከእንጨትም ለተሠሩ ለጣዖቶች እንዳይሰግዱ ስለ እጃቸው ሥራ ንስሐ አልገቡም፤ ");
INSERT INTO amh_vpl VALUES ("RV9_21","096_9_21","REV","9","21","21","ስለ መግደላቸውም ቢሆን ወይም ስለ አስማታቸው ወይም ስለ ዝሙታቸው ወይም ስለ ስርቆታቸው ንስሐ አልገቡም። ");
INSERT INTO amh_vpl VALUES ("RV10_1","096_10_1","REV","10","1","1","ሌላም ብርቱ መልአክ ደመና ተጐናጽፎ ከሰማይ ሲወርድ አየሁ፤ በራሱም ላይ ቀስተ ደመና ነበረ፥ ፊቱም እንደ ፀሐይ እግሮቹም እንደ እሳት ዓምዶች ነበሩ፥ ");
INSERT INTO amh_vpl VALUES ("RV10_2","096_10_2","REV","10","2","2","የተከፈተችንም ታናሽ መጽሐፍ በእጁ ያዘ። ቀኝ እግሩንም በባሕር ላይ ግራውንም በምድር ላይ አኖረ፥ እንደሚያገሣም አንበሳ በታላቅ ድምፅ ጮኸ። ");
INSERT INTO amh_vpl VALUES ("RV10_3","096_10_3","REV","10","3","3","በጮኸም ጊዜ ሰባቱ ነጐድጓድ በየድምፃቸው ተናገሩ። ");
INSERT INTO amh_vpl VALUES ("RV10_4","096_10_4","REV","10","4","4","ሰባቱ ነጐድጓድ በተናገሩ ጊዜ ልጽፍ አሰብሁ፤ ከሰማይም። ሰባቱ ነጐድጓድ የተናገሩትን ነገር በማኅተም ዝጋው አትጻፈውም የሚል ድምፅ ሰማሁ። ");
INSERT INTO amh_vpl VALUES ("RV10_5","096_10_5","REV","10","5","5","በባሕርና በምድርም ላይ ሲቆም ያየሁት መልአክ ቀኝ እጁን ወደ ሰማይ አሻቅቦ ዘረጋ፥ ");
INSERT INTO amh_vpl VALUES ("RV10_6","096_10_6","REV","10","6","6","ሰማይንና በእርሱም ያሉትን፥ ምድርንና በእርስዋም ያሉትን፥ ባሕርንና በእርሱም ያሉትን በፈጠረው፥ ከዘላለምም እስከ ዘላለም ድረስ ሕያው ሆኖ በሚኖረው ምሎ። ");
INSERT INTO amh_vpl VALUES ("RV10_7","096_10_7","REV","10","7","7","ወደ ፊት አይዘገይም፥ ዳሩ ግን ሰባተኛው መልአክ ሊነፋ ባለው ጊዜ ድምፁም በሚሰማበት ዘመን፥ ለባሪያዎቹ ለነቢያት የምስራች እንደ ሰበከላቸው የእግዚአብሔር ምሥጢር ይፈጸማል አለ። ");
INSERT INTO amh_vpl VALUES ("RV10_8","096_10_8","REV","10","8","8","ከሰማይም የሰማሁት ድምፅ እንደ ገና ሲናገረኝና። ሂድና በባሕርና በምድር ላይ ከሚቆመው መልአክ በእጁ ያለችውን የተከፈተችውን መጽሐፍ ውሰድ ሲል ሰማሁ። ");
INSERT INTO amh_vpl VALUES ("RV10_9","096_10_9","REV","10","9","9","ወደ መልአኩም ሄጄ። ታናሺቱን መጽሐፍ ስጠኝ አልሁት። እርሱም። ውሰድና ብላት፥ ሆድህንም መራራ ታደርገዋለች በአፍህ ግን እንደ ማር ትጣፍጣለች አለኝ። ");
INSERT INTO amh_vpl VALUES ("RV10_10","096_10_10","REV","10","10","10","ከመልአኩም እጅ ታናሺቱን መጽሐፍ ወስጄ በላኋት በአፌም እንደ ማር ጣፋጭ ሆነች፤ ከበላኋት በኋላም ሆዴ መራራ ሆነ። ");
INSERT INTO amh_vpl VALUES ("RV10_11","096_10_11","REV","10","11","11","በብዙ ወገኖችና በአሕዛብም በቋንቋዎችም በነገሥታትም ላይ እንደ ገና ትንቢት ትናገር ዘንድ ይገባሃል ተባለልኝ። ");
INSERT INTO amh_vpl VALUES ("RV11_1","096_11_1","REV","11","1","1","በትር የሚመስል መለኪያ ለእኔ ተሰጠኝ፥ እንዲህም ተባለልኝ። ተነሥተህ የእግዚአብሔርን መቅደስና መሠዊያውን በዚያም የሚሰግዱትን ለካ። ");
INSERT INTO amh_vpl VALUES ("RV11_2","096_11_2","REV","11","2","2","በመቅደሱም ውጭ ያለው እድሞ ለአሕዛብ ተሰጥቶአልና ተወው አትለካውም፤ እነርሱም አርባ ሁለት ወር የተቀደሰችውን ከተማ ይረግጡአታል። ");
INSERT INTO amh_vpl VALUES ("RV11_3","096_11_3","REV","11","3","3","ለሁለቱም ምስክሮቼ ማቅ ለብሰው ሺህ ከሁለት መቶ ስድሳ ቀን ትንቢት ሊናገሩ እሰጣለሁ። ");
INSERT INTO amh_vpl VALUES ("RV11_4","096_11_4","REV","11","4","4","እነዚህ በምድር ጌታ ፊት የሚቆሙ ሁለቱ ወይራዎችና ሁለቱ መቅረዞች ናቸው። ");
INSERT INTO amh_vpl VALUES ("RV11_5","096_11_5","REV","11","5","5","ማንምም ሊጐዳቸው ቢወድ እሳት ከአፋቸው ይወጣል ጠላቶቻቸውንም ይበላል፤ ማንም ሊጐዳቸው ቢወድም እንዲሁ ሊገደል ይገባዋል። ");
INSERT INTO amh_vpl VALUES ("RV11_6","096_11_6","REV","11","6","6","እነዚህ ትንቢት በሚናገሩበት ወራት ዝናብ እንዳይዘንብ ሰማይን ሊዘጉ ሥልጣን አላቸው፥ ውኃዎችንም ወደ ደም ሊለውጡ በሚፈልጉበትም ጊዜ ሁሉ በመቅሠፍት ሁሉ ምድርን ሊመቱ ሥልጣን አላቸው። ");
INSERT INTO amh_vpl VALUES ("RV11_7","096_11_7","REV","11","7","7","ምስክራቸውን ከፈጸሙ በኋላ ከጥልቁ የሚወጣው አውሬ ይዋጋቸዋል ያሸንፋቸውማል ይገድላቸውማል። ");
INSERT INTO amh_vpl VALUES ("RV11_8","096_11_8","REV","11","8","8","በድናቸውም በታላቂቱ ከተማ አደባባይ ይተኛል እርስዋም በመንፈሳዊ ምሳሌ ሰዶምና ግብጽ የተባለች ደግሞ ጌታቸው የተሰቀለባት ናት። ");
INSERT INTO amh_vpl VALUES ("RV11_9","096_11_9","REV","11","9","9","ከወገኖችና ከነገዶችም ከቋንቋዎችም ከአሕዛብም የሆኑ ሰዎች ሦስት ቀን ተኵል በድናቸውን ይመለከታሉ፥ በድናቸውም ወደ መቃብር ሊገባ አይፈቅዱም። ");
INSERT INTO amh_vpl VALUES ("RV11_10","096_11_10","REV","11","10","10","እነዚህም ሁለት ነቢያት በምድር የሚኖሩትን ስለ ሣቀዩ በምድር የሚኖሩት በእነርሱ ላይ ደስ ይላቸዋል በደስታም ይኖራሉ እርስ በርሳቸውም ስጦታ ይሰጣጣሉ። ");
INSERT INTO amh_vpl VALUES ("RV11_11","096_11_11","REV","11","11","11","ከሦስቱ ቀን ተኵልም በኋላ ከእግዚአብሔር የወጣ የሕይወት መንፈስ ገባባቸው በእግሮቻቸውም ቆሙ፥ ታላቅም ፍርሃት በሚመለከቱት ላይ ወደቀባቸው። ");
INSERT INTO amh_vpl VALUES ("RV11_12","096_11_12","REV","11","12","12","በሰማይም። ወደዚህ ውጡ የሚላቸውን ታላቅ ድምፅ ሰሙ፤ ጠላቶቻቸውም እየተመለከቱአቸው ወደ ሰማይ በደመና ወጡ። ");
INSERT INTO amh_vpl VALUES ("RV11_13","096_11_13","REV","11","13","13","በዚያም ሰዓት ታላቅ የምድር መናወጥ ሆነ፥ ከከተማይቱም አሥረኛው እጅ ወደቀ፥ በመናወጥም ሰባት ሺህ ሰዎች ተገደሉ፥ የቀሩትንም ፍርሃት ያዛቸው፥ ለሰማዩም አምላክ ክብር ሰጡ። ");
INSERT INTO amh_vpl VALUES ("RV11_14","096_11_14","REV","11","14","14","ሁለተኛው ወዮ አልፎአል፤ እነሆ፥ ሦስተኛው ወዮ በቶሎ ይመጣል። ");
INSERT INTO amh_vpl VALUES ("RV11_15","096_11_15","REV","11","15","15","ሰባተኛው መልአክ ነፋ፤ በሰማይም። የዓለም መንግሥት ለጌታችንና ለእርሱ ለክርስቶስ ሆነች፥ ለዘላለምም እስከ ዘላለም ይነግሣል ");
INSERT INTO amh_vpl VALUES ("RV11_16","096_11_16","REV","11","16","16","የሚሉ ታላላቅ ድምፆች ሆኑ። በእግዚአብሔርም ፊት በዙፋኖቻቸው የተቀመጡ ሀያ አራቱ ሽማግሌዎች በግምባራቸው ተደፍተው ");
INSERT INTO amh_vpl VALUES ("RV11_17","096_11_17","REV","11","17","17","ለእግዚአብሔር እየሰገዱ እንዲህ አሉ። ያለህና የነበርህ ሁሉን የምትገዛ ጌታ እግዚአብሔር ሆይ፥ ትልቁን ኃይልህን ስለ ያዝህ ስለ ነገሥህም እናመሰግንሃለን፤ ");
INSERT INTO amh_vpl VALUES ("RV11_18","096_11_18","REV","11","18","18","አሕዛብም ተቈጡ፥ ቍጣህም መጣ፥ በሙታንም ትፈርድ ዘንድ ዘመን መጣ፥ ለባሪያዎችህም ለነቢያትና ለቅዱሳን ስምህንም ለሚፈሩት ለታናናሾችና ለታላላቆችም ዋጋቸውን ትሰጥ ዘንድ፥ ምድርንም የሚያጠፉትን ታጠፋ ዘንድ ዘመን መጣ። ");
INSERT INTO amh_vpl VALUES ("RV11_19","096_11_19","REV","11","19","19","በሰማይም ያለው የእግዚአብሔር መቅደስ ተከፈተ፥ የኪዳኑም ታቦት በመቅደሱ ታየ፥ መብረቅና ድምፅም ነጐድጓድም የምድርም መናወጥ ታላቅም በረዶ ሆነ። ");
INSERT INTO amh_vpl VALUES ("RV12_1","096_12_1","REV","12","1","1","ታላቅ ምልክትም በሰማይ ታየ ፀሐይን ተጐናጽፋ ጨረቃ ከእግሮችዋ በታች ያላት በራስዋም ላይ የአሥራ ሁለት ከዋክብት አክሊል የሆነላት አንዲት ሴት ነበረች። ");
INSERT INTO amh_vpl VALUES ("RV12_2","096_12_2","REV","12","2","2","እርስዋም ፀንሳ ነበር፥ ምጥም ተይዛ ልትወልድ ተጭንቃ ጮኸች። ");
INSERT INTO amh_vpl VALUES ("RV12_3","096_12_3","REV","12","3","3","ሌላም ምልክት በሰማይ ታየ፤ እነሆም ታላቅ ቀይ ዘንዶ፤ ሰባት ራሶችና አሥር ቀንዶችም ነበሩት በራሶቹም ላይ ሰባት ዘውዶች ነበሩ፥ ");
INSERT INTO amh_vpl VALUES ("RV12_4","096_12_4","REV","12","4","4","ጅራቱም የሰማይን ከዋክብት ሲሶ እየሳበ ወደ ምድር ጣላቸው። ዘንዶውም ሴቲቱ በወለደች ጊዜ ሕፃንዋን እንዲበላ ልትወልድ ባላት ሴት ፊት ቆመ። ");
INSERT INTO amh_vpl VALUES ("RV12_5","096_12_5","REV","12","5","5","አሕዛብንም ሁሉ በብረት በትር ይገዛቸው ዘንድ ያለውን ልጅ ወንድ ልጅ ወለደች፤ ልጅዋም ወደ እግዚአብሔርና ወደ ዙፋኑ ተነጠቀ። ");
INSERT INTO amh_vpl VALUES ("RV12_6","096_12_6","REV","12","6","6","ሴቲቱም ሺህ ከሁለት መቶ ስድሳ ቀን በዚያ እንዲመግቡአት በእግዚአብሔር ተዘጋጅቶላት ወደ ነበረው ስፍራ ወደ በረሀ ሸሸች። ");
INSERT INTO amh_vpl VALUES ("RV12_7","096_12_7","REV","12","7","9","ዓለሙንም ሁሉ የሚያስተው፥ ዲያብሎስና ሰይጣን የሚባለው ታላቁ ዘንዶ እርሱም የቀደመው እባብ ተጣለ፤ ወደ ምድር ተጣለ መላእክቱም ከእርሱ ጋር ተጣሉ። ");
INSERT INTO amh_vpl VALUES ("RV12_10","096_12_10","REV","12","10","10","ታላቅም ድምፅ በሰማይ ሰማሁ እንዲህ ሲል። አሁን የአምላካችን ማዳንና ኃይል መንግሥትም የክርስቶስም ሥልጣን ሆነ፥ ቀንና ሌሊትም በአምላካችን ፊት የሚከሳቸው የወንድሞቻችን ከሳሽ ተጥሎአልና። ");
INSERT INTO amh_vpl VALUES ("RV12_11","096_12_11","REV","12","11","11","እነርሱም ከበጉ ደም የተነሣ ከምስክራቸውም ቃል የተነሣ ድል ነሡት፥ ነፍሳቸውንም እስከ ሞት ድረስ አልወደዱም። ");
INSERT INTO amh_vpl VALUES ("RV12_12","096_12_12","REV","12","12","12","ስለዚህ፥ ሰማይና በውስጡ የምታድሩ ሆይ፥ ደስ ይበላችሁ፤ ለምድርና ለባሕር ወዮላቸው፥ ዲያብሎስ ጥቂት ዘመን እንዳለው አውቆ በታላቅ ቍጣ ወደ እናንተ ወርዶአልና። ");
INSERT INTO amh_vpl VALUES ("RV12_13","096_12_13","REV","12","13","13","ዘንዶውም ወደ ምድር እንደ ተጣለ ባየ ጊዜ ወንድ ልጅ የወለደችውን ሴት አሳደዳት። ");
INSERT INTO amh_vpl VALUES ("RV12_14","096_12_14","REV","12","14","14","ከእባቡም ፊት ርቃ አንድ ዘመን፥ ዘመናትም፥ የዘመንም እኵሌታ ወደ ምትመገብበት ወደ ስፍራዋ ወደ በረሀ እንድትበር ለሴቲቱ ሁለት የታላቁ ንሥር ክንፎች ተሰጣት። ");
INSERT INTO amh_vpl VALUES ("RV12_15","096_12_15","REV","12","15","15","እባቡም ሴቲቱ በወንዝ እንድትወሰድ ሊያደርግ ወንዝ የሚያህልን ውኃ ከአፉ በስተ ኋላዋ አፈሰሰ። ");
INSERT INTO amh_vpl VALUES ("RV12_16","096_12_16","REV","12","16","16","ምድሪቱም ሴቲቱን ረዳቻት፥ ምድሪቱም አፍዋን ከፍታ ዘንዶው ከአፉ ያፈሰሰውን ወንዝ ዋጠችው። ");
INSERT INTO amh_vpl VALUES ("RV12_17","096_12_17","REV","12","17","17","ዘንዶውም በሴቲቱ ላይ ተቈጥቶ የእግዚአብሔርን ትእዛዛት የሚጠብቁትን የኢየሱስም ምስክር ያላቸውን ከዘርዋ የቀሩትን ሊዋጋ ሄደ፤ በባሕርም አሸዋ ላይ ቆመ። ");
INSERT INTO amh_vpl VALUES ("RV13_1","096_13_1","REV","13","1","1","አንድም አውሬ ከባሕር ሲወጣ አየሁ፤ አሥር ቀንዶችና ሰባት ራሶች ነበሩት፥ በቀንዶቹም ላይ አሥር ዘውዶች በራሶቹም ላይ የስድብ ስም ነበረ። ");
INSERT INTO amh_vpl VALUES ("RV13_2","096_13_2","REV","13","2","2","ያየሁትም አውሬ ነብር ይመስል ነበር፥ እግሮቹም እንደ ድብ እግሮች፥ አፉም እንደ አንበሳ አፍ ነበሩ። ዘንዶውም ኃይሉንና ዙፋኑን ትልቅም ሥልጣን ሰጠው። ");
INSERT INTO amh_vpl VALUES ("RV13_3","096_13_3","REV","13","3","3","ከራሶቹም ለሞት እንደ ታረደ ሆኖ አንዱን አየሁ፥ ለሞቱ የሆነውም ቍስል ተፈወሰ። ምድርም ሁሉ አውሬውን እየተከተለ ተደነቀ፥ ");
INSERT INTO amh_vpl VALUES ("RV13_4","096_13_4","REV","13","4","4","ለዘንዶውም ሰገዱለት፥ ለአውሬው ሥልጣንን ሰጥቶታልና፤ ለአውሬውም። አውሬውን ማን ይመስለዋል፥ እርሱንስ ሊዋጋ ማን ይችላል? እያሉ ሰገዱለት። ");
INSERT INTO amh_vpl VALUES ("RV13_5","096_13_5","REV","13","5","5","ታላቅንም ነገርና ስድብን የሚናገርበት አፍ ተሰጠው፥ በአርባ ሁለት ወርም እንዲሠራ ሥልጣን ተሰጠው። ");
INSERT INTO amh_vpl VALUES ("RV13_6","096_13_6","REV","13","6","6","እግዚአብሔርንም ለመሳደብ ስሙንና ማደሪያውንም በሰማይም የሚያድሩትን ሊሳደብ አፉን ከፈተ። ");
INSERT INTO amh_vpl VALUES ("RV13_7","096_13_7","REV","13","7","7","ቅዱሳንንም ይዋጋ ዘንድ ድልም ያደርጋቸው ዘንድ ተሰጠው፥ በነገድና በወገንም በቋንቋም በሕዝብም ሁሉ ላይ ሥልጣን ተሰጠው። ");
INSERT INTO amh_vpl VALUES ("RV13_8","096_13_8","REV","13","8","8","ከዓለምም ፍጥረት ጀምሮ በታረደው በግ ሕይወት መጽሐፍ ስሞቻቸው ያልተጻፉ በምድር የሚኖሩ ሁሉ ይሰግዱለታል። ");
INSERT INTO amh_vpl VALUES ("RV13_9","096_13_9","REV","13","9","9","ጆሮ ያለው ቢኖር ይስማ። ");
INSERT INTO amh_vpl VALUES ("RV13_10","096_13_10","REV","13","10","10","ይማረክ ዘንድ ያለው ማንም ቢኖር ወደ ምርኮነት ይሄዳል፤ በሰይፍ የሚገድል ማንም ቢኖር ራሱ በሰይፍ እንዲገደል ይገባዋል። የቅዱሳን ትዕግሥትና እምነት በዚህ ነው። ");
INSERT INTO amh_vpl VALUES ("RV13_11","096_13_11","REV","13","11","11","ሌላም አውሬ ከምድር ሲወጣ አየሁ፥ የበግ ቀንዶችን የሚመስሉ ሁለት ቀንዶችም ነበሩት እንደ ዘንዶም ይናገር ነበር። ");
INSERT INTO amh_vpl VALUES ("RV13_12","096_13_12","REV","13","12","12","በፊተኛውም አውሬ ሥልጣን በእርሱ ፊት ሁሉን ያደርጋል። ለሞቱ የሆነውም ቍስል ተፈወሰለት ለፊተኛው አውሬ ምድርና በእርሱ የሚኖሩት እንዲሰግዱለት ያደርጋል። ");
INSERT INTO amh_vpl VALUES ("RV13_13","096_13_13","REV","13","13","13","እሳትንም እንኳ ከሰማይ ወደ ምድር በሰው ፊት እስኪያወርድ ድረስ ታላላቆችን ምልክቶች ያደርጋል። ");
INSERT INTO amh_vpl VALUES ("RV13_14","096_13_14","REV","13","14","14","በአውሬውም ፊት ያደርግ ዘንድ ከተሰጡት ምልክቶች የተነሣ በምድር የሚኖሩትን ያስታል፤ የሰይፍም ቍስል ለነበረውና በሕይወት ለኖረው ለአውሬው ምስልን እንዲያደርጉ በምድር የሚኖሩትን ይናገራል። ");
INSERT INTO amh_vpl VALUES ("RV13_15","096_13_15","REV","13","15","15","የአውሬው ምስል ሊናገር እንኳ ለአውሬውም ምስል የማይሰግዱለትን ሁሉ ሊያስገድላቸው፥ ለአውሬው ምስል ትንፋሽ እንዲሰጠው ተሰጠው። ");
INSERT INTO amh_vpl VALUES ("RV13_16","096_13_16","REV","13","16","16","ታናናሾችና ታላላቆችም ባለ ጠጋዎችና ድሆችም ጌታዎችና ባሪያዎችም ሁሉ በቀኝ እጃቸው ወይም በግምባራቸው ምልክትን እንዲቀበሉ፥ ");
INSERT INTO amh_vpl VALUES ("RV13_17","096_13_17","REV","13","17","17","የአውሬውም ስም ወይም የስሙ ቍጥር ያለው ምልክት የሌለበት ማንም ሊገዛ ወይም ሊሸጥ እንዳይችል ያደርጋል። ጥበብ በዚህ አለ። ");
INSERT INTO amh_vpl VALUES ("RV13_18","096_13_18","REV","13","18","18","አእምሮ ያለው የአውሬውን ቍጥር ይቍጠረው፤ ቍጥሩ የሰው ቍጥር ነውና፥ ቍጥሩም ስድስት መቶ ስድሳ ስድስት ነው። ");
INSERT INTO amh_vpl VALUES ("RV14_1","096_14_1","REV","14","1","1","አየሁም፥ እነሆም፥ በጉ በጽዮን ተራራ ቆሞ ነበር፥ ከእርሱም ጋር ስሙና የአባቱ ስም በግምባራቸው የተጻፈላቸው መቶ አርባ አራት ሺህ ነበሩ። ");
INSERT INTO amh_vpl VALUES ("RV14_2","096_14_2","REV","14","2","2","እንደ ብዙ ውኃም ድምፅና እንደ ታላቅ ነጐድጓድ ድምፅ ያለ ከሰማይ ድምፅን ሰማሁ፥ ደርዳሪዎችም በገና እንደሚደረድሩ ያለ ድምፅ ሰማሁ። ");
INSERT INTO amh_vpl VALUES ("RV14_3","096_14_3","REV","14","3","3","በዙፋኑም ፊት በአራቱም እንስሶችና በሽማግሌዎቹ ፊት አዲስ ቅኔ ዘመሩ፤ ከምድርም ከተዋጁት ከመቶ አርባ አራት ሺህ በቀር ያን ቅኔ ሊማር ለማንም አልተቻለውም። ");
INSERT INTO amh_vpl VALUES ("RV14_4","096_14_4","REV","14","4","4","ከሴቶች ጋር ያልረከሱ እነዚህ ናቸው፥ ድንግሎች ናቸውና። በጉ ወደሚሄድበት የሚከተሉት እነዚህ ናቸው። ለእግዚአብሔርና ለበጉ በኵራት እንዲሆኑ ከሰዎች የተዋጁ እነዚህ ናቸው። ");
INSERT INTO amh_vpl VALUES ("RV14_5","096_14_5","REV","14","5","5","በአፋቸውም ውሸት አልተገኘም፤ ነውር የለባቸውም። ");
INSERT INTO amh_vpl VALUES ("RV14_6","096_14_6","REV","14","6","6","በምድርም ለሚኖሩ ለሕዝብም ለነገድም ለቋንቋም ለወገንም ሁሉ ይሰብክ ዘንድ የዘላለም ወንጌል ያለው ሌላ መልአክ ከሰማይ መካከል ሲበር አየሁ፤ ");
INSERT INTO amh_vpl VALUES ("RV14_7","096_14_7","REV","14","7","7","በታላቅ ድምፅም። የፍርዱ ሰዓት ደርሶአልና እግዚአብሔርን ፍሩ ክብርንም ስጡት፤ ሰማይንና ምድርንም ባሕርንም የውኃንም ምንጮች ለሠራው ስገዱለት አለ። ");
INSERT INTO amh_vpl VALUES ("RV14_8","096_14_8","REV","14","8","8","ሌላም ሁለተኛ መልአክ። አሕዛብን ሁሉ የዝሙትዋን ቍጣ ወይን ጠጅ ያጠጣች ታላቂቱ ባቢሎን ወደቀች፥ ወደቀች እያለ ተከተለው። ");
INSERT INTO amh_vpl VALUES ("RV14_9","096_14_9","REV","14","9","9","ሦስተኛም መልአክ ተከተላቸው፥ በታላቅ ድምፅ እንዲህ እያለ። ለአውሬውና ለምስሉ የሚሰግድ በግምባሩም ወይም በእጁ ምልክቱን የሚቀበል ማንም ቢኖር፥ ");
INSERT INTO amh_vpl VALUES ("RV14_10","096_14_10","REV","14","10","10","እርሱ ደግሞ በቍጣው ጽዋ ሳይቀላቅል ከተዘጋጀው ከእግዚአብሔር ቍጣ ወይን ጠጅ ይጠጣል፥ በቅዱሳንም መላእክትና በበጉ ፊት በእሳትና በዲን ይሳቀያል። ");
INSERT INTO amh_vpl VALUES ("RV14_11","096_14_11","REV","14","11","11","የሥቃያቸውም ጢስ ለዘላለም እስከ ዘላለም ድረስ ይወጣል፥ ለአውሬውና ለምስሉም የሚሰግዱ የስሙንም ምልክት የሚቀበል ሁሉ ቀንና ሌሊት ዕረፍት የላቸውም። ");
INSERT INTO amh_vpl VALUES ("RV14_12","096_14_12","REV","14","12","12","የእግዚአብሔርን ትእዛዛት የሚጠብቁት ኢየሱስንም በማመን የሚጸኑት ቅዱሳን ትዕግሥታቸው በዚህ ነው። ");
INSERT INTO amh_vpl VALUES ("RV14_13","096_14_13","REV","14","13","13","ከሰማይም። ከእንግዲህ ወዲህ በጌታ የሚሞቱ ሙታን ብፁዓን ናቸው። መንፈስ። አዎን፥ ከድካማቸው ያርፉ ዘንድ፥ ሥራቸውም ይከተላቸዋል ይላል ብለህ ጻፍ የሚል ድምፅ ሰማሁ። ");
INSERT INTO amh_vpl VALUES ("RV14_14","096_14_14","REV","14","14","14","አየሁም፥ እነሆም ነጭ ደመና፥ በደመናውም ላይ የሰውን ልጅ የሚመስል ተቀምጦአል፥ በራሱም ላይ የወርቅ አክሊል በእጁም ስለታም ማጭድ ነበረው። ");
INSERT INTO amh_vpl VALUES ("RV14_15","096_14_15","REV","14","15","15","ሌላ መልአክም ከመቅደሱ ወጥቶ በደመናው ላይ ለተቀመጠው። የማጨድ ሰዓት ስለ ደረሰ ማጭድህን ስደድና እጨድ፥ የምድሪቱ መከር ጠውልጓልና ብሎ በታላቅ ድምፅ ጮኸ። ");
INSERT INTO amh_vpl VALUES ("RV14_16","096_14_16","REV","14","16","16","በደመናውም ላይ የተቀመጠው ማጭዱን ወደ ምድር ጣለው ምድርም ታጨደች። ");
INSERT INTO amh_vpl VALUES ("RV14_17","096_14_17","REV","14","17","17","ሌላ መልአክም በሰማይ ካለው መቅደስ ወጣ፥ እርሱም ደግሞ ስለታም ማጭድ ነበረው። ");
INSERT INTO amh_vpl VALUES ("RV14_18","096_14_18","REV","14","18","18","በእሳትም ላይ ሥልጣን ያለው ሌላ መልአክ ከመሠዊያው ወጥቶ ስለታም ማጭድ ያለውን። ዘለላዎቹ ፈጽመው በስለዋልና ስለታሙን ማጭድህን ስደድና በምድር ያለውን የወይን ዛፍ ዘለላዎች ቍረጥ ብሎ በታላቅ ድምፅ ጠራ። ");
INSERT INTO amh_vpl VALUES ("RV14_19","096_14_19","REV","14","19","19","መልአኩም ማጭዱን ወደ ምድር ጣለው፥ በምድርም ካለው ከወይን ዛፍ ቈርጦ ወደ ታላቁ ወደ እግዚአብሔር ቍጣ መጥመቂያ ጣለ። ");
INSERT INTO amh_vpl VALUES ("RV14_20","096_14_20","REV","14","20","20","የወይኑም መጥመቂያ ከከተማ ውጭ ተረገጠ፥ እስከ ፈረሶች ልጓምም የሚደርስ ደም ርቀቱ ሺህ ስድስት መቶ ምዕራፍ ሆኖ ከመጥመቂያው ወጣ። ");
INSERT INTO amh_vpl VALUES ("RV15_1","096_15_1","REV","15","1","1","ሌላም ታላቅና ድንቅ ምልክት በሰማይ አየሁ፤ የእግዚአብሔር ቍጣ በእነርሱ ስለሚፈጸም ኋለኛዎቹን ሰባት መቅሠፍቶች የያዙ ሰባት መላእክት ታዩ። ");
INSERT INTO amh_vpl VALUES ("RV15_2","096_15_2","REV","15","2","2","በእሳትም የተቀላቀለውን የብርጭቆ ባሕር የሚመስለውን አየሁ፥ በአውሬውና በምስሉም በስሙም ቍጥር ላይ ድል ነሥተው የነበሩት የእግዚአብሔርን በገና ይዘው በብርጭቆ ባሕር ላይ ሲቆሙ አየሁ። ");
INSERT INTO amh_vpl VALUES ("RV15_3","096_15_3","REV","15","3","5","ከዚህም በኋላ አየሁ፥ የምስክርም ድንኳን መቅደስ በሰማይ ተከፈተ፥ ");
INSERT INTO amh_vpl VALUES ("RV15_6","096_15_6","REV","15","6","6","ሰባቱንም መቅሠፍት የያዙ ሰባቱ መላእክት ከመቅደሱ ወጡ፤ ከተልባ እግርም የተሠራ ጥሩ የጌጥ ልብስ ለበሱ ደረታቸውንም በወርቅ መታጠቂያ ታጠቁ። ");
INSERT INTO amh_vpl VALUES ("RV15_7","096_15_7","REV","15","7","7","ከአራቱም እንስሶች አንዱ ከዘላለም እስከ ዘላለም ድረስ የሚኖር የእግዚአሔር ቍጣ የሞላባቸውን ሰባት የወርቅ ጽዋዎች ለሰባቱ መላእክት ሰጣቸው። ");
INSERT INTO amh_vpl VALUES ("RV15_8","096_15_8","REV","15","8","8","ከእግዚአብሔርም ክብርና ከኃይሉ ጢስ በመቅደሱ ሞላበት፥ የሰባቱ መላእክት ሰባቱ መቅሰፍት እስኪፈጸሙ ድረስ አንድ እንኳ ወደ መቅደሱ ይገባ ዘንድ አልቻለም። ");
INSERT INTO amh_vpl VALUES ("RV16_1","096_16_1","REV","16","1","1","ለሰባቱም መላእክት። ሄዳችሁ የእግዚአብሔርን ቁጣ ጽዋዎች በምድር ውስጥ አፍስሱ የሚል ታላቅ ድምፅ ከመቅደሱ ሰማሁ። ");
INSERT INTO amh_vpl VALUES ("RV16_2","096_16_2","REV","16","2","2","ፊተኛውም ሄዶ ጽዋውን በምድር ውስጥ አፈሰሰ፤ የአውሬውም ምልክት ባለባቸው ለምስሉም በሚሰግዱ ሰዎች ክፉኛ የሚነዘንዝ ቍስል ሆነባቸው። ");
INSERT INTO amh_vpl VALUES ("RV16_3","096_16_3","REV","16","3","3","ሁለተኛውም ጽዋውን በባሕር ውስጥ አፈሰሰ፤ እንደ ሞተም ሰው ደም ሆነ፥ በባሕርም ከሚኖሩት ሕይወት ያለበት ነፍስ ሁሉ ሞተ። ");
INSERT INTO amh_vpl VALUES ("RV16_4","096_16_4","REV","16","4","4","ሦስተኛውም ጽዋውን በወንዞችና በውኃ ምንጮች ውስጥ አፈሰሰ፤ እነርሱም ደም ሆኑ። ");
INSERT INTO amh_vpl VALUES ("RV16_5","096_16_5","REV","16","5","5","የውኃውም መልአክ። ያለህና የነበርህ ጌታ ሆይ፥ ቅዱስ ሆይ፥ እንዲህ ስለፈረድህ ጻድቅ ነህ፤ ");
INSERT INTO amh_vpl VALUES ("RV16_6","096_16_6","REV","16","6","6","የቅዱሳንና የነቢያትን ደም ስላፈሰሱ ደምን ደግሞ አጠጥተሃቸዋል፥ የሚገባቸው ነውና ብሎ ሲናገር ሰማሁ። ");
INSERT INTO amh_vpl VALUES ("RV16_7","096_16_7","REV","16","7","7","ከመሰዊያውም። አዎን፥ ሁሉን የምትገዛ ጌታ አምላክ ሆይ፥ ፍርዶችህ እውነትና ጽድቅ ናቸው ብሎ ሲናገር ሰማሁ። ");
INSERT INTO amh_vpl VALUES ("RV16_8","096_16_8","REV","16","8","8","አራተኛውም ጽዋውን በፀሐይ ላይ አፈሰሰ፤ ሰዎችንም በእሳት ልታቃጥል ተሰጣት። ");
INSERT INTO amh_vpl VALUES ("RV16_9","096_16_9","REV","16","9","9","ሰዎችም በታላቅ ትኵሳት ተቃጠሉ፥ በነዚህም መቅሠፍቶች ላይ ሥልጣን ያለውን የእግዚአብሔርን ስም ተሳደቡ፥ ክብርንም እንዲሰጡት ንስሐ አልገቡም። ");
INSERT INTO amh_vpl VALUES ("RV16_10","096_16_10","REV","16","10","10","አምስተኛውም ጽዋውን በአውሬው ዙፋን ላይ አፈሰሰ፤ መንግሥቱም ጨለማ ሆነች ከስቃይም የተነሳ መላሶቻቸውን ያኝኩ ነበር፥ ");
INSERT INTO amh_vpl VALUES ("RV16_11","096_16_11","REV","16","11","11","ከስቃያቸውና ከቍስላቸውም የተነሳ የሰማይን