﻿USE sofia;
DROP TABLE IF EXISTS sofia.amf_vpl;
CREATE TABLE amf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES amf_vpl WRITE;
INSERT INTO amf_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Abraambee Dawtbesa muldhara nivaa Barjoyn qadhaa Kiristoos Yesussa adhadhin goyno yinne: ");
INSERT INTO amf_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraam Yisaaqam ki adhade; Yisaaqaar Yayqoobam ki adhade; Yayqoobaar Yiwdabee kisa indanaanabeam ki adhade. ");
INSERT INTO amf_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yiwdaar Tivimaarka Paareesbee Zaarahibeam ki adhade; Paareesaar Hethroonam ki adhade; Hethroonaar Raamam ki adhade. ");
INSERT INTO amf_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Raamaar Aminaadaabam ki adhade; Aminaadaabaar Navasoonam ki adhade; Navasoonaar Selimoonam ki adhade. ");
INSERT INTO amf_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Selimoonaar Revaabka Boveezam ki adhade; Boveezaar Uruteka Iyobeedam ki adhade; Iyobeedaar Iseyam ki adhade. ");
INSERT INTO amf_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Iseyaar Bitaa Dawtam ki adhade. Dawt Oriyon geshonka Solomoonam ki adhade. ");
INSERT INTO amf_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoonaar Roobiamam ki adhade; Roobiamaar Abiyaam ki adhade; Abiyaar Asaam ki adhade. ");
INSERT INTO amf_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaar Iyosaapitham ki adhade; Iyosaapithaar Iyoramam ki adhade; Iyoramaar Oozianam ki adhade. ");
INSERT INTO amf_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oozianaar Iyovatamam ki adhade; Iyovatamaar Akaazam ki adhade; Akaazaar Yizqiasam ki adhade. ");
INSERT INTO amf_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Yizqiasaar Minaseam ki adhade; Minasear Amoonam ki adhade; Amoonaar Iyosiyasam ki adhade. ");
INSERT INTO amf_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Iyosiyasaar Israveel eenaam Baabiloon peendar uxate yiidhon wodanka, Yovakinbee kisa indanaanabeam ki adhade. ");
INSERT INTO amf_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Yovakinaar Israveel eenaam Baabiloon peendar uxate yiidhonsa budonte, Selatialam ki adhade; Selatialaar Zerubaabeelam ki adhade. ");
INSERT INTO amf_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubaabeelaar Abiyoodam ki adhade; Abiyoodaar Eliyaqemam ki adhade; Eliyaqemaar Azooram ki adhade. ");
INSERT INTO amf_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azooraar Sadoqam ki adhade; Sadoqaar Akimam ki adhade; Akimaar Eliyodam ki adhade. ");
INSERT INTO amf_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyodaar Alaazaram ki adhade; Alaazaraar Mataanam ki adhade; Mataanaar Yayqoobam ki adhade. ");
INSERT INTO amf_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yayqoobaar Yoseepam ki adhade. Yoseepaar Barjoyn qadhaa Kiristoos hambhea Yesusam adhon Mayriyamsa geshoane. ");
INSERT INTO amf_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ogonante Yesussa muldhano Abraamdara yedayse Dawtka yekka, tabhi oydi adhadhi ko maatade. Pir Dawtdara yedayse Israveel eenin Baabiloon peendar uxate yiidhonka yekka, tabhi oydi adhadhi ko maatade. Ogoraar Israveel eenaam Baabiloon peendar uxate kenin tiidhondara yedayse Kiristoossa adhadhinka yekka, tabhi oydi adhadhi ko maatade. ");
INSERT INTO amf_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesus Kiristoossa adhadhino yinne: Indan Mayriyamam Yoseep kinin seesonsa budonte, kinka kiam ke keemima, kodi Manpas Gazanka sirmayse ko haapadhade. ");
INSERT INTO amf_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Koam seesaa Yoseepaar eedi tipa kinin dohonna, ‘‘Een birante koam inin ooshinserra aachika koam ida gare’’ hamayse ki qaabade. ");
INSERT INTO amf_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kidiar ogoam qaabite ki daaka, Barjosa gaana haamaka haapadhayse, ‘‘Ya Dawt muldhara adhadhaa Yoseep, Mayriyamsa sirmidino Manpas Gazankane; eedi koam sirsade hamayse hanin keemenam kurtumbhaabhode. ");
INSERT INTO amf_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kodiar naasi anngi koda adhe. Adhadhea naasaar yisa eenaam seesora kinin dhacchenna, naabenam kisa Yesus hamayse hada wode’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","‘‘Marrato! Naano dinngillo sirma ko sirme; naasi anngiar adha ko adhe; kisa naabenamaar Amaanuveel hamayse koda wodadhe’’ hamayse Barjokala qansayse eenna giyeaka Barjo Imbaayn giyoono konin thoothoadettsi ogono wul yin ko maatade. Ogonoar Amaanuveel hamintano ‘‘Barjo wombetene’’ hamintane. ");
INSERT INTO amf_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yoseepaar raatira dhaabhayse Barjosa gaana kinin giyondettsi Mayriyamam ki keemade. ");
INSERT INTO amf_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Keemayse naasaam konin adhenka yekka Yoseep konka wodhadehe. Yoseepaar naasasa naabenam Yesus hamayse ki wodade. ");
INSERT INTO amf_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bitaa Herodis bitimayse kinin dohon wodanka, Yesus Yiwda peen Betelem katamante kinin adhadhonsa budonte yin ko maatade: Marrato! Eezinin shedayse os birante hamota dohon yerinaam dhesayna eena haynsa utambarka Yerusaalem katamandar ke nivade. ");
INSERT INTO amf_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","‘‘Ayiwd eenasa bitaa adhadhaa hamote ki dahaa? Kinin adhadhonam eshkea eeziniam haynsa utambar haapayse kina goodimota wo nivade’’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kenin giyenam Bitaa Herodis qansayse ki targadhade; Yerusaalemir dohoono eenoar kimbesana kinka kurtumbhayse ko targadhade. ");
INSERT INTO amf_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ogonante Bitaa Herodis gudullasa hayonabee Musesa yigginam dhettsayna eenabe wulam buskayse, ‘‘Barjoyn qadhaa Kiristoos hambhea kinin adhadhayno ranqo hamotene?’’ hamayse keam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Kediar yin giyayse kina ke maasade: ‘‘Kiristoosin adhadhayno Yiwda peen Betelem katamantene. Harrna hambhidianna, ena Barjokala qansayse eenna giyea kinin giyaadettsi: ");
INSERT INTO amf_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Yiwda peente dohoono ya Betelemo, hamin ko dahaannaar katamanakalanka ya tokattane. Israveel zarsin innonam toolea entsea ea hakalanka kida ute’ hamayse konin thaapadhonnane’’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ogora Bitaa Herodisaar igina eena eezinin shedayse dhesaynaam aachika yikal eelayse, ‘‘Eeziniam haa ye haapaa?’’ hamayse agaa wodaam kekal payya hayayse oysate ki dhesade. ");
INSERT INTO amf_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Rooroam yinin dhesonsa budonte, ‘‘Keeda yedi Betelem katamandar yivee’’ hamayse keam ki yittsade. Yinin yittsenkaar, ‘‘Yedi yivayse adhadhaa naasaam payya oysayse zagee. Yenin haapon wodanka ina nivayse giyee. Intaar yivayse kina goodimayda goodime’’ hamayse kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kediar bitaakala ogoam qansayse Betelemdar yivo ke dhaabhade. Kenin yivenka haynsa utambar kenin haapaa eezinia naasayn dohon raqindar nivayse kinin woyenka yekka keam entsite ki dahade. ");
INSERT INTO amf_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Eeziniam kenin haapon wodanka, kattsi ke wozadhade. ");
INSERT INTO amf_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Oonintear ardayse naasabee indan Mayriyambeam ke haapade. Kumpurdhaysear kina ke goodimade. Ogora kenin bovon koymonam bulayse worqibee, qunyabee, kerbe hambhen gaamen shittonbeam iminto kina ke imade. ");
INSERT INTO amf_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ogora kenin maatenka, Bitaa Herodisdar kenin yivoamadettsi Barjo haamaka kena kinin giyonna, goyti abka yisa peendar maatate ke yivade. ");
INSERT INTO amf_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Eezinin shedayna kenin yivonsa budonte, Barjosa gaana Yoseepkal haamaka haapadhayse, ‘‘Yoseep, dhaabhaa! Bitaa Herodis naasaam deesana kida zage. Ogonante ya naasabee indanbeam bavate Gibth peendar saana yivaa. Maatayse hanin nivoadettsi inin hana giyenka yekka ogote dahaa’’ hamayse kina ki giyade. ");
INSERT INTO amf_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ogonante Yoseep sootinka dhaabhayse naasabee indanbeam bavate Gibth peendar ki yivade. ");
INSERT INTO amf_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Kediar Bitaa Herodisin diyenka yekka Gibth peente ke dahade. Ogonoar ena Barjokala qansayse eenna giyea ea aponka Barjo Imbaa yi giyna: ‘‘Isa naasaam Gibthra i eelade’’ kinin hamoono upsino konin thoothoadettsi yin ko maatade. ");
INSERT INTO amf_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ogo wodanka Bitaa Herodisaar igina eezinin shedayse os birante hamota dohon yerinaam dhesayna kikal nivima kenin yivonam dhesayse, ‘‘Harrna ke iam taysaa?’’ hamayse kattsi ki wacimade. Ogonante poolisana yinnaam Betelem katamanbee kosa gasante dohon peenbedar yittsayse, leve lamaabee leve lamaasa choobarbe dahaana naana anngina wulam ki dettsade. Ogonoar eezinin shedayse dhesaynakala eeziniayn kena haapadhon wodanam oysate kinin qansonnane. ");
INSERT INTO amf_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Ogonoar ‘‘Raama peente eepibee gebhi ilatbe ko qansimade. Raaheel kosa naana diyate kenin maqonna, yisa naanana ko eepade. Eenin koam wocchinsenka darshana damadehe’’ hamayse ena Barjokala qansayse eenna giyea Ermeasin giyondettsi ko thoothade. ");
INSERT INTO amf_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ogoraar Bitaa Herodis kinin diyonsa budonte, Barjosa gaana Gibth peente Yoseepkal haamaka haapadhayse, ");
INSERT INTO amf_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","‘‘Shedaa! Naasaam deesota zagayna eena diydine. Keeda ya naasabee indanbeam hanka bavate Israveel peendar yivaa’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ogonante Yoseep naasabee indanbeam bavate Israveel peendar maatate ki nivade. ");
INSERT INTO amf_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ogo wodanka Bitaa Herodissa naasa Arkeloos imbaa raqaate Yiwda peendar kinin bitimonam qansayse Yoseep ‘‘Yiwda peendar keeda yivattine’’ hamayse ki kurtumbhade. Ogoraar kina haamaka konin giidhonna, Galila peendar ki yivade. ");
INSERT INTO amf_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galila peen yeskayse Naazret katamante dooqayse peen ogo eedi ki maatade. Ogonoar ‘‘ ’Naazret peen ea’ hamayse kiam koda eldhe’’ hamayse ena Barjokala qansayse eenna giyaynasa aponka Barjoyn qadhaa Kiristoos goynsa giidhoono ko thoothade. ");
INSERT INTO amf_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","Ogo wodanka Shivea Wannisar, ‘‘Marrato! Barjoyn bitimayno wodano yeskidine. Ogonante seeson waadimanam garayse Barjodar maatee’’ hamaate Barjosa upsinam giyada Yiwda darandar ki yivade. ");
INSERT INTO amf_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ogonoar ‘‘ ’Marrato! Barjoyn yekal nivenna, yesa woylaminam ashkee; goynamaar kina gaz hayee’ hamayse ilatea easa upsino darante koda qansime’’ hamayse Barjokala qansayse eenna giyea Isiasin giyoono Wannis goynsane. ");
INSERT INTO amf_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Wannissa apallo gamalesa sitika ashkadhoonone; yisa karnantear qalbatha kida dhaxe. Kinin itsaynoar seerebee qoa kuribene. ");
INSERT INTO amf_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ogo wodanka Yerusaalem katamanbee, Yiwda peen wulbee, Yordaanoos baynsa gasante dohon peen wulbera eeno Wanniskal nivite ko dahade. ");
INSERT INTO amf_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nivayse yisa seesonam kenin buuthenka, Wannis Yordaanoos baynte keam kida shive. ");
INSERT INTO amf_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ko dahaannaar Parisa eenabee Saduqa eenabera thoothino eeno Wanniskal shiidhana konin nivenka Wannis koam shedayse, ‘‘Yedi qarshi naanato, niven Barjosa wacimera gobayse yenin dhaqoadettsi yeam kiilaa hayne? ");
INSERT INTO amf_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ta keeda seeson waadimanam garayse Barjodar yenin maatonam dhehen payyan waadimanam waadadhee. ");
INSERT INTO amf_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yesa woylaminkaar, ‘Wodi Abraam naasine’ hamayse erimeebhode. Yena ida giye: Barjo yi zaganna kina sennara Abraamna naasi hayayse dhaasana dama ki dame. ");
INSERT INTO amf_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ta haaqanaam taxate dhabayno tesimbho demente kesa wodadhidine. Ogonante payyan aapin ushimina haaqana wulam taxate nuunte koda dhabadhe. ");
INSERT INTO amf_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Keeda seeson waadimanam garayse Barjodar yenin maatoono may konin maatoadettsi inta noqoka yeam ida shive; ko dahaannaar isa budonte nivea kidi Manpas Gazanbee nuubeka yeam kida shive. Kidiar idara kantanka sageane. Inta kisa roonsa dunngurin hattear baskana damattine. ");
INSERT INTO amf_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Gazgonam qanayse puqulara aapinam kinin bulea anngamo kisa aaninte ko dahade; aapinam payya ashkayse kononte kida kee; puqulanamaar dikimon nuunte kida koqe’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ogo wodanka Yesus Wannis kiam kinin shivoadettsi Galila peera dhaabhayse Yordaanoos bayndar ki nivade. ");
INSERT INTO amf_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Wannisaar, ‘‘Iam ha shive koda zaske; haam i shive ya idar haminaa nivaa?’’ hante kiam marana ki dhaabhade. ");
INSERT INTO amf_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesusaar kina yinin maasenka, ‘‘Yer wulka tipa waadima woam konin zaskenna, ta iam ya shivaa’’ ki hamade. Ogonante Wannis ee hamayse kiam ki shivade. ");
INSERT INTO amf_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesusaar yinin shiidhadhonsa budonte, saanawa noqora ki utade. Ogo wodanka cecino ko bulimade; Barjosa Manpasinoar waleedettsi hanchayse Yesusdar konin dooqen Wannis ki haapade. ");
INSERT INTO amf_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tapir, ‘‘Inin nashea isa Naasa kaane; inta kanka ida wozadhe’’ hamea upsi cecira ko qansimade. ");
INSERT INTO amf_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ogosa budonte Seethaanin kiam taysate shedoadettsi Yesusam Manpas Gazano darandar ko entsade. ");
INSERT INTO amf_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ogo darante Yesus eedi lamaa kaysa roorobee sootibe itsima yinin qoomonsa budonte, ki daaqardhade. ");
INSERT INTO amf_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ogo wodanka taysate shedea Seethaanaar Yesuskal theedayse, ‘‘Ya Barjo Naas ha daana, senna kinana ‘Balasha maatee’ hamaa’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesusaar kina yinin maasenka, ‘‘ ’Eedinin dahayno Barjoyn giyen upsin wulkane; balasha itsayse bish dehehe’ hamayse thaapadhidine’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ogora pir Seethaan Yesusam yinka entsate yivayse gazan kataman Yerusaalemir dohon Barjosa gazan ooninsa illindar bulate woysayse, ");
INSERT INTO amf_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","yin ki giyade: ‘‘ ’Haam kenin tooloadettsi Barjo yisa gaananana giya ki giye. Kediar roon hannonam seenin qanoamadettsi yisa aaninka keedhayse haam yeda ke yede’ hamayse thaapadhidine. Keeda ya Barjo Naasi hanna, kora mia bhulate hanchaa!’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesusaar kina ‘‘Pir, ‘Hasa Imbaa Barjoam taysate shedaabhode!’ hamayse thaapadhidine’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ogora pir Seethaan Yesusam dhukan gudubhondar yinka entsate utayse, peendar dohon bitamon wulbee kesa gobshinbeam kina dhahayse, ");
INSERT INTO amf_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","‘‘Kumpurdhayse ina ha goodimidianna, ko wulam hana imayda ime’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ogo wodanka Yesus ‘‘Ya Seethaan, ikalanka pegimbhaa! ‘Hasa Imbaa Barjona kumpurdhayse kibisheana goodimaa!’ hamayse thaapadhidine’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ogo wodanka Seethaan Yesusam garayse kinin yivenka Barjosa gaananaar nivayse kina keda waadadhe. ");
INSERT INTO amf_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesus Wannisin yedate dhaxadhonam yinin qanson wodanka Galila peendar ki yivade. ");
INSERT INTO amf_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pir Naazret katamanam garayse Zaabloonbee Niptaaleembe peensa gasan bazinsa aponte dohon Qipirnaahoom katamante yivayse ki dooqade. ");
INSERT INTO amf_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","16","Yin konin dohoono ‘‘Bazindar yiven goyndar Yordaanoos baynsa saabar haapadhayno Ayiwdtaymina eenanin thoothon Galila peente, thipante dahaana Zaabloonbee Niptaaleembe eenana shaakano gembho ko shaakade. Dembhin shiponin shipshon peente dahaana kena shaakano ko shaakade’’ hamayse Barjokala qansayse eenna giyea Isias aponka giidhoono konin thoothoadettsi ko maatade. ");
INSERT INTO amf_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Rooroa agaara yedayse Yesus ‘‘Barjosa bitamono yekal theedidine; ogonante seeson waadimanam garayse Barjodar maatee’’ hamada giyan ki yedade. ");
INSERT INTO amf_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesus Galila bazinsa aponka kinin yivenka, Bhethiroos hambhea Simoonbee kisa indanaasa Indiriasbeam ki haapade; kediar kaaran yedayna yinin dohonna, yisa kaaran yeden zaaninam bazindar apite ke dahade. ");
INSERT INTO amf_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesusaar, ‘‘Marrato! Yedi dhaabhayse isa paanan nivee. Kaaran yenin yedendettsi Barjosa bitamondar eenaam yenin maasoadettsi yeam ida haye’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kediar kaaran yininkay yeden zaaninam saanawa garayse Yesussa paanan yivan ke yedade. ");
INSERT INTO amf_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ogora os mak kinin hamenka, pir indanaas lamaa waaniam ki haapade. Kediar Zabdoos naana Yayqoobbee Wannisbene. Naana iginaar imbaa Zabdoosbesana kinka bazindara sagadhen gonngalante dooqayse kaaran yininkay yeden zaaninam keda ashke. Yesusaar keam ki eelade. ");
INSERT INTO amf_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kediar saanawa bazindara sagadhen gonngalanbee imbaa kenteabeam garayse Yesussa paanan yivan ke yedade. ");
INSERT INTO amf_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ogora Yesus Ayiwd eensa bukin raqinte dhettsada, Barjo bitamonsa dhacchintan upsinam giyada, eenaam yedon waana waana hamon burqon wulamaar pacchada Galila peen wulir yaayte ki dahade. ");
INSERT INTO amf_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yesusin waadadhonbee giyonbe Sooria peente dohon een wulna ko qansimade. Eenoar waana waana hamon burqonka hajadhon een wulam Yesuskal bavate ko nivade. Hajadhon eensa iintear beeronaka yedadhaanabee, ruminin dhabaynabee, maqasinka malgimayse wobaanabe ke daaka, Yesus igina eenaam kesa hajimora ki pacchade. ");
INSERT INTO amf_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galila peenbee, Tabhi Katamana hambhen peenbee, Yerusaalem katamanbee, Yiwda peenbee, Yordaanoos baynsa saabar dohon peenbera nivoono thoothino eeno Yesussa paanan ko yivade. ");
INSERT INTO amf_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesusaar eensa thoothamonam shedayse dhukandar utayse ki dooqade. Kisa paanan yivayno eenoar kikal theedi konin nivenka, ");
INSERT INTO amf_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","yin giyayse keam dhettsan ki yedade: ");
INSERT INTO amf_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","‘‘Barjosa Manpasinka ‘Inta kantaysa qolmaane’ hamayse meten yinnonam toskayna Barjosa bitamono kenti konin dohonna, kedi ke wozadhe. ");
INSERT INTO amf_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Woylaminka yisa qaabayse burqadhayna Barjoyn keam wocchinsenna, kedi ke wozadhe. ");
INSERT INTO amf_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Lemmakkoka meten yinnonam toskayna peenam kenin tiyenna, kedi ke wozadhe. ");
INSERT INTO amf_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Tipa haydhenam daaqardhaynabee dheebardhaynabe kenin mishenna, kedi ke wozadhe. ");
INSERT INTO amf_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Eedina burqadhaynana Barjoyn kena kinin burqadhenna, kedi ke wozadhe. ");
INSERT INTO amf_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Barjo birante woylaminsa payyana Barjoam kenin haapenna, kedi ke wozadhe. ");
INSERT INTO amf_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kinka gemmaanaam qaashinsayna ‘Barjo naanane’ keam hambhenna, kedi ke wozadhe. ");
INSERT INTO amf_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Tipan waadimanna hamayse oytaydhayna Barjosa bitamono kenti konin dohonna, kedi ke wozadhe. ");
INSERT INTO amf_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","‘‘Ina hamayse eenin yeam iirenkabee, oytayenkabee, yerin siyon wulam buudamoka yedar kenin giyenkabe wozadhee. ");
INSERT INTO amf_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yena kashadhayno bazano cecinte gebhi konin dohonna wozadhee. Yesa birayse Barjokala qansayse eenna giyaynaam ogodettsi keam oytaydhidine. ");
INSERT INTO amf_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","‘‘Yedi peendar dohon eenna sooqone. Sooqo daathan garidi ko hanna, harka ko daathisadhe? Mayante koam bulate laldhaysaka eedin koam rooka tigera ab konka haydhea yer qolehe. ");
INSERT INTO amf_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","‘‘Yedi peendar dohon eenna shaakane. Dhukandar dahaa katama aachimana dandimehe. ");
INSERT INTO amf_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Shaakanam shashkayse yer daran guupea eedi qolehe. Ooninte dahaana wulna konin shaakoadettsi, dheg hamon raqindar ko wodadhe. ");
INSERT INTO amf_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ogodettsi yesa payyan waadimanam shedayse cecinte dahaa Imbaa yenteam eeno konin gobshoadettsi, yesa shaakano eensa birante ko shaake. ");
INSERT INTO amf_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","‘‘Inta Musesa yigginbee Barjokala qansayse eenna giyaynasa upsinbeam thoosana i nivade; koam shiishana inin nivaa yena ko maatabhoode. ");
INSERT INTO amf_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Inta yena gon ida giye: Cecinbee peenbe sagenka yekka wul thootha ko thoothe; Muse yigginsa pidal way zaaka kala hattear shidhehe. ");
INSERT INTO amf_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ogona kina giidhaanasa iira tokaa maataa kalaam kottseabee waani eenin kottsoadettsi dhettseabe eedi hay ki hannaar, Barjosa bitamonte een wulsa choobar kida dee. Barjoyn giyon wulam waadadheabee waani eenin waadadhoadettsi dhettseabe eedi hay ki hannaar, kidi Barjosa bitamonte gebhi kida hambhe. ");
INSERT INTO amf_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Inta yena ida giye: Yenno tipamono Musesa yigginam dhettsaynabee Parisa eenabesa tipamora ko sagaamma, Barjosa bitamon raqindar hamin ko dahaakaar ardattene. ");
INSERT INTO amf_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","‘‘Ena wodanka dahaana eenana, ‘Deesaabhode’ pir, ‘Deesea wuldar pirdi koda zaske’ hambhonam yedi qansidine. ");
INSERT INTO amf_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Inta yena ida giye: Aananta yinteadar wacimea wuldar dhabsha ko dhabshadhe. Aananta yinteam ‘Ya kaa pootimaa!’ hamayse iirea wuldar peensa donzanaka pirda ko pirdadhe. ‘Ya kaa dembhea!’ hamayse giyea wuldar lay dikimon nuun pirdino kiam koda toole. ");
INSERT INTO amf_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","‘‘Ogonante Barjona hanin imen imintonam marshan machadhen raqindar hanin thettsen wodanka, aananta hantea woylamka hadar yer kinin atea hana bhoqidianna, ");
INSERT INTO amf_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","hasa imintonam marshan machadhen raqinte garayse birayse ha aanantakal yivayse kimbesana qaashimaa. Ogora maatayse Barjona hasa imintonam imaa. ");
INSERT INTO amf_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","‘‘Hambesana wacimaa ea haam ki bersaysaka, kimbesana kinka pirdin oonindar yenin yivenka, goynte dahayse kimbesana kinka qaashimaa. Yin ha hayaamma, hambesana wacimaa ea haam pirdin pirdea eana saskate kida ime. Pirdin pirdea ear haam poolisana saskate kida ime; yaar dhaxin ooninte hada arde. ");
INSERT INTO amf_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Inta hana gon ida giye: Hanka kashaa hambhon wulam hanin kashate macchenka yekka dhaxin oonira hamin ko dahaakaar utattane. ");
INSERT INTO amf_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","‘‘ ’Sharmucimaabhode’ hambhonam yedi qansidine. ");
INSERT INTO amf_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Inta yena ida giye: Maam shedayse anngardhea wul ogo wodanka yisa woylaminka kombesana sharmucimidine. ");
INSERT INTO amf_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mizaqa aapea hantea haam seesondar arsea ki hanna, bulate hadara kiam dhabaa. Harrna hambhidianna, bishino wul lay dikimon nuunte konin dhabadhera, hannon bishinsa waa kalaam hakalanka ha kaysidianna hana payyane. ");
INSERT INTO amf_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mizaqa anta hantea haam seesondar arsea ki hanna, taxate hadara kiam dhabaa. Harrna hambhidianna, bishino hasa wul lay dikimon nuunte konin dhabadhera, hannon bishinsa waa kalaam hakalanka ha kaysidianna hana payyane. ");
INSERT INTO amf_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","‘‘ ’Geshon yinnonam bulate oytea eedi hay ki hannaar koam yininna bulate oytonsa goynam giyea warqat kona ki ime’ ena ko hambhade. ");
INSERT INTO amf_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Intaar yena ida giye: Sharmucimakko goytika dayma geshon yinnonam yikalanka bulea wul konin sharmucimoadettsi koam kida haye; geshoayn bulon maynam keemea ea kidi sharmucimidine. ");
INSERT INTO amf_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","‘‘Pir ena wodanka dohon eenna ‘Buudaka malleebhode. Barjona hanin imon mallan upsinam hayaa’ hambhonam yedi qansidine. ");
INSERT INTO amf_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Intaar yena ida giye: Hamin ko dahaannaar malleebhode. Cecino Barjosa bitamon borkotono konin dohonna, cecinka malleebhode; ");
INSERT INTO amf_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","peeno Barjosa roonin tigayno konin dohonna, peenkaar malleebhode. Yerusaalem gebhaa bitaasa katamano konin dohonna, Yerusaalemkaar malleebhode. ");
INSERT INTO amf_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Hasa metensa sitinam cawlibee thiyabedar hayayse maasana hanin damiminna, hasa metenkaar mallaabhode. ");
INSERT INTO amf_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ogona yesa dhalqinam ‘Yin ko dee’ hamidi ye hanna, ‘Yin ko dee’ hamee; ‘Yintehe’ hamidi ye hanna, ‘Yintehe’ hamee. Igina upsinakalanka sagoono upsino wul siyonkalankane. ");
INSERT INTO amf_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","‘‘ ’Aapin uxaasa aapino ko uxadhe; atsin aysaasaar atsino ko aysadhe’ hambhonam yedi qansidine. ");
INSERT INTO amf_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Inta yena ida giye: Siyan yedar hayayna eenasa halon maaseebhode. Hasa mizaqa karcam ceveana warkata karcam kina shirshaa. ");
INSERT INTO amf_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Eedi kalaa hasa shuraabeam hakalanka tiyo zagayse haam bersidi ki hanna, pir hasa kotteam kina imaa. ");
INSERT INTO amf_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Eedi hayo kalaa ‘Basken innonam ina baskayse goyti orgo inka dhaabhaa’ hamayse kantaka haam dhaasidi ki hanna, ya kinin zagaara kina saskayse yivima. ");
INSERT INTO amf_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Hakal miskeana imaa; hakal bazimota oysaam maraabhode. ");
INSERT INTO amf_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","‘‘ ’Ha aanantaam nashaa; haam jibbeam jibbaa’ hambhonam yedi qansidine. ");
INSERT INTO amf_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Inta yena ida giye: Yeam jibbayna eenaam nashee; yeam oytayaynana Barjoam miskee. ");
INSERT INTO amf_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ogo yenin hayenka, cecinte dahaa Imbaa yenteasa naasi yeda maate. Kidi siyanabee payyanabedar yisa haynam kida bule; tipan waadadhaynabee tipan waadadhiminabedar yisa doobinam kida qanse. ");
INSERT INTO amf_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Yeam nashaynaam bish ye nashina, yer har baza yeda haape? Eena cubbona gibirin kacchaynaar yin haya ke haye. ");
INSERT INTO amf_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yeam nashaynaam bish ye nagaysina, waani eendara sagi yer har ye waadadhaa? Barjoam dhesimina eenaar ogodettsi keda haye. ");
INSERT INTO amf_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Keeda cecinte dahaa Imbaa yentea gon hamaa kinin dohondettsi, yediar gonin hamma maatee. ");
INSERT INTO amf_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","‘‘Barjona waadadhadhen payyan waadimanam ‘Eedi ko iam shede’ hamayse yenin hayoamadettsi mete yesaam gishee. Ogotay ko hamma, cecinte dahaa Imbaa yenteakalanka yenin tiyea baza yesa qolehe. ");
INSERT INTO amf_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ogonante ya qambhinana imintonam hanin imenka, maltina eenadettsi maataabhode. Kedi eenin keam shedayse shawkoadettsi hamayse bukin raqinbee goynbedar kenin waadadhenam yisa may keda dhee. Inta yena gon ida giye: Kedi yina yesken bazanam tiydine. ");
INSERT INTO amf_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Keeda ya qambhinana imintonam hanin imenka, eedinin haapoamadettsi hayayse aachika imaa. ");
INSERT INTO amf_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Aachinka hanin imenam haapea Hamba hana bazanam kida ime. ");
INSERT INTO amf_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","‘‘Yedi yenin miskenka, maltina eenadettsi maateebhode. Kedi kesa miskenam eedinin haapoadettsi hamayse bukin ranqabee goyna parmanabedar woyayse miskana keda nashe. Inta yena gon ida giye: Kedi yina yesken bazanam tiydine. ");
INSERT INTO amf_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ya hanin miskenka, ooninsa gulinte ardayse kerin diithayse haapadhima Hambaam miskaa. Haapadhimonam haapea Hamba hasa bazanam hana kida ime. ");
INSERT INTO amf_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Yedi yenin miskenka, Barjoam dhesimina eenadettsi sun maasite maasite dhalqeebhode. ‘Wosa upsin wo thoosanna, Barjo woam kida qanse’ hamayse keda bhocche. ");
INSERT INTO amf_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yedi kedettsi maateebhode. Ye miskima birayse yeam zasken wulam Imbaa yentea dhesa ki dhese. ");
INSERT INTO amf_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","‘‘Keeda yedi yin giyayse miskee: Cecinte dahaa Imbaa wontea, nammo hasa ko gazisadhe. ");
INSERT INTO amf_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Bitamono hanno ko nive. Bhocchino hasa cecinte konin maatendettsi, peentear yin ko maateka. ");
INSERT INTO amf_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kina rooroana wona zasken galan wona imaa. ");
INSERT INTO amf_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Woam seesaynana wonin garendettsi, wonnon seesonamaar wona ya garaa. ");
INSERT INTO amf_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Siyondar arsota taysayno wodar konin nivoamadettsi woam gishaa. Siyonkalanka woam dhacchaa. Bitamonbee, kantanbee, gobshinbe lay hantine; amiin. ");
INSERT INTO amf_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Eenna kesa seesonam ye garea hanna, cecinte dahaa Imbaa yentea yenaar yesa seesonam gara ki gare. ");
INSERT INTO amf_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Eenna kesa seesonam ye garaamma, Imbaa yentea yesa seesonam yena garehe. ");
INSERT INTO amf_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","‘‘Itsima yenin qoomenka yedi yinin qoomonam eenna dhoota hayayna maltina eenadettsi wotinam seeseebhode. Kedi een birante itsima qoomayna maatayse sun guuri keda cawle. Inta yena gon ida giye: Kedi yina yesken bazanam tiydine. ");
INSERT INTO amf_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Ya itsima hanin qoomenka, aapin kerin hannon shiidhaa; hasa metenamaar waqatika qadhaa. Ogoam hanin hayoono eedina dayma, haapadhima Hamba bish kinin dhesoadettsine. Haapadhimonam haapea Hamba hasa bazanam hana kida ime. ");
INSERT INTO amf_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","‘‘Ulavulobee boyibeyn itsana damen, pir diibiar koyate tiyen peen kodar koymonam yena puccheebhode. ");
INSERT INTO amf_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ogona ulavulobee boyinbe itsimon, pir diibiar koyate tiymon cecinte koymonam yena pucchee. ");
INSERT INTO amf_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Harrna hambhidianna, hannon koymonin dohonte hasa woylammoar ogote koda dee. ");
INSERT INTO amf_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","‘‘Bishinsa shaakano aapine. Keeda aapino hanno payya ko hanna, hasa bishino wul shaakante koda dee. ");
INSERT INTO amf_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Aapino hanno hajidi ko hanna, hasa bishino wul thipante koda dee. Ta hakal dohoono shaakano thipidi ko hanna, thipano kattsi gebhi koda thipe! ");
INSERT INTO amf_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","‘‘Bit lamaasa demente daana damea eedi hay ki hannaar qolehe. Harrna hambhidianna, kalaam jibbayse lansoam kida nashe; ogotay ko hamma, kalaadar maatayse lansoam kida bage. Ogodettsi Barjobee koymobesa demente daana damattene. ");
INSERT INTO amf_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","‘‘Ogonante inta yena ida giye: Dayntan yennonna, ‘Haroo itso? Haroo wuco?’ pir bishin yennonna, ‘Haroo qaadho?’ hamayse qaabeebhode. Galara dayntano, apalara bishino sagayu? ");
INSERT INTO amf_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Cecinka pillayna aptinaam shedee: Kedi bheeta yiithehe; shikaar shikehe; konontear keehe. Ko dahaannaar cecinte dahaa Imbaa yentea keam kida kunse. Ta yedi kedara kattsi sagattenu? ");
INSERT INTO amf_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Yesa iira qaabayse leven yinnondar rooro kalaa arsea eedi hayne? ");
INSERT INTO amf_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","‘‘Pir apalanna harrnee gaale? Ta peendar aamana hamin kenin gebhenam shedee. Kedi waadimaka qajadhehe; puttoar qanehe. ");
INSERT INTO amf_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ko dahaannaar yena ida giye: Ena Bitaa Solomoonaar yisa gobshin wulka igina aamanasa kalaadettsi hattear qaadhayse goobadehe. ");
INSERT INTO amf_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ta Barjo kina haapadhayse saka nuunte koqadhayna peendar dahaana shundhaam yin gobshayse qattsea ki hanna, ta yedi Barjodar woylamin qajadhen joogaanato, yeam ini hamin ki qattsimine? ");
INSERT INTO amf_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","‘‘Keeda ‘Wodi haroo itso? Haroo wuco? Yer haroo qaadho?’ hamayse qaabeebhode. ");
INSERT INTO amf_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ogo wulam haapota Barjoam dhesimino eeno koda zage. Ogono wul yena konin zaskenam cecinte dahaa Imbaa yentea dhesa ki dhese. ");
INSERT INTO amf_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yedi yer wulsa birayse Barjosa bitamonbee kisa tipamonbeam zagee; ogono wul yena imbha ko imbhe. ");
INSERT INTO amf_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Saka hamon gaalenam sakana garee; ogoam qaabite gaaleebhode. Sedha kalaa gaaleno sedhaa agaana yeeka ko yeeke. ");
INSERT INTO amf_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","‘‘Een waanidar yenin pirdendettsi yedarar pirda ko pirdadhe. Yenin kahaaka yenaar kaadha ko kaadhe. Ogonante yedar pirdadhoamadettsi yediar eedidar pirdeebhode. ");
INSERT INTO amf_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Hannon aapinte dohon haaqanam haapima, ha aanantasa aapinte dohon kosonam harrnaa shede? ");
INSERT INTO amf_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Hannon aapinte haaqa daaka, ha aanantana ‘Aapin hannora hana kosonam i bule’ hamayse haminaa giyaa? ");
INSERT INTO amf_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ya maltia ea, birayse hannon aapinte dohon haaqanam bulaa; ogosa budonte ha aanantasa aapinte dohon kosonam bulana payya hayayse hada haape. ");
INSERT INTO amf_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","‘‘Barjosa yerin gazanam qaskinana imeebhode; ye imidianna budoka wal hamayse yeam gavasane. Ogodettsi koymon gebhonka yenin shanonam wurkupanasa birante wodeebhode; ye wodidianna roonka tigasane. ");
INSERT INTO amf_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","‘‘Miskee, yena imbha ko imbhe; zagee, haapeeda haape; kerinam kokkee, yena buldha ko buldhe. ");
INSERT INTO amf_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Harrna hambhidianna, miskea wul tiya ki tiye; zagear haapa ki haape; kerinam kokkeanaar kerro buldha ko buldhe. ");
INSERT INTO amf_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Yesa iira naasa kintea kiam balasha ki miskaysaka, kina seeni imea eedi hayne? ");
INSERT INTO amf_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Way kaara ki miskaysaka, kaaran oolonte kina guni ima ki imo? ");
INSERT INTO amf_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ta keeda yedi siyana dahayse naanana yesa yerin payyan iman ye dhesidianna, cecinte dahaa Imbaa yentea kiam miskaynana yerin payyanam sagi hamin ki imimine? ");
INSERT INTO amf_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","‘‘Ta keeda eenin yena hayoadettsi yenin nashen yerin wulam, yediar kena yin hayee. Musesa yigginbee Barjokala qansayse eenna giyaynabeyn dhettsaynoar ogoamne. ");
INSERT INTO amf_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","‘‘Kayendar arsayno kerro workine; goynoar kosa worrine; ogote ardayna eenaar thoothine. Eenaam rooro wul dayntandar yeskisayno kerro qiiqane; goynoar kosa likkane; koam haapayna eenaar tokaanane. Keeda qiiqa kereaka ardee. ");
INSERT INTO amf_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","‘‘Buudamoka ‘Inta Barjokala qansayse eenna giyeane’ hamaynakalanka mete yesaam gishee. Kedi yaati eebhe qaadhayse yekal keda nive; ko dahaannaar kesa iino sarimayna yaayonadettsine. ");
INSERT INTO amf_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Keamaar yeninkay dhesayno kesa waadimansa aapinkane. Ukumbhan hattasa iira woyni aapi kama ko kambho? Mugurira shaapsa aapi kama ko kambho? ");
INSERT INTO amf_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ogodettsi pir payyana haaqana wul aapin payyan keda ushe; haaqana siyana aapin siyonam keda ushe. ");
INSERT INTO amf_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Haaqana payyana siyon aapinam ushehe; haaqana siyana aapin payyanam ushehe. ");
INSERT INTO amf_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Payyan aapin ushimina haaqana wulam paxayse nuunte keam koqa ko koqadhe. ");
INSERT INTO amf_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Keeda igina eenaam kesa waadiman aapinka yeda dhese. ");
INSERT INTO amf_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","‘‘Inka ‘Imbo, Imbo!’ hamayna wul Barjosa bitamon raqinte ardehe; cecinte dahaa isa Imbayn giyonam hayea bisheada arde. ");
INSERT INTO amf_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Barjosa pirdin rooroaka thoothino eeno, ‘Imbo, Imbo! Hasa naabenka Barjosa wodi giyooto? Hasa naabenkasin beeronaam eendara wodi bulooto? Hasa naabenkasin thoothin yerin tarshenam wodi hayooto?’ ina keda hame. ");
INSERT INTO amf_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ogo wodanka, ‘Inta yeam dhesattine; yedi siyon hayayna eenato, ikalanka os pegadhee!’ kena ida hame. ");
INSERT INTO amf_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","‘‘Ogonante isa upsin koam qansayse hayayna wul ooninam yisa haachan peendar woysaa ea pakaladettsine. ");
INSERT INTO amf_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Dommo oonin ogodar ko qanade; mirroar daran ko nivade; wuranoar nivayse oonin ogoam ko kupade. Onno ogono haachan peendar konin woysadhonna dhambadehe. ");
INSERT INTO amf_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Taar isa upsin koam qansayse haymina wul ooninam yisa shaamindar woysaa ea malgimeadettsine. ");
INSERT INTO amf_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Dommo oonin ogodar ko qanade; mirroar daran ko nivade; wuranoar nivayse oonin ogoam ko kupade; onnoar dhambidine. Kosa dhambidinoar kattsi detha ko maatade’’ hamayse kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesusaar ogoam yin giyate kinin macchonsa budonte, eeno kinin dhettson timmirinka kattsi ko targadhade. ");
INSERT INTO amf_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ogonoar konin targadhoono Musesa yigginam dhettsaynadettsi dayma, kidi yisa hayamoka eenaam dhettsite kinin dohonnane. ");
INSERT INTO amf_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesusaar dhukara kinin hanchen wodanka, thoothino eeno kisa paanan ko yivade. ");
INSERT INTO amf_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ogo wodanka eedi kalaa lamth burqoka dahaa kisa birante nivayse hatte kumpurdhayse, ‘‘Imbo, ha nashidianna, iam pacchana damaada dame’’ hamayse kiam ki miskade. ");
INSERT INTO amf_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesusaar yisa aaninam kidar wodayse, ‘‘Haam pacchana nashayda nashe; paashaa’’ kina ki hamade. Saanawaar kisa lamthin burqono ko paashade. ");
INSERT INTO amf_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesusaar, ‘‘Hanin paashonam eedi haynaar hanin giyoamadettsi mete hasaam gishaa; ko dahaannaar yivayse hasa bishinam gudulana dhahaa. Eennaar hanin paashoono tarja konin maatoadettsi Museyn giyon Barjona machadhen marshanam imaa’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Yesus Qipirnaahoom katamante kinin ardaa wodaaka mato alaqa kisa birante nivayse, ‘‘Imbo, isa ergen ea burqoka malgimayse gaalite ooninte wodhayse ki dahade’’ hamayse kiam ki miskade. ");
INSERT INTO amf_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesusaar kina yi giyna: ‘‘Inta nivayse kiam pacchasane’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mato alaqaar kina yinin maasenka, ‘‘Imbo, oonin innonte ha arde inta eedi zaskaatehe. ‘Hasa ergen ea ki paashe’ bish ina hamaa; kidiar paasha ki paashe. ");
INSERT INTO amf_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Intaar iam wottsaynana ee hamayda hame; isaar choobar ina ee hamayna poolisana ke dahade. Kesa kalaana ‘Yivaa!’ inin hamenka, yiva ki yive. Waa eanaar ‘Nivaa!’ inin hamenka, niva ki nive. Isa erge eanaar ‘Koam hayaa’ inin hamenka, haya ki haye’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesusaar agaa easa dhalqinam yinin qansenka, kidi targadhidine. Kimbesana yiven eenna yi giyna: ‘‘Inta yena gon ida giye: Israveel eenasa shaarinte kaa eadettsi gebhi idar woylamin qajaa haapaatine. ");
INSERT INTO amf_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Inta yena ida giye: Thoothino eeno haynsa utambarabee wavambarabe koda nive; Abraambee, Yisaaqbee, Yayqoobbesana kinka Barjosa bitamonte kummandar koda dooqe. ");
INSERT INTO amf_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Barjosa bitamonte ardana bhocchayna eena os mayan thipante keam koda dhabadhe; ogotear eepibee atsi qiicabe koda maate’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ogosa budonte Yesus mato alaqaana ‘‘Ya yivaa, idar woylamin hanin qajondettsi hana ko dee’’ kina ki hamade. Kisa waadiman ear ogo wodanka ki paashade. ");
INSERT INTO amf_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesus Bhethiroossa ooninte kinin ardenka, Bhethiroossa baysino bishi occhea hajimoka burqadhate wodhayse ko daaka koam ki haapade. ");
INSERT INTO amf_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kosa aaninamaar kinin yeden wodanka, bishin occhayno hajimono koam ko garade. Kodiar dhaabhayse Yesusna galan baxan ko yedade. ");
INSERT INTO amf_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Peen sootaysakaar beeronin yedaana eena thoothinaam Yesuskal entsate ke nivade. Yesusaar beeronaka ‘‘Utee!’’ hamintaka bish ki keam bulade; hajadhaana wulamaar ki pacchade. ");
INSERT INTO amf_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ogonoar ‘‘Kidi wonnon hajimonam ki tiyade; burqamon wonnonamaar wona ki baskade’’ hamayse Barjokala qansayse eenna giyea Isiasin giyondettsi ko thoothade. ");
INSERT INTO amf_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesusaar thoothino eeno kisa gasante konin bukonam yinin haapenka, yisa paanan yivayna eenana, ‘‘Bazinsa saabar wo sage’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ogora Musesa yigginam dhettsea eedi kalaa Yesuskal nivayse, ‘‘Woam Dhettsea, inta hanin yiven hamote ko hannaar, hasa paanan yivayda yive’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesusaar kina yi giyna: ‘‘Shedaa! Gaamirenasa kenin wodhea kesa oolo daane; aptinasaar ooni daane. I Eedi Naas meten innon inin daasea raq isa qolehe’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yesussa paanan yivayna eenasa waa yi giyna: ‘‘Imbo, birayse imbaam duukayse inin nivoadettsi iam yittsaa’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesusaar kina yi giyna: ‘‘Shedaa! Diyaana diyaanaam kenin duukoadettsi kena garaa. Ya isa paanan nivaa’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesus bazindara sagadhen gonngalante kinin ardenka, kisa paanan yivayna kimbesana ardayse ke yivade. ");
INSERT INTO amf_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kenin yivenka ke dhesima bazindar gebhi wura dhaabhayse gonngalanam noqonin manngenka yekka ko jugade. Ogoka Yesus raatidine. ");
INSERT INTO amf_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kisa paanan yivayna eenaar kikal theedayse, ‘‘Imbo, wodi hakal kayoobhe; woam dhacchane!’’ hamayse kiam ke dhaasade. ");
INSERT INTO amf_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kidi kena yi giyna: ‘‘Yedi idar woylamin qajadhenin joogaanato, yin yenin kurtumbhayno hare?’’ kena ki hamade. Ogora dhaabhayse wuranbee bazinbeam ki bitade. Ogora wuranbee bazinbe kalon lay ko hamade. ");
INSERT INTO amf_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Eenaar ogoam shedayse, ‘‘Wuranbee bazinbe yinna ee hamea kaa eedi hamin dahaane?’’ hamayse ke targadhade. ");
INSERT INTO amf_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Bazinsa saabar Gergesenon peendar ki nivade. Ogotear beeronayn yedaana eedi lamaa waani duukin raqira utayse daran ke keerade. Igina eena kattsi siya eedi kenin dohonna goyn ogoka eeno yaayan bashadhidine. ");
INSERT INTO amf_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Kediar, ‘‘Ya Barjo Naasa, hambesana wosa dohoono hare? Wodar pirdadhen rooron wosa yeskima woam galshanaa nivaaw?’’ hamayse ke ilatade. ");
INSERT INTO amf_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Eena iginayn dohon raqira likka pege wurkupa thoothi gishima gishadhayna dahade. ");
INSERT INTO amf_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Beeronaar Yesuskal yi giyna: ‘‘Eena kinara woam ha bulea hanna, igina wurkupana gishiman gishadhaynadar woam yittsaa’’ hamayse kiam ke miskade. ");
INSERT INTO amf_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kidiar, ‘‘Yivee’’ kena ki hamade. Kediar eenadara utayse wurkupanasa iinte ke ardade. Marrato! Igina wurkupana wul bazinsa gasante dahayse, targadhayse yinin mugumonka laasara gobayse bazinte wavayse ke diyade. ");
INSERT INTO amf_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Wurkupan gishaynaar ogora gobate katamandar yivayse igina beeronayn yedaana eenasa goynbee ogote yerin hamon wulbeam ke giyade. ");
INSERT INTO amf_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ogosa budonte katamante dohoono eeno wul Yesusam shedo ko utade. Konin shedon wodanka, ‘‘Ea kaa, ya wosa peera yivaa’’ hamayse kiam ke miskade. ");
INSERT INTO amf_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesus bazindara sagadhen gonngalante ardayse bazinam sagayse pir yisa katamandar ki yivade. ");
INSERT INTO amf_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ogotear hajimonka malgimaa eedi kalaam eena haaqaka bavate kikal ke nivade. Yesusaar kidar woylamin kenin qajonam shedayse hajimon eana yi giyna: ‘‘Inaane, wocchimbhima; hasa seesono hana gardhidine’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Musesa yigginam dhettsaynasa waani waani eena yisa woylaminka yi giyna: ‘‘Kaa ea Barjo maato ki qaabaaw?’’ hamayse ke qaabade. ");
INSERT INTO amf_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesus kenin qaabonam dhesayse kena yin ki giyade: ‘‘Woylaminka yesa yer siya harrnee qaabe? ");
INSERT INTO amf_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‘Hasa seesono hana gardhidine’ hamarabee ‘Dhaabhayse yivaa’ hamarabesa hamaane deegaa? ");
INSERT INTO amf_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ko dahaannaar i Eedi Naasina peendar eenna seesonam garana hayamo isa konin dohonam yenin dhesoadettsi yeam ko zaske’’ hamayse hajimonka malgimaa eaka, ‘‘Dhaabhayse haam baadhon haaqanam hanka bavate hasa oonindar yivaa’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Hajimonka malgimaa ea dhaabhayse yisa oonindar ki yivade. ");
INSERT INTO amf_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Eenoar ogoam haapayse targadhidine. ‘‘Kodettsin hayamonam eedina imaa Barjo ki gobshadhe’’ hamayse kiam ko gobshade. ");
INSERT INTO amf_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesus raqin ogora dhaabhate kinin yivenka, eedi kalaa Maatoos hambhea gibirin kinin kacchen raqinte dooqayse ki daaka kiam haapayse, ‘‘Isa paanan nivaa’’ kina ki hamade. Kidiar dhaabhayse kisa paanan yivan ki yedade. ");
INSERT INTO amf_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ogosa budonte Yesus Maatoos ooninte kummandar dooqayse ki daaka, waani thoothina gibirin kacchayna eenabee Musesa yigginam toolimina eenabe nivayse Yesusbee kisa paanan yivayna eenabekal kummandar ke dooqade. ");
INSERT INTO amf_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Parisa eenaar ogoam haapayse Yesussa paanan yivayna eenana yi giyna: ‘‘Yeam dhettsea ea cubbona gibirin kacchaynabee igina seeson eenabesana kinka kinin kummayno harrnane?’’ kena ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesus yin kenin giyenam qansayse, ‘‘Hajadhaanaam akkimi koda zaske, payyanaam akkimi zaskehe. ");
INSERT INTO amf_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yedi ta yivayse ‘Inta machadhen marshara sagi eedina burqadhadhenam ida nashe’ hamayse thaapadhoono yer har konin dohonam payya hayayse dhesee. Harrna hambhidianna, inta seeson eena Barjodar kenin maatoadettsi keam eelota i nivade; tipana eenaam eelota nivaatine’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ogo wodanka Shivea Wannissa paanan yivayna eena Yesuskal nivayse, ‘‘Wombee Parisa eenabe rooro thoothi itsima woda qoome; hasa paanan yivayna eena itsima kenin qoomimino harrnane?’’ kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesusaar kena yin ki giyade: ‘‘Uutaa kembesana kinka ki daaka, gaydonna nivaana eena moykana dama ke damo? Ko dahaannaar uutaanin kekalanka edadhayno woda niva ko nive; ogo wodanka itsima keda qoome. ");
INSERT INTO amf_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Apala gecchoadar apala haaleam lashea eedi qolehe. Harrna hambhidianna, apala gecchoam yinka hattsate kinin tiyenna, haviminoar kisa kalon koda worke. ");
INSERT INTO amf_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jambin gecchonsa iinte zia haali shabhea eedi qolehe. Shabhadhidianna ziano hallo jambinam bhattsa ko bhattse; zianoar layma ko layme; jambinoar bhaqayse gemma ko gemme. Ogona zian haalinam jambin haalinte koda shabhadhe. Yin ko hanna, lamaana wul gemmima payya daa ke dee’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesus ogoam kinin giyenka, eedi hayo kalaa nivayse hatte kisa birante kumpurdhayse, ‘‘Isa naano ikalanka taaki ko diyade; ko dahaannaar ya nivayse aanin hannonam kosa bishindar ha wodidianna kodi dhaqa ko dhaqe’’ hamayse kiam ki miskade. ");
INSERT INTO amf_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesus dhaabhayse yisa paanan yivayna eenabesana kinka eabete ki yivade. ");
INSERT INTO amf_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Eedi maa kallo layme hajimoka leve tabhi lamaa hajadhayse kappoono, ‘‘Apalan kisa hattear kaamidi i hanna, inta paashayda paashe’’ hamayse woylaminka yisa konin qaabonna kisa budobar nivayse apalansa nukinam ko kaamade. ");
INSERT INTO amf_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesus budoka wal hamayse koam shedayse, ‘‘Isa naano, wocchimbhima. Idar woylamin hanin qajoono haam ko pacchade’’ kona ki hamade. Edonoar agaara yedayse ko paashade. ");
INSERT INTO amf_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ogosa budonte Yesus hayoa ea ooninte kinin yeskenka, saalan pugayna eenabee ilatite eepayna eenabeam shedayse, ");
INSERT INTO amf_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","‘‘Naano raata ko raatade, diyadehe; yedi os hamee’’ kena ki hamade. Eenaar kiam bagayse ke hancade. ");
INSERT INTO amf_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ko dahaannaar eenaam mayanka buldhonsa budonte, Yesus ardayse naansa aaninam ki yedade; kodiar dhaabhidine. ");
INSERT INTO amf_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ogono Yesusin hayoono ogo peente dohon een wulna ko dhesimade. ");
INSERT INTO amf_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesusin raqin ogora utaate yivenka, eedi lamaa aapin kayaana waani, ‘‘Dawt Naasa, bannzo! Wona burqadhayse woam pacchaa!’’ hamayse ilataate kisa paanan ke yivade. ");
INSERT INTO amf_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ooninte kinin ardonsa budonte, aapin kayaana eena kikal ke nivade. Yesus kena yi giyna: ‘‘Aapin yennonam pacchana inin damenam idar woylam qajee qajo?’’ kena ki hamade. Kediar, ‘‘Yehee, imbo, qajooda qaje’’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yesusaar kesa aapinam yisa aaninka kaamayse, ‘‘Idar woylamin yenin qajendettsi yena ko maate’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kesa aapinoar ko shedade. Kidiar kena yi giyna: ‘‘ ’Yesus woam pacchade’ hamayse eedina yenin giyoamadettsi mete yesaam gishee!’’ hamayse upsi wocchika kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kediar ogora utayse peen ogo wul gidir Yesussa waadimanam ke giyade. ");
INSERT INTO amf_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Aapin kinin pacchaana eena ogora kenin utenka, eedi waani beeroyn yedayse apo cavate kaysaa eedi kalaam Yesusdar bavate ke nivade. ");
INSERT INTO amf_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Eadara beeronam kinin bulonsa budonte, apono kisa dhalqan ko yedade. Thoothino eenoar, ‘‘Kodettsino yer Israveel peente kala hattear haapayse dhesadhadehe’’ hamayse ko targadhade. ");
INSERT INTO amf_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Parisa eena yi giyna: ‘‘Kidi beeronaam kinin bulayno beeronasa hayoa kantankane’’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesusaar Ayiwd eensa bukin raqinte dhettsada, Barjo bitamonsa dhacchintan upsinam giyada, eenaam yedon waana waana hamon burqon wulamaar pacchada kesa katamanbee gurdanbe wulir yaayte ki dahade. ");
INSERT INTO amf_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kidi eenaam gishea eediysa qolmina yaanadettsi gaalitebee kelshea bashadhaysebe ke daaka keam haapayse kena ki burqadhade. ");
INSERT INTO amf_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ogo wodanka yisa paanan yivayna eenana, ‘‘Buurdhayno isinno thoothine; buurayna eena tokaane. ");
INSERT INTO amf_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ta keeda isininsa Imbaa buurayna eenaam haamindar kinin nittsoadettsi kiam miskee’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesus yisa paanan yivayna eena tabhi lamaanaam yikal eelayse, ‘‘Beeronaam eendara bulee; eenam yedon waana waana hamon burqon wulamaar pacchee’’ hamayse hayamo kena ki imade. ");
INSERT INTO amf_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yesus Kiristoos yisa tarjamonnante kinin yittsaana eenasa namma kinane: Birayse Bhethiroos hambhea Simoonbee, indanaasa Indiriasbee, Zabdoos naana lamaana Yayqoobbee Wannisbe, ");
INSERT INTO amf_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","pir Pilbhoosbee, Bartelemoosbee, Toomaasebee, gibirin kacchea Maatoosbee, Ilpoos naasa Yayqoobbee, Taadoosbee, ");
INSERT INTO amf_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","peen yinnonna bish qaabea Simoonbee, Yesusam dembhinna saskate imea Asqoronto peen ea Yiwdabene. ");
INSERT INTO amf_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Yesus igina tabhi lamaanaam yin giyayse ki yittsade: ‘‘Yenin yivenka yaatidettsi kayaana Israveel eenadar yivimate. Ayiwdtaymina eenadar yiveebhode; Sammaria eenasa katamante ardeebhode. ");
INSERT INTO amf_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Yivayse ‘Barjoyn bitimayno wodano yeskidine’ hamayse giyee. ");
INSERT INTO amf_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Hajadhaana eenaamaar pacchee; diyaana eenaamaar dhaasee; lamth burqonin yedaanaamaar pacchee; beeronaamaar eendara bulee. Sun yenin tiyonna, eennaar sun imee. ");
INSERT INTO amf_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Worqibee, birrebee, santupbeam yesa korbhonka bavate yiveebhode. ");
INSERT INTO amf_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Goynna surba yenka beveebhode; shuraab lansobee, dunnguribee, haljobe yenka beveebhode. Harrna hambhidianna, waadadheana galano imbha ko imbhe. ");
INSERT INTO amf_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","‘‘Katamante way gurdante yenin ardenka, yeam chocchamon tiyea hay kinin dohonam payya hayayse oysate kiam dhesee. Peen ogora yenin utenka yekka kikal ooninte dooqee. ");
INSERT INTO amf_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Eenkal ooninte yenin ardenka, ‘Nagaya nagaya’ kena hamimate. ");
INSERT INTO amf_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Oonin eena yeam ke tiyea hanna, kena yenin imayno nagaymakkono kena koda maate. Yeam tiymina ke hanna, kena yenin imayno nagaymakkono yena koda maate. ");
INSERT INTO amf_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Eenin yeam chocchamon tiymon way yenin giyenam kenin qansimon raqinte ye hanna, ogo ooninbee katamanbera yenin utenka roon yennondar dohon silalinam gidir dinsee. ");
INSERT INTO amf_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Inta yena gon ida giye: Pirdin rooroaka kataman ogora Sodoombee Gamoorabedar yeskayno pirdino tokaane. ");
INSERT INTO amf_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","‘‘Marrato! Inta yeam yaanadettsi yaayonasa shaarinte ida yittse. Ogonante yedi gunidettsi pakalla, waleedettsi leemina daymate. ");
INSERT INTO amf_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ko dahaannaar pirdin pirdayna eenasa birante yedar pirdadhe eeno yeam saskate ima ko ime; Ayiwd eenasaar bukin raqinte yeam qana ke qane. Ogonante eenkalanka mete yesaam gishee. ");
INSERT INTO amf_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Innon goynka peen wottsaynabee binnabe yedar ke pirde yedate yeam kedar ke yive. Ogonoar igina eenabee Ayiwdtaymina eena wulbesa birante isa tarjana yenin maatoadettsine. ");
INSERT INTO amf_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Yedar pirdadhe hamayse yettsate saskayse yeam kenin imenka ‘Yer haroo giyo?’ way ‘Hamin giyayse wo maaso?’ hamayse qaabeebhode. Yenin giyayno ogo wodanka yena imbhasane. ");
INSERT INTO amf_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Yenka maatayse giyayno Imbaa yenteasa Manpasinone; yeditehe. ");
INSERT INTO amf_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","‘‘Ogo wodanka indanaasaar indanaasaam, imbaar naasa yinteam dembhinna saskate ima ki ime. Naanaar imbanadar dhaabhayse keam dettsa ke dettse. ");
INSERT INTO amf_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yedi isa naabenna hamayse een wulkal jibbadhaana yeda maate. Macchin wodanka yekka wocchimbhayse dehea kidi dhaqa ki dhaqe. ");
INSERT INTO amf_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","‘‘Kataman kallonte yeam ke oytayna ogoam garayse kataman waadar gobee. Ogonante inta yena gon ida giye: I Eedi Naas maatate nivenka yekka Israveel peente dohon kataman wulgidir yeskisattene. ");
INSERT INTO amf_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","‘‘Dhettsadhea ear kiam dhettseadara sagehe; waadadhea ear kiam waadiseadara sagehe. ");
INSERT INTO amf_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Dhettsadhea ear kiam dhettseadettsi maatidi ki hanna, yeeka ko yeeke. Waadadhea ear kiam waadisea eadettsi maatidi ki hanna, yeeka ko yeeke. Ooninsa imbaam ‘Bevelzebul’ hamayse eeno eelidi ko hanna, kisa oonin eenaam kattsi hamin ko eelimine’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yesus kena yi giyna: ‘‘Ta keeda eenna kurtumbheebhode! Ogonoar kicimayse may maatima, aadhimayse dhesadhima shidhea yer qolehe. ");
INSERT INTO amf_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Inin yena aachika giyenam yedi may hayayse giymate; hashkimeka yenin qansonamaar eensa shaarinte may koam ooshee. ");
INSERT INTO amf_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Waanam deesayse, sadanam deesana damiminana yedi kurtumbheebhode. Kattsi yeam kurtumbhinta zaskayno sadanbee waanbeam lay dikimon nuunte dhabayse kaysana damea Barjonane. ");
INSERT INTO amf_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","‘‘Aptina suutana lamaanaam bakkanda kalaadar shansha shanshadhayu? Aptina iginasa iira kallo hattear Imbaa yentea giyma sun peendar dhambehe. ");
INSERT INTO amf_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Meten yennonsa sitin wulam shiishima Barjo paydidine. ");
INSERT INTO amf_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ogonante yedi kurtumbheebhode; aptina suutana thoothinadara yedi sageeda sage. ");
INSERT INTO amf_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","‘‘Een birante isa tarjea wulna intaar cecinte dahaa Imbasa birante kina tarjayda tarje. ");
INSERT INTO amf_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Een birante ‘Inta Yesus eeditehe’ hamayse giyeana intaar cecinte dahaa Imbasa birante ‘Kidi inti eeditehe’ ida hame. ");
INSERT INTO amf_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","‘‘Inta peendar payyamo bavate inin nivaadettsi hayayse qaabeebhode. Eensa shaarinte payyamo dayma, banqi bavate i nivade. ");
INSERT INTO amf_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Inin nivoono naasaam imbaadara, naanam indandara, naasa geshonam aakandara edanane. ");
INSERT INTO amf_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Eedisa banqin eena kisa zelen eenane. ");
INSERT INTO amf_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","‘‘Idara sagi hayayse imbaa yinteam way indanam yisa nashea eedi inti kinin doadettsi kiam zaskehe. Taar idara sagi hayayse naasa yinteam way naan yinnonam nashea eedi inti kinin doadettsi kiam zaskehe. ");
INSERT INTO amf_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yinindariy ziitate deesadhen masqalinam kedayse isa paanan nivima eedi inti kinin doadettsi kiam zaskehe. ");
INSERT INTO amf_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sadan yinnonam dhacchota zagea wul koam kaysa ki kayse; ina hamayse sadan yinnonam saskate imea wul koam haapa ki haape. ");
INSERT INTO amf_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","‘‘Yeam chocchamon tiyea iam ki tiyade; iam chocchamon tiyea iam nittsaam ki tiyade. ");
INSERT INTO amf_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Barjokala qansayse eenna giyeam kisa waadimanna hamayse kiam chocchamon tiyea Barjokala qansayse eenna giyeana imbhayno bazano kinaar imbha ko imbhe. Tipa eam kisa tipamonna hamayse chocchamon tiyea tipa eana imbhayno bazano kinaar imbha ko imbhe. ");
INSERT INTO amf_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Inta yena gon ida giye: Kina likkanasa iira kalaana isa paanan kinin nivenna hamayse noqo qaji sharqa kala hattear kiam wushea wulsa baza shidhehe’’ hamayse kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesus dhalqin ogoam yisa paanan yivayna eena tabhi lamaanana giyate kinin macchonsa budonte, raqin ogoam garayse Ayiwd eena katamandar dhettsanabee kena Barjosa upsinam giyanabe ki yivade. ");
INSERT INTO amf_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Shivea Wannis dhaxin ooninte dahayse Kiristoosin waadadhen waadiman qansayse, kisa paanan yivayna eenasa iira eedi Kiristoosdar ki yittsade. ");
INSERT INTO amf_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Kediar Kiristooskal nivayse, ‘‘ ’Barjokala niva ki nive hambhaa yaw? Way eedi ab wo toolo?’ hamayse Wannis haam ki oysade’’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesusaar Wannisin nittsaanana ‘‘Yivayse yenin haaponbee yenin qansonbeam Wannisna giyee: ");
INSERT INTO amf_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Aapin kayaana haapa ke haape, roonsa wobona pika ke pike, lamthin burqonka dahaana paasha ke paashe, qaamin kayaana qansa ke qanse, diyaana dembhira dhaabha ke dhaabhe, qambhina eenanaar Barjosa dhacchintan upsinam giidha ko giidhe. ");
INSERT INTO amf_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ogonante inka qothimima kidi gobshadhaane’’ hamayse kena ki maasade. ");
INSERT INTO amf_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Wannis eena maatate ke yivaysaka Yesus thoothin eenna Wannissa giyan ki yedade: ‘‘Darante yer har shedee yivaa? Jibarenka shohen piiqan shedee yivaaw? ");
INSERT INTO amf_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ta har shedee yivaa? Apalan gooben qaadhaam shedee yivaaw? Apalan gooben qaadhaana eena binna ooninte ke dahade. ");
INSERT INTO amf_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ta har shedee yivaa? Barjokala qansayse eenna giyeam shedee yivaaw? Hahaa! Yena ida giye: Kidi Barjokala qansayse eenna giyeadara sagiane. ");
INSERT INTO amf_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Agaar ‘Shedaa! Hasa goynam birayse ashkea isa ergen eam hasa birante yittsayda yittse’ hamayse thaapadhoono Wannissane. ");
INSERT INTO amf_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Inta yena gon ida giye: Peente adhadhon een wulsa iira Shivea Wannisdara sagea eedi haapadhadehe. Ko dahaannaar Barjosa bitamonte een wulsa choobar dahaa Wannisdara saga ki sage. ");
INSERT INTO amf_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Shivea Wannis wodara yedayse ta kina wodan koka yekka Barjosa bitamono kantanka nivite ko dahade; ogote ardota kattsi mashimayna ogote arda ke arde. ");
INSERT INTO amf_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Barjokala qansayse eenna giyayna eenayn thaapon wulbee Musesa yigginbe Shivea Wannis wodanka yekka os birante hamota dohon yerinam giyte ke dahade. ");
INSERT INTO amf_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Yedi tiyana ye zagidianna, niva ki nive hambhaa Eelias kidi Wannisne. ");
INSERT INTO amf_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ogona qansen qaamiysa dahaa ki qanse. ");
INSERT INTO amf_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","‘‘Ta wodan ko eenaam yer harka i keam kamso? Gaban raqinte dooqayse yiigayna aanamma yinnaam eelite yin giyayna naanaam keda maate: ");
INSERT INTO amf_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Kediar, ‘Ye kirbe hamayse yena pashko wo pugade, yediar kirbeetene; siyinna ye eepe hamayse yena wo zilimade, yediar eepeetene’ kena keda hame. ");
INSERT INTO amf_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ta Shivea Wannis itsimabee wucimabe kinin qoomenka, ‘Kaa eadar beero daane’ hamayse kanka giyte ke dahade. ");
INSERT INTO amf_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ta keeda i Eedi Naas itsaatebee wucaatebe inin dehenka, ‘Marrato! Kaa ea galabee wucamobe nasheane; cubbona gibirin kacchayna eenabee seeson eenabesa yettsine’ inka ke hamade. Pakalmakkono gon konin dhesimayno waadiman konnonkane’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ogora Yesus thoothin tarshen yerinam kinin hayaana katamanaar dahaana eenaar seeson waadimanam yisa garayse Barjodar kenin maataamonna, keam yin giyayse ki kanchade: ");
INSERT INTO amf_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","‘‘Korazin katamante dahaana eenato, yedi hay! Beetesayda katamante dahaana eenato, yedi hay! Yekal haydhoono tarshayno waadimano Thiroosbee Sidoonaber haydhada hatte ko hanna, siyinna goobintonam yidara yiikayse dibiniar dumate yisa metendar kahayse ena wodda birayse seeson waadimanam yisa garayse Barjodar maatidi keda dee. ");
INSERT INTO amf_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ogonante inta yena ida giye: Pirdin pirdadhea rooroaka yedar yesken pirdindara Thiroosbee Sidoonabedar yeskayno tokaane. ");
INSERT INTO amf_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ta yedi Qipirnaahoom katamante dahaana eenato, tura cecindar dheg dheg hamo ye qaabaaw? Yin dayma mia diyaana eenayn dohon raqindar yedi hancheeda hanche. Yekal haydhoono tarshayno waadimano Sodoom gidir haydhidi hatte ko daana, katamano ogono kina koka yekka kayma ini daa ko dee. ");
INSERT INTO amf_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ogonante inta yena ida giye: Pirdin pirdadhea rooroaytana yedar yesken pirdira Sodoomdar yeskayno pirdino tokaane’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Wodan ogoka Yesus yin giyayse Barjoam ki miskade: ‘‘Cecinbee peenbesa Imbaa maataa Imbo, ko yerinam eena pakallabee yerin dhesaanabekalanka aachayse naana likkanana hanin dhohonna haam ida gobshe. ");
INSERT INTO amf_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Gonne, Imbo, koam yin hayana hasa payya qaabe ko maatade. ");
INSERT INTO amf_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yer wulam Imbakalanka ina imbhidine. Barjo Imbaakalanka ab Barjo Naasaam dhesea hayyear qolehe. Ogodettsi Barjo Naasabee Naasa yinti dhaana kinin zagaana eenabekalanka ab Barjo Imbaam dhesea hayyear qolehe. ");
INSERT INTO amf_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","‘‘Yedi qajadhaana, baskenindar dethaanato, wul ikal nivimate; inta yeam ukunsisayda ukunsise. ");
INSERT INTO amf_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Qoocandar yesa qambarin innon kedimate; ikalankaar dhesee. Inta isa woylaminkaar leemibee payyabene. Sadan yennonnaar ukunse haapeeda haape. ");
INSERT INTO amf_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Qambarro inno pasine; baskenoar isa sholbhane’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ogosa budonte Ayiwd eensa ukunsen rooroaka Yesus gazgon ushon haaminsa shaarinka kinin yivenka, kisa paanan yivayna eena yinin daaqardhonna gazgonsa tishanam qunthayse qadhate gavan ke yedade. ");
INSERT INTO amf_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Parisa eena ogoam haapayse Yesusna yi giyna: ‘‘Shedaa! Hasa paanan yivayna eena ukunsen rooroaka zaskimon waadimanam keda haye’’ kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Kidiar kena yin ki giyade: ‘‘Ena Dawtbee kimbesana kinka dahaana eenabe yinin daaqardhonna, Barjosa gazan ooninsa mayante ardayse Barjosa birante wodadhon balashanam tiyayse yinna eenabete kinka kinin itsonam yedi nabbabeete? Balashan ogoam gudulla bishda itse; Dawtbee kimbesana dahaana eenabeam ini ke itse zaskehe. ");
INSERT INTO amf_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","‘‘Tapir gudulla ukunsen rooroaka Barjosa gazan ooninte kenin waadadhenka, waadimano ogono kena seeso konin maatimonam Musesa yiggin mathaapinte yedi nabbabeete? ");
INSERT INTO amf_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Inta yena ida giye: Barjosa gazan oonindara sagi maataa ta kote daane. ");
INSERT INTO amf_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Pir, ‘Inta machadhen marshara sagi eedina burqadhenam ida nashe’ hamenam ye dhesidianna, ko seeson qolmon eendar pirdattene. ");
INSERT INTO amf_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Inta Eedi Naas ukunsen rooroasa Imbane’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesus ogora dhaabhayse Ayiwd eensa bukin raqinte ki ardade. ");
INSERT INTO amf_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kinin ardenka eedi kalaa aaniysa woboam ki haapade. Kedi Parisa eena Yesusam bersana zagayse, ‘‘Ukunsen rooroaka eediam pacchinta Musesa yigginte giidhidu?’’ hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Kidiar kena yinin maasenka, ‘‘Yesa shaarinte yaati kalaa yisa dahaa easa yaata ukunsen rooroaka geetir dhambidi ki hanna, geetira bulima hayne? ");
INSERT INTO amf_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ta eedi yaatidara kattsi sagitayu? Ogonante ukunsen rooroaka payya yer wonin waadadhoadettsi Musesa yigginte giidhidine’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ogosa budonte Yesus aaniysa woboa eana, ‘‘Antaam hasa pishkaa’’ kina ki hamade. Ear yisa antaam ki pishkaysaka paashayse anta waadettsi payya ki maatade. ");
INSERT INTO amf_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ogora Parisa eena utayse, ‘‘Hamin hayayse wo kiam deeso?’’ hamayse kinka ke ooshade. ");
INSERT INTO amf_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesus kiam deesota Parisa eenayn ooshonam dhesayse agaa raqaara raq abdar ki dhaabhade. Thoothino eeno kisa paanan yivo ko dhaabhade. Iginara hajadhaana wulam pacchayse, ");
INSERT INTO amf_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","eeno eedi haynaar kisa konin giyoamadettsi upsi wocchika ki giyade. ");
INSERT INTO amf_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ogonoar Yesusin hayoono ena Barjokala qansayse eenna giyea Isias yi giyna: ");
INSERT INTO amf_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‘‘Inin kamaa ina waadadhea ea kaane; inin nashea ininkay wozadhea kidine. Manpasin innonam daran ida wode; kidi gonin hamon pirdin peendar konin nivonam zarsin wulna kida giye. ");
INSERT INTO amf_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kidi palimehe; kidi ilatehe; goynadar upsin yisaam qansisehe. ");
INSERT INTO amf_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Pirdin wulam payya gaz hayayse kinin maasenka yekka ayanna tuqaa malkaam qunthehe, dikamba hayea nutamaar diskehe. ");
INSERT INTO amf_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Peendar dohoono eeno wul kidar qaabe koda haye’’ hamayse kinin giyoono thoothidine. ");
INSERT INTO amf_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ogosa budonte eeno beeroyn aapinbee aponbe kaysaa eedi waam Yesuskal bavate ko nivade. Yesus ea agaam ki pacchade; kidiar dhalqanabee shedanabe ki damade. ");
INSERT INTO amf_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Eeno wul Yesusin hayon yinin haapenka, kattsi targadhayse, ‘‘Kaa Dawt muldhansa iira Barjoyn qadhaa kidi doo ki dew?’’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Parisa eena ogoam qansayse, ‘‘Kidi beeronaam kinin bulayno beeronasa hayoa Bevelzebulsa kantankane’’ kanka ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesus kesa qaabonam dhesayse kena yin ki giyade: ‘‘Bita kalaasa eena kinka kikalanka edimayse kiam edea ke hanna, kikala laymate kaya ke kaye. Pir katamano kallo way oonin kallon eena kinka gemmayse kikala edimidi ke hanna, keeda kinka payyamoka daana damehe. ");
INSERT INTO amf_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Seethaan Seethaanam bulea ki hanna, kinka kikala edimidine hamintane. Ta yin ko hanna bitamono kisa hamin ko woye? ");
INSERT INTO amf_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Beeronaam inin bulayno Bevelzebul kantanka ko hanna, ta eena yenna beeronaam hay kantanka ke bule? Ogona kedi yedar pirda ke pirde. ");
INSERT INTO amf_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Inta beeronaam inin bulayno Barjosa Manpasinka ko hanna, ta keeda Barjosa bitamono yekal nividine hamintane. ");
INSERT INTO amf_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Pir eedi kalaa kantanka dahaa eam birayse yedate dhaxima ooninte kisa ardayse koymonam buurana hamin ki dame? Ogona kantanka dahaa eam yedate yinin dhaxonsa budonte, kisa ooninte ardayse koymonam kida buure. ");
INSERT INTO amf_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","‘‘Imbetetay hama hayyear iam jibba ki jibbe. Imbete kinka kamima hayyear os koam thar thar kida haye. ");
INSERT INTO amf_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Inta yena ida giye: Seeson waadimanbee iirimenbe wul eenna gardha ko gardhe. Ko dahaannaar Manpas Gazanam iireana gardhehe. ");
INSERT INTO amf_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","I Eedi Naasdar yerin siyonam giyea haynaar seesono kisa gardha ko gardhe. Manpas Gazandar yerin siyonam giyea haynaar wodan koka ko hannaar, oo niven wodanka ko hannaar, seesono kisa kina gardhehe’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yesusaar, ‘‘Payya aapi haapana haaqa payya koda zaske; siya aapi haapana haaqa siya koda zaske. Harrna hambhidianna, haaqa wul konin dhesimayno yisa aapinkane. ");
INSERT INTO amf_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yedi qarshi naanato, yedi siyana dahayse payya dhalqana haminee dame? Eedi yisa woylaminte thoothora aponka kida giye. ");
INSERT INTO amf_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ea payyaa woylaminte yisa dohon yerin payyara yer payyaam kida giye; ea siyaa woylaminte yisa dohon yerin siyora yer siyaam kida giye. ");
INSERT INTO amf_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Inta yena ida giye: Eeno konin giyen aapin qolmon dhalqin wulsa, pirdin pirdadhea rooroaka malsin ima ko ime. ");
INSERT INTO amf_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ogona hannon dhalqindettsi pirdira dhaqaada dhaqe; way hannon dhalqindettsi hadar koda pirdadhe’’ hamayse kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ogo wodanka Musesa yigginam dhettsayna eenabee Parisa eenabesa waani waani Yesuskal yi giyna: ‘‘Ya Dhettsea, tarshea milkit wona ha dhee wo zagade’’ kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kidi kena yin ki giyade: ‘‘Ko wodanka Barjoam garayno siyono adhadhino tarshea milkit haydhe koda zage. Ta Barjokala qansayse eenna giyea Yoonaasdar yeskon milkitindara milkit ab kona haydhehe. ");
INSERT INTO amf_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yoonaas kaaran gebhonsa iinte rooro makkambee sooti makkambe kinin kappondettsi, yin inta Eedi Naasiar peensa iinte rooro makkambee sooti makkambe ida kappe. ");
INSERT INTO amf_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nenewe katamante dahaana eenaar pirdin rooroaka wodan koka dohon adhadhinbete dhaabhayse kodar keda pirde; harrna hambhidianna, Nenewe katamante dohon eenna Yoonaas Barjosa upsinam kinin giyenka qansayse seeson waadimanam garayse Barjodar ko maatade. Marrato! Yoonaasdara sagea ea kote daane. ");
INSERT INTO amf_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Hayn utensa mizaqimbar dohon peensa binno ko wodanka dohon eenbesana kinka dembhira dhaabhayse pirdin rooroaka kedar koda pirde; harrna hambhidianna, kodi Bitaa Solomoon yisa pakalmakkonka kinin giyenam qansana peensa gasara ko nivade. Marrato! Solomoondara sagea ea kote daane’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yesus yin ki giyade: ‘‘Beero eeddara yinin uton wodanka, ukunse raq zagayse noqoyn qolmon raqinte kida yaaye; ko dahaannaar ukunse raq haapehe. ");
INSERT INTO amf_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ogona ‘Inin uton oonindar isa maatate ida yive’ kida hame. Maatate kinin nivenka onno gidir dehea eedi qolmaka, sahate ashkadhon kida haape. ");
INSERT INTO amf_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ogora yivayse yidara kalon sagaana waani tobbhaana beeronaam yinka entsate nivayse easa iinte ardayse keda dee. Ogonante ea agaasa dayntano ena hamora kalon siyane. Wodan koka dohoono siyono adhadhino ea agaadettsi koda maate’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesus ogoam eenna kinin giyenka kisa indanbee indanaanabe kimbete dhalqana zagayse nivite hatte mayante ke woyade. ");
INSERT INTO amf_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Eedi kalaa Yesusna, ‘‘Shedaa! Handabee handanaanabe mayante woyayse hambete dhalqana keda zage’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesus kina yi giyna: ‘‘Inda kodi hayne? Indanaana kedi haybene?’’ hamayse kina ki maasade. ");
INSERT INTO amf_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ogora aaninka yisa paanan yivayna eenaam dhahayse ‘‘Indabee indanaanabe iginane. ");
INSERT INTO amf_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Cecinte dahaa Imbasa bhocchinam ee hamayse waadadhayna wul isa indabee indanaanabe kedi iginane’’ hamayse kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Agaa rooroaka Yesus oonira utayse bazinsa aponte ki dooqade. ");
INSERT INTO amf_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kikal bukoono eeno konin thoothonna, kidi bazindara sagadhen gonngalante ardayse ki dooqade; eeno wulaar bazinsa aponte ko woyade. ");
INSERT INTO amf_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Thoothi yeram kamsika kena giyan ki yedade: ‘‘Marrato! Eedi kalaa haaminte yisa bheeta yiithota ki utade. ");
INSERT INTO amf_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Bheetan kinin yiithenka, bheetano waani goyn aponte ko wavaysaka aptinaar nivayse kamate ke itsade. ");
INSERT INTO amf_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Waani bheetano thoothin peenin qolmon haachandar ko wavade; pee thoothinin qolmonna saanawa ko baqalade. ");
INSERT INTO amf_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Haynin utayse oydhenkaar, ko halatade; caaciyn yittsaamonna ko wocchade. ");
INSERT INTO amf_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Waani bheetano ukumbhansa shaarinte ko wavade; ukumbhanoar gebhayse baqalon bheetanam ko ishkade. ");
INSERT INTO amf_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Waani bheetano peen payyandar ko wavade, aapiar ushidine; waa kisa aapi eedi dong kaysa, waa kisa pir aapi eedi makkam kaysa, waa kisa pir aapi eedi kalaa kaysa apo tabhi ke ushade. ");
INSERT INTO amf_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Keeda qansen qaamiysa dahaa ki qanse’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ogosa budonte Yesussa paanan yivayna eena kikal theedayse, ‘‘Eenna kamsinka harrnaa giye?’’ hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Kidi kena maasayse ‘‘Yenante Barjo bitamonsa aachin dhalqinam yenin dhesoadettsi imbhidine. Een waanina ko hanna imbhadehe. ");
INSERT INTO amf_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Harrna hambhidianna, yisa dahaana kisa dohondar kina imbha ko imbhe; kinaar mirga ko mirge. Yisa qolmakalanka kisa dohonam kikala tiidha ko tiidhe. ");
INSERT INTO amf_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ogona shedite dahayse shedimina kenin maatonna, qansite dahayse qansimina kenin maatonna, pir kenin bhocchimonna, kena inta kamsika ida giye. ");
INSERT INTO amf_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","‘Eena kina qansa ke qanse, yinin qansenam bhocchehe; sheda ke shede, yinin shedenam qaabehe. Aapinka kenin shedoamadettsi, qaaminka kenin qansoamadettsi, woylaminka kedi qaabayse idar ke maataysaka intaar keam pacchoamadettsi, eena kinasa woylammo duudidine; qammoar kesa qansehe; aapinamaar kedi cumbhidine’ hamayse kesa Isiasin ena birayse giyoono ko thoothade. ");
INSERT INTO amf_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","‘‘Aapin yennonin shedenna, qaamin yennonin qansenna yedi gobshadhaanane. ");
INSERT INTO amf_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Inta yena gon ida giye: Thoothina Barjokala qansayse eenna giyayna eenabee tipana eenabe yenin shedenam shedota anngardhidine, ko dahaannaar shedadehe; yenin qansenam qansana anngardhidine, ko dahaannaar qansadehe’’ hamayse kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Pir Yesus kena yin ki giyade: ‘‘Ta yedi bheetan yiitheasa kamsinsa bulinam qansimate. ");
INSERT INTO amf_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Barjo bitamonsa upsinam qansayse qaabima easa Seethaan nivayse woylaminte kisa yiithadhon upsinam kida tiye; agaa ea goyn aponte wavaa bheetadettsine. ");
INSERT INTO amf_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Peen haachandar yiithadhoono bheetano Barjosa upsinam qansayse saanawa wozanka tiyea eadettsine. ");
INSERT INTO amf_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ea agaa caaci yinin yittsaamonna, kisa woyano likka wodanane; Barjosa upsinna gaale way oytaydha kidar konin yeskenka saanawa kida gare. ");
INSERT INTO amf_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ukumbhansa shaarinte yiithadhoono bheetano Barjosa upsinam qansea eadettsine; yi qansaakaar peen kosa bhocchinbee wodimmakkon anngarmanbeka Barjosa upsino kinin qansoono kisa woylaminte sun ishkimayse aapi ushima koda shidhe. ");
INSERT INTO amf_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Peen payyandar wavaa bheetaa Barjosa upsinam qansayse bhocchika tiyea eadettsine. Agaa ea aapi usha ki ushe; kalaa kisa aapi eedi dong kaysa, waa pir aapi eedi makkam kaysa, waa pir aapi eedi kalaa kaysa apo tabhi keda ushe’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus kamsi ab yin ki giyade: ‘‘Barjosa bitamono haamin yinnonte bheetan payyan yiithaa eadettsine. ");
INSERT INTO amf_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Een wulin raaton wodanka, kisa banqin ea sootinka nivayse bargan yiithadhonsa iinte suwanam yiithayse ki yivade. ");
INSERT INTO amf_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Barganin baqalayse ushenka suwanoar wodan ogoka ko haapadhade. ");
INSERT INTO amf_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Waadadhayna eena haamin imbaakal nivayse, ‘Imbo, haaminte hasa hanin yiithoono bheetano payyatayu? Ta suwano hamora ko nivaa?’ kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Kidiar kena, ‘Ogoam yin hayaa banqin eane’ ki hamade. Kisa waadiman eena kina, ‘Ta hana suwanam yivayse wonin buucoadettsi ya zagaa zago?’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Kidiar kena yin giyayse ki maasade: ‘Yin hayeebhode! Suwanam yenin buucenka barganam kanka yeda buuce. ");
INSERT INTO amf_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ogona garmate; ushayse konin shikadhen wodanka yekka kinka ko gebhe. Ushayse shikadhen wodanka, koam shikayna eenana, ‘‘Suwanam birayse shikee; nuuntear koam koqota kidar buskayse dhaxee. Barganam kidar buskayse kononte isa kee’’ kena hamayse ida giye’ ki hamade.’’ ");
INSERT INTO amf_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesus kamsi ab kena yin ki giyade: ‘‘Barjosa bitamono saliithasa aapi eedi kalaa yisa haaminte kinin yiithon bheetandettsine. ");
INSERT INTO amf_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Bheeta agaa bheetan wulsa iira likkane. Kinin gebhon wodanka haaqana wulsa iira kidi bashine; aptinaar nivayse antindar kisa ooni kenin woysoadettsi haaqa gaari kida maate’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesus kamsi ab kena yin ki giyade: ‘‘Barjosa bitamono maa kallo dhiili sharqa makkam tiyate kanka konin taapaa irshodettsine; irshono konin dhiilin taapon taapanam konin oydhoadettsi ko hayade’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus ogo wulam zarsinna kamsika ki giyade; yinin giyen yerin wulam kamsi qolma kena giyehe. ");
INSERT INTO amf_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ogosa goyno ‘‘Isa dhalqinam kamsika ida dhettse; peen pijadhorra yedayse aachimon yerin ida giye’’ hamayse ena birayse Barjokala qansayse eenna giyea eayn giyondettsi ko thoothade. ");
INSERT INTO amf_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ogosa budonte Yesus zarsinam garayse kidi ooninte ki ardade. Kisa paanan yivayna eena kikal nivayse, ‘‘Imbo, haaminte dohon suwan kamsinsa bulinam wona giyma’’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesus kena yin giyayse ki maasade: ‘‘Bheetan payyan haaminte yiithaa inta Eedi Naasine. ");
INSERT INTO amf_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Hammo peeno konone; payyana bheetana Barjo naanane. Suwana Seethaan naanane; ");
INSERT INTO amf_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","suwanam yiithaa banqin ea Seethaanne. Haaminsa shikan wodano peen kosa macchin wodanone; shikayna Barjosa gaananane. ");
INSERT INTO amf_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ogonante suwanam shikate kidar dhaxayse nuunte koqadheadettsi, peensa macchin wodanka yin koda maate. ");
INSERT INTO amf_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ogo wodanka inta Eedi Naas gaanana innaam nittsayda nittse; kediar seesonsa iinte eenaam arsayna eenabee siyon waadadhayna eena wulbeam isa bitamora edate bulayse ");
INSERT INTO amf_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","dikimon nuunsa iinte keam keda dhabe. Ogotear eepibee atsi qiicabe koda maate. ");
INSERT INTO amf_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ogo wodanka tipana eena Imbaa kenteasa bitamonte haydettsi keda shaake. Qansen qaamiysa dahaa ki qanse’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Guttsayse Yesus yin ki giyade: ‘‘Barjosa bitamono haaminsa iir aachadhaa koymoadettsine. Eedi kalaa ogo koymon haapayse maasate pir ki aachade. Kattsi kinin wozadhonna yivayse yisa dohon wulam shanshayse ogo haaminam ki shanade. ");
INSERT INTO amf_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","‘‘Pir Barjosa bitamono bazira kambhea inqua bazaysa dethaam shanota zagea naggadeadettsine. ");
INSERT INTO amf_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Agaa naggadea bazaysa kattsi dethaa inquam yinin haaponsa budonte, yivayse yisa dohon wulam shanshayse yera agaam ki shanade’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Guttsayse Yesus yin ki giyade: ‘‘Barjosa bitamono bazinsa iinte dhabadhaysaka kaaran ayni waana waana hamonam yeden zaanindettsine. ");
INSERT INTO amf_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Zaaninte kaaranin thoothonsa budonte eena bazinsa gasandar gochate keda bule. Dooqayse konin yedonsa iira payyan payyanam edate kenin bevente keda wode; siyon siyonam os keda dhabe. ");
INSERT INTO amf_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Peensa macchin wodanka yin koda maate; Barjosa gaanana nivayse siyana eenaam tipana eenakalanka eda ke ede. ");
INSERT INTO amf_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Dikimon nuunsa iinte keam keda dhabe. Ogotear eepibee atsi qiicabe koda maate. ");
INSERT INTO amf_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","‘‘Ogo wulam yedi bhocchidu?’’ kena ki hamade. Kediar, ‘‘Wodi bhocchidine’’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kidiar, ‘‘Ogo yin ko hanna, Barjosa bitamon goynsa payya hayayse dhesea Musesa yigginam dhettsea yinnon koymora haalinbee gecchonbeam bulea imbaadettsine’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesus igina kamsinaam giyate kinin macchonsa budonte, raqin ogora ki yivade. ");
INSERT INTO amf_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ogora yinin gebhon peente Naazret katamandar nivayse kesa bukin raqinte Barjosa upsinam dhettsite ki dahade. Eeno kisa dhalqinka targadhayse, yin giyte ko dahade: ‘‘Kaa ea pakalmakkon kobee ko eenaam tarshen yerinbeam hamora ki bavaa? ");
INSERT INTO amf_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kaa haaqan qarsea ea naasitayu? Indaano kisa Mayriyam hambhaynotayu? Kisa indanaana Yayqoobbee, Yoseepbee, Simoonbee, Yiwdabetayu? ");
INSERT INTO amf_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kisa indanaana anzana wul wombete dahaanatayu? Ta ea kaa ko wulam hamora ki haapaa?’’ hamayse ");
INSERT INTO amf_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","kisa dhalqinam bagayse tiyma ke garade. Yesus ‘‘Barjokala qansayse eenna giyea kinin gobshadhimino peen een yinnonbee oonin eena yinnabekal bishne’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kinin giyenam gonne hamayse kenin tiyaamonna, Yesus raqin ogote thoothi tarshea yer hayadehe. ");
INSERT INTO amf_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ogo wodanka Galila peenam wottsea Herodis Yesussa tarshen waadimanam ki qansade. ");
INSERT INTO amf_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Yisa waadiman eenanaar, ‘‘Kaa Shivea Wannisne; kidi diira dhaabhidine. Ko tarshen waadiman wulam waadadhana kantan kinin haapoono ogokane’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herodis ena iishima Pilbhoos geshon Herodiyadaam ki keemade. Ogo wodanka Wannis Herodisna ‘‘Hambanaasa geshonam keema haam zaskehe’’ kinin hamonna, Herodis kiam yettsate dhaxin ooninte ki dhaskade. ");
INSERT INTO amf_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Pir Wannisam deesana zagite ki dahade; eeno wul Wanniska ‘‘Barjokala qansayse eenna giyeane’’ konin hamonna, eenna kurtumbhayse ki garade. ");
INSERT INTO amf_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Bitaa Herodisin adhadhaa rooroayn gobshadhea sedhaaka, Herodiyadasa naano nivayse een kummanna eldhonsa birante yiigaate konin kirbenka Herodisam ko wozisade. ");
INSERT INTO amf_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Herodis wozadhayse kona, ‘‘Iam hanin oyson yerinam hana imayda ime’’ hamayse kona ki malla ardade. ");
INSERT INTO amf_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Naanoar indankal dhalqayse, ‘‘Shivea Wannissa metenam taxate sharqaka ina taaki imaa’’ kina ko hamade. ");
INSERT INTO amf_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Bitaar qaabeka yi ataakaar, kimbesana kinka kummandar dooqaana eenasa birante kona malla kinin ardonna, konin zagonam kona haydhoadettsi ki giyade. ");
INSERT INTO amf_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Eedi yittsayse dhaxin ooninte Wannissa metenam ki taskisade. ");
INSERT INTO amf_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Taxadhaa meteamaar sharqaka bavate naanna ke imade; naanoar bavate indanna ko imade. ");
INSERT INTO amf_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Wannissa paanan yivayna eenaar nivayse kisa leesinam tiyate ke duukade; ogoraar yivayse Wannisin diyonam Yesusna ke giyade. ");
INSERT INTO amf_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesus Wannissa dembhinam kinin qanson wodanka, bazindara sagadhen gonngalante ardayse raq eedinin qolma kalaate yimal ki yivade. Eenoar ogoam konin qanson wodanka, katamana yinna yinnara utayse kikal rooka ko yivade. ");
INSERT INTO amf_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesusaar bazindara sagadhen gonngalara utayse thoothin eenam haapayse kona ki burqadhade; hajadhaana eenaamaar ki pacchade. ");
INSERT INTO amf_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Peenin sootenka Yesussa paanan yivayna eena kikal nivayse, ‘‘Kono ranqo eedinin gidir qolminone; peenoar sootidine. Ogona zarsino kono wosa gasante dahaana gurdanadar yivayse gala konin shanoadettsi koam yittsaa’’ kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesus kena yi giyna: ‘‘Yedi kenin itsen galan kena imee; kenin yivoadettsi keam zaskehe’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Yesussa paanan yivayna eenaar kina maasayse ‘‘Wokal balasha dongbee kaara lamaabe bish dahade’’ hamayse kina ke giyade. ");
INSERT INTO amf_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesus kena ‘‘Iginaam ina ora bevee’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ogosa budonte een wulka ‘‘Shudhindar dooqee’’ ki hamade. Yesus balashana dongnabee kaarana lamaanabeam tiyayse tura cecin shedayse Barjoam miskeka ki gobshade. Balashanamaar qunthayse yisa paanan yivayna eenana ki imade; kisa paanan yivayna eenaar eenna ke imade. ");
INSERT INTO amf_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Eeno wulaar itsayse ko mishade. Ke itsaysaka shidhoono Yesussa paanan yivaynayn thoosayse dhaasoono dirmano sharqa tabhi lamaane. ");
INSERT INTO amf_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Itsoono eeno maanabee naanabe paydadhima anngina bish shii dongaddhane. ");
INSERT INTO amf_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ogosa budobar saanawa Yesus yisa paanan yivayna eenana, ‘‘Eenaam onnadar inin yittsenka, yedi bazindara sagadhen gonngalanka iam birayse bazira sus sagee’’ ki hamade. Ogora kidi eenaam onnadar ki yittsade. ");
INSERT INTO amf_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kidi eenaam yinin yittsonsa budonte, Barjo misko yimal dhukandar ki utade; peenin sootenka Yesus ogote yimal ki dahade. ");
INSERT INTO amf_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ogo wodanka Yesussa paanan yivayna eena yingir dohoono gonngalano bazinsa gidinte ko daaka, wurano bazindar dhaabhayse gonngalanam kenka osbee orabe jugite ko dahade. ");
INSERT INTO amf_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Sootin peen sedhamba tiibh hamenka, Yesus bazindar rooka tigate kisa paanan yivayna eenakal nivite ki dahade. ");
INSERT INTO amf_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kisa paanan yivayna eenaar Yesus bazindar rooka tigate kinin nivenka kiam haapayse kattsi targadhayse gibazada ‘‘Kaa meeshine!’’ hamayse kurtumbhayse ke ilatade. ");
INSERT INTO amf_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesus saanawa kena ‘‘Hay! Intane; kurtumbheebhode’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ogo wodanka Bhethiroos ‘‘Imbo, ya hanna, bazindar rooka tigate hakal i nive ina giyaa’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesus kina ‘‘Nivima’’ ki hamade. Bhethiroos gonngalara utayse Yesuskal bazindar rooka tigate ki yivan yedade. ");
INSERT INTO amf_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ko dahaannaar Bhethiroos bazindar jibarshen wuranam shedayse ki kurtumbhade; bazinoar kiam itsamba konin hayenka, ‘‘Imbo, iam dhacchima!’’ hamayse ki ilatade. ");
INSERT INTO amf_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesus saanawa aanin yisa pishkayse kiam yedayse hatte, ‘‘Ya idar woylamin hanin qajensa goyn joogaa, harrnaa qothimaa?’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ogora Yesusbee Bhethiroosbe bazindara sagadhen gonngalante kenin ardenka, wurano jibarshan ko garade. ");
INSERT INTO amf_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ogo bazindara sagadhen gonngalansa iinte dahaana eena ‘‘Gon ya Barjo Naasine’’ hamayse kina ke goodimade. ");
INSERT INTO amf_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yesusbee kisa paanan yivayna eenabe bazinam sagayse Gensareth peendar ke yivade. ");
INSERT INTO amf_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ogo peente dohoono eeno Yesus kinin dohonam konin dheson wodanka, kosa gasambar theedin dohon gurdan eendar apo yittsayse hajadhon een wulam kidar ko bavsade. ");
INSERT INTO amf_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Hajadhoono eeno Yesuskal ‘‘Apalansa hasa nukinam hattear wo kaame’’ hamayse kiam koda miske; kisa apalansa nukinam kaamaana eena wul hajimora paashidine. ");
INSERT INTO amf_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ogo wodanka Parisa eenabee Musesa yigginam dhettsayna eenabe Yerusaalemra dhaabhayse Yesuskal hatte yin giyayse kiam ke oysade: ");
INSERT INTO amf_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","‘‘Hasa paanan yivayna eena ena eykenasa dambinam kenin toolimino harrnane? Aaninam shiidhima galan keda itse’’ kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesus kena yin giyayse ki maasade: ‘‘Yedisin yennon dambin toolota hamayse Barjoyn giyonam yenin toolimino harrnane? ");
INSERT INTO amf_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Barjo yi giyna: ‘Hambabee handabeam gobshaa’ pir, ‘Imbaabee indanbeam iirea ki deesadhe’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yedi ‘Eedi hayyear imbaabee indanbena ‘‘Yeam inin kelshen yerin inta Barjona iminto hayayse imidine’’ ki hamanna, ");
INSERT INTO amf_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ea kaa keeda lansi imbaabee indanbeam ki kelshabhoode’ yeda hame. Ogo goynka yedi dambin yennon toolota Barjoyn giyonam yeda gare. ");
INSERT INTO amf_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","9","Yedi maltinato, ena Barjokala qansayse eenna giyea Isias Barjoyn giyonam, ‘Kina eena yisa aponka bish ke iam gobshe; woylammo kesa ikalanka kattsi pegimbhidine. Eenin bulon dambinam Barjoyn bulaa yiggidettsi hayayse eenaam dhettsaate sun guuri ina keda goodime’ hamayse ena yennon goynam kinin giyoono gonne’’ hamayse Yesus kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ogora Yesus eenaam yikal eelayse, ‘‘Qansimate; woylaminkaar yesa payya hayayse qaabee. ");
INSERT INTO amf_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Eediam minngisayno yerro eedisa apora utaynone; iinte ardaynotehe’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ogosa budonte Yesussa paanan yivayna eena Yesuskal theedayse, ‘‘Parisa eena ogo hanin giyonam qansayse hanka kenin gemmonam ya dhesidu?’’ hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesus kena yin giyayse ki maasade: ‘‘Cecinte dahaa Imbayn koraamma yerra wul buucima ke buucime. ");
INSERT INTO amf_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Garmate! Kedi aapin kayaanaam entsayna aapin kayaanane. Aapin kayaa ea aapin kayaam entsea ki hanna, kedi lamaana oolonte keda dhambe’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Bhethiroos Yesusna ‘‘Kamsinsa bulinam wona giyma’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesus kena yin ki giyade: ‘‘Yedi ta koka yekka qaabe yininsa qolminaw? ");
INSERT INTO amf_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Aponte ardayno yerro wul iinte ardayse ora mayandar konin utenam yedi dhesattenu? ");
INSERT INTO amf_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Apora utayno ko hanna, woylamra koda ute; eediamaar minngisayno ogonone. ");
INSERT INTO amf_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Woylamra utayno siya qaabobee, eediam deesintabee, sharmucimakkobee, dimmakkobee, buudamo dhalqbee, wuupobene. ");
INSERT INTO amf_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Eediam minngisayna iginane; aanin shiidhima itsinta eediam minngisehe’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesus ogo raqira utayse Thiroosbee Sidoonabe peendar ki yivade. ");
INSERT INTO amf_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ogo peente Kanaan eedi maatoono maa kallo Yesuskal nivayse, ‘‘Imbo, Dawt Naasa, naan innonam beero yedaysaka gaalite ko dahade; ogona ina burqadhayse koam pacchaa’’ hamayse ilataate kiam ko miskade. ");
INSERT INTO amf_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesus kona yer yinne hamima lay ki hamade. Ogo wodanka Yesussa paanan yivayna eena kikal theedayse, ‘‘Kono edono wosa paananka nivite konin ilatenna, bannzo koam yittsima’’ hamayse kiam ke miskade. ");
INSERT INTO amf_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kidiar, ‘‘Inta inin nittsadhoono yaatidettsi kayaana Israveel eenana bishne. Eedi abnatehe’’ hamayse ki maasade. ");
INSERT INTO amf_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Edono Yesussa roonkal kumpurdhayse, ‘‘Imbo, bannzo! Iam kelshima’’ hamayse kiam ko miskade. ");
INSERT INTO amf_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesus kona maasayse ‘‘Naanasa galanam tiyayse qaskinana dhaba zaskehe’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kodiar ‘‘Imbo, gonne; imbaanin itsenka diinenam qaskina itsa ke itse’’ ko hamade. ");
INSERT INTO amf_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ogona Yesus kona yi maasina, ‘‘Ya kono mayno, idar woylamin hanin qajayno goyno hasa gebhine; ogona hanin zagondettsi ko hana maate’’ kona ki hamade. Agaa wodaaka naano saanawa ko paashade. ");
INSERT INTO amf_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesus raqin ogora dhaabhayse Galila bazinsa aponte ki nivade; ogotear dhukandar utayse ki dooqade. ");
INSERT INTO amf_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Thoothino eeno eena roonsa wobonabee, aylanabee, aapin kayaanabee, apon kayaanabee, hajadhon een waanibeam bavate Yesusdar nivayse kisa roon dementear ko wodade; Yesusaar keam pacchidine. ");
INSERT INTO amf_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Eeno eena apon kayaana kenin dhalqenam, eena aylanaar kenin paashenam, wobona eenaar payya kenin yaayenam, aapin kayaana eenaar kenin haapenam konin haapenka, targadhayse Israveel Barjoam ko gobshade. ");
INSERT INTO amf_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesus yisa paanan yivayna eenaam eelayse, ‘‘Eeno kono imbesana rooro makkam dooqayse konin itsea yer kosa qolmonna, inta kona burqadhidine; goynte shiitayse konin dhamboamadettsi ko itsima koam yittsana nashaatine’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yesussa paanan yivayna eena kina maasayse ‘‘Ta een koaddha hamonna yeekea gala ko eenin qolmon raqira hamora ko haapadhe?’’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesus ‘‘Balasha meemayne yekal dahaana?’’ hamayse keam ki oysade. Kediar ‘‘Balasha tobbhaabee kaara shaaqa tokaa waanibe wokal dahade’’ kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ogora Yesus eenka ‘‘Peendar dooqee’’ hamayse ");
INSERT INTO amf_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","balashana tobbhaanabee kaaranabeam tiyayse Barjoam miskeka gobshayse qunthate yisa paanan yivayna eenana ki imade; kisa paanan yivayna eenaar eenna ke imade. ");
INSERT INTO amf_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Eeno wul itsayse ko mishade. Ko itsaysaka shidhoono dirmano Yesussa paanan yivayna eena sharqa tobbhaa thoosayse ke dhaasade. ");
INSERT INTO amf_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Itsoono eeno maanabee naanabe paydadhima anngina bish shii oydine. ");
INSERT INTO amf_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ogosa budonte Yesus zarsinam yittsayse kidi bazindara sagadhen gonngalante ardayse Megedoon peendar ki yivade. ");
INSERT INTO amf_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisa eenabee Saduqa eenabe Yesuskal nivayse, ‘‘Barjo haam kinin nittsonam woninkay dhesea tarshea milkit wona hayaa’’ hamayse kiam taysate shedota zagayse ke oysade. ");
INSERT INTO amf_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kidi kena maasayse yin ki giyade: ‘‘Peenin ibanenka, ‘Cecino ciilidine; doobi qanehe’ yeda hame. ");
INSERT INTO amf_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Burin pir cecinin poldhenka ‘Peeno poldhayse thipidine; kina doobi qanasane’ yeda hame. Peensa dantan goynam cecin shedayse yeda dhese; wodansa milkitino har konin dhehen shedayse dhesano yeam bashidu? ");
INSERT INTO amf_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ko wodanka Barjoam garayno siyono adhadhino tarshea milkit haydhe koda zage. Yoonaasdar yeskon milkitindara milkit ab kona haydhehe’’ hamayse keam garayse ki yivade. ");
INSERT INTO amf_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesussa paanan yivayna eena balasha yinka bavima walayse bazinsa saabar ke sagade. ");
INSERT INTO amf_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesus ‘‘Shedee! Parisa eenabee Saduqa eenabesa irshora mete yesaam gishimate’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kediar ‘‘Ogono yin kinin giyoono balashayn wonka bambha walayse wonin nivon goynsane’’ hamayse kinka ke dhalqade. ");
INSERT INTO amf_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesus kesa qaabenam dhesayse kena yin ki giyade: ‘‘Yedi idar woylaminin qajadhen goyn joogaanato, balashanin yesa qolmonna harrnee kikal dhalqe? ");
INSERT INTO amf_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Akar bhocchattenu? Balasha dongnam shii dongin eenaam kunsate micchayse shidhoono dirmano yenin dhaasoono sharqa meemay konin dohoono yena bhoqayu? ");
INSERT INTO amf_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Yin tapir balasha tobbhaanaam shii oydin eenaam kunsate micchayse shidhoono dirmano yenin dhaasoono sharqa meemay konin dohoono yena bhoqayu? ");
INSERT INTO amf_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","‘Parisa eenabee Saduqa eenabesa irshora mete yesaam gishimate’ yena inin hamoono balashan goynkatay konin dohonam yedi hamin ye bhocchimine?’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kediar ‘‘Parisa eenabee Saduqa eenabeyn dhettserra mete yesaam gishimate’’ kinin hamoono gon balashasa irsho goytikatay konin dohonam ke dhesade. ");
INSERT INTO amf_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesus Pilbhisoos Qesaaria peente kinin yeskon wodanka, yisa paanan yivayna eenana ‘‘Eeno i Eedi Naaseam hay koda hame?’’ hamayse keam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kediar ‘‘Waani eeno ‘Shivea Wannisne’ koda hame; waani eenoar ‘Eeliasne’, waani eenoar ‘Ermeas way Barjokala qansayse eenna giyayna eenasa kalaane’ koda hame’’ kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesus kena ‘‘Yedi iam hay yeda hame?’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Bhethiroos hambhea Simoon kina yinin maasenka, ‘‘Ya Barjoyn qadhaa Kiristoos, lay dehea Barjosa Naasine’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesus maasayse kina yin ki giyade: ‘‘Ya Yoona naasa Simoono, ogoam hana dhettsoono eeditehe, cecinte dahaa Imbane; ogonante ya gobshadhaane. ");
INSERT INTO amf_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Inta hana ida giye: Ya Bhethiroos seenine; seenin laytan kodar inta isa misken oonin ida woyse; koam dembhisa kanta ko hannaar bashehe. ");
INSERT INTO amf_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Barjosa bitamon kerinam bulen qulpin hana ida ime; peente hanin dhaxaana wul cecinte dhaxadhaana keda maate; peente hanin bulaana wul cecinte buldhaana keda maate’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ogora Yesus yisa paanan yivayna eenana ‘‘Barjoyn qadhaa Kiristoos inin dohonam eedina giyeebhode’’ hamayse upsi kantaka ki giyade. ");
INSERT INTO amf_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ogo wodara yedayse Yesus yisa paanan yivayna eenana yi giyna: ‘‘Yerusaalemdar yivayda yive. Ogote peensa donzanabee, gudullasa hayonabee, Musesa yigginam dhettsayna eenabe thoothi gaale idar yeskisa ke yeskise; iam deesa ko deesadhe. Dembhiraar makkansoa rooroaka dhaabhayda dhaabhe’’ hamayse yidar yesken yerinam kena may giyan ki yedade. ");
INSERT INTO amf_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Bhethiroosaar kiam yimal entsate yivayse, ‘‘Imbo, ogono yin maatehe; ogono hadar ko yeskabhoode’’ hamaate kiam waciman ki yedade. ");
INSERT INTO amf_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesus kidar wal hamayse ‘‘Ya Seethaan, isa aapira os yivaa! Barjoyn qaabenam hanin qaabiminna, eedinin qaabenam hanin qaabenna, ina ya goane’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ogosa budonte Yesus yisa paanan yivayna eenana yin ki giyade: ‘‘Isa paanan nivana nashea hay ki dahaannaar, yinnon qaaben ki gare; yinindar ziitate deesadhen masqalinam kedayse isa paanan ki nive. ");
INSERT INTO amf_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sadan yinnonam dhacchana nashea hay ki dahaannaar koam kaysa ki kayse; ina hamayse sadan yinnonam kaysea hay ki dahaannaar koam haapa ki haape. ");
INSERT INTO amf_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Eedi peen kodar dohon yer wulam haapayse sadan yinnonam kaysidi ki hanna, kina har ko poote? Way eedi yisa sadanna baza yer har ki kashe? ");
INSERT INTO amf_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Inta Eedi Naas Imbasa gobshinka kisa gaananabesana nivayda nive; ogo wodanka een wulna kesa waadimandettsi kena bazan ida kashe. ");
INSERT INTO amf_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Inta yena gon ida giye: I Eedi Naas bit maatayse inin nivenam kenin haapenka yekka kote woyaana eenasa shaarinte dembhi diymina eedi daane’’ hamayse kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yesus ogoam yinin giyonsa budobar laskoa rooroaka Bhethiroosbee, Yayqoobbee, Yayqoobsa indanaasa Wannisbeam yinka entsate dhukan gudubhondar ki utade. ");
INSERT INTO amf_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Raqin ogotear Yesussa dantano kesa birante ko ookimade; kisa aapin kerroar haydettsi ko shaakade; kisa apalloar kattsi cawlayse shaakadettsi ko maatade. ");
INSERT INTO amf_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Marrato! Musebee Eeliasbe Yesusbesana kinka kenin dhalqenka, kisa paanan yivayna eenana ko haapadhade. ");
INSERT INTO amf_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Bhethiroos Yesusna yi giyna: ‘‘Imbo, raqin kote wonin dahayno wona payyane. Ha nashea hanna, baara kalaam hana, kalaam Musena, kalaam Eeliasna hayayse makkam i kee’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Bhethiroosaar ogoam yin kinin giyenka, liilo kattsi cawli keam ko ishkade. Liilonsa iir ‘‘Ininka wozadhea inin nashea isa Naasa kaane; kina qansee’’ hamea upsi ko qansimade. ");
INSERT INTO amf_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yesussa paanan yivayna eenaar upsin ogoam qansayse kattsi kurtumbhayse wotinka yisa peendar ke dhambade. ");
INSERT INTO amf_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesus kekal hatte yisa aaninka keam kaamayse, ‘‘Dhaabhee, kurtumbheebhode’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kediar metenka dheg hamayse kenin shedenka, Yesus bishkalanka eedi ab haapadehe. ");
INSERT INTO amf_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Dhukara kenin hanchenka, Yesus kena yi giyna: ‘‘I Eedi Naas dembhira inin dhaabhenka yekka ta yenin haapon koam eedi haynaar giyeebhode’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kisa paanan yivayna eenaar kina yi giyna: ‘‘Ta keeda Musesa yigginam dhettsayna eena ‘Birayse niva zaskea Eeliasne’ harrna ke hamaa?’’ hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesus kena yinin maasenka, ‘‘Ogono gonne; Eelias birayse niveane; kidi yer wulam ashka ki ashke. ");
INSERT INTO amf_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ko dahaannaar inta yena ida giye: Eelias kosa birayse nividine. Eeno kiam konin dhesaamonna, yinin nashon yerin wulam kidar ko hayade. Ogodettsi ta i Eedi Naas gaalenam kekalanka tiyayda tiye’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ogo wodanka Yesussa paanan yivayna eena Yesus Shivea Wannissa kinin giyonam ke dhesade. ");
INSERT INTO amf_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesusbee makkamma kimbesana dahaana eenabe thoothin eenkal nivite kenin yeskenka, eedi kalaa Yesussa birante hatte kumpurdhayse, ");
INSERT INTO amf_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","‘‘Imbo, bannzo! Isa naasana burqadhayse pacchaane. Rum kiam yedoono kattsi dhabite galshaynone; dhaabha ko hanna, thoothi wodaka nuunbee noqonbesa iir koda kiam dhabe. ");
INSERT INTO amf_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Hasa paanan yivayna eenakalar inta kiam bavate nividine; ko dahaannaar kedi pacchana kiam damadehe’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesus kina yinin maasenka, ‘‘Yedi idar woylamin qajimina, bhocchinka yesa wobaana adhadhinato, hamaaka yekka yembesana ida dee? Yena hamaaka yekkay darsho? Yinda naasaam ora ikal bevee!’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesusaar beeronam ki bitade. Beeronoar naasadara ko utade; naasaar saanawa ki paashade. ");
INSERT INTO amf_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ogosa budonte Yesussa paanan yivayna eena Yesus yimal kinin dohonte kikal nivayse, ‘‘Beeronam bulana wonin damaammo harrnane?’’ hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesus kena yin ki giyade: ‘‘Barjodar woylamin yenin qajen goynin yesa joogonnane. Inta yena gon ida giye: Saliithasa aapiaddha hama idar woylam yenin qajea goyti yesa daa ko hanna, dhukan koka ‘Kaara saa agaadar yivaa!’ kanka ye hamidianna, yena yiva ko yive. Yeam bashear yer qolehe. ");
INSERT INTO amf_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kodettsino beerono itsima Barjoam miskinta goytikatay hamidi ko hanna, utehe’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesussa paanan yivayna eena Galila peente Yesuskal ke bukaysaka kena yin ki giyade: ‘‘I Eedi Naasaam eensa aaninte saskate iam koda imbhe; ");
INSERT INTO amf_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","iamaar deesa ko deesadhe; intaar makkansoa rooroaka diira dhaabhayda dhaabhe’’ ki hamade. Kisa paanan yivayna eenaar ogo kinin giyonam qansayse kattsi ke qaabeka atade. ");
INSERT INTO amf_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ogora Yesusbee kisa paanan yivayna eenabe Qipirnaahoom katamante ke yeskaysaka, Barjosa gazan ooninna gibirin kacchayna eena Bhethirooskal nivayse, ‘‘Yeam dhettsea ea agaa gibirin kashayu?’’ hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Kidiar ‘‘Kasha ki kashe’’ kena ki hamade. Ooninte ki ardaysaka Yesus birayse kina ‘‘Simoono, hana har ko maate? Peen kodar bitimayna eena gibirin kenin kacchen een hamokalanka ke kacche? Peen eenkalankamoo? Een peen eenkalaw?’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Bhethiroosaar ‘‘Een peen eenkala tiya ke tiye’’ ki hamaysaka, Yesus ‘‘Ta ogo yin ko hanna, peen eena kenna gibirin kashehe hamintane. ");
INSERT INTO amf_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ko dahaannaar kena goa wonin maatoamadettsi bazinte yivayse kaara kalaa yedea zaaniam gidir dhabaa. Birayse hanin yedaa kaarasa apon wavshayse ogote koymo haapaada haape; agaam tiyayse imbee hambena hamayse kena imaa’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ogo wodanka Yesussa paanan yivayna eena kikal nivayse, ‘‘Barjosa bitamonte wuldara sagi maatea hayne?’’ hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kidi naasi kalaam yidar eelayse kesa shaarinte woysayse ");
INSERT INTO amf_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","yin ki giyade: ‘‘Inta yena gon ida giye: Naasidettsi maatayse ye ookimaamma Barjosa bitamonte yer hamin hambhaakaar ardattene. ");
INSERT INTO amf_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ogona naasa kaadettsi yiam toskea Barjosa bitamon raqinte wuldara sagi maatea kidine. ");
INSERT INTO amf_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kaa naasadettsi naasa kalaam isa naabenna hamayse tiyea iam ki tiyade. ");
INSERT INTO amf_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","‘‘Idar woylamin qajayna igina likkanasa iira kalaana goa maatea eedi hayyear deesime seeni gaari kisa qorcindar dhaxayse bazinte kiam dhabadhaysaka ki itsadhidianna, kina payyane. ");
INSERT INTO amf_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Eenna goa maaten peen kona hay! Hamin ko dahaakaar eenna goa maatea yer nivima shidhehe; ko dahaannaar eenin gemmoadettsi hayea eana hay! ");
INSERT INTO amf_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","‘‘Ogonante anno hanno way roono hanno hana goa maatea ko hanna, taxate hakalanka koam dhabaa. Aan lamaaka way roo lamaaka dahayse rooro wul lay dikimon nuunte haam dhabadhenna, gundi dahayse sadanka daadhen raqinte hanin ardayno hana payyane. ");
INSERT INTO amf_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Aapino hanno hana goa maatea ko hanna, bulayse hakalanka koam dhabaa. Aapi lamaaka dahayse lay dikimon nuunte haam dhabadhenna, aapi kalaka dahayse sadanka daadhen raqinte hanin ardayno hana payyane. ");
INSERT INTO amf_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","‘‘Kina likkanasa iira kalaam hattear yenin bagoamadettsi mete yesaam gishee! Naana kinaam gishayna Barjosa gaanana cecinte dahaa Imbasa birante rooro wul keda woye. ");
INSERT INTO amf_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","I Eedi Naasisa nividino kayaanaam dhacchanane. ");
INSERT INTO amf_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","‘‘Ta yena har ko maate? Eedi dong kaysa yaanaysa dahaa ea igina yaanasa iira yaati kala kaydianna, eedi oydi kaysa apo tabhi salla yaanaam dhukandar garayse kayaam zagate yivaaw? ");
INSERT INTO amf_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Inta yena gon ida giye: Haapa ki hanna, eedi oydi kaysa apo tabhi salna kayaamma yaanadara sagi hayayse yaan kayayse haapadhonka kida wozadhe. ");
INSERT INTO amf_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ogodettsi igina likkanasa iira kala kayoadettsi cecinte dahaa yesa Imbaa zagehe. ");
INSERT INTO amf_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","‘‘Aananta hantea haam genidi ki hanna, hambee kimbe bish maatayse kisa seesonam kina giyaa. Hana qansea ki hanna, pir hasa kiam aanamoa hayade. ");
INSERT INTO amf_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","‘Hanin giyenam qansattine’ ki hamanna, eedi lamaa way eedi makkamsa tarja zaskenna tapir kalaa way lamaa hanka tiyayse daran yivaa. ");
INSERT INTO amf_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Iginanaar ki qansaamma, misken ooninte dahaana eenana kisa waadimanam giyaa. Misken ooninte dahaana eenana ki qansaamma Barjoam dhesimina eenabee cubbona gibirin kacchayna eenabedettsi maasayse kiam paydaa. ");
INSERT INTO amf_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","‘‘Inta yena gon ida giye: Peente yenin dhaxaana cecintear dhaxadhaana keda maate; peente yenin bulaana cecintear buldhaana keda maate. ");
INSERT INTO amf_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Tapir inta yena gon ida giye: Yesa iira eedi lamaa peendar yer harrnaar qaabe kalaaka agayse kinka ke miskanna, cecinte dahaa Imba kesa miskenam kena ima ki ime. ");
INSERT INTO amf_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Harrna hambhidianna, lamaa way makkam maatayse isa naabenka yenin bukon raqinte intaar yembesana kinka ida maate’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ogo wodanka Bhethiroos Yesuskal theedayse, ‘‘Imbo, aananta intea iam genidi ki hanna, meemay goyt kina garinta ko iam zaske? Tobbhaa goyt kina yeeka ko yeeko?’’ hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesusaar yin giyayse kina ki maasade: ‘‘Eedi makkam kaysa apo tabhi tobbhaa goyt yekka kina garma ida hame; tobbhaa goyt bish garaa hana hamattine. ");
INSERT INTO amf_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","‘‘Ogona Barjosa bitamono yisa waadimaynadar baza meemay dohonam dhesana zagaa bitaam koda maate. ");
INSERT INTO amf_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Birayse kinin eelaana eenasa shaarinte eedi kalaa paydadhaka maqimon bazanindar dahaam entsate hatte kisa birante ke woysade. ");
INSERT INTO amf_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ea agaa bazanam kashota koymon kinin kayson goynka kiam wottsea ea yi giyna: ‘Eabee, geshonbee, naanabee, kisa yerra dahaana wulbeam shanshayse daran isa dohon bazan innonna ina bevee’ hamayse yisa waadiman eenana ki giyade. ");
INSERT INTO amf_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Waadiman ear kiam wottsea easa buqon yedayse, ‘Imbo, bannzo ina wodhaa; inta wulam hana kashayda kashe’ hamayse kiam ki miskade. ");
INSERT INTO amf_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Agaa kiam wottsea ear kina burqadhayse kidar dohon bazan wulam kina ki garade. ");
INSERT INTO amf_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","‘‘Ea agaa kiam wottsea eakala yinin utenka, kimbesana kinka waadadhayna eenasa eedi kisa aanamo kalaa kikalanka birre mato kalaa bazimaam haapayse, ‘Bazan innonam ina kashaa!’ hamayse kisa qorcinam cuuqayse ki yedade. ");
INSERT INTO amf_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Aananta agaa kintea kisa buqon yedayse, ‘Bannzo ina wodhaa; inta hana kashayda kashe’ hamayse kiam ki miskade. ");
INSERT INTO amf_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kidiar ‘Inta zagattine; ina ta kashaa’ hamayse bazanam kina kashate kinin macchenka yekka dhaxin ooninte kiam ki dhaskade. ");
INSERT INTO amf_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kimbesana waadadhayna waani ogo yin kinin hayenka haapayse kattsi burqadhayse keam wottsea eana yivayse ogo wulam ke giyade. ");
INSERT INTO amf_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ogoraar wottsea ea kiam elsayse, ‘Ya kaa siya ea, bazan innon hadar dohonam iam ha miskaysaka inta hana bazan innon wulam garidine. ");
INSERT INTO amf_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Inta hana burqadhayse inin garondettsi, yaar yin aananta hanteana burqadhayse kidar dohon bazanam kina garinta ko haam zaske’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ogo goynka kiam wottsea ea daran wacimayse, kina kinin garon bazan wulam kashate kina kinin macchenka yekka dhaxin ooninte galshayna eenana kiam yedate ki imade. ");
INSERT INTO amf_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","‘‘Yennon shaarinte aananta yinteana kisa seesonam woylam wulka garma eedi dahaa ki hanna, cecinte dahaa Imba kidar agaadettsi kida haye’’ hamayse Yesus kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesus dhalqin ogoam kinin macchonsa budonte, Galila peera dhaabhayse Yordaanoos baynsa saabar dohon Yiwda peendar ki yivade. ");
INSERT INTO amf_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Thoothino eeno kisa paanan konin yivenka, kesa iira hajadhaana eenaam raqin ogote ki pacchade. ");
INSERT INTO amf_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ogo wodanka Parisa eena kikal nivayse kiam taysate shedaate ‘‘Eedi geshon yinnonam yer har goytika ko hannaar, koam bulayse kinin yittsoadettsi Musesa yigginte giidhidu?’’ hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesus kena yinin maasenka, ‘‘Barjo birayse ‘Anngibee maabe hayayse keam ki pijade’ hamen Barjosa upsinam yedi nabbabeete? ");
INSERT INTO amf_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Pir Barjo ‘Ogonante eedi imbabee indabeam gara ki gare; geshon yinnonbete kinka kida dee; kedi lamaanaar waa kalaa keda maate’ hamayse ki giyade. ");
INSERT INTO amf_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kedi keeda kaara os waa kalaa keda maate, lamaa maatehe. Ogona Barjo kidar kalaa kinin hayonam eedi ko kidara edabhoode’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Parisa eena kina yi giyna: ‘‘Yin ko hanna, Muse ena ‘Eedi geshonam yinin bulenka, bulayse yinin oytensa tarja maatea warqat kona imayse ki bule’ harrna ki hamaa?’’ hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Kidiar kena yinin maasenka, ‘‘Muse maana yennaam ye bule kinin giyoono yedi woylaminka yesa Barjona ee hamimina yenin dohonnane; ena birayse yintehe. ");
INSERT INTO amf_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Inta yena ida giye: Eedi hay ki hannaar, sharmucimakko goytika dayma geshon yinnonam bulayse maa ab keemea kidi sharmucimidine; geshoayn bulon edonam keemea ear sharmucimidine’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yesussa paanan yivayna eena yi giyna: ‘‘Anngibee maabesa kinka dayntan goyno yin ko hanna, maa keemima daadhayno payyane’’ kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesus kena yin ki giyade: ‘‘Maa keemima daadhayno yinnante eena imbhaananane; een wulnatehe. ");
INSERT INTO amf_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ogonoar yin konin dohoono kenin adhadhenka eedi buu maataana daane; eediyn buunsaanaar daane; Barjosa bitamonna hamayse keemima daana zagaana eedi waaniar daane. Ogona tiyana damea ki tiye’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ogo wodanka Yesus yisa aaninam kedar wodayse kena Barjoam kinin miskoadettsi eeno yisa naasonam kalan entsate ko nivade. Kisa paanan yivayna eenaar eenam ke wacimade. ");
INSERT INTO amf_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesus kena yi giyna: ‘‘Naana idar ke nive; keam mareebhode. Harrna hambhidianna, Barjosa bitamono igina naanadettsi maataana eenasane’’ hamayse ");
INSERT INTO amf_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","yisa aaninam kedar wodayse kena Barjoam ki miskade. Ogoraar raq abdar ki yivade. ");
INSERT INTO amf_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Eedi kalaa Yesuskal nivayse, ‘‘Woam Dhettsea, rooro wul lay dehen sadan haapota yer payya har haynta ko iam zaske?’’ hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesusaar ‘‘Yerin payyansa ikal harrnaa oyse? Payya maataa kalaa bishne. Rooro wul lay dehen sadan haapota ha zagea hanna, Barjoyn giyonam toolaa’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ear ‘‘Upsina hammaam?’’ ki hamade. Yesus yin giyayse ki kina maasade: ‘‘Deesaabhode, sharmucimaabhode, dimmaabhode, buudamoka tarjaabhode, ");
INSERT INTO amf_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","hambabee handabeam gobshaa, een wulam hadettsi hayayse nashaa’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Barsha ear ‘‘Igina wulam inta toolidine; keeda ikal joogaa yer hare?’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesus ‘‘Yer wulam toolaa maatayse doota ha zagea hanna, yivayse hasa dohon koymonam shanshayse qambhinana imaa; ya hasa bazanam cecinte hada haape. Ogora maatayse isa paanan nivaa’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Barsha ear koymo thoothinin kisa dohonna, dhalqin ogoam yinin qansenka, yisa iinka ataate ki yivade. ");
INSERT INTO amf_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ogosa budonte Yesus yisa paanan yivaynana yin ki giyade: ‘‘Inta yena gon ida giye: Eedi wodimosa Barjo bitamonte ardano kattsi gaalene. ");
INSERT INTO amf_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tapir inta yena ida giye: Eedi wodimoyn Barjosa bitamonte ardenna gamaleyn marpisa pulaka konin utayno deegane’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yesussa paanan yivayna eenaar ogoam kenin qansenka, kattsi targadhayse, ‘‘Yin ko hanna, ta keeda hayne dhaqana damea?’’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesus keam shedayse, ‘‘Kono yerro eedina dandimiminone; Barjona yer wul dandima ko dandime’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ogo wodanka Bhethiroos yi giyna: ‘‘Shedaa! Wodi yer wulam garayse hasa paanan wo nivade. Ta wonin haapayno yer hare dohoono?’’ hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesus kena yin ki giyade: ‘‘Inta yena gon ida giye: Niven haalin wodanka, i Eedi Naas gobshinka isa bitamon borkotondar inin dooqenka, yedi isa paanan nivayna tabhi lamaana bitamon borkotondar dooqayse tabhi lamaana Israveel eenasa muldhanadar pirdeeda pirde. ");
INSERT INTO amf_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ina hamayse indanaana annginabee anzanabee, imbaabee, indanbee, naana yinnabee, oonin yinnonbee, haamin yinnonbeam garaa wul yisa dohondar sagi mato goyt kida tiye; pir rooro wul lay dehen sadanamaar haapa ki haape. ");
INSERT INTO amf_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ko dahaannaar thoothino birono eeno budo koda maate; budonte dohoono eeno pir bira koda maate’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesus yin ki giyade: ‘‘Barjosa bitamono woynin haaqana kordhon haaminte waadadhayna waadiman eenaam zagayse, waadinsota peen sedhima burburi utaa haaminsa imbaam koda maate. ");
INSERT INTO amf_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kidi rooro kalaasa birre kalaa kalaa kena kashana kenka dhalqayse, waadiman waadadhayna eenaam haamindar yisa ki yittsade. ");
INSERT INTO amf_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Savaat makkamka utayse waadimaysa qolmina eena gabante woyaanaam ki haapade. ");
INSERT INTO amf_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Keam ‘Yediar haamin innonte yivayse waadadhee; inta yena maaten bazanam yesa kashayda kashe’ kena ki hamade. Kediar haamindar ke yivade. ");
INSERT INTO amf_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tapir haaminsa imbaa savaat laxbee salbeka utayse kinin haapaana eenaam yin ki hayade. ");
INSERT INTO amf_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ogora pir savaat tabhi kalaaka utaate waani een woyonam haapayse, ‘Yedi ini burin utayse waadima kaysisaadettsi kote yenin woyoono hare?’ hamayse keam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Kediar ‘Woam waadisea eedi wonin kaysisonnane’ kina ke hamade. Kidiar ‘Ta yin ko hanna, yediar yivayse haamin innonte waadadhee’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","‘‘Peen ibanaysaka woynin haaqanasa haamin imbaa haaminte eenaam waadinsea eana ‘Eenaam eelayse macchindar nivaana eenadara yedayse ini burin birayse nivaana eenaka yekka kenin waadadhonsa bazanam kashaa’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ogora savaat tabhi kalaaka nivaanaar birre kalaa kalaa ke tiyade. ");
INSERT INTO amf_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Waadimanna birayse nivaana eena ogoam haapayse, ‘Wodi birre sagi woda tiye’ hamayse ke qaabade. Kediar pir birre kalaa kalaa ke tiyade. ");
INSERT INTO amf_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Birrenamaar kedi tiyayse, ‘Kina eena ibaandar nivayse savaat kalaa bish ke waadadhade; wodi rooron haynsana koqadhada waadadhite haaqayse wo qajadhaysaka, ya wombee kembena bazanam kiaddha ha hayade’ hamayse haamin imbaadar ke gundumade. ");
INSERT INTO amf_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Haamin imbaa waadiman waadadhayna eenasa kalaana yin giyayse ki maasade: ‘Isa nashoa, inta haam genaatine; hambesana kinka wonin dhalqoono rooroasa hana birre kalaa kashanatayu? ");
INSERT INTO amf_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Keeda ya hana yeskenam tiyayse yivaa. Hana inin imaadettsi kaa budonte nivaa eanaar yin imana ida zage. ");
INSERT INTO amf_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Koymon innondar inta inin zagaadettsi hayana isa hayamo qolaaw? Way inta eedina aan inin pishkenna idar ha woogimbho?’ hamayse kina ki giyade. ");
INSERT INTO amf_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ogodettsi tapir budonte dohoono eeno bira koda maate; birono eeno budo koda maate’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ogosa budonte Yesus Yerusaalemdar yivite goynte dahayse tabhi lamaana kisa paanan yivayna eenaam bish yikal entsate pucchayse kena yin ki giyade: ");
INSERT INTO amf_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","‘‘Marrato! Wodi ta keeda Yerusaalemdar woda yive. I Eedi Naasiam gudullasa hayonabee Musesa yigginam dhettsayna eenabena saskate ima ko imbhe; kediar inin deesadhoadettsi idar pirda ke pirde; ");
INSERT INTO amf_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","kedi Ayiwdtay hamma eenana iam saskate ima ke ime. Ayiwdtay hamma eenaar iam baga ke bage; iam qana ke qane; masqalindar konngate ziitayse iam deesa ke deese. Inta dembhira makkansoa rooroaka dhaabhayda dhaabhe’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ogo wodanka Yayqoobbee Wannisbesa indano naana yinnabesana Yesuskal hatte, kumpurdhayse yer kalaa kona kinin hayoadettsi kiam ko miskade. ");
INSERT INTO amf_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kidiar kona ‘‘Ya yer haraa zage?’’ ki hamade. Kodiar ‘‘Naana inna kina lamaanaam hasa bitamonte kalaam hasa mizaqimbar, kalaam hasa warkatambar hayayse keam dottsaa’’ kina ko hamade. ");
INSERT INTO amf_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kidiar kena yinin maasenka, ‘‘Yedi yenin miskenam dhesattene. Inin wucota dohon gaalen wucimanam yedi wucana damaw?’’ hamayse naanaam ki oysade. Kediar, ‘‘Damooda dame’’ kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Kidiar, ‘‘Inin wucen gaalen wucimanam wuceeda wuce. Ko dahaannaar isa mizaqimbee warkatambebar dooqadhoadettsi hayea intatehe; raqin ogoam isa Imbaa keninna ashkaanana ima ki ime’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Waani tambha Yesussa paanan yivayna eenaar yin giyayse kenin miskenam qansayse Yayqoobbee Wannisbeam ke wacimade. ");
INSERT INTO amf_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesus wulam yikal eelayse kena yin ki giyade: ‘‘Barjoam dhesimina eenaam wottsayna eena yisa eenaam kantaka kenin wottsenbee, entsaynasaar kedar kesa hayamo konin dohonbeam dheseeda dhese. ");
INSERT INTO amf_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Yennon shaarinte yin konin doadettsi zaskehe; yennon shaarinte eedi hayyear gebhi doota zagea yesa erge eedi ki dee. ");
INSERT INTO amf_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Yesa iira eedi hayyear bira doota zagea ye wulsa choobar dahaa erge eedi ki dee. ");
INSERT INTO amf_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ogodettsi inta Eedi Naasear eenna waadadhanabee isa sadanamaar thoothin eensa seeson bazan kashotabe i nivade; eeno ina konin waadadhoadettsi nivaatine’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ogosa budonte Yesusbee kisa paanan yivayna eenabe Iyarko katamara utaate kenin yivenka, thoothino eeno Yesussa paanan ko yivade. ");
INSERT INTO amf_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Eedi lama aapin kayaana waani goynsa aponte dooqaana ‘‘Yesus koka kida yive’’ hambhaka qansayse, ‘‘Imbo, Dawt Naasa, bannzo! Wona burqadhayse woam pacchaa!’’ hante ilataate kiam ke miskade. ");
INSERT INTO amf_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Thoothino eenoar igina aapin kayaana eenaam ‘‘Lay hamee’’ hamayse keam ko wacimade. Aapin kayaana eena ‘‘Imbo, Dawt Naasa, bannzo! Wona burqadhayse woam pacchaane! Woam kelshaa’’ hante ini kenin ilaterra sagi ke ilatade. ");
INSERT INTO amf_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesusaar woyayse keam eelayse, ‘‘Yena yer har i hayee zage?’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kediar ‘‘Imbo, aapinam wosa hanin pacchoadettsi wo zagade’’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesus kena burqadhayse kesa aapinam yisa aaninka ki kaamade. Kesa aapinoar saanawa ko shedade. Kediar Yesussa paanan yivan ke yedade. ");
INSERT INTO amf_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesusbee kisa paanan yivayna eenabe Yerusaalemkal theedayse Dabirezayt dhukankal dohon gurdan Betepaagedar ke nivade. Ogora Yesus yisa paanan yivayna eenasa lamaanaam yin giyayse ki keam yittsade: ");
INSERT INTO amf_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","‘‘Ogo yesa birante dohon gurdandar yivee. Gurdan ogotear ootabesana dhaxadhon ukuli kallon yedi saanawa haapeeda haape. Ogoam bulayse ina kote bevee. ");
INSERT INTO amf_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Eedi hayyear yeam oysidianna, ‘Imbaa wonteana kinin zaskonnane’ kina hamee; kidiar keam yena saanawa imasane’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","5","Ogono yin konin maatoono ena Barjokala qansayse eenna giyea ea yi giyna: ‘‘Thiyoon hambhen Yerusaalem katamante dahaana eenana ‘Marrato! Bitaa yentea yedar niva ki nive; kidi eedi leemi maatayse ukulidar kida dooqe; ukulisa ootodar dooqayse kida nive’ kena hamee’’ hamayse kinin giyoono ko thoothene. ");
INSERT INTO amf_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ogonante Yesussa paanan yivayna eenasa lamaana Yesusin kena giyondettsi yivayse ");
INSERT INTO amf_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ukultonam bulayse kosa ootabesana Yesusna ke bavade. Apalan kennonam ukullasa zulondar ke wodade; Yesusaar daran ki dooqade. ");
INSERT INTO amf_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Eensa thoothino yisa apalanam goyndar ko apade; waani eenoar pir haaqansa hacchan taxayse goyndar ko apade. ");
INSERT INTO amf_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kisa birante yiven eenbee budonte niven eenbe ‘‘Dawt Naasana gobshi ko dee! Barjo Imbaasa naabenka nivea gobshadhaane! Cecinte Barjona gobshi ko dee!’’ hante ilataate kiam ke gobshade. ");
INSERT INTO amf_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesus Yerusaalem nivite kinin ardenka, ogo katamante dohoono eeno wul ‘‘Kaa kidi hayne?’’ hamayse ko targadhade. ");
INSERT INTO amf_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kimbete dahaana eenaar ‘‘Kaa Galila peente dohon Naazret katamara nivaa Barjokala qansayse eenna giyea Yesusne’’ hamayse kena ke giyade. ");
INSERT INTO amf_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ogosa budonte Yesus Barjosa gazan ooninsa mayante ki ardade. Ogotear shanshaynabee shanayna eena wulbeam ooninsa mayara ki oytade; birren ookayna eenasa tharbhezanbee waleen shanshayna eenasa borkotonbeam kupate dhabayse ");
INSERT INTO amf_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","kena yin ki giyade: ‘‘ ’Onno isa miske ooni koda hambhe’ hamayse thaapadhidine; yediar eensa koymon buurate itsaynasa aadhime raq koam ye hayade’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ogora Yesus Barjosa gazan ooninsa mayante ki daaka, eena aapin kayaanabee eena roon wobonabe daran ke nivaysaka kidiar keam ki pacchade. ");
INSERT INTO amf_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ko dahaannaar gudullasa hayonabee Musesa yigginam dhettsayna eenabe Yesus tarshen yerin kinin hayenam kenin haapenkabee naana Barjosa gazan ooninsa mayante dahayse ‘‘Dawt Naasana gobshi ko dee!’’ hamada kenin ilatenam kenin qansenkabe ke wacimade. ");
INSERT INTO amf_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ogona kedi Yesusna ‘‘Naana kinayn giyenam ha qanso?’’ kina ke hamade. Kidiar ‘‘Qansayda qanse. ‘Naana shaaqanabee, naana amin qocaynabesa aponte gobshinam hana ha ashkade’ hamen Barjosa upsinam yedi nabbabeete?’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ogora Yesus keam garayse katamara utaate Bitaania gurdante yivayse ogote ki wodhade. ");
INSERT INTO amf_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesus sedhiman katamandar kinin maatenka daaqi kiam bashade. ");
INSERT INTO amf_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Haaqa shaap kallonam goynsa aponte haapayse kokal hatte koam ki shedade. Ko dahaannaar haccha bish dahade, aapi kodar haapadehe. Ogonante ‘‘Kaara os keeda macchi ko hasa aapi dahabhoode’’ ki hamade. Agaara hattonoar saanawa ko wocchade. ");
INSERT INTO amf_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kisa paanan yivayna eenaar ogoam kenin haapon wodanka, ‘‘Hattono shaapino kono saanawa hamin ko wocchaa?’’ hamayse ke targadhade. ");
INSERT INTO amf_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesus yin giyayse kena ki maasade: ‘‘Inta yena gon ida giye: Qothimima Barjodar woylam ye qajea hanna, hatton shaapon kodar inin hayondettsi bish daymaka, ko dhukanam hattear, ‘Agaara dhaabhayse bazinsa iinte wavaa!’ ye hamidianna, yena maata ko maate. ");
INSERT INTO amf_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Barjodar woylamin qajayse kiam yenin misken wulam yedi haapeeda haape’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesus Barjosa gazan ooninsa mayante ardayse eenaam dhettsite ki dahade. Ogo wodanka gudullasa hayonabee peensa donzanabe kikal nivayse, ‘‘Yerra iginaam hanin hayayno hasa yer har hayamokane? Hayamon koam hana imaa hayne?’’ hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesus kena kinin maasenka, ‘‘Intaar yer kalaa yeam ida oyse. Yeam inin oysonsa malsin ina ye maasanna, intaar yerra kinaam yer har hayamoka inin hayenam yena giyayda giye. ");
INSERT INTO amf_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Wannis eenaam kinin shivoadettsi hamora ki nittsadhaa? Barjokalankamoo, eedikalankaw?’’ hamayse keam ki oysade. Kediar yin giyayse kinka kikal ke dhalqade: ‘‘ ’Barjokalankane’ wo hamanna, ‘Ta harrnee kisa dhalqinam gonne hamayse tiyan garaa?’ wona ki hamoaye. ");
INSERT INTO amf_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","‘Eedikalankane’ wo hamanna, pir eeno wul Wannisam Barjokala qansayse eenna giyeadettsi hayayse kiam konin shedenna, eenna kurtumbhooda kurtumbhe’’ hamayse, ");
INSERT INTO amf_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yesusnante ‘‘Hamora konin dohonam wodi dhesattone’’ hamayse ke maasade. Kidiar kena ‘‘Ta intaar har hayamoka yerra iginaam inin hayenam yena giyattine’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ogora Yesus kena yin ki giyade: ‘‘Ta yena yer har ko maate? Eedi kalaasa naasi lamaa dahade. Kesa biraakal imbaa nivayse, ‘Inaane, kina woynin haaqanayn dohon haaminte yivayse ina waadadhaa!’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Naasaar, ‘Inta waadadhattine’ kina ki hamade. Yinin giyonsa budobar yer qaabayse haaminte waadadho ki yivade. ");
INSERT INTO amf_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Imbaa pir naasa lansoakal yivayse, kina ini kisa indanaasa waana kinin giyaadettsi yivayse ki waadadhe kina ki giyade. Naasaar, ‘Ee, imbo, inta yivayse waadadhayda waadadhe’ kina ki hamade. Hattear kidi yivayse waadimadehe. ");
INSERT INTO amf_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ta naana igina lamaanasa imbayn giyonam waadadhaa naasa hamaane?’’ kena ki hamade. Kediar ‘‘Naasa biraane’’ ke hamade. Yesus kena yin ki giyade: ‘‘Inta yena gon ida giye: Gibirin kacchaynabee maana sharmucanabe Barjosa bitamon raqinte ardintanka yeam bira ke bire. ");
INSERT INTO amf_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Harrna hambhidianna, Shivea Wannis tipamonsa goynam yeam dhettsota kinin nivenka yedi gonne hamayse tiyeetene; gibirin kacchaynabee maana sharmucanabe kinin giyenam gon hamayse tiyaanane. Yedi ogoam haapaysear seesora yesa maatayse kinin giyenam gonne hamayse tiyeetene’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesus pir yin ki giyade: ‘‘Kamsi ab qansee: Woynin haaqanaam haaminte yisa thoothi koraa eedi kalaa dahade. Kidiar haaminsa gasanam aygi cavayse, haaqanasa aapinin cuubadhea oolo koyate ashkayse, haaminam toolana tulee pir dheg hamaa ki kahade. Ogosa budonte haaminte waadadhayna eenana elqimayse pee abdar ki yivade. ");
INSERT INTO amf_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kidiar haaqana aapin kenin kambhen wodan yeskaysaka, ‘Haaqanasa ina yesken aapinam tiyo ke yive’ hamayse kisa ergen eenaam haaminte waadadhayna eenadar ki yittsade. ");
INSERT INTO amf_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Haaminte waadadhayna eena kinin nittsaana ergen eenaam yedayse, kesa kalaam ke qanade; waam ke deesade; waam pir seenika ke paxade. ");
INSERT INTO amf_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","‘‘Ogora haaminsa imbaa pir ini birayse kinin yittsaana ergen eenasa paydira sagi hayayse, haaminte waadadhayna eenadar ki yittsade. Haaminte waadadhayna eenaar eena biranaam kenin qanonbee deesonbedettsi keamaar yin ke hayade. ");
INSERT INTO amf_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","‘‘Macchindar kidi ‘Kedi naasa inteana bookindhasane’ hamayse naasa yinteam kedar ki yittsade. ");
INSERT INTO amf_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Haaminte waadadhayna eena naasaam kisa haapayse kinka yin ke giyade: ‘Kaa kisa haamindar sagea naasa toydiane. Nivee, kiam deesayse kisa dohonam wo tiye’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Naasaamaar woynin haaqanasa haamira gochate bulayse ke deesade. ");
INSERT INTO amf_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","‘‘Ta haaminsa imbaa kinin niven wodanka, igina haaminte kisa waadadhayna eenaam hamin ki haye?’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Kediar ‘‘Igina siyana eenana burqadhima keam kida deese; woynin aapinam kosa wodanka shiishima kina imayna eena waanina haaminam yisa elqimayse kida ime’’ kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ogora Yesus kena yin ki giyade: ‘‘ ’Seeninka oonin woysayna eena kenin bagaa seenia senna wulra ooninna kattsi zaskea ki maatade. Ogonoar Barjosa waadimane; wonin shedenkaar yer woam tarshaynone’ hamayse Mathaapin Gazante thaapadhonam yedi nabbabeete? ");
INSERT INTO amf_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ogona inta yena ida giye: Barjo yisa bitamonam yekalanka tiyayse konka aapin ushayna eenana kida ime. ");
INSERT INTO amf_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Seenia agaadar dhambea aya ki aye; seenia agaa yindar dhambaa ea giicima ki giicime’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Gudullasa hayonabee Parisa eenabe Yesusin kena giyaana kamsina iginaam kenin qansen wodanka, kesa goynam kinin giyonam ke dhesade. ");
INSERT INTO amf_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ogonante kiam yedana ke zagade; ko dahaannaar thoothino eeno Barjokala qansayse eenna giyeadettsi hayayse kiam konin shedenna, eenam ke kurtumbhade. ");
INSERT INTO amf_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Tapir Yesus kena kamsika yin giyte ki dahade: ");
INSERT INTO amf_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","‘‘Barjosa bitamono yisa naasasa gaydonna thoothi yer ashkaa bitaam koda maate. ");
INSERT INTO amf_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bitaa kinin eelaana eenadar ‘Gaydonna ikal nivee’ hamayse yisa ergen eenaam ki yittsade. Eenaar gaydondar nivota nashadehe. ");
INSERT INTO amf_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Bitaa ergen eena waani kinnaam ‘Inin eelaana eenana yivayse, ‘‘Marrato! Gaydonna zasken yerinam inta ashkidine; wannga zianabee durpisadhaanabeam inta machidine; yerro wul agidine. Ogonante gaydondar ikal nivee’’ hamayse kena giyee’ hamayse keam ki yittsade. ");
INSERT INTO amf_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Eldhaanaar kisa eelimenam bagayse kalaa yisa haamindar, kalaa yisa naggadimakkondar ki yivade; ");
INSERT INTO amf_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","waani shidhaana eena ergen eena kinnaam yedate qanayse ke deesade. ");
INSERT INTO amf_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","‘‘Ogo wodanka bitaa wacimayse, poolisana yinnaam yittsayse igina kisa ergen eenaam deesaana eenaam ki dettsade; kesa katamanamaar nuuka ki kosqade. ");
INSERT INTO amf_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ogosa budonte ergen eena kinnana yin ki giyade: ‘Gaydonna zaskayno yerro agidine. Gaydonna eldhaana eena gaydonna zaskaana maatadehe. ");
INSERT INTO amf_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ogonante kataman goynadar yivayse yenin haapen een wulam gaydonna eelee’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ergen eena kinnaar goynadar yivayse kena haapadhaana eena siyanabee payyanabe wulam ke eelade; eena gaydonna eldhaana hatte ardayse ooninka ke thoothade. ");
INSERT INTO amf_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","‘‘Ko dahaannaar bitaa igina kinin eelaana eenaam shedota gaydon ooninte kinin ardenka, gaydonna zaskea apala qaadhaama eedi kalaam ogote ki haapade. ");
INSERT INTO amf_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Yin ki giyade: ‘Isa nashoa, gaydonna zaskea apala qaadhima kote haminaa nivayse ardaa?’ kina ki hamade. Ear lay lay ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ogo wodanka bitaa waadadhayna eena yinnana, ‘Kisa aaninbee roonbeam dhaxayse mayante dohon thipansa iinte bulayse kiam dhabee. Ogotear eepibee atsi qiicabe koda maate’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ogona eldhaana eena thoothine; ko dahaannaar kambhaana tokaane’’ hamayse Yesus kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ogosa budonte Parisa eena ‘‘Yesusam kisa dhalqin goynka yedana hamin wo hayo?’’ hamayse kinka ke dhalqade. ");
INSERT INTO amf_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kesa paanan yivayna eenaam Herodissa bitamonam nashayna eenabesana yin giyayse kiam kenin oysoadettsi Yesusdar keam ke yittsade: ‘‘Woam Dhettsea, ya gon eedi hanin dohonbee Barjosa goynam gon hanin dhettsenbeam wodi dhesooda dhese. Eedisa wotina bookindhayse hanin hayminna, eedisa woti shedayse hanin hayea yer qolehe. ");
INSERT INTO amf_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Wona ta ya giyaa: Hana yer har ko maate? Roome peen bitaana gibiri kashadhoadettsi giidhidimoo, giidhadayne?’’ hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesus kesa siyan qaabenam dhesayse, ‘‘Yedi maltina eenato, harrnee iam tayse? ");
INSERT INTO amf_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Gibirin kashadhea koymoam yinda ina dhehee’’ kena ki hamade. Kediar santup kina ke bavade. ");
INSERT INTO amf_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kidiar yi giyna: ‘‘Santupa kaadar dahaa pootoabee daran thaapadhaa naabeabe haysane?’’ hamayse keam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kediar ‘‘Roome peen bitaasane’’ kina ke hamade. ‘‘Ta yin ko hanna, Roome peen bitaa gaynam kina imee; Barjo gaynam Barjona imee’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kediar ogoam qansayse targadhayse kiam garayse ke yivade. ");
INSERT INTO amf_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Agaa rooroaka ‘‘Dembhira dhaabhadhea yer qolehe’’ hamayna Saduqa eenara eedi waani Yesuskal nivayse yin giyayse kiam ke oysade: ");
INSERT INTO amf_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","‘‘Woam Dhettsea, Muse ‘Eedi kalaa maa keemayse naasi adhima diydi ki hanna, kisa kana koam keemayse diyaa iishimasa oolonte kina ki adhe’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Eedi kalaasa naasi tobbhaa waani dahade; ke wulsa iishima gebha maa keemayse naasi adhima ki diyade. Kisa kana lansoa iishima geshonam ki keemade; ");
INSERT INTO amf_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ogodettsi lansoar, makkansoar, yin tobbhaana wul koam keemayse naasi kanka adhima ke diyade. ");
INSERT INTO amf_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ke wulsa macchinte edono ko diyade. ");
INSERT INTO amf_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ogonante igina indanaana wul koam kenin keemonna, diyaana eena dembhira kenin dhaabhen wodanka, kodi tobbhaana eenasa hamaa easa maa koda maate?’’ hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesusaar yin giyayse kena ki maasade: ‘‘Yedi Mathaap Gazanbee Barjosa kantanbeam yenin dhesiminna, yeda dhaddhise. ");
INSERT INTO amf_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Harrna hambhidianna, dembhira dhaabhadhen wodanka, eeno cecinte dahaana Barjosa gaananadettsi koda maate; kodi yina kembhehe, tapir keemehe. ");
INSERT INTO amf_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tapir dembhira dhaabhadhen goynsa Barjoyn yena giyonam yedi nabbabeete? ");
INSERT INTO amf_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Kinin giyoono yinne: ‘Inta Abraamsa Barjoa, Yisaaqsa Barjoa, Yayqoobsaar Barjoane’ ki hamade. Barjo sadanka dahaana eenasa Barjone, diyaana eenasa Barjotehe’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kisa dhalqinam qansoono eeno kisa timmirinka ko targadhade. ");
INSERT INTO amf_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Saduqa eenayn dhalqoamadettsi Yesus lay kinin hayonam Parisa eena kenin qanson wodanka, kinka kidar ke bukade. ");
INSERT INTO amf_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kesa iira waa Musesa yigginam dhettsea Yesusam taysate shedana zagayse yin giyayse ki kiam oysade: ");
INSERT INTO amf_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","‘‘Woam Dhettsea, Musesa yigginte wuldara sagea Barjoyn giyaa upsea hamaane?’’ hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesus yin giyayse kina ki maasade: ‘‘ ’Ya Imbaa hantea Barjoam gonin hamon woylaminka, gonin hamon sadanka, gonin hamon qaabenka kiam nashaa’ hamaynone. ");
INSERT INTO amf_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Wuldara sagi maataa biraa upsea Barjoyn giyaa agaane. ");
INSERT INTO amf_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Agaadettsea lansoar ‘Een wulam hadettsi hayayse nashaa’ hamaynone. ");
INSERT INTO amf_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Musesa yigginbee Barjokala qansayse eenna giyayna eenayn thaapoono wulbe igina upsina lamaanadar ke woysadhade’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisa eena bukayse ke daaka, Yesus yin giyayse keam ki oysade: ");
INSERT INTO amf_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","‘‘Barjoyn qadhaa Kiristoossa yedi yer har ye qaabe? Kidi hay naasine?’’ hamayse keam ki oysade. Kediar ‘‘Dawt naasine’’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Yesus kena yinin maasenka, ‘‘Yin ko hanna, Dawt Barjo Manpasinin kiam entsaysaka, ‘Barjo isa Imbana ‘‘Haam jibbayna eenaam hasa hayamonsa demente inin keam hayenka yekka, isa mizaqimbar dooqaa’’ kina ki hamade’ kinin hamenka ‘isa Imba’ hamayse hamin ki giye? ");
INSERT INTO amf_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ta keeda Dawt yinti kiam ‘isa Imba’ hamayse eelea ki hanna, Kiristoos hamin ki Dawtsa naasi dee?’’ kinin hamenka, ");
INSERT INTO amf_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","eedi kala hattear kina upsi maasana damadehe. Rooroa agaara yedayse eedi hay ki hannaar kiam oysime oysana kedi kurtumbhidine. ");
INSERT INTO amf_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ogosa budonte Yesus thoothin eenbee kisa paanan yivayna eenabena yin kena ki giyade: ");
INSERT INTO amf_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","‘‘Musesa yigginam dhettsayna eenabee Parisa eenabe eenaam dhettsota Muse borkotondar dooqidine. ");
INSERT INTO amf_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ogona yenka ‘Hayee’ hamayse yena kenin giyen yerin wulam yedi toolee, ogoamaar hayee. Kenin hayenam hayeebhode; harrna hambhidianna, kedi kenin giyenam waadimadar hacchehe. ");
INSERT INTO amf_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Eenaam galshen dethan baskenam dhaxayse eendar keda baskise; kedi ogoam kelshana aaninsa surkenka hattear kaamana nashehe. ");
INSERT INTO amf_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kenin hayen waadiman wulam eedinin shedoadettsi hamayse keda haye. Musesa yigginam thaapayse korbho workisa iir arsayse yisa wotindar keda dhaxe; apalan kennonsa nukindar shira keda gudubhse. ");
INSERT INTO amf_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kumman kummadhen raqinte gobshadhon raqinbee Ayiwd eensa bukin raqinte gobshadhon borkotonbeam yedota keda nashe. ");
INSERT INTO amf_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Gabantear gobshadhon gisimenam gisimbhotabee ‘Dhettsea’ hamayse eldhotabe keda nashe. ");
INSERT INTO amf_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","‘‘Yeam Dhettsea kalaa bish kinin dohonnabee yedi kinka kisa indanaas yenin dohonnabe, yeam ‘Dhettsea’ hamayse ko eldhabhoode. ");
INSERT INTO amf_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tapir cecinte dahaa Imbaa yentea kidi kalaa bish kinin dohonna, peente eediam ‘Imbo’ hamayse eeleebhode. ");
INSERT INTO amf_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Yeam Entsea kalaa bish, kidiar Barjoyn qadhaa Kiristoos kinin dohonna, ‘Entsea’ hamayse yeam ko eldhabhoode. ");
INSERT INTO amf_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yesa shaarinte sagi doota zagea ea yesa erge eedi ki dee. ");
INSERT INTO amf_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Meten yinnonam yintika gettsea wul toka ki toke; meten yinnonam toskea wul gebha ki gebhe. ");
INSERT INTO amf_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","‘‘Yedi Musesa yigginam dhettsayna eenabee Parisa eenabeto, maltinato, hay! Eenin Barjosa bitamon raqindar ardoamadettsi kerin yeda diithe. Meten yennonka yedi ardattene; ardota zagayna eenaamaar kenin ardoamadettsi yeda mare. ");
INSERT INTO amf_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","‘‘Yedi Musesa yigginam dhettsayna eenabee Parisa eenabeto, maltinato, hay! Misken yennonam eedinin shawkoadettsi hamayse yeda gudubhse; maana qambhinasa ooninam yeda buure. Ogonante pirdi sagi yeda tiye. ");
INSERT INTO amf_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","‘‘Yedi Musesa yigginam dhettsayna eenabee Parisa eenabeto, maltinato, hay! Eedi kalaam yennon gilonsa iinte arsota pegen goynbee bazinbedar zagimite yeda yaaye. Kiam yedar yenin arson wodankaar yedara ii lamaaka sagi lay dikimon nuun pirdin tiyea yeda haye. ");
INSERT INTO amf_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","‘‘Yedi aapin kayaana entsanato, hay! ‘Eenin Barjosa gazan ooninka mallimenka, yer hamehe’ pir, ‘Barjosa gazan ooninte dohon worqinka konin mallimenka, mallanka yedima ko yedime’ yeda hame. ");
INSERT INTO amf_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yedi kina malgimina aapin kayaana eenato, worqinbee worqinam gazinsen Barjosa gazan ooninbesa sagea hamaane? ");
INSERT INTO amf_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yin tapir ‘Eeno Barjona marshan konin machen raqinka konin mallimenka, yer hamehe’ pir, ‘Marshan machadhen raqindar dohon marshanka konin mallimenka, mallanka kosa yedima ko yedime’ yeda hame. ");
INSERT INTO amf_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yedi kina aapin kayaanato, marshanbee marshanam gazinsen raqinbedara sagea hamaane? ");
INSERT INTO amf_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ta keeda marshan machadhen raqinka mallimea ea marshan raqabee kidar machadhen yerin wulbeka kida mallime. ");
INSERT INTO amf_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Barjosa gazan ooninka mallimea ea taar gazan ooninbee iinte kosa dahaa Barjobeka kida mallime. ");
INSERT INTO amf_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Cecinka mallimea ea taar Barjosa bitamon borkotonbee bitamonna daran dooqaa Barjobeka kida mallime. ");
INSERT INTO amf_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","‘‘Yedi Musesa yigginam dhettsayna eenabee Parisa eenabeto, maltinato, hay! Harrna hambhidianna, mayante yenin yiithaana basibilabee, saliithabee, suupibe wulsa iira shiishima tambhasa kalaam Barjona yeda ime; Musesa yigginte haapadhayna yerra zaskaynaam yeda gare. Ogonoar tipan pirdinbee, eedina burqadhayse waadadhadhenbee, gon eedi daadhenbene. Ko dahaannaar waaniam yenin hayenka kinaam garinta yeam zaskehe. ");
INSERT INTO amf_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yedi aapin kayaana entsanato, yenin wucensa iira sunguladettsi tokaam kamate buleeda bule, hattear gamaledettsi kattsi gebhaam yeda mannge. ");
INSERT INTO amf_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","‘‘Yedi Musesa yigginam dhettsayna eenabee Parisa eenabeto, maltinato, hay! Galan yenin itsen sharqanbee karambhanbesa zulon payya hayayse yeda shive; ko dahaannaar iino kosa saribee gibazbeka thoothoonone. ");
INSERT INTO amf_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ya kaa aapin kayaa Parisa ea, birayse hasa sharqanbee karambhanbesa iin shivaa; ogo wodanka kesa mayambar haapadhayno zulonoar payya koda dee. ");
INSERT INTO amf_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","‘‘Yedi Musesa yigginam dhettsayna eenabee Parisa eenabeto, maltinato, hay! Iinka yisa een diyon lepinbee minngimon yerinbeka thoothayse dahaana, zulonam kesa bhalbhaltoka qadhadhaysaka paydhaana duukinam yeda maate. ");
INSERT INTO amf_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ogonoar yedi eedi birante tipana maatayse yeda haapadhe; yesa iino maltamobee siyamobeka thoothidine. ");
INSERT INTO amf_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","‘‘Yedi Musesa yigginam dhettsayna eenabee Parisa eenabeto, maltinato, hay! Harrna hambhidianna, Barjokala qansayse eenna giyayna eenasa duukindar seenin bunkaate yeda ashke; tipana eenasaar duukinam ashkite yeda gobshe. ");
INSERT INTO amf_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Yedi ‘Ena wosa eykena wodanka wodi dahaa wo hanna, kembesana kinka Barjokala qansayse eenna giyayna eenaam deesadhente ardattone’ yeda hame. ");
INSERT INTO amf_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ta ogoka yesa ena Barjokala qansayse eenna giyayna eenaam deesaana eykena yennasa naana yenin dohonam yentika yedar yeda tarje. ");
INSERT INTO amf_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ta keeda yediar eykena yennayn hayon siyon waadimanam thoosee. ");
INSERT INTO amf_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","‘‘Yedi guni, qarshi naanato, lay dikimon nuunsa pirdira haminee dhaqe? ");
INSERT INTO amf_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ogonante inta Barjokala qansayse eenna giyayna eenabee, eena pakallabee, yigginam dhettsayna eenabeam yedar ida yittse. Kesa waaniam deeseeda deese; waaniamaar masqalindar konngate ziitayse deesadhoadettsi yeda haye; waaniamaar yesa bukin raqinte qaneeda qane; keam kataman waara kataman waadar oyteeda oyte. ");
INSERT INTO amf_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ogo goynka tipa ea Aabeelsa zombhira yedayse Barjosa gazan ooninbee Barjona marshan daran machadhen raqinbesa shaarinte yenin deesaa Berakiyo naasa Zakkariassa zombhinka yekka, tipana eenasa peendar laymon zombhin wulna pirdino yedar yeska ko yeske. ");
INSERT INTO amf_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Inta yena gon ida giye: Pirdino kono wul wodan koka dohon adhadhindar yeska ko yeske. ");
INSERT INTO amf_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","‘‘Yerusaalemo, Yerusaalemo! Ya Barjokala qansayse eenna giyayna eenaam deesayno, hadar nittsadhaana eenaam seeninka paxayno! Baacha yisa naasiam kaapin demente konin yedendettsi, intaar hasa naanaam yedana thoothi woda i zagade; ya nashaatane. ");
INSERT INTO amf_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ta keeda yesa gazan oonira Barjo utaysaka onno guuri koda shidhe. ");
INSERT INTO amf_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Harrna hambhidianna, inta yena ida giye: ‘Barjo Imbasa naabenka nivea gobshadhaane’ yenin hamenka yekka keeda kaara os iam haapattene’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesus Barjosa gazan ooninsa mayara utayse kinin yivenka, kisa paanan yivayna eena Barjosa gazan oonin woysadhonsa payyamonam kina dhoota kikal ke nivade. ");
INSERT INTO amf_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kidiar kena yinin maasenka, ‘‘Ko wulam yedi shedee shedo? Inta yena gon ida giye: Senna kina kidar dordhaanasa hamin hambhaakaar, kesa kala hattear povayse kottsimima shidhea qolehe’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesus Dabirezayt dhukandar dooqayse ki daaka, kisa paanan yivayna eena yimal kikal nivayse, ‘‘Ogono yerro haa ko yin maate? Hasa nivintanbee peensa macchin wodanbeam dhettsayno milkitino kosa hare? Wona giyaa’’ hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesus yin giyayse kena ki maasade: ‘‘Eedi hayyear yeam kinin dhaddhisoamadettsi mete yesaam gishee. ");
INSERT INTO amf_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Harrna hambhidianna, thoothino eeno ‘Inta Barjoyn qadhaa Kiristoosne’ hamaate isa naabenka niva ko nive; thoothin eenamaar dhaddhisa ko dhaddhise. ");
INSERT INTO amf_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Banqibee banqinsa upsinbeam qanseeda qanse. Ogono yin konin maatayno shidha shidhimino konin dohonna kurtumbheebhode. Macchin wodano akarne. ");
INSERT INTO amf_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Zarsino zarsindar, binnaar binnadar dhaabhayse banqi keda kiam uxe; raq waani waanirar daaqibee peensa zigabe koda maate. ");
INSERT INTO amf_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ogono yerro wul sirman edonin adhimanna birayse burqadheadettsi gaalen rooronsa biranone. ");
INSERT INTO amf_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","‘‘Ogo wodanka eeno gaalenna yeam saskate ima ko ime; yeam deesa ko deese; isa naabenna hamayse zarsin wulkal jibbadhaana yeda maate. ");
INSERT INTO amf_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ogo wodanka thoothino eeno Barjodar woylamin qajadhen goynam gara ko gare; kinka kinka kiamaar gaalenna saskate ima ko ime; eenoar kinka kiam kiam jibba ko jibbe. ");
INSERT INTO amf_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Buudamoka ‘Inta Barjokala qansayse eenna giyeane’ hamayna thoothina eenaar dhaabha ke dhaabhe; thoothin eenaamaar dhaddhinsa ke dhaddhinse. ");
INSERT INTO amf_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Eensa siyamonin thoothon goynka thoothin eensa nashimmakkono qaja ko qaje. ");
INSERT INTO amf_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Macchin wodanka yekka wocchimbhaate darshea kidi dhaqa ki dhaqe. ");
INSERT INTO amf_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Zarsin wulna tarja konin maatoadettsi Barjo bitamonsa dhacchintan upsino ko peen wul gidir giidha ko giidhe. Ogo wodanka macchino niva ko nive. ");
INSERT INTO amf_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","‘‘Barjokala qansayse eenna giyea Daaneelin giyondettsi, eenaam minngisayno siyono yerro gazisadhon raqinte woysadhaysaka yenin koam haapen wodanka (koam nabbabea ea ki bhocche), ");
INSERT INTO amf_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","wodan ogoka Yiwda peente dohoono eeno dhukanadar ko gobe. ");
INSERT INTO amf_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ooninsa zulondar dahaa ea ooninsa zulora hanchayse yer tiyo ki ooninte ardabhoode. ");
INSERT INTO amf_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Haaminte yisa dahaar apalan yinnon tiyota budoka ki maatabhoode. ");
INSERT INTO amf_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ogo wodanka maana sirmanabee amin qooshaynabena hay! ");
INSERT INTO amf_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ko dahaannaar gobeno yesa bargin wodanka way ukunsen rooroaka konin doamadettsi Barjoam miskimate. ");
INSERT INTO amf_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ogo wodanka peen pijadhorra yedayse ta koka yekka eedinin haapaammo gaaleno niva ko nive; os birantear kodettsino gaaleno yer hamin hambhaakaar nivehe. ");
INSERT INTO amf_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ogono eenaam galshayno roorono ko orgadhaamma, eedi kala hattear dhaqana damehe; ko dahaannaar kambhaana eenana hamayse roorono koda orgadhe. ");
INSERT INTO amf_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","‘‘Ogo wodanka eedi hay ki hannaar, ‘Marrato! Barjoyn qadhaa Kiristoos kote ki dahade’ way ‘Saa ogote ki dahade’ yena hamea ki hanna, gonne hamayse tiyeebhode. ");
INSERT INTO amf_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ogonoar buudamoka ‘Inta Barjoyn qadhaa Kiristoosne’ hamayna eenabee buudamoka ‘Inta Barjokala qansayse eenna giyeane’ hamayna eenabe eensa iira dhaabha ke dhaabhe; kediar kena dandimea ko hanna Barjoyn kamayse edaana eenaam dhaddhisota yer gebhi maatea milkitbee yer tarsheabe waadadhayse dhaa ke dhee. ");
INSERT INTO amf_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Shedee; inta yena birayse giydine. ");
INSERT INTO amf_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","‘‘Ogona ‘Marrato! Kiristoos eenin qolmon darante ki dahade’ yena ke hamea hanna, yiveebhode. Way ‘Marrato! Gulinte ki dahade’ yena hamea ke hanna, kenin giyenam gonne hamayse tiyeebhode. ");
INSERT INTO amf_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Harrna hambhidianna, cecinte dohon bhalqantin bhalqantenka haynsa utara yedayse wavintanka yekka konin haapadheadettsi, i Eedi Naasisaar nivano yin koda dee. ");
INSERT INTO amf_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Yerin diyonin dohon raqinte kuthoda buke. ");
INSERT INTO amf_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","‘‘Saanawa ogo gaalen rooronsa budonte, cecinte dahaana kantana wul shoa ke shoe; hayno thipa ko thipe; arpinoar shaakehe; wanconoar cecira wava ko weve. ");
INSERT INTO amf_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ogo wodanka Eedi Naasisa milkitino cecindar koda haapadhe. Peen wulsa iinte dohoono zarsino eepa ko eepe. Inta Eedi Naasear kantanbee gebhon gobshinbeka maatayse polondar dahayse inin nivenam keda haape. ");
INSERT INTO amf_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Gebhon thurumbansa upsinka isa gaananaam cecira nittsayda nittse. Kediar peensa gasara yedayse kosa macchinka yekka peen wulsa iira inin kamaana eenaam puccha ke pucche. ");
INSERT INTO amf_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","‘‘Shaapin hattonsa kamsinam dhesee. Ogonoar hattonsa antinin caagenka, hacchanin kosa utenka, bargin wodanin yeskonam dheseeda dhese. ");
INSERT INTO amf_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ogodettsi yedi igina yerra wulam yenin shedenka, i Eedi Naasisa nivan wodano theedayse ooninte ardota kerinte konin dohonam dhesimate. ");
INSERT INTO amf_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Inta yena gon ida giye: Ogo wul yin maatenka yekka wodan koka dohoono adhadhino diyate maqehe. ");
INSERT INTO amf_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Cecinbee peenbe saga ko sage; inin giyayno upsino sagehe. ");
INSERT INTO amf_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","‘‘Rooron ogobee savaatin ogobeam Barjo Imbaa bishkalanka ab dhesea eedi hay ki hannaar qolehe; cecinte dahaana Barjosa gaanana ke hannaar, Naasa kintea ki hannaar, dhesehe. ");
INSERT INTO amf_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nohe wodanka konin maatondettsi, i Eedi Naasisa nivintano yin koda maate. ");
INSERT INTO amf_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ogo wodanka kayen noqonin nivonsa birayse, Nohe gonngalante kinin ardea rooroaka yekka eeno itsaatebee wucaatebe, ora keemaatebee osar kembhaatebe ko dahade. ");
INSERT INTO amf_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Kayen noqono nivayse ke wulam konin itsenka yekka eeno dhesadehe. I Eedi Naasisa nivintanoar ogodettsi yin koda maate. ");
INSERT INTO amf_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ogo wodanka eena haamin kinka koyte dahaana lamaanasa kalaam tiyayse, lansoam gardha ko gardhe. ");
INSERT INTO amf_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Maana lamaana kinka deesimaynasa kallonam tiyayse, lansonam gardha ko gardhe. ");
INSERT INTO amf_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","‘‘Ogonante Imbaa yentea rooroa hamaaka kinin nivenam yenin dhesimonna, qaymayse toolee. ");
INSERT INTO amf_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ko dahaannaar, yerin koam dhesee: Ea ooninsa imbaa sootin woda hamaaka diibiyn oonindar nivenam dhesidi yi hanna, qaymi dahayse ooninsa kerin qunthadhoadettsi hayehe. ");
INSERT INTO amf_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ogona inta Eedi Naas yenin bhocchaamon wodanka inin nivenna, yedi ashkimbhayse toolee. ");
INSERT INTO amf_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","‘‘Oonin eenaam payya hayayse ki wottsebee waadiman eenanaar galanam kena iman zasken wodanka kinin imoadettsibe kamayse imbaayn wodaa gon hama pakalaa waadiman ea kidi hayne? ");
INSERT INTO amf_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Yisa imbaanin niven wodanka, kina giidhon waadimandar haapadhea ea kidi gobshadhaane. ");
INSERT INTO amf_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Inta yena gon ida giye: Agaa waadiman easa imbaa yisa dohon yerin wulam wottsea hayayse kiam kida wode. ");
INSERT INTO amf_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ko dahaannaar agaa waadiman ea siya ki hanna, ‘Imba saana nivehe’ hamayse yisa woylaminka qaabayse, ");
INSERT INTO amf_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kimbesana waadadhayna eenaam qanan ki yedanna, bardhon eenbesana kinka kummite ki wucina, ");
INSERT INTO amf_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","agaa waadiman easa imbaa kinin bhocchaamon rooronbee kinin dhesaamon wodanbeka niva ki nive. ");
INSERT INTO amf_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kiam kattsi kida qane; ogora ithanam kisa maltina eenabesana kida haye. Ogotear eepibee atsi qiicabe koda maate’’ hamayse kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ogosa budonte Yesus yin ki giyade: ‘‘I Eedi Naas niven wodanka, Barjosa bitamono shaakanam tiyayse uutaam toolaana tambha anzanadettsine. ");
INSERT INTO amf_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Iginasa iira dongna boosona, dongna pakalla ke dahade. ");
INSERT INTO amf_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Anzana boosona shaakanam bish bavayse, shaakanna maatea zayt bavadehe. ");
INSERT INTO amf_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Anzana pakalla kedi yisa shaakanbesana koymo abka zayt yinka ke tiyade. ");
INSERT INTO amf_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Uutayn kapponna, ke wulam gindhe yedonna ke raatade. ");
INSERT INTO amf_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","‘‘Sootin kiaddha laman hamenka, ‘Marrato! Uutaa nividine! Kiam tiyota utee!’ hamayno upsi ko qansimade. ");
INSERT INTO amf_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ogo wodanka anzana wul dhaabhayse yisa shaakanam kalon konin shaakoadettsi ke ashkade. ");
INSERT INTO amf_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Anzana boosona pakallana yi giyna: ‘Wonno shaakano dikana konin hayenna, bannzo zaytin yennora wona imee’ kena ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Anzana pakalla kedi ‘Wombee yembena yeekea zayt wokal qolehe; ogonante shanshaynakal yivayse yena zaskea zayt shanee’ hamayse kena ke maasade. ");
INSERT INTO amf_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Anzana boosonaar zaytin shano ke yivaysaka, uutaa ki nivade. Ashkimbhayse dahaana anzanaar uutaabesana kinka gaydon eenasa galan ooninte ke ardade; ke ardaysaka kerinamaar ko diithadhade. ");
INSERT INTO amf_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","‘‘Ogosa budonte anzana shidhaana nivayse, ‘Imbo, bannzo! Wona kerin bulaa’ kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kidiar ‘Inta yena gon ida giye: Inta yeam dhesattine!’ hamayse kena ki maasade. ");
INSERT INTO amf_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","‘‘Ogonante rooronbee savaatinbeam yenin dhesimonna, qaymayse toolee! ");
INSERT INTO amf_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","‘‘Rooron ogoka Barjosa bitamono kina waadiman waadadhayna eenaam yikal eelayse yinnon koymonam ke gettse kena imayse goyn utaate yivaa eadettsine. ");
INSERT INTO amf_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ke kalaa kalaanana kenin dandeaddha kena kashayse kalaana birre shii dong, kalaana birre shii lamaa, kalaana birre shii kalaa imayse pee abdar ki yivade. ");
INSERT INTO amf_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","‘‘Birren shii dongin tiyaa ea saanawa yivayse kanka naggadayse ab birre shii dong ki adhisade. ");
INSERT INTO amf_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Shii lamaan birren tiyaa ea saanawa yivayse kanka naggadayse birre ab shii lamaa ki adhisade. ");
INSERT INTO amf_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Shii kalaan birren tiyaa ea imbaasa koymonam bavate yivayse pee koyayse peensa iinte ki duukade. ");
INSERT INTO amf_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","‘‘Woda thoothisa budonte igina waadiman eenasa imbaa nivayse, kedar dohon koymon kinnonam dhesana keam oysan ki yedade. ");
INSERT INTO amf_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Shii dongin birren tiyaa ea imbaakal nivayse, birrena kinin adhisaana waaniamaar bavayse, ‘Imbo, ya ina birre shii dong ha imade; iginaar kishaa, birre ab shii dong inta daran adhisidine’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Imbaar kisa ‘Woylamin yindar qajadhea waadiman ea, ya payya hayade; yer likkaka woylamin yindar qajadhea eedi maatayse hanin haapadhonna, yer gebhidar haam kamayse ida haynse. Nivaa; imbesana wozadhota ardaa’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","‘‘Birre shii lamaa tiyaar nivayse, ‘Imbo, ya ina birre shii lamaa ha imade; iginaar kishaa, birre ab shii lamaa inta daran adhisidine’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Imbaar kisa ‘Woylamin yindar qajadhea waadiman ea, ya payya hayade; yer likkaka woylamin yindar qajadhea eedi maatayse hanin haapadhonna, yer gebhidar haam kamayse ida haynse. Nivaa; imbesana wozadhota ardaa’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","‘‘Shii kalaan birren tiyaa ea kikal nivayse, ‘Imbo, ya yiithima buurea, laalima pucchea, eedina burqadhima hanin dohonam i dhesade. ");
INSERT INTO amf_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ogonante kurtumbhayse qalte, koymon hannonam pee koyayse peesa iir i aachade. Koymonoar hasa kosha’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Imbaar kina yin ki giyade: ‘Ya kaa siyaa boosoa waadiman ea, inta yiithima inin buurenbee laalima inin pucchenbeam ya dhesidine. ");
INSERT INTO amf_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Keeda koymon innonam adhisayna eenana ima haam zaskidi hatte ko dahade; intaar inin nivenka koymonam isa adhimaka ida tiye. ");
INSERT INTO amf_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ogonante koymonam kikalanka tiyayse birren shii tabhin yinkal dahaa eana imee. ");
INSERT INTO amf_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Yisa dahaana daran arsayse kina imbha ko imbhe; kinaar mirga ko mirge. Yisa qolmakalanka kisa dohonam kikala tiidha ko tiidhe. ");
INSERT INTO amf_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Agaa pootimaa waadiman eam os mayante dohon thipansa iinte bulayse kiam dhabee; ogotear eepibee atsi qiicabe koda maate’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","‘‘Eedi Naas cecira yisa gaananabesana kisa gobshin gebhonka kinin nivenka, gobshadhon kisa bitamon borkotondar dooqa ki dooqe. ");
INSERT INTO amf_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Zarsino wul kisa birante koda buke; gishiman gishea ea yaanasa iira qollaam kinin edendettsi kidiar yin eenaam kinka kikalanka kida ede. ");
INSERT INTO amf_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yaanaam yisa mizaqimbar, qollaam yisa warkatambar hayayse keam kida woyse. ");
INSERT INTO amf_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","‘‘Ogo wodanka bitaa yisa mizaqimbar dahaana eenana yin kida giye: ‘Yedi Imbayn gobshaanato, idar ora nivee; peen pijadhorra yedayse yena ashkadhon bitamon raqinam tiyee. ");
INSERT INTO amf_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Harrna hambhidianna, daaqardhayse i daaka, iam yedi kunsidine; dheebardhayse i daaka, iam yedi wushidine; chocchi maatayse inin nivenka, iam ye tiyade; ");
INSERT INTO amf_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","pundiri maatayse i daaka, iam ye qattsade; hajadhayse i daaka, iam ye oysade; dhaxadhayse i daaka, nivayse iam ye shedade’ kena kida hame. ");
INSERT INTO amf_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ogo wodanka tipana eena maasayse kina yin keda giye: ‘Imbo, daaqardhayse ha daaka, haapayse haam haa wo kunsaa? Dheebardhayse ha daaka, haam haapayse haa wo wushaa? ");
INSERT INTO amf_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Wodar chocchi maatayse ha nivaysaka, haapayse haam haa wo tiyaa? Pundiri maatayse ha daaka, haam haapayse haa wo qattsaa? ");
INSERT INTO amf_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Hajadhayse way dhaxadhayse ha daaka, haam haa wo shedaa?’ hamayse kiam keda oyse. ");
INSERT INTO amf_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Bitaar kena yinin maasenka, ‘Inta yena gon ida giye: Kina deegana imbanaanasa kalaana yenin waadadhoono ogono ina ye waadadhade’ hamayse kena kida maase. ");
INSERT INTO amf_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","‘‘Ogora yisa warkatambar dahaana eenanaar yin kida giye: ‘Yedi kina ashadhaana eenato, ikalanka os pegimbhee! Seethaanbee kisa gaananabena ashkadhon, rooro wul lay dikimon nuundar yivee. ");
INSERT INTO amf_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Harrna hambhidianna, daaqardhayse i daaka, iam kunseetene; dheebardhayse i daaka, iam wusheetene; ");
INSERT INTO amf_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","chocchi maatayse yedar inin nivenka, iam yedar tiyeetene; pundirdhayse i daaka, iam qattseetene; hajadhaysebee dhaxadhaysebe i daaka, iam shedeetene’ kena kida hame. ");
INSERT INTO amf_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Kediar, ‘Imbo, daaqardhayse way dheebardhayse, chocchi maatayse way pundiri maatayse, hajadhayse way dhaxadhayse ha daaka, haam haapayse kelshima haa wo garaa?’ hamayse keda maase. ");
INSERT INTO amf_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ogo wodanka bitaa ‘Inta yena gon ida giye: Kina deegana eenasa kalaana hattear yenin hayaamonka, inaar hayeetene’ kena kida hame. ");
INSERT INTO amf_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","‘‘Ogonante igina eena rooro wul lay dhabshadhen pirdindar keda yive; tipana eena rooro wul lay daadhendar keda yive’’ hamayse kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesus dhalqin ogo wulam yinin macchonsa budonte, yisa paanan yivayna eenana yin ki giyade: ");
INSERT INTO amf_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","‘‘Rooro lamaasa budonte Paasikan rooroa kinin dohonam yedi dheseeda dhese. Agaa rooroaka i Eedi Naaseam masqalindar konngayse ziitadhe yettsate imbha ko imbhe’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ogo wodanka gudullasa hayonabee peensa donzanabe Qayappa hambhea gudullasa gebhaa ooninte ke bukade. ");
INSERT INTO amf_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ogote Yesusam cubbo goytika yedate kiam deesana kinka ke dhalqade. ");
INSERT INTO amf_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ko dahaannaar, ‘‘Eenin wodar wacimeka dhaabhoamadettsi Paasikan gobshadhea wodanka ko dahabhoode’’ hamayse kinka ke dhalqade. ");
INSERT INTO amf_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesus Bitaania gurdante lamthin burqonka ena dahaa Simoon ooninte ki dahade. ");
INSERT INTO amf_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yesus kummandar dooqayse ki daaka, maa kallo koymo gebhika shandhen gaamen shittonam seeni cawlira ashkadhon bilqaathinka bavate Yesuskal nivayse, gaamen shittonam Yesussa metendar ko kahade. ");
INSERT INTO amf_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yesussa paanan yivayna eenaar ogoam shedayse wacimaate, ‘‘Ko gamen shittonam harrna ko sun yiigadhe? ");
INSERT INTO amf_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kono koymo gebhidar shanshayse koymon ogoam qambhinana imana koda damadhika!’’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesus yin kenin giyenam dhesayse, ‘‘Edon koam yedi harrnee galshe? Kodi ina yer payya ko hayade. ");
INSERT INTO amf_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Qambhina rooro wul yembesana keda dee; inta rooro wul yembesana dahattine. ");
INSERT INTO amf_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kodi ko gaamen shittonam isa bishindar konin kehenka, duukinna ko iam ashkade. ");
INSERT INTO amf_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Inta yena gon ida giye: Peen wul gidir Barjosa dhacchintan upsinam giidhen raqin hamote ko hannaar, edon koyn hayonam konin bhocchadhoadettsi kosa waadimanam giidha ko giidhe’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ogo wodanka tabhi lamaana Yesussa paanan yivayna eenasa kalaa Asqoronto peen ea Yiwda hambhea gudullasa hayonakal yivayse, ");
INSERT INTO amf_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","‘‘Yesusam yettsate i yena imanna ina haree ime?’’ kena ki hamade. Kediar birre bondi makkam kina ke imade. ");
INSERT INTO amf_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kidiar rooroa agaara yedayse Yesusam yettsate kinin imensa kina agea woda zagite ki dahade. ");
INSERT INTO amf_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Irshon qolmin balashan itsadhensa biraa rooroaka Yesussa paanan yivayna eena Yesuskal nivayse, ‘‘Paasikan galanam hamote wonin ashkoadettsia zage?’’ hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kidiar ‘‘Katamante yivayse aynena ‘Woam Dhettsea ‘‘Isa wodano saanidine; ogonante isa paanan yivayna eenabete Paasikan galanam wonin itsayno hannon oonintene’’ hana kida hame’ kina hamee’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yesussa paanan yivayna eena kinin giyaadettsi yivayse Paasikan galanam ke ashkade. ");
INSERT INTO amf_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Peenin sootonsa budonte, Yesus tabhi lamaana yisa paanan yivayna eenabesana kinka kummanna ke dooqade. ");
INSERT INTO amf_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kenin kummenka Yesus ‘‘Inta yena gon ida giye: Yesa shaarira kalaa iam saskate ima ki ime’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kediar ogo yin kinin giyonka kattsi burqadhayse kalaa kalaana wul ‘‘Imbo, inta i doo?’’ hamayse kiam oysan ke yedade. ");
INSERT INTO amf_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesus yin giyayse kena ki maasade: ‘‘Iam saskate imea imbesana kinka sharqante aanin arsaane. ");
INSERT INTO amf_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Inta Eedi Naas ena birayse innon goynsa thaapadhondettsi diyayda diye; ko dahaannaar i Eedi Naasiam saskate imea ea agaana hay! Ea agaa ki adhadhaamma kina payyane’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Saskate imea Yiwda ‘‘Woam Dhettsea, inta i doo?’’ ki hamade. Yesus kina yinin maasenka, ‘‘Hanin giyaadettsine’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Galanam kenin itsenka, Yesus balashanam tiyayse Barjoam ki gobshade; qunthayse yisa paanan yivayna eenana ‘‘Kay, itsee; kono isa waanone’’ hamayse kena ki imade. ");
INSERT INTO amf_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Wucadhenamaar tiyate Barjoam gobshayse, yin giyayse ki kena imade: ‘‘Yedi wul wucadhen kosa iira wucee. ");
INSERT INTO amf_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kono thoothin eensa seesonam shiishanna laymayno haalin mallanam eshkayno isa zombhinone. ");
INSERT INTO amf_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ko dahaannaar inta yena ida giye: Imbasa bitamonte woynea hattasa aapin cuubadhon haalin wucadhenam yembesana kinka wonin wucenka yekka, keeda kaara os inta koam wucattine’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ogosa budonte, mazmur zammarayse Dabirezayt dhukanam ke utade. ");
INSERT INTO amf_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ogo wodanka Yesus yisa paanan yivayna eenana yin ki giyade: ‘‘ ’Yaana gisheam qanate deesayda deese; gishadhayna yaanaar thar thar hama ke hame’ hamayse thaapadhondettsi sootin koam yedi wul iam gareeda gare. ");
INSERT INTO amf_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ko dahaannaar diira inin dhaabhonsa budonte, Galila peendar yeam birayse ida yive’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Bhethiroos yi giyna: ‘‘Eeno waani wul haam garea ko hanna, inta hamin ko dahaakaar haam garattine’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesus kina ‘‘Inta hana gon ida giye: Kina sootin koam baacha biraa qiiqima makkam goyt ‘Inta kiam dhesattine’ hamayse marimaada marime’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Bhethiroosaar ‘‘Dembhi ko hannaar, hambete diyayda diye; hamin ko dahaakaar, ‘Kiam dhesattine’ hamayse marimattine’’ kina ki hamade. Yesussa paanan yivayna eena waani wul yin ke giyade. ");
INSERT INTO amf_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ogosa budonte Yesus kembesana kinka Getesemaane hambhen raqindar ki yivade. Ogote yinin yeskenka, Yesus yisa paanan yivayna eenana ‘‘Inta ogote yivayse Barjoam inin miskenka, yedi kote dooqee’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yinin yivenka Bhethiroosbee Zabdoos naana lamaanabeam yinka entsate yivayse qaaboka atite gaalan ki yedade. ");
INSERT INTO amf_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kena yin ki giyade: ‘‘Qaabono idar thoothayse iam deesamba koda haye; ogona yedi kote dooqayse imbesana wocchimbhayse toolee’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kekala likka pegadhayse, wotinka yisa peendar yirk hamayse yin giyayse ki miskade: ‘‘Imbo, dandimea ko hanna, ina ko gaalen wucimanam inin wucoamadettsi ikalanka koam saskaa. Ko dahaannaar hanin nashaadettsi ko dee; inin nashaadettsi ko dahabhoode’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ogosa budonte makkamma yisa paanan yivayna eenakal maatate kinin nivenka, raatayse ke daaka keam haapayse, Bhethiroosna yi giyna: ‘‘Yedi imbesana ta savaat kala hattear wocchimbhayse toolano yeam bashidu? ");
INSERT INTO amf_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Taysate yeam siyonsa iinte arsente yenin ardoamadettsi wocchimbhayse Barjoam miskee. Eedisa qaabe ashkimbhine; hattear waano qajadhine’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesus lansi maatate yivayse, ‘‘Imbo, gaalen wucimano kono i wucima ikalanka sagana dandimimino ko hanna, hanin nashaadettsi ko dee’’ hamayse ki miskade. ");
INSERT INTO amf_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pir yisa paanan yivayna eenakal kinin nivenka, keam gindhisaka raatayse kenin dohonte keam ki haapade. ");
INSERT INTO amf_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Keam garayse qalte, ini Barjoam kinin miskendettsi makkanso pir ki miskade. ");
INSERT INTO amf_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ogora yisa paanan yivayna eenakal nivayse kena yin ki giyade: ‘‘Taar yedi raatidu? Tapir lay ukunse ukunso? Marrato! Wodanoar yeskidine; i Eedi Naaseam seeson eenasa aaninte saskate iam koda imbhe. ");
INSERT INTO amf_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Keeda dhaabhee! Wo yive; iam saskate imea kash, theedidine’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesus ogoam akar giyte ki daaka, marrato! Tabhi lamaana kisa paanan yivayna eenasa kalaa Yiwda ki nivade. Kimbesana kinka halpabee haljobe bovoono thoothino eeno gudullasa hayonabee peensa donzanabekalanka nittsadhaysaka ko nivade. ");
INSERT INTO amf_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yesusam saskate imea Yiwda eenana birayse ‘‘Inin sunqea kidine; kiam yedee’’ hamayse milkit kena imidine. ");
INSERT INTO amf_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yiwda saanawa Yesuskal nivayse, ‘‘Dhettsea, payyaw?’’ hamayse kiam ki sunqade. ");
INSERT INTO amf_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesus kina ‘‘Isa nashoa, ya hanin qaabonam thoosaa’’ ki hamade. Ogora eeno Yesuskal nivayse kiam ko yedade. ");
INSERT INTO amf_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ogo wodanka Yesusbete dahaana eenasa kalaa halpanam yisa gochayse, gudullasa gebhaasa waadiman ea qaaminam taxate ki dhabade. ");
INSERT INTO amf_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesus kina yin ki giyade: ‘‘Eedidar halpa gochea wul halpaka kida diye. Ogonante halpanam hasa halpan ooninte arsaa! ");
INSERT INTO amf_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Inta Imbaam miskidi hatte i daana, paydadhimina banqin kansayna yisa gaananaam ina taaki kinin nittsimadettsi ko hakal maato? ");
INSERT INTO amf_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Yin ko hanna, Mathaapin Gazante ‘Gaale tiya kiam zaska ko zaske’ hamayse thaapadhoono hamin ko thoothe?’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ogo wodanka Yesus thoothin eenna ‘‘Eedisa koymo buurate itsea eedidettsi hayayse iam yedana halpabee haljobe bavatee nivaaw? Rooro wul Barjosa gazan ooninsa mayante dooqayse eenaam dhettsada inin dehenka, iam yedeetene. ");
INSERT INTO amf_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ko dahaannaar ogono wul yin konin dohoono ena birayse Barjokala qansayse eenna giyayna eenayn thaapoono konin thoothoadettsine’’ kena ki hamade. Ogo wodanka Yesussa paanan yivayna eena wul kiam garayse gobate ke yivade. ");
INSERT INTO amf_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ogosa budonte Yesusam yedaana eena gudullasa gebhaa Qayappakal kiam entsate ke yivade. Ogotear Musesa yigginam dhettsayna eenabee donzanabe kinka bukayse ke dahade. ");
INSERT INTO amf_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Bhethiroos gudullasa gebhaa kerminsa iin kinin yeskenka yekka pegeka Yesussa paanan yivite ki dahade. Kermintear ardayse Yesusdar dhalqadhen dhalqinsa macchin taxadhenam shedana poolisanabete kinka ki dooqade. ");
INSERT INTO amf_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Gudullasa hayonabee Yiwda peensa donzana wulbe Yesusdar dembhi pirdina yeskisea buuda tarjamo zagite ke dahade. ");
INSERT INTO amf_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Buudamonka daran tarjayna thoothina eena kekal ke nivaakaar, dembhina kiam yeskisea tarja haapadhadehe. Macchindar eedi lamaa tarja tarjota nivayse, ");
INSERT INTO amf_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","‘‘Kaa ea ‘Barjosa gazan ooninam kottsayse rooro makkamka pir koam woysana damayda dame’ ki hamade’’ hamayse ke tarjade. ");
INSERT INTO amf_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Gudullasa gebhaa dhaabhayse, ‘‘Eena kina hadar kenin tarjensa kala hattear ya yer giyattanu?’’ hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yesus lay ki hamade. Gudullasa gebhaa pir Yesusna, ‘‘Lay dehea Barjosa naabenka ida haam oyse: Barjo Naasa, Barjoyn qadhaa Kiristoos ya hanna wona giyaa’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesus ‘‘Hanin giyaadettsine. Ko dahaannaar inta yena ida giye: Kaara yedayse Eedi Naas kantanka dahaa Barjosa mizaqimbar dooqayse kinin dohonbee cecira polonka kinin nivenbeam haapeeda haape’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ogo wodanka gudullasa gebhaa dhagaka yisa apalanam hattsayse yin ki giyade: ‘‘Ea kaa Barjoam ki iirade; keeda os tarja ab wona harrna ko zaske? Yedi kisa iirimenam qansidine. ");
INSERT INTO amf_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Yena yer har ko maate?’’ ki hamade. Kediar, ‘‘Dembhi ko kiam zaske’’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ogo wodanka kisa aapindar pathimaate kiam ke gutade. Waani eenoar kiam cavaate, ");
INSERT INTO amf_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","‘‘Ya Barjoyn qadhaa Kiristoos, haam qanaa hayne? Wona giyaa’’ hamayse kiam ke bagade. ");
INSERT INTO amf_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Bhethiroos gudullasa gebhaa mayan kerminsa iinte dooqayse ki daaka, ogote waadiman maanasa maa kallo kikal nivayse, ‘‘Yaar Galilara nivaa Yesusbete ha dahade’’ kina ko hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kidiar ‘‘Hanin giyayno yer har konin dohonam inta dhesattine’’ hamayse een wulsa birante ki marimade. ");
INSERT INTO amf_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kerminsa kerinka kinin utenka, maa ab kallo kiam shedayse ogote dohon eenna ‘‘Ea kaa Naazret peen Yesusbete ki dahade’’ ko hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Bhethiroos tapir mallaate, ‘‘Agaa hanin giyea eam inta dhesattine’’ hamayse ki marimade. ");
INSERT INTO amf_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Likka kap hamayse ogote woyayse dahaana eena Bhethirooskal theedayse, ‘‘Ya hasa dhalqinka dhesimaada dhesime; gon ya kembesana kinka ha dahade’’ kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kidiar ‘‘Inta ea kaam dhesattine!’’ hamayse yiam ashite malliman ki yedade. Saanawa baacha ki qiiqade. ");
INSERT INTO amf_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Bhethiroosaar ‘‘Baacha biraa qiiqima iam makkam goyt ‘Inta kiam dhesattine’ hamayse hada marime’’ hamayse Yesusin kina giyoono kalan bhoq konin hamenka, mayan utayse qaaboka kattsi ataate ki eepade. ");
INSERT INTO amf_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Peen sedhaysaka gudullasa hayonabee peensa donzanabe wul Yesusam deesana kinka ke dhalqade. ");
INSERT INTO amf_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kiam dhaxaysear bavate peen wottsea Bhilathoosna saskate ke imade. ");
INSERT INTO amf_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","4","Ogora Yesusam saskate imaa Yiwda Yesusdar pirdadhon pirdinam yinin haapenka, seesonam yisa kinin dhesonna ki burqadhade. Gudullasa hayonabee donzanabena nivayse, ‘‘Kaa ea gazaam deesadhoadettsi saskate kiam inin imonna, inta dhabidine’’ hamayse birrena bondi makkammaam maasate kena ki imade. Kediar ‘‘Woam ogote arsayno hare? Ogono gaale hantine’’ kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kidiar birrenam Barjosa gazan ooninte dhabayse utaate yivayse, yiam rookayse ki diyade. ");
INSERT INTO amf_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Gudullasa hayonaar birrenam tiyayse, ‘‘Kono birre eedisa zombhi baza konin dohonna, Barjosa gazan ooninte iminton imbhenbesa iir wonin worsoadettsi wona giidhadehe’’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kinka kedi dhalqayse een peera nivayse diyaanayn duukadhea raq konin maatoadettsi ogo birrenka eedi daa meeshea kalaasa haami ke shanade. ");
INSERT INTO amf_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ogona haamin ogoam kinaka yekka ‘‘Zombhin haami’’ hamayse ko koam eldhe. ");
INSERT INTO amf_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Ogo goynka ‘‘Israveel eena kisa baza konin maatoadettsi kenin giyoono birrena bondina makkammaam tiyayse Barjo Imbaa ina kinin giyondettsi eedi daa meesheasa haaminna ke kashade’’ hamayse ena birayse Barjokala qansayse eenna giyea Ermeasin giyoono ko thoothade. ");
INSERT INTO amf_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ogora Yesusam peen wottsea Bhilathoossa birante entsate ko woysadhade. Peen wottsea ear, ‘‘Ayiwd eenasa bitaa yaw?’’ hamayse kiam ki oysade. Yesusaar ‘‘Inta hanin giyaadettsine’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Gudullasa hayonabee donzanabe kiam kenin bersenka, kidi yer kala hattear maasadehe. ");
INSERT INTO amf_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ogosa budonte Bhilathoos Yesusna ‘‘Hadar yer meemay goytika kenin tarjenam ya qansattanu?’’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yesus peen wottsea eanin targadhenka yekka upsi kala hattear kina maasadehe. ");
INSERT INTO amf_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Peen wottsea ea levenka levenka Paasikan wodanka, dhaxadhon eensa iira kinin buloadettsi eenin zagea eedi kalaam kinin bulea kisa dambi dahade. ");
INSERT INTO amf_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ogo wodanka Barbaan hambhea ea wobamon waadimanka kattsi dhesimaa dhaxadhidi hatte ki dahade. ");
INSERT INTO amf_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ogona eeno bukayse konin dohonte Bhilathoos kena yi giyna: ‘‘Yena inin buloadettsi yenin zagea hayne? Barbaanmoo? Way Barjoyn qadhaa Kiristoos hambhea Yesusu?’’ hamayse keam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Yin giyayse keam kinin oysoonoar Yesusam sun woogintaka yettsate saskayse kiam kenin imonam kinin dhesennane. ");
INSERT INTO amf_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pir Bhilathoos pirdin raqindar dooqayse ki daaka, geshono kisa ‘‘Agaa tipa ea goynsa inta nii sootin haamaka kattsi i gaalade; kidar yer kala hattear hayaabhode’’ hamayse daran apo ko yittsade. ");
INSERT INTO amf_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ko dahaannaar gudullasa hayonabee donzanabe ‘‘Barbaanam ko buldhe; Yesusam ko deesadhe’’ kenin hamoadettsi eenaam yidar ke maasade. ");
INSERT INTO amf_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Peen wottsea ear maasayse ‘‘Ta lamaana eena kinasa yena hamaam inin buloadettsi ye zage?’’ hamayse tapir keam ki oysade. Kediar, ‘‘Barbaanam wona bulaa’’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Bhilathoosaar, ‘‘Ta keeda Barjoyn qadhaa Kiristoos hambhea Yesusam hamin i kiam hayo?’’ kena ki hamade. Kedi wulaar ‘‘Kiam ko ziitadhe!’’ hamayse ke maasade. ");
INSERT INTO amf_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kidiar ‘‘Harrnaqa ki ziitadhe? Kinin hayoono seesono kisa hare?’’ hamayse keam ki oysade. Kediar ‘‘Kiam ko ziitadhe!’’ hamayse kalon ilatite ke waajade. ");
INSERT INTO amf_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Bhilathoosaar eenbesana kinin dhalqayno goore konin dhaaserra ab yer pootima konin dohonam dhesayse noqo tiyayse, ‘‘Inta kaa tipa eam deesadhente yekal qolattine; yedi yenin nashaadettsi hayee’’ hamayse eensa birante aaninam yisa ki shiidhade. ");
INSERT INTO amf_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Eeno wulaar kina konin maasenka, ‘‘Kinnon dembhin goynka nivayno pirdino wombee naana wonnabedar ko yeske’’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ogo wodanka Bhilathoos Barbaanam kena ki bulade; Yesusamaar ki qansade; masqalindar konngayse kiam kenin ziitoadettsi kena ki imade. ");
INSERT INTO amf_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ogo wodanka peen wottsea easa poolisana Yesusam kisa kerminte yedate yivayse, shidhaana poolisana wulam kisa gasante ke buskade. ");
INSERT INTO amf_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kisa apalanamaar kidara bulayse apala zoo ke kidar qattsade. ");
INSERT INTO amf_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ukumbha qorayse kisa metendar ke wodade; kisa mizaqa antakaar kiam haljo ke yettsade. Kisa birantear kumpurdhite, ‘‘Ayiwd eenasa bitaa, payyamo hana ko dee’’ hamada kiam ke bagade. ");
INSERT INTO amf_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kidar pathimaate aanira kisa haljonam tiyayse kanka kisa metenam maasite maasite ke qanade. ");
INSERT INTO amf_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kiam kenin bagonsa budonte, apalan zoonam kidara bulayse kinnon apalanam tapir kidar ke qattsade; kiamaar masqalindar konngayse ziitate deesota entsate ke yivade. ");
INSERT INTO amf_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Peen wottsea easa kermira kenin utenka Simoon hambhea Qerena peen eam haapayse Yesusam ziitadhen masqalinam kantaka kiam ke kettsade. ");
INSERT INTO amf_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kediar Golgotta hambhea raqaam ke yeskade; ‘‘Golgotta’’ hamintano ‘‘Eedisa Metedettsi Maataa Raq’’ hamintane. ");
INSERT INTO amf_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ogote cishinbesana worsadhon woynea hattasa aapira cuubate ashkadhon wucadhenam kinin wucoadettsi ke kina imade. Kidiar suutayse wucana zagadehe. ");
INSERT INTO amf_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Masqalindar kiam konngayse kenin ziitonsa budonte, kisa apalandar itha dhabayse ke kashimade. ");
INSERT INTO amf_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kediar raqaate dooqayse kiam ke toolade. ");
INSERT INTO amf_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kidar pirdadhonam dhettsea ‘‘Kaa Ayiwd eenasa bitaa Yesusne’’ hamea thaapi thaapate Yesussa metembar kiam ziitadhon masqalindar ke konngade. ");
INSERT INTO amf_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ogo wodanka pir eedi lamaa eedisa koymo sarite itsaynasa, kalaam Yesussa mizaqimbar, lansoam kisa warkatambar hayayse keam konngayse ke ziitade. ");
INSERT INTO amf_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kisa demenka yivayna eenaar kiam iiraate metenka jugimaate, ");
INSERT INTO amf_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","‘‘Ya ‘Barjosa gazan ooninam kottsayse rooro makkamka pir ida woyse’ hamea, ta haam dhacchaa! Barjo Naas ha daana, ta masqalindara hanchaa!’’ hamaate kiam ke bagade. ");
INSERT INTO amf_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ogodettsi pir gudullasa hayona Musesa yigginam dhettsayna eenabee donzanabesana kinka hamayse yin giyte ke kiam bagade: ");
INSERT INTO amf_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","‘‘Een waaniam dhacchayse yiam dhacchana damadehe. Kidi Israveel eensa bit ki hanna, yinda ta ko kiam ziitadhon masqalindara ki hanche; wodiar kidar woylamin qajooda qaje. ");
INSERT INTO amf_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kidi Barjodar woylamin ki qajade; ‘Inta Barjo Naasine’ ki hamade. Ogonante Barjo kiam nashea ki hanna, yinda ta kiam ki dhacche’’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Een koymon sarite itsayna eena kimbesana ziitadhaanaar ogodettsi kiam ki iirade. ");
INSERT INTO amf_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Rooron savaat laxra yedayse savaat salin thoothenka yekka peen wuldar thipa ko maatade. ");
INSERT INTO amf_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Savaat sal konin maatenka Yesus ‘‘Elohe, Elohe! Lama sabaqtani?’’ hamayse upsin yisaam kattsi dheg hayayse ki ilatade. Kosa bulinoar, ‘‘Isa Barjoa, isa Barjoa! Harrna iam garaa?’’ hamintane. ");
INSERT INTO amf_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ogote woyon eensa waani eeno Yesusin giyenam qansayse, ‘‘Kaa ea Eeliasam kida eele’’ ko hamade. ");
INSERT INTO amf_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ogo wodanka saanawa kesa iira kalaa gobayse saaro tiyate woyni thorkaasa iir tittsate bavayse malkaka Yesussa apondar thettsayse ki wushade. ");
INSERT INTO amf_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Waani eeno ‘‘Yinda woyaa; Eeliasin nivayse kiam dhacchenam wo shede’’ ko hamade. ");
INSERT INTO amf_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesus pir upsin yisa dheg hayayse ilatayse ki diyade. ");
INSERT INTO amf_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ogo wodanka Barjosa gazan ooninsa gidin kashadhoono apallo bhaara choo nukindar kiaddha raq lamaadar ko havade. Peenoar ko shohade; senna laytanaar ke bhaqade. ");
INSERT INTO amf_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Duukinsa kerroar ko bulimade; diyon gazan eensa thoothino dembhira dhaabhayse ");
INSERT INTO amf_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","duukira utidine. Yesus dembhira kinin dhaabhonsa budonte gazan kataman Yerusaalemdar ko ardade; ogo raqintear thoothin eenna ko haapadhade. ");
INSERT INTO amf_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mato alaqabee kimbesana Yesusam toolayna eenabe peenin shohenbee waani yerinbe yinin haapen wodanka kattsi kurtumbhayse, ‘‘Gon ea kaa Barjo Naasine’’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Galila peera yedayse Yesusna waadadhite kisa paanan yivayna maa thoothi waani pegeka woyayse shedayna raqin ogote ke dahade. ");
INSERT INTO amf_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Iginasa iira Megdela peen edon Mayriyambee, Yayqoobbee Yoseepbesa indan Mayriyambee, Zabdoos geshonbe gidir ke dahade. ");
INSERT INTO amf_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Peen sootaysaka Armatias kataman ea Yoseep hambhea eedi wodimo kalaa ki nivade; kidiar Yesussa paanan yivea eedi ki dahade. ");
INSERT INTO amf_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kidi Bhilathooskal yivayse Yesussa leesinin kina kinin imoadettsi ki miskade; Bhilathoosaar leesinin kina imbhoadettsi ki giyade. ");
INSERT INTO amf_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ogora Yoseep leesinam tiyayse apala haalika ki ochade. ");
INSERT INTO amf_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Seeni layta palsayse yinante kinin ashkon haalin duukin oolonte ki kiam duukade. Ogora seeni gaari gunngate duukinsa aponam kanka shupayse ki yivade. ");
INSERT INTO amf_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Megdela peen edon Mayriyambee Mayriyam waabe ogo duukinsa birante dooqayse ke dahade. ");
INSERT INTO amf_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ayiwd eensa ukunsen rooroaytana burburi gudullasa hayonabee Parisa eenabe kinka bukayse Bhilathooskal yivayse yin ke giyade: ");
INSERT INTO amf_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","‘‘Imbo, ea kaa eenaam dhaddhisea yinin diyonsa birayse, ‘Inta dembhira rooro makkamsa budonte dhaabhayda dhaabhe’ kinin hamoono wona bhoq ko hamade. ");
INSERT INTO amf_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ogona kisa paanan yivayna eena nivayse kisa leesinam kenin diiboamadettsibee eennaar ‘Yesus dembhira dhaabhidine’ hamayse kenin giyoamadettsibe duukino rooro makkamna payya hayayse konin toldhoadettsi giyaa. Ogotay hamidi ko hanna, eenaam kinin dhaddhisayno birora bere macchinte kalon sagino koda doaye’’ kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Bhilathoosaar, ‘‘Toolayna eena daane; yedi keam entsate yivayse yenin dhesaadettsi hayayse tolsee’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kediar yivayse duukinsa apon shupadhon seeninin buldhoamadettsi daran maytam qanayse toolayna poolisanaka ke tolsade. ");
INSERT INTO amf_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ayiwd eensa ukunsen rooroayn maqonsa budonte, gabansa rooroa biraa Wuudika burburi Megdela peen edon Mayriyambee Mayriyam waabe duukinam shedo ke yivade. ");
INSERT INTO amf_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Dhesadhima peeno kekal kattsi ko zigimade; Barjosa gaanaar cecira nivayse duukin oolonsa apon shupadhon seeninam gunngayse daran ki dooqade. ");
INSERT INTO amf_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kisa wotinoar bhalqantdettsi shaakayno, apalloar kisa chechidettsi cawloono ko dahade. ");
INSERT INTO amf_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Duukin toolayna eenaar Barjosa gaanaam yinin kurtumbhon goynka kattsi gibazayse eedi diyaadettsi ke maatade. ");
INSERT INTO amf_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Barjosa gaanaar maanana yin ki giyade: ‘‘Kurtumbheebhode! Masqalindar konngate ziitayse deesadhaa Yesusam yenin zagenam dhesayda dhese. ");
INSERT INTO amf_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kidi kote qolehe; ‘Dembhira dhaabhayda dhaabhe’ yinin hamondettsi kidi dhaabhidine. Kisa leesinin duukadhon raqinam nivayse shedee. ");
INSERT INTO amf_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Taaki keeda yedi saanawa yivayse kisa paanan yivayna eenana ‘Kidi dembhira dhaabhidine; yeam birayse Galila peendar kida yive; yediar kiam ogote yeda haape’ hamayse kena giyee. Inta yena ogoam giydine’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ogora maana igina kurtumbhebee gebhi wozabeka duukin raqira saanawa utayse Yesussa paanan yivayna eenana giyota ke gobade. ");
INSERT INTO amf_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Yesus goynte kedar keerayse ‘‘Nagaya’’ kena ki hamade. Kediar kikal theedayse kisa roon yedayse kina ke goodimade. ");
INSERT INTO amf_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ogo wodanka, Yesus kena ‘‘Kurtumbheebhode! Yivayse imbanaana Galila peendar kenin yivoadettsi kena giyee; iam ogote keda haapoaye’’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Maana duukin raqira maatayse yivite goynte ke daaka, duukinam toolayna eenasa waani Yerusaalem katamandar yivayse hamon yerin wulam gudullasa hayonana ke giyade. ");
INSERT INTO amf_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Gudullasa hayonabee donzanabe kinka bukayse kenin dhalqonsa budonte, duukinam toolayna poolisanana birre gebhi imayse, kena yin ke giyade: ");
INSERT INTO amf_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","‘‘ ’Wo raataysaka Yesussa paanan yivayna eena sootinka nivayse kisa leesinam diibate ke yivade’ hamayse eenna giyee. ");
INSERT INTO amf_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ko dhalqinam peen wottsea bere ki qansaakaar, yedar yer siya kinin hayoamadettsi wodi kiam dhettsooda dhettse’’ kena ke hamade. ");
INSERT INTO amf_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ogora igina poolisana birrenam tiyayse kena giidhondettsi ke giyade. Ogo dhalqinam kina wodan koka yekka Ayiwd eenasa peen wul gidir koam giyte ke dahade. ");
INSERT INTO amf_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tabhi kalaana Yesussa paanan yivayna eena Galila peente Yesusin kena giyon dhukandar ke yivade. ");
INSERT INTO amf_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kiam kenin haapenkaar kumpurdhayse kina ke goodimade; kesa iira ‘‘Kaa gon Yesusu?’’ hamayse kiam ke qothimade. ");
INSERT INTO amf_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesus kekal theedayse kena yin ki giyade: ‘‘Hayamono wul cecinbee peentebe ina imbhidine. ");
INSERT INTO amf_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","20","Yedi keeda yivayse peendar dohon zarsin wulam Barjo Imbaabee, Naasabee, Manpas Gazanbesa naabenka keam shivaate, inin yena giyon wulam kenin tooloadettsi keam dhettsaate, isa paanan yivayna eena keam hayee. Intaar peensa macchinka yekka rooro wul yembesana ida dee’’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Barjosa Naasa Yesus Kiristoossa dhacchintan upsino konone. ");
INSERT INTO amf_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","3","“Shedaa! Hasa goynam ashkea isa ergen eam hasa birante yittsayda yittse. Ogonoar ‘Marrato! Barjoyn yekal nivenna, yesa woylaminam ashkee; goynamaar kina gaz hayee’ hamayse ilatea easa upsino darante koda qansime” hamayse Barjokala qansayse eenna giyea Isiassa mathaapinte thaapadhondettsine. ");
INSERT INTO amf_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ogonante Shivea Wannisaar, “Yesa seesonam gardhoadettsi, seeson waadimanam garayse Barjodar maatayse shiidhee” hamaate Barjosa upsinam giyada darandar ki yivade. ");
INSERT INTO amf_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yiwda peen eenabee Yerusaalem katamante dahaana eena wulbe Wanniskal nivayse yisa seesonam kenin buuthenka, Wannis Yordaanoos baynte keam kida shive. ");
INSERT INTO amf_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Wannisaar gamalesa sitika ashkadhon apalan qaadhite ki dahade. Yisa karnantear qalbatha kida dhaxe. Kinin itsaynoar seerebee qoa kuribene. ");
INSERT INTO amf_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kidiar “Inin yirk hamayse kisa dunngurinsa dhaxinam hattear bulana inin damima idara kantanka sagea isa budonte niva ki nive. ");
INSERT INTO amf_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Inta noqoka yeam ida shive. Kidi yeam Manpas Gazanka kida shive” hamayse eenna giyte ki dahade. ");
INSERT INTO amf_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ogo wodanka Yesus Galila peen Naazret katamara ki nivaysaka, Wannis Yordaanoos baynte kiam ki shivade. ");
INSERT INTO amf_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Saanawaar Yesus noqora kinin utenka, cecino bulimayse Manpas Gazano waleedettsi daran konin hanchenam Wannis ki haapade. ");
INSERT INTO amf_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ogora “Inin nashea isa Naasa yane. Hanka ida wozadhe” hamea upsi cecira ko qansimade. ");
INSERT INTO amf_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Saanawaar Manpas Gazano Yesus darandar kinin yivoadettsi kiam ko dhaasade. ");
INSERT INTO amf_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Darantear eedi lamaa kaysa rooro Seethaanka taysadhaate ki dahade. Dabinbetear ki dahade. Barjosa gaananaar kina waadadhite ke dahade. ");
INSERT INTO amf_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","15","Wannisam yedate dhaxadhonsa budonte, Yesus Barjosa dhacchintan upsinam eenna giyada, “Roorono maqidine. Barjosa bitamono yekal theedidine. Ogonante seeson waadimanam garayse Barjodar maatee. Barjosa dhacchintan upsinam gonne hamayse tiyee” hamada Galila peendar ki yivade. ");
INSERT INTO amf_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ogo wodanka Yesus Galila bazinsa aponka kinin yivenka, Simoonbee kisa indanaasa Indiriasbeam ki haapade; kediar kaaran yedayna yinin dohonna, yisa kaaran yeden zaaninam bazindar apite ke dahade. ");
INSERT INTO amf_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesusaar yi giyna: “Marrato! Yedi dhaabhayse isa paanan nivee. Kaaran yenin yedendettsi Barjosa bitamondar eenaam yenin maasoadettsi yeam ida haye” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kediar kaaran yininka yeden zaaninam saanawa garayse Yesussa paanan yivan ke yedade. ");
INSERT INTO amf_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ogora likka sus mak kinin hamenka, Zabdoos naana Yayqoobbee Wannisbeam ki haapade. Kediar bazindara sagadhen gonngalante dooqayse kaaran qazadhen zaaninam kenin ashkenka, ");
INSERT INTO amf_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","saanawa Yesus keam ki eelade. Kediar imbaa Zabdoosbee kisa waadiman eenabeam kinka bazindara sagadhen gonngalante garayse Yesussa paanan yivan ke yedade. ");
INSERT INTO amf_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ogora Qipirnaahoom katamante nivayse ke ardade. Ayiwd eensa ukunsen rooroakaar Yesus kesa bukin raqinte ardayse eenaam dhettsan ki yedade. ");
INSERT INTO amf_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Qansoono eeno kinin dhettson timmirinka kattsi ko targadhade. Ogonoar konin targadhoono Musesa yigginam dhettsaynadettsi dayma kidi yisa hayamonka eenaam dhettsite kinin dohonnane. ");
INSERT INTO amf_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ogo wodanka kesa bukin raqinte beeroyn yedaa eedi kalaa dahade. ");
INSERT INTO amf_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Kidiar Yesusna “Naazret peen Yesuso, hambesana wosa dohoono hare? Woam kaysanaa nivaaw? Hay hanin dohonam inta dhesidine. Ya Barjokala nivaa gazaane” hamayse ki ilatade. ");
INSERT INTO amf_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesusaar beeroaka “Lay hamaa! Eadara utaa!” hamayse kiam ki bitade. ");
INSERT INTO amf_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Eamaar dhabayse kinin qaptisonsa budonte, gebhi upsika kiam ilattsayse beeroa kidara ki utade. ");
INSERT INTO amf_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Eeno wulaar “Kono yer hare? Kono timmiri haalitayu? Yisa hayamonka beeronana kida giye. Kediar kina ee keda hame” hamayse kinka kikal kenin oysenka yekka kedi targadhidine. ");
INSERT INTO amf_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Saanawaar Yesusin waadadhoono Galila peente dohon raqin wul gidir ko qansimade. ");
INSERT INTO amf_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ogo wodanka Yesusbee, Yayqoobbee, Wannisbe bukin raqira utayse Simoonbee Indiriasbesa oonin ke ardade. ");
INSERT INTO amf_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simoonsaar baysino bishi occhea hajimoka wodhayse ko dahade. Konin burqadhonamaar saanawa Yesusna ke giyade. ");
INSERT INTO amf_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesusaar kokal theedayse kosa aanin yedayse koam ki dhaasade. Bishin occhayno koam konin garenka galan baxan kena ko yedade. ");
INSERT INTO amf_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Hayn wavayse peenin sootenka, eeno hajadhaana eenabee beeronin yedaana eena wulbeam Yesuskal bavate nivan ko yedade. ");
INSERT INTO amf_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Katamante dohoono eeno wulaar mayante bukayse ko dahade. ");
INSERT INTO amf_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesusaar waana waana hajimoka yedadhon thoothin eenam ki pacchade. Thoothin eendaraar beeronam ki bulade. Beeronaar hay kinin dohonam kenin dhesenna kiam kenin giyoamadettsi ki marade. ");
INSERT INTO amf_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yesus peen sedhima seddhiman dhaabhayse eedinin qolmon raqinte yivayse Barjoam ki miskade. ");
INSERT INTO amf_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoonbee kimbesana kinka dahaana eenabe kiam zagate ke yivade. ");
INSERT INTO amf_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kiam kenin haapenkaar, “Eeno wul haam zaga ko zage” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesusaar “Inin nivoono Barjosa upsinam giyota konin dohonna, igina theedin dahaana gurdanar inin giyoadettsi wo yive” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ayiwd eensa bukin raqintear Barjosa upsinam giyada beeronam eendara bulada Galila peen wulir yaayte ki dahade. ");
INSERT INTO amf_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Eedi kalaa lamth burqoka dahaa Yesuskal hatte kina kumpurdhayse, “Ha nashidianna, iam pacchana damaada dame” hamayse kiam ki miskade. ");
INSERT INTO amf_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesusaar kina burqadhayse yisa aaninam kidar wodayse, “Haam pacchana nashayda nashe, paashaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Saanawa easa lamthin burqono kiam konin garenka ki paashade. ");
INSERT INTO amf_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Yesus eam yinin yittsenka, “Hanin paashonam eedi haynaar hanin giyoamadettsi mete hasaam gishaa. Ko dahaannaar, yivayse hasa bishinam gudulana dhahaa. Eennaar hanin paashoono tarja konin maatoadettsi Museyn giyon Barjona machadhen marshanam imaa” hamayse upsi wocchika kina giyayse saanawa ki kiam yittsade. ");
INSERT INTO amf_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ko dahaannaar kidi kikala utanka een wulna giyan ki yedade. Ogonante Yesus may katamandar ardano kiam ko bashade. Ogona eenin qolmon darante daan ki yedade. Raqin wulraar eeno kalan koda nive. ");
INSERT INTO amf_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Rooro likkasa budonte, pir Yesus Qipirnaahoom katamandar maatate ki nivade; ogote oonisa iir ardayse kinin dohoono ko qansimade. ");
INSERT INTO amf_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Thoothino eeno Yesuskal nivayse ooninam thoothayse mayanin kena tokenka yekka ko bukade; kidiar Barjosa upsinam kena giyte ki dahade. ");
INSERT INTO amf_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Eedi oydi waani hajimonka malgimaa eedi kalaam haaqaka Yesuskal bavate ke nivade. ");
INSERT INTO amf_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Eensa thoothamonka dhaabhoono kidar eam arsana kenin bashadhenka, ooninsa illinam kottsayse Yesusin raqa dahaadar eam haaqan kenin bavate nivonka ke arsade. ");
INSERT INTO amf_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesusaar kidar woylamin kenin qajonam shedayse hajimon eana yi giyna: “Inaane, hasa seesono hana gardhidine” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Musesa yigginam dhettsaynasa waani waani eena ogote dooqayse ke dahade. Kediar woylamka qaabayse, ");
INSERT INTO amf_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ea kaa hamin ki yin giye? Barjo maato ki qaabaaw? Eedisa seesoam garana damea Barjo bishkalanka ab hayne?” hamayse ke qaabade. ");
INSERT INTO amf_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Saanawaar Yesus woylaminka kenin qaabonam manpasinka yisa dhesayse kena yin ki giyade: “Yesa woylaminka yin harrnee qaabe? ");
INSERT INTO amf_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Hajimonka malgimaa eana, ‘Hasa seesonam hana gardhidine’ hamara, ‘Dhaabhayse haam baadhon haaqanam hanti bavate yivaa’ hamayse giyara hamaane likkaa? ");
INSERT INTO amf_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ko dahaannaar i Eedi Naasina peendar eedina seesonam garana hayamo isa konin dohonam yenin dhesoadettsi yeam ko zaske” hamayse hajimonka malgimaa eaka ");
INSERT INTO amf_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Inta hana ida giye: Dhaabhayse haam baadhon haaqanam hanka bavate hasa oonindar yivaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hajimonka malgimaa ea dhaabhayse saanawa kiam baadhon haaqanam bavate een wulsa birandar ki utade. Ogonante eeno wul targadhayse, “Ko yer yin hamonam ena kala hattear haapootone” hamaate Barjoam ko gobshade. ");
INSERT INTO amf_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesus pir bazin apondar ki yivade. Ogotear eeno wul kalan ko nivaysaka koam dhettsan ki yedade. ");
INSERT INTO amf_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Raqin ogora dhaabhate kinin yivenka, Ilpoos naasa Lewi gibirin kinin kacchen raqinte dooqayse ki daaka kiam haapayse, “Isa paanan nivaa” kina ki hamade. Kidiar dhaabhayse kisa paananka ki yivade. ");
INSERT INTO amf_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ogosa budonte Yesus Lewi ooninte kummandar dooqayse ki daaka thoothino eeno kisa paanan nivite konin dohonna, eensaar waani gibirin kacchayna eenabee Musesa yigginam toolimina eenabe Yesusbee kisa paanan yivayna eenabekal kummandar ke dooqade. ");
INSERT INTO amf_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Musesa yigginam dhettsayna Parisa eena gibirin kacchayna eenabee Musesa yigginam toolimina eenabesana kinka kinin kummenka Yesusam haapayse, kisa paanan yivayna eenana “Eena cubbona gibirin kacchaynabee igina seeson eenabesana kinka kinin kummenbee wucenbe harrnane?” hamayse keam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesus yin kenin giyenam qansayse, “Hajadhaanaam akkimi koda zaske; payyanaam akkimi zaskehe. Inta seeson eena Barjodar kenin maatoadettsi keam eelota i nivade; tipana eenaam eelota nivaatine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Shivea Wannissa paanan yivayna eenabee Parisa eenabe itsima keda qoome. Eeno Yesuskal nivayse, “Wannisbee Parisa eenabesa paanan yivayna eena itsima kenin qoomenka, hasa paanan yivayna eena itsima kenin qoomimino harrnane?” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesusaar kena yin ki giyade: “Uutaa kembesana kinka ki daaka, gaydonna nivaana eenaam itsima qooma keam zaska ko zasko? Uutaa kembete ki daaka itsima keam qooma zaskehe. ");
INSERT INTO amf_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ko dahaannaar uutaanin kekalanka edadhayno woda niva ko nive; ogo wodanka ko hanna itsima keda qoome. ");
INSERT INTO amf_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Apala gecchoadar apala haaleam lashea eedi qolehe. Yin ki haydianna, apala haalea apala gecchoam yinka hattsate kinin tiyenna, apala gecchoasa haviminoar kalon koda worke. ");
INSERT INTO amf_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jambin gecchonsa iinte zia haali shabhea eedi qolehe. Shabhadhidianna ziano hallo jambinam bhattsa ko bhattse; zianoar layma ko layme; jambinoar bhaqayse gemma ko gemme. Ogona zian haalin shabhota jambi haali koda zaske” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ayiwd eensa ukunsen rooroaka Yesus gazgon ushon haaminsa shaarinka kinin yivenka, kisa paanan yivayna eena yivada gazgon tishanam shaaban ke yedade. ");
INSERT INTO amf_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parisa eenaar “Shedaa! Ukunsen rooroaka zaskimon waadimanam hasa paanan yivayna harrna ke waadadhe?” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Kidiar “Ena Bitaa Dawt kimbete dahaana eenabesana daaqardhayse kenin gaalen wodanka kinin hayonam kala hattear yedi nabbabeete? ");
INSERT INTO amf_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiyatar gudullasa gebhaa kinin dohon wodanka, Dawt Barjosa gazan ooninsa mayante ardayse gudullakalanka een abinin itsimon Barjosa birante wodadhon balashanam yina itsayse kimbete dohon eenna kinin imonam yedi nabbabeete?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Tapir, “Ukunsen rooroa eedina ki wodadhade, eedi ukunsen rooroana wodadhadehe. ");
INSERT INTO amf_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ogona inta Eedi Naas ukunsen rooroasaar Imbane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesus taar Ayiwd eensa bukin raqinte ki ardade; raqin ogotear aaninsa woboa eedi kala ki dahade. ");
INSERT INTO amf_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Yesusam bersana zagayse “Ukunsen rooroaka eam paccho ki dew?” hamayse kiam shedite ke dahade. ");
INSERT INTO amf_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesus aaninsa woboa eana “Dhaabhayse eensa shaarinte woyaa” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ogora kena “Musesa yiggino ukunsen rooroaka wo waadadhe konin giyoono payya yermoo? Siya yeru? Eediam wonin dhacchoadettsimoo? Deesoadettsine?” hamayse keam ki oysade. Kediar lay ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kesa woylaminin duudonam haapayse kedar yinin dhagadhonka yisa gasambar dohon een wulam aapi siyaka shedayse eana “Antaam hasa pishkaa” ki hamade. Ear yisa antaam ki pishkaysaka, anta ki paashade. ");
INSERT INTO amf_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Parisa eenaar utayse, “Hamin hayayse wo kiam deeso?” hamayse saanawa Bitaa Herodissa bitamonam nashayna eenabete ke dhalqade. ");
INSERT INTO amf_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesusaar yisa paanan yivaynabete kinka agaa raqaara dhaabhayse Galila bazindar ki yivade; Galila peera thoothino eenoar kisa paanan ko yivade. ");
INSERT INTO amf_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Gebhi yer kinin waadadhon wulam qansayse thoothino eeno Yiwdabee, Yerusaalembee, Edomiyasbee, Yordaanoos baynsa saabarbera ko nivade; pir Thiroos katamarabee, Sidoona katamarabee, kesa gasan peerabe thoothino eeno kikal ko nivade. ");
INSERT INTO amf_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Eeno kattsi konin thoothonna kiam konin kupoamadettsi kisa paanan yivaynana “Bazindara sagadhen gonngalanam ikal thettsayse woysee” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Thoothin eenaam burqora kinin pacchonna, hajadhoono eeno wul kiam kaamota kidar koda tuure. ");
INSERT INTO amf_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Beerona kiam kenin haapenka, kisa birante dhambayse, “Ya Barjo Naasine” hante ke ilatade. ");
INSERT INTO amf_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kidiar hay kinin dohonam kenin giyoamadettsi upsi wocchika keam ki marade. ");
INSERT INTO amf_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesus dhukandar utayse yinin zagaana eenaam yidar ki eelade; kediar kalan ke nivade. ");
INSERT INTO amf_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Kimbesana kinka kenin doadettsibee Barjosa upsinam eenna kenin giyoadettsi keam yittsotabe tabhi lamaana eenaam kamayse beeronam eendara kenin bulea hayamo kena ki imade. Pir “Tarjamonnante Yittsadhaana” hamayse kena naabe ki wodade. ");
INSERT INTO amf_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kinin kamaana tabhi lamaana eena kinane: Simoon naabenam Bhethiroos hamayse ki wodade; ");
INSERT INTO amf_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zabdoos naana lamaana Yayqoobbee Wannisbena “Bovanerges” hamayse ki wodade (Bovanerges hambhoono guganatin naana hamintane.); ");
INSERT INTO amf_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Indiriasbee, Pilbhoosbee, Bartelemoosbee, Maatoosbee, Toomaasebee, Ilpoos naasa Yayqoobbee, Taadoosbee, peen yinnonna bish qaabea Simoonbee, ");
INSERT INTO amf_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yesusam dembhinna saskate imea Asqoronto peen ea Yiwdabene. ");
INSERT INTO amf_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Oonintear kinin ardenka, kisa paanan yivaynabete galan itsan kenin bashadhenka yekka pir thoothino eeno kikal ko bukade. ");
INSERT INTO amf_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kisa zelen eenaar ogoam qansayse kanka “Bardhidine” hamayse kiam entsanna ke nivade. ");
INSERT INTO amf_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yerusaalemra nivaana Musesa yigginam dhettsayna eena “Bevelzebul kidar dahade” pir, “Beeronaam kinin bulayno beeronasa hayoa kantankane” hamayse giyte ke dahade. ");
INSERT INTO amf_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesus eenaam yikal eelayse kamsika kena yin ki giyade: “Seethaan Seethaanam hamin ki bulana dame? ");
INSERT INTO amf_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Bit kalaa eena kikala edimayse kinka bit kalaa eed maatayse daana damehe. ");
INSERT INTO amf_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Oonin kallon eena kinka gemmayse kikala edimidi ke hanna, keeda kinka payyamoka daana damehe. ");
INSERT INTO amf_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Seethaanaar kinka kiam jibbayse edimidi ki hanna, dhamba ki dhambe; woyana damehe. ");
INSERT INTO amf_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ogodettsi birayse kantanka dahaa eam yedate dhaxima ooninte kisa ardayse koymonam buurana eedi hayyear damehe. Ogona kantanka dahaa eam yedate yinin dhaxonsa budonte, kida kisa ooninam buure. ");
INSERT INTO amf_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Inta yena gon ida giye: Eensa seesonbee iirimen wulbeam kena gardha ko gardhe. ");
INSERT INTO amf_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ko dahaannaar Manpas Gazanam iirea ea rooro wul lay seesonsa baza kidar daane; hamin ko dahaannaar kisa seesonam kina gardhehe” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesus yin kinin giyoono “Beero kidar daane” kenin hamonnane. ");
INSERT INTO amf_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yesussa indanbee kisa indanaanabe kikal ke nivade; kediar mayante woyayse eedi kidar yittsayse kiam ke elsade. ");
INSERT INTO amf_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yesuskal dooqoono thoothino eeno kina “Shedaa! Handabee handanaanabe mayante woyayse haam keda zage” ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesusaar maasayse “Inda kodi hayne? Indanaana kedi haybene?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kalan dooqon eenaam shedayse, “Marrato! Indabee indanaanabe kinane. ");
INSERT INTO amf_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Barjosa bhocchinam ee hamayse waadadhayna wul isa indabee indanaanabe kedi iginane” hamayse kena ki maasade. ");
INSERT INTO amf_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesus pir bazinsa aponte eenaam dhettsan ki yedade. Kattsi thoothino eeno kikal nivayse konin bukonna, bazindara sagadhen gonngalansa iinte ardayse ki dooqade. Eeno wul bazinsa gasante ko dahade. ");
INSERT INTO amf_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kamsikaar thoothi yer keam dhettsite ki dahade. Keam yinin dhettsenkaar kena yin ki giyade: ");
INSERT INTO amf_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","4","“Marrato! Eedi kalaa haaminte yisa bheeta yiithota ki utade. Bheetan kinin yiithenka, bheetano waani goyn aponte ko wavaysaka aptina nivayse ke itsade. ");
INSERT INTO amf_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Waani bheetanoar thoothi peenin qolmon haachandar ko wavade. Pee thoothinin qolmonna saanawa ko baqalade. ");
INSERT INTO amf_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Haynin utayse oydhenkaar, ko halatade; caaciyn yittsaamonna ko wocchade. ");
INSERT INTO amf_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Waani bheetanoar ukumbhansa shaarinte ko wavade. Ukumbhanoar gebhayse baqalon bheetanam konin ishkonna, aapi ushima ko shidhade. ");
INSERT INTO amf_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Waani bheetano peen payyandar ko wavade. Gebhaysear aapi ko ushade; waa kisa aapi eedi kalaa kaysa apo tabhi, waa kisa pir aapi eedi makkam kaysa, waa kisa pir aapi eedi dong kaysa ke ushade. ");
INSERT INTO amf_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","“Keeda qansen qaamiysa dahaa ki qanse” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesus yimal ki daaka, kalan theedaana eenabee kisa paanan yivayna tabhi lamaana eenabe kinka dahayse kena kinin giyon kamsin goynsa kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesusaar, “Yena Barjo bitamonsa aachin dhalqinam yenin dhesoadettsi imbhidine; waani eenna ko hanna, ");
INSERT INTO amf_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Sheda ke shede, kenin shedonam kenin haapoamadettsi, qansa ke qanse, kenin qansonam kenin bhocchoamadettsi, Barjodar kenin maatoamadettsi, kesa seesonoar kena ko shidhe konin hambhoamadettsi’ yer wulam kena kamsika koda giidhe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesusaar kena yin ki giyade: “Kamsin ogoam dhesattenu? Ta yin ko hanna, yedi keeda kamsin wulam hamin hayaysee dheso? ");
INSERT INTO amf_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bheetan yiithea agaa Barjosa upsinam kida yiithe. ");
INSERT INTO amf_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Upsinoar yiithadhoono goyn aponte wovoono konone: Barjosa upsinam kenin qansen wodanka Seethaan saana nivayse kesa woylaminte yiithadhon Barjosa upsinam kekalanka kida tiye. ");
INSERT INTO amf_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tapir peen haachandar yiithadhaana bheetana Barjosa upsinam qansayse saanawa wozanka tiyayna eenane. ");
INSERT INTO amf_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Eena igina caaci kenin yittsaamonna, kesa woyano likka wodanane; Barjosa upsinna gaale way oytaydha kedar konin yeskenka saanawa keda gare. ");
INSERT INTO amf_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ukumbhansa shaarinte yiithadhaana bheetana igina Barjosa upsinam qansayna eenane. ");
INSERT INTO amf_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Peen kosa bhocchinbee, wodimmakkon anngarmanbee, thoothi yersa anngarmanbeka Barjosa upsino kenin qansoono kesa woylaminte sun ishkimayse aapi ushima koda shidhe. ");
INSERT INTO amf_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Peen payyandar wavaana bheetana Barjosa upsinam qansayse bhocchika tiyayna eena, antina eedi kalaa kaysa apo tabhi, waaniar eedi makkam kaysa, waaniar eedi dong kaysa aapi ushayna eenane” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesus kena yin ki giyade: “Shaakanam shashkayse yer daran guupa ko guupadho? Way algan demente ko wodadho? Dheg hamon raqindartayu konin wodadhayno? ");
INSERT INTO amf_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ogona aachimayse may maatima, aachadhaysakaar dhesimima shidhehe. ");
INSERT INTO amf_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ta keeda qansen qaamiysa dahaa ki qanse” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Pir Yesus kena yin ki giyade: “Yenin qansen yerinam payya hayayse edee. Yenin kahaa shaaqaka yenaar kaadha ko kaadhe; ogoraar sagi yena kaadha ko kaadhe. ");
INSERT INTO amf_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yisa dahaana kisa dohondar kina imbha ko imbhe; yisa qolmakalanka kisa dohonam kikala tiidha ko tiidhe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesus yin ki giyade: “Barjosa bitamono eedi bheeta yiitheadettsine. ");
INSERT INTO amf_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ea sootinka raata ki raate; rooronka dhaabha ki dhaabhe; hamin konin dohonam ki dhesima bheetano koda baqale; gebhanaar koda gebhe. ");
INSERT INTO amf_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Peeno yinti birayse baqalin koda baqalse; baqalloar gebhayse pudha ko pudhe; yinin pudhonsa budonte aapi koda wode. ");
INSERT INTO amf_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Aapinin ushonsa budobar patadhen wodanin yeskonna, ea saanawa halpan tiyate patan kida yede” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesus yin ki giyade: “Barjosa bitamonam yer harka wo yeekinso? Way yer harka wo koam kamso? ");
INSERT INTO amf_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Saliithasa aapidettsine; kodiar peendar koam yiithadhen wodanka peendar dahaana bheetana wuldara likkane. ");
INSERT INTO amf_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Peendar konin yiithadhon wodanka baqalayse konin gebhenka, peendar dahaana haaqana wuldara gebhate koda bashe; aptinaar nivayse kosa shiponsa iinte antindar ooni kenin woysoadettsi kattsi antino koda gebhe” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesusaar zarsinin bhocchana dameaka yekka kinadettsina thoothina kamsinaka Barjosa upsinam kena kida giye. ");
INSERT INTO amf_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kamsi qolma kena giyehe; ko dahaannaar kimbesana yimal kenin dehenka, kamsinasa bulin goyn wulam yisa paanan yivayna eenana kida giye. ");
INSERT INTO amf_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Rooroa agaaka peen sootima shaakinan Yesus yisa paanan yivaynana “Bazinsa saabar wo sage” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kisa paanan yivayna eenaar thoothin zarsin garayse Yesusin gidir dohon bazindara sagadhen gonngalandar dooqayse yinka kiam tiyate ke yivade; waaniar gonngalana bazindar kimbesana kinka ke dahade. ");
INSERT INTO amf_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Gembho wurano dhaabhayse noqono gonngalanka konin thoothenka yekka wurano bazindar dohon gonngalanam koda juge. ");
INSERT INTO amf_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ogo wodanka Yesus bazindara sagadhen gonngalansa budonte qoocante yisa yer wodayse raatayse ki dahade. Kisa paanan yivayna kiam dhaasayse, “Woam Dhettsea, wonin kayenka ya lay ha hamo?” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kidiar dhaabhayse wuranam ki bitade; bazinkaar “Lay! Shoan garaa!” ki hamade. Wuranoar jibarshan ko garade; bazinoar kalon lay ko hamade. ");
INSERT INTO amf_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesusaar “Yin yenin kurtumbhayno hare? Kinaka yekka idar woylam yenin qajea yesa qolaaw?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kediar kattsi kurtumbhayse, “Wuranbee bazinbe yininna ee hamea kaa kidi hayne?” kinka kikal ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kediar bazinsa saabar Gerasenon peendar ke nivade. ");
INSERT INTO amf_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesus bazindara sagadhen gonngalara kinin utenka, eedi beeroyn yedaa duukin raqira utayse daran ki keerade. ");
INSERT INTO amf_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ea agaasa dayntano duukin raqintene; eedi hayyear yedate kiam sansalaka dhaxana damehe. ");
INSERT INTO amf_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Thoothi rooro roonte dhaxadhen sansalanbee zawnbeka kiam koda dhaxadhe. Ko dahaannaar sansalanbee roon zawnbeam qunthate kida dhabe; ogonante kiam yedana damea eedi qolehe. ");
INSERT INTO amf_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Rooro wul sootinbee rooronbe duukin raqintebee dhukanbedar dahayse kida ilate, yisa bishinamaar seeninka kida taxe. ");
INSERT INTO amf_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kidiar Yesusam pegeka haapayse, gobaka kalan hatte kumpurdhayse kina ki goodimade. ");
INSERT INTO amf_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Upsin yisa dheg hayayse ilataate “Wuldara sagea Barjosa Naasa Yesuso, hambesana isa dohoono hare? Iam hanin galshoamadettsi Barjosa naabenka inta haam maridine” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Yin kinin giyoono Yesus “Ya beeroa, ea kaara utaa!” kanka hamite kinin dohonnane. ");
INSERT INTO amf_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesusaar “Hasa nammo hayne?” hamayse kiam ki oysade. Kidiar “Thoothi wonin dohonna isa nammo Legoonne” hamayse kina ki giyade. ");
INSERT INTO amf_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Keam ko peera oytate kinin yittsoamadettsi kiam kattsi ki miskade. ");
INSERT INTO amf_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Raqin ogote laasadar thoothi wurkupa gishadhayna kenin dohonna, ");
INSERT INTO amf_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","beerona “Wurkupana iginadar wonin ardoadettsi woam yittsaa” hamayse kiam ke miskade. ");
INSERT INTO amf_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesusaar “Yedi yivee” kena ki hamade; beeronaar eadara utayse wurkupanadar yivayse ke ardade. Shii lamaaddhana wurkupanaar bazinsa aponte dahayse laasandara diirimayse bazinte ke itsadhade. ");
INSERT INTO amf_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wurkupanaam gishayna eenaar gobate yivayse ogo yinin haaponam katamanbee gurdan eenbena kenin giyenka, eenoar har konin dohon shedota ko utade. ");
INSERT INTO amf_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yesuskal kenin nivenka, Legoon hambhea beeronin yedaa easa gemmon mesken paashaysaka apala qaadhayse dooqayse ki daaka kiam haapayse ke kurtumbhade. ");
INSERT INTO amf_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ogoam haapaana eenaar beeronin yedaa ea goynbee wurkupanadar yeskonbeam eenna ke giyade. ");
INSERT INTO amf_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Eenoar Yesuska “Wosa peera utaa” hamayse kiam miskan ko yedade. ");
INSERT INTO amf_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesus bazindara sagadhen gonngalante kinin ardenka, beeronin yedaa ea “Hambesana doota i yive” hamayse kiam ki miskade. ");
INSERT INTO amf_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ko dahaannaar Yesus kina ee hamadehe. “Oonin hannondar yivayse Barjo hamin dohon gebhi yer hana kinin waadadhonbee hamin hayayse haam kinin pacchonbeam hasa oonin eenana giyaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ear yivayse Yesus hamin dohon gebhi yer kina kinin waadadhonam Tabhi Katamana hambhen peente giyan ki yedade; kinin giyenka qansoono eeno wul targadhidine. ");
INSERT INTO amf_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesusaar lansi bazindara sagadhen gonngalante dooqayse bazinsa saabar kinin sagonsa budonte, thoothi eedi kikal nivayse ko bukade; kidiar bazinsa aponte ki dahade. ");
INSERT INTO amf_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ayiwd eensa bukin raqinam wottsayna eenasa eedi kalaa Yayroos hambhea Yesuskal ki nivade. Yesusam kinin haapenkaar kisa roon demente dhambayse, ");
INSERT INTO amf_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Naano isa likkono hajadhayse diyaba koda haye. Bannzo! Paashayse sadaka konin doadettsi nivayse hasa aaninam kosa bishindar wodaa” hamayse kattsi kiam ki miskade. ");
INSERT INTO amf_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesusaar eabete kinka ki yivade; thoothino eenoar Yesussa paanan kupimaate koda yive. ");
INSERT INTO amf_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Layme hajimoka leve tabhi lamaa hajadhayse kappoono maa kallo ko dahade. ");
INSERT INTO amf_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kodiar thoothin dheeshan imayna eenasa aaninte gaalite ko dahade; dheeshanna yisa dohon koymon wulam imate konin macchonsa budonte, burqono waandar kosa gebhaate ko yivade, kodi paashadehe. ");
INSERT INTO amf_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Kodiar Yesussa eenin giyen qansayse, “Apalan kisa hattear kaamidi i hanna, inta paashayda paashe” hamayse thoothin eensa shaarinka kisa budobar nivayse apalanam ko kaamade. ");
INSERT INTO amf_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Laymayno zombhino kosa saanawa ko woyade; yisa burqora konin paashoono waante kona dhesimidine. ");
INSERT INTO amf_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesusaar pacchen kantan yikala utonam saanawa dhesayse eensa shaarinte wal hamayse, “Isa apalanam kaamaa hayne?” hamayse ki oysade. ");
INSERT INTO amf_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kisa paanan yivayna eenaar “Thoothino eeno kupimite konin yivenam ya haapayse, ‘Iam kaamaa hayne?’ hamaysea oyso?” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ogoam hayaa hay kinin dohon dhesota budoka wal ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Edonoar yinin paashonam konin dhesenna kurtumbheka gibazaate hatte, Yesussa demente dhambayse, yidar yeskon wulsa goninam kina ko giyade. ");
INSERT INTO amf_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kidiar “Isa naano, idar woylamin hanin qajoono haam ko pacchade. Nagaya yivaa; hasa gaaleraar ukunsaa” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kidiar ogoam giyte ki daaka, Ayiwd eensa bukin raqinam wottsea Yayroos oonira eedi nivayse, “Hasa naano diydine; ta keeda Dhettseam harrnaa galshe?” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesusaar eenin kina giyonam qansayse bukin raqinam wottseana, “Kurtumbhaabhode! Idar bish woylam qajaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Bhethiroosbee, Yayqoobbee, Yayqoobsa kana Wannisbedara ab eedi hayyear kisa paananka easa oonindar ke yive zagadehe. ");
INSERT INTO amf_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bukin raqinam wottsea easa ooninte kenin nivenka, Yesus eeno ilatayse konin waajenbee eepenbeam ki haapade. ");
INSERT INTO amf_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Oonintear ardayse, “Harrnee ilatayse eepe? Naano raata ko raatade, diyadehe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Eenoar kiam ko hancade. Yesusaar een wulam mayanka bulayse naansa imbaabee, indanbee, kimbesana kinka dahaana eenabeam yikal entsayse naanin raqin dohonte ki ardade. ");
INSERT INTO amf_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Naansa aanin yedayse, “Thaalitaa quumi!” kona ki hamade; ogosa bulino “Naano, ya dhaabhaa! hanka ida hame” hamintane. ");
INSERT INTO amf_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Naanoar saanawa dhaabhate woyayse osbee orabe yaayan ko yedade. Kodiar tabhi lamaa leve naasine. Eenoar gebhi ko targadhade. ");
INSERT INTO amf_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesus yinin waadadhonam eedi hayyear dhesoamadettsi upsi wocchika kena giyayse, “Gala kona imee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesus raqin ogora dhaabhayse yinin gebhon peendar ki yivade; kisa paanan yivayna eenaar kimbesana kinka ke yivade. ");
INSERT INTO amf_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ukunsen rooroaka Ayiwd eensa bukin raqinte eenam dhettsan ki yedade. Thoothino eenoar kisa dhalqinam qansayse gebhi ko targadhade. “Ea kaa yerin ko wulam hamora ki haapaa? Kina imbhoono pakalmakkono yer hare? Ogo yin tarshen yerinam kinin hayayno hamin dahaa goytikane? ");
INSERT INTO amf_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kaa haaqan qarsea Mayriyamsa naasatayu? Yayqoobbee, Yoosabee, Yiwdabee, Simoonbesa indanaasatayu? Kisa indanaana anzana wombesana kinka kote dahaanatayu?” hamayse kisa dhalqinam bagayse eeno tiyma ko garade. ");
INSERT INTO amf_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesusaar “Barjokala qansayse eenna giyea kinin gobshadhimino peen een yinnonbee, muldhana yinnabee, oonin eena yinnabekal bishne” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Raqin ogote hajadhaana eena tokaana eenadar kidi aanin wodayse keam yinin pacchondara tarshea yer ab waadadhana damadehe. ");
INSERT INTO amf_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kinin giyenam gonne hamayse kenin tiyaamonna kidi targadhidine. Ogosa budonte, Yesus kesa gurdan gurdante yaayte Barjosa upsin eenna kida dhettse. ");
INSERT INTO amf_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesus tabhi lamaana yisa paanan yivayna eenaam yikal eelayse, lama lamaa hayayse eendar keam yinin yittsenka, beeronaam eendara kenin bulea hayamo kena imayse, ");
INSERT INTO amf_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","“Yenin yivenka yenka haljo bish tiymate. Yer ab, gala ko hannaar, surba ko hannaar, korbhoka koymo yenka beveebhode. ");
INSERT INTO amf_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Roonte yesa dunngurin arsee; shuraab lanso qaadheebhode. ");
INSERT INTO amf_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Raqin hamotear eenkal yenin ardenka, birayse yeam chocchamon tiyaa ea ooninte arda ye hanna, raqin ogora yenin utenka yekka ogote dooqee. ");
INSERT INTO amf_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Eenin yeam chocchamon tiymonbee yekal konin qansimonbe raqin ye hanna, ogora yenin utenka kedar tarja konin maatoadettsi yesa roondar dohon silalinam dinsee” hamayse kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kediar ogo raqira utayse eeno seeson waadimanam garayse Barjodar konin maatoadettsi eenna ke giyade. ");
INSERT INTO amf_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Thoothi beeronin yedaana eenadara beeronam ke bulade; thoothi hajadhaana eenaamaar waqatika qadhada keam ke pacchade. ");
INSERT INTO amf_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesussa naabeno raq wulir konin qansimonna, Bitaa Herodisaar qansidine. Waani waani eeno “Shivea Wannis diira dhaabhidine; ko wul tarshen waadiman wulam waadadhana kantan kinin haapoono ogokane” ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Waani eenoar “Eeliasne” ko hamade; waani eenoar “Ena Barjokala qansayse eenna giyayna eenasa iira eedi kalaadettsine” ko hamade. ");
INSERT INTO amf_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Bitaa Herodisaar ogoam qansayse, “Agaa qorcin ininsa taskaa Wannisne; kidi diira dhaabhidine” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Herodis iishima Pilbhoos geshon Herodiyadaam kinin keemonna, Wannis “Hambanaasa geshonam keema haam zaskehe” hamayse birayse kina giyte ki dahade. Ogona Herodis Herodiyada goynka kiam yettsate dhaxin ooninte ki dhaskade. ");
INSERT INTO amf_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ogona Herodiyada Wannisdar guula wodayse kiam dettsana konin zagenka kona agadehe. ");
INSERT INTO amf_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodis Wannis tipabee gazabe eedi kinin dohonam kinin dhesonna, kina kurtumbhintaka kiam deesadhoamadettsi kida gishe. Kisa dhalqinamaar qansite thoothi qaabite kida gaale. Ko dahaannaar kisa dhalqinam wozaka kida qanse. ");
INSERT INTO amf_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Bitaa Herodisin adhadhaa rooroayn gobshadhea sedhaaka, peen wottsayna eenabee, shii alaqanabee, Galila peente dahaana dhesimaana eenabena kumma ki ashkade; ogono wodano Herodiyadana agoonone. ");
INSERT INTO amf_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodiyadasa naano kummandar dooqaana eenakal ardayse kesa birante yiigaate konin kirbenka, Bitaa Herodisbee kimbesana kinka dooqaana eenabeam ko wozisade. Bitaa Herodisaar naanna, “Iam hanin oyson yerinam hana imayda ime” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","“Bitamon innonsa antin ko hannaar, ikal hanin misken wulam hana imayda ime” hamayse kona malla ki ardade. ");
INSERT INTO amf_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Naanoar mayan utayse indankal “Hariy kalan misko?” ko hamade. Indanoar “‘Shivea Wannissa metenam taxate ina imaa’ hamayse miskaa” ko hamade. ");
INSERT INTO amf_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Naanoar saanawa bitaakal ardayse, “Shivea Wannissa metenam taxate sharqaka taaki saana ina hanin imoadettsi ida zage” hamayse ko kiam oysade. ");
INSERT INTO amf_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Bitaar qaabenka kattsi yi ataakaar, kimbesana kinka kummandar dooqaana eenasa birante malla kona kinin ardonna, konin miskonam koam marota nashadehe. ");
INSERT INTO amf_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Saanawa Bitaa Herodis poolisanasa kalaam Wannissa metenam taxate kinin bovoadettsi ki yittsade. Poolisaar dhaxin oonin yivayse Wannissa metenam ki taxade. ");
INSERT INTO amf_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kisa metea kinin taxaam sharqaka bavate hatte, naanna ki imade; naanoar indanna ko imade. ");
INSERT INTO amf_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wannissa paanan yivayna eenaar kisa dembhinam kenin qanson wodanka, nivayse kisa leesinam tiyate ke duukade. ");
INSERT INTO amf_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesus yisa tarjamonnante kinin yittsaana eenaar Yesuskal nivate bukayse, kenin waadadhonbee eenaam kenin dhettsonbe wulam kina ke giyade. ");
INSERT INTO amf_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kidiar “Yedi yemal eediyn qolmon raqinte nivayse likka ukunsee” kena ki hamade. Yin kinin giyoono kekal nivayse maatayno eeno thoothi konin dohonna gala kummana wodayn kesa qolmonnane. ");
INSERT INTO amf_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bazindara sagadhen gonngalante ardayse raq eedinin qolma kalaate yimal bish ke yivade. ");
INSERT INTO amf_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kenin yivenka thoothino eeno keam haapayse konin dhesonna, kataman wulra dhaabhayse gobada saanawa keam birayse kekal ko bukade. ");
INSERT INTO amf_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesusaar bazindara sagadhen gonngalara utayse thoothin eenam haapayse, gishea eediysa qolmina yaanadettsi konin dohonna, kona ki burqadhade; thoothi yerar koam dhettsan ki yedade. ");
INSERT INTO amf_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ogo wodanka peenin ibanonsa budonte, kisa paanan yivayna eena kikal nivayse, “Kono ranqo eedinin gidir qolminone; ta peenoar ibanidine. ");
INSERT INTO amf_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ogonante igina wosa gasante dahaana gurdanadar yivayse gala kenin shanoadettsi keam yittsaa” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kidi kena maasayse “Yedi kenin itsen galan kena imee” ki hamade. Kediar “Yivayse birre mato lamaaka gala shanayse kenin itsoadettsi kena wo imo?” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kidiar “Balasha meemayne yekal dahaana? Yivayse shedee” kena ki hamade. Kediar shedayse maatate hatte, “Balasha dongbee kaara lamaabene dahaana” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesusaar yisa paanan yivaynana “Een wulam shudhin caagindar kashate kashate dottsee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Eeno eedi dong kaysabee eedi lamaa kaysa apo tabhibe maatayse ko dooqade. ");
INSERT INTO amf_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesusaar balashana dongnabee kaarana lamaanabeam tiyayse, tura cecin shedayse Barjoam miskeka ki gobshade. Balashanamaar qunthayse yisa paanan yivayna eenana eenna kenin yeskisoadettsi ki imade; taar kaarana lamaanaam een wulna ki kashade. ");
INSERT INTO amf_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Eeno wulaar itsayse ko mishade. ");
INSERT INTO amf_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kisa paanan yivayna balashanbee kaaranbesa itsadhaka shidhon dirmanam kenin dhaasoono sharqa tabhi lamaane. ");
INSERT INTO amf_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ogo balashanam itsaana eena anngina bish paydadhana shii dongne. ");
INSERT INTO amf_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ogora saanawa Yesus yisa paanan yivayna eenana “Inta eenam onnadar inin yittsenka, yedi bazindara sagadhen gonngalanka bazira sus Beetesayda katamandar iam birayse sagee” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Eenam yinin yittsonsa budobar Barjo misko dhukandar ki utade. ");
INSERT INTO amf_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Peenin sootenka, bazindara sagadhayno gonngalano bazinsa gidinte ko dahade. Yesus kembesana gonngalante ardadehe; yimal peente ki dahade. ");
INSERT INTO amf_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kisa paanan yivayna eenaar bazindara sagadhen gonngalanka kenin yivenka, jibarro kesa birante dahayse keam yittsan konin maronna, kenin gaalenam ki haapade. Sootin peenin sedhamba hamenka, Yesus bazindar rooka tigate kekal nivite ki dahade; kesaar demeka yivota ki zagade. ");
INSERT INTO amf_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ko dahaannaar bazindar rooka tigate kekal kinin nivenka kiam haapayse meeshi wo haapade hamayse ke ilatade. ");
INSERT INTO amf_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kedi wul kiam kenin haapenka kattsi targadhayse ke gibazade. Kidiar saanawa “Hay! Intane; kurtumbheebhode” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kidiar bazindara sagadhen gonngalante kekal ki ardade. Ogo wodanka wurano jibarshan ko garade; kediar gebhi ke targadhade. ");
INSERT INTO amf_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ogonoar woylamin kesa duudonna, Yesus balashan keam kinin kunsenka tarshen waadimanam kinin waadadhonam kedi bhocchadehe. ");
INSERT INTO amf_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yesusbee kisa paanan yivayna eenabe bazinam sagayse Gensareth peendar ke yivade; bazindara sagadhen gonngalanamaar bazinsa gasante ke dhaxade. ");
INSERT INTO amf_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bazindara sagadhen gonngalara kenin utenka, eeno saanawa Yesus kinin dohonam ko dhesade. ");
INSERT INTO amf_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Eenoar peen ogo wuldar gobaka yivayse Yesusin dohon raqindar hajadhaana eenaam haaqaka bavate kikal nivan ko yedade. ");
INSERT INTO amf_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kinin yiven raqin wul gidir gurdante ko hannaar, katamante ko hannaar, hajadhaana eenaam bukin raqindar bavate nivayse koda wode. Kediar Yesusna “Hasa apalansa nukin hattear wo kaame” hamayse kiam keda miske. Kisa apalansa nukinam kaamaana eena wul hajimora paashite ke dahade. ");
INSERT INTO amf_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Yerusaalem katamara Parisa eenabee Musesa yigginam dhettsayna eenasa waanibe Yesuskal nivayse ke bukade. ");
INSERT INTO amf_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kisa paanan yivayna eenasa waani waani eena aaninsa dakanka galan kenin itsenka ke haapade. “Aaninsa dakanka” hambhoono goyno kosa aanin shiidhima kenin itsennane ko hambhade. ");
INSERT INTO amf_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parisa eenabee Ayiwd eenabe wul ena eykena dambinam toolana yisa aaninam payya shiidhima gala itsehe. ");
INSERT INTO amf_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kedi gabara yi maatanna shiidhima gala itsehe; pir yinin wucen sharqanbee, daanbee, galan yinin itsen sharqanbeam, yinin wodhen algan raqinamaar kenin shivendettsi, abaar dambi hayayse toolana kenin buloono yer thoothine dohoono. ");
INSERT INTO amf_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Parisa eenabee Musesa yigginam dhettsayna eenabe “Hasa paanan yivayna eena eykena dambinam kenin toolimino harrnane? Yisa aaninam shiidhima galan keda itse” hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Kidi kena yin ki giyade: “Ena Barjokala qansayse eenna giyea Isias Barjoyn giyonam, ‘Kina eena yisa aponka bish iam keda gobshe, woylammo kesa ikalanka kattsi pegadhidine. ");
INSERT INTO amf_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Eenin bulon dambinam Barjoyn imaa yiggidettsi hayayse eenaam dhettsaate sun guuri ina keda goodime’ hamayse ye kina maltina eena goynam gon ki giyade. ");
INSERT INTO amf_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yedi Barjoyn giyonam garayse eenin bulon dambinam yeda toole” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Tapir kena yin ki giyade: “Yennon dambinam toolota Barjoyn giyonam bagayse ye garade. ");
INSERT INTO amf_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Muse yi giyna: ‘Hambabee handabeam gobshaa’ pir, ‘Imbaabee indanbeam iirea ki deesadhe’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Yedi eedi imbabee indabena yinin kelshen yer wulam kena ‘Yeam inin kelshen yerin wulam inta Barjona iminto hayayse ida ime’ ki hamanna, ");
INSERT INTO amf_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","os birante imbaabee indanbeam yer harka ko hannaar kinin kelshoamadettsi yeda mare. ");
INSERT INTO amf_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ogonante yedi yesa dambinam toolota Barjoyn giyonam yeda gare; ogodettsiar thoothi yer yeda waadadhe” hamayse kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Pir Yesus eenaam yikal eelayse, “Yedi wul inin giyenam qansee, ogoam payya hayayse bhocchee. ");
INSERT INTO amf_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Eediam minngisayno eessa iira utaynone; mayara iinte arden yerinsa kala hattear eediam minngisea qolehe. ");
INSERT INTO amf_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Qansen qaamiysa dahaa ki qanse” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Eenkalaar edimayse ooninte kinin ardonsa budonte, kisa paanan yivayna eena kamsinsa goynam kalan ke oysade. ");
INSERT INTO amf_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kidiar, “Yedi taar ogo een waanidettsi qaabeysa qolminaw? Mayara eedisa iir ardayno eediam hamin ko dahaannaar minngisana konin damimonam yedi dheseete? ");
INSERT INTO amf_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Harrna hambhidianna, iinte ardayse woylaminte yeskima os mayanka konin utennane” kena ki hamade. Yesus ogo yin kinin giyoono galano wul payya konin dohonam ki giyade. ");
INSERT INTO amf_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kidiar “Eediam minngisayno eedisa woylamra utayno yerrone. ");
INSERT INTO amf_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Eedisa woylamra utayno siya qaabobee, sharmucimakkobee, dimmakkobee, eediam deesintabee, ");
INSERT INTO amf_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","anngarmabee, seeso waadimabee, maltamobee, tagachbee, woogintabee, wuupobee, pormakkobee, boosamobene. ");
INSERT INTO amf_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Igina siyana yerra wul eedisa woylamra keda ute, eediamaar keda minngise” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesus raqin ogora dhaabhayse Thiroos katamansa gasante dohon gurdandar ki yivade. Ogote ooninte ardayse kinin dohonam eedinin dhesoadettsi zagadehe, ko dahaannaar aadhimana damadehe. ");
INSERT INTO amf_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ogoraar naan likkon yisa beeronka yedadhoono edono Yesussa qansayse saanawa hatte kisa roon demente ko dhambade. ");
INSERT INTO amf_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Edonsa apono Girik apone, adhadhinoar kosa Siropiniqa muldharane. Naan konnondara beeronam kinin buloadettsi kiam ko miskade. ");
INSERT INTO amf_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kidi yi giyna: “Birayse naana ke mishe; naanasa galanam tiyayse qaskinana dhaba zaskehe” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kodiar kina maasayse “Gonne, Imbo! Ko dahaannaar naananin itsenka diinenam demente dahayse qaskina kamate itsa ke itse” ko hamade. ");
INSERT INTO amf_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesusaar “Ogo yin hanin giyonna, beerono hasa naandara utidine. Hasa oonindar yivaa” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Edonoar yisa oonindar ko yivade; oonin konin yeskenka, naandara beeron utaysaka naano algadar raatayse ko daaka koam ko haapade. ");
INSERT INTO amf_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesus pir Thiroos katamara Sidoona katamanbar sagayse Tabhi Katamana hambhen peensa shaarinka Galila bazindar ki yivade. ");
INSERT INTO amf_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ogotear dahaana eena qaaminbee aponbeyn kayaa eedi kalaam Yesuskal entsate ke nivade. Kedi aanin yisaam kidar wodayse kinin pacchoadettsi kiam ke miskade. ");
INSERT INTO amf_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesus eensa iira kiam edayse raq ab qalte yisa aanin surkenam kisa qaaminte ki arsade. Ogoraar pathimayse kisa atabhinam ki kaamade. ");
INSERT INTO amf_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tura cecin shedaate woopayse, “Eppitaa!” ki hamade. Ogonoar “Bulimaa!” hamintane. ");
INSERT INTO amf_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Qammoar kisa saanawa ko qansade, kisa atambho dhalqiminoar payya dhalqan ko yedade. ");
INSERT INTO amf_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesus “Eedina giyeebhode” hamayse eenana ki giyade. Ko dahaannaar kedi “Giyeebhode” hamayse kinin maronam kalon giyan ke yedade. ");
INSERT INTO amf_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Eenoar kattsi targadhayse, “Yer wulam payya kida haye; qaamin kayaanaar kenin qansoadettsi, apon kayaanaar kenin dhalqoadettsi kida haye” ko hamade. ");
INSERT INTO amf_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ogo wodanka pir thoothino eeno kikal ko bukade. Yer kenin itsea kesa konin qolmonna kisa paanan yivaynaam yikal eelayse, ");
INSERT INTO amf_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Eeno kono imbesana rooro makkam dooqayse konin itsea yer kosa qolmonna, inta kona burqadhidine. ");
INSERT INTO amf_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Yer ke itsima onnadar keam i yittsidianna goynte shiitayse dhambasane; kesa waani waani eena pee pegera ke nivade” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kisa paanan yivayna eenaar “Ko eenin qolmon darante zarsin kona yeekea gala hamora ko haapadhe?” hamayse kina ke maasade. ");
INSERT INTO amf_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Kidiar “Balasha meemayne yekal dahaana?” hamayse keam ki oysade. Kediar “Balasha tobbhaa wokal dahade” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ogora Yesus eenka “Peendar dooqee” hamayse balashana tobbhaanaam tiyate Barjoam miskeka gobshayse balashanaam qunthayse yisa paanan yivayna eenana eenna kenin yeskisoadettsi ki imade; kediar eenna ke imade. ");
INSERT INTO amf_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kaara shaaqa tokaa waaniar kekal dahade. Iginaamaar tiyate Barjoam miskeka gobshayse eenna kenin imoadettsi yisa paanan yivaynana ki giyade. ");
INSERT INTO amf_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Eenoar itsayse ko mishade. Ko itsaysaka shidhoono dirmano Yesussa paanan yivayna eena sharqa tobbhaa thoosayse ke dhaasade. ");
INSERT INTO amf_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Itsoono eenoar shii oydiaddhane. Ogosa budonte Yesus keam onnadar ki yittsade. ");
INSERT INTO amf_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ogora saanawa yisa paanan yivaynabete bazindara sagadhen gonngalante ardayse Dalmanuta peendar ke yivade. ");
INSERT INTO amf_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parisa eenoar Yesuskal nivayse kiam taysate shedota, “Barjokala nivaa hanin dohonam woninkay dhesea tarshea milkit wona hayaa” hamayse kimbesana ke palimade. ");
INSERT INTO amf_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesus yisa qaabonkaar atayse “Uuh!” hamada, “Wodan koka dohoono eeno tarshea milkit haydhoadettsi harrna ko zage? Inta yena gon ida giye: Wodan koka dohon eenna tarshea milkit haydhehe” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ogora keam garayse pir bazindara sagadhen gonngalante ardayse bazinsa saabar ki sagade. ");
INSERT INTO amf_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesussa paanan yivayna eena balasha yinka bavima walayse kenin nivonna, bazindara sagadhen gonngalante balasha kalaara ab balasha qolehe. ");
INSERT INTO amf_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesusaar “Shedee! Parisa eenabee Herodisbesa irshora mete yesaam gishee” hamayse kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kediar kinka kinka “Ogono yin kinin giyoono balashayn wosa qolmonnane” ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesusaar kesa qaabonam dhesayse kena yin ki giyade: “‘Balashanin wosa qolmonnane’ hamayse harrnee kikal dhalqe? Akar bhocchattenu? Dhesattenu? Woylammoar yesa duudiw? ");
INSERT INTO amf_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yesa aapi daaka yedi haapattenu? Qaami yesa daaka yedi qansattenu? Hamin ko yena bhoqan garaa? ");
INSERT INTO amf_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Balasha dongnam shii dongin eenam inin kunson wodanka, dirmano sharqa meemayne thoosayse yenin dhaasoono?” kena ki hamade. Kediar “Sharqa tabhi lamaane wonin dhaasoono” ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Balasha tobbhaanaamsin shii oydin eenna inin kunson wodanka, dirmano sharqa meemayne thoosayse yenin dhaasoono?” kena ki hamade. Kediar “Sharqa tobbhaane wonin dhaasoono” ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Ta ogono akar yena bhoqayu?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Beetesaydar kenin nivenka, eedi aapi kayaa kalaam Yesuskal entsate nivayse kiam kinin kaamoadettsi Yesusam ke miskade. ");
INSERT INTO amf_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesusaar aapin kayaa easa aaninam yedayse entsate kiam gurdara ki bulade. Ogotear aapindar kisa pathimayse aaninka yisa kinin kaamonsa budonte, “Yer hakal haapa ko haapadho?” hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ear dheg kinin hamonsa budonte, “Eeno isa aapinte haaqadettsi dahayse konin yaayenam ida haape” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesus pir lansi yisa aaninka kisa aapinam kinin kaamonsa budonte, payya hayayse ki haapade; kalon paashaysear yer wulam may may haapan ki yedade. ");
INSERT INTO amf_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ogosa budonte Yesus eam “Gurdante ardaabhode” hamayse oonindar kiam ki yittsade. ");
INSERT INTO amf_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesusbee kisa paanan yivayna eenabe Pilbhisoos Qesaaria peensa gasante dohon gurdandar ke yivade. Ogo goynkaar kenin yivenka Yesus “Eeno iam hay ko hame?” hamayse keam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kediar “‘Shivea Wannisne’ koda hame; waani eenoar ‘Eeliasne’, waani eenoar ‘Barjokala qansayse eenna giyayna eenasa kalaane’ koda hame” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Yedi iam hay yeda hame?” hamayse keam ki oysade. Bhethiroosaar kina yinin maasenka, “Ya Barjoyn qadhaa Kiristoosne” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesusaar “Innon goynam eedi haynaar giyeebhode” hamayse upsi wocchika kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesusaar yisa paanan yivayna eenana “Inta Eedi Naas thoothi gaale tiyayda tiye; peensa donzanabee, gudullasa hayonabee, Musesa yigginam dhettsaynabe iam baga ke bage; iam deesa ko deesadhe. Ogora rooro makkamsa budobar dembhira dhaabhayda dhaabhe” hamayse keam dhettsan ki yedade. ");
INSERT INTO amf_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Dhalqinamaar may hayayse kena ki giyade. Bhethiroosaar yimal kiam entsate yivayse waciman ki yedade. ");
INSERT INTO amf_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesus budoka yisa wal hamayse kisa paanan yivayna eenaam shedayse Bhethiroosam “Ya Seethaan, isa aapira os yivaa! Barjoyn qaabenam qaaban garayse eedinin qaabenam hada qaabe” hamayse kiam ki wacimade. ");
INSERT INTO amf_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesus een waanibee yisa paanan yivaynabeam yikal eelayse kena yin ki giyade: “Isa paanan nivana nashea hay ki dahaannaar yinnon qaabon ki gare; yinindar ziitate deesadhen masqalinam kedayse isa paanan ki nive. ");
INSERT INTO amf_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sadan yinnonam dhacchana nashea hay ki hannaar koam kaysa ki kayse; imbee Barjosa dhacchintan upsinbena sadan yinnonam kaysea hay ki dahaannaar koam dhaccha ki dhacche. ");
INSERT INTO amf_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Eedi peen kodar dohon yer wulam haapayse sadan yinnonam kaysidi ki hanna, kina har ko poote? ");
INSERT INTO amf_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Eedi yisa sadanna baza yer har ki kashe? ");
INSERT INTO amf_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Ko wodanka Barjoam garayna seeson eenasa shaarinte imbee isa upsinbeka ooshimbhea wul, inta Eedi Naas Imbaasa gobshinka gazana gaananabesana inin nivenka, inta kanka ooshimbhayda ooshimbhe” hamayse kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesusaar, “Inta yena gon ida giye: Barjosa bitamonin kantanka nivenam yinin haapenka yekka, kote woyaana eenasa shaarinte dembhi diymina eedi daane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yesus ogoam yinin giyonsa budobar laskoa rooroaka Bhethiroosbee, Yayqoobbee, Wannisbeam bish yinka entsate dhukan gudubhondar ki utade. Raqin ogotear Yesussa dantano kesa birante ko ookimade. ");
INSERT INTO amf_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kisa apallo cawlayse kosa bhalqantanoar peen kodar apalan shivaynayn shivate calshana damaamadettsi kattsi ko cawlade. ");
INSERT INTO amf_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Wodan ogoka Eeliasbee Musebe Yesuskal dahayse kimbete kenin dhalqenam ke haapade. ");
INSERT INTO amf_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Bhethiroosaar Yesusna yi giyna: “Woam Dhettsea, raqin kote wonin dahayno wona payyane; ogona baara kalaam hana, kalaam Musena, kalaam Eeliasna hayayse baara makkam wo kee” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ogo wodanka kedi makkamma kattsi kenin kurtumbhonna, Bhethiroos har giya kiam zaskenam kidi dhesadehe. ");
INSERT INTO amf_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pir liilo nivayse keam ko ishkade; liilonsaar iir “Inin nashea isa Naasa kaane; kina qansee” hamea upsi ko qansimade. ");
INSERT INTO amf_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Saanawa wal hamayse kenin shedenka, kembee Yesusbekalanka eedi ab kedi haapadehe. ");
INSERT INTO amf_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Dhukara kenin hanchenka Yesus kena yi giyna: “I Eedi Naas dembhira inin dhaabhenka yekka ta yenin haapon koam eedi haynaar giyeebhode” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ogo yin kinin giyonam qansayse, yisa woylaminka yedayse “‘Dembhira dhaabha’ hamintano kisa hamin giyntane?” hamayse kinka kiam kiam oysan ke yedade. ");
INSERT INTO amf_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kediar “Musesa yigginam dhettsayna eena ‘Birayse niva zaskea Eeliasne’ harrna ke hamaa?” hamayse Yesusam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Kidiar kena “Ogono gonne; Eelias birayse niveane; kidi yer wulam ashka ki ashke. Ko dahaannaar i Eedi Naasina ‘Gebhi gaale tiya ki tiye; pir kiam baga ko bagadhe’ hamayse thaapadhoono harrnane? ");
INSERT INTO amf_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ko dahaannaar inta yena ida giye: Gon Eelias ena kosa birayse nividine; kisaar thaapadhondettsi eeno yinin nashon yerin wulam kidar ko hayade” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesusbee makkamma kisa paanan yivaynabe waani kisa paanan yivayna shidhaanakal maatate kenin nivon wodanka, thoothino eeno kesa gasante buka ko hattaka ke haapade. Musesa yigginam dhettsayna eenaar kembesana kinka kenin palimenka keam ke haapade. ");
INSERT INTO amf_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Eeno wul Yesusam konin haapenka targadhidine; kikalar gobate nivayse kiam ko nagaysade. ");
INSERT INTO amf_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesusaar “Kembesana kinka yenin palimayno yer harsane?” hamayse keam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Eensa shaarira eedi kalaa yinin maasenka, “Woam Dhettsea, beeron yedaysaka apon kayaa isa naasaam hadar bavate i nivade. ");
INSERT INTO amf_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ruminin kisa dhaabhen wodanka hamote ko hannaar kiam dhaba ko dhabe; aponkaar kisa dubo koda nive; atsinin qiicimenka bishinoar kisa zaba ko zabe. Ogo beeronam kidara ke bule hamayse hasa paanan yivaynana i giyaysaka bulana damadehe” hamayse kina ki giyade. ");
INSERT INTO amf_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesusaar yinin maasenka, “Yedi idar woylamin qajimina adhadhinato, hamaaka yekka yembesana ida dee? Yena hamaaka yekkay darsho? Yinda naasaam ikal bevee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kediar naasaam kalan bavate ke nivade. Beeroar Yesusam yinin haapenka, naasaam saanawa ki gibattsade; kidiar peente dhambayse aponka dubon nittsite qaptiman ki yedade. ");
INSERT INTO amf_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesus naasasa imbaam “Kaa burqea naasaam ki yedaysaka leve meemayne?” hamayse ki oysade. Kidiar kina yinin maasenka, “Naasamora yedaysene. ");
INSERT INTO amf_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Thoothi woda kiam deesana nuunbee noqonbesa iir kiam koda dhabe. Ko dahaannaar ha damidianna bannzo! Wona burqadhayse woam kelshaa” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesusaar “Ha damidiannaa hamo? Barjodar woylamin qajeana yer wul kina dandima ko dandime” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Saanawa naasasa imbaa upsin yisaam dheg hayayse “Barjodar woylamin qajayda qaje; ko dahaannaar isa qothimenam ikalanka pegisaa!” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesusaar eenin thoothada kalan nivenka keam haapayse beeroam “Ya aponin dhalqoamadettsi, qaaminin qansoamadettsi hayaa beeroa, naasa kaara utaa! Lansi maatate hanin ardoamadettsi” hamayse ki bitade. ");
INSERT INTO amf_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Beeroar ilatayse naasaam kattsi qaptisada kidara ki utade. Thoothino eenoar “Naasa diydine” kenin hamenka yekka diyaadettsi ki maatade. ");
INSERT INTO amf_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ogora Yesus naasasa aaninam yedayse ki dhaasade; kidiar dhaabhayse ki woyade. ");
INSERT INTO amf_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesus oonin kinin ardonsa budonte, kisa paanan yivayna yimal kinin dohonte, “Beeronam naasadara bulana wonin damaammo harrnane?” hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesusaar kena yinin maasenka, “Kodettsin beeronam itsima Barjoam miskintakatay hamidi ko hanna, goyti abka bulana dandimehe” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesusbee kisa paanan yivaynabe raqin ogoam garayse Galilaka hayayse ke yivade. Ogoam eedi kalaar ki dhese zagadehe. ");
INSERT INTO amf_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Harrna hambhidianna, “I Eedi Naasaam eensa aaninte saskate iam koda imbhe; iamaar deesa ko deesadhe; ogosa budobar makkansoa rooroaka diira dhaabhayda dhaabhe” hamada yisa paanan yivaynaam dhettsite ki dahade. ");
INSERT INTO amf_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kena kinin giyoonoar ardadehe; kediar kiam oysana ke kurtumbhade. ");
INSERT INTO amf_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesusbee kisa paanan yivaynabe Qipirnaahoom katamandar ke nivade. Ogote oonir kenin ardonsa budobar Yesus “Ini goynte wonin nivenka yenin palimayno hare?” hamayse keam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kediar ini goynte “Wo wuldara sagea hayne?” hamayse kinka kinka kenin palimonna, Yesusin oysenka lay ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesus dooqayse tabhi lamaanaam yikal eelayse, “Eedi hay ki hannaar, bira maatana nashea een wulsa budonte ki dee. Een wulsaar erge eedi ki maate” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Naasi kalaam bavate nivayse kesa shaarinte woysayse naasaam shupayse, ");
INSERT INTO amf_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Kaa naasadettsiam isa naabenna hamayse tiyea iam kida tiye; iam tiyea ibisheam dayma iam nittsaamaar kida tiye” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Wannisaar Yesusna, “Woam Dhettsea, eedi kalaa hasa naabenka beeronaam kinin bulenka kiam wo haapade; wombesana kinka kinin dahaamonna kiam wo marade” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesusaar yin ki giyade: “Isa naabenka yer tarshen waadadhayse saana idar yer siya giyana dameayn qolmonna kiam garee; mareebhode! ");
INSERT INTO amf_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Harrna hambhidianna, woam jibbimina wul wombesana kinka ke dahade. ");
INSERT INTO amf_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Inta yena gon ida giye: Kiristoossa yenin dohonna sharqa kalaa noqo yeam wushea wulsa baza shidhehe. ");
INSERT INTO amf_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Idar woylamin qajayna igina likkanasa iira kalaana goa maatea eedi hayyear daa ki hanna, deesime seeni gaari kisa qorcindar dhaxayse bazinte kiam dhabadhidi ki hanna, kina payyane. ");
INSERT INTO amf_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ogona anno hanno hana goa maatea ko hanna, koam taxate dhabaa. Aan lamaaka dahayse qayonin diymon lay dikimon nuunte hanin ardenna, gundi dahayse sadanka daadhen raqinte hanin ardayno hana payyane. ");
INSERT INTO amf_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Roono hanno hana goa maatea ko hanna, koam taxate dhabaa. Roo lamaaka dahayse qayonin diymon lay dikimon nuunte hanin ardenna, gundi dahayse sadanka daadhen raqinte hanin ardayno hana payyane. ");
INSERT INTO amf_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Aapino hanno hana goa maatea ko hanna, koam bulate dhabaa. Aapi lamaaka dahayse qayonin diymon, lay dikimon nuunte hanin ardenna, aapi kalaka dahayse Barjosa bitamonte hanin ardayno hana payyane. ");
INSERT INTO amf_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Gala sooqoka konin daathisadhendettsi, een wulam nuuka koqate koda ashkadhe. ");
INSERT INTO amf_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Sooqo payyane. Ko dahaannaar daathan garidi ko hanna, harka ko daathisadhe? Ogona yesa shaarinte sooqodettsi daathea daathamo yesa ko dee; kinka kinkaar payyamoka dehee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesus ogora dhaabhayse Yordaanoos baynsa saabarka hayayse Yiwda peente dohon raqindar ki yivade; ogo baynsa saabar thoothino eeno pir kikal ko bukade. Kidiar yisa dambindettsi eenaam dhettsan ki yedade. ");
INSERT INTO amf_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Parisa eenaar kikal nivayse, “Eedi geshon yinnonam bulate kinin yittsoadettsi Musesa yigginte giidhidu?” hamayse taysate shedana kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Kidi yi giyna: “Muse ena yena hamin ki giyaa?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kediar “Muse ‘Eedi geshon yinnonam yinin bulenka, bulayse yinin oytensa tarja maatea warqat kona thaapate imayse ki bule’ hamayse ki giyade” ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesus kena maasayse yi giyna: “Muse yena yin giyayse kinin thaapoono yedi woylaminka yesa Barjona ee hamimina yenin dohonnane. ");
INSERT INTO amf_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ko dahaakaar pijadhinsa birayse Barjo ‘Anngibee maabe hayayse keam ki pijade. ");
INSERT INTO amf_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ogonante eedi imbabee indabeam gara ki gare; geshon yinnonbete kinka kida dee; ");
INSERT INTO amf_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","kedi lamaanaar waa kalaa keda maate’ hamayse ko thaapadhade. Kedi keeda kaara os waa kalaa keda maate, lamaa maatehe. ");
INSERT INTO amf_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ogona Barjo kidar kalaa kinin hayonam eedi ko kidara edabhoode” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ooninte kinin ardonsa budonte, kisa paanan yivayna eena yerin ogo goynam lansi dhaasayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kidiar “Eedi hay ki hannaar, geshon yinnonam bulate yittsayse maa ab keemea kidi ta yinin keemonka sharmucimayse biron geshondar seeso waadadhidine. ");
INSERT INTO amf_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Geshono geshoa yinteam garayse anngi abka kembhidi ko hanna, kodi sharmucimidine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Yesus yisa aaninam kedar kinin wodoadettsi eeno yisa naason shaaqanam daran bavate ko nivade; ogona kisa paanan yivayna eena eenaam ke wacimade. ");
INSERT INTO amf_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesus ogoam kesa yinin haapenka, yisa paanan yivayna eenaam wacimayse, “Naasono shaaqano idar ko nive; koam mareebhode. Harrna hambhidianna, Barjosa bitamono igina naanadettsi maataana eenasane. ");
INSERT INTO amf_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Inta yena gon ida giye: Barjosa bitamonam naasidettsi maatayse tiymina wul yer hamin hambhaakaar iir ardehe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yin kinin giyonsa budobar naanaam yidar tiyate shupayse, kedar yisa aaninam wodaate kena Barjoam ki eelade. ");
INSERT INTO amf_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesus ogora goyti yivo kinin dhaabhenka, eedi kalaa gobaka kalan nivayse hatte birante kisa kumpurdhayse, “Ya Payya Dhettsea, rooro wul lay dehen sadan haapota yer har haynta ko iam zaske?” hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesusaar “Payya ea inka harrnaa hamaa? Barjo bishkalanka ab eedisa payya hama eedi qolehe. ");
INSERT INTO amf_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Barjoyn giyonam dhesaada dhese: Deesaabhode, sharmucimaabhode, dimmaabhode, buudamoka tarjaabhode, maltimaabhode, hambabee handabeam gobshaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ear “Woam Dhettsea, igina wulam inta isa naasamora yedayse toolidine” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesusaar kiam shedayse nashabh hayayse “Hanin hayaama yer kalaa bishne hasa joogaa. Ogonoar yivayse hasa dohon koymonam shanshayse qambhinana imaa. Ya hasa bazanam cecinte hada haape. Ogora maatayse isa paanan nivaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ear koymo thoothinin kisa dohonna, ogoam yinin qansenka qaaboka wotin yisa ki thipsade. Ogoraar yisa iinka ataate ki yivade. ");
INSERT INTO amf_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesus yisa gasanam shedayse paanan yivayna eenana “Wodimma eenasa Barjo bitamonte ardano hamin dohoono gaalene” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kisa paanan yivayna eenaar ogo yin kinin giyenka kedi targadhidine. Yesus pir kena yin ki giyade: “Ye naanato, Barjosa bitamonte ardano hamin dohoono gaalene. ");
INSERT INTO amf_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Eedi wodimoyn Barjosa bitamonte kinin ardenna gamaleyn marpisa pulaka konin utayno deegane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kediar kattsi targadhayse kinka kikal yi giyna: “Yin ko hanna, ta keeda hayne dhaqana damea?” ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesusaar keam shedayse, “Ogono eedina dandimehe; Barjona koda dandime. Harrna hambhidianna, Barjona yer wul dandima ko dandime” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Bhethiroos yi giyna: “Shedaa! Wodi yer wulam garayse hasa paanan wo nivade” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesus maasayse kena yin ki giyade: “Inta yena gon ida giye: Imbee Barjosa dhacchintan upsinbena hamayse indanaana annginabee anzanabeam, pir imbaabee, indanbee, naana yinnabee, oonin yinnonbee, haamin yinnonbeam garaa, ");
INSERT INTO amf_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ta peen kodar oytaydhanka indanaana annginabee anzanabeam, pir indanbee, naana yinnabee, oonin yinnonbee, haamin yinnonbeam iginara sagi mato goyt tiyma garea eedi qolehe; os niven wodankaar rooro wul lay dehen sadan haapa ki haape. ");
INSERT INTO amf_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ko dahaannaar thoothino birono eeno budo koda maate; budonte dohoono eeno pir bira koda maate” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yerusaalemdar yivota goyn utayse ke daaka, Yesus kesa birante kinin yivenka, kisa paanan yivayna eenaar Yerusaalemdar kinin yivenna targadhite ke dahade; pir waani eeno kesa tudhin yivaynoar kurtumbhidine. Ogo wodanka kisa paanan yivayna tabhi lamaana eenaam pir eensa iira keam eelate bulayse yidar yesko dohon gaalensa kena giyan ki yedade: ");
INSERT INTO amf_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Marrato! Wodi ta keeda Yerusaalemdar woda yive. I Eedi Naasiam gudullasa hayonabee Musesa yigginam dhettsayna eenabena saskate imbha ko imbhe; kediar inin deesadhoadettsi idar pirda ke pirde; Ayiwdtay hamma eena yettsate iam ima ke ime. ");
INSERT INTO amf_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ayiwdtay hamma eena iam bagayse idar pathima ke pathime; iam qana ke qane; ogoraar pir iam deesa ke deese; intaar rooro makkamsa budobar dembhira dhaabhayda dhaabhe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zabdoos naana Yayqoobbee Wannisbe Yesuskal nivayse, “Woam Dhettsea, haam wonin misken wulam wona hanin waadadhoadettsi woda nashe” hamayse ke giyade. ");
INSERT INTO amf_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Kidiar kena “Yena yer har i waadadhee zage?” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kediar “Gobshinka hanin bitimenka, wosa iira kalaam hasa mizaqimbar, kalaam hasa warkatambar hayayse woam dottsaa” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesusaar kena “Yedi yenin miskenam dhesattene. Inin wucen gaalen wucimanam yedi wucana damaw? Inin shiidhen gaalen shiidhimenam yedi shiidhimbhana damaw?” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Kediar “Damooda dame” ke hamade. Yesusaar “Inin wucen gaalen wucimanam wuceeda wuce; inin shiidhimbhen shiidhimenam yedi shiidhimbheeda shiidhimbhe. ");
INSERT INTO amf_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ko dahaannaar isa mizaqimbee warkatambebar dottsea intatehe; raqin ogoam yinnante ashkadhaanana imbha ko imbhe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Waani tambha Yesussa paanan yivayna eenaar yin giyayse kenin miskenam qansayse Yayqoobbee Wannisbeam waciman ke yedade. ");
INSERT INTO amf_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesus ke wulam yikal eelayse kena yin ki giyade: “Barjoam dhesimina eenaam wottsaynane hamayse qaabadhayna eenaam kantaka kenin wottsenbee entsaynaar kedar kesa hayamo kenin dhehenbeam dheseeda dhese. ");
INSERT INTO amf_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yennon shaarinte yin konin doadettsi zaskehe. Yennon shaarinte eedi hayyear gebhi doota zagea yesa waadima eedi ki dee. ");
INSERT INTO amf_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Yesa iira eedi hayyear bira doota zagea wulsa choobar dehea eedi ki dee. ");
INSERT INTO amf_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Harrna hambhidianna, inta Eedi Naasear eenna waadadhanabee isa sadanamaar thoothin eensa seeson bazan kashotabe i nivade; eeno ina konin waadadhoadettsi nivaatine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ogosa budonte, Yesusbee kisa paanan yivayna eenabe Iyarko katamandar ke nivade. Ogora waani thoothin eenbesana Iyarkora utaate kenin yivenka, Themoos naasa aapin kayaa Barthemoos goyn aponte dooqayse miskimite ki dahade. ");
INSERT INTO amf_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kidiar goyn ogoka sagate yivea Naazret peen Yesus kinin dohonam qansayse, “Dawt Naasa Yesuso, bannzo! Ina burqadhayse iam pacchaa” hante gebhi ilatite miskiman ki yedade. ");
INSERT INTO amf_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Eensa iira thoothino eeno kanka “Ya lay hamaa!” hamayse kiam ko wacimade. Kidi pir “Dawt Naasa, bannzo! Ina burqadhayse iam pacchaa” hante ini yinin ilaterra kalon sagi ilatan ki yedade. ");
INSERT INTO amf_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesusaar woyayse, “Kiam eelee” ki hamade. Eena ea aapin kayaaka “Hay, dhaabhaa! Haam eela ki eele” hamayse kina ke giyade. ");
INSERT INTO amf_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kidiar yisa apalanam dhabayse saana dhaabhayse Yesuskal ki nivade. ");
INSERT INTO amf_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesusaar “Hana yer har i hayea zage?” kina ki hamade. Aapin kayaa ear “Dhettsea, shedana ida zage” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesusaar “Ya yivaa, idar woylamin hanin qajoono haam ko pacchade” kina ki hamade. Easaar aapino saanawa ko shedade. Ogosa budonte, kidi goynka Yesussa paanan yivan ki yedade. ");
INSERT INTO amf_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesusbee kisa paanan yivayna eenabe nivite Yerusaalemkal theedayse Dabirezayt dhukansa gasante dohon Bitaaniabee Betepaagebe gurdankal kenin theeden wodanka, Yesus yisa paanan yivayna eenasa lamaanaam yin giyayse keam ki yittsade: ");
INSERT INTO amf_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Ogo yesa birante dohon gurdandar yivimate. Ogote yenin yeskenka, eedin yindar dooqate shedaama ukulisa ooto dhaxadhaa haapeeda haape; agaam bulayse ina kiam kote qanate nivee. ");
INSERT INTO amf_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Eedi hay ki hannaar, ‘Harrnee ukuliam bule?’ hamayse yeam oysidi ki hanna, ‘Imbaa wonteana kinin zaskonnane; kidiar saanawa yena kiam maasate nittsasane’ kina hamee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kediar yivayse eedi kalaasa mayan kerinsa goyn aponte dhaxadhaa ukuliam haapayse ke bulade. ");
INSERT INTO amf_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ogo raqinte woyayse dohoono eeno waani “Ukuliam har hayee bule?” hamayse keam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kediar Yesusin giyon kena ke giyade. Eenaar qansayse ukuliam kena ke garade. ");
INSERT INTO amf_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Yesussa paanan yivaynaar ukuliam qanate Yesuskal nivayse ukuliasa zulondar yisa apalanam ke wodaysaka, Yesus daran ki dooqade. ");
INSERT INTO amf_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Thoothino eeno yisa apalanam goyndar ko apade; waani eenoar haaqansa hacchan taxate goyndar ko apade. ");
INSERT INTO amf_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kisa birante yiven eenbee budonte niven eenbe “Gobshi hana ko dee; Barjo Imbasa naabenka nivea ya gobshadhaane! ");
INSERT INTO amf_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nivayno imba wontea Dawtsa bitamonoar gobshadhoonone! Cecinte Barjona gobshi ko dee!” hamaate upsi gebhika kiam ke gobshade. ");
INSERT INTO amf_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesusaar Yerusaalem yeskayse Barjosa gazan ooninsa mayante kinin ardonsa budobar, gidir kosa dohon yerinam shedada hayayse haynin wovonna kisa paanan yivayna eena tabhi lamaanabete kinka Bitaania gurdandar ke yivade. ");
INSERT INTO amf_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Burin Bitaaniara kenin maatenka Yesusam daaqi bashade. ");
INSERT INTO amf_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Haaqa shaap kallo goobayse konin dohonam pegeka haapayse, “Aapi kosa dook?” hamayse kodar ki nivade. Ko dahaannaar wodano hatton ogosa aapi konin ushea wodatay konin dohonna, kinin shedenka haccha bish kodar dahade; aapi haapadehe. ");
INSERT INTO amf_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ogo wodanka Yesus hattonna yi giyna: “Keeda kaara os macchi eedi ko hasa aapi itsabhoode” ki hamade. Kisa paanan yivayna eenaar ogo yin kinin giyenam qansidine. ");
INSERT INTO amf_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kediar Yerusaalemdar ke nivade. Ogotear Yesus Barjosa gazan ooninsa mayante ardayse koymonam shanshaynabee shanayna eenabeam ooninsa mayara oytan ki yedade. Birren ookayna eenasa tharbhezanbee waleen shanshayna eenasa borkotonbeam kupate ki dhabade. ");
INSERT INTO amf_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ogoraar gaba koymo bavayse eedi hay ki hannaar, Barjosa gazan ooninsa mayanka sagate kinin yivoamadettsi ki marade. ");
INSERT INTO amf_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Guttsayse “‘Onno isa zarsin wulin Barjoam miskayno misken onno koda hambhe’ hamayse thaapadhadaa? Yedi eensa koymon buurate itsaynasa aadhime raq koam ye hayade” hamayse keam dhettsite ki dahade. ");
INSERT INTO amf_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Gudullasa hayonabee Musesa yigginam dhettsayna eenabe ogoam kisa qansayse, “Hamin hayayse wo kiam deeso?” hante goyti zagan ke yedade. Harrna hambhidianna, kisa dhettsidinka eeno wul konin targadhenna, kedi Yesusna kurtumbhite ke dahade. ");
INSERT INTO amf_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yesusbee kisa paanan yivayna eenabe peenin sootonsa budonte, katamara ke utade. ");
INSERT INTO amf_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Burin kenin yivenka hattono shaapino ke hanna, yisa caacinka wocchayse konin dohonam ke haapade. ");
INSERT INTO amf_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Bhethiroos yer kina bhoq hamaysaka, “Woam Dhettsea, shedaa! Hattono shaapino hanin ashoono wocchidine” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesusaar kena yin giyayse ki maasade: “Barjodar woylamin qajee. ");
INSERT INTO amf_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Inta yena gon ida giye: Eedi hay ki hannaar, woylaminka yisa qothimima yerro kinin giyoono kina konin maateadettsi woylam qajidi ki hanna, ko dhukanam ‘Agaara dhaabhayse bazinsa iinte wavaa!’ hamidi ki hanna kina maata ko maate. ");
INSERT INTO amf_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ogonante yena ida giye: Barjoam yenin misken yerin wulam yenin haapaadettsi hayayse woylam daran qajimate, yenaar maata ko maate. ");
INSERT INTO amf_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Barjoam misko yenin woyen wodanka, cecinte dahaa Imbaa yentea yennon seesonam yena kinin garoadettsi, yediar eedidar yesa dohon wacen wulam kena garmate. ");
INSERT INTO amf_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ye kena garaamma cecinte dahaa Imbaa yentea yennon seesonam yena garehe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Pir kedi Yerusaalemdar ke nivade. Ogotear Yesus Barjosa gazan ooninsa mayante kinin yaayenka, gudullasa hayonabee, Musesa yigginam dhettsayna eenabee, peensa donzanabe kinka kikal nivayse, ");
INSERT INTO amf_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Yerra iginaam hanin hayayno hasa yer har hayamokane? Kina yerra wulam hanin hayoadettsi hana hayamon imaa hayne?” hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesus “Intaar yer kalaa yeam ida oyse. Yedi ina inin oysonam maasee; intaar yerra iginaam yer har hayamoka inin hayenam yena giyayda giye. ");
INSERT INTO amf_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Wannis eenaam kinin shivoadettsi kinin nittsadhoono Barjokalankamoo? Eedikalankaw? Inin oyson oysimensa malsin ina maasee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kediar yin giyayse kinka kikal ke dhalqade: “‘Barjokalankane’ wo hamanna, ‘Ta harrnee kisa dhalqinam gonne hamayse tiyan garaa?’ wona kida hame. ");
INSERT INTO amf_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ta ‘Eedikalankane’ wo hamo?” ke hamade. Eeno wul “Wannis gon Barjokala qansayse eenna giyeane” hamayse kenin giyenna, eenna ke kurtumbhade. ");
INSERT INTO amf_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ogonante Yesusna “Hamora konin dohonam wodi dhesattone” hamayse ke maasade. Yesusaar “Ta keeda intaar har hayamoka yerra iginaam inin hayenam yena giyattine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesusaar kamsika kena yin ki giyade: “Eedi kalaa woynin haaqanaam yisa haaminte thoothi ki korade. Kidiar haaminsa gasanam aygi cavayse, haaqanasa aapinam cuubadhea oolo koyayse ki ashkade; haaminam toolana pir kattsi dheg hama tulee ki kahade. Ogosa budonte, haaminte waadadhayna eenana elqimayse pee abdar ki yivade. ");
INSERT INTO amf_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Woynin haaqanasa aapin kambhen wodan yeskaysaka, aapin ki beve hamayse yisa erge eedi kalaam haaminte waadadhayna eenadar ki yittsade. ");
INSERT INTO amf_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Haaminte waadadhaynaar kisa ergen eam yedate qanayse aan guuri ke yittsade. ");
INSERT INTO amf_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Pir haaminsa imbaa ab yisa erge eedi kalaam ki yittsade; haaminte waadadhaynaar kiam qanate meten kisa torsayse kiam ooshinsayse ke yittsade. ");
INSERT INTO amf_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Pirar eedi ab ki yittsaysaka, kiamaar ke deesade. Ogoraar haamin imba eedi thoothi ki yittsaysaka, waani waaniam ke qanade; waaniam ke deesade. ");
INSERT INTO amf_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Keeda haaminsa imbaayn adhaa naasi kalaa kisa kinin nashea dahade. ‘Kedi naasa inteana bookindhasane’ hamayse macchindar kiam kedar ki yittsade. ");
INSERT INTO amf_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Haaminte waadadhaynaar kinka kinka yinin giyenka, ‘Kaa kisa haamindar sagea naasa toydiane. Nivee, kiamaar wo deese; hammoar wona ko shidhe’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ogora naasaam yedayse ke deesade; deesaysear woynin haaminsa iira kiam bulayse ke dhabade. ");
INSERT INTO amf_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ta keeda haaminsa imbaa hamin ki haye? Kidi yinti nivayse haaminte waadadhaynaam kida deese; ogoraar woynin haaminam eedi abna kida ime. ");
INSERT INTO amf_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","‘Seeninka oonin woysayna eena kenin bagaa seenia senna wulra ooninna kattsi zaskea ki maatade. Ogonoar Barjosa waadimane; wonin shedenkaar yer woam tarshaynone’ hamayse Mathaap Gazante thaapadhonam yedi nabbabeete?” hamayse keam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ayiwd eenasa entsana Yesusin kamsinka giyaa dhalqa keam kaamea kinin dohonam kenin dhesonna, kiam yedana ke zagade; ko dahaannaar thoothin eenam kenin kurtumbhonna kiam garayse ke yivade. ");
INSERT INTO amf_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ayiwd eenasa entsana Yesussa dhalqinka kiam yedana Parisa eenabee Herodissa bitamonam nashayna eenabera eedi daran ke yittsade. ");
INSERT INTO amf_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kedi kikal nivayse, “Woam Dhettsea, ya gon hama eedi hanin dohonam wodi dhesooda dhese; eedisa wotina bookindhayse hanin hayminna, eessa woti shedayse hanin hayea yer qolehe. Barjosa goynam gon hada dhettse. Ta Roome peen bitaana gibirin kashadhoadettsi giidhidimoo? Giidhadayne? Ta wodi gibirinam kina kashoo kashoomoo? Garoo garo?” hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yesus woylaminka siyon bavayse aponka bish kenin ashkenam kesa dhesayse, “Harrnee iam tayse? Yinda i shede santup kote ina bevee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kediar kina ke bavade. Kidiar “Santupa kaadar dahaa pootoabee daran thaapadhaa naabeabe haysane?” hamayse keam ki oysade. Kediar “Roome peen bitaasane” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesusaar kena maasayse “Roome peen bitaa gaynam kina imee, Barjo gaynam Barjona imee” ki hamade. Kediar kisa dhalqinka targadhidine. ");
INSERT INTO amf_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","“Dembhira dhaabhadhea yer qolehe” hamayna Saduqa eenara eedi waani Yesuskal nivayse yin giyayse kiam ke oysade: ");
INSERT INTO amf_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Woam Dhettsea, Muse yin giyayse wona ki thaapade: ‘Eedi kalaa maa keemayse naasi adhima diydi ki hanna, kisa kana koam keemayse diyaa iishimasa oolonte kina ki adhe’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Eedi kalaasa naasi tobbhaa waani ke dahade. Ke wulsa iishima gebhaa maa keemayse naasi adhima ki diyade. ");
INSERT INTO amf_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kisa kana lansoa iishimaa geshonam keemayse naasi adhima ki diyade; makkansoar iishimmadettsi koam keemayse naasi adhima ki diyade; ");
INSERT INTO amf_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ogodettsi naana tobbhaana edon ogoam keemayse naasi adhima ke diyade. Ke wulsa macchinte edono ko diyade. ");
INSERT INTO amf_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Igina indanaana tobbhaana wul koam kenin keemonna, diyaana eena dembhira kenin dhaabhen wodanka, kodi hamaa easa maa koda maate?” hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesusaar kena yi giyna: “Yenin dhaddhisayno Mathaap Gazanbee Barjosa kantanbeam yenin dhesiminnatayu? ");
INSERT INTO amf_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Harrna hambhidianna, eedi dembhira yinin dhaabhonsa budonte, cecinte dahaana Barjosa gaananadettsi keda maate; kedi yina kembhehe, tapir keemehe. ");
INSERT INTO amf_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Diyoono eeno ko hannaar, konin dhaabhoadettsi Barjo Museyn thaapon mathaapinte hatta kodoadar nuunin yedenka Musena ‘Inta Abraamsa Barjoa, Yisaaqsa Barjoa, Yayqoobsaar Barjoane’ hamayse kinin giyonam yedi nabbabeete? ");
INSERT INTO amf_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Barjo sadanka dahayna eenasa Barjone; diyaana eenasa Barjotehe. Yedi kattsi yeda dhaddhise” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Musesa yigginam dhettsaynara eedi kalaa nivayse kenin palimenka qansayse, Yesus payya malsi kena kinin maasaadettsi shedayse, “Barjo yinin giyaana upsina wulra sagea hamaane?” hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesusaar “Wulra sagea upsea ‘Israveel eenato, qansee! Barjoa Imbaa wontea kalaane; ");
INSERT INTO amf_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ya Barjo Hambaam gonin hamon woylaminka, gonin hamon sadanka, gonin hamon qaabenka, gonin hamon kantanka kiam nashaa’ hamaynone. ");
INSERT INTO amf_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Lansoar ‘Een wulam hadettsi hayayse nashaa’ hamaynone. Iginaranka ab sagi upsi qolehe” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Musesa yigginam dhettsear “Woam Dhettsea, gonaa giyade! Barjo kidi kalaane; kidara ab barjo qolehe hamayse hanin giyoono gonne. ");
INSERT INTO amf_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ogona gonin woylaminka, gonin bhocchinka, gonin sadanka, gonin kantankaar Barjoam nashintabee pir eedi wulam yidettsi hayayse nashintabe, Barjona koqadhen marshanbee abin imbhen marshanbera kattsi sagine” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesusaar yiggin dhettsea qaabayse kinin maasonam shedayse, “Ya Barjosa bitamora pegadhaatehe” kina ki hamade. Ogosa budonte, hayyear Yesusam oysime oysana kurtumbhidine. ");
INSERT INTO amf_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesusaar Barjosa gazan ooninsa mayante yinin dhettsenka yin ki giyade: “Musesa yigginam dhettsayna ‘Barjoyn qadhaa Kiristoos Dawt naasine’ hamayse hamin ke giyaa? ");
INSERT INTO amf_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawt yinti Manpas Gazan yiam entsaysaka, ‘Barjo isa Imbana “Haam jibbayna eenaam hasa hayamonsa demente inin hayenka yekka isa mizaqimbar dooqaa” kina ki hamade’ kida hame. ");
INSERT INTO amf_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ta Dawt yinti kiam, ‘Isa Imba’ hamidi ki hanna, Kiristoos hamin ki Dawtsa naasi dee?” kena ki hamade. Thoothino eenoar wozaka kinin giyenam qansite ko dahade. ");
INSERT INTO amf_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","39","Yesus yinin dhettsenka yin ki giyade: “Gudubhon apalan qaadhayse osbee orabe hamota, pir gabante gobshadhon gisimenam gisimbhota nashayna Musesa yigginam dhettsaynakala yeam gishee. Kedi Ayiwd eensa bukin raqinte gobshadhon borkotonbee kumman kummadhen raqinte gobshadhon raqinbeam tiyota keda nashe. ");
INSERT INTO amf_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Miskenam kesa eedinin qansoadettsi hamayse gudubhsintaka maltimaate maana qambhinasa ooninam keda buure; ogona kedar sagi pirdi koda yeske” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesus koymon Barjona dhabadhen saathininsa birante dooqayse zarsinin saathininte koymon hamin konin dhabenam shedite ki dahade. Thoothina wodimmaar thoothi koymo saathininte dhabite ke dahade. ");
INSERT INTO amf_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Maa qambhi kalloar nivayse santup kala maatea bakkanda lamaa saathininte ko dhabade. ");
INSERT INTO amf_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesusaar yisa paanan yivaynaam yikal eelayse, “Inta yena gon ida giye: Kono edono qambhino koymon saathininte dhabayna eena wuldara sagi ko dhabade. ");
INSERT INTO amf_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Harrna hambhidianna, eeno wul yisa dohon koymon thoothinsa iira yina shiishayse ko dhabade; kodi qambhi dahayse yina kala hattear shiishima, yisa dohon koymon wulam ko dhabade” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesusaar Barjosa gazan ooninsa mayara kinin utenka, kisa paanan yivayna eenasa eedi kalaa “Woam Dhettsea, senna kina hamin kenin dohonbee seeninka woysadhaana onna kina hamin kenin haydhonbeam shedaa” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesusaar “Senna kina gembhaka woysadhaana onnaam ya shedaa shedo? Senna kina kidar dordhaanasa hamin hambhaakaar, kesa kala hattear kidara povayse kottsimima shidhea qolehe” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesus Barjosa gazan ooninka yekka dhari Dabirezayt dhukandar dooqayse ki daaka, Bhethiroosbee, Yayqoobbee, Wannisbee, Indiriasbe kalan theedayse, ");
INSERT INTO amf_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ogono yerro haa ko yin maate? Ogono yerro wul yin maatanba konin dohonam dhettsayno milkitino kosa hare? Wona giyaa” hamayse yimal ki daaka kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesusaar kena yi giyna: “Eedi hayyear yeam kinin dhaddhisoamadettsi mete yesaam gishee. ");
INSERT INTO amf_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Thoothino eeno ‘Inta Kiristoosne’ hamaate isa naabenka niva ko nive; thoothin eenamaar dhaddhisa ko dhaddhise. ");
INSERT INTO amf_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Yekal banqinin dhaabhenkabee pegente banqisa upsinam yenin qansenkabe kurtumbheebhode. Ogono yin konin maatayno shidha shidhiminone; ko dahaannaar macchin wodano akarne. ");
INSERT INTO amf_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Zarsino zarsindar, binnaar binnadar dhaabhayse banqi keda kiam uxe; raq waani waanir peesa ziga koda maate; daaqiar koda maate. Ogono yerro edon sirmanin adhimanna birayse burqadheadettsi gaalen rooronsa biranone. ");
INSERT INTO amf_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Yedi yeam gishimate. Pirdin pirdayna eenasa birante yeam saskate ima ke ime; Ayiwd eenasaar bukin raqinte yeam qana ke qane. Isa tarja kena yenin doadettsi, goyn innonka peen wottsayna eenabee binnabesa birante yedi woyeeda woye. ");
INSERT INTO amf_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Macchin wodan nimbha birayse Barjosa dhacchintan upsino een wulna giidha ko giidhe. ");
INSERT INTO amf_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Yeam yedate pirdinna woysadhen wodanka, yenin giyoadettsi ogo wodanka yena imbhon upsinam giymate. Birayse ‘Yer haroo giyo?’ hamayse qaaboka gaaleebhode; harrna hambhidianna, yenka maatayse giyayno Manpas Gazanone, yeditehe. ");
INSERT INTO amf_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ogo wodanka indanaasaar indanaasaam, imbaar naasa yinteam dembhinna saskate ima ki ime; naanaar imbanadar dhaabhayse keam dettsa ke dettse. ");
INSERT INTO amf_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yedi isa naabenna hamayse een wulkal jibbadhaana yeda maate. Macchin wodanka yekka wocchimbhayse darshea kidi dhaqa ki dhaqe. ");
INSERT INTO amf_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Eenaam minngisayno siyono yerro zaskaamon raqinte woysadhaysaka yenin koam haapen wodanka (koam nabbabea ea ki bhocche), wodan ogoka Yiwda peente dohoono eeno dhukanadar ko gobe. ");
INSERT INTO amf_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ooninsa zulondar dahaa ea ooninsa zulora hanchayse yer tiyo ki ooninte ardabhoode. ");
INSERT INTO amf_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Haaminte yisa dahaar apalan yinnon tiyota budoka ki maatabhoode. ");
INSERT INTO amf_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ogo wodanka maana sirmanabee amin qooshaynabena hay! ");
INSERT INTO amf_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ko dahaannaar gobeno yesa bargin wodanka konin doamadettsi Barjoam miskimate. ");
INSERT INTO amf_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ogo wodanka Barjo peen koam kinin pijorra yedayse ta koka yekka eedinin haapaammo gaale niva ko nive; os birantear kodettsino gaaleno yer hamin hambhaakaar nivehe. ");
INSERT INTO amf_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Barjo galshen rooronaam ki orgisaamma, eedi kala hattear dhaqana damehe. Ko dahaannaar kinin kamayse edaana eenana hamayse ki rooronaam orgisade. ");
INSERT INTO amf_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ogo wodanka eedi hay ki hannaar ‘Marrato! Barjoyn qadhaa Kiristoos kote ki dahade’ way ‘Saa ogote ki dahade’ yena hamea ki hanna, gonne hamayse tiyeebhode. ");
INSERT INTO amf_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ogonoar buudamoka ‘Inta Barjoyn qadhaa Kiristoosne’ hamayna eenabee buudamoka ‘Inta Barjokala qansayse eenna giyeane’ hamayna eenabe eensa iira dhaabha ke dhaabhe; kena dandimea ko hanna, Barjoyn kamayse edaana eenaam kenin dohon goyra keam dhaddhisota yer milkitbee yer tarsheabe waadadhayse dhaa ke dhee. ");
INSERT INTO amf_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ogona yedi mete yesaam gishee. Inta ko yerin wulam yena birayse giydine. ");
INSERT INTO amf_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","“Igina rooronaka, gaalen ogosa budonte, cecinte dahaana kantana wul shoa ke shoe; hayno thipa ko thipe; arpinoar shaakehe; wanconoar cecira wava ko weve. ");
INSERT INTO amf_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ogo wodanka inta Eedi Naas gebhon kantanbee gobshinbeka maatayse polonka inin nivenka iam haapa ke haape. ");
INSERT INTO amf_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Wodan ogoka isa gaananaam yittsayse, peensa gasara yedayse macchinka yekka peen wulsa iira inin kamaana eenaam pucchayda pucche. ");
INSERT INTO amf_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Hatton shaapinsa kamsinam dhesee: Ogonoar hattonsa antindar hacchanin utayse caagenka, ogo wodanka bargin wodanin yeskonam dheseeda dhese. ");
INSERT INTO amf_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ogodettsi yedi igina yerraam yenin shedenka, i Eedi Naasisa nivan wodano theedayse ooninte ardota kerinte konin dohonam dhesimate. ");
INSERT INTO amf_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Inta yena gon ida giye: Ogo wul yin maatenka yekka wodan koka dohoono adhadhino diyate maqehe. ");
INSERT INTO amf_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Cecinbee peenbe saga ko sage; inin giyoono upsino sagehe. ");
INSERT INTO amf_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Rooron ogobee savaatin ogobeam Barjo Imbakalanka ab dhesea eedi hay ki hannaar qolehe; cecinte dahaana Barjosa gaanana ke hannaar, Naasa kintea ki hannaar, dhesehe. ");
INSERT INTO amf_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Wodano haa ko hannaar yenin dhesimonna, qaymayse toolee! ");
INSERT INTO amf_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ogonoar oonin yinnonam garayse goyn utaate yivaa eadettsine. Kidiar kalaa kalaa waadiman eenaam waana waana waadimabee hayamobedar ki wodade; kerin tooleanaar qaymayse kinin tooloadettsi kina ki elqimade. ");
INSERT INTO amf_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ogonante oonin imba ta keeda shaakinan ko hannaar, way sootin kiaddha laman, way baachan qiiqenka way burburi ko hannaar, haa kinin nivenam yenin dhesimonna, qaymayse toolee. ");
INSERT INTO amf_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ye dhesima nivayse yenin raatonte ki yeam haapabhoode. ");
INSERT INTO amf_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","“Yena inin giyenam een wulna ida giye: Qaymayse toolimate!” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ayiwd eenasa Paasikanbee irshonin qolmon balashan gaadhea bavallabeyn gobshadhanna yeskota rooro lamaayn shidhenka, gudullasa hayonabee Musesa yigginam dhettsayna eenabe Yesusam cubboka hamin hayayse yedate kiam kenin deesensa goyti zagite ke dahade. ");
INSERT INTO amf_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“Eeno goore konin dhaasoamadettsi, Paasikan gobshadhea wodanka ko dahabhoode” hamayse kinka ke dhalqade. ");
INSERT INTO amf_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesus Bitaania gurdante lamthin burqonka ena dahaa Simoon ooninte kummadar dooqayse ki dahade. Maa kalloar koymo gebhika shandhen naardoosira bish ashkadhon gaamen shittonam seeni cawlira ashkadhon bilqaathinka bavate Yesuskal nivayse, bilqaathasa aponam deesate bulayse gaamen shittonam Yesussa metendar ko kahade. ");
INSERT INTO amf_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Raqin ogote dohoono waani waani eenoar wacimaate, “Ko gaamen shittonam harrna ko sun yiigadhe? ");
INSERT INTO amf_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ko gaamen shittonam mato makkamdara sagi birredar shanshayse koymo ogoam qambhinana imano koda damadhika!” hamayse kinka gundumite edonam ke bagade. ");
INSERT INTO amf_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yesus kena “Koam harrnee galshe? Garee! Kodi ina yer payya ko hayade. ");
INSERT INTO amf_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Qambhina rooro wul yembesana kenin dehenna yenin nashon wodanka kena yer payya hayana dameeda dame. Inta rooro wul yembesana dahattine. ");
INSERT INTO amf_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kodi yina dandimonam ko hayade; waan isa duukadhima birayse iam ashkota shittonka ko qadhade. ");
INSERT INTO amf_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Inta yena gon ida giye: Edon koyn hayonam konin bhocchadhoadettsi, peen wul gidir Barjosa dhacchintan upsinam giidhen raqin hamote ko hannaar, kosa waadimanam giidha ko giidhe” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tabhi lamaana Yesussa paanan yivayna eenasa kalaa Asqoronto peen ea Yiwda Yesusam yettsate imota gudullasa hayonadar ki yivade. ");
INSERT INTO amf_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kediar ogoam kenin qansen wodanka wozadhayse, “Koymo hana woda ime” hamayse kimbesana kinka ke dhalqade. Yiwdaar kiam yettsate kena kinin imen goynsa kina agea woda zagite ki dahade. ");
INSERT INTO amf_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Paasikan yaaton machadhen, irshon qolmon balashan itsadhensa biraa rooroaka, Yesussa paanan yivayna eena “Paasikan galanam hamote yivayse wonin ashkoadettsia zage?” hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesus yisa paanan yivayna eenasa lamaanana yin giyayse keam ki yittsade: “Katamandar yivee. Ogotear daaka noqo kedaa eedi kalaam yeda haape; ea agaasaar paanan yivimate. ");
INSERT INTO amf_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Kinin arden oonindar yivayse ooninsa imbaam ‘Woam Dhettsea “Isa paanan yivayna eenabete Paasikan galanam wonin itsayno ranqo hamotene?” hanka ki hamade’ kina hamee. ");
INSERT INTO amf_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kidiar ooninsa zulonte woysadhon, pir kosa iinaam payya apayse ashkadhon workin ooninam yena kida dhee; ogote wona ashkee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kediar utaate katamandar yivayse Yesusin kena giyondettsi ke haapade; Paasikan galanamaar ogote ke ashkade. ");
INSERT INTO amf_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Peenin sootonsa budonte, Yesus tabhi lamaana yisa paanan yivayna eenabesana kinka ki nivade. ");
INSERT INTO amf_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Dooqaysear kenin kummenka Yesus kena “Inta yena gon ida giye: Yesa shaarira kalaa imbesana kinka kummea, kidi iam yettsate ima ki ime” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kediar ogo yin kinin giyon goynka iinka burqadhaate kedi kalaa kalaana “Inta i doo?”, “Inta i doo?” hante kiam oysan ke yedade. ");
INSERT INTO amf_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kidiar kena yi giyna: “Ye tabhi lamaanasa iira, kalaa imbesana kinka sharqante aanin arseane. ");
INSERT INTO amf_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Inta Eedi Naas ena birayse innon goynsa thaapadhondettsi diyayda diye. Ko dahaannaar i Eedi Naasiam yettsate imea ea agaana hay! Ea agaa ki adhadhaamma kina payyane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Galanam kenin itsenka, Yesus balashanam tiyayse Barjoam ki gobshade; qunthayse yisa paanan yivayna eenana “Kay, kono isa waanone” hamayse kena ki imade. ");
INSERT INTO amf_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wucadhenamaar tiyate Barjoam gobshayse, kena ki imade; kedi wulaar ogoam ke wucade. ");
INSERT INTO amf_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kidiar kena yin ki giyade: “Kono isa thoothin eenna laymayno mallan eshkayno zombhinone. ");
INSERT INTO amf_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Inta yena gon ida giye: Barjosa bitamonte woynea hattasa aapin cuubadhon haalin wucadhenam inin wucenka yekka, keeda kaara os inta koam wucattine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ogosa budonte, mazmur yinin zammaronsa budonte Dabirezayt dhukanam ke utade. ");
INSERT INTO amf_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesus yisa paanan yivayna eenana yin ki giyade: “Barjo ‘Yaana gisheam qanate deesayda deese; gishadhayna yaanaar thar thar hama ke hame’ hamayse thaapadhondettsi, yedi wul iam gareeda gare. ");
INSERT INTO amf_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ko dahaannaar diira inin dhaabhonsa budonte, Galila peendar yeam birayse ida yive” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Bhethiroosaar “Eeno waani wul haam garea ko hannaar, inta haam garattine” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesus maasayse “Inta hana gon ida giye: Kina sootin koam baacha biraa lamaa goyt qiiqima ‘Inta kiam dhesattine’ hamayse makkam goyt marimaada marime” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Bhethiroosaar dhalqam wocchi hayayse “Dembhi ko hannaar, hambete diyayda diye; hamin ko dahaakaar ‘Inta kiam dhesattine’ hamayse marimattine” kina ki hamade. Eeno waani wulaar yin ko giyade. ");
INSERT INTO amf_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ogora Getesemaane hambhen raqindar ke yivade. Ogotear Yesus yisa paanan yivayna eenana “Barjoam inin miskenka yedi kote dooqee” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Bhethiroosbee, Yayqoobbee, Wannisbeam yinka entsate yivayse Yesus targadhite gaalan ki yedade. ");
INSERT INTO amf_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kenaar yin ki giyade: “Qaabono idar thoothayse iam deesamba koda haye; ogona yedi kote dooqayse wocchimbhayse toolee” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kekala likka pegadhayse peendar kumpurdhayse, dandimea ko hanna, kaa wodaka maatota dohoono yerro kidara konin sagoadettsi Barjoam ki miskade: ");
INSERT INTO amf_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Imbo, yer wul hana dandima ko dandime. Ko gaalen wucimanam inin wucoamadettsi ikalanka pegisima! Ko dahaannaar hanin nashaadettsi ko dee; inin nashaadettsi ko dahabhoode” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ogosa budonte maatate kinin nivenka, raatayse ke daaka keam haapayse, Bhethiroosna yi giyna: “Simoon, ya raatidu? Savaat kala hattear wocchimbhayse toolano haam bashidu? ");
INSERT INTO amf_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Taysate yeam siyonsa iinte arsente yenin ardoamadettsi wocchimbhayse Barjoam miskee. Eedisa qaabe ashkimbhine; ko dahaannaar waano eedisa qajadhine” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tapir yivayse ini yinin miskon upsinka Barjoam ki miskade. ");
INSERT INTO amf_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pir yisa paanan yivayna eenakal kinin nivenka, gindhe keam bashonna raatayse kenin dohonte keam ki haapade. Kediar kina kenin giyenam dhesadehe. ");
INSERT INTO amf_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Makkanso goyt kekal nivayse kena yin ki giyade: “Taar yedi raatidu? Tapir lay ukunsee ukunso? Keeda yena yeekidine, wodanoar yeskidine. Marrato! I Eedi Naaseam seeson eenasa aaninte yettsate iam koda imbhe. ");
INSERT INTO amf_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Keeda dhaabhee! Wo yive; iam yettsate imea kash, theedidine” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesus ogoam akar giyte ki daaka, marrato! Tabhi lamaana kisa paanan yivayna eenasa kalaa Yiwda saana ki nivade; kimbesana kinka halpabee haljobe bovoono thoothino eeno gudullasa hayonabee, Musesa yigginam dhettsayna eenabee, donzanabekalanka nittsadhaysaka ko nivade. ");
INSERT INTO amf_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yesusam yettsate imea Yiwda eenana birayse “Inin sunqea kidine; kiam yedate payya toolayse bavate yivee” hamayse milkit kena imidine. ");
INSERT INTO amf_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kidiar saanawa kalan nivayse hatte, “Dhettsea” hamayse kiam ki sunqade. ");
INSERT INTO amf_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Eenaar ogosa budobar kiam ke yedade. ");
INSERT INTO amf_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Theedin kikal woyayse dahaana eenasa eedi kalaa halpanam yisa gochayse gudullasa gebhaasa waadiman ea qaaminam taxate ki dhabade. ");
INSERT INTO amf_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesusaar “Eedisa koymo buurate itsea eedidettsi hayayse iam yedana halpabee haljobe bavatee nivaaw? ");
INSERT INTO amf_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Rooro wul Barjosa gazan ooninsa mayante eenaam dhettsada yembesana kinka inin dehenka iam yedeetene; ko dahaannaar Mathaap Gazante thaapadhoono konin thoothoadettsi ko yin maatade” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kisa paanan yivayna eena wulaar kiam garayse gobate ke yivade. ");
INSERT INTO amf_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Lathana bish qaadhaa naasi barsh kalaa kisa paanan nivite ki dahade; eenaar kiam ke yedade. ");
INSERT INTO amf_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Kidiar lathanaam kedar garayse pundiri gobate ki yivade. ");
INSERT INTO amf_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yesusamaar gudullasa gebhaakal entsate ke yivade. Ogotear gudullasa hayonabee, donzanabee, Musesa yigginam dhettsayna eenabe wul kinka bukayse ke dahade. ");
INSERT INTO amf_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Bhethiroosaar gudullasa gebhaa kerminsa iinte kinin yeskenka yekka, Yesussa paanan pegeka ki nivade; ogotear poolisanabete nuun kicardhite ki dooqade. ");
INSERT INTO amf_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Gudullasa hayonabee Yiwda peensa donzana wulbe Yesusam dembhi pirdina yeskisea tarja haapana ke zagade; ko dahaannaar haapadehe. ");
INSERT INTO amf_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ogonoar thoothino eeno buudamoka kidar tarjite ko dahade; ko dahaannaar eensa tarjamono kinka kidar upsi kalaa maatadehe. ");
INSERT INTO amf_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Eensa waani waaniar dhaabhayse, “‘Inta ko aaninka woysadhon Barjosa gazan ooninam kottsayse rooro makkamka ab aanka woysadhaamon ooni woysayda woyse’ kinin hamen wodi qansidine” hamayse buudamoka kidar ke tarjade. ");
INSERT INTO amf_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Yin giyayse kenin tarjenkaar kesa tarjamono kinka kidar upsi kalaa maatadehe. ");
INSERT INTO amf_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Gudullasa gebhaa kesa shaarira dhaabhayse, “Yer kala hattear malsi maasattanu? Eena kina hadar kenin tarjayno kono yer hare?” hamayse Yesusam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kidi lay hamayse yer kala hattear maasadehe. Pir gudullasa gebhaa “Gobshadhaa Barjoyn qadhaa kisa Naasa Kiristoos yaw?” hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesusaar “Intane; Eedi Naas kantanka dahaa Barjosa mizaqimbar dooqayse kinin dohonbee cecira polonka kinin nivenbeam haapeeda haape” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Gudullasa gebhaa dhagaka yisa apalanam hattsayse, “Keeda os tarja ab wona harrna ko zaske? ");
INSERT INTO amf_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yedi kisa iirimenam qansidine. Yena har ko maate?” ki hamade. Kedi wulaar “Dembhi ko kiam zaske” hamayse ke kidar pirdade. ");
INSERT INTO amf_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Waani waani eenoar kidar pathimaate, aapinamaar kisa ochayse kiam gutaate, “Hamota dohon yerinam wona giyaa” kina ke hamade. Poolisanaar kiam cavada entsate ke yivade. ");
INSERT INTO amf_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Bhethiroosaar gudullasa gebhaa mayan kerminsa iinte choobar ki daaka, gudullasa gebhaa ooninte waadadhayna maanasa maa kallo nivayse, ");
INSERT INTO amf_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","nuun kinin kicardhenka kiam haapayse shirshate shedayse, “Ya pir Naazretra nivaa Yesusbete dahaane” kina ko hamade. ");
INSERT INTO amf_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kidiar “Hanin giyayno yer har konin dohon dhesattine; inaar bhoqehe” hamayse ki marimade. Ogora mayanka ki utade. Baacha ki qiiqade. ");
INSERT INTO amf_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Waadiman edonoar kiam shedayse ogote woyaana eenana “Ea kaar kembesana kinka ki dahade” hamayse lansi pir giyan ko yedade. ");
INSERT INTO amf_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kidi pir marimidine. Likka kap hamayse ogote woyayse dahaana eena tapir Bhethiroosna “Ya Galila eedi hanin dohonna, gon ya kembesana kinkaa dahade” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kidi “Yenin giyea eam inta dhesattine!” hamayse yiam ashite malliman ki yedade. ");
INSERT INTO amf_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Saanawaar baacha lanso goyt ki qiiqade. Bhethiroosaar “Baacha lamaa goyt qiiqima makkam goyt ‘Inta kiam dhesattine’ hamayse iam marimaada marime” hamayse Yesusin kina giyoono kalan bhoq ko hamaysaka ki eepade. ");
INSERT INTO amf_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Burin peen sedhaysaka saanawaar gudullasa hayona Musesa yigginam dhettsayna eenabee, Ayiwd peensa donzana wulbe kinka kenin dhalqonsa budonte, Yesusam yedate dhaxayse bavate kiam Bhilathoosna ke imade. ");
INSERT INTO amf_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Bhilathoosaar “Ayiwd eenasa bitaa yaw?” hamayse kiam ki oysade. Kidiar “Inta hanin giyaadettsine” hamayse kina ki maasade. ");
INSERT INTO amf_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Gudullasa hayona yer thoothi goytika kiam ke bersade. ");
INSERT INTO amf_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Bhilathoos pir “Ya yer kala hattear giyattanu? Kedi yer meemay goytika haam kenin bersenam shedaa” hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesus Bhilathoosin targadhenka yekka yer kala hattear kina maasadehe. ");
INSERT INTO amf_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bhilathoos levenka levenka Ayiwd eensa Paasikan wodanka, eedi kalaa dhaxira kena kinin buloadettsi eenin oysaa eam kida bule. ");
INSERT INTO amf_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ogo wodanka wobamo waadimaka peendar banqi dhaasintaka eedi deesayse dhaxin ooninte dhaxadhaana eenasa eedi kalaa Barbaan hambhea dahade. ");
INSERT INTO amf_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Eenoar bukayse Bhilathoos yisa dambindettsi kena ki haye kiam miskan ko yedade. ");
INSERT INTO amf_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bhilathoosaar “Ayiwd eensa bitaam yena dhaxira inin buloadettsi yedi nashee nasho?” hamayse keam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Yin giyayse keam kinin oysoono gudullasa hayona Yesusam sun woogintaka kenin yettsate imonam kinin dhesennane. ");
INSERT INTO amf_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Gudullasa hayona “Kintea ooloate Barbaan ki dhaxira wona buldhe” hamayse zarsinin miskoadettsi zarsinam ke sobarsade. ");
INSERT INTO amf_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Bhilathoos pir maasayse “Ta keeda ‘Ayiwd eenasa bitaane’ yenin hamea eam hamin i hayo?” hamayse keam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kediar tapir maasayse “Kiam ziitayse deesima!” hante ke ilatade. ");
INSERT INTO amf_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kidiar “Hare? Har ki seesaa?” kena ki hamade. Kediar “Kiam ziitayse deesima!” hamayse ini hamora sagi ilatite ke waajade. ");
INSERT INTO amf_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Bhilathoosaar zarsinam wozisota hamayse Barbaanam kena ki bulade; Yesusam qansayse kinin ziitadhoadettsi saskate ki imade. ");
INSERT INTO amf_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Poolisanaar peen wottsea easa kermin Piraytoriyon hambhente kiam entsate ke ardade; ogotear shidhaana poolisana wulam eelate ke buskade. ");
INSERT INTO amf_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Apala zoo kiam ke qattsade; ukumbha qorayse kisa metendar ke wodade. ");
INSERT INTO amf_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","“Ayiwd eenasa bitaa, payyamo hana ko dee” hamaate bagada kiam gobshan ke yedade; ");
INSERT INTO amf_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","kisa metentear haljoka qanada kidarar ke pathimade. Pir kumpurdhayse goodimayna maatayse kiam keda bage. ");
INSERT INTO amf_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kiam kenin bagonsa budonte, apalan zoonam kidara bulayse kinnon apalanam tapir kidar ke qattsade; kiamaar masqalindar konngayse ziitate deesana entsate ke yivade. ");
INSERT INTO amf_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kenin yivenka, Iskindirosbee Rupoosbesa imbaa Qerena peen ea Simoon hambhea gurdara katamandar kinin nivenka, Yesusam ziitadhen masqalinam kantaka kiam ke kettsade. ");
INSERT INTO amf_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ogora Golgotta hambhen raqindar kiam entsate ke yivade; “Golgotta” hamintano “Eedisa Metedettsi Maataa Raq” hamintane. ");
INSERT INTO amf_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ogote kenin yeskon wodanka kerbe hambhea dheeshaam woynea hattasa aapira cuubate ashkadhon wucadhensa iinte worsayse kinin wucoadettsi kina ke imade; kidiar wucadehe. ");
INSERT INTO amf_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Masqalindar kiam konngayse ke ziitade; kisa apalanamaar hayna hayna ko yeskeatto hamayse itha daran dhabayse ke kashimade. ");
INSERT INTO amf_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kiam masqalindar kenin ziitenka burin savaat makkamne. ");
INSERT INTO amf_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kidar pirdadhon dhettsayno thaapino yin giyaynone: “Ayiwd eenasa bitaane” hamayno thaapine. ");
INSERT INTO amf_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Pir eedi lamaa eedisa koymo sarite itsaynasa, kalaam kisa mizaqimbar, lansoam kisa warkatambar konngayse ke ziitade. ");
INSERT INTO amf_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mathaap Gazantear, “Seeson eenbete kiam ko paydadhade” hamayse giidhoono dhalqino ko thoothade. ");
INSERT INTO amf_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ogoka sagate yivayna eenaar Yesusam iiraate metenka yisa jugimaate “Eyv! Ya ‘Barjosa gazan ooninam kottsayse rooro makkamka pir ida woyse’ hamea, ");
INSERT INTO amf_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","masqalindara hanchayse ta haam dhacchaa!” hamaate kiam ke bagade. ");
INSERT INTO amf_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ogodettsi pir gudullasa hayonabee Musesa yigginam dhettsaynabe kinka kikal yin giyada kiam ke bagade: “Een waaniam dhacchayse yiam dhacchana damadehe. ");
INSERT INTO amf_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kidi Barjoyn qadhaa Kiristoos, Israveel eensa bitaa ki hanna, yinda ta ko kiam ziitadhon masqalindara ki hanche; wodiar shedayse kidar woylamin qajooda qaje” ke hamade. Kimbesana kinka ziitadhaana eenaar kiam ke iirade. ");
INSERT INTO amf_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Rooron savaat laxra yedayse savaat salin thoothenka yekka peen wuldar thipa ko maatade. ");
INSERT INTO amf_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Savaat salka Yesus “Elohe, Elohe! Lama sabaqtani?” hamayse upsin yisaam kattsi dheg hayayse ki ilatade. Kosa bulinoar “Isa Barjoa, isa Barjoa! Harrnaa iam garaa?” hamintane. ");
INSERT INTO amf_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ogotear woyon eensa waani eeno Yesusin giyenam qansayse, “Marrato, Eeliasam kida eele” ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kesa iira kalaa gobayse woyni thorkaasa iir saaro tittsate bavayse ki wuce malkaka Yesussa apondar wodayse, “Yinda Eelias nivayse kiam kinin dhacchenam wo shede” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesusaar upsin yisa dheg hayayse ilatayse ki diyade. ");
INSERT INTO amf_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Barjosa gazan ooninsa gidin kashadhoono apallo bhaara choo nukindar kiaddha raq lamaadar ko havade. ");
INSERT INTO amf_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ogotear kisa birante woyaa mato alaqa Yesus hamin kinin diyonam yinin haapon wodanka, “Gon ea kaa Barjo Naasine” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Pegeka woyayse shedayna maa waani raqin ogote ke dahade. Kediar Galila peente kinin dohonka kisa paanan yivaynabee kina waadadhayna Megdela peen edon Mayriyambee, Ilpoos naasa Yayqoobbee Yoosabesa indan Mayriyambee, Seelomebe kembesana kinka ke dahade; kimbesana kinka Yerusaalemdar utaana thoothi maa waani ke dahade. ");
INSERT INTO amf_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Peen sootaysaka, ashkimbhen rooron maqayse ukunsen roorondar ardota konin hayenka, ");
INSERT INTO amf_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ayiwd peen donzanasa gobshadhaa, Armatias kataman ea Yoseep ki nivade. Kidiar Barjosa bitamonam wozaka toolite ki dahade. Kurtumbhima Bhilathooskal yivayse Yesussa leesinam kina kinin imoadettsi ki miskade. ");
INSERT INTO amf_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bhilathoosaar “Saanawa hamin ki diyaa?” hamayse ki targadhade. Mato alaqaamaar eelayse, “Gon diyayse kappidu?” hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mato alaqakal qansayse Yesussa leesinam Yoseepna ki imade. ");
INSERT INTO amf_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yoseepaar apala shanayse leesinam masqalindara hanchayse apalanka ki ochade. Ogoraar seeni layta palsayse ashkadhon duukin oolonte kiam ki duukade; seeni gaari gunngate duukinsa aponam ki shupade. ");
INSERT INTO amf_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Megdela peen edon Mayriyambee Yoosa indan Mayriyambe hamote kiam kenin wodenam shedite ke dahade. ");
INSERT INTO amf_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ayiwd eensa ukunsen rooroayn maqonsa budonte, Megdela peen edon Mayriyambee, Yayqoobsa indan Mayriyambee, Seelomebe kinka yivayse Yesussa leesinam qadhota shitto gaamea ke shanade. ");
INSERT INTO amf_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Wuudi burin haynin utenka duukindar ke yivade. ");
INSERT INTO amf_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kediar kinka kikal “Duukin oolonsa apon shupadhon seeninam wona hayne gunngate maroa?” ke hamade. ");
INSERT INTO amf_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Senno kattsi gaari konin dohonna, dheg hamayse kenin shedenka duukinsa apora gunngumayse konin dohonam ke haapade. ");
INSERT INTO amf_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Duukin oolonsa iinte ardayse apala cawli qaadhaa naasi barsh kalaa mizaqimbar dooqayse ki daaka, kiam haapayse ke targadhade. ");
INSERT INTO amf_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kidi kena “Targadheebhode! Yedi masqalindar konngate ziitayse deesadhaa Naazret peen Yesusam yeda zage. Kidi dhaabhidine; kote qolehe. Leesinam wodadhoono ranqo koshee, shedee. ");
INSERT INTO amf_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ko dahaannaar yedi yivayse kisa paanan yivaynabee Bhethiroosbena ‘Kidi yeam birayse Galila peendar kida yive; yena kinin giyondettsi yedi kiam ogote yeda haape’ hamayse kena giyee” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ogora igina maana gibattsite keam yer tarshan konin yedonna utaate duukin raqira ke gobade; kattsiar kenin kurtumbhonna yer kala hattear eedina giyadehe. ");
INSERT INTO amf_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Gabansa biraa rooroaka Yesus burburi seddhiman dembhira yinin dhaabhonsa budonte, birayse tobbhaana beeronaam kinindara bulon Megdela peen edon Mayriyamna ki haapadhade. ");
INSERT INTO amf_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kodi yivayse kisa paanan yivayna eena bukayse qaabitebee eepitebe kenin dohonte, ogo yin maaton yerinam kena ko giyade. ");
INSERT INTO amf_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kediar sadaka dahayse kona kinin haapadhonam kenin qansenka, gonne hamadehe. ");
INSERT INTO amf_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ogosa budontear, kisa paanan yivayna eenasa lamaana katamara utaate os gurdandar kenin yivenka, Yesus goynte kedar eedi abdettsi maatayse kena ki haapadhade. ");
INSERT INTO amf_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kediar yivayse waani eenana ke giyade; igina eenaar pir gonne hamadehe. ");
INSERT INTO amf_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ogosa budontear, kummandar dooqayse ke daaka tabhi kalaana yisa paanan yivayna eenana ki haapadhade. Dembhiraar kinin dhaabhonsa budonte, kiam haapaana eena “Wodi kiam haapidine” hamayse kena kenin giyenka, gonne hamayse kenin tiyaamon goynbee kesa qaaben kaymakkon goynbeka keam ki wacimade. ");
INSERT INTO amf_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kenaar yin ki giyade: “Peen wulsa iinte yivayse Barjosa dhacchintan upsinam een wulna giymate. ");
INSERT INTO amf_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Barjosa dhacchintan upsinam gonne hamayse tiyaabee shiidhaabe dhaqa ki dhaqe; tiyaamadar pirda ko pirdadhe. ");
INSERT INTO amf_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Barjosa dhacchintan upsinam tiyaanana imbhayna milkitina kinane: Naaben innonka beeronaam bula ke bule, apo haalikaar dhalqa ke dhalqe. ");
INSERT INTO amf_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Guninam aaninka yeda ke yede; een deesen davininam ke wucaakaar yer keam hayehe. Hajadhaana eenadar aaninam yisa keda wode; kediar paasha ke paashe” ki hamade. ");
INSERT INTO amf_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Imbaa wontea Yesusaar ogoam kena yinin giyonsa budonte, Barjo cecindar kiam ki tiyade; ogora Barjosa mizaqimbar ki dooqade. ");
INSERT INTO amf_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kisa paanan yivayna raqin wulir yivayse Barjosa upsinam ke giyade; Imbaa Yesusaar kembesana kinka waadadhite ki dahade; kenin giyenka, kidi yisa upsinsa gonamonam tarshen waadimanka kida wocchise. ");
INSERT INTO amf_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Gobshadhaa Toploos, birara yedayse yisa aapinka shedayse tarja maataana, Barjosa dhacchintan upsinkaar waadadhayna eena wona kenin saskaadettsi wonnon shaarinte maaton yerinam thoothina eena ashkayse thaapidine. ");
INSERT INTO amf_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Inta taar ogodettsi birara yedayse payya hayayse bhocchayse inin dhesonna, hanin dheson timmirinam ha tipise guttsi guttsi hana thaapana payya maatayse ina ko haapadhade. ");
INSERT INTO amf_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodis Yiwda peente kinin bitimon levenka, Abiya muldhara gudula Zakkarias hambhea dahade. Kisa geshonoar gudula Aaron muldhara dohoono Elsaabeth hambhaynone. ");
INSERT INTO amf_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kedi lamaanaar Barjo yinin giyonbee kisa yigginbeka yer siya yindar haapadhimina maatayse Barjo birante tipa ke dahade. ");
INSERT INTO amf_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elsaabethaar seeki konin dohonna, kesa naasi qolehe; pir kedi lamaanaar kattsi gecchidine. ");
INSERT INTO amf_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Zakkariasaar yisa muldhanabesana Barjosa gazan ooninte kinin waadadhayno wodan yeskonna Barjosa birante kinin waadadhenka, ");
INSERT INTO amf_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Barjosa gazan ooninte ardayse qunyan ki cubshe gudulmakkon goynka kidar itha ko yeskade. ");
INSERT INTO amf_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Barjosa gazan ooninte qunyan cubshadhenka eeno wul mayante woyayse Barjoam koda miske. ");
INSERT INTO amf_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Barjosa gaanaa qunyan daran cubshate imbhen raqinsa mizaqimbar woyayse ki daaka, Zakkariasna ki haapadhade. ");
INSERT INTO amf_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakkariasaar kiam yinin haapenka, targadhayse kattsi ki kurtumbhade. ");
INSERT INTO amf_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Barjosa gaanaa kina yin ki giyade: “Zakkariaso, kurtumbhaabhode! Barjo hasa miskenam qansidine; geshono hasa Elsaabeth naasi anngi adha ko adhe; kisa naabenamaar Wannis hamayse hada wode. ");
INSERT INTO amf_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kinin adhadhonna hana kattsi woza koda dee; thoothino eenoar kisa adhadhinka koda wozadhe. ");
INSERT INTO amf_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Harrna hambhidianna, Barjosa birante eedi gebhi kida maate. Woynea hattasa aapin cuubadhonbee waani een barsen wucadhenbeam wucehe; ki adhadhima indansa iinte ki daaka, Manpas Gazanka kida thoothe. ");
INSERT INTO amf_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kidi Israveel eensa thoothin eenaam Imbaa kesa Barjodar keam kida maase. ");
INSERT INTO amf_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kidi Barjoyn nivensa birayse manpasinbee kantanbeka Eeliasdettsi maatayse Wannis eendar kida nive. Imbanasa woylaminam naanadar kida maase; ee hamimina eenasa woylaminam tipana eenasa pakalmakkondar kida maase. Ogoka eeno Barjona ashkimbhoono konin doadettsi koam kida haye” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakkariasaar Barjosa gaanaana “Inta gecchidine, isa geshonoar gecchidine. Keeda ogono gon konin maatenam hamin ida dhese?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Barjosa gaanaar kina yinin maasenka, “Inta Barjosa birante woyea Gabreelne. Ogo wozisen dhalqinam hana inin giyoadettsi Barjo iam kinin nittsonna hakal i nivade. ");
INSERT INTO amf_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yaar wodan yeskenka maaten isa dhalqinam hanin tiyaamonna, ogo inin giyon wul konin maatea rooroaka yekka apo kaya hada maate; dhalqana damattane. Inin giyoono wul thootha ko thoothe” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Eenoar Zakkariasam kaalite ko dahade. Barjosa gazan ooninte kinin kapponna, “Hamin ki hamaa?” hamayse ke bhocchade. ");
INSERT INTO amf_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zakkarias Barjosa gazan oonira yinin utenka eenna giyana damadehe. Ogonante Barjosa gazan ooninte Barjokala yer kinin haaponam kedi dhesidine; kidiar milkitka kena eshkaate apo kaya maatayse ki shidhade. ");
INSERT INTO amf_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Barjosa gazan ooninte kinin waadadhen wodan maqaysaka, yisa oonindar ki yivade. ");
INSERT INTO amf_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ogosa budonte kisa geshono Elsaabeth sirmayse arpi dongna ooninte aadhimbhayse ko dooqade. ");
INSERT INTO amf_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Kodiar “Barjo yisa nashimmakkonka iam kinin shedaa wodaka ogodettsin yerin payyan ina ki hayade; eensa shaarinte idar dohon ooshimbhenam ki shiishade” ko hamade. ");
INSERT INTO amf_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elsaabeth konin sirmonsa laskoa arpeaka Barjo yisa gaanaa Gabreelam Galila peen Naazret hambhen katamandar, ");
INSERT INTO amf_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Dawtsa muldhara Yoseep hambhea yinin seeson anngika wodhaamon naandar kiam ki yittsade. Naan ogosa naabeno Mayriyam koda hambhe. ");
INSERT INTO amf_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Barjosa gaanaar kokal nivayse, “Ya Barjosa nashadhoono, payyamo hana ko dee; Barjo hambetene. Ya maanasa shaarinte gobshadhoonone” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kodiar kisa dhalqinka kattsi targadhayse, “Kono hamin dohoono nagaymakkone?” hamayse ko qaabade. ");
INSERT INTO amf_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ogora Barjosa gaanaar kona yin ki giyade: “Mayriyam, Barjosa birante gobshi hanin haaponna kurtumbhaabhode. ");
INSERT INTO amf_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Shedaa! Ya sirmaada sirme; naasi anngiar adhaada adhe; kisa naabenamaar Yesus hamayse hada wode. ");
INSERT INTO amf_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kidi eedi gebhi kida maate; kanka Wuldara Sagea Barjo Naasine koda hambhe. Imbaa Barjo kisa imbaa Dawtsa bitamon borkotonam kina kida ime. ");
INSERT INTO amf_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Yayqoobsa muldhandar rooro wulna lay kida bitime; kisa bitamonsaar macchi qolehe” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mayriyamaar Barjosa gaanaana “Inta anngika wodhayse inin dhesaamonna, ogono hamin ko yin dee?” kina ko hamade. ");
INSERT INTO amf_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kidiar kona yin ki giyade: “Manpas Gazano hadar niva ko nive; Wuldara Sagea Barjosa kantano hadar koda shipe. Ogonante hanin adhea gazaa naasa Barjo Naasine kida hambhe. ");
INSERT INTO amf_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Shedaa! Hasa muldhano Elsaabethaar ta yisa gecchamondar naasi anngi kodi sirmidine; seekine hambhayno ko sirmaysaka kono kosa arpi laskone. ");
INSERT INTO amf_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Harrna hambhidianna, Barjoam bashea yer qolehe” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mayriyamaar, “Barjosa waadiman edono intane. Hanin giyondettsi ina ko dee” kina ko hamade. Barjosa gaanaar kokalanka edimayse ki yivade. ");
INSERT INTO amf_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ogo wodanka Mayriyam dhaabhayse Yiwda peente dhukanka dohon katama kallondar saana yivayse, ");
INSERT INTO amf_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zakkariassa ooninte ardayse Elsaabethaam ko nagaysade. ");
INSERT INTO amf_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elsaabethaar Mayriyamin nagaysenam konin qansenka, iinte kosa dahaa naasa kattsi ki ruqumade; Elsaabethaar Manpas Gazanka ko thoothade. ");
INSERT INTO amf_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Kodiar upsi gebhika yin ko giyade: “Ya mansen naana wulra gobshadhoonone; hanin adhea naasaar gobshadhaane. ");
INSERT INTO amf_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Barjoyn qaadhaa Imbaam adhayno ikal hanin nivayno hamin dohoono ina gobshine. ");
INSERT INTO amf_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Shedaa! Hanin nagaysenam qansite i daaka, isa iinte dahaa naasa wozaka ki ruqumade. ");
INSERT INTO amf_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Barjo Imbayn hana giyon wulam maata ko maate hamayse hanin tiyonna, ya gobshadhoonone!” kona ko hamade. ");
INSERT INTO amf_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mayriyam yin ko giyade: “Isa sadano Barjo Imbaam koda gobshe; ");
INSERT INTO amf_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","isa woylammoar iam Dhacchea Barjoka koda wozadhe. ");
INSERT INTO amf_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Inin wozadhayno Barjo i ko tokaa maaton yisa waadiman edonam kinin haaponnane. Kinara yedayse adhadhino wul gobshadhoono iam koda hame. ");
INSERT INTO amf_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ogonoar kantanka dahaa Barjo ina yer gebhi kinin hayonnane; naabenoar kisa gazane. ");
INSERT INTO amf_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Barjoam kurtumbhen eenna adhadhira adhadhinka yekka, Barjo kena burqadhayse yer payya kida haye. ");
INSERT INTO amf_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kidi yisa kantanka gebhi waadima haydine. Yisa bhocchinka poorimbhaynaam kidi kekalanka thar thar haydine. ");
INSERT INTO amf_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Peen wottsaynaam kesa bitamora keam hanchidine; yirk hamaynaam gobshika keam dheg haydine. ");
INSERT INTO amf_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Daaqardhaanaam yer payyaka kidi micchidine; wodimma eenaam aan guuri keam ki yittsade. ");
INSERT INTO amf_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Barjo wosa eykena Abraambee kisa muldhanabena ‘Rooro wul lay yena burqadhayse yer payya ida haye’ hamayse kinin giyon wozanam bhocchintaka, kina waadadhayna Israveel eenaam kidi kelshidine” ko hamade. ");
INSERT INTO amf_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mayriyamaar Elsaabeth ooninte arpi makkamaddha dooqayse yisa oonindar maatate ko yivade. ");
INSERT INTO amf_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elsaabethaar adhiman arpin kosa yeskaysaka naasi anngi ko adhade. ");
INSERT INTO amf_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kosa gurdan eenabee muldhanabe Barjo yisa nashimmakkonam kona thoosayse kinin hayonam qansayse kombesana kinka ke wozadhade. ");
INSERT INTO amf_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kediar lankaysoa rooroaka naasasa qaamanam taxana ke nivade; imbaasa naabenka Zakkarias hamayse kisa naabenam wodana ke qaabade. ");
INSERT INTO amf_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Indano “Yin dehehe; nammo kisa Wannisne” kena ko hamade. ");
INSERT INTO amf_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kediar “Hasa muldhante naabea agaaka eldhea hay ki hannaar qolehe” kona ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ogora imbaam “Hasa naasaam hay hamayse eldhoadettsi ha nashe?” hamayse milkitka kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakkariasaar milkitka yer thaapi thaapadhea oysayse, “Kisa nammo Wannisne” hamayse ki thaapade. Eeno wulaar targadhidine. ");
INSERT INTO amf_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ogo wodanka saanawa Zakkariassa apono ko bulimade; Barjoamaar gobshaate dhalqan ki yedade. ");
INSERT INTO amf_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Gurdante dohon een wulna kurtumbhe ko maatade. Ogono yerro wul Yiwda peen dhukanka dohon wul gidir ko giidhade. ");
INSERT INTO amf_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Qansaana wulaar, “Ta naasa kaa hamin hamea ki doo?” hamayse yisa woylaminte ke yedade; ogonoar Barjosa kantano kimbesana kinka konin dohonnane. ");
INSERT INTO amf_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Naasasa imbaa Zakkarias Manpas Gazanka thoothayse hamota dohonam yin giyan ki yedade: ");
INSERT INTO amf_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Israveel eenasa Barjo Imbaa wo kisa eedanakal nivayse wodar dohon bazanam kashayse woam kinin dhacchonna ki gobshadhe. ");
INSERT INTO amf_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yisa waadiman ea Dawtsa muldhara dhacchea kanta eam kidi dhaasidine; ");
INSERT INTO amf_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","enara yedayse Barjokala qansayse eenna giyayna gazana eenasa aponka kinin giyondettsi, ");
INSERT INTO amf_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","woam jibbaynabee wosa banqin eenabe wulsa aanira woam dhacchidine. ");
INSERT INTO amf_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ogoamaar yin kinin hayoono wosa eykenana burqadhayse yer payya hayotabee yinin giyon gazan yisa mallanam bhocchintakabene. ");
INSERT INTO amf_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ogo yisa mallanam eykea wosa Abraambesana kinin ardoono ");
INSERT INTO amf_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","woam jibbaynasa aanira dhaqayse wonin dehen rooron wulka kurtumbhe qolma Barjosa birante gazamobee tipamobeka kina wonin waadadhoadettsine. ");
INSERT INTO amf_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ta ya naasa kaa, Wuldara Sagea Barjokala qansayse eenna giyeane hada hambhe. Ogonoar kisa goynam ashkana Barjo Imbasa birante hada yive. ");
INSERT INTO amf_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ogona kesa seesono kena ko shidhe hambhenam Barjokalanka kenin haapen dhaqintasa timmirinam keam hada dhettse. ");
INSERT INTO amf_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ogono yin konin dohoono Barjo eedisa seesonam kinin garenbee kisa lemmakkonbekane. Ogonante dhaqintasa hay cecira wona utana koda haye. ");
INSERT INTO amf_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Thipante dahayse diyanna dohon een wulna kidi shaaka ki shaake; roonam wosa payyan goyndar kida entse” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Naasaar gebhidine. Woylaminkaar ki wocchimbhade. Israveel eenana yinin haapadhenka yekka, darante ki dooqade. ");
INSERT INTO amf_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ogo wodanka Roome peensa bita kinin bitimon peen wulir dohoono eeno wul naaben konin thaapadhoadettsi Bitaa Awgisthoos oosh ki ooshade. ");
INSERT INTO amf_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Qerenoos Sooria peenam kinin wottsen wodanka, naaben thaapadhayno ogono bironone. ");
INSERT INTO amf_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ogonante zarsino wul yisa eykena peendar naaben thaapsota ko yivade. ");
INSERT INTO amf_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Yoseep Dawt muldhara kinin dohonna, Galila peen Naazret katamara dhaabhayse Yiwda peen Betelem hambhen Dawtin adhadhon katamante kinin seeson naan sirmon Mayriyambete thaapadhota ki yivade. ");
INSERT INTO amf_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ogote ke daaka, kosa adhiman arpino ko yeskade. ");
INSERT INTO amf_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Yisa biraa naasaam ogote ko adhade. Shonnayn wodhen ooninte raq kena konin qolmonna, kiam apalanka ochayse wanngayn galan itsen gonngalante ko wottsade. ");
INSERT INTO amf_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Peen ogote katamansa gasante yisa yaatonam gishite wodhayna gishiman gishayna eena ke dahade. ");
INSERT INTO amf_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Iginakal Barjosa gaanaa ki haapadhade; Barjosa gobshin shaakanoar kesa gasante ko shaakade; ogona kedi kattsi ke kurtumbhade. ");
INSERT INTO amf_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Barjosa gaanaar yin ki giyade: “Hay! Kurtumbheebhode! Een wulna maatea kattsi wozisea upsi yena ida giye. ");
INSERT INTO amf_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ogonoar kina Dawtin adhadhon katamante Dhacchea, kidiar Imbaa Kiristoos yena ki adhadhade. ");
INSERT INTO amf_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Milkitino kisa yinne: Naasi apalaka ochayse wanngayn galan itsen gonngalante wottsadhaam haapeeda haape” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ke dhesima thoothina Barjo cecira kinin nittsaana gaanana agaa gaanaakal theedi haapadhayse, Barjoam gobshaate ");
INSERT INTO amf_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Cecinte Barjona gobshi ko dee; payyamonoar peendar Barjo nashimmakkonka kinin sheden eenna ko dee” ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Barjosa gaanana kekala edimayse cecindar kenin yivonsa budonte, kedi yaana gishayna eena kinka kikal “Betelem yivayse Barjoyn wona giyon ogo yerinam wo shede” ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Saanawa yivayse Mayriyambee, Yoseepbee, wanngayn galan itsen gonngalante wottsadhaa naasabeam ke haapade. ");
INSERT INTO amf_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Shedayse, naasa agaasa kena giidhon yerinam eenna ke giyade. ");
INSERT INTO amf_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ogoam qansaana eena wul yaana gishaynayn kena giyon yerinka ke targadhade. ");
INSERT INTO amf_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mayriyam ogo yerin wulam yisa woylaminka qaaban ko yedade. ");
INSERT INTO amf_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Yaana gishayna kena giidhondettsi, kenin qansonbee kenin haaponbe wulna Barjoam gobshada yisa raqindar maatayse ke yivade. ");
INSERT INTO amf_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Naasa adhadhaysaka kisa qaamanam taxana rooro lankay konin thoothonna, kisa indano sirmima Barjosa gaanaa kinin giyaadettsi, kisa naabenam Yesus hamayse ko wodadhade. ");
INSERT INTO amf_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Musesa yigginka gazimbhanna kenin waadadhen wodan yeskaysaka, naasaam Barjosa birante thettsana yinka bavate Yerusaalem ke yivade. ");
INSERT INTO amf_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ogoamaar kenin hayayno Barjosa yiggin mathaapinte “Birayse adhadhaa naasi anngi wul Barjona edimaa gaza eedi kida maate” hamayse thaapadhondettsine. ");
INSERT INTO amf_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ogodettsi Barjosa yigginka “Walee likka lamaa way walee gebhisa naasi lamaa Barjona marsha machadhea hayayse bava koda zaske” hamen upsinna ogoam imana ke yivade. ");
INSERT INTO amf_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ogo wodanka Yerusaalemir Simoon hambhea eedi kalaa ki dahade. Ea agaar Israveel eenaam dhacchayse wocchinseam toolaate dahaa eedi tipabee Barjoam gobshintaka wocchimbheabe ki dahade; Manpas Gazanoar kimbesana ko dahade. ");
INSERT INTO amf_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Barjoyn qadhaa Kiristoosam haapima dembhi kinin diiminam Manpas Gazano ena birayse kina giydine. ");
INSERT INTO amf_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ogo wodanka Manpas Gazano kiam konin dhaasonna, Barjosa gazan oonindar ki yivade. Muse yigginsa dambinam toolana, naasa Yesusam imbaabee indanbe yinka tiyayse Barjosa gazan ooninte ke ardade. ");
INSERT INTO amf_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ogo wodanka Simoon naasaam yidar tiyate incayse, Barjoam gobshada yin ki giyade: ");
INSERT INTO amf_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Imbo, ‘Hayayda haye’ ina hanin hamoono payyan upsino ko thoothade; ta keeda i hasa waadiman eam peen kora payyaka tiyaa. ");
INSERT INTO amf_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Ogonoar een wulsa birante hanin ashkon hasa dhacchintanam isa aapinka inta haapidine. ");
INSERT INTO amf_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kidiar Ayiwdtay hamma eenana goninam eshkea shaaka kida maate; hasa eedana Israveel eenanaar gobshine” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Imbaabee indanbe naasa Yesussa giidhon yerin wulka ke targadhade. ");
INSERT INTO amf_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simoonaar kena Barjo eelayse indan Mayriyamna yin ki giyade: “Shedaa! Kaa naasaka Israveel eensa thoothino kanka koda kaye; pir thoothino eeno kanka koda dhaqe; thoothino eenoar kiam kenin jibbensa milkit kena kinin maatoadettsi Barjo kiam kamidine. ");
INSERT INTO amf_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ogoam Barjo kinin hayoono thoothin eensa woylaminte aachimon qaabenam may hayanane; hasaar woylaminsa iinte qaabono halpadettsi koda uxe” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ogo wodanka Aseer zarsira Panuveel naano Hanna hambhayno Barjokala qansayse eenna giyayno ko dahade. Kodiar yisa geshoabesana kinka leve tobbhaa dooqayse, geshoa kokala diyaysaka kosa lendho eedi oydi kaysa apo oydi levenin maatenka yekka, yimal bish dahada kattsi gecchoonone. Itsima Barjoam miskada sootinbee rooronbe Barjona waadadhaate Barjosa gazan ooninsa mayara kodi edimehe. ");
INSERT INTO amf_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ogo wodanka nivayse Barjoam gobshaate Barjo Yerusaalemir eendar dohon bazanam kashayse keam kinin dhacchenam toolayna wulna naasa goynsa ko giyade. ");
INSERT INTO amf_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Barjosa yigginka giidhon wulam kenin macchonsa budonte, Yoseepbee Mayriyambe naasaam tiyayse Galila peensa kenin dohon Naazret katamandar ke maatade. ");
INSERT INTO amf_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Naasaar waanka gebhaate bhocchinkaar wocchimbhaate ki yivade; pakalmakkonkaar ki thoothade. Barjosa sunin imintono kimbesana kinka ko dahade. ");
INSERT INTO amf_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yesussa imbaabee indanbe leven levenka Paasika rooroa gobshadheaka Yerusaalemdar keda yive. ");
INSERT INTO amf_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesus leve tabhi lamaa naas ki daaka, ogo Paasikan rooroaka Ayiwd eenasa dambindettsi Yerusaalemdar ke yivade. ");
INSERT INTO amf_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Rooronaamaar yinin macchonsa budonte kenin maatenka, naasa Yesus Yerusaalemir shidhidine; imbaabee indanbe ogo kinin shidhonam dhesadehe. ");
INSERT INTO amf_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Eenbesana kinka yivite ki dahade hamada rooro kalaa goyti ke yivade; ogora yisa muldhanabee yinin dhesayna eenabekal kiam ke zagade. ");
INSERT INTO amf_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Yinin bashadhonsa budonte kiam zagaate Yerusaalemdar ke maatade. ");
INSERT INTO amf_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Rooro makkamsa budonte Barjosa yigginam dhettsaynasa shaarinte dooqayse kekalanka kinin qansenbee keamaar kinin oysenbeka Barjosa gazan ooninsa mayante ke haapade. ");
INSERT INTO amf_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kinin giyenam qansayna wul kisa qaabenbee kisa malsinbeka kattsi kedi targadhidine. ");
INSERT INTO amf_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Imbaabee indanbe kiam kenin haapenka, kedi targadhidine. Indano “Isa naasa, harrnaa yin wodar hayaa? Shedaa! Imbee hambabe kattsi gaalite haam wo zagade” kina ko hamade. ");
INSERT INTO amf_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kidiar kena yinin maasenka, “Harrnee iam zagaa? Inta Imbasa ooninte daa iam konin zaskenam yedi dheseete?” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kediar kena kinin giyon dhalqinam bhocchadehe. ");
INSERT INTO amf_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kembesana kinka dhaabhayse Naazretdar ki yivade; kenaar ee hamaate ki dahade. Kodi indanoar igina yerra wulam yisa woylaminte yedite ko dahade. ");
INSERT INTO amf_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesus pakalmakkonbee gebhintanbeka, shawkadhaa maatayse Barjobee eedibesa birante gebhaate ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Roome peen bitaa Thibaroos bitimaysaka tabhi dongsoa leveaka, Bhenthenaawi Bhilathoos Yiwda peenam wottsea ki dahade; Herodisaar Galila peenam wottsea ki dahade; iishima Pilbhoosaar Thurasbee Ithirakondoosbe peenam wottsea ki dahade; Lisaaniyosaar Abileene peenam wottsea ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Hannabee Qayappabe gudullasa gembha ke dahade. Ogo wodanka Zakkarias naasa Wannis darante ki daaka, Barjosa upsino kikal ko nivade. ");
INSERT INTO amf_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ogonante Wannis Yordaanoos baynsa gasante dohon peen wulir “Yesa seesonin shidhoadettsi, seeson waadimanam garayse Barjodar maatayse shiidhee” hamaate Barjosa upsinam giyada ki yaayade. ");
INSERT INTO amf_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","6","Ogonoar yin konin dohoono Barjokala qansayse eenna giyea Isiasin giyenka: “Marrato! ‘Barjoyn yekal nivenna, yesa woylaminam ashkee; goynamaar kina gaz hayee. Qanana wul ke thoothe; dhukanabee kuttonabe yirk ke hame. Wobona goynaar gaz ke hame; agaammo goynoar agaa ko maate. Eeno wul Barjosa dhacchintanam koda shede’ hamayse ilatea easa upsino darante koda qansime” hamayse ena birayse Isiassa mathaapinte thaapadhondettsi ko maatade. ");
INSERT INTO amf_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ogonante kikal shiidhanna nivon eenna Wannis yin ki giyade: “Yedi qarshi naanato, niven Barjosa wacimera gobayse yenin dhaqoadettsi yeam kiilaa hayne? ");
INSERT INTO amf_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ta keeda seeson waadimanam garayse Barjodar yenin maatonam dhehen payyan waadiman waadadhee. Yesa woylaminkaar ‘Wodi Abraam naasine’ hamayse erimeebhode. Yena ida giye: Barjo yi zaganna kina sennara Abraamna naasi hayayse dhaasana dama ki dame. ");
INSERT INTO amf_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ta haaqanaam taxate dhabayno tesimbho demente kesa wodadhidine; ogonante payyan aapin ushimina haaqana wulam taxate nuunte koda dhabadhe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Eenoar “Ta har haya ko woam zaske?” hamayse Wannisam oysite ko dahade. ");
INSERT INTO amf_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Kidiar “Apala lamaa yisa dahaa kalaam qolmaana ki ime; gala yisa dahaar ogodettsi ki haye” hamayse kena ki maasade. ");
INSERT INTO amf_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Gibirin kacchaynaar kikal shiidhanna nivayse, “Woam Dhettsea, woam ta har haya ko zaske?” hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Kidiar “Yena yigginte giidhorra saskayse koymon tiyeebhode” hamayse kena ki maasade. ");
INSERT INTO amf_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Poolisanaar nivayse, “Woamsin ta har haya ko zaske?” hamayse kiam ke oysade. Kidiar “Eensa koymonam kantaka buurate tiyeebhode; hayyeamaar buudamoka berseebhode; yesa waadimanna yena imbhayno bazano yena ko yeeke” hamayse kena ki maasade. ");
INSERT INTO amf_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ogo wodanka eenoar Wannissa dhalqinam bhocchaate wozaka kaalite, “Kaa ea Barjoyn qadhaa Kiristoos doo ki dew?” hamayse yisa woylaminka qaabite ko dahade. ");
INSERT INTO amf_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Wannisaar ke wulna yin ki giyade: “Inta noqoka yeam ida shive; ko dahaannaar idara kantanka sagea niva ki nive. Inta kisa dunngurinsa dhaxinam hattear bulana damimane. Kidi Manpas Gazanbee nuubeka yeam kida shive. ");
INSERT INTO amf_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Gazgonam qanayse puqulara aapinam kinin bulea anngamo kisa aaninte ko dahade. Aapinam payya ashkayse yisa kononte kida kee; puqulanamaar dikimon nuunte kida koqe” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ogonante eenaam thoothi waana waana hama goytika kiilaate Barjosa dhacchintan upsinam kena giyte ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ko dahaannaar, Galila peenam wottsea Herodis iishima Pilbhoossa geshon Herodiyadaam kinin keemonnabee kinin waadadhon siyon waadiman wulbena Wannis kiam ki wacimade. ");
INSERT INTO amf_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ogona Herodis yinin waadadhon siyon waadiman wulra saskayse, pir Wannisam dhaxin ooninte ki dhaskade. ");
INSERT INTO amf_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Een wulin shiidhenka Yesusaar ki shiidhade. Barjoam kinin miskenka cecino ko bulimade, ");
INSERT INTO amf_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Manpas Gazanoar waleedettsi maatayse kidar ko hanchade. “Inin nashea isa Naasa yane; hanka ida wozadhe” hamea upsi cecira ko qansimade. ");
INSERT INTO amf_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesus eenaam dhettsan kinin yedenka lendho kisa eedi kalaa kaysa apo tabhiaddhane. Eenna Yesus Yoseep naasi kida maate. Yesussa eykena kinane: ");
INSERT INTO amf_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","(38) Barjo naasa Addaam, Addaam naasa Seet, Seet naasa Henoos, ");
INSERT INTO amf_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","(37) Henoos naasa Qaynan, Qaynan naasa Malaliveel, Malaliveel naasa Yaared, Yaared naasa Henook, Henook naasa Matusaala, ");
INSERT INTO amf_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","(36) Matusaala naasa Laamex, Laamex naasa Nohe, Nohe naasa Seem, Seem naasa Arpakisaad, Arpakisaad naasa Qaynim, ");
INSERT INTO amf_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","(35) Qaynim naasa Sheela, Sheela naasa Ebeer, Ebeer naasa Peleeg, Peleeg naasa Revu, Revu naasa Serug, ");
INSERT INTO amf_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","(34) Serug naasa Naakor, Naakor naasa Taara, Taara naasa Abraam, Abraam naasa Yisaaq, Yisaaq naasa Yayqoob, ");
INSERT INTO amf_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","(33) Yayqoob naasa Yiwda, Yiwda naasa Paarees, Paarees naasa Hethroon, Hethroon naasa Arni, Arni naasa Raam, Raam naasa Aminaadaab, ");
INSERT INTO amf_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","(32) Aminaadaab naasa Navasoon, Navasoon naasa Selimoon, Selimoon naasa Boveez, Boveez naasa Iyobeed, Iyobeed naasa Isey, ");
INSERT INTO amf_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Isey naasa Dawt, Dawt naasa Naataan, Naataan naasa Maathaat, Maathaat naasa Maynaan, Maynaan naasa Meelia, ");
INSERT INTO amf_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","(30) Meelia naasa Eliyaqem, Eliyaqem naasa Yonaan, Yonaan naasa Yoseep, Yoseep naasa Yiwda, Yiwda naasa Simoon, ");
INSERT INTO amf_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","(29) Simoon naasa Lewi, Lewi naasa Mathaat, Mathaat naasa Yooraam, Yooraam naasa Elivezar, Elivezar naasa Yoseev, ");
INSERT INTO amf_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","(28) Yoseev naasa Eer, Eer naasa Elmodaam, Elmodaam naasa Qosaam, Qosaam naasa Haadi, Haadi naasa Milki, ");
INSERT INTO amf_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","(27) Milki naasa Neeri, Neeri naasa Selatial, Selatial naasa Zerubaabeel, Zerubaabeel naasa Rees, Rees naasa Yonaan, ");
INSERT INTO amf_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","(26) Yonaan naasa Yooda, Yooda naasa Yoseep, Yoseep naasa Semey, Semey naasa Matatiyo, Matatiyo naasa Mavat, ");
INSERT INTO amf_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","(25) Mavat naasa Naage, Naage naasa Eslim, Eslim naasa Nahoom, Nahoom naasa Amoth, Amoth naasa Matatiyo, ");
INSERT INTO amf_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","(23-24) Matatiyo naasa Yoseep, Yoseep naasa Yoona, Yoona naasa Milki, Milki naasa Lewi, Lewi naasa Maati, Maati naasa Eeli, Eeli naasa Yoseepne. ");
INSERT INTO amf_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesusaar Manpas Gazanka thoothayse Yordaanoos bayra kinin maatenka, Manpas Gazano darandar kiam entsaate konin yivenka, ");
INSERT INTO amf_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","eedi lamaa kaysa rooro Seethaanka taysadhate ki dahade. Roorona iginaka yer kala hattear itsadehe. Roorona igina maqaysaka ki daaqardhade. ");
INSERT INTO amf_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Seethaanaar Yesusna “Ya Barjo Naas ha daana, seenin koka ‘Balasha maataa’ hamaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesusaar kina yinin maasenka, “‘Eedi balasha itsayse bish dehehe’ hamayse thaapadhidine” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ogora Seethaan Yesusam yinka dheg hamon raqindar entsate utayse, peendar haapadhen bitamon wulam woda likkasa iir kina dhahayse, ");
INSERT INTO amf_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“Ogo kesa hayamonbee gobshin wulbeam hana imayda ime. Harrna hambhidianna, ina imbhidine; inin nasheana imayda ime. ");
INSERT INTO amf_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ogonante ya ina kumpurdhayse ha goodimidianna, kono wul hanti koda maate” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesusaar kina yinin maasenka, “‘Hasa Imbaa Barjona kumpurdhayse kibisheana goodimaa!’ hamayse thaapadhidine” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Ta pir Seethaan Yesusam Yerusaalem entsayse Barjosa gazan ooninsa illindar bulate woysayse kina yin ki giyade: “‘Haam kenin tooloadettsi Barjo yisa gaananana giya ki giye; kediar roon hannonam seenin qanoamadettsi yisa aaninka keedhayse haam yeda ke yede’ hamayse thaapadhidine. Keeda ya Barjo Naasi hanna, kora mia bhulate hanchaa!” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesusaar kina yinin maasenka, “‘Hasa Imbaa Barjoam taysate shedaabhode!’ hamayse thaapadhidine” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Seethaanaar yinin taysen wulam kinin macchonsa budonte, pir kiam taysate shedana agea woda haapadhenka yekka kikalanka ki pegimbhade. ");
INSERT INTO amf_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesus Manpas Gazansa kantanka thoothayse Galila peendar ki maatade; kisa waadimano Galila peenbee kosa gasante dohon peen wul gidirbe ko qansimade. ");
INSERT INTO amf_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kesa bukin raqinte keam dhettsite ki dahade; kinin dhettsenkaar eeno wul kiam ko gobshade. ");
INSERT INTO amf_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ogosa budonte Yesus yinin gebhon kataman Naazretdar ki yivade. Ogotear yisa dambindettsi ukunsen rooroaka Ayiwd eensa bukin raqinte ki ardade; Mathaap Gazanam nabbabana ki dhaabhade. ");
INSERT INTO amf_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Barjokala qansayse eenna giyea Isias mathaapin kina imbhaysaka yin giyayse thaapadhaa raqadar bulayse: ");
INSERT INTO amf_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","“Barjosa Manpasino idar ko dahade; qambhinana Barjosa dhacchintan upsinam inin giyoadettsi iam ki qadhade. Dhaxadhaanayn buldhen, aapin kayaanayn sheden i giye, gaalensa iinte dahaanaam gaalera inin buloadettsi, ogo Barjo yisa nashimmakkonam kinin dhehen levenin yeskonam inin giyoadettsi iam ki nittsade” hamayse ki nabbabade. ");
INSERT INTO amf_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesus mathaapinam diithayse Ayiwd eensa bukin raqinte waadiman eana imayse ki dooqade. Bukin raqinte dohoono eeno wul bhocchaate kibisheam koda shede. ");
INSERT INTO amf_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kidiar “Marrato! Ta kono nabbabadhenka yenin qansoono mathaapinsa upsino kina thoothidine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kinnon goynsa eeno wul yer payya koda giye; kinin giyen payyan dhalqinka targadhayse, “Kaa Yoseep naasatayu?” ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesusaar kena yin ki giyade: “‘Ya akkimia, ta haam pacchaa!’ hamen kamsin koam idar bavima shidhattene. Ogodettsi ‘Qipirnaahoomir hanin waadadhon wonin qanson kotear hasa peente waadadhaa’ ina yeda hame. ");
INSERT INTO amf_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Inta yena gon ida giye: Barjokala qansayse eenna giyeam kisa peente dahayna eena hamin ko dahaakaar kiam tiyehe. ");
INSERT INTO amf_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Inta yena gon ida giye: Eelias wodanka leve makkambee arpi laxbe doobin qanima shidhonna peen wuldar gebhi daaqi dahaysaka, Israveel peente thoothina qambhina maana ke dahade. ");
INSERT INTO amf_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ko dahaannaar Eelias Sidoona peente dohon Sirabhta gurdante edon qambhinkal kiam ko yittsadhade; Israveel peente dahaana maana waanikal kiam yittsadhadehe. ");
INSERT INTO amf_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Barjokala qansayse eenna giyea Elsav wodanka Israveel peente thoothino lamth burqoka hajadhaana ke dahade; Sooria peente Niviman bishne paashaa, kesa iira eedi hay dahaannaar paashadehe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ayiwd eensa bukin raqinte dahaana wul dhalqin ogoam qansayse kattsi ke wacimade. ");
INSERT INTO amf_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Dhaabhayse katamara mayanka Yesusam yedate ke bulade; kiam boodante kupate dhabota zagayse katamanin ashkadhon ashondar ke yivade. ");
INSERT INTO amf_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kidiar kesa shaarinka utate ki yivade. ");
INSERT INTO amf_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ogosa budonte Yesus Galilar dohon Qipirnaahoom katamandar ki yivade. Ogote Ayiwd eensa ukunsen rooroaka eenaam dhettsite ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kidi yisa hayamonka kinin giyenna eeno wul kinin dhettson timmirinka targadhidine. ");
INSERT INTO amf_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ayiwd eensa bukin raqinte beeronin yiam yedaa eedi kalaa ki dahade. Upsin yisa dheg hayayse ilataate: ");
INSERT INTO amf_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Naazret peen Yesuso, hambesana wosa dohoono hare? Woam kaysana nivaaw? Hay hanin dohonam inta dhesidine; ya Barjokala nivaa Gazaane!” hamayse ki ilatade. ");
INSERT INTO amf_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesusaar beeroaka, “Lay hamayse eadara utaa!” hamayse kiam ki bitade. Beeroar kesa birante eam dhabayse gaale kidar yeskisima kidara ki utade. ");
INSERT INTO amf_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Eeno wulaar targadhayse kinka kikal “Kono kinin giyayno yer hamin dohoonone? Yisa hayamonbee yisa kantanbeka beeronana kisa giyanka eendara uta ke ute” hamayse ke dhalqade. ");
INSERT INTO amf_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yesusin shawkadhoono Qipirnaahoomsa gasante dohon peen wulir ko qansimade. ");
INSERT INTO amf_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesus kesa bukin raqira utayse Simoon ooninte kinin ardenka, Simoonsa baysino kattsi bishi occhea hajimoka wodhayse ko dahade. Ogonante koam kinin pacchoadettsi kiam ke miskade. ");
INSERT INTO amf_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Kokal theedi woyayse bishin occhenam ki bitade. Bishin occhaynoar koam ko garade; kodiar saanawa dhaabhayse kena gala baxan ko yedade. ");
INSERT INTO amf_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Hayn wevenka waana waana burqenin yedaana wulam kikal ko baadhade; kidiar kalaa kalaanadar yisa aanin wodayse keam ki pacchade. ");
INSERT INTO amf_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Beeronaar pir “Ya Barjo Naasine” hamayse ilatada thoothin eendara ke utade. Kedi Barjoyn qadhaa Kiristoos kinin dohonam kenin dhesonna Yesus yer kalaar kenin giyoamadettsi keam ki bitade. ");
INSERT INTO amf_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Peen sedhaysaka, Yesus utayse eedinin qolmon raqindar ki yivade. Eenoar kiam zagada kikal ko nivade; kekala edimayse kinin yivoamadettsi kiam marana ko zagade. ");
INSERT INTO amf_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kidiar “Waani katamante dohon eenna wozisen Barjo bitamonsa upsinam inin giyoadettsi iam koda zaske; harrna hambhidianna, iam nittsadhoono ogonane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ogonante Yiwda peente dahaana kesa bukin ranqar Barjosa upsinam giyte ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Eeno Barjosa upsinam qansaate kiam kupite ko daaka, Yesus Gensareth bazinsa gasante woyayse ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Bazinsaar gasante bazindara sagadhayna gonngala lamaa woyayse ke daaka keam ki haapade. Kaaran zaanin qazayna eenaar gonngalanara utayse kaaranna kenin qazen zaaninam keda shive. ");
INSERT INTO amf_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Igina gonngallasa Simoon gonngalante Yesus ardayse bazinsa gasara likka bazindar kinin yittsoadettsi kiam ki miskade; ogo bazindara sagadhen gonngalante dooqayse eenaam dhettsite ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yisa dhalqinam yinin macchonsa budonte Simoonna “Bazindara sagadhen gonngalanam bazinsa theerin raqindar yittsayse kaaranam yenin qazen zaaninam bazinte dhabee” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoonaar kina yinin maasenka, “Imbo, sootin woda qazika sunoo qajadhade, kala hattear yedootone; ta hanin giyonna, kaaranam wonin qazen zaaninam bazinte ida dhabe” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Yin giyayse kenin dhabenka kattsi thoothi kaaraam ke yedade; kaaran kenin qazayno zannoar havan ko yedade. ");
INSERT INTO amf_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Waani bazindara sagadhen gonngalante dahaana aanamma nivayse keam kenin kelshoadettsi milkitka keam ke eelade. Nivayse bazindara sagadhayna gonngalla lamaanayn itsadhanna hayenka yekka, kaaranam iir ke thoosade. ");
INSERT INTO amf_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Bhethiroos hambhea Simoon ogoam yinin haapenka, Yesussa birante kumpurdhayse, “Imbo, inta seeso eedi inin dohonna, ikalanka pegadhaa!” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ogoam yin kinin giyoono kimbesana kinka dahaana wul kenin yedon kaaransa thoothamora dhaabhonka kattsi yinin targadhonnane. ");
INSERT INTO amf_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ogodettsi Simoonsa aanamma Zabdoos naana Yayqoobbee Wannisbe kediar targadhidine. Yesusaar Simoonna, “Kurtumbhaabhode! Keeda kaara os kaaranam hanin yedendettsi eenaam Barjosa bitamondar maasea eedi hada maate” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kediar bazindara sagadhayna gonngallaam yisa bazinsa gasandar yeskisayse yer wulam garayse Yesussa paanan yivan ke yedade. ");
INSERT INTO amf_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesus katama kalaate ki daaka, lamth burqo yiam kattsi yedaa eedi kalaa ki dahade. Ea agaa Yesusam yinin haapenka, kisa roonte dhambayse, “Imbo, ha nashidianna, iam pacchana damaada dame” hamayse kiam ki miskade. ");
INSERT INTO amf_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesusaar yisa aaninam kidar wodayse, “Haam pacchana nashayda nashe, paashaa” kina ki hamade. Saanawaar kisa lamthin burqono kiam ko garade. ");
INSERT INTO amf_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesus “Hanin paashonam eedi haynaar giyaabhode! Ko dahaannaar yivayse hasa bishinam gudulana dhahaa; eennaar hanin paashoono tarja konin maatoadettsi Museyn giyon Barjona machadhen marshanam imaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yesusin shawkadhoono ena gayra sagi ko dhesimade. Thoothino eeno kinin giyenam qansanabee yisa burqoraar paashanabe kikal ko bukade. ");
INSERT INTO amf_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kidiar thoothi wodana darandar yimal edimate yivayse Barjoam miskaate ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Rooro kalaa Yesus eenaam kinin dhettsenka, Parisa eenabee Musesa yigginam dhettsayna eenabe kisa gasante ke dahade. Kediar Galila peenbee Yiwda peenbesa gurdan wulra, pir Yerusaalem katamaraar nivaana ke dahade. Yesus hajadhaanaam kinin pacchayno Barjosa kanta kidar ko dahade. ");
INSERT INTO amf_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Marrato! Eedi hajimoka malgimaa kalaam eena haaqaka kedate Yesuskal ke bavade; ooninte kiam arsayse Yesussa birante wodana ke zagade. ");
INSERT INTO amf_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Eensa thoothamora dhaabhoono ooninte arsan keam konin bashonna, ooninsa illindar bulayse ooninsa illinam dhaasayse eensa shaarinte Yesus birante haaqanka eam ke hanchade. ");
INSERT INTO amf_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesus kidar woylamin kenin qajonam shedayse hajimon eana yi giyna: “Ya eedi kaa, hasa seesono hana gardhidine” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Musesa yigginam dhettsaynabee Parisa eenabe “Ea kaa Barjo maato qaabea kidi hayne? Eedisa seesoam garana damea Barjo bishkalanka ab hayne?” hamayse ke qaabade. ");
INSERT INTO amf_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesusaar kesa qaabenam dhesayse kena yinin maasenka, “Yesa woylaminka yin harrnee qaabe? ");
INSERT INTO amf_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‘Hasa seesono hana gardhidine’ hamarabee ‘Dhaabhayse yivaa’ hamarabesa hamaane deegaa? ");
INSERT INTO amf_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ko dahaannaar i Eedi Naasina peendar eenna seesonam garana hayamo isa konin dohonam yenin dhesoadettsi yeam koda zaske” hamayse hajimonka malgimaa eaka “Inta hana ida giye: Dhaabhayse haam baadhon haaqanam hanka bavate hasa oonindar yivaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hajimonka malgimaa ea saana kesa birante dhaabhayse, yininka baadhon haaqanam bavate Barjoam gobshada yisa oonindar ki yivade. ");
INSERT INTO amf_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ogote dahaana eena wul Barjoam gobshaate “Kina yer tarshen wo haapade” hamayse kattsi targadhayse ke kurtumbhade. ");
INSERT INTO amf_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ogosa budonte Yesus ogora utayse Lewi hambhea gibirin kacchea gibirin kinin kacchen raqinte dooqayse ki daaka kiam haapayse, “Isa paanan nivaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewiar dhaabhayse yerin wulam garayse Yesussa paanan yivan ki yedade. ");
INSERT INTO amf_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ogosa budonte Lewi yisa ooninte Yesusna gala gebhi ki ashkaysaka, kimbesana kinka galandar dooqaana gibirin kacchaynarabee waani eenbera thoothino eeno ko dahade. ");
INSERT INTO amf_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Parisa eenabee kesa muldhara dahaana Musesa yigginam dhettsaynabe Yesussa paanan yivayna eenana “Eena cubbona gibirin kacchaynabee igina seeson eenabesana kinka galanam yenin itsenbee wucenbe harrnane?” hamayse kekal ke gundumade. ");
INSERT INTO amf_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesusaar kena yinin maasenka, “Hajadhaanaam akkimi koda zaske; payyanaam akkimi zaskehe. ");
INSERT INTO amf_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Inin nivoono seeson eena yisa seeson waadimanam garayse Barjodar kenin maatoadettsi keam eelota i nivade; tipana eenaam eelota nivaatine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ogora Parisa eenabee Musesa yigginam dhettsaynabe Yesusna yi giyna: “Shivea Wannissa paanan yivaynabee Parisa eenasa paanan yivaynabe thoothi rooro itsima qoomayse Barjoam keda miske. Hasa paanan yivayna rooro wul kenin itsenbee wucenbe harrnane?” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesusaar kena yin ki giyade: “Uutaa kembesana kinka ki daaka, gaydonna nivaana eenaam itsima kenin qoomoadettsi yedi haye hayo? ");
INSERT INTO amf_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ko dahaannaar uutaanin kekalanka edadhayno woda niva ko nive; ogo wodanka ko hanna itsima keda qoome” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Pir kamsika kena yin ki giyade: “Apala haaleam hattsayse apala gecchoadar lashea eedi qolehe. Yin ki haydianna, apala haaleam sun ki hattsade; haalea lashadhaa gecchoabesana kidar agehe. ");
INSERT INTO amf_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Jambin gecchonsa iinte zia haali shabhea eedi qolehe. Shabhadhidianna ziano jambinam bhattsa ko bhattse; zianoar layma ko layme, jambinoar bhaqayse sun guuri koda shidhe. ");
INSERT INTO amf_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ogona zian haalin shabhadhenna, jambi haali koda zaske. ");
INSERT INTO amf_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Zian oydhonam wucaa ea oydhaamon zianam wucana nashea hayyear qolehe. Harrna hambhidianna, ‘Ziano oydhino kattsi payyane’ kinin hamennane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ayiwd eensa ukunsen rooroaka Yesus gazgon ushon haaminsa shaarinka kinin yivenka, kisa paanan yivayna eena gazgon tishanam qunthate qadhayse gavite ke dahade. ");
INSERT INTO amf_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Parisa eenasa waani waani eena “Ukunsen rooroaka zaskimon waadimanam harrnee waadadhe?” kena ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesusaar yin giyayse kena ki maasade: “Ena Bitaa Dawtbee kimbesana kinka dahaana eenabe kenin daaqardhonka kinin hayonam yedi nabbabeete? ");
INSERT INTO amf_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kidi Barjosa gazan ooninsa mayante ardayse gudullakalanka een abinin itsimon Barjosa birante wodadhon balashanam tiyayse ki itsade; kimbete dahaana eenanaar ki imade. ");
INSERT INTO amf_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Inta Eedi Naas ukunsen rooroasa Imbaane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ukunsen rooro abka Yesus Ayiwd eensa bukin raqinte ardayse eenaam dhettsan ki yedade. Raqin ogotear anta mizaqaysa wobaa eedi kalaa ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Musesa yigginam dhettsaynabee Parisa eenabe Yesusam bersana zagayse, “Ukunsen rooroaka Yesus eediam paccho ki dew?” hamayse kiam shedite ke dahade. ");
INSERT INTO amf_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesusaar kesa qaabenam dhesayse, aaniysa woboa eana “Dhaabhayse eensa shaarinte woyaa!” kina ki hamade. Ear dhaabhayse ki woyade. ");
INSERT INTO amf_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesus kena yi giyna: “Yeam ida oyse: Ukunsen rooroaka Musesa yiggino har wonin waadadhoadettsi wona ko giye? Payya yermoo? Siya yeru? Eediam wonin dhacchoadettsimoo? Eediam wonin deesoadettsine?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesusaar kisa gasante dohon een wulam shedayse, yisa aanin woboaka “Aanin hannonam pishkaa!” kina ki hamade. Ear yisa aaninam ki pishkade. Kisa annoar ko paashade. ");
INSERT INTO amf_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Musesa yigginam dhettsaynabee Parisa eenabe ogoka kattsi wacimayse, “Hamin kiam wo hayanna wona ko paydhe?” hamayse kinka kikal ke dhalqade. ");
INSERT INTO amf_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ogo wodanka Yesus Barjoam miskana dhukandar ki utade; ogotear Barjoam miskaate ki wodhade. ");
INSERT INTO amf_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ogora peen sedhaysaka yisa paanan yivaynaam yikal keam ki eelade; kesaar iira tabhi lamaanaam ki kamade. Pir “Tarjamonnante Yittsadhaana” hamayse kena naabe ki wodade. ");
INSERT INTO amf_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Kediar: Bhethiroos hamayse kisa naabe kinin wodaa Simoonbee, indanaasa Indiriasbee, Yayqoobbee, Wannisbee, Pilbhoosbee, Bartelemoosbee, ");
INSERT INTO amf_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Maatoosbee, Toomaasebee, Ilpoos naasa Yayqoobbee, “Peen yinnonna bish qaabeane” hamayse giidhea Simoonbee, ");
INSERT INTO amf_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yayqoob naasa Yiwdabee, Yesusam dembhinna saskate imea Asqoronto peen ea Yiwdabene. ");
INSERT INTO amf_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Yesus igina tabhi lamaanabete kinka dhukara hanchayse torente ki woyade; kisa paanan yivayna eenasaar thoothino eeno ogote ko dahade. Taar kisa dhalqinam qansanabee yisa burqoraar paashanabe Yiwda peen wulbee, Yerusaalem katamanbee, bazinsa aponte dahaana Thiroosbee Sidoonabera kikal nivoono thoothino eeno ko dahade. Beero yiam yedaysaka gaalaynaar ke paashade. ");
INSERT INTO amf_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Pacchansa kantano kikalanka utayse ke wulam pacchite konin dohonna, eeno wul Yesusam kaamana koda zage. ");
INSERT INTO amf_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesusaar yisa paanan yivaynaam shedayse yin ki giyade: “Yedi qambhinato, Barjosa bitamono yenti konin dohonna wozadhee; ");
INSERT INTO amf_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","yedi ta daaqardhaynato, yenin mishenna wozadhee; yedi ta eepaynato, yenin hancenna wozadhee. ");
INSERT INTO amf_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","I Eedi Naasina hamayse eeno yeam konin jibbenkabee, yembesana kinka kalaa maatintanam garayse yeam konin edenkabee, yeam konin iirenkabee, yesa naabenam konin genenkabe, wozadhee. ");
INSERT INTO amf_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Marrato! Yena kashadhayno bazano cecinte gebhi konin dohonna, ogo wodanka wozadhee, wozaka bhulee. Ena kesa eykenaar Barjokala qansayse eenna giyaynaam agaadettsi keam ke hayade. ");
INSERT INTO amf_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Yedi wodimbhaanato, yena maaten yerin wulam ta yenin haaponna, os birante yenin haapiminna hay! ");
INSERT INTO amf_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Yedi ta mishaanato, yenin daaqardhenna hay! Yedi ta hancaynato, qaabonka yenin atennabee yenin eepennabe hay! ");
INSERT INTO amf_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Eeno wul yeam shawkaate payyamon yesa konin giyenka hay! Ena buudamoka ‘Wodi Barjokala qansayse eenna giyaynane’ hamaynaam yesa eykenaar yin ke shawkade” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesus pir “Inin giyenam qansaynana yin ida giye: Yeam jibbayna eenaam nashee; kena yer payya hayee. ");
INSERT INTO amf_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Yeam ashaynana payya malsi kena maasee; yeam genaynanaar Barjoam miskee. ");
INSERT INTO amf_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Hasa karcanam ceveana karca waam kina shirshayse dhahaa; hasa kotteam tiyeana shuraabeamaar kina imaa. ");
INSERT INTO amf_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Hakal miskayna wulna imaa; hasa yer tiyaar hana kinin maasoadettsi kiam oysaabhode. ");
INSERT INTO amf_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Eenin yena hayoadettsi yenin nashenam yediar kena ogodettsi hayee. ");
INSERT INTO amf_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ta yeam nashaynaam bish ye nashina yeam shawkadhok? Seeson eena yiam nashaynaam keda nashe. ");
INSERT INTO amf_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Yer payya yena hayaynana payya ye hayna yeam shawkadhok? Seeson eenaar ogodettsi keda haye. ");
INSERT INTO amf_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","‘Maasate ina kasha ki kashe’ hamayse yenin qaabe hayaynana yenin bazenna yeam shawkadhok? Seeson eenaar ogo yinin bazonam tiyana seeson eenana keda baze. ");
INSERT INTO amf_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Yediar yesa banqin eenaam nashee; yer payyaar kena hayee. ‘Maasate ina kasha ki kashe’ hamayse woylam qajima kena bazee. Yin yenin hayenka, yesa bazano gebhi koda maate; Wuldara Sagea Barjo naana maateeda maate. Kidi kiam gobshiminabee seesaynabena payyane. ");
INSERT INTO amf_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yesa Imbaa eedina burqadhea kinin dohondettsi, yediar eedina burqadhayna maatee. ");
INSERT INTO amf_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Eedisa seesoam paydeebhode; yesaar seesonam paydadhehe. Eedidar pirdeebhode; yedarar pirdadhehe. Eedina garee; yenaar koda gardhe. ");
INSERT INTO amf_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","“Imee; yena imbha ko imbhe. Yenin kahaaka maasate yenaar kaadha ko kaadhe; payya uxate thoothayse konin laymenka yekka yena kaadha ko kaadhe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ogora Yesus kamsika kena yin ki giyade: “Aapin kaya ea aapin kaya eam entsana dama ki damo? Lamaana kinka oolontetayu kenin dhambayno? ");
INSERT INTO amf_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Dhettsadhea ear kiam dhettseadara sagehe. Ko dahaannaar payya hayayse dhesidi ki hanna, kiam dhettsaadettsi kida maate. ");
INSERT INTO amf_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Hannon aapinte dohon haaqanam shedima, ha aanantasa aapinte dohon kosonam harrnaa shede? ");
INSERT INTO amf_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Hannon aapinte dohon haaqanam shedima, ha aanantana ‘Imbanaasa, aapin hannora hana kosonam i bule’ hamayse giyana haminaa damaa? Ya maltia ea, birayse hannon aapinte dohon haaqanam bulaa; ogosa budonte ha aanantasa aapinte dohon kosonam bulana payya hayayse hada shede. ");
INSERT INTO amf_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Payya hatta siya aapi ushehe; tapir hatta siya payya aapi ushehe. ");
INSERT INTO amf_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Haaqa wul yisa aapinka koda dhesime. Ukumbhara shaapsa aapi kambhehe; buukira woynisa aapi kambhehe. ");
INSERT INTO amf_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ea payyaa woylaminte yisa dohon yerin payyara yer payyaam kida giye; ea siyaa woylaminte yisa dohon yerin siyora yer siyaam kida giye. Harrna hambhidianna, yisa woylaminte thoothora yisa aponka kida giye. ");
INSERT INTO amf_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ta keeda harrnee ‘Imbo, Imbo!’ iam hame? Inin yena giyenam hayattene. ");
INSERT INTO amf_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ikal nivayse isa upsinam qansayse hayayna wul hayyeam kenin maatenam yena ida giye. ");
INSERT INTO amf_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kidiar oonin yinin woysenka oolonam payya koyayse haachan peendar woysea eam kida maate. Mirro nivayse oonin ogoam ko kupade. Onnoar haachan peendar konin woysadhonna shoana damadehe. ");
INSERT INTO amf_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Isa upsinam qansayse haymina peendar payya hayayse oolonam koyma yisa ooninam woysea eam kida maate. Doobin qanaysaka mirro nivayse oonin ogoam konin kupenka, kodiar saanawa ko dhambade. Dhambidinoar kosa kattsi siyane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesus ogo wulam eenna giyate macchayse Qipirnaahoom katamandar ki yivade. ");
INSERT INTO amf_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Raqin ogote mato alaqa kalaa ki dahade. Kinin nashea kisa ergen ear hajadhayse diyanna ki yeskade. ");
INSERT INTO amf_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kidiar Yesussa qansayse, “Yesus nivayse isa ergen eam ina kinin pacchoadettsi kiam miskee” hamayse Ayiwd eenasa donzanaam kidar ki yittsade. ");
INSERT INTO amf_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kediar Yesuskal yivayse, “Koam hanin hayoadettsi zaskea eedine. ");
INSERT INTO amf_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Harrna hambhidianna, kidi eenaam wosa nasha ki nashe; wonin buki bukea ooni wona ki woysade” hamayse upsi wocchika Yesusam ke miskade. ");
INSERT INTO amf_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesusaar kembesana kinka ki yivade. Kisa ooninkal kenin theedenka, mato alaqa yisa nashonaam yin giyayse Yesuskal keam ki yittsade: “Imbo, oonin innonte ha arde inta eedi zaskaatehe; ikal nivite qajadhaabhode. ");
INSERT INTO amf_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Intaar hakal nivana zaskea eedine hamayse iam qaabaatine. Ogonante ya ‘Hasa ergen ea ki paashe’ ina hamaa; kidiar paasha ki paashe. ");
INSERT INTO amf_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Intaar iam wottsaynana ee hamayda hame; isaar choobar ina ee hamayna poolisana ke dahade. Kesa kalaana ‘Yivaa!’ inin hamenka, yiva ki yive; ea waanaar ‘Nivaa!’ inin hamenka, niva ki nive; isa ergen eanaar ‘Koam hayaa!’ inin hamenka, haya ki haye” hamayse kikal ki yittsade. ");
INSERT INTO amf_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesusaar agaa easa dhalqinam yinin qansenka, kanka targadhidine. Kimbesana yiven zarsindar budoka wal hamayse, “Inta yena ida giye: Israveel eenasa shaarintear kaadettsi gebhi idar woylamin qajea hamin ko dahaakaar haapaatine!” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Yesuskal yiam yittsadhaana eenaar mato alaqa oonindar maatayse kenin yeskenka, kisa ergen ea paashayse ki daaka kiam ke haapade. ");
INSERT INTO amf_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Woda likkasa budonte Yesus Nayn hambhen katama kallondar ki yivade; kisa paanan yivayna eenabee thoothin eenbe kimbesana kinka ke yivade. ");
INSERT INTO amf_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yesus katamansa kerinte theedi kinin yeskenka, marrato! Eeno leesi bavate koda ute. Diyaar yindasa naasi kalaane. Kodiar maa qambhi ko dahade. Katamaraar thoothino eeno kombesana kinka ko dahade. ");
INSERT INTO amf_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Imbaa wontea Yesus koam yinin haapenka, kona burqadhayse, “Eepaabhode” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yesus nivayse leesin baadhon haaqanam ki kaamade; leesinam bavaana eenaar ke woyade. Yesusaar leeseaka “Ya naasa, dhaabhaa hana ida hame” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Diyaar dhaabhate dooqayse dhalqan ki yedade. Yesus naasasa indanna “Hasa naasa kash!” hamayse kona ki giyade. ");
INSERT INTO amf_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Een wulam kurtumbhe yedaysaka, “Barjokala qansayse eenna giyea gebha ea wosa shaarira dhaabhidine; Barjo yisa eenaam dhacchana nividine” hamayse Barjoam ke gobshade. ");
INSERT INTO amf_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ogono Yesussa waadimano Yiwda peenbee kosa gasante dohon peen wul gidirbe ko qansimade. ");
INSERT INTO amf_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Shivea Wannissa paanan yivaynaar ogo wulam Wannisna ke giyade. Wannisaar yisa paanan yivaynasa lamaanaam yikal eelayse, ");
INSERT INTO amf_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“Barjokala niva ki nive hambhaa yaw? Way eedi ab wo toolo?” hamayse kiam kenin oysoadettsi Imbaa wontea Yesuskal keam ki yittsade. ");
INSERT INTO amf_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Eenaar Yesuskal nivayse, “‘Barjokala niva ki nive hambhaa yaw? Way eedi ab wo toolo?’ hamayse haam wonin oysoadettsi Shivea Wannis hadar woam ki nittsade” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ogo wodanka Yesus waana waana burqoka gaalaynaam ki pacchade; beeronin yiam yedaanadaraar beeronaam ki bulade; thoothina aapin kayaanaamaar ki pacchade. ");
INSERT INTO amf_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesusaar Wannisin nittsaanana “Yivayse yenin haaponbee yenin qansonbeam Wannisna giyee: Aapin kayaana haapa ke haape; roonsa wobonaar pika ke pike; lamthin burqonka dahaanaar paasha ke paashe; qaamin kayaana qansa ke qanse; diyaanaar dembhira dhaabha ke dhaabhe; qambhina eenanaar Barjosa dhacchintan upsinam giidha ko giidhe. ");
INSERT INTO amf_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ogonante inka qothimima kidi gobshadhaane” hamayse kena ki maasade. ");
INSERT INTO amf_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Wannisin nittsaana ergen eena maatayse kenin yivenka, Yesus thoothin eenna Wannissa giyan ki yedade: “Ta har shedee darante yivaa? Jibarenka shohen piiqan shedota ye yivaaw? ");
INSERT INTO amf_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ta har shedee yivaa? Apalan gooben qaadhaam shedee yivaaw? Yin ko hanna, agen apalan qaadhaynabee yina agaysaka dahaana eena peensa binna ooninte ke dahade. ");
INSERT INTO amf_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ta har shedee yivaa? Barjokala qansayse eenna giyeam shedee yivaaw? Hahaa! Yena ida giye: Kidi Barjokala qansayse eenna giyeadara sagiane. ");
INSERT INTO amf_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","‘Shedaa! Hasa goynam birayse ashkea isa ergen eam hasa birante yittsayda yittse’ hamayse yinna thaapadhaa kidine. ");
INSERT INTO amf_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yena ida giye: Peente adhadhon een wulsa iira Shivea Wannisdara sagea eedi qolehe. Ko dahaannaar Barjosa bitamonte een wulsa choobar dahaa Wannisdara saga ki sage” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Dhalqin ogoam yinin qansenka eena wul, gibirin kacchayna eenaar shidhima, Wannis aaninte yinin shiidhonna, Barjo tipa kinin dohonam ke dhesade. ");
INSERT INTO amf_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Parisa eenabee Musesa yigginam dhettsaynabe ke hanna, Barjoyn kena qaabonam jibbayse, “Wannis aaninte shiidhattone” hamayse ke garade. ");
INSERT INTO amf_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesus yi giyna: “Ta keeda adhadhin koam harka keam i kamso? Har ke maate? ");
INSERT INTO amf_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bhookante dooqayse yiigayna naanaam keda maate. Kediar kinka kiam kiam eelada ‘Ye kirbe hamayse yena pashko wo pugade, yediar kirbeetene; ye eepe hamayse yena wo zilimade, yediar eepeetene’ keda hame. ");
INSERT INTO amf_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Shivea Wannis gala itsimabee yer wucimabe qoomayse kinin dehenka, ‘Kaa eadar beero daane’ kiam ye hamade. ");
INSERT INTO amf_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ta keeda i Eedi Naas itsaatebee wucaatebe inin dehenka, ‘Marrato! Kaa ea galabee wucamobe nasheane, cubbona gibirin kacchayna eenabee seeson eenabesa yettsine’ iam ye hamade. ");
INSERT INTO amf_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ogona pakalmakkono gon konin dohonam dhesadhayno kanka waadadhayna kosa naanakane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parisa eenasa eedi kalaa Yesus kimbesana gala kinin itsoadettsi kiam ki eelade. Yesusaar Parisa easa ooninte ardayse kummandar ki dooqade. ");
INSERT INTO amf_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Marrato! Kataman ogote seeso hayayno maa kallo ko dahade. Kodiar Yesus Parisa easa ooninte kummandar kinin dohonam yinin dhesenka, gaamen shittonka thoosadhon seeni cawlira ashkadhon bilqaathinam ko bavade. ");
INSERT INTO amf_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kodiar Yesussa budobar roonkal kisa woyayse, eepada kosa ermitinin kisa roondar thokkenka, kisa roonam yisa metensa sitinka ko qodade; kisa roonamaar sunqaate gaamen shittonka kisa roonam qadhite ko dahade. ");
INSERT INTO amf_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Yesusam yisa oonindar kummanna eelaa Parisa ea koam shedayse, “Ea kaa Barjokala qansayse eenna giyea yi daana, ogo kiam kaamen edonam hamin dohoono seeso eedi konin dohonam ini kidi dhesa ki dhese” hamayse yisa woylaminka ki qaabade. ");
INSERT INTO amf_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesusaar “Simoon, hana inin giyea yer kalaa dahade” kina ki hamade. Kidiar “Dhettsea, ee ina giyaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesusaar “Eedi kalaakal eedi lamaa birre baddaraana ke dahade. Ea kalaa mato dong, waa ea bondi dong birre ke baddarade. ");
INSERT INTO amf_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kediar eana koymon kashan ke bashadhaysaka, ear kena ki garade. Ta ke lamaanasa kalon kiam saskayse nashea hamaa eane?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoonaar “Thoothi bazan yindar dahaa ea kalon kiam nashima garehe” kina ki hamade. Yesusaar “Gonaa giyade” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesus edonam maatate shedayse, Simoonna yin ki giyade: “Edon koam shedaa shedo? Inta hasa ooninte i ardaysaka, ya isa roonna noqo hattear imaatane; kodi yisa ermitinka isa roonam shivayse yisa meten sitinka ko qodade. ");
INSERT INTO amf_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ya iam sunqaatane; kodi inin ardorra yedayse isa roonam sunqan garadehe. ");
INSERT INTO amf_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ya isa metenam waqatika qadhaatane; kodi isa roonam gaamen shittonka ko qadhade. ");
INSERT INTO amf_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ogonante hana yin ida giye: Kattsi konin nashonna, kosa seeson thoothinaam kona gardhidine; yisa seeson likkonam yina gardhea likkaka kida nashe” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ogora edonna “Hasa seesonam hana ko shidhe hambhidine” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kimbesana kinka kummandar dooqaanaar “Eedisa seesoam shiishea kaa kidi hayne?” hamayse yisa woylaminka qaaban ke yedade. ");
INSERT INTO amf_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesus edonna “Idar woylamin hanin qajoono haam ko dhacchade; nagaya yivaa” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ogosa budonte Yesus katamantebee gurdantebe Barjo bitamonsa wozisen upsinam giyaate yaayte ki dahade. Tabhi lamaana kisa paanan yivayna eenaar kimbesana kinka ke dahade. ");
INSERT INTO amf_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Tapir beeronaam yindara kinin bulaanabee kesa burqora keam kinin pacchaana maanabe kimbesana kinka ke dahade; kesaar iira beero tobbhaa yindara utoono Megdela peen edon Mayriyambee, ");
INSERT INTO amf_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Herodissa waadiman eenaam wottsea Kuzasa geshon Yohannabee, Soosinnabee, waaniar thoothina maanabe ke dahade. Kediar Yesusbee kisa paanan yivayna eenabena koymon yisa imada keam keda kelshe. ");
INSERT INTO amf_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Thoothino eeno kataman wulra kikal nivayse kenin bukenka, Yesus kamsika kena yin ki giyade: ");
INSERT INTO amf_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Eedi kalaa haaminte bheeta yiithota ki utade. Kinin yiithenka, bheetano waani goyn aponte ko wavaysaka, eenoar koam ko tigade; aptinaar koam ke itsade. ");
INSERT INTO amf_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Waani bheetanoar peen haachandar ko wavade; ko baqalaysakaar pee capinin qolmonna ko wocchade. ");
INSERT INTO amf_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Waani bheetanoar ukumbhansa shaarinte ko wavade; ukumbhanoar kombesana kinka gebhayse koam ko ishkade. ");
INSERT INTO amf_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Waani bheetanoar peen payyandar ko wavade; kodiar baqalayse eedi dong kaysa aapi ko ushade. Keeda qansen qaamiysa dahaa ki qanse” hamayse upsi gebhika yisa dhalqinam ki macchade. ");
INSERT INTO amf_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesussa paanan yivayna “Kamsin ogosa bulino hare?” hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesusaar “Barjo bitamonsa aachin dhalqinam yenin dhesoadettsi yena imbhidine; waani eenna ko hanna, sheda sheda dahayse, kenin haapoamadettsi qansa qansa dahayse, kenin bhocchoamadettsi kamsika kena koda giidhe. ");
INSERT INTO amf_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Kamsinsa bulino yinne: Bheetano Barjosa upsinone. ");
INSERT INTO amf_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Goyn aponte wavaa bheetasa kamsino Barjosa upsinam qansayna eenane. Kenin qansonsa budonte Barjodar woylam qajayse kenin dhaqoamadettsi Seethaan nivayse kenin qanson upsinam kesa woylamra tiya ki tiye. ");
INSERT INTO amf_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Peen haachandar wavaa bheetasa kamsino Barjosa upsinam qansayse wozanka tiyayna eenane. Eena igina caaci kenin yittsaamonna, Barjodar woylam kenin qajayno likka wodanane; kesa caacinin qolmonna, keam taysate sheden gaalenin nivenka dhamba ke dhambe. ");
INSERT INTO amf_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ukumbhansa shaarinte wavaa bheetasa kamsino Barjosa upsinam qansayna eenane. Ko dahaakaar wodhaate wodhaate kenin yivenka peen kosa qaabonbee, wodimbhanna kenin bhocchenbee, kena agaysaka daadhen bhocchinbeka ishkadhayse aapi ushima keda shidhe. ");
INSERT INTO amf_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Peen payyandar wavaa bheetasa kamsino payyamonbee gazamon woylaminbeka Barjosa upsinam qansayse kaalayna eenane. Kediar Barjosa upsinka wocchimbhayse aapi keda ushe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ogora Yesus yin ki giyade: “Shaakanam shashkayse yer daran guupea way algansa demente wodea eedi qolehe; ooninte ardaynana shaakano may konin haapadhoadettsi dheg hamon raqindar koda wodadhe. ");
INSERT INTO amf_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ogodettsi aachimayse may haapadhima, aadhimayse shaakandar utayse may dhesimima shidhea yer qolehe. ");
INSERT INTO amf_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ta keeda yenin qansen upsinkaar mete yesaam gishee; harrna hambhidianna, yisa dahaana kisa dohondar imbha ko imbhe; yisa qolmakalanka ‘isa daane’ kinin hameamaar kikala tiidha ko tiidhe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesussa indanbee kisa indanaanabe kikal ke nivade; eenin kattsi thoothonna, kikal theedana damadehe. ");
INSERT INTO amf_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Eenoar Yesusna “Shedaa! Handabee handanaanabe mayante woyayse haam shedana keda zage” hamayse kina ke giyade. ");
INSERT INTO amf_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kidiar kena yinin maasenka, “Barjosa upsinam qansayse hayayna eena indabee indanaanabe kedi iginane” hamayse kena ki maasade. ");
INSERT INTO amf_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Rooro kalaa Yesus yisa paanan yivaynabesana kinka bazindara sagadhen gonngalante ardayse, “Bazinsa saabar wo sage” kena ki hamade; kediar yivanna ke dhaabhade. ");
INSERT INTO amf_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bazindar kenin yivenka Yesus gonngalansa iinte ki raatade. Wura gebhi bazindar ko dhaabhade; bazindara sagadhen gonngalante noqono thoothan ko yedade; ogona gaale kedar ko yeskade. ");
INSERT INTO amf_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kediar Yesuskal theedayse, “Imbo, Imbo, wodi kayoobhe!” hamayse kiam ke dhaasade. Kidiar dhaabhayse, wuranbee bazinbeam ki bitade; ogora wuranbee bazin shohenbe lay ko hamade. ");
INSERT INTO amf_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ogora Yesus yisa paanan yivaynana “Idar woylam yenin qajayno yesa hamin ko hamaa?” kena ki hamade. Kediar kattsi kurtumbhaate targadhayse kinka kikal “Wuranbee bazinbear yinna ee hamea kaa kidi hayne?” ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Galila peera bazindara sagayse saabar Gerasenon peendar ke yivade. ");
INSERT INTO amf_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesus bazindara sagadhen gonngalara peendar ki utaysaka, kataman ogote beeronayn yedaa ea Yesusdar ki keerade. Ea agaa apala qaadha ki garaysaka thoothi woda maatidine. Kinin dahaynoar duukin raqintene; oonir dooqehe. ");
INSERT INTO amf_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kidiar Yesusam yinin haapenka, ilatayse kisa birante dhambayse upsi gebhika “Wuldara Sagea Barjosa Naasa Yesuso, hambesana isa dohoono hare? Iam hanin galshoamadettsi ida haam miske” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ogoamaar yin kinin giyoono Yesus beeronaam “Eadara utee!” hamayse kinin giyonnane. Kosa birayse rumino thoothi wodana eadar dhaabhite ko dahade; sansalabee zawbeka kiam dhaxayse koda toldhe. Ko dahaannaar sansalanbee zawnbeam takkayse kinin dhabenka, kantaka beerona darandar kinin yivoadettsi keda haye. ");
INSERT INTO amf_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesusaar “Hasa nammo hayne?” hamayse kiam ki oysade. Kidiar thoothi beero yidar dohonna, “Nammo isa Legoonne” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Beeronaar “Woam kattsi theeri maaton oolondar oytate yittsaabhode” hamayse Yesusam ke miskade. ");
INSERT INTO amf_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Raqin ogote dhukansa demendar thoothi wurkupa gishiman gishadhayna kenin dohonna, beerona “Wurkupanasa iinte wo arde” hamayse kiam ke miskade. Kidiar kena ee ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Beeronaar eadara utayse wurkupanasa iinte ke ardade; wurkupanaar bazinsa gasante dahayse, targadhayse laasandara diirimayse bazinsa iir ke itsadhade. ");
INSERT INTO amf_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wurkupan gishaynaar ogo yerin wulam yinin haaponsa budonte, gobate yivayse katamantebee gurdantebe dohon eenna ke giyade. ");
INSERT INTO amf_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Eenoar yerin ogoam shedota yisa onnara utayse Yesuskal ko nivade. Beeronayn yindara utaa ear barin kisa maataysaka apala qaadhayse Yesussa roon demente dooqayse ki daaka kiam haapayse ke kurtumbhade. ");
INSERT INTO amf_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Beeronayn yiam yedaa eayn paashonam aapinka haapaana hamin hamayse kinin paashonam eenna ke giyade. ");
INSERT INTO amf_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gerasenon peente dohoono eeno wul kattsi konin kurtumbhonna, Yesus kesa peera utayse kinin yivoadettsi kiam ko miskade. Yesusaar bazindara sagadhen gonngalante ardayse yinin nivon peendar maatayse ki yivade. ");
INSERT INTO amf_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Beeronayn utaa ear Yesusbete daana kiam ki miskade. Yesusaar “Hasa oonindar yivayse Barjo hamin dohon yer hana kinin hayonam eenna giyaa” hamayse kiam ki yittsade. Ear Yesus hamin dohon yer gebhi kina kinin hayonam katamante dohon een wulna giyaate ki yivade. ");
INSERT INTO amf_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Eeno wul kiam konin kaalonna Yesus maatayse kekal ki nivaysaka, wozaka kiam ke tiyade. ");
INSERT INTO amf_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ogo wodanka Ayiwd eensa bukin raqinam wottsea Yayroos hambhea eedi kalaa ki nivade; Yesussa roon demente dhambayse, yisa oonindar kinin nivoadettsi kiam ki miskade. ");
INSERT INTO amf_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Harrna hambhidianna, leve tabhi lamaaddha maatoono naasi kisa kallo bish dahade; kodiar hajadhayse diyanna yeskidine. Yesusaar kimbesana kinka kinin yivenka, thoothino eeno kiam kupada koda yive. ");
INSERT INTO amf_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Layme hajimoka tabhi lamaa leve hajadhayse kappoono maa kallo ko dahade. Kodiar yisa dohon wulam dheeshanna imada ko macchade; eedi hayyear koam pacchana damadehe. ");
INSERT INTO amf_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kodiar Yesussa budobar nivayse kisa apalansa nukinam ko kaamade; saanawaar kosa zombhino laymayno ko woyade. ");
INSERT INTO amf_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesusaar “Iam kaamaa hayne?” hamayse ki oysade. Kedi wulaar “Wodi haam kaamootone” ke hamade. Bhethiroos “Woam Dhettsea, eeno cibhimayse haam konin kupenka ‘Hayne iam kaamaa’ ha hamo?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yesusaar “Pacchasa kanta idara konin utonam inta dhesidine; eedi iam kaamidine” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Edonoar aadhimbhana yinin damaamonam yinin dhesenka, gibazada nivayse Yesussa demente ko dhambade. Harrna kiam konin kaamonbee saanawa konin paashonbeam een wulsa birante ko giyade. ");
INSERT INTO amf_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesusaar “Isa naano, idar woylamin hanin qajoono haam ko pacchade; nagaya yivaa” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesusaar ogoam giyte ki daaka, eedi kalaa Ayiwd eensa bukin raqin wottsea Yayroos oonira nivayse, “Hasa naano diydine; ta keeda dhettseam galshaabhode” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesusaar dhalqin ogoam qansayse Yayroosna “Kurtumbhaabhode! Idar bish woylam qajaa; hasa naano dhaabha ko dhaabhe” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesus Yayroos ooninte kinin yeskenka Bhethiroosbee, Yayqoobbee, Wannisbee, naansa imbaabee indanbe, igina eenara eedi ab kimbesana kinka ooninte konin ardoamadettsi ki marade. ");
INSERT INTO amf_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Eeno wul naanna burqadhayse koda eepe. Yesusaar “Eepeebhode; naano raata ko raatade, diyadehe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kediar konin diyonam yinin dhesenna, kiam ke hancade. ");
INSERT INTO amf_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kidiar naansa aanin yedayse upsi gebhika “Ya naano, dhaabhaa” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kosa sadanin maatonna saanawa kodi dhaabhidine. Yesusaar “Gala kona imee” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Naansa imbaabee indanbe targadhidine. Yesusaar “Ko yerinam haynaar giyeebhode!” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesus tabhi lamaana yisa paanan yivayna eenaam yikal eelayse, beeron wulam eendara kenin buloadettsibee burqadhaanaam kenin pacchoadettsibe kantabee hayamobe kena ki imade. ");
INSERT INTO amf_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Barjo bitamonsa upsinam eenna kenin giyoadettsibee hajadhaanaam kenin pacchoadettsibe keam ki yittsade. ");
INSERT INTO amf_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yin kena ki giyade: “Yesa goynna haljo ko hannaar, surba ko hannaar, gala ko hannaar, birre ko hannaar, yer kala hattear yenka beveebhode; shuraab lansoar beveebhode. ");
INSERT INTO amf_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Raqin hamotear birayse yeam chocchamon tiyaa ea ooninte arda ye hanna, raqin ogora yenin utenka yekka ogote dooqee. ");
INSERT INTO amf_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Eeno yeam yikal tiymino ko hanna, gurdan ogora yenin utenka, kedar tarja konin maatoadettsi yesa roondar dohon silalinam dinsee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kediar raqin ogora utayse Barjosa dhacchintan upsinam eenna giyada, hajadhaanaamaar pacchada gurdan wulir ke yaayade. ");
INSERT INTO amf_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Galila peenam wottsea Herodis ogoyn maaton wulam kidi qansidine. Kidiar waani waani eeno “Shivea Wannis diira dhaabhidine”, waani eeno “Eelias maatate ki nivade”, waani eeno “Ena birayse Barjokala qansayse eenna giyaynasa kalaa diira dhaabhidine” konin hamenna, kina dhesiman konin garonna, qothimite ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodisaar “Inta Wannissa qorcin taskidine. Ta ‘Yin kida waadadhe’ hamayse kinnon goynsa giidhea kaa kidi hayne?” hamayse kiam shedana zagite ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesus yisa tarjamonnante kinin yittsaana eenaar yinin yittsadhorra maatayse hatte, yinin waadadhon wulam Yesusna ke giyade. Kidiar yinka kebishinam entsayse Beetesayda hambhen katamansa gasandar ki yivade. ");
INSERT INTO amf_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Eenoar ogoam dhesayse Yesuskal dhaabhayse ko yivade. Kidiar yidar keam tiyayse Barjosa bitamon upsin kena giyaate ki dahade; burqora paasha keam zaskaynaamaar ki pacchade. ");
INSERT INTO amf_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Hayn ibanayse sootanna hayenka, tabhi lamaana Yesussa paanan yivayna kikal nivayse, “Ta wonin dohoono eedinin qolmontene; ogona wosa gasante dohon katamanbee gurdantebe yivayse galabee wodhinta raqbe kenin haapoadettsi eenaam yittsaa” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kidiar “Yedi kenin itsen galan kena imee” kena ki hamade. Kediar “Wodi yivayse een ko wulna gala wo shanaamma, wosa dahaana balasha dongbee kaara lamaabe bishne” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Eenaar shii dongaddhane. Yesus yisa paanan yivayna eenana “Eenaam eedi lamaa kaysa apo tabhi, eedi lamaa kaysa apo tabhi hayayse dottsee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yesussa paanan yivaynaar kena giidhondettsi eenaam ke dottsade. ");
INSERT INTO amf_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesus balashana dongnabee kaarana lamaanabeam tiyayse tura cecin shedayse Barjoam miskeka ki gobshade. Kidiar kashayse eenna kenin yeskisoadettsi yisa paanan yivayna eenana ki imade. ");
INSERT INTO amf_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Eeno wulaar itsayse ko mishade; een itsaysaka shidhoono dirmano sharqa tabhi lamaa thoothi ke dhaasade. ");
INSERT INTO amf_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yesus yimal Barjoam kinin miskenka, kisa paanan yivayna eenaar kimbesana kinka ke dahade. Kidiar “Zarsino iam hay ko hame?” hamayse keam ki oysade. ");
INSERT INTO amf_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kediar “‘Shivea Wannisne’ koda hame; waani eenoar ‘Eeliasne’, waani eenoar ‘Ena birayse Barjokala qansayse eenna giyaynasa kalaa diira dhaabhidine’ koda hame” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Yedi iam hay yeda hame?” kena ki hamade. Bhethiroosaar kina yinin maasenka, “Ya Barjoyn qadhaa Kiristoosne” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesus ogoam haynaar kenin giyoamadettsi upsi wocchika giyntaka, ");
INSERT INTO amf_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","“Inta Eedi Naas thoothi gaale tiyayda tiye; peensa donzanabee, gudullasa hayonabee, Musesa yigginam dhettsaynabe iam baga ke bage; iam deesa ko deesadhe; makkansoa rooroakaar dembhira dhaabhayda dhaabhe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yesus ke wulna yin ki giyade: “Isa paanan nivana nashea hay ki dahaannaar yinnon qaaben ki gare; yinindar ziitate deesadhen masqalinamaar rooroa rooroaka kedayse isa paanan ki nive. ");
INSERT INTO amf_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sadan yinnonam dhacchana nashea hay ki dahaannaar koam kaysa ki kayse; ina hamayse yisa sadanam kaysea hay ki dahaannaar koam dhaccha ki dhacche. ");
INSERT INTO amf_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Eedi peen kodar dohon yer wulam haapayse sadan yinnonam kaysidi ki hanna, kina har ko poote? ");
INSERT INTO amf_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Imbee isa upsinbeka ooshimbhea wul, i Eedi Naas isa gobshinbee, Imbaasa gobshinbee, Barjosa gazana gaananasa gobshinbeka inin nivenka, kanka inta ooshimbhayda ooshimbhe. ");
INSERT INTO amf_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Inta yena gon ida giye: Barjosa bitamonam yinin haapenka yekka kote woyaana eenasa shaarinte dembhi diymina eedi daane” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesus ogoam yinin giyonsa budobar rooro lankayaddha Bhethiroosbee, Wannisbee, Yayqoobbeam yinka entsate Barjoam miskota dhukandar ki utade. ");
INSERT INTO amf_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kinin miskenkaar kisa aapin kerro ko ookimade; kisa apalloar bhalqantidettsi cawli ko maatade. ");
INSERT INTO amf_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Marrato! Eedi lamaa, kediar Musebee Eeliasbe, gobshinkaar haapadhayse Yerusaalemir maatota dohon Yesus dembhinsa kimbesana kinka keda dhalqe. ");
INSERT INTO amf_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Bhethiroosbee kimbesana kinka dahaanabe gindhe keam yedonna, kedi raatidine. Kenin dhaabhenka, Yesussa gobshinbee kimbesana kinka woyayse dahaana eena lamaanabeam ke haapade. ");
INSERT INTO amf_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Eenaar Yesuskalanka edimayse kenin yivenka, Bhethiroos Yesuskal, “Imbo, raqin kote wonin dahayno wona payyane; ogona baara kalaam hana, kalaam Musena, kalaam Eeliasna hayayse baara makkam wo kee” kina ki hamade. Bhethiroos har kinin giyenam kidi dhesehe. ");
INSERT INTO amf_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Bhethiroosaar ogoam yin kinin giyenka, liilo nivayse keam ko ishkade. Liilonin keam ishkenkaar ke kurtumbhade. ");
INSERT INTO amf_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Liilonsa iir “Inin kamaa isa Naasa kaane; kina qansee” hamea upsi ko qansimade. ");
INSERT INTO amf_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Upsinin qansimonsa budonte, Yesus yimal ki daaka kiam ke haapade; kediar ogo wodanka yinin haaponam haynaar giyma lay ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Peen sedhaysaka dhukara kenin hanchenka, thoothino eeno Yesusbekal goynte ko keerade. ");
INSERT INTO amf_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Eenara eedi kala yin giyayse ki ilatade: “Woam Dhettsea, isa naasa kalaa bishne. Bannzo! Ina kiam shedaa. ");
INSERT INTO amf_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ruminin kisa dhaabhenka, ki bhocchima koda kiam ilattse; aponka kisa dubo nittsaate koda qaptinse; bishinam kisa hajinsada galshayse koda kiam gare. ");
INSERT INTO amf_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Hasa paanan yivayna beeroam kidara kenin buloadettsi keam inin miskenka bulana damadehe” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesusaar kena yinin maasenka, “Yedi idar woylamin qajimina, bhocchinka yesa wobaana adhadhinato, hamaaka yekka yembesana ida dee? Yena hamaaka yekkay darsho? Hasa naasaam kote bavaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Naasaam Yesuskal entsate kinin nivenka rumaa peendar kiam dhabayse ki qaptisade. Yesusaar beeroam ki bitade. Naasaamaar pacchayse imbaana kiam ki imade. ");
INSERT INTO amf_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Eeno wul Barjosa gebhon kantanam yinin shedenka kodi targadhidine. Eeno wulaar Yesusin waadadhon wulka targadhayse ko daaka, Yesus yisa paanan yivaynana ");
INSERT INTO amf_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Inin yena giyen koam yesa woylaminka bhocchee: I Eedi Naasaam eensa aaninte saskate iam koda imbhe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kisa dhalqino kena ardima aachi dhalq kekal konin maatonna, kedi ogo kinin giyenam bhocchadehe; yerin ogosa kiam oysanaar ke kurtumbhade. ");
INSERT INTO amf_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesussa paanan yivaynaar “Wosa iira sagi maatea hayne?” hamayse palime ke yedade. ");
INSERT INTO amf_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesus kesa woylaminsa qaabenam dhesayse naasi kalaam bavayse yikal ki woysade. ");
INSERT INTO amf_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Yin ki giyade: “Naasa kaam isa naabenna hamayse tiyea iam ki tiyade; iam tiyear iam nittsaam kida tiye. Yesa shaarira wuldara tokea kidi sagia eane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Wannis Yesusna “Imbo, eedi kalaa hasa naabenka beeronaam kinin bulenka kiam wo haapade; wombesana kinka kinin dahaamonna, kiam wo marade” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesusaar “Yeam jibbimina wul yembesana kinka kenin dohonna, kiam mareebhode” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesus cecindar kinin yiven wodan yeskaysaka Yerusaalem yivima shidhattine hamayse ki dhaabhade. ");
INSERT INTO amf_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yisa birantear ergen eenaam ki yittsade; kediar raq kina ashkota Sammaria peente dohon gurda kallondar yivayse ke ardade. ");
INSERT INTO amf_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Yesus Yerusaalem kataman kinin yivenam kenin dhesenna, gurdan ogote dahayna eena kiam tiyana nashadehe. ");
INSERT INTO amf_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kisa paanan yivayna eenara Yayqoobbee Wannisbe ogoam yinin haapenka, “Imbo, Eeliasin hayondettsi cecira nuu hanchayse keam ko koqe wonin hamoadettsi ya nashaa nasho?” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesusaar ora kedar wal hamayse keam ki wacimade. “Yedi hamin dohon manpaskalanka yenin dohonam dhesattene. ");
INSERT INTO amf_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","I Eedi Naasin nivoono eenaam dhacchanane; kaysana nivaatine” ki hamade. Ogora dhaabhayse gurda abdar ke yivade. ");
INSERT INTO amf_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yesusbee kisa paanan yivayna eenabe goynka kenin yivenka, eedi kalaa “Inta hanin yiven hamote ko hannaar, hasa paanan yivayda yive” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesusaar kina yi giyna: “Shedaa! Gaamirenasa kenin wodhea kesa oolo daane; aptinasaar ooni daane; i Eedi Naas meten innon inin daasea raq isa qolehe” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesus ea waanaar “Isa paanan nivaa” kina ki hamade. Kidiar “Imbo, birayse imbaam duukayse inin nivoadettsi iam yittsaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesusaar “Shedaa! Diyaana diyaanaam kenin duukoadettsi kena garaa; ya yivayse Barjo bitamonsa upsinam eenna giyaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ta pir eedi kalaa “Imbo, inta hasa paanan yivayda yive; ko dahaannaar birayse oonin innon eenana elqimayse inin maatoadettsi iam yittsaa” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesus “Haamin koysanna irpin aaninka yedayse budoka maatate shedea ea Barjosa bitamonna maateatehe” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ogosa budonte Imbaa wontea Yesus tabhi lamaana kisa paanan yivayna eenadar eedi makkam kaysa apo tabhi lamaa waani eenaam ki kamade. Kidiar yina yivota yinin qaabaana katamanabee ranqa wulbedar lamaa lamaa hayayse yisa birante keam ki yittsade. ");
INSERT INTO amf_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yin kena ki giyade: “Buuradhayno isinno thoothine; buurayna eena tokaane. Ta keeda isininsa Imbaa buurayna eenaam haamindar kinin nittsoadettsi kiam miskee. ");
INSERT INTO amf_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Marrato! Inta yeam yaanadettsi yaayonasa shaarinte ida yittse; ta keeda yivee. ");
INSERT INTO amf_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Birre yedea korbhobee, surbabee, dunnguribe yenka beveebhode; goynka yenin yivenka haykalar nagaysite kappeebhode. ");
INSERT INTO amf_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Onna yenin ardayna wulir, birayse ‘Payyamo oonin kona ko dee’ hamayse kena giyee. ");
INSERT INTO amf_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Oonin ogote payyamon nashea eedi daa ki hanna, yesa payyamono kina payya koda maate; yintay ko hamma yesa payyamono yedar koda maate. ");
INSERT INTO amf_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Waadadheana damooz kasha ko kashadhe. Ogona oonin ogote yena kenin imenam itsadabee wucadabe kembesana kinka dooqee; oonin waara oonin waadar yaayeebhode. ");
INSERT INTO amf_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Yenin arden kataman wulir eenin yeam tiyayse yena kenin imenam itsee. ");
INSERT INTO amf_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Raqin ogote hajadhaana wulam pacchee; eenna ‘Barjosa bitamono yekal theedidine’ hamayse kena giyee. ");
INSERT INTO amf_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ko dahaannaar yenin arden katamante eeno yeam ko tiyaamma, kataman ogosa goynadar utayse, ");
INSERT INTO amf_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Kataman yennora wosa roondar yedoono silallo tarja yena konin maatoadettsi yena woda dinse; Barjosa bitamono yekal konin theedonam dhesee’ kena hamee. ");
INSERT INTO amf_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yena yin ida giye: Pirdin rooroaka kataman ogora Sodoomdar yeskayno pirdino tokaane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ogora Yesus yin ki giyade: “Korazin katamante dahaana eenato, yedi hay! Beetesayda katamante dahaana eenato, yedi hay! Yekal haydhoono tarshayno waadimano Thiroosbee Sidoonaber haydhada hatte ko hanna, siyinna goobintonam yidara yiikayse dibiniar dumate yisa metendar kahayse ena wodda seeson waadimanam yisa garayse Barjodar maatidi keda dee. ");
INSERT INTO amf_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pirdin pirdadhenka yedar yesken pirdindara Thiroosbee Sidoonabedar yeskayno pirdino tokaane. ");
INSERT INTO amf_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“Ta yedi Qipirnaahoom katamante dahaana eenato, tura cecindar dheg dheg hamo ye qaabaa? Yin dayma mia diyaana eenayn dohon raqindar yedi hancheeda hanche” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Pir yinin yittsaynakal “Yena qansea ina kida qanse; yeam bagea iam kida bage; iam bagear iam nittsaam kida bage” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Eedi makkam kaysa apo tabhi lamaana eena Yesusin keam yittsorra wozaka maatate ke nivade. Yesusnaar “Imbo, beeronaar hasa naabenka wona ee hamidine” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesusaar kena yin ki giyade: “Seethaan cecira bhalqantidettsi kinin dhambenka kiam i haapade. ");
INSERT INTO amf_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Marrato! Gunibee qolpobeam yenin tigoadettsi, yesa banqin eenaam yenin bashen hayamo yena inta imidine. Yeam kaamea yer qolehe. ");
INSERT INTO amf_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ko dahaannaar beerona yena ee kenin hamenna wozadheebhode; yesa naabenin cecinte dohon warqatinte thaapadhonna wozadhee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ogo wodanka Yesus Manpas Gazanka wozadhayse, “Cecinbee peenbesa Imba maataa Imbo, ko yerinam eena pakallabee yerin dhesaanabekalanka aachayse naana likkanana hanin dhohonna haam ida gobshe. Gonne, Imbo, yin hayana hasa payya qaabe ko maatade. ");
INSERT INTO amf_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Yer wulam Imbakalanka ina imbhidine. Barjo Imbaakalanka ab Barjo Naasa hay kinin dohonam dhesea hayyear qolehe. Ogodettsi Barjo Naasabee Naasa yinti dhaana kinin zagaana eenabekalanka ab Barjo Imba hay kinin dohonam dhesea hayyear qolehe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yesus yisa paanan yivayna yimal ke daaka kekal maatayse, “Yenin shedenam shedayna eena gobshadhaanane. ");
INSERT INTO amf_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Inta yena gon ida giye: Thoothina Barjokala qansayse eenna giyayna eenabee binnabe yenin shedenam shedana keda zage, ko dahaannaar shedadehe; yenin qansenam qansana keda zage, ko dahaannaar qansadehe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Marrato! Eedi kalaa Musesa yigginam dhettsea Yesusam taysate shedana dhaabhayse, “Woam Dhettsea, rooro wul lay dehen sadanam haapana yer har i hayo?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesusaar “Musesa yigginte thaapadhoono hare? Ogoam hanin nabbabenka haraa bhocchaa?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ear kina yi maasina, “‘Ya Imbaa hantea Barjoam gonin hamon woylaminka, gonin hamon sadanka, gonin hamon kantanka, gonin hamon qaabenka kiam nashaa; ha aanantaam hadettsi hayayse nashaa’ koda hame” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesusaar, “Gonaa giyade; yinaa hayna rooro wul lay dehen sadanam hada haape” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ea yiam tipa hayana zagayse Yesusna “Isa aananta kidi hayne?” hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesus maasayse kina yin ki giyade: “Eedi kalaa Yerusaalemra Iyarko kinin yivenka, eena eensa koymon buurate itsayna kiam haapayse, kisa apalanam kidara bulayse kiam yinin qanonsa budonte, ea diyanna kinin hayenka garayse kiam ke yivade. ");
INSERT INTO amf_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Dhesima gudul kalaa goyn ogoka ki nivade; eamaar shedayse ki sagade. ");
INSERT INTO amf_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ogoraar tapir Lewi eedi kalaa goyn ogoka kinin nivenka kiam shedayse ki sagade. ");
INSERT INTO amf_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Sammaria eedi kalaa goyn ogoka nivite eam shedayse kina ki burqadhade. ");
INSERT INTO amf_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Eakal theedayse waqatibee woynea hattasa aapin cuubadhonbeam kisa hajimindar qadhayse apalaka ki dhaxade. Yisa ukuliadar kiam bulayse shonnayn wodhen raqindar tiyate yivayse kiam payya hayayse shedaate ki wodhade. ");
INSERT INTO amf_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Peen sedhaysakaar birre lamaa bulayse shonnayn wodhen ooninsa imbaana imayse, ‘Ea kaam payya hayayse shedaa; ogora inta nivayse hanin kina bulon koymon wulam hana kashayda kashe’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Ta keeda igina makkamma eenasa koymon buurite itsaynayn qanate dhabaasa kina aanamo maataa hakal hamaa ki maate?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Kidiar “Kina burqadhayse kiam kelshaane” ki hamade. Yesusaar “Yaar yivayse yin hayaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesus yisa paanan yivaynabesana kinka goyti yivite gurda kallonte ke yeskade. Raqin ogote Marta hambhayno maa kallo yisa oonindar keam ko tiyade. ");
INSERT INTO amf_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mayriyam hambhayno kosa indanaas kallo ko dahade; kodiar Imbaa wontea Yesussa roon demente dooqayse kinin giyen dhalqinam qansite ko dahade. ");
INSERT INTO amf_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martaar waadimanin kodar thoothenka os ora hamada ko qajadhade. Yesuskal theedayse, “Imbo, indanaano waadiman wulam idar ko garaysaka inin waadadhenka koam haapayse ya lay ha hamo? Ogonante iam konin kelshoadettsi kona giyaa” kina ko hamade. ");
INSERT INTO amf_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yesusaar kona yinin maasenka, “Marta, Marta, yer thoothi qaabite hada gaale. ");
INSERT INTO amf_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ko dahaannaar yer zaskea kalaa bishne. Mayriyam yer payyanam ko kamade; ogoamaar kokala tiidhehe” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yesusaar raq kalaate Barjoam miskite ki dahade. Misken ki macchaysaka kisa paanan yivaynasa kalaa, “Imbo, Wannis yisa paanan yivaynaam Barjoam miskadhen keam kinin dhettsondettsi, yaar hamin wonin miskenam woam dhettsaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesusaar “Barjoam yenin miskenka yin giyayse miskee: ‘Cecinte dahaa Imbaa wontea, nammo hasa ko gazisadhe; bitamono hanno ko nive. ");
INSERT INTO amf_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Wona zasken galanam rooroa rooroaka wona imaa. ");
INSERT INTO amf_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Woam seesaynana wonin garendettsi, wonnon seesonamaar wona ya garaa. Siyondar arsota taysayno wodar konin nivoamadettsi woam gishaa’ hamayse miskee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Ogora Yesus kena yin ki giyade: “Yesa iira eedi nashoysa dahaa sootin kiaddha laman kisa oonindar yivayse, ‘Isa nashoa, bannzo! Isa eedi nasho kalaa goytibar ikal ki nivade; kina inin imea gala ikal qolehe. Gala hasa daana ina imaa’ kina kinin hamenka, ");
INSERT INTO amf_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ta keeda ea agaa ooninte dooqayse, ‘Iam galshaabhode! Inta kerin diithidine; isa naanaar imbesana raatidine; dhaabhayse hana imana damattine’ kina hamok? ");
INSERT INTO amf_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kisa nashoa yinin dohonna dhaabhayse kina imana yi zagaammaar, miskite kinin galshenna dhaabhayse kinin zagon wulam kina ima ki ime ida hame. ");
INSERT INTO amf_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ogonante yena ida giye: Miskee, yena imbha ko imbhe; zagee, haapeeda haape; kerinam kokkee, yena buldha ko buldhe. ");
INSERT INTO amf_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Harrna hambhidianna, miskea wul tiya ki tiye; zagear haapa ki haape; kerinam kokkeanaar kerro buldha ko buldhe. ");
INSERT INTO amf_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Yedi ta imba dahayse yesa iira eedi kalaa naasa kintea kiam balasha kinin miskenka, seeni kina ima ki imo? Kaara kinin miskenka, kaaran oolonte guni kina ima ki imo? ");
INSERT INTO amf_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Bhula kinin miskenka, qolpo kina ima ki imo? ");
INSERT INTO amf_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ta keeda yedi siyana dahayse yesa naanana yerin payyan iman ye dhesidianna, cecinte dahaa Imbaa yentea kiam miskaynana Manpas Gazanam yedara sagi hamin ki imimine?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesus beeronin apo kaysa eedi kalaadara beeroam bulite ki dahade. Beeroar eadara utonsa budonte, ea apon dhalqima dhalqan ki yedade; ogona eenoar targadhidine. ");
INSERT INTO amf_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ko dahaannaar kesa iira waani waani eena “Beeronaam kinin bulayno beeronasa hayoa Bevelzebulsa kantankane” ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Waani eenoar kiam taysate shedota zagayse Barjokalanka tarshea milkit kena kinin dhoadettsi zagite ke dahade. ");
INSERT INTO amf_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kidiar kesa qaabonam dhesayse kena yin ki giyade: “Bita kalaasa eena kinka kikalanka edimidi ke hanna, bitamono kisa kaya ko kaye; oonin kallon eena kinka kikalanka edimidi ke hanna, onno ogono kottsima ko kottsime. ");
INSERT INTO amf_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Inta beeronasa hayoa Bevelzebul kantanka inin beeronaam buleadettsi yeda giye. Seethaan taar kinka kikalanka edimidi ki hanna, bitamono kisa hamin ko woye? ");
INSERT INTO amf_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Beeronaam inin bulayno Bevelzebul kantanka ko hanna, ta eena yenna beeronaam hay kantanka ke bule? Ogonante kedi yedar pirda ke pirde. ");
INSERT INTO amf_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Inta beeronaam inin bulayno Barjosa kantanka ko hanna, ta keeda Barjosa bitamono yekal nividine hamintane. ");
INSERT INTO amf_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Kantanka dahaa eedi kalaa banqibee lonngabe yedayse oonin yinnon toolea ki hanna, onno kisa burdhehe. ");
INSERT INTO amf_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ko dahaannaar kidara sagea nivayse kiam bashidianna, kinin woylamin qajaana banqin koymonaam kikalanka tiyayse kisa koymonam buurayse een waanina kasha ki kashe. ");
INSERT INTO amf_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Imbetetay hama hayyear iam jibba ki jibbe; imbete kinka kamima hayyear thar thar kida haye” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesus pir “Beero eeddara yinin uton wodanka, ukunse raq zagayse noqoyn qolmon raqinte kida yaaye; ko dahaannaar ukunse raq haapehe. Ogona ‘Inin uton oonindar isa maatate ida yive’ kida hame. ");
INSERT INTO amf_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Maatate kinin nivenka, ooninam sahate ashkadhon kida haape. ");
INSERT INTO amf_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ogora yivayse yidara kalon sagaana waani tobbhaana beeronaam yinka entsate nivayse easa iinte ardayse keda dee. Ogonante ea agaasa dayntano ena hamora kattsi siyane” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesus ogoam kinin giyenka, maa kallo eenasa iira upsi gebhika “Haam adhayse amin qooshoono handa hamin gobshadhoonone!” kina ko hamade. ");
INSERT INTO amf_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesusaar kona “Gobshadhaana Barjosa upsinam qansayse toolaynane” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Eeno Yesuskal nivada thoothaate konin yivenka, kona yin ki giyade: “Wodan koka dohoono eeno siyonone; kodi tarshea milkit shedana koda zage. Ena Barjokala qansayse eenna giyea Yoonaassa milkitira milkit ab kona haydhehe. ");
INSERT INTO amf_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ena Yoonaas Nenewe katamante dohon eenna milkit kinin dohondettsi, yin inta Eedi Naasiar wodan koka dohon eenna milkit ida maate. ");
INSERT INTO amf_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Hayn utensa mizaqimbar dohon peensa binno ko wodanka dohon eenbesana kinka dembhira dhaabhayse pirdin rooroaka kedar koda pirde; harrna hambhidianna, kodi Bitaa Solomoon yisa pakalmakkonka kinin giyenam qansana peensa gasara ko nivade. Marrato! Solomoondara sagea ea kote daane. ");
INSERT INTO amf_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Ena Nenewe katamante dahaana eenaar pirdin rooroaka, wodan koka dohon adhadhinbete dhaabhayse kodar keda pirde. Harrna hambhidianna, Nenewe katamante dohon eenna Yoonaas Barjosa upsinam kinin giyenka qansayse seeson waadimanam garayse Barjodar ko maatade. Marrato! Yoonaasdara sagea ea kote daane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ogora Yesus “Shaakanam shashkayse aachea way daran yer guupea eedi qolehe. Ooninte ardaynana konin shaakoadettsi dheg hamon raqindar kida wode. ");
INSERT INTO amf_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Hasa bishinsa shaakano aapine. Aapino hanno payya konin dohonna, hasa bishino wul shaakante koda dee. Aapino hanno hajidi ko hanna, hasa bishino wul thipante koda dee. ");
INSERT INTO amf_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ta hadar dohoono shaakano thipa konin maatoamadettsi mete hasaam gishaa. ");
INSERT INTO amf_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ta keeda hasa bishino wul thipa yindar qolmino shaakaka dohoono ko hanna, bishino hasa wul shaaka yindar kattsi shaakayno koda maate” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesus ogoam kinin giyonsa budonte Parisa eenasa shaarira eedi kalaa gala yikal kinin itsoadettsi kiam ki eelade. Kidiar kisa ooninte kummanna ardayse ki dooqade. ");
INSERT INTO amf_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yesus galan yinin itsensa birayse yisa aaninam kesa dambindettsi kinin shiidhaamonam Parisa ea haapayse ki targadhade. ");
INSERT INTO amf_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ogonante Imbaa wontea Yesus kina yin ki giyade: “Ta yedi Parisa eena galan yenin itsen sharqanbee karambhanbesa zulonam payya hayayse yeda shive; ko dahaannaar iinka yesa saribee siyamobe thoothidine. ");
INSERT INTO amf_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yedi kina malgimmato, zulonam pijaa Barjo iinaam pijadaa? ");
INSERT INTO amf_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ko dahaannaar sharqanbee karambhanbesa iinte dohonam qambhinana imee. Ogosa budonte yer wul yena payya koda maate. ");
INSERT INTO amf_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Yedi Parisa eenato, hay! Harrna hambhidianna, mayante yenin yiithaana basibilabee thaltinabe, yerra likkana woothin dheeshana wulsa iira shiishima tambhasa iira kalaam Barjona yeda ime; tipan pirdinbee Barjoam nashintanbeam yeda gare. Ko dahaannaar waaniam yenin hayenka kinaam garinta yeam zaskehe. ");
INSERT INTO amf_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Yedi Parisa eenato, hay! Harrna hambhidianna, Ayiwd eensa bukin raqinte gobshadhon borkotondar dooqotabee gabante gobshadhon gisimenam gisimbhotabe yeda nashe. ");
INSERT INTO amf_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Milkitinsa qolmina duukinaam yenin maatonna hay! Eeno dhesima igina duukinadar koda yaaye” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Musesa yigginam dhettsayna eenasa eedi kalaa kina yi giyna: “Woam Dhettsea, yin hanin giyenka woamaar kembesana ha iirade” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesus kina yin ki giyade: “Yedi taar Musesa yigginam dhettsayna eenato, hay! Dethan basken eenaam baskisayse yedi yena baskenam aansa surkenka hattear kaamattene. ");
INSERT INTO amf_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ena eykena yennayn deesaana Barjokala qansayse eenna giyaynasa duukindar seenin bunkaate yenin ashkenna yena hay! ");
INSERT INTO amf_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ta keeda yedi eykena yenna waadiman yeda tarje; kesa waadimanamaar keedhayse yeda waadadhe. Kedi keam ke deesade; yedi kesa duukinam yeda ashke. ");
INSERT INTO amf_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ogonante Barjo yisa pakalmakkonka yin ki giyade: ‘Ikala qansayse eenna giyaynabee isa tarjamonnante inin yittsaynabeam kedar yittsayda yittse; kesa waaniam deesa ke deese, waaniamaar oyta ke oyte’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ogonoar peen pijadhorra yedayse Barjokala qansayse eenna giyayna eenasa zombhino wodan ko eeno pirdin wodanka oysa ko oysadhe. ");
INSERT INTO amf_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Inta yena ida giye: Aabeelsa zombhira yedayse Barjona marshan daran machadhen raqinbee Barjosa gazan ooninbesa shaarinte deesadhaa Zakkariassa zombhinka yekka, wodan ko eeno gon pirdin wodanka oysa ko oysadhe. ");
INSERT INTO amf_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Yedi Musesa yigginam dhettsayna eenato, hay! Timmirinsa kerin bulen qulpinam ye tiyade; yedi yenaar gidir ardeetene, ardanna zagaynaamaar ye marade” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Yesus raqin ogora yivota kinin dhaabhenka, Musesa yigginam dhettsaynabee Parisa eenabe kattsi kiam yinin jibbenna, kisa dhalqinka kiam yedota thoothi kiam dhattsan ke yedade. ");
INSERT INTO amf_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ogo wodanka thoothino eeno Yesuskal ko bukade; eensa thoothamora dhaabhoono kinka kiam kiam tigada koda kupime. Yesus birayse yisa paanan yivaynana yin ki giyade: “Parisa eenasa irshora mete yesaam gishee; ogonoar kesa maltamora pegadhee isa hamintane. ");
INSERT INTO amf_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Aachimayse may maatima, aachadhaysakaar dhesima shidhea yer qolehe. ");
INSERT INTO amf_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ogonante aachika yenin giyoono wul may koda qansime; ooninsa gulinte hashkimeka qaaminte yenin giyaynoar eensa shaarinte may koda ooshadhe” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesusaar “Ye isa nashonana yin ida giye: Yesa waanam deesayse yer ab hayana damiminana kurtumbheebhode. ");
INSERT INTO amf_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ko dahaannaar inta hayna kurtumbha yeam konin zaskenam yena ida giye; ogonoar yinin deesonsa budonte, lay dikimon nuunte dhabana hayamoysa dahaa Barjoam kurtumbhee. Bannzo! Kiam kurtumbhee ida yena hame. ");
INSERT INTO amf_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Aptina suutana dongnam santup kalaadar shanshadhitetayu? Aptina iginasa iira kalaam hattear Barjo walehe. ");
INSERT INTO amf_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Meten yennonsa sitin wulam shiishima Barjo paydidine. Ogonante yedi kurtumbheebhode; aptina suutana thoothinadara yedi sageeda sage” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yesus pir “Yena yin ida giye: Een birante isa tarjea wulna inta Eedi Naasiar Barjo gaananasa birante kina tarjayda tarje. ");
INSERT INTO amf_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Een birante ‘Inta Yesus eeditehe’ hamayse giyeana intaar Barjo gaananasa birante ‘Kidi inti eeditehe’ ida hame. ");
INSERT INTO amf_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“I Eedi Naasdar siya giyea wul kisa seesonam kina gardha ko gardhe; Manpas Gazanam iirea ki hanna kisa seesonam kina gardhehe. ");
INSERT INTO amf_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Eena Ayiwd eensa bukin raqintebee, peen wottsaynakalbee, hayonasa birantebe pirdinna yeam yedayse kenin yivenka, ‘Hamino palimo? Yer haroo giyo?’ hamayse qaabeebhode. ");
INSERT INTO amf_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Harrna hambhidianna, giyana yeam zaskenam ogo wodanka Manpas Gazano yena giya ko giye” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Eensa shaarira eedi kalaa Yesusna “Woam Dhettsea, imbasa koymora ina kinin kashoadettsi iishimna giyaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesusaar “Ya ea kaa, yesa shaarinte pirdin pirdeabee koymon kasheabe hayayse iam wodaa hayne?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Maasayse eenana yin ki giyade: “Eensa sadano koymo thoothamokatehe. Ogonante yeam toolee; anngarma wulra mete yesaam gishee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ogora kamsika kena yin ki giyade: “Eedi wodimo kalaasa haaminte isin thoothi ko ushade. ");
INSERT INTO amf_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kidiar ‘Isinin koam inin kehea kono isa qolmonna hamin i hayo?’ hamayse yisa woylaminka ki qaabade. ");
INSERT INTO amf_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","‘Yin ida haye: Isa konnaam kottsayse ab kono worki ida woyse; ogote isa isininbee waani koymonbeam kesa iir ida kee. ");
INSERT INTO amf_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Innon sadanna “Isa sadano, thoothi levena maatea koymo thoothi i pucchade. Ta keeda ukunsaa, itsaa, wucaa, wozadhaa” kona ida hame’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Barjoar ‘Ya kaa malgimea, kina sootin hasa sadanam hakalanka tiidha ko tiidhe; ta ogo hanin pucchoono wul hayna koda shidhe?’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yinaqa peendar koymonam pucchada Barjosa birante qambhi dahaa eedi ea wodimoa agaadettsi kida maate” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesus yisa paanan yivaynana yin ki giyade: “Ogonante yena ida giye: Yesa dayntanna ‘Haroo itso? Haroo qaadho?’ hamayse qaabeebhode. ");
INSERT INTO amf_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Harrna hambhidianna, galara dayntano, apalara bishino saga ko sage. ");
INSERT INTO amf_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ayronaam shedee; kedi bheeta yiithehe, shikaar shikehe, konoar kesa qolehe. Ko dahaannaar Barjo keam kida kunse. Ta yedi aptinadara hamaddha yenin sagenam bhocchee! ");
INSERT INTO amf_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Yesa iira qaabayse leven yinnondar rooro kalaa arsea eedi hayne? ");
INSERT INTO amf_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Yerin likkonam yemal hayana ye damaamma, ta keeda yerin waaniam harrnee qaabe? ");
INSERT INTO amf_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Aamana hamin kenin gebhenam shedee; kedi waadimaka qajadhehe, puttoar qanehe. Ko dahaannaar yena ida giye: Ena Bitaa Solomoonaar yisa gobshin wulka igina aamanasa kalaadettsi hattear goobadehe. ");
INSERT INTO amf_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Barjoar kina haapadhayse saka nuunte yiam koqadhayna peendar dahaana shundhaam yin gobshayse qattsea ki hanna, ta yedi Barjodar woylamin qajadhen joogaanato, yeam hamin saskayse ki qattsimine? ");
INSERT INTO amf_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Ta ‘Wodi haroo itso? Haroo wuco?’ hamayse qaabeebhode. ");
INSERT INTO amf_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ogo wulam haapota Barjoam dhesimino eeno koda zage. Ogono wul yeam konin zaskenam Imbaa yentea dhesa ki dhese. ");
INSERT INTO amf_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Yediar kisa bitamonam zagee; ogono wul yena imbha ko imbhe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yesus yi giyna: “Yedi tokaa maataana eenato, Imbaa yentea yisa bitamonam yena imana kinin nashonna kurtumbheebhode. ");
INSERT INTO amf_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yesa dohon koymonam shanshayse birrenam qambhinana imee; diibiyn yeskimon, ulavulonin itsimon cecinte maqa maqimin gecchar gecchiminte koymo yenante wodee. ");
INSERT INTO amf_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Harrna hambhidianna, koymonin yesa dohonte woylammoar ogote koda dee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yesusaar kena “Apala karnante orgo dhaximbhaana maatee; yesa shaakanoar shaakoono ko dee. ");
INSERT INTO amf_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Yedi yisa imbaa gaydon oonira maatate nivayse kerinam kinin kokkenka, saana kina bulota toolayna waadiman eena maatee. ");
INSERT INTO amf_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Igina yisa imbaanin niven wodanka, wocchimbhayse toolite ke daaka kinin haapayna waadiman eena gobshadhaanane. Inta yena gon ida giye: Kidi apalan orgo dhaximbhayse kummandar keam dottsayse keam kida kunse. ");
INSERT INTO amf_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Sootin kiaddha laman nivayse keam kinin shedenka, wocchimbhayse dahaana waadiman eena gobshadhaanane. ");
INSERT INTO amf_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ko dahaannaar, yedi ta koam dhesee: Ea ooninsa imbaa diibiyn yisa oonindar wodaa hamaaka kinin nivenam dhesidi yi hanna, ooninsa kerin qunthadhoadettsi hayehe. ");
INSERT INTO amf_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Inta Eedi Naas yenin bhocchaamon wodanka inin nivenna, yedi taar ashkimbhayse toolee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Bhethiroosaar “Imbo, kamsin koam wo binnanaa giymoo? Een wulnaa giye?” hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Imbaa wontea Yesusaar yin giyayse kina ki maasade: “Ta keeda oonin eenaam payya hayayse ki wottsebee waadiman eenanaar galanam kena ima zaskea wodaaka kinin imoadettsibe kisa imbaa kiam kamayse kinin wodea gon hama pakala kunsea kidi hayne? ");
INSERT INTO amf_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Yisa imbaanin niven wodanka, kina giidhon waadimandar haapadhea ea kidi gobshadhaane. ");
INSERT INTO amf_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Inta yena gon ida giye: Agaa waadiman easa imbaa yisa dohon yerin wuldar wottsea hayayse kiam kida wode. ");
INSERT INTO amf_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Ko dahaannaar agaa waadiman ea ‘Imba saana nivehe’ hamayse yisa woylaminka qaabayse, waadiman eena annginabee maanabeam qanaate, pir itsadabee wucadabe bardhan ki yedanna, ");
INSERT INTO amf_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","agaa waadiman easa imbaa kinin bhocchaamon rooronbee kinin dhesaamon wodanbeka niva ki nive. Kiam kattsi kida qane; ogora ithanam kisa Barjodar woylamin qajiminabesana kida haye. ");
INSERT INTO amf_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Yisa imbaanin giyonam dhesayse ashkimbhaama, kinin giyonamaar hayaama agaa waadiman ea kattsi kida qandhe. ");
INSERT INTO amf_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yisa imbaa yinin giyonam dhesima, qandhan yiam zasken waadiman waadadhaa ea likka kida qandhe. Harrna hambhidianna, thoothi yina imbhaakalanka thoothi koda zagadhe; thoothi yina elqimbhadhakalankaar thoothi koda toldhe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesus yin ki giyade: “Peendar nuu dhabota bavate i nivade; ta keeda saana ko yedidianna hare dohoono? ");
INSERT INTO amf_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ko dahaannaar inin shiidhayno gaale shiidhime daane; ogoyn thoothenka yekka isa ukunse qolehe. ");
INSERT INTO amf_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Inta peendar payyamo hayana inin nivoono yena maata ko maato? Eenaam kikalanka edota i nivade, payyamo hayana nivaatine. ");
INSERT INTO amf_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ta keeda kaara yedayse oonin kallonte dahaana dongna eenasa shaarira makkamma lamaanadar, lamaanaar makkammadar dhaabhayse kinka kikala edima ke edime. ");
INSERT INTO amf_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Imbaa naasadar, naasaar imbaadar; indano naandar, naanoar indandar; indano naasa geshondar, naasa geshonoar aakandar dhaabhayse kinka kikala edima ke edime” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Tapir Yesus eenna yin ki giyade: “Liilono haynsa wavambar konin dohonam yenin haapenka, ‘Kina doobi qana ko qane’ yeda hame; gon qana ko qane. ");
INSERT INTO amf_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tapir jibarro hayn utensa mizaqimbar konin jibarshenka, ‘Kina peeno oydha ko oydhe’ yeda hame; gon oydha ko oydhe. ");
INSERT INTO amf_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yedi maltinato, cecinbee peenbesa milkitinam shedayse edana dameeda dame; ko dahaannaar ko wodanka maaten yerinam edana yenin damimino harrnane? ");
INSERT INTO amf_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Yedi tipan yerinam dhesayse yemal yenin pirdimino harrnane? ");
INSERT INTO amf_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Hambesana wacimaa haam bersayse peen wottseakal tiyate haam kinin yivenka, akar goynte dahayse kimbesana kinka qaashimana zagaa. Yin ha hayaamma, kidi pirdin pirdea eakal kantaka gochate haam kida yive; pirdin pirdea ear haam poolisana saskate kida ime. Poolisaar dhaxin ooninte haam kida arse. ");
INSERT INTO amf_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Inta hana ida giye: Hanka kashaa hambhon bazan wulam kashate hanin macchenka yekka, dhaxin oonira hamin ko dahaakaar utattane” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ogo wodanka Yesuskal dahaana eena waani “Galila eenasa shaarira waani waani eena Barjona marsha machayse kenin imen wodanka, Bhilathoos keam deesayse kesa zombhinam kesa marshanbesana ki worsade” hamayse kina ke giyade. ");
INSERT INTO amf_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesus kena yinin maasenka yin ki giyade: “Igina Galila eena yin kenin gaaloono Galila peen een wuldara sagi seeson waadadhaana eena kenin maatonnane hamaysee qaabo? ");
INSERT INTO amf_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Yintehe! Ko dahaannaar seeson waadimanam yesa garayse Barjodar ye maataamma, yedi wulatte yin kayeeda kaye. ");
INSERT INTO amf_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“Pir Seeloom gurdante seeninka woysadhon oonin yidar yiipaysaka diyaana eena tabhi lankayna Yerusaalemir dohon een wuldara sagi seeson waadadhaana eenane hamaysee qaabo? ");
INSERT INTO amf_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Yintehe! Ko dahaannaar seeson waadimanam yesa garayse Barjodar ye maataamma, yedi wulatte yin kayeeda kaye” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ogora Yesus kena kamsika yin ki giyade: “Eedi kalaasa haaminte kordhoono haaqa shaap kallo ko dahade. ‘Kodi aapi kaydu?’ hamayse koraa imbaa shedota kinin nivenka, kodi kala hattear aapi kaadehe. ");
INSERT INTO amf_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Haamin imbaar haamin tooleana ‘Shedaa! Hatton kosa aapi shedota ida nivika kinaka leve makkam konin maatonna, aapi kala hattear kodar inin haapaamonna, ta koam taxaa. Harrna ko haaminam gene?’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Toolea ear kina yinin maasenka, ‘Imbo, demenam kosa koyayse duba inin kehenna, taar kina leven koam garaa. ");
INSERT INTO amf_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Niven levenka aapi ushea ko hanna, payyane; ushima ko hanna, hada koam taxe’ kina ki hamade” hamayse Yesus ki giyade. ");
INSERT INTO amf_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesus ukunsen rooroaka Ayiwd eensa bukin raqinte dhettsite ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Marrato! Tabhi lankay levenka yekka beero zulo wobsaysaka dheg hamayse woyana damaammo maa kallo ko dahade. ");
INSERT INTO amf_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","13","Yesusaar koam haapayse yikal koam ki eelade. Yisa aaninam kodar wodayse, “Ya edono kono, hanin woborra ya pikidine” kona ki hamade. Saanawa kodiar dheg hamayse Barjoam ko gobshade. ");
INSERT INTO amf_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ayiwd eensa bukin raqin ogoam wottsea ea Yesus ukunsen rooroaka eenaam kinin pacchonna wacimayse, “Waadadha yeam zaskayno rooro laxne. Ta roorona iginaka nivayse paashee; ukunsen rooroaka ko dahabhoode” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Imbaa wontea Yesusaar kina yinin maasenka, “Yedi maltinato, yedi wul ukunsen rooroaka yesa wanngabee ukullabeam kenin dohon raqira bulayse noqo wusho yivattenu? ");
INSERT INTO amf_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kono edono Abraamsa muldhara dahayse, tabhi lankay levena Seethaanin koam wobsorra ukunsen rooroaka pika koam zaskayu?” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ogoam kinin giyenka kiam jibbayna wul ke ooshimbhade; kinin hayon yerin tarshen wulka eeno ko wozadhade. ");
INSERT INTO amf_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesusaar “Barjosa bitamono har ko maate? Harka koam i kamso? ");
INSERT INTO amf_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Saliithasa aapi eedi kalaa yisa haaminte kinin yiithon bheetandettsi koda maate. Kodiar haaqa gaari koda maate; aptinaar kosa antindar ooni keda woyse” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Tapir “Barjosa bitamonam harka i kamso? ");
INSERT INTO amf_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Maa kallo dhiili sharqa makkam tiyate kanka konin taapaa irshodettsine; irshono konin dhiilin taapon taapanam konin oydhoadettsi ko hayade” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesus Yerusaalem yinin yivenka katamante dahaanabee gurdante dahaana eenabeam dhettsaate yivite ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ogo wodanka eensa iira eedi kalaa “Imbo, dhaqayna eena tokaaw?” kina ki hamade. Kidiar kena yin ki giyade: ");
INSERT INTO amf_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Qiiqan kerinka ardana mashimee. Inta yena ida giye: Thoothina eena ardana keda zage; ko dahaannaar kedi damehe. ");
INSERT INTO amf_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ooninsa imbaa dhaabhayse kerinam kinin diithonsa budonte, yedi mayante woyayse, ‘Imbo, Imbo, wona bulaa!’ hante kerinam kokkeeda kokke. Kidiar yena ‘Hamora yenin nivonam inta yeam dhesattine’ hamayse yena kida maase. ");
INSERT INTO amf_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ogo wodanka yedi ‘Hambesana kinka wo itsade, wo wucade; wonin bukon raqintear woam ha dhettsade’ yeda hame. ");
INSERT INTO amf_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kidiar ‘Hamora yenin nivonam inta yeam dhesattine. Yedi kina siyon hayayna eenato, yedi wul ikalanka os pegadhee!’ yena kida hame. ");
INSERT INTO amf_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Abraambee, Yisaaqbee, Yayqoobbee, Barjokala qansayse eenna giyayna wulbeam Barjosa bitamonte yenin haapen wodanka, yedi mayante dhabadhayse yenin shidhenka, ogote eepibee atsi qiicabe koda maate. ");
INSERT INTO amf_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Peen wulra eeno nivayse Barjosa bitamonte kummandar koda dooqe. ");
INSERT INTO amf_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Marrato! Budona eenasa waani birana keda maate; birana eenasa waaniar budona keda maate” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ogo wodanka Parisa eenasa shaarira waani eena Yesuskal nivayse, “Herodis haam deesana kinin zagenna, kora dhaabhayse yivaa” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Kidiar kena yin ki giyade: “Yivayse dhalqinka uxea ea agaana ‘ “Shedaa! Kinabee sakabe beeronam eendara ida bule; hajadhaanaamaar ida pacche; makkansoa rooroaka inin waadadhenam ida macche” Yesus ki hamade’ kina hamee. ");
INSERT INTO amf_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ko dahaannaar Barjokala qansayse eenna giyea Yerusaalemra raq abir kinin diyoadettsi konin zaskimonna kinabee, sakabee, oshaalabe Yerusaalemdar yiva iam koda zaske. ");
INSERT INTO amf_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yerusaalemo, Yerusaalemo! Ya Barjokala qansayse eenna giyayna eenaam deesayno, hadar yittsadhaana eenaam seeninka paxayno! Baacha yisa naasiam kaapin demente konin yedeadettsi, intaar hasa naanaam yedana thoothi woda i zagade; ya nashaatane. ");
INSERT INTO amf_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ta keeda yesa gazan oonira Barjo utaysaka onno guuri koda shidhe. Inta yena ida giye: ‘Barjo Imbasa naabenka nivea gobshadhaane’ yenin hamenka yekka, keeda kaara os iam haapattene” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Yesus ukunsen rooroaka Parisa eenasa entsanasa kalaa ooninte gala itsota ki ardade; Parisa eena kinin hayenam toolayse shedite ke dahade. ");
INSERT INTO amf_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ogo wodanka burqoka bishiysa ettsaa eedi kalaa Yesussa birante ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesusaar “Ukunsen rooroaka eenaam pacchano Musesa yigginte giidhidimoo? Giidhadayu?” hamayse Musesa yigginam dhettsaynabee Parisa eenabeam ki oysade. ");
INSERT INTO amf_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kediar lay ke hamade. Yesus eam yedate pacchayse oonindar maasate kiam ki yittsade. ");
INSERT INTO amf_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ogora Yesus “Yesa iira yisa naasa way yisa waxa tuular wavidi ki hanna, ukunsen rooroaka saanawa gochate bulima hayne?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Dhalqin ogosa malsin maasana kedi damadehe. ");
INSERT INTO amf_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesus kummanna yiam eldhaana eena gobshadhon raqinte dooqana kenin zagenka keam shedayse, kamsika kena yin ki giyade: ");
INSERT INTO amf_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Eedi hay ki hannaar naan anzanin imbhen gaydon raqinte kummanna haam eelidi ki hanna, gobshadhon raqinte dooqaabhode; way hadara sagi gobshadhaa eldhidi daasane. ");
INSERT INTO amf_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ko dahaannaar ye lamaanaam eelaa ea nivayse, ‘Kaa raqaam ea kaana garaa’ haam kida hame. Ogo wodanka yaar gebhi ooshimbheka wuldara token raqinte hada dooqe. ");
INSERT INTO amf_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ogona haam eldhon wodanka, yivayse wuldara token raqinte dooqaa. Ogora haam eelaa nivayse, ‘Isa nashoa, kote nivaa’ haam kida hame. Ogo wodanka hambesana kinka dooqaana eena wulsa birante gobshi hana koda maate. ");
INSERT INTO amf_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yisa metenam dheg hayea wul toka ki toke; yisa metenam toskear dheg dheg kida hame” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesus kummanna eelaa eana yin ki giyade: “Rooron kummanna way sootin kummanna eenaam hanin eelen wodanka ha aanantabee, hambanaanabee, hasa muldhanabee, wodimma gurdan eenabeam eelaabhode. Ha eelidianna, kedi maasate haam eelayse hana bazanam maasa ke maase. ");
INSERT INTO amf_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ogona eenaam kummanna hanin eelen wodanka qambhinabee, aaninsa wobonabee, roonsa wobonabee, aapin kayaanabeam eelaa. ");
INSERT INTO amf_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Hana yer kenin maasea kesa qolmonna, ya gobshadhaa hada maate; eena tipana dembhira kenin dhaabhen wodanka, Barjo hana bazanam maasa ki maase” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesusbesana kummandar dooqaanasa eedi kalaa dhalqin ogoam qansayse, “Barjosa bitamonte kummandar dooqea hamin gobshadhaane!” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesusaar kina yin ki giyade: “Eedi kalaa gala gebhi baxayse thoothin eenaam ki eelade. ");
INSERT INTO amf_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kumman wodan yeskaysaka, yinin eelaanadar ‘Yerro wul ashkadhidine; keeda nivee’ hamayse kena apon giyea yisa waadiman eam kedar ki yittsade. ");
INSERT INTO amf_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Eldhaana eena wul shidhana kenin zagonna, ‘Wokal yeskimehe’ haman ke yedade. Biraar kesa ‘Haami inin shanonna, shedaba yiva iam koda zaske. Bannzo! Hakal nivana damattine’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Waa ear ‘Haami waak haaqa dong inin shanonna, keam koysate shedota ida yive. Bannzo! Hakal nivana damattine’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Waar ‘Maa inin keemonna, ikal yeskimehe’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Kisa waadiman ear maatate nivayse ogo wulam yisa imbaana ki giyade. Ogo wodanka ooninsa imbaa wacimayse yisa waadiman eana, ‘Kataman goynabee roon goynabedar saanawa yivayse qambhinabee, aaninsa wobonabee, aapin kayaanabee, roonsa wobonabeam kote keam arsaa’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Waadiman ear yinin yivorra nivayse, ‘Imbo, hanin giyondettsi i hayaysaka akar ranqo daane’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Imbaar waadiman eana ‘Isa oonin thoothoadettsi katamandar yivayna goynabee gurdan goynabedar yivayse eenin ardoadettsi hayaa. ");
INSERT INTO amf_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Inta hana gon ida giye: Igina birayse eldhaana eenasa kala hattear ogo inin ashkon galanam itsehe’ kina ki hamade” hamayse Yesus ki giyade. ");
INSERT INTO amf_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Thoothino eeno Yesusbesana kinka konin yivenka, budoka wal hamayse kena yin ki giyade: ");
INSERT INTO amf_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Imbesana nivana zagea imbaabee, indanbee, geshon yinnonbee, naana yinnabee, indanaanabee, sadan yinnonbeam idara saskayse nashea ki hanna, isa paanan nivea maatana damehe. ");
INSERT INTO amf_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yinindar ziitate deesadhen masqalinam kedayse isa budobar nivima ea isa paanan nivea maatana damehe. ");
INSERT INTO amf_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Yesa iira seeninka oonin woysota zagea ‘Koymo hamaddha ko zasko?’ pir, ‘Isa yeekea koymo daaw?’ hamayse dooqayse qaabimaa hayne? ");
INSERT INTO amf_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Ogotay ko hamma, oonin yindar woyen raqin meeshayse ooninam daran woysate macchana damaday ki hamma, haapaana eena wul ‘Kaa ea woysan yedayse macchano kiam ko bashade’ hamaate keda hance. ");
INSERT INTO amf_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Pir bit kalaa bita waabesana banqi kansana zagidi ki hanna, ‘Isa shii tabhi banqin eenaam entsayse eedi kalaa kaysa shii banqin eenaam entsea bita waabesana banqi kansana inta damaw?’ hamayse dooqayse qaabima bit hayne? ");
INSERT INTO amf_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kansana yi damimina, kansota nivea bitaadar pege ki daaka donza daran yittsayse qaashimana kida zage. ");
INSERT INTO amf_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Ta ogodettsi yesa iira eedi hay ki hannaar, yisa dohon wulam garaama isa paanan nivea maatana damehe. ");
INSERT INTO amf_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Sooqo payyane; daathan garidi ko hanna, harka ko daathisadhe? ");
INSERT INTO amf_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ogodettsino sooqono haamibee dubabena konin maatiminna, os mayante koda dhabadhe. Qansen qaamiysa dahaa ki qanse” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Gibirin kacchaynabee Musesa yigginam tooliminabe igina wul Yesusin giyenam qansana kikal keda buke. ");
INSERT INTO amf_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Parisa eenabee Musesa yigginam dhettsaynabe “Kaa ea seeson eenaam yidar tiyayse kembesanaar kinka kida itse” hamayse keda gundume. ");
INSERT INTO amf_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ogonante Yesus kamsika kena yin ki giyade: ");
INSERT INTO amf_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Eedi dong kaysa yaanaysa dahaa ea igina yaanasa iira yaati kala kaydianna, eedi oydi kaysa apo tabhi salla yaanaam qawnte garayse kayaam yinin haapenka yekka zagate yivima yesa iira hayne? ");
INSERT INTO amf_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Yinin haapen wodanka, kattsi wozadhayse yisa gelendar kida kede. ");
INSERT INTO amf_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ogora yisa ooninte yeskayse yisa muldhanabee gurdan eenabeam eelayse, ‘Kayon isa yaanam inta haapidine; ogonante imbesana kinka wozadhee’ kena kida hame. ");
INSERT INTO amf_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Inta yena yin ida giye: Ogodettsi ‘Seeson waadimanam garayse Barjodar maatee’ hambha zaskimina eedi oydi kaysa apo tabhi sal tipana eenadara seeson ea kalaa yisa seeson waadimanam garayse Barjodar kinin maatenka cecinte gebhi woza koda dee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesus yin ki giyade: “Santup tabhi yisa dohoono maa kallo igina santupinasa kalaa kaydianna, nuu shashkayse ooninam yisa sahayse yinin haapenka yekka payya zagimino maa hayne? ");
INSERT INTO amf_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Yinin haapen wodanka, yisa muldhanabee yisa gurdan eenabeam eelayse, ‘Isa kayaa santupaam inta haapidine; ogonante imbesana kinka wozadhee’ kena koda hame. ");
INSERT INTO amf_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Inta yena yin ida giye: Ogodettsi seeso eedi kalaa seeson waadimanam garayse Barjodar kinin maatenka Barjo gaananasa birante woza koda dee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Pir Yesus yin ki giyade: “Eedi kalaasa naasi lamaa ke dahade. ");
INSERT INTO amf_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Iginaranka naasa kana imbaaka, ‘Imbo, koymon hannonsa iira ina yeskaynam imaa’ kina ki hamade. Ogonante imbaar yisa koymonam naanana ki kashade. ");
INSERT INTO amf_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Rooro likkasa budonte kana yisa koymon wulam yinka tiyayse pee pege ki yivade. Ogote koymonam yer pootimondar sun ki macchade. ");
INSERT INTO amf_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Koymon wulam kinin macchonsa budonte, peen ogote kattsi daaqin utonna, kidiar gaalan ki yedade. ");
INSERT INTO amf_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ogora peen ogo eensa eedi kalaakal yivayse daan ki yedade. Ear yisa haaminte wurkupanaam kinin gishoadettsi kiam ki yittsade. ");
INSERT INTO amf_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Wurkupanayn itsen qurthonam itsayse mishana anngardhan ki yedade; ko dahaannaar ogoam hattear kina imea eedi qolehe. ");
INSERT INTO amf_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ogora yisa woylaminka eedi bardhaadettsi yinin qaaborra maatayse yin ki giyade: ‘Imbasa ooninte balashanam itsate macchima mishayna waadiman eena meemayne dahaana? Inta ta keeda kote daaqinka isa diyanone. ");
INSERT INTO amf_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Dhaabhayse imbaakal yivayse, “Imbo, Barjobee hambeam inta genidine. ");
INSERT INTO amf_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Os birantear hasa naasi inin hambhoadettsi iam zaskehe. Hanante waadadhaynasa kalaadettsi iam hayaa” ida hame’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Ogora dhaabhayse imbaakal ki yivade. Kidiar akar pege ki daaka imbaa kiam yinin haapenka, kina burqadhayse gobate nivayse yidar kiam incayse ki sunqade. ");
INSERT INTO amf_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Naasaar ‘Imbo, Barjobee hambeam inta genidine; keeda os birante hasa naasi inin hambhoadettsi iam zaskehe’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Imbaa yisa waadiman eenana yi giyna: ‘Saana apalla wulra kattsi payyan bavayse kiam qattsee; kisa aanintear worqi arsee; roontear kina dunnguri hayee; ");
INSERT INTO amf_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","durpisadhaa ootaam bavayse kina taxee. Wo itse, wo wozadhe. ");
INSERT INTO amf_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Harrna hambhidianna, isa naasa kaa diydine inin hamaa ta sadaka ki dahade; kaydine inin hamaa ta kidi haapadhidine’ kinin hamenka, kediar wozadhan ke yedade. ");
INSERT INTO amf_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ogo wodanka iishima haaminte ki dahade. Maatate ooninkal kinin theedenka, goolabee warsabesa upsi ki qansade. ");
INSERT INTO amf_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Waadadhaynasaar kalaam eelayse, ‘Ogono yer hare?’ hamayse ki oysade. ");
INSERT INTO amf_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kidiar ‘Hakana nividine; ta sadaka dahayse kinin nivonna, hamba durpisadhaa ootaam ki taxade’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ogora iishima wacimayse ‘Ooninte ardattine’ ki hamade. Imbaa mayanka utayse kinin ardoadettsi kiam ki miskade. ");
INSERT INTO amf_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kidiar imbaana yi giyna: ‘Shedaa! Koka yekka upsin hasaam garma hana inin waadadhenka inna aanammabesana kinka inin wozadhoadettsi qole anqas hattear ina imaatane. ");
INSERT INTO amf_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ko dahaannaar kaa naasa hasa koymonam maana sharmucanabesana kinka itsate macchayse kinin nivenka, durpisadhaa ootaam kina ha taxade’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Imbaa kina yinin maasenka, ‘Isa naasa, ya rooro wul imbesana kinka ha dahade; isa dohoono wul hantine. ");
INSERT INTO amf_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kaa hakana diydine hambhaa ta sadaka ki dahade; kaydine hambhaa ta kidi haapadhidine. Ogonante kattsi wozadha woam koda zaske’ ki hamade” hamayse Yesus ki giyade. ");
INSERT INTO amf_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Pir Yesus yisa paanan yivaynana yin ki giyade: “Eedi wodimo kalaasa ooninam wottsea eedi kalaa dahade. Eeno ‘Kaa ea oonin wottsea hasa koymonam kida kayse’ hamayse ea wodimoana ke giyade. ");
INSERT INTO amf_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ea wodimoa oonin wottseam eelayse, ‘Kono inin hasa qansayno hare? Keeda kaara os isa ooninam wottsea daana damattane. Ta hanin wottsenka koymonin utonbee ardonbeam hanin thaapaa warqatam ina imaa’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Wottsear yisa woylamka bhocchaate, ‘Imba inin wottsen waadimanam ikala kinin tiyenna ta hamini hayo? Haami koyayse itsana kanta isa qolay; miskayse itsano iam koda ooshinse. ");
INSERT INTO amf_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ta waadiman kora inin buldhenka, eenin onna yinnadar iam kenin tiyoadettsi inta inin hayenam dhesayda dhese’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Yisa imbaasa bazan yindar dahaana eena wulam kalaa kalaa yikal eelayse, ea biraam ‘Imbasa hanin kashayno bazano hadar dohoono meemayne?’ hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Kidiar ‘Zayt eedi dong kaysa daa idar daane’ kina ki hamade. Wottsear ‘Saana dooqayse “Eedi lamaa kaysa apo tabhine” hamayse warqatindar thaapaa’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ea lansoam eelayse, ‘Hadar meemayne bazana daana?’ hamayse kiam ki oysade. Kidiar ‘Surba eedi dong kaysa gazgo idar daane’ kina ki hamade. Wottsear ‘ “Eedi oydi kaysaane” hamayse warqatindar thaapaa’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ea wodintaar siyan wottsea easa pakalmakkonam kattsi ki shawkade. Ogonoar Barjodar woylamin qajimina eena yinna aanammabesana kesa dohon dayntanka Barjo eenakala kedi sagi pakallane. ");
INSERT INTO amf_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Inta yena ida giye: Yesa peen ko koymonin maqen wodanka rooro wul lay yenin dehen ooninte yeam tiidhoadettsi, peen ko koymonka yena payya maatayna muldhanaam zagayse haapee. ");
INSERT INTO amf_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Yer likkaka woylam yindar qajadhea eedi yer gebhikaar woylam yindar qajadhea eedi kida maate; yer likkaka siya waadadhea eedi tapir yer gebhikaar siya waadadhea eedi kida maate. ");
INSERT INTO amf_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ta peen ko koymonka woylam yindar qajadhayna ye daymina, gonin hamon koymonam yena imea hayne? ");
INSERT INTO amf_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Eedi koymoka woylam yindar qajadhayna ye maataamma, yena maaten koymonam yena imea hayne? ");
INSERT INTO amf_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Eedi kalaa bit lamaasa demente daana damehe. Harrna hambhidianna, kalaam jibbayse lansoam kida nashe; ogotay ko hamma, kalaakal theedayse lansoam kida bage. Ogodettsi Barjobee koymonbesa demente daana damattene” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Parisa eena koymo nashayna kenin dohonna, Yesusin giyen wulam qansayse kiam ke bagade. ");
INSERT INTO amf_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesus kena yin ki giyade: “Eensa birante tipana eena yeam yeda haye; ko dahaannaar Barjo yesa woylaminam dhesa ki dhese. Ogonante eedi birante gobshadhoono yerro Barjo birante bagadhoono koda maate” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yesus yi giyna: “Musesa yigginbee Barjokala qansayse eenna giyaynabe Shivea Wannis wodanka yekka giyte ke dahade. Keeda kaara os wozisen Barjo bitamonsa upsinam koda giidhe; eeno wul ogote ardota gebhi koda mashime. ");
INSERT INTO amf_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ko dahaannaar Muse yigginsa zaaka kala hattear konin shidhenna cecinbee peenbesa kayano deegane. ");
INSERT INTO amf_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Geshon yinnonam bulate yittsayse maa ab keemea wul kidi sharmucimidine; geshoayn bulon maynam keemea ea kidi sharmucimidine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Tapir Yesus yin ki giyade: “Koymo gebhika shandhen apalanam qaadhea eedi wodimo kalaa dahade. Rooro wulka yina ko agaysaka wozaka kida dee. ");
INSERT INTO amf_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Alaazar hambhea qambhi kalaa bishin yisa hajimi bish hama ea wodintasa kerinte ki raatade. ");
INSERT INTO amf_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ea wodimoayn itsenka kisa aanira diinonam itsana anngardhite ki dahade. Qaskinaar kikal nivayse kisa hajiminam keda leve. ");
INSERT INTO amf_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ogosa budonte qambhia Alaazar ki diyade. Barjosa gaanana nivayse Abraamkal kiam ke tiyade. Pir ea wodinta diyaysaka kiam ko duukadhade. ");
INSERT INTO amf_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Diyaana eenayn dohon raqinte gaalite dahayse, tura dheg hamayse Abraambee kikal dahaa Alaazarbeam pegeka ki haapade. ");
INSERT INTO amf_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kidiar ilataate ‘Imbo Abraamo, ina burqadhaa! Inta ko nuunsa iinte kattsi gaalite i dahade; ogonante yisa aaninsa surkenam noqonsa iinte arsayse isa atabhinam kinin capshoadettsi Alaazaram ina nittsaa’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraamaar ‘Isa naasa, ya sadanka dahayse payyan yerinam hanin tiyonam bhocchaa. Ogoka Alaazar siyonam ki tiyade. Ta kidi kote kinin wozadhenka, yaar ogote gaalite hada dee. ");
INSERT INTO amf_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ogo bish dayma, wokala yedar sagana zagayna kenin sagoamadettsi, yekalaar wodar eedinin sagoamadettsi yembee wombesa shaarinte geeti gebhi ko ashkadhade’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Kidiar ‘Keeda imbo, imbasa oonindar Alaazaram hanin yittsoadettsi haam ida miske. ");
INSERT INTO amf_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Harrna hambhidianna, imbasa naasi dong sadaka ke dahade; kedi ko gaalen raqinte kenin nivoamadettsi kena ki giye kiam yittsaa’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraamaar ‘Musebee Barjokala qansayse eenna giyaynabeyn thaapoono mathaapino kekal ko dahade; kedi nabbabadhaka ke qanse’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kidiar ‘Imbo Abraamo, yintehe! Ko dahaannaar eedi kalaa diira dhaabhayse kekal yivayse, “Seeson waadimanam garayse Barjodar maatee!” hamayse giydi ki hanna, kedi maata ke maate’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraamaar ‘Musebee Barjokala qansayse eenna giyaynabeyn thaapon mathaapinaam ke qansimina, diira eedi kalaa dhaabhayse ki giyaakaar kedi qansehe’ kina ki hamade” hamayse Yesus ki giyade. ");
INSERT INTO amf_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesus yisa paanan yivaynana yin ki giyade: “Eenna goa maatayno hamin ko dahaakaar nivima shidhehe; ko dahaannaar eenna goa maatea eana hay! ");
INSERT INTO amf_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Igina likkanasa iira kalaana goa kinin maatenna, deesime seeni yisa qorcindar dhaxayse bazinte dhabadhidi ki hanna, kina payyane. ");
INSERT INTO amf_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ogonante mete yesaam gishee. “Ha aanantayn haam genenka kiam wacimaa; yinnon seesora pegadhidi ki hanna kina garaa. ");
INSERT INTO amf_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Rooron kallon tobbhaa goyt haam genayse, pir hakal tobbhaa goyt nivayse, ‘Haam inta genidine’ ki hamina, kina garaa” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Imbaa Yesus yisa tarjamonnante kinin yittsayna eena “Barjodar woylam qajintanam wona thoosaa” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Imbaa Yesusaar kena yi giyna: “Saliithasa aapiaddha hama idar woylam yenin qajea yesa daa ko hanna, ‘Ya hattono kono wombhono, kaara buucimayse bazinte yivayse korimaa’ ye hamanna, yena ee hama ko hame” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ogora pir Yesus yin ki giyade: “Yesa waadima eedi kalaa haami koyea way yaati gishea dahaa ki hanna, waadimara kinin maatenka, ‘Saanawa galan kummo dooqaa’ kina hamea hayne? ");
INSERT INTO amf_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","‘Inin itsen galanam ina ashkaa; inin itsenkabee wucenkabe ya dhaximbhayse waadadhaa; ogosa budobar hada kumme’ hamayse giyaynatayu? ");
INSERT INTO amf_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Agaa waadiman eana giidhonam kinin waadadhonna, kiam wottsea shawka ki shawko? ");
INSERT INTO amf_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ogodettsi yediar yena giidhon wulam yenin waadadhon wodanka, ‘Wodi shawkadhimina waadiman waadadhaynane; wona giidhon waadiman bish wo waadadhade’ hamee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesus Yerusaalem yinin yivenka, Sammaria peenbee Galila peenbesa shaarinka ki yivade. ");
INSERT INTO amf_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Gurda kalaate kinin ardenka, tambha lamthin burqonka dahaana eena kikal hatte pegeka woyayse, ");
INSERT INTO amf_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","yisa upsinam dheg hayayse “Imbo Yesuso, bannzo! Wona burqadhayse woam pacchaane” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kidiar keam shedayse, “Yivayse yesa bishinam gudullana dhehee” kena ki hamade. Kediar goynte gudulladar yivite dahayse ke paashade. ");
INSERT INTO amf_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kesaar iira kalaa yisa burqora yinin paashonam yinin haapenka, upsi gebhika Barjoam gobshaate maatate Yesuskal ki nivade. ");
INSERT INTO amf_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kiam gobshaate yisa wotinka kisa roondar ki dhambade. Ea kidi Sammaria peen eedine. ");
INSERT INTO amf_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesusaar kina yinin maasenka, “Burqora paashaana eena tabhitayu? Ta salla eena hamote ke dahaa? ");
INSERT INTO amf_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Barjoam gobshota maatate nivaa een peen ea kaara eedi ab qolayu?” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Eana “Dhaabhayse yivaa; idar woylamin hanin qajoono haam ko dhacchade” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parisa eena Yesusam “Barjosa bitamono haa ko nive?” hamayse kiam ke oysade. Kidiar kena yinin maasenka, “Barjosa bitamono eenna haapadhen milkitinka nivehe. ");
INSERT INTO amf_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ogodettsi ‘Marrato! Barjosa bitamono kote ko dahade’ way ‘Ogote ko dahade’ yiam hambhaynotehe. Harrna hambhidianna, Barjosa bitamono ta yesa shaarinte ko dahade” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ogora Yesus yisa paanan yivaynana yin ki giyade: “I Eedi Naas rooronasa kalaam shedana yenin anngardhea woda niva ko nive; ko dahaannaar haapattene. ");
INSERT INTO amf_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Eeno ‘Marrato! Kiristoos kote ki dahade’ way ‘Ogote ki dahade’ yena koda hame; hamin ko dahaakaar kenin giyendar utayse kesa paananka yiveebhode. ");
INSERT INTO amf_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Harrna hambhidianna, cecindar dohon bhalqantinin bhalqantenka peen wuldar konin shashkendettsi, i Eedi Naasin niven wodanka yin koda maate. ");
INSERT INTO amf_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Yin ko dahaakaar birayse i Eedi Naas thoothi gaale tiyabee wodan ko eenkal bagadhabe iam koda zaske. ");
INSERT INTO amf_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ena Nohe wodanka maatondettsi, i Eedi Naasin niven wodanka yin koda maate. ");
INSERT INTO amf_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nohe gonngalante kinin ardea rooroaka yekka, eeno itsadabee wucadabe, keemadabee kembhadabe ko dahade. Kayen noqono nivayse ke wulam ko kaysade. ");
INSERT INTO amf_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Tapir ena Loothe wodanka yin ko dahade. Eeno itsaatebee wucaatebe, shanaatebee shanshaatebe, thoothi yer koraatebee ooni woysaatebe ko dahade. ");
INSERT INTO amf_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Loothe Sodoomra kinin utea rooroaka, cecira nuubee nuusa qolshinadettsinbe hanchayse een wulam ko kaysade. ");
INSERT INTO amf_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","I Eedi Naasin may haapadhea rooroaka ogodettsi koda maate. ");
INSERT INTO amf_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Agaa rooroaka ooninsa zulon utaa ea hanchayse oonira yisa yer tiyota ki ardabhoode; ogodettsi yisa haaminte dahaar budoka ki maatabhoode. ");
INSERT INTO amf_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Loothesa geshonam bhocchee. ");
INSERT INTO amf_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Sadan yinnonam dhacchota zagea wul kaysa ki kayse; sadan yinnonam kaysea wul dhaccha ki dhacche. ");
INSERT INTO amf_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Inta yena ida giye: Sootin ogoka eena kinka raataana lamaanasa kalaam tiyayse, lansoam gardha ko gardhe. ");
INSERT INTO amf_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Maana lamaana kinka deesimaynasa kallonam tiyayse, lansonam gardha ko gardhe. ");
INSERT INTO amf_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Eena haamin kallonte lamaana kinka waadadhaynasa kalaam kikala tiyayse, lansoam gardha ko gardhe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kisa paanan yivayna eenaar “Imbo, ogono hamote ko yin dee?” kina ke hamade. Kidiar kena yinin maasenka, “Yerin diyonin dohon raqinte kuthoda buke” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ogora Yesus yisa paanan yivaynana toozadhima rooro wul Barjoam kenin miskoadettsi kena kamsika ki giyade: ");
INSERT INTO amf_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Katama kalaate Barjoamaar kurtumbhima, eedinaar ooshimbhima pirdi pirdea eedi kalaa ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Taar kataman ogote maa qambhi kallo ko dahade. Kodiar pirdin pirdeakal nivaate, ‘Imbee isa wuuqan eabesa shaarinte dohon dhalqinna ina tipa pirdi pirdaa’ hamite ko dahade. ");
INSERT INTO amf_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kidiar konin giyon yerinna thoothi wodana pirdin imana nashadehe. Ogosa budonte yisa woylaminka yin giyayse ki bhocchade: ‘Barjona i kurtumbhiminaar, eedinaar i ooshimbhiminaar, ");
INSERT INTO amf_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kono mayno qambhino iam konin galshenna, kona pirdayda pirde. Ogotay ko hamma rooro wul nivayse iam koda galshe’ ki hamade” hamayse Yesus ki giyade. ");
INSERT INTO amf_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ogora Imba Yesus yin ki giyade: “Siya ea pirdin pirdeanin giyonam bhocchee. ");
INSERT INTO amf_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ta keeda Barjo kinin kamaana sootinbee rooronbe kattsi kiam miskayna eenana pirdayu? Kenin oysonam imima kappa ki kappo? ");
INSERT INTO amf_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Inta yena ida giye: Saana kena kida pirde; ko dahaannaar i Eedi Naasin niven wodanka, peen kodar dohon eensa idar woylam qajea eedi inta haapaw?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ogora Yesus “Wodi eedi tipane” hamayse meten yinnondar woylamin qajayna, een waaniam bagayna eenana kamsika kena yin ki giyade: ");
INSERT INTO amf_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Eedi lamaa Barjoam miskota Barjosa gazan oonindar ke yivade; kalaa Parisa eedine; lansoa gibirin kaccheane. ");
INSERT INTO amf_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisa ea woyayse yisa woylaminka yin giyayse ki miskade: ‘Barjo, eena waani taysaate itsaynabee, hana ee hamiminabee, sharmucimaynabee, way agaa cubboa gibirin kaccheadettsibe inin dahaamonna haam ida gobshe. ");
INSERT INTO amf_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Gaba kalaasa iir rooro lamaa itsima ida qoome; inin haapayna yerra tambha wulsa iira kalaam hana ida ime’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Gibirin kacchea yinin miskenka, pegeka woyayse tura cecin shedana zagadehe. Ko dahaannaar, ‘Barjo, i kaa seesonka dahaa ea ina garaa’ hamaate yisa aaninka sadanam ki gutade. ");
INSERT INTO amf_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Inta yena ida giye: Agaa Parisa ea daymaka, kaa gibirin kacchea Barjo birante tipamonam haapayse yisa oonindar ki maatade. Yisa metenam dheg dheg hayayna wul toka ke toke; yisa metenam toskayna wul dheg dheg keda hame” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yesus yisa aaninam kedar kinin wodoadettsi eena yisa naana likkanaam kikal keda beve; kisa paanan yivayna eenaar ogoam shedayse eenaam ke wacimade. ");
INSERT INTO amf_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yesusaar naanaam yikal eelayse yisa paanan yivaynana “Naana idar ke nive; keam mareebhode. Harrna hambhidianna, Barjosa bitamono igina naanadettsi maataana eenasane. ");
INSERT INTO amf_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Inta yena gon ida giye: Barjosa bitamonam naasidettsi maatayse tiymina wul yer hamin hambhaakaar iir ardehe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ayiwd eenasa entsanasa shaarira eedi kalaa Yesusna “Ya Payyaa Dhettsea, rooro wul lay dehen sadan haapota yer har haynta iam ko zaske?” hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesusaar “Payya ea inka harrnaa hamaa? Barjo bishkalanka ab eedisa payya hama eedi qolehe. ");
INSERT INTO amf_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Barjo yinin giyonam dhesaada dhese: Sharmucimaabhode, deesaabhode, dimmaabhode, buudamoka tarjaabhode, hambabee handabeam gobshaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ear “Igina wulam naasamora yedayse inta toolidine” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesus ogoam qansayse, “Ta yer kalaa hakalanka ki shidhade. Ogonoar hasa dohon koymon wulam shanshayse qambhinana imaa; hasa bazanam cecinte hada haape. Ogora maatayse isa paanan nivaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kidiar dhalqin ogoam yinin qansenka, eedi kattsi wodimo yinin dohonna gebhi yisa woylaminka ki atade. ");
INSERT INTO amf_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesus ea qaabonka kattsi kinin atonam shedayse, “Wodimma eenasa Barjo bitamonte ardano hamin dohoono dethane! ");
INSERT INTO amf_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ogona eedi wodimoyn Barjosa bitamonte ardenna gamaleyn marpisa pulaka utayno deegane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Dhalqin ogoam qansaanaar “Yin ko hanna, ta hayne dhaqana damea?” ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesusaar “Eedina dandimimino Barjona dandima ko dandime” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Bhethiroosaar “Shedaa, wodi wosa dohon wulam garayse hasa paanan wo nivade” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Kidiar “Inta yena gon ida giye: Barjosa bitamonna hamayse geshon yinnonbee, indanaanabee, imbaabee, indanbee, naana yinnabee, oonin yinnonbeam garaa ea ");
INSERT INTO amf_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ta peen kodar thoothi sagi tiyma garea eedi qolehe; os niven wodanka, rooro wul lay dehen sadan haapa ki haape” hamayse kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus tabhi lamaana yisa paanan yivaynaam eensa iira waana edayse kena yin ki giyade: “Marrato! Wodi ta keeda Yerusaalemdar woda yive; Barjokala qansayse eenna giyayna i Eedi Naasisa kenin thaapoono wul koda thoothe. ");
INSERT INTO amf_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ayiwdtay hamma eenana saskate ida imbhe; iam baga ke bage; iam galshaate idar pathima ke pathime. ");
INSERT INTO amf_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Iam qanayse deesa ke deese. Makkansoa rooroakaar inta dembhira dhaabhayda dhaabhe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kinin giyon wulsa kala hattear kena ardadehe. Ogono dhalqinoar kena konin aachimonna, kinin giyenam kedi bhocchadehe. ");
INSERT INTO amf_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesus Iyarko katamante kinin yesken wodanka, eedi aapi kaya kalaa yer miskaate goyn aponte ki dooqade. ");
INSERT INTO amf_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Zarsinin ogoka sagenka qansayse, “Ogono hare?” hamayse keam ki oysade. ");
INSERT INTO amf_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kediar “Naazret peen Yesus koka kida sage” hamayse kina ke giyade. ");
INSERT INTO amf_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kidiar “Dawt Naasa Yesuso, bannzo! Ina burqadhayse iam pacchaane!” hamayse upsi gebhika kiam ki miskade. ");
INSERT INTO amf_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Eensa birante yivaynaar “Ya lay hamaa!” hamayse kiam ke wacimade. Kidiar “Dawt Naasa, bannzo! Ina burqadhayse iam pacchaa!” hante ini yinin ilaterra kalon sagi ilatan ki yedade. ");
INSERT INTO amf_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesusaar woyayse yikal kiam kenin entsoadettsi kena ki giyade. Kikal ki nivaysaka, ");
INSERT INTO amf_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Hana yer har i hayea zage?” hamayse kiam ki oysade. Kidiar “Imbo, shedana ida zage” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesusaar “Aapino hasa ko shede; idar woylamin hanin qajoono haam ko pacchade” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Saanawa kisa aapino ko shedade. Barjoam gobshaate Yesussa paanan yivan ki yedade. Eeno wulaar ogoam shedayse Barjoam ko gobshade. ");
INSERT INTO amf_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesus Iyarko katamante ardayse kosa shaarinka yivite ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kataman ogotear Zekkoos hambhea eedi kala dahade; kidiar gibirin kacchayna eenasa hayobee eedi wodimobene. ");
INSERT INTO amf_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yesus hambhea hamaa kinin dohonam shedana ki zagade; kidi yisa woyntanka eedi orgo yinin dohonnabee eenin kattsi thoothonbena kiam haapana damadehe. ");
INSERT INTO amf_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yesus goyn ogoka kinin yivenna kiam shedota hamayse os birante gobate yivayse haaqa shaap kallondar ki utade. ");
INSERT INTO amf_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesusaar raqin ogote yinin yeskon wodanka, tura kiam shedayse, “Zekkooso, kina hasa ooninte haaqa iam konin zaskenna, saanawa hattorra hanchaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zekkoosaar saanawa hanchayse wozaka kiam ki tiyade. ");
INSERT INTO amf_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ogoam haapaana eena wul “Kidi seeson easa ooninte kummana ki ardade” hamayse Yesusdar ke gundumade. ");
INSERT INTO amf_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zekkoosaar woyayse Imbaa Yesusna yin ki giyade: “Imbo, isa dohon koymon wulsa iira kiaddhanam kashayse qambhinana ida ime; eedi haysaar buudamoka inin tiyaa koymo dahaa ko hanna, maasate kina adhimaka oydi goyt ida kashe” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesus kina yin ki giyade: “Kina oonin kodar dhaqinta ko nivade; kidi tapir Abraam naasine. ");
INSERT INTO amf_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Harrna hambhidianna, inta Eedi Naas kayaanaam zaganabee dhacchanabe i nivade” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Eenoar dhalqin ogoam qansite ko daaka, Yesus Yerusaalemkal kinin theedonna, eenna Barjosa bitamono saanawa konin haapadhea kena ko maatade. Ogona Yesus kamsi kalaa kena ki giyade: ");
INSERT INTO amf_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Bitamon hayamonam tiyayse maatate nivana pee pege yivaa eedi gebhi kalaa dahade. ");
INSERT INTO amf_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kidiar yinin yivensa birayse, eedi tabhi yisa waadima eedi waaniam yikal eelayse, eena iginana birre mato kalaa kalaa ki imade. ‘Maatate inin nivenka yekka, ko koymonka naggadee’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Peen eena kiam kenin jibbonna, ‘Kaa ea wodar kinin bitimoadettsi zagattone’ hamayse kisa paananka apo ke yittsade. ");
INSERT INTO amf_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Bitamon hayamonam tiyayse yinin maaton wodanka, koymon kininna imaana igina kisa waadiman eena hamaddha kenin naggadayse thoosonam dhesana yikal keam ki elsade. ");
INSERT INTO amf_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Biraa ea kikal nivayse, ‘Imbo, hanin ina imon koymonka naggadayse tabhi goyt i thoosade’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Imbaar ‘Ya payyaa waadiman ea, payyaa hayade; yer likkaka woylamin yinindar qajadhea eedi maatayse hanin haapadhonna, tabhi katamanadar haam ida haynse’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Lansoar kikal nivayse, ‘Imbo, hanin ina imon koymonka naggadayse dong goyt i thoosade’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Imbaar kina yi giyna: ‘Haamaar pir dong katamanadar ida haynse’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Waar waadiman ea nivayse, ‘Imbo, hanin ina imon koymonam ochate i wodade; kosha. ");
INSERT INTO amf_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ya eedina burqadhima eedine; hanin wodaamonam tiyeabee yiithima buureabene. Ogonante haam kurtumbhayse i wodade’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Imbaar kina yin ki giyade: ‘Ya siyaa waadiman ea, hasa dhalqinka hadar ida pirde. Inta wodima inin tiyenbee, yiithima inin buurenbee, eedina inin burqadhimonbeam ha dhesidianna, ");
INSERT INTO amf_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","harrnaa isa koymonam adhimanka maasaynana iman garaa? Inta nivayse isa koymonam adhimaka ida tiye’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ogote woyaana eenana, ‘Koymonam kikalanka tiyayse tabhi goyt thoosaa eana imee’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Kediar ‘Imbo, birre shii kisa daane!’ kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Imbaar, ‘Inta yena ida giye: Yisa dahaana daran arsayse kina imbha ko imbhe; yisa qolmakalanka kisa dohonam kikala tiidha ko tiidhe. ");
INSERT INTO amf_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ko dahaannaar kedar inin bitimoadettsi zagimina igina iam jibbayna eenaam kote bavayse isa birante keam deesee’ ki hamade” hamayse Yesus kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesus kamsin ogoam yinin giyonsa budonte, Yerusaalem yivite yisa paanan yivaynasa birante ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Dabirezayt hambhen dhukansa gasante dohon Betepaagebee Bitaaniabe gurdankal yinin theeden wodanka, yisa paanan yivayna eenasa lamaanaam yin giyayse keam ki yittsade: ");
INSERT INTO amf_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ogo yesa birante dohon gurdandar yivimate. Ogote yenin ardenka, eedin yindar dooqate shedaama ukulisa ooto dhaxadhaa yeda haape; agaam bulayse ina kote bevee. ");
INSERT INTO amf_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Eedi hay ki hannaar ‘Harrnee bule?’ hamayse yeam ki oysina, ‘Imbaa wonteana kinin zaskonnane’ hamayse giyee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yittsadhaanaar yivayse kinin kena giyondettsi ko maataysaka ke haapade. ");
INSERT INTO amf_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kediar ukulinsa ootonam kenin bulenka, ukulinsa imbana “Ukuliam harrnee bule?” hamayse keam ke oysade. ");
INSERT INTO amf_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kediar “Imbaa wonteana kinin zaskonnane” kena ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ogora Yesuskal ke bavade; ukulia ootadar yisa apalanam wodayse Yesusam daran ke dottsade. ");
INSERT INTO amf_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesus yivite ki daaka, eeno apalanam yisa goyndar ko apade. ");
INSERT INTO amf_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Dabirezayt dhukara mia hanchen goynkal kinin theeden wodanka, kisa paanan yivayna eena wul yinin haapon tarshen yerin wulka wozadhayse upsi gebhika Barjoam gobshan ke yedade. ");
INSERT INTO amf_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ogonoar “Barjo Imbasa naabenka nivea bitaa gobshadhaane! Cecinte payyamo ko dee! Cecin wulsa bhaabar dahaa Barjona gobshi ko dee!” ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Eensa shaarinte dahaana Parisa eenasa waani waani eena “Dhettsea, hasa paanan yivaynaam lay kenin hamoadettsi keam wacimaa!” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesusaar “Inta yena ida giye: Kedi lay ke hamaakaar, senna kina ilata ke ilate” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesus Yerusaalem katamankal theedayse, katamanam yinin haapenka kona eepaate ");
INSERT INTO amf_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","yin ki giyade: “Hana payya maaten yerinam kina ha dhesidianna, hana payyane. Ta hasa aapira kodi aadhimidine. ");
INSERT INTO amf_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Haam jibbayna hasa gasanka kermi woysayse haam kobarbee obarbe ishkayse kenin galshayna roorona niva ke nive. ");
INSERT INTO amf_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Hambee hasa iinte dahaana naanabeam peendar dhaba ke dhabe; kottsimima seeni kala hattear raqinte hana garehe. Harrna hambhidianna, Barjo haam dhacchana kinin nivon wodanam hanin dhesaamonnane” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesus Barjosa gazan ooninsa mayante ardayse, gaban gabimaynaam oytan ki yedade. ");
INSERT INTO amf_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Keam oytaate yin ki giyade: “‘Onno isa miske ooni koda dee’ hamayse thaapadhidine; yediar eensa koymon buurate itsaynasa aadhime raq koam ye hayade!” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesus rooro wulka Barjosa gazan ooninsa mayante dhettsite ki dahade; ko dahaannaar gudullasa hayonabee, Musesa yigginam dhettsaynabee, zarsinsa eena gembhabe Yesusam deesana zagite ke dahade. ");
INSERT INTO amf_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ko dahaannaar kenin hayonsa goyti kekalanka ko kayade; harrna hambhidianna, eeno wul Yesusin giyenam qansana zagayse yisa woylamin wulam daran konin hayonnane. ");
INSERT INTO amf_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Rooro kalaa Yesus Barjosa gazan ooninsa mayante eenaam dhettsaatebee Barjosa dhacchintan upsinam giyaatebe ki dahade. Gudullasa hayonabee, Musesa yigginam dhettsaynabee, peensa donzanabe daran ke nivade. ");
INSERT INTO amf_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Ta wona giyaa: Yerra iginaam hanin hayayno hasa yer har hayamokane? Hayamon koam hana imaa hayne?” hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Kidiar kena yinin maasenka, “Intaar yer kalaa yeam ida oyse; yediar kosa malsinam ina giyee. ");
INSERT INTO amf_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Wannis eenaam kinin shivoadettsi nittsadhoono Barjokalankamoo? Eedikalankaw?” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kediar yin giyayse kinka ke dhalqade: “‘Barjokalankane’ wo hamanna, ‘Ta harrnee kisa dhalqinam gonne hamayse tiyan garaa?’ wona kida hame. ");
INSERT INTO amf_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","‘Eedikalankane’ wo hamanna, eeno wul woam seenika paxate koda deese; harrna hambhidianna, ‘Wannis gon Barjokala qansayse eenna giyeane’ hamayse kenin giyennane” ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ogonante “Hamora ko dahaannaar wodi dhesattone” hamayse kina ke maasade. ");
INSERT INTO amf_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesusaar “Ta intaar har hayamoka yerra iginaam inin hayenam yena giyattine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ogora Yesus eenana kamsika yin ki giyade: “Eedi kalaa woynin haaqanaam yisa haaminte thoothi ki korade. Haaminte waadadhayna eenana elqimayse, ‘Yediar yena maatenam kosa iira itsaate, waani aapinam ina imee’ hamayse, thoothi wodana pee abdar ki yivade. ");
INSERT INTO amf_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Woynin haaqanasa aapin kambhen wodan yeskaysaka, kinaqa yeskayna aapinam kenin imoadettsi yisa erge eedi kalaam haaminte waadadhayna eenadar ki yittsade. Haaminte waadadhayna kisa ergen eam yedate qanayse aan guuri ke yittsade. ");
INSERT INTO amf_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tapir ab yisa erge eedi ki yittsade; kediar kiam pir qanate ooshinsayse aan guuri ke yittsade. ");
INSERT INTO amf_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tapir yisa makkansoa ergen eam ki yittsaysaka, kiamaar gebhi qanayse haamira bulate ke dhabade. ");
INSERT INTO amf_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Woynin haaminsa imbaa ‘Hamini hayo? Ta inin nashea isa naasaam ida yittse; way kina bookindhasane’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Haaminte waadadhayna eena kisa naasaam yinin haapenka, kinka dhalqayse yin ke giyade: ‘Kaa kisa haamindar sagea naasa toydiane. Hammo kisa wona konin shidhoadettsi nivee; wo kiam deese’ ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Woynin haaqanasa haamira bulayse kiam ke deesade. “Ta haaminsa imbaa keam hamin ki haye? ");
INSERT INTO amf_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kidi yinti nivayse igina haaminte waadadhayna eenaam deesa ki deese. Yisa haaminamaar eedi abna kida ime” ki hamade. Eeno ogoam yinin qansenka, “Yin ko dahabhoode!” ko hamade. ");
INSERT INTO amf_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesusaar keam shedayse yin ki giyade: “‘Seeninka oonin woysayna eena kenin bagaa seenia senna wulra ooninna kattsi zaskea ki maatade’ hamayse thaapadhoono bulino hare? ");
INSERT INTO amf_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Seenia agaadar dhambea wul aya ki aye; seenia agaa yindar dhambaa ea giicima ki giicime” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Gudullasa hayonabee Musesa yigginam dhettsaynabe Yesus kamsinka kinin giyaa dhalqa keam kaamea kinin dohonam kenin dhesonna, agaa savaataka kiam yedana ke zagade; ko dahaannaar eenaam ke kurtumbhade. ");
INSERT INTO amf_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ogonante Yesusam yedana zagayse kiam toolite ke dahade. Peen wottsea yisa hayamonka kinin pirdoadettsi saskate imana kena maatea upsi apora kisa ke zagade. Ogonante tipana eena maatayse kisa dhalqinam tiyayna doyanaam ke yittsade. ");
INSERT INTO amf_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Igina doyana Yesusam yin giyayse ke oysade: “Woam Dhettsea, hanin giyenbee hanin dhettsenbe gon konin dohonam wodi dhesooda dhese. Pir Barjosa goynam gon hada dhettse; eedi haysaar woti shedima hanin hayenam wodi dhesidine. ");
INSERT INTO amf_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ta Musesa yigginka Roome peen bitaana gibiri kashadhoadettsi giidhidimoo? Giidhadayne?” hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesusaar kenin taysenam dhesayse kena yin ki giyade: ");
INSERT INTO amf_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ta santup ina dhehee. Santupa kaadar dahaa pootoabee daran thaapadhaa naabeabe haysane?” hamayse keam ki oysade. Kediar “Roome peen bitaasane” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesusaar “Ta Roome peen bita gaynam kina imee; Barjo gaynam Barjona imee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kediar eensa birante dhalqinka kiam yedana damadehe; ogona kisa malsinka targadhayse lay ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","“Dembhira dhaabhadhea yer qolehe” hamayna Saduqa eenara eedi waani Yesuskal nivayse yin giyayse kiam ke oysade: ");
INSERT INTO amf_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Woam Dhettsea, Muse yin giyayse wona ki thaapade: ‘Eedi kalaa maa keemayse naasi adhima diydi ki hanna, kisa kana koam keemayse diyaa iishimasa oolonte kina ki adhe’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ta keeda eedi kalaasa naas tobbhaa waani ke dahade. Ke wulsa iishima gebha maa keemayse naasi adhima ki diyade. ");
INSERT INTO amf_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kana lansoa agaadettsi yisa iishima geshonam keemayse ki diyade. ");
INSERT INTO amf_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Makkansoar koam keemayse ki diyade; ogodettsi tobbhaana indanaana wul koam keemayse, naasi adhima ke diyade. ");
INSERT INTO amf_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ke wulsa macchinte edono ko diyade. ");
INSERT INTO amf_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ogonante igina tobbhaana indanaana wul koam kenin keemonna, diyaana eena dembhira kenin dhaabhen wodanka kodi hamaa easa maa koda maate?” hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesusaar kena yi giyna: “Ta peen kodar dohoono eeno maa keema ko keeme, pir kembha ko kembhe. ");
INSERT INTO amf_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Diira dhaabhayse os niven wodanka daana damayna eena yina kembhehe, tapir keemehe; ");
INSERT INTO amf_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","os birante dembhi diyana damehe. Harrna hambhidianna, Barjosa gaananadettsi kenin maatennane. Kedi diira kenin dhaabhonna Barjo naanane. ");
INSERT INTO amf_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Diyaana ke hanna kenin dhaabhenam Musear ki dhettsade. Hatta kodoadar nuunin yedensa kinin thaaponte Imbaa Barjo ‘Abraamsa Barjoa, Yisaaqsa Barjoa, Yayqoobsaar Barjoane’ hamayse ki thaapade. ");
INSERT INTO amf_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ta Barjo sadanka dahaana eenasa Barjone; diyaana eenasa Barjotehe. Harrna hambhidianna, wul Barjona sadanka koda dee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Musesa yigginam dhettsayna waani waani eena kina yinin maasenka, “Woam Dhettsea, payyaa giyade” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ogora yedayse Yesusam yer kala hattear oysime oysana kedi kurtumbhidine. ");
INSERT INTO amf_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ogo wodanka Yesus kena yin ki giyade: “Barjoyn qadhaa Kiristoosam ‘Dawt naasine’ hamayse hamin ke giyaa? ");
INSERT INTO amf_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Dawt yinti Mazmur mathaapinte ‘Barjo isa Imbana, “Haam jibbayna eenaam hasa hayamonsa demente inin hayenka yekka isa mizaqimbar dooqaa” kina ki hamade’ kida hame. ");
INSERT INTO amf_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ta keeda Dawt yinti kiam ‘isa Imba’ hamayse ki eelina, Kiristoos hamin ki Dawtsa naasi dee?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Eeno wul kikal qansite ko daaka, Yesus yisa paanan yivaynana yin ki giyade: ");
INSERT INTO amf_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Gudubhon apalan qaadhayse os ora hamota zagayna, gabantear gobshadhon gisimenam gisimbhotabee, Ayiwd eensa bukin raqintear gobshadhon borkotondar dooqotabee, kummadhen raqintear gobshadhon raqin tiyotabe nashayna Musesa yigginam dhettsaynakalanka mete yesaam gishee. ");
INSERT INTO amf_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Eedinin qansoadettsi hamayse miskenam keda gudubhse; maana qambhinasa ooninam keda buure. Kedi sagi pirdi keda haape” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesus dheg hamayse kinin shedenka, wodimma koymon Barjona dhabadhen saathininte yisa koymonam kenin dhabenka ki shedade. ");
INSERT INTO amf_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tapir maa qambhi kallo bakkanda lamaa ogote konin dhabenka ki shedade. ");
INSERT INTO amf_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","“Yena gon ida giye: Ta kono mayno qambhino een wuldara sagi ko dhabade. ");
INSERT INTO amf_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Harrna hambhidianna, kedi wul yisa dohon koymon thoothinsa iira yina shiishayse ke dhabade; kodi qambhi dahayse yina kala hattear shiishima, yisa dohon koymon wulam ko dhabade” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yesussa paanan yivayna eenasa waani waani “Kono Barjosa gazano onno seenin payyanbee Barjona imbhon imintonbeka gobshayse ko ashkadhade” hamayse kenin giyenka, ");
INSERT INTO amf_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Yesus “Igina yenin shedayna senna kina kidar dordhaanasa kala hattear kidara povayse kottsimima kenin shidhima woda niva ko nive; hamin hambhaakaar kesa kala hattear raqaate shidhehe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kediar “Woam Dhettsea, ta ogono yerro haa ko yin maate? Ogono yerro konin yeskonam dhettsayno milkitino kosa hare?” hamayse ke oysade. ");
INSERT INTO amf_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesus kena yin ki giyade: “Yenin dhaddhisadhoamadettsi mete yesaam gishee. Harrna hambhidianna, thoothino eeno ‘Inta Kiristoosne’ pir, ‘Marrato! Kiristoosin nivayno wodano yeskidine’ hamaate isa naabenka niva ko nive. Kesa paananka yiveebhode. ");
INSERT INTO amf_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Banqinbee zarsinin kidar dhaabhenbe yenin qansen wodanka, kurtumbheebhode. Harrna hambhidianna, ogono yer wul birayse konin maatayno shidha shidhiminone. Yin ko dahaakaar macchin wodano saanawa nivehe” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ogora Yesus kena yin ki giyade: “Zarsino zarsindar, binnaar binnadar dhaabhayse banqi keda kiam uxe. ");
INSERT INTO amf_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Peendar gebhi zigabee, raq waani waaniar daaqibee, burqobe koda maate. Kurtunsen yerinbee gebhi milkitbe cecindar koda haapadhe. ");
INSERT INTO amf_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ogo wulsa birayse, isa naabenna hamayse eeno yeam yeda ko yede; yeam oyta ko oyte; Ayiwd eensa bukin raqintebee dhaxin oonintebe saskate yeam ima ko ime; binnabee peen wottsaynabedar yeam entsate koda yive. ");
INSERT INTO amf_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ogonoar isa naabenna hamayse yena tarjana agea goyti koda maate. ");
INSERT INTO amf_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ogonante yeam oysadhen oysimensa malsinna birayse yesa woylaminka qaabeebhode. ");
INSERT INTO amf_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Harrna hambhidianna, yeam jibbayna palimayse yeam kenin bashoamadettsi yena dhalqinbee pakalmakkonbeam ida ime. ");
INSERT INTO amf_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Imbana yennabee, indanaana yennabee, yesa muldhanabee, yesa nashonabe yeam saskate ima ke ime; yesa iira waani waani eenaamaar deesa ke deese. ");
INSERT INTO amf_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yedi isa naabenna hamayse een wulkal jibbadhaana yeda maate. ");
INSERT INTO amf_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ko dahaannaar yesa meten sitinsa kala hattear kayehe. ");
INSERT INTO amf_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Wocchimbhaate darshayse yesa sadanam yeda dhacche. ");
INSERT INTO amf_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Banqin eena Yerusaalemam karaysaka yenin haapen wodanka, kosa kayenin yeskonam dhesee. ");
INSERT INTO amf_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Wodan ogoka Yiwda peente dohoono eeno dhukanadar ko gobe; katamansa iinte dohoono eeno iira ko ute; katamansa mayante dohoonoar katamante ko ardabhoode. ");
INSERT INTO amf_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Harrna hambhidianna, thaapadhoono wul konin thoothoadettsi Barjosa halo woda ko maatade. ");
INSERT INTO amf_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ogo wodanka maana sirmanabee amin qooshaynabena hay! Harrna hambhidianna, Ayiwd peendar gebhi gaale koda maate; ogo zarsindarar Barjosa wacime koda nive. ");
INSERT INTO amf_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kesa iira thoothino zarsinoar halpaka koda deesadhe. Waani eenamaar banqi uxate peen wuldar koda yiidhe. Ayiwdtay hamma eenasa wodanin maqenka yekka, Yerusaalem Ayiwdtay hamma eenasa kantanka tigadhoono koda maate. ");
INSERT INTO amf_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Haynbee, arpinbee, wanconbedar milkit koda haapadhe. Peen wuldar dohoono eeno bazinin shohayse oolenna kurtumbhayse gaala ko gaale. ");
INSERT INTO amf_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Peendar niven yerinam toolaate eeno kurtumbheka koda gibaze. Harrna hambhidianna, cecinte dahaana kantana wul shoa ke shoe. ");
INSERT INTO amf_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ogo wodanka inta Eedi Naas kantanbee gebhon gobshinbeka polondar dahayse inin nivenam keda haape. ");
INSERT INTO amf_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ogono wul yin konin maatan yeden wodanka, yedar dohon bazanam kashayse yeam dhacchea nivanna kinin saanonna, dheg hamayse tura shedee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ogoraar Yesus kamsika kena yin ki giyade: “Shaapin hattonbee waani haaqanabeam payya hayayse shedee; ");
INSERT INTO amf_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","haccha haali kenin bulenka keam haapayse bargin wodanin yeskonam yedi yenti dheseeda dhese. ");
INSERT INTO amf_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ogodettsi yedi igina yerram yenin shedenka, Barjosa bitamonin theedonam dhesee. ");
INSERT INTO amf_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Inta yena gon ida giye: Ogo wul yin maatenka yekka wodan koka dohoono adhadhino eeno diyate maqehe. ");
INSERT INTO amf_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Cecinbee peenbe saga ko sage; inin giyoono upsino sagehe. ");
INSERT INTO amf_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Wucadhen thoothamonbee, barinbee, peen kosa dayntan goynbena hamayse yesa woylaminka qaabite yenin gaaloamadettsibee ye dhesima ogono roorono nivayse zaanidettsi yeam konin yedoamadettsibe yeam gishee. ");
INSERT INTO amf_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Harrna hambhidianna, ogono roorono peendar dohon een wulam yeda ko yede. ");
INSERT INTO amf_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ogonante nivanna hayen yerin wulra yeninka dhaqea kanta haapanabee i Eedi Naasisa birante woyanabe yenin damoadettsi, rooro wul Barjoam miskaate wocchimbhayse toolee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesus rooron rooronka Barjosa gazan ooninte dhettsite ki dahade; peen sootina Dabirezayt hambhen dhukandar yivayse kida wodhe. ");
INSERT INTO amf_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Sedhiman eeno wul kinin giyenam qansota Barjosa gazan ooninte kikal koda nive. ");
INSERT INTO amf_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Paasika hambhen irshonin qolmon balashan gaadhea bavaala yeskidine. ");
INSERT INTO amf_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Gudullasa hayonabee Musesa yigginam dhettsaynabe eenaam kenin kurtumbhonna, aachika Yesusam yinin deesensa goyti zagite ke dahade. ");
INSERT INTO amf_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ogo wodanka tabhi lamaa Yesussa paanan yivaynasa kalaa Asqoronto peen ea Yiwda hambheasa woylaminte Seethaan ki ardade. ");
INSERT INTO amf_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yiwdaar yivayse Yesusam hamin hayayse yettsate kena yinin imensa goyti gudullasa hayonabee Barjosa gazan ooninam toolaynabekal ki dhalqade. ");
INSERT INTO amf_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kediar wozadhayse birre kina imana kimbesana kinka ke dhalqade. ");
INSERT INTO amf_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yiwdaar kena ee hamayse eedin qolmonte kiam yettsate imana agea woda zagite ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ogosa budonte Paasikan yaaton machadhen irshon qolmon balashan itsadhayno bavallo ko yeskade. ");
INSERT INTO amf_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesus “Paasikansa galanam wonin itsoadettsi yivayse wona ashkee” hamayse Bhethiroosbee Wannisbeam ki yittsade. ");
INSERT INTO amf_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Kediar “Hamote wonin ashkoadettsia zage?” hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Kidiar kena yin ki giyade: “Katamante yenin ardenka, daaka noqo kedaa eedi kalaam yeda haape; kisa paananka yivayse kinin arden oonindar ardee. ");
INSERT INTO amf_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ooninsa imbaam ‘Woam Dhettsea “Isa paanan yivayna eenabete Paasikan galanam wonin itsayno ranqo hamotene?” hana kida hame’ kina hamee. ");
INSERT INTO amf_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kidiar ooninsa zulonte woysadhon, pir kosa iinaam payya apayse ashkadhon workin ooninam yena kida dhee; ogote wona ashkimate” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kediar yivayse Yesus kena kinin giyaadettsi ke haapade. Paasikan galanam ogote ke ashkade. ");
INSERT INTO amf_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Galan itsadhen wodan yeskaysaka, Yesus yisa tarjamonnante kinin yittsaynabesana gala kummota ki dooqade. ");
INSERT INTO amf_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kidiar “Gaalen inin tiyensa birayse yembesana kinka ko Paasikan galan itsana kattsi anngardhite i dahade. ");
INSERT INTO amf_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ogona yena ida giye: Barjosa bitamonte kosa aachin dhalqinin may maatenka yekka Paasikan galanam kaara os keeda itsattine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Wucadhenamaar tiyayse Barjoam gobshayse, “Kay, kinka kashimee. ");
INSERT INTO amf_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Inta yena ida giye: Barjosa bitamono konin nivenka yekka, keeda kaara os woynea hattasa aapin cuubadhonam wucattine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ogora balashanam tiyayse Barjoam ki gobshade; qunthayse yisa paanan yivayna eenana “Kono yena hamayse imbhayno isa waanone; iam yenin bhocchea hayee” hamayse kena ki imade. ");
INSERT INTO amf_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Agaadettsi pir galansa budonte, wucadhenamaar tiyayse kena yin ki giyade: “Kono wucadhayno isa yena hamayse laymen zombhinsa haali mallane. ");
INSERT INTO amf_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ko dahaannaar saskate iam imea ea imbesana kinka itseane. ");
INSERT INTO amf_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Inta Eedi Naas giidhondettsi diyayda diye; ko dahaannaar saskate iam imea ea agaana hay!” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kediar “Wosa shaarira ogo yerinam hayea eedi hayne?” hamayse kinka kiam oysan ke yedade. ");
INSERT INTO amf_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ogora kedi “Wo wuldara sagi maatea hayne?” hamaate kinka kikal paliman ke yedade. ");
INSERT INTO amf_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesus kena yin ki giyade: “Barjoam dhesimin eensa binna eendar kantanka keda bitime; wottsaynaar ‘Eenna payya waadadhaynane’ keam koda hambhe. ");
INSERT INTO amf_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yediar ogodettsi maateebhode; ko dahaannaar yesa iira wuldara gebhi dahaa ye wulsa kanadettsi ki maate; wottsear tapir erge eedidettsi ki maate. ");
INSERT INTO amf_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kumman raqinte dooqayse itseabee woyayse waadadheabesa gebhaa ea hayne? Kummandar dooqaatayu? Ko dahaannaar inta yesa shaarinte waadima eedidettsi i maatade. ");
INSERT INTO amf_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Isa gaalen wulka imbesana kinka wocchimbhayse woyaana yedine. ");
INSERT INTO amf_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ogonante Imba iam kinin bitinsondettsi, intaar yeam bitinsayda bitinse. ");
INSERT INTO amf_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Isa bitamonte kummandar dooqayse itseeda itse, wuceeda wuce; bitamon borkotondarar dooqayse tabhi lamaana Israveel eenasa muldhanadar pirdeeda pirde” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ogora Yesus “Simoon, Simoon, qansaa! Seethaan isin anqarsadhendettsi yeam anqarsate shedana Barjoam ki miskade. ");
INSERT INTO amf_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ko dahaannaar idar woylamin hanin qajayno hasa konin kayoamadettsi inta hana Barjoam i miskade. Yaar ora idar hanin maaton wodanka, hambanaanaam wocchinsaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Bhethiroosaar “Imbo, dhaxibee dembhibe ko hannaar, hambesana kinka yivana inta ashkimbhidine” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesusaar “Bhethirooso, yin ida hana giye: Kina baacha biraa qiiqima, ‘Inta kiam dhesattine’ hamayse makkam goyt hada marime” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ogora Yesus yisa paanan yivaynana “Korbhobee, surbabee, dunnguribe qolma yeam inin yittson wodanka yena joogaa yer daaw?” hamayse kena ki giyade. Kediar “Wosa joogaa yer qolehe” hamayse kina ke maasade. ");
INSERT INTO amf_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesusaar kena yin ki giyade: “Ta keeda korbhobee surbabe yisa dahaa ki yede; halpa yisa qolmaar apalanam shanshayse halpa ki shane. ");
INSERT INTO amf_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Yena yin ida giye: ‘Seeson eenabesana kinka ki paydadhade’ hamayse thaapadhoono upsino inka thootha koda zaske; innon goynsa thaapadhonsa macchino yeskidine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kediar “Imbo, shedaa! Kote halpa lamaa daane” ke hamade. Kidiar “Yeeka ko yeeke” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesus katamara utayse yisa dambindettsi Dabirezayt dhukandar kinin yivenka, kisa paanan yivayna eenaar kimbesana kinka ke yivade. ");
INSERT INTO amf_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ogotear kenin yeskenka Yesus kena “Taysate yeam siyonsa iinte arsente yenin ardoamadettsi Barjoam miskee” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ogora seeni paxadhaysaka yivayse weveaddha kekalanka pegadhayse kumpurdhayse, yin giyayse Barjoam ki miskade: ");
INSERT INTO amf_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Imbo, ha nashidianna ko gaalen wucimanam inin wucoamadettsi ikalanka saskaa. Ko dahaannaar hanin nashaadettsi ko dee, inin nashaadettsi ko dahabhoode” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Barjosa gaana kina haapadhayse kiam wocchinsite ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yisa woylaminkaar kattsi qaabayse ini hamora sagi Barjoam miskite ki dahade. Kisa ermanoar zombhidettsi maatayse peendar hanchite ko dahade. ");
INSERT INTO amf_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Miskera dhaabhayse yisa paanan yivaynakal kinin nivenka, kattsi galshea qaaboka qajadhayse raatidi ke hattaka keam ki haapade. ");
INSERT INTO amf_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","“Harrnee raataa? Taysate yeam siyonsa iinte arsente yenin ardoamadettsi dhaabhayse Barjoam miskee!” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesus ogoam akar giyte ki daaka, marrato! Thoothina eena kikal ke nivade. Keam entsea kisa paanan yivayna eena tabhi lamaanasa kalaa Yiwda hambhea ki dahade. Kidi Yesusam sunqota kikal ki theedade. ");
INSERT INTO amf_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yesusaar “Yiwda, i Eedi Naasaam sunqayse saskatea imo?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesusbesana dahaana eena ogo maatenam shedayse, “Imbo, halpaka keam wo taxo?” ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kesa iira kalaa gudullasa gebhaasa waadiman easa qaamia mizaqaam taxate ki dhabade. ");
INSERT INTO amf_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesusaar “Garee! Yin haya zaskehe!” hamayse easa qaamiam kaamayse ki pacchade. ");
INSERT INTO amf_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ogora Yesus kiam yedota nivaana gudullasa hayonabee, Barjosa gazan ooninam toolaynasa hayonabee, donzanabena “Eedisa koymo buurate itsea eedidettsi hayayse iam yedana halpabee haljobe bavatee nivaaw? ");
INSERT INTO amf_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Rooro wul Barjosa gazan ooninsa mayante yembesana kinka inin dehenka iam yedeetene; ta yembee thipansa hayoabesa wodane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ogora eena Yesusam yedayse gudullasa gebhaasa oonindar kiam entsate ke yivade. Bhethiroosaar pegeka kesa paanan yivite ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Eena kerminsa iir nuu guttsayse kinka dooqayse ke daaka, Bhethiroosaar nivayse kembesana kinka ki dooqade. ");
INSERT INTO amf_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Bhethiroos nuunsa gasante dooqayse ki daaka, waadima eedi kallo kiam haapayse payya shirshate shedayse, “Ea kaar kimbete ki dahade” ko hamade. ");
INSERT INTO amf_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Bhethiroosaar “Eediwa kono, inta kiam dhesattine!” hamayse ki marimade. ");
INSERT INTO amf_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Likka kap yinin hamonsa budonte, eedi ab kiam shedayse, “Yaar kimbesana kinka ha dahade” kina ki hamade. Bhethiroosaar “Yeria, intatehe!” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Savaat kalaaddha yinin kapponsa budonte, eedi ab kalaa Bhethirooska “Ea kaa Galila eedi yinin dohonna, gon kimbesana kinka ki dahade” hamayse upsi wocchika ki giyade. ");
INSERT INTO amf_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Bhethiroosaar “Yeria, hanin giyenam dhesattine!” ki hamade. Ogoam giyte ki daaka, baacha biraa ki qiiqade. ");
INSERT INTO amf_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ogo wodanka Imbaa Yesus budoka wal hamayse Bhethiroosam ki shedade. Bhethiroosaar “Kina baacha biraa qiiqima makkam goyt ‘Inta kiam dhesattine’ hamayse iam hada marime” hamayse Imbaa Yesus kina giyoono kalan bhoq konin hamenka, ");
INSERT INTO amf_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","mayanka utayse qaaboka kattsi ataate ki eepade. ");
INSERT INTO amf_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Yesusam toolayna eena kiam bagaate kisa aapinam ochayse qanada, “Haam qanaa hayne? Wona giyaa!” hamaate kiam keda oyse. ");
INSERT INTO amf_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Waaniar yer thoothi kidar giyada kiam keda iire. ");
INSERT INTO amf_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Peen sedhaysaka peensa donzanabee, gudullasa hayonabee, Musesa yigginam dhettsaynabe kinka bukayse Yesusam yisa pirdin raqindar entsate ke yivade. ");
INSERT INTO amf_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ta wona giyaa: Ya Barjoyn qadhaa Kiristoosu?” ke hamade. Kidiar “I yena giyaakaar gonne hamayse tiyattene; ");
INSERT INTO amf_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","oysimear yeam oysidi i hanna, ina maasattene. ");
INSERT INTO amf_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ko dahaannaar keeda kaara os inta Eedi Naas kantanka dahaa Barjosa mizaqimbar ida dooqe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kedi wulaar “Ta keeda ya Barjo Naasiw?” hamayse kiam ke oysade. Kidiar “Yenin giyaadettsi intane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kediar “Ta kisa apora uton upsinam wodi qansidine; keeda kaara os tarja ab wona harrna ko zaske?” ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pirdin pirdayna wul dhaabhayse Yesusam Bhilathoossa birante kiam entsate yivayse, ");
INSERT INTO amf_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","“Ea kaa wosa eenaam kinin dhaddhisenbee, Roome peen bitaana gibiri kenin kashoamadettsi keam kinin marenbee, pir ‘Bitaa Barjoyn qadhaa Kiristoos intane’ hamaate kinin giyenbeka kiam wo haapade” hamayse bersan ke yedade. ");
INSERT INTO amf_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Bhilathoosaar “Ayiwd eenasa bitaa yaw?” hamayse kiam ki oysade. Yesusaar “Inta hanin giyaadettsine” hamayse kina ki maasade. ");
INSERT INTO amf_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Bhilathoosaar gudullasa hayonabee een waanibena “Ea kaasa seeso kala hattear haapaatine” ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kediar “Ea kaa Galila peera yedayse koka yekka Yiwda peen wul gidir eenaam dhettsaate eenin kidar konin gooroadettsi kida haye” hamaate wocchisayse kiam ke bersade. ");
INSERT INTO amf_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Bhilathoosaar ogoam yinin qansenka, “Ea kaa Galila eediw?” hamayse ki oysade. ");
INSERT INTO amf_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yesus Herodisin wottsen peen eedi kinin dohonam yinin dhesenka, Herodisdar kiam ki yittsade. Herodisaar ogo wodanka Yerusaalem katamante ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodisaar Yesusam yinin haapenka, kattsi ki wozadhade. Harrna hambhidianna, Yesus goynsa yinin qansonna kiam shedana thoothi wodana anngardhaate ki dahade; ogo yerin tarshen Yesus kinin waadadhenka kiam shedana qaabite ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herodis Yesusam thoothi oysime ki oysade; kidiar yer kala hattear kina maasadehe. ");
INSERT INTO amf_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Gudullasa hayonabee Musesa yigginam dhettsaynabe raqin ogote woyayse kattsi kiam keda berse. ");
INSERT INTO amf_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodisaar yisa poolisanabete kiam bagaatebee boyaatebe ki dahade; apala goobe kiam qattsayse Bhilathoosdar maasate kiam ki yittsade. ");
INSERT INTO amf_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Agaa rooroaka Herodisbee Bhilathoosbe kinka kisa nasho ke maatade; kosa birayse kinka kiam jibbayna ke dahade. ");
INSERT INTO amf_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ogosa budonte Bhilathoos gudullasa hayonabee, eensa entsanabee, zarsinbeam yikal eelayse, ");
INSERT INTO amf_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","kena yin ki giyade: “‘Eenaam goorena kida dhaase’ hamayse ea kaam ikal entsate ye nivade. Marrato! Intaar yesa birante kiam marmarayse yenin kiam bersonsa seeso kala hattear kidar haapaatine. ");
INSERT INTO amf_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ogodettsi Herodisaar kidar seeso haapadehe; ogona wodar maasate kiam ki nittsade. Marrato! Ea kaa dembhi pirdidar yer kiam yeskisea kalaar hayadehe. ");
INSERT INTO amf_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ogonante kiam micareka qansayse garayda gare” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Leven levenka Paasikan bavaalinka dhaxadhon eensa eedi kalaam Bhilathoos eenna bula ko kiam zaskade. ");
INSERT INTO amf_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Eeno wul kinka hamayse “Ea kaam kaysima; Barbaanam wona bulima!” hante ke ilatade. ");
INSERT INTO amf_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barbaanaar kataman ogote banqi dhaasayse eediam kinin deesonna, dhaxin ooninte ki dhaxadhade. ");
INSERT INTO amf_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bhilathoosaar Yesusam bulana zagayse tapir eenna kinin giyenka, ");
INSERT INTO amf_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","eeno “Kiam ziitaa! Ziitaa!” hamaate ko ilatade. ");
INSERT INTO amf_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Bhilathoosaar makkanso “Ea kaa kinin hayoono seesono kisa hare? Inta dembhina kiam yeskisea kisa seeso haapaatine; ogonante kiam micareka qansayse bulayda bule” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kediar upsinam yisa dheg hayayse “Kiam ziitaa!” hamaate kattsi ke ilatade; Bhilathoosam ilatinkaar ke bashade. ");
INSERT INTO amf_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ogona kenin zagoono kena konin haydhoadettsi Bhilathoos ki pirdade. ");
INSERT INTO amf_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","“Wona Barbaanam bulaa” hamayse kenin oysaa peenam wottsaynadar eenaam kinin dhaasonnabee eedi kinin deesonnabe dhaxin ooninte dhaxadhaam kena ki bulade. Yesusam kenin zagaadettsi saskate ki imade. ");
INSERT INTO amf_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ogora Yesusam entsate kenin yivenka, Qerena peen ea Simoon gurdara katamandar kinin nivenka, kiam yedayse Yesusin ziitadhen masqalinam kiam kettsayse Yesussa paananka kinin yivoadettsi ke hayade. ");
INSERT INTO amf_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Thoothino eenoar Yesussa paananka ko yivade; kesaar iira qaytaate eepayna maa waani ke dahade. ");
INSERT INTO amf_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesusaar kedar wal hamayse kena yin ki giyade: “Yedi Yerusaalem maana, yennon metenbee yesa naanabena eepee, inante eepeebhode. ");
INSERT INTO amf_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Harrna hambhidianna, marrato! ‘Naasi adhimina, amin qooshayse dhesimina seekina ke wozadhe’ hambhayno roorono niva ko nive. ");
INSERT INTO amf_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ogo wodanka eeno dhukanaka ‘Wodar yiipee!’, kuttonakaar ‘Woam aachee!’ haman koda yede. ");
INSERT INTO amf_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ta haaqan eeqindettsi maataa idar yin ke hayna, haaqan wocchindettsi maataana yedar hamin ke hayo?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Waaniar eedi lamaa seeso waadadhaanaam Yesusbesana kinka keam deesota tiyate ke yivade. ");
INSERT INTO amf_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ogora “Eedisa Metedettsi” hambhea raqaam yeskayse ogote Yesusam masqalindar konngayse ke ziitade; seeso waadadhaanasa kalaam kisa mizaqimbar, lansoamaar kisa warkatambar keam konngayse ke ziitade. ");
INSERT INTO amf_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesusaar “Imbo, yinin hayenam kenin dhesimonna kena garaa” ki hamade. Poolisanaar Yesussa apalandar itha dhabayse kinka ke kashimade. ");
INSERT INTO amf_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Eenaar woyayse keda shede. Peenam wottsaynaar “Een waaniam kidi dhacchidine; ogona Barjo yiam kamayse qadhaa Kiristoos yi daana, ta yiam ki dhacche!” hamaate kiam keda bage. ");
INSERT INTO amf_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Poolisanaar kiam bagada kikal theedayse woyni thorka kina bavayse, ");
INSERT INTO amf_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Ya Ayiwd eenasa bitaa hanna, ta haam dhacchaa!” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","“Kaa Ayiwd eenasa bitaane” hamea Girikbee, Roomebee, Ibra aponbeka thaapi Yesussa metensa bhaabar masqalindar ke konngade. ");
INSERT INTO amf_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yesusbesana kinka ziitadhaana seeson eenasa eedi kalaa Yesuska “Ya Barjoyn qadhaa Kiristoostayu? Ta hambee wombeam dhacchaa!” hamaate kiam ki iirade. ");
INSERT INTO amf_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Lansoa ea yinin giyenka, “Ya kidettsi dembhin pirdindar dahayse Barjoam kurtumbhattanu? ");
INSERT INTO amf_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Wodi wonin seesonsa dhabin tiyaate wonin dohonna, zasken pirdindar wo dahade; ea kaa seeso waadadhadehe” hamayse kiam ki wacimade. ");
INSERT INTO amf_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ogora kidi “Yesuso, bitimayse hanin niven wodanka iam bhocchaa!” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesusaar “Inta hana gon ida giye, kina imbesana kinka Barjoyn ashkon ukunsen raqinte hada dee” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ogo wodanka savaat laxaddhane. Keeda agaara hayn thipaysaka savaat salin thoothenka yekka, peen wuldar thipano ko nivade. Barjosa gazan ooninsa gidin kashadhoono apallo kiaddha raq lamaadar ko havade. ");
INSERT INTO amf_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesusaar upsin yisa dheg hayayse “Imbo, isa sadanam hana ida ime” ki hamade. Ogoam giyayse ki diyade. ");
INSERT INTO amf_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mato alaqaar yerin maatonam yinin haapon wodanka, “Gon ea kaa tipane!” hamayse Barjoam ki gobshade. ");
INSERT INTO amf_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Yerin ogoam shedanna bukaana eena wul maaton yerinam kenin haapon wodanka, yisa woylaminka atayse sadanam gutada ke maatade. ");
INSERT INTO amf_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesusam dhesaana wul, Galila peera yedayse kisa paanan nivaana maanabesana pegeka woyayse ogoam keda shede. ");
INSERT INTO amf_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Marrato! Yiwda peensa Armatias kataman ea Yoseep hambhea eedi tipabee payyabe ki dahade. Ayiwd peen donzanasa eedi kalaa ki dahaakaar, Yesusam deesanna kesa bhocchinbee waadimanbeka kidi wormadehe. Barjosa bitamonam wozaka toolite ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kidi Bhilathooskal yivayse Yesussa leesinam kina kinin imoadettsi ki miskade. ");
INSERT INTO amf_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Leesinamaar masqalindara hanchayse apalaka ochayse seeni layta palsate ashkadhon eedin duukadhaamon duukin oolonte kiam ki duukade. ");
INSERT INTO amf_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ogoam kinin hayenka ukunsen rooroana ashkimbhadhayno wodane; ukunsen rooroa yeskanna kida haye. ");
INSERT INTO amf_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galila peera Yesusbete kinka nivaana maana Yoseep paanan yivayse duukinbee kisa leesinam hamaabar kinin duukonbeam ke shedade. ");
INSERT INTO amf_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Onnadar maatate yivayse shitto gaameabee waqatibe ke ashkade; ukunsen rooroakaar Musesa yiggin giyendettsi ukunsada ke haaqade. ");
INSERT INTO amf_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Gabansa rooroa biraa Wuudi burin seddhiman maana yinin ashkon shitton gaamenam tiyate duukindar ke yivade. ");
INSERT INTO amf_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Duukin oolonsa apon shupadhoono sennoar gunnguma ko hattaka ke haapade. ");
INSERT INTO amf_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ogora duukin oolonsa iinte ardayse Imbaa Yesussa leesinam haapadehe. ");
INSERT INTO amf_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kediar ogoka targadhayse ke daaka, marrato! Bhalqanten apalan qaadhaana eedi lamaa kekal theedi ke woyade. ");
INSERT INTO amf_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Maanaar kurtumbhayse mia peente kenin shedenka eena kena yin ke giyade: “Sadanka dahaa eam diyaanasa shaarinte harrnee zage? ");
INSERT INTO amf_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Kidi kote qolehe, dhaabhidine. ‘I Eedi Naasaam seeson eenasa aaninte saskate imbhaysaka ziitadhayse, makkanso rooroakaar dembhira dhaabha koda zaske’ hamayse ena Galila peente dahayse yena kinin giyonam bhocchee” kena ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Maanaar Yesusin giyonam ke bhocchade. ");
INSERT INTO amf_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","10","Duukin raqira maatayse ogo wulam tabhi kalaana Yesus yisa tarjamonnante kinin yittsaynabee waani eena wulbena ke giyade. Ogoam giyaana maanaar Megdela peen edon Mayriyambee, Yohannabee, Yayqoobsa indan Mayriyambe, tapir maana kembesana kinka dahaanane. ");
INSERT INTO amf_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Maanasa dhalqinam qansaana eenana bari apo konin maatonna, kedi gonne hamayse tiyadehe. ");
INSERT INTO amf_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Bhethiroosaar dhaabhayse duukindar ki gobade. Ogotear yivayse yirk hamayse kinin shedenka, leesin yinka ochadhon apalan bish ki haapade; yinin haapon yerinka targadhayse yisa woylaminka bhocchaate oonindar ki maatade. ");
INSERT INTO amf_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ogo rooronka Yesussa paanan yivaynasa lamaana eena Emahus hambhen gurdandar yivite ke dahade; Emahus Yerusaalemra roonka yiidhenka savaat lamaaddha goytine. ");
INSERT INTO amf_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kediar yerin hamon wulam kinka kikal ke dhalqade. ");
INSERT INTO amf_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ogo kenin dhalqenka Yesus kekal theedayse kembesana kinka yivaate ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ko dahaannaar kedi aapinka Yesusam shedaate, kidi hay kinin dohonam dhesana damadehe. ");
INSERT INTO amf_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kidiar “Yivaate kinka yenin dhalqayno ogono hare?” kena ki hamade. Kediar yisa qaabonka ataate ke woyade. ");
INSERT INTO amf_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kesa iira Qeleyoobha hambhea kina yinin maasenka, “Ya Yerusaalem katamansa shaarinte dahayse ogo rooronka yerin hamonam dhesaama chocchea ya bisheaw?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kidiar “Ogono yer hare?” kena ki hamade. Kediar yin giyayse kina ke maasade: “Naazret peen ea Yesus goynsane; kidi Barjobee een wulbesa birante waadimanbee dhalqinbeka kantanka dahaa Barjokala qansayse eenna giyea ki dahade. ");
INSERT INTO amf_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Gudullasa hayonabee woam wottsaynabe dembhin pirdinna saskate ke imaysaka, masqalindar konngayse kiam ke ziitade. ");
INSERT INTO amf_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wodiar ‘Israveel eenadar dohon bazanam kashayse woam dhacchea kidine’ hamayse kidar woylam wo hayade. Ogo bish dayma, yerro ogono yin ko maataysaka kina rooro makkansone. ");
INSERT INTO amf_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Tapir wosa shaarinte dahaana maana waani yisa dhalqinka kedi woam tarshidine. Ini seddhiman Yesussa duukindar ke yivade; ");
INSERT INTO amf_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kisa leesinam haapadehe. Maatate nivayse, ‘ “Sadanka ki dahade” hamayna Barjosa gaananaam haamadettsinka wo haapade’ hamada ke nivade. ");
INSERT INTO amf_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wokalankaar waani waani eena duukindar yivayse maanayn wona giyondettsi ke haapade; Yesusam haapadehe” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesusaar “Yedi bhocchiminato, Barjokala qansayse eenna giyayna giyon wulam tiyana boosimbhaanato! ");
INSERT INTO amf_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Barjoyn qadhaa Kiristoos gaalen ogoam tiyayse yisa gobshindar arda kiam zaskayu?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ogoraar Musebee Barjokala qansayse eenna giyayna wulbera yedayse kinnon goynka giidhonam Mathaap Gazante thaapadhon wulsa bulinam kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kenin yiven gurdanam ke theedaysaka, Yesus kekala sagayse kinin yivea kena ko maatade. ");
INSERT INTO amf_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kediar “Hayno ibanidine; peenoar sootanna koda haye; ogonante wokal wodhaa” hamayse kattsi ke miskade. Kidiar kembesana kinka wodhana ki ardade. ");
INSERT INTO amf_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kembesana kinka kummandar ki dooqade; balashanamaar tiyayse Barjoam gobshayse, kashate kena ki imade. ");
INSERT INTO amf_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ogo wodanka kesa aapinin bhoqenka kiam kedi dhesidine; kidiar kekala ki kayade. ");
INSERT INTO amf_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kediar kinka kikal yi giyna: “Goynte wonin dohonka wona kinin giyenka, pir Mathaap Gazara giyada wona kinin bulenka, wosa woylaminka wodi kattsi wozadhaate diyttayu?” ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kediar saanawa dhaabhayse Yerusaalemdar maatayse ke yivade; ogotear tabhi kalaanabee kembesana kinka dahaanabe kedi kikal bukayse ke daaka keam ke haapade. ");
INSERT INTO amf_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Igina kidar bukaana “Imbaa wontea Yesus gon dhaabhidine; Simoonnaar haapadhidine” ke hamade. ");
INSERT INTO amf_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Eena lamaanaar Emahusdar kenin yivenka goynte hamon yerinbee Yesus balashanam kinin kashenka hamin kenin kiam dhesonbeam kena ke giyade. ");
INSERT INTO amf_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kediar ogoam giyte ke daaka, Yesus yinti kesa shaarinte woyayse, “Payyamo yena ko dee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kediar meeshi kenin haapaa kena konin maatonna, targadhayse ke kurtumbhade. ");
INSERT INTO amf_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yesus “Harrnee gaqatsadhaa? Yesa woylaminkaar harrnee qothimaa? ");
INSERT INTO amf_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Inin dohonam isa aaninbee roonbeam shedee; iam kaamate shedee. Iam yenin shedeadettsi meeshidar waabee lepibe qolehe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yin giyayse yisa aaninbee roonbeam kena ki dhahade. ");
INSERT INTO amf_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kediar wozaka dhaabhoono gonne hamayse tiyma kenin garonna, targadhayse ke daaka, Yesus “Yekal itsadhea dook?” hamayse keam ki oysade. ");
INSERT INTO amf_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kediar kaarasa waa koqadhaa likka kina ke imade. ");
INSERT INTO amf_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Kidiar tiyayse kesa birante ki itsade. ");
INSERT INTO amf_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yin kena ki giyade: “Birayse yembesana kinka inin dohonka, ‘Musesa yiggin mathaapinabee, Barjokala qansayse eenna giyaynasa mathaapinabee, Mazmur mathaapinabesa iinte innon goynka thaapadhoono wul thoothinta koam koda zaske’ hamayse yena inin giyoono dhalqino konone” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ogo wodanka Mathaap Gazante thaapadhonam kenin bhocchoadettsi woylam kena ki imade. ");
INSERT INTO amf_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","47","Kenaar yin ki giyade: “‘Barjoyn qadhaa Kiristoos gaale haapayse diya ki diye; makkansoa rooroakaar dembhira dhaabha ki dhaabhe. Pir kisa naabenka seeson waadimanam garayse Barjodar maatadhenbee seesonam shiishadhenbeam Yerusaalemra yedayse peendar dohon zarsin wulna koda giidhe’ hamayse thaapadhidine. ");
INSERT INTO amf_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yediar yerra iginasa tarjanane. ");
INSERT INTO amf_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Marrato! Imbanin ‘imayda ime’ hamonam yena nittsayda nittse; yedi kantanam cecira yena imbhenka yekka Yerusaalem katamante dooqee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ogora Yesus yisa paanan yivaynaam Yerusaalemra bulayse Bitaaniadar entsate yivayse, yisa aaninam dhaasayse kena Barjo ki eelade. ");
INSERT INTO amf_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kena Barjoam eelaate kekalanka edimayse cecindar ki yivade. ");
INSERT INTO amf_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kediar kina goodimayse kattsi wozaka Yerusaalemdar ke maatade. ");
INSERT INTO amf_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Barjoamaar gobshaate rooro wul Barjosa gazan ooninte ke dahade. ");
INSERT INTO amf_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ena birayse Upsea dahade; agaa Upsear Barjokal ki dahade; Upsea agaar Barjone. ");
INSERT INTO amf_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Upsea agaar ena birayse Barjokal ki dahade. ");
INSERT INTO amf_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yer wul kanka ko pijadhade; pijadhaanasa shaarinte yer kala hattear ki qolmaka pijadhadehe. ");
INSERT INTO amf_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kanka dehea sada ko dahade; agaa sadaar eensa shaakaane. ");
INSERT INTO amf_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ogono shaakanoar thipante shaaka ko shaake; thipanoar koam bashadehe. ");
INSERT INTO amf_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Barjokalanka nittsadhaa Wannis hambhea eedi kalaa dahade. ");
INSERT INTO amf_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Eeno wul kisa tarjamonka ogo shaakandar woylamin konin qajoadettsi shaakan goynsa tarjota ki nivade. ");
INSERT INTO amf_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Wannis kidi yinti shaakatehe; ogo shaakan goynsa tarjota ki nivade. ");
INSERT INTO amf_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Een wulna shaakea gonin hama shaakaa peendar ki nivade. ");
INSERT INTO amf_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Kidiar peendar ki dahade; kidi peenam ki pijade; peendar dohoono eeno kiam dhesadehe. ");
INSERT INTO amf_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Kidi yisa muldhanakal ki nivade; ko dahaannaar kisa muldhana kiam tiyadehe. ");
INSERT INTO amf_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kiam tiyaana eena wulna, kidar woylamin qajaynana Barjo naana kenin doadettsi hayamo kena ki imade. ");
INSERT INTO amf_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kediar Barjo naana kenin maatoono Barjo Manpasinkalanka kenin adhadhonnane; eedin adhadhendettsi waabee zombhibeka way eedisa bhocchika adhadhadehe. ");
INSERT INTO amf_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Upsear eedi ki maatade; Barjosa sunin imintonbee goninbeka thoothayse wosa shaarinte ki wodhade. Yimbasa Naasa kalaa Imbaakal kisa dohon gobshinam wodi haapidine. ");
INSERT INTO amf_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Wannisaar “‘Isa budonte nivea idara sagine; harrna hambhidianna, kidi isa birayse ki dahade’ hamayse inin yena giyaa, marrato! Kidi kaane” hamaate upsi gebhika kinnon goynsa ki tarjade. ");
INSERT INTO amf_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Wodi wul kisa sunin iminton thoothamora sunin imintondar pir imintonam wo tiyade. ");
INSERT INTO amf_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yiggino Musebar ko imbhade; Barjosa sunin imintonbee goninbe Yesus Kiristoosbar wona ko imbhade. ");
INSERT INTO amf_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Hamin ko dahaakaar Barjoam haapaa eedi kala hattear qolehe; ko dahaannaar Barjo Imbaabete dahaa, kisa Naasa kalaa kinnon goynsa wona may ki dhahade. ");
INSERT INTO amf_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ayiwd eenam entsaynaar “Ya hayne?” hamayse Wannisam kenin oysoadettsi Yerusaalemra gudullabee Lewi eenabeam kidar kenin yittson wodanka, ");
INSERT INTO amf_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Wannis “Inta Barjoyn qadhaa Kiristoostehe” hamayse may ki tarjade, yiam aachadehe. ");
INSERT INTO amf_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kediar “Ta ya hayne? Eeliasu?” hamayse kiam ke oysade. Kidiar “Intatehe” hamayse kena ki maasade. Kediar “‘Niva ki nive’ hambhea Barjokala qansayse eenna giyea yaw?” kina ke hamade. Kidiar “Aavav” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kediar “Ta ya hayne? Woam nittsaanana malsinam wonin maasoadettsi haam haynea hame?” hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Kidiar “Barjokala qansayse eenna giyea Isiasin giyondettsi inta ‘Barjoyn yekal nivenna, goyn kina gaz hayayse ashkee’ hamayse ilatada darante giyea eane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nittsadhaana eenaar Parisa eenakalanka ke dahade. ");
INSERT INTO amf_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ogonante “Ya Barjoyn qadhaa Kiristoos way Eelias way ‘Niva ki nive’ hambhea Barjokala qansayse eenna giyea ha dahaamma, eenam harrnaa shive?” hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Wannisaar kena “Inta noqoka ida shive; ko dahaannaar yenin dhesima eedi yesa shaarinte woydine. ");
INSERT INTO amf_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Kisa dunngurinsa dhaxinam hattear bulana inta dameatehe; isa budonte nivea kidine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ogono wul yin konin maatoono Wannisin eenam shivayno Yordaanoos baynsa saabar dohon Bitaania gurdantene. ");
INSERT INTO amf_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kina hamon Wannis Yesus kikal kinin nivenka kiam shedayse, “Marrato! Peendar dohon eensa seesonam shiishea Barjosa Yaata kaane! ");
INSERT INTO amf_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","‘Eedi kalaa isa budonte niva ki nive; kidiar isa birayse kinin dohonna, idara kalon sagine’ inin hamaa kidi kaane. ");
INSERT INTO amf_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Intaar kiam dhesaatine; ko dahaannaar Israveel eenkal kinin dhesimoadettsi ogonante inta eenam noqoka shivaate i nivade” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Wannisar yin giyayse ki tarjade: “Manpas Gazano waleedettsi cecira konin hanchenbee kidar konin dooqenbeam i haapade. ");
INSERT INTO amf_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Intaar kiam dhesaatine; ko dahaannaar eenam noqoka inin shivoadettsi iam nittsaa ‘Kidar Manpasin hanchayse dooqenka hanin haapea Manpas Gazanka shivea kidine’ ina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Intaar ogoam haapidine; kidi Barjo Naas kinin dohonam inta tarjidine” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kina hamon Wannis lamaana kisa paanan yivaynabesana kinka pir raqin ogote woyayse ki dahade. ");
INSERT INTO amf_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Wannisaar ogoka Yesusin yivenka kiam shedayse, “Marrato! Barjosa Yaata kaane” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Igina lamaana Wannissa paanan yivaynaar Wannisin giyenam qansayse Yesussa paanan ke yivade. ");
INSERT INTO amf_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesusaar igina eena kisa paanan kenin nivenka budoka keam maatate shedayse, “Haree zage?” kena ki hamade. Kediar “Rebi, hanin dahayno ranqo hamotene?” hamayse kiam ke oysade. “Rebi” hamintano “Dhettsea” hamintane. ");
INSERT INTO amf_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Kidiar “Inin dehenam nivayse shedee” kena ki hamade. Kediar nivayse kinin dehen raqinam ke shedade. Ogo wodanka savaatino savaat tabhine; kediar kimbesana kinka ke haaqade. ");
INSERT INTO amf_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Wannisin tarjenka qansayse Yesussa paanan yivaana eena lamaanasa kalaa Simoon Bhethiroossa indanaasa Indiriasne. ");
INSERT INTO amf_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Indirias birayse yisa indanaasa Simoonam zagate haapayse, “Mesiam wodi haapidine” kina ki hamade. “Mesi” hamintano “Barjoyn qadhaa Kiristoos” hamintane. ");
INSERT INTO amf_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ogosa budonte Indirias Simoonam Yesuskal entsate ki yivade. Yesusaar kiam shedayse, “Ya Wannis naasa Simoonne. Haam ‘Keepa’ koda hambhe” kina ki hamade. “Keepa” hamintano “Bhethiroos” hamintane. ");
INSERT INTO amf_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Peen sedhaysaka Yesus Galila peendar yivana zagayse Pilbhoosam haapayse, “Isa paanan nivaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilbhoosaar Indiriasbee Bhethiroosbedettsi Beetesayda kataman eedine. ");
INSERT INTO amf_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilbhoos Natinaveelam zagate haapayse, “Musesa yiggin mathaapinte, pir Barjokala qansayse eenna giyayna kisa kenin thaapaa Yoseep naasa Naazret ea Yesusam wodi haapidine” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natinaveelaar “Naazretra payya yer haapa ko haapadho?” hamayse kiam ki oysade. Pilbhoosaar kina yi giyna: “Hanti nivayse shedaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesus Natinaveel kikal kinin nivenka kiam shedayse, “Marrato! Gadimmakko yisa woylaminte qolma gon hama Israveel ea kaane” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natinaveelaar “Haminkaa iam dhesaa?” kina ki hamade. Yesusaar kina yinin maasenka, “Pilbhoos haam eelima birayse hatton shaapinsa demente ha daaka, haam i haapade” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natinaveel yi giyna: “Woam Dhettsea, ya Barjo Naasane; ya Israveel eensa bitaane” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesusaar kina yinin maasenka, “‘Hatton shaapinsa demente ha daaka haam i haapade’ inin hamonnaa idar woylamin qajo? Ta ogora sagi yer akar hada haape. ");
INSERT INTO amf_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Inta yena gon ida giye: Cecin bulimaysaka Barjosa gaanana Eedi Naasikal kenin hanchenbee kenin utenbeam yeda haape” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Makkansoa rooroaka Galila peensa Qaana katamante gaydo ko dahade; Yesussa indanoar ogote ko dahade. ");
INSERT INTO amf_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesusbee kisa paanan yivayna eenabeam ogo gaydon raqinte ke eldhade. ");
INSERT INTO amf_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ogo gaydon raqinte woynin birzinin maqonna, Yesussa indano kina yi giyna: “Shedaa, birzino maqidine” kina ko hamade. ");
INSERT INTO amf_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesusaar “Indo, harrnaa iam oyse? Isa wodano akar yeskadehe” hamayse kona ki giyade. ");
INSERT INTO amf_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ogora kodi indano waadadhaynana “Kinin yena giyen wulam hayee” ko hamade. ");
INSERT INTO amf_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ayiwd eena yisa gilon kanka kenin waadadhea seenira ashkadhaana daa lax ogote ke dahade; daano kallo mato liitiraddha noqo koda yede. ");
INSERT INTO amf_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesusaar waadimaynana yi giyna: “Daana iginaar noqo thoosee” ki hamade. Kediar daanasa aponka noqonin laymana hayenka yekka ke thoosade. ");
INSERT INTO amf_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ogora Yesus “Ta keeda qolbhayse galanbee birzinbena kamate wodadhaa eana tiyate imee” kena ki hamade. Kediar qolbhayse kina ke imade. ");
INSERT INTO amf_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Galanbee birzinbena kamate wodadhaar ogo woynin birzin maaton noqonam yinin wucenka, hamora konin nivonam dhesadehe. (Noqonam qolbhaana eena kedi dhesa ke dhese.) Galanbee birzinbena kamate wodadhaa ear keemea eam eelayse, ");
INSERT INTO amf_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Eedi wul birayse payyan birzin koda ime; ogora eenin bardhonsa budonte daathimin birzinam koda ime. Ya payyan birzinam koaddha harrnaa kappisaa?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesus ogo biron tarshen yerinam kinin hayoono Galila peensa Qaana katamantene. Ogoka yisa gobshinamaar ki dhahade; kisa paanan yivayna eenaar kidar woylamin ke qajade. ");
INSERT INTO amf_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ogosa budonte Yesus indanbee, indanaanabee, kisa paanan yivayna eenabesana kinka Qipirnaahoomir yivayse likka roorona ki dooqade. ");
INSERT INTO amf_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ayiwd eensa Paasikan bavaalin yeskaysaka Yesus Yerusaalem ki yivade. ");
INSERT INTO amf_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Barjosa gazan ooninsa mayantear wanngabee, yaanabee, waleenbeam shanshaynaam ki haapade; koymon ookaynaamaar dooqayse ke daaka keam haapayse, ");
INSERT INTO amf_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","alannga ashkayse yaanabee wanngabe wulam Barjosa gazan ooninsa mayara ki oytade. Koymon ookaynasa koymonam ki laalade; kesa tharbhezanamaar kupate ki dhabade. ");
INSERT INTO amf_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Waleen shanshaynanaar “Koam os tiyee; Imbasa ooninam gaba gabadhea ooni hayeebhode!” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ogo wodanka Yesussa paanan yivayna “Hasa ooninsa dohoono anngarmano isa iinte nuudettsi koda oydhe” hamayse thaapadhonam ke bhocchade. ");
INSERT INTO amf_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ayiwd eenam entsaynaar kina “Ya koam hayana hasa hayamonin dohonam wonin dhesoadettsi tarshea yer haraa wona dhee?” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesusaar kena yi giyna: “Barjosa gazan oonin koam kottsee; inta koam rooro makkamka pir woysayda woyse” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ogona Ayiwd eenam entsayna “Ko Barjosa gazan ooninam woysate macchana eedi lamaa kaysa apo lax leve ko tiyade; ya ta koam rooro makkamka haminaa woyse?” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yesusaar “Barjosa gazan onno” hamayse kinin giyoono yisa waansa ki giyade. ");
INSERT INTO amf_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ogonante Yesus dembhira kinin dhaabhonsa budonte, kisa paanan yivayna eena ogo kinin giyonam bhocchayse, Mathaap Gazante thaapadhonbee Yesusin giyonbeam gonne ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesus Paasikan rooroaka Yerusaalemir ki daaka, thoothino eeno kinin hayen tarshen yerinam shedayse kidar woylam ko qajade. ");
INSERT INTO amf_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yesusaar een wulam yinin dhesenna, kesa qaabonam gonne hamayse kedar woylam qajehe. ");
INSERT INTO amf_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kidi yinti eedisa iinte dohonam kinin dhesenna, eedi hay ki hannaar eedisa kina tarjoadettsi zaskehe. ");
INSERT INTO amf_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Parisa eensa shaarira Ayiwd eensa hayoa Niqodimos hambhea eedi kalaa dahade. ");
INSERT INTO amf_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kidiar sootinka Yesuskal nivayse, “Woam Dhettsea, Barjo kimbesana ki dahaamma, hanin hayayna igina tarshayna yerraam hayana damea eedi qolehe. Ogonante Barjokalanka nivaa dhettsea hanin dohonam dhesooda dhese” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesusaar kina yinin maasenka, “Inta hana gon ida giye: Eedi lansi yi adhadhaamma, Barjosa bitamonam haapana damehe” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Niqodimosaar “Eedi yinin gecchonsa budonte hamin ki adhadhe? Lansi indansa iir ardayse adhadhana damaw?” hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesusaar yin giyayse kina ki maasade: “Inta hana gon ida giye: Eedi noqokalankabee Manpas Gazankalankabe yi adhadhaamma, Barjosa bitamonte ardana damehe. ");
INSERT INTO amf_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Waakalanka adhadhaa waane; manpaskalanka adhadhaa manpasne. ");
INSERT INTO amf_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","‘Lansi adhadha yeam ko zaske’ inin hana hamonna ya targadhaabhode. ");
INSERT INTO amf_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Jibare yinin nashaa raqadar koda jibarshe; kosa upsinamaar hada qanse. Ko dahaannaar hamora konin nivenam, pir hamodar konin yivenam ya dhesattane. Manpas Gazankalanka adhadhaa wul yinne” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Niqodimosaar “Ogono hamin ko yin dee?” hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesusaar kina yi giyna: “Ya Israveel eenam dhettsea dahayse ogoam dhesattanu? ");
INSERT INTO amf_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Inta hana gon ida giye: Wonin dhesonam woda giye; wonin haaponamaar woda tarje. Yediar wosa tarjamonam gonne hamayse tiyattene. ");
INSERT INTO amf_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Peendar dohonam inin yena giyenka gonne hamayse ye tiymina, cecinte dohonam i yena giydianna yedi gonne hamayse haminee tiye? ");
INSERT INTO amf_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Cecira hanchaa Eedi Naasira ab hayyear tura cecindar yivaa eedi qolehe. ");
INSERT INTO amf_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Musear darante guninam kinin ziitaadettsi, Eedi Naasiar agaadettsi ziitadha kiam koda zaske. ");
INSERT INTO amf_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ogonoar kidar woylamin qajea hayyear rooro wul lay dehen sadanam kinin haapoadettsine. ");
INSERT INTO amf_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kidar woylamin qajayna wul kenin kayoamadettsi, rooro wul lay dehen sadanam ke haape, Barjo yisa Naasa kalaam yinin imenka yekka peen kodar dohon eenam kattsi ki nashade. ");
INSERT INTO amf_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Barjo peendar yisa Naasaam kinin nittsoono peen kodar dohoono eeno kanka konin dhaqoadettsine; eendar kinin pirdoadettsitehe. ");
INSERT INTO amf_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Kidar woylamin qajeadar pirdadhehe; kidar woylamin qajimaadar Barjo Naasa kalaadar woylamin kinin qajaamonna, ta kidar pirdadhidine. ");
INSERT INTO amf_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Shaakanoar peendar ko nivade; eeno siya konin hayenna, shaakanam nashadehe. Thipanam konin nashonna, pirdino ogona ko nivade. ");
INSERT INTO amf_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Siya hayea wul shaakanam kida jibbe; kisa waadimanin haapadhoamadettsi shaakandar nivehe. ");
INSERT INTO amf_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Gonin hayea ea kisa waadimano Barjokala konin dohonam haapadhoadettsi shaakandar kida nive” hamayse ki giyade. ");
INSERT INTO amf_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ogosa budonte Yesus yisa paanan yivaynabesana kinka Yiwda peendar ki yivade; ogotear kembesana kinka dooqayse eenaam kida shive. ");
INSERT INTO amf_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Wannisar Saaleem katamansa gasante Yenoon hambhea raqaate thoothi noqon dohonna, eenam kida shive; eenoar kikal nivayse koda shiidhe. ");
INSERT INTO amf_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Wodan ogoka Wannisam akar dhaxin ooninte dhaxadhadehe. ");
INSERT INTO amf_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Wannissa paanan yivaynabee Ayiwd eedi kalabesa shaarinte ashki gilosa palime ko dhaabhade. ");
INSERT INTO amf_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Wannissa paanan yivaynaar Wanniskal nivayse, “Woam Dhettsea, Yordaanoos baynsa saabar hambesana kinka dahaa, yaar kina hanin tarjaa, kidi eenam kida shive; eeno wulaar kidar koda yive” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Wannisaar kena yinin maasenka, “Eedi haynaar cecira Barjo kina imima yer kala hattear tiyana damehe. ");
INSERT INTO amf_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‘Inta Barjoyn qadhaa Kiristoostehe; ko dahaannaar kisa birayse i nittsadhade’ hamayse inin giyonsa yedi isa tarjanane. ");
INSERT INTO amf_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Uutan yisa dahaa ea kidi uutan imbaane; uutan imbaasa aananta kikal woyayse ki daaka, uutan imbaa uutanbesana kinin dhalqenka kisa upsinam qansayse aananta kattsi kida wozadhe. Ogonante isa wozano ta thoothidine. ");
INSERT INTO amf_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kidi dheg dheg hama kiam koda zaske; inta yirk yirk hama iam koda zaske” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Bhaara nivaa wuldara sagine. Peente dahaa peensane; peenngayn yerinam kida giye. Cecira nivaa wuldara sagine. ");
INSERT INTO amf_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Kidi yinin haaponbee yinin qansonbeam kida tarje; kinin tarjenamaar tiyea qolehe. ");
INSERT INTO amf_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kinin tarjonam tiyaa ea Barjosa gonamonam kida tarje. ");
INSERT INTO amf_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Barjoyn nittsaa Barjosa upsinam kida giye; harrna hambhidianna, Barjo yisa Manpasinam kashate imehe. ");
INSERT INTO amf_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Barjo Imbaa yisa Naasaam kida nashe; yer wulam kisa hayamon demente haydine. ");
INSERT INTO amf_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Barjo Naasadar woylamin qajeasa rooro wul lay dehea sada kisa daane. Barjo Naasadar woylamin qajima eadar Barjosa wacime kidar ko dahade; dehen sadanam haapehe. ");
INSERT INTO amf_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ogosa budonte Yesus Wanniskalanka sagi thoothina eenaam yisa paananka yivayna kinin hayenbee noqonka kinin shivenbeam Parisa eena ke qansade. ");
INSERT INTO amf_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ko dahaannaar eenaam shivayna kisa paanan yivayna eenane; kidi yinti shivehe. ");
INSERT INTO amf_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Parisa eena kisa giidhaka kenin qansonam Yesusin dheson wodanka, Yiwda peenam garayse Galila peendar ki yivade. ");
INSERT INTO amf_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ogodar kinin yivenka Sammaria peen goynka yiva kiam ko zaskade. ");
INSERT INTO amf_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ogonante Sammaria peente dohon Yayqoob yisa naasa Yoseepna ena kinin imon raqinkal theedi Sikaar kataman ki nivade. ");
INSERT INTO amf_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Raqin ogote Yayqoobsa noqo tuula ko dahade. Yesusaar kinin nivon goyn kiam qacchaysaka noqon tuulansa aponte ki dooqade; ogo wodanka savaatinoar savaat laxaddhane. ");
INSERT INTO amf_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Sammaria peen maa kallo noqo qolbhota ko nivade. Yesusaar “Noqo iam wushaa” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Kisa paanan yivayna eena ogosa birayse gala shanota katamandar ke yivade. ");
INSERT INTO amf_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ogonante edono Yesusna yi giyna: “Ya Ayiwd eedi dahayse i Sammaria edonkal ‘Noqo iam wushaa’ hamayse haminaa iam miske?” kina ko hamade. Ogonoar Ayiwd eenbee Sammaria eenbe yer kala kaladar kinka kenin agimonnane. ");
INSERT INTO amf_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesusaar kona yi giyna: “Barjosa imintonbee ‘Noqo iam wushaa’ hana hamea hay inin dohonbeam ha dhesidianna, ini ya iam hada miske; inta sadan imen noqonam hana ida ime” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Edonoar “Imbo, haninka qolbhea yer hasa aaninte qolehe; tuulanoar gudubhne. Ta sadan imen noqonam hamoraa tiye? ");
INSERT INTO amf_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ya ogo noqon tuulanam wona imaa wosa imbaa Yayqoobdara sagaa sago? Kimbee, kisa naanabee, kisa qollabe kora ke wucade” kina ko hamade. ");
INSERT INTO amf_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesusaar kona yinin maasenka, “Ogo noqora wucea wul pir kida dheebardhe. ");
INSERT INTO amf_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Inin imen noqonam wucea rooro wul dheebardhehe; ogonoar inin kina imayno noqono rooro wul lay dehen sadan imea noqo maatayse kisa iira koda ele” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Edonoar “Imbo, keeda kaara os noqo inin dheebardhoamadettsibee noqo qolbhota kote inin nivoamadettsibe ogo noqonam ina imaa” kina ko hamade. ");
INSERT INTO amf_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesusaar “Yivayse hasa geshoam eelayse kote nivaa” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Edonoar “Isa anngi qolehe” kina ko hamade. Yesusaar “‘Isa anngi qolehe’ hamayse hanin giyoono payyane. ");
INSERT INTO amf_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Hasa anngi dong ke dahade; ta hambesana kinka dahaar hasa geshoatehe. Ogona ya gonaa giyade” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Edonoar “Imbo, ya Barjokala qansayse eenna giyea hanin dohonam ta inta dhesidine. ");
INSERT INTO amf_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ena wosa eykena dhukan ogodar Barjona ke goodimade; yedi Ayiwd eenaar ‘Eediyn Barjona goodima zaskayno ranqo Yerusaalemirne’ yeda hame” kina ko hamade. ");
INSERT INTO amf_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesusaar kona yin ki giyade: “Ya edono, inin giyenam gonne hamayse tiyaa. Barjo Imbaana dhukan ogodar way Yerusaalemir yenin goodimima woda koda nive. ");
INSERT INTO amf_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Yedi yenin dhesaama Barjona yeda goodime; wodiar dhaqinta Ayiwd eensa shaarira konin dohonna, wonin dhesea Barjona woda goodime. ");
INSERT INTO amf_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ko dahaannaar, Barjona goninka goodimayna eena Barjo Imbaana manpasbee goninbeka kina kenin goodimea woda koda nive; ogono wodanoar ta nividine. Barjo Imbaa agaadettsi kina goodimaynaam kida zage. ");
INSERT INTO amf_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Barjo manpasne; kina goodimaynaar manpasbee goninbeka kenin goodimoadettsi keam koda zaske” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Edonoar “Barjoyn qadhaa Kiristoos hambhea Mesi kinin nivenam dhesayda dhese; kidi yinin nivon wodanka, yer wulam wona kida giye” kina ko hamade. ");
INSERT INTO amf_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesusaar “Shedaa! Ta hambesana dhalqea kidi intane” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ogo wodanka kisa paanan yivayna eenaar katamara maatate ke nivade; Yesus maa kallonbesana kinka kinin dhalqenka kiam haapayse kedi targadhidine. Ko dahaannaar edonna “Haraa zage?” way Yesusna “Kombesana kinka harrnaa dhalqe?” hamayse keam oysaa eedi kala hattear qolehe. ");
INSERT INTO amf_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ogo wodanka edono noqon daanam garayse katamandar yivayse eenna yi giyna: ");
INSERT INTO amf_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Inin hayon wulam ina giyaa eam nivayse shedee! Way kidi Barjoyn qadhaa Kiristoos doo ki dew?” ko hamade. ");
INSERT INTO amf_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Eenoar katamara utayse Yesuskal nivite ko dahade. ");
INSERT INTO amf_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ogo wodanka Yesussa paanan yivayna “Woam Dhettsea, gala wokal itsaa” hamayse kiam ke miskade. ");
INSERT INTO amf_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kidiar kena yinin giyenka, “Yenin dhesima gala inin itsea isa daane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ogonante kisa paanan yivayna eena “Eedi kina gala bavidi doo ko dew?” hamayse kinka kikal ke dhalqade. ");
INSERT INTO amf_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesusaar kena yi giyna: “Isa galano iam nittsaasa bhocchinam inin hayoadettsibee kisa waadimanam inin thoosoadettsibene. ");
INSERT INTO amf_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yedi ‘Akar arpi oydi ko shidhade; ogosa budonte isin patadhea rooroa kida nive’ yesa hamintatayu? Marrato! Inta yena ida giye: Isinin wocchonam, patadhen wodanin yeskonam dheg hamayse shedee. ");
INSERT INTO amf_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Isinin patea yinin patonsa bazanam kida tiye; rooro wul lay sadanka dehen aapinamaar kida pucche. Ogonante yiitheabee pateabe kinka keda wozadhe. ");
INSERT INTO amf_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ogona ‘Kalaa bheeta kida yiithe; waar pata ki pate’ hamayse giidhoono kamsino gonne. ");
INSERT INTO amf_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Intaar qajadhayse yenin waadadhaamonam yenin patoadettsi yeam i yittsade. Waani eena ke qajadhade; yedi kenin qajadhonsa aapinam ye buurade” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Edonoar “Inin hayon wulam ina ki giyade” hamayse konin tarjon goynka kataman ogora thoothino Sammaria eeno Yesusdar woylamin ko qajade. ");
INSERT INTO amf_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ogonante Sammaria eena Yesuskal yinin nivon wodanka, kekal kinin dooqoadettsi kiam ke miskade; kidiar rooro lamaa kekal ki dooqade. ");
INSERT INTO amf_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Birana eenadara kattsi thoothino eeno kisa dhalqinka kidar woylamin ko qajade. ");
INSERT INTO amf_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kedi edonna yi giyna: “Keeda kidar woylamin wonin qajayno hanin wona giyonna bish dayma, wodi wonti kinin giyenam wonin qansonnabee kidi gon peendar dahayna eenaam Dhacchea kinin maatonam wonin dhesonnabene” kona ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesus raqin ogote rooro lamaa yinin dooqonsa budonte, Galila peendar ki yivade. ");
INSERT INTO amf_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Barjokala qansayse eenna giyea peen yinnonte kinin gobshadhiminam Yesus ena yinti giydine. ");
INSERT INTO amf_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galila peendar kinin nivon wodanka, Galila eena kiam wozaka ke tiyade. Harrna hambhidianna, Paasikansa bavaala rooroaka kediar yivayse Yerusaalemir kinin hayon wulam kenin haaponnane. ");
INSERT INTO amf_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesus ena noqonam woynin birzindar kinin maason Galila peensa Qaana katamandar pir ki nivade. Qipirnaahoom gidir naasa yisa hajadhaa peen wottsea bitaasa choobar hayo kalaa ki dahade. ");
INSERT INTO amf_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kidiar Yesus Yiwda peera Galila kinin nivonam yinin qanson wodanka, naasa hajadhayse diyota kinin hayonna, nivayse kinin pacchoadettsi Yesuskal yivayse kiam ki miskade. ");
INSERT INTO amf_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ogonante Yesus kina yi giyna: “Yedi tarsheabee yer haalibeam ye haapaamma, hamin ko dahaakaar idar woylamin qajattene” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Wottsear “Imbo, isa naasa diyma bannzo! Saana ikal nivaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesusaar “Hasa naasa paashidine; oonindar hasa yivaa” kina ki hamade. Ear Yesusin giyonam gonne hamayse yisa oonindar ki yivade. ");
INSERT INTO amf_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kinin yivenkaar kisa waadiman eena goynte kidar keerayse, “Hasa naasa paashidine” hamayse kina ke giyade. ");
INSERT INTO amf_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kidiar “Naasayn paashoono savaat meemaykane?” hamayse keam ki oysade. Kediar “Naa savaat tobbhaaka bishin occhayno kiam ko garaysaka ki paashade” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Naasasa imbaar Yesus “Hasa naasa paashidine” kina kinin hamoono savaatin ogoka konin dohonam dhesayse, kidi yisa oonin eena wulbesana Yesusdar woylamin ke qajade. ");
INSERT INTO amf_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kono tarshayno yerro Yesus Yiwda peera Galila peendar maatate nivayse kinin hayonsa lansonone. ");
INSERT INTO amf_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ogosa budonte Ayiwd eensa bavaal rooro konin dohonna, Yesus Yerusaalemir ki yivade. ");
INSERT INTO amf_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yerusaalemir yaana kerinsa gasante Ibra aponka Beetesayda hambhayno eenin shiidhimbhea dalba ko dahade; ogo dalbansa gasante baara kaadhaa eedin yaayea goyti dong ko dahade. ");
INSERT INTO amf_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Ogotear noqonsa shoanam kaalada hajadhaanabee, aapin kayaanabee, wobonabee, bishiysa malgimaanabe thoothina eena iir keda wodhe. Waani waani rooronaka Barjo gaananasa kalaa nivayse noqonam kida shooshe; noqonin shohonsa budonte birayse noqonte ardaa ea yidar dohon burqora paasha ki paashe. ");
INSERT INTO amf_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ogotear eedi kalaa kaysa apo tabhi lankay levenka yekka hajadhaa eedi kala ki dahade. ");
INSERT INTO amf_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesus ea agaa raatayse ki daaka kiam haapayse, kinaka yekka thoothi leve hajadhayse kinin dohonam dhesayse, “Paashana zagaa zago?” hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Hajadhaa ear “Imbo, noqon shohanna noqonsa iinte tiyate iam arsea eedi qolehe; ko dahaannaar inta noqonte ardota inin hayenka, eeno waani iam birayse koda arde” hamayse kina ki maasade. ");
INSERT INTO amf_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesusaar “Dhaabhayse haam baadhon haaqanam bavate yivaa!” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ear saanawa paashayse, kiam baadhon haaqanam yinka bavate ki yivade. Agaa rooroar Ayiwd eensa ukunsen rooroane. ");
INSERT INTO amf_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ogonante Ayiwd eenam entsayna hajimora paashaa eana “Kina roorono ukunse rooro konin dohonna, haam haaqa bava zaskehe” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kidi “Iam pacchaa ea ‘Haam baadhon haaqanam hanka bavayse yivaa’ ina kinin hamonnane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Kediar “‘Haaqanam bavayse hanka yivaa’ hana hamaa hayne?” hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ko dahaannaar ogo raqinte thoothi eedi dahade; ogona Yesus eensa shaarinte kinin ardonna, kiam pacchaa ea hay kinin dohonam kidi dhesadehe. ");
INSERT INTO amf_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ogosa budonte Yesus eam Barjosa gazan ooninsa mayante kiam haapayse, “Shedaa! Ya paashidine; kora sagi yer hadar yeskoamadettsi keeda kaara os seeso hayaabhode!” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ear yivayse kiam pacchaa Yesus kinin dohonam Ayiwd eenam entsaynana ki giyade. ");
INSERT INTO amf_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ogonante ukunsen rooroaka yerra iginaam kinin hayonna, Ayiwd eenam entsayna Yesusam oytan ke yedade. ");
INSERT INTO amf_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesusaar “Ta koka yekka Imba waadadhite ki dahade; intaar waadadhite i dahade” hamayse kena ki maasade. ");
INSERT INTO amf_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ogonoar ukunsen rooroam kinin gobshaamonna bish dayma, Barjoam “Kidi Imbane” hamayse yiam Barjoka kinin yeekinsonna, Ayiwd eenam entsayna ena hamora sagi deesana kiam ke zagade. ");
INSERT INTO amf_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ogonante Yesus kena yin ki giyade: “Inta yena gon ida giye: Imbaanin waadadhenka yinin haaponam bish Naasa kida waadadhe; kidi yisa hayamoka waadadhana kinin damea yer kala hattear qolehe. Imbaa kinin waadadhen wulam Naasa pir agaadettsi kida waadadhe. ");
INSERT INTO amf_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Harrna hambhidianna, Imbaa yisa Naasaam kinin nashenna, yinin waadadhen wulam kina kida dhee. Yediar yenin targadhoadettsi ogora sagi waadima kina kida dhee. ");
INSERT INTO amf_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Imbaa diyaanaam kinin dhaasenbee sadanka daadhenam kena kinin imendettsibe, Naasa yinin kamaana eena wulna sadanka daadhenam kena kida ime. ");
INSERT INTO amf_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Imbaa eedi kalaadar pirdehe; eeno wul Imbaam konin gobshendettsi Naasaamaar konin gobshoadettsi pirdin wulam Naasana ki imade. Naasaam gobshima kiam nittsaa Imbaamaar gobshehe. ");
INSERT INTO amf_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Inta yena gon ida giye: Isa upsinam qansayse iam nittsaadar woylamin qajea rooro wul lay dehea sada kisa daane. Dembhira sadaka daadhendar ki sagade; kidar pirdadhehe. ");
INSERT INTO amf_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Inta yena gon ida giye: Diyaana eena Barjo Naasasa upsinam kenin qansea woda koda nive; ogonoar taakine. Qansayna wul sadaka keda dee. ");
INSERT INTO amf_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Imbaa sadanka daadhenam imea kinin dohondettsi, yin tapir Naasa sadanka daadhenam imea kinin doadettsi kiam haydine. ");
INSERT INTO amf_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Pir Eedi Naas kinin dohonna, kinin pirdoadettsi Imbaa hayamo kina imidine. ");
INSERT INTO amf_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Ogona targadheebhode; duukinte dahaana wul Naasasa upsinam qansayse duukira kenin dhaabhayno woda niva ko nive. Payyan waadadhaana dembhira dhaabhayse sadaka keda dee; siyon waadadhaana eena dembhira kenin dhaabhonsa budonte kedar pirda ko pirdadhe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Inta isa hayamoka yer kalaar hayana damattine; ko dahaannaar Imbaakalanka inin qansonam ida pirde. Iam nittsaasa bhocchinamne, isa bhocchinam hayana inin zagiminna, isa pirdino tipane. ");
INSERT INTO amf_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Inta meten innonna i tarjina, isa tarjamono gontehe. ");
INSERT INTO amf_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ina tarjea eedi kala daane; kidiar ina kinin tarjayno tarjamono gon konin dohonam dhesayda dhese. ");
INSERT INTO amf_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Yedi eenaam Wanniskal ye yittsade; kidiar goninna tarjidine. ");
INSERT INTO amf_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ogoam inin yena giyayno yenin dhaqoadettsine; eedikalanka tarjamo iam zaskonnatehe. ");
INSERT INTO amf_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Wannisar kattsi shaakea nuudettsi ki dahade; yediar likka wodana kisa shaakanka wozadhana ye nashade. ");
INSERT INTO amf_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Wannis ina kinin tarjorra sagi tarja isa daane; isa tarjamonoar Imba inin waadadhoadettsi ina kinin imoono waadimanone. Ogono inin waadadhayno waadimano Imba iam kinin nittsondettsi innon goynsa koda tarje. ");
INSERT INTO amf_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Iam nittsaa Imbaar ina tarjidine. Yediar kisa upsinam qanseetene; kiamaar haapeetene. ");
INSERT INTO amf_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kinin nittsaadar woylamin yenin qajaamonna, kisa upsinoar yekal qolehe. ");
INSERT INTO amf_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yedi Mathaap Gazante rooro wul lay sadanam yenin haapea yena konin maatenna, yedi Mathaapinam payya hayayse marmaraate yeda nabbabe; ogono Mathaapinoar ina tarjaynone. ");
INSERT INTO amf_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ko dahaannaar ogo sadanam haapana ikal nivana zagattene. ");
INSERT INTO amf_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Inta eedikalanka gobshinam zagattine. ");
INSERT INTO amf_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ko dahaannaar inta yeam dhesidine; Barjosa nashimmakkonin yekal qolmonam dhesayda dhese. ");
INSERT INTO amf_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Inta Imbasa hayamonka i nivade; yedi iam tiyeetene. Eedi ab yisa hayamonka ki nivina, kiam tiyeeda tiye. ");
INSERT INTO amf_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Yedi kinka kikalanka gobshin zagayna, kalaa Barjokalanka haapadhen gobshinam zagimina eena, haminee idar woylamin qajana dame? ");
INSERT INTO amf_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Inta Imbasa birante yeam inin bersea yena ko maatabhoode. Yeam bersea daane; agaar yenin kidar qaabe hayea Musene. ");
INSERT INTO amf_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Muse innon goynsa kinin thaaponna, kinin thaaponam gonne hamayse tiydi ye hanna, idar woylamin ini qajeeda qaje. ");
INSERT INTO amf_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kinin thaaponam gonne hamayse ye tiyaamma, isa upsinam gonne hamayse haminee tiye?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ogosa budonte Yesus Thibiriyadoos hambhen Galila bazinsa saabar ki sagade. ");
INSERT INTO amf_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Thoothino eenoar Yesus hajadhaanaam pacchaate kinin waadadhon tarshen yerinam konin haaponna, Yesusbesana ko yivade. ");
INSERT INTO amf_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ogo wodanka Yesus dhukandar utayse yisa paanan yivayna eenabesana kinka ki dooqade. ");
INSERT INTO amf_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ayiwd eensa Paasikan bavallo ko yeskade. ");
INSERT INTO amf_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ogo wodanka Yesus dheg hamayse thoothino eeno yikal konin nivenka koam shedayse Pilbhoosna yi giyna: “Ko eenin itsoadettsi gala hamoroo shano?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesus yin kinin giyoono Pilbhoossa bhocchinam dhesannane; yinin hayenam birayse dhesa ki dhese. ");
INSERT INTO amf_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilbhoosaar kina yinin maasenka, “Wulna likka likka kashate kena yeskisana mato lamaa birreka shandhea gala hattear yeekehe” hamayse kina ki maasade. ");
INSERT INTO amf_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yesussa paanan yivaynasa kalaa, Simoon Bhethiroossa indanaasa Indirias yi giyna: ");
INSERT INTO amf_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Mattsi balasha dongbee kaara lamaabe yedaa naasi kalaa kote daane; ko dahaannaar igina galana koaddhan eenna hamin ke yeeke?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesusaar yisa paanan yivaynaka “Eenam dottsee” kena ki hamade. Ogo raqintear thoothi shudhin dohonna, eeno daran ko dooqade. Anngina gembhasa paydino shii dongaddhane. ");
INSERT INTO amf_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesus balashanam tiyayse Barjoam miskeka gobshayse dooqon eenna kenin imoadettsi ki hayade; kaaranamaar agaadettsi yin ki hayade. Eeno wul yina zaskaadettsi ko itsade. ");
INSERT INTO amf_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Itsayse konin mishonsa budonte, Yesus yisa paanan yivaynana “Dirma kalaar shidhoamadettsi wulam pucchee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ogonante mattsin balashan dongra een itsaysaka shidhoono dirmano ke pucchaysaka, sharqa tabhi lamaa ko thoothade. ");
INSERT INTO amf_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Eenoar Yesusin hayon tarshen yerinam yinin haapon wodanka, “Kaa gon ‘Peen kodar niva ki nive’ hambhea Barjokala qansayse eenna giyeane” ko hamade. ");
INSERT INTO amf_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ogona Yesus eeno kantaka yedayse bitinsana kiam konin zagonam dhesayse, pir yimal dhukandar yivayse ki dooqade. ");
INSERT INTO amf_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Peenin sootenka Yesussa paanan yivayna bazinsa apondar ke yivade. ");
INSERT INTO amf_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bazindara sagadhen gonngalantear ardayse bazinsa saabar dohon Qipirnaahoomdar yivite ke dahade. Ogo wodanka peeno thipane; Yesusaar akar kekal nivadehe. ");
INSERT INTO amf_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Wura kanta jibarshonna, bazino shoan ko yedade. ");
INSERT INTO amf_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Yesussa paanan yivayna bazindar sagadhen gonngalanka bazinsa shaarinte kenin yeskonsa budonte, Yesus bazindar rooka tigate nivite kenin dohon gonngalansa gasante kinin theedenka kiam haapayse ke kurtumbhade. ");
INSERT INTO amf_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kidiar “Intane, kurtumbheebhode!” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ogonante kediar yikal gonngalante kiam arsana ke nashade; saana gonngalano kenin yiven raqindar ko yeskade. ");
INSERT INTO amf_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kina hamon bazinsa saabar dahaana eena naa bazindar gonngala kalaa bish konin dohonam ke haapade. Yesussa paanan yivaynaar yimal bish kenin yivonbee Yesus kembesana kinka bazindara sagadhen gonngalante kinin ardaamonbeam ke dhesade. ");
INSERT INTO amf_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ko dahaannaar waani bazindara sagadhayna gonngalana Thibiriyadoos katamara utayse Yesus Barjoam gobshayse eenam balashan kinin kunson raqinte ke nivade. ");
INSERT INTO amf_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Eeno Yesusbee kisa paanan yivayna eenabe raqin ogote kenin qolmonam yinin haapon wodanka, igina bazindara sagadhayna gonngalanar ardayse Yesusam zagate Qipirnaahoomdar ke yivade. ");
INSERT INTO amf_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bazinsa saabar kiam yinin haapenka, “Woam Dhettsea, kote haa nivaa?” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesusaar kena yin ki giyade: “Inta yena gon ida giye: Iam yenin zagayno balashanam yenin itsonnabee yenin mishonnabene; tarshen yerinam yenin haaponnatehe. ");
INSERT INTO amf_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ko dahaannaar, inta Eedi Naas yena inin imen, rooro wul lay dehen sadanna maaten galanna waadadhee; kayen galanna waadadheebhode. Barjo Imba iam yinin nittsonam dhaydine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ta keeda “Barjosa waadimanam waadadhana yer haroo waadadho?” hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesusaar “Barjosa waadimano yinne: Kinin yittsaadar woylamin ye qajene” hamayse kena ki maasade. ");
INSERT INTO amf_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kediar kina yin ke giyade: “Ta keeda koam shedayse hadar woylamin wonin qajoadettsi tarshea yer haraa wona waadadhe? Haraa wona haye? ");
INSERT INTO amf_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","‘Kenin itsoadettsi cecira balasha kena ki imade’ hamayse thaapadhondettsi ena wosa imbana darante manna hambhen galanam ke itsade” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesus “Inta yena gon ida giye: Gonin balashanam cecira yena imea Imbane; cecira balashanam yena imaa Musetehe. ");
INSERT INTO amf_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Barjoyn imea balasha cecira hanchaa, peendar dohon eenna sadan imeane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ogonante “Imbo, balashan ogoam rooro wul wona imaa” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesusaar kena yin ki giyade: “Sadan imea balashaa intane; ikal nivea hamin ko dahaakaar daaqardhehe; pir idar woylamin qajea hamin ko dahaakaar dheebardhehe. ");
INSERT INTO amf_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ko dahaannaar yena inin giyaadettsi, yedi iam shedaysear idar woylamin qajeetene. ");
INSERT INTO amf_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Imba ina kinin imoono wul ikal koda nive; ikal nivear hamin ko dahaakaar kiam mayanka bulattine. ");
INSERT INTO amf_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Inta cecira inin nivoono iam nittsaasa bhocchinam hayanane; isa bhocchinam hayana nivaatine. ");
INSERT INTO amf_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Iam nittsaasa bhocchinoar ina kinin imaana eenasa kala hattear inin kaysoamadettsibee macchin rooroakaar keam dembhira inin dhaasoadettsibene. ");
INSERT INTO amf_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Imbasa bhocchino Naasaam shedayse kidar woylamin qajea rooro wul lay dehen sadanam kinin haapoadettsine; intaar macchin rooroaka kiam dembhira dhaasayda dhaase” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ogonante Yesus “Cecira hanchaa balasha intane” kinin hamon goynka Ayiwd eena kidar gundumite ");
INSERT INTO amf_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","yin ke giyade: “Agaa Yoseep naasa Yesustayu? Imbaabee indanbe wonin dhesaynatayu? Ta keeda ‘Cecira i nivade’ hamayse hamin ki yin giyaa?” ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesusaar kena yi giyna: “Kinka kikal gundumeebhode. ");
INSERT INTO amf_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Iam nittsaa Imba yiam eelaamma ikal nivana damea qolehe; intaar macchin rooroaka kiam dembhira dhaasayda dhaase. ");
INSERT INTO amf_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","‘Kedi wul Barjokalanka dhesaana keda maate’ hamayse Barjokala qansayse eenna giyaynasa mathaapinte thaapadhidine; ta keeda Imbakalanka qansayse dhesaana wul ikal keda nive. ");
INSERT INTO amf_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Yin giyntano Imbaam haapaa eedi daane hamintatehe; Imbaam haapaa Barjokalanka nivaa kidi bishne. ");
INSERT INTO amf_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Inta yena gon ida giye: Idar woylamin qajeasa rooro wul lay dehea sada kisa daane. ");
INSERT INTO amf_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Sadan imea balasha intane. ");
INSERT INTO amf_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yesa imbana darante mannan hambhen galanam ke itsade; ko dahaannaar kedi diydine. ");
INSERT INTO amf_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Cecira taaki hanchaa balashaa kaane; agaa balashaam itsaa ea rooro wul dembhi diyehe. ");
INSERT INTO amf_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Cecira hanchaa sadan imea balashaa intane; agaa balashaam itsea rooro wul lay dehen sadanka kida dee. Peendar dohon eenna sada konin maatoadettsi inin imayno balashano isa waanone” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ogona Ayiwd eena “Kaa ea kisa waanam wonin itsoadettsi hamin ki wona imana dame?” hamayse kinka palimite ke dahade. ");
INSERT INTO amf_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ogonante Yesus kena yin ki giyade: “Inta yena gon ida giye: Eedi Naasisa waanam ye itsaamma, kisa zombhinamaar ye wucaamma, sada yesa qolehe. ");
INSERT INTO amf_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Isa waanam itseabee isa zombhinam wuceabesa rooro wul lay dehea sada kisa daane; intaar macchin rooroaka kiam dembhira dhaasayda dhaase. ");
INSERT INTO amf_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Isa waano gon hama galane; isa zombhinoar gon hama wucadheane. ");
INSERT INTO amf_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Isa waanam itseabee isa zombhinam wuceabe inka kida dee; intaar kanka ida dee. ");
INSERT INTO amf_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Sadan imea Imba iam kinin nittsondettsibee inta kinnon goynka sadaka inin dohondettsibe, isa waanam itsea pir innon goynka sadaka kida dee. ");
INSERT INTO amf_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ta keeda cecira hanchaa balasha kaane. Ena wosa imbana darante mannan hambhen galanam itsayse kenin diyondettsitehe; balashan koam itsea rooro wul lay dehen sadanka kida dee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesus ogoam kinin giyoono Qipirnaahoom Ayiwd eensa bukin raqinte eenam yinin dhettsenkane. ");
INSERT INTO amf_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesussa paanan yivayna eenasa thoothina eena kinin giyenam yinin qansenka, “Dhalqa kaa kattsi dethane; hayne tiyana damea?” ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesusaar yisa paanan yivayna dhalqin ogoka kenin gundumonam yisa woylaminka dhesayse, “Dhalqa kaa yena goa maatidu? ");
INSERT INTO amf_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ta keeda Eedi Naas birayse yinin dohondar maatate tura kinin yivenam ye haapidianna, yedi haminee giye? ");
INSERT INTO amf_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Sadan imayno Manpas Gazanone; eedisa kanta yer harrnaar pootehe. Inin yena giyoono upsino sadan imen Manpasinam bavaynone. ");
INSERT INTO amf_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ko dahaannaar yesa iira inin giyenam gonne hamayse tiymina daane” kena ki hamade. Yesus ogoam kinin giyoono gonne hamayse tiymina haybe kenin dohonbee yettsate imea hay kinin dohonbeam birara yedayse yinin dhesonnane. ");
INSERT INTO amf_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yesus tapir “‘Barjo Imba ikal ki nive ki hayaamma, ikal hayyear nivana damehe’ hamayse inin yena giyoono ogonane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ogo wodanka kisa paanan yivayna eensa shaarira thoothina eena budoka ke maatade; ogora yedayse kimbesana kinka yivanam ke garade. ");
INSERT INTO amf_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yesusaar tabhi lamaana yisa paanan yivaynana “Yediar ta ikala yivana zagee zago?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoon Bhethiroos yi giyna: “Imbo, wodi haydaroo yivo? Rooro wul lay dehen sadan imea upsi hakal daane. ");
INSERT INTO amf_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Barjoyn qaadhaa Gazaa Ea hanin maatonam gonne hamayse wodi tiydine; dhesidine” hamayse kina ki maasade. ");
INSERT INTO amf_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesusaar “Ye tabhi lamaanaam kamaa intatayu? Yesa iira kalaa Seethaanne” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ogoam kinin giyoonoar Asqoronto peen ea Simoon naasa Yiwdasane; kidi tabhi lamaanasa kalaa dahayse os birante Yesusam yettsate kinin imennane. ");
INSERT INTO amf_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ogosa budonte Yesus Yiwda peente yaayana yinin nashaamonna, Galila peente kida yaaye. Harrna hambhidianna, Ayiwd eenam entsayna kiam deesana kenin zagennane. ");
INSERT INTO amf_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ayiwd eensaar baarante dooqayse gobshadhayno bavallo ko yeskade. ");
INSERT INTO amf_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ogonante Yesussa indanaana kina yi giyna: “Hambesana yivayna thoothina eena hanin waadadhen tarshen waadimanam kenin shedoadettsi kora dhaabhayse Yiwda peendar yivaa. ");
INSERT INTO amf_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Harrna hambhidianna, eenkal dhesadhana zagea waadiman yinnonam aachika waadadhehe; yaar iginaam hanin waadadhenna, peendar dohon eenna haam dhahaa” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kisa indanaana ogoam kenin giyoono kedi yina kidar woylamin kenin qajaamonnane. ");
INSERT INTO amf_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesus “Isa wodano akar yeskadehe; yena wodano wul agoonone. ");
INSERT INTO amf_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Peendar dohon eeno yeam jibbana damehe; iam jibba ko jibbe. Harrna hambhidianna, inta eensa waadimano siya konin dohonam kodar inin tarjennane. ");
INSERT INTO amf_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yedi ogo bavaalindar yivee; isa wodano akar konin yeskaamonna, inta akar bavaalindar yivattine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ogoam kena yin giyayse Galila peente ki shidhade. ");
INSERT INTO amf_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kisa indanaana bavaalindar kenin yivonsa budonte, Yesus may dayma aadhimeka ogo bavaalindar ki yivade. ");
INSERT INTO amf_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ayiwd eenam entsaynaar “Kidi hamote ki dahaa?” hamayse bavaalin gobshota nivon eensa shaarinte zagite ke dahade. ");
INSERT INTO amf_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Zarsinsa shaarinte kinnon goynsa thoothi gundume ko dahade. Waani eenaar “Kidi eedi payyane” kenin hamenka, waani eena “Aavav, kidi eenam kida dhaddhise” hante ke dahade. ");
INSERT INTO amf_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ko dahaannaar eeno Ayiwd eenam entsaynana yinin kurtumbhonna, hayyear kisa may giyehe. ");
INSERT INTO amf_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Taar baarante dooqayse bavaalin gobshadhayna rooronasa gidi lamante Yesus Barjosa gazan ooninsa mayante yivayse eenam dhettsan ki yedade. ");
INSERT INTO amf_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ayiwd eenam entsaynaar “Ea kaa yiggin timmirinam timmirima ko wulam hamin ki dhesana damaa?” hamayse targadhite ke dahade. ");
INSERT INTO amf_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ogonante Yesus “Isa timmirino iam nittsaakalankane; ikalankatehe. ");
INSERT INTO amf_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Iam nittsaa kinin giyonam hayana zagea hayyear ki hanna, ogono timmirino Barjokalanka haapadhoono way inta ikalanka inin giyaa konin maatonam kida dhese. ");
INSERT INTO amf_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yikalanka giyea yisa metensa gobshinam kida zage. Yiam nittsaasa gobshinam zagea ea kidi gonin eane; buuda kikal qolehe. ");
INSERT INTO amf_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Muse yigginam yena imittayu? Ko dahaannaar yesa shaarira yigginam toolea eedi kala hattear qolehe. Ta deesana iam harrnee zagaa?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Eenoar kina yinin maasenka, “Beero hadar dahade! Hayne haam deesana zagea?” ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesusaar kena yi giyna: “Inta yer kalaa i waadadhade; yedi wul yerin ogoam shedayse yeda targadhe. ");
INSERT INTO amf_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Muse qaaman taxadhensa gilonam yena ki imade; ogono gilono konin nivoono wosa imbanakalankane, Musekalankatehe. Yedi ukunsen rooroakaar eensa qaamanam yeda taxe. ");
INSERT INTO amf_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ta keeda Musesa yiggino konin shidhoamadettsi eensa qaamanam ukunsen rooroaka taxadhidianna, inta ukunsen rooroaka eensa bishin wulam inin pacchonna, iam wacimee wacimo? ");
INSERT INTO amf_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Pirdinam tipamoka pirdee; eedisa woti shedayse pirdeebhode” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Keeda Yerusaalem eensa shaarira waani waani eena “Hayonayn deesanna zagea ea kaatayu? ");
INSERT INTO amf_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Marrato! Kidi yisa dhalqinam may hayayse kida giye; kediar kikal yer kala hattear giyehe. Way ea kaa Barjoyn qadhaa Kiristoos kinin dohonam hayona gon kiam kedi dhesidu? ");
INSERT INTO amf_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ko dahaannaar ea kaa hamora kinin nivonam dhesooda dhese; Barjoyn qadhaa Kiristoosin nivenka, hamora kinin nivonam hayyear kiam dhesehe” ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ogonante Yesus Barjosa gazan ooninsa mayante eenam yinin dhettsenka upsi gebhika “Iam dheseeda dhese; hamora inin nivonam dheseeda dhese. Isa bhocchika nivaatine. Iam nittsaa gon hamaane. Ko dahaannaar yedi kiam dhesattene. ");
INSERT INTO amf_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Inta kiam dhesayda dhese. Harrna hambhidianna, iam ki nittsaysaka kikalanka i nivade” hamayse ki giyade. ");
INSERT INTO amf_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ogonante hayona kiam yedana ke zagade; ko dahaannaar kisa wodano akar yeskaamonna, hayyear kiam yedadehe. ");
INSERT INTO amf_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Eensa iira thoothino eeno kidar woylamin ko qajade. “Barjoyn qadhaa Kiristoos yinin nivon wodanka, ea kaanin waadadhaana tarshayna yerradara sagi waadadhok?” hamayse ke giyade. ");
INSERT INTO amf_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Thoothino eeno kinnon goynka konin gundumenka Parisa eena ke qansade; ogonante gudullasa hayonabee Parisa eenabe Yesusam kenin yedoadettsi yisa poolisanaam ke yittsade. ");
INSERT INTO amf_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ogo wodanka Yesus “Likka wodana yembesana kinka ida dee; ogosa budonte iam nittsaadar ida yive. ");
INSERT INTO amf_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Iam zageeda zage, iam haapattene; inin dohon raqinte yedi nivana damattene” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ogonante Ayiwd eensa entsana yin ke giyade: “Wonin kiam haapoamadettsi ea kaa hamodar yivana ki haye? Way Ayiwdtay hamon eensa shaarinte wanthimayse dahaana Ayiwd eenakal yivayse Ayiwdtay hamon eenam dhettsana ki hayo? ");
INSERT INTO amf_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Kidiar ‘Iam zageeda zage, haapattene; inin dohon raqinte nivana damattene’ hamayse kinin giyoono upsino kisa hamin giyntane?” hamayse kinka kikal ke dhalqade. ");
INSERT INTO amf_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Bavaalinsa macchea rooroa gebhaaka Yesus woyayse, “Hayyear dheebardhaa dahaa yi hanna, ikal nivayse ki wuce. ");
INSERT INTO amf_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Idar woylamin qajea Mathaap Gazanin giyendettsi sadan imayno noqono kisa iira koda ele” hamayse upsi gebhika ki giyade. ");
INSERT INTO amf_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ogoam kinin giyoonoar kidar woylamin qajayna kenin tiyen Manpas Gazan goynsane. Yesus akar kinin gobshaamonna, Manpas Gazano akar eendar hanchadehe. ");
INSERT INTO amf_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ogonante eensa iira waani eeno dhalqin ogoam yinin qansen wodanka, “Kaa gon ‘niva ki nive’ hambhea Barjokala qansayse eenna giyeane” ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Waani eeno “Kaa Barjoyn qadhaa Kiristoosne” ke hamade. Waani eeno tapir “Gon Barjoyn qadhaa Kiristoos Galila peera niva ki nivo? ");
INSERT INTO amf_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Barjoyn qadhaa Kiristoos Dawtsa muldhara kinin adhadhendettsibee Dawtin adhadhon kataman Betelemra kinin nivendettsibe Mathaap Gazante thaapadhittayu?” ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ogonante kinnon goynka eensa shaarinte edime ko dhaabhade. ");
INSERT INTO amf_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Kesa shaarira waani waani eeno yedana kiam ke zagade; ko dahaannaar hayyear kiam yedadehe. ");
INSERT INTO amf_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Gudullasa hayonabee Parisa eenabekal poolisana maatate ke nivade. Gudullasa hayonabee Parisa eenabe “Yedi kiam harrnee bavima garaa?” kena ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Poolisanaar “Ea agaanin giyendettsi eedi hayyear giyayse dhesehe” hamayse kena ke maasade. ");
INSERT INTO amf_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Parisa eena, “Yedi keeda taysee taysadhaaw? ");
INSERT INTO amf_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Hayona eenasa way Parisa eensa shaarira kidar woylamin qajaa daaw? ");
INSERT INTO amf_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ko dahaannaar Musesa yigginam dhesimino eeno ogono ashadhoonone” hamayse kena ke maasade. ");
INSERT INTO amf_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Parisa eenasa kalaa kosa birayse Yesuskal nivaa Niqodimos yi giyna: ");
INSERT INTO amf_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Wonnon yigginka eedi kalaa birayse kinin giyenam qansimabee har kinin waadadhonam dhesimabe kidar pirda ko pirdadho?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Kediar kina yi giyna: “Yaar Galila peeraw? Barjokala qansayse eenna giyea Galila peera kinin dhaabhiminam marmarayse dhesaa!” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ogora kedi wul yisa onnadar ke yivade. ");
INSERT INTO amf_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesus raqin ogora dhaabhayse, Dabirezayt dhukandar ki yivade. ");
INSERT INTO amf_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Burin sedhiman Barjosa gazan ooninsa mayante maatate ki nivade; eeno wulaar kikal ko nivade; kidiar dooqayse keam dhettsite ki dahade. ");
INSERT INTO amf_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Musesa yigginam dhettsaynabee Parisa eenabe sharmucimakkoka yedadhon edonam kikal bavate nivayse eensa shaarinte koam woysayse, ");
INSERT INTO amf_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Dhettsea, edon koam sharmucimakko ko hayaka ko yedadhade. ");
INSERT INTO amf_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Muse ogodettsi sharmucimakkon hayen edonam seenika paxate wonin deesoadettsi yigginte wona giydine; ya ta kosa haminaa giye?” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ogono kenin giyoono kiam bersana goyti haapana zagayse kiam taysayse ke shedade. Yesusaar yirk hamayse yisa aaninka peendar ki thaapade. ");
INSERT INTO amf_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Maasayse maasayse kiam kenin oysenka, tura dheg hamayse, “Yesa shaarira seesoysa qolmaa birayse koam seenika ki paxe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tapir yirk hamayse peendar ki thaapade. ");
INSERT INTO amf_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kediar dhalqin ogoam yinin qansen wodanka, donzanara yedayse agaa raqara kalaa kalaa yivate ke maqade; Yesusbee edonbe bish ke shidhade. ");
INSERT INTO amf_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ogosa budonte Yesus tura dheg hamayse, “Ya edono, haam bersayna eena hamote ke dahaa? Hadar pirdea eedi qolaaw?” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Kodiar “Imbo, eedi kala hattear qolehe” kina ko hamade. Yesusaar “Intaar hadar pirdattine. Yivaa; keeda kaara os seeso hayaabhode” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tapir Yesus eenna yi giyna: “Peen kodar dohon eensa shaakaa intane. Isa paanan nivea eana sadansa shaakano kina shaaka ko shaake; thipante yaayehe” hamayse kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Parisa eenaar “Ya hannon metenna hada tarje; hasa tarjamonam gonne hamayse tiidhehe” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesusaar yin giyayse kena ki maasade: “Meten innonna i tarjina, hamora inin nivonbee hamodar inin yivenbeam inin dhesenna, isa tarjamono gonne. Yediar hamora inin nivonbee hamodar inin yivenbeam dhesattene. ");
INSERT INTO amf_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yedi eedi bhocchika pirdinam yeda pirde; inta eedi kaladar hattear pirdattine. ");
INSERT INTO amf_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","I pirdidianna, inta imal bish dayma, iam nittsaa Imba imbete kinin dohonna, isa pirdino gonne. ");
INSERT INTO amf_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Eedi lamaasa tarjamono gonne hamayse konin tiidhayno yesa yigginte thaapadhidine. ");
INSERT INTO amf_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Innon goynsa tarjea intane; iam nittsaa Imbaar innon goynsa kida tarje” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kediar “Hamba hamote ki dahaa?” kina ke hamade. Yesusaar yin giyayse kena ki maasade: “Iamaar way Imbaamaar dhesattene; iam ye dhesidianna, Imbaamaar ini dheseeda dhese” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesus Barjosa gazan ooninsa mayante eenam yinin dhettsenka, koymon dhabadhen saathininkal theedi dahayse dhalqin ogoam ki giyade. Kisa wodano akar yeskaamonna, hayyear kiam yedadehe. ");
INSERT INTO amf_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesus tapir “Yivayda yive; yediar iam zageeda zage; yesa seesonkaar diyeeda diye. Inin yiven raqindar yedi yivana damattene” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ayiwd eenam entsaynaar “‘Inin yiven raqindar yedi yivana damattene’ kinin hamoono yiam deesanaw? Haydhe!” ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesusaar “Yedi choobarne, inta bhaabarne; yedi peen korane, inta peen koratehe. ");
INSERT INTO amf_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ta keeda ‘Yedi yesa seesonka diyeeda diye’ yena i hamade. Inta hay inin dohonam gonne hamayse ye tiyaamma, yedi yesa seesonka diyeeda diye” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kediar “Ya hayne?” kina ke hamade. Yesusaar “Birara yedayse yena inin giyaadettsine. ");
INSERT INTO amf_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yesa inin giyeabee yennon goynsa inin pirdeabe thoothi yer daane. Ko dahaannaar, iam nittsaa gon hamaane; intaar kikala inin qanson ogoam peen kodar dohon eenna ida giye” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kediar Imbaasa kena kinin giyenam dhesadehe. ");
INSERT INTO amf_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ogonante Yesus kena yin ki giyade: “Eedi Naasiam yenin ziiten wodanka, inta hay inin dohonbee, Imbaar iam kinin dhettsonam inin giyenbee, isa meteka yer kala hattear inin hayminbeam ogo wodanka dheseeda dhese. ");
INSERT INTO amf_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Iam nittsaa imbesanane; inta kiam wozisenam rooro wul inin waadadhenna, imal iam garadehe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesus dhalqin ogoam kinin giyenka, thoothino eeno kidar woylamin ko qajade. ");
INSERT INTO amf_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesus yidar woylamin qajaana Ayiwd eenna, “Yedi isa upsinka dahaana ye hanna, gon isa paananka yivayna eenane. ");
INSERT INTO amf_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Goninam dheseeda dhese, gonnoar worsho maatayse yenin deherra yeam bula ko bule” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Kediar kina yinin maasenka, “Wodi Abraamsa muldharane; eedi kalana hattear worsho maatootone. Ta ya ‘Worsho maatayse yenin deherra yeam bula ko bule’ hamayse haminaa wona giyaa?” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesus yin giyayse kena ki maasade: “Inta yena gon ida giye: Seeso waadadhea wul seesosa worshone. ");
INSERT INTO amf_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Eedi worsho eedisa ooninte rooro wul dehehe; naasi yi hanna, rooro wul daa ki dee. ");
INSERT INTO amf_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ta keeda Naasa eedisa worsho maatayse yenin deherra yeam kinin bulenna, gon uteeda ute. ");
INSERT INTO amf_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Abraamsa muldhara yenin maatenam dhesayda dhese; ko dahaannaar isa upsinam yenin tiyaamonna, iam deesana yeda zage. ");
INSERT INTO amf_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Inta Imbakal inin haaponam ida giye; yediar imbaa yenteakalanka yenin qansonam yeda waadadhe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Kediar kina yinin maasenka, “Wosa imbaa Abraamne” kina ke hamade. Yesus kena yin ki giyade: “Abraam naana ye hanna, Abraamin waadadhen waadimanam ini yeda waadadhe. ");
INSERT INTO amf_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ko dahaannaar Barjokalanka inin qanson goninam yena giyea iam deesana yeda zage; Abraam yin hayadehe. ");
INSERT INTO amf_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yedi imbaa yenteasa waadimanam yeda waadadhe” kena ki hamade. Kediar “Wodi baskamoka adhadhootone. Imba kalaa wosa daane; kidiar Barjone” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesusaar kena yin ki giyade: “Barjo yesa Imba ki hanna, iam ini nasheeda nashe. Harrna hambhidianna, inta Barjokalanka i nivade; kidi iam ki nittsade; inta innon bhocchinka nivaatine. ");
INSERT INTO amf_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Inin giyenam yenin bhocchimino harrnane? Isa upsinam qansana yenin damaamonnane. ");
INSERT INTO amf_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Yedi yesa imbaa Seethaankalankane; kisa anngarmanam waadadhana yeda nashe. Kidi ena birara yedayse eediam deeseane; gonin kikal qolmonna, kidi goninka woyadehe. Buudaabee buudansa imbaa yinin dohonna, buudanam yinin giyenka yisa bhocchira kida giye. ");
INSERT INTO amf_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Intaar goninam inin giyenna, inin giyenam gonne hamayse tiyattene. ");
INSERT INTO amf_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yesa iira ‘Ya seeso haydine’ hamayse ina dhiidhimea hayne? Ta goninam giyea i hanna, inin giyenam harrnee tiyan garaa? ");
INSERT INTO amf_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Barjo naas maataa Barjosa upsinam kida qanse; yenin qansimino Barjosa naasi yenin dahaamonnane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ayiwd eenam entsaynaar kina yi giyna: “‘Ya Sammaria eedine; beero hadar dahade’ wosa hamintano gontayu?” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesusaar kena yinin maasenka, “Idar beero qolehe. Ko dahaannaar inta Imbaam ida gobshe; yediar iam yeda bage. ");
INSERT INTO amf_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Intaar isa gobshinam zagattine. Inin gobshadhoadettsi zagea daane; pirdea kidine. ");
INSERT INTO amf_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Inta yena gon ida giye: Inin giyen upsinam toolea hayyear dembhi diyehe” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ayiwd eenam entsaynaar “Beero hadar dohonam ta wodi dhesidine. Abraamaar diydine; Barjokala qansayse eenna giyaynaar diydine. Ya ‘Inin giyen upsinam toolea dembhi diyehe’ hada hame. ");
INSERT INTO amf_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ta ya wosa imbaa Abraamdaraar sagaa sago? Kidi diydine; Barjokala qansayse eenna giyaynaar diydine; ya haam hayyea hame?” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesusaar yin giyayse kena ki maasade: “Inta iam i gobshina, isa gobshino pootehe. Iam gobshea ‘Kidi wosa Barjoane’ yenin hamea Imbane. ");
INSERT INTO amf_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Yedi kiam dheseetene; inta kiam dhesayda dhese. ‘Kiam dhesattine’ i hamidianna, ini yedettsi buuda eedi i maatade. Ko dahaannaar kiam dhesayda dhese; kisa upsinam toolayda toole. ");
INSERT INTO amf_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Yesa imbaa Abraam isa rooronam anngardhite shedana kattsi wozadhite ki dahade; ogoraar shedayse ki wozadhade” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ayiwd eenam entsayna “Ya akar eedi lamaa kaysa apo tabhi leveysa maataama ea Abraamam ya haapidu?” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesusaar “Inta yena gon ida giye: Abraam adhadhima birayse inta daane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ogonante kiam paxayse deesana seeni ke tiyade; Yesusaar kekalanka aadhimbhayse Barjosa gazan ooninsa mayara utayse ki yivade. ");
INSERT INTO amf_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesus goynka kinin yivenka, aapi kaya dahayse adhadhaa eedi kalaam ki haapade. ");
INSERT INTO amf_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yesussa paanan yivaynaar Yesuskal “Woam Dhettsea, ea kaa aapi kaya dahayse kinin adhadhoadettsi seeson hayaa hayne? Kidimoo? Kiam adhaana eenaw?” hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesusaar kena yinin maasenka, “Barjosa waadimanam kanka konin dhesadhoadettsine; kidi way kiam adhaana eena seeso kenin hayonnatehe. ");
INSERT INTO amf_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Rooron daaka iam nittsaasa waadimanam haya iam koda zaske; hayyear waadadhana kinin damimino sooti niva ko nive. ");
INSERT INTO amf_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Peendar inin dohonka, peendar dohon eensa shaakaa intane” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ogoam yinin giyonsa budonte yirk hamayse pathika peenam capshayse aapin kaya easa aapinam ki qadhade. ");
INSERT INTO amf_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ogora eana “Yivayse Seeloom dalbante shiidhaa” kina ki hamade. “Seeloom” hamintano “nittsadhaa” hamintane. Ogonante ea yivayse yisa aapinam shiidhayse, shedada ki nivade. ");
INSERT INTO amf_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kisa gurdan eenabee birayse yer ki miskaka kiam shedaana eenabe “Kaa ea dooqayse miskimeatayu?” ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Waani eena “Kaa kidine” ke hamade; waani eena “Aavav, kaa kiam kida maate, kiditehe” ke hamade. Kidiar “Intane” kena hamite ki dahade. ");
INSERT INTO amf_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Eenaar “Ta keeda aapino hanno hamin hayayse ko shedaa?” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Kidiar kena yinin maasenka, “Yesus hambhea ea peenam pathika capshayse isa aapinam qadhayse, ‘Seeloom yivayse shiidhaa’ ina ki hamade; intaar yivayse i shiidhade; isa aapinoar ko shedade” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Kediar “Ea agaa ta hamote ki dahaa?” ke hamade. Kidiar “Hamote kinin dohonam inta dhesattine” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kedi ena aapin kayaa eam Parisa eenakal entsate ke yivade. ");
INSERT INTO amf_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesus peenam pathika capshayse easa aapindar qadhayse kinin pacchoono wodano Ayiwd eensa ukunsen rooroakane. ");
INSERT INTO amf_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ogonante Parisa eena “Hamin hayaysea shedaa?” hamayse pir kiam ke oysade. Kidiar “Pee caapi tiyayse isa aapindar ki qadhaysaka shiidhayse i shedade” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ogonante Parisa eensa shaarira waani eena “Ea agaa ukunsen rooroam kinin gobshiminna, kidi Barjokalankatehe” ke hamade. Waani eena tapir “Kidi seeso eedi ki hanna, ogodettsi tarshayna yerraam hamin ki waadadhana dame?” ke hamade. Ogoka kesa shaarinte edime ko dhaabhade. ");
INSERT INTO amf_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ogona yisa aapin kayaa eana “Aapin hannon kinin pacchonna, ya ea agaasa hamina giye?” hamayse tapir kiam ke oysade. Kidiar “Barjokala qansayse eenna giyeane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ayiwd eenam entsaynaar kiam adhaana eenaam eelayse keam oysate yinin dhesenka yekka, kidi ena aapi kaya kinin dohonbee ta kinin shedenbeam gonne hamayse kedi tiyadehe. ");
INSERT INTO amf_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ogonante kisa imbanana yi giyna: “Yedi ‘Aapi kaya maatayse ki adhadhade’ yenin hamea yesa naasa kaa kidiw? Ta hamin hayayse ki shedaa?” hamayse keam ke oysade. ");
INSERT INTO amf_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Kedi imbanaar “Kaa wosa naasi kinin dohonbee ena aapi kaya maatayse kinin adhadhonbeam wodi dhesooda dhese. ");
INSERT INTO amf_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ko dahaannaar ta hamin hayayse kinin shedonam dhesattone; aapinam kisaar hayn pacchonam wodi dhesattone. Yedi kiam oysee. Kidi eedi gebhine; yinnon metensa yinti giyana dama ki dame” kena ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Imbana yin kenin giyoono Ayiwd eenam entsaynana yinin kurtumbhonnane. Harrna hambhidianna, “‘Yesus Barjoyn qadhaa Kiristoosne’ hamayse tarjea eedi daa ki hanna, bukin raqira bulooda bule” hamayse Ayiwd eenam entsayna birayse kinka kenin dhalqonnane. ");
INSERT INTO amf_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ogona kisa imbana “Kidi eedi gebhine; kiam oysee” ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ogonante aapin kayaa eam lansi eelayse, “Ya gon giyayse Barjoam gobshaa! Ea agaa seeso eedi kinin maatonam wodi kiam dhesooda dhese” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Kidi kena yinin maasenka, “Seeso eedi kinin maatonam inta dhesattine; inta yer kalaa ida dhese. Ogonoar isa aapin kayon konin shedoadettsi kinin hayonam bish ida dhese” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kediar tapir “Hana har ki hayaa? Aapin hannonam hamin hayayse ki pacchaa?” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Kidiar kena yinin maasenka, “Ini birayse yena inta giydine; yedi qanseetene. Pir qansana harrnee zagaa? Yediar kisa paanan yivayna eena maatana zagee zago?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kediar kiam iirayse, “Ya ea agaasa paanan yiveane; wodi Musesa paanan yivaynane. ");
INSERT INTO amf_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Barjo Musena kinin giyonam dhesooda dhese; ea kaa hamora kinin dohonam dhesattone” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ear kena yin ki giyade: “Yedi hamora kinin dohonam yenin dhesaammo ogono tarshea yerne. Kidi isa aapinam pacchidine. ");
INSERT INTO amf_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Barjoam kurtumbheabee Barjosa bhocchinam waadadheabe kinin giyenam Barjo qansa ki qanse; seeson eenaam Barjoyn qansiminam dhesooda dhese. ");
INSERT INTO amf_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","‘Aapi kaya maatayse adhadhaa eediam pacchaa daane’ hambhenam peen pijadhorra yedayse qansadhadehe. ");
INSERT INTO amf_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ea agaa Barjokala yi dahaamma, ini yer kalaar waadadhana damehe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Kediar “Ya seesoka dahayse adhadhaa woama dhettso?” hamayse bukin raqira kiam ke bulade. ");
INSERT INTO amf_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Eam bukin raqira kenin bulonam Yesus qansidine. Kiam yinin haapenka, “Ya Eedi Naasdar woylamin qajaa qajo?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Kidiar “Imbo, kidar woylamin inin qajoadettsi kidi hayne?” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesusaar kina yi giyna: “Ya kiam haapidine; taar hambesana kinka dhalqea kidine” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Kidiar “Imbo, inta hadar woylamin qajayda qaje” hamayse kina ki goodimade. ");
INSERT INTO amf_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesusaar “Aapin kayaana kenin shedoadettsi, aapin yisa shedaynaar shedimina kenin maatoadettsi inta peen kodar inin nivoono eenam kikala edanane” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Parisa eensa shaarira kimbesana kinka dahaana ogoam qansayse, “Ta wodiar aapiysa shediminaw?” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesusaar kena yin ki giyade: “Yedi aapiysa shedimina ye hanna, ini seeso yena maatehe; ta keeda ‘Shedooda shede’ yenin hamonna, seeso eedi maatayse shidheeda shidhe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesus “Inta yena gon ida giye: Yaana kerinka ardima goyti abka ardea ea diibibee buurate itseabene. ");
INSERT INTO amf_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kerinka ardea ea yaanaam gisheane. ");
INSERT INTO amf_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kerin toolea kina kerinam kida bule. Yaanaar kisa upsinam qansa ke qanse. Kidiar yisa yaanaam kesa naabenka eelada keam mayanka kida bule. ");
INSERT INTO amf_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yisa yaana wulam yinin bulonsa budonte kesa birante kida yive; yaanaar kisa upsinam yinin dhesenna, kisa paanan keda yive. ");
INSERT INTO amf_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Eedi absa upsinam kenin dhesiminna, kikala goba ke gobe; hamin ko dahaakaar kisa paanan yivehe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesus kamsin ogoam kena ki giyade; kedi kinin giyonam bhocchadehe. ");
INSERT INTO amf_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ogonante Yesus tapir “Inta yena gon ida giye: Yaanasa kerea intane. ");
INSERT INTO amf_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","I nittsima iam birayse nivaana wul diibibee buurate itsea eedibene; ko dahaannaar yaana kesa upsinam qansadehe. ");
INSERT INTO amf_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kerea intane; inka ardea kidi dhaqa ki dhaqe. Arda ki arde; uta ki ute; yinin itsenam kida haape. ");
INSERT INTO amf_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Diibin nivayno diibanabee, taxanabee, kaysanabe bishne. Inin nivoono sada kenin haapoadettsibee ogono sadano kena konin thoothoadettsibene. ");
INSERT INTO amf_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Payyan gishiman gishea intane. Payyan gishiman gishea yisa sadanam yaanana hamayse saskate kida ime. ");
INSERT INTO amf_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Yaanasa imba maataama gishea ea yaayoayn nivonam yinin haapen wodanka, yaanaam garayse kida gobe; yaayoar keam yeda ki yede; yaanaamaar kikalanka thar thar kida haye. ");
INSERT INTO amf_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Gishea ea yaanaam garayse kinin gobayno yaana kinti kenin dahaamonnabee yaanana yinin burqadhiminnabene. ");
INSERT INTO amf_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Payyan gishiman gishea intane. Barjo Imbaar iam dhesendettsi, intaar Barjo Imbaam inin dhesendettsi, isa yaanaam dhesayda dhese; isa yaanaar iam dhesa ke dhese. Isa sadanam kena hamayse saskate ida ime. ");
INSERT INTO amf_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kina yaanasa iir qolmina yaati ab isa daane; keamaar tapir bava iam koda zaske. Isa upsinam qansa ke qanse. Kedi zelen kallon yaana keda maate; keam gishea eedi kalaane. ");
INSERT INTO amf_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Isa sadanam maasate dhaasana dembhinna saskate imayda ime; ogonante Imbaa iam kida nashe. ");
INSERT INTO amf_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Inta isa sadanam saskate inti ida ime; ikalanka koam hayyear tiyehe. Isa sadanam imanabee maasate tiyanabe isa hayamo daane; ko upsinam inin tiyoono Imbakalankane” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Igina upsinaka Ayiwd eenam entsaynasa shaarinte tapir edime ko dhaabhade. ");
INSERT INTO amf_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kesa shaarira thoothino eeno “Rum kidar daane; kidi bardhidine. Kinin giyenam harrnee qanse?” ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Waani eenoar “Igina upsina rum yindar dahaa eedisa upsitehe; rum aapin kayaanasa aapinam pacchana dama ko damo?” ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yerusaalem gidir Barjosa gazan ooninam minngamora gazisadhaana rooronaam gobshadhayno bavallo ko yeskade; ogono wodanoar bargi wodane. ");
INSERT INTO amf_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesusaar Barjosa gazan ooninsa mayante Solomoon baaransa demenka yaayte ki dahade. ");
INSERT INTO amf_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ayiwd eenam entsaynaar kisa gasante bukayse, “Hamaaka yekka qothimaate haam wo toolo? Ya Barjoyn qadhaa Kiristoos ha daana, may wona giyaa!” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesusaar kena yinin maasenka, “Inta yena giydine; yediar inin giyonam gonne hamayse tiyeetene. Inta Imbasa naabenka inin waadadhayno waadimano ina koda tarje. ");
INSERT INTO amf_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Yediar isa yaana yenin dahaamonna, isa dhalqinam gonne hamayse tiyattene. ");
INSERT INTO amf_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Isa yaana isa upsinam qansa ke qanse; intaar keam dhesayda dhese; isa paananka niva ke nive. ");
INSERT INTO amf_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Intaar rooro wul lay dehen sadanam kena ida ime; kedi rooro wul lay kayehe. Isa aanira hayyear keam sarate tiyehe. ");
INSERT INTO amf_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Keam ina imaa Imba wuldara saga ki sage; Imbasaar aanira keam sarate tiyana damea hayyear qolehe. ");
INSERT INTO amf_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Imbee Imbabe wodi kalaane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ayiwd eenam entsayna Yesusam paxana pir seeni ke tiyade. ");
INSERT INTO amf_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesus “Imbakalanka thoothi payya waadimanam yena i dhahade; igina waadimanasa waadima hamaasa iam ye paxe?” hamayse keam ki oysade. ");
INSERT INTO amf_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ayiwd eenam entsaynaar “Haam wonin paxayno hasa payyan waadimanna dayma, Barjoam hanin iirennane; ogonoar ya eedi dahayse haam Barjo hanin hayonnane” hamayse kina ke maasade. ");
INSERT INTO amf_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesusaar yin giyayse kena ki maasade: “Yesa yigginte ‘Yedi barjonane i hamade’ hamayse Barjoyn giyoono thaapadhittayu? ");
INSERT INTO amf_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mathaap Gazanam ookana damimehe. Barjosa upsinin yina nivaana eenaka ‘Yedi barjonane’ Barjo keam hamidi ki hanna, ");
INSERT INTO amf_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","‘Inta Barjo Naasane’ inin hamonna, yedi Imba kinin gazisaa, peen kodar kinin nittsaa ‘Barjoam hada iire’ hamayse haminee iam giyaa? ");
INSERT INTO amf_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Inta Imbasa waadimanam i waadadhiminna, iam gonne hamayse tiyeebhode. ");
INSERT INTO amf_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Imbasa waadimanam i waadadhea hanna, iam gonne hamayse ye tiyaammaar, isa waadimanam gonne hamayse tiyee. Imba inka kinin dohonbee intaar Imbaka inin dohonbeam ogoka payya hayayse dheseeda dhese” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Kediar tapir kiam yedana ke zagade; kidiar kekalanka dhaqate ki yivade. ");
INSERT INTO amf_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesus Wannisin birayse eenaam kinin shivon Yordaanoos baynsa saabar tapir yivayse raqin ogotear ki dooqade. ");
INSERT INTO amf_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Thoothino eenoar kikal ko nivade. Kediar “Wannis tarshea yer kala hattear waadadhadehe; ko dahaannaar Wannis ea agaasa kinin giyoono wul gonne” hamite ke dahade. ");
INSERT INTO amf_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ogo raqinte thoothino eeno Yesusdar woylamin ko qajade. ");
INSERT INTO amf_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mayriyambee indanaan Martabeyn dohon Bitaania gurdante dehea Alaazar hambhea eedi kalaa hajadhayse ki dahade. ");
INSERT INTO amf_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mayriyamaar Imbaa wontea Yesussa roonam gaamen shittonka qadhayse meten sitinka qodoonone; hajadhaa Alaazaraar kosa indanaasane. ");
INSERT INTO amf_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ogonante Mayriyambee Martabe “Imbo, hanin nashea hajadhidine” hamayse apo Yesusdar ke yittsade. ");
INSERT INTO amf_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesusaar upsin ogoam qansayse, “Burqono ogono Barjo Naasayn yinka gobshadhoadettsi Barjosa gobshinnane; dembhina yeskiseatehe” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesus Martabee, indanaan Mayriyambee, Alaazarbeam kida nashe. ");
INSERT INTO amf_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Kidi yinin dahaa raqate Alaazarsa burqonam qansayse rooro lamaa ki dooqade. ");
INSERT INTO amf_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ogosa budonte yisa paanan yivaynakal “Tapir Yiwda peendar wo yive” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Kisa paanan yivayna eenaar “Woam Dhettsea, rooro likkasa birayse Ayiwd eenam entsayna seenika paxate haam deesana ke zagade; tapir ya ogodar yivaa yivo?” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesusaar kena yinin maasenka, “Rooro kalaasa dahaana savaatina tabhi lamaatayu? Rooronka yaayea eedi dahaa ki hanna, peen kosa shaakanka kinin shedenna goa kiam qanehe. ");
INSERT INTO amf_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Sootinka yaayea ki hanna, shaakayn kisa qolmonna, goa kiam qana ko qane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kena yin yinin giyonsa budonte “Wosa nashoa Alaazar raatidine; ko dahaannaar kiam raatira dhaasana ida yive” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Kisa paanan yivayna eena “Ta keeda Imbo, yi raatidianna, paasha ki paashe” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesusaar Alaazarsa dembhin goynsa ki giyade; kediar raat kinin raatonsa kinin giyea kena ko maatade. ");
INSERT INTO amf_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ogo wodanka Yesus kena may “Alaazar diydine. ");
INSERT INTO amf_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Yedi idar woylamin yenin qajoadettsi konin hayenna raqin ogote inin dahaamonna, yenante ida wozadhe. Ta keeda kikal wo yive” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ogonante Didimos hambhea Toomaase Yesussa paanan yivayna yettsinakal “Kimbesana diyota wodiar wo yive” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesusin nivenka, Alaazar duukadhaysaka rooro oydi konin maatonam ki qansade. ");
INSERT INTO amf_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bitaania Yerusaalemkala kilometir makkamaddha koda pegadhe. ");
INSERT INTO amf_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ayiwd eensaar thoothina eena Martabee Mayriyambesa indanaasasa dembhin goynsa keam wocchinsana kekal nivayse ke dahade. ");
INSERT INTO amf_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martaar Yesusin nivonam yinin qansenka, kiam chocchana ko utade; Mayriyamaar ooninte dooqayse ko dahade. ");
INSERT INTO amf_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martaar Yesusna “Imbo, ha ini kote daana, indanaasa diyehe. ");
INSERT INTO amf_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ta Barjoam hanin misken wulam Barjo hana kinin imenam dhesayda dhese” kina ko hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesusaar “Hambanaasa dembhira kida dhaabhe” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martaar “Dembhira dhaabhadhen macchin rooroaka kinin dhaabhenam dhesayda dhese” kina ko hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesusaar kona “Eenaam dembhira dhaaseabee kena dehen sadan imeabe intane; idar woylamin qajea yi diyaakaar, sadaka daa ki dee. ");
INSERT INTO amf_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Sadaka dahayse idar woylamin qajayna wul rooro wul dembhi diyehe. Ogoam gonne hamayse tiyaa tiyo?” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Kodiar “Ee, Imbo, ya ‘Peen kodar niva ki nive’ hambhaa Kiristoos, Barjo Naasa hanin dohonam gonne hamayse tiyayda tiye” kina ko hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ogoam kikal konin dhalqonsa budonte, yivayse yinnon indanaan Mayriyamam aachika eelayse, “Dhettsea nivayse haam kida eele” kona ko hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kodiar ogoam yinin qansenka, saanawa dhaabhayse Yesuskal ko yivade. ");
INSERT INTO amf_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesusaar Martayn kikal keeron raqinte ki dahade; akar gurdandar ardadehe. ");
INSERT INTO amf_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Koam wocchinsada kombesana kinka ooninte dahaana Ayiwd eenaar Mayriyam kekalanka saanawa utaate konin yivonam haapayse Alaazarsa duukin raqindar eepana konin yivea kena ko maataysaka, kedi kosa paananka ke yivade. ");
INSERT INTO amf_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mayriyam Yesuskal nivayse kiam yinin haapenka kisa roondar dhambayse, “Imbo, ha ini kote daana, indanaasa diyehe” kina ko hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesusaar konin eepenkabee kombesana nivaana Ayiwd eenaar kenin eepenkabe keam shedayse, qaabonka yisa kattsi burqadhayse, ");
INSERT INTO amf_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Hamotee kiam duukaa?” kena ki hamade. Kediar “Imbo, shedota wombesana dhaabhaa” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesusaar ermitka ki eepade. ");
INSERT INTO amf_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ogonante Ayiwd eenaar “Hamin kiam kinin nashenam shedee” ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kesa shaarira waani eena “Ea kaa aapin kayaa easa aapinam pacchaa ta Alaazarin diyoamadettsi kiam hayano bashaw?” hamayse ke giyade. ");
INSERT INTO amf_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesusaar pir yisa iinka kattsi burqadhaate duukindar ki yivade. Alaazarin duukadhoono qoopasa iirne; qoopansa aponam seenika ko shupadhade. ");
INSERT INTO amf_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesus “Seeninam dhaasee” ki hamade. Diyaasaar indanaano Marta “Imbo, ki diyaysaka kina rooro oydi konin dohonna, coqima garehe” kina ko hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesusaar “Idar woylamin ha qajidianna Barjosa gobshinam hanin haapenam hana giyaati?” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ogonante seeninam ke dhaasade. Yesusaar tura cecin shedayse, “Imbo, inin giyenam hanin qansonna haam ida gobshe. ");
INSERT INTO amf_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Rooro wul inin giyenam hanin qansenam dhesayda dhese; ko dahaannaar iam hanin nittsonam isa gasante woyaana eena gonne hamayse kenin tiyoadettsi i giyade” hamayse ki miskade. ");
INSERT INTO amf_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesus yin kinin giyonsa budonte upsi gebhika “Alaazar, ora utaa!” hamayse ki eelade. ");
INSERT INTO amf_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Diyaa Alaazaraar kisa aaninbee roonbe dhaxadhonka duukira ki utade; kisa aapin kerroar apalanka ochadhondar ko dahade. Yesusaar “Kiam bulee; ki yive” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ogonante Mayriyamkal nivaana eenasa shaarira Yesusin waadadhonam haapoono Ayiwd eensa thoothino eeno kidar woylamin ko qajade. ");
INSERT INTO amf_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Waani waani eena Parisa eenakal yivayse Yesusin waadadhonam kena ke giyade. ");
INSERT INTO amf_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ogonante gudullasa hayonabee Parisa eenabe peensa donzanaam yikal pucchayse, “Ta hamino hayo? Ea kaa thoothi tarshea yer kida waadadhe. ");
INSERT INTO amf_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Sun kiam wo garanna, eeno wul kidar woylamin koda qaje; ogona Roome eena nivayse Barjosa gazan ooninbee wosa eenbeam kaysa ke kayse” ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kesa iira kalaa, ogo wodanka gudullasa gebhaa maataa Qayappa kena yi giyna: “Yediar yer kala hattear dhesattene. ");
INSERT INTO amf_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Wosa een wulin kayerra eedi kalaa wo wulna diydi ki hanna payya konin maatenam bhocchattenu?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ogoam kinin giyaynoar kisa bhocchinkatehe; ko dahaannaar ogo wodanka gudullasa gebha yinin dohonna, Yesus Ayiwd eenna kinin diyendettsi hamota dohonam ki giyade. ");
INSERT INTO amf_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ogonoar Yesussa dembhino Ayiwd eenna bishtehe; ko dahaannaar thar thar hamayse dahaana Barjo naana wulam pir raq kalaadar kinin pucchoadettsine. ");
INSERT INTO amf_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ogonante rooroa agaara yedayse kiam deesana kinka ke dhalqade. ");
INSERT INTO amf_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ogona Yesus Ayiwd eensa shaarinte may yaayadehe; ko dahaannaar daransa gasante dohon Epreem hambhen katamandar ki yivade. Ogotear yisa paanan yivaynabesana ki kappade. ");
INSERT INTO amf_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ayiwd eensa Paasikan bavallo ko yeskade. Thoothino eenoar meten yinnonam gazisana hamayse Paasikan rooroasa birayse peen yinnora Yerusaalemdar ko yivade. ");
INSERT INTO amf_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ogote Yesusamaar zagite ko dahade. Barjosa gazan ooninsa mayante woyayse kinka kikal “Har ko yena maate? Ogo bavaalindar nimbha shidho ki dew?” hamayse ko dhalqade. ");
INSERT INTO amf_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Gudullasa hayonabee Parisa eenabe kiam yedana, kinin dohon raqinam dhesea eedi daa ko hanna, kena kinin dhoadettsi ke giyade. ");
INSERT INTO amf_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Paasikan rooronaam gobshanna rooro lax shidhaysaka Yesus dembhira kinin dhaasaa Alaazarin dohon Bitaania gurdandar ki nivade. ");
INSERT INTO amf_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ogotear sooti gala kina ashkayse ke imade. Martaar keam kunsite ko dahade; Alaazaraar Yesusbesana dooqaana eenasa eedi kalaane. ");
INSERT INTO amf_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mayriyam koymo gebhika shanshadhen naardoosira bish ashkadhon bikkole kalaa gaamea shitto tiyayse Yesussa roonam qadhayse yisa metensa sitinka ko qodade; onnoar naardoos shittonsa gaamenka ko thoothade. ");
INSERT INTO amf_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ko dahaannaar kisa paanan yivayna eenasa shaarinte kiam yettsate imana hayea Asqoronto peen ea Yiwda ");
INSERT INTO amf_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Gaamen shitton koam birre mato makkamdar shanshayse koymon ogoam qambhinana imbhimino harrnane?” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ogoam kinin giyoonoar diibi yinin dohonnane; gon qambhinana burqadhaysetehe. Ogonoar kesa birre yedea maatayse kosa iira birrenam yinin tiyennane. ");
INSERT INTO amf_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesusaar “Konin hayoono iam duukadhea rooroasa ashkimbhe konin dohonna, koam garaa. ");
INSERT INTO amf_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Qambhina rooro wul yembesana keda dee; inta rooro wul yembesana dahattine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ayiwd eensa thoothino eeno Yesus ogote kinin dohonam dhesayse ko nivade. Ogonoar diira kinin dhaasaa Alaazaram pir shedanane; Yesusna bish nivadehe. ");
INSERT INTO amf_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Gudullasa hayona Alaazaramaar deesana kinka ke dhalqade. ");
INSERT INTO amf_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Harrna hambhidianna, Alaazarsa diira dhaabhidin goynsa Ayiwd eensa thoothino eeno kekalanka edimayse Yesusdar woylamin qajaate konin dohonnane. ");
INSERT INTO amf_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kina hamon bavaalinam gobshota nivoono thoothino eeno “Yesus Yerusaalem nivite ki dahade” hambhenam yinin qansenka, ");
INSERT INTO amf_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","meetha haccha yinka yedayse kiam tiyana utayse, “Gobshi kina ko dee; Barjo Imbasa naabenka nivea Israveel eensa bitaa kidi gobshadhaane” hante upsi gebhika kiam ko gobshade. ");
INSERT INTO amf_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","Ogora “Yedi Thiyoon katamante dahaana eenato, kurtumbheebhode! Marrato! Yesa bitaa ukuli ootodar dooqayse kida nive” hamayse thaapadhondettsi, Yesus ukuli ooto haapayse daran ki dooqade. ");
INSERT INTO amf_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yesussa paanan yivaynaar ogo wulam birayse bhocchadehe; ko dahaannaar Yesus cecindar utayse kinin gobshadhonsa budonte, ogono wul kinnon goynsa thaapadhonbee waadadhadhonbe ogo wodanka kena bhoq ko hamade. ");
INSERT INTO amf_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yesus Alaazaram duukira eelayse kinin dhaasenka kimbesana kinka dahaana eena ogosa ke tarjade. ");
INSERT INTO amf_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Thoothino eeno ogo tarshen yerin kinin waadadhonam yinin qansonna, kiam tiyana ko utade. ");
INSERT INTO amf_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ogonante Parisa eena yi giyna: “Marrato! Ta keeda hamino hayo? Eeno wul kisa paanan ko yivade” kinka kikal ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Bavaalin rooronaka Barjona goodimota Yerusaalemdar nivon eensa shaarira waani waani eena Girik eedine. ");
INSERT INTO amf_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Kediar Galila peensa Beetesayda katamara nivaa Pilbhooskal nivayse, “Imbo, Yesusam shedana woda zage” hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilbhoosaar yivayse Indiriasna ki giyade; Indiriasbee Pilbhoosbe kinka yivayse Yesusna ke giyade. ");
INSERT INTO amf_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesusaar maasayse “Eedi Naasin gobshadhayno wodano yeskidine. ");
INSERT INTO amf_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Inta yena gon ida giye: Gazgonsa aapi peente wavayse yi capaamma, baqalima koda shidhe; yi capidianna, baqalayse thoothi aapi koda ushe. ");
INSERT INTO amf_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Sadan yinnonam nashea koam kaysa ki kayse; peen kodar sadan yinnonam jibbea rooro wul lay dehen sadanna koam gisha ki gishe. ");
INSERT INTO amf_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ina waadadhea yi hanna, isa paananka ki nive; ina waadadhea ea inin dohon raqinte kida dee; ina waadadhea eam Imba kiam gobsha ki gobshe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesus yi giyna: “Ta isa sadano kattsi gaalidine. Hariy hamo? ‘Imbo, ogo gaalen wodara iam dhacchaa!’ i hamo? Ko dahaannaar inin nivoono ogo gaalenam tiyanane. ");
INSERT INTO amf_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Imbo, hasa naabenam gobshaa!” ki hamade. Ogo wodanka “Intaar isa naabenam gobshidine; tapir koam ida gobshe” hamea upsi cecira ko nivade. ");
INSERT INTO amf_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ogote woyayse qansaana eena “Kaa guganatne” ke hamade; waani eenaar “Barjosa gaana kina ki giyade” ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesus yin giyayse kena ki maasade: “Ogono upsino cecira yena hamayse ko nivade, ina hamayse nivadehe. ");
INSERT INTO amf_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ta peen kodar pirdino yeskidine; ta peen koam wottsea Seethaanam mayandar kida dhabadhe. ");
INSERT INTO amf_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Eedi Naas peen kora tura ki ziitadhidianna, een wulam yidar eela ki eele” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ogono yin kinin giyoono hamin hama dembhi yinin diyensa keam bhocchisana ki giyade. ");
INSERT INTO amf_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ogora thoothino eeno “Wodi Barjoyn qadhaa Kiristoos rooro wul lay kinin dehenam Musesa yigginte wodi qansidine. Ya ‘Eedi Naas tura ziitadha kiam koda zaske’ hamayse haminaa giyaa? Agaa Eedi Naas hayne?” hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesusaar “Akar likka wodana shaaka yembesana kida dee. Thipan yedar yeskoamadettsi shaakan yekal daaka yaayee. Thipante yaayea hamodar yinin yivenam dhesehe. ");
INSERT INTO amf_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Shaaka yekal daaka, shaaka eedi maatana shaakaadar woylam qajee” kena ki hamade. Yesusaar ogoam giyayse kekalanka yivayse ki aadhimbhade. ");
INSERT INTO amf_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","38","Ko dahaannaar Yesus igina tarshayna yerraam kesa birante ki waadadhaakaar Barjokala qansayse eenna giyea Isias “Imbo, wosa tarjamonam gonne hamayse hayne tiyaa? Barjosa kantanosin hayna ko haapadhaa?” hamayse kinin giyoono upsino konin thoothoadettsi kidar woylamin qajadehe. ");
INSERT INTO amf_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Isias pir “Aapinka kenin shedoamadettsi, woylaminkaar kenin bhocchoamadettsi, ogoraar ke maataysaka keam kinin pacchoamadettsi, Barjo kesa aapinam ki kaysade; kesa woylaminamaar ki duttsade” ena ki hamade. Ogonante kedi Yesusdar woylamin qajana damadehe. ");
INSERT INTO amf_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isias ogoam kinin giyoono Yesussa gobshinam shedayse kisa ki giyade. ");
INSERT INTO amf_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ko dahaannaar Ayiwd eenam entsayna eenasa shaarira shidhima thoothina eena kidar woylamin ke qajade. Ko dahaakaar Ayiwd eensa bukin raqira keam kenin buloamadettsi Parisa eenaam kenin kurtumbhonna Yesussa tarjadehe. ");
INSERT INTO amf_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ogoam yin kenin hayoono Barjoyn keam gobsherra, eedin keam gobshenam kenin nashonnane. ");
INSERT INTO amf_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesusaar upsi gebhika yin ki giyade: “Idar woylamin qajea iam nittsaadar woylamin kida qaje; idar bishtehe. ");
INSERT INTO amf_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Iam haapea iam nittsaamaar ta haapidine. ");
INSERT INTO amf_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Idar woylamin qajea wul thipante kinin doamadettsi inta shaaka maatayse peendar i nivade. ");
INSERT INTO amf_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Inta peendar dohon eenam dhacchana i nivade; peendar dohon eendar pirdana nivaatine. Ogonante isa upsinam qansayse toolimadar pirdea intatehe. ");
INSERT INTO amf_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Iam jibbeabee isa dhalqinam tiyma eabedar pirdea daane. Inin giyoono upsino yinti macchin rooroaka kidar koda pirde. ");
INSERT INTO amf_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Harrna hambhidianna, inta isa qaaboka giyaatine; ko dahaannaar iam nittsaa Imba yinti har inin giyenbee hamin inin giyenbeam ina ki imade. ");
INSERT INTO amf_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kinin giyoonoar rooro wul lay daadhea sadandar konin yeskisenam dhesayda dhese. Ogonante inin giyayno Imba ina kinin giyaadettsi ida giye” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Yesus Paasikan rooronaam gobshadhensa birayse, peen kora Barjo Imbaakal kinin yiven wodanin yeskonam ki dhesade. Peen kodar dahaana eena yinnaam kidi nashidine; yinin nashaanaam macchi ki nashade. ");
INSERT INTO amf_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Birayse Seethaan Simoon naasa Asqoronto peen ea Yiwdasa woylaminte Yesusam yettsate kinin imoadettsi qaabo kina ki imade. Yesus Barjo Imbaa yer wulam kisa aanindar kinin imonbee, Barjokala kinin nivonbee, Barjodar kinin yivenbeam ki dhesade. Sootin galan itsite ke daaka, Yesus dhaabhayse yinin qaadhon apalanam wodayse, bishin qodadhen apalanam tiyayse ki dhaximbhade. ");
INSERT INTO amf_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ogoraar shaaqante noqo kahayse, yisa paanan yivaynasa roonam shivayse, yinin dhaximbhon apalanka kesa roonam qodan ki yedade. ");
INSERT INTO amf_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yesus Simoon Bhethirooskal kinin nivenka, Bhethiroosaar “Imbo, ya isa roon shivaa shivo?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesus yinin maasenka, “Inin hayenam ya ta dhesattane; budobar koam hada bhocche” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Bhethiroosaar “Yer hamin hambhaakaar isa roonam shivattane” kina ki hamade. Yesusaar “Hasa roonam i shivaamma, imbesana dahattane” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoon Bhethiroosaar “Imbo, isa aaninbee isa metenbeam shivaa; isa roon bish shivaabhode!” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesusaar “Kosa birayse bishinam shiidhaa ea roonam bish shiidha kiam ko zaske; kisa bishino wul payyane. Yedi payyane; ko dahaannaar yedi wul payyatehe” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yettsate kiam imea eam Yesus yinin dhesenna, “Yedi wul payyatehe” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kesa roonam yinin shivonsa budonte, apalan yinnonam qaadhayse, pir maatate dooqayse kena yin ki giyade: “Inin yena hayonam yedi bhocchee bhoccho? ");
INSERT INTO amf_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yedi Dhettsea way Imbo iam yeda hame; yenin giyaadettsi inin dohonna, payyee giyade. ");
INSERT INTO amf_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ta inta yesa Imbabee Dhettseabe dahayse yesa roonam i shividianna, yedi taar kinka kisa roonam yenin shivoadettsi yeam koda zaske. ");
INSERT INTO amf_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Inta yena inin hayondettsi yedi pir yenin hayoadettsi kamsin koam yena i dhahade. ");
INSERT INTO amf_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Inta yena gon ida giye: Waadadhea ea kiam waadiseara sagehe; ergadhaa ea kiam ergaara sagehe. ");
INSERT INTO amf_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ogoam dhesayse ye haydianna, yedi gobshadhaanane. ");
INSERT INTO amf_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ko dhalqinam inin giyayno ye wulsatehe; inta inin kamaanaam dhesayda dhese. Ko dahaannaar Mathaap Gazante ‘Innon balashanam itsea idar ki dhaabhade’ hambhoono upsino konin thoothoadettsine. ");
INSERT INTO amf_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Yin konin maatonsa birayse ta yena inin giyayno, konin thoothonsa budonte inin hay dohonam gonne hamayse yenin tiyoadettsine. ");
INSERT INTO amf_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Inta yena gon ida giye: Inin yittsea hayyeamaar chocchamon tiyea iam kida tiye; iamaar tiyea iam nittsaam kida tiye” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesus ogoam yin giyayse yisa manpasinka kattsi qaabayse, “Inta yena gon ida giye: Yesa shaarira kalaa iam yettsate ima ki ime” hamayse kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kisa paanan yivayna eenaar dhalqin ogoam haysa kinin giyenam yinin dhesaamonna, kinka kiam kiam shedan ke yedade. ");
INSERT INTO amf_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Kesa iira kalaa Yesusin nashea Yesuskal theedi ki dooqade. ");
INSERT INTO amf_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ogonante Simoon Bhethiroos aapi kina qunthayse, “Haysa kinin giyenam wona oysaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kidiar Yesussa sadankal theedayse, “Imbo, agaa hayne?” hamayse ki oysade. ");
INSERT INTO amf_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesusaar “Balashanam woothinte duggayse aponte inin arsea agaa kidine” hamayse kina ki maasade. Balashanamaar woothinte duggayse Asqoronto peen ea Simoon naasa Yiwdana ki imade. ");
INSERT INTO amf_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ogo balashanam aponte kinin arsonsa budobar, saanawa Seethaan Yiwdasa woylaminte ki ardade. Ogona Yesusaar “Hanin hayenam saanawa hayaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ko dahaannaar ogote galandar dooqaana eena Yesus harrna ogoam kina kinin giyonam hayyear dhesadehe. ");
INSERT INTO amf_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yiwda birre yedea kinin dohonna, Yesus kina “Bavaala gobshana wona zaskenam shanaa” way “Qambhinana iminto imaa” kinin hamaa waani eenana ko maatade. ");
INSERT INTO amf_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yiwdaar balashanam tiyanka saana ki utade. Kinin utenka peeno sootine. ");
INSERT INTO amf_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yiwdayn utonsa budonte Yesus yin ki giyade: “Ta Eedi Naas gobshadhota ki dahade; Barjoar kanka kida gobshadhe. ");
INSERT INTO amf_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Barjoar kanka ki gobshadhidianna, Barjo pir Naasaam yinka gobsha ki gobshe; saanawa kiam kida gobshe. ");
INSERT INTO amf_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Naanato, akar likka wodana yembesana kinka ida dee. Iam zageeda zage; Ayiwd eenam entsaynana ‘Inin yiven raqinte nivana damattene’ inin kena hamondettsi, ta yena pir ogoam ida giye. ");
INSERT INTO amf_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Kinka kiam kiam yenin nashoadettsi haali upsi yena ida ime. Inin yeam nashondettsi, yedi pir kinka kiam kiam nashee. ");
INSERT INTO amf_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kinka kinka nashimmakko yesa daa ko hanna, isa paanan nivayna eena yenin maatonam eeno wul yeam ogoka dhesa ko dhese” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoon Bhethiroosaar “Imbo, hamoa yive?” hamayse kiam ki oysade. Yesusaar “Ta isa paananka inin yiven raqindar nivana damattane; bere isa paanan nivaada nive” hamayse kina ki maasade. ");
INSERT INTO amf_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Bhethiroosaar “Imbo, ta hasa paanan yiva iam marayno hare? Isa sadanam ko hannaar hana saskate imayda ime” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesusaar kina yinin maasenka, “Ya gon hasa sadanam ina saskate imaa imo? Inta hana gon ida giye: Makkam goyt ‘Inta kiam dhesattine’ hamayse iam hanin marimenka yekka kina sootin baacha qiiqehe. ");
INSERT INTO amf_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Yesa woylaminka qaabayse gaaleebhode; Barjodar woylam qajee, idarar pir woylam qajee. ");
INSERT INTO amf_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Imbasa ooninte thoothi daadhea raq daane; yin ko dahaamma, ini yena giyayda giye. Raq yena ashkota ida yive. ");
INSERT INTO amf_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Yivayse raq yena inin ashkonsa budonte, inin dohon raqinte yedi pir yenin doadettsi lansi nivayda nive; ikalar yeam tiyayda tiye. ");
INSERT INTO amf_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Inin yiven goynamaar dheseeda dhese” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toomaasear “Imbo, hamodar hanin yivenam dhesattone; hamin hayayse goynam woda dhese?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesusaar kina yinin maasenka, “Goyteabee, gonin hamaabee, sadabe intane; inka dayma goyti abka eedi hay ki hannaar Barjo Imbakal nivana damea qolehe. ");
INSERT INTO amf_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Iam ye dhesanna, Imbaamaar pir dheseeda dhese. Ta keeda kaara kiam yedi dhesidine; kiam yedi haapidine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilbhoosaar “Imbo, Barjo Imbaam wona ha dhaanna, yeeka ko yeeke” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesusaar “Ya Pilbhooso, koka yekka yembesana kinka inin dehenka iam dhesattanu? Iam haapaa Imbaam haapidine. Ta ya ‘Barjo Imbaam wona dhahaa’ hamayse haminaa giyaa? ");
INSERT INTO amf_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Inta Imbaka inin dohonbee Imbaar inka kinin dohonbeam gonne hamayse tiyattanu? Inka dahaa Imba waadimanam kida waadadhe; inin yena giyen upsinam ikalanka giyattine. ");
INSERT INTO amf_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Inta Imbaka inin dohonbee Imbaar inka kinin dohonbeam gonne hamayse isa upsinam tiyee. Yin ko dahaamma, inin waadadhen waadimanam shedayse gonne hamayse tiyee. ");
INSERT INTO amf_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Inta yena gon ida giye: Idar woylamin qajea inin waadadhen waadimanam kidi pir kida waadadhe; ogora sagi kida waadadhe. Harrna hambhidianna, inta Imbadar inin yivennane. ");
INSERT INTO amf_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Imbaar i kisa Naasaka kinin gobshadhoadettsi isa naabenka yenin misken wulam yena hayayda haye. ");
INSERT INTO amf_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yer har ko hannaar isa naabenka iam yenin miskenam inta yena hayayda haye. ");
INSERT INTO amf_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Iam nashayna ye hanna, inin giyen upsinam toolee. ");
INSERT INTO amf_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Intaar Imbaam ida miske; rooro wul lay yembesana kinin doadettsi ab yeam wocchinsea yena kida ime. ");
INSERT INTO amf_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Kidiar goninsa Manpasne. Peendar dahayna eena kiam haapiminabee dhesiminabe kenin dohonna, kiam tiyana damehe; ko dahaannaar yembesana kinka kinin dohonnabee os birante yesa iinte kinin dehennabe yedi kiam dheseeda dhese. ");
INSERT INTO amf_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Imbaysa qolmina naanadettsi yeam inta garattine; yekal nivayda nive. ");
INSERT INTO amf_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Likka wodasa budonte peendar dahaana eena iam haapehe; yedi iam haapeeda haape. Inta sadaka inin dehenna, yediar sadaka yeda dee. ");
INSERT INTO amf_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Inta Imbaka inin dohonam, yediar inka yenin dohonam, intaar yenka inin dohonam agaa rooroaka dheseeda dhese. ");
INSERT INTO amf_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Isa upsinam tiyayse koam toolea iam nashea kidine. Iam nasheamaar Imba nasha ki nashe; intaar kiam nashayda nashe; iamaar kina dhaayda dhee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Asqoronto peen ea Yiwda dayma aba Yiwda “Imbo, peendar dahayna eenana dayma wona bish haam hanin dhahayno harrnane?” hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesusaar kina yinin maasenka, “Iam nashea hay ki hannaar, isa upsinam toola ki toole; Imbaar kiam nasha ki nashe. Wodiar kikal nivooda nive; kimbesana kinka woda dee. ");
INSERT INTO amf_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Iam nashima isa upsinam toolehe. Yenin qansayno upsinoar iam nittsaa Imbasane, intitehe. ");
INSERT INTO amf_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ta yembesana dahayse koam yena i giyade. ");
INSERT INTO amf_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ko dahaannaar Imba isa naabenka yena kinin nittsayno, wocchinsayno Manpas Gazano, wulam yena koda dhettse; inin yena giyon wulam yena koda bhocchise. ");
INSERT INTO amf_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Payyamonam yena ida gare; isa payyamonam yena ida ime. Inin yena imayno payyamono peen konin imendettsitehe. Yesa woylaminka qaabayse gaaleebhode, kurtumbheebhode. ");
INSERT INTO amf_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘Inta yivayda yive; yekalar maatayse nivayda nive’ inin yena hamonam yedi qansidine. Iam nashayna ye hanna, Imbakal inin yivenka ini yeda wozadhe; harrna hambhidianna, Imba idara kinin sagennane. ");
INSERT INTO amf_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ogoyn thoothonsa budonte inin giyonam gonne hamayse yenin tiyoadettsi ta konin maatensa birayse koam inta yena giydine. ");
INSERT INTO amf_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ta keeda yembesana kinka thoothi dhalqattine; harrna hambhidianna, peen koam wottsea Seethaan kida nive. Idar kisa kanta qolehe. ");
INSERT INTO amf_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ko dahaannaar Imbaam inin nashenam peen kodar dohoono eeno konin dhesoadettsi, Imba ina kinin giyon ogoam ida haye. “Dhaabhee, kora wo yive. ");
INSERT INTO amf_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Gonin hamaa woynea hatta intane; koraar Imbane. ");
INSERT INTO amf_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Aapin ushimin idar dohon antin wulam Imba taxayse kida dhabe; aapin ushen antin wulam thoothi konin ushoadettsi koam murdayse kida ashke. ");
INSERT INTO amf_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Inin yena giyon upsin goynka ta yedi payya maatidine. ");
INSERT INTO amf_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yedi inka dehee; intaar yenka ida dee. Antino hattadar yi dahaamma yimal aapi ushana konin damimadettsi, yin yedi taar inka ye dahaamma aapi ushana damattene. ");
INSERT INTO amf_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Woynea hatta intane; yediar antinane. Hayyear inka ki daana, intaar kanka i daana, kidi thoothi aapi usha ki ushe. Harrna hambhidianna, inka ye dahaamma, yer kala hattear hayana damattene. ");
INSERT INTO amf_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Inka dayma ea hattonsa antindettsi taxate kiam mayante dhabadhaysaka kida wocche; iginaamaar buurate nuunte dhabayse koda koqadhe. ");
INSERT INTO amf_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Inka daa ye hanna, isa upsinoar yekal daa ko hanna, yenin nashen wulam miskee; yena imbha ko imbhe. ");
INSERT INTO amf_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Thoothi aapi ye ushidianna, isa paanan nivayna eena yenin maatonam yeda dhee; Imbaar ogoka gobsha ki gobshadhe. ");
INSERT INTO amf_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Imba iam kinin nashondettsi, intaar yeam nashidine; isa nashimmakkonka dehee. ");
INSERT INTO amf_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Inta Imbasa upsinam toolayse kisa nashimmakkonka inin dohondettsi, isa upsinam ye toolina isa nashimmakkonka yeda dee. ");
INSERT INTO amf_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Isa wozano yenka konin doadettsi, yesa wozanoar konin thoothoadettsi koam yena inta giydine. ");
INSERT INTO amf_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Inin yeam nashondettsi kinka kiam kiam yenin nashoadettsi isa upsino konone. ");
INSERT INTO amf_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Sadan yinnonam yisa nashonana saskayse imara sagi nashimmakko haykalar qolehe. ");
INSERT INTO amf_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Inin yena giyonam hayayna ye hanna, yedi isa nashonane. ");
INSERT INTO amf_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ta keeda kaara os ‘Ina waadadhaynane’ yeam hamattine; harrna hambhidianna, waadadhea ea yiam waadiseayn hayenam dhesehe. Ko dahaannaar Imbakala inin qanson wulam yena inin dhettsonna, ‘Isa nashonane’ yeam inta hamidine. ");
INSERT INTO amf_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Inta yeam i kamade; yedi iam kameetene. Yivayse aapi yenin ushoadettsibee yesa aapinoar konin doadettsibe yeam kamayse i wodade. Ogona Imba isa naabenka yenin misken wulam yena kida ime. ");
INSERT INTO amf_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kinka kiam kiam yenin nashoadettsi yena inin giyayno upsino konone. ");
INSERT INTO amf_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Peen kodar dohoono eeno yeam jibbidi ko hanna, yesa birayse iam konin jibbonam dhesee. ");
INSERT INTO amf_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Peen ko eena ye daana, ini peen kodar dohoono eeno kenti yenin dohonna yeam nasha ko nashe. Ko dahaannaar inta peen kodar dohon eensa iira yeam i kamade; ogona peen kosa yenin dahaamonna, peen kodar dohoono eeno yeam jibba ko jibbe. ");
INSERT INTO amf_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‘Waadadhea ea kiam waadiseadara sagehe’ hamayse inin yena giyon upsinam bhocchee. Iam oytidi ke hanna, yeamaar pir oyta ke oyte. Isa upsinam toolidi ke hanna, yesa upsinam toola ke toole. ");
INSERT INTO amf_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Iam nittsaam kenin dhesimonna, ko wulam isa naaben goynka yedar keda haye. ");
INSERT INTO amf_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Inta nivayse kena i giyaamma, ini kena seeso maatehe; keeda seeso kenin waadadhonsa kenin imea upsi qolehe. ");
INSERT INTO amf_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Iam jibbea Imbaam pir jibba ki jibbe. ");
INSERT INTO amf_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Eedi abin waadadhaamon waadimanam kesa shaarinte i waadadhaamma, ini kena seeso maatehe. Keeda inin waadadhonam shedayse imbee Imbabeam kedi jibbidine. ");
INSERT INTO amf_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ogonoar kesa yigginte ‘Sun iam ke jibbade’ hamayse thaapadhoono konin thoothoadettsine. ");
INSERT INTO amf_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Inta Imbakala inin nittsayno, kikalaar utayno, yeam wocchinsen gonin Manpasin nivon wodanka, kodi innon goynsa tarja ko tarje. ");
INSERT INTO amf_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Yedi taar birara yedayse imbesana yenin dohonna, innon goynsa tarjeeda tarje. ");
INSERT INTO amf_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Yena goa konin maatoamadettsi ogoam yena inta giydine. ");
INSERT INTO amf_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ayiwd eensa bukin raqiraar yeam bula ke bule; ogoraar saskayse pir yeam deesayna wul ‘Inta Barjosa waadima eedine’ kenin hamayno woda koda nive. ");
INSERT INTO amf_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ogoamaar yedar kenin hayayno Imbabee imbeam kenin dhesimonnane. ");
INSERT INTO amf_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ko dahaannaar wodayn yeskenka, inin yena giyonam yenin bhocchoadettsi koam yena inta giydine. “Yembesana kinka inin dohonna, ko wulam yena birayse giyma i garade. ");
INSERT INTO amf_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Keeda iam nittsaadar yivayda yive. Yesa shaarira ‘Hamoa yive?’ hamayse iam oysea qolehe. ");
INSERT INTO amf_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ta koam inin yena giyonna, yesa woylaminte sii qaabe thoothidine. ");
INSERT INTO amf_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Inta yena gon ida giye: I yividianna, yena aga ko age. Harrna hambhidianna, i yivaamma wocchinsea yekal nivehe; i yividianna, kiam yekal nittsayda nittse. ");
INSERT INTO amf_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kidiar nivayse seesonbee, tipamonbee, pirdin goynbesa peendar dahaana eenaam bhocchisa ki bhocchise: ");
INSERT INTO amf_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Seeson goynsa keam kinin bhocchisayno idar woylamin kenin qajimonnane; ");
INSERT INTO amf_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","tipamon goynsa keam kinin bhocchisayno Imbakal inin yivennabee keeda iam yenin haapiminnabene; ");
INSERT INTO amf_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","pirdin goynsaar keam kinin bhocchisayno peen koam wottsea Seethaandar konin pirdadhonnane. ");
INSERT INTO amf_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Inin yena giyayno akar thoothi yer daane; ko dahaannaar ta yena i giydianna, yedar koda dethe. ");
INSERT INTO amf_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Bere goninsa Manpasino konin nivon wodanka, gonin wulam yenin dhesoadettsi yeam entsa ko entse. Harrna hambhidianna, yinin qanson wulam koda giye; yikalanka konin giymonnane. Kodi os birante nivenam yena giya ko giye. ");
INSERT INTO amf_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Inti maatonam tiyayse yena konin giyenna, iam gobsha ko gobshe. ");
INSERT INTO amf_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Imbasa dohoono wul intine; ogonante ‘Innora tiyayse yena giya ko giye’ inin hamoono ogonane. ");
INSERT INTO amf_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Likka roorosa budobar iam haapattene; pir likka roorosa budobar iam haapeeda haape” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Kisa paanan yivayna eenasa waani waani eena “‘Likka roorosa budobar iam haapattene; pir likka roorosa budobar iam haapeeda haape’ pir, ‘Imbakal inin yivennane’ kisa hamintano hamin giyntane?” kinka kikal ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Ta keeda ‘likka roorosa’ kinin hamoono kisa hamin giyntane? Kinin giyenam dhesattone” hamayse kinka dhalqite ke dahade. ");
INSERT INTO amf_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesusaar kiam oysana kenin zagonam dhesayse kena yin ki giyade: “‘Likka roorosa budobar iam haapattene; pir likka roorosa budobar iam haapeeda haape’ inin hamonna ye kinka kiam kiam oyso? ");
INSERT INTO amf_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Inta yena gon ida giye: Yedi eepeeda eepe, qayteeda qayte; peen kodar dohoono eeno ko hanna, wozadha ko wozadhe. Yediar sii eed yeda maate; ko dahaannaar yesa siino wozadar ookima ko ookime. ");
INSERT INTO amf_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Maa adhiman rooroa kosa yeskenka koda burqadhe. Ko dahaannaar naasin yinin adhonsa budonte, ‘Peen kodar naasi inta adhidine’ hamayse wozaka yisa gaalenam koda wale. ");
INSERT INTO amf_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ogodettsi yedi ta yesa woylaminka burqadheeda burqadhe. Ko dahaannaar pir yeam ida shede; yesa woylaminkaar wozadheeda wozadhe; yesa wozanamaar yekalanka tiyea hayyear qolehe. ");
INSERT INTO amf_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Ogo wodanka ikalanka yer kala hattear miskattene. Inta yena gon ida giye: Imba isa naabenka yenin misken wulam yena ima ki ime. ");
INSERT INTO amf_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ta koka yekka isa naabenka yer kala hattear miskeetene. Yesa wozano konin thoothoadettsi miskee; tiyeeda tiye. ");
INSERT INTO amf_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Koam yena kamsika i giyade. Ko dahaannaar keeda kaara os kamsika inin giymino woda koda nive; ogo wodanka Imba goynsa yena may ida giye. ");
INSERT INTO amf_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ogo wodanka isa naabenka miskeeda miske; intaar ‘Yena Imbaam ida miske’ yena hamattine. ");
INSERT INTO amf_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Harrna hambhidianna, yedi iam yenin nashonna, Barjokalankaar inin nivonam gonne hamayse yenin tiyonna, Imba kidi yeam nasha ki nashe. ");
INSERT INTO amf_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Imbakalanka utayse peen kodar i nivade; pir peen koam garayse Imbadar yivayda yive” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kisa paanan yivayna eenaar “Shedaa! Ta kamsika giyattane; may hada giye. ");
INSERT INTO amf_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Wulam hanin dhesenbee hayyear haam oysa zaskiminbeam ta wodi dhesidine; ogona Barjokalanka hanin nivonam gonne hamayse wodi tiydine” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesusaar yin giyayse kena ki maasade: “Ta yedi inin giyonam gonne hamayse yedi tiydu? ");
INSERT INTO amf_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Yedi wul kalaa kalaa yesa onnadar thar thar hamayse yenin yivayno, iamaar imal yenin garayno woda niva ko nive, ogonoar ta yeskidine; ko dahaannaar Imba imbesana kinin dohonna, inta ta imaltehe. ");
INSERT INTO amf_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Inka yena payyamoyn doadettsi inta yena ogoam giydine. Peen kodar yenin dehenka, gaale yedar yeska ko yeske. Ko dahaannaar kurtumbheebhode! Inta peen koam bashidine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesus ogoam yinin giyonsa budobar tura cecin shedayse yin giyayse ki miskade: “Imbo, wodano yeskidine; hasa Naasa haam kinin gobshoadettsi kiam gobshaa. ");
INSERT INTO amf_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Hanin kina imaana wulna rooro wul lay daadhea sadan kinin imoadettsi een wuldar hayamo kina ha imade. ");
INSERT INTO amf_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Gonin hama Barjo bish maataa hambee hanin nittsaa Yesus Kiristoosbeam kenin dhesoadettsi rooro wul lay daadhea sada agaane. ");
INSERT INTO amf_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Inin waadadhoadettsi ina hanin imon waadimanam macchayse, peen kodar haam inta gobshidine. ");
INSERT INTO amf_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Keeda Imbo, peen pijadhima birayse hakal isa dohon gobshinka ya pir iam hakal gobshaa. ");
INSERT INTO amf_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Peen kodar dohon eensa shaarira ina hanin imaana eenana hasa naabenam kena inta dhettsidine. Kedi hanti ke dahade, inaar keam ha imade; hanin giyen upsinamaar kedi toolidine. ");
INSERT INTO amf_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ina hanin imoono wul hakalanka konin dohonam ta kedi dhesidine. ");
INSERT INTO amf_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Harrna hambhidianna, ina hanin imon upsinam intaar kena imidine; kediar ogoam ke tiyade. Hakalankaar inin nivonam gon kedi dhesidine; hanin iam yittsonam kedi gonne hamayse tiydine. ");
INSERT INTO amf_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ina hanin imaana eenana haam ida miske; igina kedi hanti kenin dohonna, kena haam ida miske; peen kodar dohon een waanina haam miskattine. ");
INSERT INTO amf_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Inti maataana wul hantine; hanti maataana wul intine; intaar kenka gobshadhidine. ");
INSERT INTO amf_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Keeda kaara os peen kodar inta dahattine, kedi peendar keda dee; inta hadar ida yive. Gazaa Imbo, igina eena wodettsi kalaa kenin maatoadettsi ina hanin imon hasa naabenka keam toolaa. ");
INSERT INTO amf_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kembesana kinka peendar inin dohonka hanin ina imon hasa naabenka inta keam toolite i dahade; inta keam toolidine. Mathaap Gazante thaapadhoono konin thoothoadettsi agaa kayendar yivea ea bishkalanka kesa iira kala hattear kayadehe. ");
INSERT INTO amf_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Taar hadar ida yive; isa dohoono wozano kenka konin thoothoadettsi peen kodar inin dohonka yerra iginaam ida giye. ");
INSERT INTO amf_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Hasa upsinam kena inta imidine. Intaar peendar dahayna eenabesana kala inin dahaamadettsi kediar peendar dahayna eenabesana kala kenin dahaamonna, peendar dahayna eena keam jibbidine. ");
INSERT INTO amf_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Siyonkalanka keam hanin tooloadettsi ida miske; peen kora keam hanin buloadettsi miskattine. ");
INSERT INTO amf_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Intaar peendar dohon eenbesana kala inin dahaamadettsi, kediar peendar dohon eenbesana kalaatehe. ");
INSERT INTO amf_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Goninka keam gazisaa; upsinoar hasa gonne. ");
INSERT INTO amf_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Peendar dohon eendar iam hanin yittsondettsi, intaar keam yin peendar dohon eendar i yittsade. ");
INSERT INTO amf_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kedi gon gazimbhaana kenin doadettsi inta kena hamayse iam gazinsidine. ");
INSERT INTO amf_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Kena bish dayma kenin giyen upsinam qansayse idar woylamin qajaynanaar haam ida miske. ");
INSERT INTO amf_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Imbo, ya inka hanin dohondettsi, intaar hanka inin dohondettsi, igina taar wonka kenin doadettsi ida miske. Inin miskaynoar hanin iam yittsonam peendar dahayna eena gonne hamayse kenin tiyoadettsi, idar woylamin qajayna wul kinka kala ke maate hamayse haam ida miske. ");
INSERT INTO amf_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Wodi kinka kala wonin dohondettsi kediar kinka kala kenin maatoadettsi, ina hanin imon gobshinam inta kena imidine. ");
INSERT INTO amf_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Intaar kenka inin dohondettsi, yaar inka hanin dohondettsi, kediar gon kinka kala kenin maatoadettsi haam ida miske. Peen kodar dohoono eeno iam hanin yittsonbee, iam hanin nashondettsi keam hanin nashonbeam ogoka dhesa ko dhese. ");
INSERT INTO amf_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Imbo, peen pijadhima birayse iam hanin nashonna, ina hanin imon gobshinam kenin shedoadettsi, ina hanin imaana kedi taar inin dohonte imbesana kinka kenin doadettsi ida nashe. ");
INSERT INTO amf_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tipaa Imbo, peendar dohoono eeno haam dhesadehe. Inta haam dhesidine; iginaar hanin iam nittsonam kedi dhesidine. ");
INSERT INTO amf_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Iam hanin nashoono nashimmakkono kesa iinte konin doadettsibee inta kesa iinte inin doadettsibe intaar hasa naabenam kena dhettsidine; pir kena dhettsayda dhettse” hamayse ki miskade. ");
INSERT INTO amf_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesus ogoam yinin giyonsa budonte, ogora utayse Qediroon baynsa saabar yisa paanan yivaynabesana kinka haaqan kordhon haaminte yivayse ke ardade. ");
INSERT INTO amf_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yesusaar kisa paanan yivayna eenabete thoothi woda ogote kenin bukenna, yettsate kiam imea Yiwda pir raqinam dhesa ki dhese. ");
INSERT INTO amf_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ogonante Yiwda Roome poolisanabee Ayiwd poolisanabeam yinka entsate raqin ogote ki nivade. Kedi Ayiwd poolisana gudullasa hayonabee Parisa eenabekalanka nittsadhaanane. Kediar paanoosbee, kuushabee, banqin koymobeam yinka bavate ke nivade. ");
INSERT INTO amf_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesus yidar yesken wulam dhesayse kekal nivayse, “Yedi hayyeame zage?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Kediar “Naazret peen ea Yesusam woda zage” hamayse kina ke maasade. Yesus kena “Intane” ki hamade. Yettsate kiam imea agaa Yiwda pir kembesana kinka woyayse ki dahade. ");
INSERT INTO amf_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesusaar “Intane” kena ki hamaysaka, kedi budoka yivayse peendar ke dhambade. ");
INSERT INTO amf_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Pir “Hayyeame zage?” hamayse keam ki oysade. Kediar kina yinin maasenka, “Naazret peen ea Yesusam woda zage” ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesusaar kena “‘Intane’ yena iam hamaati? Ta yenin zagea inta i hanna, kina eena ke yive; keam garee” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ogonoar Yesus “Igina ina hanin imaanara eedi kala hattear kaysaatine” hamayse kinin giyoono upsino konin thoothoadettsine. ");
INSERT INTO amf_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Halpan dhaximbhaa Simoon Bhethiroosaar yisa halpanam gochayse gudullasa gebhaana waadadhea easa qaamia mizaqaam taxate ki dhabade; waadima easa nammo Malkoosne. ");
INSERT INTO amf_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesusaar Bhethiroosna “Hasa halpanam halpan ooninte arsaa. Imba ina kinin imon gaalen wucimanam inta wucattinu?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ogora Roome poolisanabee, keam wottseabee, Ayiwd eensa hayonayn nittsaana poolisanabe Yesusam yedayse ke dhaxade. ");
INSERT INTO amf_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Biraysear Qayappasa baysa Hannadar kiam entsate ke yivade; Qayappa wodan ogoka Ayiwd eensa gudullasa gebha kidine. ");
INSERT INTO amf_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Qayappa “Eedi kalaa een wulna diydi ki hanna payyane” hamayse Ayiwd eensa entsanaam kiilaa kidine. ");
INSERT INTO amf_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoon Bhethiroosbee waa Yesussa paanan yivea eabe Yesussa paananka ke yivade. Ogonoar Yesussa paanan yivea ea gudullasa gebhaakal dhesadhaane; kidi gudullasa gebhaasa kerminte Yesusbesana ki ardade. ");
INSERT INTO amf_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Bhethiroosaar mayante kerinkal ki woyade. Ogona gudullasa gebhaakal dhesadhea waa Yesussa paanan yivea ea kerin toolen edonkal nivayse kombesana dhalqayse Bhethiroosam ki arsade. ");
INSERT INTO amf_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ogono kerin toolayno waadiman edono Bhethiroosna “Ya pir ea agaasa paanan yivayna eenasa kalaatayu?” kina ko hamade. Kidi “Intatehe” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Peenin kattsi qajenna, waadimayna eenabee poolisanabe nuu guttsayse nuunsa gasante woyayse kicardhite ke dahade; Bhethiroos pir kembesana kinka woyayse kicardhite ki dahade. ");
INSERT INTO amf_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ogo wodanka gudullasa gebhaa Yesusam kisa paanan yivaynabee kisa timmirinbesa kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesusaar kina yinin maasenka, “Inta peen kodar dohon een wulna may i giyade; Ayiwd eeno wul konin buken kosa bukin raqinbee Barjosa gazan ooninsa mayanbesa iir rooro wul ida dhettse; aachika kala hattear giyaatine. ");
INSERT INTO amf_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ta harrnaa iam oyse? Inin giyenka qansaanaam oysaa. Kedi inin giyonam dhesa ke dhese” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ogoam kinin giyenka, ogote dahaana poolisanasa kalaa “Ta ya gudullasa gebhaana yin giyaysea maaso?” hamayse Yesusam ki cavade. ");
INSERT INTO amf_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesus maasayse “Siya i giydianna, siyon inin giyonam tarjaa; gon i giydianna, harrnaa iam ceve?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ogosa budobar Hanna Yesusam dhaxinka ki daaka gudullasa gebhaa Qayappadar kiam ki yittsade. ");
INSERT INTO amf_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simoon Bhethiroos woyayse nuu kicardhite ki daaka, “Ya taar Yesussa paanan yivayna eenasa kalaatayu?” kina ke hamade. Kidiar “Intatehe” hamayse ki marimade. ");
INSERT INTO amf_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Gudullasa gebhaana waadimayna eenasa kalaa, Bhethiroosin qaamin taxaasa muldha maataa ea “Haaqan kordhon haaminte kimbesana kinka ha daaka haam haapaati?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Bhethiroosaar pir “Kiam dhesattine” hamayse ki marimade. Ogo yin kinin marimenka, saanawa baacha ki qiiqade. ");
INSERT INTO amf_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ayiwd eenam entsayna eena Yesusam Qayappakalanka peen wottseasa kermin iinte kiam arsota entsate ke yivade. Ogono wodano burin sedhimanne; kediar Paasikan galanam itsa keam zaskenna, yinin minngimoamadettsi peen wottseasa kermin iinte ardadehe. ");
INSERT INTO amf_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ogonante peen wottsea Bhilathoos mayan kekal utayse, “Ea kaam yenin bersensa kisa seesono hare?” hamayse keam ki oysade. ");
INSERT INTO amf_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Kediar kina yinin maasenka, “Kaa ea siya waadadhea ki dahaamma, yedayse hadar ini kiam bavattone” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Bhilathoosaar “Yedi kiam entsate yivayse yennon yiggindettsi kidar pirdee” kena ki hamade. Ayiwd eenam entsayna eenaar “Wodi haydarar dembhi pirdi pirdayse wonin deesoadettsi Roome yigginte wona giidhadehe” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ogoam kenin giyoono Yesus hamin dahaa dembhi kinin diyensa kinin giyoono upsino konin thoothoadettsine. ");
INSERT INTO amf_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Bhilathoosaar pir maatayse kermin iinte ardayse Yesusam eelayse, “Ayiwd eensa bitaa yaw?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesusaar kina maasayse “Ya koam hanin giyayno hasa qaaboramoo? Waani eenow isa hana giyoono?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Bhilathoosaar kina maasayse “Inta Ayiwd eediw? Haam yettsate ina imaana hasa peen eenabee gudullasa hayonabene. Ya haraa hayaa?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesusaar maasayse “Isa bitamono peen koratehe. Isa bitamono peen kora ko hanna, Ayiwd eenam entsayna iam kenin yedoamadettsi ina waadimayna eena ini kembesana banqi keda kanse; yin ko dahaakaar isa bitamono peen koratehe” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Bhilathoosaar “Keeda ya bitiw?” kina ki hamade. Yesusaar maasayse “Inin bit dohonam hasa giydino gonne; inta goninna tarjana i adhadhade, ogona pir peen kodar i nivade. Gon maataa wul isa upsinam kida qanse” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Bhilathoosaar “Gonno hare?” kina ki hamade. Koamaar yin giyayse pir Ayiwd eendar utayse, “Inta kisa kala hattear seeso haapaatine. ");
INSERT INTO amf_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ko dahaannaar Paasikan rooroaka dhaxadhon eensa shaarira eedi kalaam inin yena bulea dambi yesa daane. Ta keeda Ayiwd eensa bitaam yena dhaxira inin buloadettsi yedi nashee nasho?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kediar “Kiamtehe! Wona Barbaanam bulima” hamada pir ke ilatade. Barbaanaar eedi koymo buurite itseane. ");
INSERT INTO amf_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ogo wodanka Bhilathoos Yesusam poolisanaka ki qansisade. ");
INSERT INTO amf_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Poolisanaar ukumbha qorayse kisa metendar ke wodade; pir apala zoo kiam ke qattsade. ");
INSERT INTO amf_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Kikal theedayse, “Ayiwd eensa bitaa, payyamo hana ko dee” hamada kiam ke bagade; pir kiam cavite ke dahade. ");
INSERT INTO amf_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Bhilathoosaar pir mayanka utayse, “Marrato! Ea kaasa seeso kala hattear inin haapaamonam yenin dhesoadettsi mayanka kiam yena ida bule” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesusaar ukumbhanka qurayse ashkadhonam yisa metendar wodayse apala zoo qaadhayse mayanka ki utade. Bhilathoosaar “Marrato, yesa ea kash!” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Gudullasa hayonabee kesa poolisanabe kiam yinin haapenka, “Kiam ziitima! Ziitima!” hante ke ilatade. Bhilathoosaar “Inta kisa seeso kala hattear inin haapaamonna, yedi kiam entsate yivayse ziitee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Igina Ayiwd eenam entsaynaar kina yinin maasenka, “Wosa yiggi daane; yiam Barjo Naas kinin hayonna, wosa yigginka diya kiam ko zaske” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ogonante Bhilathoos upsin ogoam yinin qansenka ini hamora sagi ki kurtumbhade. ");
INSERT INTO amf_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pir maatayse kerminsa iinte ardayse Yesuskal “Ya hamora nivaa?” kina ki hamade. Yesusaar yer kala hattear kina maasadehe. ");
INSERT INTO amf_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ogonante Bhilathoosaar “Ina giyattanu? Haam dhaxira bulanabee ziitanabe isa hayamo dohonam ya dhesattanu?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesusaar kina yinin maasenka, “Barjokala hana imbhaamma idar hasa hayamo qolehe; ogonante iam yettsate hana imaa easa seesono hannora sagine” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ogosa budonte Bhilathoos Yesusdar pirdima yittsana ki zagade. Ko dahaannaar Ayiwd eeno kina yi giyna: “Ya ea kaam pirdima ha garina, ya Roome peen bitaasa nashotehe; meten yinnonam bit hayayna wul Roome bitaam jibbaynane, nashaynatehe” hante ko ilatade. ");
INSERT INTO amf_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Bhilathoosaar dhalqin ogoam qansayse Yesusam mayanka ki bulade. “Seeni Labha” hambhen raqinte pirdin borkotondar ki dooqade; ogono ranqo Ibra aponka “Gebeta” koda hambhe. ");
INSERT INTO amf_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Paasikan rooroana ashkimbhadhayno rooro ko dahade; wodanoar savaat laxaddhane. Bhilathoosaar Ayiwd eenna “Marrato, yesa bitaa kash!” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Kediar “Ea kaam kaysima! Kaysima! Kiam ziitaa!” hante ilataate ke waajade. Bhilathoosaar “Yesa bitaam i ziito?” kena ki hamade. Gudullasa hayonaar “Roome peen bitaara ab bit wosa qolehe” hamayse kina ke maasade. ");
INSERT INTO amf_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ogo wodanka masqalindar konngayse kiam kenin ziitoadettsi kena saskate ki imade. Ogosa budonte Yesusam yedayse ke yivade. ");
INSERT INTO amf_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Kidiar yinin ziitadhen masqalinam kedayse “Eedisa Metedettsi Maataa Raq” way Ibra aponka Golgotta hambhea raqadar ki utade. ");
INSERT INTO amf_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ogo raqintear eedi lamaa Yesussa warkatambarbee mizaqimbarbe hayayse, Yesusamaar kesa shaarinte masqalindar konngayse ke ziitade. ");
INSERT INTO amf_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Bhilathoosaar pir thaapi thaapayse masqalindar ki ziitisade. Thaapadhoono thaapino “Ayiwd eensa bitaa Naazret ea Yesus” hamaynone. ");
INSERT INTO amf_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yesusamaar ziitadhoono ranqo katamankal theedi konin dohonna, Ayiwd eensa thoothina eena thaapadhon ogoam ke nabbabade; thaapadhoonoar Ibrabee, Roomebee, Girikbe aponkane. ");
INSERT INTO amf_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ogonante Ayiwd gudullasa hayona Bhilathoosna, “‘Kidi “Inta Ayiwd eensa bitaane” ki hamade’ hamayse thaapaa; ‘Ayiwd eensa bitaa’ hamayse thaapaabhode” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Bhilathoosaar “Inin thaapenam inta thaapidine” hamayse ki maasade. ");
INSERT INTO amf_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Poolisanaar Yesusam yinin ziiton wodanka kisa apalanam tiyayse ke wulna konin yeskoadettsi raq oydidar ke kashade. Jaagadhaama apala gudubhaam pir ke tiyade. Apallo ogonoar bhaara choo nukindar ko ashkadhade. ");
INSERT INTO amf_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ogonante kinka kikal “Hayna konin yeskenam dhesana daran itha wo dhabe; koam hattsattone” ke hamade. “Isa apalanam kinka ke kashimade; isa apalandar itha ke dhabade” hamayno Mathaap Gazante thaapadhoono upsino konin thoothoadettsi poolisanaar yin ke hayade. ");
INSERT INTO amf_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ogo wodanka Yesussa indanbee, indansa indanaanbee, Qeliyobha geshon Mayriyambee, Megdela peen edon Mayriyambe kisa masqalinkal theedi woyayse ke dahade. ");
INSERT INTO amf_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesusaar indanbee yisa paanan yivayna eenasa yinin nasheabeam kikal woyayse ke daaka keam haapayse indanka “Indo, hasa naasaam shedaa!” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ogora yisa paanan yiveana “Shedaa! Inda kosha” kina ki hamade. Keeda agaa wodara yedayse kisa paanan yivea oonin yinnondar koam entsate ki yivade. ");
INSERT INTO amf_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ogosa budonte Yesus kisa giidhon yer wulin maqonam dhesayse, Mathaap Gazante thaapadhoono upsino konin thoothoadettsi “I dheebardhade” ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ogotear woyni thorkaa wucadhen koymonka thoosadhaa dahade; kediar woynin thorkonam saaroka tittsayse yisoobh hambhea hattasa koolinka kisa apondar ke yeskisade. ");
INSERT INTO amf_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesusaar woynin thorkonam yinin wuconsa budonte, “Keeda maqidine” hamayse meten yinnonam yirk hayayse ki diyade. ");
INSERT INTO amf_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ukunsen rooroana ashkimbhadhayno rooro konin dohonnabee agaa ukunsen rooroa kattsi detha rooro kinin dohonnabe, Ayiwd eenam entsaynaar ziitadhaana eenasa leesino ukunsen rooroaka masqalindar konin doamadettsi saana ke diye kesa gubeezinam aysayse keam masqalira hanchadhoadettsi Bhilathoosam ke miskade. ");
INSERT INTO amf_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Poolisanaar nivayse kimbesana masqalindar ziitadhaana eenasa gubeezinam ke aysade. ");
INSERT INTO amf_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Yesuskal kenin nivenka kidi birayse kinin diyonam shedayse kisa gubeezinam aysadehe. ");
INSERT INTO amf_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ko dahaannaar poolisanasa kalaa kisa demenam banqika ki uxade; saanawa zombhibee noqobe ko utade. ");
INSERT INTO amf_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ogoam haapaar tarjidine; kisa tarjamonoar gonne. Yedi pir gonne hamayse yenin tiyoadettsi kidi gonin kinin giyenam kida dhese. ");
INSERT INTO amf_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ogono yin maatoono “Kisa lepinsa kala hattear aysadhehe” hamayse Mathaap Gazante thaapadhoono upsino konin thoothoadettsine. ");
INSERT INTO amf_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Pir mathaapinsa waani raqinte “Agaa yinin uxaa eam sheda ke shede” koda hame. ");
INSERT INTO amf_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ogosa budonte Ayiwd eenam entsaynana yinin kurtumbhonna, aachika Yesussa paanan yivea Armatias katamara nivaa Yoseep Yesussa leesinam tiyana Bhilathoosam ki miskade. Bhilathoosaar leesinam kina imbhoadettsi ki giyade. Ogonante nivayse Yesussa leesinam ki tiyade. ");
INSERT INTO amf_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Pir birayse sootinka Yesuskal nivaa Niqodimos eedi kalaa kaysa apo tabhi kiloaddha gochea kerbe hambhen gaamen shittonbee walqobeka worsadhonam bavate ki nivade. ");
INSERT INTO amf_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yesussa leesinamaar tiyayse Ayiwd eenin qunthen dambindettsi qunthayse gaamen shittonam laalayse apalanka kiam ke ochade. ");
INSERT INTO amf_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kinin ziitadhon raqinkal theedi haaqa kordhaa haami ko dahade; haaqan kordhon haaminte eedin duukadhaama duuki oolo ko dahade. ");
INSERT INTO amf_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ogonante duukin ranqo theedi konin dohonnabee Ayiwd eensa ukunsen rooroana ashkimbhadhayno rooro konin dohonnabe Yesussa leesinam ogote ke duukade. ");
INSERT INTO amf_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Gabansa rooroa biraa Wuudi seddhiman peen thipa daaka, Megdela peen edono Mayriyam Yesussa duukindar ko yivade; duukin oolon shupadhoono senno apora gunngumayse ko daaka ko haapade. ");
INSERT INTO amf_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kodiar gobate Simoon Bhethiroosbee Yesusin nashea kisa paanan yivea waabekal nivayse, “Imba Yesussa leesinam duukira ke tiyade; hamote kiam kenin wodonam dhesattone” kena ko hamade. ");
INSERT INTO amf_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ogonante Bhethiroosbee Yesussa paanan yivea waabe utayse duukindar yivan ke yedade. ");
INSERT INTO amf_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Lamaanaar kinka gobite ke daaka, kesa waa Bhethiroosam saana gobaka duukinam birayse ki yeskade. ");
INSERT INTO amf_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Yirk hamayse kinin shedenka, leesinam yinka ochadhoono apallo ogote ko dahaysaka ki haapade; ko dahaannaar kidi duukinte ardadehe. ");
INSERT INTO amf_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoon Bhethiroosaar kisa budonte nivayse duukinte ki ardade; Yesussa leesinam yinka ochadhoono apallo ogote ko daaka, ");
INSERT INTO amf_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","pir kisa meten ochadhaa apalam, kisa leesinam ochadhon apalanbesana dayma yimal raq abir ki daaka ki haapade. ");
INSERT INTO amf_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ogo wodanka birayse duukindar yeskaa Yesussa paanan yivea waa duukinsa iinte ki ardade; ogora shedayse Yesus dembhira kinin dhaabhonam gonne hamayse ki tiyade. ");
INSERT INTO amf_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","“Dembhira dhaabha kiam ko zaske” hamayno Mathaap Gazante thaapadhon upsinam akar kedi dhesadehe. ");
INSERT INTO amf_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ogora kedi lamaana onna yinnadar maatayse ke yivade. ");
INSERT INTO amf_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mayriyam eepada duukinkal ko woyade. Pir eepada yirk hamayse duukinsa iinaam ko shedade. ");
INSERT INTO amf_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Apala cawli qaadhaana Barjosa gaanana lamaana Yesussa leesin wodadhon raqinsa kalaa metembar, lansoar roonbar dooqayse ke daaka keam ko haapade. ");
INSERT INTO amf_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Kediar “Ya edono, harrnaa eepe?” kona ke hamade. Kodiar “Isa Imbaam kedi tiydine; hamote kiam kenin wodonam dhesattine” kena ko hamade. ");
INSERT INTO amf_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ogoam yin giyayse budoka wal hamayse konin shedenka, Yesus ogote woyayse ki daaka kiam ko haapade; Yesus kinin dohonam kodi dhesadehe. ");
INSERT INTO amf_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesusaar “Ya edono, harrnaa eepe? Hayyeama zage?” kona ki hamade. Kodiar haaqan kordhon haaminte waadadhea eedi kona kinin maatonna, “Imbo, ha kiam tiydianna, hamote hanin wodonam ina giyaa; intaar kiam tiyayda tiye” kina ko hamade. ");
INSERT INTO amf_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesusaar “Mayriyam” kona ki hamade. Kodiar kidar wal hamayse Ibra aponka “Rebuuni!” ko hamade; kosa bulinoar “Dhettsea” hamintane. ");
INSERT INTO amf_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesusaar “Akar Imbadar tura inin yivaamonna, iam kaamaabhode; ko dahaannaar imbanaanakal yivayse, ‘Inta imbee yembesa Imba maataa, pir imbee yembesa Barjo maataakal ida yive’ hamayse kena giyaa” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ogona Megdela peen edono Mayriyam Yesussa paanan yivayna eenakal yivayse, “Imbaam inta haapidine” kena ko hamade. Ogora Yesusin kona giyonam kena ko giyade. ");
INSERT INTO amf_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Agaa gabaasa biraa rooroa Wuudi sootin Yesussa paanan yivayna eena kinka bukayse, Ayiwd eenam entsaynaam kurtumbhintaka kerinam yidar diithayse ke daaka, Yesus kekal ki nivade. Kesa shaarintear woyayse, “Payyamo yena ko dee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yin giyayse yisa aaninbee demenbeam kena ki dhahade. Kisa paanan yivayna eenaar Imbaa Yesusam yinin haapenka kattsi ke wozadhade. ");
INSERT INTO amf_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesus pir “Payyamo yena ko dee; Imba iam kinin yittsondettsi inta taar yeam ida yittse” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yin giyayse kedar uf hamayse, “Manpas Gazanam tiyee. ");
INSERT INTO amf_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Yedi eensa seesonam ko shidhe ye hamina, kesa seesono kena shidha ko shidhe; yedi eensa seesonam ye garimina, kenaar gardhehe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ko dahaannaar Yesusin niven wodanka tabhi lamaanasa kalaa, Didimos hambhea Toomaase kekal qolehe. ");
INSERT INTO amf_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Yesussa paanan yivaynasa waani “Imbaam wo haapade” kina ke hamade. Kidiar “Kisa aaninte konngadhonsa madanam i haapaamma, isa aaninsa surkenka kisa konngadhon raqinam i kaamaamma, kisa uxadhon demenam isa aaninka i kaamaamma gonne hamayse tiyattine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Rooro lankaysa budonte kisa paanan yivayna eena tapir ooninsa iinte ke dahade; Toomaasear kembesana kinka ki dahade. Kerro diithimi ko daaka Yesus kekal nivayse kesa shaarinte woyayse, “Payyamo yena ko dee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ogosa budonte Toomaasena “Hasa aaninsa surkenka isa annaam kaamayse shedaa; aanin hannonka isa uxadhon demenam kaamaa. Idar woylam qajaa, qothimaabhode” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toomaasear “Isa Imbaa, isa Barjoa!” hamayse kina ki maasade. ");
INSERT INTO amf_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesusaar “Iam hanin haaponna idar woylamina qajade; haapima idar woylamin qajayna eena gobshadhaanane” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesusaar mathaapa kaate thaapadhaama thoothi tarshea yer yisa paanan yivaynasa birante waadadhidine. ");
INSERT INTO amf_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ko dahaannaar koam thaapadhoono Yesus Barjoyn qadhaa Kiristoos, Barjo Naas kinin dohonam gonne hamayse yenin tiyoadettsibee kidar woylamin qajayse kisa naabenka sadaka yenin doadettsibe hamaysene. ");
INSERT INTO amf_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ogosa budonte Yesus Thibiriyadoos bazinsa aponte yisa paanan yivaynakal pir ki haapadhade. Kinin haapadhoonoar yinne: ");
INSERT INTO amf_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoon Bhethiroosbee, Didimos hambhea Toomaasebee, Galila peensa Qaana katamara nivaa Natinaveelbee, Zabdoos naanabee, Yesussa paanan yivaynasa lamaana waanibe kinka ke dahade. ");
INSERT INTO amf_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoon Bhethiroos “Inta kaaran qazota ida yive” kena ki hamade. Kediar “Wodi hambesana yivooda yive” kina ke hamade. Utayse bazindara sagadhen gonngalante ardayse ke yivade; sootin ogo kaara kala hattear yedadehe. ");
INSERT INTO amf_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Peen sedhaysaka Yesus bazinsa aponte ki woyade; kisa paanan yivayna eena Yesus kinin dohonam dhesadehe. ");
INSERT INTO amf_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesusaar “Naanato, kaara yekal daaw?” kena ki hamade. Kediar “Qolehe” hamayse kina ke maasade. ");
INSERT INTO amf_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kidiar “Kaaran qazadhen zaaninam bazindara sagadhen gonngalansa mizaqimbar dhabee; yedeeda yede” kena ki hamade. Ogonante kediar ke dhabade; thoothi kaaranin yedadhonna, gochayse bulano keam bashidine. ");
INSERT INTO amf_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yesusin nashea kisa paanan yivea ea Bhethiroosna “Kaa kidi Imbane!” kina ki hamade. Ogonante Simoon Bhethiroos Imbaa kinin dohonam yinin qansenka, pundiri yinin dohonna apalan yinnonam qaadhayse bazinte ki bhulade. ");
INSERT INTO amf_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yesussa paanan yivayna waani eedi tabhi kaysa dhundhuma bish bazinsa apora kenin pegadhonna, kaaran iir thoothon zaaninam gochayse bazindara sagadhen gonngalanka ke nivade. ");
INSERT INTO amf_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Gonngalara peendar kenin utenka, balashabee nuun qolshinandar wodadha kaarabe ke haapade. ");
INSERT INTO amf_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesusaar “Ta yenin yedon kaarara bevee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoon Bhethiroosaar bazindara sagadhen gonngalante ardayse eedi tobbhaa kaysa apo tabhi makkam gembha kaaranaka thoothon zaaninam peendar ki gochade; ogoaddha hamon kaaran ko yedaakaar zanno havadehe. ");
INSERT INTO amf_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesusaar “Kote nivayse itsee” kena ki hamade. Kisa paanan yivaynasa kala hattear “Ya hayne?” hamayse kiam oysana zagaa eedi qolehe; Imbaa kinin dohonam kedi dhesidine. ");
INSERT INTO amf_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesus balashanam tiyayse kena ki imade; kaaranamaar ogodettsi kena ki imade. ");
INSERT INTO amf_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesus dembhira yinin dhaabhonsa budonte yisa paanan yivaynana kinin haapadhenka kono kisa goyti makkansone. ");
INSERT INTO amf_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Galan kenin itsonsa budonte Yesus Simoon Bhethirooskal “Wannissa naasa Simoon, kinara sagi iam ya nashaa nasho?” kina ki hamade. “Ee, Imbo, haam inin nashenam ya dhesaada dhese” kina ki hamade. “Isa anqanaam gishaa!” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Pir lanso “Wannissa naasa Simoon, iam ya nashaa nasho?” kina ki hamade. “Ee, Imbo, haam inin nashenam ya dhesaada dhese” kina ki hamade. “Isa yaanaam gishaa!” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Makkanso goyt “Wannissa naasa Simoon, iam ya nashaa nasho?” kina ki hamade. Makkanso goyt “Iam ya nashaa nasho?” kinin hamonna Bhethiroos woylaminka yisa atayse, “Imbo, ya wulam hada dhese; haam inin nashenam ya dhesaada dhese” kina ki hamade. Yesusaar “Isa yaanaam gishaa! ");
INSERT INTO amf_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Inta hana gon ida giye: Ya barsh hanin dohonka hasa qalbathanam karnante hanti dhaxayse hanin nashendar hada yive. Ko dahaannaar hanin gecchenka aanin hannonam hada pishke; eedi ab hasa qalbathanam karnante hana kida dhaxe; yivana hanin nashimondar haam kida entse” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Hamindettsi dembhika Barjoam kinin gobshenam kina eshkana ogoam ki giyade. Ogoamaar yin giyayse, “Isa paanan nivaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Bhethiroos budoka wal hamayse kinin shedenka, Yesusin nashea kisa paanan yiveam kesa paananka kinin nivenka kiam ki haapade. Kidi anngala sootin galandar kenin dohon wodanka Yesussa sadankal theedayse, “Imbo, haam yettsate imea hayne?” hamayse oysaa kidine. ");
INSERT INTO amf_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Bhethiroosaar kiam haapayse Yesusna “Imbo, ea kaa keeda hamin ki hame?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesusaar “Inin nivenka yekka kinin doadettsi i zagidianna, haam gidir arsoono hare? Ya isa paanan nivaa!” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ogonante agaa Yesussa paanan yivea ea “Dembhi keeda diyehe” hamayno dhalqino imbaanaanasa shaarinte ko qansimade. Ko dahaannaar Yesus “Inin nivenka yekka kinin doadettsi i zagidianna, haam gidir arsoono hare?” ki hamade; “Dembhi diyehe” hamadehe. ");
INSERT INTO amf_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yerra iginana tarjaabee thaapaabe kisa paanan yivea ea agaane; kisa tarjamonoar gon konin dohonam dhesooda dhese. ");
INSERT INTO amf_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Waani pir Yesusin waadadhoono thoothi yer daane; wulam kalaa kalaa thaapadhidianna, ini thaapadhayna mathaapinana peeno kono yeekehe hamayse ida bhocche. ");
INSERT INTO amf_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Toplooso, Yesus waadiman yinnonam yinin yedon wodara cecindar yinin yivenka yekka, kinin waadadhonbee dhettsonbe wulam biraa mathaapadar inta thaapidine. Cecindar kinin utensa birayse yisa tarjamonnante kamayse yinin yittsaana eenana Manpas Gazanka “Yin hayee” hamayse ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ogonoar dembhira yinin dhaabhonsa budonte, eedi lamaa kaysa rooroka yekka thoothi tarjaka may kena sadanka dahayse haapadhaate Barjosa bitamonam kena giyaate ki dhahade. ");
INSERT INTO amf_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Kembesana kinkaar yinin dohon wodanka Yerusaalemra kenin utoamadettsi kena ki giyade. Ko dahaannaar, “Inin yena giyoono Imba ‘Yena imayda ime’ kinin hamonam toolee. ");
INSERT INTO amf_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Harrna hambhidianna, Wannis eenaam noqoka ki shivade; yedi likka roorosa budonte, Manpas Gazanka yeda shiidhe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Kediar kinka bukayse kenin dohonka, “Imbo, Israveel eena maatate kenin bitimoadettsi hanin hayayno wodano taakiw?” hamayse kiam ke oysade. ");
INSERT INTO amf_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesusaar kena yinin maasenka, “Imba yisa hayamonka kinin bhocchon wodanbee levenbeam ye dhese yena imbhadehe. ");
INSERT INTO amf_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ko dahaannaar Manpas Gazanin yedar hanchon wodanka kantanam yeda tiye; Yerusaalembee, Yiwda peen wulbee, Sammaria peenbe, pir peensa gasanka yekka, isa tarja yeda maate” ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesus ogoam yinin giyonsa budonte, kiam keda shedika tura cecindar ki yivade; polonoar kesa aapira aachayse kiam ko tiyade. ");
INSERT INTO amf_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kinin yivenkaar kedi tura cecin shedayse ke daaka, marrato! Apala cawli qaadhaana eena lamaa kesa gasante ke woyade. ");
INSERT INTO amf_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Yedi Galila eenato, tura cecin shedada harrnee woyaa? Agaa yekalanka cecindar tiidhaa Yesus cecindar kinin yivenka yenin shedaadettsi, yin maatate kida nive” kena ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ogo wodanka Dabirezayt hambhen dhukara Yerusaalemdar ke maatade; Dabirezayt dhukano Yerusaalemkal theedine. ");
INSERT INTO amf_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Yerusaalem gidir nivayse yinin dehen ooninsa zulondar woysadhon oonin ke utade. Kediar Bhethiroosbee, Wannisbee, Yayqoobbee, Indiriasbee, Pilbhoosbee, Toomaasebee, Bartelemoosbee, Maatoosbee, Ilpoos naasa Yayqoobbee, peen yinnonna bish qaabea Simoonbee, Yayqoob naasa Yiwdabe, ");
INSERT INTO amf_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","pir maa waanibee, Yesussa indan Mayriyambee, Yesussa kannabe kinka maatayse rooro wul Barjoam miskana bhocchi kalaaka bukite ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ogo wodanka bukaana eedi lax kaysa maatayna Yesussa paanan yivayna eenasa shaarinte Bhethiroos woyayse yin ki giyade: ");
INSERT INTO amf_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Imbanaanato, Yesusam yedaana eenasa entsaa Yiwdana Manpas Gazano birayse Dawtsa aponka kinin giyoono Mathaap Gazante thaapadhoono thootha ko zaskade. ");
INSERT INTO amf_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yiwda wombesana paydadhaa, ko Barjosa waadimanna kambhaa eedi ki dahade” ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ea agaa kisa siyon waadimanna kashadhon koymonka pee ki shanade. Kidi gupana ki dhambaysaka kisa iino bhaqayse nuqurtino ko utade. ");
INSERT INTO amf_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ogono yerro Yerusaalem gidir dohon een wulkal ko dhesimade. Ogonante peen ogoam kesa aponka “Akeldama” hamayse ke eelade; kosa bulinoar “zombhi pee” hamintane. ");
INSERT INTO amf_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Bhethiroos pir “Ogonoar yin konin dohoono Mazmur mathaapinte ‘Kinin dahayno ranqo eedin qolmino ko dee; eediar gidir ko dahabhoode’ taar, ‘Kisa hayamonam eedi ab ki tiye’ hamayse thaapadhonnane. ");
INSERT INTO amf_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Ogonante Imbaa wontea Yesus wosa shaarinte kinin dohon wodan wulka wombesana kinka dahayna eenasa shaarira, ");
INSERT INTO amf_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Wannisin shiverra yedayse Imbaa wontea Yesus cecindar kinin yivaa rooroaka yekka dahayna eenasa kalaa wombesana kinka Yesussa diira dhaabhidinsa tarja maata ko kiam zaske” ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ogonante kesa shaarira eedi lamaam ke woysade; kediar Bersaabas way Iyosthos hambhea Yoseepbee Maatiasbene. ");
INSERT INTO amf_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Barjodar woylamin qajayna eenaar yin giyayse Barjoam ke miskade: “Een wulsa woylamin dhesea Imbaa wontea Yesuso, hasa tarja hayayse yiam hanin nittsaa kinin doadettsi, eena igina lamaanasa hayyeam hanin kamonam wona eshkaa. Kono waadimano Yiwda yisa raqinte yivan kinin garoono waadimanone” hamayse kiam ke miskade. ");
INSERT INTO amf_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ithaar ke dhabade; ithanoar Maatiasdar ko wavade. Ogonante kidiar tabhi kalaana Kiristoos yisa tarjamonnante kinin yittsaanabesana kinka ki paydadhade. ");
INSERT INTO amf_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Bhentheqosthe bavaala yeskaysaka Yesussa paanan yivayna eena wul raq kalaadar bukayse ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Bhocchadhima wura kantadettsi maatoono upsi cecira nivayse kenin dohon ooninka ko thoothade. ");
INSERT INTO amf_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nuusa laabhinadettsi maatayna atabh kashimayse kesa metena metenadar ko dooqade. ");
INSERT INTO amf_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kedi wulaar Manpas Gazanka ke thoothade. Manpasinoar kenin giyoadettsi kena imoono apo waana waanaka giyan ke yedade. ");
INSERT INTO amf_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ogo wodanka peen wulra nivaana Ayiwd eenasa Barjona goodimintaka wocchimbhayna eena Yerusaalem gidir ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ogo upsinam yinin qansen wodanka thoothino eeno ko bukade; eeno ogono wul kesa aponka kenin giyenka keam kenin qansonna yinin giyenam ke bashadhade. ");
INSERT INTO amf_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kattsi targadhayse yin ke giyade: “Marrato! Igina giyayna eena wul Galila eenatayu? ");
INSERT INTO amf_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ta keeda wodi wul wonnon aponka kenin giyenka woda qanse. Yin hamin ko maataa? ");
INSERT INTO amf_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Wodi Bharte eenabee, Meedon eenabee, Elaam eenabee, Mesbhethoomia eenabee, Yiwda eenabee, Qebhedoqia eenabee, Bhanthoos eenabee, Isiya eenabee, ");
INSERT INTO amf_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Pirgia eenabee, Bhinpilia eenabee, Gibth eenabee, Qerena katamansa gasante dohon Liibia eenabe; pir Roome katamara nivaana Ayiwd eenabee Barjodar woylamin qajintanka Ayiwd eenadar ardaana eenabe; ");
INSERT INTO amf_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","tapir Qerthes eenabee, Areb eenabe dahayse Barjosa gebhon waadimanam wodi wul wonnon aponka kenin giyenka qansite wo dahade” ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Eena wul targadhayse yinin giyen bashadhayse, kinka kikal “Kono yer hare?” ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Waani eeno ko hanna, “Wucadhenam wucayse ke bardhade” hamayse keam ko bagade. ");
INSERT INTO amf_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ogo wodanka Bhethiroos tabhi kalaana Kiristoos yisa tarjamonnante kinin yittsaanabesana kinka woyayse, upsi gebhika eenana yin ki giyade: “Yedi Yiwda peen eenabee Yerusaalem gidir dahaana eena wulbeto, inin yena giyenam qansee; payya hayayse dhesee. ");
INSERT INTO amf_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Yenin qaabendettsi eena igina bardhaanatehe; peen sedhaysaka savaat makkamne. ");
INSERT INTO amf_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ko dahaannaar ta ko yenin qansayno dhalqino ena Barjokala qansayse eenna giyea Yuveelin giyoonone: ");
INSERT INTO amf_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Barjo yin ki giyade: “Macchin rooroaka yin koda maate: Een wuldar isa Manpasinam ida laale. Naana yenna annginabee maanabe Barjokala qansayse eenna keda giye; barshina naana yennaar Barjoyn kena dhohon shedintonam keda haape; yesa donzanaar haama keda haape. ");
INSERT INTO amf_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Igina rooronaka annginabee maanabe ina waadimayna eenadar isa Manpasinam ida laale; kediar ikala qansayse eenna keda giye. ");
INSERT INTO amf_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Tura cecinte tarshen yerinaam, mia peentear milkitinam ida dhee; zombhibee, nuubee, cubabe koda haapadhe. ");
INSERT INTO amf_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kattsi gebhi maatayno tarshayno Barjosa rooronin nivonsa birayse hayno thipa ko thipe, arpinoar zombhidettsi maatayse koda ookime. ");
INSERT INTO amf_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Barjosa naabenam eelayna wul dhaqa ke dhaqe” ki hamade’ hamayse ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Yedi Israveel eenato, upsina kinaam qansee: Yenin dhesendettsi Barjo Naazret ea Yesusbar yesa shaarinte kinin waadadhon kattsi tarshen yerinbee milkitinbe goynka Barjokalanka nivaa ea kinin dohonam yena ki tarjade. ");
INSERT INTO amf_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yesusam Barjo birayse kinin bhocchonbee kinin dhesondettsibe yena saskate kiam ko imbhade; yediar seeson eenasa aaninka kinin ziitadhoadettsi hayayse ye dettsade. ");
INSERT INTO amf_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Barjoar dembhisa gaalenam bashayse diira kiam ki dhaasade; harrna hambhidianna, dembhinoar kiam yedayse kinin dhaabhoamadettsi marana damadehe. ");
INSERT INTO amf_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dawtaar kinnon goynsa yin ki giyade: ‘Barjoam rooro wul isa birante ida shede; imbesana kinka kinin dohonna gibazattine. ");
INSERT INTO amf_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ogonante isa woylammo ko wozadhade; isa atambhoar wozanka ko thoothade; pir isa waanoar Barjodar qaabe hayayse koda dee. ");
INSERT INTO amf_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Harrna hambhidianna, isa sadanam diyaana eenayn dohon raqinte garattane; Gazaa hasa Naasaar kinin capoadettsi kiam hayattane. ");
INSERT INTO amf_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Sadaka daadhensa goynam ina ha dhettsade; imbesana kinka hanin dohonna, ina wozanam hada thoose’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Imbanaanato, ena wosa eykea Dawt kinin diyonbee, kinin duukadhonbee, kisa duukinoar kinaka yekka wosa gasante dohonbeam qothimima yena ida giye. ");
INSERT INTO amf_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dawt Barjokala qansayse eenna giyea kinin dohonnabee, Barjo ‘Hasa muldhara hasa bitamon borkotondar ida wode’ hamayse malla kina yinin ardonam yinin dhesonnabe, ");
INSERT INTO amf_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","birayse shedayse, Barjoyn yiam qadhaa Kiristoosam diyaana eenayn dohon raqinte kinin garoamadettsibee kisa waanar duukinte konin capoamadettsibe diira kinin dhaabhenam ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Kaa Yesusam Barjo diira kiam ki dhaasade; yerin kosa wodi wul tarjana eenane. ");
INSERT INTO amf_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ogonante Barjo yisa mizaqimbar dheg dheg hayayse kiam ki wodade. Kisa Imbaa Barjo ‘Yena Manpas Gazanam imayda ime’ hamonam Yesus tiyayse ogo yenin haapenbee yenin qansenbeam ki laalade. ");
INSERT INTO amf_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Dawt yina cecindar utadehe; ko dahaannaar Dawt yinti yin ki giyade: ‘Barjo isa Imbaana, “Haam jibbayna eenaam hasa hayamon demente inin hayenka yekka, isa mizaqimbar dooqaa” kina ki hamade’ hamayse ena ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ta keeda yenin ziitaa kaa Yesusam Imbaabee qadhadhaa Kiristoosbe kiam Barjoyn hayonam Israveel eena wul gon ke dhese” ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Eenaar dhalqin ogoam yinin qansenka, yisa woylaminka kattsi atayse Bhethiroosbee waani Kiristoos yisa tarjamonnante kinin yittsaana eenabena “Imbanaanato, ta keeda yer har wo hayo?” kena ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Bhethiroosaar kena yin ki giyade: “Seeson waadiman yennonam garayse Barjodar maatee; yesa seesonam yena shiishadhoadettsi yedi yesa meteka meteka Yesus Kiristoossa naabenka shiidhee; Barjo yena imayno Manpas Gazanamaar tiyeeda tiye. ");
INSERT INTO amf_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Harrna hambhidianna, Barjo ‘imayda ime’ kinin hamon Manpas Gazano yembee, yesa naanabee, Imbaa wosa Barjo yikal kinin eelayna pegente dahaana eena wulbenane” ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Bhethiroos thoothi kena yinin tarjenka, “Ko wodanka dahaana siyana eenadar niven Barjosa wacimera dhaqee!” hamayse keam ki kiilade. ");
INSERT INTO amf_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Kisa dhalqinam tiyaana eena ke shiidhade; ogo rooronka shii makkamaddha Barjodar woylamin qajayna eena kedar ke ardade. ");
INSERT INTO amf_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kediar Kiristoos yisa tarjamonnante kinin yittsaana eena kenin dhettsenam qansintabee, kinka kalaa dayntabee, kinka gala itsintabee, Barjoam miskintabeka ke wocchimbhade. ");
INSERT INTO amf_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ogo wodanka Kiristoos yisa tarjamonnante kinin yittsaana eenaka thoothi tarsheabee Barjosa hayamon dhehea yerbe yinin waadadhonna eena wul ke kurtumbhade. ");
INSERT INTO amf_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Barjodar woylamin qajayna eena wul kinka kalaa ke dahade; yisa dohon yer wulamaar kinka ke kashimade. ");
INSERT INTO amf_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Yisa haaminbee dohon koymonbeam shanshayse een wulna zaskendettsi ke kashimade. ");
INSERT INTO amf_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Rooroa rooroaka Barjosa gazan ooninte woylam kalaaka maatayse keda buke; kinka yisa onnar kiam eelayse wozadhaate woylam payyaka kinka galanam keda kumme. ");
INSERT INTO amf_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Barjoamaar keda gobshe; eeno wulaar keam koda gobshe. Imbaa wontea Yesusaar kidar woylamin qajayse dhaqayna eenaam rooroa rooroaka kedar kida arse. ");
INSERT INTO amf_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Bhethiroosbee Wannisbe Barjoam miskadhen sal savatka Barjosa gazan oonindar ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ogo wodanka adhadhorra yedayse rooysa wobaa eedi kalaam eedi waani kedayse ke nivade; kiamaar rooro wulka bavayse “Kerro Goobeno” hamayse yiam eldhen Barjosa gazan ooninsa mayante ardadhen kerin gasante kiam keda wode. Ear ogote dooqayse Barjosa gazan ooninsa mayante ardayna eenakalanka yer kida miske. ");
INSERT INTO amf_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kidiar Bhethiroosbee Wannisbe Barjosa gazan ooninsa mayante kenin ardenka keam shedayse yer keam ki miskade. ");
INSERT INTO amf_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Kediar payya hayayse kiam ke shedade; Bhethiroos “Woam shedaa!” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ear yer kina imana kenin hayea konin maatonna keam ki shedade. ");
INSERT INTO amf_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Bhethiroosaar “Koymo kala hattear ikal qolehe; ko dahaakaar ikal dohonam hana imayda ime. Naazret peen ea Yesus Kiristoossa naabenka dhaabhayse yaayaa!” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kisa mizaqin aaninamaar yedayse kiam ki dhaasade; saanawa kisa roonbee gaaran buqonbe ko wocchimbhade. ");
INSERT INTO amf_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Lav hamayse woyayse yaayan ki yedade. Yaayadabee, bhuladabee, Barjoam gobshadabe Barjosa gazan ooninsa mayante kembesana kinka ki ardade. ");
INSERT INTO amf_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Eena wulaar yaayada Barjoam kinin gobshenka kiam ke haapade. ");
INSERT INTO amf_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Barjosa gazan ooninsa mayante ardadhayno Kerin Goobensa gasante dooqayse eenkala yerin miskea ea kinin dohonam ke dhesade. Kinin yaayenamaar haapayse kattsi ke targadhade. ");
INSERT INTO amf_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ear Bhethiroosbee Wannisbeam yedayse ki daaka, eeno wul targadhaate kekal gobayse Solomoon Baaran hambhen raqinte ke nivade. ");
INSERT INTO amf_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Bhethiroosaar eenaam shedayse kena yin ki giyade: “Yedi Israveel eenato, yerin koka harrnee targadhe? Wodi wosa kantabee wosa gazamobeka ea kaa ki yaaye wonin hayaadettsi maasayse harrnee woam shede? ");
INSERT INTO amf_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Wosa eykena Abraambee, Yisaaqbee, Yayqoobbesaar Barjoa, kisa Naasa Yesusam ki gobshade. Yediar Bhilathoosna saskate kiam ye imade; Bhilathoosaar kiam bulana kinin bhocchenka, ‘Kiam zagattone’ hamayse ye giyade. ");
INSERT INTO amf_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yediar gazabee tipabe maataa eam ‘Kiam zagattone’ hamayse, een deesaa eam yena buldhoadettsi ye miskade. ");
INSERT INTO amf_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Sadanka daadhen imea eam ye dettsade; Barjoar diira kiam ki dhaasade. Ogona wodi tarjanane. ");
INSERT INTO amf_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kaa yenin haapeabee yenin dheseabe kinin paashoono Yesusdar woylamin qajintakane; Yesussa naabenka dhaqayse ki wocchimbhade. Yesusbar haapadhen Barjodar woylamin qajintakaar ye wulsa birante payyamo kidi haapidine. ");
INSERT INTO amf_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Taar imbanaanato, yembee yeam wottsaynabe dhesima Yesusdar yenin waadadhonam dhesayda dhese. ");
INSERT INTO amf_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Barjoar ena birayse yikal qansayse eenna giyayna wulsa aponka ‘Barjoyn qadhaa Kiristoos gaale tiya kiam ko zaske’ kinin hamoono konin thoothoadettsi ki hayade. ");
INSERT INTO amf_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ta keeda yesa seesonam yena gardhoadettsi seeson waadimanam garayse Barjodar maatee. ");
INSERT INTO amf_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Yin ye hayna Barjokala ookime woda yena nivasane. Barjoar ena birayse yena kamayse kinin qadhaa Yesusam kida nittse. ");
INSERT INTO amf_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Barjo enara yedayse kikala qansayse eenna giyayna gazana eenasa aponka kinin giyondettsi, yer wul haalisadhenka yekka Yesus cecinte kappa kiam ko zaske. ");
INSERT INTO amf_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musear ‘Imbaa yesa Barjo iam kinin dhaasondettsi yesa shaarira Barjokala qansayse eenna giyea eam yena dhaasa ki dhaase; kinin yena giyen wulam qansee. ");
INSERT INTO amf_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ogo Barjokala qansayse eenna giyea eakal qansima eedi hayyear eensa shaarira edimayse ki kaye’ hamayse ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ogodettsi Saameeldara yedayse dahaana Barjokala qansayse eenna giyayna wul ta ko wodansa kedi giydine. ");
INSERT INTO amf_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yedi Barjokala qansayse eenna giyayna eenaka kinin imon upsinam tiyayna eenane. Barjo Abraamna ‘Hasa muldhanaka peendar dohoono eeno wul gobshadhoono koda maate’ hamayse wosa eykenabesana kinin ardon mallanam yedi tiyayna eenane. ");
INSERT INTO amf_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Barjo Naasa yinteam dhaasayse kinin yittsoono birayse yenane. Ogono yin kinin hayoonoar yedi kalaa kalaana yesa siyon waadimara yeam maasintaka yeam gettsanane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Bhethiroosbee Wannisbe eenana kenin giyenka, gudullabee, Barjosa gazan ooninam toolayna eenasa wottseabee, Saduqa eenabe kedar ke nivade. ");
INSERT INTO amf_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bhethiroosbee Wannisbe eenaam kenin dhettsenbee Yesuska diira dhaabhinta dohonam kenin giyenbena ke wacimade. ");
INSERT INTO amf_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Keam yedaysear peenin ibanonna, peenin sedhenka yekka dhaxin ooninte keam ke dhaskade. ");
INSERT INTO amf_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ko dahaannaar Bhethiroosbee Wannisbesa dhalqinam qansaana eenasa shaarinte thoothino eeno Barjodar woylamin ko qajade; ogo wodanka Barjodar woylamin qajon eensa paydino shii dongaddha ko yeskade. ");
INSERT INTO amf_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Peen sedhaysaka Ayiwd eenaam wottsaynabee, peensa donzanabee, Musesa yigginam dhettsaynabe Yerusaalem gidir ke bukade. ");
INSERT INTO amf_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Bukaana eenasa shaarinte gudullasa gebhaa Hannabee, Qayappabee, Wannisbee, Iskindirosbee, gudullasa gebhaasa muldhana wulbe ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Kediar Bhethiroosbee Wannisbeam yisa shaarinte keam woysayse, “Ogo yenin hayoono har kantakabee haysa naabenbeka ye waadadhaa?” hamayse keam ke oysade. ");
INSERT INTO amf_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ogo wodanka Bhethiroos Manpas Gazanka thoothayse kena yin ki giyade: “Yedi eenaam wottsaynabee peensa donzanabe, ");
INSERT INTO amf_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ea woboana waadadhadhon payyan waadimanka hamin kinin paashonam kina woam oysadhidianna, ");
INSERT INTO amf_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","kiam yenin ziitaa Barjoar diira kiam dhaasaa Naazret ea Yesus Kiristoossa naabenka ea kaa paashayse yesa birante kinin woyondettsi, yembee Israveel een wulbena ko dhesime. ");
INSERT INTO amf_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ogonoar yedi ooninam woysayna eena bagayse yenin dhabaa seenia kidine; agaa seeniar kattsi ooninna zaskea ki maatade. ");
INSERT INTO amf_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Dhaqinta kikalanka ab haykaar qolehe; wonin dhaqoadettsi zaskea eennaar imbhaa Yesus naabera cecinsa choobar naabe ab qolehe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Yiwda peensa donzana Bhethiroosbee Wannisbe kurtumbhima kenin giyonam yinin haapenka, raq yinna imbhaammabee timmirinsa qolminabe kenin maatenam yinin dhesenka kedi targadhidine; Yesusbesana kinka ena kenin dohonam kedi dhesidine. ");
INSERT INTO amf_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Yisa burqonka paashaa ear kembesana kinka woyayse ki daaka kiam kenin shedenka yinin giyenam ke bashadhade. ");
INSERT INTO amf_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Yiwda peensa donzana os mayanka keam bulayse, yin giyayse kinka ke dhalqade: ");
INSERT INTO amf_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Eena kinadar yer har wo hayo? Ogono yer tarshayno kenin waadadhoono Yerusaalem gidir dahaana eena wulkal dhesimidine; ogonante wodi marimana damattone. ");
INSERT INTO amf_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ko dahaannaar eenakal dhalqino kono kattsi konin workoamadettsi, keeda kaara os eedi haynaar Yesussa naabenka kenin giyoamadettsi wocchinsayse kena wo giye” ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Keam eelayse, Yesussa naabenka eenna hamin ko dahaakaar kenin giyoamadettsibee kenin dhettsoamadettsibe wocchinsayse kena ke giyade. ");
INSERT INTO amf_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Bhethiroosbee Wannisbe yin giyayse kena ke maasade: “Ta yedi pirdee: Barjona ee hamara yena ee haminta Barjo birante zaskaynow? ");
INSERT INTO amf_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Wodi wonin haaponbee wonin qansonbeam giyara lay hamana damattone” kena ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Yiwda peensa donzana hamin keam yinin dhabshenam ke bashadhade; ogonoar zarsinam kenin kurtumbhonna keam kattsi kurtunsayse ke garade. Ogonoar zarsino yerin hamon wulka Barjoam gobshite konin dohonnane. ");
INSERT INTO amf_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Harrna hambhidianna, ogo tarshea yerinka yiam pacchadhaa easa lendho eedi lamaa kaysadara sagi ko dahade. ");
INSERT INTO amf_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Bhethiroosbee Wannisbe dhaxira keam buldhaysaka, yisa eedanakal nivayse gudullasa hayonabee peensa donzanabe kena hamon wulam ke giyade. ");
INSERT INTO amf_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kediar ogoam yinin qansenka woylam kalaaka upsinam dheg hayayse Barjodar yin giyayse ke miskade: “Imbo, cecinbee, peenbee, bazinbeam, kesa iinte dohon wulam pijaa yane. ");
INSERT INTO amf_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Manpas Gazanka hasa waadiman ea wosa eykea Dawtsa aponka ha giyna: ‘Ayiwdtay hamma eena harrna ke wacimaa? Eenoar pootimin yerinam harrna ko bhocchaa? ");
INSERT INTO amf_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Peensa binna banqinna ashkimbhayse, wottsaynaar kinka bukayse Barjobee kinin qadhaa Kiristoosbedar ke dhaabhade’ hamaysea giyade. ");
INSERT INTO amf_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Herodisbee Bhenthenaawi Bhilathoosbe, Ayiwdtay hamma eenabee Israveel eenabe kinka kataman kote bukayse, hanin qadhaa gazaa hasa Naasa Yesusdar gon ke dhaabhade. ");
INSERT INTO amf_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kenin dhaabhoono ya birayse hasa kantanbee bhocchinbeka hanin bhocchonam waadadhanane. ");
INSERT INTO amf_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Taar Imbo, kenin kurtunsenam shedaa; wodi hana waadimayna eena kurtumbhima hasa upsinam wonin giyoadettsi woam wocchinsaa. ");
INSERT INTO amf_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Gazaa hasa Naasa Yesussa naabenka hajadhaana eenaam pacchotabee, tarshea yer hayotabee, milkit dhootabe aanin hannonam pishkaa” hamayse Barjoam ke miskade. ");
INSERT INTO amf_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Barjoam kenin miskonsa budonte, bukayse kenin dohoono ranqo ko shohade; kedi wulaar Manpas Gazanka ke thoothade; Barjosaar upsinam kurtumbhima ke giyade. ");
INSERT INTO amf_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Barjodar woylamin qajayna eena wul woylam kalaabee qaabo kalaabeka ke dahade. Yer wul kesa kalaa ko dahade; kesa dohorra yer kala hattear “Kaa intine” hamayse giyea eedi qolehe. ");
INSERT INTO amf_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kiristoos yisa tarjamonnante kinin yittsaana eenaar Imbaa wontea Yesus dembhira kinin dhaabhonam gebhon kantanka eenna ke tarjade. Barjosa sunin imintono ke wuldar ko dahade. ");
INSERT INTO amf_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Haamibee oonibe yisa dahaana wul shanshaate koymonam bavayse Kiristoos yisa tarjamonnante kinin yittsaana eenana ke imade. Kiristoosin yittsaanaar een wulna keam zaskendettsi kenin imonna, kesa shaarinte gaale eed kala hattear qolehe. ");
INSERT INTO amf_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Qobhiroos gidir adhadhaa Lewi muldha maataa Yoseep hambhea eedi kalaa ki dahade. Kiristoos yisa tarjamonnante kinin yittsaana eenaar “Barnabaas” hamayse kiam ke eelade; “Barnabaas” haminta “wocchinsea ea” hamintane. ");
INSERT INTO amf_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Kidiar yisa haaminam shanshayse, koymonam bavayse Kiristoos yisa tarjamonnante kinin yittsaana eenana ki imade. ");
INSERT INTO amf_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Hanania hambhea kisa geshon Sabhirabesana yisa haami ke shanshade. ");
INSERT INTO amf_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Hanania geshonda dhesika haamin yinin shanshon birrera antinam yina shiishayse, antinam Kiristoos yisa tarjamonnante kinin yittsaana eenana bavayse ki imade. ");
INSERT INTO amf_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Bhethiroosaar “Hanania, Manpas Gazanam ha taysebee haamin hanin shanshonsa antinam hanin shiishoadettsibe Seethaan hasa woylaminte harrna ki ardaa? ");
INSERT INTO amf_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Hanin shanshensa birayse hammo hantitayu? Hanin shanshonsa budontesin koymono hasa aanintetayu? Ta yerin koam hasa woylaminka harrnaa bhocchaa? Hanin taysoono Barjoamne, eediamtehe” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Hananiar dhalqin ogoam yinin qansenka dhambayse ki diyade. Yerin ogoam qansaana eena wul kattsi ke kurtumbhade. ");
INSERT INTO amf_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Barshinaar dhaabhayse kisa leesinam ochayse tiyate ke duukade. ");
INSERT INTO amf_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Hanania diyaysaka savaat makkamsa budonte kisa geshono raqin ogote ko nivade; kodi geshoadar yeskon yerinam dhesadehe. ");
INSERT INTO amf_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Bhethiroosaar “Yesa haaminam yenin shanshoono koymona kinadaru? Ina giyaa” hamayse koam ki oysade. Kodiar “Gon iginadarne” kina ko hamade. ");
INSERT INTO amf_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Bhethiroosaar “Barjo Imbasa Manpasinam taysate shedana haminee kinka dhalqaa? Shedaa! Hasa geshoam duukayse maatayna eena mayante yeskidine; ta haamaar bulayse duuka ke duuke” kona ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kodiar saana kisa roonkal dhambayse ko diyade. Geshoam duukaana eenaar kenin ardenka diyayse ko daaka koam haapayse tiyate geshoakal koam ke duukade. ");
INSERT INTO amf_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Barjodar woylamin qajayna eena wulbee dhalqin koam qansaana eena wulbe kattsi ke kurtumbhade. ");
INSERT INTO amf_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Kiristoos yisa tarjamonnante kinin yittsaana eena thoothi milkitbee tarshea yerbeam eensa shaarinte waadadhite ke dahade. Barjodar woylamin qajayna eena wul woylam kalaaka maatayse Solomoon Baaran hambhen raqinte bukite ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Waani eensa eedi kala hattear kembesana kinka dahaana wocchimbhea eedi qolehe; ko dahaannaar eeno keam gobshite ko dahade. ");
INSERT INTO amf_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Imba Yesusdar woylamin qajayna annginabee maanabesa paydino kattsi thoothada ko yivade. ");
INSERT INTO amf_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kiristoos yisa tarjamonnante kinin yittsaana eenayn waadadhen tarshen waadiman goynka, eeno hajadhaana eenaam goyn apondar bulayse haaqabee eebhebedar keam ko wodade; ogono yin kenin hayoonoar Bhethiroos raqin ogoka kinin yivenka kisa shipeno hattear kesa waani waanidar konin yeskoadettsine. ");
INSERT INTO amf_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Pir eena Yerusaalemsa gasante dahaana gurdanara hajadhaanabee rumin dhaasite gaalaynabeam ke bavade; kedi wulaar burqora paashite ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Saduqa eensa shaarira gudullasa gebhaabee kimbesana kinka dahaana yettsina wulbe woogintaka Kiristoos yisa tarjamonnante kinin yittsaanadar ke dhaabhade. ");
INSERT INTO amf_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Keam yedayse dhaxin ooninte ke dhaskade. ");
INSERT INTO amf_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","20","Barjosa gaana sootinka dhaxin ooninsa kerinaam bulayse keam entsate yivayse, “Yedi yivayse Barjosa gazan ooninsa mayante woyayse, ko haalin sadanka daadhensa upsin wulam eenna giyee” hamayse keam ki yittsade. ");
INSERT INTO amf_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kiristoos yisa tarjamonnante kinin yittsaana eenaar upsin ogoam yinin qansenka, burin sedhiman Barjosa gazan ooninsa mayante ardayse eenaam dhettsan ke yedade. Ogo wodanka gudullasa gebhaabee kimbesana kinka dahaana eenabe nivaysaka, Yiwda peensa donzanabee Israveel eensa shaarira donzana wulbeam eelate ke buskade. Kiristoos yisa tarjamonnante kinin yittsaana eenaamaar kenin bovoadettsi dhaxin oonindar poolisanaam ke yittsade. ");
INSERT INTO amf_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Poolisana dhaxin ooninte yivayse Kiristoos yisa tarjamonnante kinin yittsaanaam haapadehe. Maatate peen donzanakal nivayse, ");
INSERT INTO amf_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Dhaxin ooninam diithadhaysaka, toolayna eenaar kerindar woyayse ke daaka keam wo haapade. Ko dahaannaar dhaxin ooninsa kerinaam wonin bulenka ooninte hayyeamaar haapootone” kena ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Barjosa gazan ooninam toolayna eenasa wottseabee gudullasa hayonabe dhalqin ogoam yinin qansenka, “Kono yer hamin hamonne?” hamayse kenin giyayno keam ko bashade. ");
INSERT INTO amf_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ogo wodanka eedi kalaa nivayse, “Marrato! Dhaxin ooninte yenin dhaxaana eena Barjosa gazan ooninsa mayante woyayse eenam dhettsite ke dahade!” hamayse kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ogona Barjosa gazan ooninam toolayna eenasa wottseabee poolisanabe yivayse keam ke bavade. Poolisana “Eeno woam seenika paxate deesasane” hamayse kenin kurtumbhonna, keam kenin bovoono kantakatehe. ");
INSERT INTO amf_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Keam bavate nivayse peensa donzanasa birante ke woysade. Gudullasa gebhaa ");
INSERT INTO amf_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Yesussa naabenam eelintaka eenam yenin dhettsoamadettsi wocchinsayse yena wodi giydine. Ko dahaannaar, marrato! Yerusaalemir yesa timmirino raq wulir yeskidine; ea agaasa zombhinamaar wodar hayana ye zagade” hamayse kedar ki dhiidhimade. ");
INSERT INTO amf_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Bhethiroosbee waani Kiristoos yisa tarjamonnante kinin yittsaanabe yin giyayse ke maasade: “Eedina ee hamintara Barjona ee haminta ko woam zaske. ");
INSERT INTO amf_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yedi masqalindar konngayse yenin ziitayse deesaa Yesusam wosa eykenasa Barjoa dembhira kiam ki dhaasade. ");
INSERT INTO amf_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ogonoar Barjo Yesusam Entseabee Dhaccheabe hayayse yisa mizaqinte gobshinka kiam dheg dheg ki hayade. Ogoam yin kinin hayoono Israveel eena seeson waadimanam garayse Barjodar kenin maatoadettsibee kesa seesonam kena gardhoadettsibe zagaysene. ");
INSERT INTO amf_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Dhalqin ogosa wodiar tarjanane; Barjo yina ee hamayna eenana kinin imoono Manpas Gazanoar tarjane” kena ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Yiwda peensa donzanaar dhalqin ogoam yinin qansenka kattsi dhagadhayse deesana keam ke qaabade. ");
INSERT INTO amf_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ko dahaannaar een wulin gobshea Musesa yigginam dhettsea Gamalial hambhea Parisa eedi kalaa Yiwda peensa donzanasa shaarinte dhaabhayse Kiristoos yisa tarjamonnante kinin yittsaana eenaam likka wodana mayanka keam kenin buloadettsi kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ogora kena yin ki giyade: “Yedi Israveel eenato, eena iginadar yenin hayota dohon yerinka mete yesaam gishee. ");
INSERT INTO amf_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ena birayse Toodas hambhea ea ‘Inta eedi gebhine’ hamayse dhaabhidine; eena mato oydiaddhana kimbesana kinka dhalqayse ke yivade. Ogora kiam deesadhaysaka kimbesana kinka yivaynaar thar thar ke hamade; kisa qaabonoar pootimino maatayse ko shidhade. ");
INSERT INTO amf_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ogosa budontear eensa naabenam thaapadhen levenka Galila peen ea Yiwda dhaabhayse thoothino eeno kisa paananka konin yivoadettsi haydine. Kiam deesadhaysaka kisa paanan yivayna wul thar thar ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Taar inin yena giyayno igina eenakalanka pegadhayse keam yenin garoadettsine. Harrna hambhidianna, ogo kesa qaabonbee kesa waadimanbe eedikalanka ko daana kaya ko kaye. ");
INSERT INTO amf_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Barjokalanka nivoono ko hanna, keam kaysana damattene; tapir Barjosa waadimanam jibbintaka kimbesana kinka gemmaana yeda maate” hamayse keam ki kiilade. Kediar kisa kiilimenam ke tiyade. ");
INSERT INTO amf_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ogora Kiristoos yisa tarjamonnante kinin yittsaana eenaam eelayse kenin qandhoadettsi hayayse Yesussa naabenka kenin giyoamadettsi kena giyayse keam ke garade. ");
INSERT INTO amf_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kediar “Yesussa naabenna bagadha yiam zaskayna eenane” hamayse Barjo keam paydonna wozadhintaka Yiwda peensa donzanakalanka utayse ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Rooro wul Barjosa gazan ooninsa mayantebee eensa onnarbe Yesus Barjoyn qadhaa Kiristoos kinin dohondettsi eenam dhettsintaka Barjosa dhacchintan upsinam giyte ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ogo wodanka Barjodar woylamin qajayna eena thoothada kenin yivenka, Girik aponka dhalqayna Ayiwd eena “Rooroaka rooroaka imbhen yerinka wosa maana qambhinaam yedi walidine” hamayse Yiwda peente adhadhaana Ayiwd eenadar ke gundumade. ");
INSERT INTO amf_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ogonante tabhi lamaa Kiristoos yisa tarjamonnante kinin yittsaana eena Barjodar woylamin qajayna eena wulam yikal eelayse kena yin ke giyade: “Barjosa upsinam giynta garayse yer itsadhea kasha woam zaskehe. ");
INSERT INTO amf_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ta keeda imbanaanato, yisa payyamon waadimanna tarjadhaana, pir Manpas Gazanbee pakalmakkonbeka thoothaana eedi tobbhaa imbhen yerinam kashayna yesa iira kamee; keam waadiman ogodar woda wode. ");
INSERT INTO amf_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Wodiar Barjoam miskaatebee Barjosa upsinam eenna giyaatebe woda wocchimbhe” kena ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kesa dhalqino ogono een wulam ko wozisade; ogora Barjodar woylamin qajintanbee Manpas Gazanbeka thoothaa Isthipaanoos, pir Pilbhoosbee, Bhirkoroosbee, Niqaronbee, Thimoonabee, Bharmenabee, Ayiwd eenasa Barjodar woylamin qajintante ardaa Anthokia kataman ea Niqolaasbeam ke kamade. ");
INSERT INTO amf_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Igina eenaamaar Kiristoos yisa tarjamonnante kinin yittsaana eenasa birante ke woysade; kediar Barjoam miskayse aaninam yisa kedar wodayse waadiman ogodar keam ke wodade. ");
INSERT INTO amf_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Barjosa upsinoar workada ko yivade; Yerusaalem gidir Barjodar woylamin qajayna eenasa paydino kattsi thoothada ko yivade; gudullasa thoothina Barjodar woylamin ke qajade. ");
INSERT INTO amf_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Isthipaanoosaar Barjosa sunin imintonbee kantanbeka thoothayse eensa shaarinte kattsi tarshea yerbee gebhi milkitbe kida waadadhe. ");
INSERT INTO amf_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ogo wodanka Qerenabee, Iskindirabee, Kilqiabee, Isiyabera maataana, “Worshamo Utaanasa Buki Raq” hambhen Ayiwd eensa bukin raqira waani waani eeno Isthipaanoosdar dhaabhayse ko palimade. ");
INSERT INTO amf_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ko dahaannaar kinin giyen pakalmakkonbee Manpasinbeam bashana damadehe. ");
INSERT INTO amf_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ogo wodanka, “Ea kaa Musebee Barjobeam kinin iirenka wodi qansidine” hamayna eenaam aachika kidar ke dhaasade. ");
INSERT INTO amf_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Zarsinbee, donzanabee, Musesa yigginam dhettsaynabeam ke dhagattsade. Ogona Isthipaanoosam yedayse Yiwda peensa donzanasa birante kiam entsate ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","“Ea kaa Barjosa gazan ooninbee Musesa yigginbeam iiran garadehe” hamayse kidar buudamoka tarjayna eenaam ke bavade. ");
INSERT INTO amf_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kediar “‘Naazret Yesus oonin koam kottsa ki kottse; Musear wona kinin giyon sharqanam kida ooke’ hamayse kinin giyenka wodi qansidine” hamayse kidar ke tarjade. ");
INSERT INTO amf_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ogote dooqaana Yiwda peensa donzana wul Isthipaanoosam payya hayayse kenin shedenka, kisa wotino Barjosa gaana wotindettsi maatayse kena ko haapadhade. ");
INSERT INTO amf_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Gudullasa gebhaa Isthipaanoosna “Dhalqino ogono gonu?” hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Isthipaanoosaar yi giyna: “Imbanaanato, inin giyen qansee! Wosa imbaa Abraam Kaaran katamandar yimbha birayse Mesbhethoomia ki daaka, gobshadhaa Barjo kina haapadhayse, ");
INSERT INTO amf_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Hasa peenbee hasa muldhanbera edimayse inin hana dhehen peendar yivaa’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ogo wodanka Abraam Baabiloon peera utayse Kaaran katamante ki dooqade; Abraam imbaa kisa diyonsa budonte, ta yenin dohon peendar Barjo kiam entsate ki nivade. ");
INSERT INTO amf_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Raqin ogote roosa taakaaddha hattear pee kina imadehe; ko dahaannaar peen ogoam kimbee kisa muldhanabena yinin imendettsi Barjo malla kina ardidine. Ogo mallanam kina kinin ardoono Abraam naasi kisa qolmon wodankane. ");
INSERT INTO amf_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Barjoar ‘Hasa muldhana eedi peer chocchi maatayse keda dee. Ogotear mato oydi leve eeno keam worsho maasayse koda galshe’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Taar, ‘Keam worsho maasen eendar pirdayda pirde; ogosa budontear peen ogora utayse raqin kote ina goodima ke goodime’ hamayse Barjo kina giydine. ");
INSERT INTO amf_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Barjo kina kinin ardon mallansa milkit qaama taxadhintasa gilo kina ki imade. Ogonante Abraam yisa naasa Yisaaq adhadhaysaka lankaysoa rooroaka qaamanam ki taxade; Yisaaq yisa naasa Yayqoobsa qaamanam ki taxade; Yayqoobaar tabhi lamaa Israveel eenasa muldhana maataana yisa naanasa qaamanam ki taxade. ");
INSERT INTO amf_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Yayqoob naana indanaasa Yoseepdar woogimbhayse Gibth peente worsho kinin doadettsi kiam ke shanshade. Barjoar kimbesana kinka ki dahade; ");
INSERT INTO amf_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","kisa gaalen wulra kiam ki bulade. Barjoar Gibth peen bitaa Paaronsa birante gembhakobee pakalmakkobeam kina ki imade. Bitaar Gibth eenbee yisa oonin wulbedar wottsea kiam ki hayade. ");
INSERT INTO amf_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Ogo wodanka Gibth peenbee Kanaan peen wulbedar gebhi galshea basho ko utade; wosa eykenaar isin haapana damadehe. ");
INSERT INTO amf_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yayqoobaar Gibth peente isinin dohonam yinin qanson wodanka, wosa eykenaam ogodar birayse ki yittsade. ");
INSERT INTO amf_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Lanson Gibth peendar maatate kenin yivon wodanka, Yoseep indanaanana yiam ki dhettsade; Yoseepsa oonin eenaar Gibth peen bitaakal ke dhesimade. ");
INSERT INTO amf_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yoseep imbaa Yayqoobbee kisa oonin eenabe, eedi makkam kaysa apo tabhi dongna wulam ‘Ikal nivee’ hamayse ki elsade. ");
INSERT INTO amf_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yayqoob Gibth peendar ki yivade. Kimbee wosa eykenabe ogote yivayse ke diyade. ");
INSERT INTO amf_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kesa leesinam Seekeemdar bavate nivayse Abraam Hamoor naanakalanka birrenka kinin shanon duukin raqinte ko duukadhade. ");
INSERT INTO amf_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Barjo Abraamna kinin ardoono mallano konin thoothayno wodan konin theedenka, Gibth peente dahaana wosa eykena kattsi thoothada ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ogo wodanka Yoseepsa waadimanam dhesima bit kalaa Gibth peente ki bitimade. ");
INSERT INTO amf_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Bitaa agaa wosa eendar cubbo goytika dhaabhayse, imbana naana kenin diyoadettsi gurdansa gasandar bavate yivayse ke dhabe wosa eykenaam ki galshade. ");
INSERT INTO amf_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Ogo wodanka Muse ki adhadhade; kidiar Barjosa birante dantanka payya naasi ki maatade. Arpi makkamna imbaa ooninte ki gebhade. ");
INSERT INTO amf_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kiam dhabadhaysakaar Gibth peen bitaasa naano kiam bavate nivayse naasi yintidettsi kiam ko gettsade. ");
INSERT INTO amf_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musear Gibth eenasa pakalmakkon wulam ki dhesade; dhalqinbee waadimanbeka eedi wocchi ki maatade. ");
INSERT INTO amf_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Musesa eedi lamaa kaysa leve maataysaka, muldhana yisa Israveel eenaam shedana ki qaabade. ");
INSERT INTO amf_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Muldhanasa kalaam Gibth eedi kalaa qanayse ki kupaka shedayse kiam ki kelshade; kupadhaasa halon maasana hamayse Gibth eam qanate ki deesade. ");
INSERT INTO amf_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Kisa muldhana eenna worsho maatayse kenin dohorra Barjo kanka keam kinin buleadettsi kenin bhocchea kina ko maatade; kediar ogoam bhocchadehe. ");
INSERT INTO amf_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Kina hamon Israveel eensa shaarira lamaana eena kinka ke kansaka shedayse keam marsana zagayse, ‘Marrato! Yedi kinka kisa muldhana dahayse harrnee kinka kanse?’ kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","28","Agaa yisa aanantaam qanea ea ‘Woam wottseabee wodar pirdeabe haam hayaa hayne? Naa Gibth eam hanin deesondettsi ta iamaar deesanaa qaabaaw?’ hamayse Museam ki kupade. ");
INSERT INTO amf_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musear dhalqin ogoam yinin qansenka, gobate Miidiam peente barqate yivayse ki dooqade; ogotear naasi lamaa ki adhade. ");
INSERT INTO amf_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Muse peen ogote eedi lamaa kaysa leve kinin dooqonsa budonte, Siina dhukankal darante hatton kodonsa shaarinte nuunsa laabhinanka Barjosa gaana kina ki haapadhade. ");
INSERT INTO amf_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","32","Musear ogoam yinin haapenka targadhidine. Shedana gasante kinin theedenka, ‘Inta hasa eykena, Abraambee, Yisaaqbee, Yayqoobbesa Barjoane’ hamen Barjosa upsin ki qansade. Musear kurtumbhayse yinin gibazonna shedana damadehe. ");
INSERT INTO amf_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Barjoar ‘Hanin woyoono ranqo pee gaza konin dohonna, hasa roora dunngurinam bulaa! ");
INSERT INTO amf_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Gibth gidir dohon isa zarsinsa gaalenam gon i haapade; kenin gaalaate ilatenam inta qansayse keam dhacchana i nivade. Ya kote nivaa; inta haam Gibth peendar ida yittse’ kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Israveel eena Musena ‘Woam wottseabee wodar pirdeabe haam hayaa hayne?’ hamayse kiam ke bagade. Ko dahaannaar Barjo Museam ogo kodonte yeden nuunte kina haapadhaa Barjosa gaanaaka wottseabee worshamora buleabe hayayse kedar kiam ki yittsade. ");
INSERT INTO amf_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ea agaa Gibth peenbee, Ertera bazinbee, eedi lamaa kaysa leveka yekka darantebe tarshea yer waadadhaate Gibth peera keam bulayse ki entsade. ");
INSERT INTO amf_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Israveel eenana ‘Barjo yesa naanasa iira idettsi kikala qansayse eenna giyeam yena kida dhaase’ kena hamaa Musene. ");
INSERT INTO amf_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Darante bukayse dahaana wosa eykenabee Siina dhukandar kina giyaa Barjosa gaanaabesana kinka dahaa kidi Musene; lay dehen upsinam wona giyana tiyaa kidine. ");
INSERT INTO amf_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Wosa eykena kina ee hamana zagadehe; yisa woylaminkaar Gibth peendar maatana anngardhayse kiam ke bagade. ");
INSERT INTO amf_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aaronnaar ‘Gibth peera woam bulaa Musedar har yeskonam dhesattone; wosa birante yivada woam entsayna barjona wona ashkaa’ kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ogo wodanka ‘Wosa barjone’ hamayse ootodettsi maaton yer ashkayse machadhea marsha kina ke machade; yisa aaninka yinin ashkon yerinka ke wozadhade. ");
INSERT INTO amf_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Barjoar kekalanka ki edimade; cecinsa wanconana kenin goodimoadettsi keam ki garade. Ogonoar Barjokala qansayse eenna giyaynasa mathaapinte thaapadhoono ‘Yedi Israveel eenato, eedi lamaa kaysa leve darante qolla marshan yenin machoono inaw? ");
INSERT INTO amf_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tiyayse yenin yaayen Molooksa apalan ooninbee Repaan hambhen barjoasa eezinin kamsinbena yesa aaninka ashkayse yenin goodimayna yesa barjonane. Intaar Baabiloon peera os yeam ida oyte’ hamayse thaapadhidine. ");
INSERT INTO amf_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Wosa eykena darante Barjo kembesana kinka kinin dohonam tarja maatayno apalan onno kekal ko dahade; ogo apalan ooninam Barjo Musena kinin giyonbee kinin dhohon kamsindettsibe ko ashkadhade. ");
INSERT INTO amf_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Barjo kesa birantear kinin oytaana Barjoam dhesimina eenasa peenam kenin tiyon wodanka, wosa eykena ogo yinin tiyon apalan ooninam Iyaasobesana ogo raqinte ke arsade; Dawtsa wodanka yekkaar ogote ko dahade. ");
INSERT INTO amf_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawtaar Barjosa birante shawkadhanam haapayse, Yayqoob Barjoana ooni woysana kiam ki miskade. ");
INSERT INTO amf_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ko dahaannaar Barjona oonin woysaa Solomoonne. ");
INSERT INTO amf_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Yin ko dahaannaar Wuldara Sagea Barjo eedinin aanka woyson ooninte dooqehe. Ogonoar Barjokala qansayse eenna giyea kinin yin giyondettsi: ");
INSERT INTO amf_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Barjo yi giyna: “Cecino bitimayse inin dooqayno borkotonone; peenoar roon inin wodaynone. Ta keeda ina yenin woysayno onno hamin dohoonone? Inin ukunsayno ranqo hamin dohoonone? ");
INSERT INTO amf_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ko wulam inin ashkoono isa aankatayu?” kida hame’ hamayse ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Yedi qoocan woysayna eenato, yesa woylaminka Barjoam dhesiminabee giidhendar qaami wodiminabeto, yediar yesa eykenadettsi rooro wul Manpas Gazanam yeda jibbe. ");
INSERT INTO amf_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Yesa eykena Barjokala qansayse eenna giyaynasa kenin oytaama hayne? Kedi tipaa easa nivintanam birayse giyaynaam ke deesade; yedi taar agaa eam dembhina saskate imayse kiam ye dettsade. ");
INSERT INTO amf_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Yedi Barjosa gaananaka imbhon yigginam ye tiyade; ko dahaannaar koam tooleetene” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Yiwda peensa donzana dhalqin ogoam yinin qansenka Isthipaanoosdar yisa woylaminka kattsi wacimayse hamma ke gavade. ");
INSERT INTO amf_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kidiar Manpas Gazanka thoothayse tura cecinte kinin shedenka, Barjosa gobshinbee Barjosa mizaqimbar woyaa Yesusbeam haapayse, ");
INSERT INTO amf_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Marrato! Cecino bulimayse ko daaka, Eedi Naas Barjosa mizaqimbar ki woyaysaka haapite i dahade” ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kedi upsin yisa dheg hayayse ilataate qaaminaam yedayse wulatte Isthipaanoosdar ke dhaabhade. ");
INSERT INTO amf_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Katamaraar bulayse deesana seenika kiam paxan ke yedade. Kediar kisa iirimensa tarjana apalan yinnonam Sawl hambhea barsh kalaasa roon demente ke wodade. ");
INSERT INTO amf_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Seenika kiam kenin paxenka Isthipaanoos “Imbo Yesuso, isa sadanam tiyaa” hamayse ki miskade. ");
INSERT INTO amf_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ogoraar kumpurdhayse yin giyayse ki diyade: “Imbo, ogo kesa seesonam paydaabhode” hamayse upsi gebhika ki ilatade. ");
INSERT INTO amf_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Sawlaar Isthipaanoosam deesadhenka kembesana kinka ki wormade. Barjona goodimintaka wocchimbhayna eena Isthipaanoosam ke duukade; kattsi eepiar kina ke eepade. Agaa rooroaka Yerusaalem gidir dahaana Barjodar woylamin qajayna eenadar kattsi oytaydha ko dhaabhade; Kiristoos yisa tarjamonnante kinin yittsaana eena shidhaysaka, Barjodar woylamin qajayna eena wul Yiwda peenbee Sammaria peenbedar thar thar ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sawlaar Barjodar woylamin qajayna eenaam kaysana zagayse, Barjodar woylamin qajayna eena wulsa onnar ardayse annginabee maanabeam gochate dhaxin ooninte keam ki dhaskade. ");
INSERT INTO amf_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Thar thar hamayse yivaana Barjodar woylamin qajayna eenaar yinin yivon raqin wulir Kiristoossa dhacchintan upsinam eenna ke giyade. ");
INSERT INTO amf_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilbhoosaar Sammaria katamandar yivayse Barjoyn qadhaa Kiristoos goynsa kena giyte ki dahade. ");
INSERT INTO amf_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Eenaar Pilbhoossa dhalqinam yinin qansenbee kinin waadadhon tarshen yerinam yinin haapen wodankabe, kinin giyen upsinam woylam kalaaka payya hayayse ke qansade. ");
INSERT INTO amf_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Beeronaar upsin yisa dheg hayayse ilatada thoothin eendara ke utade; thoothi hajimonka malgimaana eenabee roon wobaana eenabe ke paashade. ");
INSERT INTO amf_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ogonante kataman ogote gebhi woza ko dahade. ");
INSERT INTO amf_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kataman ogote Simoon hambhea eedi kalaa ki dahade. Ea agaa katamante marsha hayaate Sammaria gidir dohon eenaam tarshite ki dahade; kidiar “Inta eedi gebhine” hamayse kida giye. ");
INSERT INTO amf_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Een wulsa iira likkanabee gembhabe “Gebhi Barjo kantan yisa dahaa ea kaane” hamada kinin giyenam payya hayayse keda qanse. ");
INSERT INTO amf_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Harrna hambhidianna, thoothi wodara yedayse marshanka tarshite kinin waadadhonnane. ");
INSERT INTO amf_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ko dahaannaar Pilbhoos Barjosa bitamonbee Yesus Kiristoos naabenbesa wozisen upsinam kinin giyonam qansayse kenin tiyon wodanka annginabee maanabe shiidhite ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simoon yintiar Barjodar woylamin qajayse shiidhayse Pilbhoosbesana kinka ki dahade; Pilbhoosin waadadhen kattsi tarshen yerinbee milkitinbeam yinin sheden wodanka kidi targadhite ki dahade. ");
INSERT INTO amf_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yerusaalem gidir dahaana Kiristoos yisa tarjamonnante kinin yittsaana eena Sammaria eena Barjosa upsinam kenin tiyonam qansayse Bhethiroosbee Wannisbeam kekal ke yittsade. ");
INSERT INTO amf_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Kediar kekal yinin nivon wodanka Manpas Gazanam kenin tiyoadettsi kena Barjoam ke miskade. ");
INSERT INTO amf_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Harrna hambhidianna, Sammaria eena Imbaa wontea Yesussa naabenka ke shiidhade; Manpas Gazano kesa eedi kaladar hattear hanchadehe. ");
INSERT INTO amf_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ogo wodanka Bhethiroosbee Wannisbe yisa aaninam eenadar ke wodade. Eenaar Manpas Gazanam ke tiyade. ");
INSERT INTO amf_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kiristoos yisa tarjamonnante kinin yittsaana aaninam yisa eenadar kenin wodenka Manpas Gazan imbhonam Simoon yinin haapenka, birre kena bavayse, ");
INSERT INTO amf_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Intaar isa aaninam inin wodayna wul Manpas Gazanam kenin tiyoadettsi hayamon koam inaar imee” ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Bhethiroosaar kina yin ki giyade: “Barjosa imintonam birreka shanana hanin bhocchonna, hambee hasa birrenbe kinka kayee. ");
INSERT INTO amf_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Hasa woylamino Barjo birante tipa konin dahaamonna, ko waadimante waadadhana hasa raq qolehe. ");
INSERT INTO amf_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ta keeda hasa siyon qaabon koam garayse Barjodar maataa; way hasa woylaminsa qaabonam hana garea ki hanna, Barjoam miskaa. ");
INSERT INTO amf_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Harrna hambhidianna, ya gebhi woogintoka hanin thoothonbee seesoka dhaxadhaa hanin dohonbeam ida haape” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoonaar yi giyna: “Yenin giyon wulra yer kalaar idar yeskoamadettsi yedi ina Barjoam miskee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Bhethiroosbee Wannisbe yinin tarjonbee Imbaa wontea Yesussa upsinam eenana yinin giyonbesa budonte, Sammaria peensa gurdana thoothinar Barjosa dhacchintan upsinam eenana giyada Yerusaalem katamandar ke maatade. ");
INSERT INTO amf_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Barjosa gaana Pilbhoosna “Dhaabhayse hayn utensa mizaqimbar yivayse Yerusaalemra daran goynka Gaaza katamandar yiven goynka yivaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Kidiar dhaabhayse ki yivade. Marrato! Eedi kalaa Tobbhea peen ea bua Barjona goodimana Yerusaalemdar birayse ki yivade. Ea agaa Yindeke hambhen Tobbhea peen mayn bitinsa yer wulam wottsea hayamoysa dahaa eedine. ");
INSERT INTO amf_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Kidiar Yerusaalemra yinin maatenka sargalladar dooqayse Barjokala qansayse eenna giyea Isias mathaapinam kida nabbabe. ");
INSERT INTO amf_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Manpas Gazanoar Pilbhoosna “Ogo sargallankal theedaa” kina ko hamade. ");
INSERT INTO amf_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pilbhoosaar gobate yivayse, Barjokala qansayse eenna giyea Isias mathaapinam kinin nabbabenka qansayse, eana “Ta hanin nabbabayno hana arda ko ardo?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Kidiar “Ina giyea eedi qolma hamin ko ina arde?” ki hamade. Pir Pilbhoosna “Sargallandar utayse ikal dooqaa” hamayse kiam ki miskade. ");
INSERT INTO amf_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Tobbhea ear kinin nabbabayno ranqo yin giyaynone: “Kidi taxana qandhea yaatidettsine; sitin taxadhenka lay hamea yaatidettsi kidi giyana apo buladehe. ");
INSERT INTO amf_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kiam ooshinsayse, tipa pirdiar kina pirdadhadehe; peendar sadaka kinin dahayno konin maqonna, kisa adhadhinsa giyana damea hayne?” koda hame. ");
INSERT INTO amf_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tobbhea ear Pilbhoosna “Barjokala qansayse eenna giyea ogoam kinin giyoono haynane? Yinnon metensamoo? Eedi absaw? Ina giyaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Pilbhoosaar kinin nabbabon ogosa iira yedayse Yesus goynsa dhacchintan upsinam kina ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Goynka kenin yivenkaar noqo yinin dohon raqante ke yeskade. Tobbhea ear “Shedaa! Kote noqo daane; kosa iir inin shiidhoamadettsi iam marea yer daaw?” ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pilbhoosaar “Gonin hamon woylaminka Barjodar woylam ha qajidianna, shiidhana damaada dame” kina ki hamade. Tobbhea ear “Yesus Kiristoos Barjo Naas kinin dohonam dhesayse inta kidar woylam qajayda qaje” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tobbhea ea kenin yiven sargallanam woysadhoadettsi ki giyade. Ogora Pilbhoosbee Tobbhea eabe kinka noqonte ardayse Pilbhoos eam ki shivade. ");
INSERT INTO amf_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Noqora ke utaysaka saana Barjosa Manpasino Pilbhoosam raq abdar ko tiyade. Tobbhea ear wozadhaate goynka ki yivade; Pilbhoosam lansi haapadehe. ");
INSERT INTO amf_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pilbhoosaar Azothoos katamante ki haapadhade; Qesaaria katamante yinin nivenka yekka, kataman wulir yivaate Barjosa dhacchintan upsinam ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sawl Imbaa wontea Yesusdar woylamin qajayna eenaam deesota akar keam kurtunsada gudullasa gebhaakal ki yivade. ");
INSERT INTO amf_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","“Yesusdar woylamin qajayna eena annginabee maanabesa inin haapaanaam dhaxayse keam Yerusaalemdar bavate inin nivoadettsi, Demasqo gidir Ayiwd eenasa bukin ranqaam wottsayna eenana inin imea warqat thaapate ina imaa” hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Yivada Demasqo gidir yeskana kinin hayenka, kisa gasante ki bhocchima cecira bhalqantayno shaaka ko shaakade. ");
INSERT INTO amf_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Peendar ki dhambade. Ogora “Sawl, Sawl! Harrnaa iam oyte?” hamea upsi ki qansade. ");
INSERT INTO amf_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sawlaar “Imbo, ya hayne?” ki hamade. Kidiar “Inta hanin oytea Yesusne. ");
INSERT INTO amf_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ta keeda dhaabhayse katamandar yivaa. Waadadhan haam zaskenam hana giidha ko giidhe” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sawlbesana yivayna eena upsinam qansaate hayyeamaar yinin haapaamonna, lay hamayse ke woyade. ");
INSERT INTO amf_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sawlaar yinin dhamborra ki dhaabhade; aapinin kisa pak hamenka haapana damadehe; eenoar kisa aaninam yedayse entsate Demasqo katamante kiam ke yeskisade. ");
INSERT INTO amf_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Rooro makkamna aapino kisa shedana damadehe; ogo wodanka kidi itsimabee wucimabe ki kappade. ");
INSERT INTO amf_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Demasqo katamante Hanania hambhea Barjodar woylamin qajea eedi kalaa ki dahade. Kidiar Barjoyn kina dhohon shedintonam kinin haapenka, Imbaa wontea “Hanania” hamayse kiam ki eelade. Kidiar “Imbo, inta kayne” ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Imbaa wontear “Dhaabhayse Gaz hambhen goynka yivaa; ogote Yiwda ooninte Sawl hambhea Therses eam zagaa. Kidi ta Barjoam miskite ki dahade. ");
INSERT INTO amf_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Sawlsa aapino pir konin shedoadettsi Hanania hambhea ea kikal ardayse aaninam kidar kinin wodenka, Barjokala shedintonam ki haapade” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Hananiar yin ki giyade: “Imbo, ea kaa Yerusaalem gidir dohon hasa een gazandar yer siya kinin hayonam thoothin eenkalanka inta qansidine. ");
INSERT INTO amf_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Kotear hasa naabenam eelayna wulam dhaxota gudullasa hayonakalanka hayamo tiydine” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Imbaa wontear Hananiana yin ki giyade: “Kidi Ayiwdtay hamma eenabee, peensa binnabee, Israveel eenabena isa naabenam kinin dhettsoadettsi inin kamaa ea kinin dohonna kikal yivaa! ");
INSERT INTO amf_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Isa naabenna hamayse hamaddha gaale haapan kiam konin zaskenam inta kina dhaayda dhee” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ogonante Hanania yivayse Sawlin dohon ooninte ki ardade. Aaninam yisa Sawldar wodayse, “Imbanaasa Sawlo, kote hanin nivenka goynte hana haapadhaa Imbaa wontea Yesus tapir aapino hasa konin shedoadettsibee Manpas Gazanka hanin thoothoadettsibe iam hakal ki nittsade” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Saanawa opiridettsi yer kisa aapira ko wavade. Ogora kisa aapinoar ko haapade; dhaabhaysear shiidhimbhe ki shiidhimbhade; ");
INSERT INTO amf_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","galaar itsayse ki wocchimbhade. Sawl Demasqo katamante dahaana Barjodar woylamin qajayna eenabesana kinka likka roorona ki dooqade. ");
INSERT INTO amf_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Saana Sawl Yesus goynka “Kidi Barjo Naasane” hamayse Ayiwd eenasa bukin ranqar giyan ki yedade. ");
INSERT INTO amf_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kisa dhalqinam qansaana eena wulaar “Ea kaa Yerusaalem gidir naaben ogoam eelayna eenaam oytayeatayu? Ta kote kinin nivoono keam dhaxayse gudullasa hayonakal bavate yivotatayu?” hamada targadhite ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sawlaar wocchimbhada ki yivade. Yesus Barjoyn qadhaa Kiristoos gon kinin dohonam kinin giyenka Demasqo gidir dahaana Ayiwd eena malsi kina maasana damadehe. ");
INSERT INTO amf_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Thoothi roorosa budonte, Ayiwd eena Sawlam deesana kinka ke dhalqade; ");
INSERT INTO amf_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","kidiar kesa qaabonam dhesidine. Kediar kiam deesota sootinbee rooronbe katamansa kerram toolite ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ko dahaannaar kisa paanan yivayna eena sootinka sharankonte kiam wodayse seenika woysadhon kerminsa maskootinka hanchayse kiam ke yittsade. ");
INSERT INTO amf_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sawl Yerusaalem gidir yinin yeskon wodanka Barjodar woylamin qajayna eenabesana kinka doota ki zagade; kedi wulaar Barjodar woylamin kinin qajonam gonne hamayse yinin tiyaamonna kiam ke kurtumbhade. ");
INSERT INTO amf_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnabaasaar Kiristoos yisa tarjamonnante kinin yittsaana eenakal Sawlam yinka entsayse Imbaa wontea Yesus goynte hamin kina kinin haapadhonbee, kina kinin giyonbee, Demasqo gidir Sawl Yesussa naabenka hamin wocchimbhayse kinin giyenbeam kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ogonante Sawl kembesana kinka maatayse Yerusaalem gidir may ki yaayade. Imbaa wontea Yesussa naabenkaar kurtumbhima eenna giyte ki dahade. ");
INSERT INTO amf_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Girik aponka dhalqayna Ayiwd eena kinka dhalqada kembete kinka ki palimade; kediar kiam deesana ke zagade. ");
INSERT INTO amf_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Barjodar woylamin qajayna eenaar ogoam yinin dhesenka, Qesaaria katamante kiam entsate yivayse Therses katamandar kiam ke yittsade. ");
INSERT INTO amf_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Yiwda peenbee, Galila peenbee, Sammaria peen wulber dahaana Barjodar woylamin qajayna eena payyamoka ke dooqade; kediar ke kantimbhade; Barjoam gobshada Manpas Gazanka wocchimbhada ke thoothade. ");
INSERT INTO amf_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Bhethiroos igina peena wulir yaayada Liidar dahaana Barjodar woylamin qajayna eenakal ki yivade. ");
INSERT INTO amf_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Raqin ogotear leve lankayna burqoka malgimayse wodhaa Eniya hambhea eam ki haapade. ");
INSERT INTO amf_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Bhethiroosaar “Eniya, Yesus Kiristoos haam pacchidine; dhaabhayse hanin wodhon eebhenam maasaa!” kina ki hamade. Kidi saanawa ki dhaabhade. ");
INSERT INTO amf_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Liidabee Saaroonaber dohoono eeno wul Eniyaam shedayse Imbaa wontea Yesusdar woylamin ko qajade. ");
INSERT INTO amf_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Iyoobhe katamantear Thabita hambhayno Barjodar woylamin qajayno ko dahade; kosa naabensa bulino Girik peen aponka Dorqa hamintane. Kodi rooro wul payya yer hayaynobee qambhinanaar iminto imaynobe ko dahade. ");
INSERT INTO amf_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ogo wodanka kodi hajadhayse ko diyade. Kediar kosa leesinam shivayse ooninsa zulonte woysadhon ooninte koam ke wodade. ");
INSERT INTO amf_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Liida Iyoobhesa gasante theedi yinin dohonna, Iyoobhe gidir dahaana Barjodar woylamin qajayna eena Bhethiroos Liida gidir kinin dohonam qansayse, “Bannzo! Kappima wokal nivaa” hamayse eena lamaanaam kidar ke yittsade. ");
INSERT INTO amf_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Bhethiroosaar dhaabhayse kembesana kinka ki nivade; ke yeskaysaka ooninsa zulonte woysadhon ooninte kiam entsate ke utade. Maana qambhina wul Dorqa sadanka yinin dohon wodanka kena konin waadadhoono qamushinabee apallabeam dhahaate Bhethiroos birante woyayse keda eepe. ");
INSERT INTO amf_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Bhethiroosaar eena wulam mayanka keam bulayse kumpurdhayse Barjoam ki miskade. Leesindar wal hamayse, “Thabita, dhaabhaa” kona ki hamade; kosa aapin pak hamaysaka Bhethiroosamaar shedayse dhaabhate ko dooqade. ");
INSERT INTO amf_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Kidiar kosa aaninam yedate koam ki dhaasade; Barjodar woylamin qajaynabee maana qambhinabeam yikal eelayse sadaka kesa birante koam ki woysade. ");
INSERT INTO amf_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ogono yerroar Iyoobhe gidir dohon een wulna ko dhesimade; thoothino eenoar Imbaa wontea Yesusdar woylamin ko qajade. ");
INSERT INTO amf_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Bhethiroosaar Simoon hambhea eebhen kuccheakal thoothi roorona Iyoobhe gidir ki dooqade. ");
INSERT INTO amf_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Qesaaria katamante Qorneloos hambhea eedi kalaa ki dahade. Kidiar “Thaaliansa banqin eena” hambhaynasa mato alaqane. ");
INSERT INTO amf_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kidiar Barjona goodimaate wocchimbheane; yimbee oonin eena yinnabe Barjoam kurtumbhaynane; qambhinana iminto imeabee Barjoam rooro wul miskeabene. ");
INSERT INTO amf_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Rooro kalaa savaat sal maataysaka Barjosa gaana kikal kinin ardenbee “Qorneloos” hamayse kiam kinin eelenbeka Barjoyn kina dhohon shedintonka may kiam ki haapade. ");
INSERT INTO amf_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Qorneloosaar Barjosa gaanaam dhari kiam shedaate targadhayse, “Imbo, hare?” ki hamade. Barjosa gaanaar kina yin ki giyade: “Barjoam hanin miskenbee qambhinana hanin imayno hasa imintonbeam Barjo birante hana bhocchadhidine. ");
INSERT INTO amf_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Taar Iyoobhe gidir eenaam yittsayse Bhethiroos hambhea Simoonam elsaa. ");
INSERT INTO amf_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Kidi ta bazinsa gasante dahaa eebhen kucchea Simoon ooninte chocchi maatayse ki dahade” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ogoam giyaa gaanaar kikalanka edimayse ki yivaysaka, Qorneloos yisa waadimaynasa lamaanabee kimbesana kinka dahaana banqin eenabera Barjona goodimaate wocchimbhea kalaam eelayse, ");
INSERT INTO amf_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","yer wulam kena yinin giyonsa budonte, Iyoobhe gidir keam ki yittsade. ");
INSERT INTO amf_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kina hamon kenin yivenka katamante ke theedaysaka, savaat lax maatenka Bhethiroos Barjoam miskota ooninsa zulonte ki utade. ");
INSERT INTO amf_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ogotear daaqardhayse kummana ki zagade; galan akar ashkadhenka Barjoyn kina dhohon shedintonam ki haapade. ");
INSERT INTO amf_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kinin haapoono shedintonoar cecin bulimaka gasana oynnar yedadhoono apala gebhidettsino peendar konin hanchenam ki haapade. ");
INSERT INTO amf_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ogo apalante rooysa oydi dahaana wulbee, iinka peendar gochimayna yerrabee, cecindar pillayna aptinabeam ki haapade. ");
INSERT INTO amf_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","“Bhethirooso, dhaabhayse igina yerram taxayse itsaa” hamea upsi kikal ko nivade. ");
INSERT INTO amf_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Bhethiroosaar “Imbo, yintehe; inta payyatay hamon yerin qaysinam itsayse dhesattine” ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Taar lansi “Barjoyn gazinsonam ya ‘Qaysine’ hamaabhode!” hamea upsi kikal ko nivade. ");
INSERT INTO amf_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ogono yerroar makkam goyt kina yinin haapadhonsa budonte, saanawa apaladettsinam tura cecindar ko tiidhade. ");
INSERT INTO amf_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Bhethiroos “Inin shedonsa bulino har ko doo?” hante qaabada ki daaka, marrato! Qorneloosin keam yittsaana eena Simoonsa oonin oysate kisa mayan nivayse kerindar ke woyade. ");
INSERT INTO amf_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Kediar eelayse, “Bhethiroos hambhea Simoon chocchi maatayse kinin dohoono kotew?” hamayse ke oysade. ");
INSERT INTO amf_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Bhethiroosaar Barjoyn kina dhohon shedintonam qaabada ki daaka, Manpas Gazano “Shedaa! Eedi makkam haam zaga ke zage. ");
INSERT INTO amf_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Dhaabhayse hanchaa; inin keam nittsonna qothimima kembesana kinka yivaa!” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Bhethiroosaar eenakal hanchayse, “Marrato! Yenin zagea ea intane; yenin nivoono harrnane?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Kediar “Wonin nivoono mato alaqa Qornelooskalankane. Kidiar tipa eabee Barjoamaar kurtumbheabene; pir Ayiwd eeno wul kina koda tarje. Haam yisa ooninte elsayse hanin giyenam kinin qansoadettsi Barjosa gaana gazaa kina ki giyade” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Bhethiroosaar ooninte keam arsayse keam ki wottsade. Kina hamon dhaabhayse kembesana kinka ki yivade; Iyoobhe gidir dahaana Barjodar woylamin qajayna eenasa waani waani eena kimbesana kinka ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ogosa kina hamon Qesaaria katama ke yeskade; Qorneloosaar yisa muldhanabee yisa yettsinabeam yikal eelayse Bhethiroosam kaalite ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Bhethiroos nivayse ooninte kinin ardenka, Qorneloos kikal theedayse kisa roondar dhambayse kina ki goodimade. ");
INSERT INTO amf_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Bhethiroosaar “Dhaabhaa! Intaar hadettsi eedine” hamayse kiam ki dhaasade. ");
INSERT INTO amf_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kimbesana kinka dhalqada ooninte ki ardade. Thoothino eenoar bukayse ke daaka keam shedayse, ");
INSERT INTO amf_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","yin kena ki giyade: “Ayiwd eena Ayiwdtay hamma eenabesana kinka kalaa kenin dohonbee kesa ooninte ardintabe wosa yiggin goynka zaskiminam yedi yemal dheseeda dhese; ko dahaannaar hayyeamaar ‘Gazimbhaamane’ way ‘Qaysine’ inin hamoamadettsi Barjo ina dhaydine. ");
INSERT INTO amf_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ogonante iam yenin eelenka palime qolma yekal i nivade; ta harrna iam yenin eelonam dhesana ida zage” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Qorneloosaar yin ki giyade: “Kina rooro oydisa birayse kaa wodaaka savaat salka oonin innonte Barjoam miskite i dahade. Marrato! Bhalqantidettsi maaten apala qaadhaa eedi kalaa isa birante ki woyade. ");
INSERT INTO amf_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘Qornelooso, Barjo hasa miskenam qansidine; qambhinana hanin imen hasa imintonamaar bhocchidine. ");
INSERT INTO amf_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ta keeda Iyoobhe katamandar eedi yittsayse Bhethiroos hambhea Simoonam elsaa. Kidi bazinsa aponte dohon eebhen kucchea Simoonsa ooninte chocchi maatayse ki dahade’ ina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ogonante saana upsi hadar i yittsade; yaar ikal hanin nivenka payyaa hayade. Ta keeda Barjo hana kinin giyon wulam qansana wodi wul Barjo birante kote bukayse toolite wo dahade” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Bhethiroos yin ki giyade: “Barjo eedisa woti shedayse waadadhima kinin dohonam taaki gon inta dhesidine. ");
INSERT INTO amf_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Pee hamote dahaa eedi yi dahaakaar Barjoam kurtumbhea tipa hayea ki hanna, Barjo kiam kida tiye. ");
INSERT INTO amf_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Barjo ‘Yesus Kiristoosbar payyamono koda haapadhe’ hamayse dhacchintan upsinam Israveel eenana ki yittsade. Yesus Kiristoos een wulsa Imbaane. Een wulsa Imbaa maataa Yesus Kiristoosbar Israveel eenana Barjoyn yittsoono payyansa dhacchintan upsino konone. ");
INSERT INTO amf_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Wannisin giyon shiidhimensa budonte, Galila peera yedayse, Yiwda peen wulir dohon yerinam yedi dheseeda dhese. ");
INSERT INTO amf_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ogonoar Barjo Naazret peen ea Yesusam Manpas Gazanka kiam kinin qadhonbee kantan kina kinin imonbeam dheseeda dhese. Barjoar kimbesana kinka kinin dohonna, Yesus payya yer hayadabee Seethaanin yisa kantanka galshayna eena wulam pacchadabe ki yaayade. ");
INSERT INTO amf_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Ayiwd eenasa peentebee Yerusaalem katamantebe kinin hayon yer wul goynka wodi tarjanane. Ogora masqalindar ziitayse kiam ke deesade. ");
INSERT INTO amf_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Barjo makkansoa rooroaka diira kiam ki dhaasade; may kinin haapadhoadettsi ki hayade. ");
INSERT INTO amf_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","May kinin haapadhoonoar birayse Barjoyn kamaana tarjana eenanane, een wulnatehe; igina tarjana diira kinin dhaabhonsa budonte kimbesana kinka itsaanabee wucaanabe wodine. ");
INSERT INTO amf_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Kisa upsinam eenna wonin giyoadettsi, pir Yesus sadanka dahaana eenabee diyaana eenabedar kinin pirdoadettsi Barjoyn kiam wodaa kinin maatonam wonin tarjoadettsi wona ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Kidar woylamin qajea wul kisa naabenka seesonsa garintonam kinin haapendettsi Barjokala qansayse eenna giyayna eena wul kina ke tarjade” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Bhethiroos ogoam giyte ki daaka, kinin giyen upsinam qansayna eena wuldar Manpas Gazano ko hanchade. ");
INSERT INTO amf_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Bhethiroosbesana nivaana Barjodar woylamin qajayna Ayiwd eena Barjo Ayiwdtay hamma eenana Manpas Gazanam kinin imonam yinin haapenka kedi targadhidine. ");
INSERT INTO amf_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Manpas Gazanam kena imbhonam kenin dhesoono Ayiwdtay hamma eena apo abka kenin giyenbee Barjoam kenin gobshenbeam yinin qansonnane. Ogo wodanka Bhethiroos ");
INSERT INTO amf_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Igina eena wodettsi Manpas Gazanam kedi tiydine. Ta keeda noqoka kenin shiidhimbhoamadettsi hayne keam marea?” ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ogonante Yesus Kiristoossa naabenka kenin shiidhimbhoadettsi ki giyade. Ogosa budonte Bhethiroos kembesana kinka likka rooro kinin dooqoadettsi kiam ke miskade. ");
INSERT INTO amf_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ayiwdtay hamma eena Barjosa upsinam qansayse kenin tiyonam Yiwda peente dahaana Kiristoos yisa tarjamonnante kinin yittsaana eenabee kidar woylamin qajaana waani eenabe ke qansade. ");
INSERT INTO amf_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Bhethiroos Yerusaalem ki yivaysaka qaaman taxadhen goyn tipisayna Barjodar woylamin qajayna kimbesana ke palimade. ");
INSERT INTO amf_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Ya qaaman taxadhamma eenasa ooninte ardayse kembesana kinka harrnaa kummaa?” hamayse kina ke dhiidhimade. ");
INSERT INTO amf_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Bhethiroosaar birara yedayse yer wulam yin ki giyade: ");
INSERT INTO amf_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Inta Iyoobhe katamante Barjoam inin miskenka Barjoyn ina dhohon shedintonka inin haapenka, gasana oynnar yedadhoono apala gebhidettsino cecira hanchayse ikal ko nivade. ");
INSERT INTO amf_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Koamaar bhocchika inin shedenka, roo oydika dahaana qollabee, dammabee, iinka peendar gochimayna yerrabee, cecindar pillayna aptinabeam i haapade. ");
INSERT INTO amf_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","‘Bhethirooso, dhaabhayse igina yerraam taxayse itsaa’ hamayno upsino ina ko qansimade. ");
INSERT INTO amf_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Intaar ‘Imbo, yintehe! Payyatay hamon yerin qaysinam itsate dhesattine’ i hamade. ");
INSERT INTO amf_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Tapir lansi ‘Barjoyn gazinsonam ya “Qaysine” hamaabhode!’ hamea upsi cecira ko nivade. ");
INSERT INTO amf_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ogono yerro makkam goyt yin konin haapadhonsa budonte, apaladettsino wul tura cecindar ko tiidhade. ");
INSERT INTO amf_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Marrato! Ogora kappima Qesaaria katamara eedi makkam waani keam ikal nittsadhaysaka wonin dohon oonindar ke yeskade. ");
INSERT INTO amf_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Manpas Gazanoar qothimima kembesana kinka inin yivoadettsi ina ko giyade; igina laxna imbanaana imbesana kinka ke yivade. Qorneloos hambhea easa ooninte wo ardade. ");
INSERT INTO amf_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kidiar ‘Barjosa gaana isa ooninsa iinte woyayse ki daaka kiam i haapade. Barjosa gaanaar ina “Iyoobhe gidir eedi yittsayse Bhethiroos hambhea Simoonam elsaa. ");
INSERT INTO amf_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Bhethiroosaar hambee hasa oonin eena wulbe yenin dhaqensa upsi hana kida giye” ki hamade’ hamayse Qorneloos wona ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Intaar giyan inin yedenka, Manpas Gazano birayse wodar yinin hanchondettsi kedarar ko hanchade. ");
INSERT INTO amf_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","‘Wannis eenaam noqoka ki shivade; yedi Manpas Gazanka yeda shiidhe’ hamayse Imbaa wontea Yesusin giyoono upsino bhoq ina ko hamade. ");
INSERT INTO amf_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ta keeda Imbaa wontea Yesus Kiristoosdar woylamin qajaana wona Barjoyn imon imintonam kenaar imidi ki hanna, Barjosa qaabonam marana damea inta hayne?” ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Eenaar ogoam yinin qansen wodanka lay ke hamade. “Ta keeda Barjo Ayiwdtay hamma eenana seeson waadimanam garayse kidar maatayse sada kenin haapoadettsi kena imidine” hamayse Barjoam ke gobshade. ");
INSERT INTO amf_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Isthipaanoos deesadhaysaka dhaabhon oytaydhan goynka Barjodar woylamin qajayna eena Pinqe peenbee, Qobhiroos peenbee, Anthokia katamanbeka yekka ke yivade. Kiristoossa dhacchintan upsinamaar Ayiwd eenana bish ke giyade; waani eenna giyadehe. ");
INSERT INTO amf_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ko dahaannaar kesa iira Qobhiroosbee Qerenabera nivaana waani waani eena Anthokia kataman yivayse Ayiwdtay hamma eenana Imbaa wontea Yesussa dhacchintan upsinam kena ke giyade. ");
INSERT INTO amf_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Barjoar keam kelshite ki dahade; thoothino eenoar Imbaa wontea Yesusdar woylamin qajayse Barjodar ke maatade. ");
INSERT INTO amf_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Yerusaalem gidir dahaana Barjodar woylamin qajayna eena ogo kesa dhalqinam yinin qansenka, Barnabaasam Anthokia katamandar ke yittsade. ");
INSERT INTO amf_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Kidiar yivayse Barjo yisa sunin imintonka kinin waadadhonam yinin haapenka ki wozadhade. Barnabaas Manpas Gazanbee Barjodar woylamin qajintanbeyn thoothaa payya eedi kinin dohonna, eena wul woylaminka yisa wocchimbhayse Imbaa wontea Yesusdar woylam qajaate kenin doadettsi keam ki kiilade. Ogonante thoothino eenoar Imbaa wontea Yesusdar woylam ko qajade. ");
INSERT INTO amf_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ogosa budonte, Barnabaas Sawlam zagana Therses katamandar ki yivade. ");
INSERT INTO amf_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kiam yinin haapenka Anthokia katamante entsate ki nivade; ogote dahaana Barjodar woylamin qajayna eenabesana kinka bukayse leve kalaana thoothina eenaam ke dhettsade. Barjodar woylamin qajayna eenaam “Kiristiyan” keam hambhoono birayse Anthokia katamantene. ");
INSERT INTO amf_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ogo wodanka Barjokala qansayse eenna giyayna eena Yerusaalemra Anthokia katamandar ke nivade. ");
INSERT INTO amf_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Kesa shaarira Agaabos hambhea ea dhaabhayse peen wuldar gebhi basho nivenam Manpas Gazano kina dhahaysaka hamota dohonam ki giyade; ogono daaqinoar Roome peen Bitaa Qelawdoos wodanka ko dahade. ");
INSERT INTO amf_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ogonante Barjodar woylamin qajayna eena wul yinin damaadettsi yisa birre bulayse Yiwda peente dahaana imbaanaanana yittsana ke qaabade. ");
INSERT INTO amf_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Birrenamaar bulayse Barnabaasbee Sawlbesa aaninka Yiwda peente dahaana Barjodar woylamin qajayna eenasa donzanana ke yittsade. ");
INSERT INTO amf_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ogo wodanka Bitaa Herodis Barjodar woylamin qajayna eena waani waaniam oytan ki yedade. ");
INSERT INTO amf_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Wannissa indanaasa Yayqoobamaar halpaka kiam ki dettsade. ");
INSERT INTO amf_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ogono yerro Ayiwd eenaam konin wozisonam yinin haapenka Bhethiroosamaar ki yettsade. Ogonoar yin konin maatoono Ayiwd eenasa irshonin qolmin balashan kenin itsen Paasikan rooroakane. ");
INSERT INTO amf_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bhethiroosam yettsayse dhaxin ooninte kiam ki dhaskade; Paasikan rooroasa budonte eensa birante kidar pirdota qaabayse eedi oydi oydi maatayse kiam kenin tooloadettsi tabhi lax poolisanana kiam ki imade. ");
INSERT INTO amf_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ogonante Bhethiroosam dhaxin ooninte dhaskayse kida toldhe; ko dahaannaar Barjodar woylamin qajayna eena kina Barjoam wocchimbhayse miskaate ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herodis Bhethiroosam eensa birante pirdota kinin qaabon wodanka, sootin ogo sansala lamaaka kiam dhaskayse poolisana lamaanasa shaarinte raatayse ki dahade; waani poolisanaar dhaxin ooninsa kerinam keda toole. ");
INSERT INTO amf_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Marrato! Barjosa gaana dhesadhima ki haapadhade; Bhethiroosin dohon ooninsa iinte shaaka ko shaakade. Barjosa gaanaar Bhethiroossa demenam qanate dhaasayse, “Saana dhaabhaa!” kina ki hamade. Ogo wodanka sansalloar kisa aanira ko wavade. ");
INSERT INTO amf_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Gaanaar “Hasa apalanam dhaximbhaa; dunngurinamaar roonte arsaa” kina ki hamade. Bhethiroosaar kina giidhondettsi ki hayade. Gaanaar pir “Hasa apalan qaadhaa; isa paanan nivaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Bhethiroosaar utayse kisa paanan ki yivade. Barjoyn kina dhohon shedintonka kinin haapaa kina ko maatade; Barjosa gaana hayayno yer wul gon yer kina maatadehe. ");
INSERT INTO amf_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Biron kerin tooleabee lanson kerin tooleabekala sagayse katamandar uten anngamon kerinkal ke yeskade. Kerroar eedi kaamima yinti bulmaysaka utayse goyti kallonka ke yivade; saanawa Barjosa gaana Bhethirooskalanka edimayse ki yivade. ");
INSERT INTO amf_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Bhethiroosaar maasayse kinin bhocchenka, “Barjo yisa gaanaam ikal nittsayse Herodissa aanirabee Ayiwd eena kenin toolen yerin wulbera iam kinin dhacchonam ta gon inta dhesidine” ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Yinin bhocchon wodanka, Marqoos hambhea Wannissa indan Mayriyam oonindar ki yivade; ogote thoothino eeno bukayse Barjoam miskite ko dahade. ");
INSERT INTO amf_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Bhethiroosaar mayan kerinam kinin kokkenka Rooda hambhayno waadima maa kallo kidi hay kinin dohonam dhesana kerindar ko nivade. ");
INSERT INTO amf_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Bhethiroossa upsinam yinin dhesenka, yisa wozanka dhaabhoono kerinam bulma gobaka ooninte ardayse, “Bhethiroos kerinte nivayse woydine” hamayse kena ko giyade. ");
INSERT INTO amf_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Kediar “Ya bardhidine” kona ke hamade. Kodiar “Gon kidine” hamaate kekal paliman ko yedade. Kediar “Kisa shiponone” ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Bhethiroosaar kerinam kokkaate ki dahade; kediar kerinam bulayse kiam yinin haapenka targadhidine. ");
INSERT INTO amf_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Bhethiroosaar aanka lay hamee hamayse Barjo dhaxin oonira hamin kinin bulonam kena giyayse, “Koam Yayqoobbee Barjodar woylamin qajaana waanibena giyee” kena ki hamade. Ogora kekalanka edimayse raq abdar ki yivade. ");
INSERT INTO amf_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Peen sedhaysaka burin, “Bhethiroosam hare bavate yivoono?” hamayse poolisana shaarinte goore gebhi ko dhaabhade. ");
INSERT INTO amf_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Bitaa Herodisaar Bhethiroosam zagayse yinin bashadhenka dhaxin ooninam toolayna eenaam marmarayse kenin deesadhoadettsi ki giyade. Ogoraar Herodis Yiwda peera Qesaaria katamandar yivayse ki dooqade. ");
INSERT INTO amf_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodis Thiroosbee Sidoona eenabedar kattsi wacimidine. Kediar kinka kalaa maatayse bitaasa ooninam wottsea Bilasthoos nivayse keam kinin kelshoadettsi miskayse bitaakal qaashimota ke oysade. Ogoam kenin yin hayoono kesa galan kenin haapayno bitaayn wottsen peera konin dohonnane. ");
INSERT INTO amf_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Aanin qunthadhaa rooroaka Bitaa Herodis bitamon apalan qaadhayse bitamon borkotondar dooqayse eenna dhalq giyan ki yedade. ");
INSERT INTO amf_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Eenoar “Kono barjosa upsine, eedi upsitehe” hamayse upsi gebhika ilatan ko yedade. ");
INSERT INTO amf_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Herodis Barjoam gobshima kinin garonna, saana Barjosa gaana kiam ki cavade; ogora kisa bishin qaydhaysakaar ki diyade. ");
INSERT INTO amf_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Barjosa upsino gebhaatebee thoothaatebe ko yivade. ");
INSERT INTO amf_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabaasbee Sawlbe keam nittsadhon waadiman yisa macchayse Yerusaalemra Anthokiadar ke maatade; Marqoos hambhea Wannisamaar yinka entsate ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Anthokia gidir dohon misken ooninte Barjokala qansayse eenna giyaynabee eenaam dhettsaynabe ke dahade; kediar Barnabaasbee, Thiya hambhea Simoonbee, Qerena peen ea Lukiyoosbee, peen wottsea Herodisbesana kinka gebhaa Minahebee, Sawlbene. ");
INSERT INTO amf_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Barjodar woylamin qajaana eena kenin goodimenkabee itsima Barjoam kenin miskenkabe, Manpas Gazano “Barnabaasbee Sawlbeam inin eelon waadimanna ina keam edee” ko hamade. ");
INSERT INTO amf_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ogo wodanka itsima Barjoam miskayse aaninam yisa kedar kenin wodonsa budonte, keam ke yittsade. ");
INSERT INTO amf_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnabaasbee Sawlbeam Manpas Gazano keam yittsaysaka Selewqia kataman ke yivade; ogoraar bazindara sagadhen gonngalante ardayse Qobhiroos peendar ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ogote Silmaana katamante yinin yeskenka Ayiwd eenasa bukin ranqar ardayse Barjosa upsinam giyte ke dahade; Wannisaar keam kelshite ki dahade. ");
INSERT INTO amf_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Qobhiroos peensa gasara yedayse macchin Bhapu kataman kenin yesken wodanka, Baryesus hambhea Ayiwd eenasa eedi mooro kalaam ke haapade. Kidiar buudamoka “Barjokala qansayse eenna inta giyeane” hameane. ");
INSERT INTO amf_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Kidiar qaabeysa dahaa Sargiyoos Bhawloos hambhea peen wottseakal ki dahade. Sargiyoos Bhawloosaar Barnabaasbee Sawlbeam eelayse Barjosa upsinam qansota ki zagade. ");
INSERT INTO amf_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ko dahaannaar Girik peen aponka “Elmaas” hamayse eldhea mooroa ea Baryesus peen wottsea Barjodar woylamin kinin qajoamadettsi zagayse, Barnabaasbee Sawlbeam ki jibbade. ");
INSERT INTO amf_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Bhawloos hambhea Sawl Manpas Gazanka thoothayse Baryesusam jalayse, ");
INSERT INTO amf_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Cubbobee siyamobeka thoothaa ya Seethaandettsea, tipan waadiman wulsa banqin ea, Imba Yesussa gaz hamon goynam wobsan garattanu? ");
INSERT INTO amf_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Taar shedaa! Imba Yesus hadar pirda ki pirde; aapino hanno woda likkana kaya ko kaye; haynam haapattane” kina ki hamade. Ogora saanawa gudabee thipabe kidar ko hanchade; kisa aaninam yedayse entsea eedi zagada, yisa gasante yaayan ki yedade. ");
INSERT INTO amf_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ogo wodanka Imbaa wontea Yesussa yinin qanson timmirinka peen wottsea targadhayse, maaton yerinam yinin haapenka Barjodar woylamin ki qajade. ");
INSERT INTO amf_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Bhawloosaar yettsina yinnabesana kinka bazindara sagadhen gonngalante ardayse Bhapu katamara dhaabhayse Bhinpilia gidir dohon Bherge katamandar ke yivade; Marqoos hambhea Wannisaar kekalanka edimayse Yerusaalemdar maatayse ki yivade. ");
INSERT INTO amf_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Kediar Bhergera dhaabhayse Bhisdia gidir dohon Anthokia katamandar ke yivade; ukunsen rooroakaar Ayiwd eensa bukin raqinte ardayse ke dooqade. ");
INSERT INTO amf_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Musebee ena Barjokala qansayse eenna giyayna eenabesa mathaapinam nabbabadhonsa budonte, Ayiwd eensa bukin raqinam wottsayna eena “Imbanaanato, eenaam yenin kiilea dhalq yesa daa ko hanna giyee” hamayse Bhawloosbekal eedi ke yittsade. ");
INSERT INTO amf_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ogonante Bhawloos dhaabhayse aanka yisa dhahayse kena yin ki giyade: “Yedi Israveel eenabee waani Barjoam kurtumbhayna eenabeto, qansee! ");
INSERT INTO amf_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Igina Israveel eenasa Barjoa wosa eykenaam kamayse Gibth peente chocchidettsi maatayse ke daaka keam eedi gebhi ki maasade. Yisa kantanka ogo peera entsayse keam ki bulade. ");
INSERT INTO amf_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Darantear eedi lamaa kaysa leveaddha kena ki darshade. ");
INSERT INTO amf_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kanaan peentear binna tobbhaanaam kaysayse kesa peenam kenin tiyoadettsi ki hayade. ");
INSERT INTO amf_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“Ogosa budonte, mato oydibee eedi lamaa kaysa apo tabhibe (450) leveaddha Barjokala qansayse eenna giyea Saameel wodanka yekka banqin uxate keam entsada kedar pirdayna eenaam kena ki imade. ");
INSERT INTO amf_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ogora bit kena bitinsadhoadettsi ke miskade; Barjoar Biiniam muldhara nivaa Qiis naasa Saavolam eedi lamaa kaysa leveka yekka kena ki bitinsade. ");
INSERT INTO amf_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kiamaar yinin bulonsa budonte, kedar kinin bitimoadettsi Dawtam ki dhaasade. Barjoar ‘Kattsi isa woylaminin nashea, inin bhocchea wulam waadadhea Isey naasa Dawtam i haapade’ hamayse Dawtna ki tarjade. ");
INSERT INTO amf_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Ogo Dawt muldhara Barjo ‘nittsayda nittse’ kinin hamon upsindettsi Israveel eenana Dhacchea Yesusam ki nittsade. ");
INSERT INTO amf_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesusin nivonsa birayse Shivea Wannis Israveel eena wulna seeson waadimanam garayse Barjodar kenin maatonam eshkea shiidhime kenin shiidhoadettsi kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Shivea Wannisaar waadiman yinnonam macchanna kinin hayenka, ‘Inta yekal hayyi maataa? Inta Barjoyn qadhaa Kiristoostehe; ko dahaannaar inta kisa dunngurinsa dhaxinam ko hannaar, bulana iam zaskima isa budonte kida nive’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Imbanaanato, Abraamsa muldhara adhadhaanabee waani Barjoam kurtumbhayna eenabe, kono dhaqintansa upsino wona ko nittsadhade. ");
INSERT INTO amf_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yerusaalem gidir dohon eenbee kosa hayonabe Yesus dhacchea kinin dohonam dhesadehe; Ayiwd eensa ukunsen roorona wulka nabbabadhayno ena birayse Barjokala qansayse eenna giyayna eenasa upsinaamaar kedi bhocchadehe. Dembhisa pirdi kidar ke pirdade. Ogo yin kenin hayonka thaapadhonam ke thoosade. ");
INSERT INTO amf_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Dembhina kiam yeskisea seeso kalaar ke haapaammaar, kiam deesadhoadettsi Bhilathoosam ke miskade. ");
INSERT INTO amf_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kinnon goynsa thaapadhon wulam ke thoosaysaka masqalira kiam hanchayse seeni layta palsate ashkadhon duukin oolonte kiam ke duukade. ");
INSERT INTO amf_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Barjoar diira kiam ki dhaasade. ");
INSERT INTO amf_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kimbesana kinkaar Galilara Yerusaalem nivaana eenakal thoothi wodana ki haapadhade. Kedi ta eenna kisa tarjana maatayse ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Wodiar ena wosa eykenana Barjoyn ‘imayda ime’ hamon wozisen upsinsa yena woda giye. ");
INSERT INTO amf_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Mazmur mathaapinsa kashi lamaar, Barjo ‘Ya isa Naasane; kina haam i adhade’ hamayse thaapadhondettsi, Yesusam diira dhaasintaka ogo qaabe yindar haydhen upsinam wo kesa naanana ki thoosade. ");
INSERT INTO amf_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Barjo kinin capoamadettsi diira kiam kinin dhaasonam dhaana, ‘Gon hama Dawtna inin imon gazan qaabe yindar haydhen yerinam yena ida ime’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Pir Mazmur mathaapinte ‘Gazaa hasa Naasa kinin capoadettsi hayattane’ ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Dawtaar wodan yinnon wulka Barjosa qaabonam yinin waadadhonsa budonte, ki diyade. Ena kisa eykenakal ki duukadhaysaka ki capade. ");
INSERT INTO amf_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kaa diira Barjoyn yiam dhaasaa agaa ea capadehe. ");
INSERT INTO amf_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Ta imbanaanato, yena giidhonam bhocchee: Seesosa garinto Yesusbar haapadhenam dhesee. ");
INSERT INTO amf_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kidar woylamin qajea wul Muse yigginin tipa maasana damaamorra Yesuska tipa eedi kida maate. ");
INSERT INTO amf_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ogona ena Barjokala qansayse eenna giyayna eenaka yin giidhoono yedar yeskoamadettsi mete yesaam gishee: ");
INSERT INTO amf_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Yedi bagimaynato, shedayse targadhee; kayee! Harrna hambhidianna, eedi hayyear yena giydi ki hannaar yenin gonne hamimin waadiman yesa wodanka ida waadadhe’ hamayse ko thaapadhade” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Bhawloosbee Barnabaasbe Ayiwd eenasa bukin ranqira kenin utenka, niven ukunsen rooroaka dhalqin koam kenin giyoadettsi eena keam ke miskade. ");
INSERT INTO amf_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Bukiraar kenin utonsa budonte, Ayiwd eenabee Ayiwd eenasa Barjodar woylamin qajintante ardayse Barjona goodimayna eenabesa shaarira thoothino eeno Bhawloosbee Barnabaasbesa paanan yivan ko yedade. Kediar kena yinin giyenka Barjosa sunin imintonka wocchimbhayse kenin doadettsi keam ke kiilade. ");
INSERT INTO amf_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Guttsea ukunsen rooroaka eena likka bish kenin shidhenka, katamante dohoono eeno wul Barjosa upsinam qansana ko bukade. ");
INSERT INTO amf_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ayiwd eenaar thoothin een konin bukonam yinin haapenka wooginto kesa iir thoothonna, Bhawloosin giyayno “buudane” hamaate kiam ke iirade. ");
INSERT INTO amf_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Bhawloosbee Barnabaasbe kurtumbhima “Barjosa upsinam birayse yena giya ko zaskade. ‘Zagattone’ ye hamannabee rooro wul lay dehen sadan yena konin haapadhoamadettsi ye pirdannabe, Ayiwdtay hamma eenakal woda yive. ");
INSERT INTO amf_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Harrna hambhidianna, ogodettsi Barjo yi giyna: ‘Peendar dohoono eeno wul hanka konin dhaqoadettsi Ayiwdtay hamma eenana shaaka haam i hayade’ hamayse wona kinin giyonnane” kena ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ayiwdtay hamma eenaar koam qansayse kattsi ke wozadhade; Barjosa upsinamaar ke gobshade. Rooro wul lay dehen sadanna Barjoyn yina kamaana wul kidar woylamin ke qajade. ");
INSERT INTO amf_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Imbaa wontea Yesus goynka dhalqino ogono peen wulir ko workade. ");
INSERT INTO amf_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ko dahaannaar Ayiwd eena Bhawloosbee Barnabaasbedar Barjona goodimayna gobshadhaana mansen naanabee katamante gembha eenabeam ke dhaasade. Oytaydha kedar bavayse kesa peera keam ke bulsade. ");
INSERT INTO amf_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Kediar kena tarja konin doadettsi roondar yisa dohon silalinam iir dinsayse Iqoniyoon katamandar ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Barjodar woylamin qajayna eena wozabee Manpas Gazanbeka thoothayse ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iqoniyoon katamante Anthokiar maatondettsi ko maatade; Bhawloosbee Barnabaasbe Ayiwd eensa bukin raqinte ardayse Barjosa upsinam kena ke giyade. Ogo goynka Ayiwd eenabee Ayiwdtay hamma eenabesa shaarira thoothina eena Barjodar woylamin ke qajade. ");
INSERT INTO amf_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Barjodar woylamin qajaamma Ayiwd eena ke hanna, Ayiwdtay hamma eenaam dhaasayse Barjodar woylamin qajayna eenaam kenin jibboadettsi ke hayade. ");
INSERT INTO amf_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ogonante Bhawloosbee Barnabaasbe Imbaa wontea Yesus goynsa kurtumbhima giyada kataman ogote thoothi rooro ke dooqade; Imbaa wontea Yesusaar milkitbee yer tarsheabeam kenin hayoadettsi hayamo kena imintaka kisa sunin imintonsa giidhayno upsino gon konin maatenam ki tarjade. ");
INSERT INTO amf_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Katamante dohon eenoar lamaadar kashimayse, antina Ayiwd eenakal antina kesa Kiristoos yisa tarjamonnante kinin yittsaana Bhawloosbee Barnabaasbekal ke maatade. ");
INSERT INTO amf_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ayiwdtay hamma eenabee Ayiwd eenabe ke hanna, yiam wottsayna kinka Bhawloosbee Barnabaasbeam galshanabee seenika keam paxate deesanabe ke zagade. ");
INSERT INTO amf_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Bhawloosbee Barnabaasbe ogoam dhesayse, Loqonia peente dahaana Listhirabee Derbebe katamanadar, pir kesaar gasante dahaana peenadar gobate ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ogotear Barjosa dhacchintan upsinam giyte ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Yinin adhadhorra yedayse rooysa woboa, yaaya dhesima eedi kalaa Listhira gidir ki dahade. ");
INSERT INTO amf_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ea agaa dooqayse Bhawloosin giyenam qansite ki dahade. Bhawloos kiam kinin shedenka, paashana Barjodar woylamin kinin qajonam haapayse ");
INSERT INTO amf_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","upsi gebhika, “Dhaabhayse roon hannonka woyaa!” kina ki hamade. Kidi saana dhaabhabh hayayse yaayan ki yedade. ");
INSERT INTO amf_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Eenaar Bhawloosin hayonam yinin haapenka, upsinam yisa kattsi dheg hayayse Loqonia peen aponka “Igina barjona eedidettsi maatayse wokal ke hanchade” ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barnabaasamaar “Dia” ke hamade; Bhawloosamaar dhalqin kattsi kinin giyonna, “Hermeen” kiam ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Katamansa gasante dohon Dia hambhea barjoasa gazan ooninte waadadhea gudula waakibee aamanka ashkadhaana gobshin yerrabeam katamansa kerindar bavayse, zarsino kinka maatayse Bhawloosbee Barnabaasbena marsha machana ki zagade. ");
INSERT INTO amf_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kiristoos yisa tarjamonnante kinin yittsaana Barnabaasbee Bhawloosbe koam yinin qansenka, dhagaka apalam yisa hattsayse eenkal gobate yivayse upsi gebhika yin ke giyade: ");
INSERT INTO amf_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Yedi eenato, koam harrnee hayaa? Wodiar pir yedettsi eedine. Ogo pootimon yerinam garayse cecinbee, peenbee, bazinbee, kesa iir dohon yerin wulbeam pijaa sadanka dahaa Barjodar yenin maatoadettsi Barjosa dhacchintan upsinam yena woda giye. ");
INSERT INTO amf_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Barjo kosa birayse Ayiwdtay hamma eena wulam yisa bhocchinka kenin yivoadettsi keam ki garade. ");
INSERT INTO amf_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ko dahaannaar payya yena hayada, ceciraar doobi qansada, isinnoar wodanka konin ushoadettsi hayada, yesa woylaminamaar galabee wozabeka yinin micchenka, igina kinin waadadhaana wul kisa tarjane” kena ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ogoam kena giyayse eeno marshanam kena konin machoamadettsi kenin maroono gebhi gaalekane. ");
INSERT INTO amf_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ko dahaannaar Ayiwd eena Anthokiabee Iqoniyoonbera Listhira katamandar ke nivade; kataman ogosa eenaam yidar maasayse Bhawloosam seeninka paxayse, “Diydine” hamayse katamara os mayanka gochate ke dhabade. ");
INSERT INTO amf_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Barjodar woylamin qajayna eena nivayse kisa gasante ke woyaysaka, kidi dhaabhayse katamante ki ardade. Kina hamon sedhiman Barnabaasbesana Derbe katamandar ki yivade. ");
INSERT INTO amf_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","22","Ogo Derbe katamantear Barjosa dhacchintan upsinam giyayse thoothi Barjodar woylamin qajayna eenaam yinin haaponsa budonte, Bhawloosbee Barnabaasbe anngala kenin yivon Listhirabee, Iqoniyoonbee, Anthokiabe katamana gidir dahaana Barjodar woylamin qajayna eenaam wocchinsada, Barjodar woylamin yinin qajenkaar wocchimbhayse kenin doadettsi keam kiilada, “Barjosa bitamon raqinte thoothi gaaleka arda woam ko zaske” hamaate maatayse ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Misken oonin wulir itsima Barjoam miskintaka, donza kena kamayse yinin wodonsa budonte, kenindar woylamin qajaa Imbaa wontea Yesusna elqimayse keam ke imade. ");
INSERT INTO amf_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ogora Bhawloosbee Barnabaasbe Bhisdia peen goynka Bhinpilia peendar ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Bherge katamante Barjosa upsinam yinin giyonsa budonte, Athaalia katamandar mia ke hanchade. ");
INSERT INTO amf_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ogora kenin macchon waadimansa Barjosa sunin imintonna elqimbhadhaysaka iira kenin uton Sooria peen Anthokia katamandar bazindara sagadhen gonngalanka maatate ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Anthokia katamante yinin yeskon wodanka, Barjodar woylamin qajayna eenaam buskayse Barjo kembesana kinka kinin waadadhon wulbee Ayiwdtay hamma eenana Barjodar woylamin qajintasa goyti kena kinin bulonbeam kena ke giyade. ");
INSERT INTO amf_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Bhawloosbee Barnabaasbe ogote Barjodar woylamin qajayna eenabesana kinka woda thoothina ke dooqade. ");
INSERT INTO amf_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Waani waani eena Yiwda peera Anthokia katamandar nivayse, “Musena imbhon gilonka yesa qaamanam ye taxadhaamma, dhaqana damattene” hamayse Barjodar woylamin qajayna eenaam dhettsite ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Bhawloosbee Barnabaasbe kesa timmirinam kenin tiyaamonna, kattsi kekal ke palimade. Ogo wodanka Bhawloosbee, Barnabaasbee, misken ooninte bukayna eenasa waani waani eenabe Yerusaalem gidir yivayse Kiristoos yisa tarjamonnante kinin yittsaanabee misken ooninsa donzanabekal bukayse palimen ogosa kenin dhalqoadettsi kena ko giidhade. ");
INSERT INTO amf_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Anthokiar dohon misken oonira kenin yittsadhenka Pinqebee Sammariabera sagada Ayiwdtay hamma eena hamin Barjodar kenin maatonam giyaate giyaate ke yivade; dhalqino ogono Barjodar woylamin qajayna wulam kattsi wozisidine. ");
INSERT INTO amf_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Yerusaalemir kenin yesken wodanka Barjodar woylamin qajaynabee, Kiristoos yisa tarjamonnante kinin yittsaanabee, misken ooninsa donzanabe keam ke tiyade; Barjoar kembesana kinka kinin waadadhon wulam Bhawloosbee Barnabaasbe kena ke giyade. ");
INSERT INTO amf_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Parisa eensa shaarira Barjodar woylamin qajaana waani waani eena dhaabhayse, “Barjodar woylamin qajayna Ayiwdtay hamma eenana qaamanam ye taxebee Musesa yigginam kenin tooloadettsi kena ye giyebe yeam ko zaske” kena ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Kiristoos yisa tarjamonnante kinin yittsaanabee misken ooninsa donzanabe dhalqin ogo goynka kinka dhalqana ke bukade. ");
INSERT INTO amf_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Thoothi kenin palimonsa budonte, Bhethiroos dhaabhayse kena yin ki giyade: “Imbanaanato, Ayiwdtay hamma eena inin giyen Barjosa dhacchintan upsinam qansayse Barjodar woylamin kenin qajoadettsi Barjo ena birayse yennon iira iam kinin kamonam yedi dheseeda dhese. ");
INSERT INTO amf_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Eensa woylaminam dhesea Barjo wona Manpas Gazanam yinin imondettsi kenaar imayse kesa ki tarjade. ");
INSERT INTO amf_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Barjodar woylamin kenin qajenka Barjo kesa woylaminamaar kinin gazinsenna, kembee wombesa shaarinte yer kalaaka edime kidi hayadehe. ");
INSERT INTO amf_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ta eykena wonnabee wombe baskana wonin damimon baskenam Barjodar woylamin qajayna eenaam baskisintaka ta Barjoam harrnee taysate shede? Kiam taysate shedeebhode! ");
INSERT INTO amf_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Imbaa wontea Yesus Kiristoossa sunin imintonka wonin dhaqondettsi, kediar dhaqidine hamayse woda tipise” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Eeno wulaar lay hamayse Barnabaasbee Bhawloosbe Barjo kennon goynka Ayiwdtay hamma eenasa shaarinte kinin waadadhaana milkitinabee tarshayna yerra wulbeam ke giyaka ko qansade. ");
INSERT INTO amf_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Kediar giyate kenin macchonsa budonte, Yayqoob yin ki giyade: “Imbanaanato, ikal qansee. ");
INSERT INTO amf_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Barjo yisa naabenna maatayna Ayiwdtay hamma eensa shaarira tiyana ena birayse kena hamin kinin bhocchonam Simoon giydine. ");
INSERT INTO amf_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Dhalqino ogono Barjokala qansayse eenna giyaynasa dhalqinbesana kalaane. Ogonoar: ");
INSERT INTO amf_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","17","‘ “Ogosa budonte shidhaana eenabee innon naabenka eldhaana Ayiwdtay hamma eena wulbe Barjoam kenin zagoadettsi maatate nivayse dhambon Dawtsa apalan ooninam ida woyse; kosa yiiponamaar maasayse pir koam ida ashke” hamayse ");
INSERT INTO amf_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ena birara yedayse ko wulam dhettsaa Barjo ki giyade’ hamayse ko thaapadhade. ");
INSERT INTO amf_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ogonante isa qaabono Ayiwdtay hamma eensa shaarira Barjodar maatayna eenaam wonin galshoamadettsine. ");
INSERT INTO amf_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ko dahaannaar aaninka ashkadhaana barjonana marshan machadhon waankalankabee, sharmucimakkonkalankabee, taxadhima diyaana qollasa waankalankabee, zombhinkalankabe kenin pegadhoadettsi hamayse kena wo thaape. ");
INSERT INTO amf_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Harrna hambhidianna, enara yedayse ukunsen roorona wulka Ayiwd eensa bukin raqinte Musesa yigginam nabbabadhaatebee katamana wulir giidhaatebe ko daadhade” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ogo wodanka Kiristoos yisa tarjamonnante kinin yittsaanabee, misken ooninsa donzanabee, misken ooninte dohon een wulbe kinka hamayse, kesa iira eedi kamayse Bhawloosbee Barnabaasbesana Anthokiadar yittsana kinka ke dhalqade. Ogonante Barjodar woylamin qajayna eenaam entsintanka dhesadhaana Bersaabas hambhea Yiwdabee Sillaasbeam ke kamade. ");
INSERT INTO amf_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Yinin thaapon warqatinam kesa aaninka ke yittsade; warqannoar yin koda giye: “Wodi Kiristoos yisa tarjamonnante woam kinin yittsaanabee misken ooninsa donzanabe wonin thaapoono Anthokiabee, Sooriabee, Kilqiabesa gidir dahaana Ayiwdtay hamma eenasa shaarinte dahaana imbanaanato, ‘Nagaya’ yena woda hame. ");
INSERT INTO amf_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Wosa iira waani waani eena wo kena giyma yekal nivayse dhalq yena giyntaka yeam kenin galshonbee yeam warkata kenin entsonbeam wodi qansidine. ");
INSERT INTO amf_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ogonante kinka bukayse wonin dhalqonsa budonte woylam kalaa maatayse, wonin nashayna wosa imbanaana Barnabaasbee Bhawloosbedar eedi kamayse yekal keam yittsana wo zagade. ");
INSERT INTO amf_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Kedi wosa Imbaa Yesus Kiristoossa naabenna yisa sadanam dembhinna ke imade. ");
INSERT INTO amf_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ogonante Yiwdabee Sillaasbe wonin yena thaaponam pir yena kenin giyoadettsi yekal keam wo yittsade. ");
INSERT INTO amf_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","29","“Aaninka ashkadhaana barjonana marshan machadhon waankalankabee, zombhinkalankabee, taxadhima diyaana qollasa waankalankabee, pir sharmucimakkonkalankabe yenin pegimbhoadettsi, igina yeam zaskaynara ab baske yedar wonin wodoamadettsi wombee Manpas Gazanbena payya maatayse ko haapadhade. Igina wulra yeam ye toolanna, payya yeda haye. Payyamo yena ko dee” hamayse ke thaapade. ");
INSERT INTO amf_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Igina yittsadhaana eenaar kekalanka edimayse Anthokia katamandar ke yivade; misken ooninte dahaana eenaam buskayse warqatinam kena ke imade. ");
INSERT INTO amf_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Barjodar woylamin qajaynaar ogo warqatinam nabbabayse kesa kiilimenka kattsi ke wozadhade. ");
INSERT INTO amf_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yiwdabee Sillaasbe Barjokala qansayse eenna giyayna yinin dohonna, thoothi kiilayse keam ke wocchinsade. ");
INSERT INTO amf_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Yiwdabee Sillaasbe likka roorona Anthokia gidir kenin dooqonsa budonte, Barjodar woylamin qajayna imbaanaana keam payyamoka kenin yittsaka, kediar birayse yiam yittsaana eenakal ke maatade. Sillaas ogote shidhana ki zagade. ");
INSERT INTO amf_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Bhawloosbee, Barnabaasbee, waani een thoothinbesana kinka Imbaa wontea Yesussa dhacchintan upsinam dhettsadabee giyadabe Anthokiar ke dooqade. ");
INSERT INTO amf_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Likka roorosa budonte, Bhawloos Barnabaasam “Wodi maatayse Imbaa wontea Yesussa upsinam wonin giyaana katamana wulir wosa imbanaanaam yivayse wo shede; hamin kenin dohonam wo dhese” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabaas Marqoos hambhea Wannis kembesana kinka ki yive ki zagade. ");
INSERT INTO amf_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Bhawloosaar Marqoos kembesana kinka ki yive nashadehe. Harrna hambhidianna, Bhinpilia gidir kidi kekalanka edimayse kinin shidhonnabee waadadhana kembesana kinka kinin yivaamonnabene. ");
INSERT INTO amf_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ogo goynka Barnabaasbee Bhawloosbesa shaarinte kattsi palime konin dhaabhonna, kikalanka ke edimade. Ogonante Barnabaas Marqoosam yinka entsayse bazindara sagadhen gonngalante ardayse Qobhiroos ki yivade. ");
INSERT INTO amf_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Bhawloosaar Sillaasam ki kamade; Barjodar woylamin qajayna eena Bhawloosam Barjosa sunin imintonna kenin elqimonsa budonte, ki yivade. ");
INSERT INTO amf_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Kidiar Sillaasbesana Barjosa misken ooninte dahaana eenaam wocchinsada Sooriabee Kilqiabe gidir ki yaayade. ");
INSERT INTO amf_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bhawloos Derbebee Listhirabe gidir ki yeskade. Listhira gidir Thimaatoos hambhea Barjodar woylamin qajea ea ki dahade. Kisa indanoar Ayiwd eensa shaarira Barjodar woylamin qajaynone; kisa imbaa Girik eedine. ");
INSERT INTO amf_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Thimaatoosna Listhirabee Iqoniyoonbe gidir dahaana Barjodar woylamin qajayna eena ke tarjade. ");
INSERT INTO amf_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Bhawloos Thimaatoos kimbesana ki yive ki zagade. Peen ogote dahaana Ayiwd eenana hamayse kisa qaamanam ki taskade; ogonoar kisa imbaa Girik eedi kinin maatonam Ayiwd eena wul kenin dhesennane. ");
INSERT INTO amf_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Katamana wulir kenin yaayenka, Yerusaalemir dahaana Kiristoos yisa tarjamonnante kinin yittsaanabee misken ooninsa donzanabe kenin giyon dhalqinam kenin tooloadettsi Barjodar woylamin qajayna eenana ke giyade. ");
INSERT INTO amf_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ogonante misken ooninte dahaana eena Barjodar woylam qajintaka keda wocchimbhe; rooroa rooroaka waani eeno Barjodar woylam konin qajenna, kesa paydino thoothada ko yivade. ");
INSERT INTO amf_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Bhawloosbeyn Isiya peente Barjosa upsinam giyoamadettsi Manpas Gazano keam konin maronna, Pirgiabee Galatia peenbesa shaarinka ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misia peen yeskayse Bitaania peendar yivana ke zagade; ko dahaannaar Yesussa Manpasino ogodar kenin yivoamadettsi keam ko marade. ");
INSERT INTO amf_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ogonante Misiabar Thirovadda katamandar ke hanchade. ");
INSERT INTO amf_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ogo sootin Bhawloos Barjoyn kina dhohon shedintonka yer ki haapade. Ogo shedintonka Moqodoonia peen eedi kalaa Bhawlooskal woyayse, “Wokal Moqodoonia nivayse woam kelshaa!” hamayse kiam ki miskade. ");
INSERT INTO amf_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Bhawloos Barjokala shedintonam kinin shedonsa budonte, saana Moqodoonia peendar yivota wo zagade. Harrna hambhidianna, Barjosa dhacchintan upsinam kena wonin giyoadettsi Barjoyn woam eelonam wonin dhesonnane. ");
INSERT INTO amf_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Thirovadda katamara bazindara sagadhen gonngalante ardayse gaz hamayse Samotiraaqe peen wo yeskade; ogora guttsea rooroaka Naabhule kataman wo yivade. ");
INSERT INTO amf_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ogora dhaabhayse Pilbhisoos kataman wo yeskade. Pilbhisoos katamano Moqodoonia gidir dohoono Roome eenanin woysoono katama gaarine. Kataman ogote rooro likka wo dooqade. ");
INSERT INTO amf_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ayiwd eensa ukunsen rooroaka katamansa kerinka utayse “Barjoam miskadhayno raq ogote ko dahade” hamayse wonin bhocchonna baynsa aponte wo yivade. Ogote dooqayse bukaana maanana Barjosa upsinam wo giyade. ");
INSERT INTO amf_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Qansaana eenasa shaarinte Tiathiron katamara nivoono apala zoo shanshayno Liidia hambhayno maa kallo ko dahade; kodiar Barjona goodimaynone. Bhawloosin giyenam gonne hamayse konin tiyoadettsi Imbaa Yesus kosa woylaminam ki bulade. ");
INSERT INTO amf_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kombee oonin eena konnabe shiidhimbhen kenin shiidhimbhonsa budonte, “Imbaa wontea Yesusdar woylamin inin qajenam gonne ye hamidianna, oonin innonte nivayse dooqee” konin hamenka, ee wonin hamoadettsi kattsi woam ko miskade. ");
INSERT INTO amf_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Rooro kalaa Barjoam miskadhen raqinte wonin yivenka, os birante maaten yerinam koam giisayno beero yindar dohoono maa worsho kallo goynte wodar ko keerade. Kodiar os birante maaten yerinam giyntaka yiam wottsaynana thoothi birre koda pucche. ");
INSERT INTO amf_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Kodi Bhawloosbee wombesa paanan yivada, “Igina eena Wuldara Sagea Barjoana waadimayna eenane. Kedi dhaqintansa goynam yena keda giye” hamayse upsi gebhika giyte ko dahade. ");
INSERT INTO amf_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Kodiar thoothi roorona yin konin giyonna, Bhawloos dhagaka budoka wal hamayse beeroana “Yesus Kiristoossa naabenka kodara hanin utoadettsi hana ida giye” ki hamade. Ogora saanawa beeroa kodara ki utade. ");
INSERT INTO amf_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Koam wottsaynaar “Konka wonin haapayno birreno wosa shidhidine” hamayse, Bhawloosbee Sillaasbeam yedayse gochate hayonayn dohon gaban raqinte keam ke bavade. ");
INSERT INTO amf_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Kataman wottsaynasa birante keam bavaysear, “Kina eena Ayiwd eedi dahayse wosa katamante eenaam kidar keda dhaase. ");
INSERT INTO amf_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Wodi Roome eedi dahayse gonne hamayse tiyabee waadadhabe woam zaskimin dambinam wona keda giye” ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Eeno wulaar kinka maatayse Bhawloosbee Sillaasbedar ko dhaabhade. Kataman wottsaynaar Bhawloosbee Sillaasbedara apalan bulayse haljoka kenin qandhoadettsi ke giyade. ");
INSERT INTO amf_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Thoothi keam yinin qanonsa budonte, dhaxin ooninte keam ke dhaskade; dhaxin ooninam toolea ear wocchimbhayse keam kinin tooloadettsi kina ke giyade. ");
INSERT INTO amf_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kidiar dhalqin ogoam qansayse dhaxin ooninsa gulinte keam arsayse kesa roonam haaqana gulantana lamaanasa shaarinte ki dhaxade. ");
INSERT INTO amf_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Sootin kiaddha laman Bhawloosbee Sillaasbe Barjoam miskada mazmurka kiam keda gobshe; waani dhaxadhaana eenaar kenin giyenam qansite ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Dhesadhima dhaxin ooninin shohenka yekka, gebhi peeno ko zigimade. Saanawa dhaxin ooninsa kerra wul ke bulimade; dhaxin ooninte dahaana eena wulsa sansalano ko bulimade. ");
INSERT INTO amf_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Dhaxin ooninam toolear yinin raatorra dhaabhayse dhaxin ooninsa kerin bulimonam yinin haapenka, dhaxadhaana eena utate yivaa kina konin maatonna, yiam deesota qaabayse halpa ki gochade. ");
INSERT INTO amf_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Bhawloosaar upsi gebhika “Wodi wul kote daane; ya hadar yer siya yeskisaabhode!” hamayse kina ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Dhaxin ooninam toolear “Shaaka ina bevee!” hamayse dhaxin ooninsa gulinte gobate yivayse kurtumbheka gibazada Bhawloosbee Sillaasbesa birante ki dhambade. ");
INSERT INTO amf_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Mayante keam bulayse, “Imbanato, inin dhaqoadettsi har haya iam ko zaske?” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Kediar “Imbaa wontea Yesusdar woylamin qajaa; hambee hasa oonin eenabe dhaqeeda dhaqe” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Kimbee kisa ooninte dahaana wulbena Imbaa wontea Yesussa upsinam ke giyade. ");
INSERT INTO amf_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Sootin savaatin ogoka Bhawloosbee Sillaasbeam dhaxin oonira entsate yivayse kesa hajiminam ki shivade; saanawa yimbee oonin eena yinna wulbe shiidhimbhe ke shiidhimbhade. ");
INSERT INTO amf_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Yisa oonindar entsate yivayse gala kena ki imade. Yimbee oonin eena yinnabe Barjodar woylamin kenin qajonna kattsi ke wozadhade. ");
INSERT INTO amf_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Peen sedhaysakaar kataman wottsayna eena “Igina eenaam bulaa” hamayse dhaxin ooninam tooleakal poolisanaam ke yittsade. ");
INSERT INTO amf_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Dhaxin ooninam toolea “Yenin buldhoadettsi kataman wottsayna eena upsi ke nittsade; ta keeda utayse nagaya yivee” hamayse upsin ogoam Bhawloosna ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Bhawloosaar poolisanana “Wodi Roome eedi dahayse wodar pirdadhima eensa birante qanayse dhaxin ooninte woam ke dhaskade. Ta woam aachika bulate ke yittso? Yin dehehe! Yinti nivayse woam bulate ke yittse” ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Poolisanaar dhalqin ogoam kataman wottsayna eenana ke giyade. Kataman wottsayna eenaar Bhawloosbee Sillaasbe Roome eedi kenin dohonam yinin qansenka ke kurtumbhade. ");
INSERT INTO amf_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ogonante yinti nivayse, “Wodi dhabidine; wona garee” hamayse dhaxin oonira keam ke bulade. Ogo katamara kenin yivoadettsi keam ke miskade. ");
INSERT INTO amf_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Bhawloosbee Sillaasbe dhaxin oonira utayse Liidia ooninte ke ardade; ogote Barjodar woylamin qajaana eenaam yinin wocchinsonsa budonte, kataman ogora ke utade. ");
INSERT INTO amf_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Bhawloosbee kimbesana waadadhayna eenabe Ampibholisbee Abhilooniabeka sagayse Teselonqe kataman ke yeskade. Ogotear Ayiwd eenasa buki raq ko dahade. ");
INSERT INTO amf_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Bhawloosaar yisa dambindettsi kekal ardayse, gaba makkam ukunse rooro makkam Mathaap Gazara kembesana dhalqada keam ki dhettsade. ");
INSERT INTO amf_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Mathaapira kena yinin giyenka, Kiristoos gaale haapayse dembhira dhaabha kiam zaskenam kena dhettsada, “Agaa inin yena giyea Yesus Barjoyn qadhaa Kiristoosne” ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Kesa shaarira waani waani eena Bhawloossa dhalqinam yinin qanson wodanka gonne hamayse Bhawloosbee Sillaasbedar ke maatade. Ogodettsi Barjona goodimayna thoothi Girik eenabee katamante dhesadhaana maana waanibe kedar ke maatade. ");
INSERT INTO amf_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ayiwd eena kedar woogintaka waadiman garayse sun yaayayna siyana eenaam bavayse kedar ke dhaasade. Katamante goore dhaasayse Bhawloosbee Sillaasbeam eenna imana Iyaasoonsa ooninam ke karade. ");
INSERT INTO amf_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ko dahaannaar kenin haapadhaamonna, Iyaasoonbee waani Barjodar woylamin qajayna eenabeam katamanam wottsaynakal yedate keam yivayse, yin giyayse ke ilatade: “Kina peen wulir gooren dhaasaana eena ta pir kote ke nivade; ");
INSERT INTO amf_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Iyaasoon keam tiydine. Kedi wul ‘Yesus hambhea waana bit daane’ hante Roome peen bitaasa upsinam keda jibbe” ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Eenabee katamanam wottsaynabe dhalqin ogoam yinin qansenka ke targadhade. ");
INSERT INTO amf_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Iyaasoonbee Barjodar woylamin qajayna waani eenabeam waasi elsayse keam ke garade. ");
INSERT INTO amf_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Barjodar woylamin qajayna eena saana Bhawloosbee Sillaasbeam sootika Beeria katamandar ke yittsade. Yinin yeskenkaar Ayiwd eensa bukin raqinte ke ardade. ");
INSERT INTO amf_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beeria eeno Teselonqe gidir dohon eendara sagi woylaminka payya qaabayno konin dohonna, kattsi wozaka Bhawloosbeyn giyen upsinam kedi qansidine. Upsino ogono gon konin dohonam dhesana Mathaap Gazanam rooro wulka marmarate keda shede. ");
INSERT INTO amf_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ogonante kesa iira thoothino eeno Barjodar woylamin ko qajade; yin pir Girik eensa shaarira thoothi dhesadhaana maa waanibee anngi waanibe Barjodar woylamin ke qajade. ");
INSERT INTO amf_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Teselonqe katamante dahaana Ayiwd eena ke hanna, Bhawloos Beeria katamante pir Barjosa upsinam kinin giyonam yinin dhesenka, kataman ogote pir nivayse eenaam pucchayse goore ke dhaasisade. ");
INSERT INTO amf_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ogo wodanka Barjodar woylamin qajayna eena saana Bhawloosam bazinsa gasante kinin yivoadettsi kiam ke yittsade. Sillaasbee Thimaatoosbe Beeria katamante ke shidhade. ");
INSERT INTO amf_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bhawloosam suudana yivaana eena Atena katamante kiam ke yeskisade. “Sillaasbee Thimaatoosbe saana ikal ke yeske” hamen Bhawloossa ergenam yinka tiyate ke maatade. ");
INSERT INTO amf_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Bhawloos Atena katamante Sillaasbee Thimaatoosbeam kaalaate kinin dehenka, katamante aaninka ashkadhaana barjonayn thoothonam yinin haapenka qaabenka ki atade. ");
INSERT INTO amf_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ogonante Ayiwd eensa bukin raqinte Ayiwd eenabee Barjona goodimayna Ayiwdtay hamma eenabekal ki dhalqade; taar gaban raqinte yinin haapayna eenabesana rooro wul ki palimade. ");
INSERT INTO amf_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Epqorossabee Istoyk hambheabe timmirin dhesaana eena kidar ke palimade. Waani waani eenaar “Kaa sun waraqea ta har giyota ki zage?” ke hamade; waani eenaar “Barjona hallasa giyea kida maate” ke hamade. Ogono kenin giyoono Yesusbee kisa diira dhaabhidinbesa Bhawloosin giyonnane. ");
INSERT INTO amf_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ogonante Bhawloosam Aryospagos hambhen bukin raqinte kiam entsate nivayse kina yin ke giyade: “Kono hanin giyayno timmirino hallo har konin dohonam wona giyaa. ");
INSERT INTO amf_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Hanin giyayno yerro haali yer ko maatade; ta hanin giyen yerinam har konin dohonam dhesana woda zage” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ogono yin kenin giyoono Atena een wulbee gidir dahaana shonnabe haali yer giyadabee qansadabe wodanam saskota bish kenin nashennane. ");
INSERT INTO amf_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Bhawloosaar Aryospagos gidir bukaanasa shaarinte woyayse kena yin ki giyade: “Atena eenato, yer wulka waana waana hamma barjonana yenin kurtumbhenam inta dhesidine. ");
INSERT INTO amf_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ogonoar yesa katamante yaayada yenin goodimayna yerram inin shedenka, ‘Dhesimaama Barjoana’ hamayse daran thaapadhon marshan machadhea raqaam i haapade. Ta keeda kiam dhesima yenin goodimea Barjoa agaasa inta yena ida giye. ");
INSERT INTO amf_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Barjo peenbee peendar dohon yer wulbeam pijaa kidine; cecinbee peenbesa Imbaa kinin dohonna, eedin woyson gazan ooninte dehehe. ");
INSERT INTO amf_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Kidi sadanka daadhenbee, upsinbee, yer wulbeam een wulna kinin imenna yer har kikalanka joogimonna, eedi kiam kelshoadettsi zaskehe. ");
INSERT INTO amf_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kidi peendar dohon zarsin wulam eedi kalaara pijayse peen wuldar kenin doadettsi ki hayade. Pir kenin dehen kesa raqinsa maalenbee wodanbeam kashate ki imade. ");
INSERT INTO amf_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ogono kinin yin hayoonoar eeno Barjoam konin zagoadettsibee marmarayse kiam konin haapoadettsibene. Ko dahaannaar wo kalaa kalaanakal kidi pegetehe. ");
INSERT INTO amf_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Harrna hambhidianna, sadanka daadhenam wonin haapenbee, wonin yaayenbee, wonin dohonbe kankane; ogonoar yesa gaadin bulaynasa waani waani eena ‘Wodiar kisa naanane’ hamayse kenin dhaasondettsine. ");
INSERT INTO amf_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ta wodi Barjo naana wonin dohonna, Barjoam ‘Eedi yisa pakalmakkobee qaabobeka worqibee, birrebee, seenibera kinin ashkaadettsine’ hamayse bhoccha woam zaskehe. ");
INSERT INTO amf_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Kosa birayse eeno dhesima konin hayonam Barjo darshayse kena garidine; ta keeda peen wulir dohoono eeno wul siyon waadimanam garayse Barjodar konin maatoadettsi kida giye. ");
INSERT INTO amf_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kidi yinin kamaa ea goynka een wuldar tipamoka yinin pirden rooron wodidine; ogono kiam diira dhaasintaka ki tipisade” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Diira dhaabhadhen goynsa yinin qanson wodanka, antina eena ogoam hancaate ke bagade; antina eena “Dhalqin ogo goynka tapir hanin giyenam woda qanse” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ogora Bhawloos kesa shaarira utayse ki yivade. ");
INSERT INTO amf_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Waani waani eena kimbesana kinka wormayse Barjodar woylamin ke qajade. Kesa iira pir Aryospagos eenasa kalaa Diyonisiyoosbee, Demaaris hambhen maa kallonbee, waani eenabe ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ogosa budonte, Bhawloos Atena katamara utayse Qorontoos katamandar ki yivade. ");
INSERT INTO amf_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ogotear Bhanthoos peente adhadhaa Aqila hambhea Ayiwd eam ki haapade. Kidiar likka wodasa birayse geshon yinnon Bhirsqillabesana kinka Thaalian peera ki nivade; harrna hambhidianna, Ayiwd eena wul Roome katamara kenin utoadettsi Bitaa Qelawdoosin giyonnane. Bhawloosaar kekal ki yivade. ");
INSERT INTO amf_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Kisa waadimanoar kennondettsi konin dohonna, kekal dooqayse ki waadadhade; ke wulsa waadimanoar apala ooni ashkintane. ");
INSERT INTO amf_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Bhawloosaar ukunsen roorona wulka Ayiwd eensa bukin raqinte ardayse Ayiwd eenabee Girik eenabesana kinka dhalqaate Barjosa dhacchintan upsinam gonne hamayse kenin tiyoadettsi giyte ki dahade. ");
INSERT INTO amf_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sillaasbee Thimaatoosbe Moqodoonia peera kenin nivenka, Bhawloos Yesus Barjoyn qadhaa Kiristoos kinin dohonam Ayiwd eenana tarjada Barjosa upsinam rooro wul giyada wocchimbhite ki dahade. ");
INSERT INTO amf_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ko dahaannaar kiam ke jibbaysakabee ke iiraysakabe Bhawloos kedar tarjamo konin doadettsi yisa apalansa silalinam dinsayse, “Barjo yedar kinin pirdayno yesa seesonkane; ogona inta oysadhattine. Keeda kaara inta Ayiwdtay hamma eenakal ida yive” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ayiwd eensa bukin raqira utayse Titoos Iyosthos hambhea eakal ooninte ki ardade. Ea agaar Barjona goodimeane; kisa onnoar Ayiwd eensa bukin raqinsa gasante ko dahade. ");
INSERT INTO amf_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ayiwd eensa bukin raqinam wottsea Qerisbhoosbee oonin eena kinna wulbe Imbaa wontea Yesusdar woylamin ke qajade; Qorontoos eensaar thoothina eena Bhawloosin giyenam qansayse Imbaa wontea Yesusdar woylam qajayse ke shiidhade. ");
INSERT INTO amf_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Sootin Imbaa wontea Yesusin kina dhohon shedintonka Bhawloosna yin ki giyade: “Kurtumbhima giyaa! Lay hamaabhode! ");
INSERT INTO amf_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Harrna hambhidianna, inta hambesanane; kataman kote isa thoothi eedi konin dohonna, hadar gaale yeskisana dhaabhea eedi qolehe” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ogonante Bhawloos Barjosa upsinam dhettsada leve kalaabee arpi laxbe kekal ki dooqade. ");
INSERT INTO amf_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galiyoos Akaya peenam kinin wottsen wodanka, Ayiwd eena kinka kalaa maatayse Bhawloosdar ke dhaabhade. Pirdin raqintear kiam entsate ke nivade. ");
INSERT INTO amf_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“Ea kaa yiggin qolmon goynka Barjona kenin goodimoadettsi eenaam yidar kida maase” ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Bhawloos malsi maasana kinin hayenka, Galiyoos Ayiwd eenna “Yedi Ayiwd eenato, gemmayse way gebhi siya yer ki hayanna, yenin giyenam darshayse qansa iam ko zaske. ");
INSERT INTO amf_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ko dahaannaar dhalqinbee, naabenbee, yesa yigginbe goynka yedi palimayna ye hanna, yemal koam macchee. Inta dhalqin kodettsinam pirdana zagattine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Yin giyayse pirdin raqira kantaka keam ki bulsade. ");
INSERT INTO amf_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ogo wodanka kedi wul Ayiwd eensa bukin raqinam wottsea Sostensam yedayse pirdin raqinsa birante kiam ke qanade. Ogo wul haydhenka Galiyoos lay ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Bhawloos thoothi rooro Qorontoos katamante yinin dooqonsa budonte, imbaanaanaam nagaysayse bazindara sagadhen gonngalante ardayse Sooria peendar yivana ki dhaabhade; Bhirsqillabee Aqilabe kimbesana kinka ke dahade. Kidi Barjobesana malla yinin ardonna, Kinkiria katamante metenam yisa ki haadadhade. ");
INSERT INTO amf_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Epsoon kataman yeskayse ogote Bhirsqillabee Aqilabeam ki garade; kidiar Ayiwd eensa bukin raqinte ardayse Ayiwd eenabesana kinka ki dhalqade. ");
INSERT INTO amf_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Kediar yikal thoothi wodana kinin doadettsi kenin miskenka kidi kena ee hamadehe. ");
INSERT INTO amf_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ko dahaannaar kekalanka edimayse yivota yinin dhaabhenka, “Barjo giyanna yekal inta maatasane” kena ki hamade. Epsoorra dhaabhayse bazindara sagadhen gonngalante ardayse ki yivade. ");
INSERT INTO amf_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Bazira sagayse Qesaaria katamante yinin yeskenka, Yerusaalem yivayse misken ooninte dahaanaam yinin nagaysonsa budonte, Anthokia katamandar ki yivade. ");
INSERT INTO amf_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ogotear likka woda kappayse, ogora dhaabhayse Galatia peenbee Pirgia peentebe yaayaate Barjodar woylamin qajayna eena wulam wocchinsada ki yivade. ");
INSERT INTO amf_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Iskindira katamante adhadhaa Abhiloos hambhea Ayiwd eedi kalaa Epsoon gidir ki nivade; kidi Mathaap Gazanam dhesea maatayse, yisa upsinkaar eediam wozisea eedi ki dahade. ");
INSERT INTO amf_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Imbaa wontea Yesus goynsa timmiriysa dahaa maatayse woylaminka wocchimbhayse giyntaka Yesus goynam may eenna ki dhettsade. Ko dahaannaar, kinin dhesoono Wannisin shivensa bishne. ");
INSERT INTO amf_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Kidiar Ayiwd eensa bukin raqinte kurtumbhima giyan ki yedade. Bhirsqillabee Aqilabe kinin giyenam yinin qansen wodanka yinka kiam entsate nivayse Barjosa goynam ena kinin dhesera saskayse kina ke giyade. ");
INSERT INTO amf_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Kidiar Akaya peendar yivota yinin zagon wodanka, Epsoon katamante dahaana Barjodar woylamin qajayna eena kiam ke wocchinsade; ogora Akaya peente dahaana Barjodar woylamin qajayna eenana kiam kenin tiyoadettsi warqat ke thaapade. Abhiloosaar Akaya peente yinin yeskenka, Barjosa sunin imintonka Barjodar woylamin qajaynaam kattsi ki kelshade. ");
INSERT INTO amf_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ogonoar Yesus Barjoyn qadhaa Kiristoos kinin dohonam Mathaap Gazara dhettsada gebhi kantaka een wulsa birante palimayna Ayiwd eenaam ki bashade. ");
INSERT INTO amf_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Abhiloosaar Qorontoos katamante ki daaka, Bhawloos bhaabar sagayse Epsoon kataman yeskayse, waani waani Barjodar woylamin qajaana eenaam ogote ki haapade. ");
INSERT INTO amf_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","“Barjodar woylamin yenin qajon wodanka, Manpas Gazanam yedi tiydu?” kena ki hamade. Kediar “Tiyootone; Manpas Gazan dohonamaar qansootone” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Kidiar “Yin ko hanna, har shiidhimbhe ye shiidhimbhaa?” kena ki hamade. Kediar “Wannissa shiidhimbhenkane” ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Bhawloosaar “Wannis yisa budonte niveadar woylamin kenin qajoadettsi eenana giyada seesonam yisa garayse Barjodar kenin maatonam dhaana keam ki shivade; agaa Wannissa budonte nivaa Yesusne” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ogoam yinin qansenka Imbaa wontea Yesussa naabenka ke shiidhade. ");
INSERT INTO amf_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Bhawloosaar aaninam yisa kedar ki wodaysaka, Manpas Gazano kedar ko hanchade; apo abkaar ke dhalqade; pir Barjokala qansayse eenna ke giyade. ");
INSERT INTO amf_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Igina eena wul kidar tabhi lamaaddhane. ");
INSERT INTO amf_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Bhawloosaar Ayiwd eensa bukin raqinte ardayse Barjo bitamonsa kinin giyenam gonne hamayse kenin tiyoadettsi palimada arpi makkamaddha kekal kurtumbhima kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Waani waani eena iinka siyon bavaana eena Imbaa wontea Yesussa goynam eensa birante iirada, “Wodi hanin giyenam gonne hamayse tiyattone” ke hamaysaka Bhawloos kekalanka ki edimade. Barjodar woylamin qajayna eenaam yinka tiyayse Thiranoosin eenaam dhettsen ooninte rooro wul eenaam kida dhettse. ");
INSERT INTO amf_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Bhawloos ogoam kinin hayoono leve lamaaddhane. Ogonante Isiya peente dahaana Ayiwd eenabee Girik eena wulbe Imbaa wontea Yesus goynsa kedi qansidine. ");
INSERT INTO amf_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Barjo Bhawloossa aaninka kattsi tarshen yer ki hayade. ");
INSERT INTO amf_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ogo goynka eena Bhawloossa bishin kaamaa apala yinka tiyayse hajadhaana eenaam kenin kaamenka, kesa burqora keda paashe; beeronaar kedara keda ute. ");
INSERT INTO amf_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Beeronamaar eenadara bulada hamotear yaayayna waani Ayiwd eena “Bhawloosin giyea Yesussa naabenka yenin utoadettsi yena ida giye” hamaate beeronaam eendara bulota ke zagade. ");
INSERT INTO amf_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ayiwd een gudullasa hayoa Asqewasa naana tobbhaanaar yin hayte ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ko dahaannaar beerono “Yesusam dhesayda dhese; Bhawloosamaar dhesayda dhese; yedi kina haybene?” hamayse kena ki maasade. ");
INSERT INTO amf_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Beeron yindar dahaa ea kedar bhulayse ke wulam qanada ki bashade; kesa bishin hajimbhaysaka ogo oonira pundiri gobate ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ogonoar Epsoon gidir dohoono eeno wul Ayiwd eenabee Girik eenabekal konin qansimonna kedi wul kurtumbhan ke yedade. Imbaa wontea Yesussa naabeno kattsi ko gobshadhade. ");
INSERT INTO amf_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Barjodar woylamin qajaana eenasa shaarira thoothino eeno yinin waadadhon siyon waadimanam buuthada nivite ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Palpalan hayayna eenasaar thoothina eena een wulsa birante palpalan kenin hayen mathaapinam pucchayse ke koqade. Mathaapinasa bazanam paydadhenka eedi lamaa kaysa apo tabhi shii (50,000) birre ko maatade. ");
INSERT INTO amf_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ogoka Imbaa wontea Yesussa dhacchintan goynam giyayno upsino kattsi workaatebee bashaatebe ko yivade. ");
INSERT INTO amf_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ogo wulsa budonte, Bhawloos yisa woylaminka “Moqodoonia peenbee Akaya peenbeka sagayse Yerusaalem ida yive; ogote inin yeskonsa budonte, Roome katamandar yiva iam ko zaske” hamayse ki bhocchade. ");
INSERT INTO amf_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ogonante yimbesana waadimayna eenasa eedi lamaa, Thimaatoosbee Erasthoosbeam, Moqodoonia peente yittsayse kidi yinti likka wodana Isiya peente ki dooqade. ");
INSERT INTO amf_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ogo wodanka Imbaa wontea Yesussa goynna Epsoon katamante goore gebhi ko dhaabhade. ");
INSERT INTO amf_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Anngamo birre paxea Dimethiroos hambhea eedi kalaa barjono Arthemissa gazan ooninsa kamsi maatea anngamo birrera ashkayse thoothina anngamon birren paxayna eenana koymo thoothi ki hapsade. ");
INSERT INTO amf_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Dimethiroosaar anngamon birren paxaynabee kedettsi waadadhayna waani eenabeam eelayse yikal keam pucchayse, “Yedi kina eenato, wodi koymon wonin haapayno waadiman ogoka konin dohonam dheseeda dhese. ");
INSERT INTO amf_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Agaa Bhawloos ‘Eedi aanka ashkaana barjona gon barjotehe’ hamayse Epsoon gidir bish dayma Isiyaar thoothino eeno kinin giyenam gonne konin hamoadettsi, keam kinin dhaddhinsonam yedi haapidine, pir yedi qansidine. ");
INSERT INTO amf_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ogo goynka wosa waadimanam baginta bish dayma, Isiya peentebee peen wulir dohon eeno wul yinin goodimayno gembho barjono Arthemissa gazano onno pootima maatayse koda shidhe; Arthemissa gembhakono sun koda shidhe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Eenaar ogoam yinin qansenka kattsi dhagadhayse, “Wo Epsoon eenasa barjono Arthemis kodi gembhone” hamada ke ilatade. ");
INSERT INTO amf_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kataman wulir goore ko dhaabhade; eenaar kinka kalaa maatayse Bhawloosbesana yaayayna Moqodoonia eena Gayoosbee Aristhirokoosbeam yedayse gochate bukin raqinte keam ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Bhawloos bukaana eenakal yivota ki zagaysaka, Barjodar woylamin qajayna eena kinin yivoamadettsi kiam ke marade. ");
INSERT INTO amf_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Isiya peenam wottsayna eenasa kisa nasho maataana waani waani eenaar Bhawlooskal eedi yittsayse, “Eenin buken raqinte yivayse hanin haapadhoamadettsi!” hamayse kiam ke miskade. ");
INSERT INTO amf_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Eenasa shaarinte kattsi goore yinin dohonna, thoothino eeno harrna yinin bukonam dhesehe. Ogona antina yer waana giyaate keda ilate; antinaar tapir yer waana giyaate keda ilate. ");
INSERT INTO amf_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Waani waani Ayiwd eena Iskindirosam yisa shaarira eensa birante kiam ke woysade; antina payya hayayse kinin palimoadettsi kiam ke kiilade. Iskindiros lay kenin hamoadettsi aanka dhahayse paliman ki yedade. ");
INSERT INTO amf_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ko dahaannaar Iskindiros Ayiwd eedi kinin dohonam eeno wul yinin dhesenka, “Wo Epsoon eenasa barjono Arthemis kodi gembhone” hamaate savaat lamaaddha wulatte ke ilatade. ");
INSERT INTO amf_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Macchindar katamansa thaapin waadadhea ea eenaam lay haysayse kena yin ki giyade: “Yedi kina Epsoon eenato, gembho Arthemissa gazan ooninbee cecira hanchon kosa kamsinbeam yenin toolayno een wulna dhesimidine. ");
INSERT INTO amf_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Koam buudane hamea eedin qolmonna, lay yenin hamoadettsibee yer kalaa gibayse yenin hayoamadettsibe yeam koda zaske. ");
INSERT INTO amf_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Harrna hambhidianna, onna gazanaam buuraammabee wosa barjono Arthemisam iiraamma eenabeam kote yedate ye nivade. ");
INSERT INTO amf_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ta Dimethiroosbee kimbesana kinka dahaana anngamon birren paxayna eenabe eediam bersana kenin zagenna, pirdayna eena daane; pirdin imbhensa woda daane; ogote yivayse ke palime. ");
INSERT INTO amf_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ab yer yenin zagea daa ko hanna, zarsino yigginin giyendettsi bukayse ko shede. ");
INSERT INTO amf_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Harrna hambhidianna, kina haydhon yerinna ‘Goore ke dhaasade’ hamayse wonin bersadhoamadettsi woda kurtumbhe. ‘Kono gooreno harka ko dhaabhaa?’ hamayse woam oysadhidianna, wonin imea malsi wokal qolehe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ogoam yinin giyonsa budonte, bukaana eena yisa onnadar kenin yivoadettsi keam ki yittsade. ");
INSERT INTO amf_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ogo gooren woyonsa budonte, Bhawloos Barjodar woylamin qajayna eenaam yikal eelayse keam kiilate ki wocchinsade; ogora keam nagaysayse Moqodoonia peendar ki yivade. ");
INSERT INTO amf_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Peen ogoka sagaate yinin yivenka, Barjodar woylamin qajaana eenaam thoothi kiilimeka keam wocchinsayse Girik peendar ki yivade. ");
INSERT INTO amf_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ogotear arpi makkam yinin dooqonsa budonte bazindara sagadhen gonngalante ardayse Sooria peendar yivota kinin hayenka, Ayiwd eena kina siya kenin ooshonam dhesayse Moqodooniaka maatayse yivota ki qaabade. ");
INSERT INTO amf_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Beeria kataman ea Bhirhus naasa Sobhathirosbee, Teselonqe kataman eena Aristhirokoosbee, Sikondusbee, Derbe kataman ea Gayoosbee, pir Thimaatoosbee, Isiya peen eena Tikiqoosbee, Thiropimoosbe kimbesana kinka ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Kedi woam birayse yivayse Thirovadda gidir ke toolade. ");
INSERT INTO amf_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Wodiar irshonin qolmin balashan kummadhen bavaalinsa budonte, Pilbhisoos katamara bazindara sagadhen gonngalanka dhaabhayse rooroa dongsoaka Thirovaddar kekal yeskayse rooro tobbhaa ogote wo dooqade. ");
INSERT INTO amf_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Gabansa bira rooroa balashanam kashate kinka kummota bukayse wo daaka, Bhawloos sedhiman yivota yinin hayenka, bukaana eenana giyada dhalqinamaar sootin kiaddha lamanka yekka ki gudubhsade. ");
INSERT INTO amf_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Wonin bukon ooninsa zulonte woysadhon ooninte thoothi shaaka ko dahade. ");
INSERT INTO amf_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ewtheekis hambhea naasi barsh kalaa ooninsa maskootindar ki dooqade. Bhawloos dhalqinam kinin gudubhsonna naasa agaam kattsi gindhe kiam ko yedade; gindhenin kiam bashonna, ooninsa zulonte woysadhon oonin makkansonsa maskootra mia ki dhambade; eenin kiam dhaasenka, diyayse ki dahade. ");
INSERT INTO amf_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Bhawloosaar hanchayse naasadar yirk hamayse naasaam incayse eenna “Kidi sadaka daane; targadheebhode!” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ogora Bhawloos maatate utayse Barjodar woylamin qajayna eenabesana kinka balashanam ki itsade. Peenin sedhenka yekka eenbesana kinka dhalqayse ki yivade. ");
INSERT INTO amf_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Eenaar dhaqaa naasaam kisa oonindar ke tiyade; ogonante kedi wozadhayse kattsi ke wocchimbhade. ");
INSERT INTO amf_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Bhawloos Asoos kataman rooka yivota yinin qaabonna, birayse wodi ogote yeskayse kiam wo tiye ki zagade. Ogonante bazindara sagadhen gonngalante ardayse Asoos katamandar wo yivade. ");
INSERT INTO amf_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Asoos gidir Bhawloosbesana kinka keerayse bazindara sagadhen gonngalanka kiam tiyayse Mithilin katamandar wo yivade. ");
INSERT INTO amf_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Burin ogora dhaabhayse Kiyoos peensa birante dohon raqindar wo yeskade; ogoraar kina hamon dhaabhayse Saamoosdar yivayse kina hamon Milithi kataman wo yeskade. ");
INSERT INTO amf_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Bhawloos Isiya gidir kappana yinin zagaamonna, Epsoon ardima sagayse yivota ki qaabade. Ogonoar, yi damidianna, Bhentheqosthe bavaalam Yerusaalem gidir saskana zagayse ki gibade. ");
INSERT INTO amf_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Bhawloos Milithi katamara Epsoon katamante eedi yittsayse misken ooninsa donzanaam yikal ki elsade. ");
INSERT INTO amf_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kikal ke nivaysaka kena yin ki giyade: “Isiya gidir inin ardorra yedayse rooro wul yembesana kinka hamin inin dohonam yedi dheseeda dhese. ");
INSERT INTO amf_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ayiwd eena idar siya hayota ooshayse gaalebee eepibeam ke bavaakaar inta metenam isa toskayse Imbaa wontea Yesusna i waadadhade. ");
INSERT INTO amf_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Thoothin eenin buken raqintebee yesa onnarbe yeam i dhettsade; yena pooten wulam inin giyenka shiishaatine. ");
INSERT INTO amf_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ayiwd eenabee Ayiwdtay hamma eenabe seeson waadimanam garayse Barjodar ke maatebee wosa Imbaa Yesus Kiristoosdar woylamin ke qajebe hamayse wocchinsayse kena i tarjade. ");
INSERT INTO amf_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Taar iam Manpas Gazano kantaka konin dhaasonna Yerusaalem ida yive. Ogote har idar yeskenam dhesattine; ");
INSERT INTO amf_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ko dahaannaar dhaxibee gaalebe idar konin yeskenam Manpas Gazano kataman wul gidir ina wocchinsayse koda giye. ");
INSERT INTO amf_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Inta gobenbee Imbaa wontea Yesuskalanka inin tiyoono waadimanbeam inin macchoadettsi, ogo Barjosa sunin imintonsa dhacchintan upsinam giyana ‘Sadano inno ina poota ko poote’ hamayse qaabattine. ");
INSERT INTO amf_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Taar marrato! Inta Barjosa bitamon goynsa giyada ye wulsa shaarinte inin yaayoono keeda kaara os iam yenin haapiminam dhesayda dhese. ");
INSERT INTO amf_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ogonante inta een wulsa zombhira gaza ea inin maatenam kina rooroaka yena ida tarje. ");
INSERT INTO amf_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Harrna hambhidianna, Barjosa qaabon wulam yena giyara hamin ko dahaakaar shiishaatine. ");
INSERT INTO amf_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Yisa Naasasa zombhinka kinin shanoono Barjosa misken ooninam yenin tooloadettsi Manpas Gazano yeam misken ooninam toolayna hayayse konin kamonna, Barjo een wulbee yennon metenbeam gishee. ");
INSERT INTO amf_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Inin yivonsa budonte yaanana burqadhima sarea yaayodettsi maatayna eena yesa shaarinte kenin ardenam dhesayda dhese. ");
INSERT INTO amf_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Tapir yesa shaarira waani waani eena dhaabhayse wobon dhalqinam giyaate Barjodar woylamin qajayna eenaam yidar keda maase. ");
INSERT INTO amf_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ogonante leve makkam sootinbee rooronbe eepada ye kalaa kalaana inin kiilonam bhocchada qaymayse toolee. ");
INSERT INTO amf_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Taar Barjobee kisa sunin imintonsa upsinbena yeam inta elqimidine; ogono upsino yeam wocchinsanabee gazisadhaana wulsa shaarinte raq yena imana dameabene. ");
INSERT INTO amf_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Inta haysaar birrebee, worqibee, apalabe anngardhaatine. ");
INSERT INTO amf_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Inta aanin innonka imbee imbesana waadadhaynabena zaskenam waadadhayse inin haaponam yedi yenti dheseeda dhese. ");
INSERT INTO amf_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","‘Tiyea eadara imea kattsi gobshadhaane’ hamayno Imbaa wontea Yesussa dhalqinam bhocchintaka idettsi waadadhaate eedi kantaysa qolminaam kelsha woam zaskenam goyti wulka yena inta dhaydine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ogoam yinin giyonsa budonte Bhawloos kumpurdhayse ke wulbesana Barjoam ki miskade. ");
INSERT INTO amf_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Kedi wulaar kattsi eepaate Bhawloosam incayse ke sunqade. ");
INSERT INTO amf_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Kattsi qaabonka kenin atoono “Keeda kaara os iam haapattene” kinin hamonnane. Ogora bazindara sagadhen gonngalankal kimbesana yivayse kiam ke suudade. ");
INSERT INTO amf_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Kekalanka wonin edimonsa budonte, bazindara sagadhen gonngalante ardayse dhari Qoos peendar wo yivade. Ogora kina hamon Ruud peen wo yeskade. Ogoraar Bhathira katamandar wo yivade. ");
INSERT INTO amf_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ogote pir Pinqe peendar yivea gonngala haapayse kanka yivan wo yedade. ");
INSERT INTO amf_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Qobhiroosam shedayse wosa warkatambar koam garayse Sooria peente Thiroos katamante wo yeskade; harrna hambhidianna, bazindara sagadhen gonngalante dohon koymonam ogote buldhennane. ");
INSERT INTO amf_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Barjodar woylamin qajayna eenaamaar zagate haapayse kembesana kinka rooro tobbhaa wo dooqade. Kedi Manpas Gazanka entsadhayse Bhawloosna “Yerusaalemdar yivaabhode!” hamayse kina ke giyade. ");
INSERT INTO amf_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Igina roorona maqaysaka dhaabhayse wo yivade; Barjodar woylamin qajayna annginabee, maanabee, naanabe kinka katamansa gasanka yekka woam entsaate ke bulade. Bazinsaar gasante kumpurdhayse Barjoam wonin miskonsa budonte kinka kiam nagaysayse wo edimade. ");
INSERT INTO amf_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Wodi bazindara sagadhen gonngalante wo ardade; kedi yisa onnadar ke maatade. ");
INSERT INTO amf_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Wodiar bazindara sagadhen gonngalanka Thiroosra dhaabhayse Bhethelemays kataman wo yeskade; ogotear Barjodar woylamin qajaynaam nagaysayse kembesana kinka rooro kalaa haaqayse wo wodhade. ");
INSERT INTO amf_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ogora kina hamon dhaabhayse Qesaaria kataman wo yivade. Eenna galan ke kashe kambhaana tobbhaanasa kalaa, Barjosa dhacchintan upsin giyea Pilbhooskal ooninte ardayse kimbesana kinka wo dooqade. ");
INSERT INTO amf_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Pilbhoossa anza kembhaamma oydi Barjokala qansayse eenna giyayna ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Thoothi rooro ogote wonin dohonsa budonte Agaabos hambhea Barjokala qansayse eenna giyea Yiwda peera ki nivade. ");
INSERT INTO amf_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Wokal nivayse Bhawloossa qalbathanam tiyayse yisa aaninbee roonbeam dhaxayse, “Manpas Gazano ‘Qalbathan kosa imbaam Yerusaalemir dahaana Ayiwd eena yin dhaxayse Ayiwdtay hamma eenana kiam saskate keda ime’ hamayse ina ko giyade” wona ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ogoam wonin qansenkaar wombee ogote dahaana eenabe Bhawloos Yerusaalemdar kinin yivoamadettsi miskite wo dahade. ");
INSERT INTO amf_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Bhawloosaar “Eepada isa woylaminam yenin koqayno harrnane? Inta Imbaa wontea Yesussa naabenna hamayse Yerusaalem gidir dhaxi bish dayma, diyanaar ashkimbhidine” hamayse wona ki maasade. ");
INSERT INTO amf_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Wonin kiilenam qansattine kinin hamonna, “Keeda Barjosa bhocchi ko dee” hamayse wo garade. ");
INSERT INTO amf_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Igina rooronasa budonte, ashkimbhayse Yerusaalem yivana wo dhaabhade. ");
INSERT INTO amf_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Qesaaria gidir dahaana waani waani Barjodar woylamin qajayna eenaar wombesana kinka ke nivade. Kediar wonin dehen Minasoon oonindar woam ke entsade; kidiar birana Barjodar woylamin qajaana eenasa kalaa Qobhiroos peen eedine. ");
INSERT INTO amf_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Yerusaalem wo yeskaysaka Barjodar woylamin qajayna eena wozaka woam ke tiyade. ");
INSERT INTO amf_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kina hamon Bhawloos wombesana kinka Yayqoob oonindar ki yivade; misken ooninsa donzana wul ogote wo hanna ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Bhawloos keam yinin nagaysonsa budonte, yisa waadimanka Barjo Ayiwdtay hamma eenasa shaarinte kinin waadadhon wulam shiishima kena ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Kediar ogoam yinin qansenka Barjoam ke gobshade. Ogosa budonte, Bhawloosna yin ke giyade: “Wosa imbanaasa, Ayiwd eensa shaarira Barjodar woylamin qajaana thoothi shii kenin dohonam hada haape; kedi wul Musesa yiggin goynka kattsi woogimbhayna eenane. ");
INSERT INTO amf_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ya Ayiwdtay hamma eenasa shaarinte dahaana Ayiwd eena wulna ‘Yesa naanasa qaamanam taxeebhode; yesa sharqanam tooleebhode’ hamayse giyntaka Musesa yigginam kenin garoadettsi hada dhettse hamayse giidhaka kedi qansidine. ");
INSERT INTO amf_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","“Ta hamin ko haydhe? Hanin nivonam kesa qansano shidhehe. ");
INSERT INTO amf_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ogonante wonin hana giyenam hayaa. Wosa shaarira mallaysa dahaana eedi oydi ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Iginaam hanka tiyayse kembesana kinka haam gazinsaa; kesa meten haadadhayse kenin gazimbhoadettsi imbhen koymonam kena kashaa. Koam hanin hayenna hadar giidhayno wul sun konin dohonbee ya hamal Musesa yigginam toolea hanin dohonbeam Ayiwd eena wul keda dhese. ");
INSERT INTO amf_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","“Barjodar woylamin qajaana Ayiwdtay hamma eenana ko hanna, ‘Aaninka ashkadhaana barjonana marshan machadhon waankalankabee, zombhinkalankabee, taxadhima diyaana qollasa waankalankabee, pir sharmucimakkonkalankabe yenin pegimbhoadettsi ko zaske’ hamen upsinam warqatdar thaapayse kena wodi yittsidine” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ogona kina hamon Bhawloos eenaam entsate nivayse kembete ki gazimbhade; Barjosa gazan ooninsa mayante ardayse gazimbhan waadimanam kenin maccheabee ke kalaa kalaanana Barjona marshan machadhea rooroabesa aan ki qunthade. ");
INSERT INTO amf_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Roorona tobbhaana maqana hayenka, Isiya peera nivaana Ayiwd eena Bhawloosam Barjosa gazan ooninsa mayante yinin haapenka, een wulam dhaasayse kiam ke yedade. ");
INSERT INTO amf_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“Israveel eenato, woam kelshee! Wosa eenbee, yigginbee, raqin kobeam bagaate peen wulir dohon een wulam dhettsea ea kaane. Pir Girik eenaam Barjosa gazan ooninsa mayante arsintaka ogo gazisadhon raqinam minngisidine” hamayse ke ilatade. ");
INSERT INTO amf_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ogoam kenin giyoonoar birayse Epsoon ea Thiropimoosam Bhawloosbesana kinka katamante yinin haaponna, Bhawloos Barjosa gazan ooninsa mayante kiam kinin arsaa kena konin maatonnane. ");
INSERT INTO amf_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Kataman wul eeno targadhayse saana bukayse Bhawloosam yinka gochate kerminsa mayanka kiam ke bulade; saana Barjosa gazan ooninsa kermin kerram ke diithade. ");
INSERT INTO amf_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Eeno Bhawloosam deesana konin zagenka, “Yerusaalem katamano wul targadhayse ko jeekade” hamayno dhalqino Roome shii alaqakal ko yeskade. ");
INSERT INTO amf_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ogonante kidi saana poolisanabee mato alaqanabeam yinka tiyayse gobaka Ayiwd eenakal ki yivade. Kediar shii alaqabee poolisanabeam yinin haapenka, Bhawloosam qanan ke garade. ");
INSERT INTO amf_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Shii alaqa theedayse Bhawloosam yedayse sansala lamaaka kinin dhaxadhoadettsi ki giyade. Ogora hay kinin dohonbee har kinin waadadhonbeam oysan ki yedade. ");
INSERT INTO amf_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Zarsino waani waani yer kala konin giyenka, waani kesa pir yer waana ko giyade. Ogonante shii alaqaar zarsinsa ilatira dhaabhon gonin hamon dhalqinam dhesana yinin damaamonna, Bhawloosam poolisanayn dohon raqindar kinin tiidhoadettsi ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Bhawloos tigate utadhen kerinkal kinin yeskenka, eensa gebhi wacimenka dhaabhoono poolisana Bhawloosam kedayse ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ogono eenoar “Kiam deesee!” hamayse ilatada kesa paananka keda yive. ");
INSERT INTO amf_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Poolisanaar yinin dohon raqinte kiam arsana kenin hayenka Bhawloos shii alaqaana “Yer kalaa i hana giyoadettsi ya ina ee hamaa hamo?” hamayse kiam ki oysade. Kidiar “Ya Girik aponam dhesaa dheso? ");
INSERT INTO amf_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ya Roome bitaadar goore dhaasana kosa birayse een deesayna shii oydi eenaam hanka entsate darandar yivaa Gibth eatayu?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Bhawloosaar “Inta Kilqia gidir dhesimon Therses katamante adhadhaa Ayiwd eedine. Bannzo! Eenna inin giyoadettsi ina giyaa” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Kidiar kina ee ki hamaysaka Bhawloos kerinsa utadhendar woyayse eeno lay konin hamoadettsi aanka kena ki dhahade. Eenin lay hamenka Ibra aponka eenna yin ki giyade: ");
INSERT INTO amf_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Imbanaanato, ta inin yena palimada marimenam qansee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ibra aponka kinin giyenam kenin qansenka, ini hamora kattsi lay ke hamade. Kidiar kena yin ki giyade: ");
INSERT INTO amf_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Inta Kilqia gidir dohon Therses katamante adhadhaa Ayiwd eedine; inin gebhoono ogo Yerusaalem katamantene. Wosa eykenasa yigginkaar payya hayayse ina dhettsaa Gamalialne; yedi wul ta yenin hayendettsi Barjo goynka woogintan ea i dahade. ");
INSERT INTO amf_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Eena annginabee maanabeam yedate dhaxin ooninte dhaxada Barjodar woylamin qajayna eenaam kenin diyenka yekka keam i oytade. ");
INSERT INTO amf_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ogoam gudullasa gebhaabee peensa donzana wulbe tarja ke tarje. Pir Demasqor dahaana imbaanaanana kenin thaapon warqatin kekalanka tiyayse Demasqo katamante dahaana Barjodar woylamin qajayna eenaam dhaxayse kenin dhabshadhoadettsi Yerusaalem keam bavana kedar i yivade. ");
INSERT INTO amf_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Inin yivenkaar rooron cakkonka Demasqo yeskana inin hayenka, i qaabima cecira kattsi shaaka isa gasante ko shaakade. ");
INSERT INTO amf_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ogo wodanka intaar peendar i dhambade. ‘Sawl, Sawl! Harrnaa iam oytaye?’ ina hamea upsi i qansade. ");
INSERT INTO amf_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Intaar maasayse ‘Imbo, ya hayne?’ i hamade. Kidiar ‘Inta hanin oytayea Naazret ea Yesusne’ ina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","“Imbesana kinka dahaana eenaar shaakanam ke haapade; ina giyeasa upsinam qansadehe. ");
INSERT INTO amf_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Intaar ‘Imbo, hariy hayo?’ i hamade. Imba Yesusaar ‘Dhaabhayse Demasqodar yivaa; hanin waadadhoadettsi zasken yerin wul ogote hana giidhasane’ ina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","“Shaakara dhaabhonka isa aapinin haapimonna, imbesana kinka dahaana eena isa aaninam yedayse iam entsate Demasqo ke yeskisade. ");
INSERT INTO amf_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Demasqo gidir dahaana Ayiwd eena wul kina kenin tarjea, Musesa yiggindettsi Barjoam miskintaka wocchimbhaa Hanania hambhea eedi kalaa ki dahade. ");
INSERT INTO amf_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Kidi ikal nivayse isa gasante woyayse, ‘Imbanaasa Sawl, aapino hanno pir ko shede’ ina ki hamade; saanawa aapin isa shedaysaka kiam i haapade. ");
INSERT INTO amf_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Kidiar ina yin ki giyade: ‘Wosa eykena Barjo kinin qaabonam hanin dhesoadettsibee, tipaa ea Yesusam hanin shedoadettsibee, kidi yinti hana kinin giyen upsinam hanin qansoadettsibe haam ki kamade. ");
INSERT INTO amf_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Harrna hambhidianna, hanin haaponbee hanin qansonbe goynka een wulsa birante kisa tarja ha maatene. ");
INSERT INTO amf_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ta harrnaa kappe? Dhaabhayse shiidhimbhe shiidhimbhaa; Yesussa naabenam eelayse hasa seesoraar shiidhaa’ ina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Yerusaalem inin maatonsa budonte, Barjosa gazan oonin mayante inin miskenka Barjoyn ina dhohon shedintonam i haapade. ");
INSERT INTO amf_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Imba Yesusaar ina haapadhayse, ‘Goyn innonsa hanin tarjenam eeno qansehe. Ogona dhaabhaa, saana Yerusaalemra utaa’ ina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Intaar ‘Imbo, ena inta Ayiwd eensa bukin raqin wulir yaayada hadar woylamin qajaana wulam inin dhaxenbee inin qanenbeam kedi yinti dhesa ke dhese. ");
INSERT INTO amf_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Hasa tarja maataa Isthipaanoosin deesadhon wodanka, inta deesaynasa gasante woyayse kembesana kinka agayse kesa apalanam i toolade’ i hamade. ");
INSERT INTO amf_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Imba Yesusaar ‘Ayiwdtay hamma eenakal pege inin haam yittsenna, dhaabhayse yivaa!’ ina ki hamade” Bhawloos ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ogoam kinin giyenka yekka eena Bhawloossa dhalqinam ke qansade. Ogora upsi gebhika “Ogodettsin waadiman hayea eam peera ko kaysadhe! Sadaka daa kiam zaskehe!” hamayse giyan ke yedade. ");
INSERT INTO amf_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Kedi ilataate apalanam yisa bulayse dhabada, pee dumate cecindar ke laalaka, ");
INSERT INTO amf_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","shii alaqa Bhawloosam poolisanayn dohon gurdante kiam kenin arsoadettsi ki giyade. “Yin eena harrna kidar kenin ilatenam dhesana qanada kiam marmaree” ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Masaka kiam dhaxadhaysaka Bhawloos theedi kalan woyaa mato alaqaana “Roome eedi maataam pirdadhima kinin qandhoadettsi yigginka giidhidu?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Mato alaqa ogoam yinin qansenka, shii alaqakal yivayse, “Ya har hayoa daa? Ea kaa Roome eedine” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Shii alaqaar Bhawlooskal nivayse, “Ya Roome eediw? Ina giyaa” kina ki hamade. Kidiar “Ee” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Kidiar “Inta thoothi birre kashayse Roome eedi i maatade” kina ki hamade. Bhawloosaar “Inta inin adhadhorra yedayse Roome eedine” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ogonante kiam qanada marmarana qaabaana eena saanawa kiam ke garade. Shii alaqaar Roome eedi kinin dohonam yinin dhesenka, sansalanka kiam kinin dhaskonna ki kurtumbhade. ");
INSERT INTO amf_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Kina hamon shii alaqa Ayiwd eena harrna Bhawloosam kenin bersonam kosa goninam dhesana zagayse kiam bulayse gudullasa hayonabee Yiwda peensa donzana wulbe kenin bukoadettsi ki giyade; Bhawloosam kesa birante bavayse ki woysade. ");
INSERT INTO amf_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Bhawloos Yiwda peensa donzanaam may shedayse, “Imbanaanato, inta kinaka yekka Barjo birante qaabo payyaka i dahade” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Gudullasa gebhaa Hanania Bhawloossa apon kenin qanoadettsi kisa gasante woyaana eenana ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ogo wodanka Bhawloos Hananiana “Ya bhalbhaltonka galthadhaa kubaa, Barjo haam qanasane. Yigginka idar pirdota dooqayse yiggi qolma inin qandhoadettsi ha giyo?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bhawloossa gasante woyaana eena “Barjoyn wodaa gudullasa gebhaam ha iiro?” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Bhawloosaar “Imbanaanato, gudullasa gebhaa kinin dohonam dhesaatine. Harrna hambhidianna, ‘Hasa eenaam wottseadar siya giyaabhode’ hamayse thaapadhidine” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Eenasa antina Saduqa eedi, antina Parisa eedi kenin dohonam Bhawloos dhesayse, “Imbanaanato, inta Parisa eenakalanka adhadhaa Parisa eedine; ta idar pirdana kote iam woysadhoono ‘Diyaana eenasa dhaabhinta daane’ hamayse Barjodar qaabe inin hayennane” hamayse Yiwda peen donzanasa birante upsi gebhika ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Bhawloos ogoam ki giyaysaka, Parisa eenabee Saduqa eenabesa shaarinte wacime ko dhaabhade; ogona Yiwda peensa donzana raq lamaadar ke kashimade. ");
INSERT INTO amf_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Harrna hambhidianna, Saduqa eena “Dembhira dhaabhintabee, Barjosa gaanabee, manpasbe qolehe” hamayse keda giye; Parisa eena “Igina wul daane” hamayse keda giye. ");
INSERT INTO amf_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ogoka kattsi wacimeyn thoothenka, Parisa eensa shaarira waani waani Musesa yigginam dhettsayna eena dhaabhayse, “Ea agaadar yer kala hattear siya haapootone. Manpas way Barjosa gaana kina giydi ki hannas? Wodi dhesattone” hamayse kattsi ke palimade. ");
INSERT INTO amf_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Eena kattsi kenin wacimonna, Bhawloosam kenin ripayoamadettsi shii alaqa ki kurtumbhade; ogona poolisana kesa shaarira Bhawloosam kantaka sarayse yinin dohon raqinte kenin arsoadettsi ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kina hamon sootin Imbaa wontea Yesus Bhawloossa gasante woyayse, “Hay, kurtumbhaabhode! Yerusaalem gidir innon goynsa hanin tarjondettsi, Roome gidirar hanin tarjoadettsi haam koda zaske” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Peen sedhaysaka Ayiwd eena kinka bukayse ke ooshade. “Bhawloosam deesima galaar itsattone; noqoar wucattone” hamayse kinka dhalqayse ke mallade. ");
INSERT INTO amf_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ogo ooshinam kinka dhalqaana eena eedi lamaa kaysara sagi maatayna eenane. ");
INSERT INTO amf_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Kediar gudullasa hayonabee donzanabekal nivayse, “‘Bhawloosam deesima yer kalaar itsattone’ hamayse kinka wodi mallidine. ");
INSERT INTO amf_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ogonante yedi Yiwda peensa donzanabesana kinka dhalqayse Bhawloosam payya marmarayse dhesana yenin zagaadettsi maatayse, Bhawloosam yekal kinin bovoadettsi shii alaqakal yittsee. Wodiar ogote ki yeskima kiam deesana ashkimbhidine” ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ko dahaannaar Bhawloossa indanaansa naasa ogo kesa dhalqinam qansayse poolisana dohon raqinte ardayse Bhawloosna ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Bhawloosaar mato alaqa kalaam eelayse, “Naasa kaam shii alaqakal yeskisaa; yer kina kinin giyea daane” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mato alaqaar yinka kiam entsate nivayse shii alaqakal, “Dhaxadhaa Bhawloos yikal iam eelayse, naasa kaam hakal inin yeskisoadettsi iam ki miskade; naasa hana yer kinin giyea daane” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Shii alaqaar naasasa aaninam yedate ososoa gasa bulayse, “Ina hanin giyayno yer hare?” hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Naasaar “Ayiwd eena payya hayayse kiam marmarayse dhesana kenin zagaa yer dahaadettsi maatayse, saka Yiwda peensa donzanakal Bhawloosam hanin yeskisoadettsi haam oysana kedi kinka dhalqidine. ");
INSERT INTO amf_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ko dahaannaar ya kena ee hamaabhode; harrna hambhidianna, kesa iira ‘Kiam deesima gala itsattone; noqoar wucattone’ hamayse eedi lamaa kaysara sagayna eena kinka dhalqayse ke mallade. Ki dhesima kiam deesana goynte toolada ke dahade. Kediar hasa malsin kaalite ke dahade” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Shii alaqaar “Yerin koam ina hanin giyondettsi eedi haynaar giyaabhode” hamayse naasaam ki yittsade. ");
INSERT INTO amf_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Shii alaqa mato alaqana lamaanaam eelayse, “Sootin savaat makkam maataysaka Qesaariadar yivayna eedi tabhi kaysa roonka yivayna poolisanabee, eedi makkam kaysa apo tabhi pardandar dooqayna poolisanabee, eedi tabhi kaysa banqi bavayna poolisanabeam ashkee. ");
INSERT INTO amf_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Bhawloosnaar parda ashkayse peen wottsea Pilkiskal payyamoka kinin yeskoadettsi hayee” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Yin giyea warqat wottseakal ki thaapade: ");
INSERT INTO amf_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Gobshadhaa peen wottsea Pilkis, inta Qelawdoos Lusiyoos ‘Nagaya, payyaw?’ hana ida hame. ");
INSERT INTO amf_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","“Ea agaam Ayiwd eena yedayse deesana kenin hayenka, Roome eedi kinin dohonam dhesayse inna poolisanabesana yeskayse kiam i dhacchade. ");
INSERT INTO amf_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Yer harka kiam kenin bersenam dhesana Ayiwd peen donzanasa birante kiam entsate i nivade. ");
INSERT INTO amf_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Yisa yiggin dhalqin goynsa kenin kiam bersonam i dhesade; ogonoar dhaxibee dembhibena kiam yeskisaynotehe. ");
INSERT INTO amf_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","“Ayiwd eena ki dhesima kiam deesana kenin ooshondettsi ina giidhonam qansayse saana hadar kiam i yittsade. Kiam bersayna hasa birante kiam kenin bersoadettsi kena inta giydine” hamayse kina ki thaapade. ");
INSERT INTO amf_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Poolisanaar yina giidhondettsi Bhawloosam tiyayse sootinka Antibhathiroos katamante kiam entsate ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Sedhiman pardandar dooqayna poolisana Bhawloosbesana kinka kenin yivoadettsi keam garayse, waani poolisanayn dohon raqindar ke maatade. ");
INSERT INTO amf_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ogora pardandar dooqayna poolisana Qesaaria katamante ardayse warqatinam peen wottseana imayse Bhawloosam kisa birante ke woysade. ");
INSERT INTO amf_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Peen wottsea warqatinam yinin nabbabonsa budonte, hamo peera kinin nivonam Bhawloosam ki oysade. Kilqia peen ea kinin dohonam yinin dhesenka, ");
INSERT INTO amf_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“Haam bersaana eena nivayse kenin giyenka, hasa dhalqinam ida qanse” hamayse ena Herodisin woyson kerminte kinin toldhoadettsi ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Rooro dongsa budonte, gudullasa gebhaa Hanania waani waani donzanabee Therthelus hambhea kena palimea eabesana kinka Qesaaria kataman nivayse peen wottseasa birante Bhawloosam ke bersade. ");
INSERT INTO amf_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Bhawloosam eldhaysaka Therthelus yin giyayse bersan ki yedade: “Gobshadhaa Pilkiso, hanka thoothi payyamo wodi haapidine; payyan hasa wottsintankaar zarsino wonno ookime haapidine. ");
INSERT INTO amf_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ogo payyan hasa waadiman goynka hamote ko hannaar, rooro wulka kattsi haam woda shawke. ");
INSERT INTO amf_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Keeda ha qajadhima orgo inin giyenam lemmakkoka hanin qansoadettsi haam ida miske. ");
INSERT INTO amf_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Ea kaa wona hajimo maatayse peendar dohon Ayiwd een wul goore ke dhaase hayeabee Naazret eena hambhaynasa dhaddhisintaka dhettsaynasa entsabe maatayse ki daaka kiam wo haapade. ");
INSERT INTO amf_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Barjosa gazan ooninamaar minngisana ki hayaka kiam wo yedade. Wosa yigginkaar kidar pirdana wodi qaabidine. ");
INSERT INTO amf_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ko dahaannaar shii alaqa Lusiyoos nivayse gebhi kantaka wosa aanira kiam ki tiyade. ");
INSERT INTO amf_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Kiam bersaynaar hakal kenin nivoadettsi ki giyade. Ya hantika yer ogo wulka kiam marmarayse dhesana damaada dame” ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ayiwd eenaar “Ogono yerro wul gonne” hamayse kisa beerimenka ke agade. ");
INSERT INTO amf_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Peen wottsear Bhawloos ki giye aanka ki dhahaysaka, Bhawloos yin ki giyade: “Thoothi levedara yedayse peen kosa pirdea hanin dohonam inin dhesenna, wozaka palimensa malsi hana ida maase. ");
INSERT INTO amf_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Barjona goodimana Yerusaalem inin yivaara yedayse kinaka yekka tabhi lamaa roorodara konin sagimonam ya hanti dhesana damaada dame. ");
INSERT INTO amf_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Barjosa gazan ooninte ko hannaar, way Ayiwd eensa bukin raqinte, way katamante haybesanaar inin palimenka way eensa shaarinte goore inin dhaasenka iam kedi haapadehe. ");
INSERT INTO amf_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ta iam yinin bersonsa tarja hana bavate imana damehe. ");
INSERT INTO amf_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Ko dahaannaar inin giyea yer gon hama kalaa daane; ogonoar ‘dhaddhisintaka dhettsayna’ kenin hamen goynka ena eykena wonnasa Barjona ida goodime. Musesa yiggintebee Barjokala qansayse eenna giyaynasa mathaapintebe thaapadhoono wulam gonne hamayse tiyayda tiye. ");
INSERT INTO amf_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Barjodar woylam kenin hayendettsi, intaar tipana eenabee tipa maataamma eenabe dembhira kenin dhaabhenam Barjodar qaabe ida haye. ");
INSERT INTO amf_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ogonante inta pir Barjobee eenbesa birante rooro wul siya yer yindar qolma inin doadettsi ida wocchimbhe. ");
INSERT INTO amf_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Yerusaalemra i utaysaka thoothi levesa budonte, inta isa eena qambhinana kelsho maatea birrenam bavayse imanabee Barjona marshan machanabe i nivade. ");
INSERT INTO amf_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Barjosa gazan ooninsa mayantear iam kenin haapoono ogoam inin hayenkane. Ogo wodanka gazimbhintasa waadimanam inta waadadhidine; imbesana kinka thoothi eediar qolehe; goorear dhaabhadehe. ");
INSERT INTO amf_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ko dahaannaar Isiya peera nivaana waani waani Ayiwd eena ogote ke dahade; kedi iam kenin bersea kesa yer daa ko hanna, hakal nivayse iam bersa ini ko keam zaskade. ");
INSERT INTO amf_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ogonotay ko hamma, Ayiwd peen donzanasa birante nivayse inin woyen wodanka, yer idar seeso kenin haapaa daa ko hanna igina eena ke giye. ");
INSERT INTO amf_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Gon kesa shaarinte woyayse upsi gebhika ‘Idar pirdana kina kote iam woysadhoono “Diyaana eenasa dhaabhinta daane” inin hamonnane’ i hamade. Ogora yer ab inin seesaa qolehe” hamayse ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Pilkisaar Yesus goynam payya hayayse kinin dhesonna, “Shii alaqa Lusiyoos nivanna, yesa dhalqinam ida macche” hamayse ki kappisade. ");
INSERT INTO amf_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Mato alaqaar Bhawloosam dhaxima kinin tooloadettsibee kisa nashonasa eedi hayyear kiam oysana kenin nivenka keam kinin maroamadettsibe kina ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Likka roorosa budonte Pilkisbee kisa geshon Ayiwd eedi maaton Dursillabe nivayse Bhawloosam elsayse, Yesus Kiristoosdar woylamin qajintasa kinin giyenka ke qansade. ");
INSERT INTO amf_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Bhawloos tipamonbee, meten hannonam wottsintanbee, nivayno Barjosa pirdinbe goynsa kinin giyenka, Pilkis kurtumbhayse, “Ta ya yivaa; ina agen wodanka eedi yittsayse haam ida else” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Pilkis pir “Bhawloos inin kiam buloadettsi ina birre imasane” hamayse ki qaabade; ogonante thoothi woda yikal kiam elsayse ki dhalqade. ");
INSERT INTO amf_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Leve lamaa thoothonsa budonte, Pilkissa raqinte Bhorqiyoos Pisthoos peen wottsea ki maatade. Pilkisaar Ayiwd eenaam wozisana zagayse Bhawloosam dhaxin ooninte ki garade. ");
INSERT INTO amf_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Pisthoosaar yinin wottsen raqinte ardayse rooro makkam yinin wodhonsa budonte, Qesaaria katamara dhaabhayse Yerusaalem ki yivade. ");
INSERT INTO amf_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Gudullasa hayonabee Ayiwd eensaar shaarira entsaynabe Bhawloosam bersan ke yedade. ");
INSERT INTO amf_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","“Bhawloosam Yerusaalemdar baadhoadettsi payya yer wona waadadhaa” hamayse Pisthoosam kattsi ke miskade. Ogoam kenin giyoonoar Bhawloos dhesima goynte toolayse kiam deesana kenin ooshonnane. ");
INSERT INTO amf_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Pisthoosaar “Bhawloos Qesaaria katamante dhaxadhayse toldhite ki dahade; intaar saana maatayse ogote ida yive. ");
INSERT INTO amf_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Yesa hayonaar imbesana kinka Qesaaria ke yive; Bhawloosin waadadhaa seeso daa ko hanna, ogote kiam ke berse” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Pisthoos rooro lankay way tabhidara sagimin kembesana kinka yinin dooqonsa budonte, Qesaaria katamandar ki yivade; kina hamon pirdin raqindar yisa dooqayse Bhawloosam kinin baadhoadettsi ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Bhawloos nivaysaka Yerusaalemra nivaana Ayiwd eena kisa gasante woyayse kidar tarja haapadhimin thoothi detha maataa dhalqka kiam bersan ke yedade. ");
INSERT INTO amf_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Bhawloosaar “Ayiwd eenasa yiggi ko dahaakaar, Barjosa gazan oonin ko dahaakaar, Roome peen bita ki dahaakaar, inin seesaa yer kala hattear qolehe” hamayse ki palimade. ");
INSERT INTO amf_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Pisthoosaar Ayiwd eenaam wozisana zagayse Bhawloosna “Yerusaalem yivayse ogo dhalqinsa hana inin pirdoadettsi ya ee hamaa hamo?” hamayse kiam ki oysade. ");
INSERT INTO amf_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Bhawloosaar “Inta pirdadhana zasken Roome peen bitaasa pirdin raqinsa birante woydine. Pir ya payya hayayse hanin dhesendettsi Ayiwd eendar seeso waadadhaatine. ");
INSERT INTO amf_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ta dembhina iam yeskisea seeso waadadhidi i hanna, dembhira dhaqana giyattine; ko dahaannaar igina eena iam kenin bersayno gon ko dahaamma, kena iam saskate imea eedi qolehe. ‘Roome peen bitaadar iam yittsaa’ hana ida hame” ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ogo wodanka Pisthoos kiam kiilayna eenabesana kinka dhalqayse, “‘Roome peen bitaadar iam yittsaa’ hanin hamonna, daran yivaada yive” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Likka roorosa budonte, Bitaa Agirbhabee Barniqebe Pisthoosam nagaysana Qesaaria katamandar ke nivade. ");
INSERT INTO amf_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ogotear thoothi rooro kenin dooqonna, Pisthoos Bhawloossa dhalqinam yin giyayse bitaana ki giyade: “Pilkisin dhaxayse garaa eedi kalaa kote daane. ");
INSERT INTO amf_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Yerusaalemir inin dohonka gudullasa hayonabee Ayiwd eensa donzanabe kidar inin pirdoadettsi iam miskada kiam ke bersade. ");
INSERT INTO amf_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Intaar ‘Bersadhaa bersaynasa birante woyayse kiam bersadhonsa ki palimima saskate kiam imano Roome eenin bulaa dambitehe’ hamayse kena i maasade. ");
INSERT INTO amf_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","“Ogonante kiam bersayna eena bukayse kenin nivonsa, kappima kina hamon pirdi raqindar dooqayse eam baadhoadettsi i giyade. ");
INSERT INTO amf_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Kiam bersanaar ke woyaysaka, ‘Kidi kattsi siya yer ki waadadhaysaka keda berse’ hamayse inin qaaborra yer kala hattear kiam pirdina yeskisea qolehe. ");
INSERT INTO amf_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ko dahaannaar kimbesana kinka kenin palimoono Ayiwd eena Barjodar woylamin kenin qajonsabee Bhawloosin ‘Sadaka daane’ kinin hamea diyaa Yesussabene. ");
INSERT INTO amf_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","“Intaar yerin koam marmarayse dhesana inin gaalonna Bhawloosna ‘Yerusaalem yivayse ogote hasa dhalqinna pirdadhoadettsi ya ee hamaw?’ kina i hamade. ");
INSERT INTO amf_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Bhawloosaar ‘Isa dhalqinam Roome peen bitaanin shedenka yekka, dhaxin ooninte i dooqe’ kinin hamonna, bitaakal kiam inin yittsenka yekka, dhaxin ooninte kinin doadettsi i giyade” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agirbhaar Pisthoosna “Intaar ea agaanin giyenam inti qansana ida zage” ki hamade. Pisthoosaar “Saka kinin giyenam qansaada qanse” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ogona kina hamon Agirbhabee Barniqebe gebhi gobshika nivayse shii alaqanabee katamante dahaana gembha eenabesana kinka pirdi ooninte ke ardade. Pisthoosaar “Ki baadhe” hamayse ki giyaysaka, Bhawloosam ko baadhade. ");
INSERT INTO amf_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Pisthoosaar yi giyna: “Bitaa Agirbhabee yediar wombesana kinka dahaana eena wulbe, ‘Keeda kaara os sadaka daa kiam zaskehe’ hamayse ilatada Ayiwd eena wul Yerusaalembee kotebe kidar pirdadhoadettsi iam kenin miskaa ea kaane. ");
INSERT INTO amf_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Intaar dembhina kiam yeskisea yer kinin hayaamonam i haapade. Kidiar ‘Roome peen bitaadar iam yittsaa’ kinin hamonna, kiam bitaadar yittsana qaabayse i woysade. ");
INSERT INTO amf_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Kinnon goynsa isa bitaakal inin thaapea gon hama yer qolehe. Ogonante kiam marmardhonsa budonte, yer inin thaapea ina haapadhasane hamayse, yesa birante, kattsika Bitaa Agirbha, hasa birante kiam entsate i nivade. ");
INSERT INTO amf_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Harrna hambhidianna, dhaxadhaa eam yittsadhenka kiam bersadhonsa warqat thaapayse kanka yittsadhaammo yer malgimmakko ina ko maatade” ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agirbha Bhawloosna “Hannon metensa hanin giyoadettsi hana giidhidine” kina ki hamade. Bhawloosaar aaninam yisa pishkayse yin giyayse paliman ki yedade: ");
INSERT INTO amf_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Bitaa Agirbha, Ayiwd eenanin iam berson yerin wulna kina hasa birante palimensa malsin inin maasenka kattsi ida wozadhe. ");
INSERT INTO amf_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Harrna hambhidianna, ya Ayiwd eenin bulon sharqanbee kesa dhalqinbe wulam payya hayayse hada dhese. Ogonante inin giyenam darshayse hanin qansoadettsi haam ida miske. ");
INSERT INTO amf_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Inta eensa shaarintebee Yerusaalem gidirbe maatonam naasamora yedayse hamin inin dohonam Ayiwd eena wul dhesa ke dhese. ");
INSERT INTO amf_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Tarjana ke nashidianna, Barjosa yigginam kattsi toolayna Parisa eedi maatayse inin dahaadettsi enara yedayse iam kedi dhesidine. ");
INSERT INTO amf_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","“Taar Barjo wosa eykenana ‘yena imayda ime’ kinin hamon upsin goynka kidar qaabe inin hayonna idar pirdota kote iam ko woysadhade. ");
INSERT INTO amf_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Wosa muldhana tabhi lamaa sootibee roorobe wocchimbhayse Barjona kenin goodimenka, ogo Barjo ‘yena imayda ime’ kinin hamonam tiyana toolite ke dahade. Bitaa Agirbha, ogo bhocchin goynka Ayiwd eena iam bersite ke dahade. ");
INSERT INTO amf_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Barjo diyaanaam dhaasea kinin dohonam ‘gontehe’ harrnee hame? ");
INSERT INTO amf_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Ena inta ‘Naazret Yesussa naabenam jibbayse yer thoothi siya haya ko iam zaske’ hamayse i qaabade. ");
INSERT INTO amf_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Yerusaalem gidir inin hayoono ogodettsine. Gudullasa hayonakalanka hayamo tiyayse, Barjodar woylamin qajayna eenasa thoothina eenaam dhaxin ooninte keam ida dhaxe; keam deesadhenkaar deesayna eenabesana kinka inta wormidine. ");
INSERT INTO amf_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ayiwd eenasa bukin ranqaar thoothi woda keam dhabshayse Barjodar woylamin yinin qajenamaar kenin garoadettsi ida haye. Kattsi kedar inin dhagadhonna, pee abir dohon katamante yivayse keam ida oytaye. ");
INSERT INTO amf_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Bitaa, ogo goynka gudullasa hayonakalanka hayamobee ergebe tiyayse Demasqo katamandar inin yivenka, ");
INSERT INTO amf_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","goynte i daaka rooron haynin kiaddha hamenka, hayra sagayno shaaka cecira imbee inka yivayna isa aanammabesa gasante konin shaakenam i haapade. ");
INSERT INTO amf_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Wodi wul peendar wo dhambaysaka, ‘Sawl, Sawl! Harrnaa iam oytaye? Haam uxen anngamonam qapan ha garaamma, hana kattsi siyane’ hamea upsi Ibra aponka i qansade. ");
INSERT INTO amf_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Intaar ‘Imbo, ya hayne?’ i hamade. Imbaar ina yi giyna: ‘Inta hanin oytayea Yesusne. ");
INSERT INTO amf_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ko dahaannaar dhaabhayse roon hannonka woyaa. Harrna hambhidianna, ta iam hanin haaponbee os birante hana inin haapadhenbe goynka ina waadima eedibee isa tarjabe hanin doadettsi haam kamana hana i haapadhade. ");
INSERT INTO amf_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Israveel eenabee kekal haam inin yittsayno Ayiwdtay hamma eenabesa aanira haam dhacchayda dhacche. ");
INSERT INTO amf_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Thipara shaakandar keam hanin buloadettsibee Seethaanin wottserra Barjodar keam hanin maasoadettsibe kesa aapinam ha bule haam i kamade. Kediar idar woylamin yinin qajenka seesonsa garintonam haapa ke haape; yiam gazisadhaana waani eenabesana kinka Barjosa bitamonam keda tiye’ ina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Bitaa Agirbha, ogonante cecira ina haapadhonsa ina giidhonam aavav hamaatine. ");
INSERT INTO amf_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ko dahaannaar birayse Demasqobee, Yerusaalembee, Yiwda peen wulir dohon eenbee, Ayiwdtay hamma eenbena seeson waadiman garayse Barjodar kenin maatoadettsibee Barjodar kenin maatenam eshkea waadima kenin waadadhoadettsibe kena inta giydine. ");
INSERT INTO amf_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ogonante Ayiwd eena Barjosa gazan ooninsa mayante iam ke yedade; deesanaar iam ke zagade. ");
INSERT INTO amf_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","23","Kinaka yekka Barjosa kelshonam i haapade; ogona likkanabee gembha eenabena tarjada inta woydine. Barjokala qansayse eenna giyaynabee Musebe ena birayse ‘Barjoyn qadhaa Kiristoos gaale haapa ki haape; diira dhaabhintakaar bira maatayse dhaqintasa shaaka kena shaakendettsi Israveel eenabee Ayiwdtay hamma eenabena Kiristoos kida giye’ kenin hamonam giyara yer ab giyaatine” Bhawloos ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Bhawloos palimen koam kinin giyenka Pisthoos upsi gebhika “Bhawloos, ya ta bardhidine! Thoothi hanin timmiroono haam barinte ko arsade” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Bhawloosaar yin giyayse kina ki maasade: “Gobshadhaa Pisthoos, goninbee gaz hamonbeam ida giye; bardhaatine. ");
INSERT INTO amf_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Bitaasa birante may inin giyayno kidi yerin koam kinin dhesennane. Yerin ogosa kala hattear kidi dhesadehe inta hamattine; harrna hambhidianna, ogono aachika waadadhadhoono yertehe. ");
INSERT INTO amf_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Bitaa Agirbha, ena Barjokala qansayse eenna giyaynasa dhalqinam gonne hamayse tiyaa tiyo? Hanin tiyenam dhesayda dhese” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agirbhaar Bhawloosna “Ya ta likka wodasa iinte Kiristoosdar woylamin qajea iam hayota zago?” kina ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Bhawloosaar “Likka wodaar ko dee; thoothi wodaar ko dee; ya bish dayma, kina isa dhalqinam qansayna wul isa dhaxira ab yer wulka idettsi yenin maatoadettsi Barjoam ida miske” ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ogora bitaabee, peen wottseabee, Barniqebee, kembesana kinka dooqaana eenabe dhaabhayse, ");
INSERT INTO amf_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ogora utayse kenin yivenka, “Ea kaa dembhibee dhaxibe kidar yeskisea seeso waadadhadehe” hamayse kinka ke dhalqade. ");
INSERT INTO amf_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agirbhaar Pisthoosna, “Ea kaa ‘Roome peen bitaadar iam yittsee’ ki hamaamma, kiam bulate sun yittsa dandima ko dandime” ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Thaalian peente bazindara sagadhen gonngalanka wonin yivoadettsi qaabadhon wodanka, Bhawloosbee waani dhaxin eenbeam Yuliyoos hambhea Roome bitaa banqin eenasa mato alaqaana keam ko imbhade. ");
INSERT INTO amf_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Isiya peensa gasante dahaana ranqadar yivanna hayayno Adramithiyon katamara nivon bazindara sagadhen gonngalante ardayse wo dhaabhade; Moqodoonia gidir dahaa Teselonqe ea Aristhirokoosaar wombesana kinka ki dahade. ");
INSERT INTO amf_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Kina hamon Sidoona katamante wonin yeskenka, Yuliyoos Bhawloosna payya kinin dohonna, kiam zaskenka kenin kelshoadettsi yisa muldhanakal ki yive ee ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Raqin ogora bazindara sagadhen gonngalanka dhaabhayse wonin yivenka wuranin wosa birante jibarshonna, woam konin galshoamadettsi bazinsa shaarinte dohon Qobhiroos peensa demenka wo yivade. ");
INSERT INTO amf_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Kilqia peenbee Bhinpilia peenbesa gasante dohon bazindara wonin sagonsa budonte, Loqia peente dohon Muura kataman wo yeskade. ");
INSERT INTO amf_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ogote mato alaqa Thaaliandar yiven Iskindira katamara nivon bazindara sagadhen gonngala haapayse gidir woam ki arsade. ");
INSERT INTO amf_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Rooro thoothi leemayse wo yivade; thoothi gaaleka Qenidoos katamansa gasante wo yeskade. Wuranoar os birante wonin yivoamadettsi konin maronna, Selmoona katamansa gasante bazinsa shaarinte dohon Qerthes peensa demenka wo yivade. ");
INSERT INTO amf_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Gebhi gaalekaar gasan gasanka Laasia katamanna theeden “Payya Ukunse Raq” hambhente wo yeskade. ");
INSERT INTO amf_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Wonin yivenka thoothi rooro yinin maqonna, Ayiwd eenayn itsima Barjoam miskea rooroa maqidi kinin dohonna, bazindara sagadhen gonngalanka ta yivana kattsi kurtunsayno ko maatade. Ogona Bhawloos eenaam yin giyayse ki bhocchisade: ");
INSERT INTO amf_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Marrato, keeda wosa birante yivana wonin dohon goynte gaaleyn dohoono ina ko haapadhe; gaalenoar bazindara sagadhen gonngalanbee kosa iinte wodadhon koymonbedar bish dayma wodarar yeskasane” hamayse keam ki kiilade. ");
INSERT INTO amf_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Mato alaqa Bhawloossa kiilimera kattsi bazindara sagadhen gonngalansa hayoabee kosa imbaabe kenin giyenam ki qansade. ");
INSERT INTO amf_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ogo bazinsa gasante dohon ranqinte gonngalanam woysayse barginam ogote saskana konin agimonna, thoothino eeno “Kora dhaabhayse wo damidianna, Pinqe yivayse barginam ogote wo saske” hamayse kinka ke dhalqade. Pinqe katamano bazinsa shaarinte dohon Qerthes peentene; ogo Pinqekal dohoono bazino hayn utensa mizaqimbarbee warkatambarbe ko dahade. ");
INSERT INTO amf_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Tokaa jibare hayn utensa mizaqimbar dhaabhayse jibarshen kenin haapen wodanka, “Wonin qaaboono ko maatade” hamayse ogora dhaabhayse Qertheskal theedi gasanka ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ko dahaannaar, kappima hayn utensa warkatambar “Awraaqis” hambhayno wurano gembho dhaabhayse bazinsa shaarinte dohon peera utayse bazindar ko nivade. ");
INSERT INTO amf_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Bazindara sagadhen gonngalanam wuranin kupayse bashonna, gonngalanam qanan wo garaysaka lay hamayse wuranka kupadhaate wo yivade. ");
INSERT INTO amf_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Qeeda hambhen bazinsa shaarinte dohon likkon peensa demenka yivayse, bazindara sagadhen likkon gonngalanam gaaleka dhacchana wo damade. ");
INSERT INTO amf_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Gonngala likkaam tura bulayse bazindara sagadhen gebhon gonngalante ke arsade. Ogosa budonte gebhon gonngalanam zaanika dhaxayse Surtis hambhen shaamin dohon raqinte konin dhamboamadettsi kurtumbhayse gonngalandar dhaxadhon apalanam hanchayse wuranin keam kupenka ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Wuranoar kantaka woam kattsi konin jugenka, kina hamon gonngalante dohon eensa koymora bazinte dhaban ke yedade. ");
INSERT INTO amf_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Makkansoa rooroaka gonngalansa koymora tiyayse yisa aanka ke dhabade. ");
INSERT INTO amf_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Thoothi rooro haynbee wanconbeam wonin haapaamonna, pir wuranin garaamonna, “Keeda wodi dhaqattone” hamayse woylam wo taxade. ");
INSERT INTO amf_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Eena yer itsima thoothi rooro kenin kapponsa budonte, Bhawloos kesa shaarinte woyayse yin ki giyade: “Marrato, inin giyenam qansayse Qerthesdara ye dhaabhaamma, ko gaalenbee kayenbe wodar yeskehe. ");
INSERT INTO amf_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Taar ‘Hay, kurtumbheebhode!’ hamayse yeam ida kiile. Kono bazindara sagadhayno gonngalanoda kaye; yesa iira eedi kalaar kayehe. ");
INSERT INTO amf_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Harrna hambhidianna, inta kinti maataabee pir kina inin goodimeabe Barjosa gaana sootin ogo ikal theedi woyayse, ");
INSERT INTO amf_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘Bhawloos, kurtumbhaabhode! Roome peen bitaasa birante woya haam ko zaske. Shedaa! Barjo hambesana kinka yivayna wulam hana kida dhacche’ hamayse ina ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ogonante marrato, hay, kurtumbheebhode! Barjo ogo ina yinin giyonam kinin hayenna kidar woylamin qajayda qaje. ");
INSERT INTO amf_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ko dahaannaar wurano bazinsa shaarinte dohon peen kallonsa gasandar kupate yivayse woam kosa dhabano shidhehe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Tabhi oytson sootinka Meditiranian bazinte wuranka gaalada wonin kupadhenka, sootin kiaddha laman bazindara sagadhen gonngalante waadadhayna eenana peensa gasandar kenin yeskaa ko maatade. ");
INSERT INTO amf_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ogonante bazinsa theeramon shedana zaani kenin dhabenka, kosa theeramono eedi oydi kaysa dhundhuma mia ko daaka ke haapade. Likka yivayse zaaninam kenin dhabenka, eedi makkam kaysa dhundhuma mia konin dohonam ke dhesade. ");
INSERT INTO amf_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Seenindar konin thuqumoamadettsi kurtumbhayse gonngalanam woysea anngamo oydi os budobar bazinte ke dhabade; ogoraar peenin sedhoadettsi Barjoam ke miskade. ");
INSERT INTO amf_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Gonngalante waadadhaynaar iira hanchate dhaqana zagayse gonngalanam woysen anngamon birante yinin dhabeadettsi maatayse, likka gonngalaam bazindar ke hanchade. ");
INSERT INTO amf_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ogo wodanka Bhawloos mato alaqaabee poolisanabena “Igina bazindara sagadhen gonngalante waadadhayna eena gonngalante ke qolmina, yedi dhaqana damattene” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ogonante poolisana likka gonngalaam bazindar hanchayse kinin yivoadettsi kiam yedon zaaninam ke taxade. ");
INSERT INTO amf_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Peen sedhamba hayenka Bhawloos gala kenin itsoadettsi een wulam ki miskade. “Yer kala hattear itsima kinaka yenin kappaana roorona tabhi oydine. ");
INSERT INTO amf_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ogonante gala yenin itsoadettsi yeam ida miske; ogono yenin payya doadettsi koda haye. Hamin ko dahaakaar gaale kala hattear yedar yeskehe” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Ogoam yinin giyonsa budonte, balashan tiyayse een wulsa birante Barjoam ki gobshade; ogora balashanam qunthayse itsan ki yedade. ");
INSERT INTO amf_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ogo wodanka wul wocchimbhayse gala ke itsade. ");
INSERT INTO amf_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Bazindara sagadhen gonngalante dahaana wodi eedi tabhi makkam kaysa apo tabhi laxne. ");
INSERT INTO amf_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Yina yeekenam kenin itsonsa budonte, yinin bovon gazgonam bazinte dhabada gonngalansa dethamonam ke sholbhicchade. ");
INSERT INTO amf_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Peen sedhaysaka yinin yeskon peenam dhesadehe. Ko dahaannaar bazinsa gasante dohon bazinin ulon uxaa raqaasa shaaminam shedayse, yi damidianna, bazindara sagadhen gonngalanam os iir kupana ke qaabade. ");
INSERT INTO amf_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Gonngalanam woysen anngamonamaar bulayse bazindar ke garade. Ogo wodanka kanka yinin qanensa zaaninam ke bulade; pir birante dohon apalanam jibarendar tura woysayse bazinsa gasandar utota ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ko dahaannaar gonngalano bazina lamaana kinka kidar kenin kaamon raqinsa shaaminte dhambayse kosa wotino yedadhayse shoymino ko maatade; kosa budombar wuranin kupenna ayan ko yedade. ");
INSERT INTO amf_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Poolisanaar dhaxadhaana eenasa eedi kala hattear waarada dhaqayse kenin yivoamadettsi keam deesana kinka ke qaabade. ");
INSERT INTO amf_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Mato alaqa Bhawloosam dhacchana yinin zagonna, kesa bhocchinam ki marade. Waaran dhesayna eena birayse bazinte bhulayse waarada gasandar kenin sagoadettsi ki giyade. ");
INSERT INTO amf_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Shidhaana eenasa antina gonngalansa haaqanbee antina gonngalansa qunthimonbeam yedayse kenin yivoadettsi ki giyade; ogodettsi eena wul payyamoka peendar ke yeskade. ");
INSERT INTO amf_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Payyamonka peen wonin yeskonsa budonte, wonin yeskoono ranqo bazinsa shaarinte Malta hambhayno pee konin dohonam wo dhesade. ");
INSERT INTO amf_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Peen ogote dohoono eenoar tarshea payya yer wona ke waadadhade; doobinin qanenka peenin qajonna nuu guttsayse wo wulam ke tiyade. ");
INSERT INTO amf_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Bhawloosaar haaqa kamayse nuundar kinin wodenka, nuunsa oydhamora dhaabhonka haaqansa iira guni qarshi utayse kisa aaninam gavayse ko ziitimade. ");
INSERT INTO amf_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Kedi peen eenaar kisa aanindar gunin ziitimon yinin haapenka, kinka kikal “Kaa ea gon eedi deesaa eedine; bazira payyamoka utayse ki dhaqaakaar, pirdin imea barjo sadaka kinin doadettsi hayehe” ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ko dahaannaar Bhawloos guntaam aanira jugayse nuunte ki dhabade; yer siya kala hattear kidar yeskadehe. ");
INSERT INTO amf_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Eena “Taaki saana kisa bishino koda ettse way diyayse kida dhambe” hamayse ke kaalade. Ko dahaannaar thoothi kenin shedenka kidar yer siya kenin haapaamonna, “Kaa eedi dayma, barjone” hamayse qaabonam yisa ke ookade. ");
INSERT INTO amf_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Agaa raqakal theedi Malta peensa hayoa Pupiliyoos hambhea easa haami ko dahade; kidi woam chocchayse rooro makkamna payyamoka ki tiyade. ");
INSERT INTO amf_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Pupiliyoossa imbaar bishi occheabee haarintebeka hajadhayse wodhayse ki dahade. Bhawloosaar kikal ardayse Barjoam ki miskade; aaninam yisa kidar wodayse kiam ki pacchade. ");
INSERT INTO amf_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ogo yin konin maatonsa budonte, shidhaana bazinsa shaarinte dohon peente hajadhaana eena wul Bhawlooskal nivaate keda paashe. ");
INSERT INTO amf_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Thoothi goytika woam ke gobshade; yivana wo dhaabhaysakaar bazindara sagadhen gonngalante wona zasken yer ke wodade. ");
INSERT INTO amf_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Arpi makkamsa budonte, barginka ogo Maltar kappon Iskindira katamara nivon bazindara sagadhen gonngalaka wo dhaabhade; gonngalandar Diyosqoroossa milkit daran ko dahade. ");
INSERT INTO amf_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Sirakus katamante wodi yeskayse rooro makkam gidir wo dooqade. ");
INSERT INTO amf_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ogoraar dhaabhayse Regiyum katamante wo yeskade. Ogotear rooro kalaa wonin haaqonsa budonte, hayn utensa mizaqimbar jibarenin jibarshenna lansoa rooroaka Putiyolos katamandar wo yivade. ");
INSERT INTO amf_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ogotear Barjodar woylamin qajayna eenaam wo haapade. Kediar rooro tobbhaa wonin kekal dooqoadettsi woam ke miskade. Ogora Roomedar wo yivade. ");
INSERT INTO amf_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Barjodar woylamin qajayna wosa qansayse Roome katamara dhaabhayse Apiyoos Gabanbee “Wodhintan Onna Makkam” hambhen raqinbeka yekka woam tiyana ke nivade. Bhawloosaar keam yinin haapenka Barjoam ki gobshade; kidiar yisa woylaminka ki wocchimbhade. ");
INSERT INTO amf_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Roome kataman wo yeskaysaka, Bhawloosam toolea poolisabee kimbe bish kenin doadettsi ko giidhade. ");
INSERT INTO amf_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Rooro makkamsa budonte, Bhawloos Ayiwd eenasa gembha eenaam yikal ki eelade. Ke bukaysaka kena yin ki giyade: “Imbanaanato, inta wosa eenaam way wosa eykenasa dambinam jibbayse yer kala hattear i hayma Yerusaalemir inin dhaxadhoadettsi Roome eenasa aaninte yettsayse iam ke imade. ");
INSERT INTO amf_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Kedi Roome eena payya kenin marmarenka, dembhina yeskisea yer idar qolmonna, iam bulana ke zagade. ");
INSERT INTO amf_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ayiwd eena ‘Kiam buleebhode’ hamayse ke giyaysaka, inta ‘Roome peen bitaadar iam yittsee’ hamayse inin giyayno yer shidha shidhimino ko maatade; ko dahaannaar inta isa eenaam inin bersea yer qolehe. ");
INSERT INTO amf_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ogonante yeam shedanabee yembesana kinka dhalqanabe yeam i eelade. Inta ko sansalanka inin dhaxadhoono Barjo Israveel eenana ‘yena imayda ime’ kinin hamon upsin goynka kidar qaabe inin hayonnane” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Kediar “Wodi hasa Yiwda peera warqat tiyootone; wosa imbanaanasa kala hattear wokal nivayse hannon goynsa siya yer wona giyadehe. ");
INSERT INTO amf_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Kono hanin bovon eenin yindar woylamin qajen goynam hamote ko hannaar, ‘siyane’ hamayse eenin giyenam wodi dhesidine; ogonante hasa bhocchinam qansana zagooda zage” kina ke hamade. ");
INSERT INTO amf_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Aan kina qunthayse thoothi maatayse kinin dohon raqinte kikal ke nivade; kidiar burira yedayse ibanenka yekka, Barjosa bitamon goynsa kena tarjada Yesussa kenin tipisoadettsi Musesa yiggirabee Barjokala qansayse eenna giyaynasa mathaapirabe kena ki dhettsade. ");
INSERT INTO amf_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Waani waani eena kinin giyenam gonne ke hamade; waani eena gonne hamana nashadehe. ");
INSERT INTO amf_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Kinka yinin agaamonna, Bhawloos yer kalaa kena kinin giyonsa budonte yivana ke dhaabhade. Ogono kinin giyoonoar yinne: “Manpas Gazano Barjokala qansayse eenna giyea Isiasbar ena birayse yesa eykenana konin giyoono gonne. ");
INSERT INTO amf_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Ogonoar ‘Eena iginakal yivayse, “Qanseeda qanse, bhocchattene; shedeeda shede, haapattene” kena hamaa. ");
INSERT INTO amf_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Aapinka kenin shedoamadettsi, qaaminka kenin qansoamadettsi, woylaminka kedi qaabayse idar ke maataysaka intaar keam pacchoamadettsi, eena kinasa woylammo duudidine; qammoar kesa qansehe; aapinamaar kedi cumbhidine’ hamayse ena ko giyade. ");
INSERT INTO amf_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Keeda ogo Barjosa dhacchintan upsino Ayiwdtay hamma eenakal yittsadhonam dhesee; kediar qansa ke qanse” kena ki hamade. ");
INSERT INTO amf_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Koam ki giyaysaka Ayiwd eena kinka kinka kattsi palimada ke yivade. ");
INSERT INTO amf_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Bhawloosaar koymo kashaate yinin dohon ooninte leve lamaa ki dooqade; kikal nivayna eena wulam wozaka yikal ki tiyade. ");
INSERT INTO amf_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Eedi hayyear kiam marima Barjo bitamonsa giyada Imbaa wontea Yesus Kiristoossa may dhettsite ki dahade. ");
INSERT INTO amf_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Kiristoossa tarjamonnante yittsadhaa maatayse Barjosa dhacchintan upsinam giyana kamayse eldhaa, Yesus Kiristoossa waadima eedi maataa i Bhawlooskalanka nittsadhoono warqannone. ");
INSERT INTO amf_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Ogono Barjosa dhacchintan upsino Barjokala qansayse eenna giyaynasa Mathaap Gazante birayse “yena imayda ime” hamayse kinin imoono qaabe wonin hayayno upsinone. ");
INSERT INTO amf_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Ogono Barjosa dhacchintan upsino kisa Naasasa giyaynone. Kisa Naasaar waanka Dawtsa muldhara ki adhadhade; ");
INSERT INTO amf_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Gazamon Manpasinka dembhira dhaabhintaka gebhi kantaka Barjo Naasi maatayse ki haapadhade; agaa kidi wosa Imbaa Yesus Kiristoosne. ");
INSERT INTO amf_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Inta kisa tarjamonnante yittsadhaa maatana Barjosa sunin imintonam i tiyade; ogonoar kisa naabenna hamayse zarsin wulsa iira kidar woylamin qajayse Barjona ee kenin hamoadettsi keam ida haye. ");
INSERT INTO amf_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Kesa shaarira yedi Yesus Kiristoossa yenin doadettsi Barjoyn eelaana eenane. ");
INSERT INTO amf_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ogonante Roome katamante dahaana Barjoyn nashaynabee gazamonna eldhaana eena wulbena nittsadhoonone. Wosa Imbaa Barjobee Imbaa wontea Yesus Kiristoosbesa sunin imintonbee payyamonbe yena ko dee. ");
INSERT INTO amf_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Barjodar woylamin yenin qajayno peen wulir dhesimaate konin dohonna, yer wulsa birayse Yesus Kiristooska ye wulna Barjoam ida gobshe. ");
INSERT INTO amf_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Kisa Naasasa dhacchintan upsinam eenna giyaate isa woylam wulka Barjona ida waadadhe. Rooro wul Barjoam inin miskenka inin yeam bhocchensa Barjo isa tarjane. ");
INSERT INTO amf_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Ta keeda macchi yekal nivana Barjosa qaabo konin doadettsi Barjoam rooro wul ida miske. ");
INSERT INTO amf_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Harrna hambhidianna, Barjodar woylamin qajintaka yenin wocchimbhoadettsi yeam hayen manpasin imintora yena kashana inin zagenna yeam shedana ida anngardhe. ");
INSERT INTO amf_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Yin inin giyoono inta Barjodar woylamin yenin qajen goynsa, yediar isa Barjodar woylamin qajintan goynka kinka kinka wonin wocchimbhoadettsine. ");
INSERT INTO amf_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Imbanaanato, waani Ayiwdtay hamon eensa shaarinte inin dhettsenka Barjodar woylamin qajaynaam inta haapidine; ogodettsi yeamaar dhettsayse yesa shaarinte Barjodar woylamin qajaanasa aapinam haapota ida zage. Ogona yekal nivana thoothi woda inin qaabenka, ta koka yekka yekal nivana wodanin isa qolmonam yenin dhesoadettsi ida zage. ");
INSERT INTO amf_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Gilon payyan dhesaynabee dhesiminabe, pir timmiraanabee timmiraammabena Barjosa dhacchintan upsinam kena giyana baza idar daane. ");
INSERT INTO amf_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ogonante Roome gidir dahaana yenaar Barjosa dhacchintan upsinam giyana ida anngardhe. ");
INSERT INTO amf_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Inta Barjosa dhacchintan upsinka ooshimbhattine. Harrna hambhidianna, birayse Ayiwd eenana, ogoraar Ayiwdtay hamma eenana, Barjodar woylamin qajayna wul kenin dhaqoadettsi Barjosa kantanone. ");
INSERT INTO amf_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ogonoar Barjo yisa birante eediam tipa kinin maasayno birara yedayse macchinka yekka kidar woylamin qajintaka konin dohonam Barjosa dhacchintan upsino may koda giye. “Barjo birante tipa ea Barjodar woylamin qajintaka sadanam kida haape” hamayse thaapadhondettsine. ");
INSERT INTO amf_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Yisa seeson waadimanka gonin dhesimoamadettsi marayna Barjobee eenbeam kenin genen wulka Barjosa wacime cecira kedar may ko nivade. ");
INSERT INTO amf_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Harrna hambhidianna, Barjo yinnon goynsa dhesana kenin damenam kena yinti may kinin dhohonnane. ");
INSERT INTO amf_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Peen pijadhorra yedayse eenna haapadhimino Barjosa dantano, ogonoar lay dehen kisa kantanbee Barjo kinin dohonbe kinin pijaana yerra goynka may maatayse haapadhidine. Ogonante eena dhesayse seeso kenin waadadhonna, yer kenin giyea qolehe. ");
INSERT INTO amf_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Harrna hambhidianna, kedi Barjoam dhesayna dahayse zasken gobshinam kina imadehe; kisa waadimannaar kiam gobshadehe. Bhocchinka yisa pootimina ke maatade; kesa qaabimino woylammoar ko thipade. ");
INSERT INTO amf_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","“Wodi pakalla eenane” hamayse malgimma eena ke maatade. ");
INSERT INTO amf_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Rooro wul dehea Barjoam kenin gobshen garayse, diyayna pijadhina: eedibee, aptibee, rooysa oydi dahaanabee, peendar gochimayna pijadhaanabeam kamayse kenin ashkaana barjonana gobshin ke imade. ");
INSERT INTO amf_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Ogonante kinka kiam kiam ooshinsea yer kenin waadadhoadettsi Barjo kesa woylaminsa anngarmandettsi minngin yerinna keam ki garade. ");
INSERT INTO amf_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ogonoar Barjosa goninam buudanka ookayse pijaa Barjosa oolonte pijadhaanana kenin goodimonnabee kena kenin waadadhonnabe