﻿USE sofia;
DROP TABLE IF EXISTS sofia.ameNT_vpl;
CREATE TABLE ameNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ameNT_vpl WRITE;
INSERT INTO ameNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Arrpaʼ all aquellcaret̃ Jesucristo paʼtañneshañ eʼñe paʼsoʼchñec̈hnohuenet. Jesucristopaʼ David poʼm̃reneñ, eʼñe Abrahamot̃eñ. Allohuen añ soʼchñetspaʼ ñeñt̃ara mereñtsorecmuet. ");
INSERT INTO ameNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahampaʼ chemereʼtana Isaac. Isaacñapaʼ chemereʼtana Jacob. Jacobñapaʼ chemereʼtana Judá epuet ñam̃a paʼmoʼnasheñec̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judáñapaʼ chemereʼtana Fares epuet ñam̃a Zara. Ñet pachoretpaʼ añ paʼsoʼcheñ Tamar. Faresñapaʼ chemereʼtana Esrom. Esromñapaʼ chemereʼtana Aram. ");
INSERT INTO ameNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramñapaʼ chemereʼtana Aminadab. Aminadabñapaʼ chemereʼtana Naasón. Naasónñapaʼ chemereʼtana Salmón. ");
INSERT INTO ameNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmónñapaʼ chemereʼtana Booz. Ña pachorpaʼ añ paʼsoʼcheñ Rahab. Boozñapaʼ chemereʼtana Obed. Ña pachorpaʼ añ paʼsoʼcheñ Rut. Obedñapaʼ chemereʼtana Isaí. ");
INSERT INTO ameNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaíñapaʼ chemereʼtana David ñeñt̃ am̃chaʼtaret̃tatseʼt̃. Davidñapaʼ chemereʼtana Salomón. Ñeñt̃paʼ arrot̃ Urías puet̃aporot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomónñapaʼ chemereʼtana Roboam. Roboamñapaʼ chemereʼtana Abías. Abíasñapaʼ chemereʼtana Asa. ");
INSERT INTO ameNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asañapaʼ chemereʼtana Josafat. Josafatñapaʼ chemereʼtana Joram. Joramñapaʼ chemereʼtana Uzías. ");
INSERT INTO ameNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzíasñapaʼ chemereʼtana Jotam. Jotamñapaʼ chemereʼtana Acaz. Acazñapaʼ chemereʼtana Ezequías. ");
INSERT INTO ameNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequíasñapaʼ chemereʼtana Manasés. Manasésñapaʼ chemereʼtana Amón. Amónñapaʼ chemereʼtana Josías. ");
INSERT INTO ameNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josíasñapaʼ chemereʼtana Jeconías epuet ñam̃a paʼmoʼnasheñec̈hno. Ñehua, Josíaspaʼ alla chemereʼtos allempo ac̈hapataret̃tet allap̃ar all anetso ñeñt̃ paʼsoʼcheñ Babilonia. ");
INSERT INTO ameNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Allempo huac̈herret Babiloniot̃paʼ Jeconíasñapaʼ chemereʼtuerrana Salatiel. Salatielñapaʼ chemereʼtana Zorobabel. ");
INSERT INTO ameNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelñapaʼ chemereʼtana Abiud. Abiudñapaʼ chemereʼtana Eliaquim. Eliaquimñapaʼ chemereʼtana Azor. ");
INSERT INTO ameNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorñapaʼ chemereʼtana Sadoc. Sadocñapaʼ chemereʼtana Aquim. Aquimñapaʼ chemereʼtana Eliud. ");
INSERT INTO ameNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudñapaʼ chemereʼtana Eleazar. Eleazarñapaʼ chemereʼtana Matán. Matánñapaʼ chemereʼtana Jacob. ");
INSERT INTO ameNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobñapaʼ chemereʼtana José ñeñt̃epaʼtchaʼ puerrollar p̃aʼ María. Maríañapaʼ cheyoreʼtana Jesús, ñeñt̃ara ñeñt̃ Cristotats. ");
INSERT INTO ameNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Allempot̃eñ correʼt̃ Abraham t̃arrempohua allempo correʼt̃ ñam̃a David, ñeñt̃ña allponsheña chemereʼshatnomuetspaʼ alloʼtsencaʼye c̈harrasheña puechenet paʼtatssheña. Ñam̃a allempot̃eñ correʼt̃ David t̃arrempohua allempo ac̈hapataret̃tet Babilonio, ñeñt̃paʼc̈hoʼña alloʼtsenerrerr c̈harrasheña puechena paʼtatssheña ñeñt̃ allponsheña chemereshaʼterrtserr allempo. Ñam̃a allempot̃eñ ac̈hapataret̃tet Babilonio t̃arrempohua allempo eñalleta Cristo, ñeñt̃paʼc̈hoʼña alloʼtsenerrerr c̈harrasheña puechenet paʼtatssheñet ñeñt̃ allponsheña chemereshaʼtnerrtserr t̃arrempohua allempo eñalleta ñam̃a Cristo. ");
INSERT INTO ameNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","T̃eʼpaʼ oʼch neserrpareʼtatas att̃o allempo eñalleta Jesús. Allempoña María ñeñt̃chaʼ pachor p̃aʼ Jesúspaʼ añcaʼye oʼpatenaya José ñoʼch yoreʼ. Ama yoreñaʼpaʼ Maríañapaʼ ahuepaʼt ac̈homenta Parets Puecamquëñot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joséña ñeñt̃chaʼ puerrollar p̃aʼpaʼ ñañapaʼ eʼñe cohuen acheñer ñeñt̃oʼmarña ñapaʼ ama mueno oʼch pencach. Ñañapaʼ atet̃ cot̃apeʼch oʼch ser eʼñe aʼnahuot̃a. ");
INSERT INTO ameNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Allempoña atet̃ cot̃apeʼchenpaʼ machayot̃oʼ orrtoña Yompor poʼm̃llañot̃eñer. Ñeñt̃ orrtoya puec̈hopoñopaʼ atet̃ otos: —José Davidnaʼtare, amach p̃aʼllpatsto; pocteʼcaʼye oʼch peyore María ñeñt̃chaʼ pet̃apor pep̃aʼ t̃arroʼmar ñapaʼ oʼcaʼye ac̈homenta Parets Puecamquëñot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","T̃eʼpaʼ eñalletatanchaʼ asheñorr, ñeñt̃ñapaʼ pesochchaʼ Jesús t̃arroʼmar ñapaʼ ñeñt̃chaʼ aʼqueshp̃aterreʼ paʼcheñer poʼchñarot̃et. Arrpaʼ allohua ñeñt̃ atet̃ och mellañot̃eñ. ");
INSERT INTO ameNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ñeñt̃paʼ t̃arroʼmar atet̃ p̃a att̃och etsota ñeñt̃ atet̃ eñoranaʼtaneʼt̃ Isaías ñeñt̃ aʼm̃tahueteʼt̃ Yompor poʼñoñ, ñeñt̃paʼ atet̃ oteʼt̃: ");
INSERT INTO ameNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ñeñt̃ña shopsheshaʼpaʼ amach aʼp̃llaret̃ot̃eyeʼ ac̈homento; cheyoreʼtanach asheñorr, ñeñt̃ñapaʼ sochetchaʼ Emanuel. Ñeñt̃ ña soʼchñetspaʼ atet̃ oten: T̃eʼña Paretspaʼ eʼñe parroʼtseney. ");
INSERT INTO ameNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Allempoña José oyerr ñemot̃, atet̃ och Yompor poʼm̃llañot̃eñerpaʼ ñañapaʼ atet̃c̈hoʼ p̃a. Yoran María ñeñt̃chaʼ puet̃apor p̃aʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","T̃arraña ñapaʼ ama aʼp̃lleñe t̃arrempohua allempoch emareʼtua; ñeñt̃ña asheñorrpaʼ soch JESÚS. ");
INSERT INTO ameNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Allempo eñalleta Jesús all Beléño, eʼñe alla Judeopaʼ añ am̃chaʼtaret̃tatseʼt̃ Herodes. Oʼña eñalletuapaʼ eñotañneshaʼña huac̈haʼtet allot̃ huena atsrret̃paʼ oʼ c̈hac̈haʼtet Jerusaléño. ");
INSERT INTO ameNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ñetñapaʼ atet̃ otyesoset: —¿Erroʼtsenaʼtña ñeñt̃ eñalletatsa ñeñt̃chaʼ paʼm̃chaʼtaret̃er p̃aʼ judioneshaʼ? Yapaʼ yeñoteñ oʼ eñalleta t̃arroʼmar yapaʼ oʼ yentoñ poʼrantor allot̃ huena atsrret̃; yapaʼ ñeñt̃ecopña yehuena oʼch yeconcorpanaʼteñaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Allempoña am̃chaʼtaret̃ Herodes eʼman atet̃ ñoñetspaʼ ñañapaʼ ñeñt̃a naʼ pueyoc̈hro ama eñmato pueyoc̈hro. Allohuen jerusaléñoʼmarneshaʼpaʼc̈hoʼña ama eseshaʼ eñmatatseto ñamet pueyoc̈hreto. ");
INSERT INTO ameNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Allempoñapaʼ agotatan am̃chaʼtaret̃neshaʼ ñeñt̃ara judioneshet; oʼch apc̈het allohuen cornaneshaʼ ñeñt̃ atarr sherb̃aʼyets judioneshacop. Oʼch apc̈het ñam̃a ñeñt̃ atarr etsotayeneʼ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop. Allña aʼp̃t̃oʼtyesanet: —¿Erraʼt oteteʼt̃ña allchaʼ eñalletaña ñeñt̃chaʼ Cristoterrets? ");
INSERT INTO ameNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ñetñapaʼ atet̃ ochet: —Arr anetso Beléño allara Judeo t̃arroʼmar quellcopaʼ atet̃ anuaret̃, atet̃ quellquëʼt̃ ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ. Ñeñt̃paʼ Yomporña atet̃ otatseʼt̃: ");
INSERT INTO ameNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Añ Beléñ ñeñt̃ judanaʼtarneshaʼ poʼpatseñ, eʼñe poʼñoc̈h ñeñt̃ anetser ñeñt̃ atarr asherben entyeñet allohuen ñeñt̃ am̃chaʼtaret̃etyetsa alloʼmarneshaʼ. T̃arroʼmar all Beléño allchaʼ eñalleterra ñam̃a ñeñt̃chaʼ atarr am̃chaʼtaret̃terrtsa ñeñt̃chaʼ cohuam̃perreʼ allohuen neyochreshac̈hno ñeñt̃ara israelneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Allempoña otuoset atet̃paʼ Herodesñapaʼ eʼñe aʼnahua agotaterran ñam̃a poʼpotantañ eñotañneshaʼ ñeñt̃ c̈hac̈haʼtats allempo Jerusaléño. Allñapaʼ eʼñe acop̃a aʼp̃t̃oʼtareʼtyesapanet: —Rantopaʼ ¿eʼñeʼtña esempot̃eñña señch ñeñt̃ sorrtoya ñenmat̃? ");
INSERT INTO ameNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Allempoña eñotatosetpaʼ ñañapaʼ otanet: —T̃eʼpaʼ oʼch ahues Beléño, eʼñech acop̃a seʼnyesos ñeñt̃ cheshat̃oll. Ñerraʼm oʼch señchpaʼ oʼch sotuerren allochñapaʼ napaʼc̈hoʼña oʼch ahuen oʼch neconcorpanaʼteñaʼ nam̃a. ");
INSERT INTO ameNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ñetñapaʼ allempo eʼmhuanmuet atet̃ otanet am̃chaʼtaret̃paʼ allempoñapaʼ ahuanmuet. Rantoña ñeñt̃ entnenet allot̃ huena atsrret̃paʼ taʼnetsa allenet̃ senet, att̃ot̃apaʼ oʼ c̈hap eʼñe alloʼtsen cheshat̃oll. Oʼña c̈hap alloʼtsen cheshat̃ollpaʼ oʼ muechechosa eʼñe alla ento eʼñe pocto. ");
INSERT INTO ameNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Allempoña enterreterr rantopaʼ atarr nanac coshet. ");
INSERT INTO ameNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Allempoñapaʼ oʼ beʼt̃ososet pocollo, allña entoset cheshat̃oll epuet pachor María. Concorpanaʼtosyetpaʼ maʼyochosyet. Toram̃pesyesoset poʼtsapotpaʼ aposet eʼñe att̃a oro, aposet tsach pueseʼ ñeñt̃ atarr eñmosat̃. Aposet ñam̃a eñmosat̃ puerets. ");
INSERT INTO ameNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Allempoña ñetpaʼ eñotatanet Yompor puec̈hopoño allochñapaʼ att̃och ama oñerreto Herodeseshoʼmar. Allempo puerrerret paʼnyetopaʼ aña cot̃erret poʼpoñ t̃oñ. ");
INSERT INTO ameNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Puerrac̈herrtsetpaʼ Yomporña poʼm̃llañot̃eñerpaʼ alla orrterranerr José puec̈hopoñot̃. Ñeñt̃paʼ atet̃ otererr: —Petantayeʼcha oʼch p̃aʼyech cheshat̃oll pachoreʼna, orrayeʼchap̃ all anetso Egipto allchaʼ seyc̈hosa. Esempohuañenñapaʼ oʼch alla noterrperr atet̃chaʼ pep̃a. Herodes poʼñoc̈hpaʼ eʼnatanchaʼ añ cheshat̃oll att̃och muetsatach. ");
INSERT INTO ameNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Allempoña oʼ tantapaʼ anman cheshat̃oll, pachoreʼna yeta tsapo, ahuanmuet Egipto. ");
INSERT INTO ameNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Allñapaʼ alleneta att̃ot̃añapaʼ oʼ rromuen Herodes. Att̃oña etsota Yompor poʼñoñ atet̃ oteʼt̃ ñeñt̃ aʼm̃tayeʼt̃ poʼñoñ; ñeñt̃paʼ Yompor atet̃ otatseʼt̃: “Egiptot̃chaʼ nagotater Nechemer.” ");
INSERT INTO ameNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ñehua, allempoña Herodespaʼ oʼ eñoch c̈ha shecaʼnem̃ eñotañneshaʼpaʼ ñañapaʼ ñeñt̃a atarr atsrreʼmateʼ. Att̃o atsrreʼma nanacpaʼ allempoñapaʼ mueñan ñeñt̃chaʼ muetsueʼ allohuen asheñorrot̃olleshaʼ ñeñt̃ Beléñoʼtsaʼyen ñam̃a ñeñt̃ allohuen allampañoʼtsaʼyen Beléño. Allohuen asheñorrot̃olleshaʼ ñeñt̃ echeneʼ epa poʼcharña amaʼt ñam̃a allohuen ñeñt̃ eñalletyetsa chentaʼ eʼñe poctacma muetsanatuet. Ñehua, ñeñt̃ atet̃ eñotatos eñotañneshaʼpaʼ ñañapaʼ atet̃ cot̃apeʼch ahuoʼt̃eʼ epa char eñalletuaña ñeñt̃ cheshat̃oller. ");
INSERT INTO ameNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Att̃oña etsota ñeñt̃ atet̃ oteʼt̃ Jeremías ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ ahuat̃; ñeñt̃paʼ atet̃ oteʼt̃: ");
INSERT INTO ameNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ñeñt̃ anetser Ramopaʼ atarrchaʼ eʼmorrterra yahueñets, atarr gogatstena; allpaʼ Raquelcaʼye yaʼnaʼteneʼ puechoyoreshaʼ; ama mueno oʼch eseshaʼ emyaʼteʼ t̃arroʼmar puechoyoreshaʼpaʼ ama eñallmeñe, oʼ eʼñe muetsanatuet. ");
INSERT INTO ameNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Allempoña rroma Herodespaʼ Yomporña poʼm̃llañot̃eñerpaʼ alla orrterranerr José puec̈hopoño all Egipto. ");
INSERT INTO ameNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Allñapaʼ otererr: —T̃eʼñapaʼ oʼch petanterra, oʼch alla p̃aner cheshat̃oll pachoreʼna oʼch alla pepuerrerra israelneshaʼ paʼnyo; oʼcaʼye collaʼhuaña ñeñt̃ oʼpatayeʼt̃ añ cheshat̃oller ñeñt̃oʼch muetsayeñ. ");
INSERT INTO ameNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Atet̃ otuepaʼ ñañapaʼ allent̃a tantena oʼ alla anerran cheshat̃oll pachoreʼna alla ahuerret israelneshaʼ paʼnyo. ");
INSERT INTO ameNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Allempo ahuerretpaʼ ñetñapaʼ eʼmareʼtueret añ am̃chaʼtaret̃terrtsa Judeo ñeñt̃ Herodesoñ puechemer ñeñt̃ sochetsa Arquelao. Ñeñt̃oʼmarña mechaʼtenet serrtset all. Puec̈hopoñoñapaʼ alla eñotatererr ñeñt̃oʼmarña allempopaʼ alla serr Galileo. ");
INSERT INTO ameNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","C̈herr Galileopaʼ ahuerr pat̃err anetso ñeñt̃ paʼsoʼcheñ Nazaret. Allñapaʼ alla yec̈haʼhuerra. Att̃ot̃caʼyeña etsotaña ñeñt̃ atet̃ otyeseʼt̃ ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ; ñetpaʼ atet̃ otyeseteʼt̃ ñeñt̃chaʼ Cristoterretspaʼ “oteñetchaʼ nazaretoʼmarneshaʼ.” ");
INSERT INTO ameNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Allempoñapaʼ orrta Juan ñeñt̃ apatoseʼ acheñeneshaʼ Yomporecop. Ñañapaʼ arr serrpareʼtatosanet amayo eʼñe alla Judeo. ");
INSERT INTO ameNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Allñapaʼ atet̃ otosanet: —T̃eʼpaʼ oʼch soct̃apeʼcherr ello cohuen Yomporecop t̃arroʼmar oʼ c̈hapmoch allempoch ayochreshat̃terra Yompor ñeñt̃ pueʼntañoʼtsen. ");
INSERT INTO ameNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ñehua, añmapaʼ ñocopcaʼye eñoseʼt̃ña Isaías ñeñt̃ aʼm̃tayeʼt̃ ahuat̃ Yompor poʼñoñ. Allempopaʼ atet̃ oteʼt̃: Eʼmorrterrach puesheñarr poʼñoñ all amayo allchaʼña serrpareʼtaterranña acheñeneshaʼ. Puerranarot̃paʼ añchaʼ tomaʼntaterranet t̃oñ, ñeñt̃paʼ atet̃chaʼ oterranet: “T̃eʼpaʼ oʼch saʼcohuenetyes t̃oñ allchaʼ oñmos Partseshaʼ, oʼch eʼñe saʼpac̈harretyesoñ paʼt̃ep̃.” Arrpaʼ allohua ñeñt̃ atet̃ aquellcaret̃ ahuat̃ot̃eñ Cristocop. ");
INSERT INTO ameNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ñeñt̃ña Juanpaʼ camello pueʼch apomotaret̃ ñeñt̃ paʼshtam pen. Allo chanena ñeñt̃paʼ paʼrrom. Allñapaʼ rraʼyesaneʼt̃ ahuañchenclla ñeñt̃a puerrar peʼt̃ epuet pets poʼmoñ. ");
INSERT INTO ameNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Allempoña jerusaléñoʼmarneshaʼpaʼ c̈hocma huac̈haʼtyenet ñesho ñam̃a allohuen judeoʼmarneshaʼ. Huac̈haʼtyeññaña ñam̃a allohuen jordanasoʼmarneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Allña ñetpaʼ aʼmet̃aʼyesoset poʼchñaret, Juanñapaʼ apatyesapanet Yomporecop. Ñeñt̃ña oñ all apatyesapanet añ paʼsoʼcheñ Jordanas. ");
INSERT INTO ameNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Allempoña entapan shonteʼ saduceoneshaʼ ñam̃a fariseoneshaʼ ñeñt̃areta ñeñt̃et judioneshet. Ñetpaʼ t̃arroʼmar huac̈henet añ muenenet oʼch apatapanet Juan. Juanña serrpareʼtatapanetpaʼ otapanet: —Sapaʼ ama cohuenayayso atarr ashcarñat̃es, c̈ha sottena ñerraʼmrrat̃eʼ shechp̃a sompor sepen. Poʼñoc̈hcaʼ ama eseshayeʼ sotenaye eʼñech sapataret̃teñot̃a oʼch sequeshperra allochñapaʼ amach coñchatuerrso Yompor allempoch yoroc̈htatuer tsapat̃onet̃. ");
INSERT INTO ameNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Napaʼ añchaʼña notapas oʼch sorrtatyes ñeñt̃ eʼñe cohuen enten Yompor ñeñt̃ atet̃ pena ñeñt̃ poʼñoc̈h oʼ cot̃apeʼcherran ello cohuen Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Sapaʼ c̈ha soteneñ seyoc̈hro añoʼ es sepallteno, sapaʼ añoʼ eʼñe seyemtena satañ Abrahamañ. T̃arraña napaʼ oʼch notas amach atet̃ soct̃apeʼchatsto t̃arroʼmar ñeñt̃paʼ ama esoyeʼ enteñe Yompor. T̃arroʼmar oʼch notas ñerraʼm Yompor muenetseñ amaʼt añ mapueʼ ñeñt̃ senten arr oʼch aʼpnasereñ Abraham poʼm̃reneñ. ");
INSERT INTO ameNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ñeñt̃oʼmarña napaʼ oʼch notas ñerraʼm amach soct̃apeʼcherro cohuen Yomporecop oʼ mameshamerra oʼch c̈haponasa att̃och coñchaterres Yompor. Oʼch netmaʼntatasa atet̃ ñerraʼmrrat̃eʼ allempo oʼch aʼmataʼtmochet tsach. Oʼ eʼñe onañchachet gach allchaʼ tet eʼñe allohua huañen puepallactar. Ñeñt̃ allohuen tsachec̈hno ñeñt̃ ama cohuenayeʼ meʼtetsopaʼ aʼmataʼtueretchaʼ saprrochetchaʼ all huorten tsoʼ allchaʼ eʼñe aʼpoyatatueret. ");
INSERT INTO ameNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Elloña Juanpaʼ atet̃ oterraneterr: —Ñeñt̃es cot̃apeʼcherreʼ cohuen Yomporecop napaʼ amaʼt eʼñe poʼñoc̈h napatensoñ Yomporecop, napaʼ eʼñecaʼye oñochaya napatenes. T̃arraña Cristo ñeñt̃chaʼ huapatsa chentaʼpaʼ ñapaʼ añchaʼcaʼye chorratossa Parets Puecamquëñ ñeñt̃ atet̃ ñerraʼm tsoʼ. Ñapaʼ ñeñt̃ atarr ahuamencat̃eshaʼ nañapaʼ ama tama ahuamencat̃eyayno. Ñapaʼ ñeñt̃ña atarr sherbets, nañapaʼ ama es nesherbeno att̃och amaʼt poʼsapatapaʼ oʼch nanmoñ. ");
INSERT INTO ameNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ñapaʼ atarr ahuamencat̃ ñapaʼ ñach acrerreʼ allohuen acheñeneshaʼ. Ñapaʼ añ tomaʼntena ñeñt̃ orreneʼ pueshoshnat alloch shoshnan poʼtrigo oʼch eʼñe pueʼllom̃rochayam̃a. Ñeñt̃ña pueʼllomerpaʼ oʼch aʼyapac̈heʼ oʼch aññoʼch allecma aññoʼteñ eʼñe cohuen. Pueʼsheʼmarñapaʼ oʼch huaporeʼch tso allchaʼ eʼñe poyhua. Ñeñt̃ña tsoʼpaʼ ama emayaʼpahuo amaʼt errponaña. Ñeñt̃paʼ allohua atet̃ serrpareʼtatanet Juan. ");
INSERT INTO ameNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Allempo huapa Jesús Galileot̃, c̈hap Jordanaso alloʼtsen Juan, ñapaʼ añ muenen oʼch apatap̃ Juan Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juanñapaʼ eñoratsa c̈ha mueneñeñ oʼch emman Jesús. Ñeñt̃paʼ atet̃ otap̃: —Ama pocteyaye oʼch napatapap̃ p̃a, añña poctetsa p̃achña napatoseʼ. P̃apaʼ esoʼmaruachñacaʼye p̃onña nesho, p̃acaʼyeña ñeñt̃ep̃ atarr sherbets. ");
INSERT INTO ameNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesúsñapaʼ atet̃ otererr: —P̃apatapnoʼt̃ach Juanachaʼ t̃arroʼmar atet̃caʼye poctetsa oʼch yetsota allohuen ñeñt̃ poctetsa Partsocop. Allempoña Juanpaʼ eʼñe pocteʼ eñch, ");
INSERT INTO ameNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","allempoñapaʼ apatapan Jesús. Eʼne apatueʼpaʼ oʼ c̈haʼnerrña Jesús oñot̃, enetñapaʼ ahuepaʼt atoraret̃ta. Allot̃ña eʼñe sohuaʼnma Parets Puecamquëñ, Jesúsñapaʼ eʼñe atet̃ entap̃ ñerraʼmrrat̃eʼ yep̃ oʼ sohuaʼnma entot̃, eʼñe c̈hap ñesho. ");
INSERT INTO ameNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Allempoñapaʼ c̈ha eʼmorrtatsa ñam̃a ñoñets entot̃ atet̃ eñorena Yompor. Ñeñt̃ña ñoñetspaʼ atet̃ oten: —Añmapaʼ ñeñt̃ña Nechemer ñeñt̃ atarr nemorrentena. Ña atarr nanac nocshateneʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Allempoña Parets Puecamquëñpaʼ anman Jesús all amayo. Ñeñt̃paʼ añecop atet̃ p̃a att̃ochña allpaʼ oʼch huapoña oneñet̃, t̃arroʼmar ñapaʼ añ mueneñ oʼch atet̃ p̃atyes ñeñt̃ ama pocteyeʼ enteno Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Allñapaʼ ama rreno eʼñe aña t̃orrena att̃och etsotuan ora allohuen ñeñt̃ cohuentetsa Pomporecop. Ñeñt̃oʼmarña amaʼt oʼ paʼtatsoch c̈harramatpaʼ amaʼt coñeʼt̃apaʼ ama es rreno yet̃o amaʼt ñam̃a tsapo. Oʼña paʼtatsoch c̈harramatuapaʼ c̈ho cheporratsa. ");
INSERT INTO ameNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Allempoñapaʼ huapoña oneñet̃. Att̃o topatosan Jesúspaʼ atet̃ otos: —P̃a ñerraʼm poʼñoc̈ht̃eʼ Parets Puechemerep̃paʼ oʼch p̃ot: Añ mapueʼ puenasepaʼ pan. ");
INSERT INTO ameNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesúsñapaʼ atet̃ otap̃: —Napaʼ ama nemno oʼch atet̃ nep̃a t̃arroʼmar Yompor poʼñoñ ñeñt̃ anuaret̃ ahuat̃ot̃eñ ñeñt̃paʼ atet̃ oteney: “Allohueney acheñeneshohueneypaʼ ama eʼñe rreñtsa ñapuet̃ yocrram̃ yepeno. Añeʼnaña yocrram̃ yepen yecamquëñecop ñeñt̃ allohuen allpon oteney Yompor.” ");
INSERT INTO ameNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Allempoña oneñet̃paʼ oʼ anem̃ all Jerusaléño, ñeñt̃ anetserpaʼ anaret̃ Partsocop. Allñapaʼ aʼtapatos nanac eno allohuanen Parets paʼpaquëll. ");
INSERT INTO ameNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Allñapaʼ otuererr: —P̃apaʼ ñerraʼm poʼñoc̈ht̃eʼ Parets Puechemerep̃ t̃eʼpaʼ p̃omacha arrot̃ t̃arroʼmar amach p̃aʼtserrp̃o t̃arroʼmar Parets poʼñoñ ñeñt̃ anuaret̃ ñeñt̃paʼ amaʼtña atet̃ oten: Yomporpaʼ oʼch mueñonap̃ poʼm̃llañot̃eñnaneshar ñeñt̃chaʼ pecuam̃p̃sapueʼ. Ñetchaʼ p̃agapapuet, oʼch enatapapet att̃och amach p̃aʼtserrp̃atcaʼtoso mapyo. ");
INSERT INTO ameNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Allempoña Jesúspaʼ alla otererr: —Añpaʼc̈hoʼña anuaret̃ Yompor poʼñoño: “Amach yaʼllocchameʼtatsche Yompor ñeñt̃ Yepartseshar yepen.” ");
INSERT INTO ameNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Allempoña oneñet̃paʼ oʼ alla anerranerr Jesús all atarr aspent̃o eʼñe aʼnoso. Allot̃ña gatyesuererr allohuen ñeñt̃ allpon all am̃chaʼtaret̃etyena paʼnamen acheñeneshaʼ ñeñt̃ yec̈haʼyetsa errap̃aren añe patsro, gatyesuererr all atarr cohuentatyeñet. ");
INSERT INTO ameNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Oneñet̃ñapaʼ alla otuererr: —Ñerraʼm na pemaʼyocheñot̃en oʼch peconcorpanaʼtna, napaʼ napap̃chaʼ ora allohuen ñeñt̃ cohuen pentyen arr. ");
INSERT INTO ameNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesúsñapaʼ alla otererr: —T̃eʼpaʼ oʼch orrerrep̃ oneñet̃e. Napaʼ ama nemno oʼch atet̃ nep̃a t̃arroʼmar Yompor poʼñoñ ñeñt̃ anuaret̃ ñeñt̃paʼ atet̃ oteney: “Añach ñapuet̃ yemaʼyochena Yompor ñeñt̃ Yepartseshar yepen, eʼñech ñapt̃a yesherbeʼ.” ");
INSERT INTO ameNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Allempoña oneñet̃ topatuahuan Jesúspaʼ oʼ ahuerr oʼ quec̈hpaʼner. Allempoñapaʼ c̈hac̈haʼtoña Yompor poʼm̃llañot̃eñnaneshar; ñetñapaʼ eʼñe cohuen sherb̃oset Jesús all. Arrpaʼ allohua huañ att̃o oneñet̃paʼ topatenan Jesús allempo. ");
INSERT INTO ameNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Allempoña Jesús eʼmareʼtan Juan oʼ yottam̃p̃set, ñañapaʼ allent̃a ahuerr Galileo. ");
INSERT INTO ameNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","C̈herr Galileopaʼ ama aʼpohuerro anetso Nazareto, arraña serr Capernaumo, allña yec̈haʼhuerra. Ñeñt̃ Capernaumpaʼ eʼñe saʼpatop̃ñoʼtsen, allara ñeñt̃ otenet Zabulónnaneshaʼ paʼnetser ñam̃a Neftaleneshaʼ paʼnetser. ");
INSERT INTO ameNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ñeñt̃paʼ allña yec̈haʼhuerra allochñapaʼ att̃och etsota Isaías poʼñoñ ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ; ñeñt̃ ñapaʼ atet̃ oteʼt̃ ñeñt̃e anetsrecop: ");
INSERT INTO ameNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ñeñt̃ Zabulónnaneshaʼ paʼnetsro ñam̃a Neftaleneshaʼ paʼnetsro ñeñt̃ all saʼpatop̃ño all Jordanas yom̃taʼn, allara Galileo all yec̈haʼyena paʼnamen acheñeneshaʼ ñeñt̃ ama judioneshayayeto. ");
INSERT INTO ameNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ñeñt̃ acheñenesharpaʼ ñetpaʼ aña yec̈haʼyenet ñeñt̃ ama cohuenayeʼ enteno Yompor; ñetpaʼ c̈ha ottenet ñerraʼm checmetoʼtseneta. T̃arraña t̃eʼñapaʼ oʼ enteret ñeñt̃chaʼ eʼñe cohuen aʼpuetarsam̃perrahuet poct̃ap̃ñet. Ñetña amaʼt aña oʼpatyesahuetañeʼt̃ rromueñets ñeñt̃ara chenquëñets, t̃eʼñapaʼ amaʼt ñocpuetpaʼ oʼ aʼpuetarsam̃p̃saret̃terret eʼñe cohuen. Arrpaʼ allohua atet̃ naneʼt̃ Isaías poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Allempo c̈herr Jesús Galileo allempoña eʼñe ñenmat̃ serrpareʼtatuerranet all. Ñeñt̃paʼ atet̃ otuerranet: —T̃eʼpaʼ oʼch soct̃apeʼcherr ello cohuen Yomporecop t̃arroʼmar t̃eʼpaʼ oʼ c̈herrmoch allempoch ayochreshat̃terra Yompor ñeñt̃ pueʼntañoʼtsen. ");
INSERT INTO ameNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Allempo Jesúspaʼ chopeñeʼchyen all saʼpatop̃ñoʼmar; ñeñt̃ña saʼppaʼ añ paʼsoʼcheñ Galileas. Allñapaʼ entosan acheñ epsheña; ñeñt̃ña puesheñarrpaʼ añ paʼsoʼcheñ Simón ñeñt̃ara sochetsa Pedro epuet paʼmoʼnasheñ Andrés. Ñetñapaʼ terrayetset eʼñe alla saʼpo t̃arroʼmar ñetpaʼ eʼñe ñeñt̃a poʼtaruas penet. ");
INSERT INTO ameNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesúsñapaʼ atet̃ otosanet: —T̃eʼñapaʼ oʼch notas, soct̃aʼn na att̃och neyochreshaʼ neperres. Ñeñt̃ atet̃ sepena ahuat̃ot̃eñ eʼneʼ cac t̃eʼñapaʼ oʼch neyc̈haterres att̃och seʼnerr ñam̃a acheñ ñeñt̃chaʼ sameʼñaterra. ");
INSERT INTO ameNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ñetñapaʼ allorocma naʼnmuet poʼterrayapaʼ oʼ cot̃et Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Allempoña meterrerr allot̃paʼ entuerranerr poʼpoñ acheñ epsheña; ñeñt̃ña puesheñarrpaʼ añ paʼsoʼcheñ Jacobo epuet paʼmoʼnasheñ Juan; ñeñt̃paʼ Zebedeo puechemereshaʼ. Ñetñapaʼ poʼnoñt̃oʼtsaʼyenet; alloʼtsen ñam̃a pomporet all aʼcohuenetyenet poʼterraya. Jesúsñapaʼ c̈horeʼtuerraneterrpaʼ atet̃ otuerraneterr ñamet: —T̃eʼpaʼ oʼch soct̃aʼn sam̃a. ");
INSERT INTO ameNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ñetpaʼc̈hoʼña eʼñe allorocma naʼnmuet poʼnoñt̃ ñam̃a pomporet oʼ cot̃et ñamet Jesús att̃och pueyochreshaʼ perranet ñamet. ");
INSERT INTO ameNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Allempoñapaʼ chopeñeʼchyes Jesús errap̃aren Galileoʼmar. Yec̈hatyesosan judioneshaʼ eʼñe ñet poʼprahueto. Allñapaʼ serrpareʼtatosanet cohuen ñoñets att̃o ayochreshat̃tena Yompor. Aʼcrratyesosan acheñeneshaʼ; amaʼt paʼnamen osyenahuet, amaʼt paʼnamen aʼprramaʼyenahuet, ñañapaʼ eʼñe aʼcrratyesuosanet. ");
INSERT INTO ameNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Att̃eñapaʼ eʼmareʼtuet errap̃aren amaʼt Sirioʼmar. Huapatyesoñet allohuen ñeñt̃ mueroc̈htatyen atsnañets. Huapatyesoñet ñeñt̃ osyen paʼnamen atsnañets ñam̃a ñeñt̃ atserrp̃añac̈hno. Huapatyesoñet ñam̃a ñeñt̃ chorraʼyena oneñet̃ ñam̃a ñeñt̃ ot̃añac̈hno ñam̃a echarrtañac̈hno. Allohuenetpaʼ ñañapaʼ eʼñe aʼcrratyesuerranet. ");
INSERT INTO ameNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Shonteʼ acheñeneshaʼ ñeñt̃ cot̃aʼyeseʼ. Cot̃aʼyes galileoʼmarneshaʼ, ñam̃a decapolisoʼmarneshaʼ ñam̃a jerusaléñoʼmarneshaʼ, ñam̃a judeoʼmarneshaʼ; amaʼt ñeñt̃ yec̈hetsa Jordanaso yom̃taʼnpaʼ oʼ eʼñe cot̃aʼyesuet. ");
INSERT INTO ameNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Allempoña entan shonteʼ acheñeneshaʼ ñeñt̃ cot̃eneʼ, Jesúsñapaʼ ahuoʼ aspent̃o. Allña anorrospaʼ huac̈haʼtoña allohuen pueyochreshac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ñañapaʼ yec̈hatapanetpaʼ atet̃ otapan acheñeneshaʼ ñeñt̃ poʼñoc̈h atarr cosheñtsoʼtsaʼyenet: ");
INSERT INTO ameNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Nanac cosheñtsoʼtsaʼyen allohuen ñeñt̃ ama esoyeʼ asherbenayeʼ entyetso pueyoc̈hreto Yomporecop t̃arroʼmar ñetpaʼ oʼpaterretchaʼ Yompor poʼcohuenña att̃o ayochreshat̃tena pueʼntañot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Nanac cosheñtsoʼtsaʼyen allohuen ñeñt̃ llecaʼyetsa Yomporecop t̃arroʼmar ñetpaʼ coshaterranetchaʼ Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Nanac cosheñtsoʼtsaʼyen allohuen ñeñt̃ ama añeyeʼ eʼneneto ñeñt̃ eʼñe ñocpueta t̃arroʼmar ñetpaʼ oʼpataterranetchaʼ Yompor allohuanen pats. ");
INSERT INTO ameNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Nanac cosheñtsoʼtsaʼyen allohuen ñeñt̃ nanac mueneneʼ oʼch eʼñe orrtatyenet ñeñt̃ eʼñe pocteʼ enten Yompor. Ñetpaʼ eʼñe atet̃ mueneñet ñerraʼmrrat̃eʼ c̈ho nanac yachporrena ñam̃a nanacchaʼ yoʼñpaʼten. Nanac cosheñtsoʼtsaʼyenet ñet t̃arroʼmar Yomporña eʼñe atet̃ muenaterranet. ");
INSERT INTO ameNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Nanac cosheñtsoʼtsaʼyen allohuen ñeñt̃ nanac cohuen muerannetsa t̃arroʼmar elloña Yomporpaʼ atarrchaʼ muererranet ñet. ");
INSERT INTO ameNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Nanac cosheñtsoʼtsaʼyen allohuen ñeñt̃ eʼñe pueyoc̈hretopaʼ ama eñalle sosyaʼtsañ amaʼt coñeʼt̃a t̃arroʼmar ñetpaʼ enteretchaʼ Parets. ");
INSERT INTO ameNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Nanac cosheñtsoʼtsaʼyen allohuen ñeñt̃ c̈hocma amoʼtstannaʼtatenahuet t̃arroʼmar ñetpaʼ poʼñoc̈hchaʼ Yompor puechemer perranet. ");
INSERT INTO ameNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Nanac cosheñtsoʼtsaʼyen allohuen ñeñt̃ eʼmoñeʼtyenet att̃o ñetpaʼ eʼñe pocteʼ es p̃aʼyenet Yomporecop. Nanac cosheñtsoʼtsaʼyenet t̃arroʼmar ñetpaʼ oʼpaterretchaʼ Yompor poʼcohuenña att̃o ayochreshat̃tena pueʼntañot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Sapaʼc̈hoʼña nanac cosheñtsoʼtsaʼyenes ñerraʼm esempo errot̃uanen penset noʼmar. Nanac cosheñtsoʼtsaʼyenes ñerraʼm c̈ho sapaʼ sasareʼtyenset, eʼmoñeʼtyenset, paʼnamen sosey tomaʼtam̃pesyenset. ");
INSERT INTO ameNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","C̈hocmuepaʼchña socsha t̃arroʼmar shonteʼ ñeñt̃ oʼpatatensa Yompor pueʼntaño; ñeñt̃chaʼña atarr socshaterreʼ. Amaʼt ahuat̃ot̃eñ allempo ama seʼñalletenaʼ att̃ecma eʼmoñeʼtyeseteʼt̃ ñam̃a ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Sapaʼ ñeñt̃es nameʼñenaya añ netmaʼntatensa atet̃ ñerraʼm pos ñeñt̃ atarr sherbeneʼ allohuen acheñeneshaʼ arr patsro. T̃arraña pospaʼ ñerraʼm oʼch huañer poʼposerrteña amach errot̃enot̃ ellopaʼ yaʼposerrtatere. Allempopaʼ oʼhuañchaʼ es sherb̃aʼ acheñeneshacop; añecpach sherberr oʼch yehuaporeʼch aʼyo allchaʼ at̃mamaʼch acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Ñam̃a añ netmaʼntatensa puetareʼ elloña ñeñt̃ña atarr sherbeneʼ acheñeneshaʼ arr patsro. Sapaʼ c̈hocmach cohuen es sorrtatyen. Atet̃chaʼ sepena ñerraʼmrrat̃eʼ pat̃err anets ñeñt̃ eʼñe aʼnosoʼtsen aspent̃o. Ñeñt̃ña anetserpaʼ c̈hocmach cohuen orrtena allem̃at̃eñ, amach errot̃enot̃ maʼnatacheto. ");
INSERT INTO ameNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ñam̃a ñerraʼm esempo yaʼllchaten lampareñpaʼ ñeñt̃paʼ ama t̃arrecpayeʼ yaʼllchateñe oʼch yeʼrramam̃pes coym̃o. Ñeñt̃paʼ añecopña yaʼhuortateñ oʼch yeneʼ enonet̃ att̃och eʼñe c̈hoyoʼtam̃pesuan allohuen ñeñt̃ pocolloʼtsaʼyen. ");
INSERT INTO ameNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Sapaʼ att̃ecmuepaʼchña sorrtatyen ñeñt̃ cohuen enten Yompor. Allochñapaʼ poʼpotantañpaʼc̈hoʼña eʼñech cohuenareʼ entennaset atet̃ es sorrtatyen cohuen. Att̃ochña ñetpaʼc̈hoʼña cohuentatapreterrnasetchaʼ Seyomporer ñeñt̃ pueʼntañoʼtsen. ");
INSERT INTO ameNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jesúsñapaʼ atet̃ oterraneterr: —Amach soct̃apeʼchatsto napaʼ añecopt̃eʼ nohuapa oʼch nehuaporeʼtaterr Yompor poʼñoñ ñeñt̃ ahuat̃ot̃eñ atet̃ anaret̃ atet̃ ñerraʼm Moisés poʼñoñ ñam̃a añ poʼñoñ ñeñt̃ quellcaʼyeseʼt̃ ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ. Napaʼ ama añecpayeʼ nohuapo oʼch nehuaporeʼtach, napaʼ eʼñechcaʼyeña netsotatuer. ");
INSERT INTO ameNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Eʼñe poʼñoc̈h notenes: Ama ahuaporeʼtpahuoyaye Yompor poʼñoñ ñeñt̃ atet̃ anaret̃ ahuat̃ot̃eñ, amaʼt t̃ayot̃eñ t̃arrempohuach esempohuañenchaʼ chencaʼhuerra pats ñam̃a enet. Amaʼt pat̃rra ñoñets ñeñt̃ atet̃ anaret̃paʼ amach chenquërro amaʼt eʼñe pat̃rra quellec pueshempot̃ollohuenpaʼ amach chenquërro amaʼt t̃ayot̃eñ t̃arrempohuach esempohuañenchaʼ eʼñe etsotuerra ñeñt̃ atet̃ oten ahuat̃ot̃eñ. ");
INSERT INTO ameNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ñeñt̃oʼmarña ñerraʼm eseshaʼ oʼhuañ eʼñeyeʼ ameʼñaʼpoʼ entan amaʼt pat̃rrat̃olla ñoñets ñeñt̃ atet̃ anaret̃ ahuat̃ot̃eñ ñam̃a ñerraʼm att̃ach yec̈hatan poʼpotantañ, ñeñt̃ña acheñerpaʼ amach tama sherbeno Yomporecop ñeñt̃ att̃o ayochreshat̃tena ña pueʼntañot̃. T̃arraña ñerraʼm eseshaʼchña eʼñe etsoterreʼ ñam̃a ñerraʼm eʼñech atet̃ yec̈hatan poʼpotantañ, ñeñt̃ña acheñerpaʼ ñeñt̃chaʼña atarr sherberrets Yomporecop att̃och ayochreshat̃terra ña. ");
INSERT INTO ameNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Napaʼ oʼch notas, poʼñoc̈hcaʼye sa atet̃ eʼñe pocteʼ es sorrtatyen, ellochña sem̃tanaʼtuerepaʼch atet̃ es cohuen orrtatyeneñ fariseoneshaʼ ñam̃a añ ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃. Ñerraʼm amach sem̃tanaʼtuerranetopaʼ amach errot̃enot̃ soʼpataprechoña Yompor poʼcohuenña att̃o ayochreshat̃tena ña pueʼntañot̃. Att̃oña amaʼt ahuat̃apaʼ amach sec̈herro all am̃chaʼtaret̃tena pueʼntaño. ");
INSERT INTO ameNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jesúsñapaʼ alla yerpaterraneterr ñeñt̃ atet̃ anaret̃teteʼt̃ ahuat̃ot̃eñ ñoñets, ñeñt̃paʼ atet̃ oterraneterr: —Sa ahuat̃ot̃eñpaʼ seʼmart̃eʼña atet̃ otaret̃teʼt̃ ahuat̃ acheñeneshaʼ. Ñeñt̃paʼ atet̃ otaret̃teteʼt̃: “Amach muetsatsteto acheñ. Ñerraʼm eseshaʼ muetseneʼ acheñpaʼ ñapaʼc̈hoʼña muetseretchaʼ t̃arroʼmar ñeñt̃ot̃chaʼña oʼpatateret coñcheñets.” ");
INSERT INTO ameNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Elloña na t̃eʼpaʼ oʼch noterres, amaʼt ñeñt̃ att̃a eʼmoñeʼteneʼ pamoʼtspaʼ ñapaʼc̈hoʼña ñeñt̃ot̃ach oʼpatateret coñcheñets. Ñam̃a ñerraʼm eseshaʼ atarr sosyot̃ sochatseʼteñet pamoʼts ñeñt̃paʼc̈hoʼña ñeñt̃ot̃ach oʼpatateret coñcheñets alloʼtsaʼyen am̃chaʼtaret̃neshac̈hno allecma aʼpoctatenet ñoñets. Ñam̃a ñerraʼm eseshaʼ puepencareʼteñot̃ atarr sosyot̃ sochatseʼteñet pamoʼts ñeñt̃paʼc̈hoʼña acheñerpaʼ añ oʼpatenaya tsoʼ ñeñt̃ parrarets errap̃aren. ");
INSERT INTO ameNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Ñeñt̃oʼmarña napaʼ oʼch notas: Ñerraʼm esempo c̈ho es p̃apuen Yomporecop allecma sherbeñet Yompor allñapaʼ t̃aya oʼ peyerposya p̃amoʼtsñapaʼ c̈ha p̃atsrreʼmateñ, ");
INSERT INTO ameNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","p̃añapaʼ ñeñt̃chaʼ p̃ap Yomporpaʼ penaʼner alla. Oʼch ahuerrep̃, pemoʼnasheñña ñanom p̃amoʼtsterraʼ. Allempochña pepuerrerra allecma sherbeñet Yompor allempochña p̃aphuer Yompor ñeñt̃ p̃oʼpatateña. ");
INSERT INTO ameNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Ñam̃a ñerraʼm esempo eseshaʼ setmanteneʼ oʼch anmaset am̃chaʼtaret̃esho allchaʼ saʼpoctaterraʼ señoñ, sañapaʼ eʼñech allorocma samoʼtstera ñeñt̃ seʼmoñeʼteneʼ t̃ayepaʼtñapaʼ ama sec̈henaʼ am̃chaʼtaret̃esho. C̈hosachña amoʼtsterraya ñeñt̃ setmanteneʼ t̃eʼt att̃ot̃ pomataterrset am̃chaʼtaret̃esho ñañapaʼ oʼch pomuensaʼ guardiyesho ñeñt̃chaʼ seyottam̃p̃seʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Poʼñoc̈hcaʼye oʼch notas, ñerraʼm c̈hoch yottam̃p̃sasetpaʼ allenasachcaʼye oʼpono allot̃paʼ amachcaʼye ahuen c̈haʼnmaterrseto. Esempohuañenchaʼ c̈hoch sec̈haʼnmaterret ñerraʼm esempoch eʼñe setsaʼtuerra ora allohuen ñeñt̃ allpon quelle muenenet. Amaʼt eʼñe eptalla centavot̃ollña ñerraʼm ama setsaʼtueñaʼpaʼ amachcaʼye c̈haʼnmaterrseto allot̃. Ñeñt̃oʼmarña notenes oʼch eʼñe cohuen samoʼtstera ñeñt̃ seʼmoñeʼteneʼ t̃ayepaʼtñapaʼ ama c̈hennasaʼ ñeñt̃ atarr yoroc̈hen senten socop. ");
INSERT INTO ameNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Ñam̃a sapaʼ ahuat̃ot̃eñ seʼmart̃eʼña atet̃ otaret̃teʼt̃ acheñeneshaʼ: “Amach chetapretatsteto t̃aporets.” ");
INSERT INTO ameNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Elloña na t̃eʼpaʼ oʼch noterres, ñerraʼm eseshaʼ cohueneʼ coyaneshaʼ pueyeʼcheñot̃, oʼcaʼye ochñaʼtet pueyoc̈hreto. ");
INSERT INTO ameNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Ñeñt̃oʼmarña notenes: Ñerraʼm seclleʼ p̃atyenes ñeñt̃ ama pocteyeʼ enteno Yompor, añ poctetsa oʼch sequec̈hpuerr ñeñt̃ seyeʼchena seclloyot̃. Ñeñt̃paʼ eʼñe atet̃ ñerraʼmrrat̃eʼ c̈ho serrot̃en seclleʼ oʼch sehuaporeʼch, amaʼt ñeñt̃ seclleʼ secohuenrot̃eʼtsen ñeñt̃ atarr sesherbeneʼ. Añña ama tama yoroc̈henayaye socop oʼch saʼypoʼñer eʼne t̃ayecma ñeñt̃ soct̃apeʼchateneʼ sosyaʼtsañ. Añchaʼña atarr yoroc̈hen socop ñerraʼm ama t̃ayecma saʼypoʼñerepaʼ esempohuañenpaʼ orach huaporeʼterrset coñchaʼpuetso all parraren tsoʼ. Ñeñt̃paʼ añ tomaʼntena atet̃ ñerraʼmrrat̃eʼ oʼ yaʼchencaterr pat̃err yechets amaʼt yeclleʼ amaʼt yot, t̃eʼt esempohuañen ora yechtsohuenpaʼ huaporeʼterryet coñchaʼpuetso. ");
INSERT INTO ameNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Att̃ecma ñam̃a ñerraʼm sotpaʼ p̃atyenes ñeñt̃ ama pocteyeʼ enteno Yompor añ poctetsa oʼch sequec̈hpuerr ñeñt̃ atet̃ c̈hocma p̃atseʼtatyenes sot. Ñeñt̃paʼ eʼñe atet̃ ñerraʼmrrat̃eʼ c̈ho sepechen sotpaʼ oʼch sehuaporeʼch, amaʼt ñeñt̃ secohuenrot̃eʼtsen sot ñeñt̃ atarr sesherbeneʼ. Ñeñt̃paʼ oʼch alla noterrserr. Añña ama tama yoroc̈henayaye socop oʼch saʼypoʼñer eʼñe t̃ayecma ñeñt̃ soct̃apeʼchateneʼ sosyaʼtsañ. Añchaʼña atarr yoroc̈hen socop ñerraʼm ama t̃ayecma saʼypoʼñerepaʼ esempohuañenpaʼ orach huaporeʼterrset coñchaʼpuetso. ");
INSERT INTO ameNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Ñam̃a t̃eʼpaʼ oʼch noterrserr poʼpoñ: Sapaʼ ahuat̃ot̃eñpaʼ señoteñeʼtña atet̃ otaret̃teteʼt̃: “Ñerraʼm eseshaʼ serreʼ puet̃aporpaʼ apaʼnmepaʼña papell all aquellcaret̃ att̃och quec̈hpuerran puet̃apor.” ");
INSERT INTO ameNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Elloña na t̃eʼpaʼ oʼch noterres: Ñerraʼm ama añecpayeʼ quec̈hpuerrano puet̃apor att̃o ama c̈hoyeʼ aguënano poʼpsheñeñ yacma, ñerraʼm att̃ot̃a serran puet̃apor, ñañapaʼ ochñaʼtaterranchaʼ puet̃aporesheʼmañ poʼpsheññeshot̃; ñeñt̃paʼ ama cohuenayeʼ enteñe Yompor. Ñam̃a ñerraʼm eseshaʼña yorerreʼ ñeñt̃ asaret̃paʼ ñeñt̃ña yacmarpaʼ c̈hach chetapretenan poʼpsheñeñ puet̃apor; ñeñt̃paʼc̈hoʼña ama cohuenayeʼ enteñe Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Ñam̃a t̃eʼpaʼ oʼch noterrserr poʼpoñ: Sa ahuat̃ot̃eñpaʼ seʼmareʼtña ñeñt̃ atet̃ otaret̃teteʼt̃: “Amach eʼñe orrena naʼyeneto poʼñoñet Parets paʼsoʼchño t̃arroʼmar ñerraʼm erraʼtsen neneʼ poʼñoñ Parets paʼsoʼchño ñeñt̃paʼ atarr huomenc ñoñets amach att̃a puesatscheto, c̈hocmachña eʼñe aʼpoctatyenet ñeñt̃ atet̃ oʼ nohuetña poʼñoñet Parets paʼsoʼchño.” Ñeñt̃paʼ atet̃caʼye otaret̃teteʼt̃ña ahuat̃ot̃eñ. ");
INSERT INTO ameNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","T̃arraña elloña na t̃eʼpaʼ oʼch noterres: Amaʼt eʼñe erraʼtsena paʼsoʼchñopaʼ amach senatsto señoñ. Amach sotatsto oʼch senaʼ señoñ Yompor pueʼntañ paʼsoʼchño; ñeñt̃paʼ ama tama huomencayeʼ senteññe ñeñt̃ecop atet̃ senen señoñ. T̃arroʼmar napaʼ oʼch notas amaʼt pueʼntañpaʼ ñeñt̃ poʼconañ pen Parets ñeñt̃oʼmarña att̃era atarr huomenc ñerraʼm Pamoʼmteʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ñam̃a amach sotatsto oʼch senaʼ señoñ Yompor poʼpatseñ paʼsoʼchño t̃arroʼmar ñeñt̃paʼc̈hoʼña att̃era atarr huomenc t̃arroʼmar ñeñt̃paʼ ñeñt̃ña nen Parets paʼtconet̃. Ñam̃a amach sotatsto oʼch senaʼ señoñ Jerusaléñ paʼsoʼchño t̃arroʼmar ñeñt̃paʼc̈hoʼña att̃ecma atarr huomenc t̃arroʼmar ñeñt̃paʼc̈hoʼña ñeñt̃ paʼnetser pen Parets. ");
INSERT INTO ameNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ñam̃a amach sotatsto oʼch senaʼ señoñ eʼñe sa soñ paʼsoʼchño t̃arroʼmar ñeñt̃paʼc̈hoʼña ama soyaye seyec̈hcatar. Amaʼt eʼñe puep̃arra sechpaʼ amat̃eʼ errot̃enot̃ selloʼtacheña sa. Ñam̃a ñerraʼm esempoch selloʼtenpaʼ amach errot̃enot̃ alla saʼquelluetatereña sa. ");
INSERT INTO ameNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Amaʼt errot̃ena sep̃aʼyesaʼchpaʼ atet̃chaʼ sotannaʼtyesa: Ñeñt̃paʼ atet̃chaʼcaʼye yepeʼ. Ama palltenoña oʼch senaʼyen señoñ amaʼt eʼñe esa paʼsoʼchño t̃arroʼmar ñerraʼm atet̃ sep̃aʼyenapaʼ ñeñt̃paʼ oneñet̃eshot̃a huena. ");
INSERT INTO ameNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Oʼch alla noterrserr poʼpoñ: Ñam̃a sapaʼ ahuat̃ot̃eñ seʼmareʼtña ñeñt̃ atet̃ oteteʼt̃: “Ñerraʼm eseshaʼ pochoclleʼcheʼ pamoʼts, semoñseñot̃ ñeñt̃ apochoclleʼcharet̃paʼ sepochoclleʼch ñam̃a ñeñt̃ pochoclleʼcheneʼ pamoʼts. Ñam̃a ñerraʼm eseshaʼ pueʼmoñeʼteñot̃an aʼcayam̃p̃san pamoʼts paʼspaʼ semoñseñot̃paʼ saʼcayam̃pes ñam̃a paʼs ñeñt̃ aʼcayam̃peneʼ pamoʼts paʼs.” Ñeñt̃paʼ atet̃caʼye otaret̃teteʼt̃ña ahuat̃. ");
INSERT INTO ameNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","T̃arraña na t̃eʼpaʼ oʼch notas ellonet̃: Amach semoñsatstoña sa eʼñe sañeña ñerraʼm esempo eʼmoñeʼtyenset. Atet̃ ñerraʼm esempo eseshaʼ pueʼmoñeʼteñot̃etas oʼch tacllaset setsaʼpo secohuenrot̃, sañapaʼ poctepaʼchña señch tacllerrserrepaʼ ñam̃a poʼpshem̃tañot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ñam̃a ñerraʼm esempo eseshaʼ mueneneʼ oʼch temantaset att̃och puerratam̃p̃saset seshtam, sañapaʼ poctepaʼchña señch puerratam̃p̃sasetepaʼ seshtam ñeñt̃ muenenet amaʼt ñam̃a poʼpmañ seshtam allo sepmatena. ");
INSERT INTO ameNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ñam̃a ñerraʼm eseshaʼ sanmatsreʼtateneʼ eʼñe att̃a pat̃err kilómetro, sañapaʼ poctepaʼchña señch oʼch sanmatsreʼch amaʼt epa kilómetro. ");
INSERT INTO ameNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ñam̃a ñerraʼm eseshaʼ es senamueneʼ, sañapaʼ sapepaʼch. Ñam̃a ñerraʼm eseshaʼch senamueneʼ oʼch es sarchapaʼ sañapaʼ sarchepaʼch. ");
INSERT INTO ameNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ñam̃a sapaʼ seʼmart̃eʼña atet̃ oteteʼt̃ ahuat̃: “Mueryetchaʼ pamoʼtset ñeñt̃ muerenahuet. T̃arraña ñeñt̃ eʼmoñeʼtenahuetpaʼ ñetpaʼc̈hoʼña oʼch eʼmoñeʼchet ñamet.” Ñeñt̃paʼ atet̃caʼye oteteʼt̃ amaʼt ahuat̃ot̃eñ. ");
INSERT INTO ameNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","T̃arraña naña t̃eʼpaʼ elloña oʼch noterres: Semueryach amaʼt ñeñt̃ seʼmoñeʼteneʼ. Ñam̃a ñeñt̃ sarrnomareʼtenaya sañapaʼ oʼch senamaterrñañ Yompor paʼnateña. Ñam̃a ñeñt̃ errot̃ sepeneʼpaʼ sañapaʼ añchaʼ atet̃ sepoñ ñeñt̃ atarr cohuen enten ña. Ñam̃a ñeñt̃ saʼmueroc̈htateneʼ sañapaʼ oʼch semaʼyocham̃pesya. ");
INSERT INTO ameNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Att̃ochña sapaʼ eñotenset poʼñoc̈h puechemer penes Yompor ñeñt̃ pueʼntañoʼtsen t̃arroʼmar sapaʼ añ sorrtatyen cohuen amaʼt eʼñe allohuenacop eʼñe atet̃ pena Sompor ñapaʼ eʼñe cohuenareʼ es orrtatyen amaʼt allohuenacop. Atet̃ ñapaʼ c̈hocma huapataʼmuenaneʼt̃ poʼpuetarenña allohuenacop amaʼt atsrreʼmñat̃ecop ñam̃a ñeñt̃ cohuenacop acheñer. Ñam̃a ñapaʼ c̈hocma huatateñ añecop ñeñt̃ eʼñe pocteʼ es pets amaʼt ñam̃a añecop ñeñt̃ ama pocteyeʼ es p̃aʼyetso. ");
INSERT INTO ameNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ñeñt̃oʼmarña notenes: Ñerraʼm aña eʼñe semorrentena ñeñt̃ semorrentenaya sam̃a ñeñt̃paʼ amach eʼñeyeʼ sorrtatenoña ñeñt̃ eʼñe poʼñoc̈h cohuentetsa, att̃oña Yomporpaʼ amach es apuerrso ñeñt̃chaʼ atarr socshaterreʼ. T̃arroʼmar ñeñt̃ ama ameʼñenayo Yompor, ñetpaʼ aña morrentenet ñeñt̃ eʼñe morrentenahuet ñamet. Sapaʼ eʼñecaʼye señoteñ eʼñe atet̃ pena ñeñt̃ pueshquëñot̃eʼna cobrenan acheñeneshaʼ shonteʼ quelle. Añña atarr cohuentetsa amaʼt ñeñt̃ ama yemorrentenayepaʼ oʼch yemorreñcha eʼñe cohuen. ");
INSERT INTO ameNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ñam̃a ñerraʼm eʼñe aña cohuen saguën ñeñt̃ eʼñe samoʼts sepen, ñeñt̃paʼ amach errot̃enot̃ sem̃tanoña ñeñt̃ ama ameʼñetso, t̃arroʼmar ñetpaʼ eʼñe aña cohuen aguënet ñeñt̃ eʼñe pamoʼts penet. ");
INSERT INTO ameNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ñeñt̃oʼmarña napaʼ notenes: Sapaʼ eʼñepaʼchña cohuenareʼ es sorrtatyen allohuenacop eʼñe atet̃ pena Sompor ñeñt̃ pueʼntañoʼtsen eʼñe cohuenareʼ es orrtatyenña ña. ");
INSERT INTO ameNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesúsñapaʼ atet̃ oterraneterr: —Eʼñech señota, amachña eʼñe sommoʼcheñot̃eʼnaña es sorrtatyeno cohuen Yomporecop att̃och acheñeneshaʼpaʼ oʼch entenset sapaʼ atarroʼ cohuen acheñreseñ. T̃arroʼmar ñerraʼm ñeñt̃ecpaʼna es sorrtatyen cohuen, Yomporña ñeñt̃ pueʼntañoʼtsenpaʼ amach es apuerrsoña sa ñeñt̃chaʼ atarr socshaterreʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ñerraʼm esempo es sapueñ huocchañneshaʼpaʼ eʼñechña aʼnahua sapuenanet. Sommoʼcheñot̃paʼ amach sotatsto entasepaʼ allohuen acheñeneshaʼ att̃och eʼñe cohuen entasetañ. T̃arroʼmar ñeñt̃paʼ ommoñat̃eneshaʼ atet̃ petsa. Ñeñt̃ ommoñat̃eneshaʼpaʼ ñerraʼm esempo es apueñet huocchañneshac̈hnopaʼ oʼch orrtachet alloʼtsaʼyen allohuen acheñeneshaʼ all puerahuoʼmar amaʼt ñam̃a t̃oñoʼmar; att̃ochña allohuen acheñeneshaʼpaʼ eʼñech cohuen entenanetañ. T̃arraña napaʼ oʼch notas, ñeñt̃ atet̃ petsapaʼ Yomporñapaʼ amach es apuerraneto ñeñt̃chaʼ atarr coshaterrahuet. T̃arroʼmar ñetpaʼ aña eʼnenet acheñeneshach cohuentatenahuet. Ñetpaʼ eʼñech alla atsaʼtaret̃terret. ");
INSERT INTO ameNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","T̃arraña sapaʼ ñerraʼm esempo es sapueñ huocchañneshac̈hno amach eseshaʼ sotap̃saʼtatsto amaʼt ñeñt̃ eʼñe parro seyemtannena. ");
INSERT INTO ameNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Eʼñechña aʼnahua es cohuen sep̃aʼyen, allochñapaʼ Sompor ñeñt̃ña enteneʼ allohuen ñeñt̃ aʼnahua es sep̃aʼyen, ñachña sapuerreʼ ñeñt̃chaʼ ello atarr socshaterreʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jesúsñapaʼ atet̃ oterraneterr: —Ñam̃a ñerraʼm esempo semaʼyochena sapaʼ amach atet̃ sep̃atsto atet̃ pena ommoñat̃eneshaʼ. Ñetpaʼ añecpaña maʼyochenet att̃och acheñeneshaʼpaʼ eʼñech cohuen entenanetañ. Ñeñt̃oʼmarña allempo maʼyochenetpaʼ arrach t̃omyesoset all shontena acheñeneshaʼ puerahuoʼmar amapaʼ all etsapeʼtyena t̃oñ allecma huac̈hena shonteʼ acheñeneshaʼ att̃ochña allohuen acheñeneshaʼpaʼ eʼñech cohuen entenanetañ. T̃arraña napaʼ poʼñoc̈hpaʼ oʼch notas: Ñeñt̃ atet̃ ommoʼchetsa Yomporñapaʼ amach apuerraneto ñeñt̃chaʼ coshaterrahuet t̃arroʼmar ñetpaʼ aña eʼnenet acheñeneshach cohuentatenahuet. Ñetpaʼ eʼñech alla atsaʼtaret̃terret. ");
INSERT INTO ameNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Sañapaʼ ñerraʼm esempo semaʼyochenapaʼ oʼch sebeʼt̃osyes soʼponro c̈hochña seyottam̃p̃sa att̃ochña sapaʼ amach sommoʼcheñot̃a semaʼyocheñoña Sompor, ñeñt̃paʼ eʼñech ñapuet̃ alloʼtsenes epas. Allochñapaʼ Sompor ñeñt̃ eʼñe ñapt̃a senteneʼ ñachña sapuerreʼ ñeñt̃chaʼ ello atarr socshaterreʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Sa ñerraʼm c̈ho semaʼyochenapaʼ amach att̃a nanac señosatsto atarr aton eʼñe orrena ñeñt̃ atet̃ pena poʼpoñ acheñeneshaʼ ñeñt̃ ama ameʼñenayo ñeñt̃ ya Yeyomporer. Ñetpaʼ atarr t̃ematen maʼyochenetañpaʼ t̃arraña ñeñt̃ach alla oterreteʼt̃. C̈hat̃eʼ otenapuetañ ñerraʼm atarr t̃ematen eñosetpaʼ eʼñet̃eʼ cohuen entenanet Yompor att̃och eʼñe cohuen eʼm̃ñotenanet. ");
INSERT INTO ameNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Sañapaʼ amach atet̃ sep̃atsto atet̃ penet ñet t̃arroʼmar sapaʼ amaʼt ama es senamuenaʼ semaʼyocheñot̃, Somporña eʼñe eñotuennas ñeñt̃ sepalltaʼyena. ");
INSERT INTO ameNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Sañapaʼ atet̃chaʼña cohuen semaʼyochaña sa: Yompore Partso ñeñt̃ep̃ peʼntañoʼtsen, yentapepaʼch p̃a atarr Partsop̃. ");
INSERT INTO ameNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","C̈hapuepaʼch Nompore allempoch atarr p̃aʼyochreshat̃terra arr patsro. Yetsotonapepaʼch arr patsro ñeñt̃ atet̃ pemnen p̃a Nompore ñeñt̃ atet̃ penet ñam̃a all peʼntaño. ");
INSERT INTO ameNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","C̈hocmuepaʼch Nompore p̃apueney ñam̃a yocrram̃ ñeñt̃ allpon yepalltaʼyena pat̃eʼtets yet̃. ");
INSERT INTO ameNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pep̃retnaʼhuonayepaʼch Nompore allohuen yoʼchñar ñeñt̃ ama pocteyeʼ pentapretenye att̃o Nompore yapaʼc̈hoʼña yep̃retnannena ñerraʼm esempo errot̃ yep̃annena. ");
INSERT INTO ameNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ñam̃a amach Nompore pemnatatsche sosyaʼtsañ oʼch atarr topateney. Añchaʼña c̈hoch Nompore p̃aʼypoʼñataterrey allohuen sosyaʼtsañec̈hno. T̃arroʼmar eʼñe p̃a Nompore ayochreshat̃tetsa ñeñt̃ep̃ atarr Partseshatets, eʼñe p̃apt̃a ñeñt̃ep̃ Nompore ayeʼchoc̈htataret̃tetsa eʼñe errponañohuen. Ñeñt̃ach nenamap̃; ñeñt̃paʼ att̃epaʼch Nompore. ");
INSERT INTO ameNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Ñerraʼm sa c̈hocma sep̃retnannena att̃o errot̃ sep̃annenapaʼ sapaʼc̈hoʼña c̈hocmach peretnerresña Sompor ñeñt̃ pueʼntañoʼtsen. ");
INSERT INTO ameNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","T̃arraña ñerraʼm ama c̈ho sep̃retnannenopaʼ Somporpaʼc̈hoʼña amach peretnerrnasoña sam̃a soʼchñar. ");
INSERT INTO ameNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jesúsñapaʼ atet̃ oterraneterr: —Ñam̃a ñerraʼm esempo semneñ semaʼyocheñot̃ Yompor oʼch sequec̈hpaʼ serrar ñeñt̃paʼ eʼñe pocteʼ. T̃arraña ñeñt̃paʼ ama añecpayaye att̃och entas acheñeneshaʼ ñerraʼm c̈ha sellcaʼhuena. T̃arroʼmar ñeñt̃paʼ ommoñat̃eneshaʼña atet̃ petsa. Ñetpaʼ ñerraʼm esempo quec̈hpuenet puerrar Yomporecop ñetpaʼ att̃ach atsoclloyayenet allochñapaʼ att̃och eñotenanet acheñeneshaʼ ñetpaʼ Yomporecpoʼ atet̃ penet. T̃arraña na poʼñoc̈hpaʼ oʼch notas: Ñeñt̃ atet̃ ommoʼchetsa puet̃oreʼteñot̃ Yomporñapaʼ amach es apuerraneto ñeñt̃chaʼ atarr coshaterrahuet. T̃arroʼmar ñetpaʼ aña eʼnenet acheñeneshach cohuentatenahuet. Ñetpaʼ eʼñech alla atsaʼtaret̃terret. ");
INSERT INTO ameNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","T̃arraña sa ñerraʼm esempo eʼñe semaʼyocheñot̃ Yompor oʼch sequec̈hpaʼ serrar sapaʼ att̃erachña sorrtena eʼñech cohuen satsam̃oʼtyena ñam̃a seʼpaclleʼchyena. ");
INSERT INTO ameNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Allochña acheñeneshaʼpaʼ amach c̈ha eñotaseto sapaʼ c̈ho sequec̈hpuen serrar maʼyochaya Yompor. Sapaʼ eʼñech ñapt̃a Sompor senteneʼ ñeñt̃ pueʼntañoʼtsen. Allochñapaʼ Sompor ñeñt̃ eʼñe ñapt̃a senteneʼ ñachña sapuerreʼ ñeñt̃chaʼ ello atarr socshaterreʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jesúspaʼ alla oterrerr: —Ñam̃a amach seshontaʼyesatsto checmañats añe patsro ñeñt̃chaʼ atarr semorrentena. Ñeñt̃paʼ atarr apom̃pereʼchña atarr aptsaña. Amaʼt eñet̃paʼ oʼch beʼt̃osam̃p̃sonasapaʼ oʼch yoratsreʼtam̃pesuas. ");
INSERT INTO ameNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Yompor pueʼntañochña seshontaʼyesña ñeñt̃ eʼñe poʼñoc̈h sherbets. Ñeñt̃paʼ ama apom̃pereʼchño ñam̃a ama aptsaño. Allpaʼ amaʼt eñet̃apaʼ ama beʼt̃eno att̃och yoratsreʼtam̃pesuas. ");
INSERT INTO ameNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","T̃arroʼmar ñerraʼm all Yompor pueʼntaño seshontaʼnen ñeñt̃ atarr cohuen senten, yeñoteñ eʼñe ñeñt̃a pat̃err senen seyoc̈hro ñeñt̃ña atarr sherbets Yomporecop. T̃arraña arr patsro ñerraʼm aña seshontaʼnen ñeñt̃ atarr semorrentena, yeñoteñ eʼñe ñeñt̃a pat̃err senen seyoc̈hro ñeñt̃ñapaʼ ama es sherbenoña Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","Jesúsñapaʼ alla oterraneterr: —Yeclleʼpaʼ añ tomaʼntena atet̃ ñerraʼm ñeñt̃ poʼlampareñ pen ora yechets. Ñerraʼm eʼñe cohuen huomech yeclleʼpaʼ eʼñech cohuen entateney puetareʼ. Allochñapaʼ att̃och eʼñe cohuen t̃orratyenana allemeñ yechets t̃arroʼmar eʼñe cohuen aʼpuetarsam̃p̃saret̃tenet. T̃arraña yeclleʼña ñerraʼm ama eʼñe cohuen huom̃cheyayepaʼ amach eʼñe cohuenayeʼ entatenye puetareʼ att̃ochña amach eshcayeʼ t̃orratyenano allemeñ yechets t̃arroʼmar c̈ha ottena ñerraʼmrrat̃eʼ checmetoʼtsaʼyeneta. Att̃ecma pena ñam̃a yeyoc̈her. Ñerraʼm eʼñe cohuen yoct̃apeʼchyen yeyoc̈hro, ama aña es yeʼnyeno ñeñt̃ eʼñe yocpa, att̃oña c̈hennayaña eʼñe ora allohuen Yompor poct̃ap̃ña ñeñt̃ poʼcohuenña pen. Att̃oña ora yoct̃ap̃ñapaʼ eʼñech aʼpuetarsam̃p̃saret̃tena Yomporeshot̃. T̃arraña ñerraʼm ama cohuenayeʼ yoct̃apeʼcheno yeyoc̈hro, ñerraʼm aña yeʼnyen ñeñt̃ eʼñe yocpa ñeñt̃paʼ amach errot̃enot̃ aʼpuetarsam̃penyeña ñeñt̃ yoct̃ap̃ña yepen. Ñeñt̃ña yoct̃ap̃ña yepenpaʼ atarrchaʼ aʼchecmetam̃pennay yeyoc̈her. ");
INSERT INTO ameNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Ñeñt̃paʼ atet̃chaʼ yetmaʼntacha: Amaʼt puesheñarrot̃eyapaʼ amach errot̃enot̃ eʼñe cohuen yetaruasoña epsheñoʼmar yamoʼmtayecop. T̃arroʼmar ñerraʼm atet̃ yep̃apaʼ puesheñarr eʼñech cohuen yemorrenteñot̃ yocsheñeshocmañen yesherbeñ, poʼpsheñeññapaʼ amach eʼñeyeʼ yemorrenteño; c̈hach yottena ñerraʼm c̈ha yetsenaʼteñ. Ñeñt̃oʼmarña ñeñt̃paʼ amach cohuenayeʼ yesherbeñe. Ñerraʼm aña eʼñe semaʼyoc̈hrena ñeñt̃ eʼñe socpa att̃och segana aton quelle, ñeñt̃ atet̃paʼ amach errot̃enot̃ semaʼyoc̈hroña ñam̃a ñeñt̃ecop atarr sherbets Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Ñeñt̃oʼmarña t̃eʼpaʼ oʼch noterrserr: Amach aña sellcatsto ñeñt̃ att̃o yocrrena arr patsro. Amaʼt seyoc̈hrapaʼ amach sotatsto, esuachcaʼ yerrerrerrt̃eʼ tsapat̃onet̃, esuachcaʼ yorrt̃eʼ. Ñam̃a amach aña sellcatsto ñeñt̃ eʼñe sechtsocpa. Amach sotatsto, esuachcaʼ yechorrat̃eʼ. T̃arroʼmar Yompor ña yapueneʼ yoʼrrerrña allo yocrrena ñeñt̃ña atarr nanac sherbets. Ñeñt̃oʼmar yeñoteñ ña yapueneʼ ñam̃a yerrar ñeñt̃ña ñocoppaʼ ama esoyeʼ enteñe. Ñam̃a ña yec̈hcateneʼ yeʼchets ñeñt̃ atarr sherbets. Ñeñt̃oʼmar yeñoteñ ña yapueneʼ ñam̃a amaʼt ñeñt̃ yechorraʼyena ñeñt̃ña ñocop ama esoyeʼ enteñe. ");
INSERT INTO ameNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Senteñt̃eʼ att̃o correna ot̃neshac̈hno ñeñt̃ anomc̈haʼtyetsa entonet̃. Ñetpaʼ ama c̈hoyeʼ nareʼtatseʼteneto ñam̃a ama c̈hoyeʼ apc̈haʼyeneto puerrar ñeñt̃chaʼ rraʼyenet. Ñetpaʼ ama es echenaye allchaʼ es aññoʼtyenet. Amaʼt att̃o correnet Somporña ñeñt̃ pueʼntañoʼtsenpaʼ eʼñe yec̈hcatyesuanet ñeñt̃chaʼ puerrar p̃aʼyenet. Elloña sa Yomporpaʼ atarr morrentensa sa; ello sem̃taneñ ñeñt̃ att̃o atarr morrentenana ot̃neshac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ñam̃a amach sellcatsto att̃och amach serromo t̃arroʼmar amaʼt sellquënañ att̃och atarr atomat socrra arr patsro, t̃arraña amaʼt eʼñe puesheñarrot̃esapaʼ amat̃eʼ errot̃enot̃ soʼchtatoña socrreña amaʼt eʼñe pamt̃arra. ");
INSERT INTO ameNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Esoʼmareʼtchaʼña sellcaʼyesaña att̃och sepashta. Senteñt̃eʼ atet̃ yec̈hquëna rorec̈hno ñeñt̃ chopyets ñota allemeñ. Ñetpaʼ ama c̈hoyeʼ taruasaʼyeneto amaʼt mamesha ama c̈hoyeʼ taneneto ñeñt̃ chorraʼyenet att̃o eʼñe cohuen orretyenet. ");
INSERT INTO ameNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","T̃arraña napaʼ oʼch notas: Amaʼt am̃chaʼtaret̃ Salomón att̃o eʼñe aʼcohuentateʼt̃ ahuat̃, amaʼt ñapaʼ ama chorraneʼt̃eña ñeñt̃ atarr cohuen ñeñt̃ atet̃ atarr cohuentena ror. ");
INSERT INTO ameNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ñam̃a ñeñt̃ ror pueʼchorpaʼ ñeñt̃ara taʼteʼ ñeñt̃ chopyets allemeñ ñeñt̃ sentyen t̃eʼ t̃arraña ñeñt̃paʼ mamecpa. Amaʼt cohuen chopyeneñ t̃eʼpaʼ tsapat̃onet̃ñapaʼ oʼch et̃omam̃peretpaʼ eʼñech collaʼhuerrapaʼ oʼhuañchaʼ cohuenta. Ñehua, Yompor att̃o cohuentatyenan amaʼt ñeñt̃ eʼñe mamecpa, elloña sapaʼ atarr chorratyensañ sam̃a; sañapaʼ esoʼmart̃eʼña amaña eʼñeyeʼ seyemteño. ");
INSERT INTO ameNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ñeñt̃oʼmarña notenes: Amach atarr sellcaʼyesatsto. Amach sotatsto: “Esuachcaʼye yerraʼt̃eʼ. Esuachcaʼye yorrt̃eʼ.” Amach sotatsto: “Esuachcaʼye yechorrat̃eʼ.” ");
INSERT INTO ameNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","T̃arroʼmar allohuen acheñeneshaʼ arr patsro ñeñt̃ ama ameʼñaʼyetso, ñetpaʼ ñeñt̃aña eʼñe pat̃err eʼnenet. Ñehua, Somporña ñeñt̃ pueʼntañoʼtsen ñapaʼ eʼñe entuenes ñeñt̃ allpon paʼnamen sepalltaʼyena arr patsro. ");
INSERT INTO ameNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Sapaʼ añchaʼña eʼñe ñanom semaʼyoc̈hrena Yomporecop att̃och atarr ayochreshat̃tena ña. Ñam̃a añchaʼña semaʼyoc̈hrena ñeñt̃ eʼñe pocteʼ enten ña, allochñapaʼ ñachña sapaʼyeneʼ ñeñt̃ allpon sepalltaʼyena sam̃a. ");
INSERT INTO ameNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Amach eʼñe t̃ayecma sellcaʼyesatsto ñeñt̃chaʼ setantyesoya tsapat̃onet̃. T̃arroʼmar amaʼt eʼñe t̃ayot̃eñpaʼ c̈hocma eñall ñeñt̃ allcatañetyetsa amaʼt eʼñe pat̃eʼtets yet̃. ");
INSERT INTO ameNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesúspaʼ atet̃ oterraneterr: —Sapaʼ eʼñe att̃ot̃apaʼ amach sotteñeʼchatsche poʼpsheñeñ allochñapaʼ amach otteñeʼcherrso sam̃a Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","T̃arroʼmar ñerraʼm atet̃ sotteñeʼchyeñ poʼpotantañ, Yomporpaʼc̈hoʼña eʼñech att̃ecma otteñeʼcherres sam̃a. Ñerraʼm errponochchaʼ sotteñeʼchyeñ poʼpotantañpaʼ sapaʼc̈hoʼña eʼñech allponoch otteñeʼcherres sam̃a Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","5","Amach atet̃ sentatsche poʼpotantañ ñerraʼm ñetpaʼ ama cohuenayeʼ es peneto, amaʼt sapaʼ ama sentenoña ñeñt̃ atet̃ sep̃aʼyena sa ñeñt̃paʼ ello sem̃taneñña poʼpotantañ ñeñt̃ atet̃ es p̃aʼyenet ñet. Ñerraʼm ama cohuenayeʼ es sepeno sam̃apaʼ amach sotatscheña poʼpotantañ: “Napaʼ oʼch noct̃apeʼchatuerres eʼñe cohuen.” T̃arroʼmar ñerraʼm atet̃ sepenapaʼ c̈ha sommoʼchena. Ñanomchaʼña añ sehuaporeʼterr ñeñt̃ ama cohuenayeʼ sepeno sa, allochñapaʼ att̃och señoch cot̃apeʼchateʼ samoʼts eʼñe cohuen. Ñeñt̃paʼ añ tomaʼntena oʼch sentoñ poʼpsheñeñ paʼclloyoʼtsen puepachña amaʼt sa seclloyopaʼ alloʼtsen tsach; ñeñt̃ñapaʼ ama senteñe. Ñerraʼm atet̃paʼ amach errot̃enot̃ socheña poʼpsheñeñ napaʼ oʼch nechterrnap̃ peclloyot̃ pepachña t̃arroʼmar añ tsach ñeñt̃ seclloyoʼtsenpaʼ c̈ha aʼnpuennasña att̃och eʼñe cohuen es sentyen. Ñanomchaʼña añ sehuaporeʼterr tsach seclloyot̃ allochñapaʼ att̃och eʼñe cohuen es sentyen. Att̃ochña eʼñe cohuen sechterrñañ poʼpsheñeñ puepachña paʼclloyot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Jesúspaʼ atet̃ oterraneterr poʼpoñ: —Ñeñt̃ ama quec̈hpuenaye pachm̃areñ ñam̃a pat̃pareñ amach alla seserrpareʼtaterraneteʼt̃e Parets poʼcohuenña. T̃arroʼmar ñetpaʼ att̃a penet ñerraʼmrrat̃eʼ ochec. Ñehua, ochec ñerraʼm esempo amaʼtchaʼ atarr cohuen yap̃paʼ yaʼnach rremaʼpes c̈hach ac̈hotaʼteypaʼ oʼch shetsay. Ñam̃a amaʼt atet̃ ñerraʼm chañcho ñerraʼm esempo es yenaʼ ñesho amaʼtchaʼ atarr cohuen yenten ya, yeser, chañchoñapaʼ att̃ach at̃mamaʼtam̃p̃sey t̃arroʼmar chañchopaʼ ama esoyeʼ entenano amaʼt ñeñt̃ atarr cohuen. ");
INSERT INTO ameNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesúspaʼ alla yec̈haterraneterr poʼpoñ, ñeñt̃paʼ atet̃ oterraneterr: —Eʼñe senamueñot̃, Yomporñapaʼ apaschaʼ. Seʼnameʼteñot̃paʼ señchchaʼ; sec̈horeʼteñot̃, Yomporñapaʼ eʼñe pueʼm̃ñoteñot̃espaʼ eʼñech cohuen toram̃p̃sapas. ");
INSERT INTO ameNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","T̃arroʼmar ñeñt̃ es enamareʼtetspaʼ ñetña es aguëtset; ñam̃a ñeñt̃ es eʼnameʼtets ñetñapaʼ c̈hocmach eñchet ñam̃a erraʼtsen ñeñt̃ c̈horeʼtyeneʼ ñetñapaʼ eʼñe eʼm̃ñotenanet Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","11","’Yompor ñeñt̃ pueʼntañoʼtsen c̈hocmach eʼñe cohuenareʼ es apaʼyeney ñerraʼm esempo es yenamueñ. Ñapaʼ amach aña apuenye ñeñt̃ ama cohuenayeʼ yenteno ya. Amaʼt sa ñeñt̃es arromñat̃es atet̃ sepeñ sam̃a sechemer, eʼñech cohuen es sapueñ ñerraʼm esempo es enamuenes. Atet̃ ñerraʼm allempo paʼchporrñot̃ es enamuenes, oʼch enamas mam ñeñt̃chaʼ rraʼ, sapaʼ amaʼt puesheñarrot̃esapaʼ amach aña sapueñeña sechemer mapueʼ ñeñt̃ ama arrapahuoyaye. Amapaʼ ñerraʼm cac enamuenes sañapaʼ amaʼt puesheñarrot̃esapaʼ amach aña sapueñeña sechemer shechep̃ ñeñt̃ atarr amueroc̈htatañ. Ñeñt̃oʼmarña sa amaʼt arromñat̃es amaʼt ñam̃a atsrreʼmñat̃es sapaʼ eʼñe señoteñ apaʼyeseʼ sechemereshaʼ eʼñe cohuenareʼ. Añña ñeñt̃ Seyomporer sepen sam̃a ñeñt̃ pueʼntañoʼtsen elloña ñapaʼ eʼñe eñoteñ att̃o eʼñe cohuenareʼ es apaʼyenes sam̃a ñeñt̃es es enamueneʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Ñeñt̃oʼmarña atet̃ notenes: Ñerraʼm erraʼtsent̃eʼ eʼñe cohuen senten ñeñt̃ semnen sa ñeñt̃chaʼ atet̃ p̃onas poʼpsheñeñ, sapaʼc̈hoʼña eʼñech att̃ecma sep̃anet sam̃a. T̃arroʼmar ñeñt̃paʼ atet̃ oteney Yompor poʼñoñ ñeñt̃ ahuat̃ot̃eñ, amaʼt Moisés poʼñoñ ñeñt̃ atet̃ anaret̃ amaʼt ñam̃a ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñpaʼ eʼñe att̃ecma otyeseteʼt̃. ");
INSERT INTO ameNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Jesúsñapaʼ atet̃ tomaʼntaterraneterr, ñeñt̃paʼ atet̃ otanet: —Sebeʼt̃os yetarro añet̃oll t̃arroʼmar ñeñt̃ atarr yetarr, atarr t̃oñ ñeñt̃paʼ alla sen chencaʼpuetso. Shonteʼ acheñeneshaʼpaʼ eʼñe alla beʼt̃osc̈haʼtyenet. ");
INSERT INTO ameNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ñeñt̃ña añet̃oll yetarr, añet̃oll t̃oñ ñeñt̃ñapaʼ arr sen corraʼpuetso allña sapaʼ corretsasach. Eʼñe puesheñaʼttsa enteneʼña ñeñt̃ t̃oñer. Ñeñt̃paʼ añ tomaʼntena att̃och yoct̃er Cristo, c̈hoch yesuanemña ñeñt̃ ama cohuenayeʼ entapretenye. ");
INSERT INTO ameNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jesúsñapaʼ atet̃ oterraneterr: —Sapaʼ señotaʼt̃ach t̃arroʼmar huaponasach ñeñt̃chaʼ ayc̈haʼnatatsa ñetpaʼ aʼm̃tenetoʼ Yompor poʼñoñ. Ñetpaʼ pueshquëñot̃etpaʼ ottenetañ atet̃ ñerraʼm atarr cohuen acheñret eʼñech att̃etañ ñerraʼmrrat̃eʼ carrnero ñeñt̃ ama errot̃ ap̃añeyaye amaʼt mamesha. T̃arraña ñetpaʼ att̃a shequënet t̃arroʼmar eʼñe poʼñoc̈h ñetpaʼ eʼñe att̃et ñerraʼmrrat̃eʼ maʼyarr ñeñt̃ añach eʼnyen ñeñt̃ eʼñe ñocpa. Att̃ot̃chaʼña eʼñe aʼchencatuerran acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","20","T̃arraña sapaʼ att̃ot̃chaʼña eʼñe sechmeʼtyesanet. T̃arroʼmar allohuen acheñeneshaʼ ñeñt̃ eʼñe poʼñoc̈h cohuen acheñeneshar, ñetpaʼ añchaʼña orrtatyenet ñeñt̃ eʼñe cohuenareʼ. T̃arraña poʼpotantañ acheñeneshaʼ ñeñt̃ poʼñoc̈h ama cohuenayaye, ñetñapaʼ añach orrtatyenet ñeñt̃ ama cohuenayaye. Ñeñt̃paʼ atet̃chaʼ netmaʼntacha. Ora allohuen ñeñt̃ eʼñe cohuenareʼ narmetsochec̈hnopaʼ pueʼmerpaʼc̈hoʼña eʼñech cohuenareʼ. Amaʼt parrochapaʼ amach meʼtoña ñeñt̃ ama cohuenayaye. Añña poʼpchañec̈hno narmetsochec̈hno ñeñt̃ ama cohuenayaye, pueʼmerpaʼc̈hoʼña amach cohuenayaye. Ñeñt̃paʼc̈hoʼña amaʼt parrochapaʼ amach meʼtenoña eʼñe cohuen. Ñam̃a yapaʼ eʼñe yeñoteñ amaʼt errot̃enapaʼ ama arrot̃eyeʼ yet̃oquënoña lloʼm ajchot̃. Ñam̃a amaʼt errot̃enapaʼ ama arrot̃eyeʼ yet̃oquënoña ap rrenagachot̃. Ñeñt̃oʼmarña att̃oña yeñoteñ erraʼtsent̃eʼ ñeñt̃ eʼñe cohuenareʼ narmetsoch, ñam̃a ñeñt̃ ama cohuenayaye; pueʼmerot̃ña yechmeʼteñ. Ñam̃a allohuen narmetsochec̈hno ñeñt̃ ama cohuenayeʼ meʼtyetsopaʼ aʼmataʼtueretchaʼ saprrotueretchaʼ tso. ");
INSERT INTO ameNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jesúsñapaʼ atet̃ oterraneterr: —Ñeñt̃ notyenayeñ: “P̃apaʼ poʼñoc̈h naʼyochreshat̃er nepenep̃”, t̃arraña amach allohuenacmayeʼ c̈hapueto all am̃chaʼtaret̃tena Nompor Parets ñeñt̃ pueʼntañoʼtsen. Añach c̈hapyerrets all ñeñt̃ eʼñe poʼñoc̈h atet̃ peneʼ ñeñt̃ atet̃ muenen Nompor ñeñt̃ pueʼntañoʼtsen. ");
INSERT INTO ameNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Allempopaʼ shonteʼch acheñeneshaʼ ñeñt̃chaʼ notyerrayeñ: “Poʼñoc̈h Ayochreshat̃e eʼñe pesoʼchñopaʼ c̈hocmacaʼye yaʼm̃tonapeʼt̃ña peñoñ. Ñam̃a yec̈horeʼteñot̃ep̃ pesoʼchñopaʼ c̈hocmacaʼye yequec̈hpatacheʼt̃ña shonteʼ oneñet̃ec̈hno. Ñam̃a yec̈horeʼteñot̃ pesoʼchñopaʼ epayeʼcaʼye yorrtatyeseʼt̃ña partsoteñets.” ");
INSERT INTO ameNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Naña allempopaʼ naʼmet̃aʼhuerranetchaʼ, notyerranetchaʼ: “Amaʼt ahuat̃apaʼ ama nentarso, ama neyochreshayayso. T̃eʼpaʼ orrerres, sapaʼ aña setsoten ñeñt̃ ama cohuenayeʼ nenteno.” ");
INSERT INTO ameNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jesúsñapaʼ atet̃ oterraneterr: —Allohuen ñerraʼm erraʼtsenchaʼ eʼm̃ñoteneʼ neñoñ ñeñt̃ atet̃ eʼñe cohuen neyc̈hatenanet, ñerraʼm ñetña eʼñech atet̃ penet, ñetñapaʼ eʼñech eñoteñet ñeñt̃ eʼñe poʼñoc̈h sherbets. Ñeñt̃ acheñer ñeñt̃ atet̃ petsapaʼ ñapaʼ eʼñe atet̃ ñerraʼmrrat̃eʼ puesheñarr yacma ñeñt̃ atarr es eñotets. Ñañapaʼ t̃omatan paʼpaquëll, eʼñe echarr peʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Eʼñe t̃omatueʼpaʼ huata huomenc, apellchena oñ, orrnota, pocollñapaʼ orrnotam̃p̃sa. Ama aʼmatam̃p̃se t̃arroʼmar quellpachpaʼ eʼñe echarr at̃omataret̃. ");
INSERT INTO ameNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","T̃arraña poʼpotantañña ñeñt̃ eʼm̃ñoteneʼ neñoñ ñetña ñerraʼm amach att̃eyeʼ peneto ñeñt̃ notenanet, ñetñapaʼ eʼñech att̃eta ñerraʼmrrat̃eʼ puesheñarr yacma ñeñt̃ ama es eñoteno. Ñapaʼc̈hoʼña t̃omataneñchaʼña paʼpaquëll, t̃arraña amach echarroyeʼ pe. ");
INSERT INTO ameNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Eʼñe t̃omatueʼpaʼ huata huomenc, apellchena oñ, orrnota, pocollñapaʼ orrnotam̃p̃satsapaʼ c̈hepaʼtchaʼ mataʼnerretspaʼ eʼñe muellotsetuerra. ");
INSERT INTO ameNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Allempo serrpareʼtatuanet Jesús, acheñeneshaʼñapaʼ epayeʼ cohuanrrorteñet ñeñt̃ atet̃ yec̈hatenanet ña. ");
INSERT INTO ameNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","T̃arroʼmar ñapaʼ atarr cohuen yec̈hatenanet ñerraʼmrrat̃eʼ ñeñt̃ allsensaret̃tetsa Partseshot̃. Judioneshaʼ paʼm̃chaʼtaret̃erneshaʼ ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃, ñetñapaʼ ama eʼñeyeʼ att̃eyeʼ yec̈hateneto. ");
INSERT INTO ameNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Allempoña err Jesús aspent̃ot̃paʼ cot̃aʼhuanererr acheñeneshaʼ nanac shonteʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Allñapaʼ huapoña puesheñarr ñeñt̃ osen puetsarñats ñeñt̃ otenet lepra. C̈hap Jesúseshopaʼ allent̃a concorposana Jesúspaʼ atet̃ otos: —Ayochreshat̃e ñerraʼm p̃a muenats p̃apaʼ ñeñt̃ep̃ atarr ahuamencat̃eshap̃ p̃aʼcrratayeʼcherren allochñapaʼ att̃och eʼñe cohuen entuerren acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesúsña anretapaʼ allent̃a aʼp̃lleʼ, atet̃ och: —Napaʼ nemneñcaʼye, metuerrepaʼña peptsarña allochñapaʼ att̃och eʼñe cohuen entuerrep̃ allohuen acheñeneshaʼ. Yacmañapaʼ allorocmuepaʼtchaʼ metuerña pueptsarñapaʼ c̈ha cohuenterrtsa. ");
INSERT INTO ameNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesúsñapaʼ alla otererr: —T̃eʼ att̃o oʼ naʼcrraterrep̃paʼ poʼñoc̈h amaʼt eʼñe puesheñarrapaʼ amach p̃otap̃saʼtatsche amaʼt mamesha. Corneshachña pegatenaʼ all peptsarseʼt̃. Atet̃ naneʼt̃ Moisés ñoñets añ acheñrecop ñeñt̃chaʼ aʼcrrataret̃terrtsapaʼ t̃eʼñapaʼ oʼch es p̃anom ñeñt̃chaʼ p̃apos all ñeñt̃ Yomporecop allochñapaʼ att̃och eʼñe cohuen enterrep̃ allohuen acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Allempoña c̈herr Jesús Capernaumopaʼ allñapaʼ huapoña puesheñarr solltar poʼcap̃taner, ñeñt̃ñapaʼ romoʼmarneshaʼ ama judioneshayaye. Ñañapaʼ atarr otareʼtosan Jesús, ");
INSERT INTO ameNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ñeñt̃paʼ atet̃ otos: —Nomporchaʼ nepacllopaʼ atarr paʼnat̃tenapa neñañra. Alla p̃anena poʼmayo nanac mueroc̈htena c̈ha echarrtena. ");
INSERT INTO ameNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesúsñapaʼ atet̃ och: —Amaʼtpaʼ napaʼ oʼch ahuen oʼch naʼcrrateraʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Capitánña puepatareʼteñot̃paʼ atet̃ och: —Na Nomporchaʼpaʼ ama cohuenayayno att̃och pebeʼt̃osapoʼtam̃pesna nepacllo. Arrot̃ach p̃ot: “Amaʼtpaʼ correrrepaʼ peñañra”, neñañrañapaʼ acrrerrocheʼch. ");
INSERT INTO ameNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","T̃arroʼmar napaʼ ñeñt̃en ñeñt̃ atet̃ petsa ñeñt̃ atet̃ otenen ñeñt̃ neyechenaya na. Napaʼc̈hoʼña eñall ñeñt̃ neyechena nam̃a ñeñt̃ nesolltarer nepen. Ñerraʼm puesheñarr solltar noteñ: “P̃apaʼ oʼch ahuep̃ aʼyo”, ñañapaʼ oʼchc̈hoʼ ahuoʼ. Ñam̃a poʼpsheñeñ solltar ñerraʼm noch: “P̃apaʼ ap̃on arr”, ñañapaʼ oʼchc̈hoʼ huapa. Ñam̃a poʼpsheñeñ naʼtaruasañer ñerraʼm noch: “P̃apaʼ arrchaʼ petaruasaʼmuen”, ñapaʼ allchaʼc̈hoʼ taruasaʼmuen. Ñeñt̃oʼmarña napaʼ neñotenep̃ ñerraʼm errot̃en p̃otenpaʼ eʼñechcaʼye atet̃ pena. ");
INSERT INTO ameNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Allempo eʼman Jesús ñeñt̃ atet̃ oten capitán, ñañapaʼ atet̃ otan allohuen acheñeneshaʼ ñeñt̃ cot̃aʼneneʼ: —Ñapaʼ atarrcaʼye yemtenna, amaʼt ñapaʼ amacaʼye judioneshayaye. Napaʼ poʼñoc̈h oʼch notas: Amaʼt ahuat̃apaʼ ama nentareña acheñ ñeñt̃ eʼñe atet̃ neyemtenaya, amaʼt allohuen israelenaʼtarneshaʼpaʼ amaʼt puesheñarra ama nentareña ñeñt̃ atet̃ atarr neyemtenaya. ");
INSERT INTO ameNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ñeñt̃oʼmarña t̃eʼpaʼ oʼch notas: Shonteʼch acheñeneshaʼ ñeñt̃ ama judioneshayaye ñeñt̃chaʼña eʼñe neyemterraya. Allochñapaʼ esempohuañenpaʼ ñetñapaʼ allem̃at̃eñchaʼ eʼñe huac̈haʼtuerret ñeñt̃chaʼ anorrc̈haʼtyesuerrets all eʼñe Yomporesho all am̃chaʼtaret̃tena ña pueʼntaño. Allchaʼña rrallmeʼchapreteret yatañneshac̈hno Abraham, ñam̃a Isaac ñam̃a Jacob. ");
INSERT INTO ameNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Shonteñña judioneshaʼ ñetchaʼña c̈hapatsetañ all am̃chaʼtaret̃tena Yompor, t̃arraña ñetñapaʼ amach c̈hapueto all t̃arroʼmar ñetpaʼ ama nayeʼ yemteneto. Ñetñapaʼ allach ahuaporeʼtaret̃terret aʼyot̃ checmeto. Allñapaʼ allchaʼ yahuanrrorterret, panmueñot̃et atserrpaʼ rrasoʼtyesosetchaʼ paʼs. ");
INSERT INTO ameNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Allempoña Jesúspaʼ alla oterranerr capitán: —T̃eʼpaʼ oʼch ahuerrep̃ pepacllo, eʼñe att̃o atarr peyemtennapaʼ att̃etepaʼch p̃ocop. Pueñañrañapaʼ eʼñe allempocma correrra. ");
INSERT INTO ameNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Allot̃ñapaʼ c̈hap Jesús Pedro paʼpacllo. Allñapaʼ entosñañ paʼsoʼmue alla p̃anena poʼmayo c̈ha atsnaʼten, c̈ha hueraten. ");
INSERT INTO ameNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesúsñapaʼ allent̃a aʼp̃llosñañ potpaʼ c̈ha metuerretsña poʼurateña. Allent̃a tantapaʼ oʼ yemaʼtallmeʼchap̃a. ");
INSERT INTO ameNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ñeñt̃e yet̃rocma allempo ellerrenpaʼ huac̈haʼtateññañeterr shonteʼ ñeñt̃ chorraʼyena oneñet̃. Jesúsñapaʼ eʼñe poʼñoñot̃a quec̈hpatuerranet oneñet̃ ñeñt̃ chorraʼyenahuet. Ñam̃a allohuen ñeñt̃ atsnaʼtyetspaʼ oʼ aʼcrratyesapanet. ");
INSERT INTO ameNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ñeñt̃paʼ t̃arroʼmar atet̃ p̃a allochñapaʼ att̃och etsota Isaías poʼñoñ ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ; ñapaʼ atet̃ oteʼt̃: “Ñapaʼ ñach yahuanmam̃perreʼ ñeñt̃ yemueroc̈htatyeneʼ, ñapaʼ ñach ahuanerreʼ allohuen ñeñt̃ yaʼtserrp̃aʼyeneʼ.” ");
INSERT INTO ameNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Poʼpocheño allempo Jesúspaʼ entapuenanerr shonteʼ acheñeneshaʼ c̈ha emchorraʼhueñerr, ñañapaʼ atet̃ otan pueyochreshaʼ: —T̃eʼpaʼ oʼch ahuam̃p̃sey yom̃taʼn. ");
INSERT INTO ameNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Allñapaʼ huapoña puesheñarr ñeñt̃ atarr etsoteneʼ ñoñets ñeñt̃ atet̃ anaret̃. Ñañapaʼ atet̃ otos: —Na t̃eʼpaʼ Maestrochaʼ nemneñ oʼch noct̃areʼtyesep̃ amaʼt errohuanenchaʼ pechopeñeʼchyes. ");
INSERT INTO ameNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesúsñapaʼ atet̃ och: —T̃eʼpaʼ napaʼ peñotenchaʼ amaʼt nepacllapaʼ ama necheñe allchaʼ neyc̈henañ. Roʼquëp̃paʼ c̈hocma eñall paʼpon allecma yec̈hena. Ot̃ec̈hnopaʼc̈hoʼña c̈hocma eñall paʼmaʼ allecma yec̈haʼyenet. T̃arraña naña Ñeñt̃en Acheñetosetspaʼ ama eñalle ñeñt̃ eʼñe nepaquëll nepen allchaʼ nep̃anena. ");
INSERT INTO ameNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Poʼpocheño Jesúspaʼ atet̃ otenanerr poʼpsheñeñ pueyochreshaʼ: —T̃eʼpaʼ oʼch p̃oct̃aʼn att̃och eʼñe poʼñoc̈h neyochreshaʼ neperrep̃. T̃arraña ñeñt̃ña acheñerpaʼ atet̃ otan Jesús: —T̃eʼpaʼ arrchaʼña ñanom pemnaterren oʼch ahuerren apuesho oʼchña nepampaʼhueraʼ apañpaʼ allempochña nohuerrapaʼ oʼch noct̃ap̃. ");
INSERT INTO ameNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","T̃arraña Jesúspaʼ atet̃ otererr: —Acheñeneshaʼ ñeñt̃ ama yerpaʼpenaye Yompor, ñetñapaʼ pampannaʼtetepaʼ parro arromñat̃ecmuet. T̃arraña p̃ocoppaʼ ñeñt̃ep̃ oʼ peyerpuera Yompor añ poctetsa oʼch p̃oct̃aʼn att̃och poʼñoc̈h eʼñe neyochreshaʼ neperrep̃. ");
INSERT INTO ameNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Allempoña Jesúspaʼ aʼtapos noñt̃o pueyochreshaʼñapaʼ cot̃aʼhuanmet, ahuam̃p̃set rroc̈haʼsonet̃ atarr saʼpo. ");
INSERT INTO ameNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Allñapaʼ machayot̃epaʼtchaʼ huomenquëshatam̃pesnomuet. Emoʼyareʼña c̈ha eshaʼtena noñt̃o, att̃eña oññapaʼ chorramoch noñt̃o. Jesúsñapaʼ c̈ha muen. ");
INSERT INTO ameNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Att̃eña pueyochreshaʼñapaʼ ponem̃yet Jesús all muenpaʼ opueret atet̃ ochet: —¡P̃aʼqueshp̃atayeʼchey Ayochreshat̃e poʼñoc̈huachcaʼye yocllaʼhuerrat̃eʼ! ");
INSERT INTO ameNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ñañapaʼ atet̃ otanet: —Esoʼmareʼtña nanac seyoren. Sapaʼ ama eʼñeyeʼ seyemtenno. Jesúsña tanterrapaʼ eʼñe poʼñoñot̃a aʼmtsoññetuerran huomenquëshaʼ amaʼt ñam̃a emoʼyareʼpaʼ oʼ eʼñe aʼmtsoññetuer. Att̃oña ñetpaʼ oʼ alla eʼñe cohuen muechet̃tam̃perret. ");
INSERT INTO ameNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Att̃a cohuanrrorteñet ñetñapaʼ atet̃ otannaʼtyeset: —Taʼmcaʼye, añ acheñerpaʼ esonaʼtart̃eʼcaʼye. Atarrepaʼt es aʼmchechaten, amaʼt poʼñoñot̃apaʼ aʼmchechaterran huomenquëshaʼ amaʼt ñam̃a emoʼyareʼ oñ. ");
INSERT INTO ameNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Allempoñapaʼ oʼ etsotoset yom̃taʼn all sechenet. Allpaʼ añ paʼney peneʼ gadaroʼmarneshaʼ. Allñapaʼ huapoña ñam̃a epsheña acheñ t̃arraña ñetpaʼ añ chorrenahuet oneñet̃. Ñeñt̃paʼ arrot̃ huenet allecma pampaʼyeñet arromñat̃ec̈hno. Allenet̃ñapaʼ ama eseshayeʼ setso t̃arroʼmar ñeñt̃ chorraʼyena oneñet̃ ñetpaʼ atarr am̃chaʼnoc̈hetyenet allenet̃. ");
INSERT INTO ameNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Allempoñapaʼ rranareʼtapet Jesús, atet̃ ochet: —Esoʼmaruachcaʼye, Parets Puechemerechaʼ p̃aʼtsrreʼmoc̈htanaʼtosey. P̃apaʼ añecopt̃eʼ pehuena oʼch pecoñchaterrey amaʼt ama c̈henaʼ allempoch yaʼcoñchataret̃terra. ");
INSERT INTO ameNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ñehua, allpaʼ aʼyent̃eʼtsaʼyen shonteʼ chañchoc̈hno all rratseʼtyen. ");
INSERT INTO ameNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ñeñt̃oʼmarña oneñet̃ec̈hnopaʼ atet̃ otareʼtapet Jesús: —Ñerraʼm c̈hoch pequec̈hpatosey acheñpaʼ arrña pemñayeʼchosey chañchesho allochñapaʼ oʼch yechorraʼyererr ñam̃a chañchoc̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesúsñapaʼ allent̃a otanet: —Amaʼtcaʼyepaʼ orrascaʼye. Allempoña oneñet̃ec̈hnopaʼ quec̈hpaʼneret acheñpaʼ oʼ chorrereterr ñam̃a chañchoc̈hno. Chañchoña allempo chorrosya oneñet̃ec̈hnopaʼ c̈hepaʼtchaʼ matrraʼtua allohuen ñegonet̃, shorc̈haʼtuos allot̃paʼ eʼñe ñoʼshrraʼtuosa oño. ");
INSERT INTO ameNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Acheñeneshaʼña ñeñt̃ cohuam̃peneʼ chañcho, ñetñapaʼ allent̃a matrraʼtet ñamet poʼyorñot̃, ahuanmuet anetso. Allñapaʼ serrpareʼtyesoset ora atet̃ oʼ perra ñeñt̃ chorraʼyeseʼt̃ oneñet̃. ");
INSERT INTO ameNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Allent̃epaʼtchaʼ ahuanmaña allohuen anetsoʼmarneshaʼ ahuoʼch enteñetaʼ Jesús. Ñetña entoset Jesúspaʼ atet̃ otoset: —T̃eʼpaʼ oʼch ahuerrep̃ arrot̃, yenyot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Allot̃ña Jesúspaʼ aʼterr noñt̃opaʼ pechaterra, c̈herr anetso all aʼpuena. ");
INSERT INTO ameNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Allñapaʼ huapatam̃p̃soñet echarrtaña, puechecnapeʼna. Jesúsñapaʼ eñotapanet ñetpaʼ atarr nanac yemteñet. Allempoña ñapaʼ otapan echarrtaña: —C̈hochña neyochre p̃ocsherra t̃arroʼmar t̃eʼ ñeñt̃ p̃oʼchñarpaʼ ap̃retnaʼhuaret̃terra. ");
INSERT INTO ameNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Puesheñaʼtetsña ñeñt̃ etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ ñetñapaʼ att̃a otatseʼtyeset pueyoc̈hreto eʼñe ñagattseta, ñeñt̃paʼ atet̃ otet: “Añ acheñerpaʼ c̈ha achmenan Yompor.” ");
INSERT INTO ameNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesúsñapaʼ oʼ eñotanet ñeñt̃ atet̃ otyenet ñocop, ñañapaʼ atet̃ otanet: —Sapaʼ esoʼmareʼtchaʼña atet̃ soct̃apeʼchatseʼtyesña seyoc̈hro. ");
INSERT INTO ameNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Sapaʼ c̈hat̃eʼ soten ñeñt̃ atet̃ oʼ notue echarrtaña poʼchñar oʼ ap̃retnaʼhuaret̃ta ñeñt̃paʼ ama t̃orrapahuoyaye. Sapaʼ añña atarr t̃orrapoʼ senten att̃och naʼcrrater c̈honchaʼña oteʼ: “Petantena pechopeʼchnen.” ");
INSERT INTO ameNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ñehua, napaʼ oʼch neñotatas na Ñeñt̃en Acheñetosets, napaʼ ñeñt̃en aparet̃en llesens att̃och nach peretnerreʼ ochñarets añe patsro. Ñeñt̃oʼmarña Jesúspaʼ atet̃ oterranerr echarrtaña: —T̃eʼpaʼ oʼch petantena, pechtaʼnen pemueʼpaʼ pechopeʼchnen, ahuenep̃ pepacllo. ");
INSERT INTO ameNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Eʼñe otueʼ atet̃paʼ echarrtañañapaʼ c̈ha tantetsa allorocma, ahuerr paʼpacllo. ");
INSERT INTO ameNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Acheñeneshaʼña all ñeñt̃ enteneʼ ñetñapaʼ c̈ha yorenet, elloñapaʼ alla cohuentaterrñañet Yompor. Atet̃ otyenet: —Yomporcaʼyeña oʼ llesenserran ñeñt̃ amaʼt eʼñe acheña. ");
INSERT INTO ameNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesúsña meterrerr allot̃paʼ entnoman puesheñarr acheñ ñeñt̃ñapaʼ añ paʼsoʼcheñ Mateo. All anen allecma cobraʼyenan acheñeneshaʼ quelle ñeñt̃ gobiernocop. Jesúsñapaʼ atet̃ otosan Mateo: —T̃eʼpaʼ oʼch p̃oct̃aʼn att̃och neyochreshaʼ neperrep̃. Mateoñapaʼ c̈ha tantnomtsapaʼ allent̃a cot̃an Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Allempoña c̈hap ñam̃a allempoch rrallmeʼchen Jesús pocollo. Allñapaʼ huac̈haʼta poʼpotantañ shonteʼ ñeñt̃ poʼtaruas peneʼ oʼch cobraʼyeñet acheñeneshaʼ quelle ñeñt̃ gobiernocop. Ñeñt̃paʼ atarr ashcañneshaʼ entyeñ allohuen acheñeneshaʼ. Ñam̃a epuet poʼpotantañ ochñat̃eneshac̈hno ñetñapaʼ all anorrc̈haʼtyesoset all anen Jesús epuet pueyochreshac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Añña fariseoneshaʼ ñeñt̃ alloʼtsaʼyen ñetña allempo atet̃ eñchetpaʼ allent̃a otoñet pueyochreshaʼ: —Esoʼmareʼtña ñeñt̃ semaestror sepenpaʼ rrallmeʼchapretenanña añ acheñeneshar ñeñt̃ pueshquëñot̃eʼna cobraʼyeneʼ acheñeneshaʼ ñam̃a epuet acheñeneshaʼ ñeñt̃ atarr ochñat̃eneshac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Att̃o eʼmanet Jesús, ñañapaʼ atet̃ tomaʼntatanet: —Ñeñt̃ eʼñe huomech entetsapaʼ ñetpaʼ ama eʼneñetoña apartañ. Añña ñeñt̃ atsnaʼtetspaʼ ñetñapaʼ c̈hocma eʼnenet ñeñt̃chaʼ aʼcrraterrahuet. ");
INSERT INTO ameNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Napaʼ ama añecpayeʼ nohuapo att̃och nec̈horeʼtos ñeñt̃ eʼñe atet̃ entetsañ ñetpaʼ eʼñoʼ cohuen es p̃aʼyenet. Napaʼ añecopña nohuapa att̃och nec̈horeʼtos ñeñt̃ atarr ochñat̃ entyetsa. Allochñapaʼ att̃och oʼch cot̃apeʼcherret ello eʼñe cohuen Yomporecop. Socoppaʼ añ poctetsa ñerraʼm oʼch ahuerrespaʼ señotuerrepaʼchña ñeñt̃ atet̃ yec̈hateney añ Yompor poʼñoñ ñeñt̃ atet̃ anaret̃ ahuat̃ot̃eñ. Ñeñt̃paʼ atet̃ oteney Yompor: “Napaʼ ama eʼñe aña cohuen nenteno oʼch sapuenen sayara ñeñt̃ semtsen nocop. Añeʼnaña atarr cohuen nenten oʼch semuereña allohuen samoʼtseshaʼ.” ");
INSERT INTO ameNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Allempoñapaʼ ñeñt̃ pueyochreshaʼ pen Juan ñeñt̃ apatayeʼt̃ acheñeneshaʼ ñetña huac̈haʼtoñet Jesúspaʼ atet̃ otoset: —Yapaʼ t̃oreʼtetsay Yomporecop ñam̃a fariseoneshaʼpaʼc̈hoʼña t̃oreʼtetset. P̃añapaʼ ¿esoʼmareʼtña ama t̃oreʼtenoña peyochreshaʼ? ");
INSERT INTO ameNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesúsñapaʼ alla tomaʼntatanet, atet̃ otanet: —Ñeñt̃ ahuaʼñaret̃ec̈hno all rrallmeʼchapreteñet ñeñt̃ errteʼ senaʼtetsa, ama pocteyaye oʼch yotanet amach es serraʼyesatsto. Amach yellcatatstaneto t̃arroʼmar atet̃ coshapreteñet ñeñt̃ senaʼtetsa. T̃arraña ñerraʼm esempo machayot̃a saʼnerranet ñeñt̃ senaʼtetsa, ñeñt̃ña parro yemuetyena allempoña ñetpaʼ eʼñe puellquëñot̃et quec̈hpaʼhuerretchaʼ puerrar, amach arrenayeʼ enterreto. Ñeñt̃paʼ att̃ochña t̃oreʼterret allempo Yomporecop eʼñe poʼñoc̈h. Arrpaʼ allohua huañ ñeñt̃ atet̃ Jesús tomaʼntata ña senaʼtostsa. ");
INSERT INTO ameNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Elloñapaʼ alla tomaʼntaterraneterr ñeñt̃ atet̃ yec̈hen judioneshaʼ arr patsro, ñeñt̃oʼmarña atet̃ otanet: —Yapaʼ ñerraʼm mellashañ yeshtampaʼ amach yelltatsche emarr lletamtso. T̃arroʼmar amaʼt atet̃ yep̃atseʼchpaʼ ñeñt̃paʼ eʼñech orrena yellteñ t̃arroʼmar ñeñt̃ emarr lletamuetspaʼ ñerraʼm esempo yatsamaʼtam̃pespaʼ c̈hach chellamaʼta c̈hach martseʼtatanña shetamtsosheʼm. Ñeñt̃ña yelltenpaʼ alloʼnach sen rrarrtseʼtats nanac. ");
INSERT INTO ameNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jesúsñapaʼ alla tomaʼntaterraneterr poʼpoñ ñeñt̃ atet̃ yec̈hen judioneshaʼ oʼch yec̈hcatenet paʼrrom orrot̃. Ñeñt̃oʼmarña atet̃ otanet: —Amaʼt puesheñarrot̃eyapaʼ amach yeshatstoña vinos emasa mellashaʼm̃añ orrot̃o ñeñt̃ ayec̈hcataret̃ paʼrrom. T̃arroʼmar ñerraʼm atet̃ yepeʼpaʼ oʼch chasaʼña vinospaʼ c̈hach aʼptsan orrot̃, vinosñapaʼ eʼñech shebhua, ñeñt̃ña orrot̃paʼ amaʼt mameshapaʼ amach es sherberro. Añña ñerraʼm emasa vinos, arrchaʼña yesheʼ emerra orrot̃o ñeñt̃ ayec̈hcataret̃ paʼrrom. Allochñapaʼ amaʼtchaʼ chasaʼ vinospaʼ amach c̈ha potsaʼpsoña vinos, ñeñt̃paʼ allach yechen epoʼmar. Ñeñt̃paʼ att̃oña Jesúspaʼ eñotatanet ña poct̃ap̃ña eʼñe etserra. ");
INSERT INTO ameNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Allempo atet̃ eñorena Jesúspaʼ huapa ñam̃a puesheñarr ñeñt̃ am̃chaʼtaret̃tetsa judioneshacop, concorposñañapaʼ atet̃ otos: —Nesñeñpaʼ eʼñe errteʼ rromuets. T̃arraña amaʼt oʼ rromañpaʼ t̃eʼpaʼ oʼch p̃oct̃erren, amaʼt att̃apaʼ oʼch p̃aʼp̃lleñaʼ p̃otot̃ att̃och oʼch alla correrra. ");
INSERT INTO ameNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Eʼñe otueʼpaʼ allempoñapaʼ allent̃a cot̃aʼner Jesús epuet pueyochreshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Allñapaʼ cot̃aʼnmanet ñam̃a puesheñarr coyaneshaʼ ñeñt̃ atsnaʼtets. C̈harraʼ puechena epa char ñeñt̃ att̃o c̈hocma yellaʼyena. Ñañapaʼ allent̃a cot̃aʼnenan Jesús chentaʼ paʼcheʼñot̃, allñapaʼ aʼp̃llerrñañaʼ paʼshtam paʼrrpeʼmot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","T̃arroʼmar, ñapaʼ atet̃ oten pueyoc̈hro: “Amaʼt paʼshtama naʼp̃lloñpaʼ ñeñt̃ach naʼcrraterreʼ.” ");
INSERT INTO ameNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Allempo att̃o aʼp̃llaʼhuoñ paʼshtampaʼ Jesúsña allent̃a puetallerra paʼcheʼñonet̃paʼ entan coyaneshaʼ, ñeñt̃paʼ atet̃ och: —C̈hoña nesñeshachaʼ p̃ocsherra t̃arroʼmar att̃o atarr peyemtenna na, att̃oña t̃eʼpaʼ oʼ eʼñe naʼcrratnomuep̃. Coyaneshaʼñapaʼ allorocma correrra. ");
INSERT INTO ameNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesúsña allempo c̈hap am̃chaʼtaret̃ paʼpacllo allñapaʼ entosan ñeñt̃ pencllaʼtam̃pesyeneʼ arromñat̃ llequëñtsorec̈ho, entosan ñam̃a shonteʼ acheñeneshaʼ all puellquëñot̃et atarr anoʼtatseʼtyenet. ");
INSERT INTO ameNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesúsñapaʼ atet̃ otosan acheñeneshaʼ: —Sahuanerra arrot̃, añ shopsheshaʼpaʼ amacaʼye c̈hoyeʼ rromueno, c̈hacaʼye muen. Ñetñapaʼ pachm̃areʼteñot̃etpaʼ att̃a cheʼtatsetyesapet t̃arroʼmar ñetpaʼ eʼñecaʼye eñoteñet c̈hocaʼye rromuen. ");
INSERT INTO ameNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Allempoña c̈haʼnmac̈haʼtatuosan ñeñt̃ shontetsa all, ñañapaʼ beʼt̃osos oʼpono. Allempoña Jesúspaʼ rromotaʼtosan shopsheshañ potot̃ ñañapaʼ c̈hepaʼtchaʼ tanterrtsa. ");
INSERT INTO ameNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Allempoñapaʼ eʼmareʼtuet errap̃aren anetsoʼmar Jesúspaʼ oʼ tantaterran arromñat̃. ");
INSERT INTO ameNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ahuerrerr Jesús allot̃paʼ cot̃aʼnem̃ ñam̃a epsheña aporoʼyet̃. Rranareʼtneñet chentaʼ atet̃ otneñet: —Pemuerayeʼcherrya ñeñt̃ep̃ Davidnaʼtare. ");
INSERT INTO ameNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","C̈hap Jesús pocollopaʼ all beʼt̃osos allña rromueraʼña ñam̃a aporoʼyet̃. Jesúsñapaʼ aʼp̃t̃oʼtapanet: —¿Seyemtennat̃eʼ napaʼ ahuamencat̃en att̃ot̃chaʼ necuaterres? Ñetñapaʼ atet̃ otoset: —Yeyemtenp̃acaʼye, Ayochreshat̃e. ");
INSERT INTO ameNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Allempoñapaʼ allent̃a aʼp̃llaclleʼchanetpaʼ atet̃ otanet: —Att̃o atarr seyemtennapaʼ att̃etepaʼch socop. ");
INSERT INTO ameNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Allempocma eʼñe cohuen cohuerret. Jesúsñapaʼ atet̃ otanet: —Poʼñoc̈h t̃eʼpaʼ oʼch notas: Amach eseshaʼ sotap̃saʼtatsto, amaʼt eʼñe puesheñarra. ");
INSERT INTO ameNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Elloña ñetñapaʼ ahuanmuet aʼmet̃areʼtyeset Jesús. Errap̃aren allampañoʼmar eʼmareʼtuet Jesús atet̃ pena. ");
INSERT INTO ameNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Allempo ahuen epsheña aporoʼyet̃ allña Jesúseshopaʼ huapaterrñañeterr ñam̃a opan ñeñt̃ chorrena oneñet̃. ");
INSERT INTO ameNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesúsñapaʼ allent̃a quec̈hpatan oneñet̃ ñeñt̃ att̃o opanatateñ, opanñapaʼ allent̃a eñorerra. Acheñeneshaʼñapaʼ cohuanrrorteñetpaʼ atet̃ otyenet: —Israelneshaʼpaʼ amaʼt ahuat̃apaʼ ama puentarano ñeñt̃ atet̃ pena t̃eʼ Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseoneshaʼñapaʼ puesasareʼteñot̃etpaʼ atet̃ otyeset: —Oneñet̃t̃eʼ pompor ahuamencat̃ peneʼ att̃ot̃ quec̈hpatenan oneñet̃ec̈hno acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Allot̃ñapaʼ asuahuanom Jesús allohuen anetso amaʼt ñam̃a all ama tama eñalle acheñ. All yec̈hatyesosanet puerahuoʼmar. Serrpareʼtatosanet ñeñt̃ cohuen ñoñets att̃o ayochreshat̃tena Yompor. Aʼcrratyesosan ñeñt̃ osyen paʼnamen atsnañets ñam̃a ñeñt̃ paʼnamen atsotyenet. ");
INSERT INTO ameNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Allempo entosan shonteʼ acheñeneshaʼpaʼ ñañapaʼ nanac muerenanet. T̃arroʼmar eʼñe atet̃ entenanet ñerraʼmrrat̃eʼ carrnero ñeñt̃ ama acuam̃p̃saret̃eyaye; ñeñt̃oʼmarña nanac allpatataret̃tenet t̃arroʼmar ama eñalle ñeñt̃chaʼ ahuamencat̃ penahuet. ");
INSERT INTO ameNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ñeñt̃oʼmarña atet̃ otan pueyochreshaʼ: —Shonteʼ narmets ñeñt̃ nanac ellom̃reʼtets ñeñt̃chaʼ aʼyapac̈hetañ. T̃arraña ataruasañña ñeñt̃chaʼ aʼyapac̈heʼpaʼ ama atarr atonayayeto. ");
INSERT INTO ameNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","T̃eʼpaʼ añchaʼña sanamoñ pamoʼmteʼ mueñanepaʼña ñeñt̃chaʼ aʼyapac̈herrets paʼmro. Ñeñt̃paʼ atet̃ tomaʼntatanet Jesús att̃o atarr shonteʼ acheñeneshaʼ ñeñt̃chaʼ ameʼñerrtsañ t̃arraña ñeñt̃chaʼ ameʼñaterrahuetpaʼ ama atarr atonayayeto. Añchaʼña yanam Yompor ñeñt̃ Yamoʼmteʼ yepen mueñanepaʼña paʼtaruasañer ñeñt̃chaʼ t̃orraʼyerrtsa ñocop allemeñ anetsoʼmar. ");
INSERT INTO ameNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Allempo c̈hapaʼmuen allempo Jesús agotaʼmuenan pueyochreshaʼ c̈harrasheña ñeñt̃ puechetsa epsheña. Eʼñe apc̈haʼhuet ñeshopaʼ ñañapaʼ apanet llesens att̃och quec̈hpatyeset oneñet̃ec̈hno acheñeneshaʼ. Ñam̃a llesensanet att̃och aʼcrratyeset acheñeneshaʼ ñeñt̃ osyen allohuen paʼnamen atsnañtsoc̈hno ñam̃a ñeñt̃ paʼnamen atsotyenet. ");
INSERT INTO ameNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ñehua, ñetpaʼ arroʼtsaʼyenet paʼsoʼchñec̈hno; allohuenetpaʼ c̈harrasheñet puechena epsheña ñeñt̃ llesensaʼ. Ñeñt̃ ñanom atarr sherbets ñeñt̃paʼ Simón ñeñt̃ara sochetsa Pedro, allot̃paʼ ñam̃a Andrés ñeñt̃ eʼñe paʼmoʼnasheñ; allot̃ñapaʼ ñam̃a Jacobo ñeñt̃ Zebedeo puechemer epuet paʼmoʼnasheñ Juan. ");
INSERT INTO ameNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Allot̃ñapaʼ ñam̃a Felipe ñam̃a Bartolomé; allot̃ñapaʼ ñam̃a Tomás ñam̃a Mateo ñeñt̃ cobrayeʼt̃ acheñeneshaʼ quelle ñeñt̃ gobiernocop; allot̃ñapaʼ Jacobo ñeñt̃ Alfeo puechemer, allot̃paʼ ñam̃a Tadeo. ");
INSERT INTO ameNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Allot̃ñapaʼ ñam̃a Simón ñeñt̃ cananistaneshaʼ ñeñt̃ nanac t̃orratseʼt̃ paʼnetsrecop, allot̃paʼ ñam̃a Judas Iscariote ñeñt̃chaʼ pomuerreʼ tsapat̃onet̃ Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ñeñt̃ña c̈harrasheña puechena epsheña llesensanet att̃och ahuanemyeset paʼnamen anetsoʼmar, ñeñt̃paʼ atet̃ otapanet: —Amach arrent̃a setatsto all yec̈haʼyena ñeñt̃ ama judioneshayaye. Ñam̃a amach arrent̃a setatsto samarioʼmarneshaʼ paʼnetsro all yec̈haʼyenet. ");
INSERT INTO ameNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Arrchaʼña seta all yec̈haʼyena israelenaʼtarneshaʼ. Ñetpaʼ eʼñe atet̃ nentenanet ñerraʼmrrat̃eʼ carrneroc̈hno ñeñt̃ payaʼtyetsa. ");
INSERT INTO ameNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Allchaʼ soñemyespaʼ seserrpareʼtatyesnomanetchaʼ atet̃chaʼ sotyesnomanet: “T̃eʼpaʼ oʼ c̈herr allempoch ayochreshatt̃ena Yompor ñeñt̃ pueʼntañoʼtsen.” ");
INSERT INTO ameNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ñam̃a alla oterranerr pueyochreshaʼ: —Ñeñt̃ atsnaʼtyetspaʼ saʼcrratyesnomanetchaʼ, ñeñt̃ rromayetspaʼ setantatyesnom̃chaʼ, ñeñt̃ osyen puetsarñatspaʼ saʼcrratyesnom̃chaʼ att̃och eʼñe cohuen entuerranet acheñeneshaʼ, sequec̈hpatatyeschaʼ ñam̃a oneñet̃ec̈hno ñeñt̃ chorraʼyenaya acheñeneshaʼ. Sapaʼ eʼñe att̃a aparet̃es huomencñats att̃o es cohuen sorrtatyen Yomporecop, ñeñt̃oʼmarña sapaʼc̈hoʼña eʼñech att̃a sapaʼyesanet sam̃a, amach secobratstaneto ñeñt̃ atet̃ oʼ sep̃aʼyesanet. ");
INSERT INTO ameNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Ñam̃a oʼch notas: Ñerraʼm oʼch sahuanmapaʼ amaʼt puetallarrapaʼ amach seshaʼtatsetnomo quelle. Amaʼt orotllellen, amaʼt huallatllellen, amaʼt cobretllellen amach seshaʼtatsetnome. ");
INSERT INTO ameNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Amaʼt eʼñe coñeʼt̃a amach es sanmatsto allchaʼ sechopeñeʼchyes, amaʼt sebolsa, amaʼt eʼñe epma seshtam, amaʼt sesapata, amaʼt secarra, amach sanmatsche t̃arroʼmar ñeñt̃eschaʼ t̃orraʼyetsapaʼ eʼñe pocteʼ rratyesapasetchaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Amaʼt erraʼtsena anetser amaʼt ñam̃a all ama tama eñalle acheñ ñerraʼm erra sec̈hapaʼchpaʼ c̈hochña ñanom saʼp̃t̃oʼtyesosanet erroʼtsent̃eʼ cohuen acheñpaʼ allchaʼña sec̈hap. Allñapaʼ allchaʼña saʼposa t̃arrempohuach esempoch seserrerr ñam̃a allot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Amaʼt erraʼtsena pocoller allchaʼ sec̈hap, eʼñe sehuom̃chaʼteñot̃ oʼch senamatosanet Yompor paʼnateña. ");
INSERT INTO ameNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ñetña ñerraʼm eʼñe cohuen acheñret, Yomporñapaʼ aʼnatenanetchaʼ. Ñerraʼm ama cohuenayaye acheñretpaʼ Yomporñapaʼ oʼch alla apuerres sa paʼnateña. ");
INSERT INTO ameNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ñerraʼm erra anetsro ñeñt̃ alloʼmarneshaʼña ama cohuenayeʼ agapaseto t̃arroʼmar ñetpaʼ amach mueneto oʼch eʼm̃ñotapaset ñeñt̃ atet̃ seserrpareʼten, sañapaʼ oʼch sem̃terrerr ñam̃a allot̃. Ñerraʼm allempo sem̃terrerrña ñam̃a allot̃, ñeñt̃ña setcoʼtsaʼyen pañeʼteʼ patspaʼ c̈hoch sepaʼshetcaʼtyesnomña setac. Att̃ochña alloʼmarneshaʼpaʼ oʼch señotatnomanet ñetpaʼ amacaʼye pocteyeʼ entenanetoña Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Poʼñoc̈h t̃eʼpaʼ oʼch notas: Esempohuañen allempoch acraret̃etuerra allohuen acheñeneshaʼpaʼ añ anetsoʼmarneshaʼ ñeñt̃chaʼ ama cohuenayeʼ sagapaye t̃eʼ, ñetñapaʼ nanacchaʼ aʼcoñchataret̃terretña allempo. Amaʼt sodomoʼmarneshaʼ ñam̃a gomorroʼmarneshaʼ ñetpaʼ amach tama aʼcoñchataret̃terreto atet̃ ñerraʼm ñeñt̃ anetsoʼmarneshaʼ ñeñt̃chaʼ ama cohuenayeʼ sagapaye t̃eʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Ñam̃a sapaʼ ñerraʼm oʼch ahues t̃eʼpaʼ señochchaʼ poʼñoc̈h c̈hocmach eñall ñeñt̃chaʼ seʼmoñeʼteʼ amaʼt sapaʼ amach c̈ho errot̃ sepenaneto ñet. Ñeñt̃oʼmarña notenes t̃eʼpaʼ oʼch nemñas eʼñech att̃es ñerraʼmrrat̃eʼ carrnero oʼch ahuoʼ alloʼtsaʼyen maʼyarroc̈hno. Ñeñt̃oʼmarña sapaʼ señotaʼt̃ach atet̃ ñerraʼm shechep̃paʼ atarr eñoteʼ. T̃arraña sapaʼ amach errot̃ ap̃añso atet̃ ñerraʼm yep̃paʼ ama errot̃ ap̃añeyaye. ");
INSERT INTO ameNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ñeñt̃oʼmarña notenes: Señotaʼt̃ach t̃arroʼmar acheñeneshaʼpaʼ errot̃uanenchaʼ perrset, sanmaret̃terrach am̃chaʼtaret̃esho allchaʼ otteñeʼcherrset. Nalleʼtyerrsetchaʼ all judioneshaʼ poʼprahuoʼmar. ");
INSERT INTO ameNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Poʼñoc̈h eʼñe noʼmarpaʼ rremanaterrsetchaʼ att̃och mueroc̈htatyerrset, sanmaret̃terrach am̃chaʼtaret̃esho ñam̃a alloʼtsaʼyen ñeñt̃ nanac am̃chaʼtaret̃ec̈hno allchaʼña saʼmet̃aʼyesosnanchaʼ neñoñ. Ñam̃a arrchaʼ saʼmet̃errnan neñoñ alloʼtsaʼyen ñeñt̃ ama judioneshayaye. ");
INSERT INTO ameNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ñam̃a allempoch sanmaret̃etyesapaʼ amaʼt mameshapaʼ amach c̈ha sellcaʼp̃satsto, amach sotap̃saʼtatsto: Errot̃uachcaʼye notost̃eʼ am̃chaʼtaret̃esho ñerraʼm oʼch aʼp̃t̃oʼtareʼtapuen. T̃arroʼmar allempopaʼ Somporchaʼña Puecamquëñ señotatyesoseʼña all. ");
INSERT INTO ameNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Att̃oña amach eʼñe sochaya seʼñoraʼyesoso, añchaʼña Sompor Puecamquëñ ñeñt̃chaʼña seʼñoratyeseʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Allempoch atet̃ perrsetpaʼ ñeñt̃ eʼñe semoʼnasheñ sepen ñatoʼ ñeñt̃achcaʼye sepomuerreʼ att̃och muetsaterres t̃arroʼmar ñapaʼ amacaʼye ameʼñenno. Amapaʼ ñatoʼ pomporpaʼ oʼch pomuerran ñam̃a puechemer. Amaʼt ñam̃a puechemerpaʼ ñatoʼ pat̃parñot̃paʼ oʼpaterranach pamoʼmteʼ att̃och muetsatater. ");
INSERT INTO ameNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Shonteʼch acheñeneshaʼ ñeñt̃chaʼ seʼmoñeʼterreʼ t̃arroʼmar sapaʼ nacaʼye eʼñe sameʼñena. Amaʼtchaʼ atarr mueroc̈htaterrsetpaʼ t̃arraña eseshaʼch eʼñe ahuantaʼhuanmueʼ eʼñe pueyemteñot̃en na, ñeñt̃chaʼña aʼqueshp̃ataret̃terrtsa. ");
INSERT INTO ameNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ñerraʼm esempo eʼmoñeʼterrset ñeñt̃ anetsro alloʼtsenes oʼch seyetam̃p̃sanetpaʼ oʼch sahuanma poʼpoñ anetso. Allpaʼc̈hoʼña ñerraʼm att̃ecma eʼmoñeʼterrseterrpaʼ oʼch seyetam̃perraneterr oʼch sahuanerrerr ñam̃a poʼpoñ anetso. Eʼñe poʼñoc̈h notenes: Amach eʼñe sepaʼhuenaʼ ora allohuen israelneshaʼ paʼnetsropaʼ na Ñeñt̃en Acheñetosets oʼch alla norrterra. ");
INSERT INTO ameNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Ñam̃a oʼch noterrserr: Ñeñt̃ yochreshatspaʼ ñerraʼm eʼmoñeʼteññañet poʼmaestror, eʼñech att̃ecma eʼmoñeʼterrñañet ñam̃a ñeñt̃ pueyochreshac̈hno pen. Ñam̃a ñeñt̃ ñañretsotyets ñerraʼm eʼmoñeʼteññañet pamoʼmteʼ eʼñech att̃ecma eʼmoñeʼterrñañet ñam̃a pueñañreshac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ñeñt̃ yochreshatsoc̈hnopaʼ eʼñepaʼchña pocteʼ entyeñet oʼch atet̃ ap̃aret̃terret atet̃ ñerraʼm poʼmaestroret. Ñam̃a ñeñt̃ ñañretsoc̈hnopaʼ eʼñepaʼchña pocteʼ entyeñet ñam̃a oʼch atet̃ ap̃aret̃terret atet̃ ñerraʼm pamoʼmteʼ. Ñam̃a señochepaʼch ñerraʼm na puesochatseʼteñot̃etan otennet napaʼ oneñet̃oʼ pomporen ñeñt̃ otenet Beelzebú, sapaʼc̈hoʼña ellochña atarr sochatseʼterrset. Amaʼt na ñeñt̃en eʼñe samoʼmteʼ sepenen att̃o atarr sochatseʼtennet na, sapaʼc̈hoʼña ñeñt̃es nechemereshac̈hno nepen, elloña sapaʼ atarrchaʼ nanac sochatseʼterrset sam̃a. ");
INSERT INTO ameNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Amaʼt att̃eñpaʼ t̃arraña sapaʼ amach sem̃chaʼtatstaneto t̃arroʼmar yapaʼ yeñoteñ allohuen ñeñt̃ att̃o eʼñe aʼnahua shecareʼtyenet t̃eʼ, esempohuañenñapaʼ aʼmet̃am̃p̃saret̃terretchaʼ. Amaʼt allohuen ñeñt̃ eʼñe aʼnasotyenet t̃eʼpaʼ esempohuañenñapaʼ eʼñech eñotataret̃etuerret. ");
INSERT INTO ameNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ñeñt̃oʼmarña amaʼt erraʼtsena neserrpareʼtatyenes t̃eʼ eʼñe sapt̃ocheʼ, esempoña sapaʼ eʼñech señotatuer ora allohuen acheñeneshaʼ. Amaʼt erraʼtsen ñeñt̃ atet̃ neserrpareʼtatyenes t̃eʼ eʼñe aʼnahua oʼpono pocollo, esempoña sapaʼ seserrpareʼterrchaʼ allchaʼ eʼñe cohuen eʼmuerres allohuen acheñeneshaʼ atet̃ ñerraʼmrrat̃eʼ enot̃ seserrpareʼten shelletot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Amach aña sem̃chaʼtatsto ñeñt̃chaʼ semtseʼ. T̃arroʼmar añach muetsonaset sechets, secamquëññapaʼ amach errot̃enot̃ muetsonaseto. Añchaʼña sem̃chaʼnaʼt Yompor t̃arroʼmar ñerraʼm ña muenatspaʼ eʼñe ña poʼhuamencot̃paʼ oʼch aʼchencatonay yeʼchets yecamquëñpaʼc̈hoʼña oʼch aʼchencatonay coñchaʼpuetso all parraren tsoʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","31","’Elloña t̃eʼpaʼ napaʼ oʼch notas: C̈hocmach seyemcha Yompor, poʼñoc̈h ñapaʼ ñach secuam̃peneʼ. Amaʼt ot̃et̃olleshaʼpaʼc̈hoʼña c̈hocma cohuam̃peñ. Ñehua, amaʼt yapaʼ yeñoteñ ot̃et̃ollpaʼ ama tama sherbeno. Amaʼt yepomatset epa ot̃et̃olleshaʼpaʼ ñeñt̃paʼ ama tsaʼteyaye, eʼñe puetallarrat̃olla centavo tsaʼtena. T̃arraña amaʼt att̃eñpaʼ amaʼt pat̃rra ot̃et̃oll amach rromo att̃och shoraʼnom ñerraʼm ama Sompor muenataye atet̃. Ñeñt̃oʼmarña notenes: Amaʼt mameshapaʼ amach sem̃chaʼtatsto, Yomporchaʼña eʼñe seyemta. Att̃o atarr morrentenana ot̃et̃olleshaʼ elloña sapaʼ atarr nanac morrentensa. Ñehua, amaʼt allpon sechet̃olleshaʼ allpon soñoʼtsen ñapaʼ eʼñe eñotennas. ");
INSERT INTO ameNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Elloña napaʼ oʼch noterrserr: Allohuen amaʼt erraʼtsenchaʼ ñeñt̃chaʼ ama naʼnasotenaye acheñeneshesho, napaʼc̈hoʼña Ñeñt̃en Acheñetosetspaʼ amach naʼnasotuerraneto nam̃a Nomporesho all pueʼntaño. ");
INSERT INTO ameNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","T̃arraña ñerraʼm eseshaʼ naʼnasotenaya na arr patsro acheñeneshesho, napaʼc̈hoʼña naʼnasoterranetchaʼ Nomporesho all pueʼntaño. ");
INSERT INTO ameNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Sapaʼ c̈hat̃eʼ sotenapañ añecopt̃eʼ nohuapa oʼch eʼñe cohuen namoʼtstannaʼtatera acheñeneshaʼ arr patsro. Ñeñt̃paʼ ama att̃eyaye. Añecpaʼnaña nohuapa allochñapaʼ eʼñe noʼmarpaʼ acheñeneshaʼñapaʼ oʼch att̃a elloptannaʼtyeset. ");
INSERT INTO ameNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Ñehua, ñeñt̃ noten t̃eʼ amaʼt ñeñt̃ eʼñe pamoʼtsnaʼtarecmuet ñatoʼ noʼmarach eʼmoñeʼtannerret. T̃arroʼmar ñatoʼ eñallchaʼ ñeñt̃chaʼ nameʼñerraya, pamoʼtseshetñapaʼ ñatoʼ amach ameʼñerrneto. Ñeñt̃oʼmarña notenes eʼñe noʼmarpaʼ ñatoʼ puechemerpaʼ oʼch epatareʼtenan pompor, ñam̃a ñatoʼ puechoyorpaʼ oʼch epatareʼtenan pachor, ñam̃a ñatoʼ ñeñt̃ paʼt̃oʼñen pen oʼch epatareʼtenan ñam̃a paʼsoʼmue. ");
INSERT INTO ameNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’T̃arraña ñerraʼm erraʼtsenchaʼ nemorrenterrayañ ñerraʼm ñetña pompora atarr morrentenet ñamet pachoret ñeñt̃ña acheñerpaʼ ama eʼñeyeʼ pocteʼ nenteñe att̃och neyochreshaʼ neperranet. Ñam̃a poʼpotantañ ñeñt̃chaʼ nemorrenterrayañ ñetpaʼc̈hoʼña ñerraʼm puechemera atarr morrentenetpaʼ ñam̃a poʼsñet ñeñt̃paʼc̈hoʼña acheñerpaʼ ama eʼñeyeʼ pocteʼ nenteñe att̃och eʼñe neyochreshaʼ neperranet. ");
INSERT INTO ameNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","T̃arroʼmar ñerraʼm erraʼtsen ama eʼñeyeʼ sehuanmaye ñeñt̃ atet̃ muenenet eʼñe ñocpueta att̃och cot̃errnet eʼñe poctacma, nañapaʼ amach pocteʼ nenteñe oʼch neyochreshaʼ neperranet. Ñeñt̃paʼ añ tomaʼntena atet̃ ñerraʼmrrat̃eʼ c̈ho sechechnen secorsoch alloch semueroc̈hta sam̃a. ");
INSERT INTO ameNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","T̃arraña ñerraʼm eseshaʼ eʼñe aña eʼnenet oʼch correna atomat att̃och eʼñe coshenet arr patsro, ñetñapaʼ aʼchencaterretchaʼ ñañeñeta. T̃arraña ñerraʼm eseshaʼ eʼñe pocteʼ enteneʼ oʼch es sehuanmuet nocop ñeñt̃ atet̃ muenenet ñeñt̃ eʼñe ñocpueta arr patsro ñeñt̃ña acheñerpaʼ corretsach pocsheñeshocmañen eʼñe t̃ayot̃eñ errponañohuen. ");
INSERT INTO ameNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jesúspaʼ alla oterranerr pueyochreshaʼ: —Ñerraʼm oʼch sahuanma, ñerraʼm eseshaʼch eʼñe cohuen sagapueʼ sa, ñetpaʼ naʼnacaʼyeña aguënet eʼñe cohuen. Ñam̃a ñeñt̃ eʼñe cohuen naguëneʼ na, ñetpaʼ Nomporeʼnacaʼyeña aguënet ñeñt̃ nellsenseneʼ na. ");
INSERT INTO ameNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Amaʼt erraʼtsena ñeñt̃ eʼñe cohuen aguëneʼ ñeñt̃ aʼm̃teneʼ Yompor poʼñoñ t̃arroʼmar ñapaʼ Yomporcaʼye poʼñoñ aʼm̃ten, ñeñt̃ña acheñer ñeñt̃ eʼñe cohuen aguëneʼpaʼ Yomporchaʼña apuerreʼ ñeñt̃chaʼ atarr coshaterreʼ. Eʼñech att̃ecma apuer ñeñt̃ atet̃ coshatenan ñeñt̃ aʼm̃teneʼ poʼñoñ. Ñam̃a amaʼt erraʼtsena ñeñt̃ eʼñe cohuen aguëneʼ ñeñt̃ eʼñe pocteʼ es orrtatyets Yomporecop t̃arroʼmar ñapaʼ Yomporecopcaʼye eʼñe pocteʼ es orrtatyen, Yomporchaʼña apuerreʼ ñeñt̃chaʼ atarr coshaterreʼ. Eʼñech att̃ecma apuer ñeñt̃ atet̃ coshatenan ñeñt̃ eʼñe pocteʼ es orrtatyets Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ñam̃a añ ñeñt̃ ama esosheʼmayeʼ enteneto, erraʼtsenchaʼ apapueʼ ñeñt̃chaʼ orros t̃arroʼmar ñapaʼ nocaʼye neyochreshaʼ, amaʼt coñeʼt̃a oñ apapet, napaʼ poʼñoc̈h oʼch notas, Yomporchaʼcaʼyeña apuerrahuetña ñeñt̃chaʼ atarr coshaterrahuet. ");
INSERT INTO ameNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yec̈hatuahuan Jesús pueyochreshaʼ ñeñt̃ c̈harrasheña ñeñt̃ puechetsa epsheña atet̃chaʼ p̃aʼyeset, allempoñapaʼ ahuoʼ ñam̃a Jesús allot̃ yec̈hatyesets; serrpareʼtatyesan acheñeneshaʼ all paʼnetsreto. ");
INSERT INTO ameNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Añña Juanpaʼ alloʼtsena all yottam̃peñet. Allñapaʼ oʼ eʼmareʼtan Cristo atet̃ p̃aʼyena, allent̃a mueñan pueyochreshaʼ Jesúsesho. ");
INSERT INTO ameNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ñetña oʼ c̈hapuet allpaʼ atet̃ otoset: —Ñatoʼ p̃at̃eʼña ñeñt̃ep̃ eʼñe poʼñoc̈h Cristotets ñeñt̃ atarr yecuen ahuat̃ot̃eñ oʼch huapa. Ñerraʼm amat̃eʼ ñeñt̃eyaypepaʼ oʼch eʼñe p̃otey allochñapaʼ añchaʼ yecuaʼ poʼpsheñeñ ñeñt̃chaʼ huapatsa ñeñt̃ eʼñe Cristo. ");
INSERT INTO ameNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesúsñapaʼ anapanetpaʼ atet̃ otapanet: —T̃eʼpaʼ oʼch ahuerres seserrpareʼtatuerchaʼ Juan ora allpon ñeñt̃ atet̃ sentyesuennanaʼ arr ñam̃a ora allpon ñeñt̃ atet̃ seʼmyesuennanaʼ arr. ");
INSERT INTO ameNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Oʼch eʼñe seserrpareʼtatuer ora amaʼt att̃o aporoʼyet̃ec̈hnopaʼ t̃eʼñapaʼ oʼ eʼñe necuatyesuerranet ñam̃a ñeñt̃ checaʼrepayetspaʼ t̃eʼpaʼ oʼ eʼñe chopeʼchyesuerret cohuen, ñam̃a ñeñt̃ aʼptsaresyen leprapaʼ t̃eʼñapaʼ oʼ eʼñe aʼcohuentataret̃etuerret ñamet, ñam̃a ñeñt̃ paquetneshac̈hnopaʼ amaʼt ñetpaʼ t̃eʼñapaʼ oʼ eʼñe eʼmyesuerret cohuen, amaʼt ñam̃a ñeñt̃ rromayets t̃eʼñapaʼ oʼ alla atantataret̃etuerret, ñam̃a amaʼt ñeñt̃ huocchañneshac̈hno t̃eʼñapaʼ oʼ eʼñe neserrpareʼtatuerranet añ cohuen ñoñets alloch queshperret ñamet. ");
INSERT INTO ameNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Jesúsñapaʼ alla oterranerr Juan pueyochreshaʼ: —Ñam̃a ellonet̃paʼ oʼch sotuer Juan ñeñt̃ atet̃ notenes, atarr cosheñtsoʼtsen amaʼt allohuen ñeñt̃ atarr neyemtenaya na, ñeñt̃ ama eʼnenaye poʼpsheñeñ ñeñt̃chaʼ coshaterrahuet. ");
INSERT INTO ameNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Allempoña Juan pueyochreshaʼpaʼ oʼ ahuanerret. Jesúsñapaʼ alla serrpareʼtaterranerr acheñeneshaʼ ñeñt̃ atet̃ peʼt̃ ahuaña Juan, ñeñt̃paʼ atet̃ otanet: —Ahuaña allempo seteʼt̃ amayo all serrpareʼten Juan, sapaʼ amacaʼ añecpayeʼ seteʼt̃eña all oʼch sentenaʼ amuesmaʼ atet̃ aʼymaʼtateñ m̃orr. ");
INSERT INTO ameNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ñam̃a amacaʼ añecpayeʼ seteʼt̃eña all oʼch senteñaʼ ñeñt̃ atarr coc̈hneshaʼtetsa paʼshtam all, t̃arroʼmar yeñoteñ amayopaʼ amacaʼye eñalleña all ñeñt̃ atarr coc̈hneshaʼtetsa paʼshtam. Yapaʼ yeñoteñ arrña yentenña ñeñt̃ atarr coc̈hneshaʼ chorraʼyenaya shetamuets am̃chaʼtaret̃epahuo. ");
INSERT INTO ameNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Sapaʼ añecopcaʼyeña seteʼt̃ña amayo oʼch senteñaʼ all ñeñt̃ poʼñoc̈h aʼm̃teneʼ Yompor poʼñoñ. Napaʼ oʼch notas: Juanpaʼ att̃o atarr sherbenan Yomporpaʼ ello metanaʼtuan allohuen ñeñt̃ att̃o aʼm̃tenet Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","T̃arroʼmar Juanpaʼ ñocop eñoseʼt̃ Yompor ahuat̃. Ñehua, allempopaʼ atet̃ otneʼt̃ na ñeñt̃ atet̃chaʼ p̃osa Juan nocop esempoch huapa, ñeñt̃paʼ atet̃ anaret̃ ñoñets ahuat̃ot̃eñ: P̃apaʼ peñochepaʼch napaʼ oʼch nemñonap̃ puesheñarr ñeñt̃chaʼ ñanom otatsa ñeñt̃chaʼ p̃aʼcohuentatyeseʼ p̃ocop allchaʼ p̃oñmos. ");
INSERT INTO ameNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ñeñt̃oʼmarña na t̃eʼpaʼ eʼñe poʼñoc̈h atet̃ notenes: Allohuen allpon acheñeneshaʼ ñeñt̃ eñalletetsa arr patsro amaʼt puesheñarra ama eñalleña ñeñt̃ atarr sherbets atet̃ ñerraʼmrrat̃eʼ Juan ñeñt̃ apatyesayeʼt̃ ahuaña acheñeneshaʼ Yomporecop. T̃arraña ñeñt̃ ama esosheʼmayeʼ enteneto amaʼt mamesha, t̃arraña ñerraʼm pueyochreshaʼ peñ Yompor ñeñt̃ pueʼntañoʼtsen att̃o t̃eʼpaʼ ayochreshat̃tena ña, ñeñt̃ña acheñerpaʼ atarrcaʼye sherben, ello metanenan att̃o atarr sherben Juan. ");
INSERT INTO ameNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","’T̃arroʼmar añña ñoñets, Moisés poʼñoñ ñeñt̃ atet̃ anaret̃ ñam̃a añ ñoñets ñeñt̃ quellcaʼyeseʼt̃ ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ, ñetpaʼ ñeñt̃aña serrpareʼteteʼt̃ att̃och atarr ayochreshat̃terra Yompor t̃arrempohua allempo orrtosa Juan. Ñam̃a allempot̃eñ serrpareʼtatosanet Juan amaʼt t̃emeʼttsen eʼñe poʼhuamencocma serrpareʼtatyeset atet̃ penaña Yompor poʼcohuenña att̃och ayochreshat̃terra ña ñeñt̃ pueʼntañoʼtsen. Amaʼt atsrreʼmñat̃neshaʼpaʼ eʼñe ñeñt̃a atarr muenet pueyoc̈hrocmañen. ");
INSERT INTO ameNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ñam̃a ñerraʼm poʼnoc̈h sameʼñyañchaʼ Juanpaʼ ñacaʼyeña Elíasoterrets ñeñt̃ atarr secuen ñeñt̃chaʼ sehuerroya. ");
INSERT INTO ameNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Allohuenes ñeñt̃es neʼm̃ñoteneʼ neñoñ, c̈haponasepaʼchña seyoc̈hro ñeñt̃ atet̃ notenes. ");
INSERT INTO ameNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","19","Jesúsñapaʼ atet̃ oterranerr acheñeneshaʼ: —Ñehua, napaʼ oʼch neñotatas ñeñt̃ atet̃ pena patantarr acheñeneshaʼ ñeñt̃ yentyen t̃eʼ ñeñt̃ amaʼt errot̃ena ama acshatpoteneto. Ñeñt̃paʼ fariseoneshaʼ atet̃ petsa. T̃arroʼmar amaʼt allempo orrta Juan ñeñt̃ apatañtatseʼt̃ ñapaʼ ama rraneʼt̃e ñeñt̃ yocrram̃ yepen allohueney, ama orraneʼt̃e ñeñt̃ecma yorren allohueney. Ñeñt̃oʼmarña ñapaʼ c̈ha sotyeseʼt̃ c̈hoʼt̃eʼ chorreña oneñet̃; amaʼt eʼñe mameshapaʼ ama pocteyeʼ señcheʼt̃e. T̃eʼñapaʼ oʼ norrterra nam̃a Ñeñt̃en Acheñetosets. Napaʼ paʼnamen nerraʼyen ñam̃a norryen. Saña t̃eʼpaʼ att̃a sesochatseʼtyenen nam̃a atarroʼ arratsñat̃en ñam̃a atarroʼ orrarñat̃en napaʼ añoʼchña eʼñe neyemuetyena ñeñt̃ atarr ochñat̃eneshaʼ ñam̃a ashcarñat̃ec̈hno ñeñt̃ atarr cobraʼyeneʼ acheñeneshaʼ quelle. T̃arraña amaʼt atet̃ sepennoñpaʼ Nomporña eʼñe eñoteneʼ ñeñt̃ poʼñoc̈h atarr sherbets ñocop. Ñam̃a allohueney ñeñt̃ey eʼñe puechemereshaʼ p̃ohueney ñeñt̃ey cot̃eneʼ ña poct̃ap̃ña yapaʼc̈hoʼña eʼñe yeñotuenña ñeñt̃ poʼñoc̈h atarr sherbets. Ñeñt̃oʼmarña yorrtatyeññañ ñeñt̃ cohuen enten ña. Sañapaʼ amaʼt eʼñe mameshapaʼ ama acshatpahuoyayso, eʼñe att̃es ñerraʼmrrat̃eʼ cheshaneshaʼ ñeñt̃ c̈hocma poʼpoñ entannaʼtuenet amach mueno oʼch yemtana all yellsheñen poʼpotantañ pacmachoreshaʼ all plazo all shontena acheñeneshaʼ. Ñetñapaʼ amach mueneñeto oʼch coshaprechet pacmachoreshaʼ. Ñeñt̃oʼmarña ñetpaʼ att̃o yellsheñenetpaʼ atet̃ oteñet poʼpotantañ pacmachoreshaʼ: “Yapaʼ amaʼt oʼ yerequërcaʼhua allo yocshameʼtenapaʼ sañapaʼ amaña sesheʼraram̃penye; allot̃paʼ amaʼt oʼ yepoctorareʼtua ñeñt̃ yaʼchpeñtsorec̈h allo yellcanrrortenapaʼ sañapaʼ amaña sellcapretenyo.” ");
INSERT INTO ameNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Allempoña Jesúspaʼ c̈ha mueneʼ cheʼptareʼtyenan acheñeneshaʼ all paʼnetsreto all epayeʼ entatyenanet poʼpartsoña ahuañmoʼchot̃eñ. Amaʼt entatyenanetañ poʼpartsoña ñetñapaʼ ama es cot̃apeʼchenaye ello cohuen Yomporecop, ñeñt̃oʼmarña allpaʼ c̈ha mueneʼ cheʼptareʼtyesanet. Ñeñt̃paʼ atet̃ otyesanet: ");
INSERT INTO ameNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Nanacchaʼ llequëñtsoʼtsaʼyenes coraziñoʼmarneshachaʼ, nanacchaʼ llequëñtsoʼtsaʼyenes sam̃a betsaidoʼmarneshachaʼ. T̃arroʼmar amaʼt atarr norrtatyennaseñ nepartsoña sesho, sañapaʼ amaña soct̃apeʼcherroña ello cohuen Yomporecop. Ñerraʼm arrchaʼña norrtatañ nepartsoña tiroʼmarneshesho ñam̃a sidónoʼmarneshesho, ñetñapaʼ ahuat̃ot̃eñt̃eʼ cot̃apeʼcherretañ eʼñe cohuen Yomporecop. Ñetpaʼ att̃och eʼñe orrtetañ c̈ha llecatenanet poʼchñaret, cotnasheʼmach chorraʼyesetañ, tsapñach epachshemaʼtyenetañ all anorrc̈haʼtyenet puellquëñot̃et. ");
INSERT INTO ameNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ñeñt̃oʼmarña t̃eʼpaʼ notenes: Esempohuañen allempoch acraret̃etuerra allohuen acheñeneshaʼpaʼ tiroʼmarneshaʼ ñam̃a sidónoʼmarneshaʼ ñetñapaʼ amach tama aʼcoñchataret̃terretoña allempo. Coraziñoʼmarneshachaʼ ñam̃a betsaidoʼmarneshachaʼ saña allempopaʼ atarrchaʼ aʼcoñchataret̃es. ");
INSERT INTO ameNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ñam̃a sa capernaumoʼmarneshachaʼ c̈hat̃eʼ sotenapañ att̃o eʼñe cohuen sentyena sañeña, Yomporñapaʼ allent̃ach aʼtapaterres pueʼntaño. Ñeñt̃paʼ amachcaʼye att̃eyeʼ perrsoña Yompor, allachcaʼye huaporeʼterres oʼpono coñchaʼpuetso all parraren tsoʼ. T̃arroʼmar amaʼt atarr norrtatonaseñ nepartsoña sesho, sañapaʼ amaña semnoña oʼch soct̃apeʼcherr cohuen Yomporecop. Ñerraʼm arrchaʼ ñanom norrtatañ ahuat̃ot̃eñ nepartsoña sodomoʼmarneshesho ñetpaʼ allorocmat̃eʼ cot̃apeʼcherretañ cohuen Yomporecop. Allempopaʼ amat̃eʼ aʼpoyatataret̃terretañeña paʼnetser. Orat̃eʼ alloʼtsenaraña. ");
INSERT INTO ameNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ñeñt̃oʼmarña t̃eʼpaʼ notenes: Esempohuañen allempoch acraret̃etuerra allohuen acheñeneshaʼpaʼ sodomoʼmarneshaʼ ñetpaʼ amach tama aʼcoñchataret̃terretoña allempo. Capernaumoʼmarneshachaʼ saña allempopaʼ atarrchaʼ aʼcoñchataret̃es. ");
INSERT INTO ameNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Allempoña Jesúspaʼ maʼyochenana Pompor, ñeñt̃paʼ atet̃ oten: —Na Apachaʼ oʼch naʼyeʼchoc̈htatonap̃, p̃apaʼ p̃a ñeñt̃ep̃ atarr ayochreshat̃tetsa peʼntaño amaʼt ñam̃a arr patsro. Naʼyeʼchoc̈htatonap̃ t̃arroʼmar ora añec̈hno ñeñt̃ pecohuenña pepen, ñeñt̃paʼ ama arreyeʼ pec̈hapateñe pueyoc̈hro ñeñt̃ atarr eñotañ entyetsa. P̃apaʼ aña pec̈hapaten pueyoc̈hreto ñeñt̃ ama eñotañeyeʼ entyetso. ");
INSERT INTO ameNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","T̃arroʼmar Apa eʼñe pemuereñot̃ ñeñt̃paʼ atet̃ña eʼñe pocteʼ penten p̃a. Arrpaʼ allohua ñeñt̃ atet̃ maʼyochenana Pompor. ");
INSERT INTO ameNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jesúspaʼ alla oterranerr acheñeneshaʼ: —Nompor allohuen poʼcohuenña eʼñe eñotatuenen. Na ñeñt̃en Puechemerenpaʼ ama poʼñoc̈h eseshayeʼ neñotenaye, ñapt̃aña Nompor eʼñe eñotenen. Nomporpaʼc̈hoʼña ama poʼñoc̈h eseshayeʼ eñotenaye napt̃aña na ñeñt̃en Puechemeren eʼñe neñoteñ Nompor, ñam̃a erraʼtsenchaʼ ñeñt̃ eʼñe pocteʼ nenten na ñeñt̃en Puechemeren ñeñt̃ñapaʼ oʼch neñotater Nompor. ");
INSERT INTO ameNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","30","Sehuac̈haʼta nesho allohuenes ñeñt̃es neneʼ seyoc̈hro ñeñt̃ atarr amueroc̈htatañ sentyen. Eʼñe sameʼñeñot̃en na, napaʼ naʼhuañam̃perreschaʼ ñeñt̃ atarr amueroc̈htatañ sentyen. Napaʼ añchaʼña nenerrnas ñeñt̃ amach c̈ha mueroc̈htaterrso; ñeñt̃ña sapaʼ eʼñech pocteʼ senteñ. Att̃ochña sapaʼ señotenen napaʼ atarr nemuerensa ama atsrreʼmoc̈hen entñeno amaʼt eʼñe puesheñarrocpa. Amaʼt eʼñe mamesha ama añeyeʼ neʼneno ñeñt̃ eʼñe nocpa. Att̃ochña eʼñe cohuen nocshaterres seyoc̈hro amaʼt eʼñe secamquëñohuen. ");
INSERT INTO ameNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Allempoña c̈herrerr pamt̃arr allempo c̈hocma amesen judioneshaʼ. Allempoña Jesúspaʼ arr oñem chetsoʼmar epuet pueyochreshac̈hno. Allempo oñenet pueyochreshaʼñapaʼ eʼñe paʼchporrñot̃etpaʼ tasoʼtam̃pesyesnomuet puechm̃aʼtets trigo oʼ rraʼyesnomet. ");
INSERT INTO ameNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fariseoneshaʼña ñeñt̃ entahuet atet̃ p̃aʼnmuetpaʼ ñetñapaʼ allent̃a otyeset Jesús: —Pecueʼñacaʼyeña añ peyochreshaʼ tasoʼtam̃pesyesnomuet trigo; atet̃ penet ñeñt̃ ama pocteyaye oʼch atet̃ yep̃a taruasats añe yet̃ro t̃arroʼmar t̃eʼpaʼ añe yet̃ro ñeñt̃ atet̃ anaret̃ ahuat̃ot̃eñ allempocmach yamesen. ");
INSERT INTO ameNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesúsñapaʼ atet̃ otanet: —Sapaʼ amaʼtrra selleyareña ñeñt̃ atet̃ p̃a ahuat̃ David allempo cheporraʼnma epuet ñam̃a allohuen ñeñt̃ cot̃eneʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ña allempopaʼ beʼt̃osos Yompor paʼpacllo allñapaʼ rrosan pan ñeñt̃ atmaʼntataret̃ atet̃ ñerraʼmrrat̃eʼ ñeñt̃ nenet all Partsocop. Ñehua, ñeñt̃ panpaʼ ama pocteyayñe oʼch rros David ñam̃a ñeñt̃ epuet. Ñeñt̃paʼ añach ñapuet̃ rreneʼ cornaneshac̈hno; ñeñt̃paʼ atet̃ anuaret̃ judioneshacop. ");
INSERT INTO ameNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ñam̃a amaʼt selleyareña ñoñets ñeñt̃ atet̃ anaret̃ ñeñt̃ Moisés poʼñoñ all oten atet̃ pena ñam̃a cornaneshaʼ Parets paʼpacllo. Ñehua, ñet puesherbeñot̃etpaʼ ama ameseneto añe yet̃ro allempocma yamesen. Ñetpaʼ amaʼt atet̃ penetpaʼ Yomporñapaʼ eʼñe pocteʼ entenanet. ");
INSERT INTO ameNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Napaʼ oʼch notas: Napaʼ ñeñt̃en arroʼtsenen nanac nesherben ello nem̃taneñ ñeñt̃ atet̃ sherben Parets paʼpaquëll. ");
INSERT INTO ameNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ñehua, añ ñoñetspaʼ ñeñt̃ña atet̃ oteʼt̃ Yompor ahuat̃: “Napaʼ ama eʼñe aña cohuen nenteno oʼch sapuenen sayara ñeñt̃ semtsen nocop. Añeʼnaña atarr cohuen nenten oʼch semuereña allohuen samoʼtseshaʼ.” Ñerraʼm c̈ho c̈hennasañ seyoc̈hro ñeñt̃ atet̃ oteney Yompor, amach errot̃ sotatscheña amaʼt erraʼtsena acheñer ñeñt̃ eʼñe pocteʼ enten Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ñeñt̃oʼmarña t̃eʼpaʼ oʼch notas, na Ñeñt̃en Acheñetosets ñeñt̃en allsensaret̃en, nacaʼyeña atet̃ otets est̃eʼ poctetsaña ñeñt̃chaʼ atet̃ yep̃a añe yet̃ro allempocma yamesen. ");
INSERT INTO ameNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Metuerrerr Jesús allot̃paʼ beʼt̃osuerrerr judioneshaʼ poʼprahuo. ");
INSERT INTO ameNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Allñapaʼ alloʼtsen puesheñarr yacma ñeñt̃ c̈ha chellena pot. Fariseoneshaʼñapaʼ allent̃a aʼp̃t̃oʼchet: —Añe yet̃ro allempocma yamesenpaʼ taʼm ¿pocteʼt̃eʼ penteñ oʼch p̃aʼcrrateñerr acheñ? T̃arroʼmar atet̃ aʼp̃t̃oʼteñet allochñapaʼ eshecchaʼ otteñeʼchet. ");
INSERT INTO ameNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ñañapaʼ atet̃ otanet: —Sapaʼ ñerraʼm c̈ho shoraʼnen amaʼt puemocarra secarrneror añe yet̃ro allempocma yamesen, amaʼtchaʼña allent̃a sechtere amaʼt ñeñt̃e yet̃ro allempo yamesen allohueney. ");
INSERT INTO ameNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ñehua, acheñpaʼ ellocaʼye metanenanña ñeñt̃ att̃o sherben carrnero. Ñeñt̃oʼmarña napaʼ notenes eʼñe pocteʼ oʼch atet̃ yep̃a ñeñt̃ cohuentetsa amaʼt añe yet̃ro allempocma yamesen. ");
INSERT INTO ameNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Allempoña Jesúspaʼ atet̃ otan yacma ñeñt̃ chelletsa pot: —T̃eʼpaʼ oʼch notap̃ petapuerr p̃ot. Eʼñe otueʼpaʼ ñañapaʼ allent̃epaʼtchaʼ tapuerran pot, eʼñe allorocma cohuenterra pot eʼñe att̃ecmaterr ñerraʼm poʼpshem̃tañot̃ pot. ");
INSERT INTO ameNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Fariseoneshaʼña c̈haʼnmac̈herretpaʼ cot̃apeʼchatannaʼtyesnerret, atarr oʼpateñet Jesús att̃och muetsatachet. ");
INSERT INTO ameNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesúsña eñotanetpaʼ ahuerr allot̃. Shonteʼ acheñeneshac̈hno cot̃aʼhuanereterr. Allohuen ñeñt̃ atsnaʼtyetspaʼ eʼñe aʼcrratyesuerranet. ");
INSERT INTO ameNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Atet̃ otyesanet: —Poʼñoc̈h amach eseshaʼ sotap̃saʼtatsto napaʼ na ñeñt̃en Yompor Puechemeren. ");
INSERT INTO ameNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ñehua, ñeñt̃paʼ atet̃ p̃a allochñapaʼ att̃och etsota Isaías poʼñoñ ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ, ñeñt̃paʼ atet̃ oteʼt̃ Yompor Puechemerecop ñeñt̃chaʼ Cristoterrets: ");
INSERT INTO ameNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Añmapaʼ ñeñt̃chaʼ atarr t̃orrerrtsa nocop, ñapaʼ ñeñt̃ nenen ñeñt̃chaʼ atarr sherberrets. Ñapaʼ ñeñt̃ atarr nemorrentena ñeñt̃ eʼñe nocshateneʼ. Ñapaʼ ñach ahuamencat̃ neperr necamquëñot̃, ñach eñotaterreʼ allohuen paʼnamen acheñeneshaʼ amaʼt ñeñt̃ ama judioneshayaye. Añchaʼ eñotaterranet ñeñt̃ eʼñe cohuen ñoñets att̃ochña eʼñe pocteʼ nentuerranet. ");
INSERT INTO ameNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ñapaʼ amach es otnareʼtyerraneto amaʼt mameshapaʼ amach amaʼtoc̈hetyerro. Amaʼt mameshapaʼ amach cheʼc̈hameʼtyerraneto amaʼt allecma chopeñeʼchyen acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Amaʼt ñeñt̃ mueroc̈hetyetsapaʼ ñapaʼ eʼñech muererranet. Ñeñt̃paʼ atet̃chaʼ netmaʼntacha ñerraʼmrrat̃eʼ amaʼt puecharra choʼneʼch tsopaʼneʼpaʼ ñañapaʼ amach c̈ha aʼmeyatere. Ñam̃a ñerraʼm lampareñ c̈ha mueneʼ mayen ñeñt̃paʼc̈hoʼña amach emayatere. Ñapaʼ amach c̈ha es am̃chaʼnoc̈htanaʼtyerro, t̃arraña esempohuañenpaʼ eʼñech att̃a aʼmchechatuerran ora allohuen ñeñt̃ ama pocteyeʼ enteno Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ñeñt̃oʼmarña allohuen paʼnamen acheñeneshac̈hno ñachña eʼñe yemuetuerret. Arrpaʼ allohua huañ atet̃ oteʼt̃ Yompor ñeñt̃ quellquëʼt̃ Isaías. ");
INSERT INTO ameNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jesúspaʼ alla huapaterrñañeterr puesheñarr yacma ñeñt̃ aporoʼyet̃ ñeñt̃ chorrena oneñet̃ c̈ha opanatateñ. Jesúsñapaʼ aʼcrratap̃, ñeñt̃ña opanerpaʼ oʼ alla eñorerra, ñam̃a oʼ eʼñe cohuen cohuerr. ");
INSERT INTO ameNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Allohuenña acheñeneshaʼpaʼ atarr cohuanrrorteñet, ñetñapaʼ atet̃ otyeset: —Ñatoʼ añt̃eʼcaʼyeña David poʼm̃reneñ ñeñt̃chaʼ Cristotosets. ");
INSERT INTO ameNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Fariseoneshaʼña allempo eʼmareʼchetpaʼ ñetñapaʼ atet̃ otyeset: —Att̃o quec̈hpatatyenan oneñet̃ec̈hno acheñeneshaʼ añacaʼye ahuamencat̃ peneʼ Beelzebú ñeñt̃ pompor pen allohuen oneñet̃ec̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesúsñapaʼ eñotanet ñeñt̃ atet̃ cot̃apeʼchatseʼtyenet pueyoc̈hreto ñocop ñeñt̃ att̃o otyeñet ñapaʼ oneñet̃a pompor poʼhuamencot̃ quec̈hpatatenan oneñet̃ec̈hno acheñeneshaʼ. Ñeñt̃oʼmarña ñapaʼ atet̃ otanet: —Ñerraʼm puesheñarr am̃chaʼtaret̃ elloptannena paʼcheñer eʼñe ñagattsetpaʼ eʼñech poctacma aʼcllatannaʼtuerret. Att̃ecmach p̃annerra ñeñt̃ parro yec̈hetsa pat̃err anetso, ñerraʼm c̈ho elloptannenet eʼñe ñagattsetpaʼ ñeñt̃ña att̃o huomencatenetpaʼ ñeñt̃paʼc̈hoʼña c̈hachcaʼye huañerrets. Att̃ecmach p̃annerra amaʼt ñeñt̃ eʼñe pamoʼtsnaʼtarecmuet ñerraʼm elloptannerret eʼñe ñagattsetpaʼ ñeñt̃ña att̃o huomencatenetpaʼ ñeñt̃paʼc̈hoʼña c̈hachcaʼye huañerrets. ");
INSERT INTO ameNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Att̃ecmach p̃annaʼta ñam̃a oneñet̃ pueyochreshac̈hno ñerraʼm oneñet̃ec̈hno eʼmoñeʼtannenet, ñerraʼm huaporeʼtannenet eʼñe ñagattseta amach errot̃enot̃ alloʼna atarr huomencatneneto. Poʼñoc̈h oneñet̃paʼ amacaʼye huaporeʼtanneno. ");
INSERT INTO ameNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Sapaʼ atet̃ sotenen napaʼ Beelzeboʼ poʼhuamencot̃ nequec̈hpateññañ eʼñe ña pueyochreshaʼ, ñehua, t̃eʼpaʼ oʼch notas: Ñeñt̃ seyochreshaʼ sepen sa ñeñt̃ eñoteneʼ ñamet oʼch quec̈hpatachet oneñet̃ec̈hno acheñeneshaʼ, ñetpaʼc̈hoʼña amaña Beelzebú poʼhuamencot̃eyeʼ quec̈hpateñetoña oneñet̃ec̈hno acheñeneshaʼ. Ñetpaʼc̈hoʼña Yomporoña poʼhuamencot̃ quec̈hpateñetña oneñet̃. Ñeñt̃ña oʼ eñotatas ñeñt̃ atet̃ sotennoñ ñeñt̃paʼ amacaʼye poʼñoc̈h att̃eyaye. ");
INSERT INTO ameNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Poʼñoc̈hcaʼye Yompor eʼñe Puecamquëñot̃ ñeñt̃ña ahuamencat̃ nepeneʼ att̃ot̃ nequec̈hpateñña oneñet̃ec̈hno acheñeneshaʼ, ñeñt̃chaʼña señotateʼ t̃eʼpaʼ oʼ nec̈hapatonas Yompor poʼcohuenña ñeñt̃ att̃o poʼñoc̈h atarr ayochreshat̃tena ña. ");
INSERT INTO ameNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Ñehua, yapaʼ yeñoteñ ñeñt̃ atarr ahuamencat̃tetsa att̃o atarr ahuamencat̃tena oneñet̃, ñañapaʼ eʼñe poʼhuamencot̃ cohuam̃pesyenan allohuen eʼñe cohuen ñeñt̃ paʼpaquëll p̃aʼyen. T̃arraña ñerraʼm esempo oʼch huapoña ñeñt̃ atarr ahuamencat̃eshaʼ ñeñt̃chaʼ metanoseʼña poʼhuamenc atet̃ ñerraʼm na Nompor, ñeñt̃chaʼña rromoseʼ oʼch huancos, allochñapaʼ oʼch beʼt̃osos all ñeñt̃ paʼpaquëll p̃aʼyen oʼch eʼñe puerratam̃p̃sos ñeñt̃ allpon oʼpatyena ña. ");
INSERT INTO ameNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Ñeñt̃oʼmarña t̃eʼpaʼ oʼch notas allohuenes: Ñerraʼm eseshas ñeñt̃es ama net̃orrapretenaye ñeñt̃ña acheñerpaʼ c̈hacaʼye epatareʼtennan ñeñt̃ atet̃ net̃orraʼyena na. Ñeñt̃paʼ oʼch netmaʼntatasa atet̃: Ñerraʼm eseshaʼ ama naʼyapac̈hapretenaye ñeñt̃ naʼyapac̈hen na, ñeñt̃ñapaʼ c̈ha aʼparratseʼtam̃penen aʼyenet̃. ");
INSERT INTO ameNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Ñeñt̃oʼmarña t̃eʼpaʼ oʼch notas: Allohuen paʼnamen sosyaʼtsañec̈hno ñeñt̃ ama pocteyeʼ enteno Yompor amaʼt ñam̃a achm̃areʼtannaʼteñets ñeñt̃paʼ ap̃retnaʼpoʼ nenteñ. ");
INSERT INTO ameNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ñam̃a ñerraʼm eseshaʼ nesaseneʼ na Ñeñt̃en Acheñetosets ñeñt̃paʼ ap̃retnaʼpoʼ nenteñ. T̃arraña ñerraʼm eseshaʼ añ achm̃areʼteññañet Parets Puecamquëñ ñeñt̃ñapaʼ amacaʼye ap̃retnaʼpahuoyeʼ nenteñe. Ñeñt̃paʼ amach ap̃retnaʼpahuoterro eʼñe t̃ayot̃eñ errponohuañen. ");
INSERT INTO ameNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Ñehua, yeñoteñ allohuen acheñ ñeñt̃ eʼñe poʼñoc̈h cohuen acheñer, ñetchaʼña orrtatenet ñeñt̃ eʼñe cohuenareʼ. T̃arraña poʼpotantañ acheñeneshaʼ ñeñt̃ poʼñoc̈h ama cohuenayaye ñetñapaʼ añach orrtatenet ñeñt̃ ama cohuenayaye. Ñeñt̃paʼ atet̃chaʼ netmaʼntaterrsa: Ora allohuen ñeñt̃ eʼñe cohuen narmetsoch pueʼmerpaʼc̈hoʼña eʼñech cohuenareʼ. Añña poʼpchañ narmetsoch ñeñt̃ ama cohuenayayepaʼ pueʼmerpaʼc̈hoʼña amach eʼñe cohuenayaye. Ñeñt̃oʼmarña att̃oña yeñoteñ erraʼtsent̃eʼ ñeñt̃ eʼñe cohuenareʼ narmetsoch ñam̃a ñeñt̃ ama cohuenayaye narmetsoch, pueʼmerot̃ña eʼñe yechmeʼtenanet. ");
INSERT INTO ameNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","35","Sapaʼ ama cohuenayayso. C̈ha sottena ñerraʼm shechp̃a eʼñe sompor sepen allohuenes. Ñeñt̃oʼmarña amach errot̃enot̃ señoso cohuen t̃arroʼmar sapaʼ poʼñoc̈hpaʼ ama cohuenayayso. Eʼñe atet̃ atarr soct̃apeʼchatseʼtyen seyoc̈hro ñeñt̃ ama cohuenayaye, att̃ot̃caʼyeña señosatseʼtyen. Amaʼt erraʼtsena acheñer ñeñt̃ eʼñe poʼñoc̈h cohuen ñapaʼ añchaʼña orrtatyen ñeñt̃ eʼñe cohuenareʼ cot̃apeʼchen pueyoc̈hro t̃arroʼmar pueyoc̈hroña all cot̃apeʼchenan shonteʼ ñeñt̃ eʼñe cohuentetsa. T̃arraña poʼpoñ acheñer ñeñt̃ poʼñoc̈h ama cohuenayaye, ñapaʼc̈hoʼña añach orrtatyen ñeñt̃ atet̃ cot̃apeʼchen pueyoc̈hro ñeñt̃ ama cohuenayaye t̃arroʼmar pueyoc̈hroña all cot̃apeʼchenan shonteʼ paʼnamen sosyaʼtsañ. T̃arroʼmar ñerraʼm shonteʼ yoct̃apeʼchen yeyoc̈hro ñeñt̃ cohuentetsa, ñeñt̃paʼ eʼñech ñeñt̃a cohuen yeserrpareʼten. T̃arraña ñerraʼm shonteʼ yoct̃apeʼchen ñam̃a yeyoc̈hro ñeñt̃ ama cohuenayayepaʼ ñeñt̃paʼc̈hoʼña eʼñech ñeñt̃a yemnen oʼch yeserrpareʼtyen. ");
INSERT INTO ameNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Poʼñoc̈h napaʼ oʼch alla noterrserr, esempohuañen allempoch acraret̃etuerra allohuen acheñeneshaʼpaʼ allohuen ñoñets ñeñt̃ att̃a otatseʼtyen acheñeneshaʼ ñeñt̃ñapaʼ aʼmet̃atatyeretchaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","T̃arroʼmar ñerraʼm eʼñe cohuenareʼ seserrpareʼtyen t̃eʼ Yomporñapaʼ eʼñech pocteʼ entuerrnas señoñ allempo. T̃arraña t̃eʼpaʼ ñerraʼm c̈ha señosatseʼtyen ñeñt̃ña señoñerpaʼ ñeñt̃achña secoñchaterreʼ allempo. ");
INSERT INTO ameNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Allempoña allponsheña ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ epuet ñam̃a allpon fariseoneshaʼ ñetña eʼñe pueshquëñot̃etpaʼ atet̃ ochet Jesús: —Yapaʼ Maestrochaʼ yemneñ oʼch p̃orrtatonay pepartsoña ñeñt̃chaʼ yeñotateʼ p̃apaʼ poʼñoc̈ht̃eʼ Parets Puechemerep̃ ñeñt̃ep̃t̃eʼ Cristotosets. ");
INSERT INTO ameNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ñañapaʼ atet̃ otanet: —Acheñeneshaʼ ñeñt̃ corraʼyetsa t̃eʼ ñetñapaʼ ama cohuenayeʼ cot̃apeʼchyeneto, ama añeyeʼ cosheneto Yompor ñeñt̃oʼmarña ñetpaʼ eʼñe orrena otennet ahuoʼch norrtatanet nepartsoña. T̃arraña amach es norrtataneto. Napaʼ añach pat̃err neñotatanet atet̃ eñotataneʼt̃ Jonás ahuat̃ nínivoʼmarneshaʼ allempo aʼm̃taneʼt̃ Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ñehua, yeñoteñ Jonás allempopaʼ alloʼtsena cacacotmo maʼpamuet, yet̃o amaʼt ñam̃a tsapo ñeñt̃ añecmuen cac. Atet̃chaʼ neperra nam̃a Ñeñt̃en Acheñetosets, napaʼc̈hoʼña nemaʼpamuetchaʼ oʼpono eʼñe allohuanen patso, yet̃o amaʼt ñam̃a tsapo. Ñeñt̃chaʼña eñotaterrahuet atet̃ penaña ñeñt̃ huetsa Yomporeshot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","T̃arroʼmar ahuat̃ allempo serrpareʼtataneʼt̃ Jonás nínivoʼmarneshaʼ, ñetñapaʼ allempocma cot̃apeʼcherret eʼñe cohuen Yomporecop. T̃eʼña arr seshopaʼ alloʼtsenen na ñeñt̃en ello metaneneʼ ñeñt̃ atet̃ serrpareʼtateʼt̃ Jonás. T̃arraña sañapaʼ amaña soct̃apeʼchenoña ello cohuen Yomporecop. Ñeñt̃oʼmarña esempohuañen allempoch acraret̃etuerra allohuen acheñeneshaʼ ñeñt̃ña nínivoʼmarneshaʼ ñeñt̃ eʼñe cohuen cot̃apeʼcherrets Yomporecop ahuat̃, ñetpaʼc̈hoʼña orrterretchaʼ, ñeñt̃chaʼña señotaterreʼña sapaʼ amaʼt mameshapaʼ ama pocteyayeña ñeñt̃ atet̃ sep̃aʼyeseʼt̃ t̃arroʼmar ama soct̃apeʼcherro ello cohuen Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ñam̃a t̃eʼpaʼ oʼch neyerpatasa ñeñt̃ atet̃ p̃a ahuat̃ puesheñarr coyaneshaʼ ñeñt̃ am̃chaʼtaret̃tatseʼt̃ atarr b̃ac̈hayo allohuanen pats saʼponet̃. Ñeñt̃ña coyaneshaʼpaʼ allot̃eñ on oʼch eʼm̃ñotenanaʼ Salomón pueserrpareñ ñeñt̃ atet̃ atarr eñotañteʼt̃. T̃eʼña arr eʼñe seshopaʼ alloʼtsenen ñeñt̃en puesheñarrana ñeñt̃en atarr es neñoten nam̃a, ello nem̃taneñ att̃o eñotañteʼt̃ Salomón. T̃arraña sañapaʼ amaña es sotapoteno. Ñeñt̃oʼmar esempohuañen allempoch acraret̃etuerra allohuen acheñeneshaʼ, ñeñt̃ña coyaneshaʼ ñeñt̃ eʼñe cohuen eʼm̃ñotatseʼt̃ ñapaʼc̈hoʼña orrterrach, ñeñt̃chaʼña señotaterreʼ sapaʼ ama pocteyayeña ñeñt̃ atet̃ sep̃aʼyeseʼt̃ t̃arroʼmar sapaʼ ama es sameʼñeʼt̃e amaʼt eʼñe mamesha. ");
INSERT INTO ameNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","45","’Ellonet̃paʼ oʼch alla neñotaterrserr poʼpoñonet̃ ñeñt̃chaʼ atet̃ ap̃aret̃terra acheñeneshaʼ ñeñt̃ t̃eʼpaʼ ama eʼñeyeʼ cohuen cot̃apeʼcheneto Yomporecop. Ñehua, oneñet̃ ñerraʼm esempo c̈haʼnom acheñenesheshot̃, ñeñt̃ña oneñet̃paʼ oʼch auyes errap̃aren amaʼt amayoʼmar eʼnyeseʼ poʼpsheñeñ allchaʼ yec̈herrerr allchaʼ eʼñe amesuerrerr cohuen. T̃arraña ñerraʼm amach erra eñchepaʼ att̃eñapaʼ oʼch ot: “Napaʼ oʼch alla ahuerren nepacllo allot̃ nec̈haʼnom ahuaña.” Atet̃chaʼc̈hoʼ p̃a. Oʼch alla ahuerr allot̃ c̈haʼnom ahuaña. Allña oʼch c̈herrpaʼ eʼñech cohuen entuerran paʼpaquëll, eʼñech cohuen atarrapoʼtuaret̃, eʼñech cohuen aññoʼtyesaret̃, t̃arraña amach eseshayeʼ yec̈hetso all. Allempoñapaʼ oʼch alla ahuerr alloʼtsaʼyen pamoʼtseshaʼpaʼ oʼch enanaʼ poʼpoñ canc̈herrsheña oneñet̃ec̈hno ñeñt̃ nanac sosyareʼ, ñeñt̃ ello metanaʼtueneʼ ñeñt̃ atet̃ sosyaten ñeñt̃ huaʼñeneʼ oʼch yec̈haprecha. Allohuenetpaʼ oʼch chorreñet ñeñt̃ acheñer. Allempoña tsapat̃onet̃paʼ alloʼnach sen ñeñt̃ acheñer sosyatnomuets huomenc. Elloch metanerran ñeñt̃ atet̃ p̃atseʼtyeseʼt̃ ñenmat̃. Poʼñoc̈hchaʼcaʼye atet̃ perraña acheñeneshaʼ ñeñt̃ t̃eʼpaʼ ama eʼñeyeʼ cohuen cot̃apeʼcheneto Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Allempo atet̃ eñoranaʼtenana acheñeneshaʼpaʼ oʼ huapa Jesús pachor epuet ñam̃a paʼmoʼnasheñneshaʼ. Oʼ c̈hapuet allpaʼ ñetñapaʼ alla t̃omc̈henet aʼyot̃. Añ muenenet ahuoʼch serrpareʼtatoset. ");
INSERT INTO ameNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Allempoña puesheñarrpaʼ atet̃ otan Jesús: —Oʼcaʼye huapaña p̃achor ñam̃a pemoʼnasheñneshaʼ. Ñetpaʼ aʼyot̃eʼtsaʼyenet, mueneñet oʼch serrpareʼtatospet. ");
INSERT INTO ameNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ñañapaʼ atet̃ otan ñeñt̃ oteneʼ: —¿Amaʼt señoteñe ñeñt̃ eʼñe poʼñoc̈h nachor nepen ñam̃a ñeñt̃ eʼñe poʼñoc̈h nemoʼnasheñ nepen? ");
INSERT INTO ameNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Allempoñapaʼ yochan pueyochreshaʼpaʼ atet̃ otanet: —Napaʼ añcaʼyeña ñeñt̃ eʼñe poʼñoc̈h nachor nepen ñam̃a ñeñt̃ eʼñe poʼñoc̈h nemoʼnasheñneshaʼ nepen. ");
INSERT INTO ameNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ñehua, amaʼt erraʼtsena ñeñt̃chaʼ eʼñe atet̃ p̃ohueneʼ ñeñt̃ atet̃ muenen Nompor ñeñt̃ pueʼntañoʼtsen ñeñt̃caʼyeña eʼñe poʼñoc̈h nemoʼnasheñ nepen ñeñt̃ña noc̈h nepen ñeñt̃ña nachor nepen. ");
INSERT INTO ameNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ñeñt̃e yet̃ropaʼ c̈haʼnerrerr Jesús pocollot̃paʼ anorruerr saʼpatop̃ño. ");
INSERT INTO ameNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Allñapaʼ emchorraʼhuererr shonteʼ acheñeneshaʼ ñeñt̃oʼmarña Jesúspaʼ aʼtap noñt̃opaʼ ahuam̃pes mameʼ allpononet̃ allñapaʼ anorros noñt̃o. Acheñeneshaʼña allohuenetpaʼ alla t̃omc̈haʼtet saʼpatop̃ño. ");
INSERT INTO ameNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Allñapaʼ esocmañen yec̈hatyenan acheñeneshaʼ paʼnamen tomaʼnteñtsoc̈hno. Ñeñt̃ ñanompaʼ atet̃ otanet: —Ñeñt̃ña aʼparreneʼ puerets ñañapaʼ ahuoʼ allchaʼ aʼparreʼtyenanaʼ puepuer. ");
INSERT INTO ameNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","All aʼparreʼtyeñ patantaʼtetsñapaʼ alla c̈hapyes t̃oñoʼmar. Allñapaʼ huac̈haʼtyesa ot̃ eʼñe añyallmechuenanaʼ puerets. ");
INSERT INTO ameNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Poʼpoñec̈hnoñapaʼ alla c̈hapyes mapuetroʼmesoʼmar all ama tama eñalle pats. Ama nanac oʼponoʼtseno patso ñeñt̃oʼmarña mamet̃ollapaʼ cheparesuañ. ");
INSERT INTO ameNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Oʼña enomeʼtaʼmuen atsrret̃paʼ alla aʼuyatuer. Ama erc̈haʼtenaʼ ñeñt̃oʼmarña alla hueyaʼhuerra. ");
INSERT INTO ameNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Poʼpotantañña pueretspaʼ alla c̈hapyes allchaʼ chepares aj. Allpaʼc̈hoʼ mameshapaʼ cheparesuañpaʼ ajñapaʼ mameshapaʼ ateshaʼtua alla caʼmatuerranña narmets alla aʼcllatuer. ");
INSERT INTO ameNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Poʼpotantañec̈hno ñeñt̃ñapaʼ arr c̈hapyes all eʼñe cohuen patso. Ñeñt̃ñapaʼ eʼñe cohuen chepares. Allempoña ateshaʼtuapaʼ ñeñt̃ñapaʼ atarr aton ellom̃reʼtyes—puechaʼtetspaʼ c̈harroch c̈harraʼ pueʼllomer, poʼpchañec̈hnopaʼ pechapoch c̈harraʼ pueʼllomer, poʼpchañec̈hnopaʼ maʼpoch c̈harraʼ pueʼllomer. ");
INSERT INTO ameNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Allempoña Jesúspaʼ alla oterraneterr: —Ñeñt̃es poʼñoc̈h neʼm̃ñoteneʼ, c̈haponasepaʼch seyoc̈hro ñeñt̃ atet̃ netmaʼntatensa añ ñoñets. ");
INSERT INTO ameNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Allempoñapaʼ ponem̃ya pueyochreshaʼpaʼ atet̃ otoset: —¿Esoʼmareʼtña peserrpareʼteñot̃paʼ att̃a es petmaʼntatyenanet? ");
INSERT INTO ameNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesúsñapaʼ atet̃ oterraneterr: —Sa t̃eʼpaʼ Yomporña oʼ muenaterres att̃och señoterr ñeñt̃ ama eñotpahuoyaye amaʼt ahuat̃ot̃eñ ñeñt̃ atet̃ penaña Yompor poʼcohuenña att̃o ayochreshat̃tena ña pueʼntañot̃. T̃arraña poʼpotantañec̈hnoñapaʼ ñeñt̃ att̃a es puec̈haʼyetsa, ñocpuetñapaʼ amach errot̃enot̃ eñoterrñañeto Yompor poʼcohuenña. ");
INSERT INTO ameNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Eseshaʼt̃eʼ oʼ c̈herranet pueyoc̈hreto amaʼt eʼñe allpona Yompor poʼñoñ elloña Yomporpaʼ alloʼnach eñotatnenanet nanac shonteʼ. T̃arraña eseshaʼña ñerraʼm ama c̈henaneto pueyoc̈hro t̃arroʼmar ñetpaʼ ama poʼñoc̈hayeʼ aguëññañeto Yompor poʼñoñ, amaʼt allpon eñotyenetañ pueyoc̈hro ñeñt̃ñapaʼ c̈hach puerratam̃perranet Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ñeñt̃oʼmarña amaʼt neserrpareʼtatenanet tomaʼnteñtso, ñocpuetñapaʼ ama eñoteñetoña ñeñt̃ atet̃ netmaʼntatenanet. Att̃oña amaʼt enteñetañ, ñetñapaʼ ama amnataret̃teneto oʼch es c̈hapahuet pueyoc̈hreto. Amaʼt eʼmueñetañ amaña c̈henanetoña pueyoc̈hreto ñeñt̃ atet̃ yec̈hateney Yompor poʼcohuenña. ");
INSERT INTO ameNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Atet̃ penet ñetpaʼ t̃eʼñapaʼ poʼñoc̈h oʼ etsotua Isaías poʼñoñ ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ ahuat̃. Ñeñt̃paʼ atet̃ oteʼt̃ Yompor: Amaʼtchaʼ poʼñoc̈h eʼmueñetañ amaʼt eʼñe ahuat̃apaʼ amach c̈hapanetoña pueyoc̈hreto. Ñam̃a amaʼtchaʼ c̈ho eʼñe es entenetañpaʼ amach c̈hapanetoña pueyoc̈hreto. ");
INSERT INTO ameNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","T̃arroʼmar ñeñt̃ acheñeneshar t̃eʼña ñet pueyoc̈hretopaʼ nanac echarrtenet att̃ochña amach es c̈henahueto pueyoc̈hreto. T̃eʼña ñetpaʼ amach mueneñeto oʼch es eʼm̃ñotet t̃ayeʼtoʼt̃eʼ es c̈henahuet pueyoc̈hreto. T̃eʼñapaʼ amach mueneñeto oʼch es entet t̃ayeʼtoʼt̃eʼ c̈herranet pueyoc̈hreto. Att̃ochña amach es cot̃apeʼcherreto nocop amaʼt eʼñe mamesha att̃ochña naʼqueshp̃aterranetañ. ");
INSERT INTO ameNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Allempoña Jesúspaʼ alla oterranerr pueyochreshaʼ: —Saña poʼñoc̈hpaʼ atarr cosheñtsoʼtsenes sa t̃arroʼmar att̃o oʼ senterrñañ Yompor poʼcohuenña seclloyot̃ t̃eʼñapaʼ oʼ eʼñe c̈herrnasa seyoc̈hro. Ñam̃a att̃o seʼmuerrñañ Yompor poʼñoñ, t̃eʼñapaʼ oʼ eʼñe c̈herrnasa seyoc̈hro. ");
INSERT INTO ameNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Poʼñoc̈hcaʼye notenes eʼñe ahuat̃ot̃eñpaʼ shonteʼ ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ amaʼt ñam̃a ñeñt̃ eʼñe pocteʼ es p̃aʼyestseʼt̃ allempo, ñetñapaʼ atarr muenetañeʼt̃ oʼch enterrñañetañ Yompor poʼcohuenña ñeñt̃ oʼ senter sa t̃eʼ. T̃arraña allempo ñetpaʼ amaña eseshayeʼña enterrapaye Yompor poʼcohuenña. Amaʼt atarr muenetañeʼt̃ oʼch eʼm̃ñoterrñañet Yompor poʼñoñ ñeñt̃ oʼ seʼmuerr sa t̃eʼ. T̃arraña allempo ñetpaʼ amaña eseshayeʼña eʼmuerrapayeña Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jesúsñapaʼ alla oterranerr pueyochreshaʼ: —Ñeñt̃oʼmarña t̃eʼ sapaʼ seʼm̃ñoten oʼch neñotatas ñeñt̃ atet̃ yec̈hateney ñeñt̃ atet̃ oʼ netmaʼntatua atet̃ ñerraʼmrrat̃eʼ puesheñarr ñeñt̃ aʼparreneʼ puerets. ");
INSERT INTO ameNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ñehua, añ puerets ñeñt̃ c̈hapyesets t̃oñoʼmar, ñeñt̃paʼ añ notenes acheñeneshaʼ ñeñt̃ eʼm̃ñotenayeñ Yompor poʼñoñ ñeñt̃ att̃o ayochreshat̃tena ña. Amaʼt eʼm̃ñotenetañ t̃arraña ama c̈henaneto pueyoc̈hreto ñeñt̃ poʼñoc̈h atet̃ oteney Yompor. Ñeñt̃oʼmar allorocmach huapa oneñet̃paʼ oʼch alla puerratam̃perranet Yompor poʼñoñ eʼñe pueyoc̈hretot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Ñam̃a ñeñt̃ c̈hapyesets mapuetroʼmesoʼmar ñeñt̃paʼ añ notenes acheñeneshaʼ ñerraʼm esempo eʼm̃ñoteññañet Yompor poʼñoñ eʼñech allorocma pocsheñeshaʼ aguëññañetañ Yompor poʼñoñ. Eʼñech cohuen ameʼñeretañ t̃arraña ñeñt̃paʼ mamecpach atet̃ penet. T̃arroʼmar ñetpaʼ eʼñe atet̃ penet ñerraʼmrrat̃eʼ narmets ñeñt̃ chepuets mapyo amach eñalle puerec̈h. Tsapat̃onet̃ña ñerraʼm oʼch huapanet topateñets ñeñt̃chaʼ mueroc̈htatahuet t̃arroʼmar ñetpaʼ oʼ ameʼñeretañ Yompor poʼnoñ, ñetñapaʼ allorocmach alla quec̈hpuerretña Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ñam̃a puerets ñeñt̃ c̈hapyesets ajmoʼmar, ñeñt̃paʼ añ netmaʼntatena poʼpotantañ acheñeneshaʼ ñeñt̃ eʼm̃ñotenayeñ Yompor poʼñoñ. Amaʼtchaʼ c̈hapanetañ pueyoc̈hreto, t̃arraña ñetpaʼ alloʼnach senet eʼñech aña atarr cot̃apeʼchenet ñeñt̃ llecaʼyenet arr patsro ñeñt̃ eʼñe ñocpueta. Añach muenenet oʼch esocmañen es echyenet, t̃arraña ñeñt̃paʼ c̈hacaʼye shequënanet. Att̃oña ñetpaʼ amach errot̃enot̃ orrtatyesñañetoña ñeñt̃ eʼñe cohuen enten Yompor. Ñetpaʼ eʼñe att̃eta ñerraʼm narmets ñeñt̃ c̈ha aʼcllaten ajmaʼ ñeñt̃oʼmarña amach errot̃enot̃ meʼteneto oʼch ellom̃reʼtyeset. ");
INSERT INTO ameNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ñam̃a añ puerets ñeñt̃ c̈hapyesets eʼñe cohuen patso ñeñt̃ eʼñe cohuen cheparsatspaʼ ñeñt̃ña tomaʼntenaya poʼpotantañ acheñeneshaʼ ñeñt̃ eʼm̃ñoteneʼ Yompor poʼñoñ, ñoñetspaʼ eʼñech cohuen c̈henanet pueyoc̈hreto. Ñetñapaʼ ñeñt̃et poʼñoc̈h orrtatyenet ñeñt̃ atarr sherbets Yomporecop. Att̃oña ñetpaʼ eʼñe atet̃ penet ñerraʼm narmets ñeñt̃ atarr aton ellom̃reʼtyets—pat̃eʼtets c̈harroch c̈harraʼ pueʼllomer, poʼpoñpaʼ pechapoch c̈harraʼ pueʼllomer, poʼpoñpaʼ maʼpoch c̈harraʼ pueʼllomer. ");
INSERT INTO ameNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Allempoña Jesúspaʼ alla tomaʼntaterraneterr, ñeñt̃paʼ atet̃ oterraneterr: —Yompor poʼcohuenña ñeñt̃ att̃o t̃eʼ ayochreshat̃tena ña pueʼntañot̃, ñeñt̃paʼ atet̃ pena ñerraʼmrrat̃eʼ puesheñarr yacma ñeñt̃ aʼparreneʼ cohuen puerets paʼmro. ");
INSERT INTO ameNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Eʼñe cohuen aʼparreʼtuepaʼ t̃arraña allempo manrrenet allohuenet, eʼñeʼt aʼnahua huapa ñeñt̃ eʼmoñeʼteneʼpaʼ allñapaʼ ahuoʼt aʼparreʼtyesuenanaʼ taʼtllom̃ eʼñe all aʼparraret̃ cohuen trigo. Ahuoʼtña aʼparreʼtueñaʼpaʼ oʼ ahuerr aʼnahua. ");
INSERT INTO ameNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Narmetsñapaʼ oʼ cheparesua oʼ meʼtyesuapaʼ allempoñapaʼ entet ñam̃a taʼteʼ oʼ chepares epuet trigo. ");
INSERT INTO ameNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Allempoñapaʼ huac̈haʼta pamoʼmteʼ paʼtaruasañer, ñetñapaʼ atet̃ otoset: “¿Amaʼt, Nomporchaʼ cohuenayeʼ p̃aʼparrenoña puerets p̃aʼmro? Errot̃enot̃uañacaʼye oʼ chopña ñam̃a taʼteʼ all.” ");
INSERT INTO ameNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ñañapaʼ atet̃ otanet: “Eʼñecaʼye cohuen naʼparrañña nepuer all. Ñeñt̃ neʼmoñeʼteneʼpaʼ ñeñt̃t̃eʼcaʼyeña oʼ atet̃ p̃am̃p̃sen.” Paʼtaruasañerñapaʼ atet̃ ochet: “¿Amaʼt pemno oʼch ahuey oʼch yaʼmareʼtuerraʼña taʼteʼ?” ");
INSERT INTO ameNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ñañapaʼ atet̃ otanet: “Amachcaʼye saʼmareʼtatsche t̃eʼt c̈ha saʼmaram̃pennan netrigor. ");
INSERT INTO ameNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Allepaʼ chepuepaʼ epuet. Esempoch pomellaʼhua trigopaʼ allempochña noch ñeñt̃chaʼ aʼyapac̈heʼ trigo: Ñanomchaʼ añ saʼyapac̈haʼ taʼteʼ oʼch sehuancachmech att̃och yaʼpoyatater. Sehuancaʼhuepaʼ c̈hoschaʼña aʼyapac̈heʼña ñam̃a trigo oʼch saññoʼteñaʼ allecma neshontateñ.” ");
INSERT INTO ameNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Allempoña Jesúspaʼ alla oterraneterr: —Añ Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña pueʼntañot̃, ñanompaʼ eʼñech puesheñaʼttsa ameʼñaʼyestsa. Allempoteññapaʼ alloʼnach sen atonetnomtsa ñeñt̃chaʼ ameʼñerrtsa att̃ochña eʼñe epaʼhuerra erracmañen Yompor poʼcohuenña. Ñeñt̃paʼ añ tomaʼntaterraneterr mostazllom̃: —Ñeñt̃ña pueʼllom̃ret̃ollpaʼ puesheñarrñapaʼ oʼ anem̃ paʼmro allchaʼ nareʼteñaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ñehua, eʼñe yeñoteñ mostazllom̃ ñeñt̃paʼ atarrcaʼye nanac añet̃olleshallmerr, t̃arraña ñerraʼm oʼch yenareʼchpaʼ allempoña choppaʼ alloʼnach sen rrorranmats cohuen, atarrchetnomuets, elloch metanaʼtuan poʼpchañ narmetsoc̈hno. Ñeñt̃ña narmetsocherpaʼ oʼch huac̈haʼtoña ot̃ec̈hno ñeñt̃chaʼ amaʼtanatyesosets puetacroʼmar. ");
INSERT INTO ameNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesúspaʼ alla serrpareʼtaterraneterr ellonet̃ ñeñt̃ atet̃ pena Yompor poʼcohuenña ñeñt̃ att̃o atarr ayochreshat̃tena ña pueʼntañot̃. Ñeñt̃paʼ amaʼtchaʼ añet̃olla ñeñt̃chaʼ ñanom orrtatsa t̃arraña eʼñe ña poʼhuamencot̃ mamet̃ollapaʼ oʼch eʼñe epaʼhua ora errap̃aren. Ñeñt̃paʼ añ tomaʼntaterraneterr atet̃ pena chaseʼ: —Ñeñt̃ chaseʼpaʼ allo tsetenan coyaneshaʼ harinaʼ ñeñt̃ oñetsetstaten att̃och aʼchasatan harinaʼ eshecchaʼ eʼñe aʼmuesatue. Ñeñt̃ña chaseʼpaʼ amaʼtchaʼ añet̃olla net, amaʼtchaʼ aton harinaʼ ñeñt̃ maʼpa arroga, mamet̃ollapaʼ oʼch eʼñe aʼmuesatuanña amaʼt atarr aton harinaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ora allpon ñeñt̃ atet̃ yec̈hatenan Jesús acheñeneshaʼ, ñeñt̃paʼ att̃o es tomaʼntatyenanet. Allempopaʼ ama serrpareʼtataneto eʼñe att̃a, c̈hocmaña serrpareʼtatenanet tomaʼnteñtso. ");
INSERT INTO ameNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Att̃oña oʼ etsoterra ñeñt̃ atet̃ oteʼt̃ ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ ahuat̃ ñeñt̃ atet̃chaʼ yec̈haterr Cristo: Napaʼ neñerrchaʼ eʼñe tomaʼnteñtso; naʼpot̃errchaʼ ñeñt̃ ama aʼpot̃aret̃eyaye amaʼt ahuat̃ot̃eñ allempot̃eñ Yompor yec̈hcatan añ patser. ");
INSERT INTO ameNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Allot̃ña Jesúspaʼ saʼnman acheñeneshaʼpaʼ oʼ c̈herr pocollo. Allña huac̈haʼtoña pueyochreshaʼpaʼ atet̃ otoset: —T̃eʼpaʼ oʼch p̃otey eʼñe eñotoc̈hen ñeñt̃ tomaʼntena taʼteʼ ñeñt̃ chepuets p̃aʼmro. ");
INSERT INTO ameNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ñañapaʼ atet̃ otanet: —Ñeñt̃ nareʼteneʼ eʼñe cohuen pueretspaʼ ñeñt̃paʼ nacaʼye Ñeñt̃en Acheñetosets. ");
INSERT INTO ameNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ñeñt̃ naʼmuer nepenpaʼ ñeñt̃caʼyeña añe patser. Ñeñt̃ cohuen pueretspaʼ ñeñt̃caʼyeña Yompor pueyochreshaʼ ñeñt̃chaʼña c̈herrets all am̃chaʼtaret̃tena Yompor. Ñeñt̃ taʼteʼpaʼ ñeñt̃caʼyeña oneñet̃ pueyochreshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ñeñt̃ eʼmoñeʼteneʼ ñeñt̃ nareʼtam̃p̃seʼ taʼteʼ ñeñt̃caʼyeña oneñet̃ pompor. Esempoch c̈herr allempoch pomellaʼhuapaʼ ñeñt̃paʼ añ tomaʼntena allempochña mellapoterra. Ñeñt̃chaʼña aʼyapac̈herretspaʼ ñeñt̃caʼyeña mellañoteñnaneshaʼ ñeñt̃chaʼ huac̈haʼttsa entot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Atet̃ apc̈henet taʼteʼ t̃eʼ oʼch aʼpoyatachet tsopaʼ atet̃chaʼ perrñañetña oneñet̃ pueyochreshac̈hno allempoch mellapoterra. ");
INSERT INTO ameNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ñehua, na Ñeñt̃en Acheñetosetspaʼ nach mueñerreʼ nem̃llañot̃eñnaneshar ñeñt̃chaʼ aʼyapac̈haʼtuerreʼ allohuen ñeñt̃ cot̃apeʼchatyenahuet sosey ñam̃a allohuen ñeñt̃ eʼñe aña etsotayen pat̃pareñ. Arrot̃chaʼ aʼyapac̈haret̃terra alloʼtsaʼyen ñam̃a Yompor pueyochreshac̈hno, amaʼt eʼñe all ayochreshat̃tena ña. ");
INSERT INTO ameNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Oʼch eʼñe aʼyapac̈haret̃etuerretpaʼ allempochña asaprrotaret̃tet oʼpono all huorten tsoʼ. Allñapaʼ allchaʼ yahuanrrorterret, panmueñot̃et atserrpaʼ rrasoʼtyerretchaʼ paʼs. ");
INSERT INTO ameNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Allempoña allohuen ñeñt̃ eʼñe pocteʼ es p̃aʼyets ñetñapaʼ poptetsetach eʼñech att̃et ñerraʼm atsrret̃. Eʼñech cohuen popuetyenet all am̃chaʼtaret̃tena ñeñt̃ pompor penet. Allohuenes ñeñt̃es neʼm̃ñoteneʼ neñoñ c̈haponasepaʼchña seyoc̈hro ñeñt̃ atet̃ notenes. ");
INSERT INTO ameNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Poʼpocheño Jesúspaʼ alla tomaʼntaterranet poʼpoñonet̃. Ñeñt̃paʼ añ tomaʼntatanet Yompor poʼcohuenña att̃o atarr ayochreshat̃tena ña, ñeñt̃ñapaʼ atarr ayeʼchoc̈hen. Ñeñt̃paʼ atet̃ tomaʼntatanet ñerraʼmrrat̃eʼ shonteʼ quelle ñeñt̃ eʼpotaret̃tetsa eʼñe patso. Ñeñt̃ña quelle puesheñarr yacmapaʼ machayot̃ach entos. Oʼña entuepaʼ oʼ alla pampaʼner ñañapaʼ oʼ ahuerr eʼñe pocsheñeshaʼ allent̃a pomhuahuerran ora ñeñt̃ allpon echyen allochñapaʼ att̃och echan quelle alloch rañt̃errana ñeñt̃ patser alloʼtsen quelle. Att̃ochña ganam̃perrana atarr shonteʼ quelle ñeñt̃ atarr yeʼchena. ");
INSERT INTO ameNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Poʼpocheñopaʼ atet̃ tomaʼntaterraneterr: —Yompor poʼcohuenña att̃o atarr ayochreshat̃tena ña ñeñt̃paʼ atarr ayeʼchoc̈hen atet̃ ñerraʼmrrat̃eʼ ñeñt̃ atarr coc̈hneshaʼ serets. Puesheñarrña ñeñt̃ pomatsreʼtyetsa ñeñt̃ach atarr eʼnyen ñeñt̃chaʼ rañt̃a. ");
INSERT INTO ameNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pamt̃arrñapaʼ entosan serets ñeñt̃ atarr nanac coc̈hneshaʼ ñeñt̃ñapaʼ atarr tsaʼteʼ. Ñañapaʼ allent̃ach ahuerr oʼch pomhuahuerran ora ñeñt̃ allpon echyen allochñapaʼ att̃och echan quelle alloch rañt̃errana serets ñeñt̃ atarr nanac coc̈hneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jesúspaʼ alla tomaʼntaterraneterr; ñeñt̃paʼ atet̃ otanet: —Yompor poʼcohuenña att̃o atarr ayochreshat̃tena pueʼntañot̃ ñeñt̃ñapaʼ eʼñe atet̃ ñerraʼmrrat̃eʼ terraya añecmuen. Oʼch terrayet saʼpopaʼ oʼch eʼñe apc̈haʼhuan allohuen paʼnamen cacac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ñerraʼm oʼch eʼñe chorra allempoñapaʼ oʼch chetam̃peret top̃ñaso, oʼch anorrc̈haʼtet allchaʼ acret ñeñt̃ eʼñe cohuenareʼ ñeñt̃chaʼña eshaʼtanatet puecañt̃ro. Ñeñt̃ña ama cohuenayayepaʼ oʼch saprrochet. ");
INSERT INTO ameNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ñeñt̃paʼ atet̃chaʼcaʼye perraña allempoch mellapoterra. C̈haʼnmac̈haʼtchaʼ mellañoteñneshaʼ ñeñt̃chaʼ ellopaʼtetstaterreʼ ñeñt̃ atsrreʼmñat̃neshaʼ ñam̃a ñeñt̃ eʼñe pocteʼ es p̃aʼyets. ");
INSERT INTO ameNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ñeñt̃ña atsrreʼmñat̃neshaʼpaʼ huaporeʼteretchaʼ oʼpono all huorten tsoʼ. Allñapaʼ allchaʼ yahuanrrorterret, panmueñot̃et atserrpaʼ rrasoʼtyerretchaʼ paʼs. ");
INSERT INTO ameNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Allempoñapaʼ allent̃a aʼp̃t̃oʼtanet: —¿Eñotoc̈henaʼt sentenña allohuen ñeñt̃ atet̃ notyenes? Ñetñapaʼ atet̃ ochet: —Eñotoc̈hencaʼye yenteñ. ");
INSERT INTO ameNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Allempoñapaʼ atet̃ otanet: —Ñeñt̃oʼmarña amaʼt allohuen erraʼtsen ñeñt̃ atarr etsoteneʼ ñoñets ñeñt̃ atet̃ anaret̃ ahuat̃ot̃eñ, ñerraʼm elloña ayc̈hataret̃tet ñamet ñeñt̃ atet̃ pena Yompor poʼcohuenña att̃o atarr ayochreshat̃tena ña, ñeñt̃ña acheñer atarrchaʼ cohuen orrtatenan cot̃ap̃ñats ñeñt̃ ahuat̃ot̃eñ, elloña cohuenchaʼ orrtaterran ñam̃a ñeñt̃ eʼñe etserra cot̃ap̃ñats. Eʼñech atet̃ pena ñerraʼmrrat̃eʼ ñeñt̃ apacllat̃eshaʼ. All aññoʼtyenan ñeñt̃ atarr morrentena errot̃enopaʼ oʼch orrtatenan ñeñt̃ errteʼ aññoʼten all; errot̃enoñapaʼ oʼch orrtatyenan ñam̃a ñeñt̃ aññoʼten ahuat̃ot̃eñ all paʼpacllo. ");
INSERT INTO ameNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Serrpareʼtatuanet Jesús ñeñt̃ atet̃ tomaʼntatyesanet, ñañapaʼ ahuerrerr allot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","C̈herr paʼnyo all Nazareto yec̈hatuerraneterr all poʼprahueto. Allñapaʼ nanac cohuanrrorteñet, atet̃ otyeñet: —Ñapaʼ errahuañacaʼyeña eñotanña ora allohuen ñeñt̃ atet̃ p̃aʼyena. Eseshaʼhuañacaʼyeña eñotateneʼña att̃ot̃ orrtatenan partsoteñets. ");
INSERT INTO ameNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ñapaʼ aña puechemer ñeñt̃ poʼtaruas peneʼ oʼch t̃orrenana tsach att̃och es yec̈hcatyen paʼnamen. Pachorpaʼ aña María. Paʼmoʼnasheñpaʼc̈hoʼña aña Jacobo, José, Simón, Judas. ");
INSERT INTO ameNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Allohuen poʼc̈haneshaʼpaʼ eʼñecaʼye yechmeʼtuenanet parroʼmarneshayarramcheʼ. Taʼm ñañapaʼ errot̃enot̃t̃eʼña atarr es eñotyen. ");
INSERT INTO ameNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ñeñt̃oʼmarña all eʼñe ña paʼnyo ama eseshayeʼ acuaʼpenaye entenaye. Allempoña Jesúspaʼ atet̃ otanet: —Ñeñt̃ aʼm̃teneʼ Yompor poʼñoñpaʼ c̈hocmacaʼye am̃chaʼnaʼtpoʼ entyeñña allohuen acheñeneshaʼ, arrña paʼnyo alloʼtsen eʼñe ña pamoʼtsnaʼtarneshaʼ ñetñapaʼ ama acuaʼpenayeʼ enteñeto. Amaʼt ñam̃a ñeñt̃ parro yec̈henet paʼpaclleto, ñetpaʼc̈hoʼña ama acuaʼpenayeʼ enteñeto. ");
INSERT INTO ameNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ama ameʼñeñeto ñeñt̃oʼmarña allpaʼ ama atonocheyeʼ orrtataneto poʼpartsoña. ");
INSERT INTO ameNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Allempoña am̃chaʼtaret̃ Herodespaʼ eʼmareʼtenan atet̃ p̃aʼyena Jesús. Ñehua, Herodespaʼ all am̃chaʼtaret̃tena anetso Galileo. ");
INSERT INTO ameNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Allempoñapaʼ atet̃ otan ñeñt̃ sherbeneʼ: —Añepaʼtcaʼyeña Juanañ ñeñt̃ apatayeʼt̃ acheñ Yomporecop; taʼmcaʼye c̈hat̃eʼcaʼye tanterraña rromot̃. Ñeñt̃oʼmart̃eʼcaʼyeña t̃eʼpaʼ orrtaterranña partsoteñets. ");
INSERT INTO ameNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ñehua, allempopaʼ ahuañmoʼchacma rrematenanaʼ Juanañ oʼ huancachpaʼ allña yottam̃p̃sach att̃och coshatan Herodías ñeñt̃ paʼmoʼnasheñ Felipe puet̃apor. ");
INSERT INTO ameNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","T̃arroʼmar Juanañpaʼ ña otayeʼt̃ Herodes: —Amacaʼye pocteyaye oʼch peyoram̃pes pemoʼnasheñ puet̃apor. ");
INSERT INTO ameNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Amaʼt atarr mueneñeñ oʼch muetsatacheñ eʼñe allempocma t̃arraña Herodespaʼ mechaʼtenan acheñeneshaʼ ñeñt̃oʼmarña ama eshcayeʼ muetsatache. T̃arroʼmar acheñeneshaʼpaʼ eʼñe cohuen enteñet Juanañ atet̃ ñerraʼmrrat̃eʼ ñeñt̃ aʼm̃teneʼ Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Allempoña coshameʼtapreteñet Herodes allempo eñalletña allñapaʼ oʼ tancsosa Herodías puechoyor. ");
INSERT INTO ameNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Herodesñapaʼ ñeñt̃a atarr cohuen ent. Ñeñt̃oʼmarña och: —Na poʼñoc̈hpaʼ oʼch nenaʼ neñoñ eʼñe Parets paʼsoʼchño, amaʼt es penamuenpaʼ napaʼ napap̃chaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Pachorñapaʼ allent̃a otareʼch eʼñe aʼnahua: —Oʼhua p̃ocht̃eʼ am̃chaʼtaret̃: “Añchaʼ p̃apuen Juan poñ.” Allempoña shopsheshaʼpaʼ atet̃ otan Herodes: —Napaʼ añ nemnen oʼch pepechennanaʼ Juan poñ ñeñt̃ apatayeʼt̃ acheñeneshaʼ, oʼch penon platopaʼ oʼch p̃aphuerren eʼñe arrma. ");
INSERT INTO ameNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Oʼña enamhuepaʼ am̃chaʼtaret̃ñapaʼ c̈ha lleca. T̃arraña amaʼt llecañpaʼ oʼ nohuanña poʼñoñ huomenc eʼñe Yompor paʼsoʼchño ñam̃a alloʼtsaʼyen ñeñt̃ huaʼñen ñeñt̃ eʼmueneʼ atet̃ oten ñeñt̃oʼmarña otanet: —T̃eʼpaʼ oʼch sap̃ Juan poñ. ");
INSERT INTO ameNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Allempoñapaʼ oʼ mueñan paʼcheñer oʼch pecheñetaʼ Juan all yottam̃peñet. ");
INSERT INTO ameNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Allempoña oʼ huapaterrñañet poñ platopaʼ aphueret shopsheshaʼ. Ñañapaʼ anem̃ pachoresho oʼch apueñaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Allempoñapaʼ ahuanma Juanañ pueyochreshaʼ oʼ aneret apecharet̃ oʼch pampueretaʼ. Oʼña pampaʼhueretaʼpaʼ oʼ ahuanerret oʼch eʼmareʼtateñetaʼ Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesúspaʼ allempo eʼmareʼtan Juanañ, ñañapaʼ ahuam̃pes noñt̃o oʼ saʼnman acheñeneshaʼ oʼch ahuoʼ all ama acheñempañoyaye. Acheñeneshaʼñapaʼ allempo eʼmareʼchet ñetñapaʼ allent̃a ahuanmuet ñamet. Allohuen anetsot̃paʼ eʼñe ahuanmuet oʼch enteretaʼ Jesús. Ñetñapaʼ alla oñmac̈haʼtet patsoʼmar. ");
INSERT INTO ameNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Allempoña sehuosa Jesús noñt̃ot̃paʼ alla entuerraneterr oʼ alla shontaʼhuerrerr acheñeneshaʼ. Ñañapaʼ atarr nanac mueraʼhuerraneterr. Allñapaʼ oʼ alla aʼcrratyesuerraneterr patsnañet̃er. ");
INSERT INTO ameNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Att̃eñapaʼ ellerren pueyochreshaʼñapaʼ oteñetaʼ Jesús: —T̃eʼpaʼ arroʼtseney all ama acheñempañoyaye ñam̃a oʼcaʼye ellerren. T̃eʼpaʼ oʼch p̃och acheñeneshaʼ ahuanemyerretepaʼ anetsoʼmar allchaʼ rañt̃aʼyesuerret puerraret ñeñt̃chaʼ rraʼyesuerret. ");
INSERT INTO ameNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesúsñapaʼ otanet: —Amachcaʼye ahuanmatsterreto. Sachcaʼye apaʼyesahuet ñeñt̃chaʼ rret. ");
INSERT INTO ameNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ñetñapaʼ atet̃ ochet: —Ya arrpaʼ amacaʼye es yechenoña amaʼt coñeʼt̃a; yapaʼ eʼñecaʼye amnara pan yechen ñam̃a epat̃oll cac. ");
INSERT INTO ameNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Allempoña Jesúspaʼ atet̃ otanet: —Sanmon arrma oʼch sapuennaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Allempoñapaʼ otan acheñeneshaʼ: —T̃eʼpaʼ oʼch sanorrc̈haʼtyes eʼñe all cohuen emmoʼratyen pasetmaʼ. Allempoña agapan ñeñt̃ amnar pan ñam̃a epat̃oll cac, oʼ cohuaʼ enonet̃, parasyosoʼtam̃p̃san pan allot̃ñapaʼ shotaʼtan pan, apanatyesan pueyochreshaʼ. Ñetñapaʼ oʼ epatyeset allohuen acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Eʼñe epaʼhuet, allempoña oʼ rrallmeʼchet allohuenet eʼñepaʼtchaʼ yetrraʼtuahuet. Eʼñe yetuahuetpaʼ c̈ha aʼpchatyeset ñeñt̃ñapaʼ aʼyapac̈heret. Ñeñt̃ña aʼyapac̈herretpaʼ c̈hepaʼtchaʼ chorrats c̈harraʼ puechena epa cañt̃er eʼñe t̃amoʼyareʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ñeñt̃ña rrallmeʼchatspaʼ atarr shonteʼ acheñeneshaʼ; ñatoʼ alloʼtsent̃eʼ amnaroch mil ñeñt̃ eʼñe yacmaneshocheʼ. Ellonet̃paʼ alloʼtsaʼyen ñam̃a coyaneshac̈hno ñam̃a cheshaneshac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Allempoña Jesúspaʼ otan pueyochreshaʼ: —T̃eʼpaʼ oʼch saʼtac̈haʼt noñt̃o oʼch sota sanom oʼch sep̃chaterra yot̃. Napaʼ oʼch nesoʼtnom̃ ora acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Oʼña soʼtuanmanetpaʼ ñañapaʼ ahuoʼ aspent̃o eʼñe ñapuet̃ allña maʼyochosa. Amaʼt oʼ tsapuenpaʼ ñañapaʼ alloʼtsena ñapuet̃. ");
INSERT INTO ameNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Noñt̃ñapaʼ ñeñt̃a rroc̈hasoʼtsenara saʼpo, emoʼyareʼñapaʼ c̈ha anmapeʼcham̃penanet, aʼpuerrameʼtam̃penanet orrno. ");
INSERT INTO ameNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Att̃eña allempoña puetarenmochpaʼ huenanet Jesús c̈ha chopeʼchnen enot̃ oño. ");
INSERT INTO ameNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","All chopeʼchnen allempoña entapueñ pueyochreshaʼ, ñetñapaʼ c̈ha t̃oratsetyeset pueyoc̈hret, atet̃ otannaʼtyeset: —Choyesheʼmatst̃eʼcaʼye huaponaya. Pueyorñot̃etpaʼ att̃a rrannartet. ");
INSERT INTO ameNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jesúsñapaʼ eñoranaʼtuenanet, atet̃ otuenanet: —C̈hoñacaʼye socshapuenna, nacaʼye oʼ nohuapa, amach att̃a sem̃chaʼtatstapno. ");
INSERT INTO ameNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Allempoña Pedropaʼ eñoranaʼcha ñeñt̃paʼ atet̃ och: —Ñerraʼm poʼñoc̈ht̃eʼ p̃a Partseshachaʼ, t̃eʼpaʼ oʼch p̃otosen, ap̃oncaʼye nesho, pechopeʼchnom p̃am̃a enot̃ oño. ");
INSERT INTO ameNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesúsñapaʼ allent̃a och: —Ap̃oncaʼye. Ñañapaʼ allent̃a sohua noñt̃ot̃paʼ oʼ chopeʼchnom ñam̃a enot̃ oño oʼch ahuoʼ Jesúsesho. ");
INSERT INTO ameNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Chopeʼchnomtsapaʼ oʼ cohuaʼnman huomenquëshaʼ ñeñt̃ c̈ha emoʼyartatenan saʼppaʼ c̈ha yoreʼch. C̈ha yoreʼchpaʼ alla mueneʼ eshaʼta oño. Allñapaʼ rranareʼta atet̃ otan Jesús: —¡P̃aʼqueshp̃atosen Partseshachaʼ! ");
INSERT INTO ameNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesúsña t̃ecma rremap̃paʼ atet̃ och: —P̃apaʼ amaʼt eʼñeyeʼ peyemtenno. Esoʼmareʼt c̈ha peʼcharrtatenña peyoc̈her. ");
INSERT INTO ameNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Eʼñe aʼtac̈haʼtatseta noñt̃opaʼ huomenquëshaʼñapaʼ c̈hepaʼtchaʼ muetsoñeñterrtsa. ");
INSERT INTO ameNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ñeñt̃ña noñt̃oʼtsaʼyenpaʼ allent̃epaʼtchaʼ concorpanrrortanaʼtapetpaʼ atet̃ otyeset: —Poʼñoc̈hepaʼt p̃apaʼ eʼñe Parets Puechemerep̃. ");
INSERT INTO ameNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Allempoña pechatam̃p̃setpaʼ arr etsotoset all oteñet Genesareto. ");
INSERT INTO ameNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ñeñt̃ña aneʼtañneshaʼ allpaʼ oʼ chemeʼtapet Jesús. Att̃o chemeʼtapetpaʼ ñetñapaʼ allent̃a mueñet acheñ, oʼch eʼmareʼtatenanaʼ acheñeneshaʼ allampañoʼmar. Allot̃ñapaʼ huapatyesoñet allohuen atsnañet̃ec̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ñeñt̃ña atsnañet̃ec̈hnopaʼ oʼ enamyesoset amaʼt posoʼmot̃a oʼch aʼp̃llaʼyesosñañet paʼshtam. Allpon ñeñt̃ aʼp̃llaʼyesoseʼ Jesús paʼshtam allponc̈hoʼ eʼñe corraʼyesuerrtsa. ");
INSERT INTO ameNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Allempoña fariseoneshaʼ ñam̃a ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop ñetñapaʼ arrot̃ huac̈haʼtet Jerusaléñot̃. C̈hac̈haʼtet Jesúseshopaʼ atet̃ otyesoset: ");
INSERT INTO ameNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Esoʼmareʼtña peyochreshaʼñapaʼ quec̈hpuerretña ñeñt̃ atet̃ yeyc̈heʼt̃ ya ahuat̃ yatañneshohuen. Ñeñt̃oʼmar oʼhuañ eʼpotaʼtetña Partsocop allempo rrenet. ");
INSERT INTO ameNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ñañapaʼ atet̃ otanet: —Sapaʼc̈hoʼña ñeñt̃oʼmareʼtrraña sat̃pareʼteññañña sam̃a Yompor poʼñoñ ñeñt̃ atet̃ anaret̃ allochñapaʼ eʼñech sañeña seyc̈heña eʼñe setsotayen. ");
INSERT INTO ameNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ñehua, poʼñoc̈hcaʼye yeñoteñ Yomporpaʼ atet̃ oteney: “Semorrenteñot̃paʼ sem̃chaʼnaʼchchaʼ sompor ñam̃a sachor.” Elloña ñam̃a poʼpoñonet̃ atet̃ oteney: “Ñerraʼm eseshaʼ sasareʼteneʼ pompor ñam̃a pachor ñeñt̃paʼ muetsetepaʼ.” ");
INSERT INTO ameNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","T̃arraña sañapaʼ amaña att̃eyeʼ sepeno t̃arroʼmar sapaʼ c̈haña atet̃ sotyen: —Ñerraʼm eseshaʼ atet̃ oteneʼ pompor ñam̃a pachor: “Ñeñt̃ nechen oʼch napapeñpaʼ t̃arraña amach napape t̃eʼpaʼ oʼch neneʼ Yomporecop” ");
INSERT INTO ameNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ñeñt̃ña acheñerpaʼ sañapaʼ atet̃chaʼ soteñ: “P̃ocoppaʼ ama pallteno oʼch es p̃ap̃ p̃amoʼmteʼ.” Sapaʼ att̃ocaʼyeña sehuaporeʼteññañña Yompor poʼñoñ allochñapaʼ eʼñech aña setsoten ñeñt̃ eʼñe sañeña seyc̈heña. ");
INSERT INTO ameNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Sapaʼ atarrcaʼye ommoñat̃neshas t̃arroʼmar atarr seshcareʼten amaña Yomporeyeʼña sesherbeno. Isaíaspaʼ eʼñe cohuen aʼm̃taneʼt̃ Yompor poʼñoñ, saña t̃eʼpaʼ eʼñe atet̃ sepena atet̃ oteʼt̃; allempopaʼ atet̃ ot Yompor: ");
INSERT INTO ameNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ñeñt̃ acheñenesharpaʼ eʼñe puenamot̃a cohuentatennanetañ; pueyoc̈hretoñapaʼ ama c̈henaneto ñeñt̃ cohuen nenten na. ");
INSERT INTO ameNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Eʼñe orrena maʼyochennet, ñeñt̃ atet̃ yec̈hatannenetpaʼ ñeñt̃paʼ eʼñe acheña nayeʼt̃ ahuat̃ poct̃ap̃ña. ");
INSERT INTO ameNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Allempoña Jesúspaʼ c̈horeʼtan acheñeneshaʼ ñeñt̃ shontetsa, ñetñapaʼ atet̃ otanet: —Sañapaʼ eʼñepaʼchña cohuen seʼm̃ñoten allochñapaʼ att̃och eʼñe cohuen c̈haponasa seyoc̈hro. ");
INSERT INTO ameNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ama añeyeʼ yaʼsosyatenaye Partsocop ñeñt̃ yerraʼyen yenamot̃. Añcaʼyeña yaʼsosyateneʼ yeñoñ ñeñt̃ c̈haʼnets yenamot̃ ñeñt̃ atet̃ yeñosatseʼtyen. ");
INSERT INTO ameNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Allñapaʼ atet̃ oteñaʼ pueyochreshaʼ: —¿Peñoteñeʼt fariseoneshaʼñapaʼ allempo eʼmonapet peñoñ ñeñt̃ atet̃ p̃otyenanet ñetñapaʼ c̈ha atsrreʼmuet? ");
INSERT INTO ameNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ñañapaʼ atet̃ tomaʼntatanet ñeñt̃chaʼ atet̃ ap̃aret̃terra fariseoneshaʼ, ñeñt̃paʼ atet̃ otanet: —Allohuen narmetsoc̈hno ñeñt̃ ama añeyeʼ nareʼtaye Apa ñeñt̃ pueʼntañoʼtsen ñeñt̃ñapaʼ aʼmareʼtaret̃etuerrach. ");
INSERT INTO ameNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ñetpaʼ ottetepaʼt̃a. Ñetpaʼ eʼñe atet̃ penet ñerraʼmrrat̃eʼ puesheñarr ñeñt̃ aporoʼyet̃paʼ ñapaʼ oʼch echaʼnman poʼpsheñeñ ñeñt̃ parro aporoʼyet̃ecmuet. Allempo atet̃ penet ñerraʼm arrorot̃ont̃a echaʼnmannaʼtnomuet epsheñoʼmaret c̈hach shoraʼnmoset arrorot̃o. Arrpaʼ allohua ñeñt̃ atet̃ tomaʼntatanet atet̃ ñerraʼm ya allempo ama yoct̃apeʼcherraʼ ñeñt̃ cohuentetsa Yomporecop amach errot̃enot̃ yoct̃apeʼchache poʼpsheñeñ ñeñt̃ ama eñotenaye ñeñt̃ cohuen enten Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Allempoña Pedropaʼ atet̃ ot: —Yapaʼ c̈hochña peserrpareʼtatey eʼñe cohuen eñotoc̈hen ñeñt̃ atet̃ petmaʼntatena ñorraʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ñañapaʼ atet̃ otanet: —Amaʼt sapaʼc̈hoʼña amaʼtña señoteñaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Sapaʼ amaʼt c̈hennasoña seyoc̈hro ñeñt̃ yerraʼyen yenamot̃paʼ alla sen yat̃o ñeñt̃paʼ c̈hocmach yener aʼyo. ");
INSERT INTO ameNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Añña ñeñt̃ c̈haʼnets yenamot̃ ñeñt̃ att̃o yeñosatseʼtyen ñeñt̃paʼ eʼñe yeyoc̈hrot̃ huena ñeñt̃ña c̈hocma yaʼsosyateneʼña Partsocop. ");
INSERT INTO ameNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Eʼñe yeyoc̈hrot̃ huena cot̃ap̃ñats ñeñt̃ amaʼt mameshapaʼ ama cohuenayaye, ñeñt̃paʼ añ: muetsannaʼteñets, chetapretannaʼteñets, cañoreshaʼteñets, etatsreʼtyeñets, tomaʼtam̃p̃sannaʼteñets, sasareʼteñets. ");
INSERT INTO ameNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ñeñt̃ allohuen sosyaʼtsañec̈hno ñeñt̃ huetsa yeyoc̈hrot̃ ñeñt̃ña poʼñoc̈h yaʼsosyateneʼ Partsocop. T̃arraña allempo yerrallmeʼchyen amaʼt ama yeʼpotaʼtyesopaʼ ñeñt̃paʼ amaña ñeñt̃eyeʼña yaʼsosyatenayeña Partsocop. ");
INSERT INTO ameNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ahuerrerr Jesús allot̃paʼ alla c̈hap allampaño anets Tiro ñam̃a Sidón. ");
INSERT INTO ameNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Allñapaʼ oʼ huapa puesheñarr coyaneshaʼ ñeñt̃ alloʼmarneshaʼ ñeñt̃ cananoʼmarneshaʼ. Ñañapaʼ allent̃a rranareʼtospaʼ atet̃ otos: —Pemuerayeʼchosna, Nepapareshachaʼ p̃apaʼ ñeñt̃ep̃ Davidnaʼtarep̃. Na nacñeʼt̃erpaʼ atarr mueroc̈htateñ oneñet̃. ");
INSERT INTO ameNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesúsñapaʼ amaʼt mameshapaʼ ama eñoranaʼteño. Att̃eñapaʼ oʼ ponem̃ya pueyochreshaʼ otoset: —Peʼm̃ñochñacaʼye t̃ecma allochñapaʼ oʼch ahuerr, c̈hacaʼye cot̃aʼneney perranareʼtnomueʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ñañapaʼ atet̃ otanet: —Napaʼ eʼñe añecpa allsensaret̃en ñeñt̃ israelenaʼtarneshacop; ñetpaʼ eʼñe atet̃ nentenanet ñerraʼm carrneroc̈hno ñeñt̃ payaʼtyetsa. ");
INSERT INTO ameNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Coyaneshaʼña ñeñt̃ ama israelenaʼtareyayepaʼ ñañapaʼ allent̃a on eʼñe ñesho concorposñañapaʼ atet̃ otos: —C̈hoña Nepapareshachaʼ pebensam̃p̃sayeʼcherrnan nacñeʼt̃er. ");
INSERT INTO ameNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesúsñapaʼ tomaʼntatana acheñeneshaʼ ñeñt̃ ama israelenaʼtarneshayaye ñeñt̃oʼmarña atet̃ och: —Ama pocteyaye oʼch yeprratam̃pes yacñet̃ar puerrar oʼch yehuaporeʼtam̃pes alloʼtsen ochec oʼch rreʼ ñam̃a ochec. ");
INSERT INTO ameNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Coyaneshaʼñapaʼ atet̃ otererr: —Amaʼt att̃eñ Nepapareshachaʼ t̃arraña amaʼt ochecpaʼc̈hoʼña rraʼyenan ñeñt̃ aʼshoreʼtatyen pamoʼmteʼ poʼmesap̃nac̈ho. ");
INSERT INTO ameNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Allempoña Jesúspaʼ atet̃ otererr: —C̈hepaʼt nesñeshachaʼ atarr nanac peyemtenna ñeñt̃epñapaʼ att̃etepaʼch p̃ocop atet̃ pemnen p̃a. Pacñeʼt̃erñapaʼ allorocma correrra. ");
INSERT INTO ameNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ahuerrerr Jesús allot̃paʼ alla oñem saʼpatop̃ñoʼmar eʼñe Galileaso. Allot̃paʼ ahuoʼ aspent̃o allñapaʼ anorros. ");
INSERT INTO ameNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Allñapaʼ alla huac̈herrñañerr shonteʼ acheñeneshaʼ. Huapatyerrñañeterr checaʼrepac̈hno, mancoc̈hno, aporoʼyet̃ec̈hno, opananeshac̈hno ñam̃a huapatoñet shonteʼ poʼpotantañec̈hno. Ñeñt̃ñapaʼ alla nanatyesosñañet paʼrrp̃ot̃. Ñañapaʼ eʼñe aʼcrratyesuerranet. ");
INSERT INTO ameNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Allña acheñeneshaʼpaʼ c̈ha atarr cohuanrrorteñet allempo eñchet att̃o opanac̈hno c̈ha eñoraʼyerrtsa, mancoc̈hnopaʼc̈hoʼña c̈ha cohuenetyerrtsa, checaʼrepac̈hnopaʼc̈hoʼña c̈ha chopeʼchyerrets, aporoʼyet̃ec̈hnopaʼc̈hoʼña c̈ha eʼñe cohuen cohuaʼyerrets. Atet̃ eʼñe cohuen eñchetpaʼ allohuenetñapaʼ cohuentateññañet israelneshaʼ Poʼyomporer. ");
INSERT INTO ameNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Allempoña Jesúspaʼ agotan pueyochreshaʼpaʼ atet̃ otapanet: —Napaʼ c̈ha atarr nemuereña allohuen acheñeneshaʼ ñeñt̃ shontetsa arr. Oʼ maʼpamtoset nesho ama eñallmeñeto ñeñt̃chaʼ rret. Ama pocteyeʼ nenteñe oʼch ahuanerret eʼñe paʼchporrñeshaʼ t̃eʼt ama aʼñsheʼmterreto t̃oño. ");
INSERT INTO ameNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Pueyochreshaʼñapaʼ atet̃ otoset: —Errahuachcaʼye yentña allpon rreñets ñeñt̃chaʼ yerrach shonteʼ acheñ, arrpaʼ amayacaʼye. ");
INSERT INTO ameNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesúsñapaʼ atet̃ oterraneterr: —Sapaʼ ¿errponaʼt sechenña pan? Ñetñapaʼ otereterr: —Eʼñecaʼye canc̈hrra ñam̃a coñeʼt̃ cacat̃olleshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Allempoñapaʼ otan acheñeneshaʼ: —T̃eʼpaʼ sanorrc̈haʼtyes patso. ");
INSERT INTO ameNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Allñapaʼ agapan ñeñt̃ canc̈herr pan ñam̃a cacat̃olleshaʼ. Agaphuepaʼ oʼ parasyosoʼtenanerr Pompor allot̃ñapaʼ oʼ shotaʼtan pan, shetseʼtan ñam̃a cac, apanatyesan pueyochreshaʼ. Ñetñapaʼ oʼ epatyeset ñamet allohuen acheñeneshaʼ eʼñe epaʼhuet. ");
INSERT INTO ameNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Allempoñapaʼ oʼ rrallmeʼchet allohuenet, eʼñe yetrraʼtuahuet. Oʼ eʼñe yetuahuetpaʼ c̈ha aʼpchatyeset ñeñt̃ñapaʼ aʼyapac̈heret. Ñeñt̃ña aʼyapac̈herretpaʼ c̈hepaʼtchaʼ chorrats canc̈herr cañt̃er eʼñe t̃amoʼyareʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ñeñt̃ rrallmeʼchats atarr aton acheñeneshaʼ ñatoʼ alloʼtsent̃eʼ paʼtatsoch mil ñeñt̃ eʼñe yacmaneshocheʼ. Ellonet̃ñapaʼ alloʼtsaʼyen ñam̃a coyaneshac̈hno ñam̃a cheshaneshac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Allempoña Jesúspaʼ soʼtnerran acheñeneshaʼpaʼ ahuerr, aʼtapos noñt̃opaʼ ahuam̃perr oʼch ahuoʼ anetso ñeñt̃ paʼsoʼcheñ Magdala. ");
INSERT INTO ameNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseoneshaʼ ñam̃a saduceoneshaʼ ñetpaʼ oʼ ahuanmuet oʼch enteñetaʼ Jesús. C̈hac̈haʼtet Jesúsesho ñetña pueshquënot̃etpaʼ atet̃ otyesoset: —Yapaʼ añ yemnen oʼch pegatapuey pepartsoña entot̃ allochñapaʼ att̃och yeñotosep̃ poʼñoc̈h p̃apaʼ Parets Puechemerep̃. Ñetpaʼ c̈ha mueneñet oʼch topatoset Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ñañapaʼ aña yerpatapanet ñeñt̃ atet̃ otyenet ñet paʼnyeto: —Sapaʼ ñerraʼm esempo sentnen oʼch tsatatetnena enet, sañapaʼ c̈hocmach atet̃ sotyesneneʼt̃: “Tsapat̃paʼ atarrchaʼ char.” ");
INSERT INTO ameNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aromtañañapaʼ ñerraʼm esempo sentaʼmuen enet c̈ha tsatattaʼmuena, sañapaʼ c̈hocmach atet̃ sotyesaʼmueneʼt̃: “C̈hoch huataʼmuena ñeñt̃oʼmar oʼ c̈ha rrenarsaʼmuen.” Sapaʼ atarr señoteneñña ñeñt̃ sentyen ento ñeñt̃ña señotateneʼ. T̃arraña ñeñt̃ atet̃ norrtatyennas nepartsoteña esoʼmart̃eʼña ñeñt̃ñapaʼ amaña eñotatensoña ñeñt̃ atet̃ pennas Yompor t̃eʼ oʼch orrtatonas poʼcohuenña. Ñeñt̃paʼ att̃at̃eʼ seshquën. ");
INSERT INTO ameNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Acheñeneshaʼ ñeñt̃ corraʼyetsa t̃eʼ ñetñapaʼ ama cohuenayeʼ cot̃apeʼchyeneto, ama añeyeʼ cosheneto Yompor ñeñt̃oʼmarña ñetpaʼ eʼñe orrena otennet ahuoʼch norrtatanet nepartsoña. T̃arraña amach es norrtataneto. Napaʼ añach pat̃err neñotatanet atet̃ eñotataneʼt̃ Jonás ahuat̃ nínivoʼmarneshaʼ. Jesúsñapaʼ saʼnerranetpaʼ ahuerr. ");
INSERT INTO ameNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Allempoña pechatrraʼtet yom̃taʼn oʼ c̈hapuet all, pueyochreshaʼñapaʼ oʼ yerpuerret ñetpaʼ ama anmueto pan ñeñt̃chaʼ rroset all. ");
INSERT INTO ameNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesúsñapaʼ atet̃ otapanet: —Eʼñech señota ñatoʼt semeñeʼteñaʼña fariseoneshaʼ amaʼt ñam̃a saduceoneshaʼ poʼchaser allo tsetenet pan. ");
INSERT INTO ameNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ñetña cot̃apeʼchyesetpaʼ atet̃ otannaʼtyeset: —Amacaʼye yanmoña pan ñeñt̃oʼmart̃eʼcaʼyeña oteney añoʼch yemeñeʼtatscheña fariseoneshaʼ poʼchaser. ");
INSERT INTO ameNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesúsña allempo eñotanet atet̃ cot̃apeʼchyenet ñañapaʼ atet̃ oterraneterr: —Esoʼmareʼt sellquëñeshaʼ sotannaʼtyena añoʼ eñalle ñeñt̃chaʼ serraʼ. Sapaʼ amaʼtña eʼñeyeʼ seyemtenno. ");
INSERT INTO ameNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","T̃emeʼttsenaʼtña ama es sec̈henoyoña seyoc̈hro. Amaʼtña seyerpuenoña allempo natontat amnar pan ñeñt̃ nerratallmeʼchpaʼ alloʼtsen amnaroch mil acheñeneshaʼ. Amaʼt seyerpuenoña ñam̃a ñeñt̃ allpon chorrarerrets cañt̃ro ñeñt̃ sapc̈herr allempo. ");
INSERT INTO ameNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Amaʼt ñam̃a allempo natontaterrerr ñeñt̃ canc̈herr pan ñeñt̃ña nerratallmeʼcherrerrpaʼ alloʼtsen paʼtatsoch mil acheñeneshaʼ. Ñam̃a ñeñt̃ allpon chorrarerrets cañt̃ro ñeñt̃ sapc̈herrerr allempo. ");
INSERT INTO ameNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Errot̃enot̃uañacaʼyeña ama señotenoña ñeñt̃ atet̃ notas ñorraʼ att̃och ama semeñeʼtatsche fariseoneshaʼ amaʼt ñam̃a saduceoneshaʼ poʼchaser ñeñt̃paʼ ama rreñtsoyeʼ notenso. ");
INSERT INTO ameNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Allempoña ñetpaʼ oʼ c̈hapanet pueyoc̈hreto, atet̃ otannaʼtet: —Amuepaʼtcaʼye añeyeʼ otenye pan poʼchaser; añepaʼtcaʼyeña oteney amach yemeñeʼtatsche fariseoneshaʼ amaʼt ñam̃a saduceoneshaʼ poct̃ap̃ña ñeñt̃ atet̃ yec̈hatannenet ñeñt̃ ama cohuenayaye, t̃eʼt mamesha epaʼhua erracmañen eʼñe atet̃ pena chaseʼ mameshapaʼ oʼch aʼchasaʼhuan ora all yeneñ. ");
INSERT INTO ameNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Allempoña c̈hap Jesús all Cesarea ñeñt̃ara Filipo, allñapaʼ otosan pueyochreshaʼ: —¿Errot̃enaʼt otyenenña allohuen acheñeneshaʼ, na Ñeñt̃en Acheñetosets eseshant̃eʼ? ");
INSERT INTO ameNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ñetñapaʼ atet̃ otyeset: —Patantarr acheñeneshaʼpaʼ atet̃caʼye otyenpet p̃apaʼ Juanañp̃oʼt̃eʼ ñeñt̃ep̃oʼ apatañtatseʼt̃ Yomporecop. Poʼpotantaññapaʼ atet̃ otyenpet p̃apaʼ Elíasop̃oʼt̃eʼ; poʼpotantaññapaʼ atet̃ otyenpet p̃apaʼ Jeremíasop̃oʼt̃eʼ amapaʼ añep̃oʼt̃eʼ poʼpsheñeñ ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ ahuat̃. ");
INSERT INTO ameNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Allempoñapaʼ alla aʼp̃t̃oʼterraneterr: —Sañapaʼ ¿errot̃enaʼtña sotenenña sa? ");
INSERT INTO ameNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pedroñapaʼ eñoratsapaʼ atet̃ och: —P̃apaʼ ñeñt̃ep̃caʼye atarr yecuen amaʼt ahuat̃ot̃eñ; ñeñt̃ep̃caʼye Parets Puechemerep̃ ñeñt̃ep̃ Cristotosets. Ñeñt̃ña Parets ama arromñat̃eshayaye. ");
INSERT INTO ameNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesúsñapaʼ atet̃ och: —Nanac cosheñtsoʼtsenep̃, Simóna ñeñt̃ep̃ Jonás puechemerep̃ t̃arroʼmar att̃o peñotenenpaʼ ñeñt̃paʼ ama arromñat̃eshayeʼ peñotatenaye; naña Nompor peñotateneʼ ñeñt̃ pueʼntañoʼtsen. ");
INSERT INTO ameNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Napaʼc̈hoʼña t̃eʼpaʼ oʼch notap̃ p̃am̃a, p̃apaʼ añchaʼ nesocherrep̃ Pedro. (Ñehua, añ soʼchñets Pedropaʼ añ tomaʼntena ñeñt̃ atarr es echarr atet̃ ñerraʼm mapueʼ.) Ñam̃a p̃a eʼñe peyemteñot̃en na, na poʼñoc̈hpaʼ naña Cristotosets, ñeñt̃paʼ allochcaʼyeña norrtaterrña allohuen ñeñt̃chaʼ nameʼñerraya ñeñt̃chaʼ apc̈haʼyerrtsa eʼñe na pameʼñeñot̃et. Atarrchaʼ huomenc echarr nep̃aʼyerranet allohuenet ñeñt̃etchaʼ apc̈haʼyerrtsa pameʼñeñot̃etan na att̃ochña ñocpuetpaʼ amach eñalle ñeñt̃chaʼ huaporeʼterrahuet, amaʼt ahuat̃a. Amaʼt rromueñets poʼhuamencpaʼ amach errot̃enot̃ metanerranetoña ñet poʼhuamenc. ");
INSERT INTO ameNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ñam̃a na t̃eʼpaʼ oʼch napuerrep̃ llesens att̃och p̃aʼpot̃errñañ Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña pueʼntañot̃; ñeñt̃paʼ añ tomaʼntena atet̃ ñerraʼmrrat̃eʼ llave alloch petoram̃per allohuen ñeñt̃ mueneneʼ oʼch pueyochreshaʼ perranet. Ñam̃a ñerraʼm erraʼtsenchaʼ eʼñe pocteʼ pent ñeñt̃chaʼ penaʼyes arr patsropaʼ Yomporpaʼc̈hoʼña ñeñt̃ entoʼtsen eʼñech att̃ecma pocteʼ enterranet. Ñam̃a ñeñt̃chaʼ ama pocteyeʼ penteno ñeñt̃chaʼ penaʼyes arr patsro, Yomporpaʼc̈hoʼña ñeñt̃ entoʼtsen eʼñech att̃ecma amach pocteyeʼ enterraneto. ");
INSERT INTO ameNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Allempoñapaʼ otan pueyochreshaʼ: —Amach eseshaʼ sotap̃saʼtatsto amaʼt puesheñarra napaʼ na ñeñt̃en Cristotosets. ");
INSERT INTO ameNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jesúsña eʼñe allempot̃eñpaʼ mot̃etnom̃ eñotatyesnomueʼ pueyochreshaʼ ñeñt̃ atet̃ anaret̃ ñocop, ñapaʼ mueroc̈htateretchaʼ; oʼch ahuoʼ Jerusaléño allñapaʼ allchaʼ mueroc̈htateret. Añchaʼ errot̃uanen perreʼ ñeñt̃ pomporneshaʼ pen allohuen judioneshaʼ ñam̃a ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen poʼcornaneshar ñam̃a ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop. Allñapaʼ allchaʼ muetsatateret t̃arraña puemaʼpamtañoña Pomporpaʼ oʼch alla tantater. ");
INSERT INTO ameNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedroñapaʼ allent̃a anem̃ aʼyenet̃paʼ allñapaʼ atet̃ otos: —Arepaʼchña Partseshachaʼ att̃eyeʼ perrpeto amaʼt errponaña. Yomporepaʼchña eʼñe pecuam̃peneʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ñañapaʼ puetallsa aʼyenet̃ mameʼpaʼ atet̃ otan Pedro: —Orrap̃ aʼyo neshot̃ oneñet̃e, p̃apaʼ eʼñe orrena pepatareʼtenen; p̃apaʼ amacaʼye Yomporeyeʼ atet̃ p̃oct̃apeʼchatenaye, ñeñt̃paʼ acheñarramcheʼ poct̃ap̃ña. ");
INSERT INTO ameNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Allempoña Jesúspaʼ atet̃ otan pueyochreshaʼ: —Ñerraʼm eseshaʼ mueneneʼ oʼch cot̃errnet na eʼñe poʼñoc̈h att̃och neyochreshaʼ neperranet, añ poctetsa sehuanmuetepaʼña ñeñt̃ atet̃ muenenet eʼñe ñocpueta. Att̃ochña ñetpaʼ oʼch eʼñe tomaʼnteret ñeñt̃ chechneneʼ poʼcorsoch allchaʼ mueroc̈htet ñamet. Att̃ochña cot̃errnet eʼñe poʼñoc̈h. ");
INSERT INTO ameNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","T̃arroʼmar ñerraʼm eseshaʼ eʼñe aña muenenet oʼch correna atomat att̃och eʼñe coshenet arr patsro, ñetñapaʼ c̈hach aʼchencatenet eʼñe ñañeñeta. T̃arraña ñerraʼm eseshaʼ eʼñe pocteʼ enteneʼ oʼch es sohuanerret eʼñe pocrreñohuenet nocop, ñeñt̃ña acheñerpaʼ ñañapaʼ corretsach pocsheñeshocmañen eʼñe t̃ayot̃eñ errponañohuen. ");
INSERT INTO ameNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Amaʼt errponenap̃aren esocmañen es yeyoratseʼtyes ora allpon ñeñt̃ yentyen añe patsro, t̃arraña ñerraʼm ñeñt̃ach eʼñe yaʼchencaterreʼ yecamquëñohuen, ñeñt̃ñapaʼ amaʼt coñeʼt̃apaʼ amach es sherberrye. T̃arroʼmar ama eñalle poʼpoñ ñeñt̃ atarr sherbets, añña atarr nanac sherbets ñeñt̃chaʼ aʼqueshp̃aterreʼ yecamquëñ. T̃arroʼmar yocoppaʼ ama es eñalle ñeñt̃chaʼ yepomuerr alloch alla yerañt̃erra yecamquëñ. ");
INSERT INTO ameNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Poʼñoc̈h napaʼ Ñeñt̃en Acheñetosets oʼch nohuerra epan ñam̃a nem̃llañot̃eñnaneshar. Eʼñech Nompor poʼcohuenñot̃ nohuerra. Allempochña netsaʼterranet eʼñe puesheñaʼttsocmuet errot̃ent̃eʼ p̃aʼyeseteʼt̃. ");
INSERT INTO ameNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Poʼñoc̈hcaʼ t̃eʼpaʼ oʼch notas, patantaʼttsos ñeñt̃es arroʼtsaʼyenes amaʼt ama serromhuenaʼpaʼ oʼ senterrñañ Yompor poʼcohuenña att̃o napaʼ Ñeñt̃en Acheñetosetspaʼ atarrchaʼ naʼyochreshat̃terra. ");
INSERT INTO ameNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Allempo pechapmaterrerr, Jesúsñapaʼ ahuanerranerr pueyochreshaʼ; añ anem Pedro ñam̃a Jacobo ñam̃a Juan ñeñt̃ Jacobo paʼmoʼnasheñ. Ñetpaʼ arr anmanet atarr aspent̃o eʼñe ñapt̃ochayet. ");
INSERT INTO ameNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Allña Jesúspaʼ machayot̃epaʼtchaʼ poʼpoñetam̃p̃sosanet. Paʼclloyot̃paʼ c̈ha poptosa eʼñe atet̃ ñerraʼmrrat̃eʼ atsrret̃ poptetsa. Eʼñe paʼshtamohuen atarr huallamaʼt̃o poptosa c̈ha aʼpuetaresue aʼyohuen. ");
INSERT INTO ameNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Allñapaʼ machayot̃epaʼtchaʼ orrtanet Moisés ñam̃a Elías. Ñetñapaʼ alla serrpareʼtoset epuet Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pedroña eñoratsapaʼ atet̃ otan Jesús: —Atarruacaʼye Partseshachaʼ, cohuenoʼtseneyt̃eʼ arr. Amaʼt pocteʼ penteñe napaʼ oʼch nat̃omatonas maʼppahua quërpachet—puepahuarrpaʼ p̃ocopchaʼ, poʼppahueñpaʼ Moisésocopchaʼ, poʼppahueñpaʼ Elíasocopchaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Allempo eñorena Pedropaʼ c̈ha orrtosahuet os ñeñt̃ atarr cohuen poptetsa c̈hepaʼtchaʼ aʼpomam̃p̃sosanet. C̈ha eʼmorrtostsa ñoñets osot̃; ñeñt̃ña ñoñetspaʼ Yompor otosahuet; ñeñt̃paʼ atet̃ ot: —Añmapaʼ ñeñt̃ no Nechemer ñeñt̃ atarr nemuerena ñeñt̃ña atarr nocshateneʼ, ñeñt̃chaʼña eʼñe cohuen seʼm̃ñoterr. ");
INSERT INTO ameNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Allempo atet̃ eʼmuet ñoñets pueyochreshaʼñapaʼ alla rremaʼrrtet patso atarr nanac yorenet. ");
INSERT INTO ameNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesúsñapaʼ allent̃a ponerranetpaʼ aʼp̃llaʼhuerranet, atet̃ otanet: —Setanterra, amach c̈ha seyorenatsto. ");
INSERT INTO ameNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Allempoña oʼ cohuerretpaʼ arepaʼtchaʼ eseshayeʼ enterreto, ñapt̃a enteret Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Allempo onac̈herret aspent̃ot̃ Jesúsñapaʼ atet̃ otnerranet: —T̃eʼpaʼ amach eseshaʼ sotap̃saʼtatsto amaʼt eʼñe puesheñarra ñeñt̃ atet̃ oʼ sentua. T̃arrempohuach allempoch netanterra rromot̃ na Ñeñt̃en Acheñetosets, allempochña seserrpareʼtaterña allohuen acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Pueyochreshaʼñapaʼ atet̃ otnerret: —¿Esoʼmareʼtña otenña ñeñt̃ atarr etsoteneʼ ñoñets ñeñt̃ atet̃ anaret̃, Elíasoʼch ñanom huerrtsa? ");
INSERT INTO ameNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ñañapaʼ atet̃ otnerraneterr: —Elías poʼñoc̈hpaʼ ñachcaʼyeña huerrtsa, ñapaʼ eʼñechcaʼye aʼcohuentatuer ora allohuen. ");
INSERT INTO ameNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","T̃arraña napaʼ oʼch notas: Elíaspaʼ oʼcaʼye huaphuerrañ arr t̃arraña amacaʼye eseshayeʼ chemeʼtapuerraye ñeñt̃apaʼ c̈haña errot̃uanen p̃apueret ñeñt̃ atet̃ muenaʼyenet ñet. Eʼñech att̃ecma perrnet nam̃a Ñeñt̃en Acheñetosets. ");
INSERT INTO ameNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Allempoñapaʼ oʼ c̈hapanet pueyoc̈hreto ñeñt̃ otenanetpaʼ añepaʼtcaʼye Juanañ ñeñt̃ apatayeʼt̃ acheñeneshaʼ Yomporecop ñeñt̃epaʼtcaʼyeña Elíasoterrets. ");
INSERT INTO ameNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","C̈herreterr all shontena acheñeneshaʼ puesheñarrña yacmapaʼ ponmapuerrana Jesús concorposñaña. ");
INSERT INTO ameNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Atet̃ otos: —Pemuerayeʼchosnana, Ayochreshat̃e, nacñeʼt̃er c̈ha ot̃ena, nanac mueroc̈htena. Epayeʼ coyaʼnmameʼtateñ tso, errot̃enopaʼ oʼch coyaʼnmameʼtach ñam̃a oño. ");
INSERT INTO ameNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nanomhue peyochresheshopaʼ ñetñapaʼ ama errot̃eyeʼ peto att̃och aʼcrrateret. ");
INSERT INTO ameNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesúsñapaʼ atet̃ ot: —Sa ñeñt̃es acheñres amaʼt mameshaʼpaʼ ama ayemtenayeʼ sentpenno; c̈hach poʼpoñ sentuena seyoc̈hro nocop. Oʼ allponmatuanen alloʼtsenen arr patsro napaʼ att̃a atarr naʼhuantennas, att̃a necuenes ñatoʼ att̃ot̃paʼ oʼch sameʼñerrna. Allempoñapaʼ atet̃ otanet: —Amaʼtpaʼ sanmoncaʼye cheshaʼ arr. ");
INSERT INTO ameNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesúsñapaʼ atet̃ otapan oneñet̃ ñeñt̃ ot̃ateneʼ: —T̃eʼpaʼ poʼñoc̈h oʼch notap̃, pequec̈hpuer cheshachor. Oneñet̃ñapaʼ allent̃epaʼtchaʼ quec̈hpaʼner. Cheshachorñapaʼ allorocma correrra. ");
INSERT INTO ameNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Allempoñapaʼ ponem̃ya pueyochreshaʼ, eʼñe ñapt̃ochayetpaʼ atet̃ otoset: —Yañapaʼ ¿esoʼmareʼtña ama eshcayeʼ yequec̈hpatereña oneñet̃ att̃o ot̃atenan cheshachor? ");
INSERT INTO ameNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ñañapaʼ atet̃ otanet: —T̃arroʼmarcaʼye amacaʼ eʼñeyeʼ seyemtenno ñeñt̃ atet̃ notenes. Napaʼ oʼch notas, ñerraʼm poʼñoc̈h eʼñe na seyemtenañ napaʼ eʼñecaʼye naʼpoctatenña neñoñ ñeñt̃ atet̃ notenes. Amaʼtchaʼ allponat̃ollot̃a seyemtenna ñerraʼmrrat̃eʼ mostazllomet̃oll sañapaʼ amaʼt erraʼtsena senamuennoñ amaʼt ñeñt̃ atarr echarr sentenpaʼ nañapaʼ atet̃chaʼ nepennaseñ. Oʼch netmaʼntatasa atet̃ ñerraʼm oʼch sot: “Añ aspenet̃paʼ rrot̃eʼtepaʼ aʼyenet̃”, aspenet̃ñapaʼ atet̃chaʼc̈hoʼña pennasañ ñeñt̃ eʼñe atet̃ soteñ. Amaʼt mameshapaʼ amach eñalleña ñeñt̃ t̃orrapoʼ senten ñerraʼm eʼñe poʼñoc̈h na seyemtena. ");
INSERT INTO ameNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ñehua, ñeñt̃ atet̃ oneñet̃paʼ amach errot̃enot̃ yequec̈hpatacheña acheñ eʼñe att̃a. C̈hochña yemaʼyochena ñam̃a yemaʼyoc̈hreñot̃ amaʼt yerrarpaʼ oʼch yequec̈hpueʼ mameʼ. Att̃ot̃chaʼña yequec̈hpaterña oneñet̃ ñeñt̃ atet̃. ");
INSERT INTO ameNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Allempo chopeñeʼchyenet parro all Galileoʼmar, Jesúsña allpaʼ eñotatan pueyochreshaʼ, ñeñt̃paʼ atet̃ otnomanet: —Na Ñeñt̃en Acheñetosetspaʼ pomuerrnetchaʼ att̃ochña errot̃uanenchaʼ perrnet. ");
INSERT INTO ameNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Att̃eñapaʼ oʼch muetsataterrnet t̃arraña pomaʼpamtañoñapaʼ oʼch alla netanterra. Ñetñapaʼ ñeñt̃a atarr nanac llecaʼrrtatyesahuet. ");
INSERT INTO ameNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Allempoña Jesús epuet pueyochreshac̈hnopaʼ oʼ alla c̈hac̈herreterr Capernaumo. Allñapaʼ huapanet ñeñt̃ tsaʼtatenaya acheñeneshaʼ quelle ñeñt̃ impuesto; ñeñt̃paʼ Parets paʼpacllecop. Ñetpaʼ atet̃ otoset Pedro: —Semaestrorpaʼ ¿amaʼt pomuenanaʼña quelle impuesto añecop Parets paʼpacllecop? ");
INSERT INTO ameNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedroñapaʼ atet̃ otanet: —C̈hocmach tsaʼta. Allempo c̈hap pocollopaʼ Pedroñapaʼ ama otenanaʼña Jesús, ñañapaʼ ñanmacma otapan Pedro: —¿Errot̃enaʼt, Simóna, penteñña p̃a? Ñeñt̃ am̃chaʼtaret̃ec̈hno ñeñt̃ añe patsroʼtsaʼyen, ¿eseshaʼtña cobrenetña quelle ñeñt̃ impuestocop, ñatoʼ añat̃eʼ cobrenet ñeñt̃ eʼñe ñet pamoʼtsnaʼtarecmuet amapaʼ añt̃eʼ cobrenet ñeñt̃ elloʼmarneshaʼ? ");
INSERT INTO ameNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedroña atet̃ otan Jesús: —Añcaʼye cobrenet ñeñt̃ elloʼmarneshaʼ. Jesúsñapaʼ atet̃ och: —Ñeñt̃epñapaʼ ñeñt̃ eʼñe pamoʼtsnaʼtarecmuetpaʼ amaʼtrra ñeñt̃eyeʼ cobreneto. ");
INSERT INTO ameNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Amaʼt pocteñ amach netsaʼtatsto t̃arroʼmar napaʼ ñeñt̃en Puechemeren ñeñt̃ paʼpaquëll peneʼ ñeñt̃ecop tsaʼtenet, t̃arraña att̃och ama yaʼtsrreʼmatanetopaʼ eʼñecaʼye pocteʼ oʼch netsaʼta. Oʼch ahuep̃ oño oʼch pegoʼtenaʼ all. Erraʼtsenchaʼ ñanom pechtaʼ pegorot̃ ñeñt̃ñapaʼ oʼch pec̈hete. Puenamopaʼ allchaʼcaʼye pent puetallarr quelle. Ñeñt̃ña quellepaʼ oʼch p̃aner ñeñt̃ñapaʼ alloch petsaʼtanet nocop amaʼt ñam̃a p̃ocop. ");
INSERT INTO ameNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Allempoña Jesúspaʼ aʼp̃t̃oʼteñaʼ pueyochreshaʼ, ñeñt̃paʼ atet̃ ochet: —Ñeñt̃ey allponey ñeñt̃chaʼ eʼñe pueyochreshaʼ perr Yompor ñeñt̃ pueʼntañoʼtsen, yapaʼ añ yemnen t̃eʼpaʼ oʼch p̃otey, ¿erraʼtsenot̃eyt̃eʼñacaʼyeña ñeñt̃ey atarr sherbets ñeñt̃ey atarr am̃chaʼtaret̃oyen entyenyet? ");
INSERT INTO ameNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesúsñapaʼ cheshat̃olla c̈horeʼtpaʼ t̃omach eʼñe alloʼtsaʼyenet. ");
INSERT INTO ameNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Allempoñapaʼ atet̃ otanet: —Poʼñoc̈h napaʼ oʼch notas: Ñerraʼm ama c̈ho sequec̈hpaʼhuerro sommoʼcheña att̃och oʼch atet̃ sepena cohuen ñerraʼmrrat̃eʼ añ cheshat̃oll ñeñt̃ ama eñotenanaʼ oʼch ommoʼchena, sañapaʼ amat̃eʼ errot̃enot̃ es soʼpaterroña att̃o atarr ayochreshat̃tena Yompor pueʼntañot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ñeñt̃ allpon ñeñt̃chaʼ eʼñe pueyochreshaʼ perr Yompor ñeñt̃ña acheñer att̃o oʼhuañ cohuen enta ñañeña ñeñt̃paʼ oʼ eʼñe atet̃ perra ñerraʼm cheshat̃oll ñeñt̃ ama eñotenanaʼ pommoʼcheña. Ñeñt̃ñapaʼ atarr nanac asherben enteñ Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Erraʼtsenot̃es sa ñerraʼm eʼñe sameʼñeñot̃en na eʼñe cohuen saguëñ amaʼt ñeñt̃ ama asherbenayeʼ entyeneto atet̃ ñerraʼm añ cheshat̃oll, naʼnaña eʼñe cohuen saguën. ");
INSERT INTO ameNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Amaʼt erraʼtsena ñeñt̃ ama pommoʼcheñot̃eyeʼ ameʼñenno atet̃ ñerraʼm cheshat̃oll ñeñt̃ ama eñotenanaʼ oʼch ommoʼchena, t̃arraña ñerraʼm eseshaʼña poʼpsheñeñ oʼch atet̃ p̃atach ñeñt̃ ama pocteyeʼ enteno Yompor, ñeñt̃ña acheñerpaʼ atarrchaʼ yoroc̈henoʼtsen t̃arroʼmar ñapaʼ aña oʼpatenaya coñcheñets ñeñt̃ atarr huomenc. Amaʼt ñocoppaʼ ama tama yoroc̈henayayñe ñerraʼm ama atet̃ p̃atenanaʼ poʼpsheñeñ, eʼñech allorocma oʼch c̈harachetañ mapueʼ añecmuen paʼc̈hnop̃o allpon ñerraʼm puetseʼtamets oʼch huaporeʼchet oño epo allchaʼ ñoʼshach mapueʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Atarr llequëñets acheñeneshacop arr patsro ñerraʼm esempo eseshaʼpaʼ oʼch atet̃ p̃atyenanet ñeñt̃ ama pocteyeʼ enteno Yompor. T̃arroʼmar c̈hocmach huaponaya ñeñt̃chaʼ yetpatyeneʼ oʼch atet̃ p̃atey ñeñt̃ ama pocteyeʼ enteno Yompor. T̃arraña napaʼ oʼch notas, atarrchaʼ yoroc̈henoʼtsen amaʼt erraʼtsena acheñer ñeñt̃ orrtateneʼ ñeñt̃chaʼ topatyeneʼ poʼpsheñeñ ñeñt̃ nameʼñenaya oʼch atet̃ p̃atyenanet ñamet ñeñt̃ amaʼt mameshapaʼ ama pocteyeʼ enteno Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","9","’Ñam̃a oʼch noterrserr: Ñerraʼm sechets p̃atyenes ñeñt̃ ama pocteyeʼ enteno Yompor atet̃ ñerraʼm sot, setac, seclleʼ, añ poctetsa oʼch sequec̈hpuerr ñeñt̃ c̈hocma atet̃ p̃atseʼtatyenes sechets. Ñeñt̃paʼ eʼñe atet̃ ñerraʼmrrat̃eʼ eʼñe allorocma oʼ sepecherr sot, setac, oʼ serrot̃err seclleʼ, oʼch sehuaporeʼter. Añ cohuen socop amaʼt eʼñe sepoʼyotaʼteñot̃ corretsasach t̃ayot̃eñ errponohuañen. Añña ama cohuenayaye socop esempohuañenpaʼ eʼñech ora epoʼmar sotpaʼ oʼch huaporeʼterrset coñchaʼpuetso all parraren tsoʼ ñeñt̃ ama ahuañaño amaʼt errponaña. Ñam̃a añ cohuen socop amaʼt eʼñe setcot̃paʼ sepshem̃tatquëñot̃ corretsasach t̃ayot̃eñ errponohuañen. Añña ama cohuenayaye socop esempohuañenpaʼ eʼñech ora epoʼmar setacpaʼ oʼch huaporeʼterrset coñchaʼpuetso all parraren tsoʼ ñeñt̃ ama ahuañaño amaʼt errponaña. Ñam̃a añ cohuen socop amaʼt seclloyot̃ sepshem̃taclloʼyeñot̃ corretsasach t̃ayot̃eñ errponohuañen. Añña ama cohuenayaye socop esempohuañenpaʼ eʼñech ora epoʼmar seclleʼpaʼ oʼch huaporeʼterrset coñchaʼpuetso all parraren tsoʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jesúspaʼ alla oterranerr pueyochreshaʼ: —Eʼñech señota, añepaʼchña atarr asherben senten ñeñt̃ ama ommoʼchetso ñeñt̃ atet̃ petsa ñerraʼm cheshat̃oll ñeñt̃ñapaʼ eʼñech pueñmañeshaʼ yemtenna. T̃arroʼmarña t̃eʼpaʼ oʼch notas, ñeñt̃ ama pommoʼcheñot̃eyeʼ nameʼñenayo ñocpuetpaʼ eñalletcaʼyeña poʼm̃llañot̃eñer ñeñt̃chaʼ cohuam̃penahuet. Ñeñt̃ña poʼm̃llañot̃eñretpaʼ c̈hocma Yomporeshoʼtsenet allña eʼñe cohuen eʼm̃ñotenanetña Yompor pueʼntaño. ");
INSERT INTO ameNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Poʼñoc̈h na Ñeñt̃en Acheñetosets añecopña nohuapa att̃och naʼqueshp̃atyesos acheñeneshaʼ ñeñt̃ chenquëtsa. ");
INSERT INTO ameNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Ñehua, ¿amaʼt atet̃ senteñeña? Amaʼt erraʼtsen acheñer ñeñt̃ echeneʼ shonteʼ poʼcarrneror, c̈harroch c̈harraʼ echen t̃arraña ñerraʼm puemocarrña machayot̃a aʼchencachpaʼ pamoʼmteʼñapaʼ oʼch saʼnman allohuen poʼpotantañ ñeñt̃ oʼ noventa nueb̃am̃a all aspent̃o oʼch ahuoʼ eʼnerrayaʼ puemocarr ñeñt̃ chenquëtsa. Allchaʼ eʼnameʼtyeraʼpaʼ att̃ot̃ach enter. ");
INSERT INTO ameNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ñerraʼm ña oʼch enterpaʼ ñeñt̃chaʼña atarr coshaterreʼ. Elloch metanan att̃o coshenana poʼpotantañ noventa nueve poʼcarrneror ñeñt̃ ama payaʼtetso. ");
INSERT INTO ameNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Atet̃caʼye penaña ñam̃a Sompor ñeñt̃ pueʼntañoʼtsen; ñapaʼc̈hoʼña amacaʼ mueno oʼch chenca amaʼt puesheñarrot̃olla acheñ. ");
INSERT INTO ameNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesúsñapaʼ alla oterraneterr; ñeñt̃paʼ atet̃ otanet: —Ñerraʼm errot̃en p̃onas semoʼnasheñpaʼ oʼch ahues ñesho eʼñech sapuet̃ oʼch soct̃apeʼchateraʼ eʼñe cohuen. Ñerraʼm c̈ho eʼm̃ñoterrespaʼ allempoñapaʼ oʼch amoʼtsot̃ senterra. ");
INSERT INTO ameNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ñerraʼm soct̃apeʼchatueñaʼ amach eʼm̃ñotasopaʼ seʼñ puesheñarr amapaʼ epsheña ñeñt̃chaʼ saʼpoctatapreterreʼ. Atet̃chaʼ sep̃a allochñapaʼ ñeñt̃chaʼ eñosets epsheña amapaʼ maʼpsheñoʼmareschaʼ eñosets allempopaʼ eʼñech poʼñoc̈h sameʼña ñeñt̃ ñoñets t̃arroʼmar eʼñech att̃ecma otenet. ");
INSERT INTO ameNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ñerraʼmña atet̃ña oʼ sep̃ohuerñaʼ amach eʼm̃ñoterrsopaʼ allempoñapaʼ oʼch soch allohuenet ñeñt̃ c̈hocma apc̈hetsa pameʼñeñot̃ Yompor. Cot̃apeʼchateretepaʼ ñamet. Ñerraʼm oʼch cot̃apeʼchatuet allohuenetñaʼ, amaʼt ñetña amach eʼm̃ñoterranetopaʼ sañapaʼ eʼñech att̃a senter ñerraʼm poʼpoñ acheñer ñeñt̃ ama semoʼnasheñeyaye. Eʼñech atet̃ senteñ ñeñt̃ acheñer ñeñt̃ ama ameʼñetso, atet̃ ñerraʼmrrat̃eʼ ñeñt̃ pueshquëñot̃eʼna cobraʼyeneʼ acheñeneshaʼ quelle ñeñt̃ gobiernocop. ");
INSERT INTO ameNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Ñehua, t̃eʼ poʼñoc̈hpaʼ oʼch alla noterrserr: Ñerraʼm errot̃enchaʼ eʼñe pocteʼ sent ñeñt̃chaʼ senaʼyes arr patsro, Yomporpaʼc̈hoʼña ñeñt̃ entoʼtsen eʼñech att̃ecma eʼñech pocteʼ enterranet. Ñam̃a ñeñt̃chaʼ ama pocteyeʼ senteno ñeñt̃chaʼ senaʼyes arr patsro, Yomporpaʼc̈hoʼña ñeñt̃ entoʼtsen eʼñech att̃ecma amach pocteyeʼ enterraneto. ");
INSERT INTO ameNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Ñam̃a oʼch alla noterrserr: Poʼñoc̈h ñerraʼm epsheñas arr patsro oʼch eʼñe saʼpoctatue epsheñoʼmares ñeñt̃chaʼ senamuennan Nompor ñeñt̃ pueʼntañoʼtsen ñapaʼ amaʼt erraʼtsena senamueñ c̈hocmach eʼñe atet̃ pennas. ");
INSERT INTO ameNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","T̃arroʼmar ñerraʼm erroʼtsen amaʼt eʼñe epsheña amapaʼ maʼpsheña ñeñt̃ apc̈hetsa eʼñe pameʼñeñot̃etan na, naña allpaʼ alloʼtsenenchaʼ eʼñe ñesheto. ");
INSERT INTO ameNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Allempoña Pedropaʼ aʼp̃t̃oʼtenanaʼ Jesús, ñeñt̃paʼ atet̃ otos: —Partseshachaʼ, ñerraʼm c̈hocma epayeʼ errot̃ penen namoʼts, taʼm ¿errponocheʼtchaʼña nep̃retneʼ ñatoʼ eʼñech canc̈hrrocha nep̃retneʼ? ");
INSERT INTO ameNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesúsñapaʼ atet̃ och: —Napaʼ ama notenpe eʼñech canc̈hrrocha pep̃retneʼ, añña notenep̃ atonochchaʼ pep̃retneʼ—amaʼt canc̈hrrochchaʼ c̈harraʼ, ñam̃a poʼpoñ canc̈herr, allponochchaʼ sep̃retneʼña samoʼts. ");
INSERT INTO ameNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jesúspaʼ atet̃ oterraneterr: —Ñeñt̃oʼmarña Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña pueʼntañot̃ ñeñt̃paʼ atet̃ ñerraʼmrrat̃eʼ puesheñarr am̃chaʼtaret̃. Ñeñt̃ñapaʼ añchaʼ muenen oʼch aʼpoctatyesan att̃o teb̃aʼyeñ allohuen paʼtaruasañrec̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Allempoña all eʼñe aʼpoctatyesanetpaʼ allñapaʼ huapatoñet puesheñarr paʼcheñer ñeñt̃ tebeneʼ patoner quelle ñeñt̃ allpon tebenpaʼ ñeñt̃ oteñet shonteʼ millones. ");
INSERT INTO ameNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ñañapaʼ ama echenano allpon quelle alloch tsaʼterra ñeñt̃ allpon teben. Poʼpatronarñapaʼ atet̃ otanet: “T̃eʼpaʼ oʼch sepomuer epuet puet̃apor epuet ñam̃a puechemereshaʼ ñam̃a oʼch sepomhuerrñañ errpont̃eʼ echyen allochñapaʼ amaʼt allapaʼ oʼch tsaʼterrna att̃o tebenen.” ");
INSERT INTO ameNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Allempoñapaʼ allent̃a concorpanaʼcha paʼtaruasañer ñeñt̃ tebeneʼ, ñeñt̃paʼ atet̃ otareʼch: “Amach nomporchaʼ pemaʼyoreʼtatsetno, netsaʼtuerrp̃ach acop̃a.” ");
INSERT INTO ameNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Poʼpatronarñapaʼ alla morrentera allent̃a aʼrroyer allempocma eʼshohuerrñañ all quellquëññañet ñeñt̃ allpon teben. ");
INSERT INTO ameNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ñeñt̃ña paʼtaruasañerpaʼ oʼ c̈haʼnerr entuerran poʼpsheñeñ ñeñt̃ parro ataruasataret̃tenet ñeñt̃ tebeneʼ ñam̃a, ñeñt̃paʼ eʼñe coñeʼt̃a quelle. Ñañapaʼ c̈ha rremaʼhuerreʼpaʼ allent̃a mueñoc̈heʼ atet̃ otuer: “Petsaʼterrnañacaʼye ñeñt̃ allpon petebenen.” ");
INSERT INTO ameNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Aʼrroyerpaʼ ñañapaʼ allent̃a concorpanaʼtana ñam̃a ñeñt̃ oʼ mueñoc̈hoʼtue. Allñapaʼ atet̃ och: “Amach pemaʼyoreʼtatsetno, netsaʼterrp̃ach acop̃a allpon ñeñt̃ netebenep̃.” ");
INSERT INTO ameNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ñañapaʼ amaʼt mameshapaʼ ama pocteyeʼ eñche, ñeñt̃apaʼ anem̃ allchaʼ yottam̃p̃sach. Allñapaʼ allach esempohuach eʼñe tsaʼtuerra ñeñt̃ allpon teben. ");
INSERT INTO ameNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Añña poʼpotantañec̈hnoña ñeñt̃ parro ataruasataret̃tenetpaʼ ñetñapaʼ amaʼt mameshapaʼ ama pocteyeʼ eñcheto ñeñt̃ atet̃ p̃a ñeñt̃ eʼñe att̃a eʼshohuaret̃terrtsa ñeñt̃ allpon teb̃aneʼt̃ poʼpatronar. Allempoña ñetpaʼ allent̃a ahuanmuet poʼpatronaresho. Allñapaʼ aʼmet̃am̃peret. ");
INSERT INTO ameNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Allempoñapaʼ oʼ alla agotater poʼpatronar. Oʼ c̈herr poʼpatronareshopaʼ atet̃ otapuer: “P̃a naʼtaruasañre, amaʼt mamesha ama cohueneshayaype. P̃añapaʼ att̃a p̃otareʼten napaʼ ahuoʼch nep̃retnerrep̃ nañapaʼ eʼñe att̃a neʼshohuerrnap̃ ñeñt̃ allpon petebenen. ");
INSERT INTO ameNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Amaʼt eʼñe pocteñ p̃apaʼc̈hoʼña oʼch pemueryañ ñeñt̃ parro petaruasen. Atet̃ nepena na eʼñe cohuen nemuererrp̃a.” ");
INSERT INTO ameNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Allempoña poʼpatronarpaʼ eʼñe patsrreʼmueñeshaʼ pomuer, oʼ apuer ñeñt̃chaʼ coñchateʼ esempohuañen allchaʼña eʼñe tsaʼtuerrana ñeñt̃ allpon teben. ");
INSERT INTO ameNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","’Sapaʼc̈hoʼña eʼñe puesheñaʼttsosña ñerraʼm amach sep̃retnere samoʼtspaʼ eʼñech att̃ecma perres sam̃a Nompor ñeñt̃ pueʼntañoʼtsen. C̈hocmuepaʼch eʼñe cohuen sep̃retnannenaña sa eʼñe seyoc̈hrocmañen. ");
INSERT INTO ameNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Serrpareʼtuanerr Jesúspaʼ err Galileot̃. Arr c̈herr Judeo, ñeñt̃ña Judeapaʼ eʼñe alla Jordanaso yom̃taʼn. ");
INSERT INTO ameNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Cot̃aʼhuanererr shonteʼ acheñeneshaʼ allñapaʼ aʼcrratyesuerraneterr allohuenet patsnañet̃eret. ");
INSERT INTO ameNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Allñapaʼ oʼ alla huac̈herrñañerr ñam̃a fariseoneshaʼ. Ñetpaʼ añ muenenet eʼñe pueshquëñot̃etpaʼ oʼch eñorachet ñeñt̃ ama cohuenayaye. Att̃oña ñetpaʼ atet̃ otoset: —Taʼm ¿pocteʼt̃eʼ oʼch yeser yet̃apor ñerraʼm esempo errot̃enot̃? ");
INSERT INTO ameNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesúspaʼ atet̃ otapanet: —Amaʼt selleyareña atet̃ oten Yompor poʼñoñ ñeñt̃ aquellcaret̃ ahuat̃ot̃eñ. Ñehua, allpaʼ atet̃ oten, Yomporpaʼ eʼñe ahuat̃ot̃en allempot̃eñ es yec̈hcatyes allempo yec̈hcatan ñam̃a asheñorr, yec̈hcatan ñam̃a peno. ");
INSERT INTO ameNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Allempo Yomporpaʼ atet̃ ot: “Ñeñt̃oʼmarña yacmapaʼ ñerraʼm esempoch senaʼta, coyaneshaʼpaʼ oʼch echan puerrollar, añ pocteʼ oʼhuañchaʼ tama yemteñet pamoʼmteʼ allochñapaʼ yacmapaʼ att̃ochña eʼñe parrocmat epuet puet̃apor. Att̃oña epsheñoʼmaretpaʼ eʼñech pat̃rra poʼchets penet.” ");
INSERT INTO ameNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Att̃ot̃chaʼña oʼhuañchaʼ puesheñaʼtetstet, allochñapaʼ oʼch eʼñe puesheñarratet. Ñeñt̃ att̃o Parets eʼñe pat̃rratatan yacma epuet puet̃apor amach c̈ha ellopaʼ alla sannerreto. ");
INSERT INTO ameNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ñetñapaʼ atet̃ otereterr: —Ñerraʼm poʼñoc̈h atet̃paʼ ¿esoʼmareʼtña nanña Moisés ñoñets all oteney oʼch yap̃ yet̃apor papell aquellcaret̃ att̃och yesannerra, allempoñapaʼ eʼñech pocteʼ oʼch yeser? ");
INSERT INTO ameNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ñañapaʼ atet̃ oterraneterr: —Sapaʼ ama es sec̈henoyo seyoc̈hro ñeñt̃oʼmarcaʼyeña Moiséspaʼ muenatas oʼch seseʼ set̃apor. Amaʼt atet̃ muenataseñpaʼ t̃arraña Yompor eʼñe ahuat̃ot̃eñpaʼ amacaʼyeña att̃eyeʼ oteno. ");
INSERT INTO ameNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Na t̃eʼpaʼ oʼch notas: Ñerraʼm eseshaʼ serreʼ puet̃apor, puet̃aporñapaʼ ñerraʼm ama c̈ho aguënano poʼpsheñeñ yacma, ñeñt̃ eʼñe att̃a serreʼ puet̃apor, ñañapaʼ c̈hach ochñaʼtam̃perrana puet̃aporesheʼmañ ñerraʼm oʼch alla yorerranerr poʼpoñ coyaneshaʼ. Ñeñt̃paʼ ama pocteyeʼ enteñe Yompor. Ñam̃a ñeñt̃chaʼ yorerreʼ coyaneshaʼ asaret̃, ñeñt̃ña yacmarpaʼ c̈hach chetapreten t̃aporets. Ñeñt̃paʼc̈hoʼña ama pocteyeʼ enteñe Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Pueyochreshaʼñapaʼ atet̃ ochet: —Ñerraʼm amat̃eʼ asapahuo yet̃apor amaʼt ahuat̃apaʼ amat̃eʼ tama pocteyayeña yocop oʼch yeyore coyaneshaʼ ñeñt̃chaʼ yet̃apor yep̃aʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ñañapaʼ atet̃ otanet: —T̃arraña atet̃paʼc̈hoʼña eʼñecaʼye pocteñ t̃arraña ama allohuenacmayeʼ c̈hennasoña seyoc̈hro atet̃ t̃arroʼmar ama allohuenacmayeʼ seyc̈henoña atet̃. Ñeñt̃paʼ aña eñoteneʼ ñeñt̃ atet̃ cot̃apeʼchaten Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ñehua, atet̃ ñerraʼm puesheñaʼtets yacma ñeñt̃ att̃a eñalletenet eʼñech att̃a yec̈hquënet poʼchets amach mueneñeto coyaneshaʼ. Ellonet̃paʼ eñall ñam̃a poʼpotantañ yacmaneshaʼ, ñetñapaʼ c̈hoch acaparet̃tenet ñeñt̃oʼmarña amach mueneñeto coyaneshaʼ. Ellonet̃paʼc̈hoʼña eñall ñam̃a poʼpotantañ yacmaneshaʼ, ñetñapaʼ añecpach ama mueneñeto coyaneshaʼ eshecchaʼ eʼñech aña maʼyoc̈hrenet Yomporecop att̃och atarr ayochreshat̃tena ña pueʼntañot̃. Ñeñt̃ atet̃ cot̃apeʼchenet Yomporecop ñeñt̃paʼ eʼñe pocteʼ. Att̃epaʼchña pet ñerraʼm Yompor cot̃apeʼchatenahuet atet̃. ");
INSERT INTO ameNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Allempoñapaʼ huac̈haʼtachet ñam̃a shonteʼ cheshat̃olleshaʼ Jesúsesho. Ñetpaʼ añecopña huac̈haʼtachet oʼch aʼp̃llaʼyesapanet Jesús att̃och bensareʼtam̃p̃sapanet. Jesúsña pueyochreshaʼ allempo entapan ñeñt̃ huac̈haʼtateʼ cheshaneshac̈hno ñetñapaʼ ama pocteyeʼ eñcheto oʼch anmoset cheshat̃olleshaʼ Jesúsesho ñeñt̃oʼmarña ama amnataret̃tapueto. ");
INSERT INTO ameNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","T̃arraña Jesúsñapaʼ atet̃ otanet: —Pocteʼñac̈hoʼ semnachñacaʼyeña cheshaneshaʼ onosetepaʼ eʼñe nesho. Amachcaʼye c̈ha sepatareʼtatstapaneto t̃arroʼmar allohuen ñeñt̃ atarr neyemtenaya na eʼñe att̃et ñerraʼmrrat̃eʼ cheshat̃oll, ñetchaʼ oʼpatenetña Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña pueʼntañot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Allempoña Jesúspaʼ aʼp̃llaʼyesapan cheshaneshaʼ allohuenet eʼñe puesheñaʼttset. Allempoñapaʼ ahuerr allot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Allempoñapaʼ huapa puesheñarr yacma Jesúsesho, ñeñt̃paʼ ora huepueshameñ. Ñañapaʼ atet̃ otos: —Maestro, p̃apaʼ atarr cohuen acheñrep̃, t̃eʼpaʼ oʼch p̃otapuen ¿errot̃enaʼtchaʼña nep̃aña na eʼñe cohuen att̃ochña napaʼ corretsanach eʼñe t̃ayot̃eñ amaʼt errponañohuen? ");
INSERT INTO ameNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesúsñapaʼ atet̃ otap̃: —Esoʼmareʼt p̃otenenña napaʼ atarroʼ cohuen acheñren. Arr arromñat̃eneshaʼ amaʼt eʼñe puesheñarrapaʼ ama eñalleña ñeñt̃ eʼñe cohuen acheñer. Ñapt̃aña Yompor ñeñt̃ eʼñe poʼñoc̈h cohuen. Ñerraʼm añt̃eʼ pemnen att̃och p̃apaʼ corretsap̃ach eʼñe t̃ayot̃eñ amaʼt errponañohuen añ poctetsa p̃ocop oʼch eʼñe pep̃ohuoñ ñeñt̃ atet̃ oten Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Huepueshaʼñapaʼ alla aʼp̃t̃oʼtererr: —¿Erraʼtsent̃eʼña ñoñets ñeñt̃chaʼ atet̃ nep̃ohua? Jesúsñapaʼ atet̃ otererr: —Ñeñt̃paʼ añcaʼye, amach pemtsatsto acheñ, amach pechtapretatsto t̃aporets, amach petyesatsto, amach petomaʼtam̃p̃satsche p̃amoʼts eʼñe att̃a. ");
INSERT INTO ameNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ñam̃a eʼñe pemorrenteñot̃paʼ pem̃chaʼnaʼchchaʼ p̃ompor ñam̃a p̃achor. Ñam̃a añchaʼ atarr cohuen pemorrenta p̃amoʼts eʼñe atet̃ atarr pemorrentena eʼñe p̃añeña. ");
INSERT INTO ameNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Huepueshaʼñapaʼ alla oterranerr Jesús: —Eʼñe cheshot̃eñ ora añec̈hnopaʼ napaʼ eʼñecaʼye netsotueñ. Taʼm ¿erraʼtsenmeñt̃eʼña ñeñt̃ nepalltena? ");
INSERT INTO ameNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesúsñapaʼ atet̃ otererr: —Ñerraʼm añ pemnen oʼch eʼñe petsotua ñeñt̃ pepalltenmeñ t̃eʼpaʼ añchaʼña atet̃ peperra, oʼch ahuerrep̃paʼ oʼch pepomhuerr ora allpon ñeñt̃ pechyen oʼch p̃apaʼyeraʼ huocchañneshac̈hno ñeñt̃ atarr es palltaʼyetsa, att̃ochña p̃apaʼ pecherrchaʼ ñeñt̃ atarr nanac sherbets Yompor pueʼntaño. Allempochña pehuerrapaʼ oʼch p̃oct̃erren att̃och eʼñe neyochreshaʼ neperrep̃ eʼñe poctacma. ");
INSERT INTO ameNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Oʼña eʼmhuan huepueshaʼ ñeñt̃ atet̃ och Jesúspaʼ ñañapaʼ puellquëñeshaʼ ahuerr t̃arroʼmar ñapaʼ shonteʼ esocmañen echyen. ");
INSERT INTO ameNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesúsñapaʼ atet̃ otan pueyochreshaʼ: —Poʼñoc̈h napaʼ oʼch notas: Ñeñt̃ atarr ec̃llayoret̃paʼ atarrcaʼye nanac echarr att̃och agapoñet Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña pueʼntañot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ñeñt̃paʼ atet̃chaʼ netmaʼntacha. Yapaʼ yeñoteñ berr añecmuen allpon ñerraʼm huaquësh atarrcaʼye t̃orrapoʼ oʼch eshoʼtosa añet̃ollponat̃ollo atet̃ ñerraʼmrrat̃eʼ acosh puetat̃ollo. Ñeñt̃paʼ atet̃caʼye penaña acheñ ñeñt̃ ec̃llayoret̃ ello atarr t̃orrapoʼ oʼch agapan ñam̃a Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña (t̃arroʼmar ñetpaʼ ama mueneñeto oʼch sehuanmuet ñeñt̃ atarr morrentenet ñet att̃och pueyochreshaʼ perranetañ Yompor). ");
INSERT INTO ameNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pueyochreshaʼña allempo eʼmet Jesús atet̃ oten, ñetñapaʼ c̈ha mueneʼ llecaʼrrtetpaʼ atet̃ otannaʼtyenet: —T̃arraña ñerraʼm atet̃t̃eʼpaʼ amat̃eʼ eseshaʼ aʼqueshp̃ataret̃terrtso amaʼt puesheñarra t̃arroʼmar yapaʼ yeñoteñcaʼye huaquëshpaʼ amacaʼ eshoʼtenoña acshequeto. ");
INSERT INTO ameNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Allempoña Jesúspaʼ att̃a cohuaʼyesanetpaʼ atet̃ oterraneterr: —Sa arromñat̃eneshaspaʼ amach es errot̃enayeʼ apen senteno. T̃arraña Yomporpaʼ ama eñalle ñocop ñeñt̃ atarr t̃orrapoʼ enten. ");
INSERT INTO ameNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Allempoña Pedropaʼ atet̃ och: —Partseshachaʼ, poʼñoc̈h yapaʼ oʼ eʼñe yesuanom ora allohuen att̃och eʼñe yoct̃errep̃. Yapaʼ ¿esoʼtchaʼña apuerreyña Yompor? ");
INSERT INTO ameNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesúspaʼ atet̃ otanet: —Poʼñoc̈h notenes, allempoch etserraterr pats allempoch nanorruerr neconaño allchaʼ necohuenetuerra nepartsoteñot̃ na Ñeñt̃en Acheñetosets sapaʼc̈hoʼña allchaʼ sanorryesuerr seconañec̈hno eʼñe puesheñaʼttsos c̈harraʼ puechena epa seconañ ñeñt̃es noct̃eneʼ. Sa ñeñt̃es noct̃eneʼ allchaʼ sanorryesos allot̃chaʼña saʼm̃chaʼtaret̃terraña añecop ñeñt̃ c̈harraʼ puechena epa Israel poʼm̃renñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Jesúspaʼ alla oterraneterr: —Allohuen erraʼtsenchaʼ acheñer ñeñt̃chaʼ eʼñe sehuanmueʼ allohuen amaʼt paʼpacllohuen, amaʼt paʼmoʼnasheñneshaʼ ñatoʼ poc̈haneshaʼ ñatoʼ pompor, pachor ñatoʼ poʼpatseñ, att̃ochña na eʼñech cohuen sherberrnet, amaʼt erraʼtsenchaʼ ñeñt̃chaʼ sehuanmueʼ allohuen, elloña ñetpaʼ oʼch alla aguërret shonteʼ esocmañen ñeñt̃ atarr cohuen. Amaʼt allponapaʼtets sehuanomyesnomuet, elloña c̈harrochchaʼ c̈harraʼ alla agapyerret. Elloña tsapat̃onet̃paʼ oʼch aguërret ñeñt̃ alloch ñetpaʼ corretsetach beñecpuen pocsheñeshocmañen. ");
INSERT INTO ameNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","T̃eʼpaʼ señochepaʼch, eñall shonteʼ acheñ ñeñt̃ ama esoyeʼ senteno sa t̃eʼ t̃arraña ñetña allempopaʼ atarrchaʼ asherben enterranet Yompor. Ñam̃a eñall shonteʼ acheñ ñeñt̃ atarr asherben sentyen sa t̃eʼ, t̃arraña ñetña allempopaʼ amach asherbenayeʼ enterraneto Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña pueʼntañot̃, ñeñt̃paʼ añ tomaʼntena ñeñt̃ atet̃ pena puesheñarr aneʼtañ. Ñañapaʼ ahuat̃ecma ahuaʼmuen eʼnyenayaʼ acheñ ñeñt̃chaʼ taruasat paʼmro oʼch t̃oteññañetaʼ puenarem̃. ");
INSERT INTO ameNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ñeñt̃ allpon entospaʼ atet̃ otosanet: “Amaʼt semno oʼch setaruasenaʼ naʼmro. Pamt̃aʼtetspaʼ netsaʼtasach allpon quelle ñeñt̃ pat̃err denario.” Ñetñapaʼ eʼñe pocteʼ eñchet allent̃a mueñanet paʼmro, allchaʼ t̃otoset narmetsmo. ");
INSERT INTO ameNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Oʼña enomeʼtaʼmuenpaʼ oʼ alla ahuerrerr allecma shontena acheñeneshaʼ ñeñt̃ eʼnyeneʼ taruas. Allñapaʼ entuerranerr tama allponsheña, ñetpaʼ ama es otteneto. ");
INSERT INTO ameNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ñañapaʼ atet̃ otosanet: “Sapaʼc̈hoʼña ñerraʼm semneʼpaʼ oʼch setaruasaʼ naʼmro; napaʼ netsaʼtasach allpon ñeñt̃ poctetsa.” Ñetpaʼc̈hoʼña allent̃a ahuanmuet paʼmro allchaʼ t̃otoset ñamet narmetsmo. ");
INSERT INTO ameNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Allempo c̈hap poctopaʼ alla ahuerrerr aneʼtañ, alla entuerranerr poʼpotantañ acheñ. Ñetpaʼc̈hoʼña att̃ecma otuerraneterr ñeñt̃ atet̃ otan ñorraʼ poʼpotantañ. Ñetpaʼc̈hoʼña allent̃a mueñerraneterr paʼmro allchaʼ t̃otoset ñamet narmets. Oʼña ellerrenmochpaʼ oʼ alla ahuerrerr, allñapaʼ entuerranerr poʼpotantañ acheñ. Ñetpaʼc̈hoʼña eʼñe att̃ecma otuerraneterr ñeñt̃ atet̃ otan ñorraʼ poʼpotantañ. Ñetpaʼc̈hoʼña allent̃a mueñerraneterr paʼmro. ");
INSERT INTO ameNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Att̃eña oʼ ellerrenpaʼ oʼ alla ahuerrerr, allñapaʼ entuerranerr poʼpotantañ acheñ, ñetpaʼc̈hoʼña ama es otteneto. Ñetpaʼc̈hoʼña atet̃ otuerraneterr: “Sapaʼ ¿esoʼmareʼtña att̃a sellapeneʼt̃ t̃omc̈haʼtyesetsña arrma? Amaña es sotteno.” ");
INSERT INTO ameNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ñetñapaʼ atet̃ ochet: “Yapaʼ amacaʼyeña eseshayeʼ yetaruasatenaye ñeñt̃oʼmarcaʼye ama es yotteno.” Ñañapaʼ atet̃ otanet: “Ñehua, sapaʼc̈hoʼña oʼch ahues naʼmro, amaʼt mameshapaʼ setaruasaʼnen. Napaʼ netsaʼtasach allpon ñeñt̃ poctetsa.” ");
INSERT INTO ameNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Oʼña puenasoʼtenpaʼ aneʼtaññapaʼ otosan ñeñt̃ cohuam̃peneʼ allohuen paʼtaruasañer: “T̃eʼpaʼ oʼch pec̈horeʼter ataruasañneshaʼ, oʼch petsaʼtyesapuerranet eʼñe puesheñaʼttsocmuet. Añchaʼ ñanom petsaʼtapuerra ñeñt̃ taruasosets chentaʼ allot̃eñach p̃amot̃ech tsaʼtyesapuerrahuet att̃ot̃ach petsaʼtuanet ora allohuenet amaʼt ñeñt̃ aromtañohuen.” ");
INSERT INTO ameNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ñeñt̃ña taruasosets ellerronet̃ ñetñapaʼ oʼ huac̈herret. Eʼñe allponeshacma atsaʼtaret̃etyesapuerret ñeñt̃ pat̃err denario. ");
INSERT INTO ameNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Att̃eña allempo oʼ huac̈herra ñam̃a ñeñt̃ taruasosets ahuat̃ecma, ñetñapaʼ c̈ha otenapuetañ ñatoʼ atonchaʼ atsaʼtaret̃tapuerret. T̃arraña ñetpaʼc̈hoʼña eʼñe puesheñaʼttsocmuetpaʼ eʼñe allponeshacma atsaʼtaret̃tapuerret ñeñt̃ pat̃err denario. ");
INSERT INTO ameNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Allempo agapetpaʼ ñetñapaʼ c̈ha poʼpoñ entet, c̈ha eʼmoñeʼtueret aneʼtañ. ");
INSERT INTO ameNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ñeñt̃oʼmarña atet̃ ochet: “Añeneshaʼ ñeñt̃ huapatsa chentaʼpaʼ ñetñapaʼ mamesha taruasoset. Eʼñe allponeshacma petsaʼtapuerranet ñeñt̃ eʼñe allpon petsaʼtapuerrya yam̃a. Amaʼt yapaʼ oʼ yellapen yaʼñetseʼ yetaruas, nanac etay atsrret̃ all yetaruasen. Esoʼmareʼtña eʼñe allponeshacma petsaʼtapuerrya ñeñt̃ allpon petsaʼtapuera ñam̃a ñeñt̃ taruasosets mameʼ.” ");
INSERT INTO ameNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Allempo atet̃ otuer ataruasañ, aneʼtaññapaʼ atet̃ och: “Ama, masheñchaʼ, c̈hoyeʼ neshquënpe, eʼñe allpona netsaʼtenp̃a ñeñt̃ allpon yaʼpoctataʼmuen aromtaña. ");
INSERT INTO ameNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","T̃eʼpaʼ p̃anerr pec̃llayor, orrerrep̃. Napaʼ eʼñe pocteʼ nenteñ na allponchaʼ netsaʼcha ñeñt̃ huapatsa chentaʼ allpon netsaʼtasa sam̃a. ");
INSERT INTO ameNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Sapaʼ amaʼt pocteyeʼ senteñe allpon ñeñt̃ eʼñe nocma napaʼ eʼñech atet̃ nepeʼ ñeñt̃ atet̃ nemnen na. Ñatoʼ t̃arroʼmart̃eʼ c̈ha mueneʼ seʼmoñeʼtenenñaʼ napaʼ atarrcaʼye amuerañan.” ");
INSERT INTO ameNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ñeñt̃oʼmar t̃eʼpaʼ oʼch noterrserr: Ñeñt̃ ama esoyeʼ senteno sa t̃eʼ t̃arraña ñetña allempopaʼ atarrchaʼ asherben enterranet Yompor. Ñeñt̃ña atarr asherben sentyen t̃eʼ, ñetña allempopaʼ amach tama asherbenayeʼ enterraneto Yompor. Ñeñt̃oʼmar t̃eʼpaʼ oʼch alla noterrserr: Amaʼt shonteñña ñam̃a ñeñt̃ ahuaʼñaret̃ ñeñt̃chaʼ neyochreshaʼ neperreñ, t̃arraña ñetpaʼ eʼñe puesheñaʼttseta ñeñt̃chaʼ eʼñe pocteʼ nenterr na ñeñt̃chaʼña eʼñe neyochreshaʼ neperr poctacma. ");
INSERT INTO ameNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesúspaʼ ahuenerr Jerusaléñonet̃ pueyochreshohuen. Oʼ ahuanenan pueyochreshaʼ aʼyent̃eyeʼ allñapaʼ atet̃ otnenanet: ");
INSERT INTO ameNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—T̃eʼ poʼñoc̈h oʼ ahueney Jerusaléño, allchaʼ pomataterrnet na Ñeñt̃en Acheñetosets. Añchaʼ nerrmaterreʼ ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar ñam̃a ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃. Ñetñapaʼ atet̃chaʼ otyesnet naʼmtsaret̃terrepaʼtoʼ, ");
INSERT INTO ameNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","oʼch pomuerrnet poʼpoñ acheñesho ñeñt̃ ama judioneshayaye. Ñetña puecheʼtatseteñot̃etanpaʼ allchaʼña achm̃areʼterrnet, ashterrnetchaʼ, att̃ot̃chaʼña oʼch corsoʼtam̃perrnet, t̃arraña pomaʼpamtañoch alla netanterra. ");
INSERT INTO ameNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Allempoñapaʼ ponmosya ñeñt̃ pachor pen Jacobo ñam̃a Juan ñeñt̃ Zebedeo puechemereshaʼ. Huapa epuet epsheñoʼmar puechoyor, ñañapaʼ concorpanaʼtosana Jesús att̃och es enamos. ");
INSERT INTO ameNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesúsñapaʼ atet̃ otap̃: —¿Esoʼtña pemnen? Ñapaʼ atet̃ otos: —Napaʼ añ nemnen t̃eʼpaʼ oʼch pemnatapon añ nechoyor epsheñoʼmar oʼch anorruerret pesho allchaʼ p̃aʼm̃chaʼtaret̃terra eʼñe pecohuenño. Puesheñarrpaʼ anorrosepaʼch pecohuenrot̃, poʼpsheñeññapaʼ anorrosepaʼch peʼchcot̃erot̃, allchaʼ cohuentapreterrpet. ");
INSERT INTO ameNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesúsñapaʼ atet̃ otanet: —Sapaʼ amacaʼye señoteñe ñeñt̃ poʼñoc̈h senamuenen. Añcaʼyeña senamuenen att̃och semueroc̈htapreterrna sam̃a. Taʼm ¿eʼñet̃eʼ poʼñoc̈h pocteʼ senteñ oʼch semueroc̈hterra sam̃a t̃arroʼmar napaʼ c̈hocmach naʼmueroc̈htataret̃terra? Ñeñt̃ mueroc̈hteñetspaʼ Jesúspaʼ atet̃ tomaʼntatanet ñerraʼmrrat̃eʼ atarr pesherr es yorren orram̃tso ñam̃a att̃o yapataret̃tena eʼñe atet̃ ñerraʼmrrat̃eʼ c̈ho yaʼmtsaret̃terra Yomporecop. Ñetñapaʼ atet̃ ochet: —Yapaʼc̈hoʼña atet̃chaʼcaʼye yepeʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ñañapaʼ alla oterraneterr: —Ñehua, poʼñoc̈hpaʼ saʼmueroc̈htataret̃terrach sam̃a att̃eschaʼ ñerraʼm na, saʼmtsaret̃terrach sam̃a. T̃arraña añña att̃och sanorryesos nesho necohuenrot̃ ñam̃a neʼchcot̃erot̃ allchaʼ secohuentapreterrna ñeñt̃paʼ amachcaʼye nayeʼ semnaterraye. Añchaʼña anorryesuerrets all ñeñt̃ eʼñe oʼpatatenna Nompor. ");
INSERT INTO ameNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Añña poʼpotantañ pueyochreshaʼ ñeñt̃ c̈harrasheña allempo eʼmet ñeñt̃ atet̃ enamuen Jacobo epuet paʼmoʼnasheñ Juan, ñetñapaʼ ama pocteyeʼ eñcheto c̈ha mueneʼ eʼmoñeʼchet. ");
INSERT INTO ameNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Allempoña Jesúspaʼ alla c̈horeʼterranet allohuen eʼñe ñesho ñeñt̃paʼ atet̃ otanet: —Sapaʼ señoteñt̃eʼ ñeñt̃ atet̃ pena poʼpoñ acheñeneshaʼ ñeñt̃ ama judioneshayaye. Ñet ñeñt̃ paʼm̃chaʼtaret̃er penet eʼñech paʼm̃chaʼnoc̈hteñocmañen pomnaren p̃aʼyenan allohuen pueyochreshac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Sapaʼ arepaʼchña att̃eyeʼ sep̃annaʼtatsto eʼñe sommoʼcheñot̃. Socoppaʼ añña poctetsa oʼch atet̃ sepena. Ñerraʼm erraʼtsenot̃es ñeñt̃es atarr am̃chaʼtaret̃oyen entetsañ ñeñt̃es acheñres socoppaʼ añ poctetsa oʼch atet̃ senterra ñerraʼm ama esosheʼmayayso ñeñt̃ atet̃ pena ñeñt̃ att̃a atarr taruasets poʼpotantañecop. ");
INSERT INTO ameNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ñam̃a ñerraʼm erraʼtsenot̃es ñeñt̃es mueneneʼ oʼch atarr asherben entenset ñeñt̃esña acheñrespaʼ añ poctetsa oʼch atet̃ senterra ñerraʼm ama esoyayso allochñapaʼ att̃ochña eʼñech cohuen set̃orrena poʼpotantañecop atet̃ ñerraʼmrrat̃eʼ acheñ ñeñt̃ atarr taruasets eʼñe att̃a. ");
INSERT INTO ameNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Atet̃ ñerraʼm na Ñeñt̃en Acheñetosets, napaʼ ama añecpayeʼ nehuapo añe patsro allochñapaʼ sapaʼ oʼch att̃a atarr sesherb̃apuen na atet̃ ñerraʼmrrat̃eʼ napaʼ atarr am̃chaʼtaret̃ sentenen. Napaʼ añecopña nehuapa allochñapaʼ nachña sesherb̃oseʼña sa, ñeñt̃oʼmarña napaʼ naña pomostsa nañeña oʼch nerromos socop att̃ochña netsaʼtuerrnasa soʼchñar ñeñt̃es shontes paʼnamen acheñres. Att̃ochña sapaʼ amach sañeña rromatso soʼchñarecop. ");
INSERT INTO ameNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Allot̃ñapaʼ alla meterreterr Jericót̃paʼ cot̃aʼhuanererr shonteʼ acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Allchaʼ oñmuetpaʼ allñapaʼ ahuepaʼt anorros epsheña aporoʼyet̃ eʼñe t̃oñetop̃ño. Ñetña eñotataret̃tet añ huetsa Jesús. Ñeñt̃ña aporoʼyet̃paʼ allent̃a rranareʼtapet Jesús, ñeñt̃paʼ atet̃ otapet: —Pemuerayeʼchnomya, Ayochreshat̃e, p̃apaʼ ñeñt̃ep̃ Davidnaʼtarep̃. ");
INSERT INTO ameNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Acheñeneshaʼñapaʼ c̈ha mueneʼ cheʼptareʼtnometña aporoʼyet̃, atet̃ otoset: —Oʼhua semma. Aporoʼyet̃ñapaʼ elloña alla rranareʼterreterr atet̃ otereterr: —Pemuerayeʼchnomyañacaʼye, Ayochreshat̃e, p̃apaʼ ñeñt̃ep̃ Davidnaʼtarep̃. ");
INSERT INTO ameNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesúsñapaʼ alla t̃omos oʼ c̈horeʼtanetpaʼ atet̃ otanet: —¿Esoʼtña semnen ñeñt̃chaʼ atet̃ nep̃oses? ");
INSERT INTO ameNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ñetñapaʼ alla otereterr: —Ayochreshat̃e, yapaʼ añ yemnen oʼch pecuatnomuey att̃och oʼch cohuen yenterrapa. ");
INSERT INTO ameNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesúsñapaʼ allent̃a muerosanet att̃oña ñapaʼ aʼp̃llaclleʼchosanet. Aʼp̃llaclleʼchuanetpaʼ aporoʼyet̃ñapaʼ allorocma enterret eʼñe cohuen. Eʼñe cohuerrtsetpaʼ c̈ha cot̃aʼnmuet ñamet Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Att̃eñapaʼ oʼ c̈hac̈haʼtet allameʼtets Jerusaléño. C̈hapuet aspent̃o ñeñt̃ paʼsoʼcheñ Olivopen. Allñapaʼ alloʼtsen anets ñeñt̃paʼ añ paʼsoʼcheñ Betfagé. Oʼña c̈hapmochet all anetso, ");
INSERT INTO ameNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Jesúsñapaʼ atet̃ otnoman epsheña pueyochreshaʼ: —Sapaʼ oʼch sota oʼch sec̈hap aʼyent̃eyeʼ eʼñe allara anetso. Allñapaʼ allchaʼ sentos ashen all huanquëñet epuet ñam̃a puechoyor ñeñt̃ rreʼptor. Ñeñt̃ña ashenpaʼ oʼch sepyam̃p̃sospaʼ oʼch sanerrnan. ");
INSERT INTO ameNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ñerraʼm eseshaʼ errot̃ sotapueʼ sañapaʼ atet̃chaʼ sotosanet: “Yepartsesharcaʼye mueneneʼña añ ashen. Mameshapaʼ oʼch alla apuerrsaʼ.” ");
INSERT INTO ameNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ñeñt̃paʼ t̃arroʼmar atet̃ p̃a allochñapaʼ att̃och etsota añ poʼñoñ ñeñt̃ aʼm̃tayeʼt̃ ahuat̃ Yompor poʼñoñ. Ñeñt̃paʼ Yompor eñoratayeʼt̃ atet̃: ");
INSERT INTO ameNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Atet̃chaʼ soch siónoʼmarneshaʼ ñeñt̃ara jerusaléñoʼmarneshaʼ: “Secueʼt̃ach, t̃eʼchcaʼyeña huaponasaña ñeñt̃chaʼ Saʼm̃chaʼtaret̃er seperr. Att̃o huena ñapaʼ amacaʼye pommoʼcheñot̃eyeʼ c̈hapoña all, ñeñt̃oʼmarña amaʼt rreʼptorechora ashenpaʼ ñeñt̃achcaʼye montaʼnena.” Arrpaʼ allohua huañ añ poʼñoñ ñeñt̃ aʼm̃tayeʼt̃ ahuat̃ Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Allempoña pueyochreshaʼña ñeñt̃ mueñapaʼ ñetñapaʼ allent̃a ahuanmuet all anetso. Eʼñe atet̃ otapanet Jesús, ñetñapaʼ eʼñec̈hoʼ atet̃ p̃oset. ");
INSERT INTO ameNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Allempoñapaʼ huapaterrñañet ashen epuet ñam̃a puechoyor. Ñetñapaʼ nohuerret paʼshtam ashnacheʼñopaʼ montatueret Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Shonteʼ acheñeneshaʼ ñetñapaʼ t̃ot̃maʼtyesoñet paʼshtam t̃oño allchaʼ oñem Jesús. Poʼpotantañec̈hnoñapaʼ tsorrmoʼreʼtyeset tsach pueʼmoʼrer allo topanetyeset t̃oñ. ");
INSERT INTO ameNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Allohuen acheñeneshaʼ ñeñt̃ otac̈hetsa ñam̃a ñeñt̃ cot̃aʼhuaneneʼ chentaʼ ñetñapaʼ puerrannarteñot̃etpaʼ atet̃ atarr cohuentatyesneññañetpaʼ atet̃ otenet: —¡Acsherrapoʼch allohueney! ¡Ayeʼchoc̈htaterrapoʼch Jesús ñeñt̃ am̃chaʼtaret̃ David poʼm̃reneñ! ¡Ayeʼchoc̈htaterrapoʼch Jesús ñeñt̃ llesensen Yompor! ¡Yaʼyeʼchoc̈htaterrñañepaʼch Yompor Parets ñeñt̃ pueʼntañoʼtsen! ");
INSERT INTO ameNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Att̃eñapaʼ oʼ c̈hap Jesús Jerusaléño. C̈hap allpaʼ allohuen anetsoʼmarneshaʼ epayeʼ cohuanrrortapet. Ñetñapaʼ atet̃ otyeset: —¿Eseshaʼt̃eʼña añ acheñer? ");
INSERT INTO ameNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Acheñeneshaʼ ñeñt̃ cot̃aʼneneʼpaʼ ñetñapaʼ atet̃ otoset: —Añcaʼyeña Jesús ñeñt̃ aʼm̃teneʼ Yompor poʼñoñ. Ñapaʼ Galileot̃caʼye huena allara anetso Nazareto. ");
INSERT INTO ameNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Allot̃ña Jesúspaʼ beʼt̃osos Parets paʼpacllo. Allñapaʼ mueñoʼtuosan allohuen ñeñt̃ pomatsreʼtetsa all ñam̃a allohuen ñeñt̃ rañt̃aʼyetsa. Eʼñe c̈haʼnmac̈haʼtatosanet allot̃, aʼcoyeʼtam̃p̃sosanet poʼmesac̈hno allecma cam̃yatyenet poʼc̃llayoret, aʼcoyeʼtuosan ñam̃a allecma anorryen ñeñt̃ pomueneʼ yepec̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Allempoñapaʼ atet̃ otosanet: —Yompor poʼñoñ ñeñt̃ atet̃ anuaret̃ ahuat̃ot̃eñ allñapaʼ atet̃caʼye oten Yompor: “Añ ñeñt̃ nepaquëll nepenpaʼ añecpacaʼyeña sherben allecmach maʼyochennet.” T̃arraña sañapaʼ eʼñe atet̃ sepeññañña Yompor paʼpaquëll ñerraʼmrrat̃eʼ eñet̃ ñeñt̃ epotyetsa mapuetpono. ");
INSERT INTO ameNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Allña Parets paʼpacllopaʼ huac̈haʼtoña aporoʼyet̃ec̈hno ñam̃a ñeñt̃ checaʼrepayets. Ñañapaʼ eʼñe aʼcrratyesapanet. ");
INSERT INTO ameNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Añña ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar epuet ñam̃a ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃, ñetñapaʼ entoñet ñeñt̃ atarr coc̈hneshaʼ atet̃ orrtatyen Jesús ñeñt̃ amaʼt eseshapaʼ ama puentareto. Ñam̃a eʼmueññañet cheshaneshaʼ all Parets paʼpacllo puerranarot̃etpaʼ atet̃ otyenet: —¡Ayeʼchoc̈htaterrapoʼch Jesús ñeñt̃ am̃chaʼtaret̃ David poʼm̃reneñ! Ñetña atet̃ entetpaʼ ñeñt̃epaʼtchaʼ atarr atsrreʼmatahuet. ");
INSERT INTO ameNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Allempoñapaʼ atet̃ ochet Jesús: —¿Amaʼt peʼmuenoña atet̃ otac̈hreʼtapap̃ cheshaneshaʼ? Jesúsñapaʼ otanet: —Neʼmueñcaʼye. Sañapaʼ amaʼt selleyareña Yompor poʼñoñ. All anaret̃ ñoñetspaʼ ñeñt̃ña atet̃ oten: Amaʼt cheshat̃olleshaʼ eʼñe puenamot̃et eʼñech cohuen peʼñoratos ac̈hotac̈hreʼteñtso. Amaʼt ñeñt̃ ora momuenmeñ peʼmorrtatoschaʼ eʼñe cohuen p̃ocop. ");
INSERT INTO ameNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Oʼña yerpatuerranet añ ñoñets ñeñt̃ atet̃ anaret̃ ahuat̃ot̃eñ ñocop, allempoña saʼnerranet ñeñt̃e anetsrot̃paʼ oʼ alla ahuerrerr Betanio. Allpaʼ allecma ommuena. ");
INSERT INTO ameNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tsapat̃ puetaren alla ahuaʼmuenerr Jesús anetso Jerusaléño. T̃oñoñapaʼ c̈ha cheporraʼnma. ");
INSERT INTO ameNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Allñapaʼ entnoman higoch t̃oñetop̃ñoʼtsen. Ponmosya ama entoñe pueʼmer, pasopanrepaʼtchaʼ entosñañ. Jesúsña c̈hepaʼtchaʼ eñorostsa higochecop, ñeñt̃paʼ atet̃ otos: —¡Arepaʼch eñalleterro pueʼmer amaʼt eʼñe ahuat̃a! Eʼñe otueʼpaʼ allorocmuepaʼtchaʼ hueyaʼhuaña pasopaner. ");
INSERT INTO ameNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pueyochreshaʼñapaʼ eʼñe enteñet oʼ hueyaʼhuaña higochpan. Ñetñapaʼ att̃a cohuanrrorteñet, atet̃ otannaʼtet: —Errot̃enot̃uañacaʼyeña oʼ aʼuyatachña eʼñe mamecmat̃eʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesúsña atet̃ otanet: —Poʼñoc̈hcaʼye oʼch notas: Ñerraʼm seyemteña Yompor, ama c̈hoyeʼ seʼcharrtateno seyoc̈her, amach añayaya atet̃ sep̃o atet̃ nep̃aʼ higoch. Añeʼnachña eʼñe setsoten ñeñt̃ ello atarr t̃orrapoʼ senten. Oʼch netmaʼntacha atet̃ ñerraʼmrrat̃eʼ añ aspenet̃. Ñerraʼm eseshaschaʼ otets aspent̃ecop, “Añ aspenet̃paʼ rrot̃eʼtepaʼch arrot̃, arrepaʼchña eshaʼtosa saʼpo allchaʼ eʼñe chencosa”, aspenet̃ñapaʼ atet̃chaʼc̈hoʼ p̃onasa. ");
INSERT INTO ameNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Amaʼt allohuen erraʼtsenchaʼ es senam̃ Yompor eʼñe semaʼyocheñot̃, ñerraʼm c̈ho senamueñ eʼñe seyemteñocmañen, ñeñt̃ñapaʼ sagap̃chaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Allempoña Jesúspaʼ oʼ alla c̈herrerr Jerusaléño, allñapaʼ beʼt̃osuerrerr Parets paʼpacllo. Allñapaʼ yec̈hatuerranerr acheñeneshaʼ. Att̃o yec̈hatenan acheñeneshaʼpaʼ allempoña huac̈haʼtoña ñam̃a ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar epuet puesheñaʼtets ñeñt̃ pomporneshaʼ pen allohuen judioneshaʼ. Ñetñapaʼ atet̃ otoset: —Ñehua, yapaʼ añecop yohuena yemneñ oʼch p̃otey ¿errot̃eʼt apuenpetña llesens? ¿Eseshaʼtña p̃apueneʼña llesens att̃ot̃ p̃orrtatyenña ñeñt̃ c̈hocma att̃ecma pep̃aʼyena? ");
INSERT INTO ameNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesúsñapaʼ atet̃ otapanet: —Ñehua, napaʼc̈hoʼña nemneñ oʼch naʼp̃t̃oʼtapas sam̃a amaʼt pat̃rra ñoñets. Ñerraʼm sanaposenchaʼpaʼ napaʼc̈hoʼña att̃ochña notapas nam̃a allot̃ apuennetña llesens ñeñt̃oʼmar atet̃ nepena. ");
INSERT INTO ameNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Sapaʼc̈hoʼña oʼch sotosen, ahuañmoʼcha allempo apateʼt̃ Juanañ Yomporecop, ñapaʼ ¿eseshaʼtña llesenseʼ ñatoʼ Yompor amapaʼ acheñat̃eʼ apueʼña llesens? Nemnen oʼch sotosen ñeñt̃ atet̃ soct̃apeʼchen sa. Ñetñapaʼ eʼñe aʼnahua otannaʼtyeset: —Taʼm errot̃chaʼcaʼye yocht̃eʼ. Ñerraʼm c̈ha yoch Yomporeshot̃caʼye apetña llesens, ñapaʼ c̈hat̃eʼcaʼye otey: “Ñehua, sañapaʼ esoʼmareʼtña ama seʼm̃ñocheña ahuaña allempo serrpareʼtatosan acheñeneshaʼ.” ");
INSERT INTO ameNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Elloña ñerraʼm c̈ha yoch acheñeshot̃a apet llesenspaʼ acheñeneshaʼñapaʼ c̈hat̃eʼ eʼmoñeʼtyet, t̃arroʼmar ñetpaʼ eʼñe cohuen eñcheteʼt̃ Juanañ, c̈hocma otyeñet ñapaʼ ñeñt̃caʼyeña aʼm̃toseʼ Yompor poʼñoñ. Ñeñt̃oʼmarña ñetpaʼ mechaʼteñet acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ñeñt̃oʼmarña ñetpaʼ atet̃ ochet Jesús: —Taʼm yapaʼ amacaʼyeña yeñoteñe; errot̃t̃eʼ huapaña Juanañ, errot̃t̃eʼ apetña ñam̃a llesens. Allempoña Jesúspaʼ atet̃ oterraneterr: —Napaʼc̈hoʼña t̃eʼpaʼ amach notaso sam̃a allot̃ aparet̃en nam̃a llesens att̃ot̃ atet̃ nep̃aʼyena. ");
INSERT INTO ameNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","32","Jesúsñapaʼ alla oterranerr judioneshaʼ paʼm̃chaʼtaret̃erneshaʼ: —Ahuañmoʼcha allempo huapa Juanañ, ñapaʼ añecop huapa att̃och ñach seyc̈haterreʼ allohuen ñeñt̃ eʼñe pocteʼ enten Yompor. T̃arraña sañapaʼ ama sameʼñyo. Aña eʼñe cohuen ameʼñapaya ñeñt̃ atarr ochñat̃eneshac̈hno atet̃ ñerraʼm añ ñeñt̃ poʼtaruas p̃aʼyeneʼ eʼñe pueshquëñot̃et cobraʼyeñet acheñeneshac̈hno quelle ñeñt̃ gobiernocop ñam̃a aña eʼñe cohuen ameʼñapayaña Juanañ ñeñt̃ atarr ecañoreshat̃ec̈hno. Allempo sentanet att̃o ñetpaʼ cot̃apeʼcherret ello cohuen Yomporecop, sañapaʼ amaña eseshas cot̃apeʼcherrayeña cohuen Yomporecop att̃och oʼch sameʼñera sam̃a. Ñeñt̃ña t̃eʼpaʼ oʼch netmaʼntacha. Ñehua, puesheñarr yacma eñall epsheña puechemer. Ñañapaʼ atet̃ otenanaʼ puesheñarr puechemer: “T̃eʼpaʼ nechemere, oʼch ahuaʼmuenep̃ yaʼmro allchaʼ petaruasaʼmuen.” Ñañapaʼ ellont̃a otapan pompor: “Amacaʼye nemno, amachcaʼye neto.” T̃arraña elloñapaʼ cot̃apeʼcherran cohuen allempoñapaʼ ahuoʼ pompor paʼmro taruasats. Allempoña pomporpaʼ ahuoʼ ñam̃a poʼpsheñeñ puechemeresho, ñapaʼc̈hoʼña atet̃ otos atet̃ otuan poʼpsheñeñ puechemer: “T̃eʼ nechemere, oʼch ahuaʼmuenep̃ yaʼmro allchaʼ petaruasaʼmuen p̃am̃a.” Ñañapaʼ eʼñe cohuen otapan pompor: “Ñehua, apachaʼ oʼch ahuen oʼch netaruasaʼmuen yaʼmro.” T̃arraña ñañapaʼ amaʼt atet̃ otañpaʼ ama to. Jesúsñapaʼ alla oterraneterr: —T̃eʼpaʼ oʼch naʼp̃t̃oʼtas sa, ñeñt̃ epsheña puechemer, ¿erraʼtsenaʼt sentenña sa ñeñt̃ eʼñe poʼñoc̈h atet̃ petsa ñeñt̃ atet̃ muenen pompor? Judioneshaʼña paʼm̃chaʼtaret̃erneshaʼpaʼ ñetñapaʼ atet̃ ochet: —Añcaʼye ñeñt̃ ñanom, ñeñt̃ otapueʼ ñapaʼ añoʼch to taruasats t̃arraña elloñapaʼ allent̃a ahuoʼ taruasats paʼmro. Ñeñt̃caʼyeña etsoteneʼña ñeñt̃ atet̃ muenen pompor. Jesúsñapaʼ atet̃ oterraneterr: —Ñeñt̃oʼmarña t̃eʼpaʼ oʼch notas: Ñeñt̃ pueshquëñot̃eʼna cobraʼyeneʼ acheñeneshac̈hno ñam̃a ñeñt̃ atarr ecañoreshat̃ec̈hno, ñetñapaʼ poʼñoc̈h allent̃a aguërret Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña. Sañapaʼ amaña allent̃ayeʼ saguëreña sam̃a t̃arroʼmar sapaʼ c̈haña atarr seʼcharrtatenña seyoc̈her. ");
INSERT INTO ameNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesúsñapaʼ alla oterranerr judioneshaʼ paʼm̃chaʼtaret̃erneshaʼ: —T̃eʼñapaʼ seʼm̃ñotenchaʼ, napaʼ oʼch netmaʼntatasa poʼpoñ. Eñall puesheñarr aneʼtañ, ñañapaʼ nareʼtanatatnoman shonteʼ uvach; paʼmuerñapaʼ eʼñe ora uvachmatatue. Eʼñe conc̈haʼtam̃pesue allot̃ñapaʼ eñan ñam̃a allchaʼ aʼpechoʼtoñet uvas poʼñer. Allñapaʼ t̃omatatnoman torrepoʼ allot̃chaʼ cohuam̃p̃soñet paʼmuer. ’T̃omatuepaʼ naʼnman ñeñt̃chaʼ taruasatats ñeñt̃chaʼ coyerrahuet allpon ñerraʼm esempoch t̃oteñet. Oʼña nareʼtanatatuepaʼ oʼ ahuoʼ poʼpoñ anetso b̃ac̈hayo. ");
INSERT INTO ameNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","C̈hap allempo yen uvachllom̃paʼ ñañapaʼ mueñerran poʼpsheññec̈hno paʼtaruasañer ñetchaʼ enamuerrtsetaʼ uvachllom̃ poʼpsheñeñ paʼtaruasañresho ñeñt̃ cohuam̃peneʼ uvachmaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Allempoña c̈henet allpaʼ enamosan ñeñt̃ allpon oʼpatena pamoʼmteʼ, arepaʼtchaʼña es apapuenayeña uvachllom̃, elloña ñeñt̃apaʼ c̈ha rremapoñet paʼtaruasañer, c̈ha nalleʼtapueñet puesheñarr, c̈ha muetsapet poʼpsheñeñ, poʼpsheñeñpaʼc̈hoʼña c̈ha rrolleʼtapoñet. ");
INSERT INTO ameNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Allempoña ñeñt̃ pamoʼmteʼ pen uvachmaʼpaʼ oʼ alla mueñerranerr poʼpsheññec̈hno paʼtaruasañer shonteʼ. Allempo c̈hapuet ñamet allpaʼ att̃ecma errot̃uanen ap̃aret̃tapuet ñamet. ");
INSERT INTO ameNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Allempoña ñeñt̃ pamoʼmteʼ penetpaʼ ñañapaʼ atet̃ ot: “T̃eʼpaʼ oʼch nemñe all ñeñt̃ eʼñe na nechemer. Ñatoʼrraña ñeñt̃paʼ mechaʼnaʼtapetchaʼ.” ");
INSERT INTO ameNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ñeñt̃paʼc̈hoʼña amaʼt mameshapaʼ arepaʼtchaʼña mechaʼnaʼtapeto. Allempo entapoñet puechemer ñetñapaʼ atet̃ otannaʼtyeset: “Añmapaʼ ñeñt̃caʼyeña puechemer ñeñt̃chaʼ oʼpaterraya pompor puenarem̃ esempo. Ñapaʼc̈hoʼña t̃eʼpaʼ oʼchcaʼye yemtsap̃ allochñapaʼ yachcaʼyeña eʼñe oʼpaterrayaña pompor puenarem̃. T̃eʼpaʼ oʼch ahuey oʼch yemtsap̃ ñam̃a.” ");
INSERT INTO ameNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Allempoñapaʼ oʼ rromapet oʼ chetareʼtnomet narmetsmot̃ aʼyenet̃, allña muetsapetña ñam̃a. Arrpaʼ allohua atet̃ tomaʼntata Jesús eʼñe ñañeña. ");
INSERT INTO ameNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Allempoña Jesúspaʼ atet̃ oterraneterr: —Ñehua, ñerraʼm esempoch huerra ñeñt̃ pamoʼmteʼ pen ataruasañec̈hnopaʼ ¿señoteñeʼtña ñetpaʼ atet̃chaʼ ap̃aret̃terret? ");
INSERT INTO ameNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Judioneshaʼña paʼm̃chaʼtaret̃erneshaʼpaʼ atet̃ oterreterr: —Ñerraʼm huerrachpaʼ ñeñt̃ña ama matsrreʼmñopaʼ eʼñech aʼcllatuerranet pamoʼmteʼ, nanacchaʼ coñchatuerranet; narmetsmoñapaʼ elloch nerranerr poʼpotantañ ñeñt̃chaʼ taruaserrtserr all uvachmo. Nerranerrchaʼ ñeñt̃chaʼ eʼñe poʼñoc̈h apuerreʼ pueʼmer ñerraʼm esempoch yen. ");
INSERT INTO ameNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Allempoña Jesúspaʼ atet̃ oterraneterr: —Sapaʼ amaʼt ahuat̃apaʼ amaʼtña selleyareña ñeñt̃ atet̃ anuaret̃ Yompor poʼñoñ ahuat̃ot̃eñ. T̃arroʼmar ñeñt̃paʼ atet̃ oten nocop, na atmaʼntataret̃ mapueʼ. Ñeñt̃paʼ atet̃ oten: Añ mapueʼ ñeñt̃ ama pocteyeʼ entyeno ñeñt̃ t̃omatyeneʼ pocoll, ñeñt̃ña t̃eʼpaʼ oʼ anaret̃terra ñeñt̃chaʼ ello atarr cohuen sherberrets eʼñe atet̃ ñerraʼm quellpach allo eʼñe cohuen echarr orratenet pocoll. Ñeñt̃paʼ Yomporcaʼyeña atet̃ p̃ateneʼ, ñeñt̃oʼmarña yapaʼ eʼñe cohuen yenteñ. Arrpaʼ allohua atet̃ tomaʼntaterrerr Jesús eʼñe ñañeña. ");
INSERT INTO ameNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ñeñt̃oʼmarña sa ñeñt̃es judioneshaspaʼ t̃eʼña Yomporpaʼ puerratam̃perreschaʼ poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña. Añchaʼña apuerr ellonet̃ poʼpotantañ acheñeneshaʼ ñeñt̃ ama judioneshayaye ñeñt̃chaʼ poʼñoc̈h orrtaterreʼ eʼñe ña poʼcohuenña att̃o atarr ayochreshat̃tena ña. ");
INSERT INTO ameNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Allohuen erraʼtsenchaʼ atetsa añ mapyo ñeñt̃ña mapueʼpaʼ eʼñech aʼyosatseʼtuanet. Ñam̃a ñerraʼm eseshesho shoraʼnom ñeñt̃ mapyerpaʼ eʼñech aʼpep̃tseʼtuosanet. Att̃oña Jesúspaʼ tomaʼntatanet ñerraʼm ama eseshaʼ pocteyeʼ entenaye Cristo ñerraʼm erraʼtsenchaʼ ama aguërraye, ñeñt̃ña acheñerpaʼ c̈hocmach huapoña ñeñt̃chaʼ atarr mueroc̈htaterrahuet. ");
INSERT INTO ameNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Allempo atet̃ eʼmyes ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar ñam̃a fariseoneshaʼ, ñeñt̃ atet̃ tomaʼntatenanet Jesús, ñetña allempopaʼ c̈hapanet pueyoc̈hreto ñocpuetepaʼt serrpareʼtenña Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ñetñapaʼ mueneñetañ oʼch rremuetañ t̃arraña ama eseshaʼ rromaye t̃arroʼmar ñetpaʼ c̈ha mechaʼteñet acheñeneshaʼ. Ñehua, acheñeneshaʼ eʼñecaʼye cohuen enteñet Jesús ñapaʼ poʼñoc̈h ñeñt̃ aʼm̃teneʼ Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesúsñapaʼ alla tomaʼntaterraneterrpaʼ atet̃ oterraneterr: ");
INSERT INTO ameNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña pueʼntañot̃ ñeñt̃paʼ oʼch netmaʼntacha atet̃ ñerraʼmrrat̃eʼ puesheñarr am̃chaʼtaret̃. Ñeñt̃ña am̃chaʼtaret̃paʼ oʼ puetareʼtatan shonteʼ rreñets ñeñt̃chaʼ nanac rret allempoch senaʼta puechemer. ");
INSERT INTO ameNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Oʼña aʼpotatuan rreñetspaʼ oʼ mueñan paʼtaruasañreneshaʼ oʼch otyeñetaʼ ñeñt̃ ahuaʼñaret̃ oʼch rrapretenetaʼ rreñets. Oʼña otyesuaret̃tetpaʼ ñetñapaʼ arepaʼtchaʼ eseshayeʼ sechatso oʼch ahuet all. ");
INSERT INTO ameNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Poʼpocheñopaʼ oʼ alla mueñerranerr poʼpotantañ paʼtaruasañreneshaʼ. Ama senetaʼpaʼ atet̃ otapanet: “Sotoschaʼ acheñeneshaʼ ñeñt̃ ahuaʼñaret̃: ‘Am̃chaʼtaret̃caʼye sagotateneʼ, atet̃caʼye oten: Rreñetspaʼ oʼ eʼñe naʼpotatue. Huacshec̈hno ñam̃a beserec̈hno ñeñt̃ neʼsoyaʼtatyen oʼ eʼñe nemtsatue ñam̃a oʼcaʼye eʼñe naʼpotatue. T̃eʼpaʼ sonac̈haʼtepaʼtoʼ ahuoʼch serrapreteñaʼ.’ ” ");
INSERT INTO ameNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ahuaʼñaret̃neshaʼñapaʼ arepaʼtchaʼ aʼcuaʼpsenayeʼ eñchetoña ñeñt̃ huaʼñenahuet. Ñeñt̃apaʼ ahuanemyeset ñopaʼtets. Puesheñarrpaʼ ahuoʼ paʼmro, poʼpsheñeñpaʼ ahuoʼ pomatsreʼtatsa. ");
INSERT INTO ameNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Poʼpotantaññapaʼ ñeñt̃apaʼ oʼ rremapoñetña paʼtaruasañreneshaʼpaʼ errot̃uanen pet, att̃eñapaʼ oʼ muetsanatuet. ");
INSERT INTO ameNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Am̃chaʼtaret̃ñapaʼ ñeñt̃ña atarr atsrreʼmateʼ. Allempoñapaʼ oʼ mueñan ñam̃a poʼsolltar-reneshaʼ ñeñt̃chaʼ aʼcllatenayaʼ ñeñt̃ amtsañec̈hno, ñeñt̃chaʼ aʼpoyatatuenayaʼ ñam̃a paʼnetser. ");
INSERT INTO ameNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Allot̃ña am̃chaʼtaret̃paʼ atet̃ oterranerr poʼpotantañ paʼtaruasañreneshaʼ: “Rreñtsoc̈hnoña poʼñoc̈hpaʼ epayeʼcaʼye. T̃arraña ñeñt̃ña ahuaʼñaret̃paʼ ñetpaʼ amacaʼye cohuenayeʼ nentenaneto. ");
INSERT INTO ameNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","T̃eʼpaʼ orras sam̃a alloʼtsen t̃oñec̈hno t̃arroʼmar allpaʼ shonteʼ chopeñeʼchyen acheñeneshaʼ. Allohuen errponchaʼ sentyes oʼch sotyesapanet onetepaʼ arr oʼch rrapretennetaʼ rreñets ñeñt̃ shonteʼ naʼpotaten.” ");
INSERT INTO ameNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Allempoña alla ahuanerrerr paʼtaruasañreneshaʼ, ñetñapaʼ añ cot̃aʼyeset t̃oñ. Ñeñt̃ allpon poctaʼyeset t̃oñoʼmar eʼñe sechatyesuahuet, amaʼt atsrreʼmñat̃ec̈hno ñam̃a ñeñt̃ cohuen acheñ. Att̃eñapaʼ oʼ c̈ha shontosa ñeñt̃ huaʼñenet. Allña pocollo all senaʼtena puechemerpaʼ eʼñe quec̈hcosa ñeñt̃ ahuaʼñaret̃. ");
INSERT INTO ameNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Am̃chaʼtaret̃ñapaʼ allent̃a beʼt̃os oʼch entapan ñeñt̃ huaʼñatyen ñeñt̃chaʼ rrallmeʼchosets all. Allñapaʼ entan puesheñarr yacma. Ñañapaʼ ama añeyeʼ chorreno shetamuets emarr ñeñt̃ecma chorrenet all att̃o coshapreteñet ñeñt̃ senaʼtetsa. ");
INSERT INTO ameNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Am̃chaʼtaret̃ñapaʼ atet̃ och: “Esoʼmareʼtña masheñe pebeʼt̃enña arr amacaʼye añeyeʼ pechorreno shetamuets emarr att̃och p̃ocshaprecha ñeñt̃ senaʼtetsa.” Ñañapaʼ ama eñoro. ");
INSERT INTO ameNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Allempoña am̃chaʼtaret̃paʼ otan paʼtaruasañreneshaʼ: “Sehuancoñ paʼtac ñam̃a potpaʼ c̈hosa huaporeʼterreʼ aʼyot̃ checmetot̃. Allñapaʼ allchaʼ yahuanrrorterret, panmueñot̃et atserrpaʼ rrasoʼtyerretchaʼ paʼs.” ");
INSERT INTO ameNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","T̃arroʼmar amaʼt shonteñña ñeñt̃ ahuaʼñaret̃paʼ t̃arraña puesheñaʼttsaña ñeñt̃ eʼñe cohuen aʼcraret̃. ");
INSERT INTO ameNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Allempoña fariseoneshaʼpaʼ ahuanerra. Ñetñapaʼ c̈ha atarr cot̃apeʼchatannaʼtenetaʼ. Ñetpaʼ aña atarr eʼnenet att̃och eʼñe pueshquëñot̃etpaʼ amaʼt parrochapaʼ oʼch eñorachet Jesús ñeñt̃ ama pocteyaye. Allochñapaʼ att̃ot̃chaʼña otteñeʼchet. ");
INSERT INTO ameNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ñetñapaʼ eʼñe aʼnahua mueñet ñet pueyochreshaʼ epuet ñam̃a puesheñaʼtets Herodes pueyochreshaʼ. Ñetña c̈hapuet Jesúseshopaʼ eʼñe pueshquëñot̃et atet̃ otoset: —Maestrochaʼ yapaʼ yeñotenep̃ p̃apaʼ ama peshquëno amaʼt mamesha ñam̃a ñeñt̃ att̃o peyc̈haten Yompor poct̃ap̃ña ñeñt̃paʼc̈hoʼña eʼñe cohuenacma, ama shequëñtsoyaye amaʼt mamesha. Ñam̃a p̃apaʼ ama aña ñapuet̃ pemorrenteno ñeñt̃ atarr am̃chaʼnaʼtpoʼ entyen allohuen acheñeneshaʼ. Allohuen acheñ eʼñe cohuen pentueñ. ");
INSERT INTO ameNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ñeñt̃oʼmarña t̃eʼpaʼ yapaʼ yemneñ oʼch peñotatapuey erraʼtsent̃eʼña eʼñe poʼñoc̈h cohuentetsa. ¿Pocteʼt̃eʼ penteñña p̃a oʼch yetsaʼta impuestos añecop ñeñt̃ am̃chaʼtaret̃tetsa all anetso Romo ñeñt̃ ama judioneshayaye? Ñatoʼ amat̃eʼ pocteyayeña yocop ñeñt̃ey judioneshay oʼch yetsaʼcha am̃chaʼtaret̃ romoʼmarneshaʼ ñeñt̃ ama judioneshayaye. ");
INSERT INTO ameNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesúsñapaʼ eñotapanet ñeñt̃ atet̃ cot̃apeʼchyenetañ ñocop, ñañapaʼ atet̃ otanet: —Sapaʼ atarr ashcarñat̃es, esoʼmareʼtña semneñña oʼch seshcareʼtenen. ");
INSERT INTO ameNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ñehua, amaʼt att̃eseñpaʼ segatencaʼye puetallarr quelle ñeñt̃ alloch setsaʼta impuestos. Allempoñapaʼ gachet puetallarr quelle ñeñt̃ otenet denario. ");
INSERT INTO ameNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ñañapaʼ atet̃ oterraneterr: —Ñehua, sapaʼ oʼch soten, ¿eseshaʼt sentenña ñeñt̃ atmaʼntaret̃tetsa all? ¿Eseshaʼt paʼsoʼcheñ aquellcaret̃tetsa all? ");
INSERT INTO ameNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ñetñapaʼ atet ochet: —Am̃chaʼtaret̃caʼye atmaʼntaret̃tetsaña all, ñam̃a ñocaʼyeña paʼsoʼcheñ ñeñt̃ aquellcaret̃tetsa all. Jesúsñapaʼ alla oterraneterr: —Ñeñt̃epñapaʼ añ poctetsa oʼch yap̃ am̃chaʼtaret̃ ñeñt̃ ño ñeñt̃ atet̃ poctetsa gobiernocop, t̃arraña ellonet̃ña ñeñt̃ Yomporo oʼch yap̃ ñam̃a ñeñt̃ atet̃ poctetsa ñocop. ");
INSERT INTO ameNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ñetña atet̃ eʼmueñet Jesús atet̃ anapuenanetpaʼ att̃a cohuanrrorteñet t̃arroʼmar Jesúspaʼ atarrcaʼye cohuen anapuenanet. Att̃eñapaʼ quec̈hpaʼhuaneretpaʼ ahuanerret. ");
INSERT INTO ameNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ñeñt̃e yet̃rocma huac̈haʼtoña ñam̃a patantarr ñeñt̃ saduceoneshatets. Ñehua, ñeñt̃ saduceoneshatets ñetñapaʼ ellonet̃ echenet poct̃ap̃ña ñeñt̃oʼmarña ñetpaʼ atet̃ otenet amat̃eʼ errot̃enot̃ yetanterroña rromot̃ amaʼt errponaña. Ñetñapaʼ atet̃ otoset Jesús: ");
INSERT INTO ameNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Añ Maestrochaʼ ñeñt̃caʼyeña atet̃ otyeʼt̃ña Moisés ñeñt̃ poctetsa ñeñt̃chaʼ atet̃ yep̃a. Ñerraʼm esempo rroma yacma oʼch saʼnman puet̃apor t̃arraña ñerraʼm ama chemereʼtnomopaʼ, añ poctetsa paʼmoʼnasheñchaʼ alla yorerreʼña poʼnorrar allochñapaʼ att̃och eñalleterraña ñeñt̃chaʼ puechemer perr paʼmoʼnasheñeñ. Ñeñt̃paʼ atet̃caʼye quellcaʼnmonayña ahuat̃ Moisés. ");
INSERT INTO ameNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ñehua, t̃eʼpaʼ eñall canc̈herrsheña yamoʼts ñeñt̃ eʼñe poctacma paʼmoʼnasheñecmuet. Ñeñt̃ puesheñarr popoʼnaretpaʼ oʼ yoran coyaneshaʼ ñeñt̃ puet̃apor p̃aʼ. Eʼñe allponmatatsapaʼ oʼ rroma, att̃a saʼnman puet̃apor ama chemereʼtnomo. Allempoña ñeñt̃ poʼrroc̈hoʼmerpaʼ oʼ yorerran paʼmoʼnasheñeñ puet̃apor. ");
INSERT INTO ameNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Eʼñe allponmatatsapaʼ ñapaʼc̈hoʼña oʼ rromuerrerr ñam̃a, ñeñt̃paʼc̈hoʼña ama chemereʼtnomo. Allempoña poʼpsheñeñ paʼmoʼnasheñpaʼ oʼ alla yorerranerr ñam̃a poʼnorrar. Eʼñe allponmaterrtsapaʼ ñapaʼc̈hoʼña oʼ rromuerrerr ñam̃a, ñeñt̃paʼc̈hoʼña ama chemereʼtnerrerro oʼ att̃a rromuerrerr. Eʼñe att̃ecma p̃ohuet canc̈herrsheñoʼmaretpaʼ eʼñe pueyoruarochetña ñeñt̃ara puesheñarr coyaneshaʼ. Allohuenetpaʼ eʼñe att̃ecma pet rromayestset amaʼt puesheñarrot̃etapaʼ amacaʼyeña chemereʼtnomueto. ");
INSERT INTO ameNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Allempoñapaʼ c̈ho rromatsña ñam̃a coyaneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","T̃eʼña ñerraʼm poʼñoc̈ht̃eʼ atanterrapoʼ rromot̃paʼ añña coyaneshaʼñapaʼ allempopaʼ ¿eseshaʼtchaʼña eʼñe ñapuet̃ puet̃apor perreʼ t̃arroʼmar allohuenet canc̈herrsheñoʼmaretpaʼ eʼñecaʼye pueyoruarochet? ");
INSERT INTO ameNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesúsñapaʼ atet otapanet: —C̈hacaʼye atarr sepanteñ t̃arroʼmar amacaʼye c̈hennasoña seyoc̈hro ñeñt̃ eʼñe poʼñoc̈h atet̃ yec̈hateney Yompor poʼñoñ ñeñt̃ atet̃ anuaret̃ ahuat̃ot̃eñ. Ñam̃a aña sepantateneʼ t̃arroʼmar sapaʼ ama sepocteññañe Yompor poʼhuamenc. ");
INSERT INTO ameNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","T̃arroʼmar esempohuañen allempoch tanterret poʼpocheño, allempopaʼ amaʼt puesheñarrot̃eta amach senaʼterreto, amaʼt coyaneshaʼpaʼc̈hoʼ amach eseshayeʼ apuerraye ñeñt̃chaʼ yorerrahuet. T̃arroʼmar allempopaʼ eʼñech att̃et ñerraʼm Yompor poʼm̃llañot̃eñnaneshar ñeñt̃ pueʼntañoʼtsaʼyen. ");
INSERT INTO ameNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Sapaʼ amaʼtña selleyare ñeñt̃ atet̃ oteʼt̃ ahuat̃ Yompor eʼñe socop att̃och señoch poʼñoc̈hpaʼ amaʼt ñeñt̃ oʼ collaʼhuapaʼ ñetñapaʼ corretseta. ");
INSERT INTO ameNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ñehua, ñeñt̃paʼ atet̃ oteney Yompor: “Napaʼ na ñeñt̃en Poʼyomporer pen Abraham ñam̃a Isaac ñam̃a Jacob amaʼt ñetpaʼ oʼ rromhuet ahuat̃ot̃eñ.” Ñehua, yapaʼ yeñoteñ Yomporpaʼ ama añeyeʼ Poʼyomporer penaye ñeñt̃ rromuets eʼñe poctacma, ñapaʼ añcaʼyeña Poʼyomporer peneʼ acheñ ñeñt̃ corretsetach. Att̃oña Yomporpaʼ eʼñe allameʼttsa entenanet allohuen ñetñapaʼ eʼñe bet̃tetseta. ");
INSERT INTO ameNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Allempoña allohuen acheñeneshaʼ ñeñt̃ eʼmueneʼ Jesús att̃o emmaʼhuan saduceoneshaʼ, ñetñapaʼ atet̃ otannaʼtyeset: —¡Errot̃enot̃uañacaʼyeña atarr es eñoten, att̃o atarr cohuen yec̈hatyeney! ");
INSERT INTO ameNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ñam̃a allempo fariseoneshaʼ eʼmareʼchet att̃o Jesús emmaʼhuan saduceoneshaʼ ñetñapaʼ apc̈hannaʼtet parro. ");
INSERT INTO ameNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Allempoña puesheñarrot̃et ñeñt̃ atarr etsoteneʼ ñoñets ñeñt̃ atet̃ anaret̃ ñañapaʼ otenanaʼ Jesús. Ñeñt̃paʼ t̃arroʼmarña atet̃ aʼp̃t̃oʼtos ñetpaʼ c̈hocaʼye mueneñet oʼch topachet Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ñeñt̃paʼ atet̃ otos: —Maestrochaʼ ¿erraʼtsenaʼt ñoñtsor ñeñt̃ atet̃ anaret̃ ñeñt̃ atarr sherbets ñeñt̃ ello metanaʼtueneʼ ora allohuen poʼpoñec̈hno ñoñets ñeñt̃ eʼñe parro att̃ecma anaret̃? ");
INSERT INTO ameNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesúsñapaʼ atet̃ otap̃: —Añcaʼyeña ñeñt̃ ello atarr sherbets, ñeñt̃ ñoñetspaʼ atet̃ oten: “Atarrepaʼch yemorrenteña Yeyomporer ñeñt̃ Yepartseshar yepen eʼñe ora yeyoc̈hrocmañen. Ñam̃a eʼñe yecamquëñot̃ yemorreñchach, amaʼt ñam̃a ora yoct̃ap̃ñohuen.” ");
INSERT INTO ameNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ñeñt̃paʼ ñeñt̃caʼye ñoñets ñeñt̃ poʼñoc̈h atarr sherbets, ñeñt̃paʼ ellocaʼyeña metanaʼtuenan poʼpoñec̈hno ñoñtsoc̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Allot̃paʼ poʼpoñ ñoñets ñeñt̃ atarr sherbets ñeñt̃paʼ atet̃ oten: “Atarrchaʼ yemorrenteña yamoʼts eʼñe atet̃ atarr yemorrentena yañeña.” ");
INSERT INTO ameNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Añ epoʼmar ñoñets ñeñt̃ña eʼñe etsotatueneʼ allohuen poʼpoñec̈hno ñoñtsoc̈hno ñeñt̃ atet̃ anaʼyesaret̃, ñam̃a allohuen Yompor poʼñoñ ñeñt̃ aʼm̃taʼyeseteʼt̃ ahuat̃. ");
INSERT INTO ameNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Allempoña fariseoneshaʼpaʼ ñetñapaʼ alloʼtsenareta all apc̈henet eʼñe ñochayet, ");
INSERT INTO ameNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesúsña allpaʼ atet̃ otanet: —Sapaʼ ¿errot̃enaʼt sotenña sa añecop ñeñt̃chaʼ Cristotosets? ¿Eseshaʼt soten ñeñt̃chaʼ poʼm̃reneñ perreʼña ñeñt̃chaʼ Cristotosets? Ñetñapaʼ atet̃ ochet: —Davidchaʼcaʼye poʼm̃renñot̃ huapaña ñeñt̃chaʼ Cristotosets. ");
INSERT INTO ameNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ñañapaʼ alla oterraneterr: —Ñerraʼm poʼñoc̈hchaʼ David poʼm̃reneñ perreʼpaʼ sapaʼ amaʼt señoteñeña Davidpaʼ allempo eñoracheʼt̃ Parets Puecamquëñ ñapaʼ atet̃caʼye oteʼt̃ poʼm̃renñecop ñeñt̃ara ñeñt̃chaʼ Cristoterrets: “Napaʼ ñeñt̃caʼyeña Nepartseshar nepen.” David allempopaʼ atet̃caʼye eñoseʼt̃ña añecop ñeñt̃chaʼ Cristoterrets: ");
INSERT INTO ameNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Yompor Paretspaʼ atet̃ otennan ñeñt̃ eʼñe Nepartseshar nepen na (ñeñt̃ara ñeñt̃chaʼ Cristoterrets): “T̃eʼpaʼ oʼch p̃anorruerr arr necohuenrot̃ allchaʼ pecohuentapreterrna. Att̃ochña amaʼt ñeñt̃ peʼmoñeʼteneʼ napaʼ oʼch eʼñe nameʼñatuerranet allochñapaʼ oʼch atet̃ perret ñeñt̃ pemnen p̃a.” ");
INSERT INTO ameNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ñeñt̃paʼ atet̃caʼye oteʼt̃ña David, ñeñt̃chaʼ Cristoterretspaʼ ñeñt̃caʼyeña Poʼpartseshar peʼt̃ña amaʼt allempot̃eñ. Ñehua, amaʼt señoteñeña Cristo ñeñt̃ Poʼpartseshar peʼt̃ Davidpaʼ ñeñt̃ña t̃eʼpaʼ oʼ alla poʼm̃reneñ per ñam̃a. ");
INSERT INTO ameNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ñetñapaʼ amaʼt puesheñarrot̃etapaʼ ama eseshayeʼ anapuenayeʼ entaye. Ñeñt̃oʼmarña allempot̃eñpaʼ amaʼt puesheñarrot̃etapaʼ ama eseshayeʼ aʼp̃t̃oʼtenayeʼ enterraye. ");
INSERT INTO ameNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Allempoña Jesúspaʼ alla serrpareʼtaterran allohuen acheñeneshaʼ ñam̃a eʼñe ña pueyochreshac̈hno. Ñeñt̃paʼ atet̃ otanet: ");
INSERT INTO ameNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Añña fariseoneshaʼ epuet ñam̃a ñeñt̃ atarr etsotayeneʼ ñoñets ñeñt̃ atet̃ anaret̃, ñetpaʼ añecpa anaret̃tenet ñetchaʼ señotateneʼ ñoñets ñeñt̃ atet̃ nonaseʼt̃ Moisés ahuat̃. ");
INSERT INTO ameNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ñeñt̃oʼmarña socoppaʼ eʼñe pocteʼ oʼch sep̃ohuena ñeñt̃ atet̃ otenset, amachña c̈haña sat̃pareʼteñe. T̃arraña sapaʼ amachña atet̃ sep̃atsto ñeñt̃ atet̃ p̃atseʼtyenet ñet. T̃arroʼmar amaʼt atarr cohuen serrpareʼtenetañpaʼ amacaʼyeña eʼñeyeʼ atet̃ peneto ñeñt̃ atet̃ serrpareʼtatenset. ");
INSERT INTO ameNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ñetpaʼ c̈hacaʼye atarr atontatennasetña ñoñets ñeñt̃chaʼ eʼñe atet̃ sep̃ohueneñ ñetpaʼ ñeñt̃acaʼyeña nennaset ñeñt̃ atarr t̃orrapoʼ sentyen. Ñeñt̃paʼ atet̃chaʼ netmaʼntacha ñetpaʼ c̈hacaʼye ottenet ñerraʼmrrat̃eʼ añ huanquënnaset ñeñt̃ atarr eñerr seʼmuen att̃och sechechnom̃. T̃arraña ñet amaʼt mameshapaʼ amaña anmapretenseto, amaʼt potap̃ot̃etapaʼ ama echantapretnenseto ñeñt̃ chechatnenset. ");
INSERT INTO ameNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Fariseoneshaʼ allohuen ñeñt̃ atet̃ etsotayeneñpaʼ ñeñt̃paʼ eʼñe pommoʼcheñot̃eta atet̃ penet allochñapaʼ acheñeneshaʼñapaʼ eʼñech cohuen entyeñet ñeñt̃ att̃o atarr t̃orraʼyenetañ Yomporecop. T̃arraña ñeñt̃paʼ eʼñecaʼye orrena. Ñam̃a ñetpaʼ c̈hacaʼye ateshatomuerrtatenet porem̃ allñapaʼ all quellquëññañetañ Yompor poʼñoñ amaʼt ñeñt̃paʼc̈hoʼña allocaʼyeña huancatoʼtenet. T̃arraña ñeñt̃paʼ eʼñe añecpa atet̃ penet att̃och acheñeneshaʼpaʼ eʼñech cohuen entenanet. T̃arraña ñeñt̃paʼ eʼñe orrena atet̃ penet ñeñt̃ att̃o ommoʼchenet. Ñam̃a ñetpaʼ añeʼnacaʼyeña allpochaʼp̃tatenet ñeñt̃ c̈heraʼrrtenet paʼshtamueto paʼrrpeʼmonet̃. T̃arraña ñeñt̃paʼc̈hoʼña eʼñe añecpa atet penet eʼñe pommoʼcheñot̃et. ");
INSERT INTO ameNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ñam̃a ñetpaʼ ñerraʼm c̈ho rrallmeʼchapretenetpaʼ añacaʼye atarr muenenet oʼch anorrc̈haʼtyenet allecma anorryen ñeñt̃ atarr am̃chaʼnaʼtpoʼ entyen allohuen acheñeneshaʼ. Ñam̃a ñetpaʼ eʼñe att̃ecma penet amaʼt all judioneshaʼ poʼprahuo. ");
INSERT INTO ameNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ñam̃a ñetpaʼ eʼñe pommoʼcheñot̃et añeʼnaña atarr muenenet acheñeneshaʼpaʼ oʼch huom̃chaʼtyesapanet pueʼm̃chaʼnañot̃et ñerraʼm esempo chopeñeʼchyenet t̃oñoʼmar allecma shontena acheñeneshaʼ. Ñam̃a pommoʼcheñot̃etpaʼ añeʼnaña atarr muenenet oʼch otanet acheñeneshaʼ ñetpaʼ eʼñoʼ partsesharerochet. ");
INSERT INTO ameNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’T̃arraña sayeʼña neyochreshachaʼ ñatoʼtña semnenaʼña oʼch otas acheñeneshaʼ sapaʼ eʼñoʼ partseshareroches. Ñam̃a sa allohuenespaʼ eʼñechña semoʼnasheñecma sep̃annena, t̃arroʼmar sa allohuenacpaspaʼ napt̃acaʼyeña Separtseshar sepenen na ñeñt̃en Cristotosets. ");
INSERT INTO ameNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ñam̃a arr patsro amaʼt puesheñarra amach seyomporer sep̃atstaneto. T̃arroʼmar sapaʼ eʼñecaʼye pat̃rraña Sompor ñeñt̃ pueʼntañoʼtsen. ");
INSERT INTO ameNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ñam̃a sapaʼ amach semnatsche amaʼt puesheñarra eʼñe puec̈horeʼteñot̃etaspaʼ oʼch otaset: Naʼyochret̃erneshachaʼ. T̃arroʼmar sa allohuenacpaspaʼ napt̃acaʼyeña Saʼyochreshat̃er sepenen na ñeñt̃en Cristotosets. ");
INSERT INTO ameNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","T̃arroʼmar ñeñt̃ poʼñoc̈h cohuen am̃chaʼtaret̃tetsa sesho ñeñt̃paʼ ñeñt̃caʼyeña atarr t̃orretsaña poʼpotantañecop att̃och orrtatanet ñeñt̃ atarr sherbets ñocpuet. ");
INSERT INTO ameNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","T̃arroʼmar allohuen ñeñt̃ eʼñe cohuen entetsa eʼñe pommoʼcheñot̃ ñeñt̃ña tsapat̃onet̃paʼ amach esosheʼmayeʼ entereto. T̃arraña allohuen ñeñt̃ ama esosheʼmayeʼ entetso t̃eʼ ñeñt̃ña tsapat̃onet̃paʼ atarrchaʼ cohuen enteret. ");
INSERT INTO ameNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Atarr nanac llequëñtsoʼtsenes fariseoneshachaʼ ñam̃a sam̃a ñeñt̃es eʼñe etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop t̃arroʼmar sapaʼ sommoʼcheñot̃eʼna atarr seshcareʼtyen. T̃arroʼmar amaʼt sapaʼ amacaʼye senteññañeña Yompor poʼcohuenña, ellonet̃paʼc̈hoʼña c̈hocma sepatareʼteñña poʼpotantañ ñeñt̃ eʼneneʼ Yompor poʼcohuenña. C̈ha saʼnpam̃peñña acheñeneshaʼ att̃och ñetpaʼc̈hoʼña amach enterrñañeto Yompor poʼcohuenña ñeñt̃ att̃o atarr ayochreshat̃tena ña pueʼntañot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Atarr nanac llequëñtsoʼtsenes fariseoneshachaʼ ñam̃a sam̃a ñeñt̃es eʼñe etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop, t̃arroʼmar sapaʼ sommoʼcheñot̃eʼna seshcareʼtyeñ. Amaʼt rret̃orrnaneshaʼpaʼ ñeñt̃eʼnaña seprratam̃pesyenña paʼpaquëll. Elloña eʼñe sommoʼcheñot̃paʼ aña atarr semnen oʼch atet̃ sepena ñerraʼm atarr cohuen acheñres ñeñt̃oʼmarña all semaʼyochena allecma shontena acheñeneshaʼpaʼ amach t̃ematenayaya semaʼyocheno. Ñeñt̃oʼmarña na t̃eʼpaʼ oʼch notas, sapaʼ elloña atarrchaʼ saʼcoñchataret̃terra. ");
INSERT INTO ameNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Atarr nanac llequëñtsoʼtsenes fariseoneshachaʼ ñam̃a sam̃a ñeñt̃es eʼñe etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ t̃arroʼmar sapaʼ sommoʼcheñot̃eʼna atarr seshcareʼtyen. Sapaʼ c̈hocma sechopeñeʼchyen erracmañen patsoʼmar, sep̃chatyena amaʼt ñam̃a sapoʼmar. Ñeñt̃paʼ añecpa atet̃ sepena att̃och sameʼñatyesya amaʼt eʼñe puesheñaʼttsa eʼñe sa soct̃ap̃ña ñeñt̃es judioneshas. Ñeñt̃ allpon sameʼñatyenapaʼ ñetñapaʼ aña seyc̈hatyenanet ñeñt̃ ama cohuenayaye ñeñt̃ eʼñe atet̃ sepena sam̃a. Ñeñt̃oʼmar ñetpaʼc̈hoʼña ello atarr nanac oʼpatataret̃tenet coñcheñets, eʼñe epocheʼttsocma soʼpatatenanet coñcheñets. ");
INSERT INTO ameNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Atarr nanac llequëñtsoʼtsenes t̃arroʼmar amaʼt ñeñt̃ ama sec̈henoyo seyoc̈hro sañapaʼ ñeñt̃ara seyc̈hateñña poʼpotantañec̈hno. Ñeñt̃paʼ eʼñe atet̃ sepena ñerraʼmrrat̃eʼ aporoʼyet̃ecmas echaʼnmannetsa. Amaʼt seyc̈hateneñ ñeñt̃ poʼñoc̈hpaʼ amacaʼye att̃eyaye. Ñeñt̃paʼ atet̃ soteneñ: “Ñerraʼm eseshaʼ neneʼ poʼñoñ ñerraʼm aña Parets paʼpaquëll paʼsoʼchño nenan poʼñoñ saña ñeñt̃paʼ c̈ha soten añoʼ esoyaye ama pallteno oʼch eʼñe poʼñoc̈h aʼpoctatan poʼñoñ.” T̃arraña poʼpoñpaʼ atet̃ soteneñ: “Ñerraʼmña añ oro paʼsoʼchño yenaʼ yeñoñ ñeñt̃ Parets paʼpaclloʼtsen allempoña poʼñoc̈hpaʼ c̈hocmach eʼñe yaʼpoctat yeñoñ.” ");
INSERT INTO ameNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Sapaʼ atarr otatsñat̃es, ama añeyeʼña sec̈henoyoña seyoc̈hro ñeñt̃ cohuen enten Yompor. C̈hacaʼye sottena ñerraʼmrrat̃eʼ aporoʼyet̃ecmas. Amaʼt señoteñeña atet̃ sherben oropaʼ eʼñecaʼye att̃ecma sherbenña ñam̃a Parets paʼpaquëll. T̃arroʼmar allempo neteʼt̃ oro Parets paʼpacllo, ñeñt̃ña oropaʼ añcaʼye eʼñe cohuen aʼpoctatayeʼt̃ Partsocop ñeñt̃ara Partsopoʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ñam̃a poʼpoñpaʼ atet̃ soteneñ: “Ñerraʼm eseshaʼ neneʼ poʼñoñ eʼñe altar paʼsoʼchño allecma neñet ñeñt̃ amtsaret̃tetsa Yomporecop, ñeñt̃paʼc̈hoʼña c̈ha soten añoʼ esoyaye, ama pallteno oʼch eʼñe poʼñoc̈h aʼpoctatan poʼñoñ.” T̃arraña poʼpoñpaʼ atet̃ soteneñ: “Ñerraʼmña añ paʼsoʼchño yenaʼ yeñoñ ñeñt̃ amtsaret̃tetsa Yomporecop ñeñt̃ nenet altarro enot̃, allempoña poʼñoc̈hpaʼ c̈hocmach eʼñe yaʼpoctat yeñoñ.” T̃arraña amaʼt atet̃ sotatseʼtyeneñpaʼ ñeñt̃paʼ amacaʼye poʼñoc̈hoyaye. ");
INSERT INTO ameNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Sapaʼ ama añeyeʼ sec̈henoyoña seyoc̈hro ñeñt̃ cohuen enten Yompor. C̈ha sottena ñerraʼmrrat̃eʼ aporoʼyet̃ecmas. Amaʼt señoteñeña altarpaʼc̈hoʼña atarrcaʼye sherben. Eʼñe att̃ecma sherben ñerraʼmrrat̃eʼ ñeñt̃ amtsaret̃tetsa Yomporecop ñeñt̃ nenet all altarro enot̃. T̃arroʼmar altarpaʼ ñeñt̃caʼyeña aʼpoctateneʼña Yomporecop ñeñt̃ nenet all. ");
INSERT INTO ameNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ñeñt̃oʼmarña yeñoteñ ñerraʼm esempo yenen yeñoñ altar paʼsoʼchño, ama eʼñe ñapt̃a altar paʼsoʼchño yenenoña yeñoñ; añohuencaʼyeña yenenña yeñoñ eʼñe paʼsoʼchño allohuen ñeñt̃ naʼyenet all, allecma sherb̃aʼyenet Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ñam̃a ñerraʼm esempo yenen yeñoñ Partsopoʼ paʼsoʼchño, ama eʼñe ñapt̃a Partsopoʼ paʼsoʼchño yenenoña yeñoñ. Yomporeʼnacaʼyeña paʼsoʼchño yenenña yeñoñ t̃arroʼmar ñapaʼ eʼñecaʼye ño paʼpaquëll. ");
INSERT INTO ameNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ñam̃a ñerraʼm yenen yeñoñ Yompor pueʼntañ paʼsoʼchño, Yomporeʼnacaʼye paʼsoʼchño yenenña yeñoñ amaʼt ñam̃a Yompor poʼconañeʼnacaʼye paʼsoʼchño yenenña yeñoñ t̃arroʼmar enetpaʼ Yomporcaʼye poʼconañ peneʼ t̃arroʼmar allpaʼ alloʼtsencaʼyeña Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Atarr nanac llequëñtsoʼtsenes fariseoneshachaʼ ñam̃a sa ñeñt̃es eʼñe etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop t̃arroʼmar sapaʼ sommoʼcheñot̃eʼna atarr seshcareʼtyen. Ora allohuen ñeñt̃ senarem̃ sepen amaʼt c̈hocma sapueñeñ Yompor allpon ñeñt̃ poctetsa ñocop —mentapan, anísopan, cominopan—sapaʼ c̈ha sepsenña ñeñt̃ ñoñtsor ñeñt̃ atet̃ anaret̃ ñeñt̃caʼyeña ello nanac sherbets. Ñeñt̃paʼ att̃och eʼñe cohuen es sep̃aʼyeññañ poʼpotantañ. Ñeñt̃ña sapaʼ c̈haña sepseñ. Ñam̃a att̃och semuerannaʼta ñeñt̃paʼc̈hoʼña sañapaʼ c̈hacaʼyeña sepseñ. Ñam̃a att̃och poʼñoc̈h eʼñe cohuen sameʼñañat̃tena Yomporecop ñeñt̃paʼc̈hoʼña sañapaʼ c̈hacaʼyeña sepseñ. Sapaʼ eʼñe ñeñt̃aña sepalltena. Ñam̃a att̃o c̈hocma es sapaʼyen Yomporecop ñeñt̃paʼc̈hoʼña c̈hocmach atet̃ sepena amach c̈ha sepsatstere. ");
INSERT INTO ameNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Sapaʼ amaʼt ama c̈hoyeʼ c̈hennaso seyoc̈hro ñeñt̃a atarr semneñ oʼch seyc̈hach poʼpotantañ acheñeneshaʼ. Ñeñt̃paʼ eʼñe atet̃ sepena ñerraʼmrrat̃eʼ aporoʼyet̃ecmas echaʼnmannetsa. Añ ñoñets ñeñt̃ atet̃ anaret̃ socop ñeñt̃ setseten eʼñe soʼna soct̃ap̃ña amaʼt ñeñt̃paʼ atarr coñeʼt̃ot̃ sherben Yomporecop, sañapaʼ ñeñt̃acaʼye atarr semneñ oʼch seyc̈hateñ poʼpotantañ. T̃arraña añ ñoñtsor ñeñt̃ atarr nanac sherbets Yomporecop, saña ñeñt̃paʼ ama c̈hennasoña seyoc̈hro amaʼt eʼñe mamesha. Ñeñt̃paʼ oʼch netmaʼntacha atet̃ ñerraʼmrrat̃eʼ ñeñt̃ atarr es añet̃oll allpon ñerraʼm c̈hopoʼyet̃oll saña ñeñt̃paʼ c̈hacaʼyeña seyorasoteñ t̃arraña ñeñt̃ña atarr añecmuen allpon ñerraʼm huaquësh sapaʼ ñeñt̃aña sañyen eʼñe att̃a. ");
INSERT INTO ameNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Atarr nanac llequëñtsoʼtsenes fariseoneshachaʼ ñam̃a sa ñeñt̃es eʼñe etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop. Sapaʼ eʼñe seʼpameʼteneñña setaza enot̃paʼ oʼponot̃ñapaʼ ama seʼparroʼteñe. Seplatopaʼc̈hoʼña enot̃a eʼñe seʼpataʼteñ oʼponot̃ñapaʼ ama seʼpataʼteñe. Eʼñe atet̃ sepena sam̃a. Eʼñe saʼcohuentatena ñeñt̃ enoʼmar ñeñt̃ atet̃ seyc̈hena sa allochñapaʼ att̃och entenes allohuen acheñeneshaʼ sapaʼ eʼñoʼ cohuenes, t̃arraña oʼpono seyoc̈hropaʼ amacaʼyeña saʼcohuentateñe, allñapaʼ eʼñe chorren shonteʼ sosyaʼtsañec̈hno ñeñt̃ att̃o eʼñe seshquëñot̃eʼna c̈hocma es seprratam̃pesyen, atarr es seyeʼchapretannena, ñeñt̃ñapaʼ eʼñecaʼye socpa. ");
INSERT INTO ameNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ñeñt̃es fariseoneshas, sapaʼ ama añeyeʼ sec̈henoyoña seyoc̈hro ñeñt̃ cohuen enten Yompor. C̈hacaʼye sottena ñerraʼmrrat̃eʼ eʼñe aporoʼyet̃ecmas. Socoppaʼ añcaʼyeña poctetsa, ñanomchaʼña oʼponot̃ seʼpameʼtña setaza, seplatopaʼc̈hoʼña ñanomchaʼña oʼponot̃ seʼpatach. Allochñapaʼ oʼch eʼñe cohuenta emoshem̃toʼmar. ");
INSERT INTO ameNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Atarr nanac llequëntsoʼtsenes fariseoneshachaʼ ñam̃a sa ñeñt̃es eʼñe etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop. Sapaʼ eʼñe att̃es ñerraʼm apampaña ñeñt̃ aʼhuallamaʼt̃tam̃penet. Enot̃paʼ eʼñech cohuen orrtenañ. Oʼponot̃ñapaʼ eʼñech chorren arromñat̃ap ñam̃a paʼnamen ñeñt̃ nanac sosey. ");
INSERT INTO ameNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sapaʼc̈hoʼña eʼñerramcheʼ att̃esña sam̃a. Poʼñoc̈hcaʼye ñeñt̃ atet̃ sorrtatyen acheñeneshaʼñapaʼ eʼñe atet̃ entenset ñerraʼmrrat̃eʼ sapaʼ eʼñe cohuenareʼ es sep̃aʼyen. T̃arraña oʼponoña seyoc̈hropaʼ eʼñe aña shontetsa alloch sommoʼchyena, atarr seshcareʼtannaʼtyena, paʼnamen sorrtatyen ñeñt̃ amaʼt mamesha ama cohuenayeʼ entapretenso Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Atarr nanac llequëñtsoʼtsenes fariseoneshachaʼ ñam̃a sa ñeñt̃es eʼñe etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop t̃arroʼmar sa t̃eʼpaʼ sat̃omaten enot̃ ñeñt̃ atarr cohuen senten sa all pampaʼyeseteʼt̃ ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ. Ñam̃a añeʼna saʼcohuentam̃pesyen all pampaʼyeseteʼt̃ ñeñt̃ acheñeneshar ñeñt̃ eʼñe pocteʼ es p̃aʼyeseteʼt̃. ");
INSERT INTO ameNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Saña t̃eʼpaʼ atet̃ sotyeneñ: “Ñerraʼm allempocmach yeʼñalletañ allempo correʼt̃ yatañneshañ, att̃o ñetpaʼ muetsanacheteʼt̃ ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ, yañapaʼ amat̃eʼ esoʼmar yemtsapretaneto.” ");
INSERT INTO ameNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ñeñt̃ atet̃ sotyeneñpaʼ t̃eʼña eʼñe sa señoñot̃paʼ oʼ saʼmet̃am̃p̃sa eʼñe sañeña poʼñoc̈h sapaʼ poʼm̃renñescaʼye ñeñt̃ muetsanatayeʼt̃ ahuat̃ ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ñeñt̃oʼmarña sa t̃eʼpaʼ ñeñt̃acaʼyeña eʼñe setsoteññañ satañneshañ ñeñt̃ allpon sosyaʼtsañec̈hno ñeñt̃ eʼñe mot̃etnomnas ahuat̃ot̃eñ eʼñe sa satañneshañ. ");
INSERT INTO ameNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Sapaʼ ama cohuenayayso atarr ashcarñat̃es, c̈ha sottena ñerraʼmrrat̃eʼ shechp̃a sompor sepen. Sapaʼ errot̃enohuachñacaʼyeña sequeshperrat̃eʼ. Sapaʼ añacaʼye soʼpatenaya coñcheñets ñeñt̃ parrareʼ tsoʼ all oʼpono. ");
INSERT INTO ameNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ñeñt̃oʼmarña t̃eʼ napaʼ oʼch nemñerrnas ñeñt̃chaʼ aʼm̃taʼyerreʼ neñoñ, ñam̃a ñeñt̃ atarr eñotañ nep̃aʼyen, ñam̃a ñeñt̃ atarr etsotayeneʼ neñoñ ñeñt̃ atet̃ anaret̃ ahuat̃ot̃eñ. T̃arraña saña ñeñt̃paʼ c̈hachcaʼyeña semtsanatuerrnan ñeñt̃ patantaʼtets, poʼpotantaññapaʼ eʼñech secorsoʼtam̃pesuerrnan. Poʼpotantañña sapaʼ c̈hach senalleʼtyesuerrnan eʼñe all sa seprahuoʼmar. Atarr seʼmoñeʼtenanet ñeñt̃oʼmarña c̈hocma soct̃areʼtenanet anetsot̃ oʼch saʼyetatuanet ñetñapaʼ oʼch ahuanemyeset poʼpoñ anetsoʼmar. ");
INSERT INTO ameNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Att̃ocaʼyeña ora allohuen ñeñt̃ eʼñe pocteʼ es p̃aʼyestseʼt̃ ñeñt̃ amtsanatyesaret̃tatseʼt̃ ashataret̃etyeseteʼt̃ poʼrras, sañapaʼ allempot̃eñ eʼñe saʼyohuaret̃tena amaʼt t̃emeʼttsen, sa ñeñt̃es corretsa t̃eʼ, amaʼt allempot̃eñ amtsaret̃ta Abel ñeñt̃ ama es yec̈hcatetso amaʼt coñeʼt̃a t̃arrempohua allempo semtser ñam̃a Zacarías ñeñt̃ Berequías puechemer. Ñeñt̃ña sapaʼ alla semtser Parets poʼponro puechaʼpetarot̃ alloʼtsen altar allot̃ecma sherbeteʼt̃ Yompor. Amaʼt allohuen ñeñt̃ amtsanatyesaret̃tatseʼt̃ allempo sañapaʼ eʼñe allempot̃eñ saʼyohuaret̃terra. ");
INSERT INTO ameNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Poʼñoc̈hcaʼye notenes, acheñeneshaʼ ñeñt̃ corretsa t̃eʼ ñetñapaʼ atsaʼtataret̃terretchaʼ eʼñe ora allpon atserrp̃atseʼtyesoneteʼt̃ ñeñt̃ eʼñe pocteʼ es p̃aʼyestseʼt̃ Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’T̃eʼpaʼ eʼñe nellquëñot̃ oʼch notas sa ñeñt̃es jerusaléñoʼmarneshas, ñeñt̃es muetsanatyesayeʼt̃ ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ, sa ñeñt̃es rrollapechyesayeʼt̃ ñeñt̃ amñaret̃tatseʼt̃ sesho, t̃eʼña napaʼ oʼch notas: Napaʼ atarr atonocheʼtats nemneñeñ oʼch naʼyapac̈haʼhuerrsoñ allohuenes nesho att̃och eʼñe cohuen necuam̃pensoñ. Nemneñeñ oʼch naʼyapac̈haʼhuerres atet̃ ñerraʼmrrat̃eʼ atollop aʼyapac̈heneʼ puechoyoreshaʼ oʼch eʼñe setoʼtuanet. T̃arraña sañapaʼ amaʼt eʼñe mameshapaʼ amaña semno. ");
INSERT INTO ameNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","T̃eʼñapaʼ all seyc̈hena sa, Yomporñapaʼ oʼch aʼypoʼñerres. ");
INSERT INTO ameNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","T̃arroʼmar t̃eʼpaʼ oʼch alla noterrserr: Na poʼpocheñopaʼ amach alla senterrneʼt̃e. Esempohuañenñapaʼ senterrenchaʼ, allempoñapaʼ atet̃chaʼ soterren: “Ayeʼchoc̈htatpahuepaʼch Jesucristo ñeñt̃ huapatsa ñeñt̃ llesensen Yeyomporer.” ");
INSERT INTO ameNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesúsñapaʼ c̈haʼnerrerr Parets paʼpacllot̃. Alla ahuenerr allempoñapaʼ ponem̃ya pueyochreshaʼ. Ñetñapaʼ allent̃a cohuatyeset ñeñt̃ atarr coc̈hneshaʼtyetsa allo orrataret̃tena Partsopoʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Allempo Jesúspaʼ atet̃ otanet: —Amaʼt senteñeñ ora allohuen ñeñt̃ coc̈hneshareʼ t̃arraña napaʼ oʼch notas: Poʼñoc̈hcaʼye c̈herrchaʼ allempoch eʼñe aʼmataʼtaret̃etuerra. Amaʼt eʼñe puem̃arra mapyetpaʼ amach aʼpuerroña all allo orratenet Partsopoʼ eʼñechcaʼye poctacma aʼcoyeʼtaret̃etuerra. ");
INSERT INTO ameNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ñeñt̃a otuanenanetpaʼ allent̃a ahuen Olivop̃no. Allñapaʼ anorruen, pueyochreshaʼñapaʼ oʼ alla huac̈herrñañeterr, eʼñe ñapt̃ochayet. Ñetñapaʼ atet̃ otuereterr: —Yapaʼ yemneñcaʼye oʼch p̃otey ¿esempoʼtchaʼña atet̃ perra? Ñam̃a ¿esoʼtchaʼ yentyerrña ñeñt̃chaʼ yeñotaterreʼ allempoch pehuerrmocha oʼch mellapoterra? ");
INSERT INTO ameNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesúsñapaʼ atet̃ otanet: —Eʼñech señoterra, allochñapaʼ amach eseshaʼ seshquërraye. ");
INSERT INTO ameNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","T̃arroʼmar shonteʼch orrterrtsa ñeñt̃chaʼ ayc̈haʼnataterreʼ nesoʼcheñ, ñeñt̃chaʼ otyerrets: “Napaʼ ñeñt̃encaʼyeña Cristotets.” Ñetñapaʼ shonteʼch shequëret acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ñam̃a allempoña sapaʼ seʼmareʼtyerrchaʼ oʼ quellareñtsotyerr allampañoʼmar, ñam̃a seʼmareʼtyerrchaʼ oʼ quellareñtsotyerra ora errap̃aren anetsoʼmar. Saña allempopaʼ amach c̈ha seyorenatsto amaʼt eʼñe mamesha. Ñeñt̃paʼ atet̃chaʼcaʼye eʼñe poʼñoc̈h perra. T̃arraña allempopaʼ amach c̈henaʼ allempoch eʼñe mellapoterra. ");
INSERT INTO ameNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Paʼnamen acheñ ñeñt̃ eʼñe poʼpoñeʼttsocma mereñtsoretpaʼ ñetpaʼ quellarannaʼterretchaʼ. Ñam̃a paʼnamen anetsot̃ am̃chaʼtaret̃ec̈hnopaʼ quellaraterranchaʼ pueyochreneshac̈hno. Orrterrach allemeñ muec̈heñets oʼch eʼñe chaporrñatsotyerr errap̃aren. Ñam̃a orrterrach paʼnamen atsnañtsoc̈hno ñeñt̃ atarr apatannaʼtpoʼ. Pellaʼyerrach pats ora errap̃aren. ");
INSERT INTO ameNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ñeñt̃ atet̃ oʼ notuas t̃eʼpaʼ ñeñt̃ña allempopaʼ ñeñt̃chaʼña ñanom mueroc̈htaterrahuetña allempo. ");
INSERT INTO ameNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Allempoña sapaʼ pomuerrsetchaʼ att̃och errot̃uanen perrset allchaʼña muetsatyerrset. Atarrchaʼ eʼmoñeʼterres allohuen acheñeneshac̈hno t̃arroʼmar sapaʼ nacaʼyeña eʼñe sameʼñena. ");
INSERT INTO ameNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ñam̃a shonteʼch acheñ allempo ñeñt̃chaʼ quec̈hpuerreʼ Yompor. Eʼñe ñagattsetapaʼ eʼmoñeʼtannaʼterretchaʼ att̃ot̃chaʼ pomatatannaʼtyerret. ");
INSERT INTO ameNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ñam̃a allempopaʼ orretyerrach shonteʼ ñeñt̃chaʼ ayc̈haʼnaterrtsa ñetpaʼ añoʼ aʼm̃tenet Yompor poʼñoñ. T̃arraña poʼñoc̈h amach Yomporeyeʼ poʼñoñ aʼm̃terreto, ñetpaʼ att̃achña shequëretña shonteʼ acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Allempopaʼ atonterrach errap̃aren paʼnamen sosyaʼtsañec̈hno allochña atarr at̃pareʼterrñañet Yompor poʼñoñ. Ñeñt̃oʼmarña shonteʼ acheñpaʼ oʼhuañchaʼ alloʼna morrentannaʼtnenet. ");
INSERT INTO ameNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","T̃arraña amaʼtchaʼ errot̃uanen ap̃aret̃terret, eseshaʼch eʼñe ahuantaʼhuanmueʼ ñeñt̃chaʼ ama nequec̈hpuerraye, ñeñt̃ñapaʼ ñeñt̃chaʼña aʼqueshp̃ataret̃terrtsa. ");
INSERT INTO ameNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ñam̃a allempopaʼ añ cohuen ñoñets att̃o ayochreshat̃tena Yompor ñeñt̃chaʼña ñanom serrpareʼtatyeretña acheñeneshaʼ ora errap̃aren allohuanen añe patsro. Att̃ochña eñotateretña ora allohuen paʼnamen acheñeneshaʼ ñeñt̃ poʼñoc̈h atet̃ oteney Yompor. Allempochña poʼñoc̈h mellapoterra. ");
INSERT INTO ameNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Ñehua, ahuat̃ Daniel ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ, ña poʼquellcopaʼ atet̃ oteʼt̃: “C̈herrchaʼ allempo amaʼt ñeñt̃ ama masosyayeʼ enteno Yomporpaʼ ñeñt̃ñapaʼ c̈herrchaʼ all amaʼt ñeñt̃ eʼñe Partsocpa anaret̃eñ. Ñeñt̃paʼ ñeñt̃achcaʼyeña eʼñe aʼchencatuerrahuet.” Ñehua, ñeñt̃chaʼ lleyerreʼ añ ñoñetspaʼ ñetñapaʼ eñoteretepaʼch. Ñeñt̃oʼmarña ñerraʼm esempoch senter oʼ c̈hap all ñeñt̃ eʼñe Partsocpa anaret̃paʼ ");
INSERT INTO ameNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","allempoña ñeñt̃ allpon Judeoʼtsaʼyen ñetñapaʼ allorocmuepaʼch yetrraʼterret, ahuanerretepaʼña aspent̃areronet̃. ");
INSERT INTO ameNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Atet̃ ñerraʼmrrat̃eʼ puesheñaʼtets ñatoʼ ñetña allempopaʼ enoʼtsaʼyenetchaʼ paʼpacllato, ñetñapaʼ sohuetepaʼchña t̃ecma t̃arraña amachña beʼt̃osatsetnomuetoña poʼponreto att̃och yoratsreʼtnomuet. ");
INSERT INTO ameNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ñam̃a puesheñaʼtets ñeñt̃ paʼmroʼtsenpaʼ allempoña ñetpaʼ amachña onatsterreto att̃och erretaʼ paʼshtamuet. ");
INSERT INTO ameNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Allempopaʼ atarrchaʼ llequëñets añecop ñeñt̃ ac̈homenareʼ coyaneshaʼ ñam̃a ñeñt̃ allohuen emaret̃et̃olleshac̈hno. (T̃arroʼmar ñocpuetpaʼ atarr t̃orrapoʼ att̃och yetrraʼtet ñamet.) ");
INSERT INTO ameNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ñam̃a Yomporchaʼña semaʼyocha allochñapaʼ amach c̈ha huapoto allempoch seyetam̃pesya ñam̃a amachcaʼye aña yet̃ro seyetatsto allempocma samesen. ");
INSERT INTO ameNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Allempopaʼ orrterrach mueroc̈hteñets ñeñt̃chaʼ atarr mueroc̈htaterreʼ allohuen acheñeneshaʼ. Ñeñt̃ amaʼt ahuat̃apaʼ ama puemueroc̈htareto atet̃ atarr nanac huomenc. Amaʼt allempot̃eñ eʼñe errteʼ ayec̈hcataret̃ta añ patser ama puemueroc̈htareto atet̃. Allempoña ellopaʼ amach atet̃ alla mueroc̈hterreteʼt̃e amaʼt errponaña. ");
INSERT INTO ameNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Allempoch atarr amueroc̈htataret̃terret. T̃arraña allempoña Yomporpaʼ ñach oterrets t̃eʼpaʼ allohuach. Ñerraʼm amach oto allohuachpaʼ allempoña amaʼt puesheñarrapaʼ amach eseshaʼ queshperrtso. T̃arraña ñeñt̃ña ameʼñenaya ña ñeñt̃ acrenpaʼ ñocpuetñapaʼ oterrchaʼ t̃eʼpaʼ allohuach. ");
INSERT INTO ameNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Ñehua, allempoch orameñ mueroc̈hteñetspaʼ ñerraʼm eseshaʼ soteʼ: “Arroʼtsencaʼyeña Cristo”, amapaʼ oʼch otaset: “T̃arroʼtsencaʼye Cristo”, sañapaʼ amach sameʼñatstaneto. ");
INSERT INTO ameNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Orretyerrachcaʼye ñeñt̃chaʼ otyerrets ñapaʼ ñoʼña Cristotets. T̃arraña ñeñt̃paʼ att̃achcaʼye shecareʼtyerranña acheñeneshaʼ. Orretyerrach ñam̃a ñeñt̃chaʼ otyerrets ñapaʼ ñoʼña aʼm̃teneʼña Yompor poʼñoñ, t̃arraña ñeñt̃paʼc̈hoʼña eʼñech att̃ecma shecareʼtyerran acheñeneshaʼ, amachña Yomporeyeʼña poʼñoñ aʼm̃teno. Ñeñt̃chaʼ atet̃ shecareʼtyerrets, ñetñapaʼ orrtatyerretchaʼ ñeñt̃ amaʼt ahuat̃a acheñeneshaʼpaʼ ama puentare, att̃ochña cohuanrrortateretña acheñeneshaʼ. Amaʼt ñeñt̃ Yompor paʼcrarnesharpaʼ mueneñetañchaʼ ñeñt̃eʼnachña shequërret. ");
INSERT INTO ameNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Señochepaʼch amaʼt ama c̈henaʼ mueroc̈hteñtsopopaʼ napaʼ oʼ eʼñe notuas sa. ");
INSERT INTO ameNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ñeñt̃oʼmar t̃eʼpaʼ notenes: Ñerraʼm allempoch atet̃ oterrset: “T̃arroʼtsencaʼyeña Cristo aʼyo all amayo”, sañapaʼ ñatoʼtña sesenaʼña all oʼch senteñaʼ. Amapaʼ ñerraʼm atet̃chaʼ oterrseterr: “T̃arroʼtsencaʼye Cristo oʼpono pocollo”, sañapaʼ ñatoʼtña sesenaʼña all oʼch senteñaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","T̃arroʼmar ñerraʼm esempo c̈herr allempoch nohuerra na Ñeñt̃en Acheñetosets eʼñe allohuen acheñeneshaʼpaʼ entapuerrnetchaʼ t̃arroʼmar allempopaʼ atet̃chaʼ nep̃ater ñerraʼmrrat̃eʼ meratsteʼ, oʼch meratsta huomencpaʼ eʼñech aʼpuetaresuan ora enet errap̃aren, amaʼt allot̃ huena atsneʼ amaʼt eʼñe allohuanen emuena. ");
INSERT INTO ameNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ñeñt̃paʼ eʼñechcaʼye atet̃ perraña ñeñt̃ atet̃ senten t̃eʼ ñerraʼm erroʼtsen ñeñt̃ rromuepaʼ allchaʼcaʼyeña shonterraña tseʼm. ");
INSERT INTO ameNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Oʼchña huañerr ñeñt̃ mueroc̈hteñetspaʼ allempoñapaʼ eʼñech allorocma mayerr atsneʼ. Arrorrpaʼc̈hoʼña oʼhuañchaʼ atsnom. Rantoc̈hnopaʼc̈hoʼña shorc̈haʼterrchaʼ entot̃. Ñam̃a ñeñt̃ huomenc orraʼyetsa ento t̃eʼ allempoña amaʼt ñeñt̃paʼ pellaʼyerrach. ");
INSERT INTO ameNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Allempoñapaʼ orrterrach ento ñeñt̃chaʼ señotaterreʼ nacaʼyeña oʼ nohuerra Ñeñt̃en eʼñe Acheñetosets. Allempochña nanac llecanrrorterra allohuen paʼnamen acheñeneshac̈hno ñeñt̃ añe patsroʼtsen. Entapuerrnetchaʼ na Ñeñt̃en Acheñetosets oʼch nesuam̃perra osot̃ eʼñe entot̃. Eʼñe nepartsoteñohuen eʼñech necohuenteñeshaʼ nohuerra. ");
INSERT INTO ameNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nemñerchaʼ nem̃llañot̃eñnaneshar ñetchaʼña poctoraʼnerrtset atarr huomenc. Ñetchaʼña aʼyapac̈haʼhuerret allem̃at̃eñ ñeñt̃ acren Nompor nocop eʼñech paʼtatsshem̃toʼmarohuen allot̃ecma orrnotena. Eʼñech allem̃at̃eñ aʼyapac̈haʼhueretchaʼ eʼñe allohuanen añ patsrot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Ñam̃a t̃eʼpaʼ señochepaʼch ñeñt̃ atet̃ pena higoch. Ñehua, esempoch senteñ higoch oʼch em̃c̃achyen puetacret̃olleshaʼ allot̃chaʼ oʼch alla tapnaʼtyerrerr pasopaner, sañapaʼ ñeñt̃chaʼña señotateneʼ oʼ c̈henmoch allempoch huorateterrerr. ");
INSERT INTO ameNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Att̃ecmach perra ñerraʼm esempoch sentyerr ñam̃a ñeñt̃ allponoʼ notuas, sapaʼ ñeñt̃chaʼña señotaterreʼ poʼñoc̈h oʼcaʼye c̈herrmoch allempoch eʼñe etsotuerra, oʼcaʼye eʼñe allameʼttsamerra. ");
INSERT INTO ameNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Napaʼ poʼñoc̈h oʼch notas, acheñeneshaʼ ñeñt̃ eʼñe corretsa t̃eʼ ñetña amach eʼñe rromhuenetaʼpaʼ allempocmach eʼñech etsoterra allohuen añec̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Esempohuañen añ enet ñeñt̃ senten t̃eʼpaʼ eʼñech chencaʼhuerra; patspaʼc̈hoʼña att̃ecmach perra eʼñech chencaʼhuerra. T̃arraña naña neñoñpaʼ amach chenquërro amaʼt eʼñe ahuat̃a. ");
INSERT INTO ameNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’T̃arraña ñeñt̃ yet̃roch nohuerrapaʼ ñeñt̃ñapaʼ ama eseshayeʼ eñotenaye. Amaʼt erroʼtsent̃eʼ atsneʼ amaʼt erroʼtsen tsapro ñeñt̃paʼ amaʼt mellañot̃eñneshaʼ ñeñt̃ pueʼntañoʼtsaʼyen ñetpaʼc̈hoʼña amaʼt puesheñarrot̃etapaʼ amaña eseshayeʼña eñotenaye allempoch nohuerrerr poʼpocheño. Amaʼt na ñeñt̃en Yompor Puechemeren napaʼc̈hoʼña t̃eʼpaʼ ama neñoteñe, ñapt̃aña Nompor Parets eñoteneʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’T̃arraña allempoch nohuerra poʼpocheño na Ñeñt̃en Acheñetosets, allempopaʼ eʼñech atet̃ perret eʼñe atet̃ peteʼt̃ ahuat̃ allempo correʼt̃ Noé. ");
INSERT INTO ameNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ñehua, allempopaʼ ama es puec̈haʼyeneto aña eʼñe cot̃apeʼcheteʼt̃ att̃o atarr paʼnamen muenenet ñeñt̃chaʼ rraʼyenet, orrareʼtyeseteʼt̃, senaʼtanatyena yacmaneshac̈hno, coyaneshac̈hnopaʼc̈hoʼña apanatyeseteʼt̃ ñeñt̃ yoranatyesahueteʼt̃. Ñetñapaʼ ñeñt̃a eʼñe cohuen enteteʼt̃. Att̃eñapaʼ c̈hap allempo beʼt̃osos Noé poʼhuarcopahuo. ");
INSERT INTO ameNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ama es puec̈haʼyeseteʼt̃e machayot̃epaʼtchaʼ chop̃a oñ erracmañen, att̃oña añyanatuerranet oñ allohuenet. Att̃ecmach perra ñerraʼm esempoch nohuerra na Ñeñt̃en Acheñetosets. Machayot̃achcaʼye nohuerra. ");
INSERT INTO ameNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ñam̃a allempopaʼ atet̃chaʼcaʼye perra; puesheñaʼtetspaʼ anmaret̃terrach; amaʼt ñeñt̃ eʼñe pamoʼts p̃annenetañ ñeñt̃ñapaʼ allach asaʼnmaret̃terra. Ñatoʼ allempopaʼ alloʼtsenchaʼ epsheña yacma paʼmro, puesheñarrñapaʼ anmaret̃terrach poʼpsheñeññapaʼ allach asaʼnmaret̃terra. ");
INSERT INTO ameNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Amapaʼ ñatoʼ allempo alloʼtsenchaʼ epsheña coyaneshaʼ ñeñt̃ parro puetseʼtets mapyo, ñeñt̃paʼc̈hoʼña puesheñarrpaʼ anmaret̃terrach poʼpsheñeññapaʼ allach asaʼnmaret̃terra. ");
INSERT INTO ameNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Ñeñt̃oʼmarña t̃eʼpaʼ oʼch notas: C̈hocmuepaʼch señoseʼrtenna t̃arroʼmar sapaʼc̈hoʼña ama señotenno esempoch nohuerra na ñeñt̃en eʼñe Separtseshar sepen. ");
INSERT INTO ameNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Napaʼ eʼñech machayot̃a nohuerra atet̃ pena eñet̃ allempo att̃a es sepc̈haʼyena machayot̃ach huaponasa oʼch yoratsreʼtensaʼ. T̃arraña sa ñeñt̃es apacllat̃es señochepaʼch ñerraʼm señoteñeñ eʼñech esempo tsapro huaponasa eñet̃, sapaʼ c̈hochña señoseʼrtenañ att̃och amach semnacheña oʼch toram̃p̃sas sepacllo oʼch beʼt̃osam̃p̃sasa oʼch yoruennasaʼ ñeñt̃ allpon semorrentyena. ");
INSERT INTO ameNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ñeñt̃oʼmar notenes sapaʼc̈hoʼña c̈hocmuepaʼchña señoseʼrtenna t̃arroʼmar allempoch att̃a es sepc̈haʼyenapaʼ allempochña nohuerra na Ñeñt̃en Acheñetosets. ");
INSERT INTO ameNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jesúsñapaʼ alla tomaʼntaterraneterr poʼpoñonet̃, atet̃ oterraneterr: —Allohuenespaʼ atet̃chaʼ sep̃a eʼñe cohuen atet̃ ñerraʼmrrat̃eʼ puesheñarr yacma ñeñt̃ atarr ameʼñañat̃tetsa ñam̃a eʼñech eñotenan ñeñt̃ atarr sherbets. Ñeñt̃ña yacmarpaʼ añ yechenaya pamoʼmteʼ eʼñe alla paʼpacllo. Añchaʼ poʼtaruas pen c̈hocmach apaʼyesan allohuen poʼpotantañ pamoʼmteʼ paʼtaruasañer puerraret allpon ñeñt̃ poctetsa puesheñaʼttsocop. Ñapaʼ att̃ecmach penanet, c̈hocmach apuenanet ñerraʼm esempoch c̈herrerr allempo atet̃ anaret̃ ñocop oʼch alla apaʼyerraneterr poʼpocheño. Ñapaʼ c̈hocmach atet̃ pena amach quec̈hpuenaneto t̃arroʼmar ñapaʼ eʼñe eñoteñ att̃och eʼñe coshatenan pamoʼmteʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ñeñt̃ña ataruasañpaʼ atarrchaʼ coshatapuerran pamoʼmteʼ. Ñerraʼm esempoch huerra oʼch alla entuenan paʼtaruasañer ama c̈ho quec̈hpuenano ñeñt̃ poʼtaruas apaʼnem̃ ahuañmoʼchot̃eñ. ");
INSERT INTO ameNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Poʼñoc̈h oʼch notas, ñeñt̃ña yacmar atarrchaʼ coshatueñ pamoʼmteʼ. Añchaʼ coshaterreʼ oʼch nohuer am̃chaʼtaret̃ ñeñt̃chaʼ cohuam̃p̃sapreteʼ ñeñt̃ allpon echyen pamoʼmteʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","T̃arraña ñeñt̃ña ataruasañer allempo ama huerraʼ pamoʼmteʼ ñerraʼm ñapaʼ att̃a oten pueyoc̈hro, namoʼmteʼpaʼ amach ahuen huerro, allempoña ñapaʼ c̈hach ashtapechyenan ataruasañec̈hno ñeñt̃chaʼ rratañ. Ñañapaʼ ñerraʼm att̃ach allemeñ rrapretyen ñam̃a att̃ach orrareʼtapretyen allchaʼ atarr posaʼtareʼtyen, ñeñt̃ña ataruasañ atet̃paʼ amaʼt mameshapaʼ ama cohuenayaye. ");
INSERT INTO ameNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ñeñt̃ña ataruasañer ñerraʼm ñapaʼ att̃ach ottatseʼtyena amach es puec̈haʼyeno amach eñoteñe ñeñt̃e yet̃roch huerra pamoʼmteʼ amaʼt erroʼtsenchaʼ yet̃ro huena. ");
INSERT INTO ameNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Machayot̃achña huerra pamoʼmteʼpaʼ atarrchaʼ coñchatuer, allach mueñuer all ñeñt̃ oʼpatenaya allohuen ñeñt̃ poʼñoc̈h ama ameʼñetso ñeñt̃ att̃a shecareʼtyets. Allñapaʼ allchaʼ yahuanrrorterret panmueñot̃et atserrpaʼ rrasoʼtyesosetchaʼ paʼs. ");
INSERT INTO ameNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesúsñapaʼ alla yec̈haterraneterr, ñeñt̃paʼ atet̃ otanet: —Allempoch am̃chaʼtaret̃terra Yompor ñeñt̃ pueʼntañoʼtsen allempoch nohuerra na, ñeñt̃ña allempopaʼ atet̃chaʼ perra eʼñech atet̃ ñerraʼmrrat̃eʼ c̈harrasheña shopshareʼ ñeñt̃chaʼ tatsa allchaʼ cohuoset allempoch huerranet ñeñt̃ eʼñe errteʼ senaʼtetsa. Ñetñapaʼ anomyeset poʼlampareñ alloch poctapueñet ñerraʼm esempoch huerra. ");
INSERT INTO ameNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Ñeñt̃ña amnarsheña ñetpaʼ att̃a es puec̈haʼyenet ñeñt̃oʼmarña ama anmuetoña poʼpoñ aceiteʼ alloch aʼhuortaterret poʼlampareñ allempoch huañ ñeñt̃ anmam̃p̃set poʼlamparñem̃o. Poʼpotantañ amnarsheña ñetpaʼ atarr eñotenet att̃och eñoseʼrteñet eʼñe cohuen, ñeñt̃oʼmarña ñet eʼñe ellonet̃paʼ anomyeset aceiteʼ puetellm̃o alloch aʼhuortaterret poʼlampareñ ñerraʼm esempo huañap̃set ñeñt̃ poʼlampareñem̃oʼtsenet. ");
INSERT INTO ameNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Allña ñetpaʼ cohueñet, ama ahuenayeʼ huerranetoña ñeñt̃ senaʼtetsa. Ñetña all machayot̃a moñeʼtyesetpaʼ c̈hepaʼtchaʼ manrraʼtuatset. ");
INSERT INTO ameNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Oʼña ñarenen tsappaʼ allempoñapaʼ machayot̃a eʼmuet rranarets, ñeñt̃ñapaʼ atet̃ oten: “T̃ayacaʼyeña huennasaña ñeñt̃ senaʼtetsa ñeñt̃ atarr secuen. Sec̈haʼnomñacaʼyeʼ oʼch sepocteñ.” ");
INSERT INTO ameNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Allempoñapaʼ allent̃a tantrraʼtuaña allohuen shopshareʼ ñetñapaʼ aʼcohuenetyeset poʼlampareñ. ");
INSERT INTO ameNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Amnarsheñaña ñeñt̃ ama yerpaʼpesnomaye aceiteʼ ñetñapaʼ atet̃ otareʼchet poʼpotantañ amnarsheña ñeñt̃ c̈hocma anmueʼ aceiteʼ: “T̃eʼpaʼ oʼch socyaʼy yam̃a aceiteʼ ñeñt̃chaʼ yaʼhuortatnom. Yapaʼ oʼ mayaʼhuaña yelampareñ.” ");
INSERT INTO ameNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ñeñt̃ña eʼñe cohuen eñoteneʼ eñoseʼrtatsapaʼ ñetñapaʼ atet̃ ochetña poʼpoñ amnarsheña ñeñt̃ enamuenahuet aceiteʼ: “Amachcaʼye yocyaso t̃eʼt yehuañapen yam̃a. Sapaʼ arrña seta all pomueñet oʼch serañt̃eñaʼ sam̃a socop.” ");
INSERT INTO ameNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ñet ahuanmatset oʼch rañt̃eñetaʼpaʼ ñeñt̃ña senaʼtetsapaʼ eʼñe allorocma c̈hen. Ñeñt̃ña poʼpoñ amnarsheña ñeñt̃ eʼñe poʼñoc̈h c̈hocma eñoseʼrtetsa, ñetñapaʼ beʼt̃osc̈haʼtet parro epuet ñeñt̃ senaʼtetsa. Allñapaʼ allchaʼ atarr coshameʼtapreteret. Allñapaʼ eʼñe echarr yottam̃p̃set. ");
INSERT INTO ameNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Allña eʼñe oʼchtatsapaʼ oʼ huac̈herraña poʼpotantañ amnarsheña shopshareʼ ñeñt̃ ahuanmatsa ñorraʼ. Ñetñapaʼ atet̃ otuerret: “Petoram̃p̃sayeʼchapuerrey Nepapareshachaʼ.” ");
INSERT INTO ameNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ñañapaʼ atet̃ otapuerranet: “T̃eʼ napaʼ oʼch notapuerres, sa amacaʼye poʼñoc̈hayeʼ seyemtenno.” ");
INSERT INTO ameNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesúsñapaʼ alla oterranerr ñeñt̃ eʼm̃ñoteneʼ: —Ñeñt̃oʼmarña na t̃eʼpaʼ oʼch notas: Sapaʼ c̈hocmuepaʼchña eʼñe cohuen señoseʼrtena, t̃arroʼmar sapaʼ amacaʼye señoteñe erraʼtsenchaʼ yet̃ñatsro allempoch nohuerra na Ñeñt̃en Acheñetosets, ñam̃a erroʼtsenchaʼ yet̃ro amaʼt ñeñt̃paʼ ama señoteñe. ");
INSERT INTO ameNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesúsñapaʼ alla yec̈haterraneterr poʼpoñ, ñeñt̃paʼ atet̃ oterraneterr: —Allempoch am̃chaʼtaret̃terra Yompor ñeñt̃ pueʼntañoʼtsen allempoch nohuerra na, ñeñt̃ña allempopaʼ eʼñech atet̃ perra ñerraʼmrrat̃eʼ puesheñarr yacma oʼch ahuoʼ b̃ac̈hayo. Ñeñt̃ña yacmarpaʼ oʼch agotnoman paʼtaruasañreneshaʼpaʼ oʼch apaʼyesnomanet quelle ñeñt̃ allpon echen; ñetñapaʼ oʼch cohuam̃p̃soñet t̃arrempohuach esempohuañenchaʼ huerra. ");
INSERT INTO ameNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Puesheñarrpaʼ apaʼnem̃ amnarmeta talento, ñeñt̃paʼ atarr shonteʼ quelle allpon ñerraʼm amnar mil. Ñapaʼ añecop apaʼnem̃ att̃och ellopaʼ oʼch atontatan poʼpatronar poʼc̃llayor. Poʼpsheñeñpaʼ apaʼnem̃ epmeta talento, ñeñt̃paʼ allpon quelle allpon ñerraʼm epa mil. Poʼpsheñeñpa apaʼnem̃ puemetarr talento. Ñeñt̃paʼc̈hoʼña allpon quelle ñerraʼmrrat̃eʼ pat̃err mil. Ñehua, puesheñaʼttsetpaʼ eʼñe allpona apaʼyesnomanet ñeñt̃ eʼñe allpona eñotyenet att̃och ellonet̃paʼ atontatet quelle. Ñeñt̃a apaʼyesuanmanetpaʼ ñañapaʼ allent̃a ahuoʼ b̃ac̈hayo. ");
INSERT INTO ameNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ñeñt̃ agapueʼ amnar mil ñañapaʼ allorocma ahuoʼ allchaʼ taruasatan quelle; att̃oña ellonet̃paʼ oʼ alla ganerrerr poʼpoñ amnar mil quelle. ");
INSERT INTO ameNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Atet̃ p̃a ñam̃a ñeñt̃ agapueʼ epa mil. Ñapaʼc̈hoʼña ellonet̃paʼ ganerrerr poʼpoñ epa mil quelle. ");
INSERT INTO ameNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","T̃arraña añña ñeñt̃ agapueʼ pat̃err mil ñañapaʼ allent̃a anem̃ allchaʼ pampueñaʼ; att̃ocaʼyeña ñapaʼ c̈ha eʼpotanña quelle. ");
INSERT INTO ameNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Oʼña atomatpaʼ oʼ huerranetña poʼpatronaret, allent̃a agotatuerranet att̃och entuerranet poʼtaruas errot̃ent̃eʼ taruasaʼyeset eʼñe puesheñaʼttset. ");
INSERT INTO ameNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ñeñt̃ña agapueʼ amnar mil ñañapaʼ huapapaʼ apapuenan poʼpatronar poʼpoñ amnar mil quelle, ñeñt̃paʼ atet̃ otapueñ: “Añña Nomporchaʼ ñeñt̃ p̃apaʼnmuen amnar mil quelle ahuaña, napaʼ ellocaʼye neganerrerrña pec̃llayorot̃ poʼpoñ amnar mil quelle.” ");
INSERT INTO ameNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Poʼpatronarpaʼ atet̃ och: “Eʼñe pocteʼ neyochrechaʼ; p̃apaʼ atarr cohuen pesherbenen. P̃apaʼ eʼñe cohuen petsoton ñeñt̃ atet̃ notnomuep̃. Amaʼt allponat̃olla napaʼnmap̃ ahuaña, p̃añapaʼ atarroʼt cohuen pesherb̃aton. Ñeñt̃oʼmarña t̃eʼpaʼ oʼch nenuerrep̃ p̃ach necuam̃p̃sapreterreʼ ñeñt̃ atarr aton. T̃eʼña p̃apaʼ pebeʼt̃os allchaʼ atarr p̃ocshapreterrna.” ");
INSERT INTO ameNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Allempoñapaʼ ñeñt̃ agapueʼ ñam̃a epa mil, ñapaʼc̈hoʼ huapapaʼ apapuenan poʼpatronar poʼpoñ epa mil quelle. Ñapaʼc̈hoʼña atet̃ otapueñ: “Nomporchaʼ ñeñt̃ p̃apaʼnmuen nam̃a epa mil, napaʼc̈hoʼña ellocaʼye neganerrerrña pec̃llayorot̃ poʼpoñ epa mil quelle.” ");
INSERT INTO ameNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ñapaʼc̈hoʼña poʼpatronarpaʼ atet̃ och: “Eʼñe pocteʼ; p̃apaʼc̈hoʼña atarroʼt cohuen pesherbenen. P̃apaʼc̈hoʼña eʼñe cohuen petsoton ñeñt̃ atet̃ notnomuep̃. Amaʼt allponat̃olla napaʼnmap̃ ahuaña, p̃añapaʼ atarroʼt cohuen pesherb̃aton. Ñeñt̃oʼmarña t̃eʼpaʼ oʼch nenuerrep̃ p̃am̃a p̃ach necuam̃p̃sapreterreʼ ñeñt̃ atarr aton. P̃apaʼc̈hoʼña t̃eʼpaʼ pebeʼt̃os p̃am̃a allchaʼ atarr p̃ocshapreterrna.” ");
INSERT INTO ameNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Allempoñapaʼ huapa ñam̃a ñeñt̃ agapueʼ pat̃err mil quelle. Ñañapaʼ atet̃ otapueñ: “Napaʼ neñotenep̃ Nomporchaʼ. P̃apaʼ amacaʼye matsrreʼmñape; p̃apaʼ c̈hocmacaʼye peprratam̃pesyen amaʼt ñeñt̃paʼ ama p̃oyaye ñam̃a c̈hocmacaʼye p̃ocsechatyenña ñeñt̃ ama p̃ayeʼ nareʼtatyenaye; c̈hocma es p̃aʼyapac̈haʼyen amaʼt ñeñt̃paʼ amacaʼye p̃ayeʼ naʼyenaye. ");
INSERT INTO ameNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ñeñt̃oʼmarña napaʼ c̈ha nem̃chaʼtenep̃. Ñeñt̃oʼmarña ñeñt̃ p̃apaʼnmuen ahuaña pat̃err mil quellepaʼ nañapaʼ c̈ha nepamponap̃. T̃eʼñapaʼ oʼch alla napapuerrep̃ ñeñt̃ eʼñe p̃o.” ");
INSERT INTO ameNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Allempoña poʼpatronarpaʼ atet̃ och: “P̃aña poʼñoc̈hpaʼ amacaʼye cohuenayeʼ pesherbenno amaʼt mamesha; atarrcaʼye quellañtsop̃. Ñerraʼm eʼñe poʼñoc̈h peñotennoñ c̈hocma es neprratam̃pesyeneñ ñeñt̃ ama noyaye; ñerraʼm poʼñoc̈h c̈hocma nocsechatyeneñ ñeñt̃ ama nayeʼ nareʼtatyenaye; ñerraʼm poʼñoc̈h c̈hocma es naʼyapac̈haʼyeneñ ñeñt̃ ama nayeʼ naʼyenayñe, ñerraʼm eʼñe poʼñoc̈h atet̃ pentennoñpaʼ ");
INSERT INTO ameNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","esoʼmaruañacaʼye amaña bancoyeʼ penennanoña nec̃llayor allochñapaʼ t̃eʼña oʼ nehuerrapaʼ nagaphuerreñchaʼ ñam̃a allo atontatonet nec̃llayor.” ");
INSERT INTO ameNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Allempoñapaʼ atet̃ otan ñeñt̃ t̃omc̈haʼtyets all: “T̃eʼpaʼ c̈hosa puerratam̃perreʼña ñeñt̃ pat̃err mil quelle oʼch sapuer ñeñt̃ echeneʼ c̈harraʼ mil quelle.” ");
INSERT INTO ameNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ñeñt̃oʼmarña t̃eʼ napaʼ oʼch notas: Ñeñt̃ es echets shonteʼ eʼñe puesherb̃ateñot̃et pamoʼmteʼ, ñetña ellonet̃paʼ oʼch alla aparet̃terret poʼpoñ aton. T̃arraña ñeñt̃ ama es echetsopaʼ amaʼt allponat̃olla ñeñt̃ echyenetañ aprratam̃p̃saret̃terretchaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ñam̃a añ ataruasañer ñeñt̃ ama nesherbenaye, t̃eʼñapaʼ c̈hosaña huaporeʼteʼ aʼyot̃ checmetot̃. Allñapaʼ allchaʼ yahuanrrortenet panmueñot̃et atserrpaʼ rrasoʼtyesosetchaʼ paʼs.” ");
INSERT INTO ameNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Allempoch nohuerra na Ñeñt̃en Acheñetosets, nohuerrach eʼñe nepartsoteñohuen epan allohuen nem̃llañot̃eñnaneshar. Allempopaʼ nanorruerrchaʼ neconaño allchaʼña eʼñe nepartsotuerr eʼñe necohuenteñeshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Allempoñapaʼ eʼñech nesho apc̈herra allohuen paʼnamen acheñ ñeñt̃ yec̈haʼyetsa arr patsro. Allempochña nellopaʼtetstaterranet eʼñe atet̃ pena ñeñt̃ pamoʼmteʼ pen carrnero, ñañapaʼ oʼch ellopaʼtetstatenan carrneroc̈hno ñam̃a cabrac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Acheñeneshaʼña ñeñt̃ eʼñe cohuenpaʼ ñetñapaʼ necohuenrot̃chaʼ nenuerranet ñeñt̃ eʼñe atet̃ ñerraʼm carrneroc̈hno. Ñam̃a ñeñt̃ña ama cohuenayayepaʼ ñetñapaʼ neʼchcot̃erot̃ach nenuerranet ñeñt̃ eʼñe atet̃ ñerraʼm cabrac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Naña allempoch atarr naʼm̃chaʼtaret̃terrapaʼ, atet̃chaʼ noter ñeñt̃ necohuenront̃eʼtsaʼyen: “Sapaʼ sonac̈haʼt allohuenes t̃arroʼmar Nompor oʼcaʼye atarr bensareʼtam̃perres. T̃eʼña sapaʼ oʼch saguërr ñeñt̃ oʼpatatensa ahuat̃ot̃eñ. Amaʼt allempot̃eñ Nomporpaʼ errteʼ yec̈hcateneʼ pats sañapaʼ allempot̃eñ oʼpatatasa att̃och saʼm̃chaʼtaret̃tapretera. ");
INSERT INTO ameNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","T̃arroʼmar napaʼ allempo nachporreʼt̃paʼ sacaʼyeña nerratallmeʼchayeʼt̃. Allempo noʼñpaʼteʼt̃paʼ sacaʼyeña nonayesayeʼt̃. Allempo nec̈hapueʼt̃ sesho all ama nentare sañapaʼ c̈hocma eʼñe cohuen sagapneʼt̃. ");
INSERT INTO ameNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Allempo nemuelleʼt̃paʼ sacaʼyeña nepashtayeʼt̃. Allempo natsnaʼteʼt̃paʼ sañapaʼ c̈hocma secuam̃pesneʼt̃. Allempo yottam̃pesneteʼt̃paʼ sacaʼyeña eʼñe cohuen nemoʼtayeʼt̃.” ");
INSERT INTO ameNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Allempoña ñeñt̃ eʼñe cohuen es nep̃aʼyesayeʼt̃paʼ ñetñapaʼ atet̃chaʼ oterrnet: “Taʼm Partseshachaʼ, ¿esempoʼtña yentapeʼt̃ allempo p̃achporreʼt̃ allempo yerratallmeʼchapeʼt̃? ¿Esempoʼtña yentapeʼt̃ allempo p̃oʼñpaʼteʼt̃ allempo yonapeʼt̃? ");
INSERT INTO ameNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Esempoʼtña yentapeʼt̃ allempo pec̈hapueʼt̃ yesho all ama pentare allempo eʼñe cohuen yagapapeʼt̃? Taʼm ¿esempot̃eʼña yentapeʼt̃ allempo pemuelleʼt̃ allempo yepashtapeʼt̃? ");
INSERT INTO ameNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Esempoʼt yentapeʼt̃ña allempo p̃atsnaʼteʼt̃ ñam̃a allempo yottam̃p̃sapeteʼt̃ allempo yemoʼtapeʼt̃?” ");
INSERT INTO ameNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Allempoña na ñeñt̃en Partseshanpaʼ atet̃chaʼ noterres: “T̃eʼ napaʼ oʼch notas: Poʼñoc̈hpaʼ allempo eʼñe cohuen atet̃ sep̃aʼyesnaneʼt̃ na nemoʼnasheñneshaʼ naʼnacaʼyeña eʼñe cohuen atet̃ sepen. Amaʼt puesheñarra ñeñt̃ ama esosheʼmayeʼ entyeseʼt̃e acheñeneshaʼ allempo, t̃arraña saña allempopaʼ att̃o eʼñe cohuen es sep̃aʼyesaneteʼt̃, naʼnacaʼyeña eʼñe cohuen atet̃ sepen allempo.” ");
INSERT INTO ameNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Allempoña ñeñt̃ neʼchcot̃eront̃eʼtsenpaʼ atet̃chaʼ noterranet: “Sapaʼ orrerres arrot̃, sapaʼ aña soʼpatenaya ñeñt̃ atarr yoroc̈hen. T̃eʼñapaʼ orras all huorten tsoʼ errap̃aren ñeñt̃ ama amayaño amaʼt errponaña. Ñeñt̃ña tsorpaʼ añ oʼpatateñet oneñet̃ eʼñe pueyochreshohuen. ");
INSERT INTO ameNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","T̃arroʼmar na allempo nachporreʼt̃paʼ sapaʼ amacaʼye sayeʼ nerratallmeʼchayeʼt̃e. Allempo noʼñpaʼteʼt̃paʼ amacaʼ sayeʼña nonayeʼt̃e. ");
INSERT INTO ameNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Allempo nec̈hapueʼt̃ sesho all ama nentare sapaʼ amacaʼye cohuenayeʼ sagapneʼt̃e. Allempo nemuelleʼt̃paʼ sapaʼ amacaʼye sayeʼ nepashtayeʼt̃e. Allempo natsnaʼteʼt̃ amaʼt ñam̃a allempo yottam̃pesneteʼt̃paʼ sañapaʼ amacaʼye semoʼtneʼt̃e.” ");
INSERT INTO ameNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Allempoña ñetpaʼ atet̃chaʼ oterrnet: “¿Esempohuañacaʼye, Partseshachaʼ, yentapeʼt̃ allempo p̃achporreʼt̃ ñam̃a allempo p̃oʼñpaʼteʼt̃ ñam̃a allempo pec̈hapueʼt̃ yesho all ama pentare ñam̃a allempo pemuelleʼt̃ ñam̃a allempo p̃atsnaʼteʼt̃, ñam̃a allempo yottam̃p̃sapeteʼt̃? ¿Esempoʼtña yentapeʼt̃ atet̃ allempo yapaʼ amaʼt coñeʼt̃apaʼ ama es yapapeʼt̃e?” ");
INSERT INTO ameNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Allempoña napaʼ atet̃chaʼ noterranet: “T̃eʼpaʼ oʼch notas: Poʼñoc̈h sa allempo ama aʼcuaʼp̃senayeʼ sentoneʼt̃e allohuen na nemoʼnasheñneshaʼ, naʼnacaʼyeña atet̃ senteʼt̃ña allempo.” ");
INSERT INTO ameNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Allempoña acheñeneshaʼ ñeñt̃ neʼchcot̃eront̃eʼtsen, ñetñapaʼ ahuanerretchaʼ allchaʼ coñcherret eʼñe errponohuañen. Añña ñeñt̃ eʼñe cohuen es p̃aʼyestseʼt̃ ñetñapaʼ ahuanerretchaʼ Yomporesho allña ñetpaʼ corretsetach pocsheñeshocmañen errponañohuen. ");
INSERT INTO ameNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesúsñapaʼ allempo serrpareʼtatuahuanet allohuen añ ñoñetspaʼ allempoñapaʼ atet̃ otan pueyochreshaʼ: ");
INSERT INTO ameNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Sapaʼ señoteñ oʼcaʼye epomtam̃apaʼ oʼch c̈hapaʼmuen pascuapo. Allempoña na Ñeñt̃en Acheñetosetspaʼ allempochña pomuerrnet att̃ot̃chaʼña corsoʼtam̃perrnet. ");
INSERT INTO ameNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Allempoña allohuen judioneshaʼ paʼm̃chaʼtaret̃erneshaʼ ñetñapaʼ apc̈het. Añ apc̈hatsa allohuen ñeñt̃ judioneshaʼ poʼcornaneshar paʼm̃chaʼtaret̃erneshaʼ epuet ñam̃a ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ epuet ñam̃a ñeñt̃ pomporneshaʼ pen allohuen judioneshaʼ. Ñetñapaʼ arr apc̈henet corneshaʼ paʼpacllo, ñeñt̃ña corneshaʼpaʼ ñacaʼyeña atarr nanac paʼm̃chaʼtaret̃er penet, ñeñt̃paʼ añ paʼsoʼcheñ Caifás. ");
INSERT INTO ameNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Allña ñetpaʼ cot̃apeʼchatannenet, Jesúsa atarr oʼpatenet. Ñetñapaʼ atet̃ otannaʼtyeset: —Errot̃uachcaʼye yepeʼt̃eʼ att̃och yeshcach eʼñe aʼnahua eshecchaʼ yerrmach att̃ot̃chaʼ yemtsatach. ");
INSERT INTO ameNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ñetña allempopaʼ alla otannaʼtyerreterr: —T̃arraña t̃eʼ pascuapo allempo shontena acheñeneshaʼ amachcaʼye yerrmatsche allañacaʼye c̈ha yatsrreʼmoc̈htateñ acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Pamt̃arrña Jesúspaʼ Betanioʼtsen all Simón paʼpacllo, ñeñt̃ña Simónpaʼ ñeñt̃ oseʼt̃ puetsarñats. ");
INSERT INTO ameNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jesúsñapaʼ alla anen all rrallmeʼchen. Allñapaʼ huapoña puesheñarr coyaneshaʼ, huapatan eñmosat̃ ñeñt̃ ama matsaʼto; huapatam̃pes puetellm̃o ñeñt̃ña puetellem̃paʼ añ socheñet alabastro. Ñeñt̃ña eñmosat̃paʼ alla sheʼ Jesús poño. ");
INSERT INTO ameNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pueyochreshac̈hnoña ñetña eñchetpaʼ c̈ha atsrreʼmuet, atet̃ otyeset: —Esoʼmareʼtña att̃a aʼpertatosanña eñmosat̃. Ñeñt̃ eñmosat̃erpaʼ amacaʼye matsaʼto. ");
INSERT INTO ameNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","C̈hochñac̈hoʼ pomoseñpaʼ ganañchaʼ shonteʼ quelle allempoñapaʼ apaʼyesaneñchaʼ ñam̃a allohuen huocchañneshac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesúsña eʼmanetpaʼ ñañapaʼ atet̃ otanet: —Esoʼmareʼtchaʼ c̈ha mueneʼ satsrreʼmoc̈htanaʼtap̃ña coyaneshaʼ. Ñapaʼ atarrcaʼye cohuen p̃osen. ");
INSERT INTO ameNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","T̃arraña amaʼtchaʼ c̈ho pomosaneñ eñmosat̃ alloch es apaʼyesaneñ huocchañneshac̈hno, t̃arraña c̈hocmachcaʼye eñallña huocchañneshac̈hno arr patsro. Nañapaʼ poʼñoc̈hpaʼ amachcaʼye alloʼna sentenno arr patsro. ");
INSERT INTO ameNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ñeñt̃ att̃o shosnan t̃eʼ eñmosat̃ nechtso, ñeñt̃paʼ añecpaʼnacaʼye sherben t̃arrempohua allempoch aʼyanaʼterrneterr ñeñt̃chaʼ epuet pampaʼpesnet. ");
INSERT INTO ameNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Poʼñoc̈hcaʼye notenes: Ora erracmañen añ patsro errach serrpareʼtatyenet añ cohuen ñoñets allempopaʼ serrpareʼchetchaʼ ñam̃a atet̃ penen t̃eʼ añ coyaneshaʼ, att̃ochña ñaʼnach yerpuenet. ");
INSERT INTO ameNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Allempoña pueyochreshaʼ ñeñt̃ c̈harraʼ puechetsa epsheña, puesheñarrña ñeñt̃ paʼsoʼcheñ Judas Iscariote, ñañapaʼ allent̃a ahuoʼ alloʼtsaʼyen ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ p̃aʼyen allohuen judioneshaʼ poʼcornaneshar. ");
INSERT INTO ameNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","C̈hap allpaʼ ñañapaʼ atet̃ otosanet: —Ñerraʼm oʼch negatas Jesús att̃och serrmueʼpaʼ ¿errponaʼtchaʼña setsaʼtna? Ñetñapaʼ atet̃ ochet: —Oʼchcaʼye yapap̃ maʼpoch c̈harratlla quelle. ");
INSERT INTO ameNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Allempoña ñapaʼ aña eʼñe cot̃apeʼchyen errot̃enot̃chaʼ pomuerranña Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Allempoña c̈hapaʼmuen ñeñt̃ yet̃ñatsro allempoch rrerreterr pan ñeñt̃ ama anaret̃eyaye chaseʼ. C̈hapaʼmuen ñeñt̃ yet̃erpaʼ Jesúsñapaʼ huac̈haʼtoña pueyochreshaʼ ñetñapaʼ atet̃ otoset: —T̃eʼpaʼ ¿erraʼt pemneñ allchaʼ yaʼpotonap̃ ñeñt̃chaʼ perraʼ pascuapo? ");
INSERT INTO ameNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ñañapaʼ atet̃ otanet: —T̃eʼpaʼ oʼch ahues anetso; oʼch sec̈hap alloʼtsen puesheñarr acheñ. Ñeñt̃paʼ atet̃chaʼ sotos: “Ñeñt̃ña Maestro Jesúspaʼ atet̃caʼye oten: ‘T̃eʼpaʼ oʼ c̈hapmoch allempoch nerroma, t̃eʼ pascuapopaʼ arrchaʼ nerraʼnom pepacllo neyochreshohuen.’ ” ");
INSERT INTO ameNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Atet̃ otanet Jesúspaʼ ñetñapaʼ atet̃c̈hoʼ pet. Allcaʼyeña aññoʼtosñañetña rreñets allchaʼ rrallmeʼchet. ");
INSERT INTO ameNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Oʼña ellerrotenapaʼ Jesúsñapaʼ anorros allchaʼ rrallmeʼchatnenan pueyochreshaʼ ñeñt̃ c̈harrasheña puechena epsheña. ");
INSERT INTO ameNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Allña rrallmeʼchetsetpaʼ Jesúsñapaʼ atet̃ otanet: —Poʼñoc̈hcaʼye notenes: Puesheñarrot̃es sa ñeñt̃eschaʼcaʼye nepomuerreʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ñetñapaʼ c̈ha atarr llecaʼrrtet. Aʼp̃t̃oʼtyeset eʼñe puesheñaʼttset: —Partseshachaʼ taʼm ¿amat̃eʼ na nepomuerrmochape? ");
INSERT INTO ameNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ñañapaʼ atet̃ oterraneterr: —Ñeñt̃ netsapechapreteneʼ nerrarpaʼ ñeñt̃chaʼcaʼyeña nepomuerreʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Poʼñoc̈hcaʼye t̃eʼpaʼ alloʼna sen etsotnomtsa ñeñt̃ atet̃ anuaret̃ Yompor poʼñoño nocop Ñeñt̃en Acheñetosets; att̃ot̃chaʼ muetsaterrnet. T̃arraña nocoppaʼ eʼñe pocteʼ; añña poʼñoc̈h acheñer ñeñt̃chaʼ nepomuerreʼ ñocopñapaʼ atarr llequëñets. Añ acheñerpaʼ eʼñecaʼye pocteñ ñocop amachñac̈hoʼ eñalletatstañe. ");
INSERT INTO ameNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judasña ñeñt̃chaʼ pomuerreʼpaʼ ñañapaʼ atet̃ och: —Maestrochaʼ taʼm ¿amat̃eʼ na nepomuerrmochape? Jesúsñapaʼ atet̃ och: —P̃at̃eʼcaʼye atet̃caʼ p̃oten. ");
INSERT INTO ameNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","All rrallmeʼchenet, Jesúsñapaʼ chetan pan parasyosoʼtan Pompor. Parasyosoʼtuepaʼ shotaʼtan panpaʼ apaʼyesan pueyochreshaʼ. Ñeñt̃paʼ atet̃ otanet: —Sagapyes oʼch serreʼ añmapaʼ ñeñt̃chaʼña nechets sepen. ");
INSERT INTO ameNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Allot̃ñapaʼ chetan ñam̃a orramets parasyosoʼtuerrerrpaʼ apaʼyerraneterr. Ñeñt̃paʼ atet̃ oterraneterr: —Sorr ñam̃a añ narmetsos allohuenes. ");
INSERT INTO ameNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Añpaʼ nerrascaʼye sepeñ ñeñt̃chaʼ ashataret̃tatsa shonteʼ acheñeneshacop alloch ap̃reʼtnaret̃terret poʼchñaret. Añ nerraspaʼ alloch eʼñe etserra aʼpoctaterra acheñeneshaʼ Apuesho. ");
INSERT INTO ameNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Napaʼ oʼch notas: T̃eʼpaʼ amach alla norrerreʼt̃e añ narmetsos t̃ayot̃eñ t̃arrempohuach allempoch alla ello yorrerrerr parro allempoch am̃chaʼtaret̃etuerra Apa. ");
INSERT INTO ameNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Allempoña oʼ morrechuanmuet Yomporecoppaʼ ahuaneneterr Olivop̃no. ");
INSERT INTO ameNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Allñapaʼ atet̃ otosanet Jesús: —Añ tsaprocmach sa allohuenespaʼ saʼypoʼñaʼhuanmuenchaʼ t̃arroʼmar Yompor poʼñoñopaʼ atet̃caʼye anuaret̃, ñeñt̃paʼ atet̃ oteʼt̃ Yompor nocop: “Oʼch nemtsater ñeñt̃ cohuam̃peneʼ carrnero, poʼcarrnerorñapaʼ c̈hach matrraʼtyesa allemeñ.” ");
INSERT INTO ameNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Jesúsñapaʼ atet̃ oterraneterr: —T̃arraña esempoch alla netanterra napaʼ nanomchaʼ oterrtsa Galileo. ");
INSERT INTO ameNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Allempoña Pedropaʼ atet̃ och: —Amaʼt allohuenet ñerraʼm aʼypoʼñaʼhuerrpetchaʼpaʼ naña amaʼt ahuat̃apaʼ amach naʼypoʼñerrpe. ");
INSERT INTO ameNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesúsñapaʼ atet̃ otererr: —Poʼñoc̈hcaʼye oʼch notap̃, añe tsaprocma amach eñenaʼ atolloppaʼ p̃añapaʼ oʼch maʼpoch p̃aʼnasotenna. ");
INSERT INTO ameNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedroñapaʼ alla otererr: —Amaʼtchaʼ yerromhuanen parropaʼ nañapaʼ amaʼt parrocha amach naʼnasotap̃o. Allohuen pueyochreshaʼpaʼ ñetpaʼc̈hoʼña eʼñe att̃ecma otyeñetañ ñamet. ");
INSERT INTO ameNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Allot̃ñapaʼ c̈hap Jesús pueyochreshohuen all narmetsm̃o, ñeñt̃paʼ añ paʼsoʼcheñ Getsemaní. Allñapaʼ otosanet: —T̃eʼ sapaʼ allach sanorrc̈haʼtos arrma, napaʼ oʼch nemaʼyochenaʼ t̃arront̃eyeʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Allñapaʼ aña anmos Pedro ñam̃a Zebedeo puechemereshaʼ, epsheña. Jesúsñapaʼ c̈ha nanac llequëna, nanac allpatena. ");
INSERT INTO ameNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Allempoñapaʼ atet̃ otosanet: —Napaʼ c̈ha chepoc̈henen nellquëña neyoc̈hro, c̈ha mueneʼ nerromuen nellquëñot̃. Sapaʼ allasaʼt̃ach arr secuapretosnoʼt̃ach. ");
INSERT INTO ameNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ñañapaʼ ahuoʼ aʼyent̃eyeʼ all rremosa patso atet̃ maʼyochosa: —Apa, ñerraʼm errot̃enot̃paʼ arepaʼchña pemnatatsche oʼch c̈hapona ñeñt̃ atarr amueroc̈htatañ nenten. T̃arraña ñerraʼm p̃ach muenats añepaʼchña atet̃ pep̃aton ñeñt̃ pemnen p̃a, amachña añeyaye ñeñt̃ nemnen na. ");
INSERT INTO ameNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Oʼña atet̃ maʼyochuapaʼ oʼ ahuerr alloʼtsaʼyen pueyochreshaʼ maʼpsheña. Oʼ c̈herr allpaʼ alla entuerranet ñetñapaʼ c̈ha atarr manrrenet. Allempoñapaʼ otuerran Pedro: —Amaʼt mamesha areʼtchaʼña acuenayeʼ sentoso. Amahuachñacaʼ secuapretosnot̃eʼ amaʼt mamesha. ");
INSERT INTO ameNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Eʼñe señoseʼrteñot̃paʼ c̈hoña semaʼyochosa allochñapaʼ att̃och amach sañeña aʼpuerrataterro topateñets ñeñt̃chaʼ sehuapoya atarr huomenc. Ñeñt̃paʼ amaʼt atarr semneñeñ t̃arraña sechetsñapaʼ amacaʼye ahuamencat̃eyeʼ penso, ñeñt̃oʼmarña notenes c̈hocmach semaʼyochena. ");
INSERT INTO ameNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesúsñapaʼ alla ahuerrerr puepocheño oʼch maʼyocherrerr, ñeñt̃ara atet̃ otuerrerr: —Ñerraʼm Apachaʼ aña pemnaten oʼch c̈hapona ñeñt̃chaʼ atarr naʼmueroc̈htateʼ, ñerraʼm ama errot̃enot̃ p̃aʼhuañatam̃perrno, ñeñt̃paʼ eʼñe pocteʼ. Añepaʼchña atet̃ pep̃aton ñeñt̃ pemnen p̃a. ");
INSERT INTO ameNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Oʼña alla maʼyochuerrerrpaʼ allempoñapaʼ huerrerr alla entuerranerr pueyochreshaʼ ñetñapaʼ oʼ alla manrrerreterr, c̈ha nanac atserr moñeʼtenet. ");
INSERT INTO ameNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jesúsñapaʼ alla saʼnerraneterrpaʼ ahuerrerr maʼyochatsa pomaʼpocheñohua. Eʼñe att̃ecma maʼyochuerrerr atet̃ otua ñorraʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Oʼña maʼyochuerrapaʼ allempoñapaʼ alla huerrerr pueyochreshesho, atet̃ otuerraneterr: —Amaʼt t̃emeʼttsenpaʼ allaʼt semanrren; amaʼtpaʼ alla sames. T̃eʼpaʼ señochepaʼch oʼ c̈hap allempoch pomataterrnet na Ñeñt̃en Acheñetosets att̃ot̃chaʼ errot̃uanen perren ñeñt̃ atarr ochñat̃eneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","T̃eʼñapaʼ setanterra oʼch ahuey oʼch yepocteʼ. Secueʼcaʼye ñeñt̃chaʼ nepomueʼ ñeñt̃paʼ allaʼtsena. ");
INSERT INTO ameNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","All atet̃ eñorena Jesúspaʼ c̈ha huapatsa puesheñarr ñeñt̃ pueyochreshaʼ peneñ ñeñt̃ aʼpchenahuet epsheña, ñeñt̃ñapaʼ añ Judas. Ñañapaʼ huac̈haʼtatan shonteʼ acheñeneshaʼ occhellet̃areret ñam̃a etsachperet̃areret. Ñehua, añ ñeñt̃ huac̈haʼttsapaʼ añ mueñenahuet ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar ñam̃a ñeñt̃ pomporneshaʼ pen allohuen judioneshaʼ. Ñetcaʼyeña mueñeneʼña ñeñt̃chaʼ rremuenayaʼ Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ñehua, Judas ñeñt̃ pomuerreʼ Jesúspaʼ ñañapaʼ atet̃ otnoman acheñeneshaʼ ñeñt̃ anom att̃och chemeʼtoset Jesús. Ñeñt̃paʼ atet̃ otnomanet: —Erraʼtsenchaʼ nehuom̃chaʼtos eʼñe netsoʼtstsapaʼteñot̃paʼ ñeñt̃caʼyeña Jesús. Sañapaʼ ñeñt̃chaʼña serrmos. ");
INSERT INTO ameNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Allempoña huapapaʼ c̈ha ponmosaya Jesús huom̃chaʼtos eʼñe puetsoʼtstsapaʼteñeshaʼ atet̃ otos: —Tsapo, Maestrochaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesúsñapaʼ atet̃ otap̃: —Esoʼmaruañacaʼ masheñe, penña arr nesho. Allempoña acheñeneshaʼpaʼ ponmosyet Jesúspaʼ rromoset eʼñe poʼhuamencocma. ");
INSERT INTO ameNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Allempoña puesheñarr ñeñt̃ epuet Jesúspaʼ ñañapaʼ poʼcchella chetaʼpaʼ oʼch c̈hontoʼtapaneñ corneshaʼ pueñañra, puetepaʼtchaʼ tsorroñ. Ñeñt̃paʼ año pueñañra ñeñt̃ paʼm̃chaʼtaret̃er pen allohuen judioneshaʼ poʼcornaneshar. ");
INSERT INTO ameNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Allempoña Jesúspaʼ atet̃ och: —Penerr alla p̃occhell allecma peneñ. Allohuen ñeñt̃ orrotetsa poʼcchellopaʼ cochllochcaʼye collaʼhuerret. ");
INSERT INTO ameNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","P̃apaʼ c̈hat̃eʼ p̃otenapañ amat̃eʼ errot̃enot̃ es nenameña Nompor. Amaʼt peñoteñe ñerraʼm c̈ho nenam̃paʼ ñapaʼ allorocmach mueñoneñ shonteʼ nanac poʼm̃llañot̃eñnaneshar ñeñt̃chaʼ nemoñsayañ, ");
INSERT INTO ameNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","t̃arraña ñerraʼm atet̃ nep̃apaʼ amat̃eʼ errot̃enot̃ etsotoña ñeñt̃ atet̃ anuaret̃ Yompor poʼñoño nocop. Allña oten ñeñt̃paʼ atet̃chaʼcaʼye perra. ");
INSERT INTO ameNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Allempoña Jesúspaʼ atet̃ otan acheñeneshaʼ: —Esoʼmareʼt sehuac̈haʼtennanaña eʼñe occhellet̃areroches ñam̃a etsachperet̃areroches att̃och serrmaʼn. Napaʼ ¿eʼñeʼt atet̃ sentenen ñerraʼmrrat̃eʼ eñet̃en? Oʼ allponmatuanen nanorryen Parets paʼpaclloʼmar, all neyc̈hatyen, esoʼmareʼtña ama allempocmaña serrmaʼneʼt̃e. ");
INSERT INTO ameNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Amaʼtpaʼ att̃epaʼcaʼye perra allochñapaʼ att̃och eʼñe etsotuerra ñeñt̃ allpon quellcaʼyeseʼt̃ nocop ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ. Allempoña allohuen pueyochreshaʼpaʼ allorocma aʼypoʼñaʼhuanmet, ñetñapaʼ yetrraʼtuet. ");
INSERT INTO ameNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Acheñeneshaʼ ñeñt̃ rromoseʼ Jesúspaʼ ñetñapaʼ anmet alloʼtsen Caifás ñeñt̃ paʼm̃chaʼtaret̃er pen allohuen judioneshaʼ poʼcornaneshar. Allñapaʼ all apc̈henet parro allohuen ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ epuet ñam̃a ñeñt̃ pomporneshaʼ pen allohuen judioneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedroñapaʼ cot̃aʼnmanet t̃arraña ñapaʼ chentaʼ en aʼyot̃. Eʼñe corneshaʼ poʼpampohua allñapaʼ anorros epuet ñeñt̃ guardianeshaʼ allochñapaʼ eshecchaʼ entan Jesús att̃och errot̃uanenchaʼ pet. ");
INSERT INTO ameNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Cornaneshaʼña paʼm̃chaʼtaret̃erneshaʼ ñam̃a ñeñt̃ pomporneshaʼ pen allohuen judioneshaʼ ñam̃a allohuen ñeñt̃ aʼpoctatyeneʼ ñoñets ñocpuet ñetñapaʼ aña atarr eʼnenet ñeñt̃chaʼ tomaʼtam̃p̃seʼ Jesús allochñapaʼ att̃och muetsatachet. ");
INSERT INTO ameNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Amaʼt shonteʼ huapatsañ ñeñt̃chaʼ tomaʼtam̃p̃sosayeñpaʼ am̃chaʼtaret̃neshaʼña amaʼt puesheñarrot̃etapaʼ ama eseshayeʼ entayeña att̃och muetsatachet. Att̃eñapaʼ huapa ñam̃a epsheña ñeñt̃chaʼ tomaʼtam̃p̃seʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ñetñapaʼ atet̃ otoset: —Añ acheñer ahuañapaʼ atet̃caʼye oten: “Napaʼ atarr ahuamencat̃en att̃och naʼmaterrñañ Parets paʼpaquëll. Allot̃ña pomaʼpamtañopaʼ oʼch alla nat̃omater.” Ñapaʼ atet̃caʼye otña allempo. ");
INSERT INTO ameNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Allempoñapaʼ corneshaʼ ñeñt̃ nanac am̃chaʼtaret̃ allent̃a t̃ompaʼ atet̃ otan Jesús: —P̃añapaʼ ¿amaʼtchaʼña p̃anapaneto? ¿Errot̃enot̃eʼtña otteñeʼchenpet? ");
INSERT INTO ameNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesúsñapaʼ ama eñoreno. Allempoña corneshaʼpaʼ alla otererr: —T̃eʼpaʼ oʼch notap̃ oʼch p̃otey eʼñe Yompor paʼsoʼchño ñeñt̃ ama arromñat̃eshayaye, p̃apaʼ ¿p̃aʼtña ñeñt̃ep̃ Parets Puechemerep̃, ñeñt̃ep̃t̃eʼ Cristotosets? ");
INSERT INTO ameNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesúsñapaʼ atet̃ och: —Napaʼ poʼñoc̈hcaʼye ñeñt̃en eʼñe atet̃ p̃oten. Elloña napaʼ oʼchcaʼye notas, oʼcaʼye eʼñe c̈hapmoch allempoch eʼñe senterren na Ñeñt̃en Acheñetosets oʼchcaʼye alla nanorruerr Parets poʼcohuenrot̃ allchaʼ nepartsotapretera. Ñam̃a poʼpocheño oʼch sentapuerren oʼch nesuam̃perra oso Yompor pueʼntañot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Corneshaʼñapaʼ ñeñt̃a eʼmpaʼ allent̃a rrarreʼtan paʼshtam eʼñe patsrreʼmueñot̃, ñeñt̃paʼ atet̃ ot: —Oʼcaʼye c̈ha achm̃areʼtanña Yompor. Ñeñt̃epñapaʼ amach yeʼnatsche poʼpsheñeñ ñeñt̃chaʼ aʼmet̃am̃p̃soseʼ. T̃eʼ amaʼt sapaʼ oʼcaʼye seʼm̃ atet̃ achm̃areʼtenan Yompor. ¿Errot̃enaʼt senteñña sa? ");
INSERT INTO ameNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ñetñapaʼ atet̃ otyeset: —Ña poʼñoc̈hpaʼ atarrcaʼye nanac achm̃areʼtenan Yompor, pocteʼñac̈hoʼ t̃eʼpaʼ oʼch semtsatach. ");
INSERT INTO ameNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Allempoñapaʼ aʼcoshareʼtyeset eʼñe paʼclloyot̃, c̈hoʼña c̈hotaʼtyeset; poʼpotantañec̈hnoñapaʼ tacllapechyeset. ");
INSERT INTO ameNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Pachm̃areʼteñot̃etpaʼ atet̃ otyeset: —T̃eʼña ñerraʼm poʼñoc̈ht̃eʼ Cristop̃paʼ eñoratenperrepaʼ Parets allochñapaʼ att̃och p̃otey eseshaʼt̃eʼña pec̈hotaʼtyeneʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedropaʼ aʼyot̃eʼtsen all anen pampo. Allñapaʼ huapoña coyaneshaʼ ñeñt̃ corneshaʼ pueñañra, ñañapaʼ atet̃ otosan Pedro: —P̃acaʼye eʼñe cot̃ayeʼt̃ña Jesús ñeñt̃ galileoʼmarneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedroñapaʼ anapueʼpaʼ c̈ha aʼnasocha. Allohuenetñapaʼ eʼñe eʼmhueñet atet̃ ot: —Napaʼ amacaʼye neñoteñe ñeñt̃ atet̃ p̃otenen. ");
INSERT INTO ameNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Allempoña Pedropaʼ ahuerr, c̈herr allot̃ecma beʼt̃enet oʼch c̈hapuet oʼpono pampo. Allñapaʼ entuererr poʼpsheñeñ coyaneshaʼ ñeñt̃ corneshaʼ pueñañra. Ñañapaʼ atet̃ otan ñeñt̃ parro alloʼtsaʼyenet: —Añ acheñerpaʼ ñeñt̃caʼye cot̃eneʼña Jesús ñeñt̃ nazaretoʼmarneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedroñapaʼ alla aʼnasotererrpaʼ atet̃ oterrerr: —T̃eʼ napaʼ oʼch notas eʼñe Yompor paʼsoʼchño, napaʼ amacaʼye nentareña añ yacmar ñeñt̃ p̃otenen. ");
INSERT INTO ameNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Oʼña oʼchterrerrpaʼ huapoña ñam̃a ñeñt̃ t̃omc̈haʼtyets all, ñetpaʼc̈hoʼña atet̃ otoset: —Poʼñoc̈hcaʼye p̃apaʼ Jesúscaʼye pueyochreshap̃. Eʼñe atet̃ peñen ñerraʼmrrat̃eʼ galileoʼmarneshaʼ, ñeñt̃oʼmarcaʼyeña oʼ yeñotap̃. ");
INSERT INTO ameNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Allempoña Pedropaʼ eʼñe pueshquëñot̃anetpaʼ att̃a otatseʼtyerraneterr, ñeñt̃paʼ atet̃ otanet: —Napaʼ eʼñe Yompor paʼsoʼchño notenes, ñerraʼm amat̃eʼ poʼñoc̈hoyeʼ notensopaʼ t̃eʼpaʼ nerromuepaʼ. Napaʼ poʼñoc̈hcaʼye ama nentareña añ yacmar. Ñeñt̃a otuanetpaʼ eʼñepaʼtchaʼ allempocma eñenña atollop. ");
INSERT INTO ameNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Allempoña Pedropaʼ alla yerpuerrana ñeñt̃ atet̃ oteñ Jesús: “Amach eñenaʼ atollop p̃añapaʼ oʼch maʼpoch p̃aʼnasotenna.” Allempoña Pedro c̈haʼnom allot̃paʼ ahuoʼ aʼyenet̃ allñapaʼ all atarr yahuosa huomenc. ");
INSERT INTO ameNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tsapat̃ña puetarenpaʼ ñeñt̃ña paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar ñetñapaʼ apc̈haʼmueneterr parro epuet ñeñt̃ pomporneshaʼ pen judioneshaʼ. Allña apc̈henetpaʼ ñetña allohuenetpaʼ cot̃apeʼchatannaʼtet att̃ot̃chaʼ muetsatateret Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jesúsñapaʼ oʼ huancotaʼtuet allempoñapaʼ anmaʼmueñet alloʼtsen am̃chaʼtaret̃ Poncio Pilato (ñeñt̃ nen gobierno Romot̃ ñeñt̃ am̃chaʼtaret̃tetsa alloʼmarneshacop). Allcaʼye pomaʼmueñetña Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judasña ñeñt̃ pomueʼ Jesúspaʼ allempoña ñapaʼ eñoch Jesúspaʼ c̈hochcaʼye muetseret. Allempoña puellquëñot̃paʼ ello alla cot̃apeʼcherran cohuen. Allempo atet̃ cot̃apeʼcherrpaʼ ñañapaʼ alla pomuerran quelle maʼpoch c̈harratlla. Alla apuerranaʼ cornaneshaʼ paʼm̃chaʼtaret̃erneshaʼ ñam̃a ñeñt̃ pomporneshaʼ pen allohuen judioneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Allñapaʼ atet̃ otuerranet: —Napaʼ oʼ c̈ha norrtaterr ñeñt̃ ama cohuenayaye, oʼcaʼye c̈ha nepomuer acheñ att̃och muetseret amaʼt ñapaʼ amaʼt coñeʼt̃a amacaʼye eñalleña poʼchñar. Ñetñapaʼ atet̃ anaprraʼtet: —Ñeñt̃paʼ amacaʼye errot̃enoña yocop, ñeñt̃paʼ p̃ocpacaʼye. ");
INSERT INTO ameNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Allempoña ñapaʼ att̃a huaporeʼterranaʼ quelle oʼpono Parets paʼpacllopaʼ oʼ alla ahuerr, eʼñe puellquëñot̃paʼ tsom̃aʼhuerra ñañeña. ");
INSERT INTO ameNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Cornaneshaʼñapaʼ oʼ alla cheterret quelle. Ñetñapaʼ atet̃ otannaʼtyeset. —Añ quellepaʼ allocaʼye atsaʼtaret̃ta att̃och shataterrñañet acheñ poʼrras. Ñeñt̃oʼmarña t̃eʼpaʼ amat̃eʼcaʼye pocteyaye oʼch alla yenererr allecma apc̈henet quelle Parets paʼpacllo. ");
INSERT INTO ameNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Allempoña eʼñe ñagattsetapaʼ atet̃ aʼpoctachet oʼch rañt̃oñet allo añ poʼpatseñ ñeñt̃ yec̈hcatyeneʼ patsrroʼ allochñapaʼ allchaʼ pampaʼyeret amaʼt erraʼtsena acheñer ñeñt̃ ahuapña ñerraʼm esempo rromayenet allampaño. ");
INSERT INTO ameNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ñeñt̃oʼmarña ñeñt̃ patserpaʼ añ sochet Errasatsotnanen t̃arroʼmar ñeñt̃e quellayero rañt̃yet allo ashataret̃terra errasats. Amaʼt t̃emeʼttsen ñeñt̃ patser socheñet Errasatsotnanen. ");
INSERT INTO ameNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Att̃ocaʼyeña etsotaña atet̃ oteʼt̃ Jeremías ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ ahuat̃, ñeñt̃paʼ atet̃caʼye quellquëʼt̃ Cristocop: “Cheterretchaʼ ñeñt̃ maʼpoch c̈harratlla quelle ñeñt̃ allpon poʼtsaʼ nen israelenaʼtarneshaʼ att̃o muetsatateret. ");
INSERT INTO ameNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ñeñt̃ña quellepaʼ allochcaʼye rañt̃errñañet poʼpatseñ ñeñt̃ yec̈hcateneʼ patsrroʼ. Atet̃caʼye otenenña Partseshaʼ oʼch atet̃ nep̃a.” ");
INSERT INTO ameNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Allempo c̈hapachet Jesús am̃chaʼtaret̃ Pilatesho, allñapaʼ all am̃chaʼtaret̃ñapaʼ allent̃a aʼp̃t̃oʼtap̃: —P̃apaʼ ¿p̃aʼtña am̃chaʼtaret̃tetsaña judioneshacop? Jesúsñapaʼ atet̃ och: —Napaʼ ñeñt̃encaʼye atet̃ p̃oten. ");
INSERT INTO ameNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen judioneshaʼ poʼcornaneshar ñam̃a ñeñt̃ pomporneshaʼ pen allohuen judioneshaʼ ñetña allpaʼ atarr otteñeʼchyesoset Jesús. Ñañapaʼ amaʼt mameshapaʼ ama eñoreno, amaʼt parrocha ama anapuenaneto ñeñt̃ att̃o aʼmet̃areʼteñet. ");
INSERT INTO ameNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Allempo Pilatopaʼ atet̃ och: —¿Amaʼt peʼmuenoña atet̃ aʼmet̃areʼtenpetpaʼ esocmañen otenpet? ");
INSERT INTO ameNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ñañapaʼ ama anapuenaneto amaʼt eʼñe parrocha. Ñeñt̃oʼmarña am̃chaʼtaret̃paʼ nanac cohuanaʼteñ. Ama eñoteñeto esoʼmart̃eʼ ama eñoreno ñocop. ");
INSERT INTO ameNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ñehua, ñetpaʼ atet̃caʼye yec̈henet. Eʼñe pat̃eʼtets char allempoch c̈herrerr pascuapo, ñeñt̃ña am̃chaʼtaret̃ ñeñt̃ nen gobierno Romot̃paʼ ñañapaʼ c̈hocmach aʼrroyerran puesheñarr judioneshacop ñeñt̃ ayottam̃p̃saret̃tetsa allempo, ñeñt̃ara ñeñt̃ pamoʼts penet ñet. Oʼch apanet erraʼtsenc̈hoʼ enamuenet ñeñt̃ muenenet ñet. Ñeñt̃paʼ añecop aʼrroyenanetña puesheñarr pamoʼtset att̃och eʼñe cohuen coshatenan allohuen judioneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ñam̃a eʼñe allempopaʼ alloʼtsen puesheñarr judioneshaʼ ñeñt̃ ayottam̃p̃saret̃tetsa ñeñt̃paʼ añ paʼsoʼcheñ Barrabás. Allohuenetpaʼ eʼñe eñotueñet añecopña yottam̃peñet ñapaʼ c̈hocma at̃pareʼtaneʼt̃ am̃chaʼtaret̃ ñeñt̃ nen gobierno Romot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ñeñt̃oʼmarña allempo apc̈haʼhua allohuen acheñeneshaʼpaʼ am̃chaʼtaret̃ña Pilatopaʼ aʼp̃t̃oʼtapanet: —¿Erraʼtsenaʼt semnenña ñeñt̃chaʼ naʼrroyonas, ñatoʼ añchaʼ Barrabás amapaʼ Jesús ñeñt̃ otenet Cristo? ");
INSERT INTO ameNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ñehua, Pilatopaʼ eñotapan judioneshaʼ paʼm̃chaʼtaret̃erneshaʼ ñetpaʼ eʼñe pueʼmoñeʼtateñmeʼchatsa oʼ pomueret Jesús. Ñeñt̃oʼmarña Pilatopaʼ añ muenen oʼch aʼp̃t̃oʼtan allohuen acheñeneshaʼ t̃arroʼmar ñapaʼ añcaʼye eʼnen att̃och aʼrroyerran Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ñam̃a t̃arroʼmar allempo anorros poʼconaño allchaʼ aʼpoctatan ñoñets, puet̃aporñapaʼ oñmach poʼñoñ all oteñ: “Amach errot̃ pep̃atsche Jesús ñeñt̃ eʼñe cohuen acheñer t̃arroʼmar amaʼt añ tsapro napaʼ oʼ nec̈hopoʼteñ; napaʼ ñeñt̃ña atarr neyoreʼteʼ.” ");
INSERT INTO ameNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","T̃arraña ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen judioneshaʼ poʼcornaneshar ñam̃a ñeñt̃ pomporneshaʼ pen allohuen judioneshaʼ ñetñapaʼ aña atarr cot̃apeʼchatenet acheñeneshaʼ att̃och ñetpaʼ allohuenetpaʼ oʼch ochet Pilato: —Añchaʼ p̃aʼrroyerrnay Barrabás, Jesúsñapaʼ pemtsatachepaʼch. ");
INSERT INTO ameNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Allempoña am̃chaʼtaret̃ Pilatopaʼ oʼ alla aʼp̃t̃oʼterraneterr: —¿Erraʼtsenaʼtña poʼñoc̈h añ epsheñoʼmar semnen ñeñt̃chaʼ naʼrroyerrnas? Ñetña anaprraʼtetpaʼ atet̃ ochet: —Añchaʼcaʼye p̃aʼrroyerrnay Barrabás. ");
INSERT INTO ameNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatoñapaʼ alla oterraneterr: —Ñehua, añ Jesús ñeñt̃ otenet Cristopaʼ ¿errot̃eʼtchaʼña nepeʼ? Allohuenetñapaʼ alla otereterr: —¡Ñapaʼ pecorsoʼtam̃p̃sachñacaʼye! ");
INSERT INTO ameNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatoñapaʼ atet̃ oterraneterr: —Ñapaʼ ¿esoʼtña pen ñeñt̃ amaʼt mameshapaʼ ama pocteyeʼ sentapreteñe? Ñetñapaʼ alla rrannarterreterr huomencpaʼ atet̃ oterreterr: —Ñapaʼ ¡c̈hop̃añacaʼyeña corsoʼtam̃p̃sateʼ! ");
INSERT INTO ameNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatoñapaʼ eʼñe eñoteñ att̃och ñapaʼ amach errot̃ pe, elloña acheñeneshaʼpaʼ c̈ha atarr atsrreʼmoc̈htanaʼteñet. Allempoñapaʼ chetan oñpaʼ eʼpotaʼta allochñapaʼ att̃och eñotatanet ñapaʼ amacaʼye ñayeʼ otteñeʼchenaye, ñeñt̃paʼ atet̃ oterraneterr: —Napaʼ amach seyohuatsetno att̃och rroma añ acheñer ñeñt̃ amaʼt coñeʼt̃a ama c̈hoyeʼ errot̃ es peno. Ñeñt̃paʼ ama nocpaʼnayaye, ñeñt̃paʼ eʼñecaʼye sapt̃ecpa. ");
INSERT INTO ameNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Allohuenña acheñeneshaʼpaʼ ñetñapaʼ alla otereterr: —Att̃och rromapaʼ amaʼtpaʼ yohuaʼyetepaʼ—ya ñam̃a amaʼt yem̃renñohuen. ");
INSERT INTO ameNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Allempoñapaʼ aʼrroyerranet Barrabás, Jesúsñapaʼ ashtach allempoñapaʼ otan poʼsolltarneshar: —T̃eʼpaʼ oʼch secorsoʼtam̃peñaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ñehua, solltarneshaʼña ama aneñetaʼ allchaʼ corsoʼtam̃p̃soset ñetñapaʼ arrña ñanom anmet Jesús am̃chaʼtaret̃epahuo. Allña agotachet allohuen poʼpotantañ solltarneshaʼ ñeñt̃ alloʼtsaʼyen oʼch eʼñe apc̈het Jesúsesho. ");
INSERT INTO ameNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Allñapaʼ paʼllocchameʼteñot̃et Jesúspaʼ rrotam̃pes paʼshtam, chorrachet shetamuets tsamamuen ñeñt̃ paʼshtam pen ñeñt̃ poʼñoc̈h am̃chaʼtaret̃tetsa. ");
INSERT INTO ameNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pelltaʼtoñet ñam̃a choyoʼmets agrec̈hpaʼ ñeñt̃ña choyoʼm̃tachet ñeñt̃ atet̃ choyoʼm̃tena ñeñt̃ poʼñoc̈h am̃chaʼtaret̃tetsa. Orrachet ñam̃a tsachep̃ poto poʼcohuenrot̃ ñeñt̃ atet̃ orren ñeñt̃ poʼñoc̈h am̃chaʼtaret̃tetsa. Allempoñapaʼ concorpaʼyesyet. Paʼllocchameʼteñot̃etpaʼ eʼñe atet̃ p̃achet ñerraʼmrrat̃eʼ ñeñt̃ eʼñe poʼñoc̈h am̃chaʼtaret̃tetsa. Pachm̃areʼteñot̃etpaʼ atet̃ oteñet: —Puetareʼ am̃chaʼtaret̃echaʼ, atarruacaʼ cohuenep̃t̃eʼ p̃a ñeñt̃ep̃ judioneshaʼ paʼm̃chaʼtaret̃erep̃. ");
INSERT INTO ameNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Puecheʼtatseteñot̃et aʼcoshareʼteñetpaʼ oʼ chetam̃peretña ñam̃a tsachep̃ potot̃paʼ alloña astoʼtameʼteñet poño. ");
INSERT INTO ameNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Oʼña achm̃areʼtuahuetpaʼ allempoñapaʼ rrotam̃peret shetamuets tsamamuen chorrateret eʼñe ña paʼshtam. Allempoñapaʼ anmet aʼyo allchaʼ corsoʼtam̃peñetaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Eʼñe ahuanmatsetpaʼ allña oñenetpaʼ oʼ poctet puesheñarr yacma ñeñt̃ cireneoʼmarneshaʼ ñeñt̃paʼ añ paʼsoʼcheñ Simón. Ñañapaʼ allent̃a chechatnomet Jesús poʼcorsoch. ");
INSERT INTO ameNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","C̈hapachet all socheñet Gólgota ñeñt̃ yoten yeñoño Poñetallep̃no. ");
INSERT INTO ameNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Oʼ c̈hapachet all Jesúspaʼ aposetañ vinos ñeñt̃paʼ añ atsetaret̃ pueretso ñeñt̃ atarr pesherr. Att̃a am̃lleʼpaʼ ama mueno oʼch orr. ");
INSERT INTO ameNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Allempoña oʼ corsoʼtam̃pesuetpaʼ solltarneshaʼñapaʼ allent̃a yellsheñeʼchatoñet paʼshtam poʼsuertot̃ att̃och orrtet eʼñe puesheñaʼttsetpaʼ oʼch yorayesñañet paʼshtam puemaʼtets. Att̃oña etsoterra añ ñoñets ñeñt̃ aʼm̃tayeʼt̃ ahuat̃ Yompor poʼñoñ. Ñehua, allempopaʼ eʼñe atet̃ ñerraʼmrrat̃eʼ Cristo otatseʼt̃, ñeñt̃paʼ atet̃ oten: “Yellsheñeʼchaterrnanetchaʼ neshtam poʼsuertot̃ att̃och orrtet eʼñe puesheñaʼttsetpaʼ oʼch yorayesonet neshtam puemaʼtets.” ");
INSERT INTO ameNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Allempoña solltarneshaʼpaʼ alla anorrc̈haʼtet oʼch cohuam̃p̃set. ");
INSERT INTO ameNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ñehua, poñot̃ all corsocho all noñet tsachtall aquellcaret̃ att̃ochña eñoteñet ñeñt̃ecop corsoʼtam̃peñet. Ñeñt̃ña quellecpaʼ atet̃ oten: “Añ Jesúspaʼ ñeñt̃caʼyeña judioneshaʼ Paʼm̃chaʼtaret̃er.” ");
INSERT INTO ameNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Allñapaʼ corsoʼtam̃p̃set epuet ñam̃a epsheña eñet̃, puesheñarrpaʼ nosñañet poʼcohuenrot̃, poʼpsheñeññapaʼ nosñañet pueʼchcot̃erot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ñeñt̃ña oñmac̈hets allpaʼ ñetpaʼc̈hoʼña c̈hocma achm̃areʼtneñet. Pachm̃arñot̃etpaʼ coñoʼcoñtanaʼtyesneñet, ");
INSERT INTO ameNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ñeñt̃paʼ atet̃ otyesneñet: —P̃a ñeñt̃ep̃ p̃ommoʼcheñot̃paʼ p̃otatseʼteʼt̃ p̃oʼch aʼmaterrayeñ Parets paʼpaquëll, pomaʼpamtañocmoʼch alla p̃at̃omatereñ, t̃eʼñapaʼ p̃aʼqueshp̃aterrañacaʼye eʼñe p̃añeña. Ñerraʼm poʼñoc̈ht̃eʼ Parets Puechemerep̃paʼ pesuerrañacaʼyena t̃ayecma corsochot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Eʼñe att̃ecma achm̃areʼteñ ñam̃a ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen judioneshaʼ poʼcornaneshar ñam̃a ñeñt̃ etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ ñam̃a ñeñt̃ pomporneshaʼ pen allohuen judioneshaʼ, amaʼt allohuenet fariseoneshohuen. Ñetñapaʼ pachm̃areʼteñot̃paʼ atet̃ otatseʼtyeñet: ");
INSERT INTO ameNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—T̃eʼña p̃apaʼ oʼ p̃aʼqueshp̃atyes poʼpotantañ, p̃añapaʼ esoʼmareʼtchaʼña ama eshcayeʼ p̃aʼqueshp̃aterroña eʼñe p̃añeña. Eʼñe pachm̃areʼteñot̃etpaʼ atet̃ otyereterr: —P̃apaʼ ñeñt̃ep̃oʼcaʼye israelneshaʼ Paʼm̃chaʼtaret̃erep̃paʼ pesuerrañacaʼye corsochot̃ allochñapaʼ att̃och yameʼñap̃a yam̃a. ");
INSERT INTO ameNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","P̃apaʼ p̃a yemtenaya Yomporpaʼ t̃eʼñapaʼ aʼqueshp̃aterrpepaʼñacaʼye ñerraʼm poʼñoc̈ht̃eʼ eʼñe cohuen muerenp̃a. P̃apaʼ ñeñt̃ep̃ poʼñoc̈h atet̃ otets Yomporoʼ Puechemerep̃. ");
INSERT INTO ameNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Eʼñe att̃ecma peʼ ñam̃a eñet̃ ñeñt̃ epuet corsoʼtam̃peñet ñetpaʼc̈hoʼña atarr es otnareʼchet allot̃ poʼcorsochot̃. ");
INSERT INTO ameNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Oʼña c̈hap poctopaʼ oʼhuañ atsnom oʼ eʼñe checmetua ora errap̃aren añe patsro, oʼña ellerrotenmochapaʼ oʼ alla puetarerr. ");
INSERT INTO ameNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Allempoña ellerrotnenmochapaʼ Jesúsñapaʼ rrana huomenc, ñeñt̃paʼ atet̃ ot eʼñe ña poʼñoño: —Elí, Elí, lama sabactani. Ñeñt̃ña ñoñtsorpaʼ atet̃ oten: Esoʼmaruachñacaʼye Neyompor-rechaʼ p̃aʼypoʼñerren. ");
INSERT INTO ameNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Puesheñaʼtetsña ñeñt̃ t̃omc̈hets all ñeñt̃ eʼmueʼ atet̃ oten Jesús, ñetñapaʼ amacaʼye eʼmueññañeto poʼñoñ ñeñt̃ atet̃ oten, ñeñt̃oʼmarña ñetpaʼ c̈ha otyeset: —Oʼ c̈ha c̈horeʼtant̃eʼ Elías ñeñt̃ aʼm̃tayeʼt̃ ahuat̃ Parets poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Allempoñapaʼ mata puesheñarr ñeñt̃ alloʼtsen, eʼc̈homosan chellaʼso ñeñt̃ atsotsoʼtpoʼ oʼ neʼ tsachp̃opaʼ allot̃ña tsotsoʼtatosanña Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Poʼpotantaññapaʼ atet̃ ochet ñeñt̃ tsotsoʼtateneʼ: —Amach es p̃apatsche, t̃eʼpaʼ att̃achcaʼye yecueʼ ñatoʼrraña huapa Elías ñach aʼqueshp̃atoseʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Allempoña Jesúspaʼ oʼ alla rranerrerr huomencpaʼ rroma. ");
INSERT INTO ameNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Allempoña besom allo yottam̃peññañet Parets paʼpaquëll oʼponopaʼ ahuepaʼt rrarraʼnom eʼñe poctacma, ellopaʼtetsta enot̃eñ eʼñe sotatsohua. Allempoñapaʼ oʼ pella pats atarr huomenc, rrarnaʼtyes mapuetac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tornaʼtam̃pesyes apampaña. Shonteʼ ñeñt̃ pueyochreshaʼ pen Parets ñeñt̃ oʼ collaʼhuañ, ñetñapaʼ ahuepaʼt eʼñe tantrraʼtuerret. ");
INSERT INTO ameNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Allempoña tanterra Jesúspaʼ ñetpaʼc̈hoʼña oʼ sohuanerretña all apamparet̃teteʼt̃ oʼ alla ahuanerret anetso Jerusaléño ñeñt̃ anaret̃ Partsocop, allñapaʼ shonteʼ acheñ ñeñt̃ entapuerrahuet. ");
INSERT INTO ameNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Eʼñe allempo rroma Jesús, solltarneshaʼña epuet poʼcap̃taner ñeñt̃ allpon cohuam̃peneʼ Jesús, ñetñapaʼ eʼñe enteñet ñeñt̃ atet̃ p̃aʼyesa allempo, att̃o pella pats. Ñeñt̃oʼmarña ñetpaʼ atarr yorenet. Allempoñapaʼ atet̃ otet: —Poʼñoc̈huacaʼye añmapaʼ Partsepaʼtcaʼye Puechemer. ");
INSERT INTO ameNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Alloʼtsaʼyen ñam̃a shonteʼ coyaneshac̈hno, ñetñapaʼ aʼyot̃a cohuanrrorteñet. Ñetpaʼ ñetcaʼyeña cot̃aʼhuanmueʼña Jesús Galileot̃eñ ñeñt̃ sherb̃aʼyesayeʼt̃. ");
INSERT INTO ameNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ñeñt̃paʼ María Magdalena ñam̃a poʼpsheñeñ María ñeñt̃ Jacobo pachor ñam̃a José. Alloʼtsen ñam̃a ñeñt̃ pachor pen Zebedeo puechemereshaʼ, ñam̃a poʼpotantañec̈hno coyaneshac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Att̃eñapaʼ oʼ ellerren. Puesheñarr ñeñt̃ ec̃llayoret̃ ñeñt̃ paʼsoʼcheñ José ñeñt̃ arimateoʼmarneshaʼ ñeñt̃ara Jesús pueyochreshaʼ ñañapaʼ ahuos Pilateshopaʼ oʼch oteñaʼ pocteʼch eñch ñach asuatoseʼ Jesús ñeñt̃ rromuets corsocho. Pilatopaʼ atet̃ otan paʼcheñer: —T̃eʼpaʼ oʼch saʼrroyoñ arromñat̃ anerepaʼ. Oʼña ellerren Joséñapaʼ oʼ c̈herr corsocho, ");
INSERT INTO ameNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","aʼsuatuerran Jesús corsochot̃ all rromuen. Allempoñapaʼ ep̃atseʼch shetamtso ñeñt̃ eʼñe cohuen emarr. Allempoñapaʼ anem̃ allchaʼ pampueñaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","All eʼñe errteʼ eñateneʼ mapuetpon ñeñt̃paʼ eʼñe pamoʼtsnaʼtarneshacpañ allcaʼyeña nenanaʼña Jesús. Allempoñapaʼ attomeʼterrñañ mapueʼ añecmuen allo yottam̃pesner ñeñt̃ puepampuer p̃ach. Oʼña yottam̃pesuanerpaʼ Joséñapaʼ ahuerr. ");
INSERT INTO ameNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Allñapaʼ alloʼtsen María Magdalena ñam̃a poʼpsheñeñ María. Ñetñapaʼ alla anorrc̈haʼtoset allameʼtets all pampueñet. ");
INSERT INTO ameNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Met añ yet̃er allempo c̈hocmach aññoʼterreterr ñeñt̃ tsapat̃ecop allempocma amesen judioneshaʼ. Tsapat̃ñapaʼ ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen judioneshaʼ poʼcornaneshar ñam̃a fariseoneshaʼ ñetñapaʼ eʼñe alla shontenet parro all Pilatesho. ");
INSERT INTO ameNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ñeñt̃paʼ atet̃ otoset: —Nomporchaʼ yapaʼ oʼcaʼye yeyerpuera añ acheñer ñeñt̃ atarr ashcañpaʼ allempo correʼt̃paʼ atet̃caʼye otyeʼt̃: “Napaʼ amaʼt puemaʼpamtañopaʼ netanterrachcaʼye rromot̃.” ");
INSERT INTO ameNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","T̃eʼpaʼ pemñayeʼchñacaʼye ñeñt̃chaʼ nanac cohuam̃p̃soseʼ puepampro eʼñe puemaʼpamtañohua, t̃eʼt huapa pueyochreshaʼpaʼ c̈hat̃eʼcaʼye eʼñe aʼnahua eretaʼ. Allempoña ñetpaʼ c̈hat̃eʼ ochet acheñeneshaʼ Jesúspaʼ oʼcaʼye tanterra rromot̃. Ellot̃eʼña ñet allempopaʼ nanact̃eʼ shecareʼteret acheñeneshaʼ. Ellot̃eʼ metanerret ñeñt̃ att̃o shecareʼtyeseteʼt̃ ahuaña acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatoñapaʼ atet̃ otapanet: —Añcaʼyeña guardianeshaʼ, t̃eʼpaʼ orras parro, ñetpaʼ oʼch cohuam̃p̃soset, eʼñech echarr sep̃am̃p̃sosñañ puepampuer, errot̃enchaʼ eʼñe pocteʼ sent sa. ");
INSERT INTO ameNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ñetñapaʼ ahuanmuet puepampro. Mapueʼ allo yottam̃peñetpaʼ eʼñe cohuen yomrraram̃p̃soset att̃ochña eñoteret ñerraʼm eseshaʼch toram̃perreʼ. Oʼña eʼñe cohuen p̃am̃pesuetpaʼ allempoñapaʼ naʼneret guardia all ñeñt̃chaʼ cohuam̃p̃seʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Oʼña huañ yet̃ñats allempocma amesenet allempoña t̃aya puetaren temenc allempo mot̃taʼmuena yet̃ñatspaʼ Maríaña Magdalena ñam̃a poʼpsheñeñ María ñetñapaʼ ahuat̃ecma ahuanmaʼmuenet oʼch entaʼmueñet Jesús puepampro. ");
INSERT INTO ameNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Allempoña machayot̃epaʼtchaʼ pella pats huomenc; añ sohuatsa Yompor poʼm̃llañot̃eñer entot̃. Oʼ sohuapaʼ aʼrrot̃eʼtosan mapueʼ aʼyenet̃ ñeñt̃ña mapueʼpaʼ allña anorros. ");
INSERT INTO ameNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ñañapaʼ atarr nanac poptosa eʼñe atet̃ orrtosa ñerraʼmrrat̃eʼ meratsteʼ. Paʼshtamñapaʼ atarr nanac huallamaʼt̃. ");
INSERT INTO ameNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Guardianeshaʼñapaʼ ñeñt̃ña atarr yoreʼtoseʼ. Puem̃chañot̃etpaʼ c̈ha yonshemaʼtyeset c̈ha ot̃aʼyeset eʼñe att̃et ñerraʼm c̈ho rromuenet. ");
INSERT INTO ameNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Allempoña mellañot̃eñpaʼ atet̃ otapan coyaneshac̈hno: —Amach c̈ha seyorenatsto. Napaʼ neñotenes añcaʼye semnen oʼch sentaʼmueñ Jesús ñeñt̃ corsoʼtam̃p̃set. ");
INSERT INTO ameNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Amacaʼ arroʼtsenaro arr, ñapaʼ atet̃ otaseʼt̃paʼ t̃eʼñapaʼ oʼcaʼye tanterra. Soncaʼye secueñaʼ all p̃anet amacaʼ eñalle. ");
INSERT INTO ameNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Secuaʼhuepaʼ orrerres semaʼyoreñ oʼch soterrñañaʼ pueyochreshaʼ: “Oʼcaʼye tanterraña Jesús rromot̃. Ñapaʼ ñanomchaʼ otatsa oʼch ahuen Galileo. Sapaʼ allchaʼña sentuer.” ");
INSERT INTO ameNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Allempoñapaʼ puemaʼyoreñ ahuanerret puepamprot̃. Amaʼt yorenetañpaʼ pocsheñeshaʼ matrraʼterret oʼch oteññañetaʼ pueyochreshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Matac̈hetsetpaʼ Jesúsñapaʼ ahuepaʼtchaʼ poctanet, huom̃chaʼtapanet. Ñetñapaʼ allent̃a ponem̃yet, rromoset paʼrrp̃ot̃ concorposñañet. ");
INSERT INTO ameNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Allempoña Jesúspaʼ atet̃ otanet: —Amach sem̃chaʼtatsetno. Orrerres sotennanaʼ nemoʼnasheñneshac̈hno ahuanmuetepaʼ Galileo, allchaʼña eʼñe enterrnet. ");
INSERT INTO ameNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ahuanmatsetpaʼ puesheñaʼtetsña guardiapaʼ ahuanmuet ñamet anetso. Allñapaʼ serrpareʼtatoset cornaneshaʼ paʼm̃chaʼtaret̃erneshaʼ allohuen atet̃ oʼ entuet. ");
INSERT INTO ameNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ñetña allempo apc̈henet epuet ñeñt̃ pomporneshaʼ pen judioneshaʼ ñetñapaʼ cot̃apeʼchatannaʼtet. Oʼña cot̃apeʼchatannaʼtuetpaʼ allempoñapaʼ apet solltarneshaʼ shonteʼ quelle. ");
INSERT INTO ameNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ñeñt̃paʼ atet̃ ochet solltarneshaʼ: —T̃eʼpaʼ atet̃chaʼ sot: “Yaña tsapopaʼ muetsyeʼtpaʼ pueyochreshaʼñapaʼ ahuoʼt huapuet aʼnahuaʼt eretaʼña arromñat̃.” ");
INSERT INTO ameNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ellopaʼ alla oterranerr solltarneshaʼ: —Ñerraʼm am̃chaʼtaret̃ c̈ha eʼmareʼteʼ yapaʼ yaʼpoctatonaschaʼ eʼñe cohuen ñesho att̃ochña sapaʼ amach errot̃ p̃aseto. ");
INSERT INTO ameNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ñetña allempo agaphuet quellepaʼ atet̃ otaret̃tetpaʼ atet̃c̈hoʼ pet. Ñeñt̃oʼmarña ñet pueserrparñetpaʼ eʼñe allempot̃eñ epaʼhua judionesheshoʼmar. ");
INSERT INTO ameNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ñeñt̃ c̈harraʼ puechena pat̃err pueyochreshaʼpaʼ ñetñapaʼ ahuanerret Galileo. Arr ahuanmuet all aspent̃o all otanet Jesús allchaʼ tet. ");
INSERT INTO ameNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Allempo entosetpaʼ ñetñapaʼ c̈ha concorpaʼrretyesoset. Puesheñaʼtetsñapaʼ c̈ha echarrtanet pueyoc̈hro. ");
INSERT INTO ameNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Allempoña Jesúspaʼ ponmanet atet̃ otapanet: —Napaʼ aparet̃en allohuen llesens añe patsrecop ñam̃a Yompor pueʼntañecop. ");
INSERT INTO ameNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ñeñt̃oʼmarña t̃eʼpaʼ orras oʼch seyc̈hatyes ora allohuen paʼnamen acheñ att̃och neyochreshaʼ neperranet. Oʼch sapatanet Yompor Parets paʼsoʼchño ñam̃a Yompor Puechemer paʼsoʼchño ñam̃a eʼñe Yompor Puecamquëñ paʼsoʼchño allochñapaʼ att̃ochña eʼñe pueyochreshaʼ perranet Yompor Parets. ");
INSERT INTO ameNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ñam̃a c̈hocmach oʼch eʼñe seyc̈hatyesanet allochñapaʼ att̃och eʼñe cohuen ameʼñerrnanet eʼñe ora ñeñt̃ allpon oʼ notuas. Ñam̃a señochepaʼch napaʼ eʼñe pat̃eʼtets yet̃ c̈hocmach alloʼtseney parro att̃och c̈hocma nebensareʼtam̃penes amaʼt t̃arrempohuach esempohuañen allempoch mellapoterra. Ñeñt̃paʼ att̃etepaʼch Nompore. Allohua.");
INSERT INTO ameNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","T̃eʼ arr napaʼ oʼch nequellconas ñeñt̃ eʼñe cohuen ñoñets alloch yequeshperra eʼñe yameʼñeñot̃a Jesucristo ñeñt̃ Puechemer pen Yompor. Ñehua, ñeñt̃ ñanom orrtatsa ñeñt̃paʼ eʼñe atet̃ oʼ perra eʼñe atet̃ quellquëʼt̃ Isaías ñeñt̃ aʼm̃tayeʼt̃ ahuat̃ Yompor poʼñoñ. Isaíaspaʼ ñapaʼ añcaʼye quellquëʼt̃ ñeñt̃ atet̃ Yomporpaʼ otan Puechemer ñeñt̃ara Cristo, ñeñt̃paʼ atet̃ och: T̃eʼpaʼ peñochepaʼch napaʼ nemñerrnap̃chaʼ puesheñarr ñeñt̃chaʼ p̃otam̃perraya. Eʼñe ña pueserrpareʼteñot̃paʼ aññoʼterrnap̃chaʼ allchaʼ p̃oñmos p̃am̃a esempo. ");
INSERT INTO ameNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ñapaʼ eʼmorrterrach poʼñoñ all amayo allchaʼña serrpareʼtaterranña acheñeneshaʼ. Puerranarot̃paʼ añchaʼ tomaʼntaterranet t̃oñ, ñeñt̃paʼ atet̃chaʼ oterranet: “T̃eʼpaʼ oʼch saʼcohuenetyes t̃oñ allchaʼ oñmos Partseshaʼ, oʼch eʼñe saʼpac̈harretyesoñ paʼt̃ep̃.” Arrpaʼ allohua ñeñt̃ atet̃ quellquëʼt̃ Isaías. ");
INSERT INTO ameNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Eʼñe atet̃ anuaret̃ ahuat̃ot̃eñpaʼ ñeñt̃ñapaʼ eʼñec̈hoʼ atet̃ perra allempo orrtosa Juan ñeñt̃ apatoseʼ acheñeneshaʼ Yomporecop. Ñapaʼ alla orrta amayo allña serrpareʼtatosanña acheñeneshaʼ. Ñeñt̃paʼ atet̃ otosanet: —T̃eʼpa oʼch soct̃apeʼcherr ello cohuen Yomporecop allochñapaʼ eʼñech cohuen sapataret̃terra eʼñe sameʼñeñot̃ Yompor. Att̃ochña Yomporpaʼ oʼch peretnaʼhuerrnas soʼchñar. ");
INSERT INTO ameNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ñeñt̃oʼmarña shonteʼ acheñeneshaʼ c̈hocma huac̈haʼtyenet ñesho oʼch eʼm̃ñoteñetaʼ. Allohuen ñeñt̃ judeoʼmarneshaʼ ñam̃a allohuen ñeñt̃ jerusaléñoʼmarneshaʼ c̈hocma huac̈haʼtyenet ñesho. Allña ñetpaʼ aʼmet̃aʼyesoset poʼchñaret, Juanñapaʼ apatyesapanet Yomporecop. Ñeñt̃ña oñ all apatyesapanet añ paʼsoʼcheñ Jordanas. ");
INSERT INTO ameNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ñeñt̃ña Juanpaʼ camello pueʼch apomotaret̃ ñeñt̃ paʼshtam pen. Allo chanena ñeñt̃paʼ paʼrrom. Allñapaʼ rraʼyesaneʼt̃ ahuañchenclla ñeñt̃a puerrar peʼt̃ epuet pets poʼmoñ. ");
INSERT INTO ameNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juanñapaʼ atet̃ serrpareʼtatanet: —Cristoña ñeñt̃chaʼ huapatsa chentaʼpaʼ ñapaʼ atarrcaʼye ahuamencat̃eshaʼ, nañapaʼ ama tama ahuamencat̃eyayno. Ñapaʼ ñeñt̃ña atarr sherbets, nañapaʼ ama es nesherbeno att̃och nemoʼca paʼrrp̃ot̃ amaʼt poʼsapatrec̈hapaʼ oʼch nepyoñ. ");
INSERT INTO ameNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ñam̃a napaʼ amaʼt napatensoñ Yomporecoppaʼ eʼñecaʼye oñochaya napatyenes. T̃arraña Cristoñapaʼ añchaʼcaʼye chorratossa Parets Puecamquëñ. ");
INSERT INTO ameNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Allempoña huapa Jesús Nazaretot̃ allara Galileo. C̈hap Juanesho allñapaʼ apatap̃ Juan oño Jordanaso. ");
INSERT INTO ameNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Eʼñe apatueʼpaʼ oʼ c̈haʼnerrña Jesús oñot̃paʼ allent̃a entan enet atoraret̃. Allot̃ña eʼñe sohuaʼnmaña Parets Puecamquëñ eʼñe atet̃ entap̃ ñerraʼmrrat̃eʼ yep̃ oʼ sohuaʼnma entot̃. Eʼñe arr c̈hap Jesúsesho. ");
INSERT INTO ameNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Allempoñapaʼ c̈ha eʼmorrtatsa ñam̃a ñoñets entot̃ atet̃ eñorena Yompor. Ñeñt̃ña ñoñetspaʼ atet̃ oten: —P̃apaʼ ñeñt̃ep̃ Nechemerep̃ ñeñt̃ep̃ atarr nemorrentena, p̃a atarr nocshateneʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Allempoña Parets Puecamquëñpaʼ allent̃a anman Jesús all amayo. ");
INSERT INTO ameNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Paʼtatsoch c̈harramat alloʼtsena amayo; allñapaʼ alloʼtsaʼyen paʼnamen berroc̈hno. Att̃oña allpaʼ oʼ huapoña oneñet̃ mueneñ oʼch atet̃ p̃atyes ñeñt̃ ama pocteyeʼ enteno Pompor Parets. Oʼña topatuahueñaʼpaʼ allempoñapaʼ huac̈haʼtoña ñam̃a Yompor poʼm̃llañot̃eñnaneshar; ñetña sherb̃osetña Jesús all. ");
INSERT INTO ameNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","15","Allempoña yottam̃p̃set Juan allchaʼ mueroc̈htachet, Jesúsñapaʼ allent̃a ahuerr Galileo. Oʼña c̈herr all ñañapaʼ serrpareʼtatuerranet ñeñt̃ eʼñe cohuen ñoñets ñeñt̃ huetsa Yomporeshot̃ alloch yequeshperra. Ñeñt̃ñapaʼ atet̃ otuerranet: —T̃eʼñapaʼ oʼ etsoterra yet̃ñats, oʼ c̈herrmoch allempoch atarr ayochreshat̃terra Yompor. Socoppaʼ añ poctetsa oʼch soct̃apeʼcherr ello cohuen Yomporecop ñam̃a oʼch sameʼñerra ñeñt̃ eʼñe cohuen ñoñets allochcaʼyeña sequeshperra. ");
INSERT INTO ameNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Allempo Jesúspaʼ chopeñeʼchyen all saʼpatop̃ñoʼmar; ñeñt̃ña saʼppaʼ añ paʼsoʼcheñ Galileas. Allñapaʼ entnoman Simón epuet paʼmoʼnasheñ Andrés. Ñetñapaʼ all terrayenet eʼñe all saʼpo t̃arroʼmar ñetpaʼ ñeñt̃ poʼtaruas penet. ");
INSERT INTO ameNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesúsñapaʼ atet̃ otosanet: —T̃eʼñapaʼ oʼch notas: Soct̃aʼn na att̃och neyochreshaʼ neperres. Ñeñt̃ atet̃ sepena ahuat̃ot̃eñ eʼneʼ cac t̃eʼñapaʼ oʼch neyc̈haterres att̃och seʼnerr ñam̃a acheñ ñeñt̃chaʼ sameʼñaterra. ");
INSERT INTO ameNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ñetñapaʼ allorocma naʼnmuet poʼterrayapaʼ oʼ cot̃et Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Oʼña meterrerr aʼyent̃eyeʼpaʼ allñapaʼ entuerranerr ñam̃a Jacobo epuet paʼmoʼnasheñ Juan; ñeñt̃paʼ Zebedeo puechemereshaʼ. Ñetñapaʼ poʼnoñt̃oʼtsaʼyenet all aʼcohuenetyenet poʼterraya. ");
INSERT INTO ameNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesúsñapaʼ c̈horeʼtuerraneterrpaʼ atet̃ otuerraneterr ñamet: —T̃eʼpaʼ oʼch soct̃aʼn sam̃a. Ñetñapaʼ allent̃a saʼnmet pomporet Zebedeo all poʼnoñt̃o epuet ñam̃a paʼtaruasañret. Ñetpaʼc̈hoʼña cot̃et Jesús att̃och pueyochreshaʼ perranet ñamet. ");
INSERT INTO ameNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Att̃eñapaʼ ahuanmuet ñam̃a anetso Capernaumo. Oʼña c̈hap añ yet̃ñatsro allempocma amesen judioneshaʼ, allña Jesúspaʼ beʼt̃osos judioneshaʼ poʼprahuo, all yec̈hatyesosanet. ");
INSERT INTO ameNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Allempo serrpareʼtatuanet Jesús, acheñeneshaʼñapaʼ epayeʼ cohuanrrorteñet ñeñt̃ atet̃ yec̈hatenanet ña. T̃arroʼmar ñapaʼ atarr cohuen yec̈hatenanet atet̃ ñerraʼmrrat̃eʼ ñeñt̃ allsensaret̃tetsa Partseshot̃. Judioneshaʼ paʼm̃chaʼtaret̃erneshaʼ ñeñt̃ atarr etsotayeneʼ ñoñets ñeñt̃ atet̃ anaret̃, ñetñapaʼ ama eʼñeyeʼ att̃eyeʼ yec̈hateneto. ");
INSERT INTO ameNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Puesheñarrña yacma ñeñt̃ alloʼtsen puerahuo, ñeñt̃ñapaʼ añ chorrenaya oneñet̃. Ñaña rranareʼtapaʼ atet̃ otapan Jesús: ");
INSERT INTO ameNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Esoʼmareʼtchaʼña errot̃ pep̃osey Jesúso, p̃a ñeñt̃ep̃ nazaretoʼmarneshap̃. ¿Añecopt̃eʼ pehuena oʼch p̃aʼchencaterrey? Napaʼ oʼ neñotapap̃. P̃apaʼ atarr Partsop̃ añ pellsenseneʼ P̃ompor ñeñt̃ atarr nanac Parets. ");
INSERT INTO ameNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","T̃arraña Jesúspaʼ ama muenache oʼch eñoranaʼcha. Ñañapaʼ atet̃ och: —Pemma, t̃eʼpaʼ c̈hop̃aña quec̈hpaʼnerreʼña añ acheñer. ");
INSERT INTO ameNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Oneñet̃ñapaʼ c̈ha atanman yacmapaʼ alla oʼshsheʼma. Oneñet̃ñapaʼ c̈ha rranareʼtnoma allempo quec̈hpaʼnerran acheñ. ");
INSERT INTO ameNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Acheñeneshaʼñapaʼ c̈ha atarr t̃orats p̃anet pueyoc̈hret. Ñetñapaʼ atet̃ otannaʼtyeset: —Taʼmcaʼye, errot̃ent̃eʼcaʼyeña Jesús poʼñoñ; poʼpoñont̃epaʼtcaʼye yec̈hatyen. Ñeñt̃paʼ errot̃ent̃eʼcaʼye. Eʼñe atet̃ pena poʼñoñ atet̃ ñerraʼmrrat̃eʼ ñeñt̃ allsensaret̃tetsa Yomporeshot̃. ¡Amaʼt oneñet̃ errot̃ otenpaʼ atet̃c̈hoʼ p̃ateñ, eʼñech ameʼñateña! ");
INSERT INTO ameNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Eʼñe mamecmapaʼ oʼ eʼñe serrpareʼtuahuet allampañoʼmar Galileo atet̃ p̃aʼyena Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Allempoña c̈haʼnmac̈herret puerahuot̃paʼ arr ahuanmuet all yec̈hena Simón ñam̃a paʼmoʼnasheñ Andrés. Allñapaʼ añ cot̃aʼnmueʼ Jacobo ñam̃a Juan. ");
INSERT INTO ameNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Allña Simón paʼsoʼmuepaʼ c̈ha atsnaʼten, c̈ha huoraten, alla p̃anena poʼmayo. Otapet Jesús: —Simón paʼsoʼmuepaʼ c̈ha atsnaʼten. ");
INSERT INTO ameNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Allempoña Jesúspaʼ ponmosana atsnañet̃paʼ rremotaʼtos potot̃paʼ c̈ha echantoseʼ c̈ha metuerretsña att̃o huoraten. Allempoña oʼ metua poʼurateñapaʼ allent̃a tanta oʼ agapapanet eʼñe cohuen oʼ yemaʼtapanet. ");
INSERT INTO ameNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ñeñt̃e yet̃rocma allempo ellerren oʼ emuena atsrret̃paʼ acheñeneshaʼña huapatyesnenet Jesúsesho allohuen ñeñt̃ atsnaʼtyets ñam̃a ñeñt̃ chorraʼyena oneñet̃. ");
INSERT INTO ameNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Huac̈haʼtyesoña allohuen anetsoʼmarneshaʼ, ñetñapaʼ alla shontoset allot̃ecma beʼt̃enet pocollo. ");
INSERT INTO ameNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesúsña allempopaʼ eʼñe aʼcrratyesuapanet, amaʼt shonteʼ paʼnamen atsnañtsoc̈hno ñeñt̃ osyenahuet. Amaʼt ñam̃a shonteʼ acheñeneshaʼ ñeñt̃ chorraʼyena oneñet̃ ñeñt̃paʼc̈hoʼña eʼñe quec̈hpatyesuapanet oneñet̃ ñeñt̃ chorraʼyenahuet. Jesúsñapaʼ ama muenatano oneñet̃ att̃och eñoranaʼtnomet, t̃arroʼmar ñetpaʼ eʼñe eñoteñet ñapaʼ ñeñt̃caʼye Cristotets. ");
INSERT INTO ameNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tsapat̃ña eʼñe ahuat̃ecma tantaʼmuena Jesús, ama eʼñe orretuenaʼ c̈haʼnmaʼmuen ñeñt̃e anetsrot̃ ahuaʼmuen all ama acheñempañoyaye allchaʼ maʼyochaʼmuena. ");
INSERT INTO ameNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Eʼñe oʼchtatsapaʼ ahuaʼmuen ñam̃a Simón ñam̃a poʼpsheññec̈hno ñeñt̃ epuet taʼmuena. Ñetpaʼ oʼch eʼneretaʼ Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Allempoña entosetpaʼ atet̃ otoset: —P̃apaʼ allohuen acheñeneshaʼ c̈hocmacaʼye eʼnenpet. ");
INSERT INTO ameNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ñañapaʼ otapanet: —T̃eʼpaʼ oʼch ahuey poʼpoñ anetso ñeñt̃ara allampañoʼmar allpaʼc̈hoʼña oʼch neserrpareʼtatyesnomanet t̃arroʼmar napaʼ ñeñt̃ecopcaʼyeña nohuapa. ");
INSERT INTO ameNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Allempoñapaʼ chopeñeʼchyes Jesús errap̃aren Galileoʼmar, serrpareʼtatyesanet eʼñe ñet poʼprahueto. Ñam̃a ñeñt̃ chorraʼyena oneñet̃, ñañapaʼ eʼñe quec̈hpatyesuerranet. ");
INSERT INTO ameNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Allempoñapaʼ huapoña ñam̃a puesheñarr yacma ñeñt̃ osen puetsarñats ñeñt̃ otenet lepra. C̈hap Jesúseshopaʼ concorpanaʼtosana Jesúspaʼ atet̃ otos: —Ñerraʼm p̃a muenatspaʼ p̃a ñeñt̃ep̃ atarr ahuamencat̃eshap̃ p̃aʼcrratayeʼcherren allochñapaʼ att̃och eʼñe cohuen entuerren acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesúsñapaʼ eʼñe cohuen muerapya ñeñt̃oʼmarña anretapaʼ allent̃a aʼp̃lleʼ, atet̃ och: —Napaʼ nemneñcaʼye, metuerrepaʼña peptsarña allochñapaʼ att̃och eʼñe cohuen entuerrep̃ allohuen acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Yacmañapaʼ allorocmuepaʼtchaʼ metuerña pueptsarña c̈ha cohuenterrtsa. ");
INSERT INTO ameNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Jesúsñapaʼ alla otererr: —T̃eʼ att̃o oʼ naʼcrraterrep̃paʼ poʼñoc̈h amaʼt eʼñe puesheñarrapaʼ amach p̃otap̃saʼtatsche amaʼt mamesha. Corneshachña pegatenaʼ all peptsarseʼt̃. Atet̃ naneʼt̃ Moisés ñoñets añ acheñrecop ñeñt̃chaʼ aʼcrrataret̃terrtsapaʼ t̃eʼñapaʼ oʼch es p̃anom ñeñt̃chaʼ p̃apos all ñeñt̃ Yomporecop. Allochñapaʼ att̃och eʼñe cohuen entuerrep̃ allohuen acheñeneshaʼ. Att̃ot̃caʼyeña Jesúspaʼ mueñe oʼch ahuoʼ corneshesho. ");
INSERT INTO ameNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ñañapaʼ allempo ahuoʼpaʼ eʼñe serrpareʼtatyesuanman allohuen acheñeneshaʼ ñeñt̃oʼmarña eʼñe ña paʼmet̃areʼteñot̃paʼ oʼ erracmañen eñotuet ñeñt̃ atet̃ p̃aʼyena Jesús. Ñeñt̃oʼmarña Jesúspaʼ ama eshcayeʼ seno anetso all shontena acheñeneshaʼ. Ñapaʼ alla chopeñeʼchyen aʼyoʼmar all ama acheñempañoyaye. T̃arraña amaʼt atet̃ penañ acheñeneshaʼñapaʼ allem̃at̃eñ huac̈haʼteññañet ñeñt̃ shontenoya amaʼt all. ");
INSERT INTO ameNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Oʼña met allponmat Jesúsñapaʼ oʼ alla c̈herrerr anetso Capernaumo. Acheñeneshaʼñapaʼ eʼmareʼchet oʼ alla c̈herrerr pocollo. ");
INSERT INTO ameNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Allempoñapaʼ oʼ alla shonterrñañerr acheñeneshaʼ. Att̃eñapaʼ oʼhuañ epuet oʼpono pocollo. Amaʼt allot̃ beʼt̃enet pocollopaʼ oʼhuañ epuet. Jesúsña allpaʼ serrpareʼtatapan acheñeneshaʼ Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Att̃eñapaʼ huapatam̃p̃soñet ñam̃a echarrtaña ñeñt̃ñapaʼ paʼtatssheña ñeñt̃ anmam̃peneʼ puechecnap̃ot̃. ");
INSERT INTO ameNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ñetpaʼ añ muenenetañ oʼch beʼt̃ososet oʼch eʼñe noset Jesúsesho, t̃arraña shonteʼ acheñeneshaʼ ñeñt̃oʼmarña ama eshcayeʼ abeʼt̃osetoña atsnañet̃ att̃och c̈hapachet eʼñe Jesúsesho. Att̃eña aʼtapatoset enot̃ pocollato, ñeñt̃ña pocollpaʼ patsopoʼ. Ñetñapaʼ rrorosetña ñeñt̃ pocollatar enot̃ eʼñe ñeñt̃ecoptaroʼtsen Jesús all patsot̃. Allot̃ña aʼsuatam̃p̃sosetña echarrtaña eʼñe puechecnapeʼna. Att̃oña c̈hapachet eʼñe rroc̈ho alloʼtsen Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesúsñapaʼ eñotapanet ñetpaʼ atarr nanac yemteñet. Allempoña ñapaʼ otapan echarrtaña: —T̃eʼña neyochre, p̃a p̃oʼchñarpaʼ oʼ ap̃retnaʼhuaret̃terra. ");
INSERT INTO ameNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ñehua, allñapaʼ alloʼtsaʼyen ñam̃a puesheñaʼtets ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop. All anorrc̈haʼtyenet ñetñapaʼ atet̃ otatseʼtyeset pueyoc̈hreto: ");
INSERT INTO ameNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Esoʼmareʼtña atet̃ eñenña añ acheñer. Ñeñt̃ atet̃ otenpaʼ ñapaʼ c̈hacaʼye achm̃areʼtenanña Yompor t̃arroʼmar arr patsropaʼ amaʼt eʼñe puesheñarra ama eñalleña ñeñt̃ peretneneʼ ochñarets ñapt̃aña Yompor peretneneʼ ochñarets.” ");
INSERT INTO ameNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesúsña pueyoc̈hropaʼ eñotanet ñeñt̃ atet̃ otyenet ñet pueyoc̈hreto ñocop. Allempoña Jesúspaʼ atet̃ otanet: —Sapaʼ esoʼmareʼtchaʼña atet̃ soct̃apeʼchatseʼtyesña seyoc̈hro. ");
INSERT INTO ameNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Sapaʼ c̈hat̃eʼ soten ñeñt̃ atet̃ oʼ notue echarrtaña poʼchñar oʼ ap̃retnaʼhuaret̃ta, ñeñt̃paʼ ama t̃orrapahuoyaye. Sapaʼ añña atarr t̃orrapoʼ senten att̃och naʼcrrater, c̈honchaʼña oteʼ: “Petantena, pechtaʼnen pemueʼpaʼ oʼch pechopeʼchnen.” ");
INSERT INTO ameNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ñehua, napaʼ oʼch neñotatas na Ñeñt̃en Acheñetosets, napaʼ ñeñt̃en aparet̃en llesens att̃och nach peretnerreʼ ochñarets añ patsro. Ñeñt̃oʼmarña Jesús allempopaʼ atet̃ otan echarrtaña: ");
INSERT INTO ameNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—T̃eʼña napaʼ oʼch notap̃: Petantena, pechtaʼnen pemueʼpaʼ oʼch pechopeʼchnen, ahuenep̃ pepacllo. ");
INSERT INTO ameNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Eʼñe otueʼ atet̃paʼ echarrtañañapaʼ c̈ha tantetsa eʼñe allorocma, oʼ chetaʼnenan poʼmueʼpaʼ c̈haʼnen allot̃. Allohuenña acheñeneshaʼ eʼñe entueñet; ñetñapaʼ c̈ha atarr cohuanrrortapueñet. Ñeñt̃oʼmarña ñet allempopaʼ atarr cohuentatyeññañet Yompor. Ñetñapaʼ atet̃ otyenet: —Yapaʼ amaʼt ahuat̃apaʼ ama yentareña atet̃ ñeñt̃ atarr cohuen. ");
INSERT INTO ameNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesúsñapaʼ alla ahuerrerr saʼpatop̃ño. Allohuen acheñeneshaʼpaʼ alla huac̈herrñañeterr, ñañapaʼ yec̈hatyesapanet. ");
INSERT INTO ameNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Oʼña yec̈hatuanetpaʼ oʼ meterrerr Jesús allot̃, allña oñenpaʼ entnoman ñam̃a Leví ñeñt̃ Alfeo puechemer. Ñañapaʼ alla anen allecma cobraʼyenan acheñeneshaʼ quelle ñeñt̃ gobiernocop. Jesúsñapaʼ atet̃ otosan Leví: —T̃eʼpaʼ oʼch p̃oct̃aʼn att̃och neyochreshaʼ neperrep̃. Eʼñe otueʼ Jesús atet̃paʼ Levíñapaʼ c̈ha tantnomtsapaʼ allent̃a cot̃an Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Allempoña c̈hap ñam̃a allempo Jesúspaʼ alla rrallmeʼchen Leví paʼpacllo. All rrallmeʼchapreteñ shonteʼ acheñeneshaʼ ñeñt̃ poʼtaruas p̃aʼyenet ñamet oʼch cobraʼyenan acheñeneshaʼ quelle ñeñt̃ gobiernocop. Ñetpaʼ atarr ashcañneshaʼ entenanet acheñeneshaʼ. Ñam̃a alloʼtsaʼyen shonteʼ poʼpotantañec̈hno ñeñt̃ atarr ochñat̃eneshaʼ entyen acheñeneshaʼ. Ñetñapaʼ all anorrc̈haʼtyenet all anen Jesús epuet pueyochreshaʼ. T̃arroʼmar shonteʼ acheñeneshaʼ ñeñt̃ cot̃aʼhuaneneʼ Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Añña fariseoneshaʼ ñeñt̃ alloʼtsaʼyen ñam̃a ñeñt̃ etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ ñeñt̃areta judioneshet, ñetña allempo enteñet Jesús all rrallmeʼchapretenan ñeñt̃ atarr ochñat̃eneshaʼ ñetñapaʼ allent̃a otoñet pueyochreshaʼ: —Esoʼmareʼtña ñeñt̃ semaestror sepenpaʼ rrallmeʼchapretenanña añ acheñeneshar ñeñt̃ pueshquëñot̃eʼna cobraʼyeneʼ acheñeneshaʼ ñam̃a epuet acheñeneshaʼ ñeñt̃ atarr ochñat̃eneshac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Atet̃ eʼmanet Jesús, ñañapaʼ atet̃ tomaʼntatanet: —Ñeñt̃ eʼñe huomech entetsapaʼ ñetpaʼ ama eʼneñetoña apartañ. Añña ñeñt̃ atsnaʼtetspaʼ ñetñapaʼ c̈hocma eʼnenet ñeñt̃chaʼ aʼcrraterrahuet. Napaʼ ama añecpayeʼ nohuapo att̃och nec̈horeʼtos ñeñt̃ eʼñe atet̃ entetsañ ñetpaʼ eʼñoʼ cohuen es p̃aʼyenet. Napaʼ añecopña nohuapa att̃och nec̈horeʼtos ñeñt̃ atarr ochñat̃ entyetsa. Allochñapaʼ att̃och oʼch cot̃apeʼcherret ello eʼñe cohuen Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Parrochña allempo t̃oreʼtyena Juan pueyochreshaʼ Yomporecop ñam̃a fariseoneshaʼ pueyochreshaʼ, puesheñaʼtetsña acheñpaʼ huac̈haʼtet Jesúsesho, ñetñapaʼ atet̃ otoset Jesús: —Juan pueyochreshaʼpaʼ t̃oreʼtetset Yomporecop; fariseoneshaʼ pueyochreshaʼpaʼc̈hoʼña t̃oreʼtetset ñamet Yomporecop. P̃aña peyochreshaʼpaʼ esoʼmareʼtña amaña t̃oreʼteneto. ");
INSERT INTO ameNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesúsñapaʼ atet̃ tomaʼntatanetpaʼ ñeñt̃paʼ atet̃ otanet: —Ñeñt̃ ahuaʼñaret̃ec̈hno all rrallmeʼchapreteñet ñeñt̃ eʼñe errteʼ senaʼtetsa, ama pocteyaye oʼch yotanet “amach es serraʼyesatsto” t̃arroʼmar ñeñt̃paʼ atet̃ coshapreteñet ñeñt̃ senaʼtetsa. Amachña c̈ha t̃oreʼteno allempo alloʼtsenmeñ parro ñeñt̃ errteʼ senaʼtetsa. ");
INSERT INTO ameNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","T̃arraña ñerraʼm esempo machayot̃a saʼnerranet ñeñt̃ senaʼtetsa, ñeñt̃ña parro yemuetyenapaʼ allempoña ñetpaʼ eʼñe puellquëñot̃et quec̈hpaʼhuerretchaʼ puerrar, amach arrenayeʼ enterreto. Ñeñt̃paʼ att̃ochña t̃oreʼterret allempo Yomporecop eʼñe poʼñoc̈h. Arrpaʼ allohua huañ ñeñt̃ atet̃ Jesús tomaʼntata ña senaʼtostsa. ");
INSERT INTO ameNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Elloñapaʼ oʼ alla tomaʼntaterraneterr ñeñt̃ atet̃ yec̈hen judioneshaʼ arr patsro ñeñt̃oʼmarña atet̃ otanet: —Yapaʼ ñerraʼm mellashañ yeshtampaʼ amach yelltatsche emarr lletamtso. T̃arroʼmar amaʼt atet̃ yep̃atsechpaʼ ñeñt̃paʼ eʼñech orrena yellteñ t̃arroʼmar ñeñt̃ emarr lletamuetspaʼ ñerraʼm esempo yatsamaʼtam̃pespaʼ c̈hach chellamaʼta c̈hach martseʼtatanña shetamtsosheʼm. Ñeñt̃ña yelltenpaʼ alloʼnach sen rrarrtseʼtats nanac. Ñeñt̃paʼ att̃oña Jesúspaʼ eñotatanet ña poct̃ap̃ña eʼñe etserra. ");
INSERT INTO ameNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jesúsñapaʼ alla tomaʼntaterraneterr poʼpoñ ñeñt̃ atet̃ yec̈hen judioneshaʼ oʼch yec̈hcatenet paʼrrom orrot̃. Ñeñt̃oʼmarña atet̃ otanet: —Amaʼt puesheñarrot̃eyapaʼ amach yeshatstoña vinos emasa mellashaʼm̃añ orrot̃o ñeñt̃ ayec̈hcataret̃ paʼrrom. T̃arroʼmar ñerraʼm atet̃ yepeʼpaʼ oʼch chasaʼña vinospaʼ c̈hach aʼptsan orrot̃, vinosñapaʼ c̈hat̃eʼ eʼñe shebhua, ñeñt̃ña orrot̃paʼ amaʼt mameshapaʼ amach es sherberro. Añña ñerraʼm emasa vinos arrchaʼ yesheʼ emerra orrot̃o ñeñt̃ ayec̈hcataret̃ paʼrrom. Ñeñt̃paʼc̈hoʼña att̃oña Jesúspaʼ eñotatanet ña poct̃ap̃ña eʼñe etserra. ");
INSERT INTO ameNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Allempoña c̈herrerr pamt̃arr allempo c̈hocma amesen judioneshaʼ. Allempoña Jesúspaʼ arr oñem chetsoʼmar epuet pueyochreshac̈hno. Allempo oñenet chetsoʼmar pueyochreshaʼñapaʼ tasoʼtam̃pesyesnomuet puechm̃aʼtets trigo. ");
INSERT INTO ameNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseoneshaʼñapaʼ ñeñt̃ entahuet ñetñapaʼ allent̃a otyeset Jesús: —Pecueʼ esoʼmareʼtña peyochreshaʼñapaʼ atet̃ penet ñeñt̃ ama pocteyaye oʼch atet̃ yep̃a t̃arroʼmar t̃eʼpaʼ añe yet̃ropaʼ ñeñt̃ atet̃ anaret̃ ahuat̃ot̃eñ allempocmach yamesen. ");
INSERT INTO ameNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesúsñapaʼ atet̃ otanet: —Sapaʼ amaʼtrra selleyareña ñeñt̃ atet̃ p̃a ahuat̃ David allempo palltaʼp̃sa ñeñt̃chaʼ rret allempo cheporraʼnma epuet ñam̃a allohuen ñeñt̃ cot̃eneʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ña allempopaʼ beʼt̃osos Yompor paʼpacllo, allñapaʼ rrosan pan ñeñt̃ atmaʼntataret̃ atet̃ ñerraʼmrrat̃eʼ ñeñt̃ nenet all Partsocop. Ñehua, ñeñt̃ panpaʼ ama pocteyayñe oʼch eseshaʼ rreʼ. Ñeñt̃paʼ añach ñapuet̃ rreneʼ cornaneshac̈hno, ñeñt̃paʼ eʼñe atet̃ anuaret̃ judioneshacop. Ñeñt̃ña panpaʼ oʼ rros David, rratosan ñam̃a allohuen ñeñt̃ epuet. Ñehua, ñeñt̃paʼ t̃arrempo atet̃ peʼt̃ David allempo judioneshaʼ poʼcornanesharpaʼ añ paʼm̃chaʼtaret̃er peteʼt̃ Abiatar. ");
INSERT INTO ameNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesúsña alla oterraneterr: —Añ yet̃ro allempo yamesen ñeñt̃paʼ añecop anaret̃ acheñeneshacpay ñeñt̃chaʼ yesherbeneʼ. Amaña añecpayeʼ anaret̃eña yet̃ñats ñeñt̃chaʼ yesherben ya. ");
INSERT INTO ameNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ñeñt̃oʼmar na Ñeñt̃en Acheñetosets, ñeñt̃en allsensaret̃en, nacaʼyeña atet̃ otets est̃eʼ poctetsaña ñeñt̃chaʼ atet̃ yep̃a añe yet̃ro allempocma yamesen. ");
INSERT INTO ameNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Poʼpocheñoña Jesúspaʼ alla beʼt̃osuenerr judioneshaʼ poʼprahuo. Allñapaʼ alloʼtsen puesheñarr yacma ñeñt̃ c̈ha chellena pot. ");
INSERT INTO ameNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Fariseoneshaʼña allpaʼ Jesúsa atarr cohuanaʼtyenet att̃och eñchet ñatoʼrraña aʼcrratenanerrchaʼ acheñ añe yet̃ro allempocma amesenet. Ñerraʼm oʼch aʼcrratenanerr amaʼt puesheñarra añe yet̃ro allempo amesenet, allempoñapaʼ eshecchaʼ aʼmet̃am̃peñetaʼ am̃chaʼtaret̃esho. ");
INSERT INTO ameNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Allempoña Jesúspaʼ otan ñeñt̃ chelletsa pot: —Ap̃on, p̃at̃omos arrma. ");
INSERT INTO ameNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jesúsñapaʼ atet̃ otanet: —¿Errot̃enaʼtña ñeñt̃ eʼñe pocteʼ senten ñeñt̃chaʼ atet̃ yep̃a añ yet̃ro allempo yamesen? Ñatoʼ oʼch atet̃ yepeʼ eʼñe cohuen poʼpsheñeñ, amapaʼ ñatoʼ oʼch atet̃ yep̃oñ ñeñt̃ ama cohuenayaye. ¿Ñatoʼ añt̃eʼ pocteʼ senten oʼch yaʼcrrach acheñ amapaʼ añt̃eʼ pocteʼ senten amach yaʼcrratatsche c̈hachña yemtsatach? Ñetñapaʼ amaʼt puesheñarrot̃etapaʼ ama eseshayeʼ anapaye. ");
INSERT INTO ameNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Allempoña Jesúspaʼ cohuaʼyesanet, amaʼt mamesha ama pocteyeʼ entenaneto, atarr llecateñet t̃arroʼmar ñetpaʼ ama mueneneto oʼch c̈hapanet cohuen pueyoc̈hreto. Allempoña Jesúspaʼ otan yacma ñeñt̃ chelletsa pot: —T̃eʼpaʼ oʼch notap̃, petapuerr p̃ot. Eʼñe otueʼpaʼ ñañapaʼ allent̃epaʼtchaʼ tapuerranña pot, oʼ eʼñe cohuenterra pot. ");
INSERT INTO ameNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Fariseoneshaʼña c̈haʼnmac̈herretpaʼ cot̃apeʼchatannaʼtet epuet Herodes pueyochreshaʼ, ñetñapaʼ Jesúsa atarr oʼpatenet att̃och muetsatachet. ");
INSERT INTO ameNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Allempoña Jesúspaʼ ahuerr saʼpatop̃ñoʼmar pueyochreshaʼna. Shonte acheñ galileoʼmarneshaʼpaʼ cot̃aʼhuanmet ñamet. Ñam̃a shonteʼ poʼpotantañec̈hno acheñeneshaʼ ñetña allempo eʼmareʼteñet Jesús ñapaʼ atarr cohuen orrtatyen ñetpaʼc̈hoʼña allent̃a huac̈haʼtyesoñet ñamet. Allem̃at̃eñ anetsot̃ huac̈haʼtyeset Judeot̃, Jerusaléñot̃, Idumeot̃, Jordanas yom̃taʼnot̃, ñam̃a alloʼmarneshaʼ ñeñt̃ huetsa Tirot̃ ñam̃a Sidónot̃. Ñetpaʼ añ atarr muenenet oʼch enteñetaʼ Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Shonteʼ nanac acheñeneshaʼ. Att̃och ama atarr quec̈hcareʼteñe Jesús acheñeneshaʼ ñeñt̃ shontetsa, ñañapaʼ otan pueyochreshaʼ: —C̈hocmach sehuapaton noñt̃. ");
INSERT INTO ameNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Allempo Jesúspaʼ aʼcrratyesan shonteʼ atsnañet̃ec̈hno ñeñt̃oʼmarña allohuen ñeñt̃ atsnaʼtyets ñetña allempopaʼ atarr emchorreñet Jesús, añ atarr muenenet oʼch aʼp̃lloset Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Añña oneñet̃ec̈hno ñeñt̃ chorraʼyenaya acheñ ñeñt̃paʼc̈hoʼña allempo entoset Jesúspaʼ allepaʼtchaʼ rromam̃p̃sosyet paʼrrp̃ot̃, rranareʼtyesosetpaʼ atet̃ otoset: —¡Pepaʼtña Parets Puechemerep̃! ");
INSERT INTO ameNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesúsñapaʼ ama muenatano oneñet̃ec̈hno oʼch oteñet ñapaʼ poʼñoc̈h Parets Puechemer. ");
INSERT INTO ameNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Allempoña Jesúspaʼ ahuoʼ aspent̃o. Allot̃ña agotatosan ñeñt̃ eʼñe cohuen enten ña ñeñt̃chaʼ pueyochreshaʼ p̃aʼ. Ñeñt̃ agotatenpaʼ ñetña allent̃a ahuanmuet ñesho. Oʼña c̈hac̈haʼtuetpaʼ ");
INSERT INTO ameNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ñañapaʼ napanet ñeñt̃et c̈harrasheñet ñeñt̃ puechetsa epsheña, ñetñapaʼ ñeñt̃chaʼ eʼñe parro chopeñeʼchyen ñam̃a ñeñt̃chaʼ llesensen att̃och serrpareʼtyerret Yompor poʼcohuenña. ");
INSERT INTO ameNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ñam̃a oʼch apuerranet llesens att̃och quec̈hpatyeret oneñet̃ec̈hno acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ñeñt̃ llesensaʼ ñeñt̃paʼ añ paʼsoʼchñec̈hno: Simón ñeñt̃ara oʼ sochererr Pedro, ");
INSERT INTO ameNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","allot̃paʼ ñam̃a Jacobo ñam̃a paʼmoʼnasheñ Juan ñeñt̃ Zebedeo puechemereshaʼ; ñetñapaʼ oʼ socherraneterr Boanerges ñeñt̃ yoten yeñoño T̃ecorenaʼtar. ");
INSERT INTO ameNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Allot̃paʼ ñam̃a Andrés, ñam̃a Felipe, ñam̃a Bartolomé, ñam̃a Mateo, ñam̃a Tomás, ñam̃a Jacobo ñeñt̃ Alfeo puechemer, ñam̃a Tadeo, ñam̃a ñeñt̃ poʼpsheñeñ Simón ñeñt̃ cananistaneshaʼ ñeñt̃ atarr t̃orratseʼt̃ paʼnetsrecop. ");
INSERT INTO ameNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Allot̃paʼ ñam̃a Judas Iscariote ñeñt̃chaʼ pomuerreʼ tsapat̃onet̃ Jesús. Allempoña Jesúspaʼ oʼ alla c̈herrerr pocollo pueyochreshaʼna. ");
INSERT INTO ameNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Allñapaʼ oʼ alla shonterrñañerr allohuen acheñeneshaʼ, ñeñt̃oʼmarña allempopaʼ ama eshcayeʼ rreneto. ");
INSERT INTO ameNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Allempo eʼmareʼch Jesús pamoʼtseshaʼ atet̃ p̃aʼyenapaʼ ñetñapaʼ huac̈haʼtet oʼch eretaʼ Jesús t̃arroʼmar ñetpaʼ otenapuetañ ñatoʼ c̈hot̃eʼ oʼ mospaña Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Puesheñaʼtetsña ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ ñetpaʼ Jerusaléñot̃ huac̈haʼtet. Ñetñapaʼ atet̃ otyesoset Jesúsocop: —Añ yacmarpaʼ añacaʼye chorrenaya Beelzebú ñeñt̃ pompor pen allohuen oneñet̃ec̈hno; ñeñt̃caʼyeña ahuamencat̃ peneʼ att̃ot̃ quec̈hpatenanña oneñet̃ec̈hno acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Allempoña Jesúspaʼ c̈horeʼtan acheñeneshaʼ, allempoñapaʼ atet̃ otapanet: —Oʼch notas, poʼñoc̈h oneñet̃paʼ amacaʼye huaporeʼtanneno. ");
INSERT INTO ameNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Atet̃ ñerraʼm pat̃err am̃chaʼtaret̃ ñerraʼm c̈ho elloptannena pueyochreshaʼ ñeñt̃ña att̃o am̃chaʼtaret̃tena c̈hach huañerrets amach alloʼna huomencatneno. ");
INSERT INTO ameNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Att̃ecmach p̃annerra ñam̃a ñeñt̃ eʼñe pamoʼtsnaʼtarecmuet p̃annenet ñerraʼm c̈ho elloptannenet eʼñe ñagattsetapaʼ ñeñt̃ña att̃o huomencatenetpaʼ ñeñt̃paʼc̈hoʼña c̈hachcaʼye huañerrets. ");
INSERT INTO ameNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Att̃ecmach p̃annerra ñam̃a oneñet̃ pueyochreshac̈hno, ñerraʼm oneñet̃ec̈hno eʼmoneʼtannenet, ñerraʼm tantannaʼta oneñet̃ec̈hnopaʼ ñeñt̃ña att̃o huomencatenetpaʼ ñetpaʼc̈hoʼña c̈hachcaʼye huañerrets amach alloʼna huomencatneneto. Ñeñt̃oʼmarña poʼñoc̈h oneñet̃paʼ amat̃eʼ errot̃enot̃ huaporeʼtannaʼteto eʼñe ñagattseta. ");
INSERT INTO ameNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Ñehua, yapaʼ yeñoteñ ñeñt̃ atarr ahuamencat̃tetsa att̃o atarr ahuamencat̃tena oneñet̃, ñañapaʼ eʼñe poʼhuamencot̃ cohuam̃pesyenan allohuen eʼñe cohuen ñeñt̃ paʼpaquëll p̃aʼyen. T̃arraña ñerraʼm esempo oʼch huapoña ñeñt̃ atarr ahuamencat̃eshaʼ ñeñt̃chaʼ metanoseʼña poʼhuamenc atet̃ ñerraʼm na Nompor, ñeñt̃chaʼña rromoseʼ oʼch huancos, allochñapaʼ oʼch beʼt̃osos all ñeñt̃ paʼpaquëll p̃aʼyen oʼch eʼñe puerratam̃p̃sos ñeñt̃ allpon oʼpatyena ña. ");
INSERT INTO ameNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Jesúspaʼ alla oterraneterr: —Napaʼ oʼch notas, poʼñoc̈h allohuen paʼnamen sosyaʼtsañec̈hno ñeñt̃ ama pocteyeʼ enteno Yompor amaʼt ñam̃a achm̃areʼtannaʼteñets ñeñt̃paʼ ap̃retnaʼpoʼ nenteñ. ");
INSERT INTO ameNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","T̃arraña ñerraʼm eseshaʼ añ achm̃areʼteññañet Parets Puecamquëñ ñeñt̃ñapaʼ amacaʼye ap̃retnaʼpahuoyeʼ nenteñe. Ñeñt̃ña poʼchñaretpaʼ amachcaʼye ap̃retnaʼpahuoterro eʼñe t̃ayot̃eñ errponohuañen. ");
INSERT INTO ameNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ñehua, ñeñt̃paʼ atet̃ otanet Jesús t̃arroʼmar ñetpaʼ atet̃ otyeñet Jesús, ñapaʼ añoʼ chorrenaya oneñet̃ ñeñt̃oʼña ahuamencat̃ peneʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Allempoñapaʼ huapa Jesús pachor epuet ñam̃a paʼmoʼnasheñneshaʼ. C̈hapuet allpaʼ ñetñapaʼ alla t̃omc̈haʼtoset aʼyot̃, allot̃ña agotatoset Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ñeñt̃ anorrc̈haʼtyets epuet Jesús ñeñt̃ arrotam̃penaya, ñetñapaʼ atet̃ ochet: —Oʼcaʼye huapa p̃achor ñam̃a pemoʼnasheñneshaʼ. Ñetpaʼ aʼyot̃eʼtsaʼyenet, p̃acaʼye eʼnenet. ");
INSERT INTO ameNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesúsñapaʼ atet̃ otanet: —Amaʼt señoteñe ñeñt̃ eʼñe poʼñoc̈h nachor nepen ñam̃a ñeñt̃ eʼñe poʼñoc̈h nemoʼnasheñ nepen. ");
INSERT INTO ameNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Allempoñapaʼ cohuaʼyesan acheñeneshaʼ ñeñt̃ arrotam̃penaya all anorrc̈henet. Allempoñapaʼ atet̃ oterraneterr: —Napaʼ añcaʼyeña ñeñt̃ poʼñoc̈h nachor nepen ñam̃a ñeñt̃ poʼñoc̈h nemoʼnasheñneshaʼ nepen. ");
INSERT INTO ameNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ñehua, amaʼt erraʼtsena ñeñt̃ eʼñe atet̃ p̃ohueneʼ ñeñt̃ atet̃ muenen Nompor ñeñt̃ pueʼntañoʼtsen ñeñt̃caʼyeña eʼñe poʼñoc̈h nemoʼnasheñ nepen ñeñt̃ña noc̈h nepen ñeñt̃ña nachor nepen. ");
INSERT INTO ameNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesúsñapaʼ alla yec̈haterranerr acheñeneshaʼ eʼñe alla saʼpatop̃ño. Allña emchorraʼhuererr shonteʼ acheñeneshaʼ. Ñeñt̃oʼmarña Jesúspaʼ aʼtap noñt̃opaʼ ahuam̃pes mameʼ allpononet̃ allñapaʼ anorros noñt̃o eʼñe all saʼpo. Acheñeneshaʼña allohuenetpaʼ eʼñe saʼpatop̃ñoʼtsaʼyenet all mast̃o. ");
INSERT INTO ameNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Allñapaʼ esocmañen serrpareʼtatenan acheñeneshaʼ paʼnamen tomaʼnteñtsoc̈hno. All yec̈hatyenanetpaʼ atet̃ otanet: ");
INSERT INTO ameNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Seʼm̃ñoton añ ñeñt̃ atet̃ notenes: Ñeñt̃ña aʼparreneʼ puerets ñañapaʼ ahuoʼ allchaʼ aʼparreʼtyenanaʼ puepuer. ");
INSERT INTO ameNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","All aʼparreʼtyeñ patantaʼtetsñapaʼ alla c̈hapyes t̃oñoʼmar. Allñapaʼ huac̈haʼtyesa ot̃ eʼñe añyallmeʼchuenanaʼ puerets. ");
INSERT INTO ameNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Poʼpoñec̈hnoñapaʼ alla c̈hapyes mapuetroʼmesoʼmar all ama tama eñalle pats. Ama nanac oʼponoʼtseno patso ñeñt̃oʼmarña mamet̃ollapaʼ cheparesuañ. ");
INSERT INTO ameNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Oʼña enomeʼtaʼmuen atsrret̃paʼ alla aʼuyatuer. Ama erc̈haʼtenaʼ ñeñt̃oʼmarña alla hueyaʼhuerra. ");
INSERT INTO ameNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Poʼpotantañña pueretspaʼ alla c̈hapyes allchaʼ chepares aj. Allpaʼc̈hoʼ mameshapaʼ cheparesuañpaʼ ajñapaʼ mameshapaʼ ateshaʼtua alla caʼmatuerranña narmets alla aʼcllatuer, ñeñt̃oʼmarña ama ellom̃reʼto. ");
INSERT INTO ameNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Poʼpotantañec̈hno ñeñt̃ñapaʼ arr c̈hapyes all eʼñe cohuen patso. Ñeñt̃ñapaʼ eʼñe cohuen chepares. Allempoña ateshaʼtuapaʼ oʼ ellom̃reʼtyes. Atarr atonapaʼtets ellom̃reʼtyes—puechaʼtetspaʼ maʼpoch c̈harraʼ pueʼllomer, poʼpchañec̈hnoñapaʼ pechapoch c̈harraʼ pueʼllomer, poʼpchañec̈hnoñapaʼ c̈harroch c̈harraʼ pueʼllomer. ");
INSERT INTO ameNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Allempoña Jesúspaʼ alla oterraneterr: —Ñeñt̃es poʼñoc̈h neʼm̃ñoteneʼ, c̈haponasepaʼch seyoc̈hro ñeñt̃ atet̃ netmaʼntatensa añ ñoñets. ");
INSERT INTO ameNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Allempoña patmuerra acheñpaʼ oʼ ñapt̃am̃a Jesús epuet ñam̃a pueyochreshaʼ ñam̃a puesheñaʼtets poʼpotantañ ñeñt̃ alloʼtsaʼyen, ñetñapaʼ atet̃ ochet Jesús: —Taʼm ¿est̃eʼña petmaʼntatenyaña ñorraʼ? ");
INSERT INTO ameNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesúsñapaʼ atet̃ oterraneterr: —Sa t̃eʼpaʼ Yomporña semnateneʼ att̃och señoterr ñeñt̃ ama eñotpahuoyaye amaʼt ahuat̃ot̃eñ atet̃ penaña Yompor poʼcohuenña att̃o ayochreshat̃tena ña. T̃arraña poʼpotantañec̈hno ñeñt̃ att̃a es puec̈haʼyetsa, ñocpuetpaʼ ama eñoteñeto ñeñt̃ atet̃ atmaʼntataret̃ ñoñets. ");
INSERT INTO ameNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Att̃oña amaʼt enteñetañ ñetñapaʼ amach errot̃enot̃ es c̈hapahueto pueyoc̈hreto. Amaʼt eʼmueñetañ amach c̈henanetoña pueyoc̈hreto ñeñt̃ atet̃ yec̈hateney Yompor poʼcohuenña. Att̃oña amach cot̃apeʼcherreto ello cohuen Yomporecop att̃och ñach peretnerrahuet poʼchñaret. ");
INSERT INTO ameNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesúsñapaʼ alla oterraneterr: —Sapaʼ amaʼt mameshapaʼ areʼt señotenoña ñeñt̃ oʼ netmaʼntatuasa ñorraʼ. Ñerraʼm ama c̈hennaso seyoc̈hro ñeñt̃ oʼ netmaʼntatuasa ñorraʼpaʼ errot̃enot̃uachñacaʼyeña c̈haponasaña seyoc̈hro allohuen poʼpoñec̈hno ñeñt̃chaʼ netmaʼntaterrserr tsapat̃onet̃. ");
INSERT INTO ameNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Allempoña Jesúspaʼ eñotatanet ñeñt̃ atet̃ oʼ tomaʼntatuanet ñoñets ñocpuet, ñeñt̃paʼ atet̃ otanet: —Ñeñt̃ aʼparreʼtyeneʼ puerets, ñeñt̃ña pueretspaʼ añcaʼye notenes Yompor poʼñoñ allempo serrpareʼteñet. ");
INSERT INTO ameNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Añ puerets ñeñt̃ c̈hapyets t̃oñoʼmar ñeñt̃paʼ añ notenes acheñeneshaʼ ñeñt̃ eʼm̃ñotenayeñ Yompor poʼñoñ. Allempo eʼm̃ñotuetpaʼ allorocmach huapa oneñet̃ oʼch alla puerratam̃perranet Yompor poʼñoñ amaʼt allpon ñeñt̃ eñotetañ pueyoc̈hreto. ");
INSERT INTO ameNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Ñam̃a ñeñt̃ c̈hapyesets mapuetroʼmesoʼmar ñeñt̃paʼ añ notenes acheñeneshaʼ ñerraʼm esempo eʼm̃ñoteññañet Yompor poʼñoñ eʼñech allorocma pocsheñeshaʼ aguëññañetañ Yompor poʼñoñ. Eʼñech cohuen ameʼñeretañ t̃arraña ñeñt̃paʼ mamecpach atet̃ penet. T̃arroʼmar ñetpaʼ eʼñe atet̃ penet ñerraʼmrrat̃eʼ narmets ñeñt̃ chepuets mapyo amach eñalle puerec̈h. Tsapat̃onet̃ña ñerraʼm oʼch huapanet topateñets ñeñt̃chaʼ mueroc̈htatahuet t̃arroʼmar ñetpaʼ oʼ ameʼñeretañ Yompor poʼñoñ, ñetñapaʼ allorocmach alla quec̈hpuerrñañet Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ñam̃a poʼpoñec̈hno puerets ñeñt̃ c̈hapyets ajmoʼmar ñeñt̃paʼ añ netmaʼntatena poʼpotantañ acheñeneshaʼ ñeñt̃ eʼm̃ñotenayeñ Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Amaʼtchaʼ c̈hapanetañ pueyoc̈hreto t̃arraña ñetpaʼ alloʼnach senet eʼñech aña atarr cot̃apeʼchenet ñeñt̃ llecaʼyenet arr patsro ñeñt̃ eʼñe ñocpueta. Añach muenenet oʼch esocmañen es echyenet t̃arraña ñeñt̃paʼ c̈hacaʼye shequënanet. Att̃ach paʼnamen yeʼchatseʼtyenet. Att̃oña huenanet topateñets ñeñt̃oʼmarña ñetpaʼ amach errot̃enot̃ orrtatoñetoña ñeñt̃ eʼñe cohuen enten Yompor. Ñetpaʼ eʼñe att̃eta ñerraʼm narmets ñeñt̃ c̈ha caʼmateñ ajmaʼ ñeñt̃oʼmarña amach errot̃enot̃ meʼteneto oʼch ellom̃reʼtyeset. ");
INSERT INTO ameNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ñam̃a añ puerets ñeñt̃ c̈hapyesets eʼñe cohuen patso ñeñt̃ eʼñe cohuen cheparsatspaʼ ñeñt̃ña tomaʼntenaya poʼpotantañ acheñeneshaʼ ñeñt̃ eʼm̃ñoteneʼ Yompor poʼñoñ. Ñoñetsñapaʼ eʼñech cohuen c̈henanet pueyoc̈hreto. Ñetñapaʼ ñeñt̃et poʼñoc̈h orrtatenet ñeñt̃ atarr sherbets Yomporecop. Att̃oña ñetpaʼ eʼñe atet̃ penet ñerraʼm narmets ñeñt̃ atarr meʼtets—pat̃eʼtets maʼpoch c̈harraʼ pueʼllomer, poʼpoñpaʼ pechapoch c̈harraʼ pueʼllomer, poʼpoñpaʼ c̈harroch c̈harraʼ pueʼllomer. ");
INSERT INTO ameNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesúsñapaʼ alla tomaʼntaterraneterr, ñeñt̃paʼ atet̃ oterraneterr: —Ñerraʼm esempo yaʼllchaten lampareñ, ñeñt̃paʼ ama añecpayeʼ yehuapateñe oʼch alla yeʼrramam̃p̃sos coym̃o. Ñam̃a ama añecpayeʼ yaʼhuortatenoña lampareñ oʼch yeneʼ oʼponot̃ yemayep̃nac̈ho. Añecopña yaʼhuortatenña lampareñ oʼch yeneʼ enonet̃ att̃och c̈hoyoʼtam̃pesuan allohuen ñeñt̃ alloʼtsaʼyen. ");
INSERT INTO ameNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","T̃arroʼmar allohuen paʼnamen ñeñt̃ ama eñotpahuoyaye amaʼt ahuat̃ot̃eñ, t̃eʼñapaʼ oʼch eʼñe orrtataret̃terra att̃ochña oʼch eʼñe eñotataret̃etuerret eʼñe poctacma. ");
INSERT INTO ameNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ñeñt̃es poʼñoc̈h neʼm̃ñoteneʼ c̈haponasepaʼch seyoc̈hro ñeñt̃ atet̃ netmaʼntatensa añ ñoñets. ");
INSERT INTO ameNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesúspaʼ alla oterraneterr: —Sapaʼ señotenat̃eʼ eʼñet̃eʼ poʼñoc̈h cohuen seʼm̃ñoteññañ Yompor poʼñoñ ñatoʼpaʼ amat̃eʼ. T̃arroʼmar ñerraʼm errot̃ sep̃oñ poʼpsheñeñ ñeñt̃ ama cohuenayaye Yomporñapaʼ att̃ecmach perres sam̃a. Ñam̃a ñerraʼm eʼñe cohuen sepenanet, Yomporñapaʼ eʼñech cohuen perres sam̃a amaʼt ellonet̃ oʼch apuerres ñeñt̃ eʼñe cohuen. ");
INSERT INTO ameNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","T̃arroʼmar eseshaʼt̃eʼ c̈hena pueyoc̈hro amaʼt eʼñe allpona Yompor poʼñoñ, elloña Yomporpaʼ alloʼnach eñotatnenanet nanac shonteʼ. T̃arraña eseshaʼña ñerraʼm ama c̈henaneto pueyoc̈hreto t̃arroʼmar ñetpaʼ ama poʼñoc̈hayeʼ aguëññañeto Yompor poʼñoñ, amaʼt allpon eñotyenetañ pueyoc̈hro ñeñt̃ñapaʼ c̈hach puerratam̃perranet Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesúspaʼ alla tomaʼntaterraneterr, ñeñt̃paʼ atet̃ oterraneterr: —Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña, ñeñt̃paʼ atet̃ pena ñerraʼmrrat̃eʼ puesheñarr acheñ ñeñt̃ nareʼteneʼ puepuer. Oʼchña nareʼtuepaʼ oʼch ahuerr paʼpacllo. ");
INSERT INTO ameNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Allach allponmaterraʼ oʼch tsapuenpaʼ allach mueneʼt̃, yet̃oñapaʼ c̈hocmach tantaʼmueneʼt̃, puepuerñapaʼ att̃eñapaʼ oʼch chepua oʼch ateshaʼta. Pamoʼmteʼñapaʼ amach eʼñeyeʼ eñoteñe errot̃enot̃t̃eʼña chepyen. ");
INSERT INTO ameNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ñehua, yeñoteñ patspaʼ ñeñt̃caʼye aʼchpateneʼ yepuer eʼñe ñot̃a. C̈hoch ñanom c̈hoʼpeʼchyes allempoñapaʼ oʼch atarrchet c̈hoch potsets att̃och ellom̃reʼtyes, att̃ot̃achc̈hoʼ eʼñe poʼnuen. ");
INSERT INTO ameNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Eʼñe errteʼ poʼnetspaʼ eʼñech allorocma mueñan ñeñt̃chaʼ tsorrenayaʼ. Oʼcaʼ c̈hen allempoch apc̈henetña ñeñt̃ narmetser. ");
INSERT INTO ameNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesúsña ellonet̃paʼ atet̃ oterraneterr: —Añ Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña—ñanompaʼ eʼñech puesheñaʼttsa ameʼñaʼyestsa, allempot̃eññapaʼ alloʼnach sen atonetnomtsa ñeñt̃chaʼ ameʼñerrtsa, att̃ochña eʼñe epaʼhuerra erracmañen Yompor poʼcohuenña. Ñeñt̃ña t̃eʼpaʼ oʼch netmaʼntatasa ñeñt̃ atet̃ pena ña. ");
INSERT INTO ameNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ñeñt̃paʼ atet̃ pena ñerraʼmrrat̃eʼ añ pueʼllomer ñeñt̃ atarr añet̃olleshallmerr ñeñt̃ otenet mostazllom̃. Ñeñt̃ña pueʼllom̃ret̃ollpaʼ oʼch nareʼchet patso. Ñehua, eʼñe yeñoteñ mostazllom̃ ñeñt̃paʼ atarrcaʼye nanac añet̃olleshallmerr. ");
INSERT INTO ameNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","T̃arraña ñerraʼm oʼch nareʼchetpaʼ allempoña choppaʼ alloʼnach sen rrorranmats cohuen, atarrchetnomuets, elloch metanaʼtuan poʼpchañ narmetsoc̈hno. Puetacreʼnach ateshatacrerrtatsa. Allñapaʼ oʼch huac̈haʼtoña ot̃ec̈hno oʼch rremaʼrrartosa puetacroʼmar poʼmañt̃ero. ");
INSERT INTO ameNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Shonteʼ poʼpoñec̈hno ñeñt̃ alla tomaʼntaterraneterr att̃o serrpareʼtatenanet Yompor poʼñoñ. Att̃oña eʼñe allpona serrpareʼtatanet ñeñt̃ñapaʼ eʼñe cohuen eñotatanet pueyoc̈hreto. ");
INSERT INTO ameNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ama serrpareʼtatenaneto att̃a, añña c̈hocma serrpareʼtatenanet tomaʼnteñtso. Ellonet̃paʼ c̈hocma eʼñe eñotoc̈hen serrpareʼtatenan pueyochreshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ñeñt̃e yet̃rocma eʼñe ellerronet̃ Jesúsñapaʼ otan pueyochreshaʼ: —T̃eʼpaʼ oʼch ahuam̃p̃sey yom̃taʼn. ");
INSERT INTO ameNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Pueyochreshaʼna sohuanmet acheñeneshaʼ. Ñeñt̃ara noñt̃o alloʼtsen Jesúspaʼ alloña anmam̃peñet Jesús oʼch ahuam̃p̃set yom̃taʼn. Allñapaʼ cot̃aʼhuanmanet poʼpnañec̈hno noñt̃ec̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Allempo ahuam̃p̃set allñapaʼ machayot̃epaʼtchaʼ huomenquëshatam̃pesnomuet. Emoʼyareʼña c̈ha eshaʼtena noñt̃o att̃eña oññapaʼ chorramoch noñt̃o. ");
INSERT INTO ameNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesúsñapaʼ alla muen puepopato alla ñotena. Pueyochreshaʼña opueretpaʼ atet̃ ochet: —¡Maestro, amahuacaʼye pellquënyot̃eʼ oʼrramcheʼ yocllaʼhuamocha! ");
INSERT INTO ameNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesúsña tanterrapaʼ eʼñe poʼñoñot̃a aʼmtsoññetuerran huomenquëshaʼ. Ñam̃a poʼñoñot̃a aʼmtsoñeñterran saʼp ñeñt̃ emoʼyartetsa, ñeñt̃paʼ atet̃ ot: —¡Muechecherrepaʼ, muetsoñeñterrepaʼ! Eʼñe otueʼpaʼ c̈ha muechecherrtsaña huomenquëshaʼ. Att̃oña ñetpaʼ oʼ alla muechet̃tam̃perret eʼñe cohuen. ");
INSERT INTO ameNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Allempoña Jesúspaʼ atet̃ otanet: —Sapaʼ esoʼmareʼtña c̈ha atarr seyoren. Esoʼmareʼtña ama eʼñeyeʼ seyemtenno. ");
INSERT INTO ameNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ñetñapaʼ c̈ha atarr nanac yorenet, atet̃ otannaʼtyeset: —Taʼmcaʼye añ acheñerpaʼ esonaʼtart̃eʼcaʼye. Atarrepaʼt es aʼmchechaten, amaʼt poʼñoñot̃apaʼ aʼmchechaterran huomenquëshaʼ amaʼt ñam̃a emoʼyareʼ oñ. ");
INSERT INTO ameNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Allempoñapaʼ oʼ etsotoset yom̃taʼn all sechenet. Allñapaʼ añ paʼney peneʼ gadaroʼmarneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesúsñapaʼ sehuosa all noñt̃ot̃, allñapaʼ huapoña puesheñarr yacma t̃arraña ñapaʼ añ chorrenaya oneñet̃. Ñeñt̃paʼ arrot̃ huapa allecma pampaʼyeñet arromñat̃ec̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Ñehua, ñapaʼ alla yec̈hena all pampueñet arromñat̃ec̈hno. Amaʼt puesheñarrapaʼ ama eseshayeʼ errot̃ penaye att̃och aʼmchecheret. Amaʼt c̈hocma huanquëñetañ asrerec̈ho paʼtcot̃ ñam̃a potot̃, ñañapaʼ c̈hach tsepeʼtuerranña asrerec̈h allo huanquëñet potot̃ ñam̃a paʼtcot̃ c̈hach rrollapecheñ oʼch eʼñe tsepeʼtatue. Ñeñt̃oʼmarña amaʼt eʼñe eseshapaʼ ama eshcayeʼ aʼmchecheñeto. ");
INSERT INTO ameNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Allñapaʼ ellapeneʼt̃chaʼ ñam̃a arepeneʼt̃chaʼ chopeñeʼchyesets apampañoʼmar ñam̃a aspent̃areroʼmar. Allñapaʼ allecma atarr amaʼtoc̈htena, tsotseʼtyena mapyo eʼñe ñañeña. ");
INSERT INTO ameNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","T̃arraña allempo entapan Jesús aʼyot̃eñ allent̃epaʼtchaʼ matosa concorpanaʼtosana Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Allempoña Jesúspaʼ atet̃ otosan oneñet̃ ñeñt̃ chorrenaya ñeñt̃ yacmar, atet̃ otos: —Oʼch oneñet̃e notosep̃ t̃eʼñapaʼ ¡pequec̈hpaʼner añ acheñer! Ñeñt̃oʼmarña ñeñt̃ chorrena oneñet̃paʼ rranosa huomencpaʼ atet̃ otapan Jesús: —Esoʼmaruachcaʼye Jesúsochaʼ p̃atsrreʼmoc̈htanaʼtosna, p̃apaʼ ñeñt̃ep̃ Ñeñt̃ nanac Parets Puechemerep̃. T̃eʼpaʼ oʼch notapap̃ eʼñe Parets paʼsoʼchño, amach c̈ha pecoñchatatstosno. ");
INSERT INTO ameNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesúsñapaʼ alla oterranerr ñeñt̃ chorrena oneñet̃: —P̃apaʼ ¿esoʼtña pesoʼcheñ? Ñañapaʼ atet̃ oterranerr Jesús: —Napaʼ añ nesoʼcheñ Legión t̃arroʼmar yapaʼ nanac patonrey. ");
INSERT INTO ameNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Allempoña ñeñt̃ chorrena oneñet̃paʼ ñañapaʼ atet̃ otareʼtapan Jesús: —Amach pemñoʼtatsterrye allap̃ar b̃ac̈hayo. ");
INSERT INTO ameNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ñehua, allpaʼ aʼyent̃eʼtsaʼyen shonteʼ chañchoc̈hno ñeñt̃ rratseʼtyets aspent̃onet̃. ");
INSERT INTO ameNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ñeñt̃oʼmarña oneñet̃ec̈hnopaʼ atet̃ otareʼtapet Jesús: —Ñerraʼm c̈hoch mueneʼ errot̃en pep̃oseypaʼ arrña pemñayeʼchosey chañchesho allochñapaʼ oʼch yechorraʼyererr ñam̃a chañchoc̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesúsñapaʼ allent̃a otanet: —Amaʼtcaʼyepaʼ orrascaʼye. Allempoña oneñet̃ec̈hnopaʼ quec̈hpaʼneret acheñ oʼ chorrereterr ñam̃a chañchoc̈hno. Chañchoña allempo chorrosya oneñet̃ec̈hnopaʼ c̈hepaʼtchaʼ matrraʼtua ñegonet̃, shorc̈haʼtuos allot̃paʼ eʼñe ñoʼshrraʼtuosa oño. Ñeñt̃ña chañchoc̈hnopaʼ alloʼtsent̃eʼ epoch mil. ");
INSERT INTO ameNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Acheñeneshaʼña ñeñt̃ cohuam̃peneʼ chañcho, ñetñapaʼ allent̃a matrraʼtet ñamet poʼyorñot̃ ahuanmuet anetso. Allñapaʼ serrpareʼtyesoset ñam̃a ora allohuen allampañoʼmar. Acheñeneshaʼñapaʼ allent̃a ahuanmuet ahuoʼch enteñetaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Oʼ c̈hac̈haʼtet Jesúseshopaʼ allñapaʼ entoset yacma ñeñt̃ chorreʼt̃ oneñet̃ec̈hno alla anen ashtamat̃, oʼ eñoterra, oʼ cohuenterra. Ñetñapaʼ c̈ha atarr mechaʼnaʼtoset. ");
INSERT INTO ameNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Añña ñeñt̃ enteneʼ Jesús att̃o quec̈hpaterran oneñet̃ acheñ, oʼ alla mueñererr chañchesho, ñetñapaʼ allent̃a serrpareʼtatyesapet ñeñt̃ huac̈haʼttsa anetsot̃. ");
INSERT INTO ameNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Allempoña acheñeneshaʼ ñeñt̃ yec̈hetsa allpaʼ atet̃ ochet Jesús: —T̃eʼpaʼ ahuerrep̃ arrot̃ yenyot̃. ");
INSERT INTO ameNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Allempoña Jesúspaʼ aʼterr noñt̃o oʼch ahuerr, yacmaña ñeñt̃ chorreʼt̃ oneñet̃ ñañapaʼ allent̃a otan Jesús: —Napaʼ nemneñcaʼye t̃eʼpaʼ oʼch noct̃errep̃. ");
INSERT INTO ameNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","T̃arraña Jesúsñapaʼ ama muenache atet̃ och: —Allap̃ach, t̃eʼpaʼ oʼch ahuerrep̃ pepacllo pamoʼtseshoʼmar oʼch peserrpareʼtatuerranet ora allohuen att̃o Yomporpaʼ atarr yenposep̃ ñam̃a att̃o atarr muerosp̃a. ");
INSERT INTO ameNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ñañapaʼ atet̃ otue Jesúspaʼ atet̃c̈hoʼ p̃a. Allent̃a ahuerr serrpareʼtyesnerrets ora anetsoʼmar amaʼt all oteñet Decapoliso att̃o Jesúspaʼ atarr nanac yenpos. Allohuenña acheñeneshaʼpaʼ att̃a atarr cohuanrrorteñet. ");
INSERT INTO ameNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Allempoñapaʼ ahuam̃perrerr Jesús noñt̃o, oʼ alla c̈herrerr añem̃taʼn allot̃ ta ahuaña. Allñapaʼ oʼ alla emchorraʼhuererr shonteʼ acheñeneshaʼ eʼñe all saʼpatop̃ño. ");
INSERT INTO ameNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Allñapaʼ huapoña puesheñarr am̃chaʼtaret̃ ñeñt̃paʼ añ paʼsoʼcheñ Jairo. Ñapaʼ ñeñt̃ puesheñarr ñeñt̃ am̃chaʼtaret̃tetsa judioneshaʼ poʼprahuo. Allempo entosan Jesúspaʼ ñañapaʼ alla rromosa Jesús paʼrrp̃ot̃. ");
INSERT INTO ameNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Allñapaʼ atet̃ otos: —Nesñet̃ollañac̈hoʼ oʼ c̈ha aʼpoʼntsena. Ñeñt̃oʼmarña napaʼ nohuennap̃a oʼch p̃oct̃erren nepacllo. Amaʼt p̃otot̃apaʼ oʼch p̃aʼp̃lleñaʼ att̃och p̃aʼcrrater oʼch alla huom̃cherra. ");
INSERT INTO ameNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesúsñapaʼ allent̃a cot̃aʼner, allent̃a cot̃aʼhuanem̃ ñam̃a shonteʼ acheñeneshaʼ c̈ha emchorratseʼtnomet, c̈ha toʼmamaʼtneñet. ");
INSERT INTO ameNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Allñapaʼ cot̃aʼnmanet ñam̃a puesheñarr coyaneshaʼ ñeñt̃ atsnaʼtets. C̈harraʼ puechena epa char ñeñt̃ att̃o c̈hocma yellaʼyena. ");
INSERT INTO ameNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Epayeʼ mueroc̈htateñ shonteʼ apartañec̈hno ñeñt̃ partenayeñ. Amaʼt oʼ aʼgastaʼhuahuan ora allpon quelle echen att̃o partatena ñañapaʼ att̃era amaʼt mameshapaʼ ama c̈hoyeʼ pasateñe. Elloña alloʼna sen aʼpoʼntsaʼnmatsa. ");
INSERT INTO ameNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ñeñt̃ coyaneshaʼpaʼ oʼ eʼmareʼtan Jesús ñeñt̃ att̃o c̈hocma aʼcrratyenan atsnañet̃ec̈hno. Ñeñt̃oʼmarña allempo cot̃aʼhuanem̃ Jesús acheñeneshaʼpaʼ ñapaʼc̈hoʼña allent̃a cot̃aʼnman Jesús chentaʼ paʼcheʼñot̃. Att̃oña allpaʼ aʼp̃llaʼnmoñ paʼshtam. ");
INSERT INTO ameNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","T̃arroʼmar ñapaʼ atet̃ cot̃apeʼchen pueyoc̈hro: “Amaʼt paʼshtama naʼp̃lloñpaʼ ñeñt̃achcaʼ naʼcrraterreʼ.” ");
INSERT INTO ameNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Eʼñe aʼp̃llaʼhueʼ paʼshtampaʼ allorocmuepaʼtchaʼ maserrña poʼrras. Ñapaʼ eʼñe eñotena poʼchtso oʼ metueña ñeñt̃ mueroc̈htateneʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesúsñapaʼ eñotnom̃ eʼñe ña poʼhuamencot̃paʼ oʼ aʼcrratnoman puesheñarr atsnañet̃. Ñañapaʼ allent̃a puerraperra alla acheñenesheshonet̃ ñeñt̃ cot̃aʼhuaneneʼ, allñapaʼ atet̃ otanet: —¿Eseshaʼtña oʼ aʼp̃llaʼnmuenña neshtamot̃? ");
INSERT INTO ameNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Pueyochreshaʼñapaʼ atet̃ ochet: —Pentent̃eʼ shonteʼ acheñeneshaʼ ñeñt̃ allot̃emeña petoʼmamaʼtneneʼ. Esoʼmareʼtña p̃otenña eseshaʼt̃eʼ p̃aʼp̃lleneʼ peshtamot̃. ");
INSERT INTO ameNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesúsñapaʼ alla cohuaʼyesanet oʼch entan ñeñt̃ aʼp̃lleneʼ paʼshtamot̃. ");
INSERT INTO ameNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ñeñt̃ña coyaneshaʼpaʼ ñapaʼ oʼ eñotnoma Jesúscaʼyeña oʼ aʼcrratnom̃. Ñañapaʼ c̈ha paʼshmuena poʼyorñot̃ allempoñapaʼ concorposa Jesús paʼrrp̃ot̃. Allñapaʼ eʼñe aʼmet̃aʼnman ora allpon ñeñt̃ poʼñoc̈h atet̃ cot̃apeʼchen. ");
INSERT INTO ameNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesúsñapaʼ atet̃ otapan coyaneshaʼ: —P̃apaʼ nesñeshachaʼ att̃o atarr peyemtenna na, att̃oña t̃eʼpaʼ oʼ eʼñe naʼcrratnomuep̃. T̃eʼñapaʼ oʼch ahuerrep̃ peñmañeshaʼ, t̃arroʼmar amach alla mueroc̈htaterrperro atsnañets. ");
INSERT INTO ameNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Allempo eñorena atet̃paʼ allñapaʼ huac̈haʼta ñeñt̃ huetsa am̃chaʼtaret̃ Jairo paʼpacllot̃. Ñetña huapuetpaʼ atet̃ otoset Jairo: —Peseñpaʼ oʼcaʼye rroma. T̃eʼñapaʼ amach alloʼna p̃atsrreʼmoc̈htanaʼtatsche Maestro oʼch cot̃errep̃ pepacllo. ");
INSERT INTO ameNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesúsña amaʼt eʼman atet̃ otoset Jairopaʼ ñañapaʼ atet̃ otan Jairo ñeñt̃ am̃chaʼtaret̃tetsa judioneshaʼ poʼprahuo: —P̃apaʼ amach c̈ha peʼcharrtatatsto peyoc̈her, nachña eʼñe peyemta. ");
INSERT INTO ameNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesúsñapaʼ aña muenat Pedro ñam̃a Jacobo ñam̃a paʼmoʼnasheñ Juan. Ñeñt̃ach cot̃aʼnmueʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Allempoñapaʼ ahuanmuet am̃chaʼtaret̃ Jairo paʼpacllo. Oʼña c̈hac̈haʼtet allpaʼ, allñapaʼ entoset shonteʼ acheñeneshaʼ ñeñt̃ anoʼtatseʼtets, all yahuanrrortenet, atarr yaʼnaʼteñet arromñat̃. ");
INSERT INTO ameNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesúsñapaʼ beʼt̃osos pocollo, ñañapaʼ atet̃ otosanet: —Sapaʼ esoʼmareʼtña atarr sanoʼtatsen, c̈ha atarr seyahuanrrortena. Añ shopsheshaʼpaʼ amacaʼye c̈hoyeʼ rromueno, c̈hacaʼye muen. ");
INSERT INTO ameNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ñetña pachm̃areʼteñot̃etpaʼ att̃a cheʼtatsetyesapet t̃arroʼmar ñetpaʼ eʼñecaʼye eñotenet c̈hocaʼye rromuen. Allempoña Jesúspaʼ c̈haʼnmac̈haʼtatosan allohuen acheñeneshaʼ pocollot̃. Ñañapaʼ beʼt̃osos oʼpono alloʼtsen shopsheshaʼ ñeñt̃ rromuets. Ñapaʼ aña muenatos arromñat̃ puepapar ñam̃a pachor ñam̃a ñeñt̃ cot̃aʼhuaneneʼ, ñeñt̃aña epuet beʼt̃osc̈haʼtoset alloʼtsen arromñat̃. ");
INSERT INTO ameNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Allempoña Jesúspaʼ rromotaʼtosan shopsheshañ potot̃paʼ atet̃ otos eʼñe ña poʼñoño: —Talita cumi—ñeñt̃ yoten ya yeñoño: Oʼch nesñet̃olle notosep̃ t̃eʼpaʼ c̈hop̃a tanterrtsa. ");
INSERT INTO ameNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Eʼñe otueʼ atet̃paʼ allent̃epaʼtchaʼ tanterra, c̈ha chopeʼcherrets. Ñehua, ñeñt̃ shopshesharpaʼ c̈harraʼ puechena epa poʼcharña. Allohuenetñapaʼ c̈ha atarr cohuanrrorteñet. ");
INSERT INTO ameNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Allempoña Jesúspaʼ atet̃ otanet: —Poʼñoc̈h t̃eʼpaʼ amach eseshaʼ señotatatsto amaʼt eʼñe puesheñarra. Alla oterraneterr: —T̃eʼpaʼ serratallmeʼcherñacaʼye. ");
INSERT INTO ameNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesúsña ahuerrerr allot̃paʼ oʼ alla c̈herrerr paʼnyo all Nazareto. Pueyochreshaʼñapaʼ alla cot̃aʼhuanererr. ");
INSERT INTO ameNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Allñapaʼ allempo c̈herr yet̃ allempocma amesenet, ñañapaʼ arr yec̈hatuerraneterr judioneshaʼ poʼprahuo. Shonteʼ acheñeneshaʼ ñeñt̃ eʼm̃ñotapuerreʼ atet̃ serrpareʼtatuerranet all, ñetñapaʼ nanac cohuanrrortapueret, allempoñapaʼ atet̃ otyeset ñocop: —Ñapaʼ errahuañacaʼyeña eñotanña ora allohuen ñeñt̃ atet̃ p̃aʼyena. Eseshaʼhuañacaʼyeña eñotateneʼña att̃ot̃ orrtatenan partsoteñets. Errot̃uacaʼyeña huenaña ñeñt̃ eñoteñtsor ñeñt̃ orrtatyen ña. ");
INSERT INTO ameNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ñapaʼ añacaʼye ñeñt̃ poʼtaruas peneʼ oʼch t̃orrenana tsach att̃och es yec̈hcatyen paʼnamen. Ñapaʼ añacaʼye María puechoyor. Paʼmoʼnasheñpaʼc̈hoʼña añacaʼye Jacobo, José, Judas, ñam̃a Simón. Ñam̃a poʼc̈haneshaʼpaʼ eʼñecaʼye yechmeʼtenanet, parroʼmarneshayarramcheʼ. Ñeñt̃oʼmarña all eʼñe ña paʼnyopaʼ ama eseshayeʼ acuaʼpenaye entenaye. ");
INSERT INTO ameNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Allempoña Jesúspaʼ atet̃ otanet: —Ñeñt̃ aʼm̃teneʼ Yompor poʼñoñpaʼ c̈hocmacaʼye am̃chaʼnaʼtpoʼ entyeñña allohuen acheñeneshaʼ; arrña paʼnyo alloʼtsen eʼñe ña pamoʼtsnaʼtarneshaʼ ñeñt̃ eʼñe pamoʼtsnaʼtar penpaʼ ñetñapaʼ ama acuaʼpenayeʼ enteñeto. Amaʼt ñam̃a ñeñt̃ parro yec̈henet paʼpaclleto, ñetpaʼc̈hoʼña ama acuaʼpenayeʼ enteñeto. ");
INSERT INTO ameNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ama ameʼñeñeto ñeñt̃oʼmarña allpaʼ ama atonocheyeʼ orrtataneto poʼpartsoña. Allpaʼ aña orrtatyen att̃och aʼp̃llaʼyenan puesheñaʼtets atsnañet̃ allpaʼ att̃ocaʼyeña aʼcrratenanet. ");
INSERT INTO ameNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ñeñt̃oʼmarña Jesús atarr cot̃apeʼchateñ pamoʼtseshaʼ att̃o ñetpaʼ ama acuaʼpenayeʼ enteñeto, ñapaʼ c̈ha mueneʼ llecateñet. Allempoña Jesúspaʼ alla chopeñeʼchyerrerr yec̈hatyerrtserr allemeñ anetsoʼmar. ");
INSERT INTO ameNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Allempo c̈hapaʼmuen allempo Jesús agotaʼmuenan pueyochreshaʼ c̈harrasheña ñeñt̃ puechetsa epsheña. Eʼñe apc̈haʼhuet ñeshopaʼ ñañapaʼ apanet llesens att̃och quec̈hpatyeset oneñet̃ec̈hno att̃o chorraʼyenana acheñeneshac̈hno. Att̃oña llesensanet ñetpaʼ oʼch ahuanemyeset eʼñe epsheñaʼttsocmuet. ");
INSERT INTO ameNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Ñam̃a atet̃ otapanet: —Ñerraʼm oʼch sahuanmapaʼ amach es sanmatsto amaʼt coñeʼt̃a allchaʼ sechopeñeʼchyes—amaʼt sebolsa, amaʼt ñeñt̃chaʼ serraʼyesnom, amaʼt sec̃llayora. Amaʼt eʼñe epma seshtampaʼ amach sanmatsche. Añach sanem secarr, senaʼnomchaʼ ñam̃a sesapat. ");
INSERT INTO ameNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Alla oterraneterr: —Amaʼt errach pocollro sec̈hap allach sommosa allponmat esempohuach ahuerrserr poʼpoñ anetso. ");
INSERT INTO ameNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ñerraʼm erra anetsro ñeñt̃ alloʼmarneshaʼña ama cohuenayeʼ agapaseto ñerraʼm amach mueneto oʼch eʼm̃ñotapasetpaʼ oʼch sem̃terrerr ñam̃a allot̃. Ñerraʼm allempo sem̃terrerr ñam̃a allot̃, ñeñt̃ña setcoʼtsaʼyen pañeʼteʼ patspaʼ c̈hoch sepaʼshetcaʼtyesnomña setac. Att̃ochña alloʼmarneshaʼpaʼ oʼch señotatnomanet ñetpaʼ amacaʼye pocteyeʼ entenanetoña Yompor. Poʼñoc̈h oʼch notas: Esempohuañen allempoch acraret̃etuerra allohuen acheñeneshaʼ, añña anetsoʼmarneshaʼ ñeñt̃ ama sagapaye ñetñapaʼ atarrchaʼ aʼcoñchataret̃terret. Elloch metanaʼtueret ñeñt̃ att̃o aʼcoñchataret̃terra sodomoʼmarneshaʼ ñam̃a gomorroʼmarneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Eʼñe ñeñt̃a otaret̃etuetpaʼ ñetñapaʼ allent̃a ahuanmuet oʼch chopeñeʼchyeset erracmañen anetsoʼmar. Allñapaʼ serrpareʼtyesnomuet ñeñt̃ poctetsa allohuenacop oʼch cot̃apeʼcherret ello cohuen Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ñam̃a all chopeñeʼchyeset erracmañenpaʼ ñetpaʼ allña quec̈hpatyeset shonteʼ oneñet̃ec̈hno att̃o chorraʼyenana acheñeneshac̈hno. Ñam̃a shonteʼ poʼpotantañec̈hno acheñeneshaʼ ñeñt̃ atsnaʼtyets all, ñetñapaʼ aʼyanaʼtyesoset atsnañet̃ec̈hno olivosoʼyo eʼñe aʼcrratyesoset. ");
INSERT INTO ameNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Allempoña am̃chaʼtaret̃ Herodes ñañapaʼ atet̃ eʼmareʼtenan Jesús ñeñt̃ atet̃ p̃aʼyena, t̃arroʼmar Jesús allohuen acheñeneshaʼpaʼ eʼñe eʼmareʼtueñet ñeñt̃ atet̃ p̃aʼyena. Ñañapaʼ atet̃ ot: —Añepaʼtcaʼyeña Juanañ ñeñt̃ apatayeʼt̃ acheñ Partsocop. Taʼmcaʼye c̈hat̃eʼ tanterraña rromot̃. Ñeñt̃oʼmarepaʼtcaʼyeña t̃eʼpaʼ orrtaterranña partsoteñets. ");
INSERT INTO ameNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Poʼpotantaññapaʼ atet̃ otyenet: —Añepaʼtcaʼyeña Elías ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ ahuat̃. Poʼpotantaññapaʼ ñetpaʼc̈hoʼña atet̃ otyenet: —Añepaʼtcaʼyeña ñeñt̃ aʼm̃teneʼ Yompor poʼñoñ, eʼñecaʼye atet̃ ñerraʼm ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ ahuat̃. ");
INSERT INTO ameNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodesña allempo eʼmareʼch ñañapaʼ atet̃ ot: —Añepaʼtcaʼyeña Juanañ ñeñt̃ nepechat ahuañmoʼcha, c̈hepaʼtrramcheʼ tanterraña rromot̃. ");
INSERT INTO ameNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ñehua, allempo Herodespaʼ ahuañmoʼchacma rromatenanaʼ Juanañ oʼ huancachpaʼ allña yottam̃p̃sach att̃och coshatan Herodías ñeñt̃ paʼmoʼnasheñ Felipe puet̃apor. T̃arroʼmar allempo Herodespaʼ oʼcaʼye puerraterran paʼmoʼnasheñ puet̃apor. ");
INSERT INTO ameNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juanañpaʼ ñacaʼye otayeʼt̃ Herodes: —Amacaʼye pocteyaye oʼch peyoram̃pes pemoʼnasheñ puet̃apor. ");
INSERT INTO ameNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ñeñt̃oʼmarña allempo Herodíaspaʼ atarr eʼmoñeʼtaneʼt̃ Juan, atarr mueneñeʼt̃ oʼch muetsatacheñ t̃arraña ama errot̃ pe. ");
INSERT INTO ameNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","T̃arroʼmar Herodespaʼ mechaʼnaʼtaneʼt̃ Juan, eñocheʼt̃ ñapaʼ eʼñe pocteʼ es p̃aʼyeseʼt̃. Eñocheʼt̃ ñapaʼ añecpaʼna atarr t̃orrena Partsocop. Ñeñt̃oʼmareʼnaña eʼñe cohuen cohuam̃p̃sacheʼt̃ allochñapaʼ amach muetseto. Allempo eʼm̃ñotenan Juan att̃o serrpareʼteʼt̃ atarr cohuen enteñeñ, t̃arraña ama eʼñeyeʼ eñotenanoña ñeñt̃ atet̃ cot̃apeʼchateñ Juan eʼñe cohuen. ");
INSERT INTO ameNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Att̃eñapaʼ c̈hapaʼmuen pamt̃arr allempoch Herodías eñoteñ att̃ot̃chaʼ muetsaterran Juan. Ñeñt̃paʼ t̃arrempo atet̃ p̃a allempo c̈hapaʼmuen Herodes pueʼñalletño ñeñt̃ puerrollar pen Herodías. Allempoña Herodespaʼ huaʼñatyesan acheñeneshaʼ ñeñt̃chaʼ rrallmeʼchapretenayaʼ. Añ huaʼñatyes ñeñt̃ am̃chaʼtaret̃ec̈hno ñam̃a ñeñt̃ solltar poʼcap̃tanreneshaʼ ñam̃a ñeñt̃ atarr ec̃llayoret̃eneshaʼ ñeñt̃ galileoʼmarneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Allempo rrallmeʼchetpaʼ allña beʼt̃ososña ñam̃a shopsheshaʼ ñeñt̃ Herodías puechoyor. Ñañapaʼ allña tancsareʼtosa. Herodesñapaʼ ñeñt̃a atarr cohuen ent amaʼt ñam̃a ñeñt̃ ahuaʼñaret̃ec̈hno. Ñeñt̃oʼmarña am̃chaʼtaret̃ Herodespaʼ atet̃ otan shopsheshaʼ: —Amaʼt erraʼtsena penamuenenpaʼ napaʼ napap̃chaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Elloñapaʼ eʼñe Yompor paʼsoʼchño nan poʼñoñ, allempoñapaʼ alla otererr: —Poʼñoc̈hcaʼye napaʼ amaʼt es penamuen napaʼ napap̃chaʼ amaʼt pueshmet nepatseñ all naʼm̃chaʼtaret̃tena. ");
INSERT INTO ameNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Allempoña shopsheshaʼpaʼ c̈haʼnerr ahuerr pachoresho, atet̃ otosan pachor: —Taʼm ¿eschaʼ nenam̃ña am̃chaʼtaret̃? Pachorñapaʼ atet̃ och: —Añchaʼ penam̃ Juan poñ ñeñt̃ apatayeʼt̃ ahuaña acheñ. ");
INSERT INTO ameNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Allempoña shopsheshaʼpaʼ materra alla am̃chaʼtaret̃ Herodesesho atet̃ otuerran am̃chaʼtaret̃: —Napaʼ añ nemnen oʼch pepechennanaʼ Juan poñ ñeñt̃ apatayeʼt̃ acheñeneshaʼ oʼch penon platopaʼ oʼch p̃aphuerren eʼñe arrma. ");
INSERT INTO ameNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Allempo enamhue shopsheshaʼ Juan poñpaʼ am̃chaʼtaret̃ñapaʼ c̈ha lleca. T̃arraña amaʼt llecañpaʼ oʼ nohuanña poʼñoñ huomenc eʼñe Yompor paʼsoʼchño ñam̃a alloʼtsaʼyen ñeñt̃ huaʼñen ñeñt̃ eʼmueneʼ atet̃ oten ñeñt̃oʼmarña c̈hocmach aʼpoctatan poʼñoñ atet̃ otuan ñorraʼ shopsheshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Allempoñapaʼ allent̃a otan poʼsolltarer: —T̃eʼpaʼ oʼch pepecheññañaʼ Juan poñ all neyottam̃p̃sateñ; poññapaʼ pehuapater arrma. ");
INSERT INTO ameNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Solltarñapaʼ allent̃a ahuoʼ pechenanaʼ Juan poñ, oʼ huapater plato, aphuerran shopsheshaʼ. Shopsheshaʼñapaʼ apuenanaʼ ñam̃a pachor. ");
INSERT INTO ameNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Allempoña Juan pueyochreshaʼpaʼ oʼ eʼmareʼchet oʼ pecheret paʼyochreshat̃eret Juanañ, allempoña ñet ahuanmuet all pecheret Juanañ allempoña ñetpaʼ eretaʼ apecharet̃ oʼch pampueñetaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Att̃ot̃añapaʼ oʼ c̈hac̈herr ñeñt̃ llesensen Jesús. Ñetñapaʼ serrpareʼtatueret Jesús allohuen ñeñt̃ atet̃ p̃aʼyeset. Serrpareʼtatueret ñam̃a atet̃ yec̈hatyeset acheñeneshaʼ Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesúsñapaʼ atet̃ oterranerr pueyochreshaʼ: —T̃eʼpaʼ oʼch ahuey eʼñe yapt̃ocheʼ all ama acheñempañoyaye; sapaʼ allchaʼña samesuerr allponmat. Ñeñt̃ allempopaʼ atet̃ otan Jesús pueyochreshaʼ t̃arroʼmar allempo shonteʼ acheñeneshaʼ ñeñt̃ huac̈haʼtyetsa ñam̃a ñeñt̃ c̈hocma ahuanemyetsa ñeñt̃oʼmar amaʼt mameshapaʼ ama eshcayeʼ rreneto. ");
INSERT INTO ameNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Allempoñapaʼ eʼñe ñapt̃ochayet ahuanmam̃p̃set noñt̃o, oʼch ahuanmuet all ama acheñempañoyaye all otenanet Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Allempoña shonteʼ acheñeneshaʼpaʼ alla enterraneterr all oñmam̃penet. Allempoña achmeʼtaret̃tapuetpaʼ acheñeneshaʼñapaʼ oʼ alla matrraʼterrerr allohuen ñeñt̃e anetsot̃. Ñetñapaʼ patsoʼmara oñmac̈haʼtet ñanmacmueta c̈hac̈haʼtet all sechena Jesús pueyochreshohuen. ");
INSERT INTO ameNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Allempoña sehuosa Jesús allpaʼ alla entuerraneterr oʼ alla shontaʼhuerrerr acheñeneshaʼ. Atarr nanac mueraʼhuerraneterr Jesús, t̃arroʼmar ñetpaʼ eʼñe atet̃ entuerraneterr ñerraʼmrrat̃eʼ carrnero ñeñt̃ ama acuam̃p̃saret̃eyaye. Allempoña Jesúspaʼ alla yec̈hatuerraneterr paʼnamen esocmañen ñeñt̃ Yompor poʼcohuenña. ");
INSERT INTO ameNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Att̃eñapaʼ ellerren pueyochreshaʼñapaʼ oteñetaʼ Jesús: —T̃eʼpaʼ arroʼtseney all ama acheñempañoyaye ñam̃a oʼcaʼye ellerren. ");
INSERT INTO ameNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","T̃eʼpaʼ oʼch p̃och acheñeneshaʼ ahuanemyerretepaʼ anetsoʼmar allchaʼ rañt̃aʼyesuerret puerraret ñeñt̃chaʼ rraʼyesuerret t̃arroʼmar arrpaʼ ama es eñalle. ");
INSERT INTO ameNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","T̃arraña Jesúsñapaʼ otan pueyochreshaʼ: —Sachcaʼye apaʼyesahuet ñeñt̃chaʼ rret. Ñetñapaʼ atet̃ ochet: —¿Añeʼt pemnen oʼch ahuey oʼch yepomuenaʼ shonteʼ quelle ñeñt̃ doscientos denario alloch yerañt̃enaʼ pan ñeñt̃chaʼ yerratuerranet allohuenet? ");
INSERT INTO ameNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesúsñapaʼ atet̃ oterraneterr: —Ñehua, secuaʼ pan, ¿errpont̃eʼ sechen? Ñetña cohuet panpaʼ atet̃ otereterr: —Eʼñecaʼye amnara pan eñall ñam̃a epat̃oll cac. ");
INSERT INTO ameNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Allempoña Jesúspaʼ atet̃ otan acheñeneshaʼ: —T̃eʼpaʼ oʼch sanorrc̈haʼtyes eʼñe sopaʼttsocma eʼñe all cohuen emmoʼratyen pasetmaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ñetñapaʼ atet̃c̈hoʼ pet. Anorrc̈haʼtyeset eʼñe ñopaʼttsocmuet—c̈harrasheñaʼttsocma c̈harrapaʼtets ñam̃a amnarsheñaʼttsocma c̈harrapaʼtets ñeñt̃ anorrc̈haʼtyesets. ");
INSERT INTO ameNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Allempoña Jesúspaʼ agapan ñeñt̃ amnar pan ñam̃a epat̃oll cac, cohuaʼ enonet̃ parasyosoʼtam̃p̃san pan. Allempoñapaʼ shotaʼtan panpaʼ apanatyesan pueyochreshaʼ, ñetñapaʼ epatyeset allohuen acheñeneshaʼ ñeñt̃ anorrc̈haʼtyets all, eʼñe epaʼhuet. Ñam̃a shetseʼtan cac att̃och epatyesanet allohuenet. ");
INSERT INTO ameNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Allempoñapaʼ oʼ rrallmeʼchet allohuenet eʼñepaʼtchaʼ yetrraʼtuahuet. ");
INSERT INTO ameNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Eʼñe yetuahuetpaʼ elloña c̈ha aʼpchatyeset cac ñam̃a pan ñeñt̃ ashotaʼtyesaret̃. Ñeñt̃ña aʼyapac̈herretpaʼ c̈hepaʼtchaʼ chorrerrets c̈harraʼ puechena epa cañt̃er. ");
INSERT INTO ameNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ñeñt̃ña rrallmeʼchats atarr shonteʼ acheñeneshaʼ alloʼtsen amnaroch mil ñeñt̃ eʼñe yacmaneshocheʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Allempoña Jesúspaʼ otan pueyochreshaʼ: —T̃eʼpaʼ oʼch saʼtac̈haʼt noñt̃o oʼch sota sanom oʼch sep̃chaterra yot̃ oʼch sec̈herr anetso ñeñt̃ paʼsoʼcheñ Betsaida. Allempoña Jesúspaʼ oʼ soʼtnoman acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Soʼtuanmanetpaʼ ñañapaʼ ahuoʼ aspent̃o, allchaʼ maʼyochosa. ");
INSERT INTO ameNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Att̃eñapaʼ oʼ tsapuen, ñapaʼ alloʼtsenara eʼñe ñapuet̃ aspent̃o. Noñt̃paʼc̈hoʼña ñeñt̃a rroc̈hasoʼtsenara saʼpo. ");
INSERT INTO ameNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Allot̃ña entenan pueyochreshaʼ ñeñt̃ noñt̃oʼtsaʼyen. Ñetñapaʼ eʼñe poʼmueroc̈henñot̃eta echotnenet oñ t̃arroʼmar orrnoñapaʼ c̈ha aʼpuerrameʼtam̃penanet. Att̃eña allempoña puetarenmochpaʼ huenanet Jesús c̈ha chopeʼchnen enot̃ oño. Ahuoʼch metanenanetañ, ");
INSERT INTO ameNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","allempoña pueyochreshaʼpaʼ entapueñet c̈ha chopeʼchnen enot̃ oño. Ñetñapaʼ c̈ha otenapuetañ choyesheʼmatst̃eʼ huapanet. C̈ha rrannartet puem̃chañot̃. ");
INSERT INTO ameNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Allohuenetpaʼ eʼñe entuapet nanac yoreʼtosanet. Jesúsñapaʼ eñoranaʼtuenanet, atet̃ otuenanet: —C̈hoñacaʼye socshapuenna, nacaʼye oʼ nohuapa, amach att̃a sem̃chaʼtatstapno. ");
INSERT INTO ameNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Allempoña Jesúspaʼ aʼtapos noñt̃o alloʼtsaʼyen pueyochreshaʼ. Huomenquëshaʼñapaʼ c̈hepaʼtchaʼ muetsoñeñterrtsa. Ñetñapaʼ c̈ha atarr cohuanrrortapueñet. ");
INSERT INTO ameNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ama c̈henaneto pueyoc̈hreto amaʼt att̃o Jesúspaʼ atontatan pan, amacaʼye es c̈henahueto pueyoc̈hreto. ");
INSERT INTO ameNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Allempoña pechatam̃p̃setpaʼ arr etsotoset all oteñet Genesareto. ");
INSERT INTO ameNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Allempo sohuac̈haʼtoset noñt̃ot̃, añña acheñeneshaʼ ñeñt̃ alloʼtsaʼyen, ñetñapaʼ chemeʼtapet Jesúspaʼ ");
INSERT INTO ameNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","allent̃a matrraʼtyeset ora erracmañen all yec̈haʼyena acheñeneshaʼ. Att̃ot̃caʼyeña huapatam̃pesyesoñetña atsnañet̃ec̈hno allem̃at̃eñ. Amaʼt erra eʼmareʼteñet oʼ c̈hap all, allchaʼc̈hoʼ anmoñetña patsnañet̃er puechecnapeʼna. ");
INSERT INTO ameNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Amaʼt erra c̈hapyen all shontena acheñeneshaʼ ñam̃a ñerraʼm arr c̈hen all ama tama eñalle acheñ, amaʼt allecma oñen acheñeneshaʼ ñetñapaʼ allchaʼc̈hoʼ naʼyenetaʼ patsnañet̃eret allchaʼ enamapet amaʼt posoʼmot̃a oʼch aʼp̃llapoñet paʼshtam. Allpon ñeñt̃ aʼp̃llaʼyesapueʼ Jesús paʼshtampaʼ allponc̈hoʼ eʼñe corraʼyesuerrtsa. ");
INSERT INTO ameNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Allempoña allpaʼ huac̈haʼtoña fariseoneshaʼ epuet ñam̃a puesheñaʼtets ñeñt̃ huac̈hetsa Jerusaléñot̃ ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop. ");
INSERT INTO ameNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ñetña allpaʼ entosñañet Jesús pueyochreshaʼ att̃a rraʼyenet ama eʼpotaʼtyeneto pot Partsocop allempoch rrallmeʼchet. ");
INSERT INTO ameNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Ñehua, allohuen fariseoneshaʼ amaʼt ñam̃a allohuen judioneshaʼ ñetpaʼ atet̃ yec̈henet amach rrenetaʼpaʼ oʼch eʼpotaʼtyeset Partsocop. T̃arraña ñeñt̃paʼ paʼtañneshaña yec̈hatnomahuet. ");
INSERT INTO ameNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ñam̃a poʼpoñ ellonet̃paʼ atet̃ yec̈hataneteʼt̃ paʼtañneshañ ñerraʼm esempo huerret allot̃ecma pomatsreʼtyenet, amach rrenetaʼpaʼ c̈hoch ñanom aʼcohuentatenetañ Partsocop. Ñam̃a shonteʼ poʼpoñec̈hno ñeñt̃ eʼñe yec̈hatyesaneteʼt̃ paʼtañneshañ. Amaʼt ñeñt̃ porret̃ p̃aʼyenet ñam̃a poʼpajoc̈hnetpaʼ c̈hochña eʼñe eʼpameʼtyeñetañ Partsocop, eʼparroʼtyenetañ amaʼt ñam̃a paʼsrerrogac̈hno Partsocop. Amaʼt ñam̃a all p̃anrameʼtyenet eʼñech eʼpataʼtueñetañ Partsocop.) ");
INSERT INTO ameNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Añña fariseoneshaʼ ñam̃a ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop ñetña allempo entosñañet Jesús pueyochreshaʼ att̃a rraʼyenet ama eʼpotaʼteneto Partsocop ñeñt̃oʼmarña ñetpaʼ atet̃ otoset Jesús: —Peyochreshac̈hnoñapaʼ esoʼmareʼtña ama eseshaʼ yec̈henayeña ñeñt̃ atet̃ yec̈heʼt̃ yatañneshañ. Ñetpaʼ att̃a rraʼyenet ama eʼpotaʼteneto Partsocop allempo rrenet. ");
INSERT INTO ameNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesúsñapaʼ atet̃ otanet: —Sapaʼ atarruacaʼye ommoñat̃neshast̃eʼ t̃arroʼmar atarr seshcareʼten, amaña Yomporeyeʼ sesherbeno. Isaíaspaʼ eʼñe cohuen aʼm̃taneʼt̃ Yompor poʼñoñ, saña t̃eʼñapaʼ eʼñe atet̃ sepena atet̃ oteʼt̃ allempo atet̃ ot Yompor: Ñeñt̃ acheñenesharpaʼ eʼñe puenamot̃a cohuentatennanetañ; pueyoc̈hretoñapaʼ ama c̈henaneto ñeñt̃ cohuen nenten na. ");
INSERT INTO ameNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Eʼñe orrena maʼyochennet, ñeñt̃ atet̃ yec̈hatannenetpaʼ ñeñt̃paʼ eʼñe acheña nayeʼt̃ ahuat̃ poct̃ap̃ña. ");
INSERT INTO ameNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jesúspaʼ alla oterraneterr: —Sapaʼ c̈hacaʼye sequec̈hpuenña ñeñt̃ atet̃ oteney Yompor ñeñt̃chaʼ atet̃ yep̃aʼyen cohuen; sapaʼ añacaʼyeña atarr setsotayen ñeñt̃ atet̃ yec̈hatyesnomues saʼtañneshañ; ñeñt̃a atet̃ sep̃aʼyen orrot̃ec̈hno eʼpameʼtyeseʼ ñam̃a sepajoc̈hno. Ñam̃a poʼpoñec̈hno paʼnamen sep̃atseʼtyeneñ ñeñt̃ soten Partsocpañoʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesúspaʼ alla oterraneterr: —Sapaʼ añacaʼye atarr señoten att̃och sehuaporeʼtoñ Yompor poʼñoñ ñeñt̃ atet̃ oteney ña ñeñt̃chaʼ atet̃ yep̃a cohuen; ñeñt̃oʼmarña sapaʼ eʼñe aña setsotayen ñeñt̃ yec̈hatyesnomues satañneshañ. ");
INSERT INTO ameNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ñehua, Moiséspaʼ atet̃caʼye oteʼt̃: “Semorrenteñot̃paʼ sem̃chaʼnaʼchchaʼ sompor ñam̃a sachor.” Elloña ñam̃a poʼpoñonet̃paʼ atet̃ oteʼt̃ Moisés: “Ñerraʼm eseshaʼ sasareʼteneʼ pompor ñam̃a pachor ñeñt̃paʼ muetsetepaʼ.” ");
INSERT INTO ameNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","T̃arraña sañapaʼ atet̃ sotyen ñerraʼm eseshaʼ atet̃ oteneʼ pompor ñam̃a pachor: “Ñeñt̃ nechen oʼch napapeñpaʼ t̃arraña amach napape t̃eʼpaʼ oʼch neneʼ Yomporecop ñeñt̃ otenet Corbán”, ");
INSERT INTO ameNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ñeñt̃ña acheñerpaʼ sañapaʼ atet̃chaʼ soteñ: “P̃ocoppaʼ ama pallteno oʼch es p̃ap̃ p̃amoʼmteʼ.” Att̃oña sapaʼ ama semnateñe ñeñt̃ acheñer eʼñe ña puemorrenteñot̃paʼ oʼch es apuenan pompor ñam̃a pachor. ");
INSERT INTO ameNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Att̃ocaʼyeña sehuaporeʼteññañña Yompor poʼñoñ allochñapaʼ eʼñech aña setsoten ñeñt̃ eʼñe sa seyc̈heña. Amaʼt ellonet̃paʼc̈hoʼña shonteʼ poʼpoñec̈hno ñeñt̃ atet̃ sep̃atseʼtyena paʼnamenaʼttsocma. ");
INSERT INTO ameNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Allempoña Jesúspaʼ c̈horeʼtan acheñeneshaʼ ñeñt̃ shontetsa, ñetñapaʼ atet̃ otanet: —Sañapaʼ poʼñoc̈h allohuenes eʼñepaʼchña cohuen seʼm̃ñoten allochñapaʼ att̃och eʼñe cohuen c̈haponasa seyoc̈hro. ");
INSERT INTO ameNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ama añeyeʼ yaʼsosyatenaye Partsocop ñeñt̃ yerraʼyen. Añcaʼyeña yaʼsosyateneʼ eʼñe ya yoct̃apeʼchatseʼteñot̃ ñeñt̃paʼ yeyoc̈hrot̃caʼye huena. ");
INSERT INTO ameNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ñeñt̃es poʼñoc̈h neʼm̃ñoteneʼ c̈haponasepaʼch seyoc̈hro ñeñt̃ atet̃ netmaʼntatensa añ ñoñets. ");
INSERT INTO ameNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Allempoña Jesúspaʼ saʼnerran acheñeneshaʼpaʼ ñañapaʼ beʼt̃osuerrerr pocollo allña pueyochreshaʼpaʼ atet̃ otoset: —¿Esoʼtña petmaʼntatyeneyña ñorraʼ? ");
INSERT INTO ameNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesúsñapaʼ atet̃ otanet: —Sapaʼc̈hoʼña eʼñeʼtña att̃ecmas sam̃a, ama es sec̈henoyo seyoc̈hro. Sapaʼ amaʼt señotenoña ñeñt̃ yerraʼyen yenamot̃ ñeñt̃paʼ amat̃eʼ errot̃enot̃ aʼsosyatyeña Partsocop. ");
INSERT INTO ameNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","T̃arroʼmar ñeñt̃ yerraʼyenpaʼ amacaʼye yeyoc̈hroyeʼ c̈heno, yat̃acaʼye c̈hen. Ñeñt̃paʼ c̈hocmachcaʼye yener aʼyo. Ñehua, ñeñt̃paʼ atet̃ eñotateney Jesús allohuen rreñtsoc̈hnopaʼ eʼñecaʼye cohuenacma eʼñe arrapahuocma. ");
INSERT INTO ameNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jesúsñapaʼ alla oterraneterr: —Añña ñeñt̃ c̈haʼnets yenamot̃ ñeñt̃ att̃o yeñosatseʼtyen ñeñt̃paʼ eʼñe yeyoc̈hrot̃ huena ñeñt̃ña c̈hocma yaʼsosyateneʼña Partsocop. ");
INSERT INTO ameNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Eʼñe yeyoc̈hrot̃ huena cot̃ap̃ñats ñeñt̃ amaʼt mameshapaʼ ama cohuenayaye, ñeñt̃paʼ añ: chetapretannaʼteñets t̃aporets, cañoreshaʼteñets, muetsannaʼteñets, ");
INSERT INTO ameNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","etatsreʼtyeñets, yeʼchapretannaʼteñets, atsrreʼmueñets, shecareʼtannaʼteñets, ottatseʼteñets, moparrñats, sasareʼteñets, ommoʼcheñets, otatseʼteñets. ");
INSERT INTO ameNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ñeñt̃ allohuen sosyaʼtsañec̈hno ñeñt̃paʼ yeyoc̈hrot̃caʼyeña huena, ñeñt̃caʼyeña yaʼsosyateneʼña Partsocop. ");
INSERT INTO ameNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Allempoñapaʼ ahuerrerr Jesús allot̃paʼ alla c̈hap allampaño anets Tiro ñam̃a Sidón. Allempo c̈hap all pocollopaʼ ñapaʼ mueneñeñ eʼñoʼch aʼnahua c̈hapañ. T̃arraña ama errot̃enot̃ c̈hapo aʼnahua, ");
INSERT INTO ameNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","t̃arroʼmar eʼñe allempo c̈hap c̈ha eʼmareʼteʼ puesheñarr coyaneshaʼ ñeñt̃ achoyoret̃. Puechoyorñapaʼ penochor ñeñt̃ñapaʼ c̈ha chorreña oneñet̃. Ñeñt̃ña coyaneshaʼ huapapaʼ rromosa Jesús paʼrrp̃ot̃. ");
INSERT INTO ameNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ñeñt̃ña coyanesharpaʼ ama judioneshayaye, ñapaʼ poʼpoñ acheñ ñeñt̃ sirofenicioʼmarneshaʼ. All rromosa Jesús paʼrrp̃ot̃paʼ atet̃ otos: —Nepapare, pequec̈hpatatayeʼchapon nechoyor oneñet̃. ");
INSERT INTO ameNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesúsñapaʼ atet̃ tomaʼntatana acheñeneshaʼ ñeñt̃ ama judioneshayaye ñeñt̃oʼmarña atet̃ och: —Ñanomchaʼ ya yacñet̃ar yaʼyetaʼ t̃arroʼmar ama pocteyaye oʼch yeprratam̃pes yacñet̃ar puerrar oʼch yehuaporeʼtam̃pes alloʼtsen ochec oʼch rreʼ ñam̃a ochec. ");
INSERT INTO ameNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Coyaneshaʼñapaʼ atet̃ otererr: —Amaʼt atteñ nepapareshachaʼ t̃arraña amaʼt ochecpaʼc̈hoʼña rraʼyenan cheshaneshaʼ puerrar ñeñt̃ aʼshoreʼtatyenet poʼmesap̃nac̈ho. ");
INSERT INTO ameNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Allempoña Jesúspaʼ atet̃ otererr: —Eʼñe pocteʼ atet̃ peʼñorena; eʼñepaʼt p̃ameʼñenna. Ñeñt̃oʼmar t̃eʼpaʼ oʼch ahuerrep̃ eʼñe peñmañeshaʼ, t̃eʼña oneñet̃paʼ oʼ quec̈hpaʼnerrnap̃ pechoyor. ");
INSERT INTO ameNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Allempoña coyaneshaʼpaʼ ahuerr paʼpacllo, oʼ c̈herrpaʼ alla entuerran puechoyor alla p̃anena eʼñe cohuen poʼmayo, oneñet̃ñapaʼ oʼ quec̈hpaʼner. ");
INSERT INTO ameNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Allempo puerrerra allot̃ ñeñt̃ allampañot̃ Tirot̃, arr oñemhuanom anetso Sidón allot̃ ñam̃a poʼpoñ anetso Decapolisoʼmar. Att̃oña oʼ alla ahuerr saʼponet̃ all Galileyaso. ");
INSERT INTO ameNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Oʼ c̈herr allpaʼ huapaterrñañeterr puesheñarr yacma ñeñt̃ñapaʼ paquet ñam̃a ama eʼñeyeʼ cohuenayeʼ eñeno. Ñeñt̃ña huapateʼpaʼ atet̃ otosan Jesús: —Añecopcaʼ nehuapateñ oʼch p̃aʼp̃lleʼ p̃otot̃ att̃och correrra. ");
INSERT INTO ameNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesúsñapaʼ allent̃a anem̃ ñapuet̃ aʼyenet̃, allñapaʼ eshoʼtosan potap̃ paquet pueto; ñam̃a oʼ senmareʼpaʼ oʼ alla aʼp̃llerrñañer ñam̃a pueñeñ. ");
INSERT INTO ameNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Allempoña Jesús cohuaʼ enonet̃paʼ enara. Allempoñapaʼ atet̃ ot eʼñe ña poʼñoño: —Efata —ñeñt̃ yoten yeñoño: Potaʼnerrepaʼ pet allochñapaʼ oʼch peʼmuerra eʼñe cohuen. ");
INSERT INTO ameNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Eʼñe otueʼpaʼ c̈ha potaʼnerrets puetpaʼ eʼñe cohuen eʼmuerra. Amaʼt ñeñt̃ echarrtateneʼ pueñeñpaʼ oʼ aʼrroyer c̈ha eñorerrtsa eʼñe cohuen. ");
INSERT INTO ameNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesúsñapaʼ atet̃ otanet: —T̃eʼpaʼ amach eseshaʼ sotap̃saʼtatsto amaʼt eʼñe puesheñarra. Amaʼt atet̃ otanetañ elloña ñetpaʼ aʼmet̃areʼteñet. ");
INSERT INTO ameNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Allñapaʼ atarr nanac cohuanrrorteñet, atet̃ otyenet: —Jesúspaʼ atarroʼtrra cohuenña ñeñt̃ allohuen atet̃ es p̃aʼyen. Amaʼt paquetneshaʼpaʼ c̈hocma eʼñe cohuen eʼmatuenanet. Amaʼt ñam̃a opananeshac̈hnopaʼ c̈hocma eʼñe cohuen eñoratyenanet. ");
INSERT INTO ameNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Allempoña poʼpocheño shonterrerr acheñeneshaʼ Jesúsesho. Allempopaʼc̈hoʼña ama eñalle ñeñt̃chaʼ rret. Ñeñt̃oʼmar Jesúspaʼ agotan pueyochreshaʼpaʼ atet̃ otapanet: ");
INSERT INTO ameNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Napaʼ c̈ha atarr nemuereña allohuen acheñeneshaʼ ñeñt̃ shontetsa arr. Oʼ maʼpamtoset nesho ama eñallmeñeto ñeñt̃chaʼ rret. ");
INSERT INTO ameNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ama pocteyeʼ nenteñe oʼch ahuanerret eʼñe paʼchporrñeshaʼ t̃eʼt ama aʼñsheʼmterreto t̃oño t̃arroʼmar patantaʼtetspaʼ atarr b̃ac̈hayot̃ huapyenet. ");
INSERT INTO ameNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Pueyochreshaʼñapaʼ atet̃ ochet: —Errahuachcaʼye yentña rreñetst̃eʼ ñeñt̃chaʼ yerrach shonteʼ acheñ arrpaʼ amayacaʼye. ");
INSERT INTO ameNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesúsñapaʼ atet̃ oterraneterr: —Sapaʼ ¿errponaʼt sechenña pan? Ñetñapaʼ atet̃ otereterr: —Eʼñecaʼye canc̈hrra yechen. ");
INSERT INTO ameNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Allempoñapaʼ otan acheñeneshaʼ: —T̃eʼpaʼ sanorrc̈haʼtyes patso. Allñapaʼ agapan ñeñt̃ canc̈herr pan. Agaphuepaʼ oʼ parasyosoʼtenanerr Pompor allot̃ñapaʼ oʼ shotaʼtan pan, apanatyesan pueyochreshaʼ. Ñetñapaʼ oʼ epatyeset ñamet allohuen acheñeneshaʼ eʼñe epaʼhuet. ");
INSERT INTO ameNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Apuanet panpaʼ eñall ñam̃a pat̃eʼtets cacat̃olleshaʼ. Jesúsñapaʼ alla parasyosoʼtam̃perranerr ñam̃a cacat̃olleshaʼ allempoñapaʼ oterranerr pueyochreshaʼ: —Sepatyerraneterr ñam̃a cacat̃olleshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Allempoñapaʼ oʼ rrallmeʼchet allohuenet, eʼñe yetrraʼtuahuet. Oʼ eʼñe yetuahuetpaʼ c̈ha aʼpchatyeset ñeñt̃ñapaʼ aʼyapac̈heret. Ñeñt̃ña aʼyapac̈herretpaʼ c̈hepaʼtchaʼ chorrats canc̈herr cañt̃er eʼñe t̃amoʼyareʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ñeñt̃ rrallmeʼchats atarr aton acheñeneshaʼ ñatoʼ alloʼtsent̃eʼ paʼtatsoch mil acheñeneshaʼ. Allempoña Jesúspaʼ soʼtnerran acheñeneshaʼpaʼ ahuerr, ");
INSERT INTO ameNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","aʼtapos noñt̃o pueyochreshohuen ahuam̃p̃set oʼch ahuanmuet anetso ñeñt̃ paʼsoʼcheñ Dalmanuta. ");
INSERT INTO ameNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Allempoña Jesúspaʼ huac̈herrñañerr ñam̃a fariseoneshaʼ ahuoʼch otnareʼchet Jesús. Ñetñapaʼ c̈ha mueneñet oʼch topachet Jesús. Ñeñt̃oʼmarña atet̃ otoset: —Yapaʼ añcaʼye yemnen oʼch pegatapuey pepartsoña entot̃ allochñapaʼ att̃och yeñotosep̃ poʼñoc̈h p̃apaʼ Parets Puechemerep̃. ");
INSERT INTO ameNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesúsñapaʼ allent̃a enara c̈ha mueneʼ poʼpoñ entanet pueyoc̈hro ñeñt̃oʼmarña atet̃ otanet: —Esoʼmart̃eʼcaʼye acheñeneshaʼ ñeñt̃ corraʼyetsa t̃eʼ ñetñapaʼ aña atarr eʼnenet oʼch norrtatanet nepartsoña entot̃. Poʼñoc̈hcaʼye na t̃eʼpaʼ oʼch notas, amaʼt coñeʼt̃a amach es negataneto. ");
INSERT INTO ameNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Allempoña Jesús sohuanerranetpaʼ aʼtaphuerr noñt̃opaʼ ahuam̃pes, pechaterra yom̃taʼn. ");
INSERT INTO ameNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Pueyochreshaʼñapaʼ c̈ha puesnomuet oʼch anmuet pocrram̃, noñt̃opaʼ ama es eñalle ñeñt̃chaʼ rret, eʼñe pat̃rra pan eñall. ");
INSERT INTO ameNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesúsñapaʼ alla tomaʼntaterraneterr, ñeñt̃ñapaʼ atet̃ otanet: —Eʼñech señota ñatoʼt semeñeʼteñaʼña fariseoneshaʼ amaʼt ñam̃a Herodes poʼchaser allo tsetenet pan. ");
INSERT INTO ameNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ñetña cot̃apeʼchyesetpaʼ atet̃ otannaʼtyeset: —Amacaʼye yechenoña pan ñeñt̃oʼmart̃eʼcaʼyeña oteney añoʼch yemeñeʼtatscheña fariseoneshaʼ poʼchaser. ");
INSERT INTO ameNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesúsña allempo eñotanet atet̃ cot̃apeʼchyenet ñañapaʼ atet̃ oterraneterr: —Esoʼmareʼt sellquëñeshaʼ sotannaʼtyena añoʼ eñalle ñeñt̃chaʼ serraʼ. ¿Amaʼt señoteñe? ¿Amaʼt c̈hennasoña seyoc̈hro? T̃emeʼttsenaʼt seʼcharrtatenña seyoc̈her. ");
INSERT INTO ameNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Sapaʼ amaʼt aclloʼyet̃eseñpaʼ c̈hacaʼye sottena ñerraʼmrrat̃eʼ ama senteno. Amaʼt etat̃eseñpaʼ c̈hacaʼye sottena ñerraʼmrrat̃eʼ ama seʼmueno. Amaʼt mameshapaʼ areʼtña es seyerpueno. ");
INSERT INTO ameNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ñehua, ahuaña allempo neshotaʼt amnar pan eʼñecaʼye epaʼhua amnaroch mil yacmaneshaʼ. Ellopaʼ ¿errponaʼtña sapc̈haʼhuerrña ñeñt̃ ashotaʼtyesaret̃ allempo eʼñe seyetua? ¿Errponaʼtña cañt̃er seʼchorrerr? Ñetñapaʼ atet̃ ochet: —C̈harraʼcaʼye puechena epa cañt̃er. ");
INSERT INTO ameNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Ñam̃a allempo neshotaʼt canc̈herr pan paʼtatsoch mil acheñ ñeñt̃ rreʼ ¿errponaʼtña sapc̈herrerrña ñeñt̃ ashotaʼtyesaret̃ allempo eʼñe seyetuerrerr? ¿Errponaʼtña cañt̃er seʼchorrerrerr? Ñetña atet̃ ochet: —Canc̈herrcaʼye cañt̃er yeʼchorrerrerrña allempo. ");
INSERT INTO ameNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesúsñapaʼ alla oterraneterr: —T̃eʼñapaʼ ¿amaʼtña oʼ c̈haponasoña seyoc̈hro? Ñeñt̃ neñotatenes ñeñt̃paʼ ama serrarecpayeʼ notenso. ");
INSERT INTO ameNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Allempoña c̈hac̈haʼtet anetso Betsaido, allñapaʼ huapaterrñañeterr aporoʼyet̃, ñeñt̃paʼ atet̃ otoset Jesús: —Añecopcaʼye yehuapateñña oʼch p̃aʼp̃llaclleʼchap̃ att̃och pecuater. ");
INSERT INTO ameNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Allempoña Jesúspaʼ echaʼnman aporoʼyet̃ potot̃paʼ anem̃ aʼyenet̃ all ama eñalle pocoll. Allñapaʼ aʼyaclleʼchos paʼsnemo, att̃oña aʼp̃llaclleʼchos, allñapaʼ atet̃ och: —¿Amaʼt coñeʼt̃apaʼ amaʼt oʼ pento? ");
INSERT INTO ameNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Aporoʼyet̃ña cohuaʼyestsapaʼ allent̃a otan Jesús: —Oʼcaʼye nent acheñ alla chopeñen t̃arraña eʼñe atet̃ nentyenanet ñerraʼmrrat̃eʼ tsach t̃omc̈haʼtyets. ");
INSERT INTO ameNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesúsñapaʼ alla aʼp̃llaclleʼchererr, aporoʼyet̃ñapaʼ cohuaʼyerrtserrpaʼ c̈hepaʼtchaʼ eʼñe cohuenterrtsaña paʼclleʼ. Eʼñe cohuen es entyesuahuerr allohuen. ");
INSERT INTO ameNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Allempoña Jesúspaʼ atet̃ och: —T̃eʼña ñerraʼm oʼch ahuerrep̃ pepacllopaʼ t̃arraña amach p̃oñmatsterroña anetsoʼmar, allochñapaʼ amach eseshaʼ p̃otap̃saʼtatsetnerro amaʼt eʼñe puesheñarra. ");
INSERT INTO ameNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Allempoña ahuerrerr Jesús pueyochreshohuen. Arr sechenet all oteñet Cesarea ñeñt̃ara Filipo allchaʼ chopeñeʼchyenetaʼ all anetsoʼmar. Allña t̃oñopaʼ aʼp̃t̃oʼtnoman pueyochreshaʼ ñeñt̃paʼ atet̃ otnomanet: —¿Errot̃enaʼt otyenenña allohuen acheñeneshaʼ, napaʼ eseshant̃eʼ? ");
INSERT INTO ameNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ñetñapaʼ atet̃ otyeset: —Patantarr acheñeneshaʼpaʼ atet̃caʼye otyenpet p̃apaʼ Juanañp̃oʼt̃eʼ ñeñt̃ep̃oʼ apatañtatseʼt̃ Yomporecop. Poʼpotantaññapaʼ atet̃ otyenpet p̃apaʼ Elíasop̃oʼt̃eʼ; poʼpotantaññapaʼ atet̃ otyenpet p̃apaʼ añep̃oʼt̃eʼ poʼpsheñeñ ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ ahuat̃. ");
INSERT INTO ameNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Allempoñapaʼ alla aʼp̃t̃oʼterraneterr: —Sañapaʼ ¿errot̃enaʼtña sotenenña sa? Pedroña eñoratsapaʼ atet̃ och: —P̃apaʼ ñeñt̃ep̃caʼye Cristotosets. ");
INSERT INTO ameNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Allempoñapaʼ otan pueyochreshaʼ: —Amach eseshaʼ sotap̃saʼtatsto amaʼt puesheñarra napaʼ na ñeñt̃en Cristotets. ");
INSERT INTO ameNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesúsña eʼñe allempot̃eñpaʼ mot̃etnom̃ eñotatyesnomueʼ pueyochreshaʼ ñeñt̃ atet̃ anaret̃ ñocop, ñeñt̃paʼ atet̃ otanet: —Na Ñeñt̃en Acheñetosetspaʼ atet̃ anaret̃ nocop, nanacchaʼ naʼmueroc̈htataret̃terra. Amach eseshaʼ pocteyeʼ nenterraye—amaʼt ñeñt̃ pomporneshaʼ pen judioneshaʼ, amaʼt ñeñt̃ paʼm̃chaʼtaret̃er pen judioneshaʼ poʼcornaneshar, amaʼt ñam̃a ñeñt̃ etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop—amaʼt ñetpaʼ amach eseshayeʼ neyemterraye. Att̃ochña napaʼ muetsataterrnetchaʼ. T̃arraña pomaʼpamtañoch oʼch alla netanterra. ");
INSERT INTO ameNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ñeñt̃paʼ eʼñe eñotoc̈hen otnomanet ñapaʼ atet̃chaʼ ap̃aret̃terra. Pedroñapaʼ allent̃a anem̃ aʼyenet̃paʼ allñapaʼ atet̃ otos: —Arepaʼch Partseshachaʼ att̃eyeʼ perrpeto amaʼt errponaña. ");
INSERT INTO ameNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesúsñapaʼ alla puerraperra cohuos pueyochresheshonet̃ allñapaʼ atet̃ otan Pedro: —Orrap̃ aʼyo neshot̃ oneñet̃e; p̃apaʼ amacaʼye Yomporeyeʼ atet̃ p̃oct̃apeʼchatenaye; ñeñt̃paʼ acheñarramcheʼ poct̃ap̃ña. ");
INSERT INTO ameNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Allempoña Jesúspaʼ agotan acheñeneshaʼ ñam̃a pueyochreshaʼ ñeñt̃paʼ atet̃ otanet: —Ñerraʼm eseshaʼ mueneneʼ oʼch cot̃errnet na eʼñe poʼñoc̈h att̃och neyochreshaʼ neperranet añ poctetsa sohuanmuetepaʼña ñeñt̃ atet̃ muenenet eʼñe ñocpueta amaʼt eʼñe pocrreñohuenet. Att̃ochña ñetpaʼ oʼch eʼñe tomaʼnteret ñeñt̃ chechneneʼ poʼcorsoch allchaʼ mueroc̈htet ñamet. Att̃ochña cot̃errnet eʼñe poʼñoc̈h. ");
INSERT INTO ameNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","T̃arroʼmar ñerraʼm eseshaʼ eʼñe aña muenenet oʼch correnet atomat att̃och eʼñe coshenet arr patsro, ñetñapaʼ c̈hach aʼchencatet ñañeñeta. T̃arraña ñerraʼm eseshaʼ eʼñe pocteʼ enteneʼ oʼch es sohuanerret eʼñe pocrreñohuenet nocop att̃och epatuerret cohuen ñoñets ñeñt̃paʼ alloch sequeshperra, ñeñt̃ña acheñerpaʼ ñañapaʼ corretsach eʼñe cohuen t̃ayot̃eñ errponañohuen. ");
INSERT INTO ameNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Amaʼt errponenap̃aren esocmañen es yeyoratsetyes ora allpon ñeñt̃ yentyen añe patsro, t̃arraña ñerraʼm ñeñt̃ach eʼñe yaʼchencaterreʼ yecamquëñohuen, ñeñt̃ñapaʼ amaʼt coñeʼt̃apaʼ amach es sherberrye. T̃arroʼmar ama eñalle poʼpoñ ñeñt̃ atarr sherbets, añña atarr nanac sherbets ñeñt̃chaʼ aʼqueshp̃aterreʼ yecamquëñ. ");
INSERT INTO ameNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","T̃arroʼmar yocoppaʼ ama es eñalle ñeñt̃chaʼ yepomuerr alloch alla yerañt̃erra yecamquëñ. ");
INSERT INTO ameNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","T̃arraña ñerraʼm erraʼtsenchaʼ nepenquënaya na t̃eʼ, neñoñpaʼc̈hoʼña c̈ha apencoc̈hen entennanet, napaʼc̈hoʼña nepencaʼhuerranetchaʼ esempoch nohuerra. Shonteʼ acheñeneshaʼ ñeñt̃ corraʼyetsa t̃eʼ arr patsro ñetñapaʼ atarr ochñat̃eneshet t̃arroʼmar ñetpaʼ poʼpoña poʼyomporer p̃aʼyenet. T̃arraña ñerraʼm eseshaʼch puepenquëñot̃etan na amach aʼmet̃enneto all, ñeñt̃ña acheñerpaʼ napaʼc̈hoʼña c̈hach nepencaʼhuera ñerraʼm esempoch nohuerra. Poʼñoc̈h napaʼ Ñeñt̃en Acheñetosetspaʼ nohuerrach eʼñe Nompor poʼcohuenñot̃ epan ñam̃a poʼm̃llañot̃eñnaneshar ñeñt̃ eʼñe t̃orraʼyetsa Partsocop. ");
INSERT INTO ameNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Allempoña Jesúspaʼ alla oterraneterr: —Poʼñoc̈hcaʼye t̃eʼpaʼ oʼch notas, patantaʼttsos ñeñt̃es arroʼtsaʼyenes t̃eʼña amaʼt ama serromhuenaʼpaʼ oʼch senterrñañ Yompor poʼcohuenña att̃o atarrchaʼ ayochreshat̃terra ña eʼñe poʼhuamencot̃. ");
INSERT INTO ameNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Allempo pechapmaterrerr, Jesúsñapaʼ ahuanerranerr pueyochreshaʼ; añ anem Pedro ñam̃a Jacobo ñam̃a Juan. Ñetpaʼ arr anmanet atarr aspent̃o eʼñe ñapt̃ochayet all aspent̃o. Allña Jesúspaʼ machayot̃epaʼtchaʼ eʼñe poʼpoñetam̃p̃sosanet. ");
INSERT INTO ameNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Paʼshtampaʼ c̈ha popta atarr nanac huallamaʼt̃. Arr patsropaʼ ama eñalle alloch yaʼhuallamaʼt̃tat yeshtam atet̃ ñerraʼm ña paʼshtam atarr huallamaʼt̃o poptena. ");
INSERT INTO ameNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Allñapaʼ machayot̃epaʼtchaʼ orrtanet Elías ñam̃a Moisés. Ñetñapaʼ alla serrpareʼtoset epuet Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedroña eñoratsapaʼ atet̃ otan Jesús: —Atarruacaʼye Maestrochaʼ cohuenoʼtseneyt̃eʼ arr. Amaʼt pocteʼ penteñe yapaʼ oʼch yat̃omatonas maʼppahua quërpachet, puepahuarrpaʼ p̃ocopchaʼ poʼppahueñpaʼ Moisésocopchaʼ, poʼppahueñpaʼ Elíasocopchaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ñehua, Pedroña pueyorñot̃ att̃a mueneʼ otatseʼt, ama eñoche errot̃enchaʼ ot. ");
INSERT INTO ameNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Allempo eñorena Pedropaʼ c̈ha orrtosahuet os ñeñt̃ atarr cohuen poptetsa c̈hepaʼtchaʼ aʼpomam̃p̃sosanet. C̈ha eʼmorrtostsa ñoñets osot̃; ñeñt̃ña ñoñetspaʼ Yompor otosahuet; ñeñt̃paʼ atet̃ ot: —Añmapaʼ ñeñt̃ no Nechemer ñeñt̃ atarr nemuerena, ñeñt̃chaʼña eʼñe cohuen seʼm̃ñoterr. ");
INSERT INTO ameNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Allempoña oʼ cohuaʼyerretpaʼ arepaʼtchaʼ eseshayeʼ enterreto, ñapt̃a enteret Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Allempo onac̈herret aspent̃ot̃ Jesúsñapaʼ atet̃ otnerranet: —T̃eʼpaʼ amach eseshaʼ sotap̃saʼtatsto amaʼt eʼñe puesheñarra ñeñt̃ atet̃ oʼ sentua. T̃arrempohuach allempoch netanterra na rromot̃ na Ñeñt̃en Acheñetosets, allempochña seserrpareʼtaterña allohuen acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ñetña atet̃ otanet Jesúspaʼ atet̃c̈hoʼ pet, ama aʼmet̃eññañeto poʼñoñ. T̃arraña ñetñapaʼ att̃a aʼp̃t̃oʼtannaʼtyesnerret: —Taʼm ¿est̃eʼña oteneyña Jesús oʼch tanterra rromot̃? ");
INSERT INTO ameNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Allempoña pueyochreshaʼ atet̃ otnerret: —¿Esoʼmareʼtña otenña ñeñt̃ atarr etsoteneʼ ñoñets ñeñt̃ atet̃ anaret̃, Elíasoʼch ñanom huerrtsa? ");
INSERT INTO ameNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ñañapaʼ atet̃ otnerraneterr: —Elías poʼñoc̈hpaʼ ñachcaʼyeña huerrtsa ñanom, ñapaʼ eʼñechcaʼye aʼcohuentatuer ora allohuen. T̃arraña sapaʼ amaʼt señotenoña ñam̃a ñeñt̃ atet̃ anaret̃ quellco eʼñe nocop. Ñeñt̃ allpaʼ atet̃caʼ oten na Ñeñt̃en Acheñetosets atarrchaʼ naʼmueroc̈htataret̃terra, atarrchaʼ tsenaʼterrnet. ");
INSERT INTO ameNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","T̃arraña napaʼ oʼch notas, Elíaspaʼ oʼcaʼye huaphuerrañ arr, ñeñt̃apaʼ c̈haña errot̃uanen p̃apueret ñeñt̃ atet̃ muenaʼyenet ñet. Att̃ocaʼyeña etsoterraña ñam̃a ñeñt̃ atet̃ anaret̃ quellco ñocop. ");
INSERT INTO ameNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Allempoña c̈hac̈herret alloʼtsaʼyen pueyochreshaʼ allñapaʼ alla entuereterr shonteʼ acheñeneshaʼ ñeñt̃ emchorrenaya poʼpotantañ pueyochreshaʼ. Ñeñt̃ña etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃paʼ alla entuerraneterr all es otnareʼteññañet pueyochreshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Allempoña entapuer allohuen acheñeneshaʼpaʼ c̈ha atarr cohuanrrortapueret, matrraʼtet ñeshopaʼ huom̃chaʼtapueret. ");
INSERT INTO ameNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesúsñapaʼ allent̃a otuerranet: —Sapaʼ ¿errot̃enaʼtña sotannaʼtyena? ");
INSERT INTO ameNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Puesheñarrña ñeñt̃ alloʼtsenpaʼ ñañapaʼ atet̃ otap̃: —Maestrochaʼ napaʼ oʼcaʼye nohuapatonapeñña nechemer, c̈hacaʼye chorreña oneñet̃ c̈ha opanatateñ. ");
INSERT INTO ameNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ñerraʼm errot̃eno rremueñpaʼ c̈hachcaʼye ataʼtateñ patso, c̈hach amtan paʼpoʼpaʼ oʼch rrasoʼtan paʼs, oʼch eʼñe echarrta. Oʼ notuosnap̃ña peyochreshaʼ oʼch quec̈hpateret oneñet̃ ñeshot̃paʼ t̃arraña ñetpaʼ amacaʼye eshcayeʼ quec̈hpateñeto. ");
INSERT INTO ameNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesúsñapaʼ atet̃ otanet: —Sa ñeñt̃es acheñres amaʼt mameshapaʼ ama ayemtenayeʼ sentpenno. Oʼ allponmatuanen alloʼtsenen arr patsro, napaʼ att̃a atarr naʼhuantennas, att̃a necuenes ñatoʼ att̃ot̃paʼ oʼch sameʼñerrna. Allempoñapaʼ atet̃ otanet: —Amaʼtpaʼ sanmoncaʼye cheshaʼ arr. ");
INSERT INTO ameNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Allempoña anmoñet cheshaʼpaʼ oneñet̃ñapaʼ entosan Jesúspaʼ c̈hepaʼtchaʼ ot̃atosanña cheshaʼpaʼ alla ata patso, c̈ha pomeroʼta, amtan ñam̃a paʼpoʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesúsñapaʼ allent̃a otoñ pompor: —¿Esempot̃eñeʼtña atet̃ perra? Ñañapaʼ atet̃ och: —Cheshot̃eñcaʼye atet̃ perra. ");
INSERT INTO ameNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Oʼt̃eʼ epayeʼ ataʼtater amaʼt tso amaʼt ñam̃a oño att̃och muetsereñ. P̃aña t̃eʼpaʼ ñerraʼm errot̃enot̃paʼ eʼñe pemuereñot̃ pebensam̃p̃sayeʼcherrnan nechemer allochñapaʼ att̃och metuer att̃o mueroc̈htena. ");
INSERT INTO ameNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesúsñapaʼ atet̃ och: —Ñerraʼm na peyemtena amacaʼye eñalleña ñeñt̃ t̃orrapoʼ añecop ñeñt̃ eʼñe neyemtenaya na. ");
INSERT INTO ameNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Allempoña ñeñt̃ pompor pen cheshaʼpaʼ rranapaʼ atet̃ otererr: —Napaʼ neyemtenp̃añcaʼye, t̃eʼñapaʼ peyenpaʼn Ayochreshat̃e att̃och neyemterrp̃a eʼñe poctacma. ");
INSERT INTO ameNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Allempoña Jesúspaʼ entapan shonteʼ acheñeneshaʼ ñeñt̃ matac̈hetsa ñeshonet̃, ñañapaʼ allent̃a otan oneñet̃: —P̃a oneñet̃e, opanatatañep̃, aʼpaquetatañep̃, t̃eʼñapaʼ oʼch notap̃: Pequec̈hpaʼner cheshachor eʼñe t̃ayecma, amaʼt errponaña amach alla pechorrereʼt̃e. ");
INSERT INTO ameNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Eʼñe otueʼ atet̃ oneñet̃ñapaʼ c̈hepaʼtchaʼ rranaʼnmatsa, alla ot̃atnerranerr cheshachorpaʼ c̈ho quec̈hpaʼnmueʼ oʼ ahuerr. Cheshachorpaʼ ama pelleno c̈ha otta ñerraʼmrrat̃eʼ oʼ rroma. Acheñeneshaʼñapaʼ atet̃ otyes: —Poʼñoc̈h t̃eʼpaʼ oʼcaʼye rroma. ");
INSERT INTO ameNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesúsñapaʼ allent̃a cheteʼ potot̃paʼ oʼ tantach, cheshaʼñapaʼ c̈ha t̃errets eʼñe cohuen. ");
INSERT INTO ameNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Allempoña Jesúspaʼ ahuerr pueyochreshohuen, oʼ beʼt̃osc̈haʼtuerret pocollo, allpaʼ eʼñe ñapt̃ochayet, pueyochreshaʼñapaʼ allent̃a otueret Jesús: —Yapaʼ ¿esoʼmareʼtña ama eshcayeʼ yequec̈hpatatereña oneñet̃? ");
INSERT INTO ameNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ñañapaʼ atet̃ otanet: —Ñeñt̃ atet̃ oneñet̃paʼ amach errot̃enot̃ yequec̈hpatatereña eʼñe att̃a. C̈hochña yemaʼyochena ñam̃a yemaʼyoc̈hreñot̃ amaʼt yerrarpaʼ oʼch yequec̈hpueʼ mameʼ. Att̃ot̃chaʼña yequec̈hpataterña oneñet̃ ñeñt̃ atet̃. ");
INSERT INTO ameNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ahuanerreterr allot̃paʼ arr oñemhuanerret Galileoʼmar. Jesúsñapaʼ mueneñeñ aʼnahuot̃oʼch metañ ");
INSERT INTO ameNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","t̃arroʼmar ñapaʼ mueneñ oʼch yec̈hatnoman pueyochreshaʼ. Ñeñt̃paʼ atet̃ otnomanet: —Na Ñeñt̃en Acheñetosetspaʼ pomataterrnetchaʼ att̃ochña errot̃uanenchaʼ perrnet. Att̃eñapaʼ oʼch muetsataterrnet t̃arraña pomaʼpamtañoñapaʼ oʼch alla netanterra. ");
INSERT INTO ameNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ñeñt̃ña ñoñets ñetñapaʼ amaʼt puesheñarrot̃etapaʼ ama eseshayeʼ eñotenayeʼ enteñeto ñeñt̃oʼmarña ama aʼp̃t̃oʼtenayeʼ enteñeto. ");
INSERT INTO ameNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Allempoña c̈hac̈haʼtet ñam̃a Capernaumo. Allempoña c̈hapuet pocollo Jesúsñapaʼ otanet: —Sapaʼ, ¿esoʼt sotannaʼtyesnenaña ñorraʼ t̃oño? ");
INSERT INTO ameNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ñetñapaʼ ama eseshayeʼ anapuenayeʼ entaye t̃arroʼmar ñetpaʼ añcaʼye otannaʼtyesnenetña t̃oño: —Yapaʼ erraʼtsenot̃eyt̃eʼñacaʼyeña ñeñt̃ey atarr sherbets, ñeñt̃ey atarr am̃chaʼtaret̃oyen enteney acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesúsñapaʼ all anorrospaʼ allent̃a c̈horeʼtan allohuen pueyochreshac̈hnopaʼ atet̃ otanet: —Ñerraʼm erraʼtsenot̃es ñeñt̃es atarr am̃chaʼtaret̃oyen entetsañ, ñeñt̃es acheñres socoppaʼ añ poctetsa oʼch atet̃ senterra ñerraʼm ama esosheʼmayayso ñeñt̃ atet̃ pena ñeñt̃ att̃a atarr taruasets poʼpotantañecop, amaʼt ñam̃a allohuenacop. ");
INSERT INTO ameNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jesúsñapaʼ cheshat̃olla c̈horeʼtpaʼ t̃omach eʼñe alla, allent̃a enachpaʼ atet̃ otanet: ");
INSERT INTO ameNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Erraʼtsenot̃es sa ñerraʼm eʼñe cohuen saguëñ amaʼt ñeñt̃ ama asherbenayeʼ entyeneto atet̃ ñerraʼm añ cheshat̃oll t̃arroʼmar sapaʼ na sameʼñena, naʼnaña eʼñe cohuen saguën. Elloña ñam̃a erraʼtsenot̃es sa ñeñt̃es naguëneʼ na, ama eʼñe napt̃ocheyeʼ saguëno, añeʼnaña saguënnan Nompor ñeñt̃ nellsenseneʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Allempoña pueyochreshaʼ ñeñt̃ Juanpaʼ atet̃ otan Jesús: —Maestro, ya ahuañapaʼ atet̃ yeñch puesheñarr yacma ñeñt̃ quec̈hpateneʼ oneñet̃. Eʼñe puec̈horeʼteñot̃ep̃ p̃a pesoʼchñopaʼ quec̈hpatan oneñet̃. Yañapaʼ ama pocteyeʼ yeñche t̃arroʼmar ñapaʼ ama parroyeʼ yeyemteno. Ñeñt̃oʼmarña yapaʼ atet̃ yoch: —Amach atet̃ pep̃atsto. ");
INSERT INTO ameNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesúsñapaʼ atet̃ ot: —Sapaʼ amachcaʼye sepatareʼtatsche t̃arroʼmar ñerraʼm erraʼtsenchaʼ orrtateʼ partsoteñets eʼñe na nesoʼchño, ñeñt̃ña acheñer tsapat̃onet̃paʼ amachcaʼye muenere alla oʼch achm̃areʼterren. ");
INSERT INTO ameNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ñam̃a ñerraʼm ama c̈ho epatareʼtenye yam̃a, ñeñt̃ña poʼñoc̈hpaʼ eʼñecaʼye parrocma yeyenpannena. ");
INSERT INTO ameNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Poʼñoc̈hcaʼye notenes: Amaʼt erraʼtsena acheñer ñeñt̃chaʼ sapueʼ amaʼt coñeʼt̃a oñ t̃arroʼmar sapaʼ eʼñe na neyochreshaʼ nepenes, ñeñt̃ña acheñerpaʼ c̈hocmach atsaʼtaret̃terra ñeñt̃chaʼ atarr coshaterreʼ ña. ");
INSERT INTO ameNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Amaʼt erraʼtsena ñeñt̃ ama pommoʼcheñot̃eyeʼ ameʼñenno atet̃ ñerraʼm cheshat̃oll ñeñt̃ ama eñotenanaʼ oʼch ommoʼchena, t̃arraña ñerraʼm eseshaʼña poʼpsheñeñ oʼch atet̃ p̃atach ñeñt̃ ama pocteyeʼ enteno Yompor, ñeñt̃ña acheñerpaʼ atarrchaʼ yoroc̈henoʼtsen t̃arroʼmar ñapaʼ aña oʼpatenaya coñcheñets ñeñt̃ atarr huomenc. Amaʼt ñocoppaʼ ama tama yoroc̈henayayñe ñerraʼm ama atet̃ p̃atenanaʼ poʼpsheñeñ, eʼñech allorocma c̈harachetañ mapueʼ añecmuen paʼc̈hnop̃o allpon ñerraʼm puetseʼtamets oʼch huaporeʼchet oño epo allchaʼ ñoʼshach mapueʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","48","Ñam̃a oʼch noterrserr: Ñerraʼm sechets p̃atyenes ñeñt̃ ama pocteyeʼ enteno Yompor atet̃ ñerraʼm sot, setac, seclleʼ, añ poctetsa oʼch sequec̈hpuerr ñeñt̃ c̈hocma atet̃ p̃atseʼtatyenes sechets. Ñeñt̃paʼ eʼñe atet̃ ñerraʼmrrat̃eʼ eʼñe allorocma oʼ sepecherr sot, setac, oʼ serrot̃err seclleʼ, oʼch sehuaporeʼter. Añ cohuen socop amaʼt eʼñe sepoʼyotateñot̃ corretsasach t̃ayot̃eñ errponohuañen. Añña ama cohuenayaye socop esempohuañenpaʼ eʼñech ora epoʼmar sotpaʼ oʼch sec̈herr coñchaʼpuetso all parraren tsoʼ ñeñt̃ ama emayaʼpahuoyaye. Allpaʼ amaʼt pueñmochapaʼ ama rromueno; tsoʼpaʼc̈hoʼña ñeñt̃ alloʼtsenpaʼ ama amayaño amaʼt errponaña. Ñam̃a añ cohuen socop amaʼt eʼñe setcot̃paʼ sepshem̃tatquëñot̃ corretsasach t̃ayot̃eñ errponohuañen. Añña ama cohuenayaye socop esempohuañenpaʼ eʼñech ora epoʼmar setacpaʼ oʼch huaporeʼterrset coñchaʼpuetso all parraren tsoʼ ñeñt̃ ama emayaʼpahuoyaye. Allpaʼ amaʼt pueñmochapaʼ ama rromueno; tsoʼpaʼc̈hoʼña ñeñt̃ alloʼtsenpaʼ ama amayaño amaʼt errponaña. Ñam̃a añ cohuen socop amaʼt seclloyot̃ sepshem̃taclloʼyeñot̃ oʼch sec̈herr all am̃chaʼtaret̃tena Yompor. Añña ama cohuenayaye socop esempohuañenpaʼ eʼñech ora epoʼmar seclleʼpaʼ oʼch huaporeʼterrset coñchaʼpuetso all parraren tsoʼ. Allpaʼ amaʼt pueñmochapaʼ ama rromueno; tsoʼpaʼc̈hoʼña ñeñt̃ alloʼtsenpaʼ ama amayaño amaʼt errponaña. ");
INSERT INTO ameNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ñeñt̃ña Jesúspaʼ atet̃ tomaʼntaterraneterr: —Allohuen ñeñt̃chaʼ cohuenterrtsapaʼ añchaʼcaʼye aʼcohuentateneʼ tsoʼ; ñam̃a allohuen ayarrac̈hno ñeñt̃ amtsaret̃tetsa Yomporecoppaʼ añcaʼyeña aʼcohuentateneʼ pos. ");
INSERT INTO ameNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ñehua, yapaʼ yeñoteñ pospaʼ atarr cohuen sherbeney. T̃arraña ñerraʼm posña poʼposerrteña huañerretspaʼ yapaʼ amat̃eʼ errot̃ yepe oʼch alla yaʼposerrtater att̃och alla sherberrey. Sapaʼ eʼñepaʼchña cohuen sesherb̃annena eʼñech att̃es ñerraʼm pospaʼ atarrchaʼ sherbeney. Att̃ochña eʼñe cohuen sentannena eʼñech muechet̃ seyc̈haʼyena. ");
INSERT INTO ameNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Allempoña Jesúspaʼ err Capernaumot̃paʼ ahuerr anetso Judeo ñam̃a arreʼna sen Jordanas yom̃taʼn. Allñapaʼ alla shonterrñañerr acheñeneshaʼ, ñañapaʼ yec̈haterraneterr Yompor poʼñoñ ñeñt̃ c̈hocma att̃ecma penanet. ");
INSERT INTO ameNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Allñapaʼ oʼ alla huac̈herrñañerr ñam̃a fariseoneshaʼ. Ñetñapaʼ aña atarr eʼnenet eʼñe pueshquëñot̃et poʼñoñot̃etpaʼ oʼch eñorachet ñeñt̃ ama cohuenayaye. Ñeñt̃oʼmarña ñetpaʼ atet̃ otoset: —Taʼm ¿pocteʼt̃eʼ oʼch yeser yet̃apor? ");
INSERT INTO ameNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ñañapaʼ atet̃ otapanet: —Sapaʼ ¿amaʼt señotenoña Moisés poʼñoñ ñeñt̃ atet̃ nonaseʼt̃? ");
INSERT INTO ameNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ñetñapaʼ atet̃ ochet: —Moisés poʼñoñpaʼ atet̃caʼye oten, c̈hoch yequellcoñ yet̃apor papell ñeñt̃chaʼ yap̃ allempochña yeser. ");
INSERT INTO ameNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesúsñapaʼ atet̃ otanet: —T̃arraña sa seyoc̈hropaʼ c̈hocmacaʼye poʼpoñ sentuena ñeñt̃oʼmarcaʼyeña Moiséspaʼ atet̃ quellconaseʼt̃ att̃och seseʼ set̃apor. ");
INSERT INTO ameNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Amaʼt atet̃ muenataseñpaʼ t̃arraña Yomporpaʼ eʼñe ahuat̃ot̃eñ allempot̃eñ es yec̈hcatyes “allempo yec̈hcatan ñam̃a asheñorr, yec̈hcatan ñam̃a peno.” ");
INSERT INTO ameNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Allempo Yomporpaʼ atet̃ ot: “Ñeñt̃oʼmarña yacmapaʼ ñerraʼm esempoch senaʼta, coyaneshaʼpaʼ oʼch echan puerrollar, añ pocteʼ oʼhuañchaʼ tama yemteñet pamoʼmteʼ allochñapaʼ yacmapaʼ att̃ochña eʼñe parrocmat epuet puet̃apor. ");
INSERT INTO ameNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Att̃oña epsheñoʼmaretpaʼ eʼñech pat̃rra poʼchets penet.” Att̃ot̃chaʼña oʼhuañchaʼ puesheñaʼtetstet, allochñapaʼ oʼch eʼñe puesheñarratet. ");
INSERT INTO ameNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ñeñt̃ att̃o Parets eʼñe pat̃rratatan yacma epuet puet̃apor amach c̈ha ellopaʼ alla sannerreto. ");
INSERT INTO ameNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Allempo c̈hac̈herret pocollo, allña pueyochreshaʼpaʼ atet̃ otueret: —¿Errot̃ent̃eʼña ñeñt̃ atet̃ p̃oten ñorraʼ añoʼ asannaʼtpahuo? ");
INSERT INTO ameNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ñañapaʼ oterraneterr: —Ñerraʼm eseshaʼ serreʼ puet̃apor oʼch alla yorerran poʼpsheñeñ ñeñt̃chaʼ puet̃apor perr, ñeñt̃ña yacmarpaʼ c̈hachcaʼye ochñaʼtam̃perrana puet̃aporesheʼmañ. Ñeñt̃paʼ ama pocteyeʼ enteñe Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ñam̃a coyaneshaʼ ñerraʼm serran puerrollar oʼch yorer poʼpsheñeñ yacma ñeñt̃chaʼ puerrollar perr, ñeñt̃ña coyanesharpaʼ c̈hachcaʼye ochñaʼtam̃perrana ñam̃a puerrollaresheʼmañ. Ñeñt̃paʼc̈hoʼña amaʼt mameshapaʼ ama pocteyeʼ enteñe Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Allempoñapaʼ huac̈haʼtachet ñam̃a shonteʼ cheshat̃olleshaʼ Jesúsesho. Ñetpaʼ añecopña huac̈haʼtachet oʼch aʼp̃llaʼyesapanet Jesús. Jesúsña pueyochreshaʼ allempo entapan ñeñt̃ huac̈haʼtateʼ cheshaneshac̈hno ñetñapaʼ ama pocteyeʼ eñcheto oʼch anmoset cheshat̃olleshaʼ Jesúsesho ñeñt̃oʼmarña ama amnataret̃tapueto. ");
INSERT INTO ameNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","T̃arraña Jesúsña allempo entan pueyochreshaʼ c̈ha epatareʼtapan cheshat̃olleshaʼ, ñañapaʼ amaʼt mameshapaʼ ama pocteyeʼ entaneto. Ñañapaʼ atet̃ otanet: —Pocteʼñac̈hoʼ semnachñacaʼyeña cheshaneshaʼ onosetepaʼ eʼñe nesho. Amachcaʼye c̈ha sepatareʼtatstapaneto t̃arroʼmar allohuen ñeñt̃ atarr neyemtenaya na atet̃ ñerraʼmrrat̃eʼ cheshat̃oll, ñetchaʼ oʼpatenetña Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña. ");
INSERT INTO ameNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Poʼñoc̈hpaʼ oʼch notas, ñerraʼm eseshaʼ ama eʼñeyeʼ pueyemteñot̃eyeʼ aguëññañeto Yompor poʼcohuenña amach atet̃ perreto ñerraʼm cheshat̃oll eʼñech yemtenana ñeñt̃ cohuam̃peneʼ, ñetñapaʼ amach oʼpatenetoña Yompor poʼcohuenña att̃o atarr ayochreshat̃tena ña. ");
INSERT INTO ameNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Allempoña Jesúspaʼ aʼc̈honoʼtyesapan cheshaneshaʼpaʼ allña aʼp̃llaʼyesapanetña eʼñe ña potot̃ att̃oña bensareʼtam̃p̃sapanet. ");
INSERT INTO ameNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Allempoña Jesúspaʼ oʼch ahuenñerr allenet̃ sechena. Allent̃epaʼtchaʼ huapaʼmuena puesheñarr yacma eʼñe matenacma huapa. Alla concorpanaʼtosana Jesúspaʼ atet̃ otos: —Maestro, p̃apaʼ atarr cohuen acheñrep̃, t̃eʼpaʼ oʼch p̃otapuen ¿errot̃enaʼtchaʼ nepaña na ñeñt̃ eʼñe cohuen att̃ochña napaʼ corretsanach eʼñe t̃ayot̃eñ amaʼt errponañohuen? ");
INSERT INTO ameNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesúsñapaʼ atet̃ otap̃: Esoʼmareʼt p̃otenenña napaʼ atarroʼ cohuen acheñren. Arr arromñat̃eneshaʼ amaʼt eʼñe puesheñarrapaʼ ama eñalleña ñeñt̃ eʼñe cohuen acheñer. Ñapt̃aña Yompor ñeñt̃ eʼñe poʼñoc̈h cohuen. ");
INSERT INTO ameNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","P̃apaʼ eʼñe peñotuen Yompor poʼñoñ all oteney ñeñt̃chaʼ atet̃ yepena eʼñe cohuen, ñeñt̃ atet̃ oteney: “Amach yechtapretyesatsto t̃aporets, amach yemtsannaʼtatsto, amach yetyesatsto, amach yetomaʼtam̃p̃satsche yamoʼts eʼñe att̃a, yeshquëñot̃paʼ amach es yeprratam̃p̃satsche poʼpsheñeñ, ñam̃a yemorrenteñot̃paʼ yem̃chaʼnaʼchchaʼ yompor ñam̃a yachor.” ");
INSERT INTO ameNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ñeñt̃ña aʼp̃t̃oʼteneʼpaʼ atet̃ otererr: —Maestrochaʼ napaʼ eʼñecaʼye cheshot̃eñ ora añec̈hnopaʼ eʼñecaʼye netsotueñ. ");
INSERT INTO ameNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesúsña eʼñe puemorrenteñot̃ cohueʼpaʼ atet̃ otererr: —Eñallmeñcaʼye pat̃err ñeñt̃ pepalltena ñeñt̃ ama att̃eyeʼ pepeno. T̃eʼpaʼ añchaʼña atet̃ pep̃a oʼch ahuerrep̃ oʼch pepomhuerr ora allpon ñeñt̃ pechyen oʼch p̃apaʼyeraʼ huocchañneshac̈hno ñeñt̃ atarr es palltaʼyetsa, att̃ochña p̃apaʼ pecherrchaʼ ñeñt̃ atarr nanac sherbets Yompor pueʼntaño. Allempochña pehuerrapaʼ oʼch p̃oct̃erren att̃och eʼñe neyochreshaʼ neperrep̃ eʼñe poctacma. ");
INSERT INTO ameNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Oʼña eʼmhuan ñeñt̃ atet̃ och Jesúspaʼ ñañapaʼ c̈ha atarr nanac lleca t̃arroʼmar ñapaʼ shonteʼ esocmañen echyen. Ñeñt̃oʼmarña eʼñe puellquëñeshaʼ ahuerr. ");
INSERT INTO ameNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Allempoña Jesúspaʼ cohuaʼyesanetpaʼ atet̃ otan pueyochreshaʼ: —Ñeñt̃ atarr ec̃llayoret̃paʼ atarrcaʼye nanac echarr att̃och agapoñet Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña. ");
INSERT INTO ameNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Pueyochreshaʼñapaʼ c̈ha mueneʼ yoreʼtanet ñeñt̃ atet̃ otenanet. Jesúsñapaʼ alla oterraneterr: —Nechemerneshachaʼ oʼch notas: Añ acheñer ñeñt̃ añach eʼñe yemtena ñeñt̃ allpon echyen arr patsro ñeñt̃ña acheñerpaʼ atarrcaʼye nanac echarr oʼch agapoñet Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña. ");
INSERT INTO ameNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ñehua, ñeñt̃paʼ atet̃chaʼ netmaʼntacha. Poʼñoc̈h yapaʼ yeñoteñ berr añecmuen allpon ñerraʼm huaquësh atarrcaʼye t̃orrapoʼ oʼch eshoʼtosa añet̃ollponat̃ollo atet̃ ñerraʼmrrat̃eʼ acosh puetat̃ollo. Ñeñt̃paʼ atet̃caʼye penaña acheñ ñeñt̃ ec̃llayoret̃, ello atarr t̃orrapoʼ oʼch agapan ñam̃a Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña (t̃arroʼmar ñetpaʼ ama mueneñeto oʼch sehuanmuet ñeñt̃ atarr morrentenet ñet att̃och pueyochreshaʼ perranetañ Yompor). ");
INSERT INTO ameNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Pueyochreshaʼña allempo eʼmet Jesús atet̃ oten, ñetñapaʼ c̈ha mueneʼ llecaʼrrtetpaʼ atet̃ otannaʼtyeset: —T̃arraña ñerraʼm atet̃t̃eʼpaʼ amat̃eʼ eseshaʼ aʼqueshp̃ataret̃terrtso amaʼt puesheñarra t̃arroʼmar yapaʼ yeñoteñcaʼye huaquëshpaʼ amacaʼ eshoʼtenoña acshequeto. ");
INSERT INTO ameNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Allempoña Jesúspaʼ att̃a cohuaʼyesanetpaʼ atet̃ oterraneterr: —Sa arromñat̃eneshaspaʼ amach es errot̃enayeʼ apen senteno. T̃arraña Yomporpaʼ ama eñalleña ñocop ñeñt̃ atarr t̃orrapoʼ enten. ");
INSERT INTO ameNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Allempoña Pedropaʼ atet̃ och: —Partseshachaʼ poʼñoc̈h yapaʼ oʼ eʼñe yesuanom ora allohuen att̃och eʼñe yoct̃errep̃. ");
INSERT INTO ameNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesúsñapaʼ alla oterraneterr: —Allohuen erraʼtsenchaʼ acheñer ñeñt̃chaʼ eʼñe sehuanmueʼ allohuen amaʼt paʼpacllohuen, amaʼt paʼmoʼnasheñneshaʼ ñatoʼ poʼc̈haneshaʼ ñatoʼ pompor, pachor ñatoʼ puet̃apor, ñatoʼ pacñet̃ar ñatoʼ poʼpatseñ att̃ochña napaʼ eʼñech cohuen sherberrnet pueserrpareʼteñot̃et cohuen ñoñets alloch aʼqueshp̃ataret̃terra acheñeneshaʼ, ");
INSERT INTO ameNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","elloña ñetpaʼ oʼch alla aguërret shonteʼ esocmañen ñeñt̃ atarr cohuen. Amaʼt allponapaʼtets sehuanomyesnomuet, elloña c̈harroch c̈harraʼch alla agapyerret, amaʼt eʼñe t̃ayot̃eñ allempo correnet arr patsro—amaʼt ñeñt̃chaʼ paʼpacllac̈hno perret ñam̃a ñeñt̃chaʼ paʼmoʼnasheñeshac̈hno perret, ñam̃a ñeñt̃chaʼ poʼc̈haneshac̈hno perret, ñam̃a ñeñt̃chaʼ pachorneshac̈hno perret ñam̃a ñeñt̃chaʼ pacñet̃arec̈hno perret, ñam̃a ñeñt̃chaʼ poʼpatseñ perret. T̃arraña amaʼtchaʼ atet̃ aparet̃terretañpaʼ c̈hocmach amueroc̈htataret̃terret pameʼñeñot̃etan na. Elloña tsapat̃onet̃ña ñetñapaʼ aguërretchaʼ ñeñt̃ alloch corretsetach beñecpuen pocsheñeshocmañen. ");
INSERT INTO ameNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","T̃eʼpaʼ señochepaʼch eñall shonteʼ acheñ ñeñt̃ ama asherbenayeʼ senteno sa t̃eʼ t̃arraña ñetña allempopaʼ atarrchaʼ asherben enterranet Yompor. Ñam̃a eñall shonteʼ acheñ ñeñt̃ atarr asherben sentyen sa t̃eʼ, t̃arraña ñetña allempopaʼ amach asherbenayeʼ enterraneto Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Allempo ahuaneneterr ñam̃a Jerusaléñonet̃, all oñenet t̃oñoʼmar Jesúsñapaʼ ña otetsa. Pueyochreshaʼñapaʼ c̈ha t̃oratsetyesnenet pueyoc̈hret, eʼñe puem̃chaʼnañot̃a cot̃eñ. Pueyochreshaʼ ñeñt̃ c̈harraʼ puechena epsheña ñeñt̃ñapaʼ ahuanem̃ Jesús ellonet̃, allñapaʼ eñotaterraneterr ñeñt̃chaʼ huapoya ñocop. ");
INSERT INTO ameNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ñeñt̃paʼ atet̃ otanet: —T̃eʼña poʼñoc̈hpaʼ oʼcaʼye ahueney Jerusaléño. Allchaʼ pomataterrnet na Ñeñt̃en Acheñetosets. Añchaʼ nerrmuerreʼ ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar ñam̃a ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃. Ñetñapaʼ atet̃chaʼ otyesnet naʼmtsaret̃terrepaʼtoʼ oʼch pomuerrnet poʼpoñ acheñesho ñeñt̃ ama judioneshayaye. ");
INSERT INTO ameNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ñetña puecheʼtatseteñot̃etanpaʼ allchaʼña achm̃areʼterrnet, ashterrnetchaʼ, aʼcoshareʼterrnetchaʼ att̃ot̃chaʼña oʼch corsoʼtam̃perrnet, t̃arraña pomaʼpamtañoch alla netanterra. ");
INSERT INTO ameNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Allempoñapaʼ atet̃ oteñaʼ Jacobo ñam̃a Juan ñeñt̃ Zebedeo puechemereshaʼ ñeñt̃paʼ atet̃ otoset: —Maestrochaʼ yapaʼ añcaʼye yemnen oʼch atet̃ pep̃aʼy ñeñt̃chaʼ yotap̃. ");
INSERT INTO ameNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ñañapaʼ atet̃ otanet: —Sapaʼ ¿errot̃enaʼtña semnen atet̃chaʼ nep̃as? ");
INSERT INTO ameNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ñetñapaʼ atet̃ otereterr: —Yapaʼ añcaʼye yemnen t̃eʼpaʼ oʼch pemnatey oʼch yanorruerr pesho pecohuenño, puesheñarrot̃eypaʼ pecohuenrot̃chaʼ yanorryesuerr, poʼpsheñeñpaʼ peʼchcot̃erot̃chaʼ anorruerr allchaʼ yecohuentapreterrp̃a. ");
INSERT INTO ameNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesúsñapaʼ atet̃ otanet: —Sapaʼ amacaʼye señoteñe ñeñt̃ poʼñoc̈h senamuenen. Añcaʼyeña senamuenen att̃och semueroc̈htapreterrna sam̃a. Taʼm ¿eʼñet̃eʼ poʼñoc̈h pocteʼ senteñ oʼch semueroc̈hterra sam̃a t̃arroʼmar napaʼ c̈hocmach naʼmueroc̈htataret̃terra? Ñeñt̃ mueroc̈hteñetspaʼ Jesúspaʼ atet̃ tomaʼntatanet ñerraʼmrrat̃eʼ atarr pesherr es yorren orram̃tso ñam̃a att̃o yapataret̃tena eʼñe atet̃ ñerraʼmrrat̃eʼ c̈hoʼ yaʼmtsaret̃terra Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ñetñapaʼ atet̃ ochet: —Yapaʼc̈hoʼña atet̃chaʼcaʼye yep̃a. Ñañapaʼ alla oterraneterr: —Ñehua, poʼñoc̈hpaʼ saʼmueroc̈htataret̃terrach sam̃a att̃eschaʼ ñerraʼm na, saʼmtsaret̃terrach sam̃a. ");
INSERT INTO ameNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","T̃arraña añña att̃och sanorryesuerr nesho necohuenrot̃ ñam̃a neʼchcot̃erot̃ allchaʼ secohuentapreterrna ñeñt̃paʼ amacaʼye nayeʼ semnatenaye. Añchaʼña anorryesuerrets all ñeñt̃ eʼñe oʼpatatenna Nompor. ");
INSERT INTO ameNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Añña poʼpotantañ pueyochreshaʼ ñeñt̃ c̈harrasheña allempo eʼmet ñeñt̃ atet̃ enamuen Jacobo epuet paʼmoʼnasheñ Juan, ñetñapaʼ ama pocteyeʼ eñcheto c̈ha mueneʼ eʼmoñeʼchet. ");
INSERT INTO ameNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Allempoña Jesúspaʼ alla c̈horeʼterranet allohuenet ñesho ñeñt̃paʼ atet̃ otanet: —Sapaʼ señoteñt̃eʼ ñeñt̃ atet̃ pena poʼpoñ acheñeneshaʼ ñeñt̃ ama judioneshayaye. Ñet ñeñt̃ paʼm̃chaʼtaret̃er penet eʼñech paʼm̃chaʼnoc̈hteñocmañen pomnaren p̃aʼyenan allohuen pueyochreshac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Sapaʼ arepaʼchña att̃eyeʼ sep̃annaʼtatsto eʼñe sommoʼcheñot̃. Socoppaʼ añña poctetsa. Ñerraʼm erraʼtsenot̃es atarr am̃chaʼtaret̃oyen entetsañ ñeñt̃es acheñres socoppaʼ añ poctetsa oʼch atet̃ senterra ñerraʼm ama esosheʼmayayso ñeñt̃ atet̃ pena ñeñt̃ att̃a atarr taruasets poʼpotantañecop. ");
INSERT INTO ameNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ñam̃a ñerraʼm erraʼtsenot̃es ñeñt̃es mueneneʼ oʼch atarr asherben entenset ñeñt̃esña acheñrespaʼ añ poctetsa oʼch atet̃ senterra ñerraʼm ama esoyayso allochñapaʼ att̃ochña eʼñech cohuen set̃orrena poʼpotantañecop amaʼt ñam̃a allohuenacop atet̃ ñerraʼmrrat̃eʼ acheñ ñeñt̃ atarr taruasets eʼñe att̃a. ");
INSERT INTO ameNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Atet̃ ñerraʼm na Ñeñt̃en Acheñetosets, napaʼ ama añecpayeʼ nehuapo añe patsro allochñapaʼ sapaʼ oʼch att̃a atarr sesherb̃apuen na atet̃ ñerraʼmrrat̃eʼ napaʼ atarr am̃chaʼtaret̃ sentenen. Napaʼ añecopña nehuapa allochñapaʼ nachña sesherb̃oseʼña sa, ñeñt̃oʼmarña napaʼ naña pomostsa nañeña oʼch nerromos socop att̃ochña netsaʼtuerrnasa soʼchñar ñeñt̃es shontes paʼnamen acheñres. Att̃ochña sapaʼ amach sañeña rromatso soʼchñarecop. ");
INSERT INTO ameNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Allempoñapaʼ oʼ c̈hac̈haʼtet Jericó. Allempo meterrerr Jericót̃ epuet pueyochreshaʼ ñam̃a shonteʼ acheñeneshaʼ eʼñe allpona serreterrpaʼ allña eʼñe t̃oñetop̃ñopaʼ ahuepaʼt anorros puesheñarr aporoʼyet̃ ñeñt̃ c̈hocma enamareʼtets quelle. Ñeñt̃paʼ añ paʼsoʼcheñ Bartimeo ñeñt̃paʼ Timeo puechemer. ");
INSERT INTO ameNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ñañapaʼ eñotatoset añ huetsa Jesús ñeñt̃ nazaretoʼmarneshaʼ. Ñeñt̃ña aporoʼyet̃paʼ allent̃a rranareʼch atet̃ otapan Jesús: —¡Pemuerayeʼchnomna Jesúsochaʼ nam̃a! P̃apaʼ ñeñt̃ep̃ Davidnaʼtarep̃. ");
INSERT INTO ameNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Acheñeneshaʼñapaʼ c̈ha mueneʼ cheʼptareʼtnometña aporoʼyet̃paʼ atet̃ otoset: —Oʼhua pemma. Aporoʼyet̃ñapaʼ ello alla rranareʼterrerr atet̃ oterrerr: —¡Pemuerayeʼchnomnañacaʼye Ayochreshat̃e! P̃apaʼ ñeñt̃ep̃ Davidnaʼtarep̃. ");
INSERT INTO ameNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesúsñapaʼ alla t̃omos atet̃ otosan acheñeneshaʼ: —Sec̈horeʼchñacaʼye onepaʼ arr. Ñetña c̈horeʼchet aporoʼyet̃paʼ atet̃ ochet: —T̃eʼpaʼ c̈hop̃a cosherrtsa, ñapaʼ oʼcaʼye agotosep̃. Petantnoma eʼñe t̃ayecma. ");
INSERT INTO ameNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Eʼñe atet̃ otuetpaʼ c̈ha tantatsa c̈ha aʼmeyanmueʼ allo caʼmap̃naʼtenapaʼ allent̃a ahuoʼ Jesúsesho. ");
INSERT INTO ameNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesúsñapaʼ atet̃ otap̃: —P̃apaʼ ¿esoʼtña pemnen ñeñt̃chaʼ atet̃ nep̃osep̃? Aporoʼyet̃ñapaʼ atet̃ och: —Añcaʼye Maestro nemnen oʼch pecuatnomuen att̃och oʼch cohuen nenterrapa. ");
INSERT INTO ameNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesúsñapaʼ alla otererr: —T̃eʼpaʼ ahuerrep̃ eʼñe peñmañeshaʼ t̃arroʼmar att̃o atarr peyemtapna na ñeñt̃caʼyeña oʼ eʼñe aʼcrraterrep̃. Eʼñepaʼtchaʼ allorocma eʼñe cohuen enterra. Eʼñe cohuerrtsapaʼ c̈ha cot̃aʼnmueʼ ñam̃a Jesús allenet̃ sen. ");
INSERT INTO ameNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Att̃eñapaʼ oʼ c̈hac̈haʼtet allameʼtets Jerusaléño. C̈hapuet aspent̃o ñeñt̃ paʼsoʼcheñ Olivopen. Allñapaʼ alloʼtsen anets ñeñt̃paʼ añ paʼsoʼcheñ Betfagé, poʼpoñpaʼc̈hoʼ alloʼtsen anets ñeñt̃paʼ añ paʼsoʼcheñ Betania. Oʼña c̈hapmochet all anetso, ");
INSERT INTO ameNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jesúsñapaʼ atet̃ otnoman epsheña pueyochreshaʼ: —Sapaʼ oʼch sota oʼch sec̈hap aʼyent̃eyeʼ eʼñe allara anetso. Allñapaʼ allchaʼ sentos ashen rreʼptor all huanquëñet; ñeñt̃paʼ amaʼt puesheñarra acheñ amacaʼye monteñaʼ. Ñeñt̃ña ashenpaʼ oʼch sepyam̃p̃sospaʼ oʼch sanerrnan. ");
INSERT INTO ameNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ñerraʼm eseshaʼ sotapueʼ: “¿Esoʼmareʼt sepyam̃penña ashen?” sañapaʼ atet̃chaʼ sotosanet: “Yepartsesharcaʼye mueneneʼña añ ashen. Mameshapaʼ oʼch alla apuerrsaʼ.” ");
INSERT INTO ameNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Allempoña ñetpaʼ allent̃a ahuanmuet. Oʼña c̈hapuet anetsopaʼ all entoset ashen ehuancaret̃ eʼñe opellrrom̃taʼnot̃eʼtsen all t̃en eʼñe t̃oñot̃. Ñetñapaʼ pueyam̃p̃soset. ");
INSERT INTO ameNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Allempoña puesheñaʼtets ñeñt̃ t̃omc̈haʼtyets allpaʼ atet̃ otapanet: —¿Esoʼt sottenña arr? ¿Esoʼmareʼtchaʼ sepyam̃p̃sosña ashen? ");
INSERT INTO ameNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ñetña atet̃ otapanet Jesúspaʼ atet̃c̈hoʼ otoset. Allempoñapaʼ atet̃ otaret̃tet: —Ñeñt̃epñapaʼ sanercaʼye. ");
INSERT INTO ameNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Allempoñapaʼ allent̃a anerretña ashen Jesúsesho. Nohuerret paʼshtam ashnacheʼñopaʼ Jesúsñapaʼ allent̃a montaʼnmana ashen. ");
INSERT INTO ameNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Shonteʼ acheñeneshaʼ ñetñapaʼ t̃ot̃maʼtyesoñet paʼshtam t̃oño allchaʼ oñem Jesús. Poʼpotantañec̈hnoñapaʼ tsorrmoʼreʼtyeset tsach pueʼmoʼrer allo topanetyeset t̃oñ. ");
INSERT INTO ameNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Allohuen acheñeneshaʼ ñeñt̃ otac̈hetsa ñam̃a ñeñt̃ cot̃aʼhuaneneʼ chentaʼ ñetñapaʼ puerrannarteñot̃etpaʼ atet̃ atarr cohuentatyesneññañetpaʼ atet̃ otenet: —¡Acsherrapoʼch allohueney! ¡Ayeʼchoc̈htaterrapoʼch Jesús ñeñt̃ llesensen Yompor! ");
INSERT INTO ameNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Ayeʼchoc̈htaterrapoʼch Jesús ñeñt̃chaʼ am̃chaʼtaret̃terrtsa! T̃eʼpaʼ oʼcaʼ huerraña yatañ David paʼm̃chaʼtaret̃teña. ¡Ayeʼchoc̈htaterrapoʼch ñam̃a Yompor Parets ñeñt̃ pueʼntañoʼtsen! ");
INSERT INTO ameNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Att̃eñapaʼ c̈hap Jesús Jerusaléñopaʼ allent̃a ahuos Parets paʼpacllo, all beʼt̃osos, cohuaʼyesosan ora allohuen ñeñt̃ alloʼtsaʼyen. Cohuaʼyesueñaʼpaʼ oʼ c̈haʼnerrpaʼ ahuoʼ anetso Betanio allohuen pueyochreshohuen ñeñt̃ c̈harraʼ puechena epsheña t̃arroʼmar allempopaʼ oʼcaʼye ellerren. ");
INSERT INTO ameNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tsapat̃ allempo onac̈haʼtaʼmuenet Betaniot̃, Jesúsñapaʼ cheporraʼnma. ");
INSERT INTO ameNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","All oñenet Jesúsñapaʼ aʼyot̃eñ entosan higoch ñeñt̃ t̃aya oʼ asopanreʼterr. Ñañapaʼ allent̃a ponem̃ya oʼch enteñaʼ ñatoʼ eʼmeret̃t̃eʼ. Oʼña c̈hap allameʼtetspaʼ pasopanrepaʼtchaʼ entosñañ t̃arroʼmar ama c̈henaʼ allempo meʼten. ");
INSERT INTO ameNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesúsña c̈hepaʼtchaʼ eñorostsa higochecop, ñeñt̃paʼ atet̃ otos: —Amaʼt errponañapaʼ amuepaʼch eseshaʼ tsomuerraye añ higoch pueʼmer. Pueyochreshaʼñapaʼ eʼñe eʼmueñet atet̃ eños higochecop. ");
INSERT INTO ameNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Allempo entuanman Jesús higoch allempoñapaʼ oʼ alla c̈hac̈heneterr Jerusaléño. Jesúsñapaʼ beʼt̃osuenerr Parets paʼpacllo, allñapaʼ allent̃epaʼtchaʼ mueñoʼtuosan allohuen ñeñt̃ pomatsreʼtetsa all ñam̃a allohuen ñeñt̃ rañt̃aʼyetsa. Eʼñe c̈haʼnmac̈haʼtatosanet allot̃, aʼcoyeʼtam̃p̃sosanet poʼmesac̈hno allecma cam̃yatyenet poʼc̃llayoret, aʼcoyeʼtuosan ñam̃a allecma anorryen ñeñt̃ pomueneʼ yepec̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Allempo Jesúspaʼ amaʼt puesheñarrot̃a ama muenaterraneto oʼch es oñmatet all Parets paʼpaclloʼmar. ");
INSERT INTO ameNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Allempoña yec̈hatosanetpaʼ ñapaʼ atet̃ otosanet: —Yompor poʼñoñ ñeñt̃ atet̃ anuaret̃ ahuat̃ot̃eñ allñapaʼ atet̃caʼye oten Yompor: “Añ ñeñt̃ nepaquëll nepenpaʼ añecpacaʼyeña sherben allecmach maʼyochennet amaʼt allohuen paʼnamen acheñeneshaʼ.” T̃arraña sañapaʼ eʼñe atet̃ sepeññañña Yompor paʼpaquëll ñerraʼmrrat̃eʼ eñet̃ ñeñt̃ eʼpotyetsa mapuetpono. ");
INSERT INTO ameNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Añña ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar ñam̃a añ ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃, ñetñapaʼ allempo atet̃ eʼmareʼtetpaʼ Jesúsepaʼtchaʼ atarr oʼpatet oʼch muetsatachet. T̃arraña allempopaʼ ama errot̃ peto c̈ha mechaʼnaʼchet t̃arroʼmar allohuen acheñeneshaʼpaʼ atarrcaʼye cosheññañet ñeñt̃ atet̃ yec̈hatenanet, nanac cohuen enteñet. ");
INSERT INTO ameNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Allempoña oʼ ellerrenpaʼ onac̈heneterr Jerusaléñot̃paʼ ahuaneneterr Betanio. ");
INSERT INTO ameNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tsapat̃ña ahuat̃ecma alla oñmaʼmueneterr alloʼtsen higoch. Entueneterrpaʼ oʼ eʼñe hueyaʼhuenaña higoch eʼñe puerc̈hohuen. ");
INSERT INTO ameNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Allempoña Pedro allent̃a yerpana atet̃ eños ellerro Jesús higochecop, ñañapaʼ allent̃a otosan Jesús: —Maestro, pecuaʼ añ higoch ñeñt̃ p̃otnom ellerro amaʼt eseshaʼpaʼ amach tsomuerrñañeto pueʼmer, t̃eʼñapaʼ oʼ hueyaʼhua. ");
INSERT INTO ameNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesúsñapaʼ atet̃ otnomanet: —Sapaʼc̈hoʼña eʼñeñacaʼyeña seyemteraña Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Poʼñoc̈hcaʼ na t̃eʼpaʼ oʼch notas: Ñerraʼm ama c̈hoyeʼ seʼcharrtateno seyoc̈her, ñerraʼm poʼñoc̈h eʼñe seyemteña Yompor, ñachcaʼyeña atet̃ peneʼña ñerraʼm errot̃en es soten. Añeʼnachña eʼñe setsoten ñeñt̃ ello atarr t̃orrapoʼ senten. Oʼch netmaʼntacha atet̃ ñerraʼmrrat̃eʼ añ aspenet̃. Ñerraʼm eseshaschaʼ otets aspent̃ecop “Añ aspenet̃paʼ rrot̃eʼtepaʼch arrot̃, arrepaʼchña eshaʼtoso saʼpo allchaʼ chencosa”, aspenet̃ñapaʼ atet̃chaʼc̈hoʼ p̃onasa. ");
INSERT INTO ameNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Amaʼt allohuen erraʼtsenchaʼ es senam semaʼyocheñot̃, ñerraʼm c̈ho senam eʼñe seyemteñocmañen, ñeñt̃ñapaʼ sagap̃chaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ñam̃a t̃eʼpaʼ oʼch notnomues: Ñerraʼm semaʼyocheñot̃ c̈ho sat̃en ñerraʼm c̈ho seʼmoñeʼteñ poʼpsheñeñ c̈hosach peretnerreʼ seyoc̈hro allorocma, allochñapaʼ Sompor ñeñt̃ entoʼtsen peretnerrnaschaʼ sam̃a ñeñt̃ atet̃ sep̃atseʼtyen ñeñt̃ ama pocteyeʼ enteno ña. ");
INSERT INTO ameNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","T̃arroʼmar ñerraʼm ama sep̃retnannenopaʼ Somporpaʼc̈hoʼña ñeñt̃ entoʼtsen amach peretnerrnaso sam̃a ñeñt̃ atet̃ sep̃atseʼtyen ñeñt̃ ama pocteyeʼ enteno ña. ");
INSERT INTO ameNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Allempoñapaʼ alla c̈hac̈haʼtaʼmueneterr Jerusaléño. Jesúsñapaʼ all chopeñeʼchen Parets paʼpacllo. Allñapaʼ huac̈haʼtoña ñam̃a shonteʼ am̃chaʼtaret̃neshaʼ ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar ñam̃a ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ ñam̃a poʼpotantañ ñeñt̃ pomporneshaʼ p̃aʼyen allohuen judioneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ñetñapaʼ atet̃ otoset Jesús: —Ñehua, yapaʼ añecop yehuena yemneñ oʼch p̃otey ¿errot̃eʼt apuenpetña llesens? ¿Eseshaʼtña p̃apueneʼña llesens att̃ot̃ p̃orrtatyenña ñeñt̃ c̈hocma att̃ecma pep̃aʼyena? ");
INSERT INTO ameNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesúsñapaʼ atet̃ otapanet: —Ñehua, napaʼc̈hoʼña nemneñ oʼch naʼp̃t̃oʼtapas sam̃a amaʼt pat̃rra ñoñets. Ñerraʼm sanaposenchaʼpaʼ napaʼc̈hoʼña att̃ochña notapas nam̃a allot̃ apuennetña llesens ñeñt̃oʼmarña atet̃ nepena. ");
INSERT INTO ameNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Sapaʼc̈hoʼña oʼch sotosen ñeñt̃ atet̃ soct̃apeʼchen sa, ahuañmoʼcha allempo apateʼt̃ Juanañ Yomporecop, ñapaʼ ¿eseshaʼtña llesenseʼ ñatoʼ Yompor amapaʼ acheñat̃eʼ apueʼña llesens? Nemnen oʼch sotosen ñeñt̃ atet̃ soct̃apeʼchen sa. ");
INSERT INTO ameNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ñetñapaʼ eʼñe aʼnahua otannaʼtyeset: —Taʼm errot̃chaʼcaʼye yocht̃eʼ. Ñerraʼm c̈ha yoch Yomporeshot̃caʼye apetña llesens, ñapaʼ c̈hat̃eʼcaʼye otey: “Ñehua, sañapaʼ esoʼmareʼtña ama seʼm̃ñocheña ahuaña allempo serrpareʼtatosan acheñeneshaʼ.” ");
INSERT INTO ameNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Elloña amach yotatsche acheñeshot̃a apet llesens. Ñehua, acheñeneshaʼñapaʼ c̈hat̃eʼ eʼmoñeʼchet am̃chaʼtaret̃neshaʼ t̃arroʼmar acheñeneshaʼpaʼ eʼñe cohuen eñcheteʼt̃ Juanañ ñeñt̃oʼmarña c̈hocma otyeñet ñapaʼ ñeñt̃caʼyeña poʼñoc̈h aʼm̃toseʼ Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ñeñt̃oʼmarña am̃chaʼtaret̃neshaʼpaʼ atet̃ ochet Jesús: —Taʼm yapaʼ amacaʼyeña yeñoteñe; errot̃t̃eʼ huapaña Juanañ, errot̃t̃eʼ apetña ñam̃a llesens. Allempoña Jesúspaʼ atet̃ oterraneterr: —Napaʼc̈hoʼña t̃eʼpaʼ amach notaso sam̃a allot̃ aparet̃en nam̃a att̃ot̃ atet̃ nep̃aʼyena. ");
INSERT INTO ameNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Allempoña Jesúspaʼ alla serrpareʼtaterranerr acheñeneshaʼ tomaʼnteñtso, ñeñt̃paʼ atet̃ otanet: —Eñall puesheñarr acheñ ñeñt̃ nareʼtanatatnomueʼ shonteʼ uvach; paʼmuerñapaʼ eʼñe ora uvachmatatue. Eʼñe conc̈haʼtam̃pesue allot̃ñapaʼ eñan ñam̃a allchaʼ aʼpechoʼtoñet uva poʼñer. Allñapaʼ t̃omatatnoman torrepoʼ allot̃chaʼ cohuam̃p̃soñet paʼmuer. T̃omatuepaʼ naʼnman ñeñt̃chaʼ taruasatats ñeñt̃chaʼ coyerrahuet allpon ñerraʼm esempoch t̃oteñet. ’Oʼña nareʼtanatatuepaʼ oʼ ahuoʼ poʼpoñ anetso b̃ac̈hayo. ");
INSERT INTO ameNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","C̈hap allempo yen uvachllom̃paʼ ñañapaʼ mueñerran poʼpsheñeñ paʼtaruasañer oʼch enamuerraʼ uvachllom̃ poʼpsheñeñ paʼtaruasañreneshesho ñeñt̃ cohuam̃peneʼ uvachmaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Allempoña c̈hen allpaʼ enamosan ñeñt̃ allpon oʼpatena ña, arepaʼtchaʼña es apapuenayeña uvachllom̃, elloña ñeñt̃apaʼ c̈ha rremapueññañet paʼtaruasañerpaʼ oʼ nalleʼtapueñet, oʼ alla mueñoʼteret eʼñe att̃a. ");
INSERT INTO ameNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Allempoña ñeñt̃ pamoʼmteʼ pen uvachmaʼpaʼ oʼ alla mueñerranerr poʼpsheñeñ paʼtaruasañer. Allempo c̈henerr ñam̃a allpaʼ ñapaʼc̈hoʼña c̈ha rrolleʼtapetpaʼ oʼ atserrp̃apueñet poñopaʼ c̈ha es otnatapueñet. ");
INSERT INTO ameNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Allempo oʼ alla mueñerranerr poʼpsheñeñ paʼtaruasañer. Ñeñt̃paʼc̈hoʼña allempo c̈henerr ñam̃a allpaʼ ñañapaʼ c̈hepaʼtchaʼ muetsapueñet. Eʼñe att̃ecma p̃aʼyeset poʼpotantañec̈hno—patantaʼtetspaʼ nalleʼtapueñet, poʼpotantañec̈hnoñapaʼ c̈ha amtsanataret̃tapuenet. ");
INSERT INTO ameNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Ñeñt̃ pamoʼmteʼ penetpaʼ eñallmeñ ñam̃a puesheñarr ñeñt̃ eʼñe ño puechemer ñeñt̃ atarr morrentena. Allempoñapaʼ atet̃ ot: “T̃eʼpaʼ oʼch nemñe all ñeñt̃ eʼñe na nechemer. Ñatoʼrraña ñeñt̃paʼ mechaʼnaʼtapetchaʼ.” ");
INSERT INTO ameNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ñeñt̃paʼc̈hoʼña amaʼt mameshapaʼ arepaʼtchaʼña mechaʼnaʼtapeto. Allempo entapoñet puechemer ñetñapaʼ atet̃ otannaʼtyeset: “Añmapaʼ ñeñt̃caʼyeña puechemer ñeñt̃chaʼ oʼpaterraya pompor puenarem̃ esempo. Ñapaʼc̈hoʼña t̃eʼpaʼ oʼchcaʼye yemtsap̃ allochñapaʼ yachcaʼyeña eʼñe oʼpaterrayaña pompor puenarem̃. T̃eʼpaʼ oʼch ahuey oʼch yemtsap̃ ñam̃a.” ");
INSERT INTO ameNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Allempoña oʼ rremapoñet ñam̃a puechemerpaʼ oʼc̈hoʼ muetsapet, huaporeʼteret allot̃ uvachmot̃. Arrpaʼ allohua atet̃ tomaʼntata Jesús eʼñe ñañeña. ");
INSERT INTO ameNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jesúsñapaʼ atet̃ oterranerr acheñeneshaʼ: —Ñehua, t̃eʼpaʼ oʼch notas, ñeñt̃ pamoʼmteʼ pen ataruasañec̈hnopaʼ amaʼt señoteñeña sa atet̃chaʼ p̃ohuerranet. Ñerraʼm esempoch huerranet, pamoʼmtayetpaʼ aʼcllatuerranetchaʼ, narmetsmaʼñapaʼ oʼch apuerran poʼpotantañ. ");
INSERT INTO ameNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Allempoña Jesúspaʼ atet̃ oterraneterr: —Sapaʼ amaʼt ahuat̃apaʼ amaʼtña selleyareña ñeñt̃ atet̃ anuaret̃ Yompor poʼñoñ ahuat̃ot̃eñ. T̃arroʼmar ñeñt̃paʼ atet̃ oten nocop, all atmaʼntataret̃en mapueʼ. Ñeñt̃paʼ atet̃ oten: Añ mapueʼ ñeñt̃ ama pocteyeʼ entyeno ñeñt̃ t̃omatyeneʼ pocoll, ñeñt̃ña t̃eʼpaʼ oʼ anaret̃terra ñeñt̃chaʼ ello atarr cohuen sherberrets eʼñe atet̃ ñerraʼm quellpach allo eʼñe cohuen echarr orratenet pocoll. ");
INSERT INTO ameNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ñeñt̃paʼ Yomporcaʼyeña atet̃ p̃ateneʼ ñeñt̃oʼmarña yapaʼ eʼñe cohuen yenteñ. ");
INSERT INTO ameNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ñeñt̃ eʼmoñeʼteneʼ Jesús ñetñapaʼ eñoteñet ñeñt̃paʼ ñetcaʼye atmaʼntataret̃tenet, ñeñt̃paʼ ñocpuetcaʼye atet̃ eñorenaña Jesús. Allempoña ñetpaʼ atarr mueneñetañ oʼch rromuet Jesús eʼñe allorocma t̃arraña ama eseshaʼ rromaye t̃arroʼmar ñetpaʼ c̈ha mechaʼteñet acheñeneshaʼ. Ñehua, acheñeneshaʼ eʼñecaʼye cohuen enteñet Jesús. Ñeñt̃oʼmarña ñetñapaʼ quec̈hpaʼhuaneret Jesúspaʼ ahuanerret. ");
INSERT INTO ameNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Att̃eñapaʼ c̈hap allempo poʼpocheño eʼñe aʼnahua mueñeññañet puesheñaʼtets fariseoneshaʼ ñesho ñam̃a puesheñaʼtets Herodes pueyochreshaʼ, t̃arraña ñetpaʼ añecpa amñaret̃tenet att̃och eʼñe pueshquëñot̃et poʼñoñot̃etpaʼ oʼch eñoratoset ñeñt̃ ama cohuenayaye. Allochñapaʼ att̃ot̃chaʼña otteñeʼchet. ");
INSERT INTO ameNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ñeñt̃oʼmarña ñetpaʼ allempo c̈hapuet ñeshopaʼ atet̃ otoset: —Maestrochaʼ yapaʼ yeñotenep̃ p̃apaʼ ama peshquëno amaʼt mamesha ñam̃a ñeñt̃ att̃o peyc̈haten Yompor poct̃ap̃ña ñeñt̃paʼc̈hoʼña eʼñe cohuenacma, ama shequëñtsoyaye amaʼt mamesha. P̃apaʼ allohuen acheñpaʼ eʼñe cohuen pentueñ; ama aña ñapuet̃ pemorrenteno ñeñt̃ atarr am̃chaʼnaʼtpoʼ entyen allohuen acheñeneshaʼ. Ñeñt̃oʼmarña t̃eʼpaʼ yapaʼ yemneñ oʼch peñotatapuey erraʼtsent̃eʼña eʼñe poʼñoc̈h cohuentetsa. ¿Pocteʼt̃eʼ penteñña p̃a oʼch yetsaʼta impuestos añecop ñeñt̃ am̃chaʼtaret̃tetsa all anetso Romo ñeñt̃ ama judioneshayaye? Ñatoʼ amat̃eʼ pocteyayeña yocop ñeñt̃ey judioneshay oʼch yetsaʼcha am̃chaʼtaret̃ romoʼmarneshaʼ ñeñt̃ ama judioneshayaye. ");
INSERT INTO ameNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesúsñapaʼ eñotapanet ñetpaʼ c̈hacaʼye shecareʼteñet, ñañapaʼ atet̃ otapanet: —Sapaʼ esoʼmareʼtña semneñña oʼch seshcareʼtosen. Ñehua, amaʼt atet̃ setpatennoñpaʼ sorrtatcaʼyeña puetallarr quelle oʼch necueʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ñetña apetpaʼ ñañapaʼ atet̃ oterraneterr: —Ñehua, sapaʼ oʼch soten, ¿eseshaʼt sentenña ñeñt̃ atmaʼntataret̃tetsaña all? ¿Eseshaʼt paʼsoʼcheñ aquellcaret̃tetsa all? Ñetñapaʼ atet̃ ochet: —Am̃chaʼtaret̃caʼye atmaʼntaret̃tetsaña all, ñocaʼyeña paʼsoʼcheñ ñeñt̃ aquellcaret̃tetsa all. ");
INSERT INTO ameNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesúsñapaʼ alla oterraneterr: —Ñeñt̃epñapaʼ añ poctetsa oʼch yap̃ am̃chaʼtaret̃ ñeñt̃ ño ñeñt̃ atet̃ poctetsa gobiernocop, t̃arraña ellonet̃ña ñeñt̃ Yomporo oʼch yap̃ ñam̃a ñeñt̃ atet̃ poctetsa ñocop. Ñeñt̃ña shequënayeñ att̃a cohuanrrorteñet t̃arroʼmar Jesúspaʼ atarrcaʼye cohuen anapuenanet. ");
INSERT INTO ameNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Allempoñapaʼ huac̈haʼtoña ñam̃a patantarr ñeñt̃ saduceoneshatets. Ñehua, ñeñt̃ saduceoneshatets ñetñapaʼ ellonet̃ echenet poct̃ap̃ña ñeñt̃oʼmar atet̃ otenet amat̃eʼ errot̃enot̃ yetanterroña rromot̃ amaʼt errponaña. Ñetñapaʼ atet̃ otoset Jesús: ");
INSERT INTO ameNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maestrochaʼ ahuat̃ Moiséspaʼ atet̃ quellconay ñoñets ñeñt̃ poctetsa ñeñt̃chaʼ atet̃ yep̃a. Ñeñt̃paʼ atet̃ otenña Moisés poʼñoñ: Ñerraʼm esempo rroma yacma oʼch saʼnman puet̃apor t̃arraña ama chemereʼtnomopaʼ, añ poctetsa paʼmoʼnasheñchaʼ alla yorerreʼña poʼnorrar allochñapaʼ att̃och eñalleterraña ñeñt̃chaʼ puechemer perr paʼmoʼnasheñeñ. Ñeñt̃paʼ atet̃caʼye quellcaʼnmonayña Moisés ahuat̃. ");
INSERT INTO ameNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ñehua, t̃eʼpaʼ eñall canc̈herrsheña ñeñt̃ eʼñe poctacma paʼmoʼnasheñecmuet. Ñeñt̃ puesheñarr popoʼnaretpaʼ oʼ yoran coyaneshaʼ ñeñt̃ puet̃apor p̃aʼ. Eʼñe allponmatatsapaʼ oʼ rromaña, yacma ama chemereʼtnomo. ");
INSERT INTO ameNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Allempoña ñeñt̃ poʼrroc̈hoʼmerpaʼ oʼ yorerran paʼmoʼnasheñeñ puet̃apor. Eʼñe allponmatatsapaʼ ñapaʼc̈hoʼña oʼ rromuerrerr ñam̃a, ñeñt̃paʼc̈hoʼña ama chemereʼtnomo. Allempoña poʼpsheñeñ paʼmoʼnasheñpaʼ oʼ alla yorerranerr ñam̃a poʼnorrar. Eʼñe allponmaterrtsapaʼ ñapaʼc̈hoʼña oʼ rromuerrerr ñam̃a ñeñt̃paʼc̈hoʼña ama chemereʼtnerrerro oʼ att̃a rromuerrerr. ");
INSERT INTO ameNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Eʼñe att̃ecma p̃ohuet canc̈herrsheñoʼmaretpaʼ eʼñe pueyoruarochet ñeñt̃ara puesheñarr coyaneshaʼ. Eʼñe allohuenetpaʼ eʼñe att̃ecma pet rromayestset amaʼt puesheñarrot̃etapaʼ ama chemereʼtnomueto. Oʼ rromapesuaña canc̈herrsheñoʼmar puerrollareshaʼpaʼ c̈ho rromatsña ñam̃a coyaneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","T̃eʼña ñerraʼm poʼñoc̈ht̃eʼ yetantena rromot̃paʼ añña coyaneshaʼ allempoñapaʼ ¿eseshaʼtchaʼña puet̃apor perreʼ t̃arroʼmar allohuenet canc̈herrsheñoʼmaretpaʼ eʼñe pueyoruarochet? ");
INSERT INTO ameNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Allempoña Jesúspaʼ atet̃ oterraneterr: —Sapaʼ ñeñt̃oʼmarcaʼyeña c̈ha atarr sepanteñ t̃arroʼmar amacaʼye c̈hennasoña seyoc̈hro ñeñt̃ eʼñe poʼñoc̈h atet̃ yec̈hateney Yompor poʼñoñ ñeñt̃ atet̃ anuaret̃ ahuat̃ot̃eñ. Ñam̃a aña sepantateneʼ t̃arroʼmar sapaʼ ama sepocteññañe Yompor poʼhuamenc. ");
INSERT INTO ameNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","T̃arroʼmar esempohuañen allempoch tanterret poʼpocheño, allempopaʼ amaʼt puesheñarrot̃eta amach senaʼterreto, amaʼt coyaneshaʼpaʼc̈hoʼ amach eseshayeʼ apuerraye ñeñt̃chaʼ yorerrahuet. T̃arroʼmar allempopaʼ eʼñech att̃et ñerraʼm Yompor poʼm̃llañot̃eñnaneshar ñeñt̃ pueʼntañoʼtsaʼyen. ");
INSERT INTO ameNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Sapaʼ amaʼtña selleyareña ñeñt̃ atet̃ quellquëʼt̃ ahuat̃ Moisés att̃och señoch amaʼt ñeñt̃ oʼ collaʼhuapaʼ ñetñapaʼ corretseta. Ñehua, all aquellcaret̃ tsachmoʼr ñeñt̃ eʼñe ñot̃a huortets. Allot̃ñacaʼyeña Yomporpaʼ eñoranaʼtanaña Moisés; ñeñt̃paʼ atet̃caʼ otña Yompor allempo: “Napaʼ ñeñt̃en Poʼyomporer pen Abraham ñam̃a Isaac, ñam̃a Jacob.” ");
INSERT INTO ameNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Jesúsñapaʼ alla oterraneterr: —Ñehua, yapaʼ yeñoteñ Yomporpaʼ ama añeyeʼ Poʼyomporer penaye ñeñt̃ rromuets eʼñe poctacma, ñapaʼ añcaʼyeña Poʼyomporer peneʼ acheñ ñeñt̃ corretsach. Att̃oña Yomporpaʼ eʼñe allameʼttsa entenanet allohuenet ñetñapaʼ bet̃tetseta. Ñeñt̃oʼmarcaʼyeña sapaʼ atarr sepanteñ. ");
INSERT INTO ameNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Allempoña huapoña ñam̃a puesheñarr ñeñt̃ etsoteneʼ ñoñets ñeñt̃ atet̃ anaret̃, ñañapaʼ eʼmosan ñeñt̃ atet̃ aʼp̃t̃oʼtareʼteñet Jesús. Ñañapaʼ eʼmosan Jesús eʼñe cohuen anapuenanet. Ñeñt̃oʼmarña ñapaʼc̈hoʼña allent̃a aʼp̃t̃oʼtos, ñeñt̃paʼ atet̃ otos: —¿Erraʼtsenaʼt ñoñtsor ñeñt̃ atet̃ anaret̃ ñeñt̃ atarr sherbets, ñeñt̃ ello metanaʼtueneʼ ora allohuen poʼpoñec̈hno ñoñets ñeñt̃ eʼñe parro att̃ecma anuaret̃ ahuat̃ot̃eñ? ");
INSERT INTO ameNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesúsñapaʼ atet̃ otap̃: —Ñeñt̃ ñoñtsor ñeñt̃ atarr sherbets ñeñt̃ ello metanaʼtueneʼ poʼpoñec̈hno ñoñetspaʼ ñeñt̃paʼ atet̃ oten: “Seʼm̃ñot israelneshachaʼ att̃och señoch: Ñeñt̃ Yeyomporer yepenpaʼ ñapaʼ eʼñecaʼye pat̃rra ñeñt̃ Yepartseshar yepen. ");
INSERT INTO ameNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ñeñt̃oʼmarña atarrepaʼchña yemorrenteña Yeyomporer ñeñt̃ Yepartseshar yepen eʼñe ora yeyoc̈hrocmañen. Ñam̃a eʼñe yecamquëñot̃ yemorreñchach, ñam̃a yoct̃ap̃ñohuen, amaʼt ñam̃a eʼñe ora yehuamencohuen.” ");
INSERT INTO ameNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Allot̃paʼ poʼpoñ ñoñets ñeñt̃ atarr sherbets ñeñt̃paʼ atet̃ oten: “Atarrchaʼ yemorrenteña yamoʼts eʼñe atet̃ atarr yemorrentena yañeña.” Añ epoʼmar ñoñetspaʼ ñeñt̃caʼyeña atarr sherbets, ñeñt̃ña ello metanaʼtueneʼña poʼpoñec̈hno ñoñets ñeñt̃ atet̃ anaret̃. ");
INSERT INTO ameNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Allempoña ñeñt̃ etsoteneʼ ñoñets ñeñt̃ atet̃ anaret̃, ñañapaʼ atet̃ oterranerr Jesús: —Maestrochaʼ p̃apaʼ eʼñecaʼye poʼñoc̈h atet̃ p̃oten. Poʼñoc̈h Yomporpaʼ eʼñecaʼye pat̃rra ama eñalleña poʼpoñ Yeyomporer pat̃rracaʼye. ");
INSERT INTO ameNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ñerraʼm c̈hoch yemorrenteña Yompor eʼñe yeyoc̈hrocmañen eʼñe yeñoteñohuen, ñam̃a eʼñe yecamquëñot̃ yemorreñchach eʼñe yehuamencohuen ñam̃a ñerraʼm atarr yemorrenteña ñam̃a yamoʼts eʼñe atet̃ atarr yemorrentena yañeña, ñeñt̃caʼyeña atarr nanac sherbets. Ellocaʼyeña metanaʼtuenan allohuen poʼpoñec̈hno amaʼt ayarrac̈hno ñeñt̃ yemtsayen Yomporecop, amaʼt ñam̃a allohuen ñeñt̃ yachamuen allo yesherbeñ Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesúsñapaʼ atet̃ eñch ñapaʼ atarr eñotenan ñeñt̃ atarr sherbets Yomporecop, ñeñt̃oʼmarña atet̃ otererr: —P̃apaʼ amacaʼye atarr atonayeʼ pepallteno att̃och eʼñe p̃agaphuerrñañ Yompor poʼcohuenña att̃o ayochreshat̃tena ña. Allempoñapaʼ amaʼt puesheñarrot̃etapaʼ ama eseshayeʼ aʼp̃t̃oʼtenayeʼ enterrayeña Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Allempoña Jesúspaʼ alla yec̈haterraneterr all Parets paʼpacllo. Ñeñt̃paʼ atet̃ oterraneterr: —Ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃, ñetpaʼ esoʼmart̃eʼña otyenet ñeñt̃chaʼ Cristotosets ñapaʼ aña poʼm̃reneñ peneʼ David t̃arroʼmar ñeñt̃chaʼ Cristoterrets ama aña poʼm̃reneñ peneʼ David t̃arroʼmar ñapaʼ Poʼpartseshareʼnaña peʼt̃ David. ");
INSERT INTO ameNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","T̃arroʼmar amaʼt Davidpaʼ allempo eñoracheʼt̃ Parets Puecamquëñ, allempopaʼ atet̃caʼye eñoseʼt̃ña añecop ñeñt̃chaʼ Cristoterrets: Yompor Parets atet̃ otennan ñeñt̃ Nepartseshar nepen na (ñeñt̃ara ñeñt̃chaʼ Cristoterrets): “Teʼpaʼ oʼch p̃anorruerr arr necohuenrot̃ allchaʼ pecohuentapreterrna. Att̃ochña amaʼt ñeñt̃ peʼmoñeʼteneʼ napaʼ oʼch nameʼñatuerranet allochñapaʼ oʼch atet̃ perret ñeñt̃ pemnen p̃a.” ");
INSERT INTO ameNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ñeñt̃paʼ atet̃caʼye oteʼt̃ña David, ñeñt̃chaʼ Cristoterretspaʼ ñeñt̃caʼyeña Poʼpartseshar peʼt̃ña amaʼt allempot̃eñ. Ñehua, amaʼt señoteñeña Cristo ñeñt̃ Poʼpartseshar peʼt̃ Davidpaʼ ñeñt̃ña t̃eʼpaʼ oʼ alla poʼm̃renñ per ñam̃a. Ñeñt̃oʼmarña Jesús allempo yec̈hatenan shonteʼ acheñeneshaʼ ñetpaʼ eʼñe pocsheñeshaʼ eʼm̃ñoteñet. ");
INSERT INTO ameNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","All yec̈haterraneterr ñeñt̃paʼ atet̃ oterraneterr: —Amach semeñeʼtapretatsche ommoñat̃eneshaʼ poct̃ap̃ña ñeñt̃areta ñeñt̃et atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃. T̃arroʼmar ñetpaʼ añeʼnaña atarr cohuen entenet oʼch chorrenet atarrom shetamuets oʼch att̃a yormaʼtatseʼtenet paʼshtam. Ñam̃a pommoʼcheñot̃etpaʼ atarrchaʼ mueneñet oʼch eʼñe puem̃chaʼnaʼteñot̃ eʼñech cohuen huom̃chaʼtenanet acheñeneshaʼ all chopeñeʼchyenet. ");
INSERT INTO ameNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ñam̃a ñetpaʼ añeʼnach atarr muenenet oʼch anorrc̈haʼtyenet judioneshaʼ poʼprahuo allecma anorryen ñeñt̃ atarr am̃chaʼnaʼtpoʼ entyen allohuen acheñeneshaʼ ñam̃a eʼñe att̃ecma penet ñam̃a all rrallmeʼchapretenet. ");
INSERT INTO ameNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","T̃arraña ñetñapaʼ rret̃orrnaneshaʼnaña puerratam̃pesyenetña paʼpaquëll. Elloña eʼñe pommoʼcheñot̃etpaʼ aña atarr muenenet oʼch atet̃ penet ñerraʼmrrat̃eʼ ñetpaʼ atarr cohuen acheñret ñeñt̃oʼmarña arr maʼyochyenet all shontena acheñeneshaʼpaʼ amach t̃ematenayaya maʼyocheneto. Ñeñt̃oʼmarña t̃eʼ napaʼ oʼch notas ñeñt̃ atet̃ petsa pommoʼcheñot̃ elloña atarrchaʼ aʼcoñchaʼtaret̃terret. ");
INSERT INTO ameNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Allempo Jesúspaʼ alla anen aʼyent̃eyeʼ allecma naʼyenet quelle Parets paʼpacllo. Allñapaʼ shonteʼ entenan acheñeneshaʼ ñeñt̃ naʼyeneʼ quelle Partsocop, shonteʼ ec̃llayoret̃eneshaʼ ñeñt̃ naʼyeneʼ shonteʼ poʼc̃llayor Partsocop. ");
INSERT INTO ameNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Jesúsña allpaʼ att̃a cohuenanet, huapa ñam̃a puesheñarr rret̃orrnaneshaʼ ñeñt̃ atarr huocchañetets. Ñapaʼc̈hoʼña nosan eptallat̃oll quellayet̃oll ñeñt̃ cobretall, ñeñt̃ quellayerpaʼ ama tsaʼteno, ama es sherbeno. ");
INSERT INTO ameNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Allempoña Jesúspaʼ agotan pueyochreshaʼpaʼ atet̃ otanet: —T̃eʼpaʼ oʼch notas, añ rret̃orrnaneshar amaʼt atarr huocchañpaʼ ñapaʼ poʼñoc̈hcaʼye atarr aton nosan quelle, ello metanaʼtuosan allohuen poʼpotantañec̈hno allpon quelle ñeñt̃ naʼyenet ñet. ");
INSERT INTO ameNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","T̃arroʼmar allohuenet ñeñt̃ naʼyenet quellepaʼ añacaʼye naʼyenet ñeñt̃ aʼpchaʼtyenet, ñañapaʼ amaʼt atarr huocchañpaʼ eʼñe pomhuahuospan allohuen ñeñt̃ echyen ñeñt̃ muenatenaneñ att̃och yoran alloch correna arr patsro. ");
INSERT INTO ameNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Allempo c̈haʼnerrerr Jesús Parets paʼpacllot̃ puesheñarrña pueyochreshaʼpaʼ atet̃ och: —Maestro, pecuayeʼch, atarruacaʼ coc̈hneshaʼt̃eʼ mapyet ñeñt̃ allo orratyenet Partsopoʼ, atarr coc̈hneshac̈hnot̃eʼ Parets paʼpacllec̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesúsñapaʼ atet̃ och: —Amaʼt sentyeñ t̃eʼ ñeñt̃ atarr coc̈hneshareʼ pocollec̈hno t̃arraña esempopaʼ c̈herrchaʼ allempoch eʼñe aʼmataʼtaret̃etuerra. Amaʼt eʼñe puem̃arra mapyetpaʼ amach aʼpuerroña all allo orratenet Partsopoʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Allempoña ahuenerr Olivop̃nopaʼ anorruenerr all, eʼñe alla yot̃ Parets paʼpacllot̃. Allempo anen all eʼñe ñapt̃ochayet allpaʼ aña epuet Pedro ñam̃a Jacobo ñam̃a Juan ñam̃a Andrés. Ñetñapaʼ atet̃ oteñet: ");
INSERT INTO ameNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—T̃eʼpaʼ yemneñ oʼch p̃otey, ¿esempoʼtchaʼña atet̃ perra? Ñam̃a allempopaʼ ¿esoʼtchaʼña yentyerr ñeñt̃chaʼ yeñotaterreʼ poʼñoc̈hpaʼ oʼch c̈herrmoch allempoch eʼñe etsotuerra ñeñt̃ atet̃ p̃oteney t̃eʼ? ");
INSERT INTO ameNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesúsñapaʼ atet̃ otanet: —Eʼñech señoterra allochñapaʼ amach eseshaʼ seshquërraye. ");
INSERT INTO ameNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","T̃arroʼmar shonteʼch orrterrtsa ñeñt̃chaʼ ayc̈haʼnataterreʼ nesoʼcheñ, ñeñt̃chaʼ otyerrets: “Napaʼ ñeñt̃encaʼyeña Cristotets.” Ñetñapaʼ shonteʼch shequëret acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Ñam̃a allempoña sapaʼ seʼmareʼtyerrchaʼ oʼ quellareñtsotyerr allampañoʼmar, ñam̃a seʼmareʼtyerrchaʼ oʼ quellareñtsotyerra ora errap̃aren anetsoʼmar. Saña allempopaʼ amach c̈ha seyorenatsto amaʼt eʼñe mamesha. Ñeñt̃paʼ atet̃chaʼcaʼye eʼñe poʼñoc̈h perra. T̃arraña allempopaʼ amach c̈henaʼ allempoch eʼñe mellapoterra. ");
INSERT INTO ameNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Paʼnamen acheñ ñeñt̃ eʼñe poʼpoñeʼttsocma mereñtsoretpaʼ ñetpaʼ quellarannaʼterretchaʼ. Ñam̃a paʼnamen anetsot̃ am̃chaʼtaret̃ec̈hnopaʼ quellaraterranchaʼ pueyochreneshac̈hno. Pellaʼyerrach pats ora errap̃aren. Orrterrach allemeñ muec̈heñets oʼch eʼñe chaporrñatsotyerr errap̃aren. Orrterrach ñam̃a at̃pareʼteñtsoc̈hno att̃ochña atarrchaʼ amaʼtoc̈htatannaʼterret. Ñeñt̃ atet̃ oʼ notuas t̃eʼpaʼ ñeñt̃ña allempopaʼ ñeñt̃chaʼña ñanom mueroc̈htaterrahuetña allempo. ");
INSERT INTO ameNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Sapaʼ señotaʼt̃ach allempoch atet̃ perrset. Sanmaret̃terrach am̃chaʼtaret̃esho allchaʼ otteñeʼcherrset. Sashtaret̃terrach all judioneshaʼ poʼprahuoʼmar. Eʼñe sameʼñeñot̃en na sapaʼ c̈hapaterrsetchaʼ am̃chaʼtaret̃nesheshoʼmar ñam̃a alloʼtsaʼyen ñeñt̃ nanac am̃chaʼtaret̃neshaʼ; sapaʼ allchaʼ saʼmet̃osnanña neñoñ. ");
INSERT INTO ameNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ñam̃a allempoch ama mellapoterraʼpaʼ añ cohuen ñoñets alloch sequeshperra ñeñt̃chaʼ ñanom serrpareʼtatyeretña allohuen paʼnamen acheñeneshaʼ ora errap̃aren allohuanen añe patsro. ");
INSERT INTO ameNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ñam̃a allempoch sanmaret̃etyesa allchaʼ otteñeʼcherrset amaʼt mameshapaʼ amach c̈ha sellcaʼp̃satsto, amach sotap̃saʼtatsto errot̃uachcaʼye notost̃eʼ am̃chaʼtaret̃esho allempoch aʼp̃t̃oʼtareʼtapuen. Allempopaʼ añchaʼña seʼñoratoseʼ Parets Puecamquëñ. Att̃ochña amach eʼñe sot̃ayeʼ seʼñoroso, añchaʼña seʼñoratoseʼ Parets Puecamquëñ. ");
INSERT INTO ameNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Allempoch atet̃ perrsetpaʼ ñeñt̃ eʼñe semoʼnasheñ sepen ñatoʼ ñeñt̃achcaʼye sepomuerreʼ att̃och muetsaterres t̃arroʼmar ñapaʼ amacaʼye ameʼñenno. Amapaʼ ñatoʼ pomporpaʼ oʼch pomuerran ñam̃a puechemer. Amaʼt ñam̃a puechemerpaʼ ñatoʼ pat̃parñot̃paʼ oʼpaterranach pamoʼmteʼ att̃och muetsatater. ");
INSERT INTO ameNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Shonteʼch acheñeneshaʼ ñeñt̃chaʼ seʼmoñeʼterreʼ t̃arroʼmar sapaʼ nacaʼye eʼñe sameʼñena. Amaʼtchaʼ atarr mueroc̈htaterrsetpaʼ t̃arraña eseshaʼch eʼñe ahuantaʼhuanmueʼ eʼñe pueyemteñot̃en na, ñeñt̃chaʼña aʼqueshp̃ataret̃terrtsa. ");
INSERT INTO ameNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Ñehua, ahuat̃ Daniel ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ, ña poʼquellcopaʼ atet̃ oteʼt̃: “C̈herrchaʼ allempo amaʼt ñeñt̃ ama masosyayeʼ enteno Yomporpaʼ ñeñt̃ñapaʼ c̈herrchaʼ all amaʼt ñeñt̃ eʼñe Partsocpa anaret̃eñ. Ñeñt̃paʼ ñeñt̃achcaʼyeña eʼñe aʼchencatuerrahuet.” Ñehua, ñeñt̃chaʼ lleyerreʼ añ ñoñetspaʼ ñetñapaʼ eñoteretepaʼch. Ñeñt̃oʼmarña ñerraʼm esempoch senter oʼ c̈herr all ñeñt̃ ama pocteyaye allempoña ñeñt̃ allpon Judeoʼtsaʼyen ñetñapaʼ allorocmuepaʼch yetrraʼterret, ahuanerretepaʼña aspent̃areronet̃. ");
INSERT INTO ameNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Atet̃ ñerraʼmrrat̃eʼ puesheñaʼtets ñatoʼ ñetña allempopaʼ enoʼtsaʼyenetchaʼ paʼpacllato, ñetñapaʼ sohuetepaʼchña t̃ecma t̃arraña amachña beʼt̃osatsetnomuetoña poʼponreto att̃och yoratsreʼtnomuet. ");
INSERT INTO ameNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ñam̃a puesheñaʼtets ñeñt̃ paʼmroʼtsenpaʼ allempoña ñetpaʼ amachña onatsterreto att̃och erretaʼ paʼshtamuet. ");
INSERT INTO ameNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Allempopaʼ atarrchaʼ llequëñets añecop ñeñt̃ ac̈homenareʼ coyaneshaʼ ñam̃a ñeñt̃ allohuen emaret̃et̃olleshac̈hno. (T̃arroʼmar ñocpuetpaʼ atarr t̃orrapoʼ att̃och yetrraʼtet ñamet.) ");
INSERT INTO ameNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ñam̃a Yomporchaʼña semaʼyocha allochñapaʼ amach c̈ha huapoto allempoch seyeta. ");
INSERT INTO ameNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Allempopaʼ orrterrach mueroc̈hteñets ñeñt̃chaʼ atarr mueroc̈htaterreʼ allohuen acheñeneshaʼ. Ñeñt̃ amaʼt ahuat̃apaʼ ama puemueroc̈htareto atet̃ atarr nanac huomenc, amaʼt allempot̃eñ eʼñe errteʼ yec̈hcatyeneʼ Yompor allohuen paʼnamen ñeñt̃ yentyen arr patsro. Allempoña ellopaʼ amach atet̃ alla mueroc̈hterreteʼt̃e amaʼt errponaña. ");
INSERT INTO ameNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Allempoch atarr amueroc̈htataret̃terret. T̃arraña allempoña Yomporpaʼ ñach oterrets “t̃eʼpaʼ allohuach.” Ñerraʼm amach oto allohuachpaʼ allempoña amaʼt puesheñarrapaʼ amach eseshaʼ queshperrtso. T̃arraña ñeñt̃ña ameʼñenaya ña ñeñt̃ acrenpaʼ ñocpuetñapaʼ oterrchaʼ “t̃eʼpaʼ allohuach.” ");
INSERT INTO ameNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Ñehua, allempoch orameñ mueroc̈hteñetspaʼ ñerraʼm eseshaʼ soteʼ: “Secueñaʼ, arroʼtsencaʼyeña Cristo”, amapaʼ oʼch otaset: “Secueñaʼ t̃arroʼtsencaʼye Cristo”, sañapaʼ amach sameʼñatstaneto. ");
INSERT INTO ameNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Orretyerrachcaʼye ñeñt̃chaʼ otyerrets ñapaʼ ñoʼña Cristotets. T̃arraña ñeñt̃paʼ att̃achcaʼye shecareʼtyerranña acheñeneshaʼ. Orretyerrach ñam̃a ñeñt̃chaʼ otyerrets ñapaʼ ñoʼña aʼm̃teneʼña Yompor poʼñoñ, t̃arraña ñeñt̃paʼc̈hoʼña eʼñech att̃ecma shecareʼtyerran acheñeneshaʼ, amachña Yomporeyeʼña poʼñoñ aʼm̃teno. Ñeñt̃chaʼ atet̃ shecareʼtyerrets, ñetñapaʼ orrtatyerretchaʼ ñeñt̃ amaʼt ahuat̃a acheñeneshaʼpaʼ ama puentare, att̃ochña cohuanrrortateretña acheñeneshaʼ. Amaʼt ñeñt̃ Yompor paʼcrarnesharpaʼ mueneñetañchaʼ ñeñt̃eʼnachña shequërret. ");
INSERT INTO ameNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Señochepaʼch amaʼt ama c̈henaʼ mueroc̈hteñtsopopaʼ na allohuenpaʼ oʼ eʼñe notuas. ");
INSERT INTO ameNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Oʼchña huañerr ñeñt̃ mueroc̈hteñetspaʼ allempoñapaʼ c̈hoch mayerrets ñam̃a atsneʼ. Arrorrpaʼc̈hoʼña oʼhuañchaʼ atsnom. ");
INSERT INTO ameNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Rantoc̈hnopaʼc̈hoʼña shorc̈haʼterrchaʼ entot̃. Ñam̃a ñeñt̃ huomenc orraʼyetsa ento t̃eʼ allempoña amaʼt ñeñt̃paʼ pellaʼyerrach. ");
INSERT INTO ameNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Allempoñapaʼ entapuerrnetchaʼ na Ñeñt̃en Acheñetosets oʼch nesuam̃perra osot̃ eʼñe nepartsoteñohuen eʼñe necohuenteñeshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nemñerchaʼ nem̃llañot̃eñnaneshar, ñetñapaʼ aʼyapac̈haʼhueretchaʼ allem̃at̃eñ ñeñt̃ acren Nompor nocop eʼñech paʼtatsshem̃toʼmarohuen allot̃ecma orrnotena. Eʼñech allem̃at̃eñpaʼ aʼyapac̈haʼhueretchaʼ eʼñe allohuanen añ patsrot̃. ");
INSERT INTO ameNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Ñam̃a t̃eʼpaʼ señochepaʼch ñeñt̃ atet̃ pena higoch. Ñehua, esempoch senteñ higoch oʼch emc̃achyen puetacret̃olleshaʼ allot̃chaʼ oʼch alla tapnaʼtyerrerr pasopaner, sañapaʼ ñeñt̃aña señotateneʼña oʼ c̈henmoch allempoch huorateterrerr. ");
INSERT INTO ameNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Att̃ecmach perra ñerraʼm esempoch sentyerr ñam̃a ñeñt̃ allponoʼ notuas, sapaʼ ñeñt̃chaʼña señotaterreʼ poʼñoc̈h oʼcaʼye c̈herrmoch allempoch eʼñe etsotuerra, oʼcaʼye eʼñe allameʼttsamerra. ");
INSERT INTO ameNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Napaʼ poʼñoc̈h oʼch notas, acheñeneshaʼ ñeñt̃ eʼñe corretsa t̃eʼ ñetña amach eʼñe rromhuenetaʼpaʼ allempocmach eʼñech etsoterra allohuen añec̈hno. ");
INSERT INTO ameNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Esempohuañen añ enet ñeñt̃ senten t̃eʼpaʼ eʼñech chencaʼhuerra; patspaʼc̈hoʼña att̃ecmach perra eʼñech chencaʼhuerra. T̃arraña naña neñoñpaʼ amach chenquërro amaʼt eʼñe ahuat̃a. ");
INSERT INTO ameNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’T̃arraña ñeñt̃ yet̃roch nohuerrapaʼ ñeñt̃ñapaʼ ama eseshayeʼ eñotenaye. Amaʼt erroʼtsent̃eʼ atsneʼ amaʼt erroʼtsen tsapro ñeñt̃paʼ amaʼt mellañot̃eñneshaʼ ñeñt̃ pueʼntañoʼtsaʼyen ñetpaʼc̈hoʼña amaʼt puesheñarrot̃etapaʼ amaña eseshayeʼña eñotenaye allempoch nohuerrerr poʼpocheño. Amaʼt na ñeñt̃en Yompor Puechemeren napaʼc̈hoʼña t̃eʼpaʼ ama neñoteñe, ñapt̃aña Nompor Parets eñoteneʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Sapaʼ señotaʼt̃ach ñam̃a c̈hocmach señoseʼrtenna ñam̃a c̈hocmach semaʼyochena t̃arroʼmar sapaʼ amaña señoteñe esempoch c̈herr ñeñt̃eñpo allempoch nohuerra. ");
INSERT INTO ameNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ñeñt̃paʼ eʼñe atet̃ ñerraʼmrrat̃eʼ puesheñarr yacma ñerraʼm esempo ta b̃ac̈hayopaʼ oʼch naʼnman paʼtaruasañrec̈hno paʼpacllo ñeñt̃chaʼ apaʼyesnom taruas eʼñe puesheñaʼttsocmuet. Ñam̃a poʼpoñ paʼtaruasañer ñeñt̃chaʼ cohuets yetarrot̃ ñapaʼ atet̃chaʼ otnom̃ pamoʼmteʼ: “P̃apaʼ c̈hocmach peñoseʼretna.” ");
INSERT INTO ameNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ñeñt̃oʼmarña t̃eʼpaʼ oʼch notas: C̈hocmuepaʼch señoseʼrtenna na ñeñt̃en Samoʼmteʼ sepen ñeñt̃en senaʼnmueʼ na nepacllo t̃arroʼmar sapaʼc̈hoʼña ama señotenno esempoch nohuerra. Ñatoʼ ellerronet̃chaʼ nohuena, ñatoʼ rroc̈h tsapo, ñatoʼ puetarenmoch allempo eñen atollop, amapaʼ ñatoʼ aromtañach nohuena. ");
INSERT INTO ameNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Oʼch alla noterrserr: C̈hocmuepaʼch señoseʼrterrna, ñerraʼm machayot̃a nohuerrapaʼ ñatoʼrraña alla nentuerres sapaʼ c̈ha atarr semanrren. ");
INSERT INTO ameNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ñeñt̃ atet̃ notenes sa ñeñt̃paʼ allohuenacpascaʼye, ñeñt̃oʼmarña oʼch alla noterrserr: C̈hocmuepaʼch señoseʼrterrna allohuenes. ");
INSERT INTO ameNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Epomtameñ palltena oʼch alla c̈herrerr pascuapo allempoch rrerranerr judioneshaʼ pan ñeñt̃ ama anaret̃eyaye chaseʼ. Ñeñt̃ña paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar epuet ñam̃a ñeñt̃ etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃, ñetñapaʼ aña atarr eʼnenet att̃och shequët Jesús eʼñe aʼnahua eshecchaʼ rremuetpaʼ oʼch muetsatachet. ");
INSERT INTO ameNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ñetñapaʼ otannaʼtyenet: —T̃arraña t̃eʼ pascuapo allempo shontena acheñeshaʼpaʼ amachcaʼye yerrmatsche allañacaʼyeña c̈ha yaʼtsrreʼmoc̈htateñ acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Pamt̃arrña Jesúspaʼ Betanioʼtsen all Simón paʼpacllo, ñeñt̃ña Simónpaʼ ñeñt̃ oseʼt̃ puetsarñats. Jesúsñapaʼ all anen all rrallmeʼchen. Allñapaʼ huapoña puesheñarr coyaneshaʼ, huapatan eñmosat̃ ñeñt̃paʼ eʼñe ñeñt̃ocheʼ ñeñt̃ otenet nardo pueseʼ ñeñt̃ ama matsaʼto. Huapatam̃pes puetellm̃o ñeñt̃ña puetellem̃paʼ añ socheñet alabastro. Allempoña ñeñt̃ coyanesharpaʼ potam̃p̃sosan eñmosat̃; ñeñt̃ña eñmosat̃paʼ alla sheʼ Jesús poño all rrallmeʼchen. ");
INSERT INTO ameNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Puesheñaʼtetsñapaʼ ñeñt̃ña c̈ha atsrreʼmatanet, atet̃ otannaʼtyeset: —Esoʼmareʼtña att̃a aʼpertatosanña eñmosat̃. ");
INSERT INTO ameNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ñeñt̃ eñmosat̃erpaʼ amacaʼye matsaʼto. C̈hochñac̈hoʼ pomoseñpaʼ ganañchaʼ shonteʼ quelle c̈hachcaʼye metananeñña ñeñt̃ trescientos denario. Allempoñapaʼ apaʼyesaneñchaʼ ñam̃a allohuen huocchañneshac̈hno. Ñeñt̃paʼ atet̃ sasareʼchet coyaneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Allempoña Jesúspaʼ atet̃ otanet: —Semnachñacaʼyeña coyaneshaʼ ñeñt̃ atet̃ penen. Esoʼmareʼtchaʼ c̈ha mueneʼ satsrreʼmoc̈htanaʼtap̃a. Ñapaʼ atarrcaʼye cohuen p̃osen. ");
INSERT INTO ameNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","T̃arraña amaʼtchaʼ c̈ho pomosaneñ eñmosat̃ alloch es apaʼyesaneñ huocchañneshac̈hno, t̃arraña c̈hocmachcaʼye eñallña huocchañneshac̈hno arr patsro. Ñerraʼm esempo semneñ oʼch eʼñe cohuen sorrtatyesanet ñocpuet c̈hocmach atet̃ sep̃anet. T̃arraña nañapaʼ poʼñoc̈hpaʼ amachcaʼye alloʼna sentenno arr patsro. ");
INSERT INTO ameNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Añ coyanesharpaʼ añcaʼye apuenen ñeñt̃ allpon echyen. Ñeñt̃ att̃o shosnan t̃eʼ eñmosat̃ nechtso, ñeñt̃paʼ añecpaʼnacaʼye sherben t̃arrempohua allempoch aʼyanaʼterrnaneterr ñeñt̃chaʼ epuet pampaʼpesnet. ");
INSERT INTO ameNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Poʼñoc̈hcaʼye notenes: Ora erracmañen añ patsro errach serrpareʼtatyenet añ cohuen ñoñets allempopaʼ serrpareʼchetchaʼ ñam̃a atet̃ penen t̃eʼ añ coyaneshaʼ, att̃ochña ñaʼnach yerpuenet. ");
INSERT INTO ameNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Allempoña pueyochreshaʼ ñeñt̃ c̈harraʼ puechetsa epsheña, puesheñarrña ñeñt̃ paʼsoʼcheñ Judas Iscariote, ñañapaʼ allent̃a ahuoʼ alloʼtsaʼyen ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ p̃aʼyen allohuen judioneshaʼ poʼcornaneshar. Ñañapaʼ añecpa sen att̃och pomataterran Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ñeñt̃ña atarr coshatenahuet. Ñetñapaʼ allempocma aʼpoctachet c̈hochcaʼye tsaʼchetña Judas allpon quelle. Allempoña ñapaʼ aña eʼñe cot̃apeʼchyen errot̃enot̃chaʼ pomuerranña Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Allempoña c̈hapaʼmuen ñeñt̃ yet̃ñatsro allempoch rrerreterr pan ñeñt̃ ama anaret̃eyaye chaseʼ allempoch muetserreterr ñam̃a carrnero; ñeñt̃paʼ pascuapo. C̈hapaʼmuen ñeñt̃ yet̃erpaʼ pueyochreshaʼñapaʼ atet̃ otaʼmueñet Jesús: —T̃eʼpaʼ ¿erraʼt pemneñ allchaʼ yetaʼmuena allchaʼ yaʼpotonap̃ ñeñt̃chaʼ perraʼ pascuapo? ");
INSERT INTO ameNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Allempoña ñeñt̃ epsheña pueyochreshaʼ ñeñt̃chaʼ mueña, Jesúsñapaʼ atet̃ otapanet: —T̃eʼpaʼ oʼch ahuaʼmuenes anetso allchaʼ sepocteʼ puesheñarr yacma ñeñt̃ anmam̃peneʼ oñ porrt̃o. Ñeñt̃ña acheñerpaʼ oʼch soct̃aʼner. ");
INSERT INTO ameNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Allchaʼ beʼt̃osuerr allchaʼña sebeʼt̃osos sam̃a. Allñapaʼ atet̃chaʼ sotos ñeñt̃ apacllat̃eshaʼ: “Yemaestrorpaʼ atet̃ oteney atet̃chaʼ yotosep̃: ‘¿Erroʼtsenaʼtña pecuarto allchaʼ nerrallmeʼchos pascuapo epan neyochreshaʼ?’ ” ");
INSERT INTO ameNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ñeñt̃ apacllat̃eshaʼpaʼ gatapaschaʼ eno poʼcuarto ñeñt̃ atarr aʼyohuen eʼñe cohuen ap̃aret̃. Allchaʼña saññoʼtosña ñeñt̃chaʼ yerraʼ pascuapo. ");
INSERT INTO ameNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Allempo atet̃ otuanet Jesúspaʼ pueyochreshaʼñapaʼ atet̃c̈hoʼ pet, c̈ha ahuanmatset. Oʼña c̈hac̈haʼtet anetso, eʼñe atet̃ otapanetpaʼ ñetñapaʼ eʼñec̈hoʼ atet̃ entoset. Allña aññoʼtosñañetña rreñets allchaʼ rrallmeʼchet ñeñt̃e pascuapo. ");
INSERT INTO ameNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Allempoña oʼ puenasoʼtenpaʼ oʼ c̈hap ñam̃a Jesús all epuet pueyochreshaʼ ñeñt̃ c̈harrasheña puechena epsheña. ");
INSERT INTO ameNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","All anorrc̈henet all rrallmeʼchoset, Jesúsñapaʼ atet̃ otanet: —Poʼñoc̈hcaʼ notenes: Puesheñarrot̃es sa ñeñt̃eschaʼcaʼye nepomuerreʼ. Eʼñe puesheñarr ñeñt̃ eʼñe parro nerren ñeñt̃chaʼcaʼyeña nepomuerreʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ñetñapaʼ c̈ha atarr llecaʼrrtet. Aʼp̃t̃oʼtyeset eʼñe puesheñaʼttset: —Taʼm amat̃eʼ na nepomuerrmochape. ");
INSERT INTO ameNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ñañapaʼ atet̃ oterraneterr: —Eʼñe puesheñarrot̃es ñeñt̃es c̈harrasheñas sepchena epsheña ñeñt̃ña netsapechapreteneʼ nerrar, ñeñt̃chaʼcaʼye nepomataterreʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Poʼñoc̈hcaʼye t̃eʼpaʼ alloʼna sen etsotnomtsa ñeñt̃ atet̃ anuaret̃ Yompor poʼñoñ nocop na Ñeñt̃en Acheñetosets; att̃ot̃chaʼ muetsaterrnet. T̃arraña nocoppaʼ eʼñe pocteʼ; añña poʼñoc̈h acheñer ñeñt̃chaʼ nepomuerreʼ ñocopñapaʼ atarr llequëñets. Añ acheñrecoppaʼ eʼñecaʼye pocteñ amachñac̈hoʼ eñalletatstañe. ");
INSERT INTO ameNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","All rrallmeʼchenet, Jesúsñapaʼ chetan pan parasyosoʼtan Yompor. Parasyosoʼtuepaʼ shotaʼtan panpaʼ apaʼyesan pueyochreshaʼ. Ñeñt̃paʼ atet̃ otanet: —Sagapyes, añmapaʼ ñeñt̃chaʼña nechets sepen. ");
INSERT INTO ameNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Allot̃ñapaʼ chetan ñam̃a orramets parasyosoʼtuerrerrpaʼ apaʼyerraneterr. Ñetña allohuenetpaʼ eʼñe orryesuahuet. ");
INSERT INTO ameNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesúsñapaʼ atet̃ oterraneterr: —Añpaʼ nerrascaʼye sepeñ ñeñt̃chaʼ ashataret̃tatsa shonteʼ acheñeneshacop. Añ nerraspaʼ alloch eʼñe etserra aʼpoctaterra acheñeneshaʼ Apuesho. ");
INSERT INTO ameNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Na t̃eʼpaʼ oʼch notas: Amach alla norrerreʼt̃e añ narmetsos t̃ayot̃eñ t̃arrempohuach allempoch alla ello yorrerrerr parro allempoch am̃chaʼtaret̃etuerra Yompor. ");
INSERT INTO ameNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Allempoña oʼ morrechuanmuet Yomporecoppaʼ ahuaneneterr Olivop̃no. ");
INSERT INTO ameNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Allñapaʼ atet̃ otosanet Jesús: —Añ tsaprocmach sa allohuenespaʼ saʼypoʼñaʼhuanmuenchaʼ t̃arroʼmar Yompor poʼñoñopaʼ atet̃caʼye anuaret̃, ñeñt̃paʼ atet̃ oteʼt̃ Yompor nocop: “Oʼch nemtsater ñeñt̃ cohuam̃peneʼ carrnero, poʼcarrnerorñapaʼ c̈hach matrraʼtyesa allemeñ.” ");
INSERT INTO ameNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Jesúsñapaʼ atet̃ oterraneterr: —T̃arraña esempoch alla netanterra napaʼ nanomchaʼ oterrtsa Galileo. ");
INSERT INTO ameNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Allempoña Pedropaʼ atet̃ och: —Amaʼt allohuenet ñerraʼm aʼypoʼñaʼhuerrpetchaʼpaʼ naña amaʼt ahuat̃apaʼ amach naʼypoʼñerrpe. ");
INSERT INTO ameNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesúsñapaʼ atet̃ otererr: —Poʼñoc̈hcaʼye oʼch notap̃, añe tsaprocmach amaʼt eʼñe epocha amach eñenaʼ atollop p̃añapaʼ oʼch maʼpoch p̃aʼnasotenna. ");
INSERT INTO ameNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedroñapaʼ alla otererr: —Amaʼtchaʼ yerromhuanen parropaʼ naña poʼñoc̈hpaʼ amaʼt parrocha amach naʼnasotap̃o. Allohuen pueyochreshaʼpaʼ ñetpaʼc̈hoʼña eʼñe att̃ecma otyenetañ ñamet. ");
INSERT INTO ameNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Allot̃ñapaʼ c̈hap Jesús pueyochreshohuen all narmetsm̃o, ñeñt̃paʼ añ paʼsoʼcheñ Getsemaní. Allñapaʼ otosanet: —T̃eʼ sapaʼ allach sanorrc̈haʼtos arrma, napaʼ oʼch nemaʼyochenaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Allñapaʼ aña anmos Pedro ñam̃a Jacobo ñam̃a Juan. Jesúsñapaʼ amaʼt mameshapaʼ ama eñmateno pueyoc̈hro, c̈ha nanac allpatena. ");
INSERT INTO ameNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Allempoñapaʼ atet̃ otosanet: —Napaʼ c̈ha chepoc̈henen nellquëña neyoc̈hro, c̈ha mueneʼ nerromuen nellquëñot̃. Sapaʼ allasaʼt̃ach arr secuapretosnoʼt̃ach. ");
INSERT INTO ameNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Ñañapaʼ ahuoʼ aʼyent̃eyeʼ all rremosa patso atet̃ maʼyochosa: —Apa, p̃ocoppaʼ ama eñalle ñeñt̃ ama errot̃en apen penteno; ñeñt̃oʼmar t̃eʼpaʼ notenep̃ amach pemnatatsche oʼch c̈hapona ñeñt̃ atarr amueroc̈htatañ nenten na. T̃arraña ñerraʼm p̃ach muenatspaʼ añepaʼchña atet̃ pep̃aton ñeñt̃ pemnen p̃a, amachña añeyaye ñeñt̃ nemnen na. ");
INSERT INTO ameNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Oʼña atet̃ maʼyochuapaʼ oʼ ahuerr alloʼtsaʼyen pueyochreshaʼ maʼpsheña. Oʼ c̈herr allpaʼ alla entuerranet ñetñapaʼ c̈ha atarr manrrenet. Allempoñapaʼ otuerran Pedro: —C̈haʼt Simóna atarr pemos. Amaʼt mamesha areʼtña acuenayeʼ penteno. ");
INSERT INTO ameNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Eʼñe señoseʼrteñot̃paʼ c̈hoña semaʼyochosa allochñapaʼ att̃och amach sañeña aʼpuerrataterro topateñets ñeñt̃chaʼ sehuapoya atarr huomenc. Ñeñt̃paʼ amaʼt atarr semneñeñ t̃arraña sechetsñapaʼ amacaʼye ahuamencat̃eyeʼ penso, ñeñt̃oʼmarña notenes c̈hocmach semaʼyochena. ");
INSERT INTO ameNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesúsñapaʼ alla ahuerrerr puepocheño oʼch maʼyocherrerr, ñeñt̃ara atet̃ otuerrerr. ");
INSERT INTO ameNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Oʼña alla maʼyochuerraʼpaʼ allempoñapaʼ huerrerr, alla entuerranerr pueyochreshaʼ ñetñapaʼ oʼ alla manrrerreterr, c̈ha nanac atserr moñeʼtenet. Ama eñoteñeto errot̃enchaʼña otapuereteʼt̃. ");
INSERT INTO ameNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jesúsñapaʼ alla ahuerrerr maʼyochatsa. Oʼña maʼyochuerraʼpaʼ allempoñapaʼ alla huerrerr pomaʼpocheñohua, atet̃ otuerranerr pueyochreshaʼ: —Amaʼt t̃emeʼttsenpaʼ allaʼt semanrren; amaʼtpaʼ alla sames. T̃eʼpaʼ ñeñt̃epaʼt̃a, señochepaʼch oʼ c̈hap allempoch pomataterrnet na Ñeñt̃en Acheñetosets att̃ot̃chaʼ errot̃uanen perren ñeñt̃ atarr ochñat̃eneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","T̃eʼñapaʼ setanterra oʼch ahuey oʼch yepocteʼ. Secueʼcaʼye ñeñt̃chaʼ nepomueʼ ñeñt̃paʼ allaʼtsena. ");
INSERT INTO ameNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","All atet̃ eñorena Jesúspaʼ c̈ha huapatsa puesheñarr ñeñt̃ pueyochreshaʼ peneñ ñeñt̃ aʼpchenahuet epsheña, ñeñt̃ñapaʼ añ Judas. Ñañapaʼ huac̈haʼtatan shonteʼ acheñeneshaʼ occhellet̃areret ñam̃a etsachperet̃areret. Ñehua, añ ñeñt̃ huac̈haʼttsapaʼ añ mueñenahuet ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar ñam̃a ñeñt̃ etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ ñam̃a ñeñt̃ pomporneshaʼ pen allohuen judioneshaʼ. Ñetcaʼyeña mueñeneʼña ñeñt̃chaʼ rromuenayaʼ Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ñehua, Judas ñeñt̃chaʼ pomuerreʼ Jesúspaʼ ñañapaʼ atet̃ otnoman acheñeneshaʼ ñeñt̃ anom att̃och chemeʼtoset Jesús. Ñeñt̃paʼ atet̃ otnomanet: —Erraʼtsenchaʼ nehuom̃chaʼtos eʼñe netsoʼtstsapaʼteñot̃paʼ ñeñt̃caʼyeña Jesús. Sañapaʼ ñeñt̃chaʼña serrmospaʼ oʼch sanem̃ eʼñe sehuamencocma. ");
INSERT INTO ameNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Allempoña huapapaʼ c̈ha ponmosaya Jesús huom̃chaʼtos eʼñe puetsoʼtstsapaʼteñeshaʼ, atet̃ otos: —Tsapo, Maestrochaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Allempoña acheñeneshaʼpaʼ ponmosyet Jesúspaʼ rromoset eʼñe poʼhuamencocma. ");
INSERT INTO ameNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Allempoña puesheñarr ñeñt̃ Jesús pueyochreshaʼ ñañapaʼ poʼcchella chetaʼpaʼ oʼch c̈hontoʼtapaneñ corneshaʼ pueñañra puetepaʼtchaʼ tsorroñ. Ñeñt̃paʼ año pueñañra ñeñt̃ paʼm̃chaʼtaret̃er pen allohuen judioneshaʼ poʼcornaneshar. ");
INSERT INTO ameNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Allempoña Jesúspaʼ atet̃ otan acheñeneshaʼ: —Esoʼmareʼt sehuac̈haʼtennanaña eʼñe occhellet̃areroches ñam̃a etsachperet̃areroches att̃och serrmaʼn. Napaʼ ¿eʼñeʼt atet̃ sentenen ñerraʼmrrat̃eʼ eñet̃en? ");
INSERT INTO ameNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Oʼ allponmatuanen alloʼtsenen Parets paʼpacllo eʼñe parro sesho, esoʼmareʼtña amaña allempocmaña serrmaʼneʼt̃e. Amaʼtpaʼ att̃epaʼcaʼye perra allochñapaʼ att̃och eʼñe etsotuerra ñeñt̃ allpon quellcaʼyeseʼt̃ nocop ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Allempoña allohuen pueyochreshaʼpaʼ allorocma aʼypoʼñaʼhuanmet, ñetñapaʼ yetrraʼtuet. ");
INSERT INTO ameNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ñehua, allempopaʼ alloʼtsen ñam̃a puesheñarr huepueshachor ñeñt̃ epuet ta Jesús. Ñañapaʼ c̈ha muelleʼmquën att̃a ep̃amcoʼtnoma. Ñapaʼc̈hoʼña ahuoʼch rremuetañpaʼ ");
INSERT INTO ameNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","aña aʼmeyam̃peretaʼ allo ep̃amcoʼtena, huepueshachorñapaʼ muelleʼmcot̃a aʼyetachet. ");
INSERT INTO ameNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Acheñeneshaʼña ñeñt̃ rromoseʼ Jesúspaʼ ñetñapaʼ arr anmet alloʼtsen ñeñt̃ paʼm̃chaʼtaret̃er pen allohuen judioneshaʼ poʼcornaneshar. Allñapaʼ all apc̈ha ñam̃a amaʼt allohuen cornaneshac̈hno ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen judioneshaʼ poʼcornaneshar ñam̃a ñeñt̃ pomporneshaʼ pen allohuen judioneshaʼ ñam̃a allohuen ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop. Ñetña allohuenet eʼñe all apc̈henet. ");
INSERT INTO ameNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedropaʼ ñapaʼc̈hoʼña cot̃eʼ t̃arraña ñapaʼ chentaʼ en aʼyot̃. Corneshaʼ poʼpampopaʼ allñapaʼ anorros epuet ñeñt̃ guardianeshaʼ all aʼt̃orenet tsoʼ all shotoset parro. ");
INSERT INTO ameNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","56","Cornaneshaʼña paʼm̃chaʼtaret̃erneshaʼ ñam̃a allohuen ñeñt̃ c̈hocma aʼpoctatyeneʼ allohuen ñoñets ñeñt̃ judioneshacop, ñetñapaʼ aña atarr eʼnenet ñeñt̃chaʼ aʼmet̃areʼtam̃p̃soseʼ Jesús allochñapaʼ att̃och muetsatachet. Amaʼt shonteʼ huapatsañ ñeñt̃chaʼ tomaʼtam̃p̃sosayeñpaʼ am̃chaʼtaret̃neshaʼña amaʼt puesheñarrot̃etapaʼ ama eseshayeʼ entayeña att̃och muetsatateret t̃arroʼmar allohuenet ñeñt̃ tomaʼtam̃p̃sosayeñpaʼ ama eʼñe att̃ecmayeʼ otosetoña Jesúsocop. ");
INSERT INTO ameNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Allempoña t̃omc̈haʼtos ñam̃a poʼpotantañ; ñetpaʼc̈hoʼña tomaʼtam̃p̃soset Jesús; ñetñapaʼ atet̃ otoset: ");
INSERT INTO ameNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ya ahuañapaʼ yeʼmeʼt̃caʼyeña Jesús atet̃caʼye oteʼt̃: “Napaʼ oʼchcaʼye naʼmaterrñañ añ Parets paʼpaquëll ñeñt̃paʼ acheñacaʼye pueyec̈hcatar; t̃arraña pomaʼpamtañoñapaʼ napaʼ oʼchcaʼye alla nat̃omater poʼpoñ ñeñt̃paʼ amachcaʼye añeyaye ñeñt̃ yec̈hcaten acheñ.” ");
INSERT INTO ameNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","T̃arraña amaʼt atet̃ tomaʼtam̃pesyesosetañpaʼ ama eʼñe att̃ecmayeʼ otoseto. ");
INSERT INTO ameNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Allempoña corneshaʼ ñeñt̃ nanac am̃chaʼtaret̃ allent̃a t̃ompaʼ atet̃ otan Jesús: —P̃añapaʼ ¿amaʼtchaʼña p̃anapaneto? ¿Errot̃enot̃eʼtña otteñeʼchenpet? ");
INSERT INTO ameNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesúsñapaʼ ama eñoreno, ama anapuenaneto. Allempoña corneshaʼpaʼ alla otererr: —T̃eʼpaʼ oʼch notap̃, nemneñ oʼch p̃oten p̃apaʼ ¿p̃aʼtña ñeñt̃ep̃t̃eʼ Cristotosets? ¿Ñeñt̃ep̃t̃eʼ Parets Puechemerep̃, ñeñt̃ Parets c̈hocma yaʼyeʼchoc̈htateññañ? ");
INSERT INTO ameNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesúsñapaʼ atet̃ och: —Napaʼ ñeñt̃encaʼye. Elloña napaʼ oʼchcaʼye notas, senterrenchaʼ na Ñeñt̃en Acheñetosets oʼchcaʼye alla nanorruerr Parets poʼcohuenrot̃. Ñam̃a poʼpocheño oʼch sentapuerren oʼch nesuam̃perra osot̃ Yompor pueʼntañot̃. ");
INSERT INTO ameNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Corneshaʼñapaʼ ñeñt̃a eʼmpaʼ allent̃a rrarreʼtan paʼshtam eʼñe patsrreʼmueñot̃, ñeñt̃paʼ atet̃ ot: —T̃eʼpaʼ amachcaʼye yeʼnatsche poʼpsheñeñ ñeñt̃chaʼ aʼmet̃am̃p̃soseʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","T̃eʼ amaʼt sapaʼ oʼcaʼye seʼm̃ atet̃ achm̃areʼtenan Yompor. ¿Errot̃enaʼt senteñña sa? Ñetña allohuenetpaʼ atet̃ otyeset: —Ña poʼñoc̈hpaʼ atarrcaʼye nanac achm̃areʼtenan Yompor, pocteʼñac̈hoʼ t̃eʼpaʼ oʼch semtsatach. ");
INSERT INTO ameNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Allempoñapaʼ aʼcoshareʼtyeset, huancaclleʼchet paʼclloyot̃paʼ c̈hotaʼtyeset. Pachm̃areʼteñot̃et atet̃ otyeñet: —T̃eʼña eñoratenperrepaʼ Parets allochñapaʼ att̃och p̃otey eseshaʼt̃eʼña pec̈hotaʼtyeneʼ. Amaʼt guardianeshaʼ ñetpaʼc̈hoʼña oʼ c̈hotaʼchet. ");
INSERT INTO ameNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedroña allempopaʼ patsot̃eʼtsen pampat̃ollo. Allempoña allpaʼ huapa puesheñarr coyaneshaʼ ñeñt̃ sherbeneʼ corneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ñañapaʼ entosan Pedro all shotenana tsoʼ. Cohuanaʼtospaʼ atet̃ och: —P̃acaʼye eʼñe cot̃ayeʼt̃ña Jesús ñeñt̃ nazaretoʼmarneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedroña anapueʼpaʼ c̈ha aʼnasochapaʼ atet̃ och: —Napaʼ amacaʼye nentareña, amaʼt napaʼ amacaʼye neñoteñeña ñeñt̃ atet̃ p̃otenen. Allempoña Pedropaʼ ahuerr, c̈herr allot̃ecma beʼt̃enet oʼch c̈hapuet oʼpono pampo. Allempoña allent̃a eñen atollop. ");
INSERT INTO ameNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Allñapaʼ entuererr coyaneshaʼ ñeñt̃ corneshaʼ pueñañra. Ñañapaʼ atet̃ oterranerr ñeñt̃ parro alloʼtsaʼyenet: —Añ acheñerpaʼ ñeñt̃caʼye eʼñe parro yemtenet ahuaña. ");
INSERT INTO ameNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedroñapaʼ alla aʼnasotererr. Oʼña oʼchterrerrpaʼ ñeñt̃ t̃omc̈haʼtyets all, ñetpaʼc̈hoʼña atet̃ otereterr: —Poʼñoc̈hcaʼye p̃apaʼc̈hoʼña eʼñecaʼye parro seyemtena t̃arroʼmar p̃apaʼc̈hoʼña galileoʼmarneshap̃caʼye ñeñt̃oʼmar eʼñe atet̃ peñen ñerraʼm ña. ");
INSERT INTO ameNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Allempoña Pedropaʼ eʼñe pueshquëñot̃anetpaʼ att̃a otatseʼtyerraneterr, ñeñt̃paʼ atet̃ otanet: —Napaʼ eʼñe Yompor paʼsoʼchño notenes, ñerraʼm amat̃eʼ poʼñoc̈hoyeʼ notensopaʼ t̃eʼpaʼ nerromuepaʼ. Napaʼ poʼñoc̈hcaʼye ama nentareña añ yacmar. ");
INSERT INTO ameNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Oʼña atet̃ otuanetpaʼ eʼñepaʼtchaʼ allempocma puepocheño eñenña atollop. Allempoña Pedropaʼ alla yerpuerrana ñeñt̃ atet̃ oteñ Jesús: “Amaʼt eʼñe epocha amach eñenaʼ atollop p̃añapaʼ oʼch maʼpoch p̃aʼnasotenna.” Allempoña Pedropaʼ allent̃a atarr yahuena huomenc. ");
INSERT INTO ameNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tsapat̃ oʼ t̃aya puetarenpaʼ ñeñt̃ña paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar ñetñapaʼ apc̈haʼmueneterr parro epuet ñeñt̃ pomporneshaʼ pen allohuen judioneshaʼ ñam̃a añ ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ epuet ñam̃a poʼpotantañ ñeñt̃ poʼtaruas peneʼ oʼch aʼpoctatan ñoñets judioneshacop. Ñetñapaʼ cot̃apeʼchatannetset, att̃oña oʼ eʼñe aʼpoctataʼmueñet atet̃chaʼ p̃aʼmueñet Jesús. Jesúsñapaʼ oʼ huancotaʼtuet allempoñapaʼ anmaʼmueñet alloʼtsen am̃chaʼtaret̃ Pilato (ñeñt̃ nen gobiernoʼ Romot̃ ñeñt̃ am̃chaʼtaret̃tetsa alloʼmarneshacop). ");
INSERT INTO ameNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatoña aʼp̃t̃oʼtapan Jesúspaʼ atet̃ och: —P̃apaʼ ¿p̃aʼtña am̃chaʼtaret̃tetsaña judioneshacop? Jesúsñapaʼ atet̃ och: —Napaʼ ñeñt̃encaʼye atet̃ p̃oten. ");
INSERT INTO ameNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar, ñetña allpaʼ shonteʼ paʼnamenot̃ otteñeʼchaʼmueñet Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatoñapaʼ atet̃ otererr: —P̃apaʼ ¿areʼtchaʼña p̃anapaneto? ¿Amaʼt peʼmuenanetoña ñetpaʼ paʼnamenot̃ aʼmet̃areʼtam̃penpet? ");
INSERT INTO ameNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesúsñapaʼ amaʼt eʼñe parrocha ama anapuenaneto. Ñeñt̃oʼmarña Pilatopaʼ c̈ha atarr cohuanaʼtapan Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ñehua, ñetpaʼ atet̃caʼye yec̈henet. Eʼñe pat̃eʼtets char allempoch c̈herrerr pascuapo, ñeñt̃ña am̃chaʼtaret̃ ñeñt̃ nen gobiernoʼ Romot̃paʼ ñañapaʼ c̈hocmach aʼrroyerran puesheñarr judioneshacop ñeñt̃ ayottam̃p̃saret̃tetsa allempo, ñeñt̃ara ñeñt̃ pamoʼts penet ñet. Oʼch apanet erraʼtsenc̈hoʼ enamuenet ñeñt̃ muenenet ñet. Ñeñt̃paʼ añecop aʼrroyenanetña puesheñarr pamoʼtset att̃och eʼñe cohuen coshatenan allohuen judioneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ñam̃a eʼñe allempopaʼ alloʼtsen puesheñarr judioneshaʼ ñeñt̃ ayottam̃p̃saret̃tetsa ñeñt̃paʼ añ paʼsoʼcheñ Barrabás. Ñehua, ñeñt̃ Barrabás ahuañmoʼchot̃eñ yottam̃peñet epuet poʼpotantañ t̃arroʼmar ñetpaʼ ñetcaʼye yec̈hatenetña acheñeneshaʼ at̃pareʼchetepaʼtoʼ am̃chaʼtaret̃ ñeñt̃ nen gobiernoʼ Romot̃. Eʼñe pat̃pareʼteñot̃et oʼ muetset ñam̃a acheñ. ");
INSERT INTO ameNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Allempoña acheñeneshaʼpaʼ c̈hac̈haʼtet Pilateshopaʼ ñetñapaʼ atet̃ otoset: —T̃eʼpaʼ oʼch p̃aʼrroyerrnay puesheñarr ñeñt̃ atet̃ c̈hocma peperrnayeʼt̃. ");
INSERT INTO ameNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatoñapaʼ atet̃ otapanet: —Sapaʼ ¿añeʼtña semnen oʼch naʼrroyerrnas ñeñt̃ am̃chaʼtaret̃tetsa judioneshacop? ");
INSERT INTO ameNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ñehua, Pilatopaʼ atet̃ otapan acheñeneshaʼ t̃arroʼmar ñapaʼ eñotenan cornaneshac̈hno paʼm̃chaʼtaret̃erneshaʼpaʼ ñetpaʼ eʼñecaʼye pueʼmoñeʼtateñmeʼchatsa pomueñetña Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","T̃arraña ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen judioneshaʼ poʼcornaneshar ñetñapaʼ aña atarr cot̃apeʼchatenet acheñeneshaʼ att̃och ñetpaʼ allohuenetpaʼ oʼch ochet Pilato: “Añchaʼ p̃aʼrroyerrnay Barrabás.” ");
INSERT INTO ameNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Allempoña Pilatopaʼ alla oterraneterr: —Ñehua, añ ñeñt̃ soten judioneshaʼ paʼm̃chaʼtaret̃er, ñapaʼ ¿errot̃eʼtchaʼña nepeʼ? ");
INSERT INTO ameNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ñetña puerranareʼteñot̃etpaʼ atet̃ otyeset: —Ñapaʼ ¡pecorsoʼtam̃p̃sachñacaʼye! ");
INSERT INTO ameNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatoñapaʼ atet̃ oterraneterr: —Ñapaʼ ¿esoʼtña pen ñeñt̃ amaʼt mameshapaʼ ama pocteyeʼ sentapreteñe? Ñetñapaʼ alla rrannarterreterr huomencpaʼ atet̃ oterreterr: —Ñapaʼ ¡c̈hop̃añacaʼyeña corsoʼtam̃p̃sateʼ! ");
INSERT INTO ameNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatoñapaʼ añ atarr muenen oʼch coshatan acheñeneshaʼ ñeñt̃oʼmarña aʼrroyerranet Barrabás ñeñt̃ enamueñet. Allempoña ashtatan ñam̃a Jesús allot̃ñapaʼ otan poʼsolltarneshar: —T̃eʼpaʼ oʼch secorsoʼtam̃peñaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ñehua, solltarneshaʼña ama aneñetaʼ allchaʼ corsoʼtam̃p̃soset arrña ñanom anmetña Jesús am̃chaʼtaret̃epahuo. Allña agotachet allohuen poʼpotantañ solltarneshaʼ ñeñt̃ alloʼtsaʼyen oʼch eʼñe apc̈het Jesúsesho. ");
INSERT INTO ameNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Allñapaʼ paʼllocchameʼteñot̃et Jesús chorrachet shetamuets tsamamuenoʼ quelluemamtena ñeñt̃ paʼshtam pen ñeñt̃ poʼñoc̈h am̃chaʼtaret̃tetsa. Pelltaʼtoñet ñam̃a choyoʼmets agrec̈hpaʼ ñeñt̃ña choyoʼm̃tachet ñeñt̃ atet̃ choyoʼm̃tena ñeñt̃ poʼñoc̈h am̃chaʼtaret̃tetsa. ");
INSERT INTO ameNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pachm̃areʼteñot̃etpaʼ atet̃ oteñet: —¡Puetareʼ am̃chaʼtaret̃echaʼ atarruacaʼ cohuenep̃t̃eʼ! p̃a ñeñt̃ep̃ judioneshaʼ paʼm̃chaʼtaret̃erep̃. ");
INSERT INTO ameNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Puecheʼtatseteñot̃et astoʼtameʼteñet tsachp̃o poño, aʼcoshareʼteñet, allempoña concorpanaʼteñet, ottenetañ ñerraʼmrrat̃eʼ c̈hoʼ muechatseʼteñet. ");
INSERT INTO ameNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Oʼña achm̃areʼtuahuetpaʼ allempoñapaʼ rrotam̃peret shetamuets tsamamuen chorrateret eʼñe ña paʼshtam. Allempoñapaʼ anmet aʼyo allchaʼ corsoʼtam̃peñetaʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Eʼñe ahuanmatsetpaʼ allña oñenetpaʼ oʼ poctet puesheñarr yacma ñeñt̃ cireneoʼmarneshaʼ ñeñt̃paʼ añ paʼsoʼcheñ Simón ñeñt̃ errteʼ huerrtsa aʼyot̃. Ñañapaʼ allent̃a chechatnomet poʼcorsoch. Ñeñt̃ña Simónpaʼ ñeñt̃paʼ añ pompor pen Alejandro ñam̃a Rufo. ");
INSERT INTO ameNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","C̈hapachet all socheñet Gólgota ñeñt̃ yoten yeñoño Poñetallep̃no. ");
INSERT INTO ameNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Oʼ c̈hapachet allpaʼ Jesúspaʼ aposetañ vinos ñeñt̃paʼ añ atsetaret̃ pueretso ñeñt̃ atarr pesherr ñeñt̃ otenet mirra t̃arraña Jesúspaʼ ama mueno oʼch orr. ");
INSERT INTO ameNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Allempoña oʼ corsoʼtam̃pesuetpaʼ solltarneshaʼñapaʼ allent̃a yellsheñeʼchatoñet paʼshtam poʼsuertot̃ att̃och orrtet eʼñe puesheñaʼttsetpaʼ oʼch yorayesñañet paʼshtam puemaʼtets. ");
INSERT INTO ameNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Oʼña enomeʼtaʼmuen atsneʼ allempocaʼye corsoʼtam̃p̃saʼmueñetña Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ñehua, poñot̃paʼ all corsocho all noñet tsachtall aquellcaret̃ att̃ochña eñoteñet ñeñt̃ecop corsoʼtam̃peñet. Ñeñt̃ña quellecpaʼ atet̃ oten: “Añpaʼ ñeñt̃caʼyeña judioneshaʼ paʼm̃chaʼtaret̃er.” ");
INSERT INTO ameNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Allña corsoʼtam̃p̃set epuet ñam̃a epsheña eñet̃, puesheñarrpaʼ nosñañet poʼcohuenrot̃, poʼpsheñeññapaʼ nosñañet pueʼchcot̃erot̃. ");
INSERT INTO ameNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Att̃ocaʼyeña etsoterraña Yompor poʼñoñ ñeñt̃ atet̃ anuaret̃ ahuat̃ot̃eñ Cristocop; ñeñt̃paʼ atet̃caʼye oten: “Ñapaʼc̈hoʼña eʼñech att̃ecma enteret ñerraʼmrrat̃eʼ ñeñt̃ atet̃ p̃atseʼtyeneʼ ñeñt̃ ama pocteyaye.” ");
INSERT INTO ameNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ñeñt̃ña oñmac̈hets allpaʼ ñetpaʼc̈hoʼña c̈hocma achm̃areʼtneñet. Pachm̃arñot̃etpaʼ coñoʼcoñtanaʼtyesneñet, ñeñt̃paʼ atet̃ otyesneñet: —P̃a ñeñt̃ep̃ p̃ommoʼcheñot̃paʼ p̃otatseʼteʼt̃ p̃oʼch aʼmaterrayeñ Parets paʼpaquëll, pomaʼpamtañocmoʼch alla p̃at̃omatereñ, ");
INSERT INTO ameNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","t̃eʼñapaʼ p̃aʼqueshp̃aterrañacaʼye eʼñe p̃añeña, pesuerrañacaʼyeña t̃ayecma corsochot̃. ");
INSERT INTO ameNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Eʼñe att̃ecma achm̃areʼteñ ñam̃a ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen judioneshaʼ poʼcornaneshar ñam̃a ñeñt̃ etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃. Ñetñapaʼ eʼñe parrocma pachm̃areʼteñot̃paʼ atet̃ otatseʼtyeñet: —T̃eʼña p̃apaʼ oʼ p̃aʼqueshp̃atyes poʼpotantañ, p̃añapaʼ esoʼmareʼtchaʼña t̃eʼpaʼ ama errot̃enot̃ p̃aʼqueshp̃aterroña eʼñe p̃añeña. ");
INSERT INTO ameNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Eʼñe pachm̃areʼteñot̃etpaʼ atet̃ otyereterr: —P̃apaʼ ñeñt̃ep̃oʼcaʼye Cristotostsañ, ñeñt̃ep̃oʼcaʼye israelneshaʼ paʼm̃chaʼtaret̃erpeñ, pesuerrañacaʼye corsochot̃ allochñapaʼ att̃och yameʼñap̃a yam̃a. Eʼñe att̃ecma peʼ ñam̃a eñet̃ ñeñt̃ epuet corsoʼtam̃peñet, ñetpaʼc̈hoʼña atarr es otnareʼchet allot̃ poʼcorsochot̃. ");
INSERT INTO ameNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Oʼña c̈hap poctopaʼ oʼhuañ atsnom oʼ eʼñe checmetua ora errap̃aren añe patsro, oʼña ellerrotenmochapaʼ oʼ alla puetarerr. ");
INSERT INTO ameNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Allempoña ellerrotnenmochapaʼ Jesúsñapaʼ rrana huomenc, ñeñt̃paʼ atet̃ ot eʼñe ña poʼñoño: —Eloi, Eloi, lama sabactani. Ñeñt̃ña ñoñtsorpaʼ atet̃ oten: Esoʼmaruachñacaʼye Neyompor-rechaʼ p̃aʼypoʼñerren. ");
INSERT INTO ameNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Puesheñaʼtetsña ñeñt̃ t̃omc̈hets all ñeñt̃ eʼmueʼ atet̃ oten Jesús, ñetñapaʼ amacaʼye eʼmueññañeto poʼñoñ ñeñt̃ atet̃ oten, ñeñt̃oʼmarña ñetpaʼ c̈ha otyeset: —Seʼmueñeʼt oʼ c̈ha c̈horeʼtant̃eʼ Elías ñeñt̃ aʼm̃tayeʼt̃ ahuat̃ Parets poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Allempoñapaʼ mata puesheñarr ñeñt̃ alloʼtsen, eʼc̈homosan chellaʼso ñeñt̃ atsotsoʼtpoʼ oʼ neʼ tsachp̃opaʼ allot̃ña tsotsoʼtatosanña Jesús. Ñañapaʼ atet̃ otanet: —T̃eʼpaʼ oʼch yecueʼ Elías ñatoʼrraña oʼch huapapaʼ ñach aʼsuatoseʼ. ");
INSERT INTO ameNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Allempoña Jesúspaʼ oʼ alla rranerrerr huomencpaʼ rroma. ");
INSERT INTO ameNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Allempoña besom allo yottam̃peññañet Parets paʼpaquëll oʼponopaʼ ahuepaʼt rrarraʼnom eʼñe poctacma, ellopaʼtetsta enot̃eñ eʼñe sotatsohua. ");
INSERT INTO ameNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Capitánña ñeñt̃ romoʼmarneshaʼpaʼ ñeñt̃ t̃ets allameʼtets ñañapaʼ eʼñe entenan Jesús att̃o rroma, allempoña ñapaʼ atet̃ ot: —Poʼñoc̈huacaʼye añ acheñerpaʼ Partsepaʼtcaʼye Puechemer. ");
INSERT INTO ameNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Alloʼtsaʼyen ñam̃a shonteʼ coyaneshac̈hno, ñetñapaʼ aʼyot̃a cohuanrrortenet. Ñetpaʼ ñetcaʼyeña cot̃aʼhuanmueʼña Jesús Galileot̃eñ ñeñt̃ sherb̃aʼyesayeʼt̃. Ñeñt̃paʼ María Magdalena ñam̃a poʼpsheñeñ María ñeñt̃ Jacobo pachor ñam̃a José. Ñehua, ñeñt̃ Jacobopaʼ puechoyomer peñ José. Alloʼtsaʼyen ñam̃a shonteʼ poʼpotantañ coyaneshac̈hno ñeñt̃ cot̃aʼyesayeʼt̃ Jesús Jerusaléño. ");
INSERT INTO ameNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Att̃eñapaʼ oʼ ellerren. Ñehua, ñeñt̃ yet̃ñatsropaʼ allempocaʼye c̈hocma aññoʼtena judioneshaʼ ñeñt̃ tsapat̃ecop allempoch ameserreterr. ");
INSERT INTO ameNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ñeñt̃oʼmarña allempopaʼ Joséña ñeñt̃ arimateoʼmarneshaʼpaʼ ñañapaʼ ama puem̃chaʼñot̃eyeʼ ahuoso Pilatesho oʼch oteñaʼ pocteʼch eñch ñach aʼsuatoseʼ Jesús ñeñt̃ rromuets corsocho. Ñehua, ñeñt̃ Josépaʼ atarr cohuen acheñ, atarr am̃chaʼnaʼtpoʼ enteñ allohuen ñeñt̃ parro aʼpoctatenet ñeñt̃ llequëna allohuen judioneshaʼ. Ñapaʼc̈hoʼña ñeñt̃ atarr cohueneʼ Yompor esempohuañenchaʼ oʼch atarr ayochreshat̃terra. ");
INSERT INTO ameNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Allempo atet̃ enamosan Pilato, Pilatoñapaʼ atet̃ ot: —Taʼm ¿poʼñoc̈ht̃eʼ oʼ rromaña eʼñe mamecma? Allempoñapaʼ agotan solltar poʼcap̃tanerpaʼ aʼp̃t̃oʼch: —¿Poʼñoc̈haʼt oʼ rromaña Jesús? ");
INSERT INTO ameNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Capitánñapaʼ atet̃ otos: —Poʼñoc̈hcaʼye oʼcaʼye rroma. Pilatoñapaʼ atet̃ otan José: —Ñeñt̃epñapaʼ p̃aʼsuater corsochot̃paʼ p̃anercaʼye. ");
INSERT INTO ameNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joséñapaʼ allent̃a rañt̃osana emarr shetamuets, c̈herr corsochopaʼ aʼsuaterranña Jesús corsochot̃ all rromuen. Ep̃atseʼch shetamtso ñeñt̃ eʼñe cohuen. Allempoñapaʼ anem̃ allchaʼ pampueñaʼ. All eñatenan mapuetpon allcaʼyeña nenanaʼña Jesús. Allempoñapaʼ attomeʼtuerrñañ mapueʼ allo yottam̃pesner ñeñt̃ puepampuer p̃ach. ");
INSERT INTO ameNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","All cohueñ María Magdalena ñam̃a poʼpsheñeñ María, José pachor. Ñetñapaʼ eʼñe enteñet all naʼneret Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Oʼña huañ yet̃ allempo amesenet, María Magdalena ñam̃a Salomé ñam̃a poʼpsheñeñ María ñeñt̃ Jacobo pachor, ñetñapaʼ rañt̃aʼyesnenet eñmosat̃ ñeñt̃chaʼ anmaʼmuenet tsapat̃ Jesús puepampro alloch aʼyanaʼteretaʼ amaʼt rromot̃a. ");
INSERT INTO ameNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tsapat̃ allempo mot̃taʼmuena yet̃ñats temenc ñetñapaʼ eʼñe ahuat̃ecma ahuanmaʼmuenet Jesús puepampro. Oʼ t̃aya huapaʼmuena atsneʼpaʼ allempo ahuanmaʼmuenet. ");
INSERT INTO ameNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ñetñapaʼ otannaʼtyesnomuet: —Taʼ, eseshaʼch aʼrrot̃eʼteʼña mapueʼ añecmuen ñeñt̃ allo yottam̃peñet att̃och yebeʼt̃os all puepampro eshecchaʼ yaʼyanaʼteraʼ eñmosat̃o. ");
INSERT INTO ameNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ñetña c̈hapatseta all, cohuostseta entoset mapueʼ oʼ aʼrrot̃eʼtaret̃tena aʼyenet̃, amaʼt ñeñt̃ mapueʼpaʼ añecmuen. ");
INSERT INTO ameNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ñetña allempo beʼt̃ososet puepampro allñapaʼ all entoset puesheñarr huepueshaʼ all anen poʼcohuenrot̃. Paʼshtamñapaʼ atarr huallamaʼt̃, c̈ha t̃orats p̃anet pueyoc̈hret. ");
INSERT INTO ameNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ñeñt̃ña mellañot̃eñerpaʼ atet̃ otapanet: —Amach c̈ha seyorenatsto. Napaʼ neñotenes añcaʼye semnen oʼch sentaʼmueñ Jesús ñeñt̃ otenet nazaretoʼmarneshaʼ ñeñt̃ oʼ corsoʼtam̃perret. T̃arraña ña t̃eʼ oʼcaʼye tanterra, ama arroʼtsenaro. Secueñaʼcaʼye all neretañ, amacaʼye eñalle. ");
INSERT INTO ameNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Allempoña mellañot̃eññapaʼ alla oterraneterr: —T̃eʼpaʼ oʼch ahuerres oʼch sotuer Pedro ñam̃a poʼpotantañ pueyochreshaʼ, Jesús oten oʼch ota oʼch ahuerr Galileo. C̈hoschaʼña ahuanmatsa sam̃a allochñapaʼ allchaʼ senter ñeñt̃ atet̃ otaseʼt̃ ahuaña. ");
INSERT INTO ameNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Allempoña coyaneshac̈hno atet̃ otaret̃tet all Jesús puepampro, ñetña c̈haʼnmac̈herretpaʼ matenacma ahuanerret poʼyorñot̃etpaʼ c̈ha yonshemaʼtyesnerret. Pom̃chañot̃et amaʼt eʼñe eseshapaʼ ama errot̃enayeʼ otenayeʼ entnerreto. ");
INSERT INTO ameNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ñehua, ahuat̃ecma tanterra Jesús añe yet̃ro allempo mot̃taʼmuenerr yet̃ñats temenc. Allempo tanterrapaʼ añ ñanom orrterra María Magdalena. Ñeñt̃ña Maríapaʼ canc̈herrsheña oneñet̃ ñeñt̃ chorrayeʼt̃ Jesúsñapaʼ eʼñe quec̈hpatam̃p̃satuer. ");
INSERT INTO ameNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maríañapaʼ allent̃a ahuoʼ oʼch otenanaʼ ñeñt̃ epuet yemteʼt̃ Jesús all puellquëñot̃et atarr yahuanrrortenet. ");
INSERT INTO ameNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ñetña allempo eʼmareʼchet oʼ tanterra Jesús, Maríapaʼ oʼcaʼye enter, ñetñapaʼ arepaʼtchaʼ ameʼñyeto. ");
INSERT INTO ameNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Poʼpocheño Jesúspaʼ eʼñe poʼpoñot̃ orrterrana epsheña pueyochreshaʼ allempo chopeñeʼchnenet allampañoʼmar. ");
INSERT INTO ameNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ñetñapaʼ allent̃a puerrerret oʼch otueret poʼpotantañ, arepaʼtchaʼña ameʼñaret̃tapuerreto ñeñt̃ atet̃ enteret ñamet Jesús. ");
INSERT INTO ameNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Poʼpocheño Jesúspaʼ alla orrterranerr pueyochreshaʼ c̈harrasheña ñeñt̃ puechetsa pat̃err all rrallmeʼchenet. Ñañapaʼ atet̃ cot̃apeʼchatuenanetpaʼ atet̃ otuenanet: —Sapaʼ esoʼmareʼtña ama sameʼñeñoña poʼpotantañ ñeñt̃ soteneʼ napaʼ oʼcaʼye netanterra t̃arroʼmar ñetpaʼ c̈hocaʼye enterrnet. T̃arraña sapaʼ amacaʼye es sec̈henoyo seyoc̈hro. ");
INSERT INTO ameNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Allempoña Jesúspaʼ atet̃ oterraneterr: —T̃eʼpaʼ oʼch auyeses ora errap̃aren allohuanen añ patser, seserrpareʼtach allohuen acheñeneshaʼ añ cohuen ñoñets alloch aʼqueshp̃ataret̃terret. ");
INSERT INTO ameNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Allohuen amaʼt erraʼtsena ñeñt̃chaʼ ameʼñerraya añ cohuen ñoñets ñam̃a ñeñt̃ pameʼñeñot̃etpaʼ apataret̃terretchaʼ ñetñapaʼ aʼqueshp̃ataret̃terretchaʼ. T̃arraña ñeñt̃chaʼ ama ameʼñerrtso, ñetñapaʼ amñaret̃terrach coñcheñtso. ");
INSERT INTO ameNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ñeñt̃chaʼ nameʼñerraya ñocpuetpaʼ norrtaterranetchaʼ nepartsoña. Eʼñe na nesoʼchñoch quec̈hpatyesetchaʼ oneñet̃ec̈hno, ñam̃a eñosyesetchaʼ poʼpoñeʼttsocma ñoñtso. ");
INSERT INTO ameNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ñam̃a ñerraʼm eʼñe potot̃et chetetchaʼ shechep̃, t̃arraña amach errot̃ p̃aneto; ñam̃a amaʼtchaʼ añ orret ñeñt̃ amtsañtetsa t̃arraña amach errot̃ p̃aneto. Ñam̃a ñerraʼm esempoch aʼp̃llaʼyeñet atsnañet̃, atsnañet̃ñapaʼ acrrerrocheʼch. ");
INSERT INTO ameNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Oʼña atet̃ otuanerranet Partseshaʼ Jesúspaʼ allent̃a aʼtapater Pompor pueʼntaño, allñapaʼ anorruen eʼñe Pompor poʼcohuenrot̃, all partsotapretuera. ");
INSERT INTO ameNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pueyochreshaʼñapaʼ ahuanomyeset, serrpareʼtyesnomuet errap̃aren. Partseshaʼ Jesúspaʼ c̈hocma t̃orrapretenanet, orrtatenanet poʼpartsoña att̃och acheñeneshaʼ eʼñech eñotenanet ñeñt̃ atet̃ serrpareʼtyenet, ñeñt̃paʼ eʼñe poʼñoc̈h Parets poʼñoñ. Ñeñt̃paʼ att̃etepaʼch Nompore. Allohua.");
INSERT INTO ameNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Masheñe Teófilo, p̃apaʼ peñoteñ ahuañmoʼchapaʼ paʼnamen esocmañen ñeñt̃ atet̃ etsotayeseʼt̃ Jesús acheñeneshesho ñeñt̃ eʼñe ñanom ameʼñaya ña, amaʼt t̃emeʼttsen yocpaʼnaña ñeñt̃ey oʼ yameʼñera yam̃a. Ñam̃a allempot̃eñ Jesúspaʼ orrtana paʼnamen acheñeneshaʼ ñeñt̃ entyesayeʼt̃ eʼñe allameʼtets. Ñetñapaʼ eʼñe entuoñeteʼt̃ allohuen ñeñt̃ atet̃ p̃aʼyeseʼt̃. Ñetñapaʼ serrpareʼtyeseteʼt̃ atet̃ oten Yompor poʼñoñ. Att̃ot̃ña eñotaterryetña yam̃a. Ñeñt̃ atet̃ eñotatyenet ñetpaʼ shonteʼ acheñeneshaʼ quellcaʼyesetañ ñeñt̃ atet̃ p̃osa Cristo allempo huapa. Ñeñt̃oʼmarña napaʼc̈hoʼña eʼñe pocteʼ nenteñ oʼch nequellconap̃ eʼñe ora allpon ñeñt̃ atet̃ orrtatos Jesús, t̃arroʼmar napaʼ ahuañmoʼchot̃eñ atarr noct̃apeʼcheñ oʼch eʼñe neñoch errot̃ent̃eʼña ñeñt̃ eʼñe poʼñoc̈h atet̃ p̃aʼyesosa Jesús. Ñeñt̃oʼmarña t̃eʼ arrpaʼ oʼch eʼñe neñotatap̃ ora allpon ñeñt̃ oʼ etsotua allochñapaʼ att̃och eʼñe peñotuer p̃am̃a ñeñt̃ allpon yec̈hatenpetpaʼ ñeñt̃paʼ eʼñe poʼñoc̈h atet̃. Ñehua, arrpaʼ atet̃ oʼ etsotua. ");
INSERT INTO ameNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ahuat̃ allempo añ am̃chaʼtaret̃tatseʼt̃ Herodes all anetso Judeo, eñall ñam̃a puesheñarr ñeñt̃ judioneshaʼ poʼcorneshar. Ñeñt̃paʼ añ paʼsoʼcheñ Zacarías ñeñt̃ c̈hocma yemtenana poʼpotantañ cornaneshac̈hno ñeñt̃ otenet Abíasonaʼtar ñeñt̃ t̃orratseʼt̃ Yompor paʼpacllo. Zacarías puet̃apor añ paʼsoʼcheñ Elisabet; ñapaʼc̈hoʼña corneshap̃nor ñeñt̃ poʼm̃reneñ pen Aarón ñeñt̃ corneshatatseʼt̃ ahuat̃. ");
INSERT INTO ameNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ñetña epsheñoʼmaretpaʼ Yomporñapaʼ eʼñe pocteʼ entenanet ñeñt̃ atet̃ penet ñet, eʼñe cohuen etsotueññañet ora poʼñoñ ñeñt̃ atet̃ anaret̃ ahuat̃ot̃eñ acheñeneshacop ñeñt̃chaʼ atet̃ p̃ohuenet. Ñeñt̃oʼmarña amaʼt puesheñarrapaʼ amach errot̃enot̃ otaret̃teto, “ama pocteyaye ñeñt̃ atet̃ sepena.” ");
INSERT INTO ameNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ñetpaʼ ama eñalleto amaʼt puesheñarra pacñeʼt̃er t̃arroʼmar Elisabetpaʼ ama achoyoreʼtañeyaye. Amaʼt ñam̃a puerrollar epsheñoʼmaret oʼ att̃a poʼnmeʼtuenet. ");
INSERT INTO ameNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Att̃eñapaʼ c̈hap allempo t̃orrena allohuen cornaneshac̈hno ñeñt̃ epuet parro yemtena Zacarías att̃o corneshatenet Yomporecop. Ñehua, allempopaʼ allohuen ñeñt̃ corneshatatseʼt̃ Yomporecop, ñetñapaʼ añ yec̈heteʼt̃ ahuoʼch yellsheñeʼchenet allohuenet att̃och eñochet poʼsuertot̃ erraʼtsenchaʼ puesheñarrer ñeñt̃chaʼ beʼt̃osets Yompor paʼpacllo allchaʼ aʼcrratan ñeñt̃chaʼ eñmosat̃tatsa Yomporecop. Allempoña pamt̃arrpaʼ aña orrtatsa Zacarías ñeñt̃chaʼ beʼt̃osets Yompor paʼpacllo allchaʼ aʼcrratan ñeñt̃chaʼ eñmosat̃tatsa Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ñehua, allempo c̈hap allempoch beʼt̃osos puesheñarr Yompor paʼpacllo shonteʼ acheñeneshaʼ ñetñapaʼ allach t̃omc̈haʼtet aʼyot̃ allchaʼ maʼyochrraʼtoset. Amaʼt allempo beʼt̃osos Zacaríaspaʼ att̃erach maʼyochrraʼtet aʼyot̃. ");
INSERT INTO ameNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ñehua, Zacarías allempo sherbenan Yompor oʼpono, allñapaʼ machayot̃epaʼtchaʼ orrtoña Yompor poʼm̃llañot̃eñer. Arr t̃omos altar poʼcohuenrot̃, ñeñt̃ altarpaʼ allecma aʼcrratenet ñeñt̃ eñmosat̃tetsa Yomporecop, ñeñt̃paʼ att̃o sherbeteʼt̃ Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Allempo orrtoña mellañot̃eñ, Zacaríasñapaʼ atarr yoren, atarr nanac mechaʼch. ");
INSERT INTO ameNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mellañot̃eññapaʼ atet̃ otosan Zacarías: —Zacarías, amach peyorenatsto t̃arroʼmar Yomporpaʼ eʼmuennap̃ ñeñt̃ atet̃ penamueñ pemaʼyocheñot̃. Ñeñt̃oʼmarña t̃eʼ pet̃apor Elisabetpaʼ eñalletaterranchaʼ pat̃err asheñorr ñeñt̃ eʼñe p̃o pechemer, ñeñt̃ñapaʼ pesochchaʼ Juan. ");
INSERT INTO ameNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","P̃apaʼ atarrchaʼ p̃ocshena nanac. Shonteʼch acheñeneshaʼ ñeñt̃chaʼ nanac p̃ocshapretaya att̃o oʼ eñalleta pechemer. ");
INSERT INTO ameNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ñapaʼ atarrchaʼ asherben enteñ Yompor. Ñapaʼ amach orrarñat̃eyaye, amaʼt vinosapaʼ amach orreñe. Amaʼt ñam̃a paʼnamen ñeñt̃ aposaʼtpotetsapaʼ amach orreñe amaʼt mamesha. Ñapaʼ eʼñech aña chorraya Parets Puecamquëñ. Amaʼt allempot̃eñ pachor paʼt̃oʼtsen ñapaʼ eʼñech chorreña Parets Puecamquëñ. ");
INSERT INTO ameNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Allempoña mellañot̃eñpaʼ alla otererr: —Ñapaʼ cohuenchaʼ cot̃apeʼchaterran shonteʼ israelenaʼtarneshaʼ allochñapaʼ att̃och cot̃apeʼcherret eʼñe cohuen Yomporecop ñeñt̃chaʼ Poʼpartseshar perret. ");
INSERT INTO ameNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ñeñt̃ña Juanpaʼ ñeñt̃chaʼña ñanom orrtatsa Yomporecop. Ñapaʼ añchaʼ ahuamencat̃ peneʼ Yompor Puecamquëñ atet̃ peʼt̃ ahuat̃ Elías ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ. Allochñapaʼ att̃och eʼñe cohuen amoʼtstaterrana achemeret̃ec̈hno puechemereshaʼ. Allochñapaʼ amaʼt ñeñt̃ at̃pareʼtetsapaʼ oʼch ameʼñaterranet ñeñt̃ eʼñe pocteʼ es pets. Att̃ochña cot̃apeʼchaterranet cohuen, allochñapaʼ att̃och agapueret Partseshaʼ ñerraʼm esempoch orrta. ");
INSERT INTO ameNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacaríasñapaʼ ahuoʼ aʼp̃t̃oʼtan mellañot̃eñ, ahuoʼ och: —Taʼ, ¿errot̃enochña neñoch eʼñet̃eʼ poʼñoc̈h oʼch eñalleta cheshat̃oll? T̃arroʼmar napaʼ oʼ nepoʼnmeʼten; net̃aporpaʼc̈hoʼña eʼñe att̃ecmay oʼ atarr yepoʼnmeʼtuen. ");
INSERT INTO ameNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mellañot̃eññapaʼ alla otererr: —Napaʼ ñeñt̃en Gabrieletets ñeñt̃en sherbeneʼ Yompor. Napaʼ ña nellsenseneʼ att̃och neʼñoranaʼtap̃a oʼch neñotatap̃ añ cohuen ñoñets. ");
INSERT INTO ameNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","T̃arraña p̃apaʼ ama p̃ameʼñenno ñeñt̃ atet̃ notenep̃, ñeñt̃oʼmarña t̃eʼ p̃apaʼ oʼch p̃oʼpanat, amach eshec peʼñorerro t̃ayot̃eñ t̃arrempohuach allempoch eñalleta pechemer, allempochña peʼñorerra. T̃arroʼmar poʼñoc̈h etsoterrach ñeñt̃ atet̃ oʼ notuap̃ oʼch c̈hap allempo onañcharet̃. Arrpaʼ allohua ñeñt̃ atet̃ ot mellañot̃eñ. ");
INSERT INTO ameNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Att̃oʼ ellapes Zacarías oʼponopaʼ acheñeneshaʼñapaʼ cohueñet aʼyot̃ ama c̈haʼnerro. Att̃oʼ cohueñetpaʼ otannaʼtet: —¿Esoʼmart̃eʼ amoʼ c̈haʼnerroña Yompor paʼpacllot̃? ");
INSERT INTO ameNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Allempoña c̈haʼnerrpaʼ ama eshcayeʼ eñoranaʼtuerraneto. Ñetñapaʼ otyenet pueyoc̈hreto, ñatoʼ c̈hot̃eʼ es orrtoya Yomporecop ñeñt̃oʼmart̃eʼña atarr ellapes oʼpono Yompor paʼpacllo. Ñañapaʼ ama eshcayeʼ eñoranaʼtuerraneto, potot̃a eñotatuerranet ñeñt̃ atet̃ ent Yompor paʼpacllo. ");
INSERT INTO ameNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Allempoña oʼ c̈hap allponmat ñeñt̃ att̃o sherbenet Yompor paʼpacllo, Zacaríasñapaʼ oʼ ahuerr paʼpacllo. ");
INSERT INTO ameNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Eʼñe allponmatatsapaʼ oʼ ac̈homenta puet̃apor. Allempot̃eñña Elisabetpaʼ ama mueno oʼch orrterra acheñeneshesho. Amaʼt oʼ amnarm̃a arrorrpaʼ ñañapaʼ ama orrteno. Ñañapaʼ atet̃ oten: ");
INSERT INTO ameNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—T̃eʼñapaʼ atarr cohuen mueraʼna Yepapar, allochñapaʼ oʼhuañchaʼ alloʼna pencnaʼntatnennet t̃arroʼmar napaʼ otyennet muec̈hopenoʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Allempoña oʼ pechapm̃a arrorr ac̈homenta Elisabet, Yomporñapaʼ oʼ alla mueñerranerr poʼm̃llañot̃eñer ñeñt̃ara Gabriel. Arr mueñe anetso Nazareto ñeñt̃ara Galilea. ");
INSERT INTO ameNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Allempoña c̈hap Nazareto, allñapaʼ orrtosana puesheñarr shopsheshaʼ ñeñt̃ ama aʼp̃llaret̃eyaye. Ñehua, ñeñt̃ shopsheshaʼpaʼ añ oʼpatenaya yacma ñeñt̃paʼ añ paʼsoʼcheñ José, ñoʼch yoreʼ. Ñeñt̃ña shopsheshaʼ arrot̃ eñalletña David poʼm̃renñot̃; ñeñt̃paʼ añ paʼsoʼcheñ María. ");
INSERT INTO ameNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mellañot̃eñña allempo c̈hap eʼñe ñeshopaʼ atet̃ otos: —Oʼch noc̈ha nehuom̃chaʼtosep̃. Yompor eʼñe puemuereñot̃ep̃ p̃apaʼ atarrchaʼ coshaterrep̃, ñapaʼ eʼñe peshoʼtsen. Yomporpaʼ atarr bensareʼtam̃penep̃. Ello pem̃tanaʼtueñ allohuen p̃acmaneshaʼ att̃o bensareʼtam̃penanet ñet. ");
INSERT INTO ameNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Allempo eʼman atet̃ och mellañot̃eñ, ñañapaʼ c̈ha moññeʼtacha, c̈ha cot̃apeʼch pueyoc̈hro: —Taʼ, ¿est̃eʼ otenenña ñeñt̃ atet̃ huom̃chaʼtenen? ");
INSERT INTO ameNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mellañot̃eññapaʼ alla otererr: —María, amach pem̃chaʼtatsto, Yomporpaʼ atarr oʼ morrenterrp̃a. ");
INSERT INTO ameNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","T̃eʼpaʼ p̃ac̈homentach, pechyoreʼtchaʼ ñeñt̃paʼ asheñorrchaʼ. Ñeñt̃ñapaʼ pesochchaʼ JESÚS. ");
INSERT INTO ameNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ñeñt̃chaʼ nanac am̃chaʼtaret̃tatsa. Otyesetchaʼ ñapaʼ ña Ñeñt̃ Nanac Parets Puechemer. Pomporña ñeñt̃ara Paretspaʼ ñachña neʼ am̃chaʼtaret̃ atet̃ am̃chaʼtaret̃teʼt̃ paʼtañ David. ");
INSERT INTO ameNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Att̃eña ñapaʼ am̃chaʼtaret̃tach Jacob poʼm̃renñecop ñeñt̃ara israelneshaʼ. Amaʼt errponañapaʼ amach huañerro ñeñt̃ att̃o am̃chaʼtaret̃tena ña. ");
INSERT INTO ameNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maríañapaʼ atet̃ otapan mellañot̃eñ: —Taʼm ¿errot̃enot̃chaʼña nechyoreʼtña? Napaʼ amaʼt puesheñarra encaneshaʼ amarramtso yorennaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mellañoteññapaʼ alla otererr: —Paretschaʼcaʼye Puecamquëñ pec̈hapoya. Ñeñt̃ Nanac Parets poʼhuamencpaʼ aʼpomam̃p̃sosep̃chaʼ atet̃ ñerraʼmrrat̃eʼ os p̃aʼpomam̃peneʼ. Ñeñt̃oʼmarña cheshat̃oll ñeñt̃chaʼ peʼñalletatpaʼ ñapaʼ añach eʼñe maʼyoc̈hrosa ñeñt̃ atet̃ muenen Parets. Otyesetchaʼ ñapaʼ ña eʼñe Yompor Puechemer. ");
INSERT INTO ameNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ñam̃a Elisabetña ñeñt̃ p̃amoʼts pepen, ñapaʼc̈hoʼña oʼ t̃otana asheñorrot̃oll, amaʼt oʼ poʼnmeʼten. Ñam̃a amaʼt oteñet muec̈hop̃paʼ t̃eʼñapaʼ oʼ pechapm̃a arrorr oʼ ac̈homenta. ");
INSERT INTO ameNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","T̃arroʼmar Yomporpaʼ ama eñalle ñocop ñeñt̃ atarr t̃orrapoʼ enten. ");
INSERT INTO ameNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Allempoña Maríapaʼ alla oterranerr mellañot̃eñ: —Ñehua, napaʼ eʼñe pocteʼ nenteñ oʼch nesherber Yepapar ñeñt̃ Nepartseshar nepen. Ñeñt̃paʼ att̃etepaʼch nocop ñeñt̃ atet̃ p̃otenen. Allempoña mellañot̃eñpaʼ oʼ ahuerr. ");
INSERT INTO ameNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Maríañapaʼ allent̃a ahuoʼ pomaʼyorñecma oʼch emoʼtenanaʼ Elisabet. All yec̈henapaʼ all shonteʼ aspent̃arer allara Judeo. Allempoña c̈hap anetso all sechenapaʼ beʼt̃osos Zacarías paʼpacllo, huom̃chaʼtosan Elisabet. ");
INSERT INTO ameNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ñañapaʼ allempo eʼmapan María ñeñt̃ atet̃ huom̃chaʼtospaʼ pueʼmaret̃ollña ñeñt̃ paʼt̃oʼtsenpaʼ allent̃epaʼtchaʼ pella. Pachorñapaʼ eʼñe chorreña Parets Puecamquëñ. ");
INSERT INTO ameNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ñeñt̃ña eñorateneʼ, pocsheñeshocmañen eñorena huomencpaʼ atet̃ otapan María: —P̃apaʼ oʼ atarr coshaterrep̃ Yepapar. P̃apaʼ oʼ eʼñe pem̃tanaʼtue ora allohuen yacmaneshac̈hno att̃o coshatenanet ñet Yepapar. Ñam̃a Yepaparpaʼ atarrchaʼ bensareʼtam̃pennap̃ pechoyoret̃oll. ");
INSERT INTO ameNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Amaʼt na Yepaparpaʼ atarr coshatenen att̃o pemoʼtenen amaʼt ñeñt̃ep̃ pachor pen ñeñt̃chaʼ Yepartseshar yeperr. ");
INSERT INTO ameNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","T̃arroʼmar eʼñe allempocma neʼmaponap̃ peñoñ atet̃ pehuom̃chaʼtosen, neʼmaret̃ollpaʼ eʼñe pocsheñeshot̃paʼ allent̃epaʼtchaʼ pella nat̃o. ");
INSERT INTO ameNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","P̃aña t̃eʼpaʼ atarr cosheñtsoʼtsenep̃ t̃arroʼmar p̃apaʼ eʼñe p̃ameʼñaʼhuoña ñeñt̃ atet̃ otuenp̃aʼ Yepapar. Ñeñt̃oʼmarña ñeñt̃paʼ eʼñech atet̃ etsoterra p̃ocop. ");
INSERT INTO ameNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maríañapaʼ alla otererr: —T̃eʼñapaʼ eʼñech neyoc̈hrocmañen naʼyeʼchoc̈htatoñ Yepapar. ");
INSERT INTO ameNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Necamquëñohuen atarr nocsheña Yepapar ñeñt̃ Yaʼqueshp̃atañer yepen. ");
INSERT INTO ameNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Yepapar eʼñe puemuereñot̃en ñapaʼ entenen ama esoyayno, añana ñeñt̃en t̃orretsa ñocop. T̃arraña t̃eʼpaʼ allohuen acheñeneshaʼ ñeñt̃chaʼ mererrtsa arr patsro ñetñapaʼ atarrchaʼ coshapreterrnet att̃o Yepaparpaʼ oʼ atarr coshaterren na. ");
INSERT INTO ameNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","T̃arroʼmar ñapaʼ ñeñt̃ atarr ahuamencat̃tetsa att̃oña oʼ orrtaton ñeñt̃ nanac sherbets, ñeñt̃ara Yepapar ñeñt̃ otenet Ñeñt̃ atarr nanac Parets. ");
INSERT INTO ameNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Allohuen ñeñt̃ am̃chaʼnaʼtpoʼ enteneʼ Yepapar, ñañapaʼ c̈hocmach atarr muererranet amaʼt t̃ayot̃eñ errponañohuen amaʼt allpon allohuen acheñeneshaʼ ñeñt̃chaʼ mererrtsa arr patsro. ");
INSERT INTO ameNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ñam̃a ñapaʼ eʼñe etsotuenan amaʼt ñeñt̃ atarr nanac echarr entyenet, ñam̃a allpon allohuen acheñ ñeñt̃ atarr asherben entyetsa, ñañapaʼ eʼñech pomnaren p̃ohuerranet. ");
INSERT INTO ameNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ñam̃a ñeñt̃ atarr ahuamencat̃ entyetsa ñañapaʼ eʼñech aʼsuatanrrortatuerranet allot̃ am̃chaʼtaret̃tenet. T̃arraña ñeñt̃ ama esosheʼmayeʼ entyetsopaʼ ñetñapaʼ Yepaparchaʼ nohuerrahuet att̃ot̃chaʼ am̃chaʼnaʼtpoʼ enter allohuen acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ñam̃a ñeñt̃ nanac es palltaʼyetsa, ñetñapaʼ Yepaparchaʼ esocmañen aphuerrahuet. T̃arraña ñeñt̃ atarr esocmaneñ es echyets, ñetñapaʼ Yepaparchaʼ puerratam̃pesuerrahuet, amach es anerreto amaʼt coñeʼt̃a. ");
INSERT INTO ameNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Yepaparpaʼ añach c̈hocma yenpuen israelenaʼtar ñeñt̃ pueyochreshaʼ pen ña. Amach pueserrano ñeñt̃ atet̃ otaneʼt̃ ahuat̃ yamoʼmtayñeneshañ ñeñt̃chaʼ atet̃ perranet ñam̃a allohuen ñeñt̃chaʼ poʼm̃reneñ perret. Eʼñe atet̃ otaneʼt̃ ahuat̃ Abraham poʼm̃renñecop. Att̃och c̈hocma muerenanet amaʼt errponohuañen. Arrpaʼ allohua ñeñt̃ atet̃ ac̈hotan María Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Allempoñapaʼ ñatoʼ maʼpm̃at̃eʼ arrorr alla aʼpa Elisabetesho. Allot̃ña Maríapaʼ ahuerr paʼpacllo. ");
INSERT INTO ameNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Allempoña c̈hap allempoch emareʼten Elisabet. Ñeñt̃ña pueʼmarpaʼ asheñorrot̃oll. ");
INSERT INTO ameNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Allohuen acheñeneshaʼ ñeñt̃ yec̈hetsa all ñesho ñam̃a allohuen pamoʼtseshaʼ ñetñapaʼ eʼñe coshaprechet. T̃arroʼmar eñoteñet Yomporpaʼ oʼ orrtatoñ att̃o ñapaʼ atarr muereña. ");
INSERT INTO ameNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Allempoña oʼ posocmataʼmuen ñeñt̃ña asheñorrot̃ollpaʼ oʼ tsorrat̃olleʼtaʼmueñet t̃arroʼmar ñetpaʼ atet̃caʼye yec̈henet ñeñt̃et judioneshet. Allempopaʼ añ sochetañ Zacarías oʼch anmatoñetañ pompor paʼsoʼcheñ. ");
INSERT INTO ameNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","T̃arraña pachorpaʼ otanet: —Napaʼ ama nemno oʼch sesochon neʼmar Zacarías. Napaʼ añchaʼ nesoch Juan. ");
INSERT INTO ameNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Allempoña acheñeneshaʼpaʼ atet̃ ochet: —¿Esoʼmareʼt pemneñña oʼch pesoch Juan t̃arroʼmar amaʼt puesheñarra p̃amoʼtspaʼ ama eñalle ñeñt̃ sochetsa Juan? ");
INSERT INTO ameNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Allempoña acheñeneshaʼpaʼ eʼñe potot̃eta aʼp̃t̃oʼtoñet emat̃oll pompor eschaʼ sochanña puechemeret̃oll. ");
INSERT INTO ameNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ñapaʼc̈hoʼña potot̃a eñotatan acheñeneshaʼ oʼch apet quellcatets allchaʼ quellcan ñeñt̃chaʼ sochan puechemeret̃oll. Allempoñapaʼ apet quellcatets, allñapaʼ atet̃ quellcaʼ: “Añchaʼ yesoch Juan.” Acheñeneshaʼñapaʼ att̃a cohuanrrorchet. ");
INSERT INTO ameNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Eʼñe allempocma Zacaríasñapaʼ allent̃a eñorerra. Allorocma ayeʼchoc̈htaterran Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Acheñeneshaʼña ñeñt̃ yec̈hetsa allpaʼ allohuenet atarr mechaʼnaʼteñet Yompor. Ñetñapaʼ serrpareʼtatannaʼtyeset all aspent̃arero Judeo. ");
INSERT INTO ameNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ñam̃a amaʼt allohuen ñeñt̃ eʼmareʼtyeseʼ ñetñapaʼ cot̃apeʼchyeset pueyoc̈hreto, atet̃ otyenet: —Añ cheshat̃ollpaʼ poʼñoc̈hchaʼ atarr sherberran Yompor tsapat̃onet̃. T̃arroʼmar Yomporpaʼ atarr muereña. ");
INSERT INTO ameNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Cheshat̃ollña pompor ñeñt̃ Zacaríaspaʼ añ chorrenaya Parets Puecamquëñ ñeñt̃ña eñoraterreʼ Yomporecop ñeñt̃chaʼ atet̃ perra amaʼt esempo. Ñeñt̃paʼ atet̃ ot Zacarías: ");
INSERT INTO ameNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Ayeʼchoc̈htaterrapoʼch Yompor, ñeñt̃ara ñeñt̃ Poʼpartseshar pen allohuen israelneshaʼ, t̃arroʼmar t̃eʼñapaʼ oʼ orrtaterrnay puemuereña ñeñt̃chaʼ yaʼqueshp̃aterreʼ ñeñt̃ey puechemer pen. ");
INSERT INTO ameNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ñapaʼ oʼ orrtatonay ñeñt̃chaʼ aʼqueshp̃atañterrtsa ñeñt̃ atarr ahuamencat̃eshaʼ ñeñt̃ara ñeñt̃chaʼ eñalletatsa David poʼm̃renñot̃, ñeñt̃ara David ñeñt̃ atarr sherb̃ayeʼt̃ ahuat̃ Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ñeñt̃paʼ ahuat̃ot̃eñ atet̃ eñoratyesaneʼt̃ ñeñt̃ aʼm̃taʼyesayeʼt̃ poʼñoñ, amaʼt allohuen ñeñt̃ eʼñe maʼyoc̈hraʼyestseʼt̃ Partsocop. ");
INSERT INTO ameNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Amaʼt ñam̃a allohuen allpon ñeñt̃ yeʼmoñeʼteneʼ ñeñt̃ am̃chaʼnoc̈hetyetsa yocop, ñachña yaʼrroyataterreʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Att̃ochña etsotaterrnay ñeñt̃ atet̃ otaneʼt̃ ahuat̃ yatañneshañ ñeñt̃chaʼ att̃o c̈hocma muererrya. Att̃eña ñapaʼ amach pueserrano ñeñt̃ atet̃ aʼpoctat ahuat̃ot̃eñ yocop t̃arroʼmar ñeñt̃paʼ eʼñe Partseshot̃ aʼpoctataret̃ta. ");
INSERT INTO ameNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ñehua, añpaʼ atet̃ p̃a allempo Yomporpaʼ ahuat̃ otan yatañ Abraham ñeñt̃chaʼ atet̃ perrnay eʼñe poʼñoc̈h. ");
INSERT INTO ameNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ñeñt̃paʼ atet̃ oteʼt̃ Yompor yocop amaʼt ñeñt̃ allpon ñeñt̃ yeʼmoñeʼteneʼ ñeñt̃ am̃chaʼnoc̈hen yentyen ya, ñañapaʼ ñach yaʼrroyataterreʼ. Allochña yapaʼ oʼhuañchaʼ yem̃chaʼnañot̃ yesherber Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Att̃och yetsotoñ ñeñt̃ eʼñe pocteʼ enten Parets allochñapaʼ att̃ochña pocteʼ enteney ñam̃a acheñeneshaʼ att̃o eʼñe cohuen es yep̃aʼyen eʼñech t̃arrempohua esempohuach yocrrena arr patsro. ");
INSERT INTO ameNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","T̃eʼpaʼ oʼch nechemeret̃olle notap̃: P̃apaʼ oterrpetchaʼ ñeñt̃ep̃oʼ ñeñt̃chaʼ eñoranaʼtena ñeñt̃ nanac Parets. T̃arroʼmar p̃apaʼ p̃anomchaʼ orrtatsa att̃och p̃aʼcohuentatyesoñ allchaʼ oñmos Partseshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ñeñt̃paʼ att̃och p̃oct̃apeʼchater acheñeneshaʼ eʼñe cohuen allochña ñetpaʼ eshecchaʼ ap̃retnaret̃terret poʼchñaret att̃och aʼqueshp̃ataret̃terret. ");
INSERT INTO ameNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","T̃eʼpaʼ c̈hapchaʼ allempoch Yompor eʼñe puemuereñot̃ey c̈hapaterrnaychaʼ ñeñt̃ huetsa entot̃ ñeñt̃chaʼ yoct̃apeʼchaterreʼ eʼñe cohuen, ñeñt̃ña cot̃ap̃ñatserpaʼ ñeñt̃chaʼ yaʼpuetarsam̃perreʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Att̃ochña aʼpuetarsam̃p̃saret̃terra allohuen acheñeneshaʼ ñeñt̃ checmetoʼtsaʼyeneta, ñeñt̃ ama eñotenaye Yompor, ñetñapaʼ aña oʼpatenahuet rromueñets ñeñt̃ara coñcheñets. Ñeñt̃ att̃o aʼpuetarsam̃p̃saret̃ey ñeñt̃chaʼña yeñotateneʼ att̃och eʼñe cohuen yocsheñeshocmañen yeyc̈hena arr patsro. Arrpaʼ allohua huañ att̃o Zacaríaspaʼ ac̈hotenan Yompor eʼñe pocsheñeshocmañen. ");
INSERT INTO ameNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Añña cheshat̃oll Juanpaʼ alloʼna sen atarretnomtsa. Puecamquëñot̃paʼ atarr ahuamencat̃etnena. Ñañapaʼ alla yec̈hena allap̃ar amayo t̃arrempohua allempo orrta israelenaʼtarneshesho. ");
INSERT INTO ameNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Allempopaʼ añ am̃chaʼtaret̃tatseʼt̃ romoʼmarneshaʼ ñeñt̃paʼ añ paʼsoʼcheñ Augusto. Ñañapaʼ nenan poʼñoñ ñeñt̃paʼ atet̃ oten: Allohuen acheñeneshaʼ errap̃aren añe patsropaʼ quellcatyesetepaʼ paʼsoʼcheñ. ");
INSERT INTO ameNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ñehua, allempo ñanom quellcatyeset paʼsoʼcheñpaʼ, arrña anets Siriapaʼ añ am̃chaʼtaret̃tetsa ñeñt̃paʼ añ paʼsoʼcheñ Cirenio ñeñt̃ paʼm̃chaʼtaret̃er pen allohuen judioneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ñehua, allohuenet ahuanerret paʼtañneshaʼ paʼnetsro allochñapaʼ allchaʼ quellcatyerretaʼ paʼsoʼcheñ. ");
INSERT INTO ameNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ñeñt̃oʼmarña Josépaʼ on Nazaretot̃ allara anets Galileo, oʼch ahuoʼ all paʼnetser peʼt̃ paʼtañneshañ, ñeñt̃ña anetserpaʼ añ paʼsoʼcheñ Beléñ, allara Judeo, t̃arroʼmar Beléño eñalleta ahuat̃ paʼtañ David. T̃arroʼmar Josépaʼ Davidnaʼtarcaʼye. ");
INSERT INTO ameNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Allempoña Josépaʼ ahuoʼ epuet María oʼch quellcatenetaʼ paʼsoʼcheñ. Maríapaʼ José oʼpatenaya ñoʼch yoreʼ. Allempoña Maríapaʼ ac̈homenepaʼtoʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Allempoña alloʼtsaʼyenet Beléño, Maríañapaʼ ahuepaʼt c̈hen allempoch emareʼten. ");
INSERT INTO ameNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Alla emareʼt, ñeñt̃ña pueʼmaret̃ollpaʼ asheñorrot̃oll ñeñt̃ eʼñe poʼmot̃er p̃aʼ. Epeʼ poʼñoʼmopaʼ alla p̃anat̃olleʼch huacshepahuo allot̃ecma apueñet huaquësh puerrar. Ñehua, t̃arroʼmar alla emareʼtos huacshepahuoñaʼ muetsopahuopaʼ ama eseshaʼ epatso eʼñe poctacma eshepena acheñ ñeñt̃ manrraʼtosets all. ");
INSERT INTO ameNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Allempo emareʼten María all Beléño ñeñt̃e tsaprocma allampañoʼtsen ñam̃a ñeñt̃ cohuam̃peneʼ poʼcarrneror pastemo. ");
INSERT INTO ameNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Allñapaʼ machayot̃epaʼtchaʼ orrtanet Yompor poʼm̃llañot̃eñer, c̈ha poptanaʼtosanet. Ñeñt̃paʼ Yompor poʼcohuenña ñeñt̃ c̈ha aʼpuetarsam̃p̃sosahuet. Ñetñapaʼ atarr nanac mechaʼtrraʼtapet. ");
INSERT INTO ameNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mellañot̃eññapaʼ otosanet: —Amach sem̃chaʼtatsetno c̈hoña seʼm̃ñoten na, oʼch neñotatoses ñeñt̃chaʼ atarr socshaterreʼ sa amaʼt ñam̃a allohuen errap̃aren acheñeneshacop. ");
INSERT INTO ameNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","T̃eʼpaʼ socop oʼ eñalleta ñeñt̃chaʼ Saʼqueshp̃atañer seperr ñeñt̃paʼ ñeñt̃chaʼ Cristotats ñeñt̃ Yepartseshar yepen. Ñeñt̃ña cheshat̃ollpaʼ arr eñalleta David paʼnetsro allara Beléño. ");
INSERT INTO ameNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","T̃eʼpaʼ oʼch noterrserr att̃och señoch ñeñt̃ cheshat̃oller. Ñeñt̃chaʼ sentos cheshat̃oll ep̃aret̃ poʼñoʼmo all p̃anat̃olleʼteñet huacshepahuo, ñeñt̃caʼyeña Yompor Puechemer. ");
INSERT INTO ameNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Allempoñapaʼ machayot̃epaʼtchaʼ orrterrerr poʼpotantañ shonteʼ mellañot̃eñneshaʼ ñeñt̃ oʼ sohuac̈herrerr entot̃. Ñeñt̃ña mellañot̃eñneshaʼpaʼ atarr ayeʼchoc̈htatosñañet Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Atet̃ otoset: ¡Ayeʼchoc̈htaterrapoʼch Yeyomporer ñeñt̃ pueʼntañoʼtsen! Amaʼt ñam̃a acheñeneshaʼ ñeñt̃ añe patsroʼtsen coshaʼrrtetepaʼ ñamet ñeñt̃ coshaten Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Allempoña mellañot̃eñneshaʼpaʼ sohuaneret ñeñt̃ cohuam̃peneʼ poʼcarrneror, ñetñapaʼ oʼ ahuanerret pueʼntaño. Allempoña ñeñt̃ cohueneʼ poʼcarrnerorpaʼ allent̃a otannaʼtyeset: —Errot̃enuacaʼyeña ñeñt̃ otenyaʼ Yompor. Oʼch ahuey Beléño oʼch yenteñaʼ ñeñt̃ atet̃ otenyetaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Allempoñapaʼ pomaʼyorñecma ahuanmuet, oʼña c̈hapuet Beléñopaʼ all entoset María ñam̃a José ñam̃a cheshat̃oll all p̃anat̃olleʼtena huacshepahuo. ");
INSERT INTO ameNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","18","Allempo entoset ñetñapaʼ serrpareʼtoset ñeñt̃ atet̃ oʼ otuenanetaʼ mellañot̃eñ cheshat̃ollecop. Allohuen ñeñt̃ eʼmueneʼpaʼ nanac cohuanrroretyeset, otannaʼtyeset: —Taʼm errot̃enot̃t̃eʼñacaʼ oʼ serrpareʼtosña atet̃. ");
INSERT INTO ameNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maríañapaʼ eʼñe ñeñt̃a nen pueyoc̈hro eʼñe ñeñt̃a cot̃apeʼchen ñeñt̃ allpon oʼ entua ahuañot̃eñ. ");
INSERT INTO ameNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Allempoña ñeñt̃ cohueneʼ poʼcarrnerorpaʼ oʼ ahuanerret. Atet̃ otenanetaʼ mellañot̃eñneshaʼpaʼ ñetñapaʼ eʼñe poʼñoc̈h entoset. Allpon ñeñt̃ atet̃ eʼmuet, amaʼt ñam̃a ñeñt̃ atet̃ entet, ñeñt̃oʼmarña ñetpaʼ eʼñe paʼyeʼchoc̈htateñeshet ahuanerret, att̃oña ñetpaʼ atarr cohuentatnerrñañet Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ñehua, allempoña oʼ posocmataʼmuen, ñeñt̃ asheñorrot̃ollpaʼ oʼ tsorratat̃olleʼchet, ñeñt̃paʼ atet̃ yec̈henaña allohuen judioneshaʼ. Allempo ñeñt̃ña cheshat̃ollpaʼ oʼ sochet JESÚS. Ñehua, ñeñt̃ soʼchñets ñeñt̃paʼ atet̃ otenanaʼ mellañot̃eñ María amaʼt ahuañmoʼchot̃eñ allempo ama ac̈homentenaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Allempoña c̈hap allempoch aʼpoctachet ñeñt̃ atet̃ naneʼt̃ Moisés poʼñoñ ñeñt̃chaʼ atet̃ yec̈haʼ judioneshaʼ. Ñehua, ñeñt̃ña ñoñetspaʼ atet̃ oten: “Ñerraʼm esempoch cheyoreʼten coyaneshaʼ, ñerraʼm asheñorr pueʼmaret̃oll ñeñt̃ eʼñe poʼmot̃erpaʼ neñetepaʼ Partsocop.” Ñam̃a poʼpoñ Moisés poʼñoñ ñeñt̃ atet̃ neʼt̃, ñeñt̃paʼ atet̃ oten: “Muetsatenetepaʼ epm̃a arot amapaʼ epm̃a yepec̈hoʼyeʼ ñeñt̃chaʼ net Yomporecop.” Ñeñt̃oʼmarña allempo c̈hap allempoch aʼpoctatet Yomporecop ñeñt̃ atet̃ anaret̃ poʼñoñ, ñeñt̃ña cheshat̃ollpaʼ allent̃a anmet Jerusaléño, allchaʼ aʼpoctachet Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","27","Allempoña c̈hapuet Jerusaléñopaʼ oʼ beʼt̃ososet Parets paʼpacllo att̃och aʼpoctatenetaʼ ñeñt̃ atet̃ yec̈henet ñeñt̃ atet̃ oten ñoñets ñeñt̃ anaret̃ ahuat̃ot̃eñ. Allñapaʼ huapa puesheñarr yacma añ paʼsoʼcheñ Simeón ñeñt̃paʼ jerusaléñoʼmarneshaʼ. T̃arroʼmarña ñapaʼ allempocma huapañaʼ ñapaʼ añ eñotateʼ Parets Puecamquëñ. T̃arroʼmar ñeñt̃ acheñerpaʼ atarr cohuen ñeñt̃ atarr maʼyoc̈hrenaya ñeñt̃ cohuentetsa Yomporecop. Ñapaʼ ñeñt̃ atarr cohueneʼ esempoch huapa ñeñt̃chaʼ aʼrroyataterreʼ israelenaʼtarneshaʼ allochñapaʼ oʼch alla atarr cosherret. Att̃o c̈hapoña Parets Puecamquëñ ñeñt̃ña eñotateneʼ ñapaʼ amach rromuenaʼpaʼ enterranchaʼ Yompor Puechemer ñeñt̃ Cristo ñeñt̃chaʼ llesenserr esempo. ");
INSERT INTO ameNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Huaptsapaʼ allent̃a enatat̃olleʼtosan cheshat̃oll, atarr ayeʼchoc̈htatosan Yompor. Ñeñt̃paʼ atet̃ otos: ");
INSERT INTO ameNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","T̃eʼña poʼñoc̈h Nompore amaʼtchaʼ nerromapaʼ eʼñech nocsheñeshocmañen nerroma t̃arroʼmar t̃eʼpaʼ poʼñoc̈h oʼ nenterrnap̃ ñeñt̃ oʼ pemñerrnay ñeñt̃chaʼ yaʼqueshp̃aterreʼ eʼñe atet̃ p̃otneʼt̃ ahuañmoʼchot̃eñ na ñeñt̃en atarr pesherbeneʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ñeñt̃ña oʼ p̃orrtaterrnay allohuenacpay ñeñt̃ey paʼnameney acheñeneshacpay añe patsro. ");
INSERT INTO ameNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ñapaʼ ñach sherberrets atet̃ ñerraʼmrrat̃eʼ puetareʼ ñeñt̃chaʼ aʼpuetarsam̃perreʼ allohuen acheñeneshaʼ amaʼt ñeñt̃ ama israelenaʼtareyaye att̃och ñetpaʼc̈hoʼña oʼch eñoteret ñeñt̃chaʼ aʼqueshp̃atañterrtsa eʼñe poʼñoc̈h. Allochñapaʼ att̃ot̃chaʼ eʼñe cohuen ayeʼchoc̈htaterrnap̃ ñam̃a peyochreshac̈hno ñeñt̃ara israelenaʼtarneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ñeñt̃ña pamoʼmteʼ pen cheshat̃ollpaʼ ñetñapaʼ att̃a cohuanaʼteñet Simeón atet̃ eñoranaʼtenanet pueʼmaret̃ollet. ");
INSERT INTO ameNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Oʼ eñoranaʼtuanet pueʼmaret̃olletpaʼ allempoñapaʼ enamatanet ñamet ñocpuet Yompor paʼnateña. Allempoñapaʼ otoñ pachor María, ñeñt̃paʼ atet̃ och: —Peñochepaʼch añ cheshat̃oll ñeñt̃paʼ ñeñt̃ña onañcheʼt̃ ahuat̃ Yompor. Ñocoppaʼ shonteʼch israelenaʼtarneshaʼ ñeñt̃chaʼ ama ameʼñerrayo ñeñt̃chaʼ chenquërrtsa. T̃arraña eñall ñam̃a shonteʼ poʼpotantañ ñeñt̃chaʼ ameʼñerraya ñeñt̃chaʼ cohuenoʼtsenterrtsa. T̃arroʼmar Pomporpaʼ añecopña mueñer allochñapaʼ ñach eñotaterrahuet ñapaʼ Pomporeshot̃ huapa. T̃arraña shonteʼch acheñ ñeñt̃chaʼ achm̃areʼterreʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","P̃apaʼ ñeñt̃chaʼña atarr pellcaterreʼña p̃a. Atarrchaʼ atserr peʼmuerr pellquëña eʼñech atet̃ peʼmuerr puellquëña atet̃ ñerraʼmrrat̃eʼ cochllo patenpet peyoc̈hro. Elloña puesheñaʼtetspaʼ eñotaterranetchaʼ errot̃ent̃eʼ ñeñt̃ atet̃ cot̃apeʼchyenet pueyoc̈hreto. ");
INSERT INTO ameNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Allñapaʼ alloʼtsen ñam̃a puesheñarr coyaneshaʼ ñeñt̃paʼ añ paʼsoʼcheñ Ana ñeñt̃ecma aʼm̃teneʼ Yompor poʼñoñ. Ñapaʼ añoʼ poʼseñ ñeñt̃ sochetsa Fanuel, ñeñt̃paʼ Asernaʼtar. Ñeñt̃ña Anapaʼ oʼ atarr nanac poʼnmeʼten. Ñehua, allempo shopshenaʼpaʼ someʼta, eʼñe canc̈herr charohua yec̈hañ epuet puerrollarpaʼ oʼ rromapes. ");
INSERT INTO ameNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ñeñt̃ña rret̃orrnaneshaʼpaʼ att̃a correna ñapuet̃. Oʼ poscoch c̈harraʼ puechena paʼtats char allponmat correna att̃a. Ñapaʼ eʼñe ellapeneʼt̃ sherbeʼ Yompor amaʼt ñam̃a tsapomeʼtets. All Yompor paʼpacllot̃paʼ amach c̈haʼneno. All atarr maʼyochenana Yompor. Errot̃eno eʼñe puemaʼyocheñot̃ Yomporpaʼ amach rreno amaʼt coñeʼt̃a. ");
INSERT INTO ameNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ñapaʼc̈hoʼña allempocma huapa all oʼ c̈hapachet cheshat̃oll Jesús. Ñañapaʼ maʼyochosa, atarr parasyosoʼtenan Yompor cheshat̃ollecop. Ñeñt̃oʼmarña ñapaʼ atarr serrpareʼtatosan acheñeneshaʼ ñeñt̃ cheshat̃ollecop t̃arroʼmar oʼ huapa ñeñt̃ atarr cohuen allohuen acheñeneshaʼ ñeñt̃chaʼ aʼqueshp̃atoseʼ israelneshaʼ ñeñt̃ paʼnetser peneʼ Jerusaléñ. ");
INSERT INTO ameNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Allempoña oʼ aʼpoctatuet ora allpon ñeñt̃ atet̃ anaret̃ Yompor poʼñoño ñeñt̃chaʼ eʼñe yec̈haʼ judioneshaʼ ñetñapaʼ ahuanerret paʼnyeto Nazareto allara Galileo. ");
INSERT INTO ameNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Cheshat̃ollñapaʼ alloʼna sen rrorranmats, alloʼna sen huomencatnomuets, nanac eñotnenan ñeñt̃ atarr cohuen enten Pompor Parets, ñeñt̃oʼmarña Yomporpaʼ atarr muereña. ");
INSERT INTO ameNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ñehua, ñeñt̃ cheshachor pamoʼmteʼ ñetpaʼ atet̃ yec̈henet pat̃eʼtets char pascuapopaʼ c̈hocmach senet Jerusaléño oʼch coshapretenetaʼ pascua ñeñt̃ atet̃ yec̈hena judioneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Allempo c̈hap Jesús poʼcharña c̈harraʼ puechena epa ahuanerreterr Jerusaléño, ñetpaʼ atet̃caʼye yec̈henet. ");
INSERT INTO ameNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Oʼña huañ pascuapaʼ ñetñapaʼ oʼ ahuanerret. Ñeñt̃ña cheshachor Jesúspaʼ allaʼt aʼpa Jerusaléño. Pomporña ñam̃a pachorpaʼ ama eñoteñeto oʼt̃eʼ alla aʼpa. ");
INSERT INTO ameNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","C̈ha otapuetañ añt̃eʼ cot̃aʼnen poʼpotantañ ñeñt̃ parro onac̈henet. Oʼña chopeʼcherret pamt̃arrpaʼ allempoñapaʼ oʼ yerpueret, eʼnameʼtyeretaʼ pamoʼtsesheshoʼmar. Eʼnameʼtyeretaʼ alloʼtsen ñeñt̃ eʼñe chemeʼtyen pompor ñam̃a pachor. ");
INSERT INTO ameNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Oʼña eʼnameʼtuet ama es enterrayepaʼ oʼ alla ahuerret Jerusaléño. Allpaʼc̈hoʼ eʼnameʼtuereterr. ");
INSERT INTO ameNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pomaʼpamtañoñapaʼ alla enteretaʼ Parets paʼpacllo. All anen eʼñe parro maestroneshaʼ ñeñt̃ atarr eñotyeneʼ Yompor poʼñoñ ñeñt̃ atet̃ anaret̃. Jesúsñapaʼ all eʼm̃ñotyenanet ñeñt̃ atet̃ serrpareʼtyenetpaʼ oʼchc̈hoʼ aʼp̃t̃oʼtyerranet. ");
INSERT INTO ameNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ñeñt̃oʼmarña allohuen ñeñt̃ eʼmueneʼpaʼ c̈ha atarr cohuanrrorteñet, otyenet: —Errot̃enot̃uañacaʼyeña atarr es eñoten ñeñt̃oʼmar atarr cohuen es anapyen. ");
INSERT INTO ameNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Allempo enter pompor ñam̃a pachorpaʼ att̃a cohuanaʼtoset. Pachorñapaʼ atet̃ otos: —¿Esoʼmart̃eʼña neʼmare oʼ atarr pellcatya? ¿Amaʼt peñoteñe atarr yellquëñeshaʼ yeʼnamenep̃? ");
INSERT INTO ameNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ñañapaʼ otapanet: —Esoʼmareʼtña seʼnameʼtenen. Amaʼt señotennoña napaʼ ñeñt̃ poctetsa nocop oʼch net̃orreññaña ñeñt̃ poctetsa Nomporecop. ");
INSERT INTO ameNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ñetñapaʼ ama es eñotaye ñeñt̃ atet̃ otanet. ");
INSERT INTO ameNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Allempoñapaʼ oʼ cot̃erran pamoʼmteʼ oʼ c̈hac̈herret Nazareto, ñapaʼ eʼñe cohuen ameʼñenana pompor ñam̃a pachor. Pachorñapaʼ allohuen ñoñetspaʼ eʼñe eñotueñ pueyoc̈hro. ");
INSERT INTO ameNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesúsñapaʼ alloʼna sen rrorranmats atarretnomtsa. Alloʼna nanac eñotañetnena. Pomporña Paretspaʼ atarr cohuen enteñ, ñam̃a acheñeneshaʼpaʼ atarr cohuen enteñet. ");
INSERT INTO ameNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ñehua, allempo c̈hap allempoch am̃chaʼtaret̃ta ñam̃a ñeñt̃ paʼsoʼcheñ Tiberio all Romo. Allempo c̈hap oʼ am̃chaʼtaret̃ta c̈harraʼ puechena amnar char allempoña Judeopaʼ añ am̃chaʼtaret̃tatsa ñam̃a Poncio Pilato. Galileoñapaʼ añ am̃chaʼtaret̃tatsa Herodes. Paʼmoʼnasheñña Felipepaʼ ñapaʼ epa anetsocop am̃chaʼtaret̃ta, ñeñt̃paʼ arr am̃chaʼtaret̃ta Iturea ñam̃a Traconite. Lisaniasñapaʼ arr am̃chaʼtaret̃ta Abilinio. ");
INSERT INTO ameNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ñehua, allempopaʼ judioneshaʼ añ poʼcorneshar penet Anás ñam̃a Caifás, ñeñt̃ poʼcorneshar pen ora allohuen cornaneshac̈hno. Eʼñe ñeñt̃e chararocma am̃chaʼtaret̃etyenet allemeñ anetsoʼmar eʼñe allempocma Yomporpaʼ eñoranaʼtana ñam̃a Juan ñeñt̃ Zacarías puechemer ñeñt̃ amayoʼtsen. ");
INSERT INTO ameNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ñeñt̃oʼmarña Juan allempopaʼ oʼ chopeñeʼchyes erracmañen Jordanasoʼmar, all serrpareʼtyesnom. Ñeñt̃paʼ atet̃ otyesnomanet: —T̃eʼpaʼ oʼch soct̃apeʼcherr eʼñe ello cohuen Yomporecop att̃och Yomporpaʼ oʼch peretnerrnas allohuen soʼchñar, allochñapaʼ oʼch sapataret̃terra Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ñeñt̃paʼ añ serrpareʼtatosanet att̃och etsoterra ñoñets ñeñt̃ anaret̃ ñeñt̃ atet̃ eñoseʼt̃ ahuat̃ Isaías ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ. Ñeñt̃ Isaías poʼñoñ ñeñt̃paʼ atet̃ oten: Eʼmorrterrach puesheñarr poʼñoñ all amayo allchaʼña serrpareʼtaterranña acheñeneshaʼ. Puerranarot̃paʼ añchaʼ tomaʼntaterranet t̃oñ, ñeñt̃paʼ atet̃chaʼ oterranet: “T̃eʼpaʼ oʼch saʼcohuenetyes t̃oñ allchaʼ oñmos Partseshaʼ, oʼch eʼñe saʼpac̈harretyesoñ paʼt̃ep̃. ");
INSERT INTO ameNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","All rrapatseʼtyen patspaʼ oʼch eʼñe saʼmuepñetyes, all pocmoʼyaretyenapaʼ oʼch eʼñe saʼmuepñetuahue, all terepeʼp̃arretyenapaʼ oʼch eʼñe saʼpac̈harretyes, all arrorot̃etyena t̃oñpaʼ oʼch eʼñe sepampaʼhuahue. ");
INSERT INTO ameNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Allempoña allohuen acheñeneshaʼpaʼ enteretchaʼ ñeñt̃ oʼ mueñerrnay Yompor ñeñt̃chaʼ yaʼqueshp̃aterreʼ.” Arrpaʼ allohua ñeñt̃ atet̃ aquellcaret̃ ahuat̃ot̃eñ Cristocop. ");
INSERT INTO ameNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Allempoñapaʼ shonteʼ acheñeneshaʼ huac̈haʼtet Juanesho. Ñetpaʼ t̃arroʼmar huac̈henet añ muenenet oʼch apatapanet Juan Yomporecop. Juanña serrpareʼtatapanetpaʼ otapanet: —Sapaʼ ama cohuenayayso atarr ashcarñat̃es, c̈ha sottena ñerraʼmrrat̃eʼ shechp̃a sompor sepen. Poʼñoc̈hcaʼ ama eseshayeʼ sotenaye eʼñech sapataret̃teñot̃a oʼch sequeshperra allochñapaʼ amach coñchatuerrso Yompor allempoch yoroc̈htatuer tsapat̃onet̃. ");
INSERT INTO ameNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Napaʼ añchaʼña notapas oʼch sorrtatyes ñeñt̃ eʼñe cohuen enten Yompor ñeñt̃ atet̃ pena ñeñt̃ poʼñoc̈h oʼ cot̃apeʼcherran ello cohuen Yomporecop. Sapaʼ c̈ha soteneñ seyoc̈hro añoʼ es sepallteno sapaʼ añoʼ eʼñe seyemtena satañ Abraham. T̃arraña napaʼ oʼch notas amach atet̃ soct̃apeʼchatsto t̃arroʼmar ñeñt̃paʼ ama esoyeʼ enteñe Yompor. T̃arroʼmar oʼch notas ñerraʼm Yompor muenetseñ amaʼt añ mapueʼ ñeñt̃ senten arr oʼch aʼpnasereñ Abraham poʼm̃reneñ. ");
INSERT INTO ameNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ñeñt̃oʼmarña napaʼ oʼch notas ñerraʼm amach soct̃apeʼcherro cohuen Yomporecop oʼ mamesham̃a oʼch c̈haponasa att̃och coñchaterres Yompor. Oʼch netmaʼntatasa atet̃ ñerraʼmrrat̃eʼ allempo oʼch aʼmatamochet tsach. Oʼ eʼñe onañchachet gach allchaʼ tet eʼñe allohua huañen puepallactar. Ñeñt̃ allohuen tsachec̈hno ñeñt̃ ama cohuenayeʼ meʼtetsopaʼ aʼmataʼtueretchaʼ saprrochetchaʼ all huorten tsoʼ allchaʼ eʼñe aʼpoyatatueret. ");
INSERT INTO ameNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Allempoña acheñeneshaʼpaʼ aʼp̃t̃oʼtyeset Juan, ochet: —Ñehua, ¿esoʼtña poctetsaña yocop att̃och eʼñe yorrtatyes ñeñt̃ cohuentetsa Yomporecop? ");
INSERT INTO ameNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ñañapaʼ anapanetpaʼ otanet: —Ñerraʼm eseshas echeneʼ epma seshtam oʼch sap̃ ñeñt̃ ama echenaye ñeñt̃chaʼ chorrena. Ñam̃a ñerraʼm eseshas echeneʼ serrar oʼch sap̃ ñeñt̃ ama echenaye ñeñt̃chaʼ rrenet. ");
INSERT INTO ameNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Allempoña huac̈haʼta ñam̃a acheñeneshaʼ ñeñt̃ poʼtaruas peneʼ att̃o cobrenan acheñeneshaʼ quelle ñeñt̃ gobiernocop. Ñetpaʼc̈hoʼña añecop huenet Juanesho oʼch apataret̃tet Yomporecop. Ñetpaʼc̈hoʼña oʼ aʼp̃t̃oʼtoset Juan, atet̃ otoset: —Yocop Nomporchaʼ ¿esoʼtña poctetsa att̃och yorrtatyes yam̃a ñeñt̃ cohuentetsa Yomporecop? ");
INSERT INTO ameNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ñañapaʼ anapanetpaʼ atet̃ otanet: —Ñeñt̃ allpon quelle ñeñt̃ eʼñe allpona enamuen gobiernopaʼ eʼñech allpona secobreñña acheñeneshaʼ, amachña alloʼna atarr aton secobraʼneñe acheñeneshaʼ quelle ñeñt̃ eʼñech socpaʼna. ");
INSERT INTO ameNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Allempoña patantarr guardianeshaʼ ñeñt̃ alloʼtsaʼyenpaʼ aʼp̃t̃oʼtoset ñamet, ñetpaʼ atet̃ otet: —Yocoppaʼc̈hoʼña ¿esoʼtña poctetsa ñeñt̃chaʼ att̃och yorrtatyes yam̃a ñeñt̃ cohuentetsa Yomporecop? Ñaña anapanetpaʼ atet̃ otanet: —Sapaʼ amach es seprratam̃p̃satsche acheñeneshaʼ eʼñe seʼmueñocma ñam̃a saʼmet̃am̃peñot̃ eʼñe seshquëñot̃paʼc̈hoʼña amach es seprratam̃p̃satsto eʼñe att̃ot̃a. Ñam̃a ñeñt̃ allpon tsaʼtenset gobierneshot̃paʼ eʼñepaʼchña ñeñt̃a cohuen socshena. ");
INSERT INTO ameNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Acheñeneshaʼñapaʼ att̃a cohueñet, pueyoc̈hretoñapaʼ att̃a cot̃apeʼchyenet c̈ha otenapuetañ Juanpaʼ ñeñt̃t̃eʼña Cristotets ñeñt̃ cohuenet ahuat̃ot̃eñ ñeñt̃chaʼ mueñerranet Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juanñapaʼ atet̃ otanet: —Napaʼ ama añeyayno ñeñt̃ Cristotets, t̃arroʼmar napaʼ amaʼt napatensoñ Yomporecop eʼñe oñochaya napatenes. T̃arraña Cristo ñeñt̃chaʼ huapatsa chentaʼpaʼ ñapaʼ añchaʼña chorratossa Parets Puecamquëñ ñeñt̃ atet̃ ñerraʼm tsoʼ. Ñapaʼ ñeñt̃ atarr ahuamencat̃eshaʼ, nañapaʼ ama tama ahuamencat̃eyayno. Ñapaʼ ñeñt̃ña atarr sherbets, nañapaʼ ama es nesherbeno att̃och amaʼt poʼsapatrec̈hapaʼ oʼch nepyoñ. ");
INSERT INTO ameNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ñapaʼ atarr ahuamencat̃, ñapaʼ ñach acrerreʼ allohuen acheñeneshaʼ. Ñapaʼ añ tomaʼntena ñeñt̃ orreneʼ pueshoshnat alloch shoshnan poʼtrigo oʼch eʼñe pueʼllom̃rochayam̃a. Ñeñt̃ña pueʼllomerpaʼ oʼch aʼyapac̈heʼ oʼch aññoʼch allecma aññoʼteñ eʼñe cohuen. Pueʼsheʼmarñapaʼ oʼch huaporeʼch tso allchaʼ eʼñe poyhua. Ñeñt̃ña tsoʼpaʼ ama emayaʼpahuo amaʼt errponaña. ");
INSERT INTO ameNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Juanña allpaʼ atet̃ serrpareʼtatyenanet cohuen ñoñets ñeñt̃ huetsa Yomporeshot̃ alloch yequeshperra. Ellonet̃ñapaʼ shonteʼ paʼnamen serrpareʼtatan acheñeneshaʼ ñeñt̃ ama pocteyeʼ enteno Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","22","Allempoña oʼ atarr apataret̃ta shonteʼ acheñeneshaʼ Yomporecoppaʼ c̈ho apataret̃tatsa ñam̃a Jesús. Eʼñe apataret̃etuatsapaʼ oʼ maʼyocha. Allempoña maʼyochenapaʼ enetñapaʼ ahuepaʼt atoraret̃ta. Allot̃ña eʼñe sohuaʼnma Parets Puecamquëñ eʼñe atet̃ entapet ñerraʼmrrat̃eʼ yep̃ oʼ sohuaʼnma entot̃. Eʼñe arr c̈hap Jesúsesho. C̈ha eʼmorrtatsa ñoñets entot̃ atet̃ eñorena Yompor. Ñeñt̃ña ñoñetspaʼ atet̃ oten: —P̃apaʼ ñeñt̃ep̃ Nechemerep̃ ñeñt̃ep̃ atarr nemorrentena, p̃a atarr nanac nocshateneʼ. Allempoña am̃chaʼtaret̃ Herodespaʼ oʼ yottam̃p̃satan Juan t̃arroʼmar Juanpaʼ eñotach ama pocteyeʼ enteñe ñeñt̃ atet̃ p̃atseʼtyena. Amaʼt paʼmoʼnasheñ Felipe puet̃aporpaʼ oʼ yoram̃per. Amaʼt shonteʼ paʼnamen ñeñt̃ atet̃ p̃atseʼtyena Herodespaʼ elloñapaʼ oʼc̈hoʼ yottam̃p̃saterranerr ñam̃a Juan. ");
INSERT INTO ameNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ñehua, Jesúspaʼ allempo orrta oʼ t̃orraʼmochana ñeñt̃ poʼtaruas pen Pomporecop, allempoña poʼcharñapaʼ ñatoʼ oʼt̃eʼ c̈hap maʼpoch c̈harraʼ char. Acheñeneshaʼñapaʼ aña pompor p̃ateñet ñeñt̃ José. Ñehua, Josépaʼ Elí puechemer, ");
INSERT INTO ameNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elípaʼ Matat puechemer, Matatpaʼ Leví puechemer, Levípaʼ Melqui puechemer, Melquipaʼ Jana puechemer, Janapaʼ José puechemer, ");
INSERT INTO ameNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josépaʼ Matatías puechemer, Matatíaspaʼ Amós puechemer, Amóspaʼ Nahum puechemer, Nahumpaʼ Esli puechemer, Eslipaʼ Nagai puechemer, ");
INSERT INTO ameNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaipaʼ Maat puechemer, Maatpaʼ Matatías puechemer, Matatíaspaʼ Semei puechemer, Semeipaʼ José puechemer, Josépaʼ Judá puechemer. ");
INSERT INTO ameNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judápaʼ Joana puechemer, Joanapaʼ Resa puechemer, Resapaʼ Zorobabel puechemer, Zorobabelpaʼ Salatiel puechemer, Salatielpaʼ Neri puechemer, ");
INSERT INTO ameNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neripaʼ Melqui puechemer, Melquipaʼ Adi puechemer, Adipaʼ Cosam puechemer, Cosampaʼ Elmodam puechemer, Elmodampaʼ Er puechemer, ");
INSERT INTO ameNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erpaʼ Josué puechemer, Josuépaʼ Eliezer puechemer, Eliezerpaʼ Jorim puechemer, Jorimpaʼ Matat puechemer, ");
INSERT INTO ameNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matatpaʼ Leví puechemer, Levípaʼ Simeón puechemer, Simeónpaʼ Judá puechemer, Judápaʼ José puechemer, Josépaʼ Jonán puechemer, Jonánpaʼ Eliaquim puechemer, ");
INSERT INTO ameNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquimpaʼ Melea puechemer, Meleapaʼ Mainán puechemer, Mainánpaʼ Matata puechemer, Matatapaʼ Natán puechemer, ");
INSERT INTO ameNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natánpaʼ David puechemer, Davidpaʼ Isaí puechemer, Isaípaʼ Obed puechemer, Obedpaʼ Booz puechemer, Boozpaʼ Salmón puechemer, Salmónpaʼ Naasón puechemer, ");
INSERT INTO ameNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasónpaʼ Aminadab puechemer, Aminadabpaʼ Aram puechemer, Arampaʼ Esrom puechemer, Esrompaʼ Fares puechemer, Farespaʼ Judá puechemer, ");
INSERT INTO ameNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judápaʼ Jacob puechemer, Jacobpaʼ Isaac puechemer, Isaacpaʼ Abraham puechemer, Abrahampaʼ Taré puechemer, Tarépaʼ Nacor puechemer, ");
INSERT INTO ameNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacorpaʼ Serug puechemer, Serugpaʼ Ragau puechemer, Ragaupaʼ Peleg puechemer, Pelegpaʼ Heber puechemer, Heberpaʼ Sala puechemer, ");
INSERT INTO ameNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salapaʼ Cainán puechemer, Cainánpaʼ Arfaxad puechemer, Arfaxadpaʼ Sem puechemer, Sempaʼ Noé puechemer, Noépaʼ Lamec puechemer, ");
INSERT INTO ameNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamecpaʼ Matusalén puechemer, Matusalénpaʼ Enoc puechemer, Enocpaʼ Jared puechemer, Jaredpaʼ Mahalaleel puechemer, Mahalaleelpaʼ Cainán puechemer, ");
INSERT INTO ameNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainánpaʼ Enós puechemer, Enóspaʼ Set puechemer, Setpaʼ Adán puechemer, Adánpaʼ Yompor puechemer. ");
INSERT INTO ameNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Allempoña Jesúspaʼ oʼ err Jordanasot̃. Ñañapaʼ añ eʼñe chorrenaya Parets Puecamquëñ ñeñt̃ña anmueʼña all amayo. ");
INSERT INTO ameNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Att̃oña allpaʼ oʼ huapoña oneñet̃, mueneñ oʼch atet̃ p̃atyes ñeñt̃ ama pocteyeʼ enteno Pompor. Allñapaʼ ama rreno eʼñe aña t̃orrena att̃och etsotuan ora allohuen ñeñt̃ cohuentetsa Pomporecop. Ñeñt̃oʼmarña amaʼt oʼ paʼtatsoch c̈harramatpaʼ amaʼt coñeʼt̃apaʼ ama es rreno. Oʼña paʼtatsoch c̈harramatuapaʼ c̈ho cheporratsa. ");
INSERT INTO ameNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Allempoña oneñet̃ att̃o topatosan Jesúspaʼ atet̃ otos: —P̃a ñerraʼm poʼñoc̈ht̃eʼ Parets Puechemerep̃paʼ oʼch p̃ot: Añ mapueʼ puenasepaʼ pan. ");
INSERT INTO ameNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesúsñapaʼ atet̃ otap̃: —Napaʼ ama nemno oʼch atet̃ nep̃a t̃arroʼmar Yompor poʼñoñ ñeñt̃ anuaret̃ ahuat̃ot̃eñ ñeñt̃paʼ atet̃ oteney: “Allohueney acheñeneshohueneypaʼ ama eʼñe rreñtsa ñapuet̃ yocrram̃ yepeno. Añeʼnaña yocrram̃ yepen yecamquëñecop ñeñt̃ allohuen allpon oteney Yompor.” ");
INSERT INTO ameNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Allempoña oneñet̃paʼ oʼ anem̃ all atarr aspent̃o eʼñe aʼnoso. Allot̃ña gatyesuererr allohuen ñeñt̃ allpon all am̃chaʼtaret̃etyena paʼnamen acheñeneshaʼ ñeñt̃ yec̈haʼyetsa errap̃aren añe patsro. Allot̃ña amaʼt mamesha cohuospaʼ eʼñe orreʼtuena erracmañen. ");
INSERT INTO ameNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Oneñet̃ñapaʼ alla oterranerr Jesús: —Ora allohuen ñeñt̃ oʼ pentyesua ñeñt̃paʼ eʼñe nocma t̃arroʼmar ñeñt̃paʼ na aparet̃. Ñerraʼm eseshaʼ nemnen oʼch nap̃paʼ napaʼ nap̃chaʼcaʼye. Ñeñt̃oʼmar t̃eʼpaʼ oʼch notap̃, ñerraʼm na pemaʼyocheñot̃en oʼch peconcorpanaʼtna, napaʼ napap̃chaʼ ora all am̃chaʼtaret̃etyenet all atarr cohuentatyeñet, eʼñe ora allohuen ñeñt̃paʼ eʼñech p̃ocma. ");
INSERT INTO ameNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesúsñapaʼ alla otererr: —T̃eʼpaʼ oʼch orrerrep̃ oneñet̃e. Napaʼ ama nemno oʼch atet̃ nep̃a t̃arroʼmar Yompor poʼñoñ ñeñt̃ anuaret̃ ñeñt̃paʼ atet̃ oteney: “Añach ñapuet̃ yemaʼyochena Yeyomporer ñeñt̃ Yepartseshar yepen, eʼñech ñapt̃a yesherbeʼ.” ");
INSERT INTO ameNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Allempoña oneñet̃paʼ oʼ anerranerr Jesús Jerusaléño. Allñapaʼ aʼtapatos nanac eno allohuanen Parets paʼpaquëll. Allñapaʼ otuererr: —P̃apaʼ ñerraʼm poʼñoc̈ht̃eʼ Parets Puechemerep̃ t̃eʼpaʼ p̃omacha arrot̃ t̃arroʼmar amach p̃aʼtserrp̃o ");
INSERT INTO ameNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","t̃arroʼmar Parets poʼñoñ ñeñt̃ anuaret̃ ñeñt̃paʼ amaʼtña atet̃ oten: Yomporpaʼ oʼch mueñonap̃ poʼm̃llañot̃eñreneshaʼ ñeñt̃chaʼ pecuam̃p̃sapueʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ñetchaʼ p̃agapapuet oʼch enatapapet att̃och amach p̃aʼtserrp̃atcaʼtoso mapyo. ");
INSERT INTO ameNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Allempoña Jesúspaʼ alla otererr: —Añpaʼc̈hoʼña anuaret̃ Yompor poʼñoño, ñeñt̃paʼ atet̃ oten: “Amach yaʼllocchameʼtatsche Yeyomporer ñeñt̃ Yepartseshar yepen.” ");
INSERT INTO ameNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Allempoña oneñet̃ topatuahuan Jesús paʼnamenot̃paʼ oʼ ahuerr oʼ cac̈hpaʼner allponmat t̃arroʼmar oneñet̃ c̈hocma topach. ");
INSERT INTO ameNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Allempoña Jesúspaʼ oʼ alla ahuerr Galileo. Ñapaʼ añ atarr ahuamencat̃ peneʼ Parets Puecamquëñ. Errap̃aren Galileoʼmar oʼ eʼñe eʼmareʼtuet ñeñt̃ atet̃ p̃aʼyena Jesús. ");
INSERT INTO ameNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","All apc̈haʼyena judioneshaʼ poʼprahuetopaʼ ñañapaʼ all yec̈hatyenanet. Att̃oña allohuen acheñeneshaʼpaʼ atarr cohuen enteñet. ");
INSERT INTO ameNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Att̃eñapaʼ oʼ alla c̈herr Nazareto all yec̈hacheʼt̃ pompor allempo cheshenaʼ. Pamt̃arrña allempo c̈hap yet̃ allempo c̈hocma amesen judioneshaʼ, Jesúsñapaʼ oʼ ahuoʼ judioneshaʼ poʼprahuo, ñapaʼc̈hoʼ atet̃ yec̈hena. Oʼ c̈hap puerahuopaʼ allñapaʼ t̃omos allchaʼ lleyatan acheñeneshaʼ Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Allñapaʼ añ apet libro ñeñt̃ alloʼtsen Isaías poʼñoñ ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ ahuat̃. Ñañapaʼ toran libropaʼ all entan ñoñets ñeñt̃ atet̃ aquellcaret̃ ñocop, ñeñt̃ñapaʼ atet̃ oten: ");
INSERT INTO ameNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Napaʼ añ nechorrenaya Nompor Puecamquëñ t̃arroʼmar ña nellsenseʼ nach serrpareʼtaterreʼ ora allohuen acheñeneshaʼ ñeñt̃ atarr es palltetsa. Napaʼ añchaʼ neñotaterranet cohuen ñoñets ñeñt̃paʼ alloch queshperret. Ñam̃a añecopña llesenserren att̃och nach aʼcrratyerreʼ allohuen ñeñt̃ mueroc̈hetyetsa puellquëñot̃ pueyoc̈hreto. Nach eñotaterreʼ ñam̃a ñeñt̃ ayottam̃p̃saret̃etyetsa allochñapaʼ oʼch atoram̃p̃saret̃terret. Nach eñotaterreʼ ñam̃a ñeñt̃ ama entetso allochñapaʼ oʼch enterret. Ñam̃a ñeñt̃ amueroc̈htataret̃etyetsa nachña aʼrroyataterrahuet. ");
INSERT INTO ameNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ñam̃a napaʼ añecopña llesenserren nach eñotaterrahuet t̃eʼpaʼ oʼ c̈hap allempo pocteʼ enteñ Yompor oʼch atarr orrtaterranet puemuereña. Ñehua, arrpaʼ allohua ñeñt̃ allpon lleyatanet Isaías poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Oʼ lleyatuanetpaʼ oʼ alla eʼtam̃perran libro apuerran ñeñt̃ sherbets all puerahuo. Allempoñapaʼ oʼ alla anorruerr. Allohuenña acheñeneshaʼ ñeñt̃ puerahuoʼtsaʼyen ñetñapaʼ atarr cohuanrrorteñet Jesús. ");
INSERT INTO ameNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ñañapaʼ atet̃ otanet: —Att̃oʼ oʼ seʼmhua añ ñoñetspaʼ t̃eʼñapaʼ oʼ eʼñe c̈herr att̃och eʼñe etsoterra ñeñt̃ atet̃ aquellcaret̃ ahuat̃ot̃eñ. ");
INSERT INTO ameNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Allohuenña acheñeneshaʼpaʼ eʼñe cohuen eñoraʼyenet Jesúsocop. Atarr coc̈hneshaʼ enteññañet poʼñoñ ñeñt̃ atet̃ serrpareʼtatyenanet. Ñetñapaʼ atet̃ otannaʼtyenet: —Errot̃enot̃uañacaʼyeña atarr coc̈hneshareʼ serrpareʼtatyeney. Ñapaʼ añacaʼye José puechemer. ");
INSERT INTO ameNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesúsñapaʼ atet̃ oterraneterr: —Sapaʼ ñeñt̃ atet̃ oʼ seʼmareʼton ñeñt̃ atet̃ norrtatyenaʼ ahuaña Capernaumo t̃eʼña sapaʼ c̈ha semneñ oʼch soten añ ñoñets ñeñt̃ecma mueneʼ yotannena amaʼt ahuat̃ot̃eñ: “P̃a ñeñt̃ep̃ aʼcrratañtetsa t̃eʼpaʼ oʼch p̃aʼcrrata eʼñe p̃añeña”, t̃arroʼmar sapaʼ añt̃eʼ semnen oʼch atet̃ norrtat ñam̃a arr cohuen eʼñe ya yaʼnetsro atet̃ norrtatenaʼ ahuaña Capernaumo. ");
INSERT INTO ameNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","T̃arraña napaʼ poʼñoc̈h oʼch notas: —Ñeñt̃ aʼm̃teneʼ Yompor poʼñoñ amaʼt puesheñarra ama eñalleña ñeñt̃ eʼñe cohuen enten allohuen pamoʼtseshaʼ ñeñt̃ parro yec̈henet all eʼñe ñet paʼnetsreto. ");
INSERT INTO ameNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Napaʼ poʼñoc̈h t̃eʼpaʼ añchaʼ neyerpatasa ñeñt̃ atet̃ peʼt̃ Elías ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ ahuat̃. Ñehua, allempopaʼ oʼ maʼpa char ñam̃a poʼpoñ pueshmet charpaʼ nanac chares amaʼt mameshapaʼ ama huateno ñeñt̃oʼmarña orrta muec̈heñets erracmañen all anetso ñeñt̃ Israel all yec̈heʼt̃ Elías. Ñam̃a amaʼt shonteñ israelenaʼtar ñeñt̃ rret̃orrnaneshatyets allempo, t̃arraña Yomporñapaʼ ama alleyeʼ mueñanoña Elías att̃och yenposan amaʼt puesheñarra rret̃orrnaneshaʼ ñeñt̃ eʼñe pamoʼts pen ña. Arra mueñe poʼpoñ anetso ñeñt̃ paʼsoʼcheñ Sarepta ñeñt̃ allara Sidón alloʼtsen puesheñarr rret̃orrnaneshaʼ, ñañapaʼ ñeñt̃a yenpos. ");
INSERT INTO ameNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Elloña oʼch alla neyerpaterrserr poʼpoñ ñeñt̃ atet̃ peʼt̃ ñam̃a Eliseo, ñapaʼc̈hoʼña ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ ahuat̃. Ñehua, allempopaʼ shonteʼ israelenaʼtarneshaʼ ñeñt̃ osyen puetsarñats ñeñt̃ otenet lepra all anetso Israel all yec̈heʼt̃ Eliseo. T̃arraña amaʼt att̃eñ amaʼt puesheñarrot̃apaʼ ama aʼcrratereña Eliseo eʼñe all Israelo. Ñapaʼ aña aʼcrraterr ñeñt̃ poʼpoñenaʼtar acheñ ñeñt̃paʼ añ paʼsoʼcheñ Naamán ñeñt̃paʼ poʼpoñ anetsoʼmarneshaʼ; ñeñt̃ paʼnetser penpaʼ añ paʼsoʼcheñ Siria. ");
INSERT INTO ameNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Acheñeneshaʼña allempo eʼmet ñeñt̃ atet̃ yerpatanet Jesúspaʼ ñeñt̃ña atarr atsrreʼmatahuet allohuenet ñeñt̃ puerahuoʼtsaʼyen. ");
INSERT INTO ameNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ñetña tantrraʼtetpaʼ oʼ mueñoʼteret allot̃ paʼnetsretot̃. Chetaʼneret, allot̃paʼ arr anmet allohua huañen pocoll allot̃ eʼñe atseret̃tena allchaʼ huaporeʼchet att̃och muetsatachet. ");
INSERT INTO ameNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","T̃arraña amaʼt huaporeʼchetañ, Jesúsñapaʼ oʼ chopeʼchnerr amaʼt all shontena acheñeneshaʼ. Ñañapaʼ all chetaʼtnerra rroc̈hopaʼ oʼ ahuerr. ");
INSERT INTO ameNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Allempoñapaʼ oʼ alla ahuerrerr anetso Capernaumo allara Galilea. Pamt̃arrña allempo c̈hap yet̃ñats allempo amesen judioneshaʼ ñañapaʼ oʼ ahuoʼ poʼprahueto. Allñapaʼ yec̈hatyesosan acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ñeñt̃ atet̃ yec̈hatenanet, acheñeneshaʼñapaʼ att̃a cohuanrrorteñet. T̃arroʼmar ñapaʼ atet̃ yec̈hatenanet ñerraʼmrrat̃eʼ ñeñt̃ allsensaret̃tetsa Partseshot̃. ");
INSERT INTO ameNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Puesheñarrña yacma ñeñt̃ alloʼtsen puerahuo, ñeñt̃ñapaʼ añ chorrenaya oneñet̃. Ñaña rranareʼtapaʼ atet̃ otapan Jesús: ");
INSERT INTO ameNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¿Esoʼmareʼtchaʼña errot̃ pep̃osey Jesúso, p̃a ñeñt̃ep̃ nazaretoʼmarneshap̃? Añecopt̃eʼ pehuapa oʼch p̃aʼchencaterrey. Napaʼ oʼ neñotapap̃. P̃apaʼ atarr Partsop̃ añ pellsenseneʼ P̃ompor ñeñt̃ atarr nanac Parets. ");
INSERT INTO ameNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","T̃arraña Jesúspaʼ ama muenache oʼch eñoranaʼcha. Ñañapaʼ atet̃ och: —Pemma, t̃eʼpaʼ c̈hop̃aña cac̈hpaʼnerreʼña añ acheñer. Oneñet̃ñapaʼ c̈ha atanman yacmapaʼ alla oʼshsheʼma eʼñe all shontena allohuen acheñeneshaʼ. Allempoñapaʼ oʼ cac̈hpaʼner eʼñe att̃a, ama errot̃ p̃aʼnme. ");
INSERT INTO ameNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Acheñeneshaʼñapaʼ c̈ha atarr t̃oratsp̃anet pueyoc̈hret. Ñetñapaʼ atet̃ otannaʼtyeset: —Taʼmcaʼye, errot̃ent̃eʼcaʼyeña Jesús poʼñoñ, atarrepaʼt huomenc poʼñoñ pen. Eʼñe atet̃ ñerraʼmrrat̃eʼ ñeñt̃ allsensaret̃tetsa ñeñt̃ atarr ahuamencat̃eshaʼ. Amaʼt oneñet̃ errot̃ otenpaʼ atet̃c̈hoʼ p̃ateñ. Poʼñoc̈hcaʼye t̃eʼpaʼ oʼ c̈haʼnerr oneñet̃. ");
INSERT INTO ameNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Allempoñapaʼ erracmañen allampañoʼmar serrpareʼtyeset ñeñt̃ atet̃ pena Jesús. ");
INSERT INTO ameNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Allempoña Jesúspaʼ c̈haʼnerr puerahuot̃ oʼ ahuoʼ ñam̃a Simón paʼpacllo. Allña Simón paʼsoʼmuepaʼ c̈ha atsnaʼten, c̈ha atarr nanac hueraten. Otapet Jesús: —T̃eʼ yapaʼ yemneñ oʼch p̃aʼcrratos atsnañet̃. ");
INSERT INTO ameNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Allempoña Jesúspaʼ oʼ ponmosana atsnañet̃paʼ c̈ha aʼhuañam̃p̃soseʼña poʼurateña. Allempoña oʼ metua poʼurateñapaʼ allent̃a tanta oʼ agapapanet eʼñe cohuen oʼ yemaʼtapanet. ");
INSERT INTO ameNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ñeñt̃e yet̃rocma allempo oʼ emuena atsneʼpaʼ acheñeneshaʼña allohuenet ñeñt̃ atsnaʼtyets pamoʼtseshaʼ ñetñapaʼ oʼ huapatyesnenet atsnañet̃ eʼñe Jesúsesho. Ñañapaʼ naʼyesapanet pot ñesheto puesheñaʼttset, att̃oña aʼcrratyesapanet allohuenet. ");
INSERT INTO ameNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ñam̃a shonteʼ acheñeneshaʼ cac̈hpatatyesapanet oneñet̃ ñeñt̃ puerranarot̃ otnomueʼ Jesús: —P̃apaʼ ñeñt̃ep̃ eʼñe poʼñoc̈h Parets Puechemerep̃. T̃arraña Jesúspaʼ aʼmtsoñeñtanet, ama muenataneto oʼch eñoranaʼtnomet, t̃arroʼmar ñetpaʼ eʼñe eñotnomet ñapaʼ ñeñt̃ Cristotets. ");
INSERT INTO ameNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tsapat̃ña oʼ puetarenpaʼ Jesúsñapaʼ ahuaʼmuen aʼyo all ama acheñempañoyaye. Acheñeneshaʼñapaʼ eʼnameʼtaʼmueñet. Att̃eñapaʼ oʼ c̈hapaʼmuenet alloʼtsen Jesús. Ñetñapaʼ ama mueneñeto oʼch erra saʼnmanet. ");
INSERT INTO ameNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ñañapaʼ atet̃ otapanet: —Napaʼ añ poctetsa nocop oʼch ahuen poʼpoñ anetsoʼmar, allpaʼc̈hoʼña oʼch neserrpareʼtatyesnomanet ñeñt̃ cohuen ñoñets, oʼch neñotatyesosanet Yompor poʼcohuenña ñeñt̃ att̃och ayochreshat̃tena ña, t̃arroʼmar napaʼ ñeñt̃ecopña llesenserren Nompor. ");
INSERT INTO ameNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Att̃eñapaʼ oʼ serrpareʼtatyesnoman acheñeneshaʼ errap̃aren Galileoʼmar all apc̈haʼyenet poʼprahueto. ");
INSERT INTO ameNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Allempoña poʼpocheño Jesúsñapaʼ eʼñe saʼpatop̃ño t̃en, ñeñt̃ña saʼppaʼ añ paʼsoʼcheñ Genesaretas. Allñapaʼ huac̈haʼtoña shonteʼ acheñeneshaʼ oʼ c̈ha echtaʼtatseʼtannaʼtoset. Att̃oña amaʼt Jesúspaʼ oʼc̈ha echtaʼtoset. Ñetpaʼ añ muenenet oʼch eʼm̃ñotosñañet Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesúsñapaʼ all entosan epna noñt̃ eʼñe all sohuaʼpuetso. Ñeñt̃ña poʼtaruas peneʼ ñeñt̃ rremueneʼ cacpaʼ ñetñapaʼ ama poʼnoñt̃oʼtsaʼyeneto. Ñetpaʼ oʼ ahuanmuet aʼyenet̃ allchaʼ tsamaʼtenetaʼ poʼterraya. ");
INSERT INTO ameNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesúsña allpaʼ aʼtapos puenarr noñt̃o, ñeñt̃ Simón poʼnoñt̃. Aʼtapospaʼ otan Simón: —Pechtam̃p̃sen mameʼ rroc̈haʼsonet̃. Jesúsña anorros noñt̃opaʼ allot̃ña yec̈hatosan allohuen acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Allempoña serrpareʼtatuanet, oʼ alla oterranerr Simón: —T̃eʼpaʼ oʼch ahuep̃ rroc̈haʼsonet̃ epopaʼ oʼch alla peterrayerrerr, t̃eʼpaʼ perrmaʼch shonteʼ cac. ");
INSERT INTO ameNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simónñapaʼ atet̃ och: —Yapaʼ oʼ Maestrochaʼ eʼñe yarepen t̃orratsa terrayats eʼñe orrena amaʼt parra cac ama yerrmueñe. T̃eʼña p̃acaʼ noteneʼ oʼch alla neterrayerrerr amaʼtpaʼ atet̃chaʼ nep̃a oʼch alla neterrayerrerr. ");
INSERT INTO ameNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Allempoñapaʼ atet̃c̈hoʼ pet, oʼ alla terrayerreterr. Terrayañapaʼ shonteʼ rroman cac nanac aton, c̈ha mueneʼ rrarreʼtatan terraya. ");
INSERT INTO ameNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Att̃eñapaʼ agochet poʼpotantañ pamoʼtset ñeñt̃ poʼnoñt̃oʼtsaʼyen oʼch huapuet ñeñt̃chaʼ rromapretahuet cac. Oʼña c̈hapuet oʼ eshaʼtanatet cac noñt̃o eʼñe epnoʼmar chorrares cac noñt̃o, c̈ha mueneʼ eshaʼtatan noñt̃. ");
INSERT INTO ameNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Allempoña atet̃ eñch Simón Pedro ñañapaʼ pomaʼyorñecma ponmana Jesús, concorposa paʼrrp̃ot̃, all otos: —Amach Partseshachaʼ alloʼna peyemtatsetnenno t̃arroʼmar napaʼ ñeñt̃en atarr ochñat̃en. ");
INSERT INTO ameNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Atet̃ otan Jesús pueyorñot̃ t̃arroʼmar eñoteñ ñeñt̃ att̃o rreman shonteʼ cacpaʼ Parets atet̃ p̃ateneʼ. Amaʼt allohuen ñam̃a ñeñt̃ epuet taruasenetpaʼ atarr nanac yorenet. ");
INSERT INTO ameNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Amaʼt ñam̃a Jacobo ñam̃a Juan ñeñt̃ Zebedeo puechemereshaʼ ñeñt̃ parro taruasen Simón, atarr nanac yorenet. Allempoña Jesúspaʼ atet̃ oterranerr Simón: —Amach c̈ha peyorenatsto. Ñeñt̃ atet̃ pepena ahuat̃ot̃eñ eʼneʼ cac t̃eʼñapaʼ atet̃chaʼ peperra eʼnerreʼ ñam̃a acheñ ñeñt̃chaʼ p̃ameʼñaterra. ");
INSERT INTO ameNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Allempoñapaʼ ahuam̃perret oʼch etsotuerret allecma etsotenet. Ñetñapaʼ allempocma sohuanmuet allohuen ñeñt̃ allpon echyenet. Allempoñapaʼ cot̃eret Jesús att̃och pueyochreshaʼ perranet. ");
INSERT INTO ameNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Allempo poʼpocheño Jesúsñapaʼ alla c̈herrerr poʼpoñ anetso. Allñapaʼ huapoña puesheñarr yacma ñeñt̃ osen puetsarñats ñeñt̃ otenet lepra, atarr apoc̈htateñ. Entosan Jesúspaʼ alla rromam̃p̃sosya. Allña rromuenapaʼ allot̃ña enamosan Jesús, atet̃ otos: —Ayochreshat̃e ñerraʼm p̃a muenatspaʼ p̃a ñeñt̃ep̃ atarr ahuamencat̃eshap̃ p̃aʼcrratayeʼcherren allochñapaʼ att̃och eʼñe cohuen entuerren acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesúsña anretapaʼ allent̃a aʼp̃lleʼ, atet̃ och: —Napaʼ nemneñcaʼye, metuerrepaʼña peptsarña att̃och eʼñe cohuen enterrep̃ allohuen acheñeneshaʼ. Yacmañapaʼ allorocma metuer pueptsarña. ");
INSERT INTO ameNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesúsñapaʼ alla otererr: —T̃eʼ att̃o oʼ naʼcrraterrep̃paʼ amaʼt eʼñe puesheñarrapaʼ amach p̃otap̃saʼtatsche. Corneshachña pegatenaʼ all peptsarseʼt̃. Atet̃ naneʼt̃ Moisés ñoñets añ acheñrecop ñeñt̃chaʼ aʼcrrataret̃terrtsapaʼ t̃eʼñapaʼ oʼch es p̃anom ñeñt̃chaʼ p̃apos all ñeñt̃ Yomporecop. Allochñapaʼ att̃och eʼñe cohuen enterrep̃ allohuen acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Elloña atarr nanac serrpareʼtyeñet, oʼ erracmañen epaʼhua att̃oʼ pena Jesús. Ñeñt̃oʼmarña shonteʼ acheñeneshaʼ huac̈haʼtoñet att̃och eʼm̃ñotoñet poʼñoñ ñam̃a att̃och aʼcrratyesapanet allohuen paʼtsnañet̃eret. ");
INSERT INTO ameNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","T̃arraña ñapaʼ errot̃enopaʼ oʼch ahuerr aʼyo all ama acheñempañoyaye allchaʼ maʼyochena. ");
INSERT INTO ameNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Poʼpocheño allempo Jesúspaʼ all yec̈haterranerr shonteʼ acheñeneshaʼ, allña allpononet̃paʼ all anorrc̈haʼtyen ñam̃a patantarr fariseoneshaʼ ñam̃a ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop. Ñetpaʼ paʼnamen anetsot̃ huac̈haʼtyenet—Galileot̃ ñam̃a Judeot̃ ñam̃a Jerusaléñot̃. Jesúsñapaʼ atarr ahuamencat̃ peñ Pompor, att̃oña aʼcrratyesan shonteʼ ñeñt̃ atsnaʼtyets. ");
INSERT INTO ameNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Att̃eña oʼ huapatoñet ñam̃a echarrtaña, huapatam̃p̃set puechecnap̃ot̃. Ñetpaʼ añ muenenetañ oʼch beʼt̃oset oʼch eʼñe noset Jesúsesho. ");
INSERT INTO ameNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","T̃arraña shonteʼ acheñeneshaʼ ñeñt̃oʼmarña ama eshcayeʼ abeʼt̃osetoña atsnañet̃ att̃och c̈hapachet eʼñe Jesúsesho. Att̃eñapaʼ aʼtapatoset enot̃ pocollato. Allñapaʼ oʼ aʼrrot̃eʼtoset pat̃ep̃rarr echet allot̃ña aʼsuatam̃p̃set echarrtaña puechecnapeʼna. Att̃oña c̈hapachet eʼñe rroc̈ho alloʼtsen Jesús. ");
INSERT INTO ameNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesúsñapaʼ eñotapanet ñetpaʼ atarr nanac yemteñet, ñeñt̃oʼmarña atet̃ otapan echarrtaña: —Masheñchaʼ t̃eʼña p̃a p̃oʼchñarpaʼ oʼ ap̃retnaʼhuaret̃ta. ");
INSERT INTO ameNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Otueʼ atet̃paʼ añña fariseoneshaʼ ñam̃a ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop, ñetñapaʼ otatseʼtet ñañeñeta: —Eseshaʼhuañacaʼye oʼ achm̃areʼtanña Yompor. Arr patsropaʼ amaʼt puesheñarra ama eñalleña ñeñt̃ peretneneʼ ochñarets, ñapt̃aña Yompor peretneneʼ ochñarets. ");
INSERT INTO ameNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesúsñapaʼ eñotanet ñeñt̃ atet̃ otenet ñocop, ñañapaʼ atet̃ otanet: —Sapaʼ esoʼmareʼtchaʼña atet̃ soct̃apeʼchatseʼtyesña seyoc̈hro. ");
INSERT INTO ameNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ñehua, sapaʼ c̈ha soten ñeñt̃ atet̃ oʼ notue echarrtaña poʼchñarpaʼ oʼ ap̃retnaʼhuaret̃ta, ñeñt̃paʼ ama t̃orrapahuoyaye. Sapaʼ añña atarr t̃orrapoʼ senten att̃och naʼcrrater c̈honchaʼña oteʼ: “Petantena, pechopeʼchnen.” ");
INSERT INTO ameNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ñehua, napaʼ oʼch neñotatas na Ñeñt̃en Acheñetosets, napaʼ aparet̃en llesens att̃och nach peretnerreʼ ochñarets añ patsro. Ñeñt̃oʼmarña Jesús allempopaʼ atet̃ otan echarrtaña: —T̃eʼña napaʼ oʼch notap̃: Petantena, pechtaʼnen pemueʼ oʼch pechopeʼchnen, ahuenep̃ pepacllo. ");
INSERT INTO ameNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Eʼñe otueʼ atet̃paʼ echarrtañañapaʼ c̈ha tantetsa eʼñe allorocma. Allohuenña acheñeneshaʼ eʼñe entueñet. Oʼ chetaʼnenan poʼmueʼ paʼyeʼchoc̈htateñeshaʼ Yompor oʼ ahuen paʼpacllo. ");
INSERT INTO ameNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Allohuenña acheñeneshaʼpaʼ c̈ha atarr cohuanrrortapueñet. Att̃oña ñetpaʼc̈hoʼña atarr cohuentatyeññañet Yompor. Allohuenetñapaʼ atarr nanac yorenet, atet̃ otyenet: —T̃eʼpaʼ oʼ yenterr ñeñt̃ amaʼt ahuat̃apaʼ ama yentareña ya ñeñt̃ atarr cohuen. ");
INSERT INTO ameNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Allempoñapaʼ oʼ ahuerrerr Jesús. All oñempaʼ all entnoman puesheñarr ñeñt̃ poʼtaruas peneʼ oʼch cobrenan acheñeneshaʼ quelle ñeñt̃ gobiernocop. Ñeñt̃ñapaʼ añ paʼsoʼcheñ Leví. Alla anen allecma apc̈henet quelle ñeñt̃ gobiernocop. Jesúsñapaʼ otosan Leví: —T̃eʼpaʼ p̃oct̃aʼn att̃och neyochreshaʼ neperrep̃. ");
INSERT INTO ameNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Eʼñe otueʼ atet̃ Levíñapaʼ c̈ha tantnomtsa oʼ cot̃an Jesús. Att̃oña ñapaʼ eʼñe sohuanman ñeñt̃ allohuen paʼnamen. ");
INSERT INTO ameNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Allempoñapaʼ c̈hapaʼmuen ñam̃a pamt̃arr allempo Leví paʼpacllopaʼ yec̈hcatatan shonteʼ rreñets att̃och coshameʼtam̃pesyet Jesús. All rrallmeʼchapreteñ shonteʼ acheñeneshaʼ. Alloʼtsaʼyen ñam̃a ñeñt̃ parro yemtena Leví. Ñetpaʼc̈hoʼña ñeñt̃areta ñeñt̃ poʼtaruas penet oʼch cobraʼyeñet acheñeneshaʼ quelle ñeñt̃ gobiernocop, t̃arraña ñetpaʼ pueshquëñot̃eʼna cobreñet acheñeneshaʼ aton. Ñeñt̃ rrallmeʼchapreteneʼ Jesús. ");
INSERT INTO ameNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Fariseoneshaʼ ñam̃a ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃, ñetñapaʼ sasareʼteññañet Jesús pueyochreshaʼ. Att̃eñapaʼ otaret̃tet: —Taʼm, esoʼmart̃eʼña serrallmeʼchapreteñña añ acheñeneshar ñeñt̃ pueshquëñot̃eʼna cobraʼyeneʼ acheñeneshaʼ aton quelle ñam̃a epas acheñeneshaʼ ñeñt̃ atarr ochñat̃eneshac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Atet̃ eʼmanet Jesús, ñañapaʼ atet̃ tomaʼntatanet: —Ñeñt̃ eʼñe huomech entetsapaʼ ñetpaʼ ama eʼneñetoña apartañ. Añña ñeñt̃ atsnaʼtetspaʼ ñetñapaʼ c̈hocma añ eʼnenet ñeñt̃chaʼ aʼcrraterrahuet. ");
INSERT INTO ameNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Napaʼ ama añecpayeʼ nohuapo att̃och nec̈horeʼtos ñeñt̃ eʼñe atet̃ entetsañ ñetpaʼ eʼñoʼ cohuen es p̃aʼyenet. Napaʼ añecopña nohuapa att̃och nec̈horeʼtos ñeñt̃ atarr ochñat̃ entyetsa. Allochñapaʼ att̃och oʼch cot̃apeʼcherret ello eʼñe cohuen Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ñetñapaʼ alla otereterr Jesús: —Ñeñt̃ Juan pueyochreshaʼpaʼ c̈hocma t̃oreʼtenet Yomporecop, c̈hocma maʼyochenet. Ñam̃a fariseoneshaʼ pueyochreshaʼpaʼc̈hoʼña att̃ecma penet. T̃arraña p̃aña peyochreshaʼpaʼ esoʼmareʼtña ama att̃eyeʼ peneto. Ñetpaʼ atta es rratseʼtyenet, att̃a es orryenet. ");
INSERT INTO ameNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesúsñapaʼ alla tomaʼntaterraneterrpaʼ atet̃ otanet: —Ñeñt̃ ahuaʼñaret̃ec̈hno all rrallmeʼchapreteñet ñeñt̃ eʼñe errteʼ senaʼtetsa, ama pocteyaye oʼch yotanet “amach es serraʼyesatsto”, t̃arroʼmar ñeñt̃paʼ atet̃ coshapreteñet ñeñt̃ senaʼtetsa. ");
INSERT INTO ameNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","T̃arraña ñerraʼm esempo machayot̃a saʼnerranet ñeñt̃ senaʼtetsa, ñeñt̃ña parro yemuetyena allempoña ñetpaʼ eʼñe puellquëñot̃et cac̈hpaʼhuerretchaʼ puerrar, amach arrenayeʼ enterreto. Ñeñt̃paʼ att̃ochña t̃oreʼterret allempo Yomporecop eʼñe poʼñoc̈h. Arrpaʼ allohua huañ ñeñt̃ atet̃ Jesús tomaʼntata ña senaʼtostsa. ");
INSERT INTO ameNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Elloñapaʼ oʼ alla tomaʼntaterraneterr ñeñt̃ atet̃ yec̈hen judioneshaʼ arr patsro ñeñt̃oʼmarña atet̃ otanet: —Ñehua, ñerraʼm yechen epma yeshtam, pat̃err emarr ñam̃a poʼpoñ mellashañpaʼ amach yerrarratstoña emarr yeshtam alloch yelltaʼ yeshtam mellashañ all rrarraʼnen. T̃arroʼmar amaʼt atet̃ yep̃atsechpaʼ ñeñt̃paʼ eʼñech orrena. Amaʼt yeshtam emarrpaʼ oʼhuañchaʼ cohuenta all yerrarreñ. Ñam̃a yeshtam mellashañ amaʼt oʼ yelltereñ emarropaʼ amach alla cohuenterro t̃arroʼmar ñeñt̃ allo oʼ yellterpaʼ ama mellashañecmayaye, ñeñt̃oʼmarña amach ñeñt̃tatere. Ñeñt̃paʼ att̃oña Jesúspaʼ eñotatanet ña poct̃ap̃ña eʼñe etserra. ");
INSERT INTO ameNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Jesúsñapaʼ alla tomaʼntaterraneterr poʼpoñ ñeñt̃ atet̃ yec̈hena judioneshaʼ oʼch yec̈hcatenet paʼrrom orrot̃. Ñeñt̃oʼmarña atet̃ otanet: —Amaʼt puesheñarrot̃eyapaʼ amach yeshatstoña vinos emasa mellashaʼm̃añ orrot̃o ñeñt̃ ayec̈hcataret̃ paʼrrom. T̃arroʼmar ñerraʼm atet̃ yepeʼpaʼ oʼch chasaʼña vinospaʼ c̈hach aʼptsan orrot̃, vinosñapaʼ eʼñech shebhua, ñeñt̃ña orrot̃paʼ amaʼt mameshaʼpaʼ amach es sherberro. ");
INSERT INTO ameNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Añña ñerraʼm emasa vinos, arrchaʼña yesheʼ emerra orrot̃o ñeñt̃ ayec̈hcataret̃ paʼrrom. Allochñapaʼ amaʼtchaʼ chasaʼ vinospaʼ amach c̈ha potsaʼp̃soña vinos ñeñt̃paʼ allach yechen epoʼmar. Ñeñt̃paʼc̈hoʼña att̃oña Jesúspaʼ eñotatanet ña poct̃ap̃ña eʼñe etserra. ");
INSERT INTO ameNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Poʼpoñonet̃paʼ alla tomaʼntaterraneterr Jesús, ñeñt̃paʼ atet̃ oterraneterr: —Ñeñt̃ eʼñe yec̈henaya oʼch orran coʼnes ñeñt̃ atarr chaseʼpaʼ ñapaʼ ama mueno oʼch orran coʼnes emasa, t̃arroʼmar ñapaʼ atet̃ oten ñeñt̃ atet̃ yec̈hena ahuat̃ot̃eñpaʼ ñeñt̃a eʼñe cohuen enten. ");
INSERT INTO ameNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Allempoña c̈herrerr allempo c̈hocma amesen judioneshaʼ. Allempoña Jesúspaʼ arr oñem chetsoʼmar epuet pueyochreshac̈hno. Allempo oñenet chetsoʼmar pueyochreshaʼñapaʼ tasoʼtam̃pesyesnomuet puechm̃aʼtets trigo aʼsheʼchallmeʼchyesnomet att̃ot̃ rrocllomeʼchachet oʼ rraʼyesnomet. ");
INSERT INTO ameNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ñeñt̃ña patantaʼtets fariseoneshaʼpaʼ cheʼptareʼtanet, atet̃ otaret̃tet: —Esoʼmareʼtña atet̃ sepena ñeñt̃ ama pocteyaye oʼch atet̃ yep̃a t̃arroʼmar t̃eʼpaʼ añe yet̃ro ñeñt̃ atet̃ anaret̃ ahuat̃ot̃eñ allempocmach yamesen. ");
INSERT INTO ameNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesúsñapaʼ otanet: —Sapaʼ amaʼtrra selleyareña añ ñoñets all oten ñeñt̃ atet̃ p̃a ahuat̃ David allempo cheporraʼnma epuet ñam̃a allohuen ñeñt̃ cot̃eneʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ña allempopaʼ beʼt̃osos Yompor paʼpacllo, allñapaʼ chetosan pan ñeñt̃ atmaʼntataret̃ atet̃ ñerraʼmrrat̃eʼ ñeñt̃ nenet all Partsocop. Ñehua, ñeñt̃ panpaʼ ama pocteyayñe oʼch eseshaʼ rreʼ. Ñeñt̃paʼ añach ñapuet̃ rreneʼ cornaneshac̈hno; ñeñt̃paʼ eʼñe atet̃ anuaret̃ judioneshacop. Ñeñt̃ña panpaʼ oʼ chetos David, rros, rratosan ñam̃a allohuen ñeñt̃ epuet. ");
INSERT INTO ameNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Allempoña alla oterraneterr Jesús, ñeñt̃paʼ atet̃ otanet: —Ñeñt̃oʼmarña t̃eʼpaʼ oʼch notas, na Ñeñt̃en Acheñetosets ñeñt̃en allsensaret̃en, nacaʼye atet̃ otets est̃eʼ poctetsaña ñeñt̃chaʼ atet̃ yep̃a añe yet̃ro allempocma yamesen. ");
INSERT INTO ameNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Allempoñapaʼ c̈herrerr poʼpocheño ñeñt̃ yet̃ñatsro allempocma amesenet. Jesúsñapaʼ beʼt̃osuenerr judioneshaʼ poʼprahuo. Allñapaʼ yec̈hatyesuenanerr acheñeneshaʼ. Allñapaʼ alloʼtsen ñam̃a puesheñarr yacma ñeñt̃ c̈ha chellena pot poʼcohuenrot̃. ");
INSERT INTO ameNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Acheñeneshaʼña ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ epuet ñam̃a fariseoneshaʼ ñetña allpaʼ Jesúsa atarr cohuanaʼtyenet att̃och enteñeterr ñatoʼrraña oʼch aʼcrratenanerr acheñ añe yet̃ro allempocma amesenet. Ñerraʼm oʼch aʼcrratenanerr amaʼt puesheñarra acheñ añe yet̃ro allempo amesenet, allempoñapaʼ eshecchaʼ aʼmet̃am̃peñetaʼ am̃chaʼtaret̃esho. ");
INSERT INTO ameNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesúsñapaʼ eñotanet ñeñt̃ atet̃ cot̃apeʼchatseʼtyenet pueyoc̈hreto. Ñañapaʼ atet̃ otan yacma ñeñt̃ chelletsa pot: —Ap̃on p̃at̃omos arrma. Yacmaña huapapaʼ oʼ t̃omos all rroc̈ho. ");
INSERT INTO ameNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesúsñapaʼ atet̃ otanet: —Ñehua, napaʼ oʼch naʼp̃t̃oʼtas: ¿Erraʼtsenaʼtña ñeñt̃ eʼñe pocteʼ senten ñeñt̃chaʼ atet̃ yep̃a añ yet̃ro allempo yamesen? Ñatoʼ oʼch atet̃ yepeʼ eʼñe cohuen poʼpsheñeñ, amapaʼ ñatoʼ oʼch atet̃ yepoñ ñeñt̃ ama pocteyaye. Ñatoʼ añt̃eʼ pocteʼ senten oʼch yaʼcrrach acheñ amapaʼ añt̃eʼ pocteʼ senten amach yaʼcrratatsche c̈hachña yemtsatach. Ñetñapaʼ amaʼt puesheñarrot̃etapaʼ ama eseshayeʼ anapuenaye entaye. ");
INSERT INTO ameNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ñañapaʼ cohuaʼyesan allohuen ñeñt̃ anorrc̈hets all, allempoñapaʼ otan ñeñt̃ chelletsa pot: —T̃eʼpaʼ oʼch notap̃: Petapuerr p̃ot. Eʼñe otueʼpaʼ ñañapaʼ allent̃epaʼtchaʼ tapuerran pot, oʼ eʼñe cohuenterra pot. ");
INSERT INTO ameNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Fariseoneshaʼñapaʼ ñeñt̃ña atarr atsrreʼmatahuet. Allempoñapaʼ cot̃apeʼchatannaʼtet, atarr oʼpachet Jesús. ");
INSERT INTO ameNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Allempoña Jesúspaʼ oʼ alla ahuerrerr aʼyo aspent̃o allchaʼ maʼyochenaʼ. Allñapaʼ arepen maʼyochaya Pompor. ");
INSERT INTO ameNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tsapat̃ña puetarenpaʼ agotaʼmuenan allohuen ñeñt̃ pueyochreshac̈hno pen. Allempo c̈hac̈haʼtet ñeshopaʼ ñañapaʼ oʼ acrapan ñeñt̃ c̈harrasheña ñeñt̃ puechetsa epsheña ñeñt̃chaʼ llesensaʼ ñeñt̃chaʼ serrpareʼtyetsaʼ allemeñ anetsoʼmar. ");
INSERT INTO ameNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ñeñt̃ llesensaʼ ñeñt̃paʼ añec̈hno: Simón ñeñt̃ socherr Pedro, allot̃paʼ ñam̃a paʼmoʼnasheñ Andrés, allot̃paʼ Jacobo ñam̃a paʼmoʼnasheñ Juan, allot̃paʼ Felipe, ñam̃a Bartolomé, ");
INSERT INTO ameNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ñam̃a Mateo ñam̃a Tomás ñam̃a Jacobo ñeñt̃ Alfeo puechemer, ñam̃a ñeñt̃ poʼpsheñeñ Simón ñeñt̃ cananistaneshaʼ ñeñt̃ atarr t̃orratseʼt̃ paʼnetsrecop, ");
INSERT INTO ameNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","allot̃paʼ ñam̃a Judas ñeñt̃ Jacobo paʼmoʼnasheñ, allot̃paʼ ñam̃a poʼpsheñeñ Judas Iscariote ñeñt̃chaʼ pomuerreʼ tsapat̃onet̃ Jesús. ");
INSERT INTO ameNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Allempoña huerra Jesús aspent̃ot̃ epuet pueyochreshaʼ, t̃omc̈haʼtuerret all aspenet̃ pacñeʼt̃pener poño poʼmopñero. Allñapaʼ oʼ c̈hac̈haʼt shonteʼ poʼpotantañ acheñeneshaʼ ñeñt̃ pueyochreshaʼ pen. Ñam̃a alloʼtsaʼyen shonteʼ acheñeneshaʼ ñeñt̃ huac̈hetsa allemeñ anetsot̃—Judeot̃ ñam̃a Jerusaléñot̃, ñam̃a saʼpatop̃ñoʼmarneshaʼ ñeñt̃ huetsa Tirot̃ ñam̃a Sidónot̃. Ñetpaʼ añecopña huac̈henet oʼch eʼm̃ñoteret ñamet Jesús ñeñt̃ atet̃ serrpareʼten ñam̃a añecpaʼnaña huac̈henet att̃och aʼcrratyesapanet Jesús patsnañet̃eret. ");
INSERT INTO ameNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Amaʼt ñam̃a allohuen ñeñt̃ mueroc̈htatyen oneñet̃ ñañapaʼ eʼñe aʼcrratyesuapanet. ");
INSERT INTO ameNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Allohuenña acheñeneshaʼpaʼ atarr mueneñet oʼch aʼp̃lloset Jesús t̃arroʼmar ñapaʼ ña atarr ahuamencat̃eshaʼ, eʼñe ña poʼhuamencot̃ aʼcrratyenan allohuen acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Allempoña Jesúspaʼ cohuaʼyesan ñeñt̃ pueyochreshaʼ pen, ñañapaʼ atet̃ otanet: —Ñeñt̃es atarr huocchañneshaʼ entetsa ñeñt̃eschaʼña atarrchaʼ cosheñtsoʼtsaʼyenes t̃arroʼmar sapaʼ oʼpataterrsach Yompor poʼcohuenña att̃o atarr ayochreshat̃tena ña. ");
INSERT INTO ameNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Ñam̃a sapaʼ ñeñt̃es cheporrareʼtyetsa t̃eʼ ñeñt̃eschaʼña atarrchaʼ cosheñtsoʼtsaʼyenes t̃arroʼmar Yomporchaʼña eʼñe señmataterreʼ. ’Ñam̃a sapaʼ ñeñt̃es yahuetsa t̃eʼ eʼñe sellquëñot̃ ñeñt̃eschaʼña atarrchaʼ cosheñtsoʼtsaʼyenes t̃arroʼmar Yomporchaʼña eʼñe secheʼtaterreʼ socsheñot̃. ");
INSERT INTO ameNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Ñam̃a sapaʼ atarr cosheñtsoʼtsaʼyenes ñerraʼm esempo eʼmoñeʼtenset noʼmar ñerraʼm esempo mueñoʼtenset, ñerraʼm esempo puesasareʼteñot̃etas sochatseʼtenset t̃arroʼmar sapaʼ na sameʼñena Ñeñt̃en Acheñetosets. ");
INSERT INTO ameNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Allempo atet̃ penset ñeñt̃ ama cohuenayaye, sañapaʼ socshepaʼch nanac ñam̃a señochepaʼch shonteʼ ñeñt̃ oʼpatatensa Yompor pueʼntaño ñeñt̃chaʼña atarr socshaterreʼ. Ñehua, ñetpaʼ paʼtañneshañpaʼ att̃ecma mueroc̈htatyeseteʼt̃ ñam̃a ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ ahuat̃. ");
INSERT INTO ameNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’T̃arraña t̃eʼpaʼ oʼch notas sa ñeñt̃es atarr ec̃llayoret̃es ñeñt̃es echeneʼ ora allpon ñeñt̃ eʼñe socpa. Sapaʼ ñeñt̃eschaʼña atarr llequëñtsoʼtsaʼyenes t̃arroʼmar esempopaʼ huañerrchaʼ ñeñt̃ socshateneʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Ñam̃a atarr llequëñtsoʼtsaʼyenes ñeñt̃es atarr esocmañen es echyets allo eʼñe señmatena seyeteñot̃. C̈herrchaʼ allempoch atarr sepallterra ñeñt̃chaʼ serrar seperr. ’Ñam̃a atarr llequëñtsoʼtsaʼyenes sa ñeñt̃es t̃eʼpaʼ eʼñe socsheñeshaʼ secheʼtatsetyena. C̈herrchaʼña allempoch seyahuerra sellquëñot̃. ");
INSERT INTO ameNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Ñam̃a atarr llequëñtsoʼtsaʼyenes ñerraʼm esempo allohuen acheñeneshaʼ eʼñech cohuen entapretenset, eʼñe cohuen eñosyenet socop. T̃arroʼmar ñetpaʼ atet̃ peteʼt̃ paʼtañneshañ ahuat̃, eʼñe cohuen eñosyeseteʼt̃ añ acheñreneshacop ñeñt̃ amaʼt ama Yomporeyeʼ poʼñoñ aʼm̃taʼyeseteʼt̃e. ");
INSERT INTO ameNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Sa ñeñt̃es neʼm̃ñoteneʼ oʼch notas ñeñt̃chaʼ atet̃ sep̃a eʼñe cohuen, semueryach amaʼt ñeñt̃ seʼmoñeʼteneʼ. Oʼch atet̃ sepeʼ eʼñe cohuen. ");
INSERT INTO ameNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ñam̃a amaʼt erraʼtsen ñeñt̃ sarrnomareʼtenaya sañapaʼ oʼch senamaterrñañ Yompor paʼnateña. Ñam̃a ñeñt̃ sesasareʼteneʼ sañapaʼ oʼch semaʼyocham̃penanet. ");
INSERT INTO ameNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nehua, atet̃ ñerraʼm esempo eseshaʼ pueʼmoñeʼteñot̃etas oʼch tacllaset setsaʼpo, sañapaʼ poctepaʼchña señch tacllerrserrepaʼ ñam̃a poʼpshem̃tañot̃. Ñam̃a ñerraʼm esempo eseshaʼ seprratam̃p̃seʼ seshtam, sañapaʼ poctepaʼchña señch puerratam̃p̃sasetepaʼ seshtam ñeñt̃ muenenet amaʼt ñam̃a poʼpmañ seshtam allo sepmatena. ");
INSERT INTO ameNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ñerraʼm eseshaʼ es senamueneʼ sañapaʼ sapepaʼch amaʼt esesha. Ñam̃a ñerraʼm eseshaʼ seyoratsreʼtam̃p̃seʼ sañapaʼ amach alla senamatstere apuerrsetepaʼ alla. ");
INSERT INTO ameNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ñehua, ñerraʼm erraʼtsent̃eʼ eʼñe cohuen senten ñeñt̃ semnen sa ñeñt̃chaʼ atet̃ p̃onas poʼpsheñeñ, sapaʼc̈hoʼña eʼñech att̃ecma sep̃anet sam̃a. ");
INSERT INTO ameNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Ñam̃a sa ñerraʼm aña semorrentena ñeñt̃ atarr semorrentenaya sam̃a, ñeñt̃paʼ amach eʼñeyeʼ sorrtatenoña ñeñt̃ eʼñe poʼñoc̈h cohuentetsa, t̃arroʼmar ñeñt̃ ama ameʼñenayo Yompor ñetpa aña morrentenet ñeñt̃ eʼñe morrentenahuet ñamet. Añña atarr cohuentetsa amaʼt ñeñt̃ ama yemorrentenayepaʼ oʼch yemorreñcha eʼñe cohuen. ");
INSERT INTO ameNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ñam̃a ñerraʼm aña eʼñe cohuen seyenpaʼyen ñeñt̃ seyenpaʼyeneʼ sam̃a, ñeñt̃paʼ ama eʼñeyeʼ sorrtatenoña ñeñt̃ eʼñe poʼñoc̈h cohuentetsa, t̃arroʼmar ñeñt̃ ama ameʼñenayo Yompor ñetpaʼ aña yenpaʼyenet ñeñt̃ yenpaʼyenahuet ñamet. ");
INSERT INTO ameNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ñam̃a ñerraʼm añecpa es sartannaʼtyena att̃och ellopaʼ oʼch alla apuerrset sam̃a, ñeñt̃ atet̃ sepenapaʼ ama eʼñeyeʼ sorrtatenoña ñeñt̃ eʼñe poʼñoc̈h cohuentetsa; añchaʼña es saretyena poʼpsheñeñ amaʼt ñetpaʼ amaʼtchaʼ ama apuerrseto amaʼt coñeʼt̃a, t̃arroʼmar atet̃ pena ñeñt̃ ama ameʼñenayo Yompor ñerraʼm eñoteñet oʼch alla aparet̃terret ñamet eshecchaʼña archet poʼpsheñeñ. ");
INSERT INTO ameNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","T̃arraña napaʼ oʼch notas, sapaʼ añeʼnachña semorrentena amaʼt ñeñt̃ seʼmoñeʼteneʼ. Ñam̃a sapaʼ añeʼnachña seyenpuen amaʼt ñeñt̃ ama seyenpuenaye. Ñam̃a sapaʼ añeʼnachña es saretyena amaʼt ñeñt̃chaʼ ama sapuerraye. Ñerraʼm atet̃chaʼ sep̃a Yomporñapaʼ apuerreschaʼ ello ñeñt̃chaʼ atarr socshatuerreʼ. Ñapaʼ allempoch eʼñe puechemer perres, ñeñt̃ara Yompor Ñeñt̃ Nanac Parets. T̃arroʼmar ñapaʼ añeʼnaña muerena amaʼt ñeñt̃chaʼ ama coshaterraye ña, ñeñt̃ara ñeñt̃ ama cohuenayeʼ es petso. ");
INSERT INTO ameNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Sapaʼc̈hoʼña atarrepaʼchña semuerannaʼta eʼñe atet̃ pena ñeñt̃ Yeyomporer yepen atarr muerenya yam̃a. ");
INSERT INTO ameNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Sapaʼ amach sotatsche poʼpsheñeñ “ama pocteyaye ñeñt̃ atet̃ sep̃aʼyena”, allochñapaʼ amach otuerrso sam̃a Yompor ama pocteyaye ñeñt̃ atet̃ sep̃aʼyena sam̃a. Ñam̃a eʼñe att̃ot̃apaʼ amach sott̃eñeʼchatsche poʼpsheñeñ allochñapaʼ Yomporpaʼc̈hoʼña amach otteñeʼchuerrso sam̃a, c̈hochña eʼñe cohuen sep̃retnannena allochñapaʼ Yomporpaʼc̈hoʼña eʼñech cohuen peretnaʼhuerres sam̃a. ");
INSERT INTO ameNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ñam̃a sapaʼ eʼñech cohuen es sapannaʼtyena allochñapaʼ Yomporpaʼc̈hoʼña eʼñech cohuen es apuerres sam̃a. Shonteʼch nanac es apuerres, atet̃ ñerraʼmrrat̃eʼ c̈ho es eʼchorratenset soshaco atet̃ ñerraʼm c̈hop eʼcharet̃. Oʼch chorrapaʼ oʼch aʼrrapuet eshecchaʼ eshaʼtereterr poʼpoñ, ñerraʼm oʼch chorrerrerrpaʼ oʼch paʼshmuet att̃och eʼñe aʼt̃amoʼyonaset. Ñeñt̃paʼ añ tomaʼntena att̃o es apueney Yompor nanac aton. Ñam̃a errponchaʼ sap̃ poʼpsheñeñ, sapaʼc̈hoʼña eʼñech allpon apuerres sam̃a Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Allempoña Jesúspaʼ atet̃ tomaʼntaterraneterr, ñeñt̃paʼ atet̃ otanet: —Ñeñt̃ aporoʼyet̃paʼ ñapaʼ amach errot̃enot̃ echaʼnmano poʼpsheñeñ ñeñt̃ parro aporoʼyet̃ecmuet. T̃arroʼmar ñerraʼm atet̃ penet, ñerraʼm arrorot̃ont̃a echaʼnmannaʼtnomuetpaʼ epsheñoʼmaret c̈hach shoraʼnmuet arrorot̃o. Arrpaʼ allohua ñeñt̃ atet̃ tomaʼntatanet atet̃ ñerraʼm ya allempo ama yoct̃apeʼcherraʼ ñeñt̃ cohuentetsa Yomporecop amach errot̃enot̃ yoct̃apeʼchache poʼpsheñeñ ñeñt̃ ama eñotenaye ñeñt̃ cohuen enten Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","’Ñeñt̃ ayc̈hataret̃tetsapaʼ amaʼt puesheñarra amach errot̃enot̃ metanetoña ñeñt̃ allpon eñoten ñeñt̃ yec̈hateneʼ. Amaʼt allempo eʼñe ayc̈hataret̃tapaʼ eʼñech allpona yec̈haʼ ñeñt̃ allpon eñoten ñam̃a ñeñt̃ yec̈hateʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Amach atet̃ sentatsche poʼpotantañ ñerraʼm ñetpaʼ ama cohuenayeʼ es peneto amaʼt sapaʼ ama sentenoña ñeñt̃ atet̃ sep̃aʼyena sa; ñeñt̃paʼ ello sem̃taneñña poʼpotantañ ñeñt̃ atet̃ es p̃aʼyenet ñet. Ñerraʼm ama cohuenayeʼ es sepeno sam̃apaʼ amach sotatscheña poʼpotantañ: “Masheñchaʼ napaʼ oʼch noct̃apeʼchaterrep̃ eʼñe cohuen.” T̃arroʼmar ñerraʼm atet̃ sepenapaʼ c̈ha sommoʼchena. Ñanomchaʼña añ sehuaporeʼterr ñeñt̃ ama cohuenayeʼ sepeno sa, allochñapaʼ att̃och señoch cot̃apeʼchateʼ samoʼts eʼñe cohuen. Ñeñt̃paʼ añ tomaʼntena oʼch senten poʼpsheñeñ paʼclloyoʼtsen puepachña amaʼt sa seclloyopaʼ alloʼtsen tsach; ñeñt̃ñapaʼ ama senteñe. Ñerraʼm atet̃paʼ amach errot̃enot̃ socheña poʼpsheñeñ: “Masheñchaʼ napaʼ oʼch nechterrnap̃ peclloyot̃ pepachña.” T̃arroʼmar añ tsach ñeñt̃ seclloyoʼtsenpaʼ c̈ha aʼnpuennasña att̃och eʼñe cohuen es sentyen. Ñanomchaʼña añ sehuaporeʼterr tsach seclloyot̃ allochñapaʼ att̃och eʼñe cohuen es sentyen. Att̃ochña eʼñe cohuen sechterrñañ poʼpsheñeñ puepachña paʼclloyot̃. ");
INSERT INTO ameNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’T̃arroʼmar allohuen acheñ ñeñt̃ eʼñe poʼñoc̈h cohuen acheñer, ñetñapaʼ añchaʼ orrtatyenet ñeñt̃ eʼñe cohuenareʼ. T̃arraña poʼpotantañ acheñeneshaʼ ñeñt̃ poʼñoc̈h ama cohuenayaye ñetñapaʼ añach orrtatyenet ñeñt̃ ama cohuenayaye. Ñeñt̃paʼ atet̃chaʼ netmaʼntaterrsa: Ora allohuen ñeñt̃ eʼñe cohuen narmetsoch, pueʼmerpaʼc̈hoʼña eʼñech cohuenareʼ. Añña poʼpchañec̈hno narmetsoch ñeñt̃ ama cohuenayayepaʼ pueʼmerpaʼc̈hoʼña amach eʼñe cohuenayaye. ");
INSERT INTO ameNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ñeñt̃oʼmarña att̃oña yeñoten erraʼtsent̃eʼ ñeñt̃ eʼñe cohuenareʼ narmetsoch ñam̃a ñeñt̃ ama cohuenayaye, pueʼmerot̃ña eʼñe yechmeʼteñ. Ñam̃a yapaʼ eʼñe yeñoteñ ama arrot̃eyeʼ yet̃oquënoña lloʼm ajchot̃. Ñam̃a ama arrot̃eyeʼ yet̃oquënoña ap rrenagachot̃. ");
INSERT INTO ameNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Amaʼt erraʼtsena acheñer ñeñt̃ eʼñe poʼñoc̈h cohuen, ñapaʼ añchaʼña orrtaten ñeñt̃ eʼñe cohuenareʼ cot̃apeʼchen pueyoc̈hro t̃arroʼmar pueyoc̈hro allña shonteʼ cot̃apeʼchenan ñeñt̃ cohuentetsa. T̃arraña poʼpoñ acheñer ñeñt̃ poʼñoc̈h ama cohuenayaye, ñapaʼc̈hoʼña añach orrtaten ñeñt̃ atet̃ cot̃apeʼchen pueyoc̈hro ñeñt̃ ama cohuenayaye t̃arroʼmar pueyoc̈hro allña shonteʼ paʼnamen cot̃apeʼchenan sosyaʼtsañ. T̃arroʼmar ñerraʼm shonteʼ yoct̃apeʼchen yeyoc̈hro ñeñt̃ cohuentetsa, ñeñt̃paʼ eʼñech ñeñt̃a cohuen yeserrpareʼten. T̃arraña ñerraʼm shonteʼ yoct̃apeʼchen ñam̃a yeyoc̈hro ñeñt̃ ama cohuenayayepaʼ ñeñt̃paʼc̈hoʼña eʼñech ñeñt̃a yemnen oʼch yeserrpareʼteñ. ");
INSERT INTO ameNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’Sapaʼ esoʼmaruañacaʼyeña sotenen napaʼ Saʼyochreshat̃eroʼ sepenen, sapaʼ amacaʼ c̈hoyeʼ sameʼñenno ñeñt̃ atet̃ oʼ notuas. ");
INSERT INTO ameNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Allohuen erraʼtsenchaʼ huapatsa nesho ñeñt̃chaʼ nameʼñenaya na ñam̃a ñerraʼm eʼm̃ñotennanet neñoñ ñeñt̃ atet̃ cohuen neyc̈hatenanet ñerraʼm atet̃ eʼñe penet, ñetñapaʼ atarrchaʼ eñotenet ñeñt̃ eʼñe poʼñoc̈h sherbets. ");
INSERT INTO ameNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ñeñt̃ acheñer ñeñt̃ atet̃ petsa oʼch netmaʼntacha atet̃ ñerraʼmrrat̃eʼ puesheñarr yacma ñeñt̃ atarr es eñotets ñeñt̃ t̃omateneʼ pocoll ñeñt̃ eʼñech echarr penan paʼpaquëll. Ñañapaʼ atarrchaʼ oʼpono eñan pats att̃och eʼñe echarr p̃an poʼquellpach. Att̃eñapaʼ oʼ c̈hap allempo apellchena oñ, pocollñapaʼ ama aʼmato apellcheʼ t̃arroʼmar quellpachpaʼ atarr huomenc at̃omataret̃. ");
INSERT INTO ameNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","T̃arraña poʼpotantañ ñeñt̃ eʼmueneʼ neñoñ ñetña ñerraʼm ama att̃eyeʼ peneto ñeñt̃ atet̃ notenanet, ñetñapaʼ eʼñech att̃et ñerraʼmrrat̃eʼ puesheñarr yacma ñeñt̃ ama es eñoto. Ñapaʼc̈hoʼña oʼ t̃omataneñ paʼpaquëll t̃arraña ñañapaʼ ama atarr oʼponoyeʼ eñanoña pats att̃och eʼñe echarr p̃an poʼquellpach. Allempoñapaʼ apellcha oñ apellcheʼñapaʼ c̈hepaʼtchaʼ aʼmatam̃p̃sos paʼpaquëll. Pocollñapaʼ eʼñe poctacma muelloʼtstosa. ");
INSERT INTO ameNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Allempoña Jesúspaʼ serrpareʼtatuerranerr allohuen acheñeneshaʼ ñeñt̃ eʼm̃ñoteneʼ, ñañapaʼ ahuerrerr, oʼ c̈herrerr Capernaumo. ");
INSERT INTO ameNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Allñapaʼ alloʼtsen puesheñarr yacma ñeñt̃ solltar poʼcap̃taner, ñeñt̃paʼ romoʼmarneshaʼ, ama judioneshayaye. Ñeñt̃ña capitánpaʼ echenan puesheñarr paʼtaruasañer c̈ha atsnaʼten atarr paʼnat̃tena, ñañapaʼ atarr morrentenana paʼtaruasañer. ");
INSERT INTO ameNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ñeñt̃ña capitánpaʼ allempo eʼmareʼtan Jesús oʼ alla c̈herr Capernaumo, ñañapaʼ oʼ mueñan patantarr acheñ ñeñt̃ pomporneshaʼ pen judioneshaʼ, oʼch oteñetaʼ Jesús att̃o agotateñ capitán oʼch aʼcrraterrñañaʼ paʼtaruasañer. ");
INSERT INTO ameNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Allempoña c̈hapuet Jesúseshopaʼ ñetñapaʼ atet̃ otoset: —Ñeñt̃ capitánpaʼ ñapaʼ atarr cohuen acheñ, ñapaʼ atarr morrentenya ya ñeñt̃ey israelenaʼtarey, amaʼt yeprahuapaʼ oʼ t̃omatatuosnay. Ñeñt̃oʼmarña amaʼt yapaʼ eʼñe pocteʼ yenteñ oʼch peyenpueñaʼ ñam̃a, ñapaʼ amaʼt ama judioneshayaye. Att̃oña atarr enamueñet Jesús att̃och yenpuenanaʼ capitán. ");
INSERT INTO ameNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Allempoñapaʼ cot̃aʼnerranet Jesús. C̈hapmochet capitán paʼpacllo, capitánñapaʼ mueñerranerr poʼpotantañ acheñ ñeñt̃ parro yemtena ñeñt̃chaʼ otapueʼ Jesús atet̃ oten capitán: —Yapaʼ atet̃ otapuey capitán att̃oʼch yotapap̃: “Amach Ayochreshat̃e atsrreʼmoc̈hen nentatatstapape t̃arroʼmar napaʼ ama cohuenayayno att̃och pebeʼt̃osapoʼtam̃pesna nepacllo. ");
INSERT INTO ameNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Napaʼ ama cohuenayayno ñeñt̃oʼmarña aña nemñen poʼpsheñeñ ñeñt̃chaʼ nepoctatapap̃, ñeñt̃chaʼ p̃otap correrrepaʼ naʼtaruasañer, ñañapaʼ acrrerrocheʼch. ");
INSERT INTO ameNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","T̃arroʼmar napaʼ ñeñt̃en ñeñt̃ atet̃ petsa ñeñt̃ atet̃ otenen ñeñt̃ neyechenaya. Ñam̃a napaʼc̈hoʼña eñall ñeñt̃ neyechena nam̃a ñeñt̃ nesolltarer nepen. Ñerraʼm puesheñarr solltar noteñ: P̃apaʼ oʼch ahuep̃ aʼyo, ñañapaʼ oʼchc̈hoʼ ahuoʼ. Ñam̃a poʼpsheñeñ solltar ñerraʼm oʼch noch: P̃apaʼ ap̃on arr, ñañapaʼ oʼchc̈hoʼ huapa. Ñam̃a poʼpsheñeñ naʼtaruasañer ñerraʼm oʼch noch: P̃apaʼ arrchaʼ petaruasaʼmuen, ñañapaʼ allchaʼc̈hoʼ taruasaʼmuen. Ñeñt̃oʼmarña napaʼ neñotenep̃ ñerraʼm errot̃en p̃otenpaʼ eʼñechcaʼye atet̃ pena.” ");
INSERT INTO ameNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Allempo eʼman Jesús ñeñt̃ atet̃ oten capitán, ñañapaʼ alla cohuaʼyesan allohuen acheñeneshaʼ ñeñt̃ cot̃aʼneneʼ. Ñañapaʼ atet̃ otanet: —Errot̃enot̃uañacaʼyeña atarr yemtenna, ñapaʼ amacaʼye judioneshayaye. Napaʼ oʼch notas, amaʼt ahuat̃apaʼ ama nentareña acheñ ñeñt̃ eʼñe atet̃ neyemtenaya, amaʼt allohuen israelenaʼtarneshaʼpaʼ amaʼt puesheñarra ama nentareña ñeñt̃ atet̃ atarr neyemtenaya. Amaʼtpaʼ correrrepaʼ paʼtaruasañer. ");
INSERT INTO ameNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Allempoña ñeñt̃ pocteʼ Jesús oʼ ahuanerret capitán paʼpacllo. Ñetñapaʼ entuerrñañet capitán paʼtaruasañer oʼ eʼñe correrra. ");
INSERT INTO ameNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Allempo allponmaterrerr, Jesúsñapaʼ ahuerrerr poʼpoñ anetso, ñeñt̃ añets añ paʼsoʼcheñ Naín. Alla cot̃aʼhuanererr pueyochreshaʼ ñam̃a shonteʼ poʼpotantañ acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Oʼ c̈hapmochet all allot̃ecma beʼt̃enet att̃och c̈hapuet anetso. Allot̃ñapaʼ c̈haʼnmac̈haʼtos ñeñt̃ aneneʼ arromñat̃, oʼch pampueñetaʼ. Arromñat̃ñapaʼ asheñorr ñeñt̃ eʼñe poʼpat̃rror pen pachor. Pachorñapaʼ rret̃orrnaneshaʼ. Shonteʼ acheñ ñeñt̃ alloʼmarneshaʼ ñeñt̃ llecapretnenaya rret̃orrnaneshaʼ all cot̃aʼneñet. ");
INSERT INTO ameNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Partseshaʼña Jesús allempo entapan rret̃orrnaneshaʼ puellcapreteñot̃paʼ atarr muerosya. Ñañapaʼ atet̃ otapan rret̃orrnaneshaʼ: —Amach noc̈ha peyahuatsto. ");
INSERT INTO ameNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Allempoña ponmapana arromñat̃, aʼp̃llataʼtosñañ poʼcajon. Ñeñt̃ña aneneʼpaʼ alla t̃omc̈haʼtoset. Jesúsñapaʼ otan huepueshaʼ ñeñt̃ rromuets: —Napaʼ oʼch notap̃: ¡T̃eʼpaʼ oʼch petanterra! ");
INSERT INTO ameNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Eʼñe otueʼpaʼ ñeñt̃ña arromñat̃paʼ allent̃a tanterra c̈ha eñorerrtsa. Jesúsñapa oʼ alla apuerrñañ pachor. ");
INSERT INTO ameNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Acheñeneshaʼñapaʼ atarr nanac yorenet. Poʼyorñot̃etpaʼ atarr ayeʼchoc̈htateññañet Yompor. Ñetñapaʼ atet̃ otyenet: —T̃eʼpaʼ oʼ orrtonaya puesheñarr ñeñt̃ atarr sherbets ñeñt̃ aʼm̃teneʼ Yompor poʼñoñ. Yomporpaʼ oʼ yerpuerrya ñeñt̃ey eʼñe pueyochreshay peney. ");
INSERT INTO ameNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Att̃oña acheñeneshaʼñapaʼ epayeʼ serrpareʼtyesuerret ñeñt̃ atet̃ p̃aʼyena Jesús. Oʼ eʼñe epaʼhua ora Judeoʼmar ñam̃a ora erracmañen allampañoʼmar. ");
INSERT INTO ameNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Añña Juan ñeñt̃ ayottam̃p̃saret̃, ñañapaʼ c̈hocma serrpareʼtateñ pueyochreshaʼ ñeñt̃ atet̃ p̃aʼyena Jesús. ");
INSERT INTO ameNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Att̃eña Juanñapaʼ agotatan epsheña ñeñt̃ pueyochreshaʼ pen ñeñt̃chaʼ mueña Jesúsesho ñeñt̃chaʼ aʼp̃t̃oʼtenayaʼ Jesús poʼñoc̈ht̃eʼ ñapaʼ ñeñt̃ Cristotets ñeñt̃ atarr cohuenet ahuat̃ot̃eñ, ñatoʼ amat̃eʼ ñeñt̃eyayepaʼ añchaʼ cohuet poʼpsheñeñ ñeñt̃chaʼ huapatsa. ");
INSERT INTO ameNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Allempoña ñetpaʼ ahuanmuet. Allempo c̈hapuet alloʼtsen Jesús, Jesúsñapaʼ añ t̃orraʼyena aʼcrratanatyeseʼ shonteʼ acheñeneshaʼ ñeñt̃ atsnaʼtyets ñeñt̃ paʼnamen mueroc̈htatyenahuet. Ñam̃a ñeñt̃ chorraʼyena oneñet̃ ñapaʼ oʼ eʼñe cac̈hpatatuerranet oneñet̃. Ñam̃a shonteʼ aporoʼyet̃ec̈hno ñañapaʼ oʼ alla eʼñe cohuatyesuerranet. Ñeñt̃ña Juan pueyochreshaʼpaʼ aʼp̃t̃oʼtoset Jesús, atet̃ otoset: —Juan ñeñt̃ apatañtatseʼt̃ Yomporecop yapaʼ ñeñt̃ña yemñeneʼ oʼch yotenp̃aʼ, ñatoʼ p̃at̃eʼña ñeñt̃ep̃t̃eʼ eʼñe poʼñoc̈h Cristotets ñeñt̃ atarr yecuen ahuat̃ot̃eñ oʼch huapa; ñerraʼm amat̃eʼ ñeñt̃eyaypepaʼ oʼch eʼñe p̃otey allochñapaʼ añchaʼ yecuaʼ poʼpsheñeñ ñeñt̃chaʼ huapatsa ñeñt̃ eʼñe Cristo. ");
INSERT INTO ameNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesúsñapaʼ otapanet: —T̃eʼpaʼ oʼch ahuerres seserrpareʼtatuerchaʼ Juan ora allpon ñeñt̃ atet̃ sentyesuennanaʼ arr ñam̃a ora allpon ñeñt̃ atet̃ seʼmyesuennanaʼ arr. Oʼch eʼñe seserrpareʼtatuer ora amaʼt att̃o aporoʼyet̃ec̈hnopaʼ t̃eʼñapaʼ oʼ eʼñe necuatyesuerranet, ñam̃a ñeñt̃ checaʼrepayetspaʼ t̃eʼpaʼ oʼ eʼñe chopeʼchyesuerret, ñam̃a ñeñt̃ osyen puetsarñats, t̃eʼpaʼ oʼ eʼñe aʼcohuentataret̃etuerret ñamet, ñam̃a paquetneshac̈hnopaʼ amaʼt ñetpaʼ t̃eʼñapaʼ oʼ eʼñe eʼmyesuerret cohuen, amaʼt ñam̃a ñeñt̃ rromayets t̃eʼñapaʼ oʼ alla atantataret̃etuerret, ñam̃a amaʼt ñeñt̃ huocchañneshac̈hno t̃eʼñapaʼ oʼ eʼñe neserrpareʼtatuerranet añ cohuen ñoñets alloch queshperret ñamet. ");
INSERT INTO ameNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Jesúsñapaʼ alla oterranerr Juan pueyochreshaʼ: —Ñam̃a ellonet̃paʼ oʼch sotuer Juan ñeñt̃ atet̃ notenes: Atarr cosheñtsoʼtsen amaʼt allohuen ñeñt̃ atarr neyemtenaya na, ñeñt̃ ama eʼnenaye poʼpsheñeñ ñeñt̃chaʼ coshaterrahuet. ");
INSERT INTO ameNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Allempoña Juan pueyochreshaʼpaʼ oʼ ahuanerret. Jesúsñapaʼ alla serrpareʼtaterranerr acheñeneshaʼ ñeñt̃ atet̃ peʼt̃ ahuaña Juan, ñeñt̃paʼ atet̃ otanet: —Ahuaña allempo seteʼt̃ amayo all serrpareʼten Juan, sapaʼ amacaʼ añecpayeʼ seteʼt̃eña all oʼch sentenaʼ amuesmaʼ atet̃ aʼymaʼtateñ m̃orr. ");
INSERT INTO ameNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ñam̃a amacaʼ añecpayeʼ seteʼt̃eña all oʼch sentenaʼ ñeñt̃ atarr coc̈hneshaʼtetsa paʼshtam all, t̃arroʼmar yeñoteñ amayopaʼ amacaʼye eñalleña all ñeñt̃ atarr coc̈hneshaʼtetsa paʼshtam. Yapaʼ yeñoteñ arrña yentenña ñeñt̃ atarr coc̈hneshaʼ chorraʼyenaya shetamuets am̃chaʼtaret̃epahuo. ");
INSERT INTO ameNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Sapaʼ añecopcaʼyeña seteʼt̃ña amayo oʼch sentenaʼ all ñeñt̃ poʼñoc̈h aʼm̃teneʼ Yompor poʼñoñ. Napaʼ oʼch notas, Juanpaʼ att̃o atarr sherbenan Yomporpaʼ ello metanaʼtuenan allohuen ñeñt̃ att̃o aʼm̃tenet Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","T̃arroʼmar Juanpaʼ ñocop eñoseʼt̃ Yompor ahuat̃. Ñehua, allempopaʼ atet̃ otneʼt̃ na ñeñt̃ atet̃chaʼ p̃osa Juan nocop esempoch huapa, ñeñt̃paʼ atet̃ anaret̃ ñoñets ahuat̃ot̃eñ: P̃apaʼ peñochepaʼch napaʼ oʼch nemñonap̃ puesheñarr ñeñt̃chaʼ ñanom otatsa ñeñt̃chaʼ p̃aʼcohuentatyeseʼ p̃ocop allchaʼ p̃oñmos. ");
INSERT INTO ameNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ñeñt̃oʼmarña na t̃eʼpaʼ atet̃ notenes: Allohuen allpon acheñeneshaʼ ñeñt̃ eñalletetsa arr patsro amaʼt puesheñarra ama eñalleña ñeñt̃ atarr sherbets atet̃ ñerraʼmrrat̃eʼ Juan ñeñt̃ apatyesayeʼt̃ ahuaña acheñeneshaʼ Yomporecop. T̃arraña ñeñt̃ ama esosheʼmayeʼ enteneto amaʼt mamesha, t̃arraña ñerraʼm pueyochreshaʼ peñ Yompor att̃o t̃eʼpaʼ oʼ ayochreshat̃tena, ñeñt̃ña acheñerpaʼ atarrcaʼye sherben, ello metanenan att̃o atarr sherben Juan. ");
INSERT INTO ameNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Allohuen acheñeneshaʼ amaʼt ñam̃a ñeñt̃ ashcañetyestseʼt̃ att̃o atarr cobraʼyeseteʼt̃ quelle ñeñt̃ gobiernocop ñeñt̃ apatyes Juan, ñetñapaʼ att̃o eʼm̃ñotenetpaʼ otyeset: “Eʼñe pocteʼ atet̃ oteney Yompor.” ");
INSERT INTO ameNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","T̃arraña fariseoneshaʼ epuet ñam̃a ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop, ñetñapaʼ amaʼt eʼñe mamesha ama pocteyeʼ enteñeto ñeñt̃ atet̃ muenen Yompor ñocpuet, ñeñt̃oʼmarña ñetpaʼ ama apataneto Juan Yomporecop allempo. Partseshaʼñapaʼ atet̃ oterraneterr: ");
INSERT INTO ameNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","35","—Ñehua, napaʼ oʼch neñotatas ñeñt̃ atet̃ pena patantarr acheñeneshaʼ ñeñt̃ yentyen t̃eʼ ñeñt̃ amaʼt errot̃ena ama acshatpoteneto. Ñeñt̃paʼ fariseoneshaʼ atet̃ petsa. T̃arroʼmar amaʼt allempo orrta Juan ñeñt̃ apatañtatseʼt̃ ñapaʼ ama rraneʼt̃e ñeñt̃ yocrram̃ yepen allohueney, ama orraneʼt̃e ñeñt̃ecma yorren allohueney. Ñeñt̃oʼmarña ñapaʼ c̈ha sotyeseʼt̃ c̈hot̃eʼ chorreña oneñet̃, amaʼt eʼñe mameshapaʼ ama pocteyeʼ señcheʼt̃e. T̃eʼñapaʼ oʼ norrterra nam̃a Ñeñt̃en Acheñetosets. Napaʼ paʼnamen nerraʼyen ñam̃a norryen. Saña t̃eʼpaʼ att̃a sesochatseʼtyenen ñam̃a atarroʼ arratsñat̃en ñam̃a atarroʼ orrarñat̃en napaʼ añoʼchña eʼñe neyemuetyena ñeñt̃ atarr ochñat̃eneshaʼ ñam̃a ashcarñat̃ec̈hno ñeñt̃ atarr cobraʼyeneʼ acheñeneshaʼ quelle. T̃arraña amaʼt atet̃ sepennoñpaʼ Nomporña eʼñe eñoteneʼ ñeñt̃ poʼñoc̈h atarr sherbets ñocop. Ñam̃a allohueney ñeñt̃ey eʼñe puechemereshaʼ p̃ohueney ñeñt̃ey cot̃eneʼ ña poct̃ap̃ña yapaʼc̈hoʼña eʼñe yeñotuenña ñeñt̃ poʼñoc̈h atarr sherbets. Ñeñt̃oʼmarña yorrtatyeññañ ñeñt̃ cohuen enten ña. Sañapaʼ amaʼt eʼñe mamesha ama acshatpahuoyayso, eʼñe att̃es ñerraʼmrrat̃eʼ cheshaneshaʼ ñeñt̃ c̈hocmach poʼpoñ entannaʼtuenet amach mueno oʼch yemtana all yellsheñen poʼpotantañ pacmachoreshaʼ all plazo all shontena acheñeneshaʼ. Ñetñapaʼ amach mueneñeto oʼch coshaprechet pacmachoreshaʼ. Ñeñt̃oʼmarña ñetpaʼ att̃o yellsheñenetpaʼ atet̃ oteñet poʼpotantañ pacmachoreshaʼ: “Yapaʼ amaʼt oʼ yerequërcaʼhua allo yocshameʼtenapaʼ sañapaʼ amaña sesheʼraram̃penye; allot̃paʼ amaʼt oʼ yepoctorareʼtua ñeñt̃ yaʼchpeñtsorec̈ho allo yellcanrrortenapaʼ sañapaʼ amaña sellcapretenyo.” ");
INSERT INTO ameNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Allempoña Jesúspaʼ oʼ huapoña ñam̃a puesheñarr fariseo oʼch otenanaʼ Jesús rrallmeʼchapreteñepaʼ paʼpacllo. Jesúsñapaʼ allent̃a cot̃erran fariseo. Allempoña c̈hapach paʼpacllo anorrc̈haʼtoset parro allchaʼ rrallmeʼchapretos. ");
INSERT INTO ameNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Puesheñarrña coyaneshaʼ ñeñt̃ alloʼmarneshaʼ ñeñt̃ atarr ecañoreshat̃, ñañapaʼ oʼ eʼmareʼch oʼ c̈hap Jesús fariseo paʼpacllo all rrallmeʼchen. Ñañapaʼ huapa, huapatan ñeñt̃ atarr eñmosat̃ ñeñt̃ nanac tsaʼteʼ; huapatam̃pes puetellm̃o ñeñt̃ otenet alabastro. ");
INSERT INTO ameNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Allñapaʼ pueyaʼchpeñeshaʼ huapa, ponmosana Jesús paʼtco. All atarr yahuosa, pueseʼñapaʼ c̈ha tsopsaʼtos Jesús paʼtco. Allempoña chetosanña pueʼchpaʼ alloña alla aʼporrarraʼtquër, tsoʼtstecaʼtosan paʼtac, sheʼtatcaʼtos eñmosat̃o. ");
INSERT INTO ameNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Añña fariseo ñeñt̃ huaʼñeneʼ Jesús, ñañapaʼ eñchpaʼ atet̃ ot pueyoc̈hro: T̃arraña añ yacma ñerraʼm poʼñoc̈h ñeñt̃ aʼm̃tenayeñ Yompor poʼñoñpaʼ eñotapaneñchaʼña añ coyaneshaʼ ñeñt̃ aʼp̃lleneʼpaʼ atarr ecañoreshat̃, amach muenacheñe oʼch aʼp̃llosñañ amaʼt paʼtca. ");
INSERT INTO ameNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesúsñapaʼ atet̃ otan fariseo: —Napaʼ nemneñ oʼch masheñe Simóna notap̃ allpon ñoñets. Fariseoñapaʼ atet̃ och: —Eʼñe pocteʼ nenteñ Maestrochaʼ oʼch p̃oten. ");
INSERT INTO ameNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesúsñapaʼ alla tomaʼntacha, atet̃ och: —Napaʼ oʼch not, alloʼtsen puesheñarr acheñ ñeñt̃ artetsa quelle. Ñañapaʼ artana puesheñarr acheñ nanac shonteʼ quelle ñeñt̃ otenet quinientos denario; poʼpsheñeññapaʼ archa poʼpoñ quelle ñeñt̃ ama tama atonayaye ñeñt̃ otenet cincuenta denario. ");
INSERT INTO ameNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Att̃oña epsheñoʼmaretpaʼ ama eshcayeʼ tsaʼtuerreto ñeñt̃ allpon teb̃aʼyenet t̃arroʼmar ama echeneto alloch tsaʼterret. Ñañapaʼ eʼñe att̃a peretnaʼhuerranet epsheñoʼmaret, eʼñe att̃ecma ama eseshayeʼ tsaʼterrtso. T̃eʼña masheñe Simóna oʼch naʼp̃t̃oʼtap̃, añ epsheñoʼmar ñeñt̃ amorrentaret̃ att̃och peretnerranet allpon tebenet ¿erraʼtsenaʼt pentenña p̃a ñeñt̃ atarr morrentenaya ñeñt̃ peretneneʼ, ñatoʼ añt̃eʼ acheñer ñeñt̃ tebeneʼ quinientos denario amapaʼ añt̃eʼ ñeñt̃ eʼñe cincuenta denario tebeneʼ? ");
INSERT INTO ameNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simónñapaʼ alla anapuerranerr Jesús, atet̃ otererr: —Ñehua, añt̃eʼcaʼye atarr morrentenaya ñeñt̃ ap shonteʼ quelle, t̃arroʼmar ñapaʼ shonteʼ oʼ att̃a ap̃retnaret̃terra ñeñt̃ allpon shonteʼ teben. Jesúsñapaʼ alla otererr: —Atet̃caʼye masheñe. ");
INSERT INTO ameNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Allempoña Jesúspaʼ cohuaʼ allent̃eʼtsen coyaneshaʼ allot̃ñapaʼ alla oterranerr Simón: —Pecueʼ añ coyaneshaʼ ñeñt̃ atet̃ p̃osen. Allempo nec̈hap pepacllopaʼ p̃añapaʼ ama es p̃apapno amaʼt oñapaʼ ama p̃apapno alloch neʼpatcaʼtosa. T̃arraña añña coyaneshaʼpaʼ ñaña neʼpatcaʼtoseʼ eʼñe ña puesoʼyo allempoñapaʼ alla aʼporrarraʼtquërren eʼñe ña pueʼcho. ");
INSERT INTO ameNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ñam̃a allempo nec̈hap pepacllopaʼ p̃añapaʼ amaʼt pehuom̃chaʼteñot̃apaʼ ama petsoʼtstsaʼpaʼtapno. T̃arraña añ coyaneshaʼ eʼñe allempo nec̈hap pepacllo ama att̃a cac̈hposno allorocma tsoʼtstecaʼtosen att̃oña orrtatosan puemorrenteña nocop. ");
INSERT INTO ameNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","P̃apaʼ amaʼt coñeʼt̃apaʼ ama es peshapono noño amaʼt olivosoʼya ñeñt̃ ama tsaʼteyaye. T̃arraña ñañapaʼ eñmosat̃o sheʼtatcaʼtosen ñeñt̃ atarr tsaʼteʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Att̃oña t̃eʼpaʼ atarr orrtatosnan ñeñt̃ att̃o morrentosna. Napaʼ neñoteññañ amaʼt shonteʼ poʼchñar t̃eʼñapaʼ oʼ eʼñe ap̃retnaʼhuaret̃ta. T̃arraña poʼpsheñeñ amaʼt ama tama ochñat̃eyaye att̃oña ap̃retnaʼhuaret̃ta poʼchñarpaʼ ñañapaʼ ama eʼñeyeʼ morrentapanoña ñeñt̃ oʼ peretnerrñañ poʼchñar. ");
INSERT INTO ameNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Allempoña Jesúspaʼ otan coyaneshaʼ: —T̃eʼña poʼñoc̈hpaʼ oʼ eʼñe ap̃retnaʼhuaret̃terra p̃oʼchñar. ");
INSERT INTO ameNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Allempoñapaʼ ñeñt̃ parro rrallmeʼchenet, ñetñapaʼ otannaʼtyeset: —Eseshaʼhuañacaʼyeña añ yacmar att̃o peretnerranña ochñarets. ");
INSERT INTO ameNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesúsñapaʼ alla oterranerr coyaneshaʼ: —P̃apaʼ att̃o atarr peyemtenna ñeñt̃ña oʼ aʼqueshp̃aterrep̃. T̃eʼñapaʼ oʼch ahuerrep̃ eʼñe peñmañeshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Allempoñapaʼ chopeñeʼcherrerr Jesús errap̃aren serrpareʼtyesnomueʼ cohuen ñoñets att̃och c̈hap allempo ayochreshat̃tena Yompor. Erracmañen chopeñeʼchyen, ora allemeñ anetsoʼmar all shontaʼyena acheñeneshaʼ ñam̃a all ama tama shonteyaye acheñ. Allñapaʼ cot̃aʼhuanererr pueyochreshaʼ c̈harrasheña ñeñt̃ puechetsa epsheña. ");
INSERT INTO ameNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Allñapaʼ cot̃aʼhuanem̃ ñam̃a patantarr coyaneshac̈hno ñeñt̃ aʼcrratyesua Jesús ahuañmoʼcha, puesheñaʼtetspaʼ ñeñt̃ cac̈hpatatyerr oneñet̃ ñeñt̃ chorrahueteʼt̃, poʼpsheññec̈hnopaʼ ñeñt̃ aʼcrratyes ñeñt̃ paʼnamen atsnañtsor mueroc̈htatyesahueteʼt̃. Puesheñarr coyaneshaʼ ñeñt̃paʼ añ paʼsoʼcheñ María Magdalena. Ñeñt̃ Maríarpaʼ Jesúsñapaʼ puecac̈hpatataroñ canc̈herr oneñet̃. ");
INSERT INTO ameNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ñehua, poʼpsheñeñ coyaneshaʼ añ paʼsoʼcheñ Juana. Puerrollarñapaʼ añ paʼsoʼcheñ Chuza añ poʼtaruas pen att̃o sherbenan am̃chaʼtaret̃ Herodes. Allot̃ña poʼpsheñeñ coyaneshaʼ ñeñt̃ cot̃aʼneneʼ Jesús ñeñt̃paʼ añ paʼsoʼcheñ Susana. Ellopaʼ shonteʼ poʼpotantañ coyaneshac̈hno ñeñt̃ es apaʼyesayeʼt̃ Jesús ñeñt̃ allpon echyenet ñet. ");
INSERT INTO ameNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Allem̃at̃eñ anetsot̃ huac̈haʼtyena acheñeneshaʼ ñeñt̃ c̈hac̈hets Jesúsesho. Allempoñapaʼ oʼ c̈ha shontoset nanac, Jesúsñapaʼ serrpareʼtatapanet, atet̃ tomaʼntatapanet: ");
INSERT INTO ameNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Ñeñt̃ña aʼparreneʼ puerets ñañapaʼ ahuoʼ allchaʼ aʼparreʼtyenanaʼ puepuer. All aʼparreʼtyeñ patantaʼtetsñapaʼ alla c̈hapyes t̃oñoʼmar, ñeñt̃ñapaʼ att̃a at̃mamaʼtyes acheñeneshaʼ. Allñapaʼ huac̈haʼtyesa ñam̃a ot̃ eʼñe añyallmeʼchuenanaʼ puerets. ");
INSERT INTO ameNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Poʼpoñec̈hnoñapaʼ alla c̈hapyes mapuetroʼmesoʼmar. Ñeñt̃ñapaʼ mameshapaʼ cheparesuañ, t̃arraña mameshapaʼ alla hueyaʼhuerra t̃arroʼmar all mapuetroʼmesopaʼ ama eñalle amaʼt coñeʼt̃a oñ ñeñt̃chaʼ aʼyamosam̃p̃seʼ narmets ñeñt̃ oʼ cheparesua all. ");
INSERT INTO ameNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Poʼpotantañña pueretspaʼ alla c̈hapyes allchaʼ chepares aj. Allpaʼc̈hoʼ mameshapaʼ cheparesuañpaʼ ajñapaʼ mameshapaʼ ateshaʼtua alla caʼmatuerranña narmets alla aʼcllatuer. ");
INSERT INTO ameNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Poʼpotantañec̈hno ñeñt̃ñapaʼ arr c̈hapyes all eʼñe cohuen patso. Ñeñt̃ñapaʼ eʼñe cohuen chepares. Allempoña ateshaʼtuapaʼ atarr aton ellom̃reʼtyes. Puechaʼtetspaʼ c̈harroch c̈harraʼ pueʼllomer. Allempoña serrpareʼtatuanet atet̃paʼ oʼ alla oterraneterr. Eʼñe huomencocma eñoranaʼtanet, atet̃ otanet: —Ñeñt̃es poʼñoc̈h neʼm̃ñoteneʼ, c̈haponasepaʼch seyoc̈hro ñeñt̃ atet̃ netmaʼntatensa añ ñoñets. ");
INSERT INTO ameNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Allempoña pueyochreshaʼpaʼ ochet Jesús: —Taʼm ¿est̃eʼña petmaʼntatenya? Yañapaʼ ama yeñoteñe. ");
INSERT INTO ameNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesúsñapaʼ alla oterraneterr: —Sa t̃eʼpaʼ Yomporña oʼ muenaterres att̃och señoterr ñeñt̃ ama eñotpahuoyaye amaʼt ahuat̃ot̃eñ atet̃ penaña Yompor poʼcohuenña att̃o atarr ayochreshat̃tena ña. T̃arraña poʼpotantañec̈hnoña ñeñt̃ att̃a es puec̈haʼyetsa, ñocpuetpaʼ ama eñoteñeto ñeñt̃ atet̃ atmaʼntataret̃ ñoñets. Att̃oña amaʼt enteñetañ ñetñapaʼ amach es c̈henahueto pueyoc̈hreto. Amaʼt eʼmueñetañ amaña c̈henanetoña pueyoc̈hreto ñeñt̃ atet̃ yec̈hateney Yompor poʼcohuenña. ");
INSERT INTO ameNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Ñehua, ñeñt̃ atet̃ netmaʼntatasa ñorraʼpaʼ ñeñt̃paʼ atet̃ notenes: Ñeñt̃ aʼparreʼtyeneʼ puerets, ñeñt̃ pueretspaʼ añ notenes Yompor poʼñoñ allempo serrpareʼteñet. ");
INSERT INTO ameNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Añ puerets ñeñt̃ c̈hapyesets t̃oñoʼmar ñeñt̃paʼ añ notenes acheñeneshaʼ ñeñt̃ eʼm̃ñotenayeñ Yompor poʼñoñ. Allempo eʼm̃ñotuetpaʼ allorocmach huapa oneñet̃ oʼch alla puerratam̃perranet Yompor poʼñoñ pueyoc̈hretot̃. Att̃oña amach mueneñeto oʼch ameʼñenet, att̃ochña ñetpaʼ amach aʼqueshp̃ataret̃terreto. ");
INSERT INTO ameNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ñam̃a ñeñt̃ c̈hapyesets mapuetroʼmesoʼmarpaʼ ñeñt̃paʼ añ notenes acheñeneshaʼ ñerraʼm esempo eʼm̃ñoteññañet Yompor poʼñoñ eʼñech pocsheñeshaʼ aguërrñañetañ Yompor poʼñoñ. Eʼñech cohuen ameʼñeretañ t̃arraña ñetpaʼ mamecpach atet̃ pet. T̃arroʼmar ñetpaʼ atet̃ penet ñerraʼmrrat̃eʼ narmets ñeñt̃ chepuets mapyo amach eñalle puerec̈h. Tsapat̃onet̃ña ñerraʼm oʼch huapanet topateñets, ñetñapaʼ oʼch alla cac̈hpuerrñañet Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ñam̃a puerets ñeñt̃ c̈hapyesets ajmoʼmar, ñeñt̃paʼ añ netmaʼntatena poʼpotantañ acheñeneshaʼ ñeñt̃ eʼm̃ñotenayeñ Yompor poʼñoñ. Amaʼtchaʼ c̈hapanetañ mameʼ pueyoc̈hreto, t̃arraña ñetpaʼ alloʼnach senet aña atarr cot̃apeʼchenet ñeñt̃ llecaʼyenet arr patsro ñeñt̃ eʼñe ñocpueta. Añach muenenet oʼch esocmañen es echyenet att̃och allo eʼñe coshaʼyenet. Att̃oña ñetpaʼ amach errot̃enot̃ orrtatoñeto ñeñt̃ atarr sherbets Yomporecop. Ñetpaʼ eʼñe att̃eta ñerraʼm narmets ñeñt̃ c̈ha caʼmatuerr ajmaʼ amach errot̃enot̃ ellom̃reʼtyeseto. ");
INSERT INTO ameNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ñam̃a añ puerets ñeñt̃ c̈hapyesets eʼñe cohuen patso ñeñt̃ eʼñe cohuen cheparsatspaʼ ñeñt̃ña tomaʼntenaya poʼpotantañ acheñeneshaʼ ñeñt̃ eʼm̃ñoteneʼ Yompor poʼñoñ. Ñetñapaʼ att̃o ameʼñeññañet Yompor poʼñoñ amach puesereto c̈hoch eñochet pueyoc̈hreto att̃och eʼñe cohuen maʼyoc̈hroñet Yompor poʼñoñ. C̈hocmach orrtatyenet ñeñt̃ atarr sherbets Yomporecop amachña c̈ha cac̈hpueñeto. Att̃oña ñetpaʼ eʼñe atet̃ penet ñerraʼm narmets ñeñt̃ atarr aton ellom̃reʼtyets. ");
INSERT INTO ameNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesúspaʼ alla tomaʼntaterraneterr poʼpoñonet̃; ñeñt̃paʼ atet̃ otanet: —Ñerraʼm esempo yaʼllchaten lampareñ ñeñt̃paʼ ama añecpayeʼ yaʼhuortateñe oʼch alla yeʼrramam̃per coym̃o. Ñam̃a ama añecpayaye oʼch alla yener oʼponot̃ yemayep̃nac̈ho. Añecopña yaʼhuortatenña lampareñ oʼch yeneʼ enonet̃ att̃och c̈hoyoʼtam̃pesuan allohuen acheñ ñeñt̃ beʼt̃osc̈hets oʼpono pocollo. ");
INSERT INTO ameNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","T̃arroʼmar allohuen ñeñt̃ ama eñotpahuoyaye amaʼt ahuat̃ot̃eñ, t̃eʼñapaʼ oʼch eʼñe orrtataret̃terra att̃och eʼñech eñotataret̃etuerret eʼñe poctacma. ");
INSERT INTO ameNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Ñeñt̃oʼmarña sapaʼ señotenat̃eʼ eʼñet̃eʼ poʼñoc̈h cohuen seʼm̃ñoteññañ Yompor poʼñoñ ñatoʼpaʼ amat̃eʼ. Eseshaʼt̃eʼ c̈hena pueyoc̈hro amaʼt eʼñe allpona Yompor poʼñoñ, elloña Yomporpaʼ alloʼnach eñotatnenanet nanac shonteʼ. T̃arraña eseshaʼña ñerraʼm ama c̈henaneto pueyoc̈hro t̃arroʼmar ñetpaʼ ama poʼñoc̈hayeʼ aguëññañeto Yompor poʼñoñ amaʼt allpon eñotenetañ pueyoc̈hro ñeñt̃ñapaʼ c̈hach puerratam̃perranet Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Allempoñapaʼ huapa Jesús pachor epuet ñam̃a paʼmoʼnasheñneshaʼ. C̈hapuet allpaʼ shonteʼ acheñeneshaʼ ñeñt̃ emchorrenaya Jesús. Ñeñt̃oʼmarña ñetpaʼ ama eshcayeʼ entosetoña Jesús allameʼtets. ");
INSERT INTO ameNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Allempoña acheñeneshaʼ ochet Jesús: —Oʼcaʼye huapaña p̃achor ñam̃a pemoʼnasheñneshaʼ. Ñetpaʼ aʼyot̃eʼtsaʼyenet, mueneñet oʼch entenpetaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ñañapaʼ atet̃ otanet: —Allohuen ñeñt̃ eʼm̃ñoteneʼ Nompor poʼñoñ ñetña ñerraʼm atet̃ p̃ohuenet ñeñt̃ atet̃ oteney, ñeñt̃ña eʼñe poʼñoc̈h nachor nepen ñam̃a ñeñt̃ña eʼñe nemoʼnasheñ nepen. ");
INSERT INTO ameNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Allempo c̈herrerr pamt̃arr Jesúsñapaʼ aʼtapos noñt̃o epuet ñam̃a pueyochreshaʼ. Ñañapaʼ atet̃ otanet: —T̃eʼpaʼ oʼch ahuam̃p̃sey yom̃taʼn. Allempoñapaʼ ahuam̃p̃set noñt̃o. ");
INSERT INTO ameNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Allempo ahuam̃p̃set Jesúsñapaʼ alla maʼ noñt̃o. All muenpaʼ machayot̃a huomenquëshatam̃pesnomuet. Emoʼyareʼñapaʼ c̈ha eshaʼtena noñt̃o, att̃eñapaʼ chorramoch oñ noñt̃o c̈ha mueneʼ eshaʼtatan noñt̃. ");
INSERT INTO ameNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Att̃eña pueyochreshaʼñapaʼ ponem̃yet Jesús all muenpaʼ opueret, atet̃ ochet: —Maestro, poʼñoc̈huachcaʼye yocllaʼhuerrat̃eʼ. Jesúsña tanterrapaʼ eʼñe poʼñoñot̃a aʼmtsoññetuerran huomenquëshaʼ amaʼt ñam̃a emoʼyareʼpaʼ oʼ eʼñe aʼmtsoññetuer. Att̃oña ñetpaʼ oʼ alla eʼñe cohuen muechet̃tam̃perret. ");
INSERT INTO ameNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Allempoña Jesúspaʼ otanet: —Esoʼmareʼtña sapaʼ ama eʼñeyeʼ seyemtenno. Ñetñapaʼ c̈ha atarr nanac yorenet. Att̃a cohuanrrorteñet ñetñapaʼ atet̃ otannaʼtyeset: —Taʼmcaʼye añ acheñerpaʼ esonaʼtart̃eʼcaʼye. Atarrepaʼt es aʼmchechaten, amaʼt poʼñoñot̃apaʼ aʼmchechaterran huomenquëshaʼ amaʼt ñam̃a emoʼyareʼ oñ. ");
INSERT INTO ameNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Allempoñapaʼ oʼ etsotoset yom̃taʼn all senet. Allpaʼ añ paʼney peneʼ gadaroʼmarneshaʼ alla yot̃ Galileot̃. ");
INSERT INTO ameNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Allña sohuosa Jesús noñt̃ot̃paʼ allñapaʼ huapoña puesheñarr yacma ñeñt̃ alloʼmarneshaʼ, t̃arraña ñapaʼ añ chorrenaya oneñet̃ patoner. Ñeñt̃ñapaʼ ahuat̃ot̃eñ att̃a chopeñeʼchyen muelleʼmcot̃, ama shetamteno. Ñapaʼ alla yec̈hena all pampueñet arromñat̃ec̈hno ama pocolloyeʼ yec̈heno. Ñehua, oneñet̃paʼ allempo rromuenan yacmapaʼ epayeʼ ottatseʼtacheʼt̃ allempot̃eñ. Pamoʼtseshaʼñapaʼ ahuoʼch rromuetpaʼ oʼch huanquëtañ att̃och cohuam̃peñet. Ñañapaʼ c̈hach tsepeʼtuanman allo huanquëññañet pot ñam̃a paʼtac oneñet̃ñapaʼ ahuoʼchc̈hoʼ matach aʼyo amayo. Allempoña entapan Jesúspaʼ rranaʼnma huomenc, mata Jesúsesho, rromosñaña allameʼtets. Allempoña Jesúspaʼ otosan oneñet̃ ñeñt̃ chorrenaya yacma: —T̃eʼpaʼ oʼch pecac̈hpaʼner añ acheñer. Ñeñt̃ña chorrena oneñet̃paʼ ñañapaʼ atet̃ otapan Jesús: —Esoʼmaruachcaʼye Jesúso p̃aʼtsrreʼmoc̈htanaʼtosen, p̃apaʼ ñeñt̃ep̃ Ñeñt̃ Nanac Parets Puechemerep̃. T̃eʼpaʼ notapap̃chaʼ amach pecoñchatatstosno. ");
INSERT INTO ameNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesúsñapaʼ alla oterranerr ñeñt̃ chorrena oneñet̃: —P̃apaʼ ¿esoʼtña pesochena? Ñañapaʼ atet̃ oterranerr Jesús: —Napaʼ añ nesoʼcheñ Legión. Ñehua, añ soʼchñets ñeñt̃ otenet shonteʼ nanac, t̃arroʼmar ñeñt̃ nanac patoner oneñet̃ ñeñt̃ chorrenaya. ");
INSERT INTO ameNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ñehua, oneñet̃ec̈hnoñapaʼ atet̃ otareʼtapet Jesús: —Amach arra pemñatstosye oʼpono coñchaʼpuetso. ");
INSERT INTO ameNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ñehua, allpaʼ aʼyent̃eʼtsaʼyen shonteʼ chañchoc̈hno ñeñt̃ rratseʼtyets aspent̃onet̃. Ñeñt̃oʼmarña oneñet̃ec̈hnopaʼ atet̃ otareʼtapet Jesús: —Ñerraʼm c̈hoch mueneʼ errot̃en pep̃oseypaʼ arrña pemñayeʼchosey chañchesho allochñapaʼ oʼch yechorraʼyererr ñam̃a chañchoc̈hno. Jesúsñapaʼ allent̃a otanet: —Amaʼtcaʼye orrascaʼye. ");
INSERT INTO ameNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Allempoña oneñet̃ec̈hnopaʼ cac̈hpaʼhuaneret yacmapaʼ, alla chorrereterr ñam̃a chañchoc̈hno. Chañchoñapaʼ allempo chorrosya oneñet̃ec̈hnopaʼ c̈hepaʼtchaʼ matrraʼtua allohuen ñegonet̃ shorc̈haʼtuos allot̃paʼ eʼñe ñoʼshrraʼtuosa oño. ");
INSERT INTO ameNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Acheñeneshaʼña ñeñt̃ cohuam̃peneʼ chañcho allempo eñchet atet̃ p̃a chañcho oʼ shorc̈haʼtua oño, ñetñapaʼ allent̃a matrraʼtet ñamet pueyorñot̃ ahuanmuet anetso. Allñapaʼ serrpareʼtyesoset ñam̃a ora allohuen allampañoʼmar. ");
INSERT INTO ameNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Acheñeneshaʼñapaʼ allent̃a ahuanmuet ahuoʼch enteñetaʼ. Oʼ c̈hac̈haʼtet Jesúseshopaʼ allñapaʼ entoset yacma ñeñt̃ chorreʼt̃ oneñet̃. Alla anen allameʼtets Jesús paʼtcot̃ ashtamat̃. Oʼ eñoterra oʼ cohuenterra. Ñetñapaʼ c̈ha atarr mechaʼnaʼtoset. ");
INSERT INTO ameNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Añña ñeñt̃ enteneʼ Jesús att̃o cac̈hpatatenan oneñet̃ acheñ, ñetñapaʼ allent̃a serrpareʼtatapet ñeñt̃ huac̈haʼttsa anetsot̃. ");
INSERT INTO ameNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Allempoña allohuen acheñeneshaʼ ñeñt̃ yec̈haʼyetsa all ñeñt̃ gadaroʼmarneshaʼ ñetñapaʼ pueyorñot̃et atet̃ otoset Jesús: —T̃eʼpaʼ oʼch ahuerrep̃ arrot̃. Allempoña Jesúspaʼ aʼterr noñt̃o oʼch ahuerr. ");
INSERT INTO ameNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Yacmaña ñeñt̃ chorreʼt̃ oneñet̃ ñañapaʼ allent̃a otan Jesús: —Napaʼ nemneñcaʼye t̃eʼpaʼ oʼch noct̃errep̃. T̃arraña Jesúsñapaʼ ama muenache, atet̃ och: ");
INSERT INTO ameNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Allap̃ach, t̃eʼpaʼ oʼch ahuerrep̃ pepacllo p̃amoʼtseshoʼmar oʼch peserrpareʼtatuerranet ora allohuen att̃o Yompor atarr yenposep̃. Ñañapaʼ atet̃ otue Jesúspaʼ atet̃c̈hoʼ p̃a. Allent̃a ahuerr serrpareʼtyesnerrets ora anetsoʼmar att̃o Jesúspaʼ atarr nanac yenpos. ");
INSERT INTO ameNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Allempoña alla c̈herr Jesús añem̃taʼn allot̃ ta ahuaña. Acheñeneshaʼña allpaʼ eʼñe pocsheñeshaʼ agapapueñet t̃arroʼmar oʼ atarr cohueret oʼch huerra. ");
INSERT INTO ameNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Allempoña allpaʼ huapoña puesheñarr am̃chaʼtaret̃ añ paʼsoʼcheñ Jairo. Ñapaʼ ñeñt̃ puesheñarr ñeñt̃ am̃chaʼtaret̃tetsa judioneshaʼ poʼprahuo. Ñañapaʼ alla rromosa Jesús paʼtcot̃paʼ atet̃ otosan Jesús: —Napaʼ nemneñ oʼch p̃oct̃erren nepacllo, ");
INSERT INTO ameNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","t̃arroʼmar neseñ ñeñt̃ nepat̃rrorpaʼ c̈ha atsnaʼten oʼ aʼpoʼntsaʼmocha. Ñehua, ñeñt̃ poʼseñpaʼ allpont̃eʼ echenan poʼcharña c̈harraʼ puechena epa char. ");
INSERT INTO ameNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Allempo cot̃aʼner Jesús cot̃aʼhuaner ñam̃a shonteʼ acheñeneshaʼ c̈ha emchorratseʼtnomet, c̈ha toʼmamaʼtneñet. Allñapaʼ cot̃aʼnmanet ñam̃a puesheñarr coyaneshaʼ ñeñt̃ atsnaʼtets. C̈harraʼ puechena epa char ñeñt̃ att̃o c̈hocma yellaʼyena. Amaʼt epayeʼ partata oʼ aʼgastaʼhuahuan poʼc̃llayor att̃o parteñet amaña eseshayeʼ aʼcrraterraye. ");
INSERT INTO ameNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ñañapaʼ all cot̃aʼnenan Jesús paʼcheʼñot̃, allñapaʼ aʼp̃llerrñañaʼ paʼshtam paʼrrpeʼmot̃. Eʼñe aʼp̃llaʼhueʼ paʼshtampaʼ allorocma maserrña poʼrras, oʼ metuer ñeñt̃ att̃o mueroc̈htena. ");
INSERT INTO ameNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesúsñapaʼ atet̃ otanet: —¿Eseshaʼtña oʼ aʼp̃llaʼnmuenña neshtamot̃? Ama eseshayeʼ eñoratso. Pedroña ñam̃a ñeñt̃ epuet yemtena, ñetñapaʼ atet̃ ochet Jesús: —Maestrochaʼ p̃apaʼ penteñt̃eʼ shonteʼ acheñeneshaʼ ñeñt̃ allot̃emeña petoʼmamaʼtneneʼ. ¿Esoʼmareʼtña p̃otenña eseshaʼt̃eʼ p̃aʼp̃lleneʼ peshtamot̃? ");
INSERT INTO ameNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","T̃arraña Jesúspaʼ atet̃ oterraneterr: —Napaʼ neñoteñ poʼñoc̈h puesheñarr acheñ eʼñe puemnenñot̃ aʼp̃llenen neshtamot̃ t̃arroʼmar napaʼ neñotena napaʼ oʼ naʼcrrach eʼñe na nehuamencot̃ att̃o aʼp̃llenen. ");
INSERT INTO ameNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Coyaneshaʼña allempo ñapaʼ eñotena amach errot̃enot̃ aʼnasoto. Ñapaʼ c̈ha paʼshmuena pueyorñot̃ concorposa Jesús paʼrrp̃ot̃. Allñapaʼ eʼñe aʼmet̃aʼhuosan ñapaʼ añecopña aʼp̃llenan Jesús paʼshtam att̃och correrra eʼñe cohuen. Allñapaʼ atet̃ otan allohuen acheñeneshaʼ: —Na allempo naʼp̃lloñ Ayochreshat̃ paʼshtampaʼ ñeñt̃ña naʼcrraterreʼ allorocma. ");
INSERT INTO ameNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesúsñapaʼ atet̃ otan coyaneshaʼ: —P̃apaʼ nesñeshachaʼ att̃o atarr peyemtenna na att̃oña t̃eʼpaʼ oʼ eʼñe naʼcrratnomuep̃. T̃eʼñapaʼ oʼch ahuerrep̃ eʼñe peñmañeshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Allempo eñorena atet̃paʼ allñapaʼ huac̈haʼta ñeñt̃ huetsa am̃chaʼtaret̃ Jairo paʼpacllot̃. Ñetña huapuetpaʼ atet̃ otoset Jairo: —Peseñpaʼ oʼcaʼye rroma. T̃eʼñapaʼ amach alloʼna p̃aʼtsrreʼmoc̈htanaʼtatsche Maestro oʼch cot̃errep̃ pepacllo. ");
INSERT INTO ameNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesúsña amaʼt eʼman atet̃ otoset Jairopaʼ ñañapaʼ atet̃ otan Jairo: —P̃apaʼ amach c̈ha peʼcharrtatatsto peyoc̈her, nachña eʼñe peyemta att̃och correrraña peseñ. ");
INSERT INTO ameNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Allempoñapaʼ ahuanmuet Jairopahuo. C̈hapuet pocollo allñapaʼ alloʼtsaʼyen shonteʼ acheñeneshaʼ all yahuanrrortenet, yaʼnaʼteñet arromñat̃. Jesúsñapaʼ otosanet: —Amach atarr seyahuatsto. Añ shopsheshaʼpaʼ amacaʼye c̈hoyeʼ rromueno c̈hacaʼye muen. Ñetña pachm̃areʼteñot̃etpaʼ att̃a cheʼtatsetyesapet t̃arroʼmar ñetpaʼ eʼñecaʼye eñoteñet c̈hocaʼye rromuen. Allempoña Jesúsñapaʼ ama muenatano allohuen acheñeneshaʼ oʼch beʼt̃oset alloʼtsen arromñat̃. Ñapaʼ aña muenat Pedro ñam̃a Juan, ñam̃a Jacobo ñam̃a arromñat̃ puepapar ñam̃a pachor ñeñt̃aña epuet beʼt̃osc̈haʼtoset alloʼtsen arromñat̃. ");
INSERT INTO ameNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Allempoña Jesúspaʼ rremotaʼtosan shopsheshañ potot̃paʼ poʼhuamencocma otos: —Oʼch nesñe notosep̃, t̃eʼpaʼ c̈hop̃a tanterrtsa. ");
INSERT INTO ameNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Eʼñe otueʼ atet̃paʼ allent̃epaʼtchaʼ oʼrrerrerra c̈ha tanterrtsa. Jesúsñapaʼ otanet: —T̃eʼpaʼ oʼch serratallmeʼcher. ");
INSERT INTO ameNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Puepaparña ñam̃a pachorpaʼ ñetñapaʼ att̃a cohuanrrorteñet. Jesúsñapaʼ atet̃ otanet: —Amach eseshaʼ sotap̃saʼtatsto amaʼt puesheñarra ñeñt̃ atet̃ oʼ norrtatennasaʼ sepacllo. ");
INSERT INTO ameNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Allempo c̈hapaʼmuen allempo Jesús agotaʼmuenan pueyochreshaʼ c̈harrasheña ñeñt̃ puechetsa epsheña. Eʼñe apc̈haʼhuet ñeshopaʼ ñañapaʼ atarr ahuamencat̃ p̃aʼyesanet, att̃oña apanet ñam̃a llesens att̃och cac̈hpatatyeret oneñet̃ acheñeneshaʼ amaʼt erraʼtsena ñeñt̃ atarr mueroc̈htatyenahuet. Ñam̃a ahuamencat̃ p̃anet att̃och aʼcrratyeset acheñeneshaʼ amaʼt erraʼtsena ñeñt̃ osyenahuet. ");
INSERT INTO ameNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Att̃oña llesensanet att̃och ahuanemyeset paʼnamen anetsoʼmar serrpareʼtyesnomuet Yompor poʼcohuenña att̃o atarr ayochreshat̃tena ña. Ñam̃a añecpaʼnaña llesensenanet att̃och aʼcrratyesoset acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ñam̃a atet̃ otapanet: —Amach es sanmatsto amaʼt coñeʼt̃a allchaʼ sechopeñeʼchyes—amaʼt secarra, amaʼt sebolsa, amaʼt ñeñt̃chaʼ serraʼyesnom amaʼt sec̃llayora amaʼt eʼñe epma seshtampaʼ amach sanmatsche sechopeʼchpayo. ");
INSERT INTO ameNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Alla oterraneterr: —Amaʼt errach pocollro sec̈hap allach sommosa allponmat esempohuach ahuerrserr poʼpoñ anetso. ");
INSERT INTO ameNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ñerraʼm erra anetsro ñeñt̃ alloʼmarneshaʼña ama cohuenayeʼ agapasetopaʼ oʼch sem̃terrerr ñam̃a allot̃. Ñerraʼm allempo sem̃terrerrña ñam̃a allot̃ ñeñt̃ña setcoʼtsaʼyen pañeʼteʼ patspaʼ c̈hoch sepaʼshetcaʼtyesnomña setac. Att̃ochña alloʼmarneshaʼpaʼ oʼch señotatnomanet ñetpaʼ amacaʼye pocteyeʼ entenanetoña Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Eʼñe ñeñt̃a otaret̃etuetpaʼ ñetñapaʼ allent̃a ahuanmuet oʼch chopeñeʼchyeset erracmañen anetsoʼmar. Allñapaʼ añ serrpareʼtyesnomuet cohuen ñoñets alloch yequeshperra. Ñam̃a all chopeñeʼchyeset erracmañenpaʼ allña aʼcrratyesnomet ñeñt̃ atsnaʼtyets. ");
INSERT INTO ameNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Am̃chaʼtaret̃ña Herodespaʼ ñañapaʼ atet̃ eʼmareʼtenan Jesús ora ñeñt̃ allpon atet̃ p̃aʼyena. Ñañapaʼ c̈ha atarr llequëna t̃arroʼmar patantaʼtets acheñeneshaʼpaʼ atet̃ otyenet t̃eʼpaʼ oʼ orrterra Juanañ, oʼ tanterra rromot̃. (Herodespaʼ añña atarr llecateneʼ t̃arroʼmar ñapaʼ ña pechateʼ Juan ahuaña.) Ñeñt̃oʼmarña ñapaʼ ñeñt̃a nen pueyoc̈hro att̃o acheñeneshaʼ otenet ahuoʼ tanterra Juan rromot̃. ");
INSERT INTO ameNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Poʼpotantaññapaʼ atet̃ otyenet: —Elíasoñcaʼye oʼ orrterra. Poʼpotantaññapaʼ ñetpaʼc̈hoʼña atet̃ otyenet: —Añpaʼ ñeñt̃caʼye aʼm̃tayeʼt̃ Yompor poʼñoñ ahuat̃, t̃eʼñapaʼ oʼ tanterra rromot̃. ");
INSERT INTO ameNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Am̃chaʼtaret̃ña Herodespaʼ atet̃ ot: —Napaʼ neñotena nacaʼye pechateʼña Juan ahuaña. Eseshaʼhuañacaʼyeña ñeñt̃ orrtateneʼ ñeñt̃ amaʼt ahuat̃apaʼ ama yentare ñeñt̃ atet̃ atarr neʼmareʼten. Ñeñt̃oʼmarña ñapaʼ atarr mueneñ oʼch entan ñeñt̃ Jesúsotets ñeñt̃ orrtatyeneʼ ñeñt̃ ama puentare acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Allempo huac̈herra Jesús pueyochreshaʼ ñeñt̃ llesensaʼyes ahuaña. Ñetñapaʼ oʼ c̈hac̈herret Jesúsesho, serrpareʼtatyesueret Jesús allohuen allpon atet̃ p̃aʼyeset allemeñ anetsoʼmar. Allempoña Jesúspaʼ ahuanman pueyochreshaʼ eʼñe ñapt̃ochayet, c̈hapuet all ama acheñempañoyaye all allameʼtets anetso, ñeñt̃ anetspaʼ añ paʼsoʼcheñ Betsaida. ");
INSERT INTO ameNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","T̃arraña acheñeneshaʼñapaʼ allempo eʼmareʼchet oʼ ahuanmuet all, ñetpaʼc̈hoʼña allent̃a ahuanmuet ñamet. C̈hac̈haʼtet Jesúsesho ñañapaʼ eʼñe cohuen agapanet. Allñapaʼ serrpareʼtatyesapuerraneterr atet̃ penaña Yompor poʼcohuenña att̃o atarr ayochreshat̃tena ña. Ñam̃a allpaʼ aʼcrratyesapuerranerr ñeñt̃ atsnaʼtyets. ");
INSERT INTO ameNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Att̃eñapaʼ oʼ ellerren. Añña pueyochreshaʼ c̈harrasheña ñeñt̃ puechetsa epsheña ñetñapaʼ oteñetaʼ Jesús: —T̃eʼpaʼ oʼch pemueñhuer acheñeneshaʼ ahuanemyerretepaʼ anetsoʼmar allampaño allchaʼ mayesuerret allchaʼ entyesuerret puerrar ñeñt̃chaʼ rraʼyesuerret. T̃arroʼmar t̃eʼpaʼ arroʼtseney all ama acheñempañoyaye. ");
INSERT INTO ameNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","T̃arraña Jesúsñapaʼ otan pueyochreshaʼ: —Sachcaʼye apaʼyesahuet ñeñt̃chaʼ rret. Ñetñapaʼ atet̃ ochet: —Ya arrpaʼ amacaʼye es yecheno amaʼt coñeʼt̃a. Yapaʼ eʼñe amnara pan yechen ñam̃a epat̃oll cac. Ñatoʼ yapaʼ oʼch ahuey anetso allchaʼ yerañt̃enaʼ rreñets ñeñt̃chaʼ yerrach allohuen shonteʼ acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ñehua, alloʼtsen shonteʼ acheñeneshaʼ amnarocht̃eʼ mil yacmaneshaʼ. Allempoña Jesúspaʼ atet̃ otan pueyochreshaʼ: —T̃eʼpaʼ oʼch soch acheñeneshaʼ anorrc̈haʼtyesetepaʼ eʼñe ñopaʼttsocmuet, eʼñech amnarocheʼttsocma c̈harrapaʼtets anorrc̈haʼtyeset. ");
INSERT INTO ameNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pueyochreshaʼñapaʼ atet̃c̈hoʼ pet, anorrc̈haʼtatyeset acheñeneshaʼ allohuenet. ");
INSERT INTO ameNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Allempoña Jesúspaʼ agapan ñeñt̃ amnar pan ñam̃a epat̃oll cac, cohuaʼ enonet̃ parasyosoʼtam̃p̃san pan. Allempoñapaʼ shotaʼtan pan, shetseʼtan ñam̃a cac. Apanatyesan pueyochreshaʼ, ñetñapaʼ epatyeset allohuen acheñeneshaʼ ñeñt̃ anorrc̈haʼtyets all. ");
INSERT INTO ameNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Oʼña epaʼhuet allempoña oʼ rrallmeʼchet allohuenet, eʼñe yetrraʼtuahuet. Oʼña yetuahuetpaʼ c̈ha aʼpchatyeset ñeñt̃ñapaʼ aʼyapac̈heret. Ñeñt̃ña aʼyapac̈herretpaʼ c̈hepaʼtchaʼ chorrats c̈harraʼ puechena epa cañt̃er eʼñe t̃amoʼyareʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Allempoña pamt̃arrpaʼ alloʼtsen Jesús all maʼyochena eʼñe ñapt̃ochayet pueyochreshaʼ epuet alloʼtsen. Allñapaʼ atet̃ otan pueyochreshaʼ: —¿Errot̃enaʼt otyenenña allohuen acheñeneshaʼ napaʼ eseshant̃eʼ? ");
INSERT INTO ameNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ñetñapaʼ atet̃ otyeset: —Patantarr acheñeneshaʼpaʼ atet̃caʼye otyenpet p̃apaʼ Juanañp̃oʼt̃eʼ ñeñt̃ep̃oʼ apatañtatseʼt̃ Yomporecop. Poʼpotantaññapaʼ atet̃ otyenpet, p̃apaʼ Elíasop̃oʼt̃eʼ. Poʼpotantaññapaʼ atet̃ otyenpet p̃apaʼ ñeñt̃ep̃oʼ ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ ahuat̃. T̃eʼñapaʼ ahuoʼ alla petanterra perromñot̃. ");
INSERT INTO ameNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Allempoñapaʼ alla aʼp̃t̃oʼterraneterr: —Sañapaʼ ¿errot̃enaʼt sotenenña sa? Pedroñapaʼ eñoratsapaʼ atet̃ och: —P̃apaʼ ñeñt̃ep̃caʼye Parets Puechemerep̃ ñeñt̃ep̃ Cristotosets. ");
INSERT INTO ameNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesúsñapaʼ alla oterraneterr: —Amaʼt puesheñarrot̃a amach eseshaʼ sotap̃saʼtatsto napaʼ ñeñt̃en Yompor Puechemeren ñeñt̃en Cristotets. Eʼñe poʼñoc̈h notenes amach eseshaʼ sotap̃saʼtatsto. ");
INSERT INTO ameNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Elloñapaʼ alla oterraneterr: —Napaʼ Ñeñt̃en Acheñetosets, atet̃ anaret̃ nocop, nanacchaʼ naʼmueroc̈htataret̃terra. Amach eseshaʼ pocteyeʼ nenterraye—amaʼt ñeñt̃ pomporneshaʼ pen allohuen judioneshaʼ, amaʼt ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar, amaʼt ñam̃a ñeñt̃ etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop. Amaʼt ñetpaʼ amach eseshayeʼ neyemterraye. Att̃achña napaʼ muetsataterrnetchaʼ. T̃arraña pomaʼpamtañopaʼ oʼch alla tantaterren Nompor. ");
INSERT INTO ameNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Elloñapaʼ alla oterraneterr allohuenet: —Ñerraʼm eseshaʼ mueneneʼ oʼch cot̃errnet na eʼñe poʼñoc̈h att̃och neyochreshaʼ neperranet, añ poctetsa sehuanmuetepaʼña ñeñt̃ atet̃ muenenet eʼñe ñocpueta. Att̃ochña ñetpaʼ oʼch eʼñe tomaʼnteret ñeñt̃ chechneneʼ poʼcorsoch amaʼt pat̃eʼtets yet̃ allchaʼ mueroc̈htet ñamet. Att̃ochña cot̃errnet eʼñe poctacma. ");
INSERT INTO ameNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","T̃arroʼmar ñerraʼm eseshaʼ eʼñe aña muenenet oʼch correna atomat att̃och eʼñe coshenet arr patsro, ñetñapaʼ c̈hach aʼchencatet ñañeñeta. T̃arraña ñerraʼm eseshaʼ eʼñe pocteʼ enteneʼ oʼch sohuanmuet ñeñt̃ atet̃ muenenet ñeñt̃ eʼñe ñocpueta arr patsro att̃ochña ñetpaʼ añach maʼyoc̈hret ñeñt̃ cohuentetsa nocop, ñeñt̃ña acheñerpaʼ corretsach pocsheñeshocmañen t̃ayot̃eñ eʼñe errponañohuen. ");
INSERT INTO ameNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Amaʼt errponenap̃aren esocmañen es yeyoratsetyes ora allpon ñeñt̃ yentyen añe patsro, t̃arraña ñerraʼm ñeñt̃ach eʼñe yaʼchencaterreʼ yecamquëñohuen ñeñt̃ñapaʼ amaʼt coñeʼt̃apaʼ amach es sherberrye. ");
INSERT INTO ameNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","T̃arraña ñerraʼm erraʼtsenchaʼ nepenquënaya na t̃eʼ neñoñpaʼc̈hoʼña c̈ha apencoc̈hen entennanet, napaʼc̈hoʼña nepencaʼhuerranetchaʼ esempoch nohuerra. Poʼñoc̈h napaʼ Ñeñt̃en Acheñetosets nohuerrach eʼñe na necohuenñot̃, ñeñt̃ara Nompor poʼcohuenña epan ñam̃a poʼm̃llañot̃eñnaneshar ñeñt̃ eʼñe t̃orraʼyetsa Partsocop. ");
INSERT INTO ameNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Poʼñoc̈hcaʼ t̃eʼpaʼ oʼch notas: Patantaʼttsos ñeñt̃es arroʼtsaʼyenes t̃eʼña amaʼt ama serromhuenaʼpaʼ oʼch senterrñañ Yompor poʼcohuenña att̃o atarr ayochreshat̃terra ña. ");
INSERT INTO ameNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Allempo met allponmat ñatoʼ poʼpsocmatño Jesúspaʼ ahuanman pueyochreshaʼ; añ anem Pedro ñam̃a Juan ñam̃a Jacobo. Arr anmanet aspent̃o allchaʼ maʼyochenaʼ Jesús. ");
INSERT INTO ameNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Allña maʼyochosapaʼ machayot̃epaʼtchaʼ poʼpoñetam̃p̃sosanet. Paʼclloyot̃paʼ c̈ha poʼpoñ orrtosanet. Paʼshtamohuen atarr huallamaʼt̃o poptosa. ");
INSERT INTO ameNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Allñapaʼ machayot̃epaʼtchaʼ orrtanet Moisés ñam̃a Elías. Ñetpaʼc̈hoʼña atarr cohuen orretyenet. Allñapaʼ serrpareʼtoset epuet Jesús. Ñetpaʼ añ serrpareʼtenet att̃o oʼ c̈hapmoch att̃och rroma Jesús oʼch ahuerr pueʼntaño. Ñetpaʼ atet̃ otyenet, arrchaʼ atet̃ peret Jerusaléño. ");
INSERT INTO ameNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ñehua, Pedro ñam̃a ñeñt̃ epuet alloʼtsen, ñetñapaʼ amaʼt atarr moñeʼtenetañpaʼ alla eʼñe achñesuerret, att̃oña entoñet Jesús poʼcohuenña amaʼt ñeñt̃ parro t̃omc̈hen. ");
INSERT INTO ameNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Oʼ maʼnaterrmocha Moisés ñam̃a Elías att̃och saʼneret Jesús. Pedroñapaʼ allent̃a eñora, atet̃ otan Jesús: —¡Atarruacaʼye Maestrochaʼ cohuenoʼtseneyt̃eʼ arr! Amaʼt pocteʼ penteñe oʼch yat̃omatonas maʼppahua quërpachet, puepahuarrpaʼ p̃ocopchaʼ, poʼppahueñpaʼ Moisésocopchaʼ, poʼppahueñpaʼ Elíasocopchaʼ. Pedropaʼ pueyorñot̃ att̃a mueneʼ otatseʼt, ama eñoche errot̃enchaʼ ot. ");
INSERT INTO ameNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Allempo eñorena Pedropaʼ c̈ha orrtosahuet os c̈hepaʼtchaʼ aʼpomam̃p̃sosanet. Att̃o aʼpomam̃p̃sosanet ospaʼ ñetñapaʼ atarr nanac yorenet. ");
INSERT INTO ameNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","C̈ha eʼmorrtostsa ñoñets osot̃; ñeñt̃ña ñoñetspaʼ Yompor otosahuet; ñeñt̃paʼ atet̃ ot: —Añmapaʼ ñeñt̃ no Nechemer ñeñt̃ atarr nemuerena ñeñt̃chaʼ eʼñe cohuen seʼm̃ñoterr. ");
INSERT INTO ameNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Allempo oʼhuañ eʼmorrta ñoñetspaʼ oʼ eʼñe ñapt̃amerra Jesús. Pueyochreshaʼña allempopaʼ att̃a aʼnasoteñet. Amaʼt puesheñarrot̃etapaʼ ama otuerreto ñeñt̃ atet̃ oʼ entuahuet. ");
INSERT INTO ameNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tsapat̃ña allempo huac̈henet aspent̃ot̃paʼ allñapaʼ shonteʼ acheñeneshaʼ ñeñt̃ huac̈haʼttsa ñeñt̃ pocterrahuet. ");
INSERT INTO ameNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Alloʼtsen puesheñarr yacma ñañapaʼ atet̃ otosan Jesús: —Maestro, napaʼ atarr nemneñ oʼch pentennanaʼ nacñeʼt̃er. Napaʼ eʼñe ñeñt̃et̃ollapa nepat̃rror. ");
INSERT INTO ameNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ñapaʼ ñerraʼm esempo rromueñ oneñet̃paʼ c̈hach rranareʼta oʼch ot̃achpaʼ oʼch ataʼtach patso c̈hach amtan paʼpoʼ. Att̃oña atarr atserrp̃atseʼtateñ. Ama mueno oʼch aʼrroyer. ");
INSERT INTO ameNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Napaʼ oʼ notuosnap̃ña peyochreshaʼ oʼch cac̈hpatateret oneñet̃ t̃arraña ñetñapaʼ ama errot̃ peto att̃och cac̈hpatateret oneñet̃ ñeñt̃ atarr mueroc̈htateneʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesúsñapaʼ atet̃ ot: —Sapaʼ ñeñt̃es acheñres amaʼt mameshapaʼ ama ayemtenayeʼ sentpenno, c̈hach poʼpoñ sentuena seyoc̈hro nocop. Oʼ allponmatuanen alloʼtsenen arr patsro napaʼ att̃a atarr naʼhuantennas, att̃a necuenes ñatoʼ att̃ot̃paʼ oʼch sameʼñerrna. Allempoñapaʼ atet̃ otan yacma ñeñt̃ oteneʼ oʼch aʼcrratoñ puechemer: —T̃eʼpaʼ oʼch p̃anmon pechemer arr. ");
INSERT INTO ameNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Allempo anem̃ Jesúseshopaʼ oneñet̃ñapaʼ alla rromuerranerr cheshachor oʼ alla ot̃atererr alla ataʼtatererr patso. Jesúsñapaʼ atet̃ otapan oneñet̃: —T̃eʼpaʼ poʼñoc̈h oʼch notap̃, pecac̈hpaʼnerñacaʼyeña añ cheshachor. Allempo aʼcrrater Jesús oʼ alla apuerrñañ pompor. ");
INSERT INTO ameNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Allohuen acheñeneshaʼpaʼ att̃a cohuanrrorteñet. Ñetpaʼ eʼñe eñoteñet Yompor poʼpartsoña orrtetsa. Att̃a epayeʼ cohuanrrorteñet atarr cohuen enteññañet poʼpartsoña, t̃arraña Jesúsñapaʼ alla yerpaterranerr pueyochreshaʼ, ñeñt̃paʼ atet̃ otanet: ");
INSERT INTO ameNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—T̃eʼpaʼ seʼm̃ñoten eʼñe cohuen, amach sepsatsterrnano neñoñ ñeñt̃ atet̃ notenes t̃eʼ. Na Ñeñt̃en Acheñetosetspaʼ pomataterrnetchaʼ att̃ochña errot̃uanenchaʼ perrnet. ");
INSERT INTO ameNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ñeñt̃ña ñoñetspaʼ ñetñapaʼ amaʼt puesheñarrot̃etapaʼ ama eshcayeʼ eñotenayeʼ enteñeto t̃arroʼmar ama c̈henaʼ allempoch c̈hapanet pueyoc̈hreto. Ñetña pueyorñot̃etpaʼ ama eseshayeʼ aʼp̃t̃oʼtenaye est̃eʼ otenanetña att̃o eñoranaʼtenanet. ");
INSERT INTO ameNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Poʼpocheñoña pueyochreshaʼpaʼ eʼñe ñagattseta otannaʼtyeset: —Taʼmcaʼye erraʼtsenot̃eyt̃eʼñacaʼye ñeñt̃ey atarr sherbets ñeñt̃ey atarr am̃chaʼtaret̃oyen enteney acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesúsñapaʼ eʼñe eñotenanet ñeñt̃ atet̃ cot̃apeʼchatseʼtyenet ñet pueyoc̈hreto att̃o eʼñe cohuen entyenet eʼñe ñañeñeta. Ñañapaʼ cheshat̃olla c̈horeʼtpaʼ t̃omach eʼñe ñesho, ");
INSERT INTO ameNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","allempoñapaʼ atet̃ otanet: —Erraʼtsenot̃es sa ñerraʼm eʼñe cohuen saguëñ amaʼt ñeñt̃ ama asherbenayeʼ enteneto atet̃ ñerraʼm añ cheshat̃oll t̃arroʼmar sapaʼ na sameʼñena, naʼnaña eʼñe cohuen saguën. Elloña ñam̃a erraʼtsenot̃es sa ñeñt̃es naguëneʼ na, ama eʼñe napt̃ocheyeʼ saguëno, añeʼnaña saguënnan Nompor ñeñt̃ nellsenseneʼ. T̃arroʼmar ñerraʼm erraʼtsenchaʼ pocteʼ enteneʼ oʼch yenpuenan amaʼt ñeñt̃ ama esoyeʼ enteneto, ñetñapaʼ atarrchaʼ poʼñoc̈h asherben entenanet Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Allempoña pueyochreshaʼ ñeñt̃ Juanpaʼ atet̃ otan Jesús: —Maestro, ya ahuañapaʼ atet̃ yeñch puesheñarr yacma ñeñt̃ cac̈hpatateneʼ oneñet̃ acheñ. Eʼñe puec̈horeʼteñot̃ep̃ p̃a pesoʼchñopaʼ oneñet̃paʼ cac̈hpaʼnerran acheñ. Yañapaʼ ama pocteyeʼ yeñche t̃arroʼmar ñapaʼ ama parroyeʼ yeyemteno. Ñeñt̃oʼmarña yapaʼ yoch: —Amach atet̃ pep̃atsto. ");
INSERT INTO ameNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesúsñapaʼ atet̃ otanet: —Amachcaʼye sepatareʼtatsche t̃arroʼmar ñerraʼm ama c̈ho epatareʼtenye yam̃a ñeñt̃ña poʼñoc̈hpaʼ eʼñecaʼye parrocma yeyenpannena. ");
INSERT INTO ameNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","C̈hapmoch allempoch oʼch alla ahuerr Jesús pueʼntañopaʼ ñañapaʼ atarr sechena oʼch ahuerr Jerusaléño. Ñeñt̃oʼmarña mueñan pueyochreshaʼ ñeñt̃chaʼ otrraʼtatsa ");
INSERT INTO ameNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","oʼch ahuet samarioʼmarneshaʼ paʼnetsro oʼch eʼnoset muets allchaʼ c̈hap ñam̃a Jesús allchaʼ amesnom epuet pueyochreshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","T̃arraña samarioʼmarneshaʼñapaʼ ama mueneto oʼch agaparet̃tet all paʼnetsreto, t̃arroʼmar ñetpaʼ eñoteñet arr sechenet oʼch ahuet Jerusaléño. ");
INSERT INTO ameNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ñeñt̃oʼmarña Jacobo ñam̃a Juan ñetñapaʼ atet̃ ochet Jesús: —Partseshachaʼ ¿amaʼt pocteʼ penteñe yapaʼ oʼch yenam huapuepaʼ tsoʼ entot̃? allochñapaʼ ñeñt̃chaʼ aʼpoyatatuerrahuet ñeñt̃chaʼ eʼñe aʼchencatuerrahuet ñeñt̃ atet̃ peʼt̃ Elías ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ ahuat̃. ");
INSERT INTO ameNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesúsñapaʼ att̃a cohuanetpaʼ atet̃ otanet: —Ñeñt̃ atet̃ soct̃apeʼchatseʼtyenpaʼ amaʼt mameshapaʼ ama pocteyaye. Amaʼt señoteñeña Yomporpaʼ ama att̃eyeʼ cot̃apeʼchatenyeña Puecamquëñot̃. Ñeñt̃ semnen sapaʼ poʼpoña cot̃ap̃ñats. ");
INSERT INTO ameNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Na Ñeñt̃en eʼñe Acheñetosetspaʼ amacaʼyeña añecop nohuapo oʼch naʼchencatos acheñeneshaʼ. Napaʼ añecopcaʼyeña nohuapa oʼch naʼqueshp̃atos allohuen acheñeneshaʼ. Allempoñapaʼ oʼ metac̈haʼtet allot̃paʼ ahuanmuet poʼpoñ anetso. ");
INSERT INTO ameNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Poʼpocheñoñapaʼ allempo oñemyenet t̃oñoʼmar allñapaʼ poctanet puesheñarr yacmapaʼ ñañapaʼ atet̃ otapan Jesús: —Na t̃eʼpaʼ nemneñ oʼch noct̃areʼtyesep̃ amaʼt errohuanenchaʼ pechopeñeʼchyes. ");
INSERT INTO ameNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesúsñapaʼ atet̃ och: —T̃eʼpaʼ napaʼ peñotenchaʼ amaʼt nepacllapaʼ ama necheñe all neyc̈henañ. Roʼquëp̃paʼ c̈hocma eñall paʼpon allecma yec̈hena. Ot̃ec̈hnopaʼc̈hoʼña c̈hocma eñall paʼmaʼ allecma yec̈haʼyenet. T̃arraña naña Ñeñt̃en Acheñetosetspaʼ ama eñalle ñeñt̃ eʼñe nepaquëll nepen allchaʼ nep̃anena. ");
INSERT INTO ameNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Poʼpocheñoña Jesúspaʼ atet̃ oterranerr poʼpsheñeñ acheñ: —T̃eʼpaʼ oʼch p̃oct̃aʼn att̃och poʼñoc̈h neyochreshaʼ neperrep̃. T̃arraña ñeñt̃ña acheñerpaʼ atet̃ otan Jesús: —T̃eʼpaʼ arrchaʼña ñanom pemnaterren oʼch ahuerren apuesho, oʼchña nepampaʼhueraʼ apañpaʼ allempochña nohuerrapaʼ oʼch noct̃ap̃. ");
INSERT INTO ameNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","T̃arraña Jesúspaʼ atet̃ och: —Acheñeneshaʼ ñeñt̃ ama yerpaʼpenaye Yompor, ñetñapaʼ pampannaʼtetepaʼ parro arromñat̃ecmuet. T̃arraña p̃ocoppaʼ ñeñt̃ep̃ oʼ peyerpuera Yompor añ poctetsa oʼch auyesep̃ serrpareʼtyeseʼ Yompor poʼcohuenña ñeñt̃ att̃o atarr ayochreshat̃tena ña. ");
INSERT INTO ameNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Poʼpocheño allempo serrpareʼten Jesús epuet ñeñt̃ ameʼñenaya, ñeñt̃ña acheñerpaʼ atet̃ otan Jesús: —Napaʼ Ayochreshat̃e poʼñoc̈hchaʼcaʼye noct̃ap̃. T̃eʼpaʼ atoʼt nasuerraʼ nepacllo att̃och nesoʼteraʼ namoʼtseshaʼ; allempochña alla nohuerrerrpaʼ oʼch noct̃ap̃. ");
INSERT INTO ameNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesúsñapaʼ atet̃ och: —Ñeñt̃ ama eʼñeyeʼ maʼyoc̈hrenaye att̃och t̃orrenet eʼñe cohuen Yomporecop, ñeñt̃ña acheñerpaʼ amach eʼñe cohuenayeʼ sherbeno att̃och eʼñe epatuan Yompor poʼcohuenña ñeñt̃ att̃o atarr ayochreshat̃tena ña. Ñeñt̃ acheñerpaʼ atet̃chaʼ netmaʼntacha: Ñerraʼm eseshaʼ orreneʼ etamapets att̃och etaman pats eʼñe cohuen pac̈harr paʼmro, ñerraʼm paʼcheʼñont̃a cohuaʼnom amaʼt mameshapaʼ amach etsotanoña etamapets att̃och eʼñe pac̈harr etaman pats allchaʼ nareʼtatseʼt paʼmro. ");
INSERT INTO ameNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Allempoña Partseshaʼpaʼ alla llesenserranerr poʼpotantañ pueyochreshaʼ canc̈hrroch c̈harrasheña ñeñt̃chaʼ otrraʼtatsa oʼch serrpareʼtyesnomuet. Ñetpaʼ atet̃chaʼ p̃aʼnmuet eʼñech epsheñaʼttsocma tet. Arrchaʼ taʼyeset ora allohuen anetsoʼmar ñam̃a amaʼt allampañoʼmar; allochñapaʼ allchaʼ oñem ñam̃a tsapat̃onet̃ Jesús. ");
INSERT INTO ameNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ama ahuanenetaʼ Jesúsñapaʼ atet̃ otanet: —Shonteʼ narmets ñeñt̃ nanac ellom̃reʼtets ñeñt̃chaʼ aʼyapac̈hetañ. T̃arraña ataruasañña ñeñt̃chaʼ aʼyapac̈heʼpaʼ ama atarr atonayaye. T̃eʼpaʼ añchaʼña sanamoñ pamoʼmteʼ mueñanepaʼña ñeñt̃chaʼ aʼyapac̈herrets paʼmro. Ñeñt̃paʼ atet̃ tomaʼntatanet Jesús att̃o atarr shonteʼ acheñeneshaʼ ñeñt̃chaʼ ameʼñerrtsañ t̃arraña ñeñt̃chaʼ ameʼñaterrahuetpaʼ ama atarr atonayaye. Añchaʼña yenam Yompor ñeñt̃ Yamoʼmteʼ yepen mueñanepaʼña paʼtaruasañer ñeñt̃chaʼ t̃orraʼyerrtsa ñocop allemeñ anetsoʼmar. ");
INSERT INTO ameNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ñam̃a sapaʼ ñerraʼm oʼch ahues t̃eʼpaʼ señochchaʼ poʼñoc̈h c̈hocmach eñall ñeñt̃chaʼ seʼmoñeʼteʼ amaʼt sapaʼ amach c̈ho errot̃ sepenanetañe ñet. Ñeñt̃oʼmarña notenes t̃eʼpaʼ oʼch nemñas eʼñech att̃es ñerraʼm carrnero oʼch ahuoʼ alloʼtsen maʼyarroc̈hno. ");
INSERT INTO ameNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ñam̃a amach sanmatsto quelle, amaʼt sebolsa, amaʼt poʼptaña sesapatpaʼ amach sanmatsche. Oʼch ahues semaʼyorñecma. Amaʼt eseshaʼch sehuom̃chaʼtyesnom t̃oñoʼmarpaʼ amach alla soʼchtatsto. ");
INSERT INTO ameNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Allempoch sec̈hap amaʼt erraʼtsena anetsro all sesen, amaʼt erraʼtsena pocoll allchaʼ sec̈happaʼ ñanomchaʼ atet̃ sep̃osa. Eʼñe sehuom̃chaʼteñot̃ ñeñt̃ apacllat̃eshaʼpaʼ oʼch senamatosñañ Yompor paʼnateña. Ñerraʼm ñetña poʼñoc̈h eʼneññañet Yompor paʼnateña, Yomporñapaʼ aʼnatenanetchaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","T̃arraña ñerraʼm ñetña ama eʼneññañeto Yompor paʼnateñapaʼ Yomporñapaʼ oʼch alla apuerres sa paʼnateña. ");
INSERT INTO ameNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ñeñt̃e pocollro allchaʼ eʼñe cohuen agapaset allach saʼposa. Ñeñt̃ rrenet ñet ñeñt̃chaʼ rratapaset, ñeñt̃ach serros sam̃a. T̃arroʼmar ñeñt̃es t̃orretsa eʼñe pocteʼ atet̃chaʼ tsaʼtenset. Amach sommareʼtyesatsto allemeñ pocolloʼmar, allach eʼñe sommosa puepahuarro. ");
INSERT INTO ameNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Amaʼt erraʼtsena anetsro allchaʼ sec̈herrerr allchaʼ eʼñe cohuen aguërrseterr, amaʼt errot̃ena rreñets apasetpaʼ ñeñt̃ach serros. ");
INSERT INTO ameNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Allñapaʼ saʼcrratyesoschaʼ ñam̃a ñeñt̃ atsnaʼtyets. Allchaʼ seserrpareʼtatyesosanet, atet̃chaʼ sotos: “T̃eʼpaʼ oʼ yec̈hapatonas Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña. Aña palltetsa oʼch sameʼñera att̃och eʼñe c̈haponasa seyoc̈hro.” ");
INSERT INTO ameNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","T̃arraña ñerraʼm erra anetsro allchaʼ sec̈hap ñeñt̃ alloʼmarneshaʼña ama cohuenayeʼ agapaseto, allña t̃oño allecma chopeñeʼchyenet ñet oʼch señotatnomanet. Ñeñt̃paʼ atet̃chaʼ sotnomanet: ");
INSERT INTO ameNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Amaʼt pats ñeñt̃ oʼ cheta yetco arr saʼnetsro, t̃eʼñapaʼ oʼch yepaʼshetcaʼtyesnoma att̃och señoch sapaʼ amaʼt mameshapaʼ ama pocteyeʼ entenso Yompor. T̃arraña amaʼt att̃eñpaʼ t̃eʼpaʼ oʼch neñotatnomues Yompor poʼcohuenña autsa c̈haponasañ ñeñt̃ att̃o ayochreshat̃tena ña.” ");
INSERT INTO ameNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Allempoña Jesúspaʼ alla oterranerr pueyochreshaʼ allempo ama senetaʼ: —Poʼñoc̈h t̃eʼpaʼ oʼch notas, esempohuañen allempoch aʼcraret̃etuerra allohuen acheñeneshaʼpaʼ añ anetsoʼmarneshaʼ ñeñt̃ ama cohuenayeʼ sagapaye t̃eʼ, nanacchaʼ yoroc̈henoʼtsenterret allempo. Amaʼt sodomoʼmarneshaʼpaʼ amach tama yoroc̈henoʼtsenterreto atet̃ ñerraʼm ñeñt̃ anetsoʼmarneshaʼ ñeñt̃ ama cohuenayeʼ sagapaye t̃eʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Allempoña Jesúspaʼ alla oterrerr: —Nanacchaʼ llequëñtsoʼtsaʼyenes coraziñoʼmarneshachaʼ; nanacchaʼ llequëñtsoʼtsaʼyenes sam̃a betsaidoʼmarneshachaʼ. T̃arroʼmar amaʼt atarr norrtatyennaseñ nepartsoña sesho, sañapaʼ amaña soct̃apeʼchuerroña ello cohuen Yomporecop. Ñerraʼm arrchaʼña norrtatañ nepartsoña tiroʼmarneshesho ñam̃a sidónoʼmarneshesho, ñetñapaʼ ahuat̃ot̃eñt̃eʼ cot̃apeʼcherretañ eʼñe cohuen Yomporecop. Ñetpaʼ att̃ochña eʼñe orrtetañ c̈ha llecatenanet poʼchñar, cotnasheʼmach chorraʼyesetañ, tsapñach epachshemaʼtyenetañ all anorrc̈haʼtyenet puellquëñot̃et. ");
INSERT INTO ameNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ñeñt̃oʼmarña t̃eʼpaʼ notenes, esempohuañen allempoch aʼcraret̃etuerra allohuen acheñeneshaʼpaʼ tiroʼmarneshaʼ ñam̃a sidónoʼmarneshaʼ ñetñapaʼ amach tama aʼcoñchataret̃terreto allempo. Coraziñoʼmarneshachaʼ ñam̃a betsaidoʼmarneshachaʼ saña allempopaʼ atarrchaʼ coñchaterrset. ");
INSERT INTO ameNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ñam̃a sa capernaumoʼmarneshachaʼ c̈hat̃eʼ sotenapañ att̃o eʼñe cohuen sentyena sañeña, Yomporñapaʼ allent̃ach aʼtapaterres pueʼntaño. Ñeñt̃paʼ amachcaʼye att̃eyeʼ perrsoña Yompor, allachcaʼye huaporeʼterres oʼpono coñchaʼpuetso. ");
INSERT INTO ameNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesúsña allempo ama senaʼ pueyochreshaʼ oʼch serrpareʼtyenetaʼ anetsoʼmar ñañapaʼ alla oterraneterr: —Ñerraʼm eseshaʼch seʼm̃ñotapueʼ sa, naʼnaña eʼm̃ñotenet. T̃arraña ñerraʼm eseshaʼch ama sagapaye sa, naʼnaña ama aguëneto. Ñam̃a ñerraʼm eseshaʼ ama mueno oʼch agapnet na, Nomporeʼnaña ama mueneñeto oʼch agapet t̃arroʼmar ñapaʼ ña nellsenseneʼ. Arrpaʼ allohua ñeñt̃ atet̃ otan pueyochreshac̈hno ñeñt̃ canc̈hrroch c̈harrasheña. Allempoñapaʼ mueñanet allchaʼ serrpareʼtatyesnomuet. ");
INSERT INTO ameNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Eʼñe allponmatatsapaʼ oʼ alla huac̈herra pueyochreshaʼ ñeñt̃ canc̈hrroch c̈harrasheña. Ñetñapaʼ eʼñe pocsheñeshocmañen huac̈henet Jesúsesho. Atet̃ serrpareʼtatueñet: —Partseshachaʼ amaʼt oneñet̃ec̈hnopaʼ eʼñe yec̈haʼnmac̈haʼtatue eʼñe yec̈horeʼteñot̃ p̃a pesoʼchño. ");
INSERT INTO ameNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ñañapaʼ otapuenanet: —Napaʼ neñchcaʼye oneñet̃ allempo aprratam̃p̃saret̃ta poʼhuamenc. Eʼñe att̃emaʼt̃ ñerraʼm ñapaʼ oʼ c̈haʼnmachet entot̃ atet̃ pena meratsteʼ huetsa entot̃ oʼch c̈hap añe patsro. ");
INSERT INTO ameNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Poʼñoc̈hcaʼye napaʼ atarr ahuamencat̃ nep̃aʼyesapas. Amaʼt allohuen ñeñt̃ seʼmoñeʼtyeneʼ sañapaʼ ñeñt̃ecopña nellsensaʼyesas allochñapaʼ att̃och eʼñe saʼmchechatyesuenaʼ allohuen paʼnamen, amaʼt shechpec̈hno ñam̃a yellasoc̈hno, eʼñe sat̃mamaʼteñot̃paʼ eʼñe saʼpep̃tseʼtatseʼtueñaʼ. Allochñapaʼ amach eñalleterreʼt̃e ñeñt̃chaʼ semueroc̈htateʼ amaʼt pat̃rra. ");
INSERT INTO ameNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Amaʼt atarr ahuamencat̃eseñ att̃o oʼ saʼmchechatyesuahue oneñet̃ec̈hno, amachña ñeñt̃a atarr socshatsto. Añchaʼña eʼñe socshena att̃o aquellcaʼyesaret̃es sesoʼcheñ Yomporesho ñeñt̃ pueʼntañoʼtsen. ");
INSERT INTO ameNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Eʼñe allempoña Jesúspaʼ atarr coshateñ Parets Puecamquëñ. Ñeñt̃oʼmarña ñapaʼ eʼñe pocsheñeshot̃ maʼyochenana Pompor, ñeñt̃paʼ atet̃ oten: —Na Apachaʼ oʼch naʼyeʼchoc̈htatonap̃, p̃apaʼ p̃a ñeñt̃ep̃ atarr ayochreshat̃tetsa peʼntaño amaʼt ñam̃a arr patsro. Naʼyeʼchoc̈htatonap̃ t̃arroʼmar ora añec̈hno ñeñt̃ pecohuenña pepen, ñeñt̃paʼ ama arreyeʼ pec̈hapateñe pueyoc̈hro ñeñt̃ atarr eñotañ entyetsa. P̃apaʼ aña pec̈hapaten pueyoc̈hreto ñeñt̃ ama eñotañeyeʼ entetso. T̃arroʼmar Apa eʼñe pemuereñot̃ ñeñt̃paʼ atet̃ña eʼñe pocteʼ penten p̃a. Arrpaʼ allohua ñeñt̃ atet̃ maʼyochenana Pompor. ");
INSERT INTO ameNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Nompor allohuen poʼcohuenña eʼñe eñotatuenen. Na ñeñt̃en Puechemerenpaʼ ama poʼñoc̈h eseshayeʼ neñotenaye, ñapt̃aña Nompor eñotenen. Nomporpaʼc̈hoʼña ama poʼnoc̈h eseshayeʼ eñotenaye, napt̃aña na ñeñt̃en Puechemeren eʼñe neñoteñ Nompor, ñam̃a erraʼtsenchaʼ ñeñt̃ eʼñe pocteʼ nenten na ñeñt̃en Puechemeren ñeñt̃ñapaʼ oʼch neñotater Nompor. ");
INSERT INTO ameNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Allempoñapaʼ alla cohuerranerr pueyochreshaʼpaʼ atet̃ otanet eʼñe ñocpueta: —Atarr cosheñtsoʼtsaʼyenes sa t̃arroʼmar eʼñe sa seclloyot̃paʼ oʼ senterrñañ Yompor poʼcohuenña. ");
INSERT INTO ameNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Poʼñoc̈hcaʼye notenes eʼñe ahuat̃ot̃eñpaʼ shonteʼ ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ amaʼt ñam̃a ñeñt̃ am̃chaʼtaret̃tatseʼt̃ allempo, ñetñapaʼ atarr muenetañeʼt̃ oʼch enterrñañetañ Yompor poʼcohuenña ñeñt̃ oʼ senterr sa t̃eʼ. T̃arraña allempo ñetpaʼ amaña eseshayeʼña enterrapaye Yompor poʼcohuenña. Amaʼt atarr muenetañeʼt̃ oʼch eʼm̃ñoterrñañet Yompor poʼñoñ ñeñt̃ oʼ seʼmuerr sa t̃eʼ t̃arraña allempo ñetpaʼ amaña eseshayeʼña eʼmuerrapayeña Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Allempoña puesheñarr ñeñt̃ atarr etsoteneʼ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop, ñaña tantapaʼ atet̃ otan Jesús att̃och eñoch errot̃ent̃eʼ yec̈haten ña, ñeñt̃paʼ atet̃ och: —Maestrochaʼ taʼ, ¿errot̃enaʼtchaʼ nep̃aña na eʼñe cohuen att̃och napaʼ corretsanach eʼñe t̃ayot̃eñ amaʼt errponañohuen? ");
INSERT INTO ameNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesúsña anap̃paʼ atet̃ och: —¿Errot̃enaʼt otenña ñoñets ñeñt̃ atet̃ anaret̃ ahuat̃ot̃eñ? ¿Esoʼtña ñoñtsor pelleyenña p̃a ñeñt̃ anaret̃ all? ");
INSERT INTO ameNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ñañapaʼ atet̃ och: —Ñeñt̃ ñoñetspaʼ atet̃ oten: “Atarrchaʼ yemorrenteña Yeyomporer ñeñt̃ Yepartseshar yepen eʼñe yeyoc̈hrocmañen. Ñam̃a eʼñe yecamquëñot̃ yemorreñchach eʼñe yehuamencohuen, amaʼt ñam̃a ora yoct̃ap̃ñohuen.” Ellonet̃ poʼpoñpaʼ atet̃ oten: “Atarrchaʼ yemorrenteña yamoʼts eʼñe atet̃ atarr yemorrentena yañeña.” ");
INSERT INTO ameNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesúsñapaʼ atet̃ och: —Atet̃caʼye eʼñe atet̃ p̃oten. Ñerraʼm atet̃chaʼ eʼñe pep̃ohuapaʼ p̃añapaʼ corretsap̃ach eʼñe t̃ayot̃eñ amaʼt errponañohuen. ");
INSERT INTO ameNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ñeñt̃ña acheñerpaʼ aña atarr muenen oʼch eʼñe cohuen enteñ Jesús ñam̃a allohuen acheñeneshaʼ. Ñeñt̃oʼmarña alla aʼp̃t̃oʼterranerr Jesús: —Ñehua, t̃eʼpaʼ oʼch p̃oten ¿eseshaʼtña ñeñt̃ eʼñe poʼñoc̈h namoʼts nepen? ");
INSERT INTO ameNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Att̃och eñotach ñeñt̃ eʼñe poʼñoc̈h amotsot̃ entetsa ñeñt̃ eʼñe pamoʼts p̃annena, Jesúsñapaʼ atet̃ tomaʼntacha, ñeñt̃paʼ atet̃ serrpareʼtach: —Eñall puesheñarr judioneshaʼ ñeñt̃ huetsa Jerusaléñot̃, ñapaʼ arr sen Jericó. T̃oñoñapaʼ alla rromap̃ eñet̃ eʼñe puerratam̃p̃satsreʼtuet amaʼt paʼshtam. Atarr atserrpet. Autsa muetsapuetañ allempoña ñeñt̃ atserrp̃apueʼpaʼ ahuanerret. ");
INSERT INTO ameNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Allempoña t̃ematenpaʼ puesheñarr judioneshaʼ ñeñt̃ corneshaʼ ñapaʼc̈hoʼña all oñem. Ñañapaʼ amaʼt entospaʼ att̃a oñmatseʼtam̃pesya aʼyoʼmarpaʼ oʼ metane. ");
INSERT INTO ameNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Allempoña t̃ematenpaʼ huapa ñam̃a poʼpsheñeñ judioneshaʼ ñeñt̃ levitaneshatets. Ñapaʼc̈hoʼña amaʼt entospaʼ att̃a oñmatseʼtam̃pesya aʼyoʼmar oʼ metane ñam̃a. ");
INSERT INTO ameNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Allempoña t̃ematerrerr oʼ huapa ñam̃a puesheñarr ñeñt̃ ama judioneshayaye ñeñt̃paʼ samarioʼmarneshaʼ. Ñapaʼ ñeñt̃ pamoʼtseshaʼ pen ama amoʼtstenano judioneshaʼ. T̃arraña ñapaʼ allempo entosan puesheñarr judioneshaʼ ñeñt̃ atserrpenetpaʼ atarr muerosya. ");
INSERT INTO ameNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Allent̃a ponmosya, shosñañ olivoseʼ ñam̃a vino allo partosñañ all atserrpeñet. Allempoñapaʼ huanquërrñañ all atserrpeñet. Tantaterpaʼ montacha pashanoropaʼ anem̃ allchaʼ mos. Allñapaʼ all cohuam̃p̃sos. ");
INSERT INTO ameNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tsapat̃ñapaʼ chetaʼmuenan epa denario apaʼmuenan apacllat̃eshaʼ atet̃ otaʼmueñ: “T̃eʼpaʼ pecuam̃peschaʼ, errponchaʼ p̃aʼgastaʼ ello pec̃llayor, napaʼ netsaʼtuerrp̃ach esempoch nehuerra.” ");
INSERT INTO ameNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesúsñapaʼ alla oterranerr ñeñt̃ acheñer: —Maʼpsheñoʼmaretpaʼ p̃apaʼ ¿erraʼtsenaʼtña pentenña ñeñt̃ atarr amoʼtsot̃ entetsa ñeñt̃ eʼñe pamoʼts peneʼ ñeñt̃ rromaʼ eñet̃? ");
INSERT INTO ameNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ñeñt̃ña acheñerpaʼ atet̃ oterranerr Jesús: —Añcaʼye eʼñe pamoʼts peneʼ ñeñt̃ eʼñe puemuereñot̃ partatseʼterreʼ. Jesúsñapaʼ atet̃ och: —T̃eʼpaʼ atet̃chaʼ peperra p̃am̃a. Oʼch ahuerrep̃paʼ atarrchaʼ pemorrentera ora allohuen acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","All oñen Jesúspaʼ oʼ c̈hap pat̃err anetso. Allña puesheñarr coyaneshaʼ añ paʼsoʼcheñ Marta, ñañapaʼ eʼñe cohuen agapapan Jesús paʼpacllo. ");
INSERT INTO ameNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ñeñt̃ña Martapaʼ eñall ñam̃a paʼmoʼnerr ñeñt̃paʼ añ paʼsoʼcheñ María. Maríañapaʼ all anen Partseshaʼ Jesús paʼrrp̃ot̃ allot̃ eʼm̃ñoteññañ ñeñt̃ atet̃ serrpareʼtatenanet. ");
INSERT INTO ameNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Paʼmoʼnerrña Martapaʼ aña eʼñe maʼyoc̈hrena aʼt̃oram̃p̃seʼ all puetareʼtallmeʼchen. Ñañapaʼ ponmana Jesúspaʼ atet̃ otos: —Ayochreshat̃e, amat̃eʼ pocteʼ penteñe napt̃a neptareʼtallmeʼchen; nemoʼnerrñapaʼ ama yenpuenno. T̃eʼpaʼ oʼch p̃och aʼt̃oram̃p̃sapretnepaʼ nat̃ar. ");
INSERT INTO ameNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesúsñapaʼ atet̃ och: —Noc̈ha Marta, shonteʼ paʼnamen ñeñt̃ pet̃orraʼyena, p̃apaʼ ñeñt̃aña atarr pellcateneʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","T̃arraña eʼñe pat̃rraña ñeñt̃ atarr sherbets; ñeñt̃paʼ att̃o eʼñe cohuen socshennana neñoñ. Pemoʼnerr Maríapaʼ ñapaʼ ñeñt̃ña atarr eʼnen. Ñeñt̃paʼ amaʼt eʼñe esesha amach errot̃enot̃ puerratam̃pereto. ");
INSERT INTO ameNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Poʼpocheño Jesúspaʼ alla maʼyocherrerr. Oʼ maʼyochuapaʼ puesheñarrña pueyochreshaʼpaʼ atet̃ och: —Partseshachaʼ t̃eʼpaʼ oʼch peyc̈hatey maʼyochatsa atet̃ peʼt̃ Juanañ, ñapaʼ c̈hocma yec̈hataneʼt̃ ña pueyochreshaʼ atet̃chaʼ maʼyochet. ");
INSERT INTO ameNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesúsñapaʼ atet̃ otanet: —Ñehua, ñerraʼm esempoch semaʼyochena atet̃chaʼ sot: Yompore Partso ñeñt̃ep̃ peʼntañoʼtsen, yentapepaʼch p̃a atarr Partsop̃. C̈hapuepaʼch Nompore allempoch atarr p̃aʼyochreshat̃terra arr patsro. Yetsotonapepaʼch arr patsro ñeñt̃ atet̃ pemnen p̃a Nompore atet̃ penet ñam̃a peʼntaño. ");
INSERT INTO ameNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","C̈hocmuepaʼch Nompore p̃apueney ñam̃a yocrram̃ ñeñt̃ allpon yepalltaʼyena pat̃eʼtets yet̃. ");
INSERT INTO ameNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pep̃retnaʼhuonayepaʼch Nompore allohuen yoʼchñar ñeñt̃ ama pocteyeʼ pentapretenye, att̃o Nompore yapaʼc̈hoʼña yep̃retnannena ñerraʼm esempo errot̃ yep̃annena. Ñam̃a amach Nompore pemnatatsche sosyaʼtañ oʼch atarr topateney. Añchaʼña c̈hoch Nompore p̃aʼypoʼñataterrey allohuen sosyaʼtsañec̈hno. ");
INSERT INTO ameNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Elloñapaʼ alla yec̈haterraneterr ñeñt̃ att̃o eʼñe yenamueñot̃ Yompor apueychaʼ. Ñeñt̃paʼ atet̃ serrpareʼtaterraneterr tomaʼnteñtso. —Ñerraʼm eñall puesheñarr ñeñt̃ eʼñe cohuen yeyemtenaya, amaʼt rroc̈h tsapo oʼch ahuey paʼpacllo yec̈horeʼteñot̃paʼ atet̃chaʼ yotos: “Napaʼ masheñchaʼ añecop nohuena oʼch p̃apuen amaʼt coñeʼt̃a rreñets, ");
INSERT INTO ameNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","t̃arroʼmar oʼ c̈hap puesheñarr namoʼts ñeñt̃ huetsa b̃ac̈hayot̃, napaʼ ama es necheno amaʼt coñeʼt̃a alloch neyemaʼcha.” ");
INSERT INTO ameNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","T̃arraña ñapaʼ poʼponrot̃paʼ ñatoʼ c̈hach otapuey: “Amach p̃aʼtsrreʼmoc̈htanaʼtatstosno t̃arroʼmar oʼ eʼñe echarr neyottam̃pesuena, allohuen nacñet̃aret̃olleshohuenpaʼ oʼ yemanrraʼtuen. Ñeñt̃oʼmarña ama eshcayeʼ atantenno oʼch nec̈haʼnmonap̃a att̃och es napap̃.” ");
INSERT INTO ameNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","T̃arraña napaʼ oʼch notas, amaʼt ñeñt̃ atarr yeyemtenañaʼ ñerraʼm ama c̈haʼnmaponayopaʼ yañapaʼ ñerraʼm alla yenamuereʼt̃paʼ c̈haʼnmaponayach att̃och apapuey amaʼt erraʼtsena ñeñt̃ atarr yenamueñ att̃och amach alla yaʼtsrreʼmoc̈htanaʼtneñe es enamareʼteʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ñeñt̃oʼmarña napaʼ oʼch notas: Eʼñe senamueñot̃, Yomporñapaʼ apaschaʼ. Seʼnameʼteñot̃paʼ señchchaʼ, sec̈horeʼteñot̃, Yomporñapaʼ eʼñe pueʼm̃ñoteñot̃espaʼ eʼñech cohuen toram̃p̃sapas. ");
INSERT INTO ameNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","T̃arroʼmar ñeñt̃ es enamareʼtetspaʼ ñetña es aguëtset; ñam̃a erraʼtsen ñeñt̃ es eʼnyetspaʼ ñetñapaʼ enteretchaʼ, ñam̃a erraʼtsen ñeñt̃ c̈horeʼtyeneʼ ñetñapaʼ eʼñech eʼm̃ñotenanet Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","13","’Yompor ñeñt̃ pueʼntañoʼtsen c̈hocmach eʼñe cohuenareʼ es apaʼyeney ñerraʼm esempo es yenamueñ. Ñapaʼ amach aña apuenye ñeñt̃ ama cohuenayeʼ yenteno ya. Amaʼt sa ñeñt̃es arromñat̃es atet̃ sepeñ sam̃a sechemer, eʼñech cohuen es sapueñ ñerraʼm esempo es enamuenes. Atet̃ ñerraʼm allempo paʼchporrñot̃ es enamuenes, oʼch enamas mam ñeñt̃chaʼ rraʼ, sapaʼ amaʼt puesheñarrot̃esapaʼ amach aña sapueñeña sechemer mapueʼ ñeñt̃ ama arrapahuoyaye. Amapaʼ ñerraʼm cac enamuenes sañapaʼ amaʼt puesheñarrot̃esapaʼ ama aña sapueñeña sechemer shechep̃ ñeñt̃ atarr amueroc̈htatañ. Amapaʼ ñerraʼm paʼmeʼ enamuenes sañapaʼ amaʼt puesheñarrot̃esapaʼ ama aña sapueñeña sechemer yellas. Ñeñt̃oʼmarña sa amaʼt arromñat̃es amaʼt ñam̃a atsrreʼmñat̃es sapaʼ eʼñe señoteñ apaʼyeseʼ sechemereshaʼ eʼñe cohuenareʼ. Añña ñeñt̃ Seyomporer sepen sam̃a ñeñt̃ pueʼntañoʼtsen elloña ñapaʼ eʼñe eñoteñ att̃o eʼñe cohuenareʼ es apaʼyenes sam̃a. Amaʼt Puecamquëñ ñeñt̃ eʼñe cohuen Parets att̃oña eʼñe cohuen chorratensa allohuenes ñeñt̃es enamyeneʼ ña. ");
INSERT INTO ameNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Poʼpocheño alloʼtsen puesheñarr acheñ ñeñt̃ chorrena oneñet̃, c̈ha opanatateñ. Allempoña Jesúspaʼ cac̈hpatosan oneñet̃ att̃o chorrenana acheñ. Att̃o cac̈hpaʼner oneñet̃ ñeñt̃ña opanpaʼ oʼ alla eñorerra. Acheñeneshaʼña allpaʼ att̃a cohuanrrorteñet, atarr cohuen enteñet. ");
INSERT INTO ameNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","T̃arraña poʼpotantañec̈hnoña acheñeneshaʼpaʼ amaʼt mameshapaʼ ama pocteyeʼ eñcheto. Ñetñapaʼ atet̃ otyeñet: —Att̃o cac̈hpatatenan oneñet̃ acheñpaʼ añacaʼye ahuamencat̃ peneʼ Beelzebú ñeñt̃ pompor pen allohuen oneñet̃ec̈hno. ");
INSERT INTO ameNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Poʼpotantañ acheñeneshaʼ ñetñapaʼ c̈ha mueneñet oʼch topachet Jesús. Ñetpaʼ atet̃ ochet: —Yapaʼ añ yemnen oʼch pegatey pepartsoña entot̃ allochñapaʼ att̃och yeñotap̃ poʼñoc̈h p̃apaʼ Parets Puechemerep̃. ");
INSERT INTO ameNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesúsñapaʼ eñotanet ñeñt̃ atet̃ cot̃apeʼchatseʼtyenet pueyoc̈hreto ñocop ñeñt̃ att̃o otyeñet ñapaʼ oneñet̃a pompor poʼhuamencot̃ cac̈hpatenanetña oneñet̃ec̈hno. Ñeñt̃oʼmarña ñapaʼ atet̃ otanet: —Ñerraʼm puesheñarr am̃chaʼtaret̃ elloptannena paʼcheñer eʼñe ñagattsetapaʼ eʼñech poctacma aʼcllatannaʼtuerret. Att̃ecmach p̃annerra amaʼt ñeñt̃ eʼñe pamoʼtsnaʼtarecmuet ñerraʼm elloptannerret eʼñe ñagattsetpaʼ eʼñech aʼcllatannaʼtuerret. ");
INSERT INTO ameNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Att̃ecmach p̃annerra ñam̃a oneñet̃ pueyochreshac̈hno ñerraʼm oneñet̃ec̈hno eʼmoñeʼtannenet eʼñe ñagattseta, ñetña att̃o huomencatenetpaʼ c̈hach huañerrets amach alloʼna huomencatneneto. Ñeñt̃paʼ atet̃ oʼ notuas t̃arroʼmar sapaʼ c̈ha sotenen napaʼ Beelzeboʼ poʼhuamencot̃ necac̈hpatateññañ eʼñe ña pueyochreshaʼ ñeñt̃ pompor pen allohuen oneñet̃ec̈hno. Poʼñoc̈h oneñet̃paʼ amacaʼye huaporeʼtanneno. ");
INSERT INTO ameNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Sapaʼ atet̃ sotenen napaʼ Beelzeboʼ poʼhuamencot̃ necac̈hpatateññañ eʼñe ña pueyochreshaʼ, ñehua, t̃eʼpaʼ oʼch notas: Ñeñt̃ seyochreshaʼ sepen sa ñeñt̃ eñoteneʼ ñamet oʼch cac̈hpatachet oneñet̃ acheñeneshaʼ ñetpaʼc̈hoʼña amaña Beezebú poʼhuamencot̃eyeʼ cac̈hpatateñetoña oneñet̃ acheñeneshaʼ. Ñetpaʼc̈hoʼña Yomporoña poʼhuamencot̃ cac̈hpatatenetña oneñet̃. Ñeñt̃ña oʼ eñotatas ñeñt̃ atet̃ sotennoñ ñeñt̃paʼ amacaʼye poʼñoc̈h att̃eyaye. ");
INSERT INTO ameNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Poʼñoc̈hcaʼye Yompor poʼhuamencot̃ necac̈hpatateñña oneñet̃ec̈hno acheñeneshaʼ ñeñt̃chaʼña señotateʼ t̃eʼpaʼ oʼ nec̈hapatonas Yompor poʼcohuenña ñeñt̃ att̃o poʼñoc̈h atarr ayochreshat̃tena ña. ");
INSERT INTO ameNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Ñeñt̃paʼ oʼ eʼñe notuas atet̃ t̃arroʼmar yeñoteñ ñeñt̃ atarr ahuamencat̃tetsa att̃o atarr ahuamencat̃tena oneñet̃, ñañapaʼ eʼñe poʼhuamencot̃ cohuam̃pesyenan allohuen eʼñe cohuen ñeñt̃ paʼpaquëll p̃aʼyen. Ñapaʼ poʼhuamencocmañen naʼyenan ñeñt̃chaʼ eʼñe cohuam̃peneʼ all am̃chaʼtaret̃tena ña. ");
INSERT INTO ameNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","T̃arraña ñerraʼm esempo oʼch huapoña ñeñt̃ atarr ahuamencat̃eshaʼ ñeñt̃chaʼ ello metanoseʼña poʼhuamenc atet̃ ñerraʼm na Nompor, ñeñt̃chaʼña eʼñe aʼmchechatoseʼ. Att̃oña eʼñe puerratam̃p̃sosñañ ñeñt̃ allpon moñenaya ñeñt̃ atarr yemuetyena ña. Allochñapaʼ oʼch beʼt̃osos all ñeñt̃ paʼpaquëll p̃aʼyen oʼch eʼñe puerratam̃peshuos ñeñt̃ allpon oʼpatyena ña. ");
INSERT INTO ameNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Ñeñt̃oʼmarña t̃eʼpaʼ oʼch notas allohuenes: Ñerraʼm eseshas ñeñt̃es ama net̃orrapretenaye ñeñt̃ña acheñerpaʼ c̈hacaʼye epatareʼtennan ñeñt̃ atet̃ net̃orraʼyena na. Ñeñt̃paʼ oʼch netmaʼntatasa atet̃: Ñerraʼm eseshaʼ ama naʼyapac̈hapretenaye ñeñt̃ naʼyapac̈hen na, ñeñt̃ñapaʼ c̈ha aʼparratseʼtam̃penen aʼyenet̃. ");
INSERT INTO ameNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Ellonet̃paʼ oʼch alla neñotaterrserr poʼpoñonet̃: Oneñet̃ ñerraʼm esempo c̈haʼnom acheñeshot̃, ñeñt̃ña oneñet̃paʼ oʼch auyes errap̃aren amaʼt amayoʼmar eʼnyeseʼ poʼpsheñeñ allchaʼ yec̈herrerr allchaʼ eʼñe amesuerrerr cohuen. T̃arraña ñerraʼm amach erra eñchepaʼ att̃eñapaʼ oʼch ot: “Napaʼ oʼch alla ahuerren nepacllo allot̃ nec̈haʼnom ahuaña.” ");
INSERT INTO ameNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Atet̃chaʼc̈hoʼ p̃a. Oʼch alla ahuerr allot̃ c̈haʼnom ahuaña. Allña oʼch c̈herrpaʼ eʼñech cohuen entuerran paʼpaquëll, eʼñech cohuen atarrapoʼtuaret̃, eʼñech cohuen aññoʼtyesaret̃. ");
INSERT INTO ameNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Allempoñapaʼ oʼch alla ahuerr alloʼtsaʼyen pamoʼtseshaʼpaʼ oʼch enanaʼ poʼpoñ canc̈herrsheña oneñet̃ec̈hno ñeñt̃ nanac sosyareʼ, ñeñt̃ ello metanaʼtueneʼ ñeñt̃ atet̃ sosyaten ñeñt̃ huaʼñeneʼ oʼch yec̈haprecha. Allohuenetñapaʼ oʼch chorreñet ñeñt̃ acheñer. Allempoña tsapat̃onet̃paʼ alloʼnach sen ñeñt̃ acheñer sosyatnomuets huomenc. Elloch metanerran ñeñt̃ atet̃ p̃atseʼtyeseʼt̃ ñenmat̃. ");
INSERT INTO ameNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús allempo atet̃ serrpareʼtatenan acheñeneshaʼpaʼ puesheñarrña coyaneshaʼpaʼ machayot̃epaʼtchaʼ rrana, ñeñt̃paʼ atet̃ ot: —Amaʼt ñeñt̃ p̃achor pepen p̃apaʼ atarr cosheñtsoʼtsen t̃arroʼmar ñapaʼ ñeñt̃ peʼñalletateʼ p̃a ñeñt̃ep̃ atarr cohuen es peyec̈hcaten ñam̃a ñapaʼ eʼñe cohuen cohuam̃p̃sap̃ allempo cheshat̃ollenp̃aʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesúsñapaʼ atet̃ och: —Elloña allohuenetpaʼ atarr cosheñtsoʼtsaʼyenet ñeñt̃ pueʼm̃ñoteñot̃et Yompor poʼñoñ eʼñe atet̃ p̃ohuenet. ");
INSERT INTO ameNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Allempoña acheñeneshaʼ emchorreñet Jesús, ñañapaʼ atet̃ otanet: —Acheñeneshaʼ ñeñt̃ corraʼyetsa t̃eʼ ñetñapaʼ ama cohuenayeʼ cot̃apeʼchyeneto. T̃arroʼmar ñetpaʼ aña eʼnenet ahuoʼch norrtatanet nepartsoteña att̃oʼchña eñotnet napaʼ poʼñoc̈hoʼt̃eʼ Parets Puechemeren ñeñt̃enoʼt̃eʼ Cristotosets. T̃arraña amach es norrtataneto. Napaʼ añach pat̃err neñotatanet atet̃ eñotataneʼt̃ Jonás ahuat̃ nínivoʼmarneshaʼ allempo aʼm̃taneʼt̃ Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","T̃arroʼmar att̃o eñotataneʼt̃ Jonás nínivoʼmarneshaʼ ahuat̃ ñapaʼ Yomporeshot̃ huena, napaʼc̈hoʼña t̃eʼpaʼ atet̃chaʼ neñotach nam̃a acheñeneshaʼ ñeñt̃ corretsa t̃eʼ napaʼc̈hoʼña Yomporeshot̃ nohuena. ");
INSERT INTO ameNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","T̃arroʼmar ahuat̃ allempo serrpareʼtataneʼt̃ Jonás nínivoʼmarneshaʼ ñetñapaʼ allempocma cot̃apeʼcherret ello eʼñe cohuen Yomporecop. T̃eʼña arr seshopaʼ alloʼtsenen na ñeñt̃en ello metaneneʼ ñeñt̃ atet̃ serrpareʼtateʼt̃ Jonás. T̃arraña sañapaʼ amaña soct̃apeʼchenoña ello cohuen Yomporecop. Ñeñt̃oʼmarña esempohuañen allempoch aʼcraret̃etuerra allohuen acheñeneshaʼ, ñeñt̃ña nínivoʼmarneshaʼ ñeñt̃ eʼñe cohuen cot̃apeʼcherrets Yomporecop ahuat̃, ñetpaʼc̈hoʼña orrterretchaʼ, ñeñt̃chaʼña señotaterreʼña sapaʼ amaʼt mamesha ama pocteyayeña ñeñt̃ atet̃ sep̃aʼyeseʼt̃ t̃arroʼmar sapaʼ ama soct̃apeʼcherro ello cohuen Yomporecop. Ñam̃a t̃eʼpaʼ oʼch neyerpatasa ñeñt̃ atet̃ p̃a ahuat̃ puesheñarr coyaneshaʼ ñeñt̃ am̃chaʼtaret̃tatseʼt̃ atarr b̃ac̈hayo allohuanen pats saʼponet̃. Ñeñt̃ña coyaneshaʼpaʼ allot̃eñ on oʼch eʼm̃ñotenanaʼ Salomón pueserrpareñ ñeñt̃ atet̃ atarr eñotañteʼt̃. T̃eʼña arr eʼñe seshopaʼ alloʼtsenen ñeñt̃en puesheñarrana ñeñt̃en atarr es neñoten nam̃a, ello nem̃taneñ att̃o eñotañteʼt̃ Salomón. T̃arraña sañapaʼ amaña es sotapoteno. Ñeñt̃oʼmarña esempohuañen allempoch aʼcraret̃etuerra allohuen acheñeneshaʼ, ñeñt̃ña coyaneshaʼ ñeñt̃ eʼñe cohuen eʼm̃ñotatseʼt̃ ñapaʼc̈hoʼña orrterrach, ñeñt̃chaʼña señotaterreʼ sapaʼ ama pocteyayeña ñeñt̃ atet̃ sep̃aʼyeseʼt̃ t̃arroʼmar sapaʼ ama es sotapoteʼt̃e amaʼt eʼñe mamesha. ");
INSERT INTO ameNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesúspaʼ alla serrpareʼtaterraneterr, ñeñt̃paʼ atet̃ oterraneterr: —Ñerraʼm esempo yaʼllchaten lampareñ, ñeñt̃paʼ ama t̃arrecpayeʼ yaʼhuortateñe oʼch yeneʼ oʼpono eʼñe aʼnaret̃o. Ñam̃a ama añecpayeʼ yaʼllchateñe oʼch yeʼrramam̃pes coym̃o. Ñeñt̃paʼ añecopña yaʼhuortatenña lampareñ oʼch yeneʼ enonet̃ att̃ochña eʼñech c̈hoyoʼtam̃pesuan allohuen acheñeneshaʼ ñeñt̃ beʼt̃osc̈hets all pocollo. ");
INSERT INTO ameNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","35","Yeclleʼpaʼ añ tomaʼntena atet̃ ñerraʼm ñeñt̃ poʼlampareñ pen allohuen yechets. Ñerraʼm eʼñe cohuen huomech yeclleʼpaʼ eʼñech cohuen entateney puetareʼ allochñapaʼ att̃och eʼñe cohuen t̃orratyenana allemeñ yechets t̃arroʼmar eʼñe cohuen aʼpuetarsam̃p̃saret̃tenet. T̃arraña yeclleʼña ñerraʼm ama eʼñe cohuen huom̃cheyayepaʼ amach eʼñe cohuenayeʼ entatenye puetareʼ att̃ochña amach eshcayeʼ t̃orratyenano allemeñ yechets t̃arroʼmar c̈ha ottena ñerraʼmrrat̃eʼ checmetoʼtsaʼyeneta. Att̃ecma pena ñam̃a yeyoc̈her. Ñerraʼm eʼñe cohuen yoct̃apeʼchyen yeyoc̈hropaʼ att̃oña c̈hennayaña yeyoc̈hro eʼñe ora allohuen Yompor poct̃ap̃ña ñeñt̃ poʼcohuenña pen. Att̃oña ora yoct̃ap̃ñapaʼ eʼñech aʼpuetarsam̃p̃saret̃tena Yomporeshot̃. T̃arraña oʼch yeñota eʼñe yañeña t̃arroʼmar ñerraʼm ama cohuenayeʼ yoct̃apeʼcheno yeyoc̈hro, ñeñt̃paʼ amach errot̃enot̃ aʼpuetarsam̃penyeña ñeñt̃ yoct̃ap̃ña yepen. Ñeñt̃ña yoct̃ap̃ña yepenpaʼ c̈hach aʼchecmetam̃pennay yeyoc̈her. ");
INSERT INTO ameNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","T̃arraña ñerraʼm poʼñoc̈h eʼñe cohuen yoct̃apeʼchen yeyoc̈hro, att̃oña c̈hennayaña yeyoc̈hro eʼñe ora allohuen Yompor poct̃ap̃ña att̃ochña yeñoteñ orrtatyeseʼ ñeñt̃ eʼñe cohuen enten ña. Att̃oña eʼñech cohuen es yep̃aʼyen atet̃ ñerraʼmrrat̃eʼ lampareñ eʼñe cohuen c̈hoyoʼtam̃peney att̃och eʼñe cohuen es yentyen. Allempopaʼ oʼhuañchaʼ alloʼna yechecmetam̃pesnen. ");
INSERT INTO ameNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Oʼ serrpareʼtatuanet Jesúspaʼ puesheñarrña fariseoneshaʼpaʼ huaʼñaʼnerran Jesús oʼch rrallmeʼchapreteñaʼ paʼpacllo. Allempo c̈hap Jesús allpaʼ beʼt̃osos anorros allchaʼ rrallmeʼchapretosan ñeñt̃ huaʼñeneʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ñeñt̃ña fariseopaʼ entenan Jesús att̃o ñapaʼ ama eʼpotaʼto ñeñt̃ atet̃ yec̈hena judioneshaʼ. Ñehua, ñetpaʼ atet̃ yec̈henet, amach rrallmeʼchenetaʼpaʼ oʼch eʼpotaʼtyeset Partsocop. Ñeñt̃oʼmarña fariseopaʼ atet̃ cot̃apeʼch Jesúsocop: —Taʼm, esoʼmart̃eʼcaʼye amaña eʼpotaʼtenoña ñeñt̃ atet̃ poctetsa Partsocop. ");
INSERT INTO ameNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Partseshaʼña Jesúspaʼ atet̃ tomaʼntatana ñeñt̃ atet̃ pena allohuen fariseoneshaʼ, ñeñt̃paʼ atet̃ otan ñeñt̃ huaʼñeneʼ: —Ñeñt̃es fariseoneshas sapaʼ eʼñe seʼpameʼteneñña setaza enot̃paʼ oʼponot̃ñapaʼ ama seʼparroʼteñe. Seplatopaʼc̈hoʼña enot̃a eʼñe seʼpataʼteñ oʼponot̃ñapaʼ ama seʼpataʼteñe. Eʼñe atet̃ sepena sam̃a. Eʼñe saʼcohuentatena ñeñt̃ enoʼmar ñeñt̃ atet̃ seyc̈hena sa allochñapaʼ att̃och entenes allohuen acheñeneshaʼ sapaʼ eʼñoʼ cohuenes, t̃arraña oʼponot̃ seyoc̈hropaʼ ama saʼcohuentateñe, allñapaʼ eʼñe chorren shonteʼ sosyaʼtsañec̈hno ñeñt̃ att̃o eʼñe seshquëñot̃ c̈hocma es seprratam̃pesyen, seshonten paʼnamen ñeñt̃ ama pocteyeʼ entapretenso Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","C̈ha sottena ñerraʼm erraʼtsen puesheñarr acheñ ñeñt̃ ama es eñoteno. Amaʼt señoteñeña Yomporña ñeñt̃ yec̈hcatyeneʼ allohuen ñeñt̃ allpon yentyen arr patsro, ñeñt̃ aʼyot̃eʼtsaʼyen yeshot̃ ñeñt̃ara Yompor ñeñt̃ yec̈hcateʼ ñam̃a yeyoc̈her alloch eʼñe cohuen yoct̃apeʼchen oʼpono yeyoc̈hro. ");
INSERT INTO ameNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ñerraʼm oʼch poʼñoc̈h soct̃apeʼcherr cohuen seyoc̈hro Yomporecop att̃ochña eʼñe cohuen seyoc̈hrocmañen es sapaʼyen att̃och seyenpaʼyeñ poʼpotantañ. Ñerraʼm atet̃chaʼ seperrapaʼ Yomporñapaʼ eʼñech cohuenareʼ enterres. ");
INSERT INTO ameNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Atarr llequëñtsoʼtsenes sa ñeñt̃es fariseoneshas t̃arroʼmar ama att̃eyeʼ sepeno ñeñt̃ atet̃ oʼ notuas. Ora allohuen ñeñt̃ senarem̃ sepen amaʼt c̈hocma sapueñeñ Yompor allpon ñeñt̃ poctetsa ñocop—mentapan ñam̃a rudapan. T̃arraña añña ñeñt̃ nanac sherbets Yomporecop eʼñech pocteʼ es yepeññañ poʼpsheñeñ ñam̃a eʼñech cohuen yemorrenteña Yompor. Ñeñt̃ atet̃paʼ sañapaʼ ama soct̃apeʼcheñe amaʼt mamesha. Sapaʼ ñeñt̃ña sepalltena oʼch eʼñe atet̃ sep̃ohua. T̃arraña ñeñt̃ att̃o c̈hocma es sapaʼyen Yomporecop ñeñt̃paʼc̈hoʼña amach secac̈hpatsche. ");
INSERT INTO ameNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Atarr llequëñtsoʼtsaʼyenes sa ñeñt̃es fariseoneshas t̃arroʼmar sapaʼ eʼñe sommoʼcheñot̃ atarr semneñ allohuen acheñeneshaʼpaʼ oʼch eʼñe cohuen entenset. Ñeñt̃oʼmarña sapaʼ aña atarr semnen oʼch sanorrc̈haʼtyen judioneshaʼ poʼprahuo allecma anorryen ñeñt̃ atarr am̃chaʼnaʼtpoʼ enten allohuen acheñeneshaʼ. Ñam̃a sapaʼ aña atarr semnen allohuen acheñeneshaʼpaʼ oʼch huom̃chaʼtenset puem̃chaʼnañot̃ ñerraʼm esempo sechopeñeʼchen t̃oñoʼmar allecma chopeñeʼchyen allohuen acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Atarr llequëñets socop, t̃arroʼmar sapaʼ eʼñe att̃es ñerraʼmrrat̃eʼ apampaña ñeñt̃ amach orrteno enot̃ all apamparet̃tena arromñat̃ oʼpono patso. Ñeñt̃oʼmarña acheñeneshaʼpaʼ allach chopeñeʼchyenet all ama eseshaʼ eñotenaye oʼponopaʼ alloʼtsaʼyen arromñat̃ap all eʼñe chorren sosyaʼtsañ. ");
INSERT INTO ameNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Allempoña puesheñarr ñeñt̃ atarr etsotenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop, ñañapaʼ atet̃ otan Jesús: —Maestro, ñeñt̃ atet̃ p̃oten yaʼnaña c̈ha mueneʼ pepencaten. ");
INSERT INTO ameNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesúsñapaʼ atet̃ och: —Sapaʼ ñeñt̃es atarr etsotenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop, sapaʼc̈hoʼña atarr llequëñets socop, t̃arroʼmar sapaʼ atarr es senaʼyeññañ acheñeneshaʼ ñeñt̃ atarr echarrareʼ entyenet ñet, poʼñoc̈hpaʼ amach errot̃enot̃ eʼñe atet̃ p̃ohueto. Sapaʼ amaʼt mameshapaʼ ama ayenpuenayeʼ sentpenaneto. ");
INSERT INTO ameNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Llequëñtsa ñam̃a socop t̃arroʼmar sa t̃eʼpaʼ sat̃omaten enot̃ ñeñt̃ atarr cohuen senten sa all pampaʼyeseteʼt̃ ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ ahuat̃ ñeñt̃ muetsanatyeseʼt̃ ñeñt̃ satañneshañ sepeʼt̃. ");
INSERT INTO ameNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sapaʼ eʼñe señoteññañ saʼtañneshañ att̃o ñetpaʼ muetsanacheteʼt̃ ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ t̃arraña sapaʼc̈hoʼña ñeñt̃aña eʼñe pocteʼ senten sam̃a ñeñt̃oʼmar t̃eʼpaʼ eʼñe saʼcohuentam̃penanet all apamparet̃tenet. ");
INSERT INTO ameNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Amaʼt Yompor ahuat̃, eʼñe pueñoteñot̃paʼ atet̃ oteʼt̃: “Napaʼ oʼch nemñe acheñeneshesho ñeñt̃chaʼ aʼm̃teneʼ neñoñ ñam̃a ñeñt̃ nellsensarneshaʼ nep̃aʼyen. T̃arraña patantarrña acheñeneshaʼñapaʼ c̈ha muetsanatanet, poʼpotantaññapaʼ c̈ha cot̃areʼtyeset.” ");
INSERT INTO ameNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Att̃oña eʼñe allempot̃eñ ayec̈hcataret̃ta añ pats, ora allohuen ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ allpon ñeñt̃ amtsanatyesaret̃tatseʼt̃ ashataret̃etyeseteʼt̃ poʼrras, sañapaʼ allempot̃eñ eʼñe saʼyohuaret̃tena t̃emeʼttsen sa ñeñt̃es corretsa t̃eʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Eʼñe allempot̃eñ muetseret Abel t̃arrempohua allempo muetseret ñam̃a Zacarías ñeñt̃paʼ alla semtser Parets poʼponro puechaʼpetarot̃ alloʼtsen altar allot̃ecma sherbeteʼt̃ Yompor. Poʼñoc̈hcaʼye notenes añeneshaʼ ñeñt̃ corretsa t̃eʼ atarr ayohuaret̃tenet. ");
INSERT INTO ameNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Llequëñtsa socop ñeñt̃eschaʼ eʼñe etsotenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop t̃arroʼmar sapaʼ c̈ha seprratam̃peñ acheñeneshaʼ ñeñt̃ alloch enteret ñeñt̃ eʼñe poʼñoc̈h alloch queshperret. T̃arroʼmar amaʼt sapaʼ amacaʼye senteññañeña Yompor poʼcohuenña, ellonet̃paʼc̈hoʼña c̈hocma sepatareʼteñña poʼpotantañ ñeñt̃ eʼneneʼ Yompor poʼcohuenña. ");
INSERT INTO ameNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Allempoña ñetpaʼ eʼñe paʼtsrreʼmueñot̃ atarr es aʼp̃t̃oʼtareʼtyeset Jesús. ");
INSERT INTO ameNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ñetpaʼ añ atarr eʼnenet att̃och otatseʼtachet allochñapaʼ ñatoʼ poʼtatseʼtateñot̃etpaʼ att̃och otteñeʼcheñet. ");
INSERT INTO ameNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Shonteʼ acheñeneshaʼ ñeñt̃ huac̈henoya Jesús, shonteʼ nanac patoner. C̈ha cheʼmuechoset Jesúsesho att̃a at̃matcaʼtannaʼtyesoset. Jesúsña ñanompaʼ alla serrpareʼtaterranerr pueyochreshaʼ, ñeñt̃paʼ atet̃ otanet: —Eʼñech señota ñatoʼt semeñeʼteñaʼ fariseoneshaʼ poct̃ap̃ña, t̃arraña ñeñt̃ poct̃ap̃ña penet ñetpaʼ ñeñt̃paʼ ommoʼcheñtsa. Ñeñt̃paʼ mamet̃ollapaʼ oʼch epaʼhua errap̃aren eʼñe atet̃ pena ñerraʼmrrat̃eʼ chaseʼ mamet̃ollapaʼ oʼch eʼñe es aʼchasaʼhua. ");
INSERT INTO ameNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","T̃arroʼmar yapaʼ yeñoteñ allohuen ñeñt̃ allo eʼñe aʼnahua shecareʼtyenet t̃eʼ esempohuañenñapaʼ aʼmet̃am̃p̃saret̃terretchaʼ. Amaʼt allohuen ñeñt̃ eʼñe aʼnasotyenet t̃eʼpaʼ esempohuañenñapaʼ eʼñech eñotataret̃etuerret. ");
INSERT INTO ameNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ñeñt̃oʼmarña amaʼt erraʼtsena seserrparen eʼñe aʼnahua t̃eʼ esempopaʼ señotatuerchaʼ ora allohuen acheñeneshaʼ. Amaʼt erraʼtsena ñeñt̃ atet̃ seserrpareʼtyen t̃eʼ eʼñe aʼnahua oʼpono pocollo, esempopaʼ seserrpareʼtatchaʼ allchaʼ eʼñe cohuen eʼmhuerres allohuen acheñeneshaʼ atet̃ ñerraʼmrrat̃eʼ enot̃ seserrpareʼten shelletot̃. ");
INSERT INTO ameNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","T̃eʼpaʼ oʼch notas masheñneshachaʼ, amach aña sem̃chaʼtatsto ñeñt̃chaʼ semtseʼ. T̃arroʼmar añach muetsonaset sechets, secamquëññapaʼ amach errot̃enot̃ muetsonaseto. ");
INSERT INTO ameNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Añchaʼña sem̃chaʼnaʼt Yompor t̃arroʼmar ñerraʼm ña muenats eʼñe ña poʼhuamencot̃paʼ oʼch aʼchencatonay yeʼchets, yecamquëñpaʼc̈hoʼña oʼch mueñonay coñcheñtso all parraren tsoʼ. Eʼñe poʼñoc̈h notenes, Yomporchaʼña sem̃chaʼnaʼten. ");
INSERT INTO ameNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","Elloña t̃eʼpaʼ napaʼ oʼch notas, c̈hocmach seyemcha Yompor, poʼñoc̈h ñapaʼ ñach secuam̃peneʼ. Amaʼt ot̃et̃olleshaʼpaʼc̈hoʼña c̈hocma cohuam̃peñ. Ñehua, amaʼt yapaʼ yeñoteñ ot̃et̃ollpaʼ ama tama sherbeno. Amaʼt yepomatset, amnar ot̃et̃olleshaʼpaʼ ñeñt̃paʼ ama tsaʼteyaye, eʼñe eptallat̃olla centavo tsaʼtena. T̃arraña amaʼt att̃eñ Yomporña amaʼt pat̃rra ot̃et̃ollpaʼ ama pueseñe. Ñeñt̃oʼmarña notenes, amaʼt mameshapaʼ amach sem̃chaʼtatsto, Yomporchaʼña eʼñe seyemta. Att̃o atarr morrentenana ot̃et̃olleshaʼ elloña sapaʼ atarr nanac morrentensa. Ñehua, amaʼt allpon sechet̃olleshaʼ allpon soñoʼtsen ñapaʼ eʼñe eñotennas. ");
INSERT INTO ameNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Elloña napaʼ oʼch noterrserr, allohuen amaʼt erraʼtsenchaʼ ñeñt̃chaʼ ama naʼnasotenaye acheñeneshesho, napaʼc̈hoʼña Ñeñt̃en Acheñetosetspaʼ amach naʼnasotuerraneto nam̃a Nomporesho alloʼtsaʼyen epuet poʼm̃llañot̃eñnaneshar. ");
INSERT INTO ameNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","T̃arraña ñerraʼm eseshaʼ naʼnasotenaya na arr patsro acheñeneshesho, napaʼc̈hoʼña naʼnasoterranetchaʼ Nomporesho alloʼtsaʼyen epuet poʼm̃llañot̃eñnaneshar. ");
INSERT INTO ameNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Ñerraʼm eseshaʼ nesaseneʼ na Ñeñt̃en Acheñetsosets ñeñt̃paʼ ap̃retnaʼpoʼ nenteñ. T̃arraña ñerraʼm eseshaʼ añ achm̃areʼtenet Parets Puecamquëñ ñeñt̃ñapaʼ ama ap̃retnaʼpahuoyeʼ nenteñe. ");
INSERT INTO ameNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ñam̃a oʼch noterrserr, ñerraʼm esempoch anmaset judioneshaʼ poʼprahuo allchaʼ aʼmet̃areʼtam̃p̃saset am̃chaʼtaret̃esho, sañapaʼ amach c̈ha sellcaʼp̃satsto, amach c̈ha sotap̃saʼtatsto: Errot̃uachcaʼye notost̃eʼ att̃och cohuen nanapos, esuachcaʼye nott̃eʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sapaʼ añchaʼña seʼñoratoseʼ Parets Puecamquëñ eʼñe allempo aʼp̃t̃oʼtareʼtenset all. ");
INSERT INTO ameNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","All cheʼmuechen shonteʼ acheñeneshaʼ Jesúsesho, puesheñarrñapaʼ atet̃ otan Jesús: —Maestro, t̃eʼpaʼ oʼch p̃oton nemoʼnasheñ nepoʼnar apuerrnepaʼñacaʼyeña nam̃a ñeñt̃ allpon oʼpatatnomna nomporeñ. ");
INSERT INTO ameNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","T̃arraña Jesúsñapaʼ atet̃ och: —Masheñchaʼ napaʼ ama eseshayeʼ nenaye ñeñt̃enchaʼ aʼpoctateneʼ ñoñets att̃och soten oʼch napaʼyesas allpon oʼpatatyenset. ");
INSERT INTO ameNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Alla oterraneterr Jesús: —Eʼñech señota sañeña, amaʼt seyoc̈hrapaʼ amach es seyeʼchapretannaʼtatsto amaʼt eʼñe coñeʼt̃a t̃arroʼmar att̃o yocrrena arr cohuen añe patsropaʼ ñeñt̃paʼ ama añecpayaye alloch esocmañen es yechyerr ñeñt̃chaʼ atarr yocshaterreʼ tsapat̃onet̃. ");
INSERT INTO ameNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ñeñt̃paʼ atet̃ otanet tomaʼnteñtso: —Eñall puesheñarr acheñ atarr nanac ec̃llayoret̃. Allña poʼpatsñopaʼ shonteʼ nanac aton aʼyec̈hcaten. ");
INSERT INTO ameNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ñeñt̃ña ec̃llayoret̃paʼ atet̃ cot̃apeʼchen pueyoc̈hropaʼ atet̃ oten: “Errot̃uachcaʼye nep̃aʼña, ñeñt̃ atarr nanac aton net̃otaten amacaʼye eñalleña allchaʼ eʼñe naññoʼtue.” ");
INSERT INTO ameNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Allempo atet̃ cot̃apeʼchenpaʼ alla oterrerr: “T̃eʼpaʼ oʼcaʼ neñoch atet̃chaʼcaʼye nep̃a. Oʼchcaʼye naʼmaterrña pocollasheʼm allecma naññoʼteʼt̃ coñeʼt̃aʼtets t̃eʼñapaʼ oʼch alla nat̃omaterr atarrpoʼ allchaʼ eʼñe naññoʼtua allohuen ñeñt̃ allpon net̃otaten amaʼt ñam̃a allohuen ñeñt̃ allpon paʼnamen esocmañen nechyen. ");
INSERT INTO ameNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Allempoñapaʼ atet̃chaʼ not neyoc̈hro: Napaʼ ama es nepallteno amaʼt eʼñe mamesha. Ñeñt̃ allpon shonteʼ oʼ naññoʼtuapaʼ atarrchaʼ atomat char amach es nepallterreʼt̃e. T̃eʼpaʼ oʼch names eʼñe poctacma. Nellapeneʼt̃chaʼ rrats, nellapeneʼt̃chaʼ orrareʼtats; ñeñt̃chaʼña eʼñe nocshateneʼña na.” ");
INSERT INTO ameNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","T̃arraña ñeñt̃ acheñerpaʼ Yomporpaʼ atet̃ och: “P̃apaʼ atarr otatsñat̃ep̃, ama es peñoteno amaʼt mamesha. T̃eʼpaʼ añe tsaprocmach oʼch perromuen. Ñeñt̃ña shonteʼ oʼ p̃aññoʼtuapaʼ t̃eʼñapaʼ eseshaʼhuachñacaʼye oʼpaterraya.” ");
INSERT INTO ameNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ñeñt̃oʼmar yeñoteñ, ñeñt̃ aññoʼteneʼ shonteʼ esocmañen ñeñt̃ eʼñe ñocpa, ñeñt̃ña acheñer atet̃paʼ ama echenanoña ñeñt̃ sherbets Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Allempoña Jesúspaʼ alla oterranerr pueyochreshaʼ: —Ñeñt̃oʼmarña t̃eʼpaʼ oʼch noterrserr, amach aña sellcatsto ñeñt̃ att̃o yeyc̈hena arr patsro. Amaʼt seyoc̈hra amach sotatsto, esuachcaʼye yerrerrerrt̃eʼ tsapat̃onet̃. Ñam̃a amach aña sellcatsto ñeñt̃ eʼñe sechtsocpa, amach sotatsto, esuachcaʼye yechorrat̃eʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","T̃arroʼmar Yomporpaʼ ña yapueneʼ yoʼrrerrña allo yocrrena ñeñt̃ña atarr nanac sherbets. Ñeñt̃oʼmarña yeñoteñ ña yapueneʼ ñam̃a yerrar, ñeñt̃ña ñocoppaʼ ama esoyeʼ enteñe. Ñam̃a ña yec̈hcateneʼ yechets ñeñt̃ atarr sherbets. Ñeñt̃oʼmarña yeñoteñ ña yapueneʼ ñam̃a amaʼt ñeñt̃ yechorraʼyena, ñeñt̃ña ñocop ama esoyeʼ enteñe. ");
INSERT INTO ameNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Sentent̃eʼ att̃o correna paʼnamen ot̃neshac̈hno. Ñetpaʼ ama c̈hoyeʼ nareʼtatseʼteneto ñam̃a ama c̈hoyeʼ apc̈haʼyeneto puerrar ñeñt̃chaʼ rraʼyenet. Ñetpaʼ ama es echenaye allchaʼ es aññoʼtyenet. Amaʼt att̃o correnetpaʼ Yomporña eʼñe yec̈hcatyesuanet ñeñt̃chaʼ puerrar p̃aʼyenet. Elloña sa Yomporpaʼ atarr morrentensa sa; ello sem̃taneñ ñeñt̃ att̃o atarr morrentenana ot̃neshac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ñam̃a amach sellcatsto att̃och amach serromo, t̃arroʼmar amaʼt sellquënañ att̃och atarr atomat socrra arr patsro t̃arraña amaʼt eʼñe puesheñarrot̃esapaʼ amat̃eʼ errot̃enot̃ soʼchtatoña socrreña amaʼt eʼñe pamt̃arra. ");
INSERT INTO ameNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ñehua, att̃o amaʼt eʼñe sellquëñot̃a sa ama errot̃ es sepeno, ñeñt̃epñapaʼ amach paʼnamena es sellcaʼyesatsto t̃arroʼmar ñeñt̃paʼ eʼñech orrena es sellcaʼyena. ");
INSERT INTO ameNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Ñam̃a sentent̃eʼ atet̃ yec̈hquëna rorec̈hno. Ñetpaʼ ama c̈hoyeʼ taruasaʼyeneto amaʼt mamesha, ama c̈hoyeʼ taneneto ñeñt̃ chorraʼyenet att̃o eʼñe cohuen orretyenet. T̃arraña napaʼ oʼch notas, amaʼt am̃chaʼtaret̃ Salomón att̃o eʼñe aʼcohuentateʼt̃ ahuat̃, amaʼt ñapaʼ ama chorraneʼt̃eña ñeñt̃ atarr cohuen ñeñt̃ atet̃ atarr cohuentena ror. ");
INSERT INTO ameNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ñeñt̃ ror pueʼchorpaʼ ñeñt̃ara taʼteʼ ñeñt̃ chepyets allemeñ ñeñt̃ sentyen t̃eʼ t̃arraña ñeñt̃paʼ mamecpa. Amaʼt cohuen chepyeneñ t̃eʼpaʼ tsapat̃onet̃ñapaʼ oʼch et̃omam̃peretpaʼ eʼñech collaʼhuerra oʼhuañchaʼ cohuenta. Ñehua, Yompor att̃o cohuentatyenan amaʼt ñeñt̃ eʼñe mamecpa, elloña sapaʼ atarr chorratyensañ sam̃a; sañapaʼ esoʼmart̃eʼña amaña eʼñeyeʼ seyemteño. ");
INSERT INTO ameNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Amach eʼñe pat̃rra seʼneno ñeñt̃ att̃o serren ñam̃a ñeñt̃ att̃o es sorryen. Amach ñeñt̃aña eʼñe pat̃err sellcaʼyesatsto. ");
INSERT INTO ameNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","T̃arroʼmar allohuen acheñeneshaʼ arr patsro ñeñt̃ ama ameʼñaʼyetso, ñetpaʼ ñeñt̃aña eʼñe pat̃err eʼnenet. Ñehua, Somporña ñeñt̃ pueʼntañoʼtsen ñapaʼ eʼñe entuenes ñeñt̃ allpon paʼnamen sepalltaʼyena arr patsro. ");
INSERT INTO ameNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Sapaʼ añchaʼña eʼñe ñanom semaʼyoc̈hrena Yomporecop att̃och atarr ayochreshat̃terra ña allochñapaʼ ñachña sapaʼyeneʼ ñeñt̃ allpon sepalltaʼyena sam̃a. ");
INSERT INTO ameNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Amach neyochreneshac̈hnochaʼ es sellcatsto amaʼt ama atarr shonteyayso, Yomporña atarr cohuen secuam̃peneʼ atet̃ ñerraʼmrrat̃eʼ eʼñe poʼcarrneror penes. Eʼñe pocsheñeshot̃paʼ apaschaʼ att̃och eʼñe cohuen socshapreterrñaña poʼcohuenña att̃och atarr ayochreshat̃terra. ");
INSERT INTO ameNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","T̃eʼpaʼ oʼch sepomyen ñeñt̃ allpon sechyen allochñapaʼ oʼch sapaʼyes ñam̃a ñeñt̃ atarr es palltaʼyetsa. Ñerraʼm atet̃ sepena alloʼnach atarr aton seshontaʼnen ñeñt̃ eʼñe poʼñoc̈h atarr sherbets Yomporecop. Ñeñt̃paʼ ama att̃eyaye ñerraʼmrrat̃eʼ ñeñt̃ sec̃llayepoʼrer sepen arr patsro, ñeñt̃paʼ atarr am̃llashaʼtña. T̃arraña ñeñt̃ seshontaʼnen ñeñt̃ atarr sherbets ñeñt̃ ama ahuañaño, ñeñt̃paʼ arr seshonteñ Yompor pueʼntaño. Allña amaʼt eñet̃apaʼ amach c̈heno oʼch etatsreʼtas ñam̃a amaʼt pomp̃apaʼ amach eñalle ñeñt̃chaʼ rrerreʼ ñeñt̃ seshonten all. ");
INSERT INTO ameNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","T̃arroʼmar ñerraʼm all pueʼntaño seshontaʼnen ñeñt̃ atarr cohuen senten, yeñoteñ eʼñe ñeñt̃a pat̃err senen seyoc̈hro ñeñt̃ña atarr sherbets Yomporecop. T̃arraña arr patsro ñerraʼm aña seshontaʼnen ñeñt̃ atarr semorrentena, yeñoteñ eʼñe ñeñt̃a pat̃err senen seyoc̈hro ñeñt̃ñapaʼ ama es sherbenoña Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","T̃eʼpa oʼch notas poʼpoñ: C̈hocmuepaʼch señosereʼtna esempohuañenpaʼ oʼch alla nohuerra. Ñatoʼ oʼch netmaʼntatasa atet̃ ñerraʼmrrat̃eʼ puesheñarr yacma ñeñt̃ atarr ayochreshat̃. Ñapaʼ ahuoʼ allchaʼ rrallmeʼchapretenanaʼ pacma ñeñt̃ senaʼtetsa. Pueyochreshaʼñapaʼ alla cohuet paʼpacllo esempoch huerra. Allempoña ñetpaʼ aʼhuortatyeset poʼlampareñ allochñapaʼ att̃och ñerraʼm esempoch huerra ñeñt̃ pamoʼmteʼ penet ñerraʼm oʼch c̈horeʼtuenanetpaʼ ñetñapaʼ allorocmach toram̃p̃sapueñet att̃och sherb̃apueñet. ");
INSERT INTO ameNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Atarr cosheñtsoʼtsaʼyen pueyochreshaʼ ñerraʼm esempoch huerret pamoʼmteʼ allñapaʼ entuenanet c̈ho atarr eñoseʼrteñet. Poʼñoc̈hpaʼ napaʼ oʼch notas, ñachcaʼyeña sherb̃aʼhueneʼña ñeñt̃ pueyochreshaʼ pen ña. Oʼch chanaʼhuena ñam̃apaʼ oʼch anorrc̈haʼtatuenanet allchaʼ rrallmeʼchatuenanet. ");
INSERT INTO ameNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ñeñt̃paʼ atet̃chaʼ perranet amaʼt rroc̈h tsapopaʼ oʼch huenanet amapaʼ oʼch puetarenmochpaʼ oʼch huenanet. Ñeñt̃oʼmarña notenes, ñerraʼm alla entuenanet c̈ho atarr eñoseʼrteñet, ñeñt̃ña atarr eñoseʼretyenayapaʼ atarrchaʼ cosheñtsoʼtsaʼyenet. ");
INSERT INTO ameNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Eʼñech machayot̃a nohuerra atet̃ pena eñet̃ allempo att̃a es sepc̈haʼyena machayot̃ach huaponasa oʼch yoratsreʼtensaʼ. T̃arraña sa ñeñt̃es apacllat̃es ñerraʼm señoteñeñ eʼñech esempo huaponasa eñet̃ amach c̈ha semanrraʼteno att̃och amach semnacheña oʼch toram̃p̃sas sepacllo oʼch beʼt̃osam̃p̃sasa oʼch yoruennasaʼ ñeñt̃ allpon semorrentyena. ");
INSERT INTO ameNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ñeñt̃oʼmar notenes, sapaʼc̈hoʼña c̈hocmuepaʼchña señoseʼrtenna t̃arroʼmar ñerraʼm allempo att̃a es sepc̈haʼyenapaʼ allempochña nohuerra na Ñeñt̃en Acheñetosets. ");
INSERT INTO ameNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Allempoña Pedropaʼ atet̃ aʼp̃t̃oʼch: —Partseshachaʼ ñeñt̃ atet̃ petmaʼntatena t̃eʼ ñeñt̃paʼ ¿eseshacpaʼtña, ñatoʼ yocpat̃eʼ ñeñt̃ey peyochreshay pepeney amapaʼ ñatoʼ allohuenacpaʼnat̃eʼ? ");
INSERT INTO ameNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Partseshaʼñapaʼ alla tomaʼntaterraneterr poʼpoñonet̃, atet̃ oterraneterr: —Allohuenespaʼ atet̃chaʼ sep̃a eʼñe cohuen atet̃ ñerraʼmrrat̃eʼ puesheñarr yacma ñeñt̃ yechena ñeñt̃ pamoʼmteʼ pen all paʼpacllo. Ñeñt̃chaʼ poʼtaruas peneʼ c̈hocmach apaʼyesan allohuen poʼpotantañ pamoʼmteʼ paʼtaruasañer puerraret allpon ñeñt̃ poctetsa puesheñaʼttsocop. Ñapaʼ att̃ecmach pena c̈hocmach apuenanet ñerraʼm esempoch c̈herrerr allempo atet̃ anaret̃ ñocop oʼch alla apaʼyerraneterr poʼpocheño. Ñapaʼ c̈hocmach atet̃ pena amach cac̈hpuere t̃arroʼmar ñapaʼ eñoteñ att̃och eʼñe coshatenan pamoʼmteʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ñeñt̃ña ataruasañpaʼ atarrchaʼ coshatueñ pamoʼmteʼ; ñerraʼm esempoch huerrapaʼ alla entuenan paʼtaruasañer ama c̈ho cac̈hpuenano ñeñt̃ poʼtaruas apaʼnem̃ ahuañmoʼchot̃eñ. ");
INSERT INTO ameNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Poʼñoc̈h oʼch notas, atarrchaʼ coshatueñ. Añchaʼ coshaterreʼ oʼch nohuer pamoʼmteʼ am̃chaʼtaret̃ ñeñt̃chaʼ cohuam̃p̃sapreteʼ ñeñt̃ allpon echyen pamoʼmteʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","T̃arraña ñeñt̃ ataruasañer allempo ama huerraʼ pamoʼmteʼ ñerraʼm ñapaʼ att̃a oten pueyoc̈hro, namoʼmteʼpaʼ amach ahuen huerro, allempoña ñapaʼ c̈hach ashtapechyenan ataruasañec̈hno ñeñt̃chaʼ rratañ amaʼt ñam̃a coyaneshohuen. Ñañapaʼ att̃ach allemeñ rrapretyen ñam̃a att̃ach orrareʼtapretyen allchaʼ atarr posaʼtareʼtyen. ");
INSERT INTO ameNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ñeñt̃ña ataruasañer ñerraʼm ñapaʼ att̃ach ottatseʼtyena amach es puec̈haʼyeno amach eñoteñe ñeñt̃e yet̃aroch huerra pamoʼmteʼ amaʼt erroʼtsenchaʼ yet̃ro huena. Machayot̃achña huerra pamoʼmteʼpaʼ atarrchaʼ coñchatuer, allach mueñuer all ñeñt̃ oʼpatenaya allohuen ñeñt̃ ama es otapotetso amaʼt mamesha. ");
INSERT INTO ameNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Elloña napaʼ oʼch notas, amaʼt erraʼtsena ataruasañer ñerraʼm eñotenan ñeñt̃ atet̃ muenen pamoʼmteʼ t̃arraña ñerraʼm ama cohuen ameʼñenano pamoʼmteʼ ñerraʼm ama eʼñe cohuenayeʼ es p̃aʼyeno att̃och eʼñe cohuen aguërran pamoʼmteʼ esempoch huerra, amaʼt erraʼtsena ataruasañerpaʼ ñeñt̃ atet̃ petsapaʼ atarrchaʼ ashtaret̃terret. ");
INSERT INTO ameNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","T̃arraña erraʼtsenchaʼ ataruasañer ñeñt̃ ama eñotano ñeñt̃ atet̃ muenen pamoʼmteʼ amaʼt ñetpaʼc̈hoʼña aña atet̃ p̃aʼyenet ñeñt̃ ama cohuenayaye amaʼt eʼñe pocteñ att̃ecmach ashtaret̃terretañ ñamet, t̃arraña ñetpaʼ mameshaʼttsach ashtapecharet̃etyerret t̃arroʼmar ñetpaʼ ama eñoteneto ñeñt̃ atet̃ muenen pamoʼmteʼ. Allohueney erraʼtsenot̃ey ñeñt̃ey atarr aparet̃ey att̃och atarr yeñoterrñañ ñeñt̃ atarr sherbets Yomporecop, ñeñt̃eychaʼña atarrchaʼ cohueney Yompor oʼch eʼñe yesherb̃atuoñ shonteʼ allohuen ñeñt̃ atarr eñotateney. Ñam̃a allohueney erraʼtsenot̃ey ñeñt̃ey atarr yemtenya Yompor elloña allempopaʼ atarrchaʼ cohueney oʼch alloʼna eʼñe cohuen yesherb̃aʼneñ. ");
INSERT INTO ameNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’T̃eʼpaʼ oʼch neñotaterrserr poʼpoñ. Napaʼ att̃o nohuena arr patsro oʼch norrtatos elloptannaʼteñets ñeñt̃ atarr huomenc atet̃ ñerraʼm tsoʼ atarr atserrtetsa. Pocteʼ nenteñ oʼch orrtet eʼñe t̃ayecma. ");
INSERT INTO ameNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ñam̃a nocoppaʼ eʼñe atet̃ anaret̃ naʼmueroc̈htataret̃terrach eʼñe atarr huomenc atet̃ ñerraʼmrrat̃eʼ c̈ho chorratennet ñeñt̃chaʼ atarr nemueroc̈htaterreʼ. Ñeñt̃oʼmar napaʼ ñeñt̃ña atarr nellcateneʼ t̃eʼ att̃a atarr naʼhuanteñ esempoch eʼñech etsotuerra. ");
INSERT INTO ameNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Sapaʼ c̈hat̃eʼ sotenapañ añecopt̃eʼ nohuapa oʼch eʼñe cohuen namoʼtstannaʼtatera acheñeneshaʼ arr patsro. Ñeñt̃paʼ ama att̃eyaye. Añecpaʼnaña nohuapa allochñapaʼ eʼñe noʼmarpaʼ acheñeneshaʼñapaʼ oʼch att̃a elloptannaʼtyeset. ");
INSERT INTO ameNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ñehua, ñeñt̃ noten t̃eʼ eʼñe t̃ayot̃eñ ñatoʼ all yec̈hena amnarsheña puepahuarro pocollopaʼ ñatoʼ ñetpaʼ oʼch ellopaʼtetstatet poct̃ap̃ña. Ñatoʼ alloʼtsen maʼpsheña ñeñt̃chaʼ nameʼñerraya, ñatoʼ epsheñañapaʼ amach mueno oʼch ameʼñerrnet. Amapaʼ ñatoʼ epsheñach alloʼtsen ñeñt̃chaʼ nameʼñerraya, maʼpsheñañapaʼ amach mueno oʼch ameʼñerrnet. ");
INSERT INTO ameNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ñatoʼ eʼñe noʼmarpaʼ oʼch ellopaʼtetstatenet poct̃ap̃ña. Ñatoʼ pompor oʼch epatareʼtenan puechemer, amapaʼ ñatoʼ puechemerñapaʼ oʼch epatareʼtenan ñam̃a pompor, ñam̃a ñatoʼ pachorpaʼ oʼch epatareʼtenan puechoyor amapaʼ puechoyor oʼch epatareʼtenan pachor, ñam̃a ñatoʼ paʼsoʼmue oʼch epatareʼtenan paʼt̃oʼñen amapaʼ ñatoʼ paʼt̃oʼñenñapaʼ oʼch epatareʼtenan paʼsoʼmue. ");
INSERT INTO ameNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Allempoña Jesúspaʼ atet̃ yerpatana acheñeneshaʼ ñeñt̃ atet̃ otyenet ñet paʼnyeto: —Sapaʼ ñerraʼm esempo senten arr chorren os all emuena atsneʼ, sañapaʼ c̈hocmach atet̃ sotyen: “T̃eʼpaʼ c̈hach huatena.” Atet̃chaʼc̈hoʼ p̃a, oʼchc̈hoʼ huatena. ");
INSERT INTO ameNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ñam̃a ñerraʼm esempo senten huena m̃orr topot̃ot̃, ñeñt̃paʼc̈hoʼña atet̃chaʼ sotyen: “T̃eʼpaʼ oʼ charenmoch.” Atet̃chaʼc̈hoʼ p̃a, oʼchc̈hoʼ huoraterr huomenc. ");
INSERT INTO ameNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Sapaʼ atarr señoteneñña ñeñt̃ sentyen ento ñeñt̃ña señotateneʼ; amaʼt ñam̃a ñeñt̃ atet̃ sentyen ñam̃a arr patsro ñeñt̃paʼ eʼñe señotueñeñ. T̃arraña ñeñt̃ atet̃ norrtatyennas nepartsoteña, esoʼmart̃eʼña ñeñt̃ñapaʼ amaña eñotatensoña ñeñt̃ atet̃ pennas Yompor t̃eʼ oʼch orrtatonas poʼcohuenña. Ñeñt̃paʼ att̃at̃eʼ seshquëñ. ");
INSERT INTO ameNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’Elloña eʼñe sot̃a señotepaʼchña ñeñt̃ pocteʼ enten Yompor socop ñeñt̃chaʼ atet̃ sep̃annena. ");
INSERT INTO ameNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ñatoʼ oʼch netmaʼntatasa atet̃ ñerraʼmrrat̃eʼ eseshaʼ setmanteneʼ ñeñt̃chaʼ sanmueʼ am̃chaʼtaret̃esho allchaʼ saʼpoctaterr señoñ. Añ poctetsa allempo ama sec̈henaʼ am̃chaʼtaret̃esho oʼch p̃och ñeñt̃ petmanteneʼ: “Oʼch yaʼpoctaterr yeñoñ eʼñe cohuen t̃ayecma t̃ayepaʼtña ama yec̈henaʼ am̃chaʼtaret̃esho.” T̃arroʼmar ñeñt̃ petmanteneʼ ñerraʼm oʼch c̈hapatap̃ am̃chaʼtaret̃esho, am̃chaʼtaret̃ñapaʼ c̈hat̃eʼ pomap̃ policeyaneshesho, ñetñapaʼ c̈hat̃eʼ abeʼt̃apet cárcelo allchaʼ mueroc̈htaterrpet. ");
INSERT INTO ameNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Oʼch notas, ñerraʼm c̈hoch yottam̃p̃sasetpaʼ allasach oʼpono, allot̃ñapaʼ amach ahuen c̈haʼnmaterrseto. Esempohuañenchaʼ c̈hoch sec̈haʼnmaterret ñerraʼm allempoch eʼñe setsaʼtuerra ora allohuen ñeñt̃ allpon quelle muenenet. Amaʼt eʼñe eptalla centavot̃ollña ñerraʼm ama setsaʼtueñaʼ amachcaʼye c̈haʼnmaterrseto allot̃. Ñeñt̃oʼmarña notenes oʼch eʼñe cohuen samoʼtstera ñeñt̃ seʼmoñeʼteneʼ t̃ayepaʼtñapaʼ ama c̈hennasaʼ ñeñt̃ atarr yoroc̈hen senten socop. ");
INSERT INTO ameNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Allempo huapa puesheñaʼtets acheñeneshaʼ Jesúsesho, ñetñapaʼ serrpareʼtatoset Jesús atet̃ entenet ñet; ñeñt̃paʼ atet̃ otoset: —Allponsheña ñeñt̃ galileoʼmarneshaʼ alloʼtsaʼyenet allecma muetsatenet berr ñeñt̃ Yomporecop. Allempoñapaʼ huapanet ñeñt̃ mueñen am̃chaʼtaret̃ Pilato ñetñapaʼ c̈ha muetsanatosanet eʼñe all allempo muetsatenet berr ñeñt̃ Yomporecop. Att̃oña ñetpaʼ allña atsetatseʼtataret̃tet ñet poʼrras epuet pueberroret poʼrras. ");
INSERT INTO ameNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesúsñapaʼ atet̃ otanet: —Sapaʼ c̈hat̃eʼ sotenapañ ñeñt̃ galileoʼmarneshaʼ allempo atet̃ ap̃aret̃tet ñatoʼ ñetpaʼ atarrt̃eʼ nanac ochñat̃et ellot̃eʼ metanaʼtueñet allohuen poʼpotantañ galileoʼmarneshaʼ poʼchñaret. C̈hat̃eʼ sotenapañ ñeñt̃oʼmart̃eʼña atet̃ ap̃aret̃tet ñeñt̃ atarr sosey apencoc̈hen. ");
INSERT INTO ameNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","T̃arraña napaʼ oʼch notas: Amaʼt allohuenes sam̃a ñerraʼm amach eʼñe cohuen soct̃apeʼcherro ello Yomporecop, sapaʼc̈hoʼña att̃ecmach seperra sechencaʼhuerrach eʼñe poctacma. ");
INSERT INTO ameNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ñam̃a ñeñt̃ c̈harraʼ ñeñt̃ puechetsa posocsheña ñeñt̃ collaʼhuatsa ahuaña ñeñt̃ aʼtpetseʼt pocoll torrepoʼ allempo mataʼnerr Jerusaléño eʼñe all oteñet Siloé. Ñehua, sapaʼ c̈hat̃eʼ sotenapañ ñeñt̃ aʼcllaterr torrepaʼ ñetpaʼ atarrt̃eʼ at̃parñat̃et ellot̃eʼ metanaʼtueñet allohuen poʼpotantañ ñeñt̃ att̃o at̃pareʼtena jerusaléñoʼmarneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","T̃arraña napaʼ oʼch notas: Amaʼt allohuenes sam̃a ñerraʼm amach eʼñe cohuen soct̃apeʼcherro ello Yomporecop, sapaʼc̈hoʼña att̃ecmach seperra sechencaʼhuerrach eʼñe poctacma. ");
INSERT INTO ameNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Allempoña Jesúspaʼ alla tomaʼntaterraneterr poʼpocheño, ñeñt̃paʼ atet̃ oterraneterr: —Puesheñarr acheñ all puenarem̃mopaʼ allñapaʼ ahuañmoʼchot̃eñ nareʼtatenan ñam̃a puecharr partech. Att̃eñapaʼ c̈hap allempo huapa eʼnosñañ pueʼmer. T̃arraña amaʼt puem̃arrapaʼ ama entosñañe pueʼmer. Partayechpaʼ ama meʼteno. ");
INSERT INTO ameNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Allempoñapaʼ atet̃ otan ñeñt̃ cohuam̃peneʼ puenarem̃maʼ: “T̃eʼpaʼ oʼ met maʼpa char c̈hocma nohuena eʼneneʼ partech pueʼmer. T̃emeʼttsen amaʼt puem̃arra pueʼmerpaʼ ama nenteññañe. T̃eʼpaʼ oʼch p̃aʼmater t̃arroʼmar eʼñe orrena quec̈hcareʼtennay yepatseñ att̃o ama yenareʼteno poʼpoñ narmets all.” ");
INSERT INTO ameNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","T̃arraña ñeñt̃ cohuam̃peneʼ narmetspaʼ atet̃ otan pamoʼmteʼ: “Allach nomporchaʼ añ char ñeñt̃ oʼ huerrerrpaʼ napaʼ oʼch naʼmueñtsetam̃pes pats oʼch nenoñ amar. ");
INSERT INTO ameNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ñatoʼrraña atet̃ nepeʼpaʼ oʼch cohuen meʼt tsapat̃ charo. T̃arraña ñerraʼm ama meʼtopaʼ pocteʼñac̈hoʼ allempopaʼ oʼch p̃aʼmatater.” ");
INSERT INTO ameNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Allempo c̈hapaʼmuenerr allempo amesenet, Jesúsñapaʼ yec̈hatenanet judioneshaʼ poʼprahueto. ");
INSERT INTO ameNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Allñapaʼ alloʼtsen puesheñarr coyaneshaʼ ñeñt̃ c̈ha moʼquëna, ama eshcayeʼ pac̈harrteno. Ñeñt̃paʼ oneñet̃ atet̃ p̃ateneʼ. Ahuat̃ot̃eñ att̃a pena oʼ c̈harren char puechena posoc att̃a moʼquëna. ");
INSERT INTO ameNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesúsñapaʼ all eñchpaʼ oʼ c̈horeʼtospaʼ atet̃ och: —Noc̈ha t̃eʼpaʼ pasaterrep̃chaʼ ñeñt̃ att̃o atarr pemueroc̈htena. ");
INSERT INTO ameNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Allempoñapaʼ aʼp̃llamcoʼch. Aʼp̃llamcoʼtueʼpaʼ allorocma eʼñe cohuen pac̈harrterra. Ñañapaʼ atarr ayeʼchoc̈htaterran Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Allempoña ñeñt̃ am̃chaʼtaret̃tetsa all judioneshaʼ poʼprahuo, ñapaʼ allempo entan atet̃ oʼ aʼcrratan Jesús atsnañet̃, ñañapaʼ ñeñt̃a atarr atsrreʼmateʼ. Amaʼt mameshapaʼ ama pocteyeʼ eñche oʼch aʼcrratan acheñ ñeñt̃e yet̃ro allempo amesenet. Ñeñt̃oʼmarña ñapaʼ atet̃ otan acheñeneshaʼ: —Eñall pechapmat yet̃ allempo pocteʼ oʼch yetaruasen. Ñeñt̃paʼ pocteʼ oʼch sehuapa allempo att̃och saʼcrrater atsnañet̃. T̃arraña añ yet̃ro allempo yamesen amach sehuapatsto aʼcrrateʼ atsnañet̃. ");
INSERT INTO ameNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Partseshaʼñapaʼ atet̃ och: —Sapaʼ ñeñt̃es eʼñe sommoʼcheñot̃paʼ atarr seshcareʼten. Sapaʼc̈hoʼña amaʼt añe yet̃ro allempocma yamesen c̈hocma setaruasen sam̃a. Sepyam̃peñ sehuacsher, sashanor allecma serrateñ oʼch sanem̃ ñam̃a oño allchaʼ sonayeñ oñ. ");
INSERT INTO ameNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Añ coyaneshaʼ amaʼt ñeñt̃ poʼm̃reneñ pen yatañ Abraham amaʼt c̈harraʼ puechena posoc char ñeñt̃ allponmat oʼ huanquër oneñet̃, pocteʼcaʼye oʼch yaʼrroyatater amaʼt añe yet̃ro allempo yamesen. ");
INSERT INTO ameNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Acheñeneshaʼ allohuen ñeñt̃ eʼmoñeʼteneʼ ñetpaʼ ñeñt̃ña atarr pencatahuet. Poʼpotantañña acheñeneshac̈hnopaʼ ñetñapaʼ atarr nanac coshenet. Atarr nanac cohuen entenet ñeñt̃ atet̃ p̃a Jesús. ");
INSERT INTO ameNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ñeñt̃oʼmarña allempopaʼ alla oterraneterr: —Añ Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña, ñanompaʼ eʼñech puesheñaʼttsa ameʼñaʼyestsa, allempot̃eññapaʼ alloʼnach sen atonetnomtsa ñeñt̃chaʼ ameʼñerrtsa att̃ochña eʼñe epaʼhuerra erracmañen Yompor poʼcohuenña. Ñeñt̃ña t̃eʼpaʼ oʼch netmaʼntatasa ñeñt̃ atet̃ pena ña. ");
INSERT INTO ameNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ñehua, ñeñt̃paʼ atet̃ pena ñerraʼmrrat̃eʼ pueʼllomer ñeñt̃ atarr añet̃olleshallmerr ñeñt̃ otenet mostazllom̃. Ñeñt̃ pueʼllom̃ret̃ollpaʼ puesheñarrñapaʼ oʼ anem̃ paʼmro allchaʼ nareʼteñaʼ. Eʼñe allponmatatsapaʼ oʼ chop, ñeñt̃ñapaʼ alloʼna sen rrorranmats eʼñe cohuen atarrchetnom. Ñeñt̃ña narmetsocherpaʼ oʼch huac̈haʼtoña ot̃ec̈hno ñeñt̃chaʼ amaʼtanatyesosets puetacroʼmar. ");
INSERT INTO ameNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Elloña alla oterraneterr: —Poʼpoñonet̃ oʼch netmaʼntatasa ñeñt̃ atet̃ pena Yompor poʼcohuenña ñeñt̃ att̃o atarr ayochreshat̃tena ña. Ñeñt̃paʼ amaʼtchaʼ añet̃olla ñeñt̃chaʼ ñanom orrtatsa t̃arraña eʼñe ña poʼhuamencot̃paʼ mamet̃ollapaʼ oʼch eʼñe epaʼhua ora errap̃aren. ");
INSERT INTO ameNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ñeñt̃paʼ añ tomaʼntaterraneterr atet̃ pena chaseʼ: —Ñeñt̃ chaseʼpaʼ allo tsetenan coyaneshaʼ harinaʼ ñeñt̃ oñetsetstaten att̃och aʼchasatan harinaʼ eshecchaʼ eʼñe aʼmuesatue. Ñeñt̃ña chaseʼpaʼ amaʼtchaʼ añet̃olla net, amaʼtchaʼ aton harinaʼ ñeñt̃ maʼpa arroga, mamet̃ollapaʼ oʼch eʼñe aʼmuesatuanña amaʼt atarr aton harinaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","All oñemyen Jesús eʼñe ora asuahuanom allohuen anetsoʼmar all shontaʼyena acheñeneshaʼ amaʼt ñam̃a all ama tama eñalleyaye acheñeneshaʼ. Allña eʼñe serrpareʼtatyesnomanet. Allempo oñemyen allemeñ anetsoʼmar ñapaʼ arr sen Jerusaléño all sechena. ");
INSERT INTO ameNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","All oñen t̃oñopaʼ allempoña puesheñarrpaʼ aʼp̃t̃oʼtnom̃, atet̃ och: —Ayochreshat̃e, ñeñt̃chaʼ allpon aʼqueshp̃ataret̃terrtsapaʼ taʼm ñetpaʼ ¿puesheñaʼttsetat̃eʼ ñatoʼ amapaʼ atarrchaʼ shonteʼ? Jesúsñapaʼ atet̃ och: ");
INSERT INTO ameNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Sapaʼ añchaʼña eʼñe cohuen semaʼyoc̈hrena ñeñt̃ cohuen enten Yompor att̃ochña sesuanom ñeñt̃ ama cohuenayeʼ enteno ña. Ñeñt̃paʼ oʼch netmaʼntacha atet̃ ñerraʼmrrat̃eʼ allchaʼ yebeʼt̃os eshecchaʼ yec̈hap ñesho ñeñt̃paʼ atarr añet̃oll, atarr t̃orrapoʼ oʼch yebeʼt̃os all. Ñam̃a oʼch notas esempohuañen amaʼtchaʼ shonteʼ acheñeneshaʼ ñeñt̃chaʼ atarr muenatseñ oʼch beʼt̃erretañ all att̃och c̈herretañ Yomporesho t̃arraña allempopaʼ amach eshec beʼt̃erreto att̃och c̈herret all t̃arroʼmar allempopaʼ oʼch huañerr att̃o atarr cohueney Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ñeñt̃paʼ oʼch netmaʼntacha atet̃ ñerraʼmrrat̃eʼ esempo oʼch c̈hen ñeñt̃ apacllat̃eshaʼ ñañapaʼ oʼch tantuena oʼch eʼñe echarr yottam̃pesuena. Allempopaʼ amaʼt eʼñe eseshapaʼ amach eshec beʼt̃osoña all. Allempoña amaʼtchaʼ shonteseñ oʼch sehuac̈haʼta all petot̃ach sechorros allot̃chaʼ sec̈horeʼtos apacllat̃eshaʼ. Allña sapaʼ atet̃chaʼ sotos: “Ayochreshat̃e petoram̃p̃sapuey.” Ñapaʼ atet̃chaʼ otapas: “Napaʼ ama nentarso, errot̃t̃eʼ sehuenaña sa.” ");
INSERT INTO ameNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Sañapaʼ atet̃chaʼ sotererr: “Amaʼt parrocma yerrallmeʼchyeseʼt̃eña ahuañmoʼcha ñam̃a amaʼt ya yaʼnetsroʼmar allecma chopeñeʼchyenet allcaʼyeña peyc̈hatyeseʼt̃.” ");
INSERT INTO ameNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","T̃arraña ñapaʼ atet̃chaʼ oterrserr: “T̃eʼpaʼ oʼch notas, napaʼ amacaʼye poʼñoc̈h nentarso, errot̃t̃eʼ sehuenaña sa. T̃eʼpaʼ orrerres arrot̃ neshot̃ allohuenes ñeñt̃es maʼyoc̈hrenaya ñeñt̃ ama pocteʼ enteno Yompor.” ");
INSERT INTO ameNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Oʼch ahues all ñeñt̃ oʼpatatenset sa. Allñapaʼ allchaʼ seyahuanrrortosa, sanmueñot̃ atserrpaʼ serrasoʼtyesoschaʼ sas. Allot̃chaʼña sentosña satañneshac̈hno—Abraham ñam̃a Isaac ñam̃a Jacob ñam̃a allohuen ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ. Ñetñapaʼ eʼñe Yomporeshoʼtsaʼyenet all am̃chaʼtaret̃tena ña. Sañapaʼ chaʼpetot̃aña huaporeʼtenset. ");
INSERT INTO ameNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Allñapaʼ allem̃at̃eñchaʼ huac̈haʼta shonteʼ ñeñt̃ ama judioneshayaye ñeñt̃chaʼ anorrc̈haʼtyesosets all eʼñe Yomporesho all am̃chaʼtaret̃tena ña allchaʼ rrallmeʼchoset all eʼñe cohuentena Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","T̃eʼpaʼ señochchaʼ eñall acheñeneshaʼ ñeñt̃ ama asherbenayeʼ senteno sa t̃eʼ t̃arraña allempoña ñetpaʼ atarrchaʼ asherben enterranet Yompor. Ñam̃a eñall acheñeneshaʼ ñeñt̃ atarr asherben sentyen sa t̃eʼ, t̃arraña allempoña ñetpaʼ amach asherbenayeʼ enterraneto Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Eʼñe ñeñt̃e yet̃rocma allempo huac̈haʼtoña patantarr fariseoneshaʼ. Ñetñapaʼ atet̃ otoset Jesús: —T̃eʼpaʼ oʼch peyeta arrot̃ t̃arroʼmar am̃chaʼtaret̃ Herodespaʼ oʼpatenp̃a ahuoʼch muetsatap̃. ");
INSERT INTO ameNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesúsñapaʼ atet̃ otapanet: —Oʼch ahuerrespaʼ atet̃chaʼ sotuer Herodes ñeñt̃ atarr eñoteneʼ shequëñets: “T̃eʼpaʼ oʼch peñoch, napaʼ att̃erach necac̈hpatateññañ acheñeneshaʼ poʼneñet̃er ñam̃a att̃erach shonteʼ naʼcrratyes ñeñt̃ atsnaʼtyets. Atet̃ nepena t̃eʼ, tsapat̃onet̃paʼc̈hoʼña att̃ecmach nepena, oʼchña tsapat̃ont̃errerrpaʼ oʼch eʼñe netsotatue allohuen.” ");
INSERT INTO ameNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nocoppaʼ añ poctetsa c̈hocmach nesen amaʼt t̃eʼ, amaʼt tsapat̃onet̃paʼc̈hoʼña, amaʼt ñam̃a oʼch tsapat̃ont̃errerrpaʼ c̈hocmach nesen. Att̃ot̃ach nec̈herr Jerusaléño, t̃arroʼmar allpaʼ allecma c̈hocma muetsayeseteʼt̃ ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Allempoña Jesús eʼñe puellquëñot̃ judioneshaʼpaʼ atet̃ eñorena ñocpuet, ñeñt̃oʼmarña atet̃ otanet: —Sa jerusaléñoʼmarneshachaʼ ñeñt̃es muetsanatyesayeʼt̃ ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ, sa ñeñt̃es rrollapechyesayeʼt̃ ñeñt̃ amñaret̃ sesho. Atarr atonocheʼtats nemneñeñ oʼch naʼyapac̈haʼhuerrsoñ allohuenes nesho att̃och eʼñe cohuen necuam̃pensoñ. Nemneñeñ oʼch naʼyapac̈haʼhuerres atet̃ ñerraʼmrrat̃eʼ atollop aʼyapac̈heneʼ puechoyoreshaʼ oʼch eʼñe setoʼtuanet. T̃arraña sañapaʼ amaʼt eʼñe mameshapaʼ amaña semno. ");
INSERT INTO ameNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","T̃eʼñapaʼ all seyc̈hena sa, Yomporñapaʼ oʼch aʼypoʼñerres. T̃arroʼmar t̃eʼpaʼ oʼch alla noterrserr: Na poʼpocheñopaʼ amach alla senterrno t̃eʼ. Esempohuañenñapaʼ senterrenchaʼ allempoñapaʼ atet̃chaʼ soterren: “Ayeʼchoc̈htatpahuepaʼch Jesucristo ñeñt̃ huapatsa ñeñt̃ llesensen Yeyomporer.” ");
INSERT INTO ameNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Allempoña c̈herrerr pamt̃arr allempo amesenet. Jesúsñapaʼ ahuoʼ allchaʼ rrallmeʼchapretenanaʼ puesheñarr fariseo ñeñt̃ atarr am̃chaʼtaret̃tetsa. C̈hap all paʼpacllopaʼ poʼpotantañña fariseoneshaʼ ñetñapaʼ atarr cohuanaʼtyesapet Jesús. ");
INSERT INTO ameNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Allñapaʼ alloʼtsen puesheñarr yacma ñeñt̃ c̈ha ananen. ");
INSERT INTO ameNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesúsñapaʼ all serrpareʼtos epuet fariseoneshaʼ ñam̃a ñeñt̃ alloʼtsaʼyen ñeñt̃ atarr etsoteneʼ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop. Ñañapaʼ att̃a aʼp̃t̃oʼtosanet eʼñe poʼtomña, allochñapaʼ oʼch eñoch ñatoʼ errot̃enchaʼ anapet. Ñeñt̃paʼ atet̃ otosanet: —¿Errot̃enaʼtña sotenña sa, taʼm pocteʼt̃eʼ oʼch naʼcrratos atsnañet̃ añe yet̃ro allempo yamesen? ¿Att̃eʼt otenña ñoñets ñeñt̃ atet̃ anaret̃, ñatoʼ amat̃eʼ? ");
INSERT INTO ameNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Fariseoneshaʼñapaʼ ama eseshayeʼ anapuetso amaʼt puesheñarrot̃a. Allempoña Jesúspaʼ aʼp̃llamcoʼtosan atsnañet̃. Eʼñe aʼp̃llamcoʼtueʼpaʼ c̈ha correrrtsa allent̃a mueñer paʼpacllo. ");
INSERT INTO ameNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Allempoña Jesúspaʼ alla oterranerr fariseoneshaʼ: —Sapaʼ ñerraʼm sashanor amapaʼ sehuacsher shoraʼnets arrorot̃o all chorren oñ, amaʼtchaʼña sechtereña allot̃ eʼñe allorocma amaʼt añe yet̃ro allempocma yamesen. ");
INSERT INTO ameNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ñetñapaʼ ama errot̃enayeʼ otenayeʼ enteñeto amaʼt eʼñe puesheñarrot̃a. ");
INSERT INTO ameNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Allempoña ñeñt̃ ahuaʼñaret̃neshaʼ ñetñapaʼ aña atarr muenenet oʼch anorryesoset allecma anen ñeñt̃ atarr am̃chaʼnaʼtpoʼ entyenet. Jesúsñapaʼ entapanet ñeñt̃ atet̃ muenenet ñet oʼch c̈ha ommoʼchyesoset. Allempoñapaʼ atet̃ otapanet: ");
INSERT INTO ameNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Ñerraʼm esempo ahuaʼñaret̃es oʼch serrallmeʼchapreteñaʼ ñeñt̃ senaʼtetsa, sommoʼcheñot̃paʼ amach arra sanorratsetyesoso allecma anen ñeñt̃ atarr am̃chaʼnaʼtpoʼ entyenet. Ñetña chentaʼpaʼ oʼch huapuet ñamet. ");
INSERT INTO ameNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Aneʼtañ ñeñt̃ sehuaʼñeneʼ allohuenes ñañapaʼ oʼch huapa pesho oʼch otap̃: “T̃eʼpaʼ oʼch petanterra arrot̃, all p̃anen t̃eʼpaʼ oʼ huapaña ñeñt̃ panorrpueʼ peneʼ all p̃anen ñeñt̃ atarr am̃chaʼnaʼtpoʼ entyenet.” P̃aña allempopaʼ atarrchaʼ pepenquëñot̃ petanterra oʼch ahuep̃ allchaʼ p̃anorros allecma anorryen ñeñt̃ ama esosheʼmayeʼ entyeneto. ");
INSERT INTO ameNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Sapaʼ atet̃chaʼña sep̃a ñerraʼm esempo huaʼñenset. Allempo sec̈hap all huaʼñenset sapaʼ allach sanorros allecma anorrc̈haʼtyen ñeñt̃ ama esosheʼmayeʼ entyeneto. Allñapaʼ oʼch huapa aneʼtañ, ñapaʼ atet̃chaʼ otosep̃: “Masheñchaʼ p̃apaʼ arrchaʼ p̃anorros allecma anen ñeñt̃ atarr am̃chaʼnaʼtpoʼ entyenet.” Att̃ochña allohuen ahuaʼñaret̃neshaʼpaʼ oʼch entapet p̃apaʼ atarr am̃chaʼnaʼtpoʼ entyenpet. ");
INSERT INTO ameNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","T̃arroʼmar allohuen ñeñt̃ eʼñe cohuen entetsa eʼñe pommoʼcheñot̃ ñetña tsapat̃onet̃paʼ amach esosheʼmayeʼ entereto. T̃arraña allohuen ñeñt̃ ama esosheʼmayeʼ entetso t̃eʼ, ñeñt̃ña tsapat̃onet̃paʼ atarrchaʼ cohuen enteret. ");
INSERT INTO ameNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Allempoñapaʼ atet̃ otan aneʼtañ ñeñt̃ huaʼñeneʼ: —Ñerraʼm esempoch p̃orrtaten rreñets ñeñt̃chaʼ serraʼmuen aromtaña amapaʼ ellerronet̃ amach eʼñe aña pehuaʼñatsto ñeñt̃ eʼñe parro peyemtena ñam̃a ñeñt̃ pemoʼnasheñ pepen ñam̃a poʼpotantañ ñeñt̃ eʼñe p̃amoʼtseshaʼ pepen amaʼt ñam̃a alloʼmarneshaʼ ñeñt̃ atarr ec̃llayoret̃et. T̃arroʼmar ñerraʼm ñeñt̃a pehuaʼñenpaʼ ñetpaʼc̈hoʼña tsapat̃onet̃ oʼch alla huaʼñerrpet p̃am̃a. Att̃och tsaʼterrpet. ");
INSERT INTO ameNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","T̃arraña ñerraʼm esempoch p̃orrtat rreñets añeʼnachña pehuaʼñaʼyes ñeñt̃ atarr huocchañetyets ñam̃a achocrañac̈hno ñam̃a ñeñt̃ checaʼreʼpac̈hno ñam̃a aporoʼyet̃ec̈hno. ");
INSERT INTO ameNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Att̃ochña p̃apaʼ atarrchaʼ cosheñtsoʼtsenep̃ t̃arroʼmar ñetpaʼ amach errot̃enot̃ alla tsaʼterrpeto. P̃apaʼ esempohuañenchaʼña atsaʼtaret̃ep̃ allempoch atantataret̃terra allohuen ñeñt̃ eʼñe pocteʼ es p̃aʼyestseʼt̃. ");
INSERT INTO ameNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Allempo eʼmueñet Jesús atet̃ serrpareʼtatuanet, puesheñarrña ñeñt̃ parro anorrc̈henet ñeñt̃ parro rrallmeʼchenet, ñañapaʼ atet̃ otan Jesús: —Atarrchaʼ cosheñtsoʼtseney allohueney ñeñt̃eychaʼ rrallmeʼchapreterreʼ Yompor all am̃chaʼtaret̃tena pueʼntaño. ");
INSERT INTO ameNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesúsñapaʼ tomaʼntaterraneterr, ñeñt̃paʼ atet̃ oterraneterr: —Eñall puesheñarr aneʼtañ ñañapaʼ oʼch yec̈hcatatan atarr shonteʼ aton rreñets. Allempoñapaʼ otyesan shonteʼ acheñeneshaʼ ñeñt̃chaʼ rrallmeʼchapretenayaʼ esempoch eʼñe aʼpotatuan rreñets. ");
INSERT INTO ameNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Oʼña c̈hap allempo eʼñe aʼpotatuan rreñetspaʼ ñañapaʼ mueñan paʼtaruasañer ñeñt̃chaʼ huaʼñaʼyenayaʼ allohuen acheñeneshaʼ ñeñt̃ otaret̃tatsa ahuaña. Ñeñt̃ña paʼtaruasañerpaʼ atet̃ otosan acheñeneshaʼ: —T̃eʼpaʼ oʼcaʼye eʼñe aʼpotaret̃etuaña rreñets sonac̈haʼt oʼch serrallmeʼchapretenaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","T̃arraña ñeñt̃ ahuaʼñaret̃ec̈hnopaʼ ñetñapaʼ ama eseshaʼ tatso. Ñehua, ñeñt̃ ñanom puesheñarrpaʼ atet̃ ot: “Napaʼ t̃eʼpaʼ oʼcaʼye nerañt̃a pats, oʼchcaʼye ahuen oʼch necuaʼyeñaʼ. P̃otuerchaʼ p̃amoʼmteʼ peretnerrnepaʼ, napaʼ amachcaʼye neto.” ");
INSERT INTO ameNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Poʼpsheñeñpaʼc̈hoʼña atet̃ ot: “Napaʼc̈hoʼña oʼcaʼye nerañt̃a c̈harrana toro poʼyuntohuen eʼñe epnaʼttsocma; oʼchcaʼye ahuen oʼch netpach taruasateʼ. P̃otuerchaʼ p̃amoʼmteʼ peretnerrnepaʼ, napaʼ amachcaʼye neto.” ");
INSERT INTO ameNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Poʼpsheñeñpaʼc̈hoʼña atet̃ ot: “Napaʼ errtencaʼye senaʼtetsa ñeñt̃oʼmarña napaʼ amachcaʼye eshec neto.” ");
INSERT INTO ameNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ñeñt̃ña ataruasañer atet̃ otyes acheñeneshaʼpaʼ ñañapaʼ ahuerr pamoʼmtayesho, serrpareʼtatuerran pamoʼmteʼ atet̃ otyeset ñeñt̃ huaʼñaʼyeseñ. Aneʼtaññapaʼ ñeñt̃ña atarr atsrreʼmateʼ. Patsrreʼmueñot̃paʼ atet̃ oterranerr paʼtaruasañer: “T̃eʼpaʼ oʼch ahuerrperr eʼñe t̃ayecma ñam̃a all anetso allecma atarr chopeñeʼchyen shonteʼ acheñeneshaʼ. Allot̃chaʼña pehuapaterr huocchañneshac̈hno ñam̃a achocrañac̈hno ñam̃a aporoʼyet̃ec̈hno ñam̃a checaʼrepac̈hno.” ");
INSERT INTO ameNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Paʼtaruasañerñapaʼ atet̃c̈hoʼ perrerr. Allempo huerra atet̃ otuerranerr pamoʼmteʼ: “Nomporchaʼ ñeñt̃ atet̃ p̃otenpaʼ t̃eʼpaʼ oʼ eʼñe atet̃ nep̃ohua. T̃arraña allchaʼ anorrc̈haʼtyes ñeñt̃chaʼ rrallmeʼchosetspaʼ orameñ.” ");
INSERT INTO ameNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Pamoʼmteʼñapaʼ atet̃ otererr: “T̃eʼpaʼ oʼch alla ahuerrperr allampañoʼmar all shonteʼ t̃oñec̈hno allecma chopeñeʼchyen acheñeneshaʼ. Allñapaʼ atarrchaʼ p̃otareʼtyes acheñeneshaʼ onetepaʼ arr nepacllo att̃och eʼñe chorra acheñeneshaʼ arr nepacllo. ");
INSERT INTO ameNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Poʼñoc̈h t̃eʼ napaʼ oʼch notas, ñeñt̃ ñanom nehuaʼñatyeseñpaʼ ñetña t̃eʼñapaʼ amaʼt eʼñe puesheñarrot̃etapaʼ amach rrallmeʼchapreterrneto att̃och cosherret nesho.” ");
INSERT INTO ameNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","All oñemyen Jesúspaʼ shonteʼ acheñeneshaʼ cot̃aʼhuaneneʼ. Ñañapaʼ cohuaʼnmanet allenet̃ shontenetpaʼ atet̃ otnomanet: ");
INSERT INTO ameNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Ñerraʼm eseshaʼ mueneʼ oʼch cot̃erren eʼñe poʼñoc̈h, añ nemnen oʼch atarr nanac morrentennet. Elloch metaneñet att̃o atarr morrenteñet pompor, amaʼt ñam̃a pachor, amaʼt ñam̃a puet̃apor ñam̃a puechemereshaʼ, paʼmoʼnasheñneshaʼ, poʼc̈haneshaʼ. Att̃o atarr morrentennet ello metaneñet att̃o atarr morrentenet ñañeñeta ñeñt̃ att̃o correnet arr patsro. Ñerraʼm erraʼtsen ama att̃eyeʼ nemorrentenayepaʼ nañapaʼ amach errot̃enot̃ neyochreshaʼ neperraneto. ");
INSERT INTO ameNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","T̃arroʼmar ñerraʼm erraʼtsen ama eʼñeyeʼ sehuanmaye ñeñt̃ atet̃ muenenet eʼñe ñocpueta att̃och cot̃errnet eʼñe poctacma, nañapaʼ amach errot̃enot̃ neyochreshaʼ neperraneto. Ñeñt̃paʼ añ tomaʼntena atet̃ ñerraʼmrrat̃eʼ c̈ho sechechnen secorsoch allchaʼ semueroc̈hta sam̃a. ");
INSERT INTO ameNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ñeñt̃oʼmarña ñerraʼm erraʼtsenot̃es mueneneʼ oʼch neyochreshaʼ neperres, añ poctetsa c̈hoch ñanom soct̃apeʼch, eʼñet̃eʼ pocteʼ senteñ oʼch sesuanom ora allohuen ñeñt̃ atet̃ notenes. Ñeñt̃paʼ atet̃chaʼ netmaʼntacha atet̃ ñerraʼmrrat̃eʼ eseshas mueneneʼ oʼch sat̃omat sepaquëll atarrpoʼpaʼ añ sepalltena c̈hoch ñanom sanorr allchaʼ soct̃apeʼch errpont̃eʼ tsaʼtena. Ñatoʼ eñallt̃eʼ allpon quelle att̃och mameshapaʼ oʼch saʼpueʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ñerraʼm ama atet̃ ñanom soct̃apeʼchenopaʼ ñatoʼ oʼch sat̃omatañ ñanom alloch echarr sorrat sepaquëll, ñerraʼm c̈ha sehuañapes quelle att̃och saʼpañ sepaquëllpaʼ att̃ach secac̈hpueʼ. Acheñeneshaʼña ñeñt̃ senteneʼpaʼ c̈hach cheʼtatsetaset; ");
INSERT INTO ameNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ñetñapaʼ atet̃chaʼ otyeset: “Añ acheñerpaʼ oʼ t̃omataneñña atarrpoʼ paʼpaquëll, alla huañapes quellepaʼ ama esoyeʼ aʼpatano paʼpaquëll.” ");
INSERT INTO ameNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ñeñt̃ara cot̃ap̃ñatser oʼch alla netmaʼntacha poʼpoñonet̃. Atet̃ ñerraʼmrrat̃eʼ puesheñarr am̃chaʼtaret̃ ñerraʼm añ cot̃apeʼchen oʼch quellaratan poʼsolltarer epuet poʼpsheñeñ am̃chaʼtaret̃ poʼsolltarer c̈hoch ñanom anorr allchaʼ eʼñe cohuen cot̃apeʼch. Allempopaʼ atet̃chaʼ ot: “Napaʼ eʼñecaʼ c̈harraʼ mila nechen nesolltarer; poʼpsheñeñña am̃chaʼtaret̃paʼ echenan poʼsolltarer epoch c̈harraʼ mil. Taʼm, pocteʼt̃eʼ oʼch nemñe c̈harraʼ mil nesolltarer ñeñt̃chaʼ poctapueʼ epoch c̈harraʼ mil solltarneshaʼ ñeñt̃chaʼ yehuapoya. Taʼmcaʼye aʼmchechatuett̃eʼcaʼye—shonteʼ.” ");
INSERT INTO ameNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Allempoña oʼch atet̃ cot̃apeʼchuapaʼ ñerraʼm ama errot̃ apenayeʼ eñchepaʼ allempo ama aponmaret̃tenetaʼ ñañapaʼ oʼch mueñan allponsheña ñeñt̃chaʼ atet̃ otosahuet: “Yapaʼ añecop yen oʼch yaʼpoctaterr ñoñets eʼñe cohuen eʼñe att̃a, amach yec̃llarannaʼtatsto.” ");
INSERT INTO ameNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ñeñt̃oʼmar notenes, ñerraʼm eseshas ama eʼñe pocteyeʼ senteñe oʼch sesuanom ora ñeñt̃ allpon sechen, nañapaʼ amach errot̃enot̃ neyochreshaʼ neperrso. ");
INSERT INTO ameNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Ñehua, yapaʼ yeñoteñ pospaʼ atarr cohuen sherbenan allohuen acheñeneshaʼ arr patsro. (Allohuen ñeñt̃ poʼñoc̈h neyochreshaʼ nepen ñetñapaʼ atarr sherbenet att̃et ñerraʼmrrat̃eʼ pos atarr cohuen sherbeney.) T̃arraña pospaʼ ñerraʼm oʼch huañerr poʼposerrteña amach errot̃enot̃ ellopaʼ yaʼposerrtatere. ");
INSERT INTO ameNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Att̃oña amach es sherberro amaʼt eʼñe coñeʼt̃a. Amaʼt att̃och yetnarrataterr allo patspaʼ amaʼt ñeñt̃ecpapaʼ amach sherberro; ñeñt̃oʼmarña amaʼt ñeñt̃ecpapaʼ amach yaññoʼtatsche. Ñeñt̃oʼmarña oʼch yehuaporeʼter aʼyo. Ñerraʼm eseshast̃eʼ neʼm̃ñoteneʼpaʼ c̈haponasepaʼch seyoc̈hro ñeñt̃ atet̃ neyc̈hatenes. ");
INSERT INTO ameNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Shonteʼ ñeñt̃ cobrets quelle gobiernocop ñeñt̃ara ñeñt̃ atarr shecareʼtyets ñam̃a shonteʼ ochñat̃eneshaʼ, ñetñapaʼ huac̈haʼtet Jesúsesho oʼch eʼm̃ñoteññañetaʼ ñeñt̃ atet̃ serrpareʼtatenan allohuen acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Añña fariseoneshaʼ ñam̃a ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop, ñetñapaʼ amaʼt mameshapaʼ ama pocteyeʼ enteñeto. Ñetñapaʼ att̃a sasareʼteñet Jesúspaʼ ñeñt̃paʼ atet̃ otannaʼtyenet: —Añ acheñer amaʼt ñeñt̃ atarr ochñat̃eneshaʼpaʼ esoʼmart̃eʼña eʼñe cohuen agapyenanet, ñam̃a alla rrallmeʼchapreteñet. ");
INSERT INTO ameNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ñeñt̃oʼmar Jesúspaʼ alla tomaʼntaterraneterr; ñeñt̃paʼ atet̃ oterraneterr: ");
INSERT INTO ameNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Sapaʼ ñerraʼm eseshas echeneʼ shonteʼ secarrneror, c̈harroch c̈harraʼ sechen t̃arraña ñerraʼm pomocarrña machayot̃a saʼchencachpaʼ amaʼt atet̃ sepeno. Oʼch sesaʼnom allohuen poʼpotantañ ñeñt̃ oʼ noventa nueb̃am̃a all amayo amaʼt atarr aʼyopaʼ oʼch ahues eʼnerrayaʼ pomocarr ñeñt̃ chenquëtsa. Allchaʼ seʼnameʼtyeraʼpaʼ att̃ot̃ach senter. ");
INSERT INTO ameNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Allña senterpaʼ oʼch senatner, eʼñech socsheñeshocmañen saner. ");
INSERT INTO ameNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Oʼchña sec̈hapater sepacllopaʼ allñapaʼ oʼch sec̈horeʼtuer samoʼtseshaʼ oʼch onac̈haʼtet. Allñapaʼ oʼch sotuerr: “T̃eʼpaʼ oʼch socshapreterrna necarrneror, t̃eʼpaʼ oʼ nenterrña ñeñt̃ naʼchencaten.” ");
INSERT INTO ameNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ñeñt̃oʼmarña t̃eʼpaʼ notenes: Yamoʼmteʼ ñeñt̃ pueʼtañoʼtsen att̃ecmach atarr nanac cosherrana amaʼt puesheñarra acheñ ñeñt̃ atarr ochñat̃ ñerraʼm esempoch oʼch cot̃apeʼcherret ello eʼñe cohuen ñocop. Elloch metanaʼtuerran ñeñt̃ att̃o coshenana poʼpotantañ ñeñt̃ shonteʼ ñeñt̃ eʼñe pocteʼ es p̃aʼyenet ñocop amaʼt ñetpaʼ shontet atet̃ ñerraʼm noventa nueve carrnero ñam̃a ñetpaʼ amaʼt ama pallteneto oʼch cot̃apeʼcherret ello cohuen. ");
INSERT INTO ameNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Ñeñt̃ara cot̃ap̃ñats, t̃eʼpaʼ ñatoʼ atet̃chaʼ netmaʼntacha poʼpoñonet̃ atet̃ ñerraʼm puesheñarr coyaneshaʼ ñerraʼm echenan c̈harratlla poʼc̃llayor ñeñt̃ atarr morrentena. Ñerraʼm c̈ho aʼchencach puetallarrpaʼ amaʼtchaʼ aʼllchatanoña poʼlampareñ att̃och tarrapoʼtenan paʼpaquëll allchaʼ eʼnameʼtyerran puetallarr poʼc̃llayor. Att̃ot̃chaʼña enter. ");
INSERT INTO ameNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Oʼchña enterpaʼ allempoñapaʼ oʼch agotan pamoʼtseshaʼ eʼñe pacmaneshocheʼ, atet̃chaʼ otanet: “T̃eʼpaʼ oʼch socshapreterrna ñeñt̃ puetallarr nec̃llayor ñeñt̃ naʼchencat, t̃eʼpaʼ oʼ nenter.” ");
INSERT INTO ameNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","T̃eʼpaʼ oʼch noterrserr, elloña atarrchaʼ nanac coshateret Yompor poʼm̃llañot̃eñreneshohuen ñerraʼm esempo amaʼt puesheñarra acheñ ñeñt̃ atarr ochñat̃paʼ oʼch cot̃apeʼcherret ello eʼñe cohuen Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Elloña Jesúspaʼ alla tomaʼntaterraneterr, ñeñt̃paʼ atet̃ oterraneterr: —Eñall puesheñarr acheñ echenan epsheña puechemer. ");
INSERT INTO ameNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ñeñt̃ña puechoyomer penpaʼ atet̃ otan pompor: “Apachaʼ ñeñt̃ ora allpon pechen t̃eʼ napaʼ nemneñ oʼch p̃apuen eʼñe t̃ayecma ñeñt̃ allpon p̃oʼpatatenna.” Allempoña pompor ora ñeñt̃ allpon echyenpaʼ oʼ apaʼyesan epsheñoʼmar puechemereshaʼ ñeñt̃ allpon oʼpatatyenanet eʼñe puesheñaʼttset. ");
INSERT INTO ameNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Eʼñe allponmatatsa ñeñt̃ña puechoyomer penpaʼ oʼ eʼñe pomhuahuanman ora allohuen ñeñt̃ allpon ap̃ pompor allo agapan shonteʼ quelle att̃och ta b̃ac̈hayo poʼpoñ anetso. Allempoña c̈hap b̃ac̈hayopaʼ allñapaʼ sosyaʼtsañec̈hna atet̃ p̃aʼyesos. Att̃oña amaʼt shonteʼ poʼc̃llayor ñeñt̃ anem oʼ eʼñe aʼgastaʼhuahue eʼñe pottatseʼteñot̃. ");
INSERT INTO ameNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Oʼ eʼñe aʼgastaʼhuan ora poʼc̃llayorpaʼ allempoña allpaʼ oʼ orrta muec̈heñets all ñeñt̃e anetsro. Ñañapaʼ oʼhuañ errayeʼ entan puerrar ñeñt̃chaʼ rren. ");
INSERT INTO ameNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Allempoña ñapaʼ oʼ ahuoʼ alloʼtsen aneʼtañ all eʼnyenan taruas. Aneʼtaññapaʼ aña ap̃ poʼtaruas oʼch auyesos aʼyenet̃ allchaʼ cohuam̃pesyesoñ poʼchañchor. ");
INSERT INTO ameNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ña paʼchporrñot̃paʼ atarr mueneñ oʼch rrapretosan chañcho puerrar att̃och yetosa. Amaʼt chañchopaʼ paʼtalleʼtsa puerrar pen ñapaʼc̈hoʼña ñeñt̃aña atarr muenen oʼch rros t̃arraña amaʼt chañcho ama eseshayeʼ apuenaye puerrar ñeñt̃chaʼ rraʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Att̃eñapaʼ machayot̃a c̈hapoña pueyoc̈hro, atet̃ ot: “Apa paʼtaruasañer amaʼt shontetpaʼ echyenet puerrar, ello puechareʼtyena. Naña arrpaʼ oʼ nerromuerrmoch nachporrñot̃. ");
INSERT INTO ameNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","T̃eʼpaʼ oʼch ahuerren apuesho; t̃eʼ napaʼ atet̃chaʼ notuer: Apachaʼ napaʼ oʼ nep̃ohua ñeñt̃ ama cohuenayaye Yomporecop amaʼt ñam̃a p̃ocop. ");
INSERT INTO ameNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Napaʼ ama cohuenayayno att̃och pechemer pep̃apuerren. T̃eʼ napaʼ aña poctetsa nocop p̃apaʼ p̃aʼtaruasañrach pep̃apuerren.” ");
INSERT INTO ameNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Oʼña atet̃ cot̃apeʼchua ello eʼñe cohuen Yomporecoppaʼ allempoñapaʼ ahuen pomporesho. ’Amaʼt atarr ellap̃armeñ allempo entapueñ pompor eʼñe puemuereñot̃ mata poctapueñpaʼ aʼc̈honoʼtapueñ, tsoʼtstsapaʼtapueñ. Ñeñt̃paʼ atet̃ huom̃chaʼtapuenan puechemer att̃o eʼñe cohuen agapapueñ. ");
INSERT INTO ameNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Puechemerñapaʼ atet̃ otueñ: “Apachaʼ napaʼ oʼ nep̃ohua ñeñt̃ ama cohuenayaye Yomporecop amaʼt ñam̃a p̃ocop. Na t̃eʼpaʼ ama cohuenayayno att̃och pechemer pep̃apuerren.” ");
INSERT INTO ameNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","T̃arraña pomporñapaʼ eʼñe allorocma otan pueñañreshac̈hno: “Oʼch senaʼ eʼñe t̃ayecma shetamuets ñeñt̃ atarr cohuen coc̈hneshaʼ, oʼch sechorratapuennana nechemer. Oʼch senatapueñ ñam̃a anillo potap̃o, oʼch senatapueñ ñam̃a sapatets paʼtco. ");
INSERT INTO ameNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Oʼch sennanaʼ ñam̃a nehuacsher ñeñt̃ atarr neʼsoyaʼtaten oʼch semtse oʼch yerrallmeʼch oʼch yocshameʼtam̃p̃sapueña. ");
INSERT INTO ameNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","T̃arroʼmar añ nechemer amaʼt oʼ rromhuañ, t̃eʼñapaʼ oʼ alla tanterra. Amaʼt oʼ chencaʼhuañpaʼ t̃eʼñapaʼ oʼ alla nenter.” Allempoñapaʼ atarr nanac coshameʼtam̃p̃sapueñet. ");
INSERT INTO ameNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Ñehua, poʼpsheñeñ puechemer ñeñt̃ popoʼnar ñañapaʼ paʼmroʼtsen allempo c̈hen puechoyomer. Allempoña err paʼmrot̃ eʼñe yaʼrroterrtsa pocollopaʼ oʼ eʼmhuerran cosham̃ñats all requërquënet ñam̃a asheʼrarañ. ");
INSERT INTO ameNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Allempoñapaʼ c̈horeʼtuerran cheshachorpaʼ aʼp̃t̃oʼtuer: “¿Esoʼmareʼtña coshameʼtenet? ¿Esoʼtña atarr coshameʼtam̃penet? ");
INSERT INTO ameNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Cheshachorñapaʼ atet̃ otapuer: “Oʼ huena pemoʼnasheñ, p̃omporpaʼ oʼ muetsatan becer ñeñt̃ seʼsoyaʼtaten t̃arroʼmar atarr coshapuenana puechemer. Ama c̈hoyeʼ rromueno, eʼñe huomech agapapueñ.” ");
INSERT INTO ameNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ñañapaʼ ñeñt̃a atarr atsrreʼmatuerreʼ ama mueno oʼch beʼt̃osuerr all oʼ c̈hen paʼmoʼnasheñ. Att̃eñapaʼ c̈haʼnom pomporpaʼ allach otereʼt̃: “Pebeʼt̃osuerr.” Ñañapaʼ ama mueno oʼch beʼt̃osuerr. ");
INSERT INTO ameNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ñañapaʼ atet̃ otuerran pompor: “Napaʼ peñotenen oʼ shonteʼ char eʼñe cohuen nameʼñenp̃a; napaʼ amaʼt parrochapaʼ ama esempo nat̃pareʼtenpe. T̃arraña amaʼt atet̃ nepenpeñpaʼ nañapaʼ amaʼt esempapaʼ ama p̃apuennoña amaʼt pat̃rra cabra att̃och nocshameʼta nam̃a epan ñeñt̃ parro neyemuetyena na. ");
INSERT INTO ameNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","T̃eʼña oʼ huena ñeñt̃ pechemermaʼt̃ pepen amaʼt ora oʼ aʼgastaʼhuonap̃ pec̃llayor eʼñe puecañoreshaʼteñot̃, t̃eʼña p̃apaʼ oʼ pemtsatapueñ becer ñeñt̃ yeʼsoyaʼtaten.” ");
INSERT INTO ameNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Pomporñapaʼ atet̃ otererr: “Poʼñoc̈h nechemerchaʼ p̃apaʼ c̈hocma arroʼtseney parro. Amahuacaʼye nechemerchaʼ peñoteñet̃eʼ ñeñt̃ allpon nechenpaʼ eʼñerramcheʼ p̃ocma. ");
INSERT INTO ameNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ñeñt̃oʼmarña t̃eʼpaʼ añ poctetsa oʼch yocshameʼtam̃p̃sapueña pemoʼnasheñ, oʼch atarr nanac yocshena t̃arroʼmar amaʼt oʼ rromhuañ t̃eʼñapaʼ oʼ alla tanterra; amaʼt oʼ chencaʼhuañ t̃eʼñapaʼ oʼ alla yenter.” ");
INSERT INTO ameNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Elloña Jesúspaʼ alla tomaʼntaterranerr pueyochreshaʼ, ñeñt̃paʼ atet̃ serrpareʼtaterraneterr: —Eñall yacma puesheñarr ñeñt̃ atarr ec̃llayoret̃. Ñapaʼ echenan paʼcheñer ñeñt̃ poʼtaruas peneʼ oʼch cohuam̃p̃san ora allpon ñeñt̃ echyen pamoʼmteʼ. Ñam̃a ñach quellquëneʼ poʼpotantañ ñeñt̃ allpon teb̃aʼyeññañet pamoʼmteʼ. Att̃eña allempoña puesheñaʼtets acheñeneshaʼpaʼ aʼmet̃am̃peñetaʼ pamoʼmtayesho, atet̃ otoñet pamoʼmteʼ: “Oʼcaʼye att̃a aʼchencatatsreʼtap̃ña ñeñt̃ penen ñeñt̃chaʼ pecuam̃p̃satsreʼteneʼ.” ");
INSERT INTO ameNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Allempoña pamoʼmteʼ atet̃ eʼmareʼchpaʼ allent̃a agotach. Allempoña huapapaʼ atet̃ otap̃: “Esoʼmaruañacaʼyeña atet̃ p̃aʼchencatatsreʼtenen. T̃eʼpaʼ oʼch peñotatnomuen eʼñe ora allohuen ñeñt̃ allpon petaruasen t̃arroʼmar t̃eʼpaʼ ama nemno oʼch alloʼna pecuam̃p̃satsreʼtenen.” Oʼ atet̃ otue pamoʼmteʼ, ñañapaʼ allent̃a ahuerr. ");
INSERT INTO ameNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Allempoña paʼtaruasañer ñapt̃opaʼ atet̃ cot̃apeʼchen: “T̃eʼpaʼ amach alloʼna netaruasaʼneno namoʼmtayesho; oʼcaʼye mopaʼtam̃perrenña allo neganena. T̃eʼpaʼ errot̃enuachñacaʼye nep̃at̃eʼ. Napaʼ ama necheno nehuamenc att̃och namreʼt ñeñt̃chaʼ netaruas neperreñ, ñam̃a ama nemno oʼch netaruas nep̃aʼ oʼch att̃a nenamareʼtyen quelle atet̃ p̃aʼyena poʼpsheññec̈hno ñeñt̃ poʼtaruas peneʼ oʼch enamareʼtyeset quelle, t̃arroʼmar na ñeñt̃paʼ atarr apencoc̈hen nenteñ.” ");
INSERT INTO ameNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Allempoña oʼ eʼñe cot̃apeʼchuepaʼ atet̃ ot: “T̃eʼña poʼñoc̈hpaʼ oʼcaʼye neñoch atet̃chaʼcaʼye nep̃a att̃och acheñeneshaʼpaʼ eʼñech cohuen agapnet paʼpacllo tsapat̃onet̃ allempoch huañ nec̃llayor ñeñt̃ allpon naguën t̃eʼ netaruasot̃.” ");
INSERT INTO ameNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Allempoña atet̃ cot̃apeʼchenpaʼ atet̃c̈hoʼ p̃a. Ñeñt̃oʼmarña agotatan allohuen allponsheña ñeñt̃ teb̃aʼyets pamoʼmtayesho. Eʼñe puesheñaʼttsa ñanom aʼp̃t̃oʼtyesap, atet̃ otapanet: “P̃apaʼ ¿errponaʼt petebeñña namoʼmteʼ?” ");
INSERT INTO ameNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ñañapaʼ atet̃ otos: “Napaʼ netebeñcaʼye c̈harroch c̈harraʼ cilindro aceiteʼ.” Ñeñt̃ patron paʼcheñerñapaʼ ap̃ allo quellquëññañ ñeñt̃ allpon teben ahuat̃ot̃eñ. Allempoñapaʼ atet̃ otererr: “T̃eʼpaʼ oʼch p̃anorr t̃ecmapaʼ oʼch peʼsherrña ñeñt̃ c̈harroch c̈harraʼ cilindro oʼch pequellquërr amnaroch c̈harraʼ oʼcaʼye allponam̃aña ñeñt̃ peteben.” ");
INSERT INTO ameNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Allempoñapaʼ oterranerr ñam̃a poʼpsheñeñ: “P̃apaʼc̈hoʼña ¿errponaʼt petebeñña namoʼmteʼ?” Ñañapaʼ atet̃ otos: “Napaʼ netebeñ c̈harroch c̈harraʼ arroga trigo.” Ñeñt̃ patron paʼcheñerñapaʼ ap̃ ñam̃a allo quellquëññañ ñeñt̃ allpon teben ahuat̃ot̃eñ allempoña ñapaʼc̈hoʼña atet̃ otererr: “P̃apaʼc̈hoʼña p̃anorr t̃ecma oʼch peʼsherrña ñeñt̃ c̈harroch c̈harraʼ arroga oʼch pequellquërr poscoch c̈harraʼ; t̃eʼpaʼ oʼcaʼye allponam̃aña ñeñt̃ allpon petebeñ namoʼmteʼ.” ");
INSERT INTO ameNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Allempo pamoʼmteʼ eñotan ñeñt̃ paʼtaruasañer att̃a shecareʼteñ, ñañapaʼ atet̃ oten: “Añ acheñer amaʼt pueshquëñot̃paʼ eʼñe eñoteñ oʼch entan ñeñt̃chaʼ atarr sherberreʼ ñocop tsapat̃onet̃.” Poʼñoc̈h acheñeneshaʼ arr patsro ñeñt̃ ama ameʼñetso ñetñapaʼ atarr eñoteñet att̃och eʼñech aña eʼnenet ñeñt̃chaʼ atarr sherberrets ñocpuet tsapat̃onet̃. T̃arraña ñeñt̃ña ameʼñetsapaʼ ama tama eñoteñeto, ama es cot̃apeʼcheneto oʼch eʼnenet ñeñt̃chaʼ atarr sherberrahuet ñamet tsapat̃onet̃. ");
INSERT INTO ameNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Ñeñt̃oʼmarña t̃eʼpaʼ oʼch notenes: —Ñeñt̃ allpon paʼnamen sechyen sec̃llayorohuen ñeñt̃paʼ añecpuepaʼchña sherbenes alloch seyenpueñ poʼpotantañ allochñapaʼ att̃ochña eʼñech cohuen muererrset. Sapaʼ añecpuepaʼchña setaruasatña sa sec̃llayor ñeñt̃ atarr sherbets Yomporecop amaʼt yeñoteñ quellepaʼ atarr aʼgastaʼpoʼ amaʼt ñam̃a añecop ñeñt̃ ama pocteyeʼ enteno Yompor. Allochñapaʼ eñallchaʼ socop ñeñt̃chaʼ eʼñe cohuen sagüerreʼ eʼñe all Yomporepahuo esempoch sec̈hac̈herr all, allempopaʼ oʼhuañchaʼ alloʼna sherbenes quelle ñeñt̃ patsoʼmarecpa. Att̃och allohuenes eʼñech cohuen socrraʼhuerra Yomporepahuo ñeñt̃paʼ ama ahuañaño. ");
INSERT INTO ameNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Elloña oʼch notas: —Amaʼt eʼñe coñeʼt̃a yechen ñerraʼm añecop yesherb̃ateñ ñeñt̃ cohuen enten Yompor, ñañapaʼ eñoteney atet̃ ñerraʼm amaʼt atarr aton yechen att̃erach yesherb̃ateñ ñocop. T̃arraña amaʼt eʼñe coñeʼt̃a yechen ñerraʼm ama añecpayeʼ yesherb̃ateñe ñocop, ñañapaʼ eʼñech eñoteney att̃oña amaʼtchaʼ atarr aton yecheneñpaʼ att̃erach amach es yesherb̃ateñe ñocop. ");
INSERT INTO ameNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ñam̃a amaʼt eʼñe allpona quelle yechen arr patsro amaʼt eʼñe patsoʼmarecpa t̃arraña ñerraʼm ama añecop yesherb̃ateñe ñeñt̃ cohuen enten Yompor allempopaʼ amach errot̃enot̃ alla apuerryerroña ñeñt̃ poʼñoc̈h atarr sherbets ñeñt̃ apueney ña. ");
INSERT INTO ameNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ñam̃a ñerraʼm ama es yesherb̃ateññañe ñeñt̃ poʼpsheñño atet̃ ñerraʼm ñeñt̃ Yomporo, allempopaʼ amach errot̃enot̃ apyeña ñam̃a ñeñt̃ eʼñe yocop ñeñt̃chaʼ eʼñe cohuen yocshateneʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Ñeñt̃paʼ atet̃chaʼ netmaʼntacha: —Amaʼt puesheñarrot̃eyapaʼ amach errot̃enot̃ eʼñe cohuen yetaruasoña epsheñoʼmar yamoʼmtayecop. T̃arroʼmar ñerraʼm atet̃ yep̃apaʼ puesheñarr eʼñech cohuen yemorrenteñot̃ yocsheñeshocmañen yesherbeñ, poʼpsheñeññapaʼ amach eʼñeyeʼ yemorrenteño; c̈hach yottena ñerraʼm c̈ha yetsenaʼteñ. Ñeñt̃oʼmar atet̃paʼ amach cohuenayeʼ yesherbeñe. Ñerraʼm aña eʼñe semaʼyoc̈hrena ñeñt̃ eʼñe socpa att̃och segana aton quelle, ñeñt̃ atet̃paʼ amach errot̃enot̃ semaʼyoc̈hroña ñam̃a añecop ñeñt̃ atarr sherbets Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Añña fariseoneshaʼ ñeñt̃ eʼmueneʼ Jesús ñeñt̃ atet̃ serrpareʼtatenan acheñeneshaʼ, ñetñapaʼ aña atarr yeʼchapretenet quelle. Ñeñt̃oʼmarña ñet allempopaʼ puesasareʼteñot̃et Jesúspaʼ c̈ha atarr cheʼtatseteñet. ");
INSERT INTO ameNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesúsñapaʼ atet̃ otanet: —Sapaʼ c̈ha sottenañ ñerraʼmrrat̃eʼ atarr cohuensoñ att̃oña acheñeneshaʼpaʼ eʼñe cohuen entyensetañ. T̃arraña Yomporñapaʼ eʼñe eñotennas seyoc̈her ñeñt̃ att̃o sapaʼ atarr seshcareʼtyeñ acheñeneshaʼ. T̃arraña ñeñt̃ eʼñe ñañeñeta atarr cohuen entyetset arr patsro, ñetñapaʼ atarr tsenaʼtenanet Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Allempoña Jesúspaʼ atet̃ serrpareʼtaterranerr acheñeneshaʼ poʼpoñonet̃: —Añña ñoñets Moisés poʼñoñ ñeñt̃ atet̃ anaret̃ ñam̃a añ ñoñets ñeñt̃ quellcaʼyeseʼt̃ ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ, ñetpaʼ ñeñt̃a eʼñe serrpareʼteteʼt̃ t̃arrempohua allempo orrtosa Juan. Allempoteñ serrpareʼtatosanet Juanpaʼ ñapaʼ añ serrpareʼtatosanet atet̃ penaña Yompor poʼcohuenña att̃o atarr ayochreshat̃tena ña, ñeñt̃ara cohuen ñoñets alloch sequeshperra. Ñam̃a allohuen acheñeneshaʼ eʼñe pueyoc̈hrocmañenet ñeñt̃a atarr muenenet. ");
INSERT INTO ameNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’T̃arraña amaʼt att̃eñpaʼ ñeñt̃ atet̃ anaret̃ Yompor poʼñoñ amaʼt pat̃rra quellec pueshempot̃ollohuenpaʼ amach chenquërro. T̃arroʼmar Yompor poʼñoñpaʼ amach errot̃eno yaʼhuañatere ñeñt̃ att̃o sherbeney. Patsña epuet enet ñeñt̃paʼ huañerrchaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Ama aʼhuañatpahuoyaye Yompor poʼñoñ ñeñt̃ atet̃ yoteneʼ ama asaʼpahuo yet̃apor t̃arroʼmar ñerraʼm eseshaʼ serreʼ puet̃apor oʼch yorerran poʼpsheñeñ coyaneshaʼ ñeñt̃chaʼ puet̃apor perretpaʼ ñeñt̃ñapaʼ c̈hach ochñaʼtam̃perrana puet̃aporesheʼmañ; ñeñt̃paʼ ama cohuenayeʼ enteñe Yompor. Ñam̃a ñeñt̃chaʼ yorerreʼ coyaneshaʼ asaret̃, ñeñt̃ yacmarpaʼ c̈hach chetapreten t̃aporets; ñeñt̃paʼc̈hoʼña ama cohuenayeʼ enteñe Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Elloña Jesúspaʼ atet̃ serrpareʼtatanet: —Eñall puesheñarr ñeñt̃ atarr ec̃llayoret̃ ñeñt̃ chorrenaya shetamuets atarr coc̈hneshareʼ ñeñt̃ atarr cohuen apomotyesaret̃. Epayeʼ coshatseʼtatyeñ ñeñt̃ allpon echyen. Eʼñe pocsheñot̃paʼ eʼñe ellapeneʼt̃ rrallmeʼchats. ");
INSERT INTO ameNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Eñall ñam̃a puesheñarr ñeñt̃ atarr huocchañetets ñeñt̃ñapaʼ c̈ha ora puetsaren, ñeñt̃paʼ añ paʼsoʼcheñ Lázaro. Ñañapaʼ allach ellapeneʼt̃ aʼyot̃ yetarrot̃ allot̃ecma beʼt̃en ec̃llayoret̃ paʼpacllo. ");
INSERT INTO ameNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ñapaʼ añach atarr yeʼchena oʼch rraʼyesan amaʼt coñet̃aʼttsa rreñets ñeñt̃ aʼshoreʼtatyen ec̃llayoret̃ poʼmesap̃nac̈ho. Allña ochecpaʼ oʼch huapoña oʼch tsoʼnaʼteññañaʼ pueptsarña. ");
INSERT INTO ameNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Att̃eña oʼ c̈hap pamt̃arr allempo rroma ñeñt̃ huocchañneshar. Oʼ rroma mellañot̃eñneshaʼña huac̈haʼtapaʼ oʼ aneret eʼñe Abrahamuesho, allñapaʼ oʼ c̈hapachet atarr cosheñtso. Att̃eñapaʼ c̈hap allempo rroma ñam̃a ñeñt̃ atarr ec̃llayoret̃, ñeñt̃ñapaʼ pampueñetaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ñañapaʼ alla c̈hap coñchaʼpuetso ñeñt̃ oʼpatenaya ñeñt̃ rromuets ñeñt̃ ama ameʼñetso. Allñapaʼ atarr mueroc̈htosa all coñchosa. Att̃eñapaʼ cohuaʼ enonet̃paʼ allot̃ña entosan Abraham allap̃aroʼtsen ento. Allñapaʼ alloʼtsen epuet Lázaro. ");
INSERT INTO ameNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ñeñt̃ña ec̃llayoret̃ allent̃a c̈horeʼtan Abraham, ñeñt̃paʼ atet̃ och: “Nompore Abrahama pemuerayeʼchna, pemñayeʼchon Lázaro oʼch huapa arr att̃och eshaʼtosan potap̃ oño, amaʼt potap̃ot̃apaʼ oʼch onenapnaʼ oñ att̃och aʼyamoserraponaʼ neñeñ oʼ eʼñe neporrarraʼnmahuap. Atarr nanac oʼ nemueroc̈htosa arr tso.” ");
INSERT INTO ameNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abrahamñapaʼ atet̃ och: “Nechemerñechaʼ t̃eʼpaʼ oʼch peyerposa ora allpon paʼnamen ñeñt̃ pechyeseʼt̃ ñeñt̃ atarr coc̈hneshareʼ pentyeseʼt̃ allempo p̃ocrreʼt̃ patso. Lázaroñapaʼ ama es echeʼt̃e amaʼt coñeʼt̃a ñeñt̃ atarr cohuen enten ñam̃a. T̃eʼña ñapaʼ oʼ atarr acshataret̃terra, p̃añapaʼ oʼ atarr p̃aʼcoñchataret̃terra. ");
INSERT INTO ameNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Elloña t̃eʼpaʼ amaʼt eʼñe eseshapaʼ amach errot̃enot̃ c̈hapam̃p̃sapeto alloʼtsenep̃ t̃arroʼmar p̃apaʼ atseret̃oʼtsenp̃a yom̃taʼn. Sapaʼc̈hoʼña t̃eʼpaʼ amaʼt eʼñe puesheñarrot̃esapaʼ amach errot̃enot̃ sec̈hapam̃pesyo yam̃a. Amat̃eʼ errot̃ yepereʼt̃e ñeñt̃paʼ atet̃ anaret̃ att̃och yelloʼtsentataret̃terra.” ");
INSERT INTO ameNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Allempoña ec̃llayoret̃paʼ atet̃ oterranerr Abraham: “T̃arraña amaʼt att̃eñ nomporepaʼ t̃eʼpaʼ oʼch notap̃ oʼch pemñer Lázaro all patsro nompor paʼpacllo. ");
INSERT INTO ameNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","T̃arroʼmar all napaʼ nechen amnarsheña nemoʼnasheñ. Ñeñt̃oʼmarña nemneñ oʼch ahuerr oʼch cot̃apeʼchaterranetaʼ eʼñe cohuen t̃eʼt ñetpaʼc̈hoʼña esempopaʼ alla c̈hapuet arr coñchaʼpuetso.” ");
INSERT INTO ameNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrahamñapaʼ alla otererr: “Ñetpaʼ echenet Yompor poʼñoñ ñeñt̃ quellquëʼt̃ Moisés ñam̃a allohuen ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ ahuat̃. T̃eʼpaʼ eʼm̃ñoterrñañetepaʼ Yompor poʼñoñ ñeñt̃ echenet.” ");
INSERT INTO ameNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ñañapaʼ atet̃ oterranerr Abraham: “Ñatoʼ amach eʼm̃ñoterrñañeto Yompor poʼñoñ, t̃arraña nompore Abrahama ñerraʼm eseshaʼ tanterrtsa rromot̃ ñeñt̃chaʼ orrterrahuet allempoñapaʼ poʼñoc̈h ñeñt̃chaʼña cot̃apeʼchaterrahuet ello eʼñe cohuen Yomporecop.” ");
INSERT INTO ameNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abrahamñapaʼ alla otererr: “Ñerraʼm amach eʼm̃ñoterrñañeto Yompor poʼñoñ ñeñt̃ atet̃ quellquëʼt̃ Moisés ñam̃a allohuen ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ ahuat̃, t̃eʼña amaʼt eseshaʼch tanterrtsa rromot̃paʼ amach eshec c̈hapanetoña pueyoc̈hreto att̃och cot̃apeʼcherret ello eʼñe cohuen Yomporecop.” ");
INSERT INTO ameNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Allempoña Jesúspaʼ alla serrpareʼtaterranerr pueyochreshaʼ, ñeñt̃paʼ atet̃ otanet: —C̈hocmach huaponaya ñeñt̃chaʼ yetpatyeneʼ oʼch atet̃ p̃atey ñeñt̃ ama pocteyeʼ enteno Yompor. T̃arraña napaʼ oʼch notas, atarrchaʼ yoroc̈henoʼtsen amaʼt erraʼtsena acheñer ñeñt̃ orrtateneʼ ñeñt̃chaʼ topatyeneʼ poʼpsheñeñ ñeñt̃ nameʼñenaya oʼch atet̃ p̃atyenanet ñamet ñeñt̃ amaʼt mamesha ama pocteyeʼ enteno Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Amaʼt ñeñt̃ eʼñe errteʼ nameʼñenaya ñerraʼm eseshaʼ oʼch orrtatanet att̃och oʼch atet̃ p̃atachet ñeñt̃ ama pocteyeʼ enteno Yompor, ñeñt̃ña acheñerpaʼ atarrchaʼ yoroc̈henoʼtsen t̃arroʼmar ñapaʼ aña oʼpatenaya coñcheñets ñeñt̃ atarr huomenc. Amaʼt ñocoppaʼ ama tama yoroc̈henayayñe ñerraʼm ama atet̃ p̃atenanaʼ poʼpsheñeñ, eʼñech allorocma c̈harachetañ mapueʼ añecmuen paʼc̈hnop̃o allpon ñerraʼm puetseʼtamets oʼch huaporeʼchet oño epo allchaʼ ñoʼshach mapueʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ñeñt̃oʼmarña sapaʼ eʼñech señota, amach sorrtatatsto att̃och saʼshoratach poʼpsheñeñ amaʼt erraʼtsena. ’Elloña napaʼ oʼch alla noterrserr, ñerraʼm esempo samoʼts errot̃ p̃onas sa ñeñt̃ ama pocteyeʼ enteno Yompor, socoppaʼ añ poctetsa oʼch soct̃apeʼchater eʼñe cohuen oʼch p̃oter ñeñt̃ atet̃ oʼ p̃ohuonap̃paʼ amaʼt mameshapaʼ ama pocteyeʼ enteñe Yompor. Allochñapaʼ ñerraʼm oʼch alla cot̃apeʼcherran cohuen Yomporecop, sañapaʼ añ poctetsa oʼch alla eʼñe cohuen sep̃retner. ");
INSERT INTO ameNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Amaʼtchaʼ atonocheʼtats atet̃ penset, amaʼtchaʼ pamt̃arrpaʼ canc̈hrrocheʼtatschaʼ atet̃ penset ñerraʼm oʼch alla llequërrana ñeñt̃ atet̃ pennaset, ñerraʼm amaʼt pamt̃arr canc̈hrrocheʼtats oʼch alla oterrset: “Napaʼ oʼ atet̃ nep̃onap̃ ñeñt̃ ama pocteyaye t̃arraña t̃eʼña ellopaʼ amach alla atet̃ neperreʼt̃e”, socoppaʼc̈hoʼña añña eʼñe poctetsa oʼch alla eʼñe cohuen sep̃retner ñeñt̃ atet̃ sepeneʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Allempo atet̃ otaret̃tenet añña puellsensarneshaʼñapaʼ atet̃ ochet Poʼpartsesharet Jesús: —Elloña yapaʼ ahuamencat̃chaʼ pep̃aʼy allochñapaʼ eʼñech cohuen yeyemterrp̃a. ");
INSERT INTO ameNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Partseshaʼñapaʼ alla oterraneterr: —Ñerraʼm poʼñoc̈h eʼñe na seyemtenañ napaʼ eʼñecaʼye naʼpoctatenña neñoñ ñeñt̃ atet̃ notenes, amaʼtchaʼ allponat̃ollot̃a seyemtenna ñerraʼmrrat̃eʼ mostazllomet̃oll, sañapaʼ amaʼt erraʼtsena senamuennoñ amaʼt ñeñt̃ atarr echarr sentenpaʼ nañapaʼ atet̃chaʼ nepennaseñ. Oʼch netmaʼntatasa atet̃ ñerraʼm oʼch sot añ tsachecop sicómoʼrech: “Beraʼnmuepaʼch arrot̃ all t̃en, arrepaʼchña t̃omhuerrerr aʼyo saʼpo”, tsachñapaʼ atet̃chaʼc̈hoʼña p̃añ eʼñe atet̃ soteñ. ");
INSERT INTO ameNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ellopaʼ alla tomaʼntaterraneterr, ñeñt̃paʼ atet̃ oterraneterr: —Ñerraʼm eseshas echeneʼ saʼtaruasañer, ñatoʼ ñapaʼ ellapeneʼt̃chaʼ llampueʼ sechamuelleñ amapaʼ ñatoʼ ellapeneʼt̃chaʼ cohuam̃peneʼ sayarac̈hno ellerronet̃ña allempoch huerra poʼtaruasot̃paʼ sañapaʼ amaʼt puesheñarrot̃esapaʼ amach sotapuereña señañra: “T̃eʼpaʼ oʼch pebeʼt̃osuerr oʼch yerrallmeʼchnen parro.” ");
INSERT INTO ameNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Elloña ñeñt̃apaʼ oʼchc̈hoʼ alla sotapuererr: “T̃eʼñapaʼ oʼch peptareʼtuerren ñeñt̃chaʼ nerraʼnen, allot̃ñapaʼ oʼch p̃aʼcohuenetuerr peshtam att̃och eʼñe cohuen pesherb̃aʼhuerren c̈hop̃chaʼña naphuerreʼ nerrar ñeñt̃chaʼ nerraʼnen. Oʼchña nerruanen napaʼ allempoñapaʼ c̈hop̃chaʼña rrallmeʼchnets p̃am̃a.” ");
INSERT INTO ameNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Amaʼtña sapaʼ atet̃caʼye sepena. Ñam̃a saʼtaruasañer ñerraʼm esempoch eʼnuan ora poʼtaruas ñeñt̃ seyecheña, sañapaʼ amaʼt puesheñarrot̃esapaʼ amach sotereña: “Parasyos oʼ peʼnuon netaruas.” Amaʼt ama atarr socshateñe ñeñt̃paʼ eʼñe pocteʼ ñocop t̃arroʼmar ñapaʼ allpona oʼ eʼnua ñeñt̃ allpon seyecheña. ");
INSERT INTO ameNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Sapaʼc̈hoʼña Yompor paʼtaruasañer sepeneʼ. Ñam̃a amaʼt allempoch setsotuen ora allohuen ñeñt̃ atet̃ otenes Yompor att̃erepaʼchña sentena ama atarr atonayeʼ sesherbeno. Aña setsoten ñeñt̃ eʼñe poctetsa allohuen añecop ñeñt̃ paʼtaruasañer pen Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Allempo sechena Jesús Jerusaléño arr oñem allohua temuena Samaria epuet Galilea. ");
INSERT INTO ameNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Allempoñapaʼ c̈hap pat̃err anetso. Allñapaʼ huac̈haʼtoña c̈harrasheña ñeñt̃ osyen puetsarñats ñeñt̃ otenet lepra. Ñeñt̃ña aptsarñat̃ec̈hno aʼyot̃a t̃omc̈haʼtyesoset. ");
INSERT INTO ameNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ñetñapaʼ allot̃ña rranareʼtyesosetpaʼ atet̃ ochet Jesús: —Maestro Jesúsochaʼ pemuerayeʼchosya yam̃a. ");
INSERT INTO ameNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesúsñapaʼ allent̃a cohuosanetpaʼ atet̃ otosanet: —T̃eʼpaʼ oʼch ahues oʼch segatyenaʼ sañeña judioneshaʼ poʼcornanesharesho att̃och ñetpaʼ oʼch eñotaset t̃eʼpaʼ oʼ socrrerra. Atet̃ otanet Jesús, ñetña ahuanmatsetpaʼ eʼñe allorocma acrraʼyesuerrochet. ");
INSERT INTO ameNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Puesheñarrña allempo eñota oʼ correrrapaʼ alla puetallerrapaʼ oʼ alla ahuerr Jesúseshonet̃ atarr nanac pocsheñeshaʼ ayeʼchoc̈htatnerran Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Eʼñe pueparasyosoʼteñeshaʼ rromosa Jesús paʼrrp̃ot̃. Ñehua, ñeñt̃ atet̃ p̃atsapaʼ ñeñt̃paʼ ñeñt̃ña samarioʼmarneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Allempoña Jesúspaʼ atet̃ otan acheñeneshaʼ ñeñt̃ alloʼtsaʼyen: —Amaʼt c̈harrasheña ñeñt̃ oʼ naʼcrratyesua t̃eʼ. ¿Poʼpotantañña esconsheñapaʼ? Ñetñapaʼ ama es yerpaʼpesnomayeña att̃och ayeʼchoc̈htatoñet Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Eʼñe puesheñarraña ñeñt̃ puerrerrtsa att̃och atarr ayeʼchoc̈htatan Yompor amaʼt ñapaʼ ama judioneshayaye. ");
INSERT INTO ameNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Allempoña Jesúspaʼ atet̃ otan ñeñt̃ aʼcrraterr: —T̃eʼñapaʼ oʼch petanterra, eʼñech cohuen peserr t̃arroʼmar p̃apaʼ eʼñe peyemteñot̃en na oʼ p̃ocrrerra. ");
INSERT INTO ameNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parrochña fariseoneshaʼpaʼ aʼp̃t̃oʼchet Jesús: —¿Esempoʼtchaʼ orrterraña Yompor poʼcohuenña allempoch atarr am̃chaʼtaret̃terra ña? Jesúsñapaʼ atet̃ otanet: —Yompor poʼcohuenña att̃o ayochreshat̃tena ñapaʼ ñeñt̃paʼ ama att̃eyaye ñerraʼmrrat̃eʼ ñeñt̃ es yentyen yeclloyot̃. ");
INSERT INTO ameNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ñeñt̃oʼmarña amach errot̃enot̃ oteto: “Arrcaʼyeña am̃chaʼtaret̃tenaña Yompor”, amapaʼ “T̃arrocaʼyeña am̃chaʼtaret̃tenaña Yompor.” T̃arroʼmar Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ñapaʼ ñeñt̃paʼ oʼcaʼye mot̃etnoma orrtatsa eʼñe sesho amaʼt seyoc̈hro. ");
INSERT INTO ameNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Elloña ñapaʼ atet̃ oterranerr pueyochreshaʼ: —C̈herrchaʼ esempohuañen allempoch atarr seʼnerren atarrchaʼ semnerren Ñeñt̃en Acheñetostseʼt̃ oʼch norrterrnasa amaʼt eʼñe pamt̃arra. T̃arraña amaʼt eʼñe allempa amach senterrno. ");
INSERT INTO ameNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Saña allempopaʼ atet̃chaʼ otasetañ: “T̃eʼpaʼ oʼ orrterraña Cristo alloʼtsencaʼye”, amapaʼ “T̃arroʼtsencaʼyeña Cristo.” Sañapaʼ amach setatstoña all, amach soct̃atscheña ñeñt̃ sets all. ");
INSERT INTO ameNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","T̃arroʼmar ñerraʼm esempo c̈herr allempoch nohuerra na Ñeñt̃en Acheñetosets eʼñe allohuen acheñeneshaʼpaʼ eʼñech entuapuerrnet t̃arroʼmar allempopaʼ atet̃chaʼ perra ñerraʼmrrat̃eʼ meratsteʼ, oʼch meratsta huomencpaʼ eʼñech aʼpuetaresuan ora enet errap̃aren. ");
INSERT INTO ameNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ñehua, na t̃eʼ ñeñt̃ atet̃ anaret̃ nocop ñanompaʼ atarrchaʼ naʼmueroc̈htataret̃ta, amaʼt namoʼtseshaʼ ñeñt̃ corretsa t̃eʼpaʼ amach eseshayeʼ naguënaye. ");
INSERT INTO ameNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","T̃arraña allempoch nohuerra poʼpocheño na Ñeñt̃en Acheñetosets, allempopaʼ eʼñech atet̃ perret eʼñe atet̃ peteʼt̃ ahuat̃ allempo correʼt̃ Noé. ");
INSERT INTO ameNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Allempopaʼ ama es puec̈haʼyeneto aña eʼñe cot̃apeʼcheteʼt̃ att̃o atarr paʼnamen muenenet ñeñt̃chaʼ rraʼyenet, orrareʼtyeseteʼt̃, senaʼtanatyena yacmaneshac̈hno, coyaneshac̈hnopaʼc̈hoʼña apanatyeseteʼt̃ ñeñt̃ yoranatyesahueteʼt̃. Ñetñapaʼ ñeñt̃a eʼñe cohuen enteteʼt̃. Att̃eñapaʼ c̈hap allempo beʼt̃osos Noé poʼhuarcopahuo. Allempoñapaʼ huata, chop̃a oñ erracmañen, eʼñe aʼcllatuan allohuen acheñeneshaʼ errap̃aren. ");
INSERT INTO ameNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Att̃ecma perreterr allempo correʼt̃ Lot, aña eʼñe cot̃apeʼchyerreterr shonteʼ rrallmeʼchyeseteʼt̃ ñam̃a shonteʼ orrareʼtyeseteʼt̃, atarr es rañt̃aʼyeseteʼt̃, ñam̃a pomatsreʼtyeseteʼt̃. Shonteʼ esocmañen ñeñt̃ paʼnamen nareʼtyeseteʼt̃, t̃omatyeseteʼt̃ ñam̃a shonteʼ pocollac̈hno. Ñetñapaʼ eʼñe ñeñt̃a cohuen enteteʼt̃. ");
INSERT INTO ameNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Att̃eñapaʼ c̈hap allempo c̈haʼnom Lot ñeñt̃ anetsrot̃. Eʼñe ñeñt̃e yet̃rocma allempo c̈haʼnom Lot allot̃, Yomporña pueʼntañot̃ aʼshoranet tsoʼ ñeñt̃ shemashrepñeñenoʼ huorten, ñeñt̃ña eʼñe aʼcllatuerrahueterr allempo. ");
INSERT INTO ameNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Att̃ecmach perreterr allempoch norretuerra na Ñeñt̃en Acheñetosets. ");
INSERT INTO ameNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’T̃arraña allempoch norrterra na sapaʼ arepaʼchña aña soct̃apeʼcheno ñeñt̃ patsoʼmarecpa, atet̃ ñerraʼmrrat̃eʼ puesheñarr ñatoʼ aʼyot̃eʼtsenach paʼpacllot̃ arepaʼchña beʼt̃osatsterro amaʼt eʼñe mamesha paʼpacllo att̃och yoratsreʼtnoma. Amapaʼ ñerraʼm puesheñarr paʼmroʼtsenpaʼ arepaʼchña onatsterro. ");
INSERT INTO ameNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Seyerpuepaʼchña atet̃ p̃a ahuat̃ Lot puet̃apor ñeñt̃ atarr morrentnomaya ñeñt̃ patsoʼmarecpa. ");
INSERT INTO ameNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ñam̃a ñerraʼm eseshaʼ eʼñe aña eʼnenet oʼch correna atomat att̃och eʼñe coshenet arr patsro, ñetñapaʼ aʼchencaterretchaʼ ñañeñeta. T̃arraña ñerraʼm eseshaʼ eʼñe pocteʼ enteneʼ oʼch es sehuanmuet ñeñt̃ atet̃ muenenet ñeñt̃ eʼñe ñocpueta arr patsro ñeñt̃ña acheñerpaʼ corretsach pocsheñeshocmañen eʼñe t̃ayot̃eñ errponañohuen. ");
INSERT INTO ameNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Poʼñoc̈hcaʼye oʼch notas atet̃chaʼcaʼye perra allempoch nohuerra, puesheñaʼtetspaʼ anmaret̃terretchaʼ; amaʼt ñeñt̃ eʼñe pamoʼts peneʼ, ñeñt̃ñapaʼ allach asaʼnmaret̃terra. Atet̃ ñerraʼm tsapo all manrrenet epsheñoʼmaret, puesheñarrpaʼ anmaret̃terrach, poʼpsheñeññapaʼ allach asaʼnmaret̃terra. ");
INSERT INTO ameNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Amapaʼ ñatoʼ allempopaʼ alloʼtsenchaʼ epsheña coyaneshaʼ ñeñt̃ parro puetseʼtets mapyo ñeñt̃paʼc̈hoʼña puesheñarrpaʼ anmaret̃terrach ñam̃a poʼpsheñeññapaʼ allach asaʼnmaret̃terra. ");
INSERT INTO ameNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Amapaʼ ñatoʼ allempopaʼ alloʼtsenchaʼ ñam̃a epsheña ñeñt̃ eʼñe parro taruasenet paʼmro. Puesheñarrñapaʼ anmaret̃terrach, poʼpsheñeññapaʼ allach asaʼnmaret̃terra. ");
INSERT INTO ameNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Allempoña pueyochreshaʼpaʼ aʼp̃t̃oʼchet, atet̃ ochet: —Partseshachaʼ ñeñt̃paʼ ¿erraʼtchaʼña atet̃ perra? Jesúsñapaʼ atet̃ otanet tomaʼnteñtso: —Ñerraʼm erroʼtsenchaʼ ñeñt̃ rromueʼpaʼ allchaʼña shontaña tseʼm. ");
INSERT INTO ameNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Allempoña Jesúspaʼ alla serrpareʼtaterraneterr tomaʼnteñtso att̃och eñochet ñeñt̃ poctetsa yocop c̈hocmach yemaʼyochena amach yemuenmeʼchatsche maʼyochatsa. ");
INSERT INTO ameNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ñeñt̃oʼmarña allempopaʼ atet̃ otanet: —Pat̃err anetso alloʼtsen puesheñarr juez ñeñt̃ poʼtaruas peneʼ oʼch eʼñe cohuen aʼpoctatan ñoñets acheñeneshacop ñerraʼm esempo eʼmoñeʼtannenet. T̃arraña ñeñt̃ña juezpaʼ atarr atsrreʼmñat̃. Amaʼt Yomporpaʼ ama am̃chaʼnaʼtpahuoyeʼ enteñe amaʼt eʼñe mamesha. Acheñeneshaʼpaʼc̈hoʼña amaʼt puesheñarrapaʼ ama acuaʼpenayeʼ entenaneto. ");
INSERT INTO ameNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ñeñt̃ña anetsropaʼ all yec̈hena ñam̃a puesheñarr rret̃orrnaneshaʼ. Ñañapaʼ eñall poʼpsheñeñ ñeñt̃ eʼmoñeʼteneʼ, c̈hocmach errot̃ peññañ ñeñt̃ ama pocteyaye. Rret̃orrnaneshaʼñapaʼ c̈hocmach seneʼt̃ juezesho. Allchaʼ c̈hocma atet̃ otareʼtenan juez: “T̃eʼpaʼ nemneñ oʼch eʼñe cohuen peyenpaʼn att̃och p̃aʼpoctaton cohuen ñoñets añecop ñeñt̃ neʼmoñeʼteneʼ.” ");
INSERT INTO ameNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Juezñapaʼ amaʼt allponmat ama mueno oʼch yenpueʼ. T̃arraña rret̃orrnaneshaʼ ñapaʼ c̈hocmach sen juezesho enamareʼteneʼ att̃och aʼpoctatoñ ñoñets añecop ñeñt̃ eʼmoñeʼteneʼ. Att̃eñapaʼ c̈hap allempo cot̃apeʼch juezpaʼ atet̃ ot: “Napaʼ poʼñoc̈h amaʼt Parets ama nem̃chaʼteñe; acheñeneshaʼpaʼc̈hoʼña amaʼt mameshapaʼ ama acuaʼpenayeʼ nentenaneto. ");
INSERT INTO ameNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","T̃arraña añ rret̃orrnanesharpaʼ atarr atsrreʼmoc̈htanaʼtenen, epayeʼ huapameʼtennana, oʼcaʼye atarr aʼmñechatna. Ñeñt̃oʼmarña t̃eʼpaʼ oʼch neyenpueʼ allochñapaʼ amach alla huerrnaneʼt̃e.” ");
INSERT INTO ameNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Allempoña Jesúspaʼ atet̃ oterrerr: —Amaʼt seʼmueñeña ñeñt̃ atet̃ oten juez ñeñt̃ atarr atsrreʼmñat̃. T̃eʼpaʼ oten ahuoʼch aʼpoctatan rret̃orrnaneshacop amaʼt ñapaʼ ñeñt̃ acheñer ñeñt̃ atarr atsrreʼmñat̃. ");
INSERT INTO ameNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","Ñeñt̃oʼmarña t̃eʼpaʼ oʼch noterrserr: Yomporpaʼ elloña nanacchaʼ cohuen aʼpoctatonay ñeñt̃ey oʼ acrerrey ya ñeñt̃eychaʼ eʼñe puechemer pen ñerraʼm yapaʼ c̈hocmach yec̈horeʼteñ amaʼt yet̃o amaʼt ñam̃a tsapo. Napaʼ poʼñoc̈h oʼch notas, Yomporñapaʼ amach atomato, c̈hoch yeʼm̃ñoteʼ; ñapaʼ eʼñechcaʼye allorocma eʼm̃ñotey oʼch eʼñe cohuen aʼpoctatonay ñeñt̃ yocop. T̃arraña t̃eʼpaʼ oʼch notas, ñerraʼm esempoch nehuerra Ñeñt̃en Acheñetosets, errponsheñat̃eʼña nentuerrña arr patsro ñeñt̃ eʼñe cohuen nameʼñenaya. ");
INSERT INTO ameNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Poʼpocheñoña Jesúspaʼ atet̃ serrpareʼtatan allpon acheñeneshaʼ ñeñt̃ eʼñe ñeta yemtetset t̃arroʼmar ñetpaʼ eʼñe cohuen entyenet eʼñe ñañeñeta. Ñetñapaʼ amaʼt mameshapaʼ ama cohuenayeʼ enteñetoña poʼpotantañ acheñeneshaʼ. Ñeñt̃oʼmarña Jesúspaʼ alla tomaʼntatanet, ñeñt̃paʼ atet̃ otanet: ");
INSERT INTO ameNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Eñall epsheña acheñ ñeñt̃ sets Parets paʼpacllo allchaʼ maʼyochoset. Puesheñarr ñeñt̃paʼ fariseo ñeñt̃ eʼñe ñañeña cohuen entetsa; poʼpsheñeññapaʼ ñeñt̃ pueshquëñot̃eʼna cobraʼyenan acheñeneshaʼ quelle ñeñt̃ gobiernocop. ");
INSERT INTO ameNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ñeñt̃ña fariseopaʼ t̃omos all maʼyochosañ, ñeñt̃paʼ atet̃ otos: “Nompore, napaʼ oʼch neparasyosoʼtosep̃ t̃arroʼmar napaʼ atarr cohuen acheñren, napaʼ ama att̃eyayno Nompore ñerraʼm poʼpotantañ acheñeneshaʼ. Ñetpaʼ atarr es puerratam̃p̃sannaʼtyenet, ama pocteyeʼ es p̃annaʼtyeneto, atarrchaʼ chetaʼyeñet coyaneshac̈hno ñeñt̃ ama puet̃aporeyaye. Napaʼ ama att̃eyeʼ Nompore nepeno. Napaʼ ama neshcareʼteno atet̃ pena añ acheñer ñeñt̃ pueshquëñot̃eʼna cobraʼyeneʼ acheñeneshaʼ quelle gobiernocop. ");
INSERT INTO ameNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Napaʼ pat̃eʼtets semanapaʼ epochchaʼ net̃oreʼtena Nompore p̃ocop, ñam̃a amaʼt ora ñeñt̃ allpon naguën c̈hocma napuenep̃ allpon poctetsa p̃ocop amaʼt nediezmo Nompore.” Allohua huañ atet̃ maʼyochena fariseo. ");
INSERT INTO ameNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Poʼpsheñeñña ñeñt̃ cobrets quelle ñañapaʼ alla t̃omos aʼyot̃. Ñapaʼ eñotena atarr ochñat̃ ñeñt̃oʼmarña ñapaʼ ama cohuoso enonet̃ Yomporeshonet̃. Ña puellquëñot̃paʼ nosan pot puesomapo. Ña puemaʼyocheñot̃ atet̃ otos: “Nompore, t̃eʼpaʼ oʼch pemorrenterrna att̃och eʼñe pep̃retnaʼhuerrnan allohuen noʼchñar t̃arroʼmar napaʼ atarrcaʼye ochñat̃en.” ");
INSERT INTO ameNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jesúsñapaʼ atet̃ oterraneterr: —Napaʼ oʼch notas, ñeñt̃ña atet̃ aʼmet̃eneʼ poʼchñar ñeñt̃ña acheñerpaʼ eʼñe pocteʼ enteñ Yompor. Ñeñt̃oʼmarña allempo maʼyochuapaʼ oʼ ahuerr paʼpacllo eʼñe cohuen ap̃retnaʼhuaret̃terra poʼchñar. Poʼpsheñeñña fariseo ñeñt̃ ama aʼmet̃osaye poʼchñar, Yomporñapaʼ arepaʼtchaʼ pocteyeʼ eñche. T̃arroʼmar allohuen ñeñt̃ eʼñe cohuen entetsa eʼñe pommoʼcheñot̃ ñeñt̃ña tsapat̃onet̃paʼ amach esosheʼmayeʼ entereto. T̃arraña allohuen ñeñt̃ ama esosheʼmayeʼ entetso t̃eʼ, ñeñt̃ña tsapat̃onet̃paʼ atarrchaʼ cohuen enteret. ");
INSERT INTO ameNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ñam̃a allempopaʼ shonteʼ huac̈haʼtachet cheshat̃olleshaʼ Jesúsesho. Ñetpaʼ añecopña huac̈haʼtachet oʼch aʼp̃llaʼyesapanet Jesús att̃och bensareʼtam̃p̃sapanet. Jesúsña pueyochreshaʼ allempo entapan ñeñt̃ huac̈haʼtateʼ cheshaneshac̈hno, ñetñapaʼ ama pocteyeʼ eñcheto oʼch anmoset cheshat̃olleshaʼ Jesúsesho ñeñt̃oʼmarña ama amnataret̃tapueto. ");
INSERT INTO ameNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","T̃arraña Jesúsñapaʼ allent̃a c̈horeʼtapanet, atet̃ otapanet: —Pocteʼñac̈hoʼ semnachñacaʼyeña cheshaneshaʼ onosetepaʼ eʼñe nesho. Amachcaʼye c̈ha sepatareʼtatstapaneto t̃arroʼmar allohuen ñeñt̃ atarr neyemtenaya na eʼñe att̃et ñerraʼmrrat̃eʼ cheshat̃oll, ñetchaʼ oʼpatenetña Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña pueʼntañot̃. ");
INSERT INTO ameNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Poʼñoc̈hpaʼ oʼch notas, ñerraʼm eseshaʼ ama eʼñeyeʼ pueyemteñot̃eyeʼ aguëññañeto Yompor poʼcohuenña amach atet̃ perreto ñerraʼm cheshat̃oll eʼñech yemtenana ñeñt̃ cohuam̃peneʼ, ñetñapaʼ amach pueyochreshayeʼ perraneto Yompor att̃o atarr ayochreshat̃tena ña. ");
INSERT INTO ameNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Poʼpocheñoña puesheñarr ñeñt̃ atarr am̃chaʼtaret̃tetsa aʼp̃t̃oʼtosan Jesús, atet̃ otos: —Maestro, p̃apaʼ atarr cohuen acheñrep̃, t̃eʼpaʼ oʼch p̃otapuen ¿errot̃enaʼtchaʼ nep̃aña na eʼñe cohuen att̃ochña napaʼ corretsanach eʼñe t̃ayot̃eñ amaʼt errponañohuen? ");
INSERT INTO ameNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesúsñapaʼ atet̃ otap̃: —Esoʼmareʼt p̃otenenña napaʼ atarroʼ cohuen acheñren. Arr arromñat̃eneshaʼ amaʼt eʼñe puesheñarrapaʼ ama eñalleña ñeñt̃ eʼñe cohuen acheñer. Ñapt̃aña Yompor ñeñt̃ eʼñe poʼñoc̈h cohuen. ");
INSERT INTO ameNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","P̃apaʼ eʼñe peñotuen Yompor poʼñoñ all oteney ñeñt̃chaʼ atet̃ yepena eʼñe cohuen; ñeñt̃paʼ atet̃ oteney: “Amach yechtapretyesatsto t̃aporets; amach yemtsannaʼtatsto; amach yetyesatsto; amach yetomaʼtam̃p̃satsche yamoʼts eʼñe att̃a; ñam̃a yemorrenteñot̃paʼ yem̃chaʼnaʼchchaʼ yompor ñam̃a yachor.” ");
INSERT INTO ameNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ñeñt̃ña aʼp̃t̃oʼteneʼpaʼ atet̃ otererr: —Napaʼ eʼñecaʼye cheshot̃eñ ora añec̈hnopaʼ eʼñecaʼye netsotueñ. ");
INSERT INTO ameNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Oʼña atet̃ otua Jesúsñapaʼ alla otererr: —Eñallmeñcaʼye pat̃err ñeñt̃ pepalltena ñeñt̃ ama att̃eyeʼ pepenaʼ. T̃eʼpaʼ añchaʼña atet̃ pep̃a oʼch eʼñe pepomhuerr ora allpon ñeñt̃ pechyen oʼch p̃apaʼyeraʼ huocchañneshac̈hno ñeñt̃ atarr es palltaʼyetsa att̃ochña p̃apaʼ pecherrchaʼ ñeñt̃ atarr nanac sherbets Yompor pueʼntaño. Allempochña pehuerrapaʼ oʼch p̃oct̃erren att̃och eʼñe neyochreshaʼ neperrep̃ eʼñe poctacma. ");
INSERT INTO ameNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Oʼña eʼmhuan ñeñt̃ atet̃ och Jesúspaʼ ñañapaʼ c̈ha atarr lleca t̃arroʼmar ñapaʼ atarr ec̃llayoret̃, shonteʼ paʼnamen echyen. ");
INSERT INTO ameNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesúsña eñch ñeñt̃ atet̃ atarr llecapaʼ ñañapaʼ puellcapreteñot̃paʼ atet̃ ot: —Ñeñt̃ atarr ec̃llayoret̃paʼ atarr nanac echarr att̃och agapoñet Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña. ");
INSERT INTO ameNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ñehua, ñeñt̃paʼ atet̃chaʼ netmaʼntacha. Poʼñoc̈h yapaʼ yeñoteñ berr añecmuen allpon ñerraʼm huaquësh atarrcaʼye t̃orrapoʼ oʼch eshoʼtosa añet̃ollponat̃ollo atet̃ ñerraʼmrrat̃eʼ acosh puetat̃ollo. Ñeñt̃paʼ atet̃caʼye penaña acheñ ñeñt̃ ec̃llayoret̃ ello atarr t̃orrapoʼ oʼch agapan ñam̃a Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña (t̃arroʼmar ñetpaʼ ama mueneñeto oʼch sehuanmuet ñeñt̃ atarr morrentenet ñet att̃och pueyochreshaʼ perranetañ Yompor). ");
INSERT INTO ameNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ñeñt̃ña eʼmueneʼ atet̃ oten Jesús ñetñapaʼ atet̃ ochet: —T̃arraña ñerraʼm atet̃t̃eʼpaʼ amat̃eʼ eseshaʼ aʼqueshp̃ataret̃terrtso amaʼt puesheñarra t̃arroʼmar yapaʼ yeñoteñcaʼye huaquëshpaʼ amacaʼye eshoʼtenoña acshequeto. ");
INSERT INTO ameNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesúsñapaʼ atet̃ oterraneterr: —Sa arromñat̃eneshaspaʼ amach es errot̃enayeʼ apen senteno. T̃arraña Yomporpaʼ ama eñalle ñocop ñeñt̃ atarr t̃orrapoʼ enten. ");
INSERT INTO ameNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedroñapaʼ atet̃ och: —Partseshachaʼ poʼñoc̈h yapaʼ oʼ eʼñe yesuanom ora allohuen amaʼt yepacllohuen att̃och eʼñe yoct̃errep̃. ");
INSERT INTO ameNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesúsñapaʼ alla oterraneterr: —Poʼñoc̈hpaʼ oʼch notas, allohuen erraʼtsenchaʼ acheñer ñeñt̃chaʼ eʼñe sehuanmueʼ allohuen amaʼt paʼpacllohuen, ñatoʼ puet̃apor, paʼmoʼnasheñneshaʼ ñatoʼ pompor, pachor, ñatoʼ amaʼt ñam̃a puechemereshaʼ att̃och eʼñe cohuen sherb̃aterrñañet Yompor poʼcohuenña att̃o ayochreshat̃tena ña, ");
INSERT INTO ameNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","amaʼt erraʼtsenchaʼ ñeñt̃chaʼ sohuanmueʼ allohuen, elloña ñetpaʼ oʼch alla aguërret shonteʼ esocmañen ñeñt̃ atarr cohuen amaʼt t̃eʼ allempo eʼñe correnet, elloña tsapat̃onet̃ñapaʼ oʼch aguërret ñeñt̃ alloch ñetpaʼ corretsetach beñecpuen. ");
INSERT INTO ameNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ñeñt̃ pueyochreshaʼ ñeñt̃ c̈harraʼ puechena epsheña, Jesúsñapaʼ ahuanmanet ellonet̃, allñapaʼ atet̃ otosanet: —T̃eʼ poʼñoc̈hpaʼ oʼch ahueney Jerusaléño. All ora allpon quellcaʼyesoneʼt̃ ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ ahuat̃ ñeñt̃chaʼ atet̃ naʼp̃aret̃terra na Ñeñt̃enchaʼ Acheñetosets, t̃eʼñapaʼ oʼch eʼñe etsotuerra ñeñt̃ atet̃ anaret̃ nocop. ");
INSERT INTO ameNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","T̃arroʼmar t̃eʼpaʼ pomuerrnetchaʼ poʼpoñ acheñesho ñeñt̃ ama judioneshayaye. Allohuen acheñeneshaʼpaʼ oʼch achm̃areʼterrnet, oʼch atserrp̃atseʼterrnet, pueʼmoñeʼteñot̃etanpaʼ oʼch aʼcoshareʼterrnet. ");
INSERT INTO ameNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Oʼch nashtaret̃terra, att̃ot̃chaʼña muetserrnet. T̃arraña pomaʼpamtañoñapaʼ oʼch alla netanterra. ");
INSERT INTO ameNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Amaʼt atet̃ otuanet, ñetñapaʼ ama eseshayeʼ eñotaye ñeñt̃ atet̃ serrpareʼtatanet. Amaʼt puesheñarrot̃etapaʼ amaʼt mameshapaʼ ama c̈hapanetoña pueyoc̈hreto ñeñt̃ atet̃ otenanet. ");
INSERT INTO ameNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","All oñenet oʼña c̈hapmochet anetso Jericópaʼ allña eʼñe t̃oñetop̃ñopaʼ all anen puesheñarr aporoʼyet̃ ñeñt̃ c̈hocma enamuets quelle. ");
INSERT INTO ameNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ñeñt̃ña aporoʼyet̃paʼ oʼ eʼmapan shonteʼ acheñeneshaʼ ñeñt̃ metac̈hets all t̃oño, ñañapaʼ allent̃a aʼp̃t̃oʼtanet: —¿Esoʼmareʼt shonteʼ metac̈henña acheñeneshaʼ? ");
INSERT INTO ameNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ñetñapaʼ atet̃ ochet: —Añcaʼye huetsa Jesús ñeñt̃ nazaretoʼmarneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ñañapaʼ allent̃a rrana huomencpaʼ atet̃ otapan Jesús: —Pemuerayeʼchnomna Jesúsochaʼ nam̃a. P̃apaʼ ñeñt̃ep̃ Davidnaʼtarep̃. ");
INSERT INTO ameNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Acheñeneshaʼ ñeñt̃ otac̈hetsa ñetñapaʼ c̈ha mueneʼ cheʼptareʼtnomet, atet̃ otoset: —Oʼhua pemma. Aporoʼyet̃ñapaʼ elloña alla rranerrerr atet̃ oterranerr Jesús: —Ñeñt̃ep̃ Davidnaʼtarep̃, pemuerayeʼchnomnañacaʼye. ");
INSERT INTO ameNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Allempoña Jesús alla t̃omos otosan acheñeneshaʼ: —Sanmon arr nesho. Oʼ huapapaʼ Jesúsñapaʼ atet̃ otap̃: ");
INSERT INTO ameNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Esoʼtña penmen ñeñt̃chaʼ atet̃ nep̃osep̃? Ñañapaʼ atet̃ och: —Añcaʼye Ayochreshat̃e nemnen oʼch pecuatnomuen att̃och oʼch cohuen nenterrapa. ");
INSERT INTO ameNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesúsñapaʼ alla otererr: —Pecuerrepaʼch, t̃arroʼmar att̃o atarr peyemtapna na ñeñt̃caʼyeña oʼ eʼñe aʼcrraterrep̃. ");
INSERT INTO ameNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Eʼñepaʼtchaʼ allorocma eʼñe cohuen enterra. Eʼñe cohuerrtsapaʼ c̈ha cot̃aʼnmueʼ ñam̃a Jesús, allent̃a atarr ayeʼchoc̈htatnoman Yompor all cot̃aʼnenan Jesús. Att̃oʼ enteñ allohuen acheñeneshaʼ ñetpaʼc̈hoʼña eʼñe cohuen ayeʼchoc̈htatneññañet Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Allempoña Jesúspaʼ c̈hap all anetso Jericó, all oñmos anetsoʼmar. ");
INSERT INTO ameNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Allñapaʼ alloʼtsen puesheñarr yacma ñeñt̃ sochetsa Zaqueo ñeñt̃ paʼm̃chaʼtaret̃er peñ allohuen ñeñt̃ cobraʼyeneʼ acheñeneshaʼ quelle gobiernocop. Ñañapaʼ atarr ec̃llayoret̃. ");
INSERT INTO ameNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Zaqueoñapaʼ atarr mueneñ oʼch entapan ñeñt̃ otenet Jesús. Ñehua, ñapaʼ amach errot̃enot̃ entapano Jesús t̃arroʼmar shonteʼ acheñ ñeñt̃ emchorraʼnenaya all oñen ñam̃a Zaqueopaʼ allponmet̃olla. ");
INSERT INTO ameNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ñeñt̃oʼmarña ñapaʼ mata allenet̃chaʼ oñem, aʼtapos tsacho ñeñt̃ paʼsoʼcheñ sicómoʼrech allot̃chaʼ entapan Jesús t̃arroʼmar allchaʼ oñem. ");
INSERT INTO ameNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Allempoña c̈hap Jesús eʼñe ñesho, cohuostsa enonet̃paʼ alla entos, ñañapaʼ atet̃ otos: —Zaqueo, pesuerra t̃ecma. T̃eʼ napaʼ eʼñe poctennana oʼch nec̈hap pepacllo. ");
INSERT INTO ameNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ñañapaʼ allent̃a sohuerra t̃ecma eʼñe pocsheñeshaʼ agapap̃. ");
INSERT INTO ameNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Allempoña acheñeneshaʼ atet̃ eñchet, ñetñapaʼ amaʼt mameshapaʼ ama pocteyeʼ es entaye. Ñetpaʼ atet̃ otannaʼtyeset: —Esoʼmarchaʼcaʼyeña beʼt̃ososña Jesús allchaʼ mos añ acheñer paʼpacllo ñeñt̃ atarr nanac ochñat̃. ");
INSERT INTO ameNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueoñapaʼ allent̃a t̃omhuerrpaʼ atet̃ otapan Partseshaʼ: —T̃eʼpaʼ oʼch peʼm̃ñotosen Ayochreshat̃e. Ñeñt̃ ora allpon nechyen, t̃eʼñapaʼ oʼch napaʼyer pueshmet huocchañneshac̈hno. Poʼñoc̈h allempo es neprratam̃pesyeseʼt̃ puesheñaʼtetspaʼ t̃eʼñapaʼ paʼtatsocheʼtatschaʼ napuerranet. ");
INSERT INTO ameNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesúsñapaʼ atet̃ otos: —T̃eʼñapaʼ oʼ c̈hapanet allohuenacop ñeñt̃ yec̈hetsa añ pocollro alloch aʼqueshp̃ataret̃terret. Amaʼt ñapaʼc̈hoʼña Abrahamcaʼye poʼm̃reneñ. ");
INSERT INTO ameNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Na Ñeñt̃en Acheñetosets ñeñt̃oʼmarña nohuapa añe patsro oʼch neʼnyesos acheñeneshaʼ ñeñt̃ chenquëtsa ñeñt̃chaʼña naʼqueshp̃atyesos. ");
INSERT INTO ameNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Acheñeneshaʼ oʼ eʼm̃ñotenet shonteʼ ñeñt̃ atet̃ serrpareʼtatanet Jesús ñeñt̃ atet̃ pena Yompor poʼcohuenña, ñam̃a Jesúspaʼ oʼ c̈hapmoch Jerusaléño. Ñeñt̃oʼmarña ñetñapaʼ c̈ha otenapuetañ allempocmach etsota allempopaʼ ñach am̃chaʼtaret̃tatsa Yomporeshot̃ arr patsro. Ñeñt̃oʼmarña elloña ñapaʼ tomaʼntatanet poʼpoñ. ");
INSERT INTO ameNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ñeñt̃paʼ atet̃ otanet: —Eñall puesheñarr acheñ ñeñt̃ eʼñe cohuen am̃chaʼnaʼtpoʼ entyen allohuen acheñeneshaʼ amaʼt eʼñe pamoʼtseshohuen. Ñeñt̃ña acheñerpaʼ arr sechena b̃ac̈hayo poʼpoñ anetso allot̃chaʼ apet llesens att̃och esempoch huerrapaʼ oʼch am̃chaʼtaret̃etuerra all paʼnyo. ");
INSERT INTO ameNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Allempo ama senaʼpaʼ agotatnoman c̈harrasheña paʼtaruasañer ñeñt̃chaʼ apaʼyesnom allponeshapaʼtets quelle eʼñe puesheñaʼttsocmuet. Allempo apaʼyesnomanetpaʼ atet̃ otyesnomanet: “Añ quellepaʼ oʼch setaruasach nocop. Esempoch nehuerrapaʼ allempochña eʼñe neñotuerrnas eʼñe puesheñaʼttsos errpont̃eʼ quelle seganaʼyesa ñeñt̃ nocop.” ");
INSERT INTO ameNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","T̃arraña patantarr acheñeneshaʼ ñeñt̃ paʼnyoʼmarneshaʼ, ñetñapaʼ atarr eʼmoñeʼteñet. Ñeñt̃oʼmar allempo ta ñeñt̃ anetsro, ñetñapaʼ mueñet allponsheña ñeñt̃chaʼ eñososets all sen oʼch oteñetaʼ alloʼmarneshaʼ: “Yapaʼ ama yemno oʼch seneʼ añ acheñer oʼch am̃chaʼtaret̃ta yocop.” ");
INSERT INTO ameNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","T̃arraña amaʼt atet̃ petañ ñocopñapaʼ c̈hocmach apet llesens att̃och huerra oʼch am̃chaʼtaret̃etuerra all paʼnyo pamoʼtseshacop. Allempoña c̈herrpaʼ agotatuerran paʼtaruasañreneshaʼ ñeñt̃ apaʼyesnom quelle ahuaña. Ñapaʼ añecopña agotatyesuerranet oʼch eñotuerranet errpont̃eʼ quelle ganatyesñañet poʼc̃llayor eʼñe puesheñaʼttset. ");
INSERT INTO ameNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Att̃oña apc̈haʼhuerranet ñeshopaʼ ñeñt̃ ñanom huapatsapaʼ atet̃ otos: “Ayochreshat̃e, ñeñt̃ allpon p̃apaʼnmuen ahuaña quelle, nañapaʼ ello neganaterrnaperr pec̃llayor c̈harroch.” ");
INSERT INTO ameNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Pamoʼmteʼñapaʼ atet̃ otuer: “Eʼñe pocteʼ, p̃apaʼ atarr cohuen pesherbenen. Amaʼt allponat̃olla napaʼnmap̃ ahuaña, p̃añapaʼ atarr cohuen pesherb̃aton. Ñeñt̃oʼmarña t̃eʼpaʼ oʼch nenuerrep̃ c̈harracop anets allchaʼ paʼm̃chaʼtaret̃terra p̃a.” ");
INSERT INTO ameNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Allempoñapaʼ oʼ huapa ñam̃a poʼpsheñeñ paʼtaruasañerpaʼ ñapaʼc̈hoʼña atet̃ otos: “Ayochreshat̃e, na ñeñt̃ allpon p̃apaʼnmuen ahuaña quelle, nañapaʼ ello neganaterrnaperr pec̃llayor anmaroch.” ");
INSERT INTO ameNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Pamoʼmteʼñapaʼ atet̃ otuer: “Eʼñe pocteʼ, t̃eʼpaʼ oʼch nenuerrep̃ p̃am̃a amnarecop anets allchaʼ p̃aʼm̃chaʼtaret̃terra p̃am̃a.” ");
INSERT INTO ameNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Allempoñapaʼ huapa poʼpsheñeñ paʼtaruasañer, ñapaʼc̈hoʼña atet̃ otos: “Ayochreshat̃e, arrpaʼ ñeñt̃a allponara ñeñt̃ eʼñe allpona p̃apaʼnmuen ahuaña quelle. Napaʼ alla naññoʼtennap̃ eʼñe cohuen nepennap̃ pañello. ");
INSERT INTO ameNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Napaʼ c̈ha nem̃chaʼtenep̃ t̃arroʼmar neñotenep̃ p̃apaʼ amacaʼye matsrreʼmñape. P̃apaʼ c̈hocmacaʼye peprratam̃pesyen amaʼt ñeñt̃paʼ ama p̃oyaye, ñam̃a c̈hocmacaʼye pet̃otatyenña ñeñt̃ ama p̃ayeʼ nareʼtatyenaye.” ");
INSERT INTO ameNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Pamoʼmteʼñapaʼ atet̃ otuer: “P̃aña poʼñoc̈hpaʼ amacaʼye cohuenayeʼ pesherbenno amaʼt eʼñe mamesha. Eʼñe atet̃ p̃otenen napaʼ atarroʼ atsrreʼmñat̃en t̃eʼñapaʼ poʼñoc̈h atet̃chaʼcaʼye natsrreʼmoc̈htanaʼtuerrep̃chaʼ. Ñerraʼm poʼñoc̈h peñotennoñ napaʼ atarr atsrreʼmñat̃eneñ, ñerraʼm poʼñoc̈h c̈hocma neprratam̃pesyeneñ ñeñt̃ ama noyaye, ñam̃a napaʼ ñerraʼm poʼñoc̈h c̈hocma net̃otatyeneñ ñeñt̃ ama nayeʼ nareʼtatyenaye, ");
INSERT INTO ameNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ñerraʼm poʼñoc̈h atet̃ pentennoñpaʼ, esoʼmaruañacaʼyeña ama bancoyeʼ penennanoña nec̃llayor allochñapaʼ t̃eʼña oʼ nehuerrapaʼ nagapuerreñchaʼ nec̃llayor allo atontateñet.” ");
INSERT INTO ameNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Allempoña pamoʼmteʼpaʼ atet̃ otan ñeñt̃ t̃omc̈haʼtyets all: “T̃eʼpaʼ oʼch seprratam̃pesuer quelle, oʼch sapuer ñeñt̃ ganateneʼ c̈harroch nec̃llayor.” ");
INSERT INTO ameNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ñetñapaʼ atet̃ ochet: “Ayochreshat̃e, ñapaʼ echenancaʼyeña shonteʼ quelle ñeñt̃ ganena c̈harroch.” ");
INSERT INTO ameNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Pamoʼmteʼñapaʼ atet̃ oterraneterr: “T̃arraña amaʼt att̃eñpaʼ t̃eʼpaʼ oʼch notas, ñeñt̃ es echets shonteʼ eʼñe puesherb̃ateñot̃et pamoʼmteʼ ñetña ellonet̃paʼ oʼch alla aparet̃terret poʼpoñ aton. T̃arraña ñeñt̃ ama es echetsopaʼ amaʼt allponat̃olla ñeñt̃ echyenetañ aprratam̃p̃saret̃terretchaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ñam̃a t̃eʼpaʼ añña ñeñt̃ neʼmoñeʼteneʼ ñeñt̃ ama muenenaye oʼch naʼm̃chaʼtaret̃ta ñocpuet, t̃eʼña sapaʼ oʼch sehuapatanet att̃och semtsanatosanet eʼñe arr nesho.” ");
INSERT INTO ameNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Allempoñapaʼ ahuerrerr Jesús Jerusaléñonet̃. ");
INSERT INTO ameNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","C̈hapmochet aspent̃o ñeñt̃ paʼsoʼcheñ Olivopen alloʼtsen anets ñeñt̃ Betfagé ñam̃a Betania. Oʼ c̈hapmochet all Jesúsñapaʼ ");
INSERT INTO ameNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","atet̃ otosan epsheña pueyochreshaʼ: —Sapaʼ oʼch sota oʼch sec̈hap aʼyent̃eyeʼ eʼñe allara anetso. Oʼch sec̈hap allpaʼ allchaʼ sentos ashen rreʼptor all huanquëñet; ñeñt̃paʼ amaʼt puesheñarra acheñ ama monteñaʼ. Ñeñt̃ña ashenpaʼ oʼch sepyam̃p̃sospaʼ oʼch sanerrnan arr. ");
INSERT INTO ameNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ñerraʼm eseshaʼch sotapueʼ: “¿Esoʼmareʼt sepyam̃peñña ashen?” sañapaʼ atet̃chaʼ sotosanet: “Yepartsesharcaʼye mueneneʼña añ ashen.” ");
INSERT INTO ameNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Allempoña ñeñt̃ mueñapaʼ ñetñapaʼ ahuanmuet all anetso. Allñapaʼ atet̃c̈hoʼ entoset eʼñe atet̃ otanet Jesús, alloʼtsencaʼye ashen rreʼptor all huanquëñet. ");
INSERT INTO ameNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Allempo pueyam̃p̃sosetpaʼ pamoʼmteʼñapaʼ atet̃ otapanet: —¿Esoʼmareʼtchaʼña sepyam̃p̃sosnayña yashanor? ");
INSERT INTO ameNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ñetñapaʼ atet̃ otosñañetña ashen pamoʼmteʼ: —Yepartsesharcaʼye mueneneʼña añ ashen. ");
INSERT INTO ameNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Allempoñapaʼ anerretña ashen Jesúsesho. Nohuerret paʼshtam ashnacheʼñopaʼ montatueret Jesús. ");
INSERT INTO ameNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Allempo montaʼnma Jesús allenet̃ sen, acheñeneshaʼñapaʼ t̃ot̃maʼtyesoñet paʼshtam t̃oño allchaʼ oñem. ");
INSERT INTO ameNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Att̃eñapaʼ oʼ c̈hapmochet Jerusaléño. Allempo aʼnososet Olivop̃not̃ shonteʼ acheñeneshaʼ ñeñt̃ ameʼñenaya Jesúspaʼ ñetñapaʼ allot̃eñ eʼñe coshaʼrrtoset. Eʼñe pocsheñeshaʼ ahuanenet, panoʼtatseʼteñeshaʼ ayeʼchoc̈htatneññañet Yompor, t̃arroʼmar atarr cohuen entnenet att̃o Jesúspaʼ atarr orrtatenanet Pompor poʼpartsoña. ");
INSERT INTO ameNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ñetñapaʼ atet̃ otyesnenet: —¡Ayeʼchoc̈htaterrapoʼch Am̃chaʼtaret̃ Jesús ñeñt̃ llesensen Yompor! ¡Cosherretepaʼch amaʼt ñeñt̃ pueʼntañoʼtsen! ¡Ayeʼchoc̈htaterrapoʼch ñam̃a Yompor Parets ñeñt̃ pueʼntañoʼtsen! ");
INSERT INTO ameNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Fariseoneshaʼña puesheñaʼtets ñeñt̃ alloʼtsaʼyen ñeñt̃ ama ameʼñenaye Jesús, ñetñapaʼ atet̃ otapet Jesús: —Maestro, pecheʼptareʼtayeʼchyesnom̃ñacaʼyeña peyochreshac̈hno att̃och amach alloʼna att̃a ac̈hotatsetnenpeto. ");
INSERT INTO ameNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","T̃arraña Jesúsñapaʼ atet̃ otosanet: —Napaʼ oʼch notas, amaʼtchaʼ atet̃ notatstanetañpaʼ muemaʼrrtetañchaʼ, mapyec̈hnoñapaʼ puerranareʼteñot̃etpaʼ nac̈hotenayach. ");
INSERT INTO ameNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Allempo oʼ eʼñe c̈hapmochet att̃o entosan anets Jerusaléñ, Jesúsñapaʼ atarr yaʼnaʼtosan jerusaléñoʼmarneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Allpaʼ atet̃ eñorosa ñocpuet: —Atarr nemneñeñ amaʼt eʼñe t̃ayecma poʼñoc̈h sapaʼc̈hoʼña oʼt̃eʼ señotereñ errot̃enchaʼ seperra att̃och Yomporpaʼ oʼch aʼqueshp̃aterrsoñ eʼñech socsheñeshaʼ socrrerrañ. T̃arraña saña t̃emeʼttsen ñeñt̃ñapaʼ amaʼt mameshapaʼ ama c̈hennaso seyoc̈hro. ");
INSERT INTO ameNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","T̃arroʼmar napaʼ oʼch notas, poʼñoc̈h oʼch c̈hap allempoch ñeñt̃ seʼmoñeʼteneʼpaʼ conc̈haʼtam̃perrnasetchaʼ saʼnetser att̃och eʼñe rroc̈htam̃perrset allem̃at̃eñ sat̃ep̃ot̃paʼ huac̈haʼtonasetchaʼ, att̃och amach errenet̃ seyeterro amaʼt eʼñe puesheñarrot̃esa. ");
INSERT INTO ameNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Aʼmataʼtuerrnasetchaʼ ora allohuen saʼnetser att̃och sepaclleʼnachña eʼñe saʼtpetseʼtuerreʼ allohuenes amaʼt sacñet̃aret̃olleshohuen. Allo sorraten sepaquëll amaʼt pat̃rra mapueʼpaʼ amach aʼpuerro, t̃arroʼmar sapaʼ ama semno oʼch saguërrñañ Yompor puemuereña allempo mueneñeñ oʼch yenpuerrsoñ sam̃a. ");
INSERT INTO ameNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Allempo c̈hap Jerusaléño Jesúsñapaʼ ahuos Parets paʼpacllo. Beʼt̃osospaʼ allot̃ñapaʼ c̈haʼnmac̈haʼtatuosan ñeñt̃ pomatsreʼtyetsa all. ");
INSERT INTO ameNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Allñapaʼ atet̃ otosan ñeñt̃ pomatsreʼtyetsa: —Yompor poʼñoñ ñeñt̃ atet̃ anuaret̃ ahuat̃ot̃eñ, allñapaʼ atet̃ oten Yompor: “Añ ñeñt̃ nepaquëll nepenpaʼ añecpacaʼyeña sherben allecmach maʼyochennet”; t̃arraña sañapaʼ atet̃ sepeññañña Yompor paʼpaquëll atet̃ ñerraʼmrrat̃eʼ eñet̃ ñeñt̃ eʼpotyetsa mapuetponoʼmar. ");
INSERT INTO ameNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pat̃eʼtets yet̃ Jesúspaʼ c̈hocmach seneʼt̃ Parets paʼpacllo all yec̈hatenaneteʼt̃ Yompor poʼñoñ. Añña ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar ñam̃a añ ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ ñam̃a poʼpotantañ ñeñt̃ am̃chaʼtaret̃etyetsa all anetso, ñetñapaʼ Jesúsa atarr oʼpatyenet att̃och muetsatachet. ");
INSERT INTO ameNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","T̃arraña ñetpaʼ ama errot̃ peto t̃arroʼmar allohuen acheñeneshaʼpaʼ atarr yemteññañet Jesús att̃o atarr cohuen serrpareʼtatenanet Yompor poʼñoñ. Ñetpaʼ ñeñt̃ña atarr cohuen entyenet. ");
INSERT INTO ameNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Poʼpocheño pamt̃arr Jesúsñapaʼ alla yec̈haterranerr acheñeneshaʼ Parets paʼpacllo. Allpaʼ añ serrpareʼtatenanet cohuen ñoñets alloch yequeshperra. Att̃eñapaʼ huac̈haʼtoña shonteʼ am̃chaʼtaret̃neshaʼ—ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar ñam̃a allponsheña ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ ñam̃a poʼpotantañ ñeñt̃ pomporneshaʼ p̃aʼyen allohuen judioneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ñetñapaʼ atet̃ otoset Jesús: —Ñehua, yapaʼ añecop yehuena yemneñ oʼch p̃otey ¿errot̃eʼt apuenpetña llesens? ¿Eseshaʼtña p̃apueneʼña llesens att̃ot̃ p̃orrtatyenña ñeñt̃ c̈hocma att̃ecma pep̃aʼyena? ");
INSERT INTO ameNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesúsñapaʼ atet̃ otapanet: —Ñehua, napaʼc̈hoʼña nemneñ oʼch naʼp̃t̃oʼtapas sam̃a amaʼt pat̃rra ñoñets. Sapaʼc̈hoʼña oʼch sotosen, ");
INSERT INTO ameNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ahuañmoʼcha allempo apateʼt̃ Juanañ Yomporecop ñeñt̃paʼ ¿eseshaʼtña llesenseʼ ñatoʼ Yompor amapaʼ acheñat̃eʼ apueʼña llesens? Nemnen oʼch sotosen ñeñt̃ atet̃ soct̃apeʼchen sa. ");
INSERT INTO ameNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ñetñapaʼ eʼñe aʼnahua otannaʼtyeset: —Taʼm errot̃chaʼcaʼye yocht̃eʼ. Ñerraʼm c̈ha yoch Yomporeshot̃caʼye apetña llesens, ñañapaʼ c̈hat̃eʼcaʼye otey: “Ñehua, sañapaʼ esoʼmareʼtña ama seʼm̃ñocheña ahuaña allempo serrpareʼtatosan acheñeneshaʼ.” ");
INSERT INTO ameNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Elloña ñerraʼm c̈ha yoch acheñeshot̃a apet llesenspaʼ acheñeneshaʼñapaʼ c̈hat̃eʼ eʼmoñeʼtyet. Pueʼmoñeʼteñot̃etaypaʼ c̈hat̃eʼ rrollapechyet t̃arroʼmar ñetpaʼ eʼñe cohuen eñcheteʼt̃ Juanañ, c̈hocma otyenet ñapaʼ ñeñt̃caʼyeña aʼm̃toseʼ Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ñeñt̃oʼmarña ñetpaʼ atet̃ ochet Jesús: —Taʼm yapaʼ amacaʼyeña yeñoteñe; errot̃t̃eʼ huapaña Juan, errot̃t̃eʼ apetña ñam̃a llesens. ");
INSERT INTO ameNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Allempoña Jesúspaʼ atet̃ oterraneterr: —Napaʼc̈hoʼña t̃eʼpaʼ amach notaso sam̃a allot̃ aparet̃enña nam̃a llesens att̃ot̃ atet̃ nep̃aʼyena. ");
INSERT INTO ameNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Allempoña Jesúspaʼ alla serrpareʼtaterranerr acheñeneshaʼ tomaʼnteñtso, Ñeñt̃paʼ atet̃ otanet: —Eñall puesheñarr acheñ ñeñt̃ña nareʼtanatatnomueʼ shonteʼ uvach, paʼmuerñapaʼ eʼñe ora uvachmatatue. Eʼñe allponmatatsapaʼ oʼ naʼnman poʼpotantañ ñeñt̃chaʼ taruasatats uvachmo ñeñt̃chaʼ coyerrahuet allpon ñerraʼm esempoch t̃oteñet. Allempoña ñapaʼ ahuoʼ b̃ac̈hayo poʼpoñ anetso alla atomat. ");
INSERT INTO ameNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","C̈hap allempo yen uvachllom̃paʼ ñañapaʼ mueñerran poʼpsheñeñ paʼtaruasañer oʼch enamuerraʼ uvachllom̃ poʼpsheñeñ paʼtaruasañresho ñeñt̃ cohuam̃peneʼ uvachmaʼ. Allempoña c̈hen allpaʼ enamhuenan ñeñt̃ allpon oʼpatena pamoʼmtayet arepaʼtchaʼña es apapuenayeña uvachllom̃, elloña ñeñt̃apaʼ c̈ha nalleʼtapueñet, oʼ alla mueñoʼteret eʼñe att̃a. ");
INSERT INTO ameNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Allempoña ñeñt̃ pamoʼmteʼ pen uvachmaʼpaʼ oʼ alla mueñerranerr poʼpsheñeñ paʼtaruasañer. Allempo c̈henerr allpaʼ ñapaʼc̈hoʼña c̈ha es otnareʼtapetpaʼ oʼc̈hoʼ nalleʼtapet oʼ matateret eʼñe att̃a. ");
INSERT INTO ameNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Allempo pomaʼpocheño oʼ alla mueñerranerr poʼpsheñeñ paʼtaruasañer. Ñeñt̃paʼc̈hoʼña allempo c̈henerr ñam̃a allpaʼ ñañapaʼ c̈ha atarr atserrp̃atseʼtapetpaʼ oʼc̈hoʼ alla matateret. ");
INSERT INTO ameNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Allempoña ñeñt̃ pamoʼmteʼ penetpaʼ atet̃ ot: “T̃eʼpaʼ errot̃uachñacaʼyeña nepeʼt̃eʼ. T̃eʼpaʼ oʼch nemñe ñeñt̃ eʼñe na nechemer ñeñt̃ atarr nemorrentena. Ñatoʼrraña ñeñt̃paʼ mechaʼnaʼtapetchaʼ.” ");
INSERT INTO ameNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Arepaʼtchaʼña amaʼt mameshapaʼ mechaʼnaʼtapeto. Allempo entapoñet puechemerpaʼ atet̃ otannaʼtyeset: “Añmapaʼ ñeñt̃caʼyeña puechemer ñeñt̃chaʼ oʼpaterraya pompor puenarem̃ esempo. Ñapaʼc̈hoʼña t̃eʼpaʼ oʼchcaʼye yemtsap̃ allochñapaʼ yachcaʼyeña eʼñe oʼpaterrayaña pompor puenarem̃.” ");
INSERT INTO ameNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Allempoñapaʼ oʼ rromapet oʼ chetareʼtnomet narmetsmo aʼyot̃, allña muetsapoñetña ñam̃a puechemer. Arrpaʼ allohua atet̃ tomaʼntata Jesús eʼñe ñañeña. Jesúsñapaʼ atet̃ oterranerr acheñeneshaʼ: —Ñehua, t̃eʼpaʼ oʼch notas, ñeñt̃ pamoʼmteʼ pen ataruasañec̈hnopaʼ atet̃chaʼ p̃ohuerranet. ");
INSERT INTO ameNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ñerraʼm esempoch huerranet, pamoʼmtayetpaʼ aʼcllatuerranetchaʼ, narmetsmaʼña oʼch apuerran poʼpotantañ. Acheñeneshaʼñapaʼ allempo eʼmueñet Jesús atet̃ oten, ñetñapaʼ atet̃ ochet: —¡Ñeñt̃paʼ arepaʼchña att̃eyeʼ p̃atsterro, Neyompor-re! ");
INSERT INTO ameNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesúsña att̃a cohuanetpaʼ atet̃ otanet: —Ñerraʼm ama atet̃ pueperraʼchepaʼ esoʼmareʼtña otenña Yompor poʼñoñ ñeñt̃ anuaret̃ ahuat̃ot̃eñ, ñeñt̃paʼ eʼñechcaʼye poʼñoc̈h atet̃ perra. T̃arroʼmar ñeñt̃paʼ atet̃ oten nocop, all atmaʼntataret̃en mapueʼ. Ñeñt̃paʼ eʼñe atet̃ anuaret̃ Yompor poʼñoñ ahuat̃ot̃eñ: Añ mapueʼ ñeñt̃ ama pocteyeʼ entyeno ñeñt̃ t̃omatyeneʼ pocoll, ñeñt̃ña t̃eʼpaʼ oʼ anaret̃terra ñeñt̃chaʼ ello atarr cohuen sherberrets eʼñe atet̃ ñerraʼm quellpach allo eʼñe cohuen echarr orratenet pocoll. ");
INSERT INTO ameNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Elloñapaʼ atet̃ otanet: —Allohuen ñeñt̃ epot̃oʼtetsa añ mapyopaʼ atarrchaʼ atserrpenanet, ñam̃a añ mapueʼpaʼ ñerraʼm eseshesho mataʼnompaʼ eʼñech aʼtpetseʼtuosanet. ");
INSERT INTO ameNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Añña ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ ñam̃a ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar, ñetña allempopaʼ oʼ eñochet ñetcaʼye atmaʼntataret̃tenet, ñeñt̃paʼ ñocpuetcaʼye atet̃ eñorenaña Jesús. Allempoña ñetpaʼ atarr mueneñetañ oʼch rremuet Jesús eʼñe allorocma t̃arraña ama eseshayeʼ rromaye t̃arroʼmar ñetpaʼ mechaʼteñet acheñeneshaʼ. Ñehua, acheñeneshaʼ eʼñecaʼye cohuen enteñet Jesús. ");
INSERT INTO ameNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","T̃arraña ñetpaʼ aña atarr eʼnenet att̃och amaʼt parrochapaʼ oʼch eñorachet ñeñt̃ ama pocteyaye amaʼt ñam̃a gobiernocop, allochñapaʼ att̃och rremuet oʼch pomueñetaʼ am̃chaʼtaret̃esho ñeñt̃ nen gobiernoʼ Romot̃ ñeñt̃ am̃chaʼtaret̃tetsa alloʼmarecop. Att̃eña ñetñapaʼ eʼñe aʼnahua mueñet allponsheña acheñ Jesúsesho ñeñt̃ ottetsañ ñerraʼmrrat̃eʼ atarr cohuen acheñ, t̃arraña ñetpaʼ añecpa amñaret̃tet att̃och eʼñe pueshquëñot̃ poʼñoñot̃etpaʼ oʼch eñorachet ñeñt̃ ama cohuenayaye. ");
INSERT INTO ameNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Allempoña c̈hapuet ñeshopaʼ atet̃ otoset: —Maestrochaʼ yapaʼ yeñotenep̃ ñeñt̃ atet̃ peñen ñam̃a att̃o peyc̈hatyen Yompor poct̃ap̃ña ñeñt̃paʼ eʼñe cohuenacma. P̃apaʼ allohuen acheñ eʼñe cohuen pentueñ; ama aña ñapuet̃ pemorrenteno ñeñt̃ atarr am̃chaʼnaʼtpoʼ entyen allohuen acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ñeñt̃oʼmarña t̃eʼpaʼ yemneñ oʼch peñotatapuey erraʼtsent̃eʼña eʼñe poʼñoc̈h cohuentetsa. ¿Pocteʼt̃eʼ oʼch yetsaʼta impuestos añecop ñeñt̃ am̃chaʼtaret̃tetsa Romo, ñeñt̃ ama judioneshayaye? Ñatoʼ amat̃eʼ pocteyaye yocop ñeñt̃ey judioneshay oʼch yetsaʼta am̃chaʼtaret̃ romoʼmarneshaʼ ñeñt̃ ama judioneshayaye. ");
INSERT INTO ameNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesúsñapaʼ eñotanet ñeñt̃ atet̃ shecareʼteñetañ, ñañapaʼ atet̃ otanet: ");
INSERT INTO ameNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Ñehua, segaten puetallarr quelle. Gatuetpaʼ atet̃ otanet: —Ñehua, sapaʼ oʼch soten, ¿eseshaʼt sentenña ñeñt̃ atmaʼntataret̃tetsa all? ¿Eseshaʼt paʼsoʼcheñ ñeñt̃ aquellcaret̃tetsaña all? Ñetñapaʼ atet̃ ochet: —Am̃chaʼtaret̃caʼye atmaʼntataret̃tetsaña all ñam̃a ñocaʼyeña paʼsoʼcheñ ñeñt̃ aquellcaret̃tetsa all. ");
INSERT INTO ameNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesúsñapaʼ alla oterraneterr: —Ñeñt̃epñapaʼ añ poctetsa oʼch yap̃ am̃chaʼtaret̃ ñeñt̃ ño ñeñt̃ atet̃ poctetsa gobiernocop; t̃arraña ellonet̃ ñeñt̃ Yomporo oʼch yap̃ ñam̃a ñeñt̃ atet̃ poctetsa ñocop. ");
INSERT INTO ameNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Att̃oña amaʼt pueshquëñot̃et atet̃ otyenetpaʼ ama errot̃enot̃ eñoracheto ñeñt̃ ama pocteyaye amaʼt ñam̃a gobiernocop t̃arroʼmar allohuen acheñeneshaʼ ñeñt̃ alloʼtsaʼyen eʼñe cohuen enteñet atet̃ anapuenanet Jesús. Ñeñt̃ña ashcañneshaʼpaʼ att̃a cohuanrrorteñet t̃arroʼmar atarr cohuen anapuenanet Jesús. Ñeñt̃oʼmarña ñetpaʼ ama errot̃enayeʼ otenayeʼ entereterro. ");
INSERT INTO ameNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Allempoñapaʼ huac̈haʼtoña ñam̃a patantarr ñeñt̃ saduceoneshatets. Ñehua, ñeñt̃ saduceoneshatets ñetñapaʼ ellonet̃ echenet poct̃ap̃ña ñeñt̃oʼmar atet̃ otenet amat̃eʼ errot̃enot̃ yetanterroña rromot̃ amaʼt errponaña. ");
INSERT INTO ameNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ñetñapaʼ atet̃ otoset Jesús: —Maestrochaʼ ahuat̃ Moiséspaʼ atet̃ quellconay ñoñets ñeñt̃ poctetsa ñeñt̃chaʼ atet̃ yep̃a. Ñeñt̃paʼ atet̃ otenña Moisés poʼñoñ: Ñerraʼm esempo rroma yacma oʼch saʼnman puet̃apor t̃arraña ama chemereʼtnomopaʼ añ poctetsa paʼmoʼnasheñchaʼ alla yorerreʼña poʼnorrar allochñapaʼ att̃och eñalleterraña ñeñt̃chaʼ puechemer perr paʼmoʼnasheñeñ. Ñeñt̃paʼ atet̃caʼye quellcaʼnmonayña Moisés ahuat̃. ");
INSERT INTO ameNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ñehua, t̃eʼpaʼ eñall canc̈herrsheña ñeñt̃ eʼñe poctacma paʼmoʼnasheñecmuet. Ñeñt̃ puesheñarr popoʼnaretpaʼ oʼ yoran coyaneshaʼ ñeñt̃ puet̃apor p̃aʼ. Eʼñe allponmatatsapaʼ oʼ rromaña, yacma ama chemereʼtnomo. ");
INSERT INTO ameNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Allempoña ñeñt̃ poʼrroc̈hoʼmerpaʼ oʼ yorerran paʼmoʼnasheñeñ puet̃apor. Eʼñe allponmatatsapaʼ ñapaʼc̈hoʼña oʼ rromuerrerr ñam̃a, ñeñt̃paʼc̈hoʼña ama chemereʼtnomo. ");
INSERT INTO ameNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Allempoña poʼpsheñeñ paʼmoʼnasheñpaʼ oʼ alla yorerranerr ñam̃a poʼnorrar. Eʼñe allponmaterrtsapaʼ ñapaʼc̈hoʼña oʼ rromuerrerr ñam̃a, ñeñt̃paʼc̈hoʼña ama chemereʼtnerrerro oʼ att̃a rromuerrerr. Eʼñe att̃ecma p̃ohuet canc̈herrsheñoʼmaretpaʼ eʼñe pueyoruarochet ñeñt̃ara puesheñarr coyaneshaʼ. Eʼñe allohuenetpaʼ eʼñe att̃ecma pet collaʼhuet amaʼt puesheñarrot̃etapaʼ ama chemereʼtnomueto. ");
INSERT INTO ameNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Allempoña oʼ rromaña ñam̃a coyaneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","T̃eʼña ñerraʼm poʼñoc̈ht̃eʼ yetantena yerromñot̃paʼ añña coyaneshaʼ allempopaʼ ¿eseshaʼtchaʼña puet̃apor perreʼ t̃arroʼmar allohuenet canc̈herrsheñoʼmaretpaʼ eʼñe pueyoruarochet? ");
INSERT INTO ameNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Allempoña Jesús otanet: —Ñehua, atet̃ yec̈hen acheñeneshaʼ arr patsro, c̈hocmach senaʼtenet, coyaneshaʼpac̈hoʼña apueñet ñeñt̃chaʼ puerrollar p̃aʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","T̃arraña esempohuañen allempoch tanterret poʼpocheño allohuen ñeñt̃chaʼ eʼñe pocteʼ entuerr Yompor allochñapaʼ att̃och oʼch alla correrret poʼpocheño, ñetña allempopaʼ amaʼt puesheñarrot̃eta amach senaʼterreto, amaʼt coyaneshaʼpaʼc̈hoʼ amach eseshayeʼ apuerraye ñeñt̃chaʼ yorerrahuet. ");
INSERT INTO ameNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","T̃arroʼmar allempopaʼ amach arromñat̃terreto amaʼt ahuat̃a att̃och eʼñech atet̃ perret ñerraʼm mellañot̃eñnaneshaʼ. Yomporñapaʼ oʼch eʼñe puechemer perranet eʼñe poctacma t̃arroʼmar allempopaʼ oʼ tanterret rromot̃paʼ oʼhuañchaʼ arromñat̃terret amaʼt errponaña. ");
INSERT INTO ameNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Elloña amaʼt Moisés atet̃ eñotataneʼt̃ acheñeneshaʼ poʼñoc̈h ñeñt̃ collaʼhuatsa allempo, ñetñapaʼ corretseta. Ñehua, all aquellcaret̃ tsachmoʼr ñeñt̃ eʼñe ñot̃a huortets. Allot̃ñacaʼyeña Yomporpaʼ eñoranaʼtanaña Moisés; ñeñt̃paʼ atet̃caʼ otña Yompor allempo: “Napaʼ ñeñt̃en Poʼyomporer pen Abraham ñam̃a Isaac, ñam̃a Jacob.” ");
INSERT INTO ameNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Jesúsñapaʼ alla oterraneterr: —Ñehua, yapaʼ yeñoteñ Yomporpaʼ ama añeyeʼ Poʼyomporer penaye ñeñt̃ rromuets eʼñe poctacma ñapaʼ añcaʼyeña Poʼyomporer peneʼ acheñ ñeñt̃ corretsach. Yomporñapaʼ eʼñe entenanet allohuenetpaʼ eʼñe corretseta. ");
INSERT INTO ameNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Añña puesheñaʼtets ñeñt̃ atarr etsoteneʼ ñoñets ñeñt̃ atet̃ anaret̃, ñetñapaʼ atet̃ ochet: —Eʼñe Maestrochaʼ eʼñe poʼñoc̈h atet̃ p̃oten. ");
INSERT INTO ameNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ñeñt̃oʼmar allempot̃eñpaʼ amaʼt puesheñarrot̃etapaʼ ama eseshayeʼ aʼp̃t̃oʼtenayeʼ enterraye. ");
INSERT INTO ameNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Allempoña Jesúspaʼ atet̃ otan ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃: —Esoʼmareʼtña otyenet ñeñt̃chaʼ Cristotosets ñapaʼ aña poʼm̃reneñ peneʼ David t̃arroʼmar ñeñt̃chaʼ Cristoterrets ama aña poʼm̃reneñ peñe David t̃arroʼmar ñapaʼ Poʼpartseshareʼnaña peʼt̃ David. ");
INSERT INTO ameNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","T̃arroʼmar amaʼt Davidpaʼ allempo quellquëʼt̃ all libro Salmo allempopaʼ atet̃caʼye eñoseʼt̃ña añecop ñeñt̃chaʼ Cristoterrets: Yompor Paretspaʼ atet̃ otennan ñeñt̃ Nepartseshar nepen na (ñeñt̃ara ñeñt̃chaʼ Cristoterrets): “T̃eʼpaʼ oʼch p̃anorruerr arr necohuenrot̃ allchaʼ pecohuentapreterrna. ");
INSERT INTO ameNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Att̃ochña amaʼt ñeñt̃ peʼmoñeʼteneʼ napaʼ oʼch nameʼñatuerranet allochñapaʼ oʼch atet̃ perret ñeñt̃ pemnen p̃a.” ");
INSERT INTO ameNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ñeñt̃paʼ atet̃caʼye oteʼt̃ña David ñeñt̃chaʼ Cristoterretspaʼ ñeñt̃caʼyeña Poʼpartseshar peʼt̃ña amaʼt allempot̃eñ. Ñehua, amaʼt señoteñeña Cristo ñeñt̃ Poʼpartseshar peʼt̃ David ñeñt̃ña t̃eʼpaʼ oʼ alla poʼm̃reneñ per ñam̃a. ");
INSERT INTO ameNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Elloña shonteʼ acheñeneshaʼ ñeñt̃ eʼm̃ñoʼteneʼ allempo atet̃ otenan Jesús pueyochreshaʼ: ");
INSERT INTO ameNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Amach semeñeʼtapretatsche ommoñat̃eneshaʼ poct̃ap̃ña ñeñt̃areta ñeñt̃et atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃. T̃arroʼmar ñetpaʼ añeʼnaña atarr cohuen entenet oʼch chorrenet atarrom shetamuets oʼch att̃a yormaʼtatseʼtenet paʼshtam. Ñam̃a pommoʼcheñot̃etpaʼ atarrchaʼ mueneñet oʼch eʼñe puem̃chaʼnaʼteñot̃ eʼñech cohuen huom̃chaʼtenanet acheñeneshaʼ all chopeñeʼchyenet. Ñam̃a ñetpaʼ añeʼnach atarr muenenet oʼch anorrc̈haʼtyenet judioneshaʼ poʼprahuo allecma anorryen ñeñt̃ atarr am̃chaʼnaʼtpoʼ entyen allohuen acheñeneshaʼ ñam̃a eʼñe att̃ecma penet ñam̃a all rrallmeʼchapretenet. ");
INSERT INTO ameNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","T̃arraña ñetñapaʼ rret̃orrnaneshaʼnaña puerratam̃pesyenetña paʼpaquëll. Elloña eʼñe pommoʼcheñot̃etpaʼ aña atarr muenenet oʼch atet̃ penet ñerraʼmrrat̃eʼ ñetpaʼ atarroʼ cohuen acheñret ñeñt̃oʼmarña arrchaʼ maʼyochenet all shontena acheñeneshaʼ, amach t̃ematenayaya maʼyocheneto. Ñeñt̃oʼmarña t̃eʼ napaʼ oʼch notas, ñeñt̃ atet̃ petsa pommoʼcheñot̃paʼ elloña atarrchaʼ aʼcoñchaʼtaret̃terret. ");
INSERT INTO ameNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Allempo alloʼtsen Jesús Parets paʼpacllo, ñañapaʼ arrenet̃ cohuen allecma nenet quelle Partsocop. Allñapaʼ entenan ec̃llayoret̃eneshaʼ ñeñt̃ naʼyeneʼ shonteʼ poʼc̃llayor Partsocop. ");
INSERT INTO ameNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Jesúsña allpaʼ att̃a cohuenanet, huapa ñam̃a puesheñarr rret̃orrnaneshaʼ ñeñt̃ atarr huocchañetets. Ñapaʼc̈hoʼña nosan eptallat̃oll quellayet̃oll ñeñt̃ cobretall. ");
INSERT INTO ameNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesúsñapaʼ atet̃ ot: —T̃eʼpaʼ oʼch notas, añ rret̃orrnaneshaʼ amaʼt atarr huocchañ ñapaʼ poʼñoc̈hcaʼye atarr aton nosan quelle, ello metanaʼtuosan allohuen poʼpotantañec̈hno allpon quelle ñeñt̃ naʼyenet ñet. ");
INSERT INTO ameNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","T̃arroʼmar allohuenet ñeñt̃ naʼyenet quelle, añacaʼye naʼyenet ñeñt̃ aʼpchatyenet, ñañapaʼ amaʼt atarr huocchañpaʼ eʼñe pomhuahuospan allohuen ñeñt̃ echyen ñeñt̃ muenatenaneñ alloʼch yoran att̃och correna arr patsro. ");
INSERT INTO ameNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Allempoña puesheñaʼttets ñetñapaʼ aña atarr serrpareʼtyenet att̃o Parets paʼpaquëllpaʼ atarr aʼcohuentateñ. Mapyet ñeñt̃ allo orratenet Partsopoʼ ñeñt̃paʼ atarr coc̈hneshareʼ ap̃aʼyesaret̃. Shonteʼ coc̈hneshareʼ ñam̃a alloʼtsaʼyen ñeñt̃ pomyen acheñeneshaʼ all Partsocop. Jesúsñapaʼ atet̃ otanet: ");
INSERT INTO ameNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Ora ñeñt̃ allpon eʼñe coc̈hneshareʼ sentyen t̃eʼ c̈herrchaʼ allempoch eʼñe aʼmataʼtaret̃etuerra. Amaʼt puem̃arra mapyetpaʼ amach aʼpuerroña all allo orratenet Partsopoʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Pueyochreshaʼñapaʼ aʼp̃t̃oʼchet: —Maestro, ñeñt̃paʼ ¿esempoʼtchaʼña atet̃ perra? Ñam̃a allempopaʼ ¿esoʼtchaʼña yentyerr ñeñt̃chaʼ yeñotaterreʼ poʼñoc̈hpaʼ oʼch c̈herrmoch allempoch eʼñe etsotuerra ñeñt̃ atet̃ p̃oteney t̃eʼ? ");
INSERT INTO ameNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesúsñapaʼ otanet: —Eʼñech señoterra, allochñapaʼ amach eseshaʼ seshquërraye. T̃arroʼmar shonteʼch orrterrtsa ñeñt̃chaʼ ayc̈haʼnataterreʼ nesoʼcheñ, ñeñt̃chaʼ otyerrets: “Napaʼ ñeñt̃encaʼyeña Cristotets; t̃eʼpaʼ oʼcaʼye c̈herr allempoch norrterra na ñeñt̃en Cristotets.” T̃arraña sañapaʼ ñatoʼtña seʼm̃ñotenanetaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ñam̃a allempopaʼ oʼch seʼmareʼtyerr oʼ quellareñtsotyerr allemeñ anetsoʼmar ñam̃a oʼch seʼmareʼtyerr oʼ orrterra ñam̃a at̃parñats errap̃aren, saña allempopaʼ amach c̈ha seyorenatsto amaʼt eʼñe mamesha. Ñeñt̃paʼ atet̃chaʼcaʼye eʼñe poʼñoc̈h perra. T̃arraña allempopaʼ amach c̈henaʼ allempoch eʼñe mellapoterra. ");
INSERT INTO ameNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesúsñapaʼ alla oterraneterr: —Paʼnamen acheñ ñeñt̃ eʼñe poʼpoñeʼttsocma mereñtsoret ñetpaʼ quellarannaʼterretchaʼ. Ñam̃a paʼnamen anetsot̃ am̃chaʼtaret̃ec̈hnopaʼ quellaraterranchaʼ pueyochreneshac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Pellaʼyerrach pats huomenc ora errap̃aren, ñam̃a orrterrach allemeñ muec̈heñets oʼch eʼñe chaporrñatsotyerr errap̃aren. Orrterrach ñam̃a paʼnamen atsnañtsoc̈hno ñeñt̃ atarr apatannaʼtpoʼ. Allempopaʼ atarrchaʼ am̃chaʼnoc̈hterra entot̃. Orrterrach ento ñeñt̃ amaʼt ahuat̃apaʼ ama puentareto ñeñt̃chaʼña eñotaterrahuet oʼ eʼñe c̈herrmoch allempoch mellapoterra. ");
INSERT INTO ameNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Ñehua, allempoch ama orrtenaʼ atet̃paʼ saña allempopaʼ rremanaterrsetchaʼ att̃och mueroc̈htaterrset, sanmaret̃terrach judioneshaʼ poʼprahuo allchaʼña eʼñe otteñeʼcherrset, att̃ochña abeʼt̃errset cárcelo allchaʼ coñchaterrset. Eʼñe sameʼñeñot̃en na sapaʼ sanmaret̃terrach am̃chaʼtaret̃nesheshoʼmar ñam̃a alloʼtsaʼyen ñeñt̃ nanac am̃chaʼtaret̃neshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","T̃arraña allempopaʼ atarrchaʼ cohuen att̃och saʼmet̃osnanña neñoñ. ");
INSERT INTO ameNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ñeñt̃oʼmarña allempo sanmaret̃etyesa allchaʼ otteñeʼcherrset amaʼt mameshapaʼ amach sellcaʼp̃satsto, amach sotap̃saʼtatsto, errot̃uachcaʼye notost̃eʼ am̃chaʼtaret̃esho allempoch aʼp̃t̃oʼtareʼtapuen. ");
INSERT INTO ameNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","T̃arroʼmar allempopaʼ nachcaʼyeña seʼñoratoseʼña all att̃och eʼñe cohuen señotyesña atet̃chaʼ sanapyesosanet. Allochñapaʼ ñeñt̃ seʼmoñeʼteneʼpaʼ amach errot̃enayeʼ otenayeʼ entenseto. Ñam̃a amach errot̃enot̃ otaseto ñeñt̃ atet̃ soten sapaʼ ñeñt̃paʼ amacaʼ poʼñoc̈hayeʼ atet̃ soteno. ");
INSERT INTO ameNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Elloña allempoch atet̃ perrsetpaʼ ñeñt̃ eʼñe sompor sepen ñam̃a sachor ñatoʼ ñeñt̃achcaʼye sepomuerreʼ t̃arroʼmar ñapaʼ amacaʼye ameʼñenno, amapaʼ ñatoʼ semoʼnasheñ, amapaʼ ñatoʼ poʼpotantañ samoʼtseshaʼ, amapaʼ ñatoʼ ñeñt̃ eʼñe parro seyemtena ñeñt̃achcaʼye sepomuerreʼ t̃arroʼmar ñetpaʼ ama parrocmayeʼ att̃ecma soct̃apeʼcheno. Ñam̃a patantaʼttsospaʼ muetsatyerrsetchaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Shonteʼch acheñeneshaʼ ñeñt̃chaʼ seʼmoñeʼterreʼ t̃arroʼmar sapaʼ nacaʼye eʼñe sameʼñena. ");
INSERT INTO ameNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Napaʼ atarrchaʼ necuam̃penes att̃och amach errot̃enot̃ sechenquërro amaʼt eʼñe ahuat̃a. Att̃oña amaʼt eʼñe puep̃arra sechpaʼ ñeñt̃paʼc̈hoʼña amach naʼchencaterrnaso. ");
INSERT INTO ameNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","T̃arraña amaʼtchaʼ atarr mueroc̈htaterrset c̈hocmachña eʼñe seyemteñot̃en napaʼ eʼñech saʼhuantaʼhuanomña allohuen mueroc̈hteñets. Att̃ochña sapaʼ corretsasach eʼñe poʼñoc̈h. ");
INSERT INTO ameNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Ñerraʼm esempoch senterr añ anetser Jerusaléñpaʼ oʼch eʼñe rroc̈htam̃pera solltarneshaʼ allempoña sapaʼ señochepaʼch oʼ c̈herrmoch att̃och eʼñe aʼmataʼtaret̃etuerra ñeñt̃ anetser Jerusaléñ. ");
INSERT INTO ameNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Allempoña ñeñt̃ allpon Judeoʼtsaʼyenpaʼ ñetñapaʼ allorocmuepaʼch yetrraʼtuerret ahuanerretepaʼña aspent̃areronet̃. Ñam̃a ñeñt̃ allpon anetsoʼtsaʼyen Jerusaléño, ñetpaʼc̈hoʼña ahuanemyesetepaʼch ñamet allot̃. Ñam̃a ñeñt̃ allpon allampañoʼtsaʼyen all arepaʼchña tatsterretoña all Jerusaléño. ");
INSERT INTO ameNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","T̃arroʼmar allempopaʼ Yomporchaʼña tsaʼtaterrayaña allohuen israelenaʼtarneshaʼ, t̃arroʼmar allempopaʼ oʼch eʼñe etsoterra ora allpon ñeñt̃ atet̃ anuaret̃tatseʼt̃ atet̃chaʼ perra allempo. ");
INSERT INTO ameNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Allempopaʼ atarrchaʼ llequëñets añecop ñeñt̃ ac̈homenareʼ coyaneshaʼ ñam̃a ñeñt̃ allohuen emaret̃et̃olleshac̈hno. (Tarroʼmar ñocpuetpaʼ atarr t̃orrapoʼ att̃och yetrraʼtet ñamet.) T̃arroʼmar allempopaʼ oʼch orrterra ñeñt̃chaʼ atarr mueroc̈htaterrahuet arr patsro. Atarrchaʼ aʼcoñchataret̃terra allohuen acheñeneshaʼ allempo. ");
INSERT INTO ameNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ñam̃a allempo shonteʼ acheñpaʼ eʼñech muetsanatuerranet ñeñt̃chaʼ quellarerrahuet. Poʼpotantaññapaʼ rremanatuerranetchaʼ ñeñt̃ quellarenahuet oʼch anmaret̃terret poʼpoñ anetso b̃ac̈hayo all yec̈haʼyena paʼnamen acheñ. Acheñeneshaʼ ñeñt̃ ama judioneshayayepaʼ ñeñt̃chaʼña eʼñe aʼmtsoññetuerreʼña jerusaléñoʼmarneshaʼ, att̃och eʼñe at̃mamaʼtueretña ñeñt̃ anetser Jerusaléñ. Atet̃chaʼcaʼye perra ñeñt̃ allponmat onañcharet̃ ñeñt̃ ama judioneshayaye oʼch am̃chaʼnoc̈hterret all Jerusaléño. ");
INSERT INTO ameNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Allempopaʼ orrterrach ento ñeñt̃ amaʼt ahuat̃apaʼ ama sentare ñeñt̃chaʼña señotaterreʼ, ñeñt̃paʼ eʼñech atsnesho, orrterra ñam̃a arrorresho ñam̃a rantoc̈hnesho. Ñam̃a arr patsro ora allpon paʼnamen acheñeneshaʼ pueyorñot̃etpaʼ atarrchaʼ nanac llecaʼrrterret. Añchaʼ atarr yoreʼtameʼterrahuet att̃o ñeñt̃ añecmuen saʼppaʼ oʼch emoʼyarterra, atarrchaʼ huomenc maʼmoreterr allempo. ");
INSERT INTO ameNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Acheñeneshaʼ eʼñe pom̃chañot̃etpaʼ c̈hach mueneʼ ot̃anatyerret t̃arroʼmar allempopaʼ oʼch eñoterret atarrchaʼ mueroc̈hterret allohuenet arr patsro. Ñam̃a ñeñt̃ huomenc orraʼyetsa ento t̃eʼ, allempoña amaʼt ñeñt̃paʼ pellaʼyerrach. ");
INSERT INTO ameNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Allempoñapaʼ entapuerrnetchaʼ na Ñeñt̃en Acheñetosets oʼch nesuam̃perra oso eʼñe nepartsoteñohuen eʼñe necohuenteñeshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ñerraʼm esempoch senterr oʼ mot̃etnerra orretyestsa ñeñt̃ allpon oʼ notuas, allempoña sapaʼ eʼñech socsheñeshaʼ secuanrrorterr enonet̃ t̃arroʼmar allempo oʼch c̈herrmoch allempoch saʼqueshp̃ataret̃terra eʼñe poctacma. ");
INSERT INTO ameNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Allempoña Jesúspaʼ alla serrpareʼtaterraneterr tomaʼnteñtso, ñeñt̃paʼ atet̃ oterraneterr: —Señotent̃eʼ atet̃ pena tsach, higoch. ");
INSERT INTO ameNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Oʼch senteñ allempo tapnaʼtyen pasopanerpaʼ sañapaʼ ñeñt̃aña señotateneʼña oʼ c̈henmoch allempoch huorateterrerr. ");
INSERT INTO ameNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Att̃ecmach perra ñerraʼm esempoch sentyerr ñam̃a allpon ñeñt̃ oʼ notuas sapaʼ ñeñt̃chaʼña señotaterreʼ poʼñoc̈h oʼcaʼye c̈herrmoch allempoch eʼñe etsoterra allempoch am̃chaʼtaret̃terra Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Napaʼ poʼñoc̈h oʼch notas, acheñeneshaʼ ñeñt̃ corretsa t̃eʼ ñetpaʼ amach eʼñe rromhuenetaʼpaʼ allempocmach eʼñech etsoterra allohuen añec̈hno. ");
INSERT INTO ameNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Esempopaʼ añ enet ñeñt̃ sentenpaʼ eʼñech chencaʼhuerra; patspaʼc̈hoʼña att̃ecmach perra eʼñech chencaʼhuerra. T̃arraña naña neñoñpaʼ amach chenquërro amaʼt eʼñe errponaña. ");
INSERT INTO ameNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’T̃arraña t̃eʼpaʼ oʼch notas, sapaʼ c̈hocmachña eʼñe señotnoma att̃och sapaʼ amach aña soct̃apeʼchatsto ñeñt̃ sosyaʼtsañec̈hno, posaʼtareʼteñets, ñam̃a att̃o eʼñe cohuen socrrena añ patsro. T̃arroʼmar ñerraʼm ñeñt̃a eʼñe soct̃apeʼchenpaʼ machayot̃ach huaponasa añ yet̃er ");
INSERT INTO ameNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","atet̃ ñerraʼmrrat̃eʼ tamell eʼñech machayot̃a rreman ñeñt̃ecop amencaret̃. Ñeñt̃e yet̃arocmach c̈herrana ora allohuen ñeñt̃ yec̈haʼyetsa añe patsro errap̃aren. ");
INSERT INTO ameNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Añchaʼña sapaʼ c̈hocmachña señoseʼrtena ñam̃a añchaʼña senamuen Yompor att̃och saʼhuantaʼhuanom allohuen ñeñt̃chaʼ sehuapoya paʼnamen mueroc̈hteñtsoc̈hno allochñapaʼ sañapaʼ eʼñech señmañeshaʼ sat̃omhuerr nesho na Ñeñt̃en Acheñetosets. ");
INSERT INTO ameNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","C̈hocma atet̃ peʼt̃ Jesús, ellapeneʼt̃chaʼ yec̈hatats Parets paʼpacllo, ellerronet̃ñapaʼ oʼch ahuerr Olivop̃no ñapaʼ allcaʼye eʼñe aʼpueʼt̃. ");
INSERT INTO ameNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tsapat̃ puetaren ahuat̃ecmach huapaʼmueneʼt̃ ñam̃a shonteʼ acheñeneshaʼ ñeñt̃ eʼm̃ñotyesayeʼt̃ all serrpareʼtataneteʼt̃ Yompor poʼñoñ all Parets paʼpacllo. ");
INSERT INTO ameNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Allempoña c̈hapmoch allempoch c̈herrerr pascuapo, allempoch rrerranerr judioneshaʼ pan ñeñt̃ ama anaret̃eyaye chaseʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","T̃arraña allohuen ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar ñam̃a allohuen ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃et ñocpuet, ñetñapaʼ Jesúsa atarr oʼpatenet oʼch muetsatachet t̃arraña ñetpaʼ aña mechaʼnaʼtenet acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Allempoña oneñet̃paʼ chorrenana Judas ñeñt̃ara ñeñt̃ sochetsa Iscariote. Ñehua, añ ñeñt̃ Judaspaʼ Jesús pueyochreshaʼ ñeñt̃ parro yemtena poʼpotantañ ñeñt̃ llesensen Jesús ñeñt̃ allohuenet c̈harrasheñet puechenet epsheña. ");
INSERT INTO ameNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ñeñt̃ña Judaspaʼ ahuoʼ alloʼtsaʼyen ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar ñam̃a alloʼtsaʼyen judioneshaʼ poʼguardiarneshaʼ ñeñt̃ cohuam̃peneʼ Parets paʼpaquëll. Allempo c̈hap allpaʼ Judasñapaʼ serrpareʼtos epuet ñeñt̃ am̃chaʼtaret̃neshaʼ. Att̃oña eñotatosanet ñapaʼ mueneñcaʼye oʼch poman Jesús att̃och rromuet. Allempo ñetñapaʼ otannaʼtyeset: —T̃eʼpaʼ errot̃uachñacaʼye yepeʼt̃eʼ att̃och yerrmueʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Allempoña ñeñt̃ atarr am̃chaʼtaret̃neshaʼpaʼ atarr coshenet, ñetñapaʼ aʼpoctachet c̈hochcaʼye tsaʼchetña Judas allpon quelle. ");
INSERT INTO ameNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ñapaʼ eʼñe pocteʼ eñch. Allempoña ñapaʼ aña atarr eʼnen errot̃enot̃chaʼ pomanña Jesús eʼñe aʼnahua att̃och amach eñche allohuen acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Allempoña c̈hapaʼmuen ñeñt̃ yet̃ñatsro allempoch rrerreterr pan ñeñt̃ ama anaret̃eyaye chaseʼ allempoch muetserreterr ñam̃a carrnero; ñeñt̃paʼ pascuapo. ");
INSERT INTO ameNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","C̈hapaʼmuen ñeñt̃ yet̃erpaʼ Jesúsñapaʼ atet̃ otaʼmuenan pueyochreshaʼ epsheña Pedro ñam̃a Juan: —Sa t̃eʼpaʼ oʼch ahues allchaʼ saʼpotos rreñets ñeñt̃chaʼ yerraʼ pascuapo. ");
INSERT INTO ameNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ñetñapaʼ atet̃ ochet: —¿Erraʼtña pocollro pemneñña allchaʼ yaʼpotaʼña rreñets? ");
INSERT INTO ameNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ñañapaʼ atet̃ oterraneterr: —T̃eʼpaʼ oʼch ahuaʼmuenes anetso allchaʼ sepocteʼ puesheñarr yacma ñeñt̃ anmam̃peneʼ oñ porrt̃o. Ñeñt̃ña acheñerpaʼ oʼch soct̃aʼner; allchaʼ beʼt̃osuerr pocollopaʼ allchaʼña sebeʼt̃osos sam̃a. ");
INSERT INTO ameNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Allñapaʼ atet̃chaʼ sotos ñeñt̃ apacllat̃eshaʼ: “Yemaestrorpaʼ atet̃ oteney atet̃chaʼ yotosep̃: ‘¿Erroʼtsenaʼtña pecuarto allchaʼ nerrallmeʼchos pascuapo epan neyochreshaʼ?’ ” ");
INSERT INTO ameNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ñeñt̃ apacllat̃eshaʼpaʼ gatapaschaʼ eno poʼcuarto ñeñt̃ atarr aʼyohuen eʼñe cohuen ap̃aret̃. Allchaʼña saññoʼtosña ñeñt̃chaʼ yerraʼ pascuapo. ");
INSERT INTO ameNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Allempo atet̃ otuanet Jesúspaʼ pueyochreshaʼñapaʼ atet̃c̈hoʼ pet, c̈ha ahuanmatset. Eʼñe atet̃ otapanet, ñetñapaʼ eʼñec̈hoʼ atet̃ entoset. Allchaʼ aññoʼtosñañetña rreñets allchaʼ rrallmeʼchenet ñeñt̃e pascuapo. ");
INSERT INTO ameNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Oʼña c̈hap allempoch rrallmeʼchet. Jesúsñapaʼ allña anorros epuet allohuen pueyochreshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Allñapaʼ atet̃ otosan pueyochreshaʼ: —Napaʼ atarr cohuen nenteñ oʼch yerrallmeʼchen parro añ pascuapo t̃ayepaʼtñapaʼ ama c̈henaʼ allempoch muetsataterrnet. ");
INSERT INTO ameNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","T̃arroʼmar napaʼ oʼch notas, napaʼ poʼpocheño amach alla nerrallmeʼcherreʼt̃e pascuapo. Esempohuañenchaʼ etsoterra ñeñt̃ poʼñoc̈h tomaʼntenaya pascuapo eʼñech allempocma am̃chaʼtaret̃etuerra Yompor. Allempoñapaʼ eʼñech parrocma oʼch alla yocsherrerr. ");
INSERT INTO ameNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jesúsña allempopaʼ chetan orramets, parasyosoʼtan pompor, allempoñapaʼ atet̃ otanet: —Añ orrpapoʼpaʼ oʼch sagap̃paʼ oʼch sepatannaʼta sa allohuenes. ");
INSERT INTO ameNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","T̃eʼpaʼ oʼch notas, t̃ayot̃eñ napaʼ amach alla norrerreʼt̃e añ orrpapoʼ ñeñt̃ narmetsos t̃arrempohuach allempoch ello norrererr esempohuañenchaʼ am̃chaʼtaret̃etuerra Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Allempoñapaʼ cheterranerr ñam̃a pan, parasyosoʼterranerr pompor. Chetan panpaʼ shotaʼch. Shotatuepaʼ apaʼyesan pueyochreshaʼ ñeñt̃paʼ atet̃ otanet: —Añpaʼ ñeñt̃chaʼ nechets sepen ñeñt̃chaʼ eʼñe nepom att̃och eʼñe nerroma socop. Ñerraʼm esempoch serren añ pan eʼñech seyerpueñot̃en na oʼch serreñ. ");
INSERT INTO ameNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Allempoña rrohuet oʼ chetan ñam̃a orramets, ñeñt̃paʼc̈hoʼña atet̃ oterraneterr Jesús: —Añpaʼc̈hoʼña ñeñt̃chaʼ nerras sepen ñeñt̃chaʼ ashataret̃tatsa socop. Ñeñt̃paʼ alloch naʼpoctatonas eʼñe cohuen etserra Nomporesho. ");
INSERT INTO ameNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’T̃eʼpaʼ oʼch señoch ñam̃a ñeñt̃chaʼ nepomuerreʼpaʼ eʼñecaʼye parro yerrallmeʼchen. ");
INSERT INTO ameNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Poʼñoc̈hcaʼye t̃eʼpaʼ alloʼna sen etsotnomtsa ñeñt̃ atet̃ onañcharet̃ nocop, na Ñeñt̃en Acheñetosets, att̃ot̃chaʼ muetsaterrnet. T̃arraña nocoppaʼ eʼñe pocteʼ; añña poʼñoc̈h acheñer ñeñt̃chaʼ nepomuerreʼ ñocoppaʼ atarr llequëñets. ");
INSERT INTO ameNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Allempoña atet̃ otua Jesús, pueyochreshaʼñapaʼ allent̃a otannaʼtyeset eʼñe ñañeñeta: —Taʼm, eseshaychaʼcaʼye pomuerreʼña Yaʼyochreshat̃er. ");
INSERT INTO ameNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Allempoña pueyochreshaʼ eʼñe pommoʼcheñot̃etpaʼ atet̃ otannaʼtyenet eʼñe ñagattseta: —Erraʼtsenot̃eyt̃eʼña ñeñt̃ey atarr asherben enten allohuen acheñeneshaʼ ñatoʼ na, ñatoʼ p̃a. ");
INSERT INTO ameNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Allempoña Jesúspaʼ atet̃ otanet: —Sapaʼ señoteñt̃eʼ ñeñt̃ atet̃ pena poʼpoñ acheñeneshaʼ ñeñt̃ ama judioneshayaye. Ñet ñeñt̃ paʼm̃chaʼtaret̃er penet eʼñech paʼm̃chaʼnoc̈hteñocmañen pomnaren p̃aʼyenan allohuen pueyochreshac̈hno. T̃arraña amaʼt atet̃ penetañ pommoʼcheñot̃paʼ añach atarr muenen allohuen acheñeneshaʼpaʼ eʼñech mechaʼnaʼtuenanet ñam̃a ñetpaʼ mueneñet acheñeneshaʼpaʼ oʼch entenanet, atarroʼ sherb̃aʼyenanet. ");
INSERT INTO ameNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Sapaʼ arepaʼchña att̃eyeʼ sep̃annaʼtatsto eʼñe sommoʼcheñot̃. Ñerraʼm erraʼtsenot̃es ñeñt̃es atarr am̃chaʼtaret̃oyen entetsa, ñeñt̃es acheñrespaʼ socoppaʼ añ poctetsa oʼch atet̃ senterra ñerraʼm ama esosheʼmayayso atet̃ ñerraʼm ñeñt̃ atarr huepueshaʼ. Ñam̃a ñerraʼm erraʼtsenot̃es ñeñt̃es mueneneʼ oʼch atarr asherben entenset, ñeñt̃esña acheñrespaʼ añ poctetsa oʼch atet̃ senterra ñerraʼm ama esoyayso, allochñapaʼ att̃och eʼñe cohuen set̃orrena poʼpotantañecop. ");
INSERT INTO ameNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ñehua, yeñoteñ acheñeneshaʼ arr patsro añcaʼye atarr am̃chaʼnaʼtpoʼ entenet ñeñt̃ eʼñe cohueno anorrc̈haʼtyets all rrallmeʼchenet, amaña añeyeʼña am̃chaʼnaʼtpoyeʼ enteneto ñeñt̃ puesherbeñot̃ epatyeneʼ rreñets ñeñt̃ anorrc̈hets ñeñt̃ rrallmeʼchets. T̃arraña napaʼ oʼch notas: Ñeñt̃ecopcaʼyeña nohuapaña sesho att̃och nemaʼyoc̈hrena t̃orraya ñeñt̃chaʼ poʼñoc̈h atarr sherberrets socop. ");
INSERT INTO ameNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’T̃arraña sañapaʼ ñeñt̃es atarr nellcapretenaya ñeñt̃ atarr llequëñets nenten na. ");
INSERT INTO ameNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ñeñt̃oʼmarña t̃eʼpaʼ oʼch nenaʼnerres sa ñeñt̃eschaʼña napuerr att̃och saʼm̃chaʼtaret̃tapreterrna eʼñe atet̃ pena Nompor oʼ naʼn nam̃a ñeñt̃enchaʼ am̃chaʼtaret̃tapreterraya. ");
INSERT INTO ameNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Allchaʼ sanorrc̈haʼtyesuerr eʼñe sa seconaño allchaʼ eʼñe saʼm̃chaʼtaret̃etyesuerra. Eʼñe puesheñaʼttsos añecopchaʼña saʼm̃chaʼtaret̃etyesuerra ñeñt̃ mereñtsorecop israelenaʼtar ñeñt̃ c̈harraʼ mereñtsor ñeñt̃ puechetsa epsheña. Att̃oña allpaʼ oʼch naʼm̃chaʼtaret̃terra eʼñe necohuenño eʼñech cohuen yeparrocmatuerr, allñapaʼ eʼñech yocsheñeshocmañen yerrallmeʼchuerr eʼñe parro. ");
INSERT INTO ameNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","’Simón, poʼñoc̈h t̃eʼpaʼ oʼch notap̃, oneñet̃paʼ atarrcaʼye enamuenen na socop, añ muenen oʼch topatenes oʼch atet̃ p̃atenes ñeñt̃ atet̃ cot̃apeʼchen ña ñeñt̃ ama pocteyeʼ enteno Yompor. Oʼch atarr huomenc topatenes atet̃ ñerraʼm ñeñt̃ shoshneneʼ poʼtrigor eʼñech huomenc paʼshmuenan pueshoshnat. ");
INSERT INTO ameNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","T̃arraña Simón oʼch notap̃, t̃eʼpaʼ napaʼ oʼ nemaʼyochua p̃ocop att̃och amach eʼñe poctacma aʼhuañam̃p̃sonapeña p̃a att̃o atarr peyemtenna. T̃arraña amaʼtchaʼ huaponap̃añ topateñets ñeñt̃ atarr huomenc, p̃aña allempopaʼ oʼch alla p̃oct̃apeʼcherr cohuen Yomporecop. Allempoñapaʼ oʼch alla eʼñe cohuen peyenpuer pemoʼnasheñneshaʼ att̃och ñetpaʼc̈hoʼña oʼch alla huomenc perret pueyoc̈her Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pedroñapaʼ atet̃ och: —Partseshachaʼ napaʼ amach naʼypoʼñape, c̈hocmach noct̃ap̃ amaʼt errach anmapet; ñerraʼm cárceloch anmapet allchaʼ mueroc̈htatapet, napaʼc̈hoʼña nemnen allchaʼ yemueroc̈hta parro. Amaʼtchaʼ c̈ho muetsapetpaʼ yerromuepaʼ parro. ");
INSERT INTO ameNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesúsñapaʼ atet̃ otererr: —Pedro, oʼch notap̃, eʼñech añe tsaprocma amach eñenaʼ atollop, p̃añapaʼ oʼch maʼpoch p̃aʼnasotenna. Ñeñt̃paʼ atet̃chaʼ p̃oten, napaʼ añoʼ pentarno. ");
INSERT INTO ameNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Elloña Jesúspaʼ yerpaterrana pueyochreshaʼ; ñeñt̃paʼ atet̃ oterraneterr: —Ñehua, ahuaña allempo nemñas atet̃ notapas amach es sanmatsto amaʼt coñeʼt̃a, amaʼt sebolsa, amaʼt sec̃llayor amaʼt ñam̃a sesapat. Ñehua allempopaʼ ¿eñalleʼtña ñeñt̃ sepalltena? Ñetñapaʼ atet̃ ochet: —Allempopaʼ amacaʼye c̈ho es yepallto amaʼt eʼñe mamesha. ");
INSERT INTO ameNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesúsñapaʼ alla oterraneterr: —T̃arraña t̃eʼpaʼ oʼch notas poʼpoñ, ñerraʼm eseshast̃eʼ ñeñt̃es echeneʼ sec̃llayor t̃eʼpaʼ oʼchcaʼye sanem all sechopeñeʼchyen amaʼt ñam̃a sebolsa. Ñam̃a ñerraʼm ama secheno socchellpaʼ pocteʼcaʼye oʼch sepom seshtam alloch seyora socchell. ");
INSERT INTO ameNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","T̃arroʼmar t̃eʼpaʼ oʼch alla noterrserr: T̃eʼpaʼ oʼchcaʼye eʼñe etsoterra ñeñt̃ atet̃ anuaret̃ Yompor poʼñoñ nocop. Allcaʼyeña oten napaʼ errot̃uanenchaʼ perrnet atet̃ ñerraʼmrrat̃eʼ napaʼ ñeñt̃en amtsañen. T̃eʼpaʼ ñeñt̃caʼye oʼ etsotmocha ñeñt̃ eʼñe atet̃ anaret̃ nocop. ");
INSERT INTO ameNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Allempoña ñetñapaʼ atet̃ otereterr: —Partseshachaʼ yapaʼ yechencaʼyeña epmeta cochell. Jesúsñapaʼ atet̃ otanet: —Ñeñt̃achcaʼye. ");
INSERT INTO ameNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Allempoñapaʼ oʼ rrallmeʼchuanenet ñeñt̃e pascuapo, Jesúsñapaʼ c̈haʼnerrpaʼ ahuenerr Olivop̃no; ñapaʼ att̃ecma pena c̈hocmach sen all. Pueyochreshaʼñapaʼ cot̃aʼhuaneñet. ");
INSERT INTO ameNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Allempoña c̈henet allpaʼ Jesúsñapaʼ atet̃ otuenan pueyochreshaʼ: —T̃eʼpaʼ arrchaʼ semaʼyochuena att̃och eʼñe saʼhuantaʼ ñeñt̃chaʼ sehuapoya t̃eʼ ñeñt̃chaʼ atarr huomenc setpateʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Allempoña ñapaʼ ahuoʼ mameʼ aʼyent̃eyeʼ. Ñañapaʼ all concorpaʼhuena oʼ maʼyochuena. ");
INSERT INTO ameNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Puemaʼyocheñot̃ atet̃ otuen: —Apa, ñerraʼm p̃ach pocteʼ enteʼ arepaʼchña pemnatatsche oʼch c̈hapona ñeñt̃ atarr amueroc̈htatañ nenten. T̃arraña ñerraʼm p̃ach muenats añchaʼña atet̃ pep̃aton ñeñt̃ pemnen p̃a, amachña añeyaye ñeñt̃ nemnen na. ");
INSERT INTO ameNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Allempoñapaʼ huapoña mellañot̃eñ Yompor pueʼntañot̃ ñeñt̃ña ahuamencat̃ p̃oseʼ att̃och ahuantan puellquëña. ");
INSERT INTO ameNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ñapaʼ atarr nanac puellquëñeshaʼ maʼyochena; puemaʼyocheñot̃paʼ atarr nanac ñorraʼten. Poʼñorrñapaʼ c̈ha huatena atet̃ ñerraʼmrrat̃eʼ errasats tsopsaʼtets patso. ");
INSERT INTO ameNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Allempoña maʼyochuapaʼ tanterra, ahuerr pueyochreshesho. All entuerranet ñetñapaʼ c̈ha atarr manrrenet amaʼt eʼñe puellquëñeshet. ");
INSERT INTO ameNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ñañapaʼ atet̃ otuerranet: —Sapaʼ esoʼmareʼtña c̈ha atarr semanrraʼten. T̃eʼpaʼ oʼch setanterrapaʼ c̈hoña semaʼyochrraʼta att̃och saʼhuantaʼ ñeñt̃chaʼ sehuapoya topateñets atarr huomenc. ");
INSERT INTO ameNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","All atet̃ otyenan pueyochreshaʼpaʼ allempoñapaʼ huac̈haʼtoña shonteʼ acheñeneshaʼ. Ñeñt̃ huac̈haʼtatahuet ñeñt̃paʼ ñeñt̃ sochetsa Judas ñeñt̃ara ñeñt̃ pueyochreshaʼ peneñ ñeñt̃ c̈harrasheña ñeñt̃ aʼpchenahuet epsheña. Ñañapaʼ c̈ha ponmosaya Jesús, puetsoʼtstsapaʼteñot̃ huom̃chaʼtos. ");
INSERT INTO ameNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesúsñapaʼ atet̃ otap̃: —Eʼñeʼtchaʼ petsoʼtstsapaʼteñot̃en pepomuerren na Ñeñt̃en Acheñetosets. ");
INSERT INTO ameNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Añña ñeñt̃ yemtenaya Jesús allempo atet̃ eñchet oʼch rromoset Jesús, ñetñapaʼ atet̃ ochet: —Ayochreshat̃e ¿amat̃eʼ pocto oʼch yemoñsap̃a yocchello? ");
INSERT INTO ameNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Puesheñarrña pueyochreshaʼ allent̃a chetan poʼcchell ahuoʼch c̈hontoʼtapan corneshaʼ paʼcheñer puetepaʼtchaʼ tsorroñ poʼcohuenrot̃. Ñeñt̃paʼ año paʼcheñer ñeñt̃ paʼm̃chaʼtaret̃er pen allohuen judioneshaʼ poʼcornaneshar. ");
INSERT INTO ameNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesúsña allempo entan pueyochreshaʼ atet̃ p̃apaʼ ñañapaʼ otanet: —Ñeñt̃epaʼt̃a, amach atet̃ sep̃atsto. Allempoña ñeñt̃ tsorrquetaʼtetpaʼ alla aʼp̃llerrñañ puet oʼ alla orrater oʼ eʼñe correrra. ");
INSERT INTO ameNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ñeñt̃ huac̈haʼtoya ñeñt̃chaʼ rremoseʼ Jesúspaʼ ñeñt̃paʼ añcaʼye ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ p̃aʼyen allohuen judioneshaʼ poʼcornaneshar, ñam̃a ñeñt̃ judioneshaʼ poʼguardianeshar ñeñt̃ cohuam̃peneʼ Parets paʼpaquëll ñam̃a ñeñt̃ pomporneshaʼ pen allohuen judioneshaʼ. Allempo huac̈haʼtoñetpaʼ Jesúsñapaʼ atet̃ otapanet: —Esoʼmareʼt sehuac̈haʼtennanaña eʼñe occhellet̃areroches ñam̃a etsachperet̃areroches att̃och serrmaʼn. Napaʼ ¿eʼñeʼt atet̃ sentenen ñerraʼmrrat̃eʼ eñet̃en? ");
INSERT INTO ameNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Napaʼ allponmatuanen alloʼtsenen Parets paʼpacllo eʼñe parro sesho, esoʼmareʼtña amaña allempocmayeʼña serrmaʼneʼt̃e. T̃arroʼmar t̃eʼ oʼ c̈hap allempo ñeñt̃ poctetsa socop ñeñt̃oʼmar t̃eʼ oʼ c̈hap allempoch oneñet̃paʼ oʼch orrtatennas poʼhuamenc, ñeñt̃paʼ eʼñe atet̃ ñerraʼm checmeteʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Allempoñapaʼ rremoset Jesúspaʼ arr aneret am̃chaʼtaret̃ paʼpacllo ñeñt̃ paʼm̃chaʼtaret̃er pen allohuen judioneshaʼ poʼcornaneshar. Pedroñapaʼ ñapaʼc̈hoʼña cot̃eʼ t̃arraña ñapaʼ chentaʼ en aʼyot̃. ");
INSERT INTO ameNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Petot̃ña rroc̈h pampopaʼ all aʼt̃orenet tsoʼ all anorrc̈haʼtyen acheñeneshaʼ ñeñt̃ shotetsa. Pedroñapaʼ all anorros ñam̃a all shotosa. ");
INSERT INTO ameNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Allempoña huapa coyaneshaʼ ñeñt̃ am̃chaʼtaret̃ pueñañra. Entosan Pedro all shotenapaʼ alla cohuos, atet̃ otos: —Añpaʼc̈hoʼña encanesharpaʼ ñeñt̃rramtso yemtayeʼt̃ña Jesús. ");
INSERT INTO ameNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","T̃arraña Pedroña c̈ha aʼnasochapaʼ atet̃ otanña coyaneshaʼ: —Napaʼ amacaʼye nentare. ");
INSERT INTO ameNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Eʼñe oʼchtapaʼ huapa ñam̃a poʼpsheñeñ entuererrpaʼ ñapaʼc̈hoʼña atet̃ otuererr: —P̃apaʼc̈hoʼña parrocaʼye eʼñe peyemtena. Pedroñapaʼ atet̃ otan ñeñt̃ yacmar: —Napaʼ amarramcheʼ erra neyemtenoña na epan ña. ");
INSERT INTO ameNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Oʼ tama oʼchterrerrpaʼ oʼ alla huerrerr poʼpsheñeñ, ñapaʼc̈hoʼña atet̃ otuererr: —Poʼñoc̈hcaʼye añmapaʼ ñeñt̃caʼye eʼñe yemtenaya t̃arroʼmar ñapaʼc̈hoʼña galileoʼmarneshaʼcaʼye atet̃ ñerraʼm Jesús. ");
INSERT INTO ameNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedroñapaʼ alla oterranerr ñeñt̃ yacmar: —Amarramcheʼ neñoteñeña est̃eʼña atarr p̃otenen. Eʼñe allempo atet̃ eñorena Pedro, eʼñepaʼtchaʼ allempocma eñenña atollop. ");
INSERT INTO ameNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Allempoña Partseshaʼ Jesúspaʼ cohuaʼ allent̃eʼtsen Pedro. Pedroñapaʼ allent̃a yerpuerrana atet̃ otneñ Partseshaʼ: “Amach eñenaʼ atollop ñeñt̃e tsaprocma p̃añapaʼ oʼch maʼpoch p̃aʼnasotenna.” ");
INSERT INTO ameNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Allempoña Pedropaʼ ahuoʼ aʼyo all eʼñe puellquëñeshaʼ yahuosa huomenc. ");
INSERT INTO ameNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","All yottam̃p̃sateñet Jesús am̃chaʼtaret̃ paʼpacllo añña solltarneshaʼ ñeñt̃ cohuam̃p̃sachet ñetñapaʼ atarr achm̃areʼteñet Jesús all cohuam̃peñet. Atarr c̈hotaʼteñet. ");
INSERT INTO ameNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Huancaclleʼcheñet, pachm̃areʼteñot̃etpaʼ atet̃ oteñet: —Ñehua, t̃eʼña eñoratenperrepaʼ Parets allochñapaʼ att̃och p̃otey eseshaʼt̃eʼña pec̈hotaʼtyeneʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Elloña pachm̃areʼteñot̃etpaʼ paʼnamen esocmañen otyeñet, sochatseʼtyeñet. ");
INSERT INTO ameNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tsapat̃ña allempo puetarenpaʼ apc̈haʼmuena allohuen ñeñt̃ pomporneshaʼ pen judioneshaʼ epuet ñam̃a ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar epuet ñam̃a ñeñt̃ atarr etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃. All apc̈haʼmuena allohuen judioneshaʼ paʼm̃chaʼtaret̃erneshaʼ ñeñt̃ aʼpoctatyeneʼ ñoñets, all anmaʼmueñetña Jesús. Allñapaʼ aʼp̃t̃oʼtareʼtapet, atet̃ otapet: ");
INSERT INTO ameNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Yapaʼ t̃eʼpaʼ yemneñ oʼch p̃otosey ñerraʼm poʼñoc̈ht̃eʼ p̃a ñeñt̃ep̃ Cristotets. Jesúsñapaʼ atet̃ otosanet: —Amaʼt notatstas na poʼñoc̈h ñeñt̃en Cristotets sañapaʼ amachcaʼye pocteyeʼ sentno att̃och sameʼñaʼna. ");
INSERT INTO ameNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ñam̃a napaʼc̈hoʼña amaʼt oʼch es naʼp̃t̃oʼtas sam̃a sañapaʼ amachcaʼye sanapnoña nam̃a. T̃arroʼmar sapaʼ amachcaʼye semno saʼrroyerren. ");
INSERT INTO ameNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","T̃arraña t̃eʼpaʼ amaʼtchaʼ atet̃ sep̃aʼnoñ t̃eʼñapaʼ oʼ eʼñe c̈hap allempoch oʼch alla nanorruerr Nompor poʼcohuenrot̃ ñeñt̃ atarr ahuamencat̃tetsa, amaʼt na Ñeñt̃en Acheñetosets. ");
INSERT INTO ameNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Allempoña allohuenet atet̃ oteñet: —Ñeñt̃epñapaʼ ¿p̃aʼtrraña Puechemer penña Yompor? Jesúsñapaʼ atet̃ oterraneterr: —Eʼñecaʼye poʼñoc̈h ñeñt̃ atet̃ sotenen sa. ");
INSERT INTO ameNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Allempoña ñetpaʼ atet̃ otannaʼtyeset: —T̃eʼ yapaʼ ama yemneñe poʼpotantañ ñeñt̃chaʼ aʼmet̃areʼtam̃p̃soseʼ t̃arroʼmar t̃eʼ yapaʼ allohueney eʼñe yeʼmhuen ñeñt̃ atet̃ otena añ acheñer, ñapaʼ Yomporoʼ Puechemer. Ñapaʼ c̈hacaʼye atarr achm̃areʼtenan Yompor. ");
INSERT INTO ameNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Allempoña allohuenet tantrraʼtuet, eʼñe parrocma anmet Jesús alloʼtsen am̃chaʼtaret̃ Pilato (ñeñt̃ nen gobierno Romot̃ ñeñt̃ am̃chaʼtaret̃tetsa alloʼmarneshacop). ");
INSERT INTO ameNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Allñapaʼ atarr otteñeʼchoset, tomaʼtam̃pesyesoset, ñeñt̃paʼ atet̃ otyesoset: —Ya añ acheñer c̈hocma yenteñ yec̈hatyenan yamoʼtseshac̈hno judioneshaʼ ñeñt̃ amaʼt mameshapaʼ ama cohuenayaye, ñam̃a atet̃ oteney añoʼch yetsaʼtatsto impuesto ñeñt̃ romoʼmarneshacop ñeñt̃ nen am̃chaʼtaret̃ Romot̃. Amaʼt ñapaʼ atet̃ otena ñapaʼ ñoʼ Cristotets ñoʼ atarr am̃chaʼtaret̃tetsa arr. ");
INSERT INTO ameNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Allempoña am̃chaʼtaret̃ Pilatopaʼ aʼp̃t̃oʼtapan Jesús: —P̃apaʼ ¿p̃aʼtña judioneshaʼ paʼm̃chaʼtaret̃erep̃? Jesúsñapaʼ atet̃ och: —Atet̃caʼye atet̃ p̃otenen. ");
INSERT INTO ameNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Añña ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar ñam̃a acheñeneshac̈hno, ñetñapaʼ atet̃ otanet Pilato: —Ñehua, napaʼ amacaʼyeña nentoñeña ñeñt̃ att̃o ama pocteyeʼ es penoña añ acheñer. ");
INSERT INTO ameNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Judioneshaʼña paʼm̃chaʼtaret̃erneshaʼpaʼ alla otereterr Pilato: —T̃arraña yañapaʼ c̈hocmaña yenteñ ñeñt̃ atet̃ yec̈hatyenan acheñeneshaʼ att̃och at̃pareʼtatenanet gobierno. Eʼñe Galileot̃eñ atet̃ pena, amaʼt t̃eʼpaʼ oʼ c̈hap ñam̃a arr Judeo eʼñe att̃ecma oʼ yec̈hatuerrerr ñeñt̃ ama cohuenayeʼ yenteno ya. ");
INSERT INTO ameNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Att̃oʼ eʼm̃ñotenan judioneshaʼ atet̃ otyenet eʼñe Galileot̃eñ yec̈haten, allempoña Pilatopaʼ atet̃ aʼp̃t̃oʼtanet: —Jesúspaʼ ñapaʼ ¿galileoʼmarneshaʼtña? ");
INSERT INTO ameNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Allempoña eñotachet ñapaʼ poʼñoc̈hcaʼye galileoʼmarneshaʼ allempoña Pilatopaʼ atet̃ cot̃apeʼch ñeñt̃paʼ Herodesocpacaʼye t̃arroʼmar ñapaʼ ñeñt̃ am̃chaʼtaret̃tetsa galileoʼmarneshacop. Ñeñt̃oʼmarña ñapaʼ mueñan Jesús Herodesesho t̃arroʼmar Herodespaʼ allempo c̈hap Jerusaléño all emoʼten. ");
INSERT INTO ameNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodesñapaʼ eʼñe pocsheñeshaʼ agapaneñ Jesús t̃arroʼmar ahuat̃ot̃eñ atarr mueneñ oʼch eñch t̃arroʼmar ñapaʼ atet̃ eʼmareʼtenan Jesús ñeñt̃ atet̃ p̃aʼyena. Ñapaʼ añecopña atarr mueneñ oʼch orrtatoñ ñam̃a ñeñt̃ atet̃ p̃aʼyena orrtatyeseʼ ñeñt̃ ama puentareto. ");
INSERT INTO ameNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Atarr es aʼp̃t̃oʼtareʼtapaneñña Jesús t̃arraña ñapaʼ ama anapanoña Herodes amaʼt eʼñe parrocha. ");
INSERT INTO ameNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","All t̃omc̈haʼtoset ñam̃a allohuen am̃chaʼtaret̃neshaʼ ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar ñam̃a alloʼtsen ñeñt̃ atarr etsotayenayeñ ñoñets, ñetña allpaʼ otteñeʼchuereterr Jesús all Herodesesho, paʼnamen otyesuerreterr. ");
INSERT INTO ameNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Allempo Herodes ñam̃a allohuen poʼsolltarneshar ñetpaʼc̈hoʼña puerrap̃soñet ñamet. Achm̃areʼchet all cheʼtatseteñet. Puecheʼtatseteñot̃et chorrachet am̃chaʼtaret̃ paʼshtam ñeñt̃ atarr cohuen. Allempoña Herodespaʼ oʼ alla mueñoʼter Pilatesho. ");
INSERT INTO ameNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ñeñt̃oʼmarña Herodes epuet Pilatopaʼ eʼñe allempocma amoʼtstannerret t̃arroʼmar ahuañmoʼchapaʼ c̈ha eʼmoñeʼtannenet. ");
INSERT INTO ameNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Allempoña Pilatopaʼ alla apc̈haterran ora allohuen judioneshaʼ paʼm̃chaʼtaret̃erneshaʼ ñeñt̃ poʼcornaneshar paʼm̃chaʼtaret̃erneshaʼ ñam̃a poʼpotantañ judioneshaʼ paʼm̃chaʼtaret̃erneshaʼ amaʼt ñam̃a allohuen acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Pilatoñapaʼ alla otapuerraneterr: —Añ acheñer ñeñt̃ sehuapatennan ñeñt̃ soten sa ahuoʼ yec̈hatyesan acheñeneshaʼ ñeñt̃ ama cohuenayeʼ senteno sa, t̃eʼña napaʼ oʼ naʼp̃t̃oʼtareʼtue amaʼt allempo alloʼtsaʼyenes t̃arraña nañapaʼ amaʼt parrochapaʼ ama nentoñeña ñeñt̃ atet̃ sotyen att̃oʼ pena ñeñt̃ ama cohuenayaye. ");
INSERT INTO ameNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Amaʼt ñam̃a Herodespaʼ ama entoñeña ñeñt̃ ama pocteyeʼ yec̈hcateno, ñeñt̃oʼmarña oʼ alla mueñer nesho. Poʼñoc̈hpaʼ amacaʼye eñalleña ñeñt̃ atet̃ pen ñeñt̃ ama cohuenayeʼ yenteno allohueney att̃ot̃chaʼ yemtsatach. ");
INSERT INTO ameNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ñeñt̃oʼmarña na t̃eʼpaʼ att̃achcaʼye necoñchach mameʼpaʼ oʼch alla naʼrroyer. ");
INSERT INTO ameNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","19","T̃arraña allohuen judioneshaʼ puerrannarteñot̃et atet̃ ochet Pilato: —Pemtsatachñacaʼye, añchaʼña p̃aʼrroyerrnay Barrabás. Ñehua, ñeñt̃ Barrabás ahuañmoʼchot̃eñ yottam̃peñet t̃arroʼmar ña yec̈hateneʼ acheñeneshaʼ at̃pareʼchetepaʼ am̃chaʼtaret̃ ñeñt̃ nen gobiernoʼ Romot̃. Eʼñe pat̃pareʼteñot̃ oʼ muetsan acheñ. Ñehua, ñetpaʼ atet̃ yec̈henet. Pat̃eʼtets pascuapo ñeñt̃ am̃chaʼtaret̃ ñeñt̃ nen gobiernoʼ Romot̃paʼ oʼch aʼrroyerrñañet judioneshaʼ puesheñarr pamoʼts ñeñt̃ ayottam̃p̃saret̃tetsa ñerraʼm erraʼtsen muenenet ñet, ñeñt̃paʼ añecop aʼrroyenanet att̃och coshatenan judioneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ñeñt̃oʼmarña Pilatopaʼ atarr mueneñeñ oʼch aʼrroyerranet Jesús, ñeñt̃oʼmarña alla aʼp̃t̃oʼterranerr allohuen acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","T̃arraña ñetñapaʼ amaʼt mameshapaʼ amaña pocteyeʼ enteñeto. Elloña ñeñt̃apaʼ rrannartet allohuenet, atet̃ otereteʼt̃: —¡Pecorsoʼtam̃p̃sach! ¡Pecorsoʼtam̃p̃sachñacaʼye! ");
INSERT INTO ameNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pomaʼpocheño Pilatopaʼ alla oterraneterr: —¿Esoʼmareʼtña semneñña oʼch necorsoʼtam̃p̃sach? Napaʼ amacaʼye nenteññañeña ñeñt̃ att̃o ama pocteyeʼ es peno att̃och yemtsatach. Ñeñt̃oʼmarña napaʼ att̃achcaʼye, necoñchach mameʼ allempopaʼ oʼch alla naʼrroyer. ");
INSERT INTO ameNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","T̃arraña ñetpaʼ ama cac̈hpueñeto otareʼtet. Elloña ñetpaʼ eʼñe puerrannarteñot̃et atarr enamueñet att̃och corsoʼtam̃p̃sach. ");
INSERT INTO ameNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ñeñt̃oʼmarña Pilatopaʼ ameʼñachet. Att̃oña ñapaʼ atet̃ eñora: —T̃eʼpaʼ oʼch atet̃ nep̃onas ñeñt̃ atet̃ atarr semnen sa. ");
INSERT INTO ameNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ñeñt̃oʼmar allempo aʼrroyanet Barrabás ñeñt̃ enamueñet amaʼt ñeñt̃ pat̃parñot̃ yottam̃peñet ñam̃a puemtseñot̃ acheñ. T̃arraña Jesúsñapaʼ oʼ apanet att̃och muetset ñeñt̃ atarr muenenet ñet. ");
INSERT INTO ameNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Allempo anmet Jesús aʼyo allchaʼ corsoʼtam̃p̃soset. Allña oñenetpaʼ allñapaʼ poctet puesheñarr yacma ñeñt̃ cireneoʼmarneshaʼ ñeñt̃paʼ añ paʼsoʼcheñ Simón ñeñt̃ errteʼ huerrtsa aʼyot̃. Ñeñt̃ña rremapetpaʼ oʼ chechatnomet Jesús poʼcorsoch ñeñt̃ña anmueʼña chentaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Allñapaʼ cot̃aʼhuanem̃ shonteʼ acheñeneshaʼ, shonteʼ coyaneshac̈hno ñeñt̃ atarr yaʼnaʼtneneʼ Jesús chentaʼ, atarr gogaretyesnenet puellquëñot̃et. ");
INSERT INTO ameNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","T̃arraña Jesúspaʼ allent̃a cohuaʼnmanet, atet̃ otnomanet: —Noc̈hanesha ñeñt̃es jerusaléñoʼmarneshas, amach atarr seyaʼnaʼtatsteno na. Eʼñe socpa atarr seyahuena sacñet̃aret̃olleshohuen. ");
INSERT INTO ameNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","T̃arroʼmar esempopaʼ c̈hocmach huaponasa ñeñt̃chaʼ atarr sellcaterreʼ. Allempoña coyaneshaʼ ñeñt̃ ama achoyoreʼtñepaʼ ñocpuetñapaʼ eʼñech cohuen entaret̃terret allempo t̃arroʼmar ñetpaʼ ama eñalleto puechoyoreshet ñeñt̃chaʼ atarr mueroc̈hterrtsa. Ñeñt̃oʼmarña allempopaʼ otyerrchaʼ allohuen acheñeneshaʼ: “Oʼ atarr cosheñtsoʼtsenterra muec̈hop̃naneshaʼ, amaʼt allohuen ñeñt̃ ama achoyoreʼtñe, amaʼt allohuen ñeñt̃ ama es momaʼyeneto.” ");
INSERT INTO ameNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","T̃arroʼmar allempo puemueroc̈hteñot̃et eʼñe puellquëñot̃etpaʼ atarrchaʼ yaʼñameterret. Pueyaʼñameteñot̃etpaʼ eʼñech pocteʼ entyerret ñegatam̃perretepaʼtoʼ att̃och pampuerranet eʼñe poctacma. Allochñapaʼ oʼhuañchaʼ alloʼna atarr nanac mueroc̈htenet. ");
INSERT INTO ameNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","T̃arroʼmar t̃eʼpaʼ att̃o mueroc̈htatennet na amaʼt napaʼ eʼñe cohuen es norrtatyeneñ, eʼñe att̃eneñ ñerraʼm tsach eʼñe cohuen emmoʼrateʼ. Ñeñt̃oʼmar t̃eʼ napaʼ neñoteñ elloña atarrchaʼ amueroc̈htataret̃terra ñeñt̃ ama cohuenayeʼ es orrtateno; ñeñt̃ñapaʼ eʼñe atet̃ pena ñerraʼm tsach rromuech. Arrpaʼ allohua atet̃ otnomanet Jesús allempo aneñet allchaʼ corsoʼtam̃p̃soset. ");
INSERT INTO ameNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","All aneñet ñam̃a epsheña ñeñt̃ amtsañ ñeñt̃chaʼ epuet corsoʼtam̃p̃soset. ");
INSERT INTO ameNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Allempoña c̈hapachet all oteñet Poñetallep̃no, allña corsoʼtam̃p̃sosetña epuet ñam̃a epsheña ñeñt̃ amtsañ, puesheñarr nosñañet poʼcohuenrot̃, poʼpsheñeññapaʼ nosñañet pueʼchcot̃erot̃. ");
INSERT INTO ameNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Eʼñe allempo corsoʼtam̃p̃sosetpaʼ Jesúsñapaʼ atet̃ maʼyocham̃p̃sosana ñeñt̃ eʼmoñeʼteneʼ, ñeñt̃paʼ atet̃ ot: —Nomporchaʼ t̃eʼpaʼ pep̃retnanetepaʼch t̃arroʼmar ñetpaʼ poʼñoc̈hpaʼ ama eñoteneto ñeñt̃ atet yec̈hcatenet, ñeñt̃ ama pocteyaye. Allempoña solltarneshaʼpaʼ yellsheñeʼchatoñet paʼshtam poʼsuertot̃ att̃och orrta puesheñaʼtets ñeñt̃chaʼ yorayeseʼ puemaʼtets. ");
INSERT INTO ameNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Acheñeneshaʼñapaʼ att̃a cohuanrrorteñet all t̃omc̈henet aʼyenet̃. Paʼm̃chaʼtaret̃erneshet ñetñapaʼ atarr es otnareʼteñet, atet̃ otatseʼtyeñet. —T̃eʼña p̃apaʼ oʼ p̃aʼqueshp̃atyes poʼpotantañ, t̃eʼñapaʼ p̃aʼqueshp̃aterra eʼñe p̃añeña ñerraʼm poʼñoc̈ht̃eʼ ñeñt̃ep̃ acren Yompor ñeñt̃chaʼ Cristotosets. ");
INSERT INTO ameNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Solltarneshaʼpaʼc̈hoʼña atarr achm̃areʼteñet, cheʼtatseteñet. Puecheʼtatseteñot̃etpaʼ ponem̃yetpaʼ aposet vinos ñeñt̃ atarr chellaʼseʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Pachm̃areʼteñot̃etpaʼ atet̃ otyeñet: —Ñerraʼm p̃a poʼñoc̈ht̃eʼ ñeñt̃ep̃ paʼm̃chaʼtaret̃er pen judioneshaʼ, t̃eʼñapaʼ p̃aʼqueshp̃aterra p̃añeña. ");
INSERT INTO ameNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ñehua, poñot̃ all corsocho all noñet tsachtall aquellcaret̃ ñeñt̃ña quellecpaʼ atet̃ oten: “Añpaʼ ñeñt̃caʼye judioneshaʼ Paʼm̃chaʼtaret̃er.” Ñeñt̃ña quellecpaʼ ñeñt̃ anaret̃ maʼpoʼmar ñoñets—griegac̈h, latinac̈h ñam̃a hebreyac̈h, eʼñe att̃ecma oten. ");
INSERT INTO ameNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Puesheñarrña amtsañ ñeñt̃ parro corsoʼtam̃peñet, ñapaʼc̈hoʼña achm̃areʼch. Potnareʼteñot̃paʼ atet̃ oteñ: —Ñerraʼm poʼñoc̈ht̃eʼ Cristop̃paʼ p̃aʼqueshp̃aterra pañeña, yapaʼc̈hoʼña oʼch p̃aʼqueshp̃aterrey. ");
INSERT INTO ameNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Poʼpsheñeñ amtsañpaʼ cheʼptareʼch. Puecheʼptareʼteñot̃paʼ atet̃ och: P̃apaʼ esoʼmareʼtña ama pem̃chaʼnaʼteñeña Yompor, amaʼt parro amueroc̈htataret̃ey. ");
INSERT INTO ameNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","T̃arraña yocoppaʼ eʼñecaʼye pocteʼ yemueroc̈htena t̃arroʼmar ñeñt̃paʼ añ tsaʼtatenyet ñeñt̃ allpon yeyec̈hcatyen ñeñt̃ ama cohuenayaye amaʼt eʼñe mamesha. T̃arraña añ acheñer ñeñt̃ parro mueroc̈htatenyet ñapaʼ ama es yec̈hcateno amaʼt mamesha ñeñt̃ ama pocteyaye. ");
INSERT INTO ameNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Allempoña ñapaʼ atet̃ otan Jesús: —Napaʼ peyerpaʼhuerrnoʼt̃ach allchaʼ p̃aʼm̃chaʼtaret̃etuerra. ");
INSERT INTO ameNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesúsñapaʼ atet̃ och: —Napaʼ poʼñoc̈hcaʼye notap̃, eʼñe t̃ayecma parroʼtseneychaʼ cosheñtso. ");
INSERT INTO ameNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Allempoña c̈hap pocto atsneʼpaʼ oʼhuañ atsnom, oʼ eʼñe checmetua errap̃aren añe patsro. Oʼña ellerrotnenmochapaʼ oʼ alla puetarerr. Allempoña ñeñt̃ besom allo yottam̃peññañet Parets paʼpaquëll poʼponro ahuepaʼt rrarraʼnom eʼñe poctacma, oʼ eʼñe ellopaʼtetsta. ");
INSERT INTO ameNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Allempoña Jesúspaʼ rrana. Puerranarot̃paʼ atet̃ ot: —Nomporchaʼ t̃eʼpaʼ oʼ nepomuerra eʼñe p̃ocop eʼñe necamquëñohuen. Eʼñe ñeñt̃a otuapaʼ oʼ rroma. ");
INSERT INTO ameNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Solltar poʼcap̃táner ñeñt̃ romoʼmarneshaʼ ñeñt̃ corsoʼtam̃p̃seʼ, allempo atet̃ ent atet̃ oʼ p̃a, ñañapaʼ allent̃a ayeʼchoc̈htatan Yomporpaʼ ñapaʼ atet̃ ot: —Añ yacmarpaʼ poʼñoc̈huacaʼye eʼñe att̃ot̃a oʼ yemtsatater, amacaʼyeña eñalleña att̃och yemtsatatereñ. ");
INSERT INTO ameNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ñam̃a allohuen acheñeneshaʼ ñeñt̃ alloʼtsaʼyen ñeñt̃ enteʼ ñeñt̃ atet̃ oʼ p̃ach oʼ yoroc̈htach, ñetñapaʼ puellquëñeshaʼ naʼyesnerret pot puesomapo ahuanerret. ");
INSERT INTO ameNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Allohuen ñeñt̃ atarr yemtayeʼt̃ Jesús ahuañot̃eñ ñam̃a allohuen coyaneshac̈hno ñeñt̃ cot̃aʼhuanmueʼ Galileot̃ ahuañot̃eñ, ñetñapaʼ alla t̃omc̈haʼtyenet aʼyenet̃ allot̃ att̃a cohuanrrorteñet ñamet. ");
INSERT INTO ameNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Eñall puesheñarr yacma ñeñt̃ara judioneshaʼ ñeñt̃ eʼñe cohuen acheñ eʼñe pocteʼ es p̃aʼyen, ñeñt̃paʼ añ paʼsoʼcheñ José ñeñt̃ arimateoʼmarneshaʼ. Ñapaʼc̈hoʼña puesheñarr ñeñt̃ paʼm̃chaʼtaret̃er pen allohuen judioneshaʼ ñeñt̃ parrocma c̈hocmach apc̈henet epuet poʼpotantañ am̃chaʼtaret̃neshaʼ att̃och aʼpoctatenet ñeñt̃ llequëna allohuen judioneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ñehua, ña ahuaña allempo apc̈henet parro poʼpotantañ am̃chaʼtaret̃neshaʼ att̃o oʼpateñet Jesús oʼch muetsatachet, ñañapaʼ amaʼt mameshapaʼ ama pocteyeʼ eñche. T̃arroʼmar ñapaʼ ñeñt̃ atarr cohueneʼ Yompor esempohuañenchaʼ oʼch atarr ayochreshat̃terra. ");
INSERT INTO ameNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ñeñt̃ña Josépaʼ oʼ ahuoʼ Pilatesho oʼch oteñaʼ pocteʼch eñch ñach aʼsuatoseʼ Jesús ñeñt̃ rromuets corsocho. ");
INSERT INTO ameNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilatoñapaʼ eʼñe pocteʼ eñch, ñeñt̃oʼmarña ñapaʼ aʼsuater corsochot̃ allempoñapaʼ ep̃atseʼch shetamtso ñeñt̃ eʼñe cohuen, allempoñapaʼ anem̃ allchaʼ pampueñaʼ. All eñaret̃ mapuetpon all ama apamparet̃tenaʼ poʼpoñ arromñat̃, allcaʼyeña nenanaʼña Jesús. ");
INSERT INTO ameNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ñehua, allempo pampuet Jesúspaʼ ñeñt̃paʼ añe yet̃ro allempo c̈hocma aññoʼtena judioneshaʼ ñeñt̃ tsapat̃ecop allempoch ameserreterr. Ñehua, allempo pampaʼhuet Jesúspaʼ oʼ ellerren, ñeñt̃oʼmar judioneshaʼpaʼ oʼ mot̃tan ñeñt̃ tsapat̃ecop allempoch amesaʼmuenet eʼñe poctacma. ");
INSERT INTO ameNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ñeñt̃ña coyaneshac̈hno ñeñt̃ atarr yemtenaya Jesús ñeñt̃ cot̃aʼhuanmueʼ ahuañot̃eñ Galileot̃, ñetñapaʼ cot̃aʼhuanmet all pampueñetaʼ att̃och eñchet allchaʼ neret Jesús. ");
INSERT INTO ameNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Allempoña ñet onac̈herret allot̃paʼ oʼ c̈hac̈herret pocollo, ñetñapaʼ allohuenetpaʼ yorayesuerret ñeñt̃ atarr eñmosat̃ec̈hno alloch aʼyanaʼteretaʼ Jesús ora poʼchtsohuen att̃och eʼñe cohuen eñmosat̃tateretaʼ. Ñeñt̃paʼ eʼñecaʼye atet̃ yec̈henaña judioneshaʼ. Ñetpaʼ alla aññoʼtuaneñetña eñmosat̃ec̈hno t̃arroʼmar tsapat̃paʼ amach serreto puepampro t̃arroʼmar tsapat̃chaʼ c̈hapaʼmuen ñeñt̃e yet̃ro allempo c̈hocma amesen judioneshaʼ ñeñt̃ atet̃ anaret̃tenet ñocpuet. ");
INSERT INTO ameNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Allempo oʼ huañ yet̃ñats allempo amesenet, allempo mot̃taʼmuena yet̃ñats temenc coyaneshac̈hnoñapaʼ eʼñe ahuat̃ecma ahuanmaʼmuenet all pampueñet Jesús. Anmaʼmueññañet eñmosat̃ec̈hno ñeñt̃ oʼpatateñet alloch aʼyanaʼtoset. Allñapaʼ cot̃aʼnmaʼmuenanet poʼpotantañ coyaneshac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Oʼña c̈hac̈haʼtaʼmuenet allpaʼ mapueʼña ñeñt̃ allo mopam̃p̃set Jesús ñeñt̃ puepampuer p̃achet ama att̃erayeʼ entoseto ñeñt̃ atet̃ p̃am̃p̃set poʼpoñ ellerro. Entoset mapueʼ oʼ aʼrrot̃eʼtaret̃tena aʼyenet̃. ");
INSERT INTO ameNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Allempoña ñetpaʼ eshoʼtrraʼtoset mapuetpono ñeñt̃ puepampuer p̃achet amaña eseshaʼ entosayeña arromñat̃ all net. ");
INSERT INTO ameNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ñetñapaʼ c̈ha mueneʼ yoruoset ama eñoteñeto errot̃chaʼña p̃oset. Eʼñe allempo atet̃ cot̃apeʼchyenet ahuepaʼtchaʼ orrtapanet epsheña yacma alla t̃omc̈haʼtoset eʼñe alloʼtsaʼyenet, atarr cohuen popuetyenet paʼshtamuet. ");
INSERT INTO ameNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ñetña pueyorñot̃etpaʼ att̃a moʼcrraʼtyeset patso. Pom̃chañot̃et ama eshcayeʼ cohuaʼp̃seto allenet̃ t̃en. Ñeñt̃ña yacma epsheñapaʼ atet̃ otosanet: —Ñeñt̃ ama arromñat̃eshayaye, esoʼmareʼtña seʼnameʼteñña arr allecma nannena arromñat̃eneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","T̃eʼ ñapaʼ amacaʼye alloʼtsenarayaye arr, oʼcaʼye tanterra. Amaʼt seyerpueñoña ñeñt̃ atet̃ otaseʼt̃ amaʼt ahuañmoʼchot̃eñ allempo Galileoʼtsenmeñ. ");
INSERT INTO ameNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ñeñt̃paʼ atet̃caʼye otaseʼt̃ ñapaʼ ña Ñeñt̃ Acheñetosets c̈hocmach pomueret att̃och errot̃uanen per poʼpoñ acheñ ñeñt̃ atarr ochñat̃eneshaʼ att̃och corsoʼtam̃peret, t̃arraña pomaʼpamtañoñapaʼ c̈hocmach tanterra. ");
INSERT INTO ameNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Allempoña ñetpaʼc̈hoʼña allent̃a yerpueret atet̃ otaneteʼt̃ ahuañmoʼchot̃eñ Jesús. ");
INSERT INTO ameNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Allempoña coyaneshac̈hnopaʼ onac̈herret puepamprot̃, c̈hac̈herret pocollopaʼ serrpareʼtatueret Jesús puellsensarneshaʼ ñeñt̃ c̈harrasheña ñeñt̃ puesheñarram̃a oʼ puecherra ñam̃a poʼpotantañec̈hno ñeñt̃ pueyochreshaʼ pen. Coyaneshac̈hnoñapaʼ serrpareʼtueret allohuen ñeñt̃ atet̃ entaʼmuenet Jesús puepampro. ");
INSERT INTO ameNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ñeñt̃ serrpareʼtatenayaʼ Jesús puellsensarneshaʼ ñeñt̃paʼ añ María Magdalena ñam̃a Juana ñam̃a poʼpsheñeñ María ñeñt̃ Jacobo pachor ñam̃a poʼpoñec̈hno coyaneshac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","T̃arraña Jesús puellsensarneshaʼ allempo serrpareʼtatosanet coyaneshac̈hno ñeñt̃ atet̃ entuaʼmuenet, ñetñapaʼ amaʼt mameshapaʼ ama ameʼñyetoña coyaneshac̈hno, c̈ha otenapuetañ att̃at̃eʼ otatseʼtyen coyaneshac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","T̃arraña Pedroñapaʼ allent̃a ta eʼñe matenacma. Oʼña c̈hap ñam̃a puepampropaʼ moʼcosa, cohuos oʼpononet̃ all net. Ñapaʼc̈hoʼña ama entose, shetamtsa entos allo ep̃atseʼchet alla oʼshsheʼmaʼyena aʼyenet̃. Ñapaʼc̈hoʼña ahuerr pocollo ama eñoteñe ñatoʼ erroʼtsent̃eʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ñeñt̃e yet̃rocma epsheña pueyochreshaʼ ñetñapaʼ arr senet anetso ñeñt̃ paʼsoʼcheñ Emaús. Ñehua, ñeñt̃ paʼsoʼcheñ anets Emaúspaʼ Jerusaléñot̃eñpaʼ alloʼtsent̃eʼ c̈harraʼ puechena pat̃err kilómetro c̈hoychaʼ c̈hapats anets Emaúso. ");
INSERT INTO ameNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ñetñapaʼ eʼñe pueserrparñeshaʼ senet, añ serrpareʼtyesnenet ñeñt̃ allpon atet̃ oʼ p̃ohua. ");
INSERT INTO ameNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","All senet eʼñe pueserrpareʼteñeshetpaʼ anapannaʼtyesnenet Jesúsñapaʼ alla rremuerranetaʼ. Allempoñapaʼ chopeʼchnomuet eʼñe parro oʼ ahuanmuet anetsonet̃. ");
INSERT INTO ameNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","T̃arraña amaʼt entapetañña Jesúspaʼ ñetñapaʼ c̈ha ottenet ñerraʼmrrat̃eʼ ama amnataret̃teneto att̃och chemeʼtapet, ama eseshaʼ chemeʼtaye. ");
INSERT INTO ameNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesúsñapaʼ atet̃ otosan pueyochreshaʼ: —¿Esoʼtña seserrpareʼtyesnen? ¿Esoʼmareʼtña c̈ha atarr sellcaʼnena? ");
INSERT INTO ameNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Puesheñarrña ñeñt̃ sochetsa Cleofas, ñañapaʼ och: —¿Amaʼt peñoteñeña allohuen ñeñt̃ Jerusaléñoʼtsen ahuañot̃eñ oʼ eʼñe eʼmareʼtuet ñeñt̃ atet̃ oʼ metua all? P̃apaʼ ¿p̃apt̃at̃eʼña ñeñt̃ep̃ t̃aya c̈hapats all Jerusaléño ñeñt̃ep̃ ama eñotosaye ñeñt̃ atet̃ oʼ p̃ohuerret Jerusaléño? ");
INSERT INTO ameNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ñañapaʼ atet̃ otnomanet: —¿Esoʼtña ñeñt̃ atet̃ oʼ p̃ohuerretña all? Ñetñapaʼ alla otnereterr: —Añcaʼye yeserrpareʼtnen Jesús ñeñt̃ nazaretoʼmarneshaʼ ñeñt̃ aʼm̃teneʼ Yompor poʼñoñ ahuaña. Poʼhuamencot̃ orrtatennay poʼpartsoña ñeñt̃ amaʼt ahuat̃a yapaʼ ama yentare. Ñam̃a atet̃ yec̈hatyeseʼt̃ ñeñt̃paʼ atarr cohuen. Ñeñt̃paʼ eʼñe pocteʼ entapreteñ Yompor; acheñeneshaʼpaʼc̈hoʼña eʼñe pocteʼ enteñet. ");
INSERT INTO ameNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","T̃arraña yaʼm̃chaʼtaret̃erneshaʼ ñam̃a ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar, ñetñapaʼ oʼ pomueret Jesús att̃ot̃caʼyeña oʼ muetsatateret, ñeñt̃oʼmarña oʼ corsoʼtam̃peret. ");
INSERT INTO ameNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","T̃arraña yapaʼ ñeñt̃caʼyeña atarr yemneneñ ñatoʼ ñach yaʼrroyatatosayeñña allohueney ñeñt̃ey israelenaʼtarey (att̃o am̃chaʼnoc̈htanaʼtenya romoʼmarneshaʼ ya yaʼnetsro). T̃arraña t̃eʼñapaʼ c̈haña oʼ muetseret. T̃eʼpaʼ oʼcaʼye maʼpamtaʼmuen. ");
INSERT INTO ameNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Ñam̃a t̃eʼña coyaneshac̈hnoña ñeñt̃ parro yeyemtena, ñetñapaʼ ahuat̃ecma ahuanmaʼmuenet oʼch entaʼmueñet puepampro ñetñapaʼ añoʼ eseshayeʼ entosayeña puepampro all neretañ. Allempoña huac̈herret puepamprot̃ atet̃ serrpareʼtatuerryet, allñapaʼ añoʼ orrtahuet mellañot̃eñ ñeñt̃oʼña otahuet Jesúspaʼ oʼcaʼye tanterra oʼ alla bet̃terra. Ñeñt̃oʼmarña yapaʼ ñeñt̃ña atarr yeyoreʼteneʼ. ");
INSERT INTO ameNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Allempoña ñam̃a allponsheña ñeñt̃ parro yeyemtena, ñetpaʼc̈hoʼña allent̃a ahuanmuet ñamet puepampro. Eʼñe atet̃ otuerrey coyaneshac̈hno, ñetpaʼc̈hoʼña ama eseshayeʼ entosaye. ");
INSERT INTO ameNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesúsñapaʼ alla otnerraneterr: —Sapaʼ ama es sec̈henoyoña seyoc̈hro, atarr seʼcharrtaten seyoc̈her att̃och eʼñe sameʼñaʼhuaña ora ñeñt̃ atet̃ eñosyeseteʼt̃ Cristocop allohuen ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ ahuat̃ot̃eñ. ");
INSERT INTO ameNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Amaʼt señoteñeña ñeñt̃chaʼ Cristotatspaʼ atet̃caʼye anaret̃ña ñocop ñapaʼ atarrchaʼcaʼye amueroc̈htataret̃etuanena c̈hoch rromats. Elloñapaʼ oʼch alla c̈herr esempo allempochña eʼñe cohuen aʼcohuentataret̃terra. ");
INSERT INTO ameNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Allempoña Jesúspaʼ oʼ yerpatnerraneterr ora allohuen ñeñt̃ atet̃ anaret̃ añecop ñeñt̃chaʼ Cristotats. Eʼñe Moisés poʼñoñot̃eñ yerpatnomanet ñam̃a poʼpotantañec̈hno poʼñoñ ñeñt̃ eñosyestseʼt̃ Cristocop, ñeñt̃ara ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ ahuat̃. ");
INSERT INTO ameNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Allempoñapaʼ c̈hapmochet anetso all sechenet. Jesúsñapaʼ c̈ha otetnena ñerraʼm ñapaʼ am̃tocheʼch. ");
INSERT INTO ameNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ñetña alla puepateñot̃etpaʼ atet̃ ochet: —Allachcaʼye yec̈hap arr parro oʼcaʼye tsapuenmoch. Allempoña Jesúspaʼ beʼt̃osos allchaʼ c̈hapuet. ");
INSERT INTO ameNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Allempoña anorrc̈haʼtoset allchaʼ rrallmeʼchoset. Jesúsñapaʼ chetosan pan, parasyosoʼtam̃p̃sosan pan, shotaʼtospaʼ apaʼyesosanet. ");
INSERT INTO ameNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Allempo atet̃ p̃osa, pueyochreshaʼña epsheñapaʼ c̈ha eʼñe chemeʼtoset añpaʼ ñeñt̃epaʼtcaʼyeña Jesús. Eʼñe allorocma ñetpaʼ oʼ amnataret̃terret att̃och eʼñe chemeʼteret. Eʼñe chemeʼterretpaʼ allepaʼtchaʼ maʼnatam̃perranet. ");
INSERT INTO ameNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Allempoña ñetpaʼ atet̃ otannaʼtyeset: —Ñeñt̃oʼmarepaʼtcaʼyeña atarr nanac coshatosey ñorraʼ amaʼt c̈ha yellquëna yeyoc̈hro allempo serrpareʼtatnomuey t̃oño all yerpatnomya Yompor poʼñoñ ñeñt̃ atet̃ anaʼyesaret̃ eʼñe ñocop. ");
INSERT INTO ameNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ñetña eʼñe allorocma tantrraʼterretpaʼ oʼ alla ahuanerret Jerusaléño. Allñapaʼ oʼ c̈herret alloʼtsaʼyen poʼpotantañ puellsensarneshaʼ ñeñt̃ oʼ c̈harrasheñam̃a puechena puesheñarr. Alloʼtsen ñam̃a poʼpotantañec̈hno. ");
INSERT INTO ameNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Allña ñetpaʼ atet̃ otueret poʼpotantañ: —Poʼñoc̈hcaʼye oʼ tanterraña Yepartseshar. Ellonet̃ñapaʼ orrterrana ñam̃a Simón. ");
INSERT INTO ameNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Allempoña ñetpaʼ serrpareʼtueret ñeñt̃ atet̃ enteret t̃oño ñam̃a all shotaʼtosan pan, att̃oña ñetpaʼ allña eʼñe chemeʼtosetña Jesús. ");
INSERT INTO ameNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ñeñt̃a atarr otatsetyenetpaʼ Jesúsñapaʼ c̈hepaʼtchaʼ t̃omhuets eʼñe all chorren allohuen pueyochreshac̈hno. Alla huom̃chaʼtuenanet, puehuom̃chaʼtueñot̃anetpaʼ atet̃ otuenanet: —T̃eʼpaʼ c̈hosaña eʼñe cosherrtsa seyoc̈hro. ");
INSERT INTO ameNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","T̃arraña ñetñapaʼ c̈ha atarr yoreʼtuenanet, c̈ha atarr mechaʼtrraʼtet, c̈ha otenapuetañ choyesheʼmatst̃eʼ orrterranet. ");
INSERT INTO ameNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesúsñapaʼ atet̃ otuenanet: —Esoʼmareʼtña sañapaʼ c̈haña seyoren. Esoʼmareʼtña sañapaʼ c̈haña atarr seʼcharrtatenña seyoc̈her. ");
INSERT INTO ameNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","T̃eʼpaʼ oʼch secuapuennan not amaʼt ñam̃a netac att̃och eʼñe señotapuerren nacaʼye. Saʼp̃llapuennan nechets, secuaʼyesapuennan nechets allochñapaʼ oʼch eʼñe señotapuenen. Napaʼ ñeñt̃en echtsot̃en, choyesheʼmatspaʼ amacaʼyeña echtsot̃eyayeto ñam̃a amacaʼye anpat̃eyaye atet̃ oʼ sentapuenen napaʼ echtsot̃encaʼye ñam̃a anpat̃encaʼye. ");
INSERT INTO ameNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Allempoñapaʼ gatuenanet pot ñam̃a paʼtac. ");
INSERT INTO ameNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ñetñapaʼ att̃a cohuanrrortapueñet. Amaʼt atarr coshapueñetañpaʼ amaña eʼñeyeʼ ameʼñapueñeto ñatoʼ poʼñoc̈ht̃eʼ Jesús. Att̃a echarrtatenet pueyoc̈her t̃arraña Jesúsñapaʼ atet̃ oterraneterr: —¿Arrpaʼ amaʼt secheno amaʼt coñeʼt̃a rreñets? ");
INSERT INTO ameNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ñetñapaʼ aña apapueñet pashep̃arr cac achmaret̃ ñam̃a pets pocoyem̃ all nenan poʼmoñ. ");
INSERT INTO ameNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ñeñt̃a agaphuenpaʼ oʼ rrohueñ all chorrenet att̃oña ñetpaʼ entapueñet. ");
INSERT INTO ameNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Allempoñapaʼ atet̃ oterraneterr: —Ñeñt̃ atet̃ notaseʼt̃ allempo orameñ alloʼtseney eʼñe parro, ora allohuen ñeñt̃ atet̃ anaret̃ ahuat̃ot̃eñ Yompor poʼñoño nocop, ñeñt̃ña t̃eʼpaʼ oʼ eʼñe etsotuerra—eʼñe Moisésot̃eñ poʼñoñ ñeñt̃ atet̃ anaret̃ amaʼt ñam̃a ora allohuen ñeñt̃ quellcaʼyesoneʼt̃ ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ, amaʼt ñam̃a ñeñt̃ aquellcaret̃tatseʼt̃ libro Salmos, t̃eʼpaʼ ñeñt̃ña oʼ eʼñe etsotuerra ñeñt̃ atet̃ anaʼyesaret̃ nocop ahuat̃ot̃eñ. ");
INSERT INTO ameNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Allempoñapaʼ oʼ c̈hapatanet pueyoc̈hreto allohuen ñoñtsoc̈hno ñeñt̃ aquellcaʼyesaret̃ ñocop. ");
INSERT INTO ameNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jesúsñapaʼ alla oterraneterr: —Poʼñoc̈hpaʼ allohuen ñoñets ñeñt̃ aquellcaʼyesaret̃ atet̃caʼye oten ñeñt̃chaʼ Cristotosetspaʼ c̈hocmach poʼñoc̈h rromos, t̃arraña pomaʼpamtañoñapaʼ oʼch alla tanterra. ");
INSERT INTO ameNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Att̃ochña serrpareʼteret Cristo eʼñe Jerusaléñot̃eñ errap̃aren ora allemeñ allohuanen acheñenesheshoʼmar. Att̃ot̃chaʼña acheñeneshaʼpaʼ oʼch cot̃apeʼcherret ello eʼñe cohuen Yomporecop allochñapaʼ att̃ochña oʼch eʼñe ap̃retnaʼhuaret̃terret allohuenet poʼchñaret. ");
INSERT INTO ameNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Jesúsñapaʼ atet̃ oterraneterr: —T̃eʼña sapaʼ oʼch saʼpot̃errnan ora ñeñt̃ allpon atet̃ sentyesneʼt̃ amaʼt t̃emeʼttsen. ");
INSERT INTO ameNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ñam̃a sa t̃eʼpaʼ ellonet̃ oʼch atet̃ notnerres, poʼñoc̈hcaʼye napaʼ nemñohuerrnaschaʼ Yompor Puecamquëñ entot̃ ñeñt̃chaʼ eʼñe sechorraʼyesaya eʼñe puesheñaʼttsos ñeñt̃ atet̃ oten Yompor ñeñt̃chaʼ eʼñe apaʼyerres. T̃arraña sañapaʼ allasach anetso Jerusaléño, esempohuach chorratasa Parets Puecamquëñ ñeñt̃chaʼña ahuamencat̃ sep̃aʼyesoseʼ ñeñt̃chaʼ apuerres Yompor pueʼntañot̃. ");
INSERT INTO ameNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Allempoña Jesús err Jerusaléñot̃, ahuanerran pueyochreshac̈hno aʼyo anetso Betanio. Allñapaʼ echantosan potpaʼ bensareʼtam̃pesyesosanet. ");
INSERT INTO ameNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Eʼñe puebensareʼtam̃peñot̃anetpaʼ allñapaʼ aʼtenocheʼ pueʼntaño oʼ sohuanenanña pueyochreshac̈hno. ");
INSERT INTO ameNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ñetña allempo atet̃ entapueret Jesús ahuerr pueʼntañopaʼ paʼyeʼchoc̈htateñeshaʼ maʼyochnerretpaʼ ahuanerret Jerusaléño eʼñe pocsheñeshocmañenet. ");
INSERT INTO ameNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ñetña allempopaʼ ellapeneteʼt̃ Parets paʼpacllo all atarr ayeʼchoc̈htateññañet Yompor. Ñeñt̃paʼ att̃etepaʼch Nompore. Allohua.");
INSERT INTO ameNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ahuat̃ot̃eñ eʼñe ñanom paʼmot̃rot̃eñ Cristoñapaʼ eñalla epuet Pompor Parets. Ñañapaʼ ñeñt̃ara ñeñt̃chaʼ Poʼñoñ p̃aʼ Parets t̃arroʼmar ñach eñotaterreʼ acheñeneshaʼ atet̃ oteñ Yompor Parets. T̃arraña ñapaʼc̈hoʼña eʼñe att̃ecma partsoten atet̃ partsoten Pompor ñeñt̃ atarr nanac Parets. ");
INSERT INTO ameNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Allempo errteʼ ayec̈hcataret̃ta pats, ñañapaʼ eʼñe parro alloʼtsen epuet Pompor Parets. ");
INSERT INTO ameNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ñeñt̃oʼmarña allohuen esocmañen ñeñt̃ eñall, ñapaʼ ña eʼñe yec̈hcatueʼ ñeñt̃ atet̃ muenet epuet Pompor. Ñeñt̃ allpon eñallpaʼ ama eñalle ñeñt̃ ama yec̈hcato ña, amaʼt esot̃olla, ñocma pueyec̈hcatar. ");
INSERT INTO ameNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ñañapaʼ añepaʼt ñeñt̃ alloch eʼñe yocrrena. Ñeñt̃ña alloch eʼñe yocrrenapaʼ ñeñt̃chaʼ yeñotaterreʼ allohuen ñeñt̃ cohuen enten Pompor Parets. Ñeñt̃oʼmar ñapaʼ atet̃ pena ñerraʼmrrat̃eʼ puetareʼ t̃arroʼmar ñapaʼ ñach aʼpuetarsam̃perreʼ allohuen yoct̃ap̃ña. ");
INSERT INTO ameNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Amaʼt atet̃ pena sosyaʼtsañec̈hno añe patsro ñerraʼmrrat̃eʼ checmeteʼ, ñañapaʼ eʼñe aʼpuetaresuos. Checmeteʼñapaʼ amaʼt ahuat̃apaʼ amach errot̃enot̃ aʼchecmetam̃perrano ñeñt̃ puetarñatser ñeñt̃ Yompor poʼcohuenña. ");
INSERT INTO ameNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Amaʼt allempo ama orrtenaʼ Cristo ñeñt̃chaʼ puetarñatsotosets arr patsro, ñanempaʼ añ orrtatsa puesheñarr yacma ñeñt̃paʼ añ paʼsoʼcheñ Juan; ñapaʼ Yompor llesenseʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ñapaʼ añecop huapa ñach aʼpot̃oseʼ att̃och huapa Cristo arr patsro ñeñt̃chaʼ aʼpuetarsam̃perreʼ allohuen yoct̃ap̃ña. Att̃oña ña poʼñoñot̃paʼ ameʼñatosana acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","T̃arraña Juanpaʼ ama añeyaye ñeñt̃chaʼ puetarñatsotosets arr patsro; ñapaʼ añecpa huapa att̃och aʼpot̃osan ñeñt̃chaʼ aʼpuetarsam̃p̃sañtostsa. ");
INSERT INTO ameNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Allempoña c̈hap añe patsro ñeñt̃ puetarñatsotosets t̃arroʼmar añ puetarñatser ñeñt̃ eʼñe poʼñoc̈h ñeñt̃chaʼ aʼpuetarsam̃p̃soseʼ allohuen acheñeneshaʼ poct̃ap̃ña, ñeñt̃paʼ alletsa, oʼch orrtosa añe patsro. ");
INSERT INTO ameNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Amaʼt añ patspaʼ ño pueyec̈hcatareñ, acheñeneshaʼña arr patsropaʼ arepaʼtchaʼ cohuenayeʼ agapapeto t̃arroʼmar ama eseshayeʼ eñotapaye. ");
INSERT INTO ameNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Amaʼt arr c̈hapañ eʼñe ña pamoʼtseshesho, pamoʼtseshaʼñapaʼ arepaʼtchaʼ cohuenayeʼ agapapeto. ");
INSERT INTO ameNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","T̃arraña puesheñaʼtets ñeñt̃ eʼñe cohuen agapyesapueʼ, amaʼt allohuen ñeñt̃chaʼ ameʼñerraya ña, ñetñapaʼ apuerranet llesens att̃och eʼñe puechemer perranet Yompor Parets. ");
INSERT INTO ameNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ñeñt̃ att̃o puechemer perrey Yompor ñeñt̃paʼ ama att̃eyaye atet̃ yeʼñalletena ya ñeñt̃ey arromñat̃ey. T̃arroʼmar ñeñt̃ att̃o yeʼñalletena arr patsropaʼ ñeñt̃paʼ atet̃ anaret̃ey ya ñeñt̃ey arromñat̃ey. Ñam̃a att̃o puechemer oʼ perrey Yompor, ñeñt̃paʼ ama añot̃eyaye ñeñt̃ atet̃ cot̃apeʼchateney poʼpsheñeñ acheñ poct̃ap̃ña. Yapaʼ añot̃ña oʼ puechemer perrey Yompor att̃o oʼ muenaterrey eʼñe ña poct̃ap̃ña. ");
INSERT INTO ameNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Cristoña ñeñt̃ Poʼñoñ pen Yompor oʼ acheñetos arr patsro, oʼ yeyc̈hañ eʼñe parro mameʼ añe patsro. Ñapaʼ atarr amuerañtosa. Ñam̃a att̃o yec̈hatosey Yompor poʼñoñ ñeñt̃ña ñoñetspaʼ eʼñe poʼñoc̈h atet̃, ama shequëñtsoyaye amaʼt mamesha. Ñam̃a yapaʼ c̈hocma yentoñeʼt̃ poʼcohuenña. Ñeñt̃ña poʼcohuenñapaʼ atet̃ ñerraʼm Pompor ñeñt̃ poʼpat̃rror peneʼ ña. ");
INSERT INTO ameNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Allempoña Juan puerranarot̃paʼ aʼpot̃an Cristo, ñeñt̃paʼ atet̃ eñora ñocop: —Añmapaʼ ñeñt̃caʼyeña notaseʼt̃ ahuaña, ñeñt̃chaʼ huapatsa chentaʼ ñapaʼ atarr ahuamencat̃eshaʼ, nañapaʼ ama tama ahuamencat̃eyayno, t̃arroʼmar ñapaʼ ahuat̃ot̃eñ eñalla. Amaʼt allempo neʼñalleta na, ñañapaʼ eñalla. Ñeñt̃paʼ allohua atet̃ ot Juan ñenmat̃ Cristocop. ");
INSERT INTO ameNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ñapaʼ atarr amuerañtosa ñeñt̃oʼmarña allohueneypaʼ atarr bensareʼtam̃peney. Alloʼna sen yebensareʼtam̃pesneneʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ñoñets ñeñt̃ atet̃ anaret̃ ahuat̃ot̃eñpaʼ ñeñt̃ quellconay Moisés ahuat̃. T̃arraña Jesucristopaʼ ñaña orrtatoseʼña muereñets ñam̃a ñapaʼ añ orrtatonay ñoñets ñeñt̃ eʼñe poʼñoc̈h Yompor poʼñoñ alloch yequeshperra. ");
INSERT INTO ameNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Yompor Paretspaʼ amaʼt ahuat̃apaʼ ama eseshayeʼ puentare. Poʼpat̃rrorña ñeñt̃ Cristotosets ñeñt̃paʼc̈hoʼña Parets ñeñt̃ eʼñe parro att̃ecmuet; ñapaʼ ña yeñotaterreʼña atet̃ penaña Pompor Parets. ");
INSERT INTO ameNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Allempo judioneshaʼ paʼm̃chaʼtaret̃erneshaʼ ñetñapaʼ mueñet acheñ Jerusaléñot̃ ñeñt̃chaʼ ahuanmatsa Juanesho. Añ mueñet judioneshaʼ poʼcornaneshar ñam̃a levitaneshaʼ ñeñt̃ poʼtaruas peneʼ oʼch t̃orrenet Parets paʼpacllo. Ñetpaʼ añecop amñaret̃tet ñetchaʼ aʼp̃t̃oʼtoset Juan ñapaʼ eseshaʼt̃eʼña. Oʼña c̈hapuet ñeshopaʼ atet̃ otoset: —P̃apaʼ ¿eseshapeʼtña, amaʼt añeyaype ñeñt̃ep̃chaʼ Cristoterrets? ");
INSERT INTO ameNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juanñapaʼ ama aʼnasoto; att̃o aʼmet̃apaʼ ñapaʼ atet̃ otapanet: —Napaʼ amacaʼye añeyayno ñeñt̃chaʼ Cristoterrets. ");
INSERT INTO ameNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ñetñapaʼ alla otereterr: —Ñeñt̃epñapaʼ ¿eseshapeʼtña, amaʼt añeyaype Elías ñeñt̃ aʼm̃tayeʼt̃ ahuat̃ Yompor poʼñoñ? Ñañapaʼ atet̃ oterraneterr: —Amacaʼye ñeñt̃eyayno. Ñetñapaʼ alla aʼp̃t̃oʼtereterr: —Amapaʼ ñatoʼ ¿añep̃t̃eʼ ñeñt̃ep̃chaʼ aʼm̃terreʼ Yompor poʼñoñ ñeñt̃ yecuen? Ñañapaʼ alla oterraneterr: —Amacaʼye ñeñt̃eyayno. ");
INSERT INTO ameNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ñetñapaʼ alla otereterr: —Ñeñt̃epñapaʼ ¿eseshapeʼtña p̃a? Yapaʼ yemneñcaʼye oʼch p̃otey allochñapaʼ oʼch yoteraʼ ñeñt̃ yemñeneʼ. ¿Errot̃enaʼtchaʼña p̃oteyña p̃ocop? ");
INSERT INTO ameNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ñañapaʼ atet̃ oterraneterr: —Napaʼ nocopcaʼye eñoseʼt̃ña Isaías ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ ahuat̃. Allempopaʼ atet̃caʼ oteʼt̃: Eʼmorrterrach puesheñarr poʼñoñ all amayo allchaʼ serrpareʼtaterranña acheñeneshaʼ. Puerranarot̃paʼ añchaʼ tomaʼntaterranet t̃oñ ñapaʼ atet̃chaʼcaʼye oterranet: “Saʼcohuenetyes t̃oñ allchaʼ oñmos Partseshaʼ oʼch eʼñe saʼpac̈harretyesoñ paʼt̃ep̃.” ");
INSERT INTO ameNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ñehua, ñeñt̃ amñaret̃tatsa Juanesho, ñetpaʼ añcaʼye mueñenahuet ñeñt̃ fariseoneshaʼ ñeñt̃ara judioneshaʼ paʼm̃chaʼtaret̃erneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ñetñapaʼ alla otereterr Juan: —Arepaʼt Cristoyaypepaʼ esoʼmaruañacaʼyeña p̃apatenña Yomporecop, arepaʼt Elíasoyaype, arepaʼt añeyaype ñeñt̃chaʼ aʼm̃terreʼ Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juanñapaʼ atet̃ oterraneterr: —Napaʼ amaʼt napatyen Yomporecoppaʼ eʼñecaʼye oñochaya napatyenanet. T̃arraña oʼ c̈hap sesho poʼpsheñeñ ñeñt̃ ello atarr sherbets, t̃arraña sapaʼ amacaʼye señoteñeña sa. ");
INSERT INTO ameNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ñapaʼ amaʼtchaʼ chenta huapapaʼ ñapaʼ ñeñt̃caʼyeña ello atarr sherbets; nañapaʼ ama es nesherbeno att̃och amaʼt poʼsapatrec̈hapaʼ oʼch nepyam̃pes. ");
INSERT INTO ameNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ñehua, allpaʼ atet̃caʼye penet all oteñet Betábara allara Jordanaso yom̃taʼn t̃arroʼmar Juanpaʼ allcaʼye apatyenanña acheñeneshaʼ Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tsapat̃ña Juan allempo entapan Jesús ñeshonet̃ en, ñañapaʼ atet̃ otan acheñeneshaʼ: —Añcaʼyeña ñeñt̃ oʼ llesenserr Yompor ñeñt̃chaʼ Poʼcarrneror pen, ñach yahuanmam̃perreʼ yoʼchñar allohueney ñeñt̃ey añe patsroʼtsaʼyeney, t̃arroʼmar ñach rromuerrets yoʼchñarecop atet̃chaʼ perra atet̃ amtsaret̃tena carrnero ochñartsocop. ");
INSERT INTO ameNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Añmapaʼ ñeñt̃caʼyeña notaseʼt̃ ahuaña: “Ñeñt̃chaʼ huapatsa chentaʼpaʼ ñapaʼ atarr ahuamencat̃eshaʼ, nañapaʼ ama tama ahuamencat̃eyayno, t̃arroʼmar ñapaʼ ahuat̃ot̃eñ eñalla. Amaʼt allempo neʼñalleta na, ñañapaʼ eñalla.” ");
INSERT INTO ameNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Amaʼt na ahuañmoʼchapaʼ ama neñoteñe eseshaʼt̃eʼña ñeñt̃chaʼ huapatsa chentaʼ ñeñt̃chaʼ Cristoterrets. T̃arraña napaʼ añecpaña nohuena nach apatyesnomueʼ acheñeneshaʼ oño, att̃ochña norrtaterrñañ israelenaʼtarneshacop ñeñt̃ poʼñoc̈h Puechemer pen Yompor. ");
INSERT INTO ameNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Allempoña Juanpaʼ eñotatan acheñeneshaʼ ñapaʼ atet̃ otanet: —Na ahuaña allempo napatap̃ Jesúspaʼ Yomporña Puecamquëñ eʼñe atet̃ nentap̃ ñerraʼmrrat̃eʼ yep̃ oʼ sohuaʼnma entot̃, c̈hap eʼñe Jesúsesho. ");
INSERT INTO ameNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Amaʼt allempo napaʼ ama neñoteñe ñeñt̃t̃eʼña Yompor Puechemer t̃arraña Yompor ñeñt̃ oʼ llesenserren att̃och napatyes acheñeneshaʼ oño, ñapaʼ atet̃caʼye otenen: “Esempoch pent oʼ sohuaʼnma Necamquëñ oʼch c̈hap eʼñe ñesho ñeñt̃chaʼ chorrosaya, ñapaʼ ñeñt̃chaʼcaʼyeña chorraterrahuetña Parets Puecamquëñ.” ");
INSERT INTO ameNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Na poʼñoc̈hpaʼ oʼcaʼye neñch ñeñt̃oʼmar t̃eʼpaʼ neñotatenes ñeñt̃caʼyeña Yompor Puechemer. ");
INSERT INTO ameNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tsapat̃ñapaʼ poʼpocheño all t̃en Juan epuet epsheña pueyochreshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Cohuenan Jesús all chopeñeʼchen aʼyenet̃, alla oterraneterr: —Añcaʼyeña ñeñt̃ Poʼcarrneror pen Yompor. ");
INSERT INTO ameNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ñeñt̃ña epsheña pueyochreshaʼ allempo eʼmet atet̃ oteñ Juan, ñetñapaʼ allent̃a cot̃aʼnmet Jesús. ");
INSERT INTO ameNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Puetallesnomtsaña Jesúspaʼ entapanet cot̃aʼneñet chentaʼ ñañapaʼ atet̃ otapanet: —¿Esoʼtña semnen? Ñetñapaʼ atet̃ ochet: —Maestro, ¿erraʼtña pec̈hap? ");
INSERT INTO ameNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ñañapaʼ atet̃ otanet: —Soct̃errencaʼye oʼch senteñaʼ. Ñetñapaʼ allent̃a cot̃aʼneret Jesús oʼch enteñetaʼ all aʼposa. Alla aʼposet ñamet ñeñt̃e yet̃ro t̃arroʼmar allempopaʼ oʼ mam̃amena oʼch ellerren. ");
INSERT INTO ameNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ñehua, ñeñt̃ña epsheñoʼmaret ñeñt̃ eʼmueʼ atet̃ oten Juan ñeñt̃ cot̃eʼ Jesús, puesheñarr ñeñt̃paʼ Andrés ñeñt̃ Simón Pedro paʼmoʼnasheñ. ");
INSERT INTO ameNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrésñapaʼ allorocma ahuerr eʼnerrayaʼ Simón; oʼña enteraʼpaʼ atet̃ otuerr: —Yapaʼ oʼcaʼye yenter Mesías. (Ñehua, ñeñt̃ña ñoñets Mesías añcaʼye otenet ñeñt̃chaʼ Cristoterrets.) ");
INSERT INTO ameNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andrésñapaʼ allent̃a anerran paʼmoʼnasheñ Simón Jesúsesho. Jesúsñapaʼ cohuapueʼpaʼ atet̃ otap̃: —P̃aʼtña Simón, ñeñt̃ep̃ puechemer pen Jonás. T̃eʼpaʼ nesocherrep̃chaʼ Cefas (ñeñt̃ara soʼchñets ñeñt̃ otenet griegac̈ho Pedro). ");
INSERT INTO ameNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tsapat̃ña Jesúspaʼ sechena oʼch ahuerr Galileo. Allña entuenan Felipe ñañapaʼ atet̃ otueñ: —Amaʼt pemno oʼch p̃oct̃enen. ");
INSERT INTO ameNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ñehua, Felipepaʼc̈hoʼña galileoʼmarneshaʼ, ña paʼnetserpaʼ añ paʼsoʼcheñ Betsaida ñeñt̃ara ñam̃a Andrés paʼnetser ñam̃a Pedro. ");
INSERT INTO ameNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipeñapaʼ entuenan Natanaelpaʼ atet̃ otueñ: —Yapaʼ oʼcaʼye yenter ñeñt̃ ñocop quellquëʼt̃ Moisés all orrtatan ñoñets ñeñt̃ atet̃ anaret̃, ñam̃a ñocop quellquëʼt̃ ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ. Añepaʼtcaʼye Jesús ñeñt̃ huetsa Nazaretot̃ ñeñt̃ José puechemer. ");
INSERT INTO ameNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaelñapaʼ atet̃ otapan Felipe: —Nazaretot̃paʼ amaʼt ahuat̃apaʼ amacaʼye huenoña ñeñt̃ eʼñe cohuen acheñ. Felipeñapaʼ atet̃ otererr: —Poʼñoc̈h orracaʼye oʼch penteñaʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanaelpaʼ allent̃a ahuoʼ oʼch entenanaʼ Jesús. Jesúsñapaʼ entapan Natanaelpaʼ ñañapaʼ atet̃ eñora ñocop: —Añcaʼyeña poʼñoc̈h puesheñarr israelneshaʼ ñapaʼ amacaʼye shequëno amaʼt mamesha. ");
INSERT INTO ameNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaelñapaʼ atet̃ otosan Jesús: —Napaʼ ¿errot̃enot̃eʼtña peñotenen? Amacaʼye pentarno. Jesúsñapaʼ atet̃ otererr: —Allempo ama aʼsechenp̃aʼ Felipe nesho, allempo p̃apaʼ alla p̃anen mañt̃o higocho nañapaʼ nentenep̃caʼye. ");
INSERT INTO ameNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaelñapaʼ atet̃ otererr: —Maestrochaʼ pepaʼtña Yompor Puechemerep̃. Pepaʼtña Am̃chaʼtaret̃ ñeñt̃ atarr cohuen allohuen israelneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesúsñapaʼ otererr: —Napaʼ oʼ notap̃ napaʼ nentenep̃ allempo p̃anen mañt̃o higocho, ñeñt̃oʼmart̃eʼña oʼ p̃ameʼñaʼna. T̃eʼñapaʼ oʼch notas, elloña t̃eʼpaʼ nanacchaʼ senterrnan nepartsoña ñeñt̃ ama tama sentennanaʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesúsñapaʼ alla otererr: —Poʼñoc̈hcaʼ notenes, senterrchaʼ enet atoraret̃ ñam̃a Yompor poʼm̃llañot̃eñreneshaʼ aʼtac̈henet ñam̃a sohuac̈henet eʼñe nesho, na Ñeñt̃en Acheñetosets. ");
INSERT INTO ameNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Oʼña maʼpamuetuerr allempo c̈herr Jesús Galileo, allña anetso Caná atarr coshaprechet puesheñarr yacma ñeñt̃ senaʼtetsa. Jesúsña pachorpaʼ alloʼtsen. ");
INSERT INTO ameNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesúsña epuet pueyochreshaʼpaʼ ñetpaʼc̈hoʼña ahuaʼñaret̃tet allchaʼ rrallmeʼchapretenetaʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Allñapaʼ c̈ha huañap̃set vinos. Jesúsñapaʼ atet̃ och pachor: —T̃eʼpaʼ ama eñalle vinos, oʼc̈ha huañap̃set. ");
INSERT INTO ameNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesúsñapaʼ atet̃ otan pachor: —Achochaʼ esoʼmareʼtña atet̃ p̃otenenña na. Nocoppaʼ amacaʼye c̈henaʼ allempoch es norrtatyes. ");
INSERT INTO ameNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","T̃arraña amaʼt atet̃ otañpaʼ pachorñapaʼ atet̃ otan ñeñt̃ sherbets all: —Ñerraʼm errot̃enchaʼ otas nechoyorpaʼ sañapaʼ eʼñech atet̃ sep̃a. ");
INSERT INTO ameNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ñehua, allpaʼ alloʼtsen pechapm̃a orrot̃ mapyem̃. Ñeñt̃ña orrot̃ec̈hnopaʼ tama ateshamerr, puem̃aʼttso orrot̃paʼ ñatoʼ sent̃eʼ oñ epa galon amapaʼ maʼpat̃eʼ galon sets oñ att̃och chorraresua. Ñeñt̃ orrot̃ec̈hnopaʼ allecma nenet oñ alloña aʼcohuentatena judioneshaʼ Partsocop ñeñt̃ atet̃ anaret̃tenet ñocpuet. ");
INSERT INTO ameNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Allñapaʼ atet̃ otan Jesús ñeñt̃ sherbets all: —T̃eʼpaʼ oʼch seʼchorrayes oñ orrot̃o. Ñetñapaʼ atet̃c̈hoʼ pet eʼñe eʼchorraresuahuet oñ. ");
INSERT INTO ameNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Allempoña oʼ eʼchorraresuetpaʼ Jesúsñapaʼ atet̃ oterraneterr: —T̃eʼñapaʼ oʼch sesheʼ coñeʼt̃paʼ oʼch sanem̃ alloʼtsen aneʼtañ. Ñetñapaʼ atet̃c̈hoʼ pet. ");
INSERT INTO ameNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Allempoña aneʼtañpaʼ allent̃a amllan oñ ñeñt̃ aʼpnasaret̃ vinos ñañapaʼ ama eñoche errot̃t̃eʼ oʼ huapatetña vinos. Aña eñoteneʼ ñeñt̃ sherbenahuet all ñeñt̃ etasoteʼ oñ. Allempoña amllaʼhuan vinospaʼ ñañapaʼ allent̃a agotan ñeñt̃ senaʼtetsa. ");
INSERT INTO ameNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ñeñt̃paʼ atet̃ och: —Ñerraʼm c̈ho yorrpaʼ añchaʼña ñanom yorrtat ñeñt̃ eʼñe cohuen vinos. Oʼchña yonuahue ahuaʼñaret̃ eʼñe cohuen vinospaʼ allempochña yapanet ñam̃a ñeñt̃ ama eʼñe cohuenayaye. T̃arraña p̃añapaʼ amaña att̃eyeʼ pepeno. Ñeñt̃apaʼ c̈haʼtña p̃aññoʼtuaña vinos ñeñt̃ eʼñe cohuen t̃ayañoʼ p̃orrtach. (Aneʼtaññapaʼ atet̃ otan ñeñt̃ senaʼtetsa t̃arroʼmar ñapaʼ ama eñoteñe.) ");
INSERT INTO ameNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","All ñanom entatanet Jesús poʼpartsoñapaʼ ñeñt̃paʼ arr Cano allara Galileo. Att̃ocaʼyeña orrtatanetña Jesús poʼpartsoteña. Allempoña pueyochreshaʼpaʼ oʼ eñochet poʼñoc̈hepaʼt ñapaʼ Parets att̃oña eʼñe ameʼñyet. ");
INSERT INTO ameNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Allempoña Jesúspaʼ ahuoʼ Capernaumo pachoreʼna ñam̃a paʼmoʼnasheñec̈hno, ñam̃a allohuen pueyochreshaʼ. Allñapaʼ alla allponmatenetaʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Allempoña c̈hapmoch pascuapo allempoch alla cosherrerr judioneshaʼ. Jesúsñapaʼ ahuerr Jerusaléño. ");
INSERT INTO ameNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Allña Parets paʼpacllopaʼ entuenan ñeñt̃ pomueneʼ poʼhuacsher, ñam̃a carrnero, ñam̃a yep̃; ñam̃a ñeñt̃ cam̃yaʼyenahuet poʼc̃llayoretpaʼ ñetpaʼc̈hoʼña alla anorrc̈henet. ");
INSERT INTO ameNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Allñapaʼ pelltaʼtosan apec̈h pashtarec̈h. Eʼñe matatuosan allohuen ñeñt̃ pomatsreʼtyetsa Parets paʼpacllo, eʼñe ahuanerret poʼhuacsher ñam̃a poʼcarrneroret. Ñam̃a ñeñt̃ cam̃yaʼyenahuet poʼc̃llayoretpaʼ eʼñe yoʼpatsetam̃pesuosanet poʼc̃llayoret patso. Eʼñe aʼcoyeʼtam̃pesuosanet all naʼyenet poʼc̃llayoret. ");
INSERT INTO ameNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Allpaʼ atet̃ otosan ñeñt̃ pomueneʼ yep̃: —T̃eʼpaʼ sahuanerr añ arrot̃. Amach atet̃ sep̃atstono Nompor paʼpaquëll atet̃ ñerraʼmrrat̃eʼ ñeñt̃ eʼñe pocollenochaya allecma pomatsreʼtyenet. ");
INSERT INTO ameNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Allempoña pueyochreshaʼpaʼ allent̃a yerpuet ñoñets ñeñt̃ anaret̃ ahuat̃ot̃eñ ñocop, ñeñt̃paʼ atet̃ oten: “Napaʼ atarrchaʼ nempaʼtonap̃ pepaquëll amaʼtchaʼ ñeñt̃oʼmareʼna muetserrnetañ.” ");
INSERT INTO ameNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Allempoña judioneshaʼ paʼm̃chaʼtaret̃erneshaʼpaʼ atet̃ ochet: —Añña p̃orrtatosnay pepartsoña allochñapaʼ att̃ochña yeñotap̃ poʼñoc̈hpaʼ p̃apaʼ allsensaret̃ep̃t̃eʼ, t̃eʼñapaʼ att̃oʼ pep̃osnayt̃eʼ añec̈hno. ");
INSERT INTO ameNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesúsñapaʼ atet̃ oterraneterr: —Sapaʼ amaʼtchaʼ saʼmatoñ añ Parets paʼpaquëllpaʼ pomaʼpamtañoña napaʼ oʼch alla nat̃omater. ");
INSERT INTO ameNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Judioneshaʼñapaʼ alla otereterr: —Añ att̃o eʼnuoñet Parets paʼpaquëllpaʼ atarr atomat at̃orraret̃ta eʼñe paʼtatsoch c̈harrohua char puechena pechap. Taʼ, p̃añapaʼ ¿poʼñoc̈hchaʼ eʼñech pomaʼpamtañocma yet̃paʼ oʼch alla p̃at̃omatuer? ");
INSERT INTO ameNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ñehua, Jesúspaʼ añepaʼt otanet ña poʼchets ñeñt̃epaʼt paʼpaquëll pen Parets. ");
INSERT INTO ameNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ñehua, c̈hap allempo muetseret Jesús allempoña tanterrapaʼ pueyochreshac̈hnoñapaʼ allent̃a yerpuerret ñeñt̃ atet̃ oteʼt̃ Jesús allempo. Ñeñt̃oʼmarña allempo Jesús pueyochreshac̈hnopaʼ atarr yemterrñañet Yompor poʼñoñ ñeñt̃ anuaret̃ ahuat̃ot̃eñ, amaʼt ñam̃a Jesús poʼñoñ atarr ameʼñeret. ");
INSERT INTO ameNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Allempoña alloʼtsen Jesús Jerusaléño, all coshapretenet pascuapo shonteʼ acheñeneshaʼ enteññañet ñeñt̃ att̃o orrtatenanet poʼpartsoña all, ñeñt̃oʼmarña allpaʼ shonteʼ ameʼñaya. ");
INSERT INTO ameNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","T̃arraña Jesúspaʼ ama yemtaneteʼt̃e ñet, t̃arroʼmar ñapaʼ eñotaneteʼt̃ atet̃ allohueney acheñey c̈hocma yoct̃apeʼchyen ñeñt̃ yemnen ya. ");
INSERT INTO ameNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ñapaʼ ama eʼnenano amaʼt puesheñarra ñeñt̃chaʼ oteʼ ñeñt̃ atet̃ yoct̃apeʼchyen allohueney acheñey. T̃arroʼmar ñapaʼ c̈hocma eñoteney atet̃ yoct̃apeʼchyen allohueney acheñey. ");
INSERT INTO ameNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Allempopaʼ eñall puesheñarr yacma ñeñt̃ fariseo ñeñt̃ sochetsa Nicodemo. Ñeñt̃ñapaʼ puesheñarr ñeñt̃ am̃chaʼtaret̃tetsa judioneshacop. ");
INSERT INTO ameNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ñañapaʼ huapa Jesúsesho tsapopaʼ atet̃ otos: —Maestrochaʼ yeñotenep̃ p̃apaʼ añ pellsenseneʼ Yompor att̃och peyc̈hatosey cohuen t̃arroʼmar yapaʼ yeñoteñ añach orrtatyeneʼ partsoteñets ñeñt̃ ahuamencat̃ pen Yompor. ");
INSERT INTO ameNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesúsñapaʼ atet̃ otap̃: —Eʼñe poʼñoc̈h notap̃, eseshaʼch ama eñalleterrtso ello ñetñapaʼ amach errot̃enot̃ pueyochreshaʼ perraneto Yompor. ");
INSERT INTO ameNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemoñapaʼ atet̃ otererr: —Amat̃eʼ errot̃enot̃ yeʼñalleterrerroña poʼpocheñoñaʼ oʼcaʼye yepoʼnmeʼten. Errot̃enot̃uat̃eʼñacaʼ yec̈herrerrña yachor paʼt̃o att̃ot̃chaʼ yeʼñalleterrerr poʼpocheño. ");
INSERT INTO ameNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesúsñapaʼ atet̃ otererr: —Eʼñe poʼñoc̈h notenep̃, erraʼtsenchaʼ ama eñalleterrtso oñot̃ ñam̃a Yompor Puecamquëñot̃, amat̃eʼ errot̃enot̃ pueyochreshaʼ perraneto Yompor ñeñt̃oʼmarña amach eshec oʼpatapreteretoña Yompor poʼcohuenña ñeñt̃ att̃o ayochreshat̃tena ña. ");
INSERT INTO ameNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ñeñt̃ att̃o eñalletena arromñat̃eneshaʼpaʼ ñeñt̃paʼ arromñat̃a. T̃arraña ñeñt̃chaʼ eñalleterrtsa Parets Puecamquëñot̃, ñeñt̃paʼ ñeñt̃ña camuecñetsotets ñeñt̃ñapaʼ ama arromñat̃eshayaye. ");
INSERT INTO ameNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ñeñt̃ atet̃ notenep̃, “allohuenespaʼ añ sepalltena oʼch seʼñalleterrerr ello”, p̃apaʼ amach c̈ha peʼcharrtatsto peyoc̈hro, amach c̈ha p̃otatsto añoʼt̃eʼ errot̃enot̃ peʼñalleterrerroña ello poʼpocheño. ");
INSERT INTO ameNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ñeñt̃paʼ eʼñe atet̃ pena ñerraʼmrrat̃eʼ m̃orr. M̃orrpaʼ erra mueneʼpaʼ allchaʼ m̃orraren. Peʼmuent̃eʼ atet̃ maʼmoreten, ama peñoteñe errot̃t̃eʼña huena ñam̃a errat̃eʼña sen. Atet̃chaʼ perra ñam̃a allohuen erraʼtsenchaʼ eñalleterrtsa Yompor Puecamquëñot̃. ");
INSERT INTO ameNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemoñapaʼ alla aʼp̃t̃oʼtererr: —Ñeñt̃paʼ ¿errot̃enaʼtña añ? ");
INSERT INTO ameNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesúsñapaʼ atet̃ otererr: —P̃apaʼ amaʼt añepeñ israelneshaʼ poʼmaestror, amaʼt peñotenoña añ. ");
INSERT INTO ameNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Eʼñe poʼñoc̈h notenep̃: Allohueney ya ñeñt̃ yeñotenpaʼ ñeñt̃chaʼña yeserrpareʼten ñam̃a ñeñt̃ yentyenpaʼ ñeñt̃chaʼña yaʼpot̃en t̃arraña sapaʼ ama c̈hennasoña seyoc̈hro añ ñeñt̃ yaʼpot̃en. ");
INSERT INTO ameNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ñerraʼm aña notenes ñeñt̃ atet̃ yeyc̈hena añe patsro, saña ñerraʼm ama sameʼñennopaʼ errot̃enot̃uat̃eʼñacaʼye notasña ñam̃a entoʼmar ñeñt̃ Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Ama eñalle amaʼt puesheñarra ñeñt̃chaʼ aʼtapuets ento ñam̃a ñeñt̃chaʼ sohuerrtsa ñeñt̃ara entot̃. Napt̃aña na Ñeñt̃en Acheñetosets ñeñt̃en sohuatsa entot̃, napt̃a nentar Nompor pueʼntaño t̃arroʼmar napaʼ ñeñt̃ naʼnetser nepen. ");
INSERT INTO ameNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ñehua, ahuat̃ Moiséspaʼ yec̈hcatan ñeñt̃ atmaʼntataret̃ shechep̃ all amayo, ñeñt̃ñapaʼ huanquëʼ tsachopaʼ oʼ echantam̃pes enonet̃. Att̃o Moisés echantam̃p̃san shechep̃ all amayopaʼ, napaʼc̈hoʼña ñeñt̃ poctetsa nocop atet̃chaʼ perrnet nam̃a, corsochot̃chaʼ echantam̃p̃saret̃en. ");
INSERT INTO ameNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Allochñapaʼ allohuen amaʼt erraʼtsena ñeñt̃chaʼ nameʼñerraya na, ñetñapaʼ amach chenquërreto, eʼñech corretseta pocsheñeshocmañen eʼñe t̃ayot̃eñ errponañohuen. ");
INSERT INTO ameNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Att̃o atarr morrentenya Yompor allohueney acheñeneshay arr patsro ñeñt̃oʼmarña apuey Puechemer ñeñt̃ poʼpat̃rror pen, allochñapaʼ allohuen ñerraʼm eseshaʼ ameʼñerraya ña amach chenquërreto, ñetñapaʼ corretsetach pocsheñeshocmañen eʼñe t̃ayot̃eñ errponañohuen. ");
INSERT INTO ameNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Yomporpaʼ amacaʼye añecpayeʼ mueñanoña Puechemer arr patsro att̃och mueñosan acheñeneshaʼ coñcheñtso. Ñapaʼ añecopña mueñe att̃och ñach aʼqueshp̃atoseʼña acheñeneshaʼ arr patsro. ");
INSERT INTO ameNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Erraʼtsenchaʼ ameʼñerraya ña ñetñapaʼ amach amñaret̃terreto coñcheñtso. T̃arraña ñeñt̃chaʼ ama ameʼñerrayo ñocpuetñapaʼ anaret̃tet att̃och amñaret̃terret coñcheñtso t̃arroʼmar ñetpaʼ ama ameʼñoñeto Yompor Puechemer ñeñt̃ poʼpat̃rror pen. ");
INSERT INTO ameNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ñañapaʼ oʼ huapa arr patsro att̃och yec̈hatosey ñeñt̃ eʼñe cohuen enten Yompor, att̃oña aʼpuetarsam̃p̃sosnay yoct̃ap̃ña. T̃arraña shonteʼ acheñeneshaʼ ñetñapaʼ ama mueneto oʼch aʼpuetarsam̃p̃saret̃tet poct̃ap̃ñet. Ñetpaʼ aña muenenet checmeteʼ t̃arroʼmar amacaʼye masosyayeʼ cot̃apeʼchyeneto. Ñeñt̃oʼmarña ñetpaʼ att̃ot̃chaʼña amñaret̃terret coñcheñtso. ");
INSERT INTO ameNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Allohuen ñeñt̃ ama masosyayeʼ cot̃apeʼchyeneto ñetpaʼ ama cohuenayeʼ enteñetoña Cristo ñeñt̃ aʼpuetarsam̃peneʼ allohueney yoct̃ap̃ña. Ñeñt̃oʼmarña ama eneto alloʼtsen ñeñt̃ aʼpuetarsam̃p̃sañtetsa t̃ayeʼtoʼt̃eʼ orrtataret̃tet poct̃ap̃ñet ñeñt̃ ama masosyo. ");
INSERT INTO ameNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Añña ñeñt̃ eʼñe atet̃ peneʼ ñeñt̃ poʼñoc̈h cohuen enten Yompor, ñetpaʼ eʼñe pocteʼ enteñet oʼch onet alloʼtsen ñeñt̃ aʼpuetarsam̃p̃sañtetsa t̃arroʼmar ñetpaʼ añ muenenet oʼch eñotateret poʼpotantañ ñetpaʼ Yompor ahuamencat̃ penahuet ñeñt̃oʼmarña ñetpaʼ añ orrtatyenet ñeñt̃ cohuen enten Yompor. ");
INSERT INTO ameNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Allempoña Jesúspaʼ ahuerrerr Judeo epuet pueyochreshaʼ. Allñapaʼ alla allponmat epuet pueyochreshaʼ. Allña Jesúspaʼ apatyesan acheñeneshaʼ Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ñam̃a allempo Juanpaʼc̈hoʼña arr apatyenan acheñeneshaʼ all oteñet Enón eʼñe alla allameʼtets Salimo, t̃arroʼmar allpaʼ shonteʼ oñec̈hno. Acheñeneshaʼpaʼc̈hoʼña shonteʼ huac̈haʼtyeset att̃och apataret̃etyeset Yomporecop. ");
INSERT INTO ameNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ñehua, allempopaʼ ama yottam̃peñetaʼ Juan. ");
INSERT INTO ameNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Allempoña Juan pueyochreshaʼpaʼ serrpareʼtet epuet judioneshaʼ. Allpaʼ añ serrpareʼtatannaʼtet est̃eʼ poctetsaña att̃och yaʼcohuentataret̃ta Partsocop, añt̃eʼ ñeñt̃ att̃o apatyen Juan amapaʼ ñatoʼ añt̃eʼ att̃o apatyen Jesús. ");
INSERT INTO ameNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ñeñt̃oʼmarña ahuanmuet Juaneshopaʼ ñetñapaʼ atet̃ otoset: —Maestrochaʼ ñeñt̃ epap̃ ahuaña yom̃taʼn Jordanaso, ñeñt̃ peserrpareʼtatosey, ñapaʼc̈hoʼña ñepaʼtcaʼyeña apatyets ñam̃a. Ñeñt̃oʼmarña allohuenetpaʼ oʼcaʼye ahuanmuet ñesho. ");
INSERT INTO ameNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juanñapaʼ atet̃ otapanet: —Amaʼt puesheñarrot̃eyapaʼ ama ahuamencat̃eyayye ñerraʼm ama Yompor ahuamencat̃ yep̃aye. ");
INSERT INTO ameNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Sapaʼ amaʼt señoteñe ñeñt̃ atet̃ notuanmas ahuaña, napaʼ ama añeyayno ñeñt̃enchaʼ Cristoterrets. Napaʼ att̃a mueñan nanom att̃och nota. ");
INSERT INTO ameNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jesúspaʼ eʼñech atet̃ netmaʼntacha atet̃ ñerraʼmrrat̃eʼ yacma ñeñt̃ senaʼtetsa. Ñehua, ñeñt̃ senaʼtetsa ñeñt̃ñacaʼyeña aguëneʼña coyaneshaʼ ñeñt̃chaʼ puet̃apor p̃aʼ. T̃arraña ñeñt̃ña pueyempaʼ ñeñt̃ parro epuet t̃en ñerraʼm añ eʼm pueyem poʼñoñ ñeñt̃ senaʼtetsapaʼ ñañapaʼ atarrchaʼ coshapretana pueyem. Ñeñt̃oʼmarña na t̃eʼpaʼ atarr nocshapreteña Jesús. ");
INSERT INTO ameNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jesúspaʼ eʼñe pocteʼ alloʼnepaʼñacaʼyeña enteñet poʼñoc̈hpaʼ ñacaʼyeña atarr sherbets. Nañapaʼ eʼñe pocteʼ alloʼnepaʼña entennet napaʼ ama eʼñeyeʼ nesherbeno. Arrpaʼ allohua atet̃ ot Juan Cristocop. ");
INSERT INTO ameNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ñehua, yeñoteñ ñeñt̃ huetsa entot̃ Yomporeshot̃ eñchetepaʼ ñapaʼ atarrcaʼye am̃chaʼtaret̃. T̃arraña ñeñt̃ patsoʼmarneshaʼ ñeñt̃paʼ alla eñorena patsoʼmar. Ñeñt̃ huetsa entot̃ Yomporeshot̃ eñchetepaʼ ñapaʼ atarrcaʼye am̃chaʼtaret̃. ");
INSERT INTO ameNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","T̃arroʼmar allohuen ñeñt̃ entyen Pomporesho ñam̃a ñeñt̃ allpon eʼmyen all, ñapaʼ ñeñt̃caʼyeña serrpareʼtateney, t̃arraña amaʼt puesheñarrot̃apaʼ ama eseshayeʼ c̈hapahuetoña pueyoc̈hreto ñeñt̃ atet̃ otenanet. ");
INSERT INTO ameNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ñeñt̃ c̈hapa pueyoc̈hro ñeñt̃ atet̃ serrpareʼtatenanet ñeñt̃ huapatsa Yomporeshot̃ ñetñapaʼ atet̃ otet: Yomporpaʼ eʼñet̃eʼ poʼñoc̈h atet̃ oten Puechemerecop. ");
INSERT INTO ameNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","T̃arroʼmar ñeñt̃ llesensaʼ Yomporpaʼ Yomporo poʼñoño eñorena t̃arroʼmar Yomporpaʼ ama atparet̃ayaya chorratenanetoña Puecamquëñ. ");
INSERT INTO ameNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Yomporpaʼ atarrcaʼye nanac muerenanaña Puechemer. Ñeñt̃oʼmarña aphuahueñ allohuen allpon eñall allochñapaʼ ñach pomnaren penahuet. ");
INSERT INTO ameNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Eseshaʼch ameʼñenaya Yompor Puechemer ñetpaʼ corretsetach pocsheñeshocmañen t̃ayot̃eñ amaʼt errponañohuen. Añña ñeñt̃ at̃pareʼteneʼ Yompor Puechemer ñetpaʼ amach enterreto ñeñt̃ correñtsor. Ñetñapaʼ c̈hachcaʼye coñchaterranet Yompor. ");
INSERT INTO ameNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Allempoña Jesúspaʼ atarr ayochreshat̃ta nanac, ello metanenan att̃o yochreshaʼten Juan. Ñam̃a atarr apatyenan acheñeneshaʼ Yomporecop. Ñehua, ama ñayeʼ apatenahueto, aña apatenahuet pueyochreshaʼ. Ñeñt̃oʼmarña allempo eʼmareʼch fariseoneshaʼ ñeñt̃ara judioneshaʼ paʼm̃chaʼtaret̃erneshaʼ. Jesúsña allempo eñoch att̃o fariseoneshaʼ oʼ eñochet ña atarr nanac ayochreshat̃ta, ñañapaʼ allent̃a quec̈hpaʼnerran Judea, oʼ alla ahuerr Galileo. ");
INSERT INTO ameNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","T̃oññapaʼ eʼñe arr oñen Samarioʼmar, ñeñt̃oʼmarña all oñerrña Jesús. ");
INSERT INTO ameNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Oʼña c̈hap Samariopaʼ allot̃ñapaʼ oʼ ahuen pat̃err anetso ñeñt̃paʼ añ paʼsoʼcheñ Sicar. Añña anets Sicarpaʼ allameʼttsoʼtsena Jacob poʼpatseñ ñeñt̃ apaʼnman puechemer José ahuat̃. ");
INSERT INTO ameNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Allñapaʼ all poten oñ ñeñt̃ poʼñeñ peʼt̃ Jacob. Jesúsñapaʼ nanac tsanom puechopeʼcheñot̃ ñeñt̃oʼmarña anorros eʼñe allameʼtets apcoʼsat̃o. Allempopaʼ eʼñe poctoʼtsen atsneʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Allñapaʼ machayot̃a huapa puesheñarr coyaneshaʼ ñeñt̃ samarioʼmarneshaʼ ñeñt̃chaʼ etenayaʼ oñ. Jesúsñapaʼ atet̃ otap̃: —Napaʼ nemneñ oʼch p̃aposen oñ. Ñehua, allempopaʼ pueyochreneshaʼñapaʼ oʼ ahuanmuet anetso oʼch rañt̃enetaʼ ñeñt̃chaʼ rret. ");
INSERT INTO ameNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Coyaneshaʼña samarioʼmarneshaʼpaʼ atet̃ otos: —P̃apaʼ judioneshap̃paʼ esoʼmareʼtchaʼña penamapuenña oñ oʼch napap̃. P̃apaʼ peñotenen napaʼ ñeñt̃en samarioʼmarneshan. (Ñeñt̃oʼmarña atet̃ otos t̃arroʼmar judioneshaʼpaʼ ama amoʼtstanneneto epuet samarioʼmarneshaʼ.) ");
INSERT INTO ameNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesúsñapaʼ atet̃ otererr: —Ñerraʼm peñoteñeñ ñeñt̃ eʼñe att̃a apueney Yompor, ñam̃a ñerraʼm peñotennoñ na ñeñt̃en p̃oteneʼ p̃apuen oñ, p̃apaʼ oʼch penamuennoñ na nañapaʼ oʼch napospeñ oñ cohuen alloch eʼñe p̃ocrrañ. Ñeñt̃ oteñ oʼch ap̃ cohuen oñ, añ oteñ Yompor poʼcohuenña, t̃arraña coyaneshaʼñapaʼ ama eñoche, ");
INSERT INTO ameNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ñeñt̃oʼmarña atet̃ otererr: —Ama Ayochreshat̃e pecheno alloch pet oñ. Oñpaʼ nanacrramtso oʼponoʼtsen. Errot̃uamtsoch peyoraña oñ ñeñt̃ eʼñe cohuen alloch eʼñe yocrra. ");
INSERT INTO ameNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ahuat̃ yatañ Jacoboñ ñeñt̃ yapaʼnmueʼ añ oñ ñapaʼ ñeñt̃ orreʼt̃ ñam̃a puechemerneshañ ñam̃a poʼhuacsherneshañ. P̃apaʼ añep̃huat̃eʼcaʼye ñeñt̃ep̃ ello metaneneʼ yatañ Jacoboñ att̃o am̃chaʼtaret̃teʼt̃ ña. ");
INSERT INTO ameNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesúsñapaʼ atet̃ otererr: —Allohuen ñeñt̃ orreneʼ añ oñpaʼ elloch alla oñpaʼterreterr. ");
INSERT INTO ameNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","T̃arraña ñerraʼm eseshaʼ orreʼ oñ ñeñt̃chaʼ napanet na amaʼt ahuat̃apaʼ amach oñpaʼterreto. Ñeñt̃chaʼ napanet na oñ, eʼñe pueyoc̈hretopaʼ puenasanetchaʼ atet̃ ñerraʼmrrat̃eʼ allot̃ poten oñ, amach huañerro amaʼt ahuat̃a. Att̃ochña ñetpaʼ corretsetach t̃ayot̃eñ amaʼt errponañohuen. ");
INSERT INTO ameNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Coyaneshaʼñapaʼ alla otererr: —Ñeñt̃epñapaʼ Ayochreshat̃e p̃apuen ñeñt̃ oñer allochñapaʼ amach alla noʼñpaʼterrerro allochñapaʼ amach alla nohuerreʼt̃e eterrayerr arr oñ. ");
INSERT INTO ameNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesúsñapaʼ atet̃ otererr: —T̃eʼpaʼ orrerrep̃, oʼch pec̈horeʼteraʼ perrollar, allempochña alla pehuerra arr. ");
INSERT INTO ameNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Coyaneshaʼñapaʼ atet̃ otererr: —Napaʼ amarramtso arrollaret̃eno. Jesúsñapaʼ atet̃ otererr: —Eʼñe poʼñoc̈h atet̃ p̃oten añoʼ arrollaret̃eyaype. ");
INSERT INTO ameNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","T̃arroʼmar amnarsheña perrollaresheʼmañ ñeñt̃ pueyoruarep̃. Ñam̃a ñeñt̃ peyoreneʼ t̃eʼpaʼc̈hoʼña ama perrollareyaye. Ñeñt̃paʼ eʼñe poʼñoc̈h atet̃ p̃oten. ");
INSERT INTO ameNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Allempoña eʼman atet̃ oteñpaʼ coyaneshaʼñapaʼ atet̃ otererr: —Ayochreshat̃e, t̃eʼña poʼñoc̈hpaʼ oʼ neñotap̃ p̃apaʼ añepepaʼt ñeñt̃ep̃ aʼm̃teneʼ Yepapar poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Yatañneshañ samarioʼmarneshaʼpaʼ ñetpaʼ concorpueteʼt̃ maʼyochatset arr añ aspent̃ero. T̃arraña sa ñeñt̃es judioneshaspaʼ sapaʼ c̈ha soten aña pat̃err poctetsa Jerusaléñoʼchña yeconcorpuenaʼ allohueney. ");
INSERT INTO ameNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesúsñapaʼ alla otererr: —Noc̈heshachaʼ p̃ameʼñona ñeñt̃ atet̃ notenep̃ t̃arroʼmar t̃eʼpaʼ oʼ c̈hap ñerraʼm esempoch semaʼyocheña Yompor, ama sepallteno oʼch seconcorpueña Apa añ aspent̃ero amaʼt ñam̃a Jerusaléño. ");
INSERT INTO ameNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Saña ñeñt̃es samarioʼmarneshas aña semchatseʼtyen ñeñt̃ ama señoteno. Yaña ñeñt̃ey judioneshay añ yeconcorpanaʼtena ñeñt̃ eʼñe poʼñoc̈h yeñoten, t̃arroʼmar judioneshaʼpaʼ ñetpaʼ oʼ orrtateret ñeñt̃chaʼ aʼqueshp̃atañterrtsa. ");
INSERT INTO ameNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","T̃arroʼmar t̃eʼpaʼ oʼ c̈hap ñeñt̃chaʼ eʼñe poʼñoc̈h ayeʼchoc̈htaterreʼ Yompor, arrchaʼcaʼye ayeʼchoc̈htatoñet eʼñe ñet pueyoc̈hreto. Ñeñt̃chaʼ atet̃ ayeʼchoc̈htaterrñañet ñeñt̃ña eʼñe poʼñoc̈h atet̃ muenen Yompor. ");
INSERT INTO ameNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yompor Paretspaʼ ñapaʼ ña camuecñetsotets amacaʼye entpahuoyaye. Ñeñt̃oʼmarña ñeñt̃chaʼ eʼñe poʼñoc̈h ayeʼchoc̈htaterreʼ ña, arrchaʼcaʼye ayeʼchoc̈htatoñet eʼñe ñet pueyoc̈hreto, ñeñt̃paʼc̈hoʼña amacaʼye entpahuoyaye. T̃arroʼmar ñeñt̃chaʼ atet̃ ayeʼchoc̈htaterrñañet ñeñt̃ña poʼñoc̈h atet̃ muenen Yompor. ");
INSERT INTO ameNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Coyaneshaʼñapaʼ alla otererr: —Napaʼ neñoteñ añ Mesíaspaʼ huapach ñeñt̃ara ñeñt̃ yoten Cristo. Ñerraʼm ña huapatsapaʼ eʼñech serrpareʼtatuerrey ora allohuen ñeñt̃ esocmañen eñall. ");
INSERT INTO ameNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesúsñapaʼ alla otererr: —Napaʼ nacaʼye ñeñt̃en peserrpareʼtateneʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Eʼñe allempo atet̃ otenpaʼ pueyochreshaʼñapaʼ huac̈herret. Ñetñapaʼ att̃a cohuanrroretueret all serrpareʼtatenan coyaneshaʼ. T̃arraña ñetpaʼ amaʼt puesheñarrot̃apaʼ ama eseshayeʼ otuerraye ¿esoʼtña pemnen? Amaʼt puesheñarrot̃etapaʼ ama otuereto ¿esoʼmareʼt peserrparenña epap̃ coyaneshaʼ? ");
INSERT INTO ameNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Coyaneshaʼñapaʼ alla naʼnerran porret̃paʼ oʼ ahuerr alla paʼnetsro. Allñapaʼ otuerran pamoʼtseshaʼ: ");
INSERT INTO ameNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—T̃eʼpaʼ soct̃erren oʼch senteñaʼ puesheñarr encaneshaʼ ñeñt̃ oʼ serrpareʼtatuosen ora allpon ñeñt̃ atet̃ nep̃aʼyesara. Ñatoʼ ñeñt̃t̃eʼña Cristotets ñeñt̃ atarr yecuen oʼch huapa. ");
INSERT INTO ameNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ñetñapaʼ allent̃a onac̈haʼtet anetsot̃paʼ oʼ ahuanmuet Jesúsesho. ");
INSERT INTO ameNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Allempo ama c̈hac̈henetaʼ ñesho pueyochreshaʼñapaʼ atet̃ otyeñet: —Maestro maʼmat̃eʼt̃ach rreñets. ");
INSERT INTO ameNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","T̃arraña ñapaʼ atet̃ otanet: —Napaʼ nechencaʼye ñeñt̃ nerrar nepen ñeñt̃ña sapaʼ amacaʼye señoteñe. ");
INSERT INTO ameNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Pueyochreshaʼñapaʼ atet̃ otannaʼtyeset: —Amat̃eʼ eseshaʼ huapatoyeña puerrar. ");
INSERT INTO ameNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesúsñapaʼ alla oterraneterr: —Añcaʼyeña nerrar nepen oʼch nep̃a atet̃ muenen Nompor ñeñt̃ nellsenseneʼ, t̃arroʼmar ñeñt̃paʼ att̃ochña eʼñe netsotuoñ poʼtaruas. ");
INSERT INTO ameNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Amaʼt sotenoña sa: “Palltenmeñ paʼtatsm̃a arrorr oʼch eʼñe yaʼyapac̈haʼhua yenarem̃.” T̃eʼñapaʼ oʼch notas: T̃eʼpaʼ secueʼcaʼye aʼyo oʼch sentap shonteʼ acheñ ñeñt̃ onac̈hets, oʼcaʼye c̈hap allempoch ameʼñerrnet. T̃eʼ ñetpaʼ eʼñecaʼye atet̃ nentenanet ñerraʼm yenarem̃paʼ oʼ pomellaʼhuen oʼcaʼye c̈hap allempoch yapc̈haʼhue. ");
INSERT INTO ameNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ñeñt̃ apc̈hets nocop ñeñt̃paʼ atsaʼtaret̃tetchaʼ ñeñt̃chaʼña atarr coshaterrahuet. Ñam̃a allohuen ñeñt̃ ameʼñatenet ñetñapaʼ napanetchaʼ alloch eʼñe correrret t̃ayot̃eñ amaʼt errponañohuen. Ñeñt̃oʼmarña añ ñeñt̃ nareʼtets ñam̃a ñeñt̃ apc̈hets nocoppaʼ eʼñech parrocma coshapretannenet, amaʼt ñeñt̃ ñanom epatueʼ neñoñ ñam̃a ñeñt̃chaʼ t̃orratsa chentaʼ ñeñt̃ nocop. ");
INSERT INTO ameNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","T̃arroʼmar ñeñt̃paʼ eʼñe poʼñoc̈h atet̃ yepena ñeñt̃ atet̃ oten añ ñoñets ñeñt̃ c̈hocma yotannaʼtyena ya: “Puesheñarrpaʼ oʼch nareʼtatseʼtyes, poʼpsheñeññapaʼ ñeñt̃chaʼ apc̈haʼyesets.” ");
INSERT INTO ameNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ñam̃a sapaʼc̈hoʼña oʼch nemñas sam̃a oʼch sameʼñatera acheñeneshaʼ amaʼt ama sanmayeʼ ñanom t̃orratso all nocop, poʼpsheñeñña ñeñt̃ ñanom t̃orratseʼt̃ all. T̃arraña t̃eʼpaʼ sach ameʼñaterrahuet att̃och set̃orrapretera ñeñt̃ ñanom t̃orratseʼt̃ all nocop. T̃eʼpaʼ sach apc̈herrets all amaʼt ama sayeʼ nareʼtatseʼttseʼt̃e all. Amaʼt poʼpsheñeñ nareʼtatseʼttseʼt̃, t̃eʼñapaʼ sach taruasapreterrahuet all. ");
INSERT INTO ameNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Coyaneshaʼpaʼ eʼñe poʼñoñot̃a ameʼñatana pamoʼtseshaʼ samarioʼmarneshaʼ allempo serrpareʼtatuerranet att̃o Jesúspaʼ oʼ serrpareʼtatos ora allpon ñeñt̃ atet̃ puep̃aʼyesara. ");
INSERT INTO ameNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ñeñt̃oʼmarña samarioʼmarneshaʼ allempo huac̈haʼtet ñeshopaʼ atarr nanac aʼpatareʼtapet Jesús aʼposanetepaʼtoʼ all paʼnetsreto. Ñañapaʼ eʼñe epomta aʼposa all. ");
INSERT INTO ameNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Poʼpotantañec̈hnopaʼ shonteʼ ñeñt̃ ameʼñapaya att̃o serrpareʼtatosanet Jesús all paʼnetsreto. ");
INSERT INTO ameNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ñetñapaʼ atet̃ oteñet coyaneshaʼ: —T̃eʼñapaʼ ama eʼñe p̃a peñoñot̃eyeʼ yameʼñeno. T̃eʼpaʼ eʼñe ya eʼmueneʼ yam̃a allohueney. Ñeñt̃oʼmarña t̃eʼ yapaʼ oʼ yeñoch poʼñoc̈h ñapaʼ ñach yaʼqueshp̃aterreʼ allohueney ñeñt̃ey añe patsroʼtseney. ");
INSERT INTO ameNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Allempoña epomtaʼmuen Samario Jesúsñapaʼ oʼ alla ahuen Galileo all paʼney peñ ña. ");
INSERT INTO ameNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","T̃arroʼmar eʼñe poʼñoc̈h atet̃ eñorena Jesús ñocop, ñeñt̃paʼ atet̃ ot: Ñeñt̃ña aʼm̃teneʼ Yompor poʼñoñ paʼnyoʼmarneshaʼñapaʼ amaʼt mameshapaʼ ama mechaʼnaʼteñeto. ");
INSERT INTO ameNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Allempoña c̈herrerr Jesús Galileo allohuenña galileoʼmarneshaʼpaʼ eʼñe cohuen agapapueñet t̃arroʼmar ñetpaʼ eʼñe entuoñet allohuen ñeñt̃ atet̃ p̃aʼyesos Jerusaléño allempo entapretenetaʼ pascua all. Ñetpaʼc̈hoʼña allempopaʼ all ahuanmuet ñamet oʼch entapretenetaʼ pascua. ");
INSERT INTO ameNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesúsñapaʼ alla ahuerrerr poʼpocheño Cano eʼñe allara Galileo all eʼñe ñanem aʼpnasenanaʼ oñ vinos. Allñapaʼ alloʼtsen puesheñarr ñeñt̃ sherbeneʼ am̃chaʼtaret̃. Ñaña puechemerpaʼ c̈ha atsnaʼten all anetso Capernaumo. ");
INSERT INTO ameNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Allempoña eʼmareʼtan Jesús oʼ huapa Judeot̃ oʼ c̈henerr Galileo, ñañapaʼ allent̃a ahuoʼ oʼch enteñaʼ att̃och oteñaʼ cot̃erepaʼ paʼpacllo att̃och aʼcrraterrñañaʼ puechemer, oʼ rromamoch. ");
INSERT INTO ameNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesúsñapaʼ atet̃ och: —Ñerraʼm ama nentatasñe nepartsoña ñam̃a ñeñt̃ ama sentarepaʼ amat̃eʼ sameʼñennañe. ");
INSERT INTO ameNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ñeñt̃ña sherbeneʼ am̃chaʼtaret̃paʼ oʼ alla otererr: —Oʼch Ayochreshat̃e p̃oct̃erren t̃ayepaʼtñapaʼ ama rromuenaʼ nacñeʼt̃er. ");
INSERT INTO ameNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesúsñapaʼ atet̃ otererr: —T̃eʼpaʼ ahuerrep̃, pechemerpaʼ oʼcaʼye alla correrra. Yacmañapaʼ eʼñe ameʼñana Jesús poʼñoñ ñeñt̃ atet̃ och, ñañapaʼ allent̃a ahuerr. ");
INSERT INTO ameNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Allempoña ahuen t̃oñoñapaʼ poctenan pueñañreshaʼ. Ñetñapaʼ atet̃ otapueñet: —P̃acñeʼt̃erpaʼ oʼcaʼye correna. ");
INSERT INTO ameNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ñañapaʼ allent̃a otapanet: —¿Esempoʼtña pasateñ? Ñetñapaʼ atet̃ otereterr: —Ellerro allempo coyatseʼten atsneʼ mameʼpaʼ allempocaʼyeña metueñña poʼurateña. ");
INSERT INTO ameNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Allempoña pomporpaʼ oʼ yerepya ñañapaʼ atet̃ ot: —Ellerropaʼ allponcaʼyeña atsneʼ otenña Jesús nechemerpaʼ oʼcaʼye correrra. Ñapaʼ ñeñt̃ña ameʼñateʼ amaʼt ñam̃a allohuen pamoʼtseshaʼ ñeñt̃ parro paʼpaclloʼtsaʼyenet eʼñe ameʼñaʼhuet ñamet. ");
INSERT INTO ameNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Arrpaʼ att̃o puepocheño Jesúspaʼ entatanet poʼpartsoña allempo huapa Judeot̃ oʼ alla c̈herrerr Galileo. ");
INSERT INTO ameNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Allempoña oʼ alla c̈herrerr allempoch alla cosherrerr allohuen judioneshaʼ ñeñt̃ atet̃ anaret̃et ñocpuet. Jesúsñapaʼ alla ahuerrerr ñam̃a Jerusaléño. ");
INSERT INTO ameNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","All Jerusaléño eʼñe allameʼtets allot̃ecma aʼbeʼt̃eñet carrnero allñapaʼ alloʼtsen oñ apcoʼsat̃tataret̃ ñeñt̃ sochen hebreoneshaʼ poʼñoño Betesda. Ñeñt̃ñapaʼ eñall amnar puechaʼpetar. ");
INSERT INTO ameNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Allña puechaʼpetarot̃paʼ shonteʼ atsnañet̃neshaʼ ñeñt̃ penaʼrrartetsa all —ñeñt̃ aporoʼyet̃ec̈hno ñam̃a ñeñt̃ cheʼcaʼrepac̈hno ñam̃a ñeñt̃ echarretyetsa. Ñetñapaʼ añ cohuenet ñerraʼm esempoch pelleʼllchena oñ. ");
INSERT INTO ameNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","T̃arroʼmar ñerraʼm esempoch pelleʼllchena ñeñt̃ oñerpaʼ mellañot̃eñoʼch sohuetsa all oʼch pelleʼllchatosan oñ. Ñerraʼm eseshaʼ ñanom eshaʼtostsa all oño allempo pelleʼllchena ñeñt̃ña atsnañet̃erpaʼ acrrerrochayoʼch, amaʼt erraʼtsena atsnañtsor rromuenahuet. ");
INSERT INTO ameNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Allñapaʼ alloʼtsen puesheñarr yacma ñeñt̃ maʼpoch c̈harraʼ puechena posoc char atsnaʼten. ");
INSERT INTO ameNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Allempoña entos Jesús alla p̃anena ñañapaʼ eñotos shonteʼ char atsnaʼten ñeñt̃oʼmarña atet̃ otos: —¿Amaʼt pemno oʼch p̃ocrrerra? ");
INSERT INTO ameNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Atsnañet̃ñapaʼ atet̃ otan Jesús: —Amacaʼye Ayochreshat̃e eñalle ñeñt̃chaʼ neshaʼteʼ oño allempo pelleʼllchena. Napaʼ oʼch t̃aya ahuen poʼpsheñeññapaʼ ahuoʼtchaʼ eshaʼtosa ñanom. ");
INSERT INTO ameNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesúsñapaʼ atet̃ otererr: —T̃eʼpaʼ oʼch notosep̃: Petantena, pechtaʼnen allo pemuen, pechopeʼchen t̃ayecma. ");
INSERT INTO ameNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Yacmañapaʼ allorocmuepaʼtchaʼ correna, ñañapaʼ allent̃a chetenan allo muenpaʼ allent̃a chopeʼchnen. Ñehua, ñeñt̃ña yet̃ropaʼ allempo amesen judioneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ñeñt̃oʼmarña judioneshaʼpaʼ atet̃ ochet ñeñt̃ oʼ correrra: —T̃eʼ añe yet̃ro allempocma yamesen. Amacaʼye pocteyaye oʼch p̃anen pemueʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","T̃arraña ñapaʼ atet̃ otanet: —Ñeñt̃ oʼ aʼcrratosenpaʼ atet̃caʼ otosen: “Pechtaʼnen pemueʼpaʼ pechopeʼchnen.” ");
INSERT INTO ameNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ñetñapaʼ allent̃a aʼp̃t̃oʼchet: —¿Eseshaʼtña p̃otoseʼña, “Oʼch pechtaʼnen pemueʼpaʼ oʼch pechopeʼchen”? ");
INSERT INTO ameNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","T̃arraña ñeñt̃ aʼcrrataret̃terrtsapaʼ ama eñoteñe eseshaʼt̃eʼña aʼcrraterreʼ t̃arroʼmar Jesúspaʼ ama alloʼtsenaro, ñapaʼ oʼ ahuerr aʼnahua, t̃arroʼmar all shontosa acheñeneshaʼ ñeñt̃chaʼ entenayaʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Oʼña atarr oʼchetpaʼ Jesúsñapaʼ alla enterran ñeñt̃ aʼcrraterr ñorraʼ eʼñe alla Parets paʼpacllo. Allñapaʼ atet̃ oter: —T̃eʼpaʼ oʼ p̃ocrrerra. T̃eʼñapaʼ amach alla p̃oʼchñaʼtatsterrerro ñatoʼrraña alla nanac pemueroc̈hterrerr. ");
INSERT INTO ameNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Yacmañapaʼ oʼ ahuerr, atet̃ otuerran judioneshaʼ: —Jesúsepaʼtcaʼyeña ñeñt̃ naʼcrraterreʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Atet̃ pena Jesús añe yet̃ro allempo amesen judioneshaʼ ñeñt̃oʼmarña ñetpaʼ oʼpateñet Jesús. ");
INSERT INTO ameNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesúsñapaʼ atet̃ otanet: —Nompor eʼñe t̃emeʼttsen atarr t̃orrena ñeñt̃oʼmarña napaʼc̈hoʼña atarr nemneñ oʼch net̃orra nam̃a. ");
INSERT INTO ameNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ñeñt̃oʼmarña judioneshaʼ paʼm̃chaʼtaret̃erneshaʼpaʼ ello atarr nanac oʼpateñet oʼch muetset, t̃arroʼmar ñetpaʼ atet̃ otyeset: —Ñapaʼ ama ñapt̃ayeʼ añe yet̃er oʼ puesuerro allempocma yamesen, ñapaʼ añeʼnaña oten eʼñoʼ Pompor penan Parets, ñapaʼ att̃acaʼye mueneñ oʼch Partsocoptartena. ");
INSERT INTO ameNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesúsñapaʼ atet̃ oterraneterr: —Eʼñe poʼñoc̈h notenes, na ñeñt̃en Puechemer pen Yompor amat̃eʼ errot̃enot̃ es nep̃oña eʼñe not̃a. Napaʼ añña atet̃ nep̃aʼyen atet̃ nenteññañ Apa, t̃arroʼmar ñeñt̃ atet̃ pen Apapaʼ napaʼc̈hoʼña ñeñt̃en Puechemerenpaʼ atet̃chaʼ es nep̃aʼyen nam̃a. ");
INSERT INTO ameNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Apapaʼ atarr muerenna t̃arroʼmar napaʼ eʼñecaʼye poʼñoc̈h Puechemeren, ñeñt̃oʼmarña gatyenen ora allohuen ñeñt̃ atet̃ p̃aʼyen ña. Elloña ñapaʼ añ gatyenen ñeñt̃ nanac t̃orrapotyets ñeñt̃ atet̃ etsotayen ña; ñeñt̃paʼ añecop atet̃ pennan att̃oña sapaʼ atarrchaʼ secuanrrortenen. ");
INSERT INTO ameNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ñehua, yeñoteñ Apapaʼ tantaterran arromñat̃eneshaʼpaʼ apuerranet allochña ñetpaʼ corretsetach. Napaʼc̈hoʼña eʼñecaʼye atet̃ nepenaña nam̃a ñeñt̃en Puechemeren. Ñerraʼm erraʼtsenchaʼ nemnaʼ na oʼch napanet allochña ñetpaʼ corretsetach atet̃chaʼcaʼye napuerranet. ");
INSERT INTO ameNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Apapaʼ amaʼt puesheñarrapaʼ amach aʼmet̃am̃perraneto errot̃enchaʼ entyesuerranet. Naña apuen llesens ñeñt̃en Puechemeren nachña aʼmet̃am̃perrahuet errot̃enchaʼ nentyesuerranet eʼñe puesheñaʼttset. ");
INSERT INTO ameNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Allochñapaʼ att̃ochña allohuenet mechaʼnaʼtennetchaʼ nam̃a ñeñt̃en Puechemeren eʼñe atet̃ mechaʼnaʼtennanet Nompor Parets. Ñerraʼm eseshaʼ ama nem̃chaʼnaʼtenaye na ñeñt̃en Puechemeren, Nomporeʼnacaʼyeña ama mechaʼnaʼteneto ñeñt̃ nellsenseneʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Napaʼ eʼñe poʼñoc̈h atet̃ notenes: Ñerraʼm eseshaʼ eʼm̃ñoteʼ neñoñ ñam̃a ñerraʼm yemterrnanet Nompor ñeñt̃ nellsenseneʼ ñetñapaʼ corretsetach pocsheñeshocmañen t̃ayot̃eñ errponañohuen. Amach aʼcoñchataret̃terreto amaʼt errponaña. T̃arroʼmarña ñetpaʼ oʼ metanerretña ñeñt̃ eʼñe poʼñoc̈h rromueñets, oʼ c̈herret allña ñetpaʼ corretsetach t̃ayot̃en errponañohuen. ");
INSERT INTO ameNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Eʼñe poʼñoc̈h oʼch noterrserr: Oʼ c̈herrmoch allempoch atet̃ perra, ñeñt̃ arromñat̃eneshaʼpaʼ ñetñapaʼ eʼmuerrnanetchaʼ neñoñ ñeñt̃en Yompor Puechemeren. Ñeñt̃chaʼ eʼm̃ñoterreʼ na neñoñ ñetñapaʼ corretsetach. ");
INSERT INTO ameNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ñehua, Apapaʼ eʼñe ñot̃a correna, ña napueneʼña att̃och napaʼc̈hoʼña corretsanach nam̃a ñeñt̃en Puechemeren. ");
INSERT INTO ameNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ñam̃a ña napueneʼña llesens att̃och nemñe patantaʼtets acheñeneshaʼ coñcheñtso, poʼpotantaññapaʼ amach nemñerraneto coñcheñtso. Atet̃caʼye allsensaret̃enña na Ñeñt̃en eʼñe Acheñetosets. ");
INSERT INTO ameNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ñeñt̃ atet̃ oʼ notuaspaʼ amach c̈ha semoññeʼtatsche t̃arroʼmar esempopaʼ c̈herrchaʼ amaʼt ñeñt̃ puepamproʼtsaʼyenpaʼ eʼmuerrnanetchaʼ neñoñ. ");
INSERT INTO ameNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","C̈haʼnmac̈herretchaʼ allot̃ apamparet̃teteʼt̃. Ñeñt̃ atet̃ p̃aʼyesayeʼt̃ eʼñe cohuen ñeñt̃ poctetsa ñetñapaʼ añecopchaʼ tanterret att̃och ello alla correrret. Ñeñt̃ña p̃aʼyesayeʼt̃ ñeñt̃ ama pocteyaye ñetñapaʼ añecpach tanterret att̃och ello alla amñaret̃terret coñcheñtso. ");
INSERT INTO ameNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Amat̃eʼ errot̃enot̃ es nep̃aʼyesoña eʼñe not̃a. Atet̃ eñotatenen Nomporpaʼ att̃ochña nemñe patantaʼtets acheñeneshaʼ coñcheñtso, poʼpotantaññapaʼ amach. Ñam̃a errot̃enchaʼ nentyesuerranetpaʼ ñeñt̃paʼ eʼñe pocteʼ t̃arroʼmar ama eʼñe na nemnenñot̃eyeʼ es nep̃aʼyeno. Nomporña puemnenñot̃ es nep̃aʼyen t̃arroʼmar ña nellsenseneʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ñerraʼm eʼñe nañeña aʼpot̃etsa, ñeñt̃ att̃o naʼpot̃enapaʼ amat̃eʼ es sherbeno. ");
INSERT INTO ameNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Eñallña poʼpsheñeñ ñeñt̃ eʼñe no Nompor ñeñt̃ña naʼpot̃eneʼña na. Ñam̃a neñoteñ ñerraʼm ña naʼpot̃eʼpaʼ ñeñt̃ att̃o aʼpot̃enen ñeñt̃ña eʼñe poʼñoc̈h sherbets. ");
INSERT INTO ameNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ñam̃a sa ahuañmoʼchapaʼ semñe acheñ Juanesho ñeñt̃ aʼp̃t̃oʼtoseʼ nocop. Juanña att̃o aʼpot̃anpaʼ ñeñt̃ña eʼñe poʼñoc̈h atet̃. ");
INSERT INTO ameNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Napaʼ ama eʼñe nocpa neʼneno ñeñt̃ naʼpot̃eʼ; añecpaʼnaña notenes sa ñatoʼ sapaʼ sameʼñoñat̃eʼ Juan poʼñoñ att̃o aʼpot̃an na, allochñapaʼ att̃och sequeshperra sameʼñeñot̃en. ");
INSERT INTO ameNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juanpaʼ eʼñe atet̃ peʼt̃ ñerraʼmrrat̃eʼ lampareñ corretsa, att̃oña c̈hoyoʼteʼt̃. Sañapaʼ sa muenatseʼt̃ oʼch socshameʼta mameʼ all aʼpuetarsam̃p̃sas. ");
INSERT INTO ameNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","T̃arraña atet̃ naʼpot̃en napaʼ ñeñt̃ña nanac sherbets. Ello metanenan ñeñt̃ atet̃ aʼpot̃an na Juan. Allohuen es nep̃aʼyen ñeñt̃ atet̃ yechenna Apa oʼch eʼñe netsotoñ, añ netsotateñpaʼ ñeñt̃ña oʼ eñotatanet napaʼ Apa nellsenseneʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ñam̃a Apa ñeñt̃ nellsenseneʼ ñapaʼc̈hoʼña ñacaʼyeña naʼpot̃eneʼ. Sapaʼ amaʼt ahuat̃apaʼ ama seʼmaroñeña poʼñoñ atet̃ eʼmorrtena, ñam̃a ama sentareña atet̃ orrtena ña. ");
INSERT INTO ameNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Sapaʼ amaʼt poʼñoñapaʼ ama c̈hennasoña seyoc̈hro t̃arroʼmar na ñeñt̃en llesensen Apa, sañapaʼ ama sameʼñenno. ");
INSERT INTO ameNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Sapaʼ añchaʼ set̃orraʼyesa Yompor poʼñoñ ñeñt̃ atet̃ anuaret̃ ahuat̃ot̃eñ t̃arroʼmar sapaʼ c̈hat̃eʼ sotenapañ eʼñe ñoñtsochayot̃apaʼ sapaʼ corretsasat̃eʼ errponohuañen. T̃arraña Yompor poʼñoñ ñeñt̃ anuaret̃ ahuat̃ot̃eñ ñeñt̃paʼ nacaʼyeña aʼpot̃eʼt̃. ");
INSERT INTO ameNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Sañapaʼ amaña semnoña oʼch sameʼñerrna att̃ochña eʼñe socrrerrañ. ");
INSERT INTO ameNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’T̃arraña napaʼ ama añeyeʼ neʼneno att̃och ayeʼchoc̈htatennan acheñeneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","T̃arroʼmar napaʼ neñotenes sapaʼ amaʼt mameshapaʼ ama semorrenteño Yompor amaʼt seyoc̈hra. ");
INSERT INTO ameNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Napaʼ att̃o nohuapa Nomporña nellsenseneʼ t̃arraña sapaʼ amaña sameʼñenno. Ñerraʼm eseshaʼchña huapatsañ ñeñt̃ eʼñe ñot̃a huena saña ñeñt̃paʼ atarrt̃eʼ sameʼñyañ. ");
INSERT INTO ameNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Sapaʼ t̃arroʼmarña ama sameʼñenno sapaʼ añacaʼye seʼnen oʼch eʼñe sañeña ayeʼchoc̈htatannetsa, amacaʼyeña añeyeʼña seʼneno att̃och eʼñe cohuen entas ñapuet̃ Yompor. ");
INSERT INTO ameNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Amach soct̃apeʼchatsche ñatoʼ nach sotteñeʼcherreʼ esempohuañen Apuesho. T̃arraña eñallcaʼyeña poʼpsheñeñ ñeñt̃chaʼ sotteñeʼcherreʼ ñeñt̃paʼ añcaʼye Moisés, sañapaʼ ñeñt̃aña atarr nanac seyemtena. ");
INSERT INTO ameNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ñerraʼm poʼñoc̈h sameʼñeñañ Moiséspaʼ napaʼc̈hoʼña sameʼñennañchaʼ t̃arroʼmar ñapaʼ nocopcaʼye quellconas. ");
INSERT INTO ameNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","T̃arraña ñerraʼm ama sameʼñeññaño ñeñt̃ atet̃ quellconaseʼt̃ ña, ñeñt̃oʼmarña napaʼc̈hoʼña amach errot̃enot̃ sameʼñonoña nam̃a neñoñ. ");
INSERT INTO ameNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Allempoña Jesúspaʼ ahuoʼ yom̃taʼn saʼp Galileaso, ñeñt̃ara saʼp otenet Tiberias. ");
INSERT INTO ameNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Allñapaʼ cot̃aʼneñ shonteʼ acheñeneshaʼ t̃arroʼmar ñetpaʼ oʼ entuoñet poʼpartsoña att̃o aʼcrratyerran allohuen ñeñt̃ atsnaʼtyets. ");
INSERT INTO ameNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Oʼña c̈hap yom̃taʼn Jesúsñapaʼ ahuos aspent̃o, allña anorros epuet pueyochreshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Allempopaʼ oʼ c̈hapmoch pascuapo allempoch alla cosherrerr judioneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesúsña cohuatsa aʼyopaʼ entapan shonteʼ acheñeneshaʼ ñeñt̃ onac̈hets ñeshonet̃. Allempoñapaʼ atet̃ otan Felipe: —Errahuachcaʼ yerañt̃aña pant̃eʼ ñeñt̃chaʼ rros acheñeneshaʼ ñeñt̃ oʼ huac̈haʼta. ");
INSERT INTO ameNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ñehua, Jesúspaʼ eʼñe poʼtomña atet̃ ot t̃arroʼmar ñapaʼ eñoteñ atet̃chaʼ p̃a. ");
INSERT INTO ameNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipeñapaʼ atet̃ och: —Amaʼt epoch c̈harroch c̈harraʼ denario alloch yerañt̃a panpaʼ amaʼt pueshmetat̃ollapaʼ amat̃eʼ rraʼyeseto. ");
INSERT INTO ameNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Pueyochreshaʼña Andrés ñeñt̃ paʼmoʼnasheñ Simóm Pedropaʼ ñañapaʼ atet̃ och: ");
INSERT INTO ameNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Arr puesheñarr huepueshachorpaʼ echenancaʼye amnar pan ñeñt̃ cebada ñam̃a epa cac. Att̃apaʼ amat̃eʼ yepataneto, acheñpaʼ shonteʼcaʼye. ");
INSERT INTO ameNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesúsñapaʼ atet̃ otanet: —T̃eʼpaʼ sotanet anorrc̈haʼtetepaʼ. Ñehua, allpaʼ eʼñe cohuen emmoʼraten pasetmaʼ. Ñetñapaʼ anorrchaʼtet. Yacmaneshaʼpaʼ ñatoʼ amnarocht̃eʼ mil eñall. ");
INSERT INTO ameNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesúsñapaʼ chetan panpaʼ parasyosoʼtam̃pes, allempoñapaʼ apan pueyochreshaʼ. Pueyochreshaʼñapaʼ epatyeset allohuen acheñeneshaʼ ñeñt̃ anorrc̈hets all. Att̃ecma p̃a allempo apaʼyesanet ñam̃a cac. Allohuenetpaʼ eʼñe agaphuahuet ñeñt̃ allpon muenaʼyeset. ");
INSERT INTO ameNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Allempoña oʼ rrallmeʼchuetpaʼ allohuenetpaʼ eʼñepaʼtchaʼ yetrraʼtuahuet. Eʼñe yetuahuetpaʼ Jesúsñapaʼ atet̃ oterranerr pueyochreshaʼ: —T̃eʼpaʼ oʼch saʼyapac̈herr ñeñt̃ shotnaʼtyets ñeñt̃ saʼpchatyes allochñapaʼ amach es pertatso. ");
INSERT INTO ameNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Allempoña aʼyapac̈herret ñeñt̃ shotaʼtatyeset c̈hepaʼtchaʼ chorrats c̈harraʼ puechena epa cañt̃er ñeñt̃ aʼpchatet all rratanet amnar pan cebada. ");
INSERT INTO ameNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Att̃o orrtatanet poʼpartsoña acheñeneshaʼñapaʼ atet̃ otyeset: —Añña poʼñoc̈hpaʼ ñeñt̃caʼye aʼm̃teneʼ Yompor poʼñoñ ñeñt̃ atarr yecuen oʼch huapa añe patsro. ");
INSERT INTO ameNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesúsñapaʼ eñotanet ñetpaʼ añ muenenet oʼch huapoñetpaʼ oʼch rromoset oʼch noset ñeñt̃chaʼ paʼm̃chaʼtaret̃er pet. Ñeñt̃oʼmarña Jesúspaʼ aʼnahua ahuerr all aspent̃o eʼñe ñapuet̃. ");
INSERT INTO ameNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Allempoña ellerren pueyochreneshaʼñapaʼ ahuanerret saʼpatop̃ño. ");
INSERT INTO ameNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Aʼtac̈haʼtuerret poʼnoñt̃opaʼ oʼch ahuam̃perret yom̃taʼn, Capernaumonet̃. Allñapaʼ alla checmetam̃p̃set. Jesúsñapaʼ ama huerraʼ all alloʼtsaʼyenet. ");
INSERT INTO ameNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Allñapaʼ orrnotam̃pesnomuet, saʼpñapaʼ c̈ha emoʼyarerta. ");
INSERT INTO ameNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ñetñapaʼ echotnomuet saʼp amnar amapaʼ pechapt̃eʼ kilómetro allñapaʼ machayot̃epaʼtchaʼ entapet Jesús chopeʼchnen enot̃ oño. Oʼ allameʼttsam̃a p̃an noñt̃. Ñetñapaʼ c̈hepaʼtchaʼ mechaʼtapet. ");
INSERT INTO ameNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","T̃arraña ñapaʼ atet̃ otosanet: —Nacaʼye oʼ nohuapa, amach att̃a sem̃chaʼtatstapno. ");
INSERT INTO ameNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ñetñapaʼ mueneñetañ oʼch agapapet noñt̃ot̃, eñotostsetpaʼ oʼ c̈hapña noñt̃ yom̃taʼn all sechenet. ");
INSERT INTO ameNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tsapat̃ña acheñeneshaʼ ñeñt̃ alla aʼpatsa yom̃taʼn ñetpaʼ eñoteñet eʼñe pat̃rra noñt̃ allo aʼtac̈haʼt Jesús pueyochreshaʼ ñam̃a Jesúspaʼ enteñet amacaʼ aʼtapo noñt̃o epuet pueyochreshaʼ eʼñe ñapt̃ochayeta ahuanmuet. ");
INSERT INTO ameNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","T̃arraña noñt̃ec̈hnoñapaʼ c̈hocma huac̈hena Tiberiasot̃, oʼ c̈hapuet allameʼtets all rret ellerro pan ñeñt̃ parasyosoʼtam̃pes Partseshaʼ Jesús. ");
INSERT INTO ameNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Allempoña acheñeneshaʼ ñeñt̃ alloʼtsen ñetñapaʼ oʼhuañ eñchet Jesús pueyochreshohuen. Ñetpaʼc̈hoʼña allent̃a aʼtac̈haʼtet ñamet noñt̃o, ahuam̃p̃set Capernaumonet̃, oʼch eʼneretaʼ Jesús. ");
INSERT INTO ameNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Allempoña entoset yom̃taʼnpaʼ atet̃ otoset: —Maestro, ¿esempoʼtña pec̈herrña p̃a arrma? ");
INSERT INTO ameNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesúsñapaʼ atet̃ otapanet: —Na poʼñoc̈hpaʼ oʼch notapas, sapaʼ amacaʼye añecpayeʼ seʼnenno att̃o oʼ norrtatonas nepartsoña. Sapaʼ añecpacaʼyeña seʼnenen att̃o oʼ nerratuas pan oʼ eʼñe seyetua. ");
INSERT INTO ameNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","T̃eʼpaʼ oʼch notas, sapaʼ amach aña semaʼyoc̈hratsto yocrram̃ ñeñt̃ eʼnuapoʼ. Añchaʼña semaʼyoc̈hra socrram̃ ñeñt̃ ama eʼnuapahuoyaye; ñeñt̃ña alloch sapaʼ corretsasach socsheñeshocmañen eʼñe t̃ayot̃eñ amaʼt errponañohuen. Ñeñt̃ña socrram̃paʼ nach sapuerreʼ Ñeñt̃en Acheñetosets t̃arroʼmar Apapaʼ oʼ llesenserren na Ñeñt̃en Acheñetosets arr patsro. ");
INSERT INTO ameNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Acheñeneshaʼñapaʼ atet̃ otereterr: —Errot̃enuachcaʼ yep̃aña ñeñt̃ cohuen enten Yompor. ");
INSERT INTO ameNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesúsñapaʼ atet̃ oterraneterr: —Ñeñt̃ cohuen enten Yomporpaʼ oʼch sameʼñaʼna na ñeñt̃en llesensen. ");
INSERT INTO ameNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ñetñapaʼ atet̃ otereterr: —Errot̃enot̃uachcaʼ pegateyña pepartsoña ñeñt̃chaʼ yentpaʼ att̃ot̃chaʼ yameʼñap̃a. P̃apaʼ esuañacaʼ petsoten. ");
INSERT INTO ameNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ya yatañneshañpaʼ rraʼyeseteʼt̃ ñeñt̃ maná all amayo atet̃caʼye anuaret̃ Yompor poʼñoñ ahuat̃ot̃eñ: “Rratyesaneteʼt̃ pan ñeñt̃ apaneteʼt̃ Yompor pueʼntañot̃.” ");
INSERT INTO ameNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesúsñapaʼ alla oterraneterr: —Eʼñe poʼñoc̈h oʼch notas: Ama Moisésoyeʼ apahueteʼt̃eña pan ñeñt̃ huetsa entot̃. Nacaʼye Nompor sapueneʼña ñeñt̃ eʼñe poʼñoc̈h socrram̃ sepen. Añ socrram̃paʼ entot̃ña huena. ");
INSERT INTO ameNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Naña socrram̃ sepen ñeñt̃en oʼ apuerres Nompor, napaʼc̈hoʼña entot̃ nohuapa Yomporeshot̃ allochñapaʼ acheñeneshaʼña arr patsropaʼ ñetñapaʼ corretsetach. ");
INSERT INTO ameNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ñetñapaʼ atet̃ otereterr: —Ayochreshat̃e yapaʼc̈hoʼña c̈hocmach p̃apuey ñeñt̃ corramets. ");
INSERT INTO ameNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesúsñapaʼ alla oterraneterr: —Napaʼ na corram̃tsotets alloch eʼñe socrra. Eseshaʼch huapatsa nesho ñetña amaʼt ahuat̃apaʼ amach alla cheporrerreteʼt̃e. Eseshaʼch nameʼñerraya na ñetña amaʼt ahuat̃apaʼ amach alla oñpaʼterreteʼt̃e. Ñehua, ñeñt̃paʼ añ notenes, eseshaʼch nameʼñerraya na ñetñapaʼ c̈hocmach eʼñe cosherret pueyoc̈hreto, amaʼt ahuat̃apaʼ amach alla es eʼnerreteʼt̃e. ");
INSERT INTO ameNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","T̃arraña napaʼ oʼ notuas: Sapaʼ oʼ sentnoñ amaña sameʼñenno. ");
INSERT INTO ameNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Allohuen acheñeneshaʼ ñeñt̃ oʼpatatenna Apapaʼ ñetñapaʼ ameʼñerrnetchaʼ. Eseshaʼch nameʼñerraya ñetñapaʼ amach alla nehuaporeʼterraneto. ");
INSERT INTO ameNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","T̃arroʼmar napaʼ ama añecpayeʼ nohuapoña entot̃ att̃och oʼch aña atet̃ nep̃os ñeñt̃ nemnen na. Napaʼ añecopña nohuapa oʼch atet̃ neperr ñeñt̃ atet̃ muenen Nompor ñeñt̃ nellsenserreʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ñeñt̃paʼ atet̃ muenen Nompor ñeñt̃ nellsenserreʼ: Amachña c̈ha naʼchencatereña acheñeneshaʼ ñeñt̃ ora allpon oʼpatatenna na, c̈hochña ello netantaterrñañ esempohuañen. ");
INSERT INTO ameNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Añmapaʼ ñeñt̃ña muenen Nompor: Erraʼtsenchaʼ neñoterreʼ ñerraʼm ameʼñerrnetchaʼ na ñeñt̃en Yompor Puechemeren, ñetñapaʼ corretsetach pocsheñeshocmañen t̃ayot̃eñ amaʼt errponañohuen. Ñetñapaʼ c̈hocmach netantaterranet esempohuañen. ");
INSERT INTO ameNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Att̃o Jesúspaʼ otenanet, “Napaʼ na corram̃tsotets ñeñt̃en huapatsa entot̃”, judioneshaʼñapaʼ pocuanaʼteñot̃et otatseʼtyeñet. ");
INSERT INTO ameNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ñeñt̃paʼ atet̃ otyeset: —Añmapaʼ añacaʼye Jesús, José puechemer, ñeñt̃ pompor ñam̃a pachor eʼñecaʼye yechmeʼteñ. T̃eʼñapaʼ esoʼmareʼtña oten ñapaʼ entot̃oʼ huapa. ");
INSERT INTO ameNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesúsñapaʼ atet̃ otanet: —Sapaʼ amach att̃a sotatseʼtannaʼtyesatsto. ");
INSERT INTO ameNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Amaʼt eseshapaʼ amach errot̃enot̃ ameʼñerrneto ñerraʼm Nompor ñeñt̃ nellsenseneʼ ñerraʼm ña ama cot̃apeʼchaterrahueto cohuen. Ñetñapaʼ netantaterranetchaʼ esempohuañen. ");
INSERT INTO ameNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Atet̃ quellquëʼt̃ ñeñt̃ aʼm̃tayeʼt̃ Yompor poʼñoñ ahuat̃, poʼquellcopaʼ atet̃ anuaret̃: “Allohuenetpaʼ Yomporchaʼña eñotaterrahuet.” Allohuen ñeñt̃chaʼ eʼm̃ñoterreʼ Nompor att̃och cohuen cot̃apeʼchaterranet, ñetñapaʼ nachña ameʼñerret. ");
INSERT INTO ameNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Amaʼt eseshapaʼ ama puentareto Apa. Napt̃aña na ñeñt̃en huapatsa Yomporeshot̃ nentarcaʼyeña Apa. ");
INSERT INTO ameNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Eʼñe poʼñoc̈h notenes: Eseshaʼch nameʼñerraya ñetñapaʼ corretsetach pocsheñeshocmañen t̃ayot̃eñ eʼñe errponañohuen. ");
INSERT INTO ameNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Napaʼ na corram̃tsotets alloch eʼñe socrra. ");
INSERT INTO ameNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Satañneshañpaʼ amaʼt rraʼyeseteʼt̃ ñeñt̃ maná all amayo, ñetñapaʼ oʼ collaʼhuenet. ");
INSERT INTO ameNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","T̃arraña ñeñt̃en soteneʼ t̃eʼ ñeñt̃ña eʼñe poʼñoc̈h socrram̃ ñeñt̃en huapatsa entot̃ allochñapaʼ eseshaʼch rreʼpaʼ ñetñapaʼ corretsetach t̃ayot̃eñ eʼñe errponañohuen. ");
INSERT INTO ameNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Eʼñe poʼñoc̈h napaʼ na ñeñt̃en corram̃tsotets alloch eʼñe socrra ñeñt̃en huapatsa entot̃. Ñerraʼm eseshaʼ rreʼ añ corrametspaʼ ñetñapaʼ corretsetach t̃ayot̃eñ eʼñe errponañohuen. Añ corramets ñeñt̃chaʼ nepomuerr na acheñeneshacop arr patsro alloch eʼñe correnet, ñeñt̃paʼ añcaʼye nechets. ");
INSERT INTO ameNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Judioneshaʼñapaʼ ñeñt̃oʼmarac̈hoʼ es otannaʼtyeset. Ñetñapaʼ atet̃ otyeset: —Errot̃enot̃uachñacaʼ apueyña eʼñe ña poʼchets ñeñt̃chaʼ yerraʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesúsñapaʼ alla oterraneterr: —Poʼñoc̈h oʼch notas, ñerraʼm ama serrerrnano nechets Ñeñt̃en Acheñetosets, ñerraʼm ama sorrerrnano ñam̃a nerras, sapaʼ amat̃eʼ errot̃enot̃ socrroña sa. ");
INSERT INTO ameNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ñerraʼm eseshaʼ rreneʼ nechets ñam̃a ñerraʼm orrennanet nerras, ñetñapaʼ corretsetach t̃ayot̃en eʼñe errponañohuen, t̃arroʼmar nañapaʼ netantaterranetchaʼ esempohuañen. ");
INSERT INTO ameNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","T̃arroʼmar nechets ñeñt̃ eʼñe poʼñoc̈h corram̃tsotets; ñerraspaʼc̈hoʼña ñeñt̃ eʼñe poʼñoc̈h orrpapoʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ñeñt̃chaʼ rreneʼ nechets ñam̃a ñerraʼm orrennanet nerras ñetñapaʼ eʼñech parrocmatennet na, napaʼc̈hoʼña eʼñech neparrocmatenanet ñet. ");
INSERT INTO ameNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Apa ñeñt̃ nellsenseneʼ ñapaʼ ama arromñat̃eshayaye, ñacaʼyeña napueneʼña att̃o napaʼc̈hoʼña corretsanach. Atet̃ nepena nam̃a, allohuen ñeñt̃ pocrram̃ nepeneʼ napaʼc̈hoʼña añ napuenanet att̃och ñetpaʼc̈hoʼña corretsetach ñamet. ");
INSERT INTO ameNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Na ñeñt̃en socrram̃ sepen ñeñt̃en huapatsa entot̃. Ama att̃eyayno ñerraʼmrrat̃eʼ pan ñeñt̃ rreʼt̃ satañneshañ ahuat̃. Ñetpaʼ oʼ collaʼhuenet. Eseshaʼch eʼñe pocrram̃ nepeneʼ ñetñapaʼ corretsetach t̃ayot̃eñ eʼñe errponañohuen. ");
INSERT INTO ameNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Arrpaʼ allohua ñeñt̃ atet̃ yec̈hatenan acheñeneshaʼ judioneshaʼ poʼprahuo all Capernaumo. ");
INSERT INTO ameNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Allempoña atet̃ eʼmueñet atet̃ oten, shonteʼ pueyochreshac̈hnopaʼ atet̃ otyeset: —Añ ñoñetspaʼ amacaʼye eʼñeyeʼ pocteyaye, amat̃eʼ eseshaʼ ameʼñayo. ");
INSERT INTO ameNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesúspaʼ eʼñe pueyoc̈hro eñotanet c̈ha otatseʼtyen pueyochreshac̈hno, ñeñt̃oʼmarña atet̃ oterraneterr: —Ñeñt̃ atet̃ notenespaʼ areʼt pocteyeʼ senteñe. ");
INSERT INTO ameNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Taʼm, ¿errot̃enaʼtchaʼ sotña ñerraʼm poʼñoc̈h sentennoñ na Ñeñt̃en Acheñetsosets oʼch alla naʼterreñ ento allot̃ nohuapa ahuat̃? ");
INSERT INTO ameNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yecamquëñ alloña eʼñe poʼñoc̈h yocrrena. Yechetspaʼ amaʼt coñeʼt̃apaʼ ama sherbeno. Neñoñ ñeñt̃ neserrpareʼtatenespaʼ eʼñe poʼñoc̈h secamquëñecop ñeñt̃ña poʼñoc̈h alloch eʼñe socrra. ");
INSERT INTO ameNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","T̃arraña pantantaʼttsospaʼ amaña sameʼñenno. Ñehua, Jesúspaʼ eʼñe allempot̃eñ eñotenan ñeñt̃chaʼ ama ameʼñerrtso. Eʼñe eñotenan ñam̃a ñeñt̃chaʼ pomuerreʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jesúspaʼ alla oterraneterr: —Ñeñt̃oʼmarña napaʼ notaseʼt̃, amach eseshaʼ nameʼñerrayo ñerraʼm ama Apa cot̃apeʼchaterrahueto att̃och cot̃errnet. ");
INSERT INTO ameNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Allempot̃eñña shonteʼ Jesús pueyochreshac̈hno puerrac̈herret ñeshot̃paʼ oʼhuañ chopeñeʼchenet parro. ");
INSERT INTO ameNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Allempoña Jesúspaʼ atet̃ otan pueyochreshaʼ ñeñt̃ c̈harrasheña puechena epa: —Sapaʼc̈hoʼ ¿semneñeʼt oʼch sepuerrerra sam̃a? ");
INSERT INTO ameNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedroñapaʼ atet̃ och: —Partseshachaʼ, eseshaʼhuat̃eʼñacaʼye yoct̃aʼ. P̃apt̃acaʼye pechenña ñoñets att̃ochña yapaʼ corretsayach t̃ayot̃eñ errponañohuen. ");
INSERT INTO ameNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Yapaʼ oʼcaʼye yameʼñap̃a. Yapaʼ yeñotenep̃ p̃apaʼ pepaʼtcaʼye Cristotets, ñeñt̃ep̃ Yompor Puechemerep̃. ");
INSERT INTO ameNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesúsña atet̃ otanet: —Napaʼ nacaʼyeña saʼcrerreʼña sa, c̈harrasheñas sepchena epa. Ñeñt̃ña puesheñarrpaʼ ñeñt̃paʼ oneñet̃enaʼtar. ");
INSERT INTO ameNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ñehua, Judasocop atet̃ eñora. Ñeñt̃ Judaspaʼ ñeñt̃ Simón Iscariote puechemer. Amaʼt ñeñt̃ aʼpchenahuetañ epa pueyochreshaʼ, puesheñarrpaʼ ñeñt̃chaʼ pomuerreʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Allempoña Jesúspaʼ alla chopeñeʼchyen eʼñe alla Galileoʼmar. Ama mueno oʼch chopeñeʼchen ñam̃a all Judeoʼmar t̃arroʼmar judioneshaʼpaʼ c̈ha oʼpateñet oʼch muetset. ");
INSERT INTO ameNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Allempopaʼ oʼ c̈herrmocherr allempoch cosherrerr judioneshaʼ; ñeñt̃chaʼ cosherreterr añ paʼsoʼcheñ Manatpuetsopoʼ, ñeñt̃ atet̃ yec̈henet ñet. ");
INSERT INTO ameNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Allempoña Jesúspaʼ atet̃ och paʼmoʼnasheñneshaʼ: —T̃eʼpaʼ orrerrep̃ arrot̃, ahuerrep̃ alla Judeo allochñapaʼ peyochreneshac̈hno ñeñt̃ alloʼtsaʼyen oʼch p̃orrtatuerranet ñamet pepartsoña ñeñt̃ atet̃ pep̃aʼyena t̃eʼ arrma. ");
INSERT INTO ameNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ñehua, ñerraʼm yemneñ oʼch yorrta allohuenacoppaʼ amaʼt puesheñarrot̃eyapaʼ amachña aʼnahua es yep̃aʼyeno. Ñerraʼm poʼñoc̈h p̃orrtatyen pepartsoña arrpaʼ p̃orrtachñacaʼye ñam̃a allohuen acheñeneshacop añ patsro. ");
INSERT INTO ameNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Amaʼt paʼmoʼnasheñneshaʼpaʼc̈hoʼña t̃arroʼmar atet̃ ochet ñetpaʼc̈hoʼña amacaʼye ameʼñeñeto. ");
INSERT INTO ameNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesúsñapaʼ atet̃ otanet: —Allempo ñeñt̃ poctetsa nocop oʼch norrta allohuenacoppaʼ amacaʼye eʼñeyeʼ c̈henaʼ. T̃arraña socoppaʼ eʼñecaʼye pocteʼ c̈hocmacaʼye eñall. ");
INSERT INTO ameNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","T̃arroʼmar acheñeneshaʼña añ patsropaʼ amachcaʼye errot̃enot̃ eʼmoñeʼtasoña sa, t̃arraña napaʼ c̈hocma eʼmoñeʼtyennet t̃arroʼmar napaʼ añcaʼye neñotatyenanet ñeñt̃ atet̃ p̃atseʼtyenet ñeñt̃ ama pocteyaye. ");
INSERT INTO ameNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Sapaʼ orras socshapretenaʼ. Napaʼ eʼñe t̃ayecmapaʼ amachcaʼye neto coshapretatsa. T̃arroʼmar nocoppaʼ ama eʼñeyeʼ c̈henaʼ allempoch eʼñe poctaʼhuona. ");
INSERT INTO ameNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Atet̃ otuanetpaʼ ñapaʼ alla aʼpa mameʼ Galileo. ");
INSERT INTO ameNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Allempoña paʼmoʼnasheñec̈hnopaʼ ñetñapaʼ ahuanmuet coshapretatset. Oʼña tama oʼchetpaʼ ahuoʼ ñam̃a, t̃arraña ñapaʼ ama orrtenaneto, aʼnahua cot̃aʼnenanet chentaʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Judioneshaʼña all coshenetpaʼ ñetñapaʼ eʼneñet atet̃ otyenet: —Taʼmcaʼye ¿erroʼtsent̃eʼña Jesús? ");
INSERT INTO ameNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Allña acheñeneshaʼpaʼ shonteʼ eñosyenet ñocop. Patantaʼtetspaʼ atet̃ otyenet: “Ñapaʼ eʼñe cohuen acheñer”; poʼpotantañec̈hnopaʼ atet̃ otyenet: “Amacaʼye cohuenayaye, att̃acaʼye shecareʼtyenan acheñeneshaʼ.” ");
INSERT INTO ameNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ñetpaʼ atarr mechaʼteñet judioneshaʼ ñeñt̃oʼmarña aʼnahua atet̃ otannaʼtyenet. ");
INSERT INTO ameNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Oʼña patmaʼnma att̃o coshenet Jesúsñapaʼ beʼt̃osos Parets paʼpacllo, yec̈hatosanet all. ");
INSERT INTO ameNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Allñapaʼ epayeʼ cohuanrrorech judioneshaʼ. Ñetñapaʼ atet̃ otyeset: —Taʼ, errot̃ent̃eʼcaʼyeña añ, amaʼt ama ayc̈hataret̃e quellecpaʼ atarrepaʼt es eñotyen. ");
INSERT INTO ameNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesúsñapaʼ otanet: —Ñeñt̃ att̃o neyc̈hatyenes ñeñt̃paʼ amacaʼye noyaye noct̃ap̃ña, ñeñt̃paʼ Yomporoña poct̃ap̃ña ñeñt̃ nellsenseneʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ñerraʼm eseshaʼña mueneʼ oʼch atet̃ pet ñeñt̃ muenen Yompor ñetñapaʼ eñochetchaʼ neyc̈hateñpaʼ Yomporo amacaʼye not̃ayeʼ neñeno. ");
INSERT INTO ameNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ñerraʼm eseshaʼ eʼñe ñot̃ot̃a eñenpaʼ ñetñapaʼ añach eʼnenet oʼch cohuentateññañ acheñeneshaʼ eʼñe ñocop. Añña ñerraʼm eseshaʼ eʼneneʼ oʼch cohuentatenan ñeñt̃ llesenseneʼ ñapaʼ ñeñt̃ña eñetsña ñoñtso eʼñe poʼñoc̈h ama shequëñtsoyaye. ");
INSERT INTO ameNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Amaʼt apasoña Moisés ñoñets ñeñt̃ atet̃ anaret̃. T̃arraña amaʼt apaseñ, sañapaʼ amaʼt eʼñe puesheñarrot̃esapaʼ ama sep̃ohuenoña ñeñt̃ atet̃ oten añ ñoñets, ñeñt̃epñapaʼ esoʼmareʼtña t̃eʼpaʼ semneñña oʼch semtsan. ");
INSERT INTO ameNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Acheñeneshaʼñapaʼ atet̃ otereterr: —P̃apaʼ c̈hat̃eʼ chorrenp̃a oneñet̃. Amarramcheʼ eseshaʼ p̃oʼpatenayeña oʼch muetsapet. ");
INSERT INTO ameNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesúsñapaʼ alla oterraneterr: —Napaʼ amaʼt parrocha norrtatonas nepartsoña añ yet̃ro allempo yamesen saña allempopaʼ atarr secuanrroretnoñ t̃arraña sañapaʼ ama pocteyeʼ senteñe. ");
INSERT INTO ameNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moiséspaʼ apaʼnmas ñeñt̃chaʼ seyc̈haʼ att̃och setsorrannena. Ñehua, poʼñoc̈h ñeñt̃paʼ ama ñanom Moisésoyeʼ sapaye, ñeñt̃paʼ satañneshañeʼnaña seyc̈hatnomueʼ ahuat̃ot̃eñ. Ñeñt̃oʼmarña sapaʼ c̈hocmach setsorrateñ asheñorrot̃oll ñerraʼm oʼch posocmataʼmuen amaʼt añ yet̃ro allempocma yamesen c̈hocmaña setsorrateñña asheñorrot̃oll. ");
INSERT INTO ameNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Att̃o sapaʼ setsorrateñ asheñorrot̃oll amaʼt añ yet̃ro allempocma yamesen att̃och amach sat̃pueno ñoñets ñeñt̃ atet̃ anaret̃ Moisésot̃, ñeñt̃epñapaʼ esoʼmaruañacaʼyeña seʼmoñeʼtenenña na allempo eʼñe naʼcrraten puesheñarr acheñ añ yet̃ro allempocma yamesen. ");
INSERT INTO ameNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ñerraʼm esempo senteñ poʼpsheñeñ ñeñt̃ atet̃ penpaʼ amachña ñeñt̃ot̃a sotteñeʼchatsche añoʼ cohuenayeʼ es yec̈hcateno. C̈hochña ñanom señoch errot̃ent̃eʼña ñeñt̃ poʼñoc̈h atet̃ pena. ");
INSERT INTO ameNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Patantaʼtets jerusaléñoʼmarneshaʼpaʼ atet̃ otyenet: —Taʼm amat̃eʼ añeyayeña ñeñt̃ oʼpatenet oʼch muetset. ");
INSERT INTO ameNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ñapaʼc̈hoʼña alloʼtsenepaʼt arr, att̃a ama es puec̈heno eñosets, amaña errot̃eyeʼña oteñeto. Ñatoʼ t̃arroʼmart̃eʼña amaʼt am̃chaʼtaret̃neshaʼpaʼ oʼcaʼye eñotuet poʼñoc̈h ñapaʼ ñeñt̃caʼye Cristotets. ");
INSERT INTO ameNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","T̃arraña añpaʼ yeñoteñcaʼye allot̃ huena. T̃arraña esempoch huapa ñeñt̃chaʼ eʼñe poʼñoc̈h Cristotats ñapaʼ amach eseshayeʼ eñotapaye errot̃chaʼ huapa. ");
INSERT INTO ameNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesúsña allempo yec̈haten Parets paʼpacllo, ñapaʼ puerranarot̃ atet̃ otanet: —Sapaʼ sechmeʼtennoñt̃eʼ, señotennoñt̃eʼña na errot̃t̃eʼ nohuapa. T̃arraña napaʼ ama not̃ayeʼ nohuapo, eñallña ñeñt̃ nellsenseʼ; ñapaʼ eʼñe poʼñoc̈h ñerraʼm errot̃ ot, ama puenesho poʼñoñ. Ñeñt̃ña sapaʼ ama señoteñeña sa. ");
INSERT INTO ameNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nañapaʼ eʼñe neñoteñ, ñeshot̃caʼye nohuapa. Ñapaʼ ñeñt̃caʼyeña nellsenserreʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Allempocma atarr mueneñet oʼch rromuetañ t̃arraña ama eseshaʼ rromaye. T̃arroʼmar ama c̈henaʼ allempo ñeñt̃ poctetsa ñocop att̃och rromuet. ");
INSERT INTO ameNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Shonteʼ acheñeneshaʼ ñeñt̃ ameʼñaya. Ñetñapaʼ atet̃ otyenet: —Añt̃eʼcaʼyeña poʼñoc̈h Cristo ñeñt̃ yecuen oʼch huapa. Yapaʼ oʼcaʼye orrtatosnay poʼpartsoña, amat̃eʼ errot̃enot̃ huapo poʼpsheñeñ ñeñt̃chaʼ ello metanoseʼ poʼpartsoteña ñeñt̃ atet̃ entatyeney añ yacmar. ");
INSERT INTO ameNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseoneshaʼñapaʼ eʼmareʼteñet shonteʼ acheñeneshaʼpaʼ eʼñe cohuen eñosyenet Jesúsocop. Ñeñt̃oʼmar ñet ñam̃a ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar, ñetñapaʼ mueñet guardianeshaʼ ñeñt̃chaʼ rromuenayañ Jesús. ");
INSERT INTO ameNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesúsñapaʼ alla oterraneterr: —Oʼ mamesham̃a eʼñe parroʼtseney. Oʼchña mamerrerrpaʼ oʼch alla ahuerren alloʼtsen ñeñt̃ nellsenseneʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Allempoña amaʼtchaʼ seʼnameʼterrenpaʼ amach senterrno. Allchaʼ neserr napaʼ sañapaʼ amat̃eʼ errot̃enot̃ sec̈hapo. ");
INSERT INTO ameNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Judioneshaʼñapaʼ atet̃ otannaʼtyeset: —Taʼ, ¿errach taña añma ñeñt̃oʼmar amach yentere? Ñatoʼ arrchaʼ ta griegoneshesho all parratseʼtyen yamoʼtseshaʼ oʼch yec̈hatenanaʼ griegoneshaʼ all. ");
INSERT INTO ameNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Taʼ, ¿est̃eʼña añma ñeñt̃oʼmar atet̃ oten: “Amaʼtchaʼ seʼnerrnaʼpaʼ amach senterrno; allchaʼ neserr napaʼ sañapaʼ amach errot̃enot̃ sec̈hapo”? ");
INSERT INTO ameNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Oʼ eʼñe huañmoch all coshena judioneshaʼ. Añe yet̃ro allempo nanac coshenet, Jesúsñapaʼ t̃omos all, puerranarot̃ atet̃ otosanet: —Erraʼtsent̃eʼ acheñer oñpaʼtets eʼñe pueyoc̈hreto, onetepaʼ nesho orretepaʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ñeñt̃ nameʼñenaya na eʼñe pueñmateñot̃et pueyoc̈hretopaʼ atet̃ pena ñerraʼmrrat̃eʼ allot̃ poten oñ aton ñeñt̃ atarr cohuen, t̃arroʼmar ñeñt̃paʼ atet̃ oten Yompor poʼñoñ ñeñt̃ anuaret̃ ahuat̃ot̃eñ. ");
INSERT INTO ameNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ñehua, añ ñoñetspaʼ añecop serrpareʼten Yompor Puecamquëñecop ñeñt̃chaʼ chorrerraya allohuen ñeñt̃chaʼ ameʼñerraya ña. T̃arraña allempopaʼ ama aparet̃tenetaʼ Yompor Puecamquëñ, t̃arroʼmar Jesúspaʼ ama c̈henaʼ allempoch alla ahuerr Yompor pueʼntaño allchaʼ eʼñe cohuentaterrñañet. ");
INSERT INTO ameNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Allempo eʼmhuet ñeñt̃ atet̃ oten Jesús, patantarrña acheñeneshaʼpaʼ atet̃ otyeset: —Poʼñoc̈h añmapaʼ ñeñt̃t̃eʼcaʼye aʼm̃teneʼña Yompor poʼñoñ ñeñt̃ c̈hocma yecuen. ");
INSERT INTO ameNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Poʼpotantañpaʼ atet̃ otyeset: —Añmapaʼ ñeñt̃t̃eʼcaʼyeña Cristotets ñeñt̃ c̈hocma yecuen. Poʼpotantaññapaʼ atet̃ otyenet: —Ñeñt̃chaʼ Cristoterretspaʼ amat̃eʼ arrot̃a huapo Galileot̃. ");
INSERT INTO ameNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Amaʼt otenoña Yompor poʼñoñ ñeñt̃ anuaret̃, Davidchaʼ poʼm̃renñot̃ huapaña ñeñt̃chaʼ Cristoterrets; arrot̃chaʼ huapa anetsot̃ ñeñt̃ Beléñ ñeñt̃ paʼnetser peʼt̃ David. ");
INSERT INTO ameNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ñeñt̃oʼmarña allohuen acheñeneshaʼpaʼ ellopaʼtetstatenet poct̃ap̃ña Jesúsocop. ");
INSERT INTO ameNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Patantaʼtetsñapaʼ atarr mueneñet oʼch rromuet, t̃arraña ama eseshaʼ rromaye. ");
INSERT INTO ameNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Guardianeshaʼñapaʼ puerrac̈herret alloʼtsen ñeñt̃ paʼm̃chaʼtaret̃erneshaʼ pen allohuen judioneshaʼ poʼcornaneshar epuet ñam̃a fariseoneshaʼ. Ñetñapaʼ atet̃ otaret̃tapuerret: —Esoʼmaruañacaʼyeña amaña sehuapatere. ");
INSERT INTO ameNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Guardianeshaʼñapaʼ atet̃ otuerret: —Amaʼt eseshapaʼ ama pueñosaroña atarr cohuen atet̃ eñen ña. ");
INSERT INTO ameNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Fariseoneshaʼñapaʼ atet̃ oterraneterr: —T̃arroʼmart̃eʼ ama sehuapatere sapaʼc̈hoʼña c̈hot̃eʼcaʼye shecapas sam̃a. ");
INSERT INTO ameNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Amaʼt ñam̃a patantarr am̃chaʼtaret̃neshaʼpaʼ amaʼt oʼ c̈ha ameʼñyeto ñamet. Amaʼt ñam̃a patantarr fariseoneshaʼpaʼc̈hoʼña oʼt̃eʼcaʼye c̈ha ameʼñyet. ");
INSERT INTO ameNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","T̃arraña ñeñt̃ acheñeneshar ñeñt̃ ama eñotenaye ñoñets ñeñt̃ atet̃ anaret̃ ñetñapaʼ aʼcmaret̃et. ");
INSERT INTO ameNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ñeñt̃ña puesheñarr fariseo ñeñt̃ Nicodemo ñeñt̃ tatsa ahuaña Jesúsesho, ñañapaʼ atet̃ otan pamoʼtseshaʼ fariseoneshaʼ: ");
INSERT INTO ameNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Ñoñets ñeñt̃ atet̃ anaret̃ yocoppaʼ atet̃ oteney, amach errot̃enot̃ yecoñchache amaʼt puesheñarra acheñ eʼñe att̃ot̃a. C̈hochña ñanom yeʼm̃ñoch att̃och yeñoch est̃eʼ otatseʼtyen ñeñt̃ atarr sosey yenten eshecchaʼña yecoñchach. ");
INSERT INTO ameNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ñetñapaʼ atet̃ ochet: —Esoʼmaruachcaʼ pemoñesyaña galileoʼmarneshaʼ, ñatoʼ p̃apaʼ galileoʼmarneshap̃t̃eʼ. P̃apaʼ amarramcheʼ galileoʼmarneshayaype. T̃eʼpaʼ pelleyaʼyes Yompor poʼñoñ allochñapaʼ oʼch peñoch Galileot̃paʼ amaʼt puesheñarrapaʼ amach huapoña ñeñt̃chaʼ aʼm̃teneʼ Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Allempoña allohuenet ahuanemyerret paʼpaclleto. ");
INSERT INTO ameNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesúsñapaʼ ahuerr Olivop̃no. ");
INSERT INTO ameNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tsapat̃ña poʼpocheño eʼñe ahuat̃ecma alla c̈henerr Parets paʼpacllo. Shonteʼ acheñeneshaʼ alla huac̈heneterr ñesho. Ñañapaʼ anorros allña yec̈hatenaneterr. ");
INSERT INTO ameNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ñeñt̃ña etsotayenayeñ ñoñets ñeñt̃ atet̃ anaret̃ judioneshacop ñam̃a fariseoneshaʼ ñetñapaʼ huapatoñet puesheñarr coyaneshaʼ ñeñt̃ rromuet all eñchet chetapretenan poʼpsheñeñ pacma puerrollar. Nosñañet eʼñe rroc̈ho. ");
INSERT INTO ameNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Allñapaʼ atet̃ otoset: —Maestro, añ coyaneshaʼpaʼ oʼ yentaprech eʼñe all chetapretenan pacma puerrollar. ");
INSERT INTO ameNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés poʼñoñ ñeñt̃ atet̃ anaret̃ ñeñt̃paʼ atet̃ oteney, añpaʼ c̈hoch yarrolleʼch. T̃eʼña p̃apaʼ ¿errot̃eʼtchaʼña p̃oteyña p̃a? ");
INSERT INTO ameNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ñeñt̃paʼ t̃arroʼmara atet̃ otoset ñatoʼrraña eñorachet ñeñt̃ ama pocteyaye allochñapaʼ att̃och aʼmet̃am̃peñetaʼ. Jesúsñapaʼ allent̃a moʼcapaʼ oʼ quellcan pats potap̃o. ");
INSERT INTO ameNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ñetñapaʼ alla aʼp̃t̃oʼtereterr. Jesúsña echanterrtsapaʼ atet̃ otanet: —Ñerraʼm erraʼtsenot̃est̃eʼ ama eñalle soʼchñarpaʼ sarrolleʼchcaʼye sanom. ");
INSERT INTO ameNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Alla moʼquërrerr oʼ alla quellquërranerr pats potap̃o. ");
INSERT INTO ameNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ñetñapaʼ oʼ eʼmet atet̃ otanet Jesúspaʼ eʼñe acop̃ot̃eñ ahuanemhuerret eʼñe puesheñaʼttset. Añ ñanom ahuanerrtsa poʼnmeneshac̈hno, att̃ot̃apaʼ oʼ ñapt̃am̃a Jesús epuet coyaneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesúsña echanterrerrpaʼ atet̃ otan coyaneshaʼ: —Noc̈heshachaʼ ¿erroʼtsaʼyenetaʼtña? Amaʼt puesheñarrot̃eta ñetpaʼ areʼtchaʼña coñchatape. ");
INSERT INTO ameNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ñañapaʼ atet̃ otan Jesús: —Ama Ayochreshat̃e eseshayeʼ necoñchataye. Jesúsñapaʼ alla otererr: —Napaʼc̈hoʼña amach necoñchatape. T̃eʼña ñerraʼm ahuerrep̃paʼ amach alloʼna atet̃ pep̃aʼneno ñeñt̃ amaʼt mamesha ama pocteyaye. ");
INSERT INTO ameNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesúsña poʼpocheñopaʼ serrpareʼtaterranerr acheñeneshaʼ, ñeñt̃paʼ atet̃ oterraneterr: —Napaʼ na ñeñt̃en aʼpuetarsam̃peneʼ acheñeneshaʼ poct̃ap̃ña añe patsro. Eseshaʼch noct̃erreʼ oʼhuañchaʼ alloʼna cot̃apeʼchatnenanet poct̃ap̃ña ñeñt̃ atarr sosyaʼtsañ; ñeñt̃paʼ checmeta chopeñeʼchyenet. Ñetñapaʼ Yomporchaʼ poʼcohuenño correrret ñeñt̃ara ñeñt̃ puetarets. ");
INSERT INTO ameNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Fariseoneshaʼñapaʼ atet̃ ochet: —P̃apaʼ p̃añeña aʼpot̃etsa ñeñt̃oʼmarña att̃o p̃aʼpot̃enapaʼ ama sherbeno. ");
INSERT INTO ameNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesúsñapaʼ oterraneterr: —T̃arraña amaʼt nañeña aʼpot̃etsapaʼ att̃o naʼpot̃enapaʼ eʼñe sherben. T̃arroʼmar napaʼ neñoteñ allot̃ nohuapa ñam̃a neñoteñ allchaʼ neserr. Sañapaʼ ama señotenno allot̃ nohuapa ñeñt̃oʼmarña ama señoteñe allchaʼ neserr. ");
INSERT INTO ameNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Sa sotatseñpaʼ eʼñe orrena atet̃ sepena, arromñat̃eneshasa atet̃ petsa. Napaʼ amaʼt puesheñarrapaʼ ama notatseʼtenaneto eʼñe att̃a. ");
INSERT INTO ameNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","T̃arraña ñerraʼm esempo naʼmet̃enanet ñeñt̃ atet̃ nentapretyenanet ñeñt̃paʼ eʼñe poʼñoc̈h atet̃ t̃arroʼmar napaʼ ama napt̃eyeʼ es nep̃aʼyeno, napaʼ c̈hocmaña epan Apa ñeñt̃ nellsenseneʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ñoñets ñeñt̃ atet̃ anaret̃ ñeñt̃ sechen sa, ñeñt̃paʼ atet̃ oten: Ñerraʼm epsheña aʼpot̃eneʼ eʼñe att̃ecma ñeñt̃paʼ eʼñecaʼye poʼñoc̈h otenet. ");
INSERT INTO ameNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Napaʼ ñeñt̃ atet̃ naʼpot̃ena na, Apaña ñeñt̃ nellsenseneʼ ñacaʼyeña naʼpot̃eneʼña nocop. ");
INSERT INTO ameNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ñetñapaʼ atet̃ otereterr: —¿Erroʼtsenaʼtña p̃a P̃ompor? Jesúsñapaʼ atet̃ oterraneterr: —Amaʼt napaʼ ama señotenno, Apapaʼc̈hoʼ ama señoteñe. Ñerraʼm señotennoñ na Nomporeʼnat̃eʼ señoteneñ. ");
INSERT INTO ameNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Allempopaʼ atet̃ otanet Jesús all allecma aññoʼtenet quelle ñeñt̃ Yomporecop allempo yec̈hatanet allara Parets paʼpacllo. T̃arraña amaʼt puesheñarra ama eseshayeʼ rromaye t̃arroʼmar ama c̈henaʼ allempoch ñeñt̃ poctetsa ñocop oʼch rromuet. ");
INSERT INTO ameNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Allempoña Jesúspaʼ atet̃ oterraneterr: —Napaʼ oʼch ahuerren, sapaʼ seʼnerrenchaʼ. Sapaʼ orach ochñaret̃es serromhua. Allchaʼ neserrpaʼ sañapaʼ amach sec̈hapo. ");
INSERT INTO ameNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Judioneshaʼñapaʼ atet̃ otannaʼtyeset: —Taʼm ñapaʼ oʼch muetsa ñañeña, ¿ñeñt̃oʼmart̃eʼ atet̃ oten allchaʼ serrpaʼ yañapaʼ añoʼch yec̈hapo? ");
INSERT INTO ameNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ñañapaʼ alla oterraneterr: —Sapaʼ alla ayec̈hcañas arr patsro. Nañapaʼ entoʼmarneshan. Sapaʼ patsoʼmarneshasa, nañapaʼ ama patsoʼmarneshayayno. ");
INSERT INTO ameNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Napaʼ oʼ notas sapaʼ orach ochñaret̃es serromhua t̃arroʼmar ñerraʼm amach sameʼñerrno na ñeñt̃en peretneneʼ ochñarets, poʼñoc̈h sapaʼ orach ochñaret̃es serromhua. ");
INSERT INTO ameNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ñetñapaʼ atet̃ otereterr: —P̃apaʼ poʼñoc̈h ¿eseshapeʼtña? Jesúsñapaʼ alla oterraneterr: —Napaʼ ñeñt̃encaʼye poʼñoc̈h c̈hocma soteneʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Atarr nanac palltena c̈hocmach notenes atet̃ sepena sa, shonteʼch neños añecop atet̃ nentyen. T̃arraña ñeñt̃ nellsenseneʼ ñapaʼ eʼñe poʼñoc̈h atet̃ oten ña. Napaʼ añcaʼyeña neʼñoreññaña acheñeneshaʼ arr patsro ñeñt̃ atet̃ neʼmueññañ Apa. ");
INSERT INTO ameNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ñetñapaʼ ama eseshaʼ c̈hapahueto pueyoc̈hreto ñeñt̃ atet̃ otenanet Pomporecop ñeñt̃ atarr Parets. ");
INSERT INTO ameNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jesúsñapaʼ alla oterraneterr: —Ñerraʼm esempoch sapaʼ sechantam̃p̃sen eno corsocho na Ñeñt̃en Acheñetosetspaʼ allempochña c̈haponasa seyoc̈hro napaʼ ñeñt̃en eʼñe poʼñoc̈h c̈hocma soteneʼ. C̈haponasach ñam̃a napaʼ ama es nepeno eʼñe not̃a, añña neʼñorena atet̃ yec̈hatenen Apa. ");
INSERT INTO ameNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ñeñt̃ nellsenseneʼ ñapaʼ eʼñe parroʼtsenen. Ama aʼmontsenno, t̃arroʼmar napaʼ eʼñe c̈hocma atet̃ nepena ñeñt̃ muenen ña. ");
INSERT INTO ameNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Allempo atet̃ serrpareʼtatenanet allempopaʼ shonteʼ ameʼñaya all. ");
INSERT INTO ameNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Allempoña Jesúspaʼ atet̃ otan judioneshaʼ ñeñt̃ ameʼñenaya ña: —Ñerraʼm c̈hocma soct̃apeʼchon neñoñ poʼñoc̈hpaʼ neyochreshaʼch nepenes. ");
INSERT INTO ameNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Allempopaʼ señoterrchaʼ ñoñets ñeñt̃ eʼñe poʼñoc̈h Yompor poʼñoñ. Ñeñt̃ña ñoñets poʼñoc̈hpaʼ toram̃perreschaʼ eʼñech cohuenoʼtsenes. ");
INSERT INTO ameNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ñetñapaʼ atet̃ otereterr: —Yapaʼ Abrahamcaʼye poʼm̃renñey. Amaʼt ahuat̃a yapaʼ amaʼt puesheñarrot̃eyapaʼ ama ehuancaret̃eye att̃och eseshaʼ yetaruasateʼ eʼñe att̃a. Esoʼmart̃eʼ p̃añapaʼ p̃oteneyña atoram̃p̃saret̃eyoʼch. ");
INSERT INTO ameNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesúsñapaʼ alla oterraneterr: —Poʼñoc̈hcaʼye notenes: Allohuen ñeñt̃ ochñaʼtareʼtetspaʼ poʼchñara huanquënahuet, ñetñapaʼ poʼchñara taruasatenahuet eʼñe att̃a. ");
INSERT INTO ameNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ñeñt̃ ataruasataret̃ eʼñe att̃a amach c̈hocmayeʼ yec̈herro eʼñe parro epuet pamoʼmteʼ. T̃arraña na ñeñt̃en Puechemeren c̈hocma eʼñe neyc̈hena epan Namoʼmteʼ errponañohuen. ");
INSERT INTO ameNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ñeñt̃oʼmarña na ñeñt̃en Puechemeren ñerraʼm na setoram̃perreʼ sapaʼ atoram̃p̃saret̃eschaʼ eʼñe poʼñoc̈h, amach alla taruasaterrseʼt̃e soʼchñar. ");
INSERT INTO ameNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Na poʼñoc̈hpaʼ neñotenes sapaʼ poʼm̃renñeseñ Abrahampaʼ t̃arraña sapaʼ aña semnen oʼch semtsan. T̃arroʼmar neñoñpaʼ amaʼt mameshapaʼ ama c̈hennaso sa seyoc̈hro. ");
INSERT INTO ameNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Napaʼ añ neñeñ ñeñt̃ atet̃ nentapreteñ Apa. Sapaʼc̈hoʼña aña atet̃ sepen ñeñt̃ atet̃ seʼmapreteñ ñeñt̃ sompor sepen. ");
INSERT INTO ameNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Alla otereterr: —Ya yatañpaʼ Abrahamcaʼye. Jesúsñapaʼ atet̃ oterraneterr: —Sapaʼ ñerraʼm poʼñoc̈h Abraham poʼm̃renñeseñ soct̃apeʼcheneñt̃eʼ atet̃ eʼñe cohuen cot̃apeʼcheʼt̃ Abraham. ");
INSERT INTO ameNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","T̃arraña sa t̃eʼpaʼ c̈ha soʼpatenna oʼch semtsan na ñeñt̃en seserrpareʼtateneʼ ñoñets ñeñt̃ eʼñe poʼñoc̈h ñeñt̃ atet̃ neʼmueññañ Yompor. Abrahampaʼ amacaʼ att̃eyeʼ peʼt̃e. ");
INSERT INTO ameNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Sapaʼ eʼñe aña soct̃apeʼchen atet̃ pena sompor. Ñetñapaʼ alla otereterr: —Yapaʼ amacaʼye ellapnaneshot̃eyeʼ yeʼñalleto. Eʼñe ñapt̃a Yompor yepeñ ñeñt̃ara Parets. ");
INSERT INTO ameNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesúsñapaʼ alla oterraneterr: —Ñerraʼm poʼñoc̈h Sompor sepeñeñ Parets atarrt̃eʼ semorrentennañ na t̃arroʼmar napaʼ Partseshot̃caʼye nohuapa oʼ nec̈hap arr. Napaʼ amacaʼye not̃ayeʼ nohuapo, napaʼ Yomporña nellsenseʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Esoʼmareʼtña sapaʼ ama c̈hennasoña seyoc̈hro ñeñt̃ notenes. Ñatoʼ t̃arroʼmart̃eʼña ama semno oʼch seʼm̃ñoten ñeñt̃ atet̃ notenes. ");
INSERT INTO ameNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Sapaʼ oneñet̃acaʼye ñeñt̃ sompor sepen. Ñeñt̃oʼmarña sapaʼ aña semnen oʼch sep̃a ñeñt̃ muenen sompor. Ñapaʼ ahuat̃ot̃eñ eʼñe paʼmot̃rot̃eñ amtsañta. Ñapaʼ amaʼt mameshapaʼ ama eñoraʼpenoña Yompor poʼñoñ ñeñt̃ eʼñe poʼñoc̈h t̃arroʼmar ñoñets ñeñt̃ eʼñe poʼñoc̈hpaʼ amacaʼye atanenoña ña pueyoc̈hro. Ñerraʼm c̈ho eñorenapaʼ, shequëñtsach eñorena t̃arroʼmar ñapaʼ eʼñe shequëñtsa eñoten. Poʼñoc̈h sequëñetspaʼ pomporcaʼ penanña oneñet̃. ");
INSERT INTO ameNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","T̃arroʼmar napaʼ añ notenes ñeñt̃ eʼñe poʼñoc̈h sañapaʼ amaña sameʼñenno. ");
INSERT INTO ameNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Amaʼt puesheñarrot̃esa sa, napaʼ amach errot̃enot̃ sotno napaʼ eñalloʼ noʼchñar. Att̃o napaʼ añ notenes ñeñt̃ eʼñe poʼñoc̈h esoʼmareʼtña sañapaʼ ama sameʼñenno. ");
INSERT INTO ameNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Erraʼtsent̃eʼ Yomporenaʼtarpaʼ ñetñapaʼ c̈hochcaʼye eʼm̃ñoteññañet Yompor poʼñoñ. Ñeñt̃oʼmarña sapaʼ ama seʼm̃ñoteññañe poʼñoñ, amacaʼye Yomporenaʼtareyayso. ");
INSERT INTO ameNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Judioneshaʼñapaʼ atet̃ otereterr: —Eʼñe poʼñoc̈h atet̃ yotenep̃, p̃apaʼ samarioʼmarneshap̃, oneñet̃a pechorrenaya. ");
INSERT INTO ameNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesúsñapaʼ oterraneterr: —Napaʼ ama c̈hoyeʼ chorrenno oneñet̃. Napaʼ atarr nanac nem̃chaʼnaʼteñ Nompor Parets. Sañapaʼ ama sem̃chaʼnaʼtenno na. ");
INSERT INTO ameNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Napaʼ ama añeyeʼ neʼneno att̃och necohuentata nañeña. Eñallña ñeñt̃ necohuentateneʼ na. Ña eñoretsa atet̃ es entyen arr patsro. ");
INSERT INTO ameNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Poʼñoc̈hcaʼ notenes: Ñerraʼm eseshaʼ eʼñe cot̃apeʼcherreʼ neñoñpaʼ ñetña amaʼt ahuat̃apaʼ amach eʼñe poctacma rromuerreto. ");
INSERT INTO ameNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Judioneshaʼñapaʼ alla otereterr: —T̃eʼña poʼñoc̈h yapaʼ oʼ yeñotap̃ p̃apaʼ c̈ha chorrenp̃a oneñet̃. Amaʼt Abrahampaʼ oʼ rromuen ñam̃a ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñ ñeñt̃paʼc̈hoʼña oʼ collaʼhuenet. T̃eʼña p̃apaʼ atet̃ p̃oteney eseshoʼch cot̃apeʼcherreʼ peñoñpaʼ amaʼt ahuat̃apaʼ añoʼch rromuerreto. ");
INSERT INTO ameNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","P̃apaʼ c̈hat̃eʼ p̃otenapañ ellot̃eʼ pem̃taneñ att̃o am̃chaʼtaret̃teʼt̃ Abraham amaʼt ñapaʼ oʼcaʼye rromuen. Ñeñt̃ aʼm̃taʼyesayeʼt̃ Yompor poʼñoñpaʼ ñetpaʼc̈hoʼña oʼ collaʼhuenet. P̃apaʼ c̈hat̃eʼ p̃otenapañ amat̃eʼ arromñat̃eshayaype. ");
INSERT INTO ameNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesúspaʼ atet̃ oterraneterr: —Ñerraʼm na cohuentatetsa nañeña, necohuentateña eʼñe napaʼ amat̃eʼ es sherbeno. Nomporpaʼ ña necohuentateneʼ ñeñt̃ara ñeñt̃ soteneñ Seyompor-roʼ sepeñ sam̃a. ");
INSERT INTO ameNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Sapaʼ amacaʼye señoteñe t̃arraña napaʼ neñoteñcaʼye. Ñerraʼm na otetseñ ama neñoteñe napaʼc̈hoʼña att̃eneñt̃eʼ ñerraʼm sa, c̈hat̃eʼ neshcareʼtensoñ. Napaʼ eʼñe poʼñoc̈h neñoteñ ñeñt̃oʼmar c̈hocma noct̃apeʼcheññañ poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham ñeñt̃ sa satañpaʼ atarr nanac cosha allempo eñoch oʼ c̈hap allempo ñeñt̃ poctetsa nocop oʼch nohuapa arr patsro. Allempoña eñoch napaʼ oʼ nec̈hap arr patsro atarr nanac cosha. ");
INSERT INTO ameNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Judioneshaʼñapaʼ alla otereterr: —P̃apaʼ ama pechenaʼ amnaroch c̈harraʼ pecharña p̃añapaʼ esoʼmareʼtña p̃oteneyña p̃apaʼ penteroʼ Abraham, ñeñt̃paʼ ahuat̃rramcheʼ correʼt̃. ");
INSERT INTO ameNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesúsñapaʼ alla oterraneterr: —Poʼñoc̈hcaʼ napaʼ oʼch notas: Ama eñalletenaʼña Abraham, nañapaʼ eñallana. ");
INSERT INTO ameNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ñetñapaʼ allent̃a chetet mapueʼpaʼ oʼch rrolleʼchetañ t̃arraña Jesúsña aʼnahua c̈haʼnerr Parets paʼpacllot̃paʼ oʼ ahuerr oʼ sohuanerranet. ");
INSERT INTO ameNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","All oñen Jesúspaʼ allña entnoman puesheñarr yacma aporoʼyet̃. Ñeñt̃ña aporoʼyet̃paʼ att̃a eñalletña. ");
INSERT INTO ameNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Pueyochreshaʼñapaʼ allent̃a aʼp̃t̃oʼchet: —Maestro, ¿eseshaʼtña ochñaʼtats ñatoʼ ña amapaʼ pamoʼmteʼt̃eʼ ñeñt̃oʼmar eñalletaña atet̃ aporoʼyet̃? ");
INSERT INTO ameNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesúsñapaʼ atet̃ otanet: —Amacaʼye poʼchñarot̃eyaye amaʼt ñam̃a pamoʼmteʼ; ñeñt̃paʼ añecopña allochñapaʼ oʼch norrtatoñ Yompor poʼpartsoña ñesho. ");
INSERT INTO ameNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ñeñt̃ poctetsa oʼch norrtatoñ poʼpartsoña ñeñt̃ nellsenseʼ t̃ayepaʼtñapaʼ puetarmeñ. Ñerraʼm oʼch checmetenpaʼ amach eshcayeʼ yetaruaso. ");
INSERT INTO ameNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","T̃ayepaʼtña añe patsroʼtsenmeñenpaʼ na ñeñt̃en aʼpuetarsam̃peneʼ acheñeneshaʼ poct̃ap̃ña añe patsro. ");
INSERT INTO ameNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Allempoña atet̃ otuapaʼ allent̃a aʼc̈honan paʼsnom patso oʼ aʼc̈hac̈haʼtach. Ñeñt̃ña c̈hac̈haʼteʼpaʼ alloña aʼyaclleʼchanña aporoʼyet̃. ");
INSERT INTO ameNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Oʼña aʼyaclleʼchuepaʼ atet̃ och: —T̃eʼpaʼ orrap̃ oño all apcoʼsat̃tataret̃o ñeñt̃paʼ añ paʼsoʼcheñ Siloés. Allchaʼ peʼpaclleʼcha. (Ñehua, añcaʼye otenetña Siloés ñeñt̃ oñ ahuaʼñaret̃.) Ñañapaʼ allent̃a ahuoʼ oño allchaʼ eʼpaclleʼchenaʼ. Eʼpaclleʼchuatsapaʼ eʼñe errtsapaʼ allent̃epaʼtchaʼ cohuenterraña paʼclleʼ eʼñe cohuen enterra. ");
INSERT INTO ameNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Pamoʼtseshaʼña ñam̃a poʼpoñec̈hno acheñ ñeñt̃ eʼñe chemeʼteneʼ all allempo enamaren quelle, ñetñapaʼ atet̃ otyeset: —Añpaʼ ¿amaʼt añeyayeña ñeñt̃ anorrtseʼt̃ ñeñt̃ enamareʼtatseʼt̃ quelle? ");
INSERT INTO ameNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Patantarr acheñeneshaʼpaʼ atet̃ otyenet: —Ñeñt̃caʼye. Poʼpotantañec̈hnopaʼ atet̃ otyenet: —Amacaʼye ñeñt̃eyaye, att̃acaʼ ñeñt̃emaʼt̃tena. Aporoʼyet̃ñapaʼ atet̃ otanet: —Napaʼ ñeñt̃encaʼye. ");
INSERT INTO ameNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ñetñapaʼ atet̃ otyeset: —¿Errot̃enot̃eʼtña oʼ pecuerr? ");
INSERT INTO ameNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ñañapaʼ atet̃ oterraneterr: —Añ yacmar ñeñt̃ otenet Jesús ñacaʼye aʼc̈hac̈haʼteʼña paʼsnomo patspaʼ allocaʼyeña aʼyaclleʼchen. Allempoñapaʼ oten nepaclleʼchenepaʼtoʼ oño Siloéso. Nañapaʼ allña neʼpaclleʼchenaʼ. Eʼñe eʼpaclleʼchuatsanpaʼ allent̃epaʼtchaʼ necuerr. ");
INSERT INTO ameNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ñetñapaʼ alla otereterr: —¿Erroʼtsenaʼtña ñeñt̃ yacmar? Ñañapaʼ ot: —Taʼm, amacaʼye neñoteñe. ");
INSERT INTO ameNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Allempoña ñeñt̃ poroʼyeʼchatseʼt̃paʼ anmet alloʼtsen fariseoneshaʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ñehua, allempo aʼc̈hac̈haʼtan Jesús paʼsnomo pats allo aʼyaclleʼchan aporoʼyet̃ ñeñt̃ cohuaterreʼ allempopaʼ añ yet̃ro allempo amesenet. ");
INSERT INTO ameNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Fariseoneshaʼñapaʼ ello alla otereterr: —¿Errot̃enot̃eʼtña oʼ cohuaterrpet? Ñañapaʼ atet̃ otosanet: —Añocaʼye aʼyaclleʼcherrnet senmatso ñeñt̃ aʼc̈hac̈haʼtaret̃ epuet pats oʼña neʼpaclleʼcherrapaʼ allent̃a necuerr. ");
INSERT INTO ameNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Patantarrña fariseoneshaʼpaʼ atet̃ otyeset: —Ñeñt̃ yacmarpaʼ amat̃eʼcaʼye Partseshot̃eyeʼ huapo ñeñt̃oʼmar ama esoyeʼ entenanoña ñeñt̃ anaret̃ pat̃err yet̃ allempocma yamesen. Poʼpotantaññapaʼ atet̃ otyeset: —Taʼ, elloña ñerraʼm ochñat̃ acheñ amat̃eʼ errot̃enot̃ orrtatonayeña partsoteñets. Att̃oña eʼñe all ellopaʼtetstatet poct̃ap̃ña ñocop. ");
INSERT INTO ameNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ellopaʼ alla otereterr ñeñt̃ poroʼyeʼchatseʼt̃: —¿Errot̃enaʼt p̃otenña p̃a añecop ñeñt̃ oʼ cohuaterrep̃? Ñañapaʼ atet̃ ot: —Ñapaʼ ñeñt̃caʼye aʼm̃teneʼ Yompor poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Judioneshaʼñapaʼ atet̃ otyeset: —Ñapaʼ amacaʼye poʼñoc̈h aporoʼyet̃eyaye, eʼñecaʼye cohuen entena. Allempoñapaʼ c̈horeʼtoñet pamoʼmteʼ ñeñt̃ oʼ cohuerr. ");
INSERT INTO ameNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ñetñapaʼ atet̃ otapoñet pamoʼmteʼ: —Añpaʼ ¿añeʼtña sacñeʼt̃er ñeñt̃ sotyeseʼt̃ ahuoʼ eñalletaña sacñeʼt̃er aporoʼyet̃? T̃eʼñapaʼ ¿errot̃enot̃eʼtña oʼ cohuerr? ");
INSERT INTO ameNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Pamoʼmteʼñapaʼ atet̃ otosanet: —Poʼñoc̈h añcaʼyeña yacñeʼt̃er ñeñt̃ att̃a eñalletatsa aporoʼyet̃. ");
INSERT INTO ameNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Att̃o oʼ cohuerrpaʼ yapaʼ amacaʼyeña yeñoteñe. Taʼ, eseshaʼt̃eʼ oʼ cohuater, yapaʼ ama yeñoteñe. Saʼp̃t̃oʼch eʼñe ña, ñapaʼ oʼcaʼye att̃a poʼnapen, ñot̃achcaʼye eñora. Judioneshaʼña allempopaʼ atet̃ otyeset: —Poʼñoc̈hepaʼtcaʼye aporoʼyet̃ oʼ cohuerr. ");
INSERT INTO ameNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ñehua, pamoʼmteʼ atet̃ otanet t̃arroʼmar ñetpaʼ mechaʼteñet judioneshaʼ. Ñehua, judioneshaʼ ñetpaʼ atet̃ aʼpoctatenet ñerraʼm eseshaʼ otets: Jesúspaʼ ñeñt̃caʼye Cristotets, ñeñt̃ña atet̃ otetspaʼ oʼch mueñoʼchet ñet poʼprahuot̃. ");
INSERT INTO ameNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ñeñt̃oʼmarña pamoʼmteʼpaʼ atet̃ otanet: —Ñapaʼ oʼcaʼye att̃a poʼnapen, ñot̃achcaʼye eñora. ");
INSERT INTO ameNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Puepocheñopaʼ alla c̈horeʼtereterr ñeñt̃ poroʼyeʼchatseʼt̃ atet̃ otapet: —T̃eʼ p̃apaʼ oʼch pecohuentaterrñañ Yompor. Yapaʼ yeñoteñ añ yacmapaʼ atarrcaʼye ochñat̃. ");
INSERT INTO ameNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ñañapaʼ atet̃ oterraneterr: —Taʼ, ñatoʼ ochñat̃eñt̃eʼ napaʼ ama neñoteñe. Napaʼ añacaʼye neñoten napaʼ aporoʼyet̃en t̃eʼñapaʼ oʼ cohuen necuerr. ");
INSERT INTO ameNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ñetñapaʼ alla otereterr: —¿Errot̃eʼtña perrep̃? ¿Errot̃enot̃eʼtña oʼ cohuaterrep̃? ");
INSERT INTO ameNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ñañapaʼ oterraneterr: —Amaʼtña napaʼ oʼcaʼye notuas sañapaʼ areʼtña señoteñe. ¿Esoʼmareʼtña semneñ oʼch alla noterrserr? Ñatoʼ ¿añecopt̃eʼ semneñ oʼch yochreshaʼtasa sam̃a? ");
INSERT INTO ameNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ñetña allent̃a otnareʼchetpaʼ atet̃ otereterr: —P̃apaʼ pueyochreshaʼ penep̃ ñeñt̃ yacmar, yañapaʼ Moiséscaʼye pueyochreshay. ");
INSERT INTO ameNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Yapaʼ yeñoteñ Paretspaʼ eñoranaʼtana Moisés, t̃arraña ñeñt̃ yacmarpaʼ ama yeñoteñe errot̃t̃eʼña huapa. ");
INSERT INTO ameNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ñeñt̃ poroʼyeʼchatseʼt̃paʼ atet̃ oterraneterr: —Errot̃enot̃uacaʼye ama señoteñet̃eʼña errot̃t̃eʼ huapaña amaʼt napaʼ oʼcaʼye eʼñe cohuen cohuaterren. ");
INSERT INTO ameNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Yapaʼ yeñoteñ ñeñt̃ ochñat̃ acheñpaʼ amacaʼye eʼm̃ñoteñe Yompor, t̃arraña ñerraʼm ya yem̃chaʼnaʼteñot̃ Yompor atet̃ yepena ñeñt̃ muenen ñapaʼ c̈hocmach eʼm̃ñoteney. ");
INSERT INTO ameNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ya amaʼt ahuat̃apaʼ ama yeʼmareña eseshaʼpaʼ oʼ cohuaterranña ñeñt̃ att̃a eñalletña aporoʼyet̃. ");
INSERT INTO ameNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ñerraʼm ñapaʼ ama Yomporeshot̃ huapañe amat̃eʼ errot̃enot̃ cohuaterrnoñe. ");
INSERT INTO ameNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ñetñapaʼ alla otereterr: —P̃apaʼ peʼñalleta eʼñe ochñartsot̃. T̃eʼñapaʼ c̈ha pemneñ oʼch peyc̈hatey ya. Allent̃a mueñoʼchet eʼñe ñet poʼprahuot̃. ");
INSERT INTO ameNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesúsñapaʼ oʼ eʼmareʼch ñeñt̃ aporoʼyet̃tatseʼt̃paʼ oʼ mueñoʼchet. Allempoña enter Jesúspaʼ atet̃ oter: —¿P̃ameʼñeñaʼt ñeñt̃ Yompor Puechemer? ");
INSERT INTO ameNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ñañapaʼ atet̃ och: —Ayochreshat̃e, ¿eseshaʼtña ñeñt̃ Yompor Puechemer ñeñt̃chaʼ nameʼña? ");
INSERT INTO ameNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesúsñapaʼ atet̃ otererr: —Ñeñt̃ pecuen, ñeñt̃en atet̃ p̃oteneʼ, nacaʼye. ");
INSERT INTO ameNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ñañapaʼ allent̃a concorpa ñeshopaʼ atet̃ otererr: —Nameʼñerrp̃ach Partseshachaʼ. ");
INSERT INTO ameNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesúsñapaʼ alla oterrerr: —Napaʼ añecopña nohuapa arr patsro allochñapaʼ att̃och acraret̃terra acheñeneshaʼ errot̃enchaʼ nentyesanet, allochñapaʼ ñeñt̃ ama entetsopaʼ oʼch eʼñe cohuen enterra. Ñeñt̃ña entetsañpaʼ oʼch alla aporoʼyet̃terra. Ñeñt̃paʼ añ tomaʼntata, ñeñt̃ atarr ochñat̃ entetsa ñerraʼm ameʼñerrana Jesús, ñetpaʼ c̈herranetchaʼ Yompor poʼcohuenña pueyoc̈hreto. Ñeñt̃ña ama ochñat̃eyeʼ entetsañe ñeñt̃oʼmarña ñetpaʼ amach ameʼñereto Jesús, ñetñapaʼ amach c̈herraneto Yompor poʼcohuenña pueyoc̈hreto. ");
INSERT INTO ameNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Patantaʼtetsña fariseoneshaʼ ñeñt̃ allameʼttsoʼtsaʼyenet ñesho, ñetñapaʼ eʼmueñet ñeñt̃ atet̃ oten Jesús. Ñetpaʼ atet̃ ochet: —Taʼm yapaʼ ¿amat̃eʼ aporoʼyet̃eyeʼ pentenye? ");
INSERT INTO ameNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesúsñapaʼ atet̃ otanet: —Ñerraʼm poʼñoc̈h sa aporoʼyet̃ sentenañ amat̃eʼ eñallmeñeña soʼchñar. T̃arraña sapaʼ atet̃ soten, sapaʼ añoʼ aporoʼyet̃eyayso, eʼñoʼ cohuen secuen, ñeñt̃oʼmarña t̃eʼpaʼ oʼch notas, soʼchñarpaʼ c̈hocma eñall. ");
INSERT INTO ameNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Allempoña Jesúspaʼ alla yec̈haterraneterr, ñeñt̃paʼ atet̃ tomaʼntaterraneterr: —Poʼñoc̈hcaʼ notenes: All yottam̃peñet carrnero ñerraʼm eseshaʼ ama beʼt̃etso allot̃ecma beʼt̃enet ñerraʼm poʼpshem̃tañot̃a aʼtenet, ñeñt̃ña poʼñoc̈hpaʼ eñet̃caʼye ñeñt̃ aprratam̃p̃sañtetsa. ");
INSERT INTO ameNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","T̃arraña ñerraʼm eseshaʼ beʼt̃ets eʼñe allot̃ecma beʼt̃enet ñeñt̃ña poʼñoc̈hpaʼ ñeñt̃ cohuam̃peneʼ carrnero. ");
INSERT INTO ameNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ñeñt̃ cohuam̃peneʼ yetarrpaʼ ñerraʼm esempo huac̈herra ñeñt̃ cohuam̃peneʼ carrnero ñapaʼ c̈hocmach toram̃p̃sapuerranet. Carrneropaʼ eʼñe eñoteññañet pamoʼmteʼ poʼñoñ. Ñañapaʼ oʼch c̈horeʼtyesan poʼcarrneror paʼsoʼchñopaʼ oʼch c̈haʼnmac̈haʼtatan poʼcarrneror. ");
INSERT INTO ameNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Allempoña c̈haʼnmatue allohuen aʼyot̃paʼ ñañapaʼ oʼch ota. Poʼcarrnerorñapaʼ allent̃ach cot̃aʼhuanem̃ chentaʼ. Ñetñapaʼ eʼñe chemeʼteññañet pamoʼmteʼ poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","T̃arraña ahuapñapaʼ ama cot̃eñe, c̈hach matam̃pesya t̃arroʼmar ama eñotenano ahuapña poʼñoñ. ");
INSERT INTO ameNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ñeñt̃paʼ atet̃ oterranerr fariseoneshaʼ tomaʼnteñtso t̃arraña ñetñapaʼ ama eñotoñeto ñeñt̃ otenanet. ");
INSERT INTO ameNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Allot̃ñapaʼ alla oterraneterr Jesús: —Poʼñoc̈hcaʼ notenes: Napaʼ na yetarrotets allot̃chaʼ beʼt̃en carrnero. ");
INSERT INTO ameNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Allohuen ashcañneshaʼ ñeñt̃ huapyestseʼt̃ allempo ama nohuenaʼ na, ñetpaʼ eñet̃areret ñeñt̃et aprratam̃p̃sañtetsa, t̃arraña ñetpaʼ ama eʼm̃ñotenanetoña carrnero. ");
INSERT INTO ameNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Napaʼ na yetarrotets. Ñerraʼm eseshaʼch beʼt̃ets nesho ñeñt̃paʼ queshperrach, beʼt̃erretchaʼ ñam̃a c̈haʼnerretchaʼ enterretchaʼ eʼñe cohuen puerrar. Ñehua, ñeñt̃paʼ añ otenanet: Ñerraʼm eseshaʼch ameʼñaya ña ñetñapaʼ queshperretchaʼ. Ñachña cohuam̃perrahuet eʼñe cohuen amach es pallterreto. ");
INSERT INTO ameNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Jesúsñapaʼ alla oterraneterr: —Eñet̃paʼ amacaʼye huenoña eʼñe att̃a, añecopña huena oʼch etyes, oʼch es muetsa, oʼch es aʼchencatua. T̃arraña napaʼ añecopña nohuapa att̃ochña sapaʼ corretsasach socsheñeshocmañen eʼñe t̃ayot̃eñ errponañohuen. ");
INSERT INTO ameNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Napaʼ na ñeñt̃en cohuen cohuam̃peneʼ carrnero. Ñeñt̃ eʼñe cohuen cohuam̃peneʼ carrnero ñapaʼ eʼñe ñañeña aʼrroyerrtsa oʼch rroma poʼcarrnerorecop. ");
INSERT INTO ameNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","T̃arraña poʼpsheñeñ ñeñt̃ atsaʼtaret̃tatsa att̃och cohuam̃penan carrnero ñeñt̃paʼ ama pamoʼmtayeyaye; ñañapaʼ ñerraʼm entapan maʼyarrpaʼ c̈hach mata oʼch saʼnmanña carrnero. Maʼyarrñapaʼ oʼch rromaʼyesosan carrnero, patantarrña carrneropaʼ oʼch att̃a aʼparratseʼtach. ");
INSERT INTO ameNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ñeñt̃ att̃a atsaʼtaret̃tetsapaʼ poʼñoc̈hpaʼ ama llecaʼpenanoña carrnero amaʼt mamesha. Ñeñt̃oʼmarña c̈hach saʼnmanña carrnero. ");
INSERT INTO ameNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Napaʼ na ñeñt̃en cohuen cohuam̃peneʼ carrnero. Napaʼ eʼñe nechmeʼteñ ñeñt̃ necarrneror. Ñeñt̃ña nopaʼ eʼñe chemeʼtenen nam̃a. ");
INSERT INTO ameNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Atet̃ pena Apa eʼñe eñotenen, nañapaʼ eʼñe neñoteñ nam̃a Apa. Napaʼ eʼñe nañeña oʼch naʼrroyerra att̃och nerroma necarrnerorecop. ");
INSERT INTO ameNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Eñall poʼpoñec̈hño ñeñt̃chaʼ necarrneror neperr, ñetpaʼ ama parrocmateneto arr alloʼtsen ñeñt̃ necarrneror nepen t̃eʼ. Añ poctetsa oʼch nerranetaʼ att̃och eʼm̃ñoterrnanet neñoñ, allochñapaʼ oʼch eʼñe parrocmaterret. Puesheñarrana ñeñt̃enchaʼ cohuam̃perrahuet. ");
INSERT INTO ameNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Apapaʼ ello atarr morrentenna t̃arroʼmar napaʼ naʼrroyena nañeña oʼch nerroma acheñeneshacop, elloñapaʼ oʼch alla netanterra. ");
INSERT INTO ameNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Amaʼt eseshapaʼ amach puerratam̃pesnoña nocrreña, napaʼ na ñeñt̃en aʼrroyetsa eʼñe nañeña. Napaʼ anaret̃en att̃och naʼrroya oʼch nerroma; anaret̃en ñam̃a att̃och ellopaʼ oʼch alla netanterra. Ñeñt̃paʼ Apaña noteneʼ atet̃chaʼ nep̃a. Arrpaʼ allohua atet̃ tomaʼntatenanet allohuen ñeñt̃chaʼ ameʼñerraya ñeñt̃ña poʼcarrneror pen ñeñt̃chaʼ atarr cohuen cohuam̃pen. ");
INSERT INTO ameNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ñeñt̃ att̃o serrpareʼtatenanet Jesús, allña judioneshaʼpaʼ ellopaʼtetstatenet poct̃ap̃ña Jesúsocop. ");
INSERT INTO ameNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Shonteʼ acheñeneshaʼ ñeñt̃ atet̃ otyesets: —Añmapaʼ c̈hacaʼye chorreña oneñet̃, c̈hacaʼye mospuena. Esoʼmareʼtña seʼm̃ñoteñ. ");
INSERT INTO ameNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Poʼpotantañec̈hnoñapaʼ ñetpaʼ atet̃ otyenet: Ñerraʼm c̈ho chorreña oneñet̃paʼ amat̃eʼ errot̃enot̃ eñosoña atet̃ eʼñe cohuen. Oneñet̃paʼ amat̃eʼ errot̃enot̃ cohuaterranoña aporoʼyet̃. ");
INSERT INTO ameNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Allempoñapaʼ c̈herrerr allempo alla cosherrerr judioneshaʼ Jerusaléño allempoch yerpuerret ñeñt̃ att̃o neteʼt̃ ahuat̃ Parets paʼpaquëll ñocop. Allempo alla cosherreterrpaʼ allempopaʼ huapo. ");
INSERT INTO ameNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesúsñapaʼ alla chopeñen Parets paʼpacllo all oteñet Salomón puechaʼpetaro. ");
INSERT INTO ameNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Allñapaʼ arrotam̃pesya judioneshaʼpaʼ atet̃ ochet: —Esempohuachñacaʼye peʼnuaña ñeñt̃ att̃o pemoññeʼtatenya. Ñerraʼm poʼñoc̈ht̃eʼ p̃a Cristotetspaʼ p̃oteyñacaʼye eʼñe poʼñoc̈h. ");
INSERT INTO ameNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesúsñapaʼ atet̃ otanet: —Amaʼt notatstas sapaʼ amachcaʼ sameʼñaʼno. Napaʼ eʼñe neyemteñot̃ Apa atet̃ es nep̃aʼyen. Ñeñt̃ norrtatyenpaʼ ñeñt̃chaʼña señotateʼ napaʼ ñeñt̃en Cristotets. ");
INSERT INTO ameNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","T̃arraña sapaʼ ama sameʼñenno t̃arroʼmar sapaʼ ama necarrneroreyayso ñeñt̃ atet̃ oʼ notuas. ");
INSERT INTO ameNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ñeñt̃ poʼñoc̈h necarrnerorpaʼ eʼm̃ñotennanet neñoñ, nañapaʼ neñotenanet. Ñetñapaʼ cot̃ennet. ");
INSERT INTO ameNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nañapaʼ napuerranetchaʼ att̃ochña ñetpaʼ corretsetach t̃ayot̃eñ errponañohuen, ñetñapaʼ amaʼt ahuat̃apaʼ amach chenquërreto. Amaʼt eseshapaʼ amach puerraterrnetoña eʼñe na notot̃. ");
INSERT INTO ameNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nomporpaʼ ña napueneʼña ñeñt̃ nameʼñenaya. Ñapaʼ atarr ahuamencat̃eshaʼ. Ña poʼhuamencpaʼ ama eseshayeʼ metanenaye. Amaʼt eseshapaʼ amat̃eʼ errot̃enot̃ puerratam̃p̃setoña Nompor eʼñe ña potot̃. ");
INSERT INTO ameNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Napaʼ eʼñe parro att̃ecman epan ña. ");
INSERT INTO ameNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ñeñt̃oʼmarña allempo judioneshaʼ ñetpaʼ chetet mapueʼ alloʼch rrolleʼchet. ");
INSERT INTO ameNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesúsñapaʼ atet̃ oterraneterr: —Shonteʼ coc̈hneshaʼ norrtatyesonas Nompor poʼhuamencot̃. ¿Erraʼtsenot̃eʼtña añ ñeñt̃ eʼñe coc̈hnesharot̃ sapaʼ semneñ oʼch sarrollaʼn? ");
INSERT INTO ameNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Judioneshaʼñapaʼ atet̃ otereterr: —Ama p̃orrtateñot̃eyeʼ coc̈hneshaʼ yemneñe oʼch yarrolleʼtap̃. Yapaʼ añecopña yemneñ oʼch yarrolleʼtap̃ att̃o p̃apaʼ atarr p̃achm̃areʼteñ Parets. P̃apaʼ acheñot̃acaʼye pemneñ oʼch pepartsocoptarta. ");
INSERT INTO ameNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesúsñapaʼ alla oterraneterr: —Ñoñets ñeñt̃ atet̃ anaret̃ ahuat̃ot