﻿USE sofia;
DROP TABLE IF EXISTS sofia.aly_vpl;
CREATE TABLE aly_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES aly_vpl WRITE;
INSERT INTO aly_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Awank-akerr, Akngeyel alker-then ahern-then arrpmernek. ");
INSERT INTO aly_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Kwaty alayelant ahern ingkerrenh artenh. Ingwemerntarl ingkerrenh-angkwarr ayntenh. Akngeyel awer ilkwa tyarlewek. Akngey-kenh Itnweng rtnenh. ");
INSERT INTO aly_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Akngey angkek, “Arrtyernerl-aynta!” Rap arrtyernenhey-alhek-anem. ");
INSERT INTO aly_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Akngeyel arek mwerr arrtyernenhey-alhek. Akngeyel ingwethen arltethen amentant-atherr arrpmernek. ");
INSERT INTO aly_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Akngeyel itnewek “Arlta.” Kel ra akethirrenhek. Ingwer Akngeyel itnewek “Ingwa.” Arlta arrwekel anyent ikwerel, atwerrpirrenhek. Ingwemernt-anem irrek. Ingwel-anem. Ikwer-they angkep arrpemarl ra akethirrenhey-alhek. ");
INSERT INTO aly_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Akngey angkek, alker ampep-warl arrkngert rnkernetyek, kwaty alay amentant-atherriletyek. Kel alakenh-anyem. ");
INSERT INTO aly_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Kwaty ingwer irrwerl, kwaty ingwer kwaty kweneng. ");
INSERT INTO aly_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Akngeyel arrkngert renh itnewek “Alker.” Ikwer-they angkep arrpemarl ra akethirrenhey-alhek. Ingwirrek arrpemarl. Arlta 2 ikwerel, kel ingwepenh-anem irrenhek. ");
INSERT INTO aly_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Akngey angkek ahern-then kwaty alay-then amentant atherriletyek, ahern artwerretyirrey-kety. Kel ahern aremirrek. ");
INSERT INTO aly_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Akngeyel itnewek ahern-then kwaty alay-then. Akngeyel arek rarl mwerr-angkwarr arrpmernek. ");
INSERT INTO aly_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Akngey angkek atherrk-then arwerl amern-akert-then atherrk ntang-akert-rnem-then rnkernetyek. Kel alakenh-anyem. ");
INSERT INTO aly_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Arwerl ingwerek-ingwer-then ntang ingwerek-ingwer-then Akngeyel arrpmernek. Akngeyel arek ingkerrenh-angkwarr, rarl mwerr-angkwarr arrpmernek. ");
INSERT INTO aly_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ingwirrek arrpemarl. Arlta 3 ikwerel, kel ingwepenh-anem irrenhek. ");
INSERT INTO aly_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Akngey angkek “Ingkenyel arrtyernetyek arltel, ingwel arrtyernetyek alkentel.” Arltethen ingwethen amentant-atherr ra anthek. Ratherr aherrety-then alyangkw-then ament-atherr arrpemarl ra anthek, rernem iterl-arayntetyek ilenger rernem akarrirretyek. ");
INSERT INTO aly_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","16","Akngeyel arrernek atherrap-antey, ikngwer arrernek ra artewentyel arrtyerney-angker arltel. Akngeyel antyarr akngerr arrernek. ");
INSERT INTO aly_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Alkent ra arrernek alyeparl arrtyernetyek ingwel. Alkent-then ingkeny-then ra arrernek, ingwethen arltethen akngaketyek. Akngeyel arek ingkerrenh-angkwarr, rarl mwerr-angkwarr arrpmernek. ");
INSERT INTO aly_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ingwirrek arrpemarl. Arlta 4 ikwerel, kel ingwepenh-anem irrenhek. ");
INSERT INTO aly_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Akngey angkek kwaty alayek, atnwenth ingwerek-ingwer ikwerel anayntetyek. Rap angkek thip ingwerek-ingwer alkerel alhayntetyek. ");
INSERT INTO aly_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Akngeyel arrpmernek kwaty-areny ingwerek-ingwer kwaty alay kwenel anayntetyek, akely-rnem-then, ilkwernem-then. Akngeyel arrpmernek thip ingwerek-ingwer alkerel alhayntetyek. Akngeyel arek ingkerrenh, rarl ingkerrenh mwerr-angkwarr arrpmernek. ");
INSERT INTO aly_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Akngeyel renh-rnem ilek, “Akngerram-akngerrirretyek, arlperrtyirremel kwaty alay-angkwarr ingwer-rneman alker-angkwarr ingwer-rneman.” ");
INSERT INTO aly_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ingwirrek arrpemarl. Kel ingwepenh-anem irrenhek, arlta 5 ikwerel. ");
INSERT INTO aly_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Akngey angkek, “Ahern ikwer-penh atnwenth ingwerek-ingwer akngerrirretyek, ateralth-rnem-then, mwerr-rnem-then, ahernel alheyel-rnem-then.” Kel alakenh-anyem. ");
INSERT INTO aly_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Akngeyel atnwenth ingwerek-ingwer arrpmernek, atnwenth ateralth ingwerek-ingwer, atnwenth mwerr ingwerek-ingwer, ahernel alheyel ingwerek-ingwer. Akngeyel arek ingkerrenh, rarl ingkerrenh mwerr-angkwarr arrpmernek. ");
INSERT INTO aly_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Akngey angkek, “Ahern-areny arrpmernetyek rernem anetyek anwantherr-apeny, rernem Atyetyart anetyek kwaty-areny ingkerrenhek, thip ingkerrenhek, atnwenth ingkerrenhek, atnwenth mwerr-rnemek-then, atnwenth ateralth-rnemek, ahernel alheyel-rnem-then.” ");
INSERT INTO aly_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Akngeyel arrpmernek artwethen arelh-then, ratherr rapeny anetyek. ");
INSERT INTO aly_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Akngeyel ahern-areny ilek akngerrirretyek, ahern ingkerrenh-angkwarr, apmer arrpanenhel. “Arrantherr atyetyart anetyek, ahern ingkerrenhek, irrpeng ingkerrenhek, thip ingkerrenhek, atnwenth ingkerrenhek.” ");
INSERT INTO aly_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ikwer-penh Akngeyel renh-rnem ilek, “Atha arrenhantherr anthem, amern-rnem-then arwerl ntang-akert-rnem-then, arrantherr arlkwetyek. ");
INSERT INTO aly_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Atnwenth ahern-areny-rnem-then, thip alker-areny-rnem-then, ahernel alheyel-rnem-then. Ahern-areny ingkerrenhek, atha amern-rnem-then atherrk-rnem-then anthem.” ");
INSERT INTO aly_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Akngeyel ingkerrenh arek, rarl mwerr-angkwarr arrpmernek. ");
INSERT INTO aly_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Alker-then ahern-then ingkerrenh anenh. ");
INSERT INTO aly_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Arlta 7 ikwerel-antey Akngeyel warrk ikwerenh ywerrelhilek. Ltyerrek-anem. Ra ipmelhek-anem. ");
INSERT INTO aly_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Akngeyel arlta 7 anyentan akngakek ltyerrey-angker, impenan arlta ikwerel ra ltyerrenh. ");
INSERT INTO aly_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Alakenh-anyem Akngeyel alker-then ahern-then ingkerrenh arrpmernek. ");
INSERT INTO aly_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Lyertenyenp, alker-then, ahern-then Akngey INGKART ra arrpmernek-penh arwerl-weny, atherrk-weny. Kwaty ra thweney-angenh-antey ahern-warl, ingwer aney-angenh-kety amern lyapelheletyek. ");
INSERT INTO aly_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Kwaty apeynt lherrparnpenh ahern-they. Ahern-anem ra apelyilek. ");
INSERT INTO aly_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Akngey INGKARTel ahern-anem inek, artwa anyent-anem mpwarek ahern-penh. Ra ahern-areny renh itethilek-anem, pewilemel. Awer-anem anthek. Ahern-areny ra itethirrek-anem, weyangkemel. Iteth-anem irrek ra. ");
INSERT INTO aly_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Akngey INGKARTel akngerrakw-ampenyek arwerl ilek-ilek-anem rnkernek, apmer itnan Eden. Artwa renh-anem ra arrernek apmer ikwer-itwek. ");
INSERT INTO aly_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Arwerl ilek-ilek rnkernek ra, arwerl lyapelemel, amern-akert-rnem-then. Arwerl atherr apmer ampep-itwek lyapek. ");
INSERT INTO aly_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Arwerl ingweran mwerr itethiley-angkerarl, arwerl ingweran akalty-anthey-angker. Amern ntwa arlkwenty arwerl ikwer-penh nga apmwek-then mwerrek-then akaltyirrem, atherr-angkwarr-antey. Apmer Eden-they kwaty atnyerr ankalhenh, arwerl-rnem atherrkenyil-ayntetyek. Lher anyent-they ra irrpety-anem irrek, irlkwenty-anem. ... ");
INSERT INTO aly_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Akngey INGKARTel artwanem amern-angketyarr ikwer-itwek arrernek, ra arntarnt-arayntetyek. ");
INSERT INTO aly_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Akngey INGKARTel renh ilek, “Arwerl ingwer-rnem-itwek ntwa arlkwayntetyek. ");
INSERT INTO aly_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Arwerl ingwer apmwek-then mwerrek-then akaltyirreyel, menty arlkwey-angenh. Ntwa arwerl yanh-penh arlkwentyan, nga arlta ikwerel-antey ilwem.” ");
INSERT INTO aly_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Akngey INGKART angkek, “Ahern-areny anyent anerl-anekerr, atha ilkwatherr ikwer mpwarey.” ");
INSERT INTO aly_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Akngey INGKARTel ahern-anem inek arrpemarl, ra atnwenth ilek-ilek, thip ilek-ilek-anem mpwarek ahern-penh. Ra artwewarl akngetyek, ra itna renh-rnem itnewetyek. ");
INSERT INTO aly_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ahern-areny ranem itneweynek atnwenth ateralth-rnem-then, mwerr-rnem-then, thip-rnem-then, ingkerrenh-antey. Alakenh-anyem ahern-arenyel itnewek-penh itnakert ingkerr-anem rernem anek. Ahern-areny ament-areny ilkwatherr-weny anenh, atnwenth rernem ament anenh arrpemarl, ingwer-lkwer. ");
INSERT INTO aly_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","22","Akngey INGKARTel ahern-areny renh ankwayntetyek athenek. Artwa ra apelp-anem ayntek. Artwa ikwer-penh ngkerraly anyent ra inek. Renh ampwerrkileynek, ra arelh-anem ikwer mpwarek ilkwatherr, ngkerraly anyent-penh. Akngey INGKARTel arelh renh atnwenhek artwa ikwer-warl. ");
INSERT INTO aly_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ra arek-penh arelh renh, ra angkek, “Nhenh atyeng-apenyarl, nhenh arlka atyeng-penh, ngkwern atyeng-penh arnwarnekarl. Atha renh itnewem ‘arelh’, ra atyeng-penh artwepenh arnwarnekarl wenh!” ");
INSERT INTO aly_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Aleyarl alakenh aynteyel ra. Artwa anyentel aynikw-then amikw-then iwerl-alhem. Ra arelh ikwer-itwek itengirrem, anyent-apeny-antey ratherr aynteyel. Alakenh-anyem Akngey INGKARTel arrernek. ");
INSERT INTO aly_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Arrwekeleny ratherr arnkweweny anenh, nyerrirrey-angenh-antey. ");
INSERT INTO aly_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Rtnwem anyent anenh Akngey INGKARTelarl arnwarnek, irrtywerremel apmwangkwarr iley-angker. Apmwarlap ran atnwenth ingkerrenh-angkwarr. Arlta anyentel ra alhek arelh-warl. Ra ayernek, “Mpwelenhanth apek ilek Akngeyel, arwerl anyent-penh mpwelanth amern arlkwey-angenharl wenh, mentyarl aretyek?” ");
INSERT INTO aly_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Arelh ra angkek, “Akngeyel ilek, ‘Arwerl ingwer-rnem-penhant arlkwetyek. ");
INSERT INTO aly_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Arwerl anyent-penh nthakenh mpwelanth amern akey-angenh amern-angketyarr ampep-itwek. Mpwelanth arwerl ikwer-penh arlkwenty, mpwelanth ilwemarl.’” ");
INSERT INTO aly_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Rtnwem ra irrtywerremel ilek, “Mpwelanth nthakenh ilwey-angenh arwerl ikwer-penh amern arlkwenty. ");
INSERT INTO aly_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Akngey akalty, arlta ikwerel mpwelanth amern arlkwenty, Akngey rapeny mpwelanth anem, akalty-anem, apmwangkwarr-then mwerr-angkwarr-then.” ");
INSERT INTO aly_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Arelh ra amern renh arek. Amern ra mwerr-angker innga. Ra ilkelhenh, amern arlkwenty-penh Akngey rapeny akalty-anem anetyek. Amern renh akek, arlkwemel-anem. Arelh ra artwanem anthek, ratherr atherrel-antey arlkwek amern renh. ");
INSERT INTO aly_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ratherr iterl-arek ratherrarl Akngeyek awelhey-angenh. Angath-antey ratherr apmwelhelekan. Ratherr iterl-arelhek-anem, ratherr arnkweweny-anem anenh. Arwerl tywerrk aylpepenh ratherr arnkwa atanthenh pweytilemel, aylpemel-anem. Artelhenh-anem ratherr. ");
INSERT INTO aly_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ikwer-penhan alherrp ratherr awek, amern-angketyarr ikwer-itwek Akngeyarl alhenh. Ratherr aterirremel arwerlel arlengkewelhek Akngey ikwerety. ");
INSERT INTO aly_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Akngey INGKART artwa ikwer arlkek, “Nthenh-angkwarr nga?” ");
INSERT INTO aly_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Artwel renh ilek, “Ayeng arnkweweny arlengkewelhek ngkwengety, nyerr-anem irrek.” ");
INSERT INTO aly_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Akngey INGKART angkek, “Nthakenh mpwelanth iterl-arelhek, mpwelanth arnkweweny anenhan? Ntwa amern-angketyarr ampep-itwek arwerl anyent-penh arlkwek apek?” ");
INSERT INTO aly_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Artwa ra angkek, “Arelhel amern akek, rap ayenh-anem anthek, athanem arlkwetyek, arelh yanhel ntwarl ayenh anthekarl.” ");
INSERT INTO aly_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Akngey INGKARTel arelh renh ayernek, “Arwerl ilek-penh ntwa arlkwek?” Arelh ra angkek, “Rtnwemel ayenh irrtywerl-ampernek wenh! Ikwer-penh atharl arlkwek.” ");
INSERT INTO aly_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Akngey INGKARTel rtnwem renh ilek, Ntwa arelh renh irrtywerl-ampernek-penh, nga atnertel artnerrerl-apem ahern-penh arlkwerl-aperl-anem. Atha ngenh anyent apmwewarlilem intem-antey. ");
INSERT INTO aly_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","“Arelh nhayman ngkwengety arlkarirrem. Arelh-kenh-rnem-then ngkwenh-rnem-then ilkelhey-angenh intem anayntem. Arelh-kenhel-rnem ngenh akapwert atwayntem, ngkwenh-rnemel ingkan tnhwayntem.” ");
INSERT INTO aly_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Akngey INGKARTel arelh renh ilek, “Nga ampakert rlterrk anayntem. Nga artwa ngkwenhek aleth ilkelh-ayntem. Artwa Atyetyart-anem ngkwenh anayntem.” ");
INSERT INTO aly_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Akngey INGKARTel artwa renh ilek, Nga arelh ilenhek awelhek, ntwa amern-anem arlkwek. Atha weth ngenh artwerilek arwerl ilenh-penh amern ntwa arlkwekerr. Nga atyeng awelhey-angenh. Ahern yanh apmwanem, amern rnkernayntetyekan. Nga warrkirretyek artewentyel amern intwelheletyek, nga ilwetyek-atwety. ");
INSERT INTO aly_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Atherrk apmwethen intwayntem. Ntwa amern-angketyarr ikwer-penh amern arlkwey-angenh. ");
INSERT INTO aly_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","“Ntwa artewentyel warrkirretyek amern ngkwenhek. Nga ahernirreyenh ilwenty-penh. Ahern-penh atha ngenh arnwarnek. Nga angkep ahern arrpemarl irreyenh. Ngan ahern arwarl.” ");
INSERT INTO aly_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam-el arelh ikwerenh itnewek Eve. ");
INSERT INTO aly_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Akngey INGKARTel arnkwanem ikwer-atherr mpwarek, atnwenth yenp-penh. ");
INSERT INTO aly_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Akngey INGKARTel ilek, “Ratherr iterl-areyel apmwangkwarr-then mwerr-angkwarr-then, atharl iterl-areyel-apeny. Amern-angketyarr yanh-they ratherr alpetyekant-anem. Ratherr arwerl yanh itethiley-angker-penh ratherr arlkwey-angenh anetyek. Ratherr arlkwenty-penh, ratherr intem-antey iteth anekerr.” ");
INSERT INTO aly_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Akngey INGKARTel renh-atherr aketh-warl-anem irrentek, apmer ingwer-warl-anem ratherr alpek. ");
INSERT INTO aly_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Aympelh-akert-rnem akngerrakw-ampenyek arrnkngert rnkernek arwerl ikwerety. Nayp arlpenty Akngeyel rnkernek, ikwer-atherr-itwek. Nayp arlpentyel ampep-they arrtyernenh. Aympelh-akert rernem akwerrelant arrkngert rtnek, ratherr angkep alpekerr, arwerl ikwer-itwek arlkwekerr, amern-angketyarr ampep-itwek, ratherr intem iteth anekerr. ");
INSERT INTO aly_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam-then Eve-then ratherr awey akely atnyenek. Awey akely ikwerenh itnan Cain. Eve angkek, “Atha renh itnewey Cain, INGKARTelarl awey akely ayenh anthek.” Itna Cain angka ikwerenh-angkwarr aynteyel, “INGKARTel ampa anthek INGKART-they renh inek.” ");
INSERT INTO aly_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ikwer-penhan, Eve ra awey ingwer-anemarl atnyenek. Amelikw renh itnewek Abel. Ratherr ilkwerrek-anem. Abel yep-yep arntarnt-arenh-arenh, Cain ran amern atherrkarl ingwerek-ingwer lyapelhelenh. ");
INSERT INTO aly_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ingwer-ingeran Cain ra amern INGKART-anemarl tyenkerr anthek. ");
INSERT INTO aly_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel ra yep-yep akwerrk atwemel, INGKART ra tyenkerr anthek arrpemarl. Yep-yep akwerrk lyertenyankarl atnyenek. Abel-el aker atwek, ra INGKART renh tyenkerr anthetyek. Aker ikwer-penh ra tyelk mwerr-rnemant rlwanemel INGKART renh tyenkerr anthetyek, mpwerrkenty anter-akngerr. INGKART Abel ikwerant inkwerelhek, renharl ra tyenkerr anthekek. ");
INSERT INTO aly_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Cain-ekan ra inkwerelheyangarl. Cain ra artwerrety-anem anenh, ahelirremel. ");
INSERT INTO aly_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","INGKARTel Cain renh ilek, “Ilekek ngarl aneyel artwerretyan? ");
INSERT INTO aly_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ntwarl ayenh tyenkerr arraty-angkwarr anthek-penh, ngarl irrkngerney-anem anetyek. Ngarl mwerr-angkwarr anem, ngap irrkngerneyarl aneman. Ngarl mwerr-angkwarr anem, ngap irrkngerneyarl aneman.” INGKARTel renh ilek, “Ngap apmwelhelekerr, nga mwantyel iterretyek.” ");
INSERT INTO aly_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Cain-el ayteyikw ikwerenh irrtyelherl-alhek, “Mpa, ayla awangk alhey arrkent, peleyn ilkwewarl.” Irrtyelherl-alhek ratherr arrkent alhetyek-arrpantey irrtywerremel, renh ra atnwenhek akwerr-warl, ra atwey-alhetyek renh. Cain-el renh atwek, ipmek-antey. ");
INSERT INTO aly_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","INGKARTel Cain renh ayernek, “Abel-alew? Ayteyengkw ngkwenh-alew?” Cain-el renh irrtywerremel tyernek, “Inpa, ayeng arlarl.” ");
INSERT INTO aly_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","INGKARTel renh ilek, “Ntwa atwek ayteyengkw ngkwenh. Arrknga thelhelek ikwer-they ahern-warl. Atha ngenh apmer nhethey irrentem, ntwarl ayteyengkw atwek, rarl arrknga thelhelek apmer nhel. ");
INSERT INTO aly_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ahern nhekan amernan nthakenh ntwa intwelheleyang-anemarl. Arrkngarl ayteyikw thelhelek-kety.” ");
INSERT INTO aly_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","INGKARTel renh ilek, “Nhenhekan amern atherrk intwelheley-angenh. Apmer nhelan nga aney-angenh-anemarl arrangkw. Nga alhayntant-anem.” ");
INSERT INTO aly_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","14","Cain-el renh ilek, “Ntwa atyeng angka awerr arrernek. Apmer nhetheyarl apmer ingwerel-anem ayeng anayntem. Apmer-wenyengarl ayenh ingwerentyel atwetyek alhewer, mentyan.” ");
INSERT INTO aly_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","INGKARTel renh ilek, “Ingwerel ngenh atwenty, atha renh arntety anthem. Ingwerel ngenh atwekerr, atha ngkweng-warl impaty arrernem.” ");
INSERT INTO aly_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Apmer Nod-warl ra alpek, Eden-they akngerrakw. Cain aney-alpek intem-antey INGKART ikwerety, angkepirreyang arrangkw, ikwerenh-rnem-warl. Ingwer-kenh apmer-itwek aney-alpek. ... ");
INSERT INTO aly_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","... Akngeyel arek, apmwangkwarr ahern-areny ingkerrenh anenh. Rernem apmwangkwarrant iterrenh. ");
INSERT INTO aly_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","7","Ra iterrek renh-rnem ingkerrenh ywerrelhilemel atwetyek, atnwenth-rnem-then, thip-rnem-then, ahernel alheyel-rnem-then. Artwa apmwangkwarrarl aneyel-rnem-then ingkerrenh ywerrelhiletyek. “Atha renh-rnem mpwarey-angenh, atyeng awelhey-angenh-rneman. Ra iterrenh, apmwel renh-rnem mpwarekerr.” ");
INSERT INTO aly_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Akngey inkwerelhek artwa Noah ikwer, rarl ikwer inkwerelhemel awelhek rarl renh ilekek. ");
INSERT INTO aly_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Noah ra anyentant mwerran Akngey ikwer awelhek. Alerikw irrpety ikwerenh-rnem itnan ikwer-rnem-kenh Shem, Ham, Japheth. ");
INSERT INTO aly_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Akngeyel ingkerrenh iterl-arek, rernemarl apmwangkwarr anenh. ");
INSERT INTO aly_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Akngeyel Noah renh ilek, “Ahern nhel artwa ingkerrenh ahelant atwerreyel, mwerr aney-angenh. Atha ahern-areny ingkerrenh irrarlkeyenh ahern nhek. ");
INSERT INTO aly_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Arwerl mwerr-angker arterna, ntwa rtnwa arnwarnetyek warl-akert. Warl arnwarnetyek amentew-ament rwem-akert. Ankerel aperna kwen-then akwerr-ampeny-then. ");
INSERT INTO aly_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Arlpenty innga mpwara 130 metres-ek-atwety. Arlpaw innga mpwara, 25 metres-ek-atwety. Irrwerl innga mpwara, 15 metres-ek-atwety. ");
INSERT INTO aly_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Arwerl ilperr-ilperr-rnemarl irrwerlengan arrerna! Anker-anem aperneyna kwaty aylpekerran. Altywerarl ntwa arrernetyek arriwan ampepekan. Iwerr ingwer-ampenyek arrerna aylpenhey-alhayntetyek. Rwem irrpety irrwerl-akert mpwara! ");
INSERT INTO aly_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Atharl kwaty ilkwa tyarlewem-kety, ahern-areny ingkerrenh irrarlketyek. ");
INSERT INTO aly_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Atha ngenh innga ileyel, nga, anew ngwenh, alerengkw ngkwenh-rnem, ampengkw-rnem-then arrantherr rtnwa ilenhel arrantherr iteth anetyek, kwaty-kety. Ingkerrenh aker-rnem tywena, atnwenth-rnem-then, thip-rnem-then, ahernel alheyel-rnem-then. ");
INSERT INTO aly_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Atnwenth amarl-rnem-then irrwey-rnem-then anewart-anewart akngakeyna, rtnwewarl tywenemel. ");
INSERT INTO aly_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Amern akngerr-antey arrerna ikwer-rnem ngkweng-then. Ayeng ilkelheyel rernem iteth intem-antey anetyek.” ");
INSERT INTO aly_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noah Akngeyek awelhek, rarl renh ilanthek. ");
INSERT INTO aly_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","18","INGKARTel Noah renh ilek, “Rtnwewarl aylpa, ngkwenh-rnem-akert. Atha ngenh iterl-areyelarl, mwerrarl ngan atyeng awelheyel.” Kel arlta ikwerel-antey Noah-rnem rtnwewarl aylpenhek, Shem, Ham, Japheth. Ingkerrenh-antey rernem aylpenhek rtnwa ikwer-warl, anewikw-rnem-anem alerikw-rnem-anem. Noah ikwerenh-rnem-akert aylpenhek rtnwa kwen-warl. Aker ahern-areny ingwerek-ingwer rernem akwernek rtnwewarl, atnwenth ateralth-rnem-then ingkerrenh, thip-rnem-then akwernek rtnwa ilkwa ikwer-warl. Anewart-anewart irrwey-rnem-then amarl-rnem-then ingwerek-ingwer atherrarl-atherrarl akwernek rtnwa kwen-warl, Akngeyelarl renh-rnem ilanthek. Ingkerrenharl ahern-areny renh-rnem tywenek. INGKARTel rtnwa arriw ikwer-rnemenp akentek. Kwaty apeynt ikwer-they irrwerl-anem irrwerl-anem lherrparnpek kwen-they. Akngeyel alker renh altywerilek. Kwaty thelhelek alker-they, arlta 40-ek-atwety, ingwa 40-ek-atwety. Kwaty rntwek arlta arrpanenhel. Kwatyan kwen innganem. Kwaty atnyerrel rtnwa ilkwa irrwerlilek, irrwerl-anem irrwerl-anem. Apwert ingkerrenh kwatyel kwenek. Kwatyel rtnwa irrwerlilek ikwer-rnemenp. Ahern-areny ingkerrenh kwatyel ilwerl-athenek. Apmer arrpanenhel anenh-rnem, atnyerrel ingkerrenh ilwerl-athenek. Akngeyel ingkerrenh apmer arrpanenhek irrarlkek ingkerrenh kwaty atnyerrel. Irrpetyap rtnwa ilkwelarl anek-rnem rernemant iteth anenh. Noah rant ikwerenh-rnem-akert iteth anek. Kwaty rtnenh aleth arlta 150-ek-atwety, arlta arrpanenhel. ... ");
INSERT INTO aly_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Akngey ra iterl-antey-areyel, iylpelerleweyang New-rnem-then atnwenth-rnem-then. Akngeyel awer tyarlewek. Kwatyarl akelyirreynek ahern ingkerrenh artwerretyiletyek. Kel alakenh-anyem Akngeyel awer thwenek. ");
INSERT INTO aly_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Akngeyel arrkngert arrernek, kwaty ahern-they thelhelenhek. Akngeyel kwaty apeynt ywerrelhilek. Akngeyel kwaty alker-areny ywerrelhilek arrpemarl. ");
INSERT INTO aly_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Arlta 150-penh kwaty akelyant-anem ahernel rtnenh. Alkent 5-ek-atwety kwaty ra akely-anem irreynenh. ");
INSERT INTO aly_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Kwatyarl atnyerr ywerrekel, rtnwa ilkwa ra Ararat apwertel-anem arrernelhey-alpek. ");
INSERT INTO aly_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Alkent 10-penh apwert ingkerrenhan akethel-anem arem-anemirrek. Alkent 10-ek-atwetyarl rtnek-penh kwaty akelyirrek. ");
INSERT INTO aly_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","7","Alkent anyent-penh Noah-el iwerr tyet altywerilek, ra aretyek. Noah-el thip anyent irrpwerl angerl thwenek. Noah arntarnt-arelhenh thip ikwer ra apey-alpentyek. Ahern artwerretyirreyek-atwety thip alkerel-antey alhenh. Alkerel-antey ra amperelenh, kwaty-antey ra arenh. ");
INSERT INTO aly_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Kwaty ywerreynentyek Noah ra thwenek thip pwelker-anem, kwaty ywerreynentyek ra aretyek. Thip anyent ra arrernelhetyekan ikwer arrangkwarl. ");
INSERT INTO aly_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Kwatyantarl ayntek. Ra apey-alpek arrpemarl, rtnwa ilkwa ikwer-warl. Noah-el thip anyent renh anterrkwey-ayntek, kwen arrpemarl akwernemel rtnwa ilkwa ikwer-warl. ");
INSERT INTO aly_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Arlta 7-penh, Noah-el pwelker anyent renh arrpemarl thwenek. ");
INSERT INTO aly_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Thip ra apey-alpek atwerrp, alperr anyent-akert-anem. Noah ra arek kwatyarl ywerr-anemirrek. ");
INSERT INTO aly_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Arlta 7-penh pwelker renh thwenek arrpemarl, ra arlta ikwerel apey-alpeyang ywerrey-alhek. ");
INSERT INTO aly_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noah-el iwerr altywerilek-anem, rtnwa ilkwa renh ahern artwerretyirrenty aretyek. Ra arek ahernan atwerrety-anem. Noah-el arek kwatyarl kel-anem ywerreyneyel. ");
INSERT INTO aly_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Alkent atherr-penh ahernan ingkerrenh-angkwarr artwerrety-anem. ");
INSERT INTO aly_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","16","Akngeyel Noah renh ilek, “Ngan ngkwenh-rnem-akert tyerr-anemelha, rtnwa ilkwa ilenh-theyan. ");
INSERT INTO aly_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Atnwenth ilenh-rnem-then thip-rnem-then ahern alheyel-rnem-then ingkerrenh tyarlewa rernem akngerr arrpemarl irretyek ahern nhel.” ");
INSERT INTO aly_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Noah rernem-tangkwel atwarrek rtnwa ilkwa ikwer-they. ");
INSERT INTO aly_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Atnwenth ingwerek-ingwer ingkerrenh atwarrek rtnwa ilkwa ikwer-they, amentew-ament. ");
INSERT INTO aly_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noah-el apwert ilperr-ilperr arrernek, aker ampernetyek. Noah-el tyenkerr INGKART renh anthek, kwenirremel angkek. ");
INSERT INTO aly_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Akngeyel aker intenek mwerr-angker ikwakert. Rernemarl apmwel-areth aneyelek, ampa akely-penh, atha ahern apmweley-angenh-anem. Akngeyel renh ilek, “Atha ahern-areny-rnem nthakenh atwey-angenh weth atha atwek-apeny, menty-anem. Anyent-inger-antey athan irrarlkek. Akely-penh apmwangkwarr alkenhirreyelan, awaretyel. ");
INSERT INTO aly_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Atha ahern-areny ingkerrenh atwey-angenh-anem. Ahern nhenh intem-antey aynteyenh. Rernem amern lyapelheletyek, amern akwetyetyek. Ahern nhenh ywerrey-angenh arltel, ingwel, aherretyel, alyangkwel ywerrey-angenh. Ahern nhenh aherretyel ywerrey-angenh, ahern nhenh ingwel ywerrey-angenh. Ahern nhenh intem aneyenh ahern nhenh ywerreyek-atwety.” ");
INSERT INTO aly_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Akngeyel Noah renh ilek, alerikw ikwerenh-rnem-akert, “Ampa akngerr atnyena ahern nhel, thip-rnem-then, ahernel alheyel-rnem-then, aker irrpeng-then. Ahern nhel akngerrirretyek ampa akngerr anetyek. ");
INSERT INTO aly_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Atnwenth ingkerr arrekantherrety ater irrayntem aneyenh, ahern nhel. Nga ingkerrenhek Atyetyart aneyenh. Atha ngenh arrernem Atyetyart nga anetyek, ahern-areny ingkerrenhek. ");
INSERT INTO aly_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Aker ntwa alhewer arlkwetyek, ingwerek-ingwer. Atha ngenh atnwenth ingkerrenh anthem, ntwa arlkwayntetyek. Kel, atha ngenh anthek amern ntwa arlkwayntetyek. ");
INSERT INTO aly_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Aker menty, arrkngewenyirremel ayntey. Iteth-antey, ra arrkngakert-anteyarl atnwenth ran. Nthakenh arrngeynp arlkwey-angenh. Arrknga thela ahern-warl, artwerretyilemel, aker arlkwey-alenty. ");
INSERT INTO aly_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Atnwenthel artwa anyent ipmek atwenty, artwa ingwerel ipmek arrpemarl atnwenth renh atwetyek. Artwa anyentel artwa ingwer ipmek atwenty, ipmek arrpemarl atwetyek. ");
INSERT INTO aly_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Artwa ingwerel atwem, angkep renh atwenhey arrpem. Atha ahern-areny ingkerrenh arrpmernek, atyeng-apeny ingkerrenh anetyek. ");
INSERT INTO aly_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ntwa akngerr-anem ahern nhel ngkwenh-rnem atnyena! Artwa akngerr ntwa anetyek, ahern nhel artwa akngerrirretyek.” ");
INSERT INTO aly_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Akngeyel Noah ikwerenh-rnem-akert ilek, ");
INSERT INTO aly_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","11","“Atha arrenhantherr ilem, Nhepenh-anyeman kwaty arrekantherr-warl atha tyarleweyang-anem, menty. Kel anyent-inger atha kwaty ilkwan tyarlewek, ingkerrenh atwetyek, ingkerrenh ahern nhek irrarlketyek. ");
INSERT INTO aly_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Mpwelarr ilkwa alkerek atha arrekantherr arrernem. Mpwelarr arrantherr alker-itwek aremel, arrantherr iterl-aretyek wetharl atha arrenhantherr ilek-angkwarr. ");
INSERT INTO aly_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Kwaty kwenpayel mpwelarr aremirrenty atha iterl-aremel atharl weth arrekantherr ilek-angkwarr. ");
INSERT INTO aly_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Nthakenh atha atnyerr ilkwel atwey-angenh ywerrelhilemel aleth-antey. Yanh-angkwarr atha ilek, nthakenh atwey-angenh. ");
INSERT INTO aly_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Atharl arem mpwelarr alker-itwel aremirrenty, atha iterl-aremarl atharl weth arrenhantherr ilerlelpek-angkwarr. ");
INSERT INTO aly_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Mpwelarr lwewarrernelheyel alkerel apmelerrarl atharl weth ilerl-alpek-angkwarr, arrantherr iterl-aretyek. Ilenh atyetyart impen anwantherr iterl-aretyek.” ... ");
INSERT INTO aly_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Awank-akerr, ahern-areny-rnem angka anyentelant angkerrenh. ");
INSERT INTO aly_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ikwer-theyan ingwer-rnem apmer Babylon akngerrakw-ampeny-warl alpek. Rernem ingkerrenh alperlewek akngerrakw, peleyn ilkwewarl, apmer Shinar-arrangarr-warl. Apmer-anem rernem arrernek. ");
INSERT INTO aly_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Rernem angkerrenh, “Tern ilkwa mpwaretyek, warl arrpanenh, warl arlpenty-then anwantherr mpwarey alker-warl-athek, alkerek-atwety. Apwert-weny anwantherr mpwarey bricks-elant, ankerelant anyentelhilem anterrkwetyek bricks renh. Ingkerrenhel anwenhantherr iterl-aretyek apmer anyentek. Anwantherr apmer arrpanenh-warl nthakenh arlpimperrey-angenh. Anwantherr arlperrtyirreyang anetyek, apmer anyent ikwerel.” ");
INSERT INTO aly_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Akngeyel tawen renh aretyek apetyek rernemarl arnwarnenh. ");
INSERT INTO aly_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ra ilek, “Nhernem warrkirreyel rernemarl angka anyentel angkerreyel. Rernem arlkwententyelan, ilek-ilek mpwarerl-anekerr. Rernem tnakelheyel rernemarl warl ilkwa artek-penh. ");
INSERT INTO aly_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Atha renh-rnem angka amentew-ament-anem iley, rernem awerrey-angenh-antey ingkerr anayntetyek.” ");
INSERT INTO aly_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","9","Angka anyentarl angkerrenh-penh Akngeyel renh-rnem angka ilpertelhilek ingkerrenh. Angka ingwerek-ingwer-anem rernem angkerrenh. Rernem menty-anem ipmek, warrkirreyang-anem. Rernem arlperrtyirremel alpek apmer arrpanenh-warl, aney-alpek. ... ");
INSERT INTO aly_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Nhenh angka Terah-penh-anem. Terah Abram Nahor-rnem aynikw-rnem anenh. Haran-kenh-rnemek aynikw anek. Haran ra Lot-kenh aynikw anenh. ");
INSERT INTO aly_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran Ur tawen-itwek atnyenek Chaldea-areny-rnem-kenh apmer-itwek. Ra apmer ikwerel-antey ilwek, aynikw ikwerenh Terah iteth anenhel-antey. ");
INSERT INTO aly_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","30","Abram-el Sarai anew inek ikwer, Nahor-el Milcah anew ikwer inek. Milcah aytey ikwerenh Iscah anenh, Haran-kenh alerikw. Sarai ampek arrangkw anenh. ");
INSERT INTO aly_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah anperl-alhek Ur tawen-they, Canaan ikwer-warl anperl-alhetyek. Ra Abram alerikw ikwerenh akngek, Sarai, amikw ikwerenh, arrengikw ikwerenh, Lot ra akngek arrpemarl. Rernem Haran tawen-el-anem aney-alpek. ");
INSERT INTO aly_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terah ra ampwirremel aherrety 205 anenh. Ikwer-penhan Haran tawen ikwerel-antey ilwek. ");
INSERT INTO aly_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Akngey angkek Abram-warl, “Apmer nhanyem iwerl-alha ngkwenh-rnem-akert, apmer atharl ngkweng iylparrernem-warl alpemel. ");
INSERT INTO aly_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Atha ngenh arntarnt-arayntem apmer ilenhek, akngerr-anem atha ngenh anthem, akngerram-akngerr irretyek. Ingkerrenhel ngenh iterl-arayntem. Ngkwenh-rnem-angkwarr angka atyenh arlpimpirreyenh, apmer arrpanenh-angkwarr, ingkerrenhel ayenh iterl-arayntetyek-awaty. ");
INSERT INTO aly_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ingwer-rnem mwerr anayntem ngkweng-itwel, ayeng mwerr arrpemarl ikwer-rnem anayntem. Alakenh-anyem ahern-areny ingkerrenh ngkweng inkwerelhetyek. Ingwer-rnem ngkweng awelhey-angenh, rernemarl apmwangkwarr apenteyenh, atha renh-rnem arntety anthemarl.” ");
INSERT INTO aly_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Abram aherrety 75 anenh, artwa ampwanem, Akngeyelarl ilek apmer ingwer-warl-anem ra alpetyek. Abram Akngeyek awelhek. Anew ikwerenh Sarai ampikw ikwerenh Lot, ampwal ilek-ilek ingkerrenh warrkenh-rnem-then, rernemarl apmer Canaan ikwer-warl alpek. ");
INSERT INTO aly_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram ra arwerl ilkwewarl, arwerl arnenty ikwer-warl alhek, ikwerenh-rnem-akert. Abram arwerl arnenty apmer Moreh ikwer-warl alhek, apmer Shechem-itwek. Canaan-areny-rnem arrwekel-antey apmer ikwer-itwek anenh. ");
INSERT INTO aly_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Akngey Abram ikwer aremirrek. Renh ilek, “Atha ngenh apmer nhenh anthetyek, ngkwenh-rnem-akert intem-antey.” Abram ra apwert ilperr-ilperr-anem arrernek Akngey aker tyenkerr anthetyek inkwerelhemel. ");
INSERT INTO aly_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Abram ra Bethel apmer akngerrakw-ampeny-warl alhek, rap ampepel ayntenhek apmer Ai-arrangarr. Kalikw-anem artek. Ra apwert ilperr-ilperr ingwer-anem arrernek, Akngey ikwer kwenirremel inkwerelhek. ");
INSERT INTO aly_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ikwer-penhan ra antekerr-anem alhek, apmer arlpaw-ampeny-warl. ");
INSERT INTO aly_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Apmer arrpanenh Canaan-ampenyel, amern lyapey-angenh-anem ra arenh, aherrety innganem. ");
INSERT INTO aly_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","13","Abram-then Sarai-then Egypt-warl rernem alpek, amern-angketyarr-warl atherrkeny-ampeny-warl. Abram iterremel angkek anew ikwerenh-warl, “Egypt-warl alhenty nga angkwerey atyenh-arrpantey ilelha ingwer-rnemek. Egypt-arenyel inngerr mwerr-angker ngenh arey-ayntenty, ayenharl rernem atwekerr, ngkweng-they angwarekerr.” ");
INSERT INTO aly_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","15","Rernem Egypt ikwer-warl alhek. Egypt-arenyel renh arek ra mwerr-angker innga. Atyetyart ilkwel-rnem Pharoah-an ilek Sarai renh. Artwel-rnem Sarai renh akngek Pharoah-kenh apmer-warl. ");
INSERT INTO aly_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Pharaoh rarl iterrek Sarai ikwer Abram-kenh angkwerikwek-athen, ra Abram renh ingkerrenh anthek, yep-yep-rnem-then, pwelek-rnem-then, tangkey-rnem-then, warrkenh-rnem-then, kamwerl-rnem-then ingkerrenh anthek. ");
INSERT INTO aly_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Atyetyart ilkwa rarl Sarai renh apmwangkwarr ikngwey-ayntek-they, INGKARTel Pharaoh-kenh-rnem arntety ilkwanem anthek. ");
INSERT INTO aly_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","19","Pharaoh-el ingwer ilanthek, Abram renh ikngwetyek, ratherr angkerretyek. Pharaoh ra angkek Abram ikwer-warl, “Ntwa atyeng iley-angenh arraty anew ngkwenh. Kel ineyna apmer nhenh-they alpemel. Apalel anew ngkwenh atha ikngwek.” ");
INSERT INTO aly_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Pharaoh-el ikwerenh-rnem thwenek, Abram renh artengewetyek, ratherr ampwal-rnem ikwer-atherrenh ingkerrenh akngeynetyek, apmer ingwer-warl alpemel. ");
INSERT INTO aly_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram Sarai atherr alhek apmer arlpaw Canaan-ampeny-warl, Lot ra ikwer-atherr-angkwarr alhek arrpemarl. ");
INSERT INTO aly_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram ampwal akngerr-akert alhek, pwelek-rnem-then, yep-yep-rnem-then, nanikwet-rnem-then, thilp-then, gold-then. ");
INSERT INTO aly_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Abram ra apmer arrpanenhel aneynenh, apmer arlpaw antekerr-ampeny-itwek. Ayerrer-anem ra alpek, Bethel tawen-warl. Kalikw-anem rap ampepek artey-alhek, apmer ikwerenh. Ayntey-alhek tawen Ai-they ampepel, Bethel tawen-they angath. ");
INSERT INTO aly_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Apey-alpek antekerr-they, ra aynteynek apwert ilperr-ilperr-akert ikwer-itwel, irrkatyel arrpemarl. Ra kalikw akely-anem artek. Ra kwenirremel Akngeyek-anem angkek inkwerelhemel. ");
INSERT INTO aly_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot-el akngerr arrpemarl atnyenek, yep-yep-rnem-then, nanikwet-rnem-then, pwelek-rnem-then, warrkenh ikwerenh-rnem-then. ");
INSERT INTO aly_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","Apmeran akely inngarl ayntenh atnwenth-rnem-then ingwerek-rnem-then. Atherrkarl atnwenth ingkerrenhel arlkwenh. Abram-kenh warrkenh-rnem-then Lot-kenh warrkenh-rnem-then atnwenth arntarnt-arey-angker-rnem rernem apmer-they ahel-anem ilterrenh. ");
INSERT INTO aly_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abram angkek Lot-ek, “Aylakan mwerrant-atherrarl anetyek. Aylekakenh-rneman mwerrant-arey arrpemarl anetyek, ilterrey-angenh. Aylak arrer nthakenh ilterrey-angenh. Artwa aylekakenh ilterrey-angenh anetyek. ");
INSERT INTO aly_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ahern arlpawel nhan! Aylak amentant atherr alhey. Ngarl altwerl alhem-kety, ayengan akngerrakwarl alhey. Ngarl akngerrakw alhem, ayeng altwerlarl alhey.” ");
INSERT INTO aly_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ikwer-they, Lot alhek arrwekel-antey. Kwaty akngerr ra arey-alhek Jordan Ilpay-itwek. Aleth-antey ra Ilpay atherrkeny aynteynenh ikwer-angkwarr apmer Zoar-ek-atwety. ");
INSERT INTO aly_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Jordan Ilpay ingkerrenh ikwer-tangkwel rlwanek akngerrakw-ampeny. Rarl akngerrakw alhek, Abram amentant atherr ratherr irrek, arlperrtyirremel. ");
INSERT INTO aly_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","13","Abram anek apmer Canaan-ampenyel. Lot alhek tawen Sodom arrerenty, wak-rnem artey-alhek, artwa apmwernem arrerenty-itwek, rernem INGKARTek irrpelthirrenh. ");
INSERT INTO aly_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","INGKARTel Abram renh ilek, “Apmer ingkerrenh-angkwarr ara! ");
INSERT INTO aly_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Atha ngenh anthey, nga intem-antey anayntetyek, apmer arrpanenh ilenhek, ngkwenh-rnem-akert. ");
INSERT INTO aly_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Atha ngkwenh-rnem akngerram-akngerrileyenh, arrantherr akngerr-anem ahern nhel anetyek. Ngkwenh-rnem akngerrirreyenh ahern akely akngerr aynteyel-apeny. ");
INSERT INTO aly_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Nga angkepelarreng apmer nhel alhaynta, atharl ngenh anthetyek.” ");
INSERT INTO aly_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Wak kalikw akely-rnem lhelherl-alhek akngeynemel apmer arwerl arnenty-akert ikwer-itwek aney-alhek apmer Mamre-arrangarr, Hebron-itwek. Apmer ikwer-itwek apwert ilperr-ilperr tyenkerrek-arelh ra arrernek, Akngey ikwer inkwerelhemel kwenirrek. ");
INSERT INTO aly_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","... Atyetyart tawen ikwer-areny-rnem, Sodom-areny, Gomorrah-areny, Admah-areny, Zeboim-areny, Bela-areny. Rernem atwerrenh Atyetyart ingwer-areny-rnem-then. Atyetyart Chedorlaomer, Elam-areny atyetyart, Tidal, Goiim-areny atyetyart. Amraphel, Shinar-areny atyetyart. Arioch, Ellasar-areny atyetyart. Atyetyart 5-pel-ek aherrety 12 anek, ikwer-rnemek. ");
INSERT INTO aly_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Ikwer-penhan rernem ikwer-warl apetyek, rernem atwerretyek. ");
INSERT INTO aly_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Atyetyart ingkerrenh akarrirrek peleyn ikwer-itwek, itnan Sidim. Sodom-areny-rnem Gomorrah-areny-rnem-then rernem anyentirrek, artwa ingwer-rnem atwerretyek. Ingwer-rnem rernem Sodom-areny-rnem-then Gomorrah-areny-rnem-then antengilek. Sodom-areny-rnem-then Gomorrah-areny-rnem-then rernem aytnek irrkewarl, anker-angketyarr-warl. Ingwer-rnem anterrek apwert-ampeny-warl. ");
INSERT INTO aly_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Sodom-then Gomorrah-then-they amern ingkerrenh rernem rakek, ampwal ilek-ilek. ");
INSERT INTO aly_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abram-kenh ampikw-then-antey, Lot anterrkwek, akngeynemel. ");
INSERT INTO aly_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Abram artwa Hebrew anenh arwerl arnenty ikwer-itwek. Arwerl arnenty ran Mamre Amor-areny-kenh. Artwa Mamre Amor-areny. Ayteyikw ikwer-atherrenh anek, itnan ratherr Eschol, Aner. Ratherr mwerr innga anek Abram-ek. ");
INSERT INTO aly_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Artwa anyentel Abram renh angkan ilek, rernemarl alerikw ikwerenh anterrkwek, ampwal ikwerenh-rnem-akert. Abram-el artwa ikwerenh-rnem anyentilek. Kel rernem alwernek apmer Dan ikwer-warl, ");
INSERT INTO aly_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Abram-el renh-rnem ingkerrenh atwek-penh, ingwer-rnem anterrek apmer Hobah-warl Damascus ikwer-angkwarr aterel. ");
INSERT INTO aly_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Abram-el renh-rnem alwernek, apmer Hobah-ek-atwety. Ra alerikw Lot renh ineynek, arelh-rnem-then ampwal ikwerenh-rnem-then. ");
INSERT INTO aly_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram rarl king ingwer-rnem-then atwek-penhan, ra apey-alpek. Atyetyart Sodom-areny apetyek Abram-warl peleyn Shaveh ikwer-itwek, ratherr angkerretyek. Shaveh ikwerenh itna ingweran arterterr King-kenh. ");
INSERT INTO aly_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Atyetyart Salem-areny itnan Melchizedek. Ra wayn-then amern-then Abram-warl akngetyek. Melchizedek INGKART anenh, Akngey ilkwa ikwer. ");
INSERT INTO aly_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Melchizedek angkek, “Akngey atha ayernem, ngenh rlterrkiletyek, rarl alker-then ahern-then arrpmernek. ");
INSERT INTO aly_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Nga Akngey ikwer inkwerelhey-areny, ntwarl artwa ingkerrenh atwek, rlterrk ikwerenh-akertel. Ntwa artwa ingkerrenh antengilek.” ");
INSERT INTO aly_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Atyetyart Sodom-arenyel Abram renh ilek, “Atyenh-rnem, Sodom-areny-rnem ingkerrenh ipma, apmwal-rnem ntwa akngemel.” ");
INSERT INTO aly_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abram-el Atyetyart Sodom-areny renh ilek, “INGKART Akngeyel anyentelarl ahern-then alker-then arrpmernek. ");
INSERT INTO aly_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Atha renh arraty innga ilek, atharl ampwal-rnem nthakenh iney-angenh, ntwa ayenh ingkern ayntarrp-ilekerr, nga atyeng angkekerr, ‘Atharl Abram renh ampwal ingkerrenh anthek.’ Akngeyelant ayenh ampwal ingkerrenh anthek. ");
INSERT INTO aly_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Amern arlengant anwantherr arlkwey artwa atyenh-rnemelan arlkwekant. Aner Eschol-atherr ampwal akely-rnem inem arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Abram-el altyerr arek, INGKARTelarl renh ilek, “Nga aterirreyang anetyek, atha ngenh arntarnt-areyel, ilek-ilek akngerr atha ngenh anthetyek.” ");
INSERT INTO aly_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram angkek, “INGKARTay, ntwa ayenh ilek-ilek akngerr anthek. ");
INSERT INTO aly_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ntwa ayenh ampan anthey-angenharl. Ayeng ilwentyel, warrkenh atyenhel ilek-ilek ingkerrenh inem.” ");
INSERT INTO aly_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","INGKARTel ilek, “Ntwa alerengkw ngkwenh atnyeneyenh. Warrkenh ngkwenhel nthakenh ingkerrenh iney-angenh. Alerengkw ngkwenhel ingkerrenh atnyeneyenh, nga ilwenty-kety.” ");
INSERT INTO aly_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Akngeyel renh atnwenhek aketh-warl. Ra renh ilek, “Alker-warl itnywena! Antyarr-rnem ntwa areyel? Ntwa count-em-anem renh-rnem ila! Ngkwenh-rnem antyarr ilenh-rnem-apeny akngerrirreyenh.” ");
INSERT INTO aly_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram Akngeyek inkwerelhemel awelhek. Akngeyel renh artwa arraty innga arek, rarl Akngeyek awelhenh. ");
INSERT INTO aly_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Akngeyel ilek, “Ayeng Akngey ra, atharl ngenh apmer Ur-they, Chaldea-rnem-kenh apmer-they atnwenhey-alhek, apmer nhenh ngenh anthetyek, ngkwenh-rnem-akert.” ");
INSERT INTO aly_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abram angkek, “Akngeyay, nthakenh atha iterl-areman apmer yanh atha atnyenetyek?” ");
INSERT INTO aly_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Akngey ra ilek, “Pwelek amarl akely atyeng-warl akngetyay! Nanikwet anyent yep-yep irrwey anyent rwelyarr anyent, pwelker anyent.” ");
INSERT INTO aly_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram Akngey ikwer awelhek. Aker-rnem akngek, Akngey renh anthetyek, tyenkerr-anem. Abram-el aker renh-rnem rlweth-rlweth akek, amentew-ament arrernek ahern-warl, pwelker-then rwelyarr-then rlweth-akey-angenh-antey. ");
INSERT INTO aly_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Irrety-rnem-then inkwel-rnem-then akarrirrek aker-warl. Thip ingwerek-ingwer-then. Rernem aker-warl apetyek. Abram-el renh-rnem irrentek. ");
INSERT INTO aly_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ingkeny aylpenhetyek irrek. Kel ankwanem irrek. Abram artewentyel aterirrek-anem. Ingwel artek. ");
INSERT INTO aly_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","14","INGKARTel ilek, “Ngkwenh-rnem ingwer-rnemek warrk antherl-aneynenh, arlkarewerl-aneyenh. Ngkwenh-rnem nhak-itwek ingwer-rnemel warrk antherl-aneyn, rernem aleth innga warrkirr-ayntetyek aherrety 400-ek-atwety. Apmer ingwer-areny-rnemel renh-rnem ilpertileyenh. Ngkwenh-rnem apmer ingwerel arlengeny-apeny aneyenh. Atha apmer ingwer-areny-rnem ingkerrenh arntety antheyenh. Atharl apmer renh atwem-kety, rernem apmer-they alpeyenh ampwal akngerr-akert. ");
INSERT INTO aly_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Nga ampwirremel ilweyenh, ngkwenh-rnemel ngenh ikwer-itwel-antey akwernayn, nga artwa ampwanem mwerr aneyenh. ");
INSERT INTO aly_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Rernem aherrety 400-penh apey-alpeyenh, Amor-areny-rnemel apmer nhenh atnyeney-kety.” ");
INSERT INTO aly_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ikwer-penhan ingkeny aylpenhek, ingwemernt-anem irrenhek. Rwalep-then rwa lherrm-then, ampep-itwek aker ampep-angkwarr aremirrenhey-alhek. ");
INSERT INTO aly_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","20","Arlta ikwerel-antey Akngeyel Abram renh alhelek, “Atha ngkwenh-rnem ingkerrenh apmer nhenh antheyenh. Egypt lher-they Euphrates lher ilkwa ikwerek-atwety, ingkerrenh-kenh apmerek-artwey. Atha ngkwenh-rnem apmer ingkerrenh-antey ilenh antheyenh.” ... ");
INSERT INTO aly_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Sarai, Abram, ratherr anewart ampeweny anenh. Arelh warrkenh anyent ikwerenh, itnan Hagar. Sarai angkek Abram-warl, Akngeyel ayenh menty ilek ampekety. “Warrkenh atyenh ntwa ikngwa, ntwa ampa atnyenetyek.” Alakenhaym Abram ra arelh warrkenh-anem ikngwek. Abram apmer Canaan-itwek aherrety 10 anenh. Abram awelhek, anew ikwerenhelarl renh ilek. Sarai ra warrkenh Egypt-areny ikwerenh Abram renh anthek. ");
INSERT INTO aly_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram-anem Hagar-itwek ayntek, ampanem ikwerenh anenh. Ikwer-they Hagar tnakelhenh, ikwer Sarai irrpelthirremel. ");
INSERT INTO aly_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sarai angkek Abram-warl, “Ntwa atyeng apmwel-areth mpwarek. Atha ngenh warrkenh yanh anthek anew ngkweng ra atyengety arlkarirrekarl. INGKARTel iterl-areyel ntwarl atyeng apmwel-areth mpwarek.” ");
INSERT INTO aly_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram angkek, “Warrkenh yanhan ngkwenharl. Ntwarrp kel atnyenetyek. Ayengan arlarl.” Sarai-el Hagar renh ayntarrp-ilek. Irrwernek. Hagar anterrek-anem ikwerety. ");
INSERT INTO aly_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","8","Akngey-kenh angel-el Hagar renh arey-alhek apmer arlpaw-itwek kwaty ngenty-itwek, apmer Shur-ampeny-itwek. Angel-el renh ayernek, “Hagar Sarai-kenh warrkenh, nthenh-they nga alpeyel, nthenh-warlay?” Hagar angkek, “Ayeng Sarai ikwerety aterel alpeyel.” ");
INSERT INTO aly_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Angel-el renh ilek, “Sarai-warl alpa, ikwer awelhetyek. ");
INSERT INTO aly_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Atha ngenh ngkwenh-rnem akngerr innga antheyenh, ingwerel-rnem nthakenh count-emiley-angenh.” ");
INSERT INTO aly_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","“Ntwa awey akely atnyeneyenh, ntwa renh itnewa Ishmael. ");
INSERT INTO aly_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ra artwa ateralth aneyenh, tangkey saddle-ek akwerrp-apeny. Ra artwa aneyenh, tangkey ateralth-warl arrernem-apeny. Ra awelhey-angenh ingkerrenhek aneyenh, ingkerrenh ikwer awelhey-angenh arrpemarl. Ra nthakenh ikwer-rnem-itwek aney-angenh, nthakenh ingwerenty-itwek ra aney-angenh.” ");
INSERT INTO aly_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagar-el INGKART renh ilek, “Nga atyeng aremirrek.” Ra iterrek, “Atha INGKART arek-penh, ayeng iteth-antey aneyel, ilwey-angenh.” ");
INSERT INTO aly_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Alakenh rernem kwaty ngenty renh itneweyel Beer Laha Roi, kwaty ngenty ampepel apmer Kadesh-they apmer Bered-angkwarr aynteyel. ");
INSERT INTO aly_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","16","Abram-el atherr Hagar-el-atherr awey akely atnyenek, awey ikwerenh itna itnewemel Ishmael. Abram ra aherrety 86 ampwa innga anenh, renharl ratherr atnyenek-penh. ");
INSERT INTO aly_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram ra aherrety 99-anem. Akngey ikwer aremirrek angkemel, “Ayeng Akngey Atyetyart ra. Nga aleth anaynta, arraty innga. ");
INSERT INTO aly_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Abraham-ay, atyeng nga awelhetyek. Atha ngenh alhelek-angkwarr, atha alhelem arrpemarl, atha ngkwenh-rnem akngerr innga ileyenh.” ");
INSERT INTO aly_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram ahern-warl inngerr kwenirremel atnertel ilperr-ayntek. ");
INSERT INTO aly_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Akngey angkek ikwer-warl, “Atha ngenh alhelem, nga Atyetyart anetyek, ingkerrenh ngkwenh-rnem ngkweng-they akngerrirreyenh, apmer arrpanenh-areny-rnemek. ");
INSERT INTO aly_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Rernem ngenh itneweyenh Abram-weny, Abraham-ant-anem. Alakenh-anyem nga Atyetyart aneyenh apmer arrpanenh-areny-rnemek. ");
INSERT INTO aly_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Atha ngenh akngerr innga antheyenh, ngkwenh ingkerrenh. Rernem apmer arrpanenh-areny aneyenh Atyetyart ilkwernem-then. ");
INSERT INTO aly_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","8","Atha ngenh arntarnt-arem, atha ngenh alhelek-angkwarr. Atha arrenhantherr apmer Canaan-anem antheyenh, arrantherr apmerek-artwey-wenyarl aneyel, atha arrenhantherr apmer Canaan anthem arrekantherr.” ");
INSERT INTO aly_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Akngey angkek Abraham-warl, “Nga atyeng-angkwarr anayntetyek ngkwenh-rnem-then. ");
INSERT INTO aly_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","11","Arrantherr awey arrekantherrenh artwa mpwaretyek, yanh alhelenty aneyenh, atharl arrenhantherr ilek-angkwarr. ");
INSERT INTO aly_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Arlta 8 ikwerel-antey arrantherr awey renh-rnem artwa mpwaretyek, alethang-rnem-then ingkerrenh, rernemarl warl ngkwenhel aneyel-rnem-then. ");
INSERT INTO aly_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Apmer ngkwenh-itwek atnyenek-rnem-then ntwa ingkerrenh artwa mpwaretyek, warrkenh ngkwenh-rnem-then ingkerrenh. ");
INSERT INTO aly_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Rernem alakenh-anyem mpwarey-angenh, rernem atyeng irrpelthirrenty, atha renh-rnem ilek-kety. Angka atyenhek awelhey-angenh anenty, atha renh-rnem atwem.” ");
INSERT INTO aly_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Akngeyel Abraham renh ilek, “Ntwa anew ngkwenh Sarai itnewey-angenh, ntwa renh Sarah-ant-anem itnewem. ");
INSERT INTO aly_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Atha renh arntarnt-areyel, atha ngkweng aler anthem ikwer-angkwarr. Akngerr ikwer-they akngerrirreyenh arrpemarl, apmer arrpanenh-areny Atyetyart-rnem-then.” ");
INSERT INTO aly_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham ra ilperr ayntek arrpemarl. Ra irrpelthirremel atherrek, “Nthakenhan artwa aherrety 100-kenh ampa atnyenetyek? Sarah-el nthakenh ampa atnyeney-angenh aherrety 90-el?” ");
INSERT INTO aly_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abraham-el Akngey renh ayernek, “Ishmael-el-arleng atyenharl?” ");
INSERT INTO aly_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Akngeyel renh ilek, “Arrangkw wenh! Anew ngkwenhel Sarah-el awey atnyenem, ntwa renh itneweyenh Isaac. Atha renh ingkerrenh alhelem. Atha ngenh awek ngarl perayirrenh Ishmael ikwer. Atha renh arntarnt-areyenh, akngerr ikwer-they irreyenh, apmer arrpanenh-areny-rnem. ");
INSERT INTO aly_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ra Atyetyart irreyenh 12 prince ikwer-rnem. Atha renh Atyetyart ilkwa anetyek arrerneyenh, apmer arrpanenhek. ");
INSERT INTO aly_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Atha arraty mpwareyenh, atha alhelek-angkwarr Isaac ikwer-angkwarr, renharl Sarah-el atnyeneyenh, irrkaty-angkwarr aherrety ingwerel.” ");
INSERT INTO aly_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ikwer-penh Akngey alpek-anem. ");
INSERT INTO aly_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Abraham-el Ishmael, alerikw ikwerenh, warrkenh ikwerenh-rnem-then, apmer ikwerenh-itwek atnyenekarl-rnem-then. Ra renh-rnem artwilek, Akngeyelarl ilek-angkwarr. ");
INSERT INTO aly_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham aherrety 99 anenh, artwa ampwanem. ");
INSERT INTO aly_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ishmael aherrety 13 anenh, amerrk-antey, rernemarl renh-rnem ingkerrenh-anem artwilek. ");
INSERT INTO aly_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abraham-atherr Ishmael-atherr arlta anyent ikwerel-antey artwirrek. ");
INSERT INTO aly_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Abraham-kenh artwernem arlta ikwerel-antey artwirrek arrpemarl. ");
INSERT INTO aly_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Akngey aremirrek Abraham ikwer apmer Mamre-itwek, arwerl arnenty ikwer-itwek. Arlta ampep ikwerel Abram kalikw ikwerenh arriwel anenh. ");
INSERT INTO aly_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ra arek artwa irrpety rtney-alhenty aketh-itwek. ");
INSERT INTO aly_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ra ikwer-rnem-warl anterrek, renh-rnem rlwatetyek. Ra ahern-warl-athek kwenirrek, angkemel, “Anper alhey-angenh, lywenty-itwek ltyerrenherr-arey! ");
INSERT INTO aly_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Kwaty atha arrekantherr iney-akenh ingka ahern-penh lhewelhetyek, arrantherr lywel ltyerretyek. ");
INSERT INTO aly_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Amern-then atha arrekantherr iney-akenh alethel arrantherr alpetyek.” “Ya, kel mwerr,” rernem angkek. ");
INSERT INTO aly_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham wak-warl aylpenhek, Sarah-arl anenh-warl, renh ilek, “Amern arlety irrpety inay, amern rtamp ampernetyek.” ");
INSERT INTO aly_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ra aker mwerr innga rlwanek, anter-akngerr akely. Abraham-kenh warrkenhel pwelek irrwey akely atwerliwek aker artwa irrpety ikwer-rnemek. ");
INSERT INTO aly_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Abraham-el aker-then milk-then anthek, artwa irrpety renh-rnem. Abraham lywel anenh, rernem amern arlkwenh-kety. ");
INSERT INTO aly_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Rernem ayernek, “Anew ngkwenh Sarah-alew?” Abraham ra angkek, “Kalikw kwenel.” ");
INSERT INTO aly_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","11","Artwa alethang angkek, “Aherrety anyent-penh ayeng apey-alpeyenh Sarah ampa akely atnyeneyenh. Sarah-el-tangkwel ampa atnyeneyenh arrwekel-antey ayeng apey-alpey-alenty.” ");
INSERT INTO aly_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sarah-el angka awek-penh, irrpelthirremel. Sarah atherrek, “Nthakenh atha ampa atnyenem ampwelam-athen, aylanth atherr-antey ampwa, nthakenh ampa atnyenem.” ");
INSERT INTO aly_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","INGKARTel Abraham ilek, “Nthakenhek Sarah angkek atherremel-anem, atyeng irrpelthirreyel? Ayengan INGKARTarl, ampa innga atha anthey-angker! ");
INSERT INTO aly_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Aherrety anyent-penh ayeng apey-alpeyenh aherrety ingwer ikwerel-antey. Sarah-el ampa atnyeneyenh arrwekel-antey ayeng apey-alpey-alenty.” ");
INSERT INTO aly_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sarah ra aterirrek, irrtywerremel ilelhek, “Ayeng atherrey-angenh arrangkw.” Artwa alethang ra ilek, “Inngarlap nga atherrek.” ");
INSERT INTO aly_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Artwa alethang irrpety rernem apmer Sodom-warl alpek. Abraham ikwer-rnem-angkwarr antelherl-alhek, artengewemel iwerr iylparrernetyek ikwer-rnemek. ");
INSERT INTO aly_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","INGKART iterrenh, “Abraham atha iley-angenh apmer Sodom-arl atha atwem. ");
INSERT INTO aly_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ikwerenh-rnem akngerrirreyenh apmer arrpanenh-warl arlperrtyirreyenh. ");
INSERT INTO aly_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Atha Abraham renh arntarnt-arek, ra ikwerenh-rnem akalty-antheyek atyeng-angkwarr, rernem arraty anetyek. Ikwer-penh atha renh-rnem arntarnt-arem, atharl renh-rnem ilek-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","INGKARTel Abraham renh ilek, “Atha awek tern atherrarl artwa apmwangkwarr aneyel. Atha angka ilkwa awek. ");
INSERT INTO aly_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ayeng alhem, atha renh-rnem aretyek, nthek-angkwarr rernem aneyel, innga apek, arrangkw apek.” ");
INSERT INTO aly_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Artwa alethang ratherr anperl-alhek, apmer Sodom ikwer-warl-anem, Abraham INGKART-itwelarl anenh. ");
INSERT INTO aly_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham-el INGKART renh ayernek, “Artwa apmwernem ntwa atwenty, artwa mwerr-rnem ntwa atwem arrpemarl? Arlernem-alew? ");
INSERT INTO aly_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Tern yanh alerl atnyenenty artwa mwerr-rnem 50-akert? ");
INSERT INTO aly_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ntwa mwanty arntarnt-aretyek. Ngan INGKART arraty innga, arlernem-then arntarnt-aretyek, tyatyemiley-angenh renh-rnem.” ");
INSERT INTO aly_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","INGKART angkek, “Atha apek artwa mwerr-rnem 50 arentyel, atha apmer Sodom renh ywerrelhilemel atwey-angenh.” ");
INSERT INTO aly_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham angkek, “Ayengan ahern-arenyarl. Nthakenharl artwa 45 mwerr-rnem arentyan? Ntwa tern ilkwa yanh ywerrelhilemel atwetyek?” ");
INSERT INTO aly_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","INGKART angkek, “Atha apek artwa mwerr-rnem 45 arentyel, atha apmer Sodom renh ywerrelhilemel atwey-angenh.” ");
INSERT INTO aly_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","“Artwa mwerr-rnem 40-alew?” Abraham-el renh ayernek. “Kel menty atwey-angenh.” INGKART angkek, “Atha tern ilkwa ywerrelhilemel atwey-angenh.” ");
INSERT INTO aly_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham angkek, “Nga atyeng ahelirrey-angenh, INGKARTay. Nthakenharl artwa 30 mwerr-rnem arentyan? Ntwa tern ilkwa ywerrelhilemel atwetyek?” INGKART angkek, “Atha apek artwa mwerr-rnem 30 arentyel, atha apmer Sodom renh ywerrelhilemel atwey-angenh.” ");
INSERT INTO aly_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham angkek, “Ayengan arrangkw. Artwa 20 mwerr-rnem-alew?” INGKART angkek, “Atha apmer renh ywerrelhilemel atwey-angenh.” ");
INSERT INTO aly_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abraham angkek, “Nga atyeng ahelirrey-angenh INGKARTay, artwa mwerr-rnem 10-alew?” “Kel, menty atwey-angenh,” INGKART angkek. “Atha tern ilkwa ywerrelhilemel atwey-angenh.” ");
INSERT INTO aly_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Abraham angkekarl-penh INGKART alpek-anem. Kel Abraham apmer-warl alpek. ");
INSERT INTO aly_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Atwerrp-anem angel atherr apetyek apmer Sodom-warl, tern ilkwewarl. Artwa Lot keyt ilkwa iwerr-angkwarr anenh. Lot-el angel renh-atherr arek, ra akapwert ahern-warl-athek kwenirrek. ");
INSERT INTO aly_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ra angkek, “Mpwelanth apmer atyenh-warl apetyenherr-atherr, ingkernem-then mpwelanth lhewelhetyek. Ingwa anyent-inger mpwelanth ayntetyek, ingwepenh mpwelanth alethek alpey-akenh.” Ratherr renh ilek, “Mwerr aylanth akethel ayntem, tawen ampepel?” ");
INSERT INTO aly_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Lot-el renh-atherr irrtyelh-ilenh inngantey apmer ikwerenh-warl alpetyek, ratherr inngantey alpek ikwer-angkwarr, apmer ikwerenh-warl. Lot-el amern ampernek ikwer-atherr. ");
INSERT INTO aly_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Rernem ankwayntetyek irrek-anem. Artwa ingkerrenh Sodom-areny-rnem ikwer-rnem-warl, artwa atningk apetyek. ");
INSERT INTO aly_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Rernem ayernek, “Artwa alethang weth-atherr-alew? Warl ngkwenharl aneyel atherr-alew? Akngetya renh-atherr anwantherr apmwa mpwaretyek ikwer-atherr-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot alhek arriw-warl-athek. ");
INSERT INTO aly_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ra menty angkek. ");
INSERT INTO aly_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","“Kwey aleyak nhenh-atherr akngeynenherr-areyay, artwa atherr mentyarl. Atha renh-atherr arntarnt-areyel, ratherr atyeng-itwel ilkwatherr aneyel.” ");
INSERT INTO aly_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Artwa apmwernem arlkek, “Iwerr-kety alha! Arrkngert angkey-angenh! Artwa yanh alethangarl, nthakenh ra anwekantherr angkey-angenh alakenh. Anwantherr ngenh atwekerr!” Rernem akarrirrenhey-alhek arriw renh ngkweltyiletyek, warl Lot-kenh. ");
INSERT INTO aly_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","11","Artwa angel ratherr Lot renh ayteng inek, warl renh martemel artwernem akethelarl rtnenh-rnem ingkerrenh aparrngilek, rernem iwerr renh arey-angenhilek. ");
INSERT INTO aly_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Ratherr Lot ikwer angkek, “Ngkwenh-rnem apek apmer nhel aneyel? Alerengkw-rnem-then. Ingkerrenh apmer nhenh-they akngeyna, aylanth apmer nhenh atwem-kety. Aylanth apmer nhenh atwem, rernem apmwangkwarr alheyel-kety.” ");
INSERT INTO aly_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lot-el malyikw ikwerenh-atherr ilek, rernem apmer-they alpetyek ingkerr-antey. Ratherr ikwer irrpelthirrenh, menty renh awenh. ");
INSERT INTO aly_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ingwepenh angel-el atherr Lot renh ilek ra apmer ikwer-they alpetyek, “Anew ngkwenh alerengkw ngkwenh-atherr anamerl apmer nhenh-they atnweneyna alpemel. Arrangkwelan nga alpey-angenhan, ingkerrenharl arrenhantherr atwem.” ");
INSERT INTO aly_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lot arlan anyentel-antey rtnenh. Akngey ilkelhenh renh atnyeneyek. Angel-el Lot renh anew ikwerenh alerikw ikwerenh-atherr-then apmer ikwer-they atnwenhek. ");
INSERT INTO aly_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Angel-el renh-rnem ilek, “Apmer renh artepang arey-angenh alpetyek.” ");
INSERT INTO aly_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","19","Lot-el ilek, “Awethem ntwa ilekan. Apwert-warl anwenhantherr ilanthey-angenh, apwert arleng-ketyarl, anwantherr atwelhekerr. ");
INSERT INTO aly_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Tyarlewa anwenhantherr apmer akely ikwer-warl alpetyek.” ");
INSERT INTO aly_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Angel-el ilek, “Ya, kel mwerr, atha apmer renh atwey-angenh. ");
INSERT INTO aly_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Anamerl alhenherr-arey arrenhantherr atwekerr-awaty.” Lot-el tawen akely renh itnewek Zoar, angka ikwerenh-angkwarr aynteyel apmer akely. ");
INSERT INTO aly_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ingkeny tyerrelhetyek irrek-anem. Lot apmer Zoar ikwer-warl aney-alhek-anem. INGKART-kenh lherrm ikwerenhel tawen renh-atherr atwek. ");
INSERT INTO aly_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","25","INGKARTel lherrmel-anem apmer renh atwek. Apmer atherr-antey ra atwek, arwerl-rnem-then atherrk-rnem-then. Altherrp-itwekan atwek arrpemarl lherrmel. Akngeyel arrpemarl tern ilkwitwel atwek arrpemarl. Tern ilkwernem ingkerrenh atwek. ");
INSERT INTO aly_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lot-kenh anewel artepang arek, ra apwert thalt-anem irrek. ");
INSERT INTO aly_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ingwepenh ikwerel-antey angkep-antey arrpemarl Abraham alpek irrkaty ikwer-warl, rarl arrwekelarl angkek Akngey-warl. ");
INSERT INTO aly_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ra kwen-warl-athek lherrm-rnem kwert-then tyerrelhey-ayntenty apmer ikwer-atherr-they. ");
INSERT INTO aly_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Akngey ra iterl-arek, Abraham ra alhelek Lot-anem arntarnt-aremel. ... ");
INSERT INTO aly_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","INGKARTel Sarah renh arntarnt-arek, rarl Sarah renh ilek-angkwarr. ");
INSERT INTO aly_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Abraham ampwanem irrek. Sarah-el awey akely atnyenek. ");
INSERT INTO aly_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham-el renh itnewek Isaac. ");
INSERT INTO aly_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Arlta 8 ikwerel-antey renh artwilek, INGKARTelarl renh ilek-angkwarr. ");
INSERT INTO aly_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham aherrety 100 anenh. ");
INSERT INTO aly_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sarah angkek, “Akngeyel ayenh irrkngerney anthek. Ingkerrenhel awem, atharl awey akely atnyeneyel, rernem inkwerelhem arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Rap angkek, “Ingwer-rnemel Abraham ilek, ‘Sarah-el awey aylpaty anthem,’ ra ikwer-rnem irrpelthirrenh. Lyert, ra ampwan aneyel, awey ikwerenh atnyeneyel.” ");
INSERT INTO aly_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isaac kel ilkwerrek. Ra kel amernant arlkwenh, aylpaty menty ipmek. Abraham-el tyenkerr ilkwa ikwer atnyenek. ");
INSERT INTO aly_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","10","Sarah-el awey Ishmael renh arek. Sarah-el alharlkwemel Abraham-ek angkek, “Ntwa warrkenh yanh Egypt-areny irrenta! Ampikw ikwerenh-then. Ayeng ilkelhey-angenh ampa Hagar ikwerenh-kety ngkweng-they ampwal-rnem inayntetyek. Ampa atyenhelant ampwal ngkwenh-rnem atnyenerl-ayntetyek, arntarnt-arayntetyek ngarl ilwem-kety.” ");
INSERT INTO aly_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abraham ahelirrek, Sarah-elarl renh irrentetyek-anem arrkernelhek. ");
INSERT INTO aly_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Akngeyel Abraham renh ilek, “Menty arelh yanh-then ampa akely-then menty alpetyek tyarlewa, Sarah-elarl renh ilek-angkwarr. Isaac impen ngkwenhan. Ikwer-they akngerram-akngerrirreyenh arrpemarl. ");
INSERT INTO aly_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Arelh warrkenh-kenh ampikw yanh menty-anem. Yanhan alerengkw ngkwenh arrpemarl. Ikwer-they akngerram-akngerrirreyenh arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Abraham-el Hagar renh arranty kwaty-akert anthek amern-then, anpethel akngeynetyek. Hagar-then Ishmael-then irrentek-anem. Ratherr alpek, apmer Beersheba-angkwarr, arlpaw-angkwarr. ");
INSERT INTO aly_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Kwaty kel ywerrek-anem. Hagar-el awey renh iwerl-alhek, lywenty-itwek. ");
INSERT INTO aly_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ra arleng-warl alhek, arrernelhemel, awey renh arekerr, ra ilwekarl-kety. ");
INSERT INTO aly_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Akngeyel awey renh awek, rarl artnek. Akngey-kenh angel-el irrwerl-they arlkek, “Hagar, ilekek nga artneyel? Aterirrey-angenh. Akngeyel awek, awey rarl artnek. ");
INSERT INTO aly_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Awey ngkwenh inerl-alha, renh arternpiletyek. Atha ngkwenh-rnem akngerram-akngerrileyenh.” ");
INSERT INTO aly_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Akngey kwaty Hagar ikwer anayntelhilek. Ra kwaty ngenty arek. Hagar-el kwaty inpek arranty-warl, awey renh anthek, antywetyek. ");
INSERT INTO aly_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Akngeyel awey renh arntarnt-arek. Ra ilkwerrek-anem. Ra apmer arlpawel anenh. Ra akaltyirrek pewenarrek. ");
INSERT INTO aly_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ra arlpawel anenh, rernem apmer renh itnewek Paran. Ingwer-ingeran amikw ikwerenhel anew inek ikwer, aleyak Egypt-areny. ... ");
INSERT INTO aly_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Abraham renh Akngeyel arrkernek, nthekwern irrem ran wenh. Arraty renh arrkernek Akngeyel, ikwer-angkwarr anetyek apek. Akngeyan ikwer arlkek, “Abraham-ay!” “Ilekekay!” ran angkek. ");
INSERT INTO aly_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","“Isaac, alerengkw ngkwenhant aknga apmer yanh-warl, Moriah-warl. Atyeng aknga Apwert renhan atha ngkweng tnernemarl. Aknga renh tyenkerr-anem atyeng. Atwey-alha renh, tyenkerr-anem. Ikwerek-anem tyenkerr-anem atyeng atwa! Yanhan alerengkw ngkwenhan.” ");
INSERT INTO aly_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ingwepenh-antey rap akemirrek. Ingwepenh-antey Abraham ra artwa ingwer-atherran-anem ikngwerl-alhek alerikw-anem ikwerenh. Rwanem ngkwelty ngkweltyilek ra, tangkey-anem ingwepenh-antey saddle-emiley-ayntek. Saddle arertney-ayntek tangkey-warl artep-warl. Rwanem ra inenh. Tywenerl-alhek ra. Apmer ikwer-warlap ra alhek Abraham irrkaty ikwer-warl renharl Akngeyel ilek-warl. ");
INSERT INTO aly_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Irrpety-inger-penh rap arek arleng innganem, alker innganem, arleng-antey-anem. ");
INSERT INTO aly_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","“Mpwelherl-ayntenh-atherr. Akngeyek inkwerelhemel alhem-kety! Awey nhenh atyenh atha alerey akngem-kety. Anerl-ayntenh-atherr! Mpwelh-ayntenherr-atherr tangkey nhitwek. Akngeyek inkwerelhemel alhem-kety.” ");
INSERT INTO aly_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham rap awey ikwer-warl rwernem tywenekan pwerlep-warl, artep-warl-anem, awey ra akngeyn-aynteyew-anem. Abraham-el akngeynenh rwalep-then inkwartey-then. Ilperlarlap ran. Anperl-alhek-anem ratherr. ");
INSERT INTO aly_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","8","Awey rap apatey-alhek, “Aker nthenharl ngkwenh tyenkerrew? Yep-yepew?” Abraham renh-anem ayernenh. Awey apatenh-anem. Abraham-anem ikwer angkenh, “Akngeyelarl tyenkerr anthem.” ");
INSERT INTO aly_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Akngeyelarl Abraham renh ilek-angkwarr, akngeyel ratherr anperl-alhek-anem. Apwert ilperr-ilperr renhan ra arratyilekan. Rwernem ampwerrety-inenh arratyilemel. Awey renhan tyweney-alhek rlterr-atherr itep-atherr renhap athenew-anem. Awey renhan arertnek ra, rlterr-atherr itep-atherr. ");
INSERT INTO aly_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Inkwartey-anem irrwerlilek ra atanthetyek-anem awey renh. ");
INSERT INTO aly_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","INGKART-kenh angel angkek ikwer, “Abraham, Abraham!” “Ilekekay?” Abraham-an angkek. ");
INSERT INTO aly_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“Ipmay! ipmay! Abraham ipmay!” Angel-an angkek. “Abraham ipmay! Atwey-angenh! Yanh atha ngenh iterl-areyel-anem. Alerengkw ngkwenh ayenh anthek ntwa. Ngkwenh. Anyent-antey. Impen-antey. Iterl-areyel-anem. Athap ngenh anthem ampa arnkengeny-anem. Akngerr-anem.” ");
INSERT INTO aly_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham-elan arerl-arrernek, “Ay, yep-yeparlap wenh!” Akapwert yanhey yep-yep mwernelhenh ra. Arwerl-rnemel mwernek artekerrel-anem. Akapwertan renh. Mwernek-anem. Rewelyey-anem renh. Artekerr arwerl-rnemel-anem renh yep-yep mwernekan. Rap ywarn-anem tyerrelhenhan, Abraham-el renh-anem arerl-arrernekan. Rap yep-yep renh, Abraham-el tyenkerr-anem renh anthekan, ikwer-warl-anem arrernekan. Apwert ilperr-ilperr ikwer-warl-anem ra arrernekan. Tyenkerr-anem renh anthekan. ");
INSERT INTO aly_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraham-el apmer renh itnewek INGKARTel Wantem. Lyert aley renh itneweyel INGKARTel Wantem apwert ikwerenhel. Itnan renh anthek, apmer Tyarlap-tyarlap ran. Itnan renh anthek Akngeyeley. Apwert ilperr-ilperr renhan. ");
INSERT INTO aly_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Angel ikwer angkek arrpemarl, ");
INSERT INTO aly_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Ngarl impenirrey-angenh atyeng angwenhirrek, impenirrey-angenh alerengkw ngkwenhek. ");
INSERT INTO aly_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ngenh anthem ampa arnkengeny-anem, akngerr-anem. Ampa akngerr-anem atha ngenh antheman. Athap ngenh anthem ampa arnkengeny-anem. Akngerr-anem. Ampa akngerr-anem atha ngenh antheman. Apmer arrpanenh-anem ampa ngkwenhel tern ilkwernem akngeman amentew-ament. Tern ilkwernem-anem. Apmer arrpanenh-anem. Tern arrpanenh ngkwenh ingkerrenh akngerrirreyenh, ahern akely-rnem akngerr aynteyel-apeny. Ampa ngkwenhel-rnemey. ");
INSERT INTO aly_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Athap ngenh arntarnt-arem irrwerl-theyan, ngarl atyeng awelhek. Athap ngenh arntarnt-areman Abraham-ay.” ");
INSERT INTO aly_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abraham ra warrkenh ikwerenh-atherr-warl alpek alerikw ikwerenh-akert. Abraham rap alpek apmer Beersheba-warl-anem. Aleth-antey aney-alpek-anem ra. ... ");
INSERT INTO aly_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Sarah aherrety 127 anenh, apmer Kiriath Arba ilwemel-antey ikwer-itwek-antey. Apmer itna ingweran Hebron, Canaan-itwek. ");
INSERT INTO aly_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abraham rarl amperrngirrek ikwer. Ikwer-penh Abraham Hitt-kenh-rnem-warl alhek, ra renh-rnem ayerney-alhek, ");
INSERT INTO aly_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ayengan alethang. Nthenhek atha anew atyenh arrewaly akwernem? Apmer mwerr ngay ntwa akely atyenh anthem?” ");
INSERT INTO aly_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","Rernem angkek, “Ngarl Atyetyart ilkwan intey nthenhek ngarl arlkwententyelan? Kel, ntwa intey yanhek anew ngkwenh arrewaly akwerna.” ");
INSERT INTO aly_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","9","Abraham angkek, “Ephron ayernerr-arey intey renh parrik impalth-itwek tharlemiletyek. Atha man ilkwan anthem, arrantherr ayenh ingkerrel aytaretyek, atharl anthem.” ");
INSERT INTO aly_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ephron apmerek-artwey, artwa Hitt-kenh apmer tern ilkwa arriw-itwek-antey anenh. Abraham-el apmer ikwer ayernek. ");
INSERT INTO aly_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Ephron angkek, “Kel, intey atha anthey, ingwerel-rneman ngenh aytaremel ntwarl atyeng-they intey ineman.” ");
INSERT INTO aly_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","13","Abraham angkek, “Man ilkwa innga atha ngenh anthem, arraty-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Ephron ra ilek, “Menty! Thilp 400 ntwa payemeley-areny inteyekey! Arwa ngkweng aknga, man-weny. Atha ngenh menty anthek, man-weny-anem.” ");
INSERT INTO aly_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","18","Abraham-el artwa Hitt-kenh 400 thilp anthek, artwa akngerrel aytarek-angkwarr. Alakenh Abraham-el apmer Ephron-kenh payemelek ikwerant-anem, ikwerenh-rnem-akert, intey-akert, arrewaly renh akwernetyek. Apmer ranap arwerl-angketyarr. ");
INSERT INTO aly_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","20","Abraham-el anew ikwerenh intey ikwer-itwek akwernek, rarl payemelek-itwek, Hitt-kenh-rnem-itwek. ");
INSERT INTO aly_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham artwamp-anem irrek, ampwal akngerr atnyenek. Akngeyel renh arntarnt-arek. ");
INSERT INTO aly_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ikwer-penhan, Abraham-el warrkenh ikwerenh innga ilek, rarl ampwal ikwerenh-rnem arntarnt-arayntetyek. ");
INSERT INTO aly_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","“Anew apmer Canaan-areny iney-angenh alerey atyenhek. ");
INSERT INTO aly_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Kel apmer ayengarl ilkwerrek-ampeny-arenyant anew ikwer inetyek, atyenh-rnemarl aneyel-itwek.” ");
INSERT INTO aly_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Warrkenh ikwerenhel renh ayernek, “Nthakenharl arelh ra apetyetyek ilkelhey-angenhel. Ilek-apenyarl Isaac atha thwenenty, renh ikngwetyek.” ");
INSERT INTO aly_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","“Kel, menty ipmay iterrey-angenh,” Abraham-el tyernek. ");
INSERT INTO aly_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","“INGKART alker-arenyel ayenh atnwenhey-alpek apmer nhenh-warl, apmer alhelenty nhenh-warl ayenh ra anthek, atyenh-rnem-akert. Nga apmer ikwer-warl alhentyan, INGKARTel angel ikwerenh thwenem, arraty-antey atnwenhetyek arelh ikwer-warl. ");
INSERT INTO aly_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ra arlkarirrentyan menty ra aney, alerey atyenh Isaac akngeyney-angenh, ikwer-warl.” ");
INSERT INTO aly_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Warrkenh ra Abraham ikwer ilelhek, “Ayeng ngkweng awelheyel, ntwarl ayenh ilek-angkwarr-antey.” ");
INSERT INTO aly_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ikwer-penhan warrkenh ra ampwal ilek-ilek akngerr-anem Abraham-kenh kamwerl 10-warl tywenek. Ikwer-they ra anperl-alhek apmer Syria-ampeny-warl, artwa Nahor anenh-warl. Nahor Abraham-kenh ayteyikw. ");
INSERT INTO aly_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ra kamwerl-rnem kwaty-itwek apmer tern akwerr-ampenyek apmer ltyerreyek arrerney-alhek. Atwerrp-anem arelh-rnem tern ilkwareny-rnem kwaty-warl apetyek. ");
INSERT INTO aly_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Warrkenh ra kwenirremel irrwerl-warl-athek angkek, “Akngeyay, ngan Abraham Atyetyartarl aneyel. Ntwa ayenh arraty ila, anew atha Isaac-ek anetyek, ntwarl Abraham renh alhelek-angkwarr-antey. ");
INSERT INTO aly_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Arelh yanh-rnem kwaty-warl rlengk apetyem, ");
INSERT INTO aly_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","atha renh-rnem ayernem anyentel kwaty anthetyek apek, rarl ayenh kwaty antheman athap renh iterl-aremarl, Isaac-kenh anewikw, ntwarl Atyetyart atyenh alhelek-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","16","Aleyak anyent mwerr-angker innga apetyek kwaty inpetyek, ampwal kwatyek-arelh anpethel akngetyek, itnan ra Rebekah. Rebekah ra Bethuel-kenh alerikw. Bethuel ra Nahor-kenh ra Nahor-kenh alerikw, Milcah-kenh ampikw. Rebekah anper ikwer-angkwarr alhek, kwaty-anem ra inpenh kwatyek-arelh-warl. Ra apmer-warl alpetyek-anem irrek. ");
INSERT INTO aly_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Abraham-kenh warrkenhel renh ayerney-ayntek, “Kwaty atyeng antha!” ");
INSERT INTO aly_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Aleyak ra angkek, “Kel, antywa!” Ra anpeth-they renh atwarrelhilek, anterrkwemel artwa renh-anem kwaty antywetyek anthek. ");
INSERT INTO aly_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","20","“Atha kamwerl-rnem-then kwaty antywetyek anthem,” aleyak ra angkenh. Aleyak ra kwaty thelhek. Ra angkepelarreng kwaty inperlenty-akngenh kamwerl-rnemek. Kel kamwerl-rnem kwaty akngerr antywek-penh. ");
INSERT INTO aly_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","22","Abraham-kenh warrkenhel arelh renhant-anem arenh, ra renh aretyek, ra apek innga nhenhan. Artwa warrkenh ra atnyenek ampwal alhek-arelh anyent ampwal akwek-arelh anyent, apwert gold-penh. Ra Rebekah renh anthek. ");
INSERT INTO aly_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Warrkenh ra ayernek, “Angwenh aynengkw ngkwenhan? Warl arlpimp ngkwenhan aynteyel, anwantherr ayntetyek?” ");
INSERT INTO aly_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Aleyak ra ilek, “Artwamp atyenhan Bethuel-arl, Nahor-kenh alerikw, Milcah-kenh ampikw. ");
INSERT INTO aly_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Kel warl arrekantherr arlpimparl. Amern atherrk akngerr kamwerl-rnemek.” ");
INSERT INTO aly_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Warrkenh ra kwenirrek, Akngey-warl-athek angkemel. ");
INSERT INTO aly_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“Kel, Abraham-kenh Atyetyart, ayeng ngkweng inkwerelhem, ntwarl ayenh Abraham-kenh-rnem-warl atnwenhek, ntwarl alhelek-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Rebekah anterreynek apmer-warl ikwerenh-rnem anenh-warl, ra renh-rnem ilek. ");
INSERT INTO aly_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Rebekah-kenh awayikw, itnan Laban. Ra renh awek, rarl renh ingkerrenh-angkwarr ilek. Ra ampwal alhek-arelh-rnem-then, ampwal akwek-arelh-rnem-then kel arek. Laban anterrek Abraham-kenh warrkenh-warl, kamwerl-rnem-itwel rtnenh-warl, kwaty ngenty impalth-warl. ");
INSERT INTO aly_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","INGKARTel ngenh mwerr-antey akngetyek apmer nhenh-warl. Akethel anwekantherrety rtney-angenh. Apmer atha ngkweng mpwarek, nga ingwel ayntetyek, kamwerl-rnem-then, ngkwenh-rnem-then. ");
INSERT INTO aly_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Abraham-kenh warrkenh alhek, Laban-angkwarr. Laban-kenh warrkenh-rnemel ampwal-rnem atwarrelhilek kamwerl-rnem-they. Kel ra atherrk-rnem kamwerl renh-rnem anthek. Kwaty-anem ikwer-rnem akngetyek warl kwen-warl Abraham-kenh warrkenh-rnemel ingka lhewelhetyek. ");
INSERT INTO aly_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ikwer-penhan rernem amern-anem artwa renh-rnem anthek, rernem arlkwetyek. Warrkenhel ilek, “Amern arlkwey-alentyelan, angketangkwel atha ngenh ileman ilekekarl ayeng apetyek apmer nhenh-warl. Kel ilant ilekek nga apetyek,” Laban angkek. ");
INSERT INTO aly_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Warrkenh ra ilelhek, “Ayengan Abraham-kenh warrkenharl. ");
INSERT INTO aly_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","INGKARTel Abraham renh aleth arntarnt-arenh, akngerr renh anthek, yep-yep-rnem-then, pwelek-rnem-then, nanikwet-rnem-then, kamwerl-rnem-then, tangkey-rnem-then, thilp-rnem-then, gold-rnem akngerr, warrkenh-rnem-then. ");
INSERT INTO aly_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Atyetyart atyenh-kenh anewikwelan ampa atnyenek ampwelant-anem. Ra awey atnyenek, Abraham-el renh anthek ampwal ilek-ilek akngerr innga. ");
INSERT INTO aly_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Atha Atyetyart atyenh ilek, ayengarl ikwer awelheyek, rarl ayenh ilek-angkwarr. Ra ayenh ilek, ‘Menty arelh Canaan-areny ikngwey-angenh alerey atyenhek. ");
INSERT INTO aly_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Atyenh-rnem-ampeny-theyant anew ikwer inetyek.’ ");
INSERT INTO aly_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Atha Atyetyart renh ayernek, ‘Nthakenharl arelh atyeng-angkwarr apetyey-angenhan?’ ");
INSERT INTO aly_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Atyetyart atyeng angkek, ‘Ayeng aleth Akngeyek inkwerelhemel awelheyel. Akngeyelarl angel thwenem, ra ngenh atnwenhetyek arelh ikwer-warl anew ikngwetyek alerey atyenhek. ");
INSERT INTO aly_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Rernem arelh renh ngkweng-angkwarr tyarlewey-angenhan nga menty-anem ana.’ ");
INSERT INTO aly_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","43","Ayeng kwaty ngenty ikwer-warl apetyek Akngey-warl-anem ayeng angkek, ‘Ngan Atyetyart ilkwa Abraham-kenh. Atyeng iylparrerna, Abraham-kenh alerikwek anew atha ikngwetyek. Arelh ra rlengk apetyem kwaty-warl, atha renh ayernem, ra ayenh kwaty ngenty itwek inpemel anthetyek, atha antywetyek. ");
INSERT INTO aly_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Rarl ayenh kwaty antywetyek anthenty, kamwerl-rnem-then, athap renh inngarl iterl-areman, ntwarl atyeng iylparrernek.’ ");
INSERT INTO aly_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Atha Akngeyel ayernenhel-antey, arelh ra apetyek, kwaty inpetyek, ngenty ikwer-itwek, kwatyek-arelh anpeth-itwek akngetyenh. Ra kwatyek-arelh kwaty akngerr innga inpek, atha renh kwaty antywetyek ayernek, kwatyek-arelh-they. ");
INSERT INTO aly_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ra kwatyek-arelh anpeth-they ayenh anthek, atha antywek. Ra kwaty inpek kamwerl-rnemek-anem, anthwengiletyek. ");
INSERT INTO aly_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","48","Atha renh aynikwek ayernek, ra aynikw ikwerenh itnewek Bethuel, Nahor-kenh alerikw, Milcah-kenh ampikw. Anamerl-antey atha arrernek ampwal alhek-arelh-then ampwal akwek-arelh-then ikwer-warl. Ikwer-penhan ayeng kwenirremel Akngey-warl angkek, inkwerelhemel, rarl arraty innga atyeng arelh renh iylparrernek, Abraham-kenh alerikwek anew ikngwetyek, Abraham-kenh-rnem-itwek. ");
INSERT INTO aly_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ila atyeng Atyetyart atyenhek, ntwarl renh arraty innga anthem. Atha apek aleyak renh akngeynetyek. Arrangkwelan aleyak ingwerek-anemarl ayeng nthwetyek alhem, anew ikngwetyek Abraham-kenh alerikwek.” ");
INSERT INTO aly_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban, Bethuel atherrel renh ilek, “Nhan Akngey-kenh-angkwarrarl, yanh-angkwarr anwantherr apenteman. ");
INSERT INTO aly_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Kel-anem Rebekah akngeyna-anem, atyetyart ngkwenh-kenh alerikwek anew, INGKARTelarl ngenh ilek-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Abraham-kenh warrkenh Akngey kwenirremel angkek inkwerelhemel ikwer, rarl renh arraty iylparrernekek. ");
INSERT INTO aly_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ra arnkwernem-then thilp-rnem-then ampwal akwek-arelh-rnem-then gold-penh ingkerrenh anthek Rebekah renh. Ra ampwal mwerr-angker ingwer-rneman amikw-then awayikw-then anthek. ");
INSERT INTO aly_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Abraham-kenh warrkenh-rnem anyent-inger-antey ayntek, ikwer-itwek. Ingwepenh, Abraham-kenh warrkenhel renh-rnem ilek, “Kel, ayeng alpem-anem Atyetyart atyenh-warl.” ");
INSERT INTO aly_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Rebekah-kenh-rnem arrkngert angkek, “Alerey kwey Rebekah nhenh alerl aney anwekantherr-itwek-anem wik anyentel. Ikwer-penhant-anem ra alpeman.” ");
INSERT INTO aly_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Warrkenh angkek, “Arleng-alenty atyeng mpwarey-angenh ayeng anetyek, INGKARTel arraty innga iylparrernek-angkwarr. Ayeng kel alpem Atyetyart ikwer-warl.” ");
INSERT INTO aly_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Rernem angkek, “Ilek-apenyarl Rebekah anwantherr ayernentyan nthakenh rarl angkem?” ");
INSERT INTO aly_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Rernem renh ayernek, “Kel mwerrang artwa nhenh-angkwarr nga alpem?”. Kel Rebekah mwerr angkek artwa ikwer-angkwarr alpetyek. ");
INSERT INTO aly_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","60","Rebekah renh-then arelh warrkenh-then Abraham-kenh warrkenh ikwer-angkwarr renh-atherr thwenek, alpetyek Abraham-kenh alerikw ikwer-warl. Ikwer-penhan rernem inkwerelhemel Akngey-warl angkek, “Anwantherr ngkweng Akngey-warl angkem, ngkweng-they akngerram-akngerrirretyek anyany-rnem-then, aperl-rnem-then. Akngeyel renh-rnem arntarnt-arayntem artwa ahelengkw-rnem-kety.” ");
INSERT INTO aly_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Kel Rebekah ingwer-rnem-then alpetyek-anem irrek. Rernem kamwerl-warl nganek, Abraham-kenh warrkenh-rnem-angkwarr alpek. ");
INSERT INTO aly_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isaac ra Caanan-they antekerr-ampeny anenh. Apmer ra Beer Lahai Roi-they apetyek, apmer Canaan-they antekerr-ampenyel anenh. ");
INSERT INTO aly_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Atwerrp ra alhenh, artwernem-anem ra arnarek kamwerl-akert apey-alperl-anenty. Ra ikwer-rnem-warl-athek alhenh. ");
INSERT INTO aly_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebekah-el renh arnarek. Ra kamwerl-they atwarrek. ");
INSERT INTO aly_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Warrkenh renh ayernek, “Artwa angwenh apetyeyel?” Warrkenh angkek, “Atyetyart atyenh yanhan apetyeyel, Isaac-an.” Rebekah arnkwa artelhek inngerr-angkwarran, artwel arey-ayntekerr. ");
INSERT INTO aly_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Warrkenh ra ilek Isaac renh ilek-ilek-angkwarr ayntek. ");
INSERT INTO aly_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaac ra Rebekah renh atnwenhek kalikw kwen-warl. Ratherr itengirrek-anem. Ra ikwer inkwerelhek, amikw ikwerenharl ilwekarl-kety. ");
INSERT INTO aly_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","2","Abraham ra anew ingwer-anem ikngwek itnan Keturah. Ampernem atnyenek 6-pel. ... ");
INSERT INTO aly_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham iteth-antey anenhel, ra ampwal ingkerrenh anthek, Hagar-atherr, Keturah-atherr. ");
INSERT INTO aly_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ra alerikw ikwerenh-rnem thwenek, akngerrakw-antey, arleng innga, alerikw ikwerenh Isaac-kety. Abraham ilwey-alentyel ra ampwal ingkerrenh Isaac anthek. ");
INSERT INTO aly_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham aherrety 175 ampwa innganem anenh. ");
INSERT INTO aly_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Kel ra ilwek-anem. ");
INSERT INTO aly_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Alerikw ikwerenhel atherr renh intey-itwek akwernek, Hebron-angkwarr akngerrakw, rarl Hitt-kenh-rnem-itwek payemelek intey renh. Isaac-el atherr Ishmael-el atherr Abraham renh anew ikwerenh-itwek-antey akwernek. ");
INSERT INTO aly_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham ilwek-penhan Akngeyel Isaac renh arntarnt-arenh. Isaac ra alpek apmer Beer Lahai Roi-warl. ... ");
INSERT INTO aly_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Nhenh angka Abraham-kenh alerikw-then Isaac-penh Isaac alerikw anenh Abraham-kenhan. ");
INSERT INTO aly_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac aherrety 40 anenh ra itengirrek Rebekah-itwek, Bethuel-kenh alerikw-itwek. Bethuel ra apmer Aram-areny anenh. Laban Rebekah-kenh awayikw apmer Aram-areny anenh arrpemarl. ");
INSERT INTO aly_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebekah ra ampek arrangkw anenh. Isaac-el INGKART ayernek renh-atherr ampa anthetyek. INGKARTel Isaac renh awek, rarl ayernek ampek, renh-atherr ra anthetyek. ");
INSERT INTO aly_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Rebekah ra atyewenheng-atherr-akert awelhek, ratherrarl atwerrek. Ran Akngey ayernek, “Ilekek atyewenheng-atherr atwerreyel?” Rebekah ywarn iterrek nthakenharl ratherr atwerrenh. ");
INSERT INTO aly_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","INGKARTel renh ilek, “Aler ngkwenh amentant-atherr ratherr atyetyart aneyenh, ingwer apmer ingwer-ampenyekan, ingwer apmer ingwer-ampenyek. Awayikwan ayteyikwek awelh-ayntem, ayteyikw rarlap atyetyartan anayntem. Amentant atherr ikwerek-atherr anaynteman.” ");
INSERT INTO aly_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Rebekah ra ampa akely renh-atherr-anem atnyenek. ");
INSERT INTO aly_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","“Arrwekeleny alta rnter-rnterarl anek, atha renh itnewem Esau.” ");
INSERT INTO aly_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ra awayikw ikwerenh atnererrk-they anterrkwek. Rernem renh itnan Jacob renh itnewek. ");
INSERT INTO aly_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","28","Awayenheng-atherr ratherr ilkwerrek-anem. Esau ran awangk-awarrarl anenh, Jacob ra arteny-areny anenh. Isaac Esau-ek arlkwentenh, rarl akerel renh wantenhek. Amikw ikwer-atherrenh Jacob anyentekant arlkwentenh. Isaac aherrety 60 anenh. ");
INSERT INTO aly_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Arlta anyentel, Jacob ra ltya ampernenh, Esau ra angayakw irrek. ");
INSERT INTO aly_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esau ra ayteyikw ikwerenh ltyek ayernek, “Ltya ayenh anthay, ayeng angayakwirrek, atnert ayeng akelhek, angayakw innga irrek.” ");
INSERT INTO aly_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jacob angkek, “Ngenh ampwal ingkerrenh antheyenh, nga arrwekelenyarl. Ntwa ayenh ampwal ingkerrenh antha, atha ngenh aker ltyarl anthey-akenh.” ");
INSERT INTO aly_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau angkek, “Ayeng ilwetyekan arrer-anem. Kel menty ampwal-rnem atnyeney-angenh ilwetyekan arrer-anem.” ");
INSERT INTO aly_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jacob angkek, “Ampwal ayenh anthay, akngeyelarl ngenh alhelek.” Esau mwerr angkek ikwer, ra ampwal-rnem menty anthetyek. ");
INSERT INTO aly_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Jacob-el amern-then aker ltyethen Esau renh anthek. Esau ra aker arlkwek-penh ra anperl-alhek apmer-warl alpek, ampwal-rnem menty iwerl-alhek. ");
INSERT INTO aly_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Awank-akerr, Abraham rarl iteth anenh-angkwarr, apmer Canaan amern-weny irrek. Irrkaty-angkwarr arrpemarl apmer ra amern-weny irrek arrwekel. Isaac tawen Gerar-warl alhek, Abimelech-warl, Philistia-areny Atyetyart ikwer-warl, INGKARTelarl Abraham renh ilek-angkwarr. ");
INSERT INTO aly_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","INGKART aremirrek Isaac ikwer-warl. Angkek ikwer-warl, “Egypt-warl alhey-angenh-antey nhenhel-antey anaynta! Atha ngenh atnwenhey, apmer renh atha ngkweng iylparrernetyek. ");
INSERT INTO aly_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Atha ngenh aleth arntarnt-arayntetyek apmer ilenhek, alethang inngey ngarl. Atha apmer ngenh anthem, ngkwenh-rnem-then, atharl Abraham renh alhelek-angkwarr. ");
INSERT INTO aly_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","5","Atha ngenh apmer anthem, ngkwenh-rnem akngerrirretyek apmer ilenhel. Akngerr innga rernem aneyenh, antyarr-rnem akngerr innga aneyel-apeny. Ngkwenh-rnem ingkerrenh mwerrant-arey anetyek, apmer arrpanenhek, Abraham-arl atyeng awelhek-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Isaac apmer Gerar-itwek kel aney-alpek. ... ");
INSERT INTO aly_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaac artwa ampwanemarl irrek, ra annga aparrng-anem irrek. Ra alerikw ikwerenhek arlkek Esau. ");
INSERT INTO aly_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaac angkek, “Ayeng artwamp-anem. Arrer-anem ayeng ilwetyekan.” ");
INSERT INTO aly_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Isaac-el renh ilanthek, “Ntwa aker atyeng atwerl-alpa. Pewenarr ngkwenh aknga! ");
INSERT INTO aly_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Peleyn-warl alha! Aker amperna peleyn ilenhek, mwerr-angker inetyek, mwerr-angker atha arlkweyek. Ayeng mwerr-angkwarr ngkweng angketyek ayeng ilwey-alenty, INGKARTel ngenh arntarnt-aretyek.” ");
INSERT INTO aly_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebekah awelhenh, Isaac rarl angkenh. Esau anpenhek awangk, akerek aretyek. ");
INSERT INTO aly_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","7","Rebekah Jacob-ek angkek, “Atha awek Isaac-elarl Esau ilanthek aker ikwer atwerl-alpetyek ltyakert-anem ampernemel. Artwamp ilwey-alentyel arlkwetyek, awayengkw ngkwenhek mwerr-anem ra angketyek, INGKARTel renh arntarnt-aretyek.” ");
INSERT INTO aly_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Amikw angkek, “Awelha atyeng! ");
INSERT INTO aly_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Nanikwet akely atherr atwerl-alpa akngey-alpemel. Atha ampernetyek aynengkw ngkwenhek. ");
INSERT INTO aly_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ntwa ikwer-warl akngetyek, ra arlkwetyek ra mwerr-angkwarr angkey-alhenty, ra ngkweng inkwerelhemel.” ");
INSERT INTO aly_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","12","Jacob angkek, “Awayaty atyenh altangketyarr. Ayengan arrangkw, alteweny. Artwampel ayenh iterl-arekerr, atha irrtywerremel ilerl-anenty. Apmwangkwarr atha ilerl-anentyek, ra akengenty atyeng angkekerr.” ");
INSERT INTO aly_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Amikw ikwerenh angkek, “Mwerr, atyengarl ra iterrem. Akngeyel ayenh ayntarrp-iletyek. Kel nga alha aker atwetyekantarl.” ");
INSERT INTO aly_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Jacob-el aker renh atwerl-alpek. Amikwelarl renh ampernek, aynikw-kenh impen. ");
INSERT INTO aly_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Esau-kenh arnkwa amikwel Jacob renh anthek, ra aylpetyek. ");
INSERT INTO aly_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Nanikwet-penh yenp ra mpwarek, Jacob ikwer-warl arrernek, itep-atherr-warl, itewarl, Esau-apeny. Aynikw-warl aker akngetyek. ");
INSERT INTO aly_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Amikwel Jacob amern-then aker ltyethen ra anthek. ");
INSERT INTO aly_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jacob aynikw-warl alhek. Aynikw-warl ra angkek, “Kel, ayeng apey-alpek.” “Nthenh-apeny ngan?” Aynikwel ayernek. ");
INSERT INTO aly_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jacob irrtywerremel ikwer ilelhek, “Ayeng arrwekelenyan ngkwenh Esau. Atha aker atwerl-alpek, ntwarl ayenh ilanthek-angkwarr. Aker nhanyeman arlkwa ntwa mwerr-angkwarr angka atyeng iletyek, Akngeyel ayenh arntarnt-aretyek.” ");
INSERT INTO aly_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","“Alyarnpel-anem ntwa akeran atwerliwek! Ilek-kety?” Isaac-el renh ayernek. Jacob-el irrtywerremel ilek, “Akngey INGKARTel ayenh aker anthek.” ");
INSERT INTO aly_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isaac angkek, “Arrer-apeny irray, atha ngenh arnep-arnetyek, Esau-ek apek atha ngenh arnep-arnetyek.” ");
INSERT INTO aly_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jacob arrer-apeny irrek ikwer-warl. Isaac-el renh arnep-arnek. Artwamp angkek, “Jacob-apenyarl nga angkeyelan, Esau-apenyarl nga arlkan.” ");
INSERT INTO aly_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Angka mwerr innga ra angkek Esau-ek-arrpantey. ");
INSERT INTO aly_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","“Nga alerey atyenh Esau innga?” Isaac-el ayernek. “Ya, ayengan alerengkw ngkwenharl, Esau-arl,” Jacob-el irrtywerremel ilek. ");
INSERT INTO aly_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","“Aker-rnem atyeng akngetya, angka mwerr atha ngkweng iletyek. Jacob-el renh anthek aker-then wayn-then. Isaac-el arlkwek, antywek.” ");
INSERT INTO aly_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Isaac angkek alerikw ikwerenhek, “Apetya! Ayenh arrwantyetyek. Kel, atha ngkweng iletyek, atharl ngenh kel ilek-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Isaac-el arnkwa Esau-kenh intenhek, Esau-arrpantey iterl-arek, angkek, “Arlka ikwakertarl nhan, ahern atherrkeny kwaty-penh mwerr-angker inteyel-apeny, amern lyapelhelekarl INGKARTel. ");
INSERT INTO aly_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Akngeyel ngkweng-warl kwaty thwenetyek, ngenh arntarnt-arem, amern-angketyarr, ntang ingwerek-ingwer-then, amern-rnem-then lyapelheletyek. ");
INSERT INTO aly_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Nga Atyetyart ilkwa anetyek apmer arrpanenhek, ayteyengkw-rnemek, atyetyart ilkwa nga anetyek. Ingwerarl ngkweng akengenty angkenty, ayeng akengenty arrpemarl ikwer angkem. Ingwerarl ngkweng mwerr angkenty, Akngey mwerr arrpemarl ikwer angkem.” Isaac mwerr angkek Jacob ikwer. ");
INSERT INTO aly_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Esau awangk-angkwarr-penh aremirrek ikwer-warl aker-akert. ");
INSERT INTO aly_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Aker mwerr-angker ampernek aynikwek aker renh anthemel, “Aker nhenh arlkwa atharl ngkweng akngetyek.” ");
INSERT INTO aly_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","“Angwenharl ngan?” Isaac angkek. “Ayengan Esau-arl, alerengkw ngkwenh arrwekelenyan,” Esau ikwer ilelhek. ");
INSERT INTO aly_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ikwer-penhan Isaac artewentyel arrewemel iterrek. “Angwenhelarl aker arrwekel-antey akngetyek? Atharl arlkwek, mwerr ayeng angkek, atharl arrwekel alhelek-anemarl renh, kel-antey. Kel, yanhey-antey atha ilek.” Artwampel ilek. ");
INSERT INTO aly_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau artewentyel arlkemel artnek, aynikwarl awek-penh, “Kel ayenhan ntwa alhela arrpemarl!” Esau-el ilek. ");
INSERT INTO aly_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isaac angkek, “Ayteyengkw ngkwenhel ayenh irrtywerl-ampernek.” ");
INSERT INTO aly_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau angkek, “Atherr-inger ra irrtywerl-ampernek, itna ikwerenh-apeny.” ");
INSERT INTO aly_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Artwampel ilek, “Jacob-an Atyetyartarl arrekingkerr-angkwarr, ingkerrenh-angkwarr. Arringkerr ingkerrenh ikwer awelhetyek. Atha renh ingkerrenh anthek, amern-rnem-then. Ilek-anem atha ngenh anthem, ingkerrenh-antey atha anthek-kety.” ");
INSERT INTO aly_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau-el aynikw renh ayernek arrpemarl, “Ayenh-anem ilay, Akngeyel ayenh arntarnt-aretyek! Ampwal-rnem anthetyek apek!” Ra artewentyel artnenh. ");
INSERT INTO aly_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Aynikw ikwerenhel renh ilek, “Apmer arlpawel nga aneyenh. Kwaty aypmerr ayntey-angenh arrangkw, aherrety inngel. ");
INSERT INTO aly_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ngethen atwerrerl-ayntem Jacob-kenh-rnem-then aleth-antey. Ayteyengkw ngkwenh ngkweng Atyetyart aneyenh. Ingwer-ingeran, mpwel amentant-atherr irreyenh. Mpwel arlengant-atherr anetyek, ra ngkweng atyetyart-weny aneyenh.” ");
INSERT INTO aly_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau arlkarirrenh Jacob-kety, rarl renh irrtywerl-ampernek-kety. Ra ament iterrenh, “Akngey atyenh ilwentyel, atha Jacob renh ipmek atwem.” ");
INSERT INTO aly_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","43","Rebekah-el awek ingwer-rnemel ikwer ilek, Esau Jacob ikwer mpwelhenh renh atwetyek, Jacob renh ilek, “Nga awayaty atyenh-warl alpa, Laban-warl, rarl apmer Haran-itwek aneyel. ");
INSERT INTO aly_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Arleng ikwerety aney-alpa. ");
INSERT INTO aly_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Esau ra iylpelirrenty atha ingwerenty ilanthem ngenh ikngwerl-alpetyek. Mpwel aleth anayntetyek, mwerrant-atherr ipmek atwerrey-angenh anetyek.” ");
INSERT INTO aly_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebekah-el Isaac renh ilek, “Arelh Hitt-kenh-rnem, Esau-kenh anew-rnem, ayeng ikwer-rnem-kety arlkarirreyel. Jacob-el arelh Hitt-kenh ikngwenty-they, ayeng kel ilwemarl. Ayeng ilkelhey-angenh ayeng iteth anetyek, rernem ayenh arlkarewerl-anekerr.” ");
INSERT INTO aly_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaac Jacob-ek arlkek, renh rlterrkel iletyek. Ra mwerr angkek ikwer, renh rlterrkiletyek. Ra Jacob renh ilek, “Arelh Canaan-areny-rnem itengirrey-angenh. Kel menty-anem renh-rnem ipma! ");
INSERT INTO aly_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Artartey ngkwenh-kenh apmer-warl alha, Bethuel-warl, apmer Syria-ampeny, apmer Paddam Aran. Apmarlengkw ngkwenh-itwek anew ntwa ikngwetyek, apmarlengkw ngkwenh-kenh alerikw. ");
INSERT INTO aly_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ayeng Akngey-warl angkey, ra ngenh rlterrkiletyek, ampa ngkwenh-rnem akngerrirretyek. ");
INSERT INTO aly_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Nga apmer ikwer-itwek anayntetyek, Akngeyel Abraham renh anthek-itwek, anwantherr aneyelan alethang-rnemarl. Akngeyel Abraham renh alhelek, apmer renh anthetyek, Ngan arwa alethangarl aney-alhek.” ... ");
INSERT INTO aly_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","... Jacob anperl-alhek apmer Beersheba-they apmer Haran-warl. ");
INSERT INTO aly_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Atwerrp-anem, ingkeny aylperl-alhekan. Apwert rtemal arrernek. Rap ankwanem ayntek. ");
INSERT INTO aly_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Rap altyerr arek. Angel-rnem ladder ikwerel angkepelarreng alhenh. ");
INSERT INTO aly_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Alkerel irrwerl Akngey ra rtnenh. Ra angkek, “Ayeng INGKART ra, Akngey arrengengkw ngkwenh-kenh, Abraham-kenh, INGKART Akngey ngkwenh-kenh, Isaac-kenh. Apmer nhenhan ngan aynteyelan, atha ngkwenh-rnemek antheyenh. ");
INSERT INTO aly_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Rernem arlperrtyirreyenh, amentew-ament irremel. ");
INSERT INTO aly_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Atha ngenh apmer nhewarl akngey-alpem. Ayeng ngkweng ilkwatherr alhem. Atha ngenh arntarnt-aretyek intem-antey, nthakenh ngenh ipmey-angenh. Atha ngenh anthem, atharl ngenh alhelek-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jacob akemirrenhey-alpek, “INGKART wenh apmer nhel aneyel! Atha iterl-arey-angenharl! Iwerr altywer alker-warl-athek!” ");
INSERT INTO aly_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ra aterirrek, “Apmer nhenh aknganenty! Nhenh apekan Akngey-kenh apmerelarl ayeng aynteyel!” ");
INSERT INTO aly_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ra apwert rtemal renh arrernek Akngeyek, anterel apernemel. ");
INSERT INTO aly_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ra apmer renh itnewek Bethel, Luz-tangkwel arrwekel-antey itna ra ayntenh. Ra angkek, “Akngey nhel-antey aneyel!” ");
INSERT INTO aly_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ra Akngey ilek, “Ntwa ayenh arntarnt-arem, amern-then arnkwethen anthem, ");
INSERT INTO aly_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ntwa ayenh iteth-antey akngey-alpenty, ayeng ngkweng awelhem. Nga INGKART atyenh aneyenh. ");
INSERT INTO aly_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Apmer nhan apmer ngkwenhan. Atha ngenh tyenkerr anthem.” ");
INSERT INTO aly_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jacob aleth-antey alpenh akngerrakw-antey. ");
INSERT INTO aly_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ra ngenty-anem arey-alhek. Ngenty ra apwert-rnemel artekarl. Yep-yep akngerr rtnenherrenh, kwaty ngenty-itwel, apwertelarl artek-itwel. ");
INSERT INTO aly_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Yep-yep arntarnt-arey-angker-rnemel apwert renh arnangilek, yep-yep-rnem kwaty anthwengiley-alkenh. Kwaty yep-yep-rnemarl ayntwek-penh, rernem angkep arrpemarl marteynenh apwert ikwerel-antey. ");
INSERT INTO aly_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacob-el renh-rnem ayernek, “Nthenh-areny arrantherr?” “Anantherr apmer Haran-arenyarl,” rernem ilelhek. ");
INSERT INTO aly_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Jacob-el renh-rnem ayernek, Arrantherr iterl-areyel Laban apek, Nahor-kenh arrengikw? Kel, anwantherr renh iterl-areyel, rernem renh ilek. ");
INSERT INTO aly_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Rap renh-rnem ayernek, Ilek-apenyarlap ran? Kel, ra mwerr, rernem renh ilek. Alerikw ikwerenh Rachel apetyeyel apmer nhenh-warl yep-yep-rnem-akert. ");
INSERT INTO aly_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Jacob angkek, “Itwern irrwerlel-antey, rwenp inngarl, yep-yep arlwelenhey-alpenh-arey. Kwaty renh-rnem anthwengiletyek, peleyn-warl-anem akngeynemel, atherrk-anem rernem arlkwetyek.” ");
INSERT INTO aly_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","“Alerl-antey mpwelheyel ingkerrenhek, ingkerrenh-angkwarrant apwert renh ahartelheletyek, kwaty-kety.” ");
INSERT INTO aly_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Jacob ikwer-rnem-itwek angkenh-antey, altyelikw ikwerenh apetyek, aynikw-kenh yep-yep-rnem-akert. Rachel yep-yep arntarnt-arey-angker anenh. ");
INSERT INTO aly_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Renh arek, Jacob-elarl apwert renh arnangilek, yep-yep-rnemarl kwaty antywey-alkenh. Apmarlikw-kenh yep-yep-rnem anthwengilek. ");
INSERT INTO aly_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Jacob artnek, Rachel renh arrwantyek, ikwer inkwerelhemel. ");
INSERT INTO aly_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jacob Rachel ikwer ilelhek, “Ayengan Laban-kenh ampikwarl, Rebekah-kenharl.” Rachel ra anterrek, aynikw ikwerenh iletyek. Ra aynikw ikwerenh iley-alpek. ");
INSERT INTO aly_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laban ra angka awekarl-penh, ra anterrek Jacob ikwer-warl, renh atnyenemel arrwantyek, apmer ikwerenh-warl-anem atnwenheynek. Jacob Laban ikwer-warl ilelhek. ");
INSERT INTO aly_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban angkek, “Nga ampaty atyenh inngarl.” Jacob alkent anyentel Laban ikwer-itwel anek. ");
INSERT INTO aly_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban Jacob ikwer angkek, “Ngan ampaty atyenhan. Arwa nga warrkirrekerr, ilek atha ngenh antheman, ngenh kwarteweyek Nthakenh nga iterreyelan?” ");
INSERT INTO aly_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban-kenh alerikw-atherr anek, Leah-atherr. Ayteyikw ikwerenh Rachel. ");
INSERT INTO aly_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leah aleyak alpwely, alkwemp-apeny, Rachel aleyak pwentyeyn innga. ");
INSERT INTO aly_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacob ilkelhenh Rachel-ekant. Laban ikwer-warl angkek, “Aherrety 7-pelek-atwety ayeng warrkirrem ngkweng Rachel-itwek-anem ayeng itengirrey-alenty.” ");
INSERT INTO aly_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban-el renh ilek, “Mwerrarl nga itengirrentyan ingwer-rnem-kety. Mwerr-ayteng atha ngenh anthetyek. Mwerr atyeng-itwel ana warrkirremel.” ");
INSERT INTO aly_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Jacob aherrety 7-pelek-atwety warrkirrek Laban-ek, Rachel renh anthey-akenh. Ra ikwer-itwel itengirrey-angenh-antey. Kel, aherrety 7-penh, Jacob ra inkwerelhek Rachel-ek. Jacob angkek Laban ikwer-warl, ");
INSERT INTO aly_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","“Kel-anem anew atyeng Rachel anthanem, ayeng ikwer-itwek ayntetyek. Aherrety 7-pel ayeng warrkirrenh. Atha warrk atyenh kel ywerrelhilek.” ");
INSERT INTO aly_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ingwa ikwerel-antey rernem amern kwenty-anem arlkwek inkwerelhemel. Artwa ingkerrenh akarrirrek ikwer-rnem-warl. Laban akngerrek yangkelhek, amern tyenkerr arlkwetyek, Jacob Rachel-itwel itengirrek-angkwarr, amern rernem akngerr arlkwetyek inkwerelhemel ikwer-atherr. ");
INSERT INTO aly_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ingwel, Laban-el Leah-anem Jacob renh anthek, anew ikwer anetyek. Jacob ra ikwer-itwek ayntek, Rachel-itwel-arrpantey, apal-antey. ");
INSERT INTO aly_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban-el arelh Zilpah renh ilanthek Leah-ek warrkirretyek. ");
INSERT INTO aly_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ingwepenh-anem Jacob-el arek, Leah-anem ikwer-itwek ayntenh. Ra iterrek Rachel-ek-athen. Jacob-el Laban renh ayernek, “Ilekek ntwa ayenh irrtywerremel ilek, Rachel anthentyek-arrpantey! Ilekek ntwa irrtywerl-ampernek? Ntwa ayenh Leah anthek, ayengan warrkirrek Rachel-ekant.” ");
INSERT INTO aly_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban-el Jacob renh ilek, “Apmer anwekantherrenh-itwekan arrwekeleny-tangkwel itengirrem. Kwey arrwekeleny antheman, ingkerneny nthakenh anthey-angenh. Alakenh-anyem anwekantherrenh-angkwarran aynteyel, arrwekelenyant antheyel, ingkernenyan arrangkwarl. Wik anyentek-atwety mpwelanth Leah-atherr anetyek. Ikwer-penhan nga Rachel-itwek itengirrey-akenh, nga aherrety 7 ingwerek-atwety atyeng warrkirretyek, atharl Rachel anthek-penh, iteng-anem.” ");
INSERT INTO aly_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","30","Wik anyent-penh, kwenty arlkwek-penh Laban-el alerikw ikwerenh Rachel anthek Jacob-itwek itengirretyek. Laban-el arelh Bilhah renh ilanthek, Rachel-ek warrkirretyek. Jacob Rachel-itwek innganem ayntek. Ra Rachel ikwerant inkwerelhek, Leah-angkwarran. Aherrety 7 ingwerek-atwety warrkirrek. ");
INSERT INTO aly_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","INGKARTel arek, Jacob-arl Leah-kety arlkarirrenh, ra ikwer amperrngirrek. ");
INSERT INTO aly_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Alakenh Leah-el ampa atnyenek. Rachel ampek arrangkw aleth anek. Leah-kenh awey akely ayntenh. Ra renh Reuben itnewek, alakenh angka ikwerenhel aynteyel, “INGKARTel ayenh irrkngerney anthek. Anew atyenh apek atyeng inkwerelhem.” Ra iterrek Jacob-an ikwer ilkelherl-anentyek-athen. ");
INSERT INTO aly_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Leah ra ampa ingweran atnyenek, awey akely arrpemarl. Leah angkek, “Akngeyel arek anew atyenh, rarl atyeng inkwerelhey-angenh. Alakenh-they ra ayenh awey nhanyem anthek. Rernem renh itnewek Simeon.” ");
INSERT INTO aly_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ikwer-they ra ampa ingweran atnyenek, awey akely arrpemarl. Awey irrpety-anem ikwerenh. Ra angkek, “Ikwer-they anew atyenh inkwerelhem-anem atyeng. Awey irrpety-anem atyenh.” Ranem renh itnewek Levi. ");
INSERT INTO aly_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ampa ingweran atnyenek, awey akely arrpemarl. Ra angkek, “Rlengk-anem atha INGKART renh tnakem.” Ranem renh itnewek Judah. Ikwer-they Leah ra ampa ingwerek arrangkw-anem anek. ");
INSERT INTO aly_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rachel ahelirrenh Leah-ek, ampa rantarl atnyenek-they. Rap Jacob renh alharlkwemel ilek, “Ayeng ilweyenh ampeweny-antey.” ");
INSERT INTO aly_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jacob rarl awek-penh, ra antwerr-anem anenh ilelhemel, “Ayengan arlarl Akngey-wenyarl. Nhenhan Akngey-kenh-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rachel-el anew renh ilek, “Warrkenh atyenh Bilhah ikngwerl-alpa, ngkweng-itwek ayntetyek, ampa ntwa atnyenetyek ikwer-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Rachel-el arelh warrkenh Bilhah ilanthek, Jacob-itwel itengirretyek. Kel ratherr itengirrek, Jacob arelh warrkenh ikwer-itwel ayntek. ");
INSERT INTO aly_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilhah ra ampa akely atnyenek, awey akely. ");
INSERT INTO aly_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rachel renh itnewek Dan alakenh angkemel, “Akngeyel ayenh arntarnt-arek, Akngey atyeng awelhek atharl renh ayernek, kel ayenh awey akely anthek.” ");
INSERT INTO aly_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rachel-kenh warrkenh Bilhah, ra ampa ingwer atnyenek, Jacob-kenh. ");
INSERT INTO aly_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rachel angkek, “Ayengarl arrkernelhenh, kel angkwerey atyenh atha antengilek.” Rap awey akely renh itnewek Naphtali. ");
INSERT INTO aly_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leah iterrek kel ampa anyent ilenh ra atnyenek, ingweran ra atnyeney-angenh, arrangkw-anem. Ra arelh warrkenh ikwerenh Zilpah ilanthek, Jacob-itwel itengirretyek. ");
INSERT INTO aly_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ratherr awey akely atnyenek. ");
INSERT INTO aly_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leah angkek, “Nhenh mwerr-angkwarr alakenh.” Ranem awey akely renh Gad itnewek, alakenh aynteyel angka ikwerenhel, “Nhenh mwerr-angkwarr alakenh.” ");
INSERT INTO aly_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilpah ra awey ingweran atnyenek. ");
INSERT INTO aly_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leah angkek, “Irrkngerney-anem ayeng aneyel. Arelh ingwer-rnem atyeng angkerreyel, ayengarl irrkngerney-anem aneyelek.” Leah-el renh itnewek Asher. ");
INSERT INTO aly_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Kel rernem ntang weyt akwetyemel warrkirrek, awey Reuben-el amern mandrake-angketyarr arek, amern irrwarlp-apeny. Kel ra amern mandrake akek, amikw ikwerenh-warl akngey-alpek. Rachel-el Leah renh ayernek, “Awey ngwenhel amern mandrake irrpety ayenh anthey.” ");
INSERT INTO aly_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leah-el renh ilek, “Kel amern mandrake-anemarl ntwa raketyek arrkernelheyel.” Rachel-el Leah renh ilek, “Ntwa amern mandrake ayenh anthem, nga Jacob-itwel iteng ayntey-kety.” ");
INSERT INTO aly_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Atwerrp, Jacob kel apey-alpek, amern weyt-angketyarr-they. Leah ikwer anekirrek, angkemel, “Nga lyert atyeng-itwel ayntetyek. Awey atyenhel Rachel amern mandrake renh kwartewemel anthek-apeny.” Kel, Jacob Leah-itwek ayntek. ");
INSERT INTO aly_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Akngey Leah-ek inkwerelhemel awelhek, rarl renh ayernek, ampa renh anthetyek. Leah-el ampa akely atnyenek, awey anyent. Jacob-kenh awey 5-pel anek, Leah ikwer-angkwarr. ");
INSERT INTO aly_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leah angkek, “Akngey atyeng inkwerelhek, atharl warrkenh atyenh ilanthek, Jacob ikwer ratherr iteng anetyek.” Ranem renh itnewek Issachar. ");
INSERT INTO aly_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leah-el ampa ingwer atnyenek, awey akely. Jacob-kenh awey 6-pel-anem anek, amikw anyent-kenh 6 Leah-ek. ");
INSERT INTO aly_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leah angkek, “Akngeyel ayenh ampa akngerr anthemel kwartewek. Anew atyenh atyeng inkwerelhem, aylernekanthenharl awey 6-pel aneyel.” Ranem renh Zebulun itnewek. ");
INSERT INTO aly_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ikwer-penh Leah-el kwey akely-anemarl atnyenek, renh Dinah itnewek. ");
INSERT INTO aly_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Akngey Rachel-ek amperrngirrek, irrepernek, rarl renh ayernek, ampa renh anthetyek. ");
INSERT INTO aly_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Rachel ra ampa ingweran atnyenek, awey akely. Ra angkek, “Akngey atyeng amperrngirrek irrepernek, ampa ayenh anthetyek. Ingwerel-anem nthakenh ayenh kwanthey-angenh, ayengan ampewenyarl.” ");
INSERT INTO aly_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ranem renh itnewek Joseph alakenh angkemel, “Atha Akngey renh ayerney, awey akely ingwer-anemarl ayenh anthetyek.” ");
INSERT INTO aly_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Joseph, Rachel-kenh awey akely ayntek. Jacob Laban-warl angkek, “Ayenh ntwa tyarlewetyek, ");
INSERT INTO aly_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ayeng apmer atyenh-warl-anem alpetyek. Anew atyenh-atherr-then ampernem-then anwernantherr ingkerrenh alpetyek. Ayeng ngkweng warrkirrek.” ");
INSERT INTO aly_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban-el renh ilek, “Nga atyeng arlkwententy, atyengel-arleng anarl! Artwa tyakel ayenh ilek, Akngeyelarl ayenh arntarnt-arek, ngkweng-angkwarr. ");
INSERT INTO aly_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ilek atha ngenh kwartewem, nga inkwerelhetyek?” ");
INSERT INTO aly_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jacob-el renh ilek, “Ayeng ngkweng mwerr-angkwarr warrkirrenh. Aker ngkwenh akngerr innganem irrek. ");
INSERT INTO aly_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Lyertenyank ayeng apmer nhewarl apetyek yep-yep irrpetyaparl ngkwenh ntwa atnyenek. Anamerl yep-yep ngkwenh akngerrirrek. Akngeyel ngenh arntarnt-arenh, atyeng-angkwarr. Ayeng ipmelheyek warrk nhethey, atyenh-rnem-anemarl atha arntarnt-aretyek.” ");
INSERT INTO aly_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban-el renh ayernek, “Ilek atha ngenh antheman, nga nhel atyeng-itwel anetyek? Ilek-angkwarr ngkweng mwerran?” Jacob-el renh ilek, “Kel menty, man-weny. Ngkwelty ntwa ayenh antheyang. Yep-yepel-then nanikwetel-thenant ntwa ayenh kwartewa. ");
INSERT INTO aly_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Atnwenth irrpwerlant ayenh antha lthweyakw, arlkeny-arlkeny. Irrpwerl-rnem-then lthweyakw-lthweyakw-rnem-thenant ayenh antha! Kel ayeng inkwerelhem ilenh-rnemant ntwa ayenh anthentyek. ");
INSERT INTO aly_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ntwa alhengk-aretyek irrpwerl-then lthweyakw-lthweyakwantarl ntwa ayenh anthek, atha ngkwenh anyelkel yep-yep-rnem inentyek, ntwa alhengk-aretyek, yep-yep ngkwenh-rnem, atharl yep-yep ngkwenh-rnem irrtyertel-inekerr.” ");
INSERT INTO aly_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban ikwer angkek, “Mwerrarl ilenh-angkwarran.” ");
INSERT INTO aly_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Arlta anyent ikwerel-antey Laban-el atnwenth lthweyakw-lthweyakw-rnem-then irrpwerl-rnem-then ikweran amentilek, ikwerenh-rnem ament arrpemarl akngakek. Alerikw ikwerenh-rnem ra arrernek, yep-yep ikwerenh-rnem rernem arntarnt-aretyek. ");
INSERT INTO aly_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Laban-el Jacob renh ilek, “Arlta irrpetyel alpa yep-yep ilenh-rnem-akert, nanikwet-rnem-then.” ");
INSERT INTO aly_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jacob-el arwerl akek walyenp, arwerl akngerr. Arwerl-penh rltimp alerrkw, lthweyakw-lthweyakw ilemel. ");
INSERT INTO aly_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Arwerl renh-rnem rnkernek kwaty trough impalthek, yep-yepel-rnem kwaty-warl apetyentyel arwerl renh-rnem aretyek. ");
INSERT INTO aly_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Akwerrk lthweyakw-lthweyakw-rnem-then akngerr-anem anek. ");
INSERT INTO aly_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Laban-kenh-rnem lthweyakw-lthweyakw-rnem akngerr arrpemarl. Laban-kenh lthweyakw-lthweyakw-rnem pweytilek ikwerenh-rnem-warl. Akwerrk lthweyakw-lthweyakw-rnem akngerr-anem irrek. Jacob-el muster-emileynek anetyek akngakeynek lthweyakw-lthweyakw-rnemant, ikwerenh-rnem-warl pweytiletyek. ");
INSERT INTO aly_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Yep-yep rlterrk-rnem-kety arwerl-rneman alperr-akertan rnkernenh arrpemarl ra. Alakenh-anyem Jacob-el arlwerrek ikwerenh-rnem rlterrk ingkerr. Laban-kenh-rnem rlterrk-weny-antey. ");
INSERT INTO aly_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Yep-yep-rnem nanikwet-rnem-then mwerr ingkerrenh arntety-weny akngerrirrek ikwerenh. ");
INSERT INTO aly_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Jacob man akngerr-akert-anem, yep-yep akngerr-akert, nanikwet akngerr-akert, kamwerl arrpemarl ikwerenh tangkey akngerr arrpemarl ikwerenh, artwa warrkenh-rnem akngerr arrpemarl ikwerenh. ");
INSERT INTO aly_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jacob-el awek Laban-kenh alerikw-rnem ikwer angkerrenharl, Jacob ra man akngerr-akert, yep-yep-rnem-then nanikwet-rnem-then, ampwal-rnem-then. Akngey anwekingkerrenhel renh anthek, rarl akngey anwekingkerrenh-they akngerr inek. ");
INSERT INTO aly_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jacob-el Laban renh arek, Laban rarl ikwer arlkwenteyang-anemarl. ");
INSERT INTO aly_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","INGKARTel Jacob renh ilek, “Akngey-kenh arreng-kenh apmer-warl nga alpetyek. Ayengan ngkweng-angkwarr alhetyek arrpemarl ilkwatherr.” ");
INSERT INTO aly_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jacob yangkelhek Rachel-ek-atherr Leah-ek-atherr ratherr ikwer-warl apetyetyek, renh rlwatetyek yep-yep-akert. ");
INSERT INTO aly_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Jacob-el renh-atherr ilek, “Akngey mpwel-kenh atyengety arlkarirreyel-anem. Akngeyel ayenh arntarnt-arek, akngey atyenharl ikwer inkwerelhek. ");
INSERT INTO aly_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ayengarl warrkirrek mwantyel Akngey mpwel-kenhek. ");
INSERT INTO aly_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Akngey mpwel-kenhel ayenh man arraty anthey-angenh. Akngeyelant ayenh arntarnt-areyel. ");
INSERT INTO aly_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Akngey mpwel-kenhel yep-yep irrpwerl-rnemant, lthweyakw-lthweyakw-rnemant alhelek. Kel rernem-anem akngerrirrek. ");
INSERT INTO aly_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ilenh-angkwarr Akngeyel atnwenth renh-rnem kel rakek, ayenh-anem anthek. ");
INSERT INTO aly_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Kel atha altyerr arek, atnwenth-rnem ingkerrenh. Yep-yep-then nanikwet-rnem-then akngerr inngan anek, lthweyakw-lthweyakw ingkerrenh. ");
INSERT INTO aly_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Akngey-kenh angel atyeng arlkek, ‘Jacob-ay.’ ‘Nhantey ayeng aneyelaw.’ Ayeng ikwer ilelhek. ");
INSERT INTO aly_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Angel-el ayenh ilek, ‘Ntwa areyel lthweyakw-lthweyakw ilenh-rnem? Aray! Atharl arek Laban renh, rarl ngenh irrtywerremel ilek. Atha atnwenth-rnem lthweyakw-lthweyakw renh-rnem mpwarek. ");
INSERT INTO aly_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Aray, ayeng Akngey apmer Bethel-areny. Wetharl ntwa apwert anterel apernek, ayenh arraty ilek. Arraty ntwa ayenh alhelek. Apmer nhenh ntwa iwerlelpetyek, apmer ngkwenh-warl-anem nga alpetyek.’” ");
INSERT INTO aly_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Angkwerenheng ratherr Jacob renh ilek, “Akngey-they anwantherr arnkwa akngerr ineyang ikwer-they. ");
INSERT INTO aly_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ingwer-apenyarl anwantherr ikwer arrareyel. Man anwenhantherr anthey-angenh, anwantherrarl itengirrek. Ratherr tyel-angkenh aynikw ikwer-atherrenhek. ");
INSERT INTO aly_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Arnkwernem ampwal ilenh-rneman aylekenharl ampernem-kenh-then, anwernekantherrenh. Akngey ikwer nga awelhetyekant. Alakenh-anyem akngey aylekenh-they Akngeyel rakek, ngenh-anem anthek, anwantherr-anem renh-rnem atnyenetyek.” ");
INSERT INTO aly_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Jacob-el anew-rnem-then ampernem-then kamwerl-warl tywenek. ");
INSERT INTO aly_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Rernem alpek aynikw ikwerenh apmer-warl, apmer Canaan-warl. Atnwenth-rnem ingkerrenh ampwal-rnem-then rarl inek malyikw-they, ra akngeynetyek. ");
INSERT INTO aly_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laban-el yep-yep ikwerenh-rnem alta althek-angkwarr, Rachel-el ampwal ikwerenh-rnem anyelkel inerl-alhek. Akngey-arrpantey-rnem, akely-rnem. ");
INSERT INTO aly_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jacob Laban ikwerety anyelk-antey alpek. ");
INSERT INTO aly_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Jacob ra Lher Euphrates artarnpenhek, apwert-angketyarr-warl, apmer itnan Gilead, ampwal ingkerrenh-akert. ");
INSERT INTO aly_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Arlta irrpety-penh, Laban ra Jacob ikwer ywarek. Ingwerentyel Laban renh ilek. ");
INSERT INTO aly_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Laban-el Jacob renh alwernek, artwa ikwerenh-rnem-akertel, arlta 7-el, apmer Gilead-ek-atwety. ");
INSERT INTO aly_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ingwel Laban-el altyerr arek, INGKARTelarl renh ilek, “Alhewer angkey-angenh-antey Jacob ikwer.” ");
INSERT INTO aly_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jacob-el kalikw-rnem artek, apmer Gilead ikwerel, apwert-angketyarrel. Laban-el-rnem apmer arrernek, apmer Gilead-itwel arrpemarl, apwert ingwer-ampenyekarl. ");
INSERT INTO aly_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban Jacob ikwer-warl alhek. Rap renh ilek, “Ntwa ayenh irrtywerremel ilerlelpek anterrey-alhemel, ampa atyenh atherr-akert. Artwa ingwer-rnem irrtyert-awarrarl aneyel-apenyarl ngan! ");
INSERT INTO aly_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nga irrtyertelarl anterrek, atyeng ilerlelpey-angenh. Atha ngenh inkwerelhemel menty intwaremer, nga atyeng ilelhentyan. ");
INSERT INTO aly_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Atha artartey atyenh-rnem arrwantyey-angenh-antey, ntwa anterrelhilek. Arraty-angkwarr-wenyarl alakenhan. ");
INSERT INTO aly_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Atharl ngenh atwetyek-anek. Akngey ngkwenh-kenh INGKARTel ayenh artwerilek, ngkweng apmwangkwarr angkey-angenh, ayenh arternpiletyek. ");
INSERT INTO aly_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Kel, atha ngenh iterl-arekarl, ngarl alpetyek alharntek akngey ngkwenh-kenh apmer-warl. Ntwa ingkart-arrpantey akely-rnem anyelkel inerlelpek.” ");
INSERT INTO aly_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacob-el Laban renh ilek, “Ayeng ngkwengety anyelkel alpek aterel, ntwa alerengkw ngkwenh-atherr anterrkwekerr. ");
INSERT INTO aly_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Anyentel apek ingkart-arrpantey renh anyelkel inenty, ntwa renh ipmek atwetyek. Ngkwenh-rneman akalty arrpemarl anetyek, ntwarl renh atwemek. Arnkwa ingwer-rnemarl aynteyel, ntwa kel akngeynetyekan. Jacob apal angkek, iterl-areyang Rachel renh rarl ingkart-arrpantey anyelkel inerl-alhek.” ");
INSERT INTO aly_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban ra kalikw arrpanenh-warl aylpek, ingkart-arrpantey-rnem aretyek, kalikw renh-rnem arrangkw ywarek, Jacob-kenh, Leah-kenh, arelh warrkenh-atherr-kenh. Rachel-kenh kalikw-warl-anem aylpek. ");
INSERT INTO aly_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rachel-el arlengkewek kamwerl saddle-warl, kweneng-apert, Rachel ranem irrwerleng anenh kamwerl saddle ikwerel. Laban nthwek ipantey. ");
INSERT INTO aly_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rachel-el Laban renh ilek, “Akngey, atyeng nga ahelirrey-angenh, ayeng intem nhel anayntem. Akapwert ayeng arntety, ayeng nthakenh akemirrey-angenh.” Alakenh-anyem ingkart-arrpantey ikwer-rnem Laban ra ywarek. ");
INSERT INTO aly_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jacob ra ahelarl irrekel, Laban renh iltek, “Ilekekarl ntwa ayenhan itwengetilek, atha ampwal-rnem irrtyert-inenty-arrpantey? Atha anyelkel ingkart-arrpantey renh-rnem akngey-alpenty-arrpanteyan. Ayeng arlarl, atha renh-rnem akngey-alpeyangarl. Ilek ntwa ayenharl alwerneyel? ");
INSERT INTO aly_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ntwa apek arek, atharl ampwal-rnem anyelkel akngey-alpek? Ntwarl renh arey-alhenty, ntwap renh arrerna akethek, akngerrel aretyek. Anwantherr ikwer angkerretyek, arratyilemel. ");
INSERT INTO aly_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Iterl-aray, ayengarl ngkweng warrkirrek aherrety 20-ek-atwety. Yep-yep akwerrk-rnem arek ilwey-angenharl mwerr. Ingkerrenh mwerr itethewek. Yep-yep irrwey atha anyelkel ngkwenh iney-angenh, inemel atwey-angenh. ");
INSERT INTO aly_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Arengk artnwerel yep-yep ngkwenh rlterrp-rlterremel tnhwek, atha yep-yep atyenh impen-anem angkep arrerneynem. ");
INSERT INTO aly_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Itwernek rwenp inngarl, ingwel ayenh irrentelarl atwek ankwayntey-angenh ilek. Aherrety 20-ek-atwety ayeng iylpareth ngkweng warrkirrenh, aylpenyirrey-angenh. ");
INSERT INTO aly_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ayeng ngkweng warrkirrenh aherrety 14-ek-atwety, alerengkw ngkwenh-atherr atha payemelemel. Aherrety 6-ek-atwety ayeng ngkweng warrkirrenh, atnwenth-rnem ingkerrenh payemelemel, ntwa ayenh anthetyek. Ntwa ayenh man mwerr payemeley-angenh, ntwa ayenh man akelyarl anthenh. Akngeyel-anem ayenh arntarnt-arenh, Akngey renharl arrengey atyenh Abraham-el apentek, akngey atyenh Isaac-el apentek. Arrengey atyenh-kenh Akngey Abraham-kenh, akngey atyenh-kenh Isaac-kenh Akngey ra ayenh arntarnt-arenh. ");
INSERT INTO aly_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ntwa ayenh thwenem apmer ngkwenh-they, ayeng arrangkw alpetyek, Akngeyel ayenh arntarnt-arem ilenh-angkwarran, ntwa ayenh arrangkw thwenek. Akngeyel ayenh arek, ra atyeng amperrngirrek, ayengarl ngkweng mwerr-angkwarr warrkirrek. Ingwel, Akngeyel angka awerr ngenh anthek.” ");
INSERT INTO aly_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban-el Jacob renh ilek, “Alerey atyenh-atherr ntwa atnyeneyel, artartey-rnem-then. Atnwenth atyenh-rnem ntwa atnyeneyel. Ampwal atyenh-rnem-then ingkerrenh ntwa atnyeneyel, atharl ngenh anthek. Alerey atyenh-atherr-then artartey-rnem-then nthakenh atha ngkwengety anterrkwey-angenh. ");
INSERT INTO aly_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Aylanth angkerretyek, mwerrant-atherr aylanth anetyek. Apwert ilperr-ilperr-rnem aylanth arrernetyek, ingkerrenhel aylenhanth iterl-aretyek, aylanth mwerrant-atherr anetyek.” ");
INSERT INTO aly_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Jacob-el apwert ilkwa rnkernek. ");
INSERT INTO aly_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Jacob-el ikwerenh-rnem ilek, “Apwert ingwer-anemarl mpwer rnkerney. Apwert ingwer-rnem-anemarl akarriley.” Apwert ilperr-ilperrel ampernemel ratherr amern arlkwek. ... ");
INSERT INTO aly_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ingwepenh, Laban-el artarteyikw-rnem arrwantyek, kwey ikwerenh-atherr-then. Alpek-anem ra apmer-warl. ");
INSERT INTO aly_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacob angkep alpenh. Angel-rnemel renh rlwatek. Jacob-el renh-rnem arek-penh angkek, ");
INSERT INTO aly_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","“Nhenh Akngey-kenh apmerarl.” Ra itnewek apmer renh itnan Mahanaim. ");
INSERT INTO aly_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Esau apmer Seir-el anenh, apmer Edom ikwerel. Jacob-el angkakert atherr thwenek Esau-warl, apmer Seir-warl. ");
INSERT INTO aly_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","“Alakenh ayeng ngkweng awelhem. Laban-itwek ayeng anenh. ");
INSERT INTO aly_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Aleyan atyenh tangkey-rnem-then pwelek-rnem-then yep-yep-rnem-then warrkenh artwernem-then, arelh-rnem-then. Artwa nhenh-atherr atha ngkweng-warl thweneyel, nga atyeng inkwerelhetyek.” ");
INSERT INTO aly_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Angkakert ratherr apey-alpek, ratherr iley-alpek, “Esau nhewarl apetyeyel atningk ingwer-rnem-then.” ");
INSERT INTO aly_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jacob ater-anem irrek. Aterirremel-anem akngakek, atnwenth-rnem ingkerrenh artwernem-then. ");
INSERT INTO aly_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","“Esau-el anyent-ampeny atwentyan ingwer-ampeny-they ikwerety anterremarl.” ");
INSERT INTO aly_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ikwer-they Jacob Akngey-warl angkek, “Akngey ngenharl arrengey atyenhel apentenh, akngey atyenhel apentenh. INGKARTay, ntwa ayenh thwenek apmer-warl, atyenh-rnem aneyel-warl. Ntwa ayenh alhelek, ayenh arntarnt-aretyek, atyenh-rnem akngerriletyek. ");
INSERT INTO aly_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","INGKARTay, nga atyeng inkwerelhek, ntwa ayenh ipmey-angenh, aleth-antey arntarnt-arek. Ayeng irrertety atyenhant-akert Jordan Ilpay-angkwarr artarnpenhek. Atyenh-rnem akngerr innganem aleyant, atnwenth-rnem-then. ");
INSERT INTO aly_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Atha ngenh ayernem, ayenh awayaty atyenh-kety Esau-kety arntarnt-ara. Ayeng ikwerety aterirreyel, ra anwenhantherr ingkerrenh-antey atwekerr. Amenheng-rnem ingkerrenh-antey. ");
INSERT INTO aly_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ntwa ayenh alhelek, ‘Atha ngenh arntarnt-aretyek. Atha atyenh-rnem akngerram-akngerrileyenh. Rernem akngerr innga aneyenh. Rernem akngerram-akngerrirreyenh antyarr-rnem akngerr alkerel aynteyel-apeny. Ingwer-rnemel ywarn-antey count-emileyenh antyarr-rnem-apeny.’” ... ");
INSERT INTO aly_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ingwa ikwerel-antey Jacob ra akemirrek. Anew ikwerenh atherr-akert arelh warrkenh ikwerenh-atherr-akert alerikw ikwerenh 11-pel-akert. ");
INSERT INTO aly_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Rernem Jabbok Ilpay-angkwarr artarnpenhek, atnwenth-rnem-then ikwerenh ra artarnpelhelek. ");
INSERT INTO aly_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Kel, ament-areny ra anek. Artwa anyent ikwer-warl apetyek. Ratherr atwerrenh ingwepenhek-atwety. Ratherr intewerrenh. ");
INSERT INTO aly_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Artwa ra ikwerant-penh arrkernelhek, Jacob antengiletyek. Ra aneny atwek, aneny ngkwern akngenhelhilek. Iytekilemel-anem apmwelek. Ratherr aleth-antey intewerrenh. ");
INSERT INTO aly_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Artwa rap angkek Jacob ikwer-warl, “Ipmanem ayenh, ingwepenh-anem irreyel-kety.” Jacob angkek, “Nthakenh alpey-angenh, mwerr-angkwarr atyeng angka, Akngeyel ayenh arntarnt-aretyek!” ");
INSERT INTO aly_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Artwa ra ayernek, “Ilek itna ngan?” Jacob ra ilelhek, “Ayengan Jacob-arl.” ");
INSERT INTO aly_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Artwa ra ilek, “Itnan ngkwenh Jacob-weny-anemarl, ngarl Akngeyek arrkernelhenh artwernem-then. Ingkerrenhel ngenh itnew-ayntem Israel-ant-anem.” Angka ikwer-rnem-kenhel-anem Israel aynteyel, “Ratherr Akngey-then intewerrenh, antengiletyek-arrpantey.” ");
INSERT INTO aly_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jacob-el renh ilek, “Nganem itna itnewelha atyeng!” Artwa ra tyernek, “Nthakenh ntwa ayenh iterl-arey-angenharl, ra mwerr-angkwarr mpwarek.” ");
INSERT INTO aly_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jacob-el apmer renh Peniel itnewek, angka ikwerenhel. Alakenh-anyem aynteyel, “Atharl Akngey renh arek, ra ayenh ipmek atwey-angenh.” Alakenh-anyem aleyan aynteyel itnan ");
INSERT INTO aly_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ingkeny kel tyerrelhek-anem. Ra iyternemel-anem alhenh, aneny ngkwern renh tyerrek-kety. ");
INSERT INTO aly_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Alakenhaym-kety Israel-kenh-rnemel apmelerr aker aneny-penh nthakenh arlkwey-angenh atnwenth-penh. ");
INSERT INTO aly_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","2","Jacob-el Esau renh arnarek, irlkenty akngerr-akert, artwa 400, ikwer-warlarl apetyenh. ... ");
INSERT INTO aly_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Jacob ra ingkerrenh-itwek arrwekel-ampenyel. Ra kwenirrek akngerr-inger arrwekel, rarl kakey ikwerenh-warl alhenhel. Jacob-warl. ... ");
INSERT INTO aly_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esau Jacob ikwer-warl anterrek, renh anterrkwemel renh arrwantyemel. Ratherr atherr-antey artnek. ... ");
INSERT INTO aly_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","... Jacob ikwerenh-rnem-akertel Bethel ikwer-they alpek. Rernem apmer Eprath-they arleng-antey alpenh. Rachel ra arntety awelhenh. ");
INSERT INTO aly_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Arelh warrkenh rarl Rachel renh arntarnt-arenh. Arelh ra Rachel renh ilek, “Ntwa awey atnyeneyel.” ");
INSERT INTO aly_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Rachel ra ilwetyek-anem irrek, ra awey renh itnewek Ben-Oni. Rachel kel ilwek. Aynelikw ikwerenh renh itnewek Benjamin. ... ");
INSERT INTO aly_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob ra alpek aynikw ikwerenh apmer-warl, apmer itnan Hebron, itna ingweran Mamre, Kerath Arba-they arrer. ");
INSERT INTO aly_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Aherrety 180 ra anenh. Isaac ra ilwek. ");
INSERT INTO aly_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Alerikw ikwerenhel atherr Esau-el, Jacob-el atherr renh apmer-itwek akwernek, rarl ilwek. ... ");
INSERT INTO aly_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","2","Jacob ra apmer Canaan-itwek anenh, aynikw ikwerenharl Isaac anenh-itwek. Angka nhenh Jacob-kenh-rnem-akert. Joseph aherrety 17-anem anenh. Yep-yep-rnem-then nanikwet-rnem-then arntarnt-arenh, atherrk-warl ra akngenh, apmer Shechem-itwek. Kakey ikwerenhel-rnem. Aynikwel Joseph thwenek awayengkw-rnem-warl, “Alha yep-yep-rnem arntarnt-arayntetyek.” Joseph awayikwel-rnem-then yep-yep-rnem arntarnt-arek. Amikw ingwer atherr-kenh Bilhah-kenh-rnem, Zilpah-kenh-rnem. Jacob-kenh anew atherr-kenh. Joseph-el aynikw ikwerenh angka apmwa ikwer-rnem ilenh. ");
INSERT INTO aly_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Jacob Joseph-ekant inkwerelhek alerikw ingwer-rnem-theyan, rarl ingkerneny ikwerenh. Arnkwa arlkeny ingwerek-ingwer-akert aylpey-angker ra anthek. ");
INSERT INTO aly_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Joseph-kenh awayikw-rnem ikwer ahelirrek, ikwerantarl aynikw inkwerelhenh-kety, arnkwa mwerr-angker anthek-kety. Rernem ikwer-itwek angka mwerr angkerrey-angenh-anem. ");
INSERT INTO aly_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ingwer-ingerelan Joseph-el altyerr-anem arek. Ra awayikw-rnem ilek, rarl altyerr arek. Rernem ikwer ahelirrek. ");
INSERT INTO aly_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","7","Joseph angkek, “Atyeng arringkerr awelhenherr-arey. Anwingkerr atherrk weyt-rnem arlwarey-arlwarey akwetyemel arertneynenh, ataperrelemel arraty rnkernemel. Atherrk ntang weyt-akert ataperr arlwa atyenh arraty rtnek. Ataperr arrekingkerrenhan ikwer kwenirrekarl, atyetyartekarl kwenirrem-apeny.” ");
INSERT INTO aly_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Awayikw-rnem ingkerrenh-antey ikwer angkek, “Nganang ngay Atyetyart anwekingkerrenh aneyel?” Rernem ikwer ahel-anem irrek, rarl angka renh ilekek, ntang weyt-penh. ");
INSERT INTO aly_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Joseph-el altyerr ingwer-anem arek. Ra awayikw-rnem angka ilek, rarl altyerr arek, “Ingkeny-then alkent-then antyarr 11-pel, rernem atyeng kwenirrek Atyetyartek-apeny.” Joseph-el ikwer-rnem anayntiley-angenh-antey. ");
INSERT INTO aly_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ra aynikw ilek, rarl altyerr renh arek. Aynikw ikwer ahelirrek. “Ilekarlap ran alakenh aynteyel? Ayeng amengkw awayengkw-rnem-then ngkweng kwenirretyek Atyetyart-apeny?” ");
INSERT INTO aly_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Awayikw-rnem ikwer ahelirrek. Aynikw ikwerenh aleth-antey iterrenh, ywarn-antey, rarl angka renh ilekek. ");
INSERT INTO aly_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","13","Awayikw-rnem alhek, yep-yep-rnem-then nanikwet-rnem-then arntarnt-aretyek, apmer Shechem-itwek. Aynikwel Joseph thwenek, “Awayengkw-rnem-warl alha.” Joseph-el renh ilek, “Kel, mwerr.” ");
INSERT INTO aly_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Aynikwel renh ilek, “Awayengkw-rnem arerl-alpa, iley-alpemel atyeng-warl, mwerr yep-yep-rnem rernem arntarnt-areyel.” Ra renh thwenek Hebron arterterr-they apwert irrkerrel-atherr ayntek, ahern arterterr ampepel aynteyneyel. Joseph apmer Shechem-warl alhenh amern weyt-angketyarr-angkwarr. ");
INSERT INTO aly_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Artwa anyentel renh ayernek, “Ilekek nga nthwerl-alpeyel?” ");
INSERT INTO aly_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Joseph-el ilek, “Ayeng nthwerl-apeyel awayaty atyenh-rnemek. Ntwa apek arek renh-rnem? Nthenh-angkwarr rernem alhekan yep-yep-rnem-akert?” Artwel ilek, “Rernem anper-antey alhek. ");
INSERT INTO aly_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Apmer nhenh arrangkw-anem. Atha renh-rnem awek, rernemarl angkerrenh apmer Dothan ikwer-warl alhetyek.” Joseph-el awayikw ikwerenh-rnem arek apmer Dothan ikwer-itwek. ");
INSERT INTO aly_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Awayikwel-rnem renh arnarek, rernem ikwer angkerrek, renh atwetyek. ");
INSERT INTO aly_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","“Yanh ra apetyeyel altyerr arey-angker, tnakelherl-aney-angker. Atyetyart ilelherl-aney-angker! Mpa, anwingkerr ywerrelhemel atwey! ");
INSERT INTO aly_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Anwingkerr renh irrkwewarl iwey, ingwer-rnem-warl ilerl-anemel atnwenth ahelengkwel renh arlkwenty-arrpantey. Ran ilwentyel, rap atyetyart aney-angenh-anemarl!” ");
INSERT INTO aly_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Reuben ra awek rernemarl ikwer angkerrenh atwetyek. Ra arrkernelhek renh-rnem iletyek menty ra anetyek, atwey-angenh. ");
INSERT INTO aly_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ra angkek, “Apmer arlpaw-warl renh akngey, irrka ilkwewarl renh iwetyek.” Ra ikwer iterrenh aynikw-warl akngeynetyek-antey irrkewarl iwenty-penh, renh ayerrpiletyek. ");
INSERT INTO aly_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Joseph awayikw-warl apetyek. Rernem arnkwa arlkeny-angketyarr lhelhek, ");
INSERT INTO aly_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Irrka ilkwewarl renh iwek. ");
INSERT INTO aly_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Joseph-kenh awayikw-rnemel amern-anem arlkwenh. Rernem arek Ishmael-areny-rnem apetyenty apmer Gilead-they. Kamwerl-rnemel ampwal ilek-ilek akngetyenh Egypt-warl. ");
INSERT INTO aly_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Judah-el ilek, “Ilekek anwingkerr aytey anwekingkerrenh atwerl-ayntem? ");
INSERT INTO aly_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Anwingkerr tharlemiley weker-rnem-warl kamwerl-angketyarr yanh-rnem-warl, weker-rnem-warl.” ");
INSERT INTO aly_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Joseph-kenh awayikw-rnemel renh tharlemiletyek weker-rnem-warl. Irrkethey tyerrek. Weker-rnemel renh payemelek, ngkwelty 20-pel-ek. Rernem Joseph renh akngek apmer Egypt-warl. ");
INSERT INTO aly_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Reuben irrkewarl apetyek, ra arrangkw-anem arey-alhek. Arnkwanem ikwerenh ilterrek, arralty-anek. ");
INSERT INTO aly_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ra awayikw ingwer-rnemek angkek, “Awey ra ywerrek irrkethey. Nthakenh-anem ayeng irreman?” ");
INSERT INTO aly_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Joseph-kenh awayikw-rnemel nanikwet atwek, arrkngewarl-anem pwerlpewek, arnkwa arlkeny-angketyarr renhan. ");
INSERT INTO aly_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Arnkwa arlkeny-angketyarr renh rernem aynikw-warl akngeynek, arrkngenp. “Arnkwa nhenh aray! Alerengkw akely ngkwenh-kenh apek!” ");
INSERT INTO aly_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Artwamp Jacob ra alhengk-arek, “Alerey atyenh-kenh yanhan! Arnkwa arlkeny-angketyarr atharl alhengk-areyel, atnwenth ahelengkwel renh arlkwek apek!” ");
INSERT INTO aly_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Apmer-itwek amperrngirrek arleng-alenty, ra arnkwa ikwerenh ilterrek. Ra arnkwa apmwel-anem aylpek, amperrngirremel. ");
INSERT INTO aly_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Rernem ywarn-antey arternpiletyek ikwer arrkernelhenh. Artwamp ilelhek, “Ayeng aleth ikwer artnayntem ilwetyek-atwety.” Aleth-antey artnenh. ");
INSERT INTO aly_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Weker-rnemel Joseph renh tharlemilek, artwa Potiphar-warl. Potiphar Atyetyart anek artwa ahelengkw Egypt-areny-rnemek. ... ");
INSERT INTO aly_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Joseph ra anenh Potiphar-kenh warlel. ");
INSERT INTO aly_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potiphar ra iterl-arek INGKARTelarl Joseph renh arntarnt-arenh, INGKARTel renh ilek-ilek anthek ampwal-rnem. ");
INSERT INTO aly_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","5","Potiphar-el renh arrernek ampwal ingkerrenh arntarnt-arayntetyek warl ingkerrenh, ranem Atyetyart-apeny anenh, Potiphar renh arrernek-angkwarr. Joseph rarl Potiphar-itwek warrkirrenh mwerr-angkwarr Potiphar renh INGKARTel arntarnt-arek arrpemarl. Ra ilek-ilek warrkirrenh Potiphar ikwer. ");
INSERT INTO aly_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Joseph-el ilek-ilek ingkerrenh arntarnt-arenh. Potiphar atnaratyirrek, amernekant iterrenh. ");
INSERT INTO aly_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Joseph inngerr mwerr anenh. Potiphar-kenh anew Joseph ikwer iterrenh, Joseph-ek iytenyirrek, ywarn-antey. Arelh ra renh ayernek, ikwer-itwek ayntetyek. ");
INSERT INTO aly_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","9","Joseph menty angkek, “Kel, menty! Ayeng ilkelhey-angenh. Anew ngkwenh mwerr atyeng aneyel. Rarl ayenh arrernek, warl atha arntarnt-arayntetyek, warrkenh-rnem-then, ampwal-rnem-then. Nthakenh atha INGKART-angkwarr apmwel-areth mpwarey-angenh.” ");
INSERT INTO aly_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Arelh ra aleth-antey ayernenh renh, ikwer-itwek ayntetyek. Joseph ra arelh ikwer awelhey-angenh, arlkarirrenh. ");
INSERT INTO aly_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","12","Arlta anyentel, Joseph ra alhek, warl Potiphar-kenh-warl warrkirretyek. Potiphar-kenh anewikwel arnkwethey-anem renh anterrkwemel ilek, “Nga atyeng-itwek ayntetyek.” Joseph ra warl-they anterrek. Arelh ra renh arnkwa aleth-antey anterrkwenh. Warrkenh ingwer-rneman warl kwen aney-angenh arrangkw, arelh rantarl anenh. ");
INSERT INTO aly_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Arelhel renh arek, rarl anterrenh, arnkwa ikwerenh iwerl-alhemel. ");
INSERT INTO aly_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Arelh ra warrkenh-rnemek arlkelhilek, “Artwa Hebrew yanh arenherr-arey, rarl anenhantherr kwantheyel. Ra apmwel-areth mpwaretyek atyeng arrkernelhek, ayeng ikwerety arlkekarl. ");
INSERT INTO aly_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Rarl ayenh awek, ayengarl arlkek, ra aketh-warl anterrek, arnkwa ikwerenh iwerl-alhemel kwen-itwek-antey.” ");
INSERT INTO aly_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Potiphar-kenh anewel arnkwa renh atnyenenh, Potiphar ra apey-alpetyek-atwety. ");
INSERT INTO aly_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Arelhel irrtywerremel ilek, “Artwa Hebrew warrkenh yanhan arrkernelhek, ayenh mpweny inetyek. ");
INSERT INTO aly_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ayeng ingwer-rnemek arlkek. Artwa ra aketh-warl-anem anterrek, arnkwa ikwerenh iwerl-alhemel.” ");
INSERT INTO aly_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Potiphar ahelirrek-anem, ");
INSERT INTO aly_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Joseph renh tyayl-warl akwernek, Pharaoh-kenh artwa ingwer-rneman tyayl-itwek anenh-warl. Joseph ra tyayl kwenel anenh, INGKARTel renh aleth-antey arntarnt-arenh. ");
INSERT INTO aly_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","INGKARTel Joseph renh arntarnt-arenh tyayl-itwek aleth-antey. Atyetyart tyayl-arenyel Joseph renh arntarnt-arenh arrpemarl. ");
INSERT INTO aly_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Atyetyart tyayl-areny Joseph ikwer Atyetyart-anem ra arrernek tyayl-areny ingwer-rnemek anayntetyek. ");
INSERT INTO aly_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","INGKARTel Joseph renh arntarnt-arenharl, atyetyart tyayl-arenyel Joseph ikwer atnaratyirrek. ");
INSERT INTO aly_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Pharaoh-kenh warrkenh atherr, anyent wayn anthey-angker, warrkenh ingwer amern amperney-angker. ");
INSERT INTO aly_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Ratherr apmwelhelek. Pharaoh ikwer-atherr ahelirrek. ");
INSERT INTO aly_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Atyetyartel artwa ikwerenh-rnem ilanthek warrkenh renh-atherr tyayl-warl akwernetyek. Renh-atherr atherr-antey tyayl anyent-warl akwernek, Joseph-arl anenh-itwek. Rernem arleng-alenty aleth innga anenh. ");
INSERT INTO aly_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Atyetyart tyayl-arenyel Joseph renh ilanthek, ra artwa renh-atherr arntarnt-arayntetyek tyayl kwen. ");
INSERT INTO aly_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ingwa anyentel artwa ratherr atherrel-antey altyerr arek. Akngey ingwerant atherr ratherr arek. ");
INSERT INTO aly_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ingwepenh Joseph ra alhek, artwa renh-atherr aretyek. ");
INSERT INTO aly_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ra renh-atherr arey-alhek, ratherrarl iterrenh artewentyel. Joseph-el renh-atherr ayernek, “Ilek mpwelanth artewentyel iterreyel?” ");
INSERT INTO aly_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ratherr angkek, “Akngey aylanth arek, ingwer-rnemel apek aylekanth anayntileyang angka renh.” Joseph-el ilek, “Akngey rant angka arratyan iterl-areyel. Akngey arek-penh atyeng ilenherr-atherr atha apek iterl-aretyek.” ");
INSERT INTO aly_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","10","Warrkenh wayn anthey-angker ra Joseph renh ilek, “Aylpa irrpety atha arek grapes-itwek, amern-angketyarr irrpety-antey. ");
INSERT INTO aly_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Pharaoh-kenh irrkwa atha atnyenetyek grapes-rnem iltyel anterrkwenhemel grapes-penh akarr irrkwa ikwer-warl thelhemel. Pharaoh renh-anem anthek, ra antywetyek.” ");
INSERT INTO aly_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Joseph-el ikwer anayntilek, “Atha ngkweng ingkerrenharl iley, ilekarl ra aynteyel, aylpa irrpety yanhan, arlta irrpety-apenyarl. ");
INSERT INTO aly_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Arlta irrpety-penhan Atyetyartel ngenh aketh-warl tyarleweyenh. Ntwa warrkenh ikwerenh arrpemarl anem, wayn arrpemarl anthayntetyek, ntwa awank-akerr anthenh-angkwarr-apeny.” ");
INSERT INTO aly_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Joseph-el renh ilek, “Nga tyerrelhentyelan tyayl-they, Pharaoh renh ila, ra ayenh tyayl-they tyarlewetyek. ");
INSERT INTO aly_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Artwa ingwer-rnemelan ayenhan anyelkel inenh Hebrew-kenh apmer-ampeny-they. Ayeng nharl tyaylel aneyel, atha apmwel-areth mpwarey-angenharl. Ayengan arlarl.” ");
INSERT INTO aly_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Warrkenh amern amperney-angker ra altyerr ikwerenh-anem ilek Joseph-warl, rarl ingwel arek, Joseph-elarl arraty-angkwarr anayntilek. Ra Joseph renh ayernek, ilekekarl ra altyerr arekek. Atha altyerr arek arrpemarl. ");
INSERT INTO aly_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Amern-akert amernek-arelh irrpety akngeynenh akapwert irrwerlel. Thip-rnemel amern renh-rnem arlkweynenh amernek-arelh irrpety ikwer-itwek. ");
INSERT INTO aly_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Joseph-el renh ilek, “Alakenh-anyemarl angka yanhan aynteyel, amernek-arelh irrpety yanhan arlta irrpety-apeny aynteyel. ");
INSERT INTO aly_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Arlta irrpety-penh Atyetyartel ngenh ita rlweth-akem, inkwartey arreylpel. Ipma aylpar-arrerneynenh arwerl arlpenty irrwerl-warl. Thip-rnemel tyelk ngenh arlkwayntetyek.” ");
INSERT INTO aly_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Arlta irrpety-penh Pharaoh-el amern tyenkerr arlkwenh warrkenh ikwerenh-rnem-akertel. Ra warrkenh ikwer-atherr yangkelhek, ratherr kwenty renh atyenhiletyek, rernem amern tyenkerr arlkwetyek ingkerrenhel-anem. ");
INSERT INTO aly_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Warrkenh wayn anthey-angker arrernek arrpemarl, ra warrkirretyek arrpemarl, ra warrk renh antheynek arrpemarl. ");
INSERT INTO aly_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Artwa amern amperney-angkeran ra ingwer-rnem ilanthenh renh ipmek atwetyek, ipma aylpar-arrerneyenh arwerl arlpenty irrwerl-warl, Joseph-elarl ilek-angkwarr. ");
INSERT INTO aly_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ingkerrenh-angkwarr ayntek Joseph-elarl ilek-angkwarr-antey. Warrkenh wayn anthey-angker ra iylpelirrek. Atyetyart renh iley-angenh-antey, Joseph renh tyayl-they tyarlewetyek. ");
INSERT INTO aly_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Aherrety atherrel Joseph ra tyaylel anenh. Pharaoh ra altyerr arek. Akngey ra arekan, Nile ilpay impalthel ra rtnenh. ");
INSERT INTO aly_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Pwelek-rnem anter-akngerr 7-pel tyerrelhey-ayntek kwaty-they. ");
INSERT INTO aly_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Kel aremel pwelek 7-pel ngkwernant-anem kwaty ikwer-they-antey arrpemarl tyerrelhey-ayntek. ");
INSERT INTO aly_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Pwelek ngkwernant-rnemel pwelek anter-akngerr-rnem akwernek-anem. Pharaoh ra akemirrey-ayntek-anem, rarl altyerr arek-penhant. ");
INSERT INTO aly_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ankwa arrpemarl aynteynek, altyerr ingwer-anemarl arek. Ra ntang ilkwernem arek. ");
INSERT INTO aly_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ingwer-rneman arleny aynterrk-rnem. ");
INSERT INTO aly_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Arleny-anterrk-rnemel ntang ingwer-rnem kwernek. Pharaoh akemirrey-ayntek arrpemarl altyerr renh arek-penhan. ");
INSERT INTO aly_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ingwepenh Pharaoh ra artewentyel iterrek. Artwa ingwerek-ingwer-anem yangkelhek, ra renh-rnem ayernetyek, rarl altyerr arek-penh. Ngangker-akert-rnemek ra yangkelhek. Ywarn-antey ra renh-rnem ayernek. Rernem ikwer arraty anaytiletyek-arrpantey, ywarn-antey rarl altyerr arek. ");
INSERT INTO aly_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Artwa warrkenh wayn anthey-angker ra. Ra angkek, “Ayeng iterl-arelhek-anem, atharl apmwel-areth mpwarek. ");
INSERT INTO aly_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Pharaoh aylernek ahelirrek, tyayl-warl akwernek. Aylernanth arey-alhek Hebrew anyent, tyayl kwen-itwek. ");
INSERT INTO aly_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","12","Aylernanth atherrel-antey altyerr arekan. Hebrew rant arraty innga ilek, aylernantharl altyerr arekan. ");
INSERT INTO aly_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ayeng warrk-warl alpek, amern amperney-angkeran atwekarl, Hebrew rarl ilek-angkwarr-antey. Arraty inngarl ra ilenhan, Hebrew ran.” ");
INSERT INTO aly_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Pharaoh ra Joseph ikwer yangkelhek, renh ra ayernetyek, rarl altyerr arek-penh. Artwernemel Joseph renh tyayl-they tyerrek. Ra althelhek, arnkwa mwerrel-anem aylpemel, Pharaoh ikwer-warl-anem alhek. ");
INSERT INTO aly_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Pharaoh ra ilelhek, “Atharl altyerr arekan, ingwer-rnemel atyeng anayntiley-angenh. Ngenhant atha awek, mwerr inngan, anayntiley-angkeran.” ");
INSERT INTO aly_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Joseph ikwer-warl ilelhek, “Athan iterl-arey-angenharl, Akngeyelant anayntilem.” ");
INSERT INTO aly_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Atyetyart ra ilelhek, “Ayeng ilpay-itwel rtnenh, atharl altyerr arek, ");
INSERT INTO aly_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","pwelek anter-akngerr 7-pel kwaty-they tyerrelhey-ayntenty. ");
INSERT INTO aly_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ikwer-penhan atha arek, pwelek ngkwernant-rnem kwaty ikwer-they-antey tyerrelhey-ayntenty arrpemarl. ");
INSERT INTO aly_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Pwelek ampwel-rnem pwelek anter-akngerr-rnem kwernek. ");
INSERT INTO aly_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Rernem arlkwek-penhan, rernem ngkwernant irrkaty-antey anenh. Ayeng akemirrenhey-alpek, anamerl-antey.” ");
INSERT INTO aly_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Atharl altyerr arek ntang 7-pel mwerr-angker ilkwernem. ");
INSERT INTO aly_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ikwer-penhan atha arek ntang arleny aynterrk-rnem-anem. ");
INSERT INTO aly_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","25","Ntang arlenyel-rnem ntang mwerr-angker ilkwernem kwernek. Atha altyerr renh ilek ngangker-akert-rnem-warl, rernem atyeng arraty iletyek-arrpantey, rernem iterl-arey-angenh arrangkwarl.” Joseph-el ikwer anayntilek, “Altyerr yanh arek, ntwa arekan, irrkant-atherr aynteyel. Akngeyel ngkweng lwewarrerneyel, rarl alakenh-anyem mpwareyenh. ");
INSERT INTO aly_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Aherrety 7-pelant ntwa arlkweman, pwelek anter-akngerr arlkwem-apeny, alakenhaym ra aynteyelan. Alakenh-anyem ntwa ntang arleny 7-pel arlkwey-angenh, ntwa aherrety 7-pel arlengelan arlkwey-angenh arrpemarl. Aherrety 7-pelant ntwa arlkweman, ntang mwerr-angker ntwa arlkwem-apeny. Alakenh-anyem ra aynteyelan. ");
INSERT INTO aly_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Pwelek 7-pel ampwernem, aherrety 7-pel apmwernem-apeny arrpemarl, pwelek 7-pel anter-akngerr-rneman aherrety 7-pel mwerr-rnem-apeny, aherrety atherrk-angketyarr, atherrkeny. Nthakenh arlkwey-angenh arlenyelan. Alakenh-anyem ntwa pwelek ampwerneman arlkwey-angenh, ntwa aherrety 7-pel arlenyelan arlkwey-angenh arrpemarl. 7-pel aherretyel aherrety ilkwa aynteyenh amern lyapey-angenh. ");
INSERT INTO aly_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Akngeyel lwewarrernek altyerr-angkwarr rarl alakenh-anyem mpwareyenh. ");
INSERT INTO aly_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Aherrety mwerr-angker 7-pel aynteyenh apmer Egypt-el, amern-angketyarr. ");
INSERT INTO aly_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Aherrety apmwernem 7-pel aynteyenh Egypt ikwer-itwek-antey. Amernek ywarn iterreyel, amern arrangkw. ");
INSERT INTO aly_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Aherrety apmwel rernem angayakw irreyenh, amern-wenyel. Rernem aherrety mwerr-rnem ingkerrenh iylpelirreyenh. ");
INSERT INTO aly_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Akngeyel lwewarrernek, ntwa alakenh-anyem iterl-aretyek, rarl alakenh mpwareyenh. ");
INSERT INTO aly_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Artwa mwerr innga arrerney-areny Egypt-itwek Atyetyart ingkerrenhek anayntetyek. ");
INSERT INTO aly_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Artwa ingwer arrernem, rernem amern-rnem arntarnt-arayntetyek. Rernem ntang akngerr innga inetyek aherrety 7-pel apmwernem-kety, amern-angketyarr rernem arntarnt-aretyek, amern akngerr arlkwemel. ");
INSERT INTO aly_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Arlwarey-arlwarey akwernem warl ilkwewarl, rernem ikwer-penh arlkwayntetyek aherrety apmwernem 7-pelek-atwety, amern ingkerrenh ywerremel. Ingkerrenh-antey iteth anetyek-awaty amern ntang akngerr arlkwemel. ");
INSERT INTO aly_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Rernem amern renh arrernek aherrety 7-pel ikwerel, amern-weny irrentyek, amernek apatentyek.” ");
INSERT INTO aly_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Pharaoh ingwer-rnemek inkwerelhekan, ntang-rnem arrernetyek amern-weny irrentyek. ");
INSERT INTO aly_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Pharaoh angkek, “Warrkenh mwerr-angker anwantherr arrernem Joseph-arl, ran Akngey-kenh itnweng-akert.” ");
INSERT INTO aly_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Pharaoh-el Joseph renh ilek, “Akngeyel ngenh akaltyilek, ntwa alakenh-anyem mpwaretyek, ntwa ingkerrenh-angkwarr iterl-areyel ngan mwerr innga ingwer-rnem-theyan. ");
INSERT INTO aly_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Atha ngenh Atyetyart arrernem apmer ntwa arntarnt-arayntetyek. Ingkerrenh ngkweng awelhetyek. Ayengant Atyetyart ngkweng anayntem.” ");
INSERT INTO aly_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","“Atha ngenh Atyetyart arrernem Egypt-itwek, Egypt-areny-rnem ingkerrenhek.” ");
INSERT INTO aly_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Egypt-areny Pharaoh ra ampwal iltyek-arelh gold-penh mpwarekarl iltyethey lhelhek, Joseph iltyewarl arrernek. Arnkwa mwerr-rnem-then anthek ra aylpetyek. Tyeyn itek-arelh gold-penh mpwarekarl Joseph-warl tyeyn arrernek. ");
INSERT INTO aly_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Joseph renh pakey mwerr-angker anthek, ra alhayntetyek ikwerel. Ingkerrenh ikwer arlkek, “Iwerr arnangelhenh-arey Joseph ikwer.” Alakenh-anyem Joseph ra Atyetyart anenh Egypt-areny ingkerrenhek. ");
INSERT INTO aly_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Pharaoh-el Joseph renh ilek, “Ayeng anyent Atyetyartan ingkerrenh ngkweng awelh-ayntetyek, ayengan atyetyart arrwekel, ngarl Atyetyart atyeng-theyan.” ");
INSERT INTO aly_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ra Joseph renh itnewek Zapenath Paneah. Joseph ra anew inek, Potiphera-kenh alerikw, itnan ikwerenh Asenath. ");
INSERT INTO aly_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Joseph ra aherrety 30 anek, Pharaoh-el Atyetyart arrernek Egypt-areny ingkerrenh ra arntarnt-aretyek. Ra ingkerrenh-angkwarr arntarnt-arerl-apenh, warrk-itwek. ");
INSERT INTO aly_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Aherrety 7 ingweran anek, mwerr-angkerarl. Amern akngerr rernem arlkwenharl. ");
INSERT INTO aly_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ntang ingkerrenhel ra inek-penhan ra renh-rnem warl ilkwewarl arlwarey-arlwarey arrernek, tawen ilkwernem-itwek, ntang renh-rnem ra arrernek ingkerrenh arlkwayntetyek. ");
INSERT INTO aly_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Joseph-el ntang arlwarey-arlwarey akngerr arrernek, nthakenh ingwer-rnemel count-emiley-angenh. ");
INSERT INTO aly_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Arrwekel-antey amern ingkerrenh ywerrey-alenty, Joseph-then anew ikwerenh-then ratherr awey atherr ikwer-atherrenh anek. ");
INSERT INTO aly_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Arrwekeleny itnewek Manasseh, alakenh angkemel, “Akngeyelarl ayenh arntarnt-arek, ayeng iterrey-angenh arrangkw-anem, ayeng apmerek alharntey-angenh anem.” ");
INSERT INTO aly_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Awey ingweran itnewek Ephraim-arl alakenh angkemel, “Akngeyel ayenh ampa akngerr anthek, apmer ikwer-itwek rlterrk innga atyeng ayntenh-itwek.” ");
INSERT INTO aly_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Aherrety 7-pel mwerr-rneman ywerrenhek-anem. ");
INSERT INTO aly_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Aherrety 7-pel ingwer apmwernem ayntek, amern-weny-rnemarl, Joseph-el ilek-angkwarr-antey. Apmer ingkerrenh-itwek, amern lyapey-angenh ayntek. Apmer aparnpel. Amern akngerr-antey Egypt-itwek ayntenh. Egypt-itwek rernem angayakw-anem irrek, amern-wenyel. ");
INSERT INTO aly_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Rernem Atyetyart Pharaoh renh ayernenh amernek. Ra angkek, “Joseph ayerneyek alhenherr-arey, ra arrenhantherr amern anthetyek. Arrantherr ikwer awelheyek alhenherr-arey, rarl arrenhantherr ileman.” ");
INSERT INTO aly_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ra amern-weny-anem irreynenh, ra apmwa innganem ayntek, amern-wenyel. Joseph-el warl ilkwa altywerilek, amern-anem Egypt-areny-rnem tharlemilek, rernemarl angayakw irrek. ");
INSERT INTO aly_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Apmer arrpanenh-they Egypt anyent ikwer-warl akarrirrek, amern-angketyarr-warl. Aherrety apmwa apmer arrpanenh-itwek-anem ayntek, amern-weny arrangkw, amern lyapey-angenh. ");
INSERT INTO aly_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jacob-el awek ntang weyt-angketyarr apmer Egypt-itwek, angkemel, “Ilek arringkerr apatemel aneyel? ");
INSERT INTO aly_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Atha awek Egypt-an ntang weyt-angketyarr. Arringkerr ingkerrenh alhenherr-arey Egypt ikwer-warl ntang weyt inerl-alpetyek, angayakwirrekerr.” ");
INSERT INTO aly_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Joseph-kenh awayikw 10-pel alhek apmer Egypt-warl. ");
INSERT INTO aly_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Jacob-el alerikw akelyan thweney-angenh. Anterrkwek apmer-itwek-antey. Ra aterirrek atwekerr apek renh. ");
INSERT INTO aly_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Jacob-kenh-rnem anyentirrenhek angayakw ingwer-rnem-angkwarr, Egypt-warl rernem alhek. ");
INSERT INTO aly_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Joseph ra Atyetyart anenh apmer-rnem arntarnt-arayntetyek, ntang weyt-rnem arlperrtyilemel anthayntetyek. Awayikw ikwerenh-rnem apetyek ikwer-warl, kwenirrey-alhemel ikwer-itwek. ");
INSERT INTO aly_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","8","Rernem Joseph renh alhengk-arey-angenh, rant renh-rnem alhengk-arek, ra ingwer-arrpantey anenh. Ra renh-rnem iltek, “Nthenh-they arringkerr apetyek?” “Anwingkerr apmer Canaan-they apetyek, ntang weyt inerl-alpetyek, amern-weny-kety,” rernem renh ilek. ");
INSERT INTO aly_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Joseph ra iylpangkek, rarl altyerr awank arek, “Arringkerr arlwarrernerl-ayntetyek, ahelengkw-rnem apek.” ");
INSERT INTO aly_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Rernem angkek, “Arrangkw anwingkerran arwarl apetyek, amern ntang weyt-angketyarr-warl, amern-weny-kety. ");
INSERT INTO aly_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Anwingkerr ingkerrenh artwamp anyent-kenh-antey. Anwingkerr arraty ileyel, irrtywerremel iley-angenh. Anwingkerr iylpareth inngarl, irrtywerremel iley-angenh.” ");
INSERT INTO aly_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Joseph-el renh-rnem ilek, “Arringkerr apmer renh arlwarrernerl-alpetyek, arringkerr irlkenty-akert apey-alpey-alenty, apmer nhenh-itwek atwetyek-anem.” ");
INSERT INTO aly_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Rernem Joseph renh ilek, “12-an anwingkerr anekan, artwamp anyent-kenh-antey. Akelyan artwamp anwekingkerrenh-itwek anerl-anem Canaan-itwek. Anyent ingweran ilwekarl.” ");
INSERT INTO aly_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Joseph-el renh-rnem itwengetilekan, “Arringkerr artwa ahelengkw-rnem apekan. ");
INSERT INTO aly_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Alerl atha arrenhingkerr iterl-arey-tangkwel, artwa ahelengkw-rneman. Atyetyart Pharaoh iteth aneyel-apeny, arringkerr apmer nhel anetyek, aytey arrekingkerrenh ra apetyeyek-awaty. ");
INSERT INTO aly_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Anyent apmer-warl alpey ayteyikw inerl-alpetyek atyeng-warl akngetyemel. Awayikw ingwer-rnemarl tyayl-itwek anenherr-arey.” ");
INSERT INTO aly_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ra renh-rnem tyayl-ek ingkerrenh akwernek, rernem arlta irrpety tyaylel anek. ");
INSERT INTO aly_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Joseph-el renh-rnem ilek, “Ayeng Akngeyekant iterreyel. Alerl-apeny atha arrenhingkerr ipmem. Anyent ingweran tyayl-itwek anayntem. ");
INSERT INTO aly_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","20","Arringkerr ilelhek, arringkerr artwa mwerr akwel. Arringkerr atyeng mwerr-angkwarr awelhenty, atha arrenhingkerr ipmek atwey-angenh. Arringkerr aytey arrekingkerrenh ikngwerl-alpa atyeng-warl akngetyemel, atha renh aretyek. Atha renh arenty, athap arrenhingkerr iterl-arem, arratyarl ileyel atyeng.” ");
INSERT INTO aly_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ikwer-penhan rernem angkerrenh, “Akngeyel anwenhingkerr atwem, anwingkerrarl Joseph renh awank irrkewarl iwek-penh.” ");
INSERT INTO aly_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Reuben angkek, “Atha arrenhingkerr ilek, awey atwey-angenhek. Arringkerr atyeng awelhey-angenharl, Akngeyel anwenhingkerr atwemant-anem.” ");
INSERT INTO aly_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Rernem iterl-arenh Joseph-el-arl angka ikwer-rnem-kenh awey-angenh-arrpantey. Joseph angkenh angka Egypt-areny-kenhel, artwa ingwerelarl angka anayntilek ikwer-rnem. Rernem ikwer iterrenh iylpa arwengkek-arrpantey, angka ikwer-rnem-kenh awey-angenh. ");
INSERT INTO aly_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Joseph intwemelirrek, artnemel-anem. Ikwer-penhan ra angkek arrpemarl ikwer-rnem-warl. Ikwer-penhan ra warrkenh ikwerenh ilanthek, ra Simeon rwepel arertnetyek. ");
INSERT INTO aly_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ikwer-penhan Joseph-el warrkenh ikwerenh thwenek, ayteyikw ikwerenh-warl alhetyek, yakweth-warl man angkep irrtyert akwernetyek ikwerenh, angkep antheynetyek ikwer, rarl amern payemelek. Ra ntang-rnem yakweth arrpanenh arrerneynek, ntang-rnem-then man-rnem-then. ");
INSERT INTO aly_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Rernem ntang tangkey-warl tywenek, alpek-anem rernem. ");
INSERT INTO aly_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ingwel rernem ayntey-alpek ampepel. Artwa anyentel yakweth altywerilek, man-akert tangkey wantetyek, rap man amern-akert kwen. ");
INSERT INTO aly_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ra ilek, “Angwenhel man angkep antheynek, yakweth-itwek aynteyel?” Rernem ater-anem irrek, “Nthakenh Akngeyel anwenhingkerr angwenhileyel?” ");
INSERT INTO aly_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Apmer Canaan-warl rernem alpek, rernem aynikw ikwer-rnem-kenh angka ilek-ilek iley-alpek ikwer-warl. ");
INSERT INTO aly_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Egypt-areny Atyetyartel anwenhingkerr artwa ahelengkw-arrpantey arey-ayntek, apmer arlwarrernerl-anenty-arrpantey. ");
INSERT INTO aly_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Anwingkerr renh ilek, ‘Anwingkerr artwa mwerr-rneman ahelengkw-wenyarl. ");
INSERT INTO aly_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","12-an anwingkerr anekan, artwamp anyent-kenh-antey. Akelyan artwamp anwekingkerrenh-itwek anerl-anem Canaan-itwek. Anyent ingweran ilwekarl.’ ");
INSERT INTO aly_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Atyetyartel anwenhingkerr itwengetilekan, ‘Alerl atha arrenhingkerr iterl-arey-tangkwel, artwa ahelengkw-rneman. Atyetyart Pharaoh iteth aneyel-apeny, arringkerr apmer nhel anetyek, aytey arrekingkerrenh ra apetyeyek-awaty. ");
INSERT INTO aly_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Arringkerr aytey arrekingkerrenh-akert apey-alpetyek, atha arrenhingkerr iterl-aretyek, arringkerrarl artwa mwerr-rnem, ahelengkw-weny.’” ");
INSERT INTO aly_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Rernem yakweth-rnem altywerilek. Rernem arek man ingkerrenh ayntenty. Rernem aterirrek, aynikw aterirrek arrpemarl. ");
INSERT INTO aly_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Jacob-el alerikw-rnem ilek, “Arringkerr awey atyenh atyeng-they rakek. Joseph-an arrangkw, Simeon arrangkw arrpemarl. Arringkerr ilkelheyel Benjamin raketyek arrpemarl, alakenh irrwernek?” ");
INSERT INTO aly_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Reuben-el aynikw ikwerenh ilek, “Ayeng Benjamin-weny arrangkw apey-alpenty, ntwa aler atyenh-atherr ipmek atwem. Atha renh arntarnt-aretyek, akngey-alpem innga.” ");
INSERT INTO aly_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Jacob angkek, “Benjamin, alerey akely atyenhan atha nthakenh Egypt-warl thweney-angenh, alerey atyenh arrwekel ilwek-ketyarl. Alerey anyent-anem atyenh impen-antey, nthakenh tyarlewey-angenh ra alhetyek. Ayeng ikwer amperrngirrerl-anekerr, arringkerr renh akngentyan.” ");
INSERT INTO aly_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","2","Aherrety atherrk lyapey-angenh, aherrety innganem ayntek, kwaty rntwey-angenh arrangkw-anem. Ntang-rnem arrangkw-anem irreynenh, Jacob-kenh apmer-itwekan. Ntang-rnem ywerrek-anem. Amern-weny arrangkw-anem anenh. Jacob-el renh-rnem angkep-antey ilanthek ntang akngerr-rnem inerl-alpetyek. Arringkerr alhenherr-arey ntang akngerr-anem inerl-alpetyek. ");
INSERT INTO aly_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","5","Judah angkek, “Atyetyartel ilek aytey anwekingkerrenh anwingkerr akngeynentyelant, anwenhingkerr amern ntang akngerr anthem. Benjamin anwingkerr akngentyelant mwerr. Anwingkerr ikwer-weny alhentyan arrangkw wenh!” ");
INSERT INTO aly_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Jacob-el renh-rnem ilek, “Arringkerrarl Atyetyart renh ilek, arringkerr irrwernek-anem aytey arrekingkerr. Arringkerr ikwer-warl iley-angenh menty aynteyek-anek.” ");
INSERT INTO aly_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Rernem renh ilek, “Angka akngerr inngel anwenhingkerr ra ayernekan wenh! Nga iteth-antey anentyek, alerengkw ngkwenh ingwer apek anentyek. Anwingkerr ikwer arraty-antey ilelhek. Anwingkerr iterl-arey-angenh-antey rarl anwenhingkerr ilanthetyek aytey anwekingkerrenh akngey-alhetyek ikwer-warl.” ");
INSERT INTO aly_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Judah aynikw ikwerenhek angkek, “Menty anwenhingkerr tyarlewa! Amern-weny-kety angayakw irrekerr. Atha renh arntarnt-aremel akngey-alpem apmer-warl. Menty renh tyarlewa anwingkerr alhetyek. ");
INSERT INTO aly_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ingwerel-rnem renh atwentyan, ayenh anyentant-anem ntwa ileman, athan renh atnwenhek-penh. Ra ilwentyel, ntwa ayenhant-anem iley-ayntem. ");
INSERT INTO aly_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Arlta rlwethirreyneyel-kety, anwenhingkerr tyarlewa. Anwingkerr anngangelheyel-kety. Alakenh-apenyel apmer ikwerel-anem aney-areny.” ");
INSERT INTO aly_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Jacob-el renh-rnem ilek, “Atyetyart ikwer ampwal ilek-ilek akngenherr-arey apmer, nhenh-areny, ngkwarl arwengalker amern-rnem-then ampwal ilek-ilek-rnem-then. ");
INSERT INTO aly_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Man-then akngenherr-arey, apalelarl ingwerentyel yakweth-warl arrernek, antheynenherr-arey, ra anwenhingkerr ayntarrp-ilekerr anyelkel-inenty-arrpantey. ");
INSERT INTO aly_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Benjamin ikngwerl-alhenherr-arey, arringkerr alhemelant-anem. ");
INSERT INTO aly_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Arringkerr Akngey rlterrk ilkwakert ayernetyek, ra arrenhingkerr arntarnt-aretyek, atyetyartel aytey arrekingkerrenh tyarlewetyek.” ");
INSERT INTO aly_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Awayenheng-rnem Egypt-warl anperl-alhek, ampwal ilek-ilek-akert, renh-rnem-akert ayteyikw-anem ikwerenh-rnem-kenh-then. ");
INSERT INTO aly_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Joseph-el renh-rnem arnarek Benjamin-akert. Warrkenh ikwerenh ilanthek, “Artwa yanh-rnem apmer atyenh-warl atnwenha, aker-anem ikwer-rnem atwemel, anwantherr ingkerrenh aker arlkwetyek.” ");
INSERT INTO aly_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Warrkenhel artwernem Joseph-kenh warl-warl atnwenhek. ");
INSERT INTO aly_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Rernem iterrek, “Man yakweth-itwel ayntenhel-antey anwingkerr irrwernek Atyetyart ra apek anwenhingkerr anterrkwemel tyayl-warl akwernem apek, tangkey-anem rakem apek.” ");
INSERT INTO aly_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Rernem Joseph-kenh apmer-warl alhek artwa warrkenh-warl ilelhey-alhek. ");
INSERT INTO aly_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","21","“Anwingkerr ingwer-inger-antey apmer nhewarl apetyek, man irrkaty renh-antey anwingkerr yakweth-itwek arek, nhenh-anem anwingkerr akngey-alpek Atyetyart renh anthetyek. ");
INSERT INTO aly_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Man akngerr-akert anwingkerr apetyek ntang payemeletyek. Anwingkerr man ingwer yanhan iterl-arey-angenh-antey, yakweth-itwek aynterl-apenh.” ");
INSERT INTO aly_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Warrkenh angkek, “Kel mwerr, Akngey arrekantherrenh ra apek arrernek man atyenh nhenh-anteyarl.” Warrkenhel Simeon ikwer-rnem-warl atnwenhey-alhek. ");
INSERT INTO aly_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Warrkenhel renh-rnem Joseph-kenh warl-warl atnwenhek, kwaty renh-rnem anthemel kwatyel-anem ingkernem lhewelhetyek. Warrkenhel tangkey atherrkel wantek, kwatyel-anem anthwengilek. ");
INSERT INTO aly_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ampwal rernem Joseph ikwer tywenek, renh anthetyek. ");
INSERT INTO aly_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Rernem apmer ikwerenh-warl alhek. Ampwal-rnem-anem rernem Joseph renh anthek, kwenirremel. ");
INSERT INTO aly_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Joseph-el renh-rnem ayernek, “Mwerrang arringkerr? Artwa ampwalew arrekingkerrenh? Iteth-antey ra aneyel?” ");
INSERT INTO aly_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","“Kel, ra mwerr-antey aneyel.” Rernem Joseph ikwer tyernek kwenirremel. ");
INSERT INTO aly_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Joseph-el ayteyikw ikwerenh akely arek, rap renh-rnem ayernek, “Nhenhang aytey arrekingkerrenh ran? Artwa nhenhang aytey arrekingkerr ran, arringkerr renh atyeng-warl ilenhan.” ");
INSERT INTO aly_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ra kwen-warl aylpenhek Benjamin-ek amperrngirremel-anem artney-alpek. ");
INSERT INTO aly_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Inngerr lhewelhek-penh, ra ikwer-rnem-warl angkep alpek. Ra warrkenh ikwerenh-rnem ilanthek, “Amern-rnem akngetyenherr-arey artwa yanh-rnem-warl.” ");
INSERT INTO aly_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Joseph taypel anyentel anenh, ament-areny. Awayikw-rnem taypel ingwerelarl anek. Egypt-areny-rnem taypel ingwer-itwek arrpemarl anenh. Rernem arlkarirrenh Hebrew-rnem-itwek amern arlkwekerr. ");
INSERT INTO aly_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Joseph-kenh warrkenh-rnemel awayikw-rneman ilek, rernem akert-arraty arrernelhetyek ingkerneny-they arrwekelenyek-atwety. Awayenheng rernem ywarn iterrek ilekek ra rnkerneynek arraty-angkwarr, ra iterl-arentyel apek. ");
INSERT INTO aly_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Warrkenh-rnemel amern akngerr renh-rnem anthek. Benjamin renh amern akngerr innga anthek ingwer-rnem-angkwarr, ngkwarl-anem rernem antywemel tyenkerr-anem amern akngerr arlkwemel. ");
INSERT INTO aly_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Joseph-el warrkenh-rnem ilek, “Yakweth-rnem-warl amern arriwek-atwety arrernerr-arey. ");
INSERT INTO aly_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Man-anem yakweth ingwer-warl arenherr-arey irrkwa thilp-penh antywey-angker yanhan ayteyikw ikwerenh-rnem-kenh yakweth-warl arrerna.” ");
INSERT INTO aly_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ingwepenh artwernem tangkey-akert alhek. ");
INSERT INTO aly_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","5","Artwernem arrerenty-antey alpenh, Joseph-el warrkenh ikwerenh ilanthek, “Anterrkwetyek alha. Anterrkwentyelan renh-rnem ayernem, ‘Angwenhel irrkwa thilp-penh antywey-angker atyenh anyelkel inek irrtywerremel? Nhenh ikwerenh impen inngarl antywey-angker, akaltyiley-angker ikwerenh, ngangker-apeny. Arringkerr apmwel-areth mpwarek, ampwal atyenh anyelkel inerl-alhemel.’” Warrkenhel inngantey renh-rnem arey-alhek angath-antey alperl-anenty. ");
INSERT INTO aly_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ra renh-rnem ayernek Joseph-elarl renh ilek-angkwarr. ");
INSERT INTO aly_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Awayenheng-rnem ilelhek, “Arrangkwarl anwingkerr, ampwal anyelk iney-angenh yanhan. ");
INSERT INTO aly_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Anwingkerr man angkep antheynek Canaan-itwek. ");
INSERT INTO aly_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Arentyelan irrkwa thilp-penh antywey-angker yakweth ingwerenty-kenh-itwek ntwa renh atwemarl. Ingwer-rneman anwingkerr warrkenh-anem ngkweng irrem-anem.” ");
INSERT INTO aly_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Warrkenhel ilek, “Anyent ingweran atha aletharl anterrkwem, warrk ilkwa anthaynteyek. Ingwer-rnem atha tyarleweman.” ");
INSERT INTO aly_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Awayenheng-rnem yakweth ikwerenh-rnem-kenh ahern-warl arrernek, altywerilemel. ");
INSERT INTO aly_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","13","Joseph-kenh warrkenhel yakweth-rnem areynek, arrwekeleny-they ingkern-penhek-atwety. Benjamin-kenh yakweth-itwek ra irrkwa thilp-penh antywey-angker ra renh arek, yakweth Benjamin-kenh-itwek. Awayikw-rnem ikwer amperrngirrek. Ampwal-rnem ingkerrenh tangkey-rnem-warl tywenek angkep-antey tawen ikwer-warl-anem. ");
INSERT INTO aly_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Awayenheng-rnem Joseph-kenh apmer-warl alhek. Rernem Joseph-itwek kwenirrey-alhek. ");
INSERT INTO aly_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ra renh-rnem ayernek, “Ilekek arringkerr anyelkel inetyek arrkernelheyel, athan iterl-areyelarl?” ");
INSERT INTO aly_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Judah angkek, “Ilek-angkwarr angketyek iterl-arey-angenh. Akngeyel lwewarrernek, anwingkerr apekarl apmwangkwarr mpwarek. Anwingkerr warrkenh ngkwenhan anayntem irrkwa thilp-penh antywey-angker anyelkel inek warrkenh inngan ngkwenh anayntem.” ");
INSERT INTO aly_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Joseph-el renh-rnem ilek, “Athan nthakenh arrenhingkerr anterrkwey-angenharl. Anyent renh atha anterrkweman irrkwa thilp-penh ra anyelkel-inekant.” ");
INSERT INTO aly_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Judah alhek Joseph-warl, angkey-alhek, “Ngan Atyetyart ilkwa Pharaoh-apeny. Anwekingkerr ahelirrey-angenh-antey. ");
INSERT INTO aly_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ntwa anwenhingkerr ayernek artwamp anwekingkerrenh iteth-antey anentyek aytey anwekingkerrenh apek anentyek. Anwingkerr ngenh ilek, aynaynwekingkerrenh artwa ampwanemanarl. ");
INSERT INTO aly_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Artwa ampwantey ra anenh Benjamin ra atnyenek-angkwarr. Benjamin-kenh awayikw ilwek-anem. Artwa akely ra anyent impen-antey, ingwerarl ilwek-kety. Aynikw ikwer anyentekant arlkwenteyel. ");
INSERT INTO aly_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ntwa anwenhingkerr ilanthek, ‘Artwa akely akngetyay nhenh-warl, atha renh aretyek.’ ");
INSERT INTO aly_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Anwingkerr ngenh ilek, ‘Aynaynwekingkerrenh ilwemarl, Benjamin atwentyelan.’ ");
INSERT INTO aly_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ntwa anwenhingkerr ilek, ‘Aytey arrekingkerrenh arrangkwelan, nthakenh arringkerr atyeng-warl apetyey-angenhan.’ ");
INSERT INTO aly_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Anwingkerr apmer-warl alpek artwamp anwekingkerrenh iley-alpek. ");
INSERT INTO aly_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Artwampel anwenhingkerr ilanthek, ‘Ntang akngerr-antey inerl-alpetyek, apmer Egypt-itwek.’ ");
INSERT INTO aly_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Anwingkerr nthakenh Egypt-warl angkep alpey-angenh aytey anwekingkerr-wenyant. Atyetyartel anwenhingkerr irrenteyelantarl aytey anwekingkerr anwingkerr akngetyey-angenh-they. ");
INSERT INTO aly_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Anewikw anyentel awey-atherr atnyenek rarl ikwer-atherrant ilkelhenh. ");
INSERT INTO aly_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Anyent ywerrek aleth-antey arey-angenh apey-alpey-angenh. ");
INSERT INTO aly_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Akngey anwekingkerrenh iterreyel atnwenth ahelengkwel artwa akely arlkwentyek-athen. Artwampel anwenhingkerr ilek, ‘Arringkerr artwa akely atyeng-they akngenty, ayeng ilwemarl-anem.’ ");
INSERT INTO aly_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Alakenhaym-kety artwamp anwekingkerr-warl anwingkerr artwa akely akngeynem. ");
INSERT INTO aly_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Artwamp anwekingkerrenh ilweman artwa akely anwekingkerr-angkwarr apey-alpey-angenh-kety. ");
INSERT INTO aly_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Atha artwamp renh ilek atha artwa akely renh apmer-warl iwerl-alhey-angenh. Atha artwamp renh ilek, ‘Atha artwa akely akngey-alpem. Arrangkwelan ntwa ayenh iterl-ara!’ ");
INSERT INTO aly_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ayeng nhel anem ngkweng warrkirr-ayntetyek. Artwa akely yanhan alpeman artwamp ikwer ywarn iterrerl-anekerr Ayeng nthakenh alpey-angenh artwa akely iwerl-alhemel apmer nhenh-itwek. ");
INSERT INTO aly_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ayeng ilkelhey-angenh akngey atyenh atha aretyek amperrngirrenty artwa akely ikwer.” ");
INSERT INTO aly_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Joseph ra artnenh-anem. Warrkenh ikwerenh-rnem ra ilek, “Aketh-warl tyerrelhenherr-arey!” Awayenheng rernemant-anem aneyelpek. Ra ikwer-rnem-warl ilelhek-anem, “Ayeng Joseph-arl.” ");
INSERT INTO aly_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Joseph artewentyel-anem artnek. Egypt-arenyel renh awek. Rernem ikwer angkerrenh-anem. ");
INSERT INTO aly_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Joseph-el ayteyikw ikwerenh-rnem ayernek, “Artwamp ra iteth-antey aneyel?” Rernem renh tyerney-angenh akatemel anek aterirremel. ");
INSERT INTO aly_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Joseph angkek, “Arrer-apeny apetyenherr-arey!” Rernem ikwer-warl arrer-anem alhek. Joseph ilelhek ikwer-rnem, “Ayeng aytey arrekingkerrenh. Awank-akerr arringkerr ayenh tharlemilek Egypt-areny-rnem-warl. ");
INSERT INTO aly_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Atyeng iterrey-angenh ayengarl arleng-alenty ywerrekek. Akngeyel ayenh arrwekel ilanthek, ingwer-rnem itethilerl-apayntetyek. ");
INSERT INTO aly_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Aherrety atherrel kwaty rntwey-angenh. Aherrety 5-pelel artwerrety arrpemarl, kwaty rntwey-angenh arrangkw arrpemarl. Nthakenh ingwerentyel amern rnkerney-angenh arrangkw, akwetyey-angenh arrangkw. ");
INSERT INTO aly_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Akngeyel ayenh arrwekel thwenek, arrenhantherr atha arntarnt-aretyek, amern-wenyel arrantherr ingkerrenh ilwekerr. ");
INSERT INTO aly_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Arringkerr ayenh ikngwey-angenh apmer nhenh-warl. Akngeyelarl ayenhan thwenek, apmer Egypt-warl. Ra ayenh Atyetyart arrernek, Pharaoh-kenhek-rnem, ayeng Atetyart anetyek apmer Egypt-itwel. ");
INSERT INTO aly_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Arringkerr anamerl alpenherr-arey akngey-warl iley-alpetyek, Akngeyel ayenh arrernek, Egypt-areny ingkerrenhek, atyetyart anetyek. Anamerl-antey akngey akngeynetyek. Akngey atyenh arringkerr iley-alpetyek. ");
INSERT INTO aly_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Apmer Goshen-itwek arrer-antey atyeng-itwek anetyek! Alerengkw-rnem-then, arreng ngkwenh-rnem-then artartey ngkwenh-rnem-then aypmenh ngkwenh-rnem-then atnwenth ngkwenh-rnem-then ampwal-rnem-then ingkerrenh-antey. ");
INSERT INTO aly_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Atha arrenhantherr arntarnt-arem apmer Goshen-itwek aherrety 5-pelek-atwety. Canaan-itwek arringkerr anentyan atnwenth-rnem-akert arrantherr ilwemarl amern-wenyel. ");
INSERT INTO aly_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Benjamin-akerr arringkerr iterl-areyel, wetharl ayeng arrekingkerr ilelhek, ayeng Joseph inngarl. ");
INSERT INTO aly_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Akngey atyenh arringkerr iley-alpenherr-arey, ra ayenh iterl-aretyek arrpemarl, ayeng Atyetyart ilkwa Egypt-itwek aneyel. Arringkerr anamerl atyeng-warl akngetyenherr-arey.” ");
INSERT INTO aly_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Joseph-then Benjamin-then ratherr artnemel atnyenerrek. ");
INSERT INTO aly_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Joseph-el awayikw-rnem arrwantyeynek, anyentarl-anyentarl, ikwerenh-rnem-itwek artnek-anem. Ikwer-penhan rernem angkanem angkerrenh. ");
INSERT INTO aly_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Pharaoh-el awek Joseph-kenh awayikw-rnem apetyek. Ra ikwer-rnem inkwerelhek, atyetyart ingwer-rnem inkwerelhek arrpemarl. ");
INSERT INTO aly_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Pharaoh-el Joseph renh ilek, “Awayengkw-rnem ila, rernem ampwal-rnem tangkey-rnem-warl tywenetyek, rernem apmer Canaan-warl alpetyek. ");
INSERT INTO aly_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ila renh-rnem, rernem aynaynwekingkerr-then ikngwerl-alpetyek apmer nhenh-warl, ikwerenh-rnem ingkerrenh. Apmer mwerr atha renh-rnem anthetyek Egypt-itwek, amern-angketyarr-itwek. ");
INSERT INTO aly_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Egypt-areny pakey-rnem akngeynenherr-arey ampernem-then anew arrekingkerrenh-rnem-then inerl-alpetyek. Artwamp ikwerenh-rnem-kenh-then akngetyetyek apmer ikwer-warl. ");
INSERT INTO aly_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ampwal ingwer-rneman mentyarl iwerlelpey ampwal ilek-ilek Egypt-arenyel anthem-kety.” ");
INSERT INTO aly_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Jacob-kenh alerikw-rnem awelhek Atyetyart ikwer. Joseph-el pakey-rnem renh-rnem anthek, amern-rnem-then, rernem apmer Canaan ikwer-warl akngeynetyek, atyetyartarl ilanthek-angkwarr. ");
INSERT INTO aly_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Joseph-el awayikw-rnem arnkwa mwerr-rnem amentew-ament anthek. Benjamin arnkwa 5-pel anthek thilp man akngerr-then. ");
INSERT INTO aly_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","10 tangkey ra thwenek ampwal Egypt-areny ilek-ilek-akert, aynikw ikwerenhek. Tangkey 10-pel ingwer-rneman amern ilek-ilek-akert, alethek-arelh. ");
INSERT INTO aly_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Joseph-el renh-rnem ilek, “Ampep-itwek ahel ilterrey-angenh! Mwerrant-arey arringkerr alpenherr-arey Canaan-warl.” ");
INSERT INTO aly_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Rernem ayerrer Egypt-they alpek, aynikw ikwerenh-rnem-kenh-warl, apmer Canaan-warl. ");
INSERT INTO aly_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Rernem ikwer iley-alpek, “Joseph iteth-antey, anwingkerr arerl-alpek Egypt-itwek, atyetyart renh arrernek apmer ikwer-itwek ra anayntetyek.” Artwamp ra iylpelant renh-rnem awek, irrtywerremel ilerl-anenty-arrpantey. ");
INSERT INTO aly_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Rernem artwamp renh ilek ingkerrenh-angkwarr Joseph-elarl renh-rnem ilek-angkwarr-antey. Artwamp ra iterl-anem-arek, rarl pakey arekel. ");
INSERT INTO aly_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Rernem renh ilek, “Arringkerr atyeng arraty ileyel wenh, rarl iteth aneyel. Kel atha renh aretyek, ayeng ilwey-alentyel.” ");
INSERT INTO aly_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Jacob Canaan-they anperl-alhek atnwenth-rnem-akert ampwal-rnem-akert-then. Tawen Beersheba ikwer-itwek, ra tyenkerr anthek Akngeyek, renharl Isaac-el Akngeyek anthek-apeny. ");
INSERT INTO aly_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ingwa ikwerel-antey ra altyerr-anem arek, INGKARTarl ikwer-warl arlkek, “Jacob-ay, Jacob-ay.” “Ilekekay?” Jacob angkek. ");
INSERT INTO aly_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Akngey angkek, “Ayeng Akngey irrkaty-antey akngey ngkwenharl atyeng awelhekarl. Aterirrey-angenh alha Egypt-warl. Alerengkw-rnem atha akngerrileyenh, alerengkw-rnem akngerr aneyenh, apmer ilenhel. ");
INSERT INTO aly_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ayeng ngkweng-angkwarr alheyel arrpemarl Egypt-warl. Ngkwenh-rnem atha akngey-alpeyenh apmer nhenh-warl. Alerengkw ngkwenh Joseph ngkweng-itwek aneyenh ilwetyek-atwety.” ");
INSERT INTO aly_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","7","Jacob ikwerenh-rnem-akert Beersheba-they anperl-alhek. Rernem artwamp renh tywenek pakey-warl, Pharaoh-elarl pakey ikwer thwenek. Pakey ingwer-rnem-warlant anewikw-rnem alerikw-rnem rernem tywenek. Ingkerrenh-antey rernem alpek Egypt-warl, alerikw ikwerenh-rnem-then arrengey ikwerenh-rnem-then artarteyikw ikwerenh-rnem-then. Atnwenth-rnem rernem akngeynek, ampwal-rnem-then. ... ");
INSERT INTO aly_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Akngerr innganem, 66-pel-anem ikwerenh-rnem rernem anperl-alhek, apmer Egypt-warl. Anew ikwerenh-rnem-kenh akngerr arrpemarl. ");
INSERT INTO aly_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Jacob-kenh arrengeyikw atherr Egypt-ekarl atnyenek-atherr, ratherr Egypt-itwel anenh. Artwamp ikwerenh-rnem 70-pel ikwerenh-rnem anekan ra artwamp-anemarl. ");
INSERT INTO aly_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob-el Judah arrwekel thwenek Joseph ayernetyek, ra Goshen-itwel rlwatetyek. ");
INSERT INTO aly_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Joseph pakey-warl nganey-alhek artwamp ikwerenh rlwatetyek. Ratherr rlwatirrek. Joseph-el artwamp renh atnyenek, rarl ikwer amperrngirrekel. ");
INSERT INTO aly_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Jacob-el Joseph renh ilek, inkwerelhemel-anem, “Kel ayeng ilwetyek arrer-anem. Atharl ngenh kel iteth-antey arek-penh ayeng alhewer-anemarl ilwetyek. Arwa alhewer ayeng ilwetyek atharl ngenh arek-penh, iteth-antey.” ... ");
INSERT INTO aly_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jacob-el alerikw-rnem akarrilek, anyent-warl ilemel, “Anyentirrenherr-arey ingkerrenh, atha arrekantherr iletyek nthakenharl irreyenh, arrantherr iterl-aretyek-awaty.” ... ");
INSERT INTO aly_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Jacob-el Judah renh ilek, “Ingkerrenh ngkweng awelh-ayntem nga atyetyart ikwer-rnem anayntem.” ... ");
INSERT INTO aly_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","... Jacob-el alerikw ingwer-rnem ilek, “Arrer-anem ayeng ilwetyekan. Irrkaty ikwer-warl arringkerr ayenh akwernetyek, Abraham rarl payemelek Hitt-kenh-rnem-itwek, akngey atyenh-itwek-antey. Intey ra akngerrakw-ampeny, apmer Canaan-itwek. ");
INSERT INTO aly_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Abraham anew ikwerenh-then-antey intey ikwer arrpemarl akwernek, Isaac-then anew ikwerenh Rebekah-then ikwer-antey arrpemarl akwernek. Leah kel-antey atha akwernek arrpemarl. ");
INSERT INTO aly_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Apmer renhan Hitt-kenh-rnem-itwek payemelekarl intey-akert arrewaly-rnem akwern-ayntetyek.” ");
INSERT INTO aly_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Alerikw ikwerenharl ra ilanthek-penh, ra panty-itwek aynterl-arrernek. Ikwer-theyan, ra ilwek-anem, panty ikwerel-antey. ");
INSERT INTO aly_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Joseph ra artnek-anem aynikw-anem atnyenek, arrwantyek. ");
INSERT INTO aly_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Egypt-areny akalty ingkerrenh anek, arrewaly anterel apernetyek. Rernem arlta 40-ek-atwety alakenh-anyem mpwarek. ");
INSERT INTO aly_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Rernem atnalhelerrenh arlta 70-ek-atwety artwamp ikweran. Joseph-el artwa ilanthek arrewaly renh anterel apernetyek rag-el ataperrelemel. ");
INSERT INTO aly_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Rernemarl amperrngirrek-penh, Joseph Egypt-areny Atyetyart-rnem-warl angkek, “Arrantherr apek atyeng inkwerelhentyan, arrantherr Pharaoh renh ayernenherr-arey. ");
INSERT INTO aly_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Akngey atyenh ilweyew-athath, atha renh alhelek, intey apmer Canaan-itwek renh akwernetyek.” ");
INSERT INTO aly_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pharaoh-el renh ilek, “Akngey ngkwenh akwerna, ntwarl renh ilek-angkwarr-antey akwernetyek.” ... ");
INSERT INTO aly_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","... Jacob-kenh alerikw-rnemel irrkaty-angkwarr mpwarek, rarl renh-rnem ilek-angkwarr-antey. ");
INSERT INTO aly_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Apmer irrkaty Machpelah intey ikwer-itwek-antey Abraham-el Ephron, Hitt-kenh payemelek-itwek, renh akwernek. ");
INSERT INTO aly_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Rernemarl atnalhelirrek-penh awayenheng rernem Egypt-warl-anem alpek. ");
INSERT INTO aly_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Aynikw ikwerenh-rnem-kenh ilwek-penhan rernem angkerrenh, “Joseph anwekingkerr ahelirrekerr wenh, ra anwenhingkerr atwekerr.” ");
INSERT INTO aly_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Rernem thwenek artwa angkakert Joseph ikwer-warl. Ra iley-alhek, “Aynaynwekingkerr ilwey-alentyel, wetharl anwekingkerr ilerlelpek, ");
INSERT INTO aly_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Arringkerr Joseph ayernetyek, mwerrant-arey arringkerr anetyek, arringkerrarl apmwel-areth ikwer anenh.’” Ra angka awek-penh, Joseph artnek-anem. ");
INSERT INTO aly_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Awayikw ikwerenh-rnem ikwer-warl apetyek, angkey-alhemel, “Anwingkerr ngkwenh warrkenh-anemarl.” ");
INSERT INTO aly_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Joseph-el renh-rnem ilek, “Aterirrey-angenh. Ayengan Akngey-wenyarl. ");
INSERT INTO aly_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Arringkerr atyeng ilkelhey-angenh irrek Egypt-areny-rnem ayenh anthemel. Akngeyel ayenh arntarnt-arekarl. Atyeng-angkwarran Akngeyel ikwerenh-rnem arntarnt-arek, itethilek. ");
INSERT INTO aly_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Alakenh-anyem-kety arringkerr aterirrey-angenh anetyek. Atharl arrenhingkerr arntarnt-arem, aler arrekingkerrenh-rnem-then. Ikwer-penhan rernem mwerrant-arey-anem anenh.” ");
INSERT INTO aly_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Joseph apmer Egypt ikwer-itwek anenh, awayikw-rnem-akert. Joseph aherrety 110 anenh, artwa ampwanem. ");
INSERT INTO aly_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ra Ephraim-kenh arreng-rnem arek, Manasseh-kenh alerikw Makir. ");
INSERT INTO aly_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Joseph ra awayikw ikwerenh-rnem ilelhek, “Arrer-anem ayeng ilwetyek-anem. Akngeyel anwenhingkerr arntarnt-arem, apmer rarl Abraham ingkerrenh alhelek ikwer-warl, Abraham-ek, Isaac-ek, Jacob-ek.” ");
INSERT INTO aly_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Rap renh-rnem ilek, “Arringkerr arraty ayenh iletyek. Ayeng ilwenty, arrewaly ayenh aknga Akngeyel arrenhingkerr atnwenheyneyel apmer Canaan ikwer-warl, ikwer-itwek akwernetyek.” Kel rernem renh arraty ilek. ");
INSERT INTO aly_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Joseph aherrety 110 irrekel-anem, ra ilwek. Rernem arrewaly anterel-anem apernek, rag-el ataperrelemel, coffin-warl arrernemel. ");
INSERT INTO aly_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","5","Awank-akerr artwamp anyent anenh, itnan ikwerenh Jacob, itnan ingweran ikwerenh Israel. Jacob-kenh alerikw anyent itnan Joseph, kel Egypt-itwek anenh arrwekel. Artwamp ra alerikw ikwerenh-rnem atnwenhek, anewikw ikwer-rnem-kenh-then, arrengey-rnem-then artartey-rnem-then ingkerrenh-antey Egypt-warl-anem, 70-pel. Alerikw ikwerenh-rnem, Reuben, Simeon, Levi, Judah, Issachar, Zebulun, Benjamin, Dan, Naphtali, Gad, Asher. ");
INSERT INTO aly_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ingwer-inger Joseph-then awayikw ikwerenh-rnem-then ilwenherrek apmer Egypt-itwek. ");
INSERT INTO aly_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Israel-kenhel-rnem alerikw akngerr atnyenek. Israel-kenh-rnem akngerram-akngerrirrek Egypt-ampeny-itwel. ");
INSERT INTO aly_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Atyetyart ingwer Egypt-areny ingkern-they arrernek, rernem renh Pharaoh itnewek. Ra akwerrp anenh, angka Joseph-kenh iterl-arey-angenh, Joseph ra arrwelarl anenh. ");
INSERT INTO aly_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ingwer-ingeran Pharaoh ikwerenh-rnemek apatemel angkek, “Nhak arenherr-arey, Israel-kenh-rnem! Akngerr innganem irrek! Nthakenh anwantherr irrem? ");
INSERT INTO aly_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ahelengkw apmer ingwer-areny-rnem apetyenty, anwenhantherr atwekerr. Israel-kenhel-rnem apek yanh-rnem alpemilekerr, ingkerrenhel-antey anwenhantherr atwekerr! Israel-kenh-rnem apmer ingwer-warl anterrerrekerr, warrk-kety ipmelhekerr!” ");
INSERT INTO aly_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Pharaoh-el atyetyart ampep-rnem rnkernek, rernem Israel-kenh-rnem irrwampenh-anthek, rernemaw artewentyel warrkirretyek. Atyetyart ampep-rnem ahelengkw inngarl, whip-el renh-rnem atwenh. Tawen ilkwa atherr Israel-kenhel-rnem artek, itnan ikwer-atherrenh Pithom Rameses-then. Egypt-arenyel-rnem akarrilek amern akngerr ingkerrenh-antey, amern akwernek warl ilkwernem-warl. ");
INSERT INTO aly_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Atyetyart ampep-rnem rernem Israel-kenh-rnem atwenh intem-antey, Israel-kenhel-rnem ampa atnyenek akngerrarl. Rernem arlpimpirrek apmer ingwer-rnem-warl. Egypt-areny-rnem aterirrek Israel-kenh-rnem akngerrirrekarl-kety. ");
INSERT INTO aly_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Egypt-areny-rnemel irrwampenh-anthek Israel-kenh-rnem, rernem artewentyel warrkirretyek alhengkerrirrek-atwety. ");
INSERT INTO aly_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Egypt-arenyel-rnem irrwampenh-anthek renh-rnem, rernem warl-rnem artetyek, apwert bricks mpwaremel. Rernem ahern angernek arrpemarl, amern weyt rnkernetyek lyapelhiletyek. Egypt-areny-rnem amperrngirrey-angenharl ikwer-rnem. ");
INSERT INTO aly_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Theth atherr anenh Egypt-itwel, Israel-kenh-atherr. Itnan ikwer-atherrenh Shiphrah-then Puah-then. Ratherr arelh Israel-kenh-rnem arntarnt-arenh, ampa atnyenetyek ilenh. Ingwer-inger Pharaoh-el ilanthek Shiphrah Puah-then renh-atherr, ");
INSERT INTO aly_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Mpwelanth arelh Israel-kenh-itwel arntarnt-aremel anerl-ayntenherr-atherr. Awey apek atnyenentyan, atwemelarl ipmek-antey! Kwey apek atnyenenty, atwey-angenharl mentyarl.” ");
INSERT INTO aly_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Theth atherrel Akngeyekant awelhenh, Pharaoh-ek awelhey-angenharl. Awey-rneman ratherr atwey-angenharl, menty anetyekarl. ");
INSERT INTO aly_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Pharaoh-el warrkenh anyent thwenek, theth renh-atherr ikngwerl-alpetyek. Ra angkek ikwer-atherr-anem, “Kel atha ilek, awey yanh-rnem atwetyek! Mpwelanthan atyeng awelhey-angenharl! Mpwelanth awey-rnem iteth atnyenenh wenh!” ");
INSERT INTO aly_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Theth atherrel tyernek, “Arelh Israel-kenh-rnem rlterrkarl, arelh Egypt-areny-rnem rlterrk-wenyarl. Arelh Israel-kenhel-rnem ampa atnyeney-angker arntety-weny, aylanth nthakenh awey-rnem atwey-angenh. Amey-rnemel kel-antey renh-rnem akngenh.” ");
INSERT INTO aly_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Theth atherr inngarl Akngeyek awelhenh. Akngeyel renh-atherr arntarnt-arenh, ampa akngerr anthek ikwer-atherr. Akngeyel ampa Israel-kenh-rnem akngerram-akngerrilek. ");
INSERT INTO aly_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ingwer-inger Pharaoh-el Egypt-areny-rnem ilanthek, “Arelh Israel-kenh-rnemel awey atnyenenty, kwaty lher Nile-warl iwemarl. Kwey-rnem mentyarl, awey-rnemant iwemarl, rernem ilwetyek kwaty kwenel!” ");
INSERT INTO aly_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Artwa anyent Israel-kenh anenh, ranap Levi-kenharl. Artwa ra kwey aleyak anewartirrek. Arelh ra Levi-kenh arrpemarl. ");
INSERT INTO aly_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ingwer-inger arelh ampakert-anem irrek, rap awey akely atnyenek-anem. Arelh ra arek, awey mwerr-angker inngarl. Ra warlek irrtyertel akwernek, Egypt-areny-rnemel aremel atwekerr. ");
INSERT INTO aly_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Alkent irrpety-penh amikwan ywarn iterrenh alakenh, “Nthakenh atha awey akely warlek intem-antey irrtyert akwerney-angenh!” Rap rtnwa akely renh arnwarnek, ankerel apernek alyelkilemel, kwatyarl nthakenh aylpey-angenh. Ra awey akely inemel, rtnwek athenek, kwaty lher Nile-warl akngek, antywer arlpenty apenng-warl kwaty-warl. Rtnwa ampa akelyenp renh arrernek kwaty-warl, apenng-angketyarr-warl. ");
INSERT INTO aly_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Angkwerelikw renh apentek ayteyikw, amikwel kwaty-warl arrernetyek. Angkwerelikw arek, kwatyek ra rnkernek, iterrek-anem, “Mwerr apek awey yanhey?” Ra arleng-they rtnwa ampa akelyenp arntarnt-arenh. ");
INSERT INTO aly_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ikwer-penh Pharaoh-kenh alerikw aleyak ilkwa ra alhek kwaty lher-warl, pwerlpirretyek. Kwaty lher impalthel ra alhenh apenng-angketyarrel, arelh warrkenh akngerrel renh apentenh. Ra alhenh, rap rtnwa renh arek kwaty-itwek apenng-angketyarr-itwek. Arelh warrkenh anyent ra ilek, “Nhak alhay inetyek!” ");
INSERT INTO aly_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Kel ra inerl-alpek kwey aleyak ikwer-warl. Kel ra altywerilek, awey akely-anem ra arek. Awey akely artnek-anem. Kwey aleyak ra amperrngirrekarl ikwer. Ra alhengk-arek, rap warrkenh anyent ilek-anem, “Ay! Ampa akely nhan Israel-kenharl!” ");
INSERT INTO aly_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Angkwerikwan apetyek ayernemel, “Ay! Mwerrang ayeng alhem apek, arelh Israel-kenh ikngwetyek, ampa akely nhenh aylpatyel anthwengiletyek?” ");
INSERT INTO aly_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Kwey aleyak angkek, “Ya! Kel mwerraw! Kel anamerl alhay ikngwetyek!” Angkwerikw alhek, amikw ikwerenh ikngwetyek. Kel-anem ra ikngwerl-alpek amikw ikwerenh kwey aleyak-warl. ");
INSERT INTO aly_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Kwey aleyakel amikw awey-kenhek ilek, “Ampa nhenh aknga, aylpatyel anthwengiletyek. Ampa arntarnt-arerl-aynta, atha ngenh man anthey-akenh.” Kel amikw ikwerenhel renh apmer-warl akngeynek, arntarnt-arerl-ayntetyek, aylpatyel anthwengiletyek. ");
INSERT INTO aly_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ikwer-penh ampa ra alkenhirrek, arlkwenty-iperr-anem. Amikw ikwerenhel akngeynek Pharaoh-kenh alerikw-warl, antheynek renh. Ampa akely renh ikwerenh-anem alkenhilek aleyak ra. Ra itnewek-anem renh Moses, alakenh anayntileyel, “Atharl weth inek kwaty-itwek.” ");
INSERT INTO aly_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Moses ilkwerrek, artwanem ra. Ingwer-inger ra alhek Israel-kenh warrkenh-rnem-warl, ikwerenh-rnem-warl. Ra arek, rernemarl artewentyel warrkirrek. Egypt-areny anyent ra arek, rarl whip-el artwa Israel-kenh atwek arnterr. ");
INSERT INTO aly_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Moses ra artepang arelhek, ingwerentyel arekerr. Arrangkw. Ra iterrek, “Anyentaw ayeng, atha atwetyek!” Ahelengkw renh-anem atwek Moses-el, ipmek-antey ra atwek, arrewaly renh irrkewarl akwernetyek. Rap alpek-anem apmer-warl. ");
INSERT INTO aly_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ingwepenh Moses alhek angkep irrkaty-warl Israel-kenh warrkenh-rnem-warl. Artwa Israel-kenh-atherr ra arek, ilterrenharl. Artwa anyentel ra atwek artwa anyent ingwer. Moses-el renh iltek, “Ay! Ilekekarl ntwa artwa yanhan atwek? Apmer anyent-areny-atherran innganem atwerreyel!” ");
INSERT INTO aly_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","15","Artwa ra tyernek, “Nganang atyetyartarl? Angwenhel-anem ngenh arrernek, nga atyetyart anwekantherr anetyek, anwenhantherr ilayntetyek? Ayenh-anem ntwa atwetyek, wetharl ntwa atwek-apeny apmwerrkel?” Atwekarl-kety Moses aterirrek. Ra iterrek, “Ilekay? Nthakenhay? Akngerrel ayenh iterl-areyelarl, atharl atwek wenh!” Moses-arl aterel anterrek apmer arleng-warl, apmer Midian-warl. Pharaoh-el awek-penh ra iltyemwerney-rnem ilanthek, Moses atwetyek. Iltyemwerney rernem alhek, ywarn-antey ikwer nthwenh. Midian-ampeny-itwek Moses aney-alhek kwaty ngentyel. ");
INSERT INTO aly_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Apmer Midian ikwerel anenh artwa anyent, itnan Jethro. INGKART-areny atyetyartarlap ran, alerikw 7-pel aleyak-rnem-akert. Kwey aleyak-rnem yep-yep-rnemek arrwekel alhenh, kwaty ngenty-warl anthwengiletyek. ");
INSERT INTO aly_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Artwa ingwer-rnem apetyek, arrngelekarl ikwer-rnem-kety, kwey aleyak-rnemel kwaty inpekerr terap-warl yep-yep-rnemek. Kwey aleyak-rnem nthakenh kwaty-warl arrererrey-angenh. Moses-el arek, artwa rernemarl kwey aleyak-rnem aywepek. Moses ranem artwa renh-rnem aywepek. Moses-el-anem kwaty thelek terap-warl yep-yep-rnemek. ");
INSERT INTO aly_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Kwey aleyak-rnem alperlewek akngey ikwer-rnem-kenh-warl Jethro-warl. Ra ayernek-anem, “Ay! Ilekekarl arringkerr iparrpaw apey-alpek? Ingkeny akenhel-anteyaw! Ayengan iterrek, kwaty arringkerr thelerl-anentyek-athen alerl. Arringkerr iparrparl apey-alpek!” ");
INSERT INTO aly_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Kwey aleyakel-rnem renh tyernek, “Artwa ingwer-rnem arrngert angkekarl, kwaty yep-yep anwantherr anthwengilekerr. Artwa Egypt-arenyel aywepek renh-rnem, kwaty yep-yep anthwengiley-alkenh.” ");
INSERT INTO aly_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Jethro-el ayernek, “Nthenharl artwa ran? Ilekarl arringkerr iwerl-alhekan artwa renhan? Kel artwa renh ikngwetyek alhenherr-arey. Ra apetyetyek, amern arlkwetyek.” Kel rernem ikngwerl-alpek Moses renh. ");
INSERT INTO aly_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moses apetyek, Midian-ampeny-itwek ikwer-rnem-itwek ra anenh-anem aleth-antey. Jethro-el aler kwey aleyak anyentarl ikwer anthek. Moses-an aleyakarl ikwer arlwenthirrek-anem, itnan ikwerenh Zipporah. ");
INSERT INTO aly_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ingwer-inger Zipporah-el atnyenek awey akely. Moses-el renh itnewek Gershom, alakenh anayntileyel, “Ayengan apmer ingwer-arenyarl, alethangarl. Alakenharl awey renh itnewek Gershom.” ");
INSERT INTO aly_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ingwer-ingeran Pharaoh weth Egypt-areny ilwek-anem. Egypt-arenyel-rnem irrwampenh-anthenh-antey Israel-kenh-rnem, iparrp warrkirretyek. Intem-antey atwemel warrkemilemel. Israel-kenh-rnem arlkek, “Akngeyay! Anwenhantherr arntarnt-araw Egypt-areny-rnem-kety!” ");
INSERT INTO aly_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Akngeyel renh-rnem awek, ranem iterrek renh-rnem arntarnt-arayntetyek iylpelirrey-angenh, rarl arrwekeleny-rnem arrwekel alhelek-angkwarr, Abraham-then Isaac-then Jacob-then, ingkern-penh-rnem arntarnt-arayntetyek. ");
INSERT INTO aly_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Akngeyel Israel-kenh-rnem arek-penh, rap ikwer-rnem amperrngirrek. ");
INSERT INTO aly_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moses-el arntarnt-arenh yep-yep-rnem Jethro-kenh, malyey ikwerenh-kenh. Jethro ranap apmer Midian-areny atyetyart Akngey-kenh tyatyarl anenh. Ingwer-ingeran Moses yerlirrek-anem, yep-yepel-rnem renh apentetyek nanikwet-rnem-then arlpaw intwar-ampeny-warl altwerl. Ra alhek apwert ilkwewarl. Apwert ilkwa Akngey-kenh itnan Sinai. ");
INSERT INTO aly_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Akngey-kenh itna INGKARTarl. Ingwer-inger ra thwenek antyerl Moses-warl. Antyerl INGKART-kenh ikwer aremirrek arwerl apwen-itwel. Arwerl apwen ampek-anem rwa lherrm. Moses-el rwa renh arek, ampekarl lherrm. Alperr ampey-angenharlap ran, rwa lherrm arwarl! ");
INSERT INTO aly_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Moses iterrek, “Ay! Ilekarl nhan? Alperran atherrk-anteyarl ampey-angenharl! Arrer-warl alhey, atha aretyek.” ");
INSERT INTO aly_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Arwerl apwen ampeyel-they INGKARTel arek, Moses-arl apetyek. Ra arlkek, “Moses-ay!” Moses-el tyernek, “Nhantey ayengaw!” ");
INSERT INTO aly_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Akngey angkek, “Arleng-apeny rtnay! Pwetan iylwarl. Ahern nhenhan aknganentyarl! ");
INSERT INTO aly_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ayengan Akngey rey-antey arrpemarl, arrwekeleny ngkwenh-rnemek Abraham-ek-artwey-then, Isaac-ek-artwey-then, Jacob-ek-artwey-then. Rernem ayenh apenteyel.” Moses Akngey-kety aterirrek. Ranap inngerrarl artelhek, Akngeyel renh arekerr. ");
INSERT INTO aly_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","INGKART angkek Moses-ek, “Atha areyel-anem, Egypt-areny-rnemel Israel-kenh-rnem atyenh-rnem irrwampenh-anthenty atwemel. Atha aweyel, rernem atyengarl arlkeyel, arlka kwarnelhentyan. Ayeng amperrngerreyel-anem. ");
INSERT INTO aly_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ikwer-penh ayeng apetyek, Israel-kenh-rnem atnwenheynetyek Egypt-they. Ayeng apetyek atnwenheynetyek apmer mwerr-angker-warl, amern-angketyarr-warl, apmer atherrkeny-warl. Aleyan ingwer-rnem aneyel-antey apmer ikwer-itwel, Canaan-areny-rnem, Hitt-kenh-rnem-akerr, Amor-areny-rnem-akerr, Perizz-areny-rnem-akerr, Hiv-areny-rnem-akerr, Jebus-areny-rnem-akerr. ");
INSERT INTO aly_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ya, atha aweyel, Israel-kenh-rnem arlkeyelarl. Atha iterl-areyel, Egypt-areny-rnemelarl renh-rnem irrwampenh-anthemel atwenh. ");
INSERT INTO aly_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Alakenh atha ngenh thwenem Pharaoh-warl, ntwa renh alakenh iletyek, ‘Atha atnwenheynetyek Israel-kenh-rnem Egypt-they apmer ingwer-warl.’ Kel iparrp alhay!” ");
INSERT INTO aly_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Moses apatemel ilelhek Akngeyek, “Ayengan arrangkwarl, mwerr-wenyarl. Artwa apmwamwam ayengan, atyetyart-weny. Atyetyart Pharaoh atyetyart awelhey-angenharl. Nthakenh atha Israel-kenh-rnem Egypt-they atnwenheyney-angenh!” ");
INSERT INTO aly_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Akngeyel Moses ilek, “Ayeng alhey ngkweng-angkwarr Pharaoh-warl ilkwatherr. Ntwa atyenh-rnem Egypt-they atnwenhenty, renh-rnem ntwa atnwenhey-alpetyek apwert nhenh-warl. Arrantherr ayenh awetyek apwertek, atyeng aker tyenkerr arrtyetyek, atyeng arraty inkwerelhetyek. Ntwa ayenh iterl-arayntetyek innga, atharl ngenh ileyel-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Moses-el Akngey ayernek-anem, “Ayeng ikwer-rnem-warl alhenty, alakenh ayeng angkenty, ‘Akngey rey-anteyarl ayenh angkakert thwenek arrekantherr-warl, Akngey weth arrwekeleny-rnemel awank-akerr apentenh.’ Rernem irrpelthirremel ayernekerr, ‘Angwenhel ngenh thwenek? Ilek-apenyarl ran wenh, itnan ilekarl ra?’ Nthakenh atha iley-alhem?” ");
INSERT INTO aly_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Akngey itnewelhek-anem, “Itnan ayeng Yaway, alakenh anayntileyel, ‘AYENGARLAP ALETHARL ANEYEL’. Ntwa Israel-kenh-rnem ila, ‘Yanhey-antey, rarl ayenh thwenek.’” ");
INSERT INTO aly_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Akngey Moses-ek angkek arrpemarl, “Ntwa Israel-kenh-rnemek angka atyenh ila.” Ikwer-penh Moses Israel-kenh-rnem-warl iley-alhek, “Akngeyarl rey-antey arrpemarl, arrwekeleny-rnemel arrwel renh apentek, Abraham-then Isaac-then Jacob-then. Rey-antey ayenh thwenek arrekantherr-warl. INGKARTarl itnan ikwerenh wenh intem-antey. Nhepenh-anyem arrantherr renh INGKARTarl itnewem, aler arrekantherrenh-rnem-then arrengey-rnem-then artartey-rnem-then.” ");
INSERT INTO aly_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","18","Akngey Moses-warl angkek arrpemarl, “Artwamp weth-rnem Israel-kenh-rnem ntwa ikngwerl-alpa, angka atyenh ilemel. Rernem arternp ngkweng awelhetyek.” Kel Moses-el artwamp-rnem ikngwerl-alpek ilemel, “Akngey rey-antey arrpemarl, arrwekeleny-rnemel arrwel renh apentek, Abraham-then Isaac-then Jacob-then. Itnan ikwerenh INGKARTarl. Rey-antey atyeng iylparrernelhek, angkemel, ‘Atha arek, Egypt-areny-rnemel arrenhantherr irrwampenh-anthenh atwerl-anemel. Atha alakenh alhelek, atha Egypt-they arrenhantherrenh atnwenhey-alpetyek atweyelarl-kety. Atha atnwenhey-alpetyek apmer mwerr-warl amern-angketyarr-warl. Aley-anem artwa ingwer-rnem nhak aneyel, Canaan-areny-rnem, Hitt-kenh-rnem-akerr, Amor-areny-rnem-akerr, Perizz-areny-rnem-akerr, Hiv-areny-rnem-akerr, Jebus-areny-rnem-akerr. Arrekantherr atha anthetyek apmer renh.’ Arrantherr Pharaoh-warl alhenherr-arey. Ilenherr-arey ikwer alakenh, ‘Anwantherr Israel-kenh-rnem Akngey anwekantherrenh apenteyel-rnem. Itnan ikwerenh INGKARTarl. Ra iylparrernelhek anwekantherr-warl. Anwantherr arlpaw-warl alhetyek irrpety-ingerek-atwety, aker tyenkerr arrtyemel anthetyek INGKARTek, Akngey anwekantherrenhek, ikwer inkwerelhemel. Mwerrang anwantherr alhem wenh?’ Alakenh ntwa artwampel-rnem-then ilenherr-arey Pharaoh-ek. ");
INSERT INTO aly_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Pharaoh weth, ra ngkweng awelhey-angenharl arrangkwarl. Atha renh arawerrng rlterrkel atwenty-penhant, ra ngkweng awelhetyek, arrenhantherr tyarlewetyek. ");
INSERT INTO aly_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Atha Egypt-areny-rnem arawerrng ilkwakertel atweyenh akngerr-inger. Rernem atyengety aterirreyenh. Ikwer-penhant Pharaoh-el arrenhantherr tyarleweyenh. ");
INSERT INTO aly_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Yew, Egypt-areny-rnem aterirreyenh ngkwengety Israel-kenh-rnem-kety-then. Arrantherr alperlewenty Egypt-they, Egypt-areny-rnemel ilek-ilek akngerr anthem arrekantherr. ");
INSERT INTO aly_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Arrantherr alperlewentyel, arelh Israel-kenh-rneman rernem ayernetyek arelh Egypt-areny-rnem arnkwernemek, nikelethek, iltyek-arelhek, ampwal ingkerrenhek gold-penh thilp-penh. Arelh-rnem Egypt-areny-rnemel anthetyek ilek-ilek. Arrantherr antheyenh arrpemarl ampernem arrekantherrenhek. Alakenh Israel-kenhel-rnem ilek-ilek akngerr ineyenh Egypt-areny-rnem-they.” Alakenh angkek Akngey Moses-ek. ");
INSERT INTO aly_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moses angkek Akngeyek, “Israel-kenh-rnem irrpeltherrekerr, atyeng awelhey-angenharl. Rernem atyeng angkekerr alakenh, ‘INGKART ngkweng aremirrey-angenh-antey!’” ");
INSERT INTO aly_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","INGKART-el ayernek Moses, “Ilekarl yanhan ntwa antwerrkeyel iltyelan?” Moses-el tyernek, “Irretetyarl wenh nhenhan.” ");
INSERT INTO aly_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","INGKART angkek, “Iwa yanh ahern-warl.” Kel ra iwek. Ra rtnwem irrekarl. Moses aterel anterrek rtnwem ikwerety. ");
INSERT INTO aly_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","INGKART angkek, “Kanty-they inay!” Kel Moses-el inek kanty-they, ranap irrertety-anem irrek arrpemarl. ");
INSERT INTO aly_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","INGKART angkek, “Israel-kenh-rnem-warl alhentyel, irrertety yanhap iwa ahern-warl, ikwer-rnem iylparrernemel wetharl ntwa iwek-apeny. Rtnwem irrenty, kanty-they ina arrpemarl, irrertetyarl irreyenh weth-apenyarl. Rernem arentyel, rernem ayenh iterl-arem-anem. Ntwa ila ikwer-rnem, ‘Akngey rey-antey arrwekeleny-rnemel apentek, Abraham-el-then Isaac-el-then Jacob-el-then, itnan ikwerenh INGKART, ra aremirrek atyeng.’” ");
INSERT INTO aly_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","INGKART angkek Moses-ek arrpemarl, “Iltya aylpa arnkwa kwen-ampeny-warl.” Kel Moses iltya aylpa kwen-ampeny-warl. Kel iltya tyerrelhek, iltya tywen-angketyarr-anem arelhek. ");
INSERT INTO aly_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Akngey angkek ikwer, “Iltya angkep aylpa arrpemarl arnkwewarl.” Kel ra tyerrelhek arrpemarl, iltya ra arelhek, tywen-weny-anemarl. ");
INSERT INTO aly_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","INGKART angkek ikwer, “Ntwa apek Israel-kenh-rnemek iylparrernetyek irrertety renh iwemel, rtnwem irrenty aretyek, rernem irrpeltherreyelarl-kety. Ntwa iltya tyerrem, ikwer-rnem lwewarrernetyek tywen-angketyarr-anem, alakenh-angkwarr rernem ayenh iterl-aretyek ayengarl rlterrk inngan, Rernem angkeyel, ‘Arraty inngip Moses angkeyel!’ ");
INSERT INTO aly_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Rernem apek iterl-arey-angenh-antey arrangkw-antey, kwaty inpa kwaty lher Nile-itwek, ahern-warl thelemel, rernem aretyek. Arrnganem ra irrem.” ");
INSERT INTO aly_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Moses-arl INGKARTek awelhey-angenh nyerrerrenharl. Moses angkek-anem, “INGKARTay! Ayeng aleny apekap anenh ampa akelyank, arternp-antey ayeng angkem. Nga aremirrek atyeng-warl, ayeng aleny apekap-antey arrangkw-antey, ntwa ayenh mwerreley-areny!” ");
INSERT INTO aly_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","INGKART angkek ikwer, “Ayengan INGKARTarl, ilek-ilek mpwarey-angker. Atha ngenh rlterrk angketyek mpwarey-angker ilek-ilek-angkwarr. Ayengan rlterrkarl, atha artwa arwengk mpwarey-angker, awey-angenheletyek. Atha artwa akater mpwarey-angker. Atha artwa arey-angenheley-angker aparrng mpwarey-angker. Artwa apek aparrng anenty, atha renh aretyek mpwarey-angker. ");
INSERT INTO aly_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Nga ilelhey-angenh atyeng, aleny apmwa, nga angkey-angenh-arrpantey. Israel-kenh-rnem-warl alha! Ayeng alhem ngkweng-angkwarr, athap ngenh rlterrkilem. Atharl ileman, nga angketyek.” ");
INSERT INTO aly_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Moses ranap awelhey-angenh-antey Akngeyek. Ra angkek, “INGKARTay, mentyaw! Ayenh ilanthey-angenh! Ingwer apek ilanthay wenh!” ");
INSERT INTO aly_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","INGKART ahelerrek Moses-ek, ra angkek-anem, “Yaw! Awayengkw ngkwenh Aaron-alew? Ranap Levi-kenh arrpemarl. Atha renh ilanthem ngkweng-angkwarr alhetyek. Angka rlterrk-akertarlap ran. Aaron-el ngenh arentyel, rap irrkngerneyarl irreman. ");
INSERT INTO aly_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","16","Atha mpwelenh alpemelemel-ayntey, akalty-anthetyek mwerr-angkwarr. Atha ngenh atyetyart arrernek Aaron-ek. Atha ngenh ilem-tangkwel, ntwap Aaron iletyek. Aaron katy angketyek Israel-kenh-rnem ingkerrek, ayeng arlkwenteyel-angkwarr. ");
INSERT INTO aly_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Irretety-akert alpa Egypt-warl. Ingwer-inger atha ilenty, arawerrng rlterrkel ntwa mpwaretyek irrertetyel, rernem ngenh iterl-aretyek, nga arawerrng rlterrk atyenh-akert.” ");
INSERT INTO aly_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","19","Moses Midian-itwek irrpety-inger arwa ra anenh. INGKART ikwer angkek, “Alpay Egypt-warl. Artwa weth-rnem, ngenharl atwetyek-anek-rnem, rernem kel ilwenherrek ingkerr.” Moses alpek malyeyikw-warl Jethro-warl. Ra angkek, “Malyeyay! Mwerrang ayeng alpemay apmer Egypt-warl? Atyenh-rnem atha aretyek wenh, mwerrang rernem aneyel.” Jethro-el renh tyernek, “Mwerraw! Kel alpay! Akngeyel arrenhantherr arntarnt-arem.” ");
INSERT INTO aly_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Kel Moses-el tywenek anewikw alerikw-atherr tangkey-warl. Ran ingketyel alpek, tangkeyel anewikw ikwerenh ampa-atherr akngeynek. Moses Akngey-kenh irrertety-akert alhenh, arawerrng rlterrk-akert. ");
INSERT INTO aly_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","INGKART angkek Moses-warl, “Nga Egypt-warl alhenty, ngap atyeng awelha ikwer-itwel, ayengarl ngkweng angkem. Irretetyel ilek-ilek mpwara arawerrng rlterrkel, Pharaoh-el ayenh iterl-aretyek, ayengarl rlterrk inngan. Atha renh arwengkileyenh, ngkweng awelhey-angenh-anem ra irreteyek, awerrarl. Israel-kenh-rnem nthakenh ra tyarlewey-angenh, Egypt-they. ");
INSERT INTO aly_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ra arrngert angkenty, renh ila, ‘Alakenh INGKART ngkweng angkenty, “Pharaoh, nga alerengkw ilkwek artewentyel ilkelheyel. Israel-kenh-rnemek ayeng artewentyel ilkelheyel irrkaty-angkwarr, rernem aleraty-rnem. ");
INSERT INTO aly_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Tyarlewa renh-rnem Egypt-they, rerneman aker tyenkerr atyeng ampernemel anthetyek, atyeng inkwerelhetyek. Ntwa Israel-kenh-rnem antwerrkenty, alerengkw arrwekeleny ngkwenh atha atwem ipmek-antey.” ’ Alakenh ila Pharaoh-ek.” ... ");
INSERT INTO aly_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ikwer-penh Moses alpek Egypt-warl anewikw ikwerenh-akert alerikw atherr-akert. Moses ampepel-antey alpenh, INGKART angkek Aaron-ek awayikw ikwerenhek, “Arlpaw-warl-anem alha, Moses rlwatetyek.” Ra alhek arlpaw-warl, Moses rlwatetyek. Ampepel-anem ra alhek, rap Moses renh arek-anem apwert Akngey-kenh-itwek, apwert itnan Sinai. Ra apetyek, Moses renh antwerrkemel arrwantyek. ");
INSERT INTO aly_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moses-el Aaron ilek, “INGKARTarl angkek atyeng arrwekelarl.” Aaron-ek irrertety renh lwewarrernek. Moses angkek Aaron-ek, “INGKARTel ilek, irrertety renh lwewarrernetyek Israel-kenh-rnemek, rernem aylenh iterl-aretyek, INGKARTelarl aylenh thwenek arawerrng rlterrk-akert.” ");
INSERT INTO aly_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ingwer-inger Moses-atherr Aaron-atherr alpek Egypt-warl. Kel ikwer-they ratherr artwamp-rnem akarrilek, Israel-kenh-rnem. ");
INSERT INTO aly_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaron-el ilek Israel-kenh-rnem, INGKARTarl Moses-ek angkek arrwekel. Moses-el irrertety renh iwek. Rernem arek, angkek-anem, “Ay! Rtnwem-anemarlap irrertety nhan!” Ra kanty-they inek arrpemarl ikwer-rnem, rap irrertety arrpemarl irrenhey-alpek, rernem aremel. Ra iltya arnkwewarl akwernek, kel tyerrelhemel iltya tywen-angketyarr. Angkep arrpemarl iltya renh akwernek arnkwewarl, kel ra tyerrelhemel arrpemarl, mwerr-anemarl irrek. ");
INSERT INTO aly_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Israel-kenh-rnemel arekel, rernem iterl-arek, INGKARTelarl Moses thwenek, arawerrng rlterrk-akertel. Rernem angkerrenh, “INGKART iterrek anwekantherr. Ranap anwenhantherr ipmey-angenharl, anwenhantherr arntarnt-areyel-antey. INGKARTel anwenhantherr arek, Egypt-arenyel-rnem irrwampenh-anthenh atwemel.” Rernem kwenirrek-anem INGKARTek, inkwerelhek-anem ikwer. ");
INSERT INTO aly_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ikwer-penh Moses-then Aaron-then Pharaoh-warl alhek, ratherrap angkek, “Anwernantherr Israel-kenhel-rnem apentem INGKART renh, Akngey anwekantherrenh. INGKARTel ngenh ilem alakenh, ‘Arrngert angkey-angenh Israel-kenh-rnemek. Tyarlewetyek renh-rnem, rernem alhetyek apmer arlpaw ikwer-warl. Kwenty rernem arlkwetyek, aker tyenkerr atyeng anthemel!’” ");
INSERT INTO aly_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Pharaoh arrkngert angkek, “Ay! Angwenharlap ran? Athan INGKART iterl-arey-angenharl! Ayengan ikwer awelhey-angenharl! Athan Israel-kenh-rnem tyarlewey-angenharl, arlpaw-warl alhetyek, arrangkwarl!” ");
INSERT INTO aly_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Aaron-atherr Moses-atherr ratherr angkek ikwer, “Akngey weth anwernantherr apentem, ra anwernenhantherr ilek, arlpaw-warl alhetyek arlta irrpety-ingerek-atwety. Arlpaw ikwerel aker tyenkerr arrtyemel anthetyek Akngey anwernekantherrenh, itnan INGKARTarl. Ntwa apek anwernekantherr arrngert angkenty, INGKARTel anwenhantherr arntety anthekerr, anwenhantherr ipmek atwekerr!” ");
INSERT INTO aly_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","5","Pharaoh angkek-anem Moses ikwer-atherr, “Ilek-kety mpwel Israel-kenh-rneman warrk-kety akngem wenh? Warrkan impenarl! Rernem akngerrarl! Warrk-kety mpwel arrkngert angkeyel! Iley-alpenherr-atherr ikwer-rnem-warl, ‘Arrantherr warrkirr-ayntetyek!’” ");
INSERT INTO aly_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Israel-kenhel-rnem bricks akngerr mpwarenh itwern arrpanenhel, warl-rnem artetyek. Egypt-arenyel-rnem arrwekel Israel-kenh ingwer-rnem rlwanek, atyetyart akely-rnem anayntetyek Israel-kenh warrkenh-rnemek. Ingwer-inger Pharaoh atyetyart-rnemek angkek, Egypt-areny-rnemek, Israel-kenh-rnemek. ");
INSERT INTO aly_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","8","“Israel-kenh-rnem rernem alhengkerrirrek warrk ilkwekety. Rernem arlkarirrek, bricks akngerr mpwarekerr menty. Warrk-kety-anem rernem arlkarerreyel, warrk-kety ipmelhetyek-anem. Alakenh rernem ayenh ayerneyel, ‘Anwernantherr arlpaw-warl alhetyek, aker tyenkerr arrtyemel anthetyek Akngey anwekantherrenhek.’ Israel-kenh-rnemek ayeng awelhey-angenharl. Arrantherr anthenh Israel-kenh-rnem atherrk arleny, bricks mpwaretyek. Nhepenh-anyem arrantherr atherrk arleny anthey-angenh-anem, menty-anem. Ilenherr-arey Israel-kenh-rnem, ‘Atherrk arlenyek ament nthweynetyek, bricks mpwaretyek. Wetharl akngerr mpwarenh-apeny, alakenh mpwaretyek!’ Bricks irrpetyap apek rernem mpwarenty alhengkerrel, renh-rnem iltenherr-arey alhengkerrerrentyan. ");
INSERT INTO aly_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Irrwampenh-anthenherr-arey arnterr warrkirretyek! Alakenh iletyek, ‘Ipmelhey-angenh warrkirretyek!’ Rernem apek arnterr intem warrkirrenty, rernem awey-angenh angka Moses-kenh, Moses ra irrtywerrentyarl.” Alakenh Pharaoh angkek atyetyart ampep ikwerenh-rnemek-then atyetyart akely-rnemek-then. ");
INSERT INTO aly_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ikwer-penh rernem Israel-kenh-rnem-warl alhek, renh-rnem ilek, “Pharaoh-el anwernenhantherr ilanthek, atherrk arleny arrenhantherr anthey-angenh, bricks mpwaretyek. ");
INSERT INTO aly_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ra ilanthek arrpemarl, arrantherr atherrk arleny nthwemel akwetyetyek. Alhengkerrerrey-angenh warrkirretyek. Wetharl akngerr mpwarenh-apeny, alakenh mpwaretyek!” ");
INSERT INTO aly_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ikwer-penh Israel-kenh-rnem alhek apmer arrpanenh-warl, atherrk arleny akwetyetyek, bricks mpwaretyek. ");
INSERT INTO aly_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Egypt-arenyel-rnem renh-rnem irrwampenh-anthek, arnterr warrkirretyek. Rernem ilek, “Iparrp warrkirrenherr-areyay! Warrkirretyek wetharl arrantherr awank warrkirrek-apeny, bricks akngerr mpwaremel.” Ikwer-penh Israel-kenhel-rnem bricks akngerr mpwarey-angenh, arrangkw. Atherrk arleny akelyarl akwetyek, bricks irrpetyapant mpwarek. ");
INSERT INTO aly_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ahelengkw-rnemel atyetyart Israel-kenh-rnem ilek, “Rernem lyert apmwerrkel-then alhengkerrekan, akely mpwarek!” Rernem atyetyart Israel-kenh-rnem irrwampenh-anthek atwemel. Rernem ayernek-anem, “Ilek arrantherr warrk-kety ipmelhek-anem? Irrpetyap-anem arwa rernem mpwarek, akngerr-weny-anem?” ");
INSERT INTO aly_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Atyetyart Israel-kenhel-rnem Pharaoh renh ayerney-alhek, “Irrepern anwernantherr! Ilekekarl nga ahelerrekan anwernekantherr? Anwernantherr warrkenh-rnemarl ngkwenh. Ilekekarl atyetyart Egypt-areny-rnemel anwernenhantherr atweyelan? ");
INSERT INTO aly_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ntwa ilek atyetyart ngkwenh-rnem, atherrk arleny anwernenhantherr anthey-angenh, bricks mpwaretyek. Anwernantherr bricks irrpetyap mpwarek, akngerr-weny, atherrkek arrangkwarl. Rernem ahelerrek, anwernenhantherr atwek. Ahelerrey-angenh anwernekantherr! Atyetyart ampep ngkwenh-rnemek ahelerra!” ");
INSERT INTO aly_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Pharaoh angkek, “Arrantherran alhengkerr-rnemarl wenh! Arlkarerreyel warrk-kety! Alakenh arrantherr ayenh arlkareweyel intem-antey, arlpaw-warl alhetyek, aker tyenkerr arrtyemel anthetyek INGKARTek. ");
INSERT INTO aly_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Kel iparrp alpenherr-arey warrk-warl! Atherrk anthey-angenh-kety anemarl atha! Mpwarenherr-arey bricks akngerr arrantherr arrwekel mpwarek-apeny!” ");
INSERT INTO aly_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Atyetyart Israel-kenh-rnemel awek Pharaoh angkekarl, rernemap angkerrek, “Nthakenh irreyay! Irrpetyapant mpwarenty anwantherr, atyetyart Egypt-arenyel-rnem anwenhantherr atwem!” ");
INSERT INTO aly_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ikwer-penh rernem warl Pharaoh-kenh-they tyerrelhek, Moses-atherr Aaron-atherr arey-alhek. Moses-atherr Aaron-atherr ikwer-rnem mpwelhenh. ");
INSERT INTO aly_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Rernem renh-atherr iltek. “INGKARTel mpwelenh atwey-areny! Pharaoh-then atyetyart ampep-rnem-then ahelerrek anwernekantherr, mpwelarl arlpaw-warl alhetyek ayernek-kety! Mpwel ayernek Pharaoh, anwenhantherr arlpaw-warl tyarlewetyek. Alakenhan rernem anwernenhantherr ipmek atwetyek!” ");
INSERT INTO aly_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Moses ranem ament-anem alhek INGKART-warl angketyek. Ra ayernek, “INGKARTay! Ilekek ntwa atweyelan anwernenhantherr irrwampenh-anthemel nhek Egypt-itwek? Anwernantherr ngkwenharl! Ilekek ntwa pwarrk ilkwa anthek atyenh-rnemek? Ilekek ntwa ayenh thwenek Egypt-warl? Arrangkwek. ");
INSERT INTO aly_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ntwa ayenh ilanthek, ayeng Pharaoh-warl alhetyek. Kel ayeng alhek, angka ngkwenh ilek. Alakenh ra ahelerrek ngkwenh-rnemek, renh-rnem atwek irrwampenh-anthemel. Ilekekan ntwa anwernenhantherr arntarnt-arey-angenhan?” ");
INSERT INTO aly_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","INGKART angkek Moses-ek, “Ntwa ayenh areyenh, atharl Pharaoh arrkngert antwerrkeyenh, ra Israel-kenh-rnem nthakenh atwey-angenh. Pharaoh renh atha atweyenh arawerrng rlterrkel. Ikwer-penh ra Israel-kenh-rnem irrenteyenh-anem, rernem alhetyek apmer arlpaw-warl.” ");
INSERT INTO aly_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Akngey angkek Moses-ek, “Ayengan INGKARTarl. ");
INSERT INTO aly_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Arrwel ayeng aremirrek Abraham-ek, Isaac-ek-then, Jacob-ek-then. Rernem iterl-arenhant itnan ayenh El Shaddai, Akngey rlterrk innga. Rernem itna ayenh INGKART iterl-arey-angenharl. ");
INSERT INTO aly_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Atha renh-rnem alhelek, ingwer-inger apmer Canaan renh-rnem anthetyek. Rernem anenh apmer Canaan-el, apmeran ingwer-rnem-kenharlap, rerneman apmerek-artwey-wenyarl, alethangarl. ");
INSERT INTO aly_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Israel-kenh-rnem artnenh, Egypt-areny-rnemel renh-rnem atwekarl. Rernem iterreyek-athen, atha artnekarl awey-angenh. Israel-kenh-rnem artnekarl atha awek. Ayeng atyenh-rnemek iylpelerrey-angenh, atharl arrwekeleny-rnem alhelek, apmer renh anthetyek ikwer-rnem.” ");
INSERT INTO aly_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","9","Akngey Moses-ek angkek, “Alha, Israel-kenh-rnem iletyek angka atyenh.” Kel Moses alhek Israel-kenh-rnem-warl, ilek-anem, “Alakenh Akngeyel arrekantherr ileyel. Ran INGKARTarl. Ra Egypt-areny-rnem arrngert antwerrketyek, rernemarl nthakenh arrenhantherr irrwampenh-anthekerr atwekerr. Arrantherr warrkirrey-angenh anem menty Egypt-areny-rnemek. Ra atnwenhetyek arrenhantherr Egypt-areny-rnem-kety arawerrng rlterrkel. Egypt-areny-rnem ra irrwampenh-anthem atwemel. Arrantherr ikwerenh-rnem aneyenh-anem, ra Akngey arrekantherrenh aneyenh. Arrantherr renh iterl-areyenh-anem, ra Akngey arrekantherrenh, itnan INGKART. Akngey irrkatyel tyarlewek arrenhantherrenh Egypt-areny-rnem-kety atwemarl-kety. Ra arrenhantherr atnwenhem apmer weth-warl, arrwekel wetharl ra arrwekeleny-rnem alhelek apmer renh anthetyek, Abraham-then Isaac-then Jacob-then. Apmer renh ra anthem arrekantherr. Apmerek-artwey-rnem arrantherr aneman. Ran INGKARTarl.” Moses-el alakenh Israel-kenh-rnemek ilek. Moses ikwer rernem awelhey-angenharl irrpeltherrenharl, rernemarl aterirrek ahelengkw Egypt-areny-rnem-kety. ");
INSERT INTO aly_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","11","INGKART angkek Moses-ek, “Pharaoh iletyek alhay, Israel-kenh-rnem tyarlewetyek Egypt-they, arrkngert angkey-angenh!” ");
INSERT INTO aly_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Moses angkek INGKART-warl, “Israel-kenh-rneman atyeng awelhey-angenharl! Pharaoh atyeng awelhey-angenh arrpemarl! Ayeng aleny apekaparl, nthakenh ayeng mwerr angkey-angenh. Pharaoh atyeng awelhey-angenhan.” ");
INSERT INTO aly_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","INGKARTel akalty-anthek Moses-atherr Aaron-atherr Israel-kenh-rnem-then, nthakenh mwerr-angkwarr Pharaoh-ek angketyek. Ra ilek renh-atherr, ratherr Israel-kenh-rnem Egypt-they atnwenheynetyek. ");
INSERT INTO aly_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Israel-kenh-rnem akngerr anew-anenh. Nhenh-rnem itnernem alakenh: Jacob itna ingweran Israel, alerikw ilkwa ikwerenh itnan Reuben. Reuben-kenh alerikw awey-rnem 4-pel, itnan Hanoch-then, Pallu-then, Hezron-then Carmi-then. Awey rernem alkenhirrek. Alerikw akngerr arrengey akngerr-then apetyek ikwer-rnem-they. Nhenh-rnem Reuben-kenh-rnem. ");
INSERT INTO aly_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Alerikw ingwer Israel-kenh itnan Simeon. Simeon-kenh alerikw awey-rnem 6-pel, itnan Jemuel, Jamin, Ohad, Jakin, Zohar, Shaul. Shaul-kenh amikw Canaan-areny. Awey rernem alkenhirrek. Alerikw akngerr arrengey akngerr-then apetyek ikwer-rnem-they. Nhenh-rnem Simeon-kenh-rnem. ");
INSERT INTO aly_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Alerikw ingwer Israel-kenh itnan Levi. Levi anek aherrety 137-ek-atwety. Levi-kenh alerikw awey-rnem irrpety, itnan Gershon, Kohath, Merari. ");
INSERT INTO aly_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gershon-kenh alerikw awey atherr, itnan Libni-then Shimei-then. ");
INSERT INTO aly_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohath anek aherrety 133-ek-atwety. Kohath-kenh alerikw awey-rnem 4-pel, itnan Amram, Izhar, Hebron, Uzziel. ");
INSERT INTO aly_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari-kenh alerikw awey atherr Mahli-then Mushi-then. Alerikw akngerr arrengey akngerr-then apetyek ikwer-rnem-they. Nhenh-rnem Levi-kenh-rnem. Rernem ilelhek Levi-kenh-rnem. ");
INSERT INTO aly_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Artwa weth Amram anewarterrek awenhikwek, itnan Jochebed. Jochebed-el awey atherr atnyenek, Aaron-atherr Moses-atherr. Amram anenh aherrety 137-ek-atwety. ");
INSERT INTO aly_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Artwa weth Izhar, alerikw awey-rnem ikwerenh irrpety anenh, itnan Korah, Nepheg, Zicri. ");
INSERT INTO aly_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Artwa weth Uzziel, alerikw awey-rnem ikwerenh irrpety anenh, itnan Mishael, Elzaphan, Sithri. ");
INSERT INTO aly_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Artwa weth Aaron anewarterrek Elisheba-ek. Elisheba alerikw kwey Amminadab-kenh anek, angkwerikw Nahshon-kenh. Elisheba-el ampa 4-pel atnyenek, Nadab, Abihu, Eleazar, Ithamar. ");
INSERT INTO aly_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Artwa weth Korah, alerikw awey-rnem irrpety ikwerenh anenh, itnan Assir, Elkanah, Abiasaph. Awey rernem alkenhirrek. Alerikw akngerr arrengey akngerr-then apetyek ikwer-rnem-they. Nhenh-rnem Korah-kenh-rnem. ");
INSERT INTO aly_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aaron-kenh alerikw Eleazar anewarterrek arelhek. Arelh-kenh aynikw itnan Putiel. Ratherr awey akely atnyenek itnan Phinehas. Nhenh-rnem arrwekeleny-rnem Levi-kenh-rnem-kenharl. ");
INSERT INTO aly_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","27","Awayenheng-atherr Aaron-then Moses-then irrkaty-atherr, INGKARTelarl arrwekel ilek, “Israel-kenh-rnem atnwenhenherr-atherr Egypt-they arlpaw-warl.” Innga ratherr Pharaoh ilek, Israel-kenh-rnem tyarlewetyek, rernem Egypt-they alpetyek. ");
INSERT INTO aly_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","29","Arrwekel-antey INGKART ra angkek Moses-warl Egypt-itwek alakenh, “Ayengan INGKARTan. Pharaoh renh ila ingkerrenh atha ngenh arrwekel ilek-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Moses angkek INGKARTek, “Ayengan aleny apekaparl, nthakenh ayeng mwerr angkey-angenh. Pharaoh atyeng awelhey-angenhan.” ");
INSERT INTO aly_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ikwer-penh INGKART angkek Moses-ek, “Aray! Atha ngenh atyetyart arrernek Pharaoh-ek. Atha ngenh ilem-tangkwel, ntwap Aaron iletyek. Atha awayengkw ngkwenh Aaron arrernek arrpemarl, angkey-angker katy ngkweng angkayntetyek. Aaron katy angketyek, ayeng Akngeyarl arlkwenteyel-angkwarr. Ra Pharaoh iletyek, alakenh ra awelh-ayntetyek. ");
INSERT INTO aly_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Awayengkw ngkwenh ila, ra Pharaoh renh iletyek, atharl ngenh ilek-angkwarr. Alakenh-anyem Aaron ra Pharaoh-ek iletyek, ‘Arrngert angkey-angenh Israel-kenh-rnemek. Tyarlewa, Egypt-they rernem alperlewetyek.’” ");
INSERT INTO aly_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","INGKART angkek Moses-ek, “Atha Pharaoh arwengkiletyek, ra awelhey-angenh anayntetyek. Ingwer-inger ayeng Egypt-areny-rnemek aremirreyenh arawerrng rlterrk-akert. ");
INSERT INTO aly_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Pharaoh ra awerr-antey anayntetyek. Ra mpwelek awelhey-angenh aneyenh. Ingwer-inger atha Egypt-areny-rnem atwetyek. Ikwer-penh atha Israel-kenh-rnem atnwenheynem Egypt-they arawerrng rlterrk-akertel. ");
INSERT INTO aly_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Egypt-areny-rnemel ayenh iterl-areyenh, ayeng INGKART inngarl.” Alakenh angkek INGKART Moses-ek. ");
INSERT INTO aly_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","INGKARTel Moses-ek-atherr Aaron-ek-atherr alakenh ilek, ratherr angka irrkaty-antey INGKART-kenh iley-alhek Pharaoh-warl. ");
INSERT INTO aly_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moses-atherr artwamp atherr-anem ratherr irrek-anem. Moses-an aherrety 80-pel-anem irrek alyepelarl, Aaron-an aherrety 83-pel-anem ra irrek. ");
INSERT INTO aly_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","9","Ikwer-penh INGKART angkek Moses-ek-atherr Aaron-ek-atherr, “Mpwel alhenty Pharaoh-warl, ra mpwelenh alakenh iley-ayntenty, ‘Mwerr-angker mpwaretyek arawerrng rlterrk-akertel, atha renh iterl-aretyek, INGKARTel inngelarl mpwelenh thwenek!’ Moses, Pharaoh-el ngenh ra iley-ayntenty alakenh, ntwa ila Aaron alakenh, ‘Irretety renh iwetyek Pharaoh arrwekel-ampeny-itwek. Irretety ra rtnwem-anem irretyek.’” ");
INSERT INTO aly_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Moses-atherr Aaron-atherr kel ratherr alhek Pharaoh-warl-anem. Rap ilek-anem renh-atherr, “Mwerr-angker mpwaretyek arawerrng rlterrkel, atha aretyek.” Aaron ra irrertety renh iwek Pharaoh-warl arrwekel-ampeny-itwek, ra warrkenh ikwerenhel-rnem-then aretyek. Irretety rap rtnwem-anem irrek. ");
INSERT INTO aly_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Pharaoh ra warrkenh anyent ikwerenh thwenek, artwa akalty-rnem-then ngangker-akert-rnem-then ikngwerl-alpetyek. Rernem rtnwem mpwarek arrpemarl ikwer-rnem-kenh-angkwarr. ");
INSERT INTO aly_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Rernem irrertety renh iwek ahern-warl-anem arrpemarl, irrertety rernem rtnwem-anem irrek ingkerrenh-antey. Rtnwem Aaron-kenhel rtnwem ingwer-rnem kwernek ingkerrenh-antey. ");
INSERT INTO aly_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Pharaoh ran awerr-antey anenh. Nthakenh Moses-ek-atherr Aaron-ek-atherr ra awelhey-angenh. Alakenh INGKART arrwekel-antey angkek Moses-ek, Pharaoh rarl awerr-antey aneyenh. ");
INSERT INTO aly_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ikwer-penh INGKART angkek Moses-ek, “Pharaoh ra anerl-ayntetyek awerr-antey. Ra Israel-kenh-rnem Egypt-they tyarlewey-angenh-antey. ");
INSERT INTO aly_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ingwepenh nga alha kwaty lher Nile-warl, kwaty impalth-itwek rtnay. Irretety weth akngemel. Nga mpwelha Pharaoh-ek, ra kwaty lher-warl apetyentyek, pwerlpirretyek. ");
INSERT INTO aly_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","17","Ra apetyenty, angka atyenh ikwer ila.” Ingwepenh Moses-then Aaron-then alhek kwaty lher Nile-warl, Pharaoh-ek mpwelhetyek. Pharaoh warrkenh-rnem-then apetyek, INGKARTelarl ilek-angkwarr. Moses-el Pharaoh ilek, “INGKART ra Akngey aneyel Israel-kenh-rnemek. Rap ayenh thwenek, ngkweng-warl iletyek. Alakenh ra ngenh ileyel, ‘Arrngert angkey-angenh atyenh-rnemek, rernem alhetyek arlpaw-warl. Rernem aker tyenkerr arlpaw-itwek atyeng arrtyemel anthetyek, atyeng inkwerelhemel-anem. Nga atyeng awelhey-angenh.’ Alakenh INGKARTel ngkweng-warl ilem arrpemarl, ‘Ntwa ayernek Moses, “Angwenh INGKART ran?” Kel mwerr, ayeng arawerrng rlterrk ilkwakert aneyel, alakenh ntwa ayenh iterl-aretyek. Arraty ayeng ngkweng angkeyel! Moses-el irrertetyel kwaty lher Nile atwetyek. Ra kwaty atwenty, rap arrnga-anem irreman. ");
INSERT INTO aly_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ikwer-penhan irrpeng-rnem ingkerrenh ilweyenh, kwaty inteng-anem irreyenh. Egypt-areny-rnem arrantherr nthakenh kwaty antywey-angenh kwaty lher-penh, arrangkw-anem, kwaty rarl apmwirrem.’” ");
INSERT INTO aly_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ikwer-penh INGKARTel Moses ilek, “Aaron ila, kwaty irrertetyel alhel-aretyek kwaty-rnem ingkerrenh Egypt-itwek, alay-rnem-then, lher-rnem-then, artnep-rnem-then, ngenty-rnem-then. Ra irrertetyel alhel-arem, kwaty-rnem rernemap ingkerrenh arrnganem irrem. Kwaty rtnwel-then tyampitel-then rernemap ingkerrenh arrnganem irrem arrpemarl, apmer arrpanenhel.” ");
INSERT INTO aly_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moses-elap Aaron ilek, irrertetyel alhel-aretyek kwaty lher-itwek. Aaron rap atwek-anem kwaty. Kwaty ingkerrenh arrnga-anem irrek. Pharaoh-el warrkenh ikwerenhel-rnem-then rernemap arek. ");
INSERT INTO aly_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Irrpeng-rnemap ingkerrenh ilwek kwaty lher-itwek, intengerrek-anem. Kwaty intengerrek arrpemarl, Egypt-areny-rnem rernemap arek kwaty intengerrekarl-anem, menty antywey-angenh-anem. Kwaty-rnem ingkerrenh rernemap arrnga-anem irrek Egypt-itwek. ");
INSERT INTO aly_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ikwer-penh ngangker-akert-rnem Egypt-areny-rnem rernem kwaty inpek, rernemap arrnga mpwarek arrpemarl, ikwer-rnem-kenh-angkwarr. Pharaoh-el arek-penh, ra awerrirrek arrpemarl. Rap nthwekern awelhey-angenh irrek ikwer-atherr Moses-ek-atherr Aaron-ek-atherr. Alakenh INGKARTel arrwekel ilek renh-atherr Moses-atherr Aaron-atherr, Pharaoh rarl awerr irrem ikwer-atherrety. ");
INSERT INTO aly_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Pharaoh rap renh-atherr iwerl-alhek, apmer ikwerenh-warl-anem ra alpek. Rap awelhey-angenh ikwer-atherr, ikwer-atherr iterrey-angenh. ");
INSERT INTO aly_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Egypt-areny-rnem rernemap nthwekern kwaty antywey-angenh. Rernemap ngenty-anem angernenh kwaty lher arrerenty-itwek kwatyek, kwatyek nthwerl-apenh-antey. ");
INSERT INTO aly_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","INGKARTel kwaty lher Nile-itwek arrnga kwaty-penh mpwarek. Ikwer-penh Moses ra anenh apmer ikwerenhel arlta 7-ek-atwety. ");
INSERT INTO aly_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ikwer-penh INGKARTel Moses ilek, “Iley-alha Pharaoh ikwer angka atyenh.” Kel Moses alhek Pharaoh-warl iletyek, “Alakenh INGKART ngkweng ilem, ‘Atyenh-rnem arlpaw-warl alhetyek, atyeng tnakemel inkwerelhetyek. Arrngert angkey-angenh, tyarlewa renh-rnem! ");
INSERT INTO aly_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Nga arrngert angkentyan, atha antyetyerr-rnem thwenem Egypt-ampeny-warl, apmer ingkerr arrngeletyek. ");
INSERT INTO aly_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Antyetyerrel-rnem kwaty lher Nile-itwek arrngeletyek. Rernem kwaty-they warl arrpanenh-warl aylpetyek. Ampererrey-alhetyek warl ngkwenh-warl, warl-rnem warrkenh-rnem-kenh-warl, warl-rnem Egypt-areny-rnem-kenh ingkerrenh-warl. Pantyel atnarnpey-alhetyek. Rernem atnarnpey-alhetyek amern amperney-angker-itwek-then arlengarr amernek-arelh-itwek-then ingkerrenh-itwek-antey. ");
INSERT INTO aly_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Antyetyerr-rnem atnarnpem ngkweng-itwek, warrkenh-rnem-itwek-then, ingkerrenh-itwek Egypt-itwek.’” Alakenh Moses-el Pharaoh renh ilek. ");
INSERT INTO aly_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ikwer-penh INGKARTel Moses ilek, “Aaron ila, ‘Irretetyel alhel-aretyek kwaty lher-rnem ingkerrenh-warl, kwaty alay-rnem-warl-then kwaty ingkerrenh-warl-antey.’ Ra alhel-arentyel, antyetyerr-rnem kwaty ingkerrenh-they tyerrelhem Egypt-itwek.” ");
INSERT INTO aly_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Kel Aaron-el irrertetyel alhel-arek kwaty lher-rnem, alay-rnem-then ingkerrenh Egypt-itwek. Antyetyerr akngerr-anem tyerrelhek kwaty-they. Rernem atnarnpey-alhek Egypt-itwek apmer ingkerrenhel. ");
INSERT INTO aly_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ngangker-akert-rnem Egypt-areny-rnem rernem irrkaty mpwarek arrpemarl, antyetyerr-rnem ingwer-rnem tyerrelhek kwaty-they arrpemarl. Antyetyerr akngerr innga-anem Egypt-itwek anenh! ");
INSERT INTO aly_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ikwer-penh Pharaoh warrkenh anyent ilek, Moses-then Aaron-then ingwerl-alpetyek. Ra renh-atherr ilek, “INGKART ayerna, antyetyerr ingkerrenh iwetyek atyengety, ingkerrenh-kety. Ra iwentyel, atha arrenhantherr tyarlewetyek, arrantherr arlpaw-warl alhetyek, aker tyenkerr INGKARTek arrtyemel anthetyek.” ");
INSERT INTO aly_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moses-el Pharaoh ayernek, “Ilenger ayeng angkem INGKARTek ngkweng, ngkwenh-rnemek-then? Atha apek ayernenty INGKART, ikwer-penh antyetyerr-rnem ingkerr warl ngkwenh-they warl-rnem warrkenh ngkwenh-rnem-kenh-they tyerrelhemel rernem alpem. Rernem alpem kwaty lher Nile-warl, irrkaty ikwer-warl.” ");
INSERT INTO aly_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","11","Pharaoh angkek Moses-warl, “Ingwelarreng INGKART ayerna.” Moses angkek, “Ya! Ayeng angkem INGKARTek ingwelarreng. Antyetyerr-rnem ingkerrenh alpetyek ngkweng-they, warrkenh Egypt-areny-rnem ingkerrenh-they. Rernem warl-rnem-they tyerrelhem, kwaty lher Nile-warl ingkerrenh alpem. Ikwer-penh ntwa iterl-arem INGKART ra innga anyent-antey, Akngey anwekantherrenh, ingwer-rnem-apeny-weny.” ");
INSERT INTO aly_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ikwer-penh Moses Aaron-then Pharaoh iwerl-alhek. Ingwepenh Moses INGKARTek arlkek, “Antyetyerr ingkerrenh aknga Egypt-they!” ");
INSERT INTO aly_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","INGKARTel Moses awek, rap alakenh mpwarek. Antyetyerr-rnem ilwek, apmer arrpanenhel, warl ingkerrenhel-then, akethel-then. ");
INSERT INTO aly_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Egypt-arenyel-rnem antyetyerr-rnem ingkerrenh ipmernem rernem akwetyeynenh. Antyetyerr-rnem rernem ingkerrenh intengerrek. ");
INSERT INTO aly_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Pharaoh ra antyetyerr ipmernem arekel, ra awerr arrpemarl irrek. Moses-ek Aaron-ek-atherr awelhey-angenh arrpemarl ra irrek. Alakenh INGKART arrwekel angkek, Pharaoh ra awerr arrpemarl irrem. ");
INSERT INTO aly_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ikwer-penh INGKARTel Moses ilek, “Aaron ila, ‘Irretetyel ahern atwetyek.’ Ra ahern atwentyel, aheny akngerr-anem ahern-they tyerrelhem, Egypt-ampeny-itwek apmer arrpanenhel arrngeletyek.” ");
INSERT INTO aly_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Kel Aaron-el irrertety inemel ahern atwek-anem, Moses-elarl ilek-angkwarr. Aheny-rnem tyerrelhek ahern-they anamerl-antey, Egypt-itwek apmer arrpanenhel. Aheny-rnem alkerel aparnperrek, artwernem-then arelh-rnem-then ingkerrenh artek, atnwenth ingkerrenh-then artek rernem. ");
INSERT INTO aly_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ikwer-penh ngangker-akert-rnem arrkernelhenh, aheny-rnem ahern-they tyerretyek-arrpantey, ikwer-rnem-kenh-angkwarr. Ywarn-antey arrkernelhenh, arrangkw. Aheny-rnem artwernem-itwek atnwenth-rnem-itwek anenh-antey. ");
INSERT INTO aly_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ngangker-akert-rnem angkek-anem Pharaoh-ek, “Arrangkw nthakenh aheny-rnem mpwarey-angenh anwantherr, akwerrp anwantherr. Arawerrng rlterrk Akngey-kenhantel Aaron-el ahern-they aheny-rnem mpwarey-angker.” Pharaoh ran awerr-antey, awelhey-angenh arrangkw. Alakenh INGKART arrwekel angkek Moses-ek, Pharaoh ra awerr anerl-ayntem. ");
INSERT INTO aly_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","INGKARTel Moses ilek, “Ingwepenh akwenta, kwaty lher-warl alha. Nga mpwelha Pharaoh ikwer. Ra apetyenty, angka atyenh ikwer ila.” Kel Moses alakenh Pharaoh-ek mpwelhek. Pharaoh apetyek lher-warl. Moses-el Pharaoh ilek, “Alakenh INGKARTel ngkweng ilem, ‘Atyenh-rnem arlpaw-warl alhetyek, atyeng tnakemel inkwerelhetyek. Tyarlewa, arrngert angkey-angenh! ");
INSERT INTO aly_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Nga arrngert angkenty, atha ameng-rnem arrekantherr-warl thwenetyek, arrenhantherr arwengkeletyek. Amengel-rnem ngenh ampereletyek, warrkenh-rnem ngkwenh-then, Egypt-areny-rnem ingkerrenh-antey. Ameng-rnem akngerrerreyenh warl ikwer-rnem-itwek ingkerrenh Egypt-itwek, ahern ingkerrenhel rernem aparnperreyenh. ");
INSERT INTO aly_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Atha ameng-rnem thweney-angenh apmer Goshen-ampeny-warl, Israel-kenh-rnem anew-aneyel-warlan, arrangkw. Ameng-rnem nthakenh anperirrey-angenh apmer Goshen-ampeny-warl. Ntwa ameng-rnem arenty Egypt-areny-rnem-itwekant, ntwa ayenh iterl-aretyek, ayengan INGKART inngarl anem Egypt-ampeny-itwek. ");
INSERT INTO aly_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Arraty, ingwelarreng arawerrng rlterrkel atha ameng-rnem thwenem Egypt-areny-rnem-warl. Ameng-rnem alheyenh arrekantherr-warl, atha atyenh-rnemant arntarnt-arem ameng-kety. Ameng-rnem alhey-angenh atyenh-rnem-warl.’” ");
INSERT INTO aly_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Kel alakenh ayntek. INGKARTel ameng-rnem akngerr thwenek ikwer-rnem-warl. Rernem aylpenhek warl Pharaoh-kenh-warl, warl-rnem warrkenh-rnem-kenh-warl-then. Ameng akngerr inngel-anem artey-alhek Egypt-itwek. ");
INSERT INTO aly_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Pharaoh-el thwenek warrkenh anyent Moses Aaron-then ikngwerl-alpetyek. Pharaoh angkek ikwer-atherr, “Ya! Apmer nhek-antey arrantherr aker tyenkerr arrtyemel antherl-ayntetyek Akngey arrekantherrenhek!” ");
INSERT INTO aly_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Moses-el tyernek renh, “Nthakenharl alakenhan? Anwernantherr pwelek-rnem atwemel, ampernenty, INGKARTek anthenty, Egypt-areny-rnem, ahelerrekerr anwernekantherr. Rernem iltenty apek, ‘Ilekek arrantherr pwelek-rnem atweyel? Impen anwernekantherr! Anwernantherr kwenerrem ikwerek altyerr-rnem!’ Ikwer-penharl rernem apwertel anwernenhantherr wekerr, ipmek atwekerr. ");
INSERT INTO aly_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Alakenh anwernantherr apmer nhek-antey aker tyenkerr arrtyey-angenh-antey INGKARTek. Anwernantherr arlpaw-warl alhey-areny itwern irrpetyek-atwety. Arlpaw-itwekant anwernantherr aker tyenkerr arrtyemel anthetyek INGKARTek Akngey anwernekantherrenhek. Alakenh INGKARTel ilek.” ");
INSERT INTO aly_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Pharaoh-el ilek Moses-ek, “Ya, arrantherr alhenherr-arey arlpaw-warl Egypt-they. Arleng alhey-angenh. Angath-antey alhenherr-arey, aker tyenkerr arrtyemel anthetyek INGKARTek Akngey arrekantherrenhek. Alhey-alentyel, ayerna INGKART, ameng-rnem irrentetyek anwernekantherr-they.” ");
INSERT INTO aly_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moses angkek ikwer, “Ya. Ayeng alpem, ayeng angkey-alpem INGKARTek. Ingwelarreng ameng-rnem ngkweng-they alpem, warrkenh ngkwenh-rnem-they-then Egypt-areny-rnem-they-then. Atyeng awelha! Irrtywerremel iley-angenh! Arrngert angkey-angenh, anwernantherr arlpaw-warl alhetyek, aker tyenkerr arrtyemel anthetyek INGKARTek.” ");
INSERT INTO aly_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Ikwer-penh Moses-el iwerl-alhek Pharaoh, INGKART-warl angkek-anem. ");
INSERT INTO aly_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","INGKARTel Moses awek. Ingwepenh INGKARTel ameng-rnem irrentek Pharaoh ikwer-they, warrkenh-rnem-then-they, Egypt-areny-rnem-then-they. Ameng-rnem ingkerr ilwenherrek-anem. ");
INSERT INTO aly_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Pharaoh ra awerrirrek arrpemarl, awelhey-angenh. Arrwekel-antey ra ilek, ra Israel-kenh-rnem tyarlewetyek Egypt-they. Ra arrngert angkek arrpemarl, renh-rnem tyarlewey-angenh, rernem Egypt-they arlpaw-warl alhey-angenh. ");
INSERT INTO aly_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","INGKARTel ilek Moses, “Pharaoh-warl iley-alha angka atyenh.” Kel Moses Pharaoh-warl alhek angketyek, “Alakenh INGKART rey-antey Akngey Israel-kenh-rnem-kenh ngkweng ilem, ‘Atyenh-rnem arlpaw-warl alhetyek, atyeng tnakemel inkwerelhetyek. Tyarlewa renh-rnem, arrngert angkey-angenh!’ ");
INSERT INTO aly_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","3","Nga apek arrngert angkenty Israel-kenh-rnem-kety. Ntwa antwerrkenty renh-rnem Egypt-itwek, INGKARTel pwenty thwenem nantew arrekantherrenh-warl, tangkey-rnem-warl, kamwerl-rnem-warl, pwelek-rnem-warl, yep-yep-rnem-warl, nanikwet-rnem arrekantherrenh-warl ingkerrenh apmer arrpanenh-warl Egypt-itwek. Atnwenth-rnem ilwenherrem ingkerrenh. ");
INSERT INTO aly_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Atnwenth-rnem Israel-kenh-rnem-kenh ilwenherrey-angenharl, itetharl anem. INGKARTel renh-rnem arntarnt-areyel. ");
INSERT INTO aly_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Arraty, INGKART angkek atyeng, ‘Ingwelarreng atnwenth-rnem Egypt-areny-rnem-kenh ingkerrenh ilwenherrem!’” ");
INSERT INTO aly_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Kel ingwer-inger INGKARTel pwenty thwenek, atnwenth-rnem ingkerrenh Egypt-areny-rnem-kenh arntetyerrek, Moses-elarl ilek-angkwarr. Ingkerrenh ilwenherrek. Atnwenth-rnem Israel-kenh-rnem-kenh ilwey-angenharl, arrangkwarl. ");
INSERT INTO aly_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Pharaoh-el atnwenth-rnem Egypt-areny-rnem-kenh ilwenty ra arek. Ra warrkenh-rnem ilanthek, Goshen-ampeny-warl alhetyek, Israel-kenh-rnem-warl. Rernem arey-alhek atnwenth-rnem Israel-kenh-rnem-kenh iteth-antey ingkerr. Rernem alpek Pharaoh ikwer-warl. Rernem ilek, “Atnwenth ikwer-rnem-kenhan iteth ingkerrarl!” Pharaoh awerr-antey anenh, awelhey-angenh. Ra arrngert angkek arrpemarl. ");
INSERT INTO aly_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ikwer-penh INGKARTel ilek Moses-atherr Aaron-atherr, “Alhenherr-atherr ikwenty inetyek. Moses, ntwa ikwenty inemel, iwa alker-warl, Pharaoh-el ngenh aretyek. ");
INSERT INTO aly_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ikwenty ra ahern-apeny irrem, alherrpel apmer arrpanenh-warl iwem. Ahernel artem Egypt-areny-rnem atnwenth-rnem-then, artweker akngerr irrem ikwer-rnem-itwek. Artweker akngerr arlka ingkerr-warl rernem arrernelhem, tywen-angketyarr.” ");
INSERT INTO aly_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ikwer-penh Moses-el-then Aaron-el-then ikwenty inek. Ratherrap Pharaoh-warl alhek. Moses-el ikwenty iwek ikwer arrwekel alker-warl. Egypt-areny-rnem ingkerrenh atnwenth-rnem ingkerrenh-then rernem artweker-akert irrek. Rernem artweker-rnem anthwek-anem. ");
INSERT INTO aly_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ngangker-akert-rnem Egypt-areny-rnem artweker-akert-anemarl irrek. Nthakenh rernem Moses-angkwarr rtney-angenh. ");
INSERT INTO aly_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","INGKARTel Pharaoh renh awerrelek arrpemarl. Ra Moses-ek-atherr Aaron-ek-atherr awelhey-angenh. Alakenh INGKARTel arrwekel-antey ilek Moses, Pharaoh-arl ra awerrirrem arrpemarl. ");
INSERT INTO aly_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","INGKARTel Moses ilek, “Ingwepenh akemirretyek, Pharaoh renh aretyek. Ila Pharaoh ikwer angka atyenh.” Kel Moses ingwepenh akemirrek, Pharaoh-warl iletyek alhek, “Alakenh INGKART Israel-kenhel ngkweng ilem, ‘Atyenh-rnem arlpaw-warl alhetyek, rernem atyeng tnakemel inkwerelhetyek. Tyarlewa, arrngert angkey-angenh. ");
INSERT INTO aly_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Nga apek arrkngert angkenty, pwenty atha arrekantherr-warl thwenem. Atha ngenh irrwampenh-anthetyek, warrkenh ngkwenh-rnem-then, Egypt-areny-rnem ingkerrenh. Ntwa ayenh iterl-aretyek, ayengan Akngey anyentarl aneyel, ingwer apek aney-angenh. ");
INSERT INTO aly_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","16","Atha arrenhantherrenh atwenty, arrantherrap ingkerrenh ilwenherremarl. Aleyaw arrangkw-anemarl! Mwerr-anemarl nga, iteth-anemarl atha ngenh atnyeneyel. Atha ilek-ilek mpwarey-angker arrangkw-they, ntwa ayenh iterl-aretyek, ayeng arawerrng ilkwakert. Ingwer-rnemel angka atyenh ilerl-apeyenh apmer arrpanenh-warl, itna atyenh tnakemel.’ ");
INSERT INTO aly_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","INGKARTel Pharaoh renh ilek arrpemarl, ‘Nga awerr-antey irrpeltherreyel. Nga ahelerreyel atyenh-rnem-kety, tyarlewey-angenh renh-rnem. ");
INSERT INTO aly_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Atyeng awelha! Ingwelarreng atha thwenem apwert apertew, ngkweltyeletyek apmer arrpanenh Egypt-itwek. Arrantherr alakenh apertew arey-angenh, akwerrparl. ");
INSERT INTO aly_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Warrkenh ngkwenh-rnem thwena apmer arrpanenh-warl. Renh-rnem ila, pwelek-rnem atnwenth ingwer-rnem-then anyenteletyek, warl ikwer-rnem-kenh-warl renh-rnem akwernetyek. Ingwepenh apertewel Egypt-itwek atwem-kety. Ingkerrenh-antey atwem-kety akethel rtneyel-rnem artwernem-then atnwenth-rnem-then. Akethel rtneyel-rnem ingkerrenh ilwenherrem.’” Alakenh Moses-el Pharaoh ilek. ");
INSERT INTO aly_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Pharaoh-kenh warrkenh-rnemel Moses renh awek, rarl angkenh. Ingwer-rnem arternpel ikwer awelhenh, rernem INGKART-kety aterirrenh. Rernem warrkenh tyayl-areny-apeny-rnem ikwer-rnem-kenh anamerl-antey ikngwerl-alhek, atnwenth-rnem-then. Rernemap ingkerrenh warl-warl akwernek. ");
INSERT INTO aly_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Warrkenh Pharaoh-kenh ingwer-rneman Moses-ek awelhey-angenh, angka INGKART-kenhek. Warrkenh-rnem tyayl-areny-apeny-rnem ikwer-rnem-kenh atnwenth-rnem-then rernem akngetyey-angenh warl ikwer-rnem-kenh-warl, akwerney-angenh. Akethel-antey rtnenherrenh. ");
INSERT INTO aly_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ikwer-penhan INGKART angkek Moses-warl, “Akwa alker-warl-athek atnyena. Atha kwaty apertew-rnem renh-rnem alker-they iwetyek ikwer-rnem-warl, renh-rnem ingkerrenh atwetyek, artwernem-then atnwenth-rnem-then amern-rnem-then ingkerrenh-antey Egypt-itwek.” ");
INSERT INTO aly_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","24","Moses-el irrertety inek, alker-warl-athek atnyenek. INGKARTel apertew-anem iwek Egypt-warl. Awely-awely angkek, kwaty apertew-akert rntwek Egypt ikwer-itwek. Alakenh inngarl! Apertew akngerr ayntek ahernel. Egypt-arenyel-rnem alakenh-anyem ingwer-inger arey-angenh, aleyant rernem arek! ");
INSERT INTO aly_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Apertewel ingkerrenh aketh-itwek rtneyel-rnem innga atwek Egypt-ampeny-itwek. Ingkerrenh ywerrerl-alhek aketh-itwek, artwernem-then atnwenth-rnem-then. Amern weyt ingkerrenh atwek, alperr-then arwerl-they atwek. ");
INSERT INTO aly_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Goshen-ampeny-itwek, Israel-kenh-rnem-itwek apertewel atwey-angenh, arrangkwarl. ");
INSERT INTO aly_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Pharaoh-el warrkenh ikwerenh ilanthek, Moses Aaron-atherr ingwerl-alpetyek, ratherr ikwer-warl angketyek. Pharaoh ikwer-atherr ilelhek, “Athan apmwel-areth mpwarek. Ayeng atyenh-rnem-then INGKART-kety ament aneyel. INGKARTarl arraty inngarl, anwekantherr-apeny-weny ra aneyel. ");
INSERT INTO aly_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","INGKART atyeng ayernenherr-atherr. Apertew ipmelhetyek awely-awely-then. Ra anwenhantherr atweyel-kety. Alhewer arrantherr alhetyek, atha arrenhantherrenh tyarlewem, antwerrkey-angenh-anem.” ");
INSERT INTO aly_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moses Pharaoh-warl angkek, “Ayeng tawen nhenh-they alpem. Ayeng alpentyelan, akwa atha alker-warl atnyenem, athap INGKART ngkweng ayernem. Ra apertew ywerrelhiletyek. Nthakenh ra apertew thweney-angenh, awely-awely arrantherr nthakenh awey-angenh arrpemarl. Arrantherr ahern nhenh iterl-arem INGKART-kenh-anem. ");
INSERT INTO aly_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Athan iterl-areyel arrenhantherr, arrantherr Akngey INGKART-kety aterirrey-angenh-antey.” ");
INSERT INTO aly_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Arrwekel-antey kwaty apertew-akert rntwey-angenh-antey, antywer arlpenty itna flax lyapek Egypt-itwek apmer arrpanenh-itwek. Amern parley lyapek arrpemarl. Flax amern parley-then ampeng-anem irrek apmer arrpanenh-itwek. Kwaty apertew-akert rntwek, apertewel flax-then amern parley-then athenemel atwek arrpemarl. ");
INSERT INTO aly_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Amern weyt-then amern ingweran weyt-apeny-then alerl-antey, ampengirrey-angenh-antey. Apertewel renh-rnem atwek, kel mwerr-antey, lyapenh-antey. ");
INSERT INTO aly_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moses ra Pharaoh iwerl-alhek, tawen-they aketh-warl alhek. Ranem akwa-atherr irrwerlelek alker-warl-athek, INGKART ayernemel. Apertew awely-awely-then kwaty-then arternpelek, ywerrek-anem. ");
INSERT INTO aly_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Pharaoh ra alakenh-anyem arek. Ra apmwel-ayeth mpwarek arrpemarl. Ra awerr arrpemarl irrek, warrkenh ikwer-rnem-kenh-then awerrirrek, awelhey-angenh anenh. ");
INSERT INTO aly_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Pharaoh-el Israel-kenh-rnem nthakenh tyarlewey-angenh renh-rnem, antwerrkek-antey. INGKARTarl alakenh arrwekel-antey angkek Moses-ek, Pharaoh-arl ra awerrirrem arrpemarl. ");
INSERT INTO aly_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","INGKARTel Moses ilek, “Pharaoh-warl angketyek alha. Atha renh warrkenh-rnem-akert awerrelek, ayeng arawerrng rlterrkel iylparrernelhetyek ikwer-rnem-itwek. ");
INSERT INTO aly_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Atha renh-rnem atwem-penh, arrantherr ayenh iterl-arayntetyek, ayengan INGKART inngarl aneyel, akngey-arrpantey-rnem ikwer-rnem-kenh arrangkwarl. Ingkern-penhel-rnem ayenh iterl-arayntetyek arrpemarl, aler-rnem-then arrengey-rnem-then artartey-rnem-then rernem ilerrerl-anetyek ingkern-theyarl, Egypt-areny-rnem atha atwek arawerrng rlterrk-akertel.” ");
INSERT INTO aly_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Moses Aaron-then Pharaoh-warl angketyek alhek. Warl ilkwa ikwerenh-warl aylpenhek, ratherr Pharaoh ikwer-warl angkey-alhek-anem, “Alakenh-anyem INGKART anwernekantherrenh ngkweng-warl angketyek, ‘Nga atyeng arleng-alenty awelhey-angenh, ngap tnakelheyelant. Atyenh-rnem apmer arlpaw-warl alhetyek, aker tyenkerr rernem ayenh arrtyemel anthetyek, atyeng inkwerelhemel. Ikwer-rnem arrngert angkey-angenh, tyarlewa renh-rnem! ");
INSERT INTO aly_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ngarl arrngert angkenty, ntwa atyenh-rnem antwerrkenty, intelty-rnem akngerr atha thwenem apmer ngkwenh-warl ingwepenhan. ");
INSERT INTO aly_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Inteltyel-rnem ingkerrenh arteyenh apmer Egypt-itwek. Nthakenh ahern arey-angenheleyenh, inteltyel-rnem artem-kety. Apertewel atwek-penh amern weyt irrpetyap-anem lyapenh. Intelty-rnem apetyeyenh, amern weyt ingkerrenh arlkweyenh, alperr-then ingkerr-antey. ");
INSERT INTO aly_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Intelty-rnem warl ngkwenh-warl aylpeyenh, warl warrkenh-rnem-kenh-warl-then, warl Egypt-areny-rnem-kenh-warl-then, warl ingkerrenh-warl. Arrwekelenyel-rnem alakenh intelty akngerr innga arey-angenh. Egypt-arenyel-rnem alakenh arey-angenh, arrangkw. Aleyant-anem areyenh.’” Alakenh Moses Pharaoh-warl angkek, intwemel alpek-anem. ");
INSERT INTO aly_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Warrkenh-rnem ikwerenh Pharaoh ikwer-warl angkek-anem, “Moses nhenhan anwenhantherrenh kwantheyelan. Ra apmwel-areth anwenhantherrenh mpwareyel, apmer nhenh-itwek. Ilek-anem nga menty angkeyel Moses-ekan? Israel-kenh-rnem tyarlewa apmer nhenh-they, rernem arlpaw-warl alhetyek, INGKARTek Akngey ikwer-rnem-kenhek tnakemel inkwerelhetyek. Ntwa iterl-areyel, ra apmer nhenh Egypt kel apmwelek.” ");
INSERT INTO aly_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Kel warrkenh-rnem alhek, Moses Aaron-atherr ikngwerl-alpek. Pharaoh angkek ikwer-atherr, “Ya! Kel alhenherr-arey apmer arlpaw-warl, tnakemel inkwerelhetyek INGKARTek Akngey arrekantherrenhek. Atha arrenhantherr menty tyarlewem, arrngert angkey-angenh-anem. Kel angwenharlap apmer arlpaw-warl alhem. Akngerr?” ");
INSERT INTO aly_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moses ikwer-warl angkek, “Anwernantherr ingkerrenh, artwamp-rnem artwa akely-rnem-then, arelh-rnem-then ampernem-then, pwelek-rnem-then yep-yep-rnem-then ingkerrenh-antey. Anwernantherr apmer arlpawel aney-alhemel, kwenty anwernantherr atnyeneman, INGKARTek inkwerelhetyek.” ");
INSERT INTO aly_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Pharaoh Moses-warl angkek, “Arrangkwaw! Athan arrenhantherr tyarlewenty arelh-rnem-then ampernem-then-angkwarr, arrantherrap apey-alpekerr, atwetyek anenhantherr ingkerr Egypt-itwek. Mwanty atyeng awelhenherr-atherr, ament iylpelant awey-angenh. Ayeng mwerr-weny arrekantherr anem. Arrantherr arelh-rnem ampernem-then atnwenheynetyek apek? Arrangkwaw! Nthakenh atha renh-rnem tyarlewey-angenh. ");
INSERT INTO aly_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Arrangkw. Artwernemant apmer arlpaw-warl alhenherr-arey, INGKARTek tnakemel inkwerelhetyek. Alakenh-anyem mpwelan arrwekel-antey ayernenh. Arelh-rnem-then ampernem-then artenyarl anayntem!” Pharaoh-kenh warrkenh-rnem rernem Moses-atherr Aaron-atherr warl-they irrentek-anem. ");
INSERT INTO aly_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ikwer-penhan INGKARTel Moses ilek, “Akwa irrwerlela alker-warl-athek, Egypt apmer ingkerrenh-angkwarr. Intelty akngerr-anem apetyeyenh Egypt ikwer-warl, ingkerrenh-angkwarr arteyenh. Apertewel atherrk atwek-penh, atherrk intweyneyel angkep arrpemarl. Inteltyel-rnem alperr-rnem atherrk ingkerr arlkwem.” ");
INSERT INTO aly_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Kel Moses-el irrertety ikwerenh inek, Egypt apmer arrpanenh-warl alhel-arek. INGKARTel alherrp ilkwa akngerrakw-they thwenek. Alherrp ra arltel-then ingwel-then aleth innga pwenh. Ingwepenhan alherrp ra intelty akngerr innga akngetyek. ");
INSERT INTO aly_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Intelty-rnem ahern ingkerrenh artenh, apmer ingkerr artenh, apmer Egypt-itwek. Rernem iterrek, “Aleyant anwantherr arek intelty akngerr innga.” Aley anwantherr arey-angenh arrpemarl intelty akngerr innga. ");
INSERT INTO aly_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Intelty-rnem atnarnpem ahernel. Ahern irrpwerl inngirrek. Apertewel atwekarl-penh, atherrk-rnem arwerl-rnem angkep lyaperrenh. Inteltyel-rnem ingkerrenh-antey arlkwek, atherrk-rnem alperr-rnem-then amern-rnem-then. Egypt-itwek arwerl-rnem ingkerr alperr-weny, atherrk-weny, arrangkw-anem ayntek. ");
INSERT INTO aly_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Pharaoh-el anamerl-antey warrkenh ikwerenh thwenek, Moses-atherr Aaron-atherr ingwerl-alpetyek. Pharaoh angkek ikwer-atherr, “Atha INGKART Akngey arrekantherrenh-angkwarr apmwel-areth mpwarek, mpwelek-angkwarr-then. Ayeng mpwelek awelhey-areny. ");
INSERT INTO aly_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Atyeng ahelerrey-angenh anenherr-atherr! Tyarlewenherr-atherr ayenh apmwa atyenh-they, awakelhey-angenh, angkep ayenh atwey-angenh! Mpwel INGKART ayernenherr-atherr, intelty ywerrelhiletyek anwekantherr-kety. Arrangkwelan, anwantherr ingkerrarl ilwenherrem amern-weny, inteltyel-rnem ingkerrenh arlkwek!” ");
INSERT INTO aly_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moses-el Pharaoh renh iwerl-alhek, INGKART-warl angkek. ");
INSERT INTO aly_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","INGKARTel Moses renh awekarl angkenh, ran alherrp akngartewek-anem, altwerl-they-anem pwey-alhek-anem. Alherrpel intelty-rnem ingkerrenh kwaty alay-warl-anem iwek. Kwaty alay itnan Apenng-angketyarr. Egypt-itwek intelty arrangkw-anem. ");
INSERT INTO aly_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ikwer-penhan INGKARTel Pharaoh renh awerr arrpemarl mpwarek, nthakenh ra Israel-kenh-rnem tyarlewey-angenh Egypt-they. ");
INSERT INTO aly_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","INGKARTel Moses renh ilek. “Akwa irrwerlila alker-warl-athek. Atwemengkirrem Egypt-ampeny-itwek, apmer arrpanenhel, arerrey-angenhant-arey atwemengkel.” ");
INSERT INTO aly_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Kel Moses ra akwa alker-warl-athek irrwerlilek. Atwemengkirrek-anem Egypt-ampeny-itwek ingkerrenh-angkwarr. Atwemengk ayntek arlta irrpetyek-atwety. ");
INSERT INTO aly_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Artwernem ingkerrenh nthakenh arerrey-angenhant-arey, atwemengk ayntek-kety-anem. Arlta irrpetyel rernem alhey-angenh anek, apmer anyentel-antey anenh. Rernem arey-angenh anek arrangkw. Israel-kenh-rnem-itwel Goshen-ampeny-itwel arlta-antey ayntenh, rernem arenh-anteyarl. Atwemengkirrey-angenh, arrangkw. Lyenentyel-apeny anenh rernem. ");
INSERT INTO aly_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Pharaoh-el thwenek warrkenh renh, Moses ingwerl-alpetyek. Pharaoh ikwer angkek, “Ya! Arrantherr alhenherr-arey apmer arlpaw-warl, INGKART tnaketyek, ikwer inkwerelhetyek. Atha arrenhantherr nthakenh antwerrkey-angenh. Arelh-rnem-then ampernem-then atnwenheynenherr-arey. Pwelek-rnem-then yep-yep-rnem-then nanikwet-rnem-then nhel-antey anerl-ayntetyekarl.” ");
INSERT INTO aly_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Moses tyernek Pharaoh-ek. “Arrangkw! Nthakenh anwernantherr pwelek-rnem yep-yep-rnem-then nanikwet-rnem-then akngeynem, anwantherr INGKARTek arrtyemel anthetyek. ");
INSERT INTO aly_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Anwernantherr yerlirreyel ikwer-rnem ingkerrenh, arrtyemel anthetyek INGKART anwernekantherrenhek. Inpa iterl-arey-angenh, aker ilek-apeny renh anwernantherr antheman, akngerr apek, irrpety apek. INGKARTel ingwer-inger anwernenhantherr ilem wenh.” ");
INSERT INTO aly_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","INGKARTel Pharaoh arwengkilek, awerr inngarl ranap anenh. Israel-kenh-rnem ra tyarlewey-angenh arrangkw-antey. Rernem anenh-antey. ");
INSERT INTO aly_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Pharaoh-el Moses iltek, “Nhenh-they intem-antey alpa, apey-alpey-angenh-anem. Ayeng apey-alpenty, atha ngenh ipmek atwemarl!” ");
INSERT INTO aly_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moses-el renh tyernek, “Mwerr, ntwa ayenh ilek wenh. Ayeng aleth-antey alpetyek. Ayeng apey-alpey-angenh, ngenh aretyek.” ");
INSERT INTO aly_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","INGKARTel Moses arrwekel-antey ilek, “Atha Pharaoh Egypt-areny-rnem-then anyent-inger-antey atweyenh. Ikwer-penh ra arrenhantherrenh tyarlewem, arrantherr Egypt-they alhetyek. Pharaoh-el arrenhantherr ingkerrenh irrentem Egypt-they. ");
INSERT INTO aly_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Israel-kenh-rnem-warl angketyek alha. Renh-rnem ila, Egypt-areny-rnem ampwal-rnemek thilp-penhek-then gold-penhek-then ayernetyek.” Alakenh-anyem INGKARTel arrwekel-antey ilek Moses-an. ");
INSERT INTO aly_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Arrwekel-antey Egypt-areny-rnem ilkelhey-angenh anenh Israel-kenh-rnemek. INGKARTel renh-rnem mpwarek, awelhetyek Israel-kenh-rnemek. Egypt-arenyel-rnem iterl-arek Moses renh, artwa mwerrarl ra anenh. Ikwer-penh Israel-kenh-rnem rernem Egypt-areny-rnem ayernek thilpek, gold-ek-then. Egypt-areny-rnemel renh-rnem iltey-angenh arrangkw. Rernem mwerr Israel-kenh-rnem-angkwarr anek. Rernem Israel-kenh-rnem thilp akngerr gold-then akngerr anthek. ");
INSERT INTO aly_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ikwer-penhan Moses angkek Pharaoh-ek, “Alakenh-anyem INGKART ngkweng-warl angkem, ‘Ingwa ampepenyel Egypt-itwek ayeng alhayntem. ");
INSERT INTO aly_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ayeng ampererr-ayntem Egypt ikwer-itwek, atha aler awey arrekantherrenh-rnem arrwekeleny-rnem ingkerrenh atwem. Atha alerengkw ngkwenh awey arrwekeleny atwem. Atha arelh warrkenh-rnem-kenh ampikw awey arrwekeleny-rnem atwem arrpemarl. Atha pwelek irrwey arrwekeleny-rnem atwem arrpemarl. ");
INSERT INTO aly_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ikwer-penhan Egypt-arenyel-rnem artewentyel artnem alerikw ikwer-rnem-kenhek. Artewentyel innga nhepenh rernem artnem. Rernem angkerrem alakenh, “Anwantherr awank alakenh artney-angenh. Ingwer-inger anwantherr alakenh artney-angenh.” Rernem iterrek, “Aleyant anwantherr intem-antey artnalhelhirrenh.” Aleyan arrangkw-anemarl, intem-antey artnalhelhirrey-angenh ikwer-apeny. ");
INSERT INTO aly_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Rlengk ingwel Israel-kenh-rnem rernem mwerr-anem anem, akayel atnalhelirreyel. Arengk-rnem Egypt-areny-rnemek rnkernelheyenharl, arengk-rnem Israel-kenh-rnemek rnkernelhey-angenh arrangkwarl. Israel-kenh-rnemant atha arntarnt-areyel. Atha Egypt-areny-rnem arntarnt-arey-angenh, arrangkw. Alakenh ntwa iterl-arem ayeng INGKART.’ Alakenh-anyem INGKART ngkweng-warl angkeman. ");
INSERT INTO aly_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ikwer-they warrkenh ngkwenh-rnem atyeng-warl apetyem kwenerrey-alhemel. Rernem angkem, ‘Moses! Alha nhenh-they, ngkwenh-rnem ingkerrenh atnwenheyna apmer nhenh-they, rernemarl ngkweng awelheyel-rnem.’ Alakenh-anyem rernem atyeng angkenty, atha renh-rnem iwerl-alhem alhemel-anem.” Moses ra ahelerrek, Pharaoh renh iwerl-alhek-anem. ");
INSERT INTO aly_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ikwer-penh INGKART angkek Moses-warl, “Pharaoh ngkweng awelhey-angenh-antey. Atha renh arwengkilek, ayeng arawerrng rlterrk-akert aremirretyek Egypt-itwek, ingkerrenhel ayenh iterl-aretyek.” ");
INSERT INTO aly_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Kel arraty. Moses-atherr Aaron-atherr ratherr arawerrng rlterrk INGKART-kenh iylparrernenh, Pharaoh-el aretyek. INGKARTel aleth-antey Pharaoh renh awerr mpwarenh, Pharaoh ra awelhey-angenh anenh. Ra Israel-kenh-rnem tyarlewey-angenh-antey, rernem Egypt-they alperlewetyek. Ra renh-rnem arleng-alenty antwerrkenh. ");
INSERT INTO aly_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","2","INGKARTel Moses-atherr Aaron-atherr ilek Egypt-itwek, “Aherrety arrpanenhel alkent lyerteny arrantherr iterl-areman, renh itnewem Abib. ");
INSERT INTO aly_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Mpwel alhenh-atherr Israel-kenh-rnem alakenh-anyem iletyek, ‘Mpwelhenh-arey arlta 10-ek-atwety. Ikwer-penhan warlek-artweyel-rnem aker yep-yep inenherr-arey, rernem yep-yep akely atwetyek apmer amentew-ament. ");
INSERT INTO aly_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Irrpetyapant apek warl anyentel anem, rernem apek aker yep-yep nthakenh arlkwey-angenharl warl anyent-itwek ywerrelhilemel, irrpetyapelan. Apmwarl alakenhan, rernem anyenterremel arlkwentyan mwerrarl, akngerrelarl atnwenth ywerrelhilemelarl arlkwem. ");
INSERT INTO aly_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Yep-yep ilek-apeny arrantherr rlwanem wenh, arlkwetyek? Yep-yep ampwerrk aherrety anyentel ilkwerrek irrwey mwerr-angker rlwanetyek, alyelk inngarl. Yep-yep-wenyelan nanikwet irrwey akely rlwanenherr-arey.’” ");
INSERT INTO aly_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","INGKARTel renh-atherr ilek, “Yep-yep renh inenty, arrantherr renh arntarnt-aretyek arlta 4-ek-atwety. Ikwer-penhan ingkeny aylpenhentyelan, Israel-kenh-rnem arrantherr aker yep-yep atwetyek-anem inkwarteyel, warl arrpanenh-itwek-anem. ");
INSERT INTO aly_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ikwer-penhan arrantherr warl arriw akern-ampeny yep-yep-penh arrngel apernetyek, irrker-atherr-then warl arrpanenh-itwek, warl yep-yeparl arlkwek-penh-rnem-kenhant. ");
INSERT INTO aly_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ingwa ikwerel-antey yep-yep rwel ampernetyek. Aker renh arrantherr arlkwetyek, alperr tyekertel-then amern ilperr-ilperr-then. ");
INSERT INTO aly_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Aker arlety arlkwey-angenh. Kwatyel amperney-angenh arrangkw. Aperrkel arrantherr aker renh ampernetyek, akapwert-then arlaw-atherr akwa-atherr analty-then ingkerrenh-antey. ");
INSERT INTO aly_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ingkerrenh arlkwenherr-arey. Ingkeny tyerrelhenhey-alhentyel, aker ampeny apek ayntentyan, arrantherr arlkweyang menty aretyek. Rwewarl iwenh-arey, aker ampeny ingkerrenh-antey ikwentyirremel ampetyek.” ");
INSERT INTO aly_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","INGKARTel renh-atherr ilek, “Alakenh-anyem arrantherr aker arlkwetyekan. Aker arlkwey-alentyel, arnkwel aylpetyek pwetel-then. Irretety inenherr-arey, arrantherr alethel alpetyek. Aker-then amern-then anamerl-antey arlkwenherr-arey wenh. Tyenkerr nhanyem INGKART-kenh arrantherr itnewem Anperarl Alhek ‘Passover’. ");
INSERT INTO aly_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Ingwa ikwerel-antey ayeng alkerel alhayntem Egypt-angkwarr. Atha alerikw awey arrwekeleny-rnem-then atnwenth irrwey arrwekeleny-rnem-then ingkerrenh atwem Egypt-itwek. Ayeng INGKART innga, arawerrng rlterrk ilkwakert. Egypt-arenyel-rnemarl ingkart-arrpantey-rnem mpwarek apwert-penh arwerl-penh-then, rernem apenteyel kwenirrerl-anemel ikwer-rnem-warl. Atha renh-rnem ywerrelhilem. ");
INSERT INTO aly_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Arrnga atha arenty arriw-itwek, ayeng anperarl alhem, awey arrekantherrenh arrwekeleny-rnem atha atwey-angenharl. Atha Egypt-areny-rnemant atwem. ");
INSERT INTO aly_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Rlengk-they arrantherr arlta nhenhek iylpangkerl-ayntetyek. Aherrety arrpanenhel alkent lyerteny Abib irrentyel, arlta impenel, arrantherr kwenty atyeng inkwerelhemel arlkwetyek. Aler-rnem-then arrengey-rnem-then artartey-rnem-then arrekantherrenh rernem inkwerelhemel angkayntetyek atyeng-warl intem-antey. ");
INSERT INTO aly_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Arrantherr tyenkerr Anperarl Alhek ‘Passover’ arlkwek-penh, kwenty ingwer arrantherr arlkwayntenherr-arey arlta 7-ek-atwety. Amern ilperr-ilperrant arrantherr arlkwerl-ayntem arlta 7-ek-atwety. Amern pikinpat-akert arlkwey-angenh, arrangkw. Arlta arrwekel ikwerel, pikinpat warl-they inemel iwetyek, arlkwey-angenh. Ingwerentyel amern pikinpat-akert arlkwenty arlta 7-ek-atwety, arrantherr renh irrentenherr-arey intem-antey. Atyenh-wenyarl ra. ");
INSERT INTO aly_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Arlta anyent arrwekel ikwerel-anem arrantherr akarrirretyek, atyeng inkwerelhetyek wenh arlta anyent ingkern 7 ikwerel-then. Arlta atherrel, nthakenh arrantherr warrkirrey-angenh, arrangkw. Warrkant ipmenherr-arey, amernant alhewer ampernemel. ");
INSERT INTO aly_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Arlta 7-ek-atwety alakenh-anyem arrantherr amern tyenkerr arlkwem, itnan ‘Amern Ilperr-ilperr’. Arrantherr amern ilperr-ilperr arlkwem, arrantherr iterl-arerl-ayntetyek, atharl arrenhantherr Egypt-they atnwenheynem. Rlengk-they aler arrekantherrenh-rnem-then arrengey arrekantherrenh-rnem-then artartey-rnem-then rernem iterl-arayntem, iylpelerrey-angenh arrangkwarl. Arrantherr nhenh-angkwarr apenterl-ayntetyek, atha arrernek-angkwarr. Arrantherr intem-antey kwenty arlkwayntetyek. ");
INSERT INTO aly_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Aherrety arrpanenhel alkent arrwekel arrantherr itnewem Abib. Abib ra irrentyel, arrantherr anenherr-arey arlta 14-ek-atwety. Mpwelhenh-arey ingkeny aylpenhentyek. Ikwer-penh amern ilperr-ilperrant arlkwenherr-arey. Amern ilperr-ilperr arlkwenherr-arey arlta 7-ek-atwety. ");
INSERT INTO aly_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","20","Pikinpat iwenherr-arey warl-they, amern ilperr-ilperr arlkwey-alenty. Ingwerentyel amern pikinpat-akert arlkwenty, renh irrentenherr-arey, aleth-antey alpetyek. Arlta 7-penh, ingkeny tyerrelhenh-penh arrantherr alhewer amern pikinpat-akert arlkwetyek. Nhenh atha arrekantherr arrernek, arrantherr Israel-kenhel-rnem angka nhenh apentetyek, ingwerel-rnem arrekantherr-itwek aneyel-rnem-then. Apmer ingwerel apek aney-alpenty, amern ilperr-ilperr arlkwetyek-antey arlta impen ikwerel, angka nhenh apentemel.” Alakenh INGKARTel Moses-then Aaron-then ilek. ");
INSERT INTO aly_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ikwer-penhan Moses-el artwa thwenek, artwamp Israel-kenh-rnem ingwerl-alpetyek. Moses ra angkek ikwer-rnem, “Anyent ingkerrenhel yep-yep akely anyentarl-anyentarl ineynenh-arey. Atwenherr-arey, aker tyenkerr apmer amentew-ament arrantherr arlkwetyek. ");
INSERT INTO aly_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Yep-yep atwentyel, arrnga tyampit-warl thelenh-arey. Ikwer-penh alperr tyekert arrnga-warl apelyelem. Arriw-warl apernem akern-ampeny irrker-atherr. Arrantherr anenherr-arey warl kwenel-antey ingwepenhek-atwety. Aketh-warl tyerrelhey-angenh. ");
INSERT INTO aly_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ingwel rlengk INGKART ampererrerl-ayntem antyerl atwey-angker-akert. INGKART-then antyerl-then ratherr atwerl-apayntem Egypt-areny-rnem. INGKARTel arrnga arriw-itwek arenty, anper-antey alhem, arrenhantherr atwey-angenh. INGKARTel antyerl atwey-angker artwerelem, arrenhantherr atwekerr.” ");
INSERT INTO aly_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","INGKARTel ilek, “Arrantherr angka nhanyem apentenherr-arey intem-antey. Yep-yep akely arrantherr atwenherr-arey aherrety arrpanenhel, intem-antey. Angka nhenh atha arrernek arrekantherr, aler-rnem-then arrengey-rnem-then artartey-rnem-then, arrantherr apenterl-ayntetyek intem-antey. ");
INSERT INTO aly_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Arrantherr anerl-ayntetyek apmer wethel, atharl arrenhantherr alhelekel, angka nhenh yep-yep-akert apenterl-ayntenherr-arey intem-antey. ");
INSERT INTO aly_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ingwer-inger aler arrekantherrenh alakenh ayernenty, ‘Ilekekarl aker tyenkerr yep-yep anwantherr arlkweyel? Ilekekarl yep-yep anwantherr atweyelan alakenh?’ ");
INSERT INTO aly_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Rernem alakenh-anyem ayernenty, arrantherr alakenh arraty-antey iletyek, ‘Aker tyenkerr anwantherr arlkwem, INGKARTek inkwerelhemel, rarl anwenhantherr Egypt-they atnwenhey-alpek apmer nhenh-warl. Anwantherr Israel-kenh-rnem Egypt-itwek anenh tyayl-areny-apeny. INGKART alkerel alhek, ra Egypt-areny akngerr atwek, alerikw arrwekeleny-rnem ikwer-rnem-kenh atwek. Rap alkerel anper-antey rwaylpenhek warl-rnem anwekantherrenh-rnem-angkwarr. Ra menty arek anwernenhantherr atwey-angenh. Anwernenhantherr ilwekerr atnyenek.’” Israel-kenhel-rnem awek-penh, rernem ampwethel arrernelhek kwenerremel, INGKARTek inkwerelhemel. ");
INSERT INTO aly_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ikwer-penh rernem apmer-warl-anem alpek. Yep-yep rernem atwek, warl-anem arriw ingkerrenh arrngel aperneynenh, INGKARTel Moses-then Aaron-then ilek-angkwarr-antey. ");
INSERT INTO aly_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ingwa ampepenyel INGKARTel awey arrwekeleny-rnem ipmek atwek ingkerrenh Egypt-areny-rnem-kenh. Pharaoh-kenh awey alerikw arrwekeleny ipmek atwek, awey alerikw arrwekeleny-rnem warrkenh-rnem-kenh-then ipmek atwek ingkerrenh-antey. Pwelek irrwey arrwekeleny-rnem yep-yep-then ingkerrenh-antey ipmek atwek arrpemarl. ");
INSERT INTO aly_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Ingwa ikwerel-antey Pharaoh-then warrkenh ikwerenh-rnem-then ingkerrenh Egypt-areny-rnem-then akemerrek warl ingkerrenh-itwek. Aler awey arrwekeleny ikwer-rnem-kenh ingkerrenh ilwek. Rernem ingkerrenh artnalhelirrek aler ikwer-rnem-kenhek. ");
INSERT INTO aly_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ingwa ikwerel-antey INGKARTel awey alerikw arrwekeleny atwek, pwelek-rnem-then, Pharaoh-el warrkenh thwenek, Moses Aaron-then ingwerl-alpetyek, renh awetyek. Ra ikwer-atherr angkek, “Arrantherr Israel-kenh-rnem alpenherr-arey, anwernenhantherr ipmemel. Anwernekantherr-itwek aney-angenh-anem. Apmer arlpaw-warl alhewer alhenherr-arey, INGKARTek tnakemel inkwerelhetyek. ");
INSERT INTO aly_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Yep-yep-rnem pwelek-rnem-then atnwenheynemel ingkerrenh-antey. Alhenherr-arey ikwer-rnem-akert apmer arlpaw-warl. INGKART-anem ayernenh-atherr, ayenh-then arntarnt-arayntetyek.” Alakenh-anyem Pharaoh-el ilek Moses-atherr Aaron-atherr. ");
INSERT INTO aly_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Egypt-arenyel-rnem Israel-kenh-rnem ilek, “Arrantherr Egypt-itwel anayntem, anwernantherr ingkerrenh-antey ilwenherrem! Anamerl apmer-they alpenherr-arey!” ");
INSERT INTO aly_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Israel-kenh-rnem rernem arrwekel-antey arlengarr amern arletyenp-warl kwaty thelek, amern mpwaretyek. Pikinpat arrerney-angenh-antey. Israel-kenh-rnem anyentarl-anyentarl arlengarr amernenp renh arrernek-anem yakweth-warl. Yakweth amernenp renh arertnek anpeth-warl, akngeyn-ayntetyek. ");
INSERT INTO aly_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","36","Moses-el arrwekel-antey Israel-kenh-rnem ilek, rernem Egypt-areny-rnem ayernetyek thilpek gold-ek-then arnkwernemek-then. INGKARTel arrwekel-antey ilek Egypt-areny-rnem, rernem mwerr-angkwarr anetyek Israel-kenh-rnemek. Egypt-areny-rnemel ampwal-rnem arwa alhewer-anem anthek Israel-kenh-rnemek. ");
INSERT INTO aly_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Israel-kenh-rnem apmer Rameses ikwer-they anperl-alhek, apmer Succoth-warl alhenh. 600,000-pel artwernem ingketyel alperlewenh, arelh-rnem-then ampernem-then. ");
INSERT INTO aly_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Apmer ingwer-areny-rnem alhek arrpemarl, Israel-kenh-rnemel-arleng. Rernem ingkerrenh-antey alhekan. Yep-yep-rnem pwelek-rnem-then nanikwet-rnem-then akngerr atnwenheynek. ");
INSERT INTO aly_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ingwa ampepel-antey rernem aynteyarr-alpek, amern ilperr-ilperr amperneyarr-alpek, pikinpat-weny arrangkw, anamerlarl rernem anpenhew-kety, arlwar rtnelhelenh arrangkwarl. ");
INSERT INTO aly_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Egypt iwerl-alhey-alenty Israel-kenh-rnem arleng-alenty Egypt-itwek anenh, aherrety 430-ek-atwety rernem anenh. ");
INSERT INTO aly_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","INGKART-kenh-rnem ingkerrenh alperlewek arlta ikwerel Egypt-they. ");
INSERT INTO aly_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ingwa ikwerel INGKARTel Israel-kenh-rnem arntarnt-aremel atnwenheynek Egypt-they. Israel-kenhel-rnem ingwa anyent aleth-antey iterl-arem, iylpelerrey-angenh. Rernem ingwa nhenhel atyek-antey arntarnt-arelhetyek aleth-antey. Rernem iterl-arey-areny, INGKARTel arrwekeleny-rnem arntarnt-arek. ");
INSERT INTO aly_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ikwer-penhan INGKARTel ilek Moses-atherr Aaron-atherr, “Angka nhenh atha arrekantherr arraty ilem aker tyenkerrek itnan Anperarl Alhek ‘Passover’, arrantherr mwerr-angkwarr apenterl-ayntetyek, tyenkerr atnyenetyek. Israel-kenhel-rnemant alhewer yep-yep nanikwet-then arlkwem. Apmer ingwer-arenyel-rnem nthakenh alakenh arlkwey-angenh. ");
INSERT INTO aly_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Israel-kenhel apek warrkenh apmer ingwer-areny inem payemeletyek. Kel artwerrenty-penhel warrkenh rap aker tyenkerr alhewer-anem ra arlkwem. Warrkenh ra ampa apek, nthakenh aker tyenkerr arlkwey-angenh, arrangkwarl. ");
INSERT INTO aly_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Alethang apmer ingwer-areny, warrkenh alyeparl warrkirreyel arrekantherr-itwel, nthakenh ra aker renh arlkwey-angenh arrangkw.” ");
INSERT INTO aly_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","INGKARTel ilek, “Arrantherr Israel-kenhel-rnem aker arlkwenty, warl kwen-itwek anayntetyek. Aketh-warl tyerrelhey-angenh, aker arlkwetyek. Aker ngkwern rlweth-akey-angenh. ");
INSERT INTO aly_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Israel-kenh-rnem arrantherr ingkerrenhel arlkwenherr-arey. ");
INSERT INTO aly_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Apmer ingwer-areny ilkelhenty aker tyenkerr renh arlkwetyek, artweweny-antey apek, artwemernt renh mpwaretyek ikwerenh-rnem-then, aker renh arlkwey-alenty. Aker alhewer-anem arlkwetyek ikwer-rnem-itwek. Artweweny ra nthakenh arlkwey-angenh. ");
INSERT INTO aly_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Angka nhenh Israel-kenh-rnemek ikwerel aneyel-rnemek-then. Arrantherr ingkerrenh angka nhenh mwanty apentetyek.” Alakenh-anyem INGKARTel ilek Moses-atherr Aaron-atherr aker tyenkerrek, itnan Anperarl Alhek “Passover”. Ikwer-penhan Moses-atherr Aaron-atherr ratherr alhek, Israel-kenh-rnem iletyek. ");
INSERT INTO aly_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Israel-kenh-rnem INGKARTek awelhenh, rarl renh-rnem ilanthek-angkwarr-antey, tyenkerr arlkwetyek. ");
INSERT INTO aly_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Arlta ikwerelan INGKARTel Israel-kenh-rnem Egypt-they atnwenhek, ingkerrenh-antey. ");
INSERT INTO aly_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","2","INGKART angkek Moses-ek, “Israel-kenh ingkerrenh ila, ‘Artwa arelh-then ratherr awey arrwekeleny INGKARTek anthetyek, warrkirr-ayntetyek ikwer. Pwelek irrwey akely arrwekeleny Israel-kenhel-rnem tyenkerr INGKARTek anthetyek arrpemarl. Yep-yep-then nanikwet-then tangkey-then irrkaty-angkwarr ikwer anthetyek arrpemarl. Arrwekeleny-rnemant INGKART-kenh ingkerrenh, ingwer-rnem mentyarl.’” ");
INSERT INTO aly_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Moses angkek Israel-kenh-rnemek, “Arlta nhenhel arrantherr Egypt-they anperl-alhem. Nhethey-anyem arrantherr iterl-arayntetyek arlta anyent impen nhenh, iylpelerreyang. Arrantherr warrkirrenh tyayl-areny-apeny Egypt-itwek. INGKARTel arrenhantherr atnwenhey-alpek arawerrng rlterrkel. Arlta nhenhelan amern ilperr-ilperrant arrantherr arlkwetyek. Amern pikinpat-akert arlkwey-angenh, mentyarl. ");
INSERT INTO aly_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Alkent nhenh arrantherr itnewem Abib. Arlta nhenhel arrantherr anperl-alhek Egypt-they. ");
INSERT INTO aly_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Awank-akerr INGKARTel ilek Abraham-ek, Isaac-ek-then, Jacob-ek-then, arrwekeleny-rnem arrekantherrenhek, apmer Canaan anthetyek arrekantherr. INGKARTel alhelek ikwer-rnem, ‘Ingwer-inger atha apmer nhenh ingkern-penh-rnemek ngkwenh-rnemek anthem. Lyertan apmerel aneyel Canaan-areny-rnem, Hitt-kenh-rnem, Amor-areny-rnem, Hiv-areny-rnem, Jebus-areny-rnem.’ Angka nhenh arraty innga! INGKARTel arrenhantherr amern-angketyarr-warl atwenheyneyenh. Apmer ikwerel aney-alpentyel, arlta impen anyentel renh atnyenetyek aherrety arrpanenhel, arrantherr iterl-arayntetyek. Arrantherr akarrerr-ayntetyek aherrety arrpanenhel, iylpangkerl-ayntetyek, arrantherrarl Egypt-they alpek. ");
INSERT INTO aly_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Arrantherr akarrerrentyel, amern ilperr-ilperrant arrantherr arlkwetyek arlta 7-ek-atwety. Amern pikinpat-akert arrantherr arlkwey-angenh, mentyarl. Arlta anyent ingkernel 7-el arrantherr kwenty atnyenetyek, INGKARTek inkwerelhemel. ");
INSERT INTO aly_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Nhenhan arraty. Apmer ikwerel, arlta 7-ek-atwety amern pikinpat-akert nthakenh arlkwey-angenh, mentyarl. Pikinpat iwenherr-arey ingkerrenh-antey.” ");
INSERT INTO aly_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Moses-el ilek, “Arrantherrarl tyenkerrek akarrirrenty, arrantherr alerikw-rnemek tyenkerr anayntiletyek, rernem iylpangketyek, ‘INGKARTel anwernenhantherr atnwenhey-alpek Egypt-they. Ran anwernenhantherr arntarnt-arek. Alakenh-anyem anwantherr akarrerrirreyel, ikwer iterretyek, amern ilperr-ilperr arlkwetyek.’ ");
INSERT INTO aly_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Arrantherr INGKARTek iterrerl-ayntetyek, rarl arrenhantherr arntarnt-arenh. Arrantherr angka Akngey-kenh arnkwewarl, iytelarr-warl ingkwernem arrernelhemel iltyewarl, akapwert-warl. Alakenh iylpelerrey-angenh anayntetyek, angka ikwerenhek intem-antey awelherl-ayntetyek, arrantherr iterl-arem, rarl arawerrng rlterrkel arrenhantherr Egypt-they atnwenhey-alpek. ");
INSERT INTO aly_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Atyeng awelhenherr-arey! Aherrety arrpanenhel alkent Abib ikwerel, arrantherr aleth-antey aker tyenkerr-then amern ilperr-ilperr-then arlkwayntetyek.” ");
INSERT INTO aly_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Moses-el ilek, “INGKARTel arrenhantherr apmer ikwer-warl atnwenhem, apmer Canaan-warl. INGKARTel alhelek, ‘Atha apmer arrekantherr anthetyek.’ Apmer irrkaty ra alhelek arrwekeleny-rnemek, ra apmer ikwer-rnem anthetyek. ");
INSERT INTO aly_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Apmer ikwerel aney-alpentyel, angka nhenh-angkwarr apenterl-ayntetyek. Awey arrwekeleny-rnem INGKART-kenh ingkerrenh anem. Pwelek irrwey akely arrwekeleny tyenkerr INGKARTek-anem anthetyek, yep-yep-then tangkey-then. Renh-rnem ipmek atwetyek INGKART-kenh-angkwarr, alakenh renh-rnem anthetyek INGKARTek. Irrwey arrwekeleny-rnemant INGKART-kenh ingkerrenh anem. ");
INSERT INTO aly_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Tangkey irrwey akely arrwekeleny-akert apek, arrantherr arrekantherr atnyen-ayntetyek. Alakenh-anyem mwerr. Tangkey ntwa atnyenentyel, ntwap yep-yeparl atwemel anthetyek INGKARTek. Ikwer-penhan ntwa tangkey yanh ngkwenhant-anem atnyena. Yep-yep atwey-angenhel, tangkey yanh atwa rtemal arternemel INGKARTek, yep-yep mentyarl. Awey arrwekeleny-rnem arrekantherrenh arrantherr INGKART-they angkep payemeletyek.” ... ");
INSERT INTO aly_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Pharaoh-el Israel-kenh-rnem Egypt-they tyarlewek-penh, Akngeyel renh-rnem atnwenhey-angenh iwerr Philistia-angkwarr. Iwerr Egypt-they arraty-antey aynteyneyel Philistia-angkwarr apmer Canaan-warl. Akngey iterrenh, “Atha Israel-kenh-rnem atnwenhenty iwerr Philistia aynteyel-angkwarr, ahelengkwel-rnem renh-rnem ater-anthekerr, renh-rnem atwey-ayntekerr. Rernem angkep alpekerr Egypt-warl. Menty, iwerr ingwer-angkwarr atha atnwenheynem.” Alakenh-anyem Akngey ra iterrek. ");
INSERT INTO aly_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Apmer arlpaw-angkwarr ra atnwenhek amperang-amper kwaty ilkwa ingwer-ampeny-warl, itnan alay Apenng-angketyarr. Israel-kenhel-rnem irrtyart-then alkwert-then atnyenenh, rernem atwerretyek. ");
INSERT INTO aly_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moses-el Joseph arrewaly ngkwern akngeynenh. Awank-akerr Joseph ra ilwey-alenty, ra awayikw-rnemek angkek alakenh-anyem, “Akngeyel arrenhingkerr arntarnt-arem. Ra arrenhingkerr atnwenheyenh Egypt-they. Arringkerr arraty ayenh alheletyek, ayeng ilwenty, arringkerr arrewaly ngkwern ayenh akngeynetyek apmer Canaan-warl, ikwer-itwek akwernetyek.” Kel alakenh-anyem Joseph renh alhelek awayikw-rnemel. ");
INSERT INTO aly_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Israel-kenhel-rnem Egypt iwerl-alhek-penh, rernem apmer Succoth-itwek ayntenh. Ikwer-penhan rernem apmer Etham-warl alpek. Etham arrer-antey apmer arlpaw-itwek. ");
INSERT INTO aly_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","22","INGKARTel ikwer-rnem iylparrernek, nthek-angkwarr rernem alhetyek. INGKART ra arrwekel alhenh, iwerr ikwer-rnem arratyilemel, rernem renh arraty apenteyn-ayntetyek. Arltel ra alhenh kwenpay arlpenty-angkwarr. Ingwelan ra kwenpay arlpenty lherrm-akertel yerlirrenh ikwer-rnemek, rernem apentetyek. Iwerr arratyileynenh, rernem apentetyek apmer ikwer-warl. Renh-rnem alakenh-anyem atnwenheynenh ingwa arrpanenhel arlta arrpanenhel, aleth-antey. Renh-rnem iwerl-alhey-angenh. ");
INSERT INTO aly_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","2","INGKART angkek Moses ikwer-warl, “Ila Israel-kenh-rnem apmer Pi Hahiroth ikwer-warl angkeperretyek. Ila renh-rnem apmer ampepel aynteynetyek, arrerentyel apmer Migdol kwaty alay itnan Apenng-angketyarr-itwek. Ikwer-itwek aney-alpetyek, kwaty alay impalthel. Apmer Baal Zephon alay intwar-ampeny-itwel aneyel. ");
INSERT INTO aly_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Pharaoh ra alakenh-anyem iterrem, ‘Ya nthakenh Israel-kenh-rnem anterrey-angenh aleyan, rernem iterl-areyang, nthek-angkwarr alpetyek wenh. Rernem atyengety anterrey-angenh. Arrangkw aleyan. Atha renh-rnem antwerrkeyenh arrer-antey arlpaw-itwek.’ Alakenh-anyem Pharaoh ingwer-inger iterretyek. ");
INSERT INTO aly_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Atha Pharaoh arwengkilem, ra arrenhantherr alwernetyek. Atha ahelengkw-rnem ingkerrenh ilwerl-athenem atwem. Ikwer-penh arrantherr iterl-aretyek, ayeng rlterrk ilkwa-akert aneyel. Arrantherr ayenh tnaketyek inkwerelhemel. Egypt-areny-rnem rernem iterl-arem-anem arrpemarl, ayeng INGKART ingkerrenhek aneyel.” Alakenh-anyem INGKART angkek Moses-warl. Israel-kenhel-rnem awek, INGKARTarl Moses-warl angkek. Kel rernemap apmer Pi Hahiroth-itwek ayntey-alpek. ");
INSERT INTO aly_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ingwerentyel Pharaoh renh iletyek alhek, “Israel-kenh-rnem anterrek.” Pharaoh-elarl awek-penh, rap atyetyart ampep-rnem-then angkek, “Ilekek anwantherr intwarek wenh, antwerrkey-angenhan? Rernemarl kel anterrekan! Anwantherr renh-rnem antwerrkey-areny! Angwenh-rnem-anem anwekantherr warrkirreyenhan?” ");
INSERT INTO aly_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Pharaoh ra pakey nantewelarl ayteng-akngenh-warl nganerl-alhek. ");
INSERT INTO aly_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Ra ikngwerl-alhek artwa ahelengkw-rnem 600-pel. Rernem alkwert-rnem-then irrtyart-rnem-then inerl-alhek, pakey-rnem-warl nganerl-alhetyek, atwerretyek. Rernem ingkerrenh Pharaoh-angkwarr alhek. Ahelengkw atyetyart-rnem alhek arrpemarl pakey-akert. ");
INSERT INTO aly_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","INGKARTel Pharaoh renh arwengkilek. Pharaoh-el atningk ikwerenh-rnem-akertel Israel-kenh-rnem alwernek, renh-rnem atwetyek-anem. Israel-kenh-rnem rlterrk innga alhenh-antey, alhengkerrirrey-angenh. ");
INSERT INTO aly_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Pharaoh ra ahelengkw ikwerenh-rnem-akert Israel-kenh-rnem arrererrelhek apmer Pi Hahiroth-itwek, kwaty alay itnan Apenng-angketyarr ikwer-itwek. Apmer Baal Zephon intwar-ampeny kwaty alay. ");
INSERT INTO aly_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Israel-kenhel-rnem Egypt-areny-rnem arrer-anem apetyenty arnarek. Rernemap aterirrek, INGKARTek-anem arlkek, ra renh-rnem arntarnt-aretyek ahelengkw-rnem-kety. ");
INSERT INTO aly_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Rernem Moses ayntarrp-ilek, “Ilekarl ntwa anwernenhantherr Egypt-they atnwenhey-alpek? Anwantherr ingkerrenh ilweyenh wenh! Egypt-itwek anwantherr aney-areny, ikwer-itwek anwantherr ilweyek-atwety! ");
INSERT INTO aly_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Anwernantherr ngkweng ilelhek Egypt-itwek, ‘Aney wenh anwernantherr nhel-antey, menty alpey-angenh warrk-anem irremel.’ Alakenh-anyem anwernantherr arrwekel ngkweng ilelhekan! Ntwa anwernenhantherr ilek, anwernantherr ngkweng-angkwarr alhetyekarl! Aleyan anwenhantherr arlpawek ahelengkw-rnemel atweyenh ingkerrenh-antey!” ");
INSERT INTO aly_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moses angkek, “Kel mwerr! Aterirrey-angenh! Rlterrk anenherr-arey! INGKARTek anwantherr nhenhel mpwelhey, rarl anwenhantherr ingkerrenh arntarnt-aremarl. Anwantherr Egypt-areny-rnem arrer-anem arnareyel, nhepenhan anwantherr renh-rnem areyang-anem. ");
INSERT INTO aly_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Arternpant anetyek. INGKARTel Egypt-areny-rnem ingkerrenh atweyenh.” ");
INSERT INTO aly_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ikwer-penh INGKART angkek Moses-warl, “Ilekek ntwa atyeng arlkeyelan wenh? Israel-kenh-rnem ila, kwaty alay Apenng-angketyarr-warl alhetyek. ");
INSERT INTO aly_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Irretety irrwerlela, irrertetyel kwaty-warl alhel-ara. Kwaty amentant-atherr irretyek, ampepan ahern artwerretyarl ayntetyek, arrantherr alhetyek ikwer-angkwarr. ");
INSERT INTO aly_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Atha Egypt-areny-rnem arwengkileyenh. Alakenh rernem arrenhantherr alwernem kwaty-angkwarr. Alakenh-kety atha renh-rnem kwatyek akwernem, rernem arrenhantherr alwernekerr. Atha ingkerrenh ilwerl-athenem, Pharaoh-then ahelengkw-rnem-then pakey-akert-rnem-then nantew-akert-rnem-then. Ikwer-penh arrantherr ayenh iterl-aretyek, ayeng rlterrk ilkwakert aneyel. Arrantherr ayenh tnaketyek inkwerelhemel. ");
INSERT INTO aly_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ikwer-penhan Egypt-arenyel-rnem rernem iterl-arem, ayeng INGKART ingkerrenhek aneyel.” Alakenh angkek INGKART Moses-ek. ");
INSERT INTO aly_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Antyerl Akngey-kenh arrwekel alhayntenh Israel-kenh-rnemek, ra ikwer-rnem yerlirrek, rernem renh apentetyek. Kwenpay arlpenty arrwekel alhenh ikwer-rnemek arrpemarl. Kwenpay antyerl-then ingkernel-anem alpek. Antyerlel renh-rnem arntarnt-arayntetyek Egypt-areny-rnem-kety. ");
INSERT INTO aly_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Kwenpay ampepel-anem irrek, Israel-kenh-rnem-thenek Egypt-areny-rnem-thenek. Ingwerrek-anem. Kwenpay Israel-kenh-rnemekant arrtyernenh-antey. Israel-kenh-rnem lyenentyel arenh-antey ingwel, mwerr alhenh. Kwenpayel artek Egypt-areny-rnem, renh-rnem arey-angenhelek-anem. Atwemengkirrek ikwer-rnem-itwekant. Rernem ingwel Israel-kenh-rnem arrererremel atwekerr, alakenh-kety atwemengkirrek. ");
INSERT INTO aly_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moses-el kwaty renh-anem alhel-arek irrertety ikwerel. INGKARTel alherrp thwenek, akngerrakw-they ingwel aleth pwenh. Kwaty akwerrant-atherr antwerrkenh, ampepel ahern artwerretyarl ayntek. ");
INSERT INTO aly_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Israel-kenh-rnem ahern artwerretyel anperl-alhek kwaty ampepel-antey. Kwaty akwerrant-atherr rtney-alpek apwert-apeny. ");
INSERT INTO aly_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Pharaoh pakey-akert-rnem-then nantew-akert-rnem-then rernem ingkern-they renh-rnem apentek, kwaty ilkwa-angkwarr. ");
INSERT INTO aly_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Atwemengkel-antey ingkeny tyerrelhey-angenh-antey, INGKARTel Egypt-areny-rnem arek kwenpay lherrm-akert-they. Renh-rnem arwengkelek, rernem apatemel ywarn iterrenh. ");
INSERT INTO aly_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Pakey-kenh weyl aylpek ahern rtwel-anem, rernem ywarn ayteng-inenh. Egypt-areny-rnem arlkalhelerrek, “Anwantherr Israel-kenh-rnem menty ipmey-areny renh-rnem! INGKARTel renh-rnem arntarnt-areyel-kety, ikwer-rnem-they atweyel-kety!” ");
INSERT INTO aly_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Israel-kenh-rnem artempel intwar-ampeny-warl irrek, INGKARTel Moses ilek-anem, “Irretety irrwerlela, kwaty-anem alhel-ara ikwerel. Alakenhan kwaty ra angkep-anem anterrey-alpetyek, Egypt-areny-rnem artenhetyek, pakey-rnem-then nantew-areny-rnem-then ingkerrenh-antey. Kwatyel akwernetyek renh-rnem.” Alakenh INGKARTel Moses renh ilek. ");
INSERT INTO aly_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Kel Moses-el kwaty alhel-arek irrertetyel. Ingkeny tyerrelhenh-anem. Ra alhel-arek-penh, kwaty angkep anyenterrenhey-alpek. Egypt-areny-rnem angkeperreynetyek arrkernelhek ywarn-antey. INGKARTel renh-rnem ilwerl-athenek ingkerrenh-antey kwatyel. ");
INSERT INTO aly_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Innga kwaty angkeperrek, kwatyel ahelengkw-rnem-then pakey-akert-rnem-then nantew-areny-rnem-then ingkerrenh akwernenhek. ");
INSERT INTO aly_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Arrwekel-antey Israel-kenh-rnem ahern artwerretyel alperlewenh ampepel-antey. Kwaty akwerrant-atherr rtney-alpek apwert-apeny. Kwaty alay intwar-ampenyel Israel-kenh-rnem iteth-antey ingkerrenh rtney-alhek. ");
INSERT INTO aly_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Alakenh-anyem INGKARTel Israel-kenh-rnem arntarnt-arenh Egypt-areny-rnem-kety. Israel-kenh-rnemel Egypt-areny arrewaly ingkerrenh rernem arek, kwaty impalthelarl ayntenh. ");
INSERT INTO aly_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Rernem iterl-arek, INGKARTelarl renh-rnem arntarnt-arenh arawerrng rlterrkel. Akater-anem rernem rtnenherrenh, angkerrenh-anem, “Innga INGKART ra rlterrk ilkwakert. Anwantherr ingkerrenhel renh iterl-arayntetyek, rarl anwenhantherr arntarnt-arek Egypt-areny-rnem-kety. Anwantherr Moses renh apent-ayntey, INGKARTel innga renh atyetyart arrernek anwekantherr.” ");
INSERT INTO aly_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Moses Israel-kenh-rnem-then arleng-alenty aylelheyel, INGKARTek inkwerelhemel. ... ");
INSERT INTO aly_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Miriam Aaron-kenh angkwerikw anenh, angkakert Akngey-kenh. Ra ampwal rlterrpelheley-angker inek, rntwenh-anem ikwer-akert. Arelh ingwer-rnem ingkerrenh rntwenh arrpemarl ikwerenh-angkwarr. ");
INSERT INTO aly_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriam alakenh aylelhek, “INGKARTek aylelhenherr-arey, rarl anwenhantherr arntarnt-arek Egypt-areny-rnem-kety. Ra nantew-then ahelengkw-then-antey ingkerrenh kwaty-warl iwek.” ");
INSERT INTO aly_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moses-el kwaty alay Apenng-angketyarr ikwer-they renh-rnem atnwenheynek apmer arlpaw ikwer-warl, itnan Shur. Arlta irrpetyek-atwety ingketyel alperlewenh, kwatyek ywarn nthweynenh. Kwaty arey-angenh arrangkw-antey. ");
INSERT INTO aly_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Rernem apmer Marah renh arey-alhek. Kel kwatyan ikwer-itwel nthakenh rernem antywey-angenh. Kwaty arrngeynp, alakenh-anyem rernem apmer Marahan itnewek, alakenh anayntileyel, “Kwaty apmwa”. ");
INSERT INTO aly_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Israel-kenh-rnem Moses-ek tyel-angkenh, “Kwaty mwerr-weny wenh! Arrngeynparl wenh, nthakenh anwantherr antywey-angenhan! Nthenharl kwaty mwerran antywem wenh? Nthenharl wenh?” ");
INSERT INTO aly_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Moses apatemel anenh. Rap INGKARTek arlkek, “Ilay atyeng, nthakenh atha angkethakw-rnem ileman!” INGKARTel arwerl akely ikwer iylparrernek. Moses-el arwerl renh kwaty arrngeynp ikwer-warl iwek. Kwaty ra mwerr-anem irrek, antywetyek-anem. INGKARTel angka rlterrk ingwer-anem renh-rnem anthek, rernem apenterl-ayntetyek, arraty-angkwarr anayntetyek. Renh-rnem arrkernek, rernem mwerr-angkwarr apek apenterl-ayntetyek. ");
INSERT INTO aly_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ra angkek ikwer-rnem, “Ayengan INGKART wenh, Akngey arrekantherrenh. Ayeng atyetyart ilkwa ingkerrenhek. Ayeng apek arrekantherr angkenty, arrantherr atyeng awelhetyek, atyeng antwerr aney-angenh. Atha arrenhantherr ilem, arraty-angkwarr anayntetyek. Arraty-angkwarr anetyek atyeng. Angka atyenh apenterl-ayntetyek arraty-angkwarr. Arrantherr arraty-angkwarr anenty, nthakenh atha arrenhantherr arntety anthey-angenh. Arrantherr mwerr anetyek, arntety-weny. Atha Egypt-areny-rnem arntety anthek. Ayeng INGKART innga, atha arrenhantherr mwerriley-angker.” ");
INSERT INTO aly_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ikwer-penhan Israel-kenh-rnem apmer Elim-warl rernem arey-alhek. Apmer Elim ikwer-itwek kwaty apeynt 12-pel ayntenh, arwerl ilkwernem-then 70-pel. Rernem kwaty apeynt impalthel anenh. ");
INSERT INTO aly_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Israel-kenh-rnem rernem apmer Elim iwerl-alhek, arlpaw-warl alperlewenh, itnan Sin. Arlpaw Elim-they Sinai-they ampepel-angkwarr-antey. Egypt-they rernem alperlewenh-antey, alkent anyentel. ");
INSERT INTO aly_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","3","Arlpaw-itwek amern-weny, arrangkw. Israel-kenh-rnem tyel-angkek-anem Moses-ek-atherr Aaron-ek-atherr ikwer-atherrety. “Ilekek mpwel apmer apmwarl nhenh-warl atnwenhey-alpek! Amern-weny arrangkwarl-anem! Anwantherr ingkerrenh ilweyenh wenh, amern-wenyel! Egypt-itwel amern akngerrarl anwantherr arlkwenh awankan aker-then. Egypt-itwel INGKARTel anwenhantherr ipmek atwenty, mwerrarl! Lyertan anwantherr apmer nhenhelarl ilweyenh amern-weny!” ");
INSERT INTO aly_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","INGKART angkek Moses-warl, “Atha thwenem amern alker-areny arrekantherr, kwaty rntwem-apeny. Arrantherr amern akngerr arlkwem. Arlta arrpanenhel atha thwenem, arrantherr amern arlkwerl-ayntetyek-anem. Amern akely arlta anyentekant inetyek arrekantherr. Arlta arrpanenhel atha arrenhantherr arrkernerl-ayntem, nthakenh arrantherr irrem wenh, atyeng-angkwarr anetyek apek. ");
INSERT INTO aly_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Arlta 6-el Friday arrpanenhelant arrantherr amern akngerr inetyek arlta ingwerel-rnem-apeny-weny. Friday-elant amern akngerr inetyek, ampernetyek. Friday-el Saturday-el arrantherr arlkwetyek, arlta impenel.” ");
INSERT INTO aly_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Moses-atherr Aaron-atherr ilelhek Israel-kenh-rnemek, “Aylern arrenhantherr Egypt-they atnwenhey-angenh, arrangkw. Ingwel rlengk arrantherr iterl-aretyek, INGKARTelant arrenhantherr Egypt-they atnwenhey-alpek. ");
INSERT INTO aly_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","8","Ingwelarreng arrantherr areyenh, INGKARTelarl arrtyerneyenh ingkenyel-apeny, rlterrk ilkwakert. Ra arrekantherr-warl apetyeyenh. Arrantherr aylernek ahelerrek, alakenh-anyem arrantherr INGKART irrwerl-arenyekarl ahelerrek! Ra arrenhantherr awek. Ra aylernenh ilanthek wenh, arrenhantherrenh apmer nhenh-warl atnwenhey-alpetyek. Aylern ikwer awelhenh, aylern warrkirreyel ikwerarl.” Moses angkek ikwer-rnem, “Atyeng awelhenherr-arey! Arlta arrpanenhel atwerrp-atwerrp, INGKARTel aker arrekantherr anthem arlkwerl-ayntetyek. Ingwepenh arrpanenhel ra amern antherl-ayntem arrekantherr, arrantherr arlkwerl-ayntetyek. Arrantherr arlkwayntem wenh aker-then amern-then-anem wenh, angayakw irrey-angenharl.” ");
INSERT INTO aly_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ikwer-penhan Moses angkek Aaron-ek, “Ila renh-rnem, ‘Arrantherrarl aylernenh arlkarewek wenh. INGKARTel arrenhantherr awek. Alakenh-kety arrantherr akarrirretyek INGKART-warl-anem.’” ");
INSERT INTO aly_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Kel Aaron-el renh-rnem akarrelek ingkerrenh-antey. Aaron rarl ikwer-rnem angkenh-antey, rernem kwenpay arlpaw ikwer-angkwarr arleng arenh. Kwenpay ilkwa amparrkenhey-alpenh ikwer-rnem-warl-athek. INGKARTan kwenpayelarl anenh, rlterrk ilkwakert. ");
INSERT INTO aly_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","12","INGKART Moses-warl angkek kwenpay-they, “Atha awek Israel-kenh-rnemelarl mpwelenh arlkarewek. Alakenh-anyem ila renh-rnem, ‘Alakenh INGKART angkek arrekantherr, “Atwerrp-atwerrp atha arrenhantherr akerel wanteyenh. Ingwepenh atha arrenhantherr amern akngerrel wanteyenh. Nthakenh arrantherr angayakw irrey-angenh, amern akngerr-anem wenh. Ikwer-penhan arrantherr iterl-arem, ayengan INGKARTarl, Akngey arrekantherrenh.” ’” ");
INSERT INTO aly_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Arlta irrkaty ikwerel-antey atwerrp-atwerrp, Israel-kenhel-rnem thip atwelkarr akngerr arek, ikwer-rnem-warl alkerel apetyek. Alker-they rernem akngerr arrernelhenh ahern-warl, ahern ingkerrenh arrkngelek. Ingwepenh ingkeny tyerrelhenhey-alhentyel ahern-itwek rernem arek, kwaty aypmerr ahern-itwek. ");
INSERT INTO aly_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ingkeny irrwerlerrekel, ahern artwerretyerrek. Rernemap amernan aperelty-apeny ahern-itwek arek. ");
INSERT INTO aly_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Rernem apatemel ayernerrek, “Ilek nhenhan wenh?” Moses-el renh-rnem tyernek, “Amern nhenhan. INGKART ra thwenek, arrantherr arlkwetyek. ");
INSERT INTO aly_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Alakenh-anyem INGKARTel ayenh ilek, ‘Tyampit-warl amern ineyn-ayntetyek arlta arrpanenhel aleth-antey. Artwek arelhek ampek anyentam-anyent-warl.’” ");
INSERT INTO aly_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","18","Israel-kenh-rnem tyampit-warl inerl-apenh. Ingwerel-rnem akngerr inek, ingwerel-rneman akelyarl inek. Ingwerel-rnem akelyarl inek, rernem mwerr arlkwetyek. Ingkerrenhel amern akngerr-antey inek. ");
INSERT INTO aly_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ikwer-penhan Moses angkek ikwer-rnem, “Lyert-antey ingkerrenh-antey arlkwenherr-arey wenh, ywerrelhiletyek, ingwepenhek atnyeney-angenh.” ");
INSERT INTO aly_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ingwer-rneman Moses-ek awelhey-angenh. Rernem amern ingkerrenh-antey arlkwey-angenh, amern irrtyertel-akwernek ingwepenhek. Amernan tyerr-angketyarr irrek, intengerrek. Moses ikwer-rnem ahelerrek. ");
INSERT INTO aly_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ingwepenh arrpanenhel rernem amern akwetyey-ayntenh, amern arlta anyentekant arwa. Ingkeny tyerrelhenhey-alhenh-apeny, rwenp-anem irremel amern ra irrkngwerrenh-anem, arrangkwirremel-anem. ");
INSERT INTO aly_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Arlta 6-el Friday-el rernem tyampit atherr-warl ineyam-ayntenh. Artwamp atyetyart-rnem Moses-warl apetyek, angketyek ikwer-warl, “Rernem tyampit atherr-warl amern inek.” ");
INSERT INTO aly_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Moses angkek, “Kel mwerr. Alakenh-anyem INGKARTel ilek, ‘Ingwelarreng Saturday-el arlta impenel arrantherr ayenh tnakemel inkwerelhetyek. Arrantherr warrkirrey-angenh anetyek arrangkw, arrantherr anetyek ltyerremel. Lyertan amern ingwer ampernenherr-arey rwel apek, rtamp mpwaretyek. Amern ingwer tyampit-warl kwatyel arrtyenherr-arey apek. Ingwepenhek amern ingwer atnyenenherr-areyarl.’” ");
INSERT INTO aly_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Rernem alakenh amern ampernek ingwepenhek, Moses-elarl ilek-angkwarr-antey. Amern intengerrey-angenh arrangkw, tyerr-weny-anem arrangkw-anem mwerr-anem. ");
INSERT INTO aly_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moses-el ikwer-rnem ilek, “Lyertan arlta impen INGKART-kenh. Anenherr-arey warrkirrey-angenh. Arrantherr amernek nthwey-alhenty, arrantherr arem arrangkwarl. Amern apmwerrkeny renhant arlkwenherr-arey wenh, arrantherrarl apmwerrkel inekant. ");
INSERT INTO aly_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Alakenh-anyem INGKART-kenh angka aynteyelan. Arrantherr Sunday-they Friday-ek-atwetyant amernek nthwetyek, arlta 6-ek-atwety-antey. Saturday-el mentyarl, nthakenh arrantherr amernek ahern-itwek nthwey-angenharl. Arlta ikwerel Saturday impen INGKART-kenh, ltyerrey-angker.” Alakenh Moses-el ilek. ");
INSERT INTO aly_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Arraty innga. Arlta Saturday ikwerel ingwer-rneman ingwepenh amernek nthwetyekarl alhek. Arrangkw-antey rernem nthwenh ywarn-antey. ");
INSERT INTO aly_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","INGKARTel ilek Moses renh, “Ay! Nthakenh arrantherr irreyelan? Atharl arrenhantherr ilek-angkwarr! Atyeng awelhey-angenharl arrantherr, apal nthwenh! ");
INSERT INTO aly_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Atyeng awelhenherr-arey! Atha arrenhantherr ilek, Saturday-el warrkirrey-angenh anetyek, arteny anetyek! Friday-el atha arrenhantherr amern akngerr anthayntem arlta atherrek-atwety arwa. Saturday-el arrantherr anyentel-antey anayntetyek, alhey-angenh.” ");
INSERT INTO aly_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ikwer-penhan rernem Saturday arrpanenhel ltyerremel anenh, warrkirrey-angenh-anem, arrangkw-anem anenh. ");
INSERT INTO aly_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Israel-kenhel-rnem amern renh itnewek mana. Mana aynteyel “Ilek nhenhan?”. Mana amern arlter aperelty-apeny. Mana arrkerneyel ngkwarl antemarn-apeny. ");
INSERT INTO aly_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moses angkek-anem, “INGKARTel ilek, atha amern mana arrernetyek tyampit ilkwewarl, intem-antey atnyenetyek, ampernemel renh arayntetyek aleth-antey. Amern renh arenty, rernem iylpangkerl-ayntetyek, INGKARTelarl arrwekeleny-rnem atnwenhey-alpek Egypt-they, ra amern irrkaty renh anthenh apmer arlpaw-itwek. Ampernem rernem alakenh angkenty, ‘Ay! Amern irrkaty!’” ");
INSERT INTO aly_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Moses-el Aaron ilek, “Tyampit ilkwa ina, amern mana renh ikwer-warl arrerna. Renh arrerna box impen INGKART-kenh-warl, ingkern-penhel-rneman amern renh aleth-antey iterl-arayntetyek.” ");
INSERT INTO aly_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Kel Aaron-el tyampit inek, amern mana arrernek ikwer-warl. Ra tyampit box impen-warl arrernek INGKART-kenh-angkwarr. Israel-kenhel-rnem box aleth-antey atnyenenh amern mana-akert. ");
INSERT INTO aly_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","36","Israel-kenh-rnemel amern mana arlkwenh, aherrety 40-ek-atwety. Apmer arlpaw-itwek rernem ampererrenh ingketyel aleth-antey. Ikwer-penhan rernem apmer Canaan-warl arrer-anem irrek, INGKARTel renh-rnem amern mana anthey-angenh-anem, arrangkw-anem. ");
INSERT INTO aly_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Israel-kenh-rnem anperl-alhek arlpaw itnan Sin-they. Akngerr-inger INGKARTel renh-rnem thwenek apmer ingwer-warl alhetyek, kel rernem alherlewek rarl ilek-angkwarr. Ingwer-inger rernem apmer Rephidim-el ayntenh-anem. Apmer Rephidim-el rernem ayntenh arlpawel kwaty-wenyel, nthakenh rernem antywey-angenh. ");
INSERT INTO aly_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Rernem Moses ikwer ahelerrek, renh ayernek, “Kwaty-wenyarl arrangkwarl! Kwaty anwenhantherr antherl-ayna wenh, anwantherr antywetyek!” Moses ikwer-rnem angkek, “Ilek arrantherr atyeng ahelerreyel? Ilekek arrantherr INGKART arrkerneyelarl? INGKART-angkwarr apek arrantherr apentey-angenh! Arrantherr iterreyel apek, INGKARTel anwenhantherr iwerl-alhenty-arrpantey! Arrantherr iterreyel apek, INGKART rlterrk-weny, nthakenh ra anwenhantherr arntarnt-arey-angenh! Arrantherr alakenh iterrenty, INGKART arrekantherr ahelerrem!” ");
INSERT INTO aly_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Rernem angkethakw-anem irrek, kwaty-wenyel. Rernem Moses-ek aleth-antey tyel-angkerrenh. “Ilekek ntwa anwenhantherr Egypt-they atnwenhey-alpek wenh arlpaw-warlan kwaty-weny-warlan? Ilekekarl ntwa anwenhantherrenh ampernem-then, atnwenth-rnem-then nhenh-warl atnwenhey-alpek, aherrety inngewarl wenh? Anwantherr ingkerrenh ilwenherretyek arlpawel, kwatyek arrangkw-itwek wenh! Ilek-anem anwantherr antyweman?” ");
INSERT INTO aly_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Moses INGKARTek arlkek, “Nthakenh atha nhenh-rnem ileman? Rernem atyeng awelhey-angenh. Rernem apwertel ayenh wekerr, ipmek atwekerr!” ");
INSERT INTO aly_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","INGKART angkek Moses-warl, “Artwa ampwernem ikngwa. Nga-then artwa ampwernem-then arrwekel alhetyek, Israel-kenh-rnem ingkern-they alhetyek. Irretety irrkaty aknga, arrwel ntwa kwaty lher Nile ikwerel atwek. Anamerl-apeny alha! ");
INSERT INTO aly_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Apwert itnan Sinai ikwer-warl alhenherr-arey wenh. Sinai-itwek ntwa apwert ilkwa arey-alhem wenh. Ayeng apwert-itwek rtnem, arrekantherr-itwek arrwekel-ampeny-itwekarl. Apwert renh atwa irrertetyel. Kwaty-anem apwert-they thelelhetyek, arrantherr antywetyek-anem angkethakwel.” Moses INGKARTek awelhenh. Ra alhek, kwaty renh atwek apwert-itwek irrertetyel, artwamp-rnemel renh arenh-antey. Kwaty-anem thelelhek apwert ikwer-they. Rernemap antywek-anem ingkerrenhel-antey. ");
INSERT INTO aly_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Moses-el apmer renh itnewek Massah-anem. Massah aynteyel arrkerneyelarl, Israel-kenhel-rnem INGKART arrkernek. Israel-kenh-rnem kwaty-weny anek, INGKART arrkernek, ayernerremel, “INGKARTang anwekantherr-itwek aneyel-antey? Arrangkw apek. INGKARTelang anwenhantherr arntarnt-areyel-antey? Arrangkw apek wenh.” Moses-el apmer renh ingwer-angkwarr itnewek, itna Meribah. Meribah-an ayntek ilterreyelarl, Israel-kenh-rnem kwaty-they ilterrenharl arlkarewemel. ");
INSERT INTO aly_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Israel-kenh-rnem apmer Rephidim-el anenh, Amalek-areny-rnem akngerr apetyek, renh-rnem atwetyek. ");
INSERT INTO aly_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Moses angkek Joshua-warl, “Ntwa artwa mwerr-rnem rlwanetyek, arrantherr atwerretyek Amalek-areny-rnem-itwek. Ingwelarreng ayeng alhem, apwert irrwerl-itwek rtney-alhetyek-anem. Irretety renh atha akngem, INGKARTelarl ayenh anthek. Atha irrertety ikwerel alhel-arerl-ayntem, arrantherrarl atwerrerl-anem-angkwarr, arrantherr renh-rnem ingkerrenh atwetyek.” ");
INSERT INTO aly_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Joshua Moses ikwer awelhek. Ra artwernem rlwaneynek, Amalek-areny-rnem atwetyek. Moses apwert irrwerl-warl nganek, Aaron-then artwa ingwer-then itnan Hur. ");
INSERT INTO aly_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","12","Moses-el irrertety irrwerlelek akapwert irrwerl-ampeny atnyenek. Rap irrwerl-warl irrertety renh antwerrkek, Israel-kenh-rnemel Amalek-areny-rnem antengelenh-antey. Moses artwamp-anem, akwa-atherr alhengkerr-anem irrek. Ra irrertety renh irrwerl antwerrkey-angenh arrangkw-anem. Akwa alhengkerr-anem kwenerrenh-anem, Amalek-arenyel-rnem Israel-kenh-rnem antengelenh-anem. Aaron-el-atherr Hur-el-atherr ratherr apwert akely arrernek, Moses ra anerl-ayntetyek. Ikwer-penh Aaron-el-atherr Hur-el-atherr akwa-atherr Moses-kenh antwerrkenh irrertety-akert irrwerl-antey, ingwerel-rnem atwerrenh-angkwarr-antey. Aaron-elan akwa arraty-ampeny antwerrkenh, Hur-elan ayleng-ampenyarl antwerrkenh. Ratherr alakenh-anyem akwa-atherr Moses-kenh antwerrkenh, ingkeny aylpenhetyek-atwety. ");
INSERT INTO aly_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Alakenh-anyem Joshua-then irlkenty Israel-kenh-rnem-then rernem Amalek-areny-rnem antengelemel atwek. ");
INSERT INTO aly_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","INGKART angkek Moses-ek, “Angka nhenh atwerrenharl-penh pip-warl ingkwern-aynta, ingwerel-rnem iterl-arayntetyek iylpelerrey-angenh. Angka nhenh Joshua-warl ilerl-ayntetyek, atha Amalek-areny-rnem ingkerrenh altheneyenh. Ingkern-penhel-rneman renh-rnem iterl-arey-angenh, akwerrp.” ");
INSERT INTO aly_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ikwer-penh Moses-el apwert-rnem arrernek, ampwal aker arrtyerneyek-arelh mpwarek INGKARTek. Ra renh itnewek, “INGKARTel Anwenhantherrenh Arntarnt-arayntem Ahelengkw-rnem-kety.” ");
INSERT INTO aly_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Moses angkek-anem, “Atha irrertety alhel-arek irrwerl-warl-athek, INGKART aneyel-warl. INGKARTel aleth-antey atwayntem Amalek-areny-rnem.” ");
INSERT INTO aly_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","4","Arrwekel-antey Moses-el anewikw ikwerenh Zipporah alerikw-atherr-anem thwenek malyeyikw-warl Jethro-warl apmer Midian-warl. Moses-el alerikw ilkwa itnewek Gershom, alakenh anayntileyel, “Ayeng alethang apmer ingwer-areny.” Moses-el alerikw ingweran itnewek Eliezer, alakenh anayntileyel, “INGKART akngey atyenh-kenhel ayenh arntarnt-arenh, ayenh iteth-antey atnyenek, Egypt-areny ahelengkw-kety!” Jethro Moses-kenh malyeyikw artwa ingkart arrpemarl anenh Midian-areny-rnemek. Ra angka ilek-ilek awek, Akngeyelarl arntarnt-arek Moses Israel-kenh-rnem-then, INGKARTelarl Israel-kenh-rnem atnwenhey-alpek Egypt-they. ");
INSERT INTO aly_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","6","Ikwer-penh Jethro-then anewikw Moses-kenh-then alerikw-atherr-then apetyek, Moses aretyek arlpaw-itwek. Moses anenh apwert Akngey-kenh Sinai-itwek apwert aknganenty-itwek. Jethro-el artwa angkakert thwenek Moses-warl, “Jethro malyey ngkwenh ra apetyeyel ngkweng-warl alerengkw ngkwenh-atherr-then anewengkw ngkwenh-then.” ");
INSERT INTO aly_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moses malyey ikwerenh-warl arnekerrek. Rap ikwer kwenerrek, renh arrwantyemel-anem. Ratherr angkerrek, “Mwerrang nga?” Rernem kalikw-warl aylpenhek-anem. ");
INSERT INTO aly_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moses-el Jethro ilek, “INGKARTelarl anwernenhantherr arntarnt-arenh ahelengkw Egypt-areny-rnem-kety. Ra anwernenhantherr arntarnt-arenh apmwangketyarr-angkwarr. Ra anwernenhantherr Egypt-they atnwenhek apwert nhenh-warl.” ");
INSERT INTO aly_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jethro-el inkwerelhemel awek, INGKARTel renh-rnem arntarnt-arenh Egypt-areny-rnem-kety. ");
INSERT INTO aly_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Rap angkek, “Inkwerelhenherr-arey INGKARTek, rarl arrenhantherr arntarnt-arek Pharaoh-kety, ahelengkw Egypt-areny-rnem-kety. ");
INSERT INTO aly_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Aleyan atha iterl-areyel, INGKART rlterrk innga, INGKART-arrpantey ingwer-rnem arrangkwarl. INGKARTel Egypt-areny-rnem atwek, rernemarl Israel-kenh-rnemek irrpelthirrenh, tnakelhemel.” ");
INSERT INTO aly_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Jethro-el aker pwelek aker ingwer-rnem-then akngek Moses-warl-anem. Moses-el aker tyenkerr arrtyemel anthek Akngeyek. Aaron-then artwamp Israel-kenh-rnem-then Jethro-itwek akarrirrek. Rernem amern tyenkerr arlkwek, Akngeyek inkwerelhemel. ");
INSERT INTO aly_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ingwepenh akngerr ingwer-rnem apetyek Moses-warl, ikwer-itwek rtnenherrenh atwerrpek-atwety. Rernem renh ayernenh, angka arratyiletyek ikwer-rnem. ");
INSERT INTO aly_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Jethro-el arek, Moses rarl alakenh angka arratyilenh. Ra angkek, “Nthakenh nga irreyelan? Ilekek ntwa angka arratyileyel amentelan, aleth-antey ngenh ayernem, ingwepenh-they atwerrpek-atwety ingkerrenhel?” ");
INSERT INTO aly_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","16","Moses-el renh ilek, “Artwa ingwer atherr ilterrenty-penh, ratherr atyeng-warl apetyem, ayenh ayern-ayntetyek-anem. Ratherr akaltyirretyek Akngey-kenh-angkwarr. Atha renh-atherr ilem, ‘Artwa nhanyem arraty aneyel. Artwa ingwer arraty-weny.’ Atha angka arratyilem ikwer-atherr, Akngey-kenh angka anayntilemel. Alakenh-anyem akngerr atyeng-warl apetyem, ayern-ayntetyek.” ");
INSERT INTO aly_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","18","Jethro-el Moses ilek, “Nhayman warrk ilkwa ngkweng, ngarl ament warrkirreyel-angkwarr. Nga alhengkerr anem wenh arlkarewelheyel, ingwer-rnem arlkarewelheyel arrpemarl, ngenh ayerneyel intem-antey, alhengkerr antheyel. ");
INSERT INTO aly_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","20","Awelha atyeng! Atha angka mwerr ngkweng iletyek. Ntwa Akngey ayernetyek ingkerrenhek-antey. Ntwa akalty-antherl-ayntetyek angka Akngey-kenh, iylparrernetyek renh-rnem arraty-angkwarr anetyek wenh. Nga apek atyeng awelhenty, Akngey ngkweng-itwek anayntetyek. ");
INSERT INTO aly_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Artwa mwerr-rnemant rlwana, artwa mwerr Akngeyek awelhem-rnemant. Rernem irrtywerrey-angenh man inetyek, arrangkw. Rernem arraty innga-rnemant ankety-weny. Renh-rnem atyetyart arrerna ingkerrenhek, rernem ingwer-rnem arntarnt-arayntetyek, arlwarey 10-ek apek, 50-ek apek, 100-ek apek, 1000-ek apek. ");
INSERT INTO aly_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Artwa atherr ilterrenty-penh, ratherr atyetyart renh-tangkwel ayern-ayntetyek. Atyetyartel renh-atherr arternpelenty, kel mwerr. Arrangkw apek, ratherr ilterrenty-antey, kel ratherr atyetyart ilkwewarl alhetyek, ayern-ayntetyek. Atyetyartel renh-atherr arternpelenty, kel mwerr. Alakenh atyetyart ingwer-rnem-angkwarr-tangkwel ratherr arratyilerrem, ngenh arlkarewey-angenh anayntetyek. Arrangkwelan, kel ratherr ngkweng-warl alhetyek, ngenhant ayern-ayntetyek, renh-atherr arratyiletyek. ");
INSERT INTO aly_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ntwa alakenh mpwarenty, Akngeyel ngenh ilenty, ngan mwerr-anem anem alhengkerrerrey-angenh, Israel-kenh-rnem inkwerelhem-anemarl, mwerrant-arey anetyek.” Alakenh Jethro-el Moses ilek. ");
INSERT INTO aly_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moses malyeyikw ikwerenhek awelhek, alakenh mpwarek rarl renh ilek-angkwarr-antey. ");
INSERT INTO aly_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Ra rlwanek artwa mwerr-rnem, atyetyart ikwer-rnem rnkernek, atyetyart anetyek arlwarey artwa 10-ek apek, 50-ek apek, 100-ek apek, 1000-ek apek. ");
INSERT INTO aly_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Rernem aleth-antey angka arratyilenh ikwer-rnem. Angka awerr ayntenty, rernem Moses-warl alhenh, angka arratyiletyek. ");
INSERT INTO aly_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Moses-el malyeyikw ikwerenh ilek, apmer ikwerenh-warl alpetyek. Rap apmer Midian-warl-anem alpek. ");
INSERT INTO aly_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Israel-kenh-rnem Egypt renh iwerl-alhek-penh, rernem alkent atherrel aleth alhek. Ingwer-ingeran rernem aremerrey-alhek arlpaw-itwek itnan Sinai. Ampep-itwek rernem ayntek apmer Rephidim-itwek. Ikwer-penhan rernem apwert Sinai ikwer-itwek aynteyarr-alpek, apwert impalthel. ");
INSERT INTO aly_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","7","Moses apwert ikwer-warl nganenhek, Akngey awetyek. INGKART apwert irrwerl-they Moses-ek arlkek, “Alakenh-anyem nga angketyek Israel-kenh-rnemek Jacob-kenh-rnemek.” Ra angka Moses-ek ilek. Kel Moses apwert-they atwarrenhey-alpek. Ra artwamp-rnem akarrelek, rernem angkerretyek. Ra ikwer-rnem ilek, “Alakenh INGKART arrekantherr angkeyel, ‘Arrantherr INGKART ayenh arek, atha Egypt-areny-rnem atwek. Arrantherr iterl-areyel, atha arrenhantherr Egypt-they atnwenhey-alpek. Atha arrenhantherr mwerr-angkwarr atnwenhey-alpek apwert nhenh-warl atyeng-warl. Atha arrenhantherr arntarnt-arenh, irretyelarl akwerrk ikwerenh arntarnt-arem-apeny. Alakenhaym atha arrenhantherrenh arntarnt-arenh. Mwerranty atyeng awelhenherr-arey, angka atyenh-rnem mwerr-angkwarr apentemel. Ingkerrenh apmer arrpanenhel aneyel-rnem, atyenh ingkerrenh. Arrantherr Israel-kenh-rnem atyeng awelhenty, atha arrenhantherrenh ayerrpelem, arrantherr atyenh ingkerrenh anem impen mwerr-rnemarl. Arrantherr atyengant awelh-ayntetyek apenterl-ayntetyek. Arrantherr ingkerrenh ingkart-rnem anetyek, atyengant warrkirr-ayntetyek intem-antey. Israel-kenh-rnem arrantherr ingkerrenh atyeng-angkwarr mwerr-angkwarr anayntetyek!’” ");
INSERT INTO aly_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Artwamp-rnemel Israel-kenh-rnem angka INGKART-kenh ilek. Rernem apey-alpek, Moses-warl angkek-anem, “Kel mwerr. INGKARTel ilek-angkwarr, anwantherr ikwerant awelhem. Anwantherr anemarl, ikwerant warrkirrem.” Moses ra angkep apwert-warl nganek, INGKART-warl angkek, “Israel-kenh-rnem alakenh angkek, ‘Anwantherr ngkwengant warrkirretyek.’” ");
INSERT INTO aly_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","INGKART angkek Moses-warl, “Ayeng ngkweng-warl apetyeyenh kwenpay irrpwerl-angkwarr, ayeng ngkweng angketyek. Ingwer-rnemelan awenty-penhan, rernem ngenh iterl-arem-anem ngarl atyenh angkakert, rernem ngkwengant awelh-ayntem intem-antey.” ");
INSERT INTO aly_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","13","INGKART angkek ikwer-warl, “Israel-kenh-rnem-warl alha, angka atyenh iletyek.” Kel Moses atwarrenhey-alpek apwert-they Israel-kenh-rnem-warl. Ra renh-rnem ilek, “Alakenh INGKARTel arrekantherr ileyel, ‘Arrantherr ingwa atherrel atyeng mpwelhetyek, ayenh aretyek. Pwerlpirretyek. Arnkwa lhewetyek. Ingwa atherr-penh ayeng apetyeyenh irrwerl-they apwert Sinai ikwer-warl. Ingkerrenhel ayenh areyenh, ayengarl irrwerl-they apwert-warl apetyeyenh. Arrer-warl alhewer alhey-angenh, apwert aknganenty ikwer-warl, arleng-antey rtnetyek. Ingwerenty apwert ikwerel rtnenty, renh ipmek atwemarl. Arrewaly arney-angenh, arrantherrap renh apwertel wetyek, irrtyartel apek atanthetyek, pewenarrel apek. Innga, artwa apek apwert aknganentyel rtnenty, atnwenth apek, renh ipmekarl atwemarl. Terampet arrantherr awentyel, arrantherr alhewer nganetyek apwert-warl.’” Alakenh Moses-el Israel-kenh-rnem ilek. ");
INSERT INTO aly_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Angka awek-penh Israel-kenh-rnem pwerlpirrek. Rernem arnkwa lhewek, arnkwa mwerr-angker-warl aylpemel. Rernem arraty mpwelhenh, INGKART aretyekant-anem. ");
INSERT INTO aly_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Moses ikwer-rnem angkek, “Arrantherr ikwer mwanty iterretyek. Artwernemay, anew arrekantherrenh-itwek ingwa atherrel ayntey-angenh mentyarl. Arnkentyel-tangkwel ayntenherr-arey. Arelh-rnemay, ament-tangkwel amperrel ayntenherr-arey.” Alakenh angkek Moses Israel-kenh-rnemek. Ingwa atherrel rernem mpwelhek. ");
INSERT INTO aly_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ingwepenh rernem awely-awely arek, artewentyel innga awek. Kwenpay irrpwerlel apwert renh artek-anem. Terampet angkelh-angkelhelerl-anenty awek rernem. Ingkerrenh aterirrek-anem. ");
INSERT INTO aly_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Moses-el renh-rnem apmer-they atnwenhenh, rernem anyenterremel Akngeyek-anem mpwelhetyek. Rernem rtnenherrey-alhek apwert arrerentyel. ");
INSERT INTO aly_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","INGKART irrwerl-they apetyenh apwert-warl rwakert. Kwertel apwert renh artek. Kwert alker-warl-athek itntenh. Apwert ra akngelhek-anem rlterrk innga. ");
INSERT INTO aly_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Terampet ra arnterram-arnterr angkek. Moses Akngeyek angkek. Moses-el awek kwaty awely-awely angkakert, Akngey artewentyel angkenh ikwer-angkwarr. ");
INSERT INTO aly_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Innga INGKART ra irrwerl-they apetyek apwert irrwerl-warl. Irrwerl-they ra Moses-ek arlkek, “Moses, nganey-alhetyek apwert irrwerl-warl.” Kel Moses nganenhek apwert irrwerl-warl. ");
INSERT INTO aly_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","INGKART angkek Moses-ek, “Atwarrenhey-alpa, renh-rnem iley-alpa, ‘Arrantherr nthakenh apetyey-angenh apwert-warl, INGKART renh aretyek! Arrantherr alakenh-anyem arenty, arrantherr ilwemarl wenh!’ ");
INSERT INTO aly_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Atyetyart-rnem ilenherr-arey arrpemarl, ‘Arrantherr pwerlpirretyek, arnkwa lheweyek, INGKART ikwer arraty mpwelhem-anem, ra arrenhantherr atwekerr.’” ");
INSERT INTO aly_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moses angkek INGKARTek, “Kel mwerr. Arraty inngarl yanhan. Ingwer-rnem apwert nhenh-warl nthakenh nganey-angenh. Ntwarl arrwekel-antey anwenhantherr ilek, ‘Apwert aknganenty nhenh arrer-warl alhey-angenh anetyek.’” ");
INSERT INTO aly_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","INGKART angkek Moses-warl, “Apwert-they atwarreyna, Aaron ingwerl-alpa apwert nhenh-warl. Ingwer-rnem atyetyart-rnem-then ila, ‘Arrantherr yanhel-antey mpwelhetyek, apwert nhenh-warl apetyey-angenharl, mentyarl. Arrantherr arrer apetyenty, INGKARTel arrenhantherrenh atwemarl. Arleng-antey anew-anenherr-arey.’” ");
INSERT INTO aly_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Kel Moses atwarrerl-alpek, Israel-kenh-rnem iletyek, INGKARTarl angkek-angkwarr. ");
INSERT INTO aly_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Akngey angkenh Israel-kenh-rnemek alakenh-anyem, ");
INSERT INTO aly_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ayengan Akngey arrekantherrenh, itnan INGKARTarl. Atharl arrenhantherrenh Egypt-they atnwenhey-alpek, Egypt-arenyel-rnemarl arrenhantherrenh warrk ilkwa anthenh-kety, arrantherr tyayl-areny-apeny warrkirrenh. ");
INSERT INTO aly_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Ayengan Akngey arrekantherrenh anem. Arrantherr altyerr-arrpantey ingwer-rnem apentey-angenh anetyek. Atyengant arrantherr inkwerelhetyek. ");
INSERT INTO aly_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","5","Akngey-arrpantey ingwer-rnemel mpwarem apwert-penh arwerl-penh. Rernem altyerr-arrpantey mpwarem irrwerl-areny-apeny apek ahern-areny-apeny apek kwaty-areny-apeny apek. Rernem ikwer-rnem kwenerr-ayntetyek inkwerelhemel. Alakenh-anyem rernem apmwel-ayeth mpwarem atyengety. Alakenh-anyem arrantherr mpwarey-angenh! Akngey-arrpantey arrantherr mpwarey-angenh, kwenerrey-angenh ikwer-rnem. Menty ayntetyek! Ayengan Akngey arrekantherrenh anem, itnan INGKARTarl. Atha arrenhantherr antwerrkeman, atyenh-rnem. Arrantherr atyeng arlkarerrenty, altyerr-arrpantey apenterl-anenty, alakenh-they ayeng arrekantherr ahelerrem. Arrantherr apek alakenh atyengety intwemelerrenty, atha aler arrekantherrenh atwem alhewer, arrengey-rnem-then, artartey-rnem-then atwemarl, ingkern-penh-rnem ingkerrenh atwem alhewer. ");
INSERT INTO aly_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ingwer-rnemel angka atyenh apenterl-ayntem, rernem atyeng artewentyel ilkelh-ayntem, ayeng ikwer-rnem ikwer-rnem-kenh-then aleth-antey artewentyel ilkelh-ayntem. Nthakenh atha renh-rnem iwerl-alhey-angenh. ");
INSERT INTO aly_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Itnan atyenh impen. Arrantherr itna atyenh INGKART arwa iley-angenh, arrantherr arraty-angkwarrant itna atyenh iletyek. Arrantherr itna atyenh apmwangkwarr itnewenty, atha arrenhantherr atwem. ");
INSERT INTO aly_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Arrantherr arlta ltyerrey-angker atyenh iterl-ayntetyek. Arlta Saturday anyent impen ikwerel, arrantherr atyengant iterretyek wenh, atyeng iylpelirrey-angenh. ");
INSERT INTO aly_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Arlta 6-ek-atwetyant arrantherr alhewer warrkirr-ayntetyek. ");
INSERT INTO aly_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Arlta 7-el impen ltyerrey-angkerarl, arlta atyenharl. Ayengan Akngey arrekantherrenh, itnan INGKARTarl. Arlta ikwerel warrkirrey-angenh anetyek. Angka nhenh ingkerrenhekarl, aler-rnem arrekantherrenhek-then, warrkenh-rnemek-then, pwelek-rnem arrekantherrenhek-then, alethang-rnemek-then rernemarl aneyel arrekantherr-itwek. ");
INSERT INTO aly_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Awank-akerr atha ingkerrenh arrpmernek arlta 6-ek-atwety. Atha alker-then ahern-then kwaty alay-rnem ingkerrenh-then arrpmernekan. Atha ahernel alheyel-rnem-then alkerel alheyel-rnem-then kwaty-areny-rnem-then atnwenth ingkerrenh arrpmernek. Ikwer-penhan arlta 7 Saturday-elan ayeng ltyerrek-anem warrkirrey-angenh-anem anenh. Alakenh atha arlta anyent impen renh itnewek, arrantherr ltyerrayntetyek. ");
INSERT INTO aly_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Arrantherr akngeyek-then ameyek-then awelhetyek, rernem arrenhantherrenh ilenty. Antwerr alhey-angenh. Arrantherr ikwer-rnem awelhemel iylpareth anetyek, inkwerelhemel. Arrantherr ikwer-rnem awelhenty, arrantherr arleng-alenty anem apmer ikwer-itwek, atharl arrekantherr anthem. ");
INSERT INTO aly_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Arrantherr ingwer-rnem ipmek atwey-angenh anetyek. ");
INSERT INTO aly_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Arrantherr anewikw ingwer-kenh ikngwey-angenh anetyek. ");
INSERT INTO aly_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Arrantherr ingwer-kenh ampwal ilek-ilek irrtyertel iney-angenh anetyek. ");
INSERT INTO aly_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Arrantherr court-itwek ingwerenty irrtywerremel iley-angenh, arrantherr ingwerenty angka arratyant iletyek. ");
INSERT INTO aly_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Arrantherr alharlkwerrey-angenh ingwer-rnemek anetyek. Arrantherr ingwer-kenh apmer-they apek, anewikw-they apek, pwelek-akerr-they, tangkey-akerr-they, warrkenh ikwerenh-they alharlkwerrey-angenh anetyek. Ampwal nhenh-rnem aynteng, ingwer-kenhan aynteyel. Angka rlterrk nhenh-rnem arrantherr aleth-antey apenterl-ayntetyek ipmey-angenh.” ");
INSERT INTO aly_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Israel-kenh-rnem ingkerrenh apwert ikwer-itwek arrerenty rtnenherrenh. Rernem awely-awely awek angkenharl, terampet-anem angkelh-angkelhelenty awek. Kwert-angketyarr rernem apwert-itwek arek. Rernem arek-penhan, rernem aterirrek-anem, arleng-anem rtney-alpek apwert ikwerety. ");
INSERT INTO aly_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Rernem Moses-warl angkek, “Ngant anwekantherr angkey-areny. Akngey apek anwekantherr angkenty, anwantherr ilwekerrarl. Anwantherr ngkwengant awelhem.” ");
INSERT INTO aly_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moses ikwer-rnem angkek, “Aterirrey-angenh! Akngey apwert nhenh-warl apetyek, rarl arrenhantherrenh arrkernetyek, arrantherr renh apek apentetyek. Ra ilkelheyel, arrantherr ikwer iterretyek aleth-antey, apmwangkwarr aney-angenh.” ");
INSERT INTO aly_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Rernem rtnenh apwert ilkwethey arleng-antey. Moses-ant alhek kwenpay ikwer-warl Akngey-warl. ... ");
INSERT INTO aly_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","... Akngey angkek Israel-kenh-rnemek, “Atha antyerl arrekantherr-warl thwenetyek, ra arrekantherr-akert yerlirretyek apmer ikwer-warl, atharl awank-akerr arrekantherr anthek-warl. Ra arrenhantherr arntarnt-arayntetyek ahelengkw-rnem-kety. ");
INSERT INTO aly_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Arrantherr arternpel antyerl ikwer awelhenherr-arey. Ran angkakert atyenh-akert, ament-weny-antey. Arrantherr ikwer irrpeltherrenty, ra arrenhantherr apmwekety arntarnt-arey-angenh. ");
INSERT INTO aly_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Arrantherr arternp ikwer awelhenty, angka atyenh-angkwarr apententy, ahelengkw ingwer-rnem arrekantherr arrkngert angkentyan, kel atha ahelengkw-rnem atwemarl. ");
INSERT INTO aly_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Antyerl atyenh arrwekel yerlirr-ayntem, arrantherr apent-ayntetyek apmer Canaan-warl. Aleyan Amor-areny-rnem, Hitt-kenh-rnem-akerr, Perizz-areny-rnem-akerr, Canaan-areny-rnem-akerr, Hivite-areny-rnem-akerr, Jebus-areny-rnem-akerr rernem anew-aneyel. Atha renh-rnem irrarlkemel ilwerl-atheneyenh. ");
INSERT INTO aly_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Yanh-areny-rnemel mpwarem altyerr-arrpantey-rnem apwert-penh arwerl-penh-then gold-penh-then. Altyerr-arrpantey-rnem ikwer-rnem-kenhek kwenerrey-angenharl anetyek arrantherr, angka ikwer-rnem-kenhek awelhey-angenh anetyek. Altyerr-arrpantey-rnem ikwer-rnem-kenh ingkerrenh ngkweltyeletyek. Apwert arlpenty-rnem ikwer-rnem-kenh ingkerrenh ngkweltyeletyek arrpemarl. ");
INSERT INTO aly_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Arrantherr ayenh apenterl-ayntetyek inkwerelhemel. Ayeng Akngey arrekantherrenh, itnan INGKARTarl. Arrantherr ayenh apententy, atha arrekantherr amern akngerr anthem kwaty-then-antey. Arrantherr arntetyerrey-angenh. ");
INSERT INTO aly_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Arrantherr ingkerrenh arleng-alenty anerl-ayntem. Arelh ingkerrenh mwerr anerl-ayntem, arntetyerrey-angenh. Ampa akely-rnem mwerr anerl-ayntem arntety-weny. Ampa akngerr atha arrenhantherr anthem.” ");
INSERT INTO aly_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","INGKART angkek Israel-kenh-rnemek, “Arrantherr Canaan-warl alhentyel, arrantherr tawen arrpanenh-warl alhey-alenty, atha tawen-areny-rnem ater-antheyenh. Rernem ingkerrenh anterreyenh arrekantherrety. ");
INSERT INTO aly_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Atha ingwer-rnem Hivite-areny-rnem Canaan-areny-rnem-then Hitt-kenh-rnem-then irrenteyenh, arrantherr apmer ikwer-rnem-kenh-warl alhey-alenty. ");
INSERT INTO aly_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Arrantherr Canaan-warl alhey-alenty, atha apek renh-rnem irrentey-angenh aherrety anyentel, menty. Apmer ingkeny, werrk-apeny, atnwenth ateralth-angketyarr, apmer alther. Alakenh atha apmer-areny-rnem Canaan-they irrenterl-ayntem arternpel-antey. ");
INSERT INTO aly_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Atha renh-rnem irrpetyarl-irrpetyarl irrenterl-ayntem wenh, arrantherr akngerrelan apmer renh inemarl, apmer mwerr arntarnt-arayntemel.” ");
INSERT INTO aly_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","INGKART angkek Israel-kenh-rnemek, “Apmer arrekantherrenh Canaan-ampeny kwaty alay Apenng-angketyarr-they altwerl ayerrer ayntayntem. Apmer kwaty alay itna Ilkwarl-they akngerrakw ayntayntem. Apmer arlpaw itna Sinai-they ayerrer ayntayntem. Apmer kwaty lher Euphrates-they antekerr ayntayntem. Apmer Canaan ampepelarl. Atha arrenhantherr rlterrkilem, arrantherr-anem yanh-areny-rnem Canaan-they irrenterl-ayntem. ");
INSERT INTO aly_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ikwer-rnem alakenh angkey-angenh, ‘Anwantherr apmer nhenhel arrekantherr-itwek mwerrant-arey anetyek, atwerrey-angenh anetyek.’ Menty. Alakenh ikwer-rnem angkey-angenh. Apmer nhareny-rnem-kety amenterretyek, altyerr-arrpantey-rnem ikwer-rnem-kenh-kety-then. ");
INSERT INTO aly_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Canaan-el apmer arrekantherrenhel rernem ilkelhem anayntetyek. Menty. Nthakenh rernem aney-angenh, arrangkw. Arrngert angkenherr-arey. Rernem arrenhantherrenh apmwangkwarr ilekerr. Rernem altyerr-arrpantey-rnem apenteyel. Rernem arrenhantherrenh-anem ilanthekerr, arrantherr altyerr-arrpantey-rnem apenterl-ayntetyek. Rernem arrenhantherrenh arrkernekerr, arrantherr apmwangkwarr apenterl-ayntetyek.” ");
INSERT INTO aly_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","INGKARTel Moses ilek apwert irrwerl-they, “Aaron, Nadab-then, Abihu-then artwamp 70-pel Israel-kenh-rnem-then renh-rnem ingwerl-alpa wenh, atyeng-warl apetyetyek. Arrer-apeny apetyey-angenh. Atyengety arleng-antey anetyek kwenerremel. ");
INSERT INTO aly_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Moses, nga anyentant atyeng-warl arrer-apeny apetya. Israel-kenh-rnem ingwer-rnem ilenherr-arey, apwert-warl nganey-angenh anetyek.” ");
INSERT INTO aly_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moses alpek ikwer-rnem-warl, angkakert INGKART-kenh. Rernem ikwer angkek, “Alakenhaym mwerrarl wenh. INGKARTel ngkweng-angkwarr angka ilem, anwantherr awelhemarl.” ");
INSERT INTO aly_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moses-el pip-warl ingkwernek, INGKARTel renh ilek-angkwarr. Ingwepenh ra apwert akely-rnem akarrelek, akerek-arelh mpwarek INGKARTek. Renh rnkernek-anem apwert Sinai arrerenty ikwer-itwek. Apwert arlpenty ingwer-rnem 12 ra rnkerneynek akert-arraty. Apwert-rnem 12-pel ileyel, Israel-kenh-rnem 12-pel amentew-ament rernem iterl-arayntetyek. ");
INSERT INTO aly_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Moses-el artwa akely-rnem thwenek, aker atwetyek. Aker pwelek-rnem rernem apwert-rnem-itwek ampernek. Rernem INGKARTek arrtyemel aker tyenkerr anthek, ikwer inkwerelhemel. Aker ingwer-rnem ingkerrenhel arlkwek, mwerr ingkerr rernem anew-anenh INGKARTek. ");
INSERT INTO aly_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Aker rernem atwek-penh, Moses-el arrnga aker-penh inpek, arlengarr-rnem-warl amentew-ament theleynek. Arrnga ingwer-rneman ra apwert-rnem-warl akerek-arelh-warl theleynek. ");
INSERT INTO aly_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Moses-el pip-anem inek, Akngey-kenh angkernem-akert, ra atayel-antey innga reytemilek, ingkerrenhel Akngey-kenh angka awetyek. Rernem ikwer angkek, “Ilek-ilek INGKART-kenh angka pip nhenh-itwek ayntem, anwantherr ikwer awelhem.” ");
INSERT INTO aly_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Moses-el arlengarr-rnem arrnga-akert inek, ra arrnga ikwerel arlperrty iwek ikwer-rnem-warl, irrpelhelek renh-rnem arrngel INGKART-kenh-angkwarr. Ra ikwer-rnem angkek, “INGKARTel anwenhantherr alhelek, rarl anwenhantherr aleth-antey arntarnt-arayntem. Arrantherr alhelek arrpemarl, arrantherr angka ingkerrenh apenterl-ayntetyek pip nhenh-itwek. Alakenh-they atha arrekantherr-warl arrnga-anem iwek.” ");
INSERT INTO aly_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Moses Aaron-then Aaron-kenh alerikw atherr Nadab-then Abihu-then artwamp 70-pel-then Israel-kenh-rnem rernem apwert irrwerl-warl nganek, Akngey renh awetyek. ");
INSERT INTO aly_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Apwert ikwer-itwek rernem Akngey Israel-kenh-rnem-kenh renh arey-alhek. Ingka Akngey-kenh kweneng-ampeny-itwek iwerr-apeny ayntenhekarl rernem arek, iwerr ra arrtyernek alker-apeny, apwert turquoise-apeny. ");
INSERT INTO aly_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Arraty innga! Artwamp-rnem Israel-kenh-rnem rernem Akngey anngel innga-antey arek! Alhewer rernem arek renh, ranap atwey-angenh-antey renh-rnem mwerr-antey. Ikwer-penh rernem amern arlkwek, kwaty-then antywemel. ");
INSERT INTO aly_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","INGKART angkek Moses-ek, “Atyeng-warl nganenhey-alha. Mpwelha-anem atyeng, atha ngenh apwert ilperr-ilperr atherr anthetyek. Apwert atherr-itwek atha ingkwernek angkernem, ingwer-rnemel reytemilemel akaltyerrerl-ayntetyek.” ");
INSERT INTO aly_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","14","Ikwer-penhan Moses artwamp-rnem-warl angkek, “Arrantherr mpwelhenherr-arey nhenh-itwek. Aaron-atherr Hur-atherr arteny mpwelhayntem arrpemarl, ratherr ament angka arratyiletyek ingwer-rnemek ingkernan, aylanth alhemarl-kety. Joshua-ant atyeng-itwek apetyetyek wenh.” Kwertengerl Moses-kenh itnan Joshua. Moses-el Joshua ikngwek, ratherr atherr-antey apwert-warl nganenhek, apwert Akngey-kenh. Moses-el Joshua ampep-warl arrernenhek-anem, ra apwert irrwerl-warl nganenhek ament-anem. ");
INSERT INTO aly_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Moses apwert-warl nganenhek, kwenpayel apwert ingkerrenh artenhek-anem. ");
INSERT INTO aly_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Innga, INGKART irrwerl-they kwenerrek-anem apwert irrwerl-warl, lyenenty rlterrk ilkwakert arrtyernenh. Kwenpayel apwert renh artek arlta 7-ek-atwety. Arlta ingkernelan INGKART Moses-ek arlkek kwenpay-they. ");
INSERT INTO aly_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Israel-kenh-rnem rwa lherrm-apeny apwert irrwerl-itwek rernem arenh. ");
INSERT INTO aly_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moses anenh apwert ikwer-itwek, kwenpayel apwert artek. Ra anenh apwert-itwek arlta 40-ek-atwety. ... ");
INSERT INTO aly_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","... INGKART Moses-ek angkek, ");
INSERT INTO aly_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Israel-kenh-rnem alakenh ila, ‘Arrantherr angka INGKART-kenh apenterl-ayntetyek Saturday ikwer, arlta impen INGKART-kenh ltyerrey-angker. Saturday arrpanenhel arrantherr ltyerretyek, INGKARTek iterrerl-ayntetyek. Ikwer-penhan arrantherr renh iterl-arayntetyek, rarl arrenhantherr arratyilek. Arrantherr mwerr anerl-ayntem INGKART-kenh-angkwarr. Aler arrekantherrenh-rnem-then, arrengey-rnem-then, artartey-rnem-then rernem iterl-arayntetyek arrpemarl aleth-antey. Alakenh-anyem arrantherr mwerr INGKARTek anerl-ayntetyek intem-antey, INGKART-kenh-anem anem. ");
INSERT INTO aly_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Saturday ament arlta ingwer-apeny-weny, arrangkw. Saturday-an INGKART-kenh arlta impen. Ingwerentyel apek Saturday-el warrkirrem, arrantherr artwa renh ipmek atwetyek. ");
INSERT INTO aly_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Warrkirretyek Sunday-they Friday-ek-atwetyant arlta 6-ek-atwetyant. Alakenhan mwerrarl. Saturday arrpanenhel ltyerrayntetyek warrkirrey-angenh. Arlta Saturday-el arrantherr INGKARTek iterr-ayntetyek inkwerelhemel. Ingwerenty apek Saturday-el warrkirrenty, ipmek-antey renh atwem. ");
INSERT INTO aly_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Saturday arrpanenhel arrantherr ltyerrayntetyek warrkirrey-angenh. Arrantherr INGKARTek iterr-ayntetyek inkwerelhemel, ingkern-penhel-rnem arrpemarl aleth-antey. ");
INSERT INTO aly_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Arrantherr INGKARTek atyeng Saturday arrpanenhel iterrerl-ayntetyek aleth-antey, atha arrenhantherrenh aleth-antey arntarnt-arayntem. Arrantherr iterl-areyel, alker-then ahern-then ingkerrenh atha arrpmernek arlta 6-ek-atwety. Arlta 7-elan ayeng warrkirrey-angenh ipmelhek, arwa-anem anek ltyerremel. Alakenh arrantherr ayenh iterl-arayntetyek intem-antey, ingkern-penh-rnem rernem ayenh iterl-arayntetyek arrpemarl intem-antey.’” ");
INSERT INTO aly_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","INGKART ipmelhek-anem Moses-warl angkenh-penh Sinai apwert-itwek. Akngey ra angka apwert ilperr-ilperr atherr-warl arrwekel-antey ingkwernek iltyel. Ra Moses-ek apwert ilperr-ilperr atherr anthek, angka ikwerenh-akert. ");
INSERT INTO aly_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Moses apwert Sinai-itwek arleng-alenty anenh-antey. Israel-kenh-rnem alhek Aaron-warl, rernem renh ayernek, “Ayteyengkw Moses-alew? Nthakenh ra irrek? Ilek-kety ra apey-alpey-angenh? Artwa rarl anwenhantherr Egypt-they atnwenhek. Ilwek apek ra. Aaron-ay! Ilengem ntwa anwekantherr mpwara arwerl-penh apek, apwert-penh apek, ra altyerr anwekantherr anetyek. Ra ilayntetyek apek, nthenh-angkwarr anwantherr alhetyek.” ");
INSERT INTO aly_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaron angkek ikwer-rnemek, “Iylpek-arelh-rnem gold-penh arelh arrekantherrenh-kenh atyeng anthenherr-arey, aler arrekantherrenh-kenh-then.” ");
INSERT INTO aly_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Rernemap iylpek-arelh-rnem akngetyek, Aaron-ek anthek. ");
INSERT INTO aly_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Aaron-el iylpek-arelh-rnem akngerr arrernek tyampit ilkwewarl. Tyampit ilkwa rwitwek arrernek irrngwerretyek. Ra gold renh-anem ipert pwelek-apeny-warl thelek, pwelek irrwey-arrpantey gold-penh mpwarek. Israel-kenh-rnemel arek-penh, rernem angkerrek, “Israel-kenh-rnemay! Nhenh arenherr-arey! Akngey nhanyemelan anwenhantherrenh Egypt-they atnwenhey-alpek nhenh-warl!” ");
INSERT INTO aly_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aaron-el awek-penh, ra apwert-rnem arrernek amperneyek-arelh, pwelek ikwer-itwek arrwekel-ampenyek. Ra angkek ikwer-rnemek, “Ingwelarreng anwantherr anyenterretyek kwenty arlkwetyek. Anwantherr rntwetyek aylelhemel INGKARTek inkwerelhemel!” ");
INSERT INTO aly_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Arlta ingwerelan Israel-kenh-rnem ingwepenh-antey akemerr-ayntek, rernem pwelek-rnem inek atwemel-anem. Pwelek ingwer-rnem arrangkwirremel ampek, INGKARTek inkwerelhetyek-arrpantey. Pwelek ingwer-rnem rernem irrtnyewek, aker ampernemel arlkwetyek, INGKARTek inkwerelhetyek-arrpantey. Rernem aker arlkwenh, ngkwarl wayn-then antywemel, terangk irrenh. Ikwer-penh rernem arelh-rnem mpweny ingwerl-alhenh, artnewarl anterrenh. ");
INSERT INTO aly_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","INGKART angkek Moses-ek, “Anamerl-antey apwert-they alpa ngkwenh-rnem-warl, ntwarl Egypt-they renh-rnem atnwenhey-alpek. Rernem apmwerrerrek-anem. ");
INSERT INTO aly_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Rernem angka atyenhek awelhey-angenh-anem menty anek, apmwel-areth mpwarek. Rernemap pwelek irrwey gold-penh mpwarek. Aker-anem rernem ampernek, pwelek ikwer anthemel. Rernem ikwer kwenerr-ayntetyek inkwerelhemel. Rernem angkerrek alakenh, ‘Israel-kenh-rnemay! Nhenh arenherr-arey! Akngey nhanyemelan anwenhantherrenh Egypt-they atnwenhey-alpek nhenh-warl!’” ");
INSERT INTO aly_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ikwer-penh INGKART angkek Moses-ek, “Atha weth-rnem iterl-areyel, rernem awerr innga, iylpelant awem. ");
INSERT INTO aly_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ayeng ikwer-rnem ahelerreyel, atha renh-rnem ywerrelhilemel atweyenh. Atyeng arrngert angkey-angenh! Atha anewengkw ngkwenh alerengkw ngkwenh-atherr-then nthakenh ipma atwey-angenh, arrangkw. Ngkwenh-rnem-theyarl akngerram-akngerr irreyenh.” ");
INSERT INTO aly_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Moses-el amperrngerremel ayernek INGKART, “INGKARTay! Ahelerrey-angenh ngkwenh-rnemek. Weth-rnem ntwa atnwenhey-alpek Egypt-they arawerrng rlterrkel. ");
INSERT INTO aly_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ntwa renh-rnem atwenty, Egypt-areny-rnem alakenh ngkweng irrpelthirrekerr, ‘INGKARTel ikwerenh-rnem atnwenhey-alpek Egypt-they apmer arlpaw-warl, renh-rnem ilwerl-athenetyek apwert-itwek!’ Menty, nga ahelerrey-angenh ngkwenh-rnemek, renh-rnem atwey-angenh! ");
INSERT INTO aly_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Abraham-ek-then Isaac-ek-then Jacob-ek-then iterra! Awank-akerr ntwa alhelenh ikwer-rnem angkemel, ‘Ntwa alerengkw-then artartey-rnem-then arrengey-rnem-then akngerr atnyenem. Rernem akngerr innga aneyenh, antyarr alkerel aneyel-apeny. Atha apmer Canaan ikwer-rnem anthem, ikwer-rnem aleth-antey ayntetyek.’ Alakenh-anyem ntwa renh-rnem alhelek.” ");
INSERT INTO aly_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","INGKARTel Moses awek-penh, ra ingwer-angkwarr-anem iterrek. INGKARTel ikwerenh-rnem ywerrelhilemel atwey-angenh. ");
INSERT INTO aly_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ikwer-penhan Moses atwarrerl-alhek apwert-they, ra apwert ilperr-ilperr atherr akngeynek. Apwert ikwer-atherr-itwek INGKARTel arrwekel angka ikwerenh ingkwernek atherr-angkwarr-antey arrwekel-ampeny-then ingkern-ampeny-then. ");
INSERT INTO aly_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Moses-elan apwert atherr mpwarey-angenh arrangkw, Akngeyelant arrwekel-antey apwert atherr mpwarek, ra angka ikwerenh-rnem apwert atherr-itwek ingkwernek. ");
INSERT INTO aly_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Moses apwert-they atwarreynenh-antey, ra Joshua rlwatek ampep-itwek. Rernem apmer arrerirrek-anem. Joshua-el awek, ingkerrenharl arlkenh. Ra angkek Moses-ek, “Awa! Israel-kenh-rnem apek atwerreyel!” ");
INSERT INTO aly_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Moses angkek Joshua-ek, “Arrangkw. Israel-kenh-rnem inkwerelhey-angenh, rernem atwerrenty-penh. Rernem artney-angenh, rernem atwerrenty-penh. Atha renh-rnem aweyelarl, rernem aylelherreyel.” ");
INSERT INTO aly_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Moses arrer-anemirrek ikwer-rnem-warl, ra pwelek irrwey gold-penh arek. Ra ingwer-rnem arek rntwerl-anenty. Ra ikwer-rnem ahelerrek-anem. Ra apwert atherr ahern-warl iwek. Apwert atherr akelhek-anem apwert Sinai impalth-itwek. ");
INSERT INTO aly_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ikwer-penhan ra pwelek gold-penh renh inek. Ra rwewarl iwek, gold kwaty-apeny irrngwerrenhek. Ikwer-penhan ra gold ahern-warl thelek, irrernterretyek. Ikwer-penhan ra gold ngkweltyelek lher-apeny-anem. Gold renh inek, kwaty-warl ra iwemel. Israel-kenh-rnem ra ilek, “Arrantherr kwaty gold ikwer-akert antywetyek.” ");
INSERT INTO aly_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Moses Aaron-warl angkek, “Ilek ntwa weth-rnem akngartewek INGKART-kety pwelek nhenh-warl? Alakenhaym apmwarl! Rernem artewentyel apmwelhelek.” ");
INSERT INTO aly_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron angkek Moses-warl, “Nga atyetyart atyenh. Atyeng ahelerrey-angenh. Ntwa renh-rnem iterl-areyel, rernem apmwangkwarr iterreyel aleth-antey. ");
INSERT INTO aly_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Rernem atyeng angkek alakenh, ‘Ayteyengkw Moses nthakenh irrek? Ilek-kety ra apey-alpey-angenh? Artwa weth ra anwenhantherrenh Egypt-they atnwenhey-alpek. Ilwek apek ra. Aaron-ay! Ilengem ntwa anwekantherr mpwara arwerl-penh apek apwert-penh apek, ra altyerr anwekantherr anetyek. Ra ilayntetyek apek nthenh-angkwarr anwantherr alhetyek.’ ");
INSERT INTO aly_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ayeng Israel-kenh-rnemek angkek, ‘Gold iylpek-arelh-rnem arrekantherrenh-they lhelenherr-arey, ilek-ilek gold-penh-then. Ayenh-anem anthemel.’ Ingkerrenh-antey gold-penh rernem atyeng anthek ampwal ilek-ilek. Gold-rnem atha rwewarl iwek, pwelek irrwey-anem rwethey tyerrelhenhey-ayntek!” ");
INSERT INTO aly_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moses ra renh-rnem arenh, arwengk-apeny arlkenty. Aaron ra renh-rnem iltey-angenh arrangkw. Moses ament angkek, “Ingwerel-rnem atherrelhelekerr, anwekantherr arlkwentey-angenh-rnem.” ");
INSERT INTO aly_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Moses arriw ilkwa-itwek rtney-alhek. Ra ingkerrenhek arlkek, “Ingwer-rnemel apek INGKART apentetyek ilkelhem, atyeng-angkwarr apetyetyek!” Levi-kenh-rneman rernem Moses-itwek rtney-alhek. ");
INSERT INTO aly_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ikwer-penhan Moses Levi-kenh-rnemek angkek, “INGKART Akngey Israel-kenh-rnem-kenh alakenh-anyem ra arrenhantherr ileyel, ‘Artwernem, arrantherr inkwartey inenherr-arey! Apmer-warl alhemel awayengkw-rnem-then ayteyengkw-rnem-then arrantherr iterl-areyel ingwer-rnem-then ingkerrenh ipmek atwetyek.’” ");
INSERT INTO aly_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Levi-kenh-rnem rernem Moses-ek awelhek. Rernem inkwartey-rnem inek, 3,000 innga rernem ipmek atwek. ");
INSERT INTO aly_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moses Levi-kenh-rnemek angkek, “Lyertan INGKART-angkwarr anetyek arrantherr, atyetyart arrantherr anayntetyek, INGKART ikwer warrkirr-ayntetyek. Arrantherr ikwer awelhek, awayengkw-rnem-then ayteyengkw-rnem-then alerengkw-rnem-then ipmek atwek. Alakenh-they INGKART arrekantherr inkwerelhek.” ");
INSERT INTO aly_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Arlta ingwerelan Moses angkek Israel-kenh-rnemek, “Arrantherr apmwangkwarr mpwarek. Lyert atha INGKART ayernem arrekantherr. Ayeng ikwer-warl angkenty, ra arrekantherr ahelerrey-angenh anetyek, apmwa arrekantherrety iwetyek, arrantherr apek ikwerenh-anem arrpemarl anem.” ");
INSERT INTO aly_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Moses alhek INGKART-warl ayernetyek, “Weth-rnemel apmwel-areth mpwarek. Rernem pwelek gold-penh mpwarek, ikwer kwenirr-ayntetyek inkwerelhemel. ");
INSERT INTO aly_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Irrepern-rnem atwey-angenh. Menty rernem anetyek. Renh-rnem angkep atwey-angenh, rernem apmwel-areth mpwarek-penh. Renh-rnem atwey-angenh, ayenhant ntwa atwetyek. Ayenh ntwa katy atwetyek, menty ingwer-rnem aney-akenh. Ayeng ikwer-rnem katy ilwetyek. Itna atyenh ipara pip ilkwa ngkwenh-they, ntwarl itna atyenh ingkwernek ingwer-rnem-then, rernem ngkwenh-rnem intem-antey anetyek.” ");
INSERT INTO aly_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","INGKART Moses-ek angkek, “Ingwer apek apmwangkwarr alhenty, atyeng ilkelhey-angenh, atha itna ikwerenh pip ikwer-they iparem. ");
INSERT INTO aly_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Israel-kenh-rnem-warl alpa, atnwenha renh-rnem apmer atha alhelek-warl, atha ngenh arrwekel-antey ilek-warl. Antyerl atyenh arrekantherr yerlirrem, iwerr arrekantherr iylparrernetyek, apmer ikwer-warl alpetyek. Apmwel-areth aneyel-rnem atha ingwer-inger atwemant-anem.” ");
INSERT INTO aly_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","INGKARTel Israel-kenh-rnem arntety ilkwa anthek, rernem apmwel-areth mpwarek-they. ");
INSERT INTO aly_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","INGKART angkek Moses-warl, “Apmer nhenh iwerl-alhenherr-arey, nga-then ingwer-rnem-then, ntwarl renh-rnem Egypt-they atnwenhek. Alhenherr-arey apmer ikwer-warl, atharl arrwekel-antey alhelek Abraham-ek-rnem-then Isaac-ek-rnem-then Jacob-ek-rnem. ");
INSERT INTO aly_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Atha arrwekel-antey antyerl thwenem arrekantherr-warl yanh-areny-rnem irrentetyek, Canaan-areny-rnem, Amor-areny-rnem-then, Hitt-kenh-rnem-then, Perizz-areny-rnem-then, Hiv-areny-rnem-then, Jebus-areny-rnem-then. ");
INSERT INTO aly_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Alhenherr-arey apmer ikwer-warl, amern-angketyarr-warl arwengalker-angketyarr-warl. Nthakenh ayeng arrekantherr-itwek alhey-angenh, arrantherr awerr-rnemarl wethey, atyeng awelhey-angenh. Ayeng arrekantherr alhenty apmer ikwer-warl, atha ampepel apek arrenhantherr ilwerl-athenekerr.” ");
INSERT INTO aly_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","6","Arrwekel-antey INGKART Moses-ek angkek, “Angka nhenh Israel-kenh-rnem ila.” Kel Moses Israel-kenh-rnemek angkek, “Alakenh INGKARTel arrenhantherr ileyel, ‘Arrantherr awerr innga. Ayeng apek arrekantherr-angkwarr alhenty, atha apek arrenhantherr ilwerl-athenekerr. Ampwal-rnem iylpek-arelh-rnem-then nikeleth-rnem-then akwek-arelh-rnem-then lhelenherr-arey. Alerl ayeng iterrey, nthakenh atha ileman.’” Angka nhenh awek-penh, rernem ampwal-rnem lhelek apwert itna Sinai-itwek. Rernem amperrngerrek, ampwal-rnem angkep arrerneyney-angenh-anemarl. ");
INSERT INTO aly_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moses-el apmelerr kalikw artenh, apmer-they arleng. Kalikw renh itnewek, “Kalikw-itwek INGKART ayernetyek”. Ingwerentyel INGKART ayernetyek, rap alhem kalikw ikwer-warl, apmer-they akwerr-ampeny-warl. ");
INSERT INTO aly_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Moses kalikw-warl alhenhel, rernem arriw-ampeny kalikw akely-rnem-itwek rtney-alhenh. Rernem Moses intwarenh, kalikw-warl aylpenharl. ");
INSERT INTO aly_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Moses kalikw-warl aylpenhel, kwenpay arlpenty apetyek irrwerl-they, arriw-ampeny-itwek artenh. Kwenpay ikwer-they INGKART Moses-warl angkenh. ");
INSERT INTO aly_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Kwenpay renh arenh kalikw arriw-itwek, ingkerrenhel apmelerr kalikw arriw ikwer-rnem-kenh-itwek rtnenh, INGKARTek kwenerretyek. ");
INSERT INTO aly_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","INGKART Moses-warl kalikw-itwek angkenh. Ratherr arerrenhant-atherr angkerremel. Ikwer-penh Moses apmer-warl alpenh. Joshua ra kalikw ikwer-itwek apmelerr arteny anenh alpey-angenh. Joshua Nun-kenh alerikw anenh, ra kwertengerl Moses-kenh anenh. ");
INSERT INTO aly_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Ingwer-inger Moses-el INGKART ayernek, “Ntwa ayenh arrwekel-antey alakenh ilek, ‘Atha ngenh Moses iterl-areyel, ayeng inkwerelheyel ngkweng.’ Ntwa ayenh ilek arrpemarl, ‘Ntwa nhenh-rnem atnwenheynetyek apmer ingwer-warl-anem.’ Kel atha ngenh lyert ayernetyek, ‘Angwenh ntwa thwenem, atyeng-angkwarr ilkwatherr?’ Ntwa ayenh iley-angenh-antey. ");
INSERT INTO aly_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Nga atyeng inkwerelhentyan, ntwa ayenh ngkwenh-angkwarr akalty-antha. Atha ngenh iterl-aretyek. Ayeng ilkelheyel, nga atyeng intem-antey inkwerelh-ayntetyek. Nhenh-rnemek iterra iylpelerrey-angenh-antey. Ntwa renh-rnem ayerrpelek, ngkwenh-rnem anayntetyek.” ");
INSERT INTO aly_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","INGKART angkek Moses-warl, “Ayeng arrekantherr-angkwarr alhem. Arrantherr mwerrant-arey anetyek, ahelengkw-rnem nthakenh arrekantherr atwerrey-angenh.” ");
INSERT INTO aly_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moses ikwer-warl angkek, “Nga anwekantherr yerlirrey-angenh apek, ntwa anwenhantherr apmer ingwer-warl thweney-angenh anetyek. ");
INSERT INTO aly_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Nga anwekantherr yerlirrenty, ingwer-arenyel-rnem iterl-arayntetyek, ngarl anwekantherr inkwerelheyel. Anwantherr ngkwenh-rnemarl impenarl, ingwer-rnem arrangkwarl.” ");
INSERT INTO aly_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","INGKART angkek Moses-ek, “Alakenh mwerr. Nga mwerr innga angkek. Atha ngenh Moses iterl-areyel innga, ayeng ngkweng inkwerelheyel. Alakenh-they ayeng arrekantherr-angkwarr alhem ilkwatherr.” ");
INSERT INTO aly_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Moses angkek INGKART-warl, “Atha ngenh arem, arawerrng rlterrkel lyenenty arrtyernenty.” ");
INSERT INTO aly_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","INGKART angkek ikwer-warl, “Ya. Ayeng ngkweng-angkwarr rwaylpenhem. Ayeng ngkweng aremirrem. Ntwa aretyek, ayengarl mwerr-angker innga. Ayeng ngkweng itna mwerr-angker atyenh-anem ilelhetyek. Itnan atyenh INGKART. Ayeng ilkelhenty atha ingwer-rnemek amperrngirremel arntarnt-arem arrpemarl. ");
INSERT INTO aly_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ayeng ngkweng aremirretyek. Nthakenh ayeng inngerr aremerrey-angenh ngkweng-warl. Ingwerentyel inngerr ayenh arenty, rap ilwemarl. ");
INSERT INTO aly_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ay, apwert nhak aray. Apwert ikwer-itwek rtnerl-alha. ");
INSERT INTO aly_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Atha arrtyerneyenh rlterrk ilkwakert apwert-angkwarr anper-alhentyel. Ayeng anper-alhey-alentyarl, atha ngenh apwert intey-warl ikwer-itwek akwernem, atha ngenh iltyel arteyenh. ");
INSERT INTO aly_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Atha ngenh arteyenh-tangkwel, ikwer-penh altywerilem arrpemarl, ntwap artepant-anem ayenh intwareyenhan.” ");
INSERT INTO aly_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","INGKART angkek Moses-warl, “Apwert ilperr-ilperr atherr akaltha, atharl ingwer weth arrwekel-antey mpwarek-apeny. Apwert ingwer atherr angkakert ntwa iwek, ratherrap akelhek-anem. Atha apwert ilperr-ilperr atherr-warl irrkaty-angkarr ingkwernetyek. ");
INSERT INTO aly_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ingwepenh-antey apwert ilperr-ilperr atherr akngetya apwert itna Sinai-warl. Ayeng ngkweng-warl apwert irrwerl-itwek angketyek. ");
INSERT INTO aly_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ingwerenty akngetyey-angenh, ngant apetya. Ingwer-rnem ila, ‘Apwert nhenh-warl apetyekerr!’ Yep-yep-rnem-then pwelek-rnem-then renh-rnem antwerrketyek, atherrk apwert ilkwa-angkwarr rernem arlkweynekerr.” ");
INSERT INTO aly_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Moses-el apwert ilperr-ilperr atherr akalthek. Ingwepenh ra apwert Sinai-warl nganek apwert ilperr-ilperr atherr-akert. Alakenh INGKARTel renh arrwekel ilek-angkwarr. ");
INSERT INTO aly_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","INGKART kwenpay-angkwarr Sinai apwert-warl apetyek. Ran apetyek, Moses-itwek arrer rtney-alhek. Ra itnewelhek INGKART. ");
INSERT INTO aly_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Moses-warl arrwekel-ampeny-itwek ra anper-alhek. Ra ikwer-warl angkek, “Ayeng INGKART, Akngey innga. Ayeng aleth amperrngerreyel ingkerrenhek, ayeng mwerr innga iterreyel ikwer-rnemek. Rernem apmwel-areth atyeng anem, ayeng anamerl ahelerrey-angenh ikwer-rnemek, arrangkw. Ayeng ikwer-rnem artewentyel ilkelheyel-antey. Atha renh-rnem alhelenty, nthakenh ayeng ingwer-angkwarr iterrey-angenh. Ayeng arraty ikwer-rnem-warl angkem aleth. ");
INSERT INTO aly_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Alakenh-anyem innga. Ayeng mwerr ingkerrenhek aneyel. Rernem apmwel-ayeth atyengety anenty, ikwer-penh rernem atyeng-warl apey-alpenty, atha renh-rnem irrentey-angenh, arrangkw. Menty, atha renh-rnem angkep atwey-angenh. Ayeng ikwer-rnem inkwerelheyel inngey. Ingwer-rnem apek apmwangkwarr aleth anenty, angkeperrey-angenh, atha renh-rnem inngarl atwem, alerikw-rnem-then arrengey-rnem-then artartey-rnem-then ingkerrenh-antey atha aleth-antey irrwampenh-anthemel atwem arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Moses anamerl-antey ahern-itwek kwenerrek, ampwethel arrernelhek, Akngey-warl inkwerelhemel angkek. ");
INSERT INTO aly_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Moses angkek ikwer-warl, “INGKARTay, nga apek atyeng inkwerelhenty, anwekantherr-angkwarr alhayntetyek. Rernem awerr innga, iylpelant awem. Apmwa anwekantherrenh iwa, angkep atwey-angenh. Anwenhantherr intem-antey atnyena, anwantherr ngkwenh-rnem anetyek.” ");
INSERT INTO aly_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","INGKART angkek-anem, “Atha arrenhantherr innga alhelem. Rernem ayenh areyenh, ayengarl ilek-ilek mpwarey-angker arawerrng rlterrk-akert, arrantherr aketh-antey aretyek. Arrwekel ingwer-rnemel arey-angenh alakenh-anyem. Ingwer-rnem arrekantherr-itwek aneyel-rnemel areyenh arrpemarl. ");
INSERT INTO aly_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Arrantherr angka atyenhek awelhetyek, atharl lyert ilem. Atha Amor-areny-rnem, Canaan-areny-rnem-then, Hitt-kenh-rnem, Perizz-areny-rnem, Hiv-areny-rnem, Jebus-areny-rnem-then ingkerrenh irrenteyenh apmer ikwer-they, apmer atharl arrwekel arrekantherr alhelek. ");
INSERT INTO aly_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Arrantherr apmer Canaan-warl alhentyel, mwanty arntarnt-arelhemel anayntetyek yanh-rnem-kety, mwerrant-arey arrantherr aney-angenh ikwer-rnem-itwel, rernem arrenhantherrenh apmwangkwarr-anem akngartewekerr. ");
INSERT INTO aly_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Tyaty-arrpantey-rnem rernem mpwarek. Ampwal akerek-arelh-then apwert impen-rnem-then rernem tyaty kwen-itwek rnkernek, ampwal arlpenty-rnem-then. Rernem altyerr-arrpantey-rnem ilek-ilek apenteyel. Ingkerrenh ngkweltyeletyek atakemel, ampwal akerek-arelh-rnem-then, apwert impen-rnem-then, ampwal arlpenty-rnem-then. ");
INSERT INTO aly_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Ayengan INGKARTarl. Arrantherr altyerr-arrpantey-rnemek kwenirrey-angenh anetyek. Arrantherr atyengant awelh-ayntetyek.” ");
INSERT INTO aly_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","INGKART angkek, “Mwantyel arntarnt-arelhenherr-arey yanh-rnem-kety. Mwerrant-arey arrantherr apmer ikwer-areny-rnem-itwek aney-angenh. Rernem altyerr-arrpantey-rnem apent-ayntem apmwangkwarr. Rernem aker tyenkerr arrtyemel anthem altyerr-arrpantey-rnemek. Arrenhantherr apmwangkwarr angkepilekerr, Menty awenh-arey! ");
INSERT INTO aly_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Artwa aler arrekantherrenh-rnem kwey aleyak ikwer-rnem-kenh-itwek itengerrey-angenh anetyek. Aleyak ikwer-rnem-kenh altyerrek-arrpantey kwenerremel tnaketyek. Rernem artwa aler arrekantherrenh-rnem irrkaty-angkwarr arrpemarl akalty-anthekerr. ");
INSERT INTO aly_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Ingwerel-rnem gold rwel arrtyemel irrngwerretyek, altyerr-arrpantey mpwaremel ikwer-penh. Alakenh mpwarey-angenh arrantherr anetyek. ");
INSERT INTO aly_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Amern ilperr-ilperr-akert arrantherr kwenty arlkwetyek inkwerelhemel, kwenty itna ‘Amern ilperr-ilperr’. Arlta 7-ek-atwety arrantherr amern ilperr-ilperr arlkwetyek pikinpat-weny, atharl ilek-angkwarr-antey. Arrantherr alakenh mpwaretyek alkent Abib ikwerel-antey aherrety arrpanenhel. Arrantherr amern ilperr-ilperr renh kwenty arlkwayntetyek, arrantherr iterretyek Abib ikwerel, Egypt-theyarl anperl-alhekan. ");
INSERT INTO aly_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Awey arrwekeleny-rnem-then atnwenth irrwey arrwekeleny-rnem-then rernem atyenh ingkerrenh. ");
INSERT INTO aly_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Tangkey arrwekeleny ntwa apek iteth atnyenetyek, yep-yep akelyant antha atyeng. Arrangkwel apek, tangkey renh akertemal atwetyek. Arrantherr aler awey arrekantherrenh arrwekeleny-rnem ingkerrenh payemeletyek atyeng-they. Ingwerenty rtnemel angkenty atyeng-warl, ra ayenh aker tyenkerr antheynetyek-tangkwel. ");
INSERT INTO aly_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Arlta 6-ek-atwety warrkirr-ayntetyek, arlta 7-el ltyerretyek warrkirrey-angenh. Ahern angerney-angenh, ntang ineyney-angenh, ikwer-kety ltyerretyek-antey. Menty anetyek arlta ikwerel. ");
INSERT INTO aly_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Aherrety arrpanenhel arrantherr kwenty arlkwayntetyek itna Pentecost ikwerel. Ntang weyt arrwekeleny-penh arrantherr atyeng anthetyek. Ingwer-inger arrantherr kwenty ingwer arlkwayntetyek, ntang weyt ingkern-penh arrantherr atyeng anthetyek. ");
INSERT INTO aly_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Aherrety arrpanenhel irrpety-inger artwernem ingkerrenh rernem akarrirretyek arrwekel-antey atyeng. Ayeng INGKARTarl, Akngey innga Israel-kenh-rnem-kenh. ");
INSERT INTO aly_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Arrantherr aherrety arrpanenhel irrpety-inger atyeng-warl apetyenty, atha Canaan-areny-rnem arrwekel-antey apmer ikwer-they irrentem. Atha arrenhantherrenh apmer akngerr arrpemarl anthem. Nthakenh ingwer-rnemel apmer renh angkep rakeyney-angenh arrekantherr-they. ");
INSERT INTO aly_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Arrantherr aker atyeng anthenty, amern tyenkerr-then. Amern pikinpat-weny ayenh anthetyek. Arrantherr yep-yep renh atwentyel, tyenkerr itna Anperarl Alhek ‘Passover’, aker tyelk arrerney-angenh ingwepenhek-atwety. Arrantherr rwel arrtyetyek ingkerrenh-antey. ");
INSERT INTO aly_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Aherrety arrpanenhel, ntang weyt arrwekelarl lyapek akngetyenherr-arey, kalikw atyenh-warl, amern tyenkerr mwerr-angker ayenh anthetyek. Nanikwet akely apek ampernenty arrantherr, amikw ikwerenh aylpatyel arrtyey-angenh.” ");
INSERT INTO aly_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","INGKART angkek Moses-warl, “Ingkwernetyek angka nhenh. Alakenh atha ngenh alheleyel, Israel-kenh-rnem arrantherr atyenh-rnem intem-antey anayntetyek.” ");
INSERT INTO aly_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moses INGKART-itwek anenh, arlta 40-ek-atwety. Amern arlkwey-angenh kwaty antywey-angenh. Apwert ilperr-ilperr atherr-warl INGKARTel ingkwernek angkernem 10, rernem aleth-antey apenterl-ayntetyek. ");
INSERT INTO aly_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Moses-anem apwert Sinai-they atwarrenhey-alpenh, apwert ilperr-ilperr atherr-akert iltyel akngey-alpenh. Moses inngerr amparrkenh, ra Akngey-itwek angkenh-penh. Ra iterl-arelhey-angenh inngerrarl amparrkenh. ");
INSERT INTO aly_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aaron-then Israel-kenh-rnem-then rernem inngerr Moses arek amparrkenharl. Rernem ikwerety aterirrek. Alakenh-they rernem arrer-warl alhey-angenh ikwer-warl. ");
INSERT INTO aly_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Moses ikwer-rnemek atayel arlkek, “Atyengety aterirrey-angenh! Arrer-warl apetyenherr-arey!” Aaron artwamp-rnem-then arrer-warl ikwer-warl apetyek. Ra ikwer-rnem angkek. ");
INSERT INTO aly_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ikwer-penh ingkerr-anem Moses-warl arrererrenhey-alhek. Ra ikwer-rnem angka ilenh, INGKARTelarl apwert Sinai-itwek renh ilek. ");
INSERT INTO aly_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Moses ikwer-rnem-warl angkek-penh, ra inngerr-anem arnkwa akelyel artelhek. ");
INSERT INTO aly_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Moses ra kalikw-warl aylpenh aleth INGKART-warl ayernetyek. Ra arnkwa akely apmelerr lhelenh, INGKART-warl angkey-alhenty. Ra kalikw iwerl-alhenh, apmer-warl alpenh, ra ingkerrenhek iley-alpenh, INGKARTel ilek-angkwarr. ");
INSERT INTO aly_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Ingkerrenhel renh arey-ayntenh, inngerr Moses amparrkenharl. Ikwer-penh ra inngerr apmelerr artelhenh-anem arnkwa akely ikwerel. ... ");
INSERT INTO aly_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","... Moses-el kalikw impen artek. Ra ampwal impen-rnem ingkerrenh akwernek Akngeyel renh ilek-angkwarr. Moses-el warrk ywerrelhilek-penh, kwenpay INGKART-akert alker-they apetyek, kalikw impen artek. INGKART-kenh lyenentyel kalikw kwen alhernek. ");
INSERT INTO aly_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Kwenpayel iwerr arrngelek, Moses nthakenh kalikw-warl kwen aylpenhey-angenh. ");
INSERT INTO aly_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","37","Kwenpayel kalikw-itwek artenhel-antey, Israel-kenh-rnem apmerel-antey anenh. Kwenpay rarl anperl-alhenh, Israel-kenh-rnemel kwenpay renh apentenh, apmer ingwer-warl-anem. ");
INSERT INTO aly_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Alakenh-anyem innga. Itwernek kwenpayel kalikw artenh. Ingwelan kwenpay amparrkenh rwapenyarl. Israel-kenh-rnem apmer arrpanenh-warl alpenhel, rernem kwenpayan kalikw-itwek arenh. ");
INSERT INTO aly_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Awank-akerr artwa anyent anenh itnan Elimelek. Rap tawen Bethlehem-itwel anenh Judah-ampeny-itwel. Ranap Ephrath-kenh-antey. Anewikw ikwerenh itnan Naomi. Youngfella ikwer-atherrenh itna Mahlon-then Kilion-then. Ingwer-ingweran apmer ra arlenyerrek-anem. Elimelek-rnem angwayak anenh, rernemap Bethlehem iwerl-alhek, apmer ingwer-itwel Moab-itwel aney-alpek-anem. ");
INSERT INTO aly_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Ingwer-ingweran artwamp ahaperrek-anem. Anewikw Naomi ra inpert-anemerrek, youngfella alhamp atherr-itwel anerl-anemel. ");
INSERT INTO aly_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Ratherran arelh atherr-then itengerrek Moab-areny atherr. Mahlon ra arelh Ruth-then itengerrek, Kilion ran arelh Orpah-then itengerrekarl. Rernemap arleng-alenty anenh apmer ikwer-itwel, aherrety 10-ek-atwety apek. ");
INSERT INTO aly_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Ikwer-penhan Naomi ra areperrk-anemerrek, ampikw atherrarl ahaperrek. Rap amperrngerremel-anem anenh, ranap anenh-antey apmer ikwer-itwel. ");
INSERT INTO aly_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Naomi rarl Moab-itwel anenheng-arey, ra awek, INGKARTelarl ikwerenh-rnem arntarnt-arenh apmer Judah-itwel. Kwaty ilkwa rntwey-alhek, amern-rnem lyapelhelek-anem. Ingkerrelan inkwerelhemel amern-rnem akarrelenh. Naomi ra iterrek, Moab iwerl-alhetyek, angkep-antey apmer Judah-itwel aney-alpetyek. Anherrikw ikwerenh-atherran iterrek, ilkwatherr alpetyek. ");
INSERT INTO aly_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Rernemap anperl-alhek, iwerrel-antey alhemel. ");
INSERT INTO aly_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Naomi anherrikw-atherr-warl-anem angkek, “Mpwelan alpetyek, amengkw mpwel-kenh-itwel anayntetyek. INGKARTel mpwelenh arntarnt-aretyek mwerr-angkwarr, mpwelarl ayenh arntarnt-arenh-apeny ampa atyenh-atherr-then. ");
INSERT INTO aly_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Rap anthem anewengk ingwer-atherr-anem, mpwelenh irrngerney-anthetyek.” Kel ra renh-atherr arrwantyek-anem, anperl-alhetyek-athath. Ratherrap artnenh artewentyel, ");
INSERT INTO aly_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","alakenh angkemel, “Mentyaw! Ayla ngkweng-angkwarr alpetyek, ngkwenh-rnem-itwel aney-alpetyek.” ");
INSERT INTO aly_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Naomi ranap angkek ikwer-atherr, “Anherrey-atherray, mpwel angkep alpetyek apmer mpwel-kenh-warl-anem. Ilekek mpwel apenteyel-antey? Nthakenh atha ampa ingwer atherr atnyeney-angenh, mpwel itengerretyek, arrangkw. ");
INSERT INTO aly_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Ya, apmer-warl-anem alpetyek. Ayengan arelhampw-anem, nthakenh itengerrey-angenh-anem. Anherrey-atherray, arwa angkeyel-anem. Ayeng apek lyert ingwel artwitwel intengerrem, ikwer-penh ingwer-ingweran awey atherr-anem atnyenemel. Nthakenh-anem irrem? ");
INSERT INTO aly_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","Mpwelan nthakenh mpwelhey-angenh awey ikwer-atherr arrpemarl, ratherrarl alkenherretyek! Arrangkw wenh, alakenh-weny! Mpwel amperrngerremel anerl-anekerr inpert-antey arleng-alenty. Ya, rlterrk-anem aynteyel mpwelek. Rlterrk innganemarl aynteyel atyeng. INGKARTelan ayenh artewentyel irrwerneyel, amperrngelemel.” ");
INSERT INTO aly_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Rerneman artnek arrpemarl. Orpah ran anherrikw ikwerenh arrwantyek-anem, rap apmer-warl-anem anperl-alhek. Ruth-anap ilkelhey-angenharl, Naomi iwerlelpetyek, rap renh antwerrkenh-antey. ");
INSERT INTO aly_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Naomi-an ikwer angkek, “Nhak araw. Arntengengkw ikwerenh-rnem-warl alpeyel-anem, rap altyerr ikwerenh-rnem-kenh-warl alpeyel. Ngan ilkwatherr alpa.” ");
INSERT INTO aly_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Ruth-elanap tyernek, “Ayenh thweney-angenh ngkweng-kety. Ayenh iley-angenh, ngenh apentey-angenharl. Ayeng ngkweng-angkwarr alpetyek. Ngan apmer ingwer-warl alhem, ayengap alhem arrpemarl. Ngan apmer ingwer-itwel anem, ayengap anem arrpemarl. Ngkwenh-rneman atyenh-rnem-anem aneyel. Athap Akngey apentetyek, ntwarl renh apenteyel-apeny. ");
INSERT INTO aly_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Alakenhaym aylanth iteng anerl-aneyenh, aylanthap apmer ikwer-itwel ilweyenh. Ingwer-ingweran rernem ayenh akwerneyenh apmer ikwer-itwel. Inngarl ayeng angkeyel, INGKARTelarl aweyel-kety. Atha irrtywerremel ileyel apek, menty ra ayenh artewentyel atwetyek. Ayengan ngkweng-itwel anayntetyek ilwentyek-atwety.” ");
INSERT INTO aly_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Naomi ra iterl-arek-anem, inngarlap Ruth iterrek, ikwer-angkwarr alpetyek, rap akeleyt-anemerrek. ");
INSERT INTO aly_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Kel anherrenheng-atherr alhenh-antey Bethlehem-warl. Ratherrarl apmer ikwer-itwel arremerrey-alhek, akngerran apateyelpek-anem. Arelh apmer ikwer-areny-rnemel ayernerrek, “Inngarl Naomi yanhan, anwekantherr-warl apey-alpeyel?” ");
INSERT INTO aly_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Naomi arrer-anem apetyek, rap angkek, “Ayenh Naomi antwey-angenh-anem. Itna Naomi mean-errem 'irrngerney'. Ayenganap inkwerelhey-angenh-anem aneyel. Ayenh Mara-anem antwey. Itna Mara mean-erreyel 'amperrng'. Akngey Atyetyart Ilkwa Ingkerrenhekel ayenh amperrngel-anthek. ");
INSERT INTO aly_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Atharl apmer nhenh iwerl-alhek awank-akerr, atha ilek-ilek atnyenek. Aleyan INGKARTel ayenh arrangkw akngey-alpek. Ilekek ayenh Naomi antweyel? Akngey Atyetyart Ilkwa Ingkerrenhel atnert ayenh apmwelek. Ayengan amperrngerreyel-antey.” ");
INSERT INTO aly_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Kel alakenhaym ra ayntenh. Anherrenheng-atherr Naomi-then Ruth Moab-areny-then ratherr Bethlehem-itwel aney-alpek. Ikwereng-arey apmer ikwer-areny-rnemel amern antywer parley akelp-akemel akarrelenh-anem. ");
INSERT INTO aly_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Artwa anyentan Bethlehem-itwel anenh itnan Boaz. Ranap Naomi-wenh anewikwek Elimelekek apelty anenh, rap ilek-ilek atnyenenh man akngerr-then. ");
INSERT INTO aly_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Ingwer-ingweran Ruth ra angkek Naomi-ek, “Anherreyay, mwerrang ayeng yanh-rnem-warl alhem, rernemarl amern antywer parley akeyel-warl? Ingwerenty apek amperrngerrem atyeng, rap menty atha ntang akwetyetyek ingkern-they.” Naomi-el tyernek, “Mwerr alheyaw!” ");
INSERT INTO aly_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Ruth alhek-anem katen ikwer-warl, warrkenh-rnemelarl amern akenh-warl. Rap warrkenh-rnem apentenh, rernemarl amern-rnem akenh. Ra ntang akarrelenh, warrkenh-rnemelarl iwerl-alhek. Katen artwa Boaz-kenh anenh, Elimelekek apelty-kenh, Ruth-elap iterl-arey-angenh-anem. Rap apal ntang akarrelenh katen ikwerenh-itwel. ");
INSERT INTO aly_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Artwa Boaz ran Bethlehem-they aremerreylpek katen ikwerenh-itwel-anem, rap angkek warrkenh ikwerenh-rnemek apmelerr-angkwarr, “INGKARTel arrenhantherrenh arntarnt-aretyek!” Rerneman tyernek, “INGKARTel ngenh arntarnt-aretyek arrpemarl!” ");
INSERT INTO aly_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Boaz ra atyetyart akelyek angkek, “Arelh yanh ran angwenh-kenh?” ");
INSERT INTO aly_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Atyetyart akelyel tyernek, “Arelh yanh ra Moab-areny, rap ilkwatherr Naomi-itwel apey-alpek. ");
INSERT INTO aly_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Ra ayenh ayernek, ‘Mwerrang atha warrkenh-rnem apentem, ntang akarreletyek, rernemarl iwerl-alhem?’ Kel atha renh menty arek. Ingwepenh-antey ra nhenh-warl apetyek, rap pantey warrkerrenh. Ra alyepant ltyerrenh lywenty-itwel.” ");
INSERT INTO aly_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Boaz ran alhek Ruth-warl, rap angkek, “Arelhay, atyeng awelhetyek. Artewenty iterrey-angenh. Nga nhenh-itwel anemer, ntang akarrelemel katen atyenh-itwel. Katen ingwerentyak-kenh-warl alhey-angenh. Arelh warrkenh atyenh-rnemant ntwa apentetyek. ");
INSERT INTO aly_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Nhak araw, artwa warrkenh-rnemelarl amern antywer parley akeyel-warl, arelh warrkenh-rnemelarl akarreleyel-warl. Mwerr ntwan ingkern-theyarl apentetyek. Atha kel artwa warrkenh-rnem ilek, ‘Arelh renh menty ipmenh-arey!’ Nga angkethakwerrem apek, mwerr antywetyek tyampet yanh-penh. Artwernemel kwaty tyampet-warl aleth intem thelem.” ");
INSERT INTO aly_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Ruth-el awek, rap ahern-warl kwenerrek. Ra angkek Boaz-ek, “Alethang ayengan, apmer ingwer-areny. Ilekek nga atham-athamel atyeng angkeyel?” ");
INSERT INTO aly_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Ra tyernek, “Akngerr ingwer-rnemel ayenh ilenh ngkweng-akert. Ngan inpert-anemerrek, ntwap anherrengkw Naomi arntarnt-arenh arraty-angkwarr. Ntwap aynengkw-then amengkw-then iwerl-alhek apmer ngkwenh-then, ngan apmer ingwer-itwel-anem aney-alpek. Anenhantherrenh ntwa iterl-arey-angenh-tangkwel. ");
INSERT INTO aly_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","INGKARTan inkwerelheyel ngkweng, ntwarl anherrengkw arntarnt-arenh. Ngap apetyek ikwer-warl-athek. Ran Akngey aneyel Israel-kenh-rnemek, rap ngenh-anem arntarnt-arayntetyek.” ");
INSERT INTO aly_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Ruth angkek ikwerek, “Ya, atyetyart. Ngan mwerr atyeng aneyel, ngap mwerr-angkwarr angkeyel atyeng. Ayengan iterreyel, nga alakenh apek anayntem atyeng. Ayengan arelh warrkenh ngkwenh-wenyarl, ntwanap ayenh arntarnt-areyel.” ");
INSERT INTO aly_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Ingkern ampepel rernem akarrerrek, amern arlkwetyek. Boaz angkek Ruth ikwer, “Amern-warl apetyetyek. Nhanyem amern rtamp. Ltyewarl pwerlp arrernemel arlkwetyek.” Kel Ruth ra warrkenh-rnem-itwel arrernelhek, amern arlkwetyek. Boaz-el renh anthek amern ntang ampeng rwepenh. Ruth-el arlkwek atnertengek-atwety. Rap ntang ampeny awakek, ingwer-ingwerant arlkwetyek. ");
INSERT INTO aly_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Ikwer-penhan Ruth rtnerl-alhemel alpek warrk-warl angkep-antey. Boaz ra artwa warrkenh-rnem ilanthek, “Menty arelh yanhel ntang akngerr akwetyetyek ampepel, arrantherrarl antywer parley akarrelek-itwel. Renh iltey-angenh-anem. ");
INSERT INTO aly_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Arrantherr ntang aytnelheletyek akwerr-warl, ra akwetyetyek. Arrngert angkey-angenh.” ");
INSERT INTO aly_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Alakenhaym Ruth-el ntang akwetyenh ingkenyarl aylpenhetyek-atwety. Rap ntang akatwek-anem ilpemel, akngerr innga, arrernemel yakweth ilkwewarl. ");
INSERT INTO aly_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Ra yakweth inek, apmer-warl-anem akngetyemel, anherrikw ikwerenhek lwewarrernetyek. Naomi-elan arek, rarl ntang akngerr akngetyek. Ruth-elap renh anthek amern ntang ampeng rwepenh. ");
INSERT INTO aly_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Naomi-el ayernek, “Nthenh-itwel ntwa ntang akngerr akwetyerl-alpek? Katen angwenh-kenh-itwel nga warrkerrenh? Artwa yanhan atham-atham ngkweng anenh. Athan Akngey ikwer katy ayernem, mwerr ikwer anetyek arrpemarl, renh irrngerney-anthetyek.” Ruth-elan angka ikwer ilek artwakert, katen antywer parley-akertek-artweyarl. Rap angkek, “Artwa katenek-artwey itnan Boaz.” ");
INSERT INTO aly_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Naomi-el apateyelpemel awek, rap angkek, “INGKARTel Boaz renh irrngerney-anthetyek!” INGKART ra aylenhanth iwerl-alhey-angenh, rap aylekanth iterreyel-antey, anew aylekanth-kenh-atherrek-then! Artwa yanh Boaz ra akwerrk anewaty-kenh Elimelek-kenh! Ranap artwa arelh inpert arntarnt-arey-angker anwekantherrenh-angkwarr!” ");
INSERT INTO aly_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Ruth angkek-anem, “Yew-yew, artwel ayenh ilek, warrkenh ikwerenh-rnem-itwel pweyterretyek, ntang akwety-ayntetyek. Ra angkek atyeng arrpemarl, ‘Mwerr ntwa nhenh-itwel akwety-ayntetyek, antywer parley ywerretyek-atwety.’” ");
INSERT INTO aly_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Naomi-el tyernek-anem, “Ya, mwerr ntwa ntang akwety-ayntetyek arelh warrkenh-rnem-itwel Boaz-kenh katen-itwel. Katen ingwerentyak-kenh-itwel artwernemel ngenh apmwangkwarr inekerr.” ");
INSERT INTO aly_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Kel alakenh-anyem Ruth ran arrer-apeny-antey anenh arelh warrkenh Boaz-kenh-rnemek. Ra ntang akwetyenh-antey, rernem antywer parley akemel ipmelhetyek-atwety antywer weyt-then. Ruth rap anenh-antey anherrikw ikwerenh-itwel Naomi-itwel. ");
INSERT INTO aly_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Wik irrpetyap-penhan Naomi angkek Ruth-ek, “Anherreyay, atha artwa ngkweng inetyek, ngenh arntarnt-aretyek. ");
INSERT INTO aly_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Artwa yanh Boaz ra akwerrk anewaty-kenh. Nga warrkerrenh arelh warrkenh ikwerenh-rnem-kenh-itwel. Lyert ingwel ra warrkerrerl-aneyenh apmer aterterr-itwel, rernemarl ntang ilpeyel-itwel. ");
INSERT INTO aly_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Nga pwerlperretyek-tangkwel. Apernelhetyek-anem anter mwerr-angker inteyel-akertel. Ankwa mwerr-angkerel aylpetyek. Lyert ingwel nga alhetyek apmer aterterr yanh-warl, Boaz-kety arlengk-iwelhemel-tangkwel. Mpelhey-tangkwel, ra atnertengerremel anetyek-atwety. ");
INSERT INTO aly_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Mwerranty awelhetyek! Anwekantherrenh-angkwarr alakenh aynteyel! Ntwa renh mwerranty arntarnt-aretyek, ra rtnerl-alhetyek. Renh arntarnt-aretyek, rarl panty ikwerenh arlpimpeletyek, ra ankwayntetyek. Mpelhey-tangkwel, rarl apelp aynteyelek. Ikwer-warl-anem alhey, panty akentewemel ingkety–angkwarr. Nga ankwayntemel arrernelhey ingkety-angkwarrel. Ran alerl atyekerretyek. Ra iterl-areyel, anwekantherrenh-angkwarr alakenh aynteyel. Rap ngenh ilem, nthakenh-anem irrem nga.” ");
INSERT INTO aly_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Ruth-el tyernek, “Yew. Atha mpwarem, ntwarl ayenh ileyel-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Rap apmer aterterr-warl alhek, rernemarl ntang ilpenh-warl. Rap iylpareth mpwarek, anherrikw ikwerenhelarl ilenh-angkwarr. ");
INSERT INTO aly_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Amern arlkwenty-penh Boaz irrngerney-anem awelhenh, rap arrernelhek, rarl ntang mpwer tywenek-itwel. Ruth akater alhek ikwer-warl, rap panty akentewek ingkety–angkwarr. Ra arrernelhemel ayntek ingkety ikwerenh arrerenty-itwel. ");
INSERT INTO aly_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Ampepenyel Boaz arwapeny atyekerrek, rap apateyelpek-anem. Rap angapety-iwelhemel arek, “Pwertay, arelh anyent aynteyel-kety!” ");
INSERT INTO aly_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Ra ayernek, “Angwenh nganay?” Ruth-el tyernek, “Atyetyartay, ayengaw Ruth. Ngan akwerrk Naomi-kenh anewikw-kenh aneyel. Ntwa ayenh arntarnt-aretyek. Ngan artwa arelh inpert arntarnt-arey-angker. Alakenh atha iterl-areyel, ingwer-ingwer nga atyeng-itwel itengerretyek, ayenh arntarnt-aremel.” ");
INSERT INTO aly_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Boaz-el tyernek, “Atha INGKART katy ayernem ngkweng, mwerr anetyek ngkweng inkwerelhemel. Nga athamerrenh anherrengkw ngkwenhek, mwerr-angkwarr arntarnt-aremel. Atyenganap nga inngarl-anem athamerreyel. Ayengan ngkweng-they arrwekel! Youngfella akngerr aneyel, ingwer-rneman man akngerr-akert, ingwer-rneman arrangkwarl. Ntwanap renh-rnem mentyarl arenh, ntwap ayenhan rlwanek! ");
INSERT INTO aly_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Atererrey-angenh. Athan mpwarem, ntwarl ayerneyel-angkwarr. Ingkerrenh nhenh-arenyel iterl-areyel, ngarl arelh mwerr-angker. ");
INSERT INTO aly_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Yew, ayeng akwerrk Naomi-kenh anewikw-kenh aneyel. Ikwer-artwey anyent ngkweng itengerremer. Artwa ingweran apek ngkweng itengerremer ayeng-mernt? Kakey atyenh apek? Remernt apek ngkweng itengerrem, ngenh arntarnt-aremel? ");
INSERT INTO aly_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Nhenh-itwel-tangkwel nga anayntem. Aherlkenhey-alhetyek-athath akwentetyek. Anamerl apmer-warl-anem alpetyek, ingwerentyel arekerr. Ingwepenh ayengan alhem, artwa ikwer angketyek. Ra iterrem apek, ngkweng-itwel itengerretyek, kel mwerr. Arrangkw apek. Kel ayengan inkwerelhemel ngkweng-itwel itengerretyek, ngenh arntarnt-arayntetyek. Alakenh ayeng angkeyel, INGKARTelarl aweyel-kety. Innga wenh atha mpwarem, atharl ileyel-angkwarr. Nhenh-itwel-tangkwel anayntetyek. ");
INSERT INTO aly_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Kel Ruth ra ayntek ingkety Boaz-itwel arrerenty aherlketyek-atwety. Rap akwentek aherlkenhey-alhetyek-athath, ingwerentyel renh alhengk-arekerr. ");
INSERT INTO aly_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Ingwepenh-antey Boaz-an ikwer angkek, “Panty ngkwenh iney-alhetyek, nhenh-itwel arlpimpelemel.” Ruth-el panty arlpimpelek, rarl ilek-angkwarr. Artwel ntang akngerr thelek panty-warl arertnemel. Awerr-kety ra irrwerlelek, Ruth ra ntang artepel aylpwer-akngetyek. Boaz ran tawen-warl-anem alhek. ");
INSERT INTO aly_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Ruth ra alpek apmer-warl-anem anherrikw ikwerenh-warl. Naomi-elan ayernek, “Anherreyay! Nthakenhay?” Ruth-el angka ilenh Boaz-akert, rarl mpwarek. ");
INSERT INTO aly_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Rap angkek, “Nhenh araw, ntang akngerr! Ra atyeng anthek, rap angkek, ‘Ma! Nthakenh itepant-akert alpey-angenh anherrengkw-warl.’” ");
INSERT INTO aly_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Naomi-elan tyernek, “Arternp-tangkwel mpwelhey. Boaz-el ra anamerl anwarnem-tangkwel. Rap alhem, artwamp-rnemek angketyek. Lyertant apek ra ngenh ilem.” ");
INSERT INTO aly_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Ikwer-penhan Boaz ran alhek, keyt-itwel arrernelhetyek, rernemarl aylpenhem tawen-warl. Keyt ikwer-itwel rernem akarrerrenh, ilek-ilekek apmelerr angkayntetyek. Rarl ikwer-itwel arrernelhek, artwa ran apetyek, wetharl Boaz-el arrwekel itnewek. Ranap arelh inpert arntarnt-arey-angker anenharl. Boaz ikwer arlkek, “Atyeng apeltyay! Apetyay! Atyeng-itwel anetyek.” Artwa ra apetyek, ikwer-itwel anetyek. ");
INSERT INTO aly_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Boaz-elan artwamp-rnem 10-anem inerl-apenh, rap angkek ikwer-rnem, “Apetyenh-arey! Aylek-itwel arrernelhetyek.” Rernemap aney-alhek-anem. Akngerr ingwer-rneman anenh arrpemarl. ");
INSERT INTO aly_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Boaz angkek artwa ikwer-warl, “Ntwa apek awek, Naomi rarl apey-alpek Moab-they? Inperterrenty-penh ra iterreyel, katen anewikw ikwerenh-kenh Elimelek-kenh tharlemeletyek. Elimelek ra aylekenh-antey aneyel. ");
INSERT INTO aly_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Ayengan iterrenh, ngkweng-warl angketyek. Aleyaym nga ilkelhem apek, katen yanh payemeletyek, artwamp-rnemel aweyelarl-kety. Ntwemernt payemelemer. Nganap apek iterreyel, mentyarl aretyek. Kel mwerr. Athanemarl payemeletyek.” Artwa ingwerelan awek, rap angkek, “Ya, mwerr, atha payemelem.” ");
INSERT INTO aly_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Boaz-el tyernek, “Ntwarl katen payemelem, ntwap inem arelh Ruth wethey, inpert yanh Moab-areny, Elimelek-kenh ahenterrikw. Nga itengerrem ikwer-itwel, ra awey akely atnyenetyek, alerey Mahlon-kenh anetyek anwekantherrenh-angkwarr. Rarl alkenherreyenhel, rap apmer inetyek ikwer.” ");
INSERT INTO aly_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Artwa ran angkek Boaz-ek, “Yew! Boaz, nga arraty angkeyel. Kel nthakenh ayeng Ruth-itwel itengerrey-angenh. Atha apmer payemelenty, aleraty atyenh-rnemel nthakenh iney-angenh, ayengarl ahaperrenty-penh. Kel nthakenh atha iney-angenh. Ntwantey inetyek!” ");
INSERT INTO aly_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","8","Alakenh angkenty-penh artwa ra pwet anyent lhelek, anthemel Boaz ikwer. Rap angkek, “Mwerr wenh ntwa apmer payemeletyek.” Alakenhap Israel-kenh-rnemelan mpwarenh. Rernem angkerrenh-tangkwel. Anyentelan pwet lhelenh, ingwer-warl-anem anthemel. ");
INSERT INTO aly_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Boaz ranem angkek artwamp-rnemek ingwer-rnemek-then, “Kel arrantherr anngetherrarl areyel, atharl apmer payemeleyel Naomi-they. Arrantherr iterl-areyel, apmer yanh Elimelek-kenh-tangkwel, alerikw ikwerenh-atherr-then-kenh, Mahlon-then-kenh Kilion-then-kenh. ");
INSERT INTO aly_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Arrantherrap areyel, atharl Mahlon-kenh anewikw ineyel arrpemarl, Ruth wethey Moab-areny. Ayengan ikwer-itwel intengerrem-anem. Aylanth ampernem atnyenem apek, ampernem Mahlon ikwer. Kel mwerraw. Alakenhaym apmer nhenh-areny-rnemel renh iterl-aretyek, iylpelerrey-angenh.” ");
INSERT INTO aly_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Artwamp-rnemel ingwer-rnemel-then awek, rernemap angkek Boaz-ek, “Yew! Anantherran anngetherr arek. Mwerr alakenhan. Anantherrap INGKART ayernem, arelh renh arntarnt-arayntetyek, rarl apmer ngwenh-itwel aney-alpetyek. Anantherr INGKART ayernem, renh anthetyek ampernem akngerr. Awank-akerr artwa arwekeleny Jacob ra Rachel-then Leah-then-itwel itengerrek, ratherrap ampa akngerr atnyenek. Alakenh. Arelh atherr-they anantherr Israel-wenh-rnem akngerrerrek apmer nhenh-itwel. Ephrath-kenh-rnem ingkerrenhelan ngenh nakayntetyek. Bethlehem-areny-rnem ingkerrenhel ngenh iterl-aretyek. ");
INSERT INTO aly_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Alakenh-kety anantherr INGKART ayernem, mpwelanthenh ampa akngerr anthetyek. Anewart weth-atherr arrwekeleny-atherr-apeny, Tamar-then Judah-then-apeny. Ratherr alerikw anyent atnyenek itnan Perez, ngkwenh arrwekeleny. Aleyan akngerr-anem Perez-kenh-antey aneyel. Alakenhey.” ");
INSERT INTO aly_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Kel-anem Boaz-then Ruth-then itengerrek. INGKARTan athamerrenh Ruth ikwer. Ingwer-ingweran ra awey akely atnyenek. ");
INSERT INTO aly_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Arelh Bethlehem-areny-rneman angkek-anem Naomi ikwer-warl, “INGKART nakey anantherr ingkerr! Ran ngenh anthek awey aperlengkw. Rarl alkenherrenty rap ngenh arntarnt-arem-anem. Israel-kenh-rnem ingkerrenhel renh iterl-areyenh. ");
INSERT INTO aly_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Ngarl arelhampw irreyenhel, ra ngenh irrngerney-antheyenh, ngenh rlterrkelemel. Anherrengkw ngkwenhan artewenty ngkweng ilkelheyel, anperarl ingwer-rnem-angkwarran. Arelhampw anyentelan ampa irrwey 7 atnyenem apek, renh arntarnt-arayntetyek. Anherrengkwel ranap ngenh amentarrp athamerremel arntarnt-arenh arlengew-alenty. Aleyan ra aperlengkw ngkwenh-anem atnyenek.” ");
INSERT INTO aly_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Naomi-elan awey renh inek, rap iytnwel-anem atnyenek, renhap arntarnt-aremel. ");
INSERT INTO aly_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Arelh Bethlehem-areny-rnemel renh itnewek Obed, rernemap angkek, “Awey akely renh Naomi-ek atnyenek!” Ingwer-ingweran Obed ra awey akely atnyenek itnan Jesse. Jesse ran awey akely atnyenek itnan David-anem. ");
INSERT INTO aly_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Perez-kenh-rnem alakenh aynteyel: Perez-an aynikw Hezron-kenh anek, ");
INSERT INTO aly_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hezron-an aynikw Ram-kenh anek, Ram-an aynikw Amminadab-kenh anek, ");
INSERT INTO aly_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Amminadab-an aynikw Nahshon-kenh anek, Nahshon-an aynikw Salmon-kenh anek, ");
INSERT INTO aly_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmon-an aynikw Boaz-kenh anek, Boaz-an aynikw Obed-kenh anek, ");
INSERT INTO aly_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obed-an aynikw Jesse-kenh anek, Jesse-an aynikw Atyetyart David-kenh anek. ");
INSERT INTO aly_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Artwa anyent anenh itnan Elkanah. Ranap Ephraim-wenh-antey, apmer Ramah-el anenh apwert-ampeny-itwew. ");
INSERT INTO aly_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Artwa Elkanah ra arelh atherr-akert anenh itnan Hannah Peninnah-then. Peninnah-an ampakertarl anenh, Hannah-an arrangkwarl. ");
INSERT INTO aly_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Aherrety arrpanenhel artwa ra alpenh apmer ikwer-they ikwerenh-rnem-akert apmer Shiloh-warl. Apmer ikwer-itwew ra aylpey-alhenh warl INGKART-wenh-warl, kwenerr-aynteyew INGKARTew. INGKART ran Atyetyart Ilkwa Ingkerrenhew. Artwamp anenh apmer ikwerel itna Eli. Artwa alerikw ikwerenh-atherr Hophni Phinehas-then, ingkart-atherr anenh warl INGKART-wenh-itwew. ");
INSERT INTO aly_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Arlta ingwerel Elkanah-el aker tyenkerr anthenh INGKARTew apmelerrel-ayeth, rap ikwerenh-rnemew-then anthenh, arlkwaynteyew. Aker ra anthenh Peninnah-ew ampernemew-then. ");
INSERT INTO aly_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Arelh ingweran ikwerenh Hannah ampewenyarl, INGKARTelarl arrngertewew ampewety. Ikweran Elkanah-el aker akngerrarl anthenh, rarl ikwer ilkelhenhew artewentyel. ");
INSERT INTO aly_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Peninnah-el renh kwanthenh ahelerreyew-atety, ra ampewenyarl. ");
INSERT INTO aly_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Aherrety arrpanenh alakenh ayntenh. Apmelerr Hannah aylpenh warl INGKART-wenh-warl, arelh ingwerelan renh kwanthenh, rap artnenh-anem. Arlka ra apmwerrenh, nthakenh arlkwey-angenh. ");
INSERT INTO aly_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Mpwernikwan ikwer angkenh, “Nthakenh ngan irreyel? Artney-angenh. Arlkwemer ntwa. Arlka apmwa aney-angenh. Ampa irrwey atnyeneyew iterrey-angenh artewenty. Ayengan ngkweng ilkelheyel artewenty!” ");
INSERT INTO aly_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","Ingwer-ingweran, rernemarl arlkwenh-penh apmer Shiloh-itwew, Hannah-an rtnerl-alhew-anem. Rap alhew warl INGKART-wenh-warl, angkaynteyew ikwer. Artwamp Eli-an anenh arriw-itwew. ");
INSERT INTO aly_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","Hannah-an arlkarl apmwerrew innga, rap artnemel angkenh INGKART ikwer. ");
INSERT INTO aly_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","“INGKARTay! Ngan Atyetyart Ilkwa Ingkerrenhew! Ayengan arwa warrkenh ngkwenh. Amperrngerra atyeng, ayengan arlka apmwarl. Iylpelerlewey-angenh ayenh. Nhaym atha ngenh ayerneyel. Awey atyeng antha! Ntwa ayenh awey anthem, athap ngenh angkep antheynem, raw ngkweng warrkerreyew ampwerreyew-atety. Nthakenh alta renh akey-angenh, ingwer-rnemel renh areyew, ra ngkwenharl.” ");
INSERT INTO aly_vpl VALUES ("S11_12","010_1_12","1SA","1","12","13","Rap intem-antey arreytemel angkenh INGKART-warl arleng-alenty. Eli-el arew, arrakertantarl akngelhenh, awey-angenh. Ra iterrew ikwer terangkew-arrpantey, ");
INSERT INTO aly_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","rap angkew, “Ilekew nga terangkan apetyew? Ngkwarl yanh iwa!” ");
INSERT INTO aly_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Hannah-el tyernew, “Arrangkw artwampay! Ayengan terangk-wenyarl. Ayengan arelh arlkarl apmwerreyelarl. Ngkwarl atha antywey-angenh, arrangkw. Ayengan arreytenh alyepel INGKARTewarl, ikwer ilelhenh. ");
INSERT INTO aly_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Ayenh apmwa antwey-angenh. Ayengan artnemelarl anenh. INGKART atha ayernenh, ayenh alpemeleyew.” ");
INSERT INTO aly_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Eli-an angkew, “Irrepern nga! Artewenty iterrey-angenh alpanem. Anantherr Israel-wenh-rnemel Akngey mwerr-angker apentem. Ra anthemarl, ntwa renh ayernentyan.” ");
INSERT INTO aly_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Hannah angkew ikwer, “Nga mwerr-angkwarrarl atyeng angkew.” Rap anperl-alhew mwerr awelhemel, amern-anem arlkwey-alpew. ");
INSERT INTO aly_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Arlta ingwerel ingwepenh Elkanah akwentew, rap alhew ikwerenh-rnem-akert anyent-inger-anem, INGKART-warl kwenerremel angkaynteyew. Ikwer-penh rernem angkep-anem alpew apmer Ramah-warl. INGKARTel Hannah iylpelerlewey-angenh-antey, rarl ayernenhew. ");
INSERT INTO aly_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Ikwer-penh ingwer-ingwer ra awey-anem atnyenew, rap renh itnewew Samuel. Rap angkew, “Atha renh itnewem Samuel, atharl INGKART ayernew-angkwarr-antey, renh atyeng antheyew.” ");
INSERT INTO aly_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Aherrety anyent-penh Elkanah alhew ikwerenh-rnem-akert apmelerrel-ayeth apmer Shiloh-warl, kwenerr-aynteyew INGKART-warl, aker tyenkerr-then anthaynteyew ikwer. Elkanah-el ikwer antheyew, rarl arrwekel-antey arretengelew. ");
INSERT INTO aly_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Arelh Hannah-an artenyarl anew. Rap angkew, “Aweyan atha aylpatyel-antey wanteyel. Rarl aylpaty-wety ipmelhem, athap renh akngemarl Shiloh-warl, INGKART-warl-anem antheyew. Ra anayntem-then ikwer-itwew.” ");
INSERT INTO aly_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Elkanah-el tyernew, “Kel. Ngarl ilkelhem alakenh. Alerl anayntenh-atherr, awey aylpaty-wety ipmelhentyew. INGKARTel ngenh alpemelem, ntwarl arretengelew-angkwarr.” Hannah-an anenh awey ikwerenh alerl-antey alkenhelenh, rarl aylpaty antywenh-antey-akert. ");
INSERT INTO aly_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Aherrety irrpety-penh aweyel amernant-anem arlkwenh. Elkanah alhew ikwerenh-rnem-akert apmelerrel-ayeth warl INGKART-wenh-warl Shiloh-warl. Amenheng-atherran alhew-anem ikwer-rnem-angkwarr. Rernem akngew pwelek irrwey ilkwa, amern arlety ampwerrk, ngkwarl-anem arranty nanikwet yenp-penh-akert. ");
INSERT INTO aly_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Elkanah-el Hannah-el-then pwelek ipmew atwew INGKARTew, ratherr awey-then akngew artwamp Eli-warl. ");
INSERT INTO aly_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Hannah angkew ikwer, “Artwampay, ntwa ayenh iterl-areyel apek? Awank-akerr ayengan rtney-alhenh ngkweng-itwel, artnemel angkenh INGKART-warl. ");
INSERT INTO aly_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","Atha ayernenh, ampa ayenh antheyew. Rap ayenh awew, nhanemap ayenh anthewan, atharl ayernewan. ");
INSERT INTO aly_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Aleyan atha renh anthem INGKART-warl-anem. Ra warrkerr-aynteyew ikwer ampwerreyew-atety.” Rarl renh ilew, INGKARTelarl renh awew, Eli ra kwenerrew INGKART-warl-anem. ");
INSERT INTO aly_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Ikwer-penh Elkanah angkep alpew ikwerenh-rnem-akert apmer Ramah-warl. Awey ran anenharl Shiloh-itwew. Eli-elan renh akalty-anthenh, INGKARTew warrkerr-aynteyew. ");
INSERT INTO aly_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","Eli-wenh alerikw-atherr, Hophni-atherr Phinehas-atherr, ratherr ingkart apmwatherr anenh. INGKARTew awelhey-angenh ratherr anenh. ");
INSERT INTO aly_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","Ingwerentyel INGKARTew aker anthenh, ratherr aker inenh apmwangkwarr artwa ikwer-they. INGKARTel awank-antey alakenh ilew, “Ingwerentyel aker anthem atyeng, artwa ingkartel aker anter-tangkwel rwel arrtyemer atyeng. Artwa akerew-arteyel kwatyel tyelk arrtyem, artwa ingkartel ra inem-anem ikwerew.” Ratherranap apmwel-ayetharl inenh alakenh. Ingwerentyelarl aker arrtyenh, ratherr warrkenh anyent thwenenh, ikwer-atherr inaynteyew. ");
INSERT INTO aly_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","Warrkenhel fork arlpenty ilkwel atanthenh. Aker akngerr apek ra inenh, aker akely apek. Ratherr inenh alakenh apmwel-ayeth akngerr-wenh. Ratherrap Israel-wenh-rnem ingkerrew irrkaty-angkwarr mpwarenh, rernemarl alhenh apmer Shiloh-warl, aker INGKARTew anthaynteyew. ");
INSERT INTO aly_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","Ratherr mpwelhey-angenh, anter-tangkwel arrtyeyew, arrangkw. Artwa warrkenh ra angkenh artwa akerew-artey ikwer, “Aker artwa ingkartew-atherr antha, ratherr rwel arrtyemel arlkweyew. Aker kwaty-penhew ratherr ilkelhey-angenharl. Aker arlety ikwer-atherr antha!” ");
INSERT INTO aly_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","Artwel ra apek tyernem, “Alerl anter-tangkwel arrtyey-ingkerr. Ntwap aker inem-anem.” Warrkenh ran angkenh, “Arrangkw! Anamerl ayenh anthay, rakerl-alhewerr-anem atha ngenh!” ");
INSERT INTO aly_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","Alakenh Eli-wenh alerelikw-atherran mpwarenh apmwangkwarr innga. Ratherr angka INGKART-wenh awelhey-angenh. INGKARTan ahelerrew ikwer-atherr. ");
INSERT INTO aly_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","Awey Samuel ra warrkerrenh INGKARTew. Ra aylpenh artwa ingkart-wenh arnkwel. ");
INSERT INTO aly_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","Aherrety arrpanenh amelikw ikwerenh kwet akely rlengkeny mpwarenh ikwer artwa ingkart-wenh-apeny. Rarl alhenh apmelerr-angkwarr apmer Shiloh-warl, rap kwet rlengkeny akngenh ikwer. ");
INSERT INTO aly_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Eli-el INGKART ayernenh Elkanah-ew Hannah-ew-atherr alakenh, “INGKARTay, ntwa arelh nhenh anthew awey akely, rarl ngenh ayernenh. Rap ngkweng-anem anthew. Antha nhenh-atherr ampa ingwer-rnem-anem.” Ratherrap alpenh apmer-warl-anem angkep. ");
INSERT INTO aly_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Inngarl INGKART mwerr anenh Hannah-ew. Ikwer-penh ra ampa ingwer-rnem-anem atnyenew; awey-rnem irrpety, kwey atherr. Ikwereng-arey-antey Samuel ra ilkwerreynenh INGKART-wenh warl-itwew, warrkerrenharl ikwer. ");
INSERT INTO aly_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","Eli-an artwamp innganem. Ra awenh, alerikw ikwerenh-atherrelarl apmwel-ayeth mpwarenh Israel-wenh-rnemew. Ra awenh arrpemarl, ratherrarl irrtyertel alhenh arelh warrkenh-rnem-akert, INGKART-wenh kalikwelarl warrkerrenh-rnem, arriwarl arntarnt-arenh-rnem. ");
INSERT INTO aly_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","Rap angkew ikwer-atherr, “Akngerrel ayenh ileyel, mpwelarl apmwa innga mpwareyel. Ilekew mpwel alakenhan apmwelheleyel? ");
INSERT INTO aly_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","Akngerran angkerreyel mpwelew, apmwel-ayetharl mpwareyel, rernemap apetyem ayenh ileyew. ");
INSERT INTO aly_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","Mpwel iterl-arem, artwa anyent apmwelhelem ingwerew, Akngeyarl ikwer katy angkem apek. Artwa anyent apek apmwelhelem INGKART-warl-athek, nthakenh ingwer ikwer katy angkey-angenh-anem, arrangkwarl.” Alerikw ikwerenh-atherranap ikwer awelhey-angenharl, arrwekel-anteyarlap INGKARTan iterrew, renh-atherr ilwerl-atheneyew. ");
INSERT INTO aly_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","Awey Samuel-an ilkwerreynenh arraty-angkwarr. INGKART ikwer ilkelhenh artewenty ingwer-rnem-then. ... ");
INSERT INTO aly_vpl VALUES ("S13_1","010_3_1","1SA","3","1","2","Awey Samuel-el ra artwamp ingkart Eli alpemelenh. Warrk ikwerenh alakenh ayntenh INGKARTew. Eli artwamp innganem irrew, arrkay-anem arenh. Rarl anenheng-arey, INGKART irrpetyapewant angkenh. Irrpetyapelant altyerr INGKART-wenh arenh. Ingwa ingwer-ingweran artwamp ankwayntenh. ");
INSERT INTO aly_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Samuel ra amerrk-anem, rap ayntenh-anem warl INGKART-wenh-itwew, box impen Akngey-wenh-angkwarr. Atemwengkel-antey, lyenenty anter alip-akert ampenh-antey. ");
INSERT INTO aly_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","INGKART arlkew awey ikwer, “Samuel-ay!” Ra tyernew, “Yew! Ilekay?” ");
INSERT INTO aly_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Rap anterrew Eli-warl angkey-alhew, “Ilekay? Nga atyeng arlkew.” Eli-an angkew, “Arrangkwew. Ayengan arlkey-angenh. Alpa ayntey-alpa.” Rap alpew ayntey-alpew-anem. ");
INSERT INTO aly_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","INGKART arlkew arrpemarl Samuel-ew, “Samuel-ay!” Rap akwentew, anterrew Eli-warl arrpemarl angkey-alhew, “Ilekay? Nga atyeng arlkew.” Artwampan angkew, “Aweyay, ayeng ngkweng arlkey-angenh. Alpa ayntey-alpa.” ");
INSERT INTO aly_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","Samuel-elan INGKART iterl-arey-angenh-antey, arrangkw-antey. Aleyant ikwer angkew alakenhan, ranap alhengk-awey-angenh. ");
INSERT INTO aly_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","INGKART arlkew arrpemarl, “Samuel-ay!” Rap akwentew, Eli-warl arrpemarl anterremel angkey-alhew, “Yew! Ilekay? Nga atyeng arlkew.” Artwampel iterl-arew-anem, INGKARTarl arlkenh ikwer, ");
INSERT INTO aly_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","rap angkew, “Alpa ayntey-alpa. Ingwerenty ngkweng arlkenty, angka alakenh, ‘INGKART, angka atyeng-warl. Ayengan awelhem-anem ngkweng.’” Ra alpew ayntey-alpew arrpemarl. ");
INSERT INTO aly_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","INGKART rtney-alhew arrer-anem Samuel-itwew, rap angkew ikwer irrkaty-angkwarran, “Samuel-ay!” Samuel angkew, “INGKART, angka atyeng-warl. Ayengan awelhem-anem ngkweng.” ");
INSERT INTO aly_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","INGKART angkew ikwer-warl, “Atha mpwarem ingwer-lkwer-anem apmer nhenh Israel-itwew. Ingwer-rnem apateyelpeyenh, rernemarl aweyenh alakenh. ");
INSERT INTO aly_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","Eli-rnem atha ilwerl-atheneyew, atharl ilew-angkwarr arrwekel-antey. ");
INSERT INTO aly_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Alakenh atha renh ilew, ‘Ayengan ahel-anem irreyel ngkweng ngkwenh-rnemew-then, athap arrenhantherrenh ilwerl-atheneyenh. Ntwa iterl-arenhan, artwa alerengkw ngkwenh-atherrarl nyerr-weny awelhey-angenh angka atyenhew anenh. Ingkerrenh ikwer-atherr ilkelhey-angenh-anem irrew. Ntwan renh-atherr artwereley-angenh, arrangkw. ");
INSERT INTO aly_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Alakenh-wety atha arrwekel-antey ngenh ilenh ngkwenh-rnem-then, “Arrantherran apmwelelhew akngerr-inger-anem. Aker arrtyey-angenh-anem atyeng-warl, arrangkw-anem. Nthakenh ntwa ayenh apmwa nhewetyan arternpeley-angenh.” ’” ");
INSERT INTO aly_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Samuel-elarl awew-penh, rap aynteynew-anem. Ingwepenh-antey ra arriw altywerelew warl INGKART-wenh-itwew. Ra atererrew, Eli ilewerr, INGKARTarl ikwer angkew. ");
INSERT INTO aly_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","Artwampan arlkew ikwer, “Samuel apetya!” Samuel-el tyernew, “Yew! Ilekay?” ");
INSERT INTO aly_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Artwampel ayernew, “Nthakenh Akngeyan angkew ngkweng-warl? Ila atyeng-warl arraty. Ntwa arraty atyeng iley-angenh, Akngeyan ngkweng ahelerrem artewentyel.” ");
INSERT INTO aly_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Samuel-el ilew arraty-antey angka ingkerr akertew-atety. Eli angkew, “Inngarl ran INGKART ilkwarl. Ra arraty-angkwarr mpwarem.” ");
INSERT INTO aly_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Samuel ra ilkwanem irrew. Angkernem rarl angkenh, innganemarlap rerneman, INGKARTarl ikwer-itwel anenh. ");
INSERT INTO aly_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Akngerrel Israel-wenh-rnemel renh iterl-arenh. Rernem ingkerrenhel iterl-arenh, Samuel rarl artwa angkakert INGKART-wenh anenh. ");
INSERT INTO aly_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Akngerr-inger INGKART aremerrey-alhenh ikwer-warl apmer Shiloh-itwew. Ra renh akalty-anthenh, arraty angkaynteyew. ");
INSERT INTO aly_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","Alakenh Samuel angkenh Israel-wenh-rnemew. Ingwer-ingweran artwa ahawarr akngerr Philistia-areny-rnem akarrerrew, atwerreyew werreyew-then pewenarrel Israel-wenh-rnem-then. Israel-wenh-rnem ayntey-alhew apmer Ebenezer arrerenty. Philistia-areny-rneman ayntey-alhew apmer Aphek arrerentyarl, ipert ingwer-ampenyarl. ");
INSERT INTO aly_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","Rernem alhew ampep-warl, werreyew Israel-wenh-rnem-then. Philistia-areny-rnemel renh-rnem ipmew atwew, akngerr innga, 4,000. ");
INSERT INTO aly_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","Israel-wenh-rnemarl alpew angkep apmer ikwer-rnem-wenh-warl, artwamp-rnem ayernerrenh, “Ilek-wety INGKARTel renh-rnem tyarlewew, anewantherrenh-rnem atweyew? Apmer Shiloh-warl alhey, box impen Akngey-wenh inerleweyew. Anantherr box renh atnyeneyew atwerrentyeng-arey Philistia-areny-rnem-then. Akngeyelan anenhantherrenharl alpemelem.” ");
INSERT INTO aly_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","Rernemap artwernem thwenew Shiloh-warl, box impen Akngey-wenh inerleweyew. Rerneman iterrew, “INGKART Ilkwa Ingkerrenhew ra box-itwew aneyel aympelh-akert atherr ampepel.” Artwamp ingkart Eli alerikw ikwerenh-atherr, Hophni Phinehas-atherr, ratherr alhew arrpemarl, box impen arntarnt-arenhey-alpaynteyew. ");
INSERT INTO aly_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","Rernemarl akngey-alpew box renh, Israel-wenh-rnem inkwerelhemel arlkalhelerrew. Arlkewarlel ahern akngenhelhelew. ");
INSERT INTO aly_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","Philistia-areny-rnemel awew, rernemap ayernerrew, “Nthakenh irreyel? Ilekewarl Israel-wenh-rnem arlkalhelerrew?” Rernemarl awew, Israel-wenh-rnemel box impen Akngey-wenh atnyeney-alpew, ");
INSERT INTO aly_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","rernemap atererrew. Rernemap apatemel angkerrew, “Pwertay! Akngey ikwer-rnem-wenh ikwer-rnem-warl-anem apetyew! Aleyant alakenh irrewan! Irrwernelhew innganem anantherr! ");
INSERT INTO aly_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","Nthakenh ingwerentyel anenhantherrenh arntarnt-arey-angenh nhelkwer-wety! Anantherr awew, rarl apmwa innga mpwarew Egypt-areny-rnemew arlpaw-ampeny-itwew. ");
INSERT INTO aly_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","Anantherr Philistia-areny-rnem rlterrk-antey aneyew! Renh-rnem antengeleyew, anantherraw atyetyart ikwer-rnem aneyew. Rernem anewantherr atyetyartarl anewerr! Atererrey-angenh ikwer-rnem-wety! Artewenty atweyew anantherr!” ");
INSERT INTO aly_vpl VALUES ("S14_10","010_4_10","1SA","4","10","11","Rernemap inngarl rlterrk alhew ikwer-rnem-angkwarr, ipmew-anem atwemel artwa ahawarr Israel-wenh-rnem 30,000. Ikwereng-arey Philistia-areny-rnemel irrtyert-inew box impen Akngey-wenh. Eli-wenh alerikw-atherr, Hophni-atherr Phinehas-atherr, ratherr ilwew arrpemarl. Ingwer-rneman arlperrtyarl anterrew, apmer-warl angkep alperlewew. ");
INSERT INTO aly_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","Arlta ikwerel-antey artwa anyent angka apmwakert anterrew, rernemarl atwerrenh-they. Ranap Benjamin-wenh-antey, rap anterreynenh apmer Shiloh-warl, arleng innga. Arlka apmwa innga anterrenh; arnkwa ra ilterrew, akapwert-warl ahern arrernelhew ikwer-rnem-wenh-angkwarr, rarl ikwer-rnem artewenty amperrngerrew. ");
INSERT INTO aly_vpl VALUES ("S14_13","010_4_13","1SA","4","13","15","Eli-an artwamp innganem, 98, aparrng-anem. Ra anenh arriwel arntarnt-arelhemel, chair-el anerl-anemel. Ra atererremel iterrew artewenty, apmwa innga ayntewerr box impen Akngey-wenh ikwer. Artwa rarl apmer-warl aremerrenhew, angka apmwa ilerl-apenh, akngerran artnalhelerrew-anem. Eli-el awew, rap arlkew artwa ikwer, “Nthakenh irreyelay? Ilekewarl akngerr artnalhelerreyel alakenhan?” ");
INSERT INTO aly_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","Artwa ra anterrew Eli-warl angkey-alhew, “Artwampay! Ayengan anterrey-alhew, rernemarl atwerrenh-they!” Artwampel ayernew, “Nthakenh irreway?” ");
INSERT INTO aly_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","Ra tyernew, “Anantherr Israel-wenh-rnem anterrey-alpew Philistia-areny-rnem-wety. Rernem artwa ahawarr ingwer-rnem anewantherrenh-rnem atwew, alerengkw ngkwenh-atherr-then. Box impen Akngey-wenh rernemap irrtyert-inew anewantherr-they!” ");
INSERT INTO aly_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","Eli-an anenh-antey chair ikwer-itwew. Rarl awew, Philistia-areny-rnemelarl box impen irrtyert-inew, rap aytnew artepel-ayeth ahern-warl. Artwamp antyelty irrewarl innga, rap rternng-anem akelhew. Artwa ilkwa ra anenh Israel-itwew aherrety 40-ew-atety. ... ");
INSERT INTO aly_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","Philistia-areny-rnemel irrtyert-akngeynew box impen Akngey-wenh. Ebenezer-they akngeynew apmer ingwer-warl Ashdod-warl, Philistia-itwew. ");
INSERT INTO aly_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","Rernemap aylpenhew ikwer-akert warl Dagon-wenh-warl. Dagon ampwal ilkwa apwert-penh arnwarnew. Philistia-areny-rneman kwenerrenh ikwer-warl inngewarl-arrpantey. Rernemap arrernew box impen ikwer-itwew. ");
INSERT INTO aly_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","Ingwepenh ingwerelan Ashdod-areny-rnem akwentew, rernemap arew ampwal ikwer-rnem-wenh, ahernel-anem atnertel-ayeth ayntenh. Arrwekel-ampeny box impen-itwew ra ayntenh. Rernemap renh rnkerneynew angkep arrpemarl. ");
INSERT INTO aly_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","Ingwepenh ingwerelan rernem arew, ampwal ra aytnew arrpemarl. Arrwekel-ampeny box ikwer-itwew ra ayntenh ahernel arrpemarl, atnertel-ayeth. Arlkan mwerr-antey akelhey-angenh-anteyarl. Akapwert akwatherr akelhewarl, arriw-itwew ayntenh aketh-itwew. ");
INSERT INTO aly_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","Warrkenh Dagon-wenh-rnemel ampwal arnangelew arriw-wety. Rernem ingwer-rnem-then arraty alhey-angenh-anemarl arriw-angkwarr. Rernem atnarnpenhenh-anem ikwer-angkwarr, warl ikwer-warlarl aylpenhenhan, ampwal renh lthwenewerr-arrpantey. Rernem atnarnpenhenh-antey angka nhenhan ingkwernenheng-arey. ");
INSERT INTO aly_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","INGKARTel apmwel-ayeth mpwarew Ashdod ikwer-ampeny-areny-rnemew. Ingkerrenh wangkew tywen-angketyarr-anem. ");
INSERT INTO aly_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","Ashdod-areny-rnemel arew arntety apmwa, rernemap angkerrew, “Anantherr Akngey Israel-areny-angkwarr irrwernelhew innganem. Dagon-an Akngeyel atwem arrpemarl! Iwemer anantherr box Akngey-wenh!” ");
INSERT INTO aly_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","Rernem yangkelhew, artwa ilkwa apmer ingwer-ampeny-areny-rnem apetyeyew, akarrerreyew Ashdod-itwew. Rernemap renh-rnem ayernew, “Nthakenh ilem anantherr box Akngey Israel-areny-wenh nhenhan, arntety-wety?” Rernem tyernew, “Apmer ingwer-warl Gath-warl-anem thwenenh-arey.” Box renhap rernem apmer Gath-warl-anem akngeynew. ");
INSERT INTO aly_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","Rernemarl akngeynew-penh, INGKARTel apmwel-ayeth mpwarew Gath-areny-rnemew-anem irrkaty-angkwarr, ater-anthew renh-rnem artewenty. Ingkerrenh wangkew tywen-angketyarr, akely-rnem ilkwernem-then. ");
INSERT INTO aly_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","Kel Philistia-areny-rnemel box renh apmer ingwer-warl-anem Ekron-warl akngeynew. Rernemarl arrer-anem irrew box ikwer-akert apmer Ekron-warl, akngerr ikwer-areny arlkalhelerrew arnarewarlel. “Pwertay mentyaw! Nhenh-rnemelan box renh Akngey-wenh apmer nhewarl-anemarl akngetyew! Ilwerl-atheneyenhanap ingkerrenh!” ");
INSERT INTO aly_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","Rernemap yangkelhew, artwa ilkwa apmer ingwer-ampeny-areny-rnem apetyeyew, akarrerreyew arrpemarl. Ekron-areny-rnem ikwer-rnem angkew, “Box yanh iwey! Thweneyney angkep apmer ikwerenh-warl, ingkerrenh-anem ipmew atwewerr apmer arrpanenh-itwew Philistia-ampeny!” Ilwernerrew akngerr arntety ikwer-penh. INGKARTel ater-anthew renh-rnem alakenharl. Rap apmwel-ayeth innga mpwarew Philistia-areny-rnemew. ");
INSERT INTO aly_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","Ingwer-rnem iteth-antey anenh-rnem, arntety ilkwakert anenh tywen-angketyarr. Rernemap altyerr ikwer-rnem-wenhew arlkalhelerrenh, renh-rnem ayerneyew mwerreleyew. ... ");
INSERT INTO aly_vpl VALUES ("S17_1","010_7_1","1SA","7","1","2","Kel Philistia-areny-rnemel thweneynew angkep box impen Akngey-wenh Israel-warl. Israel-wenh-rnemelan akngeynew apmer Kiriath Jearim-warl, warl Abinadab-wenh-warl apwert irrwerl-warl. Rernemap arrernew alerikw ikwerenh Eleazar, box renh arntarnt-araynteyew. Box ra rtnenh aherrety 20-ew-atety warl ikwer-itwew. Ikwereng-arey Israel-wenh-rnem alpwely anenh, intem-antey ayernenh INGKART, renh-rnem alpemeleyew. ");
INSERT INTO aly_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","Samuel-el renh-rnem ayernew, “Inngang arrantherr angkeperrem INGKART-warl? Arrantherrap alakenh irremer. Iwenh-arey ilek-ilek yanh-rnem arwerl-penh apwert-penh. Ampwal yanh-rnem iwenh-arey amarl-arrpantey itnan Astarte-rnem. Ampwal yanh-rnem Israel-areny-weny, arrangkw. Apmer ingwer-areny-wenh. INGKART anyentewant nakemel kwenerreyew, rap arrenhantherrenh arntarnt-arem Philistia-areny-rnem-wety.” ");
INSERT INTO aly_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","Rernemap awelhew, iwemel ampwal renh-rnem, artwarrpantey itnan Baal-rnem amarl-arrpantey itnan Astarte-rnem-then. Rernemap INGKARTewant-anem nakemel kwenerrenh. ");
INSERT INTO aly_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","Ikwer-penh Samuel yangkelhew Israel-wenh-rnemew, “Akarrerrenh-arey apmer Mizpah-itwew. INGKART atha ayerneyew arrewantherr.” ");
INSERT INTO aly_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","Akngerr akarrerrew-anem apmer ikwer-itwew. Samuel atyetyart ikwer-rnem anenh. Kwaty rernem inpew, thelemel ahern-warl. Alakenh rernem INGKARTew ilelhew nyerrerremel apmwa ikwer-rnem-wenh-they. Arlta ikwerel rernem amern arlkwey-angenh anenh, rernemap ilelhew, “Apmwel-ayeth mpwarew anantherr INGKART-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","Philistia-areny artwa ilkwernemel awew, Israel-wenh-rnemarl akarrerrew Mizpah-itwew, rernemap atnwenhew artwa ahawarr akngerr apmer ikwer-warl. Israel-wenh-rnemel awew, ingwer-rnemarl apetyenh, rernemap atererrew. ");
INSERT INTO aly_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","Rernemap angkew Samuel-warl, “INGKART katy ayern-aynta anewantherr, ipmelhey-angenh. Ayerna, anenhantherrenh mwanty arntarnt-areyew ikwer-rnem-wety.” ");
INSERT INTO aly_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","Samuel-el inew yep-yep akely, rap renh arrtyew ingkerrenh-antey INGKARTew. Ra ayerneynenh intem Israel-wenh-rnemew, INGKART rap renh awew-anem. ");
INSERT INTO aly_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","INGKARTel alakenh mpwarew, rarl Samuel awewel. Samuel rarl yep-yep akely arrtyenheng-arey, Philistia-areny-rneman arrerarl apetyenh ahel apmer ikwer-warl. INGKARTelap arwerlk ilkwa angkelh-angkelhelew awely-awely-apeny. Philistia-areny-rnem atererrew artewenty innga apatemel, rernemap aterel-anem anterreynew. ");
INSERT INTO aly_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","Israel-wenh-rnemel alwernew Mizpah-they apmer Beth Car-ew-atety, akngerr ipmew atwenhew ampep-itwew. ");
INSERT INTO aly_vpl VALUES ("S17_12","010_7_12","1SA","7","12","13","Philistia-areny-rneman arlperrty anterrew apatemel, arleng-alenty alpew, apey-alpey-angenh apmer Israel-warl. Samuel rap apwert ilkwa anyent inew, rnkernew-anem ampep-itwew apmer atherr-itwew, Mizpah-itwew Shen-itwew-then, ingkerrel iterl-araynteyew. Rap angkew, “INGKARTel anenhantherrenh arntarnt-arenh.” Rap apwert renh itnewew “Apwert Arntarnt-arey-angker-wenh.” INGKARTel renh-rnem arntarnt-arenh arleng-alenty Philistia-areny-rnem-wety, Samuel iteth-antey anenheng-arey. ... ");
INSERT INTO aly_vpl VALUES ("S18_1","010_8_1","1SA","8","1","2","Samuel alerikw atherr-akert. Alerikw ilkwan itna Joel, alerikw akelyan itnan Abijah. Aynarlewarl artwamp-anem irrew, ra arrernew renh-atherr ilkwa Israel-wenh-rnemew. Ratherr court-ew-artey-atherr, apmer Beersheba-itwew warrkerrenh. ");
INSERT INTO aly_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Ratherranap aynarlew-apeny-weny. Anketyarlap ratherran, apwertant inaynteyew iterrenh. Artwa apmwel-rneman renh-atherr apwert anyelkel anthenh, ratherraw renh-rnem court-itwew tyarlew-aynteyew. ");
INSERT INTO aly_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Ingwer-ingweran artwamp-rnem akarrerrew apmer Ramah-itwew, angkeyew Samuel-warl. ");
INSERT INTO aly_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","“Ngan artwamp-anem irrew. Alerengkw ngkwenh-atherr ngapeny-weny. Ratherran mwerr-wenyarl ilkwa aneyew anewantherr. Ntwa arrernemer artwa ilkwa anyent, atyetyart anewantherr aneyew. Apmer ingwer-rnem-itwewan atyetyart ilkwa anyentarl aneyneyel. Anantherran ilkelheyel irrkaty-angkwarr arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Samuel-an arlkarerrew, rernemarl alakenh angkew-wety. Rap angkey-alhew INGKART-warl. ");
INSERT INTO aly_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","INGKART angkew ikwer, “Awelha ikwer-rnem, rernemarl ayerneyel-angkwarr. Rernem ngkweng-wety arlkarerrey-angenharl. Inngan atyeng-wetyarl rernem arlkarerreyel. Ilkelhey-angenh atyeng, ayeng atyetyart aneyew ikwer-rnem, arrangkw-anem. ");
INSERT INTO aly_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Awank-akerr alakenh ayntew, atharl arrwekeleny-rnem atnwenhey-alpenh apmer Egypt-they. Rernem intem-antey atyeng-wety angkeperrenh, ampwal apmer ingwer-areny-rnemew kwenerrenh. Aleyan rernem irrkaty-angkwarr-antey mpwareyel. Ngkweng-wety-anem arlkarerreyel arrpemarl. ");
INSERT INTO aly_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Mwerrarl ikwer-rnem awelheman. Menty rernem atyetyart ilkwa ingwer iney. Mwanty-tangkwel angka ikwer-rnem, ‘Atyetyart yanh-lkwer anenty, rap rlterrkarl mpwarem arrewantherr. Rap ilanthem, ilek-ilek mpwareyew rlterrk-angkwarr ikwer.’” ");
INSERT INTO aly_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Samuel-el artwamp-rnem ilew, INGKARTarl angkew-angkwarr. ... ");
INSERT INTO aly_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Rernem awelhey-angenh ikwer. “Arrangkw! Artwa atyetyart anyent anewantherr arrerneyew! ");
INSERT INTO aly_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","Apmer ingwer-rnem-itwewan artwa atyetyart ilkwa anyentarl aneyneyel. Anantherran ilkelheyel irrkaty-angkwarr arrpemarl. Atyetyart rap atnwenh-ayntem anenhantherrenh, atwerr-aynteyew ingwer-rnem-itwew.” ");
INSERT INTO aly_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Samuel alhew, INGKART ileyew, rernemarl angkew-angkwarr. ");
INSERT INTO aly_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","INGKARTel tyernew, “Awelha ikwer-rnem. Atyetyart yanh-lkwer arrerna ikwer-rnem.” Samuel angkew artwamp-rnemew, “Kel. Alakenh mpwarem atha. Alpenh-arey-anem apmer-warl ingkerr.” ");
INSERT INTO aly_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Artwamp ilkwa anenh itna Kish, ranap Benjamin-wenh-anteyarl. ");
INSERT INTO aly_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Kish-wenh alerikw itnan Saul-arl. Artwa akely inngerr mwerr-angkerarlap ran, arlpenty innga ingwer-rnem-angkwarr anenh, Israel-itwew. ");
INSERT INTO aly_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Artwamp Kish-el tangkey akngerr atnyenenh. Ingwer-ingweran tangkey-rnem ingwer-angkwarr irrtyert-alpew. Kish-ap angkew alerikw Saul-ew, “Nga warrkenh anyent-then alhenh-atherr, tangkey-rnemew nthweyew.” Ratherrap anperl-alhew, ");
INSERT INTO aly_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","nthweyew Ephraim-itwew apwert-angkwarr-tangkwel, ikwer-they Shalisha-ampeny-angkwarr-anem. Arrangkw-antey, arey-alhey-angenh-antey. Ikwer-they ratherr nthweyew alhew Shaalim-ampeny-warl-anem. Arrangkw-antey. Benjamin-ampeny-anem arrangkw arrpemarl ywarew. ");
INSERT INTO aly_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","Ratherrap alhew Zuph-ampenyew-atety-anem. Saul angkew, “Arleng-alenty aylanth apetyew. Angkep alpey, akngey atyenh artewenty iterremel mpwelherl-anewerr aylewanth, tangkey weth-rneman menty-anemarl ipmey.” ");
INSERT INTO aly_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","Warrkenhel tyernew, “Alerl-antey. Artwamp weth-alew, angka Akngey-wenh-akert? Ra apmer nhel arrer-antey aneyel. Tyak inngarl ran. Aylanth renh ayernemer. Ra apek iterl-areyel, tangkey-rnemarl alpew.” ... ");
INSERT INTO aly_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","Ratherrarl apmer ikwerel aremerrew, ratherrap artwamp Samuel arnarew. Ra alhenh apwert-warl, rernemarl aker arrtyenh-warl INGKARTew. ");
INSERT INTO aly_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Arrwekel-antey INGKARTel renh ilew alakenh, ");
INSERT INTO aly_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","“Atha areyel, atyenh-rnemarl ingwer-rnemel alhengkerr-antheyel. Rernem ayenh ayernenh, athap renh-rnem awew. Ingwelarreng atha artwa akely thwenem ngkweng-warl, ranap Benjamin-wenh-anteyarl. Rap atyenh-rnem arntarnt-arem Philistia-areny-rnem-wety. Anter alip theleyew akapwert-warl. Alakenh renh atyetyart arrerneyew atyenh-rnemew Israel-wenh-rnemew.” ");
INSERT INTO aly_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Samuel-el Saul warrkenh-then arnarew, INGKART angkew ikwer, “Yanh ra apetyeyel, atharl ngenh ilew apmwerrkel. Ran atyenh-rnemew atyetyart aneyenh.” Samuel mpwelhew ikwer-atherr keyt-itwew. ");
INSERT INTO aly_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","Saul-el iterl-arey-angenh artwamp renh, arrangkw-antey. Rap angkey-alhew ikwer apal, “Artwamp altyerr arey-angker aneyel apmer nhenh-itwew. Nthekarlap warlan ikwerenh?” ");
INSERT INTO aly_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","Samuel-el tyernew, “Ayengaw, altyerr arey-angkeran. Mpwelanth alhenh-atherr arrwekel apwert yanh-warl, akerarl arrtyem-warl INGKARTew. Rlengkan mpwelanth amern arlkwem atyeng-itwel. Ingwelarreng atha ngkweng-warl anayntelemel ilem, ngarl akwerrng iterreyel. Mpwelanthap apmer-warl-anem alpem. ");
INSERT INTO aly_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","Tangkey weth-rneman anterrewarl arlta irrpetyel, menty-anemarl ipmey. Ingwerentyel renh-rnem arey-alhew kel-antey. Angka nhenhew-anem iterra. Ntwa apek awew, akngerr alakenh angkerrew, ‘Artwa Kish-wenh-anteyarl rlwaneman, atyetyart anewantherr aneyew Israel-wenh-rnemew?’” ... ");
INSERT INTO aly_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","Rernem apey-alpew apwert irrwerl-they apmer Samuel-wenh-warl. Samuel-el Saul atnwenhew warl irrwerl-warl alkey-warl, ratherraw angkerreyew. Ingwelan Saul-then warrkenh-then ayntew irrwerl arlkarl-itwew. ");
INSERT INTO aly_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","Ingwepenh-antey Samuel arlkey-ayntew Saul-ew, “Akwentenh-atherr, apmer-warl-anem alpeyew.” Saul-then Samuel-then keyt-warl-athek-anem anperl-alhew. ");
INSERT INTO aly_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","Samuel angkew-anem ikwer, “Artwa warrkenh yanh thwena, arrwekel irreyew. Ngan alerlarl mpwelha. Atha ngenh angka INGKART-wenh-tangkwel iley-alkenh.” Warrkenh ra anperl-alhew arrwekel. ");
INSERT INTO aly_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Samuel-el anter alip inew, thelemel Saul-warl akapwert-warl. Rap renh arrwantyew arreyl atherr-angkwarr ikwer-rnem-wenh-angkwarr angkemel, “INGKARTel ngenh arrerneyel, atyetyart aneyew ikwerenh-rnemew. Ntwap renh-rnem arntarnt-arem ahelengkw-rnem-wety apmer arrpanenh-areny. ... ");
INSERT INTO aly_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","Inweng INGKART-wenh ngkweng-warl arrerneyenh, arrawarrengel ngenh rlterrkeleyew. Ntwap angka INGKART-wenh ileyenh, angkakert Akngey-wenh-rnemarl akarrerreyenheng-arey. Ngap ingwer-lkwer-anem anem. ");
INSERT INTO aly_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","Ntwarl alakenh arem, ntwap iterl-areyew, Akngeyan ngkweng-itwel arrer-anem anayntem. Ilkelhentyel ntwa ilek-ilek mpwaraynteyew.” ... ");
INSERT INTO aly_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Saul-arl anperl-alhew, anamerl-antey Akngeyel renh ingwer-lkwerelew. Ikwerel-antey ra angka INGKART-wenh ilew, artwamparl angkew-angkwarr. ... ");
INSERT INTO aly_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Samuel yangkelhew Israel-wenh-rnemew, “Ingkerr akarrerreyew apmer Mizpah-itwew.” ... ");
INSERT INTO aly_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Rernem akarrerrew apmer ikwer-warl. Samuel-el Saul-anem arrwekel rnkernew. Samuel angkew ingkerrew, “Artwa nhenh arenh-arey! INGKARTel renh rlwanew, atyetyart aneyew! Ingwerenty alakenh aney-angenh rapeny, arrangkw!” Akngerr inkwerelhemel arlkerrew ikwer, “Intem-antey ra aneyew atyetyart!” ... ");
INSERT INTO aly_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","Ikwer-penh atyetyart ilkwa apmer Ammon-areny apetyew itnan Nahash, artwa ahawarr akngerr-akert. Rernemap amperelew apmer Jabesh renh Gilead-ampeny-itwew. Akngerr ikwer-itwew nthakenh alhey-angenh aketh-warl anew. Rernem angkakert thwenew atyetyart ikwer-warl, alakenh angkeyew, “Ipmew anenhantherrenh atwey-angenh! Ngan atyetyart anewantherr anem. Anantherran warrkenharl ngkweng anem. Pip-warl anantherr alakenh ingkerrenhel ingkwerney, itnernem ingkwernelheyew ingkerrenh pip ikwer-warl.” ");
INSERT INTO aly_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","Atyetyartel thweneynew angkakert angkep, alakenh angkeyew, “Kel. Atha arrenhantherrenh atwey-angenh. Anngant arraty-ampeny atha tyerrem arrewantherr-itwew. Alakenharlan Israel-wenh-rnem nyerr-antheyew.” ");
INSERT INTO aly_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","Artwamp-rnem apmer ikwer-areny-rnemel angkakert thwenew angkep atyetyart ikwer-warl, alakenh angkeyew, “Alerl anantherr aney arlta 7-ew-atety-tangkwel. Kel anantherr thwenem angkakert-rnem apmer arrpanenh-warl Israel-ampeny-warl. Ingwer-rnem apetyey-angenh apek, anenhantherrenh alpemeleyew. Arrangkwelan, anantherr ngkweng-warl anthelhem. Ntwap anenhantherrenh annga tyerrem-anem.” ");
INSERT INTO aly_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","Angkakert-rnem aremerrew apmer Saul-wenh-itwew Gibeah-itwew, angka apmwakert. Apmer ikwer-areny-rnemel awew, rernemap atayel artnalhelerrenh. ");
INSERT INTO aly_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","Saul-an apal warrkerrenh katen-itwew. Rarl apey-alpenh pwelek atherr-akert, rap awew artnalhelerrenharl. Rap ayernew, “Nthakenh irreyelay? Ilekew akngerr artnalhelerreyel?” Rernem renh ilew, angkakert-rnemelarl ilew-angkwarr. ");
INSERT INTO aly_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","Saul-el awew, Inweng Akngey-wenhel renh rlterrkelew anamerl-antey arawerrng ilkwel. Ra ahelerrew artewenty atyetyart Ammon-areny ikwer. ");
INSERT INTO aly_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","Pwelek ikwerenh-atherr ipmew atwew, nayp ilkwel akep-akalthemel akely-akely. Angkakert akngerr-tangkwel akarrelew, aker akely-akely anthemel ikwer-rnem. Rap apmer arrpanenh-warl Israel-ampeny-warl thwenew, angkey-alheyew alakenh, “Aker tyeylp nhenh arenh-arey! Artwa ingkerrenhel apenteyew Saul-then Samuel-then, Ammon-areny-rnem-then werreyew! Artwa anyent arteny anenty, Saul-elap pwelek ikwerenh-anem akep-akaltheyenh aker nhenh-apeny!” Alakenhan Saul-el akngerr ater-anthew, INGKARTelarl rlterrkelewel. Rernemap ikwer anyent-inger awelhew. ");
INSERT INTO aly_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","Saul-el akarrelew artwa akngerr apmer anyent-itwew Bezek-itwew; 300,000 Israel-areny, 30,000 Judah-areny-rnem. ");
INSERT INTO aly_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","Saul-rnemel ilanthew angkakert Jabesh-areny-rnem, “Jabesh-areny-rnem ilenh-arey, ‘Ingwelarrengan ingwepenh-antey anantherr irrentemel atweyenh Ammon-areny-rnem!’” Jabesh-areny-rnemel awew, rernemap irrngerney irrew. ");
INSERT INTO aly_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","Rernemap angkakert thweneynew angkep atyetyart Ammon-areny-warl, alakenh iley-alheyew irrtywerremel irrtywerl-ampernemel, “Ingwelarreng anantherr anthelhem ngkweng-warl menty-anem. Ntwarrp anem, pwarrk antha, ngarl angkew-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","Saul-el ikwerenh-rnem irrpety-inger akalkelh-ayntew ingkeny tyerrelhey-angenhel-antey, 110,000 ingkerr amentew-ament, 330,000-penh. Aherlkewarlel-anem rernem anterrerrew apmer Ammon-areny-rnem-wenh-warl, artwa akngerr ipmew atwew. Rernemap renh-rnem atwenh-antey ingkeny ampepew-atety. Irrpetyapant-anem Ammon-areny-rnem aneyelpew, rernemap anterrerrew ingweram-angkwarr. ... ");
INSERT INTO aly_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Ingwer-ingweran artwamp Samuel angkew Saul-ew, “INGKARTel ayenh ilew, ngenh atyetyart arrerneyew ikwerenh-rnemew Israel-wenh-rnemew. Awelha angka nhenhew-anem, rarl ayenh ilew ngwamp. ");
INSERT INTO aly_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","‘Awank-akerr, Israel-wenh-rnemarl alperlewenh Egypt-they, Amalek-areny-rnem apetyew, renh-rnem atweyew. Aleyan athanemarl renh-rnem atweyew, rernemarl alakenh-anyem apmwa mpwarew atyenh-rnemew. ");
INSERT INTO aly_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Amalek-areny-rnem atweyew alhenh-arey! Arrtyemel ilek-ilek ikwer-rnem-wenh! Ingkerrenh atweyew ywerrelhelemel; artwernem, arelh-rnem, ampernem, pwelek-rnem, yep-yep-rnem, kamwerl-rnem, tangkey-rnem-akerr ingkerr-antey! Atyeng ingkerrenh antheyew alakenh.’” ");
INSERT INTO aly_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Saul-el angka thwenew apmer arrpanenh-warl, artwa ahawarr-rnem akarrerreyew apmer anyentel Telaim-el. Akngerr akarrerrew apmer ikwer-itwew; 200,000 Israel-areny-rnem, 10,000 Judah-areny-rnem. ");
INSERT INTO aly_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","Ra renh-rnem atnwenhew apmer Amalek-areny-rnem-wenh-warl, rernemap irrtyert-aylpew atwaty-itwew, apmer ikwer-itwew arrer-antey. ");
INSERT INTO aly_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","Ikwereng-arey ingwer-rnem-then anenh apmer ikwerel, Ken-areny-rnem. Saul-el angkakert ikwer-rnem thwenew, alakenh angkeyew, “Arrantherr Ken-areny-rnem alhemer-tangkwel arnangerremel, atha ingkerr ilwerl-atheneyenh-wety Amalek-areny-rnem. Nthakenh atha arrenhantherrenh atwey-angenh, arrantherrarl Israel-wenh-rnem alpemelew, arrwekeleny-rnem awank-akerrarl alperlewenh Egypt-they.” Ken-areny-rnem alhew-tangkwel apmer ikwer-they arnangerremel. ");
INSERT INTO aly_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Saul-el artwa ikwerenh-rnem-akertel alwernew Amalek-areny-rnem apmer Havilah-they apmer Shur-ew-atety, akngerrakw-ampeny Egypt-they. ");
INSERT INTO aly_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Saul-wenh-rnemel ipmew atwew artwa, arelh, ampa ingkerrenh-antey. Atyetyart Amalek-arenyan itnan Agag rernem atwey-angenh, arrangkwarl. ");
INSERT INTO aly_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Itetharl renh atnyenew. Atnwenth mwerr-rnem-then iteth atnyenew; yep-yep, pwelek, akwerrk-rnem-then ikwer-rnem-wenh. Atnwenth apmwernemant rernem ipmew atwew. Ingkerrenh ipmew atwey-angenh-antey, arrangkw. Rernem awelhey-angenh, INGKARTelarl Saul ilew-angkwarr. ");
INSERT INTO aly_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Ikwerel-antey INGKARTel artwamp Samuel ilew, ");
INSERT INTO aly_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","“Saul-an atyeng awelhey-angenh. Intwemelerrew atyeng-wety. Ayengan amperrngerreyel, atharl renh atyetyart arrernew.” Samuel-el awew, rap arlka apmwerrew. Ankwakel ra artnemel angkew INGKARTew. ");
INSERT INTO aly_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Ingwepenh-antey Samuel akwentew, alhew-anem, Saul-ew nthweyew. Ingwerentyel renh iley-ayntew, “Arrangkw nhenh. Saul ra alhew apwert Carmel-warl. Apwert ikwer-itwew apwert arlpenty-anem ra rnkernew, ingkerrel iterl-araynteyew, rantarl Amalek-areny-rnem ywerrelhelemel atwew. Ikwer-penh ra alhew apmer Gilgal-warl-anem.” ");
INSERT INTO aly_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Samuel-elarl renh arey-alhew, Saul angkew, “Samuel-ay! INGKARTel ngenh irrngerney-anthemer! Atha kel-antey mpwarew, rarl ilanthew-angkwarr!” ");
INSERT INTO aly_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Samuel angkew, “Ntwa ilek-ilek ingkerr ywerrelhelemel atwey-angenh! Aleyan atha aweyel, yep-yep-rnem pwelek-rnem-then artneyelarl!” ");
INSERT INTO aly_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Saul-el tyernew, “Artwa ahawarr-rnemel, rernemarl alakenhan mpwarew! Rernem atnwenth mwerr-rnem inew Amalek-areny-rnem-wenh. Iteth-antey rernem atnyenew, ntwaw arrtyaynteyew INGKARTew. Ingwer-rneman anantherr ipmewarl atwew.” ");
INSERT INTO aly_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Samuel-el renh akeleytelew. “Akeleyt awelha atyeng-tangkwel! Atha ngenh ileyew, INGKARTarl atyeng angkew-angkwarr ingwel.” “Ya, ila ayenh.” ");
INSERT INTO aly_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","“Akely-tangkwel nga ilelhew. Nga ilkwa aneyew arrkernelhey-angenh. INGKARTel ngenh ilkwarl arrernew, ikwerenh-rnemew atyetyart anaynteyew. ");
INSERT INTO aly_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Ra ngenh ilanthew, atweyew apmwa yanh-rnem Amalek-areny-rnem. Ngenh ilanthew, renh-rnem ywerrelhelemel atweyew ingkerrenh-antey. ");
INSERT INTO aly_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","Ilekew nga awelhey-angenh ikwer? Ilekew ntwa apmwa mpwarew INGKART-wenh-angkwarr? Ra ngkweng ahelerrew, ntwarl inew ilek-ilek ikwer-rnem-wenh.” ");
INSERT INTO aly_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Saul-el apatemel tyernew, “Ay? Innga ayeng awelhew INGKARTew! Atha mpwarew, rarl ayenh ilanthew-angkwarr! Atha atwew ingkerr; artwa, arelh, ampethen. Atyetyart Agag-then atha akngey-alpew iteth-antey. ");
INSERT INTO aly_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Artwa ahawarr-rnemel, rernem inew atnwenth mwerr-rnemant ikwer-rnem-wenh! Yep-yep-then pwelek-rnem-then rernem akngey-alpew, ntwaw arrtyeyew INGKARTew apmer nhenh-itwew Gilgal-itwew.” ");
INSERT INTO aly_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Samuel angkew, “INGKART ilkelhem, angka ikwerenhew-tangkwel awelh-aynteyew. Aker pwelhew ra ilkelhem alyepant. Anter pwelhew ra ilkelhem alyepant. Ikwerarl awelhemewant ra inkwerelhem. ");
INSERT INTO aly_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Ntwa iterl-aremer, ingwerenty awelhey-angenh INGKARTew, rap apmwa inngarl mpwarem. Apmwarlap alakenhan, inweng apmwa ayernenty-apeny. Ingwerenty tangkemel anenty, INGKARTan ikwer inkwerelhey-angenh. Apmwarlap alakenhan, ampwal-rnemewarl kwenerreyel-apenyarl arwerl-penhew apwert-penhew. Nga awelhey-angenh angka INGKART-wenhew, rap ngkweng-wety intwemelerrew arrpemarl. Nga atyetyart apmwanem irrew Israel-wenh-rnemew! Ngarl apmwelhelew-wety, INGKARTel ilew, ‘Nthakenh nga atyetyart aney-angenh-anem, arrangkw.’” ");
INSERT INTO aly_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","Saul angkew, “Ayeng-antey apmwelhelew. Awelhey-angenh INGKARTew ngkweng-then. Ayeng atererrew artwa ahawarr-rnem-wety, ikwer-rnemewant awelhew. ");
INSERT INTO aly_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","Athan ngenh ayernem, ahelerrey-angenh atyeng. Alpey-angenh atyeng-wety. Apey-alpa atyeng-itwel atyenh-rnem-warl. Ayeng INGKARTewant kwenerremel angkaynteyew.” ");
INSERT INTO aly_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","Samuel-anap alakenharl ikwer angkew, “Ngan awelhey-angenh INGKARTew. Nthakenh ayeng alpey-angenh ngkweng-itwel. Ngan awelhey-angenh INGKARTew, rap ngkweng awelhey-angenh arrpemarl. Nga atyetyart apmwanem irrew! Ngarl apmwelhelew-wety, INGKARTel ilew, ‘Nthakenh nga atyetyart aney-angenh-anem, arrangkw.’” ... ");
INSERT INTO aly_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Ingwer-ingweran INGKART angkew Samuel-ew, “Samuel-ay! Saul ra atyetyart apmwanem. Athan renh alpemeley-angenh-anem. Ilekew nga amperrngerreyel ikwer? Pweterl anter alip-akert ina. Alhanem, artwamp Jesse areyew apmer Bethlehem-itwew. Alerikw anyent ikwerenh atha rlwanew, atyetyart aneyew, menty-anemarl Saul-an.” ");
INSERT INTO aly_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Samuel-an angkew, “Nthakenh atha alakenh arnwarney-angenh! Ingwerentyel Saul ilewerr, ra ayenh ipmew atwewerr!” INGKARTan angkew, “Kapey-kapey akngeyna. Alakenh angkey-alha Bethlehem-areny-rnemew, ‘Atha arrtyemel antheyew kapey-kapey nhenh INGKART-warl.’ ");
INSERT INTO aly_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Artwamp Jesse ila, ra alerikw ikwerenh-rnem-akert apetyeyew, aker arlkweyew. Athap ngkweng ilem, artwa nthek-apeny atha rlwanewan, ntwaw theleyew anter alip ikwer-warl akapwert-warl. Alakenh-anyem atha renh rlwaneyew atyetyart arrwekel-antey.” ");
INSERT INTO aly_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Samuel awelhew, INGKARTarl angkew-angkwarr, rap anperl-alhew-anem Bethlehem-warl. Ra aremerrey-alhew apmer ikwer-itwew, artwamp-rnem arnekerrey-ayntew ikwer, arrewemel atererremel. Rernemap ayerney-ayntew, “Nga apetyew, angka mwerr-angker ileyew? Arrangkw apek?” ");
INSERT INTO aly_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Samuel-el tyernew, “Ya, ayeng inkwerelhemel apetyew, kapey-kapey nhenh arrtyemel antheyew INGKARTew arrewantherr-itwel. Arrewantherrenh-rnem ilenh-arey arnwarnelheyew, anantherraw kapey-kapey ingkerrenhel arrtyeyew INGKARTew.” Artwamp renh Jesse ra ilew arrpemarl alerikw ikwerenh-rnem-then. Rap renh-rnem alpemelew arnwarnelheyew. ");
INSERT INTO aly_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Ingkerrarl akarrerrew, Samuel-el arew alerikw alkenh Jesse-wenh, itnan Eliab. Rap iterrew, “Nhaym apekarl ran, INGKARTelarl rlwanewan.” ");
INSERT INTO aly_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","INGKARTan angkew Samuel-ew, “Nhenh-weny. Atha yanh rlwaney-angenh. Ya, atha iterl-areyel, ran arlpenty rlterrkarl. Kel artwernem arrantherr alakenh iterrem. Atyenh-angkwarran alakenharl; atha renh kanper iterl-areyel.” ");
INSERT INTO aly_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Samuel-el Jesse ayernew, alerikw ingwer-anem ikwerenh thweneyew Abinadab. Rap apetyew. Samuel-an angkew, “INGKARTel nhenh rlwaney-angenh.” ");
INSERT INTO aly_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Jesse-el thwenew Shammah-anem. Samuel angkew, “Arrangkw. INGKARTel yanhan rlwaney-angenh arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Jesse-el 7 ingkerrenh anyentarl-anyentarl rnkerneynew Samuel-angkwarr. Rap angkew, “INGKARTel rlwaney-angenharl nhenh-rneman.” ");
INSERT INTO aly_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Samuel-elap ayernew, “Alerengkw ingwer apek ngkwenh aneyel?” Rap tyernew, “Ya. Alerey akely David-anem, ranap peleyn-itwew yep-yep-rnem arntarnt-areyel.” Samuel angkew, “Ingwerenty thwena, renh ingwerleweyew. Anantherrap ikwer-tangkwel mpwelhem. Nthakenh arlkwey-angenh amentel.” ");
INSERT INTO aly_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Jesse-el thwenew ingwerenty, David ingweyew. Renhap ingwerl-alpew, ranap artwa mwerr-angker akely. INGKART angkew Samuel-warl, “Nhanyemart ran! Rtnerl-alhanem! Anter alip thelanem akapwert-warl!” ");
INSERT INTO aly_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Rap inew anter alip pweterl-akert, thelemel David-warl akapwert-warl. Awayikw ikwerenh-rnemelan arenh. Arlta ikwer-penhan David rlterrk-anem anew Inweng INGKART-wenh-akert. Samuel ra alpew-anem apmer ikwerenh-warl Ramah-warl. ");
INSERT INTO aly_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Inweng INGKART-wenh alpew-anem atyetyart Saul-they. INGKARTelan inweng apmwanem thwenew, Saul renh alhengkerr-antheyew. ");
INSERT INTO aly_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","Warrkenh ikwerenh-rnem angkew ikwer, “Atyetyartay! Anantherr areyel, INGKARTelarl inweng apmwa ngkweng-warl thwenew, ngenh alhengkerr-antheyew. ");
INSERT INTO aly_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","Anantherr alhem, artwa ingwerenty ingweyew, ampwal weth-lkwer ketay-apeny pelayerreyew ngkweng. Inweng apmwel ngenh alhengkerr-anthem, ra ampwal ngkweng pelayerrem, ngap mwerr-anemarl awelhem.” ");
INSERT INTO aly_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Saul angkew ikwer-rnem, “Ya, artwa mwerrew nthweyew alhenh-arey, ampwal mwerr pelayerrey-angkerew, akngetyemel atyeng-warl.” ");
INSERT INTO aly_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","Warrkenh anyent angkew, “Atha iterl-areyel artwamp anyent Bethlehem-areny itnan Jesse-arl. Alerikw anyentan ikwerenh akaltyarl, ranap artwa mwerr-angker akelyarl. Ra anaynt angkem, ranap ater-weny arnkatyarl. INGKART arrer innga anem ikwer-itwel.” ");
INSERT INTO aly_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","Saul-el angkakert thwenew Jesse-warl, alakenh angkeyew, “Atyetyart Saul ra ilkelheyel, ntwa alerengkw David yep-yepew-artey thweneyew ikwer-warl.” ");
INSERT INTO aly_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","Jesse-elan tangkey inew, rap amern akngerr tywenew ngkwarl-then, arranty nanikwet yenp-penh-akert. Rap alerikw ikwerenh ilew, alheyew apmer Saul-wenh-warl, tangkey-then nanikwet akely-then akngemel. ");
INSERT INTO aly_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","David rap warrkerrenh Saul-ew-anem. Saul-an ikwer ilkelhew artewenty. Rap renh ilanthew, irrtyart-then alkwert-then ikwer katy akngaynteyew, Israel-wenh-rnemarl werrenh ingwer-rnem-then. ");
INSERT INTO aly_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","Saul-el thwenew angkakert Jesse-warl arrpemarl, alakenh angkeyew, “Saul David-ew ilkelheyel artewenty. Menty anaynteyew, ikwer warrkerr-aynteyew.” ");
INSERT INTO aly_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","Akngerr-inger INGKARTel thwenew inweng apmwa, Saul alhengkerr-anthaynteyew. David pelayerrerl-aynenh ampwal ikwerenh, inweng apmwa irrentenh. Saul ra mwerr-anem awelhenh. ");
INSERT INTO aly_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","Ingwer-ingweran Philistia-areny-rnem akarrerrew apmer Socoh-itwew Judah-ampeny-itwew, werreyew Israel-wenh-rnem-then. Rernem ayntey-alhew apmer ingwer-itwew, Socoh arrerenty. ");
INSERT INTO aly_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","Saul-el Israel-wenh-rnem akarrelew, rernemap ayntew peleyn-itwew apmer Ila-itwew. Ikwer-itwew rernem arnwarnelherrew, atwerreyew Philistia-areny-rnem-then. ");
INSERT INTO aly_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","Apwert anyent arrer-antey arrpemarl ayntenh. Rernemap peleyn-they alpew apwert ikwer-warl. Ikwer-they rernem arew, ingwer-rnemelan renh-rnem arntarnt-arenh apwert ingwer-ampeny-theyarl. ");
INSERT INTO aly_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","Artwa ahawarr anyent Philistia-areny itna Goliath anenh, ranap apmer Gath-areny. Artwa arlpenty ilkwa inngarlap ran. ");
INSERT INTO aly_vpl VALUES ("S117_5","010_17_5","1SA","17","5","6","Aheng-areyan ra aylpenh ampwalel ilek-ilek-warl, arlka ilpelheyew-arelh. Ampwal-rneman awerr innga, ayen-penh arnwarnew. Ingwerelan akapwertarl ilpelhenh, ingwer-atherran arlaw aylpeyew-arelharl. Arneltyarl ingwerelan ilpelhenh, ranap awerr inngarl. Ra irrtyart atherr akngenh, akarteng-then arlpenty-then. Irrtyart akartengan ayen-penh arrpemarl, rap piltel antwerrkerl-apenh arety-angkwarr. ");
INSERT INTO aly_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","Irrtyart arlpentyan arrwekel-ampeny arreylparl ayen-penharl. Ranap awerr innga arrpemarl. Artwa ahawarr ingweran alhenh arrwekel, alkwertarl ikwer katy akngenh. ");
INSERT INTO aly_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","Arlta arrpanenhel ra alhenh ampep-warl, arlkey-alhenh atayel Israel-wenh-rnemew alakenh, “Israel-wenh-rnemay! Ilekew arrantherr mpwelheyel? Arrantherr ahawarr-arrpantey! Ayenh arenh-arey! Ayengan ahawarr inngarl Philistia-areny! Arrantherran arwa Saul-wenh warrkenh-rnem! Artwa anyent-anem rlwanenh-arey thwenemel, aylanthaw atwerreyew! ");
INSERT INTO aly_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Ra ayenh ipmew atwenty, anantherr ingkerrenh alpem Israel-warl, arrewantherr warrkerrey-alpeyew. Atha renh ipmew atwenty, arrantherr Philistia-warl alpem, anewantherrarl warrkerrey-alpem. ");
INSERT INTO aly_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Arrwekel-antey arlka alpwelyerrey-angenh! Thwenenh-arey artwa anyent atyeng-warl, aylanthaw atwerreyew!” ");
INSERT INTO aly_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Saul-el Israel-wenh-rnemel-then awew, rernemap atererremel apateyelpew. ... ");
INSERT INTO aly_vpl VALUES ("S117_15","010_17_15","1SA","17","15","16","Arlta arrpanenhel ingwepenh atwerrp artwa arlpenty ra angkey-ayntenh alakenh arlta 40-ew-atety. David-an alperl-arrernenh Saul-wenh apmer-they aynikw-wenh apmer-warl, yep-yep-rnem arntarnt-araynteyew aynewikw-wenh-then. ");
INSERT INTO aly_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","Ingwer-ingweran aynikw ikwerenh angkew, “Yakweth nhenh ina ntang ampeng-akert, rtamp-rnem 10-anem. Aknga awayewengkw-rnem. ");
INSERT INTO aly_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","Aker cheese-rnem 10 aknga, anthemel atyetyart ahawarr-rnemew. Anamerl! Ayeng artewenty iterremel amperrngerreyel awayewengkw-rnemew. Angka akngey-alpa ikwer-rnem-wenh. Atha iterl-areyew, rernem mwerr-antey aneyel. ");
INSERT INTO aly_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","Alha apmer peleyn-warl Elah-warl. Anewantherrenh-rnem-then Saul-akerr werreyel Philistia-areny-rnem-then peleyn ikwer-itwew.” ");
INSERT INTO aly_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","David awelhew aynewikw. Rap artwa ingwer-tangkwel arrernerl-alhew, yep-yep-rnem arntarnt-araynteyew. Ingwepenh ingwerelan ra ampwal-rnem tywenerl-alhew tangkey-warl, rap anpenhew-anem. Rarl aremerrey-alhew peleyn ikwer-itwew, rap arey-alhew, artwa ahawarr-rnem mpwelhenh, werreyew-anem. Rernem arlkalhelerrenh arnkatyelhelemel. ");
INSERT INTO aly_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Israel-wenh-rnem-then Philistia-areny-rnem-then rernem rtnemel arerrenh. ");
INSERT INTO aly_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","David-el anthenhew ampwal-rnem artwa amernarl arntarnt-arenhew. Rap anterrew, ahawarr-rnemarl rtnenh-warl, awayikw ikwerenh-rnem areyew. ");
INSERT INTO aly_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","Rap angkey-alhew ikwer-rnemel-arleng. Artwa arlpenty Goliath ra alhew ampep-warl apmelerr-angkwarr, atayel angkerl-apenh. David-el renh awew, alakenharl angkenh. ");
INSERT INTO aly_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Israel-wenh-rnemelan renh arew, rernemap anterrew aterel ikwer-wety. ");
INSERT INTO aly_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","Rernem arrwekel-antey alakenh angkerrenh, “Arlta arrpanenh ra apetyeyel, kwanth-aynteyew arrkentelhelemel anenhantherrenh. Artwa anyentel anewantherrenhel renh ipmew atwenty, Saul-el renh apwert akngerr anthem, kwey alerikw-then ikwerenh anthemel. Artwa apwert akarreley-angker-rnemel nthakenh ikwerenh-rnem iley-angenh-anem, Atyetyart Saul-ew apwert antheyew.” ");
INSERT INTO aly_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","David angkew artwernemew, arrerarl ikwer-angkwarr rtnenh-rnemew, “Artwa yanhel anenhantherrenh nyerrel-antheyel. Ingwerentyel renh akeleytelemer. Ilekarl Saul-el anthem, ra artwa renh ipmew atwentyewan? Nthakenh ra arrkentelheley-angenh artwa ahawarr INGKART-wenh-rnem, Akngey inngewenh-rnem, arrangkw!” ");
INSERT INTO aly_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","Rernem renh ilew, rernemarl angkerrew-angkwarr arrwekel-antey. ");
INSERT INTO aly_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","David-wenh awayikw alkenh Eliab ra awew, rap ahelerrew ikwer. “Ilekewarl ngaw apetyew? Yep-yep irrpetyap akely weth-rnem-alew? Angwenhel renh-rnem arntarnt-areyel aleyan? Ngan apmwelheleyel! Ilekew nga arrkernelheyel ilkwarrpantey? Nga arrkent apetyew arwa, araynteyew werreyelarl!” ");
INSERT INTO aly_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","David-el ayernew, “Ilekew ntwa ayenhan ilteyel? Ilekel ayengan apmwelhelew? Arwarl athan ayerneyel!” ");
INSERT INTO aly_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","Rap artwa ingwer-anem ayernew, “Ilekarl Saul-el anthem, ra Goliath renh ipmew atwenty?” Artwa ra ilew, rernemarl arrwekel-antey angkerrenh-angkwarr. ");
INSERT INTO aly_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Ingwerenty alhew-anem, Saul renh ileyew, David-arl angkew-angkwarr. Saul-el artwa anyent-anem thwenew, David ingweyew. ");
INSERT INTO aly_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","David angkew ikwer, “Atyetyartay! Nthakenh anantherr atererremel aney-angenh artwa yanh-wety! Ayeng alhem. Atha renh amentel-antey atweyew.” ");
INSERT INTO aly_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Saul-elan tyernew, “Arrangkwarl! Nthakenh ntwa renh atwey-angenh! Ngan artwa akelyarl, ran ahawarr arnkatyarl, akelyank anew ahawarr.” ");
INSERT INTO aly_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","David-an angkew, “Yep-yep aynaty-wenh-rnem atha arntarnt-arem. Layenel yep-yep anyent apek antwerrkem, iytarr-akngemel arlkweyew, payel apek. ");
INSERT INTO aly_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","Atnwenth ahelengkw atha alwernem atwemel, yep-yep tyarleweyew-atety. Ra atyeng arrkernelhem thnweyew, alherremel. Atha renh antwerrkem altethey, atwemel ipmew. ");
INSERT INTO aly_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Akngerr-inger atha atwew layen-then pay-then. Athap ahelengkw yanh Philistia-areny atwem irrkaty-angkwarr, rarl nyerrel-antheyel ahawarr Akngey-wenh-rnem. Akngey rant anyent alkenh aneyel. ");
INSERT INTO aly_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","INGKARTel ayenh arntarnt-arew atnwenth ahelengkw-rnem-wety, rap ayenh arntarnt-arem arrpemarl artwa ahelengkw yanh-wety.” Saul-an angkew ikwer, “Kel. Alha, atwerreyew mpwelanth, INGKARTel ngenh arntarnt-aremarl.” ");
INSERT INTO aly_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Aheng-areyan Saul aylpenh ampwalel ilek-ilek-warl, arlka ilpelheyew-arelh. Ampwal-rneman awerr innga, ayen-penh arnwarnew, rap anthew David-ew, raw aylpeyew. Rap ampwal ikwer anthew, ayen-penh arrpemarl, akapwert ilpelheyew-arelh-then. ");
INSERT INTO aly_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","David aylpew-anem, rap piltel arertnelhew, nayp arlpenty Saul-wenh arrernemel. Ngwampant ra ampwal awerr yanh-lkwerelan aylpew, renhap alhey-angenhelew. Rap angkew Saul-ew, “Nthakenh ayeng alhey-angenh alakenh. Ayengan nhelkwer-warl aylpey-angenh.” Rap lhelew, ");
INSERT INTO aly_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","irrertety ikwerenh inew ampwal tyangay-apeny yenp-penh-then, anpenhew-anem. Ilpay-itwew ra akwetyew apwert alyelk-rnem 5, yakweth-warl akwernemel. Rap alhew artwa Philistia-areny ikwer-warl-anem. ");
INSERT INTO aly_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Goliath alhew arrpemarl ikwer-warl. Ahawarr ingwerelan alkwertarl katy akngeynenh arrwekel. Ratherrap David-an arrerelhew. ");
INSERT INTO aly_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","Artwa arlpenty ilkwel atherremel David arrkentelhelew, “Ngan artwa akelyarl! ");
INSERT INTO aly_vpl VALUES ("S117_43","010_17_43","1SA","17","43","44","Ilekew nga arwerl-akertan apetyeyel? Arengkang ayengan ngkweng? Kel apetya! Atha ngenh ipmew atweyew, thipel-then atnwenth ahelengkw-rnemel-then ngenh arlkweyew! Atha ngenh ilwerl-athenem!” Rap altyerr ikwerenh-rnem ayernenh, David atweyew. ");
INSERT INTO aly_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","David-el tyernew, “Nga apetyeyel, ayenh atweyew nayp arlpenty-akert, irrtyart atherr-anem. Ayenganap alhem ngkweng-warl, ngenh atweyew, INGKART Atyetyart Ilkwa Ingkerrenhel rarl ayenh thwenew. Rant rlterrk anyent aneyel. Renhant ahawarr Israel-wenh-rnemel apentemarl. Ntwanap renh arrkentelhelewarl. ");
INSERT INTO aly_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","Rlengkanap ayenh alpemelem INGKARTel, ngenh atweyew. Athap ngenh athenemel atweyenh, ahenty-then akerrth-arternemel. Rlengkan arrantherr Philistia-areny-rnem ipma aynteyenh, thipel-then atnwenth ahelengkw-rnemel-then arrenhantherrenh arlkweyenh! Alakenh ingkerrel iterl-areyew, Akngey Israel-areny rant anyent inngan. ");
INSERT INTO aly_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","Anantherr akngerr akarrerrewel iterl-areyew, INGKARTel ikwerenh-rnem arntarnt-arem ikwerenh-angkwarr. Nayp arlpenty-akert irrtyart-then-akert nthakenh renh alpemeley-angenh, arrangkw. Anantherran ikwerenh-rnem, ament-wenyarl, anantherrap arrenhantherrenh ywerrelheleyenh ingkerrenh!” ");
INSERT INTO aly_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Goliath retangkwel alhew, David atweyew. David-an anamerl-antey anterrew ikwer-warl, ");
INSERT INTO aly_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","apwert-anem tyerrenhew yakweth ikwerenh-they. Tyangayel ra wew renh rlwantey, ngkwernan iltewew akapwert-itwew. Goliath-an atnertel-ayeth aytnew ahern-warl, ayntey-alpew-anem. ");
INSERT INTO aly_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","Alakenh David-el artwa Goliath renh ipmew atwew. Nayp arlpentyel ra atwey-angenh, arrangkw. Ra apwert tyangay-akertel renh wew. ");
INSERT INTO aly_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","Rap anterrew ikwer-warl, rtney-alhew ikwer-itwew irrwerleng. Goliath-wenh pilt-they ra tyerreyelpew nayp arlpenty, ahenty-anem akerrth-atwew renh, arlkethen akapwert-then atherreleyelpew. Philistia-areny-rnemel arew, ahawarr ilkwa ikwer-rnem-wenh aynterl-anenty, rernemap anterrerrew. ");
INSERT INTO aly_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","Israel-wenh-rnemel renh-rnem ingkern-they alwernew, arlkemel atayel. Iwerr Shaaraim-angkwarr alwernew apmer Gath Ekron-then ikwer-atherrew-atety. Ipma akngerr aynteynenh iwerr ikwerel. ... ");
INSERT INTO aly_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","David-el artwa arlpenty Goliath ipmew atwew-penh, Israel-wenh-rnem ingkerr alperlewenh apmer-warl. Apmer arrpanenh-they arelh-rnem apetyew, renh-rnem rlwateyew, rntweynenh aylelheynenh inkwerelhemel. Ingwer-rnem teram akely pelayerrenh, ingwer-rneman ampwal ketay-apenyarl pelayerrenh. ");
INSERT INTO aly_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Rernem alakenh aylelherl-apenh: “Saul-el ahelengkw akngerr atwew, David-elan ahelengkw akngerr inngarl atwew!” ");
INSERT INTO aly_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Saul-el awew, rap ahelerrew artewenty innga. Ra iterrew alakenh, “Rernem angkeyel, David-elan ahelengkw akngerr inngarl atwew atyeng-angkwarr. Atyetyart apek renh arrerneyew arrkernelheyel.” ");
INSERT INTO aly_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Ikwer-theyan rap alharlkwemel renh arntarnt-arenh intem-antey. ");
INSERT INTO aly_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","Arlta ingwerelan INGKARTel inweng apmwa arrpemarl thwenew Saul-warl. Ra artewentyel arwengkerrenh, warl kwenel anenh, arlkenty iwenh. David-an ampwal ketay-apeny ikwer pelayerrenh apmelerr-angkwarr. Saul-el ran irrtyart atnyenenh itepel, ");
INSERT INTO aly_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","rap iwew, alakenh iterremel, “Arnelty-angkwarr atha renh akwerterrp atantheyew!” David-an arnangerrew anamerl-antey irrtyart-wety. Atherr-inger ra renh atantheyew-anew. Atherr-inger David anamerl-antey ikwer-wety arnangerrew. ... ");
INSERT INTO aly_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","Ingwer-ingweran Saul-el alerikw ikwerenh Jonathan ilanthew warrkenh ikwerenh-rnem-then, “David ipmew atweyew!” Alerikwanap David-ew artewentyelarl ilkelhenh, ");
INSERT INTO aly_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","rap David ilew, “Aynatyan arrkernelheyel, ngenh ipmew atweyew! Anterra, irrtyert-aylpeyew katen-itwew! Arntarnt-arelha ingwelarreng ingwepenh. ");
INSERT INTO aly_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","Atha aynaty atnwenhey-alhem katen ikwer-warl, ngarl irrtyert-aylpem-itwew. Ayengap angkemarl ikwer-warl ngkweng-they. Rarl alpem-penh, athap ngenh ilem, rarl angkew-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","Ingwepenh Jonathan aynikw ikwerenh-then rtnenh katen ikwer-itwew, David-ew angkerrenh. Jonathan-el ra David-akert mwerrarl ilenh alakenh, “Nthakenh ntwa apmwa mpwarey-angenh ikwer. Ra apmwelheley-angenharl ngkweng. Ilek-ilek mwerr-angker mpwarew ngkweng, ngenh alpemelemel. ");
INSERT INTO aly_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","Ra artewenty iterrey-angenh, ipmew atwewerran, arrangkw. Rap arnkatyel artwa ilkwa Philistia-areny ipmew atwew. INGKARTel inngarl Israel-wenh-rnem alpemelew ikwereng-arey. Ntwan arew arrpemarl, ngap inkwerelhew. Ilekewarl nga iterrew, renh ipmew atweyewan?” ");
INSERT INTO aly_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","Saul awelhew alerikw ikwerenhew Jonathan-ew. “INGKART aweyel-wety, ayeng ngkweng arraty angkew. Ayeng arrkernelhey-angenh, David ipmew atweyew!” ");
INSERT INTO aly_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","Saul rarl alpew-wety, antengan Jonathan arlkew David-ew, tyerrelheyew. Rap renh ilew, aynikw ikwerenharl angkew-angkwarr. Ratherrap Saul ikwer-warl-anem alhew. David ikwer warrkerrenh arrpemarl angkep. ");
INSERT INTO aly_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","Ingwer-ingweran Philistia-areny-rnem apetyew arrpemarl, atwerreyew Israel-wenh-rnem-then. David ran atyetyart ahawarr-anem anew, rap Philistia-areny akngerr atwew. Ingwer-rneman aterel anterrerrew arleng. ");
INSERT INTO aly_vpl VALUES ("S119_9","010_19_9","1SA","19","9","10","David alpew apmer Saul-wenh warl-anem, ikwer warrkerreyew. Ingwer-ingweran Saul-warl INGKARTel inweng apmwa thwenew arrpemarl. David-an apmwal ketay-apeny pelayerrenh apmelerr-angkwarr. Saul-elan irrtyart arrpemarl atnyenenh itepel, rap iterrew, renh atantheyew arnelty-angkwarr akwerterrp-antey. Irrtyartel warlant atwew. David-an anterrew mwerr-antey ikwer-wety. ");
INSERT INTO aly_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","Saul-el artwernem thwenew, warl David-wenh arntarnt-areyew ingwel, ingwepenh renh ipmew-anem atweyew. Akelty ikwerenhel Michal-el renh ilanthew, “Anamerl anterra ingwel-antey! Mpwelhey-angenh! Ingwepenh rernem ngenh ipmew atwey-ayntewerr!” ");
INSERT INTO aly_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","Rap renh rwepel atwarrelhelew wintew-angkwarr, rap mwerr-antey irrtyert-anterrew. ... David-an anterrew artwamp Samuel-wenh apmer-warl Ramah-warl. Saul-el awew, rap alhew, nthweyew ikwer apmer ikwer-itwew. ...  ");
INSERT INTO aly_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","Ikwer-they David irrtyert-anterrew apmer Naioth-they Ramah-ampeny-itwew. Ra alhew Jonathan-wenh apmer-warl, renh ayerneyew, “Nthakenh irrew ayeng? Ilekel ayeng apmwelhelew? Ilek-wety aynelengkw ayenh ipmew atweyew nthweyel?” ");
INSERT INTO aly_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","Jonathan-el tyernew, “Arrangkwarl! Nthakenh ngenh ipmew atwey-angenh! Aynelaty ayenh iley-angenh, ra ilkelhenty, ngenh atweyew. Ra ayenh ilem-tangkwel, rarl ilkelhem-angkwarran. Ikwerenh-angkwarran. Nthakenh ayenh irrtywerremel iley-angenh. Apalarl nga angkeyel, inngeweny!” ");
INSERT INTO aly_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","David-el renh akeleytelew-anem. “Aynelengkw iterl-areyel, aylanthan arrerant-atherr mpwernenheng-atherr-anemarl. Ra alakenh iterrewerr, ‘Nthakenh alerey iley-angenh. Arlka ra apmwerrewerr!’ Awelha atyeng! Innga wenh! Rlengk-antey ayeng ilwem apek!” ");
INSERT INTO aly_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","Jonathan angkew, “Kel, ngarl iterreyel. Nthakenh irrem ayeng ngkweng aleyan?” ");
INSERT INTO aly_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","David angkew, “Ingwelarreng akngerran akarrerreyenh, INGKARTew angkaynteyew inkwerelhemel alkent ingkayltel apmelerrel-ayeth. Akngerr akarrerreyenh apmer aynewengkw-wenh-itwew, kwenty arlkwerreyew. Ayenh-then ra ilew, ikwer-itwew arlkweyew. Ayeng ingwa atherrel irrtyert-aneyew-tangkwel katen-itwew. Mwerrang alakenhan? ");
INSERT INTO aly_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","Aynelengkw atyeng ayernenty, ila renh alakenh: ‘David-el ayenh ayernew, “Mwerrang ayeng alheman apmer Bethlehem-warl? Aherrety arrpanenh atyenh-rnem akarrerrem arrpemarl apmelerr-angkwarr apmer ikwer-itwew, aker arrtyeyew INGKARTew.” ’ ");
INSERT INTO aly_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","Aynengkw angkentyan, ‘Mwerr,’ kel mwerrarl. Ra ahelerrenty, ntwa iterl-ararl, ra iterreyel, ayenh ipmew atweyewarl.” ... ");
INSERT INTO aly_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","David alhew-anem, irrtyert-aylpeyew katen-itwew. Arlta ingwerelan akngerr akarrerrew apmer Saul-wenh-itwew. Saul-an anenh, amern arlkwemel ");
INSERT INTO aly_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","chair ikwerenhel irrkaty-angkwarr, alerikw-warl-athek. Atyetyart ahawarr itna Abner anenh arrpemarl Saul-awa. David-ant ywerrew. ");
INSERT INTO aly_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","Saul-el arenh akeleytel, ingwerenty ayerney-angenh-antey. Rap iterrenh ament-antey, “David apekan arnwarnelhey-angenh-anteyarl, apetyeyew nhewarl. Ra apek ilek-ilek mpwarenh, nthakenh alhewer apetyey-angenh-antey.” ");
INSERT INTO aly_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","Arlta ingwerelan Saul-el ikwer arew arrangkw-antey arrpemarl. Rap alerikw ikwerenh-anem ayernew, “Ilek-wety David-an aneyel, apetyey-angenh? Apmwerrkelan ra apetyey-angenh arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","Alerelikw tyernew, irrtywerremel alakenh ilemel, “David-el ayenh intem-antey ayernew, renh tyarleweyew, Bethlehem-warl alheyew. ");
INSERT INTO aly_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","Ra angkew, ‘Aherrety arrpanenh atyenh-rnem akarrerrem apmer ikwer-itwew, aker arrtyeyew INGKARTew. Awayaty atyenh yangkelhew, ayeng alheyew ikwer-rnem-warl. Ngan mpwernaty atyenharl, ntwap ayenh tyarlewemer, alheyew awayaty atyenh-rnem areyew.’ Alakenh ra angkew, nthekwern apetyey-angenh, amern arlkweyew ngkweng-itwel.” ");
INSERT INTO aly_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","Saul ra artewenty innga ahelerrew alerikw ikwerenhew, rap renh alakenh iltew, “Amengkw ngkwenh apmwa anenh, ngan rapeny arrpemarl! Atha iterl-areyel, ngarl awelheyel Jesse-wenh alerikwew, atyeng awelhey-angenh! Nyerrelarl alakenhan, amengkw-then nyerrel-anthem ntwa! ");
INSERT INTO aly_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","David iteth-antey anenty, nthakenh nga atyetyart Israel-itwew aney-angenh. Rlengk-antey artwa thwena, renh ingwerl-alpeyew atyeng. Nthakenh ra iteth aney-angenh!” ");
INSERT INTO aly_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","Jonathan-el aynikw ikwerenh ayernew, “Ilek-penh ra ilwem? Ilekel ra apmwelhelew?” ");
INSERT INTO aly_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","Aynelikw awew, rap irrtyart ikwer-warl iwew, ipmew renh-anem atantheyew. Alerikw ra anamerl-antey arnangerrew irrtyart-wety. Rap iterl-arew-anem, aynikw ikwerenharl ilkelhew, David ipmew atweyew. ");
INSERT INTO aly_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","Rap ahelerremel rtnerl-alhew, aketh-warl-anem tyerrelhenhew. Arlta ikwerelan ra amern arlkwey-angenh irrew, arlkarl apmwerrew. Arlka alpwelyerrew, aynikwarl ahelerrew David-ew artewenty. ");
INSERT INTO aly_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","Ingwepenh ra alhew katen-warl, David-ew angkeyew. ... ");
INSERT INTO aly_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","... David tyerrelhey-ayntew-anem apwert-rnem-they. Irrpety-inger kwenerrew ra Jonathan-warl-athek. Ratherr arrwantyerrew arreyl atherr-angkwarr Jew-rnem-wenh-angkwarr. Jonathan artnew ikwer, David ran artnew arrpemarl artewentyel. ");
INSERT INTO aly_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","Jonathan angkew, “Alpanem mwanty-antey. INGKARTel ngenh arntarnt-arem. Aylanthan mwerrant-atherr anem intem-antey. INGKARTel aweyel, aylantharl alakenh angkeyel. Rap alpemelem ngkwenh-rnem atyenh-rnem-then mwerrant-arey anaynteyew intem.” David anperl-alhew-anem, Jonathan alpew arrpemarl apmer-warl. ");
INSERT INTO aly_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","Ikwer-penh David alhew apmer Nob-warl, areyew artwamp ingkart itnan Ahimelech. Artwamp rarl renh arey-alhew, rap atererremel arrewew ikwer-wety. Rap renh ayernew, “Ilekew ngan apetyew amentan? Nthekarl artwa ahawarr ngkwenh-rneman? Ilek-penh ngan?” ");
INSERT INTO aly_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","David-el tyernew irrtywerremel, “Atyetyart Saul-el ayenh thwenew, irrtyertel-antey warrk ikwer mpwareyew. Nthakenh atha iley-angenh, rarl ayenh ilanthew-angkwarr. Artwa ahawarr-rneman atha ilew, arrwekel alheyew, apmer ingwer-itwew ayenh rlwateyew. ");
INSERT INTO aly_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","Amern apek ntwa atnyeneyel? Antha atyeng. Rtamp-rnem irrpetyap apek? Amern ingwer-rnem apek antha.” ");
INSERT INTO aly_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","“Rtampewan ayeng arrangkwarl. Amern weth-lkwer nhenhant tyenkerrew-arelh. Artwa ingkartelant arlkwey-angker. Nga artwa ngkwenh-rnem-then arelh-rnem-wety amenterrenty, mwerrarl atha anthem.” ");
INSERT INTO aly_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","David angkew, “Ya! Alakenh arrpemarl anantherr irrem, atyetyart ilkwewarl warrkerreyelelan. Anantherr kel-antey arelh-rnem-wety amenterrew.” ");
INSERT INTO aly_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Rap renh amern tyenkerr anthew, rtampew arrangkwel. Amern apmwerrkeny ra anthew. Amern rlengkenyan ayntenh-antey taypel INGKART-wenh-itwew. ");
INSERT INTO aly_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","(Ikwereng-arey artwa warrkenh anyent Saul-wenh anenh arrpemarl itnan Doeg, apmer Edom-areny. Ra INGKARTew kwenerremel angkenh. Ranap yep-yepew-artey rltwarl, rap awenh, David-arl angkenh artwamp ingkartew.) ");
INSERT INTO aly_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","David angkew artwampew, “Arrangkw-anteyarl ayeng apetyew, ampwal-rnem iney-angenh-antey. Atyetyartel ayenh ilew, anamerl-antey alheyew. Irrtyart apek ntwa atnyeneyel? Nayp arlpenty apek?” ");
INSERT INTO aly_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","Ra tyernew, “Ya, nayp arlpenty yanhan artwa Philistia-areny-wenh Goliath-wenh. Ntwa renh ipmew atwew apmer peleyn Ila-itwew. Arrangkw-anem ingwer atnyeney-angenh. Nga ilkelhentyelan aknga. Pantyelarl artelheyel aynteyel, arnkwa artwa ingkart-wenh arrerenty.” David-an angkew, “Mwerr-angkerarl yanhan ingwer-rnem-wenh-angkwarran! Antha atyeng.” ... ");
INSERT INTO aly_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","Artwa weth Edom-areny Doeg ra angkep alpew, Saul iley-alpew, “Atha David arew apmer Nob-itwew. Ran alhew artwa ingkart Ahimelech-warl Ahitub-wenh alerikw-warl. ");
INSERT INTO aly_vpl VALUES ("S122_10","010_22_10","1SA","22","10","10","Ahimelech ra ikwer INGKART ayernew, amern anthemel nayp arlpenty-then Goliath-wenh Philistia-areny.” ");
INSERT INTO aly_vpl VALUES ("S122_11","010_22_11","1SA","22","11","11","Saul-el awew, rap yangkelhew, Ahimelech ra apetyeyew ikwer-warl ikwerenh-rnem-akert. Rerneman artwa ingkart-rnem, apmer ikwer-itwew anenh. Rernem alhew ingkerr Saul-wenh apmer-warl, rarl angkew-angkwarr. ");
INSERT INTO aly_vpl VALUES ("S122_12","010_22_12","1SA","22","12","12","Rerneman aremerrey-alhew, ra angkey-ayntew Ahimelech-ew, “Alerikw Ahitub-wenhay! Awelha atyeng!” Ra tyernew, “Ilek?” ");
INSERT INTO aly_vpl VALUES ("S122_13","010_22_13","1SA","22","13","13","Saul-el ayernew, “Ilekew ngan iterrew, ayenh alakenh irrtywerl-amperneyew? Atyeng-wety rlengkan arlkarerreyel nga. Nga apek iterreyel, Jesse-wenh alerikw atyetyart ilkwa arrerneyew? Ntwa renh alpemelew amernel, nayp arlpenty-then ntwa anthew renh. INGKART-then ntwa ayernew ikwer! Yanhan atyeng-wetyarl arlkarerrewarl. Rap ingwer-ingwer mpwelhem, ayenh ipmew atweyew!” ");
INSERT INTO aly_vpl VALUES ("S122_14","010_22_14","1SA","22","14","14","Artwamp ingkart angkew, “Arrangkw atyetyartay! David inngarl ngkweng warrkerreyel! Artewenty warrkerreyel ingwer-rnem-apeny-weny! Ra malyengkw ngkwenharl, atyetyart ahawarr. Ingkerr apmer ngkwenh-itwew renh ilkelheyel artewenty. ");
INSERT INTO aly_vpl VALUES ("S122_15","010_22_15","1SA","22","15","15","Akngerr-inger atha INGKART ikwer ayernew apmelerr-angkwarr, ngap atyeng ahelerrey-angenharl! Nthakenh ntwa ayenh ayntarrp-iley-angenh atyenh-rnem-then, arrangkw! Anantherr iterl-arey-angenharl, apalarl anenh!” ");
INSERT INTO aly_vpl VALUES ("S122_16","010_22_16","1SA","22","16","16","Saul-an angkew, “Nga ngkwenh-rnem-then ilwem rlengk-antey!” ");
INSERT INTO aly_vpl VALUES ("S122_17","010_22_17","1SA","22","17","17","Rap warrkenh ikwerenh-rnem ilanthew, “Artwa ingkart-rnem ingkerr atwenh-arey ipmew! Rernem awelheyel David-ew, atyeng awelhey-angenharl. Rernem iterl-arew, rarl atyeng-wety anterrenh, atyeng iley-angenh, arrangkw!” Warrkenh-rnemelanap nthakenh INGKART-wenh warrkenh-rnem atwey-angenh. ");
INSERT INTO aly_vpl VALUES ("S122_18","010_22_18","1SA","22","18","18","Saul angkew Doeg-ew, “Kelaw! Ntweteyaym artwa ingkart yanh-rnem ipmew atwa!” Doeg ra apmer ingwer-arenyarl, rap awelhew, Saul-elarl renh ilanthew-angkwarr. Artwa ingkart-rnem 85 ra ipmew atwew. ");
INSERT INTO aly_vpl VALUES ("S122_19","010_22_19","1SA","22","19","19","Ikwer-they ra alhew apmer artwa ingkart-rnem-wenh-warl Nob-warl, rap ipmew arrpemarl ingkerrenh atwew; ampa, arelh, pwelek, tangkey, yep-yep-rnem-then. ");
INSERT INTO aly_vpl VALUES ("S122_20","010_22_20","1SA","22","20","20","Artwa anyentant mwerr-antey anterrew apmer ikwer-they itnan Abiathar. Aynikwan ikwerenh Ahimelech, arrengikwan ikwerenh Ahitub-arl. Ra alpew David-rnem-angkwarr. ... ");
INSERT INTO aly_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","Ingwer-ingweran Saul artwa ahawarr ikwerenh-rnem-akert alhew, rlwaterremel werreyew Philistia-areny-rnem-then. Rernemarl angkep alpewel, ingwerentyel renh alakenh ilew, “David-rneman apmer aterterr-ampeny-itwew aneyel En Gedi-itwew.” ");
INSERT INTO aly_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","Rap akarreleynew artwa ahawarr akngerr apmer arrpanenh-they Israel-ampeny-itwew, 3,000. Rap anpenhew, nthweyew David-rnemew. Nthweynenh apwert-rnem-angkwarr, apmer itnan Nanikwet Akngerr. ");
INSERT INTO aly_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","Ikwer-itwew ra yard yep-yepew-arelh arey-alhew intey-ampenyew. Rap aylpenhew intey-warl-tangkwel iylweylperreyew. David-an artwa ikwerenh-rnem-akertarl arrwekel-antey irrtyert-aylpew intey ikwer-warl akert inngewarl. Intey ran ilkwa innga. Saul apalarl aylpenhew, renh-rnem arey-angenh. ");
INSERT INTO aly_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","Artwerneman arreytenh David-warl, “Ntwa iterl-areyel, INGKART alakenh angkew, ‘Atha ngenh alpemelemarl, ngkweng-warl apmwa mpwarem-rnem atweyewarl. Ntwap mpwarem alhewer ikwer-rnem, nga ilkelhentyelan.’ Ya, ntwap renh ipmew atwemer!” Rap aperteynenh Saul-warl, arnkwanem akert akely ilterrenhew nayp ikwerenhel. Saul-an anenh-antey, awey-angenh-antey. ");
INSERT INTO aly_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","Ikwer-penhan David artewenty-anem iterrew, rarl Saul-ew apmwelhelew-penh. ");
INSERT INTO aly_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","Ra arreytemel angkew, “Nthakenh atha apmwa mpwarey-angenh atyetyart atyenhew, INGKARTelan renharl rlwanewarl, atyetyart ilkwa aneyew Israel-ew. Nthakenh atha renh arnep-arney-angenh, arrangkw.” ");
INSERT INTO aly_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","Alakenharl ra angkew, rap renh-rnem iltew, Saul atwewerr. Saul tyerrelhenhew intey-they aketh-warl-anem. ");
INSERT INTO aly_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","David-el renh alkwernew-tangkwel. Ranemarl tyerrelhenhew aketh-warl intey-they. Rap arlkew ikwer, “Atyetyartay!” Saul-el artepang areyelpew. David-an kwenerremel angkew, ");
INSERT INTO aly_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","“Akngerr ingwer-rnem ngkweng angkeyel, atha akwel apmwa mpwareyew ngkweng. Ilekew nga awelheyel ikwer-rnemewan? ");
INSERT INTO aly_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","Ngwampan INGKARTel aylenhanth pweytelew intey-itwew. Ingwerentyan angkew atyeng, ‘Ntwa atwemer ipmew renh!’ Ayenganap amperrngerrewarl ngkweng. ‘Arrangkw! Nthakenh atha atwey-angenh atyetyart atyenh. INGKARTel renh rlwanew, atyetyart aneyew Israel-ew!’ ");
INSERT INTO aly_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","Malyeyay, nhenh ara! Arnkwa akert akely atha antwerrkeyel, atharl ngwamp akew! Atha ngenh ipmew atwey-angenh-antey, arrangkw! Ntwa iterl-aremer, ayeng ngkweng apmwelheley-angenh! Nthakenh ayeng atyetyart aneyew arrkernelhey-angenh ngkweng-angkwarr. Nganap atyeng nthweyelarl intem, ayenh ipmew atweyew. ");
INSERT INTO aly_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","Ingwer-ingweran INGKARTel court-emeleyenh aylenhanth. Ngkweng awakelheyenh apek ra, ngarl atyeng-warl-athek apmwelhelew. Athanap nthakenh ngenh atwey-angenh, arrangkw. ");
INSERT INTO aly_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","Ntwa angka iterl-areyel, anantherrarl ilerrem. Anantherr alakenh ilem: ‘Akngerrel nthakenh apmwa mpwarey-angenh. Apmwelant mpwarem alakenhan.’ Nthakenh atha ngenh atwey-angenh.” ... ");
INSERT INTO aly_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","David-arl angkew-penh, Saul-el ayernew, “Malyey! Nganang innga angkeyel?” Rap artnew artewentyel. ");
INSERT INTO aly_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","“Arraty nga angkeyel. Ntwan mwerr atyeng mpwarew, ayengan ngkweng apmwelhelewarl. ");
INSERT INTO aly_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","Aleyan nga atyeng amperrngerrew. INGKARTel aylenhanth pweytelew intey-itwew, ntwa ayenh ipmew atwey-angenharl. ");
INSERT INTO aly_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","Artwa ahawarrelarl arey-alhem anyent ingwer, nthakenh ra tyarlewey-angenh renh. Alakenh-anyemarl anewantherrenh-angkwarran. Nganap alakenh-wenyarl. Ntwa mwerr atyeng mpwarew. Alakenhan INGKARTel ngkweng-anem mwerr mpwarem. ");
INSERT INTO aly_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","Atha iterl-areyel, ingwer-ingweran nga atyetyart Israel-itwew aneyenh. Ikwer-penhan ngkwenh-rnem-anem atyetyart aneyenh. ");
INSERT INTO aly_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","INGKARTelarl aweyel-wety, ilelha-tangkwel atyeng, ntwa atyenh-rnem atwey-angenh-antey, ngarl atyetyart anemeng-areyan. Atyetyart nga anentyel, mwerr anaynta ikwer-rnem, rernem mwerr-anem anaynteyew, ingwer-rnem iylpelerrey-angenh anewerr itna atyenhew.” ");
INSERT INTO aly_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","David-el renh ilew, rarl ayernew-angkwarr. Saul alpew apmer-warl-anem. David-an alpew arrpemarl ikwerenh-rnem-akert apwert-rnem-warl, irrtyert anaynteyew. ");
INSERT INTO aly_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","Artwamp Samuel-an ahaperrew-anem. Israel-wenh-rnem akarrerrew, artnalhelerrenh. Rernemap renh akwernew apmer ikwerenh-itwew Ramah-itwew. Ikwer-penh David alpew artwa ikwerenh-rnem-akert apmer aterterr-ampeny-warl Maon-warl. ");
INSERT INTO aly_vpl VALUES ("S125_2","010_25_2","1SA","25","2","3","Artwa anyent apmer Maon-areny anenh itna Nabal, Caleb-wenh-antey. Apmer ikwerenhan apmer Carmel-ampeny-itwew. Ran apwert akngerr-akert, yep-yep-rnem 3,000, nanikwet-rnem 1,000. Artwa ahelengkwarlap ran. Akelty ikwerenh itnan Abigail. Ranap inngerr mwerr-angker, tyakarl anenh. Ingwer-ingweran Nabal-el yep-yep alta akenh apmer ikwer-itwew. ");
INSERT INTO aly_vpl VALUES ("S125_4","010_25_4","1SA","25","4","4","David-el awew, apmer arlpawelarl anenhel. ");
INSERT INTO aly_vpl VALUES ("S125_5","010_25_5","1SA","25","5","5","Rap ilew artwa akely-rnem 10 alakenh, “Carmel-warl alhenh-arey, artwa Nabal areyew. Alakenh ikwer angkenh-arey, ‘Atyetyart David mwerr-angkwarr angkeyel ngkweng! ");
INSERT INTO aly_vpl VALUES ("S125_6","010_25_6","1SA","25","6","6","INGKARTel ngenh arntarnt-arem ngwenh-rnem-then atnwenth-rnem-then! ");
INSERT INTO aly_vpl VALUES ("S125_7","010_25_7","1SA","25","7","7","Atha awew, ntwarl yep-yep-rnem altanem akeyel. Anantherran artwa yep-yepew-artey ngkwenh-rnem arntarnt-arenh mwanty, irrtyert-iney-angenh ikwer-rnem-they. Ahawarr ingwer-rneman irrtyert-awarr. Anantherran arntarnt-arem ingwer-rnem, irrtyertew iterrey-angenh. ");
INSERT INTO aly_vpl VALUES ("S125_8","010_25_8","1SA","25","8","8","Ayerna ngkwenh-rnem! Rernem ilem irrkaty-angkwarr. Alakenh anewantherr mwerr anemer nga, anantherrarl ngkweng warrkerreyel-apeny. Atha awew arrpemarl, ntwarl ilew akngerr ngwamp, akarrerreyew amern kwenty arlkweyew. Anantherran angayakw aneyel. Amern-then aker-then apek ntwa anthem?’” ");
INSERT INTO aly_vpl VALUES ("S125_9","010_25_9","1SA","25","9","9","Rernemap alhew apmer Nabal ikwerenh-warl, iley-alhew David-arl angkew-angkwarr. Ranap tyerney-angenh-anteyarl. ");
INSERT INTO aly_vpl VALUES ("S125_10","010_25_10","1SA","25","10","10","Rap renh-rnem ayernew, “Angwenharl David raw? Nthenh-apeny Jesse-wenh alerikwan? Ran warrkenh ingwer-rnem-apeny, atyetyart ikwer-rnem-wenh-wetyarl anterreyel. ");
INSERT INTO aly_vpl VALUES ("S125_11","010_25_11","1SA","25","11","11","Warrkenh atyenh-rnemewant atha antheman amern aker-then kwaty-akerr. Nthakenh atha anthey-angenh arrewantherrant atyenh-rnem-wetyan. Atha arrenhantherrenh iterl-arey-angenh. David-el thweney-angenh apek arrenhantherrenh?” ");
INSERT INTO aly_vpl VALUES ("S125_12","010_25_12","1SA","25","12","12","Rernemap alpew, David iley-alpeyew. ");
INSERT INTO aly_vpl VALUES ("S125_13","010_25_13","1SA","25","13","13","David angkew artwa ikwerenh-rnemew, “Nayp arlpenty-rnem inenh-arey! Mpa, alhey ikwer-warl!” Nayp arlpenty-rnem rernem arrernerl-alhew pilt-warl. David-el nayp arlpenty ikwerenh inerl-alhew arrpemarl. Rap anpenhew artwernem 400-akert. 200 ingwer-rneman anenh, apmer arntarnt-araynteyew anteng. ");
INSERT INTO aly_vpl VALUES ("S125_14","010_25_14","1SA","25","14","14","Warrkenh anyent Nabal-wenh anterrew akelty Nabal-wenh-warl Abigail-warl, iley-alhew-anem, “David-el thwenew angkakert-rnem apmer ikwer-they, atyetyart anewantherrenhew angkeyew. Ranap apmwel-ayeth angkew ikwer-rnem. ");
INSERT INTO aly_vpl VALUES ("S125_15","010_25_15","1SA","25","15","15","Rerneman mwerr-angker anenh anewantherr, anantherrarl yep-yep-rnem arntarnt-arenheng-arey. Rernem irrtyert-iney-angenh anewantherr-they. ");
INSERT INTO aly_vpl VALUES ("S125_16","010_25_16","1SA","25","16","16","Iternew ingwel-then rernem arntarnt-arenh anenhantherrenh mwanty, yep-yep-rnemarl akarrelenhan. ");
INSERT INTO aly_vpl VALUES ("S125_17","010_25_17","1SA","25","17","17","Atyetyart nhenh anewantherrenh irrwernelhew ament-antey. Apmwa innga ayntewerr anewantherr apmer nhenh-itwew. Nthakenh ntwa renh ilem? Ranap apmwarl, nthakenh ayeng ikwer angkey-angenh, arrangkw!” ");
INSERT INTO aly_vpl VALUES ("S125_18","010_25_18","1SA","25","18","18","Abigail ra mpwelhey-angenh. Rap ilek-ilek akarrelew: rtamp-rnem 200, ngkwarl arranty nanikwet-wenh yenp-penh-akert atherr, aker yep-yep ampeng-rnem 5, ntang ampeng yakweth-akert 5 arrpemarl, amern akngerr akatyerr-apeny, amern akngerr tywerrk-apeny. Rap tywenew tangkey-rnem-warl-anem. ");
INSERT INTO aly_vpl VALUES ("S125_19","010_25_19","1SA","25","19","19","Warrkenh ikwerenh-rnemew ra angkew, “Arrantherr arrwekel alhenh-arey. Ayengan ingkern-theyarl alhem.” Artwa ikwerenhew ra iley-angenh. ");
INSERT INTO aly_vpl VALUES ("S125_20","010_25_20","1SA","25","20","20","Abigail anperl-alhew tangkey-akert, rap apwert atwatyel-antey alpenh. Rap David-anem areynenh, artwa ikwerenh-rnem-akertarl apetyenh. ");
INSERT INTO aly_vpl VALUES ("S125_21","010_25_21","1SA","25","21","21","David-arl alpenhel, ra iterreynenh alakenh, “Arrangkwewap atha arntarnt-arenhan artwa ikwerenh-rnem yep-yep-rnem-then apmer nhenh-ampeny-itwew. Mwerr ayeng anenh ikwer, ran atyeng apmwel-ayetharl angkew. ");
INSERT INTO aly_vpl VALUES ("S125_22","010_25_22","1SA","25","22","22","Atemwengkel-antey atha atweyenh artwa, awey-rnem ingkerr apmer ikwerenh-itwew. Atha alakenh mpwarey-angenhan, ayengap irrwernelhem Akngey-angkwarr!” Alakenh David iterreynenh. ");
INSERT INTO aly_vpl VALUES ("S125_23","010_25_23","1SA","25","23","23","Abigail-elarl renh arenhew, rap atwarrenhew anamerl-antey tangkey-they, kwenerrew-anem ikwer. ");
INSERT INTO aly_vpl VALUES ("S125_24","010_25_24","1SA","25","24","24","Rap angkew, “Atyetyartay! Alerl-antey! Awelherl-ayna-tangkwel atyeng! Nga atyeng ahelerremer, mentyarl Nabal-an. ");
INSERT INTO aly_vpl VALUES ("S125_25","010_25_25","1SA","25","25","25","Ikwer awelhey-angenh apmwa yanhew. Nabal-an itna arwengkarl, alakenh ra mpwarem apmelerr. Ayengan aney-angenharl, warrkenh ngkwenh-rnemarl apetyeweng-areyan apmer anewantherrenh-warl. ");
INSERT INTO aly_vpl VALUES ("S125_26","010_25_26","1SA","25","26","26","INGKARTel ngenh artwerelew, akngerr ipmew atwewerr. Ngap anewantherr ahelerrey-angenh-anem. INGKARTelan ingwer-rnem atwemer, rernemarl apmwa mpwarem ngkweng, rarl Nabal arwengk atweyenh-apeny. ");
INSERT INTO aly_vpl VALUES ("S125_27","010_25_27","1SA","25","27","27","Nhenh araw! Atha akngetyew amern ilek-ilek ngkweng, artwa ngkwenh-rnemel-then arlkweyew. ");
INSERT INTO aly_vpl VALUES ("S125_28","010_25_28","1SA","25","28","28","Atha ngenh ayernem, ayenh ntwa ipmeyew, artwa atyenhelarl apmwa ngkweng mpwarew-wety. Atha iterl-arem, ingwer-ingweran INGKARTel ngenh atyetyart ilkwa arrerneyenh Israel-ew. Ingwer-anem ngkwenh-antey atyetyart ilkwa aneyenh irrkaty-angkwarr. Ngarl apmer-ingwer-areny-rnem-then werrerl-anem, ngap warrkerrem ikwer. Arraty-angkwarr-antey anaynteyew intem-antey nga ampwerreyew-atety. ");
INSERT INTO aly_vpl VALUES ("S125_29","010_25_29","1SA","25","29","29","Aleyan ingwer-rnemel ngenh alwernem, ipmew atweyew. INGKARTelan ngenh arntarnt-arem mwanty, iteth-antey anaynteyew. Ngan impenarl ikwerenh. Ingwer-rneman ra rlengk-anteyarl ywerrelheleyenh. ");
INSERT INTO aly_vpl VALUES ("S125_30","010_25_30","1SA","25","30","30","Rarl mwerr ngkweng mpwarew-penh, ngap anem atyetyart ilkwa Israel-itwew, rarl arrwekel-antey angkew-angkwarr. ");
INSERT INTO aly_vpl VALUES ("S125_31","010_25_31","1SA","25","31","31","Ntwarl atweyew-anewelan, nga nyerr-anemarl awelheyew-anew. Awethem ntwa atwey-angenh-antey anenhantherrenh. Ngarl atyetyart ilkwa aneyenhel, atyeng iylpelerrey-angenh-antey.” Abigail angkew arternpelemel David-ew alakenh. ");
INSERT INTO aly_vpl VALUES ("S125_32","010_25_32","1SA","25","32","32","David-an angkew, “INGKART atha nakem, Akngey Israel-areny! Rarl ngenh thwenew, ayenh rlwateyew. ");
INSERT INTO aly_vpl VALUES ("S125_33","010_25_33","1SA","25","33","33","Ra mwerr ngkweng mpwaremer, ngarl mwanty arraty iterrew-angkwarr. Ntwa ayenh artwerelew, akngerr ipmew atwewerr, ayengan ahelarl apetyenh. ");
INSERT INTO aly_vpl VALUES ("S125_34","010_25_34","1SA","25","34","34","Innga INGKARTelarl ayenh artwerelew, ngkwenh-rnem atwewerr. Nga anamerl-antey atyeng arnekerrew, atha atemwengkel-antey atwewerr artwa, awey-rnem-then ingkerr apmer ngkwenh-itwew!” ");
INSERT INTO aly_vpl VALUES ("S125_35","010_25_35","1SA","25","35","35","Rap ilew artwa ikwerenh-rnem, ilek-ilek amern ingkerr ineyew, Abigail-elarl akngetyew. Rap angkew ikwer, “Alpanem inkwerelhemel apmer ngkwenh-warl. Ayengarl ngkweng awelhew, athap mpwarem, ntwarl ayernew-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("S125_36","010_25_36","1SA","25","36","36","Arelh ra alpenh apmer-warl, arrwekelan akngerr akarrerrew apmer ikwerenh-itwew, amern kwenty arlkwerreyew artwamp ikwerenh-itwel. Nabal-an inkwerelhemel aylelhenh ngkwarl-penh. Abigail-arl aney-alpewel, ra iley-angenh-antey artwamp renh, David-akert. ");
INSERT INTO aly_vpl VALUES ("S125_37","010_25_37","1SA","25","37","37","Ingwepenhan Nabal awelhenh mwerr-anem, Abigail-el renh ilew-anem angka apmwerrkeny. Rarl awewel, inweng-weny irreyelpew, arntety-anem. Rap lerrp-anem irrew, nthakenh akngelhey-angenh-anem. ");
INSERT INTO aly_vpl VALUES ("S125_38","010_25_38","1SA","25","38","38","Arlta 10-penh INGKARTel atwew-anem renh, rap ilwew-anem. ");
INSERT INTO aly_vpl VALUES ("S125_39","010_25_39","1SA","25","39","40","David-elarl awew, rarl ahaperrew, rap angkew, “Nakem INGKART! Artwamp ra apmwel-ayeth atyeng angkenh. INGKARTel renh ywerrelhelew, apmwel-ayetharl angkenh-penh. Ra ayenh artwerelew arrpemarl, apmwa mpwarewerr.” David-el angka thwenew Abigail-warl, renh ayernew, itengerreyew ikwer-warl. Rap angkakert-rnem thwenew apmer ikwer-warl Carmel-warl, rernemap angkey-alhew Abigail ikwer, “David-el anenhantherrenh thwenew. Nga ikwerenh-anem aneyew.” ");
INSERT INTO aly_vpl VALUES ("S125_41","010_25_41","1SA","25","41","41","Ra kwenerremel angkew alakenh, “Ya, ayeng alpem. Ayeng ikwer warrkerrem artwa ikwerenh-rnemew-then, ingkety-then apek irrarlk-aynteyew.” ");
INSERT INTO aly_vpl VALUES ("S125_42","010_25_42","1SA","25","42","42","Rap nganew tangkey-warl anamerl-antey, anpenhew-anem. Arelh warrkenh-rnem 5 alpew arrpemarl ikwer-angkwarr. Rernemap ingkerr-antey alpew-anem David-warl. Ratherr iteng-anem irrew. ");
INSERT INTO aly_vpl VALUES ("S125_43","010_25_43","1SA","25","43","44","David-wenh akelty arrwekeleny itnan Michal, Saul-wenh alerikw. Saul-elap renh rakeynew, artwa ingwer-warl-anem anthew Paltiel-warl, apmer Gallim-areny-warl. David-elan akelty ingwer-anem inew itnan Ahinoam, apmer Jezreel-areny. Ikwer-theyan rap Abigail-anem pweytelew Ahinoam-warl. ");
INSERT INTO aly_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","Ingwer-ingweran artwernem apmer Ziph-areny-rnem Gibeah-warl alhew, Saul-ew nthweyew. Rernemap angkew, “David-rnem irrtyert-anew-aneyel apwert Hakilah-itwew Jeshimon-itwew.” ");
INSERT INTO aly_vpl VALUES ("S126_2","010_26_2","1SA","26","2","2","Anamerl-antey Saul-el akarrelew artwa ahawarr-rnem Israel-wenh 3,000. Alhew-anem, David-ew nthweyew apmer ikwer-warl. ");
INSERT INTO aly_vpl VALUES ("S126_3","010_26_3","1SA","26","3","3","Rernemap ayntey-alhew apwert-ampeny-itwew iwerrel. David-rneman irrtyert-anew-anenh-antey apmer aterterr-ampeny-itwew. Rarl awewel, Saul apwert Hakilah-itwew aney-alhew, ");
INSERT INTO aly_vpl VALUES ("S126_4","010_26_4","1SA","26","4","4","rap thwenew artwa ikwerenh-rnem areyew. Rernemap irrtyert-they arerl-alpew, Saul ikwerenh-rnem-akertarl anenh. ");
INSERT INTO aly_vpl VALUES ("S126_5","010_26_5","1SA","26","5","5","Ingwelan David alhew apmer Saul-wenh-warl. Irrtyert-they rap renh arey-alhew atyetyart ahawarr-then Abner, alerikw Ner-wenh. Ratherr ampepel ayntenh, artwa ahawarr-rnemelan renh-atherr ampepewelew. ");
INSERT INTO aly_vpl VALUES ("S126_6","010_26_6","1SA","26","6","6","Artwa atherr alhew David-angkwarr, Ahimelech-an artwa Heth-arl alhenh, Abishai-an Zeruiah-wenharl. Zeruiah ra David-wenh angkwerikwarl, rap ampikw atherr atnyenew, Joab-then Abishai-atherr. Awayikwan ikwerenh Joab. David-el ayernew, “Angwenh anyent apetyem atyeng-angkwarr Saul-warl?” Abishai-an angkew, “Ayeng alhem.” ");
INSERT INTO aly_vpl VALUES ("S126_7","010_26_7","1SA","26","7","7","Ampepenyel ratherr apertenhew apmer Saul-wenh-warl. Ingkerrenh ankwa apelp ayntenh. Ratherr arey-alhew Saul-atherr, ampepelarl ayntenh. Irrtyart ikwerenh rtnenh ahernel arrer-antey. ");
INSERT INTO aly_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","Abishai arreytew, “Atyetyartay, nhenh ara! INGKARTan ilkelheyel, ntwa artwamp yanh atweyew ipmew, ngkweng-warl apmwa mpwareyelan! Irrtyartel atantheyew atha akwerterrp-antey! Ra ilweyew anamerl!” ");
INSERT INTO aly_vpl VALUES ("S126_9","010_26_9","1SA","26","9","9","David-el tyernew, “Nthakenh ntwa renh atwey-angenh! INGKART ngkweng awakelhewerr! Ra renh rlwanew, atyetyart aneyew anewantherr. ");
INSERT INTO aly_vpl VALUES ("S126_10","010_26_10","1SA","26","10","10","Ingwer-ingwer INGKART rantey renh ywerrelhelem; arntety-angkwarr apek, ahangkwarr apek, rwengk. Nthakenh aylanth atwey-angenh. ");
INSERT INTO aly_vpl VALUES ("S126_11","010_26_11","1SA","26","11","11","Atha INGKART intem ayernem, atha renh atwewerr, renhan rlwanewarl. Tyampet-then irrtyart-thenant aylanth iney anterremel.” ");
INSERT INTO aly_vpl VALUES ("S126_12","010_26_12","1SA","26","12","12","Ratherrap inerl-alhew, anterremel apmer ikwer-they. Ingwerentyel arey-angenh-antey. Ingkerrenh ankwa apelp-antey ayntenh, INGKARTelarl renh-rnem ankwathenew artewentyel. ");
INSERT INTO aly_vpl VALUES ("S126_13","010_26_13","1SA","26","13","13","Ratherrap artarnpenhew peleyn ingwer-ampeny-warl, arleng-anem apwertel rtney-alhew irrwerl. ");
INSERT INTO aly_vpl VALUES ("S126_14","010_26_14","1SA","26","14","14","David-an arlkew, “Abner! Aweyel apek ntwa ayenh?” Ra tyernew, “Angwenh aley arlkeyel, atyetyartan atyekeleyel?” ");
INSERT INTO aly_vpl VALUES ("S126_15","010_26_15","1SA","26","15","15","David kwanthemel angkew, “Abner, artwa ilek-apeny ngan? Nga ilelhem atyetyart ahawarr ilkwa ingwer-rnem-angkwarr! Ntwa arntarnt-arey-angenh atyetyart ngkwenh! Ngwamp ingwerenty alhew apmer arrewantherrenh-warl, atyetyart ipmew atweyew-anew! ");
INSERT INTO aly_vpl VALUES ("S126_16","010_26_16","1SA","26","16","16","Ngan ahawarr-arrpantey ilkwa! INGKARTel ngenh ipmew ilwerl-athenemer ahawarr ngkwenh-rnem-then! Arrantherr arntarnt-arey-angenh artewenty atyetyart, rarl rlwanew! Nhak ara! Irrtyart atyetyart-wenh-alew? Tyampet ikwerenh-alew?” ");
INSERT INTO aly_vpl VALUES ("S126_17","010_26_17","1SA","26","17","17","Saul akwentenhey-alpew, rap David alhengk-awew. “Malyey? Ngang aleyan angkeyel?” ");
INSERT INTO aly_vpl VALUES ("S126_18","010_26_18","1SA","26","18","18","David-el tyernew, “Ya atyetyart, ayeng angkeyel! Ilekew ntwan ayenh intem alwerneyel? Ayengan apmwelheley-angenharl! Ilekew ayenhan ayntarrp-ileyel? ");
INSERT INTO aly_vpl VALUES ("S126_19","010_26_19","1SA","26","19","19","Arternp atyeng awelha! INGKARTel apek ngenh ilew, atyeng-wety arlkarerreyew? Kel aker apek atha arrtyem ikwer, raw atyeng awakelhey-angenharl, atweyewan angkep. Artwernemel apek ilew, atyeng-wety nga arlkarerreyew? Kel INGKARTelan renh-rnem atwem, rernemarl ayenh irrentew atyenh-rnem-they. Nthakenh ayeng apmer atyenhel Israel-el aney-angenh-anem. Nthakenh ayeng INGKARTew aney-angenh. Alethang-apeny, apmer ingwerel-anem anem. Akngerran apmer ikwer-arenyel apentey-angenharl INGKART. ");
INSERT INTO aly_vpl VALUES ("S126_20","010_26_20","1SA","26","20","20","Nthakenh ayeng apmer nhenhel ilwey-angenh, INGKART-they arleng. Ayengan akelyarl, artwa atyetyart-wenyarl. Ilekew nga atyengan nthweyel? Aker-apenyarl ntwan ayenh alwerneyel?” ");
INSERT INTO aly_vpl VALUES ("S126_21","010_26_21","1SA","26","21","21","Saul-an angkew, “Ayengarl apmwelhelew. Ngan mwerrarl atyeng. Nthakenh ayeng ngkweng apmwelheley-angenh arrpemarl. Ntwan ayenh atwey-angenh-antey ipmew. Ayengarl apmwelhelew artewenty. Ngan alerey atyenh-apeny. Apey-alpa atyeng-warl!” ");
INSERT INTO aly_vpl VALUES ("S126_22","010_26_22","1SA","26","22","22","David angkew, “Irrtyart ngkwenh nhantey! Artwa anyent thwena, apetyeyew ineyew. ");
INSERT INTO aly_vpl VALUES ("S126_23","010_26_23","1SA","26","23","23","Ngwampan INGKARTel aylenhanthenh pweytelew, atha ipmew atwey-angenh-antey ngenh. Ra ngenh rlwanew, atyetyart aneyew. Nthakenh atha ngenh atwey-angenh, arrangkw! INGKART ra mwerrarl, ikwerarl awelheyel-rnemewan, arraty-thenarl aneyel-rnemewan. ");
INSERT INTO aly_vpl VALUES ("S126_24","010_26_24","1SA","26","24","24","Alakenh ayeng ilkelheyel, ra atyeng mwerr aneyew, iteth-then ayenh atnyeneyew, ngwamparl ayeng ngkweng iterrew-apeny, ipmew atwey-angenh-antey ngenh.” ");
INSERT INTO aly_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","Saul-an angkew, “INGKARTel ngenh arntarnt-arem! Ingwer-ingweran nga atyetyart ilkwa aneyenh, ilek-ilek mwerr-angker mpwarerl-aneyenh.” David alpew-anem apmer ikwer-they, Saul alpew arrpemarl Israel-warl. ");
INSERT INTO aly_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","Arrwekel-antey Saul-el ngangker-akert-rnem irrentew apmer Israel-they, INGKARTelarl ilew-angkwarr. Ikwer-they artwamp angkakert Samuel ahaperrew. Israel-wenh-rnem artnalhelerrew ikwer, renh akwernew apmer ikwerenh-itwew Ramah-itwew. ");
INSERT INTO aly_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","Ingwer-ingwer Philistia-areny-rnem akarrerrew apmer Shunem-itwew, werreyew Israel-wenh-rnem-then. Saul-el akarrelew ahawarr-rnem apmer Gilboa-itwew, Shunem-they arrer-antey arrpemarl. ");
INSERT INTO aly_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","Rarl Philistia-areny-rnem arew, rap atererremel artewentyel apatew. Akngerr inngarl renh-rnem arew, ywarn-anemap iterrewan. ");
INSERT INTO aly_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","INGKART ra ayernew. INGKARTel renh tyerney-angenh. Altyerr-angkwarr, artwa angkakert-angkwarr-then ra tyerney-angenh, arrangkw. Apwert artwa ingkart-wenh impen renharl iwew impalkert, ra iynwanyerr apek aytneyew, INGKART renh lwewarrerney-angenh, arrangkw. ");
INSERT INTO aly_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","Saul angkew artwa ikwerenh-rnemew, “Arelh ngangker-akertew nthwenh-arey. Atha Samuel ayerneyew ikwer-angkwarr. Ra apek ayenh tyerneyew.” Rernem ikwer angkew, “Anyentan aneyel apmer Endor-itwew.” ");
INSERT INTO aly_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","Rap arnkwa ingwer-warl-anem aylpew, ingwerelhelemel. Ingwel-antey ra alhew artwa atherr-akert, arelh ikwer nthweyew. Ra renh arey-alhew, rap angkew, “Aweyaw-rnemew katy angka atyeng! Artwa anyent ipma atha itnewem. Ina atyeng!” ");
INSERT INTO aly_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","Arelhel ra tyernew, “Ilekew ngan apetyew? Ntwa iterl-areyel, atyetyart Saul-elarl ngangker-rnem irrentew Israel-they! Ntwa ayenh irrwerneyel! Saul-el ingwer-rnem ilewerr, ayenh atweyew ipmew!” ");
INSERT INTO aly_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","Saul-el tyernew, “Atha ngenh arraty ilem, INGKARTelarl aweyel-wety. Nthakenh ngenh ingwerentyel atwey-angenh, ngkweng awakelhey-angenh!” ");
INSERT INTO aly_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","Arelhelap ayernew, “Aweyaw nthek-apeny ngkweng atha inem?” “Artwamp angkakert weth. Ina renh atyeng.” ");
INSERT INTO aly_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","Arelh angkew Samuel-wenh inwengew, rap apetyew ikwer-warl. Rarl renh arew, rap arlkenty iwew. Ran angkew Saul-ew, “Ilekew ntwa irrtywerl-ampernewan? Ngan Saul-arl!” ");
INSERT INTO aly_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","Saul angkew, “Kelaw! Atererrey-angenh! Ilek ntwa areyel?” Ra tyernew, “Inweng anyent atha areyel, ahern-theyarl aremerrey-ayntew nhanyem.” ");
INSERT INTO aly_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","Saul-el ayernew, “Ilek-apeny raw?” “Artwamp arnkwa arlpenty-akert apetyeyel.” Saul-el iterl-arew Samuel renh, rap kwenerrew, ilperr-ayntemel atnertel-ayeth ahern-itwew. ");
INSERT INTO aly_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","Samuel-ap angkew-anem, “Ilekew ntwan ayenh atyekelew, apey-alpeyew ngkweng-warl ipmethey?” Rtnemel Saul-el tyernew, “Apmwa innganem aleyan atyeng ayntem! Philistia-areny-rnem apetyeyel, ayenh atweyew. Akngeyan atyeng-wety ilkelhey-angenh-anem, awey-angenh ayenh. Angkey-angenh atyeng artwa angkakert-angkwarr, altyerr-angkwarr apek. Arrangkw, ayeng apateyel-anem, aleyan ngenh-anem atha ayernem.” ");
INSERT INTO aly_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","Samuel-an angkew, “INGKARTan ngkweng-wety intwemelerrew, awelhey-angenh-anem. Nthakenh ntwa ayenhan ayerney-angenh-anem, ngenh alpemeleyew, arrangkw. ");
INSERT INTO aly_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","Ayengarl iteth anenheng-arey, ra angka ngkweng-akert arrwekel-antey ayenh ilew. Athap ngenh ilew. Inngarlap aleyan ayntew. Ngan atyetyart Israel-ew aney-angenh-anem. INGKARTel kel-antey arrernew atyetyart ingwer-anem ngkweng-wety. David-arlap ran. ");
INSERT INTO aly_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","Ra alakenh mpwarew, ngan ikwer awelhey-angenharl. Rarl ahelerrew Amalek-areny-rnemew, ra ngenh ilanthew, renh-rnem ingkerrenh ywerrelheleyew, atnwenth-rnem-then ikwer-rnem-wenh. Ntwanap alakenh mpwarey-angenh, rarl ilanthew-angkwarr. ");
INSERT INTO aly_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","Philistia-areny-rnemel ngenh ipmew atweyenh ahawarr ngkwenh-rnem-then. Ingwelarreng INGKARTel ngenh iwerl-alheyenh. Philistia-areny-rnemel ngenh alerengkw ngkwenh-rnem-then ipmew atweyenh. Arrakerr apey-alpem, aney-alpeyew atyeng-itwel ipmernem-itwel.” ");
INSERT INTO aly_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","Saul ra amern-weny anenh arlta anyentew. Rarl awelhewel, rap alpwelyerreyelpew. Ra artewentyel atererrew aytnemel ahern-warl. ");
INSERT INTO aly_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","Arelhel arew, Saul-arl arrewemel ayntenh ahern-itwew, rap angkew, “Ayeng ngkweng awelhew. Ayeng atererrew, ntwa ayenh ipmew atwewerr. Athan ngkweng mpwarew, ntwarl ayernew-angkwarr. ");
INSERT INTO aly_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","Ngan atyeng-anem awelhemer. Amern atha ngenh antheyew, ngenh rlterrkeleyew, nga alpeyew-anem apmer-warl.” ");
INSERT INTO aly_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","Ran angkew, “Arrangkw. Nthakenh atha arlkwey-angenh.” Artwa ikwerenh-atherr irrkaty-angkwarr angkew, “Atyetyartay, amern ntwa arlkwemer!” Rap awelhew ikwer-rnem. Rap akwentew, pangkel-anem anenh. ");
INSERT INTO aly_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","Kapey-kapey anterant rtnenh apmer-itwew arelh-wenh, rap atwew anamerl-antey. Akerarl ampenh, amern arlety inew, rtamp-anem ampernew pikinpat-weny. ");
INSERT INTO aly_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","Rap ampeng-anem anthew Saul-ew ingwer-atherrew-then. Rernemap arlkwerl-alhew, alpew-anem atemwengkel-antey. ... ");
INSERT INTO aly_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","Arlta ingwerelan Philistia-areny-rnem Israel-wenh-rnem-then atwerrenh, werrenh pewenarrel apwert Gilboa-itwew. Israel-wenh ahawarr akngerr ilwernerrew ikwer-itwew, ingwer-rneman aterel anterrerrew. ");
INSERT INTO aly_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","Philistia-areny-rnemel Saul alwernew alerikw ikwerenh-rnem-then, rernemap renh-rnem arrerelhenhew. Alerikw ikwerenh-rnem irrpety ipmewarl atwew; Jonathan, Abinadab, Malki-Shua. ");
INSERT INTO aly_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","Ahawarr Saul-awel rtnenherrenharl-rnem rernem artewenty wenh ipantey. Philistia-areny-rnemel Saul renh akngerr-inger wew pewenarrel, artertilew renh amperelemel. ");
INSERT INTO aly_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","Ahawarr ingwerelan alkwertarl katy antwerrkenh. Saul angkew ikwer, “Nayp arlpenty ngkwenh ina, atanthanem ayenh ipmew! Yanh-rnemel INGKART iterl-arey-angenh-rnemel arrkentelhelewerr ayenh, ayenh-mernt atwewerr!” Ahawarran atererrew, nthakenh renh atwey-angenh. Saul ran amentel-antey nayp ikwerenh inew, atanthelhemel atnert-antey ipmew. ");
INSERT INTO aly_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Artwa ahawarrel arew, atyetyart ikwerenh ipmarl ayntenh, ranemarl ipmew atanthelhew. ");
INSERT INTO aly_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","Saul, alerikw ikwerenh-rnem, artwa ikwerenh alkwert akngerl-aney-angker-then ingkerrenh-antey rernem ilwernerrew arlta ikwerel. ");
INSERT INTO aly_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","Angka apmwa arlpimperrew Jezreel, Jordan-angkwarr. Israel-wenh-rnemelarl awew apmer ikwer-atherr-ampeny-they, rernem anterrerrew aterel. Apmerant-anem aynteyelpew. Philistia-areny-rnem-anemarl aney-alpew apmer Israel-wenh-rnem-wenh-itwew. ");
INSERT INTO aly_vpl VALUES ("S131_8","010_31_8","1SA","31","8","8","Arlta ingwerelan Philistia-areny-rnem angkep alpew apwert Gilboa-warl, ilek-ilek ineyew ipmernem-wenh. Saul rernem arey-alhew ipma arrpemarl alerikw ikwerenh-rnem-then irrpety. ");
INSERT INTO aly_vpl VALUES ("S131_9","010_31_9","1SA","31","9","9","Renhap ahenty-anem akerrth-atwew, lhelpelelhew arnkwa awerr ahew-arelh. Akngerr anterrenh apmer arrpanenh-warl Philistia-ampeny-warl, angka inkwerelhemel ileyew. Rernemap aylpenhew warl kwenerreyew-arelh-warl, altyerr ikwer-rnem-wenh-warl nakemel aylelherreyew. ");
INSERT INTO aly_vpl VALUES ("S131_10","010_31_10","1SA","31","10","10","Arnkwa awerr Saul-wenh arrernew warl yanh-ikwer-warl, rernemarl altyerr amarl Astarte-warl kwenerrenh-warl. Saul ipma rernem atanthew parrik-warl apmer Beth Shan-itwew aketh-ampeny. ");
INSERT INTO aly_vpl VALUES ("S131_11","010_31_11","1SA","31","11","11","Angka apmwa awew apmer Jabesh Gilead-ampeny-they-then. Rernem arlka apmwerrew, Philistia-areny-rnemelarl alakenh mpwarew Saul ikwer. Rernemap iterl-arew, rarl renh-rnem alpemelenh arrwekel-antey. ");
INSERT INTO aly_vpl VALUES ("S131_12","010_31_12","1SA","31","12","12","Artwa arnkaty-rnem ingwel-antey alhew, Jabesh-they ankwakel alhemel Beth Shan-warl, ipmernem inerl-alpeyew. Rernemap ipma aynenheng-rnem atwarrelheley-alhew warl-they, akngeynemel Jabesh-warl. Apmer ikwer-rnem-wenh-itwew renh-rnem arrtyey-alpew, ");
INSERT INTO aly_vpl VALUES ("S131_13","010_31_13","1SA","31","13","13","ngkwern-rnem akwernemel arwerl awenth anyent intert-itwew. Arlta 7-ew-atety rerneman amern arlkwey-angenh anew amperrngerremel, Saul-ew iterremel. ");
INSERT INTO aly_vpl VALUES ("S21_1","011_1_1","2SA","1","1","1","Philistia-areny-rnem Israel-wenh-rnem-then atwerrenh, werrenh apwert Gilboa-itwew, Saul-arl ahaperrew ikwer-itwew. Arlta ikwerel-antey David-rnem Amalek-areny-rnem-then werrenh arrpemarl apmer ingwer-itwew. Renh-rnemarl antengelew-penh, David-rnem alpew-anem apmer Ziklag-warl apal-antey. ");
INSERT INTO aly_vpl VALUES ("S21_2","011_1_2","2SA","1","2","2","Arlta atherr-penh artwa akely-anem aremerrew Saul-rnem-they. Arnkwarl ilterrelhew-akert, akapwert-then ahernel artelhew, rarl angka apmwakert apetyew. Rap kwenerrey-alhew David-warl. ");
INSERT INTO aly_vpl VALUES ("S21_3","011_1_3","2SA","1","3","3","David-el ayernew, “Nthek-they ngan apetyew?” Ra tyernew, “Ayengan apmer Gilboa-they anterrey-alhew, ahelarl atwerrew-they.” ");
INSERT INTO aly_vpl VALUES ("S21_4","011_1_4","2SA","1","4","4","“Nthakenh irrew? Ila atyeng!” “Rernem ahawarr akngerr Israel-wenh-rnem wew ipmew pewenarrel. Ingwer-rneman arlperrty anterrerrew. Saul-then alerikw ikwerenh Jonathan-then ipmew atwew arrpemarl.” ... ");
INSERT INTO aly_vpl VALUES ("S21_11","011_1_11","2SA","1","11","11","David-el artwa ikwerenh-rnemel-then arnkwa ilterrew, rernemarl arlka apmwerreyelpew Saul-ew-then Jonathan-ew-then. ");
INSERT INTO aly_vpl VALUES ("S21_12","011_1_12","2SA","1","12","12","Rernemap artnew ingwelew-atety, amern-then arlkwey-angenh-anem. Rernem amperrngerrew Israel-wenh-rnemew, INGKART-wenh-rnemarl ilwernerrew. ... ");
INSERT INTO aly_vpl VALUES ("S22_1","011_2_1","2SA","2","1","1","Ikwer-penh David-el INGKART ayernew, “Nthakenh irrem? Alpemang ayeng, aney-alpeyew, apmer anyent-itwew Judah-ampeny-itwew?” INGKARTel tyernew, “Ya, alpa.” David-el ayernew, “Apmer nthenh-warl?” “Hebron-warl.” ");
INSERT INTO aly_vpl VALUES ("S22_2","011_2_2","2SA","2","2","2","Kel David alpew, aney-alpew-anem apmer ikwer-itwew. Akelty ikwerenh-atherr alpew ikwer-angkwarr; Ahinoam Jezreel-areny, Abigail Carmel-areny-then, inpertarl irrew Nabal-ew. ");
INSERT INTO aly_vpl VALUES ("S22_3","011_2_3","2SA","2","3","3","David ikwerenh-rneman alpew arrpemarl ampangketyarr. Ingwer-rneman alpew tawen Hebron ikwer-warlarl, ingwer-rneman alpew apmer ingwer-rnem-warlarl arrer-antey arrpemarl ikwer-ampeny. ");
INSERT INTO aly_vpl VALUES ("S22_4","011_2_4","2SA","2","4","4","Judah-areny-rnem akarrerrew-anem Hebron-itwew, David arrerneyew atyetyart ikwer-rnem, anter alip thelemel akapwert-warl, ikwer-rnem-wenh-angkwarr. ... ");
INSERT INTO aly_vpl VALUES ("S22_8","011_2_8","2SA","2","8","8","Ikwereng-arey Saul-wenh atyetyart ahawarrel, alerikw Ner-wenhel itnan Abner, ra akngetyew artwa anyent Ishbosheth apmer Mahanaim-warl. Ranap Saul-wenh alerikwarl. ");
INSERT INTO aly_vpl VALUES ("S22_9","011_2_9","2SA","2","9","9","Abner-el renh arrernew atyetyart ingwer-rnemew: Gilead-areny-rnemew, Asher-areny-rnemew, Jezreel-areny-rnemew, Ephraim-areny-rnemew, Benjamin-areny-rnemew-then. ");
INSERT INTO aly_vpl VALUES ("S22_10","011_2_10","2SA","2","10","10","Ishbosheth ra 40-anem irrew, renharl atyetyart Israel-ew arrernew. Rap atyetyart anew aherrety atherrew-atety. Judah-areny-rnemelanap David-arl atyetyart arrernew ikwer-rneman. ");
INSERT INTO aly_vpl VALUES ("S22_11","011_2_11","2SA","2","11","11","Rap atyetyart anew aherrety 7 alkent 6-ew-atety Hebron-itwew. ... ");
INSERT INTO aly_vpl VALUES ("S23_1","011_3_1","2SA","3","1","1","Saul-arl ilwew-penh, ikwerenh-rnem David-wenh-rnem-then intem-antey werrenh arlengew-alenty. David-wenh-rnem akngerrerrew, ingwer-rneman irrpetyap-anem irrew. David-wenh-rneman Judah-areny-rnemarl, ingwer-rneman Israel-areny-rnemarl. ... ");
INSERT INTO aly_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","David anenh atyetyart Judah-areny-rnemewant-tangkwel. Ingwer-ingweran Israel-wenh ingkerr akarrerrew Hebron-itwew, alakenh David-ew angkeyew, “Ngan anewantherr-apeltyarl. ");
INSERT INTO aly_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","Saul-arl anenheng-arey atyetyart ingkerrew anewantherr Israel-wenh-rnemew, nga anenh atyetyart ahawarr-rnemewarl. Ikwereng-arey alakenh INGKARTel ngenh ilew, ‘Ngan ingwer-ingwer atyetyart aneyenh, arntarnt-areyenh atyenh-rnem Israel-wenh-rnem, yep-yeparl arntarnt-arem-apeny.’” ");
INSERT INTO aly_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","Alakenh angkemel artwamp-rnem alhew David-warl, Hebron-warl rarl anenh-warl. Rap angkew, “Ya, ayeng atyetyart anem arrewantherr ingkerrew, arrantherrarl angkew-angkwarr.” Rap alakenh ingkwernew pip-warl-anem. Ingkerrenh ingkwernelhew pip ikwer-warl. Artwamp-rnemel renh atyetyart arrernew Israel-ew-anem, anter alip thelemel akapwert-warl, ikwer-rnem-wenh-angkwarr. ");
INSERT INTO aly_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","David ra 30-anem irrew, renharl atyetyart Israel-ew arrerneweng-areyan. Rap anew atyetyart arlengew-alenty, aherrety 40-ew-atety. ");
INSERT INTO aly_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","Aherrety 7-ew-atety David ra anew atyetyart Judah-areny-rnemew-tangkwel apmer Hebron-itwewan. Ikwer-penh ra atyetyart anew ingkerrew-anem, rap atyetyart ilkwanem aney-alpew apmer Jerusalem-itwew-anem. Rap apmer atherr pweytelew-anem, Judah-then Israel-then. Apmer ilkwa renh itnewew Israel-anem. ... ");
INSERT INTO aly_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","INGKARTel David alpemelemel arntarnt-arenh ahelengkw apmer ingwer-areny-rnem-wety. Ingwer-rneman werrey-angenh-anem ipmelhew Israel-wenh-rnem-then. David-ap inkwerelhemel-anem anenh warl ilkwa ikwerenh-itwew Jerusalem-itwew. ");
INSERT INTO aly_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","Rap angkew artwa angkakertew Nathan-ew, “Ayengan aneyel warl mwerr-angker ilkwa nhenh-itwew, box impen Akngey-wenh ranap rtneyel kalikw-itwew-antey! Warl ingwer atha arteyew box ikwer.” ");
INSERT INTO aly_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","Nathan-el tyernew, “INGKARTelan ngenh arntarnt-arem. Kel ilek-ilek ntwa mpwarem, nga ilkelhentyelan.” ");
INSERT INTO aly_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","Nathan-ewan INGKARTelan angka ingwerarl ilew altyerr-angkwarr, rarl ankwayntenh-itwew. ");
INSERT INTO aly_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","Ra ilew, alakenh David ileyew: “David, ngan warrkenh atyenh. Ayenh awa. Menty ayntey, warl artey-angenh box impen ikwer. ");
INSERT INTO aly_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","Warlel ayengan aney-angenh, atharl atnwenhenheng-arey Israel-wenh-rnem Egypt-they. Aleyan ayeng warlel aney-angenh arrpemarl, kalikwel-anteyarl aneyel. Kalikwel-antey ayeng anenh, Israel-wenh-rnemarl alhenh ikwer-akert apmer arrpanenh-warl. ");
INSERT INTO aly_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","Atha atyetyart-rnem arrernenh, renh-rnem arntarnt-araynteyew. Atyetyart renh-rnemanap atha ilanthey-angenharl, warl mwerr-angker ilkwa arteyew ikwer, arrangkw. ");
INSERT INTO aly_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","Kel, mwanty-antey awelha atyeng. Ngan yep-yep arntarnt-arey-angker-tangkwel anew. Athap ngenh-anem arrernew, atyetyart aneyew Israel-wenh-rnemew. ");
INSERT INTO aly_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","Ayengan arrer innga alhenh ngkweng-itwel, ntwarl ilek-ilek mpwarenheng-arey. Atha ngenh alpemelenh, apmer ingwer-areny-rnem irrenteyew ahelengkw-rnem Israel-they. Aleyan atha ngenh ilkwanem mpwarem. Akngerr apmer arrpanenh-arenyel ngenh iterl-areyenh, mwerr-angker antwemel. ");
INSERT INTO aly_vpl VALUES ("S27_10","011_7_10","2SA","7","10","11","Awank-they athan atyetyart-rnem atyenh-rnemew arrernenh. Ingwer-rnemelan atyenh-rnem alhengkerr-anthenh, renh-rnem-then atwerrenh. Nhepenh-anyem athan renh-rnem arntarnt-araynteyew apmer nhenh-itwew. Apmer ikwer-rnem-wenh-anem, ikwer-itwew rernem akeleyt anaynteyew, atererrey-angenh-anem. Ingwer-rnemel renh-rnem ipmeyew-anem. Arrwekel-antey atha ngenh ilem. Ngkwenh-rnem atha ilkwanem mpwareynem. ");
INSERT INTO aly_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","Ngarl ahaperreyenh, ngenhap akwerneyenh, ngkwenh-rnemarl aynteyel-itwew-antey. Alerengkw ngkwenh anyentan atyetyartarl atha rlwaneyenh, renh rlterrkelemel. Rap aneyenh atyetyart rlterrk ikwerenh-rnemew aleth-antey arlengew-alenty. ");
INSERT INTO aly_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","Nthakenh ingwerentyel apmer nhenh rakey-angenh ikwer-they. Alerikw ikwerenh-rnem ingkern-penh-rnem-then rernem atyetyart-anem aneyenh intem-antey. ");
INSERT INTO aly_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","Ayengan aynikw ikwerenh-apenyarl aneyenh, ran alerey atyenh-apenyarl aneyenh. Ra apmwelhel-aynteman, atha renh arratyel-ayntemarl, artewentyel arntarnt-arayntemel akalty-anthayntemel aynelikw-apeny. ");
INSERT INTO aly_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","Saul-ew ayeng ilkelhenh-tangkwel. Ikwer-penhan ayeng ilkelhey-angenh ikwer, athap ngenh-anem atyetyart arrernew ikwer-wety. Alerengkw ngkwenhewan ayeng ilkelh-ayntemarl intem, rarl atyetyart aneyenheng-areyan. ");
INSERT INTO aly_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","Ngkwenh-rnem intem anayntem. Anyent ngkwenhan atyetyartarl intem anayntem.” Alakenh INGKARTel ilew artwa angkakert Nathan-warl altyerr-angkwarr. ");
INSERT INTO aly_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","Ingwepenh ingwer-ingwer ra alhew, David-anem ileyew, INGKARTarl angkew-angkwarr. ... ");
INSERT INTO aly_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","Alyangkw-penh atyetyart-rnemel akarrelenh ahawarr ikwer-rnem-wenh, ingwer-rnem-then werraynteyew apmelerr-angkwarr. David-el atyetyart ahawarr Joab ilew, “Ahawarr ingkerr Israel-wenh-rnem akarrela, alheyew arrpemarl, werreyew Ammon-areny-rnem-then.” Rernemarl alhewel, rernemap rlwatew ahawarr Ammon-areny-rnem, atwew-anem artewenty ampep-itwew renh-rnem. Apmer Rabbah-anem rernem amperelew ikwer-penhelan. Apmer ikwer-areny-rnem nthakenh tyerrelhey-angenh amperelewarl-wety. David-an artenyarl anenh Jerusalem-itwew. ");
INSERT INTO aly_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","Rap atwerrp-anem ankwethey akwentew, aketh-warl-anem tyerrelhew, rtnenh-anem warl irrwerl-itwew. Rap ayternew-anem, arelharl pwerlperrenh. Arelh inngerr mwerr-angker inngarlap ran. ");
INSERT INTO aly_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","Rap warrkenh ikwerenh thwenew, alakenh ayerneyew, “Angwenharl raw nhenhey?” Warrkenh rap apey-alpew ilemel, “Bathsheba-arl yanhan, Eliam-wenh alerikw. Mpwernikwan ikwerenh Uriah-arl Heth-wenh-antey.” ");
INSERT INTO aly_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","David-el renh thwenew, arelh renh ingweyew ikwer. Ra ngwampant irrarlkelhenh, arelh-rnemarl irrarlkelhem-angkwarr alkent arrpanenhel, ikwer-rnem-wenh-angkwarr. Bathsheba-ap alhew, David-arl angkew-angkwarr, ayntenh-anem ratherr. Ikwer-penhap ra alpew-anem apmer ikwerenh-warl. ");
INSERT INTO aly_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","Arntetyel-anem arelhel ra angka thwenew David-warl. ");
INSERT INTO aly_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","David-el awew, ra thwenew angka Joab-warl, rernemarl werrenh-warl. Rap angkew, “Ahawarr Uriah thwena atyeng-warl.” Renhap thwenew Joab-el. ");
INSERT INTO aly_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","David-elarl renh arew, rap ayernew, “Joab-alew? Mwerrangay? Ahawarr Israel-wenh-rnem mwerr arrpemarl? Artewentyang rernem werrenh Ammon-areny-rnem-then?” ");
INSERT INTO aly_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","Uriah-el renh tyernew. David angkew ikwer, “Kel-anem alpa apmer-warl akelty ngkwenh-warl, pwerlperreyew ltyerremel. Joab-warl ingwelarrengant alpa.” Rarl alpew, David-el aker mwerr-angker thwenew warrkenh-angkwarr, Uriah-atherrel arlkweyew. ");
INSERT INTO aly_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","Uriah-anap apmer ikwerenhel ayntey-alpey-angenharl, arrangkw. Ran ayntew warrkenh-rnem-itwew atyetyart-wenh-rnem-itwel, aketh-itwew, David-wenh-itwew. ");
INSERT INTO aly_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","Warrkenh anyentel David ilew, “Uriah-an ayntey-alpey-angenharl warl ikwerenh-itwew.” Rap warrkenh renh ilew, Uriah ingweyew. Rarl apetyew, David-el renh ayernew, “Ilek-wety ngan alpey-angenh, ltyerreyew? Artewentyarl nga warrkerrenh, arleng-they-then nga apetyew.” ");
INSERT INTO aly_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","Uriah-el tyernew, “Nthakenh ayeng alpey-angenh apmer atyenh-warl. Akngerr werreyel-antey Ammon-areny-rnem-then: ahawarr-rnem Israel-areny, ahawarr-rnem Judah-areny, atyetyart ahawarr-rnem, Joab-akerr. Rernemap aynteyel ampep-itwew, kalikwan intelheyel. Box impen Akngey-wenh wethan rtneyel arrpemarl. Nthakenh ayeng alpey-angenh apmer atyenh-warl akelty atyenh-warl, aker arlkweyew, ngkwarl-then antyweyew, arrangkw! Arraty atha ngenh ilem, nthakenh ayeng alakenh irrey-angenh!” ");
INSERT INTO aly_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","David-an angkew ikwer, “Kel. Apmer atyenh-itwew anerl-alha. Ingwelarrengant atha ngenh thwenem.” Kel Uriah atherr-inger ayntew Jerusalem-itwew. ");
INSERT INTO aly_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","David-el anthew amern akngerr ngkwarl-then ilpertelelhemel. Rap angkew, “Ngkwarl-then antywa!” Uriah-an terangk innganem irrew. Ra alpey-angenh akelty ikwerenh-warl, ayntey-alpew panty ikwerenh-itwew warrkenh-rnem-itwel arrpemarl, irrkaty-angkwarr. ");
INSERT INTO aly_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","Ingwepenh David-el awew, pip-anem ingkwernew atyetyart ahawarr Joab ikwer. Rap angkew Uriah-ew, “Pip nhenhan anthey-alha atyetyart ngkwenhew Joab-ew.” Apalel-antey ra akngew. ");
INSERT INTO aly_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","Pip-angkwarr alakenh ilew, “Uriah renh thweneyew artewentyel werreyel-ampeny-warl, Ammon-areny-rnem arrerenty. Ingwer-rnem ila, arleng-apeny rtneyew ikwer-wety, renh pewenarrel ipmew wey-alkenh.” ");
INSERT INTO aly_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","Israel-wenh-rnemelan apmer Rabbah amperelenh-antey. Joab-el iterl-arew, ahawarr Ammon-areny tyak-rnemarl rtnenh. Rap Uriah thwenew, renh-rnem weyew arrer-they. ");
INSERT INTO aly_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","Ammon-areny-rnem arrer-anem irrew, arrer-they-anem wemel. Ingwer-rneman Israel-wenh-rnem wew ipmew. Uriah-an wew ipmew arrpemarl. ");
INSERT INTO aly_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","Joab-el artwa angkakert thwenew, David ileyew, alakenh irrenh apmer ikwer-itwew. ");
INSERT INTO aly_vpl VALUES ("S211_19","011_11_19","2SA","11","19","19","Ra angkew, “Atyetyartew angka apmwa ila. ");
INSERT INTO aly_vpl VALUES ("S211_20","011_11_20","2SA","11","20","20","Ra ahelerrewerr, arrangkwewarl rerneman ilwernerrewarl. Ra ayernewerr alakenh, ‘Ilekew arrantherr wenh arrer-theyan? Arrantherr apek alakenh iterrew, “Nthakenh wey-angenh anenhantherrenh Ammon-areny-rnemel?” ");
INSERT INTO aly_vpl VALUES ("S211_21","011_11_21","2SA","11","21","21","Arrantherr apek iylpelerrew angka Abimelech-akertew, Gideon-wenh alerikwew? Ra ilwew irrkaty-angkwarr arrpemarl apmer Thebez-itwew. Arelh anyentel apwert ilkwa iwew warl irrwerl-they, renhap ipmewarl lthwew. Ilekew arrantherr arrererrewan?’ Atyetyartelarl ayernem alakenh, ila renh, ‘Uriah-an ilwew arrpemarl.’” ");
INSERT INTO aly_vpl VALUES ("S211_22","011_11_22","2SA","11","22","22","Artwa angkakertan alhew Jerusalem-warl David-warl, ra angka iley-alhew, Joab-elarl ilanthew-angkwarr-antey. ");
INSERT INTO aly_vpl VALUES ("S211_23","011_11_23","2SA","11","23","23","Rap angkew-anem alakenh, “Ammon-areny-rnem arrer-anem apetyew tawen ikwer-rnem-wenh-they, werreyew ampep-itwew. Anantherr renh-rnem angkep-antey alwernew tawen ikwer-warl. ");
INSERT INTO aly_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","Tawen-areny-rnem rernem-anem wey-ayntew. Rernem ahawarr ngkwenh-rnem ingwerentyakant wew ipmew. Uriah ngkwenh wew ipmew arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","David-elan awew, rap angkew, “Angkep alpa, Joab ileyew alakenh, ‘Arlka apmwerrey-angenh. Ahel atwerrenh, alakenharlap irrem. Ingwerenty ilwem, ingwerentyan arrangkwarl. Arternp-antey arrkernelh-ayntenh-arey, warl-then atakeyew apmer ikwer-itwew ingkerr.’ Alakenh ila, intem-antey arlka apmwerrey-angenh ra aneyew.” David ra tangkew-anem. ");
INSERT INTO aly_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","Bathsheba rarl awew, mpwernikw ilwewarl, ra artnew ikwer. ");
INSERT INTO aly_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","Arlta 7-ew-atety ra artnew ikwer-rnem-wenh-angkwarr. Ikwer-they David-el warrkenh thwenew ikwer-warl, renh ingwerl-alpeyew. Ratherrap itengerrew-anem. Ingwer-ingwer awey-anem ikwer-atherrenh anew. INGKARTelanap renh-atherr arenh. Rap inkwerelhey-angenh, David-arl apmwelhelewan. ");
INSERT INTO aly_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","Kel INGKARTel ilew artwa angkakert Nathan, “Alha David-warl, ileyew renh angka nhenh. ‘Artwa atherr anenh apmer anyentel-antey irrkatyel. Ingwerelan ilek-ilek akngerr apwert-then atnyenenh, arrangkwarl ingweran anenh. ");
INSERT INTO aly_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","Ingwerelan yep-yep pwelek-rnem-then akngerrarl atnyenenh, ");
INSERT INTO aly_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","ingwerelan yep-yep amarl akely anyentantarl atnyenenh, rarl payemelew. Ra warl-itwew alkenhelew ikwerenh-rnem-itwew. Amern ikwer-rnem-wenh arlkwew, kwaty-then irrkwa ikwerenh-they antywenh. Rap iynwerl-ayntenh alerikw ikwerenh-apeny. ");
INSERT INTO aly_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","Ingwer-ingweran alethang anyent apetyew apmer arleng-they, rap ayntey-alhew apmer artwa apwert akngerr-akert-wenh-itwew. Ran ilkelhew, aker amperneyew alethang ikwer. Rap atnwenth ikwerenhan atwey-angenharl. Artwa irrepern ikwer-they ra yep-yep akely rakew, alethang ikweran amperneyew.’” Alakenh Nathan-el David ilenh. ");
INSERT INTO aly_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","David-el angka renh awew, rap ahelerrew artwa ikwer, rap angkew Nathan-ew, “Athan arraty ileyel, INGKARTelarl aweyel. Artwa yanh apmwelhelew. Ingwerentyel ipmew renh atwemer! ");
INSERT INTO aly_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","Ra athamerrey-angenhel apmwel-ayeth rakew. Rap yep-yep-rnem 4 anthemer angkep ikwer!” ");
INSERT INTO aly_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","Nathan angkew David-ew, “Ngarlap ran! Angka nhenhan ngkweng-akert! INGKARTelarl ilew angka nhenhan atyeng. Ra ngenh atyetyart arrernew Israel-wenh-rnemew. Saul-elarl ngenh ipmew atweyew-anew, ra ngenh arntarnt-arenh. ");
INSERT INTO aly_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","Ra ngenh atyetyart arrernew Saul-wety. Akelty ikwerenh-rnem ngkwengant-anem. Ngap atyetyart-anem apmer atherr-angkwarr-anem, Israel-ew Judah-ew-anem. Atyetyart apek anem apmer ingwerew-then? Kel, INGKARTel apek anthem ilek-ilek arrpemarl. ");
INSERT INTO aly_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","Ilek-wety nga angka ikwerenhew awelhey-angenh? Nga apmwelhelew ikwer-angkwarr. Ntwa Uriah thwenew, artewentyelarl werrenh-ampeny-warl, Ammon-areny-rnemelaw renh weyew pewenarrel ipmew. Ntwaw nheng arelh ikwerenh iney-alkenh ngkwengant-anem. ");
INSERT INTO aly_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","Kel, ngarl apmwelhelew, ngkwenh-rnem-then ntwa irrwernew. Intem-antey apmwan ayntayntem ngkwenh-rnemew, akngerr ilwerl-aneyenh. Alakenh aynteyenh, ngarl INGKART-wety arlkarerrenh, akeltyarl ntwa Uriah-wenh inew ngkweng. ");
INSERT INTO aly_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","INGKARTel ngenh angka ingwer-then ileyel. Ingwer-ingweran alerengkw anyentelan ngkwenhel irrwerneyenh ngenh. INGKARTel renh artwereley-angenh, rarl ineyenhel akelty ngkwenh-rnem, alhewer aynteyenh ikwer-rnem-akert. ");
INSERT INTO aly_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","Anyelkel ntwan akelty Uriah-wenh inenh. Ranap akelty ngkwenh-rnem anayntarl ineyenh, akngerrelaw areyew.” ");
INSERT INTO aly_vpl VALUES ("S212_13","011_12_13","2SA","12","13","14","David-an angkew Nathan-ew, “Ayeng apmwelhelew INGKART-angkwarr.” Nathan angkew, “Ya, arraty! Alakenharl apmwelhelemel arrkentelheleyel INGKART renh. Ranap ngkweng awakelhey-angenh. Ra nthakenh ngenh ipmew atwey-angenh. Awey irrngarl ngkwenh rantap ahaperreyenharl.” ");
INSERT INTO aly_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","Nathan alpew-anem apmer-warl. Akelty Uriah-wenhel awey akely David-wenh atnyenew, awey rap arntety ilkwerrew-anem, INGKARTelarl renh arntetyelew. ");
INSERT INTO aly_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","David-el intem-antey ayernenh INGKART awey ikwer, ra mwerrerreyew. Amern arlkwey-angenh, arrangkw, amperrngerrewarl ra awey ikwer. Ingwa arrpanenh ra aylpenh warl ikwerenh-warl ayntaynteyew, ayntenh arlertek-itwew ra. Pangk mwerrel ayntey-angenh. ");
INSERT INTO aly_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","Akngerr-inger warrkenh ikwerenh-rnem apetyenh ikwer-warl araynteyew. Ywarn-antey renh ilenh rtnerl-alheyew. Ywarn rernem arrkernelhenh, amern antheyew. ");
INSERT INTO aly_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","Arlta 6-penh ampa akely ahaperrew. David-wenh warrkenh-rnem atererrew, renh ilewerr angka apmwa. Rernem iterrenh alakenh: “Ampa akelyarl iteth-antey anenheng-arey, anantherr ywarn iterrew, angkeyew ikwer. Ran iylpelant awenh anenhantherrenh. Nthakenh anantherr angka apmwa nhenh iley-angenh, ra artewenty atwelhewerr!” ");
INSERT INTO aly_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","David-el warrkenh-rnem arew arreyterrenharl. Rap iterl-arew, ampa akelyarl ahaperrew. “Ayengan alerey-weny-anem anem, ngay?” Rernem tyernew, “Ya.” ");
INSERT INTO aly_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","Rap rtnerl-alhew. Rap pwerlperreyew alhew, anterel-then apernelhew inteng-inteng mwerr-angkerel, arnkwel-anem mwerr-angkerel aylpemel. Rap warl INGKART-wenh-warl-anem aylpew, angkaynteyew ikwer-warl kwenerremel. Rap alpew-anem warl ikwerenh-warl, ayernemel warrkenh ikwerenh-rnem, amern ikwer akngetyeyew, raw arlkweyew. ");
INSERT INTO aly_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","Rernem renh ayernew, “Nthakenh irreyel? Ampa akelyarl iteth anenheng-arey, ngan ayntemelant artnenh, amern arlkwey-angenh. Rarl ahaperrew-penh, ngan anamerl-antey akwentew, amern-anem arlkwemel! Nthakenh ngan irreyel?” ");
INSERT INTO aly_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","Ra tyernew, “Ya, amparl iteth anenheng-arey, ayeng ayntemelant artnenh, amern arlkwey-angenh. Ayengan iterrenh, ‘INGKART apek atyeng amperrngerreyew. Ampa akely ra mwerreleyew apek.’ ");
INSERT INTO aly_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","Ran kel ahaperrew. Amern arlkwey-angenharl nthakenh atha renh angkep itetheley-angenh, arrangkw. Ingwer-ingweran ayeng ahaperreyenh arrpemarl. Aylakap aneyenh itengant-atherr. Nthakenh ra atyeng-warl apey-alpey-angenh nhenh-warlan.” ");
INSERT INTO aly_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","David alyep-antey angkew akelty ikwerenhew Bathsheba-ew, irrngerney-antheyew. Ingwer-ingwer awey ingwer-anem ratherr atnyenew, renhap itnewew Solomon. INGKART ilkelhew artewenty ampa akely ikwer, ");
INSERT INTO aly_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","rap artwa angkakert Nathan ilew, “Alha, ileyew renh-atherr, ratherr renh itnewemer Jedidiah, ayengarl artewentyel ikwer ilkelheyel.” ... ");
INSERT INTO aly_vpl VALUES ("S215_1","011_15_1","2SA","15","1","1","Ikwer-penh ingwer-ingweran David-wenh alerikw Absalom ilkelhew, atyetyart ilkwa aneyew. Pakey mwerr-angker ra inew nantew atherr-akert, ra akngaynteyew. Rarl pakey-akert alhenh, artwa 50 anterrenh arrwekel-ampeny, atyetyart ilkwarrpantey ra. ");
INSERT INTO aly_vpl VALUES ("S215_2","011_15_2","2SA","15","2","2","Ra ingwepenh-antey akwentenh, alhenh rtnaynteyew keyt ilkwitwew. Keyt-angkwarr akngerr alhenh Jerusalem-warl. Akngerr alhenh, atyetyart David ayern-aynteyew, renh-rnem arratyel-aynteyew. Absalom ra arlkey-ayntenh ikwer-rnem, “Ay! Nthenh-areny?” Artwa ra tyernenh apek, “Ephraim-wenh-antey, Benjamin-wenh-antey” apek. Alakenh. ");
INSERT INTO aly_vpl VALUES ("S215_3","011_15_3","2SA","15","3","3","Alerikw David-wenh ra angkayntenh irrtywerremel, “Awelha atyeng! Ngan arratyarl, ingweran ngkweng-warl apmwelhelewarl. Atyetyart aynaty yanhan nthakenh akngerrew awelhey-angenh, rernem alhenty ikwer-warl, arrangkw. Ra kwertengerl atnyeney-angenharl, katy ayern-aynteyew arrewantherr.” ");
INSERT INTO aly_vpl VALUES ("S215_4","011_15_4","2SA","15","4","4","Intem ra alakenh angkenh ingkerrew. Rap angkenh, “Ayeng atyetyart anemer apmer nhenh-itwewan! Ayeng mwerrarl ingkerrenhew anayntem irrkaty-angkwarr! Ingwerentyel apek ayenh ayernem, athap arratyarl ilem renh-rnem mwerr-angkwarr!” ");
INSERT INTO aly_vpl VALUES ("S215_5","011_15_5","2SA","15","5","5","Ingwerenty apek aremerrey-alhenh alerikw David-wenh-warl, rernemap kwenerrey-alhenh, artwa ilkwew-arrpantey ikwer iterrenh. Renh-rnem itep antwerrkenh atnyenemel arrwantyemel, rernemaw ikwer ilkelh-aynteyew-awaty, Jew-rnem-wenh-angkwarr. ");
INSERT INTO aly_vpl VALUES ("S215_6","011_15_6","2SA","15","6","6","Artwa Israel-wenharl alhenh, atyetyart David ayernemel araynteyew, alerikw ikwerenh alakenh irrayntenh. Alakenhan ra Israel-wenh-rnem akalty-anthenh, ikwerant-anem ilkelh-aynteyew, David menty-anem. ");
INSERT INTO aly_vpl VALUES ("S215_7","011_15_7","2SA","15","7","8","Ra alakenh irrenh arleng-alenty. Aherrety 4-penh, ra irrtywerremel angkew aynikw ikwerenhew atyetyartew, “Artwampay, ayengarl anenh apmer Geshur-itwew Aram-ampeny-itwew, atha INGKART alakenh ilew, ‘Ntwa ayenh tyarlewenty, Jerusalem-warl alpeyew, ayengan ngkweng kwenerrey-alpem apmer Hebron-itwew.’ Mwerrang atyeng alpeyewan Hebron-warl, INGKARTew kwenerr-aynteyew?” ");
INSERT INTO aly_vpl VALUES ("S215_9","011_15_9","2SA","15","9","9","David-el tyernew, “Kelaw. Mwerr nga alhewer alpem.” Rap alhew Hebron-warl-anem. ");
INSERT INTO aly_vpl VALUES ("S215_10","011_15_10","2SA","15","10","10","Alerikw David-wenhel ra angkakert anyelkel thwenew, Israel-wenh-rnem ileyew alakenh: “Terampet arlkenty awem, arrantherr ingkerr arlkenh-arey, ‘Absalom ra atyetyart anewantherr! Rernemap renh arrernew atyetyart Hebron-itwew!’” ");
INSERT INTO aly_vpl VALUES ("S215_11","011_15_11","2SA","15","11","11","Alerikw David-wenhel ilew artwernem 200, ikwer-angkwarr alheyew Hebron-warl, aker arrtyaynteyew INGKARTew. Ra arlkarerrenh David-wety, artwernemelan renh apentew apalelarl. ");
INSERT INTO aly_vpl VALUES ("S215_12","011_15_12","2SA","15","12","12","Aker arrtyeyew-athath, ra yangkelhew artwamp Ahithophel-ew-tangkwel, apetyeyew apmer ikwerenh-they Giloh-they. Ahithophel-an kwertengerl anenh David-ew-tangkwel awank. Anper arey-angkerarlap ran. Alakenh-anyem akngerran iterrew, alerikw David-wenhant-anem apent-aynteyew, menty-anem renhan. Renh apentey-angenh-anem, ikwer awelhey-angenh-anem. ");
INSERT INTO aly_vpl VALUES ("S215_13","011_15_13","2SA","15","13","13","Ikwer-penh artwa angkakert anyent alhew David-ew, rap angkew, “Israel-wenh-rnemel apenteyel alerengkw-anemarl!” ");
INSERT INTO aly_vpl VALUES ("S215_14","011_15_14","2SA","15","14","14","David apateyelpew. Rap warrkenh ikwerenh-rnemew angkew, ikwer-itwelarl anenh-rnemew Jerusalem-itwew, “Mpa! Ingkerrenh anantherr irrtyert-anterrey, antwerrkewerr anenhantherrenh! Anamerl-antey anantherr alpey, ra atep-atakewerr apmer nhenh, ingkerrenh atwemel!” ");
INSERT INTO aly_vpl VALUES ("S215_15","011_15_15","2SA","15","15","15","Warrkenh-rnemel tyernew, “Ya atyetyartay! Anantherr ngkweng awelhem, ntwarl ilem-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("S215_16","011_15_16","2SA","15","16","16","David rap anpenhew ikwerenh-rnem-akert. Ra kwey warrkenh-rnem 10 ilew, ikwer-itwelarl itengerrew-rnem, anaynteyew anteng, arntarnt-araynteyew warl ikwerenh. ... ");
INSERT INTO aly_vpl VALUES ("S215_32","011_15_32","2SA","15","32","32","Rernemap anperlarr-alhew Apwert Alip-warl, rernemarl awank kwenerremel angkenh Akngey-warl ikwer-itwew. Kwertengerl anyent David-wenhel, Hushai-el, rlwatew renh-rnem apwert ikwer-itwew. Ranap Ark-wenh-anteyarl. Ra aremerrey-ayntew arnkwa ilterrelhenty-akert ahern-angketyarr akapwert, rarl amperrngerrew atyetyart ikwerenhew. ");
INSERT INTO aly_vpl VALUES ("S215_33","011_15_33","2SA","15","33","33","David-an angkew ikwer, “Apentey-angenh ayenh. Anngangewerr ntwa ayenh. ");
INSERT INTO aly_vpl VALUES ("S215_34","011_15_34","2SA","15","34","34","Nga alpem irrtyertel-antey Jerusalem-warl, aleraty atyenh ileyew irrtywerremel alakenh, ‘Atyetyartay! Ayengan ngkweng-anem warrkerreyew. Awankan ayeng warrkerrenh aynengkwew-tangkwel. Aleyan ayeng ngkwengant-anem warrkerreyew.’ Ngarl alakenh angkeman ikwer, ntwa ayenharl alpemelem. Ahithophel, anper arey-angker weth, rarl angka arraty angkenty, ntwa aleraty atyenh apatelhelem, angka ingwerarl ikwer ilemel.” ... ");
INSERT INTO aly_vpl VALUES ("S216_5","011_16_5","2SA","16","5","5","David-arl arrer-anem irrew apmer Bahurim-warl ikwerenh-rnem-akert, artwa anyent itnan Shimei aremerrey-ayntew, renh-rnem rlwatew. Ranap Saul-wenh akwerrk-anteyarl. Rap arrarletyel iltayntew David, ");
INSERT INTO aly_vpl VALUES ("S216_6","011_16_6","2SA","16","6","6","apwertel-then wew renh-rnem. David ra akngerr-akert arrpemarl alpenh, Shimei-elan apwertel wenh-antey. ");
INSERT INTO aly_vpl VALUES ("S216_7","011_16_7","2SA","16","7","7","Rap apmwel-ayeth angkew David-ew alakenh: “Irrwerney-angker apmwa! Ahelengkw! Atwenh-atwenh! Atyetyart-arrpantey! Alpa! ");
INSERT INTO aly_vpl VALUES ("S216_8","011_16_8","2SA","16","8","8","INGKARTel ngenh irrwernem aley-anyem angkep, ntwarl Saul-wenh-rnem akngerr atwew! Ngap atyetyart-anem arrernelhew ikwer-wety! INGKARTelap arrernew alerengkw ngkwenh Absalom-anem, atyetyart aneyew ngkweng-wety! Ngan ahelengkwarl, nga ament-antey irrwernelhew!” ");
INSERT INTO aly_vpl VALUES ("S216_9","011_16_9","2SA","16","9","9","Artwa atyetyart ahawarr anyent itnan Abishai, Zeruiah-wenh ampikw, ra angkew, “Atyetyart, artwa apmwa nthakenh alakenh ngkweng-warl angkey-angenh! Ayenh tyarlewa, akapwert atha amentewarl ileyew!” Zeruiah ra David-wenh angkwerikwarl, rap ampikw atherr atnyenew, Joab-then Abishai-atherr. ");
INSERT INTO aly_vpl VALUES ("S216_10","011_16_10","2SA","16","10","10","David-an awayenheng-atherrew angkew, “Mentyaw! Mpwelan arlarl! INGKART rantey apek ilew renh, ayenh arrarletyel ilteyew alakenh. Nthakenh ingwerentyel artwereley-angenh renh.” ... ");
INSERT INTO aly_vpl VALUES ("S216_15","011_16_15","2SA","16","15","15","Arlta ikwerel-antey Absalom, alerikw David-wenh, ikwerenh-rnem-then Israel-wenh-rnem-then aremerrew apmer Jerusalem-itwew. Ahithophel-an, artwa anper arey-angker weth, ra ikwer-itwel arrpemarl alhenh. ");
INSERT INTO aly_vpl VALUES ("S216_16","011_16_16","2SA","16","16","16","Artwa Hushai ra alhew, alerikw David-wenh rlwateyew. Hushai ra kwertengerl David-wenh-anteyarl anenh, ratherrarl awank-they alhenh akely-they. Ra irrtywerremel arlkew, “Atyetyart Absalom ngan mwerr! Nga atyetyart anemer intem-antey!” ");
INSERT INTO aly_vpl VALUES ("S216_17","011_16_17","2SA","16","17","17","Alerikw David-wenhel tyernew, “Ilekew nga alakenh arlkeyel? Ngap alhemer David-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("S216_18","011_16_18","2SA","16","18","18","Hushai irrtywerremel angkew, “Nthakenh ayeng David-angkwarr alhey-angenh aley. Nganemarl atyetyartan. INGKARTel Israel-wenh-rnemel-then ngenh rlwanew, nga atyetyart aneyew. Ayengan ngkwenh-anemarl. ");
INSERT INTO aly_vpl VALUES ("S216_19","011_16_19","2SA","16","19","19","Aley mwerr-angkwarr-anem. Ayeng ngkweng warrkerrem irrkaty-angkwarr, ayengarl aynewengkw warrkerrenh-apeny.” Alerikw David-wenh ament iterrew, “Ya inngarl ra ileyel.” ");
INSERT INTO aly_vpl VALUES ("S216_20","011_16_20","2SA","16","20","20","Alerikw David-wenh ra angkew artwa ingwerew-anem, artwa anper arey-angker wethew, “Kelap. Ntwanem ila anewantherr, nthakenh irrem anantherr?” ");
INSERT INTO aly_vpl VALUES ("S216_21","011_16_21","2SA","16","21","21","Ra tyernew, “Kwey warrkenh 10 aynengkw ngkwenh-warlarl itengerrew-rnem. Rernem antengarl anenh, warl arntarnt-araynteyew. Ngap ayntem ikwer-rnemenp. Alakenhan ntwa aynengkw ngkwenh nyerrel anthem, rap ngkweng-wety arlkarerrem artewenty innga. Ingkerrelan iterl-areyenh, nganemarl atyetyart ilkwa anerl-aneyenh aleyan, warl ikwerenh-itwewan. Rernemarl awem, ntwa arnkatyel mpwarem, rernem ngenh apentem innganemarl.” ");
INSERT INTO aly_vpl VALUES ("S216_22","011_16_22","2SA","16","22","22","Warrkenh-rnemel kalikw mpwarew warl irrwerl-itwew, akngerrel areyew. Alerikw David-wenh ra aylpenhew arelh 10 ikwer-rnem-warl nyerr-weny. ");
INSERT INTO aly_vpl VALUES ("S216_23","011_16_23","2SA","16","23","23","Alakenh alerikw David-wenh awelhew angka artwa anper arey-angker-wenhew, aynikwarl awelhenh-angkwarr-apeny. Ratherr iterrew, anper arey-angker rarl angka Akngey-wenh iley-angker anenh, Akngey angkerl-anenty-arrpantey. Ratherran apmelerrel-ayeth ayernenh, ikwer awelhemel. ");
INSERT INTO aly_vpl VALUES ("S217_1","011_17_1","2SA","17","1","1","Artwa anper arey-angker weth, Ahithophel, ra angkew arrpemarl alerikw David-wenhew Absalom-ew, “Alerl atha rlwaney ahawarr-rnem 12,000, aynengkw renh alwerneyew rlengk ingwel. ");
INSERT INTO aly_vpl VALUES ("S217_2","011_17_2","2SA","17","2","2","Aleyan ra arlka apmwanem alhengkerr-then. Rap apateyelpeyenh, ayengarl ikwer arwapeny aremerreyelpeyenh, antwerrkeyew. Ikwerenh-rnem mentyarl anterrey. Renhantap atha ipmew-antey atweyenh. ");
INSERT INTO aly_vpl VALUES ("S217_3","011_17_3","2SA","17","3","3","Ingwer-rneman atha arlweleyenh, akngey-alpeyenh nhenh-warl. Rernemarl areyn, atyetyart ikwer-rnem-wenh ipma, rernemap inkwerelhemel mwerr-antey antelhenhey-alpeyenh.” ");
INSERT INTO aly_vpl VALUES ("S217_4","011_17_4","2SA","17","4","4","Alerikw David-wenh artwamp Israel-wenh-rnem-then rernem angkerrew, “Ya, alakenhan mwerrarl.” ");
INSERT INTO aly_vpl VALUES ("S217_5","011_17_5","2SA","17","5","5","Alerikw David-wenh angkew-anem, “Kel. Kwertengerl Hushai weth, iley renh-anem, apetyeyew anewantherr-warl. Angka ikwerenhew-tangkwel anantherr awelheyew.” ");
INSERT INTO aly_vpl VALUES ("S217_6","011_17_6","2SA","17","6","6","Hushai rarl apetyew, alerikw David-wenhel renh ilew, artwa anper arey-angkerarl angkew-angkwarr. Rap ayernew, “Nthakenh ngan iterreyel, Hushai? Angka artwa anper arey-angker-wenhew anantherr awelhem? Arrangkw apek? Nthakenharlap anantherr irrem?” ");
INSERT INTO aly_vpl VALUES ("S217_7","011_17_7","2SA","17","7","7","Hushai-elan irrtywerremel tyernew, “Artwa anper arey-angker yanhan arratyarl angkem. Aleyanap arrangkwarl. Angka yanhan apmwarl, rarl ngwamp ilew. ");
INSERT INTO aly_vpl VALUES ("S217_8","011_17_8","2SA","17","8","8","Ntwa aynengkw ngkwenh iterl-areyelarl, ran ahawarr rlterrkarl. Artwa ahawarr ikwerenh-rnem rlterrk arrpemarl, atnwenth ahelengkw-rnem-apeny. Ran tyak innga, arlengarl ayntey-alhem arntarnt-arelhemel ahawarr-rnem-wetyan. ");
INSERT INTO aly_vpl VALUES ("S217_9","011_17_9","2SA","17","9","9","Apwert intey-warl apek ra irrtyert-aylpenh, apwert-ampenyel. Nthakenh renh arey-alhey-angenh. Ra aremerremel atwewerr anenhantherrenh, ahawarr akngerr ipmew atwewerr. Anantherr mpwelhemer-tangkwel. Alakenh awenty ingwer-rnem iterrem, ‘Atyewey pwertay! David-rnemelan rernemant althenew Absalom-rnem!’ ");
INSERT INTO aly_vpl VALUES ("S217_10","011_17_10","2SA","17","10","10","Rernem alakenh iterrenty, rernemap atererrem. Arnkaty-rneman atererrewerr arrpemarl. Ingkerrelan iterl-areyel, aynengkw ngkwenh ikwerenh-rnem-then rlterrkarl. Nthakenh antengeley-angenh, arrangkw. ");
INSERT INTO aly_vpl VALUES ("S217_11","011_17_11","2SA","17","11","11","Alakenh-wety nga irremer: ahawarr-rnem-tangkwel akarrelemer Israel-itwew apmer arrpanenh-itwew, akngerr innga alperr-apeny. Ntwarrp renh-rnem yerl-akngem. ");
INSERT INTO aly_vpl VALUES ("S217_12","011_17_12","2SA","17","12","12","Nthakenh aynengkw irrtyert-aylpey-angenh anewantherr-wety. Anantherr renh arey-alhem, renh atwemel artewenty, rap anamerlarl ilwem. Ikwerenh-rnem ilwem arrpemarl. ");
INSERT INTO aly_vpl VALUES ("S217_13","011_17_13","2SA","17","13","13","Ra irrtyert-aylpentyan tawen anyent-itwew apek. Anantherr ingkerrenh lhelpelhelem warlan, apwert-rnem rwepel iytarr-akngemel arleng. Apmer aketh-anem aynteyelpeyew. Intem anantherr alakenh irrayntem antwerrkeyew-atety.” ");
INSERT INTO aly_vpl VALUES ("S217_14","011_17_14","2SA","17","14","14","Alerikw David-wenhel artwamp Israel-wenh-rnemel-then rernem awew, rernemap angkerrew, “Angka arrwekelenyan artwa anper arey-angker-wenhan mwerr-wenyarl. Angka kwertengerl Hushai-wenhan mwerrarl.” INGKARTel renh-rnem arnep-arnew, alakenh iterreyew. Ra ilkelhew, rernem apenteyew angka anyelkel-antey Hushai-wenharl, alerikw David-wenh renh irrwerneyew. INGKARTel artwerelew, rernem awewerr angka artwa anper arey-angker-wenh. ... ");
INSERT INTO aly_vpl VALUES ("S218_1","011_18_1","2SA","18","1","2","David-el akarrelew ahawarr ikwerenh-rnem, rap renh-rnem ilew akalkerreyew amentew-ament. Rap atyetyart ahawarr-rnem irrpety arrerneynew ikwer-rnem-akert, renh-rnem yerl-akngeyew; Joab, ayteyikw ikwerenh Abishai, Ittai Gath-areny-anem. Rap ingkerrenh ilew, aneyew 1,000 ingweran, 1,000 ingweran, 1,000 ingweran. Rap 1,000 ikwer-rnem atyetyart ahawarr anyentel-anyent arrernew. Irrkaty-angkwarr-anem rap akalkelhew arrpemarl 100-anemarl. Rap 100 ikwer-rnem atyetyart ahawarr anyentel-anyent arrernew. Rap angkew ingkerrew, “Mpa! Alhey-anem, atweyew anantherr renh-rnem! Ayengan alhem arrpemarl arrewantherr-angkwarr!” ");
INSERT INTO aly_vpl VALUES ("S218_3","011_18_3","2SA","18","3","3","Ahawarr-rneman angkew, “Arrangkwarl! Nthakenh nga apetyey-angenh anewantherr-angkwarr! Ngan artwa ilkwarl, anantherran arrangkwarl. Ngenharl rernem alwerneyel, ipmew atweyewan. Anantherran ingkerr anterrenty, rernem alwerney-angenharl. Anantherr ingkerr ilwenty, rernem iterrem, ‘Kel mwerr menty!’ Nga ilwentyan, rernem inkwerelhem inngarl. Mwerr ngan anaynta tawen nhenh-itwew-antey anteng. Anewantherr rlterrk irrentyan, ntwa ahawarr ingwer-rnem thwenem ingkern-they, alpemeleyew.” ");
INSERT INTO aly_vpl VALUES ("S218_4","011_18_4","2SA","18","4","5","David-el tyernew, “Kel. Ayeng awelhem, arrantherrarl angkew-angkwarr.” Rap arlkew atayel, akngerrel aweyew, “Joab! Abishai! Ittai! Athamerrenh-arey Absalom-ew! Ran alerey atyenhan!” Rap keytel rtnenh, ahawarr-rnem intwarenh, rernemarl anperl-alhew. ");
INSERT INTO aly_vpl VALUES ("S218_6","011_18_6","2SA","18","6","6","David-wenh-rnem anperlarr-alhew, Israel-wenh-rnem-anem rlwatemel artnampeny-itwew Ephraim-itwew. ");
INSERT INTO aly_vpl VALUES ("S218_7","011_18_7","2SA","18","7","8","Rernem arnerant-arey alwernerremel atwerrenh, artnitwew werrenh. David-rnemel Absalom-rnem antengelew, akngerr atwemel ipmew. Akngerr innga ingwer-rnemanap angkethakw aperrerterremel ilwernerrew artnitwew. Arlta ikwerel-antey akngerr ilwernerrew, 20,000 innga. ");
INSERT INTO aly_vpl VALUES ("S218_9","011_18_9","2SA","18","9","9","Rernemarl werrenheng-arey, alerikw David-wenh ra alhenh tangkey-akert. Rap aynikw-wenh-rnem-anem rlwateyelpew, rap anterreyew-anem arrkernelhew. Tangkeyan anterrew arwerl ilkwewarl arraty-antey kweneng-apert. Arwerl iylpeyl-atherrel renh itethey antwerrkey-ayntew, rap aynterrarrerrey-alhew, tangkeyan anper-anteyarl anterrew. ");
INSERT INTO aly_vpl VALUES ("S218_10","011_18_10","2SA","18","10","10","Artwa anyentel aynikw-wenhel renh arey-alhew, rap alhew Joab-warl. “Ngwamp innga atha alerikw David-wenh arerl-alhew, arwerl-itwewarl aynterrarrerrenh!” ");
INSERT INTO aly_vpl VALUES ("S218_11","011_18_11","2SA","18","11","11","Joab angkew ikwer apatemel, “Innga ntwarl arew? Ntwap renh anamerl-antey atwemer ipmew! Athan ngenh apwert akngerr anthem atyetyart ahawarr-wenh pilt-then!” ");
INSERT INTO aly_vpl VALUES ("S218_12","011_18_12","2SA","18","12","12","Artwa ran tyernew, “Nthakenh atha alakenh iley-angenh! Ya, ntwa rlengk apwert akngerr anthem ayenh. Athanap renh ipmew atwey-angenharl atyetyart-wenh alerikwan, arrangkw! Anantherr ingkerrel awew, rarl Ittai-then mpwelenh ilanthenh alakenh: ‘Absalom-ew amperrngerrenh-arey! Alerey atyenh-anteyarl ran!’ ");
INSERT INTO aly_vpl VALUES ("S218_13","011_18_13","2SA","18","13","13","Atha apek renh ipmew atwem, aynikw ikwerenhel anamerl-antey awem. Ran ingkerr iterl-areyel, rap ayenh-anemarl atwewerr ipmew. Ntwa apekan ayenh alpemeley-angenh, alakenh angkemel, ‘Ayengan arlarl! Ayengan ingwerarl!’” ");
INSERT INTO aly_vpl VALUES ("S218_14","011_18_14","2SA","18","14","14","Joab angkew, “Nthakenh ayeng mpwelhey-angenh ngkweng intem!” Rap irrtyart irrpety inerl-alhew, alhew-anem alerikw David-wenh-warl, arwerlelarl ra aynterrarrerrenh-warl. Rap arnelty-antey atanthew, rarl iteth-antey aynterrarrerrenh arwerl-itwew. ");
INSERT INTO aly_vpl VALUES ("S218_15","011_18_15","2SA","18","15","15","Artwa 10 Joab-itwew antelhew, rernemap renh ipmew-antey atwew. ");
INSERT INTO aly_vpl VALUES ("S218_16","011_18_16","2SA","18","16","16","Anamerl-antey Joab-el terampet angkelh-angkelhelew atayel. Alakenhan David-wenh-rnemel iterl-areyew, rernem ipmelheyelpeyew, Israel-wenh-rnem alwerney-angenh-anem. ");
INSERT INTO aly_vpl VALUES ("S218_17","011_18_17","2SA","18","17","17","Alerikw David-wenh rernem inew, iwemel renh irrka intwer-warl ampep-warl artnewarl. Apwert-rnem-anem rernem arrernew irrwerleng. Ikwerel-antey Israel-wenh-rnem arlperrty anterreynew angkep apmer ikwer-rnem-wenh-warl. ... ");
INSERT INTO aly_vpl VALUES ("S218_31","011_18_31","2SA","18","31","31","Ikwer-theyan Joab-el artwa anyent thwenew, angkep anterreyneyew David-warl angkakert. Rap angkey-alhew, “Atyetyartay! Angka mwerr-angker awa! INGKARTel atwew artewenty innga ingwer weth-rnem, ngkweng-wetyarl arlkarerrenh-rnem!” ");
INSERT INTO aly_vpl VALUES ("S218_32","011_18_32","2SA","18","32","32","David-el ayernew, “Alerey-alew atyenh Absalom? Mwerr-anteyang ra?” Artwa ra tyernew, “Irrwerney-angker weth-rnem, ngenharl alhengkerr anthenh, rernem ingkerrarl ilwemer artwa akely rapeny!” ");
INSERT INTO aly_vpl VALUES ("S218_33","011_18_33","2SA","18","33","33","David arlka apmwerreyelpew. Rap aylpenhew kwen-anem, keytelarl rtnenh-penh, artnemel artewenty. Rarl alpenhel, ra arlkenty iweynenh, “Alerey atyenh Absalom! Ayengarl ilwemeran. Ngan alerey atyenharl!” ... ");
INSERT INTO aly_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Arrwekeleny Abraham anenh. Abraham-they Jesus-kenh-rnem anenh arrpemarl, atyetyart David-ek-atwety. Nhenh-rnem Jesus Christ-kenh, ");
INSERT INTO aly_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham Isaac-kenh aynikw anenh. Isaac Jacob-kenh aynikw anenh. Jacob Judah-kenh aynikw anenh, alerikw ingwer-rnem-then Jacob-kenh. ");
INSERT INTO aly_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah Perez-kenh Zerah-kenh aynikw, Amikw ikwer-atherrenh Tamar. Perez Hezron-kenh aynikw, Hezron Ram-kenh aynikw. ");
INSERT INTO aly_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram Amminadab-kenh aynikw, Amminadab Nahshon-kenh aynikw. Nahshon aynikw Salmon-kenh. ");
INSERT INTO aly_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon aynikw Boaz-kenh. Amikw ikwerenh Rahab. Boaz aynikw Obed-kenh. Amikw ikwerenh Ruth. Obed Jesse-kenh aynikw. ");
INSERT INTO aly_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse Atyetyart David-kenh aynikw. David aynikw Solomon-kenh, amikw ikwerenh artwa Uriah-itwek arrwekel itengirrek. ");
INSERT INTO aly_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon Rehoboam-kenh aynikw, Rehoboam Abijah-kenh aynikw, Abijah, Asa-kenh aynikw. ");
INSERT INTO aly_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa Jehoshapat-kenh aynikw, Jehoshaphat Joram-kenh aynikw, Joram, Uzziah-kenh aynikw. ");
INSERT INTO aly_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziah Jotham-kenh aynikw anenh. Jotham Ahaz-kenh aynikw anenh. Ahaz Hezekiah-kenh aynikw anenh. ");
INSERT INTO aly_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah Manasseh-kenh aynikw anenh. Manasseh Amon-kenh aynikw anenh. Amon Josiah-kenh aynikw anenh. ");
INSERT INTO aly_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiah Jeconiah-kenh aynikw anenh, Jeconiah-kenh ayteyikw-rnem-then. Rernem iteth anenharl-antey, ahelengkw-rnemel Israel-kenh-rnem apmer Babylon-warl atnwenheynek-kety. ");
INSERT INTO aly_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Israel-kenh-rnem apmer Babylon-they alpek. Shealtiel aynikw ikwerenh Jeconiah. Shealtiel Zerubbabel-kenh aynikw anenh. ");
INSERT INTO aly_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel Abiud-kenh aynikw anenh. Abiud Eliakim-kenh aynikw anenh. Eliakim Azor-kenh aynikw anenh. ");
INSERT INTO aly_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor Zadok-kenh aynikw anenh. Zadok Akim-kenh aynikw anenh. Akim Eliud-kenh aynikw anenh. ");
INSERT INTO aly_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud Eleazar-kenh aynikw anenh. Eleazar Matthan-kenh aynikw anenh. Matthan Jacob-kenh aynikw anenh. ");
INSERT INTO aly_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob Joseph-kenh aynikw, Joseph Mary-kenh anewikw, Mary rey-antey Jesus renh ampa akely atnyenek. Renhey-antey itneweyel Christ-an. ");
INSERT INTO aly_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraham-they David-ek-atwety, 14 anenhek. Atyetyart David-they 14-ek-atwety arrpemarl anenhel Babylonia-el anenh-rnemek-atwety. Babylonia-el anenh-penh 14-ek-atwety anenhek Christ-ek-atwety. ");
INSERT INTO aly_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Mary Joseph-itwek itengirrey-angenh-antey, amperr-arenyel-antey. Mary ra Joseph alhelekarl anenh. Joseph ra arrwekeleny Atyetyart David-kenh arrpemarl, arleng-alenty ikwerenh-rnem anenhey-alpek. Itnweng Rlwartel Mary renh ampa akely anthek. ");
INSERT INTO aly_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joseph ra artwa arraty anenh. Ra iterrenh ipmelhetyek, artwa ingwer-akert-arrpantey. ");
INSERT INTO aly_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ra altyerr arek-anem. Ingkart-kenh angel-el renh ilek, “Joseph-ay, alerikw David-kenh, Itnweng Rlwartel ampa akely Mary anthek. Mary renh anew ngkweng inay, itengirretyek. ");
INSERT INTO aly_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Alerl ampa ra atnyeneyenh. Renh itnewa Jesus. Itna alakenh-anyem aynteyel ingkerrenh itethileyenh apmwekety.” ");
INSERT INTO aly_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ingkart ra arrwekel ilek-angkwarr-antey, innganem ra alakenh ayntek, angkakert arrwekelenyel arrwekel ilek-angkwarr-antey, rap innganem ayntekan. ");
INSERT INTO aly_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Aleyak ra ampa akely atnyeneyenh. Renh itneweyel Immanuel. Itnan alakenh-anyem aynteyel. Akngey anwekantherr-itwek anem.” ");
INSERT INTO aly_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joseph ra akemirrek, ratherr itengirrek-anem, angel-el renh ilek-angkwarr-antey. ");
INSERT INTO aly_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ratherr iteng ayntey-angenh, awey ra aney-alentyan. Mary-el Jesus renh atnyenek-anem. Joseph-el awey renh itnewek Jesus. ");
INSERT INTO aly_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herod atyetyart anenh-antey arrwekelan Jesus atnyenek apmer Bethlehem-itwek, ahern Judea-ampeny-itwek. Artwa rernem ayerrer-they apetyek apmer Jerusalem-warl. Antyarrantarl artwel-rnem iterl-arenh apmer nthek-angkwarr ra born-irrek. Antyarr aremirrek ikwer-rnem-warl. Antyarrel ikwer-rnem-warl iylparrernek, antyarr-angkwarrant rernem iterl-arek, antyarr renh apentetyek, rarl ikwer-rnem iylparrerneman, rarl ikwerel born-irrekan. ");
INSERT INTO aly_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Rernem ayernek, “Nthenh ampa akely ra, Jew-rnem-kenh atyetyart ilkwa? Anwantherr antyarr ikwerenh arenhey-alpenh, renharl antyarrel iylparrernek. Anwantherr antyarr renh aremel apentek. Anwantherr apetyek, ikwer inkwerelhemel.” ");
INSERT INTO aly_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Atyetyart Herod ra angka awek, rap arlkarirrek atyetyart ingwer Jew-rnem-kenh-kety. Jerusalem-areny ingwer-rnem arlkarirrek arrpemarl. Rernem aterirrenh atyetyart Herod-kety, ahelengkw-rnem ilanthekerr, renh-rnem atwetyek. ");
INSERT INTO aly_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herod-el-anem tyaty-areny atyetyart ilkwernem-then akarrilek, artwa Moses-kenh angka akalty-anthey-angker-rnem-then, renh-rnem ayernek, “Nthenharlap ran, artwa itethiley-angker nheng aynteyel. Nthenh-itwek ra aremirreyenhan, pip arrwekeleny Akngey-kenhel aynteyel-angkwarr-antey?” ");
INSERT INTO aly_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Rernem renh ilek, “Bethlehem-itwek, ahern Judea-ampeny-itwek, angkakert arrwekelenyel angkarl arrwekel ingkwernek-angkwarr-antey, ra irrkngarl ayntek. ");
INSERT INTO aly_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Akngey-kenh pip arrwekeleny alakenh aynteyel: ‘Judea-ampenyel Bethlehem-areny-rnem rernem atyetyart ilkwakert-anem aneyenh. Bethlehem-areny anyent ra atyetyart Israel-kenh-rnem arntarnt-areyenh.’” ");
INSERT INTO aly_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herod artwa tyak-rnemek anyelkel yangkelhek, renh-rnem ayernek, “Ilenger arrantherr antyarr arek?” ");
INSERT INTO aly_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ra renh-rnem ilanthek, “Bethlehem-warl alhenherr-arey, ampa ikwer nthwetyek. Arrantherr arenty-penh, arrantherr atyeng-warl apey-alpenherr-arey, ayenh-anem iletyek. Ayengan ikwer-warl alhetyek arrpemarl, ikwer inkwerelhetyek arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Artwa tyak-rnem Herod ikwer awelhek. Rernem antyarr wethey areynenh arrpemarl, awankarl rernem arek ayerrer. Rernem antyarr renh arek-penh, rernem ikwer artewentyel inkwerelhek innga. Ra ikwer-rnem iylparrernek. Antyarr ra ampa akely ayntenh-itwek-anem arlanirrek. ");
INSERT INTO aly_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Artwernem warl kwen-warl aylpenhek, amenheng-atherr arey-alhek. Rernem kwenirrey-alhek ampwethel alernelhemel. Rernem ikwer anthek ilek-ilek, apwert gold-then apernelhey-angker mwerr-angker inteyel-rnem-then. ");
INSERT INTO aly_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ikwer-penhan rernem altyerr arek. Rernem angkarl awek-penh, rernem ilek, “Arrantherr iwerr ingwer-angkwarr alpenherr-arey atyetyart Herod-kety.” Rernem iwerr ingwerel-anem ikwerety alpek. ");
INSERT INTO aly_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Artwa tyak rernem alpek-penh, Ingkart-kenh angel Joseph ikwer aremirrek, Ra renh ilek, “Akemirra, ampa akely-then amikw-then akngeyna Egypt-warl. Herod-arl ikwer nthweyel-kety, renh atwetyek. Arrantherr ikwer-itwel anem, atha arrenhantherr iletyek-atwety.” ");
INSERT INTO aly_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ingwa ikwerel-antey Joseph-el anew ikwerenh-then ampa akely-then Egypt-warl akngeynek. ");
INSERT INTO aly_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Rernem-anem aney-alpek. Herod ra ilwekarl-kety, Akngeyel renh-rnem ilanthek, rernem angkep alpetyek, Israel-warl. Akngey-kenh angka alakenh ayntek, angkakert arrwekelenyel ingkwernek-angkwarr-antey, “Atha alerey atyenh renh atwenhek, Egypt-they.” Angka arrwekeleny innganem ayntek. ");
INSERT INTO aly_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herod ra iterl-arek-anem, artwa tyak arleng-areny rernemarl renh irrtywerl-ampernek, ra ahelirrek-anem. Ra ahelengkw-rnem thwenek, awey akely-rnem atwetyek. Awey aherrety atherrek-atwety anenh-rnem, ra ingkerrenh atwetyek, artwa tyak-rnem awek-penh, arlta ilengerarl Mary-el Jesus renh atnyenek, rernemarl antyarr arek-penh-angkwarr. ");
INSERT INTO aly_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Angka innganem ayntek. Angkakert arrwekeleny Jeremiah ra arrwekel ilenh-angkwarr-antey, ");
INSERT INTO aly_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Apmer Ramah-itwek rernem artewentyel artnalhelirreyenh. Israel-kenh-rnem artneyenh ampa ikwerenh-rnemek, arternpirrey-angenh, rernemarl ingkerrenh ilwem.” ");
INSERT INTO aly_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Atyetyart Herod ra ilwek-penh, Ingkart-kenh angel ra altyerr-angkwarr aremirrek, Joseph ra Egypt-itwek anenharl-warl. ");
INSERT INTO aly_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Angel angkek, “Akemirra, ampa akely-then amikw-then akngeyna apmer Israel-warl. Ahelengkw ingkerrenh kel ilwekarl-kety.” ");
INSERT INTO aly_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Joseph ranem akemirrek, amenheng-atherr akngeynek apmer Israel-warl. ");
INSERT INTO aly_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Herod-kenh alerikw Archelaus ranem atyetyart ahern Judea-ampeny-itwek anenh. Joseph ranem awek-penh, ranem aterirrek. Ra altyerr arek, Ingkartelarl renh ilanthek, ra Galilee-warl alpetyek. ");
INSERT INTO aly_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Rernem Nazareth tawen-itwek aney-alpek. Akngey-kenh angkakert arrwekeleny-rnemel ingkwernek, “Renh-anem itneweyn ‘Nazareth-areny,’” Angka arraty innganem ayntek. ");
INSERT INTO aly_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ingwer-inger, John Baptise-emeley-angker ra ingwer-rnem akalty-antherl-apenh ahern Judea-itwek, apmer arlpaw-itwek. ");
INSERT INTO aly_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Angkepirrenherr-arey apmwekety Akngey-warl, arlta Atyetyart ikwerenh arrerirreyelarl-kety, ingkerrenhel anwantherr Akngey renhant-anem apentetyek.” ");
INSERT INTO aly_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","John rey-antey arlkeyel angkakert, Angkakert Isaiah-kenh pip arrwekel aynteyel: “Angkakert ra arlkeyel apmer arlpawel. Iwerr arraty-angkwarrant ingkerrenhel apenterl-ayntetyek!” ");
INSERT INTO aly_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Arnkwan ikwerenh alta kamwerl-penh, pilt yenp-penh arertnelhenh. Ra intelty-rnem arlkwenh, ngkwarl arwengalker-then. ");
INSERT INTO aly_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ingkerrenh apmer Jordan-ampeny-they John-warl akarrirrek apmer Judea-areny-rnem-then, Jerusalem-areny-rnem-then. ");
INSERT INTO aly_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Rernem ilelhek John-ek, rernemarl apmwakert anenh. John-el renh-rnem baptise-emelek Jordan ilpayek. ");
INSERT INTO aly_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pharisee-rnem-then Sadducee-rnem-then John ikwer-warl apetyek arrpemarl, renh-rnem baptise-emeletyek. John-el renh-rnem ilek, “Arrantherr apmwangkwarrant apenteyel. Kel ingwerentyel arrenhantherr ilek, arrantherr apmwekety angkepirretyek-arrpantey Akngey-warl! Akngey arrekantherr ahelirreyel-antey. ");
INSERT INTO aly_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Arrantherr innga angkepirretyek apmwekety, ingkerrenhel arrenhantherr aretyek. ");
INSERT INTO aly_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Arrantherr Abraham-kenh-rnem tnakelhey-angenh anetyek. Akngey ilkelheyel ingwerek-ingwer ikwerenh-rnem anetyek. Akngeyel Abraham renh arntarnt-arenh, rarl ikwer awelhenh. Ikwer awelheyel-rnem rernem ikwerenh-rnem innga aneyel. Akngey ra ampa akngerram-akngerrilem, rernem arraty-angkwarr apenterl-ayntetyek. Ran ilek-ilek mpwarem, artwernem apwert-penh mpwarey-angker. ");
INSERT INTO aly_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Artwa apmwernem arwerl apmwarl arternemel, rwewarl iwem-apeny. Alakenh-apeny arrenhantherr iwekerr, arrantherr arraty-angkwarr apentey-angenh-they.” ");
INSERT INTO aly_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Atha arrwekel arrenhantherr kwatyelant baptise-emelem, arrantherr apmwekety ipmelhetyek. Artwa ingweran atyeng-they rlterrk inngan apetyem, ingkern-theyarl. Ayeng rlterrk-wenyarl, warrkenh apmwamwamarl, ran Atyetyart inngarl. Ra Itnweng Rlwart arrerney-angker. ");
INSERT INTO aly_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Alakenh-anyem arlta ingkernel Akngeyel apmwangkwarrarl alheyel-rnem ingkerr-antey rwewarl iweyenh, irrarlkemel ampetyek, atherrk ilpatileyel-apeny.” ");
INSERT INTO aly_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesus Galilee-they anperl-alhek Jordan lher-warl, John-el renh baptise-emeletyek. ");
INSERT INTO aly_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","John arrkngert angkek, “Ilekek ngan atyeng-warl apetyek? Ntwa ayenh baptise-emeley-areny!” ");
INSERT INTO aly_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesus-el renh ilek, “Kel aleyan alakenh aynteyel: arraty-angkwarr-antey marenyel-areth, Akngey-kenh angka aynteyel-angkwarr-antey.” John-anem ikwer awelhek. ");
INSERT INTO aly_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","John-el Jesus renh baptise-emelek-anem. Kwaty-they tyerrelhenhey-alpek-anem kwenpay-anem amentant atherrirrekarl ra arek. Itnweng Rlwart ikwer-warl apetyek irrwerl-they, thip pwelker-apeny. ");
INSERT INTO aly_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ingkerrenhel awek alker irrwerl-theyarl angkek, “Nhanyem alerey atyenh, ayengan ikwer inkwerelheyel.” ");
INSERT INTO aly_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Itnwengel-anem Jesus renh atnwenhek apmer arlpaw-ampeny-warl, arrentyel renh arrkernetyek. ");
INSERT INTO aly_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesus ra amern arlkwey-angenh anenh, arlta 40-ek-atwety, angayakw. ");
INSERT INTO aly_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Arrenty ra ikwer-warl apetyek, angkemel, “Akngey-kenh alerikw apek nga. Apwert nhernem akngartewa, amern irretyek, Akngey-kenh rlterrk-akertel.” ");
INSERT INTO aly_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesus-el renh tyernek, “Akngey-kenh pipel aynteyel: ‘Ingwerenty nthakenh amernelant itethirrey-angenh. Rernem angka Akngey-kenh-angkwarrant itethirretyek.’” ");
INSERT INTO aly_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Arrentyel Jesus renh atnwenhek Jerusalem-warl, tern ilkwewarl. Akngey-kenh apmer aknganenty-warl. Arrentyel Jesus renh tyaty ilkwa Jew-kenh irrwerl-warl atnwenhek, warl irrwerl-itwek rnkernek. ");
INSERT INTO aly_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Arrentyel renh ilek, “Akngey-kenh alerikw apekap ngan? Kel irrwerl-they nhenh atnarnpa. Nthakenh nga atwelhey-angenh. Akngey-kenh pipel alakenh aynteyel: ‘Akngeyel angel-rnem thwenem, ngenh anterrkwetyek, atwelhekerr.’” ");
INSERT INTO aly_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesus-el renh tyernek, “Akngey-kenh pipel alakenh aynteyel: ‘Nthakenh Ingkart Akngey arrkerney-angenh rlterrkek, rlterrk ilkwangkwarr.’” ");
INSERT INTO aly_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ikwer-penh Arrentyel Jesus renh atnwenhek apwert irrwerl inngewarl-anem. Arrenty-anem ikwer lwewarrernek apmer ingkerr tern ilkwernem, apmer ilek-ilek-akert, mwerr-angker-akert. ");
INSERT INTO aly_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Arrentyel renh ilek, “Nga atyeng awelhemel kwenirrenty, atha ingkerrenh ngenh anthem.” ");
INSERT INTO aly_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesus-el renh tyernek, “Arrenty, atyengety alhay! Akngey-kenh pipel aynteyel: ‘Akngey anyent ikwerant awelhetyek, Ingkart Akngey renhant apenterl-ayntetyek.’” ");
INSERT INTO aly_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Arrentyel Jesus renh iwerl-alhek-anem. Angel irrwerl-areny ikwer-warl apetyek, renh arntarnt-aretyek. ");
INSERT INTO aly_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Artwa ahelengkw-rnemel John tyayl-warl akwernek. Jesus-el angka awek-penh, ra apmer Galilee-warl alhek. ");
INSERT INTO aly_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ra Nazareth-itwek aney-angenh, ra anper-antey alhek Capernaum tawen-warl, ikwer-itwel aney-alhek, apmer Zebulun-itwel, Napthali-itwel. ");
INSERT INTO aly_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Akngeyel angka arrwekel arrernek-angkwarr-antey, kel arraty-anem ayntek, angkakert Isaiah-el ilenh-angkwarr-antey. ");
INSERT INTO aly_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Awelhenherr-arey, Zebulun-areny-rnem-then, Napthali-areny-rnem-then, Jordan-they intwarr-ampeny, Galilee ahern artwa alethang-angketyarr. ");
INSERT INTO aly_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Arrantherr apatemel aneyel, ingwemerntel aneyel-apeny, Ingkart iterl-arey-angenh. Arrekantherr arrer-anem ilwetyekan. Lyenentyel arrekantherr arrtyerneyenh, arrantherr iwerr arraty-angkwarr apentetyek.” ");
INSERT INTO aly_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jesus ranem renh-rnem akalty-anthenh, “Angkepirrenherr-arey apmwekety Akngey-warl-athek! Arlta ikwerenh arrer-anem ra Ingkart ingkerrenhek anetyek.” ");
INSERT INTO aly_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesus alhenh Galilee kwaty alay impalth-angkwarr. Ra awayenheng-atherr arek. Anyent Simon itnan ingweran Peter, ingweran Andrew-arl. Netting ratherr kwaty-warl iwenh, irrpeng anterrkwetyek. ");
INSERT INTO aly_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesus-an angkek ikwer-atherr, “Apetyenherr-atherr atyeng-angkwarr, atha mpwelenh akalty-anthetyek, mpwel ingwer-rnem akalty-anthetyek Akngey-kenh angkek, rernem-anem apentetyek arrpemarl, irrpeng mentyarl.” ");
INSERT INTO aly_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ratherr ikwer-angkwarr antelherl-alhek netting iwerl-alhemel. ");
INSERT INTO aly_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jesus ra alhenharl-antey, ra James-then John-then arek, Zebedee-kenh alerikw-atherr. Ratherr rtnwa kwen-itwek, aynikw-itwek netting mpwarenh. Jesus-el renh-atherr ayernek arrpemarl, “Atyeng-angkwarr apetyenherr-atherr!” ");
INSERT INTO aly_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ratherr rtnwa renh iwerl-alhek, aynikw-then-antey, Jesus-angkwarr antelherl-alhek. ");
INSERT INTO aly_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesus ran ahern ingkerrenh-angkwarr alhenh Galilee-ampeny. Jew-rnem akalty-anthenh, Jew-kenh tyaty akely-rnem-itwek, angka mwerr-angker ilerl-apenh. Akngey rant atyetyart ingkerrenhek aneyel. Ranem arntety-rnem mwerrilerl-apenh. ");
INSERT INTO aly_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Rernem ahern Syria-ampenyel angka awek. Rernem arntety ilek-ilek-akert-rnem ikwer-warl akngetyek, arrenty-akert-rnem-then, arwengkw-rnem-then, nthakenh alhey-angenh-rnem-then. Jesus-el renh-rnem ingkerrenh mwerrilek. ");
INSERT INTO aly_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galilee-ampeny akngerr innga Jesus ikwer-warl akarrirrek, 10-pel tawen-areny-rnem-then, Jerusalem-areny-rnem-then, Judea-areny-rnem-then anyentirrek arrpemarl, Jordan ilpay intwarr-ampeny-they. ");
INSERT INTO aly_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesus-el akngerrarl arek-penh, ra apwert irrwerl-warl alhek kwertengerl ikwerenh-rnem-akert. ");
INSERT INTO aly_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ranem renh-rnem akalty-anthek. ");
INSERT INTO aly_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Rernemarl ikwer-warl angkepirretyek arrkernelheyel, Akngeyel renh-rnem arntarnt-arem. Rernem Akngey-kenh-rnem ingkerrenh anem. ");
INSERT INTO aly_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Rernemarl amperrngirreyel, Akngeyel renh-rnem arntarnt-arem, arternpilemel. ");
INSERT INTO aly_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Rernem iterl-arelheyel rernemarl ahern-areny-rnem arwa aneyel, rernem ahern-areny ingkerrenhek atyetyart aneyenh. ");
INSERT INTO aly_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Akngeyel ingwer-rnem arntarnt-arem arrpemarl, rernemarl ikwer arraty-angkwarr awelheyel, arratyirretyek ikwerenh-angkwarr. Akngeyel ikwer-rnem iwerr mpwarem, itnweng mwerr-angker anthemel. ");
INSERT INTO aly_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ingwer-rnem mwerrant-arey arntarnt-arerreyel, Akngeyel renh-rnem arntarnt-areyel ingkerrenh-anteyarl arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Arraty-angkwarr aneyel-rnem, Akngey ikwer-rnem inkwerelhem. ");
INSERT INTO aly_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Aylperrepwenty atyetyart ilkwernem aheketyarl arrkngert angkeyel-rnem, Akngeyel renh-rnem alerey antweyel. ");
INSERT INTO aly_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Rernem arraty-angkwarr alhetyek arrkernelheyel. Ingwer-rnemel renh-rnem irrwerneyelarl, Akngeyel renh-rnem arntarnt-arem arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Arrantherr atyeng-angkwarr alhetyek arrkernelheyel-rnem, ingwer-rnemel arrenhantherr irrwerneyelarl, Akngeyel arrenhantherr arntarnt-areyel arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Irrkngerney anaynta! Akngeyel ngenh atnyen-aynteman, apmer aknganenty-itwek. Awank-akerrarl ingwerel-rnem Akngey-kenh angkakert-rnem irrwernek-apeny, aleyarl aynteyel arrpem.” ");
INSERT INTO aly_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Aker-warl thalt arrernem. Thalt-penh nthakenh apmwirrey-angenh, intengirrey-angenh, arleng-alenty mwerr ayntem. Thalt-weny aker anamerl intengirrem, ikweweny. Alakenh-anyem Akngey-kenh angka aynteyel. Akngey-kenh angkekety amentirrenty, rap aleth-antey apmwirreman, Akngey-kenh-angkwarr apentey-angenh. Ikwer-angkwarr akaltyirrenty, rernem arleng-alenty mwerr aneman. ");
INSERT INTO aly_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Lyenentyel arrtyernem-apeny, iwerr aketh arem. Ahern-areny ingkerrenhel arrenhantherr aketh-antey arem arrpemarl, nthenh-angkwarr alheman. Warl-rnem apwert irrwerl-itwek artelhenharl. Ingwer-rnemel anaynt arem arleng-they. Ingwer-rnemel arrenhantherr anaynt arem arrpemarl, rernem arraty-angkwarr apenteyelan. ");
INSERT INTO aly_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Lherrm ampenty, nthakenh ntwa tyampet-warl akwerney-angenh. Renh akethek-anem arrernetyek irrwerl-warl, ingkerrenhel anaynt aretyek. ");
INSERT INTO aly_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Arrantherr arraty-angkwarr apententy, ingwer-rnemel arrenhantherr aketh arem arrpemarl, rernem Akngey-kenh-angkwarrant apentem arrpemarl, ikwer inkwerelhemel.” ");
INSERT INTO aly_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Angka Moses-kenh aynteyel, angka arrwekeleny angkakert-rnemel pip-warl ingkwernek aynteyel arrpemarl. Atyeng arrantherr iterreyel, ayeng angka ingwer-akert apetyentyek-athen, angka Moses-kenh arrwekelenyek iylpelirrentyek-athen. Angka nthakenh iparelhey-angenh. Ayengan apetyek atha Akngey-kenh angka irrkaty renhey-antey arrekantherr iletyek, angka Akngey-kenh arlperrtyiletyek, ywerreyek-atwety. ");
INSERT INTO aly_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Arraty innga atha arrenhantherr ileyel. Angka Akngey-kenh ywerrey-angenh, ahern-then alker-then ywerrey-alenty. ");
INSERT INTO aly_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Angka Moses-kenh arrwekeleny-kety amentirrenty, ingwer-rnem apmwel-aretharl akalty-anthenty, arrantherr apmwelhileyel Akngey-kenh-angkwarr. Angka Akngey-kenh arraty apententy, ingwer-rnem arraty akalty-anthenty, arrantherr Akngey-angkwarr mwerrarl aneyenh. ");
INSERT INTO aly_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Pharisee-kenh-rnem, artwa ilkwa Moses-kenh-rnem rernem apmwangkwarr apenteyel. Arrantherr arraty-angkwarr apenterl-ayntetyek. Arrangkwelan, angka Pharisee-kenh Moses-kenh apententy, arrantherr Akngey-kenh apmer-warl aylpey-angenh.” ");
INSERT INTO aly_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Moses-kenh angka arrwekeleny angka alakenh ayntenh, ‘Ra ingwer ipmek atwenty, renh angkep atweyenh arrpemarl.’ ");
INSERT INTO aly_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Athan arrenhantherr ileyel, ‘Ingwerentyel apek iltenty, arlta ingkernel Akngeyel renh ayerneyenh arrpemarl. Arrantherr ingwer-rnem apmwa antwenty, rwa aknganenty arrwekel ikwer mpwelheyel arlta ingkernel.’ ");
INSERT INTO aly_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Ngethen ingwerenty-then ahel mpwelanth ilterrekarl-penh, nga ikwer-warl alhetyek-tangkwel, sorry antwelhetyek, tyaty-warl aylpey-angenh, Akngey renh tyenkerr anthey-alenty. Ahenp-antey alhey-angenh. Ikwer-penh-anem ntwa Akngey renh tyenkerr anthey-alpem-anem, mwerrant-atherr anetyek. Alakenh-anyem Akngey-angkwarran mwerrant-arey anetyek. ");
INSERT INTO aly_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Arrkent arwa ilterrey-angenh. Angketangkwel arratyilerrey mwerr-angkwarr, ra ngenh court-warl akngekerr, court-arenyel ngenh tyayl-warl akwernekerr. ");
INSERT INTO aly_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Fine ilkwa ntwa payemeley-angenh, nthakenh nga tyerrelhey-angenh.” ");
INSERT INTO aly_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Akngey-kenh angka alakenh aynteyel: ‘Ingwer-kenh anewikw nthakenh ikngwey-angenh.’ ");
INSERT INTO aly_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Athan arrenhantherr arraty ileyel, angka awerr innga. Nga arelh ingwerek ahenty anenty ikngwetyek-arrpantey, ngap apmwangkwarr iterreyelan. ");
INSERT INTO aly_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ntwa apek apmwangkwarr mpwareyel anngel. Ntwa apek annga atherr-akert apmwangkwarr mpwareyel-kety, mwerr ntwa annga anyent tyerrelhemel iwetyek, ngap Akngey-kenh apmer-warl aylpeman, annga anyent-akert. ");
INSERT INTO aly_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ntwa apek apmwangkwarr mpwareyel itepel. Ntwa apek itep atherr-akert apmwangkwarr mpwareyel-kety, mwerr ntwa itep anyent akelhem iwemer, mwerr-angkwarr Akngey-kenh apmer-warl aylpetyek.” ");
INSERT INTO aly_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Angka arrwekeleny alakenh aynteyel: ‘Mwerr arelh ikwerenh iwem. Artwa pip-warl itna inkwernelhemel, arelh ikwerenh pip renh anthemel, arelh ra pip renh aremel, artwa renh iwey-alentyan.’ ");
INSERT INTO aly_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Athan arrenhantherr arraty ileyel, angka atyenh awerr. Arelh ra artwa ingwer-angkwarr antelhenty, kel alakenh mwerr iwemarl. Arrangkwarl, arelh ngkwenh ntwa iwenty apmwel-areth, Akngey-angkwarr apmwa aynteyel.” ");
INSERT INTO aly_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Arrwekeleny-kenh aynteyel arrpemarl, ‘Ingkart itnewemel irrtywerremel ilelhey-angenh, Ingkartel arem.’ Arraty ntwa angkayntetyek. ");
INSERT INTO aly_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Angka atyenhan awerr, atharl arrenhantherr ileyel. Alkenh itnewey-angenh, irrtywerremel ilelhey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ahern itnewey-angenh arrpemarl, ikwerenh arrpemarl. Jerusalem itnewey-angenh arrpemarl, apmer ilkwa atyetyart impen ikwerenh arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Irrtywerremel ilelhey-angenh, arratyant nga ilelhetyek. ");
INSERT INTO aly_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yaw apek, arrangkw apek, alakenh arraty innga nga ilelhetyek. Ingwer-angkwarr nga ilelhenty, arrenty-kenh-angkwarrarl.” ");
INSERT INTO aly_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Angka arrwekeleny aynteyel: ‘Ingwerentyel annga atwenty, ntwa renh annga angkep atweynetyek arrpemarl. Ingwerel ngenh arntek renh atwenty, renh arntek atwem arrpemarl.’ ");
INSERT INTO aly_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ayengan arrekantherr-warl angkem, ngenh apek arreyl anyent-ampeny atwenty, renh angkep atwey-angenh, aleth-antey atwerrerl-anekerr. Nga menty anthelhetyek ra ngenh arreyl ingwer-angkwarr-anemarl atwenty. ");
INSERT INTO aly_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ingwerentyel kwet ngkwenhek ayernenty, ntwa kwet renh alhewer anthem arnkwa ingwer-then anthem. Akngey-kenh-angkwarr alakenh aynteyel. ");
INSERT INTO aly_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ingwerentyel ngenh ilanthenty, ikwer-angkwarr alhetyek, nga ikwer-angkwarr alha anper-antey, ikwer awelhemel. Angath-antey alhey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ingwerentyel ngenh amernek ayernenty angayakwel, ntwa renh amern anthetyekan. Ampwal ilek-ilek renh anthetyek arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","44","“Ingwer-rnemel ileyel, ikwer-rnem-kenh arntarnt-arayntetyek. Angka atyenhan awerr, atharl arrenhantherr ileyel, alakenh aynteyel, ingkerrenh arntarnt-arayntetyek alethang-rnem-then arntarnt-arayntetyek. Ingwerentyel ngenh irrwernenty, ntwa Akngey ayernetyekan ikwer, renh arntarnt-aretyek. ");
INSERT INTO aly_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Arrantherrap Akngey-kenh-rnem ingkerrenharl aneman, arrantherrap alakenh mwerrant-arey anetyek. Akngeyel ingkeny arrernek ingkerrenhek, apmwernemek-then mwerr-rnemek-then, ilek-ilek ra anthek, kwaty anthek, amern ingkerrenh lyapelhiletyek, aker-then anteril-ayntetyek atherrkeny. ");
INSERT INTO aly_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ahern-areny-kenh alakenh aynteyel, ngkwenh-rnemant arntarnt-arayntetyek apmelerreny. Apmwamwam man kapmentek iney-angker-rnem rernem arntarnt-arayntetyek arrpemarl, apmelerreny. Akngey-kenh ingwer-angkwarr aynteyel, ingkerrenh arntarnt-arayntetyek. Alakenh Akngeyel anwenhantherr angkep antheman. ");
INSERT INTO aly_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ingwer-rnem Akngey apentey-angenh-rnem rernem ikwer-rnemekant inkwerelheyel. Alakenh-apeny-weny anayntetyek mwerr-angkwarr. ");
INSERT INTO aly_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Arrantherr mwerr innga anayntetyek, Akngey irrwerl-areny aneyel-apeny.” ");
INSERT INTO aly_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mwerr-arrpantey tnakelhey-angenh, arraty-angkwarr nga anetyek, ingwer-rnemel arrenhantherr awekerr. Arrantherr tnakelhenty, Akngey irrwerl-arenyel arrenhantherr nthakenh arntarnt-arey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ntwa irrpern-rnem man anthenty, ingwer-rnem akarriley-angenh, rernem ngenh aretyek. Apmwangkwarr alheyel-rnem rernem alakenh tnakelheyel, tyaty akely kwenel iwerr impalthel, ingwer-rnemel renh-rnem aretyek, tnaketyek. Atha arrenhantherr arraty ileyel, Akngeyel renh-rnem anthey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ntwa irrepern-rnem arnkwa anthenty anyelkel-antey, tnakelhey-angenhel, ingkerrenhel ngenh arekerr, ");
INSERT INTO aly_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Akngeyelant ngenh aremel, rap ngenh arntarnt-arem arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ingwer-rnem alhem tyaty akely-rnem-warl, aketh-warl, Jew-rnem angkerreyel-warl. Akngerr akarrirrenty, rernem angkem Akngey-warl, ingwerel-rnem renh-rnem mwerr-arrpantey aretyek, tnaketyek. Rernem tnakelheyel. Akngey alakenh-kety arlkarirreyel. Kel ra renh-rnem arntarnt-arey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ament Akngey-warl angkenty mwerrarl. Akngey ilkelheyel, ngenh arntarnt-aremarl. ");
INSERT INTO aly_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Arrantherr aleth-antey angkey-angenh, artwa ingwer-arenyel-rnem angka akngerrileyel-apeny ingkart ikwer-rnem-kenh-warl. ");
INSERT INTO aly_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Aleth angkey-angenh, rernem angkeyel-apeny. Anyent-inger-antey angketyek, kel ra ngenh aweyelarl. ");
INSERT INTO aly_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Arrantherr alakenh ayernem, ‘Akngey anwekantherrenh, ngarl irrwerl aneyel. Ingkerrenh akalty-antha, anwantherr ngenh arraty iterl-aretyek. ");
INSERT INTO aly_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Apey-alha, ingkerrenhek ingkart anetyek. Ingkerrenh arratyila, ngkweng awelhetyek, irrwerl-areny ingkerrenh ngkweng awelheyel-apeny. ");
INSERT INTO aly_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Anwenhantherr intem-antey amern antherl-aynta. ");
INSERT INTO aly_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Apmwa anwekantherrety iwa, anwernantherr arratyilerretyek, mwerrant-arey anwernantherr anetyek. ");
INSERT INTO aly_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Anwernantherr apmwewarl irrekerr atnyena. Arrenty anwernekantherr irrpelthirreyelarl-kety, anwernenhantherr arntarnt-ara.’” ");
INSERT INTO aly_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Jesus-el renh-rnem ilek, “Arrantherr ingkerrenh mwerrant-arey-anem anetyek atwerrey-angenh, Akngeyan arrekantherr ingkerrenhek inkwerelhem, apmwa ingkerrenh-kety, arrekantherrety Akngeyel iwem. ");
INSERT INTO aly_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Arrangkwelan, Akngeyel apmwa arrekantherrety iwey-angenh.” ");
INSERT INTO aly_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ingwer-inger amern-kety ipmelhem, amernekant aleth iterrey-angenh, Akngeyekant iterrerl-ayntetyek. Ingwer-rnem artwerrety anew-aneyel, irrepern antwelhemel. Akngey ikwer-rnem inkwerelhey-angenh, renh-rnem angkep anthey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Alakenh amern-kety ipmelhenty, artwerrety aney-angenh. Inngerr lhewelhem apmelerreny-angkwarr. Irrepern antwelhey-angenh ingwer-rnemek. ");
INSERT INTO aly_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Akngeyel kel aketh-antey areyel, arrenhantherr angkep anthem.” ");
INSERT INTO aly_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ampwal akngerr ayerrpiley-angenh ahern nhenh-itwek. Arrangkwarlap ikwer-angkwarran. Ampwal akngerr apwert man-then akarriley-angenh, ingwerentyel irrtyert-inekerr, interrkel arlkwekerr. ");
INSERT INTO aly_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Arraty-angkwarr apenterl-ayntem. Rap arrernem ilek-ilek mwerr-angker arrekantherr irrwerl-itwek. Mwerr-angker ayntayntem intem-antey irrwerl-itwek, nthakenh ywerrey-angenh, arrangkw. Ingwerentyel irrtyert-iney-angenh, interrkel arlkwey-angenh, arrangkw. ");
INSERT INTO aly_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Arrantherranap ampwal ikwer-rnemant iterreyel, arrantherr ampwal renh-rnemant apenteyel.” ");
INSERT INTO aly_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Annga mwerr-akertel ntwa iwerr arraty apenteyel-apeny, anaynt-apeny. ");
INSERT INTO aly_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Aparrngelan iwerr arraty apentey-angenh arrangkwarl, aperrertirrerl-alpeyel. Aparrngel-apeny rernem apmwangkwarr apenteyel, atwemengkel-apeny. Rernem Akngey-kety amentirreyel.” ");
INSERT INTO aly_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Arrantherr apwert man akngerrekant iterrerl-anenty, arrantherrap Akngey-kenh angkek-anem iylpelirrem-anem, Akngey-kenh angkan apentey-angenh, amentewarl-anem. Akngey-kenh angkan impenarl. Manek artewentyel iterrey-angenh, Akngey-kenh angkekant artewentyel iterr-ayntetyek. Nthakenh ntwa atherr-angkwarr apentey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Alakenh iterrey-angenh, ‘Amern ilek atha arlkwetyek, ilek atha antywetyek, arnkwa ilek-warl ayeng aylpetyek?’ Iteth anayntetyekant nga iterr-ayntetyek, Akngey-kenh-angkwarr apenterl-ayntetyek. ");
INSERT INTO aly_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Thip yanh-rnem arenh-arey. Thip nthakenh amentel amern lyapelhiley-angenh, amern warl-warl akwerney-angenh, awakelhey-angenh. Akngey irrwerl-areny rant thip-rnem wanteyel, arntarnt-areyel. Arrantherr Akngey-kenh impen thip-rnem-angkwarr. Anwenhantherr arntarnt-areyel arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Arrantherr artewentyel iterrerl-anenty, arrantherrap arwapeny ywerreman. ");
INSERT INTO aly_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","29","Arnkwekant iterrey-angenh. Solomon arnkwa mwerr-angker-warl aylpenh. Arnkwan ikwerenh ahern-areny-kenhant. Akngeyelant alpeyt mwerr-angker arrernek ahern nhewarl. Alpeyt arnkwernem-angkwarr mwerr-angker inngarl inngelheyel! Alpeyt yanh-rnem arenherr-arey! Anyentel-antey aneyel rernem arnkwel mwerr ilelhey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Akngeyel atherrk lyapelhileyel. Atherrk arlenyirrem aherretyel, rernem antywer arrtyem. Akngeyel atherrk renharl arntarnt-areyel-apeny, ra anwenhantherr iwerl-alhey-angenh arrpemarl, arnkwa ilek-ilek anthemel arntarnt-arem mwerr-angkwarr. Arrantherr apal, Akngey renh tnakey-angenh, rarl anwenhantherr ingkerrenh arntarnt-arem. ");
INSERT INTO aly_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","32","Artewentyel iterrey-angenh, ‘Ilek anwantherr arlkwem, ilek anwantherr antywem, arnkwa ilek-warl anwantherr aylpeman?’ Ingkart apentey-angenh-rnem alakenh iterreyelan. Akngey alker-areny ra arrenhantherr areyel, ranem arrenhantherr ilek-ilek antheman, arntarnt-arem-then. ");
INSERT INTO aly_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Arrantherr-anem ikwerenh-angkwarr apenterl-ayntetyek arraty-angkwarr, Akngeyel arrenhantherr atnyenem. ");
INSERT INTO aly_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ampwal ilek-ilek akngerr arrerney-angenh ingwer-ingerek. Ngant ikwerant iterretyek. Arlta arrpanenhel Akngeyel arenhantherr arntarnt-areyelan.” ");
INSERT INTO aly_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Arrantherr ingwer-rnem tyatyemiley-angenh, akngakey-angenh. Arrantherr renh-rnem apmwa antwey-angenh, Akngeyel ngenh arrpemarl ilekerr. ");
INSERT INTO aly_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nga mwerr-arrpantey ilelhenty, ngap irrtywerreyelarl. Alakenh Akngeyel ngenh akngakeyenh mwerr-rnem-they. ");
INSERT INTO aly_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Artwa anyent annga arwerl-akert nthakenh arey-angenh. Mwerr-arrpantey irrtywerremel ilelheyel. Ra artwa ingwer annga ahern-angketyarr ileyel, ‘Annga ahern-akert irrarlkelha ntwa anaynt arey-alkenh!’ ");
INSERT INTO aly_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nthakenh ingwerek alakenh angkey-angenh, ‘Atha ahern akely irrarlketyek annga ngkweng-itwel.’ Arrangkw! Ra apek arrkay arem, annga arwerl ilkwakert. ");
INSERT INTO aly_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Rarl alakenh angkem, rap irrtywerremarl. Ra arwerl anngethey-tangkwel tyerrelhem, mwerr-anem arey-kety. Rap ahern akely irrarlkem annga ingwer-itwek-anem.” ");
INSERT INTO aly_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Nhanyem angka Akngey-kenh impen. Rant angkepiley-angker. Ahern-arenyelant-amperl nthakenh angkepiley-angenh. Apwert mwerr-angker impen, nthakenh pikepik anthey-angenh. Aker mwerr-angker arengk apmwa nthakenh anthey-angenh. Akngey-kenh angka impen arrpemarl apwert mwerr-angker impen-apeny.” ");
INSERT INTO aly_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","“Ntwa Akngey ayernenty, ranap ngenh anthemarl. Ntwa renh ayernenty, ranap ngkweng lwewarrernemarl. Ran iwerr ngkweng mpwareyel, ntwa ikwerenh-angkwarr apentetyek. Inngarlap ran! Akngey ranap ngkweng mpwaremarl, ngap aylpenhem-anem. ");
INSERT INTO aly_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Alerengkwel ngenh amernek apek ayernem. Ntwa apwert ikwer anthey-angenh, arrangkw! Ntwa amernant anthem arlkwetyekan. ");
INSERT INTO aly_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Alerengkwel ngenh aker irrpengek apek ayernem. Ntwa rtnwem ahelengkw ikwer anthey-angenharl, arrangkw! Ntwa aker irrpengant anthetyek arlkwetyekan. ");
INSERT INTO aly_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Arrantherran apmwamwam aneyel, arrantherrap iterl-areyelarl, ilek-ilek mwerr-angker anthayntetyekan ampernemek. Akngey irrwerl-arenyan arrantherr-apeny-wenyarl, ilek-ilek anthey-angker. Ra mwerr-angkerarl arrekantherr anthem, arrantherr renh ayernentyan. Rant iterl-areyel. ");
INSERT INTO aly_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Anwantherr ilkelheyel ingwer-rnemel anwenhantherr mwerr-angkwarr arntarnt-aretyek. Alakenh anwantherr mwerr-angkwarr renh-rnem-tangkwel arntarnt-aretyek. Akngey-kenh angka arrwekeleny aynteyel, Moses-kenh-angkwarr angkakert ingwer-rnem-angkwarr-then.” ");
INSERT INTO aly_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Iwerr akely alpeyel Ingkart-kenh-angkwarr, nga arraty-angkwarr apentetyekan. Akngerr alpeyel iwerr ilkwangkwarr, apmwel-aretharl alheyel-rnem. Akngeyel renh-rnem ywerrelhileyenh. ");
INSERT INTO aly_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Irrpetyap alheyel Ingkart-kenh-angkwarran. Rernem iteth intem-antey aneyenh.” ");
INSERT INTO aly_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mwantyel arntarnt-arelhetyek mwerranty arraty apentetyek artwa apmwernem-kety. Rernem irrtywerremel angkakert mwerr-arrpantey ilelheyel-kety, yep-yep-rnem anik mwerr aneyel-apeny. Artwa apmwernem ahelirreyel arengk artnwerel ahelirrem-apeny tnhwerremel. Rernem apmwangkwarr akalty-antheyel, ngenh apmwewarlilekerr. ");
INSERT INTO aly_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Apmwarlap ran, arwerl arleny-apenyarl. Arwerl arleny-penh nthekwern amern iney-angenh. Apmwa nthekwern akey-angenh, amern arnwekety akey-angenh arwerl arleny-penh apmwarl. Amern akatyerr akey-angenh arwerl arntek-arntek-penh apmwarl.” ");
INSERT INTO aly_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jesus-el angka ingwer-anem ikwer-rnem ilenh. “Arwerl ingweran amern mwerr-akertarl, arwerl apmwarenyan amern mentyarl. ");
INSERT INTO aly_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Arwerl arleny-penh nthekwern amern akey-angenh. Amernek ywarn nthweyel. ");
INSERT INTO aly_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Arwerl arlenyan apmwarl, rwewarl iwem arwerl renh. ");
INSERT INTO aly_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Angkakert irrtywerrey-angker-rnem rernem arwerl arleny-apeny. ");
INSERT INTO aly_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Apmwel-areth aneyel-rneman rernem arlkeyenh, ‘Ay, Ingkartay.’ Rernemap Akngey-kenh-warl aylpey-angenh. Arraty-angkwarr apenteyel-rnemant, Akngey ikwerenh-rnem aneyenh. ");
INSERT INTO aly_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Arlta ingkernel ingwer-rnem arlkeyenh, ‘Ay, Ingkartay. Anwantherr angka ngkwenh ilerl-apenh arrpemarl, anwantherr arrenty-rnem irrentek, itna ngkwenh itnewemel, ilek-ilek mpwarek, rlterrk ngkwenh-akertel.’ ");
INSERT INTO aly_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Athan renh-rnem ileyenh, ‘Alpenherr-arey atyengety, athan arrenhantherr iterl-arey-angenharl.’” ");
INSERT INTO aly_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Rernem apek angka atyenh awek-penh, rernem arraty-angkwarr apenteyel rlterrk-anem, artwa warl apwert irrwerl rlterrk-itwek artek-apeny. ");
INSERT INTO aly_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kwaty-anem rntwey-alhek, atnyerr ilkwanem alhek. Warl atakelhey-angenh arrangkw, ra anyentel-antey apwert rlterrk ikwerel cement-apeny-itwek artelhenh. ");
INSERT INTO aly_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Artwa ingwerel angka atyenh arwa iylpelant awek atyeng awelhey-angenh. Ra anamerl ywerreyenh warl apmwamwam anamerl ywerrek-apeny. ");
INSERT INTO aly_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kwaty ilkwa rntwey-alhek. Atnyerr alhek, awerel rlterrk pwey-alhek, warl apmwamwam renh-anem atakenhek, kel. Warl rlterrk intem-antey aneyenh, warl apmwamwam arrangkwarl, angath-antey atakelheyel. Artwa akalty intem-antey aneyel, Akngey-kenh. Artwa arwengk angath-antey ywerreyenh, warl apmwamwaman angath-antey ywerremel atakelhek-apeny.” ");
INSERT INTO aly_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Jesus rarl angka ilenh-penh, ingkerrenh-anem apatek, rarl renh-rnem rlterrk innga akalty-anthek Akngey-kenh-angkwarr, artwa Jew-kenh akalty-anthey-angker-rnemel rlterrkel akalty-anthey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesus apwert-they atwarrerl-alhek, akngerr ingwer-rnemel renh apentek. ");
INSERT INTO aly_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Artwa tywen-angketyarr apetyek Jesus-warl. Tywen ywerrey-angenh intem-anteyarl anenh. Ra kwenirrenh Jesus-itwek, ampwethel alernelhemel. Ra angkek, “Nga rlterrk inngan, mwerriley-angker. Ntwa ayenh mwerriletyek tywen-rnem atyeng-they ywerrelhila, ayeng tywen-weny alyelk-anem anetyek.” ");
INSERT INTO aly_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesus ranem renh arnep-arnek, angkemel, “Ayeng ilkelheyel, ngenh atha mwerriletyek.” Tywen-rnem arwapeny ywerrerl-alhek, mwerrirreyelpek. ");
INSERT INTO aly_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesus ra arrkngert angkek, “Akater-anem aney-alpa! Ingwer-rnem-warl ilelhey-angenh anetyek, atharl ngenh tywen-angketyarr-penh mwerrilek. Atyetyart tyaty ilkwa Jew-rnem-kenh-arenyek nga anyentekant ilelhey-alpa, ra ngenh mwerr-anem aretyek. Ntwa aker tyenkerr Atyetyart antha! Moses-kenh angka aynteyel, aker Atyetyartek anthetyek, ingkerrenhel ngenh aretyek, ngarl mwerrirrek-anem, ntwarl aker tyenkerr Atyetyart anthek.” ");
INSERT INTO aly_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesus apmer Capernaum-warl-anem alpek. Artwa ahelengkw atyetyart irlkentyek-artwey Rome-areny ikwer-warl apetyek, ayernetyek. ");
INSERT INTO aly_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ingkartay, warrkenh atyenh arlan aynteyel, akngelhey-angenhirrek, arlka ingkerr kwarnelheyel-kety.” ");
INSERT INTO aly_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesus angkek, “Ayeng alhem ngkweng-angkwarr, renh mwerriletyek.” ");
INSERT INTO aly_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Atyetyart irlkentyek-artwey ilelhek, “Ngan ilkwarl atyeng-angkwarr. Ayengan artwa apmwamwamarl. Ayeng nyerrirreyel ngkwengety, atha ngenh warl atyenh-warl atnwenheynekerr. Nga arntety ikwer angka, renh mwerriletyek. ");
INSERT INTO aly_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ayeng atyetyart arrpemarl ingwer-rnemek. Atha apek anyent ilanthem, rap awelhemarl. Atha anyent ingwerek arlkem, rap atyeng-warl apetyem. Atha warrkenh anyent ilanthenty, rap awelhemel warrkirremarl. Ngan atyetyart ilkwa innga, ingwer-rnem ngkweng awelhemarl.” ");
INSERT INTO aly_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Artwa renh awek-penh Jesus ra apatek, rantarl renh-rnem ilek, “Artwa nhenhelant ayenh tnakeyel innga, ayengarl rlterrk ilkwakert, arleng-they mwerriley-angker. Ranap Jew-wenyarl, alethangarl. Nhareny-rneman arrangkwarl. ");
INSERT INTO aly_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Akngerr akarrirreyenh apmer arrpanenh-they amern kwenty arlkwetyek arrwekeleny-rnem-itwek. Abraham-akerr, Isaac-akerr, Jacob-akerr, Rernem ingkerr anerl-aneyenh Akngey-itwel. Akngey-kenh-rneman ingkerrenh mwerr anayntem, inkwerelhemel amern kwenty arlkwerl-anemel. Jew-rnem alethang-rnem-then pweytirreyenh anerl-anemel arrpemarl. Akngeyelanap renh-rnem ingkerrenh arntarnt-arerl-aneyenh. ");
INSERT INTO aly_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Jew-rnem Akngey-kenh arrwekel anenh-rnem arrangkwarl. Rernem ywarn iterremel arrangkeyenh, Akngeyarl ikwer-rnem-kety intwemelirreyenh-kety.” ");
INSERT INTO aly_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesus-el atyetyart renh ilek, “Kel alpa, atha warrkenh ngkwenh mwerrilek, ntwarl ayenh tnakek.” Kel warrkenh ra mwerrirreyelpek. ");
INSERT INTO aly_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesus-el awek, arelh ampwa Simon-kenh arntety rwenparl ayntenh. ");
INSERT INTO aly_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesus alhek ikwer-warl, itep ikwerenh anterrkwek. Arelh ranem mwerrirrek. Ra akemirrek, amern-anem ra ampernek Jesus-ek. ");
INSERT INTO aly_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Atwemengkel ingwer-rnemel atnwenhey-alhek arrenty-akert-rnem Jesus ikwer-warl. Ranem arrenty-rnem irrentek ikwer-rnem-they, Akngey-kenh angka rlterrk-akertel, arntety-rnem-then mwerrilek. ");
INSERT INTO aly_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Alakenh angkakert Isaiah-el angka arrwekel ingkwernek, ra innganem irrek, “Ra arntety-rnem ingkerrenh mwerriley-angker.” Alakenh angka arraty innganem irrek. ");
INSERT INTO aly_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesus-el artwa akngerr arek. Ra angkek kwertengerl ikwerenh-rnemek, “Mpa, kwaty ilkwangkwarr anwantherr artarnpenhey intwarr-ampeny-warl.” ");
INSERT INTO aly_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Artwa anyent atyetyart Moses-kenh rap angkek Jesus-ek, “Atha ngenh apentetyek, ingweram-angkwarr nga alhenty.” ");
INSERT INTO aly_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesus-el renh tyernek, “Arengk artnwer rernem inteyelarl aynteyel. Thip-rnem atharlkwel aneyel, Artwa Impen Akngey-kenh ayeng apmer-weny arrangkwarl, ayeng arwarl apmer arrpanenh-warl alheyel.” ");
INSERT INTO aly_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kwertengerl anyent ikwer angkek, “Ingkartay! Akngey atyenh ilwetyek arrer-anem. Ayeng alpetyek, renh arntarnt-arey-alpetyek. Renh aytarenty-penh, ayeng apey-alpem arrpemarl, atha ngenh apenterl-ayntem arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesus angkek ikwer, “Menty, ingwerel-rnem renh aytarey. Ayenhantarl apenterl-aynta, mwerr-ayteng.” ");
INSERT INTO aly_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nganerl-alhek rernem rtnwewarl-anem anperl-alhek. ");
INSERT INTO aly_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kwaty awer-akert apetyek rntwey-alhek rlterrk innga. Awer ilkwel renh-rnem akngelhew-akngenhilek. Kwatyan lherrparnpek-anem rtnwewarl, rtnwan aylperl-alhetyek-anek-anem. Jesus rtnwel ankwaynterl-apenh apal. ");
INSERT INTO aly_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kwertengerl ikwerenh-rnemel Jesus akwentelhilek. Rernemap renh ilek, “Ingkartay, kwatyel anwenhantherr ilwerl-athenekerr!” ");
INSERT INTO aly_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesus-an angkek ikwer-rnem, “Ilek-ketyarl arrantherr aterirreyel, atyeng irrpelthirremel-apeny, atharl arrenhantherrenh arntarnt-areyelan?” Jesus artewentyel arlkek awerek, atnengkirretyek. Kwaty awer-akert atnengkirreyelpek, arwapeny. ");
INSERT INTO aly_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kwertengerl ikwerenhel-rnem Jesus renharl arek-penh, rernem ikwerety aterirrek, rarl kwaty awer-akert arternpilek rlterrkel. Rernemap ayernerrek, “Nthakenh awer-then kwaty-then ikwerant awelheyel.” ");
INSERT INTO aly_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesus rtnwel artarnpenhek Galilee kwaty ilkwangkwarr kwertengerl ikwerenh-rnem-akert, apmer Gadara-warl. Artwa arrenty-akert atherrel Jesus renh arlengek arnarek, apetyenharl. Ratherr kanper-antey anekirrey-ayntek Jesus-warl apmer awenng-angketyarr-they. Arrewaly-kenh awenng-angketyarrel ratherr anenh, nthakenh ikwer-atherr-warl alhey-angenh, ahelengkwek-atherrety. ");
INSERT INTO aly_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Artwa ratherr arlkek, “Jesus, ngan Alerikw Akngey-kenh. Ntwa arraty ilay. Ilekek ngan apetyek? Aylernanthenh ntwa atwetyek? Arlta ingkernelant Akngeyel anwernenhantherr atweyenh!” ");
INSERT INTO aly_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Apwertel atnwenth pikepik akngerr rtnenherrenh. ");
INSERT INTO aly_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Arrenty-rnemel Jesus renh ilek, “Irrentey-angenh anwernenhantherr, apmer arleng-warl! Anwernenhantherr atnwenth yanh-rnem-warl thwena!” ");
INSERT INTO aly_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesus-el kel renh-rnem irrentek, “Alpenherr-arey wenh!” Rernem kel tyerrelhek artwa ikwer-atherr-they, alhemel atnwenth-rnem-warl. Atnwenth rernem kel anterrerrek arrenty-akertan. Rernem arnkarr-they aytnek, kwaty alay kwen-warl. Rernem ilwek kwatyel kwen. ");
INSERT INTO aly_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Artwa atnwenth arntarnt-arey-angker-rnem tawen-warl anterrerrek. Rernem iley-alhek tawen-areny-rnem, atnwenth-rnem kel ilwek kwaty ilkwa kwen, Jesus-elarl arrenty-rnem irrentek artwa ikwer-atherr-they. ");
INSERT INTO aly_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tawen-areny-rnem ingkerrenh rernem-anem alhek, rernem-anem Jesus renh aretyek. Rernem Jesus ikwerety aterirrek, itnweng rlterrk-akert-kety. Rernem angkenh, “Nga apmer ilenh-they alpetyek, apmer ingwer-warl-anem.” ");
INSERT INTO aly_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesus rtnwewarl nganek, kwaty-angkwarr artarnpenhek. Ra angkep-anem alpek apmer ikwerenh-warl, tawen Capernaum-warl. ");
INSERT INTO aly_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Artwa ingwerel-rneman artwa lerrp anyent akngey-alhek pantyel, Jesus-warl. Jesus-el renh-rnem arek, rernemarl renh tnakek mwerriley-angker. Ra artwa lerrprenh ilek, “Apmwan atha ngkwengety iwem.” ");
INSERT INTO aly_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Artwa Pharisee-rnem-then Moses-kenh akalty-anthey-angker-rnem-then rernem angkerrenh, “Ran nhenhey irrtywerremel ilelheyel Akngey-arrpantey. Akngeyelant apmwan iwem!” ");
INSERT INTO aly_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesus-el iterl-arek artwa renh-rnem, rernemarl ikwer irrpelthirremel angkerrenh. Ra renh-rnem ilek, “Arrantherran apmwel-aretharl angkerreyel, atyeng irrpelthirremel! ");
INSERT INTO aly_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Ayengan Akngey-kenh Artwa Impen. Akngeyel ayenh thwenek ahern nhenh-warl, rlterrk innga. Akngeyel ayenh rlterrkilek, artwa arntety mwerriletyek, apmwa ingkerrenh-they iwetyek, arrantherr ayenh iterl-aretyek. Atha akwentelhilemel thwenem, ra apmer-warl alpetyek panty inerl-alhemel.” Jesus angkek artwa arntetyek, “Akwentenhey-alpa, panty ngkwenh inerl-alhemel, apmer-warl-anem alpa!” ");
INSERT INTO aly_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Artwa arntety-penh akwenterl-alhek, panty inerl-alhemel. Alpek-anem ra apmer-warl, mwerr-anem. ");
INSERT INTO aly_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Akngerrel intwarek apatemel, arntety rarl apmer-warl alpek. Rernem Akngeyek-anem inkwerelhek, rarl ahern-areny-rnem rlterrkilek, ingkerrenh mwerril-ayntetyek. Rernemap angkerrenh-anem, “Ngay! Akngey inngarl yanhan!” ");
INSERT INTO aly_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesus ra alpenh, ran artwa arek, itnan Matthew. Ra man akwetyenh, kapment-warl anthayntetyek. Jesus-anem angkek ikwer, “Atyeng-angkwarr apetya!” Ra warrk ikwerenh-kety ipmelhek, Jesus-angkwarrant-anem antelhenhek. ");
INSERT INTO aly_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ikwer-penhan Jesus kwertengerl ikwerenh-rnem-akertel amern arlkwek artwa apmwernem-itwek, man akwetyey-angker-rnem-itwek warl kwenek. ");
INSERT INTO aly_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pharisee ingwer-rnemel Jesus-kenh kwertengerl-rnem ayernek, “Ilekek ra amern arlkweyel man akwetyey-angker-rnem-itwek, apmwa ingwer yanh-rnem-itwek?” ");
INSERT INTO aly_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesus ra awek rernemarl angkerrenh. Ra renh-rnem ilek, “Ngangkerel arntety-rnemant arem, mwerr-rnem nthakenh arey-angenh. Ingwer-rnem rernem mwerr-arrpanteyarl iterl-arelheyel, atyeng-angkwarr-wenyarl. Ayengarl ran apmwa atha iwey-angkeran, arntety mwerriley-angkeran. ");
INSERT INTO aly_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Angka Akngey-kenh-angkwarr akaltyirra! Atha mwerr-rnemant arntarnt-arey-angenh. ‘Angka ingweran aynteyel amern tyenkerr anthetyek. Nga ingwer-rnemek-tangkwel amperrngirra!’ Alakenh-anyem Akngey-kenh pipel aynteyel, anwantherr iterl-aretyek. Ayeng ilkelheyel ingwer-rnemek-then amentewarl alheyel-rnemek-then, Akngey-kenh angkek awelhey-angenh-rnemek, rernem atyeng-warl angkepirretyek.” ");
INSERT INTO aly_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","John-kenh kwertengerl-rnem apetyek Jesus-warl. Rernem renh ilek, “Anwantherr Pharisee-rnem-then Akngeyekant iterreyel, amernek iterrey-angenh. Kwertengerl ngkwenh-rnem-alew? Amern-kety ipmelhek arrpemarl?” ");
INSERT INTO aly_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesus ikwer-rnem angkek, “Artwa anyent itengirrem-angkwarr, ingkerrenhel ikwer-angkwarr amern kwenty arlkwetyek, inkwerelhemel. Alakenh-anyem, kwertengerl atyenh-rnem anyentirremel aylperrem, amern kwenty arlkwetyek, atyeng inkwerelhemel. Ayengarl alpeyenh-ketyant, rernem ipmelheyelpeyenh. ");
INSERT INTO aly_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Arnkwa apmwamwamel-rnem nthakenh anwantherr atanthey-angenh arnkwa mwerr-warl, renh arnwarnetyek. Arnkwa apmwamwam altherrkirrey-angker arrpemarl. Anwantherr menty arnkwa apmwamwam iwey, arnkwa mwerran atnyenemel.” ");
INSERT INTO aly_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jesus-el renh-rnem ilek, “Anwantherr theley-angenh ngkwarl wayn lyerteny arranty apmwamwam-warl. Arranty apmwamwam altherrkirremarl. Arranty-they ngkwarl wayn thelelhekerr ingkerrenh-antey, rwenpirrentyan. Arranty ampwanemarl. Anwantherr ngkwarl wayn lyertenyan arranty mwerr-warl-anem theletyek. Arranty mwerr-itwek wayn mwerr aynteyel, thelelhey-angenh anetyek.” ");
INSERT INTO aly_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesus angkenharl-antey, artwa Atyetyart ilkwa ranem apetyek, ampwethel arrernelhek kwenirremel, “Kwey alerey atyenh kel ilwek. Renh arnep-arna, ra angkep itethirretyek.” ");
INSERT INTO aly_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesus ra rtnerl-alhek, ikwer-angkwarr antelhenhek, kwertengerl ikwerenh-rnem-akert. ");
INSERT INTO aly_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Arelh anyent arntety inngan, aherrety 12-ek-atwety, arleng-alenty anenh. Arelh ra ingkern-they apetyek, arnkwanem Jesus-kenh arnep-arnek. ");
INSERT INTO aly_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ra ament-anem iterrek, “Atha arnkwa ikwerenh arnep-arnenty, ayengap mwerrarl irreman.” ");
INSERT INTO aly_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesus ranem artepang arek arelh renh, ra ikwer angkek, “Nga mwerr-anem irrek, ntwarl ayenh tnakek.” Kel ikwerel-antey ra mwerrirrek. ");
INSERT INTO aly_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Warl atyetyart-kenh-warl ra aylpenhek, ra arek ingwer-rnemarl artnalhelirrenh. ");
INSERT INTO aly_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ra angkek, “Arnangerrenherr-arey! Kwey ngkwenh ilwey-angenh, ankwarl ra aynteyel.” Ingkerrenh Jesus ikwer atherrenh irrpelthirremel. ");
INSERT INTO aly_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ingkerrenh aketh-warl irrentek-penh, Jesus ra aylpenhek, arrewaly rarl ayntenh-warl. Ranem akwethey rnkernek, rtnerl-alhetyek. Kwey ra akwentenhey-alpek-anem. ");
INSERT INTO aly_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ingkerrenhel ahern Judea-ampeny-they rernem angka awek-anem, Jesus-elarl renh itethilek. ");
INSERT INTO aly_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesus apmer ikwer-they anperl-alhek, artwa aparrng atherrel Jesus renh apentenh ingkern-they. Ratherr arlkek, “Aylekanth amperrngirra! David-kenh alerikw!” ");
INSERT INTO aly_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesus ranem warl kwen-warl aylpenhek. Artwa aparrng ratherr ikwer-warl apetyek, Jesus-el renh-atherr ayernek, “Mpwelanth ayenh tnakeyel, atha mpwelanth mwerriley-angker?” “Kel Ingkartay, aylernanth ngenh tnakeyel,” ratherr alakenh angkek. ");
INSERT INTO aly_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jesus-el annga renh-atherr arnek, angkemel, “Kel mpwelanth mwerrirrem-anem, ayenh tnakekarl-penh.” ");
INSERT INTO aly_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kel ratherr mwerrirrek-anem. Jesus ikwer-atherr arrkngert angkek, “Ingwer-rnemek ilelhey-angenh, atharl mpwelanth mwerrilek.” ");
INSERT INTO aly_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Apmer arrpanenh-warl ratherr ilelherl-apenh, renh-atherrarl mwerrilek Jesus-el. ");
INSERT INTO aly_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jesus anperl-alhek kwertengerl ikwerenh-rnem-akert, ingwer-rnemel artwa arrenty-akert atnwenhek Jesus-warl. Arrentyel artwa arrwekel-antey renh angkey-angenh ilek. ");
INSERT INTO aly_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesus-el arrenty renh irrentek, artwa ikwer-they. Artwa rap angkek-anem, mwerr-anem. Jesus renh arek-penh, ingkerrenh inkwerelhemel iterrek, “Aleyant anwantherr arek, Israel-ampenyek arey-angenh.” ");
INSERT INTO aly_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Artwa Pharisee rernem angkerrenh, “Artwa yanh arrenty atyetyart-kenh rlterrk-akertel arrenty ingwer-rnem irrenteyel.” ");
INSERT INTO aly_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesus ra apmer arrpanenh-warl akalty-antherl-apenh, Akngey-kenh-angkwarr apenterl-ayntetyek, Jew-kenh tyaty-itwek, arntety-rnem mwerrilerl-apenh. ");
INSERT INTO aly_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ra ingkerrenh arek, ra ikwer-rnem amperrngirrek, rernemarl ywarn iterrenh. Ingwerentyel renh-rnem akalty-anthey-angenh. Rernem apatemel anenh, atyetyartek arrangkw, yep-yep atyetyart-weny apatemel arlperrtyirrem-apeny. ");
INSERT INTO aly_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ra kwertengerl ikwerenh-rnem ilek, “Akngerr ingwer-rneman Akngey-kenh angka awey-angenh-antey. Angkakert apetyey-angenh-antey, renh-rnem akalty-anthetyek. ");
INSERT INTO aly_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ingkart Akngey ayernetyek, angkakert thwenetyek, angka mwerr-angker ilerl-apayntetyek, akwerrp-rnem-warl.” ");
INSERT INTO aly_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesus-el kwertengerl ikwerenh 12 akarrilek, ranem renh-rnem rlterrkilek, rernem-anem rlterrk ikwerenh-akertel arrenty-rnem irrenterl-apayntetyek, arntety ilek-ilek-akert-rnem mwerrilerl-apayntetyek. ");
INSERT INTO aly_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nhanyem itnernem ikwer-rnem, Simon, itnan ingweran Peter, awayikw ikwerenh Andrew, James-then John-then, Zebedee-kenh alerikw-atherr. ");
INSERT INTO aly_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip-then Bartholomew-then, Thomas-then Matthew, man kapment-warl akwetyey-angker, James-then, Alphaeus-kenh alerikw, Thaddeus-then. ");
INSERT INTO aly_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ingweran itnan Simon Patriot. Judas Iscariot rarl Jesus renh ahelengkw-rnem-warl ahayiwenh. ");
INSERT INTO aly_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesus-el angkakert 12 thwenek, Ranem renh-rnem ilek, “Jew-weny-rnem-warl alhey-angenh, Samaria-areny-rnem-warl alhey-angenh, ");
INSERT INTO aly_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israel-kenh-rnem-warlant alhenherr-arey, rerneman atyetyartek arrangkwarl, rernem apatemelarl aneyel-rnem-warl, yep-yep apatemel rtneyel-apeny. ");
INSERT INTO aly_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ilenherr-arey, arlta kel-anemarl arrerirreyel-kety, irrwerl-areny atyetyart ingkerrenhek anetyek. ");
INSERT INTO aly_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Arntety-rnem mwerriletyek, arrewaly-rnem itethiletyek, tywen-rnem ywerrelhiletyek arntety-rnem-they, arrenty-rnem irrentetyek. Akngeyel ilek-ilek arrekantherr kel anthek. Arrantherr ngkweltyekant iterrey-angenh, arrantherr ingkerrenh ingwer-rnem mwerriletyek arwa. ");
INSERT INTO aly_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ngkwelty ilek-ilek akngeyney-angenh, thilp apek. ");
INSERT INTO aly_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yakweth akngey-angenh, arnkwernem akngey-angenh, ingkety aylpey-angker mentyarl, irrertety akngey-angenh. Ingwerentyel arrenhantherr anthem mwerr-angkwarr, warrk-penh. ");
INSERT INTO aly_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Apmer ingwer-warl alhenty, warl anyentel-antey aney-alhetyek. ");
INSERT INTO aly_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Warl ikwer-warl aylpentyel, Akngey ayerna, renh-rnem ingkerrenh arntarnt-aretyek. ");
INSERT INTO aly_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Rernem ngkweng inkwerelhenty, nga ikwer-rnem-itwek mwerr aneman. Rernem ngkwengety arlkarirrenty, ikwer-rnem-kety amentirrem arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tawen-areny-rnem ngkwengety arlkarirrenty, irrpelthirremel, ahern tertangkwelhila ingkety-theyan. Tawen-arenyel-rneman arem, rernem iterremarl, ‘Anwantherr arntetyirreyenh, Akngeyel anwenhantherr arntety ilkwa antheyenh, anwantherrarl ikwer inkwerelhey-angenh-they.’ Menty-anem yanh-rnem iwerl-alhem alpemelant-anem. ");
INSERT INTO aly_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Arlta ingkernel Akngeyel arlkarirreyelarl-rnem ingkerrenh renh-rnem atwem, Sodom-areny-rnem-then Gomorrah-areny-rnem arrwekel atwek-apeny.” ");
INSERT INTO aly_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Kel-anem alhenherr-arey, mwanty-antey. Arrantherran anik ahelengkw-weny, yep-yep-rnemarl anik aneyel-apeny. Ingwer-rnem ahelengkw arengk artnwer-apenyarl. Arrantherr mwanty-antey arnwarnelhemel mwerrant-arey aney-alhenherr-arey, ikwer-rnem-itwel ahelengkw-weny, thip rwelyarr anikarl aneyel-apeny. ");
INSERT INTO aly_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mwantyel arntarnt-arelhenherr-arey artwa apmwa ahelengkw-rnem-kety arrenhantherrenh atwekerr tyaty Jew-kenh akely-rnem-itwek. ");
INSERT INTO aly_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Artwa apmwernemel arrenhantherr arrerneyenh angka ilkwewarl, atyetyart-rnem-warl angketyek. Arrantherr angka atyenh iletyek Jew-weny-rnemek nyerrirrey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Atyetyart ilkwel arrenhantherr angka ilkwewarl arrernenty, arrantherr ilelhetyek ikwer-warl, aterirrey-angenh. Akngeyel arrenhantherr akwerrng rlterrkilem, arrantherr arraty angketyek. ");
INSERT INTO aly_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Angka ngkwenh-weny. Akngey-kenh Itnwengel arrenhantherr akwerrng rlterrkilem, arrantherr arraty angketyek. ");
INSERT INTO aly_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Artwel-rnem ayteyikw ikwer-rnem-kenh ahayiweyenh ahelengkw-rnemel atwetyek. Ingwer-rnemelan alerikw ikwer-rnem-kenh ahayiweyenh, ahelengkw-rnemel atwetyek. Ampel-rnem amey ikwer-rnem-kenh-then akngey ikwer-rnem-kenh-then ahayiweyenh, ahelengkw-rnemel atwetyek. ");
INSERT INTO aly_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Akngerr arrekantherrety arlkarirreyenh ayenharl apenteyel-kety. Arrantherr atyeng-angkwarr apententy, atyengety amentirrey-angenh, arrantherr intem-antey iteth aneyenh. ");
INSERT INTO aly_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tawen-areny-rnem arrenhantherr atwetyek arrkernelhenty, tawen ingwer-warl alhenherr-arey. Akngey-kenh Artwa Anyent Impen ayeng apey-alheyenh arrer-anem. ");
INSERT INTO aly_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","Kwertengerl 12 lyertant akaltyirreyel, atyetyart-wenyarl, warrkenh atyenh-rnemarl. Ingwer-ingeran ra alyepel akalty-anemarl, ingwer-ingeran artewentyel akalty-anemarl. Rernem warrkirreyel, atyetyart alerl irreyenh. Ingwer-rnem atyeng irrpelthirrenh, rernem kwertengerl-rnemek irrpelthirreyenh arrpemarl, rernem atyeng warrkirrenharl-kety. Ingwer-rnemel apek ayenh Satan antwem, rernem arrenhantherr Satan antweyenh arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ingwer-rnem-kety aterirrey-angenh. Ingkartel arem. Nthakenh anyelkel arlengkewelhey-angenh. Ingwer-ingerant arerl-arrernem-anem. ");
INSERT INTO aly_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Atha arrenhantherr angka atyenh anyelkel-antey ileyel. Atha arreytemel arrenhantherr ileyel, ingwer-ingerant arrantherr alhewer arnkatyel iletyek. Ingwer-ingerant arrantherr angka atyenh aketh-antey alhewer iletyek, ingkerrenhel awetyek. ");
INSERT INTO aly_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ingwer-rnem-kety aterirrey-angenh. Rernem arlkant ngenh atwem, itnweng atwetyek arrangkwarl. Ahern-areny-kety aterirrey-angenh. Arrantherr Akngeyekant iterrerl-ayntetyek, rantarl arlkethen itnweng-then ywerrelhiley-angker. ");
INSERT INTO aly_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Thip nyengk akely atherr tharlemiletyek man akelyek. Nyengk ahern-warl aytnenty, Akngeyel renh areyelarl. ");
INSERT INTO aly_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Alta ingkerr akapwert-itwek nthakenh count-emiley-angenh, Akngey akalty arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Rarl thip nyengk-rnem arntarnt-areyel-apeny, rap arrenhantherr mwantyel arntarnt-arem arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Arrantherr ilelhenty ingwer-rnemek arrantherr atyenh-rnem aneyel, arlta ingkernel athap Akngey irrwerl-areny ilem, arrantherr kwertengerl atyenh-rnem aneyel. ");
INSERT INTO aly_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Arrantherr atyengety arlkarirrenty, arlta ingkernel athap Akngey irrwerl-areny ilem, arrantherr atyenh-wenyarl.” ");
INSERT INTO aly_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Arrantherr atyeng iterreyel, ayeng apetyek ahern nhenh-warl, ingkerrenh arternpiletyek-arrpantey. Arrangkwarl! Akngerr ilterrerl-aneyenh arnerant-arey atyeng-they. ");
INSERT INTO aly_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Rernem ilterrerl-aneyenh, aynenheng-rnem ilterrerl-aneyenh atyeng-they, amenheng-rnem atyeng-they ilterrerl-aneyenh arrpemarl, anherrenheng-rnem atyeng-they ilterrerl-aneyenh arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ngkwenh-rnem ilterrerl-aneyenh atyeng-they arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Arrantherr atyeng inkwerelh-ayntetyek innga, ngkwenh-rnemant inkwerelhey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Arrantherr arlka menty anthelhem, ayenhant arrantherr apenterl-ayntetyek. ");
INSERT INTO aly_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Arrantherr amentewarl-anem alhenty, arrantherrap ywerrem-anem, intem iteth aney-angenh. Arrantherr arlka menty anthelhenty, arrantherrap Akngey-angkwarr iteth intem aneman.” ");
INSERT INTO aly_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ingwerenty ngkweng inkwerelhenty, rap atyeng inkwerelhem arrpemarl. Ingwerenty atyeng inkwerelhenty, rap Akngeyek inkwerelhem arrpemarl rarl ayenh thwenek angkakert. ");
INSERT INTO aly_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ingwerenty apek artwa angkakert ikwer inkwerelhenty, Akngeyel renh arntarnt-arem arrpemarl. Ingwerenty artwa arratyek inkwerelhenty, Akngeyel renh arntarnt-arem arrpemarl, artwa arraty arntarnt-arem-apeny. ");
INSERT INTO aly_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ingwerentyel ngenh apek kwaty irrernt anthenty, nga atyenh kwertengerlarl aneyel, Akngey ikwer inkwerelhem. Akngeyel renh mwantyel arntarnt-arem arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesus-el kwertengerl ikwerenh 12 ilanthek-penh, ranem alpek tawen-areny-rnem akalty-anthayntetyek, angka ikwer-rnem anayntiletyek. ");
INSERT INTO aly_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","John Baptise-emeley-angker tyayl-itwek anenh. Ranem awek-penh, John-el kwertengerl ikwerenh-rnem thwenek Jesus-warl. ");
INSERT INTO aly_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Rernem Jesus renh ayernek, “Ngang John-el arrwekel ilenhan? Ingwerentyek apek anwantherr mpwelhem?” ");
INSERT INTO aly_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesus-el renh-rnem tyernek, “Alhenherr-arey, John iletyek, arrantherr anngetherr ayenh awek-penh, arek-penh. ");
INSERT INTO aly_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Aparrng-penhel-rneman areyel-anem, lerrp-penh-rnem mwerr alheyel-anem, tywen-angketyarr-penh-rnem mwerrirrek, iylpel awey-angenh-rnem aweyel-anem, arrewaly-penh-rnem itethirrek-anem, akwerrp-rnemel angka mwerr-angker aweyel. ");
INSERT INTO aly_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Akngeyel renh-rnem arntarnt-areyel, rernemarl ayenh tnakeyel.” ");
INSERT INTO aly_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","John-kenh kwertengerl-rnem alpek. Jesus-el-anem ingkerrenh angka John-akert ilek, “Ilek-apeny artwa arrantherr arekan apmer arlpaw-itwek? Atherrk arlpenty-apeny, artwa awerr-wenyarl. ");
INSERT INTO aly_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ilek-apeny artwa arrantherr arekan, arnkwa mwerr-angker-akert? Atyetyart ilkwekenh apmerelarl aneyel? ");
INSERT INTO aly_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ilek arrantherr arekan? Akngey-kenh angkakertan? Ran angkakert anyent impen inngarl! ");
INSERT INTO aly_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ranap irrkaty-antey, Akngey-kenh pipel aynteyelarl. Angkakert anyent impen rey-antey: ‘Atha angkakert thwenetyek arrwekel, iwerr mpwaretyek, rarl apetyemek.’ ");
INSERT INTO aly_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","John ranem ahern-areny ingkerrenh-angkwarr impen-antey Akngey-kenh. Akngey-kenh-angkwarr apenteyel-rnem, rernem John-angkwarr ilkwa innga anem. ");
INSERT INTO aly_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Artwa ahelengkw akngerr-anem ilkelhenh, Akngey-itwek aney-alpetyek. Rernem angkakert-rnem ipmek atwek. ");
INSERT INTO aly_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Angkakert Akngey-kenh-rnemel ingwer-rnem akalty-anthenh. Akngeyel Moses law anthek arrpemarl. Rernem akalty-anthenh, John Baptise-emeley-angker ra aremirreyek-atwety. ");
INSERT INTO aly_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","John ra aneyel, angkakert arrwekeleny Elijah anenh-apeny. Awank-akerr Akngeyel ilek, renh thwenetyek ahern nhenh-warl. Renhey-antey anwantherr iterl-areyel. ");
INSERT INTO aly_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Arrantherr atyeng awelhenherr-arey!” ");
INSERT INTO aly_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","Jesus-el renh-rnem ilek, “Ampernem arlkalhelirreyel ampa ingwer-rnemek, ‘Ilek-ketyarl arrantherr arlkarirreyel arrkent alhewer ntwelhelirrey-angenh anwekantherr-itwek? Arlkarirreyelarl. Rernem amperrngirremel anwekantherr-itwek artney-angenharl.’ Ampernem arlkarirreyel artwa nhareny-rnemarl atyengety arlkarirreyel-apeny. ");
INSERT INTO aly_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","John ran artwa ipmeng, amern arlkwey-angenh, ngkwarl wayn antywey-angenh, arrangkw. Arrantherr ikwer angkerrenh arrenty-akertek-arrpantey! Arrantherr ikwerety arlkarirrenh. ");
INSERT INTO aly_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Akngey-kenh Artwa Impen ayeng kel apetyek. Arrantherr ayenh ayntarrp-ileyel ankety-arrpantey, amern akngerr arlkwerl-anenty-arrpantey, ngkwarl wayn akngerr antywerl-anenty-arrpantey. Ayeng artwa apmwernem-itwel, arwa alhewer anem, ikwer-rnem-kety arlkarirrey-angenh. Ayeng alhewer anem man-awarr-rnem-itwek arrpemarl, ankety-rnem-itwek, man kapmentek akarrileyel-rnem-itwek. Akngey-kenh-angkwarr arratyarl aynteyel, alakenh-anyem atha apenteyel.” ");
INSERT INTO aly_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tawen arrpanenhel Jesus-el ilek-ilek mpwarek. Tawen-areny-rnem apmwekety angkepirrey-angenh-antey, apmwantey. Alakenh Jesus-el renh-rnem ilenh, ");
INSERT INTO aly_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Tawen Korazin-areny-rnem angkepirrey-angenhan. Akngeyel arrenhantherr artewentyel innga irrwampenh-antheyenh. Alakenh irrkaty arrpemarl aynteyenh ingwer-rnemekan tawen Bethsaida-arenyekan. Rernem ayenh anngetherr arek, atharl akngerr mwerrilenh, rernemap atyengety arlkarerrekarl. Tawen Tyre-areny-rnem-then tawen Sidon-areny-rnem-then. Rernem-alew? Rernemap nyerrirrem, apmwa ikwer-rnem-kety angkepirrem. Rernemap arnkwa apmwamwamel aylpem inmenthel-then apernelhemel. Arrantherr akwerrp, atyeng awelhey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Arlta ingkernel, Akngeyel tawen Tyre-areny-rnem-then tawen Sidon-areny-rnem-then irrwampenh-antheyenh alyepelant. Rap tawen Korazin-areny-rnem-then tawen Bethsaida-areny-rnem-then irrwampenh-antheyenh artewentyel innga. ");
INSERT INTO aly_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","24","Tawen Capernaum-areny-rnem-alew? Rerneman apmwel-areth iterreyel alakenh, ‘Akngeyel anwernantherrenh irrwerl-warl akngeyneyenh, ikwer-itwel aney-alpetyek. Jesus-el ilek-ilek mwerr-angker mpwarenh arrekantherr-itwek.’ Alakenhap rernem iterreyelan. Rernem atyeng awelhey-angenh-anteyarl. Akngey rap renh-rnem atweyenh. Sodom-areny-rnem-alew? Akngeyel renh-rnem atwek, rernem renh arraty apentey-angenh-they. Alakenh-anyem ra arrenhantherr atwemarl.” ");
INSERT INTO aly_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ikwer-penh Jesus angkek, “Akngeyay, ngan atyetyart ingkerrenhek, ahern-areny-rnemek, alker-areny-rnemek. Ayeng ngkweng inkwerelheyel, ntwarl angka ngkwenh anayntilek, akwerrp-rnemek, ingkerrenhel ngenh iterl-aretyek-awaty, arraty apenterl-ayntetyek. Akalty-arrpantey ingwer-rnem tnakelheyel, angka ngkwenh nthakenh iterl-arey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Alakenh Akngeyay, ntwa anwekantherr arrernek arrwekel.” ");
INSERT INTO aly_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jesus kwertengerl ikwerenh-rnemek angkek arrpemarl, “Akngey atyenhel alakenh ayenh arrernek. Akngeyelant ayenh iterl-areyel innga. Atha anyentelant Akngey renh iterl-areyel innga. Atyeng-angkwarrant rernem Akngey renh iterl-aretyek. ");
INSERT INTO aly_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Atha arrenhantherr mwantyel arratyilem, arrantherr ingwer-angkwarr iterreyel-kety. ");
INSERT INTO aly_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Atyeng-angkwarr akaltyirra, atha arrenhantherr alpemiletyek. ");
INSERT INTO aly_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Arrantherr ayenh apententy, mwerrarl arrekantherr aynteyel, awerr-wenyarl.” ");
INSERT INTO aly_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Arlta anyent impen Saturday-el, Jesus alhek kwertengerl ikwerenh-rnem-akert amern weyt-angketyarr-angkwarr. Kwertengerl ikwerenh-rnemel amern weyt inenhek, angayakwirrekerr. ");
INSERT INTO aly_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pharisee-el-rnem Jesus renh iltek, “Angka anwekantherrenh aynteyel, arlta nhelan nthakenh warrkirrey-angenh. Kwertengerl ngkwenhel-rnem amern weytarl inenhey-alhek Saturday-el, arlta anyent impenel. Apmwel-aretharl amern weytan inenhey-alhek, law anwekantherrenh rernem apmwilenhey-alhek.” ");
INSERT INTO aly_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesus angkek artwa Pharisee-rnemek, “Mwerr amern anwantherr inenhey-alhek angayakwirrekerr. Arrantherrap iterl-aremer ingwer-rnemarl awank amern inek-apeny arrpemarl, David-kenhel-rnem. ");
INSERT INTO aly_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Rernem Akngey-kenh warl impen-warl aylpek. Rernem amern tyenkerr impen akngek angayakwirrekerr. David-el renh-rnem ilek, ‘Amern inenhetyek angayakwirrekerr, arwa alhewer. Angka arrwekeleny aynteyel, tyaty-areny atyetyart-rnemelant amern impen arlkwetyek.’ ");
INSERT INTO aly_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Atyetyart ilkwernem priest-rnem-then rernem alhewer warrkirreyel-antey, ipmelhey-angenh arlta Saturday-el. Alakenh mwerrarl. Ingwer-rnemel renh-rnem ayntarrp-iley-angenh. ");
INSERT INTO aly_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Angka atyenhan impen inngarl, tyaty ilkwa arrangkwarl. ");
INSERT INTO aly_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nthakenh arrantherr kwertengerl atyenh-rnem ayntarrp-iley-angenh arrpemarl. Akngey-kenh angka alakenh aynteyel, irrepern-rnem amernel wantetyek, ipmelhey-angenh. Amern tyenkerr Akngeyek arrerney-angenh. ");
INSERT INTO aly_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ayengan Akngey-kenh Artwa Impen anyent, arlta ltyerrey-angker ikwer atyetyart. Atha anyentelant ilem, arlta ikwer, kwertengerl atyenh-rnem rernem arlkwetyek.” ");
INSERT INTO aly_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Saturday-el, Jesus alhek warl kwen-warl Jew-kenh tyaty akely-warl. ");
INSERT INTO aly_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Artwa anyent akwa arlwerrelhekarl akngelhey-angenh anenh warl kwenel. Pharisee-el-rnem Jesus renh arek, arrer-they, ra arntety renh mwerrilentyek. Artwa rernem angkerrenh, “Arlta Saturday-el rlengkan Jesus-el nthakenh arntety mwerriley-angenharl. Moses-kenh angka nhenh arrwekel aynteyel.” Jesus renh arek Pharisee-el-rnem, ra akengenty irrenty arlta anyent impen nhel. “Moses-kenh angka aynteyel, arlta Saturday-el nthakenh arntety mwerriley-angenh.” ");
INSERT INTO aly_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesus-el artwa ilkwernem ilek, “Angka nhenhek iterrenh-arey arrantherr. Yep-yep apek aytnem irrkewarl, mwernelhemel. Ntwa renh angkep tyerrenhey-alpem itethilemel? Yep-yep itethilem-apeny arlta Saturday-elan, ");
INSERT INTO aly_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kel alakenh atha artwa arntety alhewer itethilem arrpemarl, arlta Saturday-elan.” ");
INSERT INTO aly_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Artwa arntety renh ilek Jesus-el, “Akwa arratyirra!” Artwa ra akwa arratyirrek, mwerr-anem, akwa ingwer-apeny. ");
INSERT INTO aly_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pharisee-rnem rernem tyerrelhek tyaty-they. Rernem tyel-angkerrenh Jesus ikwer, rarl arntety renh mwerrilek, arlta anyent impen apmwilek Jesus-el. Rernem angkerrenh Jesus renh atwetyek. ");
INSERT INTO aly_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesus-el awek, rernemarl ikwer mpwelhenh, ranem alpek apmer ingwer-warl. Akngerrel renh apentek. Ikwer-penhan, ra akngerr arntety-rnem mwerrilek. ");
INSERT INTO aly_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jesus-el renh-rnem artwerilek, “Arrantherr ingwer-rnem-warl iley-angenh. Arrantherr akater aney-alpenherr-arey. ");
INSERT INTO aly_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Angka Akngey-kenh arraty innganem irrek. Angkakert Isaiah arrwekel ingkwernek, Akngey alakenh angkek, ");
INSERT INTO aly_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‘Aray, nhanyem artwa warrkenh atyenh, atharl renh rlwanek. Ayeng ikwer inkwerelheyel. Atha Itnweng atyenh arrernek ikwer-warl, ra angka arraty ilerl-apayntetyek Jew-weny-rnemek, rernem arraty-angkwarr apenterl-ayntetyek ingkerrenhel. ");
INSERT INTO aly_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ra ingwer-rnem-then iltey-angenh, ra artewentyel arlkey-angenh iwerr ampepel. ");
INSERT INTO aly_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ra ingwer-rnem pwerep-anthey-angenh, rernem mwerr-angkwarr aneyel. Ra ikwer-rnem-itwel aneyenh. ");
INSERT INTO aly_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Apmer arleng-areny, Jew-weny-rnem rernem renh iterl-arayntetyek-awaty, rarl renh-rnem itethileyenh.’ Alakenh angkek Akngey.” ");
INSERT INTO aly_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ingwer-rnemelan artwa aparrng anyent Jesus-warl atnwenhek. Artwa akerter arrenty-akert. Jesus-el renh mwerrilek. Artwa ranem mwerr angkek, mwerr-anem arek. ");
INSERT INTO aly_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Rernem apatek, angkerrenh, “Nhanyem David-kenh innga!” ");
INSERT INTO aly_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pharisee-el-rnem awek-penh, rernem ikwer angkerrenh, “Artwa nhan arrenty-kenh rlterrk-akertel. Arrenty-kenh atyetyartel Jesus renh rlterrkilek, arrenty-rnem irrentetyek ingwer-rnem-they!” ");
INSERT INTO aly_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesus-el renh-rnem iterl-arek, rernemarl angkerrenh. Rap angkek, “Arrenty-kenh rlterrk-akertel nthakenh atha irrentey-angenh ikwer-rnem-they. Ra ayenh rlterrkiley-angenh, ikwerenh-rnem irrenteyek. Akngey-kenh Itnweng-akertarl ayengan. Itnweng rlterrk-akertel atha arrenty-rnem ingkerrenh irrentetyek. ");
INSERT INTO aly_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Atyetyart arrenty-kenhel nthakenh ikwerenh-rnem irrentey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Arrantherr iterreyel, rarl ayenh rlterrkilerl-anenty-arrpantey, arrenty irrentetyek. Arrekantherrenh-rnem-alew, arrenty irrentey-angker ingwer-rnem-alew? Arrenty atyetyartel renh-rnem rlterrkiley-angenh, arrangkw! Arrantherr alakenh ayntarrp-ilenty, irrentey-angker ingwer-rnem arrekantherr ahelirrem. ");
INSERT INTO aly_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Akngey-kenh Itnweng-akertelant atha arrenty-rneman irrentetyek. Akngey-kenh-angkwarr alakenh aynteyel, arrantherr iterl-aretyek. ");
INSERT INTO aly_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Artwa rlterrkan aneyel warl ikwerenhel. Ingwerenty nthakenh aylpey-angenharl, arnkwa ikwerenh irrtyert-inetyek. Artwa rlterrk anyent ingwerarl apetyem warl ikwerenh-warl, renh anterrkwemel, arertnemel, arnkwa ikwerenh ingkerrenh akngeynemel. Atyetyart arrenty-kenhan artwa rlterrk-apeny. Ayeng anyent ran rlterrkan, arrenty-kenh atyetyart antengiletyek, arrenty ingwer-rnem irrentetyek. ");
INSERT INTO aly_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ingwerenty atyeng awelhey-angenh, rap atyengety amentirrekarl, rap apmwangkwarrarl anem ilpertel mpwareyel, ingwer-rnem Akngey-kety amentirrem arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ra Akngey-warl angkepirrenty, Akngeyel kel apmwa ikwerety iwem. Ra Itnwengek irrpelthirrenty, Akngeyel apmwa ikwerety iwey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ra Akngey-kenh Artwa Impenek irrpelthirrenty, Akngeyel kel apmwan ikwerety iwem rarl ikwer-warl angkepirrem. Ra Itnweng Rlwartek irrpelthirrenty, Akngeyel apmwa ikwerety iwey-angenh, ahern nhel, apmwan ikwerety iwey-angenh intem-antey.” ");
INSERT INTO aly_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jesus-el angka ingwer-anem ikwer-rnem ilenh. “Arwerl mwerran amern mwerr-akertarl, arwerl arleny arrangkw amern-wenyarl. Arrantherr ayenh iterl-arey-angenh arwerl arleny-apeny. ");
INSERT INTO aly_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Arrantherr anyelk-awarr, rtnwem anyelkel alheyel-apeny. Mwerr-arrpantey arrantherr angkeyel. ");
INSERT INTO aly_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Artwa mwerr, ra mwerr iterreyel. Ra mwerr angkeyel ingwer-rnemek. Artwa apmwa ra apmwangkwarr iterreyel. Ra apmwel-areth angkem ingwer-rnemek. Mwerran ra mwerr-antey ilelhem. Apmwan ra apmwantey ilelhem. ");
INSERT INTO aly_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Atha arrenhantherr arraty ilem. Arlta ingkernel Akngeyel ingkerrenh ayerneyenh, nthakenharl rernem angkenhan, arraty-angkwarr apek, apmwangkwarr apek. ");
INSERT INTO aly_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mwerrarl angkenh-rnem, arrantherr Akngey-angkwarr arraty aneyenh. Apmwel-areth angkenh-rnem Akngeyel renh-rnem irrenteyenh.” ");
INSERT INTO aly_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pharisee-el-rnem renh ayernek “Ilek-ilek-angkwarr mpwara, Akngey-kenh rlterrk-akertel, anwantherr ngenh iterl-aretyek, Akngey-kenh innga.” Moses-kenhel-rnem ayernek arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","40","Jesus-el renh-rnem ilek, “Arrantherr angka ilek-ilek ayerneyel-kety menty-anem, yanh ipmenherr-arey. Arrantherran apmwarl! Arrantherran intemarl arlkareweyel, ‘Mwerr-angker mwanty mpwara Akngey-wenh rlterrk-akertel!’ Nthakenh atha alakenh-anyem mpwarey-angenh arrekantherr. Athan angka Jonah-akertant ilem. Ranap angkakert Akngey-kenh arrwekeleny. Arrantherr angka weth iterl-areyel. Aylperr ilkwel renh kwertnew, ingwa atherrel ra ayntenh aylperr-itwel kwen. Akngeyel aylperr iylarnek, Jonah renh iteth-antey rlkwethel iwenhey-alpetyek aketh-warl kwaty impalth-warl. Ikwer-penhan rap tawen ilkwewarl Nineveh-warl alhek-anem, ra apmer ikwer-areny-rnem iletyek, apmwekety angkepirretyek Akngey-warl-athek. Ayengan Artwa Impen Akngey-kenh, ayengap arrekantherr katy ilweyenh, awenng kwenel aynteyenh ingwa atherrel, Jonah-arl aylperr-itwel atnertel kwenel ayntek-apeny, ingwa atherrel. ");
INSERT INTO aly_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nineveh-areny-rnem Jonah-ek awelhek, rarl angka Akngey-kenh ilenhek. Rernemap nyerrirrek-anem, apmwekety angkepirrek. Akngeyel mentyarl renh-rnem arek, atwey-angenharl. Kel ayengan Atyetyart ilkwa inngarl Jonah-angkwarr. Arlta ingkernel, Akngeyel ingkerrenh-antey ayerneyenh, rernem arraty-angkwarr apententyek. Arlta ikwerel-antey, Nineveh-areny-rnemel arrenhantherrenh apmwa antweyenh, arrantherrarl atyeng awelhey-angenh-antey, apmwekety angkepirrey-angenh-antey. ");
INSERT INTO aly_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Arrantherr angka iterl-areyel arelh atyetyart Sheba-areny-akert. Rap arleng alhek innga Solomon ikwer-warl, Akngey-kenh angka akalty-ayteng awetyek. Ayengan akalty inngarl Solomon-angkwarr. Arlta ingkernel, Akngeyel ingkerrenh-antey ayerneyenh-angkwarr, arelh ra arrenhantherr apmwa antweyenh arrpemarl, arrantherr atyeng awelhey-angenh-they.” ");
INSERT INTO aly_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesus angkek ikwer-rnem, “Arrenty-wenh-angkwarrarl alakenh-anyeman. Arrenty ra artwa anyentel-arleng-tangkwel anem, ingwerentyelap renh irrentem-anem ikwer-they. Ra artwa renh iwerl-alhem-anem, rap anpenhem-anem arlpaw-ampeny-warl-anem ywarn-antey nthwerl-ayntetyek, artwa ingwerek-anem, ikwer-itwel ltyerretyek. ");
INSERT INTO aly_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ran ament angkem, ‘Ayengan angkep artwa ikwer-warl alpem, ayengarl awank anenh-warl.’ Rap angkep alpem, artwa renh mwerr-anem arey-alpem, arlkan iylpwanem arrenty-weny-anem. ");
INSERT INTO aly_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Artwa renh arem-penh, arrenty ra alpem, apmwa innga 7 ingwer-rneman ikngwerl-alpetyek, rernemap ingkerrenh artwa ikwer-warl aylpeyarr-alpetyek-anem. Artwa irrepern ra arrenty anyent-akert-tangkwel. Aleyan ra arrenty akngerr-akert-anem apmwa innganem. Angka atyenh apentey-angenh-they, alakenh apmwangkwarr apenteyel.” ");
INSERT INTO aly_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","47","Jesus-el akngerr ingwer-rnem akalty-anthenh. Amikw ikwerenh ayteyikw ikwerenh-rnem-then apetyek, renh aretyek. Rernemap akethel rtney-alhek, akngerrelarl arrngelek-kety. Ingwerentyel renh ilek, “Ntwa nhak-rnem awetyek alha! Amengkw ngkwenh ayteyengkw ngkwenh-rnem-then ngkweng mpwelheyel akethel.” ");
INSERT INTO aly_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ran angkek, “Kakey atyenhan angwenh-rnemarl? Amey atyenh angwenharl? Nhareny ingkerrenharl arrangkwarl, nhelarl aneyel-rneman. Arrantherr Akngeyek awelhenty, arrantherr atyenh arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kwertengerl ilenh-rnemant atyenh inngerneman! ");
INSERT INTO aly_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Angka Akngey-kenharl apenteyel-rnem atyenh ingkerrenh.” ");
INSERT INTO aly_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Arlta anyent ikwerel-antey, Jesus warl-they tyerrelherl-alhek kwaty irrker-ampeny-warl. Ranem arrernelhey-alhek. ");
INSERT INTO aly_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Akngerr innga akarrirrek apmer arrpanenh-they Jesus-warl, rap ilenh angka ikwer-rnem. Akngerrelarl tyetilek-kety ra rtnwewarl-anem nganek, kwatyelarl rtnwa rtnenh-warl. Ra rtnwethey-anem anemel-anem, angkan ikwer-rnem ilenh. Akngerr rtnenherremel awelhenh Jesus ikwer kwaty ilkwa impalthel. ");
INSERT INTO aly_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jesus-el angka akngerr ilenh. “Awelhenh-arey atyeng! Artwa anyentel ra ntang weyt iwerl-apenh, amern lyapetyek. ");
INSERT INTO aly_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Artwa ra ntang weyt ingwerentyan iwerr arlertek-warl iwerl-apenh. Thip-rnemel apetyemel arlkwek ingkerrenh. ");
INSERT INTO aly_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Artwa ra ntang weyt ingwerentyan ahern apwert-angketyarr-warl iwerl-apenh. Rernemap alyepel lyaperrek. Artekerr kwen-aylpey-angenh ahern apwert-angketyarrel. Nthakenh lyapey-angenh ahern apwert-angketyarrelan arrangkw. ");
INSERT INTO aly_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Atherrk-rneman arlenyirrek-anem itwern-penh kwaty-wenyel. ");
INSERT INTO aly_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Artwa ra ntang weyt ingwerentyan ahern arlkerl-angketyarr-warl iwerl-apenh. Arlkerl artekerrel amern weyt lyapey-angenhilek. Arlkerl-angketyarrelan lyapey-angenh amern weyt arrangkw. ");
INSERT INTO aly_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Artwa ra ntang ingwerentyan ahern mwerr-warl iwerl-apenh. Amern weyt ahern mwerrelan mwerrarl lyapek. Ntang weyt anyent-they amern akngerr lyapek, ntang 30 apek. Ntang weyt anyent ingwer-they 60 apek, ntang weyt anyent ingwer-they 100 apek. Aparnp-anem irrenh. Arnkengeny-anem inpanem.” ");
INSERT INTO aly_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jesus-el renh-rnem ilek, “Angka nhanyem mwerr atha arrekantherr ilem, arrantherrap iterl-arenherr-arey!” ");
INSERT INTO aly_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kwertengerl ikwerenh-rnem rernem renh ayernek, “Ilek ntwa angka anyelkelan ileyel anwekantherr. Angka ngkwenh anayntila anwekantherr!” ");
INSERT INTO aly_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesus-el renh-rnem ilek, “Nhanyem atha angka arrekantherrant anayntilek, Akngey-kenh-angkwarr. Nthakenh atha angka ingkerr ingwer-rnemek anayntiley-angenharl. Nthakenh atyengan akngerr awelhey-angenharl. ");
INSERT INTO aly_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Arrantherr Akngey-kenh angkek mwantyel awelhenty, inkwerelhemel, Akngeyel arrenhantherr intem-antey akaltyilem. Arrangkwelan, Akngeyel arrenhantherr akalty-anthey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Atharl rernem angka anyelk-rnem awekarl-penhan, rernem ywarn iterrey-alpeyel. ");
INSERT INTO aly_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Isaiah-el angka alakenh ingkwernek. Angka innganem ayntek, ‘Rernem ayenh awek-penh, rernem mwantyel awelhey-angenh-antey. Rernem ayenh arek-penh, rernem ayenh iterl-arey-angenh-antey, akwerrp.’ Angka innganem irrek. ");
INSERT INTO aly_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","‘Rernem iylpel awelhey-angenh ingkerrenh. Rernem arey-angenh aparrng-apeny. Rernem atyeng mwantyel awelhenty, rernemap ingkerr Akngey-warl angkepirremarl.’ ");
INSERT INTO aly_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Arrantherr annga mwerr-akertel anngetherr areyel, iylpa mwerr-akertel aweyel, ");
INSERT INTO aly_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Angkakert arrwekeleny-rnem artwa arraty-rnem-then rernem ilkelhenh, ayenh aretyek, aley arrantherr ayenh anaynt areyel-apeny. Rernem ilkelhenh ayenh awetyek, aley arrantherr ayenh aketh aweyel-apeny. ");
INSERT INTO aly_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Angka nhanyem awelhenherr-arey, atharl arrenhantherr ilem, angka ntang-akert. ");
INSERT INTO aly_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Amern weytarl arlperrty iwem-apeny, angka nhanyem Akngey-kenh ingkerrenh-angkwarr arlperrtyirrem. Ingwer-rneman ntang weytarl iwerr arlertek-warl iwek-apenyarl. Rernem Akngey-kenh angkek awelhem-tangkwel, rernem Akngey-angkwarr-anem apenteyel. Arrentyel Akngey-kenh angka ilpertileyel. Rernem intwemelirreyel Akngey-kety, rernem intem-anem apmwel-areth aneyenh. ");
INSERT INTO aly_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Ingwer-rnemel Akngey-kenh angka awemarl-penh, rernem mwerrarl apenteyel angath-antey. Rernem ntang weytarl apwert-angketyarrelan iwek-apenyarl. Artekerr-rnem aylpeyel angath-antey apwert-angketyarrelan. Rernem alakenh-anyemarl Akngey-kenh angka apenteyel angath-antey. Rernem ipmelhemant-anem, ahelengkwel-rnem atwekerr, apmwa mpwarekerr. ");
INSERT INTO aly_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ingwerentyan ntang weytarl arlkerl-angketyarr-warl iwek-apenyarl. Rernem Akngey-kenh angka iylpelant aweyel. Rernem apwert manek ampwal ingwerentyek-then iterrerl-anem apmwel-areth. Mwerrek iterrekerr, ikwerant iterreyel. Rernem anterrkweyel-apeny ilpertilemel, arlkerlel ntang weyt anterrkweyel-apeny. ");
INSERT INTO aly_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ingwerentyan ntang weytarl ahern mwerr-warl iwek-apenyarl. Rernem Akngey-kenh angka awemel, rernem inkwerelhem.” ");
INSERT INTO aly_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesus-el angka ingwer-anem ilenh. “Akngeyan Ingkart ingkerrenhek aneyel, alakenh-apeny anem. Artwa atyetyart anyentelan ntang weyt iwerl-apenh, amern ament lyapetyek. ");
INSERT INTO aly_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ingwel ra ankwayntenh warrkenh ikwerenh-rnem-then. Artwa apmwel apetyek, antywer apmwernem iwerl-apenh weyt-angketyarr-warl. ");
INSERT INTO aly_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Atherrk mwerr-rnem lyapek, atherrk apmwernem-then lyapek iyntwerel. ");
INSERT INTO aly_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Warrkenh ikwerenhel-rnem renh ayernek, ‘Nthakenharl atherrk apmwa nhenh-rneman lyapek mwerr-itwelan?’ ");
INSERT INTO aly_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Atyetyartel renh-rnem ilek, ‘Artwa apmwel atherrk apmwernem lyapelhiletyek.’ Warrkenh ikwerenh-rnem angkerrenh, atherrk apmwernem tyerreynetyek. Rernemap renh ayernek, ‘Atherrk apmwernem anwantherr tyerreyneyarl?’ ");
INSERT INTO aly_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ra angkek, ‘Menty, ipmenherr-arey, amern-rnem-then tyerrekerr. ");
INSERT INTO aly_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Amern ntang ampengirrentyelant, atha warrkenh atyenh-rnem thwenem, renh-rnem ingkerrenh tyerretyek, apmwernem akngakemel, mwerr-rnem ingwer-ampeny-warl arrernemel, atherrk apmwa rwewarl iwetyek. Mwerr-angkwarr atherrk mwerr-rnem pweytiletyek, warl ilkwewarl akwerney-alenty.’” ");
INSERT INTO aly_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Jesus-el angka ingwer-anem ikwer-rnem ilenh, “Akngey-kenh-angkwarr alakenh aynteyel arrpemarl. Ntang ankwerrernarl lyapeyel-apeny ahernel. Ntang ankerr-penh lyapem arwerl ilkwa. Thip-rnem ikwer-warl arrernelhemarl. Ankerr anyent-apeny, Akngey-kenh anyent anenh.” ");
INSERT INTO aly_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesus-el renh-rnem angka ingwer-anem ilenh, “Amern arlety akely-penh amern ilkwerrem, arlwar rtnemel, arlwariley-angker-akert. Amern akngerr-anem ampernem. Alakenh-anyemarl yanhey, Akngey-kenh-angkwarr. Akngey-kenh-rnem akngerram-akngerr irreyenh arrpemarl, amern arlwariley-angker-akert-apeny. Alakenh-apeny Ingkart-kenh-rnem akngerram-akngerrirrem arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Angka angath-antey renh-rnem akalty-anthenh, angka arrpanenh ikwer-rnem anayntiley-angenh. Angka anyelk-antey ayntenh, angka iley-angenh anaynt. ");
INSERT INTO aly_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Akngey-kenh angkakert ra arrwekel ingkwernek-angkwarr-antey, kel arraty innga ayntek. Akngey-kenh angka alakenh aynteyel: “Atha angka anyelk ikwer-rnem iley. Arrwekeleny-rnemel angka anyelk-rnem awey-angenh-antey.” ");
INSERT INTO aly_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kwertengerl ikwerenh-rnem Jesus ikwer-warl apetyek, renh ayernetyek, “Angka weth atherrk apmwepenh anayntila, ntang weyt-they iyntwerelarl lyapek.” ");
INSERT INTO aly_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesus-el angka ikwer-rnem anayntilek, “Akngey-kenh Artwa Anyent Impen, ayeng artwa ntang mwerr iwerl-apenh-apeny. ");
INSERT INTO aly_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Apmer amern-angketyarrel atherrk akngerr, ahern nhelarl akngerr aneyel-apeny. Akngeyek awelheyelarl-rnem ntang mwerr-apeny. Arrenty-kenh-rnem, rernem atherrk apmwapeny. ");
INSERT INTO aly_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Atherrk apmwa iwey-angkeran anayntileyel arrentyan. Warrkenh-rnem anayntileyel angel-rnem. ");
INSERT INTO aly_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Atherrk apmwa rwewarl iwem-apeny, alakenh-anyem aynteyel arlta ingkernel. ");
INSERT INTO aly_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Akngey-kenh Artwa Impen atha angel-rnem thweneyenh, apmwernem akngakeyenh ikwerenh-rnem-they. ");
INSERT INTO aly_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Angel-rnemel ingkerrenh inem, apmwangkwarr alheyel-rnem-then akngakeyenh, rwa ilkwewarl iweman, ingkerrenh artewentyel arrangkeyenh-warl. ");
INSERT INTO aly_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Akngey-kenh-rnem arrtyerneyenh ingkenyel-apeny, ikwerenh ingkerrenh. Angka nhanyem mwerr atha arrekantherr ilem, arrantherrap ingkerrenhel iterl-aretyek!” ");
INSERT INTO aly_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Artwa ingwerel ampwal man-angketyarr arerl-alpek, inkwerelhemel. Ranem man renh arlwarrernek. Ra arterl-alhek, ra ingwer-inger apey-alpetyek. Ra anyent ikwerant arrkernelhenh, renhant inetyek. Ra ilek-ilek ikwerenh tharlemilek, apmer man-angketyarr renh payemeley-alenty. Ampwal man-angketyarr impen, mwerr-angker Akngey-kenh-angkwarr alakenh arrpemarl, impen alakenh-anyem aynteyelan.” ");
INSERT INTO aly_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Artwa anyent ingwer apwert pearl mwerr-angker ikwer nthwerl-apenh, impenek-antey. ");
INSERT INTO aly_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ra apwert mwerr-angker store-itwek arerl-alpek. Ra apwert arlwarrenherl-alpek, apmer ikwerenh-warl alpemel. Ra apwertekant arrkernelhenh. Artwa ranem ampwal ilek-ilek ikwerenh tharlemilek, apwert pearl mwerr-angker renh payemeley-alenty man ilkwel. Man ingkerrenh arimpek, apwert renhant payemeletyek. Akngey-kenh impeney-antey arrpemarl, apwert pearl-apeny.” ");
INSERT INTO aly_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jesus-el angka ingwer-anem ikwer-rnem ilenh, “Akngey-kenh-angkwarr alakenh aynteyel; artwernem rernem netting iwek kwaty-warl, irrpeng ingwerek-ingwer anterrkwetyek. ");
INSERT INTO aly_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Rernem-anem netting renh kwaty irrkerr-ampeny-warl ayteng-akngeynek irrpeng-angketyarr. Ikwer-penhan rernem irrpeng renh-rnem akngakeyenh. Irrpeng mwerr-rnem rernem atnyeneyel. Irrpeng apmwernem rernem menty iwem. ");
INSERT INTO aly_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Alakenh-apeny arlta ingkernel aynteyenh. Angel-rnem apetyeyenh, apmwa ingkerrenh akngaketyek, mwerr-rnem-they. ");
INSERT INTO aly_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Renh-rnem-anem ingkerrenh rwa aknganenty ikwer-warl iweyenh, ikwer-itwek-anem rernem artewentyel innga arrangkeyenh.” ");
INSERT INTO aly_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesus-el renh-rnem ayernek, “Arrantherr angka nhenh aweyel?” Rernem angkek, “Kel, anwantherr aweyel!” ");
INSERT INTO aly_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ikwer-penhan ra renh-rnem ilek, “Store-arenyel ampwal ilek-ilek tharlemileyel, awankeny-rnem-then lyerteny-rnem-then. Ingkart Akngey-kenh angka ingkerrenhek arraty akaltyirretyek, angka arrwekeleny-angkwarr akaltyirretyek angka lyerteny-angkwarr akaltyirretyek. Alakenh-anyem Akngey-kenh-angkwarr arraty apenteyel.” ");
INSERT INTO aly_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Jesus tawen Nazareth, apmer ikwerenh-warl alpek. Ra warl kwen-warl aylpek, Jew-kenh tyaty akely-warl. Ra renh-rnem akalty-anthenh. Ingwer-rnem Jesus-ek inkwerelhek. Rernem angkerrenh, “Jesus rantarl ingkerrenh-angkwarr iterl-areyel, ran akalty innga. Ranap ngangker-akert inngarl nhenhey, arntety mwerriley-angkerarl.” Akngerr ingwer-rneman Jesus-ek irrpelthirremel angkerrenharl, ");
INSERT INTO aly_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“Jesus ahern-areny-kenh alerikw! Ilek-ilek arwerl-penh arnwarney-angkeran-kenh! Ilenhan Mary-kenh ampikwarl! Ayteyikw-rneman ikwerenh apmer nhareny-rnemarl. Itnan ayteyikw-rnem ikwerenh, James, Joseph, Simon, Judas. ");
INSERT INTO aly_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Arrempikw-rneman ikwerenh apmer nhareny-rnemarl. Ran anwantherr-apeny arrpemarl, Akngey-kenh inngewenyarl.” ");
INSERT INTO aly_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jesus angkek, “Apmer nhareny-rnemantarl atyeng irrpelthirremelan angkerreyel, ayeng angkakert Akngey-kenh inngewenyarl. Atyenh-rnem atyeng irrpelthirreyel arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Apmer-areny-rnem ikwer irrpelthirrenharl-kety, Jesus-el renh-rnem mwerriley-angenh. ");
INSERT INTO aly_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Herod, atyetyart Galilee-arenyel angka awek, Jesus-elarl arntety-rnem mwerrilenh, apmer arrpanenhek. ");
INSERT INTO aly_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Herod ra ywarn iterrenh John Baptise-emeley-angker ikwer. Ra warrkenh-rnem ilek, “Rang angkep ipmepenh itethirrek, rang apmer arrpanenhek mwerrileyel?” ");
INSERT INTO aly_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herod-kenh awayikw anewikw ikwerenh arelh anyent itnan Herodias. Herod-el anew ikwerenh rakek. John-el renh ilek, “Ntwa nthakenharl awayengkwan anew ikwerenhan rakek? Apmwel-aretharl alakenhey! Awayengkw-anteyarl anew ikwerenh ntwa rakekan, arraty-wenyarl!” Arelh Herodias ra ahelirrek John ikwer. Herod-el artwa ahelengkw thwenek, John renh anterrkwetyek, tyayl-warl akwernetyek. ");
INSERT INTO aly_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod aterirrek ingwer-rnem-kety, ingwer-rnemelarl John renh iterl-arek Akngey-kenh angkakert. Herod atherr-angkwarr iterrenh, mwerr-angkwarr, apmwangkwarr. ");
INSERT INTO aly_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Atyetyart Herod-rnem-then Atyetyart ilkwa ingwer-rnem-then, apmer Galilee-areny-rnem akarrirrek, rernem amern kwenty ingkerrenhel arlkwetyek. Atyetyart ahelengkw-rnem-then rernem akarrirrek ingkerrenh amern ingkerrenhel arlkwetyek arrpemarl. Arelh Herodias-kenh ampikw rntwenh ikwer-rnem ingkerrenhek. Aleyak ikwer rernem inkwerelhek, rarl mwerr-angker Herod-kenh apmerel rntwenhek. ");
INSERT INTO aly_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Herod-el kwey renh ilek, “Ilek-ilek akngerrek nga arlkwententy, atha ngenh anthem.” ");
INSERT INTO aly_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Arelh Herodias ra iterrek, John renh atwetyek. Kwey ra amikw ikwerenh Herodias-warl alhek. Ra amikw renh ayernek, “Ilekekarl atha ayernem Atyetyart ilenhan?” Amelikw renh ilanthek, “Akapwert John Baptise-emeley-angker yanh ina, pmwar-warl arrernemel, ayenh anthemel!” Ikwer-penhan kwey rap Atyetyart Herod-warl alhek. Ra Atyetyart Herod renh ilek, “Akapwert John Baptise-emeley-angker arterna, pmwar-warl arrernemel, ayenh anthemel.” ");
INSERT INTO aly_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herod ra amperrngant-anem irrek John ikwer. Akngerrel renh awekarl-kety, ra nthakenh akengenty angkey-angenh. Nthakenh ra arrkngert angkey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","11","Herod-el ahelengkw thwenek tyayl-warl, John ahenty arternetyek. Ahelengkwel arreylpel akapwert arternek, akapwert renh pmwar-warl arrernemel, kwey renh anthek. Kwey ra amikw-warl akngeynek, John Baptise-emeley-angker akapwert. ");
INSERT INTO aly_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","John-kenh kwertengerl-rnemel angka awek, rarl ilwek. Rernem apetyek, ipma awenng-warl akwernetyek. Rernem renh akwernek. Rernem Jesus renh angka ilek. ");
INSERT INTO aly_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesus ra angka John-akert awek-penh ra nganerl-alhek rtnwewarl, ra Galilee kwaty ilkwangkwarr artarnpenhek, apmer alther-warl, ampeny-warl, ra ament anayntetyek. Ingwer-rnem ingkern-they artenhirrek-anem ikwer-warl, ingkel alhemel tawen-they. ");
INSERT INTO aly_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesus-anem rtnwethey atwarrek, ra akngerr arek. Ra ikwer-rnem amperrngirrek, ingkerrenh arntety-rnem-then mwerrilek. ");
INSERT INTO aly_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Atwerrp, kwertengerl ikwerenh-rnem Jesus-warl apetyek, ikwer angkek, “Amern-wenyarl nhanyeman, arrangkwarl. Yanh-rnem ingkerrenh-antey thwena tawen-rnem-warl, amern-tangkwel inerl-alpetyek. Atwerrpirrekerrem-awaty!” ");
INSERT INTO aly_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesus angkek, “Arlkarel arrantherr wantenherr-arey.” ");
INSERT INTO aly_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Rernem Jesus renh ilek, “Amern ampeng 5-pelant, aker irrpeng atherr-thenant.” ");
INSERT INTO aly_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesus-el renh-rnem ilek, “Atyeng-warl akngetyenherr-arey!” ");
INSERT INTO aly_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jesus-el renh-rnem ilek, rernem arrernelhetyek atherrk-warl. Amern irrpetyap aker irrpeng-atherr Jesus-el inek. Ra Ingkart Akngey-warl angkek inkwerelhemel, rarl amern anthek, aker irrpeng-then anthek. Jesus-el amern rlweth-akek. Ra kwertengerl ikwerenh-rnem anthek, rernem-anem antheynetyek ingwer-rnem. Jesus-el aker irrpeng rlweth-akek. Ra anthek kwertengerl ikwerenh-rnem rernem antheynetyek ingwer-rnem. ");
INSERT INTO aly_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Rernem ingkerrenhel arlkwek-penh, rernem atnerteng-anem anek. Rernem akertang arlkwekarl-penh, rernem rtnwa amernek-arelh 12-pel-warl ampwerrk iweynek. ");
INSERT INTO aly_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Artwa 5,000-el amern arlkwek, arelh-rnem-then, ampernem-then ingkerrenhel. ");
INSERT INTO aly_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jesus-el kwertengerl ikwerenh-rnem ilanthek, rernem rtnwel kwaty anthenayn-ampeny-warl artarnpenhetyek arrwekel-antey, ra ingwer-rnem ilanthek rernem apmer-warl-anem alpetyek. ");
INSERT INTO aly_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Rap apwert irrwerl-warl nganek, Akngeyek ament angketyek. Atwerrpirrek-anem, ra ament-areny anenh. ");
INSERT INTO aly_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Rtnwa ranem kwaty ampep-itwek. Awer ilkwel rtnwa renh akngelhew-akngelhilek. ");
INSERT INTO aly_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ingwepenh ingkeny tyerrelhey-angenhel, ra ingkel irrwerlap-alhek kwaty ampep-angkwarr, ahernel-apeny. ");
INSERT INTO aly_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kwertengerl ikwerenhel-rnem renh arek, rernem aterirremel arlkenh, “Arrewaly yanhan.” Rernem aterirrek, arrewalyek-athen. ");
INSERT INTO aly_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jesus-el renh-rnem ilek, “Artewentyel aterirrey-angenh! Ayengarl nhan!” ");
INSERT INTO aly_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Peter-el renh tyernek, “Ingkartay, ayenh ila, ayeng kwaty-angkwarr alhetyek ngkweng-warl!” ");
INSERT INTO aly_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ranem angkek, “Apetya”. Peter ranem rtnwethey atwarrelhilek, kwaty-angkwarr ingkel alhemel Jesus-warl. ");
INSERT INTO aly_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ranem aterirrek alherrp-kety, kwen-anem aylperl-alhetyek-anek. Ra arlkek, “Ingkartay, ayenh itethila!” ");
INSERT INTO aly_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesus ra anamerl-antey iltya ikwerenh anterrkwek angkemel, “Ilek-kety ntwa ayenh tnakey-angenh!” ");
INSERT INTO aly_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ratherr rtnwewarl nganek, kwaty awer-akert arternp-anem irrek atnengk-anem. ");
INSERT INTO aly_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Rernem renh tnakek, “Nga Akngey-kenh alerikw innga!” ");
INSERT INTO aly_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Rernem artarnpenhek intwarr-ampeny-warl, apmer Gennesaret-ampeny-warl. ");
INSERT INTO aly_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Apmer ikwer-areny-rnemel renh arek-penh, rernem-anem ingwer-rnem ilek. Apmer arrpanenh-they arntety-rnem akngetyek ikwer-warl. ");
INSERT INTO aly_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Rernem iterrenh, “Anwantherr arnkwa ikwerenh arnenty anwantherr mwerrirremarl.” Rernem arnkwa arnep-arnek-penh rernem mwerrirrek-anem, arntety-weny-anem. ");
INSERT INTO aly_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Moses-kenh-rnem-then Pharisee-rnem-then Jesus-warl akarrirrek Jerusalem-they. ");
INSERT INTO aly_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Rernem arek, kwertengerl Jesus-kenhel-rnem itep aternngel amern alhewerarl arlkwek, itep lhewelhey-angenhel. Jew-rnem itep lhewelhenh amern arlkwey-alenty. Rernem Jesus renh ilek, “Kwertengerl ngkwenhel-rnem nthakenharl itep lhewelhey-angenharlan amern arlkwey-alenty. Arrwekeleny-kenh apmer nhel aknganek amern arlkwey-alenty itep lhewelhetyek.” ");
INSERT INTO aly_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesus-el renh-rnem tyernek, “Arrantherr Akngey-kenh angkekety intwemelirrek, ahern-areny-kenhant arrantherr apenteyel. ");
INSERT INTO aly_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Atha ileyel Akngey-kenh angkel: ‘Arrantherr ameyek akngeyek awelhenherr-arey.’ Moses-kenh angka alakenh-anyemarl aynteyel arrwekelenyan: ‘Akngeyek ameyek apmwel-areth angkentyek, renh ipmek atwem.’ ");
INSERT INTO aly_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Arrantherr apmwel-areth akalty-antheyel, Akngey-kenh-angkwarr-weny. Arrantherr man ikwerel amey-rnem-then akngey-rnem-then arntarnt-arey-angenh, man ilenh arrantherr ayerrpileyel. Arrantherr irrtywerremel ileyel man nhenhan Akngey-kenh-arrpantey. ");
INSERT INTO aly_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Arrantherr Akngey-kenh angkekety ipmelhek, angka arrekantherrenh-angkwarrant akalty-antheyel. ");
INSERT INTO aly_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Arrantherr irrtywerremel ilelheyel. Awank-akerr Isaiah-el Akngey-kenh angka pip-warl ingkwernek, arrantherran aneyel-apeny. ");
INSERT INTO aly_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Akngey angkek ikwer-rnem, ‘Arrantherr irrtywerremel atyeng inkwerelheyel, atyeng-angkwarr apentey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Arrantherr apenteyel arrekantherrenh-angkwarrant, ahern-areny-kenh-angkwarrant, Akngey-kenh-angkwarr-weny. Alakenh arrantherr ingwer-rnem apmwangkwarr akalty-antheyel.’” ");
INSERT INTO aly_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesus-el akngerr ingwer-rnem akarrilek. Ra renh-rnem ilek, “Atyeng arrantherr awelhetyek arternp. ");
INSERT INTO aly_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Amern arrantherr arlkwetyek alhewer, nthakenharl arrantherr apmwelhiley-angenh Akngey-angkwarr, amern alhewer arlkwemel. Arrantherr apmwel-areth angkenty, arrantherr Akngey-angkwarr apmwelhilemarl.” ");
INSERT INTO aly_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kwertengerl ikwerenhel-rnem renh ilek, “Pharisee-rnem ngkweng ahelirrenh nga apmwel-areth angkenty-arrpantey.” ");
INSERT INTO aly_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesus-el renh-rnem ilek, “Apmwangkwarrarl akalty-antherl-anentyan, Akngeyel renh iwemarl, arwerl apmwa iwem-apeny. Pharisee-rnem arwerl apmwapeny. ");
INSERT INTO aly_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Artwa aparrngel nthakenh atnwenhey-angenh artwa aparrng ingwer. Ratherr atherr-anteyarl aytnekerr irrkewarl aparrngant-atherr.” ");
INSERT INTO aly_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peter-el renh ayernek, “Angka anyelk anwernekantherr anayntila, angka amern alhewer arlkwentyek.” ");
INSERT INTO aly_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesus angkek, “Ntwa iterl-arey-angenh-antey, ywarn iterreyel! ");
INSERT INTO aly_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Amern alakenh arlkwemer, nthakenh arleng-alenty ayntey-angenh, rap atnert-they ywerrem. ");
INSERT INTO aly_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Apmwel-areth angkenty, arrakert-they angka apmwel-areth ikwerenh tyerrelheman. Alakenh apmwelhileyel Akngey-angkwarran. Amern-then aker-then arrangkwarl, nthakenh Akngey-angkwarr apmwelhiley-angenh. ");
INSERT INTO aly_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","20","Arrantherr apmwel-areth iterrenty, arrantherrap Akngey-kety amentirremarl, apmwelhilemarl. Arrantherr ingwerenty ipmek atwenty, ingwer-kenh arrkar irrtyertel ikngwenty, arrantherr irrtyertel inenty, arrantherr tyel-angkenty ingwer-rnemek, arrantherrap Akngey-kety apmwangkwarrarl aneman. Amern arlkwenty itep aterrng-akertel nthakenh Akngey-angkwarr apmwelhiley-angenh. Kel ntwa amern arlkwetyek alhewer.” ");
INSERT INTO aly_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesus ra anperl-alhek apmer Tyre-warl, Sidon-warl. ");
INSERT INTO aly_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ikwer-penh arelh Jew-weny Caanan-areny-anem anterrey-alhenh Jesus ikwer-warl arlkemel, “Ingkartay, David-kenh, atyeng amperrngirra! Ampa atyenh arrenty-angketyarr!” ");
INSERT INTO aly_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesus-el renh tyerney-angenh, arelh rarl aleth-antey ikwer arlkeynenh. Kwertengerl ikwerenh-rnem Jesus ikwer angkek, “Arelh yanh irrenta”. ");
INSERT INTO aly_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesus ran angkek, “Akngeyel ayenh thwenek, atha Israel-kenh-rnemant arntarnt-arayntetyek, rernem aperrertirrekerr amentirrekerr yep-yep-rnem ingwer-rnemarl aperrertirrem-apeny atyetyart-wenyel.” ");
INSERT INTO aly_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Arelh ranem arrer-apeny irrek. Rap kwenirrek-anem ikwer angkemel, “Ingkartay, atyeng amperrngirra!” ");
INSERT INTO aly_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesus-el renh ilek, “Atha Jew-rnemant arntarnt-areyel, atyenh-rnemant. Anwantherr ampernem-tangkwel wantey. Ampel-rnem-tangkwel arlkwenty-penh arengk-rnemant-anem wantemel. Atha atyenh-rnem Jew-rnem-tangkwel arntarnt-areyel.” ");
INSERT INTO aly_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Arelh angkek ikwer, “Arengkel-rnem arlkwetyek arrpemarl, arengk-kenh amernan rernem iwetyek arrpemarl. Jew-rnem rernem ingkerrenh atyenh-rnem-kety arlkarirreyel. Atyenh-rneman arengk-apenyarl aneyel, Jew-rnem-angkwarr. Atha ngenh iterl-areyel, ntwa ingkerrenh arntarnt-arey-angker. Atyeng-then amperrngirra!” ");
INSERT INTO aly_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesus ran angkek, “Nga atyeng arternp awelhek, kel atha ngenh arntarnt-arem.” Kel anamerl-antey arrenty tyerrelhek kwey ikwerenh-they, kwey ikwerenh mwerr-anem irrek. ");
INSERT INTO aly_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesus apmer ikwer-they alpek, ra kwaty Galilee impalth-angkwarr alhenh. Ra apwert ilkwewarl nganek, apwert-itwek anenh. ");
INSERT INTO aly_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Akngerr ikwer-warl akarrirrek, Rernem arntety-rnem-then akngeynek ikwer-warl, lerrp-rnem-then aparrng-rnem-then akerter-rnem-then arntety ingwer-rnem-then. Jesus-el renh-rnem mwerrilek. ");
INSERT INTO aly_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ingkerrenh apateyelpek. Akerter-rnem mwerr-anem angkenh, lerrp-penh rernem mwerr-anem alhenh. Aparrng-penh-rnem arenh-anem. Rernem inkwerelhek Akngey Israel-kenhek, Jesus-elarl ingkerrenh mwerrilek, Akngey-kenh rlterrk-akertel. ");
INSERT INTO aly_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Akngerr akarrirrek Jesus-warl. Amern ingkerrenh ywerrelhilek. Jesus irrepern angayakw-rnemek amperrngirrek. Jesus ilelhek kwertengerl ikwerenh-rnemek, “Ayeng irrepern angayakw-rnemek amperrngirreyel. Arlta irrpety-inger rernem anwekantherr-itwel anenh, angayakw. Nthakenh atha renh-rnem thweneyney-angenh, apmer arleng-warl alpetyek, rernem aytney-alpekerr angayakw angath-antey.” ");
INSERT INTO aly_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kwertengerl ikwerenh-rnemel renh ayernek, “Amernan anwantherr nthenh-itwel inem artwa arnkengeny wantetyek? Arrangkwarl nhenhan, aherretyarl! Atherrkeny-weny!” ");
INSERT INTO aly_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesus-el renh-rnem ayernek, “Amern akngerrelang arrekantherrenhan?” Rernem renh tyernek, “Ya, amern ampeng 7-ant aynteyel, aker irrpeng irrpety.” ");
INSERT INTO aly_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesus-el ingkerrenh ilek, “Arrantherr ingkerrenh anenherr-arey ahernel.” ");
INSERT INTO aly_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jesus-el amern 7 renh-rnem inek aker irrpeng-rnem-then. Ra Ingkart Akngey-warl angkek, inkwerelhemel, amern-then aker-then akngerr anthetyek. Jesus-el amern-then aker-then rlweth-akek, kwertengerl ikwerenh-rnem anthemel, rernem artwa ingwer-rnem antheynetyek ingkerrenh. ");
INSERT INTO aly_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Jesus-el amern irrpety-penh irrpelthel akngerrilek, ingkerrenh wantetyek. Amern akngerr menty-anem irrek. Kwertengerl rernem ingkerrenh amern-rnem akwetyeynek, teram 7-warl ampwerrk iwemel ingkerrenh. Teram 7 amern akngerr-akert rtnenh. ");
INSERT INTO aly_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Artwa 4,000 rernem atnerteng-anem anenh, arelh-rnem-then ampernem-then. ");
INSERT INTO aly_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jesus-el ingkerrenh thwenek, rernem apmer-warl alpetyek. Jesus rtnwewarl nganek. Rtnwa ikwerel rernem alhek apmer ingwer-ampeny-warl-anem, apmer Magadan-warl. ");
INSERT INTO aly_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Artwa Pharisee-rnem Sadducee-rnem-then Jesus-warl apetyek, ilerretyek. Rernem renh arrkernek, Akngey-kenh rlterrkek, ingwerek-ingwer-angkwarr mpwaretyek, mwerriletyek. ");
INSERT INTO aly_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ranem renh-rnem ilek, “Alker rnter-rnter irrenty atwerrpan ntwa arem, kel iterl-arem-anem ingwepenh alker akethirrem arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kwenpayel artem, ingwepenh kwaty rntweyenh-anem. Arrantherr alhengk-areyel alker yanh, kwatyarl rntweyenh. Kwaty rntwey-alenty arrantherr arem, arrantherrap iterl-arem. Arrantherr aleyan iterl-arey-angenh, nthakenharl irreyenh.” ");
INSERT INTO aly_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Jesus-el renh-rnem ilek, “Arrantherr angka ingwerek-ingwer ayerneyel-kety menty-anem ayenh ipmenherr-arey. Arrantherran apmwarl! Arrantherran ayenh intemarl arlkareweyel, ‘Mwerr-angker mwanty mpwara Akngey-kenh rlterrk-akertel!’ Atha alakenh-anyem mpwarey-angenh arrekantherr. Athan angka Jonah-akertant ilem arrekantherr.” ");
INSERT INTO aly_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kwertengerl ikwerenh-rnem kwaty ilkwangkwarr artarnpenhek. Rernem amern ampeng iwerl-alhek apmerek. ");
INSERT INTO aly_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesus-el renh-rnem ilek, “Mwantyel arntarnt-arelhenherr-arey artwa Pharisee-rnem-kety, artwa Sadducee-rnem-kety. Ahelarl rernem arlwar rtneyel-kety, thwet-penh-apeny, apmwangkwarrarl rernem akalty-antheyel-kety.” ");
INSERT INTO aly_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kwertengerl ikwerenh-rnem apal angkerrenh Jesus-el renh-rnem ilerl-anentyek-athen, “Ra ahelirreyel anwekantherr, anwantherrarl amern iwerl-alhekek-arnterl.” ");
INSERT INTO aly_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesus-el iterl-arek, rernemarl ikwer angkerrenh. Ra renh-rnem ilek, “Ilekekarl arrantherran amernek angkerreyel, arrantherr amern iwerl-alhek-penhan? Arrantherr ayenh tnakey-angenh, atha ingkerrenh amernel wantey-angker! ");
INSERT INTO aly_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ayenh arrantherr iterl-aremer, ayeng Akngey-kenh rlterrk-akert. Arrantherr ayenh iterl-aremer, atha artwa akngerr 5,000 wantek, amern 5-pelel. ");
INSERT INTO aly_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Arrantherr ayenh iterl-aremer, atharl 4,000 amernel-then akerel-then wantekarl amern 7-pelel.” ");
INSERT INTO aly_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Jesus-el renh-rnem ilek, “Mwantyel arntarnt-arelhenherr-arey Pharisee-rnem-kety, Sadducee-rnem-kety. Ayeng amernek angkey-angenh. Mwanty arnwarnelhemel yanh-rnem-kety, rernemarl apmwangkwarrarl akalty-antheyelarl-kety.” ");
INSERT INTO aly_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kel rernem iterl-arek-anem, rarl artwa ingwer-rnemek angkenh, Pharisee-rnem-then Sadducee-rnem-then rernemarl apmwangkwarr akalty-anthenh. ");
INSERT INTO aly_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesus ra apmer Caesarea Philippi-warl apetyek, ra kwertengerl ikwerenh-rnem ayernek, “Artwa angwenh Akngey-kenh Impenan rernem ileyel?” ");
INSERT INTO aly_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Rernem angkek, “Ingwer-rnemel ileyel John Baptise-emeley-angker apek, Elijah apek, Jeremiah apek, Akngey-kenh angkakert ingwer-rnem apek.” ");
INSERT INTO aly_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ra renh-rnem ayernek, “Ilek arrantherr atyeng angkerreyel?” ");
INSERT INTO aly_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Peter-el renh ilek, “Nga Christ-arl, Akngey-kenh alerikwarl.” ");
INSERT INTO aly_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesus-el renh ilek, “Simon, Jonah-kenh alerikw, Akngeyel ngenh arntarnt-areyel innga! Ahern-arenyel ngenh akalty-anthey-angenh. Akngey atyenh irrwerl-areny anyentelant ngenh akalty-anthekan, ntwa ayenh iterl-arayntetyek! ");
INSERT INTO aly_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Peter rlterrkarl ngan. Apwert rlterrk-itwel warl artelhem-apeny, Peter rlterrk arrpemarl. Atyenh-rnemel rlterrk-angkwarr apenterl-ayntetyek ngkweng-angkwarrant. Arrentyel renh-rnem nthakenh ywerrelhiley-angenh.” Alakenh-anyem Jesus-el renh itnewek, itnan apwertarl, Peter renh. ");
INSERT INTO aly_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","“Atha ngenh mwerr-angkwarr arraty rnkerneyel, apmwa ingkerrenh-they iwetyek. Ntwa apmwa ingwer-they iwenty Akngey-kenh-angkwarr, kel. Akngeyel artwa renh areyel mwerr-anem, arraty-anem. Ntwa apek ingwer-they apmwa iwey-angenh, Akngeyel renh areyel arrangkwarl, apmwakert-anteyarl.” ");
INSERT INTO aly_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jesus-el kwertengerl ikwerenh-rnem artwerilek, “Atyeng angkerrey-angenh arrantherr anayntetyek, ayengarl Anyent Impenan, Akngeyel ayenh thwenek ahern nhenh-warl.” ");
INSERT INTO aly_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ikwer-penhan Jesus-el renh-rnem akalty-anthek, “Arlta atyenhan arrer-anem. Alerl ayeng Jerusalem-warl alpetyek. Jew-kenh tyaty-areny Atyetyartel-rnem-then priest-rnemel-then ayenh anterrkweyenh, irrwampenh anthemel. Ahelengkwel-rnem ayenh ipmek atweyenh. Ingwa atherr-penh ayeng ipmepenh akemirreyenh arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Peter-el renh ilek, “Akngeyel ngenh iwerl-alhey-angenh. Ahelengkwel-rnem ngenh atwey-angenh.” ");
INSERT INTO aly_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesus-el renh ilek “Atyengety alhay Satan-ay! Ngarl iterreyel ahern-areny-kenh-angkwarr, Akngey-kenh-angkwarr-weny!” ");
INSERT INTO aly_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jesus-el kwertengerl ikwerenh-rnem ilek, “Arlka menty anthelhem atyeng-angkwarr apenterl-ayntetyek, amentewarl alhey-angenh. Ingwerenty apek iteth anetyek ilkelhenty, ra atyeng-angkwarr apenterl-ayntetyek, ikwer-rnem-angkwarr iterrey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nga amentewarl alhenty, ngap ilweman. Nga atyeng-angkwarr apententy, ngap iteth aneman. ");
INSERT INTO aly_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nga ahern-arenyekant iterrenty, ngap amentewarl irrem, ywerrem-anem. ");
INSERT INTO aly_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Akngey-kenh Artwa Impen ranem apey-alpeyenh Akngey-kenh rlterrk ilkwakert, angel-rnem-akert. Ranem renh-rnem arntarnt-areyenh, rernemarl mwerr-angkwarr apentenh. ");
INSERT INTO aly_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ingwerel-rnem Akngey-kenh Artwa Impen areyenh-antey, ikwerenh-rnem-akert, rernem ilwey-alenty.” ");
INSERT INTO aly_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Arlta 6-penh, Jesus-el renh-rnem atnwenhek apwert irrwerl ikwer-warl, amentewarl. Peter-then James-then awayikw ikwerenh John-then. ");
INSERT INTO aly_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kwertengerl ikwerenhel-rnem arek, inngerr renh arrtyernenty, ingkenyel arrtyernem-apeny, arnkwan arlter inngakertel. ");
INSERT INTO aly_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Arrwekeleny-atherr, Moses-then Elijah-then Jesus-itwel aremirrek arrpemarl. Rernem angkerrenh. ");
INSERT INTO aly_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Peter angkek Jesus ikwer, “Ingkartay, awethem ntwa anwernenhantherr atnwenhey-alhek nhewarl. Mwerr anwernantherr lywenty irrpety rnkerney, ingweran ngkwengarl, ingweran Moses-ekarl, ingweran Elijah-ekarl. Nga apek ilkelhentyekan.” ");
INSERT INTO aly_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Peter rarl angkenh-antey, kwenpayel-anem renh-rnem artek ingkerrenh-antey. Rernem angkanem awek, irrwerl-theyarl angkek, “Nhenh alerey atyenh, ayeng ikwer inkwerelheyel, ikwer awelhenherr-arey!” ");
INSERT INTO aly_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Rernem awek-penh, rernem ilperr iwelhek aterel. ");
INSERT INTO aly_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesus-el renh-rnem arnep-arnek, angkemel, “Akemirrenherr-arey, aterirrey-angenh!” ");
INSERT INTO aly_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Rernem-anem itnywenenhey-alpek Jesus anyentant-anem rtnerl-anenty. ");
INSERT INTO aly_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Rernem apwert-they atwarrenhey-alpenh, Jesus-el renh-rnem artwerilek, “Anyelk aney-alpenherr-arey, arrantherrarl ayenh aytarek-penh. Ingwer-rnem iley-angenh, Akngey-kenh Artwa Impen ayeng ipmepenh itethirrenty-penhelant ingwer-rnem iletyek.” ");
INSERT INTO aly_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kwertengerl ikwerenhel-rnem Jesus renh ilek, “Moses-kenh angka akalty-anthenh-anthenhel-rnem ileyel, ‘Elijah retangkwelarl apetyeyenh arrwekelan, Christ-ek-athath.’” ");
INSERT INTO aly_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","12","Jesus angkek, “Ya, arraty inngarl! Elijah kel arrwekel apetyek, ingkerrenh akaltyiletyek, rernem Akngey-angkwarr arratyirretyek. Rernem Elijah ikwer irrpelthirrenh. Alakenh-anyem rernem ayenh Artwa Anyent Impen Akngey-kenh irrpelthirremel atweyenh, ipmek-atwety. Akngey-kenh angka alakenh aynteyel.” ");
INSERT INTO aly_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kel rernem iterl-arek-anem, “John wethekarl nhan angkeyel anwekantherr!” ");
INSERT INTO aly_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Rernem apetyek, artwa akngerr akarrirrek-warl. Artwa anyent apmer ikwer-areny apetyek kwenirremel, Jesus ikwer-warl angkek, ");
INSERT INTO aly_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ingkartay, atha awey arntety atyenh akngetyek ngkweng-warl, ntwa renh mwerriletyek. Awey ra arwengk-arwengk irreyel, rwewarl aytneyel, kwaty-warl-then. ");
INSERT INTO aly_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Atha ywarn-antey ayernek kwertengerl ngkwenh-rnem, rernem awey atyenh mwerriletyek. Rernem arrangkwarl.” ");
INSERT INTO aly_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesus angkek, “Akngerr-inger ayeng arrekantherr ywarn arrkernelhek, atha arrenhantherr akaltyileyek. Atyeng arrantherr arlkwentey-angenhel, iylpelantarl awenh. Nthakenh ayenhan arrantherr iterl-arey-angenh, ayengan arlertek ilkwakert? Awey ilenh atyeng-warl akngetya!” ");
INSERT INTO aly_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Rernem akngetyek awey renh Jesus ikwer-warl. Jesus-el arrenty renh irrentek. Awey ra mwerrirrek-anem. ");
INSERT INTO aly_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kwertengerl ikwerenhel-rnem renh ayernek ament-itwek, “Jesus, nthakenh ngkwengantarl arrenty ilenhan awelhemel alpek, anwernantherr ywarnarl ikwer arrkernelhek, arrenty renh irrentetyek.” ");
INSERT INTO aly_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesus-el ilek kwertengerl ikwerenh-rnem, “Arrantherr Akngey renh rlterrk tnakey-angenh. Arrantherrap Akngey renh tnakenty, arrantherr apwert renh ilenty akngelhetyek, kel ra akngelhem. Ntwa Akngey renh tnakentyelan ntwa ilek-ilek mpwarem.” ");
INSERT INTO aly_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Rernem alhek, apmer Galilee-angkwarr. Jesus-el kwertengerl-rnem ilek, “Ahelengkwel-rnem ayenh artwa anyent impen Akngey-kenh anterrkwemel atweyenh. Ingwa atherr-penh, ayeng ipmepenh itethirremel akwenteyenh.” Rernem ikwer alpwelyirrek-anem amperrngirremel, rarl renh-rnem ilek. ");
INSERT INTO aly_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesus kwertengerl ikwerenh-rnem-akert Capernaum tawen-warl apetyek. Man akwetyey-angker rernem Peter renh ayernek, “Atyetyart ngkwenhel man antheyel Jew-kenh tyaty ilkwareny-rnemek, arrangkw apek?” ");
INSERT INTO aly_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Yaw, ra man antheyel,” Peter-el renh-rnem ilek. Peter ra apmer-warl alpek. Jesus-el renh ayernek, “Atyetyart ahern-areny-rnemel angwenh-rnem-they man-rnem ineyel, alerikw-rnem-they apek, ingwer-rnem-they apek?” ");
INSERT INTO aly_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peter-el renh tyernek, “Ingwer-rnem-they.” Jesus-el renh ilek, “Alerikw-rneman arrangkwarl, man anthey-angenharl. ");
INSERT INTO aly_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mwerr alakenh anwantherr ikwer-rnem irrwernelhey-angenhan, ikwer-rnem awelhemel. Nga alhetyek irrpeng anterrkwetyek. Arrakert altywerilemel, ngkweltyan ikwer-itwek anetyek, man akwetyey-angker anthemel, man tyaty ilkwareny-rnem-warl anthetyek.” ");
INSERT INTO aly_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kwertengerl 12 apetyek Jesus ikwer-warl renh ayernetyek, “Ngenharl apenteyel-rnem, kwertengerl angwenharl atyetyart ilkwan ingwer-rnem-they?” ");
INSERT INTO aly_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesus arlkek ampa akely anyentek. Jesus ra ampa akely renh ampepek rnkernek. ");
INSERT INTO aly_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ra renh-rnem ilek, “Atha arrenhantherr ileyel. Ampernem-apeny arrantherr akarrirreyek Akngey-warl, ikwer awelhetyek, Akngey Atyetyart arrekantherrenh anem. Arrangkwelan, Akngey intwemelirrem arrekantherrety. ");
INSERT INTO aly_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ampa nhanyem atyetyart-arrpantey ilelhey-angenharl. Artwa anyent atyetyart-arrpantey tnakelhey-angenh, Akngeyel arrernem atyetyart ilkwa kwertengerl ingkerrenhek anetyek. ");
INSERT INTO aly_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ampa akely ikwer arrantherr inkwerelhenty, arrantherr atyeng inkwerelhem arrpemarl. Ampa akely arrantherr arntarnt-arem-apeny, arrantherr ayenhan arntarnt-aretyek arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ingwerentyel kwertengerl atyenh-rnem arrkernenty, rernem apmweletyek, Akngeyel renh arntety ilkwa antheyenh. Ra irrwampenty awelhekerr, ingwerel nthakenh renh kwaty ampep-warl iwemer, apwert ilkwa ikwer-warl arrernenty itewarl. Artwa ingwerel atyenh-rnem apmwelenty, Akngeyel renh arntety ilkwa antheyenh. Atyenh-rnemarl apmweleyelarl-kety, artwa ikwer-warl apwert ilkwa itewarl arertnetyek renh kwaty-warl ikwerenp iwemel. Atyenh-rnem ra apmwelerl-anekerr renh iwetyek intem-antey kwaty kwen-warl. ");
INSERT INTO aly_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Artwa anyentel ingwer-rnem rwewilenty, Akngeyel renh arntety antheman. ");
INSERT INTO aly_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Artwa itepel apmwel-areth mpwareyel ingketyel apek. Artwa anyentel itep-atherr-akertel apmwel-areth mpwareyel-kety, mwerran itep anyent-angkwarr renh akalthemel iwemer, ra itep-atherr-akertan rwa ilkwel apmwakert aney-kety. Mwerr-ayteng ra anetyek Akngey-kenh apmer-itwek intem-antey itep anyent-akert. ");
INSERT INTO aly_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Artwa anyentel annga atherr-akertel apmwel-areth mpwareyel-kety, mwerran annga renh tyerremer iwemel. Mwerr-ayteng ra anetyek Akngey-kenh apmer-itwek intem-antey annga anyent-akert. Annga atherr-akertel apmwel-areth mpwareyel-kety, rwa ilkwewarl alhetyek.” ");
INSERT INTO aly_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jesus-el renh-rnem ilek, “Arrantherr Akngey-angkwarr apenteyel-rnem-kety arlkarirrey-angenharl. Itnweng ikwer-rnem-kenh Akngey-kenh apmer-itwek aneyel. ");
INSERT INTO aly_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Artwa anyentel yep-yep akngerr 100 arntarnt-arenh. Yep-yep anyent amentirrek ikwer-rnem-they. Aperrertirrek. Artwa ra yep-yep ingwer-rnem iwerl-alhem, yep-yep anyent ikwer nthwetyek. Rap nthwem yep-yep anyent renh arey-alheyek-atwety. ");
INSERT INTO aly_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ra renh arey-alhem, rap ikwer inkwerelhem. Rap ilem, ‘Inngantey atha arey-alhek!’ ");
INSERT INTO aly_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Akngey ilkelheyel ingkerrenhek, ingwer-rnemarl amentirreyel-rnemek-then rernem ikwer-warl ingkerrenh angkepirretyek.” ");
INSERT INTO aly_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ingwerenty ngkweng apmwel-areth angkenty, mpwelanth-atherrap arratyilerretyek. Ra ngkweng awelhenty, mpwelanth mwerrant-atherr-anem anayntetyek. Ingkart-kenh-angkwarr alakenh aynteyel. ");
INSERT INTO aly_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ra apek ngkweng awelhey-angenh, ntwa ingwer-rnem ikngwetyek, ingkerrenh-angkwarr-anem arratyilerretyek, rernem ingkerrenhel awetyek, anngetherr. ");
INSERT INTO aly_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ingwer-rnemek awelhey-angenh arrangkw, tyaty-areny-rnemel renh arratyiletyek angkerremel. Tyaty-areny-rnem ingkerrenh alhetyek ikwer-warl, rernem ingkerrenhel awetyek, anngetherr aretyek. Ra apek tyaty-areny ingkerrenhek awelhey-angenh, menty-anem renh tyarlewetyek, ra apmwangkwarr menty alhetyek. ");
INSERT INTO aly_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nga mwerr angkenty, Akngey mwerr angkem arrpemarl. Nga arrkngert-angkenty, Akngey arrkngert angkem arrpemarl. Ntwa apmwa ingwer-they iwem Akngey-kenh-angkwarr, kel. Akngeyel renh areyel arraty. Ntwa apek ingwer-they apmwa iwey-angenh, Akngeyel renh areyel arrangkwarl, apmwakert-anteyarl. ");
INSERT INTO aly_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Arrantherr angkerrenty, Akngey renh ayernenty, Akngey irrwerl-areny awelhem, rap arntarnt-areman. ");
INSERT INTO aly_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Rernem akarrirrenty, itna atyenh-angkwarr, ayeng ikwer-rnem-itwek aneyel arrpemarl intem-antey.” ");
INSERT INTO aly_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Peter Jesus-warl apetyek. Peter-el renh ayernek, “Arleng-alentyang anwantherr angkep atwerrey-angenh anetyek, mwerrant-arey anem, arratyilerretyek? Ra atwenty arrpemarl, anwantherr renh atwey-angenh arrpemarl. Angkep atwey-angenh ngay? 7-ingerant atwenty, anwantherr renh angkep atwey-angenh?” ");
INSERT INTO aly_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus-el renh tyernek, “7-inger-weny. Intem-antey atwerrey-angenh arrantherr anetyek, Akngey-kenh-angkwarr! ");
INSERT INTO aly_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Akngey-kenh-angkwarr alakenh aynteyel; atyetyart ilkwel warrkenh-rnem akarrilem, angkerretyek, pwek iparetyek, man ilkwarl alheleyel. ");
INSERT INTO aly_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Artwa ingwerel-anem renh alhelenh 50 million-arl. ");
INSERT INTO aly_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Artwa ra arrangkw-antey anenh, pwek iparey-angenh-antey, ranem tharlemilek anewikw-then, alerikw-then ingkerrenh, apmer ikwerenh-then-antey, pwek renh iparetyek. ");
INSERT INTO aly_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Artwa ra ampwethel alernelhemel, kwenirrek. Ra ilelhek, ‘Ayengan man-wenyarl, arrangkwarl. Alerl mpwelha, ingwer-ingerant atha ngenh man ingkerrenh antheynetyek, pwek iparetyek.’ ");
INSERT INTO aly_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Atyetyart ra ikwer amperrngirrek, irrepernek, man-wenyek. Ranem renh ilek, ‘Kel, menty angkep anthey-angenh, pwek payemeley-angenh.’ ");
INSERT INTO aly_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Artwa warrkenh ra alpek-anem, ra artwa ingwer-anem arey-alpek, rarl man thilp 100 alhelenh, man akely. Itethey anterrkwemel ra angkek, ‘Man ntwa ayenh angkep anthenhey-alpa!’ ");
INSERT INTO aly_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Artwa ranem ampwethel alernelhemel kwenirrek, ‘Alerl mpwelha, atha ngenh angkep anthetyek.’ ");
INSERT INTO aly_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Artwa warrkenh ra warrkenh ingwer tyayl-warl akwernek, man anthey-angenh-they. ");
INSERT INTO aly_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Warrkenh ingwer-rneman ikwer amperrngirrek. Rernem-anem atyetyart renh ilek, ‘Artwa warrkenh ingweran tyayl-itwek aneyel.’ ");
INSERT INTO aly_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","33","Atyetyart rantey yangkelhek artwa arrwekelarl ikwer ilelhekek, apetyetyek. Ra angkek, ‘Ngan apmwangkwarrarl alheyel! Athan ngenh menty-anem tyarlewek, pwek iparey-angenh. Nga ingwer-rnemek amperrngirrey-angenh, ayengarl ngkweng amperrngirrek-apeny.’ ");
INSERT INTO aly_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Atyetyart ranem ahelirrek. Ra warrkenh renh ahayiwek tyayl-areny-warl. Tyayl-arenyel renh tyayl-warl intem akwernek pwek ikwerenh ra ipareyek-atwety.” ");
INSERT INTO aly_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesus angkek, “Akngey-kenh-angkwarr alakenh-anyem aynteyel arrpemarl. Nga awerr ingwer-rnemek aneyel, Akngey irrwerl-areny atyenh ngkweng awerr arrpemarl mpwelheyel, nthakenh ngenh arntarnt-arey-angenh.” ");
INSERT INTO aly_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesus rarl ingkerrenh akalty-anthenh-penh, ra apmer Galilee-they alhek, apmer Judea-warl alhek, lher Jordan-they intwarr. ");
INSERT INTO aly_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Akngerrel renh apentek. Ra arntety-rnem mwerrilek. ");
INSERT INTO aly_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Artwa Pharisee-rnem ikwer-warl apetyek, renh arrkernetyek. Rernem renh ayernek, “Mwerrang artwel anew ikwerenh iwetyek?” Rernem iterrenh renh arrkernetyek, ra apmwel-areth angkentyek, rernem renh angka ilkwewarl arrernetyek. ");
INSERT INTO aly_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesus-el renh-rnem ilek, “Arrantherr iterl-arey-areny, Akngeyelarl angka nhenh anwekantherr arrernek. Moses-kenh angkan alakenh aynteyel, atharl arrenhantherr ileyel. Akngeyel artwethen arelh-then arrernek, ahern nhenh-warl. ");
INSERT INTO aly_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Artwa akely amek-arenty-iperr ra amikw-then aynikw-then ipmem-anem ra arnkentyel-anem aneyel itengerrey-alentyan. Ratherr intem iteng anetyek. ");
INSERT INTO aly_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Akngeyel renh-atherr itengilemel anthek artwa renh. Nthakenh ratherr iwerreyang, intem-antey ratherr anetyek. Nthakenh ingwerel renh-atherr akngakey-angenh.” ");
INSERT INTO aly_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Rernem renh ilek, “Alakenh Moses-kenh angka aynteyel: ‘Artwa pip-warl itna inkwernelhemel, arelh ikwerenh pip renh anthemel, arelh ikwerety ipmelhetyek.’” ");
INSERT INTO aly_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesus angkek, “Akngey-kenh angka ayntenh arrwekel, nthakenh iparey-angenh. Moses-el angka arrernek ingkern-they, rernemarl amentewarl alhenh-kety. Alakenh-they Moses-el angka arrernek, ingkern-penhel-rnem apenterl-ayntetyek. ");
INSERT INTO aly_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Arelh ngkwenh ntwa iwenty, ntwa arelh ingwer ikngwenty, ntwa Ingkart-angkwarr apmwelhilem. Arelhel arrkarikw ikwerenh iwenty, artwa ingwer-anemarl ikngwetyek, mwerr arelh renh iwem.” ");
INSERT INTO aly_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kwertengerl ikwerenhel-rnem Jesus renh ilek, “Alakenh aynteyel mwerr, anew-weny ament anetyek.” ");
INSERT INTO aly_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesus-el renh-rnem ilek, “Ingwer-rnem alakenh anetyek, Akngeyel ikwer-rnem arrernek-angkwarr-antey. ");
INSERT INTO aly_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ingwer-rnem arrangkwarl. Rernem anew inetyek ywarn. Ingwer-rnem itengirrey-angenh, Akngeyek warrkirr-ayntetyek.” ");
INSERT INTO aly_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Akngerr Jesus-warl alhek, ampa ikwerenh-rnem-kenh-akert, ra akapwert renh-rnem arneyek. Jesus-kenh kwertengerl-rnemel ampa renh-rnem irrentek. ");
INSERT INTO aly_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesus-el arek kwertengerl ikwerenh-rnem ampernemarl irrentek. Ra ahelirrek, angkemel, “Ampernem menty apetyey atyeng-warl! Alakenh ikwer-rnem arrkngert angkey-angenh! Ayeng arlkwenteyel ampernem ingkerrenh atyeng-warl apetyem. Akngey arlkwenteyel ra Ingkart ikwer-rnemek anetyek. Ampernem-apeny arrantherr akarrirrenty Akngey-warl, ikwer awelhetyek, Akngey Atyetyart arrekantherrenh aneyel.” ");
INSERT INTO aly_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jesus-el ampernem akapwert iltyel renh-rnem arnek. Jesus rap ayernek Akngey, ra ampa ingkerrenh atnyeneyek. Kel ra alhek-anem. ");
INSERT INTO aly_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Artwa anyent man akngerr-akert Jesus ikwer-warl anterrey-alhekarl. Ra arrernelhek kwenirremel, Jesus-itwel angkemel, “Akalty-anthenh-anthenhay. Nthakenh ayeng iteth intem anetyek?” ");
INSERT INTO aly_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","19","Jesus-el renh ilek, “Nthakenharl ntwa ayenh ayerneyel, mwerr-angkwarr apenterl-ayntetyek? Akngeyant anyent mwerr! Ntwa Moses-kenh angka renh iterl-areyelarl. Ntwa ingwerenty ipmek atwetyekarl arrangkwarl. Ingwer-kenh anewikw nthakenh ikngwey-angenh. Ampwal-rnem nthakenh irrtyertel iney-angenh. Ingwer-rnemek irrtywerremel iley-angenh, inngant ntwa iletyek. Akngeyek-then ameyek-then awelhetyek. Ingwer-rnem mwerranty arntarnt-arerl-ayntetyek, ngkwenh-rnem arntarnt-areyel-apeny. Alakenh apententy, nga iteth intem-antey aneyenh.” ");
INSERT INTO aly_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Artwa ra Jesus renh ilek, “Ayengan law ilenh-angkwarr apentenh awey akelyankel. Angka ingwer apek aynteyel, apentetyek?” ");
INSERT INTO aly_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus-el renh ilek, “Ampwal akngerr renh-rnem tharlemila man inemel, artwa ilenh-rnem, irrepern-rnem, man-weny-rnem ntwa man anthem. Ikwer-penhan Akngeyel-anem ngenh arntarnt-arem, ngenh atnyenem. Atyeng-angkwarrant-anem apetya!” ");
INSERT INTO aly_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Artwa man-akert ra iterrek man-then ampwal-rnem-then ingkerrenh ra menty impen ayerrpiletyek. Artwa ra amperrngirrek, “Nthakenh-angkwarr ayeng iteth intem-antey aneyenh, man akngerr-akert, ampwal akngerr-akert?” ");
INSERT INTO aly_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesus-el kwertengerl ikwerenh-rnem ilek, “Man-areny ilenh-rneman rernem Akngey-angkwarr anetyek arrangkwarl. Rernem manantarl apenteyel. ");
INSERT INTO aly_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kamwerlan neyl altywer akely-angkwarran nthakenh aylpenhey-angenh, arrangkwarl. Kamwerlan altywer akely-angkwarr aylpey-angenh-apeny, man akngerr-akert-rneman Akngey-kenh-angkwarr aylpey-angenh. Akngeyel nthakenh anyentiley-angenh ikwerenh-rnem-warl.” ");
INSERT INTO aly_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kwertengerl ikwerenh-rnem ywarn iterrek. Rernem renh ayernek, “Ilek-apeny-rnemant Akngey-kenh-angkwarr aylpem, Akngeyel ikwerenh-rnem-warl anyentiletyek?” ");
INSERT INTO aly_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesus angkek, “Akngey rantarl iterl-areyel ikwerenh-rnem-warl anyentiletyek, ahern-arenyel-rnem iterl-areyang arrangkw.” ");
INSERT INTO aly_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Peter-el renh ilek, “Anwernantherr-alew? Kwertengerl anwernantherran ampwal-rnem menty-anem ipmek, ngenhant-anem apenteyel. Akngeyel anwernenhantherr pweytilem, ikwerenh-rnem-warl? Anwantherr inem arrpemarl?” ");
INSERT INTO aly_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesus-el renh-rnem ilek, “Akngey-kenh Artwa Impen ayeng aney-alpeyenh chair mwerr-angker-itwel rlterrk ilkwakert. Kwertengerl arrantherr arrpemarl chair mwerr-angker 12-itwek aney-alpeyenh arrpemarl. Arrantherr Israel kenh-rnem 12 amentew-ament ayerneyenh.” ");
INSERT INTO aly_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","“Artwa anyentarl alhenty, angka atyenh-akert ikwerenh-rnem iwerl-alhemel, angka Akngey-kenh ingwer-rnem ilerl-apayntetyek, Akngeyel renh aleth-antey arntarnt-arem. Artwa ra alhentyelan, ahern ikwerenharlap ra iwerl-alheman, ikwerenh-rnem-then, warl ikwerenh-then, ra iteth intem-antey aneyenh. Akngeyel renh antheyenh akngerr innga renh arntarnt-areyenh intem-antey. ");
INSERT INTO aly_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Akngerr ilkelheyel Akngey-angkwarr apentetyek. Akngerr arrkernelheyel Atyetyart ilkwa anetyek, warrkenh iylpareth-rnem-they. Rernem arrangkwarl. Warrkenh iylpareth-rnem rernemant Atyetyart ilkwa aneyenh.” ");
INSERT INTO aly_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesus-el angka anayntilek ikwer-rnem. “Akngey-kenh-angkwarr alakenh aynteyel. Ingwepenh atyetyart alhek tawen-warl, warrkenh-rnem ikngwerl-alpetyek, amern-angketyarr-itwek warrkirretyek. ");
INSERT INTO aly_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ra angkek, ‘Arrantherr atyeng warrkirrenty, atha arrenhantherr man ilkwa anthetyek.’ Rernem mwerr angkenh ikwer. Ranem renh-rnem arrwekel thwenek amern-angketyarr-warl. ");
INSERT INTO aly_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","9 o’clock ingwepenh-antey, ranem artwa ingwer-rnem arey-alhek, tawen-itwek apatemel rnterl-anenty. ");
INSERT INTO aly_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ranem angkek ikwer-rnem, ‘Arrantherr atyeng warrkirrenty, atha arrenhantherr payemelem.’ Rernem ikwer-angkwarr iylpareth antelhek. ");
INSERT INTO aly_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ra tawen ikwer-warl alhek arrpemarl, rap arey-alhek artwa ingwer-rnem-anemarl, rernem apatemel rnterl-anenty. Renh-rnem ra ayerney-alhek warrkek arrpemarl, ra renh-rnem man anthetyek. ");
INSERT INTO aly_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Atwerrp-anem 5 o’clock ra alhek arrpemarl tawen ikwer-warl. Ra ingwer-rnem-anemarl arey-alhek rnterl-anenty. Ra renh-rnem ayernek, ‘Ilekek arrantherr rntenherreyel apatemel?’ ");
INSERT INTO aly_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Rernem ikwer ilelhek, ‘Ingwerentyel anwenhantherr warrk anthey-angenh.’ Ranem renh-rnem ilek, ‘Arrantherr amern-angketyarr-itwek atyeng warrkirretyek.’ ");
INSERT INTO aly_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Atwerrp-anem atyetyart yangkelhek, warrkenh anyentek, ra apetyetyek, ra ingwer-rnem ngkwelty antheynetyek warrk-penh. Ranem artwernem ilek, ‘Ingkernarl apetyek-rnem-tangkwel man antha!’ ");
INSERT INTO aly_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ra artwa ingkern-theyarl apetyek-rnem man ilkwa anthek. ");
INSERT INTO aly_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Arrwekelarl warrkirrek-rnem, rernem-anem apetyek, man inetyek. Rernem iterrek, ‘Man ilkwa innga anwantherr ineyenh’, arrwekelarl warrkirrey-alhekel-rnem. ");
INSERT INTO aly_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Rernem atyetyart ilkwa iltek, ‘Ntwa man ilkwan anthek ingkern-they apetyek-rnemantarl! ");
INSERT INTO aly_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Artwa ingwer-rneman hour anyent warrkirrenh, ingkern-they apetyek-rneman, anwantherr itwern ilkwel aleth arlkarewelhenh. Ingkernarl apetyekel-rneman nthakenharl man ilkwa inek?’ ");
INSERT INTO aly_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Atyetyart ranem artwa anyent tyernek, ‘Atha ngenh man ilkwa antheynek, weth atharl ngenh arrwekel ilek-angkwarr-antey. ");
INSERT INTO aly_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Man ngkwenh inerl-alha, akngeynemel apmer-warl. Atha renh-rnem man ilkwa antheyel mwerr-angkwarr. Ilek-they ntwa alharlkwek artwa ingwer-rnem, atharl man akngerr anthek? Man ilkwarl atha alhewer payemelem!’” ");
INSERT INTO aly_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jesus angkek, “Akngey-kenh alakenh aynteyel, Akngeyel ingkerrenh arntarnt-arem arrpemarl, ingkernarl apetyek-rnem arntarnt-arem arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesus alhek Jerusalem-warl. Kwertengerl ikwerenh-rnemel renh apentek. Akngerrelan renh-rnem apentek ingkern-theyarl. Ra ilelhek kwertengerl ikwerenh-rnemek, ");
INSERT INTO aly_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Awelhenherr-arey atyeng! Rlengk apmer Jerusalem-warl anwantherr alhem. Ayeng Akngey-kenh Artwa Impen. Anwantherrarl Jerusalem-el aney-alhem. Ahelengkw-rnemel ayenh anterrkweyenh ikwer-itwel. Ayenh rernem akngeyenh, atyetyart tyaty-areny ilkwernem-warl, atyetyart ilkwa Moses-kenh angka akalty-antheyel-rnem-warl. Rernem ayenh ahayiweyenh, ingwer-rnemel ayenh ipmek atwetyek. ");
INSERT INTO aly_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Rernem ayenh ahayiweyenh, Jew-weny ahelengkw-rnem-warl, rernem ayenh ipmek atwetyek. Rernem ayenh irrwaremel, whip-el-tangkwel atweyenh, ayenh rernem ipmek atwey-alenty. Ayeng ipmepenh akemirreyenh ingwa atherr-penh.” ");
INSERT INTO aly_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedee-kenh alerikw-atherr amikw ikwer-atherrenh apetyek Jesus-warl, kwenirremel. ");
INSERT INTO aly_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesus-el renh ayernek, “Ilekay?” Arelh ra renh ilek, “Nga Atyetyart ilkwa aneyenh, Ntwa arraty ilay, ampa atyenh-atherr Atyetyart ilkwa arrpemarl ngkweng-itwel aneyenh?” ");
INSERT INTO aly_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesus-el awayenheng ilek, “Mpwel atyeng mwerranty awelhenherr-atherr. Ahelengkw-rnemel ayenh artewentyel irrwampetyek atweyenh. Mpwel-alew? Mpwel arlka menty anthelhem arrpemarl, ayeng anthelhem-apeny?” Ratherr ilelhek Jesus ikwer-warl, “Ya, menty ahelengkw-rnemel aylernenh irrwampetyek atwey!” ");
INSERT INTO aly_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesus-el renh-atherr ilek, “Rernem innga mpwelenh irrwampetyek atweyenh, ayenh irrpwampetyek atweyenh-apeny. Inpa, athan iterl-arey-angenharl, Akngeyelantarl iterl-areyel angwenharl Atyetyart ilkwa atyeng-apeny aneyenh, Akngey atyenhelant atyetyart ilkwa arrerneyenh.” ");
INSERT INTO aly_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kwertengerl 10 ingwer-rnem kwertengerl ikwer-atherrety arlkarirrek ratherrarl Atyetyart ilkwa anetyek arlkwentek, Jesus-apeny. ");
INSERT INTO aly_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","26","Kwertengerl ikwerenh-rnem Jesus ra ilek, “Atyetyart Jew-weny ilkwernem awerr aneyel-rnem-angkwarr, arrantherr apentey-angenh. Arrantherr mwerrant-arey anenherr-arey. Ingwer atyenh-rnem Atyetyart ilkwa anem, mwerr-angkwarr ingkerrenh arntarnt-aretyek. ");
INSERT INTO aly_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Arrantherr arntarnt-arerretyek, warrkenh iylpareth awelheyel-apeny. Alakenh atha arrenhantherr atyetyart ilkwa arrernem. ");
INSERT INTO aly_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Akngey-kenh Artwa Impen anyent ayeng kel apetyek ahern nhenh-warl, ingkerrenh mwerr-angkwarr arntarnt-aretyek iylparethel. Ayeng arlkan anthelhem ingkerrenhek.” ");
INSERT INTO aly_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesus kwertengerl ikwerenh-rnem-akert apmer Jericho-they alhek, akngerrel renh-rnem apentek. ");
INSERT INTO aly_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Artwa aparrng atherr iwerr impalthel anenh. Ratherr awek ingwerentyelarl renh-atherr ilek, “Jesus apetyem nhangkwarr.” Ratherr arlkek Jesus ikwer, “Jesus, David-kenh, aylekanth amperrngirra!” ");
INSERT INTO aly_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Akngerrel renh-atherr ilek, “Akater anenherr-atherr! Jesus renh arlkareweyang!” Ratherr artewentyel arlkek Jesus ikwer arrpemarl, “Artwa David-kenh! Aylernekanth amperrngirra!” ");
INSERT INTO aly_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesus-el renh-atherr ayernek, “Nthakenh atha ilem?” ");
INSERT INTO aly_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Artwa aparrng ratherr Jesus-warl angkek, “Ingkartay, annga mwerrila, aylernanth mwerr-anem aretyek!” ");
INSERT INTO aly_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesus ikwer-atherr amperrngirrek, annga renh-atherr annga rlkerliletyek, ratherr arleng aretyek. Artwa aparrng ratherr kel mwerr arleng aremel-anem, Jesus-anem apentek. ");
INSERT INTO aly_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesus kwertengerl ikwerenh-rnem-akert apmer ingwer-warl alhew Jerusalem-they arrer-antey, apmer Bethphage-warl, apwert Alip-angketyarr-arrangarr. Jesus-el kwertengerl atherr thwenek, ratherr arrwekel alhetyek, ");
INSERT INTO aly_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Mpwelanthan alhenherr-atherr tawen-warl. Mpwelanthap tangkey atherr arey-alhenherr-atherr, tangkey amenheng-atherr. Rwep lhelenherr-atherr, atyeng-warl inenhey-alhemel. ");
INSERT INTO aly_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ingwerentyel mpwelhenh ayernenty, mpwelanth ilenherr-atherr, ‘Ingkart ikwer aylernanth akngeyneyel wenh tangkey nhan.’ Ra anthem-anem.” ");
INSERT INTO aly_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Alakenh-anyem Akngey-kenh angka arraty ayntenh, angkakert arrwekelenyel ilenh-angkwarr-antey. ");
INSERT INTO aly_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jerusalem-areny-rnem, atyetyart ilkwa rarl apetyeyenh, tangkey-akert. Ra tnakelhey-angenh, tangkey ateralth-akert.” ");
INSERT INTO aly_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ratherr anperl-alhek, Jesus-elarl ilanthek-angkwarr-antey. ");
INSERT INTO aly_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ratherr tangkey renh-atherr ayteng-akngeynek Jesus-warl. Ratherr arnkwa tangkey artep-atherr-warl arrernek. Jesus-anem tangkey ateralth-warl nganek. Alakenh-anyem Akngey-kenh angka arraty innganem irrek, angkakert arrwekelenyel ilenh-angkwarr-antey. ");
INSERT INTO aly_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Akngerr ingkerrenhel arnkwa ahern-warl panty iweynek, tangkey alhetyek ikwer-angkwarr Jesus-akert. Ingwerel-rnem alperrarl akek. Rernem ayatheweyneyek tangkey Jesus-akert ra alhetyek panty-angkwarr. Tangkey alhek panty-angkwarr Jesus-akert. ");
INSERT INTO aly_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Artwa akngerrel Jesus renh apentek. Ingkerrenh ikwer inkwerelhek arrwekel-warl alhenh-rnem-then, ingkern-theyarl alhenh-rnem-then. Rernem Jesus-ek inkwerelhemel arlkek, “Anwantherr Atyetyart ilkwek inkwerelhey, David-kenh innga! Akngeyelarl renh thwenek anwekantherr-warl. Akngeyel renh arntarnt-areyel, ra Atyetyart ilkwa ingkerrenhek aneyel!” ");
INSERT INTO aly_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesus alhek apmer Jerusalem-warl. Ingkerrenh ikwer inkwerelhek, ayernerremel, “Artwa angwenharlap ran nhenhey?” ");
INSERT INTO aly_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Rernem angkerrenh, “Nhenhan Jesus-arl, angkakert Nazareth-areny ahern Galilee-areny.” ");
INSERT INTO aly_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jew-rnem-kenh tyaty ilkwitwek weker-rnemel aker tharlemilenh, store-arrpantey. Ingwerel-rnem aker thiparl tharlemilenh. Jesus ra arek ingwerel-rnemarl aker tyenkerr tharlemilenh, ra ingkerrenh-antey renh-rnem irrentek, taypel-rnem iwemel, ampwal ngkweltyek-arelh-rnem-then. Jesus-el renh-rnem weker-rnem irrentek. ");
INSERT INTO aly_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ra renh-rnem ingkerrenh ilek, “Akngey-kenh angka alakenh aynteyel: ‘Ingkerrenh akarrirrerl-ayntetyek warl nhenh-warl, Akngeyek inkwerelhemel.’ Irrtyert-awarr-rnemantarl apmer nhenh-warlan arrantherr arrernek!” ");
INSERT INTO aly_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Artwa aparrng-rnem-then artwa lerrp-rnem-then ikwer-warl apetyek Jew-kenh tyaty ilkwitwek. Ra renh-rnem mwerrilek. ");
INSERT INTO aly_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jew-rnem tyaty ilkwitwek ampernem arlkalhelirrenh, “Nhanyem David-kenh.” Artwa priest-rnem-then Moses-kenh akalty-anthey-angker-rnem-then rernem arek-penh rernem ahelirrek-anem. Rernem Jesus renh ilek, ");
INSERT INTO aly_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","“Ntwa apek yanh-rnem alhengk-aweyel, rernemarl arlkalhelirreyel?” Jesus-el renh-rnem ilek, “Angka Akngey-kenh arrwekeleny aynteyel: ‘Ampernemel ayenh tnakeyel arraty-angkwarr.’” ");
INSERT INTO aly_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ra renh-rnem iwerl-alhek-anem apmer Bethany-itwel aney-alpek. ");
INSERT INTO aly_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ingwepenh Jesus Bethany-they anperl-alhek apmer Jerusalem-warl, kwertengerl ikwerenh-rnem-akert. Ra angayakw-anem irrek ampepel. ");
INSERT INTO aly_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Arleng-they, ra arwerl tywerrk arek. Ra alhek arrer-warl amernek aretyek. Amern aney-angenh arrangkw-antey ra arek, alperrant. Jesus-el arwerl renh ilek, “Arwerl nhepenh nthakenh ingwerentyel amern arlkwey-angenharl intem-antey!” Arwerl arleny-anem irrek. ");
INSERT INTO aly_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kwertengerl ikwerenhel-rnem renh awek, rarl alakenh angkenh, rernem apatek. ");
INSERT INTO aly_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesus-el kwertengerl ikwerenh-rnem ilek, “Anwantherr Akngey tnakem, ikwer irrpelthirrey-angenh, arrantherr alakenh mpwarem. Arrantherr areyel apwert aleyarl altyweneyel? Arrantherr apwert ilenh ilenty, ra alpetyek kwaty ampep-warl, ra inngarl awelhemel kwaty ampep-warl arrernelhem. Apwert ilenhan arrekantherr awelhemel kwaty ampep-warl arrernelhem-apeny, Akngeyan arrekantherr awelhem, alakenh-anyem. ");
INSERT INTO aly_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Akngeyan arrekantherr awelhem, alakenh-anyem, arrantherr renh tnakenty, renh ayernenty.” ");
INSERT INTO aly_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jew-rnem-kenh tyaty ilkwewarl aylpek. Ra renh-rnem akalty-anthenh. Atyetyart Jew-kenh tyaty-areny-rnem-then artwa ilkwernem-then ikwer-warl apetyek. Rernem renh ayernek, “Angwenhel ngenh atyetyart arrernek, ingkerrenh akalty-anthetyek.” ");
INSERT INTO aly_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesus-el renh-rnem ilek, “Atha arrenhantherr anyent-inger arwa ayernem, arrantherr apek atyeng iletyek. Arrantherr atyeng ilenty, athap arrenhantherr ilem arrpemarl, angwenhelarl ayenhan thwenek. ");
INSERT INTO aly_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Angwenhel John renh arrernek, ingkerrenh baptise-emeletyek, irrwerl-arenyel apek, ahern-arenyel apek?” Rernem angkerrenh, “Nthakenh anwantherr Jesus renh iley-angenh, Akngeyel John renharl thwenek ahern nhenh-warl, anwenhantherr Jesus-elarl arraty ilekerr, anwantherr John ikwer awelhey-angenharl, akengentyarl John ikwer irrpelthirrenh. ");
INSERT INTO aly_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nthakenharl anwantherr iley-angenh, atyetyart ahern-arenyelarl John anwekantherr-warl thwenek, ingwer-rnemarl anwekantherr ahelirrekerr, rerneman John iterl-areyel, rarl Akngey-kenh angkakert inngan aneyel. Rerneman John tnakeyelarl, rarl Akngey-kenh angkakert inngarrpantey.” ");
INSERT INTO aly_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Rernem Jesus ikwer-warl angkek, “Inpa, iterl-arey-angenh, angwenhelarl John renh thwenek ahern nhewarl.” Jesus angkek ikwer-rnemek, “Arrantherr ayenh arraty tyerneyang-kety, nthakenh atha arrekantherr arraty iley-angenh arrpemarl, angwenhelarl ayenh thwenek ahern nhewarl.” ");
INSERT INTO aly_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Atha angka arrekantherr iletyek. Artwamp-kenh alerikw-atherr anenh. Artwamp ra alerikw alkenh ilanthek, amern grapes-angketyarrel warrkirretyek. ");
INSERT INTO aly_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Alerikwan menty-tangkwel angkek, ‘Arrangkw.’ Iterrerl-alpek. Ikwer-penh ra nyerrirrerl-alpek, rap angkep-anem alpek. Ra aynikwek awelhek, atherrk lyapelherl-ayntetyek. ");
INSERT INTO aly_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Artwamp ra alerikw ingweran ilanthek-anem. Alerikwan angkek, ‘Ya, kel ayeng alhem!’ Ranap arrangkw alhey-angenharl.” ");
INSERT INTO aly_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jesus-el renh-rnem ayernek, “Alerikw nthenh-apenyarl aynewikw awelhekan?” Rernem renh ilek, “Alerikw wetharl renh-tangkwel ayernek, rant ikwer awelhekan.” Jesus-el-anem ikwer-rnem ilek, “Apmwernem ingkerrenh rernem Akngey-warl angkepirrenhey-alpeyenh nyerrirremel, man akarriley-angker-rnem-then arelh apmwangkwarrarl alheyel-rnem-then. Rernem Akngey-kenh-angkwarr aylpeyel, arrantherran arrangkwarl. ");
INSERT INTO aly_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","John Baptise-emeley-angker ra iwerr arraty arrekantherr iylparrernekarl, arraty-angkwarr apentetyek. Arrantherranap ikwer irrpelthirrenhan. Apmwangkwarr alhenh-rnem, man akarriley-angker-rnem-then arelh apmwernem-then ikwer awelhenharl, Akngey-warl angkepirremel. Arrantherran anngetherr arek arrpemarl, angkepirrey-angenharl, John ikwer awelhey-angenh.” ");
INSERT INTO aly_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Arrantherr atyeng awelhenherr-arey. Apmerek-artweyel amern grapes lyapelhilek, parrik apwert-penh artek, amern grapes lyapetyek parrikel kwen. Warl arlpenty ra artek, artwa anyent irrwerl anayntetyek, arntarnt-arelherl-anemel, ingwerenty irrtyert apetyekerr amern aketyek. Irrkanem kwen angernemel, amern grapes lthwayntetyek, akarr areyirretyek. Atyetyartel warrkenh-rnem arrernek amern grapes arntarnt-arayntetyek, ra apmer ingwer-warl alhey-kety. Kel ra apmer ingwer-warl alhek. ");
INSERT INTO aly_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Amern ampengirrentyel, ra warrkenh-rnem thwenek, amern grapes ampeng awaketyek ikwer. ");
INSERT INTO aly_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ingwer-rnemel warrkenh anyent atwek, ingweran ipmek-antey atwek, ingwer apwertel wek. ");
INSERT INTO aly_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ra warrkenh ingwer-rnem thwenek, akngerr. Rernem renh-rnem atwek arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ran angkek, ‘Alerey anyent atyenh atha renh thwenetyek, rernem apek ikwer awelhetyek.’ Atyetyartel alerikw ikwerenh anyentant-anem thwenek. ");
INSERT INTO aly_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Atyetyart-kenh alerikw rernem arnarek, rernem angkerrenh, ‘Ingwer-ingeran ranem grapes-angketyarrek atyetyart aneyenh. Anwantherr renh atwey, anwekantherr grapes-angketyarr ayntey-alkenh.’ ");
INSERT INTO aly_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Rernem renh anterrkwek, aketh-warl-anem iwemel ipmek atwek-anem renh.” ");
INSERT INTO aly_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jesus-el renh-rnem ayernek, “Nthakenharl arrantherr iterreyel, atyetyart ra apey-alpeyenhel, nthakenharl warrkenh-rnem irreyenh? ");
INSERT INTO aly_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Atyetyart priest-rnem-then artwa ilkwernem-then rernem renh tyernek, ‘Ra renh-rnem ipmek atweyenh. Ranem warrkenh mwerr-rnem arrerneyenh, rernem grapes-angketyarr mwerr arntarnt-arayntetyek, amern grapes ikwerenh arraty ikwer awaketyek.’” ");
INSERT INTO aly_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesus-el renh-rnem ilek, “Arrantherr Akngey-kenh angka arrwekeleny iterl-arey-areny. Angka alakenh aynteyel: ‘Arwerl arlpenty ingwerel iwem apmwek-athen. Arwerl ran impen-antey, lywenty artetyek. Ingkartel renh arrernek anwekantherr.’ ");
INSERT INTO aly_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Arrantherr ikwer impen anyentek awelhey-angenh, arrantherr amentewarl irrekerr ikwerenh-angkwarr-kety. Ingwer-rnemel renh tnakenty, ra renh-rnem arntarnt-aremarl.” ");
INSERT INTO aly_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Atyetyart tyaty-areny-rnem-then Pharisee-rnem-then rernem awek-penh, rernem iterl-anem-arek, “Anwekantherrip nhenhey angkeyel wenh!” ");
INSERT INTO aly_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Rernem iterrenh renh atwetyek-arrpantey. Rernem aterirrenh, ingwer-rnem-kety, rernemarl renh iterl-arenh angkakert Akngey-kenh. ");
INSERT INTO aly_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesus-el angkanem ikwer-rnem ilek, renh-rnem akalty-anthek arrpemarl, ");
INSERT INTO aly_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Akngey-kenh-angkwarr alakenh aynteyel. Atyetyart anyent anenh. Akngerr akarrirrek, amern kwenty arlkwetyek, alerikw ikwerenh itengirrenty aytaretyek. ");
INSERT INTO aly_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Warrkenh-rnem thwenek, ingwer-rnem ikngwerl-alpetyek. Rerneman arlkarirrek ikwerety. ");
INSERT INTO aly_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ra warrkenh ingwer-rnem thwenek, ‘Ingkerrenh ikngwerl-alpenherr-arey, amern kwenty arlkwetyek, aker pwelek anter-akngerr ilek-ilek, arlkwetyekant-anem.’ ");
INSERT INTO aly_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Rernem ikwer awelhey-angenh. Ingwer-rnem amern weyt atherrk inetyek, ingwerenty amentewarl alherlewenh, ingwerenty amentewarl anew-anenh. Ingwer-rnem store-itwek warrkirrenh ampwal ilek-ilek mpwarenh. ");
INSERT INTO aly_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ingwer-rnemel warrkenh ingwer-rnem anterrkwemel atwek ipmek-antey. ");
INSERT INTO aly_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Atyetyartel inngantey ingwer-rnem irlkentyilek, rernem apmwernem atwetyek, warl-rnem arrtyeynetyek. ");
INSERT INTO aly_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","9","Ra warrkenh ingwer-rnem thwenek, ingkerrenh ikngwerl-alpetyek, ‘Ingwer-rneman arrwekelarl ayernek-rneman arlkarirreyel amern kwenty ikwer-warl apetyey-angenh. Apmer arrpanenh-warl ingkerrenh ikngwerl-alpenherr-arey, ingkerrenh apetyeyek, kwenty arlkwetyek.’ ");
INSERT INTO aly_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Rernem amperirrenhey-alpek akwerr-warl ikngwerl-alpek, artwa ingwerek-ingwer ikngwenhey-alpek warl ikwerenh-warl, amern arlkwetyek, artwa mwerr-rnem-then apmwernem-then ingkerr apey-alhek amern kwenty arlkwetyek. Akngerr innga akarrirrek, warl kwen arrkngelek-anem. ");
INSERT INTO aly_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Akngerr akarrirrek, arnkwa mwerr-angkerel aylpemel. Atyetyart rap arey-alhek artwa ingweran arnkwa aterrng-akertarl, arnkwa mwerrek aylpey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Atyetyart ranem ayernek, ‘Ilek-kety nga arnkwa mwerrelan aylpey-angenh?’ ");
INSERT INTO aly_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Atyetyartel-anem artwernem ilanthek, artwa iltyatherr arertnetyek, ingkety-atherr-then aketh-warl-anem iwetyek, atwemengk-warl, artewentyel arrangkeyel-rnem-warl. ");
INSERT INTO aly_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Akngey akngerrek yangkelhek, irrpety ingwer-rnemant-anem ra arrwekel-antey rlwaneynek, ikwerenh-rnem anayntetyek.” ");
INSERT INTO aly_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pharisee-rnem anyentirrek angkerretyek, rernem Jesus renh irrtywerl-ampernetyek, ra apmwel-areth angkenty renh awetyek. ");
INSERT INTO aly_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Herod-el-rnem-then, Pharisee-rnem-then rernem artwernem thwenek, Jesus renh ayernetyek, “Ingkartay, anwantherr ngenh iterl-areyel. Ngan artwa arraty aneyel, ntwa Akngey-kenh angka arraty akalty-antheyel. Nga ahern-arenyek awelhey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nthakenh nga iterreyel, anwernantherr kapment ilkwernem man antheynetyek, menty?” ");
INSERT INTO aly_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesus ra iterl-arek, rernemarl irrtywerremel angkek ikwer-warl. Ra renh-rnem ilek, “Arrantherr ayenh arrkerneyel, ayeng arrekantherr akengenty angketyek.” ");
INSERT INTO aly_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","“Ngkwelty atyeng akngetyay, atha tax maney aretyek.” Rernem ngkwelty anyent renh anthek. ");
INSERT INTO aly_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesus angkek, “Angwenharl inngerr-akertan nhenhan, itna angwenh-kenh-akert nhan?” ");
INSERT INTO aly_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Rernem ikwer ilek, “Caesar, atyetyart kapment ilkwarlap ran nhenhey!” Jesus-el renh-rnem ilek, “Man-areny-rnemelarl arrenhantherr manek ankem, arrantherr man renh-rnem anthenherr-arey, rernem-anem kapment man renh anthetyek. Akngey-kenh warrk-rnemel man ineynem, arrantherr ingkerrenhel arrernetyek arrpemarl, Akngey ikwer-anem rernem man renh arrernetyek.” ");
INSERT INTO aly_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jesus renh awemel, rernem apateyelpek, Jesus-el angka arraty ikwer-rnem ilekarl. Kel rernem alpek-anem. ");
INSERT INTO aly_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Artwa Sadducee-rnem Jesus ikwer-warl apetyek, renh ayernetyek. Sadducee-rnem akalty-anthenh, arrewaly intem-antey ayntem, nthakenh ipmepenh akwentey-angenh. Rernem Jesus renh ayernek. ");
INSERT INTO aly_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ingkartay, Moses-el angka anwekantherr arrernek, arelh inpertirrenty, ayteyikw ranemarl arelh ikwer-warl itengirretyek ikwer-atherrenh-anemarl, ampa ingwer-anem anetyek. ");
INSERT INTO aly_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","26","Anew ikwerenhek arelh anyent ran inpertirrek ampeweny-anteyarl, ra ayteyikw ikwerenh-itwel itengirrek arrpemarl. Arelh ra inpertirrek ayteyikw ingwerek-anemarl, ampeweny-antey arrpemarl. Ayteyikw-rnem 6 ilenh-rnem arelh anyent ikwer-itwel-antey, rernem ingkerrenh anyentarl-anyentarl itengirrek, arrewaly ingwer iylpelerlewenty, awayikw ingwer-itwel itengirremel, ra ampeweny arrangkw arrpemarl. Artwa anyent aytey aynek itengirrek, arelh ikwer-itwel-antey. Artwa ranem ilwek, ampeweny-antey, arelh anyent ikwerenh ampa ikwer-atherrenh aney-angenh-antey. ");
INSERT INTO aly_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Arelh ranem ilwek. ");
INSERT INTO aly_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Artwa rernem ipmepenh akemirrenty, artwa angwenharlap arelh ikwerenh inngan?” ");
INSERT INTO aly_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus-el renh-rnem ilek, “Arrantherr apmwel-areth akalty-antheyel Akngey-kenh angka arrantherr iterl-arey-angenh. Arrantherr Akngey iterl-arey-angenh-antey, Akngeyan rlterrk ilkwakertarl aneyel, ingkerrenh ipmepenh itethiletyek. ");
INSERT INTO aly_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Rernem ingkerrenh itethirremel alpeyenh rernem aney-alpeyenh intem-antey, arelh-itwel itengirrey-angenh, irrwerl-areny-rnem-apeny. ");
INSERT INTO aly_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Akngeyel arrwekel-antey renh-rnem ilek, rernem angkeparl itethirreyenh, ipmepenh. Arrantherr angka ilenh iterl-arey-areny, angka ilenhan Akngey-kenh pipel arraty inngarl aynteyel. Arwerl wethelarl lherrm ampenh-apeny. ");
INSERT INTO aly_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Akngeyel Moses renh ilek, ‘Ayeng ngkwenhek-rnem ingkerrenhek Atyetyart aneyenh, Abraham-ek, Isaac-ek, Jacob-ek.’ Rernem iteth-antey aneyarr-alpek Akngey-kenh apmerel irrwerl, Abraham-akerr, Isaac-akerr, Jacob-akerr. Arrantherran ingwer-rnem apmwel-aretharl akalty-antheyel intem ilwenty-arrpantey. Rernem ipmepenh itethirremel ingkerrenh alpek Akngey-itwel aney-alpek, intem-antey. Alakenh-anyem, anwantherrarl ilwem, Akngeyel anenhantherrenh angkep arrpemarl itethilem, anwantherrap apmer ikwerenh-warl irrwerl alpem, ra arrenhantherr arntarnt-arayntetyek apmer ikwerenh-itwek intem-antey.” ");
INSERT INTO aly_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jesus-el renh-rnem apatel-anthek. ");
INSERT INTO aly_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pharisee-el-rnem awek-penh, rernem anyentirrek, angkerretyek. ");
INSERT INTO aly_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Artwa anyent ingwerel Jew-kenh-angkwarran iterl-arenhan. Ranem Jesus ikwer arrkernelhek, ayernemel, ");
INSERT INTO aly_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ingkartay, Moses-el angka akngerr anwekantherr arrernek. Nthenh-apenyarl angka rlterrk impen inngan, anwantherr renh apentetyek?” ");
INSERT INTO aly_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus-el renh tyernek, “‘Anyent renhant apentetyek, anyent ikwerant iterretyek’, ");
INSERT INTO aly_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Angka nhanyem impen, arrwekeleny. ");
INSERT INTO aly_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Akngey-kenh angka ingweran alakenhaym aynteyel: ‘Arrantherr ingwer-rnem arntarnt-arayntetyek, ikwer-rnem inkwerelh-ayntetyek, ampa arrekantherrenh-rnem arntarnt-areyel-apeny.’ ");
INSERT INTO aly_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Angka ingwer-rnem arrangkwarl, Moses-kenh angka ingwer-rnem artwa angkakert ingwer-rnem-anem ingkern-they-anem aremirrek.” ");
INSERT INTO aly_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pharisee-rnem ikwer-itwek rtnenh-antey, Jesus-el renh-rnem ayernek, ");
INSERT INTO aly_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nthakenh arrantherr iterl-areyel Christ itethiley-angker renhan. Angwenh-kenh ran?” “Ranem Atyetyart David-kenh,” rernem renh tyernek. ");
INSERT INTO aly_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesus-el-anem renh-rnem tyernek, “Akngey-kenh itnwengel ikwer lwewarrernek. David-el Christ renh itnewek ‘Atyetyart atyenh’. ");
INSERT INTO aly_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Akngeyel atyetyart atyenh renh ilek, ‘Atyeng-itwel ana! Arlkarirreyel-rnem, atha ngenh atyetyart arrernem ikwer-rnem.’ ");
INSERT INTO aly_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nthakenh atyetyart David-kenh? David-el renh atyetyart antweyel. Nthakenh arrantherr iterreyel.” ");
INSERT INTO aly_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ingwerentyel arraty renh tyerney-angenh-they, rernemap menty-anem ipmelhek, angka ingwerek ayerney-angenh-anem. ");
INSERT INTO aly_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesus-anem ingkerrenh-warl angkek kwertengerl ikwerenh-rnem-warl-then, ");
INSERT INTO aly_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Pharisee-rnem-then Moses-kenh-rnem-then akalty innga aneyel, angka Moses-kenh-angkwarran. ");
INSERT INTO aly_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Rernem Moses-kenh angka arraty akalty-antherl-anenty, arrantherr ikwer-rnem awelh-ayntetyek, Pharisee-kenh-angkwarr apentey-angenh. Rernem ingwer-rnem akalty-anthem, rernem Akngey-kenh-angkwarr arraty apentey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Rernem ingwer-rnem akalty-anthem, rernem renh-rnem aleth arntarnt-arey-angenh-anemarl. ");
INSERT INTO aly_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Rernem tnakelheyel. Mwantyel arntarnt-arelhenherr-arey yanh-rnem-kety kwet arlpenty-akert-kety! Akngey-kenh pip-rnem rernem rlwewarl arertnelhem iyterlarr-apeny akwewarl-then, ingkerrenhel renh-rnem arayntetyek. ");
INSERT INTO aly_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Warl ikwer-warl rernem anyentirrem, angkerr-ayntetyek. Rernem arrwekel-warl arrernelheyel arrkngelemel ingwer-rnem-kety, rernemant tnakelhetyek. Ingkerrenhel inkwerelhemel amern arlkwetyek, rernemant arrwekel-warl arrernelhetyek arrkngelemel ingwer-rnem-kety, rernemant tnakelhetyek. ");
INSERT INTO aly_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Akngerr akarrirrenty-warl, akngerrel renh-rnem tnakelh-ayntetyek, ingkart ilkwarrpantey. ");
INSERT INTO aly_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Arrekantherr akalty-anthey-angker anyentant. Akngey anyent irrwerl-areny rant ingkerrenhek aneyel. Ingkerrenh arrantherr aneyel, awayenheng-apeny, angkwerenheng-apeny. ");
INSERT INTO aly_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ingkart ahern-areny ntwa tnakey-angenh, Akngey-arrpantey. Akngey alker-arenyekant anwantherr awelhetyek. ");
INSERT INTO aly_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nthakenh ingkart rltwa tnakelhey-angenh. Artwa itethiley-angker rant atyetyart arrekantherrenh aneyel. ");
INSERT INTO aly_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ingwerenty apek atyetyart ilkwa anenty, rap warrkenh ingwer-rnemek. ");
INSERT INTO aly_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Artwa anyent ilkwarrpantey ilelhenty, Akngeyel renh areyel arrangkwarl. Artwa ra apmwamwam ilelhenty, Akngeyel renh areyel mwerrarl. ");
INSERT INTO aly_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yaw-yaw! Pharisee-rnem-then angka Moses-kenh akalty-anthey-angker-rnem-then! Akngeyelan arrenhantherr artewentyel innga irrwampenh-antheyenh! Arrantherr angka Akngey-kenh arraty akalty-anthey-angenh, akngerr ingwer-rnem akaltyirretyek, ikwerenh-angkwarr anayntetyek. Arrangkwaw! Rerneman angka ikwerenh iterl-arey-angenh, arrantherr-apeny! Rernem irrtywerremel angkeyel Akngey-warl-athek arleng-alenty. Akngeyelarl ingkerrenh court-emileyenh, rap renh-rnem irrwampenh-antheyenh, irrtywalth renh-rnem. Ingwer-rneman ra alyepel irrwampenh-antheyenh. ");
INSERT INTO aly_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Artwa Pharisee-rnemay, Moses-kenh-rnem-then arrantherr apmwangkwarr akaltyileyel. Arrantherr apmer arleng-warl alheyel, artwa anyent angkepiletyek, renh Ingkart-angkwarr akaltyiletyek. Arraty-wenyarl arrantherr apmwangkwarr akalty-antheyelarl, apmwangkwarr apenterl-ayntetyek, arrantherr apenteyel-apeny! ");
INSERT INTO aly_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","17","Rernem irrtywerremel ilelheyel tyaty ilkwangkwarr. Alakenh ingwer-rnem irrtywerremel ilelheyel, ‘Gold innga aynteyel-apeny tyaty ilkwitwel, arraty ayeng angkeyel wenh.’ Tyaty ilkwa impen, gold-an arrangkwarl. ");
INSERT INTO aly_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Apwert ilperr-ilperr impen ikwer tyenkerr ampernetyek. Ingwer-rnemel irrtywerremel ilelheyel alakenh, ‘Apwert ilperr-ilperr tyaty ilkwitwek innga aynteyel-apeny, innga atha ileyel.’ ");
INSERT INTO aly_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","20","Ingwer-rnem alakenh irrtywerremel ilelheyel, ‘Gold tyaty ilkwel innga aynteyel-apeny, arraty innga atha ileyel.’ Ingwer-rnem alakenh angkeyel, ‘Tyaty ilkwa alakenh aynteyel-apeny, innga arraty atha ileyel.’ ");
INSERT INTO aly_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Akngey-kenh warl ilkwa nhel anwantherr iterretyek, arraty apentetyek Akngey-kenh-angkwarr. Inngant nga ilelhetyek, irrtywerremel ilelhey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ingwer-rnem irrtywerremel ilelheyel alakenh, ‘Alkenhel arem’. Arrkent iley-angenh, arrantherr iterretyek Akngey anyent ikwer. Anwantherr iterretyek ra irrwerl-itwel anwekantherr mpwelheyel, irrtywerremel ilelhey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Artwa Pharisee-rnemay! Akngeyelan arrenhantherrenh artewentyel irrwampenh-antheyenh! Arrantherrarl amern atherrk akep-akalthem, akely anthem Akngeyekan, Moses-elarl akalty-anthenh-angkwarr. Angkan ikwerenh arrangkwarl. Angka akely nhan, arrangkwarl. Arrantherr arratyilerrey-angenh, ingwer-rnem arntarnt-arey-angenh, arrantherr Akngey-angkwarr arraty apentey-angenh. Arrantherr angka apenterl-anem angka ingkerr! ");
INSERT INTO aly_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Arrantherr angka anyent impen ikweretyan iylpelirrekarl. Arrantherr angka apmwel-aretharl apenteyel, angka mwerr-angkwarr apentey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Arrantherr Pharisee-rnem apmwel-areth iterreyel. Arrantherr mwerr-arrpantey inngelheyel, kwenan apmwarl. Arrantherr apmwernemarl rnter-rnem. ");
INSERT INTO aly_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Arrantherr artwa aparrng-apeny. Arrantherr apmwekety angkepirretyek Ingkart-warl. Ikwer-penh arrantherr Akngey-angkwarr arraty aneman. ");
INSERT INTO aly_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","28","Arrantherr iterl-arelheyel arraty-angkwarr-arrpanteyarl. Arrantherr arlka kwenan apmwakert-anteyarl! Warl mwerrarl intelheyel-arrpantey ntwa arem, warl apmwarl kwenan. Arrantherr apmwakert-antey aneyel, warl mwerr-arrpantey intelheyel-apeny. ");
INSERT INTO aly_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Akngeyelan arrenhantherrenh inngarl artewentyel irrwampenh-antheyenh! Awank-akerr artwa angkakert Akngey-kenh-rnem rernem akwernek awenng-warl. Arrantherr awenng-rnem ayterlkwel aperneyel mwerr-angker ilemel, angkakert-rnem iylpangk-ayntetyek. ");
INSERT INTO aly_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","31","Arrwekelenyel-rnem angkakert-rnem atwenh. Rernemap awelhey-angenh angka Akngey-kenhek, arrangkw. Alakenh-anyem arrantherr awelhey-angenh arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Arrantherran irrtywerremel ilelheyel arraty-angkwarr-arrpantey, rernemarl angkakert-rnem atwenh-apeny. ");
INSERT INTO aly_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Arrantherr Ingkart-kety amentirrek. Rwa ilkwa arrwekel arrekantherr mpwelheyel. ");
INSERT INTO aly_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Arrwekel-antey Akngey angkek, ‘Atha angkakert-rnem artwa akalty ingwer-rnem-then arrekantherr Jew-rnem-warl thwenetyek. Arrantherrarl ingwer-rnem ipmek atwem, ingwer-rnem arwerl iylpeyl-atherr-warl arrernem, ingwer-rnem whip-el atwem Jew-rnem-kenh tyaty akely-rnem-itwek, ingwer-rnem arntety anthemarl apmer arrpanenhel.’ ");
INSERT INTO aly_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","36","Awank-akerr Cain-el ayteyikw Abel-tangkwel atwek. Ingwer-rnemel-anem atwenh angkakert Akngey-kenh-rnem. Artwa anyent Zechariah Barachiah-kenh alerikw rernem atwek arrpemarl, rarl rtnenh tyaty ilkwa Jew-rnem-kenh kwen-itwel, ampwal rwek-arelh arrerenty. Yaw-yaw, atha arrenhantherrenh arraty ileyel. Akngeyan ahelirreyel arrekantherr. Arrwekeleny-rnemel angkakert Akngey-kenh-rnem awank-akerr atwenh-they, Akngeyel arrenhantherr atweyenh arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jesus-an amperrngirreyelpek Jerusalem-areny-rnemek. “Ayengan ikwer-rnem amperrngirreyel Jerusalem-areny-rnemek! Rernem Akngey-kenh angkakert-rnem atwek, Akngeyelarl ikwer-rnem thwenek. Rernem apwertel wemel, ipmew-antey atwek renh-rnem. Ayenganap ilkelhenh, renh-rnem ingkerrenh-antey arntarnt-arayntetyek. Ayengan ilkelhenh, renh-rnem ingkerrenh akarriletyek, tywek-tywekelarl akely-rnem akarrilem-apeny, aympelhel artemel. Alakenh-anyem. Arrangkwarl! Rernem ingkerrenhel ayenh artepelant arek! ");
INSERT INTO aly_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Alakenh-anyem Akngeyelan apmer Jerusalem arntarnt-arey-angenh. Apmer yanhan ampeny arrangkw aynteyenh, alkey-anem. Tyaty ilkwa renhanap atep-atakeyenh ahernel-anem arlperrty-anem ayntey-ayntey-alheyenh. ");
INSERT INTO aly_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Rernem ayenh arey-angenh arleng-alenty apmer yanh-itwek. Ingwer-inger ayeng angkep apetyeyenh. Rernemap ayenh areyenh-anem, alakenh-anem angkemel, ‘Artwa nhanyem mwerr-angker! Akngeyelan renh thwenek rlterrk-akertel!’” Angka nhanyeman Jesus-elan ilenh Jerusalem-areny-rnem-akert. ");
INSERT INTO aly_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesus ra tyaty ilkwa iwerl-alhek-penh, kwertengerl ikwerenh-rnem apetyek ikwer-warl angkemel, “Warl nhenh-rnem ara!” ");
INSERT INTO aly_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesus angkek, “Ingwer-ingeran ingwerel-rnem atakem-anem, tyaty ilkwa yanh akwarrkirreyenh.” ");
INSERT INTO aly_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Rernem apwert alip-angketyarr irrwerl-warl nganek. Rernem ament rtnenherrenhel, rernem renh ayernek-anem, “Ilengerarl ingwerel-rnem tyaty ilkwa ilenh atakeyenh, akwarrkirretyek? Nthakenh anwantherr arlta ingkern iterl-areyenh? Ngarl apey-alpey-alpeyenhan ilekel anwernenhantherr ileyenhan?” ");
INSERT INTO aly_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesus-el renh-rnem tyernek, “Mwantyel arntarnt-arelhenherr-arey, ");
INSERT INTO aly_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ingwer-rnemarl apetyem-kety rernem irrtywerremel ilelheyenh-kety ayeng-arrpantey, ‘Ayeng Akngeyel wetharl awank-akerr alhelek, ayeng nhanyem-anem apetyek arrekantherr-warl.’ ");
INSERT INTO aly_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Apmer arrpanenh atwerrerl-anenty arrantherr awerl-aneyenh. Aterirrey-angenh arrantherr anetyek. Apmer aparnpan rernem ahel atwerreyenh ahern-then alker-then ywerrey-alenty. ");
INSERT INTO aly_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Apmer ingwer-areny-rnem-then ahel atwerrerl-aneyenh. Angayakwel ilwenherreyenh, ahern akngelheyenh. ");
INSERT INTO aly_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Alakenh-anyem aynteyenh ingweleman, ahern-then alker-then ywerrey-alenty. ");
INSERT INTO aly_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Arrantherr atyeng-angkwarr apenteyel-kety rernem arrenhantherr tyayl-warl akwerneyenh, ingkerrenhel ngenh atweyenh. Ingwer-rnem arrekantherrety arlkarirreyenh, arrantherrarl atyeng-angkwarr apenteyenh. ");
INSERT INTO aly_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ingwer-rnem intwemelirreyenh, ingwer-rnem ahelengkw-rnem-warl ahayiweyenh tnhwerant-arey aneyenh. ");
INSERT INTO aly_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Irrtywerrey-angker akngerr apetyeyenh Akngey-kenh angkakert-arrpantey, irrtywerremel ilerl-aynteyek. ");
INSERT INTO aly_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Akngerrel apmwangkwarr apenteyenh, ipmelhemel-anem mwerrant-arey arnanekerr. ");
INSERT INTO aly_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Arrantherr atyeng-angkwarr apenterl-anenty arlta ingkernek-atwety, Akngeyel arrenhantherr itethileman. ");
INSERT INTO aly_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Angka atyenh arlpimpirreyenh apmer arrpanenh-warl, angka ilpertel-warl rernem ingkerrenhel awek-penh, arlta ra arrer-anemarl.” ");
INSERT INTO aly_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Arlta ikwerel, ahelengkw Jew-kenh tyaty ilkwitwek aneyenh. Akngey-kenh pip angka arrwekeleny-akert Akngey-kenh angka aynteyel, Akngey-kenh angkakert Daniel-elarl ingkwernek. Arrantherrarl awem, tyaty ilkwa ikwerelarl Atyetyart ilkwa ra aneyenh, ");
INSERT INTO aly_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","arrantherr Judea-areny-rneman alhetyek, apwert-warlarl. ");
INSERT INTO aly_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Arnkwek iterrey-angenh, arrantherr arwa apwert-warl anpenheyekant. ");
INSERT INTO aly_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Awangk alhentyel, kwetek angkep alpey-angenh, menty ra ayntey. ");
INSERT INTO aly_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ayeng amperrngirreyel arelh-rnemek, rernem ampa akely irrepern atnyeneyel-kety.” ");
INSERT INTO aly_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Jesus angkek, “Akngey rantarl arlta anyent iterl-areyelan, anwantherr iterl-arey-angenharl. Arrantherr Akngey renh ayerney aherrety arrernetyek, irrerntel arrenhantherr atwekerr. Renh ayerney arrpemarl, arlta arrernetyek, arrantherr alhewerarl alhayntetyek, ltyerrey-angker-wenyel. ");
INSERT INTO aly_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Arlta anyent ikwerel, artwa ingkerrenh arntetyirreyenh, alakenh awank-akerr anwantherr arntetyirrey-angenh. Anwantherr ingkern arntetyirrey-angenh alakenh. ");
INSERT INTO aly_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Arrer-anem anwantherr mpwelhem. Arlta irrpetyap-penh Akngeyel ikwerenh-rnem ingkerrenh arntarnt-areyenh. ");
INSERT INTO aly_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Akngerr arrekantherr-warl apetyem, arrenhantherr irrtywerremel iletyek, Akngeyel renh-rnem thwenenty-arrpantey ahern nhewarl, Christ-apeny. Rernem alakenh ingkerrenh-warl ilelhem. Arrantherr iylpelant renh-rnem awetyek, arrenhantherr ilpertileyekarl ilenhan arrkernelheyel. ");
INSERT INTO aly_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Rernem apetyem, Christ-arrpantey Akngey-kenh angkakert-arrpantey, angka ilek-ilek-akert rernem arrekantherr arrkernelhetyek, arrantherr ikwer-rnem-kenh-angkwarr apentetyek. ");
INSERT INTO aly_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mwantyel arntarnt-arelhenherr-arey ikwer-rnem-kety, arrenhantherr ilpertilekerr, atharl arrenhantherr arrwekel ileyel-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ingwer-rnemel alakenh ileyel, ‘Christ ra apmer arlpawelarl aremirrek.’ Ingwer-rnemel ileyel, ‘Christ ra warl kwenel irrtyertewelheyel ingwer-rnem-kety.’ Ikwer-rnem awelhey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ingkerrenhel Artwa Impen renh areyenh arrpemarl, anaynt, ahern-arenyel awely-awely areyel-apeny. ");
INSERT INTO aly_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Thip-rnem akarrirreyel ipmitwel, thip inkwel. Anwantherr anaynt areyenh arrpemarl, rarl apey-alpeyenhek.” ");
INSERT INTO aly_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ingkeny-then, alkent-then, antyarr-then rernem ingkerrenh akngelheyenh, ayeng Anyent Impen aremirrey-alenty. Ingkeny-then alkent-then ywerreyenh. Antyarr ingkerrenh irrwerl-they aytneyenh. ");
INSERT INTO aly_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Arlta anyent ikwerel, ingkerrenhel ayenh arnareyenh, Artwa Impen anyent Akngey-kenh irrwerl-they apetyenty, rlterrk ilkwakert. Rernem artneyenh ingkerr. ");
INSERT INTO aly_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Terampet angkelh-angkelhileyenh. Ikwer-theyan, atha alker-areny-rnem thwenem, rernem alhetyek, apmer arrpanenh-warl, Akngey-kenh-rnem ingkerrenh akarrilenhey-alpetyek.” ");
INSERT INTO aly_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","33","“Arrantherr iterrenherr-arey, arepampeyel akarley ampengirrentyel ngkweng ileyel aherrety ampep-anem. Akarleyel ileyel-apeny aherrety ampep arrer-anem, ingkeny-then alkent-then ratherr arrenhantherr ileyenh, ayeng alerl apey-alpeyenh arrekantherr-warl ahern nhewarl. Ayeng apey-alpeyenh ahern nhewarl antyarr-then aytnenty, ahern-then alker-then akngelhenty. ");
INSERT INTO aly_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Itetharl aneyel-rnem ingwer-rnemel rernem iterl-aremel areyenh arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Innga atha arrenhantherr ileyel. Ahern-then alker-then ywerreyenh. Angka atyenh intem-antey aynteyenh.” ");
INSERT INTO aly_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nthakenh ingwerentyel arlta iterl-arey-angenh, ilenger ayeng apey-alpeyenh ahern nhewarl. Alker-arenyel-rnem-then iterl-arey-angenh. Akngey anyent rant iterl-areyel, ilenger ayeng apey-alpeyenh ahern nhewarl. ");
INSERT INTO aly_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Rap irrkaty-angkwarr aynteyenh Noah-arl anenh-angkwarr-antey. ");
INSERT INTO aly_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Rernem apatemel anenh, ikwer-rnem-kenh-angkwarrant anenh, amernant arlkwerrenh, ngkwarlant antywerrenh, itengirrenh apmelerreny-angkwarr, Akngey iterl-arey-angenh. Noah-el rtnwa ilkwa arnwarnenh. ");
INSERT INTO aly_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Akngeyel kwaty ilkwa thwenek. Noah-an aylpenhek ikwerenh-rnem-akert rtnwewarl kwen. Kwaty atnyerr ilkwa ra ingwer-rnem ilwerl-athenek. Akngey-kenh Artwa Impen anyent apey-alpey-alenty, alakenh aynteyenh. ");
INSERT INTO aly_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Artwa atherr amern-angketyarrel warrkirrerl-anenty, angel-rnemel anyentant inerl-alheyenh, ingweran iwerl-alheyenharl. ");
INSERT INTO aly_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Arelh atherr apek anerl-aneyenh, ntang atherl-anemel, angel-rnemelan anyentant inerl-alheyenh, ingweran iwerl-alheyenharl. ");
INSERT INTO aly_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mwantyel arntarnt-arelhenherr-arey! Arrantherr iterl-arey-angenh, ilenger Ingkart arrekantherrenh apey-alpeyenh. ");
INSERT INTO aly_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Apmerek-artweyel nthakenh iterl-arey-angenh, anyelk-awarr ra apey-alheman. Ra arntarnt-arelhem, irrtyert-awarr ra anyelkel inekerr. ");
INSERT INTO aly_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Arrantherr iterl-arey-angenh, ilenger Artwa Impen ayeng apey-alpeyenh. Akngey-kenh arlta impen anwantherr iterl-arey-angenh inpa aneyenh. Atyek-antey arntarnt-arerl-ayntenherr-arey!” ");
INSERT INTO aly_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Artwa ilkwa anyent anem warrkenh akngerrew-artey. Atwerrpan ra angkem ikwerenh-rnemek, ‘Ayengarl alhem-kety, arrantherran warl atyenh akarerl-ayntenherr-arey! Mpwelherl-anemel, ayengant apey-alpetyek-atety, arntarnt-arelhemel.’ Akngerr apmer ikwerel akarrirrem, amern akngerr inkwerelhemel amern kwenty arlkwerrem. Ingwa ikwerel-antey artwa ilkwa ra alpem warl ikwerenh-warl. Warrkenh ikwerenh-rnem atyek-antey anem, arntarnt-arelhem ikwer lyenenty-akert. Artwa ilkwan inkwerelhem, warrkenh ikwerenh-rnemarl atyek-antey ikwer mpwelhemek, rarl ilanthek-angkwarr. Ra renh-rnem ilem arrernelhetyek, rap amentel-antey amern-anem ampernem, rernem arlkwetyek. ");
INSERT INTO aly_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Artwa ilkwa alhem-tangkwel. Rarl apey-alpemel, warrkenh renh arey-alpem, mwerrarl warrkirrerl-anenty. Ra inkwerelhem, rap angkem warrkenhek, ‘Nga artwa mwerrarl atyeng warrkirreyel. ");
INSERT INTO aly_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ngan atyetyart aneyenh warlek, pwelek-rnemek, ilek-ilek atyenh ingkerrenhek.’ ");
INSERT INTO aly_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Warrkenh ingweran arraty warrkirrey-angenh. Ra iterrem, ‘Atyetyart atyenh apey-alpey-angenh-antey, ywerreyel-antey.’ ");
INSERT INTO aly_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Warrkenh apmwa ra warrkenh ingwer-rnem atwem. Ran aynterlant-anem, amernant akngerrarl arlkwemel, ngkwarl-then antywem, terangk irretyek-atwety. ");
INSERT INTO aly_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Warrkenh apmwa apal ayntem, atnaraty, atyetyartarl apey-alpeyenhek. Ingwer-ingerant atyetyart apey-alpek anyelkel. ");
INSERT INTO aly_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Atyetyartel warrkenh apmwa artewentyel atwem, irrentemel artwa apmwernem-warl, atyetyart ikwer awelhey-angenh-rnem-warl-anem.” Alakenh-anyem Jesus ikwer-rnem angkenh. ");
INSERT INTO aly_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesus-el renh-rnem ilek, “Angka atha iletyek, Akngey-kenh-angkwarr alakenh aynteyel. Artwa ra aleyak anyent-itwek itengirrey-alenty, aleyak 10 rernem alherlewek artwa anyent rlwatetyek lyenenty-akertel. ");
INSERT INTO aly_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Aleyak 5-pel ingwer-rneman akwerrparl. 5-pel ingwer-rneman akaltyarl. ");
INSERT INTO aly_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Aleyak 5-pel akwerrpel-rnem anter akelyarl akngek, rernem lyenenty lyerrtyiletyek. ");
INSERT INTO aly_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","5-pel akalty-rnem rernem anter ilkwarl akngek, anter ywerrekerr, lyenenty lyerrtyiletyek. ");
INSERT INTO aly_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Rernem ingkerrenh mpwelhenh arleng-alenty. Renh-rnem ankwel atwek, rernem ankwanem ayntek. ");
INSERT INTO aly_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ampepenyelan ingweran arlkek, ‘Artwa yanhey ra apetyeyel-anem! Mpa anwantherr arnekirrey ikwer-warl!’ ");
INSERT INTO aly_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Aleyak-rnem akwentenhey-alpek, ingkerrenhel lyenenty-anem lyerrtyilek. ");
INSERT INTO aly_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","5-pel ingwer-rnem akwerrpel-rnem anterek-anem ayernenh aleyak ingwer-rnem, ‘Anter ingweran anthenherr-arey, lyenenty ywerrekarl-kety!’ ");
INSERT INTO aly_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","5-pel ingwer-rnemel tyernek, ‘Arrangkw. Arrantherr store-warl alhenherr-arey anter ament payemeletyek!’ ");
INSERT INTO aly_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","5-pel ingwer-rnem akwerrp-rnem alhek anter inetyek, artwa ra aremirrek ingkernarl, rernemarl store-warl alhek-kety. 5-pel aleyak akalty-rnem mpwelhenh, kel rernem aylpenhek warl ikwer-warl artwa ikwer-angkwarr, amern kwenty rernem arlkwetyek, artwa ra itengirrey-alenty. Ingwerentyel arriw martek-anem. ");
INSERT INTO aly_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ikwer-penhan aleyak akwerrp-rnem apey-alpek-anem warl ikwer-warl arrpemarl. Rernem arlkek, ‘Ingkartay! Warl altywerilay! Warl altywerilay! Anwernantherr aylpenhetyek arrpemarl!’ ");
INSERT INTO aly_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Artwa angkek, ‘Atha arrenhantherr arraty ilem, atha arrenhantherr iterl-arey-angenh.’” ");
INSERT INTO aly_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesus-el angkanem anayntilek, “Alakenh-anyem aynteyel, ayeng apey-alpeyenh arrpemarl. Arrantherr mwanty arntarnt-arelhetyek, arrantherr iterl-arey-angenharl, ilenger ayeng apey-alpeyenhan.” ");
INSERT INTO aly_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Akngey-kenh-angkwarr alakenh aynteyel, artwa anyentel artwa warrkenh irrpety arrernerl-alhek, rernem apmer arntarnt-arerl-ayntetyek. ");
INSERT INTO aly_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kel ra renh-rnem iterl-arek. Artwa ra arrwekel anthek artwa anyent man 5,000-anem. Artwa ingweran anthek 2,000, artwa ingweran 1,000. Artwa atyetyart alethel-anem ikwer-penhan anperl-alhek. ");
INSERT INTO aly_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Atyetyart ra alhek-kety Artwa anyent ingwer 5,000-akertel, ra 5,000 ingwer-anem mpwarek. ");
INSERT INTO aly_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Artwa 2,000-arl anthek, 2,000 ingwer-anem mpwarek, irrkaty-angkwarr arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Artwa anyent ingwer 1,000 anthekarl, ra irrka angernek, irrkewarl irrtyert akwernetyek arlengkewemel. ");
INSERT INTO aly_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ingwer-ingeran atyetyart angkep-anem apetyek apmer ikwerenh-warl. Ranem renh-rnem anyentel-anyentel manek ayerneynek. ");
INSERT INTO aly_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Artwa 5,000-arl anthek ran ilelhek, ‘Atha 5,000 ingwer-anem ngkweng mpwarek.’ ");
INSERT INTO aly_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Atyetyart ranem angkek, ‘Ntwa mwerr-angkwarr mpwarek wenh! Ayeng ngkweng inkwerelheyel. Apetyay atyeng-angkwarr apmer mwerr-angkerel anetyek.’ ");
INSERT INTO aly_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Warrkenh ingwer 2,000-arl anthek, ranemarl ilelhek, ‘Atha 2,000 ingwer-anem ngkweng mpwarek.’ ");
INSERT INTO aly_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Atyetyart ranem angkek, ‘Ntwa mwerr-angkwarr mpwarek, ayeng ngkweng inkwerelheyel. Apetyay, atyeng-angkwarr apmer mwerr-angkerel anetyek.’ ");
INSERT INTO aly_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Warrkenh ingweran 1,000-akertel atyetyart ikwer ilelhek, ‘Ayengan arrangkwarl. Atyetyartay, ngan artwa awerrarl. Ntwa arwa alhewer man iney-angkeran ingkerrenh-they. ");
INSERT INTO aly_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ayeng aterirrek, man ingkerrenh irrkewarl akwernek, arlengkewemel. Nhanyem man ngkwenh ingkerrenh-antey.’ ");
INSERT INTO aly_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Atyetyart ranem renh ilek, ‘Ngan warrkenh apmwarl, alhengkerrarl. Ntwa ayenh iterl-areyel, atha ingkerrenh akarriley-angker, amern atha lyapelhey-angenh-itwek. ");
INSERT INTO aly_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ntwa man bank-warl arrerney-areny areyilemel. ");
INSERT INTO aly_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Man ngkwenh antha artwa 5,000-akert-warl. ");
INSERT INTO aly_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Arraty-angkwarr apenteyel-rnem Akngeyel renh-rnem arntarnt-areyenh. Apmwangkwarr alheyel-rnem, Akngey ikwer-rnem-kety ipmelheyenh. ");
INSERT INTO aly_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Warrkenh apmwa akwerr-ampeny-warl irrenteyenh, atayel arrangkeyel-rnem-warl.’” ");
INSERT INTO aly_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesus-el renh-rnem ilek, “Ayeng Artwa Impen Akngey-kenh. Ayeng apey-alpeyenh rlterrk ilkwakert angel-rnem-then. ");
INSERT INTO aly_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ahern-areny-rnem ingkerrenh rernem anyentirreyenh atyeng-warl. Atha ingkerrenh akngakeyenh artwa anyentelarl yep-yep-rnem-then nanikwet-rnem-then akngakeyenh-apeny. ");
INSERT INTO aly_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yep-yep-rnem atha akngakeyenh arraty-ampeny-warl. Nanikwet-rnem atha akngakeyenh ayleng-ampeny-warl. ");
INSERT INTO aly_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Athanem arraty-ampeny-rnem ileyenh, ‘Apetyenherr-arey, Akngey atyenh arrekantherr inkwerelheyel. Apmer nhenh atha arrekantherr arrwekel-antey mpwarek, ahern nhenh arrpmerney-angenh-antey. ");
INSERT INTO aly_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ayeng angayakwirrek, arrantherr amern anthek arlkwetyek. Ayeng angkethakwirrek, arrantherr ayenh kwaty antywetyek anthek. Ayeng alethangank, arrantherr ayenh arntarnt-arenh. ");
INSERT INTO aly_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ayeng arnkwek arrangkw anenharl, arrantherr ayenh arnkwa anthek. Ayeng arntetyirrek, arrantherr ayenh arntarnt-arenh. Ayeng tyayl-itwek anenharl, arrantherr atyeng-warl apetyek rwanng aretyek weth-lkwer ilkwatherr.’ ");
INSERT INTO aly_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Mwerrel-rnem renh tyernek, ‘Ingkartay! Ilenger ngenh anwernantherr angayakw arek, amern-anem anthemel? Ilenger ngenh anwernantherr angkethakw arek, kwaty-anem antywetyek anthek? ");
INSERT INTO aly_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ilenger ngenh alethang anwernantherr arek, warl-warl-anem atnwenheynek? Ilenger ngenh anwernantherr arnkwek arrangkw arek, arnkwanem ngkweng anthemel? ");
INSERT INTO aly_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ilenger ngenh arntety anwernantherr arek, tyayl-itwek-then ngenh arek?’ ");
INSERT INTO aly_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Atha tyerneyenh, ‘Atha arrenhantherr arraty ilem, arrantherr alakenh-anyem irrepern-rnem arntarnt-arek, rernem atyenh-rnem ingkerr.’ ");
INSERT INTO aly_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ikwer-penhan ra ayleng-ampeny-rnemek ilek, ‘Arrantherr apmwernem alhenherr-arey atyengety! Alhenherr-arey rwa aknganenty-warl aletharl ampeyel-warl. Atha rwa mpwarekarl, renh-rnem arrtyetyek arrenty-kenh-rnem-then. Rwa nthakenh ilwernelhey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ayeng angayakwirrek, arrantherr ayenh amern arlkwetyek anthey-angenh. Ayeng angkethakwirrek, arrantherr ayenh kwaty antywetyek anthey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ayeng alethang anek, arrantherr atyengety intwemelant irrek. Ayeng arnkwek arrangkw anenharl, arrantherr ayenh arnkwa anthey-angenh. Ayeng arntetyirrek, ayenh arntety arntarnt-arey-angenh. Ayeng tyayl-itwek anek, arrantherr ilkwatherr apetyey-angenh atyeng-warl.’ ");
INSERT INTO aly_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Apmwel-rnem renh tyerneyenh, ‘Ingkartay! Anwernantherr ngenh angayakw arey-angenh? Anwernantherr angkethakw arey-angenh? Anwernantherr ngenh alethang anwernantherr arey-angenh? Anwernantherr ngenh arnkwek arrangkw arey-angenh? Ilenger ngenh arntety anwernantherr arek, tyayl-itwek-then, ngenh arntarnt-arey-angenh?’ ");
INSERT INTO aly_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Atha tyerneyenh, ‘Atha arrenhantherrenh arraty ilem, arrantherr apek artwa apmwamwam atyenh-rnemek alakenh-anyem arntarnt-arey-angenh, rernem atyenh-rnem ingkerr.’ ");
INSERT INTO aly_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Apmwerneman alheyenh apmer rwa aknganentyarl aleth ampeyel-warlarl. Mwerr-rneman apmer mwerr-warl alheyenh, rernem intem-antey iteth aneyenh ikwer-itwek.” ");
INSERT INTO aly_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesus-el renh-rnem akalty-anthek. Ikwer-penh ra kwertengerl ikwerenh-rnem ilek, ");
INSERT INTO aly_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Arlta atherr-inger aynteyel tyenkerr-anem arlkwey-alenty. Ahelengkwel-rnem ayenh Akngey-kenh Artwa Impen artwa ingwer-rnem-warl ahayiweyenh, rernem arwerl iylpeyl-atherr-warl atanthetyek.” ");
INSERT INTO aly_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Moses-kenh-rnem-then, tyaty-areny ilkwernem-then Atyetyart Jew-rnem-kenh-then, rernem akarrirrek, atyetyart ilkwa tyaty-areny Caiaphas-kenh apmer-warl. ");
INSERT INTO aly_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Rernem angkerrenh, Jesus renh anterrkwemel, renh ipmek atwetyek irrtyertel, ");
INSERT INTO aly_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Alerl-antey ra anayntey, akngerrel anwenhantherr atwekerr, ahelirremel ikwer-they.” ");
INSERT INTO aly_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesus apmer Bethany-itwel anenh. Ra amern arlkwenh Simon-kenh warlel, kwertengerl ikwerenh-rnem-akertel. Simon-arl anenh awank tywen-akert apmer ikwerenhel, ra mwerr-anem aleyan. ");
INSERT INTO aly_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Arelh anyentel anter mwerr-angker thelek, akapwert Jesus renh apernemel, arelh rarl anter renh payemelek man akngerrel. ");
INSERT INTO aly_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kwertengerl-rnemel renh arek, rarl Jesus akapwert anterel apernek. Rernem angkerrenh, “Ilek ra anter mwerran arimpeyel? ");
INSERT INTO aly_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ilek-ketyarl ra anwenhantherr anthey-angenh? Anwantherr tharlemiletyek, man akngerr inetyek, man-weny-rnem, irrepern-rnem anthemel.” ");
INSERT INTO aly_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesus-el renh-rnem iterl-arek, rernemarl tyel-angkerrenh. Jesus-el renh-rnem ilek, “Arrantherr ahelirreyang ikwer, mwerr-angkwarr ayenh anterel apernek. ");
INSERT INTO aly_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mwerr-angkwarr arrantherr man-weny-rnem arntarnt-arem. Aleth man-weny-rnem anayntem arrekantherr-itwel. Ayeng nthakenh aleth aney-angenh ahern nhel. Lyert arrantherr atyeng iterretyek. ");
INSERT INTO aly_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mareny-angkwarr arelh ra anterel apernek, ingwer-rnemel ayenh awenng-warl akwernetyek.” Jew-rnemel apmelerr arrewaly anterel apernenh awenng-warl akwerney-alenty. ");
INSERT INTO aly_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","“Atyenh-rnem apmer arrpanenh-warl alhentyel, angka atyenh ilayntetyek, rernem ingwer-rnem ileyenh, arelh anyentelarl ayenh anterel akapwert apernek mareny-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kwertengerl anyent, Judas, apmer Iscariot-areny alhek Atyetyart ilkwa tyaty-areny-rnem-warl Jesus renh ahayiwetyek, rernem Jesus renh anterrkwetyek, rernem renh ipmek atwetyek. ");
INSERT INTO aly_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Atha arrekantherr Jesus iylparrernenhenty, arrantherr renh anterrkwetyek, man ilek-apeny arrantherr ayenh antheman?” Rernem Judas renh man 30 payemelek. ");
INSERT INTO aly_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Judas ra ament-anem iterrek nthakenh-angkwarr ra Jesus renh ahayiwenh ahelengkw-rnem-warl. ");
INSERT INTO aly_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Arlta impen anyent ikwerel, Jew-rnem akarrirrek amern tyenkerr arlkwetyek. Jesus-kenh kwertengerl-rnem apetyek. Rernem renh ayernek, “Nthenh-warl anwantherr akarrirrem, anwantherr tyenkerr atyenhiletyek?” ");
INSERT INTO aly_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesus angkek, “Alhenherr-arey, artwa anyent renh iley-alhenherr-arey, ‘Ingkartel anwernantherrenh thwenek, arlta ikwerenh arrerirrek, ranem tyenkerr arlkwetyek kwertengerl ikwerenh-rnem-akertel, warl ngkwenh-itwek.’” ");
INSERT INTO aly_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Rernem kel tyenkerrek atyenhilek arrwekel, Jesus-elarl renh-rnem ilek-angkwarr. ");
INSERT INTO aly_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ingwel, Jesus kel alhek kwertengerl ikwerenh-rnem-akert amern tyenkerr arlkwetyek. ");
INSERT INTO aly_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Rernem amern arlkwenharl, Ra kwertengerl 12 ikwerenh-rnem ilek, “Artwa anyentel ayenh ahayiweyenh artwa ahelengkw-rnem-warl, rernem ayenh ipmek atwetyek.” ");
INSERT INTO aly_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kwertengerl ikwerenh-rnem amperrngirrek Jesus ikwer. Anyentel-anyentel rernem renh ayernek, “Ayeng-alew, Ingkartay?” ");
INSERT INTO aly_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesus-el renh-rnem ilek arrpemarl, “Artwa anyentel atyeng-itwek amern arlkweyel, rarlap ayenh ahayiwem artwa ahelengkw-rnem-warl. ");
INSERT INTO aly_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Angka Akngey-kenh alakenh aynteyel: ‘Akngey-kenh Artwa Anyent Impen ra ilwem.’ Artwa anyentel ayenh ahayiwem artwa ahelengkw-rnem-warl, ayenh atwetyek. Ikwer-penh rap irrkngerney-weny-anemarl aneyenh. Akngeyel renh atwem. Artwa ilenh rarl apmwangkwarr alkenhirrek.” ");
INSERT INTO aly_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas-el renh ayernek, “Ayeng-alew, Ingkartay?” Jesus-el renh tyernek, “Ngarl arraty ilelhek-angkwarr-antey!” ");
INSERT INTO aly_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Rernem amern arlkwerrenharl-antey, Jesus-el amern inek, Akngeyek angkemel inkwerelhemel, rarl amern renh anthek. Ikwer-they, Jesus-el amern renh rlweth-akek. Ra kwertengerl ikwerenh-rnem anthek, angkemel, “Ina, arlkwa. Nhenhan arlka atyenharlap ran.” ");
INSERT INTO aly_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tyampet wayn-akert inek-penh, ra Akngey angkek inkwerelhemel, rarl wayn renh anthek. Ikwer-penhan ra renh-rnem anthek antywetyek. ");
INSERT INTO aly_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Jesus angkek, “Nhenhan arrknga atyenharlap ran. Arrknga thelelhentyel ayeng ilwem, ingkerrenh-they apmwa irrarlkeyek. Akngeyel arrenhantherr alhelek, apmwa arrekantherrety iweyek, arrenhantherr anyentelhiletyek ikwerenh-rnem-warl. ");
INSERT INTO aly_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Anyent-inger-antey atha wayn nhenhan antywetyek ahern nhenh-itwek. Ingwer-ingerant, atha ngkwarl wayn lyerteny antywem, Akngey atyenh-kenh apmer-itwekant.” ");
INSERT INTO aly_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Rernemap aylelherrek-anem, Ingkart Akngey-warl-athek, inkwerelhemel. Rernem warl ikwer-they Apwert Alip-angketyarr-warl alhek. ");
INSERT INTO aly_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesus angkek, “Ingwel lyert arrantherr alhem, arlperrtyirremel, yep-yep-rnem arlperrtyirremel anterrem, weth-apeny. Akngey-kenh angka arrwekeleny alakenh aynteyel: ‘Yep-yep arntarnt-arey-angker atwenty, yep-yep-rnemarl ingkerrenh arlperrtyirremel anterrem.’ ");
INSERT INTO aly_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Akngeyel ayenh itethilenty-penhant, ayeng apmer Galilee-warl alhem arrwekel.” ");
INSERT INTO aly_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peter ilelhek, “Kwertengerl ingwerel-rnem ngenh menty iwerl-alhenty, athan nthakenh ngenh iwerl-alhey-angenh.” ");
INSERT INTO aly_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus-el Peter renh ilek, “Atha ngenh arraty ileyel, tywek-tywek irrwey ingwepenh arlkey-ayntekerrem-awaty, nga ilelhetyek irrpety-inger ntwa ayenh iterl-arey-angenh akwerrp.” ");
INSERT INTO aly_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peter-el Jesus renh ilek, “Menty! Ayeng alakenh ilelhey-angenh ikwer-rnem-warl. Atha ngenh iwerl-alhey-angenh, aylenhanth-atherr-antey ahelengkw-rnemel atwetyek.” Kwertengerl ingwer-rnem ilelhek arrpemarl, renh-rnem ingkerrenh atwetyek ahelengkw-rnemel. ");
INSERT INTO aly_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jesus apmer ingwer-warl alhek kwertengerl ikwerenh-rnem-akert, apmer Gethsemane. Jesus kwertengerl ikwerenh-rnem ilek, “Nhel arrantherr anayntenherr-arey, ayeng alhey-kety Akngey-warl angketyek.” ");
INSERT INTO aly_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","38","Jesus-el artwa irrpety atnwenhek, Peter-akerr, artwa ingwer atherr-then, Zebedee-kenh alerikw-atherr, renh-rnemant ra atnwenhek. Jesus ilelhek, “Ayengarl artewentyel iterremel ilwetyek-anem irreyel-kety. Arrantherr atyek anayntenherr-arey.” ");
INSERT INTO aly_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesus ilperr-ayntek Ingkart Akngey-warl angkemel, “Akngeyay, ayeng ilkelheyel artwa ahelengkw ilenh-rnem ntwa atyengety anterrkwetyek, ayenh atwekerr. Ntwa atyengety renh-rnem anterrkwa, nga arlkwententyarlan.” Ikwer-penhan, Jesus angkek arrpemarl, “Akngey, ngarl rlterrk inngan, mwerr ayenh menty rernem arntety ilkwa anthey, ayenh ipmek atwey, ngarl arlkwenteyel-angkwarr. Ayeng ngkweng awelheyel.” ");
INSERT INTO aly_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jesus apey-alpek kwertengerl ikwerenh-rnem-warl. Ra renh-rnem arey-alpek ankwantey aynterl-anenty. Ra Simon Peter renh ilek, “Ilekekarl arrantherr ankwantey aynteyel, ngwang ywerrey-angenh ayeng anamerl-antey arrekantherr-warl apey-alpek. ");
INSERT INTO aly_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Arrantherr atyeng atyek arntarnt-arelherl-anemer. Arrenhantherr ingwerentyel arrkernem, arrantherr apmwangkwarr apentetyek. Arrantherr Akngey renh ayernetyek kwenirremel, arrantherr apmwangkwarr apentekerr. Arrantherr ahern-areny arwarl, arraty-angkwarr apenterl-ayntetyek-arrpantey.” ");
INSERT INTO aly_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesus alhek Ingkart Akngey-warl angketyek irrkaty-angkwarr arrpemarl. Ra angkek, “Akngey, mwerr ayenh menty rernem arntety ilkwa anthey awaretyel, ngarl arlkwenteyel-angkwarr. Ayeng ngkweng awelheyel.” ");
INSERT INTO aly_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jesus kwertengerl ikwerenh-rnem-warl apey-alpek. Ra arey-alpek renh-rnem ankwantey aynterl-anenty arrpemarl. Rernem atyek-anem aney-angenh, renh-rnem ankwel intem-antey itnatwenh. Jesus-el renh-rnem akwentelhilek, rernem akater-anem ingkerrenh anenh, nyerrirremel. ");
INSERT INTO aly_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jesus alhek Akngey-warl angketyek arrpemarl, angka irrkaty arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Jesus kwertengerl ikwerenh-rnem-warl apey-alpek, ra arey-alhek renh-rnem ankwantey aynterl-anenty arrpemarl. Jesus-el renh-rnem ilek, “Arrantherr ankwantey arrpem intem aynteyel. Kel arrantherr ankwayntek. Artwa ahelengkw-rnemel Akngey-kenh Artwa Anyent Impen ayenh rlengk anterrkweyenh, artwa apmwernem-warl ahayiwemel. ");
INSERT INTO aly_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ingkerrenh akwentenherr-arey, anwantherr alhetyek. Artwa ilenhel-anyem ayenh ahayiweyenh, artwa ahelengkw-rnem-warl, ayenh rernem anterrkwetyek.” ");
INSERT INTO aly_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Judas apetyek ikwer-warl. Ra ahelengkw-rnem ikngwerl-alpek Jesus ikwer-warl. Atyetyart ilkwernem-then Atyetyart Jew-kenh tyaty-areny-rnem-then, rernem ahelengkw renh-rnem thwenek. Ahelengkw-rnem nayp arlpenty-akert apetyek, walth-then-akert. ");
INSERT INTO aly_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas-elarl renh-rnem ilek arrwekel, rernem iterl-aretyek, “Athan artwa weth renh arrwantyem, arrantherraw renh anterrkwenherr-areyarl.” Ahelengkw-rnemel Jesus renh alhengk-arek, Judas-elarl arrwekel ilek-penh. ");
INSERT INTO aly_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas Jesus ikwer-warl apetyek angkemel, “Atyetyartay!” Judas-el Jesus renh anterrkwemel arrwantyek. Jew-rnemel artwa ingkerrenh rlwatirremel, rernem arrwantyirremel apmelerr-angkwarr. ");
INSERT INTO aly_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesus angkek ikwer, “Ilekek nga apetyek?” Kel ahelengkw-rnemel renh anterrkwek, Judas-elarl arrwantyek-warl. ");
INSERT INTO aly_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kwertengerl anyent Jesus-kenhel nayp arlpentyel atyetyart ilkwa ikwerenh warrkenh renh iylpa rlweth-arternek. ");
INSERT INTO aly_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesus-el renh ilek, “Nayp arlpenty yanh arrerneyna, ingwerentyel ikwer-anterl angkep atwekerr nayp arlpenty-akertel. ");
INSERT INTO aly_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ayeng arlkwententyarlan, atha Akngey renh ayernem, ra angel akngerr thwenetyek atyeng-warl, ayenh itethiletyek. ");
INSERT INTO aly_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kel, mentyarl. Akngey-kenh angka nhenhan inngarl aynteyel, arrwekelelarl ra atyeng arrernek.” ");
INSERT INTO aly_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jesus-el renh-rnem ilek, “Ilekekarl arrantherr apetyek irrtyertelan, ayenh arrantherr anterrkwetyekan? Nayp arlpenty-rnem-thenan, walth-rnem-thenan arrantherr akngetyek, ayenh atwetyek, ayeng apmwa atwey-angker-arrpantey! Akngerr-inger atha arrenhantherr akalty-anthenh angka Akngey-kenh, ilerl-anemel, Jew-rnem-kenh tyaty ilkwitwek. Arrantherr ayenh anterrkwemer ikwer-antey artwa akngerrel arenty-angkwarr. Arraty-wenyarl alakenh arrantherr ayenh anterrkwek. ");
INSERT INTO aly_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kel mwerr ayenh arrantherr anterrkwemer, alakenh Akngey-kenh angka pipel aynteyel-angkwarr, angkakert arrwekeleny-rnemel ingkwernek-angkwarr, alakenh-anyem innganem atyeng mpwelheyel arrwekel.” Kwertengerl ikwerenh-rnem kel aterel anterrerrek. ");
INSERT INTO aly_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ahelengkwel-rnem Jesus renh akngek Caiaphas-kenh warl-warl atyetyart ilkwewarl. Atyetyart ilkwernem-then Moses-kenh-rnem-then ikwer-warl akarrirrek. ");
INSERT INTO aly_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peter-el renh-rnem apentek, arleng-theyarl. Peter arrernelhek atyetyart-kenh yard-warl, ahelengkw-rnem-itwek. Ra akarenh, nthakenh rernem Jesus renh ileyenh. ");
INSERT INTO aly_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Atyetyart ilkwernem mpwelhenh, ingwer ayernetyek, Jesus renh ayntarrp-iletyek, rernem renh ipmek atwetyek. ");
INSERT INTO aly_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Rernem apatek nthakenharl rernem Jesus renh atweyenh. Ingwer-rnemel ywarn-anteyarl Jesus renh ayntarrp-ilenh. Artwa ingwer atherr apetyek, renh ayntarrp-iletyek. ");
INSERT INTO aly_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ratherr ilenh irrtywerremel, “Jesus ilenh angkek, tyaty ilkwa Jew-rnem-kenh ataketyek, tyaty ingwer-anemarl artey-alkenh arlta irrpety-inger-penh.” ");
INSERT INTO aly_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tyaty-areny atyetyart ilkwel Jesus renh ayernek, “Ntwa anwenhantherr tyerney-angenh-antey. Nthakenh rernem ngkweng angkerreyel? Ntwa anwernekantherr arraty ilay!” ");
INSERT INTO aly_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesus akater anek, tyerney-angenh. Atyetyart ilkwel ayernek arrpemarl, “Akenhel arem, nga arraty-antey atyeng ilelha! Ngenhang Christ Akngeyel anwernenhantherr ilek, ngenh thwenetyek anwernekantherr-warl, ahern nhewarl, Akngey-kenh alerikw?” ");
INSERT INTO aly_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus ikwer ilelhek, “Ya, arrantherr areyenh, ayeng iteth alpenty Ingkart Akngey-warl intem ayeng aney-alpeyenh ikwer-itwel. Ayeng Atyetyart ilkwa aneyenh intem-antey, Akngey-apeny. Arrantherr ayenh areyenh, Ingkart Akngey-kenh apmer-they kwenpay-angkwarr apey-alpenty.” ");
INSERT INTO aly_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Artwa atyetyartel arnkwa ikwerenh ilterrek angkemel, “Nhenhey apmwel-areth angkeyel Akngeyek. Ran nhenhey Atyetyart Akngey-apeny-arrpanteyarl ilelheyel! Arrantherr renh awek rarl angkek Akngeyek. ");
INSERT INTO aly_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nthakenh arrantherr iterreyel, nthakenh rarl apmwel-areth Akngeyek angkek?” Rernem angkerrenh, “Arratyarl anwantherr renh ipmek atwem.” ");
INSERT INTO aly_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Artwa ingwer-rnemelan apelharl iwek, renh atwek. Ahelengkw-rnemel renh annga rag-el artek aparrng ilemel, renh atwemel. ");
INSERT INTO aly_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Artwa ahelengkw-rnemel renh ayernek, “Ngan akaltyarl, Akngey-kenh Impen. Angwenhel ngenh atweyel?” ");
INSERT INTO aly_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Peter-an akethel anenh. Kwey warrkenh Atyetyart tyaty-areny-kenhel Peter renh alhengk-arek ayernemel, “Ngan alhenhap Jesus Galilee-areny-angkwarr. Atha ngenh weth arekan, ngay?” ");
INSERT INTO aly_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Peter ilelhek irrtywerremel, “Inpa, atha iterl-areyangarl renh.” ");
INSERT INTO aly_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Peter anperl-alhek keyt-warl. Kwey warrkenh ingwerel Peter renh arek arrpemarl. Ra ilek artwa ingwer-rnem-warl-anem, “Nhanyemarl ran Jesus Nazareth-areny-angkwarrarl alhenhan, atharl renh alhengk-arekan.” ");
INSERT INTO aly_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Peter irrtywerremel ilelhek arrpemarl, “Akenhel arem, arrangkw, atha iterl-arey-angenh renh.” ");
INSERT INTO aly_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Artwa ingwer-rnemel Peter renh ilek, “Inngarl nga alhenh Jesus-angkwarr apmer Galilee-ampeny. Galilee-areny-apeny nga angkeyelan.” ");
INSERT INTO aly_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Peter irrtywerremel ilelhek arrpemarl, “Ingkartel arem, arraty inngay ayeng angkem. Ayeng akwerrp, atha renh iterl-arey-angenh.” Peter-el renh tywek-tywek irrwey awek rarl ingwepenh arlkey-ayntek. ");
INSERT INTO aly_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Peter ra iterl-arek, renharl Jesus-el arrwekel ilek-angkwarr, “Tywek-tywek irrwey ingwepenh arlkey-ayntekerr-awaty nga irrtywerremel irrpety-inger ilelhem.” Kel Peter alpek. Rap artewentyel artnenh-anem. ");
INSERT INTO aly_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ingwepenh Atyetyart tyaty-areny-rnem-then, atyetyart apmer-areny-rnem-then, rernem akarrirrek angkerretyek, Jesus renh atwetyek. ");
INSERT INTO aly_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Rernem-anem renh arertnemel, Atyetyart Pilate-warl atnwenhek. ");
INSERT INTO aly_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas-el kel ahelengkw-rnem-warl Jesus renh ahayiwek. Ranem ywarn iterrek amperrngirremel. Rap angkepirrek tyaty-areny atyetyart ilkwernem-warl, Jew-rnem-kenh atyetyart-rnem-warl alhek-anem. Ra ngkwelty-rnem atyetyart tyaty-areny-rnem angkep antheynetyek-arrpantey. ");
INSERT INTO aly_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ranem angkek nyerrirremel, “Ayeng-anem Akngey-angkwarr apmwelhilek, artwa mwerr innga atha ahayiwek ahelengkw-rnem-warl. Artwa alyelk ra apmwel-areth mpwarey-angenh.” Rernem renh ilek, “Ntwap renh ahayiwek anwekantherr-warl. Anantherr arlarl.” ");
INSERT INTO aly_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas ran ngkwelty-rnem tyaty ilkwa kwen-warl iwek-penh, ranem ament ipmek aynterrarrewelhek. ");
INSERT INTO aly_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tyaty-areny atyetyart ilkwernemel ngkwelty renh akwetyemel, angkerrenh, “Artwa atwetyekarl anthekarl. Nthakenh ngkwelty nhenh angkep akwerney-angenh tyaty-warl.” ");
INSERT INTO aly_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Rernem angkerrek-anem, apmer aterterr renh ingwer-itwek payemeletyek. Rernem iterrenh, awenng angernetyek, alethang arrewaly akwernetyek. Artwa ahern-penh mpwarey-angker anyent ra apmer tharlemilek ikwer-rnem. ");
INSERT INTO aly_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Alakenh-they aley rernem “Apmer Arrkngangketyarr” itneweyel-antey. ");
INSERT INTO aly_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jeremiah-kenh pip alakenh arraty innganem aynteyel, rarl arrwekel ilenh-angkwarr-antey: “Ngkwelty 30-el payemeletyek, man rernem Israel-kenh artwa anyentek payemeletyek. ");
INSERT INTO aly_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Rernem aterterr renh-anem payemelek, atnthepenh arnwarney-angker-kenh, Akngeyel renh-rnem ilanthek-angkwarr-antey.” ");
INSERT INTO aly_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Rernem Jesus renh atnwenhek Atyetyart Pilate ikwer-warl. Pilate-el Jesus renh ayernek, “Nganang Atyetyart ilkwa Jew-rnem-kenh, ngay?” “Ya, alakenh nga angkeyel.” Jesus-el renh tyernek. ");
INSERT INTO aly_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tyaty-areny atyetyart ilkwel-rnem Jesus renh ayntarrp-ilek, ra irrtywerremel ilelhenty-arrpantey. Jesus akater-anem rtnenh, tyerney-angenh. ");
INSERT INTO aly_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilate-el Jesus renh ayernek arrpemarl, “Ngenharl rernem ayntarrp-ileyel, nthakenh ngan angkem?” ");
INSERT INTO aly_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesus akater-anem rtnenh, tyerney-angenh. Atyetyart ra ikwer apatek-anem, rarl akater-anem rtnenhek. ");
INSERT INTO aly_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Aherrety arrpanenhel, amern tyenkerr arlkwenh apmelerr-angkwarr, Pilate-el artwa anyent tyayl-they tyarlewenh. ");
INSERT INTO aly_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Artwa Barabbas artwa apmwa innga tyayl-itwek anenh. ");
INSERT INTO aly_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Rernem ingkerrenh akarrirrek, Pilate-el renh-rnem ayernek, “Angwenh athan tyarlewem tyayl-theyan? Barabbas apek? Jesus apek, rernem renh itneweyel Christ, Akngeyelarl arrwekel ilek, renh thwenetyek ahern nhenh-warl ingkerrenh itethiletyek.” ");
INSERT INTO aly_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilate-arl akalty, atyetyart-rnem Jesus-kety arlkarirrenh. ");
INSERT INTO aly_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilate-el renh tyatyemilenh-angkwarr-antey, Pilate-kenh anewikwel angka thwenek ikwer-warl, “Artwa alyelk yanh ipmay! Ayeng artwa yanhek ilkelhey-angenh, renh atwetyek, altyerr apmwa atha arek-penh.” ");
INSERT INTO aly_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tyaty-areny atyetyart ingwer-rnem-then rernem renh-rnem ingkerrenh ilek, “Arrantherr Pilate ilenherr-arey, ra artwa Barabbas tyayl-they tyarlewetyek, Jesus-ant atwetyek.” ");
INSERT INTO aly_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilate-el renh-rnem ayernek arrpemarl, “Artwa nthenh-apeny atha tyarleweman?” Rernem arlkek, “Barabbas renhant tyarlewa!” ");
INSERT INTO aly_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilate-el renh-rnem ayernek arrpemarl, “Nthakenh atha Jesus renh ilem? Rernem renh Christ antweyel Akngeyelarl thwenek?” Rernem arlkek artewentyel, “Renh arwerl iylpeyl-atherr-warl atanthenherr-arey, renh atwetyek!” ");
INSERT INTO aly_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilate-el renh-rnem ayernek, “Ilekek atwetyek? Ran arlarl.” Rernem artewentyel innga arlkek, “Renh arwerl iylpeyl-atherr-warl atanthenherr-arey, renh atwetyek!” ");
INSERT INTO aly_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Atyetyart Pilate ra arek, ingkerrenh ahelirrenhant-anem. Kwatyel iltyatherr lhewelhek, anngetherr ikwer-rnem-itwek, “Arrantherrant ilkelheyel renh atwetyek. Ayeng arlarl!” ");
INSERT INTO aly_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Rernem renh ilek, “Kel menty anwenhantherr ayntarrp-ilem ingkerrenhel, renh ipmek atwenty-penh, ingkern-penh-rnem-then ayntarrp-ilem arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilate-el Barabbas renh tyarlewek, tyayl kwen-they. Pilate-el ahelengkw-rnem ilek, rernem Jesus renh whip-el atwayntetyek arwerl iylpeyl-atherr-warl atanthetyek. ");
INSERT INTO aly_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ahelengkwel-rnem Jesus renh atnwenhek warl ilkwa rlterrk-warl, warl Atyetyart ilkwa Rome-areny-kenh-warl. Ahelengkw ingwer-rnem ikwer-rnem-warl akarrirrek. ");
INSERT INTO aly_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Rernem arnkwa lhelek, ikwer-they, kwet arlpenty rnter-rnter-warl-anem renh akwernek. ");
INSERT INTO aly_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Rernem mwekart-apeny mpwarek, arreylp-angketyarr atyetyartek-arrpantey, Jesus akapwert-warl arrernemel, arwerl iltya arraty-warl arrernemel. Rernem renh arrkentelhilemel ilek kwenirremel, “Nganap Atyetyart ilkwa Jew-rnem-kenh.” ");
INSERT INTO aly_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Rernem apelh ikwer-warl iwek, akapwert-anem renh arwerlel atwemel. ");
INSERT INTO aly_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Rernem irrpelthirremel kwanthenh-penh, rernem kwet lhelek, arnkwa ikwerenh-warl-anem akwernemel. Rernem renh atnwenhek, rernem renh atanthetyek, arwerl iylpeyl-atherr-warl. ");
INSERT INTO aly_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Artwa anyent, itnan Simon apmer Cyrene-areny. Ahelengkw-rnemel arwerl iylpeyl-atherr-anem arrernek Simon ikwer-warl, ra arwerl renh aylpwer-akngeyn-ayntetyek. Simon-el arwerl iylpeyl-atherr iytarr-akngeynenh. ");
INSERT INTO aly_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ahelengkw-rnemel Jesus renh apwert ilkwewarl atnwenhek, apwert itnan Golgotha, apwert ngkwern akarnng-apeny. ");
INSERT INTO aly_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ahelengkw-rnemel arwerl mwerr-angker alperr-penh ngkwarl wayn-warl thelek, Jesus renh anthemel, ra irrwampenty awelhekerr, renh arlelpiletyek, renh atanthenty arwerl iylpeyl-atherrek. Rap arrkernek-anem. Jesus-el ngkwarl menty arek, antywey-angenh. ");
INSERT INTO aly_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ahelengkwel-rnem arnkwa ikwerenh lhelek, ahern-warl iwemel. Rernem Jesus renh arwerl iylpeyl-atherr-warl atanthek. Ahelengkwel-rnem arrkenirrek arnkwa Jesus-kenhek, antengiletyek. ");
INSERT INTO aly_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kel rernem renh arenh-anem, arrernelhemel. ");
INSERT INTO aly_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ahelengkw-rnemel pip arrernek arwerl iylpeyl-atherr-warl angka ikwer-rnem-kenh-akert, “Nhanyem Atyetyart Jew-rnem-kenh.” ");
INSERT INTO aly_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Artwa apmwatherr rernem arrernek Jesus-angkwarr ilwetyek. Artwa apmwatherr rernem rnkernek, akwerrant-atherr, Jesus ampepekilemel. ");
INSERT INTO aly_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Akngerr angkepelarreng alhenh, Jesus ikwer irrpelthirrerl-anemel, ");
INSERT INTO aly_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Rernem arlkek, “Weth ntwa anwernenhantherr ilek, ntwarl tyaty ilkwa Jew-rnem-kenh atakenty-penhel, ntwa tyaty ilkwa ingwer-anemarl artetyek akwel. Ngan arlertek ilkwakert akwel. Nga ament-anem itethelhila! Atwarra arwerl iylpeyl-atherr-they!” ");
INSERT INTO aly_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Atyetyart ilkwa tyaty-areny-rnem-then atyetyart ingwer-rnem-then Moses-kenh-rnem-then, rernem ikwer irrpelthirrenh. Rernem arrkent ikwer angkerrenh, ");
INSERT INTO aly_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ran artwa ingkerrenh arntety-penh itethiley-angker, ranem ament-anem itethelhiley! Ra ament itethelhilenty, anwantherr ingkerrenhelarlap iterl-areman, rap Atyetyart ilkwa Jew-rnem-kenharl aneman. ");
INSERT INTO aly_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ra Akngey tnakeyel. Ra ilelhek, ra Akngey-kenh alerikw akwel. Akngeyelant renh itethilemer.” ");
INSERT INTO aly_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Artwa apmwa weth atherrel Jesus renh arrkentelhilenh arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ingkeny arlta ampepel ingwerrerl-alhek, atwerrpek-atwety. ");
INSERT INTO aly_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jesus-el Akngey renh ayernek, “Akngey atyenh, Akngey atyenh, ilek-kety ntwa ayenh menty arek?” ");
INSERT INTO aly_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ingwer-rnem Jesus-arrangarr rtnenherrenh. Rernem Jesus renh awenh, angkemel, “Jesus ra arlkeyel Elijah ikwer. Elijah Akngey-kenh angkakert arrwekeleny ran.” ");
INSERT INTO aly_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Artwa anyentel ngkwarl wayn-warl antywer renh apelyilek, Jesus renh arwerl arlpenty-they antywetyek. ");
INSERT INTO aly_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ingwer-rnem angkerrenh, “Anwantherr mpwelhey Elijah ikwer-warl apetyetyek, renh arwerl iylpeyl-atherr-they tyarlewenty anwantherr aretyek.” ");
INSERT INTO aly_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kel Jesus arlkek, ilwemel. ");
INSERT INTO aly_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Rag arlpenty Jew-kenh tyaty ilkwitwek ilterrelhek, irrwerl-they, kwenek-atwety. Ahern akngenherl-akngenhelhilek. Apwert-rnem akelhemel ngkweltyirremel. ");
INSERT INTO aly_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Awenng-rnem altywerirrek, arrewaly-rnem itethirrek, Ingkart-angkwarr apenteyel-rnemarl. ");
INSERT INTO aly_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Rernem awenng-they akemirrek. Ra itethirrek-penh, rernem Jerusalem-warl alhek. Rernem aremirrek, akngerr ingwer-rnemek, ");
INSERT INTO aly_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Atyetyart ahelengkw-rnem-kenh ahelengkw-rnem-then rernem arek. Rernem ahern akngelhenh-akngelhenhek awelhek. Rernem aterirrek angkerrenh, “Jesus ranap Akngey-kenh Alerikw inngarl ilenhey.” ");
INSERT INTO aly_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Arelh akngerr rernem akarrirrek apmer Galilee-they, renh arntarnt-aretyek, Jesus arwerl iylpeyl-atherrek ilwey-alenty. Rernem Galilee-they apetyek. Rernem arleng-they arntarnt-arelhenh. ");
INSERT INTO aly_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mary Magdala-areny, Mary ingwer-then, James-then Joseph-then, ikwer-atherrenh amikw, ingwer, James-then John-kenh amikw, rernem ikwer-rnem-itwel rtnenh. James-then John-then Zebedee-kenh alerikw-atherr anenh. ");
INSERT INTO aly_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Atwerrp, artwa man-angketyarr apetyek itnan Joseph, artwa mwerr Ingkart-areny apmer ingwer-areny itnan Arimathea. ");
INSERT INTO aly_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Joseph-el Pilate renh ayernek, arrewalyek. Pilate-el ingwer ilek, ra arrewaly renh arwerl iylpeyl-atherr-they atwarrelhiletyek, Joseph renh anthetyek. ");
INSERT INTO aly_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Arnkwa mwerrel-anem ataperrelek. ");
INSERT INTO aly_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Joseph-kenhel-rnem arrewaly renh intey awenng-warl akwernek. Intey awenng renh ilkwilek awank-akerr, arrewaly-anem intey-warl akwerney-alenty, apwert ilkwa arriw-itwek arrkngertiwemel. Kel ra alpek-anem. ");
INSERT INTO aly_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mary Magdala-areny-then, Mary ingwer-then ratherr intey akarelhilenh. ");
INSERT INTO aly_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ingwepenh arlta ltyerrey-angker ikwerel, tyaty-areny atyetyart ilkwernem-then artwa Pharisee-rnem-then Pilate-warl akarrirrek. ");
INSERT INTO aly_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Rernem ikwer angkek, “Jesus ra irrtywerremel ikwer-rnem ilelhenty-arrpantey, ingwa atherr-penh ipmepenh itethirremel apey-alpetyek-arrpantey. ");
INSERT INTO aly_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Artwernem irrpety thwenay, arriw ilenh akarerl-ayntetyek arlta irrpetyek-atwety, kwertengerl ikwerenh-rnemel ipma renh tyerremel akngekerr, ingwer-rnem-anem ilekerr, itethirrenty-arrpantey.” ");
INSERT INTO aly_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilate-el renh-rnem ilek, “Ahelengkw-rnem atnwenha, rernem awenng renh akarerl-ayntetyek.” ");
INSERT INTO aly_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Atyetyart rernem apwert renh mwantyel akentek rlterrk, ahelengkw renh-rnem-anem rnkernek, awenng renh akarerl-ayntetyek. ");
INSERT INTO aly_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Arlta ltyerrey-angker Ingkeny tyerrelhey-alentyel, Mary Magdala-areny Mary ingwer-then alhek, intey renh aretyek. ");
INSERT INTO aly_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ikwer-penh ahern akngelhekarl ratherr awek, Ingkart-kenh angel ikwer-atherr-warl apetyek irrwerl-they. Ranem apwert renh atwepert-iwek, ranem apwert ikwer-itwek anenh. ");
INSERT INTO aly_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Angel ranem lyenentyel-apeny arrtyernek, arnkwan ikwerenh arlter innga. ");
INSERT INTO aly_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ahelengkw-rnem aterirremel ahern-warl aytnek, ipmapeny-anem ayntenh. ");
INSERT INTO aly_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Angel angkek ikwer-atherr, “Aterirrey-angenh anenherr-atherr! Atha mpwelanth iterl-areyel. Mpwelanth Jesus-ek nthweyel, arwerl ilpeyl-atherr-warl atanthekek. ");
INSERT INTO aly_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ra nhenh aney-angenh-anem. Akngeyel renh itethilek, weth rarl ingkerrenhek arrwekel ilelhek-angkwarr. Apetyenherr-atherr, intey renh aretyek, rarl ayntenh. ");
INSERT INTO aly_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Alhenherr-atherr, kwertengerl ikwerenh-rnem iletyek, rarl ipmepenh itethirrek. Ra Galilee-warl alhek arrwekel, arrantherr alhetyek renh arey-alhetyek. Alakenh-anyem ayeng angkakert apetyek, mpwelenhanth atha ilek.” ");
INSERT INTO aly_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ratherr aterirremel-antey anterrek inkwerelhemel, kwertengerl-rnem iletyek. ");
INSERT INTO aly_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Jesus-el renh-atherr rlwatek, ratherr-anem kwenirremel arrernelhek ingkety atherr anterrkwek, ikwer inkwerelhek. ");
INSERT INTO aly_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesus angkek, “Aterirrey-angenh, kwertengerl atyenh-rnem ilenherr-arey, rernem ayenh Galilee ikwer-itwek arey-alhetyek.” ");
INSERT INTO aly_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ratherr alhenharl-antey ahelengkw-rnem tern ilkwewarl alhek. Rernem tyaty-areny atyetyart-rnemek angka ilek. ");
INSERT INTO aly_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Atyetyart tyaty-areny-rnem-then rernem angkerrenh, ahelengkw-rnem payemeletyek rernem menty akater anayntetyek, ingwer-rnemek angka Jesus-akert iley-angenh, rarl itethirrek. Atyetyart ingwer-rnem angkerrenh arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Ingwer-rnem ilayntenherr-arey, kwertengerl weth-rnemelarl arrewaly tyerremel irrtyert akngek, awenng-they. Anwantherr arnkwa ayntenharl-antey. ");
INSERT INTO aly_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pilate ra angka awenty, mwerrarl anwantherr renh ilem, nthakenh arrenhantherr ayntarrp-ileyangarl.” ");
INSERT INTO aly_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Rernem ahelengkw-rnem man payemelek. Rernem-anem akater anenh. Apmer Judea-areny-rnem rernem arraty iterl-arey-angenh-antey. ");
INSERT INTO aly_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kwertengerl 11-pel alhek Galilee-warl, apwert ilkwewarl, Jesus-el kel renh-rnem ilek arrwekel, renh rlwatetyek. ");
INSERT INTO aly_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Rernem renh arek, ikwer inkwerelhemel. Ingwer-rnem arrangkwarl, ikwer irrpelthirrenh. ");
INSERT INTO aly_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesus ikwer-rnem-warl apetyek angkemel, “Akngeyel ayenh arrernek, alker-areny-rnemek, ahern-areny-rnemek, Ingkart ingkerrenhek anetyek. ");
INSERT INTO aly_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Apmer arrpanenh-warl alhenherr-arey, ingkerrenh akalty-anthetyek, rernem kwertengerl atyeng-anem anayntetyek. Baptise-emelenherr-arey renh-rnem itna Akngeyek, Alerek, Itnweng Rlwartek angkemel. ");
INSERT INTO aly_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Akalty-anthenherr-arey renh-rnem, angka atyenh ingkerrenh ywerreyek-atwety. Ayeng arrekantherr-itwek aneyenh, ahern nhenh ywerreyek-atwety.” ");
INSERT INTO aly_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nhanyeman angka mwerr-angker Jesus Christ-ek, Akngey-kenh Alerikw. ");
INSERT INTO aly_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Akngey-kenh angkakert artwa Isaiah anenh. Awank-akerr Isaiah-el ingkwernek Akngey-kenh angka pip-warl. Akngey alakenh-anyem angkek, “Angka atyenh-akert atha thwenem ikwer-rnem-warl, rernem iterl-aretyek Ingkartarl ingkern-they apetyem.” ");
INSERT INTO aly_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Angkakert irrkaty ra arlkeyel apmer arlpawel, “Anwantherr iterrey mwerr-angkwarr, Ingkart ikwer mpwelhetyek, rarl apetyemek.” ");
INSERT INTO aly_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Alakenh-anyem, John, Baptise-emeley-angker apmer arlpaw-itwel anenh. Arnkwan ikwerenh John-kenh alta kamwerl-penh, pilt yenp-penh-akert. Ra intelty-rnem arlkwenh, ngkwarl arwengalker-then. Akngerr-anem apmer arrpanenh-they, apmer Judea-ampenyel, John-warl akarrirrek, tawen Jerusalem-areny-rnem-then. Rernem ilelhek John-ek, rernemarl apmwakert anenh. John angkek ingkerrenhek, “Anwantherr Akngey-angkwarrant-anem apentetyek. Angkepirrenh-arey apmwekety, Akngey-warl. Atha arrenhantherr baptise-emilem. Akngeyel apmwa arrekantherrety iwetyek.” Ra renh-rnem ingkerrenh baptise-emilek, Jordan Ilpayek. ");
INSERT INTO aly_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","John ilelhek ikwer-rnem, “Artwa ingweran atyeng-they rlterrk inngan apetyem ingkern-theyarl. Ayeng nthakenh kwenirrey-angenh pwet ikwerenh lhelhetyek. Ran Atyetyart ilkwa anwekantherrenh, ayengan rlterrk-wenyarl. ");
INSERT INTO aly_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Atha arrwekel arrenhantherrenh baptise-emilem kwatyelant. Rarl apetyem inngan anwekantherr-warl. Ra Itnweng Rlwart ikwerenh arrernetyek anwekantherr-warl.” ");
INSERT INTO aly_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ikwer-penhan Jesus-anem Jordan Ilpay-warl, Nazareth-they apmer Galilee-ampeny-warl apetyek. John-el renh kwatyel baptise-emilek. ");
INSERT INTO aly_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesus tyerrelhemel kwaty-they, rap arek kwenpay-rnem amentirrenty. Ikwer-they, rap arek Itnweng Rlwartarl apetyek irrwerl-they, ikwer-warl, thip-apeny. ");
INSERT INTO aly_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Akngey-kenh angka irrwerl-itwek ra awek, rarl angkek, “Ngarl alerey atyenh. Ayeng ngkweng inkwerelheyel.” ");
INSERT INTO aly_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ikwer-they, Akngey-kenh Itnwengel thwenek Jesus renh iparrp-antey aherrety-warl. ");
INSERT INTO aly_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Alkent anyentel ra anenh, apmer arlpawel. Arrenty ikwer-warl apetyek, Jesus renh arrkernetyek rlterrkek, rarl ikwer-angkwarr awelhetyek. Jesus apmer atnwenth ateralth-angketyarrel anenh. Angel-rnemel renh arntarnt-arenh. ");
INSERT INTO aly_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Artwa ahelengkwel John anterrkwek. Ra renh tyayl-warl akwernek. Ikwer-they Jesus apmer Galilee-warl alhek, Akngey-kenh angka mwerr-akert, akalty-anthetyek. ");
INSERT INTO aly_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jesus-el renh-rnem ilek, “Kel, Akngey ikwerenh-rnemek Atyetyart alkenh anetyek. Angka mwerr nhenh awemel, arrantherr apmwekety angkepirrenhey-alpenherr-arey Akngey-angkwarrant apentetyek.” ");
INSERT INTO aly_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesus alhek kwaty ilkwa impalth-angkwarr, apmer itnan Galilee. Ra awayenheng-atherr Simon Andrew arek, aker irrpeng anterrkwenherl-anenty, netting-akertel. ");
INSERT INTO aly_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesus angkek, “Atyeng-angkwarr apetyenherr-atherr. Atha akaltyiley mpwelenh, akngerr-anem ikngwerl-alpenherr-atherr, Akngey-warl.” ");
INSERT INTO aly_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Awayenhengel-atherr netting iwerl-alhek, Jesus-anem apentek. ");
INSERT INTO aly_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesus-el arey-alhek Zebedee-kenh alerikw-atherr, James, John, ratherrarl netting arnwarnenh rtnwitwek, aker irrpengek-arelh. ");
INSERT INTO aly_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesus-el renh-atherr ilek, “Atyeng-angkwarr apetyenherr-atherr.” Zebedee, aynikw ikwer-atherrenh ratherr iwerl-alhek rtnwitwek-antey, warrkenh-rnem-akert. ");
INSERT INTO aly_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesus kwertengerl ikwerenh-rnem-akert tawen Capernaum-warl alhek. Jesus alhek Jew-rnemarl warl kwenel angkerrenh-warl Saturday-el, arlta anyent impenel. Ra renh-rnem akalty-anthek. ");
INSERT INTO aly_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Rernem Jesus renh awemel, rernem apateyelpek, rarl angka arraty rlterrk innga ilek, alhewer-antey. Rernem angkerrenh “Akalty-anthenh-anthenh nhel-rnem anwenhantherr apmwel-areth akalty-antheyel. Rernem nyerrantarl irreyel. Rernem akwerrparl, alhewer akalty anthey-angenh.” ");
INSERT INTO aly_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Artwa arrenty-akert aylpenhek warl kwenel Jew-rnemarl angkerrenh-warl. Ra artewentyel arlkek, ");
INSERT INTO aly_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jesus Nazareth-areny, nga ilekek apetyek? Ntwa atwetyek anwernenhantherrenh irrentetyek apmer nhethey? Ntwa anwernenhantherrenh ywerrelhilemel atwetyek? Atha ngenh iterl-areyel, ngan Akngey-kenh angkakert impenarl apetyek!” ");
INSERT INTO aly_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesus angkek arrenty ikwer-warl, “Nga akater ana! Tyerrelha ikwer-they!” ");
INSERT INTO aly_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Artwa ra arwengkirrek, arrenty-kety. Arrenty ra artewentyel arlkek, artwa ikwer-they tyerrelhemel. ");
INSERT INTO aly_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Rernem apatemel arek. Ingkerrenh rernem angkerrenh, “Artwa nhanyem ngangker rlterrk-akertan, arrenty artwa arntety-they iwey-angkeran! Artwa nhanyem akalty inngan! Arrenty-rnem awelheyel Jesus ikwerant.” ");
INSERT INTO aly_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ingkerrenhel awek apmer arrpanenhel Galilee-ampenyel Jesus-elarl arrenty irrentek. ");
INSERT INTO aly_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jew-rnemarl warl kwenel angkerrenh-they, Jesus-el ikngwerl-alhek artwa atherr James-then John-then. Artwa 5-pel, Simon-then Andrew-then ikwer-atherrenh apmer-warl alhek. ");
INSERT INTO aly_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Jesus-el awek arelh ampwa Simon-kenh arntety rwenparl ayntenh. ");
INSERT INTO aly_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesus alhek ikwer-warl, renh itep anterrkwemel, akwentelhilek. Ra renh mwerrilek. Arelh ra amern anthek ingkerrenhek. ");
INSERT INTO aly_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Atwemengkel, ingwer-rnemel atnwenhey-alhek arntety-rnem-then arrenty-akert-rnem-then Jesus ikwer-warl. ");
INSERT INTO aly_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ingkerrenh tawen Capernaum-areny-rnem akarrirrek warl arriw-warl, rernem Jesus renh aretyek. ");
INSERT INTO aly_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesus-el arntety akngerr mwerrilek, arrenty-rnem irrentek, ingwer-rnem-they. Arrenty-rnemel kel iterl-arek Jesus rarl Alerikw Akngey-kenh apetyek. Arrenty-rnem Jesus-ek angkey-angenh-anem. Jesus-el kel renh-rnem akatelhilek. ");
INSERT INTO aly_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jesus ingwepenh-antey warl-they alhek, ra ament-areny Akngey-warl angketyek. ");
INSERT INTO aly_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon ikwerenh-rnem-akert alhek nthwetyek ikwer. ");
INSERT INTO aly_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Rernem renh arey-alhek. Simon-el renh ilek, “Ingkerrenh ngkweng nthweyel!” ");
INSERT INTO aly_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesus angkek, “Ayeng ahern nhenh-warl apetyek, Akngey-kenh angkakert apmer arrpanenhek atha iletyek.” ");
INSERT INTO aly_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ra alhek apmer arrpanenh-warl, apmer Galilee-ampenyel. Ra arrenty-rnem irrentek, ingkerrenh, ikwer-rnem-they. Ra akalty-anthek Jew-rnem ingkerrenh, arraty-angkwarr renh apent-ayntetyek. ");
INSERT INTO aly_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Artwa tywen-angketyarr apetyek Jesus-warl. Ra kwenirrenh Jesus-itwel ampwethel alernelhemel. Ra angkek, “Ngan rlterrk inngan, mwerriley-angker, ntwa ayenh mwerriletyek. Nga ilkelhentyarl apekan, ntwa ayenh mwerrila!” ");
INSERT INTO aly_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus amperrngirrek ikwer. Ra itep arrernek ikwer-warl. Ra angkek, “Ayeng ilkelheyel, ngenh atha mwerriletyek. Kel, nga mwerr-anem.” ");
INSERT INTO aly_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tywen ikwer-they ywerrek kanper-antey. Ra mwerr-anem irrek. ");
INSERT INTO aly_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesus-el artwa renh ilek, ");
INSERT INTO aly_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Akater-anem aney-alpa! Atyetyart tyaty ilkwa Jew-rnem-kenh-arenyek nga anyentekant ilelhey-alpa, ra ngenh mwerr-anem aretyek. Ntwa aker Atyetyart-warl antha! Moses-kenh angka aynteyel aker Atyetyartek anthetyek, ingkerrenhel ngenh aretyek, rernem iterretyek ngarl mwerrirrek-anem, ntwarl aker Atyetyart-warl akngek.” ");
INSERT INTO aly_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Artwa ra akngerrek-anem ilelhey-alpek, renharl mwerrilek Jesus-el. Jesus tawen arrpanenh-warl alhey-angenh-antey. Tawen-areny-rnem-ketyan Jesus anper-alhenh, rernem renh arlkarewerl-anekerr. Akngerr ingwer-rnem-anem apetyek Jesus-warl, apmer arrpanenh-they. ");
INSERT INTO aly_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Jesus angkep-anem apetyek apmer Capernaum-warl, ra apmer anyentel-antey anenh. Ingkerrenhel awek Jesus ra apmerelarl aney-alpek. ");
INSERT INTO aly_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Rernemap akarrirrenhey-alhek-anem. Warl kwenan arrkngelek akngerrel, ingwer-rneman rtnenherrenh arriwelarl, Jesus-kenh angka awetyek. Jesus-el ilenh Akngey-kenh angka ikwer-rnem. ");
INSERT INTO aly_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Artwa 4-pelelan akngey-alhek artwa lerrp anyent pantyel Jesus-warl. ");
INSERT INTO aly_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Akngerrelarl arrkngelek-kety iwerran kwen aylpekerran, rernem apatenh akethel-antey. Rernemap iterrek, rernem nganetyek irrwerl-anem. Rernemap warl renh irrwerl altywerilek, rernemap artwa arntety renh pantyinp rwepel atwarrelhilek, ingkerrenharl Jesus-itwel rtnenherrenh-warl. ");
INSERT INTO aly_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesus-elan iterl-arek kanper-antey, rernemarl renh iterl-arek mwerriley-angker. Ran artwa arntety renh ilek, “Apmwan atha ngkwengety iwem.” ");
INSERT INTO aly_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Artwa Pharisee-el-rnem, artwa akalty-anthenh-anthenh-rnem-then Jesus renh iylpelant awenh. Rernem angkerrenh, ");
INSERT INTO aly_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ilek-arrpantey ran nhenh angkeyel? Ran nhenhey apmwel-areth angkeyel Akngey-arrpantey. Akngey anyentelant apmwan iwem!” ");
INSERT INTO aly_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesus-el iterl-arek artwa renh-rnem, rernemarl ikwer irrpelthirremel angkerrenh, “Ran nhey nthakenh apmwa iwey-angenhan arntety-they.” Ra renh-rnem ilek, “Arrantherran angkerreyel nthakenh atha apmwa iwey-angenh arntety-they. Arrantherran apmwel-aretharl angkerreyel, atyeng irrpelthirremel! ");
INSERT INTO aly_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Akngeyelan ayenh rlterrkilek, artwa arntety mwerriletyek, apmwa ikwer-they iwetyek. Nthakenh atha renh akwentelhilemel thwenem, ra apmer-warl alpetyek, panty ikwerenh inerl-alhemel. Awelhenh-arey atyeng! Atha Akngey-kenh angka arrekantherr iletyek. Ayengan Akngey-kenh Artwa Impen. Akngeyel ayenh thwenek rlterrk-akert, apmer ingkerrenh-warl rlterrk innga. Atha apmwa ingkerrenh-they iwey-angker, Akngeyelarl ayenh rlterrkilek.” Jesus angkek artwa arntetyek, ");
INSERT INTO aly_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Akwenterl-alha, panty ngkwenh inerl-alhemel, apmer-warl alpa.” ");
INSERT INTO aly_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Artwa arntety-penh akwenterl-alhek, panty inerl-alhek. Alpek-anem ra apmer-warl, mwerr-anem. Akngerrel intwarek apatemel arntety rarl apmer-warl alpek. Rernem Akngeyek-anem inkwerelhek. Rernemap angkek-anem, “Ngay! Akngey inngarl yanhan! Artwa anper inngarl ilenhan! Mwerriley-angker inngarlap ran nhenhey! Aleyant anwantherr arek alakenh-anyem mwerriley-angker!” ");
INSERT INTO aly_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesus alhek Galilee kwaty ilkwa impalth-warl. Akngerr ikwer-warl apetyek, ra renh-rnem Akngey-kenh angkek akaltyilek. ");
INSERT INTO aly_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ikwer-penhan ra alhek. Ra Levi, Alphaeus-kenh alerikw arey-alhek, ngkweltyarl ingkerrenh-they akarrilenh, man kapment-warl anthetyek. Irrtyert-awarrarl ra anenh. Jesus angkek ikwer, “Atyeng-angkwarr apetya!” Levi warrk ikwerenh ipmerl-alhek, ra Jesus-angkwarrant-anem alhek. ");
INSERT INTO aly_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ratherr alhek Levi-kenh apmer-warl, amern arlkwetyek. Irrtyert-awarr ingwer-rnem Levi-kenh apmer-warl akarrirrek. Jew-rnem renh-rnem arlkarirrenh manarl rernem ingkerrenh-kety irrtyertewenh, kapment-warl anthetyek. Apmwa ingwer-rnem Levi-kenh apmer-warl akarrirrek arrpemarl, Jesus renh awetyek. ");
INSERT INTO aly_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pharisee-el-rnem Jesus arek apmwernem-itwekarl amern arlkwek kwertengerlarl ikwerenh-rnem-akertel. Pharisee-el-rnem ayernek Jesus-kenh kwertengerl-rnem, “Ilekekarl arrantherr amern arlkweyel apmwernem-itwekarl? Anwantherr amern arlkwey-angenh apmwa yanh-rnem-itwek.” ");
INSERT INTO aly_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesus-el awek Pharisee-el-rnemarl angkek kwertengerl ikwerenh-rnemek. Ra angkek, “Arntety-wenyarl ingwer-rnem ngangker-akertel mwerriletyek arlkwentey-angenharl aneyel. Ayengarl ran apmwa atha iwey-angkeran, mwerriley-angker. Ingwer-rnem iterl-arelhek rernem mwerr-angkwarr-arrpanteyarl aneyel, atyeng-angkwarr-wenyarl. Atha renh-rnem nthakenh apmwa iwey-angenh ikwer-rnem-they, rernem arlkwentey-angenh apmwa ikwer-rnem-they atha iwetyek.” ");
INSERT INTO aly_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jew-rnem-kenh arlta anyent impenel, Pharisee-el-rnem menty amern arek, arlkwey-angenh, John-kenh kwertengerl-rnem-then. Rernem Akngeyekant iterrenh. Ingwer-rnemel Jesus renh ayernek, “Nthakenharl amern arlkweyel kwertengerl ngkwenh-rnem arlta lyertan arrangkwarl amern arlkwetyek?” Pharisee-rnem John-kenh kwertengerl-rnem-then, rernem arraty-angkwarr apenteyel, arlta nhel amern arlkwetyek, arrangkwarl. ");
INSERT INTO aly_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesus angkek, “Artwa anyent itengirrem-angkwarr ingkerrenhel ikwer-angkwarr tyenkerr arlkwetyek, inkwerelhemel. Alakenh-anyem, kwertengerl atyenhel-rnem amern arlkwetyek arrpemarl, atyeng-angkwarr. ");
INSERT INTO aly_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ikwer-penhan rarl apmer-warl alpek, tyenkerr arlkwey-angenh arrangkw-antey, Akngeyekant iterremel. Alakenh-anyem ayeng alpeyenh Ingkart Akngey-warl. Kwertengerl atyenhel-rnem amern arlkwey-angenh, Akngey ikwerant iterremel aneyenh.” ");
INSERT INTO aly_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Arnkwa apmwamwamel-rnem nthakenh anwantherr pweytiley-angenh arnkwa mwerr-warl, renh arnwarnetyek. Arnkwa apmwamwam altherrkirrey-angker arrpemarl. Anwantherr menty arnkwa apmwamwam iwey, arnkwa mwerran atnyenemel.” ");
INSERT INTO aly_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jesus-el renh-rnem ilek, “Anwantherr theley-angenh ngkwarl wayn lyerteny arranty apmwamwam-warl. Arranty apmwamwam altherrkirremarl. Arranty-they ngkwarl wayn thelelhekerr ingkerrenh-antey, rwenpirrentyan. Arranty apmwanemarl. Anwantherr ngkwarl wayn lyertenyan arranty mwerr-warl-anem theletyek. Arrantherr arranty apmwamwam ipmem-apeny, arrantherr arnkwa apmwamwam iwem-apeny, arrantherr Pharisee-rnem-kenh angka ipmenherr-arey, atyengant-anem awelhenherr-arey.” ");
INSERT INTO aly_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Arlta anyent impen Saturday-el, Jesus alhek kwertengerl ikwerenh-rnem-akert amern weyt-angketyarr-angkwarr. Kwertengerl ikwerenh-rnemel amern weyt inenhek, angayakwirrekerr. ");
INSERT INTO aly_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pharisee-el-rnem Jesus renh iltek, “Angka anwekantherrenh aynteyel, arlta nhelan nthakenh warrkirrey-angenh. Kwertengerl ngkwenhel-rnem amern weytarl inenhey-alhek Saturday-el, arlta anyent impenel. Rernemap warrkirrenhey-alhek-apeny. Apmwel-aretharl amern weytan inenhey-alhek law anwekantherrenh arlta anyent impen nhel law-arl ntwa anwekantherrenh apmwelenhey-alhek.” ");
INSERT INTO aly_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesus angkek artwa Pharisee-rnemek, “Mwerr amern anwantherr inenhey-alhek angayakwirrekerr. Arrantherrap iterl-aremer ingwer-rnemarl awank amern inek-apeny arrpemarl, David-kenhel-rnem.” ");
INSERT INTO aly_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Rernem Akngey-kenh warl impen-warl aylpek. Abiathar Atyetyart anenh warl ilkwel. Rernem amern tyenkerr impen akngek angayakwirrekerr. David-el renh-rnem ilek, “Amern inenhetyek angayakwirrekerr, arwa alhewer.” ");
INSERT INTO aly_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","28","Jesus ilelhek ikwer-rnemek, “Ayengan atyetyart ilkwarl David-angkwarr. Ayengan Akngey-kenh Artwa Impen anyent. Angka atyenh aynteyel, arlta Saturday-el amern arlkwetyek angayakwirrekerr, arwa alhewer.” ");
INSERT INTO aly_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Saturday-el, Jesus alhek warl kwen-warl Jew-rnem angkerrenh-warl. Artwa anyent akwa arlwerrelhekarl, akngelhey-angenh anenh warl kwenel. ");
INSERT INTO aly_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pharisee-el-rnem Jesus renh arek, arrer-they, ra arntety renh mwerrilentyek. Artwa rernem angkerrenh, “Arlta Saturday-el rlengkan Jesus-el nthakenh mwerriley-angenharl. Moses-kenh angka nhenh arrwekel aynteyel.” Jesus renh arek Pharisee-el-rnem, rarl akengentyirrek arlta anyent impen nhel. “Moses-kenh angka aynteyel, arlta Saturday-el nthakenh ingwerenty mwerriley-angenh.” ");
INSERT INTO aly_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesus-el arntety renh ilek, “Nga akethel nhel rtna, ngenh ingkerrenhel aretyek.” ");
INSERT INTO aly_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jesus-el renh-rnem ilek, “Nthek-angkwarran arrantherr angkerreyel? Atyeng ilenherr-arey law arrekantherrenhan nthek-angkwarrarl? Atha apek mwerrilem renh arlta anyent impen nhel rlengk. Atha apek ilwerl-athenem renh arlta impen nhel.” Rernem akatek, tyerney-angenh. ");
INSERT INTO aly_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesus ahelirrek Pharisee-ek-rnem, rernem artwa arntety amperrngirrey-angenhek, rernemap iterl-arek ra menty ilwetyek. Jesus amperrngirrek Pharisee ikwer-rnem, rerneman mwerranty ikwer awelhey-angenh. Artwa arntety renh ilek Jesus-el, “Akwa arratyirra!” Artwa ra akwa arratyirrek, mwerr-anem. ");
INSERT INTO aly_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pharisee-rnem alhek Herod-rnem-warl, rernem tyel-angkerretyek Jesus ikwer, rarl arntety anyent mwerrilek, arlta anyent impen apmwelek, Jesus-el. Rernem angkerrek, Jesus renh atwetyek. ");
INSERT INTO aly_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jesus kwertengerl ikwerenh-rnem-akert akarrirrek, kwaty ilkwa Galilee impalthel-antey. Akngerr apmer arrpanenh-they ikwer-warl akarrirrek, Galilee, Judea, Jerusalem, Idumea, Jordan Ilpay akngerrakw-areny-rnem-then. Rernem akarrirrek, apmer Tyre-ampeny-they, apmer Sidon-ampeny-they. Rernem Jesus renh awek, rarl arntety anyent renh mwerrilek. ");
INSERT INTO aly_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Akngerr akarrirrek Jesus-warl, renh awetyek. Akngerrelarl tyetilek-kety kwaty ilkwa impalthek. Jesus kwertengerl ikwerenh-rnem-akert rtnwewarl nganek, Jesus ra ingkerrenh akalty-anthetyek rtnwethey. ");
INSERT INTO aly_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ikwer-penhan, ra akngerr arntety-rnem mwerrilek. Arntety ingwerel-rneman renh ayernek, renh-rnem-anemarl mwerriletyek. Rernem iterrek, “Anwantherr renh arnep-arnenty, anwantherrap mwerrarl irreman.” ");
INSERT INTO aly_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Arrentyel-rneman renh arek rarl arntety-rnem mwerrilek. Arrenty-rnem aytnerl-alhek kwenirremel. Rernem artewentyel arlkek, “Ngan Akngey-kenh inngarl apetyek.” ");
INSERT INTO aly_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesus-el arrenty-rnem akatek, “Arrantherr ingwer-rnem-warl iley-angenh, ayeng Akngey-kenh Alerikw. Arrantherr akater aney-alpenherr-arey.” ");
INSERT INTO aly_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesus alhek apwert ilkwewarl kwertengerl ikwerenh-rnem-akert. ");
INSERT INTO aly_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jesus ra rlwanek irrpetyap kwertengerl ikwerenh-rnem ikwer-itwek anetyek ilkwatherr, rernem apmer ingwer-rnem-warl alhetyek, Jesus-kenh angka iletyek. ");
INSERT INTO aly_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Jesus-el rlterrk ikwerenh anthek, kwertengerl ikwerenh-rnemel arrenty-rnem irrentetyek. ");
INSERT INTO aly_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","18","Jesus-el artwernem 12 rlwanek, ra renh-rnem Akngey-angkwarr akaltyiletyek, kwertengerl ikwerenh-rnem-anem rernem anetyek. Itnan renh-rnem ra itneweynek, Simon, awayenheng-atherr James, John, Andrew, Philip, Bartholomew, Matthew, Thomas, James, Alphaeus-kenh alerikw, Thaddeus, Simon Patriot, Judas Iscariot. Simon atherr ra rlwanek, anyentarl Jesus-el itnewek Peter, ingwer Canaan-areny, itnan Simon Patriot. Kwertengerl awayenheng-atherr itna James, John, Zebedee-kenh alerikw-atherr. Jesus-el renh-atherr arrkent akenh itnewek “Artwa ahawarr-atherr.” ");
INSERT INTO aly_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Apmer Iscariot-areny, itnan Judas, rarl artwa ahelengkw-rnem atnwenhek Jesus-arl anenh-warl, rernem renh anterrkwetyek, atwetyek. ");
INSERT INTO aly_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","21","Jesus alpek apmer ikwerenh-warl, rarl awank-akerr anenh-warl. Akngerrarl akarrirrekel ikwer-warl, renh amern arlkwey-angenhilek. ");
INSERT INTO aly_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Artwa ilkwernem apmer Jerusalem-areny-rnem-then artwa akalty-anthenh-anthenh-rnem-then apetyek Jesus ikwer-warl. Rernemap ikwer angkerrenh, “Artwa nhenh arwengk-apenyarl angkeyel. Atyetyart arrenty-kenhelan Jesus renh rlterrkilek, ra arrenty-rnem ingkerrenh irrentetyek.” ");
INSERT INTO aly_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesus-el artwa ingkerrenh akarrilenhey-alpek, rernem ikwer-warl apetyetyek, Ra renh-rnem akalty-anthetyek ingkerrenh. Rap renh-rnem ilek, “Awelhenherr-arey atyeng, atharl arrekantherr inngarl ileyel. ");
INSERT INTO aly_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","26","Arrenty-kenh rlterrk-akertel nthakenh atha irrentey-angenh ikwerenh-rnem-they. Ra ayenh rlterrkiley-angenh, ikwerenh-rnem irrenteyek. Akngey-kenh Itnweng-akertarl ayengan, arrenty-rnem ingkerrenh irrentetyek. Atyetyart arrenty-kenhel nthakenh ikwerenh-rnem irrentey-angenh. ");
INSERT INTO aly_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Artwa rlterrk aneyel warl ikwerenhel. Ingwerentyel nthakenh arnkwa ikwerenh ingkerrenh iney-angenh. Artwa anyent ingwer rlterrk apetyem warl ikwerenh-warl renh anterrkwemel, renh arertnemel, arnkwa ikwerenh ingkerrenh akngeynemel. Atyetyart Arrenty-kenh artwa rlterrk-apeny. Ayengan ikwer-they rlterrk inngarl, ikwerenh-rnem irrentetyek. ");
INSERT INTO aly_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Artwa ingwerenty ra apmwel-areth intem anayntem, Akngeyelan ikwerety apmwa iwemarl. ");
INSERT INTO aly_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","30","Artwa anyent rarl Akngey-kenh Itnweng apmwelem, Akngeyelan ikwerety apmwa nthakenh iwey-angenh-anemarl, arrangkw-anemarl. Ra apmwel-areth intem anem ilweyek-atwety. Akngeyel renh nthakenh arntarnt-arey-angenh-anem, arrangkw-anem. Rap menty anem, ilweyek-atwety.” ");
INSERT INTO aly_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesus-kenh amikwel-then ayteyikw-rnemel-then rernem awek apmer ingwer-they Jesus ra arwengkirrentyek-athen. Rernem angkerrenh, “Ingwerel-rnem ileyel Jesus rarl arwengkirrek. Mpa! Anwantherr ikwer-warl alhey, anwantherr renh aretyek.” Rernem ikwer-warl ingkerrenh alhek. Rernem artwa anyent thwenek angkakert, Jesus renh ikngwetyek. ");
INSERT INTO aly_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ra Jesus renh ilek, “Amengkw-then ayteyengkw-rnem-then ngkweng akethel mpwelheyel.” ");
INSERT INTO aly_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesus-el renh-rnem ilek, “Atyenh-rnem akethel mpwelheyel, ngay? Ayeng Akngey-kenh arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","35","Arrantherr Akngeyek mwantyel awelhem, arrantherrap Akngey-kenh inngarl aneman, amey atyenh-apeny, ayteyaty atyenh-rnem-apeny. Akngey anyent-angkwarran, anwantherr aneyel ikwerenh-rnem. Arrantherr amey atyenh-apeny, ayteyaty atyenh-rnem-apeny.” ");
INSERT INTO aly_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Akngerr innga akarrirrek apmer arrpanenh-they Jesus-warl, rap ilenh angka ikwer-rnem. Jesus-el akalty-anthek renh-rnem Galilee kwaty ilkwa impalthek. Akngerrelarl tyetilek-kety ra rtnwewarl-anem nganek, kwatyelarl rtnwa rtnenh-warl. Ra rtnwethey-anem anemel-anem, angkan ikwer-rnem ilenh. Akngerr rtnenherremel awelhenh Jesus ikwer kwaty ilkwa impalthel. ");
INSERT INTO aly_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","3","Ra angka akngerr ilenh. “Awelhenh-arey atyeng! Artwa anyentel ra ntang weyt iwerl-apenh, amern lyapetyek. ");
INSERT INTO aly_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Artwa ra ntang weyt ingwerentyan iwerr arlertek-warl iwerl-apenh. Thip-rnemel apetyemel arlkwek ingkerrenh. ");
INSERT INTO aly_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Artwa ra ntang weyt ingwerentyan ahern apwert-angketyarr-warl iwerl-apenh. Rernemap alyepel lyaperrek. Artekerr kwen-aylpey-angenh ahern apwert-angketyarrel. Artekerran nthakenh lyapey-angenh ahern apwert-angketyarrelan. ");
INSERT INTO aly_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Atherrk-rneman arlenyirrek-anem itwern-penh kwaty-wenyel. ");
INSERT INTO aly_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Artwa ra ntang weyt ingwerentyan ahern arlkerl-angketyarr-warl iwerl-apenh. Arlkerl artekerrel amern weyt anterrkwek, nthakenh lyapey-angenhilek. Aylertnenharl renh, intwey-angenh ilenh. Arlkerl-angketyarrelan lyapey-angenh amern weyt arrangkw. ");
INSERT INTO aly_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Artwa ra ntang ingwerentyan ahern mwerr-warl iwerl-apenh. Amern weyt ahern mwerrelan mwerrarl lyapek. Ntang weyt anyent-they amern akngerr lyapek, ntang 30 apek. Ntang weyt anyent ingwer-they 60 apek, ntang weyt anyent ingwer-they 100 apek. Aparnp-anem irrenh. Arnkengeny-anem inpanem.” ");
INSERT INTO aly_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jesus-el renh-rnem ilek, “Angka nhanyem mwerr atha arrekantherr ilem, arrantherrap iterl-arenherr-arey!” ");
INSERT INTO aly_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Akngerr ingwer-rnem alperlewek apmer-warl, angka mwerrarl awek-penh. Jesus-akerr kwertengerl ikwerenh-rnem-then anenharl akngerr ingwer-rnem-then. Rernem renh ayernek, “Ntwa anwernenhantherr angka ngkwenhel anayntila!” ");
INSERT INTO aly_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesus-el renh-rnem ilek, “Nhanyem atha angka arrekantherrant ilem, Akngeyelarl ikwerenh-rnem ingkerrenh arntarnt-areyel-apeny. Nthakenh atha angka ingkerr ingwer-rnemek iley-angenharl. Nthakenh atyengan akngerr awelhey-angenharl. ");
INSERT INTO aly_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Rernem apek atyeng mwantyel awelhenty, rernemap ingkerr Akngey-warl angkepirremarl. Akngeyel apmwa ikwer-rnem-kety iwem. Atharl angka ikwer-rnem ilek, rernem angka atyenh awekarl-penhan, rernem ywarn iterrey-alpeyel.” ");
INSERT INTO aly_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesus-el renh-rnem ilek arrpemarl, “Angka nhanyem arrantherr iterl-arey-angenharl, angka ingweran nthakenh arrantherr iterl-arey-angenh. ");
INSERT INTO aly_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Amern weytarl arlperrty iwem-apeny, angka nhanyem Akngey-kenh ingkerrenh-angkwarr arlperrtyirrem. Akngey-kenh angka arlperrtyirrem arrpemarl ingkerrenh-angkwarr, ingkart-rnemel ileyel ingkerrenhek. ");
INSERT INTO aly_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ingwer-rneman ntang weytarl iwerr arlertek-warl iwek-apenyarl. Rernem Akngey-kenh angkek awelhem-tangkwel, rernem Akngey-angkwarr-anem apenteyel. Arrentyel Akngey-kenh angka ilpertileyel, thip irrpwerl ilengel-rnem ntang ilpertilem-apeny. Rernem intwemelirreyel Akngey-kety, rernem intem-anem apmwel-areth aneyenh. ");
INSERT INTO aly_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Ingwer-rnem angath-antey Akngeyan apenteyel. Rernem Akngey-kenh angka awemarl-penh, rernem mwerrarl apenteyel angath-antey. Rernem ntang weytarl apwert-angketyarrelan iwek-apenyarl. Artekerr-rnem aylpeyel angath-antey apwert-angketyarrelan. Ingwerel-rnem alakenh-anyemarl Akngey-kenh angka apenteyel angath-antey. Rernem ipmelhem-anem. ");
INSERT INTO aly_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ingwerentyan ntang weytarl arlkerl-angketyarr-warl iwek-apenyarl rernem Akngey-kenh angka iylpelant aweyel. ");
INSERT INTO aly_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Rernem apwert manek ampwal ingwerentyek-then iterrerl-anem apmwel-areth. ");
INSERT INTO aly_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ingwerentyan ntang weytarl ahern mwerr-warl iwek-apenyarl. Rernem Akngey-kenh angka awemel, rernem inkwerelhem.” ");
INSERT INTO aly_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesus-el renh-rnem ilek, “Lyenenty nthakenh arrantherr irrtyertewey-angenh. Lyenenty arrtyenherr-arey, akethek ingkerrenhel aretyek. Iylpel awelhenherr-arey atyeng! Artwa anyentel lyenenty arrernetyek ampep-warl, ingkerrenhel aretyek. Ra irrtyertewey-angenh teram-warl, ra irrtyertewey-angenh kweneng-apert pangk-warl. ");
INSERT INTO aly_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ingwerel ilek-ilek irrtyert akwernem, ingwerentyel nthakenh arey-angenh. Ingwer-ingerant renh arerl-arrernem. ");
INSERT INTO aly_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Arrantherr angkek Akngey-kenh mwantyel awelhenherr-arey, atharl arrekantherr ilem.” ");
INSERT INTO aly_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Arrantherr angkek Akngey-kenh awelhemer mwantyel. ");
INSERT INTO aly_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Arrantherr Akngey-kenh angkek mwantyel awelhenty, inkwerelhemel, Akngeyel arrenhantherr intem-antey akaltyilem.” ");
INSERT INTO aly_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesus-el renh-rnem ilek, “Atha arrekantherr iley, Akngeyelarl ikwerenh-rnem ingkerrenh arntarnt-areyel-apeny. Nthakenharl athan anayntilem arrekantherr? Alakenh-anyem atha arrenhantherr ilem, arrantherraw iterl-aretyek. Artwa anyentelan ntang weyt iwerl-apem, lyapetyek ahern-warl. ");
INSERT INTO aly_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","28","Rap ankwayntem ingwel, atnaraty ayntemel, ntang weytan ament lyapey-alkenharl kwaty-penh. Ntang rap amern-akert-anem lyapem. Artwa ra iterl-arey-angenh, ntang weyt ahernelant lyapelhilem. Ntang weytan atherrk lyapem, amern-akert. ");
INSERT INTO aly_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Artwa ra apetyem-anem, amern weyt akalthetyek nayp arreylp amper-amperel. Ranem amern inem-apeny akngerr, Akngeyelan alakenh-anyemarl ikwerenh-rneman akarrilem.” ");
INSERT INTO aly_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesus ikwer-rnem angkek, “Nthakenh Akngeyelan ikwerenh-rnem akarrileyel? Nthakenharl atha ilem arrenhantherr? Angka impen Akngey-kenh-angkwarr atha ilem. ");
INSERT INTO aly_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ntang ankwerrernarl lyapeyel-apeny ahernel. ");
INSERT INTO aly_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ntang ankerr-penh lyapem arwerl ilkwa. Thip-rnem ikwer-warl arrernelhemarl. Ankerr anyent-apeny, Akngey-kenh anyent anenh. Ntang arwerl akngerr aneyel-apeny, Akngey-kenh-rnem akngerr-anem aneyel. Rerneman arlperrtyirrem, ntang arwerl akngerr arlperrty aneyel-apeny. Alakenh-anyeman irrpetyapelant Akngey-kenh angkan apenteyel. Ikwer-penhan akngerrel-anem Akngey-kenh angka apenteyel. Rerneman arlperrtyirrem, ntang arwerlel arlperrty aneyel-apeny.” ");
INSERT INTO aly_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesus-el ingwer-rnemek angka arrpanenh ilenh angath-antey. Ra ilek renh-rnem nhek-atwety. Angka alakenh-anyem irrpetyapelant iterl-arenh. Akngerr ingwerel-rnem angkeyan iterl-arey-angenharl. ");
INSERT INTO aly_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jesus-el kwertengerl ikwerenh-rnem-warl ilenh angka akngerr ilenh ywerrelhemel. ");
INSERT INTO aly_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Atwerrp, Jesus angkek kwertengerl ikwerenh-rnemek, “Mpa! Kwaty ilkwangkwarr anwantherr artarnpenhey akngerrakw-ampeny-warl.” Nganerl-alhek rernem rtnwewarl-anem anperl-alhek. ");
INSERT INTO aly_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jesus ra kwertengerl ikwerenh-rnem-akert artarnpenhek kwaty ilkwangkwarr akngerrakw-ampeny-warl. Rtnwa ingwer-rneman ingkern-theyan renh-rnem apentek arrpemarl kwaty ilkwangkwarr. ");
INSERT INTO aly_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kwaty awer-akert apetyek rntwey-alhek rlterrk innga. Awer ilkwel renh-rnem akngelhew-akngelhilek. Kwatyan lherrparnpek-anem rtnwewarl, rtnwan aylperl-alhetyek-anek-anem. ");
INSERT INTO aly_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesus rtnwa ingkernel rtemalel ankwaynterl-apenh. Kwertengerl ikwerenh-rnemel Jesus akwentelhilek. Rernemap renh ilek, “Akalty-anthenh-anthenhay, akwentay! Ntwan anwernenhantherr kwaty-kety arntarnt-arey-angenh. Ntwa anwernenhantherr kwatyel aylpenty aretyekarl ngan arlkwenteyel?” ");
INSERT INTO aly_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesus artewentyel arlkek awerek, atnengkirretyek. Kwaty awer-akert atnengkirreylpek, arwapeny. ");
INSERT INTO aly_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesus-an ikwer-rnem angkek, “Ilek-ketyarl arrantherr aterirreyel, atyeng irrpelthirremel-apeny, atharl arrenhantherrenh arntarnt-areyelan?” ");
INSERT INTO aly_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kwertengerl ikwerenhel-rnem Jesus renharl awek-penh rernem ikwerety aterirrek, rarl kwaty awer-akert ilek rlterrkel. Rernemap ayernerrek, “Nthakenh awer-then kwaty-then ikwerant awelheyel?” ");
INSERT INTO aly_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesus rtnwel atarnpenhek Galilee kwaty ilkwangkwarr kwertengerl ikwerenh-rnem-akert. Rernem apmer Gerasa kwaty ilkwa impalthek rtnwa rnkernek. ");
INSERT INTO aly_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Artwa arwengk arrenty akngerr-akertel Jesus arlengek arnarek, apetyenharl. Ra kanper-antey anekirrey-ayntek Jesus-warl apmer awenng-angketyarr-they. Arrewaly-kenh awenng-angketyarrel ra anenh, arnkwakert-wenyel. ");
INSERT INTO aly_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Akngerr-inger apmer ikwer-arenyel-rnem renh arertnek tyeynel, arlaw atherr, akwatherr. Ran renh tyeyn akenhant. ");
INSERT INTO aly_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Intem-antey ra awenng arrerentyel anenh, apwert-ampenyel. Akngerr-inger ra ilperl arreylpel akelhenh, artewentyel arlkemel, arlta arrpanenhel ipantey arlkenh, ingwepenhek-atwety. ");
INSERT INTO aly_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ra anterremel Jesus-warl anekirrek, kwenirrey-alhemel, ampwethel alernelhemel. ");
INSERT INTO aly_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jesus-el ilek, arrenty kel tyerrelhetyek, artwa ikwer-they. Artwa ra arlkek, “Jesus, ngan Alerikw Akngey-kenh irrwerl-areny. Ilekek ngan apetyek? Ntwa atyeng arraty ilay, ntwa ayenh irrenteyang!” ");
INSERT INTO aly_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesus-el renh ayernek, “Itnan ilek nga?” ");
INSERT INTO aly_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Artwa ra ilelhek, “Itna ayeng ‘Akngerr’, ayeng arrenty akngerr-akert.” Ra arrkngert angkek Jesus-ek, “Ntwa irrentey-angenh renh-rnem apmer arleng-warl!” ");
INSERT INTO aly_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Apwertel atnwenth pikepik akngerr 2,000 rtnenherrenh. ");
INSERT INTO aly_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Arrenty-rnemel Jesus renh ilek, “Irrentey-angenh anwernenhantherr apmer arleng-warl! Anwernenhantherr atnwenth pikepik-rnem-warl thwena!” ");
INSERT INTO aly_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesus-el kel renh-rnem irrentek. Rernem kel tyerrelhek artwa arwengk-they, alhemel pikepik-rnem-warl. Pikepik-rnem kel anterrek. Rernem kwaty alay-warl aylpenhek, intem-antey. Rernem ilwek kwaty ilkwel kwen. ");
INSERT INTO aly_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Artwa ingwer-rnem pikepik arntarnt-arey-angker-rnem tawen-warl alhek. Rernem iley-alhek tawen-areny-rnem, pikepik-rnem kel ilwek kwaty ilkwa kwenel. Tawen-areny-rnem rernem-anem alhek, rernem-anem aretyek. ");
INSERT INTO aly_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Rernem artwa renh arek, rarl mwerr-anem anenh, arnkwakert-anem, rarl mwerr-anem iterremel anenh. Rernem Jesus ikwerety aterirrek, itnweng rlterrk-akert-kety. ");
INSERT INTO aly_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Rernem angkerrenh artwa ikwer pikepik-rnemek-then. ");
INSERT INTO aly_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Rernem Jesus renh ilek, “Nga apmer ilenh-they alpetyek, apmer ingwer-warl-anem.” ");
INSERT INTO aly_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesus nganetyek irrek rtnwewarl, artwa ra Jesus renh ayernek, “Ayeng-then ngkweng-angkwarr alhey, mwerrang ngay?” ");
INSERT INTO aly_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesus angkek, “Menty! Nga apmer-warl alpa, ngkwenhek-rnem ilelhey-alpa, atharl ngenh mwerrilek, Itnweng Akngey-kenh rlterrk-akertel.” ");
INSERT INTO aly_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Artwa ra apmer Decapolis-warl alhek, 10 tawenel anenh-rnem-warl. Ra ilelhek ingkerrenhek, “Jesus-el ayenh mwerrilek.” Rernem apatemel awek. Rernem angkerrenh, “Ilenharl angka mwerran!” ");
INSERT INTO aly_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesus rtnwel Galilee kwaty ilkwangkwarr alhek. Akngerr Jesus-warl ingkerrenh kwaty impalth-warl akarrirrek. ");
INSERT INTO aly_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Atyetyart Jew-rnem-kenh ra anenh, itnan Jairus. ");
INSERT INTO aly_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Artwa atyetyartel Jesus renh ilek, “Kwey atyenh ilwetyek arrer-anem. Apetyay! Renh arnep-arna, ra mwerrirretyek!” ");
INSERT INTO aly_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Akngerr ingkerrenhel renh-atherr apentek. Akngerrel renh-atherr tyetilek, rernem arrer-they renh awetyek. ");
INSERT INTO aly_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","26","Ingkerrenh akarrirrek Jesus-warl. Arelh anyent arntety inngan, aherrety 12-ek-atwety, arleng-alenty anenh. Ra ngangker arrpanenh-warl alhenh, renh mwerriletyek. Ngangker-akertel renh mwerriley-angenh, tywen-antey ra kwarnelheyel. Arelhel ngangker-akert-rnem man ingkerrenhek anthek, ingkerrenh-antey, ra man-weny-anem. Ngangker-akertel-rnem renh artewentyel-anem arntety anthek. ");
INSERT INTO aly_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Rap awenh ingwer-rnemel ilerrerl-anenty, “Jesus ra arntety ilkwa mwerriley-angker.” ");
INSERT INTO aly_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ra ament-anem iterrek, “Atha arnkwa ikwerenh arnep-arnenty, ayengap mwerrarl irreman.” ");
INSERT INTO aly_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Arelh ra arnkwanem Jesus-kenh arnep-arnek-penh, ra mwerr-anem irrek, arntety-weny-anem. ");
INSERT INTO aly_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesus ra iterl-arek, renharl ingwerentyel arnep-arnek, itnweng ikwerenh alhek, arntety ikwer-warl, mwerriletyek. Rap angkek, “Angwenhel arnkwa atyenhan arnep-arnek?” Ingkerrenh akarrirrek Jesus-warl, akngerrel renh tyetilek. ");
INSERT INTO aly_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kwertengerl ikwerenh-rnemel Jesus renh ilek, “Akngerr ngkweng-warl apetyem. Nthakenh ntwa iterl-arey-angenh akngerr-angkwarr. Akngerr nhenh-angkwarran ntwa nthakenh alhengk-areyang renhan, rarl arnkwa ngkwenh arnep-arnekan.” ");
INSERT INTO aly_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesus-el artepang arenhey-alpek, “Angwenhel atyenh arnkwan arnep-arnek?” ");
INSERT INTO aly_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Arntety ra apetyek Jesus-warl. Kwenirrey-alhek-anem ra. Ra aterel anem arrewek Jesus-kety. Ra arraty-antey Jesus-warl ilelhek rarl arnkwa arnep-arnek-penh, “Ayengarl arntety intem-antey anenhel, atha arnkwa ngkwenh arnep-arnek. Ayeng mwerr-anem irrek, atharl arnkwa ngkwenh arnep-arnek-penh.” ");
INSERT INTO aly_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesus ikwer angkek, “Ayenh ntwa iterl-aremer, ayeng Itnweng Akngey-kenh rlterrk-akert. Aterirrey-angenh ana! Akngeyel ngenh arntarnt-areyel.” ");
INSERT INTO aly_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus-el angkantey ilenh, artwa ingwer-rnem apmer Jairus-kenh-they angkakert apetyek. Rernem angkek Jairus-warl, “Ngan akalty-anthenh-anthenh ilenh-itwel anngangelheyel! Ngwang angkey-angenh ilenh-itwel. Kwey ngkwenh kel-antey ilwek!” ");
INSERT INTO aly_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesus-el renh-rnem awek. Rap angkek Jairus-warl, “Artewentyel iterrey-angenh! Irrpelthel mwerriley-angker ayengan, kwey renh mwerriletyek.” ");
INSERT INTO aly_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesus arrkngert angkek, “Menty irrpetyap atyeng-angkwarr apetyey! Peter-then awayenheng-atherr, James-then, John-then.” ");
INSERT INTO aly_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Rernem Jairus-kenh apmer-warl alhek. Rernem awek, Jairus-kenh apmer-itwek, ingwer-rnem artnalhelhirrenh. Artewentyelap rernem artnenh, amperrngirremel. ");
INSERT INTO aly_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesus angkek, “Ilekek arrantherr artnalhelhirreyel? Kweyan ilwey-angenharl ankwarl aynteyel!” ");
INSERT INTO aly_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ingwer-rneman ikwer atherrenh, irrpelthirremel. Rernem iterl-arek kwey rarl kel ilwek. Jesus-el thwenek ingwer-rnem, tyerrelhemel alhetyek, warl-they. Jesus-el atnwenhek kwey-kenh amikw-then aynikw-then kwertengerl ikwerenh-rnem-then arrewaly-warl. ");
INSERT INTO aly_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","43","Jesus-el itepel kwey renh anterrkwek. Ra akwentelhilek kwey renh angkemel, “Kwey, akwenta!” Kwey ra akwentek, rap alhenh-anem. Ingkerrenhap inkwerelhek-anem. Jesus angkek, “Ingwer-rnem iley-angenh-antey.” Jesus-el ilek amikw-then, aynikw-then, “Amern-anem renh anthenherr-atherr, ra arlkwetyek!” ");
INSERT INTO aly_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus tawen Nazareth, apmer ikwerenh-warl alpek, kwertengerl ikwerenh-rnem-akert. ");
INSERT INTO aly_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Saturday-el, ra warl kwen-warl aylpek, Jew-rnemarl angkerrenh-warl. Ra renh-rnem akalty-anthenh. Ingwer-rnemantarl Jesus-kenh angkek inkwerelhek. Rernem angkerrenh, “Jesus rantarl ingkerrenh-angkwarr iterl-areyel, ran akalty innga. Ranap ngangker-akert inngarl nhenhey, arntety mwerriley-angkerarl.” Akngerr ingwer-rneman Jesus-kenh angkek irrpelthirremel angkerrenharl, ");
INSERT INTO aly_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","“Jesus ahern-arenyarl mwerran ilek-ilek arwerl-penh arnwarney-angkeran! Ilenhan Mary-kenh ampikwarl! Ayteyikw-rneman ikwerenh apmer nhareny-rnemarl. Itnan ayteyikw-rnem ikwerenh, James, Judas, Joses, Simon. Arrempikw-rneman ikwerenh apmer nhareny-rnemarl. Ran anwantherr-apeny arrpemarl, Akngey-kenh inngewenyarl.” ");
INSERT INTO aly_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesus angkek, “Apmer nhareny-rnemantarl atyeng irrpelthirremelan angkeyel, ayeng angkakert Akngey-kenh inngewenyarl.” ");
INSERT INTO aly_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Akngerr-warl Jesus-el itep arrernek irrpelthirrenharl-rnem-warl-then. Irrpetyapantarl ikwer inkwerelhekan. Rernemap arntety-penhan mwerrarl irrek. ");
INSERT INTO aly_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesus rap ywarn iterrek ikwerarl irrpelthirrenhek-rneman. Ikwer-theyan ra apmer arrpanenh-warl alhek, Akngey-kenh angka ingkerrenh-warl ileyn-ayntetyek. ");
INSERT INTO aly_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesus-el kwertengerl ikwerenh-rnem ingkerrenh-antey rlterrkilek. Ra renh-rnem atherrarl-atherrarl thwenek, rernem alhetyek angka Akngey-kenh-angkwarr akalty-anthetyek. Ra renh-rnem rlterrkilek, rernem arrenty-rnem irrenteyek. ");
INSERT INTO aly_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ra angkek ikwer-rnem, “Atnemel arrantherr irrertety alhetyek akngenherr-arey. Amernan arrantherr akngeyang, menty! Arrantherr alhentyelan yakwethan mentyarl ayntayntey, manenpan. Iltyant alhenherr-arey atnemant-akert. ");
INSERT INTO aly_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ingketyek-arelh impen akngenherr-arey, arnkwa arlkelant akngenherr-arey.” ");
INSERT INTO aly_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jesus-el atherr-atherrarl amentew-ament ilek, “Mpwelanth alhem tawen-warl, warl anyentel-antey aney-alhenherr-atherr! Mpwelanth warl anyentelarl aney-alhenty-penh, mpwelanth tawen ingwer-warl-anemarl alhetyek. ");
INSERT INTO aly_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mpwelenhantharl tawen-arenyel-rnem irrentey-ayntem irrpelthirremel, ahernan irrarlkelhenh-atherrarl ingkety-theyan. Tawen-arenyel-rneman arem, ingketyarl mpwelanth irrarlkelheman ahern, rernem iterremarl, ‘Anwantherr arntetyirreyenh, Akngeyel anwenhantherr arntety ilkwa antheyenh, anwantherrarl renh-atherr arey-ayntem, inkwerelheyangel.’ Ikwer-theyan, mpwelanth tawen ingwer-warl-anemarl alhenherr-atherran.” ");
INSERT INTO aly_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jesus-kenh kwertengerl-rnem apmer arrpanenh-warl alhek, renh-rnem iletyek, rernem mwerr-angkwarr anetyek, apmwekety angkepirremel Akngey-angkwarrant-anem apentetyek. ");
INSERT INTO aly_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kwertengerl ikwerenh-rnem rernem arrenty akngerr irrentek tawen arrpanenhek. Rernem arntety-rnem mwerrilek, tawen arrpanenhek. Rernem anterel apernek, Akngey-warl angkemel, renh-rnem mwerriletyek. ");
INSERT INTO aly_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Herod-el Jesus renh awek, rarl arntety-rnem mwerrilenh, apmer arrpanenhek. Herod ra ywarn iterrenh John, Baptise-emeley-angker, “Rang angkep ipmepenh itethirrek, rang apmer arrpanenhek mwerrileyel.” ");
INSERT INTO aly_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ingwer-rnem angkerrenh, “Elijah rang alker-they apey-alpek anwekantherr-warl, arntety-rnem mwerriletyek, apmer arrpanenhek.” Ingwer-rneman angkerrenh, “Artwa angkakert ingwer ipmepenh angkep itethirremel, apey-alpek anwekantherr-warl, apmer arrpanenh arntety-rnem ingkerrenh mwerriletyek.” ");
INSERT INTO aly_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Atyetyart Herod apal angkenh, “John-ap ran! Itethirrenhey-alpekan, atharl thwenek ingwerel renh ahenty rlweth-aketyek, atwetyek!” ");
INSERT INTO aly_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herod-el kel iterl-arek, rarl ahelengkw thwenek, ra John renh anterrkwemel atwetyek. ");
INSERT INTO aly_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Awayikw ikwerenh Herod-el anew ikwerenh rakek, itnan Herodias. John-el renh ilek, “Ntwa nthakenharl awayengkwan anew ikwerenhan rakek? Apmwel-aretharl alakenhey! Awayengkw-anteyarl anew ikwerenh ntwa rakekan, arraty-wenyarl!” Arelh Herodias ra ahelirrek John ikwer. Herod-el John renh anterrkwek, tyayl-warl akwernemel. ");
INSERT INTO aly_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Arelh Herodias ra iterrek, John renh atwetyek. ");
INSERT INTO aly_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herod aterirrek John-kety, rarl arraty Akngey-angkwarr anenh-kety. Herod-el arntarnt-arenh renh arleng-alenty. Herod atherr-angkwarr iterrenh, mwerr-angkwarr, apmwangkwarr. ");
INSERT INTO aly_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Arelh Herodias mpwelhenh Atyetyart ilkwek, renh ayerneyek, John renh atwetyek. Atyetyart Herod-rnem-then Atyetyart ilkwa ingwer-rnem-then, apmer Galilee-areny-rnem akarrirrek, rernem amern ingkerrenhel arlkwetyek. Atyetyart ahelengkw-rnem-then rernem akarrirrek ingkerrenh amern ingkerrenhel arlkwetyek arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Arelh Herodias-kenh ampikw rntwenh ikwer-rnem ingkerrenhek. Aleyak ikwer rernem inkwerelhek, rarl mwerr-angker Herod-kenh apmerel rntwenhek. Herod-el kwey renh ilek, “Ilek-ilek akngerrek nga arlkwententy, atha ngenh anthem.” ");
INSERT INTO aly_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kwey ra amikw ikwerenh, Herodias-warl alhek. Ra amikw renh ayernek, “Ilekekarl atha ayernem Atyetyart ilenhan?” Amelikw renh ilanthek, “Akapwert John Baptise-emeley-angker yanh ina, pmwar-warl arrernemel, ayenh anthemel!” ");
INSERT INTO aly_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ikwer-penhan kwey rap Atyetyart Herod-warl alhek. Ra Atyetyart Herod renh ilek, “Akapwert John Baptise-emeley-angker aka, pmwar-warl arrernemel, ayenh anthemel.” ");
INSERT INTO aly_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herod ra amperrngant-anem irrek John akapwert ikwer. Akngerrel renh awekarl-kety, ra nthakenh akengenty angkey-angenh. Nthakenh ra arrkngert angkey-angenh. ");
INSERT INTO aly_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Herod-el thwenek ahelengkw tyayl-warl, John ahenty rlweth-aketyek. ");
INSERT INTO aly_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ahelengkwel arreylpel akapwert rlweth-akek, akapwert renh pmwar-warl arrernemel, kwey renh anthek. Kwey ra amikw-warl akngeynek, John Baptise-emeley-angker akapwert. ");
INSERT INTO aly_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","John-kenh kwertengerl-rnemel awek, rarl ilwek. Rernem apetyek, ipma awenng-warl akwernetyek. Rernem renh akwernek. ");
INSERT INTO aly_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kwertengerl Jesus ikwerenh-rnem Jesus ikwer-warl apetyek. Rernem ilelhek rernemarl akalty-anthek apmer arrpanenhek, mwerr-angkwarr apmer arrpanenhek anetyek Akngey-kenh-angkwarr. ");
INSERT INTO aly_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Akngerr Jesus ikwer-warl apetyek. Kwertengerl ikwerenh-rnem-akert Jesus renh amern arlkweyangilek akngerrel. Jesus angkek kwertengerl ikwerenh-rnemek, “Mpa, anwantherr alhey, apmer ingwer-warl, ikwer-rnem-kety!” ");
INSERT INTO aly_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nganerl-alhek rtnwewarl, rernem kwaty ilkwangkwarr artarnpenhek artempel ingwer-warl. ");
INSERT INTO aly_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ingwerel-rnem renh-rnem iterl-arek apmer ingwer-warlarl rernem artarnpenhek kwaty ilkwangkwarr, rtnwel. Kwaty ilkwa anper-alhemel, rernem alhek ikwer-rnem-warl. ");
INSERT INTO aly_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Akngerr Jesus ikwer-warl akarrirrek. Ra renh-rnem akalty-anthek, atwerrpek-atwety. ");
INSERT INTO aly_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kwertengerl ikwerenhel-rnem Jesus renh ilek, “Ingwer-rneman thwena tawen-rnem-warl, amern ikwerenh-rnem-kenh ineyek, atwerrpirrekerrem. ");
INSERT INTO aly_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Amern-wenyarl nhanyeman, arrangkwarl. Atwerrpirrekerr-awaty renh-rnem thwena!” ");
INSERT INTO aly_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesus angkek, “Arrantherr wantenherr-arey.” Rernem ywarn iterrek, rarl Jesus-el renh-rnem ilek. Rernem angkek, “Man akelyarl nthakenh amern ineyang artwa akngerrek.” ");
INSERT INTO aly_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesus angkek, “Amern aretyek alhenherr-arey akngerrek.” Rernemap amernek nthwerl-apenh. Rernem Jesus renh ilek, “Aker irrpeng atherr, amern irrpetyap.” ");
INSERT INTO aly_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesus-el ilek kwertengerl ikwerenh-rnem, rernem iletyek akngerr arrernelhetyek ingkerrenh atherrk-warl. ");
INSERT INTO aly_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ingkerrenh rernem arrernelhek amentew-ament. ");
INSERT INTO aly_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Aker irrpeng-atherr amern irrpetyap Jesus-el inek. Ra Ingkart Akngey-warl angkek inkwerelhemel, ra amern akngerr anthetyek, aker irrpeng akngerr anthetyek. Jesus-el amern rlweth-akek. Ra kwertengerl ikwerenh-rnem anthek, rernem-anem antheynetyek ingwer-rnem. Jesus-el aker irrpeng rlweth-akek. Ra anthek kwertengerl ikwerenh-rnem rernem antheynetyek ingwer-rnem. ");
INSERT INTO aly_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","44","Artwa akngerrel amern arlkwek-penh, rernem mwerr-anem, atnerteng-anem anek. Artwa akngerrel amern arlkwek. Rernem arrangkw-anem aneyel, rernem atnerteng-anem aneyel Amern akngerr-antey ayntenh. Rernem amern akngerr ywerrelhey-angenh. Amern ikwer-rnem-angkwarr akngerr-anteyarl. Rernem akarrilek arrernemel teram 12-warl. Amern akngerr-anteyarl rtnenh 12 teram ikwer. ");
INSERT INTO aly_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jesus-el ilek kwertengerl ikwerenh-rnem, rtnwel rernem kwaty ilkwangkwarr artarnpenhetyek, apmer Bethsaida-warl. Ingwer-rnem Jesus-el ilerl-alhek rernem apmer-warl alperlewetyek. ");
INSERT INTO aly_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","48","Ra nganek apwert ilkwewarl, ra angketyek Akngey-warl. Jesus apwert irrwerlel ament-areny rtnenh. Rtnwa kwaty ilkwa ampepel rtnenh kwertengerl ikwerenh-rnem-akert. Kwertengerl ikwerenh-rnem artarnpenhek kwaty ilkwangkwarr artempel ingwer-warl. Jesus-el arnarenh renh-rnem ikwer-rnemenp awerelarl twetiwenh. Rtnwa arraty alheyang, renh-rnem alhengkerr anthek. Jesus ingwepenh kwaty ilkwa ampepel apetyek, ngwangkant akethirrenhey-alhentyel. ");
INSERT INTO aly_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Jesus ikwerenhel-rnem renh arnarek kwaty ilkwa ampepek, rarl apey-alhenh ingketyel kwaty ilkwa ampepel. Rernem aterirrek. Rernem iterrek, “Artwa itnweng arrewaly anwekantherr-warl kwaty ilkwa ampepel apetyeyel.” Rernem arlkek, aterirremel. Jesus angkek, “Aterirreyang anenherr-arey! Ayeng Jesus. Aterirrey-angenh arrantherr!” ");
INSERT INTO aly_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jesus ra nganek rtnwewarl, kwatyan atnengk-anem irrek. ");
INSERT INTO aly_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kwertengerl ikwerenh-rnem ywarn iterrek, rarl amern akngerrilek. ");
INSERT INTO aly_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jesus kwertengerl ikwerenh-rnem-akert rtnwel kwaty ilkwangkwarr alhek artempel ingwer-warl, tawen Gennesaret-itwel. ");
INSERT INTO aly_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Rernem atwarrirrek rtnwa ikwer-they. Akngerr yanh-arenyel-rnem Jesus renh iterl-arekarl. ");
INSERT INTO aly_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Rernemap anterreyelperl-anew, arntety-rnem akarriletyek, ingkerrenhel panty-warl, renh-rnem arrernemel, Jesus-el mwerriletyek. ");
INSERT INTO aly_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Apmer arrpanenh-they arntetyan apeyarr-alhek Jesus-el mwerriletyek. Arntetyel-rnem Jesus renh ayernek, arnkwa ikwerenh arnetyek. Rernemarl Jesus-kenh arnkwa arnep-arnek-penh, rerneman mwerr-anem irrek. ");
INSERT INTO aly_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Moses-kenh-rnem-then Pharisee-rnem-then anenh, Jerusalem-areny-rnem-then. Rernem Jesus-warl akarrirrek. ");
INSERT INTO aly_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Rernem arek, kwertengerl Jesus-kenhel-rnem itep aternngel amern alhewerarl arlkwek, itep lhewelhey-angenhel. ");
INSERT INTO aly_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Jew-rnem-then, Pharisee-rnem-then itep lhewelhenh amern arlkwey-alenty. ");
INSERT INTO aly_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Amern store-ek inemel, rernem irrarlkemel ingkerrenh kwatyel, rernem ampernemel arlkwey-alenty. Arrwekeleny-rnem-kenh angka nhenh ayntenh. Tyampet-rnem irrkwernem-then ingkerrenh rernem irrarlkek, rernem amern ampernemel arlkwey-alenty. ");
INSERT INTO aly_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Rernem Jesus renh ilek, “Kwertengerl ngkwenhel-rnem nthakenharl itep lhewelhey-angenharlan amern arlkwey-alenty. Arrwekeleny-kenh apmer nhel aknganek amern arlkwey-alenty itep lhewelhetyek.” ");
INSERT INTO aly_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesus-el renh-rnem ilek, “Arrantherr tnakelheyel. Awank-akerr Isaiah-el Akngey-kenh angka pip-warl ingkwernek, arrantherran aneyel-apeny. Akngey angkek ikwer-rnem, ");
INSERT INTO aly_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","‘Arrantherr irrtywerremel atyeng inkwerelheyel, angka atyenh-angkwarr apentey-angenh. Arrantherr akwerrng iterreyel arrekantherrenh-angkwarrant, alakenh-anyem arrekantherrenh iterrenty Akngey-kenh-angkwarr-weny.’” ");
INSERT INTO aly_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jesus-el renh-rnem ilek arrpemarl, “Arrantherr iterreyel arrekantherrenh-angkwarrarl, arrantherr anetyek. Arrantherr Akngey-kenh-angkwarr apentey-angenh. ");
INSERT INTO aly_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","10","Atha ileyel Akngey-kenh angkel, ‘Arrantherr amey-rnem-then, akngey-rnem-then ikwer-rnem awelhenherr-arey. Moses-kenh angka alakenh-anyemarl aynteyel arrwekelenyan. Ameyek, akngeyek awelheyang, arrantherr apmwangkwarrarl aneyel.’ ");
INSERT INTO aly_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Arrantherr arntarnt-areyang akngey-then amey-then. Arrantherr apmwel-areth akalty-antheyel, Akngey-kenh-angkwarr-weny. Arrantherr man ikwerel amey-rnem-then akngey-rnem-then arntarnt-arey-angenh, man ilenh arrantherr ayerrpileyel. Arrantherr irrtywerremel ileyel man nhenhan Akngey-kenh-arrpantey. ");
INSERT INTO aly_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Arrantherr angka Akngey-kenh ingkerrenh ipmeyel, angka arrekantherrenh-angkwarr apenteyel.” ");
INSERT INTO aly_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","15","Jesus-el renh-rnem akarrilek. Ra ilek, “Atyeng arrantherr awelhenherr-arey arternp. Amern arrantherr arlkwetyek alhewer, nthakenharl arrantherr apmwelhiley-angenh, amern alhewer arlkwemel. Angka Akngey-kenh nhenh aynteyel, amern alhewer arlkwetyek. Arrantherr apmwel-areth angkenty, arrantherr Akngeyek apmwelhileyel.” ");
INSERT INTO aly_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesus-el renh-rnem ilek-penh, ra apmer-warl alpek kwertengerl ikwerenh-rnem-akert. Kwertengerl ikwerenhel-rnem renh ayernek, “Ntwa anwernenhantherr anayntiletyek angka irrkaty, ntwarl renh-rnem ilek-apeny.” ");
INSERT INTO aly_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Jesus-el renh-rnem ilek, “Arrantherr ywarn-antey iterreyel angka nhenhan atharl arrenhantherr ileyelan. Amern arrantherr inemel alhewer arlkwetyek, nthakenh apmwelhiley-angenh. Amern arrantherr arlkwenty, kwernenhenty atnert-warl, rap atnert-they ywerrenhem. Amern, aker, alhewerarl arrantherr arlkwem. ");
INSERT INTO aly_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","22","Arrantherr apmwel-aretharlap iterrenty, arrantherr apmwangkwarrarlap aneman. Arrantherr ingwer-kenh arrkar irrtyertel ikngwenty, arrantherr apmwangkwarrarlap aneman. Arrantherr irrtyert-awarr anenty, arrantherr apmwel-aretharl ilenh-angkwarran-anem. Arrantherr ingwerenty atwenty, arrantherrap apmwangkwarrarlap aneman. Arrantherrarl irrtywerremel ilenty, arrantherr apmwangkwarrarlap aneman. Arrantherr ahelirrenty ingwer-rnemek, arrantherr apmwangkwarrarlap aneman. Arrantherr tyel-angkenty ingwer-rnemek, arrantherr apmwangkwarrarlap aneman. Arrantherr ingkerrenh-angkwarr alhewer alhenty, arrantherr apmwangkwarrarl anem. Arrantherr mwerr-arrpantey tnakelhenty, arrantherr apmwangkwarrarlap aneman. Arrantherr Akngeyek irrpelthirrenty, arrantherr apmwangkwarrarl anem. ");
INSERT INTO aly_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Alakenh-anyem, arrantherr apmwangkwarrarl anem, arrantherrarl iterreyel-angkwarr, arrantherr Akngey-kenh-angkwarr apmwelhileyel, ikwer inkwerelheyang-anem. Amern alhewer arlkwemel, nthakenh arrantherr apmwelhiley-angenh.” ");
INSERT INTO aly_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesus ra apmer Tyre-warl alhek, warl ingwer-kenhel aney-alhek. Jesus-el renh-rnem ilek, “Ingwer-rnem iley-angenh, rernem ayenh arlkarewerl-anekerr. Ayeng artenyel aneyel, atha kwertengerl atyenh-rnemantarl akaltyilem.” ");
INSERT INTO aly_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Arelh apmer Phoenicia-areny ra awek, Jesus-arl aney-alhek warl ingwer-kenhel. Arelh alethang anyent Greek, angka ingwer angkenh, Jew-kenh angkeweny. Ra Jesus-warl alhek, kwenirrey-alhemel, ampwethel alernelhemel. Kwey ikwerenh arrenty apmwakertarl anenh. Amikwel Jesus renh ayernek, “Ampa atyenh-kety, ntwa arrenty irrenta!” ");
INSERT INTO aly_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesus angkek, “Nthakenh atha ingwer-rnem arntarnt-arey-angenh. Anwantherr ampernem-tangkwel wantey. Atha atyenh-rnemantarl, Jew-rnem arntarnt-areyel. Rernem ampernem-apeny atyenh. Arengk-rneman ampel-rnem arlkwenty-penhant wantey. Atha atyenh-rnem, Jew-rnem-tangkwel arntarnt-areyel. Atha arrenty-rnem Jew-rnem-kety irrentem.” ");
INSERT INTO aly_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Arelh anyent angkek ikwer, “Arengkel-rnem arlkwetyek arrpemarl, arengk-kenh amernan rernem iweyek arrpemarl. Jew-rnem rernem ingkerrenh atyenh-rnem-kety arlkarirreyel. Atyenh-rneman arengk-apenyarl aneyel, Jew-rnem-angkwarr. Jew-rnemel renh-rnem arntarnt-arey-angenh. Atha ngenh iterl-areyel, ntwa ingkerrenh arntarnt-arey-angker. Ayenh-then arntarnt-ara!” ");
INSERT INTO aly_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesus-el arelh ilek, “Nga arraty atyeng-warl angkek. Kel arrenty tyerrelhemel alpek kwey ngkwenh-they.” ");
INSERT INTO aly_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Arelh apmer ikwerenh-warl alpek. Ra arek, arrenty kel tyerrelhemel alpenty kwey ikwerenh-they. ");
INSERT INTO aly_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesus alpek apmer Tyre-ampeny-they, apmer Sidon-angkwarr, Galilee kwaty ilkwewarl. Ra apmer Decapolis-angkwarr alhek. ");
INSERT INTO aly_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Artwa ingwer-rnemel artwa anyent atnwenhek Jesus-warl. Ra angkey-angenh, iylpa arwengk awey-angenh akerter. Rernem Jesus renh ayernek, ra renh mwerriletyek, iylpa altyweriletyek, mwerr-anem ra angketyek. ");
INSERT INTO aly_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesus-el artwa anyent renh tawen-they akwerr-warl atnwenhek. Jesus-el itep-atherrel iylpatherr-warl arrernek, artwa arwengk ikwer-warl. Jesus-el itep ikwerenh-warl apelh arrernek. Ra aleny artwa arwengk renh itepel arnep-arnek, ra mwerr angketyek, awetyek. ");
INSERT INTO aly_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jesus-el irrwerl alker itnywenek, angkemel, “Iylpatherr irrpelthel altywerila!” ");
INSERT INTO aly_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ikwer-penh artwa ra mwerr-anem aweyel-anem, mwerr-anem angkeyel-anem. ");
INSERT INTO aly_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesus-el renh-rnem artwerilek, “Ingwer-rnem-warl iley-angenh. Akater anenherr-arey, atharl artwa anyent mwerrilek.” ");
INSERT INTO aly_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ingkerrenh rernem artewentyel iterrek, angkerrenhan, “Ngangker inngan yanhey, artwa yanhan arntety-rnem mwerriley-angkerarlap ran, awey-angenh-rnem-then, angkey-angenh-rnem-then.” ");
INSERT INTO aly_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Akngerr akarrirrek Jesus-warl. Amern ingkerrenh ywerrelhilek. Jesus irrepern angayakw-rnemek amperrngirrek. ");
INSERT INTO aly_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Jesus ilelhek kwertengerl ikwerenh-rnemek, “Ayeng irrepern angayakw-rnemek amperrngirreyel. Arlta irrpety-inger rernem anwekantherr-itwel anenh, angayakw. ");
INSERT INTO aly_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nthakenh atha renh-rnem thweneyney-angenh, apmer arleng-warl alpetyek, rernem aytney-alpekerr angayakw angath-antey.” ");
INSERT INTO aly_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kwertengerl ikwerenh-rnemel renh ayernek, “Amernan anwantherr nthek-warl inem? Akngerr nhenh-rnem-akertan? Arrangkwarl nhenhan, aherretyarl! Atherrkeny-weny!” ");
INSERT INTO aly_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesus-el renh-rnem ayernek, “Amern akngerrelang arrekantherrenhan?” Rernem renh tyernek, “Ya, amern ampeng 7-ant aynteyel.” ");
INSERT INTO aly_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesus-el ingkerrenh ilek, “Arrantherr ingkerrenh anenherr-arey ahernel.” Jesus-el amern 7 renh-rnem inek. Ra Ingkart Akngey-warl angkek, inkwerelhemel, amern akngerr renh anthetyek. Jesus-el amern rlweth-akek, kwertengerl ikwerenh-rnem anthemel, rernem artwa ingwer-rnem antheynetyek ingkerrenh. ");
INSERT INTO aly_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Aker irrpeng-rnem-then irrpety kwertengerl ikwerenh-rnemel inek, Jesus renh anthemel. Ra Ingkart Akngey-warl angkek, inkwerelhemel aker irrpeng renh anthetyek. Jesus-el aker irrpeng renh rlweth-akek, kwertengerl ikwerenh-rnem anthemel, rernem artwa ingwer-rnem antheynetyek ingkerrenh. ");
INSERT INTO aly_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Jesus-el amern irrpety-penh irrpelthel akngerrilek, ingkerrenh wantetyek. Ingkerrenh 4,000 inkwerelhek, Jesus-elarl amern ingkerrenh wantek. Amern akngerr menty-anem irrek. Kwertengerl rernem ingkerrenh amern-rnem akwetyeynek, teram 7-warl ampwerrk iwemel ingkerrenh. Teram 7 amern akngerr-akert rtnenh. Jesus-el ingkerrenh thwenek, rernem apmer-warl alpetyek. ");
INSERT INTO aly_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jesus, kwertengerl ikwer-rnem-akert rtnwewarl nganek. Rtnwa ikwerel rernem alhek apmer ingwer-ampeny-warl-anem, apmer Dalmanutha-warl. ");
INSERT INTO aly_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Rernem atwarrirrek rtnwethey. Pharisee-rnem Jesus-warl apetyek, renh ilerretyek. Rernem renh arrkernek, Akngey-kenh rlterrkek, ingwerek-ingwer-angkwarr mpwaretyek, mwerriletyek. ");
INSERT INTO aly_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesus-el renh-rnem ilek, “Arrantherrarl angka ingwerek-ingwer ayenh ayerneyel-kety. Menty! Ayenh ipmenherr-arey, arlkareweyang! Ayeng menty-anem aneyel arrekantherrety.” ");
INSERT INTO aly_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jesus alhek ikwer-rnem-kety. Ra rtnwel nganerl-alhek. Ra apmer ingwer-warl alhek, kwaty ilkwangkwarr anthenayn, kwertengerl ikwerenh-rnem-akert. ");
INSERT INTO aly_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kwertengerl ikwerenhel-rnem amern ampeng iwerl-alhek apmerek. Amern anyentant rernem akngek. ");
INSERT INTO aly_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesus-el renh-rnem ilek, “Mwantyel arntarnt-arelhenherr-arey Jew-kenh angkarl apenteyel-rnem-kety, Atyetyart Herod-kety. Ahelarl rernem arlwar rtneyel-kety, thwet-penh-apeny, apmwangkwarrarl rernem akalty-antheyel-kety.” ");
INSERT INTO aly_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kwertengerl ikwerenh-rnem angkerrenh, “Ra ahelirreyel anwekantherr, anwantherrarl amern iwerl-alhekek-arnterl.” ");
INSERT INTO aly_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesus-el ra iterl-arek, kanper-antey, rernemarl ikwer angkerrenh. Ra renh-rnem ilek, “Ilekekarl arrantherran iterreyelan, amern arlkwey-angenhan? Arrantherr ingkerrenhel artewentyel iterl-arey-angenh-antey. Kel, arrantherr areyelan, arrantherr iterl-arey-angenharl. Kel, arrantherr aweyelan, arrantherr iterl-arey-angenharl. ");
INSERT INTO aly_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ayenh arrantherr iterl-aremer, ayeng Akngey-kenh Itnweng rlterrk-akert. Arrantherr ayenh iterl-aremer, atha artwa akngerr 5,000 wantek, amern irrpetyapel, aker irrpetyapel.” ");
INSERT INTO aly_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Jesus-el renh-rnem ayernek, “Nthakenty teram arrantherr amern-then aker-then akwetyemel ampwerrk iwek, rernemarl akertang arlkwek-penh?” Rernem ikwer ilelhek, “Anwernantherr amern-then aker-then 12 teram-warl akwetyemel ampwerrk iwek.” ");
INSERT INTO aly_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesus-el renh-rnem ilek, “Arrantherr ayenh iterl-aremer, atharl 4,000 amern-then aker-then wantekarl.” Jesus-el renh-rnem ayernek, “Nthakenty teram arrantherr amern-then aker-then akwetyemel ampwerrk iwek, rernemarl akertang arlkwek-penh?” Rernem Jesus ikwer ilelhek, “Anwernantherr amern-then aker-then 7 teram-warl akwetyemel ampwerrk iwek.” ");
INSERT INTO aly_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesus-el renh-rnem ilek, “Arrantherr ayenh iterl-aremer, ayeng Akngey-kenh Itnweng rlterrk-akert.” ");
INSERT INTO aly_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesus, kwertengerl ikwerenh-rnem-akert apmer Bethsaida-warl alhek. Artwa tawen-arenyel-rnem artwa aparrng Jesus-warl atnwenhek, renh mwerriletyek. ");
INSERT INTO aly_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesus-el aparrng renh tawen-they akwerr-warl atnwenhek. Jesus-el apelhel annga apernek. Jesus-el renh ayernek, “Ntwa apek areyel?” ");
INSERT INTO aly_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Artwa aparrng ra ilelhek Jesus-warl, “Ya, artwernem atha areyel-anem, arwerl-apenyarl arrkay alherleweyel.” ");
INSERT INTO aly_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesus-el annga artwa aparrng renh arnep-arnek arrpem. Artwa Jesus-warl ilelhek, “Atha anaynt-anem areyel.” Ra ingkerrenh-anem arek. ");
INSERT INTO aly_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesus-el artwa renh ilek, “Kel-anem apmer-warl alpa! Tawen-angkwarr alpey-angenh, akwerrel-antey alpa! Ingwerel-rnem-anem ngenh ayerney-ayntekerr, ayenh arlkarewerl-anekerr.” ");
INSERT INTO aly_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesus kwertengerl ikwerenh-rnem-akert apmer Caesarea Philippi-ampeny-warl alhek. Jesus-el kwertengerl ikwerenh-rnem ayernek, “Nthakenh atyeng angkerreyel akngerran?” ");
INSERT INTO aly_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Rernem ikwer ilek, “Ingwer-rneman ngkweng iterreyel John baptise-emiley-angker-arrpanteyarl, ngan ipmepenh itethirremel apey-alpenty-arrpantey. Ingwer-rneman ngkweng iterreyel angkakert Elijah-arrpanteyarl, ahern nhewarl apey-alpenty-arrpanteyarl, irrwerl-they. Ingwer-rneman ngkweng iterreyel angkakert ingwer-arrpanteyarl, ipmepenh itethirremel apey-alpenty-arrpanteyarl.” ");
INSERT INTO aly_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesus-el kwertengerl ikwerenh-rnem ayernek, “Angwenh-arrpantey arrantherr iterl-areyel ayenhan?” Peter ra ilek, “Ngan Christ-arl, Akngeyel awankarl anwernenhantherr alhelekarl, ngenh thwenetyek anwernekantherr-warl, ahern nhewarl.” ");
INSERT INTO aly_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesus-el renh-rnem artwerilek, “Alerl, iley-angenh-antey, ayengarl inngan Christ-an, ingwer-ingerant artwa ingwer-rnem ilenherr-arey.” ");
INSERT INTO aly_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesus-el kwertengerl ikwerenh-rnem ilek, “Moses-kenh-rneman atyeng irrpelthirremel angkerreyel ayenh rernem atwetyek, atyetyart ilkwa tyaty-areny-rnem-then. Ayeng ipma ayntem ingwa atherrel. Ingwa atherr-penh, Akngey-kenh Artwa Anyent Impen ayeng ipmepenh itethirremel akwenteyenh.” ");
INSERT INTO aly_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesus-el aketh-antey anayntilek, angka arraty rarl ingwa atherr-penh ipmepenh akwenteyenh. Peter arleng-antey rtney-alhek, ingwer-rnem-kety, ratherr angkerretyek. Peter arrkngert angkek Jesus ikwer-warl, “Nthakenh rernem ngenh ipmek atwey-angenh, nga intem iteth aneyenh.” ");
INSERT INTO aly_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesus-el Peter renh ilek, “Menty! Ntwa ayenh arrkerneyel, arrenty-kenh angkel, ngan ahern-arenyekarl awelheyel, Akngey-kenh-angkwarr-weny. Akngey atyeng arlkwententyarlan, rernem ayenh menty ipmek atwetyek.” ");
INSERT INTO aly_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jesus-el ingkerrenh akarrilek. Rernem Jesus ikwer-warl apetyek, kwertengerl ikwerenh-rnem-then. Jesus-el renh-rnem ilek, “Arrekantherrenh-angkwarr arrantherr iterrey-angenh. Atyengant arrantherr iterrerl-ayntenherr-arey. Apmwel-rnem arrenhantherr ileyel, arrenhantherr arwa ilpertileyel, ayenhant arrantherr apentekerr, ingwerel-rneman ilperteleyel. ");
INSERT INTO aly_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Atyenhel-rneman ayenh apentetyek, intem-antey rernem ilweyek-atwety, angkepirrey-angenh, angka atyenh ilerl-apayntetyek. Apmwel-rnem renh-rnem atwenty arwerl iylpeyl-atherr-warl arrernemel, kwertengerl atyenhel-rnem ayenh apentetyek. Rernem intem-antey iteth aneyenh. ");
INSERT INTO aly_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","37","Arrantherr ampwal akngerrekant atnyenenty, Akngeyekan arrantherr iylpelirrenty, arrantherr intem iteth aney-angenh. Mwerr-ayteng arrantherr Akngeyekant inkwerelhetyek. ");
INSERT INTO aly_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Apmwel-rnem artwa anyent renh arrkernem, ra atyengety angkepirretyek, ra atyeng ilkelheyang irretyek nyerrirremel, ra ipma intem-antey aynteyenh. Artwa anyentarl atyengety angkepirrenty, ra ipma intem-antey aynteyenh. Ingwer-ingerant Artwa Anyent Impen Akngey-kenh ayeng apey-alpeyenh, alker-areny-rnem-akert, Akngey-kenh rlterrk-akertel. Angka ilkwewarl angkerreyenh-angkwarr atha ileyenh, ‘Artwa nhanyeman atyengety angkepirrek, ra ipma intem-antey aynteyenh. Ayeng ikwerety angkepirrem, rarl atyengety angkepirrek-apeny.’” ");
INSERT INTO aly_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesus angkek ikwer-rnemek, “Awelhenherr-arey atyeng! Akngey aremirreyenh ikwerenh-rnem-warl arlertek ilkwakert, atyetyart ingkerrenhek. Arrantherr ingkerrenhel arlertek ilkwakert renh areyenh arrantherr ilwey-alentyel.” ");
INSERT INTO aly_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","3","Arlta 6-penhan, Jesus-el kwertengerl-rnem irrpety, apwert irrwerl-warl atnwenhek, rernem ilarrerl-alhetyek akngerr-kety, Peter-akerr, James-akerr, John-akerr. Rernem apwert ilkwewarl nganey-alhek. Kwertengerl-rnem-itwel anngetherr Jesus ingwer irrek. Kwertengerl ikwerenhel-rnem arek Jesus renh arnkwa arlter-akertel arrtyernenty, arlertek rlterrk inngel. Ingwerel nthakenh arnkwernem arnwarney-angenh arlter innga mpwaremel. ");
INSERT INTO aly_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Arrwekeleny-atherr, Moses-then Elijah-then Jesus-itwel aremirrek. Ratherr arrwekeleny Akngey-kenh angkakert atherr anenh, ratherr ywerrey-alenty. Ratherr atherr-antey Jesus-itwel angkerrenh. ");
INSERT INTO aly_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kwertengerl Peter anyentan angkek Jesus ikwer, “Ingkartay, awethem ntwa anenhantherrenh atnwenhey-alhek nhewarl. Mwerr anwernantherr lywenty irrpety rnkerney, ingweran ngkwengarl, ingweran Moses-ekarl, ingweran Elijah-ekarl. Ngapek ilkelhenty.” ");
INSERT INTO aly_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Peter apal-apal angkek ikwer-atherr, ratherr ahern-arenyek-athen, rernemarl ater-anem irrek Moses-then Elijah-then aremirrek-kety. ");
INSERT INTO aly_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ikwer-penhan kwenpayel-anem renh-rnem artek. Akngey kwenpay-angkwarr angkek, “Nhanyem alerey atyenh. Ayeng ikwer inkwerelhem. Arrantherr ingkerrenh ikwerant awelhemel anenherr-arey!” ");
INSERT INTO aly_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kwertengerl-rnemel artepang arek angkakert ikwer-atherr. Rernem arek Jesus anyentant-anem rtnerl-anenty. ");
INSERT INTO aly_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jesus atwarrerl-alhek apwert-they kwertengerl irrpetyap ikwerenh-rnem-akert. Jesus-el artwerilek kwertengerl ikwerenh-rnem, “Ingwer-rnemek ileyang aney-alpenherr-arey, arrantherrarl apwert irrwerlek arek-penh. Ayengarl Akngey-kenh Artwa Impenan. Ayeng ilwenty-penhel, ayengarl itethirremel, Akngey-warl irrwerl alpeyenh. Ikwer-penhan arrantherr akngerr-warl-anem iletyek.” ");
INSERT INTO aly_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kel rernem akatek, iley-angenh-antey ingwer-rnem-warl, Jesus-el renh-rnem ilek-angkwarr. Rernem ywarn iterrek Jesus rarl renh-rnem ilelheyelpekek, rarl ipmepenh itethirremel akwenteyenhek. ");
INSERT INTO aly_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kwertengerl ikwerenhel-rnem Jesus renh ilek, “Moses-kenh angka akalty-anthenh-anthenhel-rnem ileyel, ‘Elijah retangkwelarl apetyeyenh arrwekelan, Christ, Akngeyel awank-akerrarl anwernenhantherr alhelek, ran apetyeyenh ingkern-theyarl ahern nhewarl.’” ");
INSERT INTO aly_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Jesus angkek, “Ya, arraty inngarl! Elijah apetyek arrwekel ingkerrenh akaltyiletyek, rernem Akngey-angkwarr apentetyek. Rernem Elijah ikwer irrpelthirrenh, iterl-arey-angenh. Rernem renh irrpelthirremel atwek, ipmek-atwety. Alakenh-anyem rernem Artwa Anyent Impen Akngey-kenh irrpelthirremel atweyenh, ipmek-atwety. Akngey-kenh angka alakenh aynteyel.” ");
INSERT INTO aly_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Rernem alpek kwertengerl ingwer-rnem-warl. Rernem arenhey-alpenh kwertengerl ingwer-rnem, rernemarl kwertengerl Moses-kenh-rnem-then ilerrenh. ");
INSERT INTO aly_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Apmer ikwer-areny-rnem Jesus ikwer inkwerelhek, renh arnaremel. Ikwer-warl rernem anterrey-alhek. ");
INSERT INTO aly_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kwertengerl ikwerenh-rnem Jesus-el ayernek, “Nthakenh arrantherr ingwer-rnem-then ilerreyel?” ");
INSERT INTO aly_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Artwa anyent apmer ikwer-areny Jesus ikwer-warl angkek, “Ingkartay, ngan akalty-anthenh-anthenh mwerr inngarl! Atha awey anyent atyenh akngetyek ngkweng-warl, ntwa mwerriletyek, renh angkeyangilek arrentyel. ");
INSERT INTO aly_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Akngerr-inger arrentyel renh anterrkwenh. Awey ra aytnek, arntek akarlkwelhemel, apelh-angketyarr irremel. Ra arwengkirremel aytnek, akngelhey-angenh irrek. Atha ywarn-antey ayernek kwertengerl ngkwenh-rnem rernem awey atyenh mwerriletyek, arrenty ikwerety irrentetyek. Rernem renh ikwer-they irrenteyek-arrpantey, arrangkwarl.” ");
INSERT INTO aly_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesus angkek, “Akngerr-inger ayeng arrekantherr ywarn arrkernelhek, atha arrenhantherr akaltyileyek. Atyeng arrantherr arlkwentey-angenhel, iylpelantarl awenh. Nthakenh ayenhan arrantherr iterl-arey-angenh, ayengan arlertek ilkwakert? Awey ilenh atyeng-warl akngetya!” ");
INSERT INTO aly_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Rernem akngetyek awey renh Jesus ikwer-warl. Arrentyel awey renh arwengkilek. Intewek ahern-warl. Awey arwengk ayntek, apelh-angketyarr irremel. ");
INSERT INTO aly_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesus-el awey aynikw ikwerenh ayernek, “Arlta ilekel ra arwengkirrenh? Intem-anteyang?” Aynikw ikwerenhel Jesus renh tyernek, “Alakenh ra awey akely ilenh arwengkirrenh artnerrenty-iperrank. ");
INSERT INTO aly_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Akngerr-inger arrentyel renh ipmek atwetyek, ra arrkernelheyel awey ilenhek, rwewarl awey renh akngeynetyek. Ra kwaty-warl aylpenhetyek ilwetyek, kwaty kwenel. Ingwer-rnemel ileyel ngap ran arntety mwerriley-angkeran. Ngapek ra rlterrk-akertan arntety mwerriley-angkeran, aylernekanth amperrngirra! Awey aylernekanthenh mwerrila!” aynikwel Jesus renh ayernek. ");
INSERT INTO aly_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus-el renh ilek, “Nga atyeng iterreyel, atharl awey ilenh mwerriley-angenh. Ntwa ayenh iterl-aremer, ayeng arntety mwerriley-angker.” ");
INSERT INTO aly_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Anamerl-antey aynikwan artnemel angkek, “Ya, ngenh atha tnakeyel, ntwarl renh mwerrilem. Akalty-antha ayenh, mwerranty atha ngenh iterl-aretyek.” ");
INSERT INTO aly_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesus-el arek, akngerrarl akarrirrek ikwer-warl, anamerl-antey. Jesus rap rlterrk angkek arrenty ikwer, “Arrenty, arwengkiley-angker nga! Atha ngenh ilem, tyerrelha awey ilenh-they! Angkepirrey-angenh, intem-antey alpa!” ");
INSERT INTO aly_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Arrenty artewentyel arlkek. Rap awey renh arrewelhilek, rarl tyerrelhek ikwer-they. Awey rap ipmapeny-anem ayntek. Akngerran angkerrenh, “Awey ra kel ilwek!” ");
INSERT INTO aly_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesus-el awey renh akwa anterrkwemel, akwentelhilek. ");
INSERT INTO aly_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jesus warl kwen-warl aylpek. Kwertengerl ikwerenh-rnemel renh ayernek, “Jesus, nthakenh ngkwengantarl arrenty ilenhan awelhemel alpek, anwernantherr ywarnarl ikwer arrkernelhek, arrenty renh irrentetyek. Akaltyila anwernenhantherr, anwernantherr arrenty-rnem irrentetyek.” ");
INSERT INTO aly_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesus-el ilek kwertengerl ikwerenh-rnem, “Arraty arrantherr perayirremelantarl Akngey ikwer-warl, arrantherr arrenty ilenh irrenteman.” ");
INSERT INTO aly_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesus iterrek kwertengerl ikwerenh-rnem akaltyiletyek ament-itwek, akngerr ingwer-rnem-kety. Apmer ikwer-they rernem alhek, apmer Galilee-angkwarr. ");
INSERT INTO aly_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Jesus-el anyelkel renh-rnem ilek, ingwerel-rnem renh awekerr. “Ahelengkwel-rnem ayenh Artwa Anyent Impen Akngey-kenh rernem anterrkwemel atweyenh. Ingwa atherr-penh, ayeng ipmepenh itethirremel akwenteyenh.” ");
INSERT INTO aly_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kwertengerl ikwerenhel-rnem ywarn iterl-arek, rarl renh-rnem ilek. Aterirrekarl rernem Jesus renh ayernekerran. ");
INSERT INTO aly_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Rernem warl kwen-warl aylpey-alhek, apmer Capernaum-itwel. Jesus-el renh-rnem ayernek, “Ilekekarl arrantherr ilerrenhey-alpenh, anwantherrarl apetyenharlan?” ");
INSERT INTO aly_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Rernem nyerrirremel akatek. Jesus ran tyerney-angenh, rernemarl ilkelhenh Atyetyart ilkwa anyent anetyek, kwertengerl ingkerrenhek, Jesus rapeny. ");
INSERT INTO aly_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesus-el renh-rnem ilek, “Arrantherr Atyetyart ilkwa anetyek, arrantherr warrkenh-apeny anetyek, ingwer-rnem arntarnt-aremel.” ");
INSERT INTO aly_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jesus-el ampa akely anyent rnkernek, akwa arrernemel ikwer-warl. Ra renh-rnem ilek, ");
INSERT INTO aly_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Atyeng inkwerelhemel, arrantherrap Akngeyek inkwerelhetyek arrpemarl, rarl ayenh thwenek, ahern nhewarl. Ampa akely ikwer arrantherr inkwerelhenty, arrantherrap atyeng inkwerelhem arrpemarl. Ampa akelyarl arrantherr arntarnt-arem-apeny, arrantherr ayenhan arntarnt-aretyek arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John angkek, “Artwa anyent ingwerel arrenty irrentek itna ngenh-apeny itnewemel, rlterrk ngkwenh-akertel, arrenty-rnem irrentetyek. Anwernantherr renh iltek, ‘Nga ipmelha, ngan ingkart-wenyarl, anwernantherrarl ingkart inngan!’” ");
INSERT INTO aly_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesus angkek, “Menty! Renh tyarlewa! Arratyarl ra ayenh itna itneweyel arrenty renh irrentetyek, ra atyeng apmwel-areth angkey-angenh.” Jesus-el John renh ilek, artwa ilenh iltey-angenharl. ");
INSERT INTO aly_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","“Artwa ilenhan atyeng ilkelheyelarl, ra atyeng irrpelthirrey-angenharl.” ");
INSERT INTO aly_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Jesus-el renh-rnem ilek arrpemarl, “Arraty atha arrenhantherr ileyel, ingwerentyel ngenh apek kwaty anthenty, nga atyenh kwertengerlarl aneyel, Akngey ikwer inkwerelhem. Akngeyel renh mwantyel arntarnt-arem arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ingwerentyel kwertengerl atyenh-rnem arrkernenty, rernem apmweletyek, Akngeyel renh arntety ilkwa antheyenh. Ra irrwampenty awelhekerr, ingwerel nthakenh renh kwaty ampep-warl iwemer, apwert ilkwa ikwer-warl arrernenty itewarl. Artwa ingwerel atyenh-rnem apmwelenty, Akngeyel renh arntety ilkwa antheyenh. Atyenh-rnemarl apmweleyel-kety, artwa ikwer-warl apwert ilkwa itewarl arertnetyek renh kwaty-warl ikwerenp iwemel. Atyenh-rnem ra apmwelerl-anekerr renh iwetyek intem-antey kwaty kwen-warl. ");
INSERT INTO aly_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Artwa itepel apmwel-areth mpwareyel. Artwa anyentel itep-atherr-akertel apmwel-areth mpwareyel-kety, mwerran itep anyent-angkwarr itep renh akemer iwemel, ra itep-atherr-akertan rwilkwel apmwakert aney-kety. Mwerr-ayteng ra anetyek Akngey-kenh apmer-itwek intem-antey itep anyent-akert. ");
INSERT INTO aly_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Artwa ingketyel apmwel-areth mpwareyel. Artwa anyentel ingkety-atherr-akertel apmwel-areth mpwareyel-kety, mwerran ingkety renh akemer iwemel, ra ingkety-atherr-akertan rwilkwel apmwakert aney-kety. Mwerr-ayteng ra anetyek Akngey-kenh apmer-itwek intem-antey ingkety anyent-akert. ");
INSERT INTO aly_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Artwa anngel apmwel-areth mpwareyel. Artwa anyentel annga atherr-akertel apmwel-areth mpwareyel-kety, mwerran annga renh tyerremer iwemel, ra annga atherr-akertan rwilkwel apmwakert aney-kety. Mwerr-ayteng ra anetyek Akngey-kenh apmer-itwek intem-antey annga anyent-akert. ");
INSERT INTO aly_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tyerrel-rnem-tangkwel renh-rnem arlkweyenh rernem rwel-anem ampey-alentyan. Rwa ilkwa ampeyenh intem-antey. ");
INSERT INTO aly_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Thalt-penh atnwenth mwerrarl ayntem, intengirrey-angenh. ");
INSERT INTO aly_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Thalt-weny atnwenth anamerl intengirrem. Thalt mwerr-angker ilenh-apeny ingkerrenh mwerrant-arey anetyek, inkwerelhemel.” ");
INSERT INTO aly_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesus Jordan Ilpay-angkwarr artarnpenhek, apmer Judea-warl alhek. Akngerr akarrirrek ikwer-warl. Ra renh-rnem ingkerrenh akaltyilek. ");
INSERT INTO aly_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pharisee-rnem ikwer-warl apetyek, renh arrkernetyek. Rernem renh ayernek, “Mwerrang artwel anew ikwerenh iwetyek?” Rernem iterrenh renh arrkernetyek, ra apmwel-areth angketyek, rernem renh angka ilkwewarl akngetyek. ");
INSERT INTO aly_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesus-el renh-rnem ayernek, “Ilek-angkwarrarl Moses-kenh angkan aynteyel?” ");
INSERT INTO aly_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Rernem renh ilek, “Moses-kenh angka nhenh aynteyel: ‘Artwa pip-warl itna ingkwernelhemel, arelh ikwerenh pip renh anthemel, arelh renh iwetyek.’” ");
INSERT INTO aly_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesus angkek, “Moses-el arrenhantherr iterl-arenh, arrantherrarl apmwel-areth aneyel, ikwer-angkwarr-anem arrenhantherr law renh anthek. ");
INSERT INTO aly_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Arrantherr iterl-aremer Akngeyel angka nhenh anwekantherr anthek, atharl arrenhantherr ileyel. Akngeyel arelh-then artwethen arrernek, ahern nhenh-warl, ratherr intem iteng anetyek. ");
INSERT INTO aly_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ra artwel amikw-then aynikw-then ipmem-anem ra arnkentyel-anem aneyel itengerrey-alentyan. ");
INSERT INTO aly_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Akngeyel renh-atherr itengilemel anthek artwa renh. Nthakenh ratherr iwerreyang, intem-antey ratherr anetyek. ");
INSERT INTO aly_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nthakenh ingwerel renh-atherr akngakey-angenh.” ");
INSERT INTO aly_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jesus warl kwen-warl aylpenhek, kwertengerl ikwerenh-rnem-akert. Rernem Jesus renh ayernek, “Nthakenharl ntwa Pharisee-rnem ilek?” ");
INSERT INTO aly_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesus angkek, “Arelh ngkwenh ntwa iwem, ntwa arelh ingwer-rnemarl ikngwetyek, ntwa ilenh iwem apmwel-aretharl. ");
INSERT INTO aly_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Arelh anyentel arrkarikw ikwerenh iwerl-alpem, artwa ingwer-warl-anemarl alhemel, apmwel-aretharl.” ");
INSERT INTO aly_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Akngerr Jesus-warl alhek, ampa ikwer-rnem-kenh-akert, ra akapwert renh-rnem arnetyek. Jesus-kenh kwertengerl-rnemel ampa renh-rnem irrentek. ");
INSERT INTO aly_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesus-el arek kwertengerl ikwerenh-rnem ampernemarl irrentek. Ra ahelirrek, angkemel, “Ampernem menty apetyey atyeng-warl! Alakenh ikwer-rnem arrkngert angkey-angenh! Ayeng arlkwenteyel, ampernem ingkerrenh atyeng-warl apetyetyek. Akngey arlkwenteyel, ra Ingkart ikwer-rnemek anetyek. ");
INSERT INTO aly_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Atha arrenhantherr ileyel. Ampernem-apeny arrantherr akarrirretyek Akngey-warl, ikwer awelhetyek, Akngey Atyetyart arrekantherrenh anem.” ");
INSERT INTO aly_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jesus rap ampernem atnyeney-ayntek-anem. Rap akapwert iltyel renh-rnem arnek. Jesus rap ayernek Akngey, ra ampa ingkerrenh atnyeneyek. ");
INSERT INTO aly_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesus rarl anperl-alhek-warl, artwa man akngerr-akert anyentan Jesus ikwer-warl anterrey-alhekarl. Ra arrernelhek kwenirremel, Jesus-itwel angkemel, “Akalty-anthenh-anthenhay, ngan artwa mwerran. Nthakenh ayeng iteth intem anetyek?” ");
INSERT INTO aly_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesus-el renh ilek, “Nthakenharl ayenh mwerran ntwa ileyel? Akngeyantarl ntwa mwerran iletyek. ");
INSERT INTO aly_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ntwa Moses-kenh angka renh iterl-areyelarl, ntwa ingwerenty ipmek atwetyekarl arrangkwarl. Ingwer-kenh anewikw nthakenh ikngwey-angenh. Ampwal-rnem nthakenh irrtyertel iney-angenh. Ingwer-rnemek irrtywerremel iley-angenh, inngant ntwa iletyek. Akngeyek-then ameyek-then awelhetyek.” ");
INSERT INTO aly_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Artwel Jesus renh ilek, “Ingkartay, ayengan law ilenh-angkwarr anek awey akelyank.” ");
INSERT INTO aly_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesus inkwerelhek ikwer, renh awemel, rarl ikwer ilelhek. Jesus-el renh ilek, “Artwa ilenh-rnem, irrepern-rnem, man-weny-rnem ntwa man ingkerrenh-then ampwal-rnem-then renh-rnem antheyna! Ikwer-penhan Akngeyel-anem ngenh arntarnt-arem, ngenh atnyenem. Man antheynenty-penh atyeng-angkwarrant-anem apetya!” ");
INSERT INTO aly_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Artwa man-akert ra iterrek man-then ampwal-rnem-then ingkerrenh ra menty impen anterrkwetyek. Artwa ra amperrngirrek, “Nthakenh-angkwarr ayeng iteth intem-antey aneyenh, man akngerr-akert, ampwal akngerr-akert?” ");
INSERT INTO aly_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesus-el kwertengerl ikwerenh-rnem ilek, “Man-areny ilenh-rneman rernem Akngey-angkwarr anetyek arrangkwarl. Rernem manantarl apenteyel.” ");
INSERT INTO aly_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kwertengerl ikwerenh-rnem ywarn iterrek. Rerneman iterrenh Akngeyelang man akngerran man-areny ilenh-rnem anthentyek-athen. ");
INSERT INTO aly_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Jesus angkek, “Kamwerlan neyl altywer akely-angkwarran nthakenh aylpenhey-angenh, arrangkwarl. Kamwerlan altywer akely-angkwarr aylpey-angenh-apeny, man akngerr-akert-rneman Akngeyel nthakenh anyentiley-angenh ikwerenh-rnem-warl.” ");
INSERT INTO aly_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kwertengerl ikwerenh-rnem ywarn iterrek. Rernem renh ayernek, “Ilek-apeny-rnemant Akngeyel ikwerenh-rnem-warl anyentiletyek?” ");
INSERT INTO aly_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus angkek, “Akngey rantarl iterl-areyel ikwerenh-rnem-warl anyentiletyek, ahern-arenyel-rnem iterl-areyang arrangkw.” ");
INSERT INTO aly_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peter-el renh ilek, “Anwernantherr-alew? Kwertengerl anwernantherran ampwal-rnem menty-anem ipmek, ngenhant-anem apenteyel. Akngeyel anwernenhantherr anyentilem, ikwerenh-rnem-warl?” ");
INSERT INTO aly_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Jesus-el renh-rnem ilek, “Artwa anyentarl alhem, angka atyenh-akert ikwerenh-rnem iwerl-alhemel, angka Akngey-kenh ingwer-rnem ilerl-alpetyek, Akngeyel renh aleth-antey arntarnt-arem. Artwa ra alhentyelan, ahern ikwerenharlap ra iwerl-alheman, ikwerenh-rnem-then, warl ikwerenh-then, Akngeyel renh arntarnt-areyenh, intem-antey. Akngey ra ingwer-rnem renh anthem ilkwatherr, warl ingwer-rnem-then. Apmwernem arrkernelherl-aneyenh, apmwangkwarr apentetyek-arrpantey, rernem-anem arlkarirremel atweyenh. Ra iteth intem-antey aneyenh. ");
INSERT INTO aly_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Akngerr ilkelheyel Akngey-angkwarr apentetyek. Akngerr ilkelheyel Atyetyart arrwekel anetyek, warrkenh iylpareth-rnem-they. Rernem ingkern-they apetyeyenh, warrkenh iylpareth-rnem-warl.” ");
INSERT INTO aly_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesus kwertengerl ikwerenh-rnem-akert Jerusalem-warl alhek. Kwertengerl ikwerenh-rnemel renh apentek. Akngerrelan renh-rnem apentek ingkern-theyarl. Rernem aterirrek, ingwer-rnemel Jesus renh atwekerr apmer Jerusalem-itwek. Jesus arlkek kwertengerl ikwerenh-rnemek, rernem rtnetyek. ");
INSERT INTO aly_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ra ilelhek kwertengerl ikwerenh-rnemek, “Awelhenherr-arey atyeng! Rlengk apmer Jerusalem-warl anwantherr alhem. Ayeng Akngey-kenh Artwa Impenan. Anwantherrarl Jerusalem-el aney-alhem. Ahelengkw-rnemel ayenh anterrkweyenh ikwer-anem. Ayenh rernem akngeyenh, atyetyart tyaty-areny ilkwernem-warl, atyetyart ilkwa Moses-kenh angka akalty-anthenh-anthenh-rnem-warl. Rernem ayenh ahayiwetyek, alethang ahelengkw-rnem-warl, rernem ayenh ipmek atwey-alenty. ");
INSERT INTO aly_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Rernem ayenh irrwaremel whip-el-tangkwel atweyenh, ayenh rernem ipmek atwey-alenty. Ingwa atherr-penh ayeng ipmepenh itethirreyenh.” ");
INSERT INTO aly_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Artwamp Zebedee-kenh alerikw-atherr, James-akerr, John-akerr. Ratherr Jesus renh ayernek, “Ingkartay, aylern ngenh ayernetyek apetyek.” ");
INSERT INTO aly_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesus-el renh-atherr ayernek, “Ya, ilekekay?” ");
INSERT INTO aly_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ratherr renh ayernek, “Nga Atyetyart ilkwa aneyenh, kwertengerl ngkwenh-atherr, aylern apekanap Atyetyart ilkwa arrpemarl aneyenh, ngay? Ntwan aylernenh arraty-antey ilay.” ");
INSERT INTO aly_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesus-el renh-atherr ilek, “Mpwel atyeng mwerranty awelhenherr-atherr. Ahelengkw-rnemel ayenh artewentyel irrwampetyek atweyenh. Mpwel-alew? Ahelengkw-rnemel mpwelenh artewentyel irrwampetyek atweyenh arrpemarl?” ");
INSERT INTO aly_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ratherr ilelhek Jesus ikwer-warl, “Ya, menty ahelengkw-rnemel aylernenh irrwampetyek atwey!” ");
INSERT INTO aly_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Jesus-el renh-atherr ilek, “Inpa, athan iterl-arey-angenharl. Akngeyelantarl iterl-areyel, angwenharl ingweran Atyetyart ilkwa atyeng-apeny aneyenh, atyetyart ilkwan ingkerrenhek aneyenh, ayeng-apeny.” ");
INSERT INTO aly_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kwertengerl ingwer-rnem kwertengerl ikwer-atherr arlkarirrek ratherrarl Atyetyart ilkwa anetyek arlkwentek, Jesus-apeny. ");
INSERT INTO aly_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","43","Kwertengerl ikwerenh-rnem Jesus ra ilek, “Atyetyart ilkwernem apmer arrpanenh aneyel-rnem-apeny-wenyarl arrantherr mwerrant-arey anenherr-arey. Rernem atyetyart awerr ingkerr. Ingwer atyenh-rnem Atyetyart ilkwa anem, mwerr-angkwarr ingkerrenh arntarnt-aretyek. ");
INSERT INTO aly_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Arrantherr Atyetyart ilkwa anem, arrantherr renh-rnem arntarnt-aretyek, warrkenh iylpareth awelheyel-apeny. ");
INSERT INTO aly_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Akngey-kenh Artwa Impen anyent kel apetyek ahern nhenh-warl, ingkerrenh mwerr-angkwarr arntarnt-aretyek iylparethel, warrkenh-rnem iylpareth awelheyel-apeny.” ");
INSERT INTO aly_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesus kwertengerl ikwerenh-rnem-akert apmer Jericho-warl alhek. Akngerrel renh-rnem apentek. Artwa aparrng Bartimaeus, Timaeus-kenh alerikw iwerr impalthel anenh. Rap ingwer-rnem ayerneyam-ayntenh renh-rnem ngkweltyek arlkarewemel. ");
INSERT INTO aly_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ra awek ingwerentyelarl renh ilek, “Jesus Nazareth-areny apetyem nhangkwarr kwertengerl ikwerenh-rnem-akert.” Artwa aparrng arlkek Jesus ikwer, “Jesus, David-kenh alerikw, atyeng amperrngirra!” ");
INSERT INTO aly_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Akngerrel artwa aparrng renh ilek, “Akater ana! Jesus renh arlkareweyang!” Aparrng artewentyel arlkek Jesus ikwer arrpemarl, “Artwa David-kenh! Annga ayenh mwerrila, atha aretyek!” ");
INSERT INTO aly_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesus rtnek, artwa ingwer-rnemek angkemel, “Atnwenhey-alhenherr-arey atyeng-warl, artwa aparrng ilenh!” Rernem artwa aparrng renh ilek, “Aterirrey-angenh, Jesus ikwer-warl apetya!” ");
INSERT INTO aly_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Artwa aparrng kwet ikwerenh iwemel, Jesus ikwer-warl atnarnpenhek, inkwerelhemel. ");
INSERT INTO aly_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesus-el renh ayernek, “Nthakenh atha ngenh ilem?” Artwa aparrng Jesus-warl angkek, “Ingkartay, annga ayenh mwerrila, aremel arrpemarl ayeng anetyek!” ");
INSERT INTO aly_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesus-el artwa renh ilek, “Kel, ntwa ayenh iterl-areyel, ayengan mwerriley-angker. Kel ntwa mwerr arleng aremel-anem nga anem.” Artwa aparrng kel mwerr arleng aremel-anem, Jesus-anem apentek. ");
INSERT INTO aly_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesus kwertengerl ikwerenh-rnem-akert alhek apmer atherr-warl, itnan apmer ratherr Bethany, Bethphage. Apmer Jerusalem-they apmer ratherr arrer-antey, Apwert Alip-arrangarr. ");
INSERT INTO aly_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jesus-el kwertengerl ikwerenh-atherr thwenek, ratherr arrwekel alhetyek, “Mpwelanthan alhenherr-atherr tawen-warl. Mpwelanthap tangkey ateralth rwep lhelhenherr-atherr arwerl-itwek atyeng-warl ayteng-akngey-alpenherr-atherr. ");
INSERT INTO aly_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ingwerentyel mpwelhenh ayernenty, ‘Ilekek mpwelanth rwep lhelheyel?’ Mpwelanth ilenherr-atherr, ‘Ingkart-kenh aylernanth. Ingkartel angkep arrpemarl ngenh anthenhey-alpem.’” ");
INSERT INTO aly_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ratherr alhek apmer ikwer-warl, ratherr arey-alhek tangkey Jesus-elarl ilek-angkwarr-antey. Ratherr rwep renh lhelhenh. ");
INSERT INTO aly_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ingwer-rnemel renh-atherr ayernek, “Ilekek mpwelanth tangkey lheleyel?” ");
INSERT INTO aly_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ratherr renh-rnem ilek Jesus-elarl renh-atherr ilek-angkwarr. Rernem artwa renh-atherr tyarlewek, ratherr tangkey renh ayteng-akngeyneyek. ");
INSERT INTO aly_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ratherr ayteng-akngeynek tangkey Jesus-warl. Ratherr arnkwa tangkey artep-warl arrernek. Jesus tangkey-warl nganek. ");
INSERT INTO aly_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Akngerrel arnkwa ahern-warl panty iweynek, tangkey alhetyek ikwer-angkwarr Jesus-akert. Ingwerel-rnem alperrarl akek. Rernem ayatheweyneyek tangkey Jesus-akert ra alhetyek panty-angkwarr. Tangkey alhek panty-angkwarr Jesus-akert. ");
INSERT INTO aly_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","10","Artwa akngerrel Jesus renh apentek. Ingkerrenh ikwer inkwerelhek arrwekel-warl alhenh-rnem-then, ingkern-theyarl alhenh-rnem-then. Rernem Jesus-ek inkwerelhemel arlkek, “Akngeyel artwa nhanyem anwekantherr-warl thwenek. Anwantherr Atyetyart ilkwek inkwerelhey, Akngeyelarl renh thwenek anwekantherr-warl. Akngeyel renh arntarnt-areyel, ra Atyetyart ilkwa ingkerrenhek aneyel, David-arl anenh-apeny aneyel.” ");
INSERT INTO aly_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesus alhek apmer Jerusalem-warl. Kel ra tyaty ilkwa Jew-rnem-kenh-warl aylpenhey-alhek, ra tyaty ilkwa renh arwa aretyek. Atwerrp-anem, Jesus apmer Bethany-warl anperl-alhek, kwertengerl ikwerenh-rnem-akert. ");
INSERT INTO aly_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ingwepenh Jesus Bethany-they anperl-alhek apmer Jerusalem-warl, kwertengerl ikwerenh-rnem-akert. Ra angayakw-anem irrek ampepel. ");
INSERT INTO aly_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Arleng-they, ra arwerl tywerrk arek. Ra alhek arrer-warl amernek aretyek. Amern aney-angenh arrangkw-antey ra arek. ");
INSERT INTO aly_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesus-el arwerl renh ilek kwertengerl ikwerenh-rnemek, “Arwerl nhepenh nthakenh ingwerentyel amern arlkwey-angenharl intem-antey!” Kwertengerl ikwerenhel-rnem renh awek, rarl alakenh angkenh. ");
INSERT INTO aly_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jesus kwertengerl ikwerenh-rnem-akert Jerusalem-warl alhek. Jew-rnem-kenh tyaty ilkwitwek weker-rnemel aker tharlemilenh, store-arrpantey. Jesus ra arek ingwerel-rnemarl aker tharlemilenh, ra ingkerrenh-antey renh-rnem irrentek, taypel-rnem iwemel, ampwal ngkweltyek-arelh-rnem-then. Ingwerel-rnem aker thiparl tharlemilenh, Jesus-el renh-rnem aker ingkerrenh irrentek. ");
INSERT INTO aly_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jesus arrkngert angkek ikwer-rnem, “Warl nhenh-angkwarr nthakenh aker akngey-angenh.” ");
INSERT INTO aly_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ra renh-rnem ingkerrenh akalty-anthek, “Akngey-kenh angka warl nhel aynteyel ingkerrenh apmer arrpanenh-they akarrirretyek warl nhenh-warl, Akngeyek inkwerelhemel. Irrtyert-awarr-rnemantarl apmer nhenh-warlan arrantherr arrernek!” ");
INSERT INTO aly_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Atyetyart Jew-rnem-kenh tyaty ilkwernem-then Moses-kenh angkakert-rnem-then, rernem awek Jesus-kenh angka. Rernem angkerrenh Jesus ikwer, renh atwetyek. Atyetyart rerneman aterirrek ingwer-rnem-kety, renh anterrkwey-angenh-antey, akngerr rernem Jesus ikwer inkwerelhek-kety. ");
INSERT INTO aly_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Atwerrp, Jesus kwertengerl ikwerenh-rnem-akert alhek apmer Jerusalem-they akwerr-warl. ");
INSERT INTO aly_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ingwepenh-antey, arwerl tywerrk arlenyirrekarl rernem arey-alhek, Jesus-elarl arwerl tywerrk renharl ilek-penh. ");
INSERT INTO aly_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter-el arwerl tywerrk renh alhengk-arek, angkemel, “Ingkartay, ngarl weth arwerl tywerrk nhek akengenty angkek, ra arleny-anem irrek.” ");
INSERT INTO aly_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesus-el kwertengerl ikwerenh-rnem ilek, “Anwantherr inkwerelhetyek Akngeyek, ikwer irrpelthirrey-angenh. ");
INSERT INTO aly_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","24","Arrantherr areyel apwert ilenharl altyweneyel? Arrantherr apwert ilenh ilenty, ra alpetyek kwaty ampep-warl, ra inngarl awelhemel kwaty ampep-warl arrernelhem. Apwert ilenhan arrekantherr awelhemel kwaty ampep-warl arrernelhem-apeny, Akngeyan arrekantherr awelhem, alakenh-anyem. ");
INSERT INTO aly_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Arrantherr Akngey ayernetyek, arrantherr mwerrant-arey-anem anemer. Arrantherr ingkerrenh mwerrant-arey-anem anetyek, Akngeyan anwekantherr ingkerrenhek inkwerelhem, apmwa ingkerrenh-kety, arrekantherrety Akngeyel iwem.” ");
INSERT INTO aly_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesus kwertengerl ikwerenh-rnem-akert Jew-rnem-kenh tyaty ilkwewarl aylpenhek, apmer Jerusalem-itwel. Moses-kenh akalty-anthenh-anthenh-rnem-then, atyetyart ikwer-areny-rnem-then Jesus ikwer-warl apetyek. ");
INSERT INTO aly_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Artwa rernem Jesus renh ayernek, “Angwenhelarl ngenhan thwenek, ingkerrenh mwerr-angkwarr akaltyiletyek, arntety-rnem mwerriletyek?” ");
INSERT INTO aly_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesus-el renh-rnem ilek, “Atha arrenhantherr-anem ayerney, arrantherr atyeng-anem arraty iletyek. Atyengarl arrantherr arraty ilem, atha arrekantherr iletyek, angwenhelarl ayenhan thwenek. ");
INSERT INTO aly_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Angwenhelarl John Baptise-emeley-angker thwenek ahern nhenh-warl, ingkerrenh kwatyel baptise-emiletyek? Akngeyel apek? Ahern-arenyel apek?” ");
INSERT INTO aly_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Rernem angkerrenh, “Nthakenh anwantherr Jesus renh iley-angenh, Akngeyel John renharl thwenek ahern nhenh-warl, anwenhantherr Jesus-elarl arraty ilekerr, anwantherr John ikwer awelheyangarl, akengentyarl John ikwer irrpelthirrenh, renharl Akngeyel thwenek inngarl ahern nhewarl. ");
INSERT INTO aly_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nthakenharl anwantherr iley-angenh Atyetyart ahern-arenyelarl John anwekantherr-warl thwenek, ingwer-rnemarl anwekantherr ahelirrekerr, rerneman iterl-areyel Akngeyel John renh thwenekarl.” ");
INSERT INTO aly_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Rernem Jesus ikwer-warl angkek, “Inpa, iterl-arey-angenh angwenhelarl John renh thwenek, ahern nhewarl.” Atyetyart ilkwernem apatemel, akater-anem rtnenherrenh. Jesus angkek ikwer-rnemek, “Arrantherr ayenh tyerneyang-kety, nthakenh atha arrekantherr iley-angenh, angwenhelarl ayenh thwenek ahern nhewarl.” ");
INSERT INTO aly_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesus-el renh-rnem akalty-anthemel ilek, “Artwa Atyetyart amern grapes lyapelhilenh-ilenh. Artwa anyentel grapes ntang iweyn-ayntetyek, amern lyapetyek, parrik-anem arteynemel, amern grapes lyapetyek parrikel kwen, warl arlpenty-anem artemel, artwa anyent ikwer-warl nganetyek, irrwerl-they arayntetyek, amern ingwerentyel inekerr. Irrkanem kwen angernemel, amern grapes renh lthwetyek, ingketyel-anem lthwemel amern grapes-penh akarr areyirretyek. Atyetyartel warrkenh-rnem arrernek amern grapes arntarnt-arayntetyek, ra apmer ingwer-warl alhey-kety. ");
INSERT INTO aly_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Amern grapes ampeng awaketyek artwa Atyetyart ikwer. Amern grapes arntarnt-arenh-arenhel warrkenh ikwerenh ra thwenek ra anthetyek amern grapes artwa Atyetyart renh, ament arrpemarl. Amern grapes renh artwa warrkenh anyentel ra amern grapes ra arlperrtyilemel anthek artwa ingkerrenhek. Atyetyart anyent ra thwenek artwa warrkenh ikwerenh amern grapes inetyek. ");
INSERT INTO aly_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Rernem artwa warrkenh renh atwek amern grapes-angketyarr-they irrentemel, amern grapes-they alharlkwek. ");
INSERT INTO aly_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Artwa warrkenh Atyetyart ikwerenh-warl apetyek, grapes-weny. Atyetyart ra warrkenh ingwer-anemarl thwenek, amern grapes ikwerenh renh inetyek. Rernem artwa warrkenh ingwer-anemarl irrentemel akapwert atwek. Ra Atyetyart ikwerenh-warl amern grapes-weny arrangkw-antey alpek. ");
INSERT INTO aly_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Atyetyartel warrkenh ingwer-anemarl thwenek, amern grapes ikwerenh inetyek. Rernem warrkenh ingwer-anemarl ipmek atwek. Anyentarl-anyentarl Atyetyartel warrkenh ikwerenh-rnem amern grapes-angketyarr-warl thwenenh, amern grapes inetyek. Rernem warrkenh ingwer-anemarl atwek, ingwer-rneman ipmekarl atwek. ");
INSERT INTO aly_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Atyetyart ikwerenh alerikw anyentant-anem aneyelpek. Atyetyart ra iterrek, ‘Artwa aler anyent atyenh atha thweney, rernem apek nyerrirremel, amern grapes atyenh anthetyek.’ Atyetyart ra alerikw ikwerenh thwenek, amern grapes inetyek. ");
INSERT INTO aly_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Rernem arnarek, atyetyart ikwerenh-anemarl alerikw apetyeyel amern grapes inerl-alpetyek. Rernem angkerrenh, ‘Ay, atyetyart alkenh ikwerenh alerikw-anem apetyeyel, aynikw ikwerenh ilwenty-ketyan ranemarl apmerek-artwey amern grapes-ek Atyetyart aneyenh!’ Amern grapes-angketyarr-they alharlkwelhek, rernem apmer renh grapes-angketyarr Atyetyart aney-kety. ");
INSERT INTO aly_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Rernem alerikw renh ipmek atwek, arrewaly renh iwemel parrik-they akwerr-warl. ");
INSERT INTO aly_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Atyetyart ra apey-alpentyelan, warrkenh amern grapes-angketyarrel aneyel-rnem, renh-rnem ingkerrenh atwetyek, warrkenh ingwer-rnem-anemarl arrernemel, amern grapes-angketyarrek, rernem amern grapes mwantyel arntarnt-arayntetyek.” ");
INSERT INTO aly_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Jesus-el renh-rnem ingkerrenh ilek, “Arrantherr Akngey-kenh angka weth iterl-aremer. Arwerl arlpenty ingwerel iwem apmwek-athen. Arwerl ran mwerr-angkerarl ilenhey, Akngeyelarl warl artek arwerl-penh. Anwantherr apatenty-kety, Akngeyel anwekantherr mwerr-angkwarr warl artetyek. Ayeng arwerl arlpenty impen weth-apeny. Akngeyel ayenh thwenek Atyetyart ingkerrenhek anetyek. Akngey atyeng inkwerelheyel. Ingwer-rnem atyeng inkwerelheyel arrpemarl.” ");
INSERT INTO aly_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Artwa ilkwernem Jew-rnem-kenh rernem iterrek, “Jesus anwekantherr angkeyel, anwantherr artwa warrkenh apmwernem ilenh-rnem-apeny irrekerr.” Rernem iterrek Jesus renh anterrkwetyek, rernemap iterrek artwa ingwer-rnem-ketyarl, menty-anem. ");
INSERT INTO aly_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pharisee-el-rnem-then Atyetyart Herod-el-rnem-then rernem artwa ingwer-rnem thwenek, rernem Jesus renh ayernetyek, ra Atyetyart ilkwernemek akengenty angkentyek. Ra akengenty angkenty, rernem renh ingwer-ingerant anterrkwetyek. ");
INSERT INTO aly_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Artwa anyent Jesus-warl angkek, “Anwernantherr ngenh iterl-areyel, ntwa Angka Akngey-kenh arraty ileyel. Nthakenh nga iterreyel, anwantherr kapment ilkwernem man anthetyek?” ");
INSERT INTO aly_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesus ra iterl-arek, rernemarl ikwer irrtywerremel angkerrenh arraty-angkwarr-arrpantey Ra renh-rnem ilek, “Arrantherr ayenh arrkerneyel, ayeng arrekantherr akengenty angketyek. Ngkwelty atyeng akngetya, atha aretyek!” ");
INSERT INTO aly_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Rernem ngkwelty anyent renh anthek. Jesus angkek, “Angwenharl inngerr-akertan nhenhan?” Rernem ikwer ilek, “Caesar, atyetyart ilkwarlap ran nhenhey!” ");
INSERT INTO aly_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesus-el renh-rnem ilek, “Man-areny-rnemelarl arrenhantherr manek ayernenty, arrantherr man renh-rnem anthenherr-arey, rernem-anem Atyetyart Caesar man renh anthetyek. Akngey-kenh warrk-rnemel man ineynem, arrantherr ingkerrenhel arrernemer arrpemarl, Akngey ikwer-anem rernem man renh arrernetyek.” Rernem Jesus renh awemel, rernem apateyelpek. ");
INSERT INTO aly_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Artwa Sadducee-rnem Jesus ikwer-warl apetyek, renh ayernetyek. Sadducee-rnem iterrenh, arrewaly intem-antey ilwem, ra nthakenh ipmepenh akwentey-angenh. ");
INSERT INTO aly_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Rernem Jesus ikwer angkek, “Moses-el angka anwenhantherr anthek, arelh inpertirrenty, ayteyikw ranemarl arelh ikwer-warl itengirretyek ikwer-atherrenh-anemarl, ampa ingwer-anem anetyek. ");
INSERT INTO aly_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","21","Anew ikwerenhek arelh anyent ran inpertirrek ampeweny-anteyarl, ra ayteyikw ikwerenh-itwel itengirrek arrpemarl. Arelh ra inpertirrek ayteyikw ingwerek-anemarl, ampeweny-antey arrpemarl. Ayteyikw-rnem 6 ilenh-rnem arelh anyent ikwer-itwel-antey, rernem ingkerrenh anyentarl-anyentarl itengirrek, arrewaly ingwer iylpelerlewenty, awayikw ingwer-itwel itengirremel, ra ampeweny arrangkw arrpemarl. Artwa anyent aytey aynek itengirrek, arelh ikwer-itwel-antey. ");
INSERT INTO aly_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Artwa ranem ilwek, ampeweny-antey, arelh anyent ikwerenh ampa ikwer-atherrenh aney-angenh-antey.” ");
INSERT INTO aly_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Sadducee-el-rnem Jesus renh ayernek, “Artwa rernem ipmepenh akemirrenty, artwa angwenharlap arelh ikwerenh inngan?” ");
INSERT INTO aly_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesus-el renh-rnem ilek, “Arrantherr apmwel-areth iterreyel Akngey-kenh angka arrantherr iterl-arey-angenh. Arrantherr Akngey iterl-arey-angenh-antey, Akngeyan rlterrk ilkwakertarl aneyel. ");
INSERT INTO aly_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Rernem ingkerrenh itethirremel alpeyenh Akngey-kenh apmer-warl, rernem aney-alpeyenh intem-antey, arelh-itwel itengirrey-angenh, irrwerl-areny-rnem-apeny. ");
INSERT INTO aly_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Akngeyel arrwekel-antey renh-rnem ilek, rernem angkeparl itethirreyenh, ipmepenh. Arrantherr angka ilenh iterl-arey-areny, angka ilenhan Akngey-kenh pipel arraty inngarl ileyel, arwerl wethelarl lherrm ampenh-apeny. Akngeyel Moses renh ilek, ‘Ayeng ngkwenhek-rnem ingkerrenhek Atyetyart aneyenh, Abraham-ek, Isaac-ek, Jacob-ek.’ ");
INSERT INTO aly_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Rernem iteth-antey aneyarr-alpek Akngey-kenh apmerel irrwerl, Abraham-akerr, Isaac-akerr, Jacob-akerr. Arrantherran apmwel-aretharl iterreyel intem ilwentyek-arrpantey. Rernem ipmepenh itethirremel ingkerrenh alpek Akngey-itwel aney-alpek, intem-antey. Alakenh-anyem, anwantherrarl ilwem, Akngeyel anenhantherrenh angkep arrpemarl itethilem, anwantherrap apmer ikwerenh-warl irrwerl alpem, ra arrenhantherr arntarnt-arayntetyek apmer ikwerenh-itwek intem-antey.” ");
INSERT INTO aly_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Artwa anyentan Jesus-kenh angkek mwantyel awelhenh inkwerelhemel. Ra angkek, “Moses-el angka akngerr anwenhantherr anthek. Ilekek angka Atyetyart inngan, anwantherr renh apentetyek?” ");
INSERT INTO aly_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus angkek, “Angka Akngey-kenh impenan nhanyeman-angkwarrarl atha ileyel, ‘Israel-kenh-rnemay, arrantherr atyeng awelhenherr-arey! Akngey anyent impen aneyel. Ingwer ikwer-apeny aney-angenh arrangkw, rant anyent aneyel. ");
INSERT INTO aly_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Anyent renhant ingkerrenhel apentetyek, anyent ikwerant ingkerrenh iterretyek.’ Angka nhanyem impen. ");
INSERT INTO aly_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Akngey-kenh angka ingweran alakenh aynteyel, ‘Arrantherr ingwer-rnem arntarnt-aretyek, ampa arrekantherrenh arrantherr arntarnt-areyel-apeny.’” ");
INSERT INTO aly_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Artwa Moses-kenh anyent, ra Jesus-ek inkwerelhek, rarl angka arraty-angkwarr ilelhek. Ra angkek, “Ntwa arraty-angkwarr ingkerrenhek ileyel, Akngey anyent impen aneyel ingkerrenhek anwekantherr, ingwer ikwer-apeny aney-angenh arrangkw. ");
INSERT INTO aly_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Amern tyenkerr anwantherr Jew-rnemel anthem Akngey renh. Anwantherr Akngey-kenh angka ilenh-angkwarr anwernantherr apentetyek, amern tyenkerr Akngey-angkwarr anthey. Arraty-ayteng anwantherr ingkerrenh arntarnt-arem, ampa anwekantherrenh anwantherr arntarnt-areyel-apeny ntwarl anwenhantherr ilenh-angkwarr. Akngey-kenh impen apentetyek-ayteng.” ");
INSERT INTO aly_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Artwa anyent rarl angkek arraty, Jesus-el renh ilek, “Nga Akngey-kenh-apenyarl aneyel.” Kel ingwer-rnem akatek, Jesus renh ayerney-angenh. ");
INSERT INTO aly_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jew-rnem-kenh tyaty ilkwitwek, Jesus-el intem-antey renh-rnem akaltyilek. Jesus-el renh-rnem ilek, “Moses-kenh-rnem nthakenh ileyel David-kenh artwa Christ inngan? ");
INSERT INTO aly_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Akngey-kenh Itnwengel ikwer lwewarrernek. David-el ilek, ‘Akngeyel Christ, atyetyart atyenh renh ilek, aylernanth anyent-apeny aneyel.’ Akngeyel renh ilek, ‘Ingwerentyel arlkarirreyel-rnem, atha ingkerrenh renh-rnem menty ipmem.’ ");
INSERT INTO aly_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David-el Christ renh itnewek, ‘Atyetyart atyenh.’ Ayeng Christ Atyetyart ilkwa inngan Akngey-kenh rlterrk inngakertel. Ayengan David-kenh artwa arrpemarl, atyeyart ilkwa David-angkwarr.” Jesus renh awemel, rernem ingkerrenh inkwerelhek. ");
INSERT INTO aly_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesus angkek, “Mwantyel arntarnt-arelhenherr-arey Moses-kenh angkakert ilenh-rnem-kety, kwet arlpenty-akert-rnem-kety, rernemarl ileng tawenel tnakelherl-apeyel-kety, rernem arrenhantherr ilpertilelhekerr. ");
INSERT INTO aly_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Rernem warl kwenel Jew-rnem angkerreyel-warl alheyel, rernemant arrwekel-warl arrernelheyel arrkngelemel ingwer-rnem-kety, rernemant tnakelhetyek. Ingkerrenhel inkwerelhemel amern arlkwetyek, rernemant arrwekel-warl arrernelhetyek arrkngelemel ingwer-rnem-kety, rernemant tnakelhetyek. ");
INSERT INTO aly_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Rernemant warl-rneman arrkngeleyel inpert-rnem-ketyan. Rernem Akngey-warl irrtywerremel angka ilemel-arrpantey. Akngerr-inger, Akngeyel Moses-kenh angkakert-rnem iltem.” ");
INSERT INTO aly_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesus-an anenh tyaty Jew-rnem-kenhel kwen arrerenty, Jew-rnemarl Akngeyek inkwerelhemel angkerrenhel. Ran arenh akngerr, rernemarl ngkwelty ampwal manek-arelh-warl arrernenh. Ingwer-rnemelan man akngerr-akert-rnemelan apetyek tyenkerr man akngerrarl arrernek. ");
INSERT INTO aly_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Arelh inpert-anem apetyek, rap ngkwelty akely atherrant arrernek. ");
INSERT INTO aly_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesus-an angkek kwertengerl ikwerenh-rnemek, “Apetyenh-arey. Atha angka arraty arrekantherr iletyek. Arelh inpertelan ngkwelty akely atherr arrernek, Akngeyekan ra akngerrarl. Ingwer-rnemelan akngerr arrernek, Akngeyekan ra akelyarl. ");
INSERT INTO aly_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Man akngerr-akert-rnemelan amern ikwer-rnem-kenh inek-penh ngkwelty akngerrarl akngey-alpek. Arelh inpertelan ingkerrenharl arrernek. Arrangkw-anem ra aneyel, amern iney-angenh.” ");
INSERT INTO aly_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesus-el arek tyaty ilkwarl Jew-rnem-kenh, kwertengerl ikwerenh-rnem-akertel. Rernem Jew-rnem-kenh tyaty ilkwewarl aylpenhek. Rernemap tyerrelhek tyaty ikwer-they, rernem arek inkwerelhemel. Kwertengerl anyent ikwerenh Jesus-ek angkek, “Tyaty ilkwa mwerr-angkerarl artek nhanyeman.” ");
INSERT INTO aly_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesus angkek, “Ingwer-ingeran ingwerel-rnem atakem-anem, tyaty ilkwa yanh akwarrkirremel, ngkweltyirretyek.” ");
INSERT INTO aly_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Rernem Apwert Alip-warl nganek. Rernem ament rtnenherrenh, Peter-akerr, James-akerr, Andrew-akerr John-akerr. Jesus-anem rernem ayernek, ");
INSERT INTO aly_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ilengerarl ingwerel-rnem tyaty ilkwa ilenh atakeyenh, akwarkirremel ngkweltyirretyek? Ngarl Akngey-kenh apmer-warl alpenty-penhan, angwenhelarl anwernekantherr ileman ngarl ahern nhewarl apey-alpeyenh arrpemarl?” ");
INSERT INTO aly_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesus-el renh-rnem ilek, “Mwantyel arntarnt-arelhenherr-arey, ingwer apetyemarl, arrenhantherr ingwer-angkwarrarl ilekerr. Mwantyel awelheyek ikwer. ");
INSERT INTO aly_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Apmwa ahern-areny ingkerrenh akngerr arlpimpirreyenh ahern nhel arrekantherr-warl, arrenhantherr irrtywerremel iletyek, ‘Ayeng Akngeyel wetharl awank-akerr alhelek, ayeng nhanyem-anem apetyek arrekantherr-warl.’ Akngerr ingwer-rnemel apentemarl angka Atyetyart ilenh-kenh-angkwarr. ");
INSERT INTO aly_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ingwer-rnemel atwerreyel-kety arrantherr aterirrey-angenh anetyek. Ahern-then alker-then ywerreyenh. Aparnpan apmer arrpanenh ahel atwerreyenh. Aparnpan apmer arrpanenh ingkerrenh ahel atwerreyenh ahern-then alker-then ywerrey-alenty. ");
INSERT INTO aly_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Apmer ingwer-areny-rnem-then ahel atwerreyenh. Apmer ingwer-areny-rnem atwerl-apem apmer ingwerek. Ahern nharl akngelheyenhel, ingkerrenh warl-rnem-then akngenherl-akngenhelhileyenh. Ingkerrenh apateyenh amern-wenyel, apmer arrpanenhel. Ingkerrenh arntety ilkwa aynteyenh apmer arrpanenhel. Artwa apmwernemel mwerr-rnem ingkerrenh atweyenh.” ");
INSERT INTO aly_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Jesus-el kwertengerl ikwerenh-rnem ilek, “Mwantyel arntarnt-arelhenherr-arey artwa apmwernem-kety! Rernem arrenhantherr atweyenh warl Jew-rnemarl angkerrenh-itwek. Artwa apmwernemel arrenhantherr akngeyenh angka ilkwewarl Atyetyart-rnem-warl angketyek. Arrantherr angka atyeng-angkwarr ilemer. ");
INSERT INTO aly_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kwertengerl atyenh-rnem alheyenh apmer arrpanenh-warl angka atyenh ilerl-aperl-ayntetyek ahern-then alker-then ywerrey-alenty. ");
INSERT INTO aly_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Atyetyart ilkwel arrenhantherr angka ilkwewarl arrernem, arrantherr ilelhetyek ikwer-warl. Arrantherr aterirrey-angenh angketyek Akngey-kenh Itnweng-akert. Akngey-kenh Itnwengel arrenhantherr akwerrng rlterrkilemel anthem, arrantherr arraty iterl-aremel angketyek. ");
INSERT INTO aly_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Artwel-rnem ayteyikw ikwer-rnem-kenh ahayiwem, ahelengkw-rnemel renh-rnem atwetyek. Ingwer-rnemelan alerikw ikwer-rnem-kenh ahayiwem, ahelengkw-rnemel renh-rnem atwetyek. Ampel-rnem amey ikwer-rnem-kenh-then akngey ikwer-rnem-kenh-then ahayiwem, ahelengkw-rnemel renh-rnem atwetyek. ");
INSERT INTO aly_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Akngerrel arrekantherrety arlkarirreyel ayenharl apenteyel-kety. Arrantherrarl atyenh-rnem ingkerrenh aneyenh, arrantherr intem-antey iteth aneyenh.” ");
INSERT INTO aly_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Arlta ikwerel, ahelengkw Jew-kenh tyaty ilkwitwek aneyenh. Arrantherrarl awem, tyaty ilkwa ikwerelarl Atyetyart ilkwa ra aneyenh, arrantherr Judea-areny-rneman alhetyek, apwert-warlarl. ");
INSERT INTO aly_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Arnkwek iterrey-angenh, arrantherr arwa apwert-warl anpenheyekant. ");
INSERT INTO aly_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kwetek angkep alpey-angenh, menty ra ayntey. ");
INSERT INTO aly_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ayeng amperrngirreyel arelh-rnemek, rernem ampa akely irrepern atnyeneyel-kety, ingwer-rneman thapelarl aneyel-kety ampa akely-rnem-akert. ");
INSERT INTO aly_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Angwenhelarl arlta anyent renhan iterl-areyel? Akngey rantarl iterl-areyelan, anwantherr iterl-arey-angenharl. Arrantherr renh ayernetyek, perayirremel, rwenpelant arlta anyentan anwantherr atnyenetyek, irrerntel renh-rnem atwekerr, irrerntelhelekerr. ");
INSERT INTO aly_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Arlta anyent ikwerel, artwa ingkerrenh arntetyirreyenh, alakenh awank-akerr anwantherr arntety ilkwa atnyeney-angenh. Alakenh anwantherr arntety ilkwa atnyeney-angenh arrpemarl, arntety ilkwa nhanyemarl anwantherr atnyenem-apeny. ");
INSERT INTO aly_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Arrer-anem anwantherr mpwelhem arlta irrpetyapel-anem. Arlta irrpetyap-penh Akngeyel ikwerenh-rnem ingkerrenh arntarnt-areyenh. ");
INSERT INTO aly_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","22","Arrantherr renh-rnem iylpelant awenherr-arey. Arrantherr ikwer-rnem awelhey-angenh, rernem irrtywerremel arrenhantherr ileyel-kety. Akngerr arrekantherr-warl apetyem, arrenhantherr irrtywerremel iletyek ilek-ilek mpwaretyek, renh Akngeyel thwenenty-arrpantey ahern nhewarl, Christ-apeny. Rernem alakenh ingkerrenh-warl ilelhem. Rernem alakenh ingkerrenh-warl ilelhem. Rernem apetyem, arrenhantherr arrkernetyek, arrantherr ikwer-rnem-angkwarr anetyek. Arrantherr iylpelant renh-rnem awetyek, arrenhantherr ilpertileyekarl ilenhan arrkernelheyel. Arrantherr renh-rnem iterl-arem, iylpelant awetyek. ");
INSERT INTO aly_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mwantyel arntarnt-arelhenherr-arey ikwer-rnem-kety, arrenhantherr ilpertilekerr, atharl arrenhantherr ileyel-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","“Arlta anyent ikwerel, akngerr arntety ilkwakert aneyenh. Akngerr apmer arrpanenhel atwerreyenh. Ingkeny-then, alkent-then, antyarr-then rernem ingkerrenh akngelheyenh, Christ anyent impen aremirrey-alenty. Ingkeny-then alkent-then ywerreyenh. Antyarr ingkerrenh irrwerl-they aytneyenh. ");
INSERT INTO aly_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ingkerrenhel ayenh arnareyenh, Artwa Impen anyent Akngey-kenh irrwerl-they apetyenty, rlterrk ilkwakert. ");
INSERT INTO aly_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ikwer-theyan, atha alker-areny-rnem thwenem, rernem alhetyek, apmer arrpanenh-warl, Akngey-kenh-rnem ingkerrenh akarrilenhey-alpetyek.” ");
INSERT INTO aly_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","29","“Arrantherr iterrenherr-arey, arepampeyel akarley ampengirrentyel ngkweng ileyel aherrety ampep renh. Akarleyel ileyel-apeny aherrety ampep arrer-anem, ingkeny-then, alkent-then ratherr arrenhantherr ileyenh, ayeng alerl apey-alpeyenh arrekantherr-warl ahern nhewarl, ahern-then alker-then ywerrey-alenty. Alkent-then akngelhey-angenh, arlan aneyel anyentel-antey. ");
INSERT INTO aly_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","31","Arrantherr apmer nhelarl aneyel-rnem, arrantherr ingkerrenh ilweyenh, atha arrenhantherr inngarl ileyel. Angka atyenhan arraty inngarl aynteyel. Jerusalem-arenyel-rnem tyaty ilkwa Jew-rnem-kenh atakeyenh ngkweltyilemel, arrenhantherr-anem rernem ingkerrenh atweyenh. Innga atha arrenhantherr ileyel. Ahern-then alker-then ywerreyenh. Angka atyenh intem-antey aynteyenh.” ");
INSERT INTO aly_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Anwantherr alker-areny-rnem-then iterl-areyang, ilenger ayeng apey-alpeyenh ahern nhenh-warl. Ingkart Akngey anyent rant iterl-areyel ilenger ayeng apey-alpeyenh ahern nhewarl. ");
INSERT INTO aly_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mwanty-antey arntarnt-arelhenherr-arey! Arlta anyent ikwerel, anwantherr iterl-arey-angenh ilenger ayeng apetyem. ");
INSERT INTO aly_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","36","Atyetyart inwekel alhem-kety, ra warrkenh-rnem arrernerl-alhem, rernem apmer ikwerenh akarerl-ayntetyek. Warrkenh anyentel warl iwerr renh arntarnt-arem atyekel-antey, ingwer-rnem aylpenhey-alhekerr apmer-warl. Warrkenh-rnemel iterl-arey-angenh ilenger Atyetyart ra apey-alpeyenh, atwerrp apek, ingwa ampepel apek, ingwepenh apek. Atyek-antey mpwelhayntenherr-arey atyeng! ");
INSERT INTO aly_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Angka ilenh atha ileyel apmer arrpanenhek, atyeng rernem intem mpwelhayntetyek.” ");
INSERT INTO aly_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Jew-rnem akarrirrenh, amern alerrkw arlkwetyek, Anperarl Alhek “Passover” tyenkerr atnyenetyek, Akngeyek inkwerelhemel. Arlta atherr-inger ayntek tyenkerr-anem arlkwey-alenty. Moses-kenh-rnem-then Atyetyart Jew-rnem-kenh-then, tyaty-areny ilkwernem-then angkerrenh, Jesus renh anterrkwemel, renh ipmek atwetyek, “Alerl-antey ra anayntey, akngerrel anwenhantherr atwekerr, ahelirremel ikwer-they.” ");
INSERT INTO aly_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesus apmer Bethany-itwel anenh, Simon-kenh warlel, kwertengerl ikwerenh-rnem-akert, Simon-arl anenh awank tywen-akert apmer ikwerenhel, ra mwerr-anem aleyan. Rernem anenh-itwek, arelh anyentel anter mwerr-angker thelek, akapwert Jesus renh apernemel, arelh rarl anter renh payemelek man akngerrel. ");
INSERT INTO aly_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ingwer-rnemel arek, anterel ra Jesus akapwert apernek. Rernem angkerrenh, “Ilek ra anter mwerran arimpeyel? ");
INSERT INTO aly_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ilek-ketyarl ra anwenhantherr anthey-angenh? Anwantherr tharlemiletyek, man akngerr inetyek, man-weny-rnem irrepern-rnem anthemel.” ");
INSERT INTO aly_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesus-el ilek, “Arrantherr ahelirreyang ikwer, mwerr-angkwarr ayenh anterel apernek. ");
INSERT INTO aly_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mwerr-angkwarr arrantherr man-weny-rnem arntarnt-arem. Aleth man-weny-rnem anayntem arrekantherr-itwel. Ayeng nthakenh aleth aney-angenh ahern nhel. Lyert arrantherr atyeng iterretyek. ");
INSERT INTO aly_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mareny-angkwarr arelh ra anterel apernek, ingwer-rnemel ayenh awenng-warl akwernetyek.” Jew-rnemel arrewaly anterel apernenh awenng-warl akwerney-alenty. ");
INSERT INTO aly_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","“Atyenh-rnem apmer arrpanenh-warl alhentyel, angka atyenh ilayntetyek, rernem ingwer-rnem ileyenh arelh anyentelarl ayenh anterel akapwert apernek mareny-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kwertengerl anyent, Judas, apmer Iscariot-areny alhek Atyetyart ilkwa tyaty-areny-rnem-warl Jesus renh ahayiwetyek, rernem Jesus renh anterrkwetyek, rernem renh ipmek atwetyek. “Atha arrenhantherr atnwenhey Jesus-warl, arrantherr renh anterrkwetyek.” Artwa ilkwel-rnem Judas renh man alhelek. Judas ra ament-anem iterrek artwa ilkwa renh-rnem ra irrtyertel atnwenhetyek artwa akngerr-kety, Jesus kwertengerl ikwerenh-rnem-akertarl anenh-warl. ");
INSERT INTO aly_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Atyetyart-rnem inkwerelhek, angkarl rernem awek, rernem renh ilek man anthetyek, rarl Jesus ahayiwem ikwer-rnem-warl, rernem renh atwetyek. Judas iterrenh, artwa irrpetyap irrentyelant Atyetyart-rnem-warl Jesus renh ahayiwetyek, rernem renh anterrkwetyek, atwetyek. ");
INSERT INTO aly_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Arlta impen anyent ikwerel, Jew-rnem akarrirrek amern tyenkerr arlkwetyek. Rernem yep-yep akwerrk-rnem atwek, arlkwetyek. Jesus-kenh kwertengerl-rnem apetyek. Rernem renh ayernek, “Nthenh-itwek anwantherr ingkerrenh akarrirrem, anwantherr tyenkerr arlkwetyek?” ");
INSERT INTO aly_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","14","Jesus angkek kwertengerl ikwerenh-atherrek, “Mpwelanth arey-alhenherr-atherr tawenek, artwa anyentel kwatyarl tyampetel akngeyneyel. Mpwelanth renh apenteynenherr-atherr, warl kwen-warl. Artwa renh iley-alhenherr-atherr, ‘Ingkartel aylernenh thwenek, apmerek-artwey ngenh awetyek, nthekek anwantherr tyenkerr arlkwem.’ ");
INSERT INTO aly_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Apmerek-artweyel mpwelekanth iylparrerney, room irrwerl-ampeny anwantherr tyenkerr arlkwetyek.” ");
INSERT INTO aly_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kwertengerl ikwerenh-atherr alhek apmer Jerusalem-warl. Ratherr arey-alhek artwa anyent renh, kwaty ra akngeyn-anenty tyampetel. Ratherr renh apentek, warl kwen-warl. Ratherr kel tyenkerrek atyenhilek arrwekel, Jesus-elarl renh-atherr ilek-angkwarr. Ikwer-penhan ratherr angkep alpek Jesus-warl. ");
INSERT INTO aly_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","18","Ingwel, Jesus kel alhek kwertengerl ikwerenh-rnem-akert amern tyenkerr arlkwetyek. Ra kwertengerl 12 ikwerenh-rnem ilek, “Artwa anyentelan amern arlkweyel nhenhey arrpemarl anwekantherr-itwek, rarl ayenh ahayiweyenh artwa ahelengkw-rnem-warl, rernem ayenh ipmek atwetyek.” ");
INSERT INTO aly_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kwertengerl ikwer-rnem amperrngirrek Jesus ikwer, renharl awekel rarl ilelhek ikwer-rnem. Anyentel-anyentel rernem ilelhek, “Ayengan arrangkwarl! Atha ngenh ahelengkw-rnem-warl ahayiwey-angenharl!” ");
INSERT INTO aly_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesus-el renh-rnem ilek arrpemarl, “Artwa anyentel anwekantherr-itwek amern arlkweyel, artwa anyent rarlap ayenh ahayiwem artwa ahelengkw-rnem-warl. ");
INSERT INTO aly_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Angka Akngey-kenh alakenh aynteyel: ‘Akngey-kenh Artwa Anyent Impen ra ilwem. Artwa anyentel ayenh ahayiwem artwa ahelengkw-rnem-warl, ayenh atwetyek.’ Artwa anyent rarl ayenh ahayiwem-penh, rap irrkngerney-weny-anemarl aneyenh. Ayenh ahayiwek ahelengkw-rnem-warl, Akngeyel renh atwem. Artwa ilenh rarl apmwangkwarr alkenhirrek, rernem renh alkenhilek apmwangkwarr.” ");
INSERT INTO aly_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Jesus-el-anem amern inek, Akngeyek angkemel inkwerelhemel, rarl amern renh anthek. Ikwer-they, Jesus-el amern renh rlweth-akek. Ra kwertengerl ikwerenh-rnem anthek, angkemel, “Amern nhenhan arlka atyenharlap ran.” ");
INSERT INTO aly_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tyampet wayn-akert inek-penh, ra Akngey angkek inkwerelhemel, rarl wayn renh anthek. Ikwer-penhan ra renh-rnem anthek antywetyek. Ingkerrenhel antywek. ");
INSERT INTO aly_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesus angkek, “Wayn nhenhan arrknga atyenharlap ran. Arrknga thelelhentyel ayeng ilwem, ingkerrenh-they apmwa irrarlkeyek. Akngeyel arrenhantherr alhelek, apmwa arrekantherrety iweyek, arrenhantherr anyentelhiletyek ikwerenh-rnem-warl. ");
INSERT INTO aly_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nthakenh atha wayn antywey-angenh arrekantherr-itwek, ahern nhenh-itwekan. Ingwer-ingerant, atha ngkwarl wayn lyerteny antywem, Ingkart Akngey-kenh apmer-itwekant.” ");
INSERT INTO aly_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Rernemap aylelherrek-anem, Ingkart Akngey-warl-athek, inkwerelhemel. Rernem warl ikwer-they Apwert Alip-warl alhek. ");
INSERT INTO aly_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesus angkek, “Akngey-kenh angka alakenh aynteyel: ‘Yep-yep arntarnt-arey-angker atwenty, yep-yep-rnemarl ingkerrenh arlperrtyirremel alhem.’ Ingwel lyert arrantherr alhem, arlperrtyirremel, yep-yep-rnem arlperrtyirremel alhem, weth-apeny. ");
INSERT INTO aly_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Akngeyel ayenh itethelenty-penhant, ayeng arrwekel alhem apmer Galilee-warl.” ");
INSERT INTO aly_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter ilelhek, “Kwertengerl ingwerel-rnem ngenh menty iwerl-alhenty, athan nthakenh ngenh iwerl-alhey-angenh.” ");
INSERT INTO aly_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesus-el Peter renh ilek, “Atha ngenh arraty ileyel, tywek-tywek irrwey ingwepenh arlkey-ayntekerrem-awaty, nga ilelhetyek irrpety-inger ntwa ayenh iterl-arey-angenh akwerrp.” ");
INSERT INTO aly_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Peter-el Jesus renh ilek, “Menty! Ayeng alakenh ilelhey-angenh ikwer-rnem-warl. Atha ngenh iwerl-alhey-angenh, aylernanth-atherr-antey ahelengkw-rnemel atwetyek.” Kwertengerl ikwerenh-rnem ilelhek arrpemarl, renh-rnem ingkerrenh atwetyek ahelengkw-rnemel. ");
INSERT INTO aly_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Rernem apmer arwerl-angketyarr-warl alhek, artna inngewarl, itnan apmer ran Gethsemane. Jesus kwertengerl ikwerenh-rnem ilek, “Artna nhel arrantherr anayntenherr-arey, ayeng alhey-kety Ingkart Akngey-warl angketyek.” ");
INSERT INTO aly_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","34","Jesus-el atnwenhek artwa irrpety ikwerenh-rnem, Peter-akerr, James-akerr, John-akerr, renh-rnemant ra atnwenhek. Jesus ilelhek, “Ayengarl artewentyel iterremel ilwetyek-anem irreyel-kety, arrantherr atyek anayntenherr-arey.” ");
INSERT INTO aly_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jesus ilperr-ayntemel ayntenh, Ingkart Akngey-warl angkemel, “Akngeyay, ayeng ilkelheyel artwa ahelengkw ilenh-rnem ntwa anterrkwetyek atyengety ayenh atwekerr. Ntwa atyengety renh-rnem anterrkwa, nga arlkwententyarlan.” ");
INSERT INTO aly_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ikwer-penhan, Jesus angkek arrpemarl, “Akngey, ngarl rlterrk inngan, ngarl arlkwentem ikwer-rnem ayenh menty arntety ilkwa anthetyek, ipmek atwetyek. Mwerr ayenh menty rernem arntety ilkwa anthey, ayenh ipmek atwey, ngarl arlkwenteyel-angkwarr. Ayeng ngkweng awelheyel.” ");
INSERT INTO aly_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jesus apey-alpek kwertengerl ikwerenh-rnem-warl. Ra arey-alpek renh-rnem ankwantey aynterl-anenty. Ra Simon Peter renh ilek, “Ilekekarl arrantherr ankwantey aynteyel? Arrantherr atyek-anem anerl-anenty, atha arey-alpemer, ngwang ywerrey-angenh ayeng anamerl-antey arrekantherr-warl apey-alpek. ");
INSERT INTO aly_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Arrantherr atyeng atyek arntarnt-arelherl-anemer. Arrenhantherr ingwerentyel arrkernem, arrantherr apmwangkwarr apentetyek. Arrantherr Akngey renh ayernetyek kwenirremel, arrantherr apmwangkwarr apentekerr.” ");
INSERT INTO aly_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesus alhek Ingkart Akngey-warl angketyek irrkaty-angkwarr arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jesus kwertengerl ikwerenh-rnem-warl apey-alpek. Ra arey-alpek renh-rnem ankwantey aynterl-anenty arrpemarl. Rernem atyek-anem aney-angenh, renh-rnem ankwel intem-antey itnatwenh. Jesus-el renh-rnem akwentelhilek, rernem akater-anem ingkerrenh anenh, nyerrirremel. ");
INSERT INTO aly_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jesus alhek Ingkart Akngey-warl angketyek arrpemarl. Jesus kwertengerl ikwerenh-rnem-warl apey-alpek, ra arey-alhek renh-rnem ankwantey aynterl-anenty arrpemarl. Jesus-el renh-rnem ilek, “Arrantherr ankwantey arrpem intem aynteyel. Kel, anyent-inger arrantherr ankwayntek. Artwa ahelengkw-rnemarl Akngey-kenh Artwa Anyent Impen ayenh rlengk anterrkweyenh. ");
INSERT INTO aly_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ingkerrenh akwentenherr-arey, anwantherr alhetyek. Artwa anyent ilenh arrantherr areyel? Ilenhel-anyem ayenh ahayiwek, artwa ahelengkw-rnem-warl, ayenh rernem anterrkwetyek.” ");
INSERT INTO aly_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","45","Apmwernem Judas ikwer-angkwarr apetyek, Jesus renh iylparrernetyek. Ra ikngwerl-alpek ahelengkw-rnem Jesus ikwer-warl. Apmwernem ayen arlpenty-akert apetyek, walth-then-akert. Atyetyart ilkwernem-then Atyetyart Moses-kenh-rnem-then, rernem ahelengkw renh-rnem thwenek. Judas-elarl renh-rnem ilek arrwel, ikwer-rnem iylparrernetyek, “Athan artwa weth renh arrwantyem, arrantherraw renh anterrkwenherr-areyarl.” Ahelengkw-rnemel Jesus renh alhengk-arek, Judas-elarl ilek-penh. Judas Jesus ikwer-warl apetyek angkemel, “Atyetyartay.” Ra angkek alakenh Judas, renh ra anterrkwemel arrwantyek. Jew-rnemel artwa ingkerrenh rlwatirremel, rernem arrwantyirremel. ");
INSERT INTO aly_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kel ahelengkw-rnemel renh anterrkwek, Judas-elarl arrwantyek-warl. ");
INSERT INTO aly_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kwertengerl anyent Jesus-kenhel Atyetyart ilkwekenh warrkenh renh iylpa rlweth-akek. ");
INSERT INTO aly_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesus-el renh-rnem ilek, “Ilekekarl arrantherr apetyek irrtyertelan, ayenh arrantherr anterrkwetyekan? Ayen arlpenty-rnem-thenan, walth-rnem-thenan arrantherr akngetyek, ayenh atwetyek, ayeng apmwa atwey-angker-arrpantey! ");
INSERT INTO aly_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Athan angka Jew-rnem-kenh apmweley-angenharl. Akngerr-inger atha arrenhantherr akalty-anthenh angka Akngey-kenh, ilerl-anemel, Jew-rnem-kenh tyaty ilkwitwek. Arrantherr ayenh anterrkwemer ikwer-antey artwa akngerrel arenty-angkwarr. Arraty-wenyarl alakenh arrantherr ayenh anterrkwek. Alakenh Akngey-kenh angka nhenharl pipel aynteyel-angkwarr, mwerran ayenh arrantherr anterrkwemer.” ");
INSERT INTO aly_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kwertengerl ikwerenh-rnem aterel anterrek, arlperrtyirremel. ");
INSERT INTO aly_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Artwa anyent arnkweweny ra pantyelant artelhek. Ahelengkw-rnemel renh anterrkwenh panty-they, ra tyerrelhemel anterrek arnkweweny-anem. ");
INSERT INTO aly_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesus renh anterrkwek ahelengkw-rnemel, warl Atyetyart ilkwekenh-warl akngeynemel. Atyetyart alkenh ingwer-rnem akarrirrek Moses-kenh-rnem ikwer-itwel. ");
INSERT INTO aly_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peter-el ingkern-they apentek ahelengkw-rnem Jesus-arl rernem atnwenheynek. Peter aney-alhek ahelengkw-rnem-itwel, warl ilkwa Atyetyart-kenh arrerenty. Rwel-anem rernem ingkerrenh anek, arlterrngirremel. ");
INSERT INTO aly_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Atyetyart ilkwernem rernem angkerrenh, “Angwenharl ikwer akaltyan rarl renh awek-penhan, Jesus rarl law anwekantherrenh apmwel-areth angkekan? Angwenhel anwenhantherr arraty-antey, rarl awek-penhel? Anyent ingwerel anenhantherr ileyek arraty-antey, rarl Jesus renh awek-penhel. Intem-antey rernem renh-rnem ayernenh, rernem arraty iletyek.” ");
INSERT INTO aly_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Angka ingkerrenhel ilenh ingwerek-ingwer irrtywerremel. ");
INSERT INTO aly_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ingwer-rnemel ilenh irrtywerremel, “Tyaty Jew-rnem-kenh ilkwa aketyek angkenty-arrpantey ra ilek, renh arlta irrpety-inger-penh tyaty ingwer-anemarl artetyek angkenty-arrpantey.” ");
INSERT INTO aly_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Alakenhaym, angka ingwerek-ingwer rernem ilenh irrtywerremel. ");
INSERT INTO aly_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Atyetyart ilkwel-rnem iterl-arey-angenh ingwerek-ingwer artwa ingwerel-rnem angkan ilenh, Jesus angkenty-arrpanteyarl angka amentew-ament ingkerrenh. Rernem apatek Jesus renh atwekerr. ");
INSERT INTO aly_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Atyetyart ilkwel Jesus renh ayernek, “Nthakenh rernem ngkweng angkerreyel? Ntwa anwernekantherr arraty ilay!” ");
INSERT INTO aly_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesus akater anek, tyerney-angenh. Atyetyart ilkwel ayernek arrpemarl, “Nga arraty-antey atyeng ilelha! Ngenhang Christ Akngeyel anwernenhantherr alhelek, ngenh thwenetyek anwernekantherr-warl, ahern nhewarl?” ");
INSERT INTO aly_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesus ikwer ilelhek, “Ya, arrantherr areyenh, ayeng iteth alpenty Ingkart Akngey-warl intem ayeng aney-alpeyenh ikwer-itwel. Ayeng Atyetyart ilkwa aneyenh intem-antey, Akngey-apeny. Arrantherr ayenh areyenh, Ingkart Akngey-kenh apmer-they apey-alpenty.” ");
INSERT INTO aly_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Artwa Atyetyartel arnkwa ikwerenh ilterrek angkemel, “Nhenhey apmwel-areth angkeyel Akngeyek. Ran nhenhey Atyetyart Akngey-apeny-arrpanteyarl ilelheyel! ");
INSERT INTO aly_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Arrantherr renh awek rarl angkek Akngeyek. Nthakenh arrantherr iterreyel, nthakenh rarl apmwel-areth Akngeyek angkek?” Rernem angkerrenh, renh ipmek atwetyek. ");
INSERT INTO aly_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Artwa ingwer-rnemelan apelharl iwek, Jesus ikwer irrpelthirremel. Ahelengkw-rnemel renh annga rag-el artek aparrng ilemel, renh atwemel. Artwa ahelengkw-rnemel renh ayernek, “Angwenhel ngenh atweyel?” Kel ahelengkwel Jesus renh atwek arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peter-an rwelarl anenh, arlterrngirremel irrernt-kety. ");
INSERT INTO aly_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kwey warrkenh Atyetyart tyaty-areny-kenhel Peter renh alhengk-arek ayernemel, “Ngan alhenhap Jesus Galilee-areny-angkwarr. Atha ngenh weth arekan, ngay?” ");
INSERT INTO aly_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Peter ilelhek, irrtywerremel, “Inpa, atha iterl-areyangarl renh.” Peter anperl-alhek keyt-warl rtney-alhemel keyt-itwel. Tywek-tywek irrwey ra awek. Anyent-inger ra arlkek. ");
INSERT INTO aly_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kwey warrkenh ra Peter renh arek arrpemarl. Ra ilek artwa ingwer-rnem-warl-anem, “Nhanyemarl ran Jesus-angkwarrarl alhenhan, atharl renh alhengk-arekan.” ");
INSERT INTO aly_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Peter irrtywerremel ilelhek arrpemarl, “Arrangkw, atha iterl-arey-angenh renh.” Artwa ingwer-rnemel Peter renh ayernek, “Inngarl nga alhenh Jesus-angkwarr apmer Galilee-elan. Galilee-areny-apeny nga angkeyelan.” ");
INSERT INTO aly_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Peter-el irrtywerremel ilelhek arrpemarl, “Ingkartel arem, arraty inngay ayeng angkem. Ayeng akwerrp, atha renh iterl-arey-angenh.” ");
INSERT INTO aly_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Peter-el renh tywek-tywek irrwey awek, rarl ingwepenh arlkey-ayntek. Peter ra iterl-arek, renharl Jesus-el ilek-angkwarr, “Tywek-tywek irrwey ntwa ingwepenh arlkey-ayntekerr-awaty ntwa atyeng irrtywerremel irrpety-inger iletyek.” Kel Peter artnenh-anem. ");
INSERT INTO aly_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Moses-kenh Atyetyart-rnem-then Atyetyart tyaty-areny-rnem-then, atyetyart Jew-rnem-kenh-then, rernem akarrirrek ingkenyarl tyerrelhenhey-alhekel, angkerretyek. Rernem angkerrenh, rernem Jesus renh arertnemel atnwenhetyek Atyetyart ilkwa ikwer-warl. Rernem Jesus renh atnwenhek Atyetyart Pilate ikwer-warl, renh rnkernek Atyetyart Pilate-itwel. ");
INSERT INTO aly_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pontius Pilate-el Jesus renh ayernek, “Nganap Atyetyart ilkwa Jew-rnem-kenh, ngay?” “Ya, arraty nga angkeyel,” Jesus-el tyernek. ");
INSERT INTO aly_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Atyetyart ilkwel-rnem Jesus renh ayntarrp-ilek, ra irrtywerremel ilelhenty-arrpantey. ");
INSERT INTO aly_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilate-el Jesus renh ayernek arrpemarl, “Ngenharl rernem ayntarrp-ileyel, nthakenh ngan angkem?” ");
INSERT INTO aly_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesus akater-anem rtnenh, tyerney-angenh. Pilate ywarn-antey iterrek, Jesus rarl akatemel-anem rtnenhew. Pontius Pilate-el Jesus renh ahayiwek, rernem renh atwetyek. ");
INSERT INTO aly_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Amern Anperarl Alhek “Passover” tyenkerr arlkwek-penh, Pilate-el artwa anyent tyayl-they tyarlewetyek. ");
INSERT INTO aly_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","8","Artwa Barabbas ahelengkw atwenh-atwenh tyayl-itwek anenh. Jew-rnem akngerr Atyetyart Pilate ikwer-warl alhek, renh ayernetyek, ra artwa anyent tyayl-they tyarlewetyek. ");
INSERT INTO aly_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Atyetyart ilkwel renh-rnem ayernek, “Angwenh athan tyarlewem tyayl-theyan? Jesus, atyetyart ilkwa Jew-rnem-kenhang atha tyarlewem?” Ra ilkelhenh Jesus renh tyarlewetyek. ");
INSERT INTO aly_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilate iterrenh Atyetyart tyaty-areny-rnem Jesus-kety arlkarirrenh, ingwer-rnem ingkerrenh ikwerantarl inkwerelhek. Ikwer-theyan rernem renh rnkernek. ");
INSERT INTO aly_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Atyetyart tyaty-areny ingwer-rnemel Jew-rnem ingkerrenh ilek, “Arrantherr Pilate ilenherr-arey, ra artwa Barabbas tyayl-they tyarlewetyek.” ");
INSERT INTO aly_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Atyetyart Pilate-el renh-rnem ayernek arrpemarl, “Angwenh athan tyarleweman? Atyetyart alkenh Jew-rnem-kenh arrantherr ileyel, nthakenharl atha renhan ilem?” ");
INSERT INTO aly_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Jew-rnem ikwer arlkek, “Renh arwerl iylpeyl-atherr-warl tywena, renh atwetyek.” ");
INSERT INTO aly_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pontius Pilate-el renh-rnem ilek, “Nthakenh anwantherr renh ayntarrp-iley-angenh, ran anwekantherr akengenty mpwarey-angenharl.” Rernem arlkek arrpemarl, “Renh arwerl iylpeyl-atherrek tywenenherr-arey, renh atwetyek!” ");
INSERT INTO aly_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pontius Pilate ikwer-rnem awelhenh. Ra Barabbas renh tyarlewek, tyayl kwen-they. Rap ahelengkw-rnem ilek, rernem Jesus renh whip-el atwayntetyek, rernem ahelengkw ingwer-rnem-anem Jesus renh anthetyek, rernem renh arwerl iylpeyl-atherrek tywenetyek, renh ipmek atwetyek. ");
INSERT INTO aly_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ahelengkwel-rnem Jesus renh atnwenhek warl ilkwa rlterrk-warl, warl Atyetyart-kenh-warl. Ahelengkw ingwer-rnem ikwer-rnem-warl akarrirrek. ");
INSERT INTO aly_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Rernem arnkwa ikwerenh lhelhek ikwer-they, kwet arlpenty irrpwerlel-anem renh akwernek. Rernem Atyetyart-kenh mwekart-apeny mpwarek, arreylp-angketyarr, Jesus akapwert-warl arrernemel. ");
INSERT INTO aly_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Rernem renh arrkentelhilemel ilek, “Nganap Atyetyart ilkwa Jew-rnem-kenh.” ");
INSERT INTO aly_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Rernem apelh ikwer-warl iwek, akapwert-anem renh arwerlel atwemel, ikwer irrpelthirremel, renh tnakeyek-arrpantey. ");
INSERT INTO aly_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Rernem irrpelthirremel kwanthenh-penh, rernem arnkwa irrpwerl lhelhek, arnkwa ikwerenh-warl-anem akwernemel. Rernem renh atnwenhek, rernem renh atanthetyek, arwerl iylpeyl-atherr-warl. ");
INSERT INTO aly_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Artwa anyent, itnan Simon apmer Cyrene-areny apetyenh tawen Jerusalem-warl, apmer ingwer-they. Ahelengkw-rnemel arwerl iylpeyl-atherr-anem arrernek Simon ikwer-warl, ra arwerl renh aylpwer-akngeyn-ayntetyek. Simon-el arwerl iylpeyl-atherr iytarr-akngeynenh. Simon ikwer-atherrenh aynikw anenh, Rufus-atherr, Alexander-atherr. ");
INSERT INTO aly_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ahelengkw-rnemel Jesus renh apwert ilkwewarl atnwenhek, apwert itnan Golgotha, ranap apwert akarnng-apeny. ");
INSERT INTO aly_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ahelengkw-rnemel arwerl mwerr-angker alperr-penh ngkwarl wayn-warl thelek, Jesus renh anthemel, ra irrwampenty awelhekerr, renh arlelpiletyek, renh atanthenty arwerl iylpeyl-atherrek. Jesus-el ngkwarl menty arek, antywey-angenh. ");
INSERT INTO aly_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Ahelengkwel-rnem arnkwa ikwerenh lhelhek, ahern-warl iwemel. Ingwepenh, rernem Jesus renh arwerl iylpeyl-atherr-warl atanthek. Rernem arwerl iylpeyl-atherr Jesus-enp irrwerlilek, arraty rnkernemel, ra arwerl iylpeyl-atherrel irrwerl ilwetyek-atwety. Ahelengkwel-rnem arrkenirrek arnkwa Jesus-kenhek, antengiletyek. ");
INSERT INTO aly_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ahelengkw-rnemel pip arrernek arwerl iylpeyl-atherr-warl angkakert ikwer-rnem-kenh, “Nhanyem Atyetyart Jew-rnem-kenh.” ");
INSERT INTO aly_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Artwa apmwatherr rernem arrernek Jesus-angkwarr ilwetyek. Artwa apmwatherr rernem rnkernek, akwerrant-atherr, Jesus ampepekilemel. ");
INSERT INTO aly_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jew-rnem akngerr angkepelarreng alhenh, Jesus ikwer irrpelthirrerl-anemel, “Weth ntwa anwernenhantherr ilek, ntwarl tyaty ilkwa Jew-rnem-kenh akenty-penhel, ntwa tyaty ilkwa ingwer-anemarl anwernekantherr artelhetyek akwel. Ngan arlertek ilkwakert akwel. ");
INSERT INTO aly_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nga ament-anem itethelhila! Atwarra arwerl iylpeyl-atherr-they!” ");
INSERT INTO aly_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Atyetyart ilkwa tyaty-areny-rnem-then Moses-kenh-rnem-then, rernem ikwer irrpelthirremel, angkepelarreng alhenh. Rernem arrkent ikwer angkerrenh, “Ran artwa ingkerrenh arntety-penh itetheley-angker, ranem ament-anem itethelhiley! ");
INSERT INTO aly_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ra ament itethelhilenty, anwantherr ingkerrenhelarlap iterl-areman, rap Atyetyart ilkwa Jew-rnem-kenharl aneman.” Artwa apmwa weth-atherrel Jesus renh arrkentelhilenh arrpemarl. ");
INSERT INTO aly_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ingkeny arlta ampepel ingwerrerl-alhek, atwerrpek-atwety. ");
INSERT INTO aly_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jesus-el Akngey renh ayernek, “Akngey atyenh, Akngey atyenh, ilek-kety ntwa ayenh menty arek?” ");
INSERT INTO aly_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Akngerr Jesus-arrangarr rtnenherrenh. Rernem Jesus renh awenh, angkemel, “Jesus ra arlkeyel Elijah ikwer. Elijah Akngey-kenh angkakert arrwekeleny ran.” ");
INSERT INTO aly_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Artwa anyentel ngkwarl wayn-warl antywer renh apelyilek, Jesus renh arwerl arlpenty-they arrakert renh irrpelhilek angkemel, “Anwantherr mpwelhey Elijah ikwer-warl apetyetyek, renh arwerl iylpeyl-atherr-they tyarlewenty anwantherr aretyek.” ");
INSERT INTO aly_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kel Jesus arlkek, ilwemel. ");
INSERT INTO aly_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Rag arlpenty Jew-kenh tyaty ilkwitwek ilterrelhek, irrwerl-they kwenek-atwety. ");
INSERT INTO aly_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Atyetyart ahelengkw-rnem-kenhel arek Jesus ilwenty. Ra angkek, “Jesus ranap Akngey-kenh Alerikw inngarl ilenhey.” ");
INSERT INTO aly_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Akngerr ingkerrenh rernem akarrirrek, renh aretyek, Jesus arwerl iylpeyl-atherrek ilwey-alenty. Mary Magdala-areny, Mary ingwer-then, James-then Joses-then, ikwer-atherrenh amikw, ingwer itnan Salome, rernem ikwer-rnem-itwel rtnenh. Rernem irrkaty-rnem-antey, kwertengerl-rnem Jesus-kenh rernem arntarnt-arenh, apmer Galilee-itwel. ");
INSERT INTO aly_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Jew-rnem ltyerrenh warrk-weny-anem, arlta Saturday-el, nthakenh arrewaly akngey-angenh awenng-warl. Arlta Saturday ikwer-rnem-kenh anek, ltyerrey-angker. Joseph artwa mwerr apmer ingwer-areny itnan Arimathea. Friday-el atwerrp, ra alhek Atyetyart Pilate-warl, renh ayernetyek arrewalyek. ");
INSERT INTO aly_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilate ra iterrek ywarn. Pilate-el ahelengkw Atyetyart renh ayernek, “Jesus ra iteth-antey?” ");
INSERT INTO aly_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ahelengkwel renh ilek, “Jesus kel ilwek.” Pilate-el Joseph renh ilek, ra arrewaly renh arwerl iylpeyl-atherr-they atwarrelhiletyek, renh awenng-warl akwernetyek. ");
INSERT INTO aly_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joseph-el arnkwa mwerr-angker payemelek, arrewaly renh ikwerenp akwernetyek, awenng-warl. Joseph-el arrewaly renh arwerl iylpeyl-atherr-they atwarrelhilek, renh mwerr-angkwarr awenng-warl akwernetyek. Arnkwa mwerrel-anem ataperrelek, ra intey awenng-warl akngek. Joseph-kenhel-rnem arrewaly renh intey awenng-warl akwernek, apwert ilkwa arriw-itwek arrkngertewemel. Intey awenng renh ilkwilek, awank-akerr, arrewaly-anem intey-warl akwerney-alenty. ");
INSERT INTO aly_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdala-arenyel-then, Mary Joseph-kenh amikwel-then ratherr arek Joseph-el apwert ilkwa arriw awenngek arrkngertewenty. ");
INSERT INTO aly_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Saturday ingwel, arelh-rnem alhek, Mary Magdala-areny-akerr, Salome-akerr, Mary, James-kenh amikw-akerr. Rernem alhek anter inetyek, arrewaly renh apernetyek anterel. ");
INSERT INTO aly_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sunday atwemengkel-antey rernem awenng-warl alhek. ");
INSERT INTO aly_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Rernem angkerreynenh, “Artwa angwenhel apwert yanh arnangelhileyenh intey-theyant?” ");
INSERT INTO aly_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Rernem arenhek awenng intey rarl arrwekel-antey altywerirrek. ");
INSERT INTO aly_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Rernem intey-warl aylpenhek. Rernem arek artwa anyent arnkwa arlter-akert anerl-anenty. Rernem aterirrek ikwerety. ");
INSERT INTO aly_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Artwa anyent angkek ikwer-rnem, “Aterirreyang atyengety arrantherr! Atha arrenhantherr iterl-areyel, arrantherr apetyek Jesus Nazareth-areny aretyek, rarl arwerl iylpeyl-atherrel ilwek. Nhenh Jesus ayntey-angenh, arrangkw. Ra iteth akwentemel alpek. Nhenh arrantherr areyel, arrangkw. Arenherr-arey, nhelanyemarl ra ayntenh ipman! ");
INSERT INTO aly_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jesus kel alhek apmer Galilee-warl arrwekel-antey. Arrantherr alhentyel, arrantherr renh arey-alhem apmer Galilee-ek. Arrantherr Peter renh ilenherr-arey kwertengerl ingwer-rnem-then, atharl arrenhantherr ilek-angkwarr.” ");
INSERT INTO aly_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Rernem intey-they aterel anterrek, artwa ikwerety. Rernem arrewey-alhek, ywarn iterl-aremel. Rernem angka iley-angenh-antey, Jesus-arl akemirrek-penh. ");
INSERT INTO aly_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesus kel itethirremel akwentek awenng-they. Rap aremirrek Mary Magdala-areny ikwer-warl, Mary irrkaty ikwer-warl, rarl arrenty 7-pel ikwer-they awank-akerr irrentek-warl. ");
INSERT INTO aly_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mary rarl arek-penh, kwertengerl Jesus ikwerenh-rnem ra ilek. Jesus ikwer kwertengerl ikwerenh-rnem apal amperrngirremel artnenh, ra intem ipmek ayntentyek-athen. ");
INSERT INTO aly_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mary renharl awek-penh, kwertengerl ikwerenh-rnem iterrek Mary-el irrtywerremel ilentyek-athen. ");
INSERT INTO aly_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jesus aremirrek kwertengerl ikwerenh-atherr-warl ampepel, apalarl ratherr tawen-they alpenh-warl. Ratherr Jesus renh arek arlka lyerteny-akert-anemarl ra aremirrek. ");
INSERT INTO aly_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kel, ratherr tawen-warl alpek. Ratherr kwertengerl ingwer-rnem iley-alpek, ratherrarl Jesus renh arek. Rernem renh-atherr iylpelant awenh irrpelthirremel, ratherr irrtywerremel ilerl-anentyek-athen. ");
INSERT INTO aly_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ingwer-ingeran Jesus aremirrek kwertengerl ikwerenh-rnem-warl-anem, rernemarl amern arlkwenh-warl. Jesus-el renh-rnem ilek, “Rernem ayenharl arek-penhel-rneman, inngarl arrekantherr-warl ilek, arrantherr ikwer-rnem irrpelthirrenharl, irrtywerremel ilenty-arrpanteyarl.” ");
INSERT INTO aly_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesus-el renh-rnem thwenek. “Angka atyenh apmer arrpanenhek iley-ayntenherr-arey! ");
INSERT INTO aly_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Rernem atyeng irrpelthirrey-angenh awelhem, rernem kel baptise inem, Ingkart Akngeyel renh-rnem intem-antey atnyenem. Ingwerel-rnem ayenh iylpelant awem irrpelthirremel, rernem ipma intem-antey aynteyenh. ");
INSERT INTO aly_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Artwa anyent atyeng irrpelthirreyang awelhem, ra atyenh rlterrk ilkwakertel arrenty ingkerrenh-they irrentem. Artwa anyent rarl atyeng mwerr-angkwarr awelhem, ra tyakarl angka ingwerek-ingwer angkem. ");
INSERT INTO aly_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Artwa anyent rarl atyeng awelhem, irrpelthirreyang, ra rtnwem anterrkwem tnhwey-angenh, arrangkw. Artwa anyent rarl atyeng awelhem, irrpelthirreyang, ra apmwa ilwenh-ilwenh antywem, nthakenh ra ilwey-angenh. Artwa anyent rarl atyeng awelhem, ra arntety-rnem mwerrilem ingkerrenh, itep ikwerenhel arnep-arnemel.” ");
INSERT INTO aly_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kel ilek-penh, Jesus ra alker-warl alpek, Ingkart Akngey-itwel aney-alpek intem-antey. ");
INSERT INTO aly_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kwertengerl ikwerenh-rnemel ilerl-apenh apmer arrpanenhek. Akngey-kenh rlterrk-akertel rernem arrenty ingkerrenh-they irrentek. Rernem arntety-rnem mwerrilek. Ingwerel-rnem renh-rnem arek, angkemel, “Akngey-kenh akalty inngarl nhernemey!” ");
INSERT INTO aly_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ya, Theophilus, angka nhanyem ngkweng. Akngerrelan angka Jesus-akert ingkwernenh. Rap ilek-ilek mwerr-angker mpwarew, rarl anenhel ahern nhenh-itwew. ");
INSERT INTO aly_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ingwer-rnemelan renh arew, rarl iteth-tangkwel ahern nhenh-itwew anenh. Rernemap apmer arrpanenh-warl alhenh, angka ingwer-rnemew ilerl-apenh. ");
INSERT INTO aly_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Rernem atyeng awank-antey ilew. Ayengan akaltyerrew mwanty, renh-rnem ayernemel. Ayengan ilkelhew arrpemarl artewentyel, angka nhenh Jesus-akert ngkweng ingkwerneyew. ");
INSERT INTO aly_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ntwa angka nhenh alyepel iterl-areyel. Nthakenh nga iterreyel? Arraty apek? Apmwel-ayeth apek nhenhey? Alakenh atha ngkweng ingkwerneyel, ntwa arraty-angkwarr iterl-areyew-awaty. ");
INSERT INTO aly_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Awank-akerr Herod-an apmer ilkwa Judea-ampeny-itwew atyetyart alkenh anenh. Apmer ikwer-itwew artwa anyent anenh, itnan Zechariah. Zechariah ran Abijah-wenh-antey anew, ranap artwa rltwa tyaty ilkwa Jew-rnem-wenh-arenyarl. Akelty ikwerenh itnan Elizabeth, ranap Aaron-wenh-anteyarl anew. ");
INSERT INTO aly_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ratherrap Akngey-wenharl anenh, arraty-angkwarrarl. Aletharl ratherr angka Akngey-wenh rlterrkan arraty-angkwarr apentenh. Ratherrap Akngeyew awelhenh, rarl ikwer-atherr angkenhew. ");
INSERT INTO aly_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Zechariah-then Elizabeth-then ampwatherr, ratherrap ampeweny-antey anenh, Elizabeth-el nthakenh ampa atnyeney-angenh, arrangkw. ");
INSERT INTO aly_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ingwer-ingweran Zechariah tyaty ilkwitwew Jerusalem-itwew warrkerrenh. Aherrety nhel ayntew ikwer-rnem-wenh-anem, warrkerreyew warl ikwer-itwew. Abijah-wenh-rneman rernemap artwa rltwernemarl. ");
INSERT INTO aly_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Rernemap artwa anyent rlwanenh, tyaty ilkwewarl aylpeyew. Rap arrtyenh arwerl irrtywel mwerr-angker intey-angker Ingkartew. Arlta ikwerel-antey rernemap Zechariah-anem rlwanew. Rap kwen aylpenhew, arwerl irrtywel arrtyeyew. ");
INSERT INTO aly_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ingwer-rneman akethelarl akarrerrenh, Akngey-warl-athek angkaynteyew. ");
INSERT INTO aly_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zechariah-an kwenelarl rtnenh, Ingkart-wenh antyerl ikwer-itwel aremerrey-alhew-anem. Rap arrer-antey rtnenh apwert ilkwangkwarr, rwa rarl ampenh-angkwarr. ");
INSERT INTO aly_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zechariah rarl arew, antyerlarl rtney-alhew, rap ikwer-wety artewentyel innga atererrew. ");
INSERT INTO aly_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Antyerlan ikwer angkew, “Zechariah, atererrey-angenh! Ntwa Akngey awey akelyew ayernenh, ran ngenh awenharl. Akelty ngkwenhel awey akely atnyeneyenh. Ntwap renh John itnewa. ");
INSERT INTO aly_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mpwelantharl renh atnyeneyenhel, rap mpwelenhanthenh irrngerney-anthem. Akngerran ikwer irrngerney irreyenh arrpemarl. ");
INSERT INTO aly_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ranap Inweng Akngey-wenh-akertarl, renharl atnyeneyenhan. Rarl ilkwerreyenhel, Ingkartel renh alkenh inngarlap ileyenhan, rap ngkwarl wayn nthekwern antywey-angenh, arrangkw. ");
INSERT INTO aly_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","17","Ingkart Akngeyel arawerrng ikwerenh antheyenh, rarl artwa angkakertew Elijah-ew awank-akerr anthew-apeny. Akngeyelap renh Inweng ikwerenh-akert Jew-rnem-warl thweneyenh. Ingwer-rnemelan aweyenh angkerl-anenty, rernemap Ingkart Akngey-warl angkeperrenhey-alpeyenh. Rap akwerrng arratyeleyenh. Amperneman aynaynewantherrenh-then awelherreyew. Ingwer-rneman Akngeyew awelhey-angenh-rnem, rap akwerrng arratyeleyenh, rernem arraty-anem aneyenhan. Alakenh-anyem alerengkw ngkwenh rap akngerr arratyeleyenh. Rernem Ingkartew mpwelheyenh, rarl ahern nhenh-warl apetyeyenh.” Alakenh-anyem antyerl Zechariah-ew angkew. ");
INSERT INTO aly_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zechariah-el antyerl ayernew, “Inngang angka ngkwenh arraty? Aylanthan ampwatherr-anem! Nthakenh aylanth awey akelyan atnyenem?” ");
INSERT INTO aly_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Antyerlel renh tyernew, “Ayengan Gabriel. Ayeng Akngey-itwew rtneyel irrwerl-itwew. Ra ayenh thwenew, angka mwerr-angker ngkweng ileyew. Nganap atyeng awelhey-angenharl! ");
INSERT INTO aly_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ranap inngarl aynteyenh! Nhepenh-anyem nga angkey-angenh-anem, ngap akerter-anem arlengew-alenty aneyenh, ngarl atyeng irrpeltherrew. Alerengkwarl ngkwenh atnyeneyenhel, Akngeyelap ngenh angkiparreleyenh arrpemarl.” Alakenh-anyem antyerlan ikwer angkew. ");
INSERT INTO aly_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Zechariah-an antyerlew tyaty ilkwitwew awelhenh, ingwer-rneman akethel-antey rtnenherrenh. Rernem ikwer mpwelhenh, aketh-warl tyerrelheyew. Rernemap iterrenh, “Nthakenh irrew, kwenan arleng-alenty ywerrew?” ");
INSERT INTO aly_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Rarl kwen-they tyerrelhenhey-alpew, ranap nthakenh iley-angenharl, rarl antyerl arew. Rap akerter-theyant iltyerrenh, ikwer-rnem angkeyew-arrpantey. Rerneman iterl-arew-anem, rarl altyerr mwerr-angker warl kwen-itwew arew. ");
INSERT INTO aly_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zechariah rap tyaty ilkwitwew arlta 7-ew-atety anenh. Rarl warrk irrenh-penh, rap apmer-warl-anem alpew. ");
INSERT INTO aly_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ikwer-penhan akelty ikwerenh Elizabeth alerl-antey mpwelhenh. Rap warl kwen-itwew alkent 5-ew-atety anenh, rarl nyerrerrenh, ingwer-rnemel renh arewerr. ");
INSERT INTO aly_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Rap angkenh ament-antey, “Ayengan ampeweny anenh. Akngerrel ayenh kwanthenh, rernemap ayenh nyerrel anthenh. Aleyan Akngeyel ampa atyeng anthew-anem. Kel-anem, ayeng aketh-warl tyerrelhem. Ayenharl akngerrel areyenh, rernem atyeng inkwerelheyenh, Akngeyelan ayenh arntarnt-arayntemarl!” ");
INSERT INTO aly_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabeth warl ikwerenh-they tyerrelheweng-arey, Akngeyel antyerl Gabriel thwenew tawen anyent-warl, itnan Nazareth, apmer Galilee-ampeny-itwew. ");
INSERT INTO aly_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Rap antyerl thwenew, kwey aleyak Mary-ew angkeyew. Mary-anap Joseph-ewant mpwelhenh, ranap artwitwewan ayntey-angenh, arrangkw-antey. Joseph ran atyetyart David-wenh-antey anew. ");
INSERT INTO aly_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Antyerlan Mary-warl apetyew, rap ikwer angkew, “Ya, Mary! Ingkart ngkwengel-arleng aneyel, ngkweng inkwerelhemel!” ");
INSERT INTO aly_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mary-an apatew. “Ilek-athek wenh ra alakenh atyeng angkew?” ");
INSERT INTO aly_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Antyerlan ikwer angkew, “Mary, Akngeyan ngkwengarl inkwerelheyel. Atererrey-angenh. ");
INSERT INTO aly_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ngap mpwelheyenh, awey akely atnyeneyew, ntwap renh Jesus-arl itneweyenhan. ");
INSERT INTO aly_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Rarl ilkwerreyenhelan, atyetyartarlap ingkerrew ra aneyenhan. Ingkerrelanap renh Alerikw Akngey-wenh ileyenh. Ilkwarlap ra aneyenh, Akngey ilkwa irrwerl-areny-wenh Alerikw. Akngeyel renh rlwanew, atyetyart alkenh aneyew, David anenh-apeny, David-wenh-rnem-they. Awank-akerr ra atyetyart alkenh Israel-wenh-rnem-wenh anenh. ");
INSERT INTO aly_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ampengkw ngkwenhan atyetyart alkenh Israel-wenh-rnem-wenh intem-antey aneyenh.” ");
INSERT INTO aly_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mary-el antyerl ayernew, “Aleyak ayeng, akwerrp-antey. Nthakenh atha ampa akely atnyeneman?” ");
INSERT INTO aly_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Antyerlan ikwer angkew, “Inweng Mwerr-angker irrwerl-arenyan ngkweng-warl apetyeyenh, rap ngenh kwenpayel-apeny arteyenh. Awey akely renh atnyenentyel, akngerrelanap renh Alerikw Akngey-wenh ileyenh. ");
INSERT INTO aly_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ntwa arelhampw Elizabeth iterl-areyel. Ingwer-rnem alakenh angkerrenh, ‘Elizabeth-el nthakenh ampa akely atnyeney-angenh, arrangkw!’ Ranap mpwelheyel-anemarl. Alkent irrpety-penhel ra awey akely atnyeneyenh. ");
INSERT INTO aly_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Inngarlap ra! Akngeyel ilek-ilek anthey-angker!” Alakenh-anyem antyerl angkew Mary-ew. ");
INSERT INTO aly_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mary-an antyerlew angkew, “Inngarlap alakenhan, ngarl atyeng angkeyel. Ayengan Akngeyewant-anem aneyenh. Ayengan ikwer mpwelheyew, Ingkartel ampa akely atyeng antheyew-atety.” Antyerlan alpew-anem, Mary-an iwerlelpew-anem. ");
INSERT INTO aly_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ikwer-penhan ingwer-ingwer Mary-el apmer ikwerenh iwerl-alhew, Elizabeth arerl-alpeyew. Rap anamerl-antey apmer akely ikwer-warl alhew apwert ilkwangketyarr-warl, Judea-ampeny-itwew. ");
INSERT INTO aly_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Rap Zechariah-wenh apmer-warl alhew, Elizabeth-ew arlkew-anem. Rap kwen aylpenhew, Elizabeth-anem atnyeney-alheyew. ");
INSERT INTO aly_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","44","Elizabeth-el Mary arlkewarl awew, rap artewentyel inkwerelhew. Elizabeth-an Inweng Mwerr-angker-akertel Mary-ew angkew, “Ngan inngan inkwerelhem arelh ingwer-rnem-angkwarr artewentyel. Ampengkw ngkwenh ilkwa aneyenh ampa ingwer-rnem-angkwarr. Ayengan arelhampwarl. Ilekew nga apetyew, ayenh areyew? Atha ngenh awew, ngarl atyeng arlkew, ayeng awelhemel artewentyel inkwerelhew. Akngeyel ngkweng ampa mwerr-angker inngarl antheyenh. Ran ngkweng artewentyel innga inkwerelheyel, ampa akelyewan inkwerelheyel arrpemarl. Ampengkw ngkwenhan atyetyart ilkwa aneyenh, ingwer-rnem-weny-apeny aney-angenharl. ");
INSERT INTO aly_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Angka wethan, Ingkart-wenh antyerlelarl ngenh ilew, rarl innga wenh aynteyenh. Akngeyan ngkweng inkwerelheyel, ngarl ikwer awelhew, rarl innga ngkweng angkew.” Alakenh Elizabeth-an Mary-ew angkew. ");
INSERT INTO aly_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","49","Mary rap alakenh Ingkartew aylelhenh-anem: “Yew! Akngeyan atyeng iterreyel, ilek-ilek atyeng mpwareyew. Ayengan kwey aleyakarl, Akngeyewant anem, akely-anteyarl ayeng. Atha renh nakem. Ayengan Akngey-warl-athek inkwerelheyel, rarl ayenh arntarnt-areyel. Nhepenh-anyem akngerran angkayntem, ‘Mary-ay! Akngeyel ilek-ilek ngkweng mpwarenh!’ Akngey mwerr-angker innga. ");
INSERT INTO aly_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Akngeyel angka ikwerenh-warl awelheyel-rnem arntarnt-arem; arrwekel-penh-rnem-then, rlengkeny-rnem-then, ingkern-penh-rnem-then. ");
INSERT INTO aly_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ran rlterrk ikwerenh lwewarrernew. Ingwer-rneman mwerr-arrpantey ilelhenh-rnemarl, Akngeyelan renh-rnem arlperrtyelew, rap renh-rnem ikwer-wety intem-antey thwenew. ");
INSERT INTO aly_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ingwer-rneman atyetyart ilkwernem anenharl, renh-rnem arrangkwarl arrerneynew. Arrangkwarl anenh-rnem rerneman atyetyart ilkwernem ikwer-rnem-angkwarr aneyenh. ");
INSERT INTO aly_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ingwer-rneman angayakw amern-wenyarl anenh. Akngeyelan ikwer-rnem anthew, mwerr-angker arlkweyew. Ingwer-rneman akngerr-akertarl. Akngeyel ilek-ilek akngew, rap renh-rnem arrangkw-anemarl anthew. ");
INSERT INTO aly_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Awank-akerr Akngey arrwekeleny-rnemew angkew, rarl ikwer-rnemel-arleng anayntem, ampernemel-arleng-then. Abraham-ew ra angkew, ran ikwer ilkelheyel ampernemew-then, rap aleth-antey arntarnt-arem. Inngarlap ran arntarnt-arenh iylpelerrey-angenharl. Iylpelerrey-angenh Israel-wenh-rnemew. Intem-antey ra arntarnt-arayntenh, renh-rnem atnyenerl-anemel.” Alakenh-anyem Mary-an Akngey-warl-athek aylelhenh. ");
INSERT INTO aly_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ikwer-penh Mary Elizabeth-wenh apmer-itwew alkent irrpetyew anew, rap angkep-anem apmer ikwerenh-warl Nazareth-warl alpew. ");
INSERT INTO aly_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mary-elan Elizabeth iwerlelpew, angkep-anem apmer ikwerenh-warl alpew. Elizabeth-elan awey akely-anem atnyenew. ");
INSERT INTO aly_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ingwer-rnem angkew Elizabeth-wenh-rnemew apmer ikwer-areny-rnemew-then alakenh, “Ingkart Elizabeth-ew iterrenh!” Rernemap ingkerrenh inkwerelhew. ");
INSERT INTO aly_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kel awey akely renh atnyenew, arlta 7-penh ingwer-rnem Zechariah-wenh apmer-warlarl alhew. Rerneman renh artweleyew Jew-rnem-wenh-angkwarr. Rernemap iterrenh, renh itneweyew Zechariah-apeny. ");
INSERT INTO aly_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Elizabeth ranap ikwer-rnem arrngert angkew, “Mpwelhenh-arey! Zechariah itnewey-angenh. John-arl renh itneweyewan!” ");
INSERT INTO aly_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Rernem ikwer angkew, “Ilekewarl ntwa John-an itnewem? Mpwelewanthenh-rneman itnan alakenh ayntey-angenh!” ");
INSERT INTO aly_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Rernemap akerterant-anem iltyerrenh, angkeyew-arrpantey Zechariah-ew, awey-wenh aynikwew. Rernemap ayernew, “Ilek itna ntwa awey akelyewan arrernem?” ");
INSERT INTO aly_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zechariah itep iltyerrew, renh-rnem ayerneyew ampwal alyelkew ingkwerneyew-arelhew. Rap alakenh ingkwernew, “Itnan John.” Rernem ywarn iterrew. ");
INSERT INTO aly_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Arntwapeny Zechariah-el itna ingkwernew, Akngeyelan renh angkiparrelew, Zechariah rap renhan nakew. ");
INSERT INTO aly_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ingwer-rnemarl rtnenherrenh-rnem atererrew, rernemarl Zechariah awew. Ywarn rernem iterrew, apatew-anem. Rernem alherlewew, angka ingwer-rnemew ilerl-apenh, apwert-angketyarr-itwewarl anenh-rnemew, Judea-ampeny-itwew. ");
INSERT INTO aly_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Akngerrel angka ampa akely John-akert awew. Rernem iterl-arew, ra Ingkart-wenh Inweng Mwerr-angker-akert. Rernemap ayernerrew, “Ampa akely yanh ilkwerreyenhelan, nthakenharlap ra irreyenhan?” ");
INSERT INTO aly_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","John-wenh aynikw Zechariah rarl alakenh-anyem Inweng Mwerr-angker-akert aylelhenh: ");
INSERT INTO aly_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Anantherran Israel-wenh-rnem, anantherr Ingkart nakem, Akngey anewantherrenh. Rap anewantherr-warl apey-alpew anaynteyew, anenhantherrenh arntarnt-araynteyew. Rap apmwa anewantherr-wety irrarlkeyew, anenhantherrenh angkep ikwer-warl-athek pweytelemel. ");
INSERT INTO aly_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ran atyetyart David-apeny thwenew, awank-akerrarl anenh-apeny, David-wenh-antey. Ran anenhantherrenh iteth atnyen-ayntem Akngeyew. ");
INSERT INTO aly_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","72","Alakenh-anyem angkakert Akngey-wenh-rnemel ilenh awank-akerran. Akngeyelan anenhantherrenh ingwer-rnem ilkelhey-angenh-wety iteth atnyen-ayntem, atwerreyelarl-wety-then. Ra anenha