﻿USE sofia;
DROP TABLE IF EXISTS sofia.alw_vpl;
CREATE TABLE alw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES alw_vpl WRITE;
INSERT INTO alw_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","መሲህ ኢስ ደዉዴለከ እብራሂም ደቦች ከለቀሙስ ህት ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","እብራሂም ኢሳቀ እሎ፤ ኢሳቅ ያቁበ እሎ፤ ያቁብ ይሁደለከ አመስ ኦሱተ እሎ፤ ");
INSERT INTO alw_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ይሁድ ትማሬች ፋሬሰለከ ዛረ እሎ፤ ፋሬስ ሄስሮነ እሎ፤ ሄስሮንን አራሜ እሎ፤ ");
INSERT INTO alw_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","አራም አምናደበ እሎ፤ አምናደብ ነኣሶነ እሎ፤ ነኣሶንን ሱልማነ እሎ፤ ");
INSERT INTO alw_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ሰልሞን ራኣቤች ቦኤዘ እሎ፤ ቦኤዝ ሩቴች ኢዮቤደ እሎ፤ ኢዮቤድን እሴዬ እሎ፤ ");
INSERT INTO alw_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","እሴይን ዎመ ደዉዴ እሎ፤ ደዉድን ኦርዮ ጫች ሱላይማነ እሎ፤ ");
INSERT INTO alw_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ሱላይማንን ሮብኣመ እሎ፤ ሮብኣምን አብየ እሎ፤ አብየን አሳፈ እሎ፤ ");
INSERT INTO alw_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","አሳፍን ኢዮሳፌጠ እሎ፤ ኢዮሳፌጥን ኢዮራመ እሎ፤ ኢዮራምን ኦዝየ እሎ፤ ");
INSERT INTO alw_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ኦዝየን ኢዮኣታመ እሎ፤ ኢዮኣታምን አካዘ እሎ፤ አካዝን ሕዝቅያሰ እሎ፤ ");
INSERT INTO alw_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ሕዝቅያስን ምናሴ እሎ፤ ምናስን አሞጼ እሎ፤ አሞጽን ኢዮስያሰ እሎ፤ ");
INSERT INTO alw_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ኢዮስያስ እስራኤል ኡመቱ ባብሎነ አገንት መርቶ ወክት እኮንያኔለከ አመስ ኦሱተ እሎ። ");
INSERT INTO alw_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ባብሎናን አገንት መርቶች ኤተሮን እኮንያን ሰላቴለ እሎ፤ ሰላቴልን ዘሩባቤሌ እሎ፤ ");
INSERT INTO alw_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ዘሩባቤልን አብዮደ እሎ፤ አብዮድን ኤልያቄመ እሎ፤ ኤልያቄምን ኣዞረ እሎ፤ ");
INSERT INTO alw_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ኣዞርን ሳዶቀ እሎ፤ ሳዶቅን አኪመ እሎ፤ አኪምን ኤልዮደ እሎ፤ ");
INSERT INTO alw_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ኤልዮድን አልዓዛረ እሎ፤ አልዓዛርን ማታነ እሎ፤ ማታንን ያቁበ እሎ፤ ");
INSERT INTO alw_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ያቁብን ዩሱፈ እሎ፤ ዩሱፍን «መሲህ» ዬኖ ኢሰ እልቶ መርየመ ምኒ አነ እኮ። ");
INSERT INTO alw_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ህካን እኮቤቺሃ እብራሂሚች ደዉዴ ኢለ ቶነ ሾሎ እለንሸ፤ ህትን ደዉዴች ባብሎን አግተእ መርቶኢሃ ኢለ ቶነ ሾሎ እለንሸ እኮ፤ ህትን ባብሎን አግቶች መሲህ ኢለ ቶነ ሾሎ እለንሸ። ");
INSERT INTO alw_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","መሲህ ኢስ እለንሹ ህትጎታን፤ አመስ መርየመ ዩሱፍሃ ኣሰንት ዮሃኔን ደቀንቱዕናን ጠሊለ አያን ወልቃን ላፈተ እካን መኑ ጉዕሙንኩ ደጎ። ");
INSERT INTO alw_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ጠዕሜ ዩሱፍ ፈየ መንቹ እኮቤቺሃ መናን ፍሹዕነ ጠወስ አጉሮተ ሰውዬእ። ");
INSERT INTO alw_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ህካን ሰውየንን ቀርች መላይኬቹ ሀቄን ለልስ «ዩሱፋ ደዉዴ ቤቶ! ኣሴመሄ መርየመ ላፈተ እኮኢሁ ጠሊለ አያኒን እኮቤቺሃ እሴተ ኣእቶተ ዋጅቶት። ");
INSERT INTO alw_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","እሴን ለቤ ጩል እልታአ፤ እስን ኡመትስ ጩቢችሰ ጡምሰኖቤቺሃ ሱዕመስ ‹ኢሰ› ይታንት» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ሁኩን ጉዕሙንኩ እኮሁ ቀርቹ ነብዬቾን ");
INSERT INTO alw_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«ሀፍቱት ላፈተ እክ ለበ ጩል እልታአ፤ ህትን ሱዕመስ ‹አማኑኤለ› ይት ገእታአ» አማኑኤለ ዩ «መገኑ ኒንት» ዩሃን። ");
INSERT INTO alw_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ህካን እኮቤቺሃ ዩሱፍ ግሰኛች በቅዬ ወክት ቀርች መላይኬቹ አዘዦገን መርየመ ኣኤሴ። ");
INSERT INTO alw_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ጠዉ እኮጎሬ መርየመ ዎኔሴ ጩል እልቶተ ኢለ እሴን ደቀሞበአ እቅ፤ ዩሱፍን እለሞ ጩል «ኢሰ» ይ ሱዕመ ፉሼስ። ");
INSERT INTO alw_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ሄሮድስ ዎመ እኮ ዘማን ኢስ ይሁድ ባዶን ቤተሌም ከተማን እለሞ ወክት ቤዜተ ዎለኣ ኤንኬዕናሙ መኑ ሸርቂች ዬሩሳሌመ አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","እሰን «አይሁድ ዎመ እሀኖ ጩሉ እለሞሁ ሀከንቤቾንት? ሸርቂን ቤዜተ ለዕን እሲሃ ሰገንዶተ አሜንቶም» ይት ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ዎሙ ሄሮድስ ህካን ሞጮጬ ወክት አበ ህልቆ፤ ህትን ዬሩሳሌም መኑ ጉዕሙንኩ ህልቆኡ። ");
INSERT INTO alw_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","እስን ኡመትስ ቂስ አዎንሳኑተለከ ሕግ አስተማረተ ጉዕመንከ ጭምአዕይ «ቡረሞ መሲህ እለመኖሁ ሀከቤቹ» እሁስ ጠዕሜሰ። ");
INSERT INTO alw_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","እሰን «ይሁድ ባዶን ቤተሌም ከተማን እለመኖ፤ መሰንትስ ነብዬቹ ");
INSERT INTO alw_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","«ቤተሌም ከተመ! አት ይሁድ ባድ አዎንሳኖች ጉዕሚችን ሆፈኣንትበአ፤ ህካን እኮቤቺሃ ኪች ኢ መነ እስራኤለ አገረኖለከ አዎንሰኖሁ እለመኖ ይ ከተቦኡ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ህከኒች ኤተሮን ሄሮድስ ህከ ኤንኬዕናሙ መነ ማጭ ገእ ጠወስ ፎፎጅ ቤዜት ለልቶ ወክት ጠዕም ደጎ። ");
INSERT INTO alw_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","እስን እሰንተ «መርቴን ህከን ጩልተኔሃ ጡመገ አጥረመቼ፤ ደጌንተጎሬ አሜቴን ኩልቴነንተኤ፤ አኒሁ ሰገዶተ መራም» ይ ቤተሌመ ሶኮ። ");
INSERT INTO alw_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","እሰን ሄሮድሴች ሞጮጭት ፉልቶ ወክት ሸርቂን ለኦ ቤዜት አዎንስተንሰ ለኦ ወክት አበ ሙንደኦኡ፤ ሁኩ ሸርቃን ለኦ ቤዜንት ጩሉ ዮ ምኒ ቡዕላን ኡርታኢሃ ኢለ አዎንስቶሰ። ");
INSERT INTO alw_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","እሰን ህከ ምኒ ኣጎ ወክት ጩሉ አማንተስ መርየማን ሜጡበ ዮኢሃ ለእ ብሬስ ጉሉጵት ሰገዶኡ፤ ህከኒች ኤተሮን ሳጥነ ፈንት ዎርቀ፥ ህጣነለከ ከርቤተ ዬኖ ህጣነ ፉሽት ኣቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ሁኩ ኤንኬዕናሙ መኑ ሄሮድሴበ ፈንቀልት መርታበእገ መገኑ ሀቄን ኩላን ዎሎ ዎቄን ባዱሰ ፈንቀልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","እሰን መርቶች ኤተሮን ቀርች መላይኬቹ ሀቄን ዩሱፊሃ ለልስ «ሄሮድስ ጩል ሾተ ሀሰኖቤቺሃ ጩልለከ አመተ ኣእት ግብጽ ባዱ ሁን፤ አን ኩሎሄተ ኢለ ህከኔ አፉዕል» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ዩሱፍ ሀንከዕሬን ኬዕይ ጩልለከ አመተ ኣእ ግብጽ ባዱ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ህከኔን ሄሮድስ ሬሆተ ኢለ አፉዕሌእ፤ ሁኩን እኮሁ ቀርቹ ነብዬቾን «ቤቱኤ ግብጺች ገኤም» ዬ ላገት ዊንቶታት እቅ። ");
INSERT INTO alw_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ሄሮድስ ቤዜተ ለኦ መኑ ጣንሱሰ ደጎ ወክት አበ ኡሙዕሬእ፤ ቤተሌማንለከ ህከን አዳን ጉዕማንን ዮ ለሞ ዘማንለከ ለሞ ዘማኒች ዎሮን ዮ ለቤ ኦሱተ ጉዕመንከ ሾኖተ አዘዦ፤ ህከ ወክትንከ ደጎሁ ኤንኬዕናሙ መኑ ኩልቶስጋት እቅ። ");
INSERT INTO alw_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ሁኩን እኮሁ ነብዬቹ ኤርምያስ ");
INSERT INTO alw_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«ራሄል እላተሴ ኦአን ያርትለከ ጨንጨነት ራማ ዬኖቤቾን ሞጮጨንቶኡ፤ እለሴ ሬቶቤቺሃ ሰብር አቶበአ» ዬኢሁ ዊሞታት። ");
INSERT INTO alw_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ሄሮድስ ሬዮች ኤተሮን ግብጽ ባዶን ቀርች መላይኬቹ ዩሱፍበ ሀቄን አሜች ");
INSERT INTO alw_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«ጩል ሽቶተ ሀሶ መኑ ሬቶቤቺሃ ኬእ አት ጩልለከ አመተ ኣእት እስራኤል ባዱ ፈንቀል» ይ ኩሎ። ");
INSERT INTO alw_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ህከ ወክት ዩሱፍ ጩልለከ አመተ ኣእ እስራኤል ባዱ ፈንቀሎ። ");
INSERT INTO alw_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ይሁድ ባዶን አርኬላዎስ አኒስ ሄሮድሴ ቤቾን ዎመ እክ ሄዕዮገ ዩሱፍ ሞጮጭ ይሁድ ባዱ ኦሮኡ ዋጄእ፤ መገኑ ዩሱፍሃ ሀቄን ኩላንስ ገሊል ባዱ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ህከቤቹንከ ኢሌ ወክት ናዝሬት ከተማን ሄዕዮ፤ ሁኩን እኮሁ ነብያኖን « ‹ናዝሬት መንቹ› ዬን ገኤኖ» ዬማሁ ዊሞታት። ");
INSERT INTO alw_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ህከ ወክት ጠመቃንቹ ያህይ ይሁድ ባድ ኡድማን አዋጀን አሜቾ። ");
INSERT INTO alw_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«ሁኩዕኑን! ሰሜ ዎምነቱ ሆንጠኮቤቺሃ ጩብክዕኔ ቶበቴን ፈንቀሌ» የኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ነብዬቹ እስያስ «መቱ መንቹ ኡለ ኡድማን ‹ቀርቹ ህገኖቤቹ ብዝ አዕዬ ህትን ዎቃስ ጌጥ አዕዬ› ይ ያርተን ሄኦ ላገተ» ዬኢሁ ያህይተኔሃት። ");
INSERT INTO alw_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ያህይ ኦድኑት ጋሜል ኦርዛች ደዴመተ እቅ፤ ረመዙስ ጠፍሪን ቆዕረኖ እቅ፤ ህትን ዳመ መለቡለከ ከንቸፈሩሃ እተኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ህከ ወክት ዬሩሳሌም ከተሚች፥ ይሁድ ባዲች ጉዕሚችለከ ዮርዳኖስ ዊ አዳን ዮ ባዲች ጉዕሚችን መኑ ያህይበ አሜተኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ጩብሰ ቶበተን ዮርዳኖስ ዛዘኖ ዊን ያህይ ጠመቀኖሳት እቅ። ");
INSERT INTO alw_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ያህይ ልግቡ ፈርሳዊትለከ ሰዱቃውት እስበ ጠመቀንቶተ አሜተን ለዕዮ ወክት እሰንተ «አዕኑ ዎሪች እለት! መገኒች አሜታ ኡሙዕሬች ጡምቶኖተ ኩሎህዕኔሁ አዬት? ");
INSERT INTO alw_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ቴሱንገ ጩብክዕኔ ቶበቴን ፈንቀሉክዕኔ ለሊሳ ጡመ ሆጉተ አዕዬ። ");
INSERT INTO alw_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ህትን ነኡ ‹እብራሂምተ እለ› ይቴነን ጡምቴነንታሃ አጉዱንከህዕኔ፤ መገኑ ከን ክኒች እብራሂም እለተ አዕይ ኬሶተ አታለኖገ አን ኩላንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ከልቱ ሀቅ ፎቃን አፉዕልዮኡ፤ ጡመ ላልቹ ላልበ ሀቀ ጉዕመንከ ሙሬን ጊራን ዎሬኖ። ");
INSERT INTO alw_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ጩብክዕኔ ቶበቴን ፈንቀሉክዕኔ ለልሲሃ ዊን ጠመቃንክዕኔ፤ እኮጎሬ ኩ ኢች ኤተሮን አሜተኖሁ ጠሊለ አያኒንለከ ጊራን ጠመቀኖህዕኔ፤ እስ ኢች አበ ሎረሃን፤ አን ጫዕመስ እጆተ በቀዕዮምበእሃን። ");
INSERT INTO alw_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ህካን እኮቤቺሃ እስ ኦዱ መክሶተለከ አቶተ ጋቢች አደ አኦተ ቤሉ ዮስ፤ አደ አዕዮች ኤተሮን ጠለሼ አቶተ ጭምአዕይ ጎተራን ዎረኖ፤ ጠዉ እኮጎሬ ጋበስ ጠዕታበእ ጊራን ቡሰኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ህከ ወክት ኢስ ገሊላች ያህይበ ዮርዳኖስ ዛዘኖ ዋን ጠመቀሞተ አሜቾ። ");
INSERT INTO alw_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","እኮጎሬ ያህይ «አን ኪን ጠመቀሙ ሀስሰኖኤ ቤሉ አት ሀት ኢቤቹ ጠመቀንቶተ አሜቶንት?» ይ ከሞተ ሀሾ። ");
INSERT INTO alw_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ኢስን «ነኡ መገኑ ሀሰኖርቹ ጉዕመንከ ዊንሹ ሀስሰኖኔቤቺሃ ቴሱ ከንቶቴኤ» ዬ ወክት ያህይ ጠዋንከስ ኢተቀም ኢሰ ጠመቆስ። ");
INSERT INTO alw_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ኢስን ጠመቀም ዊ ኣዚች ደዕል ፉሎ፤ ህከኒች ኤተሮን ሰሞ ፊልተዕይ ፈንተዕያን መገን አያኑ ሀንደዕሬገ እክ ድር ኢስ አሌን አፉዕለን ለዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ህከ ወክት «አን ሙንደኣምለከ ኢታም ቤቱኤ ከኒት» ይታ ላገት ሰሜች አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ህከኒች ኤተሮን ኢስ እልብሲን ፌተነሞተ መገን አያኑ ኡለ ኡድመ መሴስ። ");
INSERT INTO alw_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ህከኔን ሸይሉ በርለከ ሸይሉ ሀንከዕርተ ሶመኞች ኤተሮን ኢሰ ጎሩ አፎስ። ");
INSERT INTO alw_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ህከ ወክት እልብሱ ኢሰ ፌተኖተ አሜች «አት መገን ቤቱ እኮንትጎሬ ህንዴ ከ ክነተ እቸተ አእ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ጠዉ እኮጎሬ ኢስ ፈንቀሽ « ‹መኑ መገን አፌች ፉልታ ላጋኒት ቤሉ ጠለዕል እቻን ሄአኖበአ› የመም ከተበሞኡ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ህከኒች ኤተሮን እልብሱ ኢሰ ጠሊለ ዬሩሳሌም ከተመ መሴስ፤ ህከኔን ዱእ ምኒ እሌ አል ፉሽ ኡርሾ ");
INSERT INTO alw_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ጠሊለ መጻፋን « ‹ሎከክ ክኖን ቆዕልታበእገ ኬሳሃ አገርት ኬስ አፎተ መገኑ መላይከስ አዘዘኖ› የመም ጠሊለ መጻፋን ከተበሞኡ፤ ህካን እኮቤቺሃ አት መገን ቤቱ እኮንትጎሬ ህንዴ ዎሮ ዋልት ኡብ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ጠዉ እኮጎሬ ኢስ ፈንቀሽ « ‹ቀርቹ መገኑክ ፌተንቶት› የመም ወዕናንከ ከተበሞኡ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ህከኒች ኤተሮን እልብሱ ኢሰ ሎረ ቆተ አል ፉሽ ኣዱንያ አል ዎመተ ጉዕመንከ ሎርመሰ ለሊሽ ");
INSERT INTO alw_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","«ኤሳሃ ሙግይት ሰገዶንቴኤ ጎር ካን ጉዕመንከ ኣሳንኬ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ኢስ ፈንቀሽ «አት ሸይጣኑ ኢች ቄዕር፤ ጠሊለ መጻፋን ቀርቾ ‹መገኒሃክ ሰገድ፤ ጠለዕል እሲሃ ጠገም› የመም ከተበሞኡ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ህከ ወክትንከ እልብሱ ኢሰ አጉሮ፤ ህትን መላይከንት አሜት ካደንቶስ። ");
INSERT INTO alw_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ኢስ ያህይ ኡሱረሞገ ሞጮጬ ወክት ገሊለተ ኦሮዕዮ፤ ");
INSERT INTO alw_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ጠዉ እኮጎሬ ናዝሬት ከተመ አጉር ዛብሎንለከ ንፍታሌም ባዶን ሎረ ባር መዴን ዮ «ቅፍርናሆመ» ዬኖ ከተማን ሄዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ሁኩን እኮሁ ነብዬቹ እስያስ ");
INSERT INTO alw_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«ገሊለ ባር አደ መሰኖ ዎቄ አዲን ዮርዳኖስ ዛዘኖ ዊ ዉድ አዲን ለለኖ ዛብሎን ባድ መኑ፥ ንፍታሌም ባድ መኑለከ አይሁደ እኮበእ ገሊለ መኑ ");
INSERT INTO alw_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ሁኩ ቱንስቾን ሄአኖ ኡመቱ አበ ኑር ለዕዮ፤ ህትን ሬሆ ሀሌ ኣዜን ዮ መኒሃ ኑሩ ፉሎሰ» ጠወዕዮ ራግ ላገት ዊንቶታት። ");
INSERT INTO alw_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ህከን ወክቲች ኬሽ ኢስ «ሰሜ ዎምነቱ ሆንጠኮቤቺሃ አዕኑ ጩብችክዕኔ ፈንቀሌ» የን ተማርሱ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ኢስ ገሊለ ባር መዲን ሃመን ለምተ አመኦሱተ ለዕዮ፤ እሰን «ጴጥሮሴ» ዬኖ ስሞኔትለከ አመስቤቱ እንድራሴት እቅ፤ ቁርጩሜተ ወሻዳእረ እኮቤቺሃ ወሻዳሰ ሎረ ባራን ኡጅተን ለዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ኢስን «አሜ ኤሳሃ አዎኜኤ፤ አን ክዕኔተ ቁርጩሜተ ወሻዴነንተገን መነ መገን አደ ኤቤነንተረ አኣንክዕኔ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","እሰን ህከ ወክት ወሻደሰ አጉርት ኢሰ አዎንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ህከንቤቺች ቀዉተ ህጎገን ዘብዴዎሴ እለተ እኮእሩ ዎልት ለምተ አመኦሱት ያቁብለከ ያህይ አኒንከሰን ሜጡበ እክ ጀልብ ኣዜን ቁርጩሜ ወሻደ ጎበን ለዕይ ኢስ ገኤሰ። ");
INSERT INTO alw_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","እሰን ህከ ወክት አነሰለከ ጀልበሰ ጌኝአት ኢሰ አዎንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ኢስ ጭምትሰ ምናን ተማርሰንለከ መገን ዎምነት ተሽት ላገተ አዋጀን ገሊለ ባዱ ጉዕመንከ ሃመኖት እቅ፤ አደደ ጥዘነተለከ ጎግ ጥዘነተ ፈይሰኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ሁኩ ዱዱቡ ሶርይ ባዶን ጉዕማንን ሞጮጨሞቤቺሃ መኑ አደደ ጥዘናን ጥዝ ኦርጨቀንተ መነ እስበ ኤቦኡ፤ ጥዘናመ በላን ዶሮረኖ ዱሩ አፎ መኑሁ፥ ጮቱ አፎ መኑለከ ናፉ መኑ ሄዕዮ እቅ፤ ጠዉ እኮጎሬ ኢስ ጉዕመንከሰ ፈይሾ። ");
INSERT INTO alw_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ገሊላችለከ «ቶኑ ከተመ» ዬኖ ባዲቺ፥ ዬሩሳሌሚቺ፥ ይሁዲችለከ ዮርዳኖስ ዛዘኖ ዊ ዉድ አዲች አሜቶ ኡመቱ ኢሰ አዎንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ኢስ ልግብ ኡመት ለዕይ ቆተ አል ፉል ህከኔ አፉዕሌ ወክት አሳበስ እስቤቹ ሆንጠኮኡ። ");
INSERT INTO alw_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","እሰንተ ተማርሱ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","ኢስ «ገዉሰ ሆፍስ መገኖን ድከኣእሩ ሰሜ ዎምነቱ እሳሃ እኮቤቺሃ ማሰአንቶእረ። ");
INSERT INTO alw_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ሻዛሩ መገኑ ሰብር ኣሰኖሰቤቺሃ ማሰአንቶእረ። ");
INSERT INTO alw_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","መረርሲጭታእሩ ኡለተ ረገኣቤቺሃ ማሰአንቶእረ። ");
INSERT INTO alw_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","መገን ፈይመተ ጎራይታሩለከ ሰገባእሩ መገኑ ዱሰኖሰቤቺሃ ማሰአንቶእረ። ");
INSERT INTO alw_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","አሙዛእሩ መገኑ አሙዘኖሰቤቺሃ ማሰአንቶእረ። ");
INSERT INTO alw_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ነጡ ቀልቡ ዮሰሩ መገኑ ለኣቤቺሃ ማሰአንቶእረ። ");
INSERT INTO alw_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ሀራርስታእሩለከ ወገሬት አታእሩ መገን እለተ የመንታቤቺሃ ማሰአንቶእረ። ");
INSERT INTO alw_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","መገኒሃ አዘዘንቶቤቺሃ ያየንታሩ ሰሜ ዎምነቱ እሳሃ እሀኖቤቺሃ ማሰአንቶእረ። ");
INSERT INTO alw_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«ኢ መሳን መኑ ቦሮረንክዕኔለከ ሸረንክዕኔ ክዝቢን ሱዕመክዕኔ ቤሴነኒሁ ተሽ ዩንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ህካን እኮቤቺሃ ሰማን ሎረ ዋገ ኣእቴነንተቤቺሃ ሙንደዕዬ፤ ተሽ ዩንክዕኔ፤ ክዕኔች ብርተ ሄኦ ነብያኑት ህትን ኦርጨቀንቶኡ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ኢስን «አዕኑ ዱንየ አልሃ መጥኔተ፤ ጠዉ እኮጎሬ መጥንት ጤኡ ሆጋረ ሀት አኤን ጤኣገ አኤኖሴ? ህት መጥንት መቶርቺሃ ደግለልታበእቤቺሃ ቶሬናንሴ መኑ ሎካን ከደኖሴ ቤሉ መቶርቺሃ ደግለልታበአ። ");
INSERT INTO alw_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","አዕኑ ኣዱንያ አሊሃ ጉዕሚንከ ኑርሃ፤ ቆተ አሌን ዮ ከተሙ ማጠሞተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","አዪሁ ኩራዘ ለሊሽ ምኒ ኣዜን ዮ መኒሃ ጉዕሚንከ ለለኖ ቤቾን አፉሸኖ ቤሉ ሎንቆች ዎሮን አፉሸኖበአ። ");
INSERT INTO alw_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ህትን መኑ ክዕኔ ጡመ ሆጉክዕኔ ለእ ሰማን ዮ አነክዕኔ ገለትጭቶተ ክዕኔ ኑሩሁ መኒሃ ለሉን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ህትን ኢስ «መገኑ ሙሲሃ ኣሴ ሕገለከ ነብያኑት ተማርስቶኢሃ ድጆተ አሜቾሚሃ አጉዱንከህዕኔ፤ አን እሰ ተማርስቶኢሃ አቶኖተ አሜቾም ቤሉ ድጆተ አሜቾምበአ። ");
INSERT INTO alw_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ሀንቅንከ ያንክዕኔ፤ ኡለትለከ ሰሞሁ ህጎተ ኢለ ኩ ሕጉ ጉዕሙንኩ ዊመኖ ቤሉ ሕጊች መት እልቲ በኣበአ። ");
INSERT INTO alw_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ህካን እኮቤቺሃ አዪሁ ሕጊች ቀውሃሲ አዘዘምበጎሬለከ መኑ አዘዘመኖበእገ ተማርሴጎሬ እስ ሰሜ ዎምነቴን ጉዕሚችን ቀዉ እሀኖ፤ ጠዉ እኮጎሬ ሕገ ቶገኖሁለከ ዎሉ መኑ ሕገ ቶጋገ ተማርሰኖሁ ሰሜ ዎምነቴን ሎረ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ህካን እኮቤቺሃ ክዕኔ ፈይመት ሕግ አስተማራችለከ ፈርሳዌ ፈይማች በተእባች ሆሮ ሰሜ ዎምነቱ ኣጌነንተበእገ ኩላንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«ዎዕኔ ዘማን መኒሃ ‹መነ ሽቶት፤ መነ ሼ አን አሌን ፈረደመኖስ› የመሞሃ ሞጮጭቴንታአ። ");
INSERT INTO alw_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","እኮጎሬ አን ያሚሁ ከኒት፤ አመስ ቤቲን ኡሙዕረኖሀኒን ፈረደመኖስ፤ አመስቤቱ ቦሮረኖሁ ኦገት ዳኛኖበ ሆንጠሀኖ፤ ህትን ‹ኩ ደግለልትባሁ› ይ መነ ቦሮረኖሁ ሆሮን ጠእትበ ጊራን ፍርደ ኣአኖ። ");
INSERT INTO alw_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","መገኒሃ ክትሜኖ ጠረጴዝ አሌን ክትመ ሆንጠህሳንት ወክት ኪን ኡሙዕሬሄሃ ሰውይቶንትጎሬ ");
INSERT INTO alw_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ክትመ ሆንጠህሳንት ጠረጴዝ አሌን ህከኔ ጌኝአት አመክቤትበ መርት ሀራዕረም፤ ህከኒች ኤተሮን አሜት ክትመ ሆንጠህስ። ");
INSERT INTO alw_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ባለጋሩክ ከሰሻንኬ ፍርድ ምኔን ኡርታንትሀኒች ሄጭት ባለጋርንከክ ሀራዕረም፤ ህካን አትበጎሬ ባለጋሩክ ዳኚሃ ህግሽ ኣሰኖሄ፤ ዳኙንኩ ኡሱር ምኒ ኣግሰኖሄ። ");
INSERT INTO alw_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ሀንቅንከ ያንኬ፤ አሌክ ዮ ኤዳሃ ሹልት ባቱዕነ ኡሱር ምኒች ሆሮ ፉልታንትበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ኢስ « ‹ዝነተ አቶኖቼ› የመሞሃ ሞጮጭቴንታአ። ");
INSERT INTO alw_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","እኮጎሬ ቴሱ አን ኩላንክዕኔ፤ መንቹተ ለዕይ ቀልቤስ ሄዕላቾ መንቹ ዝነተ አዕዮሀንገ ዎለአመኖ። ");
INSERT INTO alw_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","መኬክ እልት ጅስሚችክ መቱስ ሉስሶ ጎሬ እሴተ ፉሽት ኡጅ፤ መሰንትስ ዊሙ ጅስሙክ አዛቤን ቡበኖሀኒች ጅስሚችክ መትተ እልተ ሆጎንቲሁ ቆሀኖ። ");
INSERT INTO alw_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","መኬክ አንገክ ሉሲሶሄ ጎሬ ሙርት ኡጅ፤ መሰንትስ ጅስሙክ ጉዕሙንኩ አዛቤን ኣገኖሀኒች ጅስሚችክ መኬክ አንገተ ሆጎንቲሁ ቆሀኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ህትን «ጫስ ገፍረኖሁ ጉዕሙንኩ ገፈሮ ፉርመ ኣሱንሴ» የመሞኡ። ");
INSERT INTO alw_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","እኮጎሬ ቴሱ አን ኩላንክዕኔ፤ ዝነተ አቱዕነ መንቹስ ገፈረኖሁ ጉዕሙንኩ ዝነተ አታገ አአኖሴ፤ ህተ ገፈሮ መንቹተ ኣአኖሁ ጉዕሙንኩ ዝነተ አዕዮሃ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ህትን «ከኒች ብርተ ሄኦ መኒሃ ‹መገኒሃ ኣጎንት ወኣድ ላገተ ዊንሽ ቤሉ ድጅቶት› የመሞሃ ሞጮጭቴንታአ። ");
INSERT INTO alw_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","እኮጎሬ አን ቴሱ ኩላንክዕኔ፤ ሰማን ሆሮ ጤሌዕልቶኖቼ፤ መሰንትስ ሰሞሁ መገን ጄነትተ ቦርጭመ። ");
INSERT INTO alw_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ኡላን እኮ እቃ ጤሌዕልቶኖቼ፤ ኡለት መገን ሎከት ፎሎጭታሃ ቤቹ፤ ህትን ዬሩሳሌማኒ ጤሌዕልቶኖቼ፤ ዬሩሳሌሙ ሎረ ዎምየ ከተመ፤ ህካን ኦኮቤቺሃ ሆሮ ጤሌዕልቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ሙሚችክ መትተ ዋጁተ ህከረንገ ገንበለ አቶተ አታልታንትበእቤቺሃ ጤሌዕልቶት። ");
INSERT INTO alw_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ህካን እኮቤቺሃ ጠወኤነታሁ እሀኖሀ እሀኖ እህባሁ እሀኖበአ ዩ ሀስሰኖ፤ ከኒች አደ እካ ላገት ጉዕሙንኩ ሸይጣንቺት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","እስን « ‹እልተ ፉሼሀኒሃ እልስ ፉሽ፤ እንኩተ ብጮሀኒሃ እንኩስ ቢጥ› የመሞሃ ሞጮጭቴንታአ። ");
INSERT INTO alw_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","እኮጎሬ ቴሱ ኩላንክዕኔሁ አዕኑ አዬሃ ገዱተ ፈንቀሽቶኖቼ፤ አዪሁ መኬክ መጫለ ዎቀረኖሀኒሃ ጉረ አድ መጫለ ዎቀሮተ ኣስ። ");
INSERT INTO alw_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","መቱ መንቹ ሸሚዘክ ኣኦተ ሀሽ ከሰሾሄ ጎሬ ኮቴክ በርግት ኣስ። ");
INSERT INTO alw_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","መቱ መንቹ ‹ቀዉ ጌሰ ህርሲሴኤ› ዬጎሬ አት ለሙ አፎ በርግት ህርሲስስ። ");
INSERT INTO alw_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ኡጨኖሄሀኒሃ ኣስ፤ ህትን ሌቄጮተ ሀሰኖሀኒሃ ሌቄስስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","ኢስን « ‹ጃለክ ኢት! ዲነክ ግብ› ዬማሃ ሞጮጭቴንታአ። ");
INSERT INTO alw_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","እኮጎሬ አን ኩላንክዕኔ፤ ዲነክዕኔ ኢትዬ፤ ሸርታህዕኔሀኑኡተ ዱአ አዕዬ ያንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ህካን አቴንተጎሬ ሰማን አኒሃክዕኔ እለተ እኬነንተ፤ መሰንትስ እስ ሂላኖተለከ ጡመ መኒሃ አሩ ፉሸኖ፤ ህትን ፈየ መኒሃለከ ጩበኛኖተ ጤነ ኣሰኖ። ");
INSERT INTO alw_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ኢተኖህዕኔሃ ኢትቴንተ ጎር መ ዋጉ ዮህዕኔ? ህካን ጩበኛኑንት አታእሃበእንዶ? ");
INSERT INTO alw_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ጠለዕል እሉክዕኔ ወገሬትሴንተ ጎሬ ዎሎ መኒች መ ቆኬነን? ህካን አይሁደ እኮበእ መኑሁ አታአ። ");
INSERT INTO alw_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ህካን እኮቤቺሃ ሰማን ዮ አኑክዕኔ ኩሌኖስሁ ዮበኢሃ እኮገን አዕኑሁ ኩሌኖህዕኔርቹ ዮበእረ እኬ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ኢስን «ጡመተ ሆጉተ አቴንተገ መኑ ለዕይ ገለትጩን ይቴን መን ብሬን አኢች አገዕርዬ፤ ህካን አቴንተጎር ሰማን ሄዕዮ መገኒች መቱርቹሃ ደእቴነንተበአ። ");
INSERT INTO alw_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ህካን እኮቤቺሃ ቡጥቻኖተ ሰደቀተ ኣቴነንተ ወክት መኑ ለኦሰተ አታ መኑ ዱአ አኤኖ ምናን አታሀንገ መኑ ለኡኔ ይቴን አቶኖቼ፤ ሀንቅንከ ያንክዕኔ፤ እሰ ሆጎሰ ዋገ ኣእቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","እኮጎሬ አት ቡጥቻኖተ ሰደቀተ ኣታንት ወክት አዪሁ ደጉዕነ ማጥ ኣስ። ");
INSERT INTO alw_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","መሰንትስ ማጥ ሰደቀተ ኣሱክ ደገኖ መገኑ ጡመ ሆጎክ ወጥ ኣሰኖሄ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","ኢስን «ዱአ አቴነንተ ወክት መኑ ለኦሰተ ዱአ አኤኖ ምናንለከ ዎቄ ገበላን ኡርት አታ መንገ አቶኖቼ፤ ሀንቅንከ ያንክዕኔ፤ እሰ ሆጎሰ ወጥ ኣእቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ዱአ አቴነንተ ወክት ምንክ ኣግ ጡፈ ጡፍ ማጠም ዮ አንክ ቤቹ ዱአ አእ፤ ማጤን አኤማሃ ለአኖ መገኑክ ጡመ ሆጎክ ዋገ ባተኖሄ። ");
INSERT INTO alw_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ዱአ አታንት ወክት አይሁደ እኮበእ መንገ ፈንቀላንስቴነን ዱአ አቶኖቼ፤ ሁኩ መኑ ፈንቀላንስት ዱአ አቶቤቺሃ መገኑ ሞጮጨኖሳሃ አት ቂራርስት ዱአ አታአ። ");
INSERT INTO alw_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","አዕኑ እሰገ እኮኖቼ፤ እስን ክዕኔ አኑ ሀስሰኖህዕኔሃ ጠዕምቶኑዕነ ሄጭ ደገኖ። ");
INSERT INTO alw_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«ህካን እኮቤቺሃ « ‹ሰማን ዮንቲ ኒ አኑ! ጠሊሉ ሱዕሙክ ሎዕሩን፤ ");
INSERT INTO alw_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ዎምነቱክ አሜቱን፤ ሃሽኣቱክ ሰማን እኮገን ህትን ኣዱንያ አሌን እኩን። ");
INSERT INTO alw_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ከበሬተ እካኔ እቸተ ኣስኔ። ");
INSERT INTO alw_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ነኡ ዎሎ መኒ ቤሱ አጉርናምገን ኒ ቤሱሃ አጉርኔ። ");
INSERT INTO alw_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ሂለርቺች ጡምስኔ ቤሉ ፌተናን ኣግሶትኔ፤ ኣሚዕን› ይቴነን ዱአ አዕዬ። ");
INSERT INTO alw_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«መን ቤሱ አጉርቴንተ ጎሬ ሰማን ዮ አኑክዕኔ ክዕኔ ቤሱሃ አጉረኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ጠዉ እኮጎሬ መን ቤሱ አጉሮንስ ይቴንባች ሰማን ዮ አኑክዕኔ ክዕኔ ቤሱሃ አጉረኖህዕኔበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","ኢስ «ሶመንቴነንተ ወክት መኑ ለኦሰተ አታ መንገ ሻዞኖቼ፤ እሰ ሶመኑሰ መኑ ለኦተ ይት ሚንሰ ቤሳአ፤ ሀንቅንከ ያንክዕኔ፤ እሰ ሆጎሰ ወጥ ኣእቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ጠው እኮጎሬ አት ሶመንታንት ወክት ሚንተ ኣዕልት ቡዕለክ ቡዕር። ");
INSERT INTO alw_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ህካን አቶንትጎሬ ማጭ ለአኖ አኒክ ቤሉ ዎሉ አዪሁ ለአኖበአ፤ ማጭ ለአኖ አኑክ ሆጎክ ወጥ ኣሰኖሄ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","ኢስ «ሞጋኑት ኣግ ቢጥ ሞግታቤቾኒ፥ ብሉት እታቤቾንለከ ቡሃይ በአኖቤቾን ዱንያክዕኔ ኣዱንያ አሌን ጭምአቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ጠዉ እኮጎሬ ብሉት እታበእቤቾኒ፥ ቡሃይ በአኖበእቤቾንለከ ሞጋኑት ቢጥ ኣግ ሞግታበእቤቾን ሰማን ዱንያክዕኔ ጭም አእዬ። ");
INSERT INTO alw_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ህካን እኮቤቺሃ ዱንያክ ዮቤቾን ቀልቡክ ህከኔ ሄአኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","ኢስን «እልክ ጅስምሀክ ኑርሃን፤ እልክ ፈየተ እኮጎሬ ጅስሙክ ጉዕሙንኩ ኑር እክ ለለኖ። ");
INSERT INTO alw_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","እልክ ፈየተ እክበጎሬ ጅስሙክ ጉዕሙንኩ ቱንስቹ እሀኖ፤ ህካን እኮቤቺሃ ኬሳን ዮ ኑሩ ቱንስቹ እኮጎሬ ቱንስቹስ ሄንከ በተአኖሃ እሀኖ?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","ህትን ኢስ «መቱ መንቹ ለሞ ቀርቺሃ ጠገሞተ አታለኖበአ፤ መቱስ ኢተኖ፤ ዎሉስንገ ግበኖ፤ ህከረንገ መቱስ ሎርሰኖ፤ ዎሉስንገ ህንቀኖ፤ ህትን መገኒሃለከ ብሪሃ ጠገሚሃ አታልቴነንተበአ። ");
INSERT INTO alw_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ህካን እኮቤቺሃ አን ኩላንክዕኔ ‹መ እንታም? መ አንጋም? መ ኦደዕናም?› ይቴን ሄእክዕኔተኔሃ ሻዞኖቼ፤ እቲች ሄኡ ኦድኖች ጅስሙ በተአኖበእንዶ? ");
INSERT INTO alw_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ህንዴ ሰማን ብርይታ ጪኡተ ለዕዬ፤ እሰ ዉጣበአ፤ ምዳበአ፤ ቀፎኒ ዎርታበአ፤ ጠዉ እኮጎሬ ሰሜ አኑክዕኔ እትሰኖሰ፤ ህከረ አዕኑ ጪኦች በተኤነንተበእንዶ? ");
INSERT INTO alw_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ክዕኔኤች ጨነቀም ኡሙሬንከስ መቱ በር በርጎተ አታለኖሁ አዬት? ");
INSERT INTO alw_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ህትን ሚሃ ኦድኖተ ሻዜነንታት? ህንዴ አብሌን ዮ ቦብሉት ነጵታገ ለዕዬ፤ እሰ ገይሀሰ ሆጎን ሆጋበአ ህከረንገ ደዳበአ። ");
INSERT INTO alw_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","አን ኩላንክዕኔ፤ ሆሮ ዎሙ ሱላይማን ህከን ጉዕመንከ ሎርማንተስ ከን ቦብሎች መትሴገ ኦደዕዮበአ። ");
INSERT INTO alw_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","መገኑ ከበር ለልት ጋቴተ ጊራን ቡባ ህጤተ ህት ኦደኣገ አአኖሃ እኮች አዕኑ አመዕነቱ ሆፈዕዮህዕኔሩ ክዕኔተ ቆህሽ ኦዲሰኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ህካን እኮች ‹መ እንታም? መ አንጋም? መ ኦደዕናም?› ይቴን ሻዞኖቼ። ");
INSERT INTO alw_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ህካን አይሁደ እኮበእ መኑሁ ሀሳአ፤ ክዕኔሃ ሁኩ ጉዕሙንኩ ሀስሰኖህዕኔገ ሰሜ አኑክዕኔ ደገኖ። ");
INSERT INTO alw_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","አዕኑ እኮጎሬ ሄጭቴን መገን ዎምነቱስለከ ፈይመስ ሀሼ፤ ሁኩ ጉዕሙንኩ ጠዉ በርገመኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ህትን ጋቴተክዕኔ ይቴን ሻዞኖቼ፤ ጋት ገዬተሴ ሻዛአ፤ በሪሃስ በሬስ ጭንቀት እካአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ኢስን «ፈረደመኖህዕኔበእገ ፈረዶኖቼ። ");
INSERT INTO alw_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","መሰንትስ አዕኑ ፈረዴንተገን ፈረደመኖህዕኔ፤ ህትን ብክቴነንተሀኔን ብከመኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ኪ እሌን ዮ ሎረ ሁረ ለኡዕናን ሀት ኪ አመክ ቤት እሌ ኣዜን ዮ ሁረ ለኣንቲት? ");
INSERT INTO alw_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ህትን ኪ እሌን ዮ ሎረ ሁረ ከንቱዕነ ኪ አመክቤቱ ‹ህንዴ እሌክ ዮ ሁረ ፉሻም› ይቶተ ሀት አታልተን? ");
INSERT INTO alw_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","አት አን ሎረሃን ይታንቲሁ፤ ሄጭት እሌክ ዮ ሎረ ሁረ ፉሽ፤ ህከኒች ኤተሮን አመክ ቤት እሌን ዮ ሁረ ፉሽቶተ አጥረመት ለኣንት። ");
INSERT INTO alw_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","መገኒሃ አደ እኮርቹ ዉሻተ ኣቶኖቼ፤ ህትን ሎካንከሰ ከድ ቤሳበእገ ዎርቀ ቦኬ ብሬን ኡጅቶኖቼ፤ ዉሸንት ፈንቀልት ገዕምታህዕኔ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ህትን ኢስ «ኡጭዬ ኣእቴነንተ፤ ሀሼ ደእቴነንተ፤ ህትን ኡሩተ ቆጭዬ ፈነመኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ህካን እኮቤቺሃ አዪሁ ኡጨኖሁ ቶገኖ፤ አዪሁ ሀሾ ጎሬ ደአኖ፤ ህትን አዪሁ ኡሩተ ቆጬጎሬ ፈንተአኖስ። ");
INSERT INTO alw_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ክዕኔኤች አዪሁ ቤቱስ ዳቡተ ኡጬጎሬ ክኑ ኣሰኖሁ አዬት? ");
INSERT INTO alw_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ህትን ቁርጩሜተ ኡጬጎሬ ዎሪቹ ኣሰኖንዶ? ");
INSERT INTO alw_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","አዕኑ ሂላኑተ እኬነን እላተክዕኔ ጡመርቹ ኣሱ ደጌንታች ሰማን ዮ አኑክዕኔ ኡጭታሀኑኡተ ጡመርቹ በትሽ ኣሰኖበእንዶ? ");
INSERT INTO alw_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ህካን እኮቤቺሃ መኑ አሶህዕኔተ ኢትቴንታሃ ጉዕመንከ አዕኑ እሳሃ ህትን አዕዬ፤ መሰንትስ መገን ሕጋን ዬማሁለከ ነብያኑት ኩልቶኢሁ ህከኒት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ኢስ «ሩካሸ ኡሮን ኣጌ፤ መሰንትስ በእቤቹ መስታ ኡሩት አልባዕሎታን፤ ህትን ዎቆሲ ሎረሃን፤ ህከን ዎቃን ሃመኖ መኑ ልግብያ። ");
INSERT INTO alw_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","እኮጎሬ ሄእቤቹ አዎንስታ ኡሩት ሩካሸታን፤ ህትን ዎቆሲ ኦርሰኖሃን፤ ህካን እኮቤቺሃ ህከ ዎቃሃ ደአኖ መኑ ቀዎሃን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","ኢስ «አዕኑ ክዝብ ነብያኖች አገዕርዬ፤ እሰ ክዕኔቤቹ ሆለተ አጉድ አሜታአ፤ ጠዉ እኮጎሬ ወልቅሽ እተኖ ኦሌገ ዮእረ። ");
INSERT INTO alw_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","እሰንተ ደጌነንተሳሁ ላልቺንከሳት፤ ኡት ሀቂች ወይነ ዬኖ ላልቹ ህትን ቃልቃልች ኦድ ላልቹ መጤኖበአ። ");
INSERT INTO alw_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ህትን ጡሙ ሀቁ ጡመ ላልቹ ላለኖ፤ ጠዉ እኮጎሬ ሂሉ ሀቁ ሂለ ላልቹንከ ላለኖ። ");
INSERT INTO alw_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ጡሙ ሀቁ ሂለ ላልቹ ላሎተ ህትን ሂሉ ሀቁ ጡመ ላልቹ ላሎተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ጡመ ላልቹ ላለኖበእ ሀቀ ጉዕመንከ ሙሬን ጊራን ቡሴኖ። ");
INSERT INTO alw_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ህካን እኮቤቺሃ ክዝብ ነብያኑተ ሆጎሰ ላልቺን ደጌነንተሰ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ኢስ «ሰማን ሄአኖ ኢ አን ሃሽኣቱተ ዊንሸኖሀን ቤሉ ‹ቀርቾ! ቀርቾ!› የኖኤሁ ጉዕሙንኩ ሰሜ ዎምነቱ ሆሮ ኣገኖበአ። ");
INSERT INTO alw_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ፍርድ በር ልግቡ መኑ ‹ቀርቾ! ቀርቾ! ሱዕሚንከክ ራገ ጠወዕንበእንዶ? ሱዕሚንከክ ሩሃንያ ፉሽንበእንዶ? ህትን ሱዕሚንከክ ልግብ አጀብሲሰኖ ጠወ አዕንበእንዶ?› ይታአ። ");
INSERT INTO alw_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ህከ ወክት ‹አን ሆሮ ደጋንክዕኔበአ፤ አዕኑ መገን ትዛዝ ቶጌንቡሩ ኢች ካጳ ሽቄ› ያም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ኢስ «ህከ ኢ ላገተ ሞጮጭ አገረኖ መንቹ ምንስ ክን አሌን ጠረኝሽ እጃሮ ኤንኬዕናሙ መንቹ አጉደኖ። ");
INSERT INTO alw_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ምንስ አሌን ጠረኙ ጤኑ ኡቦ፤ ድርሱንኩ አሜቾ፤ ህትን ቦብሩ ሀንበሎስ፤ ጠዉ እኮጎሬ ምኑ ክን አሌን እጃረሞቤቺሃ ኡቦበአ። ");
INSERT INTO alw_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ጠዉ እኮጎሬ ኢ ላገተ ሞጮጭ አገርቡ መንቹ ምንስ ሽፋር አሌን እጃሮ ገወ መንቹ አጉደኖ። ");
INSERT INTO alw_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ምንስ አሌን ጤኑ ኡቦ፤ ድርሱንኩ አሜቾ፤ ህትን ቦብሩ አበ ሀንበላንስ ምኑስ ሽፋር አሌን እጃረሞቤቺሃ ወክትንከስ ኡቦ፤ ሁኩ ምኑንኩ ሂለገ ኡቦ» ይ ተማርሴእ። ");
INSERT INTO alw_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ኢስ ህካን ተማርስ ሹሎ ወክት እስ ተማርሴ ትምርታን ኡመቱ አበ አጀብሲጬእ። ");
INSERT INTO alw_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","መሰንትስ እሰተ ተማርሴኢሁ ሹምነቱ ዮስ መንጋት ቤሉ ሕግ አስተማረጋበአ። ");
INSERT INTO alw_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ኢስ ቆታች ድሬ ወክት ልግቡ ኡመቱ አዎንቶስ። ");
INSERT INTO alw_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ህከ ወክት አሌን ፉልታ ጎግ ጥዘነት አፎስ መቱ መንቹ ኢስበ አሜቾ፤ እስን ብሬስ ጉሉጵ «ቀርቾ! ኢትቶንትጎር ነጠ አቶኤተ አታልታንት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ኢስን አንገስ ሂር ህከ መንቹ አፍ «ፈቀጆም ነጠ እህ» ዬእ፤ ህከ ወክት ሁኩ ጎግ ጥዘነት አጉርቶስ። ");
INSERT INTO alw_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ህከ መንቹ ኢስ «ከ ጠወ አዬሃ ጠወኦት፤ ጠዉ እኮጎሬ ቴሱ መርት ነጠ እሁክ ቂስቺሃ ለልስ፤ ህትን መኒሃ ጉዕሚንከ ምስክር እሆተ ሙስ አዘዦገን መገኒሃ ክትም ሆንጠህስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ኢስ ቅፍርናሆም ከተመ ኣጎ ወክት መቱ ጥቤ ሀለቁ ኢስበ አሜች ");
INSERT INTO alw_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«ቀርቾ! ካዲንቹኤ ናፈ እክ አበ ኦርጨቀመን ምኔን ኦሰዕዮኡ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ኢስን «አን መር ፈይሳንስ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ጠዉ እኮጎሬ ጥቤ ሀለቁ «ቀርቾ! አት ኢ ምኒ ኣጎተ አን በቀዕባ መንቹ፤ ጠዉ እኮጎሬ ጠለዕልመት ላገተ ጠወእ፤ ካድንቹኤ ፈየኖ። ");
INSERT INTO alw_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","አን ገዉንኩእ ኢች አሊን ዮ ዳኚሃ አዘዘማም፤ ህትን ኢች ዎሮን አን አዘዛም ዎታደሩ ዮኤ፤ መቱስ ‹ካጳ ኦሮእ› ዬም ጎሬ ኦሮአኖ፤ ዎሉንገ ‹ከበ አም› ዬም ጎሬ አሜተኖ፤ ኢ ካድንቹንኩ ‹ካን አእ› ዬም ጎሬ አአኖ» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ኢስ ካን ሞጮጬ ወክት አጀብሲጭ አዎንተን ሄኦ መኒሃ «ሀንቅንከ ያንክዕኔ፤ ህትኔ አመዕነቱ እስራኤላን ደጎምበአ። ");
INSERT INTO alw_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ከ ጠወ አጥራመቼ፤ ልግቡ መኑ ሸርቂችለከ ገርቢች አሜት ሰሜ ዎምነቴን እብራሂሚን፥ ኢሳቂንለከ ያቁቢን ሜጡበ እክ ማዳን አፉዕልት እታአ። ");
INSERT INTO alw_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ሰሜ ዎምነት እለት አብሌ ቱንስቾን ኡጄናንሰ ህከኔ አልፋቴተለከ እንኩተ እጡ እሀኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ህከኒች ኤተሮን ኢስ ጥቤ ሀለቂቹ «ኦሮእ፤ አመዕንቶንትገን እሁን» ዬስ፤ ካድንቹስ ህከ ወክት ፈዬእ። ");
INSERT INTO alw_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ኢስ ጴጥሮሴ ምኒ ኣገኖ ወክት ጴጥሮሴ በሉት ፋረ ደሙሜን አበ ጥዣንሴ ኦሰኣን ለዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","እስ አንገሴ ኡሎ ወክት ፋረት አጉርቶሴ፤ እሴን ኬእ እሰንተ ካደንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ሀዎሬ ወክት ልግቡ መኑ ሩሃንዩ አፎሰ መነ ኢስበ ኤቦኡ፤ እስን ላጋንተስ ልግብ ዶሮረኖ ዱር ፉሼእ፤ ህትን ጥዘናመተ ጉዕመንከ ፈይሾ። ");
INSERT INTO alw_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ህካን አዕዮሁ ነብዬቾ እስያሴን «እስ ጥዘነኔ ኣኤእ፤ ጥዘነኔ እጄእ» ዬኢሁ ዊሞታት እቅ። ");
INSERT INTO alw_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ኢስ ልግቡ ኡመቱ እስ መዴን ጭምዬኢሃ ለዕዮ ወክት «ከን ባርች ዉድ አደ ቶሌ» ይ አሳበስ አዘዦ። ");
INSERT INTO alw_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ህከኒች ኤተሮን ሕግ አስተማራች መቱ ኢስበ አሜች «አስተማርቾ! አት መርታንትቤቹ ጉዕመንከ አዎናንኬ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ኢስ «ዎለንጌሃ ኤሎ ዮሰ፤ ሰሜ ጪኦንተ ጎዕምት ዮሰ፤ ጠዉ እኮጎሬ መንች ቤቲሃ ገዉስ ፎሎሲሰኖ ቤቹ ዮስበአ» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ህትን አሳባችስ መቱ «ቀርቾ! ሄጭ መር አነኤ ሞጎተ ፈቀደኤ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ጠዉ እኮጎሬ ኢስ «ሬዮ መነ ሬዮ መኑንኩ ሞጉን፤ አት ኤሳሃ አዎኔኤ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ህከኒች ኤተሮን ኢስ ጀልባን ኣጎ ወክት አሳባንት ሜጡበ ኣጎኡ። ");
INSERT INTO alw_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ጠረኙ ቦብሩ ባር አሌን ኬዕያን ዊ ሁሉ ጀልባ ጥምብሶተ እኮ፤ ጠዉ እኮጎሬ ኢስ ግሾ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","አሳበንት ኢስበ ሆንጠክ «ቀርቾ! በዕናሚት፤ ጡምስኔ» ይት ግሰኛች ኬሶኡ። ");
INSERT INTO alw_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ኢስን «አዕኑ አመዕነቱ ሆፈዕዮህዕኔሩ፤ ሚሃት ዋጅቴነንታሁ?» ዬሰ፤ ህከኒች ኤተሮን ኢስ ኬዕይ ቦብረለከ ባረንከ አጉረኖገ ሻቃን ጨለ ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","መኑ አበ አጀብሲጭ «ቦብሩለከ ባሩ አዘዘመኖሲሁ ኩን ሀትናሙወ መንቹ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ኢስ ገሊለ ባረ ቶል ጌርጌሶን ባዱ አሜቾ፤ ህከኔን ሩሃንዩ አፎሰ ለሙ መኑ ሎድ ኣዚች ፉልት ደቀንቶስ፤ እሰ መነ ምርታእረ እኮቤቺሃ አዪሁ ህከን ዎቄን ህጎተ አታለኖበ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","እሰን ያርተን «መገን ቤቶ! ኔሳለከ ኬሳሃ ሚ ደቅንሹ ዮኔ? ወክቱ እሉዕነ ኦርሶኔተ አሜቶንትንዶ?» ይተን ያርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","እሳች ቀዉንተ ህግ ቦኬ መሰረት ዘግ ይቶ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ዶሮረኖ ዱሩ «ፉሽታንትኔ ጎሬ ህከን ቦኬ መሰራን ኣንጋምገ አእኔ» ይት ኡጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ኢስን «መሬ» ዬሰ፤ ህከን መኒች ፉልት መርት ቦኬን ኣጎኡ፤ ሁኩ ቦኬ መሰረት ጉዕሙንኩ ቆተ መዲች ደጉደን ባራን ጥንብሰንት ሬቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ህከን ቦኬ ዜማኑት ሁንት ከተመ ኣግ ጉዕመንከ ጠወለከ ሩሃንዩ አፎ ለሞንከ መናን እኮ ጠወ መኒሃ ጠወኦኡ። ");
INSERT INTO alw_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ህከኒች ኤተሮን ህከን ከተም መኑ ጉዕሙንኩ ኢሰ ለኦተ መርቶኡ፤ ለኦ ወክት ባዱሰ ገፈር ኦሮአኖገ ኡጭቶስ። ");
INSERT INTO alw_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ኢስ ጀልባን ኣግ ባረ ቶል ገይስ ከተመ አሜቾ። ");
INSERT INTO alw_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ህከቤቹንከ መቱ ናፈ መንቹ ዴስን እጅት ኤቦኡ፤ ኢስን አመዕነቱሰ ለዕይ «ኢ ቤቶ! ዋጅቶት፤ ጩቡክ ፈቁን የመሞኡ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ህከ ወክት ሕግ አስተማራች መት-መቱ ገገዉንኩሰን «ኩ መንቹ መገን አሌን ቦሮር ላገተ ጠወአኖት» ይት ቀልቤንከሰ ሰውይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ጠዉ እኮጎሬ ኢስ ቀልብሰ ጠወ ደግ «አዕኑ ሚሃት ሂለ ጠወ ቀልቤንከክዕኔ ሰውይቴነንታሁ? ");
INSERT INTO alw_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‹ጩቡክ ፈቁን የመሞሄ› ዪችለከ ‹ኬእ ኡርት ሃም› ዪች ሀኩንስ ቆሀኖ? ");
INSERT INTO alw_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ጠዉ እኮጎሬ መንች ቤቱ ኣዱንያ አሌን ጩብ ፈቁን ዮተ ወልቀት ዮሲሃ እሁስ ደጌ» ይ ናፈ መንቹ «ኬእ ዴሰክ እጅት ምንክ ኦሮእ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","መንቹንኩ ኬዕይ ምንስ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ኡመቱንኩ ህካን ለኦ ወክት ዋጅት ህትኔ ዎልቀተ መኒሃ ኣሴ መገኑ ገለትጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ኢስ ህከንቤቺች ኬዕይ ኦሮአን «ማቶሴ» ዬኖ ቀረጠ ሙረኖሃ ቀረጠ ሙረኖ ቤቾን አፉዕሌኢሃ ለዕይ «አወኔኤ» ዬስ፤ እስን ኬዕይ አዎኞስ። ");
INSERT INTO alw_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ህከኒች ኤተሮን ኢስ ማቶሴ ምኔን ማዳን አፉዕሌሀኔን ልግቡ ቀረጠ ሙርታእሩለከ ጩበኛኑት ህከ ቤቹ አሜት እሲንለከ አሳባንን ማዳን አፉዕልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ህካን ፈርሳውት ለእ አሳበስ «አስተማርቹክዕኔ ጩበኛኖንለከ ቀረጠ ሙርታሀኑኡን ሜጡበ እተኖሁ ሚሃት?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ጠዉ እኮጎሬ ኢስ ህካን ሞጮጭ «ሀኪሙ ሀስሰኖሁ ጥዘናማታት ቤሉ ፈየ መኒሃትበአ። ");
INSERT INTO alw_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ኦሮዕዬ ‹አን ኢታሚሁ ማርቱታት ቤሉ ክትምሃትበአ› የመም ከተበሞሃ መሃጎር አጥራመቴን ደጌ፤ አን አሜቾሚሁ ጩበኛኑት ጩብችሰ ፈንቀልታገ ገኦታት ቤሉ ፈየ መነ ገኦታበአ» ይ ፈንቀሼሰ። ");
INSERT INTO alw_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ህከ ወክት ያህይ አዎናኑት ኢስበ አሜት «ነኡለከ ፈርሳውት ሶመን አንፈን ኪ አሳበት ሶመንታበኢሁ ሚሃት?» ይት ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ኢስን «እዜቹ እሳን ሜጡበ ሄአን ጃለት ሻዛእንዶ? ጠው እኮጎሬ እዜቹ እሳች አደ እሀኖ ወክቱ አሜተኖ፤ ህከ ወክት ሶመንታአ። ");
INSERT INTO alw_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","አዪሁ ኑባጵቶ ኦድኖን ሃዕሮ ቃፈተ ቃፈኖሁ ዮበአ፤ ቃፌጎሬ ኦድኑስ ፊልተኣአ፤ ፊልተኡንኩስ ወዕኔች ባሰ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ህትን ሃዕሮ ጠጀ ኑባጴ ሆቆማዶን ዎሬኖበአ፤ ህካን አኤመ ጎሬ ሃዕሮ ጠጁ ኑባጴ ሆቆማዱ ፊለኖ፤ ጠጁሲ ዱንተአኖ፤ ጠው እኮጎሬ ሃዕሮ ጠጀ ሃዕሮ ሆቆማዶን ዎሬኖረ ጠጁሲ ዱንተአኖበአ፤ ህትን ሆቆማዱንኩ ፊልተአኖበአ» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ኢስ ህካን ጠወአንን መቱ ሹሙ ኢስበ አሜች ብሬስ ጉሉጵ «ጩልኤ ቴሱ ሬቶኡ፤ ጠዉ እኮጎሬ አት አሜት አንገክ እሴ አሌን አቶንት ጎር ፈይታአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ኢስ ኬዕይ አሳባንተስን ሜጡበ ህከ መንቹ አዎኞ። ");
INSERT INTO alw_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","እሰን ሃንተን ሄኦገን ቶነ ለሙ ዘማን ጅስምችሴ ቄጉ ዱንተአን ኦርጨቀንተን ሄኣ መት መንቹት አሜት ኤተርስ አዲን ኢስ ኦድኖስ ሰኑተ አንጋንተሴ ኡልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ህካን አቶኢሁ ቀልቤንከሴ «ኦድኖስ ሰኑተ ኡሎም ጎሬ ፈያም» ይቲት እቅ። ");
INSERT INTO alw_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ኢስን ፈንቀል እሴንተ ለዕይ «ኢ ጩሌ! ዋጅቶት፤ አመዕነቱክ ፈይሾሄ» ዬሴ፤ ህከ ወክትንከ እሴ ፈይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ህከኒች ኤተሮን ኢስ ሹም ምኒ ኢሌ ወክት አልፋቴተ ጡሩንበ ቡሰን ምኒ ኣዜን ኦአኖ መነ ለዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","«ጉዕሙንኩክዕኔ ከን ምኒች ፉሌ! ሀፍቱት ግሶ ቤሉ ሬቶበአ» ዬእ፤ ጠዉ እኮጎሬ እሰ ኦሰዕልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","መኑ ፉሎች ኤተሮን ኢስ ሀፍቶ ጀናዘት ዮ ቤቹ ኣግ አንገሴ አፎ ወክት ኬኦኡ። ");
INSERT INTO alw_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ሁኩ ጠዉ ጉዕሙንኩ ህከን ባዶን ሞጮጨሞ። ");
INSERT INTO alw_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ኢስ ህከንቤቺች ኬዕይ ኦሮአን ሄዕዮገን ለሙ ቆቁ መኑ «ደዉዴ ቤቶ! ሀዕይ አሙዝኔ» ይተን አዎንቶስ። ");
INSERT INTO alw_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ኢስ ምኒ ኣጎ ወክት እስ መድ ሆንጠክ «አን ካን አኣምገ አመዕንቴነንዶ?» ዬሰ፤ እሰን «ኤ ቀርቾ!» ይት ፈንቀሽቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ህከኒች ኤተሮን ኢስ አንጋንተስ እልሰ አፍ «አመዕንቴንተገን እሁንክዕኔ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","እልሰ ፈንተኦኡ፤ ኢስን «ከ ጠወ አዬሃ ጠወኦኖቼ» ይ ጠረኝሽ አዘዦሰ። ");
INSERT INTO alw_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ጠዉ እኮጎሬ እሰ መርት ህከን ባዶን ጉዕማንን ኢስተኔሃ ኩልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ሁኩ እልሰ ፈንተኣን ለኦ መኑ መርቶገን ዎሉ መኑ ዶሮረኖ ዱሩ አፎስ ዱደ መንቹ ኢስበ ኤቦኡ። ");
INSERT INTO alw_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ዶሮረኖ ዱሩ ፉሎች ኤተሮን ሁኩ መንቹ ጠወኡ ጀመሮ፤ መኑ «ህትናሙ ጠወ እስራኤላን ሆሮ ለዕኖምበአ» ይት አጀብሲጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ጠዉ እኮጎሬ ፈርሳውት «እስ ሩሃንየ ፉሸኖሁ ሩሃንይ ዎም ወልቃኒት» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ኢስ ዱኣ አኤኖ ምናን ተማርሰን፥ መገን ዎምነት ተሽት ላገተ አዋጀንለከ መነ ጥዘናች ጉዕሚችን ፈይሰን ከተመለከ ቀዕየተ ጉዕመንከ ሃመን ተማርሰኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","እስ መኑ ዜሞ ዮበእ ሆለገ እክ ብን ይት ኦርጨቀንተን ለዕዮሰ ወክት አሙዦሰ። ");
INSERT INTO alw_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ህካን እኮቤቺሃ አሳባተስ «አኤኖስ ሆጉት ልግብያን፤ ጠዉ እኮጎሬ ሆጉተ አአኖ መኑ ቀዎሃን። ");
INSERT INTO alw_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ህካን እኮቤቺሃ ሆጎስ አኑ ሆጎቤቹ መነ ሶሆተ ኡጭዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ኢስ ቶነ ለሙንከ አሳበተ እስበ ገእ ዶሮረኖ አያነ ፉሽቶተለከ መነ አደደ ጥዘናች ጉዕሚችን ፈይሰ ወልቀተ ኣሴሰ። ");
INSERT INTO alw_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ቶነ ለሞንከ አሳበ ሱዕሙ ከኒች ዎሮን ከተበሞኡ፤ እሰን «ጴጥሮሴ» ዬኖ ስሞኔት፥ አመስቤቱ እንድራሴት፥ ዘብዶሴ ኦሱት ያቁባት፥ ያህይት፥ ");
INSERT INTO alw_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ፍልጶሴት፥ ባርቴለሞሴት፥ ቶማሴት፥ ቀረጠ ሙረኖ ማቶሴት፥ እልፎሴ ቤቱ ያቁባት፥ ታዶሴት፥ ");
INSERT INTO alw_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ባዱስ ኢተኖሁ ይሁዳት እቅ። ");
INSERT INTO alw_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ኢስ ህከ ቶነ ለሙንከ አሳበተ «አይሁደ እኮበእ መንቤቹ መርቶኖቼ፤ ህትን ሰመር ከተመ ኣጎኖቼ። ");
INSERT INTO alw_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ሆለገ እክ በኦ እስራኤል መንቤቹ ኦሮዕዬ ");
INSERT INTO alw_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","‹ሰሜ ዎምነቱ ሆንጠኮ› ይቴነን ተማርስዬ። ");
INSERT INTO alw_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ጥዘናመተ ፈይሼ፤ ሬዮ መነ ሬሆች ኬሼ፤ ጎግ አሌን ፉልታ ሂለ ጥዘነት ዮ መነ ነጠ አዕዬ፤ ሩሃንየ ፉሽዬ፤ ጠለዕላን ኣኢቴንታሃ ጠለዕላንን ኣስዬ። ");
INSERT INTO alw_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ክሳንከክዕኔ ሳንትበተ አፎኖቼ። ");
INSERT INTO alw_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ዎቄሃክዕኔ ከረጥትተ ህከረንገ ለሙ ቀንቢሰ ህከረንገ ጫዕመተ ህከረንገ በርተ አፎኖቼ፤ መሰንትስ ሆጉተ አአኖ መንቺሃ እተኖሁ ሀስሰኖስ። ");
INSERT INTO alw_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","አዕኑ ኣጌነንተ ከተማን ህከረንገ ቀኤን ክዕኔተ ቶጎተ ሙንደአኖ መንቹ አጥራመቴን ደጌ፤ ህከ ቤቹ አጉርቴን መርቶኖተ ኢለ እሲን ሜጡበ አገሬ። ");
INSERT INTO alw_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","መን ምኒ ኣጌነንተ ወክት ‹ወገሬትሼ›። ");
INSERT INTO alw_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ምኔን ዮ መኑ ወገሬትክዕኔ ቶጎ ጎሬ ወገሬቱክዕኔ እሰ አሌን እሁን፤ ጠዉ እኮጎሬ ወገሬትክዕኔ ቶጉ ግቦጎሮ ወገሬቱክዕኔ ክዕኔ አደንከ ፈንቀሉን። ");
INSERT INTO alw_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","አዪሁ ቶጉ ግበኖህዕኔ ወክት ህከረንገ ጠወኤነንተ ጠወ ሞጮጩ ግበኖህዕኔ ወክት ህከ ምኒ ህከረንገ ህከ ከተመ አጉርቴን ፉልቴነን ሎከክዕኔ ትበ ግግሽቴን ፉሌ። ");
INSERT INTO alw_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","አን ሀንቅንከ ያንክዕኔ፤ ፍርድ በር ህከን ከተሚች በትሽ ሶዶምለከ ጎሞር ከተም መኒሃ ቅጣቱስ ቆሀኖ» ይ አዘዥ ሶኮ። ");
INSERT INTO alw_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ኢስን «ህትን ፉሽ ሆለገ ኦሌ በላን ሶሃንክዕኔ፤ ህካን እኮቤቺሃ ዎሪችገ ኤንኬዕናመተ ሀንደዕሬገ ጎደበ ላፋኑተ እኬ። ");
INSERT INTO alw_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ጠዉ እኮጎሬ ፍርድ ኦገት ዳኛኖበ ህግሴን ኣሴኖህዕኔ፤ ዱአ አኤኖ ምናን ሀለንጌን ኦሌኖህዕኔ፤ ህካን እኮቤቺሃ መኒች አገዕርዬ። ");
INSERT INTO alw_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ኢተኔሃ ባድ ዳኛኖቤቹሃ ዎም ብርተ መሴኖህዕኔ፤ አዕኑ እሳሃለከ አይሁደ እህበ መኒሃ መሰከርቴነንተ። ");
INSERT INTO alw_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","መኑ ፍርድቤቹ ሆንጠህሰኖህዕኔ ወክት ጠወኤነንተ ጠዉ ህከ ወክትንከ ኣሰመኖህዕኔቤቺሃ ‹ሀት› ህከረንገ ‹መ ጠወዕናም?› ይቴን ሻዞኖቼ። ");
INSERT INTO alw_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","መሰንትስ ክዕኔ ኣዜን ጠወአኖሁ ሰሜ አንክዕኔሃ አያነ ቤሉ ጠወኤነንታሁ አዕኖበአ። ");
INSERT INTO alw_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","መኑ ገይስ አመቤቱ ሬሆተ ህግሽ ኣሰኖ፤ ህትን አኑ ገይስ ቤቱ ሬሆተ ህግሽ ኣሰኖ፤ እለት አነሰ ህከረንገ አመሰ ዲንስት ሬሆተ ህግስ ኣታአ። ");
INSERT INTO alw_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ጉዕሙንኩ መኑ ኢ ሱዕምተኔሃ ግበኖህዕኔ፤ ጠዉ እኮጎሬ መጨረሸ ኢለ ጠረኝ ኡረኖሁ ፈቀኖ። ");
INSERT INTO alw_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","መቶ ከተማን ኦርሸት በተኣ ወክት ዎሉ ከተመ ሁኜ፤ አን ሀንቅንከ ያንክዕኔ፤ መንች ቤቱ ፈንቀል አሜቶተ ኢለ እስራኤል ከተመ ጉዕመንከ ኢልቴነንተበአ። ");
INSERT INTO alw_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ተማረኖሁ ተማርሰኖስሀኒች ህትን ካድንቹ ቀርቺች በተአኖበአ። ");
INSERT INTO alw_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ህካን እኮቤቺሃ ተማረኖሁ ተማርሰኖሀንገ ህትን ካድንቹ ቀርችስገ እኮች እሀኖስ፤ ጠዉ እኮጎሬ ምንስ አነ ‹ቤዔልዜቡል› ዬን ገኤመ ጎሬ ምንስ አበሮስ ህከኒች ባሰ ሂለ ሱዕሚን ገኤኖበእንዶ?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","ኢስ «መነ ዋጅቶኖቼ፤ መሰንትስ እፍሰሞሁ ፈንተኡነ ህትን ማጠሞርቹ ለሉዕነ ፈቀኖበአ። ");
INSERT INTO alw_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","አን ቱንስቾን ኩላንክዕኔሃ አዕኑ በራን ኩሌ፤ ህትን ማጤን ኩሌነን ሞጮጭቴንተ ጠወ በነቻን ፉልቴን ጠወዕዬ። ");
INSERT INTO alw_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ማለ ሽታረ እኮጎሬ ፎል ሽቶተ አታልታበእረ ዋጅቶኖቼ፤ ጠዉ እኮጎሬ ማለለከ ነብሳሃ ጠእትበ ጊራን ኡጆተ አታለኖ መገኑ ዋጅዬ። ");
INSERT INTO alw_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ለምተ ጭኡት መቶ በከናን ህረንታእበእንዶ? ጠዉ እኮጎሬ ሰሜ አኑክዕኔ ይበጎሬ ኢች ሆሮ መት ጭኡቲ ኡለ ኡብ ፈቃበአ። ");
INSERT INTO alw_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ክዕኔ ሙሙክዕኔ ፈቁዕነ ዎለአሞእሃን። ");
INSERT INTO alw_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ህካን እኮቤቺሃ ዋጅቶኖቼ፤ አዕኑ ልግብ ጭኦች በተኤነንተ። ");
INSERT INTO alw_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«መን ብሬን ኢተኔሃ መሰከረኖሀኒሃ ጉዕሚንከ አን ሰማን ዮ አኒኤ ብሬን መሰከራንስ። ");
INSERT INTO alw_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ጠዉ እኮጎሬ መን ብሬን ለገአኖኤሃ አዬሁ አን ሰማን ዮ አኒኤ ብሬን ለገኣንስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","ኢስ «አን ኣዱንያ አሌን ወገሬት ኤቦተ አሜቾሚሃ አጉዱንከህዕኔ፤ አን አሜቾሚሁ በገዙ ኤቦታት ቤሉ ወገሬት ኤቦታበአ። ");
INSERT INTO alw_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","መሰንትስ ቤቱ አኒን ህትን ቤቱተ አማንተሴ ቤቲተ በሎንተሴ ብተንሶተ አሜቾም። ");
INSERT INTO alw_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","መኒ ባለገሩ ገይስ ምኒ መነ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","አዪሁ አነስለከ አመስ ኢች በትሽ ኢቴ ጎሬ ኤሳሃ እሆተ ሀስሰኖበአ፤ ህትን አዪሁ ቤቱስ ህከረንገ ቤቱተ ኢች በትሽ ኢተኖሁ ኤሳሃ እሆተ ሀስሰኖበአ። ");
INSERT INTO alw_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ገይስ መስቀለ እጅ አዎንበኤሁ አዪሁ ኤሳሃ እሆተ ሀስሰኖበአ። ");
INSERT INTO alw_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ፎልስ ፌሶተ ኢተኖሁ አዪሁ ቤሰኖ፤ ጠዉ እኮጎሬ ፎልስ ኢተኔሃ ቤሰኖሁ አዪሁ ፈቀኖ። ");
INSERT INTO alw_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","ክዕኔተ ቶገኖሁ አዪሁ ኤሳሃ ቶገኖ፤ ኤሳሃ ቶገኖሁ አዪሁ ኤሳሃ ሶኮሃ ቶገኖ። ");
INSERT INTO alw_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ነብዬቹ ነብዬች ሱዕሚን ቶገኖሁ ነብዬች ዋጋ ደአኖ፤ ፈየ መንቹ ፈዪ ሱዕሚን ቶገኖሁ ፈዪ ዋጋ ደአኖ። ");
INSERT INTO alw_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ሀንቅንከ ያንክዕኔ፤ ኢ አሳቤቹ እኮቤቺሃ ከን ማዕናኖች መትሀስ መቱ ቡርጩቆ ዋሀ ኣሰኖሁ አዪሁ ዋገስ ደኡዕነ ፈቀኖበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ኢስ ቶነ ለሙንከ አሳበስ አዎንታገ አዘዥ ሹሎች ኤተሮን ህከ ቤቹ ጌኝ አዕይ ግደኖን ዮ ከተመ ዱዱብሶተለከ ተመርሶተ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ህከ ወክት ጠመቃንቹ ያህይ ኡሱር ምኔን ሄዕዮገ መሲህ ኢስተኔሃ ሞጮጭ ");
INSERT INTO alw_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","« ‹አሜተኖ› ዬመ መሲህ ኢስ አቴትንዶ? ህከረንገ ዎሉ አገርኑ» ይ አዎናኑስ ኢስበ ሶኮ። ");
INSERT INTO alw_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ኢስ «መርቴን ለኤንታሃለከ ሞጮጭቴንታሃ ያህዪሃ ኩሌ። ");
INSERT INTO alw_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ሁኩዕኑን ቆቃኑት ለኣኢት፤ ሎከተ ናፉ መኑ ጌጥ ይ ሃመኖት፤ ጎግ አሌን ፉልታ ሂለ ጥዘነት አፎሰ መኑ ነጠ እካኢት፤ ዶንቁ መኑ ሞጮጨኖት፤ ሬዮ መኑ ሬሆች ኬአኖት፤ ቡጥቻኖተ እንጂሉ ዱዱብሰመኖት። ");
INSERT INTO alw_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ኢተኔሃ ሸክባሁ ማሰአሞእሃ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ያህይ አዎናኑት መርቶች ኤተሮን ኢስ ህከኔ ጭምዬ መኒሃ ያህይተኔሃ ጠወአን «መ ለኢሃት ኡለ ኡድመ ፉልቴንታሁ? ቦብሩ ሌንቄቅሰኖ ሸምቦቁተ ለኢሃትንዶ? ");
INSERT INTO alw_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","መ ለኦኖተ ፉልቴን? ጡመተ ኦድኑተ ኦደዕዮ መነ ለኢሃትንዶ? ጡመተ ኦድኑተ ኦደዕዮ መኑ ሄአኖሁ ዎመ ምናኒት። ");
INSERT INTO alw_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ህከረ መ ለኦኖተ ፉልቴን? ነብዬቹ ለኦኖታትንዶ? ኤ! አን ያንክዕኔ፤ ነብዬቺች በተአኖሃ ለኢሃት። ");
INSERT INTO alw_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","‹ሁኩዕኑን ዎቃክ ብዝ አአኖ ሶቀማንቹኤ ብሬክ ሶሃም› የመም እስተኔሃ ከተበሞሁ ከኒት። ");
INSERT INTO alw_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ሀንቅንከ ያንክዕኔ፤ ከን ኣዱንያ አሌን ከለቀሞ መኒች ጉዕሚችን ጠመቃንቾ ያህዪች በተአኖሁ ዮበአ፤ ጠዉ እኮጎሬ ሰሜ ዎምነቴን ጉዕሚችን ሆፈአኖሁ እሲች ሎዕረኖ። ");
INSERT INTO alw_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ጠመቃንቾ ያህይ ዘማኒች ኬሽ ከበሬ ኢለ ሰሜ ዎምነቱ ወልቃን ኣጎተ አበ አጰንታኢት። ");
INSERT INTO alw_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","«ነብያኑትለከ ሙስ አንጋን ኣሰሞ ሕጉሁ ጠመቃንቾ ያህይ ወክት ኢለ ራገ ጠወኦኡ። ");
INSERT INTO alw_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ቴሱ ቶጎኖተ ሀሴንተ ጎሬ ‹አሜተኖ› ዬመ እልያስ ከኒት። ");
INSERT INTO alw_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ሞጮጭታ መጨት ዮሲሁ ዮ ጎሬ ሞጮጩን። ");
INSERT INTO alw_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«ጠዉ እኮጎሬ ከን ዘማን መነ ሚን አጉጣቀንሳም? እሰ ጌባን አፉዕልት መት-መቱሰ ገእተን ");
INSERT INTO alw_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹ሁሉሌተ ቡንሳንክዕኔረ ቦለቸ ከዴንታበአ፤ ህትን ኦዕናምረ ቶጌንታኔበአ› ይተን አለጵታ እለተ አጉዳአ። ");
INSERT INTO alw_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","መሰንትስ ያህይ እቱዕነለከ አጉዕና አሜቾ ወክት ‹ዶሮረኖ ዱሩ አፎስ› ይቶስ። ");
INSERT INTO alw_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","መንች ቤቱ እተንለከ አገን አሜተኖረ ‹ኩ መንቹ እቱሃ አጉሃ ኢተኖ፤ ህትን ቀረጠ ሙረኖ መኒሃለከ ጩበኛኖተ ጃላ!› ዬመስ፤ እኮጎሬ ሀይቹ ሆጎንተስ ለለኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ኢስ ልግብ አጀብሲሰኖ ጠወ አዕዮ ከተም መኑ ጩብችሰ ፈንቀሉ ግቦቤቺሃ ዎቀሱ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«ኣዬ ኮራዜ! ኣዬ ቤተ ሳይዳ! ክዕኔን እኮ አጀብሲሰኖ ጠወ ጢሮስለከ ሲዶን ከተሚሃ አሰሞ እቃን ሁኩ መኑ ሄጭት ጥጅ ኦድኑተ ኦደእ ጠበሩ አሌሰ አት ጩብችሰ ፈንቀሉሰ ለሊሳ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ጠዉ እኮጎሬ አን ያንክዕኔ፤ ፍርድ በር ክዕኔች አበ ጢሮስለከ ሲዶን ከተም መኒሃ ፍርዱስ ቢለኖ። ");
INSERT INTO alw_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","አት ቅፍርናሆም ከተንቹት! ሰማሃ ኢለ ጎት ጎት ይቶንትንዶ? አዛቤን ድርታንት፤ ኪን አሰሞ አጀብሲሰኖ ጠዉ ሶዶም ከተማን አሰሞ እቃኔተ ሁኩ ከተሙ ከበሬ ኢለ በኡዕነ ኢልታ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","አን ሀንቅንከ ያንክዕኔ፤ ፍርድ በር ኪች በትሽ ሶዶም ከተም ፍርዱ ቆሀኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ህከ ወክት ኢስ «ሰሜለከ ኡለ ቀርቹ እኮንት ኢ አነ! ካን ሀይቻኖችለከ ደጋሀኑኡች ማጥ ቀልቡስ ኦሶገ ቶገኖ መኒሃ ለሊሶንትቤቺሃ ገለትጫንኬ። ");
INSERT INTO alw_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ኤ ኢ አነ! ኪ ጡሙ ሰውቱ ህትናሙሃን። ");
INSERT INTO alw_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","አኑኤ ጉዕመርቹንከ ኣስዮኤ፤ አኒ ቤሉ ቤቱ ደገኖሁ አዪሁ ዮበአ፤ ህትን ቤትለከ ቤቱ ለሊሶተ መጠሮ መንች ቤሉ አነ ደገኖሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«አዕኑ እጅነት ኬዕምታንክዕኔ ሆጌንተ መኑ ጉዕሙንኩ ኢቤቹ አሜ፤ አን ፎሎሲሳንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ኢ አንገቼተ እጅዬ፤ ኢችን ትምርት ኣእዬ፤ አን ጎደበ ላፋለከ መረርሲጫምሃን፤ ፎልሃክዕኔ ፎሎጩ ደዕቴነንተ። ");
INSERT INTO alw_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","አንገቼእ ኬዕምታበእታን፤ እጅነኤን ኬዕምታበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ህከ ወክት ኢስለከ አሳበስ አበ በሬን አለስ ኣዚን ህጋኢት እቅ፤ አሳበስ ጎሩ አፎሰቤቺሃ ሀማሙተ ተንቅስ ቁስት እቱ ጀመርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ፈርሳዉት ህካን ለኦ ወክት ኢሰ «አሳበክ አበ በሬን አኡ ገበእበ ጠወ አታኢሃ ለእ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ኢስን ፈንቀሽ «ዳዉድለከ እሲን ሜጡበ ሄዕዮ መኑሁ ጎሩ አፎሰ ወክት ዳዉድ አዕዮሃ አነበቤንታበእንዶ? ");
INSERT INTO alw_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ዱእ ምኒ ኣግ ቂስ ቤሉ እስ ህከረንገ እሲን ሜጡበ ሄኦ መኑ እቶተ ፈቀደሞበእ መገኒሃ አደ እኮ ዳቡተ እቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ህትን ቂሰት አበ በሬን መገን ምኔን አተን ፎሎጭ በሬ ሕገ ድጅታ ወክት ቤሱ እሀኖሰበእገ ሙስ መሳን ኣሰሞ ሕጋን ከተበሞሃ አነበቤንታበእንዶ? ");
INSERT INTO alw_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ጠዉ እኮጎሬ መገን ምኒች በተአኖሁ ከበ ዮኡ። ");
INSERT INTO alw_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‹አን ክትሚች አበ አሙዙ ኢታም› ዩ መ ዩሃ ጎሬ አጥራመቴንታእቃን ቤሾበእ መን አሌን ፈረዴነንተበ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","እኮጎሬ መንች ቤቱ አበ በሬተ ቀርቹሃን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ኢስ ህከንቤቺች ኬዕይ ጭምትሰ ምኒ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ህከንቤቾንን መቱ አንገተ ናፉ መንቹ ሄዕዮ እቅ፤ እሰን ከሰሶስተ ሀስ «አበ በሬን ጥዘናሙ ፈይሱ ፈቀደሞእንዶ?» ይት ኢሰ ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ኢስን ፈንቀሽ «ክዕኔኤች መት ሆልቹት ዮሲሁ አበ በሬን በዋን ኡቦጎሬ በዊች ፉሽባሁ አዬት? ");
INSERT INTO alw_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ህካን እኮች መንቹ ሆልቺች አበ በተአኖበእንዶ? ህካን እኮቤቺሃ አበ በሬን ጡመ ጠወ አኡ ሀስሰኖሃን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ህከኒች ኤተሮን ኢስ አንገተ ናፈ መንቹ «አንገክ ሂር» ዬእ፤ መንቹንኩ አንገስ ሂሮ ወክት ዎሌ አንገስገን ፈየተ አንገተ እኮኡ። ");
INSERT INTO alw_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","እኮጎሬ ፈርሳውት ህከንቤቺች ፉልት ኢሰ ሀት አት ሽታስጎሬ አማዕለንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ኢስ እሰ አማዕለሙሰ ደግ ህከንቤቺች ገበጭ ዬእ፤ ህትን ልግቡ መኑ አዎንቶስ፤ እስን ጉዕመንከሰ ፈይሾ። ");
INSERT INTO alw_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","እሰን እስተኔሃ አዬሃ ጠወኣበእገ አዘዦሰ። ");
INSERT INTO alw_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ሁኩን እኮሁ መገኑ ነብዬቾ እስያሴን ");
INSERT INTO alw_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«ሁኩዕኑን! አን መጠሮም ካዲንቹኤ፤ እስ አን ኢታሚሃለከ ሙንደኣምሃን፤ እስ አሌንን ጠሊለ አያነኤ አኣም፤ እስን ሀንቅ ፍርደ አይሁደ እህበ ኡመቲሃ አዋጀኖ። ");
INSERT INTO alw_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","እስን ኦደኖበአ ህከረንገ ያረኖበአ፤ ዎቄ አሌን ጉዕማንን ላገስ ሞጮጨኖሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","እስን ሀንቅ ፍርደ አኦተ ኢለ ቀጠቀጠንቶ ሾምቦቁተ ቢጠኖበአ፤ ህከረንገ ዉሊለኖ ኩራዝ ፈትለ ኡፍ አዕይ ጠእሰኖበአ፤ ");
INSERT INTO alw_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ህትን መገኑ ደግቡ መኑ ሱዕማንከስ ተብሳሃ አአኖ» ዬ ጠዉ ዊሞታት። ");
INSERT INTO alw_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ህከኒች ኤተሮን መኑ መቱ ዶሮረኖ ዱሩ አፎስ ቆቀለከ ዱደ መንቹ ኢስበ ኤቦኡ፤ ኢስን ህከ መንቹ ጠወአኖገለከ ለአኖጋ አዕይ ፈይሾ። ");
INSERT INTO alw_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ህካን እኮቤቺሃ መኑ ጉዕሙንኩ አጀብሲጭ «ኩን ደዉዴየ ቤቱንዶ?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","እኮጎሬ ፈርሳውት ህካን ሞጮጭቶ ወክት «ኩ መንቹ ሩሃንየ ፉሸኖሁ ‹ብዔልዜቡል› ዬኖ ሩሃንይ ሀለቅች ዎልቃኒት» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ኢስ እሰ ቀልብ ጠወ ደግ «መቱ ዎሙ አደ እክ ገገይንከስ ብተመኖሃ እኮች ሁኩ ዎሙ ኡበኖ፤ ህትን መቱ ከተሙ ህከረንገ መቶ ምኔን ሄአኖ መኑ ገገይንከስ አደ እኮች ጠረኝ ሄኦተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ሸይጣነ ሸይጣኑ ፉሸኖሃ እኮች ገገይንተስ አደ እኮ ዩሃን፤ ህካን እኮች መንግስቱስ ሀት እክ ጠረኝ ሄኦተ አታለኖ? ");
INSERT INTO alw_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","አን ብዔልዜቡሌ ዎልቃን ሩሃንየ ፉሻሚሃ እኮች ክዕኔ መኑ አዬ ዎልቃን ፉሽታአ? ህካን እኮቤቺሃ መኑክዕኔ ክዕኔ አሌን ፈረዳእረ እካአ። ");
INSERT INTO alw_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","አን ሩሃንየ ፉሻሚሁ መገን አያኒን እኮች ቴሱ መገን ዎምነቱ ክዕኔቤቹ አሜተኖ። ");
INSERT INTO alw_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ህትን መቱ መንቹ መቱ ጠረኘ መንቹ ኡሱርባች ምንስ ቢጭ ኣግ ዱንያስ ዘረፎተ ሀት እክ አታለኖ? እኮጎሬ ህከ ጠረኘ መንቹ ኡሱሮች ኤተሮን ዱንያስ ዘረፎተ አታለኖ። ");
INSERT INTO alw_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","አዪሁ ኢን ሜጡ እህባሁ ኢን ሀንበዕለመኖ፤ ህትን ኢን ጭምአእቡ ጉዕሙንኩ ብንአአኖ። ");
INSERT INTO alw_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ህካን እኮቤቺሃ አን ኩላንክዕኔ፤ መኑ አዕዮ ጩቡ ጉዕሙንኩ፥ ቦሮር ላገቲ ፈቁን የመንታአ፤ እኮጎሬ ጠሊለ አያን አሌን ጠወኤኖ ቦሮር ላገት ጉዕሙንኩ ማረመኖስበአ። ");
INSERT INTO alw_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","መንች ቤት አሌን ቦሮር ላገተ ጠወአኖአን ቤሱ ማረመኖስ፤ ጠዉ እኮጎሬ ጠሊለ አያን አሌን ቦሮር ላገተ ጠወአኖአን ቤሱ ከን ዘማኔንለከ አሜተኖ ዘማኔን ማረመኖስበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","ኢስ «ሀቁ ጉዕሙንኩ ላልቺንከስ ደገመኖቤቺሃ ጡሙ ላልቹ ሄኡንክዕኔ፤ ላልቹስ ጡመ እኮጎሬ ሀቁሲ ጡመሃን፤ ላልቹስ ሂለ እኮጎሬ ሀቁሲ ሂለ ዩሃን። ");
INSERT INTO alw_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ቀልቤን ዊሞሀኒች አፎሁ ጠወአኖቤቺሃ አዕኑ ኩ ዎሪች እለት! ሂላኑተ እኬነን ሀት እኬን ጡመ ጠወ ጠወኦኖተ አታልቴነን? ");
INSERT INTO alw_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","«ጡሙ መንቹ ጡመ ጠወ ማጮ ጡመ ቤቺች ጠወአኖ፤ ሂሉ መንቹ ሂለ ጠወ ማጮ ሂለ ቤቺች ጠወአኖ። ");
INSERT INTO alw_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","አን ሀንቅንከ ያንክዕኔ፤ ሀኩ መንቹሁ ህትን ጠወአኖ ሀስስበ ጠዊሃ ጉዕሚንከ ፍርድ በር ጠዕመመኖ። ");
INSERT INTO alw_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","መሰንትስ ጠወኦንት ላጋን ነጠ እካንት፤ ህትን ሂለ ጠወኦንት ላጋንን ፈረደመኖሄ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","መት-መቱ ሕግ አስተማረትለከ ፈርሳውት ኢሰ «አስተማርቾ! አት መላተ አተን ለዕኖተ ሀንሳም» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","እስን ፈንቀሽ «ከን ዘማን ሂሉለከ አመዕንቡ ክልቀቱ መላተ ለኦተ ሀሰኖ፤ ጠዉ እኮጎሬ ነብዬቾ ዩኑስ መላ ቤሉ ዎልት መላት ኣሰመኖስበአ። ");
INSERT INTO alw_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ዩኑስ ሎረ ቁርጩሜ ጎደባን ሰሱ በራለከ ሰስ ሀዎሩተ ዱንኬሀንገን መንች ቤቱሁ ኡለ ኣዜን ሰሱ በራለከ ሰስ ሀዎሩተ ዱንከኖ። ");
INSERT INTO alw_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ናናዌ ከተም መኑ ፍርድ በር ከን ዘማን መኒን ሜጡበ እክ እሰ አሌን ፈረዳአ፤ መሰንትስ ናናዌ መኑ ዩኑስ ዱዱብሴኢሃ ሞጮጭቶ ወክት ጩብችሰ ቶበት ፈንቀልቶኡ፤ ሁኩዕኑን ዩኑሲች በተአኖሁ ከበ ዮኡ። ");
INSERT INTO alw_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ካኣጵ ዎመት ሱለይማን ሀይመተ ሞጮጭቶተ ኡለ ገበሊች አሜቶቤቺሃ ፍርድ በር ከን ዘማን መኒን ሜጡበ እሰ አሌን ፈረዳአ፤ ሁኩዕኑን ሱለይማኒች በተአኖሁ ከበ ዮኡ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ኢስ «ዶሮረኖ ዱሩ መንቺች ፉሎ ወክት ፎሎጨኖ ቤቹ ሀሰን ዉሁ ዮበእቤቾን ጉዕማንን ዘሀኖ፤ እኮጎሬ ደአኖበአ። ");
INSERT INTO alw_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ህካን እኮቤቺሃ ‹ፉሎም ምኒ ፈንቀል ኦሮኣም› የኖ፤ እስን ፈንቀል አሜተኖረ ምኑስ ኦነ እክ ሀጣወም ተቃጠብያን ደገኖ። ");
INSERT INTO alw_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ህከኒች ኤተሮን ኦሮዕይ እሲች ሂላኑተ ዎሉ ለመለ ሩሃንየ ኤበኖ፤ እሰን ህከን መንቾን ኣግ ሄኣአ፤ ህካን እኮቤቺሃ ህከን መንች ሄኡ ዎኔች ኤተርሲሁ በትሽ ሂለ እሀኖ፤ ከን ዘማን ሂለ መን አሌን ህትኔ ጠዉ እሀኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ኢስ ኡመቲሃ ጠወአንን አመስለከ አመስኦሱት ደቀንቶስተ ሀስ አብሌን ኡርቶ እቅ።  ");
INSERT INTO alw_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","መቱ መንቹ ኢሰ «አመክለከ አመክ ኦሱት ደቀንቶሄተ ሀስ አብሌን ኡርቶኡ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","እኮጎሬ ኢስ ህከን መንቺሃ ፈንቀሽ «አመኢለከ አመኤ ኦሱቲ አዬኤታን?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ህከኒች ኤተሮን አንገስ አሳበስ አደ ለልሰን «አመእለከ አመኤ ኦሱቲ ከኑኡታን። ");
INSERT INTO alw_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","መሰንትስ ሰማን ዮ አንኤ ሃሽኣቱተ ዊንሸኖሁ ጉዕሙንኩ አመኤየ ቤቱ፥ አመኤተ ቤቱለከ አመተኤ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ህከ በር ኢስ ምኒች ፉል ባር መዴን አፉዕሌእ። ");
INSERT INTO alw_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ልግቡ ኡመቱ እስበ አሜች ጭምዬቤቺሃ ኢስ ጀልባን ኣግ አፉዕሌእ፤ ኡመቱ ጉዕሙንኩ ባር መዴን ኡርዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ህከኒች ኤተሮን ኢስ ልግብ ጠወ ማቆን ኩለን «ሁኩዕኑን! መቱ መንቹ ዜሬተ ዉጦተ ፉሎ። ");
INSERT INTO alw_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ዉጠንን መት-መቱስ ዎቄ ገበላን ኡባን ጪኡት አሜት እቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ዎሉ ዜሬቱ ልግቡ ትቡ ዮበእቤቾን ክኑ ዮ ኡላን ኡቦ፤ ልግቡ ትቡ ዮበእቤቺሃ ደዕል ሙቾ፤ ");
INSERT INTO alw_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ጠዉ እኮጎሬ አሩ ፉሎ ወክት ቆሮ፤ ጠጱ ዮስበእቤቺሃ ሞሎ። ");
INSERT INTO alw_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ዎሉስ ዜሬቱ ኡት ኣዜን ኡቦ፤ ኡቱ ነጵ ሙተ አጉዕሜእ። ");
INSERT INTO alw_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ዎሉ ዜሬቱ ጡመ ኡላን ኡብ ሙች መቱስ ጥብተ፥ መቱስ ሌሃዉ፥ መቱስ ሰጁ አቶቾ ");
INSERT INTO alw_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ሞጮጭታ መጨት ዮሲሁ ሞጮጩን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ህከኒች ኤተሮን አሳበስ ኢስበ አሜት «መኒሃ ማቆን ጠወኣንቲሁ ሚሃት?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ኢስን ፈንቀሽ «ሰሜ ዎምነት ምስጥረ ደጉ ኣሰሞህዕኔ፤ ጠዉ እኮጎሬ ህካን ደጉ እሳሃ ኣሰሞሰበአ። ");
INSERT INTO alw_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","መሰንትስ ዮስ መንቺሃ ኣሰመኖስ፤ አበንከ በተአኖስ፤ ዮስበእሀኒች ሁኩ ዮሲንኩ ኣአመኖስ። ");
INSERT INTO alw_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","አን እሳሃ ማቆን ኩላንሳሃ ለአን ለእበረ፥ ሞጮጭተን ሞጮጭትበረ፥ አጥራመትቡረ እኮቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ህካን እኮቤቺሃ ነብዬቾ እስያሴን « ‹ሞጮጩ ሞጮጭቴነንተ፤ ጠዉ እኮጎሬ አጥራመቴነንተበአ፤ ለኡስ ለኤነንተ ጠዉ እኮጎሬ ሆሮን ቀልብ አቴነንተበአ። ");
INSERT INTO alw_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","መሰንትስ ከን መን ቀልቡ ዱጆኡ፤ መጨንትሰ እፍሰንቶኡ፤ እልንትሰ ቆቆኡ፤ ህት እኮበእቀ፥ እሌንከሰ ለእ፥ መጫንከሰ ሞጮጭት፥ ቀልብንከሰ አጥረመት፥ ኢ አደ ፈንቀልቶ እቃን ፈይሳንሰ እቅ› » የመሞ ጠዉ አሌሰ ዊመኖ። ");
INSERT INTO alw_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«እኮጎሬ ክዕኔ እልት ለኣቤቺሃ፥ መጨክዕኔን ሞጮጭታቤቺሃ ማሰአንቶእራን። ");
INSERT INTO alw_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","አን ሀንቅ ያንክዕኔ፤ ከ አዕኑ ለኤነንታሃ ልግቡ ነብያኑትለከ ልግቡ ጠሊላኑት ለኦተ አበ ሄዕላቶ እቅ፤ ጠዉ እኮጎሬ ለኦበአ፤ ህትን ከ አዕኑ ሞጮጭቴንታሃ ሞጮጭቶተ ሄዕላቶ እቅ፤ እኮጎሬ ሞጮጭቶበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","ኢስ «ቴ አዕኑ ከን ዜሬተ ዉጣንች ምሳሌ ፍሳረተ ሞጮጭዬ። ");
INSERT INTO alw_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","አዪሁ መገን ዎምነት ላገተ ሞጮጭ አጥራመትቡ ዎቄ አሌን ኡቦ ዜሬተ አጉደኖ፤ ሸይጣኑ አሜች ዉጠንቶ ላገተ ቀልቢችስ ኣእ ከመኖ። ");
INSERT INTO alw_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ልግቡ ትቡ ዮበእቤቾን ክኑ ዮ ኡላን ኡቦ ዜሬቱ ላገስ ሞጮጭ ደዕል ሙንዲኖን ቶገኖ መንችተ ምሳል። ");
INSERT INTO alw_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","እኮጎሬ ጠጱ ዮስበእቤቺሃ ቀዉ ወክት ዱንከኖ፤ ህከን ላገ መሳን ኦርሸት ህከረንገ ያየሙ ኬእዮእቃን ወክትንከስ ደዕልን አመዕነቲችስ ኡበኖ። ");
INSERT INTO alw_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ሁኩ ኡት ኣዜን ኡቦ ዜሬቱ ላገስ ሞጭጨኖ መንችተ ምሳል፤ እኮጎሬ ከን ኣዱንያ አሌን ሄእ ጠወ ሰውዩለከ ቀባጦን ናጠቀሙ ቀልቤስ ኣግ ሞጮጬ ላገተ አቶቱ ዮበኢሃ ፌሰኖ። ");
INSERT INTO alw_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ጡመ ኡላን ዉጠሞ ዜሬቱ ላገስ ሞጮጭ ቀልቤስ ቶግ ኣኤ መንችተ ምሳል፤ እስን መቱ ጥብተ መቱ ሌሃዉ መቱ ሰጁ አቶተኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ህትን ኢስ ዎሌ ምሳሌን «ሰሜ ዎምነቱ ኡላንከስ ጡመ ዜሬተ ዉጮ መንቺን አጉጣቀመኖ። ");
INSERT INTO alw_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ጠዉ እኮጎሬ መኑ ግሾ ወክት ዲኑስ አሜች አለስ ኣዜን ቅንጭተ ዉጭ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ህካን እኮቤቺሃ አለሱ ነጵ አቶቾ ወክት ቅንጭንትስ ህከ ወክት ለልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ካዲመስ ኡለስ አንቤቹ አሜት ‹ቀርቾ! አቡራንከክ ጡመ ዜሬተ ዉጦንት እቅበእንዶ? ህከረ ቅንጭት ሀከን አዲች አሜቶኡ?› ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","እስን ፈንቀሽ ‹ህካን አዕዮሁ ዲና› ዬእ፤ ካዲመንት ፈንቀሽት ‹ህከረ መርን ቅንጭተ ቡቱንክ ከሞተ ሀሰንንዶ?› ይት ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","እስን ፈንቀሽ ‹እሀኖበአ! መሰንትስ ቅንጭተ ቡቱኬነንተ ወክት አለሱ ሜጡበ ቡቱኬነንተ። ");
INSERT INTO alw_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ህካን እኮቤቺሃ ምዴኖ ወክቱ ኢሎተ ኢለ አለሱ ቅንጬን ሜጡበ ነጱን፤ ምዴኖ ወክት ምዳሀኑኡተ ሄጭቴን ቅንጭተ ቡቱኬን ጊረ ቡቦተ ኡሱሬ፤ እኮጎሬ አለሱስ ጭምአቴን ጎተራንከኤ ዎሬ ያም› ዬእ» ይ ኩሎሰ። ");
INSERT INTO alw_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ኢስ «ሰሜ ዎምነቱ መቱ መንቹ ጋሮ ኣዜን ዉጮ ዎንጌ እሌ ዜሬተ አጉዳኣ። ");
INSERT INTO alw_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","እሴን ዜሬት እሌች ጉዕሚችን ቀዉተ፤ እኮጎሬ ነጵቶ ወክት ጋሮን ካሴኖ አታክልቲች በተኣአ፤ ሎረ እካን ሰሜ ጪኡት አሜት ሀማንከሴ ምኒ እጃርታአ» ይ ዎሉ ምሳልተ ኩሎሰ። ");
INSERT INTO alw_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ኢስ ዎሎ ምሳሌን «ሰሜ ዎምነቱ መት መንቹት ጉዕሙንኩስ ሁፍ ዮተ ሰሶ ኮርቦቦ ቀማን ሜጡበ ቁፍሶ ራጭተ አጉዳአ» ይ ኩሎሰ። ");
INSERT INTO alw_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ኢስ ከ ጉዕመንከ ጠወ ልግብየ ኡመቲ ምሳሌን ጠወዕዮ፤ ምሳልት ዮበኢሃ መቱርቹሃ ጠወዕዮሰበአ። ");
INSERT INTO alw_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","እስን ነብዬቾን «ጠወኤ ምሳሌን ኩላም፤ ኣዱንያት ከለቀንቶች ኬሽ ደጵ ዬ ጠወ ጠወኣም» የመሞሁ ዊሞታት። ");
INSERT INTO alw_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ኢስ ልግብ ኡመት አጉር ምኒ ኣጎ ወክት አሳበስ እስበ አሜት «አለሲን ሜጡበ ነጴ ቅንጬ ምሳልተ መሃጎር ኩልኔ» ይት ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ኢስን ፈንቀሽ «ጡመ ዜሬተ ዉጮሁ መንችየ ቤቱ። ");
INSERT INTO alw_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","አቡረስ ከን ኣዱንያሃ አል፤ ጡሙ ዜሬቱ መገን ዎምነትተ እለ፤ ቅንጭንት ሸይጣንተ እለ። ");
INSERT INTO alw_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ቅንጭተ ዉጮ ባለጋሩ እልቢስሃን፤ ምዴኖስ ወክቱ ኣዱንያሃ መጨረሸ፤ ምዳእሩ መገንተ መላይከ። ");
INSERT INTO alw_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ህትን ቅንጭተ ጭምአኤን ጊራን ቡሴኖሀንገን ዘማን ጎፍሞኒ ህት እሀኖ። ");
INSERT INTO alw_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","መንች ቤቱ መላይከስ ሶክ መኑ ጩብ አአኖገ አታረለከ ሂለ ሆጉተ አቶረ እስ ዎምነቲችስ መጥ ፉሽታአ። ");
INSERT INTO alw_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","እሰንተ ጠረኘ ጊራን ኡጄናን ኦኡለከ የቡሩ ገዕሙ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","እኮጎሬ ሙጩራኑት አንሰ ዎምነቴን አሪገ ለሊሳአ፤ ሞጮጭታ መጨት ዮሲሁ ሄዕዮ ጎሬ ሞጮጩን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","ኢስ «ሰሜ ዎምነቱ መቴ አቡረ ኣዜን ማጠንቶ ቀባጡተ አጉዳአ፤ መቱ መንቹ ህከ ቀባጡተ ደኤ ወክት ፈንቀሽ ማጭ ሙንደአን ኦሮዕዮች ኤተሮን ዮሲሃ ጉዕመንከ ህር ህከ ኡለተ ህዕሬእ።» ");
INSERT INTO alw_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ህትን ኢስ «ሰሜ ዎምነቱ አበ ጤአተ እኮ ክኑ ህዕሮተ ሀሰኖ ነጋዴተ አጉዳኣ። ");
INSERT INTO alw_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","እስን ዋጉስ አበ ጤአተ እኮ ክኑ ደኤ ወክት ምንስ ኦሮዕይ ዮሲሃ ጉዕመንከ ህር ህከ አበ ጤአተ እኮ ክኑ ህዕሬእ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ህትን ኢስ «ሰሜ ዎምነቱ ባራን ኡጄናን አደደ ቁርጩሜተ ጭምአአኖ ዎሻደ አጉዳኣ። ");
INSERT INTO alw_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ዎሻዱስ ዊሞ ወክት መኑ ገበለ ፉሽ ጡመስ መጠር ኦዳንከስ ዎር ሂለስ ቶረኖ። ");
INSERT INTO alw_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ዘማን ጎፍሞን ህት እሀኖ፤ መገን መላይካት አሜት ጩበኛኑተ ፈየ መኒች አደ አታአ። ");
INSERT INTO alw_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ጩበኛኑስ ጠእትበ ጊራን ቶሬናን ኦኡለከ የቡሩ ገዕሙ እሀኖሰ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ኢስ አሳባተስ «ህካን ጉዕመንከ አጥራመቴንታእንዶ?» ይ ጠዕሜሰ ወክት «ኤ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ኢስን «ህከረ ሰሜ ዎምነት ምስጥር ተማረኖ ሕግ አስተማርቹ ማጮ ቀባጡተ ምኒችስ ኑባቹለከ ሃዕሮ ኦዳተ ፉሸኖ መንቹ አጉደኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ኢስ ህከ ምሳልተ ሹሎች ኤተሮን ህከንቤቺች ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ገይስ ባዱ አሜች ህከኔ ጭምትሰ ምናን ተማርሰኖሳት እቅ፤ እሰን አበ አጀብሲጭት «ኩ መንቹ ከ ሀይመተለከ ከ አጀብሲሰኖ ጠወ ሀከን አዲች ኤቦ? ");
INSERT INTO alw_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ኩን አናጤችየ ቤቱበእንዶ? አመስ ማይረመ ዬኖተበእንዶ? አመስ ኦሱንት ያቁባቲ፥ ዩሱፋቲ፥ ስሞኔትለከ ይሁዳበእንዶ? ");
INSERT INTO alw_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ህትን ሜአኖ አመስ ኦሱንት ጉዕሙንኩ ከኔ ኒን ሄኣእበእንዶ? ህካን እኮጎሬ ኩ መንቹ ከ ጠወ ጉዕመንከ ሀከን አዲች ደኤእ?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","እሰን ኢሰ ሙንደእ ቶጎበአ፤ ኢስን እሳንከ «ነብዬቹ ኬዕምሴኖስበኢሁ ባዶንከስለከ ጠለዕል ገይስ ምኔንት» ዬእ ");
INSERT INTO alw_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","አመዕነቱ ዮሰበእቤቺሃ ኢስ ህከን ቤቾን ልግብ አጀብሲሰኖ ጠወሃ አዕዮበአ። ");
INSERT INTO alw_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ህከ ወክት ገሊለ ባዱ ገሸኖ ሄሮድስ ኢስ ዱዱቡ ሞጮጬእ። ");
INSERT INTO alw_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ህካን እኮቤቺሃ ሄሮድስ ካዲመስ «ኩን ጠመቃንቾ ያህዪት፤ ከ አጀብሲሰኖ ጠወ አአኖቲሁ ሬሆች ኬዕዮቤቺሃት» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","መሰንትስ ሄሮድስ «ፍልጶሴ» ዬኖ አመስ ቤት ጫተ «ሄሮዳደ» ዬኖተ ኣኤቤቺሃ ያህይ «ሄሮዳደ ኣኡ ሀስሰኖሄበአ» ዬስቤቺሃ ሄሮድስ ያህይ ኡሱርስሾ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ህካን እኮቤቺሃ ሄሮድስ ያህይ ሾተ ሀሰኖ እቅ፤ ጠዉ እኮጎሬ ኡመቱ ያህይ ነብዬችገ አዕይ ለአኖስቤቺሃ ዋጄእ። ");
INSERT INTO alw_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ሄሮድስ እለሞ በር ከበጄኖ በሬን ሄሮዳደ ቤቱት አሜት እሱለከ እስ ኮሀ ቦሎቸ አለጵተን ሙንዲሲሶኡ። ");
INSERT INTO alw_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ህካን እኮቤቺሃ ሄሮድስ «ኢትታንት ጠወ ጉዕመንከ ኣሳንኬ» ይ ጤሌዕሌእ። ");
INSERT INTO alw_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","እሴን አመሴ ሸዛንሴ «ጠመቃንቾ ያህይ ቡዕለ ከን ሳናን አት ቴሱ ኣሴኤ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ዎሙ ህከን ጠዋን አበ ሻዦ፤ እኮጎሬ ላገተ ኣጎቤቺሃ ማዳን አፉዕልቶ ኮህ ማሌተ ይ ያህይ ቡዕለ ኣሴኖሴገ አዘዦ። ");
INSERT INTO alw_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ህካን እኮቤቺሃ መቱ መንቹ ሶክ ያህይ ቡዕለ ኡሱር ምኔን ሙርሲሾ። ");
INSERT INTO alw_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","እስ ቡዕለንከ ሳናን ዎሬን ኣሴናንሴ አማተሴ መስት ኣቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ያህይ አዎናኑት አሜት ጀናዘስ መስት ሞጎች ኤተሮን ጠወስ ኢስሃ ኩልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ኢስ ያህይ ሬሁተ ሞጮጬ ወክት ጀልባን ኣግ ኡለ ኡድመ ሜጢሀስ ኦሮዕዮ፤ ኡመቱንኩ ህካን ሞጮጭቶ ወክት ከተሚች ፉልት ሎካን አዎንቶስ። ");
INSERT INTO alw_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ኢስ ጀልብች ፉል ልግብ ኡመት ለዕዮ ወክት አሙዦሰ፤ ጥዘናመሰን ፈይሾ። ");
INSERT INTO alw_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ኡለት ሀዎርቶ ወክት አሳበት ኢስበ አሜት «ኩ ቤቹ ኡለሃ ኡድመ፤ ወክቱንኩ ሀዎርዮኡ፤ ህካን እኮቤቺሃ ኩ መኑ ግደኖን ዮ ቀእተ መርት እታኢሃ ህዕርቶተ ህርሲስሰ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ኢስን «እሰ እታኢሃ አዕኑ ኣስዬ ቤሉ እሰ ህትን እቱዕነ ኦሮኡ ሀስሰኖበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","አሳበንት «ኦንቱ ጣብተለከ ለሜ ቁርጩሜ ቤሉ መቱርቹሁ ዮኔበአ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ኢስን «ኢቤቹ ኤቤ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ህከኒች ኤተሮን መኑ ኡላን አፉዕሎተ አዘዦ፤ ኦንቱ ጣቢተለከ ለምተ ቁርጩሜተ አፍ ሰማ ለአን መገኑ ገለትጭ ጣቢተ ቢጭ አሳባተስ ኣሴእ፤ እሰን መኒሃ ኣቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ጉዕሙንኩ መኑ እተን ዱባን ፈቆ ፉርፉሩ አሳበስ ቶነ ለሙ መሶበ ዊመ ኬሶኡ። ");
INSERT INTO alw_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ህካን እቾ መን ዎሊንሹ ሜንቱሁ፥ ኦሱቲ ፈቀን ጎኑ ኦንቶ ኩሜ መን ጌሰ እሀኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ኢስ ኡመት ህርሲሰን አሳበስ ጀልባን ኣግ እሱ ሄጭት ዊች ዉድ አደ ቶልታገ አዘዦሰ። ");
INSERT INTO alw_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ኡመት ህርሲሾች ኤተሮን ዱአ አኦተ ሜጥሀስ መቶ ቆተ አል ፉሎ፤ ኡለት ሀዎርቶ ወክት ኢስ ሜጢሀስ ህከኔ ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ህከ ወክት ጀልቡ ኡላች ቄዕር ዮሀኔን ዎሎ አዲን ቦብረኖ ቦብሪን ሀንበለመን ዊ ሁሉ ከበሃ ካጰ አአን ጨነቀኖሳት እቅ። ");
INSERT INTO alw_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ሀንከዕሬ ቶኖ ሰኣት ጌሳን ኢስ ባር አሌን ሃመን አሳበስበ አሜቾ። ");
INSERT INTO alw_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","አሳበስ ባር አሌን ሃመን ለኦ ወክት አበ ህልቅ «ኩን ሀብዙላትሃ» ይት ዋጅት ያርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ኢስ ህከ ወክት አሳበስ «አደብ አዕዬ! ዋጅቶኖቼ አኔት» ይ ጠወዕዮሰ። ");
INSERT INTO alw_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ህከ ወክት ጴጥሮስ «ቀርቾ! አቴትጎሬ ዊ አሌን ሃመን ኪበ አሜቶተ አዘዜኤ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ኢስን «አም» ዬእ፤ ጴጥሮስን ጀልብ ኣዚች ፉል ዊ አሌን ሃመን ኢስበ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ጠዉ እኮጎሬ ጠረኘ ቦብረ ለዕዮ ወክት ዋጄእ፤ ዊ ኣዝ ዋል ኣአሞተ እኮ ወክት «ቀርቾ! ፌሴኤ» ይ ያሮ። ");
INSERT INTO alw_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ኢስን ወክትንከስ አንገስ ሶክ አፍ «ኩ አመዕነቱ ሆፈዕዮኤሁ! ሚሃት ሸክቶንቲሁ?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ኢስለከ ጴጥሮስ ጀልባን ኣጎ ወክት ቦብሩ ጨለ ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ህካን እኮቤቺሃ ጀልባን ሄኦ አሳበት «ሀንቅንከ አት መገንየ ቤቱ» ይት ኢሲሃ ሰገዶኡ። ");
INSERT INTO alw_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ኢስለከ አሳበስ ባረ ቶልት «ጌንሴሬጠ» ዬኖ ባዱ ኢልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ህከን ባዶን ሄዕዮ መኑ ኢሰ እሁስ ደጎ ወክት ህከን አዳን ሄዕዮ ባዱ ጉዕመንከ ሶካን ጥዘናመተ ጉዕመንከ እስበ ኤቦኡ። ");
INSERT INTO alw_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ሁኩ ጥዘናመት ጠለዕል ኦድኖስ ሰኑተ ኡልቶተ ኡጭቶስ፤ ኦድኑስ ኡልቶእሩ ጉዕሙንኩ ጥዘናችሰ ፈይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ፈርሳውትለከ ሕግ አስተማረት ዬሩሳሌሚች ኢስበ አሜት ");
INSERT INTO alw_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«ሚሃት አሳበክ ባልቅ ዎገ ድጅታኢሁ? መሰንትስ አንገተ ኣዕልቱዕናን እታኢሁ ሚሃት?» ይት ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ኢስ ፈንቀሽ «አዕኑ ሚሃት ዎጊሀክዕኔ ይቴነን መገን ትዛዝ ድጅቴነንታት? ");
INSERT INTO alw_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","መሰንትስ መገኑ ‹አነክለከ አመክ ኬዕምስ› ህትን ‹አንስለከ አመስ አሌን ቦሮር ላገተ ጠወአኖሁ ሬሆን ቀጠአሙን› ይ አዘዦኡ። ");
INSERT INTO alw_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","እኮጎሬ አዕኑ ‹መቱ መንቹ አነስለከ አመስ ኢች ደእቴነንታሃ አን መገኒሃ ኣስዮም› ዬጎሬ ");
INSERT INTO alw_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","‹ሁኩ መንቹ አነስ ኬዕምሱ ሀሲሰኖበአ› ይቴነንተ፤ ህካን እኮቤቺሃ አዕኑ ገይክዕኔ ዎጊሃ ይቴን መገን ሕገ ድጅቴነንታት። ");
INSERT INTO alw_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","አዕኑ ኩ መኑ ለኦህዕኔተ ይቴን አቴነንተሩ! ነብዬቹ እስያስ ክዕኔተኔሃ ");
INSERT INTO alw_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","« ‹ኩ መኑ አፌንከስ ኬዕምሰኖኤ፤ እኮጎሬ ቀልቡስ ኢች ቄዕርዮኡ፤ ");
INSERT INTO alw_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","እሰ መን ወገለከ ሴረ ሕግገ አት ተማርስተን ኤሳሃ ሰገዱሰ ተሰ ዮንከስ ሀንቅ ራጎኡ› » ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ኢስ ኡመት እስቤቹ ገእ «ሞጮጭዬ! አጥራመቼ! ");
INSERT INTO alw_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","መነ ንጃስሰኖሁ አፌች ፉለኑወ ቤሉ አፎንከስ ኣገኖሃበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ህከኒች ኤተሮን አሳበስ እስበ አሜት «ፈርሳውት ከ ጠወ ሞጮጭቶ ወክት ኡሙዕርቶገ ደጎንትንዶ?» ይት ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ኢስን ፈንቀሽ «ሰማን ዮ አኑኤ ካስቡ ሀቁ ጉዕሙንኩ ቡቱከመኖ። ");
INSERT INTO alw_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","እሰ ቆቃኑተለከ ቆቃኑተ አዎንስታረ እኮቤቺሃ ጌኝ አዕዬሰ፤ ቆቁ ቆቀ አዎንሴ ጎር ለሙንኩ ኤሎን ኡባአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ጴጥሮስ ኢሰ «ከን ማቆ ፍሳረተ ኩልኔ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ኢስ ፈንቀሽ «አዕኑ ቴሶ ኢለ አጥራመቴንታበእንዶ? ");
INSERT INTO alw_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","አፎን ኣጎርቹ ጉዕሙንኩ ጎደባን ኣግ ሹመተ እክ ፉለኖገ ደጌነንተበእንዶ? ");
INSERT INTO alw_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","እኮጎሬ አፌች ፉለኖሁ ቀልቤን ዮሀኒችት፤ መነ ንጃስሰኖሁ ህከኒት። ");
INSERT INTO alw_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","መሰንትስ ሂለ ሰውዩሁ፥ መነ ሹሁ፥ ዝነት፥ ሞጉሁ፥ ክዝብ መሰከሩሁ፥ መን ሱዕመ ቤሱሁ ሁኩን ጉዕሙንኩ መን ቀልቢች ፉለኖሃን። ");
INSERT INTO alw_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","መነ ንጃስሰኖሁ ህከኒት ቤሉ አንገተ አዕሎኑዕነ እቱ ሆሮ ንጃስሰኖበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ኢስ ህከንቤቺች ኬዕይ ጢሮሰለከ ሲዶነ ዬኖ ባዱ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ህከን ባዶን ሄኣ መት ከነኣናውቹት መንቹት ኢስበ አሜት «ደዉዴ ቤቶ ቀርቾ! ቤቱኤ ዶሮረኖ አያኑ አፋንሴ አበ ኦርጨቀንታኢት፤ ሀዕይ አሙዜኤ» ይት ኡጭቶስ። ");
INSERT INTO alw_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","እኮጎሬ ኢስ መት ላገታ ፈንቀሽዮበአ፤ ህካን እኮቤቺሃ አሳበስ እስበ ሆንጠክ «ት መንቹት ኔሳሃ አዎንተን ጨንጭታቤቺሃ ሀዕይ መርታገ አእሴ» ይት ኡጭቶስ። ");
INSERT INTO alw_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ኢስን «አን ሶሀሞሚሁ እስራኤል ምኒች በኦ ሆላታት ቤሉ ወሊሃ ሶሀሞምበአ» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","እኮጎሬ ህት መንቹት «ሀዕይ ቀርቾ ሀዕሌኤ» ይት ሎከስ ኡቦኡ። ");
INSERT INTO alw_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ኢስ «ኦሱት እታ እቸተ ዉሻተ ቶሩ ሀስሰኖበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","እሴን «ቀርቾ ሁኩን ሀንቅሃን፤ ጠዉ እኮጎሬ ዉሸት ምኒ መን ማዲች ፈቆ ፉርፉሩ እታአ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ህከ ወክት ኢስ «አት አቡ አመዕነቱ ዮሄተ መንቹ፤ ህካን እኮቤቺሃ አት ኢትቶንትገን እሆሄ» ዬሴ፤ ህከ ወክትንከ ቤቱሴ ፈይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ኢስ ህከንቤቺች ኬዕይ ገሊለ ባር መዲን ህግ ቆተ አል ፉል ህከኔ አፉዕሌእ። ");
INSERT INTO alw_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ልግቡ ኡመቱ ሎከተ ድናኑታ፥ ቆቃኑታ፥ ናፎ መነሃ፥ ዱዳኑታለከ ዎልት ጥዘናመታ ኣእት ኢስበ አሜት ሎከስ መዴን አፉሽቶኡ፤ እስን ፈይሾሰ። ");
INSERT INTO alw_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ህካን እኮቤቺሃ ኡመቱ ዱዳኑት ጠወአን፥ ናፋኑት ፈይተን፥ ድናኑት ጌጥ ይት ሃንተን፥ ቆቃኑት ለአን ለኦ ወክት አጀብሲጭት እስራኤል መገኑ ገለትጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ኢስ አሳበስ እስበ ገእ «ኩ ኡመቱ ኢን ሜጡበ ሰሱ በር ዱንክቶኡ፤ እታኢሁ መቱርቹሁ ዮሰበእቤቺሃ አሙዛንሰ፤ ዎቃን ሆጋቤቺሃ ጎሪንከሰ መርቶተ ገፈራንሰበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","አሳበስ «ህከረ ከን ጉዕማንከ መኒሃ እካ እቸተ ከን ኡለ ኡድማን ሀከንቤቺች ኤምባም?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ኢስ «ሄንኩ ጣቢቱ ዮህዕኔ?» ይ ጠዕሜሰ፤ እሰን «ለመሉ ጣቢቱለከ ቀዉንኩ ቀቀዋኑት ቁርጩሜት ዮኔ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ህከኒች ኤተሮን ኢስ ኡመቱ ኡላን አፉዕለኖገ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ህት አዕይ ለመለ ጣቢተለከ ቁርጩሜተ አፍ መገኑ ገለትጭ ቢጭ አሳባተስ ኣስያን አሳበስ መኒሃ ኣቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ጉዕሙንኩሰ እት ዱባን ፈቆ ፉርፉሩ አሳበስ ለመለ መሶበ ዊመ ኬሶኡ። ");
INSERT INTO alw_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","እቾ መኑ ሜንቱለከ ኦሱተ ወለአንቱዕናን ሾሌ ኩሜ ጎነ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ኢስ ኡመት ህርሲሾች ኤተሮን ጀልባን ኣግ «መጌዶነ» ዬኖ ባዱ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ፈርሳውትለከ ሰዱቃውት አሜት ኢሰ ፌተንቶተ «ህንዴ ሰሜች መላተ ለሊስኔ» ይት ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ኢስ ፈንቀሽ «ኡለት ሀዎርቶ ወክት ሰሞሁ ቢሸዕዮኡ፤ ‹ጋተ ኡለት ብረተ እካአ› ይቴነንተ። ");
INSERT INTO alw_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ህትን ገስመ ‹ሰሞሁ ጎመተ እኮኡ፤ ከበር ጠረኙ ጤኑ ኡበኖ› ይቴነንተ፤ ሰማሃ ለኤን አደ አቴን ደጌነንታት፤ ህከረ ሚሃት ዘማንስ መላተ አደ አቴን ደጌነንተበኢሁ? ");
INSERT INTO alw_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","አመዕነቱ ዮበእ ሂሉ ከን ዘማን መኑ መላተ ለኦተ ሀሰኖ፤ እኮጎሬ ዩኑስ መላ ቤሉ ዎልት መላት ኣሰንታስበአ» ዬሰ፤ ህከኒች ኤተሮን ኢስ እሰተ አጉር ዎሉቤቹ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ኢስ አሳበት ባረ ቶልቶ ወክት እቸተ አፉዕነ ሀቦ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ኢስ «ፈርሳዌለከ ሰዱቃዌ ራጭቲች ጠረኝቴን አገዕርዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","እሰን «እቸተ አንፍበቤቺሃትጎር?» ይት ገገዉንኩሰ ጠወኦኡ። ");
INSERT INTO alw_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","እኮጎሬ ኢስ ህካን ደግ «ኩ አመዕነቱ ሆፈዕዮህዕኔ መኑ! እቸተ አንፍበቤቺሃት ይቴነን ሚሃት ገገዊንከክዕኔ ጠወኤነንታት? ");
INSERT INTO alw_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ቴሶሃ ኢለ አጥራመቴንበረንዶ? ኦንቱ ጣቢተ ኦንቶ ኩሜ መኑ እቻን ፈቆ ፉርፉሩ ሄንከ መሶበ ኬሴንተጎሬ ሰውይቴነንተበእንዶ? ");
INSERT INTO alw_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ህትን ለመለ ጣቢተ ሾሌ ኩሜ መኑ እተን ፈቆ ፉርፉሩ ኬሴንታሁ ሄንካጎሬ ሰውይቴነንተበእንዶ? ");
INSERT INTO alw_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","አን ጠወዕዮሚሁ እቸተኔሃ እሁ ሆጉስ ሀት አጥረመቴነንተበአ? ፈርሳዌለከ ሰዱቃዌ ራጭቲች አገዕርዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","አሳበስ ኢስ «አገዕርዬ» ዬሳሁ ፈርሳዌለከ ሰዱቃዌ ትምርቲች ቤሉ ጣብት ራጭቲች እሁ ሆጉስ አጥረመቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ኢስ «ፍልጶስ ቂሳረ» ዬኖ ባዱ አሜቾ ወክት አሳበስ «መኑ መንች ቤቱ አዬት ይታኢት?» ይ ጠዕሜሰ። ");
INSERT INTO alw_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","እሰን «መት-መቱ ‹ጠመቃንቾ ያህዪት› ዎሉሰ ‹እልያሴት› ዎሉሰንገ ‹ኤርምያሴት ህከረንገ ነብያኖች መቶሃስ› ይታኢት» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ኢስ «አዕኑ ኤሳሃ አዬት ይቴነንተኤት?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ስሞን ጴጥሮስ «አት ሄአኖ መገኒየ ቤቱ መሲህት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ኢስን «ዮነ ቤቱ ስሞኔ! አት ማሰአንቶንትሃን፤ መሰንትስ ካን ለሊሾሄሁ ሰማን ዮ አናኤ ቤሉ መናበአ። ");
INSERT INTO alw_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","አን ኩላንኬ፤ ኪ ሱዕሙ ጴጥሮሴት፤ ጠረኛ ክኑ፤ ከን ክን አሌን ጭምት ዱእ ምኒ እጃራም፤ ህካንን ሬሆ ዎልቀት ቄልታበአ። ");
INSERT INTO alw_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","አን ኬሳሃ ሰሜ ዎምነት ቁልፋከተ ኣሳንኬ፤ ኡላን ኡሱርቶንቲሁ ሰማን ኡሱረሞሃ እሀኖ፤ ህትን ኡላን ሂርቶንቲሁ ሰማን ሂረሞሃ እሀኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ህከኒች ኤተሮን አሳበስ እስ መሲህ እሁስ አዬሃ ኩልታበእገ ጠረኝሽ አዘዦሰ። ");
INSERT INTO alw_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ህከን ወክቲች ኬሽ ኢስ አሳበስ «ዬሩሳሌመ ኦሮኣም፤ ህከኔን ባድ ባልቃች፥ ሎርሎረ ቂሳችለከ ሕግ አስተማራች ኦርሸት ኢልታኤ፤ ሽታኤ፤ እኮጎሬ ሰቅ በር ሬሆች ኬኣም» ዩ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ህካን እኮቤቺሃ ጴጥሮስ ኢሰ መድ ዋሽ «ቀርቾ! ሆሮ እሀኖበአ፤ ኩ ጠዉ ሆሮን እለኖሄበአ» የን ሻቁ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","እኮጎሬ ኢስ ጴጥሮሴ አደ ፈንቀል «ኩ ሻይጣንቹ መዲችኤ ሽቅ! አት መኒሃ ቤሉ መገን መኑ ሰውየኖ ሃሊን ሰውይታንትበእቤቺሃ ቆፉተ እኮንቴኤ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ህከኒች ኤተሮን ኢስ አሳበስ «አዪሁ ኤሳሃ አዎኖተ ሀሰኖሁ ገዉስ ለገኡን፤ ህትን መስቀለስ እጅ ኤሳሃ አዎኑን። ");
INSERT INTO alw_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","አዪሁ ፎልስ ፌሶተ ሀሾ ጎሬ ቤሰኖ፤ ህትን አዪሁ ኢተኔሃ ፎልስ ቤሰኖሁ ደአኖ። ");
INSERT INTO alw_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","መቱ መንቹ ኣዱንያ አሌን ዮኢሃ ጉዕመንከ ደእ ፎልስ ቤሾ ጎሬ መ ደግለለኖስ? ህከረንገ መቱ መንቹ ፎልስ ወጥ መ ባቶተ አታለኖ? ");
INSERT INTO alw_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","መንች ቤቱ አንስ ኬዕምኚን ገይስ መላይካን ሜጡበ አሜተኖ፤ ህከ ወክት እስን አነኒንከ ሆጎስ ወጥ ባተኖ። ");
INSERT INTO alw_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ሀንቅንከ ያንክዕኔ፤ መንች ቤቱ ጄነቴንከስ አሜተን ለኦተ ኢለ ከኔ ኡርቶሀኑኡች ሬታበእሩ ዮኡ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ሌሆ በሬች ኤተሮን ኢስ ጴጥሮሴ፥ ያቁበለከ ያቁብ አመቤቱ ጠለዕል ያህይ አዎንስ መቴ ቆተ አል ፉሎ። ");
INSERT INTO alw_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ኢስ ደኑንኩ ብሬሰ ዶረሞ፤ ሚንስን አርገ ኑር እኮኡ፤ ኦድኑስን ዋቅይት ዋጀእ ኑርገ በለቆኡ። ");
INSERT INTO alw_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ህከኔን ሙሲለከ እልያስ ኢሲን ጠወአን ለኦኡ። ");
INSERT INTO alw_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ህከ ወክት ጴጥሮስ ኢሰ «ቀርቾ! ከንቤቾን ሄኡ ኔሳሃ ጡመሃን፤ ሀሶንት ጎሬ ሰሱ ዳሰ ዳሳም፤ መቱስ ኬሳሃ፥ መቱስ ሙሲሃ መቱስ እልያሴሃ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ጴጥሮስ ህካን ጠወአንን በለቃ ጎመት ቴልቶስ፤ ህከን ጎመ ኣዜን «እሲን ተሽ የኖኤ ኢታም ቤቱኤ ከኒት፤ እሱ ሞጮጭዬ» ይታ ላገት አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","አሳበስ ህከ ላገተ ሞጮጭቶ ወክት አበ ዋጅት ኡለ ኡቦኡ። ");
INSERT INTO alw_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","እኮጎሬ ኢስ እሰበ አሜች አንጋንከስ አፍ «ኬዕዬ፤ ዋጅቶኖቼ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","እሰን ኬእ ለኣ ወክት ኢስ ቤሉ ዎሉ አዬሃ ለኦበአ። ");
INSERT INTO alw_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","እሰን ቆታች ድርተን ኢስ «መንች ቤቱ ሬሆች ኬአኖ ኢለ ከ ለኤንታሃ አዬሃ ኩልቶኖቼ» ይ አዘዦሰ። ");
INSERT INTO alw_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","አሳበስ «ህከረ ሚሃ ሕግ አስተማረት ‹ሄጭ እልያስ አሜቱ ሀስሰኖስ› ይታኢት?» ይተን ኢሰ ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ህትን ኢስ «እልያስዕኑ ሄጭ አሜች ጉዕመርቹንከ ቅጥአአኖ። ");
INSERT INTO alw_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","አን ኩላንክህዕኔ፤ እልያስ ሄጭ አሜቾኡ፤ እኮጎሬ መኑ እሱ ነብዬቹ አዕይ ቶጎስበአ፤ ህካን እኮቤቺሃ እሱሃ ሀሶገ አቶስ፤ ህትን መንች ቤቱ እሳች ኦሪሸተ ቶገኖ» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ህከ ወክት አሳበስ ኢስ ጠወዕዮሁ ጠመቃንቾ ያህይተኔሃ እሁስ አጥራመቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","እሰን ኡመት ቤቹ አሜቶ ወክት መቱ መንቹ ኢስበ አሜች ብሬስ ጉሉጵ ");
INSERT INTO alw_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«ቀርቾ! ጮት ዱሩ አፍ ልግብ ወክት ጊራንለከ ዋን ኡጀንስ አበ ኦርሰኖስቤቺሃ ቤቱኤ መረርስጭስ። ");
INSERT INTO alw_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","አሳበክቤቹ ኤቦም ወክት ፈይሶተ አታልቶበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ኢስን «አዕኑ ኩ አመዕንቴንቡለከ ሾኩ ከን ዘማን መኑ! ሀከ በር ኢለ ክዕኔን ሄኣም? ሀከ በር ኢለ ክዕኔተ አታላም? ህንዴ ጩልስ ከበ ኤቤ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ኢስን ዱር ሻቃን ህከን ጩሊች ፉሎ፤ ጩሉንኩ ህከ ወክት ፈዬእ። ");
INSERT INTO alw_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ህከኒች ኤተሮን አሳበት ኢስበ አደደ እክ አሜት «ነኡ ካን ፉሽኖተ አታልንባሁ ሚሃት?» ይት ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ኢስ «አመዕነቱ ሆፈዕዮህዕኔቤቺሃት፤ ሀንቅንከ ያንክዕኔ፤ ዎንጌ እሌ ጌሱ አመዕነቱ ሄዕዮህዕኔ እቃን ከ ቆተተ ‹ከንቤቺች ኬእ ካጰ ኦሮእ› ይቴንተጎሬ ኦሮታአ፤ ዎልቅሰኖህዕኔርቹ መቱርቹሁ ሄአኖበአ። ");
INSERT INTO alw_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","እኮጎሬ ህትኔ ዱሩ ዱኢንለከ ሶመኒን እህባች ሆሮ ፉለኖበአ» ");
INSERT INTO alw_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","አሳባስ ገሊላን ሄኦሀኔን ኢስ «መንች ቤቱ መን አንጋን ህግሴን ኣሴኖ፤ ");
INSERT INTO alw_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","እሰን ሽታስ፤ እኮጎሬ እስ ሰቅ በር ሬሆች ኬአኖ» ዬሰ፤ ህካን እኮቤቺሃ እሰ አበ ሻዞኡ። ");
INSERT INTO alw_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ኢስለከ አሳበስ ቅፍርናሆም ከተመ ኢልቶ ወክት ዱእ ምኒ ግብረ ጭምአታ መኑ ጴጥሮሴቤቹ አሜት «አስተማርቹክዕኔ መገን ምኒ ግብረ ባተኖበእንዶ?» ይት ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ጴጥሮስ «ኤ ባተኖ» ይ ምኒ ኣጎ ወክት ኢስ ሄጭ «ስሞኔ! ኬሳሃ መ አጉደኖሄት? ከን ኣዱንያ አል መንግስታከት ቀረጠለከ ግብር ቶጋኢሁ እላችሳትንዶ ዎሎ መኒቺት?» ይ ጠዕሜእ። ");
INSERT INTO alw_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ጴጥሮስን «ዎሎ መኒቺት» ዬእ፤ ኢስ «ህከረ ኦሱሰ ግብር ባትበረንዶ? ");
INSERT INTO alw_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","እኮጎሬ እሰ ቆዕልታበእገ ባር አሌን ዎሻደ ኡጅት ሄጭት ፉልቶ ቁርጩሜተ አፍ አፎሴ ፈንቶንት ወክት ባታንት ጌሰ ብረ ደጋንት፤ ህካን መስት ኢለ ኪ ወጥ ባት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ህከ ወክት አሳበት ኢስበ አሜት «ሰሜ ዎምነቴን ጉዕሚችን በተአኖሁ አዬት?» ይት ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ህካን እኮቤቺሃ ኢስ መቱ ጩል ገእ በላንከሰ ኡርሽ ");
INSERT INTO alw_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","«አን ሀንቅንከ ያንክዕኔ፤ ሰዊቱክዕኔ ጡመ እህባችለከ ኦሶገ እኬንባች ሰሜ ዎምነቱ ሆሮ ኣጌነንተበአ። ");
INSERT INTO alw_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ሰሜ ዎምነቴን ሎሩ ከን ጩልገ ገዉስ ሆፍሰኖሃን። ");
INSERT INTO alw_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ከን ጩልገ ዮኢሃ ኢ ሱዕሚን ቶገኖሁ አዪሁ ኤሳሃ ቶገኖ። ");
INSERT INTO alw_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«ኢን አመዕንቶ ከን ማዕናኖች መቱስ ሉሲሰኖ መንቹ ሎረ ሪትም ክኑ ጎበስ ኡሱሬን ጥዕላሸ ባራን ቶረም ኣአሞእቀ ቆሀኖስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ኢስ «ሉሲሰኖርቹ አሜተኖቤቺሃ ከን ኣዱንያ አል መኒሃ ኣዬ! መሰንትስ ሉሲሰኖርቹ አሜቱዕነ ሆሮ ፈቀኖበአ፤ ሉሲሰኖርቹ እስ መሳን አሜተኖ መንቺሃ ኣዬ! ");
INSERT INTO alw_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ህካን እኮቤቺሃ አንገክ ህከረንገ ሎከክ ሉሲሳሄትጎሬ ሙርት ኡጅ፤ መሰንትስ ለምተ አንገት ህከረንገ ለምተ ሎከት ሄኣንኬ ዘላለሚሃ ሆሮ ጠእትበ ጊራን ኣጋንትሀኒች ድኑለከ አንገተ ሙረሞሃ እክ ሄእቤቹ ኣጉ ቆሀኖሄ። ");
INSERT INTO alw_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ህትን እልክ ሉሲሳሄትጎሬ ፉሽት ቶር፤ መሰንትስ ለሜ እሌን ሄእ አዛብ ጊራን ኣጋንትሀኒች መትእልቹ እክ ሄእቤቹ ኣጉ ቆሀኖሄ። ");
INSERT INTO alw_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ከን ማዕናኖች መቱስ ህንቄነንተበእገ አገዕርዬ፤ አን ኩላንክዕኔ፤ ሰማን ዮ እሰ መላይከት ጉዕመ ወክት ሰማን ዮ አንኤ ብሬን ለልታአ።  ");
INSERT INTO alw_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","መሰንትስ መንች ቤቱንኩ አሜቾሁ በዕዮሃ ጡምሲሃት» ");
INSERT INTO alw_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ኢስ «ህንዴ መ አጉደኖህዕኔ፤ መቶ መንቺሃ ጥቤ ሆለት ዮስሀኒች መትሴ በኦስጎሬ ሆንሳይኔ ሆንሱንከ ቆተ አሌን አጉር በዕዮሲሃ ሀሶተ ኦሮአኖበእንዶ? ");
INSERT INTO alw_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ሀንቅንከ ያንክዕኔ፤ ሀሽ ደጎ ወክት በኡዕነ ፈቆ ሆንሳይኔ ሆንሶ ሆላች በትሽ በዕያን ደጎ ሆልቺሃ ሙንደአኖ። ");
INSERT INTO alw_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ህትን ሰማን ዮ አኑክዕኔ ከን ማዕናኖች መቱስ በኦተ ኢተኖበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ኢስ «አመክቤቱ ቤሾሄ ጎሬ መርት ቤሱስ ገዪንከስን ኩል፤ እስን ቤሱስ አመዕኔሄጎሬ አመክቤቱ አቶንትስ ዩሃን። ");
INSERT INTO alw_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ሞጮጩ ግቦሄጎሬ ጠዉ ጉዕሙንኩ ለሞ ህከረንገ ሰሶ ምስክር ላጋን ዊመኖቤቺሃ መቱ ህከረንገ ለሙ መንቹ አፍ እስቤቹ መር። ");
INSERT INTO alw_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","እሰ ይታኢሃ ሞጮጩ ግበኖረ ዱእ ምኒ መኒሃ ኩል፤ ዱእ ምኒ መኒሃ ሞጮጩ ግበኖረ መገኑ አመዕንበ መንችገለከ ሰጭ ፈንቀልበ ጩበኝገ ዎለእ። ");
INSERT INTO alw_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«ሀንቅንከ ያንክዕኔ፤ ኡለ ኡሱርቴንታሁ ሰማን ኡሱረሞሃ እሀኖ፤ ኡላን ሂርቴንታሁ ሰማኒ ሂረሞሃ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ህትን አን በርግ ኩላንክዕኔ፤ ክዕኔ በሊች ለሙ መንቹ መ ጠወሃ ኢተቀንት ዱአ አቶጎሬ ሰማን ዮ አኑኤ ህከ ጠወ አአኖሰ። ");
INSERT INTO alw_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","መሰንትስ ለሙ ህከረንገ ሰሱ መንቹ ሱዕሚንከኤ ጭምይቶቤቾን አን በላንከሰ እሃምቤቺሃት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ህከኒች ኤተሮን ጴጥሮስ ኢስቤቹ ሆንጠክ «ቀርቾ! አመኤቤቱ በደሎኤጎሬ ሜኡ ወክት አጉሩስ? ለመለ ወክት አጉሩስንዶ?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ኢስን «ለመላዩ ወክት ለመላ ቤሉ ጠለዕል ለመለ ወክት ያንኬበአ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ህካን እኮቤቺሃ «ኢስ ሰሜ ዎምነቱ ካዲማንከስ ሜጡበ ሆጎተስ ሀስሰኖ ህሳበ አማዕለመኖ ዎመ አጉዳአ። ");
INSERT INTO alw_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","እስን ስሌት አኡ ጀመርቶ ወክት ቶኖ ኩሜ መክሊት ኤዶሁ ዮስ መቱ ካዲንቹ አፍ እስበ ኤቦኡ። ");
INSERT INTO alw_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ሁኩ ካዲንቹ ኤዳስ ባቱ ሆጎቤቺሃ ገዉሲ፥ መንቹስለከ እለስ ዮስርቹ ጉዕመንከ ህሬን ኤዳስ ባተመኖገ ቀርቹስ አዘዦ። ");
INSERT INTO alw_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ህካን እኮቤቺሃ ካዲንቹስ ቀርችስ ሎካን ኡብ ‹ኢ ቀርቾ! ሀዕይ ቀዉ ጌሰ አገሬኤ፤ ጉዕመንከስ ባታም› ይ ኡጬስ። ");
INSERT INTO alw_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ቀርቹንኩስ አሙዦስቤቺሃ ገፈሮስ፤ ኤዳስ ጉዕመንከ አጉሮስ። ");
INSERT INTO alw_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«ጠዉ እኮጎሬ ሁኩ ካዲንቹ ህከንቤቺች ፉል ኦሮአን ጥቤ ዲናረ ሌቄሾ ሆጎስ ጃለ ደግ ‹ሌቄሾንኬሃ ባቴኤ› ይ ቆኤስ ለንግ አፎ። ");
INSERT INTO alw_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ጃሉንኩስ ሎከስ አሌን ኡብ ‹ሀዕይ ቀዉ ጌሰ አገሬኤ፤ ባታንኬ› ይ ኡጬስ። ");
INSERT INTO alw_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","እኮጎሬ መንቹስ ግብ ኤዳስ ባቶተ ኢለ ኡሱርሲሾስ። ");
INSERT INTO alw_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ሆጎስ ጃለት ህካን ለኦ ወክት አበ ሻዝ እኮ ጠወ ጉዕመንከ ቀርቺሃንሰ መርት ኩልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ቀርቹንኩ ህከ ካዲንቹ ገእሲሽ ‹ኩ ሂሉ ካዲንቹ፤ ኡጭቶንቴኤረ ህከ ኤዳክ ጉዕመንከ አጉርበሄንዶ? ");
INSERT INTO alw_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","አን አሙዦኬገን አቲሁ ጃልሀክ አሙዛንትስበእንዶ?› ይ ");
INSERT INTO alw_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ቀርቹስ ኡሙዕር ኤዳስ ጉዕመንከ ባች ሹሎተ ኢለ ኡሱር ምኒ ሀለቅቺሃ ህግሽ ኣሴእ። ");
INSERT INTO alw_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«ህትን አዕኑሁ አመክዕኔቤት ብድል ቀልቢን ሹልቴን አጉርቴንበጎሬ ሰማን ዮ አኑኤ ህትን አአኖህዕኔ ዬሰ።» ");
INSERT INTO alw_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ኢስ ህከ ጠወ ጠወዕይ ሹሎች ኤተሮን ገሊላች ኬዕይ ዮርዳኖስ ዛዘኖ ዊ ዉድ አዲን ሄዕዮ ይሁድ ባዱ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ልግቡ ኡመቱ አዎኞስ፤ እስን ህከኔ ፈይሾሰ። ");
INSERT INTO alw_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ህከ ወክት ፈርሳውት ኢስበ አሜት ሉሲሶተ «መቱ መንቹ ጫስ እኮስ መሳን ሸሩ ፈቀደመኖስንዶ?» ይት ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","እስን ፈንቀሽ «ካልቁሰ ዎዕናንከ ‹ሜኣተለከ ለባሃ አዕይ ከለቆሰ› የመሞሃ አነበቤንታበእንዶ? ");
INSERT INTO alw_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ህትን ‹መንቹ አነስለከ አመስ አጉር ጫንከስ ሜጡ እሀኖ፤ ለሙንኩ መቱ ጅስመ› እካአ። ");
INSERT INTO alw_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ህካን እኮቤቺሃ እሰ ከኒች ኤተሮን መቶሃ ጅስመ ቤሉ ለሞሃበአ፤ መገኑ ሜጡ አዕይ በርጌኢሃ መኑ አደ አኡንከ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","እሰን «ህከረ ሙስ ሚሃት ምኒ አኑ መንቾተስ ንከሴ ሂር ገፈሮተ አዘዦ?» ይት ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ኢስ «ሙስዕኑ ሜንቱክዕኔ ገፈርቶኖተ ፈቀጆሁ ቀልቡክዕኔ ዱጆቤቺሃት፤ እኮጎሬ ዎዕናሃ ህትጎተበአ። ");
INSERT INTO alw_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","«አን ያንክዕኔ፤ ዝነተ አቱዕነ ጫስ ገፈር ዎልተ ጫተ ኣአኖሁ ጉዕሙንኩ ዝነተ አአኖሃን» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","አሳበስ «ለቤለከ ሜኣ ደኑ ካን እኮች ኣኡ ሆጉ ቆሀኖ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ጠዉ እኮጎሬ ኢስ «ኣሰሞሰሀኑኡ ቤሉ ኩ ጠዉ ጉዕመ መኒሃ አታልሲስበሃን። ");
INSERT INTO alw_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","መሰንትስ እለንተንን ለቤነቱ ዮሰበእሩ ዮኡ፤ ህትን መኑ ቃሮሰሩ ዮኡ፤ ህትን ሰሜ ዎምነቲሃ ይት ምኒሃ እሁ ግቦእሩ ዮኡ፤ ህካን ቶጎተ አታለኖሁ ዮ ጎሬ ቶጉን» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ህከ ወክት አንገስ አሌሰ አዕይ ዱአ አኦተ መኑ ኦሱተ ኢስቤቹ ኤቦኡ፤ አሳበስ ኤቦ መነ ኡሙዕርቶሰ። ");
INSERT INTO alw_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","እኮጎሬ ኢስ «ሰሜ ዎምነቱ ከኑኡገ ዮሀኑኡተ እኮቤቺሃ አጉሬሰ፤ ኦሱት ኢቤቹ አሜቶተ ከንቶኖቼሰ» ይ ");
INSERT INTO alw_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","አንገስ አሌሰ አዕዮች ኤተሮን ዎሉ አደ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","መቱ በር መቱ መንቹ ኢስበ አሜች «አስተማርቾ! ዘላለሚሃ ሄአኖ ሄኡ ደኦተ መ ጡመ ጠወሃ አኡ?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ኢስን «ጡመ ጠውተኔሃ ሚሃ ጠዕምታንቴኤት? ጡሙ ሜጥቾሃ መገኑ፤ ሄእቤቹ ኣጎተ ሀሶንት ጎሬ ትዛዝ አገር» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","መንቹንኩ «ሀከ ትዛዝዪት?» ዬእ። ኢስን «ሽቶት፥ ዝነተ አቶት፥ ሞግቶት፥ ጩብ መሰከርቶት፤ ");
INSERT INTO alw_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","አነክለከ አመክ ኬዕምስ፤ ዎሉ መነ ገይክገ አት ኢት» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","እስን ኢሰ «ከ ትዛዝ ጉዕመንከ አዕዮም፤ ዎሉ ፈቆኤሁ መርቹሃን?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ኢስን «ዊመ እኮተ ሀሶንት ጎሬ መርት ዮሄ ዱንያተ ጉዕመንከ ህርት ቡጥቺሃ ኣስ፤ ሰማን ዱንያት ሄኣሄ፤ ህከኒች ኤተሮን አሜት አዎኔኤ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ሁኩ ዎደልቹ ህካን ሞጮጬ ወክት አቡ ዱንያት ዮስቤቺሃ ሻዘን ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ህከኒች ኤተሮን ኢስ አሳበስ «ሀንቅንከ ያንክዕኔ፤ ቀባጣሞ መንቺሃ ሰሜ ዎምነቱ ኣጉ አበ ኦርሰኖሃን። ");
INSERT INTO alw_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ለንኪሃ ያንክዕኔ፤ ቀባጣሙ መንቹ መገን ዎምነቱ ኣገኖሀኒች ጋሜሉ መርፌ ጠላዕላን ሕጉ ቆሀኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","አሳበስ ህካን ሞጮጭቶ ወክት አበ አጀብሲጭት «ህከረ አይ ጡሞተ አታለኖ?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ጠዉ እኮጎሬ ኢስ እሰተ ለአን «ኩ ጠዉ መኒሃ አታለምበሃን፤ እኮጎሬ መገኒሃ ጉዕሙርቹንኩ አታለመኖስ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ህከ ወክት ጴጥሮስ ፈንቀሽ «ሁኩዕኑን ነኡ ጉዕመርቹንከ አጉርን አዎኖንኬ፤ ህከረ ደእናሚሁ መርቹሃን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ኢስን «ሀንቅንከ ያንክዕኔ፤ አዕኑ ኤሳሃ አዎንቴንተሩ መንች ቤቱ ጉዕሙርቹንኩ ሃዕሮ እሀኖ ዘማኔን ኬዕምኝ ቦርጭማን አፉዕለኖ ወክት አዕኑ ቶነ ለሞ ቦርጭማን አፉዕልቴን ቶነ ለሞሃንከ እስራኤል ደቦ አሌን ፈረዴነንተ። ");
INSERT INTO alw_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ህትን ኢ ሱዕምተኔሃ ምነተ ህከረንገ አመስ ኦሱተ ህከረንገ አነ ህከረንገ አመተ ህከረንገ እለስ ህከረንገ ኡለስ አጉሮሁ ጉዕሙንኩ ጥቤ አፎሃ ኣአኖ፤ ህትን ዘላለሚሃ ሄአኖ ሄኡ ደአኖ። ");
INSERT INTO alw_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ጠዉ እኮጎሬ ልግቡ ብርት ሄኦእሩ ኤተራኑተ ኤተራኑንት ብርተ ሄኦእረ እካአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ኢስ «ሰሜ ዎምነቱ ዎይነስ አስሲሶተ ሆጉተ አታ መነ ቀጠሮተ ገስመ ሱጵተ ፉሎ ኡለ አነ አጉዳኖ። ");
INSERT INTO alw_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ኢስን መት-መትሀሰ በሬን መት-መቱ ዲናረ ባቶተ ኢተቀም ሆጉተ አታ መነ ዎይነ መክሴኖ ላልች ኣዝ ሶኮ። ");
INSERT INTO alw_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ኡለስ አኑንኩ ሰሶ ሰኣት ጌሳን ፉል ሆጉተ ሆግ በነቻን ኡርቶ ዎሉ መነ ለዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","እሳንከ ‹አዕኑ ዎይን ላልች ኣዝ መርቴን ሆጉተ አዕዬ፤ ሀስሰኖ ጌሰ ባታንክዕኔ› ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","እሰን ዎይን ላልች ቤቹ መርቶኡ፤ ህትን ሌሆ ሰኣትለከ ሆንሶ ሰኣት ጌሳን ፉል ህትን አዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ህትን ቶነ መቶ ሰኣት ጌሳን ፉል ዎሉ ኡርቶ መነሃ ደግ ‹ከኔ ዊመ በር ሆጉት ዮበኢሃ ኡርቴን ሚሃ ሆሴንታአ?› ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","እሰን ‹ቀጠረኖ መንቹ ሆንጊት› ይቶስ፤ እስን ‹አዕኑ ዎይን ላልች ኣዝ መርቴን ሆጉተ አዕዬ› ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«ኡለት ሀዎርቶ ወክት ዎይን ላልች አኑ ሆጎስ ሀላፌቹ ‹ሆጉተ አታእረ ገእት መጨረሻን ቀጠረንቶሀኑኡች ኬስ ዎዕናሃ ቀጠረንቶእረ ኢለ ሆጉተ አቶ ዲናረ ባት› ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ህከ ወክት ቶነ መቶ ሳኣቴን ቀጠረንቶእሩ ሆንጠክ መት-መቱሰ መት-መቱ ዲናረ ኣእቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ህትን ዎዕና ቀጠረንቶእሩ ሆንጠኮ ወክት በትስ ኣእታኢሃ አጉጆሰ እቅ፤ ጠዉ እኮጎሬ እሳ መት-መቱ ዲናረ ኣእቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","እሰ ዲናረ ኣእተን ‹ኩ ኒች ኤተሮን ቀጠረንቶእሩ ሆጉተ አቶኢሁ መቶሃ ሰኣት፤ ዊመ በረ አሮን ቡንብ አዕነን ሆንሶም ኒን ቅጡ ባቶንት› ይት ኡለስ አኒን ቁንቁንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ኡለስ አኑንኩ ህከን ሆጉተ አታ መኒች መቱስ ‹ኢ ጃለ አን መቱርቹሃ ቤሾምበአ፤ አት ኢን መቶ በሬተ መቱ ዲናረ ባቶሄተ ኢተቀሞምበእንዶ? ");
INSERT INTO alw_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ህካን እኮቤቺሃ ወጥክ ኣኢት ኦሮእ፤ አን ኬሳሃ ኣሴምሀንገን መጨረሻን አሜቾ መኒቺሃ ኣሶተ ኢትዮም። ");
INSERT INTO alw_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ገይኤሃ ኢቴምገ አኦተ አታላምበእንዶ? ህከረንገ አን ጡመ እኮምቤቺሃ ምቀኝቶንትንዶ?› » ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ህካን እኮቤቺሃ ኢስ «ኤተሩ ሄኦእሩ ብርተ እካአ ህትን ብርተ ሄኦእሩ ኤተሩ እካአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ህከኒች ኤተሮን ኢስ ዬሩሳሌም ከተመ አሌ ዋል ኦሮአን ቶነ ለሙንኩ አሳበተ አደ አዕይ እስበ መስ ");
INSERT INTO alw_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«ሁኩዕኑን ነኡ ዬሩሳሌመ መርናሚት፤ ህከኔን መንች ቤቱ ቂስ አዎናኖተለከ ሕግ አስተማራታ ህግሴን ኣሴናን እሰን አሌስ ሬሆ ፍርደ ፈረዳአ። ");
INSERT INTO alw_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ህትን እሰ ቀለደንስለከ አበ ገረፈንስ ሰቀልቶተ አይሁደ እኮበእ መኒሃ ኣታስ፤ ህትን ሰቅ በር ሬሆች ኬአኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ዜብዶሴ ኦሶ አመት ኦሱሴ ኣእት ኢስበ አሜት ብሬስ ጉሉጵት መቱ ጠወ አኦተ ኡጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ኢስን «መ ሀሶንት?» ዬሴ፤ እሴን «ዎምነቴንከክ ለሜ እላችኤ መቱሰ መኬ አዲን መቱሰ ጉረ አዲን አፉዕልታገ አእ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ጠዉ እኮጎሬ ኢስ «ኡጭቴነንታሃ ደጌነንተበአ፤ አን ግደኖ በሬን አጋም ኦርሸ ጠበቴሃ አጎኖተ አታልቴነንንዶ?» ዬእ፤ እሰን «ኤ አታልናም» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ኢስን «ኦርሻኤ ጠበትተ አጎኖተ አታልቴነንተ፤ ጠዉ እኮጎሬ ጉረኤ አዲንለከ መኬኤ አዲን አኣሚሁ አኔበአ፤ ሁኩ ቤቹ ኣሰመኖሁ አኑኤ ቅጥአዕዮ መኒሃት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ፈቆ ቶኑንኩ አሳበት ህከ ጠወ ሞጮጭቶ ወክት ለሞንከ አመኦሶ አሌን ኡሙዕርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","እኮጎሬ ኢስ ጉዕመንከሰ እስበ ገእ «ኣዱንያ አል መን ሀለቀት መነሰ ገሽታእራን፤ አዎንሳኑሰን እሰ አሌን ሹምነቱ ዮሰገ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ክዕኔ በላን ህት እሁንከ፤ ጠዉ እኮጎሬ አዪሁ ክዕኔ በሊች ሎረ እሆተ ኢተኖሁ ሄዕዮ ጎሬ ክዕኔ ካድንቹ እሁን። ");
INSERT INTO alw_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ህትን አዪሁ ክዕኔ በሊች ጉዕሚችን ሎረ እሆተ ኢተኖሁ ሄዕዮ ጎሬ ክዕኔ ካድንቹ እሁን። ");
INSERT INTO alw_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ህትን መንች ቤቱ ፎልስ ልግብ መኒሃ ዎዝኑተ አዕይ ኣሶተ አሜቾ ቤሉ ካደሞኖስተ አሜቾበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ህከኒች ኤተሮን ኢስለከ አሳበስ ኢያርኮ ከተሚች ፉልት መርተን ልግቡ ኡመቱ አዎኞሰ። ");
INSERT INTO alw_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ዎቄ ገበላን አፉዕልቶ ለሙ ቆቁ መኑ ኢስ ህከን አዲን ህገን ሞጮጭቶ ወክት ላገሰ ጎት አት «ቀርቾ ዳዉዴ ቤቶ! መረርሲጭኔ» ይተን ያርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ሁኩ ኡመቱ «ጨለ ይዬ» ይት ሻቆሰ፤ ጠዉ እኮጎሬ እሰን ዎዕኔች በትስ «ቀርቾ ዳዉዴ ቤቶ! ሀዕይ አሙዝኔ» ይት አበ ያርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ኢስን ኡር እስበ ገእ «መ አኦህዕኔተ ሀሴነን?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","እሰን «ቀርቾ! እልኔ ፈንተኣገ አእኔ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ኢስን አሙዥ እልሰ አንጋን አፎ ወክት አጀብሲሰኖ ሃሊን እልሰ ፈንተኣን አዎንቶስ። ");
INSERT INTO alw_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ኢስለከ አሳበስ ዬሩሳሌም ከተመ ሆንጠኮ ወክት ዘይት ሀቁ ነጰኖ ቆተ አሌን ዮ «ቤተ ፋጌ» ዬኖ ቀእተ ኢልቶኡ፤ ህከ ወክት ኢስ አሳባችስ ለሙ ");
INSERT INTO alw_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«ብሬክዕኔ ዮ ቀእተ መሬ፤ ህከኔን መት ሀሩቹተ ዎተሪንከሴን ኡሱሬማሃ ደጌነንተ፤ እሰንተ ሂርቴን ኤቤ። ");
INSERT INTO alw_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","አዪሁ መቱርቹ ዬህዕኔጎሬ ‹ቀርቹ ሀሾቤቺሃት› ይዬ፤ እስን ወክትንከስ ሶሀኖ» ይ ሶኮ። ");
INSERT INTO alw_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ሁኩን እኮሁ ነብዬቾን ");
INSERT INTO alw_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«ጽዮን ቤቶ ‹ሁኩዕኑን! ዎሙክ ገዉስ ሆፍሽ ሀሩቾንለከ ሀሩቾ ዎተራን ቆጵ ኪቤቹ አሜተኖ!› ይቴን ኩሌሰ» የመም ጠወአሞሁ ዊሞታት። ");
INSERT INTO alw_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","አሳበንት መርት ኢስ ዬሰገን አቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","እሰን ሀሩቹተ ዎተሪንከሴን ኤብ ኦድኑሰ ሀሩቾ ጉጆን አታን ኢስ ቆጶ። ");
INSERT INTO alw_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ህከን መኒች ልግቡሰ ኦድኑሰ ዎቃን ዌሶኡ፤ ዎሉሰንገ ሀቅ ሀበረ ተንቅሰን ዎቃን ዌሳኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ልግቡ መኑ ብሬ አዲንለከ ኤተር አዲን ላገሰ ጎት አት «ሆሳና! ጡምሳንቺሃኔ ደዉዴ ቤቲሃ፤ ቀርች ሱዕሚን አሜተኖሁ ማሰአሞእሃን፤ ሆሳና! አሌ ሰማን» ይታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ኢስ ዬሩሳሌም ከተመ ኣጎ ወክት «ኩን አዬት?» ይተን ከተም መኑ ጉዕሙንኩ ረበሾኡ። ");
INSERT INTO alw_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ሁኩ ኡመቱ «ኩን ገሊለ ባዶን ዮ ናዝሬት ከተሚች አሜቾሃ ነብዬቾ ኢሳት» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ኢስ ዱእ ምኒ ኣግ ዱእ ምኒ ኣዜን ህርታእረለከ ህዕርታእራ ሸር ፉሼእ፤ ብረ ዶርታ ጠረጴዘተለከ ሀንደዕርተ ህርታ መን ቦርጭመተ ኮሎንኮዕልሾ። ");
INSERT INTO alw_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","እስን « ‹ምኑኤ ዱአ አኤኖ ምኒ ዬን ገኤኖ› የመም ከተበሞኡ፤ እኮጎሬ አዕኑ ሽፍጡ አፉዕለኖ ሻንቀ አቴንተ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ኢስ መገን ምኔን ዮሀኔን ቆቃኑትለከ ድናኑት እስበ አሜታን ፈይሾሰ። ");
INSERT INTO alw_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ጠዉ እኮጎሬ ቂስ አዎንሳኑትለከ ሕግ አስተማረት ኢስ አዕዮ አጀብሲሰኖ ጠወ መገን ምኔን «ሆሳና! ደዉዴ ቤቲሃ» ይተን ጨንጭቶቤቺሃ ኡሙዕርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","እሰን «ኩ ኦሱት ይታኢሃ ሞጮጭታንቲትንዶ?» ይቶስ፤ ኢስን «ኤ! ‹ኦሶችለከ ቀንታሀኑኡ አፌች ገለት ቅጥ አቶንት› ይታ ላገተ ሆሮ አነበቤንታበእንዶ?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ኢስን እሳች አደ እክ ዬሩሳሌም ከተሚች ፉል «ቢታነ» ዬኖ ቀእተ ኦሮዕይ ህከኔ ገሎ። ");
INSERT INTO alw_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ኢስ ለንክ በር ገስመ ሱጵተ ዬሩሳሌም ከተመ ፈንቀል ኦሮአን ጎሩ አፎስ። ");
INSERT INTO alw_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","እስን ዎቄ ገበላን ዮ መት ኦድ ሀቁቹተ ለዕይ እሴቤቹ ኦሮዕዮ፤ እኮጎሬ ሀበር ቤሉ መቱ ላልቹሃ ደጎሴበአ፤ ህከ ኦድ ሀቁቹተ «ለንኪሃ ኬሳሃ ሆሮ ላልቹ ሄኡንከሄ» ዬሴ፤ ኦድ ሀቁቹንት ህከ ወክት ሞልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","አሳበስ ህካን ለኦ ወክት አጀብሲጭት «ሀት ት ኦድ ሀቁቹት ሜጦረን ሞልቶኡ?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ኢስን ፈንቀሽ «ሀንቅንከ ያንክዕኔ፤ አመዕነቱ ሄዕዮህዕኔጎሬ፥ ሸክቴንበረ ከን ኦድ ሀቁቾን እኮ ጠወ ጠለዕል አቴነንተበአ፤ ጠዉ እኮጎሬ ተ ቆተተ ‹ከንቤቺች ቡቱከንት ባራን ኡብ› ይቴንተጎሬ እሀኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","አመዕነቱ ሄዕዮህዕኔጎሬ ኡጭቴነንተርቹ ጉዕመንከ ደእቴነንተ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ኢስ ዱእ ምኒ ኣግ ተማርሰን ቂስ አዎንሳኑትለከ ባድ ባልቀት እስበ አሜት «ከ ጠወ ጉዕመንከ አታንቲሁ መ ዎልቃኔት? ህትን ከ ዎልቃተ ኣሴሄሁ አዬት?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ኢስን ፈንቀሽ «መቱርቹ ጠዕማንክዕኔ፤ አዕኑ ህካን ፈንቀሽቴንተጎሬ አኒሁ ካን መ ዎልቃን አኣሚት ጎሬ ኩላንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ያህይ ጥምቀቱ ሀከን አዲች አሜቾ? መገን አዲችትንዶ መን አዲችት?» ዬሰ፤ ገገዉንኩሰን « ‹መገኒችት› ይኖምጎሬ ‹ህከረ ሚሃ ያህዪን አመዕንቴንታበአ?› የኖኔ። ");
INSERT INTO alw_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ጠዉ እኮጎሬ ‹መኒችት› ይኖምጎሬ መኑ ጉዕሙንኩ ያህይ ‹ነብዬቹወ› ይ አመዕኔቤቺሃ መነ ዋጅኖም» የቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ህካን እኮቤቺሃ እሰን ኢሲሃ «ደንጋምበአ» ይት ፈንቀሽቶኡ፤ ኢስን «አኒሁ ካን ጉዕመንከ መ ዎልቃን አኣምትጎሬ ኩላንክዕኔበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ኢስ «መ አጉደኖህዕኔት? መቶ መንቺሃ ለምተ ኦሱት ሄኦስ እቅ፤ እስን መትስቤቹ ሆንጠክ ‹ከበር ዎይን ኣዝ መርት ሆጉተ አእ› ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ቤቱንኩስ ‹መራምበአ› ይ ፈንቀሼእ፤ እኮጎሬ ኤተሮን ሸጭ ሆጉተ አኦተ መሮ። ");
INSERT INTO alw_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ህትን ለምቅስ ቤት ቤቹ መር ዎዕኔሀንገን ዬስረ ‹ኤኩ ኢ አነ መራም› ዬእ፤ ጠዉ እኮጎሬ መሩዕነ ፈቆ። ");
INSERT INTO alw_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ህከን ለሜ ኦሶች አኒሀስ አዘዘሞሁ ሀከኒት?» ዬእ፤ እሰን «ዎኔስየ» ይቶኡ፤ ኢስን «ሀንቅንከ ያንክዕኔ፤ ቀረጠ ሙርታእሩለከ ዝነተ አታእሩ ክዕኔተ ሄጭት መገን ዎምነቱ ኣጋአ። ");
INSERT INTO alw_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","መሰንትስ ያህይ መገኒን ሄኤኖ ዎቃሃ ለሊሶህዕኔተ አሜቾ ጎሬ አመዕንቴንታስበአ፤ ጠዉ እኮጎሬ ቀረጠ ሙርታሩለከ ዝነተ አታእሩ አመዕንቶስ፤ አዕኑ ኤተሮን ህካን ለኤኒ ቶበቴን አመዕንቴንታስበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ኢስ «ዎልት ምሳልተ ሞጮጭዬ፤ ኡላንከስ ዎይን ላልቹ ዮስ መቱ መንቹ ሄዕዮ እቅ፤ እስን ዎይነስ ኦች ላልቹስ ጩንሼኖ ኡለተ እም አገርታ መኒሃ ሀንሸሩ እጃር ቀባኖተ ኣስ ዎሉ ባዱ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ዎይኑስ ላለኖ ወክቱ እካን ላልቺችስ ኤቦተ ካዲመስ ቀባኖቤቹ ሶኮ። ");
INSERT INTO alw_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ሁኩ ቀባኑት ካዲማች መቱስ ኦልቶኡ፤ መቱንገ ሽቶኡ፤ ዎሉስንገ ክኒን ቀሶኡ። ");
INSERT INTO alw_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ለንኪሃ ኡለስ አኑ ዎኔሀኑኡች በተኣ ካዲመተ ሶኮረ ሁኩ ቀባኑት ዎኔረ አቶገን አቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ህከኒች ኤተሮን ‹ቤቱኤ ከበጅታስ› ይ ቤቱስ ሶኮ። ");
INSERT INTO alw_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ጠዉ እኮጎሬ ሁኩ ቀባኑት ቤቱስ ለኦ ወክት መት-መትሀሰ ‹ረገአኖሁ ከኒት፤ አሜ እሱ ሽን ዮስርቹ ጉዕመንከ ረገዕናም› የቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","እሰን እሱ አፍ ዎይን ኣዚች አብል ፉሽት ሽቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","«ኡለስ አኑ አሜቾ ወክት ህከ ቀባኑተ መ አአኖሰ?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","እሰን «ህከ ሂለ መነ ሂለገ አዕይ ሽ ዎይን ላልቹ ወክቲን አታ ዎሎ ቀባኖተ ኣሰኖ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ኢስን « ‹ግንበኛኑት ህንቆ ክኑ እስ ሙረበ ቡዕል ክኑ እኮ፤ ሁኩንን ቀርችተ ሆጉ፤ እሌን ለኢሃ አጀብሲሰኖሃን› የመም መጻፋን ከተበሞሃ ሆሮ አነበቤንታበእንዶ? ");
INSERT INTO alw_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«ህካን እኮቤቺሃ አን ኩላንክዕኔ፤ መገን ዎምነቱ ክዕኔች ከሜን ላልቹ ላለኖ ኡመቲሃ ኣሴኖ። ");
INSERT INTO alw_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ህከን ክን አሌን ኡበኖሁ ቁሽቁሽ የኖ፤ ሁኩ ክኑ አዬ አሌኒ ኡቦጎሬ ፍጭርቀኖስ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ቂስ አዎንሳኑትለከ ፈርሳውት ኢስ ጠወዕዮ ምሳልተ ሞጮጭቶ ወክት እሰተኔሃ ጠወኡስ አጥራመቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ህካን እኮቤቺሃ እሰ አፎስተ ሀሶኡ፤ ጠዉ እኮጎሬ ኡመቱ ኢሰ ነብዬችገ ለአኖስቤቺሃ መነ ዋጅቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ኢስን ለንኪሃ ምሳሌን ");
INSERT INTO alw_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«ሰሜ ዎምነቱ ቤቲሀስ ቦለች ድግሰ ቅጥአዕዮ ዎመ አጉደኖ። ");
INSERT INTO alw_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ዎሙንኩ ቦለቺሃ ገኤመ መነ ገእቶተ ካዲመስ ሶኮ፤ ጠዉ እኮጎሬ ገኤመ መኑ አሜቱ ግቦኡ። ");
INSERT INTO alw_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","«ለንኪሃ ዎሙንኩ ዎልት ካዲመስ ‹ሁኩዕኑን ድግሰኤ ቅጥ አዕዮም፤ ቦረኤለከ ምሶ ደርገጌተ ጎረጮም፤ ጉዕሙርቹንኩ ቅጥ ይዮኡ፤ ድግስቤቹ አሜ ይቴን ገኤመሀኑኡሃ ኩሌ› ይ ሶኮ። ");
INSERT INTO alw_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","እሰን ጠወስ ህንቅ መቱ አቡረ ቤቹ ዎሉስንገ ህትን ንግድቤቹ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ፈቆሩ ህትን ካዲመስ አፍ ዎቀርት ሽቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ዎሙንኩ ኡሙዕር ዎታደረስ ሶክ ህከ ሽቶ መነ ሽሲሾ፤ ህከ ከተመንከ ቡሴእ። ");
INSERT INTO alw_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ህከ ወክት ካዲማተስ ‹ድግሱኤ ቅጥ ይዮኡ፤ እኮጎሬ ገኤመ መኑ ድግሲሀስ ገበእበረ እኮኡ። ");
INSERT INTO alw_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ህካን እኮቤቺሃ ዎቃሃ ፉልቴን ደጌንተ መነ ጉዕመንከ ድግሲሃ ገእዬ› ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ካዲመንትስ ጎዳነ ፉልት ደጎኢሃ ጉዕመንከ ሂለለከ ጡመ ጭምአታን ቦለች ምኒ መኑ ዊሞ። ");
INSERT INTO alw_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«ዎሙ ህከ መነ ለኦተ ምኒ ኣጎ ወክት ቦለች ኦድኑተ ኦደእበ መንቹ ለዕይ ");
INSERT INTO alw_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‹ኢ ጃለ! ቦለች ኦድኑተ ኦደኡዕነ ሀት ከበ ኣጎንት?› ዬስ፤ ሁኩ መንቹንኩ ጨለ ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ህከኒች ኤተሮን ዎሙ ካዲማተስ ‹አንገስለከ ሎከስ ኡሱርቴን አብሌ ቱንሽቾን ኡጅዬ፤ ህከን ቤቾን ኦኡለከ የቡሩ ገዕሙ እሀኖ› ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","መሰንትስ ገአንቶእሩ ልግብየ፤ እኮጎሬ መጠረንቶእሩ ቀዎሃን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ህከኒች ኤተሮን ፈርሳውት መርት ኢሰ ጠወአኖ ጠዊን ሉሲሶተ አማዕለንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","17","እሰን «አስተማርቾ! አት ሀንቀኘ እሁክለከ መገን ዎቃሃ ሀንቂን ተማርስታንቲሃ እሁክ ህትን መን እልተ ለእ ፈረድባሃ እሁክ ደንጋም፤ ህንዴ ኩልኔ መ አጉደኖሄት? ሮም ዎሚሃ ግብር ባቱ ፈቀደሞሃንዶ ፈቀደሞበእሃን?» ይቶተ አዎናኑሰለከ ሄሮድሴ አድ መነ ሶኮኡ። ");
INSERT INTO alw_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ኢስን ሂልመሰ ደግ «አዕኑ ኩ መኑ ለኦህዕኔተ ይቴን አቴነንተሩ፤ ሚሃት ፌተንቴነንተኤሁ? ");
INSERT INTO alw_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ህንዴ ግብር ባቴኖ ዲናረ ለልሼኤ» ዬሰ፤ እሰን መቱ ዲናረ ኤብ ኣቶስ። ");
INSERT INTO alw_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ኢስን «ከን ዲናር አሌን ከተበሞሁለከ ፎቱስ አዬሃን?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","እሰን «ሮም ዎምሃን!» ይቶኡ፤ ኢስን «ህካን እኮች ቄሳሬሃ ቄሳሬንከ መገኒሃ መገኒንከ ኣስዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","እሰን ህካን ሞጮጭቶ ወክት አጀብሲጭት አጉርት መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ህከ በር «ሬዮ መኑ ኬአኖበአ» ይታ ሳዱቃውት ኢስበ አሜት ");
INSERT INTO alw_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«አስተማርቾ! ሙስ ‹መቱ መንቹ እለተ እሉዕነ ሬዮ ጎሬ አመስቤቱ ጫስ ረገዕይ ሬዮ አመስቤቲሀስ እለተ እሉን› ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ለመሉ አመኦሱት ኒ አዳን ሄኦ እቅ፤ ሀንገፉስ ጫተ ኤብ እለተ እሉዕነ ሬያን ማዕኑ አመስቤቱ ጫስ ረገዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ህትን ለንክሁ፥ ሰቂሁ ለመልቂሃ ኢለ ረገእ እለተ እልቱዕነ ሬቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ጉዕሚችሰን ኤተሮን ህት ጫቲ ሬቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ጉዕሙንኩሰ ኣእቶሴቤቺሃ ሬሆች ኬኤኖ ወክት ህት ጫት ህከን ለመለ አመኦሶች ሀከንስ ጫተ እካአ?» ይት ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ጠዉ እኮጎሬ ኢስ ፈንቀሽ «መጻፈለከ መገን ዎልቀተ ደጌነንተበእቤቺሃ ሉሴነንታት። ");
INSERT INTO alw_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","መሰንትስ ሬሆች ኬኤኖ ወክት እሰ ሰሜ መላይከገ እካ ቤሉ ኣእታበኢ፤ መእሲሰንታበኢ። ");
INSERT INTO alw_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ሬሆች ኬእተኔሃ እኮጎሬ መገኑ ክዕኔኤሃ ");
INSERT INTO alw_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‹አን እብራሂምሃ መገኑ፥ ኢሳቂሃ መገኑለከ ያቁብሃ መገኑ› ዬኢሃ አነበቤንታበእንዶ? እስ ሄኣ መኒሃ መገኑ ቤሉ ሬዮ መኒሃ መገኑበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ሁኩ ኡመቱ ህካን ሞጮጭቶ ወክት ኢስ ትምርታን አበ አጀብሲጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ኢስ ሰዱቃውተ መስለ ከሞሰገ ፈርሳውት ሞጮጭቶ ወክት ሜጡበ እክ እስበ አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","እሳችን መቱ ሕገ ደገኖ መንቹ ፌተኖስተ ");
INSERT INTO alw_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«አስተማርቾ! ሕግ ኣዜን ዮ ትዛዚች ሀኩን በተአኖ?» ይ ጠዕሜስ። ");
INSERT INTO alw_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ኢስን ፈንቀሽ «ቀርቹ መገኑክ ዊመ ቀልብንከኪ፥ ዊመ ነብሴንከክለከ ዊመ ሰውቲንከክ ኢት። ");
INSERT INTO alw_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ኩን ጉዕሚችን በተአኖሃለከ ዎኔሃ ትዛዝ። ");
INSERT INTO alw_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ህካን አጉደኖ ለንክ ትዛዙ ‹ዎሉ መነ ገይክገ ኢት› የኖሃን። ");
INSERT INTO alw_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ሕጉለከ ነብያኑት ይቶኢሃ ኩ ለሙ ትዛዙ ሜጡበ አዕይ አፈኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ፈርሳውት ሜጡበ እክ ጭምይቶ ወክት ኢስ ");
INSERT INTO alw_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«መሲህተኔሃ መ ሰውይቴነን? እስ አዬሃ ቤቱ?» ይ ጠዕሜሰ፤ እሰን «ደዉዴየ ቤቱ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","እስን «ህካን እኮች ደዉድ ጠሊለ አያኒን እክ ሀት ‹ቀርቾ› ይ ገአኖስ? ");
INSERT INTO alw_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","« ‹ቀርቹ መገኑ ኢ ቀርቺሃ ባለጋረክ ሎካችክ ዎሮ አዲን አኣሚሃ ኢለ መኬኤ አዲን አፉዕል› ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ደዉድ ገዉንኩስ ‹ቀርቾ› ይ ገኤኢች ሀት እክ ቤቱስ እሆተ አታለኖ?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ህካን እኮቤቺሃ አዪሁ መት ላገታ ፈንቀሾተ አታሎበአ፤ ህከን በሬች ኬስ እሰ መቱርቹሃ ጠዕምቶተ መለልቶበአ። ");
INSERT INTO alw_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ህከኒች ኤተሮን ኢስ ኡመትሀለከ አሳባተስ ");
INSERT INTO alw_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«ሕግ አስተማረትለከ ፈርሳውት ሙስ ቦርጭማን አፉዕልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ህካን እኮቤቺሃ እሰ አታኢሃ እሁዕነ ኩልታህዕኔሃ ጉዕመንከ አዕዬሁ፥ አገሬሁ፤ መሰንትስ እሰ ኩልታ ጠወ ሆጎን ሆሲሳበእራን። ");
INSERT INTO alw_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","እሰ አዪሁ አታልቡለከ ኬዕምተ እጅነተ ኡሱርት መን ጌነኖን እጅሲሳእራን፤ እኮጎሬ ገዉሰ ዙሩዕሜሰ ሰኖኒ ኡልቶተ ሀሳበእራን። ");
INSERT INTO alw_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ሆጉተ አታኢሁ መኒሃ ለሊሶታት፤ መሰንትስ መገን ላጋች መት-መቱ ከተቤን ጎቤመ ክታበ አልባሽት ሚኔሰ ኡሱርታኢሁ፥ አንገሰለከ ጌነኖንከሰ ኦደአ ኦድኖሰ ሰኑተ ቄራርስታአ። ");
INSERT INTO alw_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ድግስ ምናን ኬዕምኝ ቤቾን አፉዕሉለከ ጭምት ምናን ጡመ ቦርጭማን አፉዕሉ ኢትታአ። ");
INSERT INTO alw_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ህትን በነቻን ጠብሲሶኖሰተለከ መኑ ‹አስተማርቾ!› ይ ገኦሰተ ኢትታአ። ");
INSERT INTO alw_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ጠዉ እኮጎሬ ጠለዕል መቱ አስተማርቹ ዮህዕኔቤቺሃ፥ አዕኑ ጉዕሙንኩክዕኔ አመኦሱተ እኬንተቤቺሃ ‹አስተማርቾ!› የመንቴን ገአንቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ህትን ሰማን ዮ አኑክዕኔ መጡ እኮቤቺሃ አዬሁ ከን ኣዱንያ አሌን ‹ኒ አነ!› ይቴን ገእቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ህትን አዎንሳንቹክዕኔ ሜጡ መሲህ እኮቤቺሃ ‹አዎንሳንቹ!› የመንቴን ገአንቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ክዕኔኤ በሊች ጉዕሚችን ሎሩስ ካዲንቹክዕኔ እሁን። ");
INSERT INTO alw_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ገዉስ ሎርሰኖሁ ሆፈአኖ፤ ህትን ገዉስ ሆፍሰኖሁ ሎዕረኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ኢስ «መኑ ሰሜ ዎምነቱ ኣገኖበእገ ጡፌን ከንቴነንተ ሕግ አስተማረተለከ ፈርሳዌሃ ክዕኔኤ ከን መኑ ለኦህዕኔተ ይቴን አቴነንተሀኑኡሃ ኣዬ! አዕኑ ገዉክዕኔ ኣጌነንተበአ፤ ኣጎተ ሀሳእሩ ኣጋበእገ ከንቴነንታት። ");
INSERT INTO alw_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«ለኦዕኔ ይቴን ሆንጠህሴነንተ ቄራዕሩ ዱአ መሰተ አቴን ምንሰ አኑ ሬዮ ሜንቱ ዮሰርቹ ሹልቴነንተ አዕኑ ሕግ አስተማረትለከ ፈሪሳውያኑት ቆሀኖህዕኔ! ህካን እኮቤቺሃ ክዕኔሃ ባሱ ፍርዱ አሌክዕኔ አሜተኖ። ");
INSERT INTO alw_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«አዕኑ ኩ መኑ ለኦህዕኔተ ይቴን አቴነንተ ሕግ አስተማረትለከ ፈርሳውት መቱ መንቹ ክዕኔኤ አመዕነቶን ፈንቀሽቶኖተ ባርለከ ኡለ አሌን ዘህቴነንተ፤ እስን ፈንቀሎ ወክት ክዕኔኤች ለሙ አፎሃ በተእ ዘላለሚሃ ጠእትቡ ጊራን ቅጠሞኢሃ አቴነንተቤቺሃ ክዕኔኤሃ ቆሀኖህዕኔ! ");
INSERT INTO alw_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«አዕኑ ቆቁ አዎንሳኑት! ‹መቱ መንቹ መገን ምኔን ጤሌዕሌጎሬ መቱርቹሃ ደግለለኖስበአ፤ እኮጎሬ መገን ምኔን ዮ ዎርቃን ጤሌዕሌጎሬ ጤሌዕልንከስ አፈመኖ› ይቴነንተቤቺሃ ክዕኔኤሃ ቆሀኖህዕኔ! ");
INSERT INTO alw_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","አዕኑ ኩ ቆቃኑትለከ ገዋኑት! ዎርቀስ ጠሊለ አአኖ መገን ምኑንዶ ዎርቁስ በተአኖ? ");
INSERT INTO alw_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ህትን ‹መቱ መንቹ መገኒሃ ክትመ ሆንጠህሴኖ ጠረጴዝ ቤቾን ጤሌዕሌጎሬ መቱርቹሃ ደግለለኖስበአ፤ እኮጎሬ ክትሜኖ ቤቾን ክትሚሃ ሆንጠህሴኖርቾን ጤሌዕሌጎሬ ጤሌዕልንከስ አፈመኖ› ይቴነንተ። ");
INSERT INTO alw_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","አዕኑ ኩ ቆቃኑት! ክትመ ጠሊለ አአኖ መገኒሃ ክትም ሆንጠህሴኖ ጠረጴዙንዶ ክትሙስ በተአኖ? ");
INSERT INTO alw_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ህካን እኮቤቺሃ መገኒሃ ክትም ሆንጠህሴኖ ጠረጴዛን ጤሌዕሌኢሁ መገኒሃ ክትም ሆንጠህሴኖ ጠረጴዘለከ ዮርቾን ጉዕማንን ጤሌዕለኖ። ");
INSERT INTO alw_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ህትን መገን ምኔን ጤሌዕሌኢሁ መገን ምኔንለከ ኣዜንከስ ሄአኖ መገኖን ጤሌዕለኖ። ");
INSERT INTO alw_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ህትን ሰማን ጤሌዕለኖሁ መገን ጄነት ቦርጭማንለከ ጄነት ቦርጭማን አፉዕለኖሀኔን ጤሌዕለኖ። ");
INSERT INTO alw_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«አዕኑ ኩ መኑ ለኦህዕኔተ ይቴን አቴነንተ ሕግ አስተማረትለከ ፈርሳውት፤ መንዞቺ፥ ዎስማሚቺ፥ አደደ ጠጎቺ ቶኒች መቱ ፉሽቴን ሕግ ኣዜን ዮ ሎረስ ጠወ ሀንቅ ፍርደሃ፥ አሙዙለከ አመዕነሙ አጉርቴነንተቤቺሃ ክዕኔኤሃ ቆሀኖህዕኔ! ዎሉስ አጉርቶኑዕነ ካን አኡ ሀስሰኖህዕኔ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","አዕኑ ቆቁ አዎንሳኑት! አጌነንተሀኒች ጉዕሚችን ቢንቤገ ቀቅቹ እኮሃ ጠሊሽቴነን ኡጅቴነንተ፤ እኮጎሬ ጋሜልገ ዮ ሎረስ አጉዕምቴነንታት። ");
INSERT INTO alw_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«አዕኑ ኩ መኑ ለኦህዕኔተ ይቴን አቴነንተ ሕግ አስተማረትለከ ፈርሳውት ቡርጩቆለከ ሳህን አብል አደ ሙጩርስቴነንታት፤ እኮጎሬ ኣዙክዕኔ አደደ ገዶንለከ ጎራምማን ዊሞቤቺሃ ክዕኔኤሃ ቆሀኖህዕኔ! ");
INSERT INTO alw_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","አዕኑ ኩ ቆቃኑት ፈርሳውት! ኤተርስ አዱ ሙጩራን ሄጭቴን ቡርጩቆለከ ሳህን ኣዝስ ሙጩሩ አዕዬ። ");
INSERT INTO alw_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«አዕኑ ኩ መኑ ለኦህዕኔተ ይቴን አቴነንተ ሕግ አስተማረትለከ ፈርሳውት፤ ኣዜሰ ሬዮ መን ምቁለከ ንጃሾርቹ ጉዕሙንኩ ዊማንሰ እኮጎሬ አብል አዲን ጡመ ተሽ የኖ ኖሪን መክሴመ ሎደ አጉዴነንተቤቺሃ ክዕኔኤሃ ቆሀኖህዕኔ! ");
INSERT INTO alw_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ህከንገን አዕኑ መኒሃ ፈየ አጉዴን ለልቴነን ኣዜንከክዕኔ መኑ ለኦህዕኔተ ይቴነን አኡለከ አዘዘሙ ግቡ ዊሞህዕኔ። ");
INSERT INTO alw_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«አዕኑ ኩ መኑ ለኦህዕኔተ ይቴን አቴነንተ ሕግ አስተማረትለከ ፈርሳውት፤ ነብያኖ ሎደ ግምብቴነንለከ ፈየ መን ሎዳን ሐዉልተ መክሴነን ");
INSERT INTO alw_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","‹አናኖኔ ዘማኔን ሄዕኖም እቃ አናኑኔ ነብያኖ ቄጉ ዱንተን ነኡ ሜጡበ እንካምበአ እቅ› ይቴነንተቤቺሃ ክዕኔኤሃ ቆሀኖህዕኔ! ");
INSERT INTO alw_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ህከኒን ነብያኑተ ሽቶ መን እለተ እሁክህዕኔ ገዉንኩክዕኔ መሰከርቴነንታት። ");
INSERT INTO alw_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ህካን እኮች አዕኑ አናኑክዕኔ አቶተ ጀመርቶ ሂለ ሆጉተ ሹሌ። ");
INSERT INTO alw_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","አዕኑ ኩ ደህችለከ ዎሪች እለት አዛብ ፍርዲች ሀት እኬን ፈቄነን? ");
INSERT INTO alw_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ህካን እኮቤቺሃ ሁኩዕኑን አን ነብያኑተ፥ ሀይቻኑተ፥ አስተማረተ ክዕኔቤቹ ሶሃም፤ እሳችን መት-መቱሰ ሽቴነንተ፤ መት-መቱሰ ሰቀልቴነንተ፤ ህትን መት-መቱሰ ጭምትክዕኔ ምኔን አብዳዴን ኦልቴነንተ፤ መቶ ከተሚች ዎሉ ከተመ ሸርቴነንተሰ። ");
INSERT INTO alw_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ህካን እኮቤቺሃ ጠሊለ አቤሌ ቄጊች ጀመር መገን ምኔንለከ መገኒሃ ክትም ክትሜኖ ጠረጴዝ በላን ሽቴንተ በራክዮ ቤቱ ዘከርያ ቄጉ ኢለ ኡለ አሌን ዱንተዕዮ ጠሊላኖ ቄጊሃ ጉዕሚንከ አዕኑ ጠዕመንቴነንተ። ");
INSERT INTO alw_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ሀንቅንከ ያንክዕኔ፤ ኩ ቄግ ቅጣቱ ጉዕሙንኩ ከን ዘማን መን አሌን ኢለኖ።» ");
INSERT INTO alw_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«ዬሩሳሌማ! ዬሩሳሌማ! ነብያኑተ ሽታንቲት! ኪቤቹ ሶሀንቶእረ ክኒን ቀስ ሽታንቲት! ሀንጠቤቹት ጪጮረሴ ጎኔሴ ኣዜን ሀንቀፋገን አኒሁ ኪ እለተ ጭምአኦተ ሀሾሚሁ ሄንከ ወክትሃት? እኮጎሬ አዕኑ ሀሴንታኤበአ። ");
INSERT INTO alw_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ሁኩዕኑን ምኑክዕኔ ኦነ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","መሰንትስ አን ኩላንክዕኔ፤ ‹ቀርች ሱዕሚን አሜተኖሁ ማሰአሞእሃን› ይቶኖተ ኢለ ለንኪሃ ለኤነንተኤበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ኢስ መገን ምኒች ፉል ኦሮአን አሳበስ ዱእ ምኒ ግምበ ለሊሶስተ ሆንጠኮኡ። ");
INSERT INTO alw_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","እኮጎሬ እስ «ከ ጉዕመንከ ለኤነንታትንዶ? ሀንቅንከ ያንክዕኔ፤ ክኑ ክን አሌን እኮገን መቱ ክኑሁ ከንቤቾን ፈቁዕነ ድጀመኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ኢስ ዘይት ሀቁ ነጰኖ ቆተ አል ፉል አፉዕሌሀኔን ጠለዕል አሳበስ እስበ ሆንጠክ «ኪ አሜቱለከ ቂያመት ቢጠም መላት መሃን? ህትን ኩ ጉዕሙንኩ ጠዉ እሀኖሁ መ ወክትዪት?» ይት ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ኢስን ፈንቀሽ «አዪሁ ሉሲሰኖህዕኔበእገ አገዕርዬ። ");
INSERT INTO alw_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","መሰንትስ ልግቡ መኑ ‹አን መሲህት!› ይተን ሱዕሚንከኤ አሜት ልግብ መነ ሉሲሳአ። ");
INSERT INTO alw_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","በገዙለከ በገዝ ትምርት ሞጮጭቴነንተ፤ ሁኩን ጉዕሙንኩ እሁዕነ ፈቀኖበእቤቺሃ ህልቆኖቼ፤ እኮጎሬ መጨረሹስ ኢልዮበአ። ");
INSERT INTO alw_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","መኑ መን አሌን ዎሙ ዎም አሌን በገዙ ኬሰኖ፤ ጎሩለከ አደደ ቤቾን ኡለ ሌንቄቁ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ሁኩን ጉዕሙንኩ ኒጠኛ ጭንቃተ ዎኔሲሃ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ህከ ወክት ኦርሻተ ህግሴን ኣሴኖህዕኔ፤ ህትን ሼኖህዕኔ፤ ክዕኔተ ኢ ሱዕምተኔሃ ጉዕማንከ መንቤቾን ግቤኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ህትን ልግቡ መኑ ህከ ወክት ሀይማኖተሰ ካደአ፤ ህትን መቱ መቱስ ህግሽ ኣሰኖ፤ መኑ ገገይንከስ ብተመኖ። ");
INSERT INTO alw_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ልግቡ ክዝብ ነብያኑት ኬእ ልግብ መነ ሉሲሳአ። ");
INSERT INTO alw_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ሂሉ ጠዉ በተዕዮቤቺሃ ልግብያ መን ኢተት በኣአ። ");
INSERT INTO alw_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ጠዉ እኮጎሬ መጨረሸ ኢለ ጠረኘኖሁ ጡመኖ። ");
INSERT INTO alw_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","መን ጉዕሚንከ ምስክር እሆተ ኩ መገን ዎምነት ተሽት ላገት ኣዱንያ አሌን ጉዕማንን ዱዱብሰንታአ፤ ህከ ወክት ቅያመት ሆንጠካአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","አነበበኖሁ ካን አጥራመቱን፤ ነብዬቹ ዳኔል ጠወዕዮገን ኮፍየኖ ንጃሾርቹ ማሰአሞ ቤቾን እካን ለኤነንተ ወክት ");
INSERT INTO alw_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ይሁድ ባዶን ሄኣእሩ ቆተ አል ሁንቱን። ");
INSERT INTO alw_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ምኒ እሌ አሌን ዮ መንቹ ምኔስ ዮርቹ ኣኦተ ድሩንከ። ");
INSERT INTO alw_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ህትን አቡረ ቤቾን ዮ መንቹ ኦድኑስ ኣኦተ ምንስ ፈንቀሉንከ። ");
INSERT INTO alw_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ህከ ወክት ቀንስተሀኑኡተለከ ላፈ ሜንቲሃ ኣዬ። ");
INSERT INTO alw_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ሁንቴነንተ ወክቱ ከርሜን ህከረንገ አበ በር እሀኖበእገ ዱአ አዕዬ። ");
INSERT INTO alw_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ህከ ወክት ኣዱንያ አሉ ከለቀሞች ጀመር እኮበኢሁለከ ብርተ ዋሽ ሆሮን እሀኖበእ አቡ ኦሪሸት አሜታአ። ");
INSERT INTO alw_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ሁኩ ኦሪሸ ወክቱ ገቦጥዮበእቃን መቱ መንቹሁ ጡሞተ አታለኖበአ እቅ፤ ጠዉ እኮጎሬ መጠረንቶ መንተኔሃ ሁኩ ወክቱ ገበንቹ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ህከ ወክት አዪሁ «መሲሁ ከበ ዮኡ!» ህከረንገ «ካጳ ዮኡ!» ዬህዕኔጎሬ አመዕንቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","መሰንትስ ክዝብ መሲህት ይታእሩለከ ነብያኑት ኬኢሃ አታልቶ እቃን መጠረንቶ መነሃ ፈቁዕናን ሉሲሶተ አበ መላተለከ አጀብሲሰኖ ጠወሃ ለሊሳቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ሁኩዕኑን አን ጉዕመርቹንከ ሄጭ ኩሎንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ህካን እኮቤቺሃ «ሁኩዕኑን! ኡድማን ዮኡ» ዬመህዕኔጎሬ ፉልቶኖቼ፤ ህትን «ሁኩዕኑን! ማጠሞ ቤቾን ዮኡ» ዬመህዕኔጎሬ አመዕንቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","መሰንትስ ጉገኛት ጉጋ ወክት ሸርቂች ኬሽ ገርበ ኢለ ለለኖሀንገን መንች ቤት አሜቱሁ ህትን እሀኖ። ");
INSERT INTO alw_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ሬሹ ኡቦቤቹ ዞብሩ ጭምየኖ ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ኢስ «ህከን ኦርሻች ኤተሮን ወክትንከስ አሩ ቱንሰኖ፤ አገንቹንኩ ለሊሰኖበአ፤ ቤዜት ሰሜች ኡባአ፤ ሰማንዮርቹ ጉዕሙንኩ ሌንቄቀኖ። ");
INSERT INTO alw_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ህከ ወክት መንች ቤት መላት ሰማን ለልታአ፤ ኣዱንያ አሌን ዮ መኑ ጉዕሙንኩ አበ ኦአኖ፤ መንች ቤቱንኩ ዎልቃንለከ ሎረ ኬዕምኚን ሰሜ ጎማን አሜተን ለኣአ። ");
INSERT INTO alw_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ጡሩምበ ሎረ ላጋን ቡሳ መላይከተ ሶሀኖ፤ እሰን ሾሎንከ ሰሜ ዳንጊች እሲሃ መጠረንቶእረ ጭምአታአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ኢስ «ኦድ ሀቁቾ ምሳሌች ተማሬ፤ ሀሙሴ ለተንለከ ሀበሩሴ ገምበለዕያን ለኤንተ ወክት ሀጎ ሆንጠሁስ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ህትን አዕኑ ኩ ጠዉ ጉዕሙንኩ እሀን ለኤንተ ወክት ጠወአንቶ ላገኤ ዊንታ ወክቱ ኢሌገ ደጌ። ");
INSERT INTO alw_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ሀንቅንከ ያንክዕኔ፤ ኩን ጉዕሙንኩ ዊሞተ ኢለ ከን ዘማን መኑ ህገኖበአ። ");
INSERT INTO alw_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ሰሞሁለከ ኡለት ህጋአ፤ ጠዉ እኮጎሬ ላገኤ ሆሮ ህጋበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ኢስን «ህከ በርለከ ህከ ሳኣት አነ መገን ቤሉ ሰሜ መላይከት እኮእቃን ቤቱሃ እቃን አዪሁ ደጎተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ኑህ ዘማን እኮገን መንች ቤቲ አሜቱሁ ህትን እሀኖ። ");
INSERT INTO alw_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ህከ ዘማን ቤሰኖ ዊች ሄጭ ኑህ መርከባን ኣገኖ በር ኢለ መኑ እተኖቲ፥ አገኖቲ፥ ኣአኖትለከ መዕሲሰኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ቤሰኖ ውሁ አሜች ጉዕመንከሰ ሀጣው መሶተ ኢለ ደጎበእሀንገን መንች ቤቲ አሜቱሁ ህትን እሀኖ። ");
INSERT INTO alw_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ለሙ መኑ አቡርታቤቺች መቱስ መሴናን መቱስ ፈቀኖ። ");
INSERT INTO alw_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ለሙ ሜንቱ ሪትማን ሪታ ቤቺች መትሴ መሴናን መትሴ ፈቃአ። ");
INSERT INTO alw_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ህካን እኮቤቺሃ ቀርቹክዕኔ አሜተኖ በር ደጌነንተበእቤቺሃ ጠረኝቴን አገዕርዬ። ");
INSERT INTO alw_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ጠዉ እኮጎሬ ካን ደጌ፤ መቶ ምኒ አኑ ሞጋንቹ ሀንከዕሬን ሀከ ወክት አሜተኖጎሬ ደጎእቃን ምንስ እሞኖተ ሰዕምየኖበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ህካን እኮቤቺሃ መንች ቤቱ ሰውይቴንበ ወክቴን አሜተኖቤቺሃ አዕኑ ተቃጠቤን አገሬ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ኢስ «ምንስ አበሮሲሃ እቸተ ወክቲን ኣሶተ ቀርቹስ አበሮስስ አሌን ዳኛ አእዮስ አመዕነሞለከ ኤንኬዕናሙ ካዲንቹ አዬት? ");
INSERT INTO alw_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ቀርቹስ አሜቾ ወክት እስ ዬገን አአን ደገመኖ ካዲንቹ ማሰአሞእሃን። ");
INSERT INTO alw_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","አን ሀንቅንከ ያንክዕኔ፤ ህከ ካዲንቹ ቀርቹስ ዮስ ዱንያ አሌን ጉዕማንን ሹመ አአኖስ። ");
INSERT INTO alw_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","እኮጎሬ ሂሉ ካዲንቹ ‹ቀርቹኤ ቴሱ አሜተኖበአ› ይ ሰውዬጎሬ ");
INSERT INTO alw_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ሆጎስ ጃለተ ኦለን ሰካራሚን ሜጡበ እቱለከ አጉ ጀመሮጎሬ ");
INSERT INTO alw_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ህከን ካዲንች ቀርቹ አገሮበእ በሬንለከ ሳኣቴን አሜች ");
INSERT INTO alw_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ህከ ካዲንቹ ቀጠአኖስ፤ ህትን መኑ ለኦሰተ ይት አታ መኒን ሜጡበ አዕያንስ ህከኔ ኦኡለከ የቡሩ ገዕሙ እሀኖስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ኢስን ሰሜ ዎምነቱ ኩረዘ አፍ እዜቹ ቶጎተ ፉልቶ ቶን ሜኣኑተ አጉዳአ። ");
INSERT INTO alw_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","እሳችን ኦንቱሰ ገዋኑተ፥ ኦንቱሰ ኤንኬዕናመተ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ገዋኑስ ኩረዘ አፎ እቅ፤ እኮጎሬ ጋዘ አፎበአ። ");
INSERT INTO alw_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ኤንኬዕናመት ኩረዘለከ ዎሌ ኦዳን ጋዘ አፎ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","እዜቹ አሜቱዕነ ዱንኬ ወክት ጉዕመንከሰ ግሰኛት ቄልታንሰ ኦሰኦኡ። ");
INSERT INTO alw_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","እኮጎሬ ሀዎሮ በላን «ሁኩዕኑን! እዜቹ አሜቾኡ፤ ፉልቴን ቶጌ!» ዬኖ ጨንጨነት እኮኡ። ");
INSERT INTO alw_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ህከ ወክት ጉዕሙንኩ ሜኣኑት ኬእ ኩረዘሰ ቅጥአቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ገዋኑት ኤንኬዕናመተ ኩረዙኔ ጠኦታት፤ ህካን እኮቤቺሃ ጋዝችክዕኔ ኣስዬኔ ይት ኡጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ኤንኬዕናመት ፈንቀሽት ክዕኔኤሃለከ ኔሳሃ እሀኖ ጋዙ ዮኔበአ፤ ሱቀ መርቴን ክዕኔ እሀኖህዕኔ ጋዘ ህዕርዬ ይት ፈንቀሽቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ሁኩ ገዋኑንት ጋዘ ህዕርቶተ መርቶ ጌሳን እዜቹ አሜቾ፤ ተቃጠብ አገርቶ ሜኣኑት እዜቺን ሜጡበ ቦለች ድግስቤቹ ኣጋን ኡሩት ጡፈንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","«ሁኩ ገዋኑት ኡሩት ጡፌማች ኤተሮን አሜት ‹ቀርቾ! ቀርቾ! ሀዕይ ኡሩተ ፈንኔ› ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","እኮጎሬ እስ ፈንቀሽ ‹ሀንቅንከ ያንክዕኔ፤ አን ደጋንክዕኔበአ› ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ህካን እኮቤቺሃ በርስለከ ሰኣትስ ደጌነንተበእቤቺሃ ጠረኝቴን አገዕርዬ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ኢስ «ሰሜ ዎምነቱ ዎሉ ባዱ ሃሞተ ካዲመስ ገእ ዮስ ዱንያተ ኣሴ መንቹ አጉደኖ። ");
INSERT INTO alw_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","መት-መትሀሰ ዎልቀሰ ጌሰ ቤሀን መቲሀስ ኦንቱ መክሊተ ሁኩ መክሊቱ መኬኢሁ ጠገር ብርቺት። መቲሀስ ለሙ መክሊተ ህትን ዎልሀስ መቱ መክሊተ ኣስ ዎሉ ባዱ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ኦንቱ መክሊተ ኣኤኢሁ ወክትንከስ ኦሮዕይ ነገጅ ዎሉ ኦንቱ መክሊተ ተረፍሾ። ");
INSERT INTO alw_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ህትን ለሙ መክሊተ ኣኤኢሁ ነገጅ ዎሉ ለሙ መክሊተ ተረፍሾ። ");
INSERT INTO alw_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","እኮጎሬ መቱ መክሊተ ኣኤኢሁ ኦሮዕይ ኡለተ እም ቀርችስ መክሊተ ሞጎ። ");
INSERT INTO alw_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«ልግብያ ወክቲች ኤተሮን ህከን ካዲመ ቀርቹ ኦሮዕዮ ቤቺች አሜች ካዲማንከስን መክሊተ አሰቡ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ኦንቱ መክሊተ ቶጎ ካዲንቹ ዎሉ ኦንቱ መክሊተ አፍ ቀርችቤቹ አሜች ‹ቀርቾ! ኦንቱ መክሊተ ኣቶንቴኤ እቅ፤ ሁኩዕኑን ዎሉ ኦንቱ መክሊተ ተረፍሾም› ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ቀርቹንኩ ፈንቀሽ ‹ጡመ አቶንት፤ ኩ ጡሙለከ አመዕነንቶንት ካዲንቹ! ከን ቀዎርቾን አመዕነንቶንትቤቺሃ ሎረርቾን ሹመ አኣንኬ፤ አም! ቀርችክ ሙንዲኖቤቹ ኣግ!› ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ህትን ለሙ መክሊተ ቶጎ ካዲንቹ አሜች ‹ቀርቾ! ለሙ መክሊተ ኣቶንቴኤ፤ ሁኩዕኑን አን ዎሉ ለሙ መክሊተ ተረፍሾም› ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ቀርቹንኩ ‹ጡመ አቶንት፤ አት ኩ ጡሙለከ አመዕነንቶንት ካዲንቹ! ከን ቀዎርቾን አመዕነንቶንትቤቺሃ ሎረርቾን ሹመ አኣንኬ፤ አም! ቀርችክ ሙንዲኖቤቹ ኣግ› ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","መቱ መክሊተ ቶጎ ካዲንቹ አሜች ‹ቀርቾ! አት ዉጥበቤቺች ምዳንቲሃለከ ፍንጭትበቤቺች ጭምአታንቲ አሙዝበ መንቹ እሁክ ደጎም። ");
INSERT INTO alw_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ህካን እኮቤቺሃ ዋጅ መክሊተክ ኡለ ኣዜን ሞጎም፤ ሁኩዕኑን መክሊቱክ› ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ቀርቹንኩ ‹አት ኩ ሂሉ ደግለልትቡ ካዲንቹ! አን ዉጮምበእቤቺች ምዳምገለከ ፍንጭበቤቺች ጭምአኣምገ ደገንንዶ? ");
INSERT INTO alw_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ህካን እኮች አን አሜች መክሊተእ ትርፊንከስን ኣኦተ ተረፍሰኖ መኒሃ ኣሱ ሀስሰኖኤ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ህካን እኮቤቺሃ መቱ መክሊተ ኣእቴን ቶኑ መክሊቱ ዮስ መንቺሃ ኣስዬ። ");
INSERT INTO alw_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","መሰንትስ ዮስ መንቺሃ ኣሰመኖሲሁ፥ በተአኖሲሁ፤ እኮጎሬ ዮስበእሀኒች ሁኩ ዮሲንኩ ኣአመኖስ። ");
INSERT INTO alw_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ህከ ደግለልቡ ካዲንቹ አብሌ ዮ ቱንስቾን ፉሽቴን ኡጅዬ፤ ህከኔን ኦኡለከ የቡሩ ገዕሙ እሀኖስ› ዬስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ኢስ «መንች ቤቱ ጉዕመንከ መላይካንተስ አጀበም አሜቾ ወክት ኬዕምኝስ ጄነት ቦርጭማን አፉዕለኖ። ");
INSERT INTO alw_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","መኑ ጉዕሙንኩ ብሬስ ጭምየኖ፤ እስን ዜማንቹ ሆለተ ፌዕላኢች አደ አአኖሀንገ መቱ-መቲች አደ አአኖ። ");
INSERT INTO alw_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ህትን ሆለተ መኬስ አዲን ፌዕላኡ ጉረስ አዲን ኡርሰኖ። ");
INSERT INTO alw_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ህከ ወክት ዎሙ መኬስ አዲን ዮሀኑኡተ ‹አዕኑ አኑኤ ማሰእዮህዕኔሩ አሜ! ኣዱንያት ከለቀንቶች ኬሽ ቅጠሞህኔ ዎምነቱ ረገዕዬ። ");
INSERT INTO alw_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","መሰንትስ ጎሩ አፋዕኔ እትሴንታኤ፤ ሰገባዕኔ አግሴንታኤ፤ ኮህቹ እክ አሜቻን ቶጌንታኤ። ");
INSERT INTO alw_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ኦድኑተ ሆጋን ኦድሴንታኤ፤ ጥዣዕኔ ጠዕምቴንታኤ፤ ኡሱረማን ለኤንታኤ› የኖሰ። ");
INSERT INTO alw_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ህከ ወክት ጠሊላኑት ‹ቀርቾ! ጎሩ አፋንኬ ለዕን ሀከረ እትንሶንኬ ህከረንገ ሰገብት አፋንኬ ለዕን ሀከረ አግንሶንኬ? ");
INSERT INTO alw_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ህትን ኮህቹ እክ አሜታን ሀከረ ቶንጎንኬ? ኦድኑተ ሆጋን ለዕን ሀከረ ኦዲንሶንኬ? ");
INSERT INTO alw_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ህትን ሀከረ ጥዛን ህከረንገ ኡሱረንታን ለዕኖንኬ?› ይት ፈንቀሽታስ። ");
INSERT INTO alw_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ዎሙንኩ ‹ሀንቅንከ ያንክዕኔ፤ ከን አመኤኦሶች መቶ ቀይሀስ አቴንታሁ ጉዕሙንኩ ኤሳሃ አቴንተሀንጋት› ይ ፈንቀሸኖሰ። ");
INSERT INTO alw_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ህትን ጉረ አዲን ሄኦሀኑኡተ ‹አዕኑ ቦሮረንቴንታእሩ! ኢች ቄዕርዬ! እልቢስሀለከ አዎንታስ መላይከተ ቅጥይቶ ዘላለሚሃ ጠእትቡ ጊራ ኣዝ ኦሮዕዬ። ");
INSERT INTO alw_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","መሰንትስ ጎሩ አፋዕኔ እትሴንታኤበአ፤ ሰገባን አግሴንታኤበአ። ");
INSERT INTO alw_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ኮህቹ እካን ቶጌንታኤበአ፤ ኦድኑተ ሆጋን ኦዲሴንታኤበአ፤ ጥዣን ህከረንገ ኡሱረማን ጠዕምቴንታኤበአ› የኖሰ። ");
INSERT INTO alw_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","እሰን ፈንቀሽት ‹ቀርቾ! ጎሩ አፋንኬ ለዕን ህከረንገ ሰገባን ህከረንገ ኮህቹ እካን ህከረንገ ኦድኑተ ሆጋን ህከረንገ ጥዛን ህከረንገ ኡሱረንታን ሀከረ ለዕን ሀዕልኑዕነ አጉርኖንኬ?› ይታስ። ");
INSERT INTO alw_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ዎሙንኩ ‹ሀንቅንከ ያንክዕኔ፤ ከን ቀቀዋኖች መቲሀስ አቴንባች ኤሳሃ አቴንበኤሀንጋት› የኖሰ። ");
INSERT INTO alw_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ህካን እኮቤቺሃ ጩበኛኑት ዘላለሚሃ ቀጠአንታቤቹ መርታአ፤ እኮጎሬ ፈያኑት ዘላለሚሃ ሄአኖ ሄእቤቹ መርታአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ኢስ ካን ጉዕመንከ ተማርስ ሹሎች ኤተሮን አሳባተስ ");
INSERT INTO alw_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«ለሞ በሬች ኤተሮን ሻሽግ ከበጀት ከበጄኖሃ ደጌነንተ፤ ህትን መንች ቤቱ ሰቀሊሃ ህግሴን ኣሴኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ህከ ወክት ቂስ አዎንሳኑትለከ ባድ ባልቀት «ቀያፈ» ዬኖ ሎረ ቂስች ግቤን ጭምይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","እሰ ኢሰ ተንኮን አፍ ሽቶተ አማዕለንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ጠዉ እኮጎሬ እሰ «መን በላን ብተት ኬኣቤቺሃ ከበጃት በሬን እሁንከ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ጎግ አሌን ፉልታ ጥዘነት ዮስ ስሞኔ ምኔን «ቢታነ» ዬኖቤቾን ኢስ ዮሀኔን ");
INSERT INTO alw_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","መት መንቹት ዋጉሴ አበ ጤአተ እኮ ሽቱት ዊንቶእ «አልባስጥሮሰ» ዬኖ ብልቃጠ አፍ ኢስቤቹ አሜቶኡ፤ እስን ማዳን አፉዕሌቤቾን ቡዕለስ ሽቱተ ዱንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","እኮጎሬ አሳበስ ለእ ኡሙዕርት «ኩ ሽቱት ሚሃ ተሰ በኣአ? ");
INSERT INTO alw_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ከ ሽቱተ አበ ብረ ህሬን ቡጥቻኖተ ኣሴመ እቃን ጡመ እቅ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ጠዉ እኮጎሬ ኢስ እሰ ይታኢሃ ደግ «ት መንቹት ኤሳሃ ጡመርቹ አቶኤ፤ ሚሃ ኦርሴነንተሴት? ");
INSERT INTO alw_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","መሰንትስ ቡጥቻኑት ጉዕመ ወክት ክዕኔን ሄኣእረ፤ ጠዉ እኮጎሬ አን ጉዕመ ወክት ክዕኔን ሜጡበ ሄኣምበአ። ");
INSERT INTO alw_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","እሴ ከ ሽቱተ አሌኤ ዱንቶኢሁ ሞጎኖኤተ ቅጥ አቶታት። ");
INSERT INTO alw_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ሀንቅንከ ያንክዕኔ፤ ኩ ተሽት ላገት ኣዱንያ አሌን ዱዱብሰመኖቤቾን ጉዕማንን ት መንቹት አቶ ጠዉ እሴተ ሰውዬኖሴገ አአኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ቶነ ለሞንከ አሳባች መቱስ አስቆሮቶ ይሁድ ቂስ አዎንሳኖቤቹ መር ");
INSERT INTO alw_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","«አን ኢሰ ህግሽ ኣሴንክዕኔጎሬ መ ኣቴነዕኔ?» ዬእ፤ እሰን ሰጁ ጠገር ብረ ኣቶስ። ");
INSERT INTO alw_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","እስን ህከን ወክቲች ጀመር ኢሰ ህግሽ ኣሶተ መከኖ ወክት ሀሰኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ጦሮሹ እቴነን ከበጄኖ ከበጃት ዎኔ በር አሳበት ኢስበ ሆንጠክ «ሻሽግ ሁርባት ሀከንቤቾን ቅጥአኖሄተ ሀሶንት?» ይት ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ኢስን «ከተመ መርቴን ‹አስተማርቹ ወክቱእ ኢሌቤቺሃ አሳባንተኤን ሻሽግ ከበጃት ሁርባት እታሚሁ ኪ ምኔንት የኖት› ይቴን ኩሌስ» ይ መቶ መንችቤቹ ሶኮ። ");
INSERT INTO alw_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","አሳበስን ኢስ አዘዦገን ሻሽግ ሁርባት ቅጥአቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ኡለት ሀዎርቶ ወክት ኢስ አሳባንተስን ማዳን አፉዕሌእ። ");
INSERT INTO alw_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","እተንን «ሀንቅንከ ያንክዕኔ፤ ክዕኔች መቱ ኤሳሃ ህግሽ ኣሰኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","አሳበንት ህከን ጠወን አበ ሻዝ «ቀርቾ! ኤሳህትንዶ?» ይተን መት-መቱሰ ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ኢስን ፈንቀሽ «ቴሱ ኢን ሜጡበ አንገስ ብጥራን ወረኖሁ ኤሳሃ ህግሽ ኣሰኖኤ። ");
INSERT INTO alw_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","መንች ቤቱ እስተኔሃ ከተበሞገን ሬሀኖ፤ ጠዉ እኮጎሬ መንች ቤቱ ህግሽ ኣሰኖ መንቺሃ ቆሀኖስ! ሁኩ መንቹ እለሞበእቃን ቆሀኖስ እቅ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ህግሽ ኣሰኖ ይሁድን ፈንቀሽ «አስተማርቾ! ኤሳህትንዶ?» ዬእ፤ ኢስን ፈንቀሽ «አት ይቶንትጋንት» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","እሰ እተንን ኢስ ዳቡተ ኬሽ ማሰዕይ ቢጭ አሳባተስ «ኩን ማላኤ፤ ኣእቴን እቼ» ይ ኣሴሰ። ");
INSERT INTO alw_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ጠበቴሃ ኬሽ መገኑ ገለትጭ ዱአ አዕዮች ኤተሮን «ጉዕሙንኩክዕኔ ህከን ጠበቴች ኣጌ። ");
INSERT INTO alw_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ልግብያ መን ጩቡ ፈቆተ ሃዕሮ ጉዲሃ ዱንተአኖሃ ቄጉሃኤ። ");
INSERT INTO alw_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ሃዕሮ ወይነ አንኤ ዎምነቴን ክዕኔን ሜጡበ አጋም በሩ ኢለ ከን ወይን ላልቺን ዎሬማሃ ሆሮን አጋምበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ህከኒች ኤተሮን መዝሙረ ዘመርት ቆተ አል ፉልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ህከ ወክት ኢስ «ከበሬ ሀንከዕርተ ጉዕሙንኩክዕኔ ኤሳሃ ለገኤነንተኤ፤ መሰንትስ ‹ዜማንቹ ዎቀራም፤ ዜሜ ሆለንት ብን ይታአ› የመም ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ጠዉ እኮጎሬ ሬሆች ኬዕዮሚች ኤተሮን ክዕኔተ ሄጭ ገሊለተ ኦሮኣም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ጴጥሮስ ፈንቀሽ «ዎሉ ጉዕሙንኩ ለገዕዮሄ ጎሬ አን ሆሮን ለገኣንኬበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ኢስን «ሀንቅንከ ያንኬ፤ ከበሬ ሀንከዕርተ ሀንጠቦ ዎዱዕነ ሄጭት ኤሳሃ ሰሶረ ለገኣንቴኤ» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","እኮጎሬ ጴጥሮስ ፈንቀሽ «ሆሮ ኪን ሜጡበ ሬሃምያ ጎሬ አን ሆሮን ኬሳሃ ለገኣንኬበአ» ዬእ፤ ፈቆ አሳበንት ህትን ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ህከኒች ኤተሮን ኢስ አሳባንከስን ሜጡበ «ጌተሰማኔ» ዬኖ አቡረ ቤቹ ኦሮዕዮ፤ እሳንከ «አን ካጳ ኦሮዕይ ዱአ አኦተ ኢለ አዕኑ ከኔ አገሬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","እስን ጴጥሮሴለከ ዘብዶሴ ኦሱተ ኣእ ኦሮዕይ አበ ሻዥ ጨነቀመኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ህትን «ሩህቹኤ ፉልቶተ ኢለ አበ ሻዦም፤ አዕኑ ከኔ አገሬ፤ ኢን ሜጡበ ጠረኝዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","እሳች መቱ ጌሰ ቄዕር ኦሮዕዮች ኤተሮን ኡለ ኡብ ዱአ አአን «ኢ አነ! አታለመኖሄ ጎሬ ከ ኦርሸ ጠበትተ ኢች ህግስ፤ ጠዉ እኮጎሬ አን ሀሾምገ እሁዕነ አት ሀሶንትገ እሁን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ህከኒች ኤተሮን ሰሶንከ አሳበቤቹ ፈንቀል አሜተኖ ወክት ግሶኢሃ ለዕይ ጴጥሮሴ «ኢን ሜጡበ መቶ ሳኣት ጌሰ አታሉ ሆጌንታእንዶ? ");
INSERT INTO alw_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ፌተናን ኣጌነንተበእገ ጠረኝቴን ዱአ አዕዬ፤ መገን አያኑ ቅጥ ይዮኡ፤ ጠዉ እኮጎሬ ማሉ ላፈሃን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ህትን ኢስ ለንክ ወክት ቀዉንከ ቄዕር ኦሮዕይ «ኢ አነ! ኩ ኦርሸ ጠበትተ አን አጉዕናን ህገኖበኢሃ እኮጎሬ አት ይቶንትገ እሁን» ይ ዱአ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ህትን እስ ፈንቀል ኣሜተኖ ወክት እልሰ ግሰኛት ኬዕምታን ትርክም ይታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ህትን እሰንተ አጉር ኦሮዕይ ሰቅ ወክት ዎዕኔገን ይ ዱአ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ህከኒች ኤተሮን አሳበስቤቹ አሜች «ቴሱ ግሴን ፎሎጭቴንታእትንዶ? ሁኩዕን! መንች ቤቱ ጩበኛኖ አንጋን ህግሴን ኣሴኖ ወክቱ ኢልዮኡ። ");
INSERT INTO alw_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ኬዕዬ ኦሮዕኖ፤ ሁኩዕኑን ህግሽ ኣሰኖኤሁ ሆንጠኮኡ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ኢስ ጠወአንን ቶነ ለሞንከ አሳባች መቱ «ይሁደ» ዬኖሁ አሜቾ፤ እሲን ሜጡበ ቂስ አዎንሳኖችለከ ባድ ባልቃች ሶሄመ ልግቡ መኑ ሲፈለከ በርተ አፍ አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ኢሰ ህግሽ ኣሰኖ ይሁድን እሲን ሜጡበ አሜተኖ መኒሃ «አዕኑ አን ሱንቃንሲሃ እሱ አፌ» ይ መላተ ኩሎሰ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","እስን ህከ ወክት ኢስበ ሆንጠክ «አስተማርቾ! ወገሬቴ!» ይ ሱንቄስ። ");
INSERT INTO alw_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ኢስን «ኢ ጃለ! አሜቶንት ሰውትክ ዊንሽ» ዬስ፤ ህከኒች ኤተሮን መኑ ኢስበ ሆንጠክ አፎስ። ");
INSERT INTO alw_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ህከ ወክት ኢሲን ሜጡበ ዮሀኑኡች መቱስ ሲፋ ፉሽ ቂስ አዎንሳንች ካዲንች መጨተ ሙሮ። ");
INSERT INTO alw_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ኢስን «ብሰክ ኮቦን ዎር፤ ብሰ ኬሳሩ ጉዕሙንኩ ብሲን በኣአ። ");
INSERT INTO alw_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","አን አነኤ ኡጭያን እስ ቶነ ለሞ ጎጎት መላይካተ ሶሆተ አታልባሃ አጉደኖሄንዶ? ");
INSERT INTO alw_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ህካን እኮች ከ ጠወ ጉዕመንከ ቶጉ ሀስሰኖ የኖ መጻፋን ከተቤመ ላገት ሀት እክ ዊንቶተ አታልታአ?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ህከ ወክት ኢስ ህከኔ ሄዕዮ ኡመቲሃ «ሽፍጠ አፌነንተሀንገ ብሰለከ በርተ አፌን አፎኖኤተ አሜቴንንዶ? ጉዕመ ወክት መገን ምኔን አፉዕል ተማርሰን አፌንታኤበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ጠዉ እኮጎሬ ሁኩን ጉዕሙንኩ እኮሁ ነብያኖ መጻፋን የመሞ ጠዉ ዊሞታት» ዬእ፤ ህከ ወክት አሳበስ ጉዕሙንኩ ጌኝአት ሁንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ህከኒች ኤተሮን ኢሰ አፎ መኑ ሕግ አስተማረትለከ ባድ ባልቁ ጭምይታቤቹ ኣእት ሎረ ቂስች ቀያፍበ መስቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ጠዉ እኮጎሬ ጴጥሮስ ሎረ ቂስች ግቤ ኣዝ ኢለ ቄዕራሻን አዎነኖት እቅ፤ ጠወስ መጨረሸ ኢለ ለኦተ ግቤ ኣዜን ካዲማንን ሜጡበ አፉዕሌእ። ");
INSERT INTO alw_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ቂስ አዎንሳኑትለከ አይሁድ ኦገት ዳኛኑት ጉዕሙንኩ ኢሰ ሽሲሶተ ክዝብ ጠወ አሌስ ሀሳኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ሄንከሃ ክዝብ ምስክሩ ሆንጠሁን ቤሉ ሬሁተ ፈረድሲሰኖ ጠወሃ ደጎስበአ፤ ጠዉ እኮጎሬ መጨረሽ ለሙ ክዝብ ምስክሩ ሆንጠክ ");
INSERT INTO alw_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«ኩ መንቹ ‹አን ዱእ ምኒ ድጅ ሰሶ በሬን እጃራም› ይዮኡ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ሎሩ ቂስቹ ኬዕይ «ኩ መኑ አሌክ መሰከሮ ጠዊሃ ፈንቀሽታንትሁ መቱርቹሁ ዮሄበእንዶ?» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ጠዉ እኮጎሬ ኢስ መቱርቹሃ ይዮበአ፤ ሎሩ ቂስቹ ኢሰ «መሲህ መገን ቤቱ እኮንትጎሬ ሄአኖ መገኖን መገኝዮንኬ ኩልኔ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ኢስን ሎረ ቂስቹ «አት ይቶንትጋንት፤ አን ኩሎንክዕኔ መንች ቤቱ መገን መኬ አዲን አፉዕልሃን ለኤነንተ፤ ህትን ሰሜ ጎማን አሜተን ለኤነንተ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ህከ ወክት ቂስ አዎንሳንቹ ኦድኑስ ፊል «መገኑ ቦሮሮኡ፤ ከኒች ኤተሮን ም ምስክሩ ሀስሰኖ? መገኑ ቦሮሩስ አዕኑ ሞጮጭቴንታአ። ");
INSERT INTO alw_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ቴሱ መ አጉደኖህዕኔት?» ዬእ፤ እሰን «ሬሁት ገበኣስ» ይት ፈንቀሽቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ህከ ወክት ኢስ አሌን አንጀ ቱይቶኡ፤ ጡንጤንን ዎቀርቶኡ፤ ህትን መጨለ ዎቀርተን፥ ");
INSERT INTO alw_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«መሲህ! ህንዴ አይ ዎቀሮሄ ጎሬ ራገ ጠወእ» ይታስ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ጴጥሮስ ሎረ ቂስች ምኒች አብሌን ግቤ ኣዜን አፉዕሌሀኔን መት ገረድቹት እስበ ሆንጠክ «አት ገሊለ ኢስን ሜጡበ ሄኦንት» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ጠዉ እኮጎሬ እስ «አት ይታንቲሁ አዬት ጎሬ ደጋምበአ» ይ ጉዕምሰ ብሬንን ለገዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ጴጥሮስ ፉሎተ ብትምቤቹ ሆንጠኮሀኔን ገረድቹት ለእ ህከኔ ሄዕዮ መኒሃ «ኩ መንቹ ናዝሬት ኢስን ሜጡበ ሄዕዮሃን» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ጴጥሮስ ለንኪሃ ጤሌዕለን «አት ይታንት መንቹ ደጋምበአ» ይ ለገዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ቀዎ ወክቲች ኤተሮን ህከኔ ኡርቶ መኑ እስበ ሆንጠክ «ጠወኣንትጉ ለሊሰኖት፤ ሀንቅንከ አት እሳች መቶሃስ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ጴጥሮስን «አን ከ መንቹ ደጋምበአ» የን ገዉስ ቦሮዕሩሃ ጤሌዕሉሃ ጀመሮ፤ ወክትንከስ ሀንጠቦ ዎጆ። ");
INSERT INTO alw_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ጴጥሮስን ኢስ «ሀንጠቦ ዎዱዕነ ሰሶረ ለገኣንቴኤ» ዬ ላገተ ሰውይ አብል ፉል ቡብ ኦዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ኡለት ሶዞ ወክት ቂስ አዎንሳኑትለከ ኡመት ባልቁ ጉዕሙንኩ ኢሰ ሽቶተ አማዕለንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ሀከኒች ኤተሮን ኢሰ ኡሱርት መስት ሮም ባድ ገሻንች ጵላጦሴቤቹ ህግስ ኣቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ህከ ወክት ኢሰ ህግሽ ኣሴ ይሁድ ኢስ አሌን ሬሆ ፍርደ ፈረዴማሃ ለዕዮ ወክት አበ ሰጭ ሰጁ ጠገር ብረ ቂስ አዎንሳኖተለከ ባድ ባልቃተ ፈንቀሽ ኤብ ኣሴእ። ");
INSERT INTO alw_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","«ፈየ መንቹ ሬሆተ ህግሽ ኣሴምቤቺሃ አን ቤሾም» ዬእ፤ ጠዉ እኮጎሬ «ኔሳሃ ም ኦርሾኔ፤ አት ገዉክ ሹል» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ይሁድን ሰጁ ብረንከ መገን ምኔን ብንአዕይ ፉል ለንገቅ ሬዮ። ");
INSERT INTO alw_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","እኮጎሬ ቂስ አዎንሳኑት ብረስ ኬስ «ኩ ብሩ ቄግ ብረ እኮቤቺሃ ዱእ ምኒ ብራን ሜጡበ አኡ ሀስሰኖበአ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ህካን አማዕለንቶች ኤተሮን ኮሀ እክ አሜች ሬዮ መነ ሞጎተ ፉግቺች ኡለተ ህዕርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ህካን እኮቤቺሃ ህተ ኡለተ ከበሬ ኢለ «ቄግ ኡለተ» ዬነን ገኤኖ። ");
INSERT INTO alw_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ህከን ሃሌን «እስራኤል ኦሱት ‹ሄንከ ፉሸኖ› ይት ገመቶ ዋገ ሰጁ ጠገር ብረ ኣእቶኡ፤ ");
INSERT INTO alw_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ቀርቹ አዘዦኤገን ፉግቺች ኡለተ ህዕሬመ» የመም ነብዬቾ ኤርምያሴን ጠወአሞ ራጉ ዊሞ። ");
INSERT INTO alw_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ህከ ወክት ኢሰ ገሻንች ቤቹ ኤቤመ፤ ገሻንቹንኩ «አት አይሁድየ ዎመንዶ?» ይ ጠዕሜእ፤ ኢስን «አት ይቶንትጋት» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ጠዉ እኮጎሬ ቂስ አዎንሳኑትለከ ባድ ባልቁ ኦዶስ ወክት መቱ ጠወሃ ፈንቀሽዮበአ። ");
INSERT INTO alw_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ህከኒች ኤተሮን ጵላጦስ «ኩ መኑ ኬንከ ኦዳሄ ጠወ ሞጮጭታንትበእንዶ?» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","እኮጎሬ ኢስ ገሻንቹ አበ አጀብሲጮተ ኢለ መቱ መስለሃ ፈንቀሽዮበአ። ");
INSERT INTO alw_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ሻሽግ ከበጃት ወክት መኑ መጠሮ መቱ መንቹ ኡሱሮች ሂር ገፈረኖ ሮሸት ገሻንቾ ጵላጦሴሃ ሄኦስ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ህከ ወክት «ባርባኔ» ዬኖ ለልዮኢሁ ኡሱር ምኔን ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","መኑ ጭምዬ ወክት ጵላጦስ «አዬ ሂሮህዕኔተ ሀሴነን? ባርባኔይትንዶ መሲህ የመሞሃ ኢሰ?» ይ ጠዕሜሰ። ");
INSERT INTO alw_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ጵላጦስ ህካን ዮተ አታሎሁ ኢሰ ጢቄን ህግስ ኣቶገ ደገኖቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ጵላጦስ ፍርድ ቦርጭማን አፉዕሌሀኔን ጫስ «ከን ነጠ መንች አሌን መቱርቹሃ አቶት፤ አን እስ መሳን ሀንከዕርተ ሀቄንተኤ አበ ጨነቀመን ገሎምንተገ» ይት ሶኮኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ህከ ወክት ቂስ አዎንሳኑትለከ ባድ ባልቀት መኑ ጵላጦሴ ባርባኔ ሂር ኢሰ ሾን ይተን ኡጭታገ አቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ገሻንቹንኩ «ከን ለሞንከ መንቺች ሀካንስ ሂሮህዕኔተ ሀሴነን?» ይ ጠዕሜሰ፤ እሰን «ባርባኔ ሂርኔ» ይት ፈንቀሽቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ጵላጦስን «መሲህ የመሞ ኢሰ መ አኡ?» ዬሰ፤ ጉዕሙንኩሰ «ሰቀሎን» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ገሻንቹንኩ «ሚሃት? እስ አዕዮ ሂሉ ጠዉ መርቹሃን?» ዬእ፤ እሰን «ሰቀለሙን» ይት በትስ ጨንጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ጵላጦስን ኩ ጠዉ ብተተ ኬስ ቤሉ መቱርቹሃ ደግለለኖበእገ ለዕዮ ወክት ጉዕማንከ ኡመት ብሬን ዋሃ ኤብሲሽ አንገስ ኣዕለን «አን ከን መንች ቄጊች ነጠሃን፤ አዕኑን ሹዕልዬ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ኡመቱ ጉዕሙንኩ «ቄጉስ ኒለከ እለኔ አሌን እሁን» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ህከ ወክት ጵላጦስ ባርባኔ ሂር ገፈሮ፤ እኮጎሬ ኢሰ ኦልሲሾች ኤተሮን ሰቀሎኖተ ህግሽ ኣሴእ። ");
INSERT INTO alw_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ሮም ዎታደሩ ኢሰ ጵላጦሴ ግብተ መስቶኡ፤ ህትን ዎታደረ ጉዕመንከ ኢስ መዴን ጭምአቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ኦድኑስ ኣእት ብሸ ኦድኑተ ኦድሶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ኡት አክሊለ መክስ ቡዕለስ ዎርት መኬስ አንጋን ሾምቦቁተ አፍሲሶስች ኤተሮን ብሬስ ሰገደን «አይሁድ ዎመ! ወገሬቱ ኬሳሃ እሁን!» ይተን ቀለዳሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","አሌስ አንጀ ቱይተን አንጋችስ ሾምቦቁተ ኣእት ቡዕለስ ዎቀርታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ቀለዶሲች ኤተሮን ብሸ ኦድኑተ ፉሽት ገይስ ኦድኑተ ኦድስ ሰቀልቶተ ኣእት መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ገሻንች ግቤች ፉልተን «ስሞኔ» ዬኖ ቀሬን ባድ መንቺን ደቀንት ኢስ መስቀለ ግዳን እጅሲሶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","እሰን «ጎልጎተ» ዬኖቤቹ ኢልቶኡ፤ «ጎልጎተ» ዩ «ቡዕል ቁሌ ቤቹ» ዩሃን። ");
INSERT INTO alw_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ህከኔን ደምብቹ ልቃለቀሞ ዎይን ጠጀ አጎተ ኢሲሃ ኣቶኡ፤ እኮጎሬ እስ ቀመሽ ለዕይ አጉ ግቦ። ");
INSERT INTO alw_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ኢሰ ሰቀልቶች ኤተሮን ኦድኑስ እጠ ኡጅት ቤቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","እሰን ህከኔ አፉዕልት አገርታሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","«ኩን አይሁድየ ዎመ ኢሳት» ዬኖ ከሰሶ ጠወ ከተብ ቡዕልስ አሌ አዲን አፉሽቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ኢሲን ሜጡበ ለሙ ወንበድት መቱስ መኬ አዲን መቱስ ጉረ አዲን ሰቀለንቶ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","መዲንከስ ህጋ መኑ ህንቅ ቡዕለሰ ሌንቀቅሰን ");
INSERT INTO alw_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","«አት ዱእ ምኒ ድጅት ሰቅ በር እጃርታንቲሁ ህንዴ ገዉክ ጡምስ፤ መገን ቤቱ እኮንትጎሬ ህንዴ መስቀሊች ድር» ይተን ቀለዳሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ህትን ቂስ አዎንሳኑት፥ ሕግ አስተማረትለከ ባድ ባልቀት ቀለደን ");
INSERT INTO alw_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«ዎሉ መነ ፌሾ፤ ጠዉ እኮጎሬ ገዉስ ጡምሶተ አታሎበአ፤ እስ እስራኤል ዎመ እኮጎሬ ህንዴ መስቀሊች ድሩን፤ ነኡሁ አመዕንናም። ");
INSERT INTO alw_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","‹አን መገንየ ቤቱ› ይ መገኖን አመዕንዮኡ፤ ህካን እኮቤቺሃ መገኑ እሱ እትዮስጎሬ ህንዴ ቴሱ ፌሱንስ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ህትን እሲን ሜጡበ ሰቀለንቶ ዎንበድት ህትን ይተን ቦሮርታሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ሌሆ ሰኣቲች ኬሽ ሆንሱ ሰኣት ኢለ ኡለት ቱንስቹ እኮኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ሆንሶ ሰኣት ጌሳን ኢስ ሎረ ላጋን «ኤሎሄ! ኤሎሄ! ላማ ሰበቅታኒ?» ይ ያሮ፤ ህት ዩ «ኢ መገኖ! ኢ መገኖ! ሚሃ አጉርቴኤ?» ዩሃን። ");
INSERT INTO alw_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ህከኔ ኡርቶ መኒች መት-መቱ መኑ ህካን ሞጮጭት «ኩ መንቹ እልያሴ ገአኖት» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ህከ ወክት እሳች መቱ ደጉጅ ሆለጮ ወይነ ጥጢን ጬፍ ሾምቦቆን አዕይ ኢስ አጎተ አፌስበ ሽቅ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ዎሉሰ «አገር ህንዴ እልያስ አሜች ፌሰኖስ ጎሬ ለዕናም» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ኢስ ለንኪሃ ሎረ ላጋን ያር ነብሳስ ህግሽ ኣሴእ። ");
INSERT INTO alw_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","መገን ምኔን ሰቀሌመ መጋረጁ አሊች ኡለተ ኢለ ለሙ አደ እክ ፊልተዕዮ፤ ኡለት ሌንቄቅቶኡ፤ ክኑንኩ ጦጭ ፊልተዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ህትን ሎዱ ፈንተዕያን ዎዕነ ሬቶ ጠሊለ መኒች ልግቡሰ ሬሆች ኬኦኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","እሰን ሎዲች ፉልት ኢስ ሬሆች ኬዕዮች ኤተሮን ዬሩሳሌም ከተመ ኣግ ልግብየ መኒሃ ለልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ጥቤ ሀለቁለከ እሲን ሜጡበ ኢሰ አገርተን ሄኦ መኑ ኡለት ሌንቄቁለከ እኮስ ጠወ ጉዕመንከ ለኦ ወክት አበ ዋጅት «ሀንቅንከ ኩን መገንያ ቤቱ እቅ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ህከኔን ልግቡ ሜንቱ ቄዕራሻን ኡርት ለኣኢት እቅ፤ እሰን ገሊላች ጀመርት ኢሰ ሀዕልተን አዎንተን ሄኦእረ። ");
INSERT INTO alw_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ህከን ሜንቲን ሜጡበ መግደል ከተም መርየመ፥ ያቁብለከ ዩሱፍ አመት መርየመለከ ዘብዶሴ ኦሶ አመት ሄኦ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ኡለት ሀዎርቶ ወክት አርማትይ ከተም «ዩሱፈ» ዬኖ መቱ ቀባጣሙ መንቹ ህከ ቤቹ አሜቾ፤ እስን ኢስየ አሳቤቹ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ሁኩ መንቹ ኢስ ጀናዘተ ኣሶስተ ጵላጦሴ ኡጬሃን ኣሶኖስተ አዘዦ። ");
INSERT INTO alw_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ዩሱፍ ኢስ ጀናዘተ ኣእ ነጠ ጥጥ ጋቤን ከፈኝ ");
INSERT INTO alw_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ገይሃስ ክኒች መክሾ ሃዕሮ ሎድ ኣዜን ኢስ ጀናዘተ አፉሽ ሎድስ አፎን ሎረ ክኑ ኮሎንኮዕልሽ ጡፎች ኤተሮን ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ህከኔን መግደል ከተም መርየመለከ ዎልት መርየመ ሎድ ብሬን አፉዕልቶ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ህከ ለንክ ፎሎጭ በር ቂስ አዎንሳኑትለከ ፈርሳውት ሜጡበ ጵላጦሴቤቹ መርት ");
INSERT INTO alw_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","«ቀርቾ! ሁኩ ሉሲሰኖሁ ሬሁዕናን ሄጭ ‹ሰሶ በሬች ኤተሮን ሬሆች ኬኣም› ዬ ጠዉ ቃገሞኔ። ");
INSERT INTO alw_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ህካን እኮቤቺሃ ኢስ አሳበት መርት ሞግታበእገ ሬሆች ኬዕዮኡ ይት መኒሃ ኩልታበእገ ሎደስ ሰቅ በር ኢለ አገርታገ አዘዝ፤ ህካን እህባች ወኔስ ሉጨንሺች ኤተርስ ሉጨንሹ ባሾሃ እሀኖ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ጵላጦስ «አገርታ ዎታደሩ ዮህዕኔ፤ መርቴን ደጌነንተ ሃሌን አገርሲሼ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ህካን እኮቤቺሃ እሰ ሎድበ መርት ሎድ አፎን ዮ ክኖን ማተቢን አሸግ ዎታደሪን አገርሲሶኡ። ");
INSERT INTO alw_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","አበ በሩ ህጎች ኤተሮን ሳምንትስ ዎኔ በሬን ኡለት ሶዘን መግደል ከተም መርየመለከ ዎልት መርየመ ሎደ ለኦተ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ህከ ወክት አቡ ኡለ ሌንቄቁ እኮ፤ ቀርች መላይኬቹ ሰሜች አሜች ሎድ ኡሩተ ጡፌመ ክኑ ፈኝ ጎንብሽ አሌስ አፉዕሌእ። ");
INSERT INTO alw_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","መላይኬችስ ክልቀቱ ጉገኛገ ዮእሃ እቅ፤ ኦድኑስ በረድገ ዋጁተ እቅ። ");
INSERT INTO alw_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","አገርታሩንኩ መላይኬቹ ዋጅት ሁጦኡ፤ ሬዮ መንገን እኮኡ። ");
INSERT INTO alw_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ጠዉ እኮጎሬ መላይኬቹ ሜንቱ «አዕኑ ሰቀሌመ ኢሰ ሀሴነንተገ ደጋምቤቺሃ ዋጅቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","እስ ወዕና ዬገን ሬሆች ኬዕዮኡ፤ ከንቤቾን ዮበአ፤ ጀናዘስ አፉሼመ ቤቹ አሜ ለዕዬ። ");
INSERT INTO alw_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ቴሱ ደዕልቴን መርቴን አሳባተስ ‹ኢስ ሬሆች ኬዕዮኡ፤ ክዕኔተ ሄጭ ገሊለተ ኦሮአኖ፤ ህከኔ እሱ ለኤነንተ› ይቴን ኩሌሰ፤ ሁኩዕኑን ኩሎንክዕኔ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ህከኒች ኤተሮን እሰ ዋጅተንለከ አበ ሙንዲኖን አሳባተስ ኩልቶተ ሎድቢች ደዕልት ደጉድ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ኢስ እሳን ደቀም «ወገሬቱ ክዕኔሃ እሁን!» ዬሰ፤ እሰን እስበ ሆንጠክ ሎከስ ኡብ ሰገዶኡ። ");
INSERT INTO alw_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ህከ ወክት ኢስ «ዋጅቶኖቼ! መርቴን አመኤ ኦሱት ገሊለተ ህጋገ ኩሌ፤ ኤሳሃ ህከኔ ለኣኤ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ሜንቱንኩ መርተን ሄኦገን ሁኩዕኑን! ዘበኛኖች መት-መቱ ዎታደሩ ከተመ መርት እኮ ጠወ ጉዕመንከ ቂስ አዎንሳኖተ ኩልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ቂስ አዎንሳኑት ባድ ባልቂን ጭምይት አማዕለንት ዎታደሪሃ ልግብ ብረ ኣት ");
INSERT INTO alw_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","«መኒሃ ‹ነኡ ግንሶምአኔን ሀንከዕሬን አዎናኑስ አሜት ሞግት መስቶኡ› ይቴን ኩሌ። ");
INSERT INTO alw_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ከ ጠወ ባድ ገሻንቹ ሞጮጬ ጎሬ ክዕኔ አሌን ኦርሸት አሜታበእገ ነኡ ጠወስ ብዝ አዕን ኩልናንስ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ህካን እኮቤቺሃ ዎታደሩ ብረስ ቶግ ይቶሰገን አቶኡ፤ ሁኩ ጠዉ ከበሬ ኢለ አይሁድ በላን ጠወአመኖት። ");
INSERT INTO alw_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ቶነ መቱንኩ አሳበት ኢስ መርቶተ አዘዦገን ገሊለ ባዶን ዮ ቆተቤቹ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","እሰን ለኦስ ወክት ሰገዶስ፤ እኮጎሬ መት-መቱሰ ሸክቶኡ። ");
INSERT INTO alw_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ኢስን እሰበ ሆንጠክ «ዎልቀት ጉዕሙንኩ ሰማንለከ ኡላን ኤሳሃ ኣሰንቶኤ። ");
INSERT INTO alw_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ቴሱ መንቤቹ ጉዕመንከ መርቴን አንኤ ሱዕሚኒ፥ ቤት ሱዕሚኒለከ ጠሊለ አያን ሱዕሚኒ ጠመቄነን አዎናኑኤ አዕዬ። ");
INSERT INTO alw_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","አዘዦንክዕኔሃ ጉዕመንከ አገርታገ ተማርስዬ፤ አን ዘማን መጨረሸ ኢለ ጉዕመንከ ወክት ክዕኔን ሜጡበ እሃም» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ኩን መገን ቤቲ መሲህ ኢስ እንጂሊሃ ዎኔሃን። ");
INSERT INTO alw_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ነብዬቾ እስያሴን «መገኑ ‹አን ወዕቃክ ቅጥአአኖ ሶቀማንቹኤ ብሬንከክ ሄጭ ሶሃም› ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ሁኩንን፦ ‹ቀርች ወቃሃ ቅጥአዕዬ፤ ጭርቴን ጌጥ አዕዬ› የን ኡለ ኡድማን ላገስ ጎት አዕይ ያረኖ መንች ላገተ» የመም ከተበሞጋት። ");
INSERT INTO alw_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ህካን እኮቤቺሃ ጠመቃንቹ ያህይ «ጩብክዕኔ ፈቁን የመሞተ ቶበቴን ጠመቀሜ» የን አዋጀን ኡለ ኡድመ አሜቾ። ");
INSERT INTO alw_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ይሁድ ባዶንለከ ዬሩሳሌም ከተማን ሄዕዮ መኑ ጉዕሙንኩ አሜት ጩብሰ ቶበተን ዮርዳኖስ ዛዘኖ ዋን ጠመቀኖሳት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ህትን ያህይ ጋሜል ኦርዛች ደዴማ ኦድኑተ ኦደዕይ ረመዞንከስ ጠፍራ ቆዕረኖ እቅ፤ እስን ከንቸፈሩሃ፥ ኡድም ዳመ መለቡሃ እተኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","እስን «አን ሙግይ ጫዕመስ ወደሩ ሂሮተ በቀዕባሁ ኢች በተአኖሁ ኢች ኤተሪን አሜተኖ፤ ");
INSERT INTO alw_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ህትን አን ዊን ጠመቆንክዕኔ፤ ጠዉ እኮጎሬ እስ ጠሊለ አያኒን ጠመቀኖህዕኔ» የን አዋጀኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ህከ ወክት ኢስ ገሊል ባዶን ሄዕዮ ናዝሬት ከተሚች አሜቻን ያህይ ዮርዳኖስ ዛዘኖ ዋን ጠመቆስ። ");
INSERT INTO alw_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ወክትንከስ ኢስ ዊች ፉሎ ወክት ሰሞ ፊልተዕይ ፈንተዕያን ጠሊሉ አያኑ ሀንደዕሬገ እክ እስ አሌን ድረንስ ለዕዮ። ");
INSERT INTO alw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ህከ ወክት «ኢታንኬ ቤቱኤ አቴት ኪን ተሽ የኖኤ» ይታ ላገት ሰሜች አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ወክትንከስ መገን አያኑ ኢሰ ኡለ ኡድመ ኦሮአኖገ አዕዮስ። ");
INSERT INTO alw_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ህከን ኡለ ኡድማን ሸይጣኑ ኢሰ ፌተኖተ አጰመን ሸይሉ በር ኢስ አብል ቡሳዊን ሜጡበ ዱንኬእ፤ ሰሜ መላይከንት ካደንቶስ። ");
INSERT INTO alw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ያህይ ኡሱሬማች ኤተሮን ኢስ መገን ተሽት ላገተ አዋጀን ገሊለተ አሜቾ። ");
INSERT INTO alw_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","እስን «ዘማኑ ጎፎኡ፤ መገን ዎምነቱ ሆንጠኮቤቺሃ ጩብችክዕኔ ፈንቀልቴን ተሽት ላጋን አመዕንዬ» የኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ኢስን «ገሊለ» ዬኖ ባር መዴን ህገን ስሞንለከ አመስቤቱ እንድርያሴን ቁርጩሜተ ዎሻዳእራ እኮቤቺሃ ዎሻደሳ ባር አሌን ኡጅተን ለዕዮሰ። ");
INSERT INTO alw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","እሰንተ ኢስ «ኤሳሃ አዎኜ፤ አዕኑ ቁርጩሜተ ዎሻዴነንተገን መነ መገን አደ ኤቤነንተረ ኣሳንክዕኔ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ወክትንከስ ወሻደሰ ኡጅት አዎንቶስ። ");
INSERT INTO alw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ኢስ ህከንቤቺች ቀውተ ህጎገን ዘብዴዎሴ ኦሱት ያቁቢለከ ያህይ ጀልብሰ አሌን አፉዕልት ወሻደሰ መክሰን ለዕዮ። ");
INSERT INTO alw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ኢስን ወክትንከስ ገኤሰ፤ እሰን ያቁብ ያህይ አነሰ ዘብድዎሴለከ አኒሃሰ ሆጉተ አአኖ መነሃ ጀልብ ኣዜን አጉርት ኢሰ አዎንቶስ። ");
INSERT INTO alw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ኢስ አሳባንተስን «ቅፍርናሆመ» ዬኖ ከተመ አሜች አበ በሬን ጭምት ምኒ ኣግ ተማርሱ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ኢስ ሕገ ተማርስታሀኑኡገ እሁዕነ ሎሩ ሹምነቱ ዮስ መንችገ ተማርሰኖሃ ለእ ህከኔ ሄዕዮ መኑ ሞጮጭት ትምርቴንከስ አበ አጀብሲጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","ጭምትሰ ምናንን መቱ ዶሮረኖ አያኑ አፎስ መንቹ ሄዕዮ እቅ፤ እስን «ናዝሬት ኢሰ! ኔሳለከ ኬሳሃ ም ደቀንሹ ዮኔ? ቤሶኔተ አሜትንዶ? አት አዬት ጎሬ አን ደጋንኬ፤ አት መገንያ ጠሊለ» የን ሎረ ላጋን ያሮ። ");
INSERT INTO alw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ጠዉ እኮጎሬ ኢስን «ጨለይት እሲች ፉል» ይ ሻቆስ። ");
INSERT INTO alw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ሁኩ ዶሮረኖ አያኑ ህከ መንቹ መቱ ጌሰ ከጣቀንሴሲች ኤተሮን ሎረ ላጋን ያረን እሲችን ፉሎ። ");
INSERT INTO alw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ህከኔ ሄዕዮ መኑ ጉዕሙንኩ «ኩን መርቾሃን? ዶሮርታ ዱራከተ ሹምነቲንከስ ተማርስሃን አዘዘንታስ» ይተን አጀብሲጭት መቱ መቱሰ ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ህከ ወክትንከ ዱዱቡስ ገሊላ ባዶን ጉዕማንን ሞጮጨሞ። ");
INSERT INTO alw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ህከኒች ኤተሮን ኢስ ያቁብንለከ ያህይን ሜጡበ ጭምት ምኒች ፉል ሲሞኔለከ እንድርያሴ ምኒ ኣጎ። ");
INSERT INTO alw_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ህከኔን ስሞኔ በሉት ፋረ ደሙሜን አበ ጥዝ ኦሰኦ እቅ፤ እሴ ጥዞገ ወክትንከስ ኢሲሃ ኩለሞስ። ");
INSERT INTO alw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ኢስን አንገሴ አፍ ኬሻንሴ ፋረ ደሙሜ ጥዘናችሴ ፈይቶኡ፤ እሴን ኬእ እሰንተ ካደንቶሰ። ");
INSERT INTO alw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ህከ በር አሩ ኣገን ሀዎርዮ ወክቴን መኑ ጥዘናመተለከ ሩሃንዪን አፈንቶረ ጉዕመንከ ኢስበ ኤባኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ከተምስ መኑ ጉዕሙንኩ ህከን ኡሮን ጭምይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ኢስን ልግብ መነ አደደ ጥዘናች ፈይሾ፤ ልግብ ሩሃንየንከ ፉሼእ፤ ልግቡ ሩሃንዩንኩ ኢስ አዬት ጎር ደጎስቤቺሃ ኢስ ጠወኦተ ፈቀጆሰበ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ኢስ ሶዞተ ሆንጠኮ ወክቴን ኬዕይ መኑ ዮበእቤቹ መር ህከን ቤቾን ዱአ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ጠዉ እኮጎሬ ስሞንለከ እሲን ሜጡበ ሄኦእሩ ኢሰ ሀሶተ ፉልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","እሰን ደጎስ ወክት «መኑ ጉዕሙንኩ ኬሳሃ ሀሰኖሄት» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ኢስን «ወዕናንከ አሜቾሚሁ ተማርሶተ እኮቤቺሃ ግደኖ ዮ ቀእተ መርን ህከኔ ተማርስኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ህካን እኮቤቺሃ ጭምትሰ ምናን ዱዱብሰንለከ ሩሃንየ ፉሸን ገሊለ ባዶን ዮ ጉዕመ ቤቹንከ ፈንቀላመኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ጎግ አል ጥዘነተ ጥዦ መንቹ ኢስበ አሜች ሎከስ አሌን ኡብ «ኢትቶንቴኤ ጎሬ ፈይሶኤተ አታልታንት» ይ ኡጬስ። ");
INSERT INTO alw_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ኢስን አበ መረርስጭ አንገስ አሌስ አዕይ «ፈቀጆም ፈይ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ወክትንከስ ጎግ አል ጥዘነት ገፈርታንስ ፈዬእ። ");
INSERT INTO alw_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","ኢስን ህከ መንቹ «ከ ጠወሃ አዬሃ ጠወኣንትበእገ አገዕር፤ ጠዉ እኮጎሬ ሎረ ቂስችበ መርት ጅስመክ ለሊስ፤ መሰንትስ አት ነጠ እክ ፈይቶንትገ መኑ ደጎተ ሙስ አዘዦገን መገኒሃ ክትም ሆንጠህስ» ይ አዘዦስ። ");
INSERT INTO alw_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ጠዉ እኮጎሬ ሁኩ መንቹ ጠወስ ወክትንከስ መኒሃ ጠወኡ ጀመሮ፤ ህከን መንች መሳን ኢስ ከተማን ለል ፈንቀላሞተ አታሉ ሆጎቤቺሃ ከተሚች አብሌን መኑ ዮበእቤቾን ሄአኖ እቅ፤ ህካን እኮቤቺሃ መኑ እስዮቤቹ ጉዕመ ቤቺችን አሜተኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ቀዎ በሬች ኤተሮን ኢስ ቅፍርናሆም ከተመ ፈንቀል አሜቾ፤ ህከን ቤቾን «ኢስ ምኔን ዮኡ» ዬኖ ዱዱቡ ሞጮጨሞ። ");
INSERT INTO alw_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ህከ ወክት ልግቡ መኑ ኢስ ዮ ምኒ ኡሩት ሩክታኢሃ ኢለ ጭምዬእ፤ ህከኔን ኢስ መገን ላገተ ተማርሰኖሳት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ህከ ወክት መቱ ናፈ መንቹ ሾሉ መኑ እጅት ኤቦኡ። ");
INSERT INTO alw_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ጠዉ እኮጎሬ መኑ በተዕዮቤቺሃ ህከ ናፈ መንቹ ኢስበ ሆንጠህሶተ ቤቹ ሩኬሰቤቺሃ ኢስ ዮ አዲን ምኒ እልተ ፈንት ናፈ ኦሰዕዮ ዴስንከስን ድርሶኡ። ");
INSERT INTO alw_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ኢስን አመዕነቱሰ ለዕይ ናፈ መንቹ «ኢ ጩሌ ጩቡክ ፈቁን የማሞሄ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","ህከኔ አፉዕልቶ ሕግ አስተማራች መት-መቱሰ ቀልቤንከሰ «ኩ መንቹ ሚሃት ህትኔ ቦሮር ላገተ መገን አሌን ጠወአኖሁ? ሜጡወ መገን ቤሉ ጩብ አጉሮተ አታለኖሁ አዬት?» ይት ሰውይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ወክትንከስ ኢስ ቀልብሰ ጠወ አያኒንከስ ደግ «ሚሃት ቀልቤንከክዕኔ ካን ሰውይቴነንታሁ? ");
INSERT INTO alw_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ናፈ መንቹ ‹ጩቡክ አጉረሞሄ› ዪቺለከ ‹ኬእ ዴሰክ እጅት ኦሮእ› ዪቺ ሀኩንስ ቆሀኖ? ");
INSERT INTO alw_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ጠው እኮጎሬ መንች ቤቱ ኡለ አሌን ጩብ ፈቁን ዮተ ሹምነቱ ዮሲሃ እሁስ ደጌ» ይ ናፈ መንቹ ");
INSERT INTO alw_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«ኬእ ዴሰክ እጅት ምንክ ኦሮእ ያንኬ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ናፉንኩ ወክትንከስ ዴሰ እጅ መን ብሬን ፉሎ፤ ህካን እኮቤቺሃ መኑ ጉዕሙንኩ አጀብሲጭ «ህትኔ ጠወ ሆሮን ለዕኖምበአ» ይት መገኑ ገለትጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ኢስ ፈንቀል ገሊለ ባር መድ ኦሮዕዮ፤ ልግቡ መኑ እስበ አሜታን ተማርሴሰ። ");
INSERT INTO alw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ህከን አዲን ህገን እሊፍዮሴ ቤቱ ሌው ቀረጠ ሙረን ለዕይ «አዎኔኤ» ዬስ፤ እስን ኬዕይ አዎኞስ። ");
INSERT INTO alw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ህከ ወክት ኢሰ አዎኞ መኒች ልግቡሰ ቀረጠ ሙርታሀኑኡንለከ ጩበኛኖን ጉዕሙንኩ ኢሲንለከ አሳባን ሜጡበ እክ ሌዌ ምኔን እቸተ እታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ፈሪሳዌ አዲች ሕግ አስተማረት ኢስ ቀረጠ ሙርታሀኑኡንለከ ጩበኛኖን ሜጡበ እተን ለእ «ጩበኛኖንለከ ቀረጠ ሙርታሀኑኡን እተኖሁ ሚሃት» ይት አሳበስ ጠዕምቶሰ። ");
INSERT INTO alw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ኢስን ህካን ሞጮጭ «ሀኪሙ ሀስሰኖሁ ጥዘናማታት ቤሉ ፈየ መኒሃበአ፤ አን አሜቾሚሁ ጠሊላኑተ እሁዕነ ጩበኛኑተ ገኦታት» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ጠመቃንቹ ያህይ አዎንታእሩለከ ፈርሳውት ሶመንታ እቅ፤ ህካን እኮቤቺሃ መቱ-መቱ መኑ ኢስበ አሜት «ጠመቃንቾ ያህይለከ ፈርሳዊተ አዎንታእሩ ሶመንታ፤ ጠዉ እኮጎሬ ኪ አሳበት ሶመንታበኢሁ ሚሃት?» ይት ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ህከ ወክት ኢስን ኢዜቹ እሳን ሜጡበ ሄአን ጃለስ ሶመንቶተ ሀስሰኖሰንዶ? ሀስሰኖሰበአ፤ እዜቹ እሳን ሜጡበ ሄዕዮገ ሶመንታበአ። ");
INSERT INTO alw_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ጠዉ እኮጎሬ «እዜቹ እሳች ኣኤኖ በሩ አሜተኖ፤ እሰን ህከ ወክት ሶመንታአ። ");
INSERT INTO alw_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«ኑባጵቶ ኦድኖን ሃዕሮ ቃፈተ ቃፈኖሁ ዮበአ፤ ጠዉ እኮጎሬ ህካን አዕዮ ጎሬ ሃዕሮ ቃፈት ኑባጵቶ ኦድኑተ ሁዙዝ ፍልታአ፤ ሁኩ ፍልተዕዮ ቤቹንኩ ወዕኔች ባሰ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ህትን ኑባቾ ሆቆማዶን ሃዕሮ ቃርቡተ ፉሸኖሁ ዮበአ፤ ህካን አኤመ ጎሬ ቃርቡት ሆቆማዱ ፊልታአ፤ ህትን ቃርቡንት ዱንተኣአ፤ ሆቆማዱንኩ ፊልተአኖ፤ ጠዉ እኮጎሬ ሃዕሮ ቃርቡተ ሃዕሮ ሆቆማዶን ዎሩ ሀሲሰኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","አበ በሬን ኢሰ አዎንታእሩ አለስ ዉጠ በሊን ህገን አዎንታእሩ አለስ ሀማሙተ ተንቅሱ ጃመርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ህከ ወክት ፈርሳውት ኢሰ «ከ ለእ! ኬሳሃ አዎንታእሩ አበ በሬን አኡ ፈቀዴንባሃ ሚሃት አታኢሁ?» ይት ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","ኢስን « ‹ኣብያተሬ› ዬኖ መንቹ ሎረ ቂስቹ እክ ሄዕዮ ወክት ደዉድለከ ደዉዴን ሜጡበ ሄኦ መኑ ጎሩ አፋንሰ ኦርጨቀንቶ ወክት ደዉድ ዱእ ምኒ ኣግ ሎረ ቂስ ቤሉ ዎሉ መኑ እቱ ፈቀደሞበእ መገን የመንቶ ዳቡተ እቾገለከ እሲን ሜጡበ ዮ መኒሃ ኣሴጋ አነበቤንታበእንዶ? ");
INSERT INTO alw_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ህትን አበ በሩ መኒሃ ከለቀሞ ቤሉ መኑ አበ በሬተ ከለቀሞበአ። ");
INSERT INTO alw_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ህካን እኮቤቺሃ መንች ቤቱ አበ በሬተ ቀርቾሃ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ለንኪሃ ኢስ ጭምት ምኒ ኣጎ፤ ህከኔን አንገተ ናፉ መንቹ ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ጠዉ እኮጎሬ ኢሰ ከሰሶተ ሀሶ መኑ «አበ በሬን ፈይሰኖ ጎሬ ለዕናም» ይት አገርታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ኢስን ህከ አንገተ ናፈ መንቹ «አም ከን በላን ኡር» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ህከኒች ኤተሮን ኢስ «አበ በሬን ጡመ ህከረንገ ሂለ አኡ ፈቀደሞኡ? ፎል ጡምሱንዶ ህከረንገ ፎል ቤሱ?» ይ ጠዕሜሰ፤ ጠዉ እኮጎሬ እሰ ጨለ ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ኢስን ቀልብሰ ዱድመተ ለዕይ አበ ሻዥ መዴስ ዮ መነ ኡሙዕሬን ለዕይ ህከ አንገተ ናፈ መንቹ «አንገክ ሂር» ዬስ፤ እስን አንገተ ሂሮ ወክት አንገስ ፈይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ወክትንከስ ፈሪሳውት ጭምት ምኒች ፉልት ኢሰ ሀት አት ሽቶተ አታልታ ጎሬ ሄሮድሴን ሜጡበ ዮ መኒን አማዕለንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","ኢስ አሳባንተስን ሜጡበ ገሊለ ባርበ ኦሮዕዮ፤ ኢስ አዕዮ አጀብሲሰኖ ጠወ ሞጮጭቶ ወክት ልግቡ መኑ አዎኞስ፤ አዎንቶስሩንኩ ገሊል ባዲች፥ ይሁድ ባዲች፥ ኤዶምየ ባዲች፥ ዮርዳኖስ ዉድ አዲን ዮ ባዲች፥ ህትን ዬሩሰሌም ከተሚች፥ ጢሮስ ከተሚችለከ ስዶን ከተሚች አሜቶዕረ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","መኑ በተዕዮቤቺሃ ሀንበዕለመን ሃሙ ከመኖስበእገ ጀልበ ቅጥአቶተ አዎናኑስ ኣዘዦ። ");
INSERT INTO alw_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ልግብ መነ ጥዘናች ፈይሾቤቺሃ ጥዘናን ኦርጨቀንታሩ ጉዕሙንኩ አንጋን አፎስተ ሀንበዕለንታ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ዶሮርታ አያናከት እሱ ለኦ ወክት ብሬስ ኡብ «አት መገንያ ቤቱ» ይተን ያርታ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ጠዉ እኮጎሬ ኢስ ገዉስ አዬት ጎሬ ኩልታበእገ ጠረኝሽ አዘዦሰ። ");
INSERT INTO alw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ኢስ ቆተ አል ፉሎ ወክት እስ ሀሾሰረ እስበ ገኤእ፤ እሰን እስበ አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","እሰን እስን ሜጡበ ሄኦታ፥ ተሽት ላገተ ተማርስቶተ ሶሆሰተለከ ሩሃንየ ፉሽታ ሹምነቱ ኣሶተ ቶና ለሙንከሰ መጠር አሳበተ ይ ሱዕምሾሰ። ");
INSERT INTO alw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","እሰን መጠሮሰ ቶነ ለሙንኩ አሳበት ከኑኡታን «ጴጥሮሴ» ይ ሱዕመ ፉሼ ስሞኒ፥ ");
INSERT INTO alw_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","«ቦአርኔጌስ» ህከረንገ «ጉገኛ ኦሱተ» ይ ሱዕምሾሰ ዘብዴዎሴ ኦሱት ያቁባትለከ ያህይት፥ ");
INSERT INTO alw_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","እንድርያሴት፥ ፍልጶሴት፥ ባርቶሎሞሴት፥ ማቶሴት፥ ቶማሴት፥ እልፍዮሴ ቤቱ ያቁባት፥ ታዶሴት፥ ባዱስ ኢተኖ ስሞኔት፥ ");
INSERT INTO alw_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ኢሰ ህግሽ ኣሴ አስቆሮቶ ይሁዳቲ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ኢስ ምኒ ኦሮዕያን ልግቡ መኑ ለንኪሃ ጭምይት አሜቶኡ፤ ህካን እኮቤቺሃ ኢስለከ አሳበት እቸተ እታ ወክቱ ዮሰበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","«ኢስ በርገጎኡ» ዬኖሃ እሉስ ሞጮጭቶ ወክት እሱ አፎተ አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ዬሩሳሌሚች አሜቶ ሕግ አስተማረት «እሱ ብዔልዘቡል አፎስ፤ እስ ሩሃንየ ፉሸኖሁ ህከን ሩሃንይ ዎመ ብዔልዘቡል ወልቃኒት» ይታ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ኢስን እሰንተ እስበ ገእ ምሳሌን «ሼይጣኑ ሀት አዕይ ሼይጣን ፉሾተ አታለኖ? ");
INSERT INTO alw_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","መቱ ዎሙ ገሸኖ መኑ ገገዉንኩስን አደ እክ ብተመኖሃ እኮች ሁኩ ዎሙ ሀት እክ ጠረኝ ኡሮተ አታለኖ? ");
INSERT INTO alw_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ህትን መቶ ምኔን ሄአኖ መኑ ብተንት ሀት እክ ጠረኝት ሄኦተ አታልታአ? ");
INSERT INTO alw_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ህካን እኮች ሼይጣኑ ገገዉስ አደ እክ ብተመኖሃ እኮች በአኖ ቤሉ ጠረኝ ሄኦተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«ህትን መቶ ጠረኘ መንች ምኒ ኣጌን ቦጎኖተ ሄጬን ህከ ጠረኘ መንቹ ኡሱሮኑዕነ ምንስ ኣጌን ቦጎኖተ አታሌኖበአ። ");
INSERT INTO alw_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","ሀንቅንከ ያንክዕኔ፤ ኡመቱ አታ ጩቡለከ ጠወኣ ቦሮር ላገት ጉዕሙንኩ ፈቁን የመመኖሰ። ");
INSERT INTO alw_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ጠዉ እኮጎሬ ጠሊለ አያን አሌን ቦሮር ላገተ ጠወአኖሀን አሌን ጉዕማንን ዘላለሚሃ መገን ኡሙዕርት አሌስ እካ ቤሉ ጩቡስ ማረመኖስበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ኢስ ህካን ጠወዕዮሁ «ዱሩ አፎስ» ይቶ መሳኒት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ኢስ አመትለከ አመስኦሱት አሜት አብሌን ኡርት እስበ መነ ሶክ ገእሲሶስ፤ ");
INSERT INTO alw_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ኢስ መዴን ልግቡ መኑ አፉዕልዮ እቅ፤ እሰን «አመክለከ አመክ ኦሱት አብሌን ኡርት ኬሳሃ ሀሳሄት» ይት ኩልቶስ። ");
INSERT INTO alw_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","እስን «አመኤለከ አመኤ ኦሱት አዬኤታን?» ይ መስለ ፈንቀሼሰ። ");
INSERT INTO alw_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ኢስን መዴስ አፉዕልቶሀኑ አደ ለአን «አመኤለከ አመኤ ኦሱት ከኑኡታን። ");
INSERT INTO alw_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","መገን ሰውት አአኖ አዪሁ እኮጎር ኤሳሃ አመዕያ ቤቱ፥ አመኤተ ቤቱለከ አመተኤ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ኢስ ለንኪሃ ገሊለ ባር መዴን ተማርሱ ጀመሮ፤ ልግቡ መኑ እስቤቾን ጭምይታን እስ ባር አሌን ዮ ጀልባን ኣግ አፉዕሌእ፤ ህትን ልግቡ መኑ ባር መዴን ሄዕዮ እቅ፤ ");
INSERT INTO alw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ህከኔን ኢስ ምሳሌን ልግብርቹ ተማርሰኖት እቅ፤ ተማርሰንን ");
INSERT INTO alw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«ሞጮጭዬ! መቱ አቡራንቹ ዜሬተ አፍ ዉጦተ ፉሎ። ");
INSERT INTO alw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ዜሬተ ዉጠንን መት-መቱስ ዎቄ አሌን ኡባን ጪኡት ኣሜት እቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ህትን ዎሉ ዜሬቱ ልግቡ ትቡ ዮበእቤቾን ክን ኣሌን ኡብ ደዕልን ሙቾ፤ መሰንትስ ቤቾንከስ ኣዝ ኢለ ልግቡ ትቡ ዮበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ሁኩንን አሩ ፉል ቀሾረ ቆሮ፤ ህትን ሙቾንኩ ጠጱ ዮስበእቤቺሃ ሞሎ። ");
INSERT INTO alw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ዎሉስ ዜሬቱ ኡቱ ጭምዬ በላን ኡቦ፤ ኡቱንኩ ነጵ ለንግ አፎስቤቺሃ አቶተ አቶቱዕነ ፈቆ። ");
INSERT INTO alw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ህትን ዎሉስ ዜሬቱ ጡመ ኡላን ኡብ ሙቾ፤ ሙቾንኩ ነጵ አቶተ አቶቾ፤ ሁኩንን መቱስ ሰጁ ዎሉስንገ ሌሃዉ ፈቆሲሁ ጥብተ አቶቾ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ኢስን «ሞጮጭታ መጨት ዮሲሁ ሞጮጩን!» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ኢስ ሜጥሀስ ሄዕዮ ወክት መዴንከስ ሄኦ መኑለከ ቶና ለሙንኩ አሳበት ሜጡበ ምሳሌስ ፍሳረተ ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","እስን «ክዕኔሃ መገን ዎምነትስ ምስጥር ደጎኖተ ኣሰሞህዕኔ፤ ጠዉ እኮጎሬ አብሌን ዮሀኑኡተ ጉዕሙ ጠዉንኩ ምሳሌን ኩለመኖሰ። ");
INSERT INTO alw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ህካን እኮቤቺሃ « ‹እሰ መገን አደ ፈንቀልቶ እቃ መገኑ ጩብሰ አጉረኖሰ እቅ፤ ጠው እኮጎሬ እሰን ለአን ለኦኢሃ ደጋበአ፤ ህትን ሞጮጭተን ሰዉ ይት ኣእታበአ› » ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ኢስን «ክዕኔሃ ት ምሳልት ኣጎህዕኔበእንዶ? ህከረ ዎልት ምሳልተ ሀት አቴን አጥራመቶኖተ አታልቴነን? ");
INSERT INTO alw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ዉጠኖሁ መገን ላገተ ኩለኖሃን። ");
INSERT INTO alw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ሁኩ ዎቄ ገበላን ኡቦ ዜሬቱ ለሊሰኖሁ ላገስ ሞጮጨኑሃ መነ፤ እሰን ሞጮጭቶ መገን ላገተ ሼይጣኑ አሜች ቀልብችሰ መጭ መሰኖ። ");
INSERT INTO alw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ህትን ሁኩ ክን አሌን ኡቦ ዜሬቱ መገን ላገት ኩለንታ ወክት ተሽቲን ደዕል ቶገኖ መነ አጉደኖ። ");
INSERT INTO alw_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ጠዉ እኮጎሬ እሰን ወክትሃሲት ቤሉ ጠጱ ዮሰበእቤቺሃ ጠረኝት ኡርታበአ፤ ህከን ላገ መሳን መት ኦሪሸት ህከረንገ ቶቸሙ አሜቾ ወክት ደዕልት ቆዕልት ኡባአ። ");
INSERT INTO alw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ህትን ዎሉንገ ጭምዬ ኡት በላን ኡቦ ዜሬትጋት፤ እሰን ላገስ ሞጮጭታእሃ መነ፤ ");
INSERT INTO alw_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ጠዉ እኮጎሬ ከን ኣዱንያ አል ሻዘነት፥ ዱንያተ ኢቱሁ ዎሉ ልግብርቹ ሄዕላቱ ቀልብሰ ኣዝ ኣግ ህከ መገን ላገተ ለንግ አፋን አቶቱዕነ ፈቆኡ። ");
INSERT INTO alw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ጠዉ እኮጎሬ ጡመ ኡላን ዉጠሞ ዜሬቱ ለሊሰኖሁ መገን ለገተ ሞጮጭት ቶጋእሃ መነ፤ ሁኩ መኑንኩ መቱስ ሰጁ መቱንገ ሌሃዉ ዎሉንገ ጥብተ አቶተኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ለንኪሃ ኢስ ፈንቀሽ «መኑ ኩራዘ አፍሲሽ ሰቀሌኖ ቤቾን አፉሹ አጉር ዛሌ ኣዜን ህከረንገ ሀንሸሪች ዎሮን አፉሸኖንዶ? ");
INSERT INTO alw_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ህትን ሀኩ ማጠሞርቹ ለሉዕነ ህትን እፍሰሞርቹ ፈንተኡዕናን ፈቀኖበአ። ");
INSERT INTO alw_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ሞጮጭታ መጨት ዮሲሁ ዮ ጎሬ ሞጮጩን» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ኢስን «ሞጮጭቴነንታሃ ጉዕመንከ አገዕርዬ፤ አዕኑ ዎሎ መናን ፈረዴንተገን ክዕኔ አሌን ፈረደመኖ፤ በትሽን በርገመኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ዮስሀኒሃ ኣሰመኖስ፤ ጠዉ እኮጎሬ ዮስበእሀኒች ሁኩ ዮሲንኩ ኣአመኖስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ህከኒች ኤተሮን ኢስ «መገን ዎምነቱ ኡለ አሌን ዜሬተ ዉጦተ ፉሎ መንቹ አጉደኖ። ");
INSERT INTO alw_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ሁኩ ዜሬተ ዉጮ መንቹንኩ ሀንከዕርተ ኦሰአኖ፤ ሶዦ ወክት ኦሶች ኬአኖ፤ ሁኩ ዉጠሞ ዜሬቱ ሀት እሀኖጎሬ ዳጎኑዕናን ሙች ነጰኖ። ");
INSERT INTO alw_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ኡለት ገይንትሴ ህከ ሙተ ነስታአ፤ ህከኒች ኤተሮን ሀበረ ኤበኖገ አታአ፤ ህከ ሀበረ ነስቶች ኤተሮን አቶተ አቶተኖገ አታአ። ");
INSERT INTO alw_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ዉጠት ኢልቶ ወክት ወክቱስ ዉጠተ ጭም አኤኖ ወክት እኮቤቺሃ መንቹስ ዘዘረተ ቅጥ አዕይ ምደኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ኢስን «መገን ዎምነቱ መርቺን ቅጥ አዕናም? ህትን መ ምሳሌን ሂርን ጠወዕናም? ");
INSERT INTO alw_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","መገን ጄነቱ ዎንጌ እልተ አጉዳአ፤ እሴን ዉጠንታ ወክት ኡለ አሌን ዮ ዜሬቲች ጉዕሚችን በትስ ቀዎታን። ");
INSERT INTO alw_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ጠዉ እኮጎሬ ሁኩ ዜሬቱንኩ ዉጠሞች ኤተሮን ነጵ ጋሮን ካሴመሀኒች ጉዕሚችን በተአኖሃ አሀኖ፤ ቅራዕሩ ሀመ ነሰኖ፤ ህካን እኮቤቺሃ ሰሜ ጪኡት ምኒ መክስ እስ አሌን ሄኣኣ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ኢስን መኑ ሰውዩ አታልታገ ካን አጉዳ ልግቤ ምሳሌን ላገስ ኩለኖሳት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","እስን ምሳልት ዮበኢሃ መቱርቹሃ ጠወዕዮሰበአ፤ ጠዉ እኮጎሬ እስን አሳባን ሀለኘሰ ሄኦ ወክቴን ጉዕመርቹንከ ሂር ኩለኖሰ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ህከ በር ሀዎሬ ወክት ኢስ አሳበስ «ከን ሎረ ዊች ዉድ አደ ቶልኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","እሰን ህከኔ ዮ መነ አጉርት ኢስ ዮ ጀልባን ኣግ ኢሰ ኣእት መርቶኡ፤ ህከ ወክትንከ ዎሉ ጀልቡ እሳን ሜጡበ ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ድንገቴን ጠረኙ ቦብሩ ዊ አሌን ኬዕዮ፤ ዊ ሁሉንኩ ጀልበ ካጰለከ ከበ ሀንበለን ዊ ጀልብ ኣዜን ዊሞተ እኮ። ");
INSERT INTO alw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ህከ ወክትንከ ኢስ ጀልብ ኣዜን ኤተር አዲን ቦርከዕይ ግሾ እቅ፤ አሳበስ እሱ ግሰኛች በቅአት «አስተማርቾ! ነኡ በዕነን አት ሀት ጨለ ይቶንት?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","እስን ኬዕይ ቦብረንከ ሻቆ፤ ዊ ሁለንከ «ጨለይ» ዬእ፤ ቦብሩንኩ አጉሮ፤ አበንከ ጨለ ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ኢስን «ሚሃት ዋጅቴነንታሁ? ቴሁ አመዕነቱ ዮህዕኔበእንዶ?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","እሰን አበ ዋጅት መት-መቱሰ «ጠረኙ ቦብሩለከ ዊ ሁሉ አዘዘመኖሲሁ ኩን ሀትናሙወ መንቹ?» የቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ህከኒች ኤተሮን ኢስ አሳባንተስን ገሊለ ባረ ቶልት «ጌርጌሴኖነ» ዬኖ ባዱ ኢልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ኢስ ጀልቢች ፉሎገን ዶሮረኖ አያኑ አፋንስ ሎደቤቾን ሄአኖ መንቹ ወክትንከስ ህከን አዲች ፉል ደቀሞስ። ");
INSERT INTO alw_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ሁኩ መንቹንኩ ሎደ ኣዜን ሄአኖ እቅ፤ ህከ ወክት አዪሁ እሱ ሰንሰለቲን ኡሱሮተ አታለኖበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ልግብ ወክት አንገስለከ ሎከስ ኡሱሬኖ ወክት እስ ህካን ጉዕመንከስ ሙረንሰኖ እቅ፤ ህካን እኮቤቺሃ አዪሁ እሱ አፍ ኡሱሮተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ህትን እስ ጉዕመ ወክት ሀዎሩተለከ በራሃ ሎዱለከ ቆተቲ ዮቤቾን ዘሀን አልስ ክኒን ሀንፈጠን ያረኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","እስን ኢሰ ቄዕራሻን ለዕዮ ወክት ደጉጅ አሜች ብሬስ ጉልጵ ሰገጆ። ");
INSERT INTO alw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ህትን ሎረ ላጋን ያረን «አት ጉዕሚችን ሎረ መገን ቤቶ ኢሰ! ኤሳለከ ኬሳሃ ም ደቀንሹ ዮኔ? አን ኪች መገኖን መገኝዮንኬ ቤሶቴኤ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ህት ዮተ አታሎንኩ ኢስ «ኩ ዶሮርታንት ዱሩ ከን መንቺች ፉል» ይ አዘዦቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ኢስን ሱዕሙክ አዬት? ይ ጠዕሜስ፤ እስን «ናኡ ልግብ እንኮምቤቺሃ ሱዕሙኤ ሌጌዎኔት» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","እስን ህከን ባዲች ፉሽ ሸረኖሰበእገ ኢሰ ጠረኝሽ ኡጬስ። ");
INSERT INTO alw_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ህከን ቆሮ መዴን ልግቡ ቦኬ መሰረት ዘግ ይት እታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ሁኩ ዶሮረኖ አያኑንኩ «ሀዕይ ህከን ቦኬ መሰራን ኣንጋምገ አእኔ» ይት ኢሰ ኡጭቶስ። ");
INSERT INTO alw_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ኢስ «መርቴን ኣጌ» ዬሰ፤ ሁኩ ዶሮረኖ አያኑ ህከን መንቺች ፉልት ቦኬ መሰራን ኣጎኡ፤ ህከኒች ኤተሮን ለምተ ኩምተ እካ ቦኬ መሰረት ቆሮ መዲች ደጉደን ሎረ ባራን ኣአንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ህከን ቦኬ ዜማኑት ሁንት ከተማንለከ ህከን ባዶን ሄአኖ መኒሃ ጠወስ ኩልቶኡ፤ መኑንኩ እኮ ጠወ ለኦተ አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","እሰን ኢስበ አሜት ዶሮረኖ አያኑ አፎስሃ፥ ሌጌዎንን ሄዕዮስ መንቹ ፈይ ኦድኑተ ኦደዕይ አፉዕልያን ለኦ ወክት ጉዕሙንኩሰ ዋጅቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ኢስ ዶሮረኖ አያነ ህከን መንቺች ፉሸንለከ ዶሮረኖ አያኑንኩ ቦኬን ኣገን ወዕና ህከን ቤቾን ሄእ ለኦሩ እኮ ጠወ ጉዕመንከ መኒሃ ኩልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ህካን እኮቤቺሃ ህከን ባድ መኑ ኢስ ህከን ባዲች ፉል ኦሮአኖገ ኡጭቶስ። ");
INSERT INTO alw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ኢስ ጀልባን ኣገን ሩሃንዩ አፋንስ ፈዬ መንቹ ኢሰ «አን ኪን ሜጡበ ኦሮኣም» ይ ኡጨስ። ");
INSERT INTO alw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ጠዉ እኮጎሬ ኢስ «ኢን ሜጡበ መርታንትበአ፤ ምንክ መርት ቀርቹ ሄንከ ሎረ ጠወ አዕዮሄ ጎሬ ህትን ሀት አዕይ ፈይሾሄጎሬ ምንክ መኒሃለከ እልሀክ ጠወእ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ሁኩ መንቹ ኢስ አዕዮስ ጠወ «ቶኑ ከተመ» ዬኖ ባዶን ጉዕማንን አዋጁ ጃመሮ፤ ጠወስ ሞጮጭቶ መኑ ጉዕሙንኩ አጀብሲጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ኢስ ጀልባን ኣግ ባር ዉድ አደ ፈንቀል ቶሎገን ልግቡ መኑ እስ መዴን ጭምዬእ፤ ህከ ወክት ኢስ ባር መዴን ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ህከኔ ጭምት ምኒ ገሽታሀኑኡች መቱስ «ኢያኢሮሴ» ዬኖ መንቹ አሜች ኢሰ ለዕዮ ወክት ሎከስ አሌን ኡብ ");
INSERT INTO alw_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","«ኢ ቀዉት ጩልኤ አበ ጥዞኡ፤ አት አሜት ጡምቶተለከ ፎልን ሄኦተ እሴ አሌን አንገክ አእ» ይ ኢሰ ጠረኝሽ ኡጨእ። ");
INSERT INTO alw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ኢስን እሲን ሜጡበ ኦሮዕዮ፤ ህከ ወክት ልግቡ መኑ ኢሰ አዎነን ከን አዲንለከ ካጵ አዲን ሀንበዕለንተን ሃሙ ከንት ጨነቃሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ህከን መን በላን ቶነ ለሞ ዘማን ጌሰ ቄጉ ዱንተአንሴ ኦርጨቀንተን ሄኣ መት መንቹት ሄኦ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","እሴን ሐኪሚች ሐኪመ ልግብ ወክት ፈንቀላንት ዱንያሴ ጉዕመንከ ሹልቶ እቅ፤ ጠዉ እኮጎሬ ባሾሴ ቤሉ መቱርቹሃ ደግለሎሴበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","እሴን መኑ ኢስተኔሃ ጠወአኖ ዱዱቡ ሞጮጭቶቤቺሃ ሀንበዕለመኖ መን በሊን ኤተር አዲን አሜት ኦድኑስ ኡልቶኡ፤ ህካን አቶኢሁ ቀልቤንከሴ «አን እስ ኦድኑተ ኡሎም እቃ ፈያም» ይታ አመዕነቱ ሄዕዮሴ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ህከ ወክትንከ ቄጉ ዱንተኡ አጉሮሴ፤ እሴን ጥዘናችሴ ፈዩሴ ጅስሚንከሴ ደጎኡ። ");
INSERT INTO alw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ኢስን ወልቀት እሲች ፉልቶገ ደጎቤቺሃ መን አደ ዘህ ለዕይ «አዬት ኦድኑእ ኡሎሁ?» ይ ጠዕሜሰ። ");
INSERT INTO alw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","አሳበስ «አት ኬንኩ መኑ ሀንበዕለመን አዎነኖሄ ለአን ሀት ‹አዬት ኡሎኤሁ› ይተን» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ጠዉ እኮጎሬ ኢስ ህካን አዕዮሁ አዬት ጎሬ ለኦተ ዘህ ለዕዮ። ");
INSERT INTO alw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ህት መንቹት እኮ ጠወ ደጎቤቺሃ ዋጅት ሁጠን ሎከስ ኡብ ክዝቡዕነ ሀንቅ እኮ ጠወ ጉዕመንከ ኩልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ኢስን እሴተ «ኢ ቤቶ አመዕነቱክ ፋይሾሄ ወገሬቲን መር፤ ጥዘናችክ ፈይ» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ኢስ ህካን ጠወአን ሄዕዮገን ጭምት ምኒ ሀለቅች ምኒች ሶቀንት አሜቶ መናከት ጭምት ምኒ ሀለቅቹ «ጩልክ ሬቶኡ፤ ቴሱ አስተማርቹ ሚሃት ኦርሳንትሲሁ?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ጠዉ እኮጎሬ ኢስ እሰ ይታ ጠወ ሞጮጭ ጭምት ምኒ ሀለቅቹ «አመዕን ቤሉ ዋጅቶት» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ህትን ኢስ ጴጥሮሴችለከ ያቁቢች፥ ያቁብ አመቤቱ ያህይ ቤሉ አዪሁ አዎኖስተ ፈቀጆበአ። ");
INSERT INTO alw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ኢስን ጭምት ምኒ ሀለቅች ኢያኢሮሴ ምኒ ኢሌ ወክት ህከን ምኔን መኑ ያረንለከ ኦአን ጨንጭተን ለዕዮ። ");
INSERT INTO alw_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ኢስን ምኒ ኣግ «ሚሃት ያርቴነንታሁለከ ኦኤነንታሁ? ጩልት ግሶ ቤሉ ሬቶበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","እሰን እሶን አበ ኦሰዕልቶኡ፤ ጠዉ እኮጎሬ እሰንተ አብል ፉሽ ጩሌ አነለከ አመተ እሲን ሜጡበ ሄኦእረ አዎንስ ጩልት ዮ ቤቹ ኣጎ። ");
INSERT INTO alw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ኢስን ህተን ጩሌ አንገተ አፍ «ጣሊታ ቁሚ!» ዬሴ፤ ፍሳረስ «ቴ ጩሌ ኬእ» ዩሃን። ");
INSERT INTO alw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ጩልንት ቶነ ለሞ ዘማንተ ጩል እቅ፤ ወክትንከስ ኡርት ከበለከ ካጰ እከን ፈንቀላንቶኡ፤ ህከኔ ሄኦ መኑ ከ ጠወ ለኦ ወክት አጀብሲጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ህከ ወክት ኢስ ከ ጠወ አዬሃ ጠወኣበእገ ጠረኝሽ ኩል «ጩሌተ እታኢሃ ኣስዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ኢስ ህከንቤቺች ፉል ገይስ ባዱ አሳባንተስን ሜጡበ አሜቾ። ");
INSERT INTO alw_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ህከኔን ኢስ አበ በሬን ጭምት ምኔን ተማርሱ ጀመሮ፤ ህከኔ እስ ተማርሰኖሃ ሞጮጭቶ ኡመቱ አበ አጀብሲጭት ገገዉንኩሰን «ኩ መንቹ ከ ጠወሃ ጉዕመንከ ሀከኔ ደኤእ? ሀትኔ ሀይመት ኣሰንቶስ? ህትኔ አጀብሲሰኖ ጠወ አአኖሁ ሀትጎታን?» ይተን አጀብሲጭታ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ህከኒች ኤተሮን «እስ ማይረመ ቤቱ አነጤቾሃበእንዶ? ያቁቤሃ፥ ዮሳ፥ ይሁዲለከ ስምዖኔሃ አመ ቤቱበእንዶ? ሜኣ አመስ ኦሱንት ከኔ ኒን ሜጡበ ዮእረበእንዶ?» ይተን ህንቅ ቶጉዕናንስ ፈቆኡ። ");
INSERT INTO alw_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","እኮጎሬ ኢስ እሰንተ «ነቢዬቹ ዎሎ ባዶን ኬዕምሴኖስ፤ ጠዉ እኮጎሬ ገይስ ባድ መኑሁ፥ ገይስ እሉለከ ገይስ ምኒ መኑ ህንቀኖስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ህከኔ ሄኦ ቀዎ ጥዘናመ አሌን አንገተ አዕይ ፈይስቤሉ ዎሉ አጀብሲሰኖ ጠወሃ አኦተ አታሎበአ፤ ");
INSERT INTO alw_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ጠዉ እኮጎሬ ኡመቱ አመዕንቱዕነ ፈቆቤቺሃ አበ ቦሮረንቶኡ፤ ህከኒች ኤተሮን ኢስ ቀኤች ቀእተ ዘሀን ተማርሰኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","እስን ቶነ ለሙንከ አሳበተ እስበ ገእ ለሙ ለሙ አዕይ ዶሮረኖ ዱር ፉሽታ ሹምነቱ ኣስ ሶኮሰ። ");
INSERT INTO alw_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","እስን እሰንተ «ዎቃ ሃንተን በርት ቤሉ እቴኖሃ እኮ ኢቶንከሰ ብረለከ ከረጥትተ አፋበእገ አዘዦሰ። ");
INSERT INTO alw_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ሎካንከክዕኔ ጫዕመተ ወዕርዬ ቤሉ ለሙ ዎልት ኦድኑተ ኦደኦኖቼ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ህትን እስ «አዕኑ መርቴነንተ ቤቾን መቱ ምኒ ኣጌነንተ ወክት ህከ ቤቹ አጉርቴን ፉልቶኖተ ኢለ ህከን ምኔን አገሬ። ");
INSERT INTO alw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","መርቴንተ ቤቾን ጉዕማንን ‹ሀበይ ወገሬቲን አሜቴን› ዬን ቶጉለከ ሞጮጩ ግቤመህዕኔጎሬ አዕኑ ሎከክዕኔ ትበ ህከኔ ግግሽቴን አጉርቴን ፉሌ፤ ሁኩ ትቡንኩ እሳሃ እማኘ እሀኖ» ይ ኩሎሰ። ");
INSERT INTO alw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","እሰን መርት መኑ ጩብችሰ ፈንቀልት ቶበታገ ዱዱብስቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ህትን እሰን ልግብ ሩሃንየ ፉሽቶኡ፤ ጥዘናመ አሌን ዘይተ ቡርተን ልግብ ጥዘናመተ ፈይሶኡ። ");
INSERT INTO alw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ኢስ ሱዕሙ ጉዕመ ባዶንን ደገሞቤቺሃ ዎሙ ሄሮድስ እስተኔሃ ሞጮጬእ፤ ህትን መት-መቱ መኑ «ጠመቃንቹ ያህይ ሬሆች ኬዕዮኡ፤ ህካን እኮቤቺሃ ከ አጀብሲሰኖ ጠወ አአኖ ወልቀተ ደኤእ» ይታ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ዎሉ መኑ «እልያሴት» ይታኢት እቅ፤ ህትን ፈቆ መኑ «ሄጭት ሄኦ ነቢያኖች መትስጋት» ይታ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ጠዉ እኮጎሬ ሄሮድስ ህካን ጉዕመንከ ሞጮጭ «አን ጎበስ ሙርሲሾም ጠመቃንቹ ያህይ ሬሆች ኬዕዮኡ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","ሄሮድስ አመስ ቤት ፍልጶሴ ጫተ ሄሮድያደ ኣኤቤቺሃ ያህይ «አመክ ቤት ጫተ አኡ ኬሳሃ ፈቀደሞሄበአ!» ይ ጠወዕዮቤቺሃ ሄሮድስ ሶክ አፍሲሽ ያህይ ኡሱርሲሾ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ህካን እኮቤቺሃ ሄሮድያዳ ያህይን ገዱተ አፍ ሽሲሶስተ ሀሳኢት እቅ፤ ጠዉ እኮጎሬ ሽሲሶስተ አታልቶበአ። ");
INSERT INTO alw_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","መሰንትስ ያህይ ፈየ መንቹለከ ጠሊለ መገን መንቹ እሁስ ሄሮድስ ደገኖቤቺሃ ዋጅ አገረኖስ እቅ፤ ህትን እስን ያህይ ጠወአኖ ጠወ ሞጮጬ ወክት ባበኖ እቅ፤ ጠዉ እኮጎሬ ሙንደዕይ ሞጮጨኖስ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ሄሮድስን እለሞ በሬ ከበጃት ከበጂሃ ባድ ገሻኑተለከ ገሊለ ሎርሎረ መነ ጉዕመንከ ድግሰ ድግሽ ገኤእ፤ ሁኩ በሩ ሄሮድያደ ያህይ ሽሲሶስተ መኩተ እኮሴ። ");
INSERT INTO alw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ህከ በርንከ ሄሮድያዳ ቤቱት መኑ ጭምዬ ምኒ ኣግ ቦሎቸ ከደን ሄሮድሴለከ እሲን ሜጡበ ሄዕዮ ኮሀ ሙንዲሲሶኡ፤ ህካን እኮቤቺሃ ዎሙ ህተ ጩልተ «አት ኢትታንት ጉዕመንከ ጠዕሜኤ፤ ኣሳንኬ» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","«ሆሮ ዎምነትኤ ደሩ እኮጎሬ አት ይቶንቲሃ ጉዕመንከ ኣሳንኬ» ይ ጤሌዕሌእ። ");
INSERT INTO alw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","እሴን አመሴቤቹ መርት «መ ኣሴኤ ዩ?» ይት አመሴ ጠዕምቶ ወክት « ‹ጠመቃንቾ ያህይ ቡዕለ ኣሴኤ› ይ» ይቶሴ። ");
INSERT INTO alw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ጩልንት ደዕልት ወምበ ኣግ «ጠመቃንቾ ያህይ ቡዕለ ሳናን አኤን ቴሱ ኣሶኖኤተ ሀሳም» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ዎሙ ህከን ጠዋን አበ ሻዦ፤ እሁን ቤሉ ጤሌዕሌቤቺሃለከ እሲን ሜጡበ ሄኦ ኮህተኔሃ ጠዕምቶኢሀ ከሞተ ሀሾበአ። ");
INSERT INTO alw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ህካን እኮቤቺሃ ህከ ወክት ዎሙ ወታደሪች መቱ ያህይ ቡዕለ ሙር ኤበኖገ ኡሱር ምኒ ሶኮ፤ ወታደርቹንኩ ኡሱር ምኒ መር ያህይ ቡዕለ ሙሮ። ");
INSERT INTO alw_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ሙር ኤቦ ቡዕለንከ ጩሌተ ሳናን አዕይ ኣሴሴ። ጩልንት መስት አማተሴ ኣቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ያህይ አዎንታእሩ ህከን ሞጮጭት ኡሱር ምኒ አሜት ጀናዘስ መስት ሞጎኡ። ");
INSERT INTO alw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ሶቀማኑት ሶሀንቶ አዲች ፈንቀልት ኢስ ብሬን ጭምይቶኡ፤ ተማርስቶኢሃለከ አቶኢሃ ጉዕመንከ እሲሃ ኩልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ኢስን እሰንተ «አዕኑ ሜጥሃክዕኔ መርቴን መኑ ዮበእቤቾን ቀዉ ጌሰ ፎሎጭዬ ዬሰ» ህካን ዬኢሁ እስበ አሜተኖሁለከ መረኖሁ ልግብ እኮቤቺሃ እቸተ እታ ወክቱ ዮሰበእቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ህካን እኮቤቺሃ እሰ ሜጥሀሰ ጀልባን ኣግ መኑ ዮበእቤቹ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ጠዉ እኮጎሬ እሰ መርተንን ልግቡ መኑ ለዕይ እሰተ እሁሰ ደግ ከተሚች ጉዕሚችን ደዕልት ፉልት ሎካን ደጉደን ሄጭት ቤቹስ ኢልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ህከን ቤቾን ኢስ ጀልቢች ድረን ልግብ መነ ለዕዮ፤ መኑንኩ ዜማንቹ ዮሰበእ ሆለገ እካን ለዕይ አበ መረርሲጬሰ፤ ህከኔን ልግብ ጠወ ተማርሱ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ህከኔን ኡለት ሀዎርቶቤቺሃ አሳበስ እስበ ሆንጠክ «ዮም ቤቹ ኡድመሃን፤ ወክቱስ ሀዎርዮኡ፤ ");
INSERT INTO alw_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ህካን እኮቤቺሃ እታኢሁ ዮሰበእቤቺሃለከ ከን ቀኤን ዮ ገጠረለከ ኦሎሃ መርት እቸተ ገይሃሰ ህዕርታገ ከ መነ ህርሲስ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ጠዉ እኮጎሬ ኢስ እሰንተ «ኩ መኑ እታኢሃ አዕኑ ኣስዬሰ» ዬሰ፤ እሰን «ህካን እኮች እታኢሃ ለሜ ጥቤ ዲናሪን ህዕርን ኣስኖሰንዶ?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ኢስን ፈንቀሽ «ህንዴ ሄንኩ ጣብቱ ዮህዕኔጎሬ መርቴን ለእዬ» ዬሰ፤ እሰን መርት ለእ «ኦንቱ ጣብቱለከ ለምት ቁርጩሜት ዮኔ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ኢስን አሳበስ መነ ለቶ ህጤ አሌን ቤቾን ቤቾን አፉሽታገ አዘዦሰ። ");
INSERT INTO alw_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ህካን እኮቤቺሃ መኑስ መት መቶ ቤቾን ጥብተ ጥብተ ህትን መት-መቶ ቤቾን ኦንታሁ ኦንታሁ እክ አፉዕልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ኢስን ኦንቱ ጣብታለከ ለም ቁርጩሜተ ኣእ ሰማ ዋሽ ለዕይ መገኑ ገለትጬእ፤ ህከኒች ኤተሮን ጣብተንከ ቢጭ መኒሃ ሆንጠህሶተ አዎንታሀኑኡተ ኣሴእ፤ ህትን ለም ቁርጩሜተ መኒሃ ጉዕሚንከ ቤኮ። ");
INSERT INTO alw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","መኑ ጉዕሙንኩ እች ዱቦ። ");
INSERT INTO alw_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","አሳበንት መን ብሬች ፈቆ ፉርፉሩለከ ቁርጩሜች ፈቆሃ ቶነ ለሙ ሳጠራ ዊሞሃ ኬሶኡ። ");
INSERT INTO alw_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","እቸተ እቾ ጎን ዎሊንሹ ኦንቶ ኩሜ መነ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ህከ ወክት ኢስ መነ ህርሲሰን አሳበስ ጀልባን ኣግ ዉድ አደ «ቤተ ሳይዳ» ዬኖቤቹ እሱ ሄጭት መርቶተ አዘዦሰ። ");
INSERT INTO alw_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","እስ መነ ህርሲሾች ኤተሮን ዱአ አኦተ ቆተ አል ፉሎ። ");
INSERT INTO alw_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ኡለት ሀዎርቶ ወክት ጀልቡንኩ ባር በላን ሄዕዮ እቅ፤ ጠዉ እኮጎሬ ኢስ ሜጥሀስ ኡለ አሌን ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","አሳበስ ብሬን ዊ አሌን ጠረኙ ቦብሩ ኬዕይ ጀልበ ብሬ አደ ዋሽ ሃሙ ከማን ኦርጨቀንተንን ኢስ ለዕዮሰ፤ ሁኩንን ሆንሲች ቶና ለሞ ሳኣት ጌሳን ባር ኣሌን ሃመን እሰ አዲን አሜች አጉር ህጎታት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ጠዉ እኮጎሬ እስ ባር አሌን ሃመን ለእ ሀብዙላት አጉጃንሰ ያርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ጉዕሙንኩ ለኦስ ወክት ህልቆኡ፤ ህከ ወክት ኢስ «ጠረኝዬ! አኔት! ዋጅቶኖቼ!» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","እስን ጀልብ ኣዝ እሰበ ኣጎ ወክት ቦብሩንኩ አጉሮ፤ አሳበስ ህከን ጠዋን አበ አጀብሲጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","እሰ ቀልቡንኩ ዱጆሁ ወዕና ኢስ ኦንቶ ኩሜ መኒሃ ኦንቱ ጣብተ እትሾ ጠወ ሰውዩ ሆጎቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ባሪች ቶልት «ጌንሴሬጠ» ዬኖ ባዱ ኢልቶኡ፤ ጀልበንከ ዊ አሊች ኡለ መድ ሆንጠህስ ኡሱርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","እሰ ጀልቢች ፉልቶገን ኢሰ እሁስ መኑ ደጎ። ");
INSERT INTO alw_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ህካን እኮቤቺሃ መኑ ህከን ቀኤን ሄዕዮ ኦሎ ጉዕመንከ ደጉደን መርት ኢስ ዮኡ ዬመ ቤቹ ጥዘናመተ ዴሲን እጅት ኤባኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ኢስ ኦሮዕዮ ቤቹ ጉዕመንከ ቀኤች፥ ከተሚችለከ ገጠሪች ጥዘናመተ ጉዕመንከ በነቻን ኢስ መድ ሆንጠህሰን ኦድኖስ ሰኑተ ኡልቶተ ኡጭታኢት እቅ፤ ህትን ኢስ ኦድኖ ሰኑተ ኡልቶእሩ ጉዕሙንኩ ጥዘናችሰ ፈይታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","መት-መቱ ፈርሳውትለከ ዬሩሳሌሚች አሜቶ ሕግ አስተማረት ኢስበ አሜት ጭምይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","እሰን ኢስ አሳበት መት-መቱሰ አንገሰ ነጠ አቱዕነ ዩ ኣዕልቱዕነ ጣብተ እተን ለኦኡ። ");
INSERT INTO alw_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ፈርሳውትለከ ኣይሁዱ ጉዕሙንኩ ባልቅ ዎገ አገርቶተ አንገሰ ኣዕልቱዕናን እታበአ። ");
INSERT INTO alw_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ህትን ጌቤች ፈንቀልት አሜታ ወክት ሄጭት ኣዕልቱዕናን እታበአ፤ ኩባየለከ ጆከ፥ ናስ ምዳኑተለከ መዕነተ፥ ልግብ ህትኔ ዎገ አገርታአ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ህካን እኮቤቺሃ ፈርሳውትለከ ሕግ አስተማረቲ ኢሰ «አሳበክ ባልቅ ዎገ አገሩ ግብ አንገሰ ኣዕልቱዕናን ጣብተ እታኢሁ ሚሃት?» ይት ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ጠዉ እኮጎሬ ኢስ እሳንከ ፈንቀሽ «ክዕኔተኔሃ ራጎገን አዕኑ ኩ ለዕዬኔ ይቴነንተሀኑኡተ ነቢዬቹ እስያስ ጠወዕዮገን « ‹ኩ መኑ አፎንከስ ኬዕምሰኖኤት ቤሉ ቀልቡስ ኢች አበ ቄዕርዮእሃን! ");
INSERT INTO alw_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","መሰንትስ መን ትዛዝ ተማርስተን ኤሳሃ ህትን ሰገዳኤት› የመም ከተበሞ ራጉ ሀንቅሃን። ");
INSERT INTO alw_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","አዕኑ መገን ትዛዝ አጉርቴን መን ዎገ ጠረኝሴን አገርቴንታአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ህትን ኢስ እሰንተ «አዕኑ ክዕኔ ዎገ አገርቶኖተ መገን ትዛዝ አጉርቴንታአ። ");
INSERT INTO alw_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ሙስ ‹አነክለከ አመክ ከበጅ፤ ህትን አዪሁ አንስ ህከረንገ አመስ አሌን ሂለ ጠወ ጠወአኖኦሁ ሬሁን› ይ አዘዦ። ");
INSERT INTO alw_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ጠዉ እኮጎሬ አዕኑ መቱ መንቹ አነስ ህከረንገ አመስ ‹አኒሃስለከ አማተስ አኡ ሀስሰኖ ጠወ ጉዕመንከ መገኒሃ ኣስዮም› ዬህዕኔጎሬ ");
INSERT INTO alw_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","አነስ ህከረንገ አመስ ደግለሎበአ ዬን ጠዕሜኖስበአ። ");
INSERT INTO alw_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ከን ሃሌን ገይክዕኔ ዎገ አገርቶኖተ መገን ላገተ ድጅቴነንታት፤ ህትን አዕኑ ህትኔ ልግብ ጠወ አቴነንታት» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ኢስ ለንኪሃ ኡመትስ እስበ ገእ «አዕኑ ጉዕሙንኩክዕኔ አን ጠወአንክዕኔ ጠወ አጥራመቴን ቶጌ። ");
INSERT INTO alw_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","መንቹ ንጃስሰኖሁ ኣዚች ፉለኖሃ ጠወ ቤሉ አብሊች ኣዝ ኣገኖሁ መነ ንጃስሰኖበአ» ");
INSERT INTO alw_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ሞጮጭታ መጨት ዮሲሁ አዪሁ ሞጮጩን ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ኢስ ኡመት አጉር ምኒ ኣጎ ወክት አሳበስ እስ ተማርሴ ምሳሌተኔሃ ሂር ኩሎሰተ ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ኢስ እሰንተ «አዕኑ ቴሁ ካን አጥራመቴን ቶጌነንተበእንዶ? አብሊች መን ጎደባን ኣገኖሁ ንጃስሰኖበእገ ደጌነንተበእንዶ? ");
INSERT INTO alw_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","መሰንትስ አፌች ጎደባን ኣግ ሹመተ እክ ፉለኖሀን ቤሉ ቀልብበ ኦሮአኖበአ» ዬሰ፤ ኢስ ህካን ዩስ እቸት ጉዕሙንኩ ነጠ ዩሃንስ። ");
INSERT INTO alw_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ለንኪሃ ኢስ «መነ ንጃስሰኖሁ መን ቀልቢች ፉለኖሃን። ");
INSERT INTO alw_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ሁኩንን ሂሉ ሰውቱ፥ ሞጉ፥ ዝነት፥ መነ ሹ፥ ");
INSERT INTO alw_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ጎራምመት፥ ሂለተ ሆጉተ አኡ፥ ጣንሱሁ፥ ሀሶገ እሁ፥ ምቀኞመት፥ ሄምት፥ ቦኑለከ ዋንክዕሉሁ ");
INSERT INTO alw_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ኩን ጉዕሙንኩ ሂሉ ጠዉ መን ቀልቢች ፉለኖ፤ እስን መነ ንጃስሰኖሃን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ኢስ ህከንቤቺች ኬዕይ ህከ ጢሮስ ባዱ ኦሮዕዮ፤ ህከኔን መቱ ምኒ ኣግ ህከኔ ሄኡስ አዪሁ ሞጮጨኖበእገ ሀሾ፤ ጠዉ እኮጎሬ ህከኔ ማጠሞተ አታሎበአ። ");
INSERT INTO alw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ዶሮረኖ አያኑ አፋንሴ ጥዞ ጩልት ዮሴ መንቹት ኢስ ዱዱቡ ሞጮጭቶ ወክት እስበ አሜት ሎከስ ኡቦኡ። ");
INSERT INTO alw_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","መንቹንት ሲሮ ባዶን ፊንቃዌ አዲች ከለቀንቶእተ ግርካዊቾተ እቅ፤ እሴን ጩሌችሴ ዶሮረኖ ዱር ፉሾተ ኢሰ ኡጭቶስ። ");
INSERT INTO alw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ጠዉ እኮጎሬ ኢስ ህተን መንቾተ «ኦሶ እቸተ ዉሻተ ኣሱ ሀስሰኖበአ፤ ሄጭት ኦሱት እት ዱቡ ሀስሰኖ» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ህት መንቹት ፈንቀሽት «ቀርቾ ሁኩን ሀንቅሃን፤ ጠዉ እኮጎሬ ዉሸት ኦሱት እቶ ቁኒች ኡቦ ፉርፉሩ እታአ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ህካን እኮቤቺሃ ኢስ «ካን ጠወኦንተክ ጩሌችክ ዶሮረኖ አያኑ ፉሎኡ፤ ቴሱ ምንክ መር» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","እሴን ምንሴ ፈንቀልት መርቶ ወክት ጩሌችሴ ዶሮረኖ አያኑ ፉላን መዕነ አሌን ኦሰአን ደጎሴ። ");
INSERT INTO alw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ህትን ጢሮስ ባዲች ፉል ስዶን አዲን «ቶኑ ከተመ» ዬኖ ባዲን ህግ ገሊለ ባርበ አሜቾ። ");
INSERT INTO alw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ህከኔን መኑ መቱ ዶንቃለከ ዶንቀ እኮ መንቹ ኢስበ ኤቦኡ፤ እሰን ኢሰ ህከን መንች አሌን አንገስ አኦተ ኡጭቶስ። ");
INSERT INTO alw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ኢስ ህከ መንቹ መኒች አደ አዕይ ሜጥሀስ እሱ መስ ዙሩዕማስ ህከን መንች መጫን ኣግሾ፤ ህትን ኢስ አንጀስ ቱይ ህከን መንች አረብተ አንጋንከስ ሀጣዌእ። ");
INSERT INTO alw_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ኢስ ሰማ ዋሽ ኦሎሽ ቀልቤስ ሻዥ ህከ መንቹ «ኤፍታህ!» ዬስ፤ ፍሳረንትስ «ሂርተእ» ዩሃን። ");
INSERT INTO alw_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ህከ ወክትንከ መጨስ ፈንተኦኡ፤ ህትን አረብስ ሂርተኣን ጠሊሽ ጠወዕዮ። ");
INSERT INTO alw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ኢስን መኑ ህከ ጠወ አዬሃ ኩልታበእገ አዘዦሰ፤ እሁን ቤሉ ጠወኣበእገ ኩሎሰ ጌሰንከ ልግቤ መኒሃ ኩልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","እሰን አበ አጀብሲጭት «ጉዕመንከ ጠወ ጡመገ አዕዮ፤ ዶንቃኑት ሞጮጭታገለከ ዱዳኑት ጠወኣገ አአኖ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ህከን ታቦን ልግቡ መኑ ጭምዬእ፤ ህከን መኒሃ እታኢሁ ዮሰበአ እቅ፤ ህካን እኮቤቺሃ ኢስ አሳበስ እስበ ገእ ");
INSERT INTO alw_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«ኩ መኑ ኢን ሜጡበ ሰሱ በር አገርቶኡ፤ እሳንከ እታኢሁ ዮሰበእቤቺሃ አን አበ መረርሲጫንሰ። ");
INSERT INTO alw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ህት ጎራይቶገን ምንሰ መርታገ አዕዮንሰ ጎሬ ዎቃን አበ ሆጋአ፤ ህትን እሳችን መት-መቱሰ ቄዕራሺች አሜቶእራን» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","አሳበስ ፈንቀሽት «ህከረ ከን ኡለ ኡድማን ኬንከ መኒሃ እታኢሃ አይ ኣሶተ አታለኖ?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ኢስ አሳበስ ፈንቀሽ «ሄንኩ ጣብቱ ዮህዕኔ?» ይ ጠዕሜሰ፤ እሰን ፈንቀሽት «ለመሉ ጣብቱ ዮኔ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ህከ ወክት ኢስ መኑ ኡለ አሌን አፉዕለኖገ አዘዦ፤ ለመለንከ ጣብተ ኣእ መገኑ ገለትጭ ቢጥ መኒሃ ሆንጠህሶተ አሳባተስ ኣሴእ፤ እሰን መኒሃ ሆንጠህሶኡ። ");
INSERT INTO alw_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ህትን ቀዉት ቁርጩሜት ዮሰ እቅ፤ እሴንተ ኬሽ ኣእ መገኑ ገለትጭ አሳበስ መኒሃ ሆንጠህሶተ ኣሴእ። ");
INSERT INTO alw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","መኑንኩ እት ዱባን ፈቆሃ አሳበስ ለመለ መሶበ ዊመ ፉርፉሩ ኬሶኡ። ");
INSERT INTO alw_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ህካን እቾ መን ዎሊንሹ ሾሌ ኩሜሃ ጌሰ እቅ፤ እሰንተ ኢስ ህርስሾሰ። ");
INSERT INTO alw_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ህከ መነ ህርሲሾች ኤተሮን ኢስ አሳባንን ሜጡበ እክ ጀልባን ኣግ «ደልማኑተ» ዬኖ ባዱ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ፈርሳውት ኢስበ አሜት ሉሲሶተ «ሰሜች አጀብሲሰኖ ጠወ ለሊስኔ» ይት ኦዱ ጀመርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ህከ ወክት ኢስ ቀልቤስ ሻዥ «ከን ዘማን መኑ አጀብሲሰኖ ጠወ ሚሃ ሀሰኖት? ሀንቅንከ ያንክዕኔ፤ ከን ክልቀቲሃ አጀብሲሰኖ ጠዉ ኣሰመኖስበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","እሰንተ አጉር ጀልባን ኣግ ዉድ አደ ቶሎ። ");
INSERT INTO alw_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","አሳበት እሀኖሰ ጌሰ ጣብተ አፉዕናን ሀብ መቱ ጣብታ አፍ ጀልብ ኣዜን ሄኦ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ኢስን እሰንተ «ፈርሳዌለከ ሄሮድሴ ራጭቲች ጠረኝቴን አገዕርዬ» ይ አዘዦሰ። ");
INSERT INTO alw_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ህከ ወክት ገገዉንኩሰን «ህት ዩስ እቴኖሃ አንፉዕናን አሜንቶምቤቺሃት» ይት ገገዉንኩሰን ጠወኦኡ። ");
INSERT INTO alw_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ኢስን ሰውትሰ ደግ « ‹እቴኖሁ ዮኔበእቤቺሃት› ይቴን ሚሃት ሰውይቴነንታት? ቴሶ ኢለ መቱርቹሃ ደጌነንተበዕንዶ? ህከረንገ ኣገኖህዕኔበዕንዶ? ህትን ቀልቡክዕኔ ቴሶ ኢለ ዱጆዕትንዶ? ");
INSERT INTO alw_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","እልት ሄኦህዕኔገን ለኤነንተበእንዶ? ህትን መጨት ዮህዕኔገን ሞጮጭቴነንተበእንዶ? ሀት ሆሮን ሰውይቴነንተበአ? ");
INSERT INTO alw_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","አን ኦንቶ ኩሜ መኒሃ ኦንቱ ጣብተ ቢጭ ኣሰን ፈቆ ፉርፉሩ ሄንከ መሶበ ኬሴን?» ዬሰ፤ እሰን «ቶነ ለሞ መሶበ ዊመ» ይት ፈንቀሽቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ህትን ኢስ «ለመለ ጣብተ ሾሌ ኩሜ መኒሃ ቢጭ ኣሴምሀኒች ፈቆ ፉርፉሩ ሄንከ መሶበ ኬሴን?» ዬሰ፤ እሰን «ለመለ መሶበ ዊመ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ህካን እኮቤቺሃ ኢስ ፈንቀሽ እሰንተ «ቴሁ አጥራመቴነንተበእንዶ?» ይ ጠዕሜሰ። ");
INSERT INTO alw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ኢስ አሳበት «ቤተ ሰይዳ» ዬኖቤቹ ኢልቶ ወክት መኑ መቱ ቆቀ መንቹ ኢስበ ኤብ አንገስ አሌስ አኦተ ኡጭቶስ። ");
INSERT INTO alw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","እስን ህከ ቆቀ መንቹ አንገስ አፍ አዎንስ ቀኤች አብል ፉሼስ፤ ኢስን ህከን መንች እሌን አንጀ ቱይ እልስ አንጋን ሀጣው «ለአንትርቹ ዮዕንዶ» ይ ጠዕሜስ። ");
INSERT INTO alw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ሁኩ ቆቁንኩ ጌጥ ይ «ኤ! መነ ለኣሚት፤ ጠዉ እኮጎሬ ሃመኖ ሀቀ አጉደኖኤት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ለንኪሃ ኢስ ህከን መንች እሌን አንገስ አዕዮ፤ ህከ ወክት መንቹስ አጥራመች ለዕዮ፤ ህትን ፈይ ጉዕመርቹንከ አጥራመች ለኡ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ህከኒች ኤተሮን ህከ መንቹ ኢስ «ከ ቀእተ ኣጎት አዬሃ ከ ጠወ ጠወኦት» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ኢስለከ አሳበስ «ፍልጶስ ቄሳረ» ዬኖ ባዶን ዮ ቀእተ መርታኢት እቅ፤ ዎቄ አሌን ሄኦገን ኢስ አሳበስ «መኑ ኤሳሃ አዬት የኖኤሁ?» ይ ጠዕሜሰ። ");
INSERT INTO alw_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","አሳበስ ፈንቀሽት «መት-መቱ መኑ ‹ጠመቃንቾ ያህዪት› የኖሄት፤ ዎሉሰንገ ‹ነብዬቹወ እልያሴት› የኖሄት፤ ህትን ዎሉ መኑ ‹ነብያኖች መቱሃስ› የኖሄት» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ኢስ ፈንቀሽ «አዕኑ ኤሳሃ አዬት ይቴነንታት?» ይ ጠዕሜሰ፤ ጴጥሮስን «አት መሲሂት» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ህከ ወክት ኢስ እሰንተ «አዕኑ ኢተኔሃ አዬሃ ጠወኦኖቼ» ይ ጠረኝሽ አዘዦሰ። ");
INSERT INTO alw_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ኢስ አሳባተስ «መንች ቤቱ ልግብ ኦርሸተ ቶጉ ሀስሰኖስ፤ ህትን ባድ ባልቀት፥ ቂሳከ አዎንሳኑትለከ ሕግ አስተማረት ቶጉ ግብ ሽታስ፤ ጠዉ እኮጎሬ እስ ሰቅ በሬን ሬሆች ኬአኖ» የን ተማርሱ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ኢስ ህከ ጠወ ኣገኖሰገ ኩሎሰ፤ ህከ ወክት ጴጥሮስ ኢሰ መድ ዋሽ ኡሙዕሬስ። ");
INSERT INTO alw_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ጠዉ እኮጎሬ ኢስ ኤተሩ ፈንቀል አሳበስ ለአን ጴጥሮሴ «አት ሸይጣንቹ ኢች ካጳ ቄዕር፤ አት መን ሰዉት ቤሉ መገን ሰዉት ደጋንትበአ» ይ ሻቆስ። ");
INSERT INTO alw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ህከኒች ኤተሮን ኢስ ልግብ መነ አሳባንተስን ሜጡበ እስበ ገእ «ኤሳሃ አዎኖተ ኢተኖሁ ዮ ጎሬ ገይስተኔሃ ሰውዩ አጉር መስቀለስ እጅ አዎኑዕኔ። ");
INSERT INTO alw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ነብሳስ ጡምሶተ ሀሰኖሁ ጉዕሙንኩ ነብሳስ ቤሰኖ፤ ኢተኔሃለከ ተሽት ላገተኔሃ ነብሳስ ህግሽ ኣሰኖሁ ነብሳስ ጡምሰኖ። ");
INSERT INTO alw_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","አዪሁ ኣዱንያ አሌን ዮኢሃ ጉዕመንከ ደእ ነብሳስ ቤሾ ጎሬ መ ደግለለኖስ? ");
INSERT INTO alw_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ህትን መንቹ ነብሴስ ወጥ መ ባቶተ አታለኖ። ");
INSERT INTO alw_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ከን ጩበኛኖንለከ ለገአኖ ክልቀት ብሬን ኢንለከ ኢ ላጋን ሙለኖ መንች ቤቱ አንስ ኬዕምኚን ጠሊላኖ መላይካን ሜጡበ አሜተኖ ወክት እሲን ሙለኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ህከኒች ኤተሮን ኢስ «ሀንቅንከ ያንክዕኔ፤ ቴሱ ከኔ ኡርቶ መን በሊች መት-መቱሰ መገን ዎምነቱ ሎረ ወልቃን ገሸኖ ወክት ለኦተ ኢለ ሬታበእሩ ዮኡ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ሌሆ በሬች ኤተሮን ኢስ ጴጥሮሴ፥ ያቁበለከ ያህይ ሰሱንከሰ ኣእ ሎረ ቆተ አል ፉሎ፤ ህከኔን ኢስ ደኑ ብሬሰን ዶረሞ። ");
INSERT INTO alw_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ኢስ ኦድኑት ኣዱንያ አሌን አዪሁ ሜጭ ዋቅ አዕይ ዋጁ አአኖበእ ጌሰ ዋቅይት በለቆኡ። ");
INSERT INTO alw_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ህከ ወክት እልያስለከ ሙስ አሜት ኢሲን ሜጡበ ጠወአንን ሰሱንኩ አሳበት ለኦስ። ");
INSERT INTO alw_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ጴጥሮስ ኢሰ «አስተማርቾ! ከኔ ሄኡ ኔሳሃ አበ ጡመሃን፤ ህካን እኮቤቺሃ መቱ ኬሳሃ፥ መቱ ሙሲሃለከ መቱንገ እልያሴሃ ዳሰ እጃርኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ህከ ወክት ሰሱንኩ አሳበት አበ ዋጅቶቤቺሃ ጴጥሮስ ጠወአኖሃ ደገኖበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ጎመንት አሜት ቴልታን ጎማች ኣዚን «ኢታም ቤቱኤ ከኒት፤ እሱንከ ሞጮጭዬ» ይታ ላገተ ሞጮጨንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ወክትንከስ ሰሱንኩ አሳበት አደሰ ዘህት ለኣ ወክት እሳን ሜጡበ ኢስ ቤሉ አዪሁ ዮበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ቆተ አሊች ድርተን ኢስ «መንች ቤቱ ሬሆች ኬኦተ ኢለ ከ ለኤንተ ጠወ አዬሃ ጠወኦኖቼ» ይ አዘዦሰ። ");
INSERT INTO alw_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","እስን ዬሰ ጠወ ቀልቤሰ አፍ «ኩ ‹ሬሆች ኬኡ› ዩ መ ዩሀን» ይት ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","እሰን ኢሰ «ሕግ አስተማረት ‹ሄጭ አሜቱ ሀስሰኖሲሁ እልያሴት› ይታኢሁ ሚሃት?» ይት ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","እስን «ሁኩን ሀንቅሃን፤ እልያስ ሄጭ አሜች ጉዕመርቹንከ መክሰኖ፤ ጠዉ እኮጎሬ መንች ቤቱ አበ ኦርሸተ ቶገኖገለከ ህንቀመኖሃ እሁስ ጠሊለ መጻፋን ከተበሞሁ ሀትጎታን? ");
INSERT INTO alw_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ጠዉ እኮጎሬ አን ያንክዕኔ፤ እልያስ ሄጭ አሜቾኡ፤ እስተኔንከ ጠሊለ መጻፋን ከተበሞገን መኑ ሀሶገ አቶስ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ኢስለከ እሲን ሜጡበ ሄኦ ሰሱንኩ አሳበስ ፈንቀልት አሜቶ ወክት ልግቡ መኑ ፈቆ አሳባን ጭምይሃን ህከኔን መት-መቱ ሕግ አስተማረት ኢስ አሳባን ኦዳኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","መኑ ጉዕሙንኩ ኢሰ ለኦ ወክት አበ አጀብሲጭቶኡ፤ ህትን እስበ ደጉድ መርት ዝያርቶስ። ");
INSERT INTO alw_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ኢስን አሳበስ «መ ጠዋኒት ኦዴነንታሁ?» ይ ጠዕሜሰ። ");
INSERT INTO alw_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ህከን ልግብያ ኡመቲች መቱ መንቹ «አስተማርቾ! ዱሩ አፍ ጠወኡ ከሞ ጩልኤ ኪቤቹ ኤቦም። ");
INSERT INTO alw_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ሁኩ ዱሩ ኬዕዮስ ወክት ኡጀኖስ፤ ህትን አፌን ሁንብ ኩፍ አአን እንኩተ እጥሲሰኖ፤ አልስ ክቺች አዕይ ሞሸኖስ፤ ህካን እኮቤቺሃ ህከ ዶሮረኖ አያነ ፉሽቶተ አሳበክ ጠዕምዮም እቅ፤ ጠዉ እኮጎሬ እሰ ፉሽቶተ አታልቶበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ኢስ እሰንተ «አዕኑ አመዕነቱ ዮህዕኔበእ መኑ፤ ሄንከ በር ኢለ ክዕኔን ሜጡበ ሄኣም? ሀከ በር ኢለ አታላንክዕኔ? ህንዴ ጩል ኢበ ኤቤ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","እሰን ጩል እስበ ኤቦኡ፤ ሁኩ ዶሮረኖ ዱሩ ኢሰ ለዕዮ ወክት ጩል ኡለ አሌን ኡጅ ከጣቀንሴስ፤ ጩሉንኩ ኡለ አሌን ኮሎንኮዕለን አፎንከስ ሁንብ ኩፍ አኡ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ኢሲን ህከን ጩል አነ «ኩ ጥዘነት አፎሲች ሄንከ ዘማን እኮስ?» ይ ጠዕሜስ፤ እስን ፈንቀሽ «ኦስማችስ ኬሺት። ");
INSERT INTO alw_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ኩ ዶሮረኖ ዱሩ ሾተ ሀሽ ልግብ ወክት ጊራንለከ ዋን ኡጀኖስ፤ ጠዉ እኮጎሬ መቱርቹ አኡ አታልታንት ጎር መረርሲጭኔ! ሀዕልኔሁ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ኢስን «ሀት አታልታንት ጎሬ ይታንቴኤት? አመዕነኖሀኒሃ ጉዕሙርቹንኩ አታለመኖስ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ህከ ወክት ጩል አኑ ኢሰ «አመዕኑ አመዕናም፤ ጠዉ እኮጎሬ አመዕኑ ሆጋም ጠዊሃ ጉዕሚንከስ ቴሁ አት ሀዕሌኤ!» የን ያሮ። ");
INSERT INTO alw_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ኢስን መኑ ደጉደን አሜተኖገ ለዕዮ ወክት ህከ ዶሮረኖ ዱር «አት ዱዱለከ ዶንቁ ዱሩ ከን ጩሊች ፉልት ለንኪ እስበ ፈንቀልት አሜታንትበእገ አዘዦንኬ» ይ ሻቆስ። ");
INSERT INTO alw_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ሁኩ ዶሮረኖ ዱሩ ሎረ ላጋን ያር ጩል መቱ ጌሰ ኡጅ ከጣቀንሴሲች ኤተሮን ፉሎ፤ ህከ ወክት ጩሉስ ደሜቤቺሃ መኑ «ሬዮ» ይ ሰውዬእ። ");
INSERT INTO alw_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ጠዉ እኮጎሬ ኢስ ጩል አንገተ አፍ ኬሻንስ ኬዕይ ኡሬእ። ");
INSERT INTO alw_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ኢስ ምኒ ኣጎ ወክት አሳበስ «ነኡ ከ ዶሮረኖ ዱር ፉሽኖተ አታልናምበኢሁ ሚሃት?» ይት ሜጡስ ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ኢስን እሰንተ «ህትናሙርቹ ዱኢንለከ ሶመኒን እህባች ዎሎርቺን ሆሮን ፉሎተ አታለኖበአ» ይ ፈንቀሼሰ። ");
INSERT INTO alw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ኢስለከ አሳበስ ህከ ቤቹ ጌኝአት ገሊለ አዲን ህጎኡ፤ ኢስ ዮቤቹንከ አዪሁ ደጎተ ሀሾበ እቅ፤ ");
INSERT INTO alw_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ሁኩን እኮሁ ኢስ አሳበስ «መንች ቤቱ መን አንጋን ህግሴን ኣሴኖስ፤ እሰን ሽታስ፤ ጠዉ እኮጎሬ ሬሆች ሰቅ በር ኬአኖ» የን ተማርሴሰ። ");
INSERT INTO alw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","አሳበስ ኩ ጠዉ ኣጎሰበአ፤ ጠዉ እኮጎሬ ጠዕምቶስተ ዋጅቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ኢስለከ አሳበስ ቅፍርናሆም ከተመ አሜቶኡ፤ ኢስ ምኒ ኣጎች ኤተሮን አሳበስ «ዎቃን ሄኤንተ ወክት ኦዴነንተ ጠዉ መርቹሃን?» ይ ጠዕሜሰ። ");
INSERT INTO alw_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ጠዉ እኮጎሬ እሰ ዎቃን «ጉዕሚችኔ በተአኖሁ አዬት?» የቀንቶቤቺሃ መስለ ኣቶስበአ። ");
INSERT INTO alw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","እስን አፉዕሌኢች ኤተሮን ቶነ ለሙንከ አሳበስ እስበ ገእ «ዎኔሃ እሆተ ሀሰኖሁ ጉዕሙንኩ ጉዕሚንከ ካድመለከ ጉዕሚችን ቀዉ እሁ ሀስሰኖስ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","መቱ ቀዉ ጩል ኤብ በላንከሰ ኡርሾ፤ ህከ ጩልንከ ሀንቀፍ ");
INSERT INTO alw_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«ከን ጩልገ ዮኢሃ ሱዕሚንከኤ ቶገኖሁ ኤሳሃ ቶገኖኤ፤ ኤሳሃ ቶገኖሁ ጉዕሙንኩ ጠለዕል ኤሳሃ ቶጉ እሁዕነ ኤሳሃ ሶኮንከ ሜጡበ ቶገኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ጠዉ እኮጎሬ ያህይን ኢሲሃ ፈንቀሽ «አስተማርቾ መቱ መንቹ ሱዕሚንከክ ሩሃንየ ፉሸን ለዕን ኒን ሜጡበ እክ አዎንበኔቤቺሃ ከሞንስ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ጠዉ እኮጎሬ ኢስ «ሱዕሚንከኤ አጀብሲሰኖ ጠወ አአን ወክትንከስ ኢ አሌን ሂለርቹ ጠወአኖሁ ዮበእቤቺሃ አጉሬ፤ ከንቶኖቼስ። ");
INSERT INTO alw_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","መሰንትስ ኒን ሀንበዕለምባሁ ጉዕሙንኩ ኒንት። ");
INSERT INTO alw_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ሀንቅንከ ያንክዕኔ፤ መሲህሃ እኬንተቤቺሃ ሱዕሚንከኤ መቶ ቡርጩቆ ዋሃ አጎተ ኣሰኖሁ አዪሁ ወጥስ ደአኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ኢስ «ኢን አመዕንቶ ከን ማዕናኖች መቱስ ሉሲሰኖ መንቹ ሎረ ሪትም ክኑ ጎባንከስ ኡሱሬን ባራን ቶረሙስ ቆሀኖ። ");
INSERT INTO alw_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ህካን እኮቤቺሃ አንገክ ሉሲሳሄትጎሬ ሙርት ኡጅ፤ መሰንትስ ለምት አንገት ሄኣንኬ አዛቤን ዘላለሚሃ ጠዕትበ ጊራን ኣጊች አንገክ ሙርተኣን ነብሴን ሄኤን ሄኡ ደኡ ቆሀኖ። ");
INSERT INTO alw_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ህከን ቤቾን እሰተ እታ ዘቡዕሉት ሬታበአ፤ ህትን ጊረሲ ሆሮ ጠእታበአ። ");
INSERT INTO alw_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ህትን ሎከክ ሉሲሳሄትጎሬ ሙርት ኡጅ፤ ለም ሎከት ሄኣንኬ አዛቤን ዘላለሚሃ ጠዕትበ ጊራን ቶሬኖሄሀኒች ድኑ እክ ነብሴን ሄኡ ደኡ ቆሀኖሄ። ");
INSERT INTO alw_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ህከን ቤቾን እሰተ እታ ዘቡዕሉት ሬታበአ፤ ህትን ጊረሲ ሆሮ ጠእታበአ። ");
INSERT INTO alw_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ህትን እልክ ሉሲሳሄትጎሬ ፉሽት ኡጅ፤ መሰንትስ ለም እልት ሄኣንኬ ዘላለሚሃ ጠእትቡ ጊራን ቶሬኖሄሀኒች መት እላሙ እክ መገን ዎምነቴን ሄኡ ቆሀኖሄ። ");
INSERT INTO alw_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ህከን አዛቤን እሰተ እታ ዘቡዕሉት ሆሮን ሬታበአ፤ ህትን ጊረንት ሆሮን ጠእታበአ። ");
INSERT INTO alw_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«ክትሙ መጥኔን ነጠ እሀኖ ሀንገን ");
INSERT INTO alw_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","መጥንት ጡመተ፤ እሁን ቤሉ መጥንት እሁሴ ጤእባች ሀት አቴን ጤኣገ አቴነን? ክዕኔንከ መጥኔ ጤዕንሹ ሄኡንክዕኔ፤ ገገዉንኩክዕኔ ኢተቀንቴን ወገሬቲን ሄዕዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ኢስ ህከንቤቺች ኬዕይ ይሁድ ባዱ ህግ ዮርዳኖስ ዛዘኖ ዊች ገርብ አዲን ቶል ኦሮዕዮ፤ ልግቡ መኑ ለንኪሃ እስበ ጭምይታን ወዕና ሮሾገን ተማርሰኖሳት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ፈርሳዌች መት-መቱሰ ኢሰ ሉሲሶተ ሀስ አሜት «መቱ መንቹ ጫስ ገፈሮተ ሕግን ፈቀደመኖስንዶ?» ይት ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ኢስን ፈንቀሽ «ሙስ ከን ጠዊሃ መ አዘዦህዕኔ?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","እሰን «ሙስ ‹እሴንከ ንከሴ ሂር ሸሩን› ይ አዘዦኔ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","እኮጎሬ ኢስ እሳሃ ፈንቀሽ «ሙስዕኑ ከ ትዛዝ ከተቦተ አታሎሁ ቀልቡክዕኔ ዱጃን ሞጮጭቴነንተበእቤቺሃት ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ጠዉ እኮጎሬ መገኑ ወዕና ክልቀት ከለቆ ወክት ለባለከ ሜኣተ አዕይ ከለቆ። ");
INSERT INTO alw_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ህካን እኮቤቺሃ መኑ አነስለከ አመስ አጉረኖ ምንስ አማን ሜጡ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ህትን ለሙንኩሰ ሜጡ ጅስመ እካኣ፤ ህከኒች ኤተሮን እሰ ሜጡ ጅስመ እካ ቤሉ ለሙ ጅስመ እካበአ። ");
INSERT INTO alw_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ህካን እኮቤቺሃ መገኑ ሜጡ አዕዮሃ መኑ መለሉንከሰ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","እሰን ምኒ ፈንቀልት አሜቶ ወክት አሳበስ ህከን ጠውተኔሃ ፈንቀልት ኢሰ ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","እስን «ጫስ ገፈር ዎሉ ሜንቱ ኣአኖሁ ጉዕሙንኩ እሴ አሌን ዝነተ አዕዮኡ። ");
INSERT INTO alw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ህትን ምንሴ መንቺች ፉልት ዎሉ ጎነ ኣግሶ ጎሬ እሴሁ ዝነተ አቶኡ ዩሃን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","መት-መቱ መኑ እለሰ አሌን አንገተ አዕይ ማሰኦሰተ ኢስበ ኤቦኡ፤ ጠዉ እኮጎሬ አሳበስ ህከ ኦሱተ ኤቦ መነ ሻቆኡ። ");
INSERT INTO alw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ኢስን ህካን ለዕዮ ወክት አሳበስ ኡሙዕር «መገን ዎምነቱ ከኑኡገ ዮሀኑኡተ እኮቤቺሃ ኦሱት ኢበ አሜቱን ከንቶኖቼ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ኢስ «ሀንቅንከ ያንክኔ፤ መገን ዎምነቱ ኦሶገ እክ ቶግባሁ መገን ዎምነቱ ኣጎተ ሆሮ አታለኖበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ህከኒች ኤተሮን ኦሱተ ሀንቀፍ አንገስ አሌሰ አዕይ ማሰዕዮሰ። ");
INSERT INTO alw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ኢስ ህከን አዲች ፉል ሃመን ሄዕዮገን መቱ መንቹ እስበ ደጉደን አሜች ብሬስ ጉሉጵ «መረርሲጭታንት አስተማርቾ! ጉዕመ ዘማን ሄኡ ደኦተ መ አኡ ሀስሰኖኤ?» ይ ጠዕሜስ። ");
INSERT INTO alw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ኢስን ፈንቀሽ «ሚሃት መረርሲጫንቾ ይታንቴኤሁ? ሜጦ መገን ቤሉ መረርሲጫንቹ አዪሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ትዛዝ ደጋንት፤ ትዛዙንኩ ‹ሽቶት፥ ዝነተ አቶት፥ ሞግቶት፥ ጩብ መሰከርቶት፥ ጣንስቶት፥ አነክለከ አመክ ከበጅ› የኖሃን» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ሁኩ መንቹንኩ ፈንቀሽ «አስተማርቾ! አን ከ ትዛዝ ጉዕመንከ ኦስማችኤ ኬሽ አገሮም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ኢስን ህከ መንቹ ለዕይ እሱንከ ኢቴስ፤ «መቱ ጠዉ ጠለዕሉ ፈቆሄ፤ እስን መርት ዮሄ ዱንያክ ጉዕመንከ ህርት ብረስ ቡጥቻኖተ ኣስ፤ አት ሰማን ጭምይቶ ዱንያተ ደእታንት፤ ህከኒች ኤተሮን አሜት ኤሳሃ አዎንት ኢች ተማር» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","መንቹንኩ ከ ጠወ ሞጮጬ ወክት ልግቡ ዱንያት ዮስቤቺሃ ሚንተ በዕይ ሻዘን ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ህከ ወክት ኢስ አሳበስ ዘህ ለዕይ «ቀባጣሙ መኑ መገን ዎምነቱ ኣጉ ሀትኔታ ኦርሸ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","አሳበስ ላጋንተስ አጀብሲጭቶኡ። ኢስን ፈንቀሽ «ኢ ኦሶ መገን ዎምነቱ ኣጉ ሀት ኦርሰኖሃን? ");
INSERT INTO alw_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ቀባጣሙ መገን ዎምነቱ ኣገኖ ዪች ጋሜሉ መርፌ ጠላዕላን ህገኖ ዩ ቆሀኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ህከን ጠዋን አሳበስ አበ አጀብሲጭት ገገዉንኩሰን «ከን ሃሌን አይ ጡሞተ አታለኖ?» የቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ኢስን እሰ አደ ለዕይ «መኒሃ አታለምቡ መገኒሃ አታለመኖ፤ መሰንትስ መገኒሃ ጉዕሙርቹንኩ አታለመኖስ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ጴጥሮስን «ነኡ ጉዕመርቹንከ አጉርን አዎኖንኬ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ኢስን «ሀንቅንከ ያንክዕኔ፤ ኢተኔሃለከ እንጂልተኔሃ ምንስለከ አመስ ኦሱተ፥ ላባኑተለከ ሜኣኑተ፥ አመስለከ አነስ፥ እለስለከ ኡለስ አጉረኖሁ በትሽ አበ ደአኖ። ");
INSERT INTO alw_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ከን ዘማኔን ሆሮ ምንስለከ አመስ ኦሱታ፥ አማኑስለከ እለስ፥ ኡለስ አመዕነትተኔሃ ያየም ኦርጨቀሞጎሬ ጥቤ ለሙ አፎ ደአኖ፤ ህትን አሜተኖ ኣኬሩ ዘማኔን ጉዕማን ጎፍበ ሄኡ ደአኖ። ");
INSERT INTO alw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ጠዉ እኮጎሬ ልግቡ ብሬሩ ኤተርረ ህትን ልግቡ ኤተርሩ ብሬረ እካአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ኢስለከ አሳበስ ዬሩሳሌመ መሰኖ ዎቃን ሜጡበ ሄኦገን ኢስ እሰ ብሬን ሃመኖ እቅ፤ አሳበስ አጀብሲጭቶኡ፤ ህትን ኤተርስ አዲን አዎንተን ሄኦ መኑ ዋጅቶ እቅ፤ ኢስ ቶነ ለሙንከ አሳበስ ለንኪሃ እስበ ሆንጠህሽ ኢልታሰ ኦርሸተ ኩሎሰ። ");
INSERT INTO alw_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ኢስን እሰንተ «ሁኩዕኑን! ቴሱ ዬሩሳሌመ መርናሚት፤ ህከንቤቾንን መንች ቤቱ ቂስ አዎንሳኖተለከ ሕግ አስተማረተ ህግሴን ኣሴኖስ፤ እሰን ሬሆ ፍርደ ፈረድ አይሁደ እህበ መኒሃ ህግስ ኣታአ። ");
INSERT INTO alw_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","እሰን ቀለዳስ፤ አንጀ ቱ ይታስ፤ ኦልታስ፤ ሽታስ፤ ጠዉ እኮጎሬ እስ ሰቅ በር ሬሆች ኬአኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ዜብዴዎሴ ኦሱት ያቁብለከ ያህይ ኢስበ ሆንጠክ «አስተማርቾ! ኡጭናንኬ ጉዕመርቹንከ ኣቶኔተ ሀንሳም» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ኢስን «መ አኦህዕኔተ ኢትቴነን?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","እሰን «ኬዕምኝክ ዎምነቴን መቱኔ መኬ አዲን መቱኔ ጉረ አዲን አፉዕልናምገ አእኔ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ጠዉ እኮጎሬ ኢስ እሰንተ «ኡጭቴነንታሃ ደጌነንተበአ፤ አን ቶጋም ኦርሸ ጠበትተ ቶጎኖተ አታልቴነንንዶ? ህትን አን ጠመቀማም ጥምቀት ጠመቀሙ አታልቴነንንዶ?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","እሰን ፈንቀሽት «ኤ አታልናም» ይቶኡ፤ ህትን ኢስ ፈንቀሽ «አን ቶጋም ኦርሸ ጠበቴሃ አዕኑ ቶጎኖተ አታልቴነንተ፤ ህትን አን ጠመቀማም ጥምቀት ጠመቀንቴነንተ። ");
INSERT INTO alw_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","እኮጎሬ ኢ መኬ አዲንለከ ጉረ አዲን አፉዕሌኖገ አኣሚሁ አኔበአ፤ ጠዉ እኮጎሬ ሁኩ ቤቹ መገኑ ቅጥ አዕዮሰሀኑኡሃ ኣሰመኖሃን» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ፈቆ ቶኑንኩ አሳበት ህካን ሞጮጭቶ ወክት ያቁበለከ ያህይ ኡሙዕርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ህከ ወክት ኢስ እሰንተ እስበ ገእ «አይሁደ እህበ ኡመቲሃ ዬን ገኤኖሰገለከ አዎንሳኑሰን እሰ አሌን ሹምነቱ ዮሳሃ እሁስ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ጠዉ እኮጎሬ ክዕኔቤቾን ህት እሁ ሀስሰኖበአ፤ አዪሁ ክዕኔ በላን ሎረ እሆተ ኢተኖሁ ሄዕዮ ጎሬ ክዕኔንከ ካዲንቹ እሁ ሀስሰኖስ። ");
INSERT INTO alw_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ህትን ክዕኔ በላን ዎኔሃ እሆተ ሀሰኖሁ ጉዕሚንከክዕኔ ሮስቹ እሁን። ");
INSERT INTO alw_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ህትን መንች ቤቱ ካደሞተለከ ነብሳስ ልግብያ መኒሃ ዎዥ ኣሶተ አሜቾ ቤሉ እስ ካደሞኖስተ አሜቾበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ህከኒች ኤተሮን እሰን ኢያርኮ ከተመ አሜቶኡ፤ ኢስ አሳበስ ልግብያ መኒን ሜጡበ ኢያርኮ ከተሚች ፉለንን ጤሞሴ ቤቱ «በርጤሞሴ» ዬኖ ቆቁ ዎቄ መዴን አፉዕል ኡጨኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ህከን አዲን ህገኖሁ ነዝሬት ኢሰ እሁስ ሞጮጬ ወክት «ደዉዴ ቤቶ ኢሰ! ሀዕይ መረርሲጬኤ» የን ያሩ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ኢሰ አዎንተን ሄኦ መኑ «ጨለይ» ይት ኡሙዕርቶስ፤ ጠዉ እኮጎሬ እስ «ደዉዴ ቤቶ ሀዕይ መረርሲጬኤ» የን ወዕኔች በትሽ ያሮ። ");
INSERT INTO alw_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ኢስን ኡር «ገእዬስ» ዬእ፤ እሰን ህከ ቆቀ መንቹ «ቴ ጠረኝ ኬእ፤ ኢስ ገአኖሄት» ይት ገእቶስ። ");
INSERT INTO alw_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","እስን ኦደዕዮ ኦድኑስ ኡጅ ኡር ኮርጀን ኬዕይ ኢስበ አሜቾ። ");
INSERT INTO alw_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ኢስን «መ አኦሄተ ሀሰን?» ይ ጠዕሜስ። ሁኩ ቆቁንኩ መንቹ «አስተማርቾ! ሀዕይ እልኤ ለኣገ አኤኤ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ኢስን «ቴ ኦሮእ፤ አመዕነቱክ ፈይሾሄ» ዬስ፤ ወክትንከስ እልስ ፈንተኣን ለዕይ ኢሰ አዎኞ። ");
INSERT INTO alw_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ኢስለከ አሳበስ ዬሩሳሌመ ሆንጠኮ ወክት ቤተ ፋጌለከ ቢታን ከተም አዲን ዘይት ሀቁ ነጰኖ ቆተበ ኢልቶኡ፤ ህከንቤቺች ኢስ አሳባች ለሙሰ ");
INSERT INTO alw_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«ብሬ አዲን ዮ ቀዕየተ መሬ፤ ህከ ቤቹ እልቴንተ ወክት አዪሁ ሆሮን ቆጶበእ ወተረ ኡሱረሞሃ ደጌነንተ፤ እሱንከ ሂርቴን ኤቤኤ። ");
INSERT INTO alw_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","አይደጎ አዪሁ ‹ካን ሚሃ አቴነንታት?› ዬህዕኔጎሬ ‹ቀርቹ ሀሾቤቺሃት፤ እስን ደዕል ፈንቀሽ ሶሀኖህዕኔ› ይዬ» ይ ሶኮሰ። ");
INSERT INTO alw_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","እሰን መርት ዎተሩስ ዎቄ መዴን ኡሮ ቀፈቴን አሱረሞሃ ደግ ህርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ህከ ወክት ህከኔ ኡሬ መኒች መት-መቱሰ «ከ ዎተረ ሂርቴነንታሁ ሚሃት?» ይት ጠዕምቶሰ። ");
INSERT INTO alw_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","እሰን ኢስ እሳሃ ዬገን ይት ኩልቶኡ፤ ሁኩ መኑንኩ «መስዬ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","አሳበስ ዎተረ ኢስበ ኤብ ኦድኑሰ ዎተር ጉጅ አሌን አታን ኢስ ቆጶ። ");
INSERT INTO alw_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ልግቡ መኑ ኦድኑሰ ዎቃን ዌሳኢት እቅ፤ ዎሉሰንገ ቆጢች ሀቅ ሀበረ ተንቅሰን ዌሳእት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ብሬ አዲን ሃንተን ሄኦእሩለከ ኤተር አዲን አዎንተን ሄኦ ጉዕሙንኩ «መገኒሃ ኬዕምኙ እሁን! ቀርች ሱዕሚን አሜተኖሁ ማሰአሞሃን። ");
INSERT INTO alw_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","አሜተኖ አንኔ ደዉዴ ዎምነቱ ማሰአሞሃን፤ መገኒሃ ኬዕምኙ አሌ ሰማን እሁን» ይተን ሎረ ላጋን ገለትጭታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ኢስ ዬሩሳሌመ ኢሌ ወክት ዱአ አኤኖ ምኒ ኣጎ፤ እስን ህከኔ ዮ ጉዕመርቹንከ ለዕዮ፤ ጠዉ እኮጎሬ ኡለት ሀዎርቶቤቺሃ ቶነ ለሞንከ አሳባን ቢታን ከተመ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ለንክ በር ቢታን ከተሚች አሜተንን ኢሰ ጎሩ አፎስ። ");
INSERT INTO alw_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","እስን ሀበረ ለቶ ኦድ ሀቁቹተ ቄዕራሻን ለዕይ «አይደጎ ላልቹ ዮሴ ጎሬ» ይ እሴበ ኦሮዕዮ፤ ጠዉ እኮጎሬ ህከ ኦድ ሀቁቾበ ሆንጠኮ ወክት ኦዱ ላለኖ ወክቱ ኢልዮበእቤቺሃ ሀበር ቤሉ ላልቹ ዮሴበ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ህካን እኮቤቺሃ ኢስ ኦድ ሀቁቹተ «አዪሁ ከኒች ኤተሮን ኪች ላልቹ እቱንከ» ዬሴ። ህካን ጠወአንን አሳበንት ሞጮጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","እሰን ዬሩሳሌመ ኢልቶ ወክት ኢስ ዱአ አኤኖ ምኒ ኣግ ምንስ ኣዜን ህርታእረለከ ህዕርታእረ ፉሼእ፤ ብረ ዶርተ መን ጠረጴዘተለከ ሀንደዕርተ ህርታ መን ቦርጭመተ ገለበጮ። ");
INSERT INTO alw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ኢስ አዪሁ ዱአ አኤኖ ምኒ ግቤ ኣዚን መቱርቹሃ እጅ ህገኖበእገ አዘዦ። ");
INSERT INTO alw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ህትን ኢስ እሳሃ « ‹ምኑኤ ኡመቱ ጉዕሙንኩ መገኑ ኡጨኑወ ምኒ› የመም ጠሊለ መጻፋን ከተበሞበእንዶ? እኮጎሬ አዕኑ ሽፍጥ ቆጠ አቴንታአ» ይ ተማርሴሰ። ");
INSERT INTO alw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ቂስ ሀለቀትለከ ሕግ አስተማረት ህካን የን ሞጮጭቶ ወክት እሱ ሽታ ዎቃሃ ሀሶኡ፤ እኮጎሬ እስ ተማርሰን መኑ ጉዕሙንኩ ትምርቴንከስ አጀብሲጬቤቺሃ ዋጅቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ኢስለከ አሳበስ ኡለት ሀዎርቶ ወክት ከተሚች አብል ፉልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","እሰን ለንክ በር ሱጵተ ዎቄን ህገን ኦድ ሀቁቹት ጠጰሴ ኢለ ሞልቶኢሃ ለኦኡ። ");
INSERT INTO alw_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ጴጥሮስን ጠወስ ሰውይ ኢሰ «አስተማርቾ ከለእ! አት ቦሮርቶንትሴ ኦድ ሀቁቹት ሞልቶኡ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ኢስን እሰንተ «መገኖን አመዕንዬ። ");
INSERT INTO alw_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ሀንቅንከ ያንክዕኔ፤ አዪሁ ቀልቤንከስ ሸኩዕናን ዬኢሁ ጉዕሙንኩ እሀኖገ አመዕን ከ ቆተተ ‹ከንቢች ኬእ ባራን ኡብ› ዬጎሬ እሀኖስ። ");
INSERT INTO alw_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ህካን እኮቤቺሃ አን ኩላንክዕኔ፤ አዕኑ መገኑ ኡጭቴነንተርቹ ጉዕሙንኩ ክዕኔሃ ኣሰመኖህዕኔገ አመዕንቴንተጎሬ ክዕኔሃ ኣሰመኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","አዕኑ ዱአ አኢሃ ኡርቴነንተ ወክት አዬ አሌኒ አፌንተ ገዱተ አጉሬ፤ ህካን እኮቤቺሃ ሰማን ዮ አኑክዕኔ ጩብክዕኔ አጉረኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ጠዉ እኮጎሬ አዕኑ መኑ በደሎህዕኔሃ አጉርቴንበጎሬ ሰማን ዮ አኑክዕኔ ክዕኔ ብድልሃ አጉረኖበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ኢስለከ አሳበስ ለንኪሃ ዬሩሳሌመ መርቶኡ፤ ህከኔ ኢስ ዱአ አኤኖ ምኔን ፈንቀላመን ቂስ አዎንሳኑት፥ ሕግ አስተማረትለከ ባድ ባልቀት እስበ አሜት ");
INSERT INTO alw_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","«ከ ጠወ አታንቲሁ መ ሹምነቲንት? ህከረንገ ካን አታንት ወልቀተ ኣሴሄሁ አዬት?» ይት ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ኢስን እሳንከ ፈንቀሽ «አን መቱ ጠወ ጠዕማንክዕኔ፤ አዕኑ አን ጠዕሜምርቹ ፈንቀሽቴንተጎሬ አን መ ወልቃን ከ ጠወ አኣሚት ጎሬ ኩላንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ህንዴ ኩሌኤ፤ ያህይ ጠመቀኖ ጥምቀቱ መገኒችትንዶ ህከረንገ መኒችት?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ህከ ወክትንከ እሰን «መ ይኑ?» ይት ገገዉንኩሰን አማዕለንት « ‹መገኒችት› ይኖምጎሬ ‹ሚሃ ያህይን አመዕንቴነንተበአ?› የኖኔ። ");
INSERT INTO alw_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","‹መኒችት› ይኑንዶ?» ይቶኡ፤ ህካን ይታበእገ ኡመቱ ጉዕሙንኩ ያህይ «ነብዬቹወ» የኖቤቺሃ መነ ዋጅቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ህካን እኮቤቺሃ እሰን ኢስሃ «ነኡ ደንጋምበአ» ይት ፈንቀሽቶኡ፤ ኢስን እሰንተ «አን ካን መ ወልቃን አኣሚት ጎሬ ኩላንክዕኔበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ኢስ እሳንከ ማቆን መቱ ወክት መቱ መንቹ ወይነ ዬኖ ላልቹ ካሾ፤ ህከቤቹንከ ዘህሽ ኦች ላልቹስ ጩንሼኖ ኤሎ እም ወይነ አገረኖሀኒሃ ሀንሸሩ እጃር መክሾ፤ ህከኒች ኤተሮን ሁኩ መንቹ ወይነስ ቀባኖተ ኣስ ቄዕራሸ ባዱ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ወይኑስ ላለኖ ወክት ካድንቹስ መር ላልቺችስ ኤቦተ ቀባኖበ ሶኮ። ");
INSERT INTO alw_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","እሰን ህከ ሶሄመ ካድንቹ አፍ ኦልት መቱርቹሃ ኣቱዕናን ኦነስ ሸርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ለንኪሃ ወይንስ አኑ ዎሉ ካድንቹ ሶኮ፤ ቀባኑስ ህከ ካድንቹ ቡዕለስ ፍልት ጡላይስ ሆፍስስ ሸርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ህትን ወይንስ አኑ ዎሉስ ሶኮረ ሽቶኡ፤ ህትን ልግብ መነ ሶኮረ መት-መቱሰ ዎቃርቶኡ፤ ዎሉሰንገ ሽቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ቴሁ መንቺሀስ ፈቆሁ ኢተኖ ቤቱስ ሶኋን፤ ህካን እኮቤቺሃ «ኢ ቤቱ ከበጅታስ» ይ ሰውይ ኤተሮን ቤቱስ ቀባኖስበ ሶኮ። ");
INSERT INTO alw_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ጠዉ እኮጎሬ ሁኩ ቀባኑት ገገዉንኩሰን «ከለዕዬ! ኡለስ ረገአኖሁ ከኒት፤ ህካን እኮቤቺሃ አሜ እሱ ሽኖ፤ ነኡ ኡለስ ረገዕናም» የቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","እሰን እሱ አፍ ሽት ወይን አቡረ ኣዚች አብል ፉሽት ቶርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ህካን እኮቤቺሃ ሁኩ ወይንስ አኑ መ አአኖ? አሜች ህከ ቀባኑስ ሽ ወይነስ ዎሎ መኒሃ ኣሰኖ። ");
INSERT INTO alw_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ጠሊለ መጻፋን «ግንበኛኑት ህንቆ ክኑ እስ ሙረበ ቡዕል ክኑ እኮ። ");
INSERT INTO alw_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ሁኩንን ቀርችተ ሆጉ፤ ሁኩ ሆጉንት እሌተኔ አጀብሲሳእታን የመም ከተበሞሃ አነበቤንታበእንዶ?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","አይሁድ ሀለቀት ኢስ ጠወዕዮ ምሳልተ እሰንተ ለአኖሃ እሁስ ደጎቤቺሃ አፎተ ሀሶ እቅ፤ ጠዉ እኮጎሬ ኡመት ዋጅቶቤቺሃ አጉርት መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ጠወአኖ ጠዊን ሉሲሶተ መት-መቱ ፈርሳውትለከ ሄሮድሴሃ እሉ እሀኖ መነ ኢስበ ሶኮኡ። ");
INSERT INTO alw_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","እሰን እስበ አሜት «አስተማርቾ! መቱ አደ ጎልቱዕናን ሀንቅ መገን ዎቃሃ ተማርሲታንትሃን፤ አት ሀንቅ አታንቲሃ እሁክ ደንጋም፤ ሮም ዎሚሃ ግብር ባቱ ገበአኑሃንዶ ገበእበሃን? ግብር ባንቱንዶ ህከረንገ ባንቱንከ?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ኢስን እሰ ሂለ ጠወ ደግ «ሚሃ ሉስሶኖኤተ ሀሴነንታት? ህንዴ ዲናረ ኤቤ ለኣም» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","እሰን መቱ ዲናረ ኤቦኡ፤ እስን እሰንተ «ከን ዲናር አሌን ዮ ፎቱትለከ ከተበሞ ሱዕሙሁ አዬሃን?» ዬሰ፤ እሰን «ቄሳርየ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ኢስን ፈንቀሽ «ህካን እኮች ዎሚሃ ዎሚንከ ህትን መገኒሃ መገኒንከ ኣስዬ» ዬሰ፤ እሰን ጠዋንከስ አጀብሲጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","«ሬዮ መኑ ሬሆች ኬአኖበአ» ይታ ሰዱቃውት ኢስበ አሜት፤ ");
INSERT INTO alw_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«አስተማርቾ! ሙስ ‹መቱ መንቹ እለተ እሉዕናን ሬዮ ጎሬ ህከን ሬዮ መንች አመስቤቱ ጫስ ረገዕይ ህከን ሬዮ መንቺሃ እለተ እሉን› ይ ከተቦኔ። ");
INSERT INTO alw_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","መቱ ወክት ለመሉ አመኦሱት ሄኦ እቅ፤ እሳችን ሀንገፉስ ጫተ ኤብ እለተ እሉዕናን ሬዮ። ");
INSERT INTO alw_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ህትን ለንክሁ ህተ ጫተ ረገዕይ እሉዕነ ሬዮ፤ ሰቂሁ ህትን እኮ። ");
INSERT INTO alw_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ከን ሃሌን ለመሉንኩ ህተ ጫተ ረገእ እልቱዕናን ሬቶኡ፤ ህከኒች ኤተሮን ጫንትስ ሬቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ህካን እኮቤቺሃ ለመሉንኩ አመኦሱት ተሪን ተሪን ረገኦሴቤቺሃ ሬዮ መኑ ሬሆች ኬአኖ በር ህት ጫት አዬተ እካአ?» ይት ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ኢስን እሳንከ ፈንቀሽ «አዕኑ ህት ሉሴነንታሁ ጠሊለ መጻፈተለከ መገን ዎልቀተ ደጉ ሆጌንተቤቺሃትበእንዶ? ");
INSERT INTO alw_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ሁኩ ሬቶ መኑ ሬሆች ኬኣ ወክት መላይከገ እካ ቤሉ ኣኢታበኢሁ፤ ኣአቀንታበኢሁ። ");
INSERT INTO alw_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ጠዉ እኮጎሬ ሬቶሀኑኡተ ኬእተኔሃ መገኑ ቡበኖ ሽፎ ኣዜን ሙሰ ‹አን እብራሂሚሃ፥ ኢሳቅለከ ያቁብሃ መገኑ› የኖሃ ጠሊለ መጻፊች አነበቤንታበእንዶ? ");
INSERT INTO alw_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ህካን እኮቤቺሃ መገኑ ፎሉ ዮ መኒሃ መገኑዋ ቤሉ ሬዮ መኒሃ መገኑሃበአ፤ ጠዉ እኮጎሬ አዕኑ ሉሴነንታት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ህከን ቤቾን ሕግ አስተማራች መቱ ኦደንታኢሃ ሞጮጨኖት እቅ፤ እስን ኢስ ሁኩ ሬዮ መኑ ኬአኖበአ ይታ ሰዱቃዌተ ጡመገ ፈንቀሼገ ለዕይ ኢስበ ሆንጠክ «ትዛዚች ጉዕሚችን በተአኖ ሎረሃን?» ይ ጠዕሜእ። ");
INSERT INTO alw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ኢስን እሲሃ ፈንቀሽ «ጉዕሚችን በተአኖ ትዛዝ ‹እስራኤል መኑ ሞጮጭዬ! ቀርቹ መገኑኔ ሜጦሃ ቀርቹ። ");
INSERT INTO alw_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","አቲሁ ቀርቹ መገኑክ ዊመ ቀልብንከክ፥ ዊመ ነብሴንከክ፥ ዊመ ሰውቲንከክለከ ዊመ ወልቃንከኪ ኢት› የኖሃን። ");
INSERT INTO alw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ህትን ካን አጉደኖ ለንክ ትዛዙ ‹ዎሉ መነ ገይክገ አት ኢት› የኖሃን፤ ከን ለሞ ትዛዚች በተአኖ ዎሉ ትዛዙ ዮበአ» ይ መስለ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ሁኩ ሕግ አስተማርቹንኩ «አስተማርቾ! ጡመሃን! ‹መገኑ ሜጥቹሃን፤ እስ ቤሉ ዎሉ መገኑ ዮበአ› ይት ጠወኦንቲሁ ሀንቅሃን። ");
INSERT INTO alw_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ህካን እኮቤቺሃ መኑ ዊመ ቀልብንከስ፥ ዊመ ሰውትንከስ፥ ዊመ ወልቃንከስ መገኑ ኢቱ ሀስሰኖስ፤ ህትን ዎሉ መነ ገይስገ ኢቱ ሀስሰኖስ፤ ጭንጭ ክትመለከ ዎሉ ክትመ ጉዕመንከ መገኒሃ ኣሲች ከ ለሙ ትዛዝ አገዕሩ በተአኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ኢስን ሁኩ ሕግ አስተማርቹ ሀይማንከስ ፈንቀሼገ ለዕይ «አት መገን ዎምነቲች ቄዕርትበሃን» ዬስ፤ ህከኒች ኤተሮን ኢሰ ጠዕሞተ መለሎሁ አዪሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ኢስ ዱእ ምኔን ተማርሰን «ሕግ አስተማረት ‹ፌሳንቹ መሲህ ደዉዴሃ ቤቱ› ምሀ ይታአ? ይ ጠዕሜሰ። ");
INSERT INTO alw_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ዳዉድ ገዉንኩስ መሲህተኔሃ መገን ጠሊሉ አያኑ አዎንሴሃንስ « ‹መገኑ ኢ ቀርቺሃ አን ባለጋራክ ሎካችክ ዎሮን አኦሄተ ኢለሬተ መኬኤ አዲን አፉዕል ዬእ› ይዮስ። ");
INSERT INTO alw_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ዳዉድ ገዉንኩስ ‹ቀርቾ› ይ ገኤሲች መሲህ ሀት እክ ደዉዴ ቤቱ እሀኖ?» ህከኔን ልግቡ መኑ ኢስ ጠወአኖሃ ተሽቲን ሞጮጭታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ኢስ ተማርሰን እሰንተ «ሕግ አስተማራች አገዕርዬ፤ እሰ ቅራዕሩ ኦድኑተ ኦደእ ሃንተን ጌቤ ኣዜን ኬዕምኚን ጠዉሲሶኖሰተ ኢትታአ። ");
INSERT INTO alw_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","እሰን ጭምት ምናን ኬዕምኝ ቦርጭማን አፉዕሉለከ ድግሳኒን ኬዕምኝ ቤቾን አፉዕሉ ኢትታአ። ");
INSERT INTO alw_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","አመሰልት ቅራርስት ዱአ አተን ምንሰ አኑ ሬዮ ሜንቱ ጣንስተን እታአ፤ ህካን እኮቤቺሃ እሳሃ በተአኖ ፍርዱ አሌሰ እሀኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ኢስ ዱአ አኤኖ ምኔን ሰደቀ ብረ ዎሬኖ ቀዎ ሳጥን መዴን ኣፉዕል ኡመቱ ብረ ኣሰኖሃ ለአኖት እቅ፤ ህከኔን ልግቡ ቀባጣሙ መኑ ልግብ ብረ ኣሰኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ህከ ወክት መት ቡጥቹት ምንሴ አኑ ሬዮ መንቹት አሜት ለሙ ሳንትበ እሀኖ ናስ ብረ ኣቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ኢስ አሳበስ እስበ ገእ «ሀንቅንከ ያንክዕኔ፤ ከን ሳጥን ኣዜን ብረ ዎርቶሀኑኡች ጉዕሚችን ምንሴ አኑ ሬዮ ቡጥቹት መንቹት በትስ ኣቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","መሰንትስ ዎሉ ጉዕሙንኩ ኣቶኢሁ ዮሰ ቀባጦች ፈቆሰሃን፤ ጠዉ እኮጎሬ ት ቡጥቹት መቱርቹሃ ፌሱዕናን ዮሴሃ ጉዕመንከ ኣቶኡ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ኢስ ዱእ ምኒች ፉለንን አሳባች መቱ «አስተማርቾ! ከ አጀብሲሰኖ ዱእ ምኒ ክኑለከ ግምብ ምነታ ለእ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ኢስ «ከ ሎረ ምኒ ለኣንቲትንዶ? ኩ ክኑ ድጀሙዕናን መቱ ክኑ መቶ ክን አሌን ግምበሞገ ፈቀኖበአ» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ኢስ ዱአ አኤኖ ምኒች ብሬ አዲን ዘይት ሀቁ ነጰኖ ቆተ አሌን አፉዕልዮሀኔን ጴጥሮስ፥ ያቁቢ፥ ያህይለከ እንድራስ ሜጡበ ኢስበ መርት ");
INSERT INTO alw_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«ኩን እሀኖሁ መ ወክትዪት? ህትን ሁኩ ጠዉ ጉዕሙንኩ እሆተ ሆንጠኮ ወክት መላስ መሃጎር ኩልኔ» ይት ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ኢስ እሰንተ «አዪሁ ሉስሰኖህዕኔበእገ አገዕርዬ። ");
INSERT INTO alw_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ልግቡ መኑ ‹አን መሲህት› ይተን ኢ ሱዕሚን አሜት ልግብ መነ ሉሲሳአ። ");
INSERT INTO alw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","አዕኑ በገዝ ዱዱቡለከ በገዙሃ ሞጮጭቴነንተ ወክት ህልቆኖቼ፤ ሁኩን ሆሮ እሁዕነ ፈቀኖበአ፤ ጠዉ እኮጎሬ ሁኩንን ኣዱንያ ጎፊሃ መጨረሸስበአ። ");
INSERT INTO alw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ህካን እኮቤቺሃ መኑ መን አሌን ዎሙ ዎም አሌን ኬአኖ፤ ህትን አደደ ቤቾን ኡለ ሌንቄቁለከ ጎሩ እሀኖ፤ እኮጎሬ ሁኩን ኒጠና ኦርሻተ ወኔሃን። ");
INSERT INTO alw_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«መኑ አፍ ዳኛኖተ ኣሰኖህዕኔ፤ ህትን ጭምት ምኔን ዎቀርታህዕኔ፤ ህካን እኮቤቺሃ አዕኑ ገዉክዕኔ አገዕርዬ፤ ኢ ሱዕምተኔሃ ምስክር እኮኖተ ሹመለከ ዎመ ብሬን ፍርዲሃ ኡርቴነንተ። ");
INSERT INTO alw_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ሄጭ ተሽት ላገት ኡመቲሃ ጉዕሚንከ ዱዱብሰሙ ሀስሰኖ። ");
INSERT INTO alw_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","መኑ አፍ ዳኛኖበ ሆንጠህሰኖህዕኔ ወክት ‹መ ይናም?› ህከረንገ መ ጠወዕናም?» ይቴነን ጨነቀንቶኖቼ፤ እኮጎሬ ህከ ወክት ኣሰንታህዕኔ ላገተ ጠወዕዬ፤ መሰንትስ ህከ ወክት ጠወአኖሁ ጠሊለ አያነ ቤሉ አዕኖበአ። ");
INSERT INTO alw_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ህከ ወክት አመቤቱ አመስቤቱ፥ አኑሁ ቤቱስ ሾኖተ ህግሽ ኣሰኖ፤ ህትን ኦሱት አንለከ አመ አሌን ዲኖማን ኬእ ሽታሰ። ");
INSERT INTO alw_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ኢ ሱዕምተኔሃ ጉዕሙንኩ መኑ ግበኖህዕኔ፤ ጠዉ እኮጎሬ መጨረሸ ኢለ አደቢን አታዕለኖሁ ጡመኖ። ");
INSERT INTO alw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ኮፍየኖ ሂሉርቹ እሁ ገበእበቤቾን እሀኖሃ ለኤነንተ፤ ህከ ወክት ህካን አነበበኖሁ ሰውዩን፤ ህካን እኮቤቺሃ ይሁድ ባዶን ዮ መኑ ቆተተ ሁንቱን። ");
INSERT INTO alw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ምኒ እሌ አሌን ዮ መንቹ ምኒች መቱርቹ ኣኣም የን ድረን ወክት ቤሱንከ። ");
INSERT INTO alw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ህትን አቡረ ቤቾን ዮኢሁ ኦድኑስ ኣኦተ ኤተሩ ዋል ምንስ ፈንቀሉንከ። ");
INSERT INTO alw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ህከ ወክት ላፈ ሜንቲሃለከ ቀንስታ ሜንቲሃ ኦርሸት በተኣሰ። ");
INSERT INTO alw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ሁኩን ጉዕሙንኩ ከርሜን እሀኖበዕገ ዱአ አዕዬ። ");
INSERT INTO alw_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ህከ ወክት መገኑ ክልቀት ከለቆች ከበሬ ኢለ እኮበእ ኦርሸት እካአ፤ ህትን ህትኔ ጭንቀት ከ ኤተሩ እካበአ። ");
INSERT INTO alw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ቀርቹ ህከ በራከተ ገቦትሾበዕቃኔተ መኑ ጉዕሙንኩ ጡመኖበአ እቅ፤ ጠዉ እኮጎሬ እስ መጠሮ መንተኔሃ በራከስ ገበንቹ አአኖ። ");
INSERT INTO alw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ህከ ወክት አዪሁ «መሲህ ሁኩዕኑን ከበ ዮኡ» ህከረንገ «ሁኩዕኑን ካጳ ዮኡ» ዬህዕኔጎሬ አመዕንቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ክዝብ መሲሁለከ ክዝብ ነብያኑት አሜታአ፤ እሰን አታለሞሰ ጎሬ መገኑ መጠሮ መነ ሉሲሶተ አጀብሲሰኖ ጠወ አታአ። ");
INSERT INTO alw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","እኮጎሬ ኩ ጠዉ እሆተ ሄጭ ጉዕመርቹንከ ኩሎንክዕኔቤቺሃ አገዕርዬ። ");
INSERT INTO alw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","ህከ ወክት ኦርሻች ኤተሮን አርቹት ቱንስቹ እካአ፤ ህትን አገንቹ ለሊሰኖበአ። ");
INSERT INTO alw_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ቤዜት ሰሜች ኡባአ፤ ህትን ሰማን ዮ ዎልቀት ጉዕሙርቹንኩ ሌንቄቀኖ። ");
INSERT INTO alw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ህከኒች ኤተሮን እሰን መንች ቤቱ ሎረ ወልቃንለከ ኬዕምኝን ጎመ ኣዚን አሜተን ለኣአ። ");
INSERT INTO alw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ህከኒች ኤተሮን እስ መላይከተ ሶክ ሾሎንከ አዲን ሰሜች ዎሮን ኡለ ዳንጊች ዳንገ ኢለ መገኑ መጠሮ መነ ጭምአአኖ። ");
INSERT INTO alw_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ኦድ ሀቁቾ ምሳልት ተማርስቱንክዕኔ፤ ሀሙንኩሴ ቀንሰንለከ ሀበረ ኤብ ለተኖ ወክት ሀጎ ሆንጠሁስ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ህትን አዕኑ ሁኩ ጉዕሙንኩ ጠዉ እሀን ለኤንተ ወክት ኡሮን ሆንጠኮሃ እሁስ ደጌ። ");
INSERT INTO alw_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ሀንቅንከ ያንክዕኔ፤ ከን ዘማን መኑ ኩ ጠዉ እሁዕነ ሄጭ ህገኖበአ። ");
INSERT INTO alw_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ሰሞሁለከ ኡለት ህጋአ፤ ጠዉ እኮጎሬ ላገኤ ሆሮን ህጋበአ። ");
INSERT INTO alw_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ህከ በርለከ ህከ ወክት መገን ቤሉ አዪሁ ደጎተ አታለኖበአ፤ ህትን ሆሮን ሰሜ መላይከትለከ ቤቱሁ ደገኖበአ። ");
INSERT INTO alw_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","አዕኑ ወክቱስ መ ወክት እሀኖጎሬ ደጌነንተበእቤቺሃ ጠረኝቴን አገዕርዬ። ");
INSERT INTO alw_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ሁኩንን መቱ ዎቃ ሃመኖ መንቹ አጉደኖ፤ እስን ምንስ አጉር ሃመን ካዲመስ እስገ እክ ሆጉተ አታገ መት-መትሃሰ ሆጉተ ኣሴእ፤ ህትን አገራንቹንከ ጠረኝት አገር ይ አዘዦ። ");
INSERT INTO alw_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ህካን እኮቤቺሃ ምንስ አኑ መ ወክት አሜተኖጎሬ ደጌነንተበእቤቺሃ ጠረኝቴን አገዕርዬ፤ መሰንትስ እስ ሀዎሩተ ህከረንገ ሀንከዕሬ በላን ህከረንገ ሀንጠቦ ወደን ህከረንገ ሱጵተ አሜቱስ ደጌነንተበአ። ");
INSERT INTO alw_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ህካን እኮቤቺሃ ድንገቴን ኦሳኤናን አሜተኖበዕገ ጠረኝቴን አገርዕዬ። ");
INSERT INTO alw_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","«ክዕኔሃ ኩሎምገን ዎሎ መኒሃ ጉዕሚንከ ጠረኝቴን አገዕርዬ! ያም» ይ ተማርሴእ። ");
INSERT INTO alw_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ሻሽገለከ ራጭቱ ዮበኢሃ ጨልሰሞ እቸተ እቴነን ከበጄኖ ከበጀ በሪሃ ለሙ በሩ ፈቆስ እቅ፤ ቂስ አዎንሳኑትለከ ሕግ አስተማረት ኢሰ መኑ ደጉዕነ አፍ ሽቶተ እሳሃ ቆሀኖ ዎቃሃ ሀሳኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ጠዉ እኮጎሬ እሰን «ከን ከበጀ በሬን አፎኑንከ፤ መሰንትስ መኑ ብተተ ኬሰኖ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ጎግ አሌን ፉልታ ጥዘነት አፎስ «ስሞኔ» ዬኖ መንች ምኔን ብታን ከተማን ኢስ ማዳን አፉዕልዮ እቅ፤ ህከ ወክት መት መንቹት «አልባስጥሮሰ» ዬኖ ክኒች መክሴመ ብልቃጣን «ናርዶሰ» ዬኖ ሽቱት ዊንቶኢሃ አፍ አሜቶኡ፤ ሽቱስን አበ ጤአተ እቅ፤ እሴን ብልቃጥ እፈ ብጥ ሽቱስ ኢስ ቡዕላን ዱንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ህከኔ ሄዕዮ መኒች መት-መቱሰ ኡሙዕርት «ኩ ሽቱት ተሳን በኣኢሁ ሚሃት? ");
INSERT INTO alw_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ኩ ሽቱት ሰሴ ጥቤ ዲናረ ህሬን ብረስ ቡጥቻኖተ ኣሴመ እቃን ጡመሃበእንዶ?» ይተን መንቹተ ቀነጦሴ። ");
INSERT INTO alw_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ጠው እኮጎሬ ኢስን «እሴተ ሚሃት ኦርሴነንተሴሁ? አጉሬሴ፤ እሴ ኤሳሃ ጡመርቹ አቶኤ። ");
INSERT INTO alw_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ቡጥቻኑት ጉዕመ ወክትንከ ክዕኔን ሜጡበ ሄኣቤቺሃ ሀሴንተ ወክት ሀዕልቶኖሰተ አታልቴነንተ፤ ጠዉ እኮጎሬ አን ክዕኔን ጉዕመ ወክት ከኔ ሄኣምበአ። ");
INSERT INTO alw_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","እሴ አቶተ አታልቶኢሃ አቶኤ፤ አን ሞገሙዕናን ሄጭት አሌንከኤ ሽቱተ ቡርቶኤ። ");
INSERT INTO alw_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ሀንቅንከ ያንክዕኔ፤ ኡለ አሌን ተሽት ላገተ ዱዱብሴኖ ቤቾን ጉዕማንን እሴ አቶርቹ እሴተ ቃጎኖተ ኩለመኖሴ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ህከኒች ኤተሮን ቶነ ለሞንከ አሳባች መቱስ አስቆሮንቶ ይሁድ ኢሰ ህግሽ ኣሶተ ቂስ አዎንሳኖቤቹ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","እሰን ህካን ሞጮጭቶ ወክት ሙንደእ እሲሃ ብረ ኣቶተ ላገተ ኣጎኡ፤ ይሁድን ህከን ወክቲች ኬሽ ኢሰ ህግሽ ኣሶሰተ ጡመ ወክት ሀሰኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ሻሽግ ሆልቹ ጎራጤን ጦሮሹ እቴነን ከበጄኖ ከበጀ ዎኔ በሬን አሳበስ ኢስበ አሜት «ሻሽግ ሁርባት እቶተ ሀከቤቹ መርን ቅጥ አዕኖሄተ ሀሰን?» ይት ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","እስን አሳባችስ ለሙሰ «ከተመ መርቴን ዊ ኮሩ እጄ መንቺን ደቀንቴንስ ህከ መንቹንከ አዎኜ። ");
INSERT INTO alw_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","እስ ኣገኖ ምኒ መርቴን ምንስ አነ ‹አስተማርቹ አሳባንን ሻሽግ ሁርባት እታም ኮህ ምኑ ሀከንቤቾንት? የኖት› ይዬ ይ ሶኮሰ። ");
INSERT INTO alw_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","እስን ሎረ አልባዕሎ ፉቅ ምኔን ሀስሰኖህዕኔርቹ ጉዕሙንኩ ቅጠሞኢሃ ለሊሰኖህኔ፤ ህከን ቤቾን ቅጥአዕዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ለሙንኩ አሳበንት ህከንቤቺች ፉልት ከተመ መርቶኡ፤ እሳንከ ኢስ ዬገን ጉዕሙርቹንኩ እኮ፤ ህካን እኮቤቺሃ እሰን ሻሽግ ሁርባት ህከን ቤቾን ቅጥአቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ኡለት ሀዎርቶ ወክት ኢስ ቶና ለሞንከ አሳባን ሜጡበ አሜቾ። ");
INSERT INTO alw_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ህከን ቤቾን ጉዕሙንኩሰ ማዳን አፉዕልት እተንን ኢስ «ሀንቅንከ ያንክዕኔ፤ ክዕኔች መቱ ኢን ከኔ ቴሱ ሁርባት እተኖሁ ኤሳሃ ህግሽ ኣሰኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","እሰን ህከ ወክት አበ ሻዝ ተሪን ተሪን ኢሰ «አኔትንዶ?» ይተን ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ኢስን ፈንቀሽ «ህካን አአኖሁ ቶነ ለሚችክዕኔ መቱሃስ፤ እስን ኢን ሜጡበ ብጥራን አንገተ ወር እተኖሃን። ");
INSERT INTO alw_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","መንች ቤቱዕኑ እስተኔሃ ከተበሞገን ሬሁዕናን ፈቀኖበአ፤ ጠው እኮጎሬ መንች ቤቱ ህግሽ ኣሰኖሀኒሃ ቆሀኖስ፤ ሁኩ መንቹ ሄጭ ከለቀሞበእቀ ቆሀኖስ እቅ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","እሰን ሜጡበ እተንን ኢስ ጦሮሹ ኬሽ ዱአ አዕይ ብጭ አሳባተ «ሂዕዬ፤ ኩን ማላኤ» ይ ኣሴሰ። ");
INSERT INTO alw_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ጠበቴሃ ኬሽ ዱአ አዕይ አሳባተስ ኣሴእ፤ ጉዕሙንኩሰ ህከን ጠበቴች አጎኡ። ");
INSERT INTO alw_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ህትን ኢስ እሳሃ «ኩን ልግብያ መኒሃ ዱንተአኖሃ ወኣድ ቄጓኤ። ");
INSERT INTO alw_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ሀንቅንከ ያንክዕኔ፤ መገን ዎምነቴን ሃዕሮ ሃሌን አጋሚሃ ኢለ ከን ወይን ላልቺች ጩንሸሞሃ ለንኪሃ አጋምበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ህከኒች ኤተሮን መዝሙረ ዘመርት ዘይት ሀቁ ነጰኖ ቆተተ ፉልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ኢስን አሳባስ « ‹ዜማንቹ ዎቀር ሻም፤ ሆለንትስ ብን ይታአ› የመም ከተበሞቤቺሃ ጉዕሙንኩክዕኔ ኤሳሃ ለገኤን አጉርቴን ሁንቴነንተ። ");
INSERT INTO alw_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ጠዉ እኮጎሬ ሬሆች ኬዕዮሚች ኤተሮን ገሊለተ ክዕኔተ ሄጭ መራም» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ህከ ወክት ጴጥሮስ ፈንቀሽ «ዎሉ መኑ ጉዕሙንኩ ለገዕዮሄ ጎሬ አን ሆሮን ለገኣንኬበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ኢስን ጴጥሮሴ ፈንቀሽ «ሀንቅንከ ያንኬ፤ ከበሬ ሀንከዕርተ ሀንጠቦ ለሞረ ወዱዕናን ሄጭት ሰሶረ ለገኣንቴኤ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ጠው እኮጎሬ ጴጥሮስ «አን ኪን ሜጡበ ሬሀም ጎሬሁ ለገኣንኬበአ» የን ጠረኝሽ ጠወዕዮ፤ ፈቆ አሳበንት ጉዕሙንኩ ህትን ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ህከኒች ኤተሮን «ጌቴሴማኔ» ዬኖቤቹ መርቶኡ፤ ህከን ቤቾን ኢስ አሳባንተስን «አን ዱአ አኦተ ኢለ ከንቤቾን አገሬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","እስን ጴጥሮሴ፥ ያቁበለከ ያህይ አዎንስ ኦሮዕዮ፤ ህከን ቤቾን እስን አበ ሻዘን ጨነቀሙ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","እሳንከ «ነብሴቹኤ ሬቶተ ኢለ አበ ሻዞኡ፤ አዕኑ ከኔ ግሶኑዕናን አገሬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","እሳችን ቀው ቄዕር ኦሮዕዮ፤ ሚኔንከስ ኡላን ጎምብሰም ኡብ አታለመኖሄ ጎሬ ሁኩ ኦርሸ ወክቱ እሲች ህጎተ ዱአ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","እስን «ኢ አነ! ጉዕሙርቹንኩ አታለመኖሄ፤ ከ ኦርሸ ጠበቴሃ ኢች መስ፤ ጠዉ እኮጎሬ አን ዬምገ እሁዕነ አት ኢትቶንትገ እሁን?» ይ ዱአ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ህከኒች ኤተሮን ሰሶንከ አሳበስበ ፈንቀል አሜተኖ ወክት እሰን ግሶ እቅ፤ ህካን እኮቤቺሃ ጴጥሮሴ «ስሞኔ! ግሶንትዶ? ሆሮን መቱ ሳኣቲሃ በቅ ይት አገሩ አታልቶንትበዕንዶ?» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ህትን «ፌተናን ኣጌነንተበእገ ጠራኝቴን ዱአ አዕዬ፤ አያኑ ቅጥ ይዮኡ፤ ጠዉ እኮጎሬ ማሉ ላፈሃን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ለንኪሃ ኦሮዕይ ወዕና ጠወዕዮ ላገንተ ጠወአን ዱአ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ህከኒች ኤተሮን አሳበስበ ፈንቀል አሜተኖ ወክት ግሰኛት ኬዕምታንሰ ግሶ እቅ፤ ጠዕመኖ ወክትንከ ፈንቀሽቶተ አታልቶበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ለንኪሃ እሰበ ፈንቀል አሜች «ቴሁ ግሴንተገለከ ፎሎጭቴንተገን ዮንተንዶ? ቴሱ እሀኖ፤ ወክቱ ኢልዮኡ፤ መንች ቤቱ ጩበኛኖ አንጋን ህግሴን ኣሴኖ። ");
INSERT INTO alw_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ቴሱ ኬዕዬ መርኖ፤ ኤሳሃ ህግሽ ኣሰኖኤሁ ሁኩዕኑ ሆንጠኮኡ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ወክትንከስ ኢስ ካን ጠወአን ሄዕዮገን ቶነ ለምችሰ መቱስ «ይሁደ» ዬኖሁ አሜቾ፤ እሲን ሜጡበ በርተለከ ብሰ አፎ ልግቡ መኑ ሄዕዮ እቅ፤ እሰን ቂስ አዎንሳኑትለከ ሕግ አስተማረት ባድ ባልቃች ሶሀንቶእረ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ህግሽ ኣሰኖ ይሁድን እሰንተ አዕኑ «አን ሱንቃንሲሃ ጠረኝሴን አፌን መስዬ» ይ መላተ ኩሎሰ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ወክትንከስ ይሁድ ደዕል አሜች ኢስበ ሆንጠክ «አስተማርቾ!» ይ ሱንቄስ። ");
INSERT INTO alw_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ህከኒች ኤተሮን ሁኩ መኑ ኢሰ አፎኡ። ");
INSERT INTO alw_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","መዴንከስ ኡርቶሀኑኡች መቱስ ብሰ ኮብ ኣዚች ፉሽ ሎረ ቂስች ካዲንቹ መጨስ ሙሮ። ");
INSERT INTO alw_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ህከ ወክት ኢስ «ብሰለከ በርተ አፌን አሜቴንታሁ ሽፍጥገ አፎኖኤታትንዶ? ");
INSERT INTO alw_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ጉዕመንከ በር ዱእ ምኔን ተማርሰን ክዕኔን ሜጡበ ሄአን አፌንታኤበ እቅ፤ ጠዉ እኮጎሬ ኩን እኮሁ ጠሊለ መጻፋን ከተበሞሁ ዊሞታት» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","አሳበስ ጉዕሙንኩ እሱ አጉርት ሁንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ነጠለ ኦደዕዮ መቱ ዎደልቹ አዎነኖሲት እቅ፤ እሱንከ ሁኩ መኑ አፎኡ። ");
INSERT INTO alw_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","አፎስ ወክት ነጠለስ ኡጅ ከልስ ሁኝ ፉሸኤእ። ");
INSERT INTO alw_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ህትን ኢሰ ሎረ ቂሲች ምኒ መስቶስ፤ ህከን ቤቾን ቂስ አዎንሳኑት፥ ባድ ባልቀትለከ ሕግ አስተማረት ጉዕሙንኩ ጭምይቶኡ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ጴጥሮስን ኢሰ ቂስ አዎንሳንች ምኒ ኡሮ ብትም ኣዝ ኢለ ቄዕራሻን አዎነኖሲት እቅ፤ ህከኔን እስ ዘበኝን ሜጡበ ጊረተ ኢብጨኖት። ");
INSERT INTO alw_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ቂስ አዎንሳኑትለከ ኦገት ደኛኑት ጉዕሙንኩ ኢሰ ሽሲሶተ ምስክር ሀሳኢት እቅ፤ ጠዉ እኮጎሬ መቱርቹሃ ደጎበአ። ");
INSERT INTO alw_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","መሰንትስ ልግቡ ክዝብ ምስክሩ ልግብ ጠወ አሌስ መሰከርቶ እቅ፤ እኮጎሬ አሌስ መሰከርቶ ላገት አደደ እኮኡ። ");
INSERT INTO alw_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","መቱ-መቱ መኑ ኬእ « ‹አን ከን መን አንጋን እጃረሞ ዱእ ምኒ ድጅ ዎሉ መን አንጋን እጀረሞበኢሃ ሰሶ በሬች ኤተሮን እጃራም› የን ሞጮጭኖም» ይተን ክዝብ ኢስ አሌን መሰከርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ህት ይቶ ጎሬሁ ምስክሩ ጠወዕዮ ላገት ሜጡ እኮበአ። ");
INSERT INTO alw_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ሎሩ ቂስቹንኩ ብሬንከሰ ኡር ኢሰ «ጠወአንትርቹ ዮበእንዶ? ኩ መኑ ኪ አሌን መሰከርታኢሁ መርቹሃን?» ይ ጠዕሜእ። ");
INSERT INTO alw_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ጠዉ እኮጎሬ ኢስ መቱርቹሃ ጠወኡናን ጨለ ዬእ፤ ሎሩ ቂስቹንኩ ኢሰ ፈንቀሽ «ማሰአሞ መገን ቤቱ መሲሁ አቴትንዶ?» ይ ጠዕሜስ። ");
INSERT INTO alw_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ኢስን «ኤ አኔት፤ መንች ቤቱ ጉዕመንከ አታለኖ መገን መኬ አዲን አፉዕል ሰሜ ጎማን አሜተን ለኤነንተ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ሎሩ ቂስቹንኩ ኦድኑስ ፊል «ዎሉ ምስክሩ ሚሃ ሀስሰኖኔ? ");
INSERT INTO alw_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","አዕኑ እስ ቦሮር ላገተ መገን አሌን ጠወአን ሞጮጭቴንታአ፤ ህካን እኮቤቺሃ ኩ ጠዉ ክዕኔሃ መ አጉደኖህዕኔ?» ዬእ፤ ህከ ወክት እሰ ጉዕሙንኩሰ መቴ ላጋን «ሬሁት ገበኣስ» ይት ፈረዶኡ። ");
INSERT INTO alw_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","መት-መቱ መኑ አሌስ አንጀ ቱ ዩ ጀመርቶኡ፤ እልስ ኦድኖን ድብ ኡሱርት መጫለ ዎቀርተን «ህንዴ አዬት ዎቀሮሄሁ? ደግ! ራገ ጠወእ» ይታሲት እቅ፤ ህትን አገርታሩንኩ ኦልተን መስቶስ። ");
INSERT INTO alw_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ጴጥሮስን ቂስ አዎንሳንች ምኒ ዎሮ አዲን ግቤ ኣዜን ሄዕዮገን ቂስ አዎንሳንች መት ገረድቹት አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","እሴን ጴጥሮስ ጊረተ ኢብጨን ቱክ ይት ለእ እሱ «አት ነዝሬት ኢስን ሜጡበ ሄኦንት እቅ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ጠዉ እኮጎሬ ጴጥሮስ «አን ደጋንስበአ፤ አት ይታንትንኩ ኣጎኤበአ» ይ ለገዕዮ፤ ህካን ይ አብል ፉሎገን ሀንጠቦ ዎጆ። ");
INSERT INTO alw_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ህት ገረዴቹንት ጴጥሮሴ ለእ ህከኔ ኡሬ መኒሃ «ኩን እሳች መቱሃስ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ጠዉ እኮጎሬ እስ ቴሁ ለገዕዮ፤ ህትን ቀዉ ጌሰ አገርት ህከኔ ኡርቶ መኑ «አት ገሊለ መንቹ እኮንትቤቺሃ ሀንቅንከ አት እሳች መቱሃስ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ጠዉ እኮጎሬ ጴጥሮስ «አዕኑ ከ ይቴነንተ መንቹ ደጋንስበአ» የን ገውስ ቦሮሩለከ ጤሌዕሉ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ህከ ወክት ሀንጠቦ ለንኪሃ ዎጆ፤ ጴጥሮስን «ሀንጠቦ ለሞረ ወዱዕነ አት ኤሳሃ ሰሶራ ለገኣንት» ዬ ኢስ ጠወዕዮ ጠወ ሰዉ ይ ቡብ ኦዕዮ። ");
INSERT INTO alw_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ገስመ ሱጵተ ቂስ አዎንሳኑት፥ ባድ ባልቀትለከ ሕግ አስተማረት ኦገት ደኛኖን ሜጡበ ጉዕሙንኩ ደቀንት አማዕለንቶኡ፤ ህከኒች ኤተሮን ኢሰ ኡሱርት መስት ገሻንቾ ጵላጦሴሃ ህግስ ኣቶስ። ");
INSERT INTO alw_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ጵላጦስን ኢሰ «አት አይሁድያ ዎመንዶ?» ይ ጠዕሜስ። ኢስን ፈንቀሽ «አት ይቶንትጋንት» ዬስ። ");
INSERT INTO alw_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ህትን ቂስ አዎንሳኑት ኢሰ አበ ጠዊን ኦዳሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ጠዉ እኮጎሬ ጵላጦስ ኢሰ «ሄንከ ጠዊን ኦደሄት ከ ለእ! ከን መኒሃ መቱርቹሃ ፈንቀሽታንትበዕንዶ?» ይ ለንኪሃ ጠዕሜስ። ");
INSERT INTO alw_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ጵላጦስ አበ አጀብሲጮተ ኢለ ኢስ መቱርቹሃ ፈንቀሽዮበአ። ");
INSERT INTO alw_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ጵላጦስ ዘማን ዘማኔ አይሁድ ሻሽግ ከበጀ ወክት ሂሮኖተ መኑ ሀሶኢሃ ኡሱሬመ መኒች መቱ መንቹ ሂረኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ህከ ወክት ዎምነቱክ ግብ መነ ሽት ኡሱረንቶ መን በሊች «ባርባኔ» ዬኖ መንቹ ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","መኑንኩ ጵላጦሴበ አሜት ሮሾገን መቱ መንቹ ሂሮተ ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","እስን «አይሁድ ዎመ ሂሮህዕኔተ እትቴነንንዶ?» ይ ጠዕሜሰ። ");
INSERT INTO alw_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ህካን ዬኢሁ ቂስ አዎንሳኑት ኢሰ ህግስ ኣቶኢሁ ጢቄን እሁስ ደጎቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ጠዉ እኮጎሬ ቂስ አዎንሳኑት «ባርባን ሂረሙኔ ቤሉ ኢስ ሂረሙንከ» ይት መኑ ጵላጦሴ ጠዕመኖገ መነ ኬሰንስቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ጵላጦስ ለንኪሃ ፈንቀሽ «ህካን እኮች ከ አዕኑ ‹አይሁድ ዎመ› ይቴነንታሃ መ አኡ?» ይ ጠዕሜእ። ");
INSERT INTO alw_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","እሰን «ሰቀል» ይተን ላገሰ ጎት አት ጨንጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ጵላጦስን «ሚሃት? እስ አዕዮ ሂሉርቹ መርቹሃን?» ዬሰ፤ ጠዉ እኮጎሬ እሰን «ሰቀል» ይተን ወዕኔች በትስ ጨንጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ጵላጦስ መነ ሙንዲሲሶተ ይ ባርባኔ ሂር ገፈሮ፤ ህከኒች ኤተሮን ኢሰ ገረፍ ሰቀልቶተ ህግሽ ኣሴእ። ");
INSERT INTO alw_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ሮም ዎታደሩ ኢሰ ጵላጦሴ ግብተ መስቶኡ፤ ፈቆ ወታደረ ጉዕመንከ ገእቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ሰመ አጉደኖ ብሸ ኦድኑተ ኢሲሃ ኦዲስ ኡት አክሊለ መክስ ቡዕለስ አቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ህካን አቶች ኤተሮን «አይሁድ ዎመ! ወገሬቱ ኬሳሃ እሆሄ!» ይተን ቀለዳሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","እሰን ሾምቦቆን ቡዕለስ ዎቀርተን አንጀ አሌስ ቱ ይታኢት እቅ፤ ህትን እሰን ቀለደን ብሬስ ጉሉጵት ሰገዶስ። ");
INSERT INTO alw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","እሰን እሲን ቀለዶች ኤተሮን ህከ ሰመ አጉደኖ ቢሸ ኦድኑተ ፉሽት ገይስ ኦድኑተ ኦድስ ሰቀልቶስተ ኣእት መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","መርተንን እስክንድርለከ ሩፎሴ አኑ ቀሬን ባድ «ስሞኔ» ዬኖ መንቹ ገጠሪች ከተመ አሜተን ደቀንት ኢስ መስቀለ እጆተ ግዳጅሶስ። ");
INSERT INTO alw_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","እሰን ኢሰ «ጎልጎተ» ዬኖቤቹ መስቶስ፤ «ጎልጎተ» ዩ ቡዕል ቁላሃ ዩሃን። ");
INSERT INTO alw_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","እሰን ኢሲሃ «ከርቤተ» ዬኖ ዘቢን ልቀለቀሞ ወይን ጠጀ አጎተ ኣቶስ፤ ጠው እኮጎሬ ኢስ አጎበአ። ");
INSERT INTO alw_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ህከኒች ኤተሮን እሱ ሰቀልቶኡ፤ ህትን ሀኩንስ አዬሃ ኢለኖ ጎሬ ደጎተ ኦድኑስ እጠ ኡጅት ቤቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","እሰን ኢሰ ሰቀልቶ ወክቱ ገስሜ ሰሶሃ ሳኣት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ህትን ወንጀልስ ለልሶተ «አይሁድ ዎመ» የኖ ከተበሞ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","እሰን ኢሲን ሜጡበ ለሙ ሽፍጠ መቱ መኬ አዲን መቱስ ጉረ አዲን ሰቀልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ከን ሃሌን «ሾከ መኒን ዎለአሞ» የመሞ ራግ ላገት ዊንቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","እስ መዲን ህገኖ መኑ እሱ ህንቅ ቡዕለሰ ሌንቄቅሰን «ለዕዬስ! አት ዱእ ምኒ ድጅት ሰሶ በሬን እጃርታንቲሁ! ");
INSERT INTO alw_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ህንዴ ቴሱ መስቀሊች ድርት ገውክ ፌስ» ይታሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ህትን ቂስ አዎንሳኑትለከ ሕግ አስተማረት ገገዉንኩሰን «እስ ዎሉ መነ ፌሾኡ፤ እኮጎሬ ገውስ ፌሶተ አታሎበአ። ");
INSERT INTO alw_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","እስ ፌሳንቹ መሲሁ እስራኤል ዎመ እኮጎሬ ህንዴ ቴሱ ከን መስቀሊች ድሩን፤ ነኡን ለዕን አመዕንናም» ይተን ህንቃሲት እቅ፤ ህትን እሲን ሰቀለንቶእሩ ህትን ይተን ቦሮርታሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ህከ በር ሌሆ ሳቲች ኬሽ ሆንሱ ሳት ኢለ ኡለ አሌን ጉዕማንን ቱንስቹ እኮ። ");
INSERT INTO alw_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ሆንሱ ሳት እኮ ወክት ኢስ «ኤሎሄ! ኤሎሄ! ላማ ሰበቅታኒ» ይ ሎረ ላጋን ያሮ፤ ፍሳረንትስ «ኢ መገኖ! ኢ መገኖ! ሚሃ አጉርቴኤ» ዩሃን። ");
INSERT INTO alw_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ህከኔ ኡርቶ መኒች መት-መቱሰ እስ ያረኖሃ ሞጮጭት «እልያሴ ገአኖት» ይቶኡ፤ ");
INSERT INTO alw_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","እሳችን መቱስ ደጉጅ መር ሆለጮ ወይነ ጠጀ ሰፍነገ ዬኖሀኒን ዊንሽ ጬፍ ሾንቦቆ ሰኖን አዕይ ኢሲሃ ኣስ «ህንዴ አገሬ፤ እልያስ አሜች ድርሰኖስ ጎር ለዕናም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ህከኒች ኤተሮን ኢስ ሎረ ላጋን ያር ሬዮ። ");
INSERT INTO alw_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ህከ ወክት ዱእ ምኒ መጋረጁ አሌች ወሮ ኢለ ለሙበ እክ ፊልተዕዮ። ");
INSERT INTO alw_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ኢስ ሰቀለሞ መስቀል ብሬን ኡርዮ መቱ ጥቤ ሀለቅቹ ኢስ እክ ሬዮገ ለዕይ «ሀንቅንከ ኩን መገንያ ቤቱ እቅ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ቄዕራሻን ኡርት ለአን ሄኦ መት-መቱ ሜንቱ ህከኔ ሄኦ እቅ፤ እሰ በላን መግደል ከተም መርየማ፥ ማዕነ ያቆቤለከ ዮሲ አመት መርየማ፥ ሰሎሚ ሄኦ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","እሰን ኢስ ገሊላን ሄዕዮ ወክት አዎንተን ካደንታስረ እቅ፤ ህትን ኢሲን ሜጡበ የሩሳሌመ አሜቶ ልግቡ ሜንቱ ሄኦ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","በሩስ ተቃጠቤኖ በር እኮቤቺሃ ሀዎሬ ወክት ፎሎጭ በሬች ብርተ እኮ። ");
INSERT INTO alw_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","አይሁድ ኦገት ደኛኖች መቱ ጡመገ ኤንኬዕነሞ አርማትያስ ከተም ዩሱፍ መገን ዎምነቱ ተቢሴን አገዕረኖሁ ጵላጦሴበ መር መለል ኢስ ጀናዘተ ኣሶኖስተ ኡጨእ። ");
INSERT INTO alw_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ጠው እኮጎሬ ጵላጦስ «ሀት ደዕል ሬዮ?» ይ አጀብሲጭ ጥቤ ሀለቅቹ ገእ «ሀንቅንከ ሬዮች ዱንክዮእንዶ?» ይ ጠዕሜእ። ");
INSERT INTO alw_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","እስን ኢስ ሬሁስ ጥቤ ሀለቅቹ ሞጮጬች ኤተሮን ጀናዘስ ዩሱፍ መሰኖገ ፈቀጆስ። ");
INSERT INTO alw_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ዩሱፍን ሃዕሮ ከፈን ኦድኑተ ህዕር ኢስ ጀናዘተ መስቀል አሊች ድሪሽ ከፈኞ፤ ህከኒች ኤተሮን ክኒች ሸሄን መክሴመ ሎድ ኣዜን አፉሼእ፤ ሎረ ክኑ ኮሎንኮዕልሽ ኤብ ሎድስ ኡሩተ ጡፎ። ");
INSERT INTO alw_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","መግደል ከተም መርየመለከ ዮሳ አመት መርየማ ኢስ ጀናዘተ ሀከኔ አፉሼኖ ጎሬ ለኣኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ፎሎጭ በሩ ህጎች ኤተሮን መግደል ከተም መርየማ፥ ያቁብ አመት መርየመለከ ሰሎሚ ኢስ ጀናዛን ቡርቶተ ሽቱተ ህዕርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","አበ በር ገስመ ሱጴን አሩ ፉለንን ሎድበ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ገገዉንኩሰ «አይ ሎድ ኡሮች ክኑ ኮሎንኮልሽ ፈነኖኔ?» ይተን ጠወአን ሃንታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ህካን ይቶኢንኩ ክኑስ ሎረ እኮቤቺሃት፤ እሰን ህት ይተን ሎድበ ኦሎስ ለኣ ወክት ክኑስ ሎድ ኡሮች መቱ አደ ዋል ኮሎንኮዕልዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ህትን ሎድ ኣዝ ኣጎ ወክት ዋጁ ኦድኑተ ኦደዕዮ ወደልቹ መኬ አዲን አፉዕሌኢሃ ለኦቤቺሃ ህልቆኡ። ");
INSERT INTO alw_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ጠው እኮጎሬ እስ እሰንተ «ህልቆኖቼ፤ አዕኑ ሀሴነንታሁ ሰቀሌመ ናዝሬት ኢሰ እሁስ አን ደጋም፤ እስ ሬሆች ኬዕዮኡ፤ ከንቤቾን ዮበአ፤ ከለዕዬ! እሱ ሞጌማ ቤቹንኩ ኩዕኑን። ");
INSERT INTO alw_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ቴሱ መርቴን አሳባተለከ ጴጥሮሴሃ ‹ከኒች ብርተ እስ ዬህዕኔገን ክዕኔንተ ሄጭ ገሊለ መረኖ፤ ህከኔን ለኤነንተስ› ይቴን ኩሌ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ሁኩ ሜንቱንኩ ዋጅት ሁጠን ሎድቢች ፉልት ሁንቶኡ፤ እሰን አበ ዋጅቶቤቺሃ መቱርቹሃ መቶ መንቺሃ ጠወኦበ እቅ።  ");
INSERT INTO alw_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ኢስ አበ በር ገስመ ሱጵተ ሬሆች ኬዕዮች ኤተሮን ወዕና ለመሉ ሩሃንዩ ፉሎሴ መግደል መርየማን ሄጭ ደቀሞ። ");
INSERT INTO alw_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","እሴን መርት ሻዘናንለከ አልፋቴን ሄኦ አሳባተስ ኩልቶኡ። ");
INSERT INTO alw_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","እሴን «ኢስ ሬሆች ኬዕዮኡ እስን ፎሊን ዮኡ፤ አንን እሌንከኤ ለዕዮም» ይት ኩልቶሰ፤ ጠዉ እኮጎሬ እሰ ጠወስ አመዕንቶበአ። ");
INSERT INTO alw_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ህከኒች ኤተሮን ኢስ ከተሚች ገጠረ መርተን ሄኦ ለሞንከ አሳባንተ ዎሎ ደኒን ለሌእ። ");
INSERT INTO alw_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","እሰን ፈንቀልት መርት ፈቆ አሳባተ ኩልቶኡ፤ ጠዉ እኮጎሬ እሰንተ አመዕንቶበአ። ");
INSERT INTO alw_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ህከኒች ኤተሮን ቶነ መቶንከ አሳባተስ ማድ አሌን እተን ሄኦገን ኢስ ለሌሰ፤ እስን «ኢስ ሬሆች ኬዕይ ፎልን ዮኡ፤ ነኡን ለዕኖም» ይቶ ጠወ ቀልቡሰ ዱጃን አመዕኑ ሆጎቤቺሃ ዎቀሾሰ። ");
INSERT INTO alw_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ኢስን «ጉዕማንከ ኣዱንያ አል ባዱ መሬ፤ መኒሃ ጉዕሚንከ ተሽት ላገተ ተማርስዬ፤ ");
INSERT INTO alw_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","አመዕን ጠመቀሞሁ ፈቀኖ፤ እኮጎሬ አመዕንበሀኒሃ ፈረደመኖስ። ");
INSERT INTO alw_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ኢን አመዕንቶሀኑኡተ ጉዕሚንከ አጀብሲሰኖ ጠወ አታ ወልቀት ኣሰንታሰ፤ ኢ ሱዕሚን ሩሃንየ ፉሽታአ፤ ህትን ወዕና ጠወእበ ሃዕሮ ላጋን ጠወኣአ። ");
INSERT INTO alw_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ወሪቹንከ አፎእቀ ህከረንገ ሸኖ ዘቡ አጎእቀ ምረኖሰበአ፤ እሰን ጥዘናመ አሌን አንገተ አቶእቃ ጥዘናችሰ ፈይታአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ህካን ቀርቹ ኢስ ጠወዕይ ሹሎች ኤተሮን መገኑ ሰማሃ መሴሃንስ መገን መኬ አዲን አፉዕሌእ። ");
INSERT INTO alw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","አሳበንት ጉዕመ ቤቹንከ መርት ተሽት ላገተ ተማርስቶኡ፤ ቀርቹንኩ እሳን ሜጡበ አአኖት እቅ፤ አጀብሲሰኖ ጠወ አታ ወልቀተ ኣሲን ተማርስታ ጠዉ ሀንቅ እሁስ ሆጎን ለሊሰኖት እቅ።");
INSERT INTO alw_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ከበጀንቶንት ቴዎፍሎሴ! ኒ በላን እኮ ጠውተኔሃ ልግቡ መኑ ማቁስ ከኒች ዎዕናሃ ከተቦኡ። ");
INSERT INTO alw_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ህከ ሶህኑተ ኔሳሃ ህግሶእሩ ወዕኔችን ኬስ እሌንከሰ ለኦእረለከ ላገስ ካዲመተ እኮእሃ መነ። ");
INSERT INTO alw_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ህትን አን ወዕኔችን ኬሽ ጉዕመ ጠወንከ ጠረኝሽ አጥራመቾሚች ኤተሮን ጠወስ ቅልቢን ከተቡ ጡመ አጉጅ ለሌኤ። ");
INSERT INTO alw_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ካን አኡኤ ተማርቶንት ትምህርቱ ሀንቅ እሁስ ጡመገ ደጎተ ይዪት። ");
INSERT INTO alw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ይሁድ ባድ ዎመ ሄሮድሴ ዘማኔን «አብየ» ዬኖ ቂሶመ ክድመ አዲሁ «ዘከርየ» ዬኖ መቱ ቂስቹ ሄዕዮ እቅ፤ እስን ሀሩን ዘሬች እኮኢት «ኤልሳቤጤ» ዬኖ መንቹት ሄኦስ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ህትን ለሙንኩ ቀርች ትዛዝለከ ሴረ ጉዕመንከ ሂሉርቹ ዮበኢሃ አገርተን መገን ብሬን ፈየ መነ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ኤልሳቤጥን እልትባተ እኮቤቺሃ እለት ዮሰበእረ፤ ህትን ለሙንኩ ባልቆእረ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ህከ ወክት ዘከርየ አዲሃ ሆጎ ተሩ ኢልሃን መገን ብሬን ቂሶመ ሆጉተ አአንን ");
INSERT INTO alw_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ቂሰ ሴር ሃሊን ዱእ ምኒ ኣግ ህጣነ አጪሶተ እጡ ኢሌስ። ");
INSERT INTO alw_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ህከ ህጣነ አጪሴኖ ወክት ኡመቱ ጉዕሙንኩ አብሌን ኡር ዱአ አታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ቀርች መላይኬቹ ህጣነ አጪሴኖ ጠረጴዝ መኬ አዲን ኡርኬዕይ ዘከርይሃ ለሌእ። ");
INSERT INTO alw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ዘከርይን መላይኬቹ ለዕዮ ወክት ህልቆ፤ አበ ዋጄእ። ");
INSERT INTO alw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ጠው እኮጎሬ መላይኬቹ «ዘከርየ! ዱኡክ ሞጮጨሞቤቺሃ ዋጅቶት፤ መንቹክ ለባ ጩል እልታሄ፤ ሱዕመስ ‹ያህይ› ይት ገእታንት። ");
INSERT INTO alw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ኬሳሃ አቡ ሙንዲኑት እካሄ፤ ጩሉ እለሞቤቺሃ ልግቡ መኑ ሙንደአኖ። ");
INSERT INTO alw_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","መሰንትስ እስ መገን ብሬን ሎረ እሀኖ፤ ህትን ወይኒን ቦበጤማሀለከ ዎሉ ሰከርሰኖ አጌኖርቹ ሆሮን አገኖበአ፤ ህትን አመስ ጎደባን ሄዕዮ ሰኣቲች ኬሽ ጠሊለ አያኒን ዊሞሃ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","እስን እስራኤል ኡመቲች ልግብሰ ቀርቾሃ መገን አደ ፈንቀሸኖ። ");
INSERT INTO alw_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ህትን ቅጥይቶ መነ ቀርቺሃ ቅጥ አኦታ፥ አናኑተለከ እለተ ሀራርስ ሜጡበ አኦተለከ አዘዘንታበእ መን ቀልብ ጠሊላኖ ደጉ ፈንቀሾታ፥ እልያሴ አያኒንለከ ወልቃን ቀርች ብሬን ሃመኖ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ዘከርየን ህከ መላይኬቹ «አን ባልቆም፤ ጫንትኤ ባልቆኡ፤ ኩ ጠው ሀንቅ እሁስ ማን ደጎተ አታላም?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","መላይኬቹንኩ ፈንቀሽ «አን መገን ብሬን ኡራም ጅብርላት፤ ከ ተሽት ኩሎሄተ ሶቀም አሜቾም እቅ። ");
INSERT INTO alw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","እኮጎሬ ወክቴንከስ እካ ላገኤ አመዕንትበቤቺሃ ኩ ጠው እሆተ ኢለ ዱደ እካንት፤ ጠወኡንከ አታልታንትበአ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ህከ ወክት መኑ ዘከርየ አገረኖት እቅ፤ እስን ዱእ ምኒ ኣዜን ዱንኬቤቺሃ አጀብሲጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ዘከርየን ዱእ ምኒች ፉሎ ወክት መኒን ጠወኦተ አታሎበአ፤ ህካን እኮቤቺሃ ዱእ ምኔን መቱርቹ ለሌስገ ደጎኡ፤ መሰንትስ አንጋን ቀቀሰን ኩለኖሳት እቅ፤ እስን ዱደ እኮ። ");
INSERT INTO alw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ክድመ ወክቱንኩ ጎፋን ምንስ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ቀወ ወክቲች ኤተሮን ጫስ ኤልሳቤጥ ላፈተ እኮኡ፤ ");
INSERT INTO alw_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«ቀርቹ ከ ጡመርቹ አዕዮኤ፤ መን በላን ዮኤ ህንቀሙ ከሞኤ» ይት ኦንቱ አገነ መኒች ማጠንቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ኤልሳቤጥ ላፈተ እኮ ሌህቅ አገናን መላይኬቹ ገሊለ ባዶን ሄዕዮ «ናዝሬተ» ዬኖ ከተማን ሄኣ መቴ ሀፍቶበ መገን አዲን ሶሀሞ። ");
INSERT INTO alw_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","እሴን ዳዉዴ ዘሬች እኮ «ዩሱፈ» ዬኖ መንቺሃ ኣሰንቶእተ እቅ፤ ሀፍቶስ ሱዕሙ «መርየመ» ዬኖተ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ሁኩ መላይኬቹንኩ እሴቤቹ አሜች «መገን ኣስቱት ዊሞሄት፤ ወገሬቱ ኬሳሃ እሁን፤ መገኑ ኪን ዮኡ፤ አት ሜንቲች ጉዕሚችን ማሰአንቶንትተ» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ጠዉ እኮጎሬ እሴን ህከ መላይኬቹ ለኦ ወክት ጠዊንከስ አበ ህልቅ «ኩን ሀትናሙሃ ወገሬት?» ይት ሰውይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ሁኩ መላይኬቹንኩ እሴንተ «ቴ መርየማ! መገን አያኑ ዮሄቤቺሃ ዋጅቶት። ");
INSERT INTO alw_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ሁኩዕኑ! አት ላፈተ እካንት፤ ለባ ጩልንከ እልታንት፤ ሱዕመስ ‹ኢሰ› ይት ገእታንት። ");
INSERT INTO alw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","እስን ሎረ እሀኖ፤ ጉዕሚችን ሎረ መገን ቤቱ የመመኖ፤ ህትን ቀርቹ መገኑ አንስ ደዉዴ ሎረ ኬዕምኝ ቦርጭመተ ኣሰኖስ። ");
INSERT INTO alw_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ያቁብ እለ አሌን ዘላለሚሃ ዎመ እሀኖ፤ ወሞማተስ ዳንጉ ዮስበአ» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","መርየመ ህከ መላይኬቹ «አን ሀፍቱተ እኮምቤቺሃ ኩ ጠዉ ሀት እሆተ አታለኖ?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","መላይኬቹንኩ ፈንቀሽ «መገን ጠሊሉ አያኑ ኪ አሌን አሜተኖ፤ ጉዕሚችን ሎረ መገን ወልቀት ኪ አሌን እካአ፤ ህካን እኮቤቺሃ ኪች እለመኖ ጠሊለ ጩል ‹መገን ቤቱ› ዬን ገኤኖስ። ");
INSERT INTO alw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ህንዴ ለእ! እልቹክ ኤልሳቤጥ ባልቅማንተሴ ለባ ጩል ላፈታን፤ እሴን ‹እልትበታን› ዬነንሴ ሄእ እሴ ላፈተ እኮኢች ኩን ሌህቅያ አገነ። ");
INSERT INTO alw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","መሰንትስ መገኑ ቄለኖስ መቱርቹሁ ዮበአ» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","መርየማን «ሁኩዕኑን አን መገንተ ሮስቹ፤ ኤሳንከ አት ይቶንትገ እሁዕኔ» ይቶኡ፤ መላይኬቹንኩ እሴች አደ እክ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ህከ ወክትንከ መርየመ ቆተ ባዶን ሄዕዮ ይሁድ ከተመ ደዕልት መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","እሴን ዘከርየ ምኒ ኣግ ኤልሳቤጤ ወገሬትሶኡ። ");
INSERT INTO alw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ኤልሳቤጥን መርየመ ወገሬትሶ ላገተ ሞጮጭቶ ወክት ጎደባንከሴ ዮ ጩሉ አለጴእ፤ ኤልሳቤጥን ጠሊለ መገን አያኒን ዊንት ");
INSERT INTO alw_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ላገሴ ጎት አት «አት ሜንቲች ጉዕሚችን ማሰአንቶንትታን፤ ኪች እለመኖሁ ማሰአሞእሃን። ");
INSERT INTO alw_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ህትን ቀርችኤ አመት ኢቤቹ አሜቱ ሀትናሙሃ ሎረ ኬዕምኝ? ");
INSERT INTO alw_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","መሰንትስ ከለእ! ወገሬትክ ላገተ ሞጮጬም ወክት ጎደባንከኤ ዮ ጩሉ ተሽቲን አለጴእ። ");
INSERT INTO alw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ህትን ቀርቹ ኩሎሴ ጠዉ ዊመኖሃ እሁስ አመዕንቶኢት እሴ ማሰአንቶእተ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","መርየመ «ፎልቹኤ መገኑ ገለትጭታአ፤ ");
INSERT INTO alw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ህትን ቀልቡኤ ፌሳንቾ መገኖን ሙንደአኖ። ");
INSERT INTO alw_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","መሰንትስ መገኑ ሮስቾስ ህንቀሙ ለዕዮኡ፤ ህትን ከበሬች ኬሽ መኑ ጉዕሙንኩ ‹ማሰአንቶእተ› የኖኤ። ");
INSERT INTO alw_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ህትን ወልቃሙ መገኑ ኤሳሃ አበ ጠወ አዕዮኤ። ሱዕሙስን ጠሊለሃን። ");
INSERT INTO alw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ህትን እሱ ዋጅታ መኒሃ ጉዕሚንከ መገኑ እላች እለ እለተ ኢለሬተ ማረኖሰ። ");
INSERT INTO alw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","አንጋንተስን ጠረኘ ሆጉተ አዕዮኡ፤ ቦንታ መነንከ ቀልብሰ ሰውቲንን ብን አዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ህትን ሎራኑተ ሹምነቱ ዮሰረ ኬዕምኝ ቦርጭማችሰ ድርሾኡ፤ ጠው እኮጎሬ ገዉሰ ሆፍሳእረ ኬዕምሾሰ። ");
INSERT INTO alw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ህትን ጎሩ አፎሰራ ጡመ ጠዊን ዱሴሰ፤ እኮጎሬ ቀባጣመተ ኦነ አንገንተ መርታገ አዕዮሰ። ");
INSERT INTO alw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","ህትን መገኑ አናኖተኔ ጠወዕዮገን እብራሂሚሃለከ ዘሬተስ ዘላለሚሃ አጉሩስ ሰውይ ሮስቹስ እስራኤለ ሀዕልዮኡ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","መርየመን ኤልሰቤጤን ሜጡበ ሰሶ አገን ጌሰ አፉዕልቶች ኤተሮን ምንሴ ፈንቀልት መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ኤልሳቤጥ እልታ ወክቱ ኢልየን ለቤ ጩልንከ እልቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ህከኒሃ ኦሎሴለከ እሉሴ ጉዕሙንኩ መገኑ አበ አሙዦሴገ ሞጮጭት እሴንን ሜጡበ ሙንደኦኡ። ");
INSERT INTO alw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","እሰን ህዘትቅ በሬን ጩል ጡርከንቶተ አሜት አንስ ሱዕሚን «ዘከርየ» ይት ገእቶተ ሀሶኡ። ");
INSERT INTO alw_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ጠው እኮጎሬ አመስ «ህትጎተበአ፤ ‹ያህይ› የመም ገአመኖ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ህካን እኮቤቺሃ እሰን «ኪ ዘሬች ከን ሱዕሚን ገአሞኢሁ ዮበእንዶ?» ይቶሴ። ");
INSERT INTO alw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ህከኒች ኤተሮን እሰን ጩሉስ አዬ የመም ገአሞተ ሀሰኖ ጎሬ ደጎተ አነስ መላን ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ዘከርየን ከተቤኖሃ አሶኖስተ ጠዕም «ሱዕሙስ ያህይት» ይ ከተቦ፤ ህከን ጠዋንን ጉዕሙንኩሰ አጀብሲጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ህከ ወክት ዘከርየ አፎስ ፈንተዕያንለከ አረብስ ሂርተኣን መገኑ ገለትጨን ጠወኡ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ህካን እኮቤቺሃ ቀዕየ መኑ ጉዕሙንኩ ዋጄእ፤ ህትን ሁኩ ጠው ጉዕሙንኩ ቆተ ይሁድ ባዶን ጉዕማንን ጠወአሞ። ");
INSERT INTO alw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ህከ ጠወ ሞጮጬ መኑ ጉዕሙንኩ «ኩ ጩሉ ሀትናሙ እሆታት?» የን ጠወስ ቀልቤንከስ አፎ፤ መሰንትስ መገን ዎልቀት እሲን ሜጡበ ሄኦቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ጩል አኑ ዘከርይ ጠሊለ አያኒን ዊም ");
INSERT INTO alw_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«ኡመትስ ለዕዮቤቺሃለከ ፌሾቤቺሃ እስራኤል ቀርቹ መገኑ ማሰአሞሃ እሁን! ");
INSERT INTO alw_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ካዲንቾ ደዉዴ ዘሬ ምኒች ጠረኘ ጡምሳንቹ ኬሾኔ፤ ");
INSERT INTO alw_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ዎዕኔ ዘማኒች ኬሽ ሄኦ ጠሊላኖ ነብያኖ አፎን ጠወዕዮገን፤ ");
INSERT INTO alw_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ዲኒችለከ ግበኖኔ መን አንጋች ፌሾኔ። ");
INSERT INTO alw_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ህካን አዕዮንኩ አናካተኔ አጉሮተለከ ጠወዕዮ ወኣድ ላገተ ዊንሾተ ሰው ይዪት። ");
INSERT INTO alw_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ከ ወኣድ ላገንተ ጤሌዕል ኣሴኢሁ አኒሀኔ እብራሂሚሃ ");
INSERT INTO alw_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ዲን አንጋች ነጠ ፉልን ዋጅኑዕናን ካደሞሲታት፤ ");
INSERT INTO alw_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ህትን ሄዕናም ዘማኔን ጉዕማንን መገን ብሬን ጠሊልማንለከ ፈይማን ሄዕኖታት። ");
INSERT INTO alw_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ህትን ኮ ጩሌ! ጠሊለ ሎረ መገን ነብዬቹ ዬኖሄ። ወቃንከ ብዝ አቶተ ሄጭት ቀርች ብሬን መርታንት። ");
INSERT INTO alw_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ቀርቹ ጩብሰ አጉሮ ይ ጡም ኤንኬዕኑ ኣሰኖሰ። ");
INSERT INTO alw_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","መገኑኔ መረርሲጫንቹለከ ጎደበ ላፈ እኮቤቺሃ ፈቅ ኑሩ ሰሜች ለሎተ አአኖ። ");
INSERT INTO alw_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","እስን ቱንስቾንለከ ሬሆ ሀላን አፉዕልቶ መኒሃ ጉዕሚንከ ለሊሰኖ፤ ሎከኔ ወጌሬት ወቃሃ አዎንሰኖ» ይ ራገ ጠወዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ሁኩ ጩሉንኩ ገዉሲ ነጵ አያኒን ጠረኘ እኮ፤ እስራኤል መኒሃ ለለኖ በሩ ኢሎተ ኢለ ኡለ ኡድማን ሄዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ህከ ወክት ሮም ገሽቶ ኣዜን ዮ መነ ጉዕመንከ ወለኢሃ ሮም ዎሚች አውግስጦሴች ትዛዙ ፉሎ። ");
INSERT INTO alw_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ህከ ወዕኔ ዎሊንሽ ወክት «ቄሬኔዎስ» ዬኖ መንቹ ሶሪይ ባዱ ገሸኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ህካን እኮቤቺሃ መኑ ጉዕሙንኩ ሱዕመስ ከተብሲሶተ ገገዉንኩስ ገገይስ ከተመ መረኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","ዩሱፍን እለንሹስ ደዉዴ ምኒ ዘርተ እኮቤቺሃ እሲሃ ኣሴናንስ ላፈተ እኮ መርየማን ሜጡበ ገሊላን ሄዕዮ ናዝሬት ከተሚች ኬዕይ ይሁድ ባዶን ሄዕዮ «ቤተሌመ» ዬኖ ደዉዴ ከተመ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ለሙንኩሰ ህከኔ ሄኦገን መርየመ እልታ ወክቱ ኢሌእ። ");
INSERT INTO alw_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ህከንቤቾንን ሀንገፈ ጩል እልቶኡ፤ ኮሁ ገለኖ ምኔን ቤቹ ዮሰበእቤቺሃ ኦድኖን ጣጥ ጋድር ብሬን ለሉ ህጥተ እተኖ ገበት ኣዜን ኦሲሶስ። ");
INSERT INTO alw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ህከን ቀኤን ባዳን ሆለ ዜሞሃ አገርተን አብሌ ገልታ ዜማኑት ሄኦ እቅ፤ ");
INSERT INTO alw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","እሳንከ ቀርች መላይኬቹ ለሌሰ፤ ህትን ቀርች ኬዕምኝ ኑሩ አዳንከሰ በለቆ፤ እሰን አበ ዋጅቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ጠዉ እኮጎሬ መላይኬቹንኩ እሰንተ «መኒሃ ጉዕሚንከ አበ ሙንዲኑተ አፍ ክዕኔበ አሜቾምቤቺሃ ዋጅቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ከበር ደዉዴ ከተማን ጡምሳንቹ ቀርቹ መሲሁ እለሞህዕኔ። ");
INSERT INTO alw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ሰብዬቹ ሆጮን ጣጤን ለሉ ህጥተ እተኖ ገበታን ኦስሴናን ደጌነንተ፤ ሁኩን መላተ እሀኖህዕኔ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ድንገቴን ልግቡ ሰሜ መላይከ ጎጎቱ ህከን መላይኬቺን ሜጡበ ለልቶኡ፤ እሰን መገኑ ገለትጭተን ");
INSERT INTO alw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«ሎርመት አሌ ሰማን መገኒሃ እሁን፤ መገኑ መረርሲጨኖስ መኒሃ ኡለ አሌን ወገሬቱ እሁን» ይታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ሁኩ መላይከንት እሳች አደ እክ ሰማ መርቶ ወክት ዜማኑት ገገዉንኩሰን «ቴሁ ኬዕዬ! ቤተልሄመ ኢለ መርን ቀርቹ ኩሎኔ ከ እኮ ጠወሃ ለዕኖ» የቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","እሰን ደዕልት መርት መርየመለከ ዩሱፈ ህትን ለሉ ህጥተ እተኖ ገበታን ኦሰዕዮ ጩል ደጎኡ። ");
INSERT INTO alw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ህትን ሰብዬቹ ጩል ለኦ ወክት ህከን ሰብዬችተኔሃ ኩለሞሰርቹ ጠወኦኡ። ");
INSERT INTO alw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ህካን ሞጮጭቶእሩ ዜማኑት ኩልቶሰ ጠዋን አጀብሲጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ጠው እኮጎሬ መርየመ ህከ ጠወ ጉዕመንከ ቀልቤንከሴ አፍ ሰውይታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ዜማኑት ኩለሞሰገን ሞጮጭቶሀኒሃለከ ለኦሀኒሃ ጉዕሚንከ መገኑ ሎርስተንለከ ሹክር ኣተን ፈንቀልት መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ህዜትቅ በር ጩልስ ጡርከሜኖ ወክት ሱዕመስ «ኢሰ» ዬን ገኤመ፤ ሁኩንን አመስ ጎደባን አፉዕሉዕናን ሄጭ መላይኬቹ ፉሽዮስየ ሱዕመ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","ሙስ ሕጋን የመሞገን እሰን ነጠ እካ ወክቱ ሆንጠካን መገን ሴራን «ዎዕነ እለመኖ ለቤ ቤቱ ጉዕመንከ መገኒሃ ኣሴናን አደ እሁን» የመም ከተበሞገን ጩልስ ቀርች ብርተ ሆንጠህሲሃ ዬሩሳሌመ መስቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ህትን መርቶኢሁ ቀርች ሕጋን «ለሙ ሀንደዕርተ ህከረንገ ለሙ ዱብሀንደዕሬ ጭጮራ ሆንጠህሱን» የመሞገን ክትመ ሆንጠህሲሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ህከ ወክት ዬሩሳሌም ከተማን «ስሞኔ» ዬኖ ገዉስ መገኒሃ ኣሴ ፈዩ መንቹ ሄዕዮ እቅ፤ እስን እስራኤል ጡም ተቢሳሃ አገረኖት እቅ፤ ጠሊሉ አያኑ እስ አሌን ሄዕዮ እቅ፤ ");
INSERT INTO alw_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","እስን መገኑ እቴስ ቀርቹ መሲህ ለኡዕናን ሄጭ ሬህበገ መገን አያኑ ለሊሾስ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ስሞን ጠሊሉ አያኑ ቃግሻንስ ዱእ ምኒ ኦሮዕዮ፤ ዩሱፍለከ መርየመ ሴራን ሮሰሞገን አቶተ ጩል ኢሰ ዱእ ምኒ አፍ ኣጎኡ። ");
INSERT INTO alw_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ህከ ወክት ስሞን ጩል ቶግ ሀንቀፍ መገኑ ገለትጨን ");
INSERT INTO alw_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«ቀርቾ! ቴሱ ካድንቹክ ጠወኦንት ላገክገን ወገሬቲን ህርስሴኤ፤ ");
INSERT INTO alw_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ጡምሱክ እሌንከእ ለዕዮም፤ ");
INSERT INTO alw_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","እስን መገኑ አመዕንበ መን ጉዕም ብሬን ቅጥአቶንቲሃን፤ ");
INSERT INTO alw_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","እስን መገኑ አመዕንዮበእ መኒሃ ፈኝ ለሊሰኖ ኑር እሀኖ፤ ህትን እስራኤል ኡመቲሃ ኬዕምኝያ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","አመስለከ አኑስ ጩልተኔሃ ዬን ጠወኤመ ጠዋን አጀብሲጭቶ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","ስሞንን እሰንተ ማሰዕዮሰ፤ ህትን ጩልስ አመት መርየመ «ኩ ጩሉ አበ መን ቀልብ ሰውቱ ደገሞተ እስራኤል ኣዜን ሄዕዮ ልግብያ መኒሃ ኡቢሃለከ ኬኢሃ መገኑ ኤቦስ፤ ህከ መላተ ልግቡ መኑ ግቦስ፤ ኪ ቀልብ ሻዙት ሲፍገ ሙርታአ» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ህትን አሴር ደቦች ፋኑኤሌ ቤቱት «ሃነ» ዬኖ ራጋንቹት ሄኦ እቅ፤ እሴን ገልቶች ኤተሮን ጨይንከሴ ሜጡበ ለመለ ዘማን ሄኦእተ እቅ፤ ህትን አበ ባልቆ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","እሴን ምንሴ አኑ ዮበኢሃ ህዜታይኔ ሾሉ ዘማን ሄኦ እቅ፤ እሴን ሀንከዕርተለከ በራሃ ዱእ ምኒች ሆሮ አደ እኩዕናን ሶመንተንለከ ዱአ አተን መገኑ ካደንታ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ህከ ወክትንከ እሴ አሜት መገኑ ገለትጭተን ዬሩሳሌም ጡሙ ተቢሴን አገርታ መኒሃ ጉዕሚንከ እስተኔሃ ኩልቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ዩሱፍለከ መርየመ ጉዕመርቹንከ ቀርች ሕጋን የመሞገን አቶች ኤተሮን ገሊላን ሄዕዮ ከተመ ናዝሬተ ፈንቀልት መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ጩሉንኩ ነጵ ጠራኜእ፤ ህትን ሀይቹ እኮ፤ ህትን መገን ኣስቱት እሲን ሜጡበ ሄኦ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","አኑስለከ አመስ ዘማን ዘማኔን ሻሽግ ከበጃት ከበጅቶተ ዬሩሳሌም ከተመ መርታ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ኢሲንከ ቶነ ለሙ ዘማን እኮስ ወክት ዎዕነ ሮሰሞገን ከበጃት ከበጂሃ ዬሩሴሌመ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","በሩስ ጎፎች ኤተሮን እሰን ምኒ ፈንቀልታን ጩሉ ኢስ ዬሩሳሌማን ፈቆ እቅ፤ ህካን አኑስለከ አመስ ደጎበአ። ");
INSERT INTO alw_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ሀራቲን ሜጡበ አሜተኖሃ አጉጃንሰ መቶ በሬ ዎቃ ሃንተን ሆሶኡ፤ ህከኒች ኤተሮን እሉሰ ዮቤቹለከ ደጋ መንቤቾን ሀሶስ። ");
INSERT INTO alw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ሀስ ሆጎ ወክት እሱ ሀሰን ዬሩሳሌመ ፈንቀልት መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","እስን ተማርሲሰ መን በላን አፉዕል ሞጮጨንለከ ጠዕምቱተ ጠዕመን ሰሶ በሬች ኤተሮን መገን ምኔን ደጎስ። ");
INSERT INTO alw_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ሞጮጭቶ መኑ ጉዕሙንኩ አጥራመች ቶጊንከስለከ መስሊንከስ አጀብሲጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ዩሱፍለከ መርየመ ለኦ ወክት አበ አጀብሲጭቶኡ፤ አመስን «ኢ ጩሌ! ሚሃት ህት አቶንትኔሁ? ህትን አኑኪ አን ጨነቀመን ሀንሳንኬት እቅ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","እስን «ሚሃ ሃሴነዕኔ? አኒሀኤ ዮርቾን እሁ ሀስሰኖኤሀ እሁስ ደጌነንተበእንዶ?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","እሰን ጠወዕዮሰ ጠወሃ አጥራመቶበአ። ");
INSERT INTO alw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ህከኒች ኤተሮን እሳኒን ሜጡበ ናዝሬተ አሜቾ፤ እሳንከ አዘዘመኖሰ እቅ፤ አመስ ህከ ጠወሃ ጉዕመንከ ቀልቤንከሴ አፋ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ኢስ መገንለከ መን ብሬን አያኒን ዊም ሀይማንለከ ጉባን ነጰን መረኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ሮም ዎሙ ጢባርዮስ ዎመ እኮ ቶና ኦንትቅ ዘማን ጴንጠናዊ ጵላጦስን ይሁዳ ገሸኖ እቅ፤ ህትን ሄሮድስን ገሊላ ባዱ ሄሮድሴ አመቤቱ ፊልጶስን «ኢጡርያስለከ ጥራኮኒዶስ» ዬኖ ባዱ ሊሳንዮሰ ህትን «አቢሌኔ» ዬኖ ባዱ ገሽታእረ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ህትን ሐናኒለከ ቀያፊ መገን ምኔን ሎርሎራኖ ቂሰተ አዎንሰኖ እቅ፤ ህከ ወክት መገን ላገት ዘከርይ ጩልቤቹ ያህይበ ኡለ ኡድማን አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ህካን እኮቤቺሃ ያህይ ዮርዳኖስ ዊ አዝጋጌን ጉዕማንን ዘሀን «ጩብሀክዕኔ ጡሙ ደእቶኖተ ቶበቴን ጠመቀሜ» የን ተማርሰኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ህካን እኮሁ ነቢዬቹ እስያስ ያህይተኔሃ ሄጭ «ሁኩዕኑን! ኩን ኡለ ኡድማን ህት የን ያረኖ መንችተ ላገ፤ ‹መገን ዎቃሃ ቅጥአዕዬ! ህገኖ ቤቹንከ ብዝ አዕዬ! ");
INSERT INTO alw_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","በዕዮቤቹ ጉዕሙንኩ ዊሙን! ቆተትለከ ቆሩት ጉዕሙንኩ ራሰተ እኩን! ሾኩ ዎቆንኩ ጌጥ ዩን! ሂሉ ዎቆንኩ ብዝ ዩን! ");
INSERT INTO alw_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","መኑ ጉዕሙንኩ መገን ጡምሱ ለኡን!›» የመም ከተበሞጋት። ");
INSERT INTO alw_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ህካን እኮቤቺሃ ጠመቆሰተ አሜቶ ልግብ መነ ያህይ «አዕኑ ኩ አዳዌ እለት! አሜታ ኡሙዕሬች ሁንቶኖተ አይ ኩሎህዕኔ? ");
INSERT INTO alw_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ቴሱ ቶበቱክዕኔ ለሊሳ ሆጉተ አዕዬ ቤሉ ነኡ ‹እብራሂምተ እለ› ይቴነን ቀልብክዕኔ ጠዊን ድከኦኖቼ፤ መሰንትስ መገኑ ከን ክኒች እብራሂሚሃ እለተ አዕይ ኬሶተ አታለኖገ ኩላንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ቴሱ ከልቱ ሀቅ ፎቃን አፉዕልዮኡ፤ ህካን እኮቤቺሃ ጡመ ላልቹ ላልቡ ሀቁ ጉዕሙንኩ ሙርተዕይ ጊራን ኣገኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ሁኩ መኑንኩ ያህይ «ቴሱ መ አዕኑ?» ይት ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","እስን ፈንቀሽ «ለሙ ኦድኑት ዮሲሁ ዮስበእሀኒሃ ኣሱን፤ እቴኖሁ ዮሲሁ እቴኖሁ ዮስበእሀኒሃ ቤሁን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ህትን ቀረጠ ሙርታእሩ ጠመቀንቶተ አሜት «አስተማርቾ! ነኡ መ አዕኑ?» ይት ጠዕምቶ ወክት ");
INSERT INTO alw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","«ሕጊን ፈቀደሞህዕኔሀኒች በትሴን ኣእቶኖቼ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ህትን ወታደሩንኩ «ነኡ መ አዕኑ?» ይት ጠዕምቶ ወክት «መቶ መንቺች ወልቃን ዘረፎኖቼ፤ መቱ መንቹሃ ክዝቢን ከሰሶኖቼ፤ ገይክዕኔ ደሞዙ እሁንክዕኔ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","መኑ ተብሴን አገረኖቤቺሃ ጉዕሙንኩ መኑ ቀልቤንከስ ያህይ «ኩን መሲህትንዶ?» ይት ሰውይታ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ያህይን «አን ዊን ጠመቃንክዕኔ፤ ጠዉ እኮጎሬ አን ጫዕማስ ወደሩ ሂሮተ አታልቡ ኢች ጠረኙ አሜተኖ፤ እስን ጠሊለ መገን አያኒንለከ ጊራን ጠመቀኖህዕኔ፤ ");
INSERT INTO alw_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","እስን ኦድ አሌን ዉጠተ ጋቢች አደ አኦተ ቤለ አንጋንከስ አፎኡ፤ ጠዉ እኮጎሬ ጋበስ አደ አዕዮች ኤተሮን ዉጠተ ቀፎን ወረኖ፤ ጋበንከ ጠእትበ ጊራን ቡሰኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ህትን መነ አበ ሸዘነተ ሸዘን ተሽት ላገተ ዱዱብሰኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ጠዉ እኮጎሬ ገሊለ ባድ ገሻንቹ ሄሮድስ አመስ ቤት ፊልጶሴ ጫተ ሄሮድያደ ኣኤቤቺሃለከ ዎሉ አዕዮ ተንኮተ ጉዕሚንከ ያህይ ሻቆስ። ");
INSERT INTO alw_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ሄሮድስ ተንኮ አሌን ተንኩተ አዕይ ያህይ ኡሱር ምኒ አግሾስ። ");
INSERT INTO alw_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","መኑ ጉዕሙንኩ ጠመቀሞች ኤተሮን ኢስ ጠመቀሞ፤ እስን ዱአ አአንን ሰሞ ፈንተዕያን ");
INSERT INTO alw_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ጠሊሉ አያኑ ሀንደዕሬገ እክ አሌስ ድሬእ፤ ህከ ወክትንከ «ኢታም ቤቱኤ አቴት ኪን ተሽ የኖኤ» ይታ ላገት ሰሜች አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ኢስ ሆጉተ ጀመረኖ ወክት ሰጁ ዘማን ጌሰ እኮስ እቅ፤ መኑ እሱ ዩሱፍያ ቤቱ ይ ሰውየኖ እቅ፤ ዩሱፍ ኤልያ ቤቱ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ኤል ማቲያ ቤቱ፥ ማት ሌዊያ ቤቱ፥ ሌዊ ሚልክያ ቤቱ፥ ሚልኪ ዮና ቤቱ፥ ዮና ዩሱፍያ ቤቱ። ");
INSERT INTO alw_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ዩሱፍ ማታትዩያ ቤቱ፥ ማታትዩ አሞጽያ ቤቱ፥ አሞጽ ናሆምያ ቤቱ፥ ናሆም ኤስልምያ ቤቱ፥ ኤስልም ናጌያ ቤቱ። ");
INSERT INTO alw_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ናጌ ማኣትያ ቤቱ፥ ማኣት ማታትዩያ ቤቱ፥ ማታትዩ ሴሜይያ ቤቱ፥ ሴሜይ ዩሱፍያ ቤቱ፥ ዩሱፍ ዮዳያ ቤቱ። ");
INSERT INTO alw_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ዮዳ ዮናንያ ቤቱ፥ ዮናን ሬስያ ቤቱ፥ ሬስ ዘሩባቤልያ ቤቱ፥ ዘሩባቤል ሰላትያልያ ቤቱ፥ ሰላትያል ኔርያ ቤቱ። ");
INSERT INTO alw_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ኔር ምልክያ ቤቱ፥ ሚልኪ ሐድያ ቤቱ፥ ሐዲ ቆሳምያ ቤቱ፥ ቆሳም ኤልሞዳምያ ቤቱ፥ ኤልሞዳም ዔርያ ቤቱ። ");
INSERT INTO alw_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ዔር ዮሴዕያ ቤቱ፥ ዮሴዕ ኤልዔዛርያ ቤቱ፥ ኤሌዔዛር ዮራምያ ቤቱ፥ ዮራም ማጣትያ ቤቱ፥ ማጣት ሌዊያ ቤቱ። ");
INSERT INTO alw_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ሌዊ ስሞንያ ቤቱ፥ ስሞን ይሁድያ ቤቱ፥ ይሁድ ዩሱፍያ ቤቱ፥ ዩሱፍ ዮናንያ ቤቱ፥ ዮናን ኤልያቅያ ቤቱ። ");
INSERT INTO alw_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ኤልያቅ ሜልያ ቤቱ፥ ሜልያ ማይናንያ ቤቱ፥ ማይናን ማጣትያ ቤቱ፥ ማጣት ናታንያ ቤቱ፥ ናታን ዳዉድየ ቤቱ። ");
INSERT INTO alw_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ዳዉድ እሴይያ ቤቱ፥ እሴይ ኢዮቤድያ ቤቱ፥ ኢዮቤድ ቦኤዝያ ቤቱ፥ ቦኤዝ ሰልሞንያ ቤቱ፥ ሰልሞን ነአሶንያ ቤቱ። ");
INSERT INTO alw_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ነአሶን አምናደብያ ቤቱ፥ አምናደብ አድምንየ ቤቱ፥ አድሚን አሮኒያ ቤቱ፥ አሮኒ ሔጽሮምያ ቤቱ፥ ሔጽሮም ፋሬስያ ቤቱ፥ ፋሬስ ይሁድያ ቤቱ፥ ይሁድ ያቁብያ ቤቱ። ");
INSERT INTO alw_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ያቁብ ኢሳቅያ ቤቱ፥ ኢሳቅ እብራሂምያ ቤቱ፥ እብራሂም ታራሃ ቤቱ፥ ታራ ናኮርያ ቤቱ። ");
INSERT INTO alw_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ናኮር ሰሩጊያ ቤቱ፥ ሰሩግ ረኡያ ቤቱ፥ ረኡይ ፈሌቅያ ቤቱ፥ ፋሌቅ አቤርያ ቤቱ፥ አቤር ሳላሃ ቤቱ። ");
INSERT INTO alw_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ሳላ ቃይንያ ቤቱ፥ ቃይን አርፋክስድያ ቤቱ፥ አርፋክስድ ሴምያ ቤቱ፥ ሴም ኑህያ ቤቱ፥ ኑህ ላሜህያ ቤቱ። ");
INSERT INTO alw_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ላሜህ ማቱሳልያ ቤቱ፥ ማቱሳል ሔኖክያ ቤቱ፥ ሄኖክ ያሬድያ ቤቱ፥ ያሬድ መላልኤልያ ቤቱ፥ መላልኤል ቃይናምያ ቤቱ። ");
INSERT INTO alw_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ቃይናም ሄኖስያ ቤቱ፥ ሄኖስ ሤትያ ቤቱ፥ ሤት ኣደምያ ቤቱ፥ ኣደም መገንያ ቤቱ ይታ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","ኢስ ጠሊሉ አያኑ ዊማንስ ዮርዳኖስ ዊች ፈንቀል አሜቾ፤ ህከኒች ኤተሮን ጠሊሉ አያኑ ኢሰ ኡለ ኡድመ ኦሮአኖገ አዕዮስ፤ ህከኔን ሸይሉ በር እልብሱ ፌተኞስ፤ ህከን በራካንን መቱርቹሃ እቱ ሆጎቤቺሃ በሩስ ጎፎ ወክት ጎር አፎስ። ");
INSERT INTO alw_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ህከ ወክት ሸይጣኑ ኢሰ «ህንዴ አት መገን ቤቱ እኮንትጎሬ ከ ክኑ ዳቡተ እሁን ይት አዘዝ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ጠዉ እኮጎሬ ኢስ « ‹መኑ ጠለዕል እቴኖርቺን ሄአኖበአ› የመም ከተበሞኡ» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ህከኒች ኤተሮን እልብሱ ኢሰ ቆሮ አል ፉሽ ኣዱንያ አል ዎመተ ጉዕመንከ ገለብቴንን ለሊሽስ ኬዕይ ");
INSERT INTO alw_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","«ከ ገሽ ወልቀተለከ ሎርማሰ ጉዕመንከ ኣሳንኬ፤ ኩ ኬዕምኙ ኤሳሃ ኣሰሞኤቤቺሃ አን ሀሾምሀኒሃ አዬሃ ኣሶተ አታላም። ");
INSERT INTO alw_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ህካን እኮቤቺሃ አት ኤሳሃ ሰገዶንቴኤ ጎሬ ኩን ጉዕሙንኩ ኬሳሃ እሀኖሄ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ኢስን « ‹ቀርቹሃ መገኒሃክ ሰገድ፤ ጠለዕል እሲንከ እባደተ አእ› የመም ከተበሞኡ» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ህከኒች ኤተሮን እልቢሱ ኢሰ ዬሩሳሌመ መስስ ዱእ ምኒ እሌ አሌን ኡርሽ «አት መገን ቤቱ እኮንትጎሬ ህንዴ ገዉክ ዎሮ ዋልት ኡብ፤ ");
INSERT INTO alw_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","‹ኬሳሃ አገርቶተ መገኑ መላይከተ አዘዘኖ፤ ");
INSERT INTO alw_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ህትን ሎከክ ክኖን ቆዕልታበእገ አንጋንከሰ ኬስ አፋሄ› የመም ከተበሞኡ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ኢስን « ‹ቀርቹ መገኑክ ፌተንቶት› የመም ከተበሞኡ» ይ ፈንቀሼስ። ");
INSERT INTO alw_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","እልቢሱ ኢሰ ፈተኝ ሹሎች ኤተሮን ወክቲሃስ አጉር ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ህከኒች ኤተሮን ኢስ ጠሊለ አያን ዎልቃን ዊም ገሊለተ ፈንቀሎ፤ እስ ዱዱቡንኩ ህከን አዳን ዮ ባዶን ጉዕማንን ሞጮጨሞ። ");
INSERT INTO alw_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","እስን ጭምት ምኔን ተማርሰኖ ወክት መኑ ጉዕሙንኩ ገለትጨኖስ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ህከኒች ኤተሮን ኢስ ነጴ ባዱ ናዝሬተ አሜች ሮሾገን አይሁድ አበ በሬን ዱአ አኤኖ ምኒ ኣግ አነበቦተ ኬዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ህከ ወክት ነብዬቾ እስያሴ መጻፈ ኣስቶስ፤ ህከ ጣጠሞ መጻፈ ፈኞ ወክት ");
INSERT INTO alw_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«ቀርች አያኑ ኢ አሌኒት፤ ተሽት ላገተ ቡጥቻኖተ ዱዱብሶተ ሹመ አዕይ ቡሮኤ፤ ኡሱረንቶእሩ ሂረንቶተ፥ ቆቁ መኑ ለኣገ አዋጆተ፥ ጭንፈንቶራ ሰዎልድማን ፉሾተለከ ");
INSERT INTO alw_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ህትን ቀርቹ ሙንዲሲሰኖ ወክቱ እሌገ አዋጆተ ሶኮኤ» የመም ከተበሞቤቹ ደጎ። ");
INSERT INTO alw_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ኢስን መጻፈ ጣጭ አስናደኖሀኒሃ ኣስ አፉዕሌእ፤ ጭምት ምኔን ሄዕዮ መኑ ጉዕሙንኩ ቱክ ይት ለኣስት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","እስን «ከበር ከን መጻፍ ላገት አዕኑ ሞጮጭቴነን ዊንቶኡ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ጉዕሙንኩ መኑ እስተኔሃ ጡመ ጠወ ጠወአኖት እቅ፤ ህትን ጠወአኖ ኣስቶ ላጋን አጀብሲጭት «ኩን ዩሱፍሃ ቤቱበእንዶ?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ኢስን « ‹አት ሀኪንቹ! ህንዴ ገዉክ ፈይስ› ይታ ተ ምሳልተ ሸክት ዮበኢሃ ኤሳሃ ይቴነንተገ ደጋም፤ ህትን ‹ቅፍርናሆም ከተማን አቶንቲሃ ነኡ ሞጮጭኖሚሃ ከን ገይክ ባዶን አእ› ይቴነንተኤ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ሀንቅንከ ያንክዕኔ፤ ነብዬቹ ገይስ ባዶን ሆሮን ኬዕምሴኖበአ። ");
INSERT INTO alw_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","«ሀንቅንከ ያንክዕኔ እልያሴ ዘማኔን ሰሱ ዘማንለከ ሌሁ አገነ ጤኑ ኡቡ ሆጎቤቺሃ ባዶን ጉዕማንን ጎሩ እኮ ወክት እስራኤል ባዶን ምንሰ አኑ ሬዮ ልግቡ ሜንቱ ሄኦ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ጠዉ እኮጎሬ እልያስ ሲዶነ ዬኖ ባዶን ሄዕዮ ሰረጵተ ዬኖ ቀዕያን ሄኣ ምኒ አኑ ዮሴበእ መንቾ ቤሉ ወልሀስ አዬሃ እስራኤላን ሄኣ ምንሰ አኑ ሬዮ ሜንትቤቹ ሶሀሞበአ። ");
INSERT INTO alw_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ህትን ነብዬቾ እልሳኤ ዘማን እስራኤላን ጎግ አል ጥዘነት አፎስ ልግቡ መኑ ሄዕዮ እቅ፤ ጠዉ እኮጎሬ ሶርየ ዬኖ ባድ ንዕማኔ ዬኖ መንች ቤሉ ዎሉሰ ፈይቶበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ህከን ጭምት ምኔን ሄዕዮ መኑ ጉዕሙንኩ ህካን ሞጮጭቶ ወክት ኡሙዕርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ጉዕሙንኩሰ ከተሚች አብል ፉሽቶሲች ኤተሮን ዎሮ ዋሽት ኡጅቶተ ሀስ ከተሙሰ እጃራሞ ቆሮ ገርደብ መድ መስቶስ። ");
INSERT INTO alw_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ጠዉ እኮጎሬ እስን በሊንከሰ ፉል ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ኢስን ገሊላን ሄዕዮ ቅፍርናሆም ከተመ ዎሮ ዋል ኦሮዕዮ፤ ህከኔን አይሁድ አበ በሬን ጉዕመረን ተማርሰኖሳት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ጠዉስ ደጊን እኮቤቺሃ እስ ተማርሰኖ ትምርቴን ጉዕሙንኩ አጀብሲጭታ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ህከኔን ዱእ ምኔን ዶሮረኖ ዱሩ አፎስ መንቹ ሄዕዮ እቅ፤ እስን ሎረ ላጋን ");
INSERT INTO alw_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«ናዝሬት ኢሰ! ኔሳሃለከ ኬሳሃ ም ደቀንሹ ዮኔ? ቤሶኔተ አሜትንዶ? አት አዬት ጎሬ ደንጋንኬ፤ አት መገንየ ጠሊለ» ይ ያሮ። ");
INSERT INTO alw_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ጠዉ እኮጎሬ ኢስ «ጨለይት እሲች ፉል!» ይ ሻቆስ፤ ህካን እኮቤቺሃ ዶሮረኖ ዱሩ ህከ መንቹ መን በላን ኡጅ መቱርቹሃ ምሩዕናንስ እሲች ፉሎ። ");
INSERT INTO alw_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ጉዕሙንኩ አጀብሲጭት ገገዉንኩሰን «ኩን ሀትኔታ ላገ? ወልቃንለከ ዳኞማን ዶሮረኖ ዱር አዘዘኖ ወክት እሰን አዘዘንት ፉልታኢት» የቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ኢስ ዱዱቡንኩ ህከን አዝጋጌን ሄዕዮ ባዶን ጉዕማንን ሞጮጨሞ። ");
INSERT INTO alw_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ኢስ ዱእ ምኒች ፉል ስሞኔ ምኒ ኣጎ፤ ህከኔን ስሞኔ በሉት ፋረ ደሙሜን ጥዞ እቅ፤ እሰን እሴንተ ፈይሶተ ኢሰ ኡጭቶስ። ");
INSERT INTO alw_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","እስን እሴ መድ ሆንጠክ ኡርኬዕይ ሁኩ ፋረ ደሙምት ገፈርቶተ አዘዣን አጉሮሴ፤ ህከ ወክት ኬእ እሰንተ ካደሙ ጀመርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","አሩ ኣጎ ወክት መኑ አደደ ጥዘናን ጥዞ ጥዘናመተ ጉዕመንከ ኢስበ ኤቦኡ፤ እስን መት-መትሰ አሌን አንገስ አሌሰ አዕይ ጉዕመንከሰ ፈይሾ። ");
INSERT INTO alw_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ህትን ሩሃንዩንኩ ልግብያ መኒች «አት መገንየ ቤቱ» የን ያረን ፉሎ፤ ጠው እኮጎሬ ኢስ ሻቆሰ፤ ህትን ዶሮረኖ ዱሩ እስ መሲህ እሁስ ደጎቤቺሃ እሲን ጠወኦተ ፈቀጆሰበአ። ");
INSERT INTO alw_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ኡለት ሶዞ ወክት ኢስ ህከንቤቺች ኬዕይ መኑ ዮበእቤቹ ኦሮዕዮ፤ ጠው እኮጎሬ መኑ እሱ ሀሰን አሜት እሰንተ አጉር ኦሮአኖበእገ ኡጭቶስ። ");
INSERT INTO alw_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","እስን «ዎሎ ከተሚሃ መገን ዎምነት ተሽት ላገተ ዱዱብሱ ሀስሰኖኤ፤ መሰንትስ አን ሶሀሞሚሁ ተን ሆጎታት» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ህካን እኮቤቺሃ ይሁድ ባድ ጭምት ምናን ፈንቀላመን ተማርሰኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","መቱ በር ኢስ «ጌንሴሬጠ» ዬኖ ባር መዴን ኡርዮሃኔን ልግቡ መኑ እስበ ሆንጠክ መገን ላገተ ሞጮጭቶተ ሀንበዕለንተን ");
INSERT INTO alw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ኢስ ባር ገበላን ኡርት ሄኦ ለሙ ጀልበ ለዕዮ፤ ቁርጩሜተ ወሻዳሩ ጀልብ ኣዚች ፉልት ወሻደሰ ኣንሽታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ኢስን ህከን ጀልቢች መቶንከስ ስሞኔሀኔን ኣግ ሎረ ባርበ ሽቅ አኦተ ስሞኔ ጠዕሜስ፤ ህከን ጀልባን አፉዕል ኡመት ተማርሴእ። ");
INSERT INTO alw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ኢስ ጠወዕይ ሹሎች ኤተሮን ስሞኔ «ጥዕላሻ አደ ዋሽቴን ቁርጩሜተ ወሻዶኖተ ወሻዳክኔ ኡጅዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ስሞንን ፈንቀሽ «ቀርቾ! ዊመ ሀዎሩተ አጰመን ገልን መቱርቹሃ አንፎምበአ፤ ጠዉ እኮጎሬ አት ይቶንቴኤች ወሻዳኤ ኡጃም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","እስ ዬገን አቶ ወክት ልግብ ቁርጩሜተ አፋን ወሻዱሰ ፊልተኡ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","እሰን ዎሎ ጀልባን ሄኦ ጃለሰ አሜት ሀዕልቶሰተ ቀቀሶሳ፤ ጃለሰን አሜት ለሞ ጀልባን ቁርጩሜተ ዊንሽታን ጀልቡሰ ዊን ኣአሞተ እኮ። ");
INSERT INTO alw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ስሞን ጴጥሮስ ህካን ለዕዮ ወክት ኢስ ሎከ አሌን ኡብ «ቀርቾ! አን ጩበኘ እኮምቤቺሃ ኢ መድ ሆንጠኮት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","እስ ህካን ዬ መሰት አፎ ቁርጩሜተስ እስለከ እሲን ሜጡበ ሄኦእሩ ጉዕሙንኩ አበ አጀብሲጭቶቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ህትን ስሞኔ ጃለት ዘብደዎሴ ኦሱት ያቁብለከ ያህይ አጀብሲጭቶኡ፤ ጠዉ እኮጎሬ ኢስ ስሞኔ «ዋጅቶት ከኒች ኤተሪሃ መነ ወሻዳንቲሃ እካንት» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","እሰን ጀልበሰ ኡለ አደ ሽቅ አቶች ኤተሮን ጉዕመርቹንከሰ አጉርት ኢሰ አዎንቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","መቱ በር ኢስ መቶ ከተማን ሄዕዮገን ጎግ አል ጥዘናን ጥዦ መቱ መንቹ አሜች ኢሰ ለዕዮ ወክት ብሬንከስ ኡብ «ቀርቾ! ተሽዬሄ ጎሬ ፈይሶኤተ አታልታንት» ይ ኡጬስ። ");
INSERT INTO alw_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ኢስን አንጋንከስ አልስ ሀጣዊ «ኤ ፈይ!» ዬስ፤ ህከ ወክትንከ ሁኩ ጎግ አል ጥዘነት ገፈርቶስ። ");
INSERT INTO alw_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ህትን ኢስ መንቹስ «ከ ጠወ መቶ መንቺሃ ጠወኦት፤ ጠዉ እኮጎሬ መርት ገዉክ ቂስቺሃ ለሊስ፤ እሲንከ እማኘ እሆተ ሙስ አዘዦገን ፈይቶንትቤቺሃ ክትመ ሆንጠህስ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ጠዉ እኮጎሬ ኢስ ዱዱቡ ጉዕመ ወክቲችን በትሽ ሞጮጨሞ፤ ልግቡ መኑ እሲች ሞጮጭቶተለከ ጥዘናችሰ ፈይቶተ ጭም ይታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","እሁን ቤሉ እስ ኡለ ኡድመ መር ሜጡንኩስ ዱአ አአኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","መቱ በር ኢስ ተማርሰን ገሊላን ይሁድ ባዶን ዮ ኦሌች ጉዕሚችለከ ዬሩሳሌም ከተሚች አሜቶ ፈርሳውያኑትለከ ሕግ አስተማረት መዴንከስ አፉዕልቶ እቅ፤ ኢሲንከ ጥዘናመተ ፈይሰኖ ቀርች ዎልቀት አሌስ ሄኦ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ህከ ወክት መቱ ሎከተ ናፈ መንቹ ዴሲን እጅት ኤቦኡ፤ እሱንከ ምኒ ኣግስ ኢስ ብሬን አፉሽቶተ ዎቃ ሀሳኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ጠዉ እኮጎሬ መኑ በተዕዮቤቺሃ ሎከተ ናፈ መንቹ ምኒ ኣግሳ ዎቃሃ ሆጎኡ፤ ህካን እኮቤቺሃ ምኒ እሌ አል ፉልት እሌስ ብሎኬቲች መቱ ጌሰ ፈንት ህከ ናፈ መንቹ ዴሲንከስን ኢስ ብሬን ድርሶኡ። ");
INSERT INTO alw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ኢስን አመዕነቱሰ ለዕይ «ኮ መንቾ! ጩቡክ አጉረሞሄ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ህካን እኮቤቺሃ ሕግ አስተማረትለከ ፈርሳውት «ኩ መገን አሌን ቦሮር ላገተ ጠወአኖሁ አዬት? ሜጥቾሃ መገን ቤሉ ጩብ ፈቁን ዮተ አታለኖሁ አዬት?» ይተን ሰውዩ ጀመርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ኢስ ሰውትሰ ደግ «ካን ቀልቤንከክዕኔ ሚሃት ሰውይቴነንታሁ? ");
INSERT INTO alw_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‹ጩቡክ ፈቁን› ዪችለከ ‹ኬዕ ሃም› ዪች ሀኩንስ ቆሀኖ? ");
INSERT INTO alw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ጠዉ እኮጎሬ ከን ኣዱንያ አሌን መንች ቤቲሃ ጩብ ፈቁን የኖ ሹምነቱ ሄኡስ ለሊሳንክዕኔ» ይ ፈንቀሽ ናፈ መንቹንከ «አን ኬሳሃ ያንኬ፤ ኬእ ዴሰክ እጅት ምንክ ኦሮእ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ህከ ወክትንከ ብሬሰ ኬዕይ ኦሰዕዮ ዴሰ እጅ መገኑ ገለትጨን ምንስ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ህካን እኮቤቺሃ ጉዕመንከ መነ አጀብሲሻን መገኑ ገለትጭተን «ከበር አጀብሲሰኖ ጠወ ለዕኖም» ይት አበ ዋጅቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ህከኒች ኤተሮን ኢስ ህከን አዲች ፉል «ሌዌ» ዬኖ ቀረጠ ሙረኖሃ ቀረጤኖቤቾን አፉዕሌእሃ ለዕይ «አወኔኤ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","እስን ጉዕመርቹንከ አጉር ኬዕይ አዎኞስ። ");
INSERT INTO alw_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ሌዊን ኢስሃ ምኔንከስ አበ ድግሰ ቅጥ አዕያን ልግቡ ቀረጠ ሙርታእሩለከ ዎሉ መኑሁ እሳን ሜጡበ ማዳን አፉዕልቶ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ፈርሳዊያኑትለከ ሕግ አስተማረት ኢስ አሳበተ «ቀረጠ ሙርታሀኑኡንለከ ጩበኛኖን ሜጡበ እቴነንታሁለከ አጌነንታሁ ሚሃት» ይት ቁንቁቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ኢስን «ሀኪሙ ሀስሰኖሁ ጥዘናማታት ቤሉ ፈይሃበአ። ");
INSERT INTO alw_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","አን አሜቾሚሁ ፈያኑተ ገኦተ እሁዕነ ጩበኛኑት ጩብችሰ ቶበት ፈንቀልታገ አኦታት» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ህከኒች ኤተሮን መት-መት መናከት ኢሰ «ያህይ አዎናኑትለከ ፈርሳዊያኖ አዎናኑት ልግብ ወክት ሶመንተን ዱአ አታአ፤ ጠዉ እኮጎሬ ኪ አሳበት እታኢሁለከ አጋኢሁ ሚሃት?» ይት ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ኢስን «እዜቹ እሳን ሜጡበ ሄዕዮገን ቦሎቸ ገኤመ ኮሃ ሶመንታገ አቶኖተ አታልቴነንንዶ? ");
INSERT INTO alw_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ጠዉ እኮጎሬ እዜቹንከ እሳች አደ አኤን መሴኖ ወክቱ አሜተኖ፤ ህከ ወክት ሶመንታአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ኢስን መት ምሳልተ «አዪሁ ሃዕሮ ኦድኖች ቃፈተ ፊል ኑባጵቶ ኦድኖን ቃፈኖሁ ዮበአ፤ ህካን አዕዮ ጎሬ ሃዕሮ እሱ ፊለኖ ቤሉ ሃዕሮ ቃፈት ኑባጵቶ ኦድኖን መክታበአ። ");
INSERT INTO alw_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ህትን አዪሁ ሃዕሮ ወይነ ቦበጤማሃ ኑባቾ ሆቆማዶን አፉሸኖበአ፤ ህካን አዕዮ ጎሬ ሃዕሮ ወይነ ቦበጤማሁ ሆቆማዱንከ ፊላንስ እስን ዱንተአኖ፤ ሆቆማዱንኩ በአኖ። ");
INSERT INTO alw_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ህካን እኮቤቺሃ ሃዕሮ ወይነ ቦበጤማሃ ሃዕሮ ሆቆማዶን አፉሹ ሀስሰኖ። ");
INSERT INTO alw_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ህትን አዪሁ ‹ዱንኬኢሁ ቆሀኖ› የኖቤቺሃ ዱንኬ ወይነ ቦበጤማሃ አጎች ኤተሮን ሃዕሮ እሱ ሀሰኖሁ ዮበአ» ይ ኩሎሰ። ");
INSERT INTO alw_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ኢስ አበ በሬን ውጠ በሊን ህገን አሳበስ ሀማሙተ ተንቅስ አንጋንከሰ ቁስተን እታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ህካን እኮቤቺሃ ፈርሳዉያኖች መት-መቱሰ «አበ በሬን አኡ ገበእባሃ አዕኑ ሚሃት አቴነንታት?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ጠው እኮጎሬ ኢስ «ደዉዴለከ እሲን ሜጡበ ሄኦ መኑ ጎሩ አፎሰ ወክት አዕዮሀ ");
INSERT INTO alw_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ሁኩንን እስ ዱእ ምኒ ኣግ ቂስ ቤሉ ዎሉ መኑ እቱ ፈቀደሞበእ ክትም ዳቡተ ኬሽ እቱስለከ እሲን ሜጡበ ሄኦ መኒሃ ኣሴገ አነበቤንታበእንዶ?» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ህትን እስ «መንች ቤቱ አበ በሬተ ቀርቹሃን» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ዎሎ አበ በሬን ኢስ ጭምት ምኒ ኣግ ተማርሰኖት እቅ፤ ህከንቤቾንን መኬስ አንገተ ናፎ መንቹ ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ሕግ አስተማረትለከ ፈርሳዉያኑት ኢሰ ከሰሶተ ወንጀል ደጎተ አበ በሬን ፈይሰኖ ጎሬ ለዕናም ይት አገርታ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ጠዉ እኮጎሬ ኢስ ቀልብሰ ጠወ ደግ አንገተ ናፈ መንቹ «ኬእ መን በላን ኡር» ዬስ፤ ኬዕይን ኡሬእ። ");
INSERT INTO alw_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ኢስን «ህንዴ መት ጠዕምቱተ ጠዕማንክዕኔ፤ አበ በሬን ጡመ ጠወ አኡሃንዶ ሂለ ጠወ አኡሃን ፈቀደመኖሁ? ነብሳሃ ጡምሱሃንዶ ህከረንገ ቤሱሃን?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","እስን ጉዕመንከሰ ዘህ ለዕዮች ኤተሮን አንገተ ናፈ መንቹ «አንገክ ሂር» ዬስ፤ ሁኩ መንቹንኩ አንገስ ሂሮ ወክት አንገንትስ ፈየተ እኮኡ። ");
INSERT INTO alw_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ጠዉ እኮጎሬ ሕግ አስተማረትለከ ፈርሳዉያኑ እሰን ኡሙዕርት «ከ ኢሰ መ አዕኑ?» ይት አማዕለንቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ህከ ወክት ኢስ ዱአ አኦተ ቆተ አል ፉል ኬዕይ ዊመ ሀንከዕርተ ዱአ አአን ገሎ። ");
INSERT INTO alw_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ኡለት ሶዞ ወክት አሳበስ እስበ ገእ እሳችን ቶና ለሙ መጠር «አሳበተ» ይ ሱዕምሾሰ። ");
INSERT INTO alw_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","እሰን «ጴጥሮሴ» ይ ሱዕምሾ ስሞኔት፥ ስሞኔ አመቤቱ እንድርያሴት፥ ያቁባት፥ ያህይት፥ ፍልጶሴት፥ ቤርቶሎሜዎሴት፥ ");
INSERT INTO alw_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ማቶሴት፥ ቶማሴት፥ እልፍዮሴ ቤቱ ያቁባት፥ ባዱስ ኢተኖ ስሞኔት፥ ");
INSERT INTO alw_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ያቁብ ቤቱ ይሁዳትለከ ኢሰ ህግሽ ኣሴ አስቆሮንቶ ይሁዳት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ኢስ አሳባንን ሜጡበ ቆታች ድር ባዳን ልግቤ ኡመቲን ኡሬእ፤ ሁኩ ኡመቱንኩ ሞጮጭቶተለከ ጥዘናችሰ ፈይቶተ ይሁድ ባዲች ጉዕሚች ዬሩሳሌም ከተሚችለከ ባር መዴን ሄዕዮ ጢሮስለከ ስዶን ከተሚች አሜቶእራ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ዶሮረኖ አያኑ አፋንሰ ኦርጨቀንተን ሄኦእሩ ፈይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ኢሲችን ወልቀት ፉልታን ጉዕመንከ ፈይሰኖቤቺሃ መኑ ጉዕሙንኩ እሱ ኡሎተ ሀሰኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ኢስን አሳበስ ለአን «መገን ዎምነቱ» ክዕኔሃ እኮቤቺሃ አዕኑ ቡጥቻኑት ማሰአንቴንታእራን። ");
INSERT INTO alw_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","አዕኑ ቴሱ ጎሩ አፎህዕኔሩ ዱቤነንተቤቺሃ ማሰአንቴንታእራን፤ ህትን አዕኑ ቴሱ ኦኤነንተሩ ኦሰዕልቴነንተቤቺሃ ማሰአንቴንታእራን። ");
INSERT INTO alw_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","መንች ቤት መሳን መኑ ግቦህዕኔ ጎሬ፥ ያዬመህዕኔ ጎሬ፥ ህንቄመህዕኔ ጎሬ፥ ሱዕመክዕኔ ሂልማን አፌመህዕኔ ጎሬ ማሰአንቴንታእራን። ");
INSERT INTO alw_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ዋጉክዕኔ ሰማን ሎረ እኮቤቺሃ ሁኩን ኢለኖህዕኔ ወክት ሙንዲኖን ተሽ ዩንክዕኔ፤ አናኑሰን ከኒች ብርንተ ነብያኑተ ህት አቶእራን። ");
INSERT INTO alw_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ጠዉ እኮጎሬ «አዕኑ ቀባጣመት» መከኖህዕኔርቹ ጉዕመንከ ደእቴነንተቤቺሃ ቆሃኖህዕኔ! ");
INSERT INTO alw_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ህትን «አዕኑ ቴሱ ዱቤንተሩ» ጎሩ አፈኖህዕኔቤቺሃ ክዕኔሃ ቆሃኖህዕኔ! ህትን «አዕኑ ቴሱ ኦሰዕልቴነንተሩ» ሻዜነንተቤቺሃለከ ኦኤነንተቤቺሃ ክዕኔሃ ቆሃኖህዕኔ! ");
INSERT INTO alw_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","መኑ ጉዕሙንኩ ጡመ ዱዱቡ ክዕኔተኔሃ ዱዱብሴህዕኔጎሬ ቆሃኖህዕኔ! አናኑሰን ክዝበኛኑተ ነብያኑተ ህት አቶእራን ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ኢስ «አን ክዕኔሃ ሞጮጭቴነንተኤሀኑኡተ ያንክዕኔ፤ ዲነክዕኔ ኢትዬ፤ ግባህዕኔሀኑኡሃ ጡመ አዕዬ፤ ");
INSERT INTO alw_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ቦሮርታህዕኔረ ማሰዕዬ፤ ቤሶህዕኔሀኑኡተ ዱአ አዕዬ፤ ");
INSERT INTO alw_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","መጫለክ ዎቀረኖሀኒሃ ለንክ እሱ ኣስስ፤ ነጠለክ ኣአኖሀኒሃ ሹራበክ በርግት ኣስ፤ ");
INSERT INTO alw_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ኡጨኖሄሀኒሃ ጉዕሚንከ ኣስ፤ ኪች ዱንያተ ኣኤ መንቹ ፈንቀሾሄተ ጠዕምቶትስ። ");
INSERT INTO alw_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","መኑ ክዕኔሃ አኦተ ሀሴነንታሃ አዕኑሁ ህትን አዕዬ» ያንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ኢትታህዕኔረ ኢትቴንተ ጎሬ መ ደግለለኖህዕኔ? መሰንትስ ጩበኛኑት ኢትታሰረ ኢትታአ። ");
INSERT INTO alw_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ህትን ጡመ አታህዕኔሀኑኡተ ጡመ አቴንተጎሬ መ ደግለለኖህዕኔ? ጩበኛኑቲ ህካን አታአ። ");
INSERT INTO alw_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ፈንቀሽቴን አእቶኖተ ተቢሳ አቴነንተሀኑኡተ ሌቄሴንተ ጎሬ ም ገለቱ ዮህዕኔ? ሌቄሶ ብከ ፈንቀሽት ኣእቶተ ጩበኛኑቲ ጩበኛኖተ ሌቄሳአ። ");
INSERT INTO alw_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ጠዉ እኮጎሬ ገለትጭትበሀኑኡተ ገዉሰ ኢትታሀኑኡተ መገኑ መረርሲጫንቹ እኮቤቺሃ ዲነክኔ ኢትዬ፤ ጡመ አዕዬ፤ መቱርቹሃ ፈንቀሽቴን ኣእቶኖተ ተቢሳ አቶኑዕነ ሌቄሼ፤ ህከኒሃ አጅሩክዕኔ ሎረ እሀኖ፤ ጉዕሚችን ሎረ መገን እለተ እኬነንተ። ");
INSERT INTO alw_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ሰሜ አኑክዕኔ መረርሲጫንቹ እኮገን አዕኑሁ መረርሲጫኑተ እኬ ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","ኢስ «ፈረዶኖቼ ፈረደመኖህዕኔበአ፤ ዎሉ መነ ዋሃኦኖቼ ዋሃኣንቴነተበአ፤ ‹ማሮንስ› ይዬ አጉረመኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ኣስዬ ኣሰመኖህዕኔ፤ ጡመ ብካንቾን ጢቤን ቱጉሜን ብኬናን በተዕይ ደፈፍ ይዮኢሁ ኣሰመኖህዕኔ፤ መሰንትስ ብክቴንተ ኦዳኒን ብከመኖህዕኔ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ኢስ ምሳሌኒን «ቆቁ መንቹ ቆቀ መንቹ አዎንሶተ አታለኖንዶ? ህካን አዕዮ ጎሬ ለሙንኩሰ ኤሎን ኡባበዕንዶ? ");
INSERT INTO alw_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ተማረኖሁ ተማርሰኖሀኒች በተአኖበአ፤ ጠዉ እኮጎሬ አዪሁ ጠረኝ ተማሮ ጎሬ አስተማርችስገን እሀኖ። ");
INSERT INTO alw_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«ገይክ እሌን ሎሩ ሁሩ ሄዕዮገን ጃልክ እሌን ዮ ሁረ ሚሃ ለአን? ");
INSERT INTO alw_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","አት ገይክ እሌን ዮ ሎረ ሁረ ለኡዕናን ሀት ጃልሃክ ‹ኢ ጃላ እሌክ ዮ ሁረ ፉሻም› ይቶተ ሀት አታልተን? ኩ ገዉክ ሎርስታንቲሁ! ሄጭት ገይክ እሌች ሁረ ፉሽ፤ ህከኒች ኤተሮን ጃልክ እሌች ሁረ ፉሽቶተ አጥረመት ለኦተ አታልታንት» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ኢስ «ጡሙ ሀቁ ሂለ ላልቹ ህከረንገ ሂሉ ሀቁ ጡመ ላልቹ ሆሮ ላለኖበአ። ");
INSERT INTO alw_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ህካን እኮቤቺሃ ሀቁ ጉዕሙንኩ ላልቺንከስ ደገመኖ፤ ኦዴቾ ላልቹ ኡቲች መጦኖተለከ ወይን ላልቹ ኡታሞ ሀቂች መጦኖተ አታሌኖበአ። ");
INSERT INTO alw_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","መኑ ቀልቤንከስ ዊም በተዕዮሃ አፌን ጠወአኖቤቺሃ ጡሙ መንቹ ጡመ ቀልቢችስ ጡመ ጠወ ፉሸኖ፤ ህትን ሂሉ መንቹ ሂለ ቀልቢችስ ሂለ ጠወ ፉሸኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","ኢስ «አን ኩላንክዕኔሃ አቴነንተበአ፤ ሚሃት ‹ቀርቾ! ቀርቾ!› ይቴነን ገእቴነንተኤሁ? ");
INSERT INTO alw_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ኢ ቤቹ አሜተኖሁ ጉዕሙንኩ ላገኤ ሞጮጭ አአኖሁ አዪሁ መ አጉደኖ ጎሬ ለሊሳንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ሁኩ መንቹ ምኒ እጃሮተ ጠረኝሽ ቀበበ እም ክን አሌን ምኒ ኤሎ እመኖ መንቹ አጉደኖ፤ ድርሱ አሜቾ ወክት ህከ ምን ሀንበሎ፤ ጠዉ እኮጎሬ ክን አሌን እጃረሞቤቺሃ ሌንቄቅሶተ አታሎበአ። ");
INSERT INTO alw_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ላገኤ ሞጮጭ አእቡ መንቹ ምኒሀስ ቀበብ ኤሎሃ እሙዕናን ኡለ አሌን ምኒ እጃሮ መንቹ አጉደኖ፤ ህከ ምኒ ድርሱ ሀንበላን ወክትንከስ ኡቦ፤ ህከን ምኒ ኡቡንኩ ሂለ እኮ» ይ ኩሎሰ። ");
INSERT INTO alw_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ኢስ መኑ ሞጮጨን ጠወዕይ ሹሎች ኤተሮን ቅፍርናሆም ከተመ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ህከኔ መቱ ጥቤ ሀለቁንኩ ሄዕዮ እቅ፤ እሲንከ አበ ደግለለኖስ ካድንቹ ጥዥ ሬሆተ ሆንጠኮ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ጥቤ ሀለቁንኩ ኢስተኔሃ ሞጮጬ ወክት አይሁድ ባልቃተ ኢስ አሜች ካድንቹኤ ፈይሶተ መርቴን ኡጭዬ ይ ሶኮሰ። ");
INSERT INTO alw_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","እሰን ኢስበ አሜቶ ወክት «ከ ጠወ አቶተ ሀስሰኖሃ መንቹ። ");
INSERT INTO alw_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","መሰንትስ ኩ መንቹ መነኔ ኢተኖሃን፤ ህትን ጭምት ምኒ እጃሮኔ» ይት ጠራኝስ ኡጭቶስ። ");
INSERT INTO alw_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ህካን እኮቤቺሃ ኢስን እሳን ሜጡበ ኦሮዕዮ፤ ጠው እኮጎሬ ምንስ ሆንጠኮ ወክት ጥቤ ሀለቁ ጃለስ «ቀርቾ! አት ኢ ምኒ ኣጎተ አን ገበእበ መንቹ እኮምቤቺሃ ኢቤቹ አሜቶተ ተርበ ይቶት። ");
INSERT INTO alw_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ህካን እኮቤቺሃ አን ኪበ አሜቶተ ገበእበሃን፤ ጠዉ እኮጎሬ አት ላገክ ጠወኦንት ጎር ካድንቹኤ ፈየኖ። ");
INSERT INTO alw_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","አን ኢች በተኣ ሀለቃተኤ አዘዘመን ኢች ዎሮን አዘዛንሰ ወታደሩ ዮኤ፤ ህከኑኡችን መቱስ ‹መር› ዬም ጎሬ መረኖ፤ ዎሉስንገ ‹አም› ዬም ጎሬ አሜተኖ፤ ህትን ካድንቹኤ ‹ካን አእ› ዬም ጎሬ አአኖ» ይ ኢስቤቹ ሶኮ። ");
INSERT INTO alw_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ኢስ ህካን ሞጮጬ ወክት እስን አበ አጀብሲጭ አዎነን ሄዕዮ ልግብያ መንቤቹ ፈንቀል «አን ኩላንክዕኔ፤ እስራኤላን ህትኔ አመዕነቱ ሆሮን ለዕዮምበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ሁኩ ሶሀንቶእሩ ምኒ ፈንቀልት አሜታ ወክት ካድንቹስ ፈይሃን ለኦኡ። ");
INSERT INTO alw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ኢስ ለንክ በር አሳባንለከ ልግቤ መኒን ሜጡበ «ናይነ» ዬኖ ከተመ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","እስን ከተመ ኣጌኖ ኡሩተ ሆንጠኮ ወክት ጀናዘተ እጅቶ መኑ ከተሚች እጅት ፉልታኢት እቅ፤ እስን አማተስ ሜጥቹሃ ቤቱ እቅ፤ አመስን ምኒ አኑ ዮሴበእተ መንቹ እቅ፤ ህከን ከተም መኒች ልግቡ መኑ እሴን ሜጡበ ሄኦ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ቀርቹንኩ ለዕዮሴ ወክት መረርሲጭሴ «ኦኦት» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ኢስን ሆንጠክ ዴሰስ ኡሎ ወክት እጅቶእሩንኩ ኡርቶኡ፤ እስን «ወደልቾ! አን ኬሳሃ ያንኬ፤ ኬእ!» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ህከ ወክት ሁኩ ሬዮ ጩሉንኩ ጎበስ ኬሽ አፉዕል ጠወኡንከ ጀመሮ፤ ኢስን ህከ ወደልቹንከ አማተስ ኣሴእ። ");
INSERT INTO alw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ህካን እኮቤቺሃ ጉዕመንከሰ ባበነት አፋንሰ «ጠረኙ ነብዬቹ በላንከኔ ኬዕዮኡ፤ ህትን መገኑ መነ ጡምሶተ አሜቾኡ» ይተን መገኑ ገለትጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","እስ ዱዱቡንኩ ይሁዳንለከ ህከን አዝጋጌን ዮ ባዶን ጉዕማንን ሞጮጨሞ። ");
INSERT INTO alw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ያህይ አዎናኑት ህካን ጉዕመንከ ዱዱብስቶስ። ህካን እኮቤቺሃ ያህይ አዎናኖችስ ለሙ እስቤቹ ገእ ");
INSERT INTO alw_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","«ሁኩ አሜተኖ ዬኖ መሲሁ አቴትንዶ ህከረንገ ዎሉ አገርኑ?» ይ ኢስቤቹ ሶኮሰ። ");
INSERT INTO alw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","እሰን ኢስቤቹ መርት «ጠመቃንቹ ያህይ ‹አሜታንት ዬኖ መሲሁ አቴትንዶ ህከረንገ ዎሉ አገርኑ?› ይ ኪቤቹ ሶኮኔ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ህከ ወክት ኢስ ልግብ መነ አደደ ጥዘናች ፈይሾ፤ ህትን ዶሮረኖ ዱርሃ ፉሼእ፤ ልግብ ቆቆ መነ ለኣገ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ኢስን ሶሀንት አሜቶእረ «መርቴን ያህይሃ ለኤንታሃለከ ሞጮጭቴንታሃ ሁኩንን ‹ቆቆ መኑ ለአኖት፤ ድኑ መኑ ሃመኖት፤ ጎግ አል ጥዘነት አፎሰሩ ፈይታኢት፤ ዶንቁ መኑ ሞጮጨኖት፤ ሬቶእሩ ሬሆች ኬኣኢት፤ ቡጥቻኖተ ተሽት ላገት ተማርሴኖት። ");
INSERT INTO alw_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ኢን ቆዕልባሁ ማሰአሞእሃን› ይቴን ኩሌስ» ይ ፈንቀሼሰ። ");
INSERT INTO alw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ያህይ አዎናኑት መርቶ ወክት ኢስ ህከን ልግቤ መኒሃ ያህይተኔሃ ጠወኡ ጀመሮ፤ እስን «መ ለኦኖታት ኡለ ኡድመ መርቴንታሁ? ቦብሩ ሌንቄቅሰኖ ሾምቦቁተ ለኦኖታትንዶ? ");
INSERT INTO alw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ህከረንገ መ ለኦኖተ ፉልቴን? ጡመ ኦድኑተ ኦደዕዮ መንቹ ለኦኖታትንዶ? ህትጎተበአ፤ ጡመ ኦድኑተ ኦደኦእሩ መኬሃንሰ ሄኣኢሁ ዎመ ምናኒት። ");
INSERT INTO alw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ህከረንገ መ ለኦኖተ መርቴን? ነብዬቹ ለኦኖታትንዶ? ህትጎተበአ! አን ኩላንክዕኔ፤ ነብዬቺች በተአኖሃ ለኢሃት። ");
INSERT INTO alw_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","‹ከለእ! ሄጭ ብርክ ሃመን ወቃክ ቅጥአአኖ ሶቀማንቹኤ ሶሃም› የመም እስተኔሃ ከተበሞሁ ከኒት። ");
INSERT INTO alw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","አን ኩላንክዕኔ፤ ሜንቲች እለንቶሀኑኡ በላን ያህዪች በተአኖሁ አዪሁ ዮበአ፤ ጠዉ እኮጎሬ መገን ዎምነቴን ጉዕሚችን ሆፈአኖሁ ጉዕሚችን በተአኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ጉዕሙንኩ መኑለከ ቀረጠ ሙርታእሩ ህካን ሞጮጭቶ ወክት ያህዪን ጠመቀንቶእረ እኮቤቺሃ መገን ሆጉት ሀንቅ እሁስ ደጎኡ። ");
INSERT INTO alw_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ጠዉ እኮጎሬ ፈርሳዊያኑትለከ ሕግ አስተማረት ያህዪን ጠመቀሙ ሆጎቤቺሃ መገን ሰውት ግቦኡ። ");
INSERT INTO alw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ኢስ «ከን ዘማን መነ ሚን አጉጣቀንሳንሰ? እሰንገ መ አጉዳአ? ");
INSERT INTO alw_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ኩ መኑ ጌባን አፉዕልት መት-መቱሰ ገእተን ‹ሁሉሌተ ቡንሶንክዕኔ፤ አዕኑንገ አለጵቴንታበአ፤ ህትን ኦእሲንሳም ወክት ኦኡ ግቤንታአ› ይተን መት-መቲንከሰ ገአቀንታ ኦሱተ አጉዳአ። ");
INSERT INTO alw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ጠመቃንቹ ያህይ እቸተ እቱዕነለከ ወይነ ቦበጤማሃ አጉዕነ አሜቾረ ‹ዶሮረኖ ዱሩ ዮስ› ይቴንታአ። ");
INSERT INTO alw_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","መንች ቤቱ እተንለከ አገን አሜቾ እቃን ‹ቆኤቻማተ፥ ሰከርታሀኑኡሃ፥ ቀረጠ ሙርታሀኑኡተለከ ጩበኛኖተ ጃለ› ይቴነንተ። ");
INSERT INTO alw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ጠዉ እኮጎሬ መገን ሀይመት ሀንቅ እሁስ ደገመኖሁ እስ ሀይመተ አዎንታሀኑኡሃት» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ፈርሳውያኖች መቱ መንቹ ኢስ ምኔስ እቶተ ገኤሃን ህከን ፈርሳውች ምኒ ኣግ ዛበዕይ ማዳን አፉዕሌእ። ");
INSERT INTO alw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ህከን ከተማን መትት ጩበኘት ጫት ኢስ ፈርሳውች ምኔን ማዳን ዛበዕይ አፉዕሌኢሃ ደጎ ወክት ሽቱት ዊንቶ «አልባስጥሮሰ» ዬኖ ክኒች መክሴመ ብልቃጠ አፍ አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","እሴን ኤተርስ አዲን ሎከስ መዴን ኡርት ኦአን እንጂጃሴ ሎከስ አሌን ዱንተንለከ ሙሚንከሴ ሎከስ ሺንሽተንለከ ሱንቅተን ሎከስ አሌን ሽቱተ ቡርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ህከ ወክት ኢሰ ገኤ ፈርሳውቹ ህካን ለዕዮ ወክት «ኩ መንቹ ነብዬቹ እኮ እቃን ካን አታስ ጫት ጩበኘተ እኮቤቺሃ ሃትናሜተ ጫ ጎሬ ደገኖ እቅ» ይ ቀልቤንከስ ሰውዬእ። ");
INSERT INTO alw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ኢስን «ስሞኔ! ጠወኣንኬ ጠዉ ዮኡ» ዬስ፤ እስን «አስተማርቾ! መርቾሃን?» ይ ፈንቀሼስ። ");
INSERT INTO alw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ኢስን «መቶ መንቺች ብረ ሌቄጭቶ ለሙ መኑ ሄኦ እቅ፤ ህከኑኡችን መቱስ ኦንቴ ጥቤ ዲናረ ዎሉንገ ኦንታሁ ዲናረ ሌቄጭቶ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","እሰን ሌቄጭቶኢሃ ባቱ ሆጎ ወክት ሌቄሾ መንቹ ለምሰ ኤዳሃ ጌኝ አዕይ አጉሮ፤ ሌቄጭቶሀኑኡች ሀኩንስ በትሽ ኢተኖስ?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ስሞንን «አበ ሌቃሃ አጉሬመሲሃ አጉደኖኤ» ይ ፈንቀሼእ፤ ኢስን «ሀንቅንከ ፈረዶንት» ይ ስሞኔሃ ጠወዕዮስ። ");
INSERT INTO alw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ህከኒች ኤተሮን ኢስ ህተን ጫ አደ ፈንቀል ስሞኔ «ተ ጫተ ለኣንቲትንዶ? አን ምንክ ኣጎም ወክት አት ሎካተኤ ዋሃ ኣቶንቴኤበአ፤ ጠዉ እኮጎሬ እሴ እንጂጃንከሴ ሎከኤ ቁፍስ ሙሚንከሴ ሺንሽቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ህትን አት ሱንቅቶንቴኤበአ፤ ጠዉ እኮጎሬ እሴ ምንክ ኣጎምሀኒች ኬሽ ሎከኤ ሱንቁ አጉርቶበአ። ");
INSERT INTO alw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","አት ቡዕላንከኤ ሆሮ ዘህተሃ ቡርቶንቴኤበአ፤ ጠዉ እኮጎሬ እሴ ሎካንከኤ ሽቱተ ቡርቶኤ። ");
INSERT INTO alw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ህካን እኮቤቺሃ አን ያንኬ፤ በትስ ኢትቶቤቺሃ ልግቡ ጩቡሴ አጉረሞሴ፤ ጠዉ እኮጎሬ ቀው አጉረመኖሲሁ ቀው ኢተኖ» ዬስ፤ ");
INSERT INTO alw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ኢስ ህተ ጫተ «ጩቡክ አጉረሞሄ» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","እሲን ሜጡበ ማዳን ሄኦእሩ «ኩ ጩብ ፈቁን ዮተ አታለኖሁ አዬት?» ዩ ጀመርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ጠዉ እኮጎሬ ኢስ ህተ ጫተ «አመዕነቱክ ፈይሾሄ፤ ወገሬቲን ኦሮእ» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ህከኒች ኤተሮን ኢስ መገን ዎምነት ተሽት ዱዱብሰን ከተማንለከ ኦሎን ጠወአን ህገኖ እቅ፤ ቶና ለሙንኩ አዎንተን ሄኦእሩ እሲን ሜጡበ ሄኦ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ህትን ዶሮረኖ አያኑ ገፈሮሰሩለከ አደደ ጥዘናች ፈይቶ መት-መቱ ሜንቱ አዎንታሲት እቅ፤ እሰን ለመለ ሩሃንየንከ ፉሼመ «መግደል» መርየማት፥ ");
INSERT INTO alw_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ሄሮድሴ ምኔን አዘዘን ሄዕዮ «ኩዘ» ዬኖ መንች ጫት ዮሃናቲ፥ «ሶስነ» ዬኖተንለከ ዎሉ ልግቡ ሜንቱ ሄኦ እቅ፤ እሰን ዱንያንከሰ ኢሰለከ አዎንታስረ ካደንታ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ልግቡ መኑ ከተሚች ጉዕሚችን አሜች ጭምዬ ወክት ኢስ ");
INSERT INTO alw_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«መቱ ዉጣንቹ ዜሬተ ዉጦተ ፉሎ፤ ዉጠንን መት-መቱ ዎቄ ገበላን ኡብ ሎካን ከደሞ፤ ህትን ሰሜ ጪኡት እቶስ። ");
INSERT INTO alw_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ዎሉንገ ክን አሌን ኡብ ሙቾ፤ እኮጎሬ ቤቹስ ሙጥመት ዮስበእቤቺሃ ሞሎ። ");
INSERT INTO alw_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ህትን መት-መቱስ ኡት ኣዜን ኡቦ፤ ኡቱንኩ እሲን ሜጡበ ነጵ ለንግ አፎስ። ");
INSERT INTO alw_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ህትን መት-መቱ ጡመ ኡላን ኡብ ሙቾ፤ ነጴ ወክት ጥብተ ጥቤን አቶቾ» ይ ማቆን ኩሎሰ፤ ህካን ጠወዕይ ኬዕይ ላገስ ጎት አዕይ «ሞጮጭታ መጨት ዮሲሁ አዪሁ ሞጮጩን!» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","አሳበስ ኢሰ «ከን ምሳሌ ፍሳረስ መርቹሃን?» ይት ጠዕምቶ ወክት ");
INSERT INTO alw_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","«ክዕኔሃ መገን ዎምነት ምስጥር ደጉ ኣሳሞህዕኔ፤ እኮጎሬ ዎሉ መኑ ለአን ቀልብ አትበገለከ ሞጮጭተን አጥራመትበገ ኩለመኖሳሁ ምሳሌኒት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ኢስ «ምሳሌስ ፍሳረት ከኒት፤ ዜሬቱ መገንተ ላገ። ");
INSERT INTO alw_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ህትን ወቄ ገበላን ኡቦ ዜሬቱ ለሊሰኖሁ መገን ላገተ ወክቲሀስ ሞጮጨኖ መነሃት፤ ጠዉ እኮጎሬ አመዕንት ፈቅበገ እልቢሱ አሜች ሞጮጭቶ ላገተ ቀልብችሰ መሰኖ። ");
INSERT INTO alw_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ክን አሌን ኡቦ ዜሬቱ ለሊሰኖሁ መገን ላገተ ሞጮጭታ ወክት ተሽቲን ቶጋእራን፤ እኮጎሬ እሰ አመዕንቶኢሁ ወክቲሃስት፤ ጠጱ ዮሰበእቤቺሃ ኦሪሸ ወክት ለገኣአ። ");
INSERT INTO alw_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ህትን ኡት ኣዜን ኡቦ ዜሬቱ ለሊሰኖሁ መገን ላገተ ሞጮጨኖ መነሃት፤ እኮጎሬ ከ ኣዱንያ ጠወ ሰውዩ፥ ቀባጡትለከ ናጠቀሙ ለንግሃንሰ አቶቱዕናን ቆሸ እካአ። ");
INSERT INTO alw_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ህትን ጡመ ኡላን ኡቦ ዜሬቱ ለሊሰኖሁ ጡመ መክዮ ቀልቢን መገን ላገተ ሞጮጭት ጠረኝት አገርታእረ፤ እሰን አታዕሊን አቶተ አቶታአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ኢስ «አዪሁ ኩራዘ ቀሾች ኤተሮን ኦዳን እፍሽ አፉሸኖሁ ህከረንገ መቃጢች ዎሮን አፉሸኖሁ ዮበአ፤ ጠዉ እኮጎሬ ምኒ ኣገኖሀኒሃ ጉዕሚንከ ለሎተ ጎትዬ ቤቾን አፉሼኖ። ");
INSERT INTO alw_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","«መሰንትስ ቴዕሌርቹ ደገሙዕነ ማጠሞርቹንኩ ለሉዕናን ፈቀኖበአ። ");
INSERT INTO alw_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","«ህካን እኮቤቺሃ ሀት እኬን ሞጮጭቴነንተ ጎሬ አገዕርዬ፤ መሰንትስ ዮስሀኒሃ በርገም ኣሰመኖስ፤ እኮጎሬ ዮስበእሀኒች ሁኩ ዮኤ ይ ሰውየኖንኩ ኣአመኖስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ህከኒች ኤተሮን ኢስ አመትለከ አመስኦሱት እስቤቹ አሜቶኡ፤ እኮጎሬ መኑ በተዕዮቤቺሃ እሲን ደቀንቶተ አታልቶበአ። ");
INSERT INTO alw_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ህካን እኮቤቺሃ «አመክለከ አመክ ኦሱት ደቀንቶሄተ ሀስ ኡሮን ኡርቶኡ» ዬን ኩሌመስ። ");
INSERT INTO alw_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ጠው እኮጎሬ እስ «መገን ላገተ ሞጮጭት አዘዘንታእሩ ጉዕሙንኩ አመተኤለከ አመኤተ ኦሱ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","መቱ በር ኢስ አሳባንከስን ሜጡበ ጀልባን ኣግ «ከን ባርች ዉድ አደ ቶልኖ» ዬሰ ወክት እሰን መርቶተ ኬኦኡ። ");
INSERT INTO alw_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","መርተን ሄኦገን ኢስ ግሾ፤ ዊ ሁሉንኩ ህከን ባር አሌን ኬዕይ ዉሁ ህከን ጀልባን ኣግ ዊሞተ እኮቤቺሃ ጨነቀንታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","እሰን እስቤቹ መርት ግሰኛች ኬስ «ቀርቾ! ቀርቾ! ጎንፎታት» ይቶኡ፤ እስን ኬዕይ ቦብረለከ ዊ ሁለ ሻቆ ወክት ኡሬእ፤ አበንከ ጨለ ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ኢስን «አመዕነቱክዕኔ ህንዴ?» ዬሰ፤ እሰን አበ አጀብሲጭትለከ ዋጅት መት-መቱሰ «ኩ ቦብረለከ ዋሃ አዘዘኖሁ ህትን እሰን አዘዘንታሲሁ ሀትናሙሃ መንቹ?» የቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ህከኒች ኤተሮን ገሊለ ዉድ አዲን ሄዕዮ «ጌርጌሴኖነ» ዬኖ ባዱ ኢልቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ኢስ ጀልቢች ኡለተ ድሬገን ሩሃንዩ አፎስ መንቹ ከተሚች ፉል ህከኔ ደቀሞስ፤ እስን ልግብያ ወክቲች ኬሽ ኦድኑተ ኦደኡ አጉሮ እቅ፤ ህትን እስ ሄአኖሁ ምኔን እሁዕነ ሎድ ኣዜኒት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","እስን ኢሰ ለዕዮ ወክት ብሬንከስ ያር ኡብ ሎረ ላጋን «ጉዕሚችን ሎረ መገን ቤቶ ኢሰ! ኤሳለከ ኬሳሃ ም ደቀንሹ ዮኔ? ሀዕይ ኤገተክ ኦሪሶቴኤ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ህካን ዬኢሁ ሁኩ ዶሮረኖ ዱሩ ህከን መንቺች ፉሎተ ኢስ ሻቆስቤቺሃት፤ መሰንትስ ከኒች ብርተ ልግብ ወክት አፎስቤቺሃ ሰንሰለቲንለከ ሎከ ብረቲን ኡሱሬን አገሬኖስ እቅ፤ ጠዉ እኮጎሬ ሰንሰለተ ተንቅሽ ሎከ ብረቲንከ ቢጭ ዶሮረኖ ዱሩ አዎንሰንስ ኡለ ኡድመ መሰኖስ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ኢስን «ሱዕሙክ አዬት?» ይ ጠዕሜስ፤ እስን ልግቡ ሩሃንዩ አሌስ ጭምዬቤቺሃ ሱዕሙኤ «ጎጎተሃን» ይ ፈንቀሼስ። ");
INSERT INTO alw_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ሁኩ ዶሮረኖ ዱሩ «ሀዕይ ጥዕላሸ በዋን ኣንጋምገ አቶትኔ» ይት ኡጭቶስ። ");
INSERT INTO alw_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ህከን ቤቾን ቆተ መዴን ልግቡ ቦኬ መሰረት ዘግ ይቶ እቅ፤ ሁኩ ዶሮረኖ ዱሩንኩ «ህከን ቦኬ መሰራን ኣንጋምገ አእኔ» ይት ኢሰ ኡጭቶስ፤ እስን ኣጎተ ፈቀጆሰ። ");
INSERT INTO alw_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ህከኒች ኤተሮን ሩሃንዩንኩ ህከ መንቹ ገፈር ቦኬን ኣጎ ወክት ቦኬ መሰረንት ሂለ ብከ ደጉደን ገርደብ አሊች ጨነቀንተን ድርት ባራን ኣአንቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ቦኬ ዘማኑት እኮ ጠወ ለኦ ወክት ሁንት መርቶች ኤተሮን ከተማንለከ ገጠራን ጠወስ ዱዱብስቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","መኑንኩ እኮ ጠወ ለኦተ ምኒች ኢስቤቹ አሜቶኡ፤ ሩሃንዩ ፉሎስ መንቹ ቀልቡስ ፈንቀላን ኦድኑተ ኦደዕይ ኢስ ሎከስ ብሬን አፉዕሌኢሃ ለኦ ወክት ዋጅቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ወክትስ ሄኦ መኑ ሩሃንዩ አፎስ መንቹ ሀት እክ ፈዬ ጎሬ ዱዱብስቶሰ። ");
INSERT INTO alw_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ህከኒች ኤተሮን «ጌርጌሴኖነ» ዬኖ ቀኤን ሄዕዮ መኑ ጉዕሙንኩ አበ ዋጅቶቤቺሃ ኢስ እሰ ባዲች ኦሮኦተ ኡጭቶስ፤ ህካን እኮቤቺሃ ኢስ ጀልባን ኣግ ወዕና አሜቾ ባዱ ፈንቀል ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ሩሃንዩ ፉሎስ መንቹ ኢሰ አዎናንኬ ይ ኡጬስ፤ እኮጎሬ ኢስ ህርሲሽስ ");
INSERT INTO alw_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«ምንክ ፈንቀልት መርት መገኑ አዕዮሄ ጠወ ጉዕመንከ ጠወእ» ዬስ፤ ሁኩ መንቹንኩ ኢስ አዕዮስ ጠወ ከተማን ጉዕማንን ጠወአን ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ኢስ ፈንቀል አሜቾ ወክት ልግቡ መኑ አገርቶስቤቺሃ ሙንዲኖን ቶጎስ። ");
INSERT INTO alw_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ህከቤቹንከ ጭምት ምኒ ገሻንቹ «ኢያሮሴ» ዬኖ መቱ መንቹ አሜች ኢስ ሎከ አሌን ኡብ «ምኒኤ አም» ይ ኡጬስ። ");
INSERT INTO alw_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ህካን ዬኢሁ ቶና ለሙ ዘማን እኮሴ መት ቤቱስ ጥዝ ሬቶተ ሆንጠኮቤቺሃት እቅ። ኢስን እሳን ሜጡበ መረን ሄዕዮገን አዎንተን ሄኦ መኑ ከን አዲንለከ ካጵ አዲን ረብ አፎስ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ቶና ለሙ ዘማን ጉዕመንከ ቄጉ ዱንተአን ኦርጨቀንተን ሄኣ መት መንቹት ሄኦ እቅ፤ እሴን ዱንያሴ ጉዕመንከ ሀኪማን ሹልት አዪሁ ፈይሶሴተ አታሎበአ። ");
INSERT INTO alw_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","እሴን ኢስቤቹ ኤተርስ አዲን ሆንጠክ ኦድኖስ ሰኑተ ኡልቶኡ፤ ህከ ወክትንከ ቄግሴ ቡቁት ኡርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ኢስን «አዬት ኡሎኤሁ?» ይ ጠዕሜሰ። ጉዕሙንኩ መኑ «ኡልኖኬበኣ» ዬ ወክት ጴጥሮስለከ እሲን ሜጡበ ሄኦእሩ «አስተማርቾ! ኬንኩ መኑ ጉዕሙንኩ ሀንበዕለመን አዎነንኬ ለአን ‹አዬት ኡሎኤሁ› ይተንንዶ?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ጠዉ እኮጎሬ ኢስን «ወልቀት ኢች ፉልቶገ ደጎምቤቺሃ መቱ መንቹ ኡሎኤ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ህት መንቹንት ማጠሙ ሆጉሴ ደጎ ወክት ሁጠን ኢስቤቹ አሜት ሎከስ አሌን ኡብ ጉዕማንከ መን መዴን ሚሃ ኡልቶስጎሬለከ ህከ ወክት ሀት እክ ፈይቶጎሬ ኩልቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ኢስን «ኢ ቤቶ፤ አመዕነቱክ ፈይሾሄ ወገሬቲን ኦሮእ» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ኢስ ህካን ጠወአን ሄዕዮገን መቱ መንቹ ጭምት ምኒ ገሻንች ምኒች አሜች «ጩልክ ሬቶኡ፤ ህካን እኮቤቺሃ አስተማርቹ ጠለዕላን ሆግሶትስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ጠዉ እኮጎሬ ኢስ ህካን ሞጮጭ «ዋጅቶት፤ አመዕን ቤሉ፤ ጩልክ ፈይታአ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ኢስ ኢያሮሴ ምኒ ኢሌ ወክት ጴጥሮሴች፥ ያህይች፥ ያቁቢች፥ ጩሌ አንለከ አመ ቤሉ ዎሉ መኑ ሜጡሁ እሲን ሜጡበ ምኒ ኣጎተ ፈቀጆበ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ህከኔ ሄዕዮ መኑ ጉዕሙንኩ ጩሌተኔሃ «ኣዬ! ኣዬ!» ይተን ኦኣእት እቅ፤ ጠዉ እኮጎሬ ኢስ «ኦኦኖቼ፤ ጩልት ግሶ ቤሉ ሬቶበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","እሰን ጩልት ሬሁሴ ደጎቤቺሃ ጉዕሙንኩ ቀለደን ኦሰዕልቶስ። ");
INSERT INTO alw_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ጠዉ እኮጎሬ ኢስ ጩሌ አንገተ አፍ «ቴ ጩሌ ኬእ!» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","እሴን ሩሁሴ ፈንቀሎቤቺሃ ወክትንከስ ሾት ይት ኬኦኡ፤ ኢስን «እታኢሃ ኣስዬሴ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ጩሌ አመትለከ አኑ አጀብሲጭቶኡ፤ ጠዉ እኮጎሬ እኮ ጠወ ሜጢሃ ጠወኦኖቼ ይ ኢስ አዘዦሰ። ");
INSERT INTO alw_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ኢስ ቶና ለሙንከ አሳበተ ሜጡበ ገእ ሩሃንየ ፉሽቶተ፥ ጥዘነተ ጉዕመንከ ፈይሳ ወልቀተለከ ሹምነቱ ኣሴሰ። ");
INSERT INTO alw_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ህት አዕይ መገን ዎምነቱ አሜቱስ መኒሃ ጉዕሚንከ ጠወኦተለከ ጥዘናመተ ፈይሶተ ሶኮሰ። ");
INSERT INTO alw_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ህትን ዎቄሀክዕኔ «በርተሃ እኮ እቃ ከረጥትታ እኮ እቃ ሽንቅታ እኮ እቃ ብረሃ እኮ እቃ ዶዕርቶኖተ ኦድኑታ እኮ እቃ አፎኖቼ። ");
INSERT INTO alw_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ህትን ኮሀ እኬን ኣጌንተ ምኒች ፉልቴን መርቶኖተ ኢለ ህከን ምኔን አገሬ። ");
INSERT INTO alw_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","‹ሀበይ ወገሬቲን አሜቴን› ይ መኑ ቶግበህዕኔጎሬ ህከ ከተመ አጉርቴን ፉልቴነንተ ወክት እሳንከ እማኘ እሆተ ሎከክዕኔ ትበ ግግሽቴን ኦሮዕዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ህካን እኮቤቺሃ አሳበት ህከን አዲች ፉልት ተሽት ላገተ ተማርስተንለከ ጉዕመ ቤቾንን ጥዘናመተ ፈይሰን ቀዕያን ጉዕማንን ህጋ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ገሊለ ባድ ገሻንቹ ሄሮድስ ኢስ አዕዮ ጠወ ሞጮጬ ወክት ዱዱቅ ዬስ፤ ህካን እኮሁ መት-መቱ መኑ «ጠመቃንቹ ያህይ ሬሆች ኬዕዮኡ» ");
INSERT INTO alw_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ህትን መት-መቱ መኑ «እልያስ ፈንቀል አሜቾኡ» ይተን ዎሉሰንገ «ሄጭት ሄኦ ነቢያኖች መቱ ኬዕዮኡ» ይታቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ሄሮድስን «ያህይ ቡዕለ ሙርሲሾም እቅ፤ ጠዉ እኮጎሬ እስተኔሃ ህትኔ ጠወ ሞጮጫሚሁ ኩን አዬት?» ዬእ፤ ለኦስተ ሀሰኖት እቄ። ");
INSERT INTO alw_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","አሳበስ ሶሄመ አዲች ፈንቀልት አሜት አቶ ጠወ ጉዕመንከ ኢሲሃ ኩልቶኡ፤ እስን «ቤተ ሳይዳ» ዬኖ ከተማን ገበጭ ዬቤቹ ሜጥሃስ ኣእ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ጠዉ እኮጎሬ ልግቡ መኑ ህካን ሞጮጬ ወክት አዎኞስ፤ እስን መነስ ቶግ መገን ዎምነትተኔሃ ተማርሴሰ፤ ጥዘናች ፈይቶተ አሜቶእረ ፈይሾሰ። ");
INSERT INTO alw_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ኡለት ሀዎርቶተ ሆንጠኮ ወክት ቶና ለሙንኩ አሳበስ ኢስቤቹ ሆንጠክ «ኩ ነኡ ዮም ቤቹ ኡድመ እኮቤቺሃ ከን ቀኤን ዮ ከተመለከ ገጠረ መርት ገልቶተለከ እታኢሃ ሀሶተ ከ መነ ህርሲስ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ጠዉ እኮጎሬ ኢስን «እታኢሃ አዕኑ ገዉንኩክዕኔ ኣስዬ» ዬ ወክት «ኔሳሃ ዮኔሁ ኦንቱሃ ጣብተለከ ጠለዕል ለሜተ ቁርጩሜ፤ መርን ከን ኡመቲሃ ጉዕሚንከ እካ እቸተ ህዕርን ኤምቦተ ሀሰንንዶ?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ጎኑስ ኦንቶ ኩሜ ጌሰ እሀኖ እቅ። ኢስን አሳበስ «ኦንታሁ ኦንታሁ መት-መቶ ቤቾን እክ አፉዕለኖገ አዕዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","እሰን እስ አዕዬ ዬገ አት መኑ አፉዕለኖገ አቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ህከኒች ኤተሮን ኢስ ኦንቱ ጣብተለከ ለም ቁርጩሜተ አፍ ሰማ ዋሽ ለዕይ ማሰዕይ ቢጭ መኒሃ አስናዶተ አሳባተስ ኣሴእ። ");
INSERT INTO alw_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ጉዕሙንኩ እት ዱቦኡ፤ መኑ እተን ፈቆ ፉርፉሩ ቶና ለሙ መሶበ ዊመ አሳበስ ኬሶኡ። ");
INSERT INTO alw_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","መቱ በር ኢስ ሜጥሀስ ዱአ አአን አሳበስ እሲን ሜጡበ ሄኦ እቅ፤ እስን «መኑ ኤሳሃ አዬት የኖኤሁ?» ይ ጠዕሜሰ። ");
INSERT INTO alw_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","እሰን ፈንቀሽት «መት መቱ መኑ ‹ጠመቃንቾ ያህዪት› ዎሉስንገ ‹እልያሴት› ህትን ዎሉሰ ‹ሄጭት ሄኦ ነቢያካች መቱስ ኬዕዮኡ› ይታኢት» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","እስን አዕኑንገ «ኤሳሃ አዬት ይቴነንታት?» ይ ጠዕሜሰ፤ ጴጥሮስን «አት መገኑ መጠሮሄ መሲህ ኢሳት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ኢስን ከ ጠወ አዬሃ ጠወኣበእገ ጠረኝሽ ኩሎሰ። ");
INSERT INTO alw_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ኢስን «መንች ቤቱ ልግብ ኦሪሸተ ቶጎተ ባልቃን፥ ቂስ አዎንሳኖንለከ ሕግ አስተማራን ግበሞተ፥ ሬሆተለከ ሰቅ በሬን ሬሆች ኬአኖ» ይ ጠረኝሽ አዘዦሰ። ");
INSERT INTO alw_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ኢስን ጉዕሚንከሰ «አዪሁ ኤሰ አዎኖተ ሀሰኖኤሁ ገዉስ ለገዕይ በሬን በሬን መስቀለስ እጅ አዎኑዕኔ። ");
INSERT INTO alw_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ነብሳስ ፌሶተ ሀሰኖሁ ጉዕሙንኩ ነብሳስ ቤሰኖ፤ ጠው እኮጎሬ ኢተኔሃ ነብሳስ ቤሰኖሁ ጉዕሙንኩ ነብሳስ ጡምሰኖ። ");
INSERT INTO alw_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","መቱ መንቹ ከን ኣዱንያ ቀባጡተ ጉዕመንከ ደእ ነብሳስ ቤሾ ጎሬ መ ደግለለኖስ? ");
INSERT INTO alw_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ህትን አዪሁ ኤሳንለከ ኢ ላጋን ሙሌ ጎሬ መንች ቤቱ ገይስ ኬዕምኚን፥ አንስ ኬዕምኚንለከ ጠሊላኖ መላይከ ኬዕምኚን አሜተኖ ወክት ህከኒን ሙለኖ። ");
INSERT INTO alw_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ጠው እኮጎሬ ሀንቅስ ኩላንክዕኔ፤ ከኔ ኡርቶሀኑኡች መት-መቱ መገን ዎምነቱ ለኡዕናን ሄጭት ሬትበሩ ዮኡ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ኢስ ህከ ጠወ ጠወዕዮ ህዜቱ በር እኮች ኤተሮን ጴጥሮሴ፥ ያህይለከ ያቁበ ሜጡበ አዕይ ዱአ አኦተ መቴ ቆተ አል ፉሎ። ");
INSERT INTO alw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ዱአ አአንን ሚኔስ ደኑ ዶረሞ፤ ህትን ኦድኑስ ዋጀእ በለቆኡ። ");
INSERT INTO alw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ህከ ወክት ለሙ መኑ አሜት እሲን ጠወኣኢት እቅ፤ እሰን ሙሳትለከ እልያሴት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ኬዕምኝን ለሊት ጠወአን ሄኦ ጠዉንኩ ኢስ ዬሩሳሌም ከተማን መገን ሃሽኣቱተ ሬሆንከስ ዊንሸኖ ወቄሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ጠው እኮጎሬ ጴጥሮሴለከ እሲን ሜጡበ ሄኦእራ ግሰኛት ቄልቶሰ እቅ፤ እሰን ግሰኛች ኬኦ ወክት ኢስ ኬዕምኝለከ እሲን ሜጡበ ኡርቶ ለም መናከተ ለኦኡ። ");
INSERT INTO alw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ለም መናከንት ኢሲች አደ እክ መርተንን ጴጥሮስ ኢሰ «አስተማርቾ! ከኔ እሁ ኔሳሃ ጡመ እኮቤቺሃ ሰሱ ዳሰ መቱ ኬሳሃ መቱ ሙሲሃ መቱንገ እልያሴሃ እጃርኖ» ዬስ፤ ጠው እኮጎሬ ጠወአኖርቹ መሃጎሬ ደጎበ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ጴጥሮስ ከ ጠወ ጠወአን ጎመት አሜት ቴልቶኡ፤ ጎመት ቴልቶሰ ወክት ዋጅቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ህትን ህከን ጎመ ኣዚች «መጠሮም ቤቱኤ ከኒት፤ እሱ ሞጮጭዬ!» ይታ ላገት አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ህት ላገት ጠወአንቶሀኒች ኤተሮን ኢስ ሜጥሀስ እክ ደገሞ፤ ህትን እሰ ለኦ ጠዊች መቱርቹሃ ህከን ወክቴን አዬሃ ጠወኡዕናን ጨለ ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ለንክስ በር እሰ ቆታች ድርቶ ወክት ልግቡ መኑ ኢስን ደቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ህከን መኒች መቱስ «አስተማርቾ! እስ ኤሳሃ ሜጥቹ ጩልኤ እኮቤቺሃ ፈይሶኤተ ኡጫንኬ። ");
INSERT INTO alw_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","እሱንከ ዶሮረኖ ዱሩ አፍ ድንገቴን ያርሲሰኖስ፤ ህትን ሁንብ ኩፍ አአንስ ከጣቀንሰኖስ፤ ጅስመስ ቁስ ፍትፍት አዕይ ጨነቅ ገፈረኖስ። ");
INSERT INTO alw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ህከ ዶሮረኖ ዱር ፉሽቶተ አዎንታሄረ ኡጭዮም እቅ፤ እኮጎሬ እሰ አታልቶበአ» ይ ያሮ። ");
INSERT INTO alw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ኢስን «ኩ ሂሉለከ አመዕነቱ ዮህዕኔበእ ከን ዘማን መኑ ሄንከ በር ኢለ ክዕኔን ሜጡበ ሄኣም? ህትን መ በር ኢለ አታላንክዕኔ? ህንዴ ቤቱክ ከበ ኤብ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ጩሉንኩስ አሜተንን ሁኩ ዶሮረኖ ዱሩ ኡጅ ከጣቀንሴስ፤ ጠው እኮጎሬ ኢስ ህከ ዶሮረኖ ዱር ሻቅ ጩልንከስ ፈይሽ አኒሀስ ኣሴእ። ");
INSERT INTO alw_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ህካን እኮቤቺሃ ኡመቱ ጉዕሙንኩ መገን ሎረ ወልቀተ ለኦቤቺሃ አጀብሲጭቶኡ፤ ጉዕሙንኩ ኢስ አዕዮ ጠዋን አጀብሲጨን ሄዕዮገን እስን አሳበስ ");
INSERT INTO alw_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«መንች ቤቱ መን አንጋን ህግሰም ኣሰመኖቤቺሃ ከ ላገተ ሰውይቴን ሞጮጭዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ጠው እኮጎሬ ጠውስ አግበሰገ ቴለሞሰቤቺሃ ህከ ጠወ ደጎበአ እቅ፤ ህትን ህከን ጠዊንከ ጠዕምቶስተ ዋጅቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","አሳበስ በላን «ኒች ጉዕሚችኔ በተአኖሁ አዬት?» ይታ ኦደት ኬኦኡ። ");
INSERT INTO alw_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ጠዉ እኮጎሬ ኢስ ቀልብሰ ጠወ ደግ መቱ ጩል ኤብ መዴንከሰ ኡርሽ ");
INSERT INTO alw_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","«ከ ጩል ሱዕሚንከኤ ቶገኖሁ ጉዕሙንኩ ኤሳሃ ቶገኖ፤ ህትን ኤሳሃ ቶገኖሁ ጉዕሙንኩ ኤሳ ሶኮኤሃ ቶገኖ፤ መሰንትስ በላንከክዕኔ ጉዕሚችን ሆፈአኖሁ እስ ጉዕሚችክዕኔን ሎረሃን» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ህከኒች ኤተሮን ያህይ «ቀርቾ! መቱ መንቹ ሱዕሚንከክ ሩሃንየ ፉሸን ለዕኖም፤ እኮጎሬ እስ ኒን ሜጡበ አዎንበሄሃ እኮቤቺሃ ከሞንስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ጠዉ እኮጎሬ ኢስን «ኦደምበህዕኔሁ ጉዕሙንኩ ክዕኔሃ እኮቤቺሃ ከንቶኖቼስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ኢስ ሰማ ኦሮአኖ ወክቱ ሆንጠካን ዬሩሳሌመ ኦሮኦተ ሙርሲጭ ኬዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","እሲች ሄጭት መርታ አሳበተ ሶካን እሰን ጉዕመርቹንከ ቅጥአቶተ «ሰማርያ» ዬኖ ባዶን ዮ መት ቀዕየተ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ጠው እኮጎሬ ህከን ቀዕየ መኑ ኢስ ህከኒን ህግ ዬሩሳሌመ መረኖገ ደጎቤቺሃ ቶጎስተ ሀሶበአ። ");
INSERT INTO alw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","አሳበስ ያቁብለከ ያህይ ህካን ለኦ ወክት «ቀርቾ! ሰሜች ጊረት ድርት ከ መነ ቡስቶተ አዘንዞተ ሀሰንንዶ?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","እስን ኤተሩ ፈንቀል ሻቆሰ። ");
INSERT INTO alw_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ህከኒች ኤተሮን ዎልተ ቀዕየተ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ኢስለከ አሳበስ ዎቃን ሀንተንን መቱ መንቹ ኢሰ «መርታንትቤቹ ጉዕመንከ አዎናንኬ» ዬስ ወክት ");
INSERT INTO alw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ኢስን «ወለንጌሃ ኤሎ ዮሰ፤ ህትን ሰሜ ጭኦተ ጎዕምት ዮሰ፤ ጠው እኮጎሬ መንች ቤቲሃ ገዉስ ኣግሽ ፎሎሲሰኖ ቤቹ ዮስበአ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ኢስ ዎሉ መንቹሃ «አዎኔኤ» ዬእ፤ ጠው እኮጎሬ መንቹስ «ቀርቾ! ሄጭ አነኤ ሞጎተ ፈቀዴኤ» ዬስ ወክት ");
INSERT INTO alw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ኢስ «ሬቶእሩ ሬሸሰ ሞጎተ አጉርሰ፤ ጠው እኮጎሬ አት መርት መገን ዎምነትተኔሃ ጠወእ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ህትን ዎሉ መንቹ «ቀርቾ! አን አዎናንኬ፤ ጠው እኮጎሬ ሄጭ መር አበሮስኤ ‹ወገሬቲን ሄዕዬ› ዮተ ፈቀዴኤ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ኢስን «አቡሮተ ከዶ ወኝተ አንጋንከስ አፍ ኤተሩ ለአኖ መኑ ጉዕሙንኩ መገን ዎምነቲሃ በቀእበሃን» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ህከኒች ኤተሮን ቀርቹ ኢስ ለመላይኔ ለሙ አሳበተ መጠር እስ መሮተ ሰውዬ ከተመለከ ጉዕመ ቤቹንከ ለም ለሙ አዕይ ሄጭት መርታገ ሶኮሰ። ");
INSERT INTO alw_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","እስን «አዝመሩስ ልግብሃን፤ እኮጎሬ ሆጉተ አታእሩ ቀዎሃን፤ ህካን እኮቤቺሃ ሆጎስ አኑ ሆጉተ አአኖ መነ ሶሆተ ኡጭዬ። ");
INSERT INTO alw_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ቴ መሬ! ሁኩዕኑን አን ሆለገ ኦሌ በላን ሶሃንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ወቄሀክዕኔ ቦርሰ ህከረንገ ከረጢትተ ህከረንገ ጫዕመተ አፎኖቼ፤ ህትን አዬኒ ዎቃን ጠውሲጨንቴነን ወክት ቤሶኖቼ። ");
INSERT INTO alw_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ሀከ ምኒሃ ኣጌንተ ወክት ሄጭቴን ‹ወገሬቱ ከን ምኒሃ እሁን› ይዬ። ");
INSERT INTO alw_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ህከንቤቾንን ወገሬት መንቹ ሄዕዮ ጎሬ ወገሬቱክዕኔ ህከን መንቾን እሀኖ፤ ዮበእ ጎሬ ወገሬቱክኔ ክዕኔቤቹ ፈንቀለኖ። ");
INSERT INTO alw_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ሆጉተ አአኖ መንቺሃ ደሞዙ ሀስሰኖስ፤ ከን ሀሌንን አዕኑሁ ኣጌንተ ምኔን ሆንጠህሴመህዕኔሃ እቴነንለከ አጌነን ህከን ምኔን አገሬ ቤሉ መቶ ምኒች መቱ ምኒ ፈንቀላንቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ህትን ኣጌንተ ከተማን ጉዕማንን ቶጌመህዕኔች ሆንጠህሴመህዕኔሃ እቼ። ");
INSERT INTO alw_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ህከን ከተማን ዮ ጥዘናመተ ፈይሼ፤ ህትን ‹መገን ዎምነቱ ክዕኔቤቹ ሆንጠኮኡ› ይዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ጠዉ እኮጎሬ ሀከ ከተመሃ ኣጌንተ ወክት መኑ ቶግበህዕኔጎሬ ከተም በነቻን ፉልቴን ");
INSERT INTO alw_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹ሁኩዕኑን ጡር እሆህኔተ ሎከኔ አሌን ዮ ከተምክዕኔ ትበ ግግሽናንክዕኔ፤ እኮጎሬ መገን ዎምነቱ ክዕኔቤቹ ሆንጠሁስ ደጌ› ይዬ። ");
INSERT INTO alw_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","አን ኩላንክዕኔ፤ ፍርድ በር ህከን ከተሚች በትሽ ሰዶም ከተሚሃ እኮ ጠዉ ቢለኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ኢስ «ቆሀኖሄ አት ኩራዝ ከተንቾ! ቆሀኖሄ አት ቤተ ሰይደ! ክዕኔቤቾን አሰሞ አጀብሲሰኖርቹ ጢሮስለከ ስዶን ከተማን አሰሞ እቃን እሰን ጥጅ ኦድኑተ ኦደእ ጠበሮን አፉዕልት አበ ወክቲች ብርተ ጩብሰ አጉርኔ ይታ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ጠዉ እኮጎሬ ፍርድ በር ክዕኔች በትሽ ጢሮስለከ ስዶን ከተሚሃ ቅጣቱስ ቢለኖሰ። ");
INSERT INTO alw_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ህትን ቴ ቅፍርናሆም ከተንቾ! ሰማሃ ኢለ ጎት ጎት ይቶተ ሀስንዶ? አዛቤን ድርታንት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ህትን አሳበስ «ክዕኔተ ሞጮጨኖሁ ኤሳንከ ሞጮጨኖሃን፤ ህትን ክዕኔተ ቶግባሁ ኤሳንከ ቶግባሃን፤ ህትን ኤሳሃ ቶግባሁ ኤሰ ሶኮኤንከ ቶግባሃን» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ለመላይኔ ለሙንኩ አሳበት ሶሀንቶ አዲች አበ ሙንዲኖን ፈንቀልት «ቀርቾ! ኪ ሱዕሚን ሩሃንዩ አዘዘሞኔ!» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ኢስን «ሻይጣንቹ ጉገኛገ እክ ሰሜች ኡባን ለዕዮንስ። ");
INSERT INTO alw_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ሁኩዕኑን አን ዎሪቹለከ ‹ግንጠ› ዬኖ መርዙ ዮስ ዎርቹ ከዶኖተለከ ዲን ዎልቀተ ጉዕመንከ አታልቴነንተ ሹምነቱ ኣስዮንክዕኔ፤ ሚረኖህዕኔሁ መቱርቹሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ሩሃንዩ አዘዘሞህዕኔ ቤቺሃ ተሽ ዩንከህዕኔ፤ ጠዉ እኮጎሬ ሱዕሙክዕኔ ሰማን ከተበሞቤቺሃ ሙንደዕዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ህከ ወክት ጠሊሉ አያኑ ኢሰ ተሽቲን ዊንሽስ «ሰሜለከ ኡለ ቀርቹ እኮንት ኢ አነ! ከ ጠወ ሀይቻኖችለከ ደጋሀኑኡች ማጥ ኦሶተ ደግስሶንትቤቺሃ ገለትጫንኬ፤ ኤ ኢ አነ! መሰንትስ ኪ ጡሙ ሰውቱ ህትናሙሃን። ");
INSERT INTO alw_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«ጉዕሙርቹንኩ አኒችኤ ኣሰሞኤ፤ ቤቱ አዬት ጎሬ አን ቤሉ አዪሁ ደገኖበአ፤ ህትን አኑ አዬት ጎሬ ቤቲችለከ ቤቱ ለሊሶስተ መጠሮ መንች ቤሉ አዪሁ ደገኖበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ህከኒች ኤተሮን አሳበ አደ ፈንቀል ኬዕይ ጠለዕል እሳሃ «አዕኑ ለኤነንታሃ ለኣእሩ ማሰአንቶእራን። ");
INSERT INTO alw_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","አን ኩላንክዕኔ፤ መሰንትስ ልግቡ ነብያከትለከ ዎመት አዕኑ ለኤንታሃ ለኦተ ሄዕላቶ እቅ፤ እኮጎሬ ለኦበአ፤ ህትን አዕኑ ሞጮጭቴንታሃ ሞጮጭቶተ ሄዕላቶ እቅ፤ እኮጎሬ ሞጮጭቶበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","መገን ሕገ ደገኖ መቱ መንቹ አሌ ዋል ኡርኬዕይ ኢሰ ፌተኖስተ «አስተማርቾ! ዘላለም ሄኡ ደኦተ መ አኡ?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ኢስን «ሕጋን ከተበሞሁ መርቾሃን? ህትን ህካን ሀት አነበባንቲት?» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ሁኩ መንቹንኩ « ‹ቀርቹ መገኑክ ዊመ ቀልቢንከክ፥ ዊመ ፎልኒከክ፥ ዊመ ወልቃንተክለከ ዊመ ሰውቲንከክ ኢት፤ ህትን ዎሉ መነ ገይክገ ኢት› የኖ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ኢስን «ሀንቅንከ ይቶንት፤ ካን አእ፤ ዘላለም ሄኡ ደእታንት» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ሁኩ መገን ሕገ ደገኖ መንቹንኩ ገዉስ ፈየ አኦተ ሀሽ ኬዕይ ኢሰ «ኦሌቹኤ አዬት?» ይ ጠዕሜስ። ");
INSERT INTO alw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ኢስን ፈንቀሽ «መቱ መንቹ ዬሩሰሌም ከተሚች ኢያርኮ ከተመ ህገኖት እቅ፤ ህከ መንቹንከ ሽፍጡ አፍ ኦድኑስ ቃርት ኦልቶች ኤተሮን ሬሆተ ሆንጠካን ሂለ ፎልስ አጉርት መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ህትን ህከን ዎቄን መቱ ቂስቹ ህገኖት እቅ፤ እስን ህከ መንቹ ገምባትንከ ለዕዮ ወክት አጉር መዲንከስ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ህትን መቱ ሌውቹ ህከን ቤቺን ህገን ህከ መንቹ ለዕይ ዎሎ አዲን አጉር ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ጠዉ እኮጎሬ መቱ ሰማር ባድ መንቹ ህከን አዲን ኦሮአን ሁኩ መንቹ ዮ ቤቺን አሜቾ፤ እስን ለዕዮስ ወክትንከ አሙዦስ፤ ");
INSERT INTO alw_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","እስበ ሆንጠክ ዘይተለከ ወይነ ቦበጤማሃ ጡላንከስ ዎር ጡላስ ኡሱሮ፤ ህት አዕይ ገይስ ገማሞን ቆጵሲሽ ኮሁ ገለኖቤቹ መስ ጥስሾስ። ");
INSERT INTO alw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","እስን ለንክ በር ገስማን ኦሮአን ኮሁ ገለኖ ምኒ አኒሃ ለሙ ዲናር ፉሽ ኣስ ‹ከ መንቹ ጡመገ አት ጥሲስስ፤ ከኒች በተአኖ ዲናረ ፉሽቶንት ጎሬ ፈንቀል አሜታም ወክት ባታንኬ› ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ቴሱ ህከን ሰሶንከ መንቺች ሽፍጡ ኦልታንስ ኡቦ መንቺሃ ጃላ እሁስ ለሊሾሁ ሀከን እሶት?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","መገን ሕገ ደገኖ መንቹንኩ «አሙዥ ሀዕሌስሃን» ዬእ፤ ኢስን «አቲሁ መርት ህትን አእ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ኢስ አሳባንተስን ዎቃሃ ሃመን መት ቀዕተ ኣጎ፤ ህከኔን «ማርተ» ዬኖ መት መንቹት ምኔንከሴ ቶጎስ። ");
INSERT INTO alw_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","እሴንከ «መርየመ» ዬኖ አመቤቱት ሄኦሴ እቅ፤ እሴን ኢስ ሎካች ዎሮ አዲን አፉዕልት ተማርሰኖሃ ሞጮጭታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ጠዉ እኮጎሬ ማርተ ሆጉት በተኣንሴ መቴምማተሴ ኢስቤቹ መርት «ቀርቾ! አመኤ ቤቱት ሆጉተ አአን ኦርጨቀሞተ ኤሳሃ ሜጥሃኤ አጉርቶኤጉ ሻዝሰኖሄበእንዶ? ቴሱ ሀዕልቶኤተ ኩልሴ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ጠዉ እኮጎሬ ኢስ ፈንቀሽ «ማርታ! ማርታ! አት አበ ጠዊን ጨነቀንታንቲትለከ ኦርጨንታንቲት። ");
INSERT INTO alw_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","እኮጎሬ ሀስሰኖሁ ጠለዕል መቶ ጠወ፤ ህከን እኮቤቺሃ እሴሃ አዪሁ ኣኦተ አታለኖበ፤ ቆሀኖሲሃ መጠርቶኡ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","መቱ በር ኢስ መቶ ቤቾን ዱአ አአኖት እቅ፤ ዱአ አዕይ ኬዕዮ ወክት አሳባችስ መቱ «ቀርቾ! ያህይ አዎናኑስ ዱአ አታገ ተማርሴገን አቲሁ ዱአ አዕናምገ ተማርስኔ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ኢስን ዱአ አቴነንተ ወክት «ሰማን ዮንቲሁ ኒ አኑ! ጠሊሉ ሱዕሙክ ማሰአሞሃ እሁን፤ ዎምነቱክ አሜቱን! ");
INSERT INTO alw_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","በሪሃ ሀስሳ እቸተ በሬን በሬን ኣስኔ! ");
INSERT INTO alw_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ነኡ በደልቶኔረ ፈቁን ይን አጉርናምሀንገን፥ ብድልኔ ፈቁን ይኔ፤ ፌተናን ኣግሶትኔ ይዬ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","እስን አሳበስ «ክዕኔች አዪሁ ጃሉ ዮሲሁ ሀዎሮ በላን ጃልስቤቹ መር ‹ኢ ጃላ! ሰሱ ጣብተ ሌቄሴኤ፤ መቱ ጃሉኤ ቄዕራሸ ባዲች ኢ ምኒ አሜቾኡ፤ እሲንከ ሆንጠህሳም መቱርቹሁ ዮኤበአ› ዬስ ጎር ");
INSERT INTO alw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","«ምኒ ኣዚን ዮኢሁ ‹ኦርሶቴኤ! ኡሩት ጡፈንቶኡ፤ እለኤ ኢን ሜጡበ መዕናን ኦሰኦኡ፤ ህከን እኮቤቺሃ ኬዕይ መቱርቹሃ ኣሶሄተ አታላምበአ› የኖንዶ? ");
INSERT INTO alw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","አን ያንክዕኔ፤ ጃለስ እኮቤቺሃ ኬዕይ ኣሲሃ ሀስበ ጎሬ ዎርዋቾስቤቺሃ ኬዕይ ሀሰኖርቹ ጉዕመንከ ኣሰኖስ። ");
INSERT INTO alw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«አኒሁ ያንክዕኔ፤ ኡጭዬ ኣሰመኖህዕኔ፤ ሀሼ ደእቴነንተ፤ ኡሩተ ቆጭዬ ፈንተአኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","መሰንትስ ኡጨኖሁ ጉዕሙንኩ ኣአኖ፤ ሀሰኖንኩ ደአኖ፤ ህትን ኡሩተ ቆጨኖሀኒሃ ፈንተአኖስ። ");
INSERT INTO alw_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","«ክዕኔች ቤቱክዕኔ ‹ቁርጩሜተ ኣሴኤ› ይ ኡጬጎሬ ዎሪቹ ኣስቴነንዶ? ");
INSERT INTO alw_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ህከረንገ ቡጳ ኣሴኤ ይ ኡጬጎሬ ‹ግንጠ› ዬኖ መርዙ ዮስ ዎሪቹ ኣቴነንስንዶ? ");
INSERT INTO alw_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","አዕኑ ሂላኑተ እኬነን እላተክዕኔ ጡመርቹ አኡ ደጌንታች ሰማን ሄአኖ አኑክዕኔ ኡጭታሀኑኡተ ጠሊለ አያነ ሀት በትሽ ኣሰኖሰበአ!» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","መቱ በር ኢስ መቶ መንቺች ዶሮረኖ ዱር ፉሸኖት እቅ፤ ዶሮረኖ ዱሩንኩ ፉሎ ወክት ዱዱንኩ ጠወዕዮ፤ መኑንኩ ህከን ጠዋን አበ አጀብሲጬእ። ");
INSERT INTO alw_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ጠዉ እኮጎሬ ህከን መኒች መት-መቱሰ «እስ ሩሃንየ ፉሸኖሁ ሩሃንይ ብዔልዜቡል ወልቃኒት» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ህትን ዎሉ መኑ ፌተንቶስተ ሀስ ሰሜች መላተ ለሊሶሰተ ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ጠዉ እኮጎሬ ኢስ ቀልብሰ ጠወ ደግ «መቶ ዎም ኣዜን ሄዕዮ መኑ ገገዉንኩስን አደደ እኮጎሬ ሁኩ ዎሙ ድጀመኖ፤ ህትን መቶ ምኔን ሄአኖ መኑ አደደ እክ ገገዉንኩስ ብተሞ ጎሬ ብን የኖ። ");
INSERT INTO alw_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ህትን አዕኑ ኤሳሃ ‹እስ ፉሸኖሁ ብዔልዜቡሌ ወልቃኔት› ይቴነንተኤቤቺሃ ሻይጣን ዎሙ ገገዉንኩስ ብተም ብን የኖሃ እኮጎሬ ሀት እክ ጠረኝ ኡሮተ አታለኖ? ");
INSERT INTO alw_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","አን ሩሃንየ ፉሻሚሁ ብዔልዜቡሌ ወልቃን እኮጎሬ እለክዕኔ አዬ ሱዕሚን ፉሽታአ? ህካን እኮቤቺሃ ገይክዕኔ እለት ክዕኔ አሌን ፈረዳእረ እካአ። ");
INSERT INTO alw_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ጠዉ እኮጎሬ አን ሩሃንየ ፉሻሚሁ መገን ወልቃን እኮች መገን ዎምነቱ ክዕኔቤቹ አሜተኖት። ");
INSERT INTO alw_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ህትን መቱ ጀቡ መንቹ ጌሬንጌሩለከ በገዙ አፍ ምንስ አገረኖረ ዮስ ዱንያስ ጡመገ አገረንታአ። ");
INSERT INTO alw_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ጠዉ እኮጎሬ እሲች ጀቡ መንቹ አሜች ብተም ቄሎ ወክት ወዕና አመዕን ሄዕዮ እቅ በገዝ ኦደተ ኣእ ከም ዘረፎ ኦዳተ መኒሀስ ቤሀኖ። ");
INSERT INTO alw_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«ኢን ሜጡበ እህቡ ጉዕሙንኩ ኢን ሀንበዕለመኖ፤ ህትን ኢን ሜጡበ ጭምአእቡ ጉዕሙንኩ ብንአዕይ ከመኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","ህከኒች ኤተሮን ኢስ «ዶሮረኖ ዱሩ መንቺች ፉል ኦሮዕዮ ወክት ፎሎጨኖ ቤቹ ሀሰን ዉሁ ዮበእቤቾን ሃመን ዘሀኖ፤ ፎሎጨኖ ቤቹ ሆጎ ወክት ‹ወዕና ፉሎም ምኒኤ ፈንቀል ኦሮኣም› የኖ። ");
INSERT INTO alw_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ፈንቀል አሜተኖ ወክት ምኑስ መክ ሀጠወማን ደገኖ። ");
INSERT INTO alw_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ህከኒች ኤተሮን መር እሲች ባሰ ሂላኑተ ለመለ ዎሉ ሩሃንየ ኤበኖ፤ እሰን ኣግ ህከኔ ሄኣአ፤ ህከን መንች ኤተሩስ ወዕኔችስ በትሽ ሻዝሰኖሃ እሀኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ኢስ ህካን ጠወአን ሄዕዮገን ልግቤ መን በላን መት መንቹት ላገሴ ጎት አት ኢሰ «ኬሳሃ እልቶ መንቹት ማሰአንቶእታን» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ጠዉ እኮጎሬ እስ «ማሰአንቶእሩኑ መገን ላገተ አገርታእረ» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ልግቡ መኑ ጭምዬ ወክት ኢስ «ከን ዘማኒ መኑ ሂለሃን፤ መላተ ለኦተ ሀሰኖ፤ እኮጎሬ ዩኑስ መላ ቤሉ ዎልት መላት ሆሮን ኣሰንታስበአ። ");
INSERT INTO alw_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","መሰንትስ ዩኑስ ናናዌ ከተም መኒ መላተ እኮገን ህትን መንች ቤቱሁ ከን ዘማን መኒሃ መላተ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ካበ ባድ ዳኘት ‹ሳበ› ዬኖት ሱላይማኔ ሀይመተ ሞጮጭቶተ ኡለ ዳንጊች አሜቶቤቺሃ ፍርድ በር ከን ዘማን መኒን ሜጡበ ኬእ እሰተ ዎቀሳአ፤ ከለዕዬ! ሱልማኒች በተአኖሁ ከበ ዮኡ። ");
INSERT INTO alw_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ህትን ናናዌ ከተም መኑ ዩኑስ ዱዱብስያንሰ ጩብሰ ቶበቶቤቺሃ ፍርድ በር ከን ዘማን መኒን ሜጡበ ሬሆች ኬእ እሰተ ዎቀሳአ፤ ከለዕዬ! ዩኑሲች በተአኖሁ ከበ ዮኡ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ኢስን «አዪሁ ኩራዘ ቀሽ ምኒ ኣገኖ መኑ ኑር ለኢሃ አታለኖቤቾን ኩራዘ ሱተኖ ቤሉ ማጭ ሰፈ እፍሰኖሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ህትን እልክ ጅስምሃክ ኑርየ፤ እልክ ፈየተ እኮ ወክት ጅስሙክ ጉዕሙንኩ ኑርን ዊሞሃ እሀኖ፤ ህትን እልክ ፈየተ እክበ ወክት ጅስሙክ ጉዕሙንኩ ቱንስቹ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ህካን እኮቤቺሃ ኪን ዮ ኑሩ ቱንስቹ እሀኖበእገ አገዕር። ");
INSERT INTO alw_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ጅስሙክ ሜጡ ቤቹሁ ቱንስቹ ሄኡዕናንስ ጠለዕል ኑር እኮጎሬ ኩራዝ ኑሩ አበ ለሊሰኖ ጌሰ ጅስሙክ ጉዕሙንኩ ኑር እሀኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ኢስ ህካን ጠወአንን መቱ ፈርሳውቹ ምኔንከስ ዛበዕይ ሆሹ እቶተ ኡጬስ፤ ህካን እኮቤቺሃ ኢስ ምኒ ኣግ ሆሹ እቶተ አፉዕሌእ። ");
INSERT INTO alw_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ኢስ ሆሹ እቱዕነ ሄጭ አንገተ ኣዕሉ ሆጉስ ሁኩ ፈርሳውቹ ለዕዮ ወክት አበ አጀብሲጬእ። ");
INSERT INTO alw_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ህካን እኮቤቺሃ ቀርቹ ህከ ፈርሳውቹ «አዕኑ ፈርሳውያኑት! ኩበየለከ ሳነ አብልስ ኣንሽቴነንተ፤ ጠዉ እኮጎሬ ኣዜንከክዕኔ ወልቅሴን ኣኡለከ ሂሉ ጠዉ ዊሞህዕኔ። ");
INSERT INTO alw_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ኩ ገዋኑት! ኤተርስ አደ ከለቆሁ ኣዝስ አደ ከለቆበእንዶ? ");
INSERT INTO alw_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ህከን ኣዜን ዮኢሃ ቡጥቻኖተ ዘከተ ኣስዬ፤ ጉዕሙርቹንኩ ሙጩሩ እሀኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«ጠው እኮጎሬ አዕኑ ፈርሳውያኑት ገንበለ ጠጉተ፥ ጫሮቴችለከ ጋሮ ጠጎች ጉዕሚችን ዘከተ ፉሽቴነን ሀንቅ ፍርደለከ መገኑ ኢቱ ህንቄንተቤቺሃ ክዕኔሃ ቆሀኖህዕኔ! እኮጎሬ ዎሉሲንገ አጉርቶኑዕናን ከ ጠወ አኡ ሀስሰኖህዕኔ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ህትን «ጭምት ምናን ኬዕምኝ ቦርጭማን አፉዕሉለከ ጌቦ ዮቤቾን ጠውሲሶኖህዕኔተ ሀሴነንተቤቺሃ ክዕኔ ፈሪሳውያኖተ ቆሀኖህዕኔ! ");
INSERT INTO alw_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","መኑ ደጉዕነ አሌስ ሃመኖ ለልቡ ሎደ አጉዴነንተቤቺሃ ክዕኔሃ ቆሀኖህዕኔ!» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","መገን ሕገ ደጋሀኑኡች መቱስ ፈንቀሽ «አስተማርቾ! ካን ዩክ ህትን ኔሳሃ ቦሮሩሃክበዕንዶ!» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ኢስን ፈንቀሽ «አዕኑ ኬዕምተ እጅነተ መናን እጅሲሴን እጅነስ አዕኑ ዙሩዕሜንከክዕኔ ኡልቴነንተበእቤቺሃ መገን ሕገ ደጌነንተ ክዕኔሃ ቆሀኖህዕኔ! ");
INSERT INTO alw_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ህትን አናከክዕኔ ሽቶ ነቢያከ ሎደሰ ምልካንስቴን መክሴነንተረ እኬንተቤቺሃ ክዕኔሃ ቆሀኖህዕኔ!» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ህካን እኮቤቺሃ አዕኑ ምስክረተለከ አናከክዕኔ ሂለ ሆጎን ኢተቀንቴንታእረ፤ መሰንትስ አናከክዕኔ ሽቶኡ፤ አዕኑንገ ሎደሰ መክሴነንታት። ");
INSERT INTO alw_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ህካን እኮቤቺሃ መገን ሀይመት አን እሰቤቹ ነቢያከተለከ ሶቀማኑተ ሶሃም፤ እሳችን መት-መቱሰ ሽታአ፤ ፈቆረ ሸርታአ ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ሁኩን እኮሁ ኣዱንያት ከለቀንቶች ኬሽ ነብያካች ዱንተዕዮ ቄጊሃ ከን ዘማን መኑ ጠዕመመኖ። ");
INSERT INTO alw_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ሁኩንን አቤሌ ቄጊች ኬሽ መገን ክትም ሆንጠህሴኖ ጠረጴዛንለከ ዱእ ምኒ በላን ሬዮ ዘከርያሴ ቄጉ ኢላት፤ ኤ! አን ያንክዕኔ፤ ህከን ቄጊሃ ከን ዘማን መኑ ጠዕመመኖ። ");
INSERT INTO alw_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","አዕኑ «ሕገ ደጌነንተሩ ቆሀኖህዕኔ! ደግ ቁልፈ ፈኔኖሃ ሀንቅ ቁልፈ አፌንታአ፤ ጠዉ እኮጎሬ አዕኑ ገዉንኩክዕኔ ኣጌንታበአ፤ ኣጉ ሀሳእራ አጋበእገ ከንቴንታአ።» ");
INSERT INTO alw_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","ኢስ ኦሮአን ሕግ አስተማረትለከ ፈርሳዊያኑት መት ሉሰተ አፌችስ ደግ አፎተ ሀስ አበ ጥቅስ ጢቄን ልግብ ጠዕምቱተ ጠዕምቶስተ ኡለንስታሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ህከ ወክት ልግቡ ኩሜ መኑ ጭምይ ኬዕይ ገገዉንኩሰን ሀንበዕለንተን ከጣቀንታእት እቅ፤ ኢስን ሄጭ አሳባተስ «ፈርሳዌ ራጭቲች አገዕርዬ፤ እስን ለዕዬኤ ዩሃን። ");
INSERT INTO alw_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ጠው እኮጎሬ እፍሰሞርቹ ፈንተኡዕነለከ ማጠሞንኩ ለሉዕነ ፈቀኖበአ። ");
INSERT INTO alw_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ህካን እኮቤቺሃ ቱንስቾን ጠወኤንተርቹ ጉዕሙንኩ ኑሬን ሞጮጨመኖ፤ ህትን ጡፈንቶ ጎጆን ኩሽኩሽይቴን ጠወኤንታሃ በነቻን አዋጄኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ኢስ «ክዕኔተ ኢ ጃላ ያንክዕኔ፤ ጅስመ ሽቶተ አታልታእረ ዎሉ መቱርቹሃ አቶተ አታልትበረ ዋጅቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ጠዉ እኮጎሬ አዬ ዋጁ ሀስሰኖኔ ጎሬ ጠረኝሽ ኩላንክዕኔ፤ ሼች ኤተሮን ዘማኒሃ ጉዕሚንከ ጠእትበ ጊራን ዎረኖ ወልቀት ዮስ መገኑ ዋጅዬ፤ ኤ! አን ያንክዕኔ፤ እሱ ዋጅዬ። ");
INSERT INTO alw_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«ኦንት ጭኡት መቱ ሳንትበ ህረንታእበእንዶ? ሆሮን እሳች መቱሰ መገን ብሬን ሀበንታበአ። ");
INSERT INTO alw_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ክዕኔሁ ሆሮ ቡዕልክዕኔ ሙሙሁ ጉዕሙንኩ ዎለአሞእሃን፤ ህካን እኮቤቺሃ አዕኑ ልግቤ ጭኦች በትሴን ደግለልቴነንተቤቺሃ ዋጅቶኖቼ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ኢስ አን ኩላንክዕኔ፤ መን ብሬን መሰከረኖኤሀኒሃ ጉዕሚንከ መንች ቤቱ መገን መላይካ ብሬን መሰከረኖስ። ");
INSERT INTO alw_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ህትን መን ብሬን ለገአኖኤሀኒሃ አኒሁ መገን መላይከ ብሬን ለገኣንስ። ");
INSERT INTO alw_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ህትን መንች ቤት አሌን ቦሮር ላገተ ጠወአኖሀኒሃ ጉዕሚንከ ጩቡስ ማረመኖስ፤ ጠዉ እኮጎሬ ጠሊለ አያን አሌን ቦሮር ላገተ ጠወአኖሀኒሃ ጩቡስ ሆሮን ማረመኖስበአ። ");
INSERT INTO alw_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«መኑ ጭምት ምንቤቹ፥ ገሻኖ ብርተለከ ዳኛኖ ብርተ ፍርድ ሆንጠህሰኖህዕኔ ወክት ‹ሀት ፈንቀሽናም? ህከረንገ መ ጠወዕናም?› ይቴን ጨነቀንቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","መሰንትስ ጠወኡ ሀስሰኖህዕኔሃ ህከ ወክትንከ ጠሊሉ አያኑ ኩለኖህዕኔ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ህከን ልግብያ መን በሊች መቱ መንቹ «አስተማርቾ አንኤ ወጥ ኤሳሃ ቤሆተ አመኤ ቤቲሃ ኩል» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ጠዉ እኮጎሬ ኢስ «ኮ መንቾ! ክዕኔ አሌን ዳኛለከ ወጥ ቤሃንቹ አዕዮኤሁ አዬት?» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","እስን ጉዕማንከ መኒሃ «መን ሄኡ ቀባጦስ በትኜን እህበቤቺሃ ሄዕላቻች ጉዕሚችን ጠረኝቴን አገዕርዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ኢስን መኒሃ «መቶ ቀባጣሞ መንች ኡለት አበ አቶተ አቶቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ሁኩ መንቹንኩ ቀልቤንከስ ‹አቶተእ ጭም አአም ቤቹ ዮኤበእቤቺሃ መ አዕዮምጎሬ ቆሀኖኤ?› ይ ሰውዬእ። ");
INSERT INTO alw_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","እስን ‹አአሚሁ ከኒት፤ ጎተረኤ ጉዕመንከ ድጅ አልባዕሉ ጎተረ እጃራም፤ ህት አዕዮሚች ኤተሮን አቶተ ጉዕመንከ ጭምአዕይ አፉሻም። ");
INSERT INTO alw_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","አንን ነብስያኤ ኢ ነብሴቾ! ልግቤ ዘማኒሃ እካ ቀባጡት ዮሄ፤ ህካን እኮቤቺሃ ፎሎጭ! እት! አግ! ሙንደእ! ያንሴ› ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ጠዉ እኮጎሬ መገኑ ‹ኩ ገዉ! ከበሬ ሀንከዕሬን ነብሳክ ኪች ሀሳም፤ ኩ ጭም አቶንት ዱንያት ጉዕሙንኩ አዬሃ እካአ?› ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","«ገይሀስ ዱንያተ ጭም አአን መገንሀኔን ቀባጣሙ እህቡ ጉዕሙንኩ ህትናሙሃን» ይ መት ማቁተ ኩሎሰ። ");
INSERT INTO alw_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ኢስ አሳበስ «አን ያንክዕኔ፤ ነብሴሃክዕኔ እቴነንተሀኒሃለከ አሊሀክዕኔ ኦደኤነንተሀኒሃ ኦርጨቀንቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","መሰንትስ እቴነንተሀኒች ነብሶሁ ኦድኖችን ጅስሙ በተአኖ። ");
INSERT INTO alw_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ህንዴ ቁሬኤተ ለዕዬሰ፤ ዉጣበአ፤ ምዳበአ፤ ህትን ጭምአታ ምኑ ህከረንገ ጎተሩ ዮሰበአ፤ እሁን ቤሉ እታኢሃ መገኑ ኣሰኖሰ፤ አዕኑ ጭኦች በተኤነንተበእንዶ? ");
INSERT INTO alw_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ህትን ክዕኔች ጨነቀም ኡሙርስ ዘማኔን መቱ በር በርጎተ አታለኖሁ አዬት? ");
INSERT INTO alw_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ከ ቀዉ ጠወ አኢሃ አታልቴንቡረ እኬነን ዎሎ ጠዊሃ ሚሃ ሻዜነን? ");
INSERT INTO alw_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ህትን ቦብሉት ሀት እክ ነጵታ ጎሬ ለዕዬ፤ እሰን ሆጎን ሆጋበአ፥ ደዳበአ፤ እኮጎሬ ዎሉስ ፈቅ ሱላይማን ህከን ጉዕማንከ ሎርማንከስ ህከን ቦብሎች መትሴገ ኦደዕዮበአ። ");
INSERT INTO alw_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ጠዉ እኮጎሬ መገኑ ከበር ለልት ጋቴተ ጊረ ኡጄኖ አብል ህጥተ ሄንከ ኑርሰኖ እኮች አዕኑ አመዕነቱ ሆፈዕዮህዕኔሩ! ክዕኔተ ሄንከ ኑርሰኖህዕኔ እቅ! ");
INSERT INTO alw_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","«ህካን እኮቤቺሃ ‹መ እንታም? መ አንጋም?› ይቴነን ጉዕመ ወክት ሻዞኖቼ። ");
INSERT INTO alw_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ህካን ጉዕመንከ ኣዱንያ አሌን ዮ መኑ ጉዕሙንኩ ሀሰኖ፤ እኮጎሬ ሀሲሰኖህዕኔሃ ክዕኔ አኑንኩክዕኔ ደገኖ። ");
INSERT INTO alw_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","አዕኑ መገን ዎምነቱ ሀሼ፤ ሀሴነንታሁ ጉዕሙንኩ ኣሰመኖህዕኔ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","አዕኑ ቀዉ መሰረት! ሰሜ አኑክዕኔ ዎምነቱ ኣሶህዕኔተ ኢቴቤቺሃ ዋጅቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ህካን እኮቤቺሃ ዮህዕኔሃ ጉዕመንከ ህርቴን ቡጥቻኖተ ኣስዬ፤ ጎፍበ ከረጥትተ መክሴን ጎፍበ ዱንያተ ኣዜስ አቴን ሞጋንቹ ኣእበቤቾንለከ ብሉት እትበቤቾን ሰማን አፉሽዬ። ");
INSERT INTO alw_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","መሰንትስ ዱንያክዕኔ ሄኣቤቾን ህከኔ ቀልቡክዕኔ ሄአኖ። ");
INSERT INTO alw_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ኢስ «ረመዙክዕኔ ኡሱርቴን ኑሩክዕኔ ለሌኢሃ እሁን። ");
INSERT INTO alw_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ህትን ቀርቹሰ አሜች ኡሩተ ቆጬ ወክት ፈንቶተ ቦለች ምኒች ፈንቀል አሜቶተ ኢለ ጠረኝ አገረኖ መነ እኬ። ");
INSERT INTO alw_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ቀርቹሰ አሜቾ ወክት ተቃጠብ አገርተን ደገኖሰ ካዲመት ማሰአንቶእረ፤ ሀንቅንከ ያንክዕኔ፤ እስን ረመዙስ ኡሱር ማዳን አፉሽ ካደመን እትሰኖሰ። ");
INSERT INTO alw_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","አይደጎ ቀርቹሰ ሀንከዕሬ በላን ህከረንገ ሀንከዕሬ በሊች ኤተሮን አሜቾ ወክት ጠረኝት አገርተን ደገኖ ካዲመት ማሰአንቶእረ። ");
INSERT INTO alw_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ጠዉ እኮጎሬ ካን ደጌ፤ መቱ መንቹ ምንስ ሞጋንቹ መ ወክት አሜተኖጎሬ ደጎእቀ ምንስ እሞተ ሰዕምይ አጉረኖበ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ህትን መንች ቤቱ ሰውይቴንበ ወክት አሜተኖቤቺሃ አዕኑሁ ተቃጠቤን አገሬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ጴጥሮስን «ቀርቾ! ከ ምሳልተ ጠወኣንቲሁ ኒሳህትንዶ? ህከረንገ ጉዕሚሃንት?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ቀርቹንኩ ፈንቀሽ «ህካን እኮች በሬ በሬተ እታኢሃ ወክቲን አሶሰተ ቀርቹ ካዲመስ አሌን ዳኛ አአኖ አመዕነሞ ቀልባሙ መንቹ አዬት? ");
INSERT INTO alw_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ቀርቹስ አሜች ዬስገ አአን ደገኖስ ሁኩ ካዲንቹ ማሰአሞእሃን። ");
INSERT INTO alw_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ሀንቅንከ ያንክዕኔ፤ ቀርቹስ ህከ ካዲንቹ ዮስ ዱንያንተስ ጉዕማንን ዳኛ አአኖስ። ");
INSERT INTO alw_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ጠዉ እኮጎሬ ሁኩ ካዲንቹ ቀልቤንከስ ‹ቀርቹኤ አሜቱዕናን ዱንከኖ› ይ ሜንትለከ ጎን ካዲመተ ኦለን እቱ፥ አጉለከ ሰከሩ ጀመሮረ ");
INSERT INTO alw_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ህከን ካዲንች ቀርቹ ‹አሜተኖ› ይ አገርበ በሬንለከ ደጎበእ ሰኣቴን ድንገቴን አሜች ቀጠዕይ አመዕነሞበእ መኒን ሜጡበ አአኖስ። ");
INSERT INTO alw_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«ቀርች ሰውት ደገን ተቃጠብቡለከ ቀርቹስ ሀሾ ሃሊን አእቡ ካዲንቹ አበ ገረፈመኖ። ");
INSERT INTO alw_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","እኮጎሬ ቀርችስ ሰውት ደጉዕናን ቀጠአመኖ ሆጉተ አአኖ ካዲንቹ ቀዉ ገረፈመኖ፤ መሰንትስ ልግብ ጠወ ኣሴመስ መንቺች ልግብንከ ሀሴኖ፤ ህትን ልግብ ኤገተ ኣሴመ መንቺች ልግብንከ ኣኦኖተ ሀሴኖስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ኢስ «አን ኣዱንያ አሌን ጊረተ አፍሲሶተ አሜቾም፤ ህካን እኮቤቺሃ ደዕልት አጵቶ እቃ ሄንከ ኢታም እቅ። ");
INSERT INTO alw_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ጠዉ እኮጎሬ መቱ ጠመቀማም ኦርሸ ጥምቀቱ ዮኤ፤ እስን እሆተ ኢለ ጨነቀሞም። ");
INSERT INTO alw_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","አን ወገሬት ኤቦተ ኣዱንያ አሊሃ አሜቾሚሃ አጉደኖህዕኔንዶ? ህትጎተበአ፤ ሀንቅስ ጠወኣንክዕኔ፤ አን አሜቾሚሁ አደዶመተ ኤቦታት። ");
INSERT INTO alw_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ከበሬች ኬሽ መቶ ምኔን ሄኣ ኦንቶ መኒች ሰሱሰ ለም አሌን ህትን ለሙሰ ሰስ አሌን ኬእ ብተንታአ። ");
INSERT INTO alw_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ህትን አኑ ቤትስ አሌን፥ ቤቱንኩ አንስ አሌን፥ አመንት ቤቶሴ አሌን፥ ቤቱንት አመሴ አሌን፥ በሉት ቤት ጫ አሌን፥ ቤት ጫንት በሎሴ አሌን ኬእ አደደ እካአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ኢስ ኡመቲሃ «ጎመት ገርብ አዲን ኬአን ለኤንተ ወክት ከበር ‹ጤነ ኡቦታት› ይቴነንተ፤ ይቴንተገን እሀኖ። ");
INSERT INTO alw_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ህትን ከኣጵ አዲን ቦብርሰን ለኤንተ ወክት ‹አበ ፋረተ እሆታት› ይቴነንተ፤ እስን ይቴንተገን እሀኖ። ");
INSERT INTO alw_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","አዕኑ ኩ ለዕዬኔ! ለዕዬኔ! ይቴነንተሩ ሰሜለከ ኡለ ጠወ ለኤን አደደ አቴን ደጌነንተ፤ ጠዉ እኮጎሬ ሚሃት ከን ዘማኔን እሀኖ ጠወ አደ አቴን ደጌነንተበኢሁ?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ኢስ «አዕኑ ገዉክዕኔ ሚሃት ሀንቅ እኮ ጠወ ፈረዴነንተበአ? ");
INSERT INTO alw_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ባለጋርንከክ ሜጡበ ዳኝቤቹ መርታንት ወክት ዎቃን ሀራዕረም፤ ህካን እህባች ባላጋሩክ ዳኝበ መሴሃን ዳኙንኩ ወታደሪሃ ህግሽ ኣሰኖሄ፤ ህትን ወታደሩንኩ ኡሱር ምኒ ኣግሰኖሄ። ");
INSERT INTO alw_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ሀንቅንከ ያንኬ፤ መቱርቹሁ ፈቁዕነ ባቱዕናን ህከን ኡሱር ምኒች ሆሮ ፉልታንትበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ህከ ወክት መኑ አሜች «ገሊለ ባድ መነ ክትመ ሆንጠህሰን ጲላጦስ ሽኬዕይ ቄጉሰ ክትምንከሰ ሜጡበ ሊቃልቆ» ይት ኢሲሃ ኩልቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ኢስን ፈንቀሽ «ገሊል ባድ መኑ ህትኔ በኡ እሌሰቤቺሃ ገሊለ ባዶን ዮ ዎሎ መኒች ጉዕሚችን አበ ጩበኛኑተ አጉዳህዕኔትንዶ? ");
INSERT INTO alw_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","አን ኩለንኪዕኔ፤ ህትጎተበአ፤ ጠዉ እኮጎሬ ቶበቴንባች አዕኑ ጉዕሙንኩክዕኔ ህትን በኤነንተ። ");
INSERT INTO alw_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ህትን ‹ሰልሆመ› ዬኖቤቾን ሎሩ ግንቡ አሌሰ ኡብ ሼ ቶነ ህዜቱ መንቹ ዬሩሰሌማን ሄኣ ዎሎ መኒች ጉዕሚችን በትስ ጩበኛኑተ አጉዳህዕኔትንዶ? ");
INSERT INTO alw_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","አን ኩላንክዕኔ፤ ህትጎተበአ፤ ጠዉ እኮጎሬ ቶበቴንበጎሬ አዕኑ ጉዕሙንኩክዕኔ ህትን በኤነንተ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ኢስ «መቶ መንች ጋሮስ ኣዜን ሄኦ ሀቅ በላን መት ኦድ ሀቁቹት ሄኦ እቅ፤ እስን ላልቹ ሀሽ እሴቤቹ አሜቾ ወክት መቱርቹሃ ደጎበአ። ");
INSERT INTO alw_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ህካን እኮቤቺሃ እስን ህከን ሆጉተ አአኖ መንቺሃ ‹ከለእ! ከን ሰሶ ዘማኔን ተን ኦድ ሀቁቾች ላልቹ ሀሽ መቱርቹሃ ደጎምበአ፤ ሙርት ከም፤ ሚሃ ኡለተ ቤሳአ?› ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ሆጉተ አአኖንኩ ‹ቀርቾ! ፎቀሴ ሀረሞተለከ መዳበራ ዎሮተ ጠለዕል ከዘማኔተ አጉር። ");
INSERT INTO alw_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","አሜተኖ ዘማን ላልቹ ላልቶጎሬ ጡመሃን፤ ጠዉ እኮጎሬ ላልትበ ጎሬ ሙርቶተ አታልታንት› ይ ፈንቀሼስ» ይኬዕይ ተ ምሳልተ ኩሎሰ። ");
INSERT INTO alw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ኢስ አበ በሬን ጭምት ምናች መቶንከስ ተማርሰኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ህከኔን ቶነ ህዜቱ ዘማን ዶሮረኖ ዱሩ ጉብራይሾሴ መት መንቹት ሄኦ እቅ፤ እሴን ጌጥ ይት ኡርቶተ ሆሮን አታልታበ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ኢስን ለዕዮሴ ወክት እስቤቹ ገእ «መንቾ! ሆግሳሄ ጥዘናች ፈይቶንት» ይ ");
INSERT INTO alw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","አንገስ አሌንከሴ አዕዮ፤ ህከ ወክቲንከ ጌጥ ይት ኡርት መገኑ ገለትጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ጠዉ እኮጎሬ ኢስ አበ በሬን ፈይሾሴቤቺሃ ህከን ጭምት ምኒ ገሻንቹ ኡሙዕር መኒሀስ «ሳምንታን ሆጉተ አኤኖ ሌሁ በሩ ዮኡ፤ ህከን በሬን አሜቴነን ፈይዬ ቤሉ አበ በሬን አታልሲሰኖበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ህከኒች ኤተሮን ኢስ ፈንቀሽ «ኩ ለዕዬኔ ለዕዬኔ ይቴነንተሩ! ክዕኔች መት-መትችክዕኔ አበ በሬን ቦረስ ጋድሪች ህከረንገ ሀርስ ጎሊች ሂር ዋሃ አግሶተ መሰኖበእንዶ? ");
INSERT INTO alw_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ት ጫት ቶነ ህዜቱ ዘማን ሸይጣኑ ኡሱራንሴ ሄኦ እብራሂምተ ቤቱ፤ እሴን አበ በሬን ኡሱሮችሴ ሂርተኡ ሀስሰኖሴበእንዶ?» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ኢስ ህካን ጠወአንን እሲን ሀንበዕለንተ መኑ ጉዕሙንኩ ሙልቶኡ፤ ህትን መኑ ጉዕሙንኩ ኢስ አዕዮ አጀብሲሰኖ ጠዋን ጉዕማንን አበ ሙንደኦኡ። ");
INSERT INTO alw_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ህከኒች ኤተሮን ኢስ «መገን ዎምነቱ መ አጉደኖ? ህትን አን ሚን አጉጣቀንሳንስ? ");
INSERT INTO alw_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","መገን ዎምነቱ መቱ መንቹ ጋሮስ ዉጮ ወንጌ እልተ አጉደኖ፤ እሴን ነጵት ሀቅ ጌሰ እካአ፤ ሰሜ ጪኡት ሀማንከስ ምኒ እጃርታአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ለንኪሃ ኢስ «መገን ዎምነቱ ሚን አጉጣቀንሳም? ");
INSERT INTO alw_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","መገን ዎምነቱ መት መንቹት ሰሶ ኮርቦቦ ዊሙ ቀሙ ሁፍ ዮተ ቀማንከስ ቁስቶ ራጭተ አጉደኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ኢስ ዬሩሳሌመ መረን ከተማንለከ ገጠራን ጉዕማንን ተማርሰን ህገኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ህከ ወክት መቱ መንቹ «ቀርቾ! ጡምታእሩ ቀዉሃ መነንዶ?» ይ ጠዕሜሰ፤ ኢስን ");
INSERT INTO alw_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«ሩካሸ ኡሮን ኣጎኖተ ሄጫቀሜ፤ መሰንትስ ልግቡ መኑ ህከን ኡሮን ኣጎተ ሀስ አታልታበእገ ኩላንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ምንስ አኑ ኬዕይ ኡሩስ ጡፍ ከሞች ኤተሮን አዕኑ አብልን ኡርቴን ኡሩተ ቆጭቴነን ‹ቀርቾ! ፈንኔ!› ይቴነንተ፤ እስን ፈንቀሽ ‹ሀከን አዲች አሜቴንተጎር ደጋንክዕኔበአ› የኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ህከ ወክት አዕኑ ‹ብሬክ እንቶም፥ አንጎም፤ ህትን በነቻንተኔን ተማርስቶንትኔ› ይቴነንተ። ");
INSERT INTO alw_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ጠዉ እኮጎሬ እስ ‹አን ያንክዕኔ፤ ሀከን አዲች አሜቴንተጎር ደጋንክዕነበአ፤ አዕኑ ሂለ ጠወ አቴነንተሩ ጉዕሙንኩክዕኔ ኢ መዲች ሽቄ› የኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","አዕኑ እብራሂመ፥ ኢሳቀለከ ያቁበ ጉዕመንከ ነብያከተ መገን ዎምነቴን ለኤን አዕኑ አብሌን ፈቁክዕኔ ደጌንተ ወክት ህከኔን ኦኡለከ እንኩተ እጡ እሀኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ህትን ልግቡ መኑ ሸርቂች፥ ገርቢች፥ ቅልቢችለከ ከኣጵ አዲች አሜት መገን ዎምነት ማዳን አፉዕልታአ። ");
INSERT INTO alw_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ህካን እኮቤቺሃ ኤተራኑት ብራኑተ ህትን ብራኑት ኤተራኑተ እካእሩ ዮኡ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ህከ ወክት ፈርሳዌች መት-መቱ መኑ አሜት ኢሰ «ሄሮድስ ሾተ ሀሰኖቤቺሃ ከንቤቺች ፉልት ኦሮእ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","እስን «ህከን ወለንጌቺሃ መርቴን ‹ከበርለከ ጋታ ሩሃንየ ፉሻም፤ ጥዘናመንተ ፈይሳም፤ ሰቅ በር ሆጉእ ሹዕላም› የኖት ይቴን ኩሌስ። ");
INSERT INTO alw_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ጠዉ እኮጎሬ ነብዬቹ ዬሩሳለም ቤሉ ሬሁ ገበእበስቤቺሃ ከበር ጋተለከ ጋቶሽ ዬሩሳሌመ ኦሮኦተ ዎቄ አሌን እሁ ሀስሰኖኤ። ");
INSERT INTO alw_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«ዬሩሳሌማ! ዬሩሳሌማ! ነብያከተ ሽታንቲት! ኪበ ሶሃንቶእረ ክኒን ቀሳንቲት! ሀንጠቤቹት ጭጮረሴ ጎኔንተሴ ጭም አታገን አን እለክ ጭምአኦተ ሀሾሚሁ ሄንከ ወክትዪት? ጠዉ እኮጎሬ አዕኑ ህካን ሀሴንታበአ። ");
INSERT INTO alw_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ህካን እኮቤቺሃ ምኑክዕኔ ኦነ እሀኖ፤ አን ኩላንክዕኔ፤ ‹ቀርች ሱዕሚን አሜተኖሁ ማሰአሞኢሃን› ይቶኖተ ኢለ ከኒች ኤተሮን ለኤነንተኤበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","መቶ አበ በሬን ኢስ ፈርሳዌ አዎንሳኖች መትስ ምኔን ሆሹ እቶተ ኣጎ እቅ፤ እሰን መ አአኖ ጎር ለኦተ አገርታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ህከኔን አሉስ ደርሽዮ መቱ መንቹ ብሬስ ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ኢስን መገን ሕገ ደጋረለከ ፈርሳውተ «አበ በሬን ፈይሱ ሀስሰኖንዶ ሀስሰኖበአ?» ይ ጠዕሜእ። ");
INSERT INTO alw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ጠዉ እኮጎሬ እሰ ጨለ ይቶኡ፤ ህከኒች ኤተሮን ኢስ ህከ ጥዘናሙ አፍ ፈዪሽ ህርሲሾስ። ");
INSERT INTO alw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ኢስን «ክዕኔች ቤቱስ ህከረንገ ቦሩስ አበ በሬን ኤሎን ኡቦጎሬ ህከ ወክት ኤሌች ፉሸኖበኢሁ አዬት?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","እሰ ህከን ጠዊሃ መቱርቹሃ ፈንቀሽቶተ አታልቶበአ። ");
INSERT INTO alw_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ገኤመ መኑ ኬዕምኝ ቤቾን አፉዕልቶተ መጠርተን ኢስ ለዕይ ");
INSERT INTO alw_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«አዪሁ ቦለቸ ገኤሄ ወክት ኬዕምኝ ቤቾን አፉዕልቶት፤ መሰንትስ አይደጎ ኪች ሎዕረኖ መንቹ ገኤማሃ እሀኖ፤ ");
INSERT INTO alw_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ለሙንከክዕኔ ገኤ መንቹ ኪቤቹ አሜች ‹ከቤቹ ከን መንቺሃ ኣስ› የኖሄ፤ ህከ ወክት ሙልት ቀዎ ቤቾን አፉዕልታንት። ");
INSERT INTO alw_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ጠዉ እኮጎሬ ቦለቸ ገኤመሄ ወክት ቀዎ ቤቾን አፉዕል፤ ገኤሄ መንቹ ኪቤቹ አሜች ‹ኢ ጃለ! ኬዕምኝ ቤቾን አፉዕል› የኖሄ፤ ህከ ወክት ኪን ሜጡበ ማዳን አፉዕሌ መን ብሬን ኬዕምኝ ደእታንት። ");
INSERT INTO alw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","መሰንትስ ገዉስ ሎርሰኖሁ ጉዕሙንኩ ሆፈአኖ፤ እኮጎሬ ገዉስ ሆፍሰኖሁ ኬዕምኝ ደአኖ» ይ መት ምሳልተ ኩሎሰ። ");
INSERT INTO alw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ህትን ኢስ እሱ ገኤ መንቹ «ሆሹ ህከረንገ ሁርባት ተቃጠቦንት ወክት እሰ አይደጎ ፈንቀሽት ገእት ሌቃ ባትበገ ጃላክ ህከረንገ አመክ ኦሱተ ህከረንገ እሉክ ህከረንገ ቀባጣሙ ቀኤክ መነ ገእቶት። ");
INSERT INTO alw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ጠዉ እኮጎሬ ድግሰ ድግሳንት ወክት ቡጥቻኑተ፥ አንገተ ሎከተ ሙርተኦእረ፥ ናፋኑተለከ ቆቃኑተ ገእ። ");
INSERT INTO alw_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ህካን አቶንትጎር አቶንቲሃ ባቶተ አታልታበእቤቺሃ ማሰአንቶንቲሃ እካንት፤ ህትን ፈዩ መኑ ሬሆች ኬኣ ወክት መገኑ ባተኖሄ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ኢሲን ሜጡበ ማዳን አፉልቶሀኑኡች መቱ ህካን ሞጮጬ ወክት «መገን ዎምነቴን ማዳን እተኖሁ ሀት ማሰአሞእሃን!» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ጠዉ እኮጎሬ ኢስ ፈንቀሽ «መቱ ወክት መቱ መንቹ ሁርባት ድግሰ ቅጥ አዕይ ልግብ መነ ገኤእ። ");
INSERT INTO alw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ሁርባት እቴኖ ወክቱ እካን ‹ቴሱ ጉዕሙርቹንኩ ቅጥዬቤቺሃ አሜ› ዮተ ካድንቹስ ገኤመ መንቤቹ ሶኮስ። ");
INSERT INTO alw_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ጠዉ እኮጎሬ ገኤመ መኑ ጉዕሙንኩ መቲን መቲን ድግሰስ ፈቆተ ሄዕላት መሰተ ኩሉ ጀመርቶኡ፤ መቱስ ‹ኡለተ ህዕሬምቤቺሃ መር ለኡ ሀስሰኖኤ፤ ህካን እኮቤቺሃ ኤገተክ መረርሲጬኤ› ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ህትን ዎሉስ ‹ኦንቶ ጥንድ ቦረተ ህዕሬምቤቺሃ አቡርታገ ለኦተ መራሚት፤ ህካን እኮቤቺሃ ኤገተክ መረርሲጬኤ› ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ህትን ዎሉስ ‹ጫተ ኤብ እዜቹ እኮምቤቺሃ አሜቶተ አታላምበአ› ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«ሁኩ ካድንቹንኩ አሜች ህካን ጉዕመንከ ቀርቺሃስ ኩሎ፤ ህከ ወክት ምንስ መንቹ ኡሙዕር ካድንቹንከስ ‹ደዕልት ከተም ዎቃሀ፥ በል ዎቃሀ መርት ቡጥቻኑተ፥ አንገተ ሎከተ ሙርተኦእረ፥ ቆቃኑተለከ ናፋኑተ ኤብ ኣግስ› ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ካድንቹንኩ ‹ቀርቾ! አዘዞንቴኤገን አዕዮም፤ እኮጎሬ ቴሁ ፈቆ ቤቹ ዮኡ› ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ቀርቹንኩ ካዲንቺሀስ ‹ገጠር ዎቃለከ በል ዎቃሃ መርት ምኑኤ ዊሞተ ኢለ መኑ አሜተኖገ አእ። ");
INSERT INTO alw_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","መሰንትስ አን ያንክዕኔ፤ ህከን ገአሞ መኒች መቱሁ ሁርበቲችኤ ቀመሰኖበአ› ዬእ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ልግቡ መኑ ኢሲን ሜጡበ ሃመኖት እቅ፤ እስን መን አደ ፈንቀል ");
INSERT INTO alw_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«ኢቤቹ አሜተኖሁ ጉዕሙንኩ አነስ፥ አመስ፥ ጫስ፥ እለስ፥ አመስ ኦሱተለከ ዎሉ ፈቅ ገይስ ፎሉ ፈቁዕነ ለገእበጎር አዎኖኤተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ህትን አዪሁ መስቀለስ እጅ አዎንበኤሁ አዎናንቹኤ እሆተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«ክዕኔች ግንበ እጃሮተ ሀሾ መንቹ ወዕና አፉዕል እጃር ሹልሲሰኖ ብሩ ዮ ጎሬ ይ ሰው ይባሁ አዬት? ");
INSERT INTO alw_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ህካን እህባች ቀበበ ጀመር ሹል እጃሩ አታልባች ለዕዮሁ ጉዕሙንኩ ");
INSERT INTO alw_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‹ኩ መንቹ እጃሮተ ጀመር ሹሉ ሆጎ› ይተን ቀለዳስ። ");
INSERT INTO alw_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ህትን «ቶኖ ኩሜ ወታደሩ ዮስ ዎሙ ለሞድመ ኩሜ ወታደረ አፍ አሜተኖ ዎሚን ኦለሞተ አታለኖንዶ? ኦልሃ መሩዕነ ሄጭ አፉዕል አማዕለመኖበእንዶ? ");
INSERT INTO alw_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ህካን እህባች ኦሊሃ አሜተኖ ወሙ ቄዕራሻን ሄዕዮገን ወገሬት ሶቀማኑተ ሶክ ሀራዕረሞተ ኡጨኖ። ");
INSERT INTO alw_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ህትን ዮሲሃ ጉዕመንከ አጉርባሁ አዪሁ አዎናንቹኤ እሆተ አታለኖበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ቴሁ ኢስ «መጥንት ጡመታን፤ ጠዉ እኮጎሬ መጥንት ጤዕበ ጎሬ ጤኣገ ሚን አኦኖተ አታሌኖ? ");
INSERT INTO alw_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ህትናምት መጥንት ኡላተ መዳበረ እክ ደግለልታበእቤቺሃ ፉሼን አብሌን ኡጄኖስ፤ ሞጮጭታ መጨት ዮሲሁ ሞጮጩን» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","መቱ ወክት ቀረጠ ሙርታእሩለከ ጩበኛኑት ጉዕሙንኩ ኢሲች ሞጮጭቶተ ሆንጠካኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ጠዉ እኮጎሬ ፈርሳውትለከ ሕግ አስተማረት «ኩ መንቹ ጩበኛኑተ ቶግ እሳን ሜጡበ እተኖት» ይት ቁንቁቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ህካን እኮቤቺሃ ኢስ እሰንተ ");
INSERT INTO alw_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«ክዕኔች ጥቤ ሆለት ዮሲሁ ህከን ሆላች መትሴ በኦጎር ሆንሳይኔ ሆንስተ ሆለተ ኡለ ኡድማን አጉር በኦ ሆልቹተ ደጎተ ኢለ ሀሶተ መርባሁ አዬት? ");
INSERT INTO alw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ደጎሴ ወክት ሙንደዕይ ቆዕሌስ እጅ አሜተኖ። ");
INSERT INTO alw_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ምንስ ኢሌ ወክት ጃላስለከ ኦሌስ መነ ሜጡበ ገእ ‹በዕዮ ሆልቹኤ ደኤምቤቺሃ ኢን ሜጡበ ሙንደዕዬ› የኖሰ። ");
INSERT INTO alw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","አን ኩላንክዕኔ፤ ህከንገን ጩብሰ ቶበቱ ሀስሰኖሰበእ ሆንሳይኔ ሆንሶ ጡመ መኒች አበ ጩብስ ቶበተኖ መቶሃ ጩበኚሃ ሰማን አቡ ሙንዲኑት እካአ» ይ ኩሎሰ። ");
INSERT INTO alw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ህትን «ቶኑ ሽልንጉ ዮሴሀኒች መቱስ ሽልንጉ በዕዮሴራ ኩራዘ ለሊስ ምንሴ ሀጣውት ደጎተ ኢለ ኩት አት ሀስባት አዬት? ");
INSERT INTO alw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ደጎ ወክት ጃላከሴለከ ኦሌሴ መነ ሜጡበ ገእት ‹በዕዮኤ ሽልንገ ደኤምቤቺሃ ኢን ሜጡበ ሙንደዕዬ› ይታሰ። ");
INSERT INTO alw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","አን ኩላንክዕኔ፤ ህካን እኮገን ጩብስ ቶበተኖ መቶሃ ጩበኚሃ መገን መላይከ ብሬን ሙንዲኑት እካአ» ይታ ምሳልተ ኩሎሰ። ");
INSERT INTO alw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ኢስ «መቶ መንቺሃ ለም ኦሱት ሄኦስ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ህከኑኡች ማዕኑስ አነስ ‹ኢ አነ! ዮሄ ዱንያችክ እለኖኤ ወጥ ኣሴኤ› ዬእ፤ አኑሰ ዮስ ዱንያች ለሚንከሰ ቤኮ። ");
INSERT INTO alw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ቀዎ በሬች ኤተሮን ማዕኑ ጩሉ ዮስ ዱንያተ ጉዕመንከ አፍ ቄዕራሸ ባዱ ኦሮዕዮ፤ ህከኔን ዱንያስ ጉዕመንከ ገውማን ደግለልበርቾን ብን አይ ቤሾ። ");
INSERT INTO alw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ዮስርቹ ጉዕመንከ ሹሎች ኤተሮን ህከን ባዶን ጠረኙ ጎሩ እካን ሁኩ ጩሉ ኦርጨቀሞ። ");
INSERT INTO alw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ህካን እኮቤቺሃ ህከን ባድ መኒች መቶ መንቾን ኤገተ ኣጎ፤ ሁኩ መንቹኩ ቦኬ ዜማንቹ አዕዮስ። ");
INSERT INTO alw_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ሁኩ ጩሉንኩ ቦክት እታ ሀርቁተ እቶተ ሄዕላተኖ እቅ፤ እኮጎሬ መቱርቹሃ ኣሰኖሲሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ኤተሮን ቀልቡስ ፈንቀላን ‹አንኤ ምኔን ሄኣ ካዲመት ጉዕሙንኩ ጣብተ እት ዱባን ፈቀኖሳት፤ እኮጎሬ አን ከኔ ጎሮን ሬሃሚት። ");
INSERT INTO alw_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ህካን እኮቤቺሃ ከንቢች ኬዕይ አንኤቤቹ መር ኢ አነ! መገኒሃለከ ኬሳሃ ቤሾም። ");
INSERT INTO alw_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ከኒች ኤተሮን ቤቱክ የመም ገአሙ ሀስሰኖኤበአ፤ ህካን እኮቤቺሃ ቀጠረንት አታ ካዲማችክ መትስገ ወለኤኤ ያንስ› ይ ሰውዬእ። ");
INSERT INTO alw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ህከንቤቺችን ኬዕይ አንስቤቹ አሜቾ፤ «እስን ቄዕራሻን ሄዕዮገን አኑስ ለዕይ ሻዥ ደጉጅ መር ጎበስ ሀንቀፍ ሱንቄስ። ");
INSERT INTO alw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ቤቱንኩስ ‹ኢ አነ! መገኒሃለከ ኬሳሃ ቤሾም፤ ከኒች ኤተሮን ቤቱክ የመም ገአሙ ሀስሰኖኤበአ› ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ጠዉ እኮጎሬ አኑስ ካዲመስ ገእ ‹ደዕልቴን አበ ጡመ ኦድኑተ ኤቤን ኦድሼስ፤ ህትን አንገስ ጨንባረ ሎከስን ጫዕመተ ዎሬስ። ");
INSERT INTO alw_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ህትን ምሾ ደርገጌሸ ኤቤን ጎራጬ፤ ነኡ እንቶሁ፥ ሙንደዕኖሁ። ");
INSERT INTO alw_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","መሰንትስ ኩ ቤቱኤ ሬዮ እቅ፤ ሁኩዕኑን ቴ ፎሊን ዮኡ፤ ህትን በዕዮ እቅ፤ ቴ ደገሞኡ› ዬ ወክት ሙንደኡ ጀመርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«ህከ ወክት ሀንገፉ ቤቱ አቡረ ቤቾን አቡረኖት እቅ፤ ፈንቀል አሜተን ምንቤቹ ሆንጠኮ ወክት ከረቡተ ዎቀሬነን ቦለቸ ከዴኖሃ ሞጮጬእ። ");
INSERT INTO alw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","እስን ካዲማች መቱስ ገእ ‹ኩን መርቹሃን?› ይ ጠዕሜስ። ");
INSERT INTO alw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ሁኩ ካዲንቹንኩ ‹አመክቤቱ አሜቾኡ፤ በዕዮ ቤቱስ ደገሞቤቺሃ አኑክ ምሾ ደርገጌሸ ጎራጮኡ› ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ጠዉ እኮጎሬ «ሀንገፉ ቤቱ ኡሙዕር ምኒ ኣጉ ግቦ፤ አኑስ ምኒች ፉል ምኒ ኣጎተ ኡጬስ። ");
INSERT INTO alw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","እስን አኒሀስ ፈንቀሽ ‹ሁኩዕኑን! ልግብ ዘማን ካደሞንኬ፤ አዘዜንቴኤንከ ሆሮ ግቦምበአ፤ ህካን እኮቤቺሃ ደረቦንተእ ሜጡበ ሙንደኦተ መቱ ኮርቤሸሃ ኣቶንቴኤበአ። ");
INSERT INTO alw_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ጠዉ እኮጎሬ ኩ ቤቱክ ዱንያክ ጉዕመንከ ዝነተ አታ መኒን ሜጡበ ሹል አሜቻን ምሾ ደርገጌሸ ጎረጦንትስ› ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","አኑንኩ ‹ኢ ቤቶ! አት ጉዕመ ወክትንከ ኢን ሜጡበ ዮንት፤ ኤሰ ዮኤርቹ ጉዕሙንኩ ኪሃን። ");
INSERT INTO alw_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ጠዉ እኮጎሬ ኩ አመክቤቱ ሬዮ እቅ፤ ቴሱ ፎልን ዮኡ፤ ህትን በዕዮ እቅ፤ ቴሱ ደገሞኡ፤ ህካን እኮቤቺሃ አበ ሙንደኡ ሀስሰኖኔ› ዬስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ኢስ አሳበስ «መቱ ወክት መቱ ቀባጣሙ መንቹ ሄዕዮ እቅ፤ እሲንከ ምንስ አዘዘኖ መቱ ሀላፌቹ ሄዕዮስ እቅ፤ ህከን ቀባጣሞ መንቺሃ ‹ምንክ ገሻንቹ ዮሄ ዱንያክ ብንአዕይ ቤሰኖት› ዬን ኩሌመስ። ");
INSERT INTO alw_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ሁኩ ቀባጣሙ መንቹንኩ ምንስ ሀላፌቹ ገእሲሽ ‹ኩ ሞጮጫም ጠዉ መርቹሃን? ከኒች ኤተሮን ምንእ ገሽቶተ አታልታንትበእቤቺሃ አቶንት ዎልቀክ ጌሰ ኩሌኤ› ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ሁኩ ሀላፌቹንኩ ቀልቤንከስ ‹ቴሱ ሀለቁኤ ኣሴኤ ሆጎች ሸሮኤታት፤ ህካን እኮቤቺሃ መ አኡ? አቡር አታላምበአ፤ ጦለብ እቱ ሙልሰኖኤ። ");
INSERT INTO alw_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ገሽኤ ሆጎች ሸሬመኤ ወክት መኑ ምናንከሰ ኤሳሃ ቶጎተ አኣም ጠወ ደጎም› ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«ህካን እኮቤቺሃ ቀርች ኤዴ መነ ጉዕመንከ መቲን መቲን ገእ ዎዕኔስ መንቹ ‹ኢ ቀርቺሃ ባታንት ሄንኩ ኤዶ ዮሄ?› ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","መንቹስ ‹ጥቤ ምዳኖ ዘይት ኤዶ ዮኤ› ዬእ፤ ሀላፌቹንኩ ‹ኤዶክ ከተበሞ ወረቀተ ኣእት አፉዕልት ኦንታሁ ምዳኑተ ይት ደዕልት ከተብ› ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ህከኒች ኤተሮን ለንክ መንቹሃ ‹ሄንኩ ሌቆ ዮሄ?› ዬስ፤ መንቹንኩ ‹ጥቤ ሆቆማድ አለስ ሌቆሁ ዮኤ› ዬእ፤ ሀላፌቹንኩ ‹ኤዶክ ከተበሞ ወረቀተ ኣእት ህዜታሁ ሆቆማዱ ይት ከተብ› ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ሀለቁንኩ አመዕነሞበእ ሀላፌቹንከ አት ብላታሞሃን!» ዬስ፤ መሰንትስ ከን ሂለ ኣዱንያ አል መኑ ገገዉሰ ሀዕሊሃ ኑሬን ሄኣ መገን መኒች በትስ ኤንኬዕናመተ እሁሰ ለሊሰኖ። ");
INSERT INTO alw_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","አን ኩላንክዕኔ፤ ከን ኣዱንያ አል ተንኩተ አቴን ደእቴነንተ ቀባጦንከክዕኔ ገይሀክዕኔ ጃለተ መክሴነንተ፤ ሁኩ ቀባጡክዕኔ ጎፎ ወክት ጃለክዕኔ ዘላለሚሃ ሄኣ ምኔንከሰ ቶጋህዕኔ። ");
INSERT INTO alw_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ቀዎርቾን አመዕነሞሁ ሎረርቾን አመዕነሞእሃን፤ ጠዉ እኮጎሬ ቀዎን ጡመርቹ አእቡ መንቹ አበ ጠዋን ጡመርቹ አአኖበአ። ");
INSERT INTO alw_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ቴሱ ተንኩተ አኤን ደኤመ ቀባጦን አመዕነንቴንተረ እኬንባች ሀንቅ ቀባጦተ አይ ኤገተ ኣሰኖህዕኔ? ");
INSERT INTO alw_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ህትን ዎሎ መን ቀባጦን አመዕነንቴንተረ እኬንባች ገይሀክዕኔ እካ ቀባጡተ አይ ኣሰኖህዕኔ? ");
INSERT INTO alw_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«ለሙ ቀርቹ ካደመኖ ካዲንቹ ዮበአ፤ ህካን እኮቤቺሃ መቱስ ግብ መቱስ ኢተኖ፤ መቱስ ኬዕምሽ መቱስ ሆፍሰኖ፤ ህትን መገኒሃለከ ዱንያሃ ጠገንቶኖተ አታልቴነንተበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ዱንያተ ኢትታ ፈርሳውት ኢስ ጠወዕዮሃ ጉዕመንከ ሞጮጭት ቀለዶስ። ");
INSERT INTO alw_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ጠዉ እኮጎሬ ኢስ «አዕኑ መን መዴን ገዉክዕኔ ፈየ አቴነንተሩ፤ እኮጎሬ መገኑ ቀልብክዕኔ ደገኖ፤ መሰንትስ መንቤቾን ሎረ እክ ለለኖርቹ መገንሀኔን ህንቀሞእሃን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ኢስ «መገን ሕገለከ ነብያከት ጠወኦኢሁ ጠመቃንቾ ያህይ ወክቱ ኢሎተ ኢለ ሹምነቱ ሄዕዮሰ እቅ፤ ህከን ወክቲች ኬሽ መገን ዎምነት ተሽት ላገት ሜጡበ ተማርሴኖት፤ መኑ ገገዉንኩስ ህከ ዎምነቱ ወልቃን ኣጎተ ሄጫቀመኖት። ");
INSERT INTO alw_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ጠዉ እኮጎሬ መገን ሕግ ላጋች ቀቅቹት በኣሀኒች ሰሞለከ ኡለት ህጋ ዩ ቆሀኖ። ");
INSERT INTO alw_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«ጫስ ገፈር ዎልተ ጫተ ኤበኖሁ ጉዕሙንኩ ዝነተ አአኖት፤ ህትን ጨይችሴ ፉልቶ ጫተ ኣአኖሁ ጉዕሙንኩ ዝነተ አአኖት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ኢስ ሰመ አጉደኖ ብሸተ ኦድኑተለከ ጡመገ መክሴን ደዴመ ኦድኑተ ኦደአኖ መቱ ቀባጣሙ መንቹ ሄዕዮ እቅ፤ እስን በሬን በሬን መክያንስ ተስቄነጭ ሙንዲኖን ሄአኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ህትን አሉስ ጡሌን ጡለ እኮ አልዓዛሬ ዬኖ መቱ ቡጥቹ መንቹ ህከን ቀባጣሞ መንች ግቤስ ብትም መዴን ኦሰዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ሁኩ ቡጥቹንኩ ቀባጣሞ መንች ማዲች ኡቦ ፉርፉሩ እቶተ ሄዕላተኖ እቅ፤ ዉሸት አሜት ጡላስ ላጠ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ሁኩ ቡጥቹ መንቹ ሬዮች መላይከት እብራሂም መድ መስቶስ፤ ህትን ሁኩ ቀባጣሙ መንቹንኩ ሬይ ሞገሞ። ");
INSERT INTO alw_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ሁኩ ቀባጣሙ መንቹ አዛቤን ኦርጨቀመን ቄዕራሻን እልስ ኬሽ እብራሂመለከ ጋለስ አፉዕሌ አልዓዛሬ ለዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","እስን ኢ አነ እብራሂመ! ሀዕይ ኤሳሃ አሙዜኤ፤ አን ከኔ ጊራ ለበነ ኣዜን ኦርጨቀመምቤቺሃ ዙዕሩሜስ ዋን ጬፍ አራብኤ ቅዝሶተ አልዓዛሬ ሶሄኤ ይ ገኤእ። ");
INSERT INTO alw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ጠዉ እኮጎሬ እብራሂም ኢ ቤቶ! ፎሊን ሄኦንት ወክት ናጃን ሄኦንትገ ሰውይ፤ ህትን አልዓዛር ኦርጨቀሞገ ሰውይ፤ ህካን እኮቤቺሃ እሲሃ ቴሱ ከኔ መከኖስ፤ አት ኦርጨቀንታንት። ");
INSERT INTO alw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ህትን ህከኒች ጉዕሚችን በትሽ ከን አዲች ክዕኔ አደ ህጎተ ሀሳእሩ አታልታበእገለከ ህካጵ አዲች አዪሁ ኒ አደ ቶለኖበእገ ኒለከ ክዕኔ በላን አቡ በዉ ዮኡ ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ሁኩ ቀባጣሙ መንቹንኩ ኢ አነ! ህካን እኮች አልኣዛሬ አንኤ ምኒ ሶሆተ ኡጫንኬ። ");
INSERT INTO alw_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","መሰንትስ ህከኔ ኦንቱ አመኤ ኦሱት ዮኤ፤ እሰን ከ ኦርሸ ቤቹ አሜታበእገ እስን መር ጠረኝሽ ኩሉን ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ጠዉ እኮጎሬ እብራሂም «እሳንከ ሙሲለከ ነብያኖ ክታበት ዮሰ፤ ህካን ሞጮጭቱን ዬ ወክት ");
INSERT INTO alw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ሁኩ ቀባጣሙ መንቹ ፈንቀሽ ‹ኢ አነ እብራሂመ! ህትጎተበአ፤ ሬዮ መኒች መቱ መንቹ ኬዕይ መሮ ጎሬ ጩብሰ ቶበታአ› ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","እብራሂምን ‹ሙሲለከ ነብያኑት ከተቦ ክታበት ይታኢሃ ሞጮጭታበኢሃ እኮች ሬዮ መኒች መቱ መንቹ ኬዕይ ኩሎሰ ጎሬሁ አመዕንታበአ› ዬስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ኢስ አሳበስ «መነ ሉሲሰኖርቹ አሜቱዕነ ሆሮ ፈቀኖበአ፤ ጠዉ እኮጎሬ ህከ ሉሲሰኖርቹ ኤበኖ መንቺሃ ቆሀኖስ! ");
INSERT INTO alw_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ሁኩ መንቹ ከን ቀቅቻኖች መቱስ ሉሲሰኖሀኒች ርትም ክኑ ጎበስ ኡሱሬን ባራን ቶሬናንስ ቆሀኖስ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ህካን እኮቤቺሃ ገይሀክዕኔ አገዕርዬ፤ አመክቤቱ ቤሾሄ ጎሬ ሻቅስ፤ እስን ሰጭ ፈንቀሎ ጎሬ አጉርስ። ");
INSERT INTO alw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","መቶ በሬን ለመለ ወክት ቤሾ ጎር ለመለ ወክትንከ ‹ሰጭ ፈንቀሎም› የን ኪቤቹ ፈንቀሎ ጎሬ አጉሩ ሀስሰኖሄ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","አሳበንት ቀርቹ ኢሰ «ሀዕይ አመዕነቱ በርግኔ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ቀርቹንኩ ፈንቀሽ «ጣፌ እሌ ጌሱ አመዕነቱ ሄዕዮህዕኔ እቃን ከ ኦድ ሀቀ ‹ከንቤቺች ቡቱከንት ባራን ካሰም› ይቴነንተረ አዘዘመኖህዕኔ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ህትን «አቡረኖ ህከረንገ ሆለተ አላለኖ ካዲንቹ ዮሲሁ ካዲሙስ አቡራች ፈንቀሎ ወክት ‹ደዕልት አፉዕልት እት› የኖሁ ክዕኔች አዬት? ");
INSERT INTO alw_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ህካን የኖ ወጥ ‹ቴሱ ሁርባት እቶተለከ አጎተ ኢለ ረመዙክ ቆዕርት ካደሜኤ፤ ህከኒች ኤተሮን አት እታንትለከ አጋንት› የኖስበእንዶ? ");
INSERT INTO alw_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ህትን እስ አዘዦርቹ አዕዮሀኒሃ ህከ ካዲንቹ ገለትጨኖስንዶ? ");
INSERT INTO alw_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ህትን አዕኑሁ አዘዘንቴንተርቹ ጉዕመንከ አቴንተ ወክት ‹ነኡ ገለት ሀንስበረ፤ አኡ ሀስሰኖ ጠወ ጠለዕል አዕኖም› ይዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ኢስ ዬሩሳሌም ከተመ መረን ሰመርለከ ገሊል በሊን ህገኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","መት ቀዕተ ኣጎ ወክት ጎግ አል ጥዘነት አፎሰ ቶኑ መኑ ቄዕራሻን ኡርቶሀኑኡን ደቀሞ። ");
INSERT INTO alw_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","እሰን ላገሰ ጎት አት «ቀርቾ ኢሰ! ሀዕይ አሙዝኔ!» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ኢስን እሰተ ለዕይ «መሬ አልክዕኔ ቂሲሃ ለሊሼ» ዬሰ፤ እሰን መርተንን ጎግ አሌን ፉልቶ ጥዘናች ፈይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","እሳችን መቱስ ፈዩስ ለዕዮ ወክት ሎረ ላጋን መገኑ ገለትጨን ፈንቀል አሜቾ። ");
INSERT INTO alw_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","እስን ሚኔንከስ ሙግይ ኢስ ሎከ አሌን ኡብ ገለትጬስ፤ መንቹንኩስ ሰመር ባድየ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ኢስን «ፈይቶሩ ቶኑሃ እቅበእንዶ? ሆንሱሰ ሀከበ ዩኡ? ");
INSERT INTO alw_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ከን ዎሎ ባድ መንች ቤሉ መገኑ ገለትጮተ ፈንቀል አሜቾሁ ዮእንዶ?» ይኬዕይ ");
INSERT INTO alw_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ህከ መንቹ «አመዕነቱክ ፈይሾሄ፤ ኬእ ኦሮእ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ፈርሳውት ኢሰ «መገን ዎምነቱ መ ወክት አሜተኖ?» ይት ጠዕምቶስ ወክት «መገን ዎምነቱ አሜተኖሁ መኑ አገረኖ ሃልጋበአ። ");
INSERT INTO alw_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ህትን ‹ሁኩዕኑን ከበ ዮኡ› ህከረንገ ‹ካጰ ዮኡ› ዬኖሴበአ፤ መሰንትስ መገን ዎምነቱ ዮኢሁ ክዕኔ በላንት» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ህከኒች ኤተሮን ኢስ አሳበስ «መንች ቤት በሬች መቱ በር ለኦኖተ ሄዕላቴነንተ ወክቱ አሜተኖ፤ እኮጎሬ ለኤነንተበአ። ");
INSERT INTO alw_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ህትን መኑ ‹ሁኩዕኑን ከበ ዮኡ› ህከረንገ ‹ሁኩዕኑን ካጰ ዮኡ› የኖህዕኔ፤ ጠዉ እኮጎሬ እሰተ አዎንቴን መርቶኖቼ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","መሰንትስ ሰማን ጉገኛት በለቅ ከን አድ ገበሊች ካጵ አዲ ገበለ ኢሎተ ኢለ ለሊሰኖገን መንች ቤቱ አሜተኖ ወክት ህትን እሀኖ። ");
INSERT INTO alw_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ጠዉ እኮጎሬ ህከኒች ሄጭ መንች ቤቱ ልግብ ኦርሸተ ቶጎተለከ ከን ዘማን መኒን አበ ግበሞተ ሀስሰኖስ። ");
INSERT INTO alw_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ህትን ኑህ ዘማን እኮገን መንች ቤት ዘማኔን ህትን እሀኖ። ");
INSERT INTO alw_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ሁኩንን ኑህ መርከባን ኣገኖ በሩ ኢሎተ ኢለ መኑ እተኖት፥ አገኖት፥ ኤበቀኖትለከ መእሲሰኖት እቅ፤ ቤሰኖ ውሁ አሜች ጉዕመንከ ቤሾ። ");
INSERT INTO alw_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ህትን ሉጥ ዘማንገን እሀኖ፤ ህከ ወክት መኑ እተኖት፥ አገኖት፥ ህረኖት፥ ህዕረኖት፥ ካሰኖትለከ እጃረኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","እኮጎሬ ሉጥ ሶዶም ከተሚች ፉሎ ወክት ጊረትለከ ዲን ሰሜች ጤንገ ኡብ ጉዕመንከ ቤሾ። ");
INSERT INTO alw_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","መንች ቤቱ ለለኖ በርሃ ህትን እሀኖ። ");
INSERT INTO alw_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ህከ በርንከ ምኒ እንት አሌን ሄዕዮ መንቹ ምኔስ ዮ ኦደተ ኣኦተ ድሩንከ፤ ህትን አቡረ ቤቾን ዮእንኩ ኤተሩ ዋል ፈንቀሉንከ። ");
INSERT INTO alw_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ህትን ሉጤ ጫንተ ሰውይዬ። ");
INSERT INTO alw_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ፎልስ ፌሶተ ሀሰኖሁ ጉዕሙንኩ ፎልስ ቤሰኖ፤ ህትን ፎልስ ሆገኖሁ ጉዕሙንኩ ፎልስ ደአኖ። ");
INSERT INTO alw_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","አን ኩላንክዕኔ፤ ህከ ሀዎሮን ለሙ መንቹ መቶ መዕናን ኦሰኣአ፤ ህከኑኡችን መቱስ መሴናን መቱስ ፈቀኖ። ");
INSERT INTO alw_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ህትን ለሙ ሜንቱ ሜጡበ ሪታአ፤ ህከኑኡችን መትሴ መሴናን መትሴ ፈቃአ። ");
INSERT INTO alw_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ህትን ለሙ መኑ መቶ ቤቾን አቡርታአ፤ እሳችን መቱስ መሴናንስ መቱስ ፈቀኖ። ");
INSERT INTO alw_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ህካን እኮቤቺሃ አሳበስ ኢሰ «ቀርቾ! ሀከበዪት?» ይት ጠዕምቶስ፤ እስን «ሬሹ ዮቤቾን ዞብሩ ጭምየኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ህከኒች ኤተሮን ኢስ መኒሃ ሆጉዕናን ጉዕመ ወክትንከ ዱአ አኡ ሀስሰኖሃ እሁስ ተማርሶተ መት ምሳልተ ኩሎሰ። ");
INSERT INTO alw_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","እስን «መቶ ከተማን መገኑ ዋጅቡለከ መነ ከበጅቡ መቱ ዳኙ ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ህከን ከተማንን መት ጨዉሴ ሬዮ መንቹት ሄኦ እቅ፤ እሴን ህከን ዳኝቤቹ ጉዕመ ወክት አሜተን ‹ባላጋርንከኤ ኦዳም ጠወ ፈረዴኤ› ይታሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","እስን ልግብ ወክት ፈረዱ ግቦሴ፤ ጠዉ እኮጎሬ ኤተሮን ቀልቤንከስ ‹መሃ መገኑ ዋጅበጎሬ መነሃ ከበጅበጎሬ ");
INSERT INTO alw_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ት ጨዉሴ ሬዮ ጫት ኦርሳኤቤቺሃ ፈረዳንሴ፤ ህካን እህባች ጉዕመ ወክትንከ አሜተን ኦርሱንከኤ› ይ ሰውዬእ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ቀርቹ ኢስን «ሁኩ ሀንቅ ፈረድቡ ዳኙ ዬ ጠወ ሞጮጭዬ። ");
INSERT INTO alw_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","መገኑ ሀንከዕርተለከ በራሃ እስቤቹ ዎርዋታ መጠረንቶሀኑኡሃ ፈረደኖሰበእንዶ? ህትን ፈረዱዕናን ልግብ ወክት ዱንከኖንዶ? ");
INSERT INTO alw_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","አን ኩላንክዕኔ፤ ደዕል ፈረደኖሰ፤ ጠዉ እኮጎሬ መንች ቤቱ አሜተኖ ወክት ኣዱንያ አሌን አመዕነቱ ደገኖንዶ?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ኢስ «ነኡ ፈያኖታን» ይተን ገዎንከሰ ድከኣሀኑኡተለከ ዎሉ መነ ህንቃ መኒሃ ከ ምሳልተ ኩሎሰ። ");
INSERT INTO alw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ሁኩንን ለም መናከት ዱአ አቶተ ዱእ ምኒ መርቶኡ፤ ህከኑኡችን መቱስ ፈርሳውቹሃ፤ ህትን ለንክስሁ ቀረጠ ሙረኑሃን እቅ። ");
INSERT INTO alw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ፈርሳውቹስ ሜጥሀስ ኡር ቀልቤንከስ መገኖ! ዎሎ መንገ ሁኩንን ወልቅስ ኣእታ መንገ፥ ሾከ መንገለከ ዝነተ አአኖ መንገ ባሰንከስ ከን ቀረጠ ሙረኖ መንችገ እህበቤቺሃ ገለትጫንኬ። ");
INSERT INTO alw_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","አንን ሳምንታን ለሞረ ሶመናሚት፤ ህትን ደኣምሀኒች ጉዕሚችን ቶኒች መቱ ዘከተ ፉሻሚት ይ ዱአ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ጠዉ እኮጎሬ «ቀረጠ ሙረኖሁ ቄዕራሻን ኡርኬዕይ እልስ አሌ ዋሽ ሰማ ለኦተ መለሎበአ እቅ፤ እኮጎሬ ወዘነስ ዎቀረን ‹መገኖ! ኤሰ ጩበኛ መረርሲጬኤ!› የኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","አን ኩላንክዕኔ፤ ፈርሳውቺች አበ ቀረጠ ሙረኖሁ ፈየ እክ ምንስ ፈንቀሎ፤ መሰንትስ ገዉስ ሎርሰኖሁ ጉዕሙንኩ ሙግ የኖ፤ እኮጎሬ ገዉስ ሙግ አአኖሁ ሎረኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","መኑ ቀቀዋኑ ኦሱተ ኢስ አንገስ አሌሰ አኦተ እስቤቹ ኤቦኡ፤ ኢስ አሳበት ህካን ለኦ ወክት ህከ መነ ሻቆኡ። ");
INSERT INTO alw_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ጠዉ እኮጎሬ ኢስ ኦሱተ ገእ «መገን ዎምነቱ ህትናማተ እኮቤቺሃ ኦሱት ኢቤቹ አሜቱን፤ ከንቶኖቼሰ። ");
INSERT INTO alw_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ሀንቅንከ ያንክዕኔ፤ መገን ዎምነቱ ኦሶገ እክ ቶግባሁ አዪሁ መገን ጄነት ሆሮ ኣገኖበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","መቱ ገሻንቹ ኢሰ «ጡመ አስተማርቾ! ዘላለሚሃ ጎፍበ ሄኡ ደኦተ መ አኡ?» ይ ጠዕሜእ። ");
INSERT INTO alw_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ኢስን «ሚሃ ‹ጡመ› ይት ገእታንቴኤት? መገን ቤሉ ጡሙ አዪሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ህትን ትዛዝ ጉዕመንከ ደጋንት፤ ትዛዙንኩስ ‹ዝነተ አቶት፤ ሽቶት፤ ሞግቶት፤ ክዝብ መሰከርቶት፤ አነክለከ አመክ ከበጅ› የኖሃን» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","መንቹንኩስ «ካን ጉዕመንከ ኦስማችኤ ኬሽ አገሮም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ኢስን ህካን ሞጮጬ ወክት «መቱ ጠዉ ፈቆሄ፤ ሁኩንን ዮሄርቹ ጉዕመንከ ህርት ቡጥቻኖተ ኣስ፤ ሰማን ጭምይቶ ዱንያተ ደእታንት፤ ህት እክ አሜት አዎኔኤ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ጠው እኮጎሬ መንቹስ አበ ቀባጣሙ እኮቤቺሃ ህካን ሞጮጬ ወክት ህለብከ ሻዦ። ");
INSERT INTO alw_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ኢስን ሁኩ መንቹ ሂለ ብከ ሻዦገ ለዕይ «ቀባጣመት መገን ዎምነቱ ኣጉ ሄንከ ኬዕመኖሃን! ");
INSERT INTO alw_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ህትን ቀባጣሙ መንቹ መገን ዎምነቱ ኣገኖሀኒች ጋሜሉ መርፌ ጠላዕላን ሕጉ ቆሀኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ህካን ሞጮጭቶ መኑ «ህካን እኮች አይ ጡሞተ አታለኖ?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ጠው እኮጎሬ ኢስ «መኒሃ አታለምቡ መገኒሃ አታለመኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ጴጥሮስን «ሁኩዕኑ ነኡ ጉዕመርቹንከ አጉርን አዎኖንኬ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ኢስን «ሀንቅንከ ያንክዕኔ፤ መገን ዎምነትተኔሃ ምንስ ህከረንገ ጫስ ህከረንገ አመስ ኦሱተ ህከረንገ አነስ ህከረንገ አመስለከ እለስ አጉር ");
INSERT INTO alw_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ከን ዘማኔን ልግብ ወክቲሃ አበ አፎ ኣእቡ ህትን አሜተኖ ዘማኔን ዘላለሚሃ ጎፍቡ ሄኡ ደኡዕነ ፈቀኖ መንቹ ዮበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ኢስ ቶና ለሙንከ አሳበስ መድስ ሽቅ አዕይ «ሁኩዕኑን! ነኡ ዬሩሳሌም ከተመ መርናሚት፤ ህትን መንች ቤትተኔሃ ነብያከት ከተቦ ጠዉ ጉዕሙንኩ ዊመኖ። ");
INSERT INTO alw_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","እሱንከ አይሁደ እህቡ መኒሃ ህግሴን ኣሴናን ቀነጣስ፥ ቦሮርታስለከ አሌስ አንጀ ቱ ይታስ። ");
INSERT INTO alw_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ኦልቶሲች ኤተሮን ሽታስ፤ ጠዉ እኮጎሬ እስን ሰቅ በር ሬሆች ኬአኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ጠዉ እኮጎሬ አሳበስ ህከን ጠውች መቱርቹሃ አጥራመቶበአ፤ ህትን ጠወኦ ጠዉንኩ ለሉ ሆጎሰቤቺሃ ጠወአሞ ጠወሃ ደጎበአ። ");
INSERT INTO alw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ኢስ ኢያርኮ ከተመ ሆንጠኮ ወክት መቱ ቆቁ መንቹ ሰደቀተ ኡጨን ዎቄ ገበላን አፉዕልዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ልግቡ መኑንኩ መዲንከስ ህገን ሞጮጭ «ኩን መርቹሃን?» ይ ጠዕሜሰ። ");
INSERT INTO alw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","መኑንኩ «ናዝሬት ኢስ ከን አዲን ህገኖት» ይት ኩልቶስ። ");
INSERT INTO alw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ሁኩ ቆቁንኩ «ዳዉዴ ቤቶ ኢሰ! ሀዕይ አሙዜኤ» የን ያሮ። ");
INSERT INTO alw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ብሬን ሃንተን ሄኦ መኑ «ጨለይ!» ይት ሻቆስ፤ ጠዉ እኮጎሬ ሁኩ ቆቁንኩ «ዳዉዴ ቤቶ! ሀዕይ አሙዜኤ» የን ላገስ ጎት አዕይ ያሮ። ");
INSERT INTO alw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ኢስን ኡር እስቤቹ ኤባገ አዘዦ፤ ሁኩ ቆቁንኩ እስቤቹ ሆንጠኮ ወክት ");
INSERT INTO alw_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ኢስ «መ አኦሄተ ሀሰን?» ይ ጠዕሜስ፤ እስን «ቀርቾ! ለኢሃ ሀሳም!» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ኢስን «ለእ! አመዕነቱክ ፈይሾሄ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ሁኩ ቆቁ ህከ ወክትንከ ለዕዮ፤ እስን መገኑ ገለትጨን ኢሰ አዎኞ፤ ህትን ኡመቱ ጉዕሙንኩ ህካን ለኦ ወክት መገኑ ገለትጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ኢስ ኢያርኮ ከተመ ኣግ ህከን አዲን ህገኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ህከኔን «ዘክዮሴ» ዬኖ መንቹ ሄዕዮ እቅ፤ እስን ቀረጠ ሙርታሀኑኡተ አዛዣለከ ቀባጣሙሃ መንቹ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ሁኩ መንቹንኩ ኢሰ አዬት ጎር ለኦተ ሀሰኖ እቅ፤ ጠዉ እኮጎሬ እስ ገበንቹ እኮቤቺሃለከ መኑስ ልግብ እኮቤቺሃ ለኦተ አታሎበአ። ");
INSERT INTO alw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ኢስ ህከን ዎቄን ህገኖቤቺሃ ዘክዮስ ብሬን ደጉደን ህግ ኢሰ ለኦተ መቶ ኦድ ሀቃን ቆጶ። ");
INSERT INTO alw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ኢስን ህከ ቤቹ ኢሌ ወክት አሌ ዋል ለዕይ «ዘክዮሴ! ከበር ኪ ምኔን ሆሱ ሀስሰኖቤቺሃ ደዕልት ድር» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ህካን እኮቤቺሃ ዘክዮስ ደዕል ድር ሙንዲኖን ቶጎስ። ");
INSERT INTO alw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","መኑንኩ ህካን ለዕዮ ወክት «ጩበኛ መንች ምኒ እቶተ ኣጎ» ይት ጉዕሙንኩሰ ቁንቁቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ጠዉ እኮጎሬ ዘክዮስ ኡር ኢሰ «ቀርቾ! ዮኤ ዱንያች ጉዕሚችን ደሩስ ቡጥቻኖተ ኣሳም፤ ህትን አዬሁ ጣንስ ኣኤም ጎር ሾሉ አፎስ እሲንከ ፈንቀሽ ኣሳም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ኢስን «ኩ መንቹ እብራሂም ቤቱ እኮቤቺሃ ከበር ጡሙ ከን ምኒሃ እኮኡ። ");
INSERT INTO alw_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","መሰንትስ መንች ቤቱ በዕዮሃ ሀሶተለከ ጡምሶተ አሜቾኡ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","መኑ ህካን ሞጮጨንን ኢስ መት ምሳልተ በርግ ኩሎሰ፤ መሰንትስ ኢስ ዬሩሳሌመ ኢሎተ ሆንጠኮቤቺሃትለከ መገን ዎምነቱ ደዕል ለለኖሃ አጉጆሰቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ህካን እኮቤቺሃ ኢስ መቱ ጡመ ደቦች እለሞ ሎሩ መንቹ ዎመ እክ ፈንቀሎተ ቄዕራሸ ባዱ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ህካን እኮቤቺሃ ካዲማችስ ቶኑሰ ገእ መት-መትሀሰ ቶኑ ቶኑ ምናነ ኣስ ፈንቀል አሜቶተ ኢለ ከንን ነገጄ ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ባድስ መኑ ግቦስቤቺሃ ኩ መንቹ ኒ አሌን ዎመ እሆተ ሀንሳምበአ ይት እስ ኦሮዕዮች ኤተሮን ሶቀማንቹ ሶኮኡ። ");
INSERT INTO alw_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ሁኩ መንቹንኩ ዎመ እክ ፈንቀሎ ወክት ምናነ ኣሴሰ ካዲመት ነገድ ሄንከ ተረፍሶ ጎር ደጎተ እስቤቹ ገእቶተ አዘዦ። ");
INSERT INTO alw_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ወዕኔስ ካዲንቹ እስቤቹ ሆንጠክ ‹ቀርቾ! መቱ ምናኑ ቶኑ ምናነ ተረፎኡ› ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ሀለቅቹንኩ ‹ጡመገ አቶንት! አት ጡሙ ካዲንቹ ቀዎ ጠዋን አመዕነንቶንትቤቺሃ ቶኖ ከተም ሹመ እህ› ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ህትን ለንክሲንኩ አሜች ‹ቀርቾ! መቱ ምናኑ ኦንቱ ምናነ ተረፎኡ› ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ሀለቅቹንኩስ እሲሃ ‹አት ኦንቶ ከተሚሃ ሹመ እህ› ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ህትን «ዎሉስ አሜች ‹ቀርቾ! ሆጮን ጣጭ ማጮም መቱ ምናኑ ሁኩዕኑን። ");
INSERT INTO alw_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","መሰንትስ አት አፉሽቱዕናን ኣእታንቲሀለከ ዉጡዕነን ጭም አታንት እዲዳንቹ መንቹ እሁክ ደግ ዋጄምቤቺሃት› ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ሀለቅቹንኩ ‹ኩ ሂሉ ካዲንቹ! ገዉክ ጠወኦንት ጠዊን ፈረዳንኬ፤ አን አፉሽባንከ ቶጋሚሃለከ ዉጥባንከ ጭምአኣም እድዳንቹ መንቹ እሁእ ደጎንት! ");
INSERT INTO alw_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ህካን እኮች ምናነኤ ሚሃት ባንካን አፉሽቶንትበኢሁ? አንን አሜች ትርፊንከስን ኣኣም እቅ› ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ህከኒች ኤተሮን ሀለቅቹንኩ ህከኔ ኡርቶ መነ ‹ምናነስ ቶጌን ቶኑ ምናኑ ዮስሀኒሃ ኣስዬ› ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","እሰን ‹ቀርቾ! እሲሃ ቶኑ ምናኑ ዮስ!› ይቶስ። ");
INSERT INTO alw_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ሀለቅቹንኩ ‹አን ኩላንክዕኔ፤ ዮስሀኒሃ ጉዕሚንከ በርጌን ኣሴኖስ፤ እኮጎሬ ዮስበእሀኒች ሁኩ ዮሲንኩ ኣአመኖስ። ");
INSERT INTO alw_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ጠዉ እኮጎሬ አን ዎመ እሆተ እትትበ ህከ ዲነኤ ኢቤቹ ኤቤን እልኤ ለአን ሽዬ› ዬሰ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ኢስ ከ ምሳልተ ጠወዕዮች ኤተሮን ዬሩሳሌመ ኦሮአን ብርተ ዋል ሃመኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","እስን «ዘይት ሀቁ ነጰኖ ቆተተ» ዬኖቤቾን ሄዕዮ «ቤተ ፋጌለከ ቢታነ» ዬኖቤቹ ሆንጠኮ ወክት አሳባች ለሙሰ ");
INSERT INTO alw_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«ብሬክዕኔ ዮ ቀእተ መሬ፤ ህከቤቹንከ ኢልቴንተ ወክት አዪሁ ሆሮን ቆጶበእ ሀሩች ዎተረ ኡሱረሞሃ ደጌነንተ፤ ህካን ሂርቴን ከቤቹ ኤቤ። ");
INSERT INTO alw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","አዪሁ ‹ሚሃት ሂርቴነንታሁ?› ይ ጠዕሜህዕኔ ጎር ‹ቀርቹ ሀሾቤቺሃት› ይዬ» ይ ሶኮሰ። ");
INSERT INTO alw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","አሳበንት መርቶ ወክት ጉዕሙርቹንኩ ኢስ ኩሎሰገን እካን ደጎኡ። ");
INSERT INTO alw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","እሰ ዎተረ ሂርተን ዎተርስ አናከት «ዎተረ ሚሃት ሂርቴነንታሁ?» ይቶሰ። ");
INSERT INTO alw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","እሰን «ቀርቹ ሀሾቤቺሃት» ይት ፈንቀሽቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ህከኒች ኤተሮን ዎተራስ ኢስቤቹ ኤብ ኦድኑሰ ዎተር አሌን አት ኢሰ ቆጵሲሶኡ። ");
INSERT INTO alw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ኢስን ቆጵ ሃመን መኑ ኦድኑሰ ዎቃን ዌሳኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ኢስን ዘይት ሀቁ ነጰኖ ቆተ አዲን መሰኖ ዎቄን ዬሩሳሌመ ኢሎተ ሆንጠኮ ወክት አዎነን ሄዕዮ ልግቡ መኑ ሄጭት ለኦ አጀብሲሰኖ ጠወ ጉዕመንከ ሙንደአን ላገተ ጎት አት መገኑ ገለትጩ ጀመርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","እሰን «ቀርች ሱዕሚን አሜተኖ ዎሙ ማሰአሞእሃን፤ ወገሬቱ ሰማንለከ ኬዕምኙ መገኒሃ እሁን» ይታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","እኮጎሬ ህከን ኡመት በላን ሄኦ ፈርሳዌች መት-መቱሰ «አስተማርቾ! ኬሳሃ አዎንታ መነ ጨለ ይታገ ሻቅ!» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ኢስን «አን ኩላንክዕኔ፤ እሰ ጨለ ይቶጎሬ ኩ ክኑ ያረኖ» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ኢስን ዬሩሳሌም ከተመ ሆንጠክ ለዕዮ ወክት ከተንቾተስ ኦዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","«ወገሬት ኣሰኖ ጠወ ከበር ደጋንቲሃ እኮ እቃ ጡመሃን፤ ጠዉ እኮጎሬ ቴሱ እሌችክ ደጵይዮኡ። ");
INSERT INTO alw_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ዲኑክ ጉዕመ አዲን ድችረ ድችር ከን አዲንለከ ካጵ አዲን ረብ ፉሉ ከንታሄ ወክቱ አሜተኖ። ");
INSERT INTO alw_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ህትን መገኑ ጡምሶሄተ አሜቾ ወክት አጥራመትበቤቺሃ ዲኑክ ኬሳለከ እለክ ድጅታአ፤ ህትን ኣዜንከክ መቱ ክኑሁ መቶ ክን አሌን ፈቀኖበአ» ይ ኦዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ህከኒች ኤተሮን ኢስ ዱእ ምኒ ኣግ ነገደኖ መነ አብል ሸሬእ። ");
INSERT INTO alw_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ህትን እሰንተ « ‹ምኑኤ ዱአ አኤኖሃ ምኒ› የመም ከተበሞኡ፤ እኮጎሬ አዕኑ ሽፍጡ ማጠንታ ሻንቀ አቴንታአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","እስን ጉዕመ በርንከ መገን ምኔን ተማርሰኖት እቅ፤ ቂስ አወንሳኑት፥ ሕግ አስተማረትለከ መነ አዎንስታእሩ ኢሰ ሽቶተ ሀሳኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ጠዉ እኮጎሬ መኑ ጉዕሙንኩ ኢስ ጠወአኖ ጠወ ቀልቢን ሞጮጭታቤቺሃ እሰ መ አታጎር ደጎበአ። ");
INSERT INTO alw_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","መቱ በር ኢስ ዱአ አኤኖ ምኔን መነ ተማርሰንለከ ተሽት ላገተ ዱዱብሰን ቂስ አዎንሳኑት፥ ሕግ አስተማረትለከ ባድ ባልቀት ሜጡበ አሜት ");
INSERT INTO alw_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","«ህንዴ ኩልኔ፤ ካን አታንቲሁ መ ዎልቃኒት? ህከረንገ ካን አታንት ዎልቀተ ኣሴሄሁ አዬት?» ይት ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ኢስን «አን መቱ ጠወ ጠዕማንክዕኔ፤ ህንዴ ቴሱ ኩሌኤ፤ ");
INSERT INTO alw_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ያህይ ጠመቀኖ ዎልቀተ ደኤኢሁ መገን አዲኒትንዶ መን አዲኒት?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ህከ ወክት ገገዉንኩሰን « ‹መገን አዲኒት› ይኖም ጎር ‹ሚሃት ያህዪን አመዕንቴንታበአ?› የኖኔ፤ ");
INSERT INTO alw_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ጠዉ እኮጎሬ ‹መን አዲኒት› ይኖም ጎር መኑ ጉዕሙንኩ ያህይ ነብዬቹ እሁስ አመዕነኖቤቺሃ ክኒን ቀሳኔ» ይት ጠወኦኡ። ");
INSERT INTO alw_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ህካን እኮቤቺሃ «ሀከን አዲኒት ጎር ደንጎምበአ» ይት ፈንቀሽቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ኢስን እሰንተ «አን ካን አዬ ወልቃን አኣም ጎር ኩላንክዕኔበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ህከኒች ኤተሮን ኢስ መኒሃ «መቱ መንቹ ወይን ላሉተ ካሾ፤ ወይነስ ቀባንቺሃ ኣስ ዎሉ ባዱ ኦሮዕይ ልግብ ወክት ዱንኬእ። ");
INSERT INTO alw_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","እስን ወይኑስ ላለኖ ወክቱ እሌ ውክት ወይን ላልቺች እሲሃ ኢለኖ ወጥ ኣቶተ መቱ ካዲንቹ ቀባኖስቤቹ ሶኮ፤ ጠዉ እኮጎሬ ቀባኑስ ሶሀሞ ካዲንቹ ኦልት መቱርቹሃ ኣቱዕነ ሸርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ለንክ ወክት ዎሉ ካዲንቹ ሶኮ፤ ህትን እሰን ህከ ካዲንቹ ኦልትለከ ሙልስ መቱርቹሃ ኣቱዕነ ሸርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ህትን ሰቂሃ ሶኮ ወክት እሱንከ ኦልት ጡላይስ አብል ዋሽት ኡጅቶስ። ");
INSERT INTO alw_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ህከኒች ኤተሮን ወይንስ አኑ ‹መ አኡ? ኢታም ቤቱኤ ሶሃም፤ አይደጎ እሱ ከበጅታኢሃ እሀኖ› ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ጠዉ እኮጎሬ ቀባኑንት እሱ ለኦ ወክት መት-መቲንከሰ ‹ረገአኖሁ ከኒት፤ ዮስርቹ ኒሀ እሆተ እሱ ሽኖ› የቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","እሰን እሱ ወይን ኣዚች አብል ፉሽት ሽቶኡ፤ ቴሱ ወይንስ አኑ ህከ ቀባኑተ መ አአኖ? ");
INSERT INTO alw_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ወይንስ አኑ አሜች ህከ ቀባኑተ ሽ ኬዕይ ወይነስ ዎሎ መኒሃ ኣሰኖ» ይታ ምሳልተ ኩሎሰ። እሰን ህካን ሞጮጭቶ ወክት «ህትኔርቹ መገኑ ኤቡንከኔ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ጠዉ እኮጎሬ ኢስ እሰንተ ለዕይ «ህካን እኮች ‹ግንበኛኑት ህንቆ ክኑ እስ ሙረበ ቡዕል ክኑ እሀኖ› የመም ከተበሞሁ መ ለሊሰኖ? ");
INSERT INTO alw_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ህከን ክኖን ኡቦ አዪሁ ቁሽቁሽ የኖ፤ ጠዉ እኮጎሬ ሁኩ ክኑ አዬ አሌኒ ኡቦጎሬ ፍጭርቀኖስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ሕግ አስተማረትለከ ቂስ አዎንሳኑት ኢስ ህከን ምሳሌን እሳሃ ጠወኡስ ደግ ህከ ወክትንከ አፎስተ ሀሶኡ፤ ጠዉ እኮጎሬ መነ ዋጅቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ህትን ገሽ ወልቀትለከ ሹምነቱ ዮስ ገሻንቺሃ ህግስ ኣቶተ መከኖ ወክት ሀሳኢት እቅ፤ ህካን እኮቤቺሃ ፈየ መነ አጉደን ጠውንከስ ትርቲባ መነ ሶኮኡ። ");
INSERT INTO alw_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","እሰን ኢሰ «አስተማርቾ! ሀንቅ ጠወኣንትገለከ ሀንቅ ተማርስታንትገ መን እልተ ለእ ጎልቱዕነ ሀንቅ መገን ዎቃሃ ተማርስታንትገ ደንጋም። ");
INSERT INTO alw_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ሮም ዎሚሃ ግብር ባቱ ፈቀደሞእሃንዶ ፈቀደሞበእሃን?» ይት ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ጠው እኮጎሬ ኢስ ተንኩሰ ለዕይ ");
INSERT INTO alw_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«መቱ ዲናረ ለሊሼኤ፤ ከን ዲናር አሌን ዮ ፎቱትለከ ሱዕሙ አዬሃን?» ዬሰ፤ እሰን ቂሳርያ ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","እስን «ህካን እኮች ዎሚሃ ዎሚንከ ህትን መገኒሃ መገኒንከ ኣስዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ህካን እኮቤቺሃ እሰን እስ ጠወዕዮ ጠዊን መን ብሬን ትርቲቦስተ አታልቶበአ፤ እኮጎሬ እስ ፈንቀሼ ጠዊን አጀብሲጭት ጨለ ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ህከኒች ኤተሮን «ሬዮ መኑ ሬሆች ኬአኖበአ» ይት ተማርስተ «ሰዱቃውተ» ዬኖ መኒች መት-መቱ ኢስቤቹ አሜት ");
INSERT INTO alw_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«አስተማርቾ! ሙስ ‹መቱ መንቹ ጫተ ኤብ እለተ እሉዕነ ሬዮጎር መንችስ አመቤቱ ሬያን ጫስ ረገዕይ አመስ ቤቲሀ እለተ እሉን› ይ ሴራን ከተቦኔ። ");
INSERT INTO alw_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","መቱ ወክት ለመሉ አመኦሱት ሄኦ እቅ፤ እሳችን ሀንገፉስ ጫተ ኤብ እለተ እሉዕነ ሬዮ። ");
INSERT INTO alw_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ህትን አሌስ እለሞ አመስቤቱ ጫስ ረገዕዮ፤ ");
INSERT INTO alw_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","አሌስ እለሞ ሰቅ ማዕኑንኩ ረገዕዮ፤ ከን ሃሌን ለመሉንኩ አመኦሱት ረገእ እለተ እልቱዕነ ሬቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ጉዕሚችሰ ኤተሮን ህት ጫቲ ሬቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ህካን እኮቤቺሃ ለመሉንኩ ኣእቶሴቤቺሃ ሬቶሩ ሬሆች ኬኣ ወክት ህት ጫት ሀከኒሀስ እካአ?» ይት ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ኢስን እሳንከ «ከን ኣዱንያ አሌን ሄአኖ መኑ ኤባኢሁ፥ መእሲሳኢሁ። ");
INSERT INTO alw_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ጠዉ እኮጎሬ ሬሆች ኬኢሀለከ አሜተኖ ዘማኔን ሄኦተ ሀስሰኖሰሩ ኤበቅታበኢሁ፥ መእሲሳበኢሁ። ");
INSERT INTO alw_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","እሰን ሰሜ መላይከገ እካቤቺሃ ለንኪሃ ሬታበአ፤ ህትን እሰን ሬሆች ኬኦቤቺሃ መገንተ ኦሱ። ");
INSERT INTO alw_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ህትን ሙስ ቡባ ሽፎተኔሃ ከተቦሀኔን ቀርቹ ‹እብራሂምሃ መገኑ፥ ኢሳቅሃ መገኑለከ ያቁብሃ መገኑ› ይ ገእ ሬቶሩ ኬኣገ ለሊሾኡ። ");
INSERT INTO alw_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ህካን እኮች መገኑ ፎልን ሄዕዮ መኒሃ መገኑ ቤሉ ሬዮ መኒሃ መገኑበአ፤ መሰንትስ እሲን ጉዕሙንኩ ፎሊን ሄኣቤቺሃት» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ህትን ሕግ አስተማራች መት-መቱ ፈንቀሽት «አስተማርቾ! ጡመገ ጠወኦንት» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ህከኒች ኤተሮን እሰን ኢሰ መቱርቹሃ ጠዕምቶተ መለልቶበአ። ");
INSERT INTO alw_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ጠዉ እኮጎሬ ኢስ «እሰንተ ‹መሲሁ ደዉዴሃ ቤቱ› ዪ አታልቶኢሁ ሀትዪት? ");
INSERT INTO alw_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","መሰንትስ ዳዉድ ገዉንኩስ መዝሙር መጻፋን « ‹ቀርቹ ቀርቺሃኤ አን ዲነክ ሎከክ ኣዜን አኦተ ኢለ መኬኤ አዲን አፉዕል› ዬስ የኖ። ");
INSERT INTO alw_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ዳዉድ ‹ቀርቾ› ይ ገኤሲች መሲሁ ሀት እክ ቤቱስ እሀኖ?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ህትን መኑ ጉዕሙንኩ ሞጮጨን ኢስ አሳበስ ");
INSERT INTO alw_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«ቅራዕሩ ኦድኑተ ኦደእ ሃሙ፥ በነቻን ኬዕምኚን ጠዉሲሶኖሰተ፥ ጭምት ምናን ኬዕሚኝ ቦርጭማን አፉዕሉለከ ድግሰ ድግሴመ ቤቾን ኬዕሚኝ ቤቹ ኢትታ ሕግ አስተማራች አገርዕዬ። ");
INSERT INTO alw_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","እሰን አመሰልት መኑ ለኦሰተ ቅራርስት ዱአ አተን ምንሰ አኑ ሬዮ ሜንቱ ጣንስተን እታአ፤ ህካን እኮቤቺሃ እሳሃ አበ ፍርደ እሀኖሰ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ኢስ ሰደቀተ ቶጌኖ ሳጥናን ቀባጣመት ብረ ዎርተን እልስ አሌ ዋሽ ለአኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ህትን ምንሴ አኑ ሬዮ ቡጥቹት መንቹት ለም ቀቅቻኑተ ሳንትበተ ወርተን ለዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","እስን «ሀንቅንከ ያንክዕኔ፤ ት ምንሴ አኑ ሬዮ ቡጥቹት መንቹት ጉዕሚችሰን አበ ኣቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","መሰንትስ እሰ ጉዕሙንኩሰ ኣቶኢሁ ዮሰ ዱንያች በተዕዮሳሃት፤ ጠዉ እኮጎሬ እሴ ቡጥማንከሴ ሄኦተ ደግለለኖሴሃ ዮሴሃ ጉዕመንከ ኣቶኡ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","መት-መቱ መኑ መገን ምኑ ተሽ የኖ ክኒንለከ መገኒሃ ኣሴመ ኣስቶን መክሴናን ተሽ የኖሃ እሁስ ጠወኣኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ኢስን «ኩ ለኤነንተ ክኑ መቶ ክን አሌን እክ ፈቁዕነ ድረሸመኖ በሩ አሜተኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ህከኒች ኤተሮን እሰን «አስተማርቾ! ኩ ጠዉ እሀኖሁ መ በርሃት? ህትን ኩ ጠዉ እሆተ ሆንጠሁስ ደንጋም መላስ መርቹሃን?» ይት ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ኢስን «አዪሁ ሉስሰኖህዕኔበእገ አገርዕዬ፤ መሰንትስ ልግቡ መኑ ‹አን መሲሁት› ይተንለከ ‹ወክቱ ኢልዮኡ› ይተን ሱዕሚንከኤ አሜታአ፤ እኮጎሬ እሰንተ አዎንቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ህትን ኦለለከ ተንበከሰ ሞጮጭቴንተ ወክት ህልቆኖቼ፤ መሰንትስ ሁኩን ሄጭ እሁ ሀስሰኖስ፤ ጠዉ እኮጎሬ መጨረሹ ደዕል እሀኖበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ህከኒች ኤተሮን ኢስ እሳሃ «ኡመቱ ኡመት አሌን ዎሙ ዎም አሌን ኬአኖ። ");
INSERT INTO alw_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ህትን አቡ ኡለ ሌንቄቁ፥ ቤቾን ቤቾን ጎሩለከ ዌረሩ እሀኖ፤ ህትን ዋጅሲሰኖርቹለከ አቡ መላት ሰማን ለልታአ። ");
INSERT INTO alw_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ጠዉ እኮጎሬ ህከን ጠዊች ጉዕሚችን ሄጭ ክዕኔተ መኑ አፈኖለከ ሸረኖ፤ ህትን ጭምት ምኒለከ ኡሱር ምኒ ህግስ ኣስታህዕኔ፤ ህትን ሱዕምኤተኔሃ ዳኛኖለከ ገሻኖ ብርተ ኤባህዕኔ። ");
INSERT INTO alw_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ህከ ወክትንከ አዕኑ እሳሃ መሰከርቶኖተ መከኖ ወክት እሀኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ሄጭቴንን ‹መ ይን ፈንቀሽናም› ይቴን ጠዊሀስ ቀልቤክዕኔ ሸዞኖቼ። ");
INSERT INTO alw_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","መሰንትስ አን ዲንችክዕኔ አዪሁ አታሎተ ህከረንገ ሀምበዕለሞተ አታልበ ላገተለከ ሀይመተ ኣሳንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ሆሮን አናከክዕኔ፥ አመክዕኔ ኦሱት፥ እሉክዕኔለከ ጃለክዕኔ ፈቁዕነ ህግስ ኣስታህዕኔ፤ ህትን እሰን ክዕኔች መቱ-መቱክዕኔ ሽታአ። ");
INSERT INTO alw_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ህትን ሱዕምኤተኔሃ ጉዕማንከ መንቤቾን ግበንቴንታእረ እኬነንተ። ");
INSERT INTO alw_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ጠው እኮጎሬ ቡዕልክዕኔ ሙሚች ሜጥት በኣበአ። ");
INSERT INTO alw_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ህካን አታዕሊን ፎልክዕኔ ጡምሴነንተ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ኢስ «ዬሩሳሌመ ወታደሩ ረብ አፋን ለኤንተ ወክት በኢሃ ሆንጠሁስ ደጌ። ");
INSERT INTO alw_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ህከ ወክት ይሁድ ባዶን ሄዕዮ መኑ ቆተተ ዋል ዞሁን፤ ህትን ዬሩሳሌም ከተም ኣዜን ሄኦእሩ ህከን አዲች ፉልቱን፤ ህትን ከተሚች አብል ባዶን ሄኦእሩ ከተም ኣዝ ኣጉንከ። ");
INSERT INTO alw_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","መሰንትስ ከተበሞርቹ ጉዕሙንኩ ዊሞተ ኩን ገዱተ ፉልሃ ወክት። ");
INSERT INTO alw_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ህከ ወክት ላፈ ሜንቲሀለከ ቀንስታ ሜንቲሃ ቆሀኖህዕኔ፤ መሰንትስ አቡ ኦርሸት ኣዱንያ አሌን እካአ፤ ህትን መገን ኡሙዕርት ከን ኡመት አሌን አሜታአ። ");
INSERT INTO alw_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","እሳችን መት-መቱሰ ሲፊን ጎረጠንታአ፤ ህትን ዎሉሰ አገንት ኡመት ቤቹ ጉዕመንከ መርታአ፤ ህትን አይሁዳ እህቡ መኑ ወክቱስ ኢሎተ ኢለ ዬሩሳሌማን ተንበከሳአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ኢስ «አሮን፥ አገንቾንለከ ቤዜን መላት ለልታአ፤ ህትን ኣዱንያ አሌን ሄዕዮ መኑ ባርለከ ዊ ሁል ዋጅሲሰኖ ላጋች ኬዕዮሀኒን ዋጅት ጨነቀንታአ። ");
INSERT INTO alw_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ሰማንዮርቹ ሌንቄቀኖ ቤቺሃ መኑ ዋጅት ኣዱንያ አል አሜተኖርቹ አገዕርተን ቀልብሰ ሉሳአ። ");
INSERT INTO alw_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ህከ ወክት እሰን መንች ቤቱ ወልቃንለከ ሎረ ኬዕሚኚን ጎመ ኣዚን አሜተን ለኣአ። ");
INSERT INTO alw_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ኩ ጠው ጉዕሙንኩ እሆተ ጀመሮ ወክት ጡሙኔ ሆንጠኮቤቺሃ አሌ ዋሽቴን ለዕዬ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ህከኒች ኤተሮን ኢስ መት ምሳልተ እሳንከ «ኦድ ሀቁቹተለከ ዎሉ ጉዕመንከ ሀቀ ቀልቢን ለዕዬ። ");
INSERT INTO alw_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ሁኩ ሀቁንኩ ለቾገ ለኤነንተ ወክት ሀጎ ሆንጠሁስ ገውንኩክዕኔ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ህትን ኩ ጉዕሙንኩ ጠዉ እሀን ለኤንተ ወክት መገን ዎምነቱ ሆንጠሁስ ደጌ። ");
INSERT INTO alw_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","«ሀንቅንከ ያንክዕኔ፤ ኩ ጉዕሙንኩ ጠው እሆተ ኢለ ከን ዘማን መኑ ህገኖበአ። ");
INSERT INTO alw_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ሰሞለከ ኡለት ህጋአ፤ ጠው እኮጎሬ ላገኤ ሆሮን ህጋበአ።» ");
INSERT INTO alw_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ወክቲሀስ «ደግለልበርቹ እቲን፥ ሰከሪንለከ ከን ኣዱንያ አል ጠው ሻዞን ቀልቡክዕኔ ሆግበገ ሁኩ በሩ ድንገቴን ወሻድገ አሌክዕኔ አሜች አፍበህዕኔገ ገዉክዕኔ አገዕርዬ። ");
INSERT INTO alw_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","መሰንትስ ሁኩ በሩ ኣዱንያ አሌን ጉዕማንን ሄአኖ መንቤቹ አሜተኖ። ");
INSERT INTO alw_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ህካን እኮቤቺሃ ከን አሜተኖ ጠዊች ጉዕሚችን ጡምቴነንተ ዎልቀተ ደእቶኖተለከ መንች ቤት ብሬን ኡሩ አታልቶኖተ ዱአ አቴነን ጉዕመ ወክትንከ ጠረኝዬ» ይ ኩሎ። ");
INSERT INTO alw_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ኢስን መገን ምኔን ጉዕመ በርንከ ተማርሰን ኡለት ሀዎርታ ወክት ዘይት ሀቁ ነጰኖ ቆተተ ፉለን ገለኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ህትን መኑ ጉዕሙንኩ መገን ምኔን እሲች ሞጮጮተ ገስመ ሱጵተ እስቤቹ አሜተኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ራጭቱ ዮበኢሃ ጨሊሰሞ ጦሮሹ እቴነን ከበጄኖ ከበጃቱ ሆንጠኮ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ህከ ወክት ቂስ አዎንሳኑትለከ ሕግ አስተማረት መነ ዋጅቶቤቺሃ ኢሰ ሀት አት ሽታጎር ዎቃ ሀሳኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ህከኒች ኤተሮን ቶና ለሞንከ አሳባች መቶንከስ «አስቆሮንቶ» ዬኖ ይሁዳን ሼይጣኑ ኣጎ። ");
INSERT INTO alw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","እስን ኦሮዕይ ቂስ አዎንሳኖንለከ ዱእ ምኒ አገርታ ወታደር አዛዣን ኢሰ እሳንከ ህግሽ ኣሰኖ ዎቃሃ አማዕለሞ። ");
INSERT INTO alw_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","እሰን ሙንደእ ብረ ኣቶተ ዉለ ኡርሶኡ። ");
INSERT INTO alw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ህካን እኮቤቺሃ እስን ዉላንከስ አማዕለም መኑ ዮበእቤቾን ኢሰ እሳሃ ህግሽ ኣሶተ መከኖ ወክት ሀሰኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ህከኒች ኤተሮን ሻሽግ ሆልቹ ዱሌን ራጭቱ ዮበኢሃ ጨሊሰሞ ጦሮሹ እቴነን ከበጄኖ ከበጀ በሩ ሆንጠኮ። ");
INSERT INTO alw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ህካን እኮቤቺሃ ኢስ ጴጥሮሴለከ ያህይ «መርቴን ሻሽግ ሁርባት እንቶተ ተቃጠቤ» ይ ሶኮ። ");
INSERT INTO alw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","እሰን «ህካን ሀከንቤቾን ተቃጠንቦሄተ ሀሰን?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","እስን «ከተመ ኣጌንተ ወክት ዊ ምዳኑተ እጄ መንቺን ደቀንቴነንተ፤ እስን ኣገኖ ምኒ አዎንቴን መርቴን ");
INSERT INTO alw_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ምንስ አኒንከ ‹አስተማርቹ አሳባንን ሻሽግ ሁርባት እታም ኮሁ ገለኖቤቹ ሀከንቤቾንት? የኖሄት› ይቴን ኩሌስ። ");
INSERT INTO alw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","እስን ሀስሰኖርቹ ጉዕሙንኩ ተቃጠቦ ፉቅ ምኔን አልባዕሉ ቤቹ ለሊሰኖህዕኔ፤ ህከን ቤቾን ቅጥአዕዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","እሰን መርት ጉዕሙርቹንኩ ኢስ ጠወዕዮሰገን እካን ህከን ቤቾን ሻሽግ ሁርባት ቅጥአቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ሁርባት ወክቱ እሌሃን ኢስ አሳባንን ሜጡበ ማዳን አፉዕሌእ። ");
INSERT INTO alw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","እስን እሳሃ «ኦርጨቀማምሀኒች ሄጭ ከ ሻሽግ ሁርባት ክዕኔኤን ሜጡበ እቶተ አበ ሄዕላቾም እቅ። ");
INSERT INTO alw_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","መሰንትስ መገን ዎምነቴን ሻሽግ ሁርባት ለልዮበእ ምስጥሩ ለሎተ ኢለ አን ከ ሻሽግ ሁርባት ሆሮን እታምበእገ ኩላንክዕኔ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ህትን ኢስ ኩባያ ኬሽ መገኑ ገለትጭ «ከን ጠበቴን ዮኢሀ ኣእቴን ቤቀሜ። ");
INSERT INTO alw_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","አን ከን ወክቲች ኬሽ መገን ዎምነቱ አሜቶተ ኢለ ወይን ላልቺች ጩንሼማሃ ሆሮን አጋምበእገ ኩላንክዕኔ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ህከኒች ኤተሮን ኢስ ዳቡተ ኬሽ መገኑ ገለትጬእ፤ ህካንን ቢጭ እሳንከ ኣስ «ኩን ክዕኔሃ ኣሰሞሃ ማላእ፤ ካን ኤሳሃ ቃጎኖተ አዕዬ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ህትን ሁርባቲች ኤተሮን ጠበቴሃ ኬሽ አሌ ዋሽ «ኩ ጠበቴሁ ክዕኔኤሃ ዱንተአኖ ቄጊንከኤ እሀኖ ሃዕሮሃ ወኣድ። ");
INSERT INTO alw_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«ጠዉ እኮጎሬ ከለዕዬ፤ ኤሳሃ ህግሽ ኣሰኖኤሀን አንገስ ኢን ሜጡበ ማዳን ዮኡ። ");
INSERT INTO alw_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","መንች ቤቱ እስተኔሃ ሄጭ ቀደሮስገን ሬሀኖ፤ እኮጎሬ ህግሽ ኣሰኖ መንቺሃ ቆሀኖስ!» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ህካን ገገዉንኩሰን «ካን አአኖሁ ኒ በላን አዬት?» ይተን መት-መቱሰ ጠዕሙ ጀመርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ህትን አሳበስ «ኒ በላን ጉዕሚችኔን ሎሩ አዬት?» ይተን ኦደተ ጀመርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ህካን እኮቤቺሃ ኢስ እሰተ «ኡመት ዎመት መነሰ ገዘኣአ፤ ህከ ገዘኣ ዎመንተ ‹ጡመ ጠወ አቶኡ› ዬን ገኤኖሰ። ");
INSERT INTO alw_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","እኮጎሬ አዕኑ ህት እኮኖቼ፤ ህከን ወጥ ክዕኔ በላን ሎረ እኮሁ ቀዉ እሁን፤ ህትን አዎንሳንቹ እኮሁ ካዲንቹ እሁን። ");
INSERT INTO alw_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ማዳን አፉዕል እተኖሀኒችለከ ኡር ካደመኖሀኒች በተአኖሁ አዬት? በተአኖሲሁ ማዳን አፉዕሌሃበእንዶ? ጠዉ እኮጎሬ አን በላንከክኔ ካዲንችጋት። ");
INSERT INTO alw_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ህትን አዕኑ ኢን ሜጡበ ኦርሸኤ ወክት ጉዕመንከ ሄኤንታእራን። ");
INSERT INTO alw_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ህካን እኮቤቺሃ አኑኤ ኤሳሃ ዳኛ አዕዮኤገን አኒሁ ክዕኔተ ዳኛኑተ አዕይ ሾማንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ጄነቴንከኤ ኢ ማዲች እቶኖተለከ አጎኖተ ህትን ቶና ለሞንከ እስራኤል ደቦን ፈረዶኖተ ዎመ ቦርጭማን አፉዕልቴነንተ ዳኝነቱ ኣሳንክዕኔ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ኢስን «ስሞኔ! ስሞኔ! ገበሬቹ አለሱ ጋቢች አደ አዕይ ጠለሸኖሀንገን ሼይጣኑ ክዕኔተ ጠለሾህዕኔተ ጠረኝሽ ሀሾ። ");
INSERT INTO alw_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","እኮጎሬ አን አመዕነቱክ በእበገ ኬሳሃ ዱአ አኣም፤ ህካን እኮቤቺሃ አት ቶበት ፈንቀልቶንት ወክት አመክ ኦሱተ ጠረኝስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","እስን ኢሰ «ቀርቾ! ኪን ሜጡበ ኡሱረሞተለከ ሬሆተ ተቃጠቦም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ኢስን «ጴጥሮሴ! አን ያንኬ፤ ከበር ሀንጠቦ ዎዶተ ኢለ ‹ደጋንስበአ› ይት ሰሶረ ለገኣንቴኤ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ህከኒች ኤተሮን ኢስ አሳበስ «ከረጢትት፥ ሆቆማዱለከ ጫዕመት ሄኡዕነ ሶኮንክዕኔ ወክት ሆፈዮዕኔሩ ሄዕዮእቅንዶ?» ዬሰ። እሰን «መቱርቹሁ ሆፈዕዮኔበአ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","እስን «ቴሱ ከረጢትትለከ ሆቆማዱ ዮሲሁ አፉን፤ ህትን ብሱ ዮስበኢሁ ኦድኑስ ህር መቱ ብሰ ህዕሩን። ");
INSERT INTO alw_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ህካን እኮቤቺሃ ‹ሂለ መኒን ወለአሞ› የመም ከተበሞሁ ኢ አሌን ዊሙ ሀስሰኖ እሁስ ኩላንክዕኔ፤ መሰንትስ ኢተኔ ከተበሞ ጠዉ ጉዕሙንኩ ዊመኖቤቺሃት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ህትን አሳበስ «ቀርቾ! ከለእ፤ ለሙ ብሱ ከበ ዮኡ» ይቶኡ፤ እስን «እሀኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ኢስ ከተሚች ፉል ወዕና ሮሾገን ዘይት ሀቁ ነጰኖ ቆተተ ኦሮዕዮ፤ ህትን አሳበስ እሱ አዎንቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","እስን ቤቹስ ኢሌ ወክት እሳንከ «ፌተናን ኣጌንበገ ዱአ አዕዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ህከኒች ኤተሮን ክኑ ቶሬን እልሴኖ ቤች ጌሰ እሳች ቄዕር ጉሉጵ ");
INSERT INTO alw_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«ኢ አነ! አት ሀሶንት ጎሬ ከ ኦርሸ ጠበቴሃ ኢች ቄርስ፤ ጠዉ እኮጎሬ አን ሀሳምገ እሁዕነ አት ሀሳንትገ እሁን» ይ ዱአ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ኢስን ኣዜስ አበ ሻዥ ጠረኝ ዱአ አዕዮ፤ ");
INSERT INTO alw_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ሁንኩ ቄግገ ኡላን ዛዘኖት እቅ፤ ህከ ወክት መገን መላይኬቹ ሰሜች አሜች እሱ ጠረኝሰን ህከን ቤቾን እስሃ ለሌስ። ");
INSERT INTO alw_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ህትን ዱአ አአኖቤቺች ኬዕይ አሳበስበ አሜቾ ወክት አበ ሻዞቤቺሃ ግሳን ደጎሰ። ");
INSERT INTO alw_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","እስን እሰንተ «ሚሃት ግሴነንታሁ? ፌተናን ኣጌነንተበእገ ኬኤን ዱአ አዕዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ኢስ ጠወአን ሄዕዮገን ቶና ለሞንከ አሳባች መቱስ «ይሁደ» ዬኖሁ አዎንሴሃን ልግቡ መኑ ህከ ቤቹ አሜቶኡ፤ ይሁድን ሱንቆተ ኢስቤቹ ሆንጠኮ። ");
INSERT INTO alw_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ጠዉ እኮጎሬ ኢስ «ይሁደ! መንች ቤቱ ሱንቅት ህግስ ኣተንንዶ?» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","እስ አሳበት እሀኖ ጠወ ለኦ ወክት «ቀርቾ! ብሲን ዎቀርኑንሰንዶ?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ህትን እሳችን መቱስ ቂስ አዎንሳንች ካዲንቹ ዎቀር መኬ አድ መጨተ ሙሮ። ");
INSERT INTO alw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ጠዉ እኮጎሬ ኢስ «ካን አቶት!» ይ መንችስ መጨተ አፍ ፈይሾስ። ");
INSERT INTO alw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ህከኒች ኤተሮን ኢስ ህከ አፎስተ አሜቶ ቂስ አዎንሳኑተ፥ ዱእ ምኒ አገርታ ገሻኑተለከ ባድ ባልቀተ «ቆጥ ሽፍጠ አፌኖሀንገ ብሰለከ በርተ አፌን አሜቴንንዶ? ");
INSERT INTO alw_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","አን መገን ምኔን ጉዕመ በርንከ ክዕኔን ሜጡበ ሄዕዮም ወክት አፌንታኤበአ እቅ፤ ጠዉ እኮጎሬ ኩ ወክቱ ክዕኔሃለከ ቱንስች ሹምነቱ ዮስሀንሃን» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ህከኒች ኤተሮን ሁኩ መኑ ኢሰ አፍ ቂስ አዎንሳኖ ምኒ አዎንስት ኤቦኡ፤ ጴጥሮስን ቄዕራሻን ሃመን አዎነኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ህትን እሰን ግቤ በላን ጊረተ ቡስተን ሜጡበ አፉዕልቶ ወክት ጴጥሮስ አሜች በለሰ አፉዕሌእ። ");
INSERT INTO alw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","እስን ለለኖ አዲን አፉልዮሀኒን መት ገረድቹት ቱክ ይት ለእ «ኩ መንቹ ኢሲን ሜጡበ ሄዕዮ እቅ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ጠው እኮጎሬ ጴጥሮስ «ቴ መንቾ! አን እሱ ደጋምበአ» ይ ለገዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ህትን ቀዉ ጌሰ አገር ዎሉ መንቹ እሱ ለዕይ «አት እሳች መቶሃስ» ዬእ፤ ጠው እኮጎሬ ጴጥሮስ «ኮ መንቾ አኔበአ!» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ህትን መቶ ሳኣት ጌሰ አገሮች ኤተሮን ዎሉ መንቹ «ኩ መንቹ ገሊል ባድ መንቹ እኮቤቺሃ ሀንቅንከ እሲን ሜጡበ ሄዕዮ እቅ» ይ ጠራኝሽ ጠወዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ጠው እኮጎሬ ጴጥሮስ «ኮ መንቾ አት ይታንቲሃ አን ደጋንስበአ» ዬእ፤ ህከ ወክት እስ ጠወአንን ሀንጠቦ ዎጆ። ");
INSERT INTO alw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ኢስን ኤተሩ ፈንቀል ጴጥሮሴ ለዕዮ፤ ጴጥሮስን «ከበር ሀንጠቦ ዎዶተ ኢለ ሰሶራ ለገኣንቴኤ» ዬስ ቀርች ላገተ ሰውዬእ። ");
INSERT INTO alw_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ህካን እኮቤቺሃ አብል ፉል ቡብ ኦዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ህከ ወክት ኢሰ አፎ መኑ ህንቃሲትለከ ዎቀርታሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ህትን እልስ ጉንጉሽት ዎቀርተን «ዎቀሮሄሁ አዬት? ህንዴ ደግ» ይተን ጠዕምታሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","እሰን ዎሉ ልግብ ጠወ ጠወአን ቦሮርታሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ኡለት ሶዞ ወክት ባድ ባልቁ፥ ቂስ አዎንሳኑትለከ ሕግ አስተማረት ጭምይት ኢሰ ኦገትሰቤቹ መስቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","እሰን «አት መሲህ እኮንትጎሬ ኩልኔ» ይቶኡ፤ ጠው እኮጎሬ እስ «ኩሎንክዕኔ ጎሬ አመዕንቴነንተኤበአ። ");
INSERT INTO alw_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ህትን አን ጠዕሜንክዕኔ ጎሬ ፈንቀሽቴነንተበአ። ");
INSERT INTO alw_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ጠው እኮጎሬ ቴሶች ጀመር መንች ቤቱ ዎልቀት ዮሲ መገን መኬ አዲን አፉዕለኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","እሰን ጉዕሙንከሰ «ህካን እኮች አት መገንየ ቤቱንዶ?» ይቶኡ፤ እስን «ኤ አዕኑ ይቴንተጋንት» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ህካን እኮቤቺሃ እሰን «ነኡ ገዉንኩኔ ገይስ አፌች ሞጮጭኖምቤቺሃ ዎሉ ምስክር ሚሃት ሀንሳሚሁ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ህከኒች ኤተሮን ሁኩ ኦገቾ መኑ ጉዕሙንኩ ሜጡበ እክ ኢሰ ጵለጦሴቤቹ ኤቦኡ። ");
INSERT INTO alw_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","እሰን «ኩ መንቹ መነኔ ሉሲሰን፥ ሮም ዎሚሃ ግብር ባታበእገ ከመንለከ ‹አን ዎመ መሲህት› የን ደንጎንስ» ይተን ኦደሙ ጀመርቶስ። ");
INSERT INTO alw_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ጵላጦስን «አት ይሁድሃ ዎመንዶ?» ይ ጠዕሜስ፤ ኢስን «አት ይቶንትጋንት» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ህከኒች ኤተሮን ጵላጦስ ቂስ አዎንሳኖተለከ ህከን ልግቤ መኒሃ «ከን መንቾን መቱ ቤሱሃ ደጎምበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ጠው እኮጎሬ እሰን «ገሊላች ኬሽ ከኣጰ ኢለ ይሁድ ባዶን ጉዕማንን ተማርሰን ጨንጨነተ ኬሰኖት» ይተን ጠረኝስ ጠወኦኡ። ");
INSERT INTO alw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ጵላጦስን «ገሊለተ» ይተን ሞጮጬ ወክት «ገሊለ ባድሃ መንቹንዶ?» ይ ጠዕሜእ። ");
INSERT INTO alw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","እስን ኢስ ሄሮድስ ገሸኖ ባዲሃ እሁስ ደጎ ወክት ኢሰ ሄሮድሴቤቹ ሶኮ፤ ሄሮድስ ህከ ወክት ዬሩሳሌማን ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ሄሮድስን ኢሰ ለዕዮ ወክት አበ ሙንደዕዮ፤ መሰንትስ እስተኔ ልግብ ጠወ ሞጮጭ ለኦስተ ልግብ ወክት ሄዕላተኖት እቅ፤ ህትን አጀብሲሰኖ ጠወ አአን ለኦተ ተብሳሃ አአኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ህካን እኮቤቺሃ ሄሮድስ ኢሰ ልግብ ጠወ ጠዕሜስ፤ እኮጎሬ ኢስ መቱርቹሃ ፈንቀሽዮበአ። ");
INSERT INTO alw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ህትን ቂስ አዎንሳኑትለከ ሕግ አስተማረት ህከኔ ኡርት ጠረኝስ ኦዳሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ህትን ሄሮድስ ወታደሪንከስን ሜጡበ ህንቆስ፤ ህከኒች ኤተሮን ቀለደን በለቃ ኦድኑተ ኦዲሽ ጵላጦሴቤቹ ፈንቀሽ ሶኮ። ");
INSERT INTO alw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ህከ በር ጵላጦስለከ ሄሮድስ ጃለተ እኮኡ፤ ህከኒች ብርተ ለሙንኩሰ ብታን ሄኦ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ህከኒች ኤተሮን ጵላጦስ ቂስ አዎንሳኑተ፥ ደኛኑተለከ ኡመት ሜጡበ ገኤእ ");
INSERT INTO alw_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","« ‹ኦመት አሌን ብተተ ኬሰኖ› ይቴን ከ መንቹ ኢቤቹ ኤቤንታአ፤ አንን ህትን አዕኑ ለኤነን መረመርስ ሆንጠህሴንተ ክሲች ጉዕሚችን ከን መንች አሌን መቱ ቤሱሃ ደጎምበአ። ");
INSERT INTO alw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ህትን ሄሮድስ መቱ ብድልሃ ደጉ ሆጎቤቺሃ ኒቤቹ ፈንቀሽ ሶኮስ፤ ከለዕዬ ሬሆተ ኢልሰኖስ መቱርቹሃ አዕዮበአ። ");
INSERT INTO alw_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ህካን እኮቤቺሃ አን እሱ ገረፍ ገፈራም» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ዘማን ዘማኔን ጵላጦስ ኡሱረኚች መቱ መንቹ ሂር ገፈሩ ግዳስ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ጠዉ እኮጎሬ እሰ ጉዕሙንኩሰ ሜጡበ እክ «ከ መንቹ ሽ! ባርባኔ ሂር!» ይተን ጨንጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ባርባን ከተም ኣዜን ጨንጨነተ ኬሰንለከ መነ ሸን ኡሱር ምኔን ኡሱረሞእሃ መንቹ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ጵላጦስን ኢሰ ሂር ገፈሮስተ ሀሽ ለንኪሃ መኒሃ ጠወዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ጠዉ እኮጎሬ እሰን «እሱ ሰቀል! እሱ ሰቀል!» ይተን ጨንጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ሰቅ ወክት ጵላጦስ «ኩ መንቹ ሆሮን አዕዮ ጠዉ መርቹሃን? አን ሬሆተ ኢልሰኖስርቹ ደጎምበአ፤ ህካን እኮቤቺሃ ገረፍ ገፈራንስ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ጠዉ እኮጎሬ እሰ ላገሰ ጎት አት ሰቀል! ይተን ያርቶኡ፤ ኡመቲሁለከ ቂሰ አዎንሳኖ ላገንት በተኦኡ። ");
INSERT INTO alw_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ህከን መሳን ጠዕምቶ ጠዉ እሆሰተ ጵላጦስ ፈረጆ። ");
INSERT INTO alw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","እስን እሰ ጠዕምቶገን ህከ ርብሸተ አስለከ መነ ሺ ኡሱር ምኔን ኡሱረሞ መንቹ ሂር ገፈሮ፤ ጠዉ እኮጎሬ ኢሰ ተሽ የኖሰገ አቶተ ህግሽ ኣሴሰ። ");
INSERT INTO alw_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ህከኒች ኤተሮን እሰን ኢሰ መስተን ሄኦገን ገጠሪች ከተመ አሜተኖት እቅ፤ «ስሞኔ» ዬኖ ቀሬን ባድ መንቹ አንገስ አፍ መስቀለ እጅሲስ ኢሰ አዎነኖገ አቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ልግቡ ኡመቱ «ኣዬ! ኣዬ!» ይተን እሰ በላንን ወዘነሰ ዎቀርተን ኦኣ ሜንቱ ኢሰ አዎንታሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ጠዉ እኮጎሬ ኢስ እሰ አደ ፈንቀል «ዬሩሳሌም ሜንቶ! ኤሳሃ ኦኦኖቼ፤ እኮጎሬ ክዕኔሃ ገይሀክዕኔለከ እላተክዕኔ ኦዕዬ። ");
INSERT INTO alw_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","መሰንትስ ‹እልትበሩ፥ እልበ ጎደቡለከ ቀንስበ ኡኑኑ ማሰአሞእሃ› ዬኖ ወክቱ አሜተኖት። ");
INSERT INTO alw_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ህከ ወክት መኑ ቆተተ ‹አሌኔ ኡቤ!› ህትን ቆሩንተ ‹ማጬኔ› የኖ። ");
INSERT INTO alw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","እሰን ሙጠ ሀቅ አሌን ህካን አኤማሃ እኮች ሞሎ ሀቅ አሌን መ አኤኖሃ እሆታት?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ህትን ጩብ አቶ ዎሉ ለም መናከተ ኢሲን ሜጡበ ሽቶተ መስቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","እሰን «ቡዕል ቁላ» ዬኖቤቹ ኢልቶ ወክት ህከን ቤቾን ኢሰ ሰቀልቶኡ፤ ህትን ጩብ አዕዮሃ መቱስ መኬ አዲን ዎሉስ ጉረስ አዲን ሰቀልቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ኢስን «ኢ አነ! እሰ አታርቹ ደጋበእቤቺሃ መረርሲጭሰ» ዬእ፤ እሰን ኦድኑስ እጠ ኡጅት ቤቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ህትን ኡመቱ ኡር ለአኖት እቅ፤ ጠዉ እኮጎሬ ዳኛኑት «ዎሉ መነ ፌሾኡ፤ መጠረሞ መገን መሲህ እኮጎሬ ህንዴ ገዉስ ፌሱን!» ይተን ቀለዳሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ህትን ዎታደሩ እስቤቹ ሆንጠክ ሆለጮ ዎይነ ቦበጤማሃ ኣትስ ");
INSERT INTO alw_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","«አት አይሁድ ዎመ እኮንትጎሬ ገዉክ ፌስ!» ይተን ቀለዳሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ህትን «ኩን አይሁድያ ዎመ» ዬን ከተቤማሁ ቡዕልስ አሌ አዲን ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ሂለርቹ አታን ሰቀሌመሀኑኡች መቱስ «አት መሲህ በእንዶ? ህንዴ ገዉክለከ ኔሳሃ ፌስ» የን ቦሮሮስ። ");
INSERT INTO alw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ጠዉ እኮጎሬ ዎሉስ «አቲሁ መቴ ሬሆ ፍርድ ኣዜን ሄኦንትገን መገኑ ዋጅታንትበእንዶ? ");
INSERT INTO alw_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ነኡዕኑ ሆጎኔተኔሃ ሀስሰኖኔ ፍርደ ኣእናምቤቺሃ ኒሁ ሀንቅሃ ፍርደ፤ እኮጎሬ ኩ መንቹ መቱ ሂለርቹ አዕዮበአ» ይ ኡሙዕሬስ። ");
INSERT INTO alw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ህትን «ኢሰ! አሜትክ ወክት ኪ ዎምነቴን ቃጌኤ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ኢስን «ሀንቅንከ ያንኬ፤ ከበር ኢን ሜጡበ ጄነቴን እካንት» ዬስ። ");
INSERT INTO alw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ሌሆ ሰኣት ጌሰ እኮች አሩ ቱንስሻን ኡለ አሌን ጉዕማንን ሆንሱ ሰኣት ኢለ ቱንስቹ እኮ፤ ");
INSERT INTO alw_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ህከ ወክት ዱእ ምኒ መጋረጁ ቅጡ ለሙ ቤቹ እክ ፊልተዕዩ። ");
INSERT INTO alw_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ኢስ ሎረ ላጋን ያር «ኢ አነ! ነብሴቹኤ አንጋተክ ኤገተ ኣሳም!» ዬእ፤ ህካን ዬች ኤተሮን ሬዮ። ");
INSERT INTO alw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ጥቤ ሀለቅቹ ህከ እኮ ጠወ ለዕዮ ወክት «ሀንቅንከ ኩ መንቹ ፈየሃ እቅ» ይ መገኑ ሎርሴእ። ");
INSERT INTO alw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ህካን ለኦተ ጭምይቶ መኑ ጉዕሙንኩ እኮ ጠወ ለኦ ወክት ሻዝ ዎዘነሰ ዎቀርተን ምነሰ ፈንቀልቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ጠዉ እኮጎሬ ኢስን ኤንኬዕነንተ መኑ ጉዕሙንኩ፥ ገሊላች እሱ አዎንታሲት እቅ፤ ሜንቱሁ ቄዕራሻን ኡርት ህከ ጠወ ለኣኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","«አርማትየ» ዬኖ አይሁድ ከተማን ሄአኖ «ዩሱፈ» ዬኖ መንቹ ሄዕዮ እቅ፤ እስን ፈያለከ ጡመሃ መንቹ እቅ፤ ህትን እስን ኦገት ዳኛኖች መቶሃስ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","እኮጎሬ አማሌንከሰለከ ሆጎንከሰ ኢተቀሞበአ እቅ፤ ህትን መገን ዎምነቱ ተብሴን አገረኖሃ መንቹ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ሁኩ መንቹንኩ ጵላጦሴቤቹ መርኬዕይ ኢስ ጀናዘተ ኣሶኖስተ ፍቃድ ጠዕሜእ። ");
INSERT INTO alw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ህከኒች ኤተሮን ጀናዘተ ጡመ ጥጥ ኦድኖን ከፈኞ፤ ህት አዕይ አዪሁ ሞገሞበእ ክኑ ሸሄን መክሴመ ሎዳን አፉሼእ። ");
INSERT INTO alw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ሁኩንን ፎሎጭ በሩ ኣጎተ ሆንጠካን ተቃጠቤኖ ጅዕማቴተ ሀዎሩ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ገሊላች ኢሲን ሜጡበ አዎንተን አሜቶ ሜንቱ ሆንጠክ ሎደስለከ ጀናዘስ አፉሼመገ ለኦኡ። ");
INSERT INTO alw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","እሰን ምነሰ ፈንቀልት አንጀኖርቹለከ ሽቱተ ቅጥአቶኡ፤ ሕግሰጊን ፎሎጭ በርንከ አዘዘሞገን ፎሎጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ሁኩ ሜንቱ ሳምንት ዎኔ በር ገስመ ሱጵተ ቅጥአቶ ሽቱተ አፍ ሎድቤቹ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","እሰን ክኑ ሎድ አፌች ኮሎንኮዕልሃን ለኦኡ። ");
INSERT INTO alw_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ጠዉ እኮጎሬ ሎድስ ኣዝ ኣጎ ወክት ቀርቾ ኢስ ጀናዘተ ደጎበአ። ");
INSERT INTO alw_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","እሰን ህከን ጠዋን አበ አጀብሲጭተን በለቃ ኦድኑተ ኦደኦ ለሙ መኑ ድንገቴን መዴንከሰ ኡርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ሜንቱንኩ አበ ዋጅት ሙግይት ለአን ለሙንኩ መንቹ «ፎሊን ዮኢሃ ሬቶሀኑኡ በላን ሚሃ ሀሴነንታት? ");
INSERT INTO alw_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","እስ ከበ ዮበአ፤ ኬዕዮኡ፤ ገሊለን ሄዕዮ ወክት ‹መንች ቤቱ ጩበኛኖ አንጋን ህግሴን ኣሱ፥ ሰቀለሙለከ ሰቅ በር ሬሆች ኬኡ ሀስሰኖስ› ይ ኩሎህዕኔገ ሰውይዬ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","9","ሜንቱንኩ ኢስ ጠወ ሰውይት ሎድቢች ፈንቀልት ህከ ጠወ ጉዕመንከ ቶና መቶሃንከ አሳባተለከ ፈቆሀኑኡተ ጉዕሚንከ ኩልቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ህከ ጠወ አሳባተ ጠወኦእሩ መግደል ከተም መርየማት፥ ዮሃናት፥ ያቁብ አመት መርየማትለከ እሳንን ሜጡበ ሄኦ ዎሎሃ ሜንቱ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ጠዉ እኮጎሬ ሜንቱ ጠወኦ ጠዉ ሀንቅ አጉጆሰበእቤቺሃ አሳበት አመዕንቶሰበአ። ");
INSERT INTO alw_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ጴጥሮስ ኬዕይ ሎድቤቹ ደጉጆ፤ ህከን ቤቾን ሙግይ ከፈኔመ ጥጥ ኦድኑት ሄኦኢሃ ለዕይ ጠዋንከስ አጀብሲጨን ምኒ ፈንቀሎ። ");
INSERT INTO alw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ህከ በርንከ ኢስ አሳባች ለሙ «ኤማሁሰ» ዬኖ ቀእተ መርታኢት እቅ፤ ሁኩቤቹንኩ ዬሩሳሌሚች ለሞ ሰኣት ጌሰ መሰኖሃ ዎቃ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ህትን ገገዉንኩሰ ህከ እኮ ጉዕመንከ ጠውተኔሃ ሀሳውታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ጠራኝስ ሀሳውተንን ኢስ ገዉንኩስ ሆንጠክ እሳን ሜጡበ ሃመኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ጠዉ እኮጎሬ እሱ ደግበገ እሌንከሰ ለአንን አጥራመቶበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","እስን «ሃንቴነን ገገዉክዕኔን ጠወኤነን ሄኤንተ ጠዉ መርቹሃን?» ዬሰ፤ እሰን ሻዝ ጨለይት ኡርቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ህከኒች ኤተሮን እሳችን መቱስ «ቀላዮጳ» ዬኖሁ «ከን ሳምንታን ህከኔ እኮ ጠወ ደግባሁ ዬሩሳሌም ከተማን ጠለዕል አት ኮህቹሃንዶ?» ይ ፈንቀሼስ። ");
INSERT INTO alw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ኢስን «መ ጠወ?» ዬሰ፤ እሰን «ሆጎንለከ ጠወኢን መንለከ መገን ብሬን ጠረኘ ነቢዬች ናዝሬት ኢስተኔሃት። ");
INSERT INTO alw_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ቂስ አዎንሳኑትለከ ዳኛኑት ሬሆ ፍርዲሃ ህግስ ኣቶች ኤተሮን ሰቀልቶስ። ");
INSERT INTO alw_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","እኮጎሬ ነኡ ‹እስራኤለ ፌሰኖሁ እሶት› ይን ተቢሳሃ አዕኖም እቅ፤ ህትን ህከን ጉዕመንከ ጠው አሌንን ኩ ጠዉ እኮች ከበር ሰቅየ በር። ");
INSERT INTO alw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ዎሉንገ ህትን ኒ በሊች ሱጵተ ፉልት ሎድቤቹ መርቶ መት-መቱ ሜንቱ አጀብሲሶኔ። ");
INSERT INTO alw_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ጠዉ እኮጎሬ እሰን ጀናዘስ ደጎተ አታልቶበአ፤ ህትን ‹እስ ፎሊን ዮኡ› ይታ መላይከተ ለዕኖም ይተን ፈንቀልት አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ህትን ኒን ሜጡበ ሄኦሀኑኡች መት-መቱ መኑ ሎድቤቹ መርት ሁኩ ሜንቱ ይቶገን እኮሃ ደጎኡ፤ እኮጎሬ እሱ ለኦስበአ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ኢስን «አዕኑ ኩ ገዋኑት፤ ነቢያኑት ጠወኦ ጠወ ጉዕመንከ ቀልቡክዕኔ ደዕል አመዕንዮበእሩ። ");
INSERT INTO alw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","መሲሁ ከ ኦርሸተ ጉዕመንከ ቶጎተለከ ኬዕምኚን ኣጎተ ሀስሰኖስበእንዶ?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ህትን ሙሲችለከ ጉዕማንከ ነቢያኖች ኬሽ መጻፋን ጉዕማንን እስተኔሃ ከተበሞ ጉዕመንከ ቤቺች ቤቺች ኩሎሰ። ");
INSERT INTO alw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ህከኒች ኤተሮን እሰን መርታ ቀእተ ሆንጠካን እስ ቄዕራሻን ሃመኖሀንገ እኮ። ");
INSERT INTO alw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","እሰን «ኡለት ሀዎርቶኡ፤ አሩ ኣጎተ እኮቤቺሃ ኒን ገል» ይት ጠራኝስ ኡጭቶስ፤ ህካን እኮቤቺሃ እሳንን ሜጡበ ገሎተ ኣጎ። ");
INSERT INTO alw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","እስን እሳን ሜጡበ ማዳን አፉዕሌ ወክት ጦሮሹ ኣእ ዱአ አዕይ ቢጭ እሳሃ ኣሴእ። ");
INSERT INTO alw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ህከ ወክት እልሰ ፈንተኣን እሱ ደጎኡ፤ እስን ብሬችሰ ገበጭ ዬእ። ");
INSERT INTO alw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","እሰን መት-መትሀሰ «ዎቃን ኒን ጠወአን መጻፈተ ሂር ኩሎኔ ወክት ቀልቡኔ ሙንዲኖን ተሽይበኔንዶ?» የቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","እሰን ህከ ሰኣትንከ ኬእ ዬሩሳሌመ ፈንቀልት አሜት ቶና መቱንኩ አሳበትለከ ዎሎ መኒን ጭምይት ");
INSERT INTO alw_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","«ቀርቹ ኢስ ሀንቅንከ ሬሆች ኬዕዮኡ፤ ስሞኔንከ ለልዮኡ» ይተን ደጎኡ። ");
INSERT INTO alw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ለሙንኩ ህትን ዎቃን እኮ ጠውተኔሃ ጦሮሹ ቢጮ ወክት እሱ አጥራመቶስገ ኩልቶሰ። ");
INSERT INTO alw_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ህካን ጠወአንን ኢስ ገዉንኩስ በላንከሰ ኡር «ወገሬቱ ክዕኔሃ እሁን» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ጠዉ እኮጎሬ እሰን አያነ ለኣኢሃ አጉጃንሰ ህልቅ ዋጅቶኡ። ");
INSERT INTO alw_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","እስን «ሚሃት ህልቄነንታሁ? ህትን ሚሃት ቀልቤንከክዕኔ ሸክቴነንታቲሁ? ");
INSERT INTO alw_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ኤሳሃ ገዉእ እሁእ አንገእለከ ሎከእ ለእዬ፤ ህትን ለኤነንተኤገን ኤሳሃ ዮ ማሉ፥ ምቁለከ አያኑ ዮስበእቤቺሃ ኤሳሃ አፌን ለዕዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ህካን ይኬይ አንገስለከ ሎከስ ለሊሾሰ። ");
INSERT INTO alw_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","እሰን አበ ሙንደእ አጀብሲጭቶቤቺሃ ጠወስ አመዕንቶበአ እቅ፤ ኢስን እሰተ «እቴኖርቹ ዮህዕኔንዶ?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","እሰን ሬዕዮ ቀዉተ ቁርጩሜተ ኣቶስ። ");
INSERT INTO alw_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","እስን ኣእ ኬዕይ ብሬንከሰ እቾ። ");
INSERT INTO alw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ህከኒች ኤተሮን ኢስ «ክዕኔኤን ሜጡበ ሄዕዮም ወክት ‹ሙሲ ሕጋን፥ ነቢያኖለከ መዝሙር መጻፋን እተኔሃ ከተበሞሁ ጉዕሙንኩ እሁ ሀስሰኖስ› ይ ኩሎንክዕኔ ላገት ተኒት» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ህከ ወክት ጠሊሉ መጻፉ የኖሃ ሰውይታገ ቀልብሰ ፈኞ። ");
INSERT INTO alw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ህትን « ‹መሲሁ ኦርሸተ ኣአኖ፤ ሰቅ በርንከ ሬሆች ኬአኖ፤ ");
INSERT INTO alw_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ህትን ቶበቱለከ ጩብ አጉሩ ዬሩሳሌሚች ኬሽ ጉዕማንከ ኡመት በላን እስ ሱዕሚን ኩለመኖ› የመም ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","አዕኑ ከን ጉዕመንከ ጠዊሃ ምስክረታን። ");
INSERT INTO alw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","አን አኑኤ ኣሴ ተብሳሃ ሶሃንክዕኔ፤ ጠዉ እኮጎሬ አሊች ዎልቀት ኣሰንቶህዕኔተ ኢለ ዬሩሳሌም ከተማን አገሬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ህከኒች ኤተሮን ኢስ አሳበስ ዬሩሳሌም ከተሚች ፉሽ «ቢታነ» ዬኖ ከተመ መሴሰ፤ ህከኔን አንገስ ሂር ማሰዕዮሰ። ");
INSERT INTO alw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ማሰአንን እሳች አደ እክ ሰማ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","እሰን እሲሃ ሰገድ ኬእ አበ ሙንዲኖን ዬሩሳሌም ከተመ ፈንቀልት ");
INSERT INTO alw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","መገን ምኔን ጉዕመ ወክትንከ መገኑ ገለትጭተን ሄኣኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ዎዕናሃ ላገት ሄኦ እቅ፤ ላገንትስ መገንሀኔን ሄኦ እቅ፤ ህት ላገንት መገኑወ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","እስን ዎዕኔችን ኬሽ መገንሀኔን ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ጉዕሙርቹንኩ እሲን አሜቾ፤ እስ ዮበኢሃ መቱርቹሁ አሜቾበአ። ");
INSERT INTO alw_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ሁኩ አሜቾንኩ እሲን ዮእሃ ሄኡ፤ ሁኩ ሄኡንኩ መን እላተ ኑርሃን። ");
INSERT INTO alw_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ሁኩ ኑሩንኩ ቱንስቾን ለለኖ፤ ቱንስቹንኩ ሆሮን ቄለኖስበአ። ");
INSERT INTO alw_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","መቱ «ያህይ» ዬኖ መንቹ ሄዕዮ፤ እስን መገኑ ሶኮስየ መንቹ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","እስ ኑርተኔሃ መሰከሮተ አሜቾ፤ ህከን እስ መሰከሮሀኔን ጉዕሙንኩ መኑ አመዕንታአ። ");
INSERT INTO alw_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","እስ ኑርተኔሃ መሰከሮተ አሜቾኡ ቤሉ እስ ገዉስ ኑርሃበአ። ");
INSERT INTO alw_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ሁኩ ሀንቅ ኑሩ ከ ኣዱንያ አል አሜች መኒሃ ጉዕሚንከ ኑር ለሊሰኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","እስን ከን ኣዱንያ አሌን ሄዕዮ እቅ፤ ኩ ኣዱንያንት እሲን አሜቶጎሬሁ ከን ኣዱንያ አል መኑ እሱ ደጎስበ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","እስን ገይስ መንቤቹ አሜቾ፤ እኮጎሬ ገይስ መኑ ቶጎስበ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ጠዉ እኮጎሬ ቶጎስረለከ ሱዕሚንከስ አመዕንቶእረ መገን እለተ እካ ሹምነቱ ኣሴሰ። ");
INSERT INTO alw_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","እሰን መገኒች እለንቶኡ ቤሉ ቄጊች ህከረንገ ማል ሄዕላቸገ መን ሃሺኣቶን እለንቶበአ። ");
INSERT INTO alw_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ላገንት መንቹ እኮኡ፤ እሲን ኒን ሄዕዮ፤ ነኡ እስ ኬዕምኝ ለዕኖም፤ ሁኩ ኬዕምኙንኩ ሜጦ አኒች እለሞእሃን፤ እሲን ኣስቶንለከ ሀንቂን ዊሞእሃን። ");
INSERT INTO alw_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ያህይን « ‹ኢች ኤተሮን አሜተኖሁ ኢች በተአኑሃን፤ መሰንትስ እስ ኢች ሄጭ ሄዕዮ› ይ ኩሎንክዕኔሁ ከኒት» ይ እስተኔሃ ላገስ ጎት አዕይ ጠወዕዮ። ");
INSERT INTO alw_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ነኡ ጉዕሙንኩኔ እስ ኣስቶ ዊምማች ኣስቶ አሌን ኣስቱተ ደዕናም። ");
INSERT INTO alw_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","መገን ሕጉ ሙስ አዲን ኣሰሞ፤ እኮጎሬ ኣስቱትለከ ሀንቁ መሲህ አዲን አሜቾ። ");
INSERT INTO alw_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","መገኑ ለዕዮሁ አዪሁ ዮበአ፤ እሁን ቤሉ መገንሀኔን ዮ ሜጥቹስ ቤቱ ኔሳሃ ለሊሾኔ። ");
INSERT INTO alw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ኩን ያህይሃ ምስክርነቱ፤ አይሁድ አዎንሳኑት ዬሩሳሌም ቂሰተለከ ሌዋውያኑተ ያህይበ ሶክ «አት አዬት?» ይት ጠዕምሲሶስ ወክት ");
INSERT INTO alw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ያህይ «አን መሲህበአ» ይ መሰከሮ ቤሉ ካጆበአ። ");
INSERT INTO alw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","እሰን «ህካን እኮች አት አዬት? እልያሴትንዶ?» ይት ጠዕምቶስ፤ እስን «አን እሶበአ» ዬሰ። እሰን «አሜተኖ ዬመ ነቢዬቹሃንዶ?» ይቶስ። እስን «እሶበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","እሰን «አት አዬት? ሶኮኔ መኒሃ ኩልኖተ ገይክተኔሃ መ ይተን?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","እስን ነቢዬቹ እስያስ ጠወዕዮገን አን « ‹ቀርች ዎቃሃ ጌጥ አዕዬ› የን ኡለ ኡድማን ያረኖ መንችተ ላገ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ሁኩ መኑንኩ ፈርሳዌ አዲች ሶሀንቶእረ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","እሰን «አት መሲህ ህከረንገ እልያሴ ህከረንገ ነቢዬቹ እክባች ሚሃት ጠመቃንቲት?» ይት ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ያህይን ፈንቀሽ «አን ዊን ጠመቃንክዕኔ፤ ጠዉ እኮጎሬ አዕኑ ደጌንቡ በላንከክዕኔ ዮኡ። ");
INSERT INTO alw_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","እስ ኢች ኤተሮን አሜተኖ፤ ዎሉ ፈቅ አን እስ ሎከስ ጫዕመስ ወደሩ ህሮተ በቀዕበሃን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ኩ ጉዕሙንኩ ጠዉ እኮሁ ያህይ መነ ጠመቀኖ ዮርዳኖስ ዊች አሩ ፉለኖ አዲን ሄዕዮ «ቢታንያ» ዬኖ ከተማኒት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ለንክ በር ያህይ ኢስ እስቤቹ አሜተን ለዕይ «ኣዱንያ አል መኒች ጉዕሚችን ጩብ ከመኖ መገን ሆልቹ ሁኩዕኑን ከለዕዬ! ");
INSERT INTO alw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","‹ኢች በተአኖ መንቹ ኢች ኤተሮን አሜተኖ፤ መሰንትስ እስ ኢች ሄጭ ሄዕዮ› ዬሚሁ ሁኩዕኑን። ");
INSERT INTO alw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","አን ገዉንኩእ እሱ ደጋንስበ እቅ፤ ጠዉ እኮጎሬ እስራኤል መኑ እሱ ደጋገ አን ዊን ጠመቀን አሜቾም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ለንኪሃ ያህይ «ጠሊሉ አያኑ ሀንደዕሬገ እክ ሰሜች ድር አሌስ አፉዕለን ለዕዮም። ");
INSERT INTO alw_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ህትን አን ገዉንኩእ ደጋንስበአ እቅ፤ ጠዉ እኮጎሬ አን ዊን ጠመቆተ ሶኮኤሁ ‹ጠሊሉ አያኑ ድረንለከ አሌስ አፉዕለን ለኣንቲሁ ጠሊለ አያኒን ጠመቀኖሁ እሶት› ይ ኩሎኤ። ");
INSERT INTO alw_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","አንን ህካን ለዕዮም፤ እስ መገን ቤቱ እሁስ መሰከራም» ይ መሰከሮ። ");
INSERT INTO alw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ህትን ለንክ በር ያህይ ለሞንከ አሳባን ሜጡበ ኡርዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ያህይን ኢስ ህከን ቤቺን ህገን ለዕይ «መገን ሆልቹ!» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ያህይ ህካን የን ሞጮጭት ለሙንኩ አዎንታስሩ ኢሰ አዎንቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ኢስን ህከ አዎንታረ ፈንቀል ለዕይ «መ ሀሴነንታት?» ዬሰ፤ እሰን «ረቢ! ሀከንቤቾን ሄኣንቲት?» ይት ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","እስን «አሜቴን ሄኣም ቤቹ ለዕዬ» ዬሰ፤ እሰን አሜት ሄአኖ ቤቹ ለኦኡ፤ ህከ በር እሲን ሜጡበ ሆሶኡ፤ ሁኩ ወክቱንኩ በሬ ቶኖ ሰኣትየ ጌሰ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ህከ ያህይ ጠወ ሞጮጭት አዎንቶሀኑኡች መቱስ ስሞን ጴጥሮሴ አመቤቱ እንድራሴት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","እስን ሄጭ አመስ ቤቲን ስሞኔን ደቀም «መሲህ ደንጎም» ዬስ፤ (መሲህ ዩ ቡረሞሃ ዩሃን) ");
INSERT INTO alw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","እንድርያስን ስሞኔ ኢስቤቹ አፍ አሜቾ፤ ኢስን እሱንከ ለዕይ «አት ዮነሃ ቤቱ ስሞኔት፤ አትን ‹ኬፈ› የመንታንት» ዬእ፤ (ኬፈ ዩ ጠረኘ ክኑ ዩሃን) ሁኩንን «ጠረኘ መንቹ» ዩሃን። ");
INSERT INTO alw_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ለንክ በር ኢስ ገሊለተ መሮተ ሀሾ፤ እስን ፍልጶሴን ደቀም «አዎኔኤ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ፍልጶስን እንድርያስለከ ጴጥሮስ ሄኣ «ቤተ ሳይዳ» ዬኖ ከተምየ መንቹ። ");
INSERT INTO alw_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ፍልጶስን ናትናኤሌን ደቀም «ሙሲ ሕጋን ህትን ነቢያከት እስተኔሃ ከተቦ ዩሱፍ ቤቱ ናዝሬት ኢሰ ደንጎም» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ናትናኤልን «ናዝሬት ከተማን ጡሙርቹ ደገመኖንዶ?» ዬእ፤ ፍልጶስን «አሜት ለእ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ኢስን ናትናኤል እስቤቹ አሜተን ለዕይ «ተንኩት ዮስበእ ሀንቅ እስራኤል መንቹ ከለዕዬ» ዬእ፤ ");
INSERT INTO alw_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ናትናኤልን ኢሰ «ሀከኔ ደገዕኔ?» ዬስ፤ ኢስን ፈንቀሽ «ፍልጶስ ገኡዕናንኬ ሄጭ ኦድ ሀቁቾ ፎቃን ሄኦንት ወክትንከ ደጎንኬ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ህከ ወክት ናትናኤል ፈንቀሽ «አስተማርቾ! አት መገኒየ ቤቱ፤ ህትን አት እስራኤልየ ዎመ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ህትን ኢስ «ኦድ ሀቁቾ ፎቃን ለዕዮንኬ ዬምቤቺሃ አመዕንቴኤንዶ? ከኒች በተአኖርቹ ለኣንት። ");
INSERT INTO alw_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ሀንቅንከ ያንክዕኔ፤ ሰሞሁ ፈንተዕያን መገን መላይከት መንች ቤትበ አሜተንለከ መርተን ለኤነንተ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ሰቅስ በሬን ገሊለ ቃናን ቦለቹ ሄዕዮ እቅ፤ ህከን ቤቾን ኢስ አመት መርየመ ሄኦ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ህትን ኢስ አሳባንከስን ህከን ቦለቺሃ ገአሞ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ዎይን ጠጁንኩ ህከን ቦለች ምኔን ጎፎ ወክት ኢሲሃ አመስ «ዎይን ጠጁ ጎፎሰ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ኢስን «ኪን ም ዮኤ፤ ወክቱኤ እልዮበአ» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ህከ ወክት አመስ ህከን ቤቾን ሄኦ ካዲማተ «እስ የኖህዕኔሃ ጉዕመንከ አዕዬ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ህከንቤቾንን አይሁድ ሴር ሃሊን ነጠ እኮተ ኣዕልታ ዋሃ ዎሬኖ ሌሁ ክን ዛለት ሄኦ እቅ፤ እሰን መት-መቱስ ለሙ-ለሙ ህከረንገ ሰ-ሰሱ ኮሪ ጌሰ አፋዕረ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ኢስን ህከኔ አታ ካዲማተ «ከን ሌሆንከ ዛላን ዋሃ ዊንሽዬ» ዬሰ፤ እሰን ህከን ዛላን አፎሰ ኢለ ዋሃ ዊንሽቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ህከኒች ኤተሮን ኢስ «ከኒች እንኪልቴን ከን ድግስ አስናዳንቺሃ ኣስዬ» ዬሰ፤ እሰን መስት ኣቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ሁኩ መንቹንኩ ዎይን ጠጀ እክ ዶራሞ ዋሃ ፊጭ ይ ለዕዮ ወክት ሀከንቢች አሜቾ ጎሬ ደጎበአ፤ ጠው እኮጎሬ ዋስ እንኪልት ዛሌን ወርቶ ካዲመት ሀከንቤቺችት ጎሬ ደጎ እቅ፤ ህካን እኮቤቺሃ ሁኩ አስናዳንቹ እዜቹ ገእ ");
INSERT INTO alw_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","«መኑ ጉዕሙንኩ ዎዕና ጡመ ወይን ጠጀ ኣሰኖ፤ ህትን መኑስ ሰከሮች ኤተሮን ሂለስ ኣሰኖ፤ ጠው እኮጎሬ አት ከ ወክት ኢለ ጡመስ ወይን ጠጀ ማጦንት» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ኢስ ከ ዎኔስ አጀብሲሰኖ ጠወ ገሊለ ባዶን ዮ «ቃነ» ዬኖቤቾን አዕዮ፤ ህት አዕይ ኢስ ኬዕምኝስ ለልሾ፤ ህትን አሳበንት እሲን አመዕንቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ህከኒች ኤተሮን ኢስ አማንተሲ፥ አመስ ኦሶንለከ አሳባን ሜጡበ «ቅፍርናሆመ» ዬኖ ከተመ መር ህከኔ ቀው በር አገሮ። ");
INSERT INTO alw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ሻሽግ ከበጃት በሩ ሆንጠኮቤቺሃ ኢስ ዬሩሰሌመ ኦሮዕዮ፤ ");
INSERT INTO alw_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","መገን ምኔን ቦተተ፥ ሆለተለከ ሀንደዕርተ ህርታ መነለከ ህትን አፉዕልት ብረ ዶርታእረ ደጎ። ");
INSERT INTO alw_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ህከ ወክት ወደር ጮርቄተ ደጅ ጉዕመንከ መነ ሆላንተሰለከ ቦታንከሰ መገን ምኒች ሸር ፉሼእ፤ ብረ ዶርታሀኑኡ ብረ ብንአዕይ ጠራጴዘ ገለበጮ። ");
INSERT INTO alw_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ሀንደዕርተ ህርታእረ «ካን ከንቤቺች ከሜ፤ አንኤ ምኒ ንግድ ምኒ አቶኖቼ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ህከ ወክት አሳበት «ምኒሀክ ዮኤ ኢተት ጊረገ ቡስቶኤ» የመም ከተበሞሃ ሰውይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ህካን እኮቤቺሃ አይሁድ አዎንሳኑት «አት ካን አታንት ዎልቀት ዮሄጎሬ ደንጎተ መ መላተ ለሊሰኔ?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ኢስን ፈንቀሽ «ከ ዱእ ምኒ ድጅዬ፤ አን ሰሶ በሬን ፈንቀሽ እጃራም» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","እሰን ፈንቀሽት «ኩ መገን ምኑ ሸይልኔ ሌሆ ዘማኔን እጃረም ጎፎኡ፤ አት ህካን ሰሶ በሬን እጃርተንዶ?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ጠዉ እኮጎሬ ኢስ «ዱእ ምኒ» ዬእሁ ገይስ ጅስመሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ህካን እኮቤቺሃ ኢስ ሬሆች ኬዕዮች ኤተሮን አሳበስ ከ ጠወ ሰውይት ኢስ ጠወዕዮሃለከ ጠሊለ መጻፋን ከተበሞሃ አመዕንቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ኢስ ሻሽግ ከበጀ ወክቴን ዬሩሳሌማን አዕዮ አጀብሲሰኖ ጠውተኔሃ ልግቡ መኑ እስ ሱዕማን አመዕንቶእ። ");
INSERT INTO alw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ጠዉ እኮጎሬ ኢስ ጉዕመንከ መነ ደገኖቤቺሃ ጎደበ ኣስዮሰበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","እስን መን ቀልቤን ዮኢሃ ጉዕመንከ ደገኖቤቺሃ መንተኔሃ አዪሁ እሲሃ ኩሉተ ሀስሾስበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","«ንቆድሞሴ» ዬኖ መቱ መንቹ ሄዕዮ እቅ፤ እስን ፈርሳዌ አዲች አይሁድ መኒሃ ሀለቀ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ሁኩ መንቹ ኢስቤቹ ሀዎሮን አሜች «ረቢ! አት መገን አዲች አሜቶንት አስተማርቹ እሁክ ደንጎም! መገኑ እሲን ሜጡበ ሄዕዮ መንች ቤሉ አት አታንት አጀብሲሰኖ ጠወ አኦተ አታለኖሁ አዪሁ ዮበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ኢስን ፈንቀሽ «ሀንቅንከ ያንኬ፤ መኑ ለንኪሃ እለምባች መገን ዎምነቱ ለኦተ አታለኖበአ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ንቆድሞስን «መኑ ባሊቆች ኤተሮን ሀት እክ እለሞተ አታለኖ? ለንኪሃ አመስ ጎደበ ፈንቀል ኣግ እለሞተ አታለኖንዶ?» ይ ጠዕሜእ። ");
INSERT INTO alw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ህትን ኢስ ፈንቀሽ «ሀንቅንከ ያንኬ፤ መኑ ዊችለከ ጠሊለ አያኒች እለምባች መገን ዎምነቱ ኣጎተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","መኒች እለመኖሁ መንቹሃን፤ አያኒች እለመኖሁ አያነ። ");
INSERT INTO alw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","‹ለንኪሃ እለሙ ሀስሰኖህዕኔ› ዬምሀኒን አጀብሲጭቶት። ");
INSERT INTO alw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ቦብሩ ሀሾ አደ ዋል ቦብርሰኖ፤ አትን ላገስ ሞጮጭታንት ቤሉ ሀከን አዲች አሜች ሀከ አደ መረኖጎሬ ደጋንትበአ፤ አያኒች እለሞሁ ህትዪንት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ንቆድሞስን ፈንቀሽ «ኩን ሀት እክ እሆተ አታለኖ?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ኢስን ንቆድሞሴ «አት እስረኤል አስተማርቹ እክ ከ ጠወ ደጋንትበእንዶ? ");
INSERT INTO alw_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ሀንቅንከ ያንኬ፤ ደንጋሚሃ ጠወዕናም፤ ህትን ለዕኖሚሃ መሰከርናም፤ ጠዉ እኮጎሬ መሰከርኖሚሃ ቶጌነንተበአ። ");
INSERT INTO alw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","አን ከን ኣዱንያ አል ጠወ ኩላን አመዕንቴንበሩ ሰሜ ጠወ ኩሎንክዕኔ ጎሬ ሀት እኬን አመዕንቴነን? ");
INSERT INTO alw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ሰሜች አሜቾሀኒች ሁኩንን መንች ቤት ቤሉ ሰማ አሌ ዋል ኦሮዕዮሁ አዪሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","«ሙስ ኡለ ኡድማን ዎሪቹ አሌ ዋሽ ኬሾገን ህትን መንች ቤቱሁ አሌ ዋል ኬኡ ሀስሰኖስ። ");
INSERT INTO alw_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ሁኩንን እሲን አመዕነኖሁ ጉዕሙንኩ ጉዕመ ዘማኒሃ ሄአኖ ሄኡ ደኦታት። ");
INSERT INTO alw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","«ቤቶንከስ አመዕነኖሀኒሃ ጉዕሚንከ ዘላለሚሃ ሄአኖ ሄኡ ሄኦስታት ቤሉ በአኖበእገ መገኑ ሜጥቹስ ቤቱ ኣሶተ ኢለ ከን ኣዱንያ አል ህትን ኢቴእ። ");
INSERT INTO alw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","መገኑ ቤቱስ ከ ኣዱንያ አል ሶኮሁ ኩ ኣዱንያት እስ አዲን ጡምቶታት ቤሉ ፈረዶታበአ። ");
INSERT INTO alw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","«እሶን አመዕነኖሀኒሃ ፈረደመኖስበአ፤ ጠው እኮጎሬ እሲን አመዕንበሀኒሃ መገን ሜጥቾ ቤቶንከስ አመዕኒበቤቺሃ ዎዕናንከ ፈረደሞስ። ");
INSERT INTO alw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","«ፍርዱንኩስ ከኒት፤ ኑሩ ከ ኣዱንያ አል አሜቾ፤ ጠው እኮጎሬ መኑ ሆጉስ ሂለ እኮቤቺሃ ኑሪች በትሽ ቱንስቹ ኢቴእ። ");
INSERT INTO alw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ሂለርቹ አአኖሁ ጉዕሙንኩ ኑር ግበኖ፤ ሂለ ሆጉስ ለልታበእገ ኑርቤቹ አሜተኖበአ። ");
INSERT INTO alw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ጠው እኮጎሬ እስ አዕዮ ጡመ ሆጉት መገኒች እኮኢተ እሁሴ ደጎኖተ ሀንቅ ጠወ አአኖሁ ጉዕሙንኩ ለለኖ ቤቹ አሜተኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ህከኒች ኤተሮን ኢስ አሳባንተስን ሜጡበ ይሁድ ባዱ ኦሮዕዮ፤ ህከን ቤቾን ጠመቀን እሳንን ሜጡበ ቀው ጌሰ ዱንኬእ። ");
INSERT INTO alw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ህከ ወክት ያህይ ልግቡ ውሁ ሄዕዮ «ሳሌመ» ዬኖ ቤች መዴን «ሄኖነ» ዬኖቤቾን ጠመቀኖት እቅ፤ ህከ ቤቹ መኑ አሜተን ጠመቀመኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ያህይ ህከ ወክት ኡሱር ምኒ ኣጎበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ያህይ አዎናኖለከ መቶ አይሁድ መንች በላን ሴርሰ ሃሊን ነጠ እህተኔሃ ኦደት ኬኦኡ። ");
INSERT INTO alw_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ያህይ አዎናኑት ሆንጠክ «አስተማርቾ! ዮርዳኖስ ዊ ዉድ አዲን ኪን ሜጡበ ሄዕዮእቂሁ አት እስተኔሃ መሰከርቶንቲሁ ጠመቀኖት፤ ህትን መኑ ጉዕሙንኩ እስበ መረኖት» ይት ኩልቶስ። ");
INSERT INTO alw_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ያህይን «ሰሜች ኣሰምባች ሀኩ መንቹሁ መቱርቹሃ ኣኦተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‹አን እሲች ሄጭ ሶሀሞም ቤሉ አን መሲህበአ› ይ ኩሎንክዕኔገን አዕኑ ገዉንኩክዕኔን ምስክርሃን። ");
INSERT INTO alw_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","እዜቹት ዮሲሁ እዜቹሃን፤ ጠዉ እኮጎሬ እዜች ጃሉ እዜች መዴን ኡር ላገስ ሞጮጨን ሙንደአኖ፤ ህትን አን ቴሱ ዊመ ሙንዲኑተ ደእዮም። ");
INSERT INTO alw_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","አን እሲች ሆፈአን እስን ኢች በተአን መሩ ሀስሰኖስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","አሊች አሜተኖሁ እስ ጉዕሚችን ሎረሃን፤ ከን ኡላች እሀኖሁ ጉዕሙንኩ ኡላሃን፤ ከን ኡለ አል ጠወ ጠወአኖ፤ ሰሜች አሜተኖሁ እስ ጉዕሚችን ሎረሃን። ");
INSERT INTO alw_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","እስ ለዕዮሃለከ ሞጮጬኢሃ መሰከረኖ፤ ጠዉ እኮጎሬ እስ መሰከሮሃ አዪሁ ቶገኖበአ። ");
INSERT INTO alw_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","እስ መሰከሮሃ ቶገኖሁ መገኑ ሀንቅ እሁስ ደገን ቶጎእሃን። ");
INSERT INTO alw_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","መሰንትስ መገኑ ሶኮሲሁ መገን ላገተ ጠወአኖቤቺሃ ጠሊለ አያነስ በትሽ ኣሰኖስ። ");
INSERT INTO alw_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","አኑ ቤቱስ ኢተኖቤቺሃ ጉዕመርቹንከ አንገስ ህግሽ ኣስዮስ። ");
INSERT INTO alw_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","መገን ቤቶን አመዕነኖሁ ጉዕሙንኩ ዘላለሚሃ ሄአኖ ሄኡ ደአኖ፤ መገን ቤቶን አመዕንበሀን አሌን መገን ኡሙዕርት እካ ቤሉ ዘላለሚሃ ሄአኖ ሄኡ ደአኖበአ። ");
INSERT INTO alw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","ህከ ወክት ኢሳ አሳበስ ያህይ አዎናኖች በተኦገለከ ልግብ መነ ኢስ ጠመቀኖገ ፈርሳውት ሞጮጩሰ ኢስ ደጎ ወክት ይሁድ ባዱ አጉር ለንኪሃ ገሊለተ ኦሮዕዮ፤ ጠው እኮጎሬ ኢስ አሳበት ጠመቃኢት ቤሉ ኢስ ገዉስ ጠመቆበአ። ");
INSERT INTO alw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ህከ ቤቹ መረን ሰማር ባዲን ህጉ ሀስሾስ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ህካን እኮቤቺሃ ያቁብ ቤትሀስ ዩሱፊሃ ኣሴ ኡለ መዴን ሰማር ባዶን ሄዕዮ «ሲካረ» ዬኖ ሰማር ከተመ አሜቾ። ");
INSERT INTO alw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ህከን ቤቾን ያቁብ ዊ ኤሎሁ ሄዕዮ እቅ፤ ኢስ ዎቀሃ ሃም ሆጎቤቺሃ ህከን ኤሌ መዴን አፉዕሌእ፤ ወክቱስን ሌሁ ሳት እኮ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ህከ ወክት መት ሰማር ባድ መንቹት ዋሃ እንኪልቶተ አሜቶኡ፤ ኢስን ህተ መንቹተ «ዊች አግሴኤ» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","አሳበስ እቸተ ህዕርቶተ ከተመ መርቶ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ህት መንቹንት ፈንቀሽት «አት አይሁድቹ እክ ኤሳሃ ሰማር ባዲተ ሀት ‹ዊች አግሴኤ› ይት ጠዕምታንቴኤት?» ይቶስ፤ ህት ይቶኢንኩ አይሁድ መኑ ሰማር መኒን ቶቀንታበእቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ኢስን «መገን ኣስቱተለከ ‹ዊች አግሴኤ› ያኖሄሁ አዬት ጎሬ ደጎንት እቀ አት እሱ ኡጭታንትስ እቅ፤ እስንገ ህትን ሄእ ዋሃ ኣሰኖሄ እቅ» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","መንቹንት ፈንቀሽት «ቀርቾ! ኬሳሃ እንኪልታንቲንኩ ዮሄበአ፤ ህትን ኤሎንኩስ ሂለ ጌሰ ጥዕላሸሃን፤ ከ ሄእ ዋሃ ሀከንቤቺች ኤበን? ");
INSERT INTO alw_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ሀንቅንከ አት ከ ዊ ኤሎ ኣሴኔ አኒችኔ ያቁቢች በተአንንዶ? እስ፥ ኦሱስለከ ግዙስ ከን ኤሌ ዊች አጎኡ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ህትን ኢስ «ከን ዊች አገኖሁ ጉዕሙንኩ ለንኪሃ ሰገበኖስ። ");
INSERT INTO alw_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ጠው እኮጎሬ አን ኣሳም ዊች አገኖሁ ጉዕሙንኩ ሆሮን ሰገበኖበአ፤ መሰንትስ ኣሳም ውሁ እስ ኣዜን ዘላለም ሄአኖ ሄኡ ቡቃ ዊ ቡቁተ እሀኖ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","መንቹንት «ቀርቾ! ከኒች ኤተሪሃ ሰገብበኤገለከ ህትን ከቤቹንከ ዋሃ እንኪሎተ አሜትበገ ህከ ዋሃ ኣሴኤ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ኢስን መንቹተ «መርት ምንክ አነ አፍ ከቤቹ አም» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","እሴን «ምኒ አኑ ዮኤበአ» እስን «ምኒ አኑ ዮኤበአ ይቶንቲሁ ሀንቅሃን። ");
INSERT INTO alw_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ጠዉ እኮጎሬ ኦንቱ ምኒ አኑ ሄዕዮሄ እቅ፤ ህትን ቴሁ ኪን ዮኢሁ ምኒክሃ መንቹበአ፤ ህካን እኮቤቺሃ ሀንቅ ጠወኦንት» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","መንቹንት «ቀርቾ! አት ራጋንቹ እኮንትገ ቴ ደጎም። ");
INSERT INTO alw_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","አናከክዕኔ ተን ቆታን ሰገዶኡ፤ ጠው እኮጎሬ አዕኑ አይሁዱ ‹መኑ መገኒሃ ሰገዱ ሀስሰኖሁ ዬሩሳሌማኒት› ይቴነንተ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ህትን ኢስ «ቴ መንቾ! አነ መገኒሃ ሰገዴነንተ ተን ቆተ አሌን ህከረንገ ዬሩሳሌማን እሀኖበእ ወክቱ አሜተኖገ አመዕኔኤ። ");
INSERT INTO alw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","አዕኑ ሰማር ባድ መኑ ደጌንበሀኒሃ ሰገዴነንተ፤ ጠዉ እኮጎሬ ነኡ ጡሙ አሜተኖሁ አይሁዲች እኮቤቺሃ ደንጋም መገኒሃ ሰገንዳም። ");
INSERT INTO alw_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ህትን ሀንቂን ሰገዳእሩ አነ መገኒሃ ዊመ አያኒንለከ ሀንቂን ሰገዳ ወክቱ አሜተኖ፤ ወክቱንኩስ ከኒት፤ አኑ መገኑንኩ ሀሰኖሁ ህት ሰገዳእራት። ");
INSERT INTO alw_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","መገኑ አያነሃን፤ ሰገዳእሩ አያኒንለከ ሀንቂን ሰገዱ ሀስሰኖሰ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","መንቹንት « ‹መሲህ› የመመኖሁ አሜተኖገ ደጋም፤ እስ አሜቾ ወክት ጉዕመርቹንከ ኩለኖኔ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ኢስ «ቴሱ ጠወኣንኬሁ አን እሶት» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ህከ ወክት አሳበስ መርቶ አዲች አሜቶኡ፤ እሰን ኢስ መንቾን ጠወአን ለእ አበ አጀብሲጭቶኡ፤ ጠዉ እኮጎሬ «መ ሀሶንት? ህከረንገ እሴን ሚሃ ጠወኣንቲት?» ይ ጠዕሜሲሁ አዪሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ህከ ወክት መንቹት ዊ ኮሩ ህከን ቤቾን አጉርት ከተመ መርት መኒሃ ");
INSERT INTO alw_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«አሜ! አን አዕዮም ጠወ ጉዕመንከ ኩሎኤ መንቹ ለዕዬ፤ አይደጎ እስ መሲህት ጎር?» ይት ኩልቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","መኑንኩ ከተሚች ፉል እስበ መረኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ህከ ወክትንከ አሳ «አስበስ አስተማርቾ! እቸተ እት» ይት ኡጭቶስ። ");
INSERT INTO alw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ጠዉ እኮጎሬ ኢስ እሳሃ «አዕኑ ደጌንቡ አን እታም እቸት ዮኤ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","አሳበስ ገገዉንኩሰን «መኑ እቸተ ኤቦስጎሬ?» የቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ኢስን ፈንቀሽ «ኢ እቸት ሶኮኤሀን ቀልብስ ጠወ ዊንሾሃለከ ሆጉስ ሹል አኡሃን። ");
INSERT INTO alw_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","አዕኑ ‹ምዴኖ ወክቱ ኢሎተ ሾሉ አገኑ ፈቆኡ› ይቴነንታበእንዶ? እኮጎሬ አን እልክዕኔ አሌ ዋሽቴን ውጠተ ምዴኖገ ሆንጠሁስ ለእዬ ያንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ምደኖሁ ሆጎስ ሁንክ ኣአኖ፤ ዘላለሚሃ ሄኡ እሀኖ ላልቹ ጭምአአኖ፤ ህካን እኮቤቺሃ ዉጠኖሁለከ ምደኖሁ ሜጡበ ሙንደኣአ። ");
INSERT INTO alw_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","‹መቱ ውጠኖ፤ ዎሉስንገ ምደኖ› የመሞሁ ሀንቅ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","አንን አዕኑ ኦርጨቀንቴንታበኢሃ ምዶኖተ ሶኮንክዕኔ፤ ዎሉ መኑ ህከን ሆጎን አበ ሆጎኡ፤ እሰ ሁንኪን አዕኑ ደግለሸቀንቴንታአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ህት መንቹንት «አዕዮም ጠወ ጉዕመንከ ኩሌኤ» ይት መሰከርቶ ጠወ ሞጮጭቶ ህከን ከተማን ሄኣ ልግቡ ሰማር ባድ መኑ እሲን አመዕንቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ሁኩ መኑንኩ ኢስበ አሜቶ ወክት እሰቤቾን አፉዕሎተ ኡጭቶስ፤ እስን ለሙ በር ህከን ቤቾን አገሮ። ");
INSERT INTO alw_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","እስ ጠወዕዮ ጠውተኔሃ ዎሉ ልግቡ መኑሁ እሲን አመዕንቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","እሰን መንቹተ «ነኡ ቴሱ እሱ አመዕንናሚሁ አት ኩልቶንትኔቤቺሃ እሁዕነ ነኡ ገውንኩኔ እሲች ሞጮጭኖምቤቺሃትለከ እስ ሀንቅንከ ከን ኣዱንያ አሊሃ ጡምሳንቹ እሁስ ደንጎምቤቺሃት» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ኢስ ሰማር ባዶን ለሙ በር ዱንኬኢች ኤተሮን ገሊለ ባዱ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ኢስ «ነብዬቹ ገይስ ባዶን ከበጀመኖበአ» ይ ጠወዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ጠዉ እኮጎሬ እስ ገሊለ ባዱ አሜቾ ወክት መኑ ጡመ ሃሊን ቶጎስ፤ መሰንትስ እሰን ሻሽግ ከበጀተ ከበጅቶተ ዬሩሳሌመ መርቶ ወክት እስ ህከጴ አዕዮ ጠወ ጉዕመንከ ለኦ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ህከኒች ኤተሮን ኢስ ዋሃ ዎይን ጠጀ አዕዮ ገሊለ ባዶን ሄዕዮ «ቃነ» ዬኖቤቹ ለንኪሃ መሮ፤ ህከ ወክት ቅፍርናሆማን ቤቱስ ጥዦ መቱ ዎም ምኒ ሹሙ ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","እስን ኢስ ይሁድ ባዲች ገሊለ ባዱ አሜቱስ ሞጮጭ ኢስበ ኦሮዕዮ፤ ሬሀኖ ጌሰ ጥዦ ቤቱስ ቅፍርናሆመ መር ፈይሶስተ ኢሰ ኡጬስ። ");
INSERT INTO alw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ኢስን «አዕኑ መላተለከ አጀብሲሰኖርቹ ለኤንባች አመዕንቴነንተበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ሁኩ ሹሙንኩ «ቀርቾ! ቤቱእ ሬሁዕናን ኢንን ደዕልት ኬእ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ኢስን «ምንክ ኦሮእ፤ ቤቱክ ፈየኖ» ዬስ፤ መንቹንኩ ኢስ ዬኢሃ አመዕን ምንስ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","እስን ምንስ መረን ዎቄ አሌን ሄዕዮገን ካዲመስ ደቀንት «ቤቱክ ፈይዮኡ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","መንቹንኩ ቤቱስ ፈዬኢሁ ሄንከ ሳኣቴን እኮጎር ጠዕሜሰ፤ እሰን «ደሙምት አጉርቶሲሁ ቤሬተ ለመለ ሳኣቴኒት» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ጩልስ አኑንኩ ኢስ «ቤቱክ ፈየኖ» ዬ ወክቴን እሁስ ደጎ፤ ህካን እኮቤቺሃ ሁኩ መንቹለከ ምንስ አበሮሱ ኢሳን አመዕንቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ሁኩ አጀብሲሰኖ ጠዉ ኢስ ይሁድ ባዲች ገሊለ ባዱ አሜቾ ወክት አዕዮ ለንኪሃ አጀብሲሰኖሃ ጠወ። ");
INSERT INTO alw_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ህከኒች ኤተሮን አይሁድ ከበጀት ከበጄኖ ወክቱ ኢሌቤቺሃ ኢስ ዬሩሳሌመ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ዬሩሳሌማን ሆለ ኡሮ መዴን እብራዌ መን አፎን «ቤተ ሳይዳ» ዬኖቤቾን መት ቡቁት ሄኦ እቅ፤ ህከኔን ኣጌኖ ኦንት ጎልጌ ኡሩት ሄኦ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ህከንቤቾንን ልግቡ ጥዘናመተ፥ ቆቃኑተ፥ ድናኑተለከ ናፋኑተ ህከን ህጌኖ ኦንቴ ጎልጌ ኡሮን ኦሰእ ውሁ ሌንቄቀኖገ አገርታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","መት-መቱ ወክት ቀርች መላይኬቹ ድር ህከ ዋሃ ሌንቄቅሰኖ እቅ፤ ሁኩን ሌንቄቄኢች ኤተሮን ሄጭ ህከ ዊ ኣዝ ኣጎ መንቹ ዮስ ጥዘናች ፈየኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ህከንቤቾንን ሰጅኔ ህዜቱ ዘማን ጥዦ ጥዘናሙ ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ኢስን ሁኩ መንቹ ህከኔ ኦሰዕዮሃ ለዕይ ልግብያ ዘማኒች ኬሽ ጥዦ እሁስ ደግ «ፈይቶተ ሀሰንንዶ?» ይ ጠዕሜስ። ");
INSERT INTO alw_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ሁኩ ጥዘናሙንኩ «ቀርቾ! ውሁ ሌንቄቄ ወክት ኤሳሃ መስ ህከን ዋን ኣግሰኖኤ መኑ ዮኤበአ፤ አን መሮተ እሀንን ዎሉ መኑ ኤሳሃ ሄጭ ኣገኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ኢስን «ኬእ! ኦሰኦንት ዴሰክ እጅት ኦሮእ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ሁኩ መንቹ ወክትንከስ ፈይ ዴሰስ እጅ ኦሮዕዮ፤ ሁኩንን እኮሁ ፎሎጭ በሬኔት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ህካን እኮቤቺሃ አይሁድ አዎንሳኑት ህከን ጥዘናች ፈዬ መንቺን ደቀንት «ከበር ፎሎጬኖ በር እኮቤቺሃ ኦሰኦንት ዴሰ እጁ ሕጉ ፈቀደኖሄበአ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ጠው እኮጎሬ እስ «ኤሳሃ ፈይሾ መንቹ ‹ዴሰክ እጅት ኦሮእ› ዬኤ» ይ ፈንቀሼሰ። ");
INSERT INTO alw_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","እሰን «ዴሰክ እጅት ኦሮእ ዬሄ መንቹ አዬት?» ይት ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ህከን ቤቾን መኑ በተዕዮቤቺሃለከ ኢስ ህከንቤቺች ዎሉቤቹ ኦሮዮቤቺሃ ሁኩ መንቹ ፈይሾሲሁ አዬት ጎር ደጎበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ህከኒች ኤተሮን ኢስ ህከን መንቺን መገን ምኔን ደቀም «ቴሱ ፈይቶንት፤ ከኒች ኤተሮን ባሰኖርቹ አፈኖሄበእገ ጩብ አቶት» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ሁኩ መንቹንኩ ፈይሾሲሁ ኢሰ እሁስ መር አይሁድ ሹማተ ኩሎሰ። ");
INSERT INTO alw_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ህትኔ ጠወ አበ በሬን አዕዮቤቺሃ አይሁድ ሹመት ኢሰ ሂለ ጠዊን ሆችታሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ጠዉ እኮጎሬ ኢስ «አኑኤ ጉዕመረን አአኖት፤ ህትን አኒሁ አኣሚት» ይ ፈንቀሼሰ። ");
INSERT INTO alw_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ኢስ ህት ዩስ አይሁድ አዎንሳኑት እሱ ሽቶተ አበ ኬሰንሴሰ፤ መሰንትስ እስ አበ በሬን ጠለዕል ሆጉተ አኡ እሁዕነ «መገኑ አናኤ» የን ገዉስ መገኒን ቅጥ አዕዮቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ኢስን ፈንቀሽ «ሀንቅንከ ያንክዕኔ፤ አኑ አአን ለዕዮሃ አእ ቤሉ ቤቱ ገይንከስ መቱርቹሃ አአኖበአ፤ አኑ አአኖሃ ቤቱሁ ህትን እስገን አአኖ። ");
INSERT INTO alw_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","መሰንትስ አኑ ቤቱስ ኢተኖ፤ ህትን አአኖሃ ጉዕመንከ እሲሃ ለሊሰኖ፤ አዕኑን አጀብሲጭቶኖተ ከኒች በተአኖሃ ለሊሰኖስ። ");
INSERT INTO alw_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","አኑ ሬሆች ኬሽ ሄኡ ኣሰኖሰገን ቤቱሁ ህትን ኣሶተ ሀሾ መኒሃ ሄኡ ኣሰኖ። ");
INSERT INTO alw_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","አኑ አዬ አሌኒ ፈረደኖበአ፤ ጠዉ እኮጎሬ ፈረዶተ አታለኖ ዎልቀተ ጉዕመንከ ቤቲሃ ኣስዮስ። ");
INSERT INTO alw_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ካን አዕዮሁ መኑ ጉዕሙንኩ አነ ኬዕምሰኖገን ቤቱሃ ኬዕምሶታት፤ ቤቱ ኬዕምስባሁ ሶኮስ አነሃ ኬዕምሰኖበአ። ");
INSERT INTO alw_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«ሀንቅንከ ያንክዕኔ፤ ላገእ ሞጮጨኖሀኒሃለከ ሶኮኤሃ አመዕነኖሀኒሃ ዘላለሚሃ ሄአኖ ሄኡ ሄአኖስ፤ እስ ሬሆች ሄኦን ህጎ ቤሉ ፈረደመኖስበአ። ");
INSERT INTO alw_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ሀንቅንከ ያንክዕኔ፤ ሬቶእሩ መገን ቤት ላገተ ሞጮጭታ ወክቱ አሜተኖ፤ ወክቱንኩስ ከኒት፤ ሞጮጭታእሩ ፎልን ሄኣአ። ");
INSERT INTO alw_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","መሰንትስ አኑ ሄእ ቡቁተ እኮገን ቤቱሁ ሄእ ቡቁተ እሀኖገ አዕዮስ። ");
INSERT INTO alw_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ህትን አኑ ዊመ ዎልቀተ ኣሴስ ቤቱስ እስን መንች ቤቱ የመመኖሁ ፍርደ ፈረዶተ ሹምነቱ ኣስዮስ። ");
INSERT INTO alw_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ከኒን አጀብሲጭቶኖቼ፤ ሎድ ኣዜን ሄኦእሩ እስ ላገተ ሞጮጭት ሎዲች ፉልታ ወክቱ አሜተኖ። ");
INSERT INTO alw_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ጡመ ሆጉተ አቶእሩ ሬሆች ኬእ ፎሊን ሄኣአ፤ ጠዉ እኮጎሬ ሂለ ሆጉተ አቶእሩ ሬሆች ኬኣን አሌሰ ፈረደመኖሰ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ህትን ኢስ «አን ገይእ ዎልቃን መቱርቹሃ አኦተ አታላምበአ፤ ጠዉ እኮጎሬ አኒችኤ ሞጮጬሚሃ ፈረዳም፤ ሶኮኤሀን ሃሽኣቶ ቤሉ ገይኤ ሃሽኣቱተ ዊንሻምበእቤቺሃ ፍርዱእ ሀንቅሃን። ");
INSERT INTO alw_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«አን ገይኤተኔ መሰከሮም ጎሬ ምስክሩስ ሀንቅ እሁስ ለለኖበአ። ");
INSERT INTO alw_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ጠዉ እኮጎሬ ኢተኔሃ መሰከረኖሁ ዎሉ ዮኡ፤ እስን ኢተኔሃ መሰከረኖ ምስክሩ ሀንቅ እሁስ ደጋም። ");
INSERT INTO alw_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","አዕኑ ያህይቤቹ ሶቀማኑተ ሶኬንታአ እቅ፤ እስን ሀንቅተኔሃ ኩሎህዕኔ። ");
INSERT INTO alw_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","አን መን ምስክር ቶጉ ሀስሰኖኤበአ እቅ፤ ጠዉ እኮጎሬ አዕኑ ጡምቶኖተ ይ ከ ጠወ ያም። ");
INSERT INTO alw_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ያህይ ቡበኖለከ ለሊሰኖ ኩራዝጋት፤ አዕኑ ቀዎ ወክቲሃ እስ ኑሬን ሙንደኤነንተ። ");
INSERT INTO alw_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ጠዉ እኮጎሬ ኤሳሃ ያህዪች በተአኖ ምስክሩ ዮኤ፤ ሁኩንን ሹል አኦተ አኑኤ ኣስዮኤተ ሆጉ፤ ሁኩ አን አኣም ሆጉት አኑኤ ኤሳሃ ሶሁስ ለሊሳእተ። ");
INSERT INTO alw_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ኤሳሃ ሶኮ አኑኤ ገዉንኩስ ኢተኔሃ መሰከሮኡ፤ እኮጎሬሁ አዕኑ ላገሲ ሞጮጭቴንታበአ፤ ህትን ገዉሲ ለኤንታበአ። ");
INSERT INTO alw_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","እስ ሶኮሀኒን አመዕንቴነንተበእቤቺሃ እስ ላገት ክዕኔቤቾን ሄኣበአ። ");
INSERT INTO alw_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","አዕኑ ዘላለሚ ሄኡ ጠሊለ መጻፋች ደዕቴነንታሃ አጉጃንክዕኔ እሰተ መረመርቴነንታት፤ እሳሁ ኢተኔ መሰከርታእራን። ");
INSERT INTO alw_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","እኮጎሬሁ አዕኑ ሄኡ ደዕቶኖተ ኢቤቹ አሜቱ ግቤንታአ። ");
INSERT INTO alw_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«አን መኑ ኬዕምሶኤተ ሀሳምበአ። ");
INSERT INTO alw_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","እኮጎሬሁ ክዕኔኤ ቀልቤን መገን ኢተት ዮበኢሃ እሁስ ደጎም። ");
INSERT INTO alw_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","አን አንኤ ሱዕሚን አሜቾምጎሬሁ ቶጌንታኤበአ፤ ጠዉ እኮጎሬ ዎሉስ ገይስ ሱዕሚን አሜቻን ቶጌነንተስ። ");
INSERT INTO alw_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","አዕኑ መት-መቱክዕኔ ኬዕምሴንተሩለከ ሜጡዋ መገኒች ኬዕምኝ ሀሴንበሩ ሀት እኬን ኢን አመዕንቶኖተ አታልቴነን? ");
INSERT INTO alw_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","አን አንኤ ብሬን ኦዳሚሃ አጉዱንከህዕኔ፤ ኦደኖህዕኔሁ አዕኑ ተቢሳ አቴነንተ ሙሳት። ");
INSERT INTO alw_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","አዕኑ ሙሰ አመዕንቴንተ እቃ ኤሳሁ አመዕንቴነንተ እቅ፤ መሰንትስ እስ ኢተኔሃ ከተቦኡ። ");
INSERT INTO alw_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","እስ ከተቦሃ አመዕንቴንባች ኢ ላጋን ሀት እኬን አመዕንቶኖተ አታልቴነን?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ህከኒች ኤተሮን ኢስ «ጥባሮሰ ህከረንገ ገሊለ» ዬኖ ባር ዉድ አደ ቶሎ። ");
INSERT INTO alw_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ኢስ ጥዘናመተ ፈይሻን አጀብሲሰኖ ጠወ ለኦ ልግቡ መኑ አዎንቶስ። ");
INSERT INTO alw_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ኢስ ቆተ አል ፉል አሳባንተስን ሜጡበ አፉዕሌእ። ");
INSERT INTO alw_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","አይሁድ ሻሽግ ከበጃቱ ሆንጠኮ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ህከ ወክት ኢስ ልግቡ መኑ እስበ አሜተን ለዕይ እልስ አሌ ዋሽ ፍልጶሴ «ካን ጉዕማንከ መኒሃ እታ እቸተ ሀከን አዲች ህዕርኖተ አታልናም?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ኢስ ህት ዬኢሁ ፍልጶስ የኖሃ ለኦታት ቤሉ እስ አኡ ሀስሰኖሲሃ ገዉንኩስ ደገኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ፍልጶስን «መት-መትሀሰ ቀዉ ቀዉ እልሲሃ ለሜ ጥቤ ዲናር እቸቲ እካሰበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","አሳባች መቱ ስሞን ጴጥሮሴ አመቤቱ እንድርያስ ");
INSERT INTO alw_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«ከኔ ኦንቶ ሶእ ጣብተለከ ለም ቁርጩሜተ አፎ መቱ ጩሉ ዮኡ፤ ጠው እኮጎሬ ኩን ከን ጉዕማንከ መኒሃ ሀት እክ እሀኖ?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ኢስን «መኑ አፉዕለኖገ አዕዬ» ዬሰ፤ ህከን ቤቾን ልግቡ ህጥት ሄኦ እቅ፤ ኦንቶ ኩሜ ጌሱ ጎኑ ህከኔ አፉዕልዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ህከኒች ኤተሮን ጣብተ ኬሽ መገኑ ገለትጭ አፉዕሌ መኒሃ ኣሴእ፤ ህትን ቁርጩሜተ ጉዕሚንከሰ ሀስሰኖሰ ጌሰ ኣሴእ። ");
INSERT INTO alw_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ጉዕሙንኩ እት ዱቦች ኤተሮን ኢስ አሳባተስ «መቱርቹሁ ፈቁዕናን ፈቆ ፉርፉሩ መጤን ጭምአዕዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","እሰን ኦንቶ ሶእ ጣብቲች መኑ እች ዱባን ፈቆ ፉርፉሩ ቶነ ለሙ መሶበ ዊመ ኬሶኡ። ");
INSERT INTO alw_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","መኑንኩ ኢስ አዕዮ አጀብሲሰኖ ጠወ ለኦ ወክት «ሀንቅንከ ኩን ኣዱንያ አል አሜተኖሃ ነቢዬቹ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","እኮጎሬ ሁኩ መኑ ዎመ አቶተ ሰውይቶገ ደግ ኢስ ሜጥሀስ ቆተ አል ዋል እሳች ገበጭ ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ሀዎሬ ወክት አሳበስ ገሊል ባር ቤቹ ድርቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","እሰን ጀልባን ኣግ ቅፍርናሆመ መርቶተ ኬኦኡ፤ ሁኩ ወክቱ ኡለት ቱንስቹሃ እቅ፤ ህትን ኢስ እሰበ አሜቾበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ቦብሩ አበ ቦብርሰኖቤቺሃ ባሩ ሌንቄቀኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","አሳበንት ኦንቱ ህከረንገ ሌሁ ኪሎ ሜትረ ባር አሌን ሃንቶኢች ኤተሮን ኢስ ባር አሌን ሃመን ህከ ጀልብ ቤቹ ሆንጠኮ ወክት ለእ ዋጅቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ጠዉ እኮጎሬ ኢስ «አኔት! ዋጅቶኖቼ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","እሰን ሙንዲኖን ጅልብ ኣዝ ኣግሶስ፤ ጀልቡንኩ ወክትንከስ እሰ መርታቤቹ ኢልሾሰ። ");
INSERT INTO alw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ለንክ በር ባር ዉድ አዲን ፈቆ መኑ ባር አሌን ጠለዕል መቱ ጀልቡ ፈቆገ ለኦ እቅ፤ ህትን ሜጢሃሰ አሳበት መሩሰለከ ኢስ እሳን ሜጡበ መርከባን ኣጉዕነ ፈቁስ ደጎ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ጠዉ እኮጎሬ ዎሉ መርከቡ ጥባሮስ ከተሚች ኬዕይ ኢስ መገኑ ገለትጬለከ ኡመቱ ጣብተ እቶ ቤቹ መድስ አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ሁኩ መኑንኩ ኢስ ህከረንገ እስ አሳበት ህከን ቤቾን ሄኡ ሆጉሰ ለኦ ወክት ህከን መርከባን ኣግ ኢሰ ሀሶተ ቅፍርናሆመ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ባር ዉድ አዲን ደጎስ ወክት «አስተማርቾ! መ ወክት ከቤቹ ኢልት?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ኢስን ፈንቀሽ «ሀንቅንከ ያንክዕኔ፤ አዕኑ ኤሳሃ ሀሴነንታሁ ጣቢተ እትሾንክዕኔቤቺሃትለከ ዱቤንተቤቺሃት ቤሉ አን ለሊሾንክዕኔ አጀብሲሰኖ ጠውሃበአ። ");
INSERT INTO alw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","መንች ቤቱ ኣሰኖህዕኔ ዘላለሚሃ ሄኣ ሄእ እቻተ አዕዬ ቤሉ በኣ እቻተ አቶኖቼ፤ እስን አኑ መገኑ ቤቲሀስ አዕዮ ሀንቅተ መላ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ሁኩ መኑንኩ «መገን ሆጉተ አዕኖተ መ አኡ ሀስሰኖኔ?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ኢስን ፈንቀሽ «መገን ሆጉት መገኑ ሶኮሀኒን አመዕኑሃን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","እሰን ፈንቀሽት «ነኡ ለእን ኪን አመዕንኖተ መ መላተ አስተን? ህትን መ አተን? ");
INSERT INTO alw_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","‹እቶተ ሰሜች እቸተ ኣሴእ› የመም ከተበሞገን አናከኔ ኡለ ኡድማን ‹መና› ዬኖ እቸተ እቶኡ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ኢስ «ሀንቅንከ ያንክዕኔ፤ ሰሜች እቸተ ኣሰኖሁ ሙሳበአ፤ ጠዉ እኮጎሬ ሀንቅ እቸተ ሰሜች ኣሰኖህዕኔሁ አናኤ። ");
INSERT INTO alw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","መሰንትስ መገኑ ኣሰኖ እቸተ ሰሜች ድርታእተለከ ኣዱንያ አሊሃ ሄኡ ኣስታእታን» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","እሰን «ቀርቾ! ከ እቸተ ጉዕመ ወክትንከ ኣስኔ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ኢስን ፈንቀሽ «ሄእ እቸት አኔት፤ ኢቤቹ አሜተኖሁ ሆሮን ጎሩ አፈኖስበአ፤ ኢን አመዕነኖሁ ሆሮን ሰገበኖበአ። ");
INSERT INTO alw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ጠዉ እኮጎሬ ‹አዕኑ ኤሳሃ ለኤን አመዕንቴንታበአ› ዬንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","አኑኤ ኣሰኖኤሁ ጉዕሙንኩ ኢቤቹ አሜተኖ፤ አንን ኢቤቹ አሜተኖሃ ጉዕመንከ አብል ዋሽ ቶቻንስበአ። ");
INSERT INTO alw_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","አን ሰሜች አሜቾሚሁ ሶኮኤሀን ሃሽኣቱተ ዊንሾታት ቤሉ ገይኤ ሃሽኣቱተ ዊንሾታበአ። ");
INSERT INTO alw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ሶኮኤሀን ሃሽኣቱት ኣሴኤ መኒች መቱሃ ቤሱዕናን ቂያመ በር ሬሆች ኬሶታት። ");
INSERT INTO alw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","አንኤ ሃሽኣቱት ቤቱስ ለዕይ እሲን አመዕነኖሁ ጉዕሙንኩ ዘላለሚሃ ሄአኖ ሄኡ ደኦታት፤ አንን ቂያመ በር ሬሆች ኬሳንስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ኢስ «ሰሜች ድርቶ እቸት አኔት» ዬቤቺሃ አይሁዱ እስ አሌን ቁንቁቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","እሰን «ኩን ነኡ አነስለከ አመስ ደንጋም ዩሱፍሃ ቤቱ ኢሳበእንዶ? እስ ሀት ‹አን ሰሜች ድርዮምሃን› የኖት?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ኢስን ፈንቀሽ «መት-መቱክዕኔ ቁንቁቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ኤሳሃ ሶኮ አኑኤ ኢ አደ ኤቦሀን ቤሉ አዪሁ ኢቤቹ አሜቶተ አታለኖበአ፤ ኢቤቹ አሜተኖሃ አንን ቂያመ በር ሬሆች ኬሳንስ። ");
INSERT INTO alw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ነቢያካ መጻፋን ‹ጉዕሙንኩሰ መገኒች ተማርቶረ እካአ› የመም ከተበሞኡ፤ ህካን እኮቤቺሃ መገኒች ሞጮጬኢሁለከ ተማሮሁ ጉዕሙንኩ ኢቤቹ አሜተኖ። ");
INSERT INTO alw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ጠዉ እኮጎሬ አነ ለዕዮሁ አዪሁ ዮበአ፤ መገን አዲች እኮሁ ጠለዕሉ አነ ለዕዮሃን። ");
INSERT INTO alw_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ሀንቅንከ ያንክዕኔ፤ ኢን አመዕነኖሀኒሃ ዘላለሚሃ ጉዕሚንከ ሄአኖ ሄኡ ዮስ። ");
INSERT INTO alw_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ሄእ እቸት አኔት። ");
INSERT INTO alw_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","አናከክዕኔ ኡለ ኡድማን ‹መና› ዬኖ እቸተ እቶኡ፤ እሰን ሬቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ሰሜች ድርቶ እቸት ተኒት፤ ከኒች እተኖሁ አዪሁ ሆሮን ሬሀኖበአ። ");
INSERT INTO alw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ሁኩ ሰሜች ድርቶ ሄእ እቸት አኔት፤ አዪሁ ህከን እቻች እቾጎሬ ዘላለሚሃ ጉዕሚንከ ሄአኖ፤ አንን ኣዱንያ አሊሃ ኣሳም እቸት ገግኤ ማላኤ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ህከ ወክት አይሁዱ «ኩ መንቹ ማለስ እንቶተ ኣሶተ ሀት አታለኖ?» ይተን መት-መትንከሰ ኦደቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ኢስን «ሀንቅንከ ያንክዕኔ፤ መንች ቤት ማለ እቴንባችለከ ቄጉስ አጌንባች ክዕኔሃ ሄኡ ኣዜክዕኔ ዮህዕኔበአ። ");
INSERT INTO alw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ኢ ማለ እተኖሀኒሃለከ ቄጉእ አገኖሀኒሃ ዘላለሚሃ ጉዕሚንከ ሄአኖ ሄኡ ዮስ፤ አንን ቂያመ በር ሬሆች ኬሳንስ። ");
INSERT INTO alw_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","መሰንትስ ማሉኤ ሀንቅተ እቸ፤ ህትን ቄጉንኩኤ ሀንቅሃ አጌኖሃን። ");
INSERT INTO alw_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ማላኤ እተኖሁለከ ቄጉኤ አገኖሁ ኢን ሄአኖ፤ አንን እሲን ሜጡበ እሃም። ");
INSERT INTO alw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ሄአኖ አኑኤ ሶኮኤቤቺሃ አን እሲን ሄኣሚሃ እኮምገን ህትን ማላኤ እተኖሁ ኢ አዲን ሄአኖ። ");
INSERT INTO alw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ሰሜች ድርቶ እቸት ተኒት፤ ሁኩንን አናከክዕኔ እቶኢሃ አጉድበሃን፤ መሰንትስ ህከ እቸተ እቶእሩ ሬቶኡ፤ ከ እቸተ እቶእሩ ዘላለሚሃ ጉዕሚንከ ሄኣአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ኢስ ህካን ዬኢሁ ቅፍርናሆማን ሄዕዮ ጭምት ምኔን ተማርሰኒት። ");
INSERT INTO alw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","አሳባች ልግቡሰ ህካን ሞጮጭቶ ወክት «ኩ ትምርቱ አበ ኬዕመኖሃን፤ ከ ትምርት አይ ቶጎተ አታለኖ?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ጠዉ እኮጎሬ ኢስ አሳበስ ከን ትምርትተኔሃ ቁንቁቶገ አያኒንከስ ደግ «ኩን ሉሲሰኖህዕኔንዶ? ");
INSERT INTO alw_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","መንች ቤቱ ወዕና ሄዕዮቤቹ ፈንቀል ፉለን ለኤንተጎር መ ይቶኖታት? ");
INSERT INTO alw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ሄኡ ኣሰኖሁ መገንየ አያነ፤ ጠዉ እኮጎሬ ማሉ ሜጡራ ደግለለኖበአ፤ አን ክዕኔሃ ጠወዕዮም ላገት አያነለከ ሄኦሃን። ");
INSERT INTO alw_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ጠዉ እኮጎሬ ክዕኔ በሊች አመዕንትቡሩ ዮኡ» ዬሰ፤ ኢስ ካን ዬኢሁ ወዕኔችን ኬሽ አመዕንትበሩ አዬኤታጎሬ ህትን ህግሽ ኣሰኖሁ አዬት ጎሬ ደገኖቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ህትን ኢስ « ‹አኑኤ አሜተኖገ አዕዮሀን ቤሉ ዎሉ ኢ አደ አሜቶተ አታለኖበአ› ዬሚሁ ከኒሃት» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ህካን እኮቤቺሃ አሳባች ልግቡ ፈንቀልት መርቶኡ፤ ህከኒች ኤተሮን ኢሰ አዎኑ አጉርቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ህካን እኮቤቺሃ ኢስ ቶነ ለሙንከ አሳበተ «አዕኑሁ መርቶኖተ ሀሴነንንዶ?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ስምዖን ጴጥሮስን ፈንቀሽ «ቀርቾ ነኡ ሀከቤቹ መርናም? ኬሳሃ ዘላለሚሃ ጉዕሚንከ እካ ሄእ ላገት ዮሄ። ");
INSERT INTO alw_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ነኡ አት መገን ጠሊለ እሁክ አመዕንን ደንጎም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ህትን ኢስ «አን ክዕኔተ ቶነ ለሙንከክዕኔ መጠርበህዕኔንዶ? ክዕኔች መቱ እልቢስሃ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ካን ዬኢሁ ስሞኔ ቤት አስቆሮንቶ ይሁድተኔሃት፤ መሰንትስ ይሁድ ቶነ ለሞንከ አሳባች መቱስ እኮጎሬሁ ኢሰ ህግሽ ኣሰኖሁ እሱ እኮቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ህከኒች ኤተሮን ኢስ ገሊለ ባዶን ሃመኖት እቅ፤ መሰንትስ አይሁድ አዎንሳኑት ሽቶተ ሀሶስቤቺሃ ይሁድ ባዶን ሃሞተ ሀሾበአ። ");
INSERT INTO alw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ህከ ወክት አይሁድ ዳስ በአሉ ሆንጠኮ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ህካን እኮቤቺሃ አመስኦሱት «አዎንታሄሩ አት አታንት ሆጉተ ለኦተ ከንቤቺች ኬእ ይሁድ ባዱ ኦሮእ። ");
INSERT INTO alw_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","መሰንትስ ለሎተ ሀሰኖ መንቹ ሆጉስ ማጭ አኦተ ሀሰኖበአ፤ አት ካን ጉዕመንከ አተን ገዉክ መኒሃ ጉዕሚንከ ለሊሱ ሀስሰኖሄ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ህካን ይቶኢሁ ዎሉ ፈቅ አመስ ኦሱንት እሲን አመዕንትበቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ህካን እኮቤቺሃ ኢስ «ኢ ወክቱ ኢልዮበአ፤ ጠዉ እኮጎሬ ክዕኔሃ ጉዕሙንኩ ወክቱ መክዮእሃን። ");
INSERT INTO alw_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ኩ ኣዱንያ አሉ ክዕኔተ ግቦህዕኔተ አታለኖበአ፤ ጠዉ እኮጎሬ ኤሳሃ ግበኖ፤ መሰንትስ አን ሆጉስ ሂለ እሁስ ኩላምቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","አዕኑ ህከ ከበጀተ ከበጄኖቤቹ አሌ ዋልቴን መሬ፤ ወክቱእ ኢልበቤቺሃ አን ህከ ቤቹ መሮተ አታላምበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ኢስ ህካን ይ ገሊላን ፈቆ። ");
INSERT INTO alw_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ጠዉ እኮጎሬ አመስ ኦሱት ህከ ከበጃት ከበጄኖቤቹ መርቶች ኤተሮን እስ ህከ ቤቹ ለሉዕናን ማጠም ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ህከን ከበጀ ቤቾን አይሁድ ሹመት «እስ ሀከበ ዮኡ?» ይተን ሀሳሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","አይሁድ ኡመቱ ህከን ቤቾን እስተኔ ኩሽኩሽይተን መት-መቱሰ «እስ ጡማ መንቹ» ይተን ዎሉሰንገ «ህትጎተበአ እስ መነ ሉሲሰኖሃን» ይታሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ጠዉ እኮጎሬ አይሁድ ሹመት ዋጅቶቤቺሃ አዪሁ እስተኔሃ ለሊሽ ጠወዕዮበአ። ");
INSERT INTO alw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ህከ ከበጀት ከበጅተን ደሩ እኮሀኒን ኢስ አሌ ዋል ዱእ ምኒ መር ተማርሴእ። ");
INSERT INTO alw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ህከንቤቾንን አይሁድ ሹመት «ኩ መንቹ ተማርባሃ ከ ጉዕመንከ ሀት ደጎተ አታሎ?» ይተን አጀብሲጭታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ህካን እኮቤቺሃ ኢስ ፈንቀሽ «አን ተማርሳሚሁ ኢች እሁዕነ ኤሳሃ ሶኮኤሀኒቺት። ");
INSERT INTO alw_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","መገን ሃሽኣቱተ አኦተ ሀሰኖሁ አዪሁ ኩ ትምህርቱ መገኒች አሜቾሃ እሁስ ህከረንገ አን ገይችኤ ጠወኣምጎሬ መለል ደገኖ። ");
INSERT INTO alw_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ገይችስ ጠወአኖሁ ገይሀስ ኬዕምኝ ሀሰኖ፤ ጠዉ እኮጎሬ ሶኮስሀን ኬዕምኝ ሀሰኖሁ ሀንቅየ መንቹ፤ ክዝቡንኩ እሲን ዮስበአ። ");
INSERT INTO alw_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ሙስ ሕገ ኣስዮህዕኔበእንዶ? እኮጎሬ ክዕኔኤች መቱክዕኔሁ ሕገ አገርቴንበረ፤ ሚሃት ሽቶኖኤተ ሀሴነንተኤሁ?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ኡመቱንኩ ፈንቀሽ «ኬሳሃ ዱሩ አፎሄ፤ ኬሳሃ አይ ሾሄተ ሀሾሄ?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ህትን ኢስ «አን መት ሆጉተ አዕዮም፤ አዕኑ ጉዕሙንኩ ህከኒን አጀብሲጭቴንታአ። ");
INSERT INTO alw_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ሙስ ጡርከም ሴረ ኣስዮህዕኔ፤ ሁኩንን አናካቺት ቤሉ ሙሲችበአ፤ አዕኑ አበ በሬን ጡርከንቴነንታት። ");
INSERT INTO alw_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ሙሲ ሕጉ ድጀምበገ መኑ አበ በሬን ጡርከመኖ እኮች አን አበ በሬን መንች ዊመንከስ ጅስመ ፈይሾምቤቺሃ ኢን ሚሃት ኡሙዕርቴነንታት? ");
INSERT INTO alw_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ሀንቅ ፍርደ ፈረጄ ቤሉ መን እልተ ለኤን ፈረዶኖቼ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ዬሩሳሌም ከተማን ሄኦ መኒች መት-መቱሰ «ኩን ሽቶተ ሀሳስየ መንቹበእንዶ? ");
INSERT INTO alw_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ሁኩዕኑን እስ አልባሽ ጠወአኖት፤ እሰን መቱርቹሃ ይቶስበአ፤ ሹመት ኩ መንቹ መሲህ እሁስ ሀንቅንከ ደግትንዶ ጨለይቶኢሁ? ");
INSERT INTO alw_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ጠዉ እኮጎሬ ኩ መንቹ አሜቾቤቹ ነኡ ደንጋም፤ መሲሁ አሜተኖ ወክት እስ ሀከን አዲች አሜቾንዶ አዪሁ ደገኖበአ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ህካን እኮቤቺሃ ኢስ መገን ምኔን ተማርሰን ላገስ ጎት አዕይ «አን ሀከን አዲች አሜቾምጎሬ ኤሳሃ ደጌነንተ፤ ጠዉ እኮጎሬ አን ገይንከኤ አሜቾምበአ፤ ኤሳሃ ሶኮኤንኩ ሀንቅሃ፤ አዕኑ ደጌነንተስበአ። ");
INSERT INTO alw_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","አን እስ አዲች አሜቾምቤቺሃለከ እስን ኤሳሃ ሶኮኤቤቺሃ አን እሱ ደጋም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ህካን እኮቤቺሃ እሰን አፎስተ ሀሶኡ፤ እኮጎሬ ወክቱስ ኢልበቤቺሃ አዪሁ አፎስበአ። ");
INSERT INTO alw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","እኮጎሬሁ ኡመቲች ልግቡስ እሲን አመዕንት «መሲሁ አሜቾረ ኩ መንቹ አዕዮ አጀብሲሰኖ ጠዊች በተአኖሲሃ አአኖሃንዶ?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ፈርሳውት መኑ ኢስተኔሃ ኩሽኩሽ ይት ጠወአን ሞጮጭቶኡ፤ ህካን እኮቤቺሃ ቂስ አዎንሳኑትለከ ፈርሳውት ኢሰ አፍሲሶተ ወታደረ ሶኮኡ። ");
INSERT INTO alw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ኢስን «አን ክዕኔን ሜጡበ ቀዉ ወክት ዱንካም፤ ህከኒች ኤተሮን ሶኮኤሀኒቤቹ መራም። ");
INSERT INTO alw_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","አዕኑ ኤሳሃ ሀሴነንተ፤ እኮጎሬሁ ደጌነንተኤበአ፤ አን ዮም ቤቹንከ አዕኑ አሜቶኖተ አታልቴነንተበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ህካን እኮቤቺሃ አይሁዱ መት-መትሀሰ «ነኡ ደንግበስገ ኩ መንቹ ሀከቤቹ መሮታት? ህከረንገ ግሪክ መን በላን ሄኣ አይሁድቤቹ መር ግሪክ መነ ተማርሶታትንዶ? ");
INSERT INTO alw_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ህትን ኤሳሃ ‹ሀሴንተኤ ጎሬ ደጌነንተኤበአ፤ አን ዮም ቤቹ አሜቶኖተ አታልቴነንተበአ› ዩስ መ ዩሃስ?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ህከ ከበጀት ከበጄን ሹሌኖ ጎፍሜስ ሎረ በሬን ኢስ ኡር ላገስ ጎት አዕይ «ውሁ ሰገቦሲሁ ዮ ጎሬ ኢቤቹ አሜች አጉን። ");
INSERT INTO alw_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ኢን አመዕነኖሀኒች ጠሊለ መጻፋን የኖገን ሄእ ዊ ቡቁት ኣዚችስ ቡቃአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ህት ይ ጠወዕዮንኩ እሲን አመዕንቶሩ ኣእታ ጠሊለ አያንተኔሃት እቅ፤ መሰንትስ ኢሲ ኬዕምኝ ወክቱ እሉዕነ ዮቤቺሃ ጠሊሉ አያኑ ኣሰሞበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","መኒች መት-መቱ ህከ ጠወ ሞጮጭቶ ወክት « ‹አሜተኖ› የመሞ ነቢዬቹ ሀንቅንከ ከኒት» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ህትን ዎሉሰንገ «ኩን መሲህት» ይቶኡ፤ ጠዉ እኮጎሬ መት-መቱሰ «መሲሁ ገሊለ ባዲች አሜተኖንዶ? ");
INSERT INTO alw_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","መሲሁ ደዉዴ ዘሬች እለመኖገለከ ደዉድ እለሞ ቤተልሔም ከተሚች አሜተኖገ ጠሊለ መጻፋን ከተበሞበእንዶ?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ህካን እኮቤቺሃ መን በላን እስ መሳን መለዕለንሹ እኮኡ። ");
INSERT INTO alw_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","እሳችን መት-መቱሰ እሱ አፎተ ሀሶ እቅ፤ እኮጎሬ አዪሁ አፎስበአ። ");
INSERT INTO alw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ህከኒች ኤተሮን ወታደሩንኩ ቂስ አዎንሳኖበለከ ፈርሳዌቤቹ ፈንቀልት መርቶኡ፤ እሰን «እሱ ሚሃት ኤቤንታበኢሁ?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ወታደሩንኩ «ህከን መንችገ አዪሁ ጠወዕዮበአ» ይት ፈንቀሽቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ጠዉ እኮጎሬ ፈርሳውት «ክዕኔታሁ ሉስሾህዕኔንዶ? ");
INSERT INTO alw_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ሹማች ህከረንገ ፈርሳዌች እሲን አመዕኔኢሁ ዮጎር ደጌንታእንዶ? ");
INSERT INTO alw_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ጠዉ እኮጎሬ ኩ ሙስ ሕገ ደግቡ ኡመቱ ቦሮረሞእሃን» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ህከን መኒችን መቱስ ከኒች ብርንተ ኢስቤቹ መሮ «ንቆድሞሴ» ዬኖ ፈርሳውቹ ");
INSERT INTO alw_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«ሕግኔ ሃሊን መቶ መንች ጠወ ሞጮጩዕነለከ መ አዕዮ ጎሬ ደጉዕነ ፈረዱ ሀስሰኖንዶ?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","እሰን «አቲሁ ገሊለ ባዲችትንዶ? ነቢዬቹ ገሊለ ባዶን ነጶተ አታለኖበእገ መረመርት ለእ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","እሰን መት-መቲን ምነሰ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ህከኒች ኤተሮን ኢስ ዘይት ሀቁ ነጰኖ ቆተተ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ለንክ በር ሱጵተ ዱእ ምኒ ፈንቀል አሜቾ፤ ኡመቱ ጉዕሙንኩ እስበ አሜች ጭምዬሃን እስ አፉዕል ተማርሱ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ሕገ ተማርስታእሩለከ ፈርሳውት ዝነተ አተን አፎሴ መት መንቹተ ኤብ በላንከሰ ኡርሶኡ። ");
INSERT INTO alw_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","እሰን ኢሰ «አስተማርቾ! ት መንቹት ዝነተ አተን አፈንቶእተ። ");
INSERT INTO alw_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ህትኔ ጠወ አታ ሜንቱ ክኒን ቀሴን ሼኖገ ሙስ ሕጋን አዘዦኔ፤ አትንገ እሴተኔሃ መ ይተን?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","እሰን ህት ይቶኢሁ እሱ ኦደ ጠወ ደግ ፌተንቶተ ሀሶቤቺሃት እቅ፤ ጠዉ እኮጎሬ ኢስ ሙግይ ዙሩዕሜንከስ ኡለ አሌን ከተቡ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ፈንቀላንስት ጠዕምቶስ ወክት ሙግ ዬቤቺች ጎበስ ኬሽ «ክዕኔ በሊች ጩቡ ዮስበእ መንቹ ሄጭ ክኒን ቀሱን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ህከኒች ኤተሮን ለንኪሃ ሙግይ ኡለ አሌን ከተቡ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","እሰን ህካን ሞጮጭቶ ወክት ባሊቂች ኬሽ ሀርድ ኢለ መት-መትን ፉልት መርቶኡ፤ ህካን እኮቤቺሃ ኢስ ብሬስ ኡርቶ መንቾን ሜጥሃስ ፈቆ። ");
INSERT INTO alw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ህከኒች ኤተሮን ኢስ ጎበስ ኬሽ ለዕይ «ቴ መንቾ! ከሰሰኖሄ መኑ ሀከበ ዮኡ? አሌክ ፈረጆሁ መቱሁ ዮበእንዶ?» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","እሴን «ቀርቾ! መቱሁ ዮበአ» ይቶኡ፤ ኢስን ፈንቀሽ «አኒሁ ፈረዳንኬበአ ኦሮእ፤ ከኒች ኤተሪሃ ጩብ አቶት» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ለንኪሃ ኢስ «አን ከን ኣዱንያ አልሃ ኑርሃን፤ ኤሳሃ አዎነኖሁ ጉዕሙንኩ ሄእ ኑር ደአኖ ቤሉ ቱንስቾን ሃመኖበአ» ይ ጠወዕዮሰ። ");
INSERT INTO alw_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ፈርሳውት «አት ገይክተኔሃ መሰከርታንቲት፤ መሰከርቶንቲሁ ሀንቅሃበአ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ኢስን «መቱርቹሃ አን ገይሀእ መሰከሮም ጎሬ አን ሀከን አዲች አሜቾም ጎሬ ህትን ሀከ አደ መራም ጎር ደጋምቤቺሃ ምስክሩእ ሀንቅሃን፤ ጠዉ እኮጎሬ አዕኑ አን ሀከን አዲን አሜቾም ጎር ህትን ሀከ አደ መራም ጎር ደጌነንተበአ። ");
INSERT INTO alw_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","አዕኑ መኬህዕኔገ ፈረዴነንተ፤ ጠዉ እኮጎሬ አን አዬ አሌኒ ፈረዳምበአ። ");
INSERT INTO alw_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ፈረጆም ጎሬ ፍርዱእ ሀንቅሃን፤ መሰንትስ ፈረንዳሚሁ አኔትለከ አናኤ ቤሉ አን ሜጦሃኤበአ። ");
INSERT INTO alw_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ለሙ መንቹ መሰከሮች ጠዉስ ሀንቅ እሁስ ሕጋንከክዕኔ ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ህካን እኮቤቺሃ አን ገይኤተኔሃ መሰከራም፤ ህትን ኤሳሃ ሶኮኤ ኢ አኑሁ ኢተኔሃ መሰከረኖ» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","እሰን «አኑክ ሀከበ ዮኡ» ይት ጠዕምቶስ፤ ኢስን «ኤሳለከ አነኤ ደጌነንተበአ፤ ኤሳሃ ደጌንታ እቃን ኢ አነሃ ደጌነንተ እቅ» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ኢስን ህካን ጠወዕዮሁ መገን ምኔን ብረ ቶጌኖ ሳጥን መዴን አፉዕል ተማርሰኒት እቅ፤ እኮጎሬ ወክቱስ ኢልበቤቺሃ አዪሁ አፎስበአ። ");
INSERT INTO alw_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ለንኪሃ ኢስ «አን ኦሮኣም፤ አዕኑ ኤሳሃ ሀሴነንተ፤ ጠዉ እኮጎሬ ጩቢንከክዕኔን ሬቴነንተ ቤሉ አን ኦሮኣምቤቹ መርቶኖተ አታልቴነንተበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","አይሁድ አዎንሳኑት «እስ ‹አን ኦሮኣምቤቹ አዕኑ አሜቶኖተ አታልቴነንተበአ› ዩስ ገዉስ ሾታትንዶ?» የቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ህከኒች ኤተሮን ኢስ «አዕኑ ወሮን ከን ኣዱንያ አሊቺት፤ እኮጎሬ አን አሊቺት ቤሉ ከን ኣዱንያ አሊችበአ። ");
INSERT INTO alw_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","አን ክዕኔተ ‹ጩቢንከክዕኔን ሬቴነንተ› ዬሚሁ ከኒሃት፤ መሰንትስ አን ኤሳሃ እሁኤ ደጌን አመዕንቴንባች ጩቢንከክዕኔን ሬቴነንተ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","እሰን «አት አዬት?» ይቶስ፤ ኢስን «አን ወዕኔችን ኬሽ ኩሎንክዕኔጋት። ");
INSERT INTO alw_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","አን ክዕኔተኔሃ ያምርቹለከ ፈረዳምርቹ ልግቡ ዮኤ፤ እኮጎሬ ሶኮኤሁ ሀንቅሃን፤ አን ኣዱንያ አሊሃ ጠወኣሚሁ እሲች ሞጮጬሚሃት» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","እኮጎሬ እሰ እስ አኒተኔሃ ጠወዕዮሰገ ሰውይቶበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ህካን እኮቤቺሃ ኢስ «መንች ቤቱ መስቀላን አሌ ዋሽቴን አፉሽቴነንተ ወክት አን ኤሳሃ እሁኤ ደጌነንተ፤ ህትን ጠለዕል አኑኤ ተማርሴኤሃ ጠወዕዮምጋት ቤሉ ገይኤ ዎልቃን መቱርቹሃ አኣምበእገ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ኤሳሃ ሶኮሁ ኢኒንት፤ አን ጉዕመ ወክትንከ አኣም ጠዉ እሱ ሙንዲሲሰኖቤቺሃ ኤሳሃ ሜጡእ አጉሮኤበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ኢስ ህካን ጠወዕዮ ወክት ልግቡ መኑ እሲን አመዕንቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ኢስ ህከን አመዕንቶ አይሁዲሃ «አዕኑ ላጋንታኤ ሄኤንተ ጎር ሀንቅንከ አዎንቴነንተኤረ። ");
INSERT INTO alw_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","አዕኑ ሀንቅንከ ደጌነንተ፤ ሀንቁንኩ ሰዎልድማን ፉሸኖህዕኔ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ጠዉ እኮጎሬ እሰ «ነኡ እብራሂምተ ዘር፤ ኬንከ ኢለ አዬሁ ሮስ እንኮምበአ፤ አትንገ ‹ሰዎልድማን ፉልቴነንተ› ይታንቲሁ ሚሃት?» ይት ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ኢስን «ሀንቅንከ ያንክዕኔ፤ ጩብ አአኖሁ ጉዕሙንኩ ጩብሃ ሮስቹ። ");
INSERT INTO alw_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ካዲንቹ ቀርችስ ምኔን ዘላለሚሃ ሄአኖበአ፤ እኮጎሬ ቤቱ ዘላለሚሃ ምኔን ሄአኖ። ");
INSERT INTO alw_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ህካን እኮቤቺሃ ቤቱ ሰዎልድማን ፉሼህዕኔች ሀንቅንከ ሰዎልድማን ፉልቴነንተ። ");
INSERT INTO alw_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","አዕኑ እብራሂም ዘርተ እሁክዕኔ ደንጋም፤ ጠዉ እኮጎሬ ኢ ላገተ ቶጌንበቤቺሃ ኤሳሃ ሽቶኖተ ሀሴነንታት። ");
INSERT INTO alw_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","አን አንኤቤቾን ለዕዮምርቹ ጠወኣም፤ አዕኑ አኒችክዕኔ ሞጮጭቴንታሃ አቴነንተ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","እሰን «አኑኔ እብራሂማት» ይቶኡ፤ ህትን ኢስ «እብራሂም እለተ እኬንተ እቃን እብራሂም አዕዮሃ አቴነንተ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ጠዉ እኮጎሬ አዕኑ መገኒች ሞጮጬም ሀንቅ ኩሎንክዕኔረ ሽቶኖኤተ ሀሴነንታት፤ እብራሂም ህት አዕዮበአ። ");
INSERT INTO alw_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ህትን አዕኑ አንክዕኔገን አቴነንታት» ዬሰ፤ እሰን «ነኡ ህንጨረበሃበአ፤ መቱ አኑ ዮኔ፤ እስን መገኑሃ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ህትን ኢስ «መገኑ አነክዕኔ እኮ እቃን ኤሳሃ ኢትቴነንተ እቅ፤ መሰንትስ አን መገን አዲች አሜቾም፤ ኤሳሃ እስ ሶኮኤ ቤሉ አን ገይንከእ አሜቾምበአ። ");
INSERT INTO alw_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ሚሃት ጠወእ አጥራመቴነንተበኢሁ? ላገኤ ቶጎኖተ ሀሴንበቤቺሃበእንዶ? ");
INSERT INTO alw_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","አዕኑ እልቢስተ እለ፤ አንክዕኔ ሰውት አቶኖተ ሀሴነንተ፤ እስ ዎዕኔችን ኬሽ መነ ሸኖሃን፤ ሀንቁንኩ እሲን ዮስበእቤቺሃ ሀንቄን ኡርዮበአ፤ እስ ክዝበኘለከ ክዝብ አነ እኮቤቺሃ ክዝብ ጠወአኖሁ ገይችሲት። ");
INSERT INTO alw_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ጠዉ እኮጎሬ ሀንቅ ጠወኣምቤቺሃ አመዕንቴነንተኤበአ። ");
INSERT INTO alw_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ክዕኔ በሊች ኤሳሃ ‹አት ጩበኛ› ይ ጠወአኖሁ አዬት? አን ሀንቅ ጠወኣሚሃ እኮች ሚ አመዕንቴነንተኤበአ? ");
INSERT INTO alw_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","መገን አዲች እኮሁ መገን ላገተ ሞጮጨኖ፤ አዕኑ መገን አድረ እኬንበቤቺሃ መገን ላገተ ሞጮጭቴነንተበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","አይሁዱ ፈንቀሽት «ነኡ ‹አት ሰምራውቹሃን፤ ህትን እልብሱ አፎሄ› ዩኔ ሀንቅሃበእንዶ?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ህካን እኮቤቺሃ ኢስ «ኤሳሃ እልብሱ አፎኤበአ፤ ጠዉ እኮጎሬ አን አነኤ ኬዕምሳሚት፤ አዕኑ ኬዕምሴንታኤበአ። ");
INSERT INTO alw_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","እኮጎሬ አን ገይኤ ኬዕምኝ ሀሳምበአ፤ ኢ ኬዕምኝ ሀሰኖሁለከ ፈረደኖሁ ዎሉ ዮኡ። ");
INSERT INTO alw_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ሀንቅንከ ያንክዕኔ፤ ላገእ አገረኖሁ ዘላለሚሃ ሬሀኖበአ» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","አይሁዱ «ዱሩ አፎሄገ ቴሱ ደንጎም፤ እብራሂምለከ ነቢያከት ሬቶኡ፤ እኮጎሬ አት ‹ላገኤ አገርታእሩ ሆሮን ሬታበአ› ይታንቲት። ");
INSERT INTO alw_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ሀንቅንከ አት አናኔ እብራሂሚች በተአንንዶ? እብራሂምለከ ነቢያከት ሬቶኡ፤ እኮጎሬ አት ገዉክ አዬት ይቶታት?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ህትን ኢስ ፈንቀሽ «አን ገዉኤ ከበጄም ጎር መቱርቹሃ ደግለለኖበአ፤ ኤሳሃ ከበጀኖሁ አኑኔ ‹መገኑሃኔ› ይቴነንተ አናኤ። ");
INSERT INTO alw_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ጠዉ እኮጎሬ አዕኑ እሱ ደጌንታበአ፤ አን ደጋንስ፤ አን ‹እሱ ደጋምበአ› ዬም ጎሬ ክዕኔገን ክዝበኘ እሃም፤ እኮጎሬ አን እሱ ደጋም፤ ላገሲ አገራም። ");
INSERT INTO alw_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","አንክዕኔ እብራሂም ሃሽኣቱተ አን አሜታም በር ለዕይ ሙንደኦታት እቅ፤ እስን ህካን ለዕይ ሙንደዕዮ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ህከ ወክት አይሁዱ «አት እለንቶንቲች ኦንታሁ ዘማን እኮሄበኢሁ ‹እብራሂመ ለዕዮም› ይተንዶ?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ህትን ኢስ «ሀንቅንከ ያንክዕኔ፤ እብራሂም እለሙዕነ ዎዕናከ አን ዮምሃ» ይ ፈንቀሼሰ። ");
INSERT INTO alw_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ህካን እኮቤቺሃ አይሁዱ ኢሰ ቀሶተ ክኑ ኬሶኡ፤ ጠዉ እኮጎሬ ኢስ እሳች ገበጭ ይ መገን ምኒች ፉል ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","መቱ በር ኢስ ዎቃን ሃመን ቆቀ እክ እለሞ መንቹ ለዕዮ። ");
INSERT INTO alw_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ህከንቤቾንን አሳበንት ኢሰ «አስተማርቾ! ኩ መንቹ ቆቀ እክ እለሞሁ አይ አዕዮ ጩቢሃት? ገዉስ አዕዮ ጩቢንትንዶ አኑስለከ አመስ አቶ ጩቢኒት?» ይት ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ኢስን ፈንቀሽ «ኩ መንቹ ቆቀ እኮሁ ገዉስ አዕዮ ህከረንገ አኑስለከ አመስ አቶ ጩቢሃበአ፤ ጠዉ እኮጎሬ መገን ሆጉት እስ አሌን ለሊቶታት። ");
INSERT INTO alw_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","በሩ ዮ ጌሳን ሶኮኤ ሆጉተ አኡ ሀስሰኖኤ፤ መሰንትስ አዪሁ አኦተ አታለኖበእ ሀንከዕርት አሜታአ። ");
INSERT INTO alw_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","አን ከን ኣዱንያ አሌን ሄዕዮም ጌሳን ከን ኣዱንያ አሊሃ ኑርሃን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ህካን ጠወዕዮች ኤተሮን አንጀ ቱይ ትበ ቁፍሽ ጭቀስ ህከን ቆቀ መንች እሌን ቡር ");
INSERT INTO alw_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","«መርት ሰልሆም ዋን ኣዕል» ዬስ፤ «ሰልሆመ» ዩ «ሶቀሞሃ» ዩሃን፤ ህካን እኮቤቺሃ መንቹንኩ መር ኣዕል ፈይ ለአን ፈንቀል አሜቾ። ");
INSERT INTO alw_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ኦሌስ መኑለከ ከኒች ብርተ አፉዕል ኡጨን ለዕዮ መኑ «ኩን አፉዕል ኡጨኖሃ መንቹበእንዶ?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","መት-መቱሰ «ኤ እሶት» ይቶኡ፤ ዎሉሰንገ «እሱ አጉደኖት ቤሉ እሶበአ» ይቶኡ፤ ጠዉ እኮጎሬ ሁኩ መንቹንኩ «ኤ አኔት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","መኑንኩ «እልክ ሀት እክ ፈንተኦኡ?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","እስን « ‹ኢሰ› ዬኖ መንቹ ጭቀ ቁፍሽ እሌንከእ ቡር ‹ሰልሆም ዋን መርት ኣዕል› ዬኤ፤ አንን ህከ ቤቹ መር ኣዕል ፈዬም» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","እሰን «መንቹስ ሀከበ ዮኡ?» ይቶስ፤ እስን «አን ደጎምበአ» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","እሰን ህከ ቆቀ እክ እለሞ መንቹ ፈርሳዌቤቹ መስቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ኢስ ጭቀ ቁፍሽ መንች እልተ ፈይሾ በሩ ፎሎጭየ በር እቅ። ");
INSERT INTO alw_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ፈርሳውት ህከ መንቹ «ሀት እክ ለኦተ አታልት?» ይት ጠዕምቶስ፤ እስን «እሌንተእ ጭቀ ቡራን ኣዕል ለዕዮም» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ህከ ወክት ፈርሳዌች መት-መቱ «ኩ መንቹ ፎሎጭ በር ከበጅበቤቺሃ መገንየ መንቹበአ» ይቶኡ፤ እኮጎሬ ዎሉስ መኑ «ጩበኙ መንቹ ህትኔ አጀብሲሰኖ ጠወ ሀት አኦተ አታለኖ?» ይቶኡ፤ ህከን መሳን በላንከሰ አደዶመት እኮኡ። ");
INSERT INTO alw_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ህካን እኮቤቺሃ ህከ ቆቀ መንቹ «ኩ መንቹ እልክ ፈይሾች አት እስተኔሃ መ ይተን?» ይት ለንኪሃ ጠዕምቶስ፤ እስን «ነቢዬቹሃን» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","አይሁድ አዎንሳኑት ሁኩ መንቹ ብርተ ቆቀ እኮሃ እሁስ ቴንገ እልስ ፈይት ፈንተኦገ አነስለከ አመስ ገእት ጠዕምቶተ ኢለ አመዕንቶበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ህካን እኮቤቺሃ እሰን « ‹ቆቁ እለሞኡ› ይቴነንተ ቤቱክዕኔ ከንትንዶ? ቴሱ ሀት እክ ለኦተ አታሎ?» ይት አነስለከ አመስ ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","አኑስለከ አመስ «ኩ መንቹ ቤቱኔ እሁስለከ ቆቀ እክ እለሙስ ደንጋም። ");
INSERT INTO alw_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ጠዉ እኮጎሬ ቴሱ ሀት እክ ለአኖት ጎሬ፥ ህትን አይ እልስ ፈይሾስ ጎር ደንጋምበአ፤ እስ ገውስ ደጎ መንቹ እኮቤቺሃ ገዉንከስ ጠዕምዬስ፤ እስ ገይስተኔሃ ኩሎተ አታለኖ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","እሰን ህት ይቶኢሁ አይሁድ ሹመተ ዋጅቶቤቺሃት፤ መሰንትስ ኢስ «መሲህ» ይ መሰከረኖሁ ሄዕዮጎር ጭምትሰ ምኒች ፉሽቶተ ከኒች ብርተ አይሁድ ሹመት አማዕለንቶቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ህካን እኮቤቺሃ አኑስለከ አመስ «እስ ገውስ ደጎ መንቹ እኮቤቺሃ እሱንከ ጠዕምዬስ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ህከን መሳን ቆቀ እክ እለሞ መንቹ ለንኪሃ ገእት «አት መገኒሃ ኬዕምኝ ኣስ፤ ኩ መንቹ ጩበኘ እሁስ ነኡ ደንጋም» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","እስን «ጩበኛ እሁስ ደጋምበአ፤ አን ዎዕነ ቆቀ እሁእለከ ቴንገ ለኣምገ ጠለዕል ህካን ደጋም» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","እሰን «እስ መ አዕዮሄ? እልክ ሀት አዕይ ፈይሾሄ?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","እስን ፈንቀሽ «አን ዎዕናንከ ኩሎንክዕኔ እቅ፤ እኮጎሬ አዕኑ ሞጮጭቶኖተ ሀሴንታበአ፤ ቴንገ ሚሃ ሞጮጪ ሀሴነንታት? አዕኑ እሱ አዎንቴነንተረ እኮኖተ ሀሴነንታትንዶ?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","እሰን እሱ ቦሮርተን «እሱ አዎንታንቲሁ አቴት፤ እኮጎሬ ነኡ ሙሰ አዎናምረ። ");
INSERT INTO alw_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","መገኑ ሙሲሃ ጠወዕዮገ ነኡ ደንጋም፤ ጠዉ እኮጎሬ ኩ መንቹ ሀከንቤቺችት ጎር ደንጋምበአ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ሁኩ መንቹ እሳሃ «ኩ መንቹ ሀከንቤቺችት ጎር አዕኑ ደጉ ሆጉክህኔ አበ አጀብሲሰኖሃን! ጠዉ እኮጎሬ እልኤ ፈይሾሁ እሶት። ");
INSERT INTO alw_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","መገኑ ጩበኛኑት ይታ ጠወ ሞጮጨኖበእገ ደንጋም፤ ጠዉ እኮጎሬ መገኑ ዋጀኖሁለከ እስ ሃሽኣቱተ አአኖሁ ሄዕዮጎር ሁኩን የኖ ጠወ መገኑ ሞጮጨኖ። ");
INSERT INTO alw_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","‹ቆቀ እክ እለሞ መንች እልተ ፈይሾሁ ዮኡ› ዬን ጠወኤነን ከበሬ ኢለ ሆሮ ሞጮጨሞበአ። ");
INSERT INTO alw_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ኩ መንቹ መገኒች እህበእቃን መቱርቹሃ አኦተ አታለኖበ እቅ» ይ ፈንቀሼሰ። ");
INSERT INTO alw_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","እሰን «አት ጉዕሙርቹንኩክ ጩቢን እለንቶንቲሁ ኔሳሃ ተማርስተንንዶ?» ይት ጭምት ምኒች ፉሽቶስ። ");
INSERT INTO alw_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ህከ መንቹ አይሁዱ ጭምት ምኒች ፉሽቶስገ ኢስ ሞጮጬእ፤ ኢስ ህከ መንቹ ደግ «መንች ቤቶን አመዕንተንንዶ?» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","እስን ፈንቀሽ «ቀርቾ! አን እሶን አመዕኖተ እስ አዬት?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ኢስን «አት እሱ ከኒች ዎዕናንከ ለኦንት፤ ህትን ቴሁ ኪን ጠወአኖንኩ እሶት» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","እስን «ቀርቾ! አመዕናም» ይ ሰገጆስ። ");
INSERT INTO alw_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ኢስን «ለእበሩ ለኦተለከ ለኣእሩ ቆቆተ አን ፈረዶተ ከን ኣዱንያ አል አሜቾም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ህከ ወክት ኢስ መዴን ሄኦ ፈርሳውት ህካን ሞጮጭት «ነኡ ቆቃኖተንዶ?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ኢስ እሳሃ «ቆቃኑተ እኬንተ እቃን ጩብ እሀኖህዕኔበ እቅ፤ ጠዉ እኮጎሬ ቴሱ ለዕናሚት ይቴነንተቤቺሃ ጩብ እሀኖህዕኔ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ኢስ «ሀንቅንከ ያንክዕኔ፤ ሆለ ጎረንች ኡሮን እሁዕነ ዎሎ አዲን ኣገኖ መንቹ ሞጋንቹሃለከ ዘራፌተ። ");
INSERT INTO alw_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ጠዉ እኮጎሬ ኡሮን ኣገኖሁ ሆላተስ ዜማንቹሃን። ");
INSERT INTO alw_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","እሲሃ ኡሮ አገራንቹ ኡሩተ ፈነኖስ፤ ሆለንት ላገስ ሞጮጭታአ፤ እስን ገይስ ሆለተ ሱዕሚንከሰ ገአን አዎንስ አብል ፉሸኖሰ። ");
INSERT INTO alw_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ገይስረ ጉዕመንከ ገእ ፉሼች ኤተሮን ብሬንከሰ ሃመን አዎንሰኖሰ፤ ሆለንትስ ላገስ ደጋቤቺሃ አዎንታስ። ");
INSERT INTO alw_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ጠዉ እኮጎሬ ዎሊች ሁንታ ቤሉ አዎንታስበአ፤ መሰንትስ ዎል ላገተ ደጋበእቤቺሃት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ኢስ ህከ ምሳልተ ኩሎሰ፤ ጠዉ እኮጎሬ እሰ ኩሎሳሁ መሃጎሬ አጥራመቶበአ። ");
INSERT INTO alw_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ህካን እኮቤቺሃ ኢስ ለንኪሃ «ሀንቅንከ ያንክዕኔ፤ አን ሆለት ኣጋታ ኡሩ። ");
INSERT INTO alw_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ኤሳሃ ሄጭት አሜቶእሩ ጉዕሙንኩ ሞጋኖተለከ ዘራፌታ፤ ጠዉ እኮጎሬ ሆለት ሞጮጭቶሰበአ። ");
INSERT INTO alw_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","አን ኣጌኖ ኡሩተ እኮምቤቺሃ ኢ አዲን ኣገኖሁ አዪሁ ጡመኖ፤ ኣገኖለከ ፉለኖ፤ ህትን ዜሜ ቤቹ ደአኖ። ");
INSERT INTO alw_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ሞጋንቹ ሞጎተ፥ ሾተለከ ቤሶተ አሜተኖ፤ እኮጎሬ አን አሜቾሚሁ ልግብ ሄኡ ኣሶታት። ");
INSERT INTO alw_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«ጡሙ ዜማንቹ አኔት፤ ጡሙ ዜማንቹ ሆላተስ ነብሳስ ህግሽ ኣሰኖ። ");
INSERT INTO alw_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ጠዉ እኮጎሬ ሆለት ገይሲረ እኩዕነ ባቴናንስ አገራኖ ዜማንቹ ሆልት አሜተን ለዕዮ ወክት አጉር ሁነኖ፤ ሆልንት ሆለተ ብንአዕይ ደመቅሽ ኣአኖ። ");
INSERT INTO alw_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ሁኩ ዜማንቹ ሁነኖሁ ብረ ባቴናንስ አገራኖሃ እኮቤቺሃትለከ ሆላተስ አሙዝበቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ጡሙ ዜማንቹ አኔት፤ አን ሆለእ ደጋም፤ ሆለንትኤ ኤሳሃ ደጋአ። ");
INSERT INTO alw_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","አን እሰተ ደጋሚሁ አኑኤ ኤሳሃ ደገኖኤገለከ አኒሁ አነኤ ደጋምሀንጋት፤ አን ሆላተኤ ነብሳእ ህግሽ ኣሳም። ");
INSERT INTO alw_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ከን ዜሜ ኣዜን ዮበእ ዎልት ሆለት ዮኤ፤ እሰንተ ኤቡ ሀስሰኖኤ፤ ላገእ ሞጮጭታኣ፤ ህትን መቱ ዜሞሃ እካን ዜማንቹሰ መቱ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","«ህካን እኮቤቺሃ አኑኤ ኤሳሃ ኢተኖ፤ መሰንትስ አን ፈንቀሽ ኣኦተ ነብሳእ ህግሽ ኣሳምቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ነብሳእ አን ገይኤ ኢታን ህግሽ ኣሳም ቤሉ ኢች ከም ኣአኖሁ አዪሁ ዮበአ፤ ነብሳእ ህግሽ ኣሶተለከ ፈንቀሽ ኣኦተ ዎልቀት ዮኤ፤ ከ ትዛዝ ኣኤሚሁ አኒችኤት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ህከን ጠዊች ኬዕዮሀንን አይሁድ በላን ለንኪሃ አደዶመት እኮኡ። ");
INSERT INTO alw_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","እሳችን ልግቡሰ «እሱ ዱሩ አፎስ፤ እስን በርገጎኡ፤ እስ ጠወአኖ ጠወ ሚሃት ሞጮጭቴነንታቲሁ?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ህትን ዎሉሰንገ «ኩ ጠዉ ዱሩ አፎስ መንች አፌች ፉለኖበአ፤ ዱሩ ቆቀ መንች እልተ ፈይሰኖንዶ?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ዬሩሳሌማን ዱእ ምኒ ሙጩሩ አኤኖ ከበጃት ከበጄኖ ወክቱ ኢልዮ እቅ፤ ወክቱንኩስ ከርምሃ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ኢስን መገን ምኔን «ሱላይማን ሃመኖ ዎቃ» ዬኖቤቾን ሃመኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ህከ ወክት አይሁድ አዎንሳኑት ኢሰ አጀብ ኡርት «ሄንኩ በሩ ኢሎተ ኢለ ሸክናምገ አተኔ? አት መሲህ እኮንትጎር ለሊስ ኩልኔ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ኢስ «አን ከኒች ብርንተ ኩሎንክዕኔ፤ እኮጎሬ አዕኑ አመዕንቴነንተበአ፤ አንኤ ሱዕሚን አኣም ሆጉት ኢተኔሃ መሰከርታአ። ");
INSERT INTO alw_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ጠዉ እኮጎሬ አዕኑ ሆለኤ እኬንበቤቺሃ አመዕንቴነንተበአ። ");
INSERT INTO alw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ሆለኤ ላገኤ ደጋአ፤ አኒሁ እሰተ ደጋም፤ እሰን አዎንታኤ። ");
INSERT INTO alw_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","አን እሳሃ ዘላለሚሃ ጉዕሚንከ ሄአኖ ሄኡ ኣሳንሰ፤ ህካን እኮቤቺሃ እሰን ሆሮን በኣበአ፤ ህትን ኢ አንጋች አዪሁ ዎልቅሽ መሰኖሰበአ። ");
INSERT INTO alw_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","እሰንተ ኤሳሃ ኣሴ አኑኤ ጉዕሚችን ሎረሃን፤ አንኤ አንጋች እሰተ ዎልቅሽ ኣኦተ አታለኖሁ አዪሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","አንለከ አኑኤ ሜጡሃን» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ህከ ወክት አይሁዱ ለንኪሃ ኢሰ ቀሶተ ክኑ ኬሶኡ። ");
INSERT INTO alw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","እኮጎሬ ኢስ ፈንቀሽ «አን ልግብ ጡመ ሆጉተ አኒችኤ ለሊሾንክዕኔ፤ ህከረ አዕኑ ኤሳሃ ክኒን ቀሴነንታሁ ህከኑኡች ሀተን ሆጎታት?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","እሰን «ነኡ ቀንሳንኬሁ መገን አሌን ቦሮር ላገተ ጠወኦንትቤቺሃት ቤሉ ጡመ ሆጎተክበአ፤ ህትን አት መንቹ እከን ገዉክ መገኑ አቶንትቤቺሃት» ይት ፈንቀሽቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ኢስ «ሕጋንከክዕኔ ‹ክዕኔተ ሽርኬተ ዬንክዕኔንዶ› የኖሁ ከተበሞበእንዶ? ");
INSERT INTO alw_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","መገን ላገት ህግባሃ እኮኢችለከ ሁኩ መገን ላገት አሜቶሰረ ‹ሽርክተ› ይ ገአኖ ስርኘ ");
INSERT INTO alw_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ህካን እኮች አኑ መገኑ መጠሮሃለከ ከን ኣዱንያ አል ሶኮኤሃ ‹አን መገንየ ቤቱ› ዬምቤቺሃ ‹መገን አሌን ቦሮር ላገተ ጠወኦንት› ይቴነንንዶ? ");
INSERT INTO alw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","አን አንኤ ሆጉተ አእባች አመዕንቶኖቼኤ። ");
INSERT INTO alw_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","አን አንኤ ሆጉተ አኣሚሃ እኮች ኢን አመዕንቴንበ ጎር ሆጎንተኤ አመዕንዬ፤ ህከኒን አኑኤ ኢን ሄኡስለከ አን አኒንከኤ ሄኡእ ደጌነንተለከ አጥራመቴነንተ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","እሰን ህከ ወክት አፎስተ ሀሶኡ፤ እኮጎሬ እስ አንጋችሰ ፉሸእ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ኢስ ለንኪሃ ዮርዳኖስ ዋሃ ቶል ያህይ ዎዕነ ጠመቀኖ ቤቹ አሜቾ፤ ህከኔን ዱንኬእ። ");
INSERT INTO alw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ልግቡ መኑ እስበ አሜት «ያህይ መቱ አጀብሲሰኖ ጠወሃ አዕዮበአ፤ ጠዉ እኮጎሬ ያህይ ከን መንችተኔሃ ጠወዕዮ ጠዉ ጉዕሙንኩ ሀንቅሃን» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ህከንቤቾንን ልግቡ መኑ ኢሳን አመዕንቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","መቱ በር «ቢታንያ» ዬኖቤቾን ሄአኖ «አልዓዛሬ» ዬኖ መንቹ ጥዦ እቅ፤ ቢታንዩ መርየመለከ አመሴ ቤቱት ማርታ ሄኣእተ ቀእ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ህት መርየመ ቀርች ሎካን ሽቱተ ቡርት ሙሚንከሴ ሺንሽቶእተ፤ ሁኩ ጥዦ አልዓዛር አመሴሃ ቤቱ። ");
INSERT INTO alw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ሁኩ ለሙንኩ አመኦሱት ኢስበ «ቀርቾ! ጃሉክ ጥዦኡ» ይት ሶኮኡ። ");
INSERT INTO alw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ኢስን ህካን ሞጮጬ ወክት «ኩ ጥዘነት ሽትበተ፤ ጠዉ እኮጎሬ መገን ኬዕምኙ ለሎተ መገን ቤቱንኩ ከን ጥዘነ መሳን ኬዕሞተ እኮእሃን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ኢስ ማርተለከ አመሴ ቤቱተ መርየመ ህትን አመሰ ቤቱንከ አልዓዛሬ ኢተኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","እኮጎሬ አልዓዛር ጥዦገ ሞጮጬ ወክት ዮቤቾን ለሙ በር ዱንኬእ። ");
INSERT INTO alw_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ህከኒች ኤተሮን አሳበንት «ለንኪሃ ይሁድ ባዱ መርኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","አሳበንት «አስተማርቾ! አይሁድ አዎንሳኑት ግደኖ በሬች ብርተ ኬሳሃ ክኒን ቀሶሄተ ሀሳሄት እቅ፤ ቴሱንገ ህከ ቤቹ ፈንቀልት መርተንንዶ?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ኢስን ፈንቀሽ «ሱጴች ኬሽ አሩ ኣጎተ ኢለ ቶነ ለሞሃ ሰኣትበእንዶ? በራን ሃመኖሁ ከን ኣዱንያ አል ኑር ለአኖቤቺሃ ቆዕለኖበአ። ");
INSERT INTO alw_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ጠዉ እኮጎሬ ሀንከዕሬን ሃመኖሁ ኑሩ እሲን ዮበእቤቺሃ ቆዕለኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ኢስ ህካን ጠወዕዮች ኤተሮን «ጃሉኔ አልዓዛር ግሾኡ፤ እኮጎሬ ግሰኛች ኬሶስተ መራም» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","አሳበንት «ቀርቾ! ግሾ ጎር ቆሀኖስ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ኢስ ህካን ጠወዕዮሁ አልዓዛሬ ሬሆተኔሃት እቅ፤ ጠዉ እኮጎሬ ግሰኛተኔሃ ጠወዕዮሃ አጉጆሰ። ");
INSERT INTO alw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ህካን እኮቤቺሃ ኢስ እሳሃ ለሊሽ «አልዓዛር ሬዮ። ");
INSERT INTO alw_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","አዕኑ አመዕንቶኖተ አን ህከን ቤቾን ሄኡ ሆጉኤ ክዕኔተኔሃ ሙንዲሲሾኤ፤ እኮጎሬ ቴሱ ነኡ እስቤቹ መርኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ህከ ወክት «ዲዲሞስ» ዬን ገኤኖ ቶማስ ዎሎ አሳባን «ነኡ እሲንን ሬኖተ መርኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ኢስ ህከ ቤቹ ኢለኖ ወክት አልዓዛር ሞገሞች ሾሉ በር እኮስ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ቢታንዩ ዬሩሳሌም ከተሚች ሰኣት ደሬ ጌሰ ሃምሲሰኖሃ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ማርተለከ መርየመ አመሰ ቤቱ ሬዮቤቺሃ ሻዛበእገ ልግቡ አይሁዱ አልፋቴን አፉዕልቶተ እሰቤቹ አሜቶኡ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ማርተ ኢስ አሜቾገ ሞጮጭቶ ወክት ቶጎስተ መርቶኡ፤ እኮጎሬ መርየመ ምኔን ፈቆኡ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ማርተ ኢሰ «ቀርቾ! አት ከንቤቾን ሄኦንት እቃን አመኤቤቱ ሬሀኖበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ጠዉ እኮጎሬ ቴሁ አት ጠዕምቶንት ጠወ ጉዕመንከ መገኑ ኣሰኖሄገ ደጋም» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ኢሲን «አመክቤቱ ሬሆች ኬአኖ» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ማርተን «ቂያመ በር ሬሆች ኬኤኖ ወክት ኬአኖገ ደጋም» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ኢስን «ሬሆች ኬኡለከ ሄኡ አኔት፤ ኢን አመዕነኖሁ ሬዮ ጎሬሁ ሄአኖ። ");
INSERT INTO alw_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ኢን ሄአኖሁለከ አመዕነኖሁ አዪሁ ሆሮን ሬሀኖበአ፤ ህካን እኮቤቺሃ አመዕንተንንዶ?» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ማርተን «ኤ ቀርቾ! አት ኣዱንያ አል አሜተኖ ዬመ መሲህ መገን ቤቱ እሁክ አመዕናም» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ማርተን ህካን ጠወኦች ኤተሮን «መርየመ» ዬኖ አመሴ ቤቶቤቹ መርት «አስተማርቹ አሜቾኡ፤ እስን ኬሳሃ ገአኖሄት» ይት ማጥ ኩልቶሴ። ");
INSERT INTO alw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","እሴን ህካን ሞጮጭቶ ወክት ደዕልት ኬእ እስቤቹ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ኢስ ህከ ቀእተ ኣጉዕናን ማርታን ደቀንቶ ቤቾን ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","መርየመ ምኔን እሴንን ሜጡበ አልፋቴን አፉዕልቶ አይሁዱ መርየመ ደዕልት ኬእ መርተንን ለኦ ወክት አልዓዛሬ ሎድበ መርት ኦኣኢሃ አጉጃንሰ እሴንተ አዎንቶሴ። ");
INSERT INTO alw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","መርየማን ኢስ ሄዕዮቤቹ ኢልት ለኦ ወክት ሎከስ ኡብ «ቀርቾ! አት ከንቤቾን ሄኦንት እቃን አመኤቤቱ ሬሀኖበአ እቅ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","እሴለከ እሴን ሜጡበ አሜቶ አይሁዱ ኦአን ኢስ ለዕይ አበ ሻዣን ጎደቡስ ሌንቄቄእ። ");
INSERT INTO alw_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","እስን «ሀከንቤቾንት ሞጌንታሁ?» ዬእ፤ እሰን «ቀርቾ! አሜት ለእ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ኢስን እንጂጃተ ፉሽ ኦዕዮ። ");
INSERT INTO alw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ህካን እኮቤቺሃ «ሄንከ ኢተኖስ ጎር ለዕዬ» የቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ጠዉ እኮጎሬ እሳች መት-መቱ «ኩን ቆቀ መን እልተ ፈኞሁ ከ መንቹ ሬህበገ አኦተ አታለኖበእንዶ?» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ኢስ ቀልቤንከስ አበ ሻዘን ሎድቤቹ መሮ፤ ጃናዘስ አፉሼማንኩ ሎረ ክኒች ሸሄን መክሴመ ሎዳን ክኑ እፍሰሞ ሻንቃንት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ህትን ኢስ «ክኑ ኬሼ» ዬእ፤ ሬዮ መንች አመቤቱት ማርተ «ቀርቾ! ሬዮች ሾሉ በር እኮስቤቺሃ ከ ወክት ቦበኖ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ኢስን « ‹አመዕንቶንትጎር መገን ኬዕምኝ ለኣንት› ይበሄንዶ?» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","መኑ ህከ ክኑ ኬሾ፤ ህከኒች ኤተሮን ኢስ አሌ ዋሽ ለዕይ «ኢ አነ! ሞጮጭቶንቴኤቤቺሃ ገለትጫንኬ። ");
INSERT INTO alw_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ጉዕመረን ሞጮጭታንቴኤገ ደጋም፤ ጠዉ እኮጎሬ ካን ዬሚሁ ከኔ ኡርቶ ኡመቱ አት ኤሳሃ ሶኮንትገ አመዕንታገ ይዪት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ኢስ ህካን ጠወዕዮች ኤተሮን «አልዓዛሬ! አም ፉል» ይ ላገስ ጎት አዕይ ጠወዕዮ። ");
INSERT INTO alw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ሬዮ አልዓዘርን አንገስለከ ሎከስ ከፈኒን ጣጠሞገን ሎድ ኣዚች ፉሎ፤ ሚንስ ከፈኒን ጣጠሞ እቅ፤ ኢስ «ሂርቴን አጉሬስ፤ ሃሙን» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","መርየመቤቹ አልፋቴን አፉዕልቶተ አሜቶ አይሁዲች ልግቡሰ ኢስ አዕዮሃ ለእ አመዕንቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ጠዉ እኮጎሬ እሳችን መት-መቱሰ ፈርሳዌቤቹ መርት ኢስ አዕዮ ጠወ ኩልቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ህካን እኮቤቺሃ ቂስ አዎንሳኑትለከ ፈርሳውት ኦገት ባሊቅ ገእት ጭምአት «ኩ መንቹ ልግብ አጃብሲሰኖ ጠወ አአኖቤቺሃ መ አዕኖም ጎር ቆሀኖ? ");
INSERT INTO alw_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ህትን አኦተ ሰዕም ይኖም ጎር መኑ ጉዕሙንኩ እሲን አመዕነኖ፤ ሮም ባድ መኑንኩ አሜት ከ ቤቹለከ ኡመት ጉዕመንከ ቤሳአ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ጠዉ እኮጎሬ እሳች መቱ ህከን ዘማን ሎሩ ቂስቹ «ቀያፈ» ዬኖሁ «አዕኑ መቱርቹሃ ደጌንታበአ። ");
INSERT INTO alw_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ኡመቱ በአኖሀኒች መቱ መንቹ መንተኔሃ ሬዮጎር ክዕኔሃ ቆሀኖሃ እሁስ ሰውይቴነንተበእንዶ?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","እስን ህካን ጠወዕዮሁ ገይስ ቀልቢቺበአ፤ እኮጎሬ ህከ ወክት እስ ሎረ ቂስቹ እኮቤቺሃ ኢስ መንተኔሃ ሬሀኖገ ራገ ጠወዕዮ። ");
INSERT INTO alw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ጠዉ እኮጎሬ እስ ሬሀኖሁ ጠለዕል ኡመቲሃ እሁዕነ ብንይቶ መገን እለተ ሜጡበ ጭም አኦታት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ህካን እኮቤቺሃ እሰን ህከን በሬች ኬስ ኢሰ ሽቶተ አማዕለንቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ህከኒች ኤተሮን ኢስ አይሁድ መን በላን አልባሽ ሃሞበአ፤ ጠዉ እኮጎሬ ህከንቤቺች ፉል ኡለ ኡድም መዴን ሄዕዮ «ኤፍሬመ» ዬኖ ከተመ ኦሮዕዮ፤ ህከን ቤቾን አሳባን አፉዕሌእ። ");
INSERT INTO alw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","አይሁድ ሻሽግ ከበጀቱ ሆንጠኮ እቅ፤ ልግቡሰ ሻሽግ ከበጀቱ ኢለኖሀኒች ሄጭት ገዉሰ ነጠ አቶተ ሄኣ ቤቺች ጉዕሚችን ዬሩሳሌም ከተመ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","እሰን ዱእ ምኒ ኣዜን ኡርት ኢሰ ሀሰን «እስ ከ ከበጀት ከበጄኖቤቹ ሆሮን አሜተኖበእንዶ? መ ሰውይቴነን?» የቀንተን መት-መቲንከሰ ጠወኣኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ህትን ቂስ አዎንሳኑትለከ ፈርሳውት ኢሰ አፎተ ሄአኖ ቤቹ ደገኖ መንቹ ሄዕዮ ጎሬ ኢሰ ለሊሶሰተ መነ ጉዕመንከ አዘዞ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ሻሽግ ከበጃቲሃ ሌሁ በሩ ፈቆሀኔን ኢስ ቢታንያ ኦሮዕዮ፤ ሁኩ ቢታኑ ኢስ ሬሆች ኬሾስ አልዓዛር ሄአኖተ ቀዕየ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","እሰን ህከኔን እሲሃ ሁርባት ቅጥ አታን ማርተ ሆንጠህሳኢት እቅ፤ አልዓዛርን ኢሲን ሜጡበ ማዳን አፉዕልቶሀኑኡች መቶሃስ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ህከ ወክት መርየመ ዋጉስ አበ ጤአተ እኮ ነጠ «ናርዶሰ» ዬኖ ሀቂች መክቶ መቶ ብልቃጥ ሽቱተ ኤቦኡ፤ ህካንን ኢስ ሎካን ቡርት ሙሚንከሴ ሺንሽቶኡ፤ ህከን ሽቶ አንጀነት ምኒ ኣዝ ዊንቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ጠዉ እኮጎሬ አሳባች መቱ ኢሰ ህግሽ ኣሰኖ አስቆሮንቶ ይሁድ፥ ");
INSERT INTO alw_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«ከ ሽቱተ ሰሴ ጥቤ ዲናረ ህሬን ሚሃ ቡጥቻኖተ ኣሴኖበአ?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","እስ ህካን ጠወዕዮሁ ቡጥቻኖተ ሻዥ እሁዕነ ሞጋንቹ እኮቤቺሃት፤ ህትን ብር ከረጢትተ አፈኖሃ እኮቤቺሃ ህከን ከረጢቴን ዎሬኖ ብሪች ኣኡ ሮሾቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ኢስ «ሞገማም በሬተ ተቃጠባቤቺሃ አጉሬሴ። ");
INSERT INTO alw_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ቡጥቻኑት ጉዕመ ወክትንከ ክዕኔኤን ሜጡበ ሄኣአ፤ ጠዉ እኮጎሬ አን ክዕኔኤን ጉዕመ ወክት ሄኣምበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ህከ ወክት ልግቡ አይሁዱ ኢስ ቢታንያን ሄዕዮገ ደግ ህከ ቤቹ አሜቶኡ፤ እሰን ህከ ቤቹ አሜቶኢሁ ጠለዕል ኢሰ ለኦተ እሁዕነ ኢስ ሬሆች ኬሾ አልዓዛሬሁ ለኦታት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ቂስ አዎንሳኑንት አልዓዛሬ ሽቶተ አማዕለንቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","መሰንትስ ልግቡ አይሁዱ ሰውትሰ ዶርተን አልዓዛሬ መሳን ኢሳን አመዕንቶቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ህከኒች ኤተሮን ሻሽግ ከበጃት ከበጅቶተ አሜቶ ልግቡ መኑ ኢስ ዬሩሳሌመ አሜተኖገ ሞጮጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ህካን እኮቤቺሃ እሰን ኢሰ ቶጎተ ዘምባብ ሀበረ አፍ ላገሰ ጎት አት «ሆሳና! ቀርች ሱዕሚን አሜተኖ እስራኤል ዎሙ ማሰአሞእሃን» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ኢስ ሀሩች ዎተረ ደግ እሶን ቆጶ፤ ሁኩን እኮሁ፥ ");
INSERT INTO alw_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«አት ጽዮን ከተሙ! ዋጅቶት፤ ሁኩዕኑን ዎሙክ ሀሩች ዎተራን ቆጵ አሜተኖት» የመም ከተበሞ ራጉ ዊሞታት። ");
INSERT INTO alw_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ሁኩ ጠዉ ሄጭ አሳባተ ኣጎሰበአ እቅ፤ ጠዉ እኮጎሬ ኢስ ኬዕምኚን ኣጎች ኤተሮን ኩ ጠዉ እስተኔ ከተበሙስለከ ጠወስ እሲሃ አኤመገ ሰውይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ኢስ አልዓዛሬ ሎዲች ገእ ሬሆች ኬሰን ኢስን ሜጡበ ሄኦ መኑ እሲሃ መሰከርቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ሁኩ ኡመቱ ኢሰ ቶጎተ ፉሎሁ እስ ህከ አጀብሲሰኖ ጠወ አዕዮገ ሞጮጭቶቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ህከ ወክት ፈርሳውት «ከለዕዬ ኣዱንያ አሉ ጉዕሙንኩ እሱ አዎነኖት፤ ነኡ መቱርቹሃ አዕኖተ አታልናምበአ» የቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ህከን ሻሽግ ከበጀ ወክቴን ሰገዶተ ዬሩሳሌመ አሜቾ መን በላን መት-መቱ ግሪክ መኑ ሄኦ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","እሰን ገሊለ ባዶን ሄዕዮ «ቤተ ሳይዳ» ዬኖ ከተሚች አሜቾ ፍልጶሴቤቹ መርት «ቀርቾ! ነኡ ኢሰ ለዕኖተ ሀንሳም» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ፍልጶስን መር እንድራሴሃ ኩሎ፤ እንድራስለከ ፍልጶስ መርት ኢሲሃ ኩልቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ኢስ ፈንቀሽ «መንች ቤቱ ኬዕምሴኖስ ወክቱ ኢልዮኡ። ");
INSERT INTO alw_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ሀንቅንከ ያንክዕኔ፤ አለስ መትት እልት ኡላን ኡብ ሬትባች ጠለዕለ ፈቃአ፤ እኮጎሬ ሬቶች ልግብ ላልቹ ላልታአ። ");
INSERT INTO alw_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ነብሳስ ኢተኖሁ ነብሳስ ቤሰኖ፤ ጠዉ እኮጎሬ ከን ኣዱንያ አሌን ነብሳስ ግበኖሁ ዘላለሚሃ ጉዕሚንከ ጎፍበ ሄኡ አገዕረኖ። ");
INSERT INTO alw_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ኤሳሃ ካደሞተ ሀሰኖሁ ዮ ጎሬ አዎኑዕኔ፤ አን ዮምቤቾን ካድንቹእ ህከን ቤቾን ሄአኖ፤ ኤሳሃ ካደመኖሃ አኑኤ ሎርሰኖስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ህትን ኢስ «ነብሴቹእ ጨነቀንቶኡ፤ ቴንገ መ ዩ? ‹ኢ አነ! ከን ወክቲች ጡምሴኤ› ዩንዶ? ህት ይበገ አን አሜቾሚሁ ከን ወክቲሃት። ");
INSERT INTO alw_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ኢ አና! ሱዕመክ ሎርስ» ዬእ፤ ሰሜችን «ሱዕመኤ ሎርስዮም፤ ህትን ቴሁ ሎርሳም» ይታ ላገት አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ህከን ቤቾን ኡሬ መኑ ህካን ሞጮጬ ወክት «ኩን ጉገኛተ ላገ» ይቶኡ፤ ዎሉሰንገ «መላይኬቹ ጠወአኖሲት» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ኢስ ፈንቀሽ «ኩ ላገት ክዕኔተኔሃ አሜቶኡ ቤሉ ኢተኔሃ አሜቶበአ። ");
INSERT INTO alw_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ከን ኣዱንያ አሌን ፍርዱ እሀኖሁ ቴሶት፤ ህትን ከን ኣዱንያ አል ዳኙ ሼይጣንቹ አብል ፉል ኡበኖ ወክቱ ቴሶት። ");
INSERT INTO alw_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","አን ኡለ አሊች አሌ ዋሎም ወክት ጉዕመንከ መነ ኢ አደ አኣም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ኢስ ህት ዩስ ሀት እክ ሬሀኖ ጎር ለሊሶታት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ህትን ኡመቱ ፈንቀሽት «ሕግ ላገች ሞጮጭኖሚሁ ‹መሲሁ ዘላለሚሃ ጉዕሚንከ ሄአኖ› የኖሃ እቅ፤ አት ሀት ‹መንች ቤቱ አሌ ዋሉ ሀስሰኖስ› ይታንትት? ኩ መንች ቤቱ አዬት ጎር?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ኢስን «ቀዎ ወክቲሃ ኑሩ ክዕኔን ሜጡበ ሄአኖ፤ ቱንስቹ አፈኖህዕኔበእገ ኑሩ ሄዕዮ ጌሳን ሃሜ፤ ቱንስቾን ሃመኖሁ ሀከቤቹ መረኖጎር ደገኖበአ። ");
INSERT INTO alw_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ኑር እለተ እኮኖተ ኑሩ ዮ ጌሳን አመዕንዬ» ዬሰ፤ ኢስ ህካን ዬች ኤተሮን እሳች አደ እክ ገበጭ ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ኢስ አበ መላተ ብሬንከሰ አዕዮ ጎሬሁ አይሁዱ እሲን አመዕንቶበአ። ");
INSERT INTO alw_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ሁኩንን ነቢዬቹ እስያስ «ቀርቾ! ኩልኖም ጠወ አይ አመዕንዮኔ? ህትን መገን ዎቀልት አዬሃ ለልቶኡ?» ይ ጠወዕዮ ላገት ዊንቶታት። ");
INSERT INTO alw_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ህካን እኮቤቺሃ አመዕንቶተ አታልቶበአ፤ መሰንትስ ነቢዬቹ እስያስ ለንኪሃ ");
INSERT INTO alw_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«እሌንከሰ ለኣበእገለከ ቀልቤንከሰ ሰውይታበእገ ኢ አደ ፈንቀልታን አን ፈይሳንሰበእገ እልሰ ቆቅሾኡ፤ ህትን ቀልብንከሰ ዱድሾኡ» ዬቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","እስያስ ህካን ዬኢሁ እስ ሄጭን መሲህ ኬዕምኝ ለዕዮቤቺሃት፥ ኢስተኔሃ ጠወዕዮቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","አይሁድ ሀለቃች ልግቡሰ ኢሳን አመዕንቶጎሬሁ ጭምትሰ ምኒች ፉሽታሰበእገ ፈርሳውተ ዋጅቶቤቺሃ አመዕኑሰ ለሊሶበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","መሰንትስ እሰ መገኑ ኬዕምሰኖ ኬዕምኚች መኑ ኬዕምሰኖ ኬዕምኝ ኢትቶቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ህትን ኢስ ላገስ ጎት አዕይ «ኢን አመዕነኖሁ ጠለዕል ኢን እሁዕነ ኤሳሃ ሶኮኤሀኒን አመዕንዮእሃን። ");
INSERT INTO alw_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ኤሳሃ ለአኖሁ ኤሳሃ ሶኮኤሃ ለአኖ፤ ");
INSERT INTO alw_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ኢን አመዕነኖሁ ጉዕሙንኩ ቱንስቾን ሄአኖበእገ አን ኑር እክ ከ ኣዱንያ አል አሜቾም። ");
INSERT INTO alw_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ላገኤ ሞጮጭ አገርበሀን አሌን አን ፈረዳምበአ፤ መሰንትስ አን አሜቾሚሁ ከን ኣዱንያ አል ጡምሶታት ቤሉ ፈረዶታበአ። ");
INSERT INTO alw_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ኤሳሃ ግበኔኤሁለከ ላገኤ ቶግባኤሃ ፈረደኖሁ ዮኡ፤ አን ጠወዕዮም ላገት ገይንትሴ ቂያመ በር ፈረዳስ። ");
INSERT INTO alw_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","መሰንትስ አን ገዪንከኤ ጠወዕዮምበአ፤ አን ያሚሃለከ ጠወኣሚሃ ኣሴኤሁ ኤሳሃ ሶኮኤ አናኤ ገዎንከስ። ");
INSERT INTO alw_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","እስ ትዛዙ ዘላለሚሃ ጉዕሚንከ ሄአኖ ሄኡ እሁስ ደጋም፤ ህካን እኮቤቺሃ አን ጠወኣሚሁ አኑኤ ኩሎኤሃት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ኢስ ሻሽግ ከበጃች ሄጭ ከን ኣዱንያ አሊች አኒስ ቤቹ ኦሮአኖ ወክቱ ኢሌገ ደጎ፤ እስን ከን ኣዱንያ አሌን ሄዕዮ ገይስ መነ ጉዕመንከ መጨረሸ ኢለ ኢቴሰ። ");
INSERT INTO alw_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ኢስለከ አሳበስ ሁርባት እታኢት እቅ፤ ስሞኔ ቤቱ አስቆሮንቶ ይሁደ ቀልብስ እልብሱ ኢሰ ህግሽ ኣሰኖገ አዕዮስ። ");
INSERT INTO alw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","አኑ ጉዕመርቹንከ አንጋንከስ ኣሴገለከ መገን አዲን አሜቾገ ህትን መገን አደ ፈንቀል ኦሮአኖገ ኢስ ደገኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ህካን እኮቤቺሃ ማዲች ኬዕይ ኦድኑስ አፉሽ ፎጠ ኣእ ረመዞንተስ ቆዕሬእ። ");
INSERT INTO alw_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ህከኒች ኤተሮን ኣዕሌኖ ኦዳን ዊች ዎር አሳበ ሎከተ ኣንሸን ረመዞንተስ ቆዕሬ ፎጢን ሞሼእ። ");
INSERT INTO alw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ኢስን ስሞን ጴጥሮሴቤቹ ኢሌ ወክት ስሞን ጴጥሮስ «ቀርቾ! አት ኢ ሎከተ ኣንሽተንንዶ?» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ኢስን ፈንቀሽ «አን ቴሱ አኣሚሃ አት ደጋንትበአ፤ ጠዉ እኮጎሬ ኤተሮን አጥራመታንት» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ስሞን ጴጥሮስ «አት ኢ ሎከተ ሆሮን ኣንሽታንትበአ» ዬስ፤ ኢስን ፈንቀሽ «አን ሎከተ ኣንሽበጎሬ ኢች ወጡ ዮሄበአ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ስሞን ጴጥሮስን ፈንቀሽ «ቀርቾ! ህት እኮች ጠለዕል ሎከእ እሁዕነ አንገእለከ ቡዕለእ ሜጡበ ኣንሼኤ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ኢስን «አልስ ኣዕልሀን ጉዕሙ ጅስሙንኩስ ሙጩሩ እኮቤቺሃ ሎከስ ኣዕል ቤሉ ዎሉ ሀስሰኖስበአ፤ አዕኑ ሙጩራኖታን፤ ጠዉ እኮጎሬ ጉዕሙንኩክዕኔ ሙጩራኖተበአ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ኢስን «አዕኑ ጉዕሙንኩክዕኔ ሙጩራኖተበአ» ዬኢሁ ህግሽ ኣሰኖሲሁ አዬት ጎር ደገኖቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ኢስ ሎከተ ኣንሽ ሹሎች ኤተሮን ኦድኑስ ኦደዕይ ቤቾስ ፈንቀል አፉዕል «አን ክዕኔሃ አዕዮሚሃ አጥራመቴነንንዶ? ");
INSERT INTO alw_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","አዕኑ ኤሳሃ ‹አስተማርቹ› ‹ቀርቹ› ይቴነንተኤ፤ አን አስተማርቹለከ ቀርቹ እኮምቤቺሃ ይቴንታሁ ሀንቅሃን። ");
INSERT INTO alw_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ቴሱ አን ክዕኔሃ ቀርቹለከ አስተማርቹ እሀን ሎከክዕኔ ኣንሼሚች አዕኑሁ መት-መትክዕኔ ሎከተ ኣንሹ ሀስሰኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","አን ክዕኔሃ አዕዮምገን አዕኑሁ አቶኖተ ምሳልተ ኣስዮንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ሀንቅንከ ያንክዕኔ፤ ካዲንቹ ቀርቺች ህትን ሶቀመኖሁ ሶኮስሀኒች በተአኖበአ። ");
INSERT INTO alw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ከ ጠወ ደጌን ሆጎ አሌን ሆስሴንተ ጎር ማሰአንቴንታእረ እኬነንተ። ");
INSERT INTO alw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","አን ካን ያሚሁ ጉዕመንከክዕኔበአ፤ አን መጠሮም መነ አን ደጋም፤ ጠዉ እኮጎሬ መጻፋን ‹እቸተ ኢን ሜጡበ እቾሁ ኤሳሃ ባለጋረ እኮ› የመሞሁ ዊሞታት። ");
INSERT INTO alw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","አን ኩ ጠዉ እሁዕናን ሄጭ ኩላንክዕኔሁ ኩ ጠዉ እኮ ወክት አዕኑሁ አን ኤሳሃ እሁኤ ደጌነንተጋት። ");
INSERT INTO alw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ሀንቅንከ ያንክዕኔ፤ አን ሶሃሚሃ ቶገኖሁ ኤሳሃ ቶገኖ፤ ህትን ኤሳሃ ቶገኖሁ ኤሳሃ ሶኮኤሃ ቶገኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ኢስ ህካን ጠወዕዮች ኤተሮን ቀልቤስ ሻዥ «ሀንቅንከ ያንክዕኔ፤ ክዕኔች መቱ ኤሳሃ ህግሽ ኣሰኖ» ይ ጠወዕዮ። ");
INSERT INTO alw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","አሳባችስ እስ ከ ጠወ ጠወዕዮሁ አዬሃት ጎር ደግበቤቺሃ መት-መቱሰ ለኦኡ። ");
INSERT INTO alw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","አሳባች ኢስ ኢተኖሁ ኢስ መድ ጠምበቅይ አፉዕልዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ስሞን ጴጥሮስ እሱ ቀቀሽ «አዬተኔሃ ጠወአኖት ጎር ጠዕምስ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ህካን እኮቤቺሃ እስን ጎበስ ኢስቤቹ ሆንጠህሽ «ቀርቾ! ህግሽ ኣሰኖሄሁ አዬት?» ይ ጠዕሜስ። ");
INSERT INTO alw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ኢስን «ከ ጣቢተ ወጤን ቀሽ ዱሳንስሃን» ዬእ፤ ህካን ጠወዕይ ጣቢተ ወጤን ቀሽ አስቆሮንቶ ስሞኔ ቤቲ ይሁዲሃ ዱቅሾስ። ");
INSERT INTO alw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ይሁዲን ህካን ዱቆች ኤተሮን ቀልቤንከስ ሼይጣኑ ኣጎ፤ ኢስን ይሁደ «አቶተ ሰውይቶንቲሃ ደዕልት አእ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ህከኔ ማዳን አፉዕሌ መኒች አዪሁ ኢስ ህካን ሚሃ ዬጎር ደጎበአ። ");
INSERT INTO alw_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ይሁድ ብረ አፈኖሃ እኮቤቺሃ አሳባች መት-መቱሰ ኢስ ይሁደ «ሻሽግ ከበጃት ከበጅኖተ ሀስሰኖ ብረ ህከረንገ ቡጥቻኖተ ሰደቀተ ኣስ» ዬኢሃ አጉጆሰ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ይሁድን ዱቆች ኤተሮን ደዕለንስ አጉር ኦሮዕዮ፤ ሁኩ ወክቱንኩ ሀንከዕሬተ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ይሁድ ህከንቤቺች ፉል ኦሮዕዮ ወክት ኢስ «ቴሱ መንች ቤቱ ኬዕምኝ ደዕዮኡ፤ መገኑንኩ እስ መሳን ኬዕምኝ ደአኖ። ");
INSERT INTO alw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","መገኑ ቤቲ መሳን ኬዕምኝ ደኤኢች መገኑ ገዉንከስ ቤቲሃስ ኬዕምኝ ደዕልን ኣሰኖ። ");
INSERT INTO alw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ኢ ኦሶ! ክዕኔን ሜጡበ ቀዉ ወክት ዱንካም፤ አዕኑ ሀሴነንተኤ፤ አይሁዲሃ ‹አን ኦሮኣምቤቹ አዕኑ መርቶኖተ አታልቴነንተበአ› ዬምሀኒገን ቴሁ ክዕኔሃ ህት ያም። ");
INSERT INTO alw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ገገዉንኩክዕኔ ኢተቀንቶኖተ ሃዕሮ ትዛዝ ኣሳንክዕኔ፤ አን ክዕኔተ ኢታምገ ገገዉንኩክዕኔ መት-መቱክዕኔ ኢትዬ። ");
INSERT INTO alw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ገገዉንኩዕኔ ኢተቀንቴንተ ጎር አዎንቴነንተኤረ እሁክዕኔ መኑ ጉዕሙንኩ ደገኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ስሞን ጴጥሮስ ኢሰ «ቀርቾ! ሀከቤቹ መርተን?» ዬእ፤ ኢስን «አን መራምቤቹ ቴሱ አዎንቶኤተ አታልታንትበአ፤ ኤተሮን አዎንታንቴኤ» ይ ፈንቀሼስ። ");
INSERT INTO alw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ጴጥሮስን ፈንቀሽ «ቀርቾ! ሚሃት ቴሱ አዎኖሄተ አታላምበኢሁ? አን ፎልኤ ኪተኔሃ ህግሽ ኣሳም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ኢስን «አት ፎልክ ኢተኔሃ ህግስ ኣተንንዶ? ሀንቅንከ ያንኬ፤ ከበር ሀንጠቦ ዎዶተ ኢለ ሰሶረ ለገኣንቴኤ» ይ ፈንቀሼስ። ");
INSERT INTO alw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ኢስ «ቀልቡክዕኔ ህልቁንከ፤ መገኖን አመዕንዬ፤ ህትን ኢን አመዕንዬ። ");
INSERT INTO alw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","አንኤ ምኔን ልግቡ ቤቹ ዮኡ፤ ህካን እኮበእቀ ‹ቤቹ ቅጥ አኦህዕኔተ መራም› ያምበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","አን መር ቤቹ ቅጥ አዕዮንክዕኔ ወክት ፈንቀል አሜች አን ሄኣም ቤቾን አዕኑ ሄኦኖተ ኢቤቹ መሳንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","አን መራም ዎቃሃ ደጌነንተ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ቶማስን ኢሰ «ቀርቾ! አት መርታንትቤቹ ደንጎምበእሃ ሀት እንክ ዎቃስ ደንጎተ አታልናም?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ኢስን ፈንቀሽ «አን ዎቃሃ፥ ሀንቂሃለከ ሄኦሃን፤ ኢ አዲን እህባች አዪሁ አነ መገን ቤቹ መሮተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ኤሳሃ ደጌንተ እቃን አነኤ ደጌነንተ እቅ፤ እኮጎሬ ከ ኤተሩ ደጌነንተስ፤ ህትን ለኤንተስ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ፍልጶስን «ቀርቾ! አነ መገኑ ለሊስኔ፤ ሁኩን እሀኖኔ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ኢስን «ፍልጶሴ! አን ኬንከ ዘማን ክዕኔኤን ሜጡበ ሄአን ኤሳሃ ደጌነንቴኤበእንዶ? ኤሳሃ ለዕዮሁ አነ መገኑ ለዕዮሃን፤ ህካን እኮች አት ሀት ‹አነ መገኑ ለሊሴኤ› ይተን? ");
INSERT INTO alw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","አን አነ መገኖን ሄዕዮምገ ህትን አኑ መገኑሁ ኢን ሄኡስ አመዕንታንትበእንዶ? አን ክዕኔሃ ጠወኣም ላገት ገይኤ ዎልቃኒበአ፤ ጠዉ እኮጎሬ ኢን ሄአኖ አኑ መገኑ ሆጉስ አአኖ። ");
INSERT INTO alw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","አን አነ መገኖን ሄዕዮምገን ህትን አኑ መገኑ ኢን ሄዕዮገ አመዕንዬ፤ ሁኩን ዮበእ ጎሬ ሆጎእተኔሃ አመዕንዬ። ");
INSERT INTO alw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ሀንቅንከ ያንክዕኔ፤ ኢን አመዕነኖሁ አን አኣም ሆጉተ አአኖ፤ ህትን አን አነ መገን ቤቹ መራምቤቺሃ ህከኒች በተአኖሃ አአኖ። ");
INSERT INTO alw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","አኑ መገኑ ቤቲንከስ ከበጀሞተ ሱዕሚንከኤ ኡጭቴነንተ ጠወ ጉዕመንከ አኣም። ");
INSERT INTO alw_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","እኮስ ጠወሃ ሱዕሚንከኤ ኡጭቴንተ ጎር አን አኣም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ኢስ «ኢትቴነንተኤጎር ትዛዝኤ አገሬ። ");
INSERT INTO alw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","አኑ መገኑ ዘላለሚሃ ክዕኔኤን ሜጡበ ሄአኖ ዎሉ ጠራኝሳንቹ ኣሶህዕኔተ አን እሱ ኡጫም። ");
INSERT INTO alw_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","እሱንከ ከን ኣዱንያ አል መኑ ቶጎስበአ፤ መሰንትስ ለእበስቤቺሃለከ ደጉሆጎስቤቺሃት፤ እኮጎሬ እስ ክዕኔኤን ሜጡበ ሄአኖቤቺሃለከ ኣዜንከክዕኔ እሀኖቤቺሃ አዕኑ ደጌነንተስ። ");
INSERT INTO alw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","«አኑለከ አመት ዮበእ እለገ ህትን አጉራንክዕኔበአ፤ ክዕኔቤቹ ፈንቀል አሜታም። ");
INSERT INTO alw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ቀዎ ወክቲች ኤተሮን ከን ኣዱንያ አል መኑ ሆሮን ለአኖኤበአ፤ እኮጎሬ አዕኑ ለኤነንተኤ፤ አን ሄኣምቤቺሃ አዕኑሁ ሄኤነንተ። ");
INSERT INTO alw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","አን አኒንከኤ አዕኑ ኢን ህትን አን ክዕኔኤን ሄኡኤ ህከ በር ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«ትዛዙኤ እስቤቾን ዮኢሁለከ ትዛዝኤ አገረኖሁ ኤሳሃ ኢተኖ፤ ኤሳሃ ኢተኖንከ አኑኤ ኢተኖስ፤ ህትን አኒሁ ኢታንስለከ ገዉእ እሲሃ ለሊሳንስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","አስቆሮንቶ ይሁደ እሁዕነ ዎሉ ይሁድ ኢሰ «ቀርቾ! ገዉክ ከን ኣዱንያ አል መኒሃ እሁዕነ ኔሳሃ ለሊሳንቲሁ ሀትዪት?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ኢስ ፈንቀሽ «ኤሳሃ ኢተኖሁ ላገእ አገረኖ፤ አኑኤ ኢተኖስ፤ ነኡን እስቤቹ አሜንት እሲን ሜጡበ ሄዕናም። ");
INSERT INTO alw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ኤሳሃ ኢትባሁ ላገኤ አገረኖበአ፤ ኩ ሞጮጭቴነንተ ላገንት ኤሳሃ ሶኮኤ አኒኤተ ቤሉ ኢታበአ። ");
INSERT INTO alw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«አን ቴሱ ክዕኔኤን ሜጡበ ሄአንን ከ ጠወ ኩሎንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","እኮጎሬ አኑኤ ኢ ሱዕሚን ሶሀኖ ጠራኝሳንቹ ጠሊሉ አያኑ ጉዕመርቹንከ ተማርሰኖህዕኔ፤ ህትን አን ኩሎንክዕኔ ጠወ ጉዕመንከ ሰውይቶኖተ አአኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«ወገሬቱኤ ክዕኔን ሄአኖ፤ አን ወገሬትኤ ኣሳንክዕኔ፤ አን ኣሳንክዕኔ ወገሬቱ ከን ኣዱንያ አሉ ኣሰኖ ወገሬትጋበአ፤ ቀልቤክዕኔ ሻዞኖቼ፤ ህትን ዋጅቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","አን ‹ኦሮኣም፤ ፈንቀል ክዕኔቤቹ አሜታም› ዬሚሃ ሞጮጭቴንታአ፤ ኢትቴነንተኤ እቃን አንኤቤቹ መሪሃኤ ሙንደኤነንተ እቅ፤ መሰንትስ አኑኤ ኢች ሎረሃን። ");
INSERT INTO alw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ኩን እኮ ወክት አመዕንቶኖተ ቴሱ ሄጭን ጠዉስ እሁዕነ ኩሎንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ከኒች ኤተሮን ክዕኔኤን ልግብ ጠወኣምበአ፤ መሰንትስ ከን ኣዱንያ አል ሸይጣኑ አሜተኖ፤ እኮጎሬ ኢ አሌን እሲሃ መት ዎልቀቲ ዮስበአ። ");
INSERT INTO alw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ጠዉ እኮጎሬ አን አነ ኢታምገ ከን ኣዱንያ አሉ ደጎተ አኑኤ አዘዦኤገን አኣም፤ ኬዕዬ ከንቤቺች መርኖ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ኢስ «ሀንቅ ዎይን ላልቹ አኔት፤ ካሾኤንኩ አናኤ። ");
INSERT INTO alw_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ላልቹ ላልቡ ኢ አሌን ዮ ሀመ ጉዕመንከ አኑኤ ሙር ከመኖ፤ ላሊቹ ላለኖሃ አበ ላሎተ ጠር መክሰኖ። ");
INSERT INTO alw_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","አዕኑ አን ኩሎንክዕኔ ላገ መሳን ነጠ እኬንታእራን። ");
INSERT INTO alw_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","አዕኑ ኢን ሄዕዬ፤ አኒሁ ክዕኔኤን ሄኣም፤ ሀሙ ዎይን ላልቾን ሄእበ ጎር ጠለዕል ገዉስ ላሊቹ ላሎተ አታለኖበእገን አዕኑሁ ኢን ሄኤንባች ላሊቹ ላልቶኖተ አታልቴነንተበአ። ");
INSERT INTO alw_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«አን ወይኒሃ ላልቹ፤ አዕኑንገ ሀመሃን፤ አን እሶን እስንገ ኢን ዮኢሁ ልግብ ላልቹ ላለኖ፤ መሰንትስ አን ሄእባሃ መቱርቹሃ አቶኖተ አታልቴነንተበአ። ");
INSERT INTO alw_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ኢን ሄእቡ አዪሁ ሀምገ አብል ቶረም ሞለኖ፤ ህካንን ጭምአኤን ጊራን ዎሬን ቡሴኖ። ");
INSERT INTO alw_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","አዕኑ ኢን ሄኤንተ ጎሬ ኢ ላገንት ክዕኔኤን ሄኦ ጎሬ ሀሴንተርቹ ጉዕመንከ ኡጭዬ፤ ኣሰመኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","አዕኑ ልግብ ላልቹ ላልቴንተ ጎር አኑኤ ከበጀመኖ፤ ህትን አዕኑ ኤሳሃ አዎንታረ እሁክዕኔ ለሊሴነንተ። ");
INSERT INTO alw_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","አኑኤ ኢቴኤገን አኒሁ ክዕኔተ ኢቴንክዕኔ፤ ኢተኤ ኣዜን ሄዕዬ። ");
INSERT INTO alw_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","አን አንኤ ትዛዝ አገር ኢተስ ኣዜን ሄዕዮምገን አዕኑሁ ትዛዝኤ አገርቴን ኢተኤ ኣዜን ሄኤነንተ። ");
INSERT INTO alw_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ካን ኩሎንክዕኔሁ ሙንዲኑኤ ክዕኔኤን እኮተለከ አበ ሙንደኦኖታት። ");
INSERT INTO alw_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ኢ ትዛዙ አን ኢቴንክዕኔገን አዕኑሁ መት-መቱክዕኔ ኢትቶኖታት። ");
INSERT INTO alw_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","መንቹ ፎልስ ጃላተስ ህግሽ ኣሲች በተኣ ኢተት ዮበአ። ");
INSERT INTO alw_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","አዕኑ አን አዘዦንክዕኔሃ አቴንተጎሬ ኢታ ጃለ። ");
INSERT INTO alw_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ቀርቹ አአኖ ጠወ ካዲንቹ ደገኖበእቤቺሃ አን ከ ኤተሩ ክዕኔኤተ ‹ካዲመኤ› ያምበአ፤ ጠዉ እኮጎሬ አኒችኤ ሞጮጬሚሃ ጉዕመንከ ለሊሾንክዕኔቤቺሃ ‹ጃለኤ› ዬንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","አን መጠሮንክዕኔ ቤሉ አዕኑ መጠርቴንታኤበአ፤ አን ሶኮንክዕኔሁ ልግብ ላልቹ ላሊቶኖተለከ ላሊቹንኩ ሄአኖሃ እሆተ መጠሮንክዕኔ፤ ህካን እኮቤቺሃ አዕኑ ሱዕሚንከኤ ኡጭቴነንተርቹ ጉዕመንከ አኑኤ ኣሰኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","አን አዘዛንክዕኔ ትዛዙ መት-መትንከክዕኔ ኢተቀንቶኖታት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ኢስ ኩ ኣዱንያ አሉ ግቦህኔጎሬ ክዕኔኤች ብርተ ኤሳሃ ግቦሃ እሁስ ደጌ። ");
INSERT INTO alw_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","አዕኑ ከን ኣዱንያ አሊች እኬንተ እቃን ኩ ኣዱንያ አሉ ኢተኖህዕኔ እቅ፤ ጠዉ እኮጎሬ አዕኑ ከን ኣዱንያ አሊች እኬንበቤቺሃለከ አን ከን ኣዱንያ አሊች አደ አዕይ መጠሮንክዕኔቤቺሃ ኩ ኣዱንያ አሉ ግበኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","አን ክዕኔሃ ካዲንቹ ቀርቺችስ በተአኖበአ ይ ኩሎንክዕኔ ላገተ ሰውይዬ፤ ኤሳሃ ሸርቶኢች ክዕኔታሁ ሸርታአ፤ ኢ ላገተ አገርቶ እቃን ክዕኔ ላገታ አገርታ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","እኮጎሬ ኤሳሃ ሶኮሃ ደግበቤቺሃ ኢ መሳን ከ ጉዕመንከ ጠወ አታህዕኔ። ");
INSERT INTO alw_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","አን አሜች ኩሎንሰበእቃን ጩብ እሀኖሰበ እቅ፤ ጠዉ እኮጎሬ ቴሱ ጩቢሀሰ ደባቡርታርቹ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ኤሳሃ ግበኖሁ አነኤ ግበኖ። ");
INSERT INTO alw_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","አዪሁ አእበ ሆጉተ አን እሰ በላን አዕዮምበ እቃን ጩብ እሀኖሰበ እቅ፤ ጠዉ እኮጎሬ ካን ጉዕመንከ ለእ ኤሳለከ ኢ አነ ግቦኡ። ");
INSERT INTO alw_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ኩን እኮሁ እሰ ሕጋን ህትን ግቦኤ የመም ከተበሞሁ ዊሞታት። ");
INSERT INTO alw_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ጠዉ እኮጎሬ «አኒችኤ አሜተኖሁለከ አኒሁ አኒችኤ ሶሃንክዕኔ ጠራኝሳንቹ ሀንቅ አያኑ አሜቾጎር እስ ኢተኔ መሰከረኖ። ");
INSERT INTO alw_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ህትን አዕኑ ዎዕኔችን ኢን ሜጡበ ሄኤንተቤቺሃ መሰከርቴነንተ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ኢስ «አን ካን ጉዕመንከ ኩሎንክዕኔሁ አመዕነቲችክዕኔ ኡቤነንተበእገ ይዪት። ");
INSERT INTO alw_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ጭምት ምናች ፉሽት ሸርታህዕኔ፤ ሀንቅንከ ክዕኔኤተ ሸኖሁ ጉዕሙንኩ መገኒሃ አአኖሃ አጉደኖ ወክቱ አሜተኖ። ");
INSERT INTO alw_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","እሰ ህካን አታኢሁ ኤሳለከ አነኤ ደጋበእቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ጠዉ እኮጎሬ አን ካን ክዕኔሃ ኩሎንክዕኔሁ ወክቱስ ኢሌረ ከን ጠውተኔሃ መ ዬንክዕኔጎር ቃጎኖታት፤ አን ካን ከኒች ብርተ ኩልበህዕኔሁ አን ክዕኔኤን ሜጡበ ሄዕዮምቤቺሃት» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ኢስ «ጠዉ እኮጎሬ ቴሱ ሶኮኤሀንበ ኦሮኣም፤ እኮጎሬ ክዕኔች አዪሁ ‹ሀከቤቹ መርተን?› ይ ጠዕምዮኤበአ። ");
INSERT INTO alw_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","እኮጎሬ አን ካን ኩሎንክዕኔቤቺሃ ቀልቤንከክዕኔ ሻዙት ዊንቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","እሁን ቤሉ አን ሀንቅንከ ያንክዕኔ፤ ኢ ኦሮኡ ክዕኔኤሃ ደግለለኖህዕኔ፤ መሰንትስ አን ኦሮእባች ጠራኝሳንቹ ክዕኔቤቹ አሜተኖበአ፤ አን ኦሮዕዮሚች እሱ ክዕኔቤቹ ሶሃም። ");
INSERT INTO alw_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","እስ አሜቾ ወክት ከን ኣዱንያ አል መኒሃ ጩብሰ ኩሎች ኤተሮን ጩብተኔሃ፥ ጠሊልመተኔሃለከ ፍርድተኔሃ መሃጎር ለሊሽ ኩለኖ። ");
INSERT INTO alw_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ጩብተኔሃ ኩለኖሳሁ ኢን አመዕኑ ግቦቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ፈይመተኔሃ ኩለኖሁ አንኤቤቹ ኦሮኣምቤቺሃትለከ ከኒች ኤተሪሃ ለኤነንተበእቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ህትን ፍርድተኔ ኩለኖሁ ከን ኣዱንያ አል ዳኝ አሌን ፈረደሞቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«ዎሉ ኩላንክዕኔ ልግቡ ጠዉ ዮኡ፤ እኮጎሬ ቴሱ ጠወስ ቀልቤክዕኔ አፌን አታልቴነንተበአ። ");
INSERT INTO alw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ሀንቅ አያኑ አሜቾ ወክት ሀንቅ ጉዕመንከ ደጌነንተገ አአኖህዕኔ፤ መሰንትስ እስ ጠወአኖሁ ሞጮጬኢሃት ቤሉ ገዪችስ መቱርቹሃ ጠወአኖበአ፤ እስን ከ ኤተሩ አሜተኖ ጠወ ኩለኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","እስ ኢች ኣእ ኩለኖህዕኔቤቺሃ ኤሳሃ ሎርሰኖ። ");
INSERT INTO alw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ኢ አኒሃ እኮሁ ጉዕሙንኩ ኢሃን፤ ‹ኩ ኢች ቶግ ክዕኔሃ ኩለኖህዕኔ› ዬሚሁ ከኒሃት። ");
INSERT INTO alw_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«ቀዎ ወክቲሃ ለኤነንተኤበአ፤ ህትን ቀዎ ወክቲች ኤተሮን ለኤነንተኤ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","አሳባችስ መት-መቱ «ኩ ‹ቀዎ ወክቲሃ ለኤነንተኤበአ› ህትን ‹ቀዎ ወክቲች ኤተሮን ለኤነንተኤ፤ አንኤቤቹ ኦሮኣም› የኖኔሁ መ ዩሃስ?» የቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ህትን «ኩ ‹ቀዎ ወክቲች ኤተሮን› የኖ ጠዉ መርቾሃን? መ ዩሃስጎሬ ደንጎምበአ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ኢስ እሰ ጠዕምቶስተ ሀሱሰ ደግ «ገገዉንኩክዕኔ ‹ቀዎ ወክቲሃ ለኤነንተኤበአ› ህትን ‹ቀዎ ወክቲች ኤተሮን ለኤነንተኤ› ዬምቤቺሃትንዶ መት-መቱክዕኔ ጠዕምቴነንታሁ? ");
INSERT INTO alw_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ሀንቅንከ ያንክዕኔ፤ አዕኑ ኦኤነንተ፤ ጠው እኮጎሬ ከን ኣዱንያ አል መኑ ሙንደኣአ፤ አዕኑ ሻዜነንተ፤ እኮጎሬ ክዕኔ ሻዙት ሙንዲኖን ዶረንታአ። ");
INSERT INTO alw_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","መንቹንት እልታ ወክቱ ኢሌ ወክት ንዕጠን ሻዛአ፤ እልት ኬኦች ኤተሮን ከን ኣዱንያ አሌን ጩሉ እለሞ ሙንዲኖን ዎኔ ኦርሸተ ሀባአ። ");
INSERT INTO alw_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ህትን አዕኑ ቴሱ ሻዜነንተ፤ ጠው እኮጎሬ አን ለንኪሃ ለኣንክዕኔ፤ ክዕኔ ቀልቡንኩ ሙንደአኖ፤ ሙንዲኑክዕኔ ክዕኔች ኣአኖሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«ህከ በር አዕኑ መቱርቹሃ ጠዕምቴነንተኤበአ፤ ሀንቅንከ ያንክዕኔ፤ አኑኤ ሱዕሚንከኤ ጠዕምቴነንተርቹ ጉዕመንከ ኣሰኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ቴሱ ኢለ ሱዕሚንከኤ መቱርቹሃ ጠዕምቴንታበአ፤ ሙንዲኑክዕኔ ዊመ እኮተ ዱአ አዕዬ፤ ደዕቴነንተ። ");
INSERT INTO alw_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«ቴሶ ኢለ ከ ጠወ ምሳሌን ኩሎንክዕኔ፤ ከ ኤተሩ ምሳሌን ኩላምበእ ወክቱ አሜተኖ፤ ጠው እኮጎሬ አንኤተኔሃ ጉዕመርቹንከ ለሊሽ ኩላንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ህከ በር አዕኑ አነኤ ሱዕሚንከኤ ኡጭቴነንተ ቤሉ አን ‹ክዕኔ ወጥ ኡጫምበአ› ");
INSERT INTO alw_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","መሰንትስ አኑኤ ገዉንኩስ ኢተኖህዕኔቤቺሃት፤ አኑኤ ኢተኖህዕኔሁ ኤሳሃ ኢትቴንተኤቤቺሃትለከ አን መገን አዲች አሜቾምገ አመዕንቴንተቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","አን መገን አዲን ኣዱንያ አል አሜቾም፤ ቴሁ ፈንቀል ኣዱንያ አል አጉር አንኤቤቹ ኦሮኣም» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","አሳበንት «ምሳሌን እሁዕነ ለሊስ ኩልቶንትኔ። ");
INSERT INTO alw_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","አት ጉዕመንከ ደጋንትገለከ አዪሁ ጠዕሙ ሀስሰኖበእገ ቴሱ ደንጎም፤ ህካን እኮቤቺሃ አት መገን አዲን አሜቶንትገ አመዕንናም» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ኢስ ፈንቀሽ «ቴሱ አመዕንቴንታንዶ? ");
INSERT INTO alw_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ጉዕሙንኩክዕኔ ኤሳሃ ሜጢሃእ አጉርቴን ብን ይቴነንተ ወክቱ አሜተኖት፤ ወክቱንኩስ ቴሱ ኢልዮኡ፤ ጠዉ እኮጎሬ አኑኤ ኢን ሜጡበ ሄዕዮቤቺሃ አን ሜጧኤበአ። ");
INSERT INTO alw_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ካን ክዕኔሃ ኩላሚሁ ኢን ሜጡበ ሄኤንተ ወክት ወገሬቱ እሆህዕኔታት፤ ከን ኣዱንያ አሌን ሄኤንተ ወክት ኦርሸት ዮኡ፤ ጠዉ እኮጎሬ ዋጅቶኖቼ፤ አን ከ ኣዱንያ አል ቄሎም» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ኢስ ህካን ጠወዕዮች ኤተሮን ሰማ ዋሽ ለአን «ኢ አና! ወክቱ ኢልዮኡ፤ ቤቱክ ኬዕምሶሄተ አት እሱ ኬዕምሲስ። ");
INSERT INTO alw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ህካን እኮቤቺሃ አት ኣቶንትስ መኒሃ ጉዕሚንከ ዘላለሚሃ ሄአኖ ሄኡ ኣሶተ ጉዕማንከ መን አሌን ሹምነቱ አቶንትስቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ዘላለሚሃ ሄኤኖ ሄኡ ዩ አት ሜጥቹክ ሀንቅ መገኑ እኮንት ኬሳለከ አት ሶኮንት መሲህ ኢሰ ደጉሃን። ");
INSERT INTO alw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","አን አኦተ ኣቶንቴኤ ሆጉተ ሹል አዕይ ኡለ አሌን ኬዕምሾንኬ። ");
INSERT INTO alw_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ኢ አና! ኣዱንያ አሉ ከለቀሙዕነ ሄጭ ኪቤቾን ሄዕዮኤ ኬዕምኚን ቴሱ ብሬክ ኬዕምሴኤ። ");
INSERT INTO alw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«ከን ኣዱንያ አሊች ኣቶንቴኤ መኒሃ ሱዕመክ ለሊሾም፤ እሰን ኪራን፤ አት እሰንተ ኤሳሃ ኣቶንቴኤ፤ እሰን ላገክ አገርቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","አት ኤሳሃ ኣቶንትርቹ ጉዕሙንኩ ኪች እኮገ እሰን ቴሱ ደጋአ። ");
INSERT INTO alw_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","አት ኣቶንት ላገተ ኣስዮንሰ፤ እሰን ቶጎኡ፤ አን ኪ አዲች አሜቱእ ሀንቅንከ ደጎኡ፤ አት ኤሳሃ ሶኮንትገን አመዕንቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«አን ኡጫሚሁ እሰተኔሃት፤ ኩ ኣቶንቴኤሁ ኪሃ እኮቤቺሃ እሳንከ ዱአ አኣም፤ ጠዉ እኮጎሬ ከን ኣዱንያ አል መኒሃ ዱአ አኣምበአ። ");
INSERT INTO alw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ኢሃ እኮ መኑ ጉዕሙንኩ ኪረ፤ ህትን ኪሃ እኮ መኑ ጉዕሙንኩ ኢሃን፤ አን እሳን ኬዕሜም። ");
INSERT INTO alw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","አን ከኒች ኤተሮን ከን ኣዱንያ አሌን ሄኣምበአ፤ እኮጎሬ እሰ ዮኢሁ ከን ኣዱንያ አሌኒት፤ አን ክቤቹ አሜቶታት፤ ጠሊለ ኢ አና! ንገን ሜጡ እኮተ ኣቶንቴኤ ሱዕሚንከክ አገርሰ። ");
INSERT INTO alw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","አን እሳን ሜጡበ ሄዕዮም ወክት አት ኣቶንቴኤ ሱዕሚንከክ አገሮንሰ፤ ህካን እኮቤቺሃ መገን ላገት ዊንቶተ ህከን በእ ጩል ቤሉ ሆሮን እሳች አዪሁ በዕዮበአ። ");
INSERT INTO alw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","እኮጎሬ አን ቴሁ ኪቤቹ አሜቶታት፤ አን ከን ኣዱንያ አሌን ሄአን ከን ጠወዕዮሚ ሙንዲኑእ ቀልቤንከኤ ዊንቶታት። ");
INSERT INTO alw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","አን ላገክ ኣስዮንሰ፤ አን ከን ኣዱንያ አሊች እህበገ እሰ ከን ኣዱንያ አሊች እኮበእቤቺሃ ከን ኣዱንያ አል መኑ ግቦሰ። ");
INSERT INTO alw_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ሂለርቺች አገርቶታት ቤሉ ከን ኣዱንያ አሊች ዎሉ አደ መስቶተ ኡጫንኬበአ። ");
INSERT INTO alw_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","አን ከን ኣዱንያ አሊች እህበሀንገን እሰ ከን ኣዱንያ አሊችበአ። ");
INSERT INTO alw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ሀንቅንከክ ጠሊላኑተ አእሰ፤ ላገክ ሀንቅሃን። ");
INSERT INTO alw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","አት ኤሳሃ ኣዱንያ አል ሶኮንቴኤገን አኒሁ እሰተ ከ ኣዱንያ አል ሶኮንሰ። ");
INSERT INTO alw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","እሰን ሀንቂን ጠሊላኑተ እኮተ አን ገዉእ እሰተኔሃ ጠሊለ እሆተ አደ አኣም። ");
INSERT INTO alw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«አን ጠለዕል እሰተ እሁዕነ እሰ ላገተ ሞጮጭት ኢን አመዕንተሀኑኡተ ዱአ አኣም። ");
INSERT INTO alw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ዱአ አኣሚሁ ጉዕሙንኩሰ ሜጡ እኮታት፤ ህትን ኢ አና! አት ኢን አንን ኪን ሄዕዮምገን እሰ ኒን ሄኦታት፤ አት ኤሳሃ ሶኮንቴኤገ ኣዱንያ አሉ አመዕኖታት። ");
INSERT INTO alw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ነኡ ሜጡ እንኮምገን ሜጡ እኮተ ኤሳሃ ኣቶንቴኤ ኬዕምኝ ኣሴንሰ። ");
INSERT INTO alw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","አን እሳን አት ኢን ሄኦንትገን እሰ ሹልት ሜጡ እካን ኣዱንያ አሉ አት ኤሳሃ ሶኮንትገለከ ኢትቶንት ጌሰ እሰንተ ኢትቶንትገ ደጋአ። ");
INSERT INTO alw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«ኢ አና! ኣዱንያ አሉ ከለቀሙዕነ ሄጭት ኢትቶንቴኤቤቺሃ ኣቶንቴኤ ኬዕምኝ ለእ ኩ አት ኣቶንቴኤሃ አን ሄዕዮም ቤቾን ኢን ሜጡበ ሄኦተ ሀሳም። ");
INSERT INTO alw_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ፈየ ኢ አና! ኣዱንያ አሉ ደጎሄበአ፤ ጠዉ እኮጎሬ አን ደጋንኬ፤ ኩ መኑ ኤሳሃ ሶኮንቴኤገ ደጎኡ። ");
INSERT INTO alw_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","አት ኤሳሃ ኢትቶንት ኢተት እሳን ሄኦተለከ አን እሳን እሆተ እሰን ሱዕመክ ደጋገ አዕዮም፤ ከ ኤተሩሃ ደጋገ አኣም» ይ ዱአ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ኢስ ህካን ጠዕወዮች ኤተሮን አሳባንተስን ሜጡበ «ቄድሮነ» ዬኖ ሀጨሬች ዉድ አደ ኦሮዕዮ፤ ህከኔን ካሴመ ሀቅ ኣዝ አሳባንተስን ሜጡበ ኣጎ። ");
INSERT INTO alw_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ኢስለከ አሳበት ህከን ቤቾን ልግብ ወክት ጭም ይታቤቺሃ ህግሽ ኣሰኖ ይሁድ ህከ ቤቹ ደገኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ህካን እኮቤቺሃ ይሁድ ልግብ ወታደረ፥ ቂስ አዎንሳኖችለከ ፈርሳዌች ሶሀንቶ ዘበኝ ሀለቀተ አዎንስ ህከ ቤቹ አሜቾ፤ እሰን ፋኖሰ፥ ችቡተለከ በገዝ ኦደተ አፍ አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ኢስ አሌስ አሜተኖ ጉዕመንከ ጠወ ደግ እሰበ መር «አዬ ሀሴነንታት?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","እሰን «ነዝሬት ኢሰ ሀንሳሚት» ይት ፈንቀሽቶኡ፤ እስን «አኔት» ዬሰ፤ ኢሰ ህግሽ ኣሴ ይሁድ እሳን ሜጡበ ኡርዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ኢስ «አኔት» ዬሰ ወክት ኤተሩ ዋልት ኡለ አሌን ኡቦኡ። ");
INSERT INTO alw_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ለንኪሃ ኢስ «አዬ ሀሴነንታት?» ዬሰ፤ እሰን «ናዝሬት ኢሰ ሀንሳሚት» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","እስን ፈንቀሽ «‹አኔት!› ይ ኩሎንክዕኔ፤ ሀሴነንታሁ ኤሳሂት ጎር እሰ መርቱን» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ህካን እኮሁ ኢስ «አት ኣቶንቴኤ መኒች መቱሃ ቤሾምበአ» ዬ ላገት ዊንቶታት። ");
INSERT INTO alw_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ስሞን ጴጥሮስን ብሰ አፎ እቅ፤ እስን ብሰ ፉሽ ሎረ ቂሲች ካዲንች መኬ አድ መጨተ ሙሮ፤ ህከን ካዲንች ሱዕሙንኩ «ማልኮሴ» ዬኖሃ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ኢስ ጴጥሮሴ «ብሰክ ኮቦንተክ ዎር፤ አኑኤ ኣሴኤ ኦርሸ ጠበቴሃ ቶጉ ሀስሰኖኤበእንዶ?» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ህከኒች ኤተሮን ዎታደሩለከ አዛዡ አይሁድ ዘበኝ ሀለቀንት ኢሰ አፍ ኡሱርቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","እሰን ሄጭት ሃነቤቹ መስቶስ፤ ሃነ ህከ ዘማን ሎረ ቂሲቹ እክ ሄዕዮ ቀያፍየ በሉ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ቀያፍን «መቱ መንቹ መንተኔሃ ሬዮጎር ጡመሃን» ይ አይሁድ መኒሃ ሸዦሃ መንቹ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ስምዖን ጴጥሮስለከ መቱ ዎሉ አሳበንት ኢሰ አዎንቶኡ፤ ህከ ዎሉ አሳቤቹንከ ሎሩ ቂሲቹ ደገኖስ እቅ፤ ህካን እኮቤቺሃ እስ ኢሲንን ሜጡበ ሎረ ቂሲች ግቤ ኣዝ ኣጎ። ");
INSERT INTO alw_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ጠዉ እኮጎሬ ጴጥሮስ ብትም ኤተር አዲን ኡርዮ እቅ፤ ሁኩ ሎሩ ቂሲቹ ደገኖስ አሳቤቹ ፈንቀል ፉል ብትመ አገርታ ሀፍቶን ኩል ጴጥሮሴ ኣዝ ኣግሾ፤ ");
INSERT INTO alw_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ህት ብትመ አገርታ ሀፍቱት ጴጥሮሴ «አት ከ መንች አሳባች መቶሃስበእንዶ?» ይቶስ፤ እኮጎሬ እስ «አን አሳባችበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ወክቱስ ቂዘኖ ቤቺሃ ካዲመትለከ ዘበኙ ከሰል ጊረተ ቡስት ኡርት ኢብጭታኢት እቅ፤ ጴጥሮስን እሳን ሜጡበ ኡር ኢብጨኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ሎሩ ቂስቹንኩ ኢሰ አሳበተኔሃለከ ተማርሰኖ ትምርትተኔሃ ጠዕሜስ። ");
INSERT INTO alw_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ኢስ «አን ጉዕማንከ መን ብሬን ጠወዕዮም፤ አይሁድ መኑ ጉዕሙንኩ ጭምይታ ቤቾን ጭምትሰ ምኔንለከ መገን ምኔን ተማርሴም፤ አን ገበጭ አዕይ ጠዕወዮም መቱ ጠዉሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ኤሳሃ ሚሃ ጠዕምተን? አን ጠወአን ሞጮጭቶረ ጠዕም፤ አን ጠወዕዮሚሃ እሰ ደጋአ» ይ ፈንቀሼስ። ");
INSERT INTO alw_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ኢስ ህካን ጠወዕዮ ወክት ህከኔ ኡርቶ ዘበኚች መቱ «ሎረ ቂስቺሃ ፈንቀሽታንቲሁ ህትጎተንዶ?» ይ ኢሰ መጫለ ዎቀሮ። ");
INSERT INTO alw_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ኢስ ፈንቀሽ «ሂለ ላገተ ጠወዕዮም ጎር ሂለ ላገተ ጠወዕዮምገ መሰከር፤ እኮጎሬ ጡመ ጠወዕዮሚሁ ሀንቅ እሀን ሚሃ ዎቀርተዕኔ?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ህከኒች ኤተሮን ሃነ ኢስ ኡሱረሞገን ሎረ ቂስች ቀያፍቤቹ ሶኮ። ");
INSERT INTO alw_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ህከኔን ስሞን ጴጥሮስ ኡር ጊረተ ኢብጨኖት እቅ፤ ህከኔ ሄዕዮ መኑንኩ ጴጥሮሴ «አት ህከ መንች አስባች መቶሃስበእንዶ?» ይቶስ፤ እስን «አን አሳባችበአ» ይ ለገዕዮ። ");
INSERT INTO alw_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ጴጥሮስ መጨስ ሙሮ መንች እሉ እሀኖሁ ሎረ ቂሲች ካዲማች መቱስ «ህከን ሀቅ ኣዜን እሲን ሜጡበ ለዕዮንኬበእንዶ?» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ጴጥሮስ ለንኪሃ ለገዕዮ፤ ህከ ወክትንከ ሀንጠቦ ዎጆ። ");
INSERT INTO alw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ህከኒች ኤተሮን ኢሰ ቀያፍ ምኒች ሮም ባድ ገሻንች ግብተ መስቶስ፤ ወክቱስ ገስመ ሱጴተ እቅ፤ አይሁዱ ሻሽግ ከበጃተ ጎረጤኖ ሆልቹ እታቤቺሃ ንጃሳበእገ ይት ባድ ገሻንች ግቤ ኣዝ ኣጎበአ። ");
INSERT INTO alw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ህካን እኮቤቺሃ ጲላጦስ እሰበ ፉል «ከን መንች አሌን ክሰ ሆንጠህሴንታሁ መርቾሃን?» ይ ጠዕሜሰ። ");
INSERT INTO alw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","እሰን «ኩ መንቹ ሂለ ጠወ አዕዮበእቀ ኬሳሃ ህግንስ ኣስናምበ እቅ» ይት ፈንቀሽቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ጵላጦስን «አዕኑ መስቴን ሕግንከክዕኔ ፈረጄ» ዬሰ፤ እሰን «ነኡ መነ ሽናም ዳኝነቱ ኣሰሞኔበአ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ካን እኮሁ ኢስ ሀትኔ ሬሁተ ሬሀኖ ጎር ጠወዕዮ ላገት ዊንቶታት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ጵላጦስን ፈንቀል ምንስ ኣግ ኢሰ ገእ «አት አይሁድየ ዎመንዶ?» ይ ጠዕሜስ። ");
INSERT INTO alw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ኢስን «አት ካን ይታንቲሁ ገይችክትንዶ ህከረንገ ዎሉ መኑ ኢተኔሃ ኩሎሄ?» ይ ጠዕሜእ። ");
INSERT INTO alw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ጵላጦስ ፈንቀሽ «አን አይሁድቾሃንዶ? ኬሳሃ ኤሳሃ ህግስ ኣቶሄሩ ዘሬተክለከ ቂስተ አዎንሳኑ፤ አት መ አቶንት?» ይ ጠዕሜእ። ");
INSERT INTO alw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ኢስ «ኢ ዎምነቱ ከን ኣዱንያ አሊችበአ፤ ዎምነቱኤ ከን ኣዱንያ አሊች እኮ እቃ አይሁድ አንጋን ኣጋምበእገ ካዲመኤ ኦለንተ እቅ፤ እኮጎሬ ዎምነቱእ ከን ኣዱንያ አሊችበአ» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ጵላጦስን «ህከረ አት ዎማንዶ?» ዬእ፤ ኢስ «ዎመ እሁኤ አት ይቶንቴኤ፤ አን ከለቀሞሚሁለከ ከ ኣዱንያ አል አሜቾሚሁ ሀንቅተኔሃ መሰከሮታት፤ ሀንቅ አዲን እኮሁ ጉዕሙንኩ ላገኤ ሞጮጨኖ» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ጵላጦስን «ሀንቁ መርቾሃን?» ዬስ፤ ህካን ጠወዕዮች ኤተሮን ጵላጦስ ለንኪሃ ፉል «አን ከን መንቾን መቱ ቤሾርቹሃ ደጎምበአ። ");
INSERT INTO alw_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ጠዉ እኮጎሬ ሻሽግ ከበጀ ወክት ኡሱሬመ መኒች መቱ ሂራንክዕኔ ሴሩ ዮቤቺሃ አይሁድ ዎመ ሂሮተ ሀሴነንንዶ?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","እኮጎሬ እሰ «ባርባኔ ሂር ቤሉ እሱ ሂርቶት!» ይተን ሎረ ላጋን ጨንጭቶኡ፤ ባርባን ወንበዴቾሃ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ህከኒች ኤተሮን ጵላጦስ ኢሰ መስ ኦልሲሾ። ");
INSERT INTO alw_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ዎታደሩንኩ ኡት አክሊለ መክስ ኢስ ቡዕላን ዎርቶኡ፤ ህትን ሰመ አጉደኖ ቢሸተ ኦድኑተ ኦዲሶስ። ");
INSERT INTO alw_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","እሰን መድስ ሆንጠክ «አይሁድ ዎመ! ወገሬቱ ኬሳሃ እሁን!» ይተን መጫለስ ዎቀርታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ጵላጦስ ምኒችስ አብል ፉል «ሁኩዕኑን አን ከን መንቾን መቱ ቤሱሃ ደጉ ሆጉኤ ደጎኖተ እሱ አብል ፉሻንክዕኔ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ህካን እኮቤቺሃ ኢስ ኡት አክሊለ ቡዕለስ አዕይ ሰመ አጉደኖ ቢሸ ኦድኑተ ኦደዕይ ፉሎ፤ ጵላጦስን «መንቹስ ሁኩዕኑን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ቂስ አዎንሳኑትለከ ዱእ ምኒ ዘበኙ ኢሰ ለኦ ወክት «ሰቀል! ሰቀል!» ይተን ሎረ ላጋን ጨንጭቶኡ፤ ጵላጦስን «አዕኑ ገዉክዕኔ መስቴን ሰቀሌ፤ መሰንትስ አን እስ አሌን መቱ ቤሱሃ ደጎምበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","አይሁዱንኩ እሲሃ ፈንቀሽት «ኔሳሃ ሕጉ ዮኔ፤ ኩ መንቹ ገዉስ መገን ቤቱ አዕዮቤቺሃ ህከን ሕግኔገ ሬሁ ሀስሰኖስ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ጵላጦስ ህከ ጠወ ሞጮጬ ወክት አበ ዋጄእ። ");
INSERT INTO alw_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","እስን ምኒስ ፈንቀል ኣግ ኢሰ «አት ሀከንቤቺችት?» ይ ጠዕሜስ፤ ጠዉ እኮጎሬ ኢስ መቱርቹሃ ፈንቀሽዮበአ። ");
INSERT INTO alw_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ህካን እኮቤቺሃ ጵላጦስ «መቱርቹሃ ጠወኣንትበእንዶ? ኬሳሃ ሂር ገፈሮተለከ ሰቀሎተ ሹምነቱ ዮኤገ ደጋንትበእንዶ?» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ኢስን ፈንቀሽ «መገን አዲች ሹምነቱ ኣሰሞሄበእቀ አት ኤሳሃ መቱርቹሃ አቶተ አታልታንትበአ እቅ፤ ህካን እኮቤቺሃ ኬሳሃ ህግሽ ኣሴሀን ጩቡስ በተአኖ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ጵላጦስ ኢስ ህካን ጠወአን ሞጮጬ ወክት ሂር ገፈሮተ ሀሾ እቅ፤ እኮጎሬ አይሁዱ «ከ መንቹ ገፈርቶንት ጎሬ አት ሮም ዎሚሃ ጃለበአ፤ መሰንትስ ገዉስ ዎመ አአኖሁ ጉዕሙንኩ ሮም ዎሚሃ ዲነሃን!» ይተን ጨንጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ጵላጦስን ህካን ሞጮጬ ወክት ኢሰ አብል ፉሽ «ሻምባቀ ክኑ» የመሞ ቤቾን ፍርድ ቦርጭማን አፉዕሌእ፤ ሁኩ ቤቹ እብራዌ መን አፎን «ገበተ» የመመኖ። ");
INSERT INTO alw_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ሁኩ በሩንኩ ሻሽግ ከበጃቲሃ ተቃጠቤኖሃ በር እቅ፤ ወክቱስ ሌሆ ሳኣትሃ ጌሰ እቅ፤ ጵላጦስን አይሁዲሃ «ዎሙክዕኔ ሁኩዕኑን» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ጠዉ እኮጎሬ እሰን «እሱ ከም! እሱ ከም! ሰቀል!» ይቶኡ፤ ጵላጦስን «ዎመክዕኔ ሰቀሉንዶ?» ዬሰ፤ ቂስ አዎንሳኑንት «ሮም ዎም ቤሉ ኔሳሃ ዎሉ ዎሙ ዮኔበአ» ይት ፈንቀሽቶስ። ");
INSERT INTO alw_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ህከ ወክት ኢሰ ሰቀሎኖተ ጵላጦስ ህግሽ ኣሴእ፤ እሰን አፍ መስቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ህከኒች ኤተሮን ኢስ ገይስ መስቀለ እጅ «ቡዕል ቁላሃ» ዬኖቤቹ ፉሎ፤ ሁኩ ቤቹ እብራዌ መን አፎን «ጎልጎተ» ዬኖሃን። ");
INSERT INTO alw_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ህከንቤቾንን እሱ ሰቀልቶኡ፤ ህትን ዎሉ ለሙ መንቹ መቱ መኬ አዲን መቱስ ጉራ አዲን አት ኢሰ በለሰ ሰቀልቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ጵላጦስን «አይሁድ ዎመ፤ ናዝሬት ኢሰ» የኖሃ ከተብ ሰቀለሞ መስቀል ቡዕል አዲን አኦኖተ አዘዦ። ");
INSERT INTO alw_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ኢስ ሰቀለሞ ቤቹ ከተሚሃ ግደኑ እኮቤቺሃ ልግቡ አይሁዱ ከተበሞሲሃ አነበቦኡ፤ ሁኩንን እብራዌ መን አፎን፥ ላቲን አፎንለከ ግርክ አፎን ከተበሞእሃ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","አይሁድ ቂሰ አዎንሳኑት ጵላጦሴ « ‹አን አይሁድያ ዎመ› ዬገ ከተብ ቤሉ ‹አይሁድ ዎመ› ይት ከተቦት» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ጵላጦስን «ከተቦሚንከ ከተቦም» ይ ፈንቀሼሰ። ");
INSERT INTO alw_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ዎታደሩንኩ ኢሰ ሰቀልቶች ኤተሮን ኦድኑስ መስት ቡዕለ ቡዕለሰ መት-መቱ እሎሰተ ቀምቢሰስ ፌስ ሾሉ ቤቹ ቤኮእ፤ ጠው እኮጎሬ ቀምቢሱስ አሌች ዎሮ ኢለ ጎበሙዕነ ሜጡበ ደደሞእሃ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ህካን እኮቤቺሃ ዎታደሩ «አዬሃ እለኖ ጎሬ ለዕኖተ እጠ ኡጅኖ ቤሉ ቀምቢሰ ፊልኑንከ» ይቶኡ፤ ሁኩንን እኮሁ «ኦድኑኤ ቤቀንቶኡ፤ ቀምቢሰኤ እጠ አቶኡ» ይታ ጠሊለ መጻፍ ላገት ዊንቶታት፤ ዎተደሩንኩ ህትን አቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ህከ ወክት ኢስ መስቀል መዴን አመስ፥ አመስ አመ ቤቱቲ፥ ቀሎጴ መንቹት መርየመለከ መግደል ከተም መርየመ ኡርቶ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ኢስ አመስለከ እስ ኢተኖሰ አሳበስ መዴንከስ ኡርታን ለዕዮ ወክት አመስ «ቴ መንቾ! ቤቱክ ሁኩዕኑን» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ህትን አሳቤችሃስ «አመክ ትዕኒን» ዬስ፤ ህከን ወክቲች ኬሽ ሁኩ አሳቤቹ ኢስ አመተ ምንስ መሴእ። ");
INSERT INTO alw_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ህከኒች ኤተሮን ኢስ ጉዕሙርቹንኩ ዊሞገ ደጎ፤ መጻፋን ከተበንቶ ላገት ዊንቶተ «ሰገቦኤ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ህከኔን ሆለጮ ዎይኑ ዊሞ ኦደት ሄኦ እቅ፤ ህካን እኮቤቺሃ ህከኔ ዮ መኑ ህከን ሆለጮ ወይነ ጥጢን ጬፍ አገደ አጉደኖ ሀቂን አፌስቤቹ ሆንጠህሶኡ። ");
INSERT INTO alw_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ኢስን ህከ ሆለጮሃ ፊጭ ዬች ኤተሮን «አበቀዕዮ!» ዬእ፤ እስን ቡዕለስ ሙግ አዕይ ሬዮ። ");
INSERT INTO alw_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ህከኒች ኤተሮን አይሁዱ ሰቀለንቶ መነ ጋለ ቢጤን ድሪሶኖተ ጵላጦሴ ኡጭቶኡ፤ መሰንትስ አበተ ተቃጠቤኖ በር እኮቤቺሃለከ ሁኩ ፎሎጭ በሩ አበ ከበጄኖሃ እኮቤቺሃ ህከን አባን ሬሹሰ መስቀል አሌን እሀኖበእጋት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ህካን እኮቤቺሃ ዎተደሩ መርት ኢሲን ሰቀለንቶ መን ጋለ ቢጦኡ። ");
INSERT INTO alw_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ኢስቤቹ አሜታ ወክት እስ ሬዮገ ለእ ጋለስ ቢጦበአ። ");
INSERT INTO alw_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ጠው እኮጎሬ ዎታደሪች መቱ ኢስ ምዛሹ በገዚን ቀሻን ህከ ወክትንከ ምዛሺችስ ቄጉለከ ውሁ ፉሎ። ");
INSERT INTO alw_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ህካን ለዕዮሁ አዕኑ አመዕንቴነንተገ መሰከሮ፤ ምስክሩንኩ ሀንቅሃን፤ እስ ጠወአኖሁ ሀንቅ እኮገ እስን ደገኖ። ");
INSERT INTO alw_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ሁኩን እኮሁ መጻፋን «እሲች መቱ ምቀሃ ቢጤኖበአ» የመም ጠሊለ መጻፋን ከተበሞሁ ዊሞታት። ");
INSERT INTO alw_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ህትን መጻፋን ዎሎ ቤቾን «እሰን ቀሶኢሃ እሌንከሰ ለኣስ» የኖ። ");
INSERT INTO alw_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","አይሁድ ሹመተ ዋጄቤቺሃ ማጠም ኢሰ አዎነኖ አርማት ከተም ዮሱፍ ኢስ ጀናዘተ ኣኦተ ጵላጦሴ ኡጬእ፤ ጵላጦስን «ኣእ» ዬሃንስ ዩሱፍ መር ጀናዘተ ድርሽ መሴእ። ");
INSERT INTO alw_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ዎዕኔ ሀዎሮን ኢስበ ኦሮዕዮ «ንቆድሞሴ» ዬኖ መንቹ ሰጅኔ መት ክሉተ እሀኖ ሀንቀፍቱተ አጉደኖ ካርቤተለከ ቁዕረንደ ልቀለቄማሃ አእ አሜቾ። ");
INSERT INTO alw_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","እሰ ለሙንኩሰ ኢስ ጀናዘተ መስት አይሁድ ሴርገ ሽቱተ ቡርት ጥጥ ኦድኖን ከፈንቶስ። ");
INSERT INTO alw_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ኢስ ሰቀለሞ መዴን ሀቀ ካሴኖ ቤቹ ሄዕዮ እቅ፤ ህከንቤቾንን አዪሁ ሞገምቡ ሃዕሮ ሎዱ ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ሁኩንን አይሁዱ አባተ ተቃጠበ በር እኮቤቺሃለከ ህከን ሎድቤቹ ግደኑ እኮቤቺሃ እሰ ኢስ ጀእዘተ ህከን ሎዳን ሞጎኡ። ");
INSERT INTO alw_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ሳምንት ወኔ በር ገስመ ሱጵተ አሩ ፉሉዕነ መግደል መርየመ ኢስ ሎድቤቹ መርቶኡ፤ ህከ ቤቹ ኢልቶገን ሎዱስ ጡፈሞ ክኑ ሎድ ኡሮች ፈንተዕዮሃ ለኦኡ። ");
INSERT INTO alw_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ህካን እኮቤቺሃ እሴ ስሞን ጴጥሮሴቤቹለከ ኢስ ኢተኖስ ዎሎ አሳባቤቹ ደጉደን መርት «ቀርቹ ሎዲች ፉሽት መስቶስ፤ ሀከቤቹ መስቶስ ጎሬ ደንጎምበአ» ይቶሰ። ");
INSERT INTO alw_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ህከ ወክት ጴጥሮስለከ ዎሉ አሳባት ፉልት ሎድቤቹ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ለሙንኩሰ ሜጡበ ደጉደንን ዎሉ አሳቤቹ አበ ደጉጅ ጴጥሮሴ ሄጭ ሎድቤቹ ኢሌእ። ");
INSERT INTO alw_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ሙግይ ሎድ ኣዝ ለአኖ ወክት ከፈኔመ ከፈኑ ህከኔ ዮኢሃ ለዕዮ፤ ጠዉ እኮጎሬ ኣዝ ኣጎበአ። ");
INSERT INTO alw_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ስሞን ጴጥሮስ አዎኝስ አሜች ሎድ ኣዝ ኣጎ፤ እስን ከፈኔመ ኦድኑት ህከኔ ዮኢሃ ለዕዮ፤ ");
INSERT INTO alw_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ህትን ኢስ ቡዕላን ጣጤማ ከፈኑ ዎሎ ከፈኒች አደ እክ ዎሎ ቤቾን ጣጠም ኡቦሃ ለዕዮ። ");
INSERT INTO alw_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ህከኒች ኤተሮን ሁኩ ሄጭ ሎድቤቹ ኢሌ ዎኔ አሳቤቹ ሎድ ኣዝ ኣግ ለዕይ አመዕኔእ። ");
INSERT INTO alw_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","መሰንትስ እሰ «ሬሆች ኬኡ ሀስሰኖስ» ይታ ጠሊለ መጻፍ ላገተ አጥራመቶበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ህከኒች ኤተሮን ለሙንኩ አሳበት ፈንቀልት ምንሰ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","መግደል መርየመ ኦአን ሎዲች አብል አዲን ኡርቶ እቅ፤ ኦአንን ሙግይት ሎድ ኣዝ ለኦኡ። ");
INSERT INTO alw_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","እሴን ኢስ ጀናዘት ሄኦ ቤቾን ዋጁተ ኦድኑተ ኦደኦ ለሙ መላይካት መቱ ቡዕል አዲን መቱንገ ሎከ አዲን አፉዕልቶኢሃ ለኦኡ። ");
INSERT INTO alw_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","እሰን መርየመ «ቴ መንቾ! ሚሃት ኦኣንቲት?» ይቶሴ። እሴን «ቀርቹኤ መስቶስ፤ መ አቶስጎሬ ደጎምበአ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ህካን ይት ኤተር አደ ፈንቀልት ኢስ ኡሬኢሃ ለኦኡ፤ ኢሰ እሁስ ደጎበአ። ");
INSERT INTO alw_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ኢስን «ቴ መንቾ ሚሃት ኦኣንቲት፤ አዬ ሀሳንቲት?» ዬሴ። እሴን ህከኔ ሆጉተ አአኖ መንቹ አጉጃንሴ «ቀርቾ አት መስቶንትስ ጎሬ አፉሽቶንት ቤቹ ኩሌኤ፤ አን መሳንስ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ኢስን «መርየመ!» ዬሴ። እሴን እስ አደ ዘህት ዕብራዌ መን አፎን «ረቡኒ» ይቶኡ፤ ፍሳረንትስ «አስተማርቾ» ዩሃን። ");
INSERT INTO alw_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ኢስ «አንኤቤቹ መሩዕነ ዮምቤቺሃ ኡልቶቴኤ፤ ጠዉ እኮጎሬ አመኤ ኦሶቤቹ መርት ‹አን አንኤለከ አንክዕኔበ መገንኤለከ መገንክዕኔበ አሌ መራም ይዮኡ› ይት ኩልሰ» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ህካን እኮቤቺሃ መግደል መርየመ አሳበበ መርት ቀርቹ ለኡሴለከ እስን መ ዬሴ ጎሬ ኩልቶሰ። ");
INSERT INTO alw_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ህከን ሳምንት ዎኔ በሬን ሀዎሮን አሳበት አይሁድ ዳኛኑተ ዋጅት ኡሩተ ጡፍ ምኒ ኣዜን ጭምይቶ እቅ፤ ኡሩት ጡፈንቶሀኔን ኢስ አሳበስ ጭምይቶ ምኒ ኣጎ፤ በለሰ ኡር «ወገሬቱ ክዕኔኤሃ እሁን» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ህካን ይ አንገስለከ ምዛሹስ ለሊሾሰ፤ አሳበንትስ ቀርቹ ለኦ ወክት ሙንደኦኡ። ");
INSERT INTO alw_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ህከኒች ኤተሮን ኢስ ለንኪሃ «ወገሬቱ ክዕኔሃ እሁን! አኑኤ ኤሳሃ ሶኮገን አኒሁ ክዕኔተ ሶሃም» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ህካን ይ እሰ አሌን ፎገልስ ኡፍ አዕይን «ጠሊለ አያነ ቶጎኡ፤ ");
INSERT INTO alw_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","አዕኑ ዎሎ መን ጩብ ፈቁን ይቴንታጎሬ ክዕኔ ጩቡሁ ፈቁን የመመኖህዕኔ፤ ህትን አዕኑ ዎሎ መን ጩብ ፈቁን ይቴንባች ክዕኔ ጩቡሁ ፈቁን የመመኖህዕኔበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ኢስ አሳበስበ አሜቾ ወክት ቶና ለሞ አሳባች መቱ ዲዲሞሴ ዬኖ ቶማስ እሳን ሜጡበ ሄዕዮበ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ህካን እኮቤቺሃ ዎሉ አሳበንት ቶማሴ «ቀርቹ ለዕኖንስ» ይት ኩልቶስ። እኮጎሬ እስ «ሙስማሪን ቀሴመ አንገስ ለእባችለከ ቤቾንከስ ዙሩዕማኤ ኣግስባች ህትን አንገኤ ምዛሾንከስ ዮ ጡላን ኣግስባች አመዕናምበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ሳምንቲች ኤተሮን አሳበስ ለንኪሃ ምኔን ሄኦሀኔን ቶማስ እሳን ሜጡበ ሄዕዮ እቅ፤ ኡሩት ጡፈንቶሀኔን ኢስ አሜች በለሰ ኡር «ወገሬቱ ክዕኔሃ እሁን!» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ህከኒች ኤተሮን ቶማሴ «ዙሩዕማክ ከቤቹ ኤብ አንገኤ ለእ፤ አንገክን ኤብ ምዛሾንከኤ ኣግስ፤ አመዕን ቤሉ አመዕንባሃ እኮት» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ቶማስን «ኢ ቀርቾ! ኢ መገኖ!» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ኢስን ቶማሴ «አት ለኦንቴኤቤቺሃ አመዕንቶንት፤ ለኡዕናን አመዕንታእሩ ማሰአንቶእራን» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ኢስ ከን መጻፋን ከተበሞበእ ልግብ አጀብሲሰኖ ጠወ አሳበስ ለአን አዕዮኡ፤ ");
INSERT INTO alw_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ጠዉ እኮጎሬ ኢስ መሲህ መገን ቤቱ እሁስ አመዕንቶኖተለከ አመዕንቴን እስ ሱዕሚን ሄኡ ደእቶኖተ ኩን ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ህከኒች ኤተሮን ኢስ ጥብራዶስ ባር መዴን አሳባተ ለንኪሃ ለሌእ፤ ለሌኢሁ ህትዪት፤ ");
INSERT INTO alw_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ስሞን ጴጥሮስ፥ «መልተተ» የመሞ ቶመስ፥ ገሊል ባዶን ሄዕዮ «ቃነ» ዬኖ ቤች ናትናኤል፥ ዘብድዮሴ ኦሱትለከ ዎሉ ለሙ አሳበት ሜጡበ ሄኦ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ስሞን ጴጥሮስ «ቁርጩሜተ ዎሻዶተ መሮታት» ዬሰ። እሰን «ኪን ሜጡበ መርናም» ይት መርት ጀልባን ኣጎኡ፤ ጠዉ እኮጎሬ ህከ ሀንከዕርተ መት ቁርጩሜተ አፎበአ። ");
INSERT INTO alw_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ኡለት ሶዘን ኢስ ባር ገበላን ኡሬእ፤ እኮጎሬ አሳበት ኢሰ እሁስ ደጎበአ። ");
INSERT INTO alw_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ኢስ «ኢ ኦሶ! ቁርጩሜት ዮህዕንዶ?» ዬሰ፤ እሰን «መቱርቹሁ ዮኔበአ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","እስን እሰንተ «ወሻደ ጀልብ መኬ አዲን ኡጅዬ፤ ደእቴነንተ» ዬሰ፤ ህካን እኮቤቺሃ ወሻደ ባር አሌን ኡጅቶኡ፤ ልግብ ቁርጩሜተ አፎቤቺሃ ወሻደሰ ጎሾሽት አታልቶበአ። ");
INSERT INTO alw_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ህከ ወክት ኢስ ኢተኖስ አሳቤቹ ጴጥሮስ «ቀርቹሃን!» ዬስ። ስሞን ጴጥሮስ «ቀርቹሃ» ዬኢሃ ሞጮጬ ወክት ሆጉተ አኦተ ኦድኑስ ፉሼቤቺሃ ወክትንከስ ኦድኑስ ኦደዕይ ባር ኣዝ ኮርጅ ኣጎ። ");
INSERT INTO alw_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","እኮጎሬ ዎሉሰ አሳበት ኡላች ጠለዕል ጥቤ ሜትር ጌሰ ቄዕርቶቤቺሃ ቁርጩሜት ዊንቶ ወሻዳ ጎሾሽተን ጀልባን አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","እሰን ጀልቢች ድርቶ ወክት ከሰል አሌን ዮ ቁርጩሜተለከ ጣቢተ ለኦኡ። ");
INSERT INTO alw_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ኢስን «ቴሱ አፌንተ ቁርጩሜች ኤቤ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ህካን እኮቤቺሃ ስሞን ጴጥሮስ ጀልባን ኣግ ጥብተ ኦንታይኔ ሰሱ ሎርሎሩ ቁርጩሜት ዊሞ ወሻደ ጎሾሽ አብል ፉሼእ፤ ልግብ ቁርጩሜተ አፎጎሬሁ ወሻዱስ ፊልተዕዮበአ። ");
INSERT INTO alw_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ህከኒች ኤተሮን ኢስ «አሜ እቼ» ዬሰ፤ እስ ቀርቹ እሁስ ጉዕሙንኩሰ ደጎቤቺሃ አሳባች መቱሁ «አት አዬት?» ይት ጠዕምቶተ መለልቶበአ። ");
INSERT INTO alw_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ህከኒች ኤተሮን ኢስ አሜች ጣቢተለከ ቁርጩሜተ ኬሽ ኣሴሰ። ");
INSERT INTO alw_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ኢስ ሬሆች ኬዕዮች ኤተሮን አሳባተስ ለሎተ ኩን ሰቅሃ ወክት እቅ። ");
INSERT INTO alw_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","እቸተ እቶኢች ኤተሮን ኢስ ስሞን ጴጥሮሴ «ዮነ ቤቶ ስሞኔ! እሰ ኢትታኤሀኒች በትስ ኢትተዕኔንዶ?» ዬስ። እስን «ኤ ቀርቾ! አን ኢታንኬገ አትን ደጋንት» ይ ፈንቀሼስ። ");
INSERT INTO alw_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ኢስን «ዉዕላኑኤ አላል» ዬስ። ለንኪሃ «ዮነ ቤቶ ስሞኔ! ኢትተዕኔንዶ?» ዬስ፤ እስን «ኤ ቀርቾ! ኢታንኬገ አትን ደጋንት» ዬስ፤ ኢስን «ቆርባበኤ አገር» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ሰቂሃ «ዮነ ቤቶ ስሞኔ! ኢትተዕኔንዶ?» ዬረ ሰቅ ወክት «ኢትተዕኔንዶ» ዬስቤቺሃ ጴጥሮስ ሻዥ «ቀርቾ! አት ጉዕመርቹንከ ደጋንት፤ ህትን አን ኢታንኬገ ደጋንት» ዬስ፤ ኢስን «ሆለኤ አላል። ");
INSERT INTO alw_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ሀንቅንከ ያንኬ፤ አት ዎደልማን ዮንት ወክት ቀበቱተ ገይክ አንጋን ቆዕርት ሀሶንትቤቹ መርታንት እቅ፤ እኮጎሬ ባልቆንት ወክት አት አንገክ አሌ ዋሽት ኬሳን ዎሉ መኑ ቆርስሴኖሄ፤ መርቶተ ሀስበቤቹ መሰኖሄ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ህካን ዬኢሁ ጴጥሮስ ሀትኔ ሬሆን መገኑ ሎርሰኖገ ለሊሶታት፤ ህከኒች ኤተሮን ጴጥሮሴ «አዎኔኤ!» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ጴጥሮስ ኤተሩ ዋል ለአኖረ ኢስ ኢተኖስ አሳቤቹ አዎነኖሃ ለዕዮ፤ ሁኩ አሳቤቹ መጨረሽ ሁርባት ወክቴን ኢስበ ሆንጠክ «ቀርቾ! ህግሽ ኣሰኖሄሁ አዬት?» ይ ጠዕምዮስሃ እቅ። ");
INSERT INTO alw_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ጴጥሮስ እሱ ለዕዮ ወክት «ቀርቾ! ኩ መንቹ መ እሀኖ?» ይ ኢሰ ጠዕሜእ። ");
INSERT INTO alw_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ኢስን «አን አሜቶተ ኢለ ሄኦተ ሀሳምረዕኑ! ኬሳሃ ም ኦርሾሄ? አት አዎኔኤ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ህከን መሳን አመዕናኖ በላን «ኩ አሳቤቹ ሬሀኖበአ» ዬኖ ዱዱቡ ኢሌእ፤ ጠዉ እኮጎሬ ኢስ «አን አሜቶተ ኢለ ሄኦተ ሀሳምረዕኑ! ኬሳሃ ም ኦርሾሄ?» ዬ ቤሉ «ሬሀኖበአ» ይዮበአ። ");
INSERT INTO alw_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ከን ጠውተኔሃ ጉዕመንከ መሰከሮሁለከ ከ ጠወ ከተቦሁ ህከን አሳቤቹ፤ እስ መሰከሮንኩ ሀንቅ እሁስ ደንጋም። ");
INSERT INTO alw_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ጠዉ እኮጎሬ ኢስ አዕዮ ልግቡ ዎሉ ጠዉ ዮኡ፤ ኤሳሃ አጉደኖኤሁ እስ አዕዮ ጠወ ጉዕመንከ መት-መትን ከተቤማ እቃን ከተቤመ መጻፋተ ኣዱንያ አሉ እሀኖሰበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ቴዎፍሎሴ! ዎኔኤ መጻፋን ኢስ አዕዮሀለከ ተማርሴኢሃ ጉዕመንከ ከተቦም። ከተቦሚንኩ ኢስ ሆጉስ ጀመሮ ወክቲች ኬሽ ");
INSERT INTO alw_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ሰማሃ ኦሮዕዮ በር ኢለ አዕዮሃት፤ ሰማሃ ኦሮዕዮሁ መጠሮ አሳባተ ትዛዝስ ጠሊለ አያኒን ኣሴሳች ኤተሮኒት፤ ");
INSERT INTO alw_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ልግብ ኦርሸተ ቶግ ሬዮች ኤተሮን ልግቤ ለልዮ ምስክርን ፎሊን እክ አሳባተ ገዉስ ለሊሾሰ፤ ሸይሉ በር ዊመ ለለንሰ መገን ዎምነትተኔሃ ጠወዕዮሰ። ");
INSERT INTO alw_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","መቱ ወክት እሳን ሜጡበ እተንለከ አገን ሄዕዮ ወክት ኢስ «አን ኩሎንክዕኔ አኑኤ ኣሴ ላገተ አገሬ ቤሉ ዬሩሳሌሚች ፉልቶኖቼ፤ ");
INSERT INTO alw_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","መሰንትስ ያህይ ዊን ጠመቆ፤ እኮጎሬ አዕኑ ቀወ በሬች ኤተሮን ጠሊለ አያኒን ጠመቀንቴነንተ» ይ አዘዦሰ። ");
INSERT INTO alw_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","እሰን ሜጡበ ጭምይቶሀኔን «ቀርቾ! ዎምነቱክ እስራኤሊሃ ፈንቀሽት ኣታንት ወክቱ ቴሶትንዶ?» ይት ጠዕምቶስ። ");
INSERT INTO alw_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ኢስን ፈንቀሽ «አኑ መገኑ ገይስ ዎልቃን ዬ ወክትለከ በር አዕኑ ደጎኖተ አታልቴነንተበአ። ");
INSERT INTO alw_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ጠዉ እኮጎሬ ጠሊሉ አያኑ ክዕኔ አሌን ድሬ ወክት ዎልቀተ ደእቴነንተ፤ ህከ ወክት ዬሩሳሌማን፥ ይሁድ ኡላን ጉዕማን፥ ሰማርያንለከ ኡለ ዳንገ ኢለ ምስክር እኬነንተ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ህካን ጠወዕዮች ኤተሮን እሰን ለአንስ አሌ ዋል ሰማሃ ኦሮዕዮ፤ ጎመንት እሌችሰ ቴልቶቤቺሃ ለኦስበአ። ");
INSERT INTO alw_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","እስን አሌ ዋል ኦሮአን እሰ ሰማሃ ቱክ ይት ለአንን ዋጁተ ኦድኑተ ኦደኦ ለም መናከት መዴሰ ኡርት፥ ");
INSERT INTO alw_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","«አዕኑ ገሊለ መኑ ሚሃት ሰማ ዋሽቴን ለኤነን ኡርቴንታአ? ኩ ሰማ ኦሮአን ለኤንተስ ኢስ ሰማ ኦሮአን ለኤነንስን ፈንቀል አሜተኖ» ይቶሰ። ");
INSERT INTO alw_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ህከኒች ኤተሮን እሰ ደብረ ዘይተ ዬኖ ቆታች ዬሩሳሌም ከተመ ፈንቀልቶኡ፤ ሁኩንን ዬሩሳሌሚች አበ በሬን ሃሞኖተ አታሌኖ ዎቄሃ ጌሰ። ");
INSERT INTO alw_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ዬሩሳሌመ አሜት ሄኣ ፉቅ ምኒ አሌ ክፍል ፉልቶኡ፤ እሰን «ጴጥሮሴት፥ ያህዪት፥ ያቁባት፥ እንድራሴት፥ ፍልጶሴት፥ ቶማሴት፥ በርቴሌሜዎሴት፥ ማቶሴት፥ እልፍዮሴሃ ቤቱ ያቁባት፥ ባዱስ ኢተኖ ስሞኔትለከ ያቁብሃ ቤቱ ይሁዳት።» ");
INSERT INTO alw_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ሁኩ ጉዕሙንኩ ኢስ አማን መርየማን፥ ለቤ አመስ ኦሶንለከ ዎሎ ሜንቲን ሜጡበ መቶሃ ቀልቢን ኡርሱዕናን ዱአ አታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ህከ ወክት ጴጥሮስ መት ጥብተ ለሞድም ጌሰ እሀኖ አመዕናኖ ጭምት በላን ኡር ");
INSERT INTO alw_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«አመኤ ኦሶ! ኢሰ አፎ መኒሃ አዎንሳንቹ እኮ ይሁድተኔሃ ጠሊሉ አያኑ ሄጭን ደዉዴ አፎን ጠወአንቶ ጠሊለ መጻፍ ላገት ዊሙ ሀስሰኖሴ። ");
INSERT INTO alw_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ይሁድ ከን ሆጎ ቤቀማንቹ እሆተ ኒንን ሜጡበ ዎለአሞኡ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ጠዉ እኮጎሬ ሁኩ መንቹ ሂለ ሆጎስ ብሪን ኡለተ ህዕሬእ፤ እስን ብርተ ዋል ጎምብሰም ኡባን ጎደቡስ ፍልተዕያን ህሌስ ፉልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ሁኩ ጠዉንኩ ዬሩሳሌማን ሄአኖ መንቤቾን ጉዕማንን ለሌእ፤ ህካን እኮቤቺሃ ሁኩ ቤቹ እሰ አፎን ‹አኬልዳመ› ዬን ገኤመ፤ ፍሳረንትስ ‹ቄግ ኡለተ› ዩሃን። ");
INSERT INTO alw_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ሁኩን እኮንኩ «ደውድ መጻፋን «‹እስ ሄአኖ ቤቹ ኦነ እሁን፤ ህከን ቤቾን አዪሁ ሄኡንከ› ህትን ‹እስ ሹምነትስ ሆጉተ ዎሉ መኑ ኣኡን›» የመም ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«ህካን እኮቤቺሃ ቀርቹ ኢስ ኒ በላን ፈንቀላመን ሄዕዮ ዘማን ጉዕመንከ ኒን ሜጡበ ሄኦሀኑኡች ");
INSERT INTO alw_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ህትን ያህይ ጥምቀቲች ኬሽ ቀርቹ ኢስ ሰማሃ ኦሮዕዮ በር ኢለ ኒን ሜጡበ ህከን መኒች መቱስ ኒን ሜጡበ ኬእሀስ ምስክር እሆተ ሀስሰኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","«ኢዮስጦሴ» ህከረንገ «በርሳባሴ» ዬኖ «ዩሱፈለከ» «ማትያሴ» ዬኖ ለሙ መንቹ ቅጥአቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","እሰን ዱአ አተን «መን ቀልብ ጉዕመንከ ደጋንት ቀርቾ! ከን ለምችሰ አዬስ መጠርቶንት ጎር ይሁድ አጉር ሬዮ ክድመተለከ ሶቀም ሆጉተ ቶግ ቤቾስ እሀኖሃ ለሊሶኔታት» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","እጠ ኡጄናን እጡ ማትያሴሃ እሌእ፤ ህካን እኮቤቺሃ እስን ቶና መቶንከ አሳባን ሜጡበ ዎለአሞ። ");
INSERT INTO alw_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ጴንጤቆስጤ ከበጃት ዬን ከበጄኖ ከበጀ ወክቱ እሌ ወክት አሳበስ ጉዕሙንኩሰ መቶ ቤቾን ጭምይቶ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ድንገቴን ጠረኘ ቦብርገ ዮ ላገት ሰሜች አሜት እሰ አፉዕልቶ ምኒ ዊሞ። ");
INSERT INTO alw_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ህከንቤቾንን ጊረ ለበነተ አጉደኖ መት-መት አረብት ለልቶሰ፤ እሰን ቤቀንት መት-መትሰ አሌን አፉዕልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ጉዕሙንኩሰ ጠሊለ አያኒን ዊንቶኡ፤ እሰን ጠሊሉ አያኑ አዕዮሰገን ዎሎ አፎን ጠወኡ ጀመርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ኣዱንያ አሌን ዮ ኡመቲች ጉዕሚችን አሜቶ መገኑ ዋጅታ አይሁዱ ዬሩሳሌማን ሄኣኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ህከ ላገተ ሞጮጭቶ ልግቡ መኑ ጭምይት አሜቶኡ፤ እሰን መት-መቱሰ ገይሰ አፎን ጠወአን ሞጮጭት አጀብሲጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ሁኩ መኑንኩ አበ አጀብሲጭት «ኩሩ ህት ጠወኣእሩ ጉዕሙንኩ ገሊላ መነበእንዶ? ");
INSERT INTO alw_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ነኡ ገዉኔ ከለቀሞም ባድ አፌን ጠወአን ሞጮጭናሚሁ ኩን መርቹሃን? ");
INSERT INTO alw_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ነኡ ጳርቴ ባድ መኑሁ፥ ሜድ ባድ መኑሁ፥ ኤላሜ ባድ መኑሁ፥ መስጴጦም ባድ መኑሁ፥ ይሁድ ባድ መኑሁ፥ ቄጳዶቅ ባድ መኑሁ፥ ጳንጦስ ባድ መኑሁ፥ እስይ ባድ መኑሁ፥ ");
INSERT INTO alw_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ፍርግ ባድ መኑሁ፥ ጵንፍል ባድ መኑሁ፥ ግብጽ ባድ መኑሁ፥ ሊብይ ባዶን ቄሬን ከተም መዴን ሄዕኖምሩ፥ ሮም ባዲች አሜንቶም አይሁዱለከ አይሁድ አዳ ዶረሞምሩ ዮም። ");
INSERT INTO alw_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ህትን ቀርጤስለከ አረብ ባድ መኑሁ መገን ሎረ ሆጉተ ገይኔ አፎን ጠወአን ሞጮጭናሚት» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ህካን እኮቤቺሃ ጉዕሙንኩ አጀብሲጭትለከ ይታኢሃ ሆግ መት-መቱሰ «ኩ ጠዉ መርቹሃን?» የቀንታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ጠዉ እኮጎሬ ዎሉሰ መኑ ቀለደን «ሰከርሰኖ አጌኖሃ አግ ሰከርቶኡ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ህከ ወክት ጴጥሮስ ቶነ መቶንከ አሳባን ሜጡበ ኡር ላገስ ጎት አዕይ «አዕኑ አይሁድ መኑለከ ዬሩሳሌማን ሄኤነንተሩ ጉዕሙንኩ ከ እኮ ጠወ ደጎኖተ ጠወኣሚሃ ሞጮጭዬ። ");
INSERT INTO alw_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ክዕኔሃ አመሰሎህዕኔ ቤሉ ኩ መኑ ሰከሮበአ፤ መሰንትስ ቴሱ ገስሜ ሰሶሃ ሰኣት። ");
INSERT INTO alw_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ጠዉ እኮጎሬ ኩን ነብዬቾ ኢዮኤላን ህት ይ ጠወአሞ ጠዉ ዊሞታት። ");
INSERT INTO alw_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","« ‹እስን መገኑ መጨረሽ ዘመኔን ህት እሀኖ፤ መናን ጉዕማንን፤ ጠሊለ አያኒችኤ አሌሰ ዱናም፤ ጎኑለከ ሜኣ ኦሱክዕኔ ራገ ጠወኣአ፤ ዎደለት መናመተ ለኣአ፤ ባልቀንት ሀቄተ ሀቃቅታአ። ");
INSERT INTO alw_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ህትን ህከ ዘመን ለቤለከ ሜንት ካዲመኤ አሌን ጠሊለ አያኒችኤ አሌሰ ዱናም፤ እሰን ራገ ጠወኣአ። ");
INSERT INTO alw_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","አን አጀብሲሰኖርቹ ሰሜ አሌን መላተ ኡለ አሌን ለሊሳም፤ ቄጉ፥ ጊረትለከ ዉሊሌ ጎመት እካአ። ");
INSERT INTO alw_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ሎሩለከ አጀብሲሰኖ ቀርች በሩ አሜቱዕናን ሄጭ አሩ ቱንስቹ እሀኖ፤ አገንቹንኩ ቄጉ አጉደኖ። ");
INSERT INTO alw_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ቀርች ሱዕመ ገአኖሁ አዪሁ ጡመኖ፤› ");
INSERT INTO alw_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«እስራኤል መነ! ተ ላገተ ሞጮጭዬ፤ አዕኑ ገዉንኩክዕኔ ደጌነንተገን ናዝሬት ኢስ መገኑ በላንከክዕኔ እስ አዲን አዕዮ ሎርሎረ ሆጎን፥ አጀብሲሰኖ ጠዊንለከ መላን መገን አዲን ክዕኔሃ ለልዮእሃ መንቹ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","እሱንከ መገኑ ሰውይ ቅጥአዕዮ ሰውቲንለከ ዎዕናንከ ዮስ ኤንኬዕኒን ክዕኔሃ ህግሴን ኣሴመ፤ አዕኑን ሕጉ ዮበእ መን አንጋን ሰቀለመኖገለከ ሬሀኖገ አቴንተስ። ");
INSERT INTO alw_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ጠዉ እኮጎሬ መገኑ ሬሆ ኦርሸተ ቤሽ ሬሆች ኬሾስ፤ መሰንትስ ሬሁት እሱ አፍ ፌሶተ አታልቶበአ። ");
INSERT INTO alw_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ደዉድ እስተኔሃ « ‹ቀርቹኤ ጉዕመ ወክት ብሬንከኤ ለኣም፤ መሰንትስ ጨነቀምበገ እስ መኬንተኤ እኮቤቺሃ አን ሌንቄቃምበአ። ");
INSERT INTO alw_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ህካን እኮቤቺሃ ቀልቡኤ ሙንደዕዮ፤ አረብንትኤ ሙንደእ ጠወኣአ፤ ህትን ሬሀኖ ጅስሙኤ ተብሴን ፎሎጨኖ። ");
INSERT INTO alw_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","መሰንትስ ፎልኤ ሬዮ መን በላን ሎድ ኣዜን አጉርታንትበአ፤ ህትን ጠሊለ እኮሃ ሎዳን ሸም ፈቆተ አታንትበአ። ");
INSERT INTO alw_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ቴሱ ሄእ ወቃሃ ለልሶንቴኤ፤ ኢን ሜጡ እሆንከክ ሙንዲኑኤ አበ እካአ፤› ");
INSERT INTO alw_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«አመኤ ኦሶ! ወዕኔ አነ እኮ ደዉድ ሬዮገ፥ ሞገሞገለከ ሎዱንኩስ ከበሬ ኢለሬተ ኒቤቾን ሄኡስ ለሊሽ ኩላንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ጠው እኮጎሬ ዳዉድ ካን ጠወዕዮንኩ ነብዬቹ እኮቤቺሃ መገኑ ‹ዘሬችክ መቱስ ኬዕምኝክ ቦርጭመ አሌን አፉሻም› ይ ጤሌዕል ኣሴ ተብሴ ላገተ ደገኖሃ እኮቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ህከን መሳን መሲሁ ሬዮ መን በላን ፈቀኖበእገለከ ማሉስ ሎዳን ሸም በእበገ ሄጭ ለዕይ መሲሁ ሬሆች ኬእተኔሃ ጠወዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ህከ ኢሰንከ መገኑ ሬሆች ኬሾስ፤ ህከን ጠዊሃ ነኡ ጉዕሙንኩኔ ምስክረታን። ");
INSERT INTO alw_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","መገን መኬን አፉዕሎተ አሌ ዋል ጠሊለ አያን ተብሳሃ መገኒች ቶግ ከ ለኤነንተለከ ሞጮጭቴነንተ ጠሊለ አያነ ዱኞ። ");
INSERT INTO alw_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","ደዉድ ሰማሃ ኦሮዕዮበአ፤ ጠዉ እኮጎሬ እስ « ‹ቀርቹ ቀርቺሃኤ ባለጋረክ ሎካችክ ዎሮን አኦተ ኢለ መኬንከኤ አፉዕል› » ይ ጠወዕዮኡ። ");
INSERT INTO alw_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«ቴሱ መገኑ ከ አዕኑ ሰቀልቴንተ ኢሰ ቀርቹለከ ቡረሞኢሃ አዕዮስገ እስራኤል አድ ኡመቱ ጉዕሙንኩ ጠረኝሽ ደጉን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","እሰን ህካን ሞጮጭቶ ወክት ቀልቡሰ ሻዞን ዊማን ጴጥሮሴለከ ዎሉ ሶቀማኑተ «ኒ አመኦሶ! መ አዕኑ?» ይት ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ጴጥሮስን «ጩቡክዕኔ አጉረሞተ ጩብክዕኔ ቶበቴን መት-መቱክዕኔ መሲህ ኢስ ሱዕሚን ጠመቀሜ፤ መገን ኣስቱተ እኮ ጠሊለ አያነ ቶጌነንተ። ");
INSERT INTO alw_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ተብሴስ ላገት ክዕኔሃትለከ እላተክዕኔት፤ ህትን መገኑ ቄዕራሺች ገኤሀኑኡታት» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ጴጥሮስን ዎሉ ልግብ ጠወ መሰከረን «ከን ሾከ ክልቀቲች ገዉክዕኔ ጡምሼ» የን ሸዦሰ። ");
INSERT INTO alw_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ህካን እኮቤቺሃ ላገስ ቶጎእሩ ጠመቀንቶኡ፤ ህከ በር ሰሱ ኩምተ እካ መኑ እሳን ሜጡበ እኮ። ");
INSERT INTO alw_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","እሰን ሶቀማኑት ተማርስታኢሃ ሞጮጭተን ሜጡበ ሄአን እቸተ ሜጡበ እተንለከ ዱአ አተን ጠረኝታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ህከ ወክት አሳበ አንጋን ልግቡ አጅበተለከ መላት እካቤቺሃ መኑ ጉዕሙንኩ ዋጄእ። ");
INSERT INTO alw_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","አመዕናኑት ጉዕሙንኩ ዮሰርቹ ጉዕመንከ ሜጡበ አት ሄኣኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ህትን ኡለሰለከ ዮሳሃ ጉዕመንከ ህርተን ብረሰ መት-መትንከ ሀስሰኖስ ጌሰ ቤካኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ጉዕመንከ በር መቶ ቀልቢን መገን ምኔን ጭም ይተን መት-መትሰ ምናን እቴኖሃ ሙንዲኖንለከ ጡመ ቀልቢን ሜጡበ እታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","እሰን መገኑ ገለትጭታኢት እቅ፤ ህትን ጉዕሙንኩ ከበጀኖሳት እቅ፤ ቀርቹንኩ በሬን በሬን አመዕንት ጡምታ መነሃ በርገኖሳት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","መቱ በር ጴጥሮስለከ ያህይ ዱአ አኤኖ ወክቴን ዱእ ምኒ መርታኢት እቅ፤ ሁኩንን ሆንሶሃ ሰኣት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ህከኔ «ምልካምተ» ዬኖ ዱእ ምኒ ኡሮን መኑ እጅ ጉዕመንከ በር ኤበኖ መቱ መንቹ ሄዕዮ እቅ፤ እስን አመስ ጎደቢች ኬሽ ናፈ እኮቤቺሃ አፉሼኖሲሁ ዱእ ምኒ ኣገኖ መኒች ሰደቀተ ኡጮታት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","እስን ጴጥሮስለከ ያህይ ዱእ ምኒ ኣጎተ አሜቱሰ ደጎ ወክት ሰደቀተ ኣቶስተ ኡጬሰ። ");
INSERT INTO alw_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ጴጥሮስ ያህዪንን ሜጡበ ህከ መንቹ ቱክ ይ ለዕይ «ኒ አደ ለእ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","እስን ሰደቀተ ኣታሲሃ አጉጃንስ እሰበ ለዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ጠዉ እኮጎሬ ጴጥሮስ «ብሩለከ ዎርቁ ዮኤበአ፤ እኮጎሬ ኤሳሃ ዮኤሃ ኣሳንኬ፤ ሁኩንን ናዝሬት መሲህ ኢስ ሱዕሚን ኬእ ሃም!» ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","እስን መኬስ አንገተ አፍ ኬሾስ፤ ህከ ወክት ሎከስለከ ሴዝ ምቁስ ጠረኜእ። ");
INSERT INTO alw_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ሾት ይ ኡሬእ፤ ህትን ሃሙንከ ጀመሮ፤ ህትን ሃመን፥ ቱጵ-ቱጵ የንለከ መገኑ ገለትጨን እሳን ሜጡበ ዱእ ምኒ ኣጎ። ");
INSERT INTO alw_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","እስን መገኒሃ ገለት ኣሰንለከ ሃመን መኑ ጉዕሙንኩ ለዕዮስ። ");
INSERT INTO alw_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ህትን «ምልካምተ ኡሩተ» ዬኖ ዱእ ምኒ ኡሮን አፉዕል ሰደቀተ ኡጨኖሃ እሁስ ደጎቤቺሃ እሲን እኮ ጠዊች ኬዕይ መኑ አበ አጀብሲጬእ። ");
INSERT INTO alw_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ሁኩ ፈዬ መንቹንኩ ጴጥሮሴችለከ ያህዪች መለዕለሙ ግብ አንገሰ አፍ ሄዕዮገን መኑ ጉዕሙንኩ ሜጡበ እክ አጀብሲጨን እሰቤቹ ደጉደን «ሱለይማን ሃመኖ ዎቃሃ» ዬኖቤቹ አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ጴጥሮስ ህካን ለዕይ መኒሃ «እስራኤል መነ! ከኒን ሚሃ አጀብሲጭቴነንታት? ነኡ ህትን ገይኔ ዎልቃን ህከረንገ መገኑ ዋጅንከኔ ኩ መንቹ ሃመኖገ አዕኖምሀንገ አቴን ሚሃት ቱክ ይቴን ለኤነንታት? ");
INSERT INTO alw_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","እብራሂም፥ ኢሳቅለከ ያቁብ አናከኔ ሰገዳ መገኑ አዕኑ ህግሴን ኣቴንተለከ ጵላጦስ ሂሮስተ ሀሾ ወክት ጵላጦሴ ብሬን ለገኤንተ ቤቱስ ኢሰ ከበጄስ። ");
INSERT INTO alw_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ጠዉ እኮጎሬ አዕኑ ጠሊለለከ ፈየ እኮሃ ግቤን መነ ሼ መንቹ ሂረሞህዕኔተ ኡጭቴንተ። ");
INSERT INTO alw_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ሄኡ ኣሰኖሃ ሽቴንተ፤ እኮጎሬ እሱ መገኑ ሬሆች ኬሾስ፤ ህከን ጠዊተኔሃ ነኡ ምስክርሃን። ");
INSERT INTO alw_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ኩ ለኤነንተለከ ደጌነንተ መንቹ ፈይ ጠረኜኢሁ ኢስ ሱዕሚን ደገሞ አመዕነቲኒት፤ ኢስ ሱዕሚን አመዕኒከስ ጉዕሚክዕኔ ብሬንን ዊመ ፈይመተ ደኤእ። ");
INSERT INTO alw_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«ቴሁ አመኤ ኦሶ! አዕኑ ኢስ አሌን አቴንተ ጠዉ ሹመክዕኔገን ደጉ ሆጊን አቴንተገ ደጋም። ");
INSERT INTO alw_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ጠዉ እኮጎሬ መገኑ ሄጭ ነብያኖ አፎን ‹መሲሁ ኦርሸተ ቶገኖ› ዬ ላገት ከን ሃሊን ዊንታገ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","ቴሱ ቀርቺች ሃዕሮ ወገሬት ዘማኑ አሜቶተ ዎዕናንከ መጠሮ መሲሁ ሶሆተለከ ጩብክዕኔ መገኑ አጉሮተ ቶበቴን ፈንቀሌ። ");
INSERT INTO alw_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","መገኑ ወዕኔችን ኬሽ ጠሊላኖ ነብያኖስ አፎን ጠወዕዮገን ኣዱንያ አሉ ጉዕሙንኩ መኮተ ኢለ ኢስ ሰማን ዱንኩ ሀስሰኖስ። ");
INSERT INTO alw_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ሙስ ‹ቀርቹ መገኑ ኤሳሃ ኬሾሀንገን አመክዕኔ ኦሶች ነብዬቹ ኬሰኖህዕኔ፤ እስ ኩለኖህዕኔሃ ጉዕመንከ ሞጮጭዬ። ");
INSERT INTO alw_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ሁኩ ነብዬቹ የኖሃ ሞጮጩ ግበኖሁ ጉዕሙንኩ መኒች አደ እክ በአኖ› ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ህትን ሳሜሊች ኬሽ እሲች ኤተሮን አሜቶ ነብያኑት ጉዕሙንኩ ከን ወክትተኔሃ ጠወኦኡ። ");
INSERT INTO alw_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","አዕኑ ነብያኖተ ረገኣኑታን፤ ህትን መገኑ እብራሂሚሃ ‹ኣዱንያ አል መኑ ጉዕሙንኩ ኪ ዘሬን ማሰአመኖ› ይ ወዕኔ አናካተክዕኔ ሜጡበ ኣጎ ወኣድ ላገተ ረገኤነንተረ። ");
INSERT INTO alw_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ህካን እኮቤቺሃ መገኑ ቤቱስ ኬሽ ሶኮሁ ሄጭ ክዕኔሃት እቅ፤ ህካን አዕዮሁ መት-መቱክዕኔ ሂለ ዎቄች ፈንቀልቴናን ማሰኦህዕኔታት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ጴጥሮስለከ ያህይ ኡመቲሃ ጠወአንን ቂሰትለከ ዱእ ምኒ ዘበኛኖ ሀለቅቹ ህትን ሰዱቃውት እሰቤቹ አሜት ");
INSERT INTO alw_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ለሙንኩ አሳበት ኢስ ሬሆች ኬኡስ ኡመቲሃ ተማርሲንከሰለከ ህከኒንን ሬሆች ኬኡ ኩልቶቤቺሃ ኡሙዕርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ህካን እኮቤቺሃ አፍሰ ኡለት ሀዎርቶቤቺሃ ሶዞተ ኢለ ኡሱር ምኔን አገርታገ አቶሰ። ");
INSERT INTO alw_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ጠዉ እኮጎሬ ላገሰ ሞጮጭቶ መኒች ልግቡሰ አመዕንቶኡ፤ አመዕንቶ ጎን ዎሊንሹ ኦንቶ ኩሜ ጌሰ በተዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ለንክስ በር ይሁድ ዳኛኑት፥ ባልቀትለከ ሕግ አስተማረት ዬሩሳሌም ከተማን ጭምይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ህከን ጭምይቶ መን በላን ሎሩ ቂስቹ ሃነ፥ ቀያፍ፥ ያህይ፥ እስክንድሮስለከ ሎረ ቂስች አበሮሱ ጉዕሙንኩሰ ሄኦኡ። ");
INSERT INTO alw_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","እሰን ጴጥርሴለከ ያህይ በላንከሰ ኡርስ «አዕኑ ከ ጠወ መ ወልቃን ህከረንገ አዬ ሱዕሚን አቴነንታት?» ይት ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ህከ ወክት ጴጥሮስ ጠሊለ አያኒን ዊም «አዕኑ ኡመት ገሻኑትለከ ባልቀት ሞጮጭዬ። ");
INSERT INTO alw_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ኔሳሃ ከበር ጠዕሜኖኔሁ መቶ ናፎ መንቺሃ አኤመስ ጡመ ሆጎተኔሃለከ ኩ መንቹ ሀት እክ ፈዩሲት። ");
INSERT INTO alw_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ኩ መንቹ ፈይ ብሬንከክዕኔ ኡሬኢሁ አዕኑ ሰቀልቴንተለከ መገኑንገ ሬሆች ኬሾ ናዝሬት መሲህ ኢስ ሱዕሚን እሁስ ክዕኔሃ ጉዕሚንከክዕኔለከ እስራኤል ኡመቲሃ ጉዕሚንከ ደገሞሃ እሁን። ");
INSERT INTO alw_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","አዕኑ ግምበ እጃርቴነንተሩ ህንቄን ኡጅቴንተ ክኑ ግምበስ ሙረበ ቡዕል ክኑ እኮ። ");
INSERT INTO alw_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ህካን እኮቤቺሃ ጡሙ ዎሎን አዬኒ ዮበአ፤ ጡምኖተ መን በላን ኡለ አሌን ጉዕማንን ዎሉ ኣሰሞ ሱዕሙ ዮበአ» ይቶሰ። ");
INSERT INTO alw_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ጴጥሮስለከ ያህይ መለልት ጠወኣገ ኦገት መኑ ለኦ ወክት ተማርቶበእ ገወ መነ እሁሰ ደግ አጀብሲጭቶኡ፤ እሰ ኢሲን ሜጡበ ሄኦእረ እሁሰ ደጎኡ። ");
INSERT INTO alw_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ሁኩ ፈዬ መንቹ እሳን ሜጡበ ኡሬኢሃ ለእ እሰ አሌን ይታኢሃ ሆጎኡ። ");
INSERT INTO alw_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ጠዉ እኮጎሬ ህከን ኦገት በሊች ፉልታገ አት ገገዉንኩሰን ");
INSERT INTO alw_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«ከ መነ መ አዕኑ? ሎረ መላት እሰ አንጋን አሰንታኢሃ ዬሩሳሌም መኑ ሄኣ ጉዕመ ቤቾንን ደገሞቤቺሃ ካንዶተ አታልናምበአ። ");
INSERT INTO alw_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ጠዉ እኮጎሬ ኡመት በላን አልባዕለን መረኖበእገ ከኒች ኤተሮን ከን ሱዕሚን አዬሃ ጠወኣበእገ ጠረኝንስ ዋጅሲንሶ» ይት አማዕለንቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ህከኒች ኤተሮን እሰተ ገእት ኢስ ሱዕሚን ሆሮን ጠወኣበእገለከ ተማርስታበእገ አዘዞኡ። ");
INSERT INTO alw_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ጠዉ እኮጎሬ ጴጥሮስለከ ያህይ ፈንቀሽት «መገን ትዛዝ ቶጉ ህከረንገ ክዕኔ ትዛዝ ቶጉ መገን አኔን ቆሀኖ እኮጎሬ ህንዴ አዕኑ ፈረጄ። ");
INSERT INTO alw_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ነኡ ሞጮጭኖሚሃለከ ለዕኖሚሃ ጠወኡ አጉሩ አታልናምበአ» ይቶሰ። ");
INSERT INTO alw_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","እሰን ጴጥሮሴለከ ያህይ ቀጠእሲሰኖ ጠወ አሌሰ ሆጎቤቺሃ መነ ዋጅት ለንኪሃ ዋጅሲስ ገፈርቶሰ፤ መሰንትስ መኑ ጉዕሙንኩ እኮ ጠውተኔሃ መገኑ ገለትጭታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ከን አጀብሲሰኖ ዎቄን ፈዬ መንቹ እለሞች ሸይሎ ዘማኒች በተዕዮስ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ጴጥሮስለከ ያህይ ሂረንቶች ኤተሮን ጃለሰቤቹ መርት ቂስ አዎንሳኑትለከ ባልቁ ይቶሰ ጠወ ጉዕመንከ ኩልቶሰ። ");
INSERT INTO alw_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","እሰን ህከ ጠወ ሞጮጭቶ ወክት ቀልብሰ ሜጡ አት ላገሰ መገን ቤቹ ኬስ «ሰማሃ፥ ኡለተ፥ ባረለከ ኣዜንከስ ዮእረ ጉዕመንከ ከለቆንት ቀርቾ መገኖ! ");
INSERT INTO alw_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ጠሊለ አያኒን ካዲንቾንተክ አናኔ ደዉዴ አፎን « ‹መገኑ ደግቡ መኑ ሚሃ ኡሙዕሬእ? መኑ ሚሃ ደግለልበ ጠወ አቶተ ሰውይቶኡ? ");
INSERT INTO alw_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ኡለ አል ዎመት ኬእ ህትን ገሻኑት ሜጡበ ጭምይት ቀርችለከ መሲህ አሌን ኬኦኡ› ይት ጠወኦንት መገኑ አቴት። ");
INSERT INTO alw_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«ሀንቅንከ ዎሙ ሄሮዲስለከ ጳንጦስ ባድ ጵላጦስ፥ አይሁደ እህበ መኒንለከ እስራኤል መኒን ሜጡበ ከን ከተማን ጭምይት መሲሁ ኣቶንት ጠሊለ ካዲንቾንተክ ኢስ አሌን ኬኦኡ። ");
INSERT INTO alw_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ህት እኮሁ አት ሄጭት ገይክ ዎልቃንለከ ሃሽኣቶን ሰውይቶንቲሃ አቶታት፤ ");
INSERT INTO alw_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ህትን ቀርቾ! ፎከሩሰ ለእ፤ ካዲመክ ላገክ ዋጅቱዕናን መለልት ጠወኣገ አእሰ፤ ");
INSERT INTO alw_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ጠሊለ ቤትክ ኢስ ሱዕሚን ጥዘናመት ፈይቶተ፥ አጅበተለከ አጀብሲሰኖ ጠዉ አሰሞተ አንገክ ሂር» ይተን ዱአ አቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","እሰን ዱአ አቶች ኤተሮን ጭምይቶ ቤቹ ሌንቄቄእ፤ ጉዕሙንኩሰ መገን አያኒን ዊንቶኡ፤ መገን ላገተ ዋጅቱዕናን መለልት ጠወኦኡ። ");
INSERT INTO alw_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","መገን መኑ ጉዕሙንኩ መቶ ቀልብንለከ ሰውቲን ሄኦኡ፤ እኮስ መንቹሁ «ኩን ኢሃን» የኖርቹ ዮበአ እቅ፤ በላንከሰ ጉዕሙርቹንኩ ቅጤሳሃ እቅ፤ ");
INSERT INTO alw_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","አሳበት ቀርቹ ኢስ ሬሆች ኬኡስ ሎረ ወልቃን መሰከርታኢት እቅ፤ ጉዕምሰ አሌኒን ሎረ መገን አያኑ ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","እሰ በላን ኦርጨቀሞሁ መቱሁ ዮበአ፤ መሰንትስ ኡለት ዮሲሁ ህከረንገ ምኑ ዮሲሁ ጉዕሙንኩ ህረን ብረ ኤበኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ህከ ብረ ኤበን ሶቀማኖ ብሬን አፉሽተን አዬሁ ሀስሰኖስ ጌሰ ቤሄነን ኣሴኖሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","«ቆጵሮሰ» ዬኖ ባድ መቱ መንቹ ሌዌ አዲሁ «ዩሱፈ» ዬኖሁ ሄዕዮ እቅ፤ እሱንከ ሶቀማኑት «በርናባሴ» ይት ገእታስ እቅ። ህት ዩሁ «ቦረሸተ ከመኖሃ» ዩሃን። ");
INSERT INTO alw_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ሁኩ መንቹንኩ ኡለስ ህር ብረስ ሶቀማኖተ ቶግስሾሰ። ");
INSERT INTO alw_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","መቱ «ሀናንየ» ዬኖ መንቹ «ሰጲረ» ዬኖ መንቾንከስን ሜጡበ ኡለተ ህሮ። ");
INSERT INTO alw_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ጠዉ እኮጎሬ ምንስ መንቹስ ደገን ኡለስ ህሮ ብሪች መቱ ጌሰ ፌሽ ፈቆስ ጌሰ ኤብ አሳባተ ቶግስሾሰ። ");
INSERT INTO alw_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ጴጥሮስን «ሀናንየ! ጠሊለ አያን አሌን ክዝቦተለከ ኡለተ ህርቶንት ብሪች መቱ ጌሰ ፌሶተ ሼይጣኑ ቀልቤንከክ ሚሃ ኣጎ? ");
INSERT INTO alw_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ህርቱዕነ ዎዕናሃ ኪሃበእንዶ? ህርቶንቲች ኤተሮኒሁ ብሩስ ኪሃበእንዶ? ከ ጠወ ሚሃ ቀልቤንከክ ሰውይት? አት ክዝቦንቲሁ መነ እሁዕነ መገኑሃት» ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","ሀናንየን ህከ ላገተ ሞጮጬ ወክት ኡብ ሬዮ፤ ዎደለት ኬእ ከፈንት እጅት ፉሽት ሞጎስ፤ ህከ ጠወ ሞጮጭቶእሩ ጉዕሙንኩ አበ ዋጅቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ሰሱ ሰኣት እሀኖ ወክቲች ኤተሮን እኮ ጠወ ደጉዕነ መንቹስ አሜት ኣጎኡ። ");
INSERT INTO alw_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ጴጥሮስን እሴተ «ህንዴ ኩሌኤ! ኡለክዕኔ ህርቴንታሁ ከን ጌሰ ብርሃትንዶ?» ዬሴ፤ እሴን «ኤ! ከን ጌሲሃንት ህርኖሚሁ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ጠዉ እኮጎሬ ጴጥሮስ «ቀርች ጠሊለ አያኒን ፌተንቶኖተ ሚሃ አማዕለንቴን? ምንክ መንቹ ሞጎ መኑ ኡሮን ዮኡ፤ ኬሳሁ ፉሽት ሞጋሄ» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ወክትንከስ ሎከስ መዴን ኡብ ሬቶኡ፤ ዎደለት ኣጋ ወክት ሬቶኢሃ ለእ መስት ምንሴ መንች ሎድ መዴን ሞጎሴ። ");
INSERT INTO alw_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ህካን እኮቤቺሃ አመዕናኑት ጉዕሙንኩለከ ህከ ጠወ ሞጮጬ መኑ ጉዕሙንኩ አበ ዋጄእ። ");
INSERT INTO alw_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","አሳበት ልግብ አጅበተለከ አጀብሲሰኖ ጠወ መን በላን አታኢት እቅ፤ ጉዕሙንኩ መቶ ቀልቢን እክ «ሱላይማን ሃመኖ ዎቃሃ» ዬኖቤቾን ጭምይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ዎሉ አዪሁ እሳን በርገሞተ መለሎበአ፤ እኮጎሬ መኑ ከበጀኖሳት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","እሁን ቤሉ ቀርቾን አመዕንቶ ጎንለከ ሜንት ዎሊንሹ ብሬች አበ በተአን መረኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","አሳበት አቶሀኒች ኬዕዮሀኒን ጴጥሮስ ህገን ዎሉ ፈቅ ሀሎስ መት-መቶ መን አሌን ኢሎተ መኑ ጥዘናመተ ዎቃ ፉሸን መዕነ አሌንለከ ዴስ አሌን ኦሲሳኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ህትን ዬሩሳሌም አዝጋጌን ሄኦ ከተሚች ጥዘናመተለከ ዶሮረኖ ዱሩ አፋንሰ ኦርጨቀንታእረ ኤቤናን ልግቡ መኑ ጭምየኖት እቅ፤ እሰ ጉዕሙንኩሰ ፈይታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ጠዉ እኮጎሬ ሎሩ ቂስቹለከ እሲን ሜጡበ ሄኦ ሰዱቃዌ አድ መኑ ምቀኝት አሌሰ ኬኦኡ። ");
INSERT INTO alw_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","አሳበተ አፍ ኡመት ኡሱር ምኒ ኣግሶኡ። ");
INSERT INTO alw_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","20","ጠዉ እኮጎሬ ቀርች መላይኬቹ ኡሱር ምኒ ኡሩተ ሀዎሮን ፈኝ እሰተ አብል ፉሽ «መሬ፤ መገን ምኔን ኡርቴን ኡመቲሃ ከ ሄእ ላገተ ሆርንተ ኩሌ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ህከ ላገተ ሞጮጭቶ ወክት ሶዘ ሱጵተ መገን ምኔን ኣግ ተማርስታኢት እቅ፤ ጠው እኮጎሬ ሎሩ ቂስቹለከ እሲን ሜጡበ ሄኦእሩ አሜት ኦገት መነለከ አይሁድ ባሊቅ ጉዕመንከ ሜጡበ ጭምአት ኡሱረንቶእረ ኤቦተ ኡሱር ምኒ ሶኮኡ። ");
INSERT INTO alw_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ሶሄመ ዘበኙ አሜት አሳበተ ኡሱር ምኔን ደጎሰበአ፤ እሰን ፈንቀልት አሜት ");
INSERT INTO alw_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«ኡሱር ምኑ ጠረኝ ቆለፈሞቤቺሃ አገርታእሩ ኡሮ ብሬን ኡርቶኢሃ ደንጎም፤ ኡሱር ምኒ ኡሩተ ፈኖም ወክት ኣዜንከስ አዬሁ ደንጎምበአ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ዱእ ምኒ ዘብ ሀለቅቹለከ ቂስ አዎንሳኑት ህካን ሞጮጭቶ ወክት «ኩን መርቾሃን?» ይት ጉረተ አጎሰ። ");
INSERT INTO alw_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ህከ ወክት መቱ መንቹ አሜች «ሁኩዕኑን! አዕኑ ኡሱር ምኒ ኣግሴንተ መኑ መገን ምኔን ኡርት ኡመት ተማርስታኢት» ይ ኩሎሰ። ");
INSERT INTO alw_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ህከ ወክት ዱእ ምኒ ዘበኝ ሀለቁለከ ካዲመስ መርት ኤቦኡ፤ ኤቦሳንኩ ዎልቃንበአ፤ ህካን አቶኢንኩ ኡመቱ ክኒን ቀሰኖሰበእገ ዋጅቲት። ");
INSERT INTO alw_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ኤቦሳች ኤተሮን ኦገት ብሬን ኡርሶሰ፤ ሎሩ ቂስቹንኩ ");
INSERT INTO alw_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«ኢስ ሱዕሚን ተማርስቴነንተበእገ ጠረኚንስ አዘንዝበእንዶ? ሁኩዕኑን ዬሩሳሌም ከተመ ጉዕመንከ ትምርቲንከክዕኔ ዊንሽቴንታአ፤ ህትን ከን መንች ቄግ ኒ አሌን ኤቦኖተ ሀሴነንታት» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ጠዉ እኮጎሬ ጴጥሮስለከ ዎሉ አሳበት ፈንቀሽት «መን ትዛዝ ቶጊች መገን ትዛዝ ቶጉ ሀስሰኖኔ። ");
INSERT INTO alw_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","አዕኑ መስቀል አሌን ሰቀልቴን ሽቴንተ ኢሰ አናከኔ መገኑ ሬሆች ኬሾስ። ");
INSERT INTO alw_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","እሱንከ መገኑ እስራኤል መኑ ቶበታን ጩቡሰ አጉረሞተ ቡዕለለከ ጡምሳንቹ መኬስ አዲን ኬዕምኚን አፉዕለኖገ አዕዮስ። ");
INSERT INTO alw_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ነኡ ከን ጠዊሃ ምስክርሃን፤ መገኒሃ አዘዘንታሀኑኡተ ጉዕሚንከ ኣሴሰ ጠሊሉ አያኑ ምስክርሃን» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","እሰን ህካን ሞጮጭቶ ወክት አበ ኡሙዕረንት ሽቶሰተ ሀሶኡ። ");
INSERT INTO alw_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ጠዉ እኮጎሬ መኑ ጉዕሙንኩ ከበጀሞለከ መገን ሕገ ተማርሰኖ «ገማልያሌ» ዬኖ ፈርሳውቹ ኦገት በላን ኡር አሳበተ ቀዎ ወክቲሃ አብል ፉሽታሰገ አዘዦ። ");
INSERT INTO alw_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","እስን «እስራኤል መነ! ከን መን አሌን መ አቴነንተጎሬ ገዉክዕኔ አገዕርዬ። ");
INSERT INTO alw_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","መሰንትስ ከኒች ዎዕናሃ ‹ቴዎዳሴ› ዬኖ መንቹ ‹አን ሎረሃን› የን ኬዕዮ እቅ፤ ሾሌ ጥቤ ጌሱ መኑ እሲን ሜጡ እኮኡ፤ ጠዉ እኮጎሬ እሱሃ ሼመስ፤ ህትን እሱ አዎንቶእሩ ጉዕሙንኩ ብንት ተሰ እክ በኦኡ። ");
INSERT INTO alw_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ህከኒች ኤተሮን መነ ዎለኤመ ዘማን ገሊለ ዬኖ ቤቺች ‹ይሁደ› ዬኖ መንቹ ኬዕዮ፤ ልግብ መነ ሽፍጠ አዕይ አዎንታስገ አዕዮ፤ እሲሁ ሬዮ፤ አዎንታስሩንኩ ብንይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ህካን እኮቤቺሃ ቴሁ አን ያንክዕኔሁ ከ መነ ኡልቶኖቼ፤ ኩ ሰውቱ ህከረንገ ኩ ሆጉት መኒች እኮጎሬ በኣአ። ");
INSERT INTO alw_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ጠዉ እኮጎሬ ኩ ጠዉ መገኒች እኮጎሬ ቤሶኖተ አታልቴነንተበአ፤ ህከኒችን በትሽ ኩ ጠዉ መገኒን ብተሙ እሀኖህዕኔበእገ» ዬሰ፤ ህከን መንች ሸዘነተ ሞጮጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","አሳበንተ እሰበ ገእት ገረፎሳች ኤተሮን ኢስ ሱዕሚን ለንኪሃ ጠወኣበእገ አዘዝ ሂርቶሰ። ");
INSERT INTO alw_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","እሰን እስ ሱዕሚን ህንቀሙ ሀስሰኖሃ እኮቤቺሃ ኦገቲች ሙንደአን ፉልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ህካን እኮቤቺሃ በሬን በሬን መገን ምኔንለከ ምኔንከሰ ኢስ መሲሁ እሁስ ተማርሱለከ ተሽት ላገተ ተማርሱ ሆሮ አጉርቶበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ህከ ወክት አመዕናኖ ዎሊንሹ በተአን መረን ግሪክ አፎሃ ጠወኣ አይሁዱ እሰ አድ ምንሰ አናከት ሬቶ ሜንቲሃ በሬን በሬን ኣሴኖሰ እቸተ ብዝ አኤን ኣሴማሰበአ ይት እብራይስጥ አፎ ጠወኣ አይሁድ አሌን ቁንቁቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ህካን እኮቤቺሃ ቶነ ለሙንኩ አሳበት ጉዕመንከ አመዕናኑተ ጭምአት «እቴኖርቹ ቤንኮተ ይን መገን ላገተ ተማርሱ አጉሩ ሀስሰኖበአ። ");
INSERT INTO alw_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ህካን እኮቤቺሃ አመኤ ኦሶ! መኑ ‹ጡማኖተ› የኖሰ ለመለ መነ ጠሊሉ አያኑ ዊሞሰረ በሊችክዕኔ ሀይቹ መነ መጠሬ፤ ተን ሆጎንተ ሹምነቱ ኣስናንሰ። ");
INSERT INTO alw_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ጠዉ እኮጎሬ ነኡ ዱአ አኦንለከ ላገስ ተማርሶን ጠረኝናም» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ሁኩ ጠዉንኩ ጉዕመንከሰ ሙንዲሲሾ፤ ህከኒች ኤተሮን አመዕነቲንለከ ጠሊለ አያኒን ዊሞ እስጥፋኖሴ መጠርቶኡ፤ ህትን ፍልጶሴ፥ ጵሮኮሮሴ፥ ንቃሮነ፥ ጢሞነ፥ ጰርሜነለከ አይሁድ አመዕነት ቶጎ አንጾክ ባድ መንቹ ኒቆላዎሴ መጠርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","እሰንተ አሳበ ብሬን ኡርሶሰ፤ አሳበንት ዱአ አቶች ኤተሮን አንገሰ አሌሰ ኡጅቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ከን ሃሌን መገን ላገት አልባዕልተን መርቶኡ፤ ህትን ዬሩሳሌማን አመዕናኖ ዎሊንሹ በተአን መሮ፤ አይሁድ ቂሳች መት-መቱሰ ኢሳን አመዕንት ትምርቲንከስ ቶጎኡ። ");
INSERT INTO alw_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","እስጥፋኖስን ኣስቶንለከ ጠሊለ አያንስ ዎልቃን ዊም መን በላን አጀብሲሰኖ ጠወለከ አጅበተ አአኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ህከ ወክት «ሰዎልድማን ፉሎ መን ጭምት ምኒ» ዬኖ አይሁድ ጭምት ምኒ መኑ፥ ቄሬንለከ አለክሰንድር ከተም መኑ፥ ክልቅይለከ እስይ ባድ መኑ እስጥፋኖሴን ኦዳኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ጠዉ እኮጎሬ እስጥፋኖስ ጠወአን ሄዕዮ ሀይመተለከ ጠሊለ አያነ ኦዶተ አታልቶበአ። ");
INSERT INTO alw_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ህከ ወክት «ኩ መንቹ ሙሲንለከ መገን አሌን ቦሮር ላገተ ጠወአን ሞጮጭኖም» ይታ መነ ማጥ ኬሶኡ። ");
INSERT INTO alw_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ከን ሃሊን ኡመት፥ ባልቅለከ ሕግ አስተማረተ ኬሶኡ፤ እስጥፋኖሴቤቹ መርት ኣእት ኦገትቤቹ ሆንጠህሶስ። ");
INSERT INTO alw_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","እስ አሌን ክዝብ መሰከርታ መት-መት መናከተ ኤቦኡ፤ ሁኩ መናከንት «ኩ መንቹ ከን መገኒሃ አደ እኮ ቤቾንለከ መገን ሕግ አሌን ቦሮር ላገተ ጠወኡ ሆሮ አጉሮበአ። ");
INSERT INTO alw_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","‹ኩ ናዝሬት ኢስ ከ ዱእ ምኒ ድጀኖ፤ ሙስን ኣሴኔ ሴረ ዶረኖ› የን ሞጮጭኖም» ይታ ክዝብ ምስክር ኬሶኡ። ");
INSERT INTO alw_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ህከ ወክት ኦገቴን አፉዕልቶእሩ ጉዕሙንኩ እስጥፋኖሴ ቱክ ይት ለአን ሚኔስ አዱ መላይከ ሚንተ አጉጅ ለሌሰ። ");
INSERT INTO alw_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ሎሩ ቂስቹ እስጥፋኖሴ «ኩ የመሞ ጠዉ ሀንቅሃንዶ?» ይ ጠዕሜስ። ");
INSERT INTO alw_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","እስጥፋኖስን «አመኤ ኦሱትለከ አናከኤ! አን ያሚሃ ሞጮጭዬ!፤ አኑኔ እብራሂም ካራን ባዶን ሄኦተ መሩዕነ ብርተ መስጴጦምያን ሄአን ኬዕምኝ መገኑ እሲሃ ለልኬዕይ ");
INSERT INTO alw_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‹ባዲችክለከ እሊችክ አደ እክ ፉልት አን ለሊሳንኬ ባዱ ኦሮእ› ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ህከ ወክት ከላድ ባዲች ፉል ‹ካራነ› ዬኖቤቾን አፉዕሌእ፤ አኑስ ሬዮች ኤተሮን ህከንቤቺች ከበር አዕኑ ሄኤነንተ ከ ባዱ መገኑ ኤቦስ። ");
INSERT INTO alw_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ከን ባዶን መት ብኩታ እሀኖ ጌስ ኡለት ርስተ አዕይ ኣስዮስበአ፤ እብራሂምሃ እለት ሄእበስጎሬ እሲሃለከ እሲች ኤተሮን ዘሬተስ ርስተ አዕይ ኣሶተ ላገተ ኣጎ። ");
INSERT INTO alw_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","መገኑ እብራሂም ዘርት መን ባዶን ቶቸንት ሄአን ሮስ አኤን ሾሌ ጥቤ ዘማኒሃ አብዳዴኖሰገ ኩሎስ። ");
INSERT INTO alw_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ህትን መገኑ ‹ህከ ዘርክ ሮስ አት ጠቅታ ኡመት አሌን አን ፈረዳም፤ ህከኒች ኤተሮን ህከን ባዲች ሰዎልድማን ፉሼሃን ከንቤቾን ኤሳሃ ሰገዳኤ› ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ጡርከም ወኣድ ሴረ መላተ እሆተ ኣሴስ፤ እብራሂም ኢሳቀ እሎ ህዜትቅ በር ጡርከሞስ፤ ህትን ኢሳቅን ጩልስ ያቁበ ጡርከሞ፤ ያቁብን ደቦተ ወዕኔ አናከተ እኮ ቶነ ለሙንከ እለስ ጡርከሞ። ");
INSERT INTO alw_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«ያቁብ ኦሱት አመሰ ቤቱ ዩሱፈ ምቀኝት ግብጽ ባዶን ሮስ እሆተ ህርቶስ፤ ጠዉ እኮጎሬ መገኑ እሲን ሜጡበ ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ህካን እኮቤቺሃ ኦሪሻችስ ጉዕሚችን ፉሽ ግብጽ ባድ ዎም ፍራኦን ብሬን ኬዕምኝለከ ሀይመተ ኣሴስ፤ ዎሙንኩ ግብጽ ባዶንለከ ምኔንከስ ሹምነቱ ኣሴስ። ");
INSERT INTO alw_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ህከ ወክት ግብጻንለከ ከነኣን ባዶን አቡ ጎሩለከ ኦሪሸት እኮኡ፤ ወዕኔ አናከኔን እቸተ ደእቶተ አታልቶበአ። ");
INSERT INTO alw_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ጠዉ እኮጎሬ ያቁብ ግብጽ ባዶን ዉጠት ሄኡስ ሞጮጬ ወክት ወዕኔ ወክት አናከኔ ህከቤቹ ሶኮ። ");
INSERT INTO alw_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ለንኪሃ ፈንቀልት ግብጽ ባዱ መርቶ ወክት ዩሱፍ ገዉስ አመስ ኦሶተ ለልሾ፤ እሉስን ግብጽ ዎምቤቾን ኤንኬዕነንቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ህከኒች ኤተሮን ዩሱፍ አነስ ያቁበለከ እሉስ ጉዕመንከ እስቤቹ ሶክ ኤብሲሾ፤ እሉስ ጉዕሙንኩ ለመላይኔ ኦንቶ መነ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ህካን እኮቤቺሃ ያቁብ ግብጽ ባዱ ኦሮዕዮ፤ እስለከ ወዕኔ አናከኔ ህከን ቤቾን ሬቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ምቀስ ሴኬመ ዬኖቤቹ ፈንቀሽት መስት እብራሂም ሴኬም ከተማን ኤሞሬ ኦሶች ብሪንከስ ህዕሬ ሎዳን ሞጎኡ። ");
INSERT INTO alw_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«ጠዉ እኮጎሬ መገኑ እብራሂሚሃ ኣሴ ተብሳሃ ዊንሸኖ ወክቱ ሆንጠካን ግብጽ ባዶን ኡመትኔ ዎሊንሹ በተአን ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ህካን እኮንኩ ዩሱፈ ደግቡ ዎሉ ዎሙ ግብጽ ባዶን ኬኦተ ኢላት። ");
INSERT INTO alw_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ሃዕሮ ዎሙንኩ ኡመቲኔ አሌን ተንኮን ኬዕይ ወዕኔ አናከኔ አብዳዱ ጀመሮ፤ ሰብያኑተ አብል ፉሼን ቶቼናን ሬታገ ወዕኔ አናከኔ ግዳጅሾሰ። ");
INSERT INTO alw_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ህከ ወክት ሙስ እለሞ፤ እስን መገን ብሬን ምልካሙሃ ጩል እቅ፤ አንስ ምኔን ሰሱ አገነ ነጴእ። ");
INSERT INTO alw_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ምኒች ፉሽት አብሌን ቶችቶስ ወክት ፍራኦኔ ቤቱት ኬስ ቤትሴገ አት ነስቶስ። ");
INSERT INTO alw_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ሙስ ግብጽ ባድ ሀይመተ ጉዕመንከ ተማሮ፤ እስን ጠወአኖ ላጋንለከ ሆጎንተስ ጠረኘ እኮ። ");
INSERT INTO alw_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«ጠዉ እኮጎሬ ሙስ ሸይሉ ዘማን እኮስ ወክት አመስ ኦሱተ እስራኤል መነ ለኦተ ቀልቤንከስ ሰውዬእ። ");
INSERT INTO alw_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","እስ እሊች መቱስ ግብጽ ባድ መንቹ ሚዕረንስ ለዕይ ሀዕሌስ፤ ህከን ሚርተዕዮ መንቺሃ ሀዕል ግብጽ ባድ መንቹ ዎቀር ሽ ገዱተ ፉሎ። ");
INSERT INTO alw_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ሙሲን አመስ ኦሱንት መገኑ እስ አዲን ዎዥ ፉሸኖሰገ አጥራመታኢሃ አጉጆስ እቅ፤ ጠዉ እኮጎሬ እሰ ህካን አጥራመቶበአ። ");
INSERT INTO alw_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ለንክ በር እስራኤል ኦሶች ለሙ ብተንተን ለዕዮ፤ ሀራርሶተ ሄዕላች ‹ኮ መነ! አዕኑ አመተ ኦሱ፤ ሚሃ መት-መቲንከክዕኔ ብተንቴነንታት?› ዬሰ። ");
INSERT INTO alw_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ሁኩ ጃለስ ዎቀረን ሄዕዮ መንቹንኩ ሙሰ ካጳ ሀንበል ‹ኒ አሌን ኬሳሃ ገሻንቹለከ ፈረዳንቹ እኮተ ዳኘ አዕዮሄሁ አዬት? ");
INSERT INTO alw_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ቤሬተ ግብጽ ባድ መንቹ ሽቶንትገን ኤሳሁ ሽቶኤተ ሄዕላቶንትንዶ?› ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ሙስን ህካን ሞጮጬ ወክት ግብጽ ባዲች ሁኝ ሚድያም ባዶን ሄዕዮ፤ ህከኔን ለም ለቤ እለተ እሎ። ");
INSERT INTO alw_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«ህከኔን ሙስ ሸይሉ ዘማን ሄዕዮች ኤተሮን መገን መላይኬቹ ሲና ዬኖ ቆተ ኡድማን ሀቅ ሽፎ በላን ጊረ ለበነ ኣዜን እሲሃ ለሌስ። ");
INSERT INTO alw_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ሙስን ህካን ለዕዮ ወክት ለዕዮርቾን አጀብሲጬእ፤ እስን ለኦተ መድ ሆንጠኮ ወክት ቀርቾሃ መገን ላገት ");
INSERT INTO alw_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹አን ወዕኔ አናከክሃ መገኑ፤ አን እብራሂሚሃ፥ ኢሳቅለከ ያቁብሃ መገኑ› ይተን ሞጮጬእ፤ ሙስን አበ ዋጄእ፤ ለኦንተ መለሎበአ። ");
INSERT INTO alw_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ህትን ‹አት ኡርቶንት ቤቹ ጠሊለ እኮቤቺሃ ሎካችክ ጫዕመተ ፉሽ። ");
INSERT INTO alw_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ሀንቅንከ ግብጽ ባዶን ሄኦ ኡመትኤ ኦርሸተ ለዕይ ያርታኢንከ ሞጮጭ ነጠ ፉሾህዕኔተ አሜቾም፤ ቴሁ አት ከቤቹ አም፤ አን ኬሳሃ ግብጽ ባዱ ሶሃንኬ› ይታ መገን ላገት እስቤቹ አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«እስራኤል ኡመቱ ሙሰ ‹ገሻንቹለከ ፈረዳንቹሃ እኮተ ዳኘ አዕዮሄሁ አዬት?› ይት ለገኦስ ህከ ሙሰ ህከን ሽፎ ኣዜን ለሌስ መላይኬች አዲን መገኑ ገሻንቹለከ ፌሳንቹ አዕይ ሶኮስ። ");
INSERT INTO alw_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ሁኩ ሙስ ግብጽ ባዶንለከ ቢሸ ባራን ሸይሉ ዘማን ኡለ ኡድማን አጅበተለከ አጀብሲሰኖ ጠወ አአን ግብጽ ባዲች አዎንስ ፉሼሰ። ");
INSERT INTO alw_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","‹ቀርቹ መገኑክዕኔ ኤሳሃ ኬሾገን ህትን አመክዕኔ ኦሶ በሊች ነብዬቹ ኬሰኖህዕኔ› ይ እስራኤል ኦሶተ ጠወዕዮሁ ህከን ሙሳንት። ");
INSERT INTO alw_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ኡለ ኡድማን ጭምዬ ኡመቲን ሜጡበ ሲና ቆተ አሌን ጠወዕዮ መላይኬቺንለከ ህትን አናካንተክዕኔ ሜጡበ ሄዕዮሁ እሶት፤ መገን ሄእ ላገንተ ኔሳሃ ኣሴኔሁ ህከን ሙሳት። ");
INSERT INTO alw_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«ወዕኔ አናከኔ ግቦስ ቤሉ ትዛዝስ ቶጎበአ፤ ቀልቤንከሰን ግብጽ ባዱ ፈንቀልቶተ ሰውይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ሀሩነን ‹ኩ ኔሳሃ ግብጽ ባዲች አዎንስ ፉሼኔ ሙሲሃ ም እሌስጎሬ ደንጋምበእቤቺሃ ብሬን ሃንተን አዎንስታኔ ሽርክተ መክስኔ› ይቶስ። ");
INSERT INTO alw_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ህከ ወክት ወዕየ አጉደኖ ሽርክተ መክስ ክትም ሆንጠህሶኡ፤ አንገሰ ሆጎንን ሙንደኦኡ። ");
INSERT INTO alw_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ጠዉ እኮጎሬ መገኑ እሳች አደ እኮ፤ ሰሜ ቤዜተ መገኑ አት ዱአ አታገ ህግሽ ኣሴሰ፤ ሁኩንን ነብያካን « ‹አዕኑ እስረኤል መነ! ሸይሉ ዘማን ኡለ ኡድማን ጎረጤመ ግዘለከ ክትም ሆንጠህሴነንተኤትንዶ? ");
INSERT INTO alw_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ሰገዶኖስተ መክሴንተ ምስልለከ እሰን ሞሎከ ዬኖ መገንክዕኔ ዱካነለከ ሬፋነ ዬኖ ቤዜ ክዝብ ሽርኬ ምስለ እጅቴን ሃንቴንተ፤ አን ባብሎነ ዬኖ ባዲች ካጵ አደ ቄርሳንክዕኔ› የመም ከተበሞቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«ወዕኔ አናከኔ ኡለ ኡድማን መገኑ ገዉስ ለሊሰኖ ዱካኑ ሄዕዮሰ እቅ፤ ሁኩ ዱካኑንኩ መገኑ ሙሲሃ ኩሎስለከ ለሊሾስ ሃሊን መክዮእሃ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","መገኑ ብሬችሰ ሸር ፉሼ አይሁደ እክቡ መን ኡለተ ኦለንት ረገኦ ወክት አናከኔን ተ ቶጎ ዱካንቹተ ኢያሱንን ሜጡበ ህከ ባዱ ኣግሶኡ፤ ደዉዴ ዘማን ኢለ ህከኔ ሄኦኡ። ");
INSERT INTO alw_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ደዉድን መገን ብሬን ኬዕምኝ ደእ ያቁብ ዘሬ በላን መገኑ ገለኖ ምኒ እጃሮተ ዱአ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ጠዉ እኮጎሬ ዱእ ምኒ እጃሮሁ ሱላይማናት። ");
INSERT INTO alw_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«ጠዉ እኮጎሬ ሎሩ መገኑ መን አንገት እጃርቶ ምኔን ሄአኖበአ፤ ሁኩንን ነብዬቹ ጠወአን ");
INSERT INTO alw_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","« ‹ሰሞሁ ዎምነትኤተ ቦርጭመ፤ ኡለት ሎከእ ፎሎሲሳምሃ ቤቹ፤ ኤሳሃ ሀትኔ ምኒ እጃርቴነን? ህከረ አን ፎሎጫም ቤቹ ሀትናሙሃን? የኖ ቀርቹ። ");
INSERT INTO alw_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ህካን ጉዕመንከ አንገእ አቶሃበእንዶ?› የኖ መገኑ። ");
INSERT INTO alw_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","አዕኑ «ጢቃመት ቀልቡክዕኔ ዱጆእሩ! መጨክዕኔ ሞጮጭትቡሩ! አናከክዕኔ ጠሊለ አያነ ቶጉ ግቦገን አዕኑሁ ቶጉ ግቤነንታት። ");
INSERT INTO alw_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ነብያካች ወዕኔ አናከኔ ያይትቡ ነብዬቹ አዬት? እሰን ፈዩ አሜቱስ ሄጭት ኩልቶእረ ሽቶኡ፤ ህትን ህከ ፈየ ኢሰን ህግሴን ኣስቴን ሽቴንታስ። ");
INSERT INTO alw_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ህትን መላይከ አዲን መገን ሕገ ቶጌንታ እቅ፤ እኮጎሬ አገርቴንታበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ኦገት መኑ ህካን ሞጮጭቶ ወክት አበ ኡሙዕርት እስጥፋኖሴ አሌን እንኩተ እጦኡ። ");
INSERT INTO alw_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ጠዉ እኮጎሬ እስጥፋኖስ ጠሊለ አያኒን ዊም ሰማሃ ዋሽ ቱክ ይ ለአን መገን ኬዕምኝለከ መገን መኬ አዲን ኡሬ ኢሰ ለዕዮ፤ ");
INSERT INTO alw_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","«ሁኩዕኑን ሰሞሁ ፈንተዕያን መንች ቤቱ መገን መኬ አንገ አዲን ኡሬኢሃ ለኣሚት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ጠዉ እኮጎሬ እሰ ሎረ ላጋን ያርተን መጨሰ እፍስ ሜጡበ እክ እስቤቹ ደጉዶኡ። ");
INSERT INTO alw_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ከተሚች አብል ፉሽት ክኒን ቀሶስ፤ ምስክር እኮእሩ ኦድኑሰ «ሳኦሌ» ዬኖ መቱ ወደልቹ አገሮተ ሎከስቤቾን አፉሽቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","እሰን ክኒን ቀሰንን እስጥፋኖስ «ቀርቾ ኢሳ! ሩህኤ ቶግ» ይ ላገስ ጎት አዕይ ዱአ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","እስን ጉሉጵ «ቀርቾ! ጩብሰ አጉር» የን ሎረ ላጋን ያሮ፤ ህካን ይ ሬዮ። ");
INSERT INTO alw_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ሳኦል እስጥፋኖሴ ሼመ ወክት አማዕለሞ እቅ፤ ህከ በር ዬሩሳሌማን ሄኦ አመዕናኖ አሌን አቡ ያየሙ እኮ፤ ህከ ወክት አሳበ ቤሉ አመዕናኑት ጉዕሙንኩ ይሁድ ባዱለከ ሰማር ባዱ ብንይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","አመዕነቶን ጠረኝቶ መት-መቱ መኑ እስጥፋኖሴ ሞግ ላገሰ ጎት አት ቡብ ኦኦኡ። ");
INSERT INTO alw_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ጠዉ እኮጎሬ ሳኦል አመዕናኑተ ቤሶተ አጰመኖት እቅ፤ ህትን ምኒች ምኒ ኣገን አመዕንቶ ሜንቱለከ ጎነ ጎሾሽ ፉሸን ኡሱር ምኒ ኣግሰኖሳት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ሁኩ ብንይቶ አመዕናኑት ተሽት ላገተ ዘህተን ተማርስቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ፍልጶስን ሰማር ከተመ ኦሮዕይ መሲህተኔሃ ተማርሰኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","መኑንኩ ፍልጶሴ ላገተ ሞጮጭትለከ አዕዮ አጅበተ ለኦ ወክት መቶ ሰውቲን ሞጮጭታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ዶሮረኖ ዱሩ አበ መኒች ሎረ ላጋን ያረን ፉለኖት እቅ፤ ህትን ልግቡ ናፎሩለከ ድናኑት ፈይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ህካን እኮቤቺሃ ህከን ከተማን አቡ ሙንዲኑት እኮኡ። ");
INSERT INTO alw_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ጠዉ እኮጎሬ ህከን ከተማን ሄአኖ መቱ «ስሞኔ» ዬኖ መንቹ ሄዕዮ እቅ፤ እስን «አን ሎረሃን» የን ሲረ አአን ሰማር ባድ ኡመት አጀብሲሰኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ከተምስ መኑ ሎሪች ቀዉ ኢለ ህከ መንቹ «ኩ መንቹ ሎረ ዬን ገኤኖሲሁ መገንተ ዎልቀ» ይተን ጉዕሙንኩ ሞጮጭታሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ልግቤ ዘማኒች ኬሽ ሲርንከስ አጀብሲሾሰቤቺሃ የኖርቹ ሞጮጭታሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ጠዉ እኮጎሬ ፍልጶስ መገን ዎምነትተኔሃለከ መሲህ ኢስ ሱዕምተኔሃ ዱዱብሴሰ ተሽት ላጋን አመዕንቶሀኒች ኤተሮን ጎኑለከ ሜንቱ ጠመቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ስሞን ገዉንኩስ አመዕን ጠመቀሞ፤ እስን ፍልጶሴን መለዕለሙ ግብ ሜጡበ እኮ፤ ህትን ፍልጶስ አአኖ መላተለከ አጀብሲሰኖ ጠወ ለአን አጀብሲጨኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ህከ ወክት ዬሩሳሌማን ሄኦ ሶቀማኑት ሰማር ባድ መኑ መገን ላገተ ቶጎገ ሞጮጭት ጴጥሮሴለከ ያህይ እሰቤቹ ሶኮኡ። ");
INSERT INTO alw_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ጴጥሮስለከ ያህይ ህከ ቤቹ ኢልቶ ወክት ሁኩ መኑ ጠሊለ አያነ ቶጎተ ዱአ አቶሰ። ");
INSERT INTO alw_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","መሰንትስ ሰማር መኑ ጉዕሙንኩ ቀርቾ ኢስ ሱዕሚን ጠለዕል ጠመቀንቶ ቤሉ እሳች መትሰ አሌኒ ጠሊሉ አያኑ ሜጦረ ሜጥሰ አሌን ድርዮሰበ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ህካን እኮቤቺሃ ጴጥሮስለከ ያህይ እሰ አሌን አንገሰ አቶ ወክት ሁኩ መኑ ጠሊለ አያነ ቶጎኡ። ");
INSERT INTO alw_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","አሳበት አንገሰ መን አሌን አተን ጠሊሉ አያነ ኣሰመኖሰገ ስሞን ለዕዮ ወክት ብረ እሳሃ ኤብ ");
INSERT INTO alw_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«አኒሁ አንገኤ አሌስ አኣሚሁ ጉዕሙንኩ ጠሊለ አያነ ቶጎተ ኤሳሃ ከ ወልቀተ ኣስዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ጠዉ እኮጎሬ ጴጥሮስ «መገን ኣስቱተ ብሪን ደዕቶተ ሰውይቶንትቤቺሃ ብሩክ ኪን ሜጡበ በኡን። ");
INSERT INTO alw_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ቀልቡክ መገን ብሬን ጌጥ ዬእሃ እህበቤቺሃ ከን ጠዋን ኬሳሃ ቤቀንሹ ህከረንገ ወጡ ዮሄበአ። ");
INSERT INTO alw_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ቴሁ ከን ሂለ ሆጎተክ ሻዝ ቶበት፤ አይደጎ ቀልብክ ሂለ ሰዉትክ አጉረኖሄጎሬ ቀርችቤቹ ዱአ አእ። ");
INSERT INTO alw_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","መሰንትስ አት አበ ሂለ ምቀኝማንለከ ጩብ ኡሱሮን ሄኡክ ለለኖኤት» ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ስሞን «ቴሁ ጠወኤንተሀኒች መቱርቹሁ አሌንከኤ ኢለኖበእገ አዕኑ ቀርችቤቹ ዱአ አዕዬ» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ጴጥሮስለከ ያህይ ቀርች ላገተ መሰከርትለከ ጠወኦኢች ኤተሮን ሰማር ባዶን ዮ ልግቤ ኦሎን እንጂለ ተማርስተን ዬሩሳሌመ ፈንቀልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","መገን መላይኬቹ ፊልጶሴ «ኬእ ዬሩሳሌሚች ጋዛ መሰኖ ዎቄን ካአጳ ዋልት ኦሮእ» ዬስ፤ ሁኩ ዎቆንኩ ኡለ ኡድማን ዮእሃ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","እስን ህከንቤቺች ኬዕይ ኦሮዕዮ፤ «ሕንዳኬ» ዬኖ እቶጵየ ባድ ዎማን ዮሴ ዱንየ አሌን ጉዕማንን ሹመለከ ገሸኖሃ እኮ መቱ ቃሬመስ እቶጵያውቹ መንቹ መገኒሃ ሰገዶተ ዬሩሳሌመ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","እስን ፈንቀል ኦሮአን ኬዕምኝ ጋሬን አፉዕል ነብዬቾ እስያሴ መጻፈ አነበበኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ህከ ወክት ጠሊሉ አያኑ ፍልጶሴ «መርት ህከ ኬዕምኝ ጋሬቤቹ ሆንጠክ ደቀም» ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ህካን እኮቤቺሃ ፍልጶስ ህከ ቤቹ ደጉጅ መርክና ኢቶጵያውቹ ነብዬቾ ኢስያሴ መጻፈ አነበበኖሃ ሞጮጭ «አነበባንት ፍሳረስ ኣጋሄትንዶ?» ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ኢትዮጵያውቹንኩ «ሮስሰኖኤ መንቹ ዮበኢሃ ሀት እክ ኣጎኤተ አታለኖ» ይክነ ፍልጶሴ «ኬዕምኝ ጋሬ አል ቆጵ ኢን ሜጡበ አፉዕል» ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","እስን አነበበን ሄዕዮ ጠሊለ መጻፍ ቤቹ «እስን ጎረጢሃ መሴኖ ሆልችገ፤ ኦርዘስ ኣኢሃ ሆንጠኮ መን ብሬን ሰዕም የኖ ቆርባብገ እስ ጠወኦተ አፎስ ፈኞበአ። ");
INSERT INTO alw_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","እስን ገዉስ ሆፍሾ፤ ሀንቅ ፍርዱ ኣሰሞስበአ፤ ሄኡስ ኡለ አሊች ኬዕዮቤቺሃ ደቦስተኔሃ አይ ጠወኦተ አታለኖ?» ");
INSERT INTO alw_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ሁኩ ቃሬመሲንኩ ፊልጶሴ «ነብዬቹ ካን ጠወዕዮሁ አዬተኔሃት? ገይስተኔሃትንዶ ዎሎ መንተኔሃት? ሀዕይ ኩሌኤ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ፊልጶስን ህከን ጠሊለ መጻፊች ኬሽ ኢስተኔሃ ተሽት ላገተ ኩሎስ። ");
INSERT INTO alw_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ሀንተንን ዉሁ ዮ ቤቹ ኢልቶ ወክት ሁኩ ቃሬመሲሁ «ዉሁ ኩዕኑን፤ ኤሳሃ ጠመቀሙ ከመኖኤሁ መርቹሃን?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ፊልጶስ «ዊመ ቀልብንከክ አመዕንቶንትጎር ጠመቀንቶተ አታልታንት» ዬእ፤ ሁኩ ቃሬመሲንኩ «መሲህ ኢስ መገን ቤቱ እሁስ አመዕናም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ሁኩ ቃሬመሲንኩ ኬዕምኝ ጋርተ ኡርሳገ አዘዦ፤ ለሙንኩሰ ዊቤቹ መርታን ፊልጶስ ህከ ቃሬመሲንከ ጠመቆስ። ");
INSERT INTO alw_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ዊ ኣዚች ፉልቶች ኤተሮን ቀርች አያኑ ፊልጶሴ መሴስ፤ ሁኩ ቃሬመሲንኩ ለንኪሃ ፊልጶሴ ለዕዮስበአ፤ እኮጎሬ ሙንደአን ዎቃስ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ጠዉ እኮጎሬ ፊልጶስ «አሽዶደ» ዬኖ ከተማን ደገሞ፤ እስን ቂሳር ከተመ ኢሎተ ኢለ ከተማን ጉዕማንን ሃመን ተሽት ላገተ ዱዱብሰኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ህከ ወክት ሳኦል ቀርቾን አመዕንቶእረ ሾተ ፎከሮ፤ ሎረ ቂስችቤቹ ኦሮዕይ ");
INSERT INTO alw_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ቀርች ዎቃሃ አዎንታ ጎነለከ ሜንቱ ደገኖረ ጉዕመንከ ኡሱረን ዬሩሳሌመ ኤቦተ አታልሲሰኖ ደብዳቤተ ደማስቆን ሄኣ ጭምት ምናተ ከተብ ኣሶተ ጠዕሜእ። ");
INSERT INTO alw_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ኦሮአንን ደማስቆ ኢሎተ ሆንጠኮ ወክቴን ድንገቴን እስ ዮቤቾን ሰሜች ኑሩ በለቆ። ");
INSERT INTO alw_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ህከ ወክት ኡላን ኡቦ፤ «ሳኦሌ! ሳኦሌ! ሚ ሸርታንቴኤት?» ይታ ላገተ ሞጮጬእ። ");
INSERT INTO alw_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ሳኦልን «ቀርቾ! አት አዬት?» ዬ ወክት «አን አት ሸርታንቴኤ ኢሳት፤ ቀሰኖ ብረት ሃንቶንት ጎሬ ሂለኖሄ ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ቴሱ ኬእ ከተመ ኣግ፤ ህከኔ መ አታንት ጎሬ ህከጴ ኩሌኖሄ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","እሲን ሜጡበ ሃንተን ሄኦ መኑ ጠወአኖሲሁ አዬት ጎሬ ለኡዕነ ጠለዕል ላገተ ሞጮጭተን ይታርቹ ሆግ ኡርቶ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ሳኦል ኡቦቤቺች ኬዕይ ለአኖ ወክት እልስ መቱርቹሃ ለኦተ አታልቶበአ፤ እሲን ሜጡበ ሄኦ መኑ አንገስ አፍ መሰገን ደማስቆ ከተመ መስቶስ። ");
INSERT INTO alw_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ህከኔን እልስ ለኡዕነ፥ እቱዕነለከ አጉዕነ ሰሱ በር ዱንኬእ። ");
INSERT INTO alw_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ደማስቆን «ሀናንየ» ዬኖ መቱ ቀርች አሳቤቹ ሄዕዮ እቅ፤ ቀርቹንኩ እሱ መናማን «ሀናንየ» ዬስ፤ እስን «ቀርቾ! አን ከቤቹ ዮም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ቀርቹንኩ እሱ «ኬእ ‹ጌጥዬ› ዬኖ ዎቃሃ ኦሮእ፤ ህከኔን ይሁድ ምኔን ዮ ‹ሳኦሌ› ዬኖ ጠርሴስ ባድ መንቺን ደቀም፤ መሰንትስ ሁኩዕኑን! እስ ህከጴ ዱአ አአኖት። ");
INSERT INTO alw_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","እስን ለኡ አታሎተ ‹ሀናንየ› ዬኖ መንቹ ኣግ አሌስ አንገተ አአን መናማን ለዕዮ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ጠዉ እኮጎሬ ሀናንይ ፈንቀሽ «ቀርቾ! ኩ መንቹ ዬሩሳሌመን ሄኣ አመዕናኖ አሌን ሄንከ ሂለ ሆጉተ አአኖት ጎሬ ልግብያ መኒች ሞጮጭዮም። ");
INSERT INTO alw_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ከንቤቾን ሱዕመክ ገእታእረ ጉዕመንከ ኡሱሮተ ቂስ አዎንሳኖች ዳኞመት ኣሰንቶስ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ጠዉ እኮጎሬ ቀርቹ ሀናንየ «እስ ሱዕመኤ መገኑ አመዕንበ መኒሃ፥ ዎማተለከ እስራኤል ኦሶተ ደግሲሰኖ አን መጠሮንስ ኦዳተ እኮቤቺሃ እስቤቹ ኦሮእ። ");
INSERT INTO alw_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","መሰንትስ ሱዕምኤተኔሃ ሄንከ ኦርሸተ ቶጉ ሀስሰኖስገ አን እሲሃ ለሊሳንስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ህካን እኮቤቺሃ ሀናንየ ኦሮዕይ እስ ሄዕዮ ምኒ ኣጎ፤ አንገስ ሳኦሌ አሌን አዕይ «አመኤ ቤቶ ሳኦሌ! ሁኩ አሜተን ዎቃን ለሌሄ ቀርቹ ኢስ ለንኪሃ ፈንቀሽት ለኡ አታልቶተለከ ጠሊሉ አያኑ ዊሞሄተ ሶኮኤ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ህከ ወክት እሌስ አሊች ኦሞለ አጉደኖርቹ ኡባን ወዕኔገን ለኦተ አታሎ፤ ኬዕይን ጠመቀሞ። ");
INSERT INTO alw_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","እቸተ እች ጠረኜእ፤ ደማስቆን ሄኣ አሳባን ሜጡበ ቀዉ በር ዱንኬእ። ");
INSERT INTO alw_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ወክትንከስ ሳኦል ደማስቆን «ኢስ መገንየ ቤቱ» የን አደደ አይሁድ ጭምት ምናን ተማርሱ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ሞጮጭቶሩ ጉዕሙንኩ «ኩ መንቹ ዬሩሳሌማን ከ ሱዕመ ገእታእረ ጉዕመንከ ቤሰን ሄዕዮሃበዕንዶ? ከ ቤቹንከ አሜቾሁ እሰተ ኡሱረን ቂስ አዎንሳኖቤቹ መሶታበእንዶ?» ይተን አጀብሲጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ጠው እኮጎሬ ሳኦል ወዕኔች በትሽ ጠረኘን ኦሮዕዮ፤ ኢስ መሲሁ እሁስ ደማስቆን ሄኣ አይሁዲሃ መስለ ከመኖሳት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ልግብያ በሬች ኤተሮን አይሁዱ ሳኦሌ ሽቶተ አማዕለንቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ጠዉ እኮጎሬ ሳኦል ተንኮ አማልሰ ደጎ፤ እሰን ሳኦሌ ሽቶተ ከተሚች ሀንከዕርተለከ በራሃ ፉለኖ ኡሩተ ጉዕመንከ አገሩ ጀመርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ጠዉ እኮጎሬ አሳበት እሱ ቀርጫታን ዎርት ሀንከዕሬን መስት ግንብ ኦተ መስኮቲን ኤተሩ ዋሽት ፉሽቶስ። ");
INSERT INTO alw_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ሳኦል ዬሩሳሌመ ኢሌ ወክት ህከኔ ሄኦ አሳባን ሜጡበ ሄኦተ ሀሾ፤ ጠዉ እኮጎሬ እሰ ጉዕሙንኩሰ እስ አሳቤቹ እሁስ አመዕንትበቤቺሃ ዋጅቶስ። ");
INSERT INTO alw_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ጠዉ እኮጎሬ በርናባስ ሳኦሌ አሳበቤቹ ኣእ መር ዎቃን ቀርቹ ሀት እክ ለሌስገለከ ጠወዕዮስገ ህትን ደማስቆን ኢስ ሱዕሚን ሀት መለል ተማርሴገ ኩሎሰ። ");
INSERT INTO alw_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ህካን እኮቤቺሃ ሳኦል እሳን ሜጡበ እክ ዬሩሳሌማን ሃመኖት እቅ፤ ቀርች ሱዕሚን መለል ተማርሰኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ግርክ አፎ ጠወኣ አይሁዲን ጠወአን ኦደኖት እቅ፤ እኮጎሬ እሰ ሽቶስተ ሀሶኡ። ");
INSERT INTO alw_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ህካን አመዕናኑት ደጎ ወክት ቂሳር ከተመ መስቶስ፤ ህከንቤቺች ተርሴስ ከተመ ኦሮአኖገ አቶስ። ");
INSERT INTO alw_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ይሁድ ባዶን፥ ገሊለ ባዶንለከ ሰማር ባዶን ጉዕማንን አመዕናኑት ጠረኝት ወገሬቲን ሄኦኡ፤ ህትን መገኑ ዋጅተን ጠሊሉ አያኑ ጠረኝሰንሰ ዎሊንሺን በተአን መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ጴጥሮስ ቤቺች ቤቹ ፈንቀላመን ልዳን ሄኣ አመዕናኖቤቹ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ህከኔን ህዜቱ ዘመን ዊመ መዕናን ኦሰዕዮ ኤኒያ ዬኖ ናፈ መንቹ ደጎ። ");
INSERT INTO alw_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ጴጥሮስን «ኤኒያ! መሲህ ኢስ ፈይሰኖሄ፤ ኬዕ መዕነክ ዌስ!» ዬስ፤ እስን ወክቲንከስ ኬዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ልዳለከ ሳሮን ከተማን ሄዕዮ መኑ ጉዕሙንኩ እሱ ለእ ቀርች አደ ፈንቀልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","እዮጴ ከተማን «ጠቢተ» ዬኖ መትት ኢሰ አዎንታእት ሄኦ እቅ፤ እሴን ግርክ መን አፎን «ዶርቃ» ዬኖ እቅ፤ ፍሳረስ «ጉሜተ» ዩሃን፤ እሴ ጡመተ ሆጉተ አታኢተለከ ቡጥቻኖተ ደግለልታእተ መንቹ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ህከ ወክት እሴ ጥዝ ሬቶኡ፤ እሰን ጀናዘሴ አንሽት ፉቅ ምኔን አፉሽቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ልዳ ከተሙ እዮጴ ከተሚሃ ግደኑ እኮቤቺሃ እዮጴ ከተማን ዮ ኢስ አሳበት ጴጥሮስ ልድ ከተማን ሄኡስ ሞጮጭት እስቤቹ ለሙ መነ «ኒቤቹ ደዕልት አም» ይት ሶኮኡ። ");
INSERT INTO alw_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ጴጥሮስን ህከን ሶቀንቶሀኑኡንን ሜጡበ አሜቾ፤ እስን ኢሌ ወክት ፉቅ ምኒ ፉሽቶስ፤ ህከኔን ምንሰ አኑ ሬዮ ሜንቱ ጉዕሙንኩ ብሬስ ኡርት ዶርቃ እሳን ሜጡበ ሄኦ ወክት ደዶ ቀምብሰተለከ ኦድኑተ ቶገን ኦኦኡ። ");
INSERT INTO alw_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ጠዉ እኮጎሬ ጴጥሮስ እሰተ ጉዕመንከ አብል ፉሽ ጉሉጵ ዱአ አዕዮ፤ እስን ጀናዘት ዮ አደ ፈንቀል «ጠብተ! ኬእ» ዬእ፤ እሴን እልሴ ፈንት ጴጥሮሴ ለእ ኬእ አፉዕልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","እስን አንገስ ሂር አፍሴ ኬሾ፤ ምንሰ አኑ ሬዮ ሜንቱለከ ዎሉ አመዕናኑተ ገእ ሩሁሴ ፈንቀላን ኣሴሰ። ");
INSERT INTO alw_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ሁኩ ጠዉ እዮጴ ከተማን ጉዕማንን ሞጮጨሞ፤ ልግቡ መኑንኩ ቀርቾን አመዕኔእ። ");
INSERT INTO alw_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ጴጥሮስን እዮጴ ከተማን ጎገ ዙገኖ «ስሞኔ» ዬኖ መንቺን ሜጡበ ልግብ በር አፉዕሌእ። ");
INSERT INTO alw_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ቄሳር ከተማን ሄአኖ «ቆርኔሎሴ» ዬኖ መቱ መንቹ ሄዕዮ እቅ፤ እስን ሮም በገዝ ጎጎት ኣዜን «ጣልያን ብርጌደ» ዬኖሀኒሃ ጥቤ ሀለቀ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","እስን ምንስ አበሮሲን ሜጡበ መገኒሃ ሰገደን መገኑ ዋጀኖ እቅ፤ ህትን ቡጥቻኖተ ሰደቀተ ኣሰኖ እቅ፤ መገን አደንከ ጉዕመ ወክት ዱአ አአኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","መቱ በር ሆንሶ ሰኣት ጌሳን መገን መላይኬቹ «ቆርኔሎሴ» የን እሱ ገአን መናማን ለሌስ። ");
INSERT INTO alw_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","እስን መላይኬቹ ቱክ ይ ለአን ዋጅ «ቀርቾ መርቹሃን?» ዬእ፤ መላይኬቹንኩ «ዱኡክለከ ቡጢቻኖተ ሰደቀ ሀዕልታንቲሁ መገንሀኔን ቃገንታንትገ አዕዮሄ። ");
INSERT INTO alw_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ቴሁ እዮጴ ከተማን ሄዕዮ ጴጥሮሴ ዬኖ ስሞኔቤቹ መነ ሶክ ገእሲስ። ");
INSERT INTO alw_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","እስ ቴሱ ምኑስ ባር መዴን ሄዕዮ ጎገ ዙገኖ ስሞኔ ምኔን ኮህነቱ አፉዕልዮኡ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","እሲን ሜጡበ ጠወአን ሄዕዮ መላይኬቹ እሲች አደ እክ ኦሮዕዮች ኤተሮን ቆርኔሎስ እስ ካዲማች ለሙሰለከ ጉዕመ ወክት እሱ አገርታሀኑኡች መገኑ ዋጀኖ መቱ ወታደርቹ ገእ ");
INSERT INTO alw_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ጉዕመንከ ጠወ ኩሎሳች ኤተሮን እዮጴ ከተመ ሶኮሰ። ");
INSERT INTO alw_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ለንክ በር ገስመ እሰ መርት ከተመስ ሆንጠኮ ወክት ሌሆ ሰኣት ጌሰ ጴጥሮስ ዱአ አኦተ ሀንሸርገ ዮ ቤቹ ፉሎ። ");
INSERT INTO alw_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","እስን ጎሩ አፋንስ እቸተ እቶተ ሀሾ እቅ፤ እቸተ ቅጥ አኤነኒን መናመተ ለዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ህከ ወክት ሰሞሁ ፈንተዕየን ሾሉ ሙረበስ ኡሱረሞ መጋረጀ አጉደኖርቹ ሰሜች ኡለተ ድረን ለዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ህከን ኣዜንን አደዱ ሾል ሎከት ዮሰ ቡሳዉ፥ ወዘንከሰ ሹርይታ ክልቀቱለከ ሰማን ብርይታ ጪኡት ሄኦ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ህከ ወክት «ጴጥሮሴ! ኬእ ካን ጎረጥ እት» ይታ ላገተ ሞጮጬእ። ");
INSERT INTO alw_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ጠዉ እኮጎሬ ጴጥሮስ «ቀርቾ! እሀኖበአ፤ አን ህትኔ ንጃሾ ህከረንገ ነጠ እህባሃ እቾም በሩ ዮበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ህትን ለንኪሃ «መገኑ ሙጩሩ አዕዮሃ አት ንጃስሶት» ይታ ላገት አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ሁኩን ሰሱ ወክት እኮች ኤተሮን ሁኩ መጋረጀ አጉደኖርቹ ሰማ ዋል ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ጴጥሮስ መናመገ ለዕዮ ጠወ «ኩን እኮሁ ሚሃት?» የን ቀልቤንከስ ጨነቀመን ቆርኔሌዎስ ሶኮ መኑ ስሞኔ ምኒ መነ ጠዕምት ደጎኢች ኤተሮን ኡሮን ኡርቶ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","እሰን ላገሰ ጎት አት « ‹ስሞኔ› ዬን ገኤኖ ጴጥሮስ ከበ ዮእንዶ?» ይት ጠዕምቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ጴጥሮስን ህከን መናማን ለዕዮ ጠውተኔሃ ሰውየን ሄዕዮገን ጠሊሉ አያኑ «ሁኩዕን ሰስ መናከት ሀሳሄት። ");
INSERT INTO alw_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","እሰን አን ሶካንሰ አሜቶረ እኮቤቺሃ ኬእ ለሞሱዕናን እሳን ሜጡበ ኦሮእ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ጴጥሮስን ህከን መንቤቹ ድር «አዕኑ ሀሴነንተ መንቹ አኔት፤ አሜቴንታሁ መ መሳኒት?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","እሰን «አይሁድ መኑ ሎርሰኖ መገኑ ዋጀኖ ሀንቅ መንቹ ‹ቆርኔሌዎሴ› ዬኖ ጥቤ ሀለቁ ሶካኔት፤ ኬሳሃ ምንስ ገእሲሽ አት ይታንቲሃ ሞጮጮተ ጠሊሉ መላይኬቹ ኩሎስ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ጴጥሮስን እሰተ ምኒ ኣግሽ ካደሞሰ፤ ለንክ በር ገስመንከ እሳን ሜጡበ ኦሮኦተ ፉሎ፤ እዮጴ ከተማን ዮ አመዕናኖች መት-መቱ እሲን ሜጡበ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ለንክ በር ገስማን ቄሳር ከተመ ኢልታ ወክት ቆርኔሎሴ እሉስለከ ሆንጠካስ ጃለስ ገእ እሳን ሜጡበ አገረኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ጴጥሮስን ህከ ቤቹ ኢል ምኒ ኣጎ ወክት ቆርኔሎስ ጴጥሮሴን ደቀም ሎከስ ኡብ ሰገጆስ። ");
INSERT INTO alw_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","እኮጎሬ ጴጥሮስ «ኬእ! አን ኪገን መንቹሃን» ይ ኬሾስ። ");
INSERT INTO alw_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ጴጥሮስ እሲን ጠወአንን ምኒ አገኖ ወክት ልግቡ መኑ ጭምዬኢሃ ለዕይ ");
INSERT INTO alw_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","«አይሁድ መንቹ አይሁደ እህባ ዎሎ ዘሬን ጭምዩ ህከረንገ ምኒ ኣጉ ሕጋን ፈቀደምባሃ እሁስ አዕኑ ገዉክዕኔን ደጌነንተ፤ እኮጎሬ ኤሳሃ አዬሁ ‹ነጠ እኮበእሃ ህከረንገ ንጃሾእሃ› ዩ ሀስሰኖኤበእገ መገኑ ለሊሾኤ። ");
INSERT INTO alw_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ህካን እኮቤቺሃት እቤቹ ሶኬንተ ወክት ግቡዕነ አሜቾሚሁ፤ ‹ቴሱ ገእቴንተኤሁ ሚሃት?› ይ ጠዕማንክዕኔ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ቆርኔሌዎስ «ሾሎ በሬች ብርተ ህትኔ ወክቴን ሆንሶ ሳቴን ምኔንከኤ ዱአ አአን አበ በለቀ ኦድኑተ ኦደዕዮ መቱ መንቹ ብሬንከእ ኡር ");
INSERT INTO alw_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‹ቆርኔሌዎሴ! ዱአክ መገኑ ሞጮጭዮኡ፤ ህትን ቡጢቻኖተ ኣቶንት ሰደቀተ መገኑ ቃጎኡ። ");
INSERT INTO alw_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","እዮጴ ከተመ መነ ሶክ «ጴጥሮሴ» ዬን ገኤኖ ስሞኔ ገእሲስ፤ እስን ጎገ ዙገኖ ስሞኔ ምኔን ኮህነቱ አፉዕልዮ፤ ስሞኔ ምኑ ባር መዴን ዮእሃን› ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ህካን እኮቤቺሃ ህከ ወክትንከ ኪቤቹ ሶኮም፤ አት አሜቲንከክ ጡመ አቶንት፤ ቴሱ መገኑ አዘዦሄርቹ ጉዕመንከ ሞጮጭኖተ ጉዕሙንኩኔ ከንቤቾን መገን ብሬን ጭምይኖም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ጴጥሮስን «መገኑ መነ መኒች በትሽ ጎልባሃ እሁስ ሀንቅንከ ቴሱ ደጎም ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ጠዉ እኮጎሬ ሀከን ደቦ ዘርተ እሁን መገኑ ከበጀኖ እኮች መገኑ ቶገኖስ። ");
INSERT INTO alw_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","መገኑ እስራኤል ኡመቲሃ ላገስ ሶኮ፤ ጉዕም ቀርቹ መሲህ ኢስ እስ አዲን አሜተኖ ወገሬት አዋጄሰ። ");
INSERT INTO alw_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ያህይ ጥምቀትተኔሃ ተማርሴኢች ኤተሮን ገሊለ ባዲች ጀመር ይሁድ ባዶን ጉዕማንን እኮ ጠወ አዕኑ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","«ህትን መገኑ ናዝሬት ኢሰ ጠሊለ አያኒን ቡር ወልቀተ ኣሴስገ ደጌነንተ፤ መገኑንኩ እሲን ሜጡበ ሄዕዮቤቺሃ እስ ጡመ ጠወ አአንለከ እልቢሱ አፎሃ ጉዕመንከ ፈይሰን ፈንቀላሞ። ");
INSERT INTO alw_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«እስን ይሁድ መን ባዶንለከ ዬሩሳሌም ከተማን አዕዮ ጠዊሃ ነኡ ምስክርሃን፤ እሱ መስቀል አሌን ሰቀልት ሽቶስ። ");
INSERT INTO alw_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ጠዉ እኮጎሬ መገኑ ሰቅ በር ሬሆች ኬሽ ለለኖገ አዕዮስ። ");
INSERT INTO alw_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ሁኩ እሲን ለሌኢሁ ሄጭ መገኑ መጠሮ ምስክር እንኮም ኔሳዪት ቤሉ መኒሃ ጉዕሚሃበአ፤ እስ ሬሆች ኬዕዮች ኤተሮን እስን ሜጡበ እንቶሚሁለከ አንጎሚሁ ነኦት። ");
INSERT INTO alw_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ኢስን ሬቶሀኑኡንለከ ፎሊን ሄኣሀኑኡ አሌን ፈረዶተ መገኑ አዕዮሁ እሱ እሁስ መሰከርኖተለከ መኒሃ ጉዕሚንከ ተማርስኖተ አዘዦኔ። ");
INSERT INTO alw_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","እሲን አመዕነኖሁ ጉዕሙንኩ እስ ሱዕሚን ጩቡስ ፈቁን የመሞተ ነብያከት ጉዕሙንኩ መሰከርቶስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ጴጥሮስ ህከ ጠወ ጠወአንን ላገስ ሞጮጭቶ መን አሌን ጉዕማንን ጠሊሉ አያኑ ድሬእ። ");
INSERT INTO alw_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ጴጥሮሴን ሜጡበ አሜቶ ጡርከመንቶ አይሁድ አመዕናኑት አይሁደ እክበ መን አሌን ጠሊለ አያነ ኣሴሰገ ለኦ ወክት አጀብሲጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","47","አጀብሲጭቶኢሁ እሰ ዎሎ ላጋን ጠወአንለከ መገኑ ሎርስተን ሞጮጭቶቤቺሃት። ጴጥሮስን «ቴ ኒገን ጠሊለ አያነ ቶጎ መኑ ዊን ጠመቀንታበእገ ከመኖሳሁ አዬት?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","እሰን መሲህ ኢስ ሱዕሚን ጠመቀንታገ ጴጥሮስ አዘዦሰ፤ ህከኒች ኤተሮን ቀዉ ጌሰ እሳን ሜጡበ አገሮተ ኡጭቶስ። ");
INSERT INTO alw_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","አሳበትለከ ይሁድ ባዶን ዮ መገኑ አመዕንቶ መኑሁ አይሁደ እህቡ መኑሁ መገን ላገተ ቶጎገ ሞጮጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ህካን እኮቤቺሃ ጴጥሮስ ዬሩሳሌመ ፈንቀል መሮ ወክት ጡርከመንቶ አይሁድ አመዕናኑት ");
INSERT INTO alw_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«ጡርከመንቶበእ መን ምኒ ኣግ እሳን ሜጡበ እቶንቲሁ ሚሃት?» ይት ዎቀሶኡ። ");
INSERT INTO alw_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ጠዉ እኮጎሬ ጴጥሮስ ወዕኔችን ጀመር እኮ ጠወ ጉዕመንከ ሮስሾ። ");
INSERT INTO alw_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","እስን «አን እዮጴ ከተማን ዱአ አአን ገዉእ ዛኛምገ አአኖ ሰዉት ኣዜን ሄዕዮምገ መናማን ለሌኤ፤ ሁኩንን መጋረጀ አጉደኖሁ ሾሉ ሙረበስ ኡሱሬማሁ ሰሜች ኢቤቹ አሜቾ። ");
INSERT INTO alw_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ህካን ሆንጠክ ቱክ ይ ለኣም ወክት መጋረጅ አሌን ሾል ሎከት ዮስ ግዘ፥ ቆጥ ቡሳወ፥ ኡለ አሌን ወዘኒንከሰ ሹርይተን ሃንታ ክልቀቱለከ ሰማን ብርይታ ጪኡት ዮኢሃ ለዕዮም። ");
INSERT INTO alw_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ህትን ‹ጴጥሮሴ! ኬእ ካን ጎረጥ እት› ይታ ላገተ ሞጮጬም። ");
INSERT INTO alw_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ጠዉ እኮጎሬ አን ‹ቀርቾ! እሀኖበአ፤ ነጠሀ እኮበእሃ ህከረንገ ንጃስ እኮሃ ከበሬ ኢሎተ ኢለ አፎንከኤ አፎምበአ› ዬም። ");
INSERT INTO alw_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ለንኪሃ ‹መገኑ ነጠ አዕዮሃ አት ንጃስሶት› ይታ ላገት ሰሜች አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ኩ ጠዉ ሰሱ ወክት ህት እኮች ኤተሮን ሁኩ መጋረጀ አጉደኖርቹ ሰማ ዋል ጣጠሞ። ");
INSERT INTO alw_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ህከ ወክት ቄሳር ከተሚች ኢቤቹ ሶሀንቶ ሰስ መናከት አን ሄዕዮም ምኒ ኢልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ጠሊለ አያነ ሸኩዕናን እሳን ሜጡበ ኦሮኣምገ ኩሎኤ፤ ኩ ሌሁ መኑንኩ ኢን ሄኦኡ እቅ፤ እሳኒን ሜጡበ ቆርኔሌዎሴ ዬኖ መንች ምኒ ኣንጎም። ");
INSERT INTO alw_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ቆርኔሎስን መላይኬቹ ምኔስ ኡር ለዕዮገለከ ‹እዮጴ ከተመ መነ ሶክ ጴጥሮሴ ዬኖ ስሞኔ ገእሲስ፤ ");
INSERT INTO alw_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","አትለከ ምንክ አበሮሱ ጉዕሙንኩ ጡምቴነንተ ጠወ ኩለኖሄ› ዩስ ኩሎኔ። ");
INSERT INTO alw_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ህከኔን አን ጠወኡ ጀመሮም ወክት ጠሊሉ አያኑ ወዕና ኒ አሌን ድሬገን እሰ አሌን ድሬእ። ");
INSERT INTO alw_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ህከ ወክት ‹ያህይ ዊን ጠመቆ፤ እኮጎሬ አዕኑ ጠሊለ አያኒን ጠመቀንቴነንተ› ዬ ቀርች ላገት ቃገንቶኤ። ");
INSERT INTO alw_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ነኡ ቀርቾ መሲህ ኢሳን አመዕንኖም ወክት ኔሳሃ ኣሴ ህከ ኣስቱተ እሳሃ ኣሴሳች መገኒን ሀንበዕለሞተ አን አዬት?» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","እሰን ህካን ሞጮጭቶ ወክት መስለ ሆግ ጨለ ይቶኡ፤ ህትን «መገኑ አይሁደ እህበ መኒሀ ነብሴሀሰ ቶበት ፈንቀልታገ አዕዮሰ» ይተን መገኑ ገለትጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","እስጥፋኖሴ ሼመች ኤተሮን ኬዕዮ ያህይ መሳን ብንይቶ አመዕናኑት ዎሎ መኒሃ እሁዕነ ጠለዕል አይሁድ መኒሃ መገን ላገተ ኩልተን ፍንቄ ባዱ፥ ዊን ረበንቶ «ቆጵሮሰ» ዬኖ ባዱለከ አንጾክ ከተመ ኢለ ዘህተን ኩልታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ጠዉ እኮጎሬ እሳች መት-መቱ ዊን ረበንቶ «ቆጵሮሰ» ዬኖ ባዱለከ ቀሬን ከተም መኑ አንጾከ መርቶ ወክት ቀርቾ ኢስ ተሽት ላገተ ግርክ ባድ መኒሃ በርግት ኩልተን ተማርስታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ቀርቹንኩ እሳንከ ደግለለን ሄዕዮቤቺሃ ልግቡ መኑ አመዕንት ቀርች አደ ፈንቀልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ህከን ጠው ዱዱቡንኩ ዬሩሳሌማን ሄኦ አመዕናኖተ ሞጮጨሞ፤ እሰን በርናባሴ አንጾክ ከተመ ሶኮኡ። ");
INSERT INTO alw_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","እስን መር መገን ኣስቱተ ለዕዮ ወክት አበ ሙንደዕዮ፤ ዊመ ቀልብንከሰ ቀርቾን ጠረኝት አመዕነንቶረ እክ ሄኣገ ሰዦሰ። ");
INSERT INTO alw_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","መሰንትስ እስ ጠሊሉ አያኑለከ አመዕነቱሁ ዊሞስቤቺሃ ጡመ መንቹ እቅ፤ ልግቡ መኑንኩ አመዕንት ቀርች አደ ፈንቀልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ህከኒች ኤተሮን በርናባስ ሳኦሌ ሀሶተ ተርሴስ ከተመ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","እስን ደጎስ ወክት አንጾክ ከተመ ኣእ ኦሮዕዮ፤ ለሙንኩ ዊመ ዘማን ህከኔ ሄኦ አመዕናኖን ሜጡበ ልግብ መነ ተማርስቶኡ፤ አሳበንት ዎኔሳንከ አንጾካን «ክርስታነ» ዬን ገኤመሰ። ");
INSERT INTO alw_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ህከ ወክት መት-መቱ ነብያኑት ዬሩሳሌሚች አንጾክ ከተመ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","እሳችን መቱ «አጋቦሴ» ዬኖ መንቹ ኬዕይ ኡር ዱንየ አሌን ጉዕማንን ጎሩ እሀኖገ ጠሊሉ አያኑ ለሊሻንስ ኩሎ፤ ሁኩ ጎሩንኩ ሮም ባድ ዎም ዎማ ቀላዉዶሴ ዘማኔን እኮእሃ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ህካን እኮቤቺሃ አንጾካን ሄኣ አመዕናኑት ገገዉንኩሰ ወልቀሰ ጌሰ ፉሽት ይሁድ ባዶን ዮ አመዕናኖተ ሶኮተ ሙርስጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","እሰን ብረ ጭምአት በርናባሴለከ ሳኦሌ አንጋን ዱእ ምነ ባልቀቤቹ ሶኮኡ። ");
INSERT INTO alw_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ህከ ዘማን ዎሙ ሄሮድስ መት-መቱ አመዕናኑተ ያዩ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","እስን ያህይ አመቤቱ ያቁበ ሲፊን ሽሲሾስ። ");
INSERT INTO alw_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ሁኩ ጠዉ አይሁደ ሙንደእሲሾገ ለዕዮ ወክት ጴጥሮሴ በርግ ኡሱርሲሾ፤ ሁኩን እኮሁ ጦሮሹ እቴነን ከበጄኖ ከበጃን ዊመ ሳምንት ኣዜን ዮ በሬኒት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ሄሮድስ ጴጥሮሴ አፍ ኡሱር ምኒ ኣግሾስ፤ እስን ሻሽግ ከበጃቲች ኤተሮን መን ብርተ ፉሾተ ሰውይ ሾሉ-ሾሉ እክ ተሪን-ተሪን አገርታገ ቶነ ሌሆ ወታደሪሃ ህግስ ኣቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ህካን እኮቤቺሃ ጴጥሮሴ ኡሱር ምኔን ጠረኜን አገሬኖት እቅ፤ ጠዉ እኮጎሬ አመዕናኑት ሜጡበ እክ እስተኔሃ ጠረኝት ዱአ አታኢት። ");
INSERT INTO alw_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ሄሮድስ ጴጥሮሴ ኡመት ብርተ ገስመ ሆንጠህሶተ ሰውዬ በሬን ሀንከዕርተ ጴጥሮሴ ለሞ ሰንሰለቲን ኡሱሬናን ለሞ ዎታደር በላን ኦሰዕዮ እቅ፤ ዎሉ ዎታደሩ ኡሱር ምኒ ኡሮን ኡርት አገርታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ድንገቴን ቀርች መላይኬቹ ለሌእ፤ ምንስ ኣዙ አበ ዋቅ ዬእ፤ ጴጥሮሴ ምዛሹስ ኡል ኬሽ «ደዕልት ኬእ» ዬስ፤ ጴጥሮሴ አንገተ ኡሱሬመ ሰንሰለቱ አንጋችስ ኡቦ። ");
INSERT INTO alw_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","መላይኬቹንኩ «ቀበቱክ ቆዕር! ጫዕመክ ዎዕር!» ዬስ፤ እስን መላይኬቹ ዬስገ አዕዮ፤ መላይኬቹንኩ ቴሁ «ጋብክ ኦደእ አዎኔኤ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ጴጥሮስን አብል ፉል አዎኞስ፤ ጠዉ እኮጎሬ ጴጥሮስ መናመተ ለአኖ አጉደኖሲት ቤሉ መላይኬቹ አአኖ ጠዉ ሀንቅ አጉጆስበአ። ");
INSERT INTO alw_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ዎኔ አገሬኖቤቹለከ ለንክ አገሬኖቤቹ ህግ ከተመ ፉሸኖ ብረት ሳንቁ ዮ ቤቹ ኢልቶኡ፤ ሁኩ ብረት ሳንቁ ገዉንኩስ ፈንተዕዮ፤ እሰን ፉልት መቶ ሩካሸ ዎቄን ህጎኡ፤ ወክትንከስ መላይኬቹ እሲች አደ እክ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ጴጥሮስን ቀልቡስ ፈንቀላን «ቀርቹ መላይኬቹስ ሶክ ሄሮድሴ አንጋችለከ አይሁድ ኡመቱ አገርታ ጠዊች ጉዕሚችን ፌሾኤሃ እሁስ ቴ ደጎም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","እስን ህከ ጠወ አጥራመቾች ኤተሮን ልግቡ መኑ ሜጡበ ጭምይ ዱአ አአኖ መርየማ ምን ኦሮዕዮ፤ እሴን «ማርቆሴ» ዬኖ ያህዪሃ አመተ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ጴጥሮስ አብል ሳንቀ ቆጬ ወክት «ሮደ» ዬኖ ህከን ምን ገረዴቹት ለኦተ ብትም ኡሩተ አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","እሴን ጴጥሮሴ ላገተ እሁስ ደጎ ወክት አበ ሙንደኦቤቺሃ ሳንቀ ፈንቱዕናን ምን ደጉደን ኣግ ጴጥሮስ አብሌ ኡሩስ ኩልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","እሰን እሴተ «በርገጎንት» ይቶሴ፤ ጠዉ እኮጎሬ እሴ «ሀንቅንከ እሶት» ይተን ጠረኝስ ኩልቶሰ፤ እሰን «ጴጥሮሴ አገረኖሃ መላይኬቹ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ጠዉ እኮጎሮ ጴጥሮስ ሳንቀ ሰዕምይ ቆጬእ፤ እሰን ፈንት ለኦስ ወክት አበ ገረምሲጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ጴጥሮስ እሰንተ አንጋን ቀቀሽ ጨለ ይታገ አዕይ መገኑ ኡሱር ምኒች ሀት አይ ፉሼስ ጎር ኩሎሰ፤ እስን «ከ ጠወ ያቁብለከ ፈቆ አመዕናኖተ ኩሌ» ይኬዕይ እሳች አደ እክ ዎሉቤቹ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ኡለት ሶዞ ወክት ዎታደሩ «ጴጥሮስ መ እኮ?» ይተን አበ ጨነቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ሄሮድስን ጴጥሮሴ ሀሴኖገ አዕይ ሆጎች ኤተሮን ህከ ወክት አገርታ ዎታደረ መረመር ሹል ሾኖተ አዘዦ፤ ህከኒች ኤተሮን ሄሮድስ ይሁድ ባዲች ቄሳር ከተመ ኦሮዕይ ህከኔ አፉዕሌእ። ");
INSERT INTO alw_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ሄሮድስ ጢሮስለከ ሲዶን ባድ መኒን ኡሙዕርዮ እቅ፤ ሁኩ መኑንኩ ሜጡበ አሜት ዎም ምን ሀላፌቹ ብላስጦሴ ዎሚን እተቀንሶተ ኡጭቶኡ፤ መሰንትስ ባዱሰ እቸተ ደአኖ ህከን ዎም ባዲች እኮቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ዝኜ በር ሄሮድስ ዎም ኦድኑተ ኦደዕይ ኬዕምኝ ቦርጭማን አፉዕል ኡመቲሃስ ጠወአኖሳት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ኡመቱንኩ «ቲን መገንተ ላገ ቤሉ መንተ ላገበአ!» ይተን ጨንጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ሄሮድስ መገኒሃ ኬዕምኝ ኣሱ ሆጎቤቺሃ ወክትንከስ ቀርች መላይኬቹ ዳፋን አሉስ ዘቡዕለዕይ ሬዮ። ");
INSERT INTO alw_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ጠዉ እኮጎሬ መገን ላገት ጉዕመ ወክት ነጵተንለከ አልባዕልተን መርታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ህከ ወክት በርናባስለከ ሳኦሊ ሆጉሰ ሹልት ዬሩሳሌሚች አንጾከ ዬኖቤቹ ፈንቀልቶኡ፤ እሰ ፈንቀልት አሜተን «ማርቆሴ» ዬኖ ያህዪ እሳንን ሜጡበ ኣእት አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","«አንጾከ» ዬኖ ከተማን አመዕናኖ ኦገት በላን ነብያኑትለከ አስተማረት ሄኦ እቅ፤ እሰን በርናባስ፥ «ገንበለ» ዬኖ ስሞን፥ ቀሬን ባድ ሉክዮስ፥ ባድስ ሾልቅ አፎ ገሸኖ ሄሮድሴን ሜጡበ ነጴ ምናሔትለከ ሳኦሌት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","እሰን ቀርቹ ካደንተንለከ ሶመንተን ዮሀኔን ጠሊሉ አያኑ «በርናባሴለከ ሳኦሌ አን መጠሮም ሆጎተ አደ አዕዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ህከኒች ኤተሮን ሶመንትለከ ዱአ አት አንገሰ አሌሰ አቶች ኤተሮን ሶኮሰ። ");
INSERT INTO alw_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","በርናባስለከ ሳኦል ጠሊለ አያኒን ሶሀንት «ሴሌውቅያ» ዬኖ ከተመ ኢልቶኡ፤ ህከንቤቺች መርከባን ኣግ «ቆጵሮሰ» ዬኖ ባዱ ኢልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","እሰን «ሰላሚሰ» ዬኖ ከተመ ኢልቶ ወክት አይሁድ ጭምት ምናን መገን ላገተ ተማርስታኢት እቅ፤ ያህይን እሳን ሜጡበ እክ ሀዕለኖሳት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ህከ ዊን ረበንቶ ኡለተ ጉዕመንከስ ዘህተን «ጳፉ» ዬኖ ከተመ ኢልቶ ወክት «ባርየሱስ» ዬኖ መቱ አይሁድቹ ኪላንቹ ደጎኡ፤ ሁኩ መንቹንኩ ክዝብየ ነብዬቹ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","እስን «ሰርግዮስ ጰዉሎሴ» ዬኖ ገሻንቺን ሜጡበ ሄኣ እቅ፤ ሁኩ ገሻንቹንኩ መገን ላገተ ሞጮጮተ ሀሽ በርናባሴለከ ሳኦሌ እስቤቹ ገእሲሾ። ");
INSERT INTO alw_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ጠዉ እኮጎሬ ግሪክ መን አፎን «ኤሊማሴ» ዬን ገኤኖ ኪላንቹ ባርየሱስ ሁኩ ገሻንቹ አመዕንበገ ሀሽ በርናበሴንለከ ሰኦሌን ሀንበዕለሙ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","እኮጎሬ «ጰዉሎሴ» የመሞ ሳኦል ጠሊለ አያኒን ዊም ህከ መንቹ ቱክ ይ ለአን ");
INSERT INTO alw_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","«አት ተንኩትለከ ሂሉ ጠዉ ጉዕሙንኩ ዊሞሄ እልቢስ ቤቱ፤ ጡመርቺሃ ጉዕሚንከ ዲኑ፤ ቀርችኔ ጌጥዬ ዎቀሃ ሾክሱ አጉርታንትበእንዶ? ");
INSERT INTO alw_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ቴሱ ሁኩዕኑን ቀርች አንገት ዎቀርታሄ፤ ህካን እኮቤቺሃ ቆቀ እክ ቀዎ ወክቲሃ አር ኑር ለኣንትበአ» ዬስ። ወክትንከስ ጉንጄገለከ ቱንስችገ ዮርቹ እልስ እፍሾ፤ እስን አንገስ አፍ መሰገኖስ መነ መዲስ ሀሱ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ሁኩ ገሻንቹንኩ ቀርችተኔሃ ተማርስቶ ትምርቲን አጀብሲጬቤቺሃ ህከ ጠወ ለዕዮ ወክት መገኖን አመዕኔእ። ");
INSERT INTO alw_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ህከኒች ኤተሮን ጰዉሎስለከ ጃለስ መርከባን ኣግ «ጳፎሰ» ዬኖ ከተሚች «ጵንፍልየ» ዬኖ ባዶን ሄኣ «ጴርጌ» ከተመ መርቶኡ፤ ያህይ እሳች አደ እክ ዬሩሳሌመ ፈንቀል ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","እኮጎሬ እሰ ህከን ጴርጌ ከተሚች «ጵስድያ» ዬኖ ባዶን ሄዕዮ ዎሉ «አንጾከ» ዬኖ ከተመ ኢልቶኡ፤ ሰምበት በሬን መቶ አይሁድ ጭምት ምኒ ኣግ አፉዕልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ሕግለከ ነብያኖ መጻፈ አነበቦች ኤተሮን ጭምት ምኒ ገሽታእሩ «አመኤ ኦሶ! መነ ሸዜነንተ ጠዉ ዮህዕኔ ጎር ኩሌ» ይት እሰቤቹ ሶኮኡ። ");
INSERT INTO alw_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ህካን እኮቤቺሃ ጳዉሎስ ኬዕይ ኡር ኡመት አንጋንተስ ቀቀሽ ጨለየኖገ አዕይ «አዕኑ እስራኤል መኑለከ መገኑ ዋጅቴነንተ ኡመቱ! ከበ ሞጮጭዬ! ");
INSERT INTO alw_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ከን እስራኤል ኡመት መገኑ ዎኔ አናኑኔ መጠር ግብጽ ባዶን ኮሀ እክ አፉዕልቶ ወክት ልግብ ኡመት አዕይ ሎረ ዎልቃንከስ ህከንቤቺች ፉሼእ። ");
INSERT INTO alw_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ሸይሉ ዘማን ኢለ ኡለ ኡድማን አታዕሌሰ። ");
INSERT INTO alw_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ህከኒች ኤተሮን ከነአን ባዶን ለመለ ደቦ ኡመት ቤሽ ኡለሰ እሳሃ ረገእሲሾ። ");
INSERT INTO alw_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ህከኒች ኤተሮን ሾል ጥብተ ኦንታዮ ዘማን ጌሰ ነብዬቾ ሳሙኤሌ ወክቱ ኢሎተ ኢለ ዳኛኑት ገሽታገ አዕዮሰ። ");
INSERT INTO alw_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","«እሰን ህከኒች ኤተሮን ዎመ ኣሶሰተ ጠዕምቶኡ፤ መገኑ ቢንያሜ ደቦች ቂስ ቤቱ ሳኦሌ ሸይሉ ዘመን ዎመ አዕዮሰ። ");
INSERT INTO alw_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ሳኦሌ ዎምነቲች ድሪሾች ኤተሮን ዳዉዴ ዎመ አዕዮሰ፤ መገኑ ዳዉዴተኔሃ ‹ገይኤ ቀልብገ ዮኢሃ አን ዬም ጠወ ጉዕመንከ አአኖ እሴዬ ቤቱ ደዉዴ ደኤም› ይ መሰከሮስ። ");
INSERT INTO alw_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ህከን መንች ዘሬች መገኑ ተብሴስ ላገ ሃሊን እስራኤል መኒሃ ጡምሳንቹ ኢሰ ኤቦሰ። ");
INSERT INTO alw_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ኢስ አሜቱዕነ ብርተ ጠመቃንቹ ያህይ እስራኤል መኒሃ ጉዕሚንከ ጩብ ቶበት ፈንቀልት ጠመቀንታገ ተማርስዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ያህይ ሆጉስ ሹሎች ኤተሮን ‹ኤሳሃ አዬት ይቴን ሰውይቴነንታት? አን አሜተኖ ይቴን አገርቴነንታሃበአ፤ ጠዉ እኮጎሬ አን ጫመስ ወደሩ ሂሮተ በቀእባሃ ኢች ኤተሮን አሜተኖ› ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«አዕኑ እብረሂም ዘሬች ከለቀንቴንታ አመኔ ኦሱትለከ መገኑ ዋጅቴነንተ ኡመቱ! ጡም ሶህኑት ሶሃንቶኢሁ ኔሳህት። ");
INSERT INTO alw_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ጠዉ እኮጎሬ ዬሩሳሌማን ሄኣእሩለከ ሀለቃሰ ኢስ ጡምሳንቹ እሁስ ደጎበአ፤ ሰምበት በሬን አነበቤኖ ነብያከ መጻፈተ አጥራመቱዕናን እስ አሌን ፈረዶ ወክት ራጉስ ዊመኖገ አቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ኢሰ ሬሆተ ኢልሰኖስ መሰተ ደግባጎሬሁ ገሻንቹ ጵላጦስ ሾስተ ኡጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","እስተኔሃ ከተበሞሃ ጉዕመንከ አት ሹልቶች ኤተሮን ሰቀለሞ መስቀሊች ድሪስ ሞጎኡ፤ ");
INSERT INTO alw_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ጠዉ እኮጎሬ መገኑ እሱ ሬሆች ኬሾስ። ");
INSERT INTO alw_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ኢስ እሲን ሜጡበ ገሊላች ዬሩሳሌመ አሜቶሀኑኡተ ልግብ በር ለሌሰ፤ እሰን ቴሱ ኡመት ብሬን እስተ ምስክረ። ");
INSERT INTO alw_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ኣእን አሜንቶም ሃዕሮ ተሽት ላገት መገኑ አናካተኔ ኣጎ ተብሴ ላገት ");
INSERT INTO alw_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ኢሰ ሬሆች ኬሲንከስ ህከ ተብሳሃ ኒን ኦሶንተሰ ዊንሽዮኡ፤ ሁኩንን ደውድ መጻፋን ለንክ መዝሙራን ‹አት ቤቱሃኤ፤ አን ከበር እሎንኬ!› የመም ከተበሞጋት። ");
INSERT INTO alw_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ህትን ሸሙዕነ መገኑ ሬሆች ኬሽ ለልሶተ ‹ጠሊለ አመዕነንቶ በረከተ ደዉዴ ኣሴሚሃ ኣሳንክዕኔ› ይ ጠወዕዮኡ። ");
INSERT INTO alw_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ህትን ደውድ መጻፋን ዎሎ ቤቾን ‹ኪ ጠሊሉ ካዲንቹክ ሎድ ኣዜን ሸሞተ ሰዕም ይታንትበአ› የኖ። ");
INSERT INTO alw_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ጠዉ እኮጎሬ ደዉድ ሄዕዮ ዘማኔን መገኑ ኢተኖገ ሆጉስ ሹሎች ኤተሮን ሬይ አናካንተስን ሞገም ሸሞኡ። ");
INSERT INTO alw_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","እኮጎሬ መገኑ ሬሆች ኬሾሲሁ ሸሞበአ። ");
INSERT INTO alw_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ህካን እኮቤቺሃ አመኤ ኦሶ! ጩብ አጉረሙ ደገሞሁ ህከን ኢሲን እሁስ ተማርሴማህዕኔገ ደጌ። ");
INSERT INTO alw_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ህትን እሲን አመዕነኖሁ ጉዕሙንኩ ሙሲን ኣሰሞ ሕጊን ነጠ ፉሎተ አታልበ ጩቢች ጉዕሚችን ነጠ ፉለኖ። ");
INSERT INTO alw_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ህካን እኮቤቺሃ ነብያኖን ህት የመም ጠወአሞሁ ኢለኖህዕኔበእገ አገዕርዬ፤ ");
INSERT INTO alw_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","እስን ‹አዕኑ ቀለዴነንተሩ! ለዕዬ! ገረምሲጭዬ! በዕዬሁ! መሰንትስ አይ ኩሎህዕኔጎሬ አመዕንቴንበ ሆጉተ ዘማኔንከክዕኔ አኣም›» የኖ ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ጳዉሎስለከ በርናባስ ጭምት ምኒች ፉልተን ከ ጠወ አሜተኖ ሰምበት በሬተ ፈንቀሽት ኩልታገ መኑ ኡጭቶሰ። ");
INSERT INTO alw_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ጭምት ምኒ መኑ ፉሎ ወክት ልግቡ አይሁዱሁ አይሁድ እምነቴን ፈንቀልቶእሩ ጳዉሎሴለከ በርናባሴ አዎንቶኡ፤ ጳዉሎስለከ በርናባስ ህከ መነ መገን ኣስቶን ጠረኝት ሄኣገ ሸዞሰ። ");
INSERT INTO alw_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ሳምንትስ ሰንበት በር ከተማንከስ ሄአኖ መኒች ልግቡሰ ቀርች ላገተ ሞጮጮተ ጭምዬእ። ");
INSERT INTO alw_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ጠዉ እኮጎሬ አይሁዱ ኡመትስ በትኝ ለኦ ወክት ጢቅስ ጳዉሎስ ጠወአኖ ጠወ ግብ ጳዉሎሴ ቦሮርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","እኮጎሬ ጳዉሎስለከ በርናባስ መለልት «መገን ላገተ ሄጬን ክዕኔሃ ጠወኡ ሀስሰኖ፤ ጠዉ እኮጎሬ አዕኑ ‹ቶንጋምበአ› ይቴን ዘላለሚሃ ጉዕሚንከ ሄኤኖ ሄኡ ገበእባሃ አቴን ገጎንከክዕኔ ፈረዴንተቤቺሃ ነኡ ጌኝአዕን አይሁደ እህበ መንቤቹ መርናም። ");
INSERT INTO alw_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","መሰንትስ ቀርቹ ‹ኡለ ዳንገ ኢሎተ ኢለ ጡሙ ኤቦኖተ አይሁደ እህበ መኒሃ ኑሪ አዕዮንኬ›» ይ አዘዦኔ ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","አይሁደ እህበ መኑ ህካን ሞጮጭቶ ወክት ሙንደኦኡ፤ ቀርች ላገንተ ሎርስቶኡ፤ ዘላለሚም ሄኢሃ መጠረንቶእሩ ጉዕሙንኩ አመዕንቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ቀርች ላገት ህከን ባዶን ጉዕማንን አልባዕልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","አይሁድ አዎንሳኑት አይሁድ አመዕነቱ ቶጎ መገኑ ዋጅታ ቀባጣሙ ሜንቱለከ ሎርሎሩ መኑ አደሜኖገ አት ጳዉሎሴሃለከ በርናባሴሃ ኦርሸት ኢልታገ አት ህከን ባዲች ሸርት ፉሽቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ጳዉሎስለከ በርናባስ ህከን መኒሃ ጡር እሆተ ሎከሰ ትበ ግግሽት እቆንዮም ከተመ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","አመዕናኑት ሙንዲኖንለከ ጠሊለ አያኒን ዊንቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ህከኒች ኤተሮን ወዕና ሮሶገን ጳዉሎስለከ በርናባስ እቆንዮናን ዮ አይሁድ ጭምት ምኒ ኣጎኡ፤ ህከን ቤቾን ልግቡ አይሁዱለከ ግሪክ መኑ አመዕንቶተ ኢለ ተማርስቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ጠዉ እኮጎሬ አመዕንትበ አይሁዱ አይሁደ እህበ መነ ኬስ አመዕናኖ አሌን ብተተ ኬሶኡ። ");
INSERT INTO alw_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ህካን እኮቤቺሃ ጳዉሎስለከ በርናባስ ቀርች ላገተ መለልት ጠወአን ልግብ ወክት ህከኔ አገርቶኡ፤ ቀርቹ አጅበተለከ አጀብሲሰኖ ጠወ አንጋንከሰ አታገ ወልቀተ ኣስ እስ አስቶ ላገት ሀንቅ እሁስ ለሊሰኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ጠዉ እኮጎሬ ከተማንከስ ሄዕዮ መኑ ለሙ አደ እክ መቱስ አዱ አይሁድ አደለከ ደሩስ አዱ አሳበ አደ እኮኡ። ");
INSERT INTO alw_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ጠዉ እኮጎሬ አይሁዱለከ አይሁደ እህቡ ዎሉ መኑ ሀለቃንከሰ ሜጡበ እክ ጳዉሎሴለከ በርናባሴ አበ ኦሪሶተለከ ክኒን ቀሶተ ሀሶኡ። ");
INSERT INTO alw_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ጳዉሎስለከ በርናባስ ህከ ጠወ ሞጮጭቶ ወክት «ልስጥረለከ ደርቤታ» ዬኖ ልቃኦን ባድ ከተመተለከ አዝጋጌንከስ ዮ ባዱ ሁንት መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ህከን ቤቾን ተሽት ላገተ ዱዱብስቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ልስጥራን ሎከስ ናፎ መቱ መንቹ ሄዕዮ እቅ፤ ኩ መንቹ እለሞች ኬሽ ናፈ እኮቤቺሃ ሎካንከስ ሃም ደገኖበአ። ");
INSERT INTO alw_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ኩ መንቹ ጳዉሎስ ጠወአኖሃ አፉዕል ሞጮጨኖት እቅ፤ ጳዉሎስ ህከ መንቹ ቱክ ይ ለዕይ ጡሞተ አታልሲሰኖ አመዕነቱ ዮስገ ለዕዮ ወክት ");
INSERT INTO alw_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ሎረ ላጋን «ጌጥ ይት ሎካንከክ ኡር!» ዬ ወክት መንቹንኩ ኬዕይ ሃሙ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","መኑ ጳዉሎስ አዕዮ ጠወ ለዕዮ ወክት ልቃኦን አፎን «ሽርኬ መገናከት መነ አጉድ ኒቤቹ ድርቶኡ» ይት ሎረ ላጋን ጠወኦኡ። ");
INSERT INTO alw_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","እሰን በርናባሴ «ድያ» ይቶኡ፤ ህትን ልግብ ወክት ጠወአኖሃ እኮቤቺሃ ጳዉሎሴ «ሄርሜነ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ከተሚች አብሌን ሄዕዮ ድያ ሰገዴኖስ ምኒ ቂስቹ ዎርጃመተለከ ሸፎገ መክሴመ ቦብሉተ ከተመ ኣጌኖ ኡሮቤቹ ኤብ ኡመቲን ሜጡበ ጳዉሎሴሃለከ በርናባሴሃ ክትም ሆንጠህሶተ ሀሾ። ");
INSERT INTO alw_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ጠዉ እኮጎሬ ጳዉሎስለከ በርናባስ ህከ ጠወ ሞጮጭቶ ወክት ህልቅ ኦድኑሰ ፊልት ያርተን መንቤቹ ደጉደን መርት ");
INSERT INTO alw_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«ኮ መነ! ከ ጠወ ሚሃ አቴነንታት? ነኡ ክዕኔገን ዮምሃ መነ፤ ነኡ ከቤቹ አሜንቶሚሁ አዕኑ ከን ተሰ ጠዊች ገበላ ዋልቴን ሰማ፥ ኡለተ፥ ባረለከ ኣዜንከስ ዮርቹ ጉዕመንከ ከለቆለከ ሄአኖ ካሊቅ አደ ፈንቀልቴነንተገ ተሽት ላገተ ኩልኖህዕኔታት። ");
INSERT INTO alw_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ህጎ ዘማኔን ኡመቱ ጉዕሙንኩ ገይሰ ሃሽኣቶገ ሄኦተ መገኑ ጌኝ አዕይ አጉሮሰ። ");
INSERT INTO alw_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","እሁን ቤሉ እስ ጎደበ ላፈ መገኑ እሁስ መሰከረኖ ጡመ ሆጉተ አኡ አጉሮበአ፤ መሰንትስ ሰሜች ጤነ ኡበኖገ አዕዮህዕኔ፤ ጡመ አቶተ ኣሴህዕኔ፤ እቻንለከ ሙንዲኖን ቀልብክዕኔ ሰገብተ ዊንሼእ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","አሳበት ኬንከ ጠወኦጎሬሁ ኡመቱ እሳሃ ክትም ሆንጠህሳበእገ ከንቶኢሁ አበ ኦርጨቀንቲት። ");
INSERT INTO alw_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","እኮጎሬ አይሁዱ አንጾክለከ እቆንዮን ከተሚች ህከ ቤቹ አሜት ኡመት ሂለ አድመተ አማልሲስ ጳዉሎሴ ክኒን ቀስ ሬዮ አጉጃንሰ ጎሾሽት ከተሚች አብል ፉሽቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ጠዉ እኮጎሬ አዎንታስሩ አሜት መዴስ ኡርቶ ወክት ኬዕይ ከተመ ኣጎ፤ ለንክ በር በርናባሴንን ሜጡበ «ደርቤ» ዬኖ ከተመ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ጳዉሎስለከ በርናባስ «ደርቤተ» ዬኖ ከተማን ተሽት ላገተ ተማርስ ልግብ መነ ኢሰ አዎንታረ አቶኡ፤ ህከኒች ኤተሮን ልስጥረለከ እቆንዮነ ህግ «አንጾከ» ዬኖ ከተመ ፈንቀልት መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ህከን ከተማን ዮ አመዕናኖ ቀልብ ጠረኝሰን፥ አመዕነቶንከሰ ጠረኝት ሄኣገ ሸዘንለከ «መገን ዎምነቱ ኣጎኖተ ልግብ ኦርሸተ ቶጉ ሀስሰኖ» ይተን ተማርስታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","እሰን ቤቾን ቤቾን ዮ አመዕናኖተ ባልቅ ሾንቶኡ፤ ሶመንቶችለከ ዱአ አቶች ኤተሮን እሰ አመዕንቶ ቀርቺሃ ኤገተ ህግስ ኣቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","እሰን «ጵስድየ» ዬኖ ባዲን ህግ «ጵንፍልየ» ዬኖ ባዱ አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","«ጴርገ» ዬኖ ከተማን መገን ላገተ ተማርስቶች ኤተሮን «አጣልየ» ዬኖ ከተመ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ህከንቤቺች መርከባን ኣግ ሶርያን ዮ አንጾከ ፈንቀልቶኡ፤ ሁኩ አንጾክ ከተሙ ቴሱ አት ሹልቶ ሆጎተ ፉልቶ ወክት መገን ኣስቶተ ህግሴን ኤገተ ኣሴመሰሃ ቤቹ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ህከ ቤቹ ኢልቶ ወክት አመዕናኑተ ጉዕመንከ ሜጡበ ጭምአት መገኑ እሳን ሜጡበ አዕዮ ጠወ ጉዕመንከለከ አይሁደ እህቡ መኑ መገኑ አመዕንቶተ ሀት አዕይ ዎቃ ፈኞሰጎር ኩልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","እሰን ህከኔ አመዕናኖን ሜጡበ ልግብ ወክት አፉዕልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","መት-መቱ መኑ ይሁድ ባዲች አንጾክ ከተመ መርት «ሙስ ሕግገ ጡርከመንቴንበጎሬ ጡምቴነንተበአ» ይት አመዕናኑተ ተማርሱ ጀመርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ጳዉሎስለከ በርናባስ ህከን ጠውተኔሃ መኒንከስ አበ ብተንት ኦደንቶቤቺሃ እሰለከ ህከን ባድ አመዕናኖች መት-መቱ ዬሩሳሌማን ዮ ሶቀማኖቤቹለከ ባልቅቤቹ መርታገ ወሰነሞ። ");
INSERT INTO alw_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ህካን እኮቤቺሃ እሳንከ አመዕናኑት ዎቄሃሰ ሽንቅተ ኣት ሶካንሰ አይሁደ እህቡ መኑ ኢስ አደ ፈንቀሉሰ ኩልተን ፍንቄንለከ ሰማርይ ባዲን ህጎኡ፤ ሁኩ ጠዉ አመዕናኑተ ጉዕመንከ አበ ሙንዲሲሾ። ");
INSERT INTO alw_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","እሰን ዬሩሳሌመ ኢልቶ ወክት አመዕናኑት፥ አሳበትለከ ባልቀት «ሀበይ ወገሬቲን አሜቴን» ይት ቶጎሰ፤ ህትን መገኑ እሳን ሜጡበ አዕዮ ጠወ ጉዕመንከ ዬሩሳሌማን ዮ መኒሃ ኩልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ጠዉ እኮጎሬ ፈርሳዌ አዲች አመዕንቶ መኒች መት-መቱ ኬእ «ህከ አይሁደ እህበ መነ ጡርከመንታገለከ ሙስ ሕገ አገርታገ አኡ ሀስሰኖኔ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","አሳበትለከ ባልቀት ህከን ጠውተኔሃ አማዕለንቶተ ጭምይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","አበ ኦዶኢች ኤተሮን ጴጥሮስ ኬዕይ «አመኤ ኦሶ! አይሁደ እህቡ ኡመቱ ኢ አፌች ተሽት ላገተ ሞጮጭት አመዕንቶተ መገኑ ሄጭ ኤሳሃ ክዕኔ በሊች መጠሩስ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","መን ቀልብ ደገኖ መገኑ ጠሊለ አያኒን ኔሳሃ ኣሴ ሃሊን እሳሃ ኣሲን መሰከሮኡ። ");
INSERT INTO alw_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ቀልብሰ አመዕነቲን ነጠ አዕዮቤቺሃ እሰለከ ኒ በላን መት አደዶመታ አዕዮበአ። ");
INSERT INTO alw_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ህካን እኮች አናከኔለከ ነኡ እጅኖተ አታልንበ እጅነተ አመዕናኖተ እጅሲሴነን ሚሃት መገኑ ፌተንቴነንታት? ");
INSERT INTO alw_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ጠዉ እኮጎሬ ነኡ ጡምናሚሁ እሰገን ቀርቾ ኢስ አያኒን እሁስ አመዕንናም» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ህከ ወክት ጭምዬ መኑ ጉዕሙንኩ ጨለ ዬእ፤ ህትን በርናባስለከ ጳዉሎስ አይሁደ እኮበእ መን በላን እሰ አዲን መገኑ አዕዮ አጅበተለከ አጀብሲሰኖ ጠወ ጉዕመንከ ኩልተን ሞጮጭታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","እሰን ጠወእ ሹልቶች ኤተሮን ያቁብ ፈንቀሽ «አመኤ ኦሶ! ህንዴ ሞጮጭዬ! ");
INSERT INTO alw_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","መገኑ አይሁደ እህበ መኒች ሱዕሚንከስ ገአመኖ ኡመት በሊችሰ መጠር ወዕና ዳንዴሰገ ስሞን ኩሎኡ። ");
INSERT INTO alw_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ከን ሰውቲን ነብያከ ላገት መቱ እክ ኣገንቀንታአ፤ እስን ህት የመም ከተበሞሃን፦ ");
INSERT INTO alw_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","17","«‹ከኒች ኤተሮን ፈቆ መኑለከ ሱዕሚንከኤ ገአንቶእሩ አይሁደ እኮበእሩ ኡመቱ ጉዕሙንኩ ኤሳሃ ሀሳገ ፈንቀል አሜታም፤ ድጀሞ ደዉዴ ምኒ እጃራም፤ ድጀሞሲንከ ለንኪሃ ፈንቀሽ ኡርሳም። ");
INSERT INTO alw_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ወዕኔችን ጀመር ካን ጉዕመንከ ለሊሾም አን መገኑ ህት ያሚት›። ");
INSERT INTO alw_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","«ህካን እኮቤቺሃ ኢ ሰውቱ መገን አደ ፈንቀልቶ አይሁደ እህበ መነ ኦርንሱንከ። ");
INSERT INTO alw_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ህከን ወጥ ‹ሽርኬተ ክትሜመ እቸተ እቶኖቼ፤ ዝነተ አኢች፥ ለንገቅ ሬዮ ለል ማለ እቲችለከ ቄጉ አጊች አገዕርዬ› ይን ከተንባሰ። ");
INSERT INTO alw_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","መሰንትስ ልግብያ ዘማኒች ኬሽ ሙሲ ሕጋን ሰምበት በር ጭምት ምናን አነበበመኖት እቅ፤ ከተማን ጉዕማንን ዱዱብሰመኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ህከኒች ኤተሮን አሳበትለከ ባልቀት አመዕናኖን ጉዕሚንን ሜጡበ ጭምይት በሊችሰ ቀዉ መነ መጠርት ጳዉሎሴንለከ በርናባሴን ሜጡበ አንጾክ ከተመ ሶኮተ አማዕለንቶኡ፤ ህካን እኮቤቺሃ አመዕናኖ በሊች ጡመ አዎንሳኖች «በርሳባሴ» ዬኖ ይሁደለከ ሲላሴ መጠርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ከተበንቶ ደብዳቤተ እሰ አንጋን ሶኮኡ፤ ደብዳቤስን «ነኡ አመክዕኔ ኦሱት አሳበትለከ ባልቁ፦ አንጾክ ከተማን፥ ሶርይለከ ክልቅይ ባዶን ሄኤነንተ አይሁድ እህቡ መን አድረ እኬንተ አመኔኦሱተ ወገሬቴ ይናንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ኒ በሊች መት-መቱ መኑ ነኡ ሶንኩዕነ ክዕኔቤቹ መርት ኩልቶህዕኔ ላጋን ኦርሶህዕኔገለከ ሻዝሶህዕኔገ ሞጮጭኖም። ");
INSERT INTO alw_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ህካን እኮቤቺሃ ሜጡበ ጭምይኖሚች ኤተሮን መጠርን ኢተንቶ አመኔኦሶች በርናባሴለከ ጳዉሎሴ ሜጡበ ክዕኔቤቹ ሶንኮተ ኢተቀሞም። ");
INSERT INTO alw_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","በርናባስለከ ጳዉሎስ ቀርቹሃኔ መሲህ ኢስ ሱዕምተኔሃ ገዉሰ ህግስ ኣቶእረ። ");
INSERT INTO alw_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ይሁድለከ ስላስ ነኡ ከተንቦሚሃ ገይሰ አፎን ኩልታህዕኔገ ሶንኮም። ");
INSERT INTO alw_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ህካን እኮቤቺሃ ከኒች ዎሮ አዲን ዮ ሀስሰኖ ጠወ ቤሉ ዎሉ ኬዕመኖ ጠወ እጅሲንሳንክዕኔበእገ ጠሊሉ አያኑለከ ነኡ ኢተቀሞም። ");
INSERT INTO alw_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ሽርኬተ ክትሜመ ማለ እቶኖቼ፥ ዝናች፥ ለንገእ ሬዮ ለል ማለ እቲችለከ ቄጉ አጊች አገዕርዬ፤ ካን ጉዕመንከ አገዕርቴንተጎር ጡመሃን፤ ቴሱ ወገሬቲን ሄዕዬ» ይት ከተቦኡ። ");
INSERT INTO alw_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ህከኒች ኤተሮን ሶሄመ መኑ ወገሬቲን ሄዕዬ ይት አንጾክ ከተመ መርቶኡ፤ እሰን አመዕናኑተ ጭምአት ደብዳቤተ ኣቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","አመዕናኑት ደብዳቤተ አነበቦ ወክት ሶሄመ ሸዘናን አበ ሙንደኦኡ። ");
INSERT INTO alw_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ህትን ይሁድለከ ስላስ ነብያከተ እኮቤቺሃ አመዕናኑተ ልግብየ ጠዊን ሸዝ ጠረኝሶኡ። ");
INSERT INTO alw_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","እሰን ህከኔ ዮ አመዕናኖን ቀዉ በር ሜጡበ አፉዕልቶች ኤተሮን «ወገሬቲን ሄዕዬ» ይት ሶኮ መንቤቹ ፈንቀልት መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ጠዉ እኮጎሬ ሲላስ ህከኔ ፈቆተ ሄዕላቾ። ");
INSERT INTO alw_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","እኮጎሬ ጳዉሎስለከ በርናባስ ቀዉ በር አንጾክ ከተማን ዱንክት ዎሎ ልግብየ አመዕናኖን ሜጡበ ቀርች ላገተ ተማርስተን ተሽት ላገተ ዱዱብስቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ቀዎ በሬች ኤተሮን ጳዉሎስ በርናባሴ «አም ከኒች ብርተ ቀርች ላገተ ተማርስኖም ከተማን ጉዕማንን ዮ አመዕናኑት ሀት ዮ ጎሬ ዳንድኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","በርናባስ ህትን «ማርቆሴ» ዬኖ ያህይ እሳን ሜጡበ መሮተ ኢቴእ። ");
INSERT INTO alw_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ጠዉ እኮጎሬ ጳዉሎስ እሳን ሜጡበ መሮተ ሀሾበአ፤ መሰንትስ እስ «ጵንፍልያ» ዬኖቤቾን እሳች አደ እክ ሆጎቤቹ መሩዕነ ፈቆቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ህከን ጠዊን አበ ኦዶኢች ኤተሮን መለዕለንቶኡ፤ ህካን እኮቤቺሃ በርናባስ ማርቆሴ ኣእ መርከባን ኣግ ዊን ረበንቶ «ቆጵሮሰ» ዬኖ ባዱ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ጠዉ እኮጎሬ ጳዉሎስ ስላሴ መጠሮ፤ አመዕናኑት ጳዉሎሴ ቀርች ኣስቶተ ኤገተ ኣቶኢች ኤተሮን ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","እስን «ሶርየለከ ክልቅየ» ዬኖቤቾን ዮ አመዕናኑተ ጠረኝሰን ሃመኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ጳዉሎስ «ደርቤተለከ ልስጥረ» ዬኖቤቹ አሜቾ፤ ህከኔን «ጥማቶሴ» ዬኖ አመዕናንቹ ሄዕዮ እቅ፤ አመስ አይሁድተ አመዕናንቹ እቅ፤ እኮጎሬ አኑስ ግርክቾሃ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","እሲንከ «ልስጥረለከ እቆንዮነ» ዬኖቤቾን ሄኣ አመዕናኖ አኔን ጡሙ ሱዕሙ ሄዕዮስ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ጳዉሎስ ጥማቶሴ ኣእ ሃሞተ ሀሾቤቺሃ ጡርከሞስ፤ መሰንትስ ህከን ቤቾን ሄኣ አይሁዱ ጉዕሙንኩ ጥማቶሴ አኑ ግርክቹ እሁስ ደጋቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ጳዉሎስለከ ሲላስ ከተመ ዘህተን ዬሩሳሌም ከተማን ዮ አሳበትለከ ባልቀተ ጠወእ ኡርሶ ትዛዝ አመዕናኑት አገርታገ ሸዛኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ህካን እኮቤቺሃ አመዕናኑት ጠረኝተን በሬን በሬን ወሊንሹሰ በተአን መረኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ህትን እሰ እስይ ባዶን መገን ላገተ ኩልታበእገ ጠሊሉ አያኑ ከማንሰ ፍርግይለከ ገለትይ ባዲን ህጎኡ። ");
INSERT INTO alw_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","«ሚስየ» ዬኖ ባዱ ኢልቶ ወክት ቢታንየ ባዱ መርቶተ ሰውይቶኡ፤ ጠዉ እኮጎሬ ኢስ አያኑ ህከበ መርታበእገ ከሞሰ። ");
INSERT INTO alw_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ህካን እኮቤቺሃ እሰ ሚስይ ባዲን ህግ ጢሮኣድ ከተመ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ህካን እኮቤቺሃ ሀንከዕርተ መቱ መቄዶን መንቹ ኡር «መቄዶነ አሜት ሀዕልኔ» የን ኡጨኖሃ ጳዉሎስ መናማን ለዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ጳዉሎስ መናማን ለዕዮች ኤተሮን ነኡ ህከ ወክትንከ መቄዶነ መርኖተ ቅጥይኖም፤ መሰንትስ ነኡ ህከኔ ዮ መኒሃ ተሽት ላገት ኩልኖተ መገኑ ገኡስ ደንጎምቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ጢሮአዲች መርከባን ኣንግ «ሳሞትራቄ» ዬኖቤቹ ኢልኖም፤ ለንክ በር «ናጱሌ» ዬኖቤቹ መርኖም። ");
INSERT INTO alw_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ህከንቤቺች ኬዕን ፍልጵስዩስ ከተመ ኢልኖም፤ ፍልጵስዩሱ መቄዶን አዉራጂሃ ሎረ ከተመለከ ሮም ባድ ዎም አንጋን ጠገሞሃ እቅ፤ ነኡ ህከን ከተማን ቀዉ በር ዱንክኖም። ");
INSERT INTO alw_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ህትን ሰምበት በር ከተሚች አብል ዱአ አቶተ ጭምይታቤቹ ዮኢሃ አጉጆኔቤቺሃ ፉልን ዛዘኖ ዊ መድ መርኖም፤ ህከኔ አፉዕልን ጭምይቶ ሜንቲሃ መገን ላገተ ተማርስኖም። ");
INSERT INTO alw_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ህከኔ ሞጮጭታ ሜንቲች መት ትያጥሮን ከተሚች አሜቶ ሰመ አጉደኖ ብሸ ኦድኑተ ነገዳ መገኒሃ ሰገዳ «ሊድየ» ዬኖ መንቹተ እቅ፤ ጳዉሎስ ጠወአኖርቹ አጥራመቶተ መገኑ ቀልብሴ ፈኞ። ");
INSERT INTO alw_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","እሴን ምንሴ መኒን ጉዕሚንን ሜጡበ ጠመቀንቶች ኤተሮን «ቀርቾ መገኖን አመዕኔሚሃ እኮሚች ምኒኤ አሜቴን አፉዕልዬ» ይት ጠረኝስ ኡጭቶኔቤቺሃ መርኖም። ");
INSERT INTO alw_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ነኡ መቱ በር ዱአ አኤኖ ቤቹ መርነኒን ኪልታገ አአኖ ዶሮረኖ ዱሩ ዮሴ መት ካዲንቹት ሀፍቱት ዎቃን ደቀንቶኔ፤ ህት ሀፍቱት ኪልተን ገሽታሴሀኑኡተ ልግብ ብረ ኤባእተ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","እሴን ጳዉሎሴለከ ኔሳሃ አዎንተን «ኩ መኑ ሎረ መገንተ ካዲመ፤ እሰ ጡሜኖ ዎቃሃ ክዕኔሃ ኩልታህዕኔረ» ይተን ያርታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ህካንን ልግብ በር አቶኡ፤ ጠዉ እኮጎሬ ጳዉሎስ ኡሙዕር ኤተሩ ፈንቀል ለዕይ ዶሮረኖ ዱሩ «መሲህ ኢስ ሱዕሚን እሴች ፉልቶተ አዘዛንኬ» ዬእ፤ ህከ ወክትንከ ዶሮረኖ ዱሩ ፉሎ። ");
INSERT INTO alw_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","እኮጎሬ ገሻኑሴ ብረ ደዕተ ዎቆሁ ሙርተኡስ ደጎ ወክት ጳዉሎሴለከ ሲላሴ አፍ ጌቤበ ጎሾሽተን መስት ሹመ ቤቹ ሆንጠህሶኡ። ");
INSERT INTO alw_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","እሰን ሮም ዳኛኖ ብርተ ሆንጠህስ «ኩ መኑ አይሁድ መነ እከን ከተማንከኔ ብተተ ኬሳኢት። ");
INSERT INTO alw_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ነኡ ሮም ባድ መኑ ቶንጎተለከ አዕኖተ ሴሩኔ አዘዝባሃ ሮስሳኔት» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ኡመቱ እሰ አሌን ጭምይት ኬኦኡ፤ ዳኛኑት ጳዉሎሴለከ ስላሴ ኦድኑተ ቃርቶሳች ኤተሮን በርቲን ዎቀርታገ አዘዞኡ። ");
INSERT INTO alw_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","አበ ዎቀርቶች ኤተሮን ኡሱር ምኒ ኣግስ ኡሱር ምኒ ዘበኘ ጠረኝ አገረኖገ አዘዞኡ። ");
INSERT INTO alw_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ሁኩ ኡሱር ምኒ ዘበኙ ትዛዝ ቶጎች ኤተሮን ኣዝ ክፍለ ኣግሽ ሎከሰ ሀቃን ኡሱሮ። ");
INSERT INTO alw_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ሀንከዕሬ በላን ጳዉሎስለከ ስላስ ዱአ አተንለከ መዝሙረ ዘመርተን መገኑ ገለትጭታኢሃ ዎሉ ኡሱሬመ መኑ ሞጮጨኖሳት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ድንገቴን ኡሱር ምኒ ቀበቡ ሌንቄቀኖ ኢለ አቡ ኡለ ሌንቄቁ እኮ፤ ህከ ወክት ኡሱር ምኒ ጡፉ ጉዕሙንኩ ሜጦረ ፈንተዕዮ፤ ህትን ጉዕምሰ ሰንሰለቱ ሂርተዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ኡሱር ምኒ ዘበኙ ግሰኛች በቅይ ኡሱር ምኒ ጡፉ ፈንተዕያን ለዕዮ ወክት ኡሱረኙ ፉሸኢቶኢሃ አጉጃንስ ገዉስ ሾተ ብሰ ኬሾ። ");
INSERT INTO alw_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ጠዉ እኮጎሬ ጳዉሎስ «ጉዕሙኩኔ ከኔ ዮምቤቺሃ ገዉክ ሚርቶት» ይ ሎረ ላጋን ያር ከሞስ። ");
INSERT INTO alw_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ህትን እስ መብራት አፍሲሽ ኣእ ኣዝ ጠጡተ ደጉጅ ኣግ ሁጠን ጳዉሎሴለከ ስላሴ ብሬን ኡቦ። ");
INSERT INTO alw_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","እሰንተ አብል ፉሽ «ቀርቻኑኤ! አን ጡሞተ መ አኡ ሀስሰኖኤ?» ይ ጠዕሜሰ። ");
INSERT INTO alw_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","እሰን «ቀርቾ ኢሳን አመዕንቶንትጎር አትለከ ኪ ምኒ መኑሁ ጡምቴነንተ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ህትን እሰ ቀርች ላገተ እሲሃለከ ምኔስ ዮ አበሮሲሀስ ኩልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","እስ ህከ ወክትንከ ሀንከዕሬን እሰተ መስኬዕይ ጡላሰ ኣንሽ አበሮስንከስ ሜጡበ ጠመቀሞ። ");
INSERT INTO alw_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ህከኒች ኤተሮን ጳዉሎሴለከ ሲላሴ ምንስ ኤብ እቸተ ሆንጠህሾ፤ ህትን እስለከ ምንስ መኑ መገኖን አመዕንቶቤቺሃ ሙንደኦኡ። ");
INSERT INTO alw_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ጠዉ እኮጎሬ ለንክ በሬ ሱጵተ ከተመስ ገሽታሩ «ህከ መነ መርቶተ ገፈሬ» ይት ፖሊሰተ ሶኮኡ። ");
INSERT INTO alw_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ኡሱር ምኒ ዘበኝቹ «አዕኑ ገፈረንቶኖተ ዳኛኑት መነ ሶኮኡ፤ ህካን እኮቤቺሃ አዕኑ ቴሱ ፉልቴን ወገሬቲን ኦሮዕዬ» ይ ጳዉሎሴሃ ኩሎ። ");
INSERT INTO alw_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","እኮጎሬ ጳዉሎስ «ነኡ ሮም ባድ መነ እንከን መቱርቹሃ ቤንሱዕነ ፍርድ ቤሉ ኡመት ብሬን ዎቀርት ኡሱር ምኒ ኣግሶኔ፤ ህትን ቴሱ ማጠም ፉልናምገ አታኔትንዶ? ፉልናምበአ! እሰ ገዉሰ አሜት ፉሽቱኔ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ፖሊሰት እሰ ይቶ ላገተ ዳኛኖተ ኩልታንሰ ዳኛኑት ጳዉሎስለከ ስላስ ሮም ባድ መነ እሁሰ ሞጮጭቶ ወክት ዋጅቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ህካን እኮቤቺሃ ዳኛኑት አሜት «ቤንሶም» ይት ኡሱር ምኒች ፉሽት ከተሚች ፉልት መርታገ ኡጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ጳዉሎስለከ ስላስ ኡሱር ምኒች ፉልት ሊድያ ምኒ ኣጎኡ፤ ህከኔን አመዕናኑተ ሸዝ ጠረኝስ አጉርት መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ህከኒች ኤተሮን እሰን «አንፊጶሊሰለከ አጶሎኖ» ዬኖ ከተሚን ህግ ተሰሎንቄ ከተመ አሜቶኡ፤ ህከኔን አይሁድ ጭምት ምኑ ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ጳዉሎስ ወዕና ሮሾገን አይሁድ ጭምት ምኒ ኣጎ፤ እስን እሳንከ ሰሱ ፎሎጭ በር መገን ላገተ ጠሊለ መጻፊ ኣዚች አነበበን እሳን ሜጡበ ኩለኖሳት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ህትን መሲሁ ኦርሸተ ቶጉለከ ሬሆች ኬኡ ሀስሰኖስገ ሀንቅ እሁስ ለሊሽ ኩለን «ኩን አን ኩላንክዕኔ ኢስ መሲህት» የኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ህካን እኮቤቺሃ አይሁዲች መት-መቱሰ ላገስ ኣጋንሰ አመዕንት ጳዉሎሴንለከ ሲላሴን ሜጡበ እኮኡ፤ ህትን መገኒሃ ሰገዳ ልግቡ ግሪክ ባድ መኑለከ ከተማንከስ ለሊቶ ሜንቱ ላገስ ሞጮጭት እሳን ሜጡበ እኮኡ። ");
INSERT INTO alw_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ጠዉ እኮጎሬ አመዕንትቡ አይሁዱ ምቀኝት ሆጉት ዮበእ መነ ዎቄች ጉዕሚችን ጭምአት ልግብ መነ ሂለ አማልተ አማልሲስ ከተማንከስ ብተት ኬኣገ አቶኡ፤ ጳዉሎሴለከ ሲላሴ ፉሽት ኡመቲሃ ኣቶተ ሀስ «ኢያሶን» ዬኖ መንች ምኒ ረቦኡ። ");
INSERT INTO alw_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ጠዉ እኮጎሬ እሰተ ሀስ ሆጎ ወክት ኢያሶኔለከ መት-መቱ አመዕናኑተ ከተም ሹማተ ሆንጠህሶተ ጎሾሽተን መስቶኡ፤ ህትን «ኩ መኑ ጉዕመንከ ባዱ ኦርሳእረ፤ ህትን ቴሱ ኒ ከተመ አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ኢያሶንን ምኔንከስ ቶጎሰ፤ ህትን ‹ኢሰ ዬኖ ዎሉ ዎሙ ዮኔ› ይት ሮም ባድ ዎም ትዛዝ ግቦእረ» ይት ያርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ኡመቱለከ ከተም ሹመት ህከ ጠወ ሞጮጭቶ ወክት አበ ጨነቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","እሰን ኢያሶኔለከ ዎሉ መነ ሩብት ገእሲስ ገፈርቶሰ። ");
INSERT INTO alw_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ህከ ወክት አመዕናኑት ጳዉሎሴለከ ሲላሴ ሀንከዕሬን «ቤርየ» ዬኖ ከተመ ህርሲሶኡ፤ እሰን ህከ ቤቹ ኢልቶገን አይሁድ ጭምት ምኒ ኣጎኡ። ");
INSERT INTO alw_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ህከኔ ሄኦ አይሁዱ ተሰሎንቄ ከተማን ሄኣ አይሁዲች በትስ ጡሙ ቀልቡ ዮሰቤቺሃ ጳዉሎስ ዬ ጠዉ ሀንቅያ ጎሬ ደጎተ በሬን በሬን ጠሊለ መጻፈ መረመርተን ላገስ አበ ሙንዲኖን ቶጎኡ። ");
INSERT INTO alw_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ህካን እኮቤቺሃ እሳች ልግቡሰ አመዕንቶኡ፤ ልግቡ ግሪክ ቀባጣሙ ሜንቱለከ ልግቡ ግሪክ ጎኑ አመዕንቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ጠዉ እኮጎሬ ተሰሎንቄ ከተማን ሄኦ አይሁዱ ጳዉሎስ ቤርይ ከተም መኒሃ መገን ላገተ ኩሎገ ሞጮጭቶ ወክት ህከ ቤቹ አሜት መነ ሂለ አማልተ አማልሲስ ኡመቱ አሌሰ ኬአኖገ አቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ህከ ወክትንከ አመዕናኑት ጳዉሎስ ደዕል ባር መድ ኦሮአኖገ አቶኡ፤ እኮጎሬ ሲላስለከ ጥማቶስ ቤርያን ፈቆኡ። ");
INSERT INTO alw_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ጳዉሎሴ ህርሲስ አቴን ከተመ ኢልሶ መኑ «ስላስለከ ጥማቶስ ደዕልት ኢቤቹ አሜቱን» ዬ ጳዉሎሴ ሶህኑተ ኣእት ቤርየ ፈንቀልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ጳዉሎስ አቴን ከተማን አፉዕል ሲላሴለከ ጥማቶሴ አገረን ከተማንከስ ሽርኬተ ሰገዴኖርቹ ዊሞሀ ለዕዮ ወክት ቀልቤንከስ አበ ኡሙዕሬእ። ");
INSERT INTO alw_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ህካን እኮቤቺሃ ጭምት ምኔን አይሁዲንለከ መገኒሃ ሰገዳ መኒን ጉዕመ በር ጌባን ደቀመኖ መኒን ጠወአኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","«ኤፒኮሮሰለከ እስቶይኮ» ዬኖ ኤንኬዕናመት ጳዉሎሴቤቹ አሜተን ኦደንታኢት እቅ፤ መት-መቱሰ «ኩ ዛንቁራንቹ መ ዮተ ሀሾኡ?» ይታኢት እቅ፤ ህትን ዎሉሰ ፈንቀሽት «ደገሞበእ መገኒሃ ጠወአኖ አጉደኖት» ይታኢት እቅ፤ ህካን ይቶ መሰት ጳዉሎስ ኢስ ሬሆች ኬእ ጡመ ዱዱቡ ኩሎሰቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","እሰን ጳዉሎሴ ኣእት «አርዮስፋጎስ» ዬኖ ቆሮን ሄአኖ ኦገትቤቹ ኤብ «ኩ አት ኩልታንትኔ ሃዕሮ ጠዉ መርቹሃጎሬ ደንጎተ አታልናምንዶ? ");
INSERT INTO alw_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ኩ አት መጫተኔ ሃዕሮ ጠወ ጠወአንቲሁ መሃጎሬ ደንጎተ ሀንሳምቤቺሃ መሃጎሬ ኩልኔ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","መሰንትስ አቴን ከተም ጉዕሙንኩ መኑለከ ህከን ቤቾን ሄኣ ዎሎ ባድ መኑ ሃዕሮ ጠወ ጠወአንለከ ሞጮጭተን ሆስ ቤሉ ዎሉ መቱርቹሃ አታበእረ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ህካን እኮቤቺሃ ጳዉሎስ «አርዮስፋጎስ» ዬኖ ኦገት ብሬን ኡር «አቴን መነ! ጉዕማንከ አዲን ሀይማኖቱ ዮህዕኔ መነ እሁክዕኔ ደጎም። ");
INSERT INTO alw_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ከተመክዕኔ ዘሀን አዕኑ ሰገዴነንተ ቤቹ ለዕዮም ወክት ‹ደገሞበእ መገኒሃ› የመም ከተበሞሃ ክትም ጠረጴዘ ደጎም፤ ቴሱ ህከ ደጎኑዕናን ሰገዴነንታሃ አን ኩላንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","«መገኑ ኡለተለከ ኡለ አሌን ዮኢሃ ጉዕመንከ ከለቆእሃን፤ እስን ሰሜለከ ኡለ ቀርቹ እኮቤቺሃ መኑ አንጋን እጃሮ ምኔን ሄአኖበአ። ");
INSERT INTO alw_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","እስን ነብሳለከ ፎገል ዎሉርቹ ጉዕመንከ መኒሃ ኣሰኖሃ እኮቤቺሃ መቱርቹሁ ሆፈዕዮስሀንገ መን አንገተ ሄዕላተኖበአ። ");
INSERT INTO alw_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","እሲን ኣዱንያ አሌን ሄኣ አደደ ኡመት ጉዕመንከ መቶ መንቺች ከለቆ፤ ኡለ አሌን ጉዕማንን ሄኣገ አዕዮሰ፤ እሳንከ ሄኣ ዘማንለከ ሄኣ ቤቹ መደቦሰ። ");
INSERT INTO alw_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ህካን አዕዮንኩ መኑ መገኑ ሀሶተለከ መረመርት ሀስ እሱ ደጋጋት፤ እሁን ቤሉ እስ ኒች ጉዕሚችኔን ቄዕራሻበአ። ");
INSERT INTO alw_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","መሰንትስ ‹ሄኡ ደእናሚሁለከ ሌንቄቅናሚሁ ህትን ሄዕናሚንኩ እሲኒት› ሁኩንን ክዕኔ መት-መቱ ሴነፋሩ ‹ነኡ ጉዕሙንኩኔ እስተ እለ› ይቶጋት። ");
INSERT INTO alw_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ቴሱ ነኡ መገን ኦሱተ እንኮምጎሬ ‹መገኑ መን ሀይማንለከ ሰውቲን ዎርቂን ህከረንገ ብሪን ህከረንገ ክኒን መክሴመ ምስለ አጉደኖ› ይን ሰውዩ ሀስሰኖኔበአ። ");
INSERT INTO alw_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ህካን እኮቤቺሃ መኑ ወዕኔ ዘማን ደጉ ሆጊን አቶኢሃ መገኑ አጉሮሰ፤ እኮጎሬ ቴሱ ባዶን ጉዕማንን ዮ መኑ ጩቢች ቶበት ፈንቀልታገ አዘዦኡ። ");
INSERT INTO alw_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","መሰንትስ መገኑ መጠሮ መንች አዲን ጉዕማንከ መን አሌን ጌጥ አዕይ ፈረደኖ በር ወሰኞኡ፤ ህካን ሀንቅ እሁስ መን ጉዕሚንከ ለሊሾሁ ህከ እስ መጠሮ መንቹ ሬሆች ኬሲንከሲት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","እሰ «ሬሆች ኬኡ» ዬኖ ላገተ ሞጮጭቶ ወክት መት-መቱሰ ቀለዶኡ፤ መት-መቱሰ «ከን ጠውተኔሃ ዎሉ ወክት ሞጮጭናም» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ህከኒች ኤተሮን ጳዉሎስ ኦገቲችሰ ኬዕይ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ጠዉ እኮጎሬ መት-መቱ መኑ አመዕንት እሲን ሜጡበ እኮኡ፤ እሳንን ሜጡበ «አርዮስፋጎስ» ዬኖ ኦገት መኒች መቱ «ዲዮናስዮስ» ዬኖ መንቹ፥ «ደማሪስ» ዬኖ መት መንቹትለከ ዎሉ ልግቡ መኑ ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ህከኒች ኤተሮን ጳዉሎስ «አቴና» ዬኖ ከተሚች ኬዕይ ቆሮንቶስ ከተመ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ህከኔን ጳንጦስ ባዲሃ «አቂለ» ዬኖ መቱ አይሁድቹ ደጎ፤ እስን ቀዎ ወክቲች ብርተ መንቾንከስ ጵርስቅላን ሜጡበ ጣሊያን ከተሚች አሜቾሃ እቅ፤ መሰንትስ አይሁዱ ጉዕሙንኩ ከተሚችስ ፉልቶተ ሮም ባድ ዎመ ሀለቁ ዎሙ ቀላዉዴዎስ አዘዦቤቺሃት እቅ፤ ጳዉሎስን እሰንተ ለኦተ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","እስ ሆጉት እሰገን ዱካነ ጎቡ እኮቤቺሃ እሳንን ሜጡበ ሄአን እሲሁ ዱካነ ጎቡ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","እስን ሰምበት በር ጉዕመንከ አይሁዲለከ ግሪክ መኒሃ ጭምት ምኔን ደገመን ተማርሰን አመንሲሰኖሳት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ህከኒች ኤተሮን ጥማቶስለከ ሲላስ መቄዶን ባዲች አሜቶ ወክት ጳዉሎስ ኢስ መጠረሞ መሲሁ እሁስ አይሁዲሃ ጉዕመንከ ወክት ጠረኝሽ ኩለኖሳት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ጠዉ እኮጎሬ አይሁድ መኑ እሱ ግቦስለከ ቦሮርቶስ ወክት ኦድኖስ ትበ ግግሽ «ቴሱ ፈረደሞህዕኔ ጎሬ ገይክዕኔ ቤሲን እኮቤቺሃ ኤሳሃ ከን ጠዊሃ ኣግሰኖኤበአ፤ ቴሱ አን አይሁደ እህበ መንቤቹ ኦሮኣም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ህካን እኮቤቺሃ ጳዉሎስ ህከንቤቺች ኬዕይ መገኒሃ ሰገደኖ «ቲቶስ ኢዮስጦስ» ዬኖ መንች ምኒ ኦሮዕዮ፤ ምኑስ አይሁድ ጭምት ምኒሃ መድ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","አይሁድ ጭምት ምኒ ዳኙ «ቀረስጶስ» ዬኖ መንቹ ምንስ አበሮሲን ሜጡበ መገኑ አመዕኔእ፤ ህትን ልግቡ ቆሮንቶስ ከተም መኑ ጳዉሎሴች መገን ላገተ ሞጮጭት አመዕንት ጠመቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ቀርቹ መት ሀንከዕርተ መናማን ጳዉሎሴ «ዋጅቶት ሰዕምይት ጠወእ። ");
INSERT INTO alw_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","አን ኪኒት፤ አዪሁ ኬሳሃ ሚዕሮሄተ አታለኖበአ፤ መሰንትስ ከን ከተማን ኤሳሃ ልግቡ መኑ ዮኤ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ህከን ቤቾን ጳዉሎስ መገን ላገተ ኡመቲሃ ተማርሰን መቱ ዘማን ደሬን እሰቤቾን ዱንኬእ። ");
INSERT INTO alw_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ጠዉ እኮጎሬ «ጋልዮስ» ዬኖ መንቹ አካይ ባድ ሹመ እኮ ወክት አይሁድ መኑ ሜጡበ እክ ጳዉሎሴ አሌን ኬእ አፍ ፍርድ ምኒ መስቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ህከን ቤቾን «ኩ መንቹ ሕጉ አዘዝበ ሃሌን መኑ መገኒሃ ሰገደኖገ አአኖት» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ጠዉ እኮጎሬ ጳዉሎስ ህከን ጠውተኔሃ መስለ ፈንቀሾተ ቅጥ ይዮሀኔን ጋልዮስ አይሁደ «አዕኑ አይሁድ መኑ! ክዕኔ አሌን ኬዕማሸ ጠወ ህከረንገ ሂለ አኤማህዕኔ እቃን ክሰክዕኔ አደቢን ሞጮጫም እቅ። ");
INSERT INTO alw_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ጠዉ እኮጎሬ ኩ ጠዉ ጠለዕል ላገተኔሃ፥ ሱዕምተኔሃለከ ገይክዕኔ ሕግተኔሃ ኦዴነንታሃ እኮጎሬ ኤሳሃ ኣግሰኖኤበ፤ አን ከን ጠው አሌን ፈረዶተ ሀሳምበአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","እስን ህት ይ ፍርድ ምኒች አብል ፉሼሰ። ");
INSERT INTO alw_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ህከኒች ኤተሮን እሰ ጉዕሙንኩ ጭምት ምኒ ዳኛ «ሶስቴንሴ» ዬኖሃ አፍ ፍርድ ምኒ ኦገት ብሬን ኦልቶስ፤ እኮጎሬ ሁኩ ጠዉ ጋልዮሴሃ መቱርቹሃ አጉጆስበአ። ");
INSERT INTO alw_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ጳዉሎስ ልግብ ወክት ቆሮንቶስ ከተማን ዱንኬእች ኤተሮን አመዕናኑተ «ወገሬቲን ሄእዬ» ይ ሶርይ ባዱ ኦሮዕዮ፤ ህትን ጵርስቅልለከ አቂል እሲን ሜጡበ ሄኦ እቅ፤ እኮጎሬ ሁንዱር ኣጎቤቺሃ ኦሮአኖሀኒች ሄጭ ሙምስ «ክንክሪያ» ዬኖቤቾን ሜጆ። ");
INSERT INTO alw_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","እሰን ኤፌሶን ከተመ ኢልቶ ወክት እስ ጵርስቅለለከ አቂለ ህከኔ አጉር አይሁድ ጭምት ምኒ ኣግ አይሁድ መኒሃ ጠወአኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ጳዉሎስ ልግብ ወክት እሰቤቾን ዱንኮተ ኡጭቶስ ወክት ቶጉ ግቦሰ። ");
INSERT INTO alw_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ጠዉ እኮጎሬ «መገኑ ዬጎሬ ዎሉ ወክት ክዕኔቤቹ ፈንቀል አሜታም» ይ ኤፌሶኒች መርከባን ኣግ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","እስ «ቂሳርያ» ዬኖ ከተመ ኢል ህከኒች ኤተሮን ዬሩሳሌመ ኦሮዕይ አመዕናኑተ ወገሬትሾች ኤተሮን ዘህ አንጾክ ከተመ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","እስን ቀዉ ወክት አንጾክ ከተማን ዱንኬች ኤተሮን ህከንቤቺች ኬዕይ «ገለትየለከ ፍርግየ» ዬኖ ባዶን ቤቺች ቤቹ ዘሀን አመዕናኑተ ጉዕመንከ ጠረኝሰኖሳት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","«አጵሎሴ» ዬኖሁ አሌክሰንደር ከተማን እለሞ አይሁድቹ ኤፌሶን ከተመ አሜቾ፤ እስን ጡመገ ጠወአኖሃለከ ጠሊለ መጻፈ አጥራመች ደገኖሃ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","እስን ቀርች ዎቄተኔሃ ጡመገ ተማሮሃለከ ህትን አበ ቡብ ኢስ ሀንቅ ጠወ ጌጥ አዕይ ጠወአኖለከ ተማርሰኖ እቅ፤ እኮጎሬ እስ ጠለዕል ያህይ ጠመቆ ጥምቀት ደገኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ህትን እስን መለል አይሁድ ጭምት ምኔን ጠወአኖሃ ጵርስቅልለከ አቂል ሞጮጭቶ ወክት ምንሰ መስት መገን ዎቃሃ ወዕኔች ባሰ ተማርስቶስ። ");
INSERT INTO alw_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ህትን አጵሎስ አካይ ባዱ መሮተ ሀሾ ወክት አመዕናኑት ጠረኝሶስ፤ እሰን አካይ ባዶን ሄኦ አመዕናኑት ቶጎስተ ደብዳቤተ ከተቦስ፤ እስን ህከ ቤቹ ኢሌ ወክት መገን አያኒን አመዕንቶእረ አበ ሀዕለኖሳት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ህካን እኮቤቺሃ ኢስ ቡረሞሃ እሁስ ጉዕማንከ መን ብሬን አይሁድ መኒሃ ጠሊለ መጻፊች አነበበን ጠረኝ ኦደን ገረኖሳት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","አጵሎስ ቆሮንቶስ ከተማን ሄዕዮ ወክት ጳዉሎስ አል ባዲን ህግ ኤፌሶን ከተመ አሜቾ፤ እስን ህከን ቤቾን ቀዉ አመዕናኑተ ደግ ");
INSERT INTO alw_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ጳዉሎስ «አመዕንቴንተ ወክት ጠሊለ አያነ ቶጌንታእቅንዶ?» ዬሰ፤ እሰን «ቶንጎምበአ፤ ጠሊለ አያነ ሄኡስ ሆሮ ሞጮጭን ደንጋምበአ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ህትን ጳዉሎስ «ህከረ ሀትኔ ጥምቀቲሃት ጠመቀንቴንታሁ?» ዬሰ፤ እሰን «ያህይ ጥምቀትኒት ጠመቀሞሚሁ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ጳዉሎስን «ያህይ ‹ኡመቲሃ ጩብክዕኔ ቶበቴን ፈንቀልቴን ኢች ኤተሮን አሜተኖ ኢሳን አመዕንቴን ጠመቀሜ› ዬእ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","እሰን ህካን ሞጮጭቶ ወክት ቀርቾሃ ኢስ ሱዕሚን ጠመቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ህትን ጳዉሎስ አንገስ እሰ አሌን አዕዮ ወክት ጠሊለ አያነ እሰ አሌን አሜቻን አደደ አፎን ጠወኦኡ፤ ራገሃ ጠወኡ ጀመርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","እሰ ጉዕሙንኩሰ ቶነ ለሞ መንየ ጌሰ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ጳዉሎስ አይሁድ ጭምት ምኒ መር ሰሶ አገን ጌሰ መገን ዎምነትተኔሃ ኦደን መለል መኒሃ ተማርሰኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ጠዉ እኮጎሬ መት-መቱ ጢቃመተ እኮቤቺሃ ኢስ ዎቃሃ ኡመት ብሬን ቦሮርተን አመዕኑ ግቦ ወክት እሰንተ ጌኝ አዕዮ፤ እስን አመዕናኑተ አደ አዕይ እስቤቹ መስ «ጢራኖሴ» ዬኖ መንቹ ተማርሰኖ ቤቾን መኒሃ በሬን በሬን ተማርሰኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","እስይ ባዶን ሄኣ አይሁዱለከ ግርክ መኑ ጉዕሙንኩ ቀርች ላገተ ሞጮጭት ቶጎተ ኢለ ጳዉሎስ ህከን ቤቾን ለሙ ዘማን ተማርሴእ። ");
INSERT INTO alw_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ህትን መገኑ ጳዉሎሴ አንጋን አበ አጅበተ አአኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ህካን እኮቤቺሃ ጳዉሎሴ ጅስመስ ኡልቶ ኦድኑተለከ ማረበ ኣኤን ጥዘናመ አሌን አኤኖ ወክት ጥዘናችሰ ፈይታ እቅ፤ ዶሮረኖ ዱሩንኩ ፉለኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","መኒች ሩሃንየንከ ፉሽተን ዘህታ አይሁዲች መት-መቱ ቀርቾሃ ኢስ ሱዕመ ገእተን «ጳዉሎስ ዱዱብሰኖ ቀርቾ ኢስ ሱዕሚን ፉልቶኖተ አዘንዛንክዕኔ» ይተን መኒች ሩሃንየ ፉሽቶተ አጰንታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","አይሁድ ሎረ ቂሳች መቲሃስ አስቄዋ ዬኖሀኒሃ ህት አታ ለመል ለቤ እለት ሄኦስ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ጠዉ እኮጎሬ ዶሮረኖ ዱሩ ፈንቀሽ «ኢሰ ደጋም! ህትን ጳዉሎሴተኔሃ ደጋም፤ ህከረ አዕኑ አዬኤታን?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ዶሮረኖ ዱሩ አፎስ መንቹንኩ እሰንተ ኬዕይ አለግሽ ጉዕመንከሰ ቄል ጡላይሽ ኦድኑሰ ፊላን ከልሰ ምኒች ሁንት ፉልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ሁኩ ጠዉ ኤፌሶን ከተማን ሄኣ አይሁድለከ ግርክ መኒሃ ጉዕሚንከ ሞጮጨሞ ወክት አበ ዋጅቶኡ፤ ህከንቤቾንን ቀርቾ ኢስ ሱዕሙ ሎረ እኮ። ");
INSERT INTO alw_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","አመዕንቶ መኒች ልግቡሰ አሜት ሂለ ሆጎችሰ ቶበታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ህትን አስማእ አታሩ አስማእ መጻፈተ ጭምአት ጉዕማንከ ኡመት ብሬን ቡስቶኡ፤ መጻፉስ ህሬማ እቃን ፉሸኖ ጌሰ ገመቴኖ ወክት አበ ጤአተ እኮ ብረቲን መክሴመ ኦንታሁ ኩሜ ጠገር ብር ጌሰ እኮ። ");
INSERT INTO alw_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ህካን እኮቤቺሃ ቀርች ላገት አልባዕልተንለከ ነጵተን መርታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ሁኩን ጉዕሙንኩ እኮች ኤተሮን ጳዉሎስ ሜቄዶንለከ አካይ ባድ አዲን ህግ ዬሩሳሌም ከተመ መሮተ ጠሊለ አያኒን ሰውይኬእ «ህከ ቤቹ ኢሌምሀኒች ኤተሮን ህትን ሮም ከተመ መር ለኡ ሀስሰኖኤ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ጳዉሎሴ ሀዕልታሀኑኡች ለሙ ጥማቶሴለከ ኤራስጦሴ ሜቄዶን ባዱ ሶክ እስ ገዉስ እስይ ባዶን ቀዉ ጌሰ ዱንኬእ። ");
INSERT INTO alw_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ህከ ወክት ኢስ ዎቄተኔሃ ኤፌሶን ከተማን አቡ ብተት ኬኦኡ። ");
INSERT INTO alw_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ህከኔ ብረ ሽልስ መክሰኖ «ድሜጥሮስ» ዬኖ መቱ መንቹ «አርጤምሴ» ምኒሃ ምስለ ብሪን አሲሰን መክሳሀኑኡተ ልግብ ብረ ደእታገ አአኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ህካን እኮቤቺሃ እሲን ህከ ብረ አታ መነለከ ህትን ሆጉተ አታእረ ጭምአዕይ «ኮ መነ! ነኡ ብረ ደእናሚሁ ከን ሆጎን እሁስ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ህትን ኩ ጳዉሎስ መን አንጋን መኬ ምስለ ‹ሽርኬተበአ› የን ጠለዕል ኤፌሶን ከተማን እሁዕነ ቀዎ ባድ ቤሉ እስይ ባዶን ጉዕማንን ልግቡ መኑ አመዕነኖገ አኡስለከ ሉሲሱስ አዕኑን ገውንኩክዕኔ ለኤንታእሃለከ ሞጮጭቴንታእሃን። ");
INSERT INTO alw_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ህካን እኮቤቺሃ ጠለዕል ኒ ሆጉት ህንቀንቶኢተ እኩዕነ እስይ ባድ መኑ ጉዕሙንኩ ኣዱንያ አል መኑ ሰገደኖ ሎረ ‹አርጤምሴ› ዬኖ ሜኣ መገን ምኑ ኦነ እክ ፈቀኖ፤ ህትን እሴ ኬዕምኙሴ ሻረሞንከስበእንዶ?» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","እሰን ህካን ሞጮጭቶ ወክት አበ ኡሙዕርት «ኤፌሶን ከተም አርጤምስ ሎረታን» ይተን ያርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ህካን እኮቤቺሃ ኤፌሶን ከተማን ልግቡ ብተት እካን መቄዶን ባዲች አሜቶ ጳዉሎሴ ጃለተ ጋዮሴለከ አርስጣርኮሴ አፍ ጎሾሽተን ኡመቱ ጭምየኖ ቤቹ ሜጡበ እክ ደጉደን አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ጳዉሎስ ህከን ጭምዬ መንቤቹ መሮተ ሄዕላቾረ አሳበት ከንቶስ። ");
INSERT INTO alw_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","እስይ ባድ ገሻኖች ጳዉሎሴ ጃለተ እኮእሩ ጳዉሎሴቤቹ ሶክ መኑ ጭምዬ ቤቹ መረኖበእገ ኡጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ኡመትስ በላን አበ ብተት እኮቤቺሃ መቱ መቱርቹንከ ህትን ዎሉንገ ዎሉርቹ የን ያረኖት፤ እኮጎሬ ልግቡሰ ሚሃ ጭምይቶ ጎሬ ደጎበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","መት-መቱ አይሁድ አድሩ «አለክሰንድሬ» ዬኖ መንቹ ኡመት በሊች ሀንበልተን መን ብርተ ፉሽቶኡ፤ ኡመት በሊች መት-መቱሰ ጡመገ ኦዶሰተ ሸዞስ፤ አለክሰንድርን ኡመቱ ጨለ ዮተ አንገስ ቀቀሽ ኦደኖ ጠወ ጠወኦተ ቅጥዬእ። ");
INSERT INTO alw_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ጠዉ እኮጎሬ እስክንድር አይሁድቹ እሁስ እሰ ደጎ ወክት «ኤፌሶን ከተም አርጤምስ ሎረታን» ይተን ለሙ ሳኣት እሀኖ ጌሰ ጉዕሙንኩሰ ሜጡበ እክ ያርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ህትን ኤፌሶን ከተም ዋኑ ከተባንቹ ኡመት ሰዕምየኖገ አዕይ «ኤፌሶን ከተም መነ! ኤፌሶን ከተም መኑ ሎረ ‹አርጤምሴ› ሜኣ ሽርኬተ ሰገዴኖ ምኒለከ ሰሜች ድሬኢሃ ጠሊለ ክኑ አገርታእረ እሁሰ ጉዕመ ቤቾንን ደገሞኡ። ");
INSERT INTO alw_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ህካን እኮቤቺሃ ካን ለገአኖሁ ሄዕባሃ እሁስ ደጌንታች ሰዕምይዬ ቤሉ መቱርቹሃ ደዕልቴን አቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","መሰንትስ አዕኑ አርጥምሴ ምኒ ኦዳተ ሞግትበረለከ እሴተ ቦሮርትበ መነ አፌን ከቤቹ አሜቴንታአ። ");
INSERT INTO alw_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ህትን ዴሜጥሮስለከ እሲን ሜጡበ ብረ ሽልስ መክሰኖ መንቹ ዮ ጎሬ ኦዱን፤ ፈረዴኖ በሩለከ ኦዳገ አታ ዳኛኑት ህከኔ ዮቤቺሃ ኦዱን። ");
INSERT INTO alw_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","እኮጎሬ ዎሉ ሀሴነንተ ጠዉ ዮ ጎሬ ሕግ ኦገቴን ለኤኖ። ");
INSERT INTO alw_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ህካን እህበጎሬ ነኡ ‹ከበር እኮ ጠዊ ብተተ ኬሶእረ› ዬን ኦዴኖኔበእገ ዋጅናም፤ መሰንትስ ‹ኩ ብተት ኬኦኢሁ መርቹሃን› ዬን ጠዕሜመኔ ጎሬ ይናምርቹ ዮበአ» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","እስ ህካን ጠወዕዮች ኤተሮን ኦገቾ መኑ ብንየኖገ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ብተተ ኡርቶች ኤተሮን ጳዉሎስ አመዕናኑተ ሜጡበ ገእ ሸዥ «ወገሬቲን ሄዕዬ» ይ ሜቄዶን ባዱ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","እስን ህከን ባዲን ህገን አመዕናኑተ ልግቤ ሸዘናን ጠረኝሰን ግርክ ባዱ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ህከንቤቾንን ጳዉሎስ ሰሱ አገነ ዱንኬች ኤተሮን መርከባን ሶርይ ባዱ መሮተ ሰውዬእ፤ እኮጎሬ አይሁድ መኑ እስ አሌን ተንኩተ አቶተ ሰውይቶገ ደጎ ወክት ሜቄዶን ባዲን ህጎተ ሰውዬእ። ");
INSERT INTO alw_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","እሲን ሜጡበ ሄኦእሩ ቤርይ ከተም ጵርሁሴ ቤቱ ሶጳጥሮስ፥ ተሰሎንቄ ከተም መኒች አርስጥሮኮስለከ ስኮንዱስ፥ ደርቤ ከተሚች ጋይዮስ፥ እስይ ባድ ቲኪቆስለከ ጥሮፊሞስ ህትን ጢማቶስ እሳን ሜጡበ ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","እሰን ብርተ ህግ ጢሮኣድ ከተማን አገርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ጠዉ እኮጎሬ ነኡ ጦሮሹ እቴነን ከበጄኖ ከበጀቲች ኤተሮን ፍልጵስዩስ ከተመ መርከባን ኣንግ ኦንትቅ በር ጢሮአድ ከተመ እሰቤቹ ኢልኖም፤ ህከን ቤቾን ለመለ በር ዱንክኖም። ");
INSERT INTO alw_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ሳምንት ወዕኔ በሬን ጭምይኖምሀኔን ጳዉሎስ ለንክ በር ገስመ ዎሉቤቹ መረኖቤቺሃ ህከኔ ሄዕዮ መኒሃ ጠወኡ ጀመሮ፤ እስ ጠወስ ጠወአንን ሀንከዕሬ ሜሬሩ እኮ። ");
INSERT INTO alw_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ነኡ ጭምይኖም ፉቅ ምኔን ልግቡ መብራቱ ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ኤውጤኪስ ዬኖ መቱ ዎደልቹ መንቹ መስኮት አሌን አፉዕልዮ እቅ፤ ጳዉሎስ ጠወ ቅራርሴሃን ሁኩ ዎደልቹ አበ ግሾቤቺሃ ሰቅ ፉቂች ዎሮ ዋል ኡቦ፤ መኑ ኬሰኖ ወክት ሬዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ጠዉ እኮጎሬ ጳዉሎስ ድር ዎደልች አሌን ሙግይ አንጋንከስ ሀንቀፍ «ህልቆኖቼ ፎሊን ዮኡ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ጳዉሎስ ፉቅ አል ፈንቀል ፉል እሳንን እቸተ ሜጡበ እች ኡለት ሶዞተ ኢለ ኩሎች ኤተሮን ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ህትን እሰ ፈዬ ዎደልቹ ምኒ ኣእት መርት አበ ሙንደእ መት-መቱሰ ጠረኝሶኡ። ");
INSERT INTO alw_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ጳዉሎሴ ቶንግ ህርሲንሶተ ሄጭን መርከባን ኣንግ አሶሰ መርኖም፤ መሰንትስ እስ ህከ ከተመ ሎከ መሮተ ሀሽ ነኡ ህት አዕኖተ አዘዦኔቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ህትን ነኡ እሲን አሶስ ከተማን ደቀም እሱ ቶንግ መርከባን ኣግንስ ሚጢሊኒ ከተመ መርኖም። ");
INSERT INTO alw_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ነኡ ለንክ በር መርከባን ኣንግ ዊን ረበንቶ «ኪዮሴ» ዬኖቤቹ ኢልኖም፤ ህትን ለንክ በር «ሳሞሰ» መድን ህንግ ሰቅ በር ሚሊጢ ከተመ ኢልኖም። ");
INSERT INTO alw_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ጳዉሎስ እስይ ባዶን ልግብ ወክት ዱንኩዕነ ኤፌሶን ከተመ አጉር ህጎተ ሀሾ፤ መሰንትስ አታልሲሾስጎሬ ጴንጠቆስጤ ከበጃት ዬሩሳሌም ከተማን ከበጆተ ሀሾቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ጳዉሎስ ሚሊጢን ከተሚች መነ ሶክ ኤፌሶን አመዕናኖ ባልቀተ ገእሲሾ። ");
INSERT INTO alw_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","እሰን እስበ አሜቶ ወክት «አን እስይ ባዱ መር አፉዕሌም በሬች ጀመር ጉዕመ ወክትንከ በላንከክዕኔ ሀት እክ ሄዕዮምጎሬ አዕኑ ገዉክዕኔ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ህትን አይሁድ ሂለ ሰውት መሳን ኦርጨቀሞምጎሬ ጉዕመንከ አታለን ገውእ ሙግ አዕይ እንጅጀአን ቀርቹ ካደማም እቅ። ");
INSERT INTO alw_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ኦገትቤቾን እኮ ምኒች ምኒ ሃመን ተማርሳም ወክት ደግለለኖህዕኔሃ ጉዕመንከ ኩሎንክዕኔ ቤሉ መቱርቹሃ ኩሉዕነ ፌሾምበአ። ");
INSERT INTO alw_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","አይሁድ መኑለከ ግርክ መኑ ጩብችሰ ቶበት መገን አደ ፈንቀልት ቀርቾ ኢሳን አመዕንቶተ ኩሎንሰ። ");
INSERT INTO alw_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ጠሊለ አያኒን አዘዘም ዬሩሳሌም ከተመ መራሚት፤ ህከን ቤቾን መ እሀም ጎሬ ደጎምበአ። ");
INSERT INTO alw_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ጠዉ እኮጎሬ ኡሱረሙለከ ኦርሸት እልታኤገ ከተማን ጉዕማንን ጠሊሉ አያኑ ኩሎኤ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","እኮጎሬ አን ቀርቾ ኢሲች ቶጎም ሆጉተ ሹሎተ ኢለ ገይኤ ፎሊሃ አሙዛምበአ፤ እስን መገን ኣስቱተ ተሽት ላገተ ኩሉሃን። ");
INSERT INTO alw_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«ህትን ከበሬ ኢሎተ ኢለ ክዕኔ ጉዕምክዕኔ በላን ፈንቀላመን መገን ዎምነትተኔሃ ተማርሳንክዕኔ፤ ከኒች ኤተሮን ክዕኔ በሊች አዪሁ ለአኖኤበእገ ደጋም። ");
INSERT INTO alw_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ህካን እኮቤቺሃ ክዕኔ በሊች መቱ መንቹ በዕዮ እቃ ሩበት እሀንክዕኔበእገ ኩላንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","መሰንትስ መገን ሰዉት ጉዕመንከ ኩሎንክዕኔ ቤሉ ኩሉዕነ ፌሾምርቹ መቱርቹሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","መገኑ ገይስ ቤት ቄጊን ዎዦህዕኔ አመዕናኖ ጭምት አገርቶኖተ ጠሊለ አያኒን ክዕኔተ ዜማንቹ አዕይ መጠሮህዕኔ መገን ሆለ ዜሜሃለከ ገይሃክዕኔ አገዕርዬ። ");
INSERT INTO alw_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","አን ኦሮዕዮሚች ኤተሮን መገን ሆለ ዜሜሃ አሙዝቡ ሆሌገ ጎደበ ጠረኛኑት ሂሉ መኑ አሜት ክዕኔ በለ ኣጋገ ደጋም። ");
INSERT INTO alw_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ህትን መት-መቱ መኑ ክዕኔ ገይክዕኔ በሊች ኬእ ሉሲሰኖ ትምርት ተማርስተን ልግብ አመዕናኑተ እሰ አደ ፈንቀሽታአ። ");
INSERT INTO alw_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ህካን እኮቤቺሃ አን ጉዕማንከ መኒሃ ሀንከዕርተለከ በራሃ እንጅጃተ ዱነን ሰሱ ዘማን ሸዦንክዕኔገ ቃጌነን አገዕርዬ። ");
INSERT INTO alw_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«ህትን ቴሁ መገኒሃለከ ጉዕመንከ ጠሊላኖ በላን ጠረኝሰኖህዕኔ መገን ርስተ ኣሶተ አታለኖ ኣስቶ ላጋተ ኤገተ ኣስዮንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","አን አዬ ብረ ህከረንገ ዎርቀ ህከረንገ ኦድኑተ ሄዕላቾምበአ። ");
INSERT INTO alw_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ኤሳሃለከ ኢን ሜጡበ ዮሀኑኡተ ሀስሰኖርቹ አንጋንከኤ አአን ደግለሎምገ አዕኑ ገዉንኩክዕኔ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","‹ኣአኖሀኒች በትሽ ኣሰኖሁ ማሰአሞእሃን› ዬ ገይስ ቀርቾ ኢስ ላገተ ቃጊን አንጋንከኔ አዕነን ሆጎሀኑኡተ ደግለሉ ሀስሰኖ እሁስ ልግብያ ዎቄን ለሊሾንክዕኔ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ጳዉሎስ ህካን ጠወዕዮች ኤተሮን ጉዕሚንከሰ ጉሉጵ ዱአ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","እሰ ጉዕሙንኩሰ ኦአን ጳዉሎሴ ሀንቀፍ ሱንቅቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","በትስ አበ ሻዞ መሰት «ከኒች ኤተሮን ለንኪሃ እልኤ ለኦኖተ ሆሮን አታልቴነንተበአ» ዬሰቤቺሃት እቅ፤ እሰን መርከቡ ዮ ቤቹ ኢሎተ ኢለ ህርሲሶስ። ");
INSERT INTO alw_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","እሳች መለዕለሞሚች ኤተሮን መርከባን ኣንግ ጌጥይን «ቆስ» ዬኖ ባዱ መርኖም፤ ህትን ለንክስ በር ዊን ረበንቶ «ሩደ» ኢልኖም፤ ህከንቤቺች ኬዕን «ጳጥራ» ዬኖ ከተመ መርኖም። ");
INSERT INTO alw_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ህከን ቤቾን ፍንቄ ባዱ ኦሮአኖ መርከበ ደእን እሲን ኣንግ መርኖም። ");
INSERT INTO alw_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ዊን ረበንቶ «ቆጵሮሰ» ዬኖ ኡለተ ለእን ጉረ አዲን አጉርን ሶርይ ባዱ መርን «ጥሮሰ» ዬኖ ከተመ ኢልኖም፤ ሁኩ ቤቹ መርከቢች ኦደተ ድሪሴኖሃ ቤቹ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ህከን ቤቾን አመዕናኑተ ሀንስ ደንጎም ወክት እሰቤቾን ለመለ በር ዱንክኖም፤ እሳንከ ጠሊሉ አያኑ ለሊሻንሰ «ጳዉሎሴ! ዬሩሳሌም ከተመ መርቶት» ይት ኩልቶስ። ");
INSERT INTO alw_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","እኮጎሬ ነኡ ህከን ቤቾን አገርናም ወክቱ ጎፋን ሃሞተ ኬዕኖም፤ እሰ ጉዕሙንኩሰ ሜንቲንከሰለከ እላንተሰ ሜጡበ ከተሚች አብል ኢሎተ ኢለ ህርሲሶኔ፤ ባር መዴን ጉሉጵን ዱአ አዕኖሚች ኤተሮን «ወገሬት ሄዕዬ» ይን አደ እንኮም። ");
INSERT INTO alw_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ህከኒች ኤተሮን ነኡ መርከባን ኣንጎም፤ ህትን እሰን ምንሰ ፈንቀልት መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ነኡ ጢሮሲች ኬዕን «ጴጤሌማይስ» ዬኖ ከተመ ኢልኖም፤ ህከን ቤቾን አመዕናኖን ደቀም ወገሬትጨቀሞሚች ኤተሮን እሳን መቱ በር አገርኖም። ");
INSERT INTO alw_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ለንክስ በር እሳች መለዕለሞሚች ኤተሮን ቄሳር ከተመ ኢልኖም፤ ህከኔን መጠረንቶ ለመላ ዳቆናች «ፍልጶሴ» ዬኖ መንች ምኒ ኣንግ እሲን ሜጡበ አፉዕልኖም፤ ፍልጶስን መገን ላገተ ተማርሰኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","እሲንከ ራገ ጠወኣ ሾልት ሀፍታኑት ሄኦስ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ህከን ቤቾን ልግብ በር አፉዕልኖሚች ኤተሮን «አጋቦሴ» ዬኖ ነብዬቹ ይሁድ ባዲች አሜቾ። ");
INSERT INTO alw_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ሁኩ ነብዬቹ ኒቤቹ አሜች ጳዉሎሴ ኢቱተ ኣእ ገይስ ሎከተለከ ገይስ አንገተ ኡሱር «ጠሊሉ አያኑ ‹ከን ኢቶ መንቹ ዬሩሳሌማን ዮ አይሁዱ ህት ኡሱርት አይሁደ እህበ መን አንጋን ህግስ ኣታአ› የኖት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ህከ ጠወ ሞጮጭኖም ወክት ነኡለከ ህከኔ ሄኣ መኑሁ ጳዉሎሴ «ዬሩሳሌመ መርቶት» ይን ኡጭኖም። ");
INSERT INTO alw_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","እኮጎሬ ጳዉሎስ «ህት ኦኤነን ኢ ቀልብ ሚ ዶርቴነንታት? አን ቀርቾ ኢስተኔሃ ዬሩሳሌማን ኡሱረሙ እሁዕነ ሬሆታ ቅጥ ይዮም» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ጳዉሎስ ሸዘነኔ ቶጉ ግቦ ወክት «ቀርቹ ዬኢሁ እሁን» ይን አጉርኖም። ");
INSERT INTO alw_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ህከኒች ኤተሮን ነኡ ኦዳኔ ቅጥ አዕን ዬሩሳሌመ መርኖም። ");
INSERT INTO alw_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ህትን ቄሳር ከተማን ዮ አመዕናኑት መት-መቱ ኒን ሜጡበ እክ አሜቶኡ፤ እሰን ምናሶኔ ምኔን ፎሎጭኖተ እስ ምኒ መስቶኔ፤ ሁኩ መንቹ ዊ በላን ዮ «ቆጵሮሰ» ዬኖ ባዶን ዱንክዮእሃ አመዕናንቹ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ነኡ ዬሩሳሌመ ኢልኖም ወክት አመዕናኑት ሙንዲኖን ቶጎኔ። ");
INSERT INTO alw_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ለንክስ በር ጳዉሎስ ኒን ሜጡበ እክ ያቁብቤቹ መርኖም ወክት ጉዕሙንኩ ጭምት ምኒ ባልቁ ህከኔ ሄኦ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ጳዉሎስ እሰንተ ወገሬትሾች ኤተሮን መገኑ አይሁደ እህበ መን በላን እስ ክድማን አዕዮሃ መት-መቲን ኩሎሰ። ");
INSERT INTO alw_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","እሰን ህካን ሞጮጭት መገኑ ገለትጭት «ኒ አመቤቶ ጳዉሎሴ! አመዕንቶ ልግቡ ኩሜ መኑ አይሁድ በላን ሄኡሰለከ ጉዕሙንኩሰ ሕጊሃ አዘዘንታኢሃ እሁስ አትን ደጋንት። ");
INSERT INTO alw_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","እሰን አት ‹አይሁደ እህበ መን በላን ሄኣ አይሁዲ ጉዕሚንከ እለሰ ጡርከንትበገለከ ሴረ አገርትበገ ተማርስተን ሙስ ሕገ ሻርታገ አታንቲት› ዬኖ ጠወ ሞጮጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ህከረ መ አዕኑ? እሰ አት አሜቱክ ሀንቅንከ ሞጮጭታአ። ");
INSERT INTO alw_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ህካን እኮቤቺሃ ነኡ ይናሚሃ አእ፤ ኒ በላን ሁንዱር ኣጎ ሾሉ መኑ ዮኡ። ");
INSERT INTO alw_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ከ መነ ኣእት መርት እሳንን መገን ብሬን ገዉክ ነጠ አእ፤ እሰን ነጠ እኮተ ብረ አት ባትሰ፤ ህከኒች ኤተሮን ሙምሰ ሜዳኣ፤ ህካን አቶንትጎሬ ኪተኔሃ ጠወአሞ ጠዉ ክዝብ እሁስለከ አት ገዉክ ሕገ አገርተን ሄኣንትገ ጉዕሙንኩሰ ደጋአ። ");
INSERT INTO alw_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","እኮጎሬ አይሁደ እህበ መን አዲች አመዕንቶእሩ ክትም ክትንታን ንጃሾ እቸተ እታንትበእገ፥ ቄጉ አጋንትበእገ፥ ለንገእ ሬዮ ለል ማላ እትበገለከ ዝነተ አትበገ አገዕርቶተ ኢተቀሞም ጠወሃ ደብዳቤን ከተንቦክዕኔ» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ህከኒች ኤተሮን ጳዉሎስ ለንክ በር ህከ መነ ኣእ እሳንን ሜጡበ ነጠ እኮ፤ እስን ሁኩ መኑ ሄንኩ በሩ ኢሎተ ኢለ ነጠ እክ አገርታጎሬ ህትን ገገዉሰ ኣታ ሰደቀተ መ ወክት ኣታጎሬ ኤንኬዕንሶተ ዱእ ምኒ ኣጎ። ");
INSERT INTO alw_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ለመሉ በሩ ጎፎተ እካን እስይ ባዲች አሜቶእሩ አይሁዱ ጳዉሎሴ መገን ምኔን ለእ ኡመት ጉዕመንከ አድመተ አት አፎስ። ");
INSERT INTO alw_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","እሰን «እስራኤል መነ! ሀዕልዬኔ! ከለዕዬ ኩ መንቹ ኡመትኔ፥ ሕገኔለከ ዱእ ምኒ ጥቅሽ ጉዕመንከ ቤቹ መረን ኡመት ተማርሰኖሃን፤ ሁኩንን ሆፈዕያንስ ግሪክ ባድ መነ ዱእ ምኒ ኣግሽ ፈየ እኮቤቹ ንጃስሾእሃን» ይት ያርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","እሰን ህካን ይቶኢሁ ሄጭት ጳዉሎሴ ኤፌሶን ከተም ጥሮፊሞሴንን ሜጡበ እክ ዬሩሳሌም ከተማን ዮኢሃ ለኦስቤቺሃ እሱ ዱእ ምኒ አፍ ኣጎሃ አጉጆሰቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ከተሙስ ጉዕሙንኩ ሌንቄቄእ፤ ህትን መኑ ጉዕሙንኩ ሜጡበ እክ ደጉደን አሜት ጳዉሎሴ ኣእት ጎሾሽተን ዱእ ምኒች አብል ፉሽቶስ፤ ህከ ወክትንከ ዱእ ምኒ ኡሩት ጡፈንቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ህትን እሰ ጳዉሎሴ ሽቶተ ሀሶ ወክት ሮም ባድ በገዝ ሀለቂሃ «ዬሩሳሌም ከተሙ ጉዕሙንኩ ጨነቀንቶኡ» ዬኖ ዱዱቡ ሞጮጨሞ። ");
INSERT INTO alw_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","እስን ህከ ወክት ወታደረለከ ጥቤ ሀለቀ ኣእ ደጉደን መንቤቹ ኢሌእ፤ ሁኩ ጳዉሎሴ ኦልታእሩ በገዝ ሀለቀለከ ዎታደረ ለኦ ወክት ዎቀሩ አጉርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ህከ ወክትንከ ሀለቁ ኢል ኬዕይ ጳዉሎሴ አፍሲሽ ለሞ ሰንሰለቲን ኡሱሬኖገ አዘዥ «ኩ መንቹ አዬት? ህትን መርቹሃን አዕዮሁ» ይ ጠዕሜእ። ");
INSERT INTO alw_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","መኒች ደሩስ መቱርቹ ደሩስ ህትን ዎሉርቹ ይተን ጨንጭቶቤቺሃ በገዝ ሀለቁ ሀንቅ እኮ ጠወ ደጎተ አታሉ ሆጎ ወክት ጳዉሎሴ ዎታደር ቀእተ መስታገ አዘዦ። ");
INSERT INTO alw_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ህከቤቹንከ መሴነን ጳዉሎስ አል ፉሌኖ ቤቹ ኢሌ ወክት ኡመቱ አበ ኡሙዕር እስ አሌን አደገ ኢልሶተ ሀሶገ ደግ ዎታደሩ እሱ እጅት መስቶስ። ");
INSERT INTO alw_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ሁኩ ልግቡ ኡመቱ «ሽዬ» ይተን ጨንጭተን ዘክሳሲት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ጳዉሎሴ ዎታደሩ ገልታቤቹ ኣግሶተ ሆንጠኮ ወክት ጳዉሎስ በገዝ ሀለቀ «አን መቱርቹ ኩሎሄተ ፈቀደዕኔንዶ?» ዬእ፤ ሁኩ በገዝ ሀለቁ «ግሪክ ባድ አፎሃ ደገንንዶ? ");
INSERT INTO alw_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ግደኖ በሬን ብተተ ኬስለከ ሾሎ ኩሜ ሽብር ኬሶረ ኣእት ኡለ ኡድመ ሁንቶንቲ ግብጽ ባድ መንቹ አቴበእንዶ?» ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ጳዉሎስ በገዝ ሀለቀ « ‹ኪልቅየ› ዬኖ ባዶን ኤንኬዕነንቶ ጠርሴስ ከተማን እለሞምየ አይሁድቹ፤ ሀዕይ ኡመቲሃ ጠወኦተ ወክት ኣሴኤ» ይ ኡጬስ። ");
INSERT INTO alw_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ህትን እስ ጠወኦተ ወክት ኣስያንስ ጳዉሎስ ጎትዬ ቤቾን ኡር መኑ ሰዕምዮተ አንጋንተስ ቀቀሽ መኑ ጨለ ዬ ወክት እብራዌ መን አፎን መኒሃ ጠወኡ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","ጳዉሎስ «አመኤ ኦሱትለከ አናከኤ አን ኣሳንክዕኔ መስለ ሞጮጭዬ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","እሰን እስ እብራዌ መን አፎን ጠወአን ሞጮጭቶ ወክት ወዕኔችን በትስ ጨለ ይቶኡ፤ ");
INSERT INTO alw_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","እስን «አን ኪልቅይ ባዶን ዮ ተርሴስ ከተማን እለሞምሃ አይሁድቹ፤ ተማሮሚሁ ከን ዬሩሳሌም ከተማኒት፤ ተማርሴኤሁ ገማልያሌት፤ እሲች አናከኔ ሕገ ጠረኝሽ ተማሮሚሁለከ ከበር አዕኑ ጉዕሙንኩ ደጌነንተገን መገኒሃ ቡብ ገዉእ ኣስ ካደማሚሃ መንቹ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ኢስ ዎቃሃ አዎንታ መነ ጉዕመንከ ሬታኢሃ ኢለ ሸረን ጎነለከ ሜንቱ አፈን ኡሱር ምኒ ኣግሾምሃ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ኩን ሀንቅ እሁስ ቂስ አዎንሳኑትለከ አይሁድ ኦገት ባልቀት ጉዕሙንኩ ኤሳሃ ምስክረተ፤ ደማስቆ ከተማን ዮ ህከ መነ ኡሱር ዬሩሳሌመ ኤቦተለከ ቀጠእሲሶተ አታልሲሰኖኤ ደማስቆን ዮ አይሁዲሃ ከተቦ ደብዳቤተ ቶጎሚሁ እሳችት። ");
INSERT INTO alw_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«አንን ደማስቆ ከተመ መረን ኢሎተ ሆንጠኮምሀኔን መቱ በር ሌሆ ሰኣት ጌሳን ድንገቴን ሰሜች ሎሩ ኑሩ አዳንከኤ በለቆ። ");
INSERT INTO alw_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ህትን ኡለ ኡብ ኤሳሃ ‹ሳኦሌ! ሳኦሌ! ሚሃት ሸርታንቴኤት?› ይታ ላገት ሞጮጬም። ");
INSERT INTO alw_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","አንን ፈንቀሽ ‹ቀርቾ አት አዬት?› ዬም፤ እስን ‹አት ሸርታንቴኤ ናዝሬት ኢሳት› ዬኤ። ");
INSERT INTO alw_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ኢን ሜጡበ ሄኦእሩ ኑርስ ለኦ ቤሉ አይ ጠወአኖኤት ጎሬ ላገስ ሞጮጭቶበአ። ");
INSERT INTO alw_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","አንን ‹ቀርቾ! መ አኡ?› ዬም፤ ቀርቹንኩ ‹ኬእ ደማስቆ ከተመ መር፤ አታንቲሁ ጉዕሙንኩ ህከን ቤቾን ኩለመኖሄ› ዬኤ። ");
INSERT INTO alw_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ህከን ኑር በለቅ መሳን ለኦተ አታሉ ሆጎምቤቺሃ ኢን ሜጡበ ሄኦ መኑ አንገኤ አፍ መሰግ ደማስቆ ከተመ ኢልሶኤ። ");
INSERT INTO alw_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«ህከን ከተማን ‹ሀናንየ› ዬኖ መቱ መንቹ ሄዕዮ እቅ፤ ህከ መንቹንከ ደማስቆ ከተማን ሄኣ አይሁዱ ጉዕሙንኩ ገለትጭታሲሁ ሕገ ጡመገ አገረኖለከ አያኑ ዮስየ መንቹ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","እስን ኢቤቹ አሜች መዴንከኤ ኡር ‹አመኤ ቤቶ ሳኦሌ! ቴሱ ለእ› ዬእ፤ አንን ህከ ወክትንከ ለኦተ አታሎም። ");
INSERT INTO alw_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","እስን ‹አናከኔ መገን ሰዉት አት ደጎተ፥ ፈየ ለኦተለከ ላገስ ሞጮጭቶተ ሄጭ መጠሮሄ። ");
INSERT INTO alw_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","እስን ለኦንትለከ ሞጮጭቶንት ጠወ ጉዕመንከ መን ብሬን እስተኔሃ ምስክር እኮታት። ");
INSERT INTO alw_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ህከረ መ አገርታንቲት? ቴሱ ኬእ ሱዕመስ ገእት ጠመቀም፤ ጩብችክ ነጠ እህ› ይ ኩሎኤ። ");
INSERT INTO alw_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«ህከኒች ኤተሮን ህከ ዬሩሳሌመ ፈንቀል አሜቾሚች ኤተሮን መገን ምኔን ዱአ አአን መናመተ ለዕዮም። ");
INSERT INTO alw_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ቀርቹንኩ ኤሳሃ ለልኤ ‹አት ኢተኔሃ ጠወኣንት ጠወሃ እሰ ቶጋበእቤቺሃ ዬሩሳሌሚች ደዕልት ፉል› ዬኤ። ");
INSERT INTO alw_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","አንን ቀርቾ! ‹ጭምት ምኒ ጉዕመንከ መረን ኪን አመዕኔ መነ ኦላምገለከ ኡሱራምገ እሰ ገዉንኩሰ ደጋአ። ");
INSERT INTO alw_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ኬሳሃ ምስክር እክ ሄዕዮ እስጥፋኖሴ ቄጉስ ዱንቶ ወክት አን ጠዋንከስ ኢተቀም ሽታ መን መዴን ኡር ኦድኑሰ አገራም እቅ› ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ቀርቹንኩ ‹ቄዕራሸ ዮ አይሁደ እህበ መንቤቹ ሶሃንኬቤቺሃ ከንቤቺች ኬእ ኦሮእ› ይ ኩሎኤ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","እስ ከ ጠወ ኩሎተ ኢለ ሞጮጭታሲት እቅ፤ እሰ ላገሰ ጎት አት «ህትናሙ መንቹ ፎሊን ሄኡ ሀስሰኖስበእቤቺሃ ዱንየ አሊች ከም» ይት ያርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ህትን እሰን ያርተን ኦድኑሰ ኡጅተን ትበ ሰማ ዋሽት ብን አታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","በገዝ ሀለቁንኩ ጳዉሎሴ ወታደሩ ገልታቤቹ መስታገ አዘዦ፤ ህትን እስ አሌን መኑ ሚሃ ጨንጨኖጎር ደጎተ «ኦልቴነን መረመሬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ጠዉ እኮጎሬ እሰ ጠፍሪን ጠረኝስ ኡሱርቶ ወክት ጳዉሎስ መዴንከስ ዮ ጥቤ ሀለቅቹ «ሮም መንቹ ፍርዱ ዮበኢሃ ኦልቶኖተ ፈቀደሞህዕኔንዶ?» ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ህከ ወክትንከ ጥቤ ሀለቁ ሞጮጭ በገዝ ሀለቅቤቹ መር «መ አቶታት? ኩ መንቹ ሮማውቹሃ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ሁኩ በገዝ ሀለቁንኩ ጳዉሎሴቤቹ መር «ህንዴ ኩሌኤ! አት ሮማውቹሃ መንቹንዶ?» ይ ጠዕሜስ፤ እስን «ኤ! አን ሮማውቹሃ መንቹ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","በገዝ ሀለቁንኩ ፈንቀሽ «አን ከ ሮማውቹ እሆተ ህዕሬሚሁ አበ ብሪንት» ዬስ ወክት ጳዉሎስ ህትን «አን እለሞሚሁ ሮማውቹ እክት» ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ህካን እኮቤቺሃ ጳዉሎሴ መረመርቶተ ቅጥይቶሩ ህከ ወክትንከ እሲች አደ እኮኡ፤ በገዝ ሀለቁንኩ ጳዉሎስ ሮም ባድ መንቹ እሁስ ደጎ ወክት ኡሱርሲሾስቤቺሃ ዋጄእ። ");
INSERT INTO alw_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ለንክ በር ገስመ በገዝ ሀለቁንኩ አይሁዱ ጳዉሎሴ ከሰሶ መሰት መርቹሃጎሬ ጠውስ ሀንቅ ደጎተ ሀሾቤቺሃ ቂስ አዎንሳኑትለከ ኦገት መነ ጉዕመንከ ጭምይታገ አዘዦ፤ እስን ጳዉሎሴች ሰንሰለተ ሂር ኡሱሮ ምኒች ኤቤኖገ አዕይ ብሬንከሰ ኡርሾ። ");
INSERT INTO alw_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ህከኒች ኤተሮን ጳዉሎስ አይሁድ ኦገት ባልቀተ ቱክ ይ ለዕይ «አመኤ ኦሶ! ከበሬ ኢሎተ ኢለ ጡመ ቀልቢን ጉዕሚንን መገን ብሬን ሄዕዮምሃን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ህትን ሎሩ ቂስቹ «ሀናንየ» ዬኖሁ ጳዉሎሴ መዴን ኡርቶእረ ጳዉሎሴ አፎስ ዎቀርታገ አዘዦ። ");
INSERT INTO alw_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ህከ ወክትንከ ጳዉሎስ ሀናንየ «አት ለኤኖሄረ ጡመ አጉዳንቲሁ ቀልቡክ ሂሉ! ኬሳሃ መገኑ ዎቀረኖሄ፤ ሕጊን ፈረዶተ አፉዕልት ሕጉ ዮበኢሃ ዎቀሮኖኤተ አዘዘንዶ?» ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ህከኔ መዴንከስ ኡርቶእሩ ጳዉሎሴ «መገን ሎረ ቂስቹ ቦሮርተንንዶ?» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ህትን ጳዉሎስ ፈንቀሽ «አመኤ ኦሶ! ሎረ ቂስቹ እሁስ ደጎምበአ እቅ፤ መሰንትስ ‹ኡመትክ ገሸኖሀን አሌን ሂለ ላገተ ጠወኦት› የመም ከተበሞኡ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ጠዉ እኮጎሬ ጳዉሎስ ህከን መኒች መት-መቱሰ ሰዱቃውተ ህትን ዎሉሰ ፈርሳውተ እሁሰ ደግ «አመኤ ኦሶ! አን ፈርሳውቹሃን፤ አኑኤ ፈርሳውቹሃን፤ ቴሱ ፍርድቤቹ ሆንጠኮሚሁ ሬቶእሩ ሬሆች ኬኣገ ተብሳሃ አዕዮምቤቺሃት» ይ ላገስ ጎት አዕይ ኦገት ባልቃተ ጠወዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ጳዉሎስ ህካን ጠወዕዮ ወክት ፈርሳዌለከ ሰዱቃዌ በላን ብተት ኬኣን ኦገቱስ ለሙ ቤቹ እኮ። ");
INSERT INTO alw_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ሰዱቃውት «ሬዮ መኑ ሬሆች ኬአኖበአ፤ መላይከንት ዮበአ፤ አያኑንኩ ዮበአ» ይታእረ፤ ህትን ፈርሳውት «ሁኩን ጉዕሙንኩ ዮኡ» ይት አመዕንታእረ። ");
INSERT INTO alw_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ህከ ወክት አበ ጨንጨነተ እኮ፤ ፈርሳዌ አዲች መገን ሕግ አስተማራች ኬእ «ነኡ ከን መንቾን ሂለ ጠወ መቱርቹሃ ደንጎምበአ፤ አያኑ ህከረንገ መላይከት ጠወኦሲሃ እሀኖ?» ይት ኦዶኡ። ");
INSERT INTO alw_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ብተት በተአን መርቶ ወክት መኑ ጳዉሎሴ ሀንፈጣስበእገ በገዝ ሀለቁ ዋጅ ወታደረ «መርቴን ጳዉሎሴ መን በሊች ዎልቅሴን ዎታደሩ ገለኖቤቹ ኤቤ» ይ አዘዦ። ");
INSERT INTO alw_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ለንክስ በር ሀንከዕርተ ቀርቹ ጳዉሎሴ መዴን ኡር «ዬሩሳሌም ከተማን ኢተኔሃ መሰከርቶንትገን ሮም ከተማኒ መሰከሩ ሀስሰኖቤቺሃ ዋጅቶት» ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ለንክ በሬ ገስመ አይሁዱ ጭምይት አማዕለንትኬእ «ጳዉሎሴ ሽኖተ ኢለ እቸተ እንቱንከ፤ ዋሃ አንጉንከ» ይት ጤሌዕልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ህከን አድማን አማዕለንቶእሩ ሸይልች በተአኖሃ መነ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ህትን እሰ ቂስ አዎንሳኖበለከ ባልቀቤቹ መርትኬእ « ‹ጳዉሎሴ ሽኑዕናን መቱርቹሃ እንታምበአ› ይን ጤሌዕልኖም። ");
INSERT INTO alw_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ህከኒሃ ቴሱ አዕኑ ኦገት ባልቃን ሜጡበ አማዕለንቴን መረመርናም ጠዉ ዮኡ ይቴን ጳዉሎሴ ኦል ሀለቁ ክዕኔቤቹ ኤቦተ ጠዕምዬ፤ እኮጎሬ ነኡ ክዕኔቤቹ ኢሉዕነ ሄጭን ሽኖተ ቅጥይኖም» ይት ኩልቶሰ። ");
INSERT INTO alw_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ጠዉ እኮጎሬ ጳዉሎሴ አመቤቶ ቤቱ ህከ አማዕለንቶ ጠወ ሞጮጬ ወክት ዎታደሩ ገልታቤቹ መርኬዕይ ጳዉሎሴሃ ኩሎስ። ");
INSERT INTO alw_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ህትን ጳዉሎስ ጥቤ ሀለቀ መቱ ገእ «ኩ ጩሉ በገዝ ሀለቂሃ ጠወአኖ ጠዉ ዮስቤቺሃ እስቤቹ መስ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ጥቤ ሀለቅቹንኩ ጩልስ በገዝ ሀለቅቤቹ አፍ መር «ኩ ጩሉ ኩለኖ ጠዉ ዮስቤቺሃ ኡሱር ምኔን ዮ ጳዉሎሴ ኤሳሃ ገእ ከ ጩል ኪቤቹ ኤቦተ ኡጭዮኤ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","በገዝ ሀለቁንኩ ጩል አንገተ አፍ መድ ዋል «ኩልታንቴኤ ጠዉ መርቹሃን?» ይ ገበለ ዋሽ ጠዕሜስ። ");
INSERT INTO alw_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ሁኩ ጩሉንኩ «አይሁድ አዎንሳኑት ጳዉሎሴ ዎዕኔችን ባሳ ጠረኝስ መረመርቶተ ጋቴተ ኦገትቤቹ ሆንጠህሶተ ኬሳሃ ጠዕምቶተ ኢተቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ጠዉ እኮጎሬ አት እሳሃ ኤኩ ይቶት፤ መሰንትስ እሰ ጳዉሎሴ ሽቶተ ኢለ እቸተ እታበእገለከ ዋሃ አጋበእገ ጤሌዕልት ሸይልች በተአ መኑ ማጠንት አገርታኢት፤ ቴሱ እሰ አገርታኢሁ ጠለዕል ኪ መስለህት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","በገዝ ሀለቁንኩ ህከ ጩል «ከ ጠወ ኤሳሃ ኩሉክ አዬሃ ጠወኦት» ይ ጩል ህርሲሾ። ");
INSERT INTO alw_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ህከኒች ኤተሮን ኦል ሀለቁንኩ ጥቤ ሀለቃች ለሙ ገእ «ሀንከዕሬ ሰሶ ሳቴን ቂሳር ከተመ መርታ ለሜ ጥቤ ዎታደረ፥ ለመላዩ ፋሻንቹለከ ለሜ ጥቤ በገዝ መነ ቅጥአዕዬ። ");
INSERT INTO alw_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ህትን ጳዉሎስ ቆጰኖ ገማሙ ቅጥ አቴን ባዱ ገሸኖ ፍልክሴበ ወገሬቲን ኢልሳስገ አዕዬ» ይ አዘዦ። ");
INSERT INTO alw_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","26","ህትን እስን «ቀላዶስ ሉስዩሲች፤ አበ ከበጀንቶንት ባዱ ገሽታንት ፊልክሴ! ወገሬቱ ኬሳሃ እሁን! ");
INSERT INTO alw_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ከ መንቹ አይሁዱ አፍ ሽቶተ እከንን እስ ሮማውቹ እሁስ ደጎምቤቺሃ ዎታደርንከኤ መር ኢል ጡምሾንስ። ");
INSERT INTO alw_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ህትን እሰን እሱ መ መሳን ከሰሳስጎሬ ደጎተ ኦገትሰቤቹ ሆንጠህሾም እቅ። ");
INSERT INTO alw_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","እሰን እሱ ከሰሶኢሁ ገይሰ ሕግተኔሃ እሁስ ደጎም፤ ጠዉ እኮጎሬ ሬሆተ ህከረንገ ኡሱረሚሃ ኢልሰኖ ጠዉ መቱርቹሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","አይሁዱ ከ መንቹ ሽቶተ አድመተ አት አማዕለንቶገ ህከ ወክትንከ ሞጮጭ ኪቤቹ ሶኮም፤ ኦደን ሄኦ መኑንኩ ኪ ብሬን ኦዳገ አዘዦም» ይ ሶኮ። ");
INSERT INTO alw_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ህካን እኮቤቺሃ ዎታደሩ አዘዘንቶ ሃሌን ጳዉሎሴ አፍ ሀንከዕሬን መስት «አንቲጳጥርስ» ዬኖ ከተመ ኢልሶኡ። ");
INSERT INTO alw_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ለንክ በሬ ገስማ ጳዉሎሴ ፋርሱተ ቆጶ መኒን ሜጡበ መረኖገ አት ወታደሩ አጉርት ገልታቤቹ ፈንቀልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ሁኩ ፋርሱተ ቆጶ መኑንኩ ቂሳር ከተመ ኢልሶ ወክት ደብዳቤተ ባዱ ገሸኖሀኒሃ ኣት ጳዉሎሴ ብሬንከስ ኡርሶኡ። ");
INSERT INTO alw_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ባዱ ገሸኖንኩ ደብዳቤተ አነበቦች ኤተሮን ጳውሎሴ «አት ሀከን ባድየ?» ይ ጠዕሜስ፤ ኪልቅይ ባድ መንቹ እሁስ ደጎ ወክት ");
INSERT INTO alw_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","«ከሰሳሄሩ አሜቶ ወክት ጠወክ ሞጮጫም» ዬስ፤ ህትን ሄሮድስ ግንብሲሾ ዎም ግቤ ኣዜን አገርታስገ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ኦንቶ በሬች ኤተሮን ሎሩ ቂስቹ ሀናንይ መት-መቶ ባልቃንለከ «ጠርጠሉሴ» ዬኖ ጠበቂን ሜጡበ ቄሳር ከተመ ኦሮዕዮ፤ እሰ ጳዉሎሴ ጠወ ባዱ ገሸኖ ፊልክሴ ብርተ ሆንጠህስ ከሰሶኡ። ");
INSERT INTO alw_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","3","ህትን ጳዉሎሴ ገኤን ኤቤመ ወክት ጠበቅቹ ጠርጠሉስ «ከበጀንቶንት ፊልክሴ! ኪ መሳን ልግብ ወገሬት ደእኖም፤ ጡመገ ገሽንተክ ገይሃኔ ሃዕሮ ጡመርቹ ደእኖም፤ ጡመ ሆጉክ ጉዕመ ወክት ቶንጋሚሁ አበ ገለትኒት። ");
INSERT INTO alw_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ጠዉ እኮጎሬ ወክትክ ቤሱዕናን ገበንቾን ኩላንኬ ጠወ መረርሲጭት ሞጮጭቶተ ኡጫንኬ። ");
INSERT INTO alw_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ኩ መንቹ ኔሳሃ ሂለ ጥዘነተ እክ ዱንየ አሌን ጉዕማንን ዮ አይሁድ በላን ብተተ ኬሰን ‹ናዝራውያኑተ› ዬኖ ክዝብ ትምርት አዎንሳኖች መቱስ እሁስ ደንጎም። ");
INSERT INTO alw_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","እስን ዱእ ምኒ ንጃሲሶተ ሰውየን ደንግ አንፍ ሕግኔ ሃሊን ፈረንዶተ ሀንሶም እቅ። ");
INSERT INTO alw_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ጠዉ እኮጎሬ በገዝ ሀለቁ ሉስዮስ አሜች አንጋችኔ ዎልቅሽ መሴእ። ");
INSERT INTO alw_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ከሰሳሩ ኪቤቹ አሜቶተ አዘዦ ኩ ነኡ ከሰንሶም ክሱ መርቹሃጎሬ አት ገዉክ እሱ መረመርት ደጎተ አታልታንት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","አይሁዱ «ኩ ጠዉ ጉዕሙንኩ ሀንቅሃን» ይት ክሳንከስ ኢተቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ገሻንቹ ፊልክስ አንገስ ቀቀሽ ጳዉሎስ ጠወአኖ ወክት ኣሴሃንስ ጳዉሎስ «ልግቤ ዘማኒች ኬሽ ከን ኡመት አሌን ፍርድ ዳኘ እሁክ ደጎምቤቺሃ ኤሳሃ ከሰሶኤ ክሲሃ መከላከየ ኪቤቹ ሆንጠህሳም ወክት አበት ሙንዲኑት ሞጮጨንታኤ። ");
INSERT INTO alw_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","አን ዬሩሰሌመ ሰገዶተ መሮሚች ቶነ ለሞ በሬች በተአኖበእገ አት ገዉንኩክ አጥራመቶተ አታልታንት። ");
INSERT INTO alw_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","እሰን ኤሳሃ መገን ምኔን ኦደንለከ ጭምት ምኔን ህከረንገ ከተማን ኡመት ጭምአዕይ ብተተ ኬሰን አፎኤበአ። ");
INSERT INTO alw_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","እኮጎሬ እሰ ኤሳሃ ኦደ ጠዊሃ ማስረጀ ሆንጠህሶሄተ አታልታበአ። ");
INSERT INTO alw_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ጠዉ እኮጎሬ አን ካን ኩላንኬ፤ እሰ ክዝብየ ይታ አመዕነት ዎቃሃ አናኖኔ መገኒሃ ሰገዳም፤ ህትን ሕጋንለከ ነብያኖ መጻፋን ከተበሞሃ ጉዕመንከ አመዕናም። ");
INSERT INTO alw_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","እሰ ፈያኑትለከ ጩበኛኑት ሬሆች ኬኣአ ይት ተብሳሃ አታገን ኤሳሃ መገኖን ተብሶሁ ዮኤ። ");
INSERT INTO alw_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ህካን እኮቤቺሃ አን መገንለከ መን ብሬን ነጡ ሰውቱ ሄኦኤተ ጉዕመ ወክት አጰማም። ");
INSERT INTO alw_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","ዬሩሳሌም ከተሚች ፉሎምች ልግብ ዘማን እኮች ኤተሮን ኢ ባድ መኒሃ ሀዕላም ብረለከ መገኒሃ ኣሰም ብረ አፍ ፈንቀል አሜቾም። ");
INSERT INTO alw_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","አን መገን ምኔን ነጠ እሄኖ ሴረ ሹሎሚሃ ለኦኤ ወክት ህከን ቤቾን ኢን ጭምዬ ኡመቱለከ ብተት ዮበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ጠዉ እኮጎሬ እስየ ዬኖ ባዲች አሜቶ አይሁዱ ህከን ቤቾን ሄኦኡ፤ እሰ ኤሳሃ ከሰሳ ጠዉ ዮሰጎሬ ኪ ብርተ ሆንጠክ ጠወኡ አታልታአ። ");
INSERT INTO alw_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ህከረንጋ ኦገት ብርተ ሆንጠኮም ወክት አዕዮንሰ ጠዉ ዮ ጎሬ ህንዴ ኩ መኑ ኩልቱን። ");
INSERT INTO alw_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ሀንቅንከ በላንከሰ ኡር ሎረ ላጋን ‹ሬቶእሩ ሬሆች ኬኣአ ይ ጠወዕዮምሀኒሃ ከበር ብርክዕኔ ሆንጠኮም› ይ ጠወዕዮምቤሉ ዎሉ አዕዮም ጠዉ መቱርቹሁ ዮበአ።» ");
INSERT INTO alw_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ጠዉ እኮጎሬ ፍልክስ አመዕነት ዎቀሃ ደገኖቤቺሃ «በገዝ ሀለቁ ሉስዮስ አሜቾ ወክት አን ጠወክዕኔ ሹላም» ይ ዝኝተ ህግሾ። ");
INSERT INTO alw_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","እስ ጰዉሎሴ አገረኖ ጥቤ ሀለቀ «አበ ጨነቁዕነ አሙዘን ጡመገ አገርስ፤ ጃለስ ሀስሰኖስርቹ ኤባስ ወክት ከንቶትስ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ቀወ በሬች ኤተሮን ፊልክስ «ዱሩሲላ» ዬኖ አይሁድቾ መንቾንተስን ሜጡበ እክ አሜቾ፤ እስ ጰዉሎሴ ገእሲሽ መሲህ ኢሳን አመዕንተኔሃ ጠወአንን ሞጮጬእ። ");
INSERT INTO alw_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ህትን ጳዉሎስ ፈይመተኔሃ፥ ገዉ አገዕርተኔሃለከ አሜተኖ ፍርድተኔሃ ኩለኖ ወክት ፍልክስ ዋጅ «ቴሶተስ እሀኖኤ፤ ቴሱ መር! ሀሾም ወክት ገእሲሳንኬ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ህከ ወክት ፍልክስ ጰዉሎሴች ጉቡተ ኣኦተ ተብሳሃ አአኖት እቅ፤ ህካን እኮቤቺሃ ልግብ ወክት ጰዉሎሴ እስቤቹ ገእሲሰን ጠዉሲሰኖስ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","እኮጎሬ ለሞ ዘማኒች ኤተሮን ጶርቅዮስ ፊስጦስ ፍልክሴ ቤቾን ገሸኖሃ እኮ፤ ፍልክስ አይሁደ ሙንዲሲሶተ ሀሾቤቺሃ ጰዉሎሴ ኡሱር ምኔን አጉሮስ። ");
INSERT INTO alw_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ፊስጦስ ገይስ አዉራጃ አሜች ሰሶ በሬች ኤተሮን ቂሳርይ ከተሚች ዬሩሳሌመ ኦሮዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ህከን ቤቾን ፊስጦሴ ብሬን ቂስ ሀለቀትለከ አይሁድ ምኒ ሎርሎሩ አዎንሳኑት ጳዉሎሴ ከሰሳ ጠወ ሆንጠህሶኡ። ");
INSERT INTO alw_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","እሰን ፍስጦስ ጳዉሎሴ ዬሩሳሌመ ፈንቀሾተ ኡጭቶኡ፤ ህካን ይቶ መሰት ዎቃን አገርት ሽቶተ ሀሶቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ፍስጦስን «ጳዉሎስ ቂሳርየ ኡሱር ምኔን ዮኡ፤ አን ገዉእ ህከ ቤቹ ፈንቀል ደዕል መራም። ");
INSERT INTO alw_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ሹመክዕኔ ኢን ሜጡበ ቂሳረየ መርቱን፤ ጳዉሎስ አዕዮ ሂሉርቹ ዮስጎሬ ህከን ቤቾን ከሰሱን» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ፊስጦስ ህዜቱ ህከረንገ ቶኑ በሩ ኢሎተ ኢለ እሰቤቾን አገሮች ኤተሮን ቂሳርየ ባዱ ኦሮዕዮ፤ ህከ ቤቹ ኢሌ ለንክ በር ፍርድ ቦርጭማን አፉዕል ጳዉሎሴ ሆንጠህሳገ አዘዦ። ");
INSERT INTO alw_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ህትን ጳዉሎሴ ሮም ባድ ዎመ ሀለቅቤቹ ሆንጠህሴመ ወክት ዬሩሳሌሚች አሜቶ አይሁዱ ረብ ኡርት ምስክር ደጎተ አታልትበ ልግብ ጠረኘ ክሰ ሆንጠህሶኡ። ");
INSERT INTO alw_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ጳዉሎስን «አን አይሁድ ሕጋን፥ መገን ምኔንለከ ሮም ዎመ አሌን አዕዮም ሂሉ ጠዉ መቱርቹሁ ዮኤበአ» ይ ጠዕሜእ። ");
INSERT INTO alw_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","እኮጎሬ ፊስጦስ አይሁድ መነ ሙንዲሲሶተ ሀሽ ጳዉሎሴ «ዬሩሳሌመ መርት ከ ጠወ ኢ ብሬን ፍርደ አእቶተ ሀሰንንዶ?» ይ ጠዕሜስ። ");
INSERT INTO alw_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ጳዉሎስ «አን ፍርደ አኦተ ሀስሰኖኤሃ ሮም ዎመ ሀለቅ አሌን ፍርድ ቦርጭመ ብሬን ኡርዮም፤ እኮጎሬ አት ገዉክ ጡመገ ደጋንትገን አይሁዲሃ አዕዮም ሂሉርቹ መቱርቹሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ህትን አን ቤሾም ጠዉ ዮ ጎሬ ህከረንገ ሬሆተ ኢልሰኖኤ ብድል አዕዮምጎሬ ሬሆች ጡሞ ያምበአ፤ ጠዉ እኮጎሬ እሰ ከሰሳኤ ጠዉ ክዝብ እኮጎሬ አዪሁ ኤሳሃ ህግሽ ኣሶኤተ አታለኖበአ፤ ሮም ባድ ዎም አሌን ይግባኘ ይዮም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ህከ ወክት ፊስጦስ እስ አማሌ መኒን አማዕለም «አት ሮም ባድ ዎም አሌን ይግባኘ ይቶንት ጎሬ ህከ ሮም ዎምቤቹንከ መርታንት» ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ቀዎ በሬች ኤተሮን ዎሙ አግርጵለከ በርኒቄ ፍስጦሴ «ሀበይ ወገሬቲን አሜት» ይቶተ ቂሳርየ መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","እሰን ህከን ቤቾን ልግብ በር አፉዕልቶቤቺሃ ፍስጦስ ጳዉሎሴ ጠወ ዎመ አግርጲሃ ኩለን «ፍልክስ ኡሱርሲሾ መቱ መንቹ ኡሱር ምኔን ዮኡ። ");
INSERT INTO alw_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ህትን አን ዬሩሳሌመ ሄዕዮም ወክት ቂስ ሀለቀትለከ አይሁድ ባልቁ እስተኔሃ ኩልቶች ኤተሮን አሌንከስ ፈረዶተ ጠዕምቶኤ። ");
INSERT INTO alw_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ጠዉ እኮጎሬ አን ‹ከሰሳም መንቹ ከሰሾ መን ብሬን ኡር ከሰሰሞ ጠዊሃ መከላከይ መስሉ ኣሰሙዕነ ከሰሰሞ መንቹ ህግሴን ኣሱ ሮም ባድ መኒሃ ሴረበአ› ይ ፈንቀሼም። ");
INSERT INTO alw_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ህካን እኮቤቺሃ ከሰሶ መኑ ጭምይት ከቤቹ አሜቶ ወክት አን አገሩዕነ ለንክ በር ፍርድ ቦርጭመ አሌን ፈረዶተ አፉዕል ጳዉሎሴ ሆንጠህሳገ አዘዦም። ");
INSERT INTO alw_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ሁኩ ከሰሶእሩ መዴስ ኡርቶ ወክት አን ኩ መንቹ ቤሾ ይ ሰውዬም ጌሰ እሱ ክሲሃ ኢልሰኖ ጠወ መቱርቹሃ ሆንጠህሶበአ። ");
INSERT INTO alw_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ጠዉ እኮጎሬ እሰ እሲን ኦደን ሄኦ ጠዉ ገይሰ አመዕነትሰተኔሃለከ እኮጎሬ ሬዮ እቅ ጳዉሎስ ‹ፎልን ዮኡ› ዬ ኢስተኔሃት። ");
INSERT INTO alw_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ህትናሙ ጠወ አጥራመች ደጉ ኤሳሃ ኦርሾኤቤቺሃ ጳዉሎሴ ‹ዬሩሳሌመ መርት ህከን ቤቾን ፍርደክ ለኦኖተ ሀሰንንዶ?› ይ ጠዕሜስ። ");
INSERT INTO alw_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","እኮጎሬ ጳዉሎስ ኦደን ሄዕዮ ጠወ ሮም ባድ ዎማን ለአሞተ ሀሽ ሮም ባድ ዎሚሃ ይግባኘ ዮንከስ ህካጰ ሶሆስተ ኢለ ኡሱር ምኔን አገረኖገ አዘዦም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ህትን አግርጵ «አን ገዉእ ኩ መንቹ ኩለን ሞጮጮተ ሀሳም» ዬ ወክት ፍስጦስ «ጋተ ሞጮጭታንት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ለንክ በር ገስመ አግርጵለከ ቤርኒቅ ኬዕምኝ ኦድኑተ ኦደእ በገዝ ሀለቃኖንለከ ከተም ሎርሎረ መኒን ሜጡበ እክ ፍርድ ምኒ ኣጎኡ፤ ህከኒች ኤተሮን ፍስጦስ ጳዉሎሴ ገእሲሽ አሜተኖገ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ፍስጦስን «ዎመ አግርጰ! አዕኑ ኒን ከንቤቾን ሜጡበ ዮንተ መኑ ጉዕሙንኩ! አይሁዱ ‹ኩ መንቹ ከኒች ኤተሮን ፎሊን ሄኡ ሀስሰኖስበአ› ይተን አሌስ ፈረዶተ ዬሩሳሌማንለከ ከኔ ቂሳርያን ኤሳሃ ጠዕምቶ መንቹ ከኒት። ");
INSERT INTO alw_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","አን ጳዉሎሴ አሌን ሬሆተ ኢልሰኖ ጠወ ደጎምበአ፤ እኮጎሬ እስ ገዉስ ‹ሮም ዎመ አለቂሃ ይግባኘ› ዬቤቺሃ ሶሆተ ወሰኞም። ");
INSERT INTO alw_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","እሁን ቤሉ እስተኔሃ ዎሚሃኤ ከተባም አጥራመቾም ጠዉ ዮበአ፤ ህካን እኮቤቺሃ መረመረሞች ኤተሮን ከተባም ጠወ ደኤም ጎሬ ይ ብሬንከክዕኔ በትሽን ዎመ አግርጰ! ብርክ ሆንጠህሾም። ");
INSERT INTO alw_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","መሰንትስ ኡሱረሞ መንቹ ዎመ ሀለቅቤቹ ሶሄኖ ወክት መንቹስ ኦደሞ ጠወ ከተቤን ኤንኬዕንሱ ሆጉሰ ገውመተ አጉጅ ለልዮኤ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ዎሙ አግርጵ ጳዉሎሴ «ገይክ ጠወ ጠወኦተ ወክቱ ኣሰሞሄ» ዬስ፤ ህካን እኮቤቺሃ ጳዉሎስ አንገስ ሂር ");
INSERT INTO alw_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«ዎመ አግርጳ! አይሁዱ ከሰሶኤ ጠዊ ጉዕሚንከ ከበር ኪ ብሬን መስለ ኣሳም ወክት አበ ተሽ የኖኤ። ");
INSERT INTO alw_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","መሰንትስ አት አደደ አይሁድ ወገለከ ኦደሰ ጉዕመንከ አጥራመት ደጋንት፤ ህካን እኮቤቺሃ ኢ ጠወ አደቢን ሞጮጭታንቴኤገ ኡጫንኬ። ");
INSERT INTO alw_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«ኦስማችኤ ኬሽ ሀት እክ ሄዕዮምጎሬ አይሁዱ ጉዕሙንኩ ደጋአ፤ ወዕኔች ኬሽ ገይኤ ኡመት በላንለከ ዬሩሳሌማን ሀት እክ ሄዕዮምጎሬ ሄኡኤ ደጋአ። ");
INSERT INTO alw_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ህትን እሰ ኢ ጠወ ኩልቶተ ሀሶ ጎሬ አመዕነትንከኔ ዎገ አገሪን አበ ጠረኘ እኮ ፈርሳዌ አዲሃ እሁኤ ወዕኔችን ኬስ ደጋኣ። ");
INSERT INTO alw_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","አን ቴሁ ከኔ አሌንከኤ ፈረደሞኤተ ኡራሚሁ መገኑ ኒ አበናኖተ ኣሴ ላገ ተብሴሃት። ");
INSERT INTO alw_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ህከ ተብሳሃ ደኢሃ እስራኤል ቶነ ለሙንኩ ደቡኔ ሀንከዕርተለከ በራሃ መገኒሃ ጠረኝት ሰገዳኢት እቅ፤ ዎመ አግርጰ! አይሁዱ ኤሳሃ ከሰሳኤሁ ከን መሳኒት። ");
INSERT INTO alw_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","መገኑ ሬዮ መነ ሬሆች ኬሰኖ እሁስ ክዕኔሃ ሀት አመዕነቱ ሆፈዕዮህዕኔ? ");
INSERT INTO alw_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«አን ገዉእ ናዝሬት ኢስ ሱዕመ አታሎም ጌሲን ቶጉ ግቡ ጡመሃን ይ ሰውያም እቅ። ");
INSERT INTO alw_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","አን ዬሩሳሌማን አዕዮሚሁ ከኒት፤ እስን ቂስ ሀለቃች ቶጎም ዳኞማን አመዕንቶ ወገሬት መነ ኡሱር ምኒ ኣግሾም፤ ህትን እሰንተ ሽተን ሽታሀኑኡን ሜጡበ አማዕለሞም። ");
INSERT INTO alw_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","አን ልግብ ወክት ጉዕመንከ ጭምት ምኒ መረን ኦሌኖሰገለከ ቀርች ሱዕመ ቦሮርታገ አዕዮም፤ ህትን እሰ አሌን ኡሙዕር ዎሎ ባድ ከተመ ኢሎተ ኢለ መረን ሸራንሳት እቅ።» ");
INSERT INTO alw_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ህካን እኮቤቺሃ «አን ቂሰ ሀለቃች ዊመ ሹምነቱለከ ትዛዝ ቶግ ደማስቆ ከተመ ኦሮዕዮም። ");
INSERT INTO alw_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ዎመ! አን ዎቃን ሃመን ዙር ሰኣት እኮ ወክቴን አር ኑሪች በተአኖ ኑር ለዕዮም፤ ሁኩ ኑሩንኩ ኢለ ኢን ሜጡበ ሃመን ሄዕዮ መን መዴን ሰሜች በለቆ። ");
INSERT INTO alw_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ነኡ ጉዕሙንኩኔ ኡለ አሌን ኡንብ እብራዌ መን አፎን ‹ሳኦሌ! ሳኦሌ! ሚሃ ሸርታንቴኤት? ቦረተ አቡሬኖ ሱጠ ብረቲን ቀሴነን ጌጥ ይት ሃንትበጎር ምርተኣንት› ይታ ላገተ ሞጮጬም። ");
INSERT INTO alw_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","አኒን ‹ቀርቾ! አት አዬት?› ዬም፤ ህትን ቀርቹንኩ ‹አን አት ሸርታንቴኤ ኢሳት። ");
INSERT INTO alw_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","እኮጎሬ ቴሱ ኬእ ሎካንከክ ኡር፤ አን ኬሳሃ ለሌንኬሁ ካዲንቹ እኮተ ህትን ለኦንት ጠዊሃለከ ብርተ ዋሽት ለኣንት ጠዊሃ ምስክር እኮተ ሾሞሄታት። ");
INSERT INTO alw_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","አን አይሁድ ኡመት አንጋችለከ ህትን አን ሶሃንኬ አይሁደ እክበ መን አንጋች ጡምሳንኬ። ");
INSERT INTO alw_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","እልሰ ፈንቶተለከ ቱንስቺች ኑርቤቹ ፉሽቶሰተ ሽይጣን ዎልቃች መገን አደ ፈንቀሽቶሰተ አኣንኬ፤ እሰን ጩቡሰ ፈቁን የመመኖሰ፤ ህትን ኢን አመዕንት ኢረ እኮ መን በሊች እሰ ርስት ቤቀንታአ› ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«ህካን እኮቤቺሃ ዎመ አግርጰ! ሰሜች ኣሰንቶኤ መናመተ ቶጉ ግቦምበአ። ");
INSERT INTO alw_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ጠዉ እኮጎሬ አን ሄጭ ደማስቆ ከተማን ሄዕዮ መኒሃ፥ ህከኒች ኤተሮን ዬሩሳሌም ከተማንለከ ይሁድ ባዶን ሄኣእሩ ጉዕሙንኩ ህትን አይሁደ እህቡ መኑ ጩብሰ ቶበት መገን አደ ፈንቀልታገ ተማርሴንሰ፤ ህትን ጩብሰ ቶበት ፈንቀሉሰ ለሊሳ ሆጉተ አታገ ተማርሴንሰ። ");
INSERT INTO alw_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ህከን መሳን አይሁድ መኑ ኤሳሃ መገን ምኔን ሄዕዮምሀኔን አፍ ሽቶኤተ ሀሶኡ። ");
INSERT INTO alw_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ጠዉ እኮጎሬ ከበሬ ኢለ መገን ሀዕለንሹ ኢች አደ እኮበአ፤ ህካን እኮቤቺሃ አን ሎሪሃለከ ቀዊሃ ተማርሰን ከንቤቾን ዮም፤ ሙሲለከ ነብያከት ሄጭት ህት እሀኖ ይቶኢሃ ጠወዕዮምሀንቤሉ ዎሉ መቱርቹሃ ጠወዕዮምበአ። ");
INSERT INTO alw_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ሁኩ እሰ ጠወኦኢሁ ‹መሲሁ ኦርሸተ ቶገኖ፤ ህትን ሬሆች ኬኢን ዎኔሃ እክ ጡም ኑር እስራኤል መኒሃለከ አይሁደ እህቡ መኒሃ ለሊሰኖ ይቲት› » ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ጳዉሎስ ህት ጠወአንን ፍስጦስ «ጳዉሎሴ! ቴዕኑ በርገጎንት፤ ልግብ ተማሩክ በርገጋሸ አዕዮሄ» ይ ላገስ ጎት አዕይ ጠወዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ጠዉ እኮጎሬ ጳዉሎስ «ከበጀንቶንት ፍስጦሴ! አን ሀንቅለከ ሀቅቀተ እኮ ጠወ ጠወኣሚት ቤሉ በርገጎምበአ። ");
INSERT INTO alw_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","አን ብሬስ ለሊሽ ጠወዕዮሚሃ ዎሙ ህከ ጠወ ደገኖ፤ ሁኩንን ማጠም አሰምባሃ እኮቤቺሃ ዎሙ ደገኖገ ተሬገጮም። ");
INSERT INTO alw_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ዎመ አግሪጳ! ነብያኑተ አመዕንታንትበእንዶ? አት አመዕንታንትገ ደጋም» ይ ፈንቀሼእ። ");
INSERT INTO alw_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","አግርጵ ጳዉሎሴ «አት ኤሳሃ ቀዎ ጌሳን መሲህ ኢሳን አመዕናምገ አቶኤተ ሰውይቶንት» ዬስ። ");
INSERT INTO alw_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ህትን ጳዉሎስ «ገበንቾ ወክቴን እሁን ቄራዕሮ ወክቴን ኬሳሃ ጠለዕል እሁዕነ ከበር ኩላሚሃ ሞጮጨኖሁ ጉዕሙንኩ ከን ኡሱረምኤ ቤሉ ዎሎርቾን ጉዕማንን ኢገ እኮተ ዱአ አኣም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ህከኒች ኤተሮን ዎሙ፥ ባድ ገሻንቹለከ ቤርኒቅ እሳንን ሜጡበ አፉዕልቶእሩ ጉዕሙንኩ ኬኦኡ። ");
INSERT INTO alw_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","እሰን ህከንቤቺች ኬእ መርተን «ኩ መንቹ ሬሆተ ህከረንገ ኡሱረሞተ ኢልሰኖስ ጠወ መቱርቹሃ አዕዮበአ» የቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","ህትን አግርጵ ፍስጦሴ «ኩ መንቹ ሮም ባድ ዎመ ዎም አሌን ይግባኘ ይዮበእቃን ህትን ገፈረመኖ እቅ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ህከኒች ኤተሮን ጣልያን ባዱ መርከቢን መርኖተ ወሰነሞ ወክት እሰ ጳዉሎሴለከ ዎሉ መት-መቱ ኡሱረንቶእረ በርግት ሮም ወታደር ኣዜን ሄዕዮ ዩልዮሴ ዬኖ ጥቤ ሀለቅቺሃ ህግስ ኣቶሰ። ");
INSERT INTO alw_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","እስይ ባር መዴን ዮ ባዶን ሄዕዮ መርከበት ኡርታ ቤቹ መረኖ አድራሚጥዮን መርከባን ኣንግ መርኖም፤ ተሰሎንቄን ሄአኖ መቄዶን ባድ መንቹ አርስጥሮኮስ ኒን ሜጡበ ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ነኡ ለንክ በር ሲዶን ከተመ ኢልኖም፤ ዩልዮስ ጳዉሎስ አሙዦስቤቺሃ ጃለሰቤቹ መር እሳች ሀስሰኖርቹ ኤቦተ አዕዮስ። ");
INSERT INTO alw_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ነኡ ለንክ በር ቦብሩ ጠረኝ ቦብርሰን ሃሙ ከሞኔቤቺሃ ዊን ረበንቶ «ቆጵሮሰ» ዬኖ ኡላን ቴዕልን ባር አሌን መርከባን ሃሙ ጃመርኖም። ");
INSERT INTO alw_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ክልቅይለከ ጵንፍልየ መዴን ሄዕዮ ባረ ቶልኖሚች ኤተሮን ሊቅየ ባዶን ሄአኖ «ሙራ» ዬኖ ከተመ ኢልኖም። ");
INSERT INTO alw_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ጥቤ ሀለቁ ጣልያን ባዱ መረኖ አለክሰንደሪ ከተም መርከበ ደግ እሶን ኣግሾኔ። ");
INSERT INTO alw_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ነኡ ልግብ በር ሎድ ይን መርነን አበ ኦርሻን ቀኒዶስ ከተም መድ ኢልኖም፤ ቦብሩ ብርተ ዋልን ሃሙ ከሞኔቤቺሃ «ሰልሞና» ዬኖቤቺን ህንግ ዊን ረበንቶ «ቀርጤሰ» ዬኖ ኡላን ማጠም ኦሮዕኖም። ");
INSERT INTO alw_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ነኡ አበ አርሻን ገበል ገበለ ሃመን ህንግ «ላስየ» ዬኖ ከተም መዴን ሄኣ ጡመተ ዬኖ መርከቡ ኡረኖ ቤቹ ኢልኖም። ");
INSERT INTO alw_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ዎቄኔ አሌን ልግቡ ወክቱ በዕዮቤቺሃለከ ሶመን በሩ ህጎቤቺሃ ህከን ወክቴን ባር አሌን ሃሙ አበ ኦርሰኖቤቺሃ ");
INSERT INTO alw_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ጳዉሎስ «ኮ መነ! ከኒች ኤተሮን ዮኔ ዎቃን አበ ኦርሸት ዮኢሃ እሁስ ለለኖኤት፤ ሁኩንን ሆጎቦንለከ መርከባን ኢልታ ኦርሸተ ጠለዕለ እሁዕናን ኒ ገይኔ ነብሳን አቡ ኦርሸት ኢልቶተ አታልታአ» ይ ጠረኝሽ ጠወዕዮ። ");
INSERT INTO alw_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ጠዉ እኮጎሬ ጥቤ ሀለቅቹ ጳዉሎስ ጠረኝሽ ጠወዕዮ ጠዊች በትሽ መርከበስ ኦተአኖሀንለከ መርከብስ አኑ የኖሃ ሞጮጨኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ሁኩ መርከቡ ኡረኖ ቤቹ ከርም ህከኔ ህግሲሃ ጡመ እህበቤቺሃ መኒች ልግቡስ «ሃሚሃ አታልሲሾ ጎሬ ቅልብ ገርብንለከ ከኣጳ ገርብ ኡሮን ዮ ፊንቄ ዬኖ ዊን ረበሞ ቀርጤሳን ሄአኖ መርከቡ ኡረኖ ቤቹ ኢልን ከርም ህከኔ ህግንሶ» ይት አማልሰ ሆንጠህሶኡ። ");
INSERT INTO alw_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ከኣጳ አዲን ቦብሩ ሎድ ይ ቦብርሰን ለኦ ወክት እሰ ሰውይቶ ሃሊን እሀኖሃ አጉጃንሰ መልሕቀ ኬስ ሃንቶተ ኬኦኡ፤ ሁኩ መርከቡ ኡረኖቤቺች ኬእ ቀርጤስ ኡለ ለቾን ህጎኡ። ");
INSERT INTO alw_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ጠዉ እኮጎሬ ቀዎ ወክቲች ኤተሮን ቅልቢን ሸርቅ ኡንጉሉሉተ ዬኖ ጠረኙ ቦብሩ ዊን ረበንቶ ኡላች ኬዕይ እሰ ዮ ቤቹ አሜቾ። ");
INSERT INTO alw_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","መርከበ ቦብሩ ሀምበሎቤቺሃለከ ቦብረስ አታሉ ሆንጎምቤቺሃ ጨለ ይን ቦብሩ ሀንበለኔ መርኖም። ");
INSERT INTO alw_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ቀዎ ዊን ረበንቶ ቄዳ ዬኖ ኡለ መዲን ህንግ መርከበ ሀዕለኖ ጀልበ አበ ኦርሻን ኡሱርን ኡርንሶተ አታልኖም። ");
INSERT INTO alw_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","መርከብ ኣዜን አታ መኑ ጀልበስ ኣዝ ኣግስ መርከበስ ዌደሪን ኡሱርቶኡ፤ ህትን መርከበስ ሊብየ ባዲች አል አዲን ሄአኖ ሱርቲሰ ዬኖ ሽፋሩ ዮቤቾን ኡባበእገ ዋጅት ሸረ ድሪስ ቦብሩ ሀምበለን መርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ኒ አሌን ኡንጉሉሎ ቦብሩ ጠረኘን መሮቤቺሃ መርከባን ሆጎበንቶ ኦዳተ መት-መቲን ለንክስ በር ድሪስ ባር ኣዜን ኡጁ ጀመርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","እሰን ሰቅ በር መርከቢሃ ደግለልታ ኦዳተ ባር ዊ አሌን ኡጅቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ልግብ በር ጠረኙ ቦብሩ ኬዕይ አሩለከ ቤዜተ ለኡ ከሞኔቤቺሃ ጡምናምበአ ይን ተብሳሃ ሙርኖም። ");
INSERT INTO alw_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","መኑ እቸተ እቱዕነ ልግብ በር ዱንኬቤቺሃ ጳዉሎስ በለሰ ኡር «ኮ መነ! ከኒች ብርተ ሸዦንክዕኔ ሸዘነተ ሞጮጭቴን ዊን ረበንቶ ቀርጤሰ ዬኖ ቤቺች ኬኤንታበ እቃን ኩ ኦርሸትለከ በኡ ኢለኖህዕኔበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ቴሁ መርከቡስ በአኖ ቤሉ ክዕኔች መትክዕኔ ነብሶሁ በአኖበአ፤ ዋጅቶኖቼ ይ ሸዛንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","መሰንትስ ህጎ ሀንከዕርተ አን እሲሃ ጠገም ሰገዳም መገኑ ሶኮስ መላይኬቹ መዴንከእ ኡር ");
INSERT INTO alw_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‹ጳዉሎሴ ዋጅቶት! ሮም ባድ ዎም ብሬን ኡሩ ዮሄ፤ ህትን ኪን ሜጡበ እክ ሃንታ መነ ጉዕመንከ መገኑ ኪተኔሃ ይ ሬሆች ጡምሰኖ› ይ ኩሎኤ። ");
INSERT INTO alw_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ህካን እኮቤቺሃ መነ ዋጅቶኖቼ፤ መገኑ ኤሳሃ ኩሎኤርቹ አአኖገ አመዕናም። ");
INSERT INTO alw_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","እኮጎሬ ቦብሩ ሀንበል መት ዊን ረበንቶ ኡለተ መሰኖኔ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ቶነ ሾልቅ በሬ ሀንከዕሬን አድርያ ባር አሌን ቦብሩ ሀምበለን ሀንከዕሬ በላን መርከበ ኦተኣእሩ ኡለተ ኢልቶኢሃ አጉጆሰ። ");
INSERT INTO alw_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ህካን እኮቤቺሃ እሰ ህከን ቤቺ ጥዕላሽመተ ዎደሪን ክኑ ኡሱርት ኣዝ ዋሽት ብክታ ወክት ህዜታዩ ብኩተ እኮ፤ ህትን ቀወ ወክቲች ኤተሮን ለንኪሃ ብክቶ ወክት ሌሃዉ ብኩተ እኮ። ");
INSERT INTO alw_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ህካን እኮቤቺሃ መርከቡ ባር መዴን ዮ ክኖን ዎቀዕርበገ ዋጅት መርከብ ኤተር አዲን ሾሉ «ማልሕቀ» ዬኖ ብረት ባር ኣዜን ኡርሶኡ፤ ህከኒች ኤተሮን ኡለት ሶዛገ ዱአ አቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","መርከበ ኦተኣ መኑ መርከቢች ፉልት ሁንቶተ ሄዕላት መርከብ ብሬ አዲን ዮ «መልሕቀ» ዬኖርቹ ኡጅታኢሃ አጉድ መርከብ አሌን ሄዕዮ ጀልበ ባር አሌን ኡጅቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ጳዉሎስ ህካን ለዕዮ ወክት ጥቤ ሀለቅቺሃለከ ዎታደሪሃ «ኩ መርከበ ኦተኣእሩ መርከብ ኣዜን ረጀይት አፉዕልትባች አዕኑ ጡምቶኖተ አታልቴነንተበአ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ህካን እኮቤቺሃ ዎታደሩ ጀልበ ኡሱሬመ ዎደሩ ሙርት ባር አሊን ሃንታገ አቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ኡለት ሶዞተ ሆንጠካን ጳዉሎስ ጉዕሙንኩሰ እቸተ እቶተ «አዕኑ መት-መቱክዕኔ አገርቴነን እቸተ እቶኑዕነ ዱንክቴንታች ከበር ቶነ ሾልቅየ በር። ");
INSERT INTO alw_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ህካን እኮቤቺሃ አዕኑ እቸተ እቶኖተ ኡጫንክዕኔ፤ እቸት እቴንታች ጡምቴነንተ፤ ክዕኔ አሌን መት ኦርሸት እካህዕኔበአ» ይ ኡጬሰ። ");
INSERT INTO alw_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","እስ ህካን ዬች ኤተሮን ጣቢተ ኣእ ጉዕምሰ ብሬን ዱአ አዕይ ቢጭ እቱ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ህከኒች ኤተሮን ጉዕሙንኩሰ ነሻጥ እቸተ እቶኡ፤ ህትን እሰን ገይሰ አንጋን ጣቢተ ኣእት እቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","መርከብ ኣዜን ሄዕኖምሩ ጉዕሙንኩኔ ለም ጥብተ ለመላይኔ ሌሆ መነ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","እሰን እት ዱቦች ኤተሮን መርከቢሃ ኬዕመኖበእገ አለሱ ባራን ቶርቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","እሰን ኡለት ሶዘን ኢልቶ ቤቹ ደጎበአ፤ ጠዉ እኮጎሬ ባር መዴን ዮ ሽፋር ኡለተ ለኦኡ፤ አታልቶ እቃ መርከበ ህከ ቤቹ ሆንጠህሶተ ሰውይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ህካን እኮቤቺሃ እሰ መርከበ ኡርሳ መልሔቅ ዌደሩ ሙርት ኡጅቶኡ፤ ህትን መርከበስ ጉረለከ መኬ አደ አኢሃ ሀዕለኖ ዌደሩ ሂርቶኡ፤ ሸረስ አሌ ዋሽት ኡሱርታን ቦብሩ ብርተ ዋሽ ሃንሲሰን ባሪች ገበለ ዋል ሃመኖገ አቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ጠዉ እኮጎሬ መርከቡ ናረሞ ሽፋራን ቆዕል ብሬ አዲን ኡላን ካሰሞቤቺሃ ሌንቄቅበገ እኮ፤ ህትን ኤተር አዲን ዊ ሁሉ አበ ሀምበለኖቤቺሃ ቢጠሙ ጀመሮ። ");
INSERT INTO alw_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ኡሱረንቶሀኑኡች አዪሁ ባረ ዘከዕይ ፉሸዕበገ ዎታደሩ ሽቶተ አማዕለንቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ጠዉ እኮጎሬ ጥቤ ሀለቅቹ ጳዉሎሴ ጡምሶተ ሀሾቤቺሃ ሰውትሰ ቶጎበአ፤ ህካን እኮቤቺሃ ዘከኡ አታለኖሁ አዪሁ መርከቢች ኮርጅ ድር ዘከዕይ ገበለ ፉለኖገ አዘዦ። ");
INSERT INTO alw_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ፈቆሀኑኡች መቱ ጌሱ መርከቢች ቢጠሞሀኒን ህከረንገ ዎሎርች አሌን እክ ፉልቶተ አዘዣን ጉዕሙንኩሰ ወገሬቲን ገበለ ፉልቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ነኡ ዊን ረበንቶ ኡለቤቹ ወገሬቲን ኢልኖሚች ኤተሮን ሁኩ ኡለት «ማልተ» ዬን ገኤኖሃ እሁስ ደንጎም። ");
INSERT INTO alw_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ህከ ወክት ጤነ ኡባን ቂዘ እኮቤቺሃ ህከን ዊን ረበንቶ ኡላን ሄአኖ መኑ ጉዕሙንኩ ጊረተ ቡስት ጡመገ አት ኮህሶኔ። ");
INSERT INTO alw_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ጳዉሎስ ሁረ ጭምአዕይ ጊራን ዎሮ፤ ህከን ፋራን ኬዕዮ አኔን መቱ ዎሪቹ ፉል ጳዉሎሴ አንገስ ከሮ። ");
INSERT INTO alw_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ማልተ ዬኖ ኡላን ሄኣ መኑ ዎሪቹ ጳዉሎሴ አንገተ ከሩስ ለኦ ወክት ገገዉንኩሰን «ኩ መንቹ ሀንቅንከ መነ ሽዮእሃን፤ ባሪች ወገሬቲን ፉሎጎሬሁ ፍርዲች ጡም ፎሊን ሄኦተ አታሎበአ» የቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ጠዉ እኮጎሬ አንጋችስ ዎሪቹ ግግሽ ጊራን ኡጅ ምርተኡዕነ ፈቆ። ");
INSERT INTO alw_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","እሰ «አንገላንገን አሉስ ደርሸኖ ህከረንገ ወክትንከስ ኡብ ሬሀኖ» ይት አገርታኢት እቅ፤ ጠዉ እኮጎሬ እሰ ልግብ ወክት አገርትኬእ ምርተኡ ሆጉስ ለእ ሰውትሰ ዶርት «ኩን መገኑሃን» ይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ህከን ሄዕኖም ቤቾን መዴን ዊን ረበሞ ባዱ ገሸኖ «ፑፕልዮሴ» ዬኖ መንቺሃ ኡለት ሄኦስ እቅ፤ እስን ምንስ መስ ሰሱ በር ጡመገ አዕይ ቶጎኔ። ");
INSERT INTO alw_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ህከ ወክት ፑፕልዮሴ አነ ፋረትለከ ጎደበ ኦተዕይ ጥዣንስ ኦሰዕዮ እቅ፤ ህካን እኮቤቺሃ ጳዉሎስ እስ ምኒ ኦሮዕይ አንገስ አሌስ አዕይ ዱአ አዕያን ፈዬእ። ");
INSERT INTO alw_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ሁኩን እኮች ኤተሮን ህከን ዊን ረበንቶ ባዶን ሄኣ መኒች ዎሉ ጥዘናመት አሜት ጥዘናችሰ ፈይቶኡ። ");
INSERT INTO alw_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","እሰ ኔሳሃ ልግብ ሽልማት ኤቦኔ፤ ከበጁሰ ለሊሶኔ፤ ነኡ መርከባን ኣንግ መርኖተ ኬዕኖም ወክት ኔሳሃ ሀስሰኖርቹ መርከባን ሆጎቦኔ። ");
INSERT INTO alw_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ሰሱ አገነ ዊ በላን «ማልተ» አገርኖሚች ኤተሮን ከርም ህከኔ ዊን ረበሞ ባዶን ዱንኬ አሌክሰንደር ከተም መርከባን ኣንግ ሃሞተ ኬዕኖም፤ መርከብስ አሌን «ዲዮስቆሮስ» ዬኖ መልተ ሽርኬሃ ለም መላት ሄኦስ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","«ስራኩሰ» ዬኖ ከተመ ኢልን ሰሱ በር አፉዕልኖም። ");
INSERT INTO alw_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ህከንቤቺች ባር መዴን ዘህን «ሬጊዩም» ዬኖቤቹ ኢልኖም፤ መቶ በሬች ኤተሮን ከኣጵ አዲን ቦብረኖ ቦብሩ ቦብርሴቤቺሃ ለንክስ በር «ፑቲዮሉሰ» ዬኖቤቹ አሜንቶም። ");
INSERT INTO alw_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ህከኔ ሄኦ አመዕናኖን ደቀም እሳንን ሜጡበ ለመለ በር ዱንክኖተ ኡጭቶኔ፤ ህከኒች ኤተሮን ሮም ከተመ መርኖም። ");
INSERT INTO alw_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ሮም ባድ አመዕናኑት ኒተኔሃ ሞጮጭቶ ወክት «አፍዮስ» ዬኖ ጌቤበለከ «ሰሱ ኮሁ ገለኖ ምነት» ዬኖቤቹ ኢለ ኔሳሃ ቶጎተ አሜቶኡ፤ ህካን እኮቤቺሃ ጳዉሎስ እሰተ ለዕዮ ወክት መገኑ ገለትጭ ጠረኜእ። ");
INSERT INTO alw_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ነኡ ሮም ከተመ ኣንጎም ወክት ጳዉሎሴ ፉሸእበገ አገረኖ መቱ ዎታደርቹ ኣሴናንስ ሜጢሀስ ሄአኖገ አኤመስ። ");
INSERT INTO alw_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ሰሶ በሬች ኤተሮን ጳዉሎስ ሮም ከተማን ሄኣ አይሁድ ሎርሎረ መነ ገእሲሾ፤ መኑስ ጭምይቶ ወክት «አመኤ ኦሶ! እስራኤል ኡመት አሌንለከ አናከኔ ሴር አሌን አዕዮም ብድሉ ዮበአ፤ እሁን ቤሉ ዬሩሳሌም ከተማን ኡሱረሞምቤቺች ሮም መኒሃ ህግሴን ኣሴመኤ። ");
INSERT INTO alw_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ሮም ባድ መኑ መረመርቶች ኤተሮን ህትን ገፈርቶኤተ ሰውይቶኡ፤ መሰንትስ ኤሳሃ ሬሆተ ኢልሰኖኤ ጠወ ሆጎቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ጠዉ እኮጎሬ አይሁዱ አን ህትን ገፈረሙ ግባ ወክት ሮም ባድ ዎም አሌን ይግባኘ ዩ ሀስሾኤ ቤሉ ኢ ኡመት ከሰሳም ጠዉ ዮኤበአ። ");
INSERT INTO alw_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ህካን እኮቤቺሃ አን ክዕኔተ ለኦተለከ ክዕኔን ሜጡበ ጠወኦተ ጠዕምዮም፤ መሰንትስ አን ሰንሰለቲን ኡሱረሞሚሁ እስራኤልሃ ኣሰሞ ተብሴሃት» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","እሰ ጳዉሎሴ «ኪተኔሃ ኔሳሃ ይሁድ ባዲች ደብዳቤት ኢልቶኔበአ፤ ህትን ከበ አሜቶ መኒች አዪሁ ኪ ሂለ ጠወ ኩሎሁለከ ጠወዕዮሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","እኮጎሬ ነኡ አት አዎንታንት አመዕነቱ አደደ ቤቾን ዮ መኑ ቶጉ ግበኖገ ደንጋም፤ ህካን እኮቤቺሃ ኪ ሰውቱ መሃጎሬ ሞጮጭኖተ ሀንሳም» ይቶስ። ");
INSERT INTO alw_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ህካን እኮቤቺሃ እሰ ዝኝተ አፎች ኤተሮን ልግቡ መኑ እስ ገለኖ ምንቤቹ አሜቶኡ፤ ጳዉሎስን ገስሜች ሀዎሩተ ኢለ መገን ዎምነትተኔሃ ዮስ ሰውት ጠወዕዮ፤ ሙስ ሕጊችለከ ነብያከ መጻፊች ኢስተኔሃ ኩሎሰ። ");
INSERT INTO alw_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ህከኒች ኤተሮን መት-መቱሰ እስ ጠወዕዮሰ ላገተ አመዕንቶኡ፤ እኮጎሬ መት-መቱሰ አመዕንቶበአ። ");
INSERT INTO alw_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ህካን እኮቤቺሃ ገገዉንኩሰን ኢተቀንቱዕነ አደ እኮገ ጳዉሎስ ለዕዮ ወክት «ጠሊሉ አያኑ ነብዬቾ እስያሴን አናካተክዕኔ ጠወዕዮሁ ሀንቅሃን። ");
INSERT INTO alw_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","« ‹ህከ ኡመት ቤቹ መርትኬእ ሞጮጩስ ሞጮጭቴነንተ ሆሮን ቶጌነንተበአ። ለኡስ ለኤነንተ እኮጎሬ ሆሮን አጥራመቴነንተበአ። ");
INSERT INTO alw_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","መሰንትስ ከን ኡመት ቀልቡ ዱጆኡ፤ መጨስ ዶንቅቶኡ፤ እልሰን ቆቆኡ፤ ህት እኮበእ እቃን እሌንከሰ ለእ መጫንከሰ ሞጮጭት ቀልቤንከሰ ሰውይት ኢቤቹ ፈንቀልቶ እቃን አንን ፈይሳንሰ እቅ› ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","«ቴሁ መገን ጡምስ ሶህኑት አይሁደ እህበ መኒሃ ሶሀንቶእተ እሁስ ደጌ፤ ህትን እሰ ሞጮጭታአ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","«ጳዉሎስ ህካን ጠወዕዮች ኤተሮን አይሁዱ አበ ኦደን ህከንቤቺች አጉርት ፉልቶኡ» ");
INSERT INTO alw_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ጳዉሎስ ኬር ምኔን ለሙ ዘማን ዊመ አፉዕሌእ፤ እስቤቹ አሜተኖ መነ ጉዕመንከ ኮህኝተ ቶገኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ጳዉሎስ መገን ዎምነትተኔሃ ኩለን ቀርቾ መሲህ ኢስተኔሃ አዪሁ ከሞስበኢሃ መለል ተማርሰኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","መሲህ ኢስ ካዲንቹ እኮ ሶቀም ሆጎተ ገአሞ መገን እንጂለ ተማርሶተ መጠረሞ ጳዉሎሴች ሶሃሞሃ። ");
INSERT INTO alw_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ሁኩንን እንጂሉ መገኑ ነብያኖን ጠሊለ መጻፋን ሄጭ ኣሴ ተብሴታ ላገ። ");
INSERT INTO alw_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ኩ እንጂሉንኩ ደውዴ ዘሬች እለም መንቹ እኮ ቤትስተኔሃ ጠወአኖ። ");
INSERT INTO alw_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","መገኑ ገውንኩስ ጠሊለ አያን ዎልቃን ቀርቹኔ መሲህ ኢሰ ሬሆች ኬሽ ቤቱ እሁስ ዊመ ዎልቃን ደግሲሾ። ");
INSERT INTO alw_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","መሲህ ሱዕምተኔሃ አይሁደ እክበሩ ጉዕሙንኩ አመዕንቶተለከ አዘዘንታገ አኢሃ እስ መሳን ሶቀሚሃ አበቀኣኔ ኣስቱተ ቶንጎም። ");
INSERT INTO alw_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ህከን መኒን ሜጡበ አዕኑሁ መሲህ ኢስረ እኮኖተ ገአንቴንታእራን። ");
INSERT INTO alw_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","መገኑ ኢቴህዕኔለከ ጠሊላኑተ እኮኖተ ገአንቴንተ ሮም ከተማን ሄኤነንተሩ ጉዕሙንኩክዕኔ አናኔ መገኒችለከ ቀርቹሃኔ መሲህ ኢሲች ኣስቱትለከ ወገሬቱሁ ክዕኔኤሃ እሁን። ");
INSERT INTO alw_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","አመዕነቱክዕኔ ባዶን ጉዕማንን ሞጮጨሞቤቺሃ ጉዕምክዕኔተኔንከ ሄጭ መሲህ ኢስ መሳን ጉዕሚክዕኔተኔሃ ኢ ቀርቹ መገኑኤ ገለትጫም። ");
INSERT INTO alw_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ጉዕመ ወክት ዱአ አአን ቃጋንክዕኔገ ቤትስተኔሃ ጠወአኖ እንጂለ ተማርሲን ዊመ ቀልብንከኤ ካደማም መገኑኤ ምስክርሃን። ");
INSERT INTO alw_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ቴሱ አበ ዱንኬሚች ኤተሮን መጨረሻን መገኑ ዬጎሬ ክዕኔቤቹ አሜቶተ ዎቆኤ ብዝ ዮተ ጉዕመ ወክት ዱአ አኣም። ");
INSERT INTO alw_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","አመዕነቲን ጠረኝቴነንተገ አአኖህዕኔ አያን በረከተ ቤሆህዕኔተ ይ ለኦህዕኔተ ሀሳም። ");
INSERT INTO alw_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ህት ዬሚንኩ አን ክዕኔ አመዕነቲንለከ አዕኑሁ ኢ አመዕነቲን ገገዉንኩኔ ጠረኝጨቀሞታት። ");
INSERT INTO alw_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","አመኤ ኦሶ! አይሁደ እህበ ዎሎ መንቤቾን ልግብ አቶተ ደጎምገን ህትን ክዕኔ በላን አቶተ ደጎተ ሀሾም እቅ፤ ጠዉ እኮጎሬ ክዕኔቤቹ አሜቶተ ልግብ ወክት ያጅ ከበሬ ኢለ መኩ ሆጉስ ደጎኖተ ሀሳም። ");
INSERT INTO alw_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ግርክ መኒለከ ግርከ እህበ መኒሃ፥ ኤንኬዕናማተለከ ገወ መኒሃ ግዳጁ ዮኤ። ");
INSERT INTO alw_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ህካን እኮቤቺሃ ክዕኔንከ ሮም ከተማን ዮንተ መኒሃ ተሽት ላገተ ተማርሶተ ሄዕላታም። ");
INSERT INTO alw_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","አን እንጂል ላጋን ሙላምበአ፤ ተሽት ላገት አይሁዲሃለከ ግርክ መኒሃ አመዕንታ መኒሃ ጉዕሚንከ መገን ወልቀት ፈይሲሃት። ");
INSERT INTO alw_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ፈዩ መንቹ አመዕነቲን ሄኡ ደአኖ የመም ከተበሞገን መገኑ መነ ፈየ እሁሰ ወለአኖሁ ዎዕኔች ኤተሩ ኢለ ጠለዕል አመዕነቲን እሁስ ህከን ተሽት ላጋን ለሌእ። ");
INSERT INTO alw_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","መኑ ሂልማንተስ ሀንቁ ለለኖበእገ አታአ፤ መገኑ ዋጅትበቤቺሃለከ ፈይመት ዮሰበእቤቺሃ እሰ አሌን መገን ኡሙዕርት ሰሜች አሜታአ። ");
INSERT INTO alw_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","መሰንትስ መገንተኔሃ ደገሙ ሀስሰኖሃ ጉዕመንከ መገኑ ለልሾሰቤቺሃ እሳሃ ኑር እክ ለልዮእሃን። ");
INSERT INTO alw_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ኣዱንያ አሉ ከለቀሞ በሬች ኬሽ መኒሃ ለለኖበእ መገን ሃሉ ሁኩንን ዘላለሚሃ ሄኣ ወልቀስለከ ቀርቹ እሁስ እስ ከለቆ ጠው መሳን ዊመ እክ ለሌቤቺሃ መኑ ቤሳ ቤሲሃ መሰት ዮሰበአ። ");
INSERT INTO alw_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ህትን እሰ መገኑ ደገን መገኑ እህሃስ ሀስሰኖ ኬዕምኝለከ እሱ ገለትጩ ግቦኡ፤ ሰውቱንኩሰ ተሰ እኮ፤ አጥረመትቡ ቀልቡሰ ቱንስቹ እኮ። ");
INSERT INTO alw_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","«ነኡ ሀይቻኑተ» ይተንን ገዋኑተ እኮኡ። ");
INSERT INTO alw_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ሄአኖ መገኑ ከበጅታ ወጥ ሄእበ መን ምስሊሃ፥ ጭኦተ፥ ሾል ሎከት ዮስ ግዚሃለከ ኡለ አሌን ጎሾሸንትኣ ግዝ ደኒን መክሴመ ምስሊሃ ኬዕምኝ ኣቶኡ። ");
INSERT INTO alw_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ህካን እኮቤቺሃ ገገዉንኩሰ ገይሰ ጅስም አሌን ሙልሰኖርቹ አቶተ መገኑ ንጃሱ ዊሞ ሂለ ሄዕላቻተሰ ጠገንቶረ እካገ ህግሽ ኣሴሰ። ");
INSERT INTO alw_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ሁኩን እኮሁ መገን ሀንቅ ክዝቢን ዶርቶቤቺሃቲ፥ ካሊቅ ወጥ ከለቀሞሀኒሃ ሰገዶቤቺሃለከ ካደንቶቤቺሃት፤ እኮጎሬ መገኑ ዘማኒሃ ጉዕሚንከ ገለትጨሞሃ እሁን፤ ኣሚዕን። ");
INSERT INTO alw_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","መኑ ህካን አቶ መሳን መገኑ ገበእበ ሙልሰኖ ሄዕላቻተሰ ህግሽ ኣሴሰ፤ ሜንቱሰ ሆሮ ጎንን ኦሰኡ አጉርት ሮሰሞበእ ሃሌን ዶርቶኡ። ");
INSERT INTO alw_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ህትን ጎኑ ሮሰሞ ሃሌን ሜንቲን ኦሰኡ አጉርት ጎኑ ጎኒን ሜጡበ ሙልሰኖ ጠወ አቶኡ፤ ሉጨንሽሰ መሳን ሀስሰኖሰ ቅጣት ገይንከሰ ቶጋአ። ");
INSERT INTO alw_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","መኑ መገኑ ደጎተ ሀሱሆጎቤቺሃ አኡ ገበእበ ጠወ አቶተ መገኑ ሂለ ሰውቲሃ ህግሽ ኣሴሰ። ");
INSERT INTO alw_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ህካን እኮቤቺሃ ብድሊን፥ ሂልማን፥ እዲድማን፥ ተንኮን፥ ምቀኝማን፥ ነብሳሃ ሾን፥ ብታን፥ ጣንሶን፥ ሂለ ሄዕላቻን ጉዕሚን ዊንቶእሩለከ ህትን ሄዕምታእራን። ");
INSERT INTO alw_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","መን ሱዕመ ቤሳእሩ፥ መገኑ ግባእሩ፥ መነ ሆፍሳእሩ፥ ቦንታእሩ፥ ገዎንከሰ ድከኣእሩ፥ ሂለርቹ ሀሳእሩ፥ አኒሃለከ አመታ አዘዘንትበሩ፥ ");
INSERT INTO alw_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ሰውይታበእሩ፥ ዉለ ድጅታሩ፥ ኢተት ዮሰበእሩ፥ ጎደበ ጠረኛኖታን። ");
INSERT INTO alw_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","«ህትኔ ጠወ አታ መኑ ጉዕሙንኩ ሬሁ ሀስሰኖሰ» የኖ መገን ሕገ ደገን ህካን ጉዕመንከ አታአ፤ ጠለዕል ህካን አኡ እሁዕነ ህት አታ መነ ኬሰንስታአ። ");
INSERT INTO alw_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","አት ዎሎ መን አሌን ፈረዳንት መንቾ! አዪሁ እኮንትጎሬ ደባቡርታንትርቹ ዮሄበአ፤ መሰንትስ አት ዎሎ መን አሌን ፈረዳንት ሁኩ ፍርዱ መኑ አአኖሃ አታንትቤቺሃ ዎሎ መን አሌን ፈረዳንት ወክት ገይክ አሌን ፈረዳንቲት። ");
INSERT INTO alw_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ህትኔ ጠወ አአኖ መን አሌን መገኑ ፈረደኖ ፍርዱ ሀንቅ እሁስ ደንጋም። ");
INSERT INTO alw_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","አት ህትኔ ጠወ አአኖ መናን ፈረደን እሰ አታርቹ አታንቲሃ እኮንትጎሬ መገን ፍርዲች ፈቃንቲሃ አጉደኖሄትንዶ? ");
INSERT INTO alw_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ህከረንገ መገን ጎደብ ላፍመታ፥ እጀቁስለከ አታዕልስ በትኝ ህንቃንቲትንዶ? መገኑ አጉሩስ በትሾሄሁ ኬሳሃ ጩብክ ቶበታንትገ አኦሄተ እሁስ ደጋንትበእንዶ? ");
INSERT INTO alw_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ጠዉ እኮጎሬ ጎደበ ጠረኝማተክለከ ጩብክ ቶበቱ ግቦ ቀልቢሃክ መገን ኡሙርትለከ ሀንቅ ፍርዱ አሜተኖ በር ገይክ አሌን ኡሙዕርተ ጭምአታንቲት። ");
INSERT INTO alw_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","መሰንትስ መገኑ መት-መቲሃስ ሆጎስገ ኣሰኖስ። ");
INSERT INTO alw_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ህትን አታዕሊን ጡመ ሆጉተ አኢን ገለትለከ ኬዕምኝ በእበ ሄኡ ሀሳሀኑኡተ መገኑ ዘላለም ሄኡ ኣሰኖሰ። ");
INSERT INTO alw_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ገይሰ ጥቅም ኢትታሩ፥ ሀንቂሃ አዘዘሙ ግብ ክዝብሃ አዘዘንታ መኒሃ መገን ኡሙዕርትለከ በለት አሌሰ እካአ። ");
INSERT INTO alw_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ወዕና አይሁዳን ህከኒች ኤተሮን ግርካን ሂለርቹ አአኖ መን አሌን ጉዕማንን ኦርሸትለከ ጨነቀሙ አሜተኖሰ። ");
INSERT INTO alw_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ጠዉ እኮጎሬ አይሁዲሃ እኮ ግሪክ መኒሃ ጡመ ጠወ አአኖ መኒሃ ጉዕሚንከ ገለቱ፥ ኬዕምኙለከ ወገሬቱ ኣሰመኖሰ። ");
INSERT INTO alw_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","መሰንትስ መገኑ መን ሚንተ ለዕይ ፈረደኖበአ። ");
INSERT INTO alw_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ሕጉ ዮበኢሃ ጩብ አዕዮ መኑ ጉዕሙንኩ ሕጉ ሄዕበሰጎሬ በኣአ፤ ህትን ሕጉ ሄአንሰ ጩብ አታ መን አሌን ጉዕማንን ሕጊን ፈረደመኖሰ። ");
INSERT INTO alw_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","መሰንትስ መገን ብሬን ፈያኑተ እካእሩ ሕገ አገርታእረ ቤሉ ሕገ ሞጮጭት ሆጎ አሌ ሆሲስበሩ ፈያኑተ የመንት ዎለአንታበአ። ");
INSERT INTO alw_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ሙስ ሕጉ ዮሰበእ አይሁደ እኮበእ ኡመቱ ክልቀቲችሰ ሕጊሃስ አዘዘንታአ፤ ሁኩንን ለሊሰኖሁ መቱርቹሁ እሰ ሙስ ሕጉ ዮሰበእጎሬሁ ሕጉ የኖሃ አኡ ሀስሰኖሳሃ እሁስ ደጉሰ ለሊሰኖ። ");
INSERT INTO alw_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ሁኩንን ሕጉ የኖሁ ጉዕሙንኩ ቀልቤንከሰ ከተበሞሃ እሁስ ለሊሰኖ፤ ህትን ቀልቡሰ አሌሰ መሰከረኖ፤ መሰንትስ ቀልቤሰ ከተበሞሁ መት-መቶረ ዎቀሰኖሰ፤ መት-መቶረንገ እሰንተ ሀዕለኖሰ። ");
INSERT INTO alw_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ሁኩንን እሀኖሁ አን ዱዱብሳም እንጂል ላገ ሃሊን መገኑ መሲህ ኢስ አዲን መኑ አዕዮ ማጠሞ ጠው አሌን ፈረደኖ በርዪት። ");
INSERT INTO alw_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","ጠዉ እኮጎሬ አት ገዉክ «አን አይሁድቹሃን» ይቶንት ጎሬ፥ ሕጋን ድከኦንትጎሬ፥ መገኒሃ እሆንከክ ቦንቶንትጎሬ፥ ");
INSERT INTO alw_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","መገኑ ኢተኖርቹ ደጎንትጎሬ፥ ሕጊች ተማርቶንትቤቺሃ ጡመ ጠወ አጥራመት ደጎንትጎሬ፥ ");
INSERT INTO alw_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","አት «ቆቃኖተ አዎንሳንቹሃ ይቶንት ጎሬ፤ ቱንስቾን ዮሀኑኡንተ ኑርሃን ይቶንት ጎሬ፤ ");
INSERT INTO alw_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ገዋኑተ ተማርሳምሃን ይቶንት ጎሬ፥ ኦሱተ ተማርሳም ይቶንት ጎሬ» ህትን «ሕግ ሀንቂን ዊሙ ደጉ ዮኤ» ይታንት። ");
INSERT INTO alw_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","አት ዎሉ መነ ተማርስታንቲሁ ገዉክ ተማርስታንትበእንዶ? ህትን «ሞግቶኖቼ» ይተን አት ገዉንኩክ ሞግተንንዶ? ");
INSERT INTO alw_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ዝነተ አቶኖቼ ይተን አት ገዉንኩክ ዝነተ አተንንዶ? አት ሽርኬተ ሰገዱ እትታንትበአ፤ ጠዉ እኮጎሬ ክዝብ መገናካተ ሰገዴኖሰ ምነተ ዘረፈንንዶ? ");
INSERT INTO alw_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","አት መገን ሕጋን ድከኣንት፤ ጠዉ እኮጎሬ መገን ሕገ ድጅተን መገኑ ቦሮርሲሳንት። ");
INSERT INTO alw_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ሁኩንን «ክዕኔ መሳን መገን ሱዕሙ አይሁደ እህበ መን በላን ቦሮረመኖ» የመም ከተበሞጋት። ");
INSERT INTO alw_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ሕገ ዊንሽታንቲሃ እኮንትጎሬ ጡርከሙ ደግለለኖሄ፤ ጠዉ እኮጎሬ ሕገ ድጅታንቲሃ እኮንትጎሬ ኪ ጡርከመሙ ጡርከመንትበሀንገ ዎለአመኖ። ");
INSERT INTO alw_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ህካን እኮቤቺሃ ጡርከመምቡ አይሁደ እኮበእ ሕግ ትዛዝ አአኖሃ እኮጎሬ ጡርከመሙ ሆጉስ ጡርከመሞገ ዎለአመኖበእንዶ? ");
INSERT INTO alw_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ኬሳሃ ከተበሞ ሕጉ ሄአንኬለከ ጡርከመንቶንቲሃ እክ ሕገ ድጅታንትረ ማሊን ጡርከመሞበእሀንገ እክ ሕገ ዊንሸኖ አይሁደ እኮበእ መንቹ ኪ አሌን ፈረደኖ። ");
INSERT INTO alw_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ሱዕሚን አይሁደ እኮሁ ሀንቅሃ አይሁድቹሃበአ፤ ህትን አብልን ለለኖ ማል ጡርከሙ ሀንቅሃ ጡርከሙበአ። ");
INSERT INTO alw_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ሀንቅ አይሁድቹ ኣዚን አይሁድቹ እኮሃን፤ ሀንቅ ጡርከሙንኩ መገን አያኒን እሀኖ ቀልቢሃ ጡርከመሙሃ ቤሉ ሕጊን ከተበሞ ሃሊን ማልሃ ጡርከመሙበአ፤ ህትናሙ መንቹ ገለት ቶገኖሁ መገኒችት ቤሉ መኒችበአ። ");
INSERT INTO alw_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ቴሱ አይሁድቹ እሁ ቆሀኖሁ ሚሃት? ህከረንገ ጡርከሙ መ ደግለለኖ? ");
INSERT INTO alw_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","አይሁድቹ እሁ አቡ ጥቅሙ ዮስ፤ ወዕናንከ መገኑ ላገስ ኤገተ ኣሴኢሁ አይሁዲሃት። ");
INSERT INTO alw_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","ህከረ እሳች መት-መቱ አመዕነሙ ሆጋረ አመዕነሙ ሆጉሰ መገኑ አመዕነሞ እሁስ ፌሰኖንዶ? ");
INSERT INTO alw_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","ሆሮ ፌሰኖበአ! «ጠወኣንት ላጋች ኬዕዮሀኒን ሀንቅ መንቹ እካንት፤ ህትን ባለጋራክ ኦዳንት ወክት ገርታንት» የመም ከተበሞሀንገን መኑ ጉዕሙንኩ ክዝበኘ እኮጎሬ መገኑ ሀንቀኛሃን። ");
INSERT INTO alw_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ጠው እኮጎሬ ኒ ሀንቀኛ እሁ ሆጉ መገን ፈይመተ እሁስ ለሊሰኖሃ እኮች መ ይናም? መገኑ ጩብኔተኔሃ ቀጠዕዮኔጎር ፈረደኖሁ ሀንቅያበአ ይናምንዶ? ከንቤቾን ጠወዕናሚሁ መን ሰውትጋት። ");
INSERT INTO alw_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ህካን መገኑ ኤቡንከ፤ ህት እኮች መገኑ ኣዱንያ አሌን ዮ መን አሌን ፈረዶተ ሀት እክ አታለኖ? ");
INSERT INTO alw_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","ጠው እኮጎሬ አን ክዝበኘ እሁ መገን ሀንቀኞመተ ለሊሰኖሃለከ ኬዕምኝስ በርገኖሃ እኮች ቴሱ ኢለ ጩበኛ መንችገ አሌኤ ፈረደመኖኤንንዶ? ");
INSERT INTO alw_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","መት-መቱ መኑ «ጡመርቹ ደዕኖተ ሂለርቹ አዕኖ» ይን ጠወዕኖምሀንገ አት ሄሜን ቦሮርታኔት፤ እሰ አሌን ፈረዴኖ ፍርዱ ሀንቅያ ፍርደ። ");
INSERT INTO alw_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ቴሱ መ ጠወዕናም፤ ነኡ አይሁደ እኮበእ መኒች በትንስ ደግለሸቀማምረንዶ? ሆሮ ህትጎተበአ! ወዕናንከ መኑ ጉዕሙንኩ አይሁደ እኮ አይሁደ እኮበእሩ ጩብሃ ጠገንቶረ እሁሰ ሄጭ ኩሎም። ");
INSERT INTO alw_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","መሰንትስ «መቱ መንቹሁ ፈዩ ዮበአ፤ መቱሁ ሆሮ ዮበአ፤ ");
INSERT INTO alw_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","አጥራመተኖሁ መቱሁ ዮበአ፤ ህትን መቱ መንቹሁ መገኑ ሀሰኖሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ጉዕሙንኩሰ ዎቃኤ ገፈርቶኡ፤ ህትን ደግለልታበእረ እኮኡ። ጡመ ሆጉተ አአኖሁ ዮበአ፤ መቱሁ ሆሮ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","መነ ምዕርታ ሂለ ላገተ ጠወኢሃ አፎሰ ፈንተዕዮ ሎድጋት፤ አረቤንከሰ ጣንስታአ፤ የቡሮንከሰ ዎሪች መርዙ ዮሰራ። ");
INSERT INTO alw_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","አፎንከሰ ቦሮሩለከ ቁንቁቱ ዊሞሰ። ");
INSERT INTO alw_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ሎከሰ መን ቄጉ ዱኒሃ ደዕልታአ። ");
INSERT INTO alw_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ዎቃንከሰ ቤሱለከ ኦርሸት ዮኡ። ");
INSERT INTO alw_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ወገሬት ዎቃሃ ደጋበአ። ");
INSERT INTO alw_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","መገኑ ሆሮ ዋጅታበአ» ህት የመም ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","መኑ ጉዕሙንኩ አፎስ አፎተ ኣዱንያ አሌን ዮ መኑ ጉዕሙንኩ መገን ፍርድ ኣዜን እኮተ ሕጉ የኖሁ ጉዕመንከ ሕግ ኣዜን ዮ መኒሃ እሁስ ደንጋም። ");
INSERT INTO alw_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ህካን እኮቤቺሃ መኑ ጉዕሙንኩ መገን ብሬን ሕገ አገሪን ፈየ እሆተ አታለኖበአ፤ ሕጉ ጩቡ መሃጎሬ ለሊሰኖ። ");
INSERT INTO alw_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","ቴሱ እኮጎሬ መገኑ መነ ፈየ አአኖ ዎቆሁ ሕጊች አደደ ዎቄን እሁስ ለልዮኡ፤ ሁኩንን ሙስ ሕጊንለከ ነብያኖን መሰከረሞኡ። ");
INSERT INTO alw_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ሁኩንን አደዶመት ዮበኢሃ አመዕንታሀኑኡተ እኮ መሲህ ኢስን አመዕኒን ደገመኖ መገንተ ፈይመ። ");
INSERT INTO alw_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","መኑ ጉዕሙንኩ ጩብ አቶኡ፤ መገኑ ኣሴሰ ኬዕምኙ ጤዕይዮሰ። ");
INSERT INTO alw_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ህካን እኮቤቺሃ መኑ መሲህ ኢስ ወዝኖ አዲን መገን ኣስቶን ህትን ፈየ እኮኡ። ");
INSERT INTO alw_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","መገኑ መሲህ ኢሰ ክትመ አዕይ ኣሴኢሁ እሶን አመዕንታሩ ጉዕሙንኩ ቄጊንከስ ጩቢች መረርሲጩ አመዕነቲን ደእቶታት፤ መገኑ ካን አኡስ አታዕሊንከስ ወዕና ሄዕዮስ ጩብ አጉሪን ገይስ ሀንቅ ፍርደ ለሊሶታት። ");
INSERT INTO alw_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ህትን መገኑ ህካን አዕዮሁ ገዉስ ፈየ እሁስ ለሊሰኖሁ ኢሳን አመዕንታሀኑኡተ ፈየ አአኖሃ እሁስ ከን ዘማኔን ለሊሶታት። ");
INSERT INTO alw_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ቴሱ ገዎንተኔ ድከዕናምርቹ ዮበአ፤ መቶርቾን ድከዕናምበአ! ድከዕናምበእ መሰት መርቹሃን? ሕገ አገሪንትንዶ? ህትጎተበአ፤ ጠዉ እኮጎሬ አመዕነቲኒት። ");
INSERT INTO alw_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ህካን እኮቤቺሃ መገኑ መነ ፈየ አአኖሁ መኑ ሕግ ሆጉተ አኢን እሁዕነ አመዕነቲን እሁስ ደንጋም። ");
INSERT INTO alw_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ህከረንገ መገኑ አይሁድያ ጠለዕል መገኑንዶ? አይሁደ እኮበእ መኒሃ መገኑዋበእንዶ? ሀንቅንከ አይሁደ እኮበእ መኒሃ መገኑ። ");
INSERT INTO alw_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","መገኑ ሜጥቹሃን? ጡርከመንቶ አይሁደ እኮ ጡርከመንቶበእ አይሁደ እኮበኢሃ ፈየ አአኖሁ እሶት። ");
INSERT INTO alw_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ህከረ አመዕነት መሳን ሕገ ሻርናምንዶ? ህትጎተበአ! ሕገ ጠረኝንሳም ቤሉ ሻርናምበአ። ");
INSERT INTO alw_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","ማልን አበኑኔ እብራሂም «ደኤእ» ይናምርቹ መርቹሃን? ");
INSERT INTO alw_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","እብራሂም አዕዮ ሆጎን ፈየ እኮ እቃን ድከአኖርቹ ሄአኖስ እቅ፤ እሁን ቤሉ መገንሀኔን ድከአኖርቹ ዮስበአ። ");
INSERT INTO alw_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","መሰንትስ ጠሊለ መጻፋን መ የኖ? መጻፋን «እብራሂም መገኖን አመዕኔእ፤ አመዕነቱንኩስ ፈየ እክ ዎለአሞስ» የመም ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","ሆጉተ አአኖ መንቺሃ ደሞዙስ አዕዮ ሆጎስገ ዎለአመኖስ ቤሉ ኣስቶገ ዎለአመኖስበአ። ");
INSERT INTO alw_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","መኑ ሆጉት ሄዕበስጎሬ ጩበኛ ፈየ አአኖ መገኖን አመዕኔ ጎሬ አመዕነቱስ ፈየ እክ ዎለአመኖስ። ");
INSERT INTO alw_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ህትን መቱርቹሃ አኡዕነ ፈየ እኮሀንገ መገኑ ዎለአኖስ መንቹ ማሰአሞሃ እሁስ ደዉድ ጠወአን ");
INSERT INTO alw_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«ብድሉሰ አጉረሞሰለከ ጩቡሰ ፈቁን የመሞሰ መኑ ማሰአንቶእረ! ");
INSERT INTO alw_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ህትን ቀርቹ ጩብስ ዎለአኖበእ መንቹ ማሰአሞእሃን!» ይዮኡ። ");
INSERT INTO alw_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ህከረ ኩ ማሰት ጡርከመሞ መኒሃትንዶ ጡርከመምበ መኒሃት? ነኡን « ‹እብራሂም አመዕነቱ ፈየ እክ ዎለአሞስ› የመሞኡ» ይኖም። ");
INSERT INTO alw_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","እብራሂም አመዕነቱ ፈየ እክ ዎለአሞሲሁ ሀትጎታን? ጡርከመሞች ኤተሮንትንዶ ጡርከመሙዕናንት? ጡርከመሙዕናን ብርታት ቤሉ ጡርከመሞች ኤተሮኒበአ። ");
INSERT INTO alw_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","እብራሂም ጡርከመሙዕናን ብርተ ዮስ አመዕነቲን ደኤ ፈይመ መላተ እሆተ ጡርከመሞ፤ ህካን እኮሁ እሰ ፈያኑተ እክ ዎለአንቶተ ጡርከመንቱዕናን አመዕንታ መኒ ጉዕሚንከ አነ እሆታት። ");
INSERT INTO alw_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ህትን እብራሂም ጡርከመሞ መኒሃ አነሃን፤ ጠዉ እኮጎሬ ጡርከመሞ ጉዕሚሃሰ እሁዕነ አኑኔ እብራሂም ጡርከመሙዕናን ብርንተ ዮስ አመዕነት ምሳልተ አዎንታ መኒሃ አነ እሆታት። ");
INSERT INTO alw_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","እብራሂሚሃለከ ዘሬተስ ኣዱንያ አል ረገአኖ ተብሶ አሜቾሰ ሕገ አገሪን እሁዕናን አመዕነቲን ደገንታ ፈይማኒት። ");
INSERT INTO alw_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ተብሳስ ረገኣሩ ሕገ አገርታ መነ እኮጎሬ አመዕነቱ ከልበ እሀኖ፤ ህትን ተብሶንኩ ዋጉ ዮበኢሃ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","መሰንትስ ሕጉ መገን ኡሙርተ ኤበኖ፤ ጠው እኮጎሬ ሕጉ ዮበእቤቾን ሕገ ድጁ ሄአኖበአ። ");
INSERT INTO alw_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ተብሶስ ጀመሮሁ አመዕነት አሌንት፤ ሁኩ ተብሶሁ እብራሂም ዘሬተ ጉዕሚንከ ህከ ተብሳሃ ረገኣኢሁ መገን ኣስቶን ኣሰሞሃ እሁስ ተሬገጠሞኡ፤ ሁኩንን ሕገ አዎንታ መኒሃ ጠለዕል እሁዕነ እብራሂምገ አመዕንቶሀኑኡተ ጉዕሚንካት፤ ከን ሃሊን እብራሂም ጉዕሚንከኔ አነሃን። ");
INSERT INTO alw_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","አብራሂምተኔ «ልግብያ ኡመቲሃ አነ አዕዮንኬ» የመም ከተበሞኡ፤ እስ ሬቶእረ ሬሆች ኬሰኖሀኒንለከ ዮበኢሃ ሄአኖገ አዕይ ገአኖ አመዕኔ መገን ብሬን ጉዕሚንከኔ አነሃን። ");
INSERT INTO alw_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","እብራሂም ዘርክ አበ ፈከንታአ የመም ከተበሞገን ልግብያ ኡመቲሃ አነ እሀኖገ አመዕኔኢሁለከ ተብሳሃ አዕዮሁ መቱርቹሃ ተብሳሃ አኤንበ ጠዋኒት። ");
INSERT INTO alw_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","እስ ጥቤ ዘማን እኮስቤቺሃ ጅስሙስ ሆግ እሎተ አታለኖበእገለከ ሳረ እልትባተለከ ባልቆኢተ እኮጎሬ አመዕነቲን ሆጎበአ። ");
INSERT INTO alw_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","አመዕነቲንከስ ጠረኘ እክ መገኒሃ ኬዕምኝ ኣሴ ቤሉ መገኑ ኣሴ ተብሴን አመዕኑ ሆጊን ሆሮ ሸክዮበአ። ");
INSERT INTO alw_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","መገኑ ኣሴስ ተብሳሃ አኡ አታለኖገ ዊመ ቀልቢንከስ አመዕነኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ከኒች ኬዕዮሀኒንት እብራሂም አመዕነቱስ ፈየ እክ ዎለአሞሲሁ። ");
INSERT INTO alw_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ጠዉ እኮጎሬ «ፈየ እክ ዎለአሞስ» ይታ ላገት ከተበሞሁ ጠለዕል እብራሂሚሃበአ። ");
INSERT INTO alw_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ጠለዕል እብራሂሚሃ እሁዕነ ኔሳሃ በርግይት፤ ቀርቹኔ ኢሰ ሬሆች ኬሾስ መገኖን አመዕንናም ኔሳሁ አመዕነቱኔ ፈየ እክ ዎለአመኖኔ። ");
INSERT INTO alw_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ኩ ቀርቹኔ ኢስን ጩብኔተኔሃ ሬሆተ ህግሴን ኣሴመሲሁለከ ኔሳሁ መገን ብሬን ፈየ አኦኔተ ሬሆች ኬዕዮሃን። ");
INSERT INTO alw_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ቴሱ ነኡ ፈይመተ ደእኖሚሁ አመዕነቲን እኮቤቺሃ ቀርቾንከኔ መሲህ ኢስ አዲን መገኒን ወገሬቱ ዮኔ። ");
INSERT INTO alw_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","መሲህ ኢስ አዲን ቴሱ ኡርኖም መገን ኣስቶበ አመዕነቲን ኣንጎም፤ ህትን ተብሴን መገን ኬዕምኝ ቤቀማምረ እንኮምቤቺሃ ሙንደዕናም። ");
INSERT INTO alw_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ህከንን ጠለዕል እሁዕነ ኦርሸት አታዕሊን ጠረኜን ኡሩ ደግሲሰኖሃ እሁስ ደንጋምቤቺሃ ኦሪሻንከኔ ሙንደዕናም፤ ");
INSERT INTO alw_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","አታዕሉ ጠረኝመተ ኤበኖሀንገን ህትን ጠረኝመት ተብሳሃ ኤባገ ደንጋም። ");
INSERT INTO alw_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","መገኑ ኣሴኔ ጠሊለ አያን አዲን መገን ኢተት ቀልቤንተኔ አበ ዊንቶቤቺሃ ተብሶስ ሙልሰኖኔበአ። ");
INSERT INTO alw_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ነኡ ላፋኑተ እንኮምገን መገኑ ዬ ወክቱ ኢሌ ወክት መሲህ ኢስ ጩበኛኖተኔሃ ሬዮኡ። ");
INSERT INTO alw_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ፈየ መንች ወጥ ሬሀኖ መንቹ ደጉ አበ ኦሪሰኖ፤ እኮጎሬ ጡመ መንች ወጥ ሬሀኖ መንቹ ደጊሃ አታሌኖሃ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","ጠዉ እኮጎሬ ነኡ ጩበኛኑተ እንኮምገን መሲህ ኢስ ኒ ወጥ ሬዮኡ፤ ሁኩንን መገኑ ሄንከ ኢተኖኔጎሬ ለሊሰኖ። ");
INSERT INTO alw_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ቴሱ ነኡ ፈየ እንኮሚሁ መሲህ ኢስ ቄጊን እኮች በትንስን መገን ኡሙዕሬች ጡምናሚሁ ኢሲኒት። ");
INSERT INTO alw_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","መሰንትስ ነኡ መገን ባለጋረተ እንኮምገን ቤትስ ሬሆን መገኒን ሀራዕረሞም፤ ሀራዕረሞሚች ኤተሮን እሲችን አበ ኢስ ሄኦን ጡምናም። ");
INSERT INTO alw_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ህካን እሁዕነ ቴሁ መገኒን ሜጡበ ሀራሩተ ደእናሚሁ ቀርቺንከኔ መሲህ ኢስ አዲን መገኒን ሙንደዕናም። ");
INSERT INTO alw_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","መቶ መንች መሳን ጩቡ ከ ኣዱንያ አል አሜቾ፤ ጩብ መሳንን ሬሁት አሜቶኡ፤ ህትን መኑ ጉዕሙንኩ ጩብ አዕዮቤቺሃ ሬሁት ጉዕመ መን አሌን አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","መሰንትስ ሙስ ሕጉ ኣሰመኖሀኒች ሄጭ ጩቡ ኡለ አሌን ሄዕዮ እቅ፤ ጠው እኮጎሬ ሕጉ ዮበእ ወክት ጩቡ ገዉንኩስ ጩብገ ዎለአመኖበአ። ");
INSERT INTO alw_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","እሁን ቤሉ ኣደምገ ሕገ ድጅት ጩብ አቶበእ መን አሌን ሆሮ ፈቁዕነ ሬሁት አደሚች ኬሽ ሙሰ ኢለ መን አሌን ጉዕማን ሹምነቱ ደእቶኡ። ");
INSERT INTO alw_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","ጠዉ እኮጎሬ መገን ኣስቶ ሽልማቱ መን ጩብጋበአ፤ መቶ መንች ጩብ መሳን ልግቡሰ ሬቶገን መገን ኣስቶንለከ መቶ መንች መሲህ ኢስ መሳን ደገሞ ኣስቶ ሽልማቱ ልግቤ መኒሃ ትርፈ ትርፊን ኣሰሞ። ");
INSERT INTO alw_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ህትን መገኑ ጠለዕለ ኣሴኔ ሽልማቱ ኤቦ ኣስቱት መቶ መንች ጩቡ ኤቦ ላልችጋበአ፤ መቶ መንች ጩብ መሳን ኣሰሞ ፍርዱ ቅጣት ኤቦ፤ ልግብያ ጩብ መሳን ኣሰሞ መገን ሽልማቱ ፈይመተ ኤቦ። ");
INSERT INTO alw_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","መቶ መንች ጩብተኔሃ ሬሁት ህከ መቶ መንች አዲን ኣሰንቶች ህከኒች አበ መገን ኣስቱታ፥ ጠሊልመስ ኣስቱታ ኣእታ መኑ መቶ መሲህ ኢስ አዲን ሄኢን ሄኣአ፤ መቶ መንች ጩብ መሳን ሬሁት መን አሌን ጉዕማን ሹምነቱ ደእቶኢች መገን ትርፈ ትርፊን እኮ ኣስቱትለከ ፈይመ ሽልማት ቶጎሩ መቶ መንች መሲህ ኢስ መሳን በተዕዮ ሄኡ ደእት ነገሳአ። ");
INSERT INTO alw_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ቴሱ መቶ መንች ኣደም ጩቡ ቅጣት ፍርደ መን አሌን ጉዕማን ኤቦገ ህትን መትስ መሲህ ኢስ ፈይመ ሆጉት ልግብ መነ ቅጣቲች ነጠ አዕይ ሄኡ ኣሰኖሰ። ");
INSERT INTO alw_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","መሰንትስ መቶ መንች አዘዘሙ ሆግ መሳን ልግቡ መኑ ጩበኛኑተ እኮገን ህትን መቶ መንች አዘዘም መሳን ልግቡሰ ፈየ እኮኡ። ");
INSERT INTO alw_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","ጩቡ በተኦተ ሕጉ አሜቾ፤ ጠዉ እኮጎሬ ጩቡ በተዕዮ ቁድሬን መገን ኣስቱት አበ በተኦኡ። ");
INSERT INTO alw_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ኩን እኮሁ ጩቡ ሬሁተ ኤቢን ነገሾገን መገን ኣስቱት ፈይመተ ኤቢን ህትን ቀርቾ መሲህ ኢስ አዲን ዘላለም ሄኡ ኤቢን ነገሶታት። ");
INSERT INTO alw_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ቴሱ መ ይናም? መገን ኣስቱት በተኦተ ጩብ አዕነን ሄዕኑንዶ? ");
INSERT INTO alw_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","ሆሮ ህትጎተበአ፤ ነኡ ጩብ አኢች ሬኖምሩ ሀት እንክ ጩብ አዕነን ሄዕናም? ");
INSERT INTO alw_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","መሲህ ኢስን ሜጡበ እንኮተ ጠመቀሞምሩ ጉዕሙንኩኔ ሬሁስ ቤቀማምረ እሁኔ ጠመቀሞንከኔ ደጌነንተበእንዶ? ");
INSERT INTO alw_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ነኡሁ እሲን ሜጡበ ጠመቀማም ወክት ሬሆንከስ ሜጡበ እንኮተ እሲን ሜጡበ ሞገሞም፤ መገን አላመት መሲህ ኢስን መገን ኬዕምኝ ዎልቃን ሬሆች ኬሾገን ነኡሁ ህትን ሃዕሮ ሄኡ ሄዕኖተ ኬዕናም። ");
INSERT INTO alw_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ሬሆንከስ እሲን ሜጡበ እንኮሚች ህትን ኬኦንከሲ እሲን ሜጡበ እንካም። ");
INSERT INTO alw_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ከ ኤተሩ ጩብሃ ሮሰተ እንካምበእገለከ ጩበኛሙ ጅስሙኔ ኒች ሽቆተ ኑባጴ ጅስሙኔ ኢስን ሜጡበ ሰቀለሞገ ደንጋም። ");
INSERT INTO alw_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","መሰንትስ ሬዮ መንቹ ጩቢሃ ጠገሚች ነጠሃን። ");
INSERT INTO alw_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ጠዉ እኮጎሬ መሲህ ኢስን ሜጡበ ሬኖምጎሬ እሲን ሜጡበ ሩሂን ሄዕናምገ አመዕንናም። ");
INSERT INTO alw_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","መሰንትስ መሲህ ሬሆች ኬዕዮቤቺሃ ለንኪሃ ሆሮ ሬሀኖበእገለከ ሬሁት ከ ኤተሩ እስ አሌን ሹምነቱ ዮስበእገ ደንጋም። ");
INSERT INTO alw_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","እስ ሬሀን ጩብ ዎልቀተ ቢጦተ ሜጦረን ሹል ሬዮኡ፤ ጠዉ እኮጎሬ ሩሂን ሄአን መገን ኬዕምኚሃ ሄአኖ። ");
INSERT INTO alw_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ህትን አዕኑ ጩቢሃ ሬቴን መሲህ ኢሲን መገኒሃ ሩሂን ሄኤነንተገ ገውክዕኔ ዎለዕዬ። ");
INSERT INTO alw_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","ህካን እኮቤቺሃ ማል ሰውቲሃ ጠገንቴነንተገ አኦተ ሬሀኖ ማላክዕኔ ጩቡ ሀላዕሉንከህዕኔ። ");
INSERT INTO alw_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ጅስሙክዕኔ ሂለ ሆጎ ኦዳተ አቴን ጩቢሃ ኣቶኖቼ፤ ጠዉ እኮጎሬ ሬሆች ሄእ አደ ህጎ መንገ አቴን ገዉክዕኔ መገኒሃ ኣስዬ፤ ህትን ጅስመክዕኔ ጠሊለ ኦዳተ አቴን መገኒሃ ኣስዬ። ");
INSERT INTO alw_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ቴሱ አዕኑ ሄኤነንታሁ መገን ኣስቶ ኣዜን ዮንተቤቺሃ ሕጊች ዎሮን እህበቤቺሃ ጩቡ ጠቆተ ሀስሰኖበአ። ");
INSERT INTO alw_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ህከረ መ ይናም? ነኡ ሕጊች ዎሮን እሁዕነ መገን ኣስቶች ዎሮን ዮምቤቺሃ ጩብ አዕኑንዶ? ሆሮ ህትጎተበአ። ");
INSERT INTO alw_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ገዉክዕኔ መቶ መኒቺሃ ካድንችገ ጠገንቶኖተ ሆንጠኬንተጎሬ ህከ ጠገንቴነንተ መንቺሃ ካዲንቹ እሁክዕኔ ደጌነንተበእንዶ? ጩቢ ካዲመተ እኬንተጎሬ ጩቡ ሬሁተ ኤበኖ፤ ህትን መገኒ ካዲመተ እኬንተጎሬ መገኑ ፈየ አአኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","አዕኑ ወዕናንከ ጩብ ካዲመተ እኬንታ እቅ፤ ጠዉ እኮጎሬ ቴሱ ቶጌንተ ትምርቲሃ ቀልቢን አዘዘንቴንተቤቺሃ መገኒሃ ገለቱ እሁንስ። ");
INSERT INTO alw_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ጩብ ሮሶማች ነጠ ፉልቴን ፈይመ ካዲመተ እኬንታአ። ");
INSERT INTO alw_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","አን ህትን መኒሃ ኣገኖ አፌን ጠወኣሚሁ ክዕኔሃ ኣገኖህዕኔገ ይዪት፤ አዕኑ ከኒች ብርተ ጅስመክዕኔ ኒጃስ ካዲመ አቴን ሆንጠህሴንተ እቅ፤ ሁኩንን ጠሊለ እኮበእ ዎቃሃ አዎንሰኖ፤ ጠዉ እኮጎሬ ቴሱ ጅስመክዕኔ ፈይመ ካዲመ አቴን ሆንጠህሼ፤ እስን ጠሊልመ አደ አዎንሰኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","አዕኑ ጩብ ካዲመተ እኬንተ ወክት ፈይመ ሆጉተ አቴነንተ ግዳጁ ሞጮጨመኖህዕኔበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ህከን ጠዊች ደእቴንተርቹ ም ዮኡ? ህከን ጠዊች ኤተሩስ ሬሁተ እኮቤቺሃ ቴሱ ሙልሰኖህዕኔርች ቤሉ መቱርቹሃ ደእቴንታበአ። ");
INSERT INTO alw_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","እኮጎሬ ቴሱ ጩብ ሮሶማች ፉልቴን መገን ሮሰተ እኬንታአ፤ ህከን ወጥ ጠሊልመተ ደእቴንተ፤ መጨረሹስ ዘላለሚሃ ሄኤኑሃ ሄኡ። ");
INSERT INTO alw_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","መሰንትስ ጩብ ዋጉ ሬሁተ፤ ጠዉ እኮጎሬ መገን ሽልማቱ ቀርቹሃኔ መሲህ ኢስ መሳን ዘላለሚሃ ሄኤኑሃ ሄኡ። ");
INSERT INTO alw_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","አመኤ ኦሶ! አን ሕገ ደጋ መኒሃ ጠወኣሚት፤ ሕጉ መኑ ፎሊን ዮ ጌሳን ገዘአኖሃ እሁስ ደጌነንተበእንዶ? ");
INSERT INTO alw_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ምሳሌተ ምኒሃ እኮ መንቹት ምንሴ አኑ ፎሊን ዮ ጌሳን ምንሴ አኒን ሕጊን ኡሱረንቶእተ፤ ጠዉ እኮጎሬ ምንሴ አኑ ሬዮች ምንሴ መንቺች ኡሱረንቶ ሕጊች ገፈረንቶእተ። ");
INSERT INTO alw_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ህካን እኮቤቺሃ ምንሴ አኑ ፎሊን ሄአን ዎሎ ጎናን ገልቶጎሬ ዝነተ አቶ ዬኖሴ፤ ጠዉ እኮጎሬ ምንሴ አኑ ሬዮ ጎሬ ምንሴ መንቺን ኡሱረንቶ ሕጊች ገፈርሲጭቶቤቺሃ ዎሎ ጎናን ገልቶጎሬ ዝነተ አቶ ዬኖሴበአ። ");
INSERT INTO alw_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","አመኤ ኦሶ! ህትን አዕኑ መሲህ ጅስመ እኬንተቤቺሃ እስ ሬሆን ሕጊሃ ሬቴንታአ፤ ህካን እኮቤቺሃ ነኡ መገን ላልቹ ላልኖተ አዕኑ ዎሎ መንችረ ሁኩንን ሬሆች ኬዕዮ መሲህረ ኤኬንታአ። ");
INSERT INTO alw_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","መሰንትስ ነኡ ማል ሰውትገ ሄዕናም ወክት ሕግ መሳን ኬአኖ ሂለ ሄዕላቸኔ ሬሆ ላልቹ ላልኖተ ጅስምኔ ኣዜን ሆጉተ አአኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","እኮጎሬ ቴሱ ኡሱር አፎኔ ሕጊች ሬሆን መለዕለሜኖ ጌሰ ጠገሞም ሕጊች ሂረሞም፤ ህካን እኮቤቺሃ ከኒች ኤተሮን መገን አያኒን ሃዕሮ ሄኦን ሄዕናም ቤሉ ኑባቹ ሕጉ የኖ ሃሌን ሄዕናምበአ። ");
INSERT INTO alw_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ህከረ መ ይናም? ሕጉ ገዉስ ጩብያንዶ? ሆሮ ህትጎተበአ፤ ጠዉ እኮጎሬ ሕጉ ሄዕዮበእቃን ጩቡ መሃጎሬ ደንጋምበአ እቅ፤ መሰንትስ ሕጉ «ሂለርቹ ሄዕላቶት» ይዮበእቃን ሄዕላቱ መሃጎሬ ደንጋምበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","ጠዉ እኮጎሬ ሕጉ ዮበእ ጎሬ ጩቡ ሬዮሃ እኮቤቺሃ ጩቡ ትዛዝ አዲን እድለ ደእ ሂለ ሄዕላቸተ ጉዕመንከ ኣዜንከኤ ከለቆ። ");
INSERT INTO alw_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","አን ዎዕነ ሕጉ ዮበእ ወክት ፎሊን ሄኣም እቅ፤ ጠዉ እኮጎሬ ሕግ ትዛዙ አሜቾ ወክት ጩቢሃ ፎሉ ሄዕዮስ እቅ፤ እኮጎሬ አን ሬዮም። ");
INSERT INTO alw_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ሁኩ ፎል ኣሶተ ኣሰሞ ሕግ ትዛዙ ኢ አሌን ሬሁተ ኤቦ። ");
INSERT INTO alw_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","መሰንትስ ጩቡ ሕግ ትዛዝ አዲን እድለ ደእ ጣንሴኤ፤ ትዛዝ መሳንን ሼኤ። ");
INSERT INTO alw_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ህካን እኮቤቺሃ ሕጉ ጠሊላሃን፤ እሲን ከተበሞ ትዛዙንኩ ጠሊለ፥ ሀንቅያለከ ጡመሃን። ");
INSERT INTO alw_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ህከረ ሁኩ ጡመ እኮ ጠዉ ኤሳሃ ሬሁተ ኤቦኤ ዩሃንዶ? ሆሮ ህትጎተበአ፤ ህከን ጡመ ጠው አዲን ሬሁተ ኤሳሃ ኤቦሁ ጩብየ፤ ሁኩን እኮሁ ጩቡ ጩብ እሁስ ለሎታትለከ ጩቡ አበ ሂለ እሁስ ትዛዝ አዲን ደገሞታት። ");
INSERT INTO alw_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ነኡ ሕጉ ጠሊለ አያኒሃ እሁስ ደንጋም፤ ጠዉ እኮጎሬ አን ጠሊለ አያኒሃ እኮምበእ ጩብ ሮሶማተ ህረሞምያ መንቹ። ");
INSERT INTO alw_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","አን አኦተ ኢታም ጠወ እሁዕነ ግባም ጠወ አኣምቤቺሃ ገይኤ ሆጉንተ አጥረመታምበአ። ");
INSERT INTO alw_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ቴሱ አን ሀስበርቹ አኣሚሃ እኮምጎሬ ሕጉ ጡመ እሁስ ህከኒን ኢተቀማም። ");
INSERT INTO alw_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ህት እኮች ህካን አአኖሁ ኣዜእ ዮእሃ ጩብ ቤሉ አኔበአ። ");
INSERT INTO alw_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","ኢ ኣዜን ህከረንገ ጅስማንከኤ ጡሙ ጠዉ መቱርቹሁ ሄእበገ ደጋም፤ መሰንትስ ጡመ ጠወ ሄዕላቾምጎሬ አኦተ አታላምበአ። ");
INSERT INTO alw_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ህትን አኦተ ሀሳም ጡመ ጠወ እሁዕናን አኦተ ሀስበ ሂለ ጠወ አኣሚት። ");
INSERT INTO alw_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ቴሱ አን ሀሾምበእ ሂለ ጠወ አኣሚሃ እኮች ህካን አአኖሁ ኣዜንከኤ ዮእሃ ጩብ ቤሉ አኔበአ ዩሃን። ");
INSERT INTO alw_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ጡመ ጠወ አኦተ ሀሰን ሂለ ጠወ አኣምገ አአኖኤ ዎሉ ሕጉ አአን ሄዕዮገ ደጋም። ");
INSERT INTO alw_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","መሰንትስ አን ኣዜንከኤ መገን ሕጊን ሙንደኣም። ");
INSERT INTO alw_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ጠው እኮጎሬ አን አኣም ጠው ጉዕሙንኩ ሁኩ ዎሉ ሕጉ አአን ዬገ ለኣም፤ ኩ ሕጉንኩ ቀልቤንከኤ ኣገቀመኖ መገን ሕግን ሜጡበ ኣገቀመኖበአ፤ ኩ ሕጉንኩ ኤሳሃ ጩብ ዎልቃተ ጠገማምገ አአኖኤሃ እሀን ህከን ሕግገን መ አኣምጎሬ ወሰነኖኤ። ");
INSERT INTO alw_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","አን ሄንከ ምርተዕዮምየ መንቹ! ከን ሬሀኖ ጅስሚችኤ አይ ጡምሰኖኤ? ");
INSERT INTO alw_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","ቀርቹሃኔ መሲህ ኢሲን መገኒሃ ገለቱ ኢሉስ፤ ቴሱ አን ቀልቤንከኤ መገን ሕጊሃ ጠገማም፤ እኮጎሬ ማሊንከኤ ጩብ ሕጊሃ ጠገማም። ");
INSERT INTO alw_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ህካን እኮቤቺሃ መሲህ ኢስን ሄአኖ መን አሌን ቴሱ ፍርዱ ፈረደመኖሰበአ። ");
INSERT INTO alw_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","መሰንት መሲህ ኢስን ዮ ሄኡ ኣሰኖ ጠሊለ አያን ሕጉ ጩቢችለከ ሬሆ ሕጊች ሰዎልድማን ፉሽዮሄ። ");
INSERT INTO alw_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ኒ ጩበኘ ሀል ዶሮተ ሕጊሃ ወልቀት ዮስበአ፤ ጠዉ እኮጎሬ ሕጉ አኦተ አታልባሃ መገኑ ጩቡ ዮበእ ቤቱስ ጩበኘ እንኮም ኒን መን ማቆን መነ አዕይ ሶክ ጩብ ሀል ፈረጆስ። ");
INSERT INTO alw_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ኩን እኮሁ ማል ሰውትገ እሁዕነ ጠሊሉ አያኑ ሀሰኖጊን ሄዕናም ኒን ሕጉ ጠዕመኖኔሁ ፈይመት ዊንቶታት። ");
INSERT INTO alw_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","መሰንትስ ማል ሰውትገ ሄኣሩ ማል ጠወንከ ሰዉ ይታአ፤ ጠሊለ አያኒ ሰውትገ ሄኣእሩ ጠሊለ አያን ጠወንከ ሰውይታአ። ");
INSERT INTO alw_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ማል ጠወ ሰውዩ ሬሁተ ኤበኖ፤ ጠሊለ አያን ጠወ ሰውዩ ሄኡለከ ወገሬት ኣሰኖ። ");
INSERT INTO alw_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","መሰንትስ ማል ጠወ ሰውየኖ መንቹ መገን ሕጊሃ አዘዘመኖበእቤቺሃለከ አዘዘሙ አታለምበስቤቺሃ መገኒሃ መስቹሃን። ");
INSERT INTO alw_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ማል ሰውትገ ሄኣእሩ መገኑ ሙንዲሲሶተ አታልታበአ። ");
INSERT INTO alw_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","ሀንቅንከ መገን አያኑ ኣዜንተክዕኔ ሄዕዮች አዕኑሁ ህትን ዮንታሁ ማሊን እሁዕነ ጠሊለ አያኒንት፤ መሲህ አያኑ ኣዜስ ዮስበኢሁ አዪሁ መሲህየበአ። ");
INSERT INTO alw_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ጠዉ እኮጎሬ መሲህ ኣዜንተክዕኔ ሄዕዮች መሃ ማሉክዕኔ ጩብ መሳን ሬሀኖጎሬሁ ፎሉክዕኔ ፈይማን ሄአኖሃን። ");
INSERT INTO alw_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ህትን ኢሰ ሬሆች ኬሾሁ መገኑሃን፤ እስ አያኑ ኣዜንከክዕኔ ሄዕዮ ጎሬ መሲህ ኢሰ ሬሆች ኬሾ መገኑ ኣዜንከክዕኔ ሄአኖ አያንከስ ሬሀኖ ማልሃክዕኔ ሄኡ ኣሰኖ። ");
INSERT INTO alw_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","አመኤ ኦሶ! ኤዶ ዮኔ፤ ጠዉ እኮጎሬ ሁኩ ኤዶሁ ማል ሃሽኣቶገ ሄዕኖታበአ። ");
INSERT INTO alw_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ህካን እኮቤቺሃ ማል ሃሽኣቶገ ሄኤንተ ጎሬ ሬቴነንተ፤ ጠዉ እኮጎሬ ጠሊለ አያን ወልቃን ማል ሆጉተ ሽቴንተጎሬ ፎሊን ሄኤነንተ። ");
INSERT INTO alw_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","መገን አያኑ አዎንሰኖሰሩ ጉዕሙንኩ መገንተ እለ። ");
INSERT INTO alw_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ህካን እኮቤቺሃ አዕኑ «አበ! ኢ አና!» ይቴን ገእቶኖተ አታልሲሰኖህዕኔ መገን እለተ አአኖ ጠሊለ አያነ ቶጌንታ ቤሉ ዋጅቴን ሄኦኖተ ፈንቀሽ ኣግሰኖ ሮስማ ቀልብ ቶጌንታበአ። ");
INSERT INTO alw_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","መገን አያኑ ኒ አያኒን ሜጡበ እክ ነኡ መገን እለተ እሁኔ ገይሃኔ መሰከረኖ። ");
INSERT INTO alw_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ህትን መገን እለተ እንኮሚች መገኒች ረገዕናም፤ ህትን መሲህ ኢስን ሜጡበ ኬዕምኝ ደዕኖተ እስን ኦርጨቀሞምጎሬ እስን ሜጡበ ረገዕናምረ። ");
INSERT INTO alw_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","ከን ወክት ኦርሸት ከ ኤተሩ ኔሳሃ አሜተኖ ኬዕምኝን ሆሮ ቅጡ እሆተ አታለኖበእገ አዕይ ሰውያም። ");
INSERT INTO alw_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","ክልቀቱ ጉዕሙንኩ መገን እለት ለልታ በር ሄዕላተን አገርታአ። ");
INSERT INTO alw_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","ክልቀቱ ተሰ እኮ ጠዊሃ ህግሽ ኣሰሞኡ፤ ሁኩንን ገይስ ሄዕላቻን እሁዕነ ህትን እሆተ መገኑ ፈቀጆቤቺሃት፤ እኮጎሬ መገኑ ተብሳሃ ኣስዮኡ። ");
INSERT INTO alw_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ተብሶስ ክልቀቱ ገዉንኩስ በእ ሮስማች ሰዎልድማን ፉልኬዕይ መገን እለ ኬዕምኝ ዎምነቲን ቤቀማንቹ እሆታት። ");
INSERT INTO alw_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","ክልቀቱ ጉዕሙንኩ ከበሬ እለ ኒጠኛገ ዮ ኦርሸ ጨነቃን ሄኡስ ደንጋም። ");
INSERT INTO alw_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","ጠዉ እኮጎሬ ኒጠኛ አሌን ዮኢሁ ጠለዕል ክልቀትያበአ፤ መገኑ ዎሉ ኣስቱተ ኣሰኖገን አጥራመተሞሃ እኮሃ ጠሊለ አያነ ወዕኔሃ ቶንጎም ነኡ መገኑ ኦሱስ እሁኔ ለሊሶተለከ ሬሄን ሸሚች ነጠ አዕይ ፉሾኔተ ኢለ ኣዝኔ ጅስማን ኒንጠንለከ አገዕርነን ደገማም። ");
INSERT INTO alw_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","ጡምኖሚሃ እንኮምጎሬ ጡሙኔ ዊመ ዊሚን ሀንቅ እክ ለሎተ ኢለ ተብሴን ሄዕናም፤ ነኡ ጡምኖሚሁ ህከን ተብሴኔት፤ ጠዉ እኮጎሬ ተብሳ አዕናምርቹ ለለኖሃ እኮጎሬ ተብሳሃ እሁስ ፈቀኖ፤ ለለኖርቹ አይ ተብሳሃ አአኖ? ");
INSERT INTO alw_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","ለዕንበርቹ ተብሳ አዕኖምጎሬ አታዕሊን አገዕርናም። ");
INSERT INTO alw_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ህትን ሀት መገኑ ኡጩ ሀስሰኖኔ ጎሬ ደንጋምበእቤቺሃ ጠሊሉ አያኑ ሆንጌንከኔ ሀዕለኖኔ፤ ላጋን ኩሌን አታሌንበ ሃሊን ጠሊሉ አያኑ ዱአ አአኖኔ። ");
INSERT INTO alw_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","መን ቀልብ መረመረኖ መገኑ ጠሊለ አያን ሰውቱ መሃጎሬ ደገኖ፤ ጠሊሉ አያኑ መገንረ እኮሀኑኡተ ሸፈአኖ መገን ፍቃድጋት። ");
INSERT INTO alw_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","መገኑ ኢትታሀኑኡተለከ ሰውትስገ ገአንቶሀኑኡተ መገኑ ጉዕመርቹንከ ጡምማተ አአኖገ ደንጋም። ");
INSERT INTO alw_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ኩን እኮ መሰት ሄጭ ደጎሳሃ ቤቱስ አጉዳገለከ ቤቱስ ልግብያ አመስ ኦሶ በሊች ሀንገፈ እሀኖገ መገኑ ሄጭ ወሰኞቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","ወዕና ወሰኞሰረ ገኤሰ፤ ህትን ህከ ገኤሰረ ወሰኞ፤ ህከ ወሰኞሰረ ኬዕምሾሰ። ");
INSERT INTO alw_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ህከረ ከ ጠዊሃ መ ይናም? መገኑ ኔሳሃ ሀዕለኖኔሃ እኮች ሀንበዕለመኖኔሁ አዬት? ");
INSERT INTO alw_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","መቱዋስ ቤቲሃ አሙዙዕነ ጉዕሚንከኔ ህግሽ ኣሴ መገኑ ቤትንከስ ሜጡበ ጉዕመርቹንከ ህትን አሰኖኔበእንዶ? ");
INSERT INTO alw_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","መገኑ መጠሮሰሃ አይ ከሰሶተ አታለኖ? ፈየ አአኖሁ ገዎንከስ። ");
INSERT INTO alw_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","እሰ አሌን ፈረደኖ አዬት? መሲህ ኢስ እሰ አሌን ፈረደኖንዶ? እስ ኔሳሃ ሬዮሃ፥ ሬሆች ኬዕዮሃ፥ መገን መኬ አዲን አፉዕልዮሃንለከ ኔሳሃ ዱአ አአኖሃን። ");
INSERT INTO alw_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","መሲህ ኢስ ኢታች አደ አአኖኔሁ አዬት? ኦርሸተንዶ? ጭንቀተንዶ? ሸረሙሃንዶ? ጎሩዋንዶ? ከልመተንዶ? አደጋንዶ? በገዙሃንዶ? ");
INSERT INTO alw_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","እስን «ኪተኔሃ ጉዕመ በርንከ ሽታኔ፤ ጎረጤኖ ሆለገ ዎለአሞም» የመም ከተበሞጋት። ");
INSERT INTO alw_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","እኮጎሬ ህከን ጠዋን ጉዕማንን ነኡ ኢቴኔ እሲን ከ ጠወ ጉዕመንከ ድለ አኢን ቄልታሀኑኡች በተዕናም። ");
INSERT INTO alw_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","መሰንትስ ሬሆተጎሬ፥ ሄኡሃጎሬ፥ መላይከታጎሬ፥ ሹመተጎሬ፥ ቴሱ ዮ ጠወሃጎሬ፥ ኤተሮን አሜተኖሃ ጠወሃጎሬ፥ ሀከን ዎልቃሞሃጎሬ፥ ");
INSERT INTO alw_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ጎት ዩሃጎሬ፥ ሙግ ዩሃጎሬ ሀኩ ክልቀቱሁ እኮጎሬ ቀርቾሃ መሲህ ኢስን ደእኖም መገን ኢታች አደ አኦተ አታለኖ መቱርቹሁ ዮበኢሃ እሁስ ደጎም። ");
INSERT INTO alw_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","መሲሂን ሀንቅ ጠወኣም፤ ክዝባምበአ፤ ጠሊለ አያኒን አዎነኖ ቀልቡኤ ክዝባምበእገ መሰከረኖኤ። ");
INSERT INTO alw_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","አቡ ሻዙትለከ ሙርተእቡ ጨነቀሙ ቀልቤንከኤ ዮኡ። ");
INSERT INTO alw_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","መሰንትስ እሉኤ እኮ ወገኒሃኤ ይ አን መሲሂች አደ እክ ቦሮሩ እልዮኤ እቃን ኢታም እቅ። ");
INSERT INTO alw_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","እሰ እስራኤላውያኖታን፤ ህትን መገኑ እሰንተ እለስ አዕዮሰ፤ ኬዕምኝስ ለሊሾሰ፤ ወኣድ ላገተ ኣጎሰ፤ ሕገ ኣሴሰ፤ ሀንቅ ሰገድ ሴረ ለሊሾሰ፤ ተብሴ ላገት ኣሴሰ። ");
INSERT INTO alw_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ህትን ወዕኔ አናኖች አሜቶእራን፤ መሲሁ ማሊን አሜቾሁ እሰ ደቦቺት፤ እስ ጉዕሚችን ሎረሃን፤ መገኒሃ ዘላለሚሃ ሹኩሩ ኢሉስ፤ ኣሚዕን! ");
INSERT INTO alw_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ጠዉ እኮጎሬ መገን ላገት ሻረንቶኡ ዩሃበአ፤ መሰንትስ እስራኤላውያኖ ዘርት ዊመ ዊሚን ሀንቅ እስራኤላውያኖተበአ። ");
INSERT INTO alw_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ህትን እብራሂም ዘርተ እኮሁ ጉዕሙንኩ ሀንቅ እብራሂም ኦሶተ ዩሃበአ፤ ጠዉ እኮጎሬ «ዘርክ ገአንታኢሁ ኢሳቂንት» ዬስቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","ህካን እኮቤቺሃ ሮሰሞ ዎቄን ጠለዕል ማሊን እለንቶሩ መገንተ እለበአ፤ ጠዉ እኮጎሬ ዘርት እክ ዎለአንታሩ ጠለዕል ተብሴ ላገተ ኦሱ። ");
INSERT INTO alw_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ተብሴ ላገንት «አሜተኖ ዘማን ከ ወክት ፈንቀል አሜታም፤ ሳረ ለባ ጩል እልታአ» ይታእተ እቅ። ");
INSERT INTO alw_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","ህካን ጠለዕለ እሁዕነ ርብቀ ሜጦ መንቺች ሁኩንን አነኔ እኮ ኢሳቂች መልተተ እልቶተ ላፈተ እኮ ወክት ");
INSERT INTO alw_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","መገኑ መጠረኖሁ ለሙንኩ እለት እለንቱዕናን ሂለ እኮ ጡመ አቱዕነ ሄጭ ");
INSERT INTO alw_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ሆጎን እሁዕነ እስ ገአኖ ሃሊን እሁስ ለልሲሃ መገኑ ርብቀ «ሀንገፉ ማዕኒሃስ ጠገመኖ» ዬሴ። ");
INSERT INTO alw_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ሁኩን እኮሁ «ያቁበ ኢትዮም፤ ጠዉ እኮጎሬ ኤሳ ግቦም» የመም ከተበሞጋት። ");
INSERT INTO alw_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","ቴሱ መ ጠወዕናም? መገን አዲን ሉጨንሹ ዮእንዶ? ሆሮ ህትጎተበአ። ");
INSERT INTO alw_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","መሰንትስ መገኑ ሙሰ «መረርሲጩ ሀሾምሀኒሃ መረርሲጫም፤ አሙዛንስሀኒንከ አሙዛም» ይዮስ። ");
INSERT INTO alw_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ህካን እኮቤቺሃ መገኑ መነ መጠረኖሁ መኑ ሀሾ ሃሊን ህከረንገ መን ሆጎን እሁዕነ መገን መረርሲጪንት። ");
INSERT INTO alw_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","መሰንትስ መጻፋን ፉራኦኔተኔሃ «ዎልቀኤ ኪን ለሊሶተለከ ሱዕሙኤን ኣዱንያ አሌን ጉዕማንን ደገሞተ ዎመ አዕዮንኬ» የመም ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ህካን እኮቤቺሃ መገኑ ሀሾሃ አዬሁ ማረኖስ፤ ህትን ሀሾሀ አዬሁ ቀልብስ ዱድሰኖ። ");
INSERT INTO alw_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","ቴሱ «መገን ሰውት ከሞተ አታለኖሁ ዮበኢች ሚሃ ሉጨንሺሀኔ መገኑ ዎቀሰኖኔት?» ይቴነንታሃ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ጠዉ እኮጎሬ ኮ መንቾ! መገኒን ኦደሚሃ አታልታንቲሁ አት አዬት? ትብ ኦዳት መክሾሲሃ «ህት አት መክሶንቴኤሁ ሚሃት?» ዮተ አታለኖንዶ? ");
INSERT INTO alw_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ትብ ኦዳት መክሰኖሴሁ መቶ ትቢች መት ኦዳተ ኬዕምኚሃ ህትን ዎልት ኦዳንተ ሂለርቺሃ መክሶተ ዎልቀት ዮስበእንዶ? ");
INSERT INTO alw_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","መገኑ ኡሙዕርስ ለልሶተለከ ዎልቀስ ለሊሶተ ሀሽ በኢሃ ቅጥይቶ ኡሙዕሬ ኦዳተ ልግብ ወክት አታዕሌሰ። ");
INSERT INTO alw_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ህካን አዕዮንኩ ዎዕናንከ ኬዕምኚሃ ቅጥአዕዮ ማርቶ ኦዳ ኬዕምኝስ በትኝ ለሊሶታት። ");
INSERT INTO alw_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","ኔሳሃ መረርሲጭ ኦዳንተስ ጠለዕል አይሁዲች እሁዕነ አይሁደ እህበ መኒች ገእዮኔ። ");
INSERT INTO alw_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ሁኩንን እኮሁ መገኑ ሆሴ መጻፋን «ኢ ኡመትኤ እክበረ ‹ኡመቱኤ› ይ ገኣም፤ ኢተሞበእ ኡመትንከ ‹አን ኢታም ኡመት› ይ ገኣም፤ ");
INSERT INTO alw_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ህትን ‹አዕኑ ኢሃ ኡመትበአ› ዬመሰ ቤቾን ‹ሄአኖ መገን እለተ› የመንት ገአንታአ» ዩሃን። ");
INSERT INTO alw_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ህትን እስያስ እስራኤል ኦሶተኔሃ ላገስ ጎት አዕይ «ሄንከሃ እስራኤል ኦሶ ዎሊንሹ ባር ኣዝ ሽፋር ጌሰ እኮጎሬ እሳች ፈቆሀኑኡች ጠለዕል ቀዉሰ ጡምታአ። ");
INSERT INTO alw_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","መሰንትስ ቀርቹ ደዕል ኡለ አሌን ሹል ፈረደኖ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ህትን እስያስ «ጎጎት ቀርቹ መገኑ መን ዘርተ ፌሾበእቃን ሶዶምለከ ጎሞር ከተምገ እንካም እቅ» ይ ዎዕናንከ ጠወዕዮ። ");
INSERT INTO alw_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ቴሱ መ ይናም? ፈይመተ ሀስቡ አይሁደ እህቡ መኑ ፈይመተ ደእቶኡ፤ ሁኩ ፈይመት አመዕነቲን ደገንታእታን። ");
INSERT INTO alw_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","ጠዉ እኮጎሬ እስራኤል መኑ ሕገ አገሪን ደገንታ ፈይመት ሀሰን ሕገ አገሩ ሆጎቤቺሃ ፈይመተ ደኢሃ አታልቶበአ። ");
INSERT INTO alw_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","«ሚሃት ፍይመተ ደእቶበአ?» ዬማእቃን እሰ ፈይመተ ሀሶኢሁ አመዕነቲን እሁዕነ ሆጎን እኮቤቺሃት፤ ህካን እኮቤቺሃ ቆለኖ ክኖን ቆዕልቶኡ። ");
INSERT INTO alw_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ሁኩንን «ሁኩዕኑ መነ ቆለኖ ክኑ ጽኦናን አፉሻም፤ ሁኩ ክኑ መነ ቆለን ኡጀኖሃን፤ ህከን ክኖን አመዕነኖሁ አዪሁ ሙለኖበአ» የመም ከተበሞገን ህከን ክኖን ቆዕልቶኡ። ");
INSERT INTO alw_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","አመኤ ኦሶ! እስራኤል መኑ ጡሞተ ቀልቤንተኤ አበ ሄዕላታምለከ ዱአ አኣም። ");
INSERT INTO alw_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","መሰንትስ ሀንቅ ደጊን እሁ ሆጉሃሰ ቤሉ እሰ መገኒሃ አዘዘንቶተ ጠረኝስ ሀሳእረ እሁሰ አን ገውንኩኤ መሰከራንሰ። ");
INSERT INTO alw_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","እሰ መገን ፈይመተ ደጉዕናን ገይሰ ፈይመተ አዎኑ ሀስ መገን ፈይማተ አዘዘንቶበአ። ");
INSERT INTO alw_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ህካን እኮቤቺሃ አመዕናኑት ጉዕሙንኩ ፈይቶተ መሲህ ሕገ ዊንሼእ። ");
INSERT INTO alw_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ሙስ «ሕገ አገሪን ደገንታ ፈይመተ አአኖ መንቹ ሁኩ ሕጉ የኖሃ አአኖ ጉዕሙንኩ ፎሊን ሄአኖ» ይ ከተቦኡ። ");
INSERT INTO alw_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","ጠዉ እኮጎሬ አመዕነቲን ደጌኖ ፈይመተ «ቀልቤንከክ ሰማሃ አይ ፉለኖ?» ይቶት፤ ሁኩንን መሲህ ኡለተ ድርሲሃት። ");
INSERT INTO alw_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ህትን ቀልቤንከክ «አዛቤን አይ ድረኖ?» ይቶት፤ ሁኩንን መሲህ ሬሆች ኤብሃት። ");
INSERT INTO alw_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","ጠዉ እኮጎሬ መ ይታእ? «አፎንከክለከ ቀልቤንከክ እክ መገን ላገት ሆንጠኮኡ» ይታአ፤ ህትን ነኡ ዱዱብስናሚሁ አመዕነትተ ላገ። ");
INSERT INTO alw_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","አት ኢስ ቀርቹ እሁስ አፌንከክ መሰከርቶንትጎሬለከ መገኑ ሬሆች ኬሾስገ ቀልቤንከክ አመዕንቶንትጎሬ ጡምታንት። ");
INSERT INTO alw_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","መሰንትስ መኑ ቀልቤስ አመዕን ፈየ እሀኖ፤ ህትን አፎንከስ መሰከር ጡመኖ። ");
INSERT INTO alw_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ጠሊለ መጻፋን «እሲን አመዕነኖሁ አዪሁ ሙለኖበአ» የመም ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","መሰንትስ መቱ ቀርቹ ኢስ ጉዕሚንከ ቀርቹ እኮቤቺሃ አይሁደለከ አይሁደ እህበ መን በላን አደዶመት ዮበአ፤ እስን ኡጭታስሀኑኡተ ጉዕሚንከ በረከስ በትሽ ኣሰኖሰ። ");
INSERT INTO alw_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","መሰንትስ «ቀርች ሱዕመ ገአኖሁ ጉዕሙንኩ ጡመኖ» የመሞኡ። ");
INSERT INTO alw_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","ጠዉ እኮጎሬ አመዕንቱዕናን ሀት አት ገእቶተ አታልታአ? ህትን እስተኔሃ ሞጮጭቱዕናን ሀት እክ አመዕንታአ? ተማርሰኖ መንቹ ዮበኢሃ ሀት እክ ሞጮጭቶተ አታልታአ? ");
INSERT INTO alw_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","ተሽት ላገተ ዱዱብስታሩ ሶሀንቱዕናን ሀት እክ ላገስ ዱዱብስቶተ አታልታአ? ሁኩንን «ጡመ ዱዱቡ ኩልታሩ አሜቱሰ ሄንከ ተሽ የኖ?» የመም ከተበሞጋት። ");
INSERT INTO alw_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","ጠዉ እኮጎሬ እስያስ «ቀርቾ! ነኡ ጠወዕኖም ጠወ አይ አመዕንዮኡ?» ዬገን ጉዕሙንኩሰ ተሽት ላጋተ አዘዘንቶበአ። ");
INSERT INTO alw_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ህካን እኮቤቺሃ አመዕነቱ አሜተኖሁ ሞጮጭኒት፤ ሞጮጩንኩ መሲህተኔሃ ኩለንታ ላጋቺት። ");
INSERT INTO alw_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ህንዴ ጠዕሞህዕኔ፤ እሰ ሞጮጩ ሆጎቤቺሃትንዶ? ጠሊለ መጻፋን «ላገሰ ኣዱንያ አሌን ጉዕማንን ሞጮጨንቶኡ፤ ጠወኦርቹንኩ ኡለ ገበለ ኢልዮኡ» የመም ከተበሞቤቺሃ ሀንቅንከ ሞጮጭቶኡ። ");
INSERT INTO alw_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ቴሁ ጠዕሞህዕኔ፤ እስራኤላውያኑት ላገስ ደጎበአ ዩሃንዶ? ህካን ዬንበሰገ ሙስ ሄጭ «ኡመት እክበሀኑኡተ ሰጭቴነንተገ አኣንክዕኔ፤ አጥራመትበ ኡመት መሳን ኡሙዕርቴነንተገ አኣንክዕኔ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ህትን እስያስ «ኤሳሃ ሀሾበእ መኒሃ ደገሞም፤ ኢተኔንከ ጠዕምትበ መኒንከ ገዉእ ለሊሾም» ይ መለል ጠወእዮኡ። ");
INSERT INTO alw_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","ጠዉ እኮጎሬ እስራኤልተኔሃ «ሾከለከ አዘዘምበ መንበ በር ጉዕመንከ አንገኤ ሂሮም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ህንዴ ጠዕማም፤ መገኑ ኡመትስ ኡጀኖንዶ? ሆሮ ህትጎተበአ፤ መሰንትስ አን ገዉንኩእ እስራኤላውቹሃንለከ እብራሂም ዘሬች ቢንያም ደቦሃን። ");
INSERT INTO alw_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","መገኑ ዎዕነ ሄጭ መረጮ ኡመት ኡጅዮሰበአ፤ እስራኤልተኔሃ እልያስ መገን ብሬን ኦጆገ መጻፉ የኖሃ ደጌነንተበእንዶ? ");
INSERT INTO alw_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ህከን ወክቴን እልያስ «ቀርቾ! ነቢያከክ ሽቶኡ፤ ኬሳሃ ክትመ ሆንጠህሴኖሄ ጠረጴዘ ጉዕመንከ ድጅቶኡ፤ አን ሜጡንኩእ ፈቆም፤ እሰን ኤሳሃ ሽቶተ ሀሳኢት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ጠዉ እኮጎሬ መገኑ መ ይ ፈንቀሼስ? መገኑንኩ «አን ‹በኣለ› ዬኖ ሽርኬሃ ሰገድቡ ለመለ ኩሜ መነ ገይሀእ ፌሾም» ዬስ። ");
INSERT INTO alw_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ከን ዘማኔን መገን ኣስቶን መጠረንት ፈቆ ቀዉ መኑ ዮኡ። ");
INSERT INTO alw_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ምርጩስ ኣስቶን እኮጎሬ ሆጎኒበአ ዩሃን፤ ሆጎን እኮጎሬ ኣስቱት ኣስቱተ እሁስ ፈቀኖ። ");
INSERT INTO alw_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","እስራኤል መኑ ሀሶኢሃ ደዕቶበአ? እኮጎሬ መገኑ መረጮሰሩ ደዕቶኡ፤ ፈቆሩ ቀልብሰ ዱድሶኡ። ");
INSERT INTO alw_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ሁኩንን «መገኑ ቀልብሰ ጀልአዕዮሰ፤ ህከኒሃ ከበሬ ኢለሬተ እሌንተሰ ለኦበአ፤ መጫንተሰን ሞጮጭቶበአ» የመም ከተበሞጋት። ");
INSERT INTO alw_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ህትን ደዉድ «ማዱሰ አፈኖ ዎሻደ ኡጀኖ ኤሎሃ እክ ኦሪሱንሰ! አቶ ሂሉርቹ ገይሰ አሌን እሁን! ");
INSERT INTO alw_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","እልሰ ለኣበእገ ቱንሲሱን፤ ረመዙሰ ኦርሻን ጉዕመ ወክት ቁቾሃ እሁን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ህንዴ ቴሁ ጠዕማም፤ እስራኤል መኑ ሉሶኢሁ ኬእበ ኡቡ ኡቦታትንዶ? ሆሮ ህትጎተበአ፤ ህከን ወጥ እሰ ሰጭቶተ እስራኤል መኑ ጩብ አቶ መሳን አይሁደ እህቡ መኑ ጡሙ ደኤእ። ");
INSERT INTO alw_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","ጠዉ እኮጎሬ እስራኤል መን ሉጨንሹ ከን ኣዱንያ አል መኒሃ በረከተ ደግሲሾችለከ እሰ ኡቡ አይሁደ እህበ መኒሃ በረከተ እኮች ጉዕሙንኩሰ ፈቆ እቃን ሄንኩ ልግቡ በረከት ደገንታ እቅ። ");
INSERT INTO alw_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ቴሱ ጠወኣሚሁ ክዕኔሃ አይሁደ እኬንበ መኒሃት፤ አይሁደ እኬንበ መኒሃ ሶሀሞሚሃ እኮምቤቺሃ ክድማተኤ አቡ ኬዕምኙ ዮኤ። ");
INSERT INTO alw_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ካን አኡኤ ማል እሉእ እኮእረ አይሁደ ሰጭታጋ አኢሃት፤ ከን ሃሌን አይደጎ እሳች መት-መቱሰ ጡምታገ አኦተ አታላሚሃ እሆተ አታለኖ። ");
INSERT INTO alw_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","መሰንትስ አይሁድ ኡቡ ኣዱንያ አሌን ዮ መኒሃ መገኒን ሀራዕረሙ ኤቦች እሰ መገን አደ ፈንቀሉንገ ሀት እሀኖ? ሁኩን ሬሆች ኬእተገ። ");
INSERT INTO alw_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","መቶ ደን ቡኮች ወዕኔ እስ መገኒሃ ጠሊሎሃ እኮች ቡኩት ጉዕሙንኩ ጠሊለ እካአ፤ ህትን መቶ ሀቅ ጠጱ ጠሊለ እኮች ሀሙሰ ጠሊላኑተ እካአ። ");
INSERT INTO alw_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","አይሁዱ ጋሮ ወርች ሀቅጋት፤ እሰ በሊች መቱ ጌሱ ሀሙ ሙርተዕይ ኡባንለከ አዕኑ ኡድም ወርች ሀመ እኬንታሩ እስቤቾን እኬን ጠጱስ ዱንያተለከ በረከተ ቤቀንቴንተረ እኬንተ ጎር ");
INSERT INTO alw_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ህከን ቢጠንት ኡቦ ሀማን ቦንቶት፤ እኮጎሬ ቦንቶንትጎር ጠጱስ ኬሳሃ እጅዮሄ ቤሉ ጠጰ እጅቶንቲሁ ኬሳሃ እሁ ሆጉክ ደግ። ");
INSERT INTO alw_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","ጠዉ እኮጎሬ «ሀማከት ቢጠንት ኡቦኢሁ አን እሰቤቾን እሆታት» ይቴነንታሃ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ሁኩን ሀንቅሃን፤ እሰ ቢጠንቶኢሁ አመዕኑ ሆጎቤቺሃት፤ አዕኑ አመዕነት መሳን አጳቀንቴን ኡርቴንታአ፤ ህካን እኮቤቺሃ ዋጅዬ ቤሉ ቦንቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","መሰንትስ መገኑ ዎዕናሃ ነጴ ሀሚሃ አሙዝባች ኬሳሃ አሙዘኖበአ። ");
INSERT INTO alw_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ቴሱ መገን አሙዙስለከ ዋጅሲሱሲ ለእ፤ ዋጅሲሱንኩስ ለሊሰኖሁ ኡቦ ሀዕኑኡአሌኒት፤ እኮጎሬ መገን አሙዞንከስ ጠረኝት ሄኦንትጎሬ ኬሳሃት፤ ሁኩን ዮበእ ጎሬ አዕኑሁ ሙርተኤን ኡቤነንተ። ");
INSERT INTO alw_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","እሰን አመዕኑ ሆጊች ፈንቀልቶጎሬ ዎዕናሃ ሙርተኦ ቤቾን ፈንቀልት ኣጋአ፤ መሰንትስ መገኑ ወዕኔሰቤቹ ፈንቀሽ ኣግሶሰተ አታለኖ። ");
INSERT INTO alw_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","አት ክልቀቴንከክ ኡድም ወርቹ ሀቀ እኮሀኒች ሙርተእ ከለቀንቶንትገ እሁዕነ ጡመ ወርቾን ኣጎንቲች በትሽን ሁኩ ክልቀቴንከስ ዮስ ሀሙ ገይስ ወርች አሌን ሀት ኣጋበአ። ");
INSERT INTO alw_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","አመኤ ኦሶ! ቀልባመተ እኬንታሃ አጉዱንከህዕኔ፤ ህካን እኮቤቺሃ ማጠሞ ጠወ ደጎኖተ ሀሳም፤ አይሁደ እክበሩ መሲህ አመዕንት መገኑ ሀሰኖ ወሊንሸ ኢልቶተ ኢለ ዱድሰኖ አያኑ መት-መቶ እስራኤላውያኖ አሌን እኮ። ");
INSERT INTO alw_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ህትን «ጡምሳንቹ ጽኦኒች አሜተኖ፤ ያቁብ ዘሬች ጉዕሚችን ሂልመተ ከመኖ፤ ");
INSERT INTO alw_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ጩብሰ ፈቁን ዬም ወክት ክዕኔኤን ኣጋም ወኣድ ላገት ከኒት» የመም ከተበሞገን እስራኤል መኑ ጉዕሙንኩ ጡምታአ። ");
INSERT INTO alw_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","እስራኤላውያኑት ተሽት ላገተ ሞጮጩ ግቢንከሰ ክዕኔተኔሃ መገን ዲነ እኮኡ፤ እኮጎሬ መጠረሚን አናኖሰተኔሃ መገኑ ኢተኖሰራን። ");
INSERT INTO alw_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","መሰንትስ መገን ኣስቱትለከ መገን መጠሩ ዶረምበሃን። ");
INSERT INTO alw_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","አዕኑ ዎዕናሃ መገኒሃ አዘዘሙ ግቤንታአ፤ ቴሁ እኮጎሬ እስራኤል መኑ አዘዘሙ ሆጊን ማርቱተ ደዕቴንተገን ");
INSERT INTO alw_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","አዕኑ ደእቴንተ ማርቱተ እሳሁ ህከ ማርቱተ ደእቶተ ቴሁ አዘዘንቶበአ። ");
INSERT INTO alw_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","መሰንትስ መገኑ ጉዕማንከ መኒሃ ማርቱስ ለሊሶተ ጉዕሙንኩ መኑ አዘዘምበገ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","መገን ቀባጡትለከ ሀይመት ደጉ ሄንከ ጥዕላሸሃን? ፍርዱስ መረመሬን እሌንቡሃን፤ ዎቆንኩስ ለልበሃን። ");
INSERT INTO alw_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","«ቀርች ቀልብ ጠወ ደገኖሁ አዬት? እሱሃ ሸዘኖሲሁ አዬት? ");
INSERT INTO alw_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","መገኒሃ ሌቄሰኖሁ ሌቄሾንከ ኣአኖሁ አዬት?» ");
INSERT INTO alw_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","መሰንትስ ጉዕሙርቹንኩ እሲች፥ እሲንትለከ እሲሃት፤ እሲንከ ዘላለሚሃ ኬዕምኙ እሲሃ እሁስ! ኣሚዕን! ");
INSERT INTO alw_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ቴሁ አመኤ ኦሶ! ጅስመክዕኔ መገኒሃ አደ እኮሃ ሙንዲሲሰኖለከ ሄአኖ ክትመ አቴን ሆንጠህሶኖተ መገን መረርሲጪን ኡጫንክዕኔ፤ ሁኩንን አዕኑ መገኒሃ ሆንጠህሶኖተ ሀስሰኖሃ ሀንቂን እኮ ሰገዱዋክዕኔ። ");
INSERT INTO alw_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","ህትን ጡመ ሙንዲሲሰኖለከ ንጃሱ ዮበእ መገን ሰውቱ መሃጎር አጥራመቴን ደጎኖተ ቀልቡክዕኔ ሃዕሮ እክ ሄኡክዕኔ ዶረሙን ቤሉ ከን ኣዱንያ አል መነ አጉዶኖቼ። ");
INSERT INTO alw_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","«ክዕኔ በላን መት-መቱንኩክዕኔ መገኑ ኣሴህዕኔ አመዕነት ጌሲን ጡምማን ሰውዩን ቤሉ ገይስተኔሃ ሀስሰኖሀኒች በትሽ ቦኒን ሰውዩንከ» ይ መገኑ ኣሴኤ ኣስቶን ሸዛንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","መቶ ጅስማን ልግቡ ብሊቱ ዮኔሀንገለከ ህከን ብሊት ሆጉት ጉዕመንት አደ እኮገን ");
INSERT INTO alw_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ነኡ ሄንከ ልግብ እንኮምጎሬሁ መሲሁ መቱሃ ጅስመ፤ መቶ ጅስም ብልት እንኮምቤቺሃ ገገይንከኔ ሜጡ እንኮም። ");
INSERT INTO alw_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","መገኒች ኣሰንቶኔ ኣስቶገን አደዱ ኣስቱት ዮኔ፤ ራገ ጠወኡ እኮጎሬ አመዕነትኔ ጌሲን ራገ ጠወዕኑን። ");
INSERT INTO alw_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ካደመኖሁ ክድማንከስ ጠረኙን፤ ተማርሰኖንኩ ተማርሶንከስ ጠረኙን። ");
INSERT INTO alw_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ህትን ሸዘኖሁ ሸዞንከስ ጠረኙን፤ ኣሰኖንኩ ቀልቢችስ ኬሽ ኣሱን፤ ገሸኖንኩ ጠረኝ ገሹን፤ መረርሲጨኖንኩ ሙንዲኖን መረርሲጩን። ");
INSERT INTO alw_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","ስንስንት ዮበኢ ሀንቅ ኢተት ሄኡንክዕኔ፤ ሂለ ጠወ ግቤ፤ ጡመርቹ አዎኜ። ");
INSERT INTO alw_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","ህትን ገገዉክዕኔ ጠረኝቴን ኢተቀሜ፤ መት-መቱክዕኔ ኬዕምሼ። ");
INSERT INTO alw_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","ዋንክዕሉ ዮበኢሃ ጠረኝቴን ዊመ ቀልቢን ቀርቹ ካደሜ። ");
INSERT INTO alw_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","ተብሴን ሙንደዕዬ፤ ኦርሸተ እጀቅዬ፤ ጉዕመ ወክትንከ ዱአ አዕዬ፤ ");
INSERT INTO alw_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","አመዕንቶ አመኦሱተ ኦርሸሰ ወክት ሀዕልዬ፤ ኮሀ ቶጌ። ");
INSERT INTO alw_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","ሸርታህዕኔረ ማሰዕዬ፤ ማሰዕዬሰ ቤሉ ቦሮርቶኖቼሰ። ");
INSERT INTO alw_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ህትን ሙንደኣሀኑኡን ሜጡበ ሙንደዕዬ፤ ኦኣሀኑኡን ሜጡበ ኦዕዬ። ");
INSERT INTO alw_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","ገገውንኩክዕኔ ኢታን ሄዕዬ፤ ገውክዕኔ ሎርሱ አጉርቴን ቡጥቻኖን ሜጡበ ሄዕዬ «ኢ ቤሉ ዎሉ ደገኖሁ ዮበአ» ይቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","ጉዕማንከ መን ብሬን ጡመ ጠወ አዕዬ ቤሉ አዬሃዉ ሂለ አዕዮ ወጥ ሂለ ጠወ አቴን ፈንቀሽቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ህትን አታልሲሾህዕኔ ጎሬ መኒን ጉዕሚንን ወገሬቲን ሄዕዬ። ");
INSERT INTO alw_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ኢ ጃላ፥ «ቀርቹኔ መገኑ ‹ገዱተ ፉሉ ኢሃን፤ አን ገዱተ ፉላም› ዬእ» የመም ከተበሞቤቺሃ መገን ኡሙዕሬተ ቤቹ ኣስዬ ቤሉ አዕኑ ገዉክዕኔ ገዱተ ፉልቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ህከን ወጥ ባለጋሩክ ጎራዬጎሬ እትስስ፤ ሰገቦስጎሬ አግስ፤ ህካን አኦንከክ ሙልሳንት። ");
INSERT INTO alw_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","ህካን እኮቤቺሃ ሂለ ጠወ ጡመ ጠወ አኢን ቄል ቤሉ ሂለ ጠዊን ቄለንቶት። ");
INSERT INTO alw_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","ዳኝነቱ ጉዕሙንኩ ኣሰመኖሁ መገኒች እኮቤቺሃለከ ቴሱ ዮ ዳኛኑት መገኑ ዳኛ አዕዮሰረ እኮቤቺሃ መኑ ጉዕሙንኩ ገሽታ ሹማተ አዘዘሙ ሀስሰኖሰ። ");
INSERT INTO alw_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ህካን እኮቤቺሃ ዳኛኖን ሂልማን ኬአኖሁ ጉዕሙንኩ መገን ትዛዝ ቶገኖበአ፤ አዘዘምባሁ ጉዕሙንኩ ገይስ አሌን ፍርደ ኤበኖ። ");
INSERT INTO alw_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","ሹመት ሂለርቹ አታ መን ቤሉ ጡመርቹ አታ መነ ዋጅሲሳበአ፤ ሹሙ ዋጅሲሰኖሄበዕገ ሀሰንንዶ? ጡመርቹ አእ፤ እስን ገለትጨኖሄ። ");
INSERT INTO alw_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","መሰንትስ እስ ሂለ አታረ ቀጠአኖ መገንየ ካድመ፤ ጠዉ እኮጎሬ ሹሙ ብሰ ቆዕረኖሁ ጠለዕላን እህበቤቺሃ ሂለርቹ አቶንትጎሬ ሹመ ዋጅ፤ ህትን እስን ሂለርቹ አስታእረ ቀጠኦን መገን ኡሙዕርተ ለሊሰኖሃ መገንየ ካዲንቹ። ");
INSERT INTO alw_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ህካን እኮቤቺሃ ሹማተ አዘዘሙ ሀስሰኖ፤ ሁኩንን ኡሙዕርተ ዋጅን ጠለዕለ እሁዕነ ቀልቡክዕኔ ቀነጠኖህዕኔቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","አዕኑ ግብር ባቴነንታሁ ሹማተ አዘዘሙ ሀስሰኖህዕኔቤቺሃት፤ መሰንትስ ሹመት ህካን አኢን መገኒሃ ካደንታእራን። ");
INSERT INTO alw_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","ቴሱ ጉዕማንከ መኒሃ አኡ ሀስሰኖሃ አዕዬ፤ ግብር ባቱ ሀስሰኖሀኒሃ ግብረ ባቼ፤ ቀረጠ ባቱ ሀስሰኖሀኒሃ ቀረጠ ሙሬ፤ ዋጁ ሀስሰኖሀኒሃ ዋጅዬ፤ ኬዕምኙ ሀስሰኖሰሀኒሃ ኬዕምኝ ኣስዬ። ");
INSERT INTO alw_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","ገገዉክዕኔ ኢተቀሜ ቤሉ አዬ ሌቆሁ አሌክዕኔ ሄኡንከ፤ መሰንትስ ኦሌቹስ ኢተኖሁ አዪሁ ሕጉ የኖሃ አአኖ። ");
INSERT INTO alw_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","«ዝነተ አቶት፤ ሽቶት፤ ሞግቶት፤ ዎሎ መንርቹ ሄዕላቶት» የኖ ትዛዙሁ ዎሉ ትዛዙ ጉዕሙንኩ «ኦሌቹክ ገይክገ ኢት» ይታ ላጋን ዊሞኡ። ");
INSERT INTO alw_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","ኢተት ሄኦ ጎሬ ዎሎ መን አሌን ሂለርቹ አአኖበአ፤ ህካን እኮቤቺሃ ኢታን ሕጉ ዊመ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","ቴሱ ግሰኛች ኬኤነንተ ወክቱ እሌገ ደጌ፤ መሰንትስ አመዕንኖም ወክቲች ጡምናም ወክቱ ቴሱ ኒቤቹ ሆንጠኮኡ። ");
INSERT INTO alw_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","ሀንከዕርት ህጎተ አኬኮኡ፤ በሩስ ሆንጠኮኡ፤ ህካን እኮቤቺሃ ቱንስቾን አዕናም ሆጉተ ጌኝ አዕኖ፤ ኑር ኦል ኦድኑተ ኦደዕኖ። ");
INSERT INTO alw_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","ህካን እኮቤቺሃ በራን እንካምሀንገ ሀስሰኖገ ሄዕኖ ቤሉ ሄዕናሚሁ ቦለቺን፥ ሰከሪን፥ ዝነተ አኢን፥ ጅስመ ሆጎዲን፥ ኦዳንለከ ምቀኞማን እሁንከ። ");
INSERT INTO alw_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ጠዉ እኮጎሬ ቀርቹ መሲህ ኢሰ ኦደዕዬ ቤሉ ሄዕላተኖርቹ ዊንሾተ ማልሃክዕኔ ሰውይቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","አመዕነቲን ሆጎ መንቹ ኢታን ቶጌስ ቤሉ ሰውትስ ህንቆኖቼ። ");
INSERT INTO alw_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","ጉዕመርቹንከ እቱ ሀስሰኖስገ አመዕነኖሁ ዮኡ፤ እኮጎሬ አመዕነቲን ሆጎሁ ጠለዕል አታክልተ እተኖ። ");
INSERT INTO alw_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","ህካን እኮቤቺሃ እኮስርቹ እተኖ መንቹ እትበ መንቹ ህንቁንከ፤ ህትን እትበ መንቹ እተኖሀን አሌን ፈረዱንከ፤ መሰንትስ መገኑ እሱ ቶጎስ። ");
INSERT INTO alw_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","ዎሎ መንች ካዲም አሌን ፈረዶተ አት አዬት? እስ ኡሬጎሬ ህከረንገ ኡቦጎሬ ቀርቺሃሲት፤ እሱ ቀርቹ ኡርሶስተ አታለኖቤቺሃ ኡረኖ። ");
INSERT INTO alw_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","ህትን መቱ መንቹ መቱ በር ዎለኢች ቆሀኖገ ሰውየኖ፤ ህትን ዎሉ በሩ ጉዕሙንኩ ቅጡወ ይ ሰውየኖ፤ ህካንን ጉዕሙንኩ ገግስ ቀልቢን አጥራመች ደጉ ሀስሰኖስ። ");
INSERT INTO alw_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","ህትን በር ከበጀኖ መንቹ ቀርቹ ኢሰ ከበጆተ ይ ከበጀኖ፤ እተኖንኩ መገኑ ገለትጨኖሲቤቺሃ ቀርቹ ኢሰ ከበጆተ ይ እተኖ፤ እትበ መንቹ ቀርቹ ኢሰ ከበጆተ ይ እተኖበአ፤ እስን መገኑ ገለትጨኖ። ");
INSERT INTO alw_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","ኒች ገይሀስ ሄአኖለከ ገይሀስ ሬሀኖ መንቹ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","ህካን እኮቤቺሃ ፎሊን ሄዕኖም ጎሬ ቀርቾ ኢሲሃ ሄዕናም፤ ሬኖምጎሬ ቀርቾ ኢሲሃ ሬናም፤ ህካን እኮቤቺሃ ሬኖምጎሬለከ ሄዕኖም ጎሬ ነኡ ኢስራን። ");
INSERT INTO alw_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","መሰንትስ መሲህ ሬቶሀኑኡተለከ ፎሊን ዮሀኑኡተ ቀርቹ እሆተ ሬይ ሬሆች ኬዕዮኡ። ");
INSERT INTO alw_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","አመክ ቤት አሌን ፈረዳንቲሁ ሚሃት? ህከረንገ አመክቤቱ ህንቃንቲሁ ሚሃት? ነኡ ጉዕሙንኩኔን መገን ፍርድ ቦርጭመ ብሬን ኡርናም። ");
INSERT INTO alw_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","«ቀርቹ መገኑ አን ሄኣሚሃ እኮምቤቺሃ መኑ ጉዕሙንኩ ኤሳሃ ሰገደኖ፤ አረቤንከስ አን መገኑ እሁእ መሰከረኖ» የመም ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","ህካን እኮቤቺሃ መት-መቱንኩኔ ገይኔተኔሃ መገኒሃ መስለ ኣስናም። ");
INSERT INTO alw_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ህካን እኮቤቺሃ መት-መትኔ አሌን ፈረንዱንከ፤ ህከን ወጥ አዪሁ አመስ ቤቲሃ ጉፍቹ እህበገ ህከረንገ አመስቤቱ ሉሲሰኖበእገ አገዕሩን። ");
INSERT INTO alw_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","አን ቀርቾ ኢስሃ እኮምቤቺሃ እቸት ገይንተሴ ኒጃስ እሁ ሆጉስ አጥራመች ደጎም፤ እኮጎሬ መቱርቹሃ «ንጃስየ» የኖ መንቺሃ ሁኩን ንጃስ እሀኖስ። ");
INSERT INTO alw_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","አት እታንት እቻን አመክቤቱ ሻዘኖ እኮች ኢታን ፈንቀላንቶንትበአ፤ ህካን እኮቤቺሃ መሲህ እስተኔሃ ሬዮ መንቹ እታንት እቸ መሳን በአኖገ አቶት። ");
INSERT INTO alw_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","ህትን ክዕኔሃ ዮ ጡመ ጠወ ህንቄኖገ አቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","መሰንትስ መገን ዎምነቱ ጠሊለ አያኒን እኮ ፈይመተ፥ ወገሬትየለከ ሙንዲኑተ ቤሉ እቴኖሃለከ አጌኖሃ ጠወበአ። ");
INSERT INTO alw_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ከን ሃሌን መሲህ ካደመኖ መንቹ መገኑ ሙንዲሲሰኖ፤ ሁኩ መንቹ መንሀኔን ማሰአሞእሃን። ");
INSERT INTO alw_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ቴሱ ወገሬቱ ደገመኖሁለከ ገገዉኔ ጠረኝጨቀማም ዎቃሃ አዎኑን። ");
INSERT INTO alw_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","እቴኖርቺሃ ይቴን መገን ሆጉተ ቤንሱንከ፤ እቸት ጉዕሙንኩ ነጠሃን፤ ጠዉ እኮጎሬ ዎሉ መነ ሉሲሳ እቸተ እቱ ሉጨንሻን። ");
INSERT INTO alw_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","ህካን እኮቤቺሃ ማለ እቱ ግቡ ህከረንገ ወይን ጠጀ አጉ ግቡ ህከረንገ መነ ሉሲሰኖርቹ መቱርቹሃ አኡ ሆጉ ጡመሃን። ");
INSERT INTO alw_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","ህትን ኬሳሃ ዮሄ አመዕነቱ መገንለከ ኪ በላን እሁን፤ ጡመ ይ አአኖ ጠዋን ቀልቡስ ቀነጠኖ ጠዉ ዮስበኢሁ ማሰአሞእሃን። ");
INSERT INTO alw_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","ጠዉ እኮጎሬ ሸከኖ መንቹ እቾጎሬ አመዕነቲን እኮበእቤቺሃ እስ አሌን ፈረደሞኡ፤ መሰንትስ አመዕነቲን እህበርቹ ጉዕሙንኩ ጩብሃን። ");
INSERT INTO alw_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","ነኡ አመዕነቲን ጠረኛኑተ እንኮምሩ ላፍ እጅነተ እጁ ሀስሰኖኔ ቤሉ ገዉኔ ጠለዕለ ሙንዲሲንሳምረ እሁ ሀስሰኖኔበአ። ");
INSERT INTO alw_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","መት-መቱንኩኔ አመዕነቲን ጠረኝኖተ ደግለለኖስ ጠወ አኢን ዎሉ መነ ሙንዲሲንሶ። ");
INSERT INTO alw_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","መሰንትስ «ኬሳሃ ቦሮሬመ ቦሮሩ ኢ አሌን እኮኡ» የመም ከተበሞገን እኮስ ቤሉ መሲህ ገዉስ ሙንዲሲሾበአ። ");
INSERT INTO alw_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","ጠሊለ መጻፋች ደንጋም አታዕሊንለከ ሰበሪን ኔሳሃ ተብሶሁ ሄኦኔተ ከኒች ብርተ ከተበንቶሩ ጉዕሙንኩ ተማርስቶኔተ ከተበንቶኡ። ");
INSERT INTO alw_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","አታዕልለከ ሰብር ቀርቹ ገገውንኩክዕኔ መሲህ ኢስ ምሳልተ አዎንቴን ሜጡበ ሄኤኖ ሰውት ኣሱንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ህትን ቀርቾ መሲህ ኢስ አኑ መገኑ መቶ ቀልቢንለከ መቶ ላጋን ኬዕምሴነንተገ አኡንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","ህትን መገኑ ኬዕምኝ ደኦተ መሲህ ገይሲሃ አዕይ ቶጎኔገን ገገዉክዕኔ ቶቃቀሜ። ");
INSERT INTO alw_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","ህካንን ጠወአን መገኑ ወዕኔ አናካተ ኣሴ ተብሶሁ እሆተለከ መገኑ ሀንቅ እሁስ ደጎኖተ መሲህ አይሁድ ካዲንቹ እኮ ዩሃን። ");
INSERT INTO alw_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","መሲህ አይሁድ ካዲንቹንኩ እኮንኩ እኮ ዎልት መሰት አይሁደ እክበሩ መገኑ መረርሲጭስተኔሃ ገለትጭቶታት፤ ሁኩንን፦ «ኡመት በላን ገለትጫንኬ፤ ሱዕምሃክ መዝሙራን ገለት ሆንጠህሳም» የመም ከተበሞጋት። ");
INSERT INTO alw_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","ህትን፦ «አዕኑ አይሁደ እኬንቡሩ መገኑ መጠሮ ኡመቲን ሜጡበ ተሽ ዩንክዕኔ» የመም ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","ህትን «አዕኑ አይሁደ እኬንቡሩ ቀርቹ መገኑ ገለትጭዬ፤ ህትን ኡመቱ ጉዕሙንኩ ገለትጩን» የመም ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","ህትን እስያስ «እሴዬ ዘሬች ከለቀመኖሁ አሜተኖ፤ አይሁደ እህበ ኡመት ገሸኖ ዋና እሀኖ፤ እሰን ተብሳሰ እስ አሌን አታአ» የመሞኡ። ");
INSERT INTO alw_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","ተብሶክኔ ጠሊለ አያን ዎልቃን ነጰን መሮታ ተብሴ መገኑ እሶን አመዕኒንከክዕኔ ሙንዲኑተለከ ወገሬት ዊንሽ ኣሱንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","አመኤ ኦሶ! አዕኑ ጡምማን ዊንቴንታእረ እኬንተጋ፥ ደጊን ዊንቴንተረ እኬንተገለከ መቱ መቱክዕኔ ተማርሱ አታልቴነንተገ አጥራመች ደጎም። ");
INSERT INTO alw_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","ጠዉ እኮጎሬ መት-መቶ ጠውተኔሃ ቃግሶህዕኔተ ይ መገኑ ኣሴኤ ኣስቶን መለልን ከተቦንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ሁኩ ኣስቱት ኣሰንቶኤሁ መገን ተሽት ላገተ አይሁደ እህቡ መኒሃ ዱዱብሲን ቂስችገ እክ መሲህ ኢሰ ካደሞታት፤ ህካን እኮቤቺሃ አይሁደ እህቡ መኑ ጠሊለ አያኒን ማሰአንቶተለከ መገኑ ሙንዲሲሰኖ ክትመ እክ ሆንጠኩንተ ካደማሚት። ");
INSERT INTO alw_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ህከን መሳን መሲህ ኢሲን መገኑ ካደሞተ አታዕሊንከኤ ቦናም። ");
INSERT INTO alw_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","አይሁደ እክበሩ አዘዘንታገ አኢሃ መሲህ ኢ ላጋንለከ ሆጎ መሳን አዕዮ ጠው ቤሉ መቱርቹሃ ጠወኢሃ መለላምበአ። ");
INSERT INTO alw_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","ህትን ሎርሎረ አጀብቶንለከ ገረምሲጬኖ ሆጎን ጠሊለ አያን ወልቃን ዬሩሳሌሚችለከ አዝጋጊች ጀመር እልዋሪቆነ ዬኖ ባዱ ኢለ መሲህ እንጂለ ሹል ተማርስዮም። ");
INSERT INTO alw_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","ህትን ጉዕመ ወክት ሃሽኣቱኤ ዎሉ መኑ ቀበቦ ቀበብ አሌን እጃሩ እሁዕነ መሲህ ሱዕሙ ሞጮጨሞበእቤቾን ተሽት ላገተ ዱዱብሱሃን። ");
INSERT INTO alw_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ሁኩንን፦ «ከኒች ብርተ እስተኔሃ መቱርቹሁ ኩለሞሰበእ መኑ ለኣአ፤ እስተኔሃ ሞጮጭትበሩ አጥራመታአ» የመም ከተበሞጋት። ");
INSERT INTO alw_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","ልግብ ወክት ክዕኔቤቹ አሜቶተ አታሉ ሆጎሚሁ ዎዕነ ሄጭ ጠወዕዮም መሳኒት። ");
INSERT INTO alw_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","ጠዉ እኮጎሬ ቴሱ ከን ኦሎን ዮ ባዶን አኣም ቤቹ ዮበእቤቺሃ፥ ህትን አበ ዘመኒች ኬሽ ክዕኔተ ለኦህዕኔተ አቡ ሃሽኣቱት ዮኤቤቺሃ ");
INSERT INTO alw_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","እስፔን ባዱ መራም ዎቄ አዲን ለኦህዕኔተ ያጆም። ቀዎ ጌሲሃ ክዕኔኤን ሜጡበ ተሽ ይሃዕኔ አገሮሚች ኤተሮን ዎቃኤ ጀመሮተ አታልሲሰኖኤርቹ ሀዕልቴነንተኤገ ተብሳ ኣአም። ");
INSERT INTO alw_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","ቴሱ እኮጎሬ አመዕናኖተ ደግለለኖርቹ ኣእ ዬሩሳሌመ መራም። ");
INSERT INTO alw_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","መሰንትስ መቄዶንለከ አካይ ባድ አመዕናኑት ዬሩሳሌም አመዕናኖ በላን ዮ ቡጥቻኖተ ሀዕልቶተ ሀሶቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","እሰ ህካን አቶተ ሀሶኢሁ አኡ ሀስሰኖሰቤቺሃት፤ መሰንትስ አይሁደ እህቡ መኑ አይሁድ መኒሃ መገኑ ኣሴ አያን በረከተ ቤቀማኑተ እኮች አይሁደ እህቡ ዮሰርቺን አይሁደ ሀዕሉ ሀስሰኖሰ። ");
INSERT INTO alw_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","ህካን እኮቤቺሃ ተ ሆጉተ ሹሎሚችለከ ጭምዬእ ብረ ኣሴንሳች ኤተሮን እስፔን ባዱ መራም ዎቃን ክዕኔተ ለዕይ ህጋም። ");
INSERT INTO alw_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","ህካን እኮቤቺሃ ክዕኔቤቹ አሜታም ወክት መሲህ በረከተ ዊምማን አፍ አሜታምገ ደጋም። ");
INSERT INTO alw_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","አመኤ ኦሶ! ኢን ሜጡበ እኬን ኢተኔሃ መገኑ ጠረኘገ ዱአ አቶኖተ ቀርቾሃ መሲህ ኢሲንለከ ጠሊለ አያን ኢታን ኡጫንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","32","መገኑ ዬ ጎሬ ሙንዲኖን ክዕኔቤቹ አሜች ክዕኔን ሜጡበ ፎሎጮተ አይሁድ ባዶን ዮ አመዕንበ መን አንጋች ፌሶኤተለከ ዬሩሳሌም ከተማን አኣም ሆጉተ አመዕናኑተ ሙንዲስሳኢታ እኮተ መገኑ ኡጭዬ። ");
INSERT INTO alw_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ወገሬት መገኑ ጉዕሚንከክዕኔ ሜጡበ እሁን፤ ኣሚዕን። ");
INSERT INTO alw_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","ፌቤን ክንክሪያ ከተማን ዮ አመዕናኖ ዱእ ምናን ካደንታ አመዕነንቶ አመኔ ቤቱተ እሁሴ አን መሰከራም። ");
INSERT INTO alw_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","እሴን ልግብ መነለከ ኤሳሃ ሀዕልቶኢተ እኮቤቺሃ ጠሊላኖተ ሀስሰኖ ዎቄን እሴተ ቀርች ሱዕሚን ቶጌን ሀሲሰኖሴርቺን ጉዕሚንን ሀዕልዬሴ። ");
INSERT INTO alw_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","መሲህ ኢስ ሆጎን ኢንን ሜጡበ አተ ጵርስቅለለከ አቂለሁ «ወገሬቴ» ይዬሰ። ");
INSERT INTO alw_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","እሰ ኢተኔሃ ፎልሰ ህግስ ኣቶእራን፤ ህካን እኮቤቺሃ አን ጠለዕለ እሁዕነ አይሁደ እህበ መኒች መገኑ አመዕኔ መኑ ጉዕሙንኩ ገለትጭታሳት። ");
INSERT INTO alw_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","ህትን እሰ ምኔን ጭምይታ አመዕናኑተ «ወገሬት» ይዬ፤ ህትን እስይ ባዶን ወዕና መሲህ አመዕንቶለከ አኒሁ አበ ኢታንስ ኤጴኔጦሴ «ወገሬቴ» ይዬስ። ");
INSERT INTO alw_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","ክዕኔ በላን ጠረኝት አቶ መርየመ «ወገሬቴ» ይዬሴ። ");
INSERT INTO alw_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","ህትን አሳበ በላን ደገንቶእረለከ ኢችን ዎዕነ መሲህ አመዕንቶእረ ህትን ኢንን ሜጡበ ኡሱረንቶ እሉኤ አንድሮኒቆኔለከ ዩንያሴ «ወገሬቴ» ይዬሰ። ");
INSERT INTO alw_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","ህትን ቀርቾ ኢሲን ኢታንስ አንጵልያጦሴ «ወገሬቴ» ይዬስ። ");
INSERT INTO alw_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","ህትን መሲህ ሆጎን ኒንን ሜጡበ አአኖ ኡርባኖሴለከ አን አበ ኢታንስ እስጣቆሴሁ «ወገሬቴ» ይዬስ። ");
INSERT INTO alw_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","ህትን መሲህ እሁስ ፌተነም መሰከረሞስ አጴሊሴ «ወገሬቴ» ይዬስ፤ ህትን አርስጦቡሎሴ ምኒ መነ «ወገሬቴ» ይዬሰ። ");
INSERT INTO alw_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","ህትን እሉኤ ሄሮድዮነ «ወገሬቴ» ይዬስ፤ ህትን ነርክሲስ ምኒ መኒች ቀርቾን አመዕንቶእረ «ወገሬቴ» ይዬሰ። ");
INSERT INTO alw_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","ህትን ቀርቾ ኢሲሃ አታ ካዲመተ ቱሩፋይናለከ ትርፎሴሁ «ወገሬቴ» ይዬሰ፤ ህትን ቀርቾ ኢስ ሆጉተ ጠረኝት አታእረለከ መሲህ ኢታን አበ ኢታንሴ ጴርሲዴ «ወገሬቴ» ይዬሴ። ");
INSERT INTO alw_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","ህትን ቀርችን መጠረሞ ሩፎሴሃ «ወገሬቴ» ይዬሰ፤ ኤሳሁ እለሴገ ኢትታኤ አማተስ ወገሬት ይዬስ። ");
INSERT INTO alw_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","ህትን አስክርጦሴሁ፥ ፍሌጎኔለከ ሄርሜሴሁ እሳንን ሜጡበ ዮ አመ ኦሶታ «ወገሬቴ» ይዬሰ። ");
INSERT INTO alw_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","ህትን ፊሎሎጎሴ፥ ዩልየሁ፥ ኔሮሴሁ፥ ኔሮሴ አመቤቱተ፥ ኦሉምፓሴ እሳንን ሜጡበ ዮ አመዕናኑተ ጉዕመንከ «ወገሬቴ» ይዬሰ። ");
INSERT INTO alw_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","ህትን ጡመ ሱንቃቀሚን ወገሬትጨቀሜ፤ መገን አመዕናኖ ጭምት ዱእ ምናተ ጉዕሚንከ ወገሬት ሶኮህዕኔ። ");
INSERT INTO alw_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","አመኤ ኦሶ! አዕኑ ተማርቴንተ ትምርቲን ኦደንታእረለከ በላንከክዕኔ አደዶመተለከ ጉፍቹ እሀኖርቹ ኤባ መኒች አገዕርቶኖተ ኡጫንክዕኔ፤ እሳች ሁኜ። ");
INSERT INTO alw_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","ህትኔ መኑ ገዉሰ ቤሉ ቀርቹኔ መሲህ ካደንትበራን፤ እሰን አመሰልት ጡመ ጠወአን ጎደበ ላፈ መን ቀልብ ሉሲሳኣ። ");
INSERT INTO alw_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","አዕኑ እንጂል ላጋተ አዘዘንቴንተረ እኬንተገ መኑ ጉዕሙንኩ ሞጮጬቤቺሃ ክዕኔተኔሃ አን አበ ሙንደዕዮም፤ ጠዉ እኮጎሬ ጡመ ጠዊሃ ሀይቻኑተለከ ሂለ ጠዊሃ ገዋኑተ እኮኖተ ሀሳም። ");
INSERT INTO alw_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","ቴሁ ወገሬት መገኑ ደዕል ሸይጣንቹ ሎካችክዕኔ ዎሮን ደዕል ቀጠቀጠኖ፤ ቀርቹሃኔ ኢስ ኣስቱት ክዕኔን ሜጡበ እኩን። ");
INSERT INTO alw_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","ኢን ሜጡበ አአኖ ጥማቶስ ወገሬት ሶኮህዕኔ፤ ህትን እሉኤ እኮሀኑኡተ ሉቅዮስለከ ኢያሶን ሶሲጳጥሮስ ወገሬት ሶኮህዕኔ። ");
INSERT INTO alw_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","ህትን አን ከን ደብዳቤ ከተባንቹ ጤርጦስ ቀርቾ ኢስ ሱዕሚን «ወገሬት ዮንተንንዶ?» ያንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","ኤሳለከ አመዕናኑተ ጉዕመንከ ኮህቹ ቶገኖ ጋይዮስ ወገሬት ሶኮህዕኔ፤ ከተምስ ብረ አፈኖ ኤርስጦስለከ አመኔቤቱ ቋርጦስ ወገሬት ሶኮህዕኔ፤  ");
INSERT INTO alw_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","ቀርቹሃኔ መሲህ ኢስ ኣስቱት ጉዕሚንከክዕኔ ሜጡበ እኩን፤ ኣሚዕን። ");
INSERT INTO alw_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","መሲህ ኢስተኔሃ አን ዱዱብሳም እንጂል ሶህኖን መገኑ ክዕኔተ ነጠ አኦህዕኔተ አታለኖ፤ ኩ እንጂሉንኩ አበ ዘማኒሃ ማጠም ሄዕዮ ምስጥር ለሊሰኖሃን። ");
INSERT INTO alw_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","ዘማኒሃ ጉዕሚ መገኑ አዘዦገን ምስጥሩ ቴሱ ነብያኖ መጻፈ መሳን ለልዮኡ፤ ኩ ጉዕሙንኩ ኡመቱ እንጂለ ደጎተለከ አመዕነት አደ አዘዘንት አሜቶታት። ");
INSERT INTO alw_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","ህካን እኮቤቺሃ እስ ሜጥቹስ መገኑለከ ሀይቹ እኮ መገኒሃ መሲህ ኢስ መሳን ዘላለሚሃ ኬዕምኙ እሁንስ፤ ኣሚዕን። ");
INSERT INTO alw_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","መሲህ ኢስ ሶቀማንቹ እሆተ መገን ሰውቲሃ ገአሞም አን ጰዉሎሴችለከ አመኔቤቲች ሶስቴኔሴች ");
INSERT INTO alw_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","መሲህ ኢስ ጠሊለ አዕዮሀኑኡተለከ ጠሊላኑተ እኮተ መገኑ ገኤሰ ቆሮንቶስ ከተማን መገን አመዕናኖ ጭምት ዱእ ምኒሃ፥ እሰለከ ኒ ቀርቹ እኮ ቀርቹሃኔ መሲህ ኢስ ሱዕመስ ጉዕመ ቤቾን ገአንቶሀኑኡተ ጉዕሚንከ ሶኮምተ ሶህኑ። ");
INSERT INTO alw_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","አንችኔ መገኒችለከ ቀርቹሃኔ መሲህ ኢሲች ኣስቱትለከ ወገሬቱ ክዕኔሃ እሁን። ");
INSERT INTO alw_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","መሲህ ኢስ አዲን ኣሰሞህዕኔ መገን ኣስቶተኔሃ ክዕኔ መሳን አን ጉዕመ ወክትንከ መገኑኤ ገለትጫም። ");
INSERT INTO alw_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","መሰንትስ አዕኑ ጠወኤነንተ ጠዊን፥ ኤንኬዕኒን ጉዕማንን መሲህ ኢስን ጉዕመ አዲንን ቀባጣመተ እኬንታአ። ");
INSERT INTO alw_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","ህትን ነኡ መሲህ ኢስተኔሃ ኩልኖንክዕኔ ጠዉ ክዕኔ በላን ጠረኝዮኡ። ");
INSERT INTO alw_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ህከኒች ኤተሮን ቀርችኔ መሲህ ኢስ አሜቱ አገርቴነን መገን ኣስቶች መቱርቹሁ ሆፈአኖህዕኔበአ። ");
INSERT INTO alw_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","እስን ቀርቹኔ መሲህ ኢስ ፈንቀል አሜተኖ በር ህንቄኖህዕኔርቹ ዮህዕኔበእረ እኮኖተ መጨርሸ ኢለ ጠረኝቴን ሄኤነንተገ አሰኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","መሰንትስ ቤትንከስ ቀርቹሃኔ መሲህ ኢሲን ሜጡበ እሁ ሄኦህዕኔተ ገኤህዕኔ መገኑ አመዕነሞእሃን። ");
INSERT INTO alw_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","አመኤ ኦሶ! መቱ ጠወ ጠወኦኖተ፥ መቱ ቀልቡለከ መቱ ሰውቱ ሄኡክዕኔ ቤሉ በላንከክዕኔ አደዶመት ሄኣበእገ ቀርቹሃኔ መሲህ ኢስ ሱዕሚን ኡጫንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","መሰንትስ አመኤ ኦሶ! በላንከክዕኔ ብተት ሄኡስ ቀሎኤ ምኒ መኑ ኩሎኤ። ");
INSERT INTO alw_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","ህካን ዩ መት-መቱክዕኔ «አን ጳዉሎሴሃ» ህከረንገ «አን አጵሎሴሃ» ህከረንገ «አን ጴጥሮሴሃ» ህከረንገ «አን መሲህረ» ይቴነንታት። ");
INSERT INTO alw_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","መሲህ ቤሀሞእንዶ? ህትን ጳዉሎስ ክዕኔተኔሃ ሰቀለሞእንዶ? ህከረንገ ጠመቀንቴንታሁ ጳዉሎሴ ሱዕሚንትንዶ? ");
INSERT INTO alw_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","አን ቀርስጶሴለከ ጋዮሴ ቤሉ ክዕኔተ መቱክዕኔ ጠመቆምበእቤቺሃ መገኑ ገለትጫም። ");
INSERT INTO alw_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ህካን እኮቤቺሃ አዪሁ ክዕኔተ «ጳዉሎሴ ሱዕሚን ጠመቀንቴንታእረ» ዮተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","ህትን እስጥፋኖሴ ምኒ መነ ጠመቆም፤ ህከን ቤሉ ዎሉ መነ ጠመቆምጎር ደጎምበአ ");
INSERT INTO alw_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","መሰንትስ መሲህ ሶኮኤሁ ተሽት ላገተ ዱዱብሶታት ቤሉ ጠመቆታትበአ፤ ዱዱብሳሚንኩ መሲህ መስቀሉ ተሰ እሀኖበእገ መን ሀይማን ደገንቶ ላጋኒበአ። ");
INSERT INTO alw_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","መስቀልተኔሃ ኩሌኖ ጠዉ በኣ መኒሃ ገዊመተ እኮጎሬ ኔሳሃ ጡምናም መኒሃ መገንተ ዎልቀ። ");
INSERT INTO alw_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","መሰንትስ «ሀይቾ መን ሀይመንተ ቤሳም፤ ኤንኬዕናሞ መን ኤንኬዕኑ ከማም» የመም ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ህካን እኮቤቺሃ ሀይቹ መንቹ አዬት? ሕግ አስተማርቹ አዬት? ከን ኣዱንያ አሌን አጥራመች ደገኖሁ አዬት? መገኑ ከን ኣዱንያ አል ሀይመተ ገዊመተ እሀኖገ አዕዮበእንዶ? ");
INSERT INTO alw_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","መሰንትስ መገኑ ሀይማንከስ ከን ኣዱንያ አል መኑ ገይስ ሀይማን መገኑ ደጋበእገ ሀይማን አዕዮሰ፤ ጠዉ እኮጎሬ ገዊመገ ዎለአመኖ ነኡ ተማርስናም እንጂሉ አመዕንታእረ ጡምሶተ መገን አምሩ እኮኡ። ");
INSERT INTO alw_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","አይሁድ መኑ መላተ ለኡ ኢትታአ፤ ህትን ግሪክ መኑ ሀይመተ ሃሸኣአ። ");
INSERT INTO alw_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ጠዉ እኮጎሬ ነኡ አይሁዲሃ ጉፍቹ እኮሃ አይሁደ እህበ መኒሃ ገዊመተ እኮ ሰቀለም ሬዮ መሲህ ዱዱብስናም። ");
INSERT INTO alw_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","ህትን ገአሞ መኒሃ አይሁዲሃ እካን ግሪክ አፎን ጠወአኖ መኒሃ መሲህ መገንተ ዎልቀተለከ መገንተ ሀይመ። ");
INSERT INTO alw_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","መሰንትስ መገን ገዊመት መን ሀይማች በተኣአ፤ ህትን መገን ላፍመት መን ዎልቃች በተኣአ። ");
INSERT INTO alw_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","አመኤ ኦሶ! ክዕኔተ መገኑ ገኤህዕኔ ወክት ሀትኔ መነ እኬንታጎሬ ሰውይዬ፤ መን ሰውቲን በላንከክዕኔ አኡ ሀይመተ ህከረንገ ልግቡ ጠረኙ ህከረንገ ልግቡ ሎርሎሩ መኑ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ጠዉ እኮጎሬ ሀይመተ ሙልሶተ መገኑ ከን ኣዱንያ አል ገወ መነ መጠሮ፤ ህትን ዎልቃመተ ሙልሶተ መገኑ ከን ኣዱንያ አል ላፈ መነ መጠሮ። ");
INSERT INTO alw_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","ከን ኣዱንያ አል ሎረ ጠወ ሆፍሶተ መገኑ ከን ኣዱንያ አል ቀዉ ጠዋሃ፥ ህንቀሞ ጠወለከ ተሰ እኮ ጠወሃ መጠሮ። ");
INSERT INTO alw_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ህካን አዕዮንኩ ማለ ኦደዕዮሁ ጉዕሙንኩ መገን ብሬን ቦነኖበእጋት። ");
INSERT INTO alw_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","እኮጎሬ ክዕኔተ መገኑ መሲህ ኢሲን ሜጡበ ሜጦመት ሄኣህዕኔገ አዕዮ፤ ህካን እኮቤቺሃ መገኑ መሲህ ኢሰ ሀይመኔ፥ ፈይመኔ፥ ጠሊልመኔለከ ወዝኑኔ እሀኖገ አዕዮስ። ");
INSERT INTO alw_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","ጠሊለ መጻፋን ከተበሞገን «ድከአኖሁ ቀርቾን ድከኡን።» ");
INSERT INTO alw_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","አመኤ ኦሶ! አን ክዕኔቤቹ አሜቾም ወክት መገንተኔሃ መሰከሩ አን ጠወ ደጋምሀንገለከ ጡመገ አዕይ ጠወአሚሃ እሁኤ ለሊሶህዕኔተ አሜቾምበአ። ");
INSERT INTO alw_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","መሰንትስ አን ክዕኔን ሄዕዮም ወክት ሰቀለሞ መሲህ ኢስ ቤሉ ዎሉ መቱርቹሃ ደጋምበእገ ሙርሲጭዮም። ");
INSERT INTO alw_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","ህካን እኮቤቺሃ ክዕኔን ሜጡበ ሄዕዮም ወክት ላፈ እክ ዋጀን አበ ሁጠኛ አሌን ሄዕዮም እቅ። ");
INSERT INTO alw_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","ጠዉኤለከ ትምርቱኤ መን ሀይመተለከ ጠወ መክሲን እሁዕነ መገን አያነለከ ዎልቀተ ለልሲሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ህካን አዕዮሚሁ አመዕነቱክዕኔ መን ሀይመ አሌን ኡሬኢሃ እሁዕነ መገን ዎልቃን ድከዕዮሃ እሆታት። ");
INSERT INTO alw_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","ጠዉ እኮጎሬ አመዕነቲን ጠረኝቶሀኑኡተ ሀይመ ላጋን ጠወዕናም፤ እሁን ቤሉ ጠወዕናሚሁ ከን ኣዱንያ አል ሀይመተ ህከረንገ መጨረሽ በኡ እሀኖ ከን ኣዱንያ አል ገሸኖ ሀይመተበአ። ");
INSERT INTO alw_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","ነኡ ጠወዕናሚሁ እኮጎሬ መገኑ ሄጭ ጉዕመ ዘማኒች ብርተ ኬዕምኚሃኔ ቅጥ አዕዮለከ ማጠሞ እቅ መገን ምስጥር ሀይመታት። ");
INSERT INTO alw_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ከን ኣዱንያ አል ገሻኖ በላን ከ ሀይመተ አጥራመቾሁ አዪሁ ዮበአ፤ ደጎእቃኔተ ኬዕምኝ ቀርቹ ሰቀልታስበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","እሁን ቤሉ ጠሊለ መጻፋን ከተበሞገን «መን እልት ለኦበኢሃ፥ መን መጨት ሞጮጭቶበኢሃ፥ መን ቀልቡ ሰውይዮበኢሃ፥ መገኑ ኢትታሀኑኡተ ቅጥ አዕዮኡ» የኖ። ");
INSERT INTO alw_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","ኔሳሃ እኮጎሬ መገን አያን መሳን ምስጥርስ ለሊሾኔ፤ መገን አያኑ ጥዕላሸ እኮ መገን ሰውቱ ፈቁዕናን ጉዕመ ጠወንከ መረመረኖ። ");
INSERT INTO alw_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","መንተኔሃ እኮእቀ ገይስ አያን ቤሉ እሶን ሄዕዮ ሰውት ደገኖሁ አዬት? ህትን መገን አያን ቤሉ መገን ሰውት ደገኖሁ አዪሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","መገኒች ኣሰሞኔርቹ ደንጎተ መገን አያነ ቶንጎም ቤሉ ከን ኣዱንያ አል አያነ ቶንጎምበአ። ");
INSERT INTO alw_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","ህካን እኮቤቺሃ ነኡ አመዕነት ጠወ አመዕንቶ መኒሃ ተማርስናሚሁ መኒች ደገመኖ ሀይማን እሁዕነ መገን አያኒች ደገመኖ ሀይማኒት። ");
INSERT INTO alw_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","አመዕነቱ ዮስበእ መንቹ መገን አያኒች ቶጎተ አታለኖበአ፤ መሰንትስ ህትኔ ጠው እሲሃ ገውመተ፤ አያኒን እክ መረመረመኖሃ እኮቤቺሃ ደጎተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","መገን አያኑ ዮሲሁ እኮጎሬ ጉዕመ ጠወንከ መረመሮተ አታለኖ፤ እስ ገዉስ አዬኒ መረመረመኖበአ። ");
INSERT INTO alw_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","ሁኩንን፦ «ቀርች ሰውት አይ ደገኖ? ሸዞስተ አታለኖሁ አዬት?» የመም ከተበሞጋት። ነኡ እኮጎሬ መሲህ ቀልቡ ዮኔ። ");
INSERT INTO alw_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","አመኤ ኦሶ! አን ከን ኣዱንያ አል ሰውቱ ዮህዕኔገለከ መሲሂን ጩለገ አዕዪት ቤሉ መገን አያኒን ዮ መንገ አዕይ ጠወኦተ አታሎምበአ። ");
INSERT INTO alw_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","ጠረኘ እቸተ እት አታልትቡ ጩለገ እኬንተቤቺሃ አን ኢትሾንክዕኔሁ አዙታት ቤሉ ጠረኘተ እቸበአ፤ ቴሁ እኮጎሬ ጠረኘ እቸተ እቶኖተ አታልቴነንተበአ። ");
INSERT INTO alw_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","አዕኑ ቴሁ ከን ኣዱንያ አል መን ሰውቱ ዮህዕኔ፤ ገገዉንኩዕኔ መት-መቲንከክዕኔ ምቀኝቴነንተቤቺሃለከ ኦደንቴነንተቤቺሃ ከን ኣዱንያ አል ሰውትገ እሆንከክዕኔበእንዶ? ህት እሁክዕኔ ከን ኣዱንያ አል መን ሰውትገ እሆንከክዕኔበእንዶ? ");
INSERT INTO alw_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","ህትን መቱክዕኔ «አን ጳዉሎሴሃ» ዎሉዕኔንገ «አን አጵሎሴሃ» የኖሃ እኮች አመዕንበ መንገ እሆንከክዕኔበእንዶ? ");
INSERT INTO alw_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","አጵሎስ መርቾሃን? ህትን ጳዉሎስ መሃን? እሰ አዕኑ አመዕንቶኖተ አቶህዕኔተ ካዲመ፤ መት-መቱንኩሰ ካደንታስ ቀርቹ መት-መቲሃሰ መደቦሰ ሆጎኒት፤ ");
INSERT INTO alw_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","አን ካሾም፤ አጵሎስ ዋሃ አግሾ፤ ነሴኢሁ እኮጎሬ መገኑሃን። ");
INSERT INTO alw_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","ህካን እኮቤቺሃ ሆጎተስ ቡዕለ እኮሁ ነሴ መገኑሃ ቤሉ ካሾሁ እኮ ዋሃ አግሾሁ መርቹሃስበኢሁ። ");
INSERT INTO alw_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","ካሾሁ እኮ ዋሃ አግሾሁ ለሙንኩ ቅጦሃን፤ መት-መቱስ ሆጎስ ወጥ ዋገ ቶገኖ። ");
INSERT INTO alw_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","ነኡ መገኒን ሜጡበ አዕናምረ ካዲመ፤ አዕኑሁ መገንተ አቡረለከ መገንየ ምኒ። ");
INSERT INTO alw_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","መገኑ ኣሴኤ ኣስቶ ጌሲን ኤንኬዕናሙ መንቹ ምኒ እጃረኖሀንገ ቀበበ መክሾም፤ ዎሉንገ አን መክሾም ቀበብ አሌን እጃረኖ፤ ጠዉ እኮጎሬ ገገዉንኩስ ከን ቀበብ አሌን ሀት አዕይ እጃረኖጎሬ አገዕሩ ሀስሰኖስ። ");
INSERT INTO alw_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","ሜጦረ መኬ ቀበብ ቤሉ አዪሁ ዎሉ ቀበበ መክሶተ አታለኖበአ፤ ሁኩ ቀበቡንኩ መሲህ ኢሳት። ");
INSERT INTO alw_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","ከን ቀበብ አሌን ዎርቂን፥ ብሪን፥ ጡመ ክኒን፥ ህከረንገ ሀቂን፥ ህጤንለከ ገለቢን ግንበ እጃረኖሁ ሄዕዮጎር ");
INSERT INTO alw_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","መት-መቶ መንች ሆጉት ለልታ ፍርድ በሩ አሜተኖ፤ ህከ በር ጉዕምስ ሆጉት መሃጎር ጊራን ፌተነም ለለኖ። ");
INSERT INTO alw_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","መቱ ግንበ እጃረኖ መንቹ ቀበብስ አሌን አዕዮ ሆጉት ጊራን ፌተነም ምርተኡዕነ ጠረኝ ኡሬጎር ግንበ እጃረኖሁ ዋገስ ደአኖ። ");
INSERT INTO alw_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","ሆጉስ ጊራን ቡብ በኦጎር ግንበ እጃረኖሀን ዋጉ ፈቀኖ፤ እሁን ቤሉ እስ ገዉስ ጊረ ኣዚን ህግ ቡቡዕነ ፈቆ መንችገ ጡመኖ። ");
INSERT INTO alw_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","መገን ጠሊለ ምኒ እሁክዕኔለከ መገን አያኑ ኣዜንከክዕኔ ሄኡስ ደጌነንተበእንዶ? ");
INSERT INTO alw_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ህካን እኮቤቺሃ አዪሁ ዱእ ምኒ ድጄጎር መገኑ ገዉንከስ ድጀኖ፤ መገን ፎሎጨኖ ምኑ ጠሊለሃን፤ ሁኩ መገን ምኑ አዕኖት። ");
INSERT INTO alw_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","አዪሁ ገዉስ ጣንሱንከ፤ ከን ኣዱንያ አሌን አዪሁ ክዕኔ በሊች ሀይቹ እኮሃ አጉጆስ ጎሬ ሀይቹ እሆተ ገዉስ ገወ አዕይ ዎለኡን። ");
INSERT INTO alw_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","ከን ኣዱንያ አል ሀይመት መገን ብሬን ገዊመተ፤ መሰንትስ «መገኑ ተንኮንተሰን አፈኖሰ» የመም ከተበሞጋት። ");
INSERT INTO alw_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","ህትን «ቀርቹ ሀይቻኖ ሰውቱ ተሰ እሁስ ደገኖ» የመም ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","ህካን እኮቤቺሃ ጉዕሙርቹንኩ ክዕኔሃ እኮቤቺሃ አዪሁ መናን ድከኡንከ። ");
INSERT INTO alw_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","ህትን ጳዉሎሴሃ እኮ አጵሎስ፥ ጴጥሮሴሃ እኮ እቃ፥ ኣዱንያ አል እኮ እቃ፥ ሄኡ እኮ እቃ፥ ሬሁተ እኮ እቃ፥ ቴሱ ዮኢሃ እኮ እቃ፥ ኤተሮን አሜተኖሃ እኮ እቃ ጉዕሙንኩ ክዕኔሃን። ");
INSERT INTO alw_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","አዕኑ እኮጎሬ መሲህተ እለ፤ መሲሁንገ መገንየን። ");
INSERT INTO alw_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","ቴሱ መኑ ጉዕሙንኩ ኔሳሃ መሲህ አሳበተ እሁኔለከ መገን ማጠሞ ጠወ ለሊስ ኤገት ኣሰንቶኔ መንገ አዕይ ዎለኡ ሀስሰኖኔ። ");
INSERT INTO alw_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","ኤገተ ቶጎ መኑ አመዕነንቶእረ እክ ደገሙ ሀስሰኖሰ። ");
INSERT INTO alw_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","ኢተኔሃ እኮጎሬ አዕኑሁ ፈረዴንተጎሬ ህከረንገ ዎሉ መኑሁ መኑ ፈረደኖገ ፈረጆኤጎሬ ኦርሸት ዮኤበአ፤ ሀንቅንከ አን ገይኤ አሌን ፈረዶተ አታላምበአ። ");
INSERT INTO alw_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","አን ደጋምገን እኮጎር ሂሉርቹ ኢን መቱርቹሁ ዮበአ፤ ህካን ዩኤ አን «ነጠ እሁኤ ለሊሰኖ» ዩሃበአ፤ ጠዉ እኮጎሬ ኢ አሌን ፈረደኖሁ ጠለዕል ቀርቹሃን። ");
INSERT INTO alw_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","ህካን እኮቤቺሃ ወክቱስ ኢሉዕነ ቀርቹ አሜቱዕናን ሄጭቴን አዬ አሌን ፈረዶኖቼ፤ እስ አሜተኖ ወክት ቱንስቾን ማጠሞ ጠወ ፉሽ ለሊሰኖ፤ መን ቀልቤን ማጠሞ ሰውት ለሊሰኖ፤ ህከ ወክት ገገዉንኩስ መገኒች ሀስሰኖ ገለት ቶገኖ። ");
INSERT INTO alw_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","አመኤ ኦሶ! ክዕኔተ ደግለሎተ ይ ከን ጠዋን ኤሳለከ አጵሎሴ ምሳልተ አዕይ ጠወዕዮም፤ ህካንን አዕዮሚሁ «ከተበሞሀኒች ህጎት» ይታ ሸዘነ ፍሳረስ ኒች ተማርቶኖተ ይዪት፤ ህካን እኮቤቺሃ መቱ መንቹ መቶ መንቺች በትሴን ህከን መንቾን ድከኦኖቼ። ");
INSERT INTO alw_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","መሰንትስ አት ሚን በተአን? ህትን ኣእቶንትበእርቹ ም ዮኡ? ህከረ ኣእቶንቲሁ እኮጎሬ ኣእበ መንገ ሚሃ ገዎንከክ ድከአን? ");
INSERT INTO alw_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ቴሱ ሀስሰኖህዕኔርቹ ጉዕመንከ ደእቴንታአ፤ ቴንገ ቀባጣመተ እኬንታአ፤ ኒች አደ እኬን ነገሴንታአ፤ ሀንቅንከ ነገሴንታ እቃን ነኡ ክዕኔን ሜጡበ ነገንሳምቤቺሃ ነገሱክዕኔ ጡመ እቅ፤ ");
INSERT INTO alw_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","ኣዱንያ አል ጉዕሚንከ መላይካንተ መኒንከ ሙሃሌኖኔሃ እንኮም፤ መሰንትስ መገኑ ኔሳሃ አሳበስ ሬሁት ፈረዴመሰ መንገ መኒች ጉዕሚችን ዎሮን አዕዮኔሃ አጉደኖኤ። ");
INSERT INTO alw_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ነኡ መሲህሃ ይን ገዋኑተ እንኮም፤ አዕኑ እኮጎሬ መሲህ ሀይቻኑተ እኬንታአ፤ ህትን ነኡ ሆጎ መነ እንኮም፤ አዕኑ እኮጎሬ ጠረኛኑተ እኬንታአ፤ አዕኑ ኬዕምኛመተ እኬንታአ፤ ነኡ እኮጎሬ ሆፍኛመተ እንኮም። ");
INSERT INTO alw_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","ቴሁ እኮጎሬ ከ ሰኣት ኢለ ጎራይናም፤ ሰገምባም፥ ከልናም፥ ኦለማም፥ ምኒ ሆንግ ኦርጨቀማም። ");
INSERT INTO alw_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","ነኡ ገይኔ አንጋን አዕነን ቆንዶድናም፤ ቦሮሮኔ መነ ማሰዕናም፤ ሸርታኔ ወክት አታዕልናም። ");
INSERT INTO alw_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","ህትን ቦሮሬመኔለከ ሱዕመኔ ቤሴመ ወክት ገዉኔ ሆፍንስ ፈንቀሽናም፤ ቴሱ ኢለ ከን ኣዱንያ አል ሁረ እንኮም። ");
INSERT INTO alw_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","አን ከ ጠወ ከተባንክዕኔሁ ኢታም እለኤገ አዕይ ሸዞህዕኔታት ቤሉ ሙልሶህዕኔተ ይዪበአ። ");
INSERT INTO alw_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","መሃ እኮጎሬ መሲሂን ነስታህዕኔሩ ሄኦህዕኔጎሬ ልግቡ አነ እሀኖህዕኔሁ ዮበአ፤ መሰንትስ አን መሲህ ኢስ አዲን እንጂል ላጋን እሎንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","ህካን እኮቤቺሃ ኤሳሃ አጉዴን አዎንቶኖኤተ ኡጫንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ህከን መሳን ኢተሞለከ አመዕነሞ ቀርቺን ቤቱኤ እኮ ጥማቶሴ ክዕኔቤቹ ሶኮም፤ ቤቾን ጉዕማንን አመዕናኑተ ተማርሴምሀንገ እስ አን መሲሂን ደኤም ሃዕሮ ሄእ ሸዘነተ ኩለኖሰ። ");
INSERT INTO alw_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","ጠዉ እኮጎሬ ክዕኔች መት-መቱሰ አን ክዕኔተ ለኦተ አሜታምበኢሃ አጉጃንሰ ቦንታኢት። ");
INSERT INTO alw_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","እሁን ቤሉ ቀርቹ ዬጎሬ ግደኖ በሬን ክዕኔቤቹ አሜታም፤ ህከ ወክት ጠለዕል ህከን ቦንታ መን ጠወሰ እሁዕነ ዎልቀሳ ደጎተ ሀሳም። ");
INSERT INTO alw_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","መሰንትስ መገን ዎምነቱ ጠለዕል ጠዊን እሁዕነ መገን ዎልቃኒት። ");
INSERT INTO alw_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","አዕኑ ሀሴነንታሁ መርቾሃን? ቅጣት በርተ አፍ ክዕኔቤቹ አሜቶተ ሀሴነንንዶ? ህከረንገ ኢታንለከ ገዉ ሆፍስ አያኒን አሜቶተ ሀሴነን? ");
INSERT INTO alw_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","ክዕኔ በላን ሙልሳ ዝነት ሄኡስ ሞጮጭዮም፤ ህትኔ ዝነት አይሁደ እህበ መኑሁ አእበሃን፤ ሁኩንን አንስ ጫተ ገይስ ምኒ አመገ አዕይ ሄአኖሁ ዮኡ የመሞኡ። ");
INSERT INTO alw_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","ህካን እክ ህትኔ ሙልሲሰኖ ጠዉ በላንከክዕኔ ሄአን ሚሃት ቦንቴነንታሁ? ባሰንከ ከን ጠዋን ሻዙ ሀስሰኖህዕኔበእንዶ? ህትኔ ሆጉተ አዕዮ መንቹ በሊችክዕኔ ከሜ። ");
INSERT INTO alw_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","አን መሃ እኮ እቃን ሜጡበ ሄእበ ጎሬ ሰውቲን ክዕኔን ሜጡበ ዮም፤ ሜጡበ ሄዕዮምሀንገ እክ ህትኔ ሆጉተ አዕዮ መንች አሌን ቀርቾሃ ኢስ ሱዕሚን ፈረጆም፤ ");
INSERT INTO alw_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","ጭምይቴነንተ ወክት አኒሁ ቀርቹሃኔ ኢስ ዎልቃን በላንከክዕኔ ሰውቲን ሄኣምቤቺሃ ");
INSERT INTO alw_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","መሲህ ለምቅ አሜቶን ከን መንች ነብሶሁ ጡሞተ ህትናሞ መንች ማል ሰውቱ በኦተ ሸይጣኒሃ ህግሽ ኣሱ ሀስሰኖ ይ ፈረጆም። ");
INSERT INTO alw_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","ህካን እኮቤቺሃ ቦኑክዕኔ ጡመሃበአ፤ ቀቅቹ ራጭቱ አበ ቡኩተ አቦከኖገ ደጌነንተበእንዶ? ");
INSERT INTO alw_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","ቴሱ እኬንተሀንገ ራጭቱ ዮበእ ሃዕሮ ቡኮገ እኮኖተ ዱንኬ ራጭተ ክዕኔች ቄርስዬ፤ መሰንትስ ሻሽግ ሆልቹ እኮ መሲህ ኢስ ጎረጠሞኡ፤ ");
INSERT INTO alw_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ህካን እኮቤቺሃ ተንኩትለከ ሂሉ ጠዉሁ ዊሞ ዱንኬ ራጭቲን እሁዕነ ራጭቱ ዮበእ ነጠለከ ሀንቁ ዊሞ ጦሮሽ ከበጀኔ ከበጅኖ። ");
INSERT INTO alw_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","ከኒች ብርተ ከተቦንክዕኔ ሶህኖን ዝነተ አታ መኒን ሜጡ እኮኖቼ ይዮንክዕኔ እቅ። ");
INSERT INTO alw_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","ህካን ዩእ ጉዕመ ከን ኣዱንያ አሌን ሄኣ ዝነተ አታ ህከረንገ ጎራይታ መኒች ህከረንገ ሞጋኖች ህከረንገ ሽርከተ አታ መኒን ሜጡ እኮኖቼ ዩሃእበአ፤ ህካን እኮጎሬ ኣዱንያ አሊች ፉሉ ሀስሰኖኔ ዩሃን። ");
INSERT INTO alw_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","አን እኮጎሬ ከተቦንክዕኔሁ አመዕናኑተ እክ ዝነተ አታሀኑኡን፥ ህከረንገ ጎራይታሀኑኡን፥ ህከረንገ ሽርከተ አታሀኑኡን፥ ህከረንገ መን ሱዕመ ቤሳሀኑኡን፥ ህከረንገ ሰከርታሀኑኡን፥ ህከረንገ ሞግታሀኑኡን ሜጡ እኮኖቼ ይይት። ህትኔ መኒን ሜጡበ እቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","መገኑ አመዕኔ ጭምቲች አብሊን ዮ መን አሌን አን ፈረዶተ ም አግሾኤ? መገኑ አመዕኔ ጭምት ኣዜን ዮ መን አሌን አዕኑ ፈረዴነንተበእንዶ? ");
INSERT INTO alw_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","አመዕንትበ መን አሌን ፈረደኖሁ መገኑሃን፤ ህትን መጻፋን «ሂለ መንቹ በሊችክዕኔ ፉሽቴን ከሜ» ዬገን አዕዬ። ");
INSERT INTO alw_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","ክዕኔች መቱ አመዕናንቹ እኮ አመስ ቤቲን ብተሞ ጎር ጠወስ አመዕናኑት ለኣገ አአኖ ወጥ መገኑ አመዕንቶበእ ዳኛኖበ መሮተ ሀት መለለኖ? ");
INSERT INTO alw_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","መገኑ አመዕንቶ መኑ ከን ኣዱንያ አሌን ሄኣ መን አሌን ፈረዳገ ደጌነንተበእንዶ? ህከረ ኣዱንያ አሌን ፈረዴነንታሃ እሀን ከን ቀዎ ጠው አሌን ፈረዱ ቄለኖህዕኔንዶ? ");
INSERT INTO alw_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","ህትን ነኡ መላይከ አሌን ፈረንዳምገ ደጌነንተበእንዶ? ህከረ ባሰንከስ ከን ኣዱንያ አል ጠዋን ፈረዱ ሀት አታልናምበአ? ");
INSERT INTO alw_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ቴሱ ገገዉክዕኔ ብተንቴንተጎር አመዕንቶበእለከ ህንቀንቶ መን ብርተ ጠወክዕኔ ሀት ሆንጠህሴነን? ");
INSERT INTO alw_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","ካን ያሚሁ ሙልቶኖተ ይዪት፤ ሀት አመዕናኖ በላን ሀራርሶህዕኔተ አታለኖ ባልቁ ዮበእንዶ? ");
INSERT INTO alw_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","ህከረ መቱ አመዕኔ መንቹ ዎሉ አመዕኔ መንቹ ኦዶተ አመዕንትበ ዳኛኖበ መረኖንዶ? ");
INSERT INTO alw_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","ህትን ገገዉክዕኔ ከሰጨንቴን ኦደሙ ክዕኔሃ ቢልኝየ፤ ባሰንከስ አዕኑ ምርተኡክዕኔ ህከረንገ ጣንሰሙክዕኔ ቆሀኖበእንዶ? ");
INSERT INTO alw_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","እኮጎሬ አዕኑ አመዕንቶ አመክዕኔ ኦሱተ ምርቴነንታትለከ ጣንስቴነንታት። ");
INSERT INTO alw_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ሾኩ መኑ መገን ዎምነቱ ዎረሳበእገ ደጌነንተበእንዶ? ከን ጠዋን ጣንሰንቶኖቼ፤ ፎኩተ አታእሩ፥ ህከረንገ ሽርኬተ ሰገዳእሩ፥ ህከረንገ ዝነተ አታእሩ፥ ህከረንገ ጎኑ ጎኒን ዝነተ አታእሩ ");
INSERT INTO alw_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ህከረንገ ሞግታእሩ፥ ህከረንገ ጎራይታእሩ፥ ህከረንገ ሰከርታእሩ፥ ህከረንገ መን ሱዕመ ቤሳእሩ፥ ህከረንገ ዘረፋእሩ መገን ዎምነቱ ኣጋበአ። ");
INSERT INTO alw_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","ክዕኔች መት-መቱክዕኔ ህትናመተ እቅ፤ ቴሁ እኮጎሬ ቀርቾ መሲህ ኢስ ሱዕሚንለከ ኒ መገን አያኒን ጩቢች ነጠ እኬንታአ፤ መገኒሃ አደ እኮ ጠሊለ ኡመትለከ ፈየ እኬንታአ። ");
INSERT INTO alw_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","«ጉዕሙርቹንኩ ፈቀደሞኤ» እኮጎሬ ጉዕሙርቹንኩ ደግለለኖኤ ዩሃበአ፤ ጉዕሙርቹንኩ ፈቀደሞኤ፤ እሁን ቤሉ እኮስ ጠዊሃ ሮስ እክ ጠገማምበአ። ");
INSERT INTO alw_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","ህትን «እቸት ጎዳቢሃ፥ ጎደቡንኩ እቻታት» እኮጎሬ መገኑ ለሙንከስ ቤሰኖ፤ ጠዉ እኮጎሬ ጅስሙኔ ቀርቾ ኢሲሃ፥ ቀርቹ ኢስን ጅስሚሃኔ እኮቤቺሃ ጅስመኔ ዝናተ ህግንስ ኣሱ ሀስሰኖኔበአ። ");
INSERT INTO alw_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","መገኑ ቀርቹ ኢሰ ሬሆች ኬሾስ፤ ኔሳሁ ዎልቃንከስ ሬሆች ኬሰኖኔ። ");
INSERT INTO alw_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","ጅስሙክዕኔ መሲህ ጅስመ እሁስ ደጌነንተበእንዶ? ህከረ አን መሲህ ጅስመ መስ ዝነተ አታ መንቾ ጅስመ አኡ ሀስሰኖንዶ? ሆሮ ሀስሰኖበአ! ");
INSERT INTO alw_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","ዝነተ አታ መንቾን ደቀመኖ መንቹ እሴን ሜጡ ጅስመ እሁስ ደጌነንተበእንዶ? «ለሙንኩሰ መቱ ጅስመ እካአ» የመም ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","ቀርቺን ሜጡበ ገውስ መቱ አአኖ መንቹ እሲን ሜጡበ አያኒን መቱ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","ህካን እኮቤቺሃ ዝነተ አቶኖቼ፤ መኑ አአኖ ዎሉ ጩቡ ጅስሚችስ አብሊን እሀኖሃን፤ ጠዉ እኮጎሬ ዝነተ አአኖ መንቹ ገይስ ጅስም አሌን ጩብ አአኖ፤ ");
INSERT INTO alw_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","ጅስሙክዕኔ መገኒች ቶጌንታእለከ ኣዜንከክዕኔ ሄአኖ ጠሊሉ አያኑ ፎሎጨኖ ቤቹ እሁስ ደጌነንተበእንዶ? ቴሱ አዕኑ መገንረ ቤሉ ገይክዕኔረበአ። ");
INSERT INTO alw_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","እስ ዋጊን ህዕርዮህዕኔ፤ ህካን እኮቤቺሃ ጅስምንከክዕኔ መገኑ ኬዕምሼ። ");
INSERT INTO alw_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","አዕኑ ከተቤንተኤ ጠዊተኔሃ እኮጎር መኑ ሜንቱ ኤቡዕነ ፈቆእቃ ጡመሃን። ");
INSERT INTO alw_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","ጠዉ እኮጎሬ ዝነተ አኢች አገዕርተኔሃ መት-መትሀስ ገይስ ጫት ሄኡንስ፤ ህትን ገዬተሴ ገይሴ ጨዉ ሄኡንሴ። ");
INSERT INTO alw_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","ምንሴ አኑ ገይስ ጫን ሜጡበ ኦሰአኖ ሀንቅሴ ከሙንከ፤ ህትን ጫንት ጨይንከሴ ሜጡበ ኦሰኣ ሀንቅስ ከንቱንከ። ");
INSERT INTO alw_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ጫት ገይሴ ጅስም አሌን ሹምነቱ ዮሴበአ፤ እሴ ጅስም አሌን ሹምነቱ ዮሲሁ ጨዊሃሴት፤ ህትን ጨዉ ጅስምስ አሌን ሹምነቱ ዮስበአ፤ እስ ጅስም አሌን ሹምነቱ ዮሴሁ ጫታት። ");
INSERT INTO alw_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ህትን ዱአ አቶኖተ ኢተቀንቴን ቀዎ ወክቲሃ አገሩ እህባች ገገዉክዕኔ ከዕመቀንቶኖቼ፤ ህትን ገዉ አገዕሩ ሆግን ሼይጣኑ ሉሲሰኖህዕኔበእገ ፈንቀልቴን ሜጡበ እኬ። ");
INSERT INTO alw_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","ጠዉ እኮጎሬ አን ካን ያንክዕኔሁ ሸዘነገ ያንክዕኔ ቤሉ አዘዝጋበአ። ");
INSERT INTO alw_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","መኑ ጉዕሙንኩ ኢገ እኮ እቃን ኢታም እቅ፤ ጠዉ እኮጎሬ መገኑ መት-መትሀስ አደደ ኣስቱተ ኣሴእ፤ ህካን እኮቤቺሃ መትሀስ መቱ ኣስቱት ሄኣስ፤ ህትን ዎልሀስ ዎልት ኣስቱት ዮስ። ");
INSERT INTO alw_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","ምኒሃ እኮበእሩለከ ህትን ምንሰ አኑ ሬዮ ሜንቱሁ ኤቡዕነለከ ገልቱዕነ ኢገ እክ ሄኦ እቃን ጡመ እቅ። ");
INSERT INTO alw_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","ጠዉ እኮጎሬ ሄዕላቴነን ቡቢች ጎጆሃ እሁ ቆሀኖቤቺሃ ገዉሰ አታዕሉ ሆጋ ወክት ጎጆሃ እኩን። ");
INSERT INTO alw_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","ጎጆሃ እኮሀኑኡተ ኣሳም ትዛዙ ከኒት፤ ሁኩ ትዛዙንኩ ቀርቺሃ ቤሉ እሃበአ፤ ገልቶ ጫት ምንሴ አኒች መለዕለንቱንከ። ");
INSERT INTO alw_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","መለዕለንቶጎሬ ሜጥሃሴ ሄኡን ህከረንገ ጨይንከሴ ሀራዕረንት ሄኡን፤ ህትን ምንሴ አኑ ጫስ ገፈሩንከ። ");
INSERT INTO alw_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","ዎልሀስ ቀርቹ ኢስ እሁዕነ አን ያሚሁ መቶ አመዕኔ መንቺሃ አመዕንቶበእ መንቹት ዮስጎሬ እሴን ምንሴ አኒን ሜጡበ ሄኦተ ሀሶ ጎሬ ገፈሩንከ። ");
INSERT INTO alw_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","ህትን አመዕንዮበእ ምኒ አኑ ዮሴ መንቹት ምንሴ አኑ እሴን ሜጡበ ሄኦተ ሀሾ ጎሬ ገፈርቱንከ። ");
INSERT INTO alw_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","መሰንትስ አመዕንቡ ምኒ አኑ አመዕንቶ መንቾ መሳን መገኒሃ አደ እኮሃ እሀኖ፤ ህትን አመዕንቶበእ መንቹት አመዕንዮ ምንሴ መንች መሳን መገኒሃ አደ እኮሃ እካአ፤ ህካን እህባች እለክዕኔ መገኒሃ አደ እኮተ አታልታበአ፤ ጠዉ እኮጎሬ ከን ሃሊን ሄኤንተ ጎር ኦሱክዕኔ መገኒሃ አደ እኮሃ እካአ። ");
INSERT INTO alw_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","አመዕናንቹ እኮበእ አዱ አደ እሆተ ሀሾ ጎር አደ እሁን፤ ጠዉ እኮጎሬ ከን ወክቴን አመዕናንቹ እኮሁ ምኒ አነ እኮ ምኒ አመተ መቶርቾን ግዳጅሴኖሰበአ፤ መገኑ ገኤኔሁ ወገሬቲን ሄዕኖታት። ");
INSERT INTO alw_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","አት አመዕንቶንት ጫት አመዕንቡ ምንክ አነ ጡምሳንትጎር ሚን ደገን? ህትን አመዕንቶንት ምኒ አኑ! ምንክ አመተ አይደጎ ጡምሶተ አታልታ ጎሬ ሚን ደገን? ");
INSERT INTO alw_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","መት-መቱስ መገኑ ሄእ ዬስ ሃሊንለከ መገኑ ገኤስ ሃሊን ሄኡን፤ መገኑ አመዕኔ መን ጭምቲሃ ጉዕሚንከ ኣሴ ትዛዙ ከኒት። ");
INSERT INTO alw_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ህትን ጡርከመሞች ኤተሮን አመዕኔ መንቹ አዪሁ ሄዕዮ ጎሬ ጡርከመሞበእሀንገ እሆተ ሰውዩንከ፤ ህትን ጡርከሙዕናን ሄጭ አመኔኢሁ ጡርከሚሃ ሀሱንከ። ");
INSERT INTO alw_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","መሰንትስ መገን ትዛዝ አገሩሃ ቤሉ ጡርከመሙ ህከረንገ ጡርከመሙ ሆጉ መቱርቹሃ ደግለለኖበአ። ");
INSERT INTO alw_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","ህካን እኮቤቺሃ ገገዉንኩስ መገኖን አመዕኔ ወክት ዮ ሃሌን ሄኡን። ");
INSERT INTO alw_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","ህትን አት መገኑ አመዕንቶንት ወክት ሮስቹሃ እቅንዶ? እኮንት እቃ ሆሮ ሰዉ ይቶት፤ እኮጎሬ ሰዎልድማን ፉልቶተ መኩተ ደእቶንት ጎር ሆሮ አጉርቶት። ");
INSERT INTO alw_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","መሰንትስ ሰዎልድማን ሄዕዮገ ቀርቹ አመዕኔ መንቹ ቀርቺን ሰዎልድቹሃን፤ ህትን አመዕነኖ ወክት ሰዎልድቹ እኮ መንቹ መሲህየ ሮስቹ። ");
INSERT INTO alw_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","አዕኑ መሲህ ኢስ ዋግን ህዕሬኔቤቺሃ መኒሃ ሮስ እኮኖቼ። ");
INSERT INTO alw_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","ህካን እኮቤቺሃ አመኤ ኦሶ! ጉዕሙንኩ መኑ ገአሞ ወክት ዮ ሀለቴን እክ መገኒን ሜጡበ ሄኡን። ");
INSERT INTO alw_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","ቴሱ ጎጆሃ እኮበእ መንተኔሃ ቀርቾ ኢሲች ቶጎም ትዛዙ ዮኤበአ፤ ጠዉ እኮጎሬ አመዕነሞሚሃ እሆተ መገኒች ማርቱተ ደኤም እኮቤቺሃ ገይኤ ሰዉት ኣሳንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","ከን ዘማን ኦርሸተኔሃ መኑ ዮ ሃሌን ሄአኖረ ጡመ አጉደኖኤት። ");
INSERT INTO alw_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","ህካን እኮቤቺሃ ጎጆሃ እኮንትጎር ሸርቶተ ሀሶት፤ ጎጆሃ እኩዕነ ዮንት ጎር ኤቦተ ሀሶት። ");
INSERT INTO alw_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","ጠዉ እኮጎሬ አት ጎጆሃ እኮንትጎር ጩብ እሀኖ ዩሃበአ፤ ህትን መት ሀፍቱት ጎጆሃ እኮ እቃን ጩብ እሀኖሴ ዩሃበአ፤ እሁን ቤሉ ጎጆሃ እካ መኑ ከን ኣዱንያ አሌን አበ ኦርጨቀንታአ፤ አዕኑ ከኒች ፈቄንታ እቃን ኢታም እቅ። ");
INSERT INTO alw_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","አመኤ ኦሶ! ዘማኑ ገበንቹ እኮቤቺሃ ከን ወክቲች ጀመር ምኒ አመት ዮሲሁ ምኒ አመት ዮስበእሀንገ እክ ሄኡን፤ ምኒ አማኑት ዮሰሩ ዮሰበእሀንገ እክ ሄኡን። ");
INSERT INTO alw_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","ህትን ሻዛሩ ሻዛበእገ እክ ሄኡን፤ ሙንደኣእሩ ሙንደኣበእገ እክ ሄኡን፤ ኦዳተ ህዕርታሩ ኦዳተ ዮሰበእሀንገ እክ ሄኡን። ");
INSERT INTO alw_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","ህትን ከን ኣዱንያ አሌን ዮኢሃ ገይሳሃ አታሩ ጉዕሙንኩ ደግለሸቀንታበእገ እክ ሄኡን፤ መሰንትስ ከን ኣዱንያ አሌን ዮኢሁ ጉዕሙንኩ ህገኖሃን። ");
INSERT INTO alw_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","አዕኑ ሻዞኑዕናን ህከኒሃ ሄኦኖተ ኢታም፤ ጎጆሃ እኮበእ መንቹ ቀርቹ ሙንዲሲሰኖ ጠወሃ ሀሰኖቤቺሃ ቀርች ጠዊተኔሃ ሰዉ የኖ። ");
INSERT INTO alw_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","ጠዉ እኮጎሬ ጎጆሃ እኮ መንቹ ምንስ አመተ ሙንዲሲሰኖ ጠወ ሀሰኖቤቺሃ ከን ኣዱንያ አል ጠዊተኔሃ ሰውየኖ። ");
INSERT INTO alw_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","ህከን መንች ቀልቡንኩ ለሙ አደ እኮእሃን፤ ህትን ጎጆሃ እኮበእ መንቹት ህከረንገ ሀፍቱት ማሉሴለከ ሩሁሴ ጠሊለ እክ ቀርቺሃ እኮተ ሰዉ ይታቤቺሃ ሰውቱሴ ጉዕሙንኩ ቀርች ሆጎ አሌኒት፤ ጎጆሃ እኮ መንቹት ጫሴ ሙንዲሲሶተ ሀሳቤቺሃ ከን ኣዱንያ አል ጠዊተኔሃ ሰዉ ይታአ። ");
INSERT INTO alw_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","አን ህት ዬንክዕኔሁ ዎሻዲን አፎህዕኔተ እሁዕነ ክዕኔሃ ደግለለኖ ይዪት፤ ህትን ሀስሰኖ ሃሊን ሄኦኖታትለከ ሰዊቱክዕኔ ብንዩዕናን ዊመ ቀልቢን ቀርቾ ኢሳን ጠረኝቴን ሄኦኖታት። ");
INSERT INTO alw_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","መቱ መንቹ ኢተቀሞ ጩልተ መዕሲሰንታ ጌሰ እኮ ወክት ገዉስ አታዕሉ ሆጊን ኣኦተ ሀሾ ጎሬ ከመኖስ ጠዉ ዮበአ፤ እሴንተ ኣኡን፤ ሁኩን ጩብያበአ። ");
INSERT INTO alw_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","ጠዉ እኮጎሬ አዪሁ ኢተቀሞ ጩልተ ኣኦተ ግዳጅሰኖስ ጠዉ ዮስበእጎሬ ኣኡዕነ ዱንኮተ አታሎጎሬ ጠወስ ቀልቤንከስ ሙርሲጬኢች ሁኩ መንቹ ጡመ አዕዮኡ። ");
INSERT INTO alw_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","ህካን እኮቤቺሃ ጠዕሜ ጩልተ ኣኡስ ጡመ አዕዮኡ፤ ጠዉ እኮጎሬ አኡነ ፈቆሁ ቆሀኖሃ አዕዮኡ። ");
INSERT INTO alw_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","መት መንቹት ጨዉሴ ፎሊን ዮ ጌሳን ንክን ኡሱረንቶእተ፤ እኮጎሬ ምንሴ አኑ ሬዮ ወክት ገልታ መንቹ አመዕናንቹ እሁን ቤሉ ሀሶሀኒን ገልቶተ አታልታአ። ");
INSERT INTO alw_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","ጠዉ እኮጎሬ አን ሰውያም ሃሌን ህት ጫት ገልቱዕናን ሄኦ እቃን አበ ሙንዲኖን ሄኣ እቅ፤ ህትን ኤሳሃ መገን አያኑ ዮኤሃ አጉደኖኤት። ");
INSERT INTO alw_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","ሽርኬተ ክትመሞ ማልተኔሃ ጉዕሚንከኔ ኤንኬዕኑ ዮኔ፤ ኤንኬዕኑ ቦንሲሰኖ፤ እኮጎሬ ኢተት ጠረኝሳአ። ");
INSERT INTO alw_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","መቱ መንቹ «ኤንኬዕኑ ዮኤ» ይ ሰዉ ዬጎሬ ሁኩ መንቹ ደጉ ሀስሰኖስ ጌሰ ሆሮ ደጎበአ። ");
INSERT INTO alw_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","ጠዉ እኮጎሬ መቱ መንቹ መገኑ ኢቴስጎሬ ሁኩ መንቹ መገን ቤቾን ኤንኬዕነሞሃን። ");
INSERT INTO alw_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","ህካን እኮቤቺሃ ሽርኬተ ክትመሞ ማለ እትተኔሃ እኮጎሬ ሽርክተ ጉዕሙንኩ ከን ኣዱንያ አሌን ሄእባሃ እሁሰለከ መቶ መገን ቤሉ ዎሉ መገኑ ሄእባሃ እሁስ ደንጋም። ");
INSERT INTO alw_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","መሰንትስ ልግቡ ሽርክትለከ ልግቡ ቀርቹ እኮእሩ ዮኡ፤ ጠዉ እኮጎሬ ሄንከ ሰማንለከ ኡላን «መገኑ» ዬኖሰሩ ሄኦ ጎሬ ");
INSERT INTO alw_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ጠዉ እኮጎሬ ኒ መገኑ ጉዕመርቹንከ ከለቆለከ ነኡሁ እሲሃ እንኮምሩ መቱ መገኑ አነ እኮኔሁ ዮኔ፤ ህትን ጉዕሙርቹንኩ እስ አዲን ከለቀሞለከ ነኡሁ እሲን ሄዕናም መቱ ቀርቹ መሲህ ኢስ ጠለዕል ዮኔ። ");
INSERT INTO alw_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","ጠዉ እኮጎሬ ካን ጉዕሙ መኑ ደገኖበአ፤ መት-መቱ ከበሬ እለ ሽርኬን ሮሰቀንቶቤቺሃ ማለ እታኢሁ ሽርኬተ ክትሜመሀኒገ አት ሰዉ ይታቤቺሃት፤ ህካን እኮቤቺሃ ቀልቡሰ ላፈ እኮቤቺሃ ንጃሳአ። ");
INSERT INTO alw_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","ኔሳሃ መገን አደ ሆንጠህሰኖኔሁ እቸተበአ፤ እንትበጎሬ ጤዕየኖኔርቹ ዮበአ፤ እንቶምእቃ በርገመኖኔርቹ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","ጠዉ እኮጎሬ ሁኩ ሰዎልድመኔ አመዕነቲን ጠረኝቶበእ መኒሃ ሉስሰኖሃ እሀኖሰበእገ አገዕርዬ። ");
INSERT INTO alw_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","መሰንትስ አዪሁ አት ኤንኬዕኑ ዮኤ ይታንቲሁ ሽርኬ ምኔን ማዳን አፉዕልት እተን አመዕነቲን ጠረኝቡ መንቹ ለዕዮሄጎሬ ሽርኬሃ ክትሜመ ማለ እቶተ መለለኖገ አታንትበእንዶ? «ኤንኬዕኑ ዮኤ» ይት ሽርኬተ ክትመሞ ማለ እተኖገ ሀንበለንሰኖስበእንዶ? ");
INSERT INTO alw_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","ህካን እኮቤቺሃ መሲህ እስተኔሃ ሬዮ ሁኩ አመዕነቲን ላፉ መንቹ ኪ ኤንኬዕኒን በአኖ ዩሃን። ");
INSERT INTO alw_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ከን ሃሊን አመዕናኖ አሌን ጩብ አቴነንተለከ ላፈሰ ሰዉት ጡላይሴነንተ ወክት መሲህ አሌን ጩብ አቴነንታት ዩሃን። ");
INSERT INTO alw_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","ህካን እኮቤቺሃ እቸት አመዕናንቹ አመኤ ቤቲሃ ጉፍቹ እሀኖሃ እኮች አመኤቤቱ ሉስሳምሀኒች ማለ ሆሮ እታምበአ። ");
INSERT INTO alw_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","አን ሰዎልድቹሃበእንዶ? ህትን አን አሳቤቹሃበእንዶ? አን ቀርቹኔ ኢሰ ለእዮንስበእንዶ? አዕኑንገ ቀርቹሃ ኢሲን አዕዮም ሆጎእየ ላልቹበእንዶ? ");
INSERT INTO alw_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","ቀርቹሃ ኢሲን አዕኑ ኤሳሃ አሳቤቹ እህእ መላተ እኬንተቤቺሃ ዎሎ መኒሃ ሶቀማንቹ እህበጎሬ አን ክዕኔሃ ሀንቅንከ አሳቤቹሃን። ");
INSERT INTO alw_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","ሱዕመኤ ቤሳ መኒሃ ፈንቀሻም መስሉ ከኒት። ");
INSERT INTO alw_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","ኔሳሃ እቲሃለከ አጊሃ ሀንቁ ዮኔበእንዶ? ");
INSERT INTO alw_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","ዎሎ አሳበገለከ ቀርቹሃ ኢስ አመ ኦሶገ ህትን ጴጥሮሴገ መገኑ አመዕንቶ ምኒኔ አማኑተ አዎንስን ሜጡበ ሃሞተ ሀንቁ ዮኔበእንዶ? ");
INSERT INTO alw_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","ህከረንገ ሆጎን አጰመን ሄኡ ሀስሰኖኔሁ ጠለዕል አንለከ በርናባሴቲንዶ? ");
INSERT INTO alw_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","ገይስ ብሪን ዎታደርቹ እክ አአኖ መንቹ ሄአኖንዶ? ህትን ዎይን ሀቀ ካሽ ላልቹስ እትባሁ አዬት? ህትን ለሉ ጠቅ ለልስ አዙተ አገኖበእሁ አዬት? ");
INSERT INTO alw_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","አን ከ ጠወ ጠወኣሚሁ መኑ ሰውየኖ ሃሊንትንዶ? ሕጉሁ ህት የኖበእንዶ? ");
INSERT INTO alw_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","መሰንትስ «ዉጠተ ዎቀሬኖ ቦር አፎስ ኡሱርቶት» የመም ሙሲ ሕጋን ከተበሞኡ፤ መገኑ ህካን ዬኢሁ ቦረተኔሃ ሰውየኖቤቺሃትንዶ? ");
INSERT INTO alw_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","መገኑ ህካን ዬኢሁ ኒተኔሃበእንዶ? ለሙንኩ ዉጣች ወጥሰ ደእቶተ አቡረኖሁ ተብሴን አቡረኖቤቺሃ፥ ዉጠተ ዎቀረኖንኩ ተብሴን ዎቀረኖቤቺሃ ሁኩ ጠዉ ከተበሞሁ ሀንቅንከ ኒተኔሃት። ");
INSERT INTO alw_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","ነኡ ክዕኔ በላን መገን ጠወ ዉንጣምረ እንኮሚች ኔሳሃ ማሊሃ ደግለለኖርቹ ኣእኖም ጎሬ ሁኩን ሎረ ጠወንዶ? ");
INSERT INTO alw_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","ዎሉ መኑ ክዕኔች ሀስሰኖሳሃ ኣእቶተ አታልታኢሃ እኮች ነኡ በትንስ ኣኡ ሀስሰኖኔበእንዶ? ጠዉ እኮጎሬ መሲህ ተሽት ላገት አልባዕልታቤቹ ከማምበእገ ይን ጉዕመ ጠወንከ አታዕልናም ቤሉ ኔሳሃ ሀስሰኖኔርቹሃ ኣእኖተ ሀንሶምበአ። ");
INSERT INTO alw_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","መገን ምኔን አታ መኑ እታኢሃ መገን ምኒች ደእታገለከ መገኒሃ ክትም ሆንጠህሴኖ ጠረጴዚች መኑ ክትሚሃ ሆንጠህሴመርቺች ቤቀንት እታኢሃ ደጌነንተበእንዶ? ");
INSERT INTO alw_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","ህከንገን ተሽት ላገተ ዱዱብስታ መኑ ተሽት ላገ ሆጎች ርስቀሰ ደእታገ ቀርቹ አዘዦኡ። ");
INSERT INTO alw_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","እኮጎሬ አን ከን ጉዕማንከ ሀንቂች መቶንከስ ደግለሸቀሞምበአ፤ ቴሱ ከተባሚሁ ህትኔ ጠዉ እሆኤተ ሀሽበአ፤ መሰንትስ አን ድከኣም ጠወ አዪሁ ተሰ አአኖሀኒች ሬሁ ቆሀኖኤ። ");
INSERT INTO alw_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","ህትን ተሽት ላገተ ዱዱብሱ ኤሳሃ ግደ እኮቤቺሃ ተሽት ላገተ ዱዱብሲንከኤ ቦናምርቹ ዮኤበአ፤ ህካን እኮቤቺሃ ተሽት ላገተ ዱዱብስበጎሬ ኤሳሃ ኣዬ! ");
INSERT INTO alw_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","መሰንትስ አን ገዉእ ኢት እንጂለ ዱዱብሳሚሃ እኮምጎሬ ዋጉ ዮኤ፤ ጠዉ እኮጎሬ ግዲን አኣሚሃ እኮምጎሬ ኤገት ኣሰንቶኤቤቺሃ አኣሚት ዩሃን። ");
INSERT INTO alw_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","ህከረ ሆጎኤ ዋጉ መርቹሃን? ቴሱ ሆጎኤ ዋጉ ተሽት ላገተ ተማርሴምቤቺሃ ዮኤ ሀንቅ ደግለሸቀሙዕናን እንጂለ ተማርሳም ሆጉኤን ደሞዝ ቤሉ ተማርሱሃን። ");
INSERT INTO alw_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","መኒች ጉዕሚችን ሰዎልድቹ እኮምጎሬሁ ልግብ መነ ፈይሶተ ይ መኒሃ ጉዕሚንከ ገጉኤ ሮስቹ አዕዮም። ");
INSERT INTO alw_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","ህትን አይሁድ መነ ጡምሶተ ይ አይሁዲሃ አይሁድገን እኮም፤ ህትን ሕግ ኣዜን ሄዕበጎሬሁ ሕግ ኣዜን ሄኦእረ ጡምሶተ ይ ሕግ ኣዜን ዮ መንገ እኮም። ");
INSERT INTO alw_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","ህትን ሕጉ ዮበእ መነ ጡምሶተ ይ መገን ሕጉ ዮኤሃለከ መሲህ ሕግ ኣዜን ሄዕዮሚሃ እኮምገን ሕጉ ዮበእ አይሁደ እኮበእ መኒሃ ሕጉ ዮበእ መንገን እኮም። ");
INSERT INTO alw_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","ህትን አመዕነቲን ላፈ መነ ጡምሶተ ይ ላፈ መኒሃ ላፈ መንገን እኮም፤ አታልሲሾኤ ጌሲን ቀዉ መነ ጡምሶተ ይ ጠዋን ጉዕማንን መኒሃ እሰገን እኮም። ");
INSERT INTO alw_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","አን ተሽት ላገ ማሰተ ቤቀማንቹ እሆተ ይ ተሽት ላገተኔሃ ህከ ጉዕመንከ ጠወ አዕዮም። ");
INSERT INTO alw_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","ሄጫቀሜኖቤቾን ደጉደኖሁ ጉዕሙንኩ ሄጫቀመኖገለከ ጠለዕል ሜጥቹስ ሽልማት ኣአኖገ ደጌነንተበእንዶ? ህትን ሽልማት ደእቶኖተ ሄጫቀሜ። ");
INSERT INTO alw_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","ሄጫቀመኖሁ ጉዕሙንኩ ጉዕመርቾንን ጅስመስ ጠረኝሽ ቅጥአአኖ፤ እሰን ህት ሆጋኢሁ በአኖሃለከ ወክቲሃስ እሀኖ ሽልማት ደኢሃት፤ እኮጎሬ ነኡ ሆንጋሚሁ በአኖበኢሃለከ ዘላለሚሃ እሀኖ ሽልማት ደኢሃት። ");
INSERT INTO alw_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","ህካን እኮቤቺሃ አን ሰውቱ ዮበእ መንገ ደጉዳምበአ፤ ህትን ቦብረ ጡንጤን ዎቀረኖ መንችገ ጠለዕለ አኣምበአ። ");
INSERT INTO alw_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ጠዉ እኮጎሬ ዎሎ መኒሃ ዱዱብሴሚች ኤተሮን ገጉእ ኡቦሚሃ እሃምበእገ አልኤ ቀጠአን አዘዘመኖኤገ አኣም። ");
INSERT INTO alw_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","አመኤ ኦሶ! አናከኔ ጉዕሙንኩ ጎመት አሊን እክ አዎንስተንሰ ጉዕሙንኩ ባረ ቶልቶገ ደጎኖተ ሀሳም። ");
INSERT INTO alw_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","እሰን ጉዕሙንኩሰ ሙሲን ሜጡ እኮተ ይት ጎማንለከ ባራን ጠመቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","ህትን ጉዕሙንኩሰ መቱ ደነ ሰሜ እቸተ እቶኡ። ");
INSERT INTO alw_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ህትን ጉዕሙንኩሰ መቱ ደነ ሰሜ አጌኖሃ አጎኡ፤ አጎኢንኩ አዎነንሰ ሄዕዮ ሰሜ ክኒች ቡቆኢሃ እቅ፤ ሁኩ ክኑንኩ መሲህት እቅ። ");
INSERT INTO alw_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","እኮጎሬ እሰ ኡለ ኡዱማን ጎፎቤቺሃ መገኑ እሳች ልግብንከሰ ሙንደዕዮበአ። ");
INSERT INTO alw_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","እሰ ሂለርቹ ሄዕላቶገን ነኡ ሂለርቹ ሄዕላንታምበእገ ኩ ጠዉ ጉዕሙንኩ አገዕርናምገ ምሳልተ እኮኔ። ");
INSERT INTO alw_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","መጻፋን «መኑ እቶተለከ አጎተ አፉዕልቶኡ፤ ቦሎቸ ከዲሃ ኬኦኡ» የመም ከተበሞገን እሳች መት-መቱሰ ሽርኬተ ሰገዳእረ እኮገን አዕኑሁ ሽርኬተ ሰገዴነንተረ እኮኖቼ። ");
INSERT INTO alw_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","እሳች መት-መቱሰ ዝነተ አት መቶ በሬን ለሞድምኔ ሰሶ ኩሜ መኑ ሬቶገን ነኡሁ ዝነተ አዕኑንከ። ");
INSERT INTO alw_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","ህትን እሳችን መት-መቱሰ ቀርቹ ፌተንቶገለከ ዎሪቹ ከር ሼሰገን ነኡሁ ቀርቹ ፌተኑንከ። ");
INSERT INTO alw_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","ህትን እሳች መት-መቱሰ ቁንቁቶገለከ ቤሳንቹ መላይኬቹ ቤሾሰገን አዕኑሁ ቁንቁቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","ኩ ጉዕሙንኩ ጠዉ እሰ አሌን እሁስ መጨረሽ ዘማኔን ሄዕናም ነኡ አገዕርኖተ ትምርተ እክ ከተበሞኔ። ");
INSERT INTO alw_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","ህካን እኮቤቺሃ ጠረኝ ኡሬኢሃ አጉደኖሲሁ አዪሁ ኡበኖበእገ ገውስ አገዕሩን። ");
INSERT INTO alw_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","መናን ኢለኖሀኒች አደ እኮ ኦርሸት ክዕኔ አሌን ኢልቶህዕኔበአ፤ መሰንትስ ዎልቃችክዕኔ ሎረ እኮ ዎቄን ኦርጨቀንቶኖተ ሰውየኖ መገኑ አመዕነሞእሃን፤ እስን ኦርሸስ አታዕል አታልቶኖተ ኦርሻንከስ ሜጡበ ኦርሻችስ ፉልቴነንተ ዎቃሃ ቅጥ አዕዮኡ። ");
INSERT INTO alw_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","ቴሱ ኢ ጃላ! ሽርኬተ ሰገዲች አገዕርዬ። ");
INSERT INTO alw_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","ህካንን ያሚሁ ዘህጭቴነንተረ እኬንተቤቺሃት፤ ህካን እኮቤቺሃ ጠወዕዮም ጠውተኔሃ አዕኑ ገዉክዕኔ ፈረጄ። ");
INSERT INTO alw_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","ነኡ መገኑ ገለትጭን አንጋም ማሰአሞ ጠበቴሁ መሲህ ቄጊን መቱሃበእንዶ? ህትን ሜጡበ እንታም ዳቡት መሲህ ጅስሚን መቱሃበእንዶ? ");
INSERT INTO alw_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","መሰንትስ ዳቡስ ሜጥተ እኮቤቺሃለከ ህከን መቴ ዳቦች ቤቀማምቤቺሃ መሃ ልግብ መነ እንኮምጎሬሁ ነኡ መቶሃ ጅስመ። ");
INSERT INTO alw_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","ህንዴ እስራኤል ኡመትተኔሃ ሰውይዬ፤ ክትሜኖርቹ እታ መኑ መገኒሃ ክትም ሆንጠህሴኖ ጠረጴዚን ሜጡበ ዮረበእንዶ? ");
INSERT INTO alw_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ህከረ ህካን ያም ወክት ሽርኬተ ክትሜመ ማሉ ቆሀኖርቹ ዩሃስንዶ? ህከረ ሽርክት ቆካአ ዩሃኤንዶ? ");
INSERT INTO alw_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","ህትጎተበአ፤ ሀንቅ መገኑ ደግቡ መኑ ክትም ሆንጠህሳኢሁ ሩሃንይሃት ቤሉ መገኒሃበአ፤ ህካን እኮቤቺሃ አዕኑ ሩሃንዪን ሜጡ እኮኖተ ሀሳምበአ። ");
INSERT INTO alw_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","ህትን አዕኑ ቀርች ጠበቴች አጌነን ሩሃንይ ጠበቴች አጎኖተ አታልቴነንተበአ፤ ህትን ቀርች ማዲችለከ ሩሃንይ ማዲች ቤቀንቶኖተ አታልቴነንተበአ። ");
INSERT INTO alw_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","ቴሱ ነኡ መገኑ ኡሙርሲንሱንዶ? ነኡ እሲች አበ ጠረኝናምንዶ? ");
INSERT INTO alw_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","ጉዕሙርቹንኩ ፈቀደሞኡ፤ እኮጎሬ ጉዕሙርቹንኩ ደግለለኖበአ፤ ህትን ጉዕመ ጠወ አኢሃ አታሌኖ፤ እኮጎሬ ጉዕሙርቹንኩ ጠረኝሰኖበአ። ");
INSERT INTO alw_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","አዪሁ ገይስ መኩተ ጠለዕል እሁዕነ ዎሎ መን መኩተ ሀሱን። ");
INSERT INTO alw_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","ቀልቢችክዕኔ ኬኣ ሸክተ ከንቴን እኮስ ጌባን ህሬኖ ማላ ለሞሶኑዕናን እቼ። ");
INSERT INTO alw_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","መሰንትስ ዱንያ አሌንለከ ኣዜሴዮርቹ ጉዕሙንኩ ቀርችሃን። ");
INSERT INTO alw_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","መገኑ አመዕንዮበእ መኒች መቱ እቴኖሃ ቅጥ አዕይ ገኤጎሬ አዕኑ መርቶኖተ ሀሴንተ ጎሬ ኣሴመህኔሃ ጉዕመንከ ቀልቤንከክዕኔ ለሞሶኑዕናን እቼ። ");
INSERT INTO alw_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","ጠዉ እኮጎሬ አዪሁ «ኩ ማሉ ሽርኬተ ክትመሞኢሃን» ዬህዕኔጎሬ ህከ ኩሎህዕኔ መንች መሳንለከ ቀልብ ዎቀሸ ሰውትተኔሃ እቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","ህካን ዬሚሁ መንች ቀልብ ሰውትተኔሃት ቤሉ ኪ ቀልብ ሰውትተኔሃትበአ፤ መሰንትስ ዎሎ መን ቀልብ ሰውትተኔሃ ኢ ሰዎልድማን ፈረዴኖሁ ሚሃት? ");
INSERT INTO alw_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","ህትን አን መገኑ ገለትጨን እቾምጎሬ ህከ መገኒሃ ገለት ኣሳም ጠዋን ዎቀሸተ አኤኖኤሁ ሚሃት? ");
INSERT INTO alw_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","ቴሱ እቴንተጎሬ አጌንተጎሬ መሃ አቴንተጎሬ ጉዕመንከ መገን ኬዕምኚሃ አዕዬ። ");
INSERT INTO alw_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","አይሁደ እኮ፥ አይሁደ እኮበእ እኮ፥ አመናኖ ጭምት ምኒ እኮ፥ አዬሁ ቆዕለኖገ አቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","አን ጉዕሙንኩሰ ጡምቶተ ዎሎ መን ጥቅም ቤሉ ገይኤ ጥቅም ሀሱዕነ መነ ጉዕመንከ አኣም ጠዋን ጉዕማንን ሙንዲሲሳምገን አዕኑሁ ህትን አዕዬ። ");
INSERT INTO alw_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","አን መሲህ አጉዳምገን አዕኑሁ ኤሳሃ አጉጄ። ");
INSERT INTO alw_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","ጉዕመ ወክት ቃጌነንተኤቤቺሃለከ ክዕኔሃ ኣሴም ትምርተ ጠረኝቴን አፌነንተቤቺሃ ገለትጫንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","ጠዉ እኮጎሬ ጎንች ቡዕሉ መሲህ እሁሲ፥ መንቾ ቡዕሉ ምንሴ አነ እሁስለከ መሲህ ቡዕሉ መገኑ እሁስ አጥራመቴን ደጎኖተ ኢታም። ");
INSERT INTO alw_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","ህትን ጉንጉዕል ዱአ አአኖሁ ህከረንገ ራገ ጠወአኖሁ ጎንቹ አዪሁ ገይስ ቡዕለ እኮ መሲህ ሙልሰኖ። ");
INSERT INTO alw_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","ህትን ሻሸ ጣጡዕናን ዱአ አታኢሁ ህከረንገ ራገ ጠወአ መንቹት ሀቲንሴ ገይሴ ቡዕለ እኮ ምንሴ መንቹ ሙልሳአ፤ ሁኩንን ሙምሴ ሜዶገ ዎለአመኖ። ");
INSERT INTO alw_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","መንቹት ሻሸ ጣጥባች ሙምሴ ሙርሲሱን፤ ጠዉ እኮጎሬ ሙምሴ ሙርሲሱ ህከረንገ ሜዱ ሙልሰኖሴሃ እኮጎሬ ሻሸ ጣጡን። ");
INSERT INTO alw_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","ህትን ጎኑ መገን ደነለከ መገን ኬዕምኝ እኮቤቺሃ ጉንጉዕሉ ሀስሰኖስበአ፤ ጠዉ እኮጎሬ ሜንቱ ጎኒሃ ኬዕምኝሃን። ");
INSERT INTO alw_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","መሰንትስ ሜንቱ ጎኒች ደገንቶ ቤሉ ጎኑ ሜንቲች ደገሞበአ። ");
INSERT INTO alw_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","ህትን ሜንቱ ጎኒሃ ከለቀንቶ ቤሉ ጎኑ ሜንቲሃ ከለቀሞበአ። ");
INSERT INTO alw_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","ህከን መሳንለከ መገን መላይከት ለኣሴቤቺሃ መንቹት ምንሴ አን ሹምነት ኣዜን እሁሴ ለሊሶተ ቡዕለሴ ጣጡን። ");
INSERT INTO alw_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","ጠዉ እኮጎሬ ቀርችቤቾን ሜንቱ ጎኑ ዮበኢሃለከ ጎኑ ሜንቱ ዮበኢሃ ሄኦተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","መሰንትስ ሜንቱ ጎኒች ከለቀንቶገን ጎኑ እለመኖሁ ሜንቲችት፤ ህትን ጉዕሙርቹንኩ ደገመኖሁ መገኒችት። ");
INSERT INTO alw_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","ህንዴ ገዉክዕኔ ፈረጄ፤ መት መንቹት ሻሸ ጣጡዕነ ዱአ አኡ ጡመሃንዶ? ");
INSERT INTO alw_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","ጎኑ ሙምስ ቅራርስ ነሴጎሬ ሁኩን እሲሃ ሙልሰኖሃ እሁስ ክልቀቲች ተማርቴነንተበእንዶ? ");
INSERT INTO alw_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","ጠዉ እኮጎሬ ሙሙ ኣሰሞሴሁ ቡዕለሴ ጣጦተ እኮቤቺሃ ሙምሴ ነስቶጎር እሴሃ ኬዕምኝያን። ");
INSERT INTO alw_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","ህካን እኮቤቺሃ አዪሁ ኦደሞተ ሀሾ ጎሬ ኔሳሃ እኮ መገኑ አመዕኔ መኒሃ ከኒች አደ እኮ ጠዉ ዮኔበአ። ");
INSERT INTO alw_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","አዕኑ ጭምይቴነንተ ወክት ምዕረኖህዕኔ ቤሉ ደግለለኖህዕኔርቹ አቴነንተበእቤቺሃ ከኒች ዎሮን ዮ ትዛዝ ኣሳንክዕኔ ወክት አን ክዕኔተ ገለትጭህበአ። ");
INSERT INTO alw_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","መሰንትስ ጉዕመርቺችን ሄጭ መገኑ አመዕኔ መንቤቾን ጭምይቴነንተ ወክት በላንከክዕኔ አደዶመት ሄኡስ ሞጮጭዮም፤ ህከን ጠዊች ደሩስ ሀንቅ እሁስ አመዕናም። ");
INSERT INTO alw_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","ህካን እኮቤቺሃ ሀንቅ መኑ አዬኤታጎሬ መለዕለንት ለልቶተ በላንከክዕኔ አደዶመት ሄኡስ ግደሃን። ");
INSERT INTO alw_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","አዕኑ ሜጡበ ጭምይቴነንተ ወክት እቴነንታሁ ጠሊለ ቀርች ሁርባትሃበአ። ");
INSERT INTO alw_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","መሰንትስ እቴነንተ ወክት መቱ-መቱስ አገሩዕነ ሄጫቀንሺን ገይስ ሁርባት እተኖቤቺሃ መቱስ ጎራዬገን ፈቀኖ፤ ህትን ዎሉስ ሰከረኖ። ");
INSERT INTO alw_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","እቶኖተለከ አጎኖተ ምኑ ዮህዕኔበእንዶ? ህከረንገ መገኑ አመዕኔ ጭምት ዱእ ምኒ ህንቄነንንዶ? ህትን መቱርቹሁ ዮስበእ መነ ሙልሴነንንዶ? ቴሱ አን ክዕኔተ መ ዩ! ከን ጠውተኔሃ ገለትጮህዕኔንዶ? ሆሮ ገለትጫንክዕኔበአ። ");
INSERT INTO alw_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","ቀርቺች ቶጎሚሁለከ ክዕኔንከ ኣሴም ትምርቱ ከኒች ዎሮን ዮእሃን፤ ህግሴን ኣሴመ ሀንከዕርተ ቀርቹ ኢስ ዳቡተ ኬሽ ");
INSERT INTO alw_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","መገኑ ገለትጭ ቢጭ «ህዕዬ እቼ ኩን ክዕኔተኔሃ ኣሰሞ ጅስማኤ፤ ካን ኤሳሃ ቃጎኖተ አዕዬ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","ህትን ሁርባቲች ኤተሮን ጠበቴሃ ኬሽ «ኩ ጠበቴሁ ቄጊንከኤ እሀኖ ሃዕሮሃ ወኣድ፤ ህካን አጌነንተ ወክት ጉዕመንከ ካን ኤሳሃ ቃጎኖተ አዕዬ» ዬሰ። ");
INSERT INTO alw_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","መሰንትስ ከ ዳቡተ እቴነንተ ወክትሃ ከ ጠበቴሃ አጌነንተ ወክት ጉዕመንከ ቀርቹ ኢስ ፈንቀል አሜቶተ ኢለ ሬሁስ ዱዱብስቴነንተ። ");
INSERT INTO alw_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","አዪሁ ኣጉዕናንስ ቀርች ሁርባቲሃ ኬዕምኝ ኣሱዕነ እቾጎሬለከ ቀርች ጠበቴሃ አጎጎሬ ቀርች ጅስሚሃለከ ቄጊሃ ኤዳሙ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","ህካን እኮቤቺሃ መቱ መንቹ ህከን ዳቦች እቶተ ብርተለከ ህከን ጠበቴሃ አጎተ ብርተ ገዉስ መረመሩን። ");
INSERT INTO alw_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","ሀኩ መንቹሁ ቀርች ጅስመ መሃጎሬ አደ አዕይ ደጉዕነ እተኖሁለከ ቀርች ጠበቴሃ አገኖሁ ጉዕሙንኩ ፍርደ ገይስ አሌን ኤበኖ። ");
INSERT INTO alw_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","ክዕኔ በሊች ልግቡ ሆጎኢሁለከ ጥዞኢሁ ህከኒሃት፤ ህትን ልግቡሰ ሬቶኢሁ ህከን መሳኒት። ");
INSERT INTO alw_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","ገይኔተኔሃ አጥራመንት ደንጎም እቃን አሌንከኔ ፈረደመኖበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","ጠዉ እኮጎሬ ከን ኣዱንያ አል መኒን ሜጡበ ኒ አሌን ፈረደመኖኔበእገ ቀርቹ ኒ አሌን ፈረደኖኔሁ ኔሳሃ ተማርሶኔታት። ");
INSERT INTO alw_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","ህካን እኮቤቺሃ አመኤ ኦሶ! ቀርች ጠሊለ ሁርባት እቶኖተ ጭምይቴንተ ወክት ገገዉክዕኔ አገዕራቀሜ። ");
INSERT INTO alw_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","ጭምይቴነንታሁ ፍርዲሃ እሀኖበእገ ጎራዬኢሁ ዮ ጎሬ ምኔንከስ እቱን፤ ፈቆ ጠውተኔሃ አኡ ሀስሰኖህዕኔሃ አሜቾም ወክት ኩላንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","አመኤ ኦሶ! ጠሊለ አያን ኣስቶተኔሃ ደጎኖተ ሀሳም። ");
INSERT INTO alw_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","ሀንቅ መገኑ ደጎኑዕናን ሄኤንተ ወክት ደጌንቡ ጠወ አዎንቴን ጠወኢሃ አታልትበ ሽርኬቤቹ መርቴነንተገ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","ህካን እኮቤቺሃ ቴሱ አዪሁ መገን አያን ዎልቃን ጠወአን «ኢስ ቦሮረሞእሃን» የኖሁ ሆሮን ዮበእገለከ ጠሊለ አያን ዎልቃን እህባች «ኢስ ቀርቹሃን!» ዮተ ሜጡሁ አታልበገ አጥራመቴን ደጎኖተ ሀሳም። ");
INSERT INTO alw_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","አደዱ ጠሊለ አያን ኣስቱት ዮኡ፤ እኮጎሬ ጠሊሉ አያኑ ሜጥቹሃን። ");
INSERT INTO alw_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","ህትን አደዱ ክድመት ዮኡ፤ እኮጎሬ ቀርቹ ሜጥቹሃን። ");
INSERT INTO alw_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","ህትን ሆጉተ አኤኖ አደዱ ዎቆሁ ዮኡ፤ ጠዉ እኮጎሬ ህካን ጉዕመንከ ጉዕመ መን አዲን አአኖሁ መቱሃ መገኑ። ");
INSERT INTO alw_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","መት-መቲሃስ ጠሊሉ አያኑ መቱርቹ ለሊሰኖሁ ጉዕመንከ ደግለለኖ ጠዊሃት። ");
INSERT INTO alw_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","ጠሊሉ አያኑ መቶ መንቺሃ ሀይማን ጠወአኖ ላገተ ኣሰኖስ፤ ሁኩ ጠሊሉ አያኑንኩ ዎሊሀስ ኤንኬዕኒን ጠወኡ ኣሰኖስ። ");
INSERT INTO alw_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","ህትን ሁኩ ጠሊሉ አያኑ መቲሀስ አመዕነቱ ዎሊሀስንገ ጥዘናሙ ፈይሱ አታለኖ ኣስቱተ ኣሰኖ፤ ");
INSERT INTO alw_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","ህትን መቲሀስ አጀብሲሰኖ ጠወ አኡ ዎሊሀስንገ ራግ ላገተ ጠወኡ ህትን መቲሃ ሀንቅለከ ክዝብ አያነ አደ አኤን ደጌኖ ኤንኬዕኑ ዎሊሀስንገ ሮሰሞበእ አፌን ጠወኡ ህትን መቲሀስንገ አደደ አፌን ጠወኤማሀ ፈሰሬኖ ኣስቱተ ኣሰኖስ። ");
INSERT INTO alw_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","ጠዉ እኮጎሬ ህከ ጉዕመ ጠወንከ ሁኩ ሜጡ ጠሊሉ አያኑ ሃሸዕዮገ አነኒንከስ ቤክ ኣሰኖ። ");
INSERT INTO alw_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","ሜጥቾ ጅስማን ልግቡ ብሊቱ ሄአኖሀንገን መሃ ልግብ እኮጎሬ ጉዕሙንኩ ብሊቱ መቱ ጅስመ እኮሀንገን መሲህ ህትኒንት። ");
INSERT INTO alw_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","መሰንትስ አይሁደ እንኮምጎሬሁ ግሪክ አፎን ጠወዕናም መነ እንኮምጎሬሁ ሮስ እንኮምጎሬሁ ሰዎልድ እንኮምጎሬሁ ነኡ ጉዕሙንኩኔ ሜጡ ጅስማ እንኮተ መቶ ጠሊለ አያኒን ጠመቀሞም፤ ህትን ጉዕሙንኩኔ ህከን መቶ ጠሊለ አያኒች አንጎም። ");
INSERT INTO alw_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","ጅስሙ መኬኢሁ ልግቤ ብሊቲቺት ቤሉ መቶሃ ብሊቲቺበአ። ");
INSERT INTO alw_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","ህካን እኮቤቺሃ ሎከት «አን አንገተ እህበቤቺሃ ጅስሚሃ ብሊትሃበአ» ይቶጎሬ ህካን ይንከሴ ጅስሚች መቱ ብሊት እሁ ፈቃእንዶ? ");
INSERT INTO alw_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","መጨት «አን እልተ እህበቤቺሃ ጅስሚሃ ብሊትሃበአ» ይቶጎሬ ህካን ዪንከሴ ጅስሚች መቱ ብሊት እሁ ፈቃእንዶ? ");
INSERT INTO alw_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","ህካን እኮቤቺሃ ጅስሙ ጉዕሙንኩ ጠለዕል እልተ እኮ እቃን ሞጮጩ ሀከኔ ሄአኖ እቅ? ህትን ጅስሙ ጉዕሙንኩ መጨተ እኮ እቃን ሀንሱሱ ሀከኔ ሄአኖ እቅ? ");
INSERT INTO alw_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","ጠዉ እኮጎሬ መገኑ ኢቴ ሃሊን ብሊት ጉዕመንከ ጅስማን ሀሲሰኖ ቤቾን ሄአኖገ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","ህትን ጉዕሙንኩስ ጠለዕል መቱ ብሊት እኮ እቃን ጅስሙ ሀከኔ ሄአኖ እቅ? ");
INSERT INTO alw_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","ቴሱ ልግቡ ብሊቱ ሄዕዮ ጎሬሁ ጅስሙ ሜጦሃን። ");
INSERT INTO alw_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","ህካን እኮቤቺሃ እልት አንገተ «ሀሳንኬበአ» ይቶተ አታልታበአ፤ ቡዕሉንኩ ሎከተ «ሀሳንኬበአ» ዮተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","ጠዉ እኮጎሬ ጅስማን ላፈ አጉደኖ ብሊቱ አበ ሀስሰኖሃን። ");
INSERT INTO alw_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","ህትን አሌንከኔ ኬዕምኙሰ ቀቅቹ አጉደኖኔ ብሊቲሃ ሎረ ኬዕምኝ ኣስናንሰ፤ ህትን ለኤንበገ ሙልናም ብሊቲሃ ሎረ ኬዕምኚን አገርናንሰ፤ ");
INSERT INTO alw_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","ብሬን እክ ለለኖ ጅስሚሃ ጉዕሚንከ ኩን ጉዕሙንኩ ሀሲሰኖሰበአ፤ እኮጎሬ መገኑ ለኢሃ ሙልሰኖ አጉጅ ለለኖ ጅስም ብሊተ ሎረ ኬዕምኚን አፌኖሰገ አዕይ ጅስመ ጉዕመንከ ሜጡ አዕይ አጳቀንሴሰ። ");
INSERT INTO alw_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","ካን አዕዮሁ ጅስመ ጉዕመንከ በላንከሰ አደዶመት ሄኣበእገ ገገዉንኩሰ መቱ መቲንከስ አጳቀንታጋት። ");
INSERT INTO alw_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","ህካን እኮቤቺሃ ብሊቲች መቱስ ኦርጨመኖ ወክት ጉዕሙንኩ ብሊቱ ሜጡበ ኦርጨቀመኖ፤ ህትን መቱ ብሊቱ ኬዕምኛሙ እሀኖ ወክት ጉዕሙንኩ ብሊቱ ሜጡበ ሙንደአኖ። ");
INSERT INTO alw_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","ቴሱ አዕኑ መሲህሃ ጅስመ፤ መት-መቱክዕኔ ህከን ጅስምሃ ብሊተ። ");
INSERT INTO alw_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","ህካን እኮቤቺሃ መገኑ መት-መቱ መነ መገኑ አመዕኔ መን ጭምት ዱእ ምናን አደደ ሆጎን ሄኣገ አዕዮ፤ ከን ሃሌን ዎዕናሃ አሳበተ ለንኪሃ ነብያኑተ ሰቂሃ አስተማረተ ህከኒች ኤተሮን አጀብሲሰኖ ጠወ አታ መነ ህከኒች ኤተሮን ጥዘናመተ ፈይሳ መነ ህከኒች ኤተሮን መኒሃ ደግለልታ መነ ህከኒች ኤተሮን ገሻኑተ ህከኒች ኤተሮን ሮሰሞበእ አፌን ጠወኣ መነ አመዕናኖ ኣዜን ኡርሾኡ። ");
INSERT INTO alw_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","እሰ ጉዕሙንኩሰ አሳበተንዶ? ህትን ጉዕሙንኩሰ ነብያኖተንዶ? ህትን ጉዕሙንኩሰ አስተማረተንዶ? ህትን ጉዕሙንኩሰ አጀብሲሰኖ ጠወ አታእረንዶ? ");
INSERT INTO alw_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","ህትን ጉዕሚንከሰ ጥዘናመተ ፈይሳ ኣስቱት ዮሰረንዶ? ህትን ጉዕሙንኩሰ ሮሰሞበእ አፌን ጠወኣእረንዶ? አደደ አፌን ጠወኤማሃ ጉዕሙንኩሰ ፈሰርቶተ አታልታእረንዶ? ");
INSERT INTO alw_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","ጠው እኮጎሬ አዕኑ ጉዕሚችን በተኣ ኣስቱተ ደእቶኖተ ጠረኝቴን አጰሜ። ህትን አን ጉዕሚችን ቆሀኖ ዎቃሃ ለሊሳንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","መንለከ መላይከ አፌን ጠወዕዮም እቃ ኢተት ሄእበኤች ወደኖ ብረትገለከ ዶልገ እኮም። ");
INSERT INTO alw_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","ህካን እኮቤቺሃ ራገ ጠወኣም ዎልቀት ሄኦኤ እቃ፥ ምስጥር ጉዕመንከ ደጎም እቃን፥ ኤንኬዕኑ ጉዕመንኩ ሄዕዮኤ እቃ፥ ቆተት ቤቺችሴ ኬእ ዎሉቤቹ መርታገ አኣም አመዕነቱ ሄዕዮኤ እቃ ኢተት ሄእበኤች አን ተሰሃን። ");
INSERT INTO alw_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","ህትን ዮኤሃ ጉዕመንከ ቡጥቻኖተ ቤኮም እቃ፥ ጅስመኤ ጊራን ቡቦተ ህግሽ ኣስዮም እቃ ኢተት ሄእበኤች መቱርቹሃ ደግለለኖኤበአ። ");
INSERT INTO alw_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","ኢተት አታዕልሲሳእተ፤ ኢተት ጡመ ጠወ አታአ፤ ኢተት ምቀኝታበአ፤ ኢተት ዮሴሀኔን ድከኣበአ፤ ኢተት ቦንሲሳበአ። ");
INSERT INTO alw_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","ኢተት አለ ቅልበ እካበአ፤ ኢተት ጠለዕል ገይሀሴ ይታበአ፤ ኢተት ኡሙዕሪታበአ፤ ኢተት ዮስ መንቹ በደለሞ እቃን ብድልገ ዎለኣበአ። ");
INSERT INTO alw_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","ኢተት ሀንቅ ጠዋን ሙንደኣ ቤሉ ሂለ ጠዋን ሙንደኣበአ። ");
INSERT INTO alw_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","ኢተት ጉዕመ ጠወ አታዕልታአ፤ ኢተት ጉዕመርቹንከ አመዕንታአ፤ ኢተት ጉዕመርቹንከ ተብሴን አገዕርታአ፤ ኢተት ጉዕመ ጠዋን ጠረኝት ሄኣአ። ");
INSERT INTO alw_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","ኢተት ሆሮ በኣበአ፤ ራጉ እኮ እቃ ህገኖ፤ ሮሰሞበእ አፎን ጠወኡ እኮ እቃ ፈቀኖ፤ ኤንኬዕኑ እኮ እቃ ህገኖ። ");
INSERT INTO alw_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","መሰንትስ ነኡ ደንጋሚሁ ዊመ ዊሚንትበአ፤ ራገ ጠወዕናሚንኩ ዊመ ዊሚንትበአ። ");
INSERT INTO alw_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","ጠዉ እኮጎሬ ዊመ እኮ ጠዉ አሜቾ ወክት ደሩ እኮ ጠዉ ህገኖ። ");
INSERT INTO alw_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","ጩል እክ ሄዕዮም ወክት ጩለገን ጠወኣም፥ ሰውያምለከ አጥራመታም እቅ፤ ቴሱ ኦስመኤ ሹሎም ወክት ጩል እክ ሄዕዮም ወክት አኣም ጠወ ጉዕመንከ አጉሮም። ");
INSERT INTO alw_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","መሰንትስ ቴሱ ለአቃንቺን ለኤኖሀንገ ቀቅቹንከ ለዕናም፤ ጠዉ እኮጎሬ ህከ ወክት ዊመ ዊሚን ለዕናም፤ ቴሱ አን ደጋሚሁ ደሩሲት፤ ጠዉ እኮጎሬ ህከ ወክት መገኑ ኤሳሃ ደጎኤ ጌሰንከ ዊሙ ኤንኬዕኑ ሄአኖኤ። ");
INSERT INTO alw_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","ህካን እኮቤቺሃ አመዕነቱ፥ ኢተትለከ ተብሶሁ ኩ ሰሱንኩ ጠረኝት ሄኣአ፤ ጠዉ እኮጎሬ ኢተት ህከኑኡች በተኣአ። ");
INSERT INTO alw_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","ቴሱ ኢተተ አወኜ፤ ህትን ጠሊለ አያነ ኣስቱተ ጡመገ ሀሼ፤ በትሴን ራገ ጠወኢሃ አታሌኖ ኣስቱተ ሀሼ። ");
INSERT INTO alw_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","መሰንትስ ሮሰሞበእ አፌን ጠወአኖ መንቹ መገኒሃት ቤሉ መኒሃ ጠወአኖበአ፤ እስን ጠሊለ አያኒን ማጠሞ ጠወ ጠወአኖቤቺሃ ጠወአኖስርቹ ደገኖሁ አዪሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","ጠዉ እኮጎሬ ራገ ጠወአኖ መንቹ ዎሉ መነ ጠረኝሲሃ፥ ሸዚሃለከ ሰብር አአኖገ መኒሃ ጠወአኖ። ");
INSERT INTO alw_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","ህካን እኮቤቺሃ ሮሰሞበእ አፌን ጠወአኖ መንቹ ገዉስ ጠረኝሰኖ፤ ጠዉ እኮጎሬ ራገኖ መንቹ ዱእ ምነተ ጠረኝሰኖ። ");
INSERT INTO alw_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","ህትን ጉዕሙንኩክዕኔ ሮሰሞበእ አፎን ጠወኤንታ እቃን ኢታም እቅ፤ እኮጎሬ በትሽ ሀሳሚሁ ራጎኖታት፤ መሰንትስ ዱእ ምነት ደግለሸቀንቶተ ጠወዕዮሃ ሂር ኩለኖሁ ዮበእ ጎሬ ሮሰሞበእ አፎን ጠወአኖሀኒች ራገኖሁ በተአኖ። ");
INSERT INTO alw_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","ቴሱ አመኤ ኦሶ! ክዕኔቤቹ አሜቾም ወክት ሮሰሞበእ አፌን ጠወአን አሜቾም ጎር ክዕኔሃ መ ደገለለኖ? ህከን ወጥ ደግለለኖህዕኔ መገን ምስጥር ለሊሱ፥ ኤንኬዕኑ፥ ራገ ጠወኡለከ ትምርት አፍ አሜቾሚሁ ቆሀኖ። ");
INSERT INTO alw_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","ዎሉ ፈቅ ሁሉሌገ ክራርጋ ሩሁ ዮሰበእ ኦዳታ እኮ እቃ ላገሰ አደ እክ ለልትባች ሁሉሌ ላገተ እሁስለከ ክራር ላገተ እሁስ ማን ደጌኖ? ");
INSERT INTO alw_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","ህትን ሞጮጨንቶበእ ላጋን ደገሞበእ ሃሊን ጡሩምበ ቡሴመጎሬ መርቺሃ ቡሴመገ መኑ ሀት አዕይ ደጎተ አታለኖ። ");
INSERT INTO alw_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","ህከንገን ሮሰሞበእ አፎን መኒሃ ኣግበገ ጠወኤንተጎሬ ቦብሪሃ ጠወኤነንተሀንገ እኬነንተ ቤሉ ጠወኤነንተርቹ አይ አጥራመች ደጎተ አታለኖ? ");
INSERT INTO alw_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","ከን ኣዱንያ አሌን አደዱ ልግቡ አፎሁ ዮኡ፤ ጠዉ እኮጎሬ ፍሳረት ዮበእ አፎሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","ቴሱ መቱ መንቹ ጠወአኖ አፌ ፍሳረተ ደግባች አን ጠወአኖሀኒሃ ኮህቹ እሃም፤ እስን ኤሳሃ ኮህቹ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","ህካን እኮቤቺሃ ጠሊለ አያን ኣስቱተ ሀሴነንተረ እኬንተጎሬ መገኑ አመዕኔ መነ ጠረኝሲሃ አታልቴነንተ ኣስቱተ በትሴን ሀሼ። ");
INSERT INTO alw_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","ህካን እኮቤቺሃ ሮሰሞበእ አፎን ጠወአኖ መንቹ ጠወአኖስርቹ ፈሰሮተ አታለኖ ዎልቀተ ደኦተ ዱአ አኡን። ");
INSERT INTO alw_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","መሰንትስ ሮሰሞበእ አፎን ዱአ አዕዮ ጎሬ አያኒን ዱአ አአኖ፤ ጠዉ እኮጎሬ ቡዕሉኤ መቱርቹሃ ሆጉተ አዕዮበአ። ");
INSERT INTO alw_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","ቴሱ አኡ ሀስሰኖኤርቹ መርቹሃን? አያኒንከኤ ዱአ አአን ሰውቲንከኤ ዱአ አኣም፤ ህትን ቀልቢንከኤ ዘመረን ሰውቲንከኤ ዘመራም። ");
INSERT INTO alw_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","ህካን እህባች አት አያኒንከክ ሮሰሞበእ አፎን መገኑ ገለትጭቶንትጎሬ መቱ ኮህቹ መንቹ ይቶንትርቹ ደግበቤቺሃ አት መገኑ ገለትጭቶንትሀኒሃ ሀት እክ «ኣሚዕን» የኖ? ");
INSERT INTO alw_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","መሰንትስ አት መገኑ ገለትጭቶንትጉ ጡመሃ እቅ፤ እኮጎሬ ሁኩን ዎሉ መንቹ ጠረኝሰኖበአ። ");
INSERT INTO alw_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","ጉዕሚችክዕኔን ሎረ ሮሰሞበእ አፎን ጠወኣምቤቺሃ መገኑ ገለትጫም። ");
INSERT INTO alw_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","ጠዉ እኮጎሬ ሮሰሞበእ አፎን ቶኑ ኩሜ ላገተ ጠወኢች ዎሉ መነ ተማርሲሃ ሮሰሞ አፎን መገኑ አመዕኔ ጭምት ዱእ ምናን ኦንት ላገተ ደጌኖ ላጋን ጠወኡ ኢታም። ");
INSERT INTO alw_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","አመኤ ኦሶ! ሂለ ጠዊሃ ጩለተ እኬ ቤሉ ሰውቲንከክዕኔ ጩለተ እኮኖቼ፤ ጠዉ እኮጎሬ ሰውቲንከክዕኔ አንጀ አጉዕምቴንታእረ እኬ። ");
INSERT INTO alw_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","ሕጋን፦ « ‹ሮሰሞበእ አፎን ጠወኣ መኒሃለከ ዎሎ ባድ መን አፎን ከን መኒሃ ጠወኣንሰ፤ ጠወዕዮምጎሬሁ ሞጮጭታኤበአ› ይዮኡ ቀርቹ መገኑ» የመም ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","ቴሱ ሮሰሞበእ አፎን ጠወኡ መላተ እሀኖሁ አመዕንበ መኒሃት ቤሉ አመዕኔ መኒሃበአ፤ ጠዉ እኮጎሬ ራገ ጠወኡ አመዕናኖታት ቤሉ አመዕንቡ መኒሃትበአ። ");
INSERT INTO alw_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","አመዕናኑት ጉዕሙንኩ ጭምይታ ወክት ጉዕሙንኩ ሮሰሞበእ አፎን ጠወአን ደግቡ ህከረንገ አመዕንቡ መኑ ኣጎጎሬ «ኩ መኑ በርገጎኡ» የኖበእንዶ? ");
INSERT INTO alw_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","ጠዉ እኮጎሬ ጉዕሙንኩሰ ራገ ጠወአን ደግቡ ህከረንገ አመዕንቡ መንቹ ኣጎጎሬ ሞጮጬ ላገት ሆርንት ዎቀሳስ፤ ህትን ሞጮጬ ላጋት ሆርንትስ ፈረዳስ። ");
INSERT INTO alw_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","ቀልቤንከስ ቴለሞ ጠዉ ለለኖ፤ ህካን እኮቤቺሃ ሁኩ መንቹ ኡላን ኡብ «ሀንቅንከ መገኑ ክዕኔ በላን ዮኡ» የን መገኒሃ ሰገደኖ። ");
INSERT INTO alw_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","አመኤ ኦሶ! ቴሱ መ ይናም? አዕኑ ጭምይቴነንተ ወክት መት-መቲሃስ መዝሙሩ ዮሲሁ ዮኡ፤ ዎሉስ ተማርሰኖ፤ መቱስ ማጠሞርቹ ለሊሽ ኩለኖ፤ መቱስ ሮሰሞበእ አፎን ጠወአኖ፤ መቱስ ሮሰሞበእ አፎን ጠወኤማሃ ፈሰረኖሁ ዮኡ፤ እኮጎሬ ሁኩ ጉዕሙንኩ አመዕናኑተ ጠረኝሲሃ እሁን። ");
INSERT INTO alw_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","ህትን ሮሰሞበእ አፎን ጠወአኖሁ ሄዕዮ ጎሬ ለሙ ህከረንገ በተዕዮ ጎሬ ሰሱ እክ ተሪን ተሪን ጠወኡን፤ እሰ ጠወኣእንከ ዎሉ መኑ ፈሰሩን። ");
INSERT INTO alw_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","ጠዉ እኮጎሬ ፈሰሩ አታለኖ መንቹ ሄእባች መገኑ አመዕኔ ጭምት ምናን ሮሰሞበእ አፎን ጠወኡንከ፤ ህከን ወጥ ገይሃስለከ መገኒሃ ጠወኡን። ");
INSERT INTO alw_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","ራገ ጠወኣእሩ ለሙ ህከረንገ ሰሱ እክ ጠወኡን፤ ዎሉ መኑ ጠወአሞስ ጠወ አጥራመት አደ አት ደጉን። ");
INSERT INTO alw_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","ጠዉ እኮጎሬ አፉዕሌ መኒች መቲሀስ ሃሽኣቱት ለልቶስጎሬ ዎዕናሃ ጠወአኖሁ ጨለዩን። ");
INSERT INTO alw_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","መኑ ጉዕሙንኩ ተማሮተለከ ጠረኞተ ጉዕሙንኩክዕኔ ተሪን ተሪን ራገ ጠወኦኖተ አታልቴነንተ። ");
INSERT INTO alw_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","ህትን ነብያካ አያኑ ነብያካተ አዘዘመኖ። ");
INSERT INTO alw_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","መሰንትስ መገኑ ወገሬትየ መገኑ ቤሉ ጨንጨነሃ መገኑበአ። ");
INSERT INTO alw_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","ሜንቱ መገኑ አመዕኔ መን ዱእ ምኒ ኣዜን ጠወኡንከ፤ መሰንትስ ሕጉ የኖገን እሰ አዘዘንቶታት ቤሉ ጠወኢሃ ፈቀደሞሰበአ። ");
INSERT INTO alw_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","ህካን እኮቤቺሃ መት መንቹት መገኑ አመዕኔ መን ዱእ ምናን ጠወኡ ሙልሰኖሃ እኮቤቺሃ ሜንቱ ደጎተ ሀሳ ጠዉ ሄዕዮ ጎሬ ምንሰ አነ ምኔሰ ጠዕምቱን። ");
INSERT INTO alw_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","ህትን መገን ላገት አሜቶኢሁ ክዕኔቺትንዶ? ህከረንገ መገን ላገት እልቶኢሁ ጠለዕል ክዕኔቤቹሃትንዶ? ");
INSERT INTO alw_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","አዪሁ «አን ነብዬቹሃን» የኖሁ ህከረንገ «ኤሳሃ ጠሊለ አያን ኣስቱት ዮኤሃን» የኖሁ ሄዕዮ ጎሬ ኩ ከተቦንክዕኔሁ ቀርች ትዛዝ እሁስ ደጉን። ");
INSERT INTO alw_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","ጠዉ እኮጎሬ ካን ሞጮጫምበአ የኖ መንቹ ዮ ጎሬ እስ ጠወአኖሁ ሞጮጨሙንከ። ");
INSERT INTO alw_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","ህካን እኮቤቺሃ አመኤ ኦሶ! ራገ ጠወኢሃ ጠረኝቴን ሀሼ፤ ህትን ሮሰሞበእ አፌን ጠወኡሃ ከንቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","ጠዉ እኮጎሬ ጉዕሙንኩ ጠዉ ጡመ ሃሊንለከ ሴሪን እሁን። ");
INSERT INTO alw_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","አመኤ ኦሶ! አዕኑ አን ተማርሲየንክዕኔ ኣእቴን ጠረኝቴን ኡርቴንተ ተሽት ላገተ ቃግሶህዕኔተ ሀሳም። ");
INSERT INTO alw_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","ህከ ተሽት ላገንተ ጠረኝሴን አፌንተጎሬ ህከን ላገ አዲን ፈቄነንተ፤ ህካን እህባች አመዕነቱክዕኔ ተሰሃን። ");
INSERT INTO alw_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","ጉዕመርቺችን በትሽ ሀስሰኖ ጠወ አንን ቶጎሚሃ ክዕኔኤ ህግሽ ኣሴም፤ ሁኩንን ጠሊለ መጻፋን የመሞገን መሲህ ጩብኔተኔሃ ሬዮኡ፥ ");
INSERT INTO alw_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","ሞገሞ፤ ጠሊለ መጻፋን ከተበሞገን ሰቅ በር ሬሆች ኬዕዮ የኖሃን። ");
INSERT INTO alw_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","እስን ጴጥሮሴሃ ለሌእ፤ ህከኒች ኤተሮን ቶና ለሞንከ አሳባተ ለሌእ፤ ");
INSERT INTO alw_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","ህትን ኦንቴ ጥቤች በተኣ አመዕናኖተ መቱ ወክት ለሌእ፤ እሳችን መቱ-መቱሰ ሬቶጎሬ ልግቡሰ ቴሁ ኢለ ፎሊን ዮኡ። ");
INSERT INTO alw_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","ህትን ኢስ ያቁቢሃ ለሌእ፤ ህከኒች ኤተሮን ጉዕማንከ አሳባተ ለሌእ። ");
INSERT INTO alw_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","መጨረሻን ጉዕሚችን ሆፈኣም ኤሳሃ ለሌእ። ");
INSERT INTO alw_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","መሰንትስ መገን ዱእ ምነተ ሸረን ኦሪሳሚሃ እኮምቤቺሃ አን አሳባች ጉዕሚችን ሆፈኣሚሁለከ ሶቀማንቹ የመም ገአሙ ገበእበኤሃን። ");
INSERT INTO alw_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","ጠዉ እኮጎሬ አን ቴሱ ሄኣም ሀለት ደኤሚሁ መገን ኣስቶቺት፤ ህትን ሁኩ ኣሰንቶኤ ኣስቱት ላልቹ ዮበኢሃ እኮበአ፤ አንን ዎሎ መኒች ጉዕሚችን በትሽ ጠረኝ አዕዮም፤ ጠዉ እኮጎሬ አዕዮሁ ኢን ሄአኖሃ መገንተ ኣስቱ ቤሉ አኔበአ። ");
INSERT INTO alw_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","አኒ እኮም እቃ እሳሁ ተማርስናሚሁ ከኒት፤ አዕኑሁ አመዕንቴንታሁ ከኒት። ");
INSERT INTO alw_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","ቴሱ መሲህ ሬሆች ኬኡስ ተማርስናሚሃ እኮች ሀት ክዕኔች መት-መቱ «ሬቶ መኑ ሬሆች ኬኣበአ» ይታኢት? ");
INSERT INTO alw_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","ሬቶ መኑ ሬሆች ኬእባሃ እኮች መሲህ ሬሆች ኬዕዮበአ ዩሃን። ");
INSERT INTO alw_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","ህትን መሲህ ሬሆች ኬእባች ኒ ትምርቱለከ ክዕኔ አመዕነቱሁ ተሰሃን። ");
INSERT INTO alw_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","ህከኒችን በትሽ «መገኑ መሲህ ሬሆች ኬሾስ» ይን እስተኔሃ መሰከርኖምቤቺሃ መገኒሃ ክዝብ ምስክር እንኮም ዩሃን፤ ሬቶ መኑ ሬሆች ኬእባች መገኑ መሲሁ ሬሆች ኬሾስበአ ዮሃን። ");
INSERT INTO alw_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","መሰንትስ ሬቶ መኑ ሬሆች ኬእባሃ እኮች መሲህ ሬሆች ኬዕዮበአ ዩሃን። ");
INSERT INTO alw_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","ህትን መሲህ ሬሆች ኬእባች አመዕነቱክዕኔ ተሰሃን፤ አዕኑሁ ከበሬ ኢለ ጩቢንከክዕኔ ዮንተ ዩሃን። ");
INSERT INTO alw_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","መሲሂን አመዕንት ሬቶእሩ በኦኡ ዩሃን። ");
INSERT INTO alw_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","ነኡሁ መሲህ ተብሳሃ አዕናሚሁ ከን ዱንያ አሌን ሄዕናም ሄኢሃ ጠለዕል እኮጎሬ መኒች ጉዕሚችን በትሴን ሻዝንሳምረ እንኮም ዩሃን። ");
INSERT INTO alw_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","ጠዉ እኮጎሬ መሲህ ሬቶሀኑኡተ ዎዕኔሃ እክ ሀንቅንከ ሬሆች ኬዕዮኡ። ");
INSERT INTO alw_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","መሰንትስ ሬሁት መቶሃ መንች አዲን አሜቶገን ሬቶእሩ ሬሆች ኬኡሁ መቶ መንች አዲኒት። ");
INSERT INTO alw_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","መኑ ጉዕሙንኩ ኣደም መሳን ሬሀኖሀንገን መሲህ መሳን መኑ ጉዕሙንኩ ሄኡ ደአኖ። ");
INSERT INTO alw_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","ጠዉ እኮጎሬ መት-መቱንኩ ገገይስ ተሪን አሜተኖ፤ መሲህ ሬሆች ኬኢን ዎኔሃን፤ ህትን ኤተሮን መሲህ አሜቾ ወክት እሲሃ እኮእረ ሬሆች ኬሰኖ። ");
INSERT INTO alw_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","መሲህ ገሹ ጉዕመንከ፥ ደኝነቱ ጉዕመንከለከ ዎልቀተ ጉዕመንከ ቤሾች ኤተሮን ዎምነቱ አነ መገኒሃ ህግሽ ኣሰኖ ወክት ዘማን ጎፉ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","መገኑ ዲነስ ሎከስ ጫዕማች ዎሮን አኦተ ኢለ መሲህ ዎመ እሁ ሀስሰኖስ። ");
INSERT INTO alw_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","መጨረሻን ቄለም በአኖሁ ዲኑ ሬሁታን። ");
INSERT INTO alw_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","«መገኑ ጉዕመ ጠወንከ ሹምነቲችስ ዎሮን አዕዮኡ» የኖሁ ከተበሞኡ፤ ጠዉ እኮጎሬ «ጉዕሙ ጠዉንኩ ሹምነትችስ ዎሮን እኮኡ» የኖ ወክት ጉዕሙ ጠዉንኩ ሹምነቲች ዎሮን አዕዮ አነ መገኑ በርገኖበአ። ");
INSERT INTO alw_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","ጉዕሙርቹንኩ መሲህ ሹምነቲ ኣዚን እኮች ኤተሮን አኑ መገኑ ጉዕሙርቹንኩ ጠገመኖሃ እሆተ ህከ ወክት ቤቱ ገዉንኩስ ጠቀኖገ አዕዮ መገኒሃ ጠገመኖስ። ");
INSERT INTO alw_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","ህካን እህባች ሬዮ መን ወጥ ጠመቀመኖ መኑ መ አአኖት? ህትን ሬዮ መኑ ሆሮን ሬሆች ኬእባሃ እኮጎሬ መኑ እሰ ወጥ ጠመቀመኖሁ ሚሃት? ");
INSERT INTO alw_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","ነኡ ገዉንኩኔ ጉዕመ ወክት አደጊሃ ገውኔ ኣስነን ሄዕናሚሁ ሚሃት? ");
INSERT INTO alw_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","አመኤ ኦሶ! ኤሳሃ በሬን በሬን ሬሁት ገንበ ይታኤት፤ አንን ህካን ያሚሁ ቀርቹሃኔ መሲህ ኢስ አዲን ክዕኔኤን ዮኤ አመዕነቲንት። ");
INSERT INTO alw_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","ህትን አን ኤፌሶን ከተማን አብል ቡሳዊን ኡጀቀሜኖሀንገን ኡጀቀሞሚሁ መን ሰውቲን እኮጎሬ መ ደግለለኖኤ? ህትን ሬዮ መኑ ሬሆች ኬእባሃ እኮች «ጋቴተ ሬናምቤቺሃ አሜ እንቶለከ አንጎ» ይታገ እሁሃስ። ");
INSERT INTO alw_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","አዕኑ ሉጨንቶኖቼ፤ «ሂሉ ጃሉ ጡመ አመል ቤሰኖ» የመሞኡ። ");
INSERT INTO alw_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","ቴሱ ቀልብ አዕዬ፤ ጩብ አኡ አጉሬ፤ መገኑ ደግቡ መኑ በላንከክዕኔ ዮኡ፤ አን ህካን ያሚሁ ሙልሶህዕኔተ ይዪት። ");
INSERT INTO alw_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","መቱ መንቹ «ሬቶ መኑ ኬኣኢሁ ሀት እኪት? ሬሆች ኬኣ ወክት ጅስሙሰ መ አጉደኖ?» ይ ጠዕመኖ መንቹ ሄኦተ አታለኖ። ");
INSERT INTO alw_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","አት ኩ ገዉ መንቹ! አት ዉጣንት ዉጠት ሸንትባች ሙታበአ። ");
INSERT INTO alw_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","አት ዉጣንት አለስ ህከረንገ ዎሎርች ዜሬተህቤሉ ኤተሮን ሙች ነጴኢሃበአ። ");
INSERT INTO alw_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","ጠዉ እኮጎሬ መገኑ ኢተኖ ሃሊን ገይስ ደነ ኣሰኖስ፤ ህትን መት-መቲሃስ ዘሬትስ ገይስ ደነንከ ኣሰኖስ። ");
INSERT INTO alw_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","መሰንትስ ማሉ ጉዕሙንኩ ሜጦሃ ደነበአ፤ እኮጎሬ መን ማሉ ሜጦሃ ደነ፤ ግዝ ማሉሁ ዎሉሃ ደነ፤ ህትን ጭኦ ማሉ አደደ ደነ፤ ቁርጩሜ ማሉ ዎሉሃ ደነ። ");
INSERT INTO alw_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","ህትን ሰሜ ጅስሙ ዮኡ፤ ኡለ አል ጅስሙሁ ዮኡ፤ እኮጎሬ ሰሜ ጅስም ኬዕምኙ መቶሃ ደነ፤ ህትን ኣዱንያ አል ጅስም ኬዕምኙ ዎሉሃ ደነ። ");
INSERT INTO alw_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","ህትን አር ኬዕምኙ መቶሃ ደነ፤ አገንች ኬዕምኙንገ ዎሎሃ ደነ፤ ቤዜ ኬዕምኙሁ ዎሎሃ ደነ፤ መሰንትስ መቶሃ ቤዜ ኬዕምኙ ዎሊችስ አደደ። ");
INSERT INTO alw_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","ሬዮ መኑ ሬሆች ኬአኖሁ ህትዪት፤ ዉጠሞ ጅስሙ በአኖሃን፤ ሬሆች ኬዕዮ ጅስሙ በእበሃን። ");
INSERT INTO alw_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","ሁኩንን ሆፍኚን ዉጠም ኬዕምኚን ኬአኖ፤ ህትን ላፈ እክ ዉጠም ጠረኘ እክ ኬአኖ። ");
INSERT INTO alw_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","ህትን ማል ጅስሚን ዉጠም ጠሊሉ አያኑ ሄኡ ኣሴ ጅስመ እክ ኬአኖ፤ ማል ጅስሙ ሄኦች ጠሊሉ አያኑ ሄኡ ኣሴ ጅስሙ ዮኡ። ");
INSERT INTO alw_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","ህካን እኮቤቺሃ «ዎኔ መንቹ ኣደም ሄአኖ ክልቀት እኮ» የመም ከተበሞኡ፤ ኤተር ኣደም ሄኡ ኣሰኖ አያነ እኮ። ");
INSERT INTO alw_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","ጠዉ እኮጎሬ ዎዕናሃ አሜቾሁ ጠሊለ አያኒን ሄኡ ኣሰሞሲሁ እሁዕነ ማል ጅስሙ አሜቾ፤ ጠሊለ አያኒን ሄኡ ኣሰሞስ ማል ጅስሚች ኤተሮን አሜቾ። ");
INSERT INTO alw_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","ዎዕኔ መንቹ ከለቀሞሁ ኡለ ትቢች እኮቤቺሃ ኡላሃን፤ ለንክ መንቹ አሜቾሁ ሰሜቺት። ");
INSERT INTO alw_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","ኡላች እኮእሩ ኡላች እኮሃ አጉዳአ፤ ሰሜች እኮእሩ ሰሜች እኮኢሃ አጉዳአ። ");
INSERT INTO alw_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","ነኡ ኡላ ትቢች ከለቀሞ መንች ደነ አጉንዶምገን መቱ በር ሰሜች አሜቾ መንች ደነ አጉንዳም። ");
INSERT INTO alw_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","አመኤ ኦሶ! መቱርቹ ኩላንክዕኔ፤ ማሉለከ ቄጉ መገን ዎምነቱ ዎረሶተ አታልታበአ፤ ህትን በአኖ ጅስሙ በእቡ ጅስመ ዎረሶተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","ቴሱ መቱ ማጠሞ ጠወ ኩላንክዕኔ፤ ነኡ ጉዕሙንኩኔ ሬናምበአ፤ ጠዉ እኮጎሬ ጉዕሙንኩኔ ዶረማም። ");
INSERT INTO alw_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","ዶረማሚንኩ መጨረሽ ጡሩምበ ቡሴኖ ወክት እሌ ገለብትገ መቶ ወክቴኒት፤ ጡሩምቡ ቡሰመኖ፤ ሬቶ መኑ በእበ መነ እክ ኬኣአ፤ ነኡሁ ዶረማም። ");
INSERT INTO alw_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","መሰንትስ ኩ ሸመኖ ማሉ ሸምባሃ ኦደኡ ህትን ኩ ሬሀኖ ማሉ ሬህባሃ ኦደኡ ሀስሰኖስ። ");
INSERT INTO alw_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","ኩ በአኖ በእባሃ ኦደዕዮ ወክት ህትን ኩ ሬሀኖ ሬህባሃ ኦደአኖ ወክት «ሬሁት ቄለንት በኦኡ» የመም ከተበሞሁ ዊመኖ። ");
INSERT INTO alw_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","ህትን «ሬሆ! ቄሉክ ሀከበ ዮኡ? ሬሆ! መነ ምዕርታንት ዎልቀክ ሀከበ ዮኡ?» የመሞኡ። ");
INSERT INTO alw_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","ሬሆ ቄል ዎልቀት ጩብሃን፤ ጩብ ዎልቀት ሕገሃን። ");
INSERT INTO alw_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","ጠዉ እኮጎሬ ቀርቹሃኔ መሲህ ኢስ አዲን ቄሉ ኣሰኖኔ መገኒሃ ገለቱ እሁንስ! ");
INSERT INTO alw_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","ህካን እኮቤቺሃ ኢተንቴንተ አመኤ ኦሶ! ጠረኝቴን ኡርዬ፤ ቀርቾ ኢሲሃ አቴንተ ሆጉት ጠለዕለ እክበገ ደጌነንተቤቺሃ ሌንቄቅቶኑዕናን ቀርቾ ኢስ ሆጉተ ጉዕመንከ ወክት አዕዬ። ");
INSERT INTO alw_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","አመዕናኑተ ሀዕላቀሜኖ ብረ ጭምአእተኔሃ ገለትይ ባዶን ሄኣ አመዕናኖተ ኩሎምገን አዕኑሁ ህት አዕዬ። ");
INSERT INTO alw_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","ሁኩ ብረ ጭምአኤኖሁ አን አሜታም ወክት እሀኖበእገ መት-መቱክዕኔ ደእቴነንተሀኒች ዎልቀክዕኔ ጌሰ ጉዕመንከ ወክት ሳምንት ዎኔ በር አደ አቴን አፉሽዬ። ");
INSERT INTO alw_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","አን አሜቾም ወክት አዕኑ አመዕንቴነንተ መኑ ህከ ጭም አቴንተ ብረ ዬሩሳሌመ መስቶተ ደብደቤተ ከተብ ሜጡበ አዕይ ሶሃንሰ። ");
INSERT INTO alw_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","ኢ መሩ ሀስሾ ጎሬ እሰ ኢን ሜጡበ መርታአ። ");
INSERT INTO alw_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","መቄዶን ባድ አዲን ህጎተ ሰውዬምቤቺሃ ህከኒን ህገን ክዕኔተ ለኦተ አሜታም። ");
INSERT INTO alw_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","አን ሀከቤቹሃ መሮም ጎር ዎቄሃእ እካ ሽንቅተ ኣቶኖኤተ ክዕኔቤቾን ቀዉ ጌሰ አፉዕላሚሃ እሀኖ፤ ህትን ከርም ክዕኔቤቾን አፉዕላሚሃ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","ህካን እኮቤቺሃ ህግኤ ዎቃን ለኦህዕኔተ ሀሳምበአ፤ መገኑ ዬጎር ክዕኔን ሜጡበ መቱ ጌሰ ዱንኮተ ተብሳሃ አኣም። ");
INSERT INTO alw_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","ጠዉ እኮጎሬ ጰንጠቆስጤ ከበጀት ኢለ ኤፌሶን ከተማን ዱንካም። ");
INSERT INTO alw_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","መሰንትስ ልግቡ ሆጉት ሄኦ አልባዕሉት ኡሩት ፈንተኦኤ፤ እኮጎሬ ኤሳሃ ግባኤ መኑ ልግብሃን። ");
INSERT INTO alw_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","ጥማቶስ አሜቾ ወክት ዋጁዕናን በላንከክዕኔ አፉዕለኖገ አዕዬስ፤ መሰንትስ እሲሁ ኢገን ቀርች ሆጉተ አአኖሃን። ");
INSERT INTO alw_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","ህካን እኮቤቺሃ አዪሁ ህንቁንከስ፤ እኮጎሬ አመዕናኖን ሜጡበ አገራምቤቺሃ ኢቤቹ ወገሬቲን ፈንቀሎተ ዎቄሀስ እካ ሽንቅተ ኣቴን ህርሲሼስ። ");
INSERT INTO alw_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","አመኔቤቱ አጵሎስ ዎሎ አመኦሶን ሜጡበ ክዕኔቤቹ መሮተ አበ ኡጭዮንስ እቅ፤ እኮጎሬ እስ ቴሱ ክዕኔቤቹ አሜቶተ ሀሾበአ፤ መከኖስ ወክት ክዕኔቤቹ አሜተኖ። ");
INSERT INTO alw_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","በቅይዬ፤ አመዕነቶንከክዕኔ ጠረኝቴን ኡርዬ፤ አጰሜ፤ ጠረኝዬ። ");
INSERT INTO alw_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","ህትን አቴነንታሃ ጉዕመንከ ኢታን አዕዬ። ");
INSERT INTO alw_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","አመኤ ኦሶ! አካይ ባዶን ሄጭት መገኑ አመዕንቶእሩ እስጥፋኖሴ አበሮስ እሁሰለከ እሰ አመዕናኑተ ሀዕልቶተ ገዉሰ ህግስ አቶገ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","እሰገ ዮ መኒሃለከ እሳንን ሜጡበ አተን ሆጋ መኒሃ ጉዕሚንከ አዘዘንቴነንተገ ጥሽ አዕይ ቃግሳንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","እስጥፋኖስ፥ ፈርዶናጢስለከ አካይቆስ ኢቤቹ አሜቶቤቺሃ ተሽ ይዮኤ፤ አዕኑ ኢን ሜጡበ ደገንቴንበቤቺሃ እሰ ክዕኔቤቾን ሆፈዕዮኤርቹ ዊንሽቶኤ። ");
INSERT INTO alw_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","እሰ ኢለ ክዕኔ ቀልብ ፎሎሲሶእረ፤ ህካን እኮቤቺሃ ህትኔ መነ ደጉ ሀስሰኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","እስይ ባዶን ሄኣ አመዕናኑተ «ወገሬት ዮንተንዶ?» ይታህዕኔት፤ ህትን አቂልለከ ጵርስቅል ምኔንከሰ ጭምይታ አመዕናኖን ሜጡበ ቀርች ሱዕሚን «ጠረኘገ ወገሬት ዮንተንዶ?» ይታህዕኔት። ");
INSERT INTO alw_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","ህትን አመዕናኑት ጉዕሙንኩ «ወገሬት ዮንተንዶ?» ይቶህዕኔ፤ ገገዉንኩክዕኔ አመዕናኖተ ሀስሰኖ ነጠ እኮ ወገሬትጨቀሚን ዝያዕረቀሜ። ");
INSERT INTO alw_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","አን ጳዉሎስ ከ ወገሬት ገይእ አንጋን ከተቦንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","ቀርቹ መሲህ ኢሰ ኢትባሁ ሄዕዮ ጎሬ ቦሮረሞኢሃ እሁን፤ ኒ ቀርቾ አም! ");
INSERT INTO alw_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","ቀርቾሃ ኢስ ኣስቱት ክዕኔን ሜጡበ እኩን። ");
INSERT INTO alw_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","ኢ ኢተት መሲህ ኢስ አዲን ጉዕሚንከክዕኔን ሜጡበ እኩን! ኣሚዕን። ");
INSERT INTO alw_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","መገን ሰውቲን መሲህ ኢስ አሳቤቹ እኮም አን ጰውሎሴ አመኔቤቲች ጢማቶሴች፥ ቆሮንቶሳን ዮ መገን አመዕናኖ ጭምት ዱእ ምናችለከ ህትን ዊመ አካይያን ዮ አመዕናኖተ ጉዕሚንከ ");
INSERT INTO alw_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","አንችኔ መገንቺ፥ ቀርቹሃኔ መሲህ ኢስ ኣስቱትለከ ወገሬቱ ክዕኔሃ እሁን። ");
INSERT INTO alw_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","ማርቶ አነ እኮሃ ጠረኝመተ ጉዕመንከ ኣሰኖ ህትን ቀርቹሃኔ መሲህ ኢስ አነ መገኒሃ ገለቱ ኢሉስ። ");
INSERT INTO alw_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","ነኡን መገኒች ኣእኖም ጠረኝማን ኦርሸ ኣዜን ዮእረ ጉዕመንከ ጠረኝሱ አታልኖተ መገኑ ኔሳሃ ኦርሻን ጉዕማንን ጠረኝሰኖኔ። ");
INSERT INTO alw_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","መሰንትስ መሲህ ኦርሸተ በትኝስ ቤቀሞምገን ጠረኝመታ መሲህ አዲን በትንስ ደእናም። ");
INSERT INTO alw_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","ህትን ነኡ ኦርሸተ ቶንጋሚሁ አዕኑ ጠረኝቶኖተለከ ጡምቶኖታት፤ ህትን ነኡ ጠረኝኖምጎሬ አዕኑሁ ነኡ ቶንጋም ደኒን ኦርሸተ አታዕሊን ቶጌን ጠረኝቴነንተ፤ ");
INSERT INTO alw_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","ህከኒሃ ኒ ኦርሸተ ቤቀንቴነንተሀንገን ሙንዲኑኔ ቤቀንቴነንተገ ደንጋምቤቺሃ ክዕኔ አሌን ዮኔ ተብሶሁ ጠረኘሃን። ");
INSERT INTO alw_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","አመኤ ኦሶ! እስይ ባዶን ኢልቶኔ ኦርሸተ ደጎኖተ ሀንሳም፤ ሁኩንን ኢልቶኔ ኦርሸት አታዕልናም ጌሲች በተኣን ፎሊን ሄዕናም ተብሳሃ ሙርኖም እቅ። ");
INSERT INTO alw_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","ህትን ሬሁተ ፈረዴመአንገ አዕን ቀልቤኔ ሰውይኖም እቅ፤ እኮጎሬ ሁኩ ጉዕሙንኩ ጠዉ አሌኔ ኢሌኢሁ ሬቶ መነ ሬሆች ኬሰኖ መገኖን ድከዕንት ቤሉ ገይኔ ዎልቃን ድከዕንበጋት። ");
INSERT INTO alw_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","መገኑ ሬሆች ጡምሾኔ፤ ቴሁ ጡምሰኖኔ፤ ህትን ከ ኤተሩሃ ፌሰኖኔገ መገኖን ተብሳሃ አዕናም። ");
INSERT INTO alw_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","አዕኑሁ ኔሳሃ ዱአ አቴነን ሀዕሉ ሀስሰኖህዕኔ፤ ህትን አበ ዱኢን ነኡ መገን ሀዕለንሸ ደእናም ወክት ልግቡ መኑ ኒ መሳን መገኑ ገለትጨኖ። ");
INSERT INTO alw_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","ነኡ ድከዕናምርቹ ከኒት፤ ከን ዱንየ አሌን በትሽን ክዕኔን ሜጡበ ዮኔ ደቀንሹ መገኒች ደዕኖም አመዕነንሺን ሄዕኖምገ ቀልቡኔ መሰከረኖ፤ ሁኩንን መን ሀይማን እሁዕነ መገን ኣስቶኒት። ");
INSERT INTO alw_vpl VALUES ("C21_13","077_1_13","2CO","1","13","14","መሰንትስ አዕኑ አነበቢሃለከ አጥራመቲሃ አታልቴነንተሀን ቤሉ ዎሉ መቱርቹሃ ከተባንክዕኔበአ፤ ህካን እኮቤቺሃ ቀርቹኔ ኢስ አሜተኖ በር ነኡ ክዕኔን ድከዕኖተለከ አዕኑ ኒን ድከኦኖተ ከኒች ብርተ ኒተኔሃ ቀዉንከ አጥራመቴነንታሁ ኤተሮንገ ሹልቴን አጥራመቴነንተገ ተብሳሃ አዕናም። ");
INSERT INTO alw_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","ከን ጠዋን ሀንቀኘ እኮምቤቺሃ አዕኑ ኢን ለሙ ወክት ደግለሸቀንቶኖተ ይ ጉዕመርቺችን ሄጭ ክዕኔቤቹ አሜቶተ ሀሾም። ");
INSERT INTO alw_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","አንን መቄዶን ባዱ መረንለከ ህከንቤቺች አሜተን ክዕኔቤቹ አሜቶተ ሰውይዮም እቅ፤ ህትን ክዕኔቤቺች ይሁድ ባዱ መራም ወክት ዎቄሃኤ ሽንቅተ ኣቴን ህርሲሴነንተኤገ ሰውይዮም እቅ። ");
INSERT INTO alw_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","ህትን አን ያጆም ወክት ሸኬምንዶ? ህትን አን ሰውያሚሁ መን ሰውትገ መቱርቹ «እሁን» ይ ፈንቀሽንገ «እሁንከ» የንትንዶ? ");
INSERT INTO alw_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","መገኑ ሀንቅንከ አመነሞኢሃ እኮገን ነኡሁ ኩልናንክዕኔ ላገት «እሁን» ይን «እሁንከ» ይኖታበአ። ");
INSERT INTO alw_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","አን ስላስለከ ጢማቶስ ተማርሰኖህዕኔሁ መገን ቤቱ መሲህ ኢስ ጉዕመ ወክት «ኤ ሀንቄንከ» መቶረ «እሁን» መቶረ «እሁንከ ዩሃበአ።» ");
INSERT INTO alw_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","መገኑ ኣሴኔ ተብሶሁ ጉዕሙንኩ «እሁን» እኮሁ መሲህት፤ ነኡ መሲህን መገን ኬዕምኚሃ «ኣሚዕን» ይናሚሁ ከኒሃት። ");
INSERT INTO alw_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","ኔሳሃ ክዕኔን ሜጡበ መሲህን ጠረኝናምገ አዕዮኔሁ መገኑሃን፤ ቡሮኔሁ እሶት። ");
INSERT INTO alw_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","እስረ እሁኔ ለሊሰኖ ገይስ ማተመ ኒ አሌን አዕዮሁለከ ጠሊለ አያነስ ሩብት እሆተ ቀልቤንከኔ አፉሼኢሁ እሶት። ");
INSERT INTO alw_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","አን ቆሮንቶስ ከተመ ፈንቀል አሜቱዕነ ፈቆሚሁ ኡሙዕር ሻዝሳንክዕኔበእገ ይዪት፤ ህከኒሃ መገኑ ምስክርሃእ። ");
INSERT INTO alw_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","አዕኑ አመዕነቶንከክዕኔ ጠረኝቴን ኡርቴነንተረ እኬንተቤቺሃ አዕኑ ሙንደኦኖተ ክዕኔን ሜጡበ አዕናምሀን ቤሉ አመዕነትክዕኔ አሌን ቀርቻኑተ እንካምበአ። ");
INSERT INTO alw_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","ቴሱ ሻዝሶህዕኔተ ሀሳምበእቤቺሃ ለንኪሃ ክዕኔቤቹ አሜታምበእገ ሙርስጭዮም። ");
INSERT INTO alw_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","አን ክዕኔተ ሻዝሾንክዕኔጎሬ ሻዝሾንክዕኔ ክዕኔ ቤሉ ኤሳሃ ሙንዲሲሰኖ አይ ዮኤ? ");
INSERT INTO alw_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","አን ህት ከተቦንክዕኔሁ ክዕኔቤቹ አሜቾም ወክት ኤሳሃ ሙንዲሲሱ ሀሳ መኑ ሻዛበእገ ይዪት፤ መሰንትስ ኢ ሙንዲኑት ጉዕሚክዕኔ ሙንዲኑተ እሁስ አመዕናም። ");
INSERT INTO alw_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","መሰንትስ አን ልግቤ ኦርሻን፥ ቀልብ ጭንቃንለከ አበ እንጂጃን ከተቦንክዕኔ ክዕኔተ አበ ኢታንክዕኔገ ደጎኖታት ቤሉ ሻዝሶህዕኔታበአ። ");
INSERT INTO alw_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","መነ ሻዝሾ መንቹ አዪሁ ሄዕዮጎሬ ሻዥሾሁ ጠለዕል ኤሳሃ እሁዕነ ቤሱስ በትሱ እሁንከኤ ቤሉ ጉዕመንከኔ እህበረ ልግብንከኔ ሻዝሾኡ። ");
INSERT INTO alw_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","ህትኔ መንቺሃ ክዕኔች ልግቡኔ ቀጠኤንተስ ቅጣት ጌሱ እሀኖስ። ");
INSERT INTO alw_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","ህካን እኮቤቺሃ ሁኩ መንቹ አበ ሻዦቤቺሃ ተብሳሃ ሙረኖበዕገ አዕኑ እሱሃ ማሮንስ ዩለከ ጠረኝሱ ሀስሰኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","ህትን እሶን ዮህዕኔ ኢተተ ፈንቀሽቴን ጠረኝሶኖተ ኡጫንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","አንን ህካን ከተቦንክዕኔሁ ፌተነንቴን ጉዕመ ጠዋንን አዘዘንቴንተረ እሁክዕኔ ደጎተ ይዪት። ");
INSERT INTO alw_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","አዕኑ ማሮንስ ይቴነንተስ መንቹ አዬሁ እኮጎሬ አኒሁ ማራንስ፤ ሁኩ መንቹ ቤሾርቹ ሄዕዮ ጎሬ አን መሲህ ብሬን «ማሮም» ያንሲሁ ክዕኔተኔሃት። ");
INSERT INTO alw_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","አን ህካን አኣሚሁ ሸይጣን ሂለ ጠወ ደንጋምቤቺሃ ኔሳሃ ጣንሰኖበእገ ይዪት። ");
INSERT INTO alw_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","ህከኒች ኤተሮን መሲህ ተሽት ላገተ ተማርሶተ ጥሮኣድ ከተመ መሮም ወክት ቀርች ሆጎ ኡሩት ፈንተኦኤ እቅ። ");
INSERT INTO alw_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","እኮጎሬ አመኤ ቤቲን ቲቶን ደቀሙ ሆጎምቤቺሃ ቀልቡኤ ሻዦ እቅ፤ ህካን እኮቤቺሃ «ወገሬቲን ሄዕዬ» ይ እሳች አደ እክ መቄዶን ባዱ ኦሮዕዮም። ");
INSERT INTO alw_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","ጠዉ እኮጎሬ መሲሂን ጉዕመ ወክት ድለ አዕናምረ አዕይ አዎንሰኖኔለከ ኤንኬዕንስ አንጀኖ ፎገል ኒ መሳን ጉዕመ ቤቾን ለሊሰኖ መገኒሃ ገለቱ እሁንስ። ");
INSERT INTO alw_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","መሰንትስ ጡምታሀኑኡተለከ በኣሀኑኡ በላን መገኒሃ መሲሂን ጡሙ ፎገሉ ዮስ አንጀነተ እንኮም። ");
INSERT INTO alw_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","ህካን እኮቤቺሃ ነኡ በአኖ መኒሃ ሬሆተ አንጀነ፤ እኮጎሬ ፈቀኖ መኒሃ ሄዕተ አንጀነ፤ ህከን ጠዊሃ በቀአኖ መንቹ አዬት? ");
INSERT INTO alw_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","መሰንትስ ነኡ መገን ላገተ ነገዳ ልግቤ መንጋበአ፤ ጠዉ እኮጎሬ ነኡ መገኒች ሶሀሞ መንገ መሲህ አዲን መገን ብሬን አመዕነሞምረ እንክ ጠወዕናም። ");
INSERT INTO alw_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","ገዉኔ ፈንቀሽን ገለትጭናምትንዶ? ህከረንገ መት-መቱ መኑ አታሀንገን ክዕኔሃ ህከረንገ ክዕኔች ገይኔ ጡምመተ ለሊሳ ደብዳቤተ ሀስሳኔንዶ? ");
INSERT INTO alw_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","አዕኑ መኑ ጉዕሙንኩ ደገኖህዕኔሁለከ አነበበኖህዕኔሁ ቀልብኔ ኣዜን ከተበንቴንተ ደብዳቤተኔ። ");
INSERT INTO alw_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","አዕኑ ኒ ክድማን አሜቴንታሁ መሲህ ሶህኑተ እሁክዕኔ ለሊዮእሃን፤ ኩ ሶህኑት ከተበንቶኢሁ ሄአኖ መገን አያኒንት ቤሉ ቀለማንበአ፤ ህትን ከተበሞንኩ መን ቀልቤን ቤሉ ክኒ አሌንበአ። ");
INSERT INTO alw_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","ካን ይናም መሰንት መሲህ መሳን መገን አሌን አመዕነቱ ዮኔቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","ክድመ ሆጉተ አዕኖተ አታልናሚሁ ዎልቀተ ኣሰኖኔ መገኒንት ቤሉ ነኡ ጠረኛኑተ እንክበአ። ");
INSERT INTO alw_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","ሃዕሮ ወኣድ ላገ ካዲመተ እንኮተ ዎልቀተ ኣሴኔሁ እሶት፤ ሁኩንን ከተቤመ ሕጊን እሁዕነ መገን አያን ወልቃኒት፤ ከተቤመ ሕጉ ሬሁተ ኤበኖ፤ መገን አያኑ እኮጎሬ ሄኡ ኣሰኖ። ");
INSERT INTO alw_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","ክኒ አሌን ከተበሞ ሕጉ አሜቾሁ ኬዕምኚንት፤ ሁኩን ሙስ ሚኔ አሌን ለለን ሄዕዮ ኬዕምኙ ሆፈአን ኦሮዕዮ ጎሬሁ ሚንስ አበ በለቃኢሃ እኮቤቺሃ እስራኤላውያኑት ሚንስ ቱክ ይት ለኦተ አታልቶበአ፤ ቴሱ ኩን ሬሆቤቹ አዎንሰኖ ሕጉ ህትኔ ሎረ ኬዕምኚን አሜቾሃ እኮች ");
INSERT INTO alw_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","ጠሊለ መገን አያን መሳን ደገመኖ ክድመት በተአኖ ኬዕምኙ ሄአኖስበእንዶ? ");
INSERT INTO alw_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","መሰንትስ መን አሌን ፍርደ ኤቦ ሆጎተ ኬንኩ ኬዕምኙ ሄዕዮች መኒ ፈይመተ ኤቦ ሆጎተ በተአኖ ኬዕምኙ ሀት ሄአኖስበአ? ");
INSERT INTO alw_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","ወዕና ሄዕዮ ኬዕምኙ ኤተሮን አሜቾ ኬዕምኚን ሜጡበ ለኤኖ ወክት መቱርቹሁ ኬዕምኙ ዮስበእሃ እሁስ ለዕናም። ");
INSERT INTO alw_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","ሁኩ በአን ኦሮአን ሄዕዮሁ ኬንኩ ኬዕምኙ ሄዕዮሲች ዘላለሚሃ ጠረኝ ሄአኖሁ ሀት በተዕዮ ኬዕምኙ ሄአኖስበአ። ");
INSERT INTO alw_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","ቴሱ ህትኔ ተብሶሁ ሄዕዮኔች ነኡ መለልን ጠወዕናም። ");
INSERT INTO alw_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","እስራኤላውያኑት ሚኔሰ ኑሩ በአን ኦሮአኖሃ መጨረሸስ ለኣበእገ ሚንስ ሻሺን ድቦ ሙስጋበአ። ");
INSERT INTO alw_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","እሰ ቀልቡ ዱጆኡ፤ ከበሬ ኢለ ኑባቹ ወኣድ መጻፈ አነበቤኖረ ቀልቡሰ ህከን ሻሺን እፍሰሞጋንት፤ መሰንትስ ሁኩ እፍሰሞሁ ኬአኖሁ ጠለዕል መሲሂን እኮቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","ኤ ከበሬ ኢለ ሕግ መጻፈተ አነበበንታ ወክት ጉዕመንከ ሁኩ ሻሹ ቀልቤንከሰ ሄአኖ። ");
INSERT INTO alw_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","ጠዉ እኮጎሬ መኑ ቀርቾ ኢሲበ ፈንቀሎ ወክት ሁኩ ሻሹ ሽቀኖ። ");
INSERT INTO alw_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","ህትን ቀርቹ አያነ እኮቤቺሃ ቀርች አያኑ ዮቤቾን ጉዕማንን ሰዎልድመት ዮኡ። ");
INSERT INTO alw_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","ነኡ ጉዕሙንኩኔ ጌረደሞበእ ሚኔን እንክ ለአቃንቺን ለእናምሀንገ ቀርች ኬዕምኝ ለዕናም፤ ነኡ ኬዕምኚች ኬዕምኜን እሱ አጉዲሃ ዶረማሚት፤ ሁኩን እኮሁ አያነ እኮ ቀርቺችት። ");
INSERT INTO alw_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","መገን ማርቶን ኩ ሆጉት ዮኔቤቺሃ ተብሳሃ ሙርናምበአ። ");
INSERT INTO alw_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","ጠዉ እኮጎሬ ማጠሞለከ ሙልሲሰኖ ጠወ ኡጅኖም፤ ተንኩተ አዕናምበአ፤ መገን ላገተ ክዝቢን ልቀለንቃምበአ፤ ህከን ወጢ ሀንቅ በነቻን ለሊንሳም፤ ሀንቅ ለልሲን እኮጎሬ መገን ብሬን ጡመ አዕኖሚሃ እሁኔ መኒሃ ጉዕሚንከ ለሊንሳም። ");
INSERT INTO alw_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","ነኡ ተማርስኖም እንጂል ላገት አይደጎ ማጠሞሃ እኮጎሬ ማጠሞሁ በአኖሁ መኒሃት። ");
INSERT INTO alw_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","ህትን መገን ምሳልተ እኮ መሲህ ሎርመተኔሃ ኩለሞ ተሽት እንጂል ላገ ኑር ለኣበእገ ከን ኣዱንያ አል ሸይጣኑ መገኑ አመዕንቶብእ መን ቀልብ ቆቅሾኡ። ");
INSERT INTO alw_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","ነኡን መሲህ ኢስ ቀርቹ እሁስለከ ነኡ ገዉኔ ኢስተኔሃ ክዕኔ ካዲመተ እንኮም ቤሉ ገይኔተኔሃ ተማርስናምበአ። ");
INSERT INTO alw_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","መሰንትስ «ቱንስች ኣዚች ኑሩ ፉሉን» ይ ጠወዕዮ መገኑ መሲህ ብሬን ለሊሰኖ መገን ኬዕምኙ ደንጋም ኑር ኣሶኔተ ኑሩስ ቀልብኔ ኣዜን ለሊሰኖገ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","ጠዉ እኮጎሬ ኩ ሎሩ ዎልቀት መገኒሃ እሁንስ ቤሉ ኒሃ እሁ ሆጉስ ለልሲሃ ኩ ሎሩ ጠዉ ትብ ኦዳገ እንኮም ኒ ኣዜን ዮኡ። ");
INSERT INTO alw_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","ኔሳሃ ጉዕመ አዲንን ኦርሸት እልታኔ፤ ጠዉ እኮጎሬ ቄለማምበአ፤ ልግብ ወክት ጉረተ ኣገኖኔ ቤሉ ተብሳሃ ሙርናምበአ። ");
INSERT INTO alw_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","ህትን ሸሬኖኔ ቤሉ ሜጢሃኔ እንክ ፈንቃምበአ፤ ዎቀረም ኡንባም፤ እኮጎሬ ሬናምበአ። ");
INSERT INTO alw_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","ኢስ ሄኡ አሌኔ ለሎተ ጉዕመ ወክት ጅስምኔ አሌን ኢስ ሬሁተ እጅን ዘህናም። ");
INSERT INTO alw_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","መሰንትስ ኢስ ሄኡ ሬሀኖ ጅስማንከኔ ለሎተ ኔሳሃ ቴሱ ፎሊን ዮምረ ኢስተኔሃ ጉዕመ ወክት ሬሆተ ህግሴን ኣሴኖኔ። ");
INSERT INTO alw_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","ህካን እኮቤቺሃ ሬሁት ኒ አሌን ሆጉተ አታአ። እኮጎሬ ሄኡክዕኔ አሌን ሆጉተ አአኖት። ");
INSERT INTO alw_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","እሁን ቤሉ «አመዕንዮም፤ ህካን እኮቤቺሃ ጠወዕዮም» የመም ከተበሞቤቺሃ ሁኩ አመዕነት ቀልቡ ዮኔቤቺሃ ነኡ አመዕንናም፤ ህካን እኮቤቺሃ ጠወዕናም። ");
INSERT INTO alw_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","ቀርቹ ኢሰ ሬሆች ኬሾ መገኑ ኔሳሃ ኢሲን ሜጡበ ኬሰኖኔገለከ ክዕኔንን ሜጡበ እስ ብርተ ሆንጠህሰኖኔገ ደንጋም። ");
INSERT INTO alw_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","ሁኩን ጉዕሙንኩ እኮሁ ክዕኔተ ደግለልሃት። ኣስቱት ልግቤ መኒሃ ኢልቶኢሁ መገኒሃ ኬዕምኝ እሀኖ ገለቱ በተኦታት። ");
INSERT INTO alw_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","አብልን ለኤኖ ጅስሙኔ በአን መሮ ጎሬ ኣዝኔ ጅስሙ በሬን በሬን ሃዕሮሃ እኮቤቺሃ ተብሳሃ ሙርናምበአ። ");
INSERT INTO alw_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","ከን ቀዎ ወክቲሃ ኦርጨማም ኬዕምትበ ወክትስ ኦርሸት ሎረለከ ዘላለሚሃ ሄአኖ ኬዕምኚሃ ቅጥ አታኔት። ");
INSERT INTO alw_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","መሰንትስ ነኡ ኦሎንሰን ዮሚሁ ለልባሃት ቤሉ ለለኖሃበአ፤ ለለኖርቹ ቀወ ወክቲሃት፤ እኮጎሬ ለልበርቹ ዘላለሚሃ ሄአኖሃን። ");
INSERT INTO alw_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","ኩ ዱካንገ ዮ ኣዱንያ አል ምኑኔ ድጀሞች መን አንጋን እሁዕነ መገኑ እጃሮ ዘላለሚሃ ሄአኖ ምኑ ሰማን ዮኔሃ እሁስ ደንጋም። ");
INSERT INTO alw_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","ሀንቅንከ ነኡ ሰሜ ምኒኔ ኦደዕኖተ አበ አዛንባሚት። ");
INSERT INTO alw_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","መሰንትስ ህካን ኦደዕኖሚች ኤተሮን ከልን እንካምበአ። ");
INSERT INTO alw_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","ህትን ከን ዱካናን ዮም ጌሳን ኬዕሜሃኔ አዛንባም፤ ነኡ ኦርጨቀማሚሁ ሬሀኖ ማሉኔ ሄኦን ዶረሞተ ሰማን ዮ ምኒኔ ኣንጎተ ሀንሲት ቤሉ ከን ኣዱንያ አል ጠዊች አደ እሂሃ ሀንስበአ። ");
INSERT INTO alw_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","ከን ጠዊሃ ቅጥ አዕዮኔሁለከ ጠሊለ አያነ ኔሳሃ ሩብት እሆተ ኣሴኔሁ መገኑሃን። ");
INSERT INTO alw_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","ነኡ ማሊን ከን ኣዱንያ አሌን ዮም ጌሳን ቀርቺን ሜጡበ ሄኡ ሆጉኔ ደንጎምጎሬ ጉዕመ ወክት እሱ አመዕንን ሄዕናም። ");
INSERT INTO alw_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","መሰንትስ ነኡ ሄዕናሚሁ አመዕኒንት ቤሉ ለእንበአ። ");
INSERT INTO alw_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","ህትን ከን ማሊች አደ እንክ ቀርቾሃ ኢሲን ሜጡበ ሄዕኖተ ሄዕላንታምቤቺሃ አመዕነንሺን ሄዕናም። ");
INSERT INTO alw_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","ህካን እኮቤቺሃ ማሊንከኔ ሄዕኖም ጎሬ ህከረንገ ማሊችኔ አደ እንኮምጎሬ ሰውቱኔ መገኑ ሙንዲሲሱሃን። ");
INSERT INTO alw_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","መሰንትስ መት-መቱስ ማሊንከስ አዕዮ ጡመ ጠዊሃ እኮ ሂለ ጠዊሃ ሆጎስ ዋገ ሀስሰኖስርቹ ቶጊሃ ጉዕሙንኩኔ መሲህ ፍርድ ቦርጭመ ብርተ ሆንጠሁ ሀስሰኖኔ። ");
INSERT INTO alw_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","ቀርቹ ዋጁ ዩ መ ዩሃ ጎሬ ደንጋምቤቺሃ መኑሁ ደገኖገ አዕናም፤ እኮጎሬ ነኡ ሀትናሞሃ መነ ጎሬ መገኑ ደገኖ፤ ክዕኔ ቀልቡሁ ህካን ደገኖሃ እሁስ ተብሳሃ አዕናም። ");
INSERT INTO alw_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","ቀልብ ኣዜን ዮ ጠዋን እሁዕነ ለለኖ ጠዋን ድከኣ መኒሃ ፈንቀሽቴነንተ መስሉ ሄኦህዕኔተ ኒን ድከኤነንተ ዎቃሃ ደእቴነንተገ አዕኖህዕኔታት ቤሉ ቴሱ ገዉኔ ክዕኔ ብሬን ገለትጭኖታበአ። ");
INSERT INTO alw_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","ነኡ በርገጋሸ እንኮምጎሬሁ መገኒሃ ይኒት፤ ህትን ኤንኬዕናመተ እንኮምጎሬ ክዕኔኤሃ ይኒት። ");
INSERT INTO alw_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","መቱ ወክት መሲህ መኒሃ ጉዕሚንከ ሬሁስለከ መኑ ጉዕሙንኩ እስ ሬሆተ ቤቃማኑተ እሁሰ ደንጎምቤቺሃ መሲህ ኢተቲ ሆጎተ ግዳጅሳኔ። ");
INSERT INTO alw_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","ህትን ፎሊን ዮ መኑ ጉዕሙንኩ እሳሃ ይ ሬዮለከ ሬሆች ኬዕዮ መሲህሃ ሄኦታት ቤሉ ከ ኤተሩ ገይሀሰ ይት ሄኣበእገ መሲህ ጉዕሚንከ ሬዮ። ");
INSERT INTO alw_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","ቴሱ ከ ኤተሩ አዬሁ መኑ ለአኖ ሃሊን ለዕናምበአ፤ ነኡ መሲህ ከኒች ብርተ ህት ለእኖም ጎሬ ከኒች ኤተሮን እኮጎሬ ህት ለዕናምበአ። ");
INSERT INTO alw_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","ህካን እኮቤቺሃ አዪሁ መሲሂን እኮጎሬ ሃዕሮሃ ክልቀት፤ ኑባቹ ክልቀቱ ህጎኡ፤ እሲንን ሃዕሮ ክልቀቱ አሜቾኡ። ");
INSERT INTO alw_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","ሁኩ ጉዕሙንኩ ጠዉ እኮሁ ኔሳሃ ገይንከስ መሲህ አዲን ሀራርሴኔለከ ሀራሮ ሆጉተ ኣሴኔ መገኒችት። ");
INSERT INTO alw_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","መገኑንኩ መን ጩብ ዎለኡዕነ መሲህ አዲን ከን ኣዱንያ አል መነ ገይንከስ ሀራርሴ ዩሃን፤ መነ ቀርቺን ሀራርስ ላገተ ኔሳሃ ኣሴኔ። ");
INSERT INTO alw_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","መገኑ ኒ አዲን መነ ገአኖቤቺሃ ነኡ መሲህሃ ወከለሞምራን፤ ህካን እኮቤቺሃ ነኡን «መገኒን ሀራዕረሜ» ይን መሲህ ሱዕሚን ኡጭናንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","ነኡ መሲህ አዲን መገኒሃ ፈየ እንክ ዎለአሞተ ጩቡ ዮበእ መሲሂ መገኑ ኒተኔሃ ጩበኝገ አዕይ ዎለዕዮስ። ");
INSERT INTO alw_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","ነኡ መገኒን ሜጡበ አዕናምረ እንኮምቤቺሃ መገኒች ቶጌንተ ኣስቱተ ተሰ አቴነንተበእገ ኡጭናንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","መሰንትስ መገኑ «አን ኢታም ወክቴን ሞጮጬንስ! ጡም በርንከ ሀዕሌንኬ» የኖቤቺሃ «እስ ኢተኖ ወክቱ ቴሶት፤ ጡሜኖ በሩ ቴሶት።» ");
INSERT INTO alw_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","ኒ ሆጉት ህንቀንታበእገ ይን መ ጠዋን አዬሁ ጉፉቹ እንካምበአ። ");
INSERT INTO alw_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","እሁን ቤሉ አዕናም ጠዋን ጉዕማንን ገውኔ መገን ካዲመገ ሆንጠህንሳም፤ ሁኩንን አበ ኦርሻን፥ ሻዞን፥ ጭንቃን፥ ");
INSERT INTO alw_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","ገረፈሚን፥ ኡሱረሚን፥ ረብሻን፥ ሆጎ በትኜን፥ ግሰኛተ ሆጊንለከ ጎሪንት። ");
INSERT INTO alw_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","ህትን ነጢማን፥ ኤንኬዕኒን፥ አደቢን፥ ጎደበ ላፍማን፥ ጠሊለ አያኒን፥ ሀንቅ ኢታን፥ ");
INSERT INTO alw_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","ሀንቅ ጠወ ጠወኢንለከ መገን ዎልቃን ሄዕኖም፤ ፈይመ በገዝ ኦዳተ ጉረለከ መኬ አንጋን አፊኒት። ");
INSERT INTO alw_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","ኬዕምኚንለከ ሆፍኚን፥ ገለትጨሚንለከ ቦሮረሚን ሄዕኖም፤ ሀንቀኛኑተ እንከን ክዝበኛኖገ ዎለአሞም፤ ");
INSERT INTO alw_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","ደገማምረ እንከን ደገምበረ እንኮም፤ ሬቶ ዬነን ፎሊን ዮምረ እንክ ደገማም፤ ኦሌመኔጎሬሁ ሬኖምበአ፤ ");
INSERT INTO alw_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","ሻዙት ኢልቶኔጎሬ ጉዕመ ወክትንከ ሙንደዕናም፤ ቡጥቻኑተ እንኮምጎሬሁ ልግብ መነ ቀባጣመተ አዕናም፤ መቱርቹሁ ዮኔበእረ እንኮምጎሬሁ ጉዕሙርቹንኩ ኒሃን። ");
INSERT INTO alw_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","ቆሮንቶስ ከተማን ዮንተ መኑ! ነኡ መቱርቹሃ ፌንሱዕነ ኩልኖንክዕኔ፤ ቀልብኔ አልባሽን ፈኖንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","አዕኑ ኢተክዕኔ ኔሳሃ ከንቴንታኔ ቤሉ ነኡ ኢተኔ ክዕኔሃ ከሞምበአ። ");
INSERT INTO alw_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","ጠዉ እኮጎሬ አዕኑ እለኤ እኬንተቤቺሃ ያንክዕኔ፤ ነኡ ቀልብኔ ጠወ ማንጡዕነ ኩልኖንክዕኔገን አዕኑሁ ቀልብክዕኔ ጠወ ማጦኑዕነ ኩሌኔ። ");
INSERT INTO alw_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","አመዕንበ መኒን ገበእበ ዎቄን ጠመደንቶኖቼ፤ መሰንትስ ፈይመትለከ ጩቡ ሀት እክ ደቀንቶተ አታልታአ? ህትን ኑሩለከ ቱንስቹ ሀት እክ ሜጡበ ሄኦተ አታልታአ? ");
INSERT INTO alw_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","ህትን መስሂሃለከ እልብሲሃ ም ደቀንሹ ዮሰ? ህትን አመዕኔኢሁለከ አመዕንቡሁ ሚን ደቀንታአ? ");
INSERT INTO alw_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","መገን ምኑ ሽርኬን ም ደቀንሹ ዮኡ? መሰንትስ መገኑ «አን እሳን ሜጡበ ሄኣም፤ በላንከሰ ፈንቀላማም፤ መገኑሰን እሃም፤ እሰን ኡመቲኤ እካአ» ይ ጠወዕዮገን ነኡ ጉዕመንከ አታለኖ መገንያ ምኒ። ");
INSERT INTO alw_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","ህካን እኮቤቺሃ ቀርቹ «እሰ ኣዚች ፉልቴን አደ እኬ፤ ንጃሾሃ መርቹሃ ኡልቶኖቼ፤ አንን ኢረ አዕይ ቶጋንክዕኔ፤ ");
INSERT INTO alw_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","ህትን አን አነክዕኔ እሃም፤ አዕኑ ኤሳሃ ጎነለከ ሜኣ እለተ እኬነንተ የኖ ጉዕመንከ አታለኖ ቀርቹ» ዬእ። ");
INSERT INTO alw_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","ቴሱ ኢ ጃላ! ኩ ጉዕሙንኩ ተብሶሁ ኣሰሞሁ ኔሳሃ እኮቤቺሃ ማለለከ አያነ ንጃስሰኖ ሀከን ጠዊች ገዉኔ አገዕርኖ፤ መገኑ ዋጂን ዊመ ዊሚን ጠሊልማን ሄዕኖ። ");
INSERT INTO alw_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","ቀልቢን ቶጌኔ፤ ነኡ ሜጡ መንቹሃ በደልኖምበአ፤ መቱ መንቹሃ ምርኖምበአ፤ መቱ መንቹሃ ደግለሸቀማምሃ አዕኖምበአ። ");
INSERT INTO alw_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","ካን ይናሚሁ ክዕኔ አሌን ፈረንዶታበአ። ከኒች ብርተ ኩሎንክዕኔገን አዕኑ ቀልብኔ ኣዜኒት፤ ህካን እኮቤቺሃ ሄኦን እኮ ሬሆን ጉዕመ ወክት ክዕኔች መለዕለማምበአ። ");
INSERT INTO alw_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","ክዕኔ አሌን ዮኤ አመዕነቱ አበሃን፤ ክዕኔን አበ ቦናም፤ ክዕኔን ጠረኝመተ ደኣም፤ ኦርሻንተኔ ጉዕማኒን ሙንዲኑኔ ዳንጉ ዮስበአ። ");
INSERT INTO alw_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","ነኡ መቅዶን ባዱ አሜንቶም ወክት ጉዕመ አዲን ኦርሸት አሌንከኔ እልቶኔ ቤሉ ጅስሙኔ ፎሎጭዮበአ፤ አብሊን ብተተ ሄኦ እቅ፤ ኣዚን ዋጁ ሄዕዮኔ እቅ። ");
INSERT INTO alw_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","ጠው እኮጎሬ ሻዦ መነ ጠረኝሰኖ መገኑ ቲቶ አሜቲን ጠረኝመተ ኣሴኔ። ");
INSERT INTO alw_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","ጠረኝኖሚሁ ትቶ አሜቲን ጠለዕል እሁዕነ አዕኑ እሱ ጠረኝሴንተገ ሞጮጭኒት፤ ህትን አዕኑ ኤሳሃ ለኦኖተ ሱንቴንተገ፥ ኤሳሃ ጨነቀንቴንተገለከ እኮ ጠዋን ሰጩሰ ሞጮጭኖም ወክት አበ ተሽ ዬኤ። ");
INSERT INTO alw_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","ከኒች ብርተ ከተቦንክዕኔ ደብዳቤት ሻዝሳህዕኔጎሬ ሚሃ ከተቦም ይ ሰጫምበአ፤ ሰጬም ጎሬ ሰጬም ሶህኖንከኤ ቀዎ ወክቲሃ ሻዝሶህዕኔቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","ቴሱ እኮጎሬ ተሽ ይዮኤ፤ መሰንትስ ኤሳሃ ተሽ ዬኤሁ ክዕኔተ ሻዝሾንክዕኔቤቺሃ እሁዕነ ሻዘነክዕኔ መሳን ቶበቴን ፈንቀልቴንተቤቺሃት፤ ቴሁ ሻዘነክዕኔ መገኑ ዬገ እኮቤቺሃ ነኡ መቱርቹሃ በደልኖንክዕኔበአ ዩሃን። ");
INSERT INTO alw_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","መገን አዲን እኮ ሻዘነት ጡም አደ አዎንሰኖ ቶበቲን ደገመኖ ዶረንሸ ደግሲሰኖቤቺሃ ሰጫቱንት ዮስበአ፤ እኮጎሬ ኣዱንያ አል ሻዘነት ሬሁተ ኤባአ። ");
INSERT INTO alw_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","ኩ መገን አዲን እኮ ሻዘነት ሀትኔ ጠረኝመተ፥ ሀትኔ መስለ ኣሱ፥ ሀትኔ ጡመ ኡሙዕርተ፥ ሀትኔ ከበጅ ዋጁ፥ ሀትኔ ሱኑ፥ ሀትኔ ጡመ ሃሸኡ፥ ሀትኔ ሀንቅ ፍርዱ እሀን ለኤኖ ሄዕላቸተ ደግሲሾህዕኔገ ጡመገ ቀልቢን ለዕዬ። አዕኑ ከን ጠዋን ነጣኑተ እሁክዕኔ ጉዕመ አዲንን መሰከርሲሴንታአ። ");
INSERT INTO alw_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","አን ከተቦንክዕኔሁ ኔሳሃ ዮህዕኔሁ ጡሙ ሰዉቱ መገንሀኔን ክዕኔሃ ጡመገ ለሉን ይዪት ቤሉ ቤሾ መንችተኔሃ ህከረንገ ምዕርተዕዮ መንችተኔሃበአ። ");
INSERT INTO alw_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","ህካን እኮቤቺሃት ነኡ ጠረኝመተ ደእኖሚሁ ህከን መሳኒት፤ ኒ ጠረኝማች አበ አዕኑ ጉዕሙንኩክዕኔ ቲቶ ቀልብ ፎሎስሴነን ቲቱ ሙንደዕዮቤቺሃ ነኡ አበ ሙንደዕኖም። ");
INSERT INTO alw_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","አን ክዕኔን ድከኣምገ ቲቶሃ ኩሎም እቅ፤ አዕኑሁ ሙልሴንታኤበአ፤ ነኡ ጉዕመንከ ወክት ሀንቅ ኩልኖንክዕኔ፤ ህከንገን ክዕኔን ድከዕናምገ ቲቶሃ ኩልኖም ሀንቅ እሁስ ተሬገጠሞኡ። ");
INSERT INTO alw_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","ህካን እኮቤቺሃ ቲቶ ዋጅቴነንለከ ሁጤነን ጉዕሙንኩክዕኔ አዘዘንቴን ቶጌንተስገ ሰዉ የኖ ወክት ክዕኔሃ ዮስ ኢተት አበሃን። ");
INSERT INTO alw_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","አን ክዕኔን አመዕነሙ አታሎምቤቺሃ አበ ተሽ ይዮኤ። ");
INSERT INTO alw_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","አመኤ ኦሶ! መገኑ መቄዶን ባዶን ዮ መገን መኒሃ ኣሴ ኣስቶተኔሃ ደጎኖተ ሀንሳም። ");
INSERT INTO alw_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","እሰ አሌንን አቡ ኦርሸት እካን ፌተነንቶኡ፤ እሁን ቤሉ ሙንዲኑሰ አበ እኮቤቺሃ እሰ መሃ ቡጥቻኑተ እኮጎሬ ሙንዲኖን አበርቹ አቶኡ። ");
INSERT INTO alw_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","እሰን አታልቶ ጌሰ እሁዕነ አታልታሀኒች አበ ኢትት ኣቶ ኣስቶገ መሰከራም። ");
INSERT INTO alw_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","ቴሁ እሰ «መገን መኒሃ ሀዕለኖ ብረ ነኡ ጭም አዕናም» ይት ጠረኝስ ኡጭቶኔ። ");
INSERT INTO alw_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","ህትን እሰ ነኡ አገርኖምሀኒች አበሃት ኣቶኢሁ፤ ወዕናሃ ገውሰ ቀርቹሃኔ መሲህ ኢሲሃ ህግስ ኣቶኡ፤ ህከኒች ኤተሮን መገን ሰውትገ ገውሰ ኔሳሃ ህግስ ኣቶኡ። ");
INSERT INTO alw_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","ከ ሆጉተ ወዕናንከ ጀመሮሁ ቲቶ እኮቤቺሃ ቴሁ እስ ገውንኩስን ህከ ጡመ ሆጉተ ሹል አኦተ ኡጭኖንስ። ");
INSERT INTO alw_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","አዕኑ ጉዕመርቾንን እስን አመዕነቲኒ፥ ጠወኤነንተ ጠዊኒ፥ ኤንኬዕኒን፥ ጡመ ሆጎን ጠረኚን፥ ኒን ዮህኔ ኢታን በተኤን ደገንቴንተገን ከን መኒሃ አኤኖ ጡመ ሆጎን በተዕዬ። ");
INSERT INTO alw_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","አን ህት ያንክዕኔሁ ክዕኔተ አዘዞታበአ፤ ጠዉ እኮጎሬ ዎሉሰ ሀዕልቶተ አበ አጰንታቤቺሃ ክዕኔ ኢተተ ሀንቅ እሁስ አጥራመቶተ ይዪት። ");
INSERT INTO alw_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","አዕኑ ቀርቹሃኔ መሲህ ኢስ ኣስቱተ ደጌነንተ፤ እስ መሃ ቀባጣሙ እኮጎሬ እስ ቡጥማን አዕኑ ቀባጣመተ እኮኖተ ክዕኔተኔሃ ቡጥቹ ኢኮኡ። ");
INSERT INTO alw_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","ከን ጠዊተኔሃ ደግለለኖህዕኔ ጠወ ሸዛንክዕኔ፤ ኑሬ ዘማንች ጀመርቴን ጠለዕል ኣሲሃ እሁዕናን ከ ጠወ አቶኖተ ሰዉ ይቴነንተሩ ብሬሩ አዕኖት እቅ። ");
INSERT INTO alw_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","ህካን እኮች ዮህዕኔ ጌሲች ኣቶኖተ ሰው ይቴንተ ሰዊቱክዕኔ ዊሞተ ቴሁ ህከ ሆጉተ ሹልቴን አዕዬ። ");
INSERT INTO alw_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","መቱ መንቹ ዮስበእ ጌስን እሁዕነ ዮስ ጌስን ኢት ኣሰኖሃ እኮች ህከን ኣሴርቾን መገኑ ሙንደአኖ። ");
INSERT INTO alw_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","አን ካን ያሚሁ ጉዕሙንኩክዕኔ ቅጡ እኮኖታት ቤሉ አዕኑ ኣቴነን ኦርጨቀንቴነን ዎሉሰንገ ፎሎጭቱን ይዮምበአ። ");
INSERT INTO alw_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","አዕኑ ኦርጨቀንቴነንተ ወክት እሰ ዱንያት ክዕኔ ኦርሸተ ሀዕልቶተ ቴሱ ክዕኔሃ ዮህዕኔርቹ እሰ ኦርሻተ ሀዕሉን፤ ከን ሃሌን በላንከክዕኔ ሜጦመት ሄኣአ። ");
INSERT INTO alw_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","ሁኩንን፦ «ልግብ ጭምአዕዮሀኒሀ ተረፎስበአ፤ ቀዉ ጭም አዕዮሀኒሃ ሆፈዕዮስበአ» የመም ከተበሞጋት። ");
INSERT INTO alw_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","አን ክዕኔሃ ሰውያም ጌሰ ቲቱ ክዕኔኤሃ ቀልቢንከስ ሰውዮተ አዕዮ መገኑ ገለትጨሙን። ");
INSERT INTO alw_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","ቲቱ ክዕኔቤቹ አሜተኖሁ ገውስ ሃሸዕይ ሙንዲኖን ኬዕይት ቤሉ ነኡ ጠለዕል ኡጭኖስቤቺሃበአ። ");
INSERT INTO alw_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","ህትን እንጂለ ተማርሰን አመዕናኖቤቾን ገለትጨሞ አመዕናንቹ እሲን ሜጡበ ሶንካም። ");
INSERT INTO alw_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","ህከኒች አበ ሀዕላቀንሸስ ቶንጋም ወክት ሜጡበ መሮተ አመዕናኖን መጠረሞኡ፤ ሀዕላቀንሸስ ቶንጋሚሁ ቀርቹ ገውስ ኬዕምሰኖሃለከ ዎሉሰ ሀዕሊሃ ዮኔ ጡመ ሃሸኢች ኬዕዮሀኒንት። ");
INSERT INTO alw_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","ከን መኒሃ ኢልንሶተ ኣሰሞኔ ብርተኔሃ አዪሁ ዎቀሰኖኔበእገ አገዕርናም። ");
INSERT INTO alw_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","አላመኔ ቀርች ብሬን ጠለዕል እሁዕነ መን ብሬንን ጡመ እኮ ጠወ አኡሃን። ");
INSERT INTO alw_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","ልግብ ወክት ነኡ አበ ወቄን ፌተነም ጠረኘ እክ ደገሞ አመኔቤቱ ቲቶንን ሜጡበ ሶንኮሚሁ ህከን መሳኒት፤ እስ ክዕኔ አሌን ዮስ አመዕነቱ አበ እኮቤቺሃ ከን ሆጎን ሀዕሎተ ዮስ ጠረኝመት መ ወክቲች አበሃን። ");
INSERT INTO alw_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","ቲቶተኔሃ ደጊሃ ሀሴንተ ጎሬ ክዕኔተ ሀዕሎተ ኢን ሜጡበ አአኑሃ ጃላኤ፤ እሲን ሜጡበ አሜታሀኑኡተ ዎሎ አመኔ ኦሶተ እኮጎሬ እሰ አመዕናኖ ጭምት ወከለንቶረለከ መሲህ ኬዕምኚሃ ኡርቶእረ። ");
INSERT INTO alw_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","ህካን እኮቤቺሃ ኢተክዕኔ ለሊሼሰ፤ ከን ሃሊን ኢተኔለከ ክዕኔ አሌን ህትን ድከኡ ተሰ እሁ ሆጉስ አመዕናኖተ ጉዕሚንከ ለሊሴነንተ። ");
INSERT INTO alw_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","ይሁዳን ዮ አመዕናኑተ ደግለሊሃ ጭም አኤመ ብርተኔሃ ክዕኔሃ ከተቡ ሀስሰኖበአ። ");
INSERT INTO alw_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","መሰንትስ አዕኑ ደግለልቶኖተ ቅጥ ይቴንታእረ እኬንተገ ደንጎምቤቺሃ «አካይ ባድ መኑ ህጎ ዘማኒች ኬስ ደግለልቶተ ቅጥ ይቶእራን» ይ መቅዶን ባድ መኒሃ ክዕኔተኔሃ አመዕን ጠወዕዮሚሁ ጠረኝመክዕኔ ደጋምቤቺሃት፤ መነ ደግለልቶኖተ ዮህዕኔ ጡሙ ሰውቱ እሳች ልግብሰ ኬሰንስዮኡ። ");
INSERT INTO alw_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","ጠው እኮጎሬ ከን ጠዊን ክዕኔተኔሃ ቦናም ቦኑኔ ህትን ተሰ እህበገ ከ አመኦሱተ ሶሃም፤ አዕኑ አን ከኒች ብርተ ዬምገን ተቃጠቤን አገሬ። ");
INSERT INTO alw_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","መቅዶን ባድ መኑ ኢን ሜጡበ ክዕኔቤቹ አሜት ቅጥ ይቶኑዕነ ደጎህዕኔ ጎሬ ክዕኔን ድከኡኔ ሙልሰኖኔ፤ አዕኑሁ ሂለ ብከ ሙልቴነንተ። ");
INSERT INTO alw_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","ህካን እኮቤቺሃ ኣቶኖተ ላገተ ኣጌንተርቹ ሄጭቴን ቅጥ አቴነንተገ ቃግሶህዕኔተ ይ ከ አመኦሱት ሄጭት ክዕኔቤቹ መርታገ አኡ ሰውዬም፤ ህትን ግዳጂን እሁዕነ ኢታን ኣቴነንታሁ ቅጥ ዬኢሃ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","«ቀው ውጮ መንቹ ቀውንከ ምደኖ፤ ህትን ልግብ ውጮ መንቹ ልግብንከ ምደኖ» ህካን ሰውይዬ። ");
INSERT INTO alw_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","ሙንደአን ኣሰኖሃ ጉዕመንከ መገኑ ኢተኖሃ እኮቤቺሃ ጉዕሙንኩ ቀልቤንከስ ሰውዬገ ኣሱን ቤሉ ሻዘን ህከረንገ ግዲን ኣሱንከ። ");
INSERT INTO alw_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","ጉዕመ ወክት ጉዕመ ጠዋን ገውክዕኔ አታልቴን ጡመ ሆጉተ ጉዕመንከ አኢሃ መገኑ አበ በረከስ ኣሶህዕኔተ አታለኖ። ");
INSERT INTO alw_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","ሁኩንን፦ «ቡጥቻኖተ ህትን በትሽ ኣሴእ፤ ፈይመስ ዘላለሚሃ ሄኣአ» የመም ከተበሞጋት። ");
INSERT INTO alw_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","ዜሬተ ዉጠኖሀኒሃ ዜሬተ ህትን እተኖሀኒሃ እቸተ ኣሰኖ መገኑ ዉጤነንተ ዜሬት በረከስ ኣሰኖህዕኔ፤ ህትን ፈይመክዕኔ ላልቹ በትሰኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","አዕኑ ኣቴንተርቹ ኒ አዲን ቶገኖ መኑ ጉዕሙንኩ መገኑ ገለትጮተ ጉዕመ ወክት ኣቶኖተ ጉዕማንከ አዲን ቀባጣመተ እኬነንተ። ");
INSERT INTO alw_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","ኩ አዕኑ ኣቴነንታሁ አመዕናኖ ኦርሸተ ፉሹ ጠለዕለ እሁዕነ መኑ መገኑ አበ ገለትጨኖገ አአኖ። ");
INSERT INTO alw_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","ኩ አዕኑ ኣቴነንታሁ መሲህ ተሽት ላገተ አመዕንዮም ይቴን አዘዘሙክዕኔ እሳሃለከ ዎሎ መኒሃ አቴነንተረ እሁክዕኔ ለሊሰኖሃ እኮቤቺሃ መኑ መገኑ ገለትጭታአ። ");
INSERT INTO alw_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","እሰን መገኑ ክዕኔሃ ኣሴህዕኔ አበ ኣስቶተኔሃ መገኑ ኡጭታህዕኔ ወክት እልክዕኔ ለኦተ ሱንታህዕኔ። ");
INSERT INTO alw_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","መን ላጋን ጠወኦኖተ አታሌንበ ሽልማትስተኔሃ መገኒሃ ገለቱ ኢሉስ። ");
INSERT INTO alw_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","አን ጳዉሎስ ክዕኔ ብሬን ዮም ወክት ሙላሚሃ የመሞም፤ ጠዉ እኮጎሬ ክዕኔች ቄዕሬም ወክት መለላንቹ የመሞም፤ መሲህ ጎደበ ላፍማንለከ ጡምማን ኡጫንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","ኡጫንክዕኔንኩ አን ክዕኔቤቹ አሜቾም ወክት መለል ጠወኣምገ አቶኖኤበእታት፤ ማል ሰውትገ እንክ ሄዕናምገ አቶእሩ መት መቶ መን ብሬን እኮጎሬ መለል ጠወኦተ ሀሳም። ");
INSERT INTO alw_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","መሰንትስ ነኡ መሃ እኮጎሬ ከን ኣዱንያ አሌን ሄዕኖም ጎሬ ከን ኣዱንያ አል መንገ ኦለማምበአ። ");
INSERT INTO alw_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","ኦለንሽኔ ኦዳት ሻንቀ ድጂሃ አታልሲሰኖ መገን ወልቀት ዮስ ቤሉ ከን ኣዱንያ አል መሳርገ ዮእሃበአ። ክዝብ ኦደተ ድጅናም። ");
INSERT INTO alw_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","ህካን እኮቤቺሃ መን ሰውት መገን ኤንኬዕን አሌን ኬአኖ ቦን ኦደተ ጉዕመንከ ድጅናም፤ ህትን መን ሰውት ጉዕመንከ አንግ መሲህሃ አዘዘመኖገ አዕናም። ");
INSERT INTO alw_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","አዘዘሙክዕኔ ሹልቴንተ ወክት አዘዘንታበእ መነ ገዱተ ፉልኖተ ተቃጠንቦም። ");
INSERT INTO alw_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","አዕኑ ለኤነንታሁ አብልን ለለኖ ጠወዪት፤ ሀኩ መንቹሁ «አን መሲህሃን» ይ አመዕኔኢች ለንኪሃ ሰዉ ዩን፤ ነኡ እስገን መሲህረ እሁኔ ደጉን። ");
INSERT INTO alw_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","ቀርቹ ኣሴኔ ሹምነቴን አበ ድከዕዮም ጎሬ ሙላምበአ፤ ከ ሹምነቱ ቶንጎሚሁ ክዕኔተ ጠረኝንሶህዕኔታቤሉ ድጅኖህዕኔታበአ። ");
INSERT INTO alw_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","አን ክዕኔሃ ከተቦንክዕኔ ደብዳቤን ዋጅሲሳሚሃ አጉዱንከህዕኔ። ");
INSERT INTO alw_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","መሰንትስ መት-መቱ መኑ «ጳዉሎስ ከተቦ ሶህኑት አበ ኬዕምታእረ፤ እኮጎሬ እስ ገውስ ለኤኖረ አበ ላፈሃን፤ ጠወአኖ ጠውንኩ ህንቀሞእሃን» ይታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","ሁኩ መኑንኩ ነኡ ቄዕራሻን ዮም ወክት ደብዳቤተ ከተቦሚሁለከ ግደኖን ክዕኔን ሜጡበ ሄዕዮም ወክት አዕናሚሁ ሜጡ እሁስ ደጉን። ");
INSERT INTO alw_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","ነኡ እኮጎሬ መት መቶ ገውሰ ገለትጭታ መኒን ሜጡበ ገውኔ አመሰልኖተ ህከረንገ ገውኔ ለልንሶተ መለልናምበአ፤ እሰ እኮጎሬሁ ገዉሰ መት-መትንከሰ ለኣ ወክት ገውሰ ገገይንከሰ አመሰለንስት ለኣ ወክት ኤንኬዕኑ ዮሰበእረን። ");
INSERT INTO alw_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","ጠዉ እኮጎሬ ነኡ ክዕኔተ ኢሎተ ኢለ መገኑ ኣሴኔ ሆጎኔ ወጢን ድከዕናም ቤሉ ድከኡ ሀስሰኖኔሀኒች አበ ድከዕናምበአ። ");
INSERT INTO alw_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","አዕኑ ዮንታሁ ክድመኔ ሆጎ ኣዜን እኮቤቺሃ መሲህ እንጂለ ተማርስኖተ አሜንቶም ወክት ኣሰሞኔ ሆጎኔ ወጢች ህንጎምበአ። ");
INSERT INTO alw_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","ዎሉ መኑ ቆንዶዴ ሆጎን ጌሲች አበ ድከኢን የመሞኔ ሆጎኔ ወጢች ህንጋምበአ፤ አመዕነቱክዕኔ ነጰን መሮጌሳን ክዕኔቤቾን መደበንቶኔ ሆጉኔ አልባዕልተን መርታገ ተብሳሃ አዕናም። ");
INSERT INTO alw_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","ቴሁ ከኒች ብርተ ዎሉ መኑ አታ ሆጎቤቾን ኣንግ ቦኑዕነ ክዕኔች ካጵ አዲን ዮ ባዶኒሁ ተሽት ላገተ ተማርስኖተ ተብሳሃ አዕናም። ");
INSERT INTO alw_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","ጠዉ እኮጎሬ «ድከአኖሁ ቀርቾን ድከኡን።» ");
INSERT INTO alw_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","መንቹ ገዉንኩስ ገለትጨሞተ በቀአኖሲሁ ቀርቹ ገለትጨኖስራት ቤሉ ገዉስ ገይንከስ ገለትጨንበአ። ");
INSERT INTO alw_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","አዕኑ ኢ ገውመኤ ቀውንከ አታልቴንታኤ እቃን ጡመሃን እቅ፤ አዕኑ ሀንቅንከ እጀቅቴንታኤ። ");
INSERT INTO alw_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","አንን መገኑ ጡመርቹ ሰውየኖገ ጡመርቹ ሃሸዕዮንኬ፤ መሰንትስ ክዕኔተ ጡመ ሀፍቶገ መቶ ጎኒሃ ሁኩንን መሲህሃ ሆንጠህሶህዕኔተ ጠዕምዮንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","ጠው እኮጎሬ ዎሪቹ ሀዋ ሾክማንተስ ሉሲሾሴገን ህትን ክዕኔ ሰውቱ በዕያን መሲህ ዮህዕኔ ጡመ ሰውቲችለከ ነጢማች ፉልቴን መርቶኖታትንዶ ይ ዋጅዮም። ");
INSERT INTO alw_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","መሰንትስ መቱ መንቹ ክዕኔቤቹ አሜች ነኡ ተማርስኖንክዕኔ ኢሲች ዎሉ ኢሰ ተማርሴጎሬ ህከረንገ ቶጌንተ አያኒች አደ እኮ አያነ ቶጌንተጎሬ ህከረንገ ቶጌንተ እንጂሊች አደ እኮ እንጂለ ቶጌንተጎሬ ጠወስ ጨለ ይቴን ኣእቴነንተ ዩሃን። ");
INSERT INTO alw_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","ጠው እኮጎሬ አን ከን ሎርሎራኖ አሳባች መ ጠዋን ሆፈኣሚሃ አጉጆኤበአ። ");
INSERT INTO alw_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","እኮጎሬ አን ጡመገ ጠወኣም መንቹ እህበጎሬ ኤንኬዕኑ ሆፈአኖኤበአ፤ ህከኒሃ ልግብ ወክት ልግቤ ዎቄን ለሊንስ ኩልኖንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","አን መገን ተሽት ላገተ ደሞዙ ዮበኢሃ ክዕኔሃ ተማርሲሃለከ ህትን ክዕኔንተ ጎት አኢሃ ገውኤ ሙግ አዕዮሚሁ ጩብሃንዶ? ");
INSERT INTO alw_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","ክዕኔተ ካደሞተ ዎሎ አመዕናኖች ሀዕለንሸ ቶጎንከኤ እሰተ ዘረፎም። ");
INSERT INTO alw_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","ክዕኔን ሜጡበ ሄዕዮም ወክት ኦርሸት ኢሊቶኤ ወክት መቅዶኒች አሜቶ አመዕናኑት ሀስሰኖኤርቹ ጉዕመ ጠዊን ሀዕልተን ሄኦቤቺሃ አዬ አሌን እጅነተ እኮምበአ፤ ቴሱ ኢለ ክዕኔ አሌን መ ጠዋን እጅነተ እኮምበአ፤ ከኒች ኤተሮኒ እጅነተ እሃምበአ። ");
INSERT INTO alw_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","መሲህ ሀንቁ ኣዜንከኤ ዮቤቺሃ ከን ጠዋን ቦኑ ከመኖኤሁ አካይ ባዶን አዪሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","ህከን መሰት መርቹሃን? ኢታንክዕኔበእቤቺሃትንዶ? ኢታንክዕኔገ መገኑ ደገኖ። ");
INSERT INTO alw_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","ሁኩ ዎልት አሳበት «ነኡን እሰገ አዕናም» ይተን ቦንታ መሰተ ከሞተ ቴሱ አኣሚሃ ከ ኤተሩሃ አኣም። ");
INSERT INTO alw_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","መሰንትስ ህትኔ መኑ መሲህ አሳበተ አጉዶተ ገዉሰ ዶርታ ክዝበኛኑተ ሶቀማኑተለከ ሉሲስ ሆጉተ አታእራን። ");
INSERT INTO alw_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","ሁኩን አጀብሲሰኖሃ ጠወበአ፤ መሰንትስ ሸይጣኑ ገዉስ ኑር መላይኬቹ አጉዶተ ገዉስ ዶረኖ። ");
INSERT INTO alw_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","ህካን እኮቤቺሃ ሸይጣን ካዲመት ፍይማ ካዲመተ አጉዶተ ገዉሰ ዶርቶጎሬ አጀብሲሰኖበአ፤ ኤተሮን ሆጎሰ ዋገ ደእታአ። ");
INSERT INTO alw_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","«አዪሁ አን ገወ እኮሚሃ አጉዱንከስ» ይ ቴዉ ጠወኣም። ገወ አጉጆንክዕኔጎሬሁ ቀቅቹ ቦኖተ ገወ መንችገ አቴን ዎለዕዬኤ። ");
INSERT INTO alw_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","ህትን አመዕን ቦኒን ጠወኣሚሁ ቀርች ሰውትገ እሁዕነ ገወ መንቹ እክት። ");
INSERT INTO alw_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","ልግቡ መኑ ከን ኣዱንያ አል ጠዋን ቦንታቤቺሃ አኒሁ ቦናም። ");
INSERT INTO alw_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","መሰንትስ አዕኑ ኤንኬዕናመተ እኬንተቤቺሃ ገዋኑተ ሙንዲኖን አታዕልቴነንተሳት። ");
INSERT INTO alw_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","ህትን አዪሁ ሮስገ ጠቄህዕኔጎሬ ህከረንገ ዘረፎህዕኔጎሬ ህከረንገ ደግለሸቀሞህዕኔጎሬ ህከረንገ ህንቆህዕጎሬ ህከረንገ መጫለክዕኔ ዎቀሮጎሬ አታዕልቴነንተ። ");
INSERT INTO alw_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","እኮጎሬ ነኡ ህከኒሃ አበ ላፋኑተ እሁኔ ሙለን ጠወኣም፤ ጠዉ እኮጎሬ አዪሁ ቦኖተ መለሎጎሬ አኒሁ እስገን መለል ቦናም፤ ካን ያሚሁ ገወ መንችገ እክት። ");
INSERT INTO alw_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","እሰ እብራዌየ መነንዶ? አንን እብራውቹሃን፤ ህትን እሰ እስራኤልየ መነንዶ? አን እስራኤላውቹሃን፤ እሰ እብራሂምተ ዘርንዶ? አን እብራሂምተ ዘር። ");
INSERT INTO alw_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","እሰ መሲህተ ካዲመንዶ? አን እሳች ባሽ መሲህየ ካዲንቹ፤ ካን የን በርገጋሽጋት ጠወኣሚሁ፤ እሳች በትሽ ልግብ ወክት ሆጎን ቆንዶድዮም፤ እሳች በትሽ ልግብ ወክት ኡሱራሞም፤ በትሽ ልግብ ወክት ገረፈሞም፤ ልግብ ወክት ሬሆተ ኢልዮም፤ ");
INSERT INTO alw_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","አይሁዱ ኦንቱ ወክት ሰጅኔ ሆንሶረ ጅራፊን ገረፎኤ። ");
INSERT INTO alw_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","ህትን ሰሱ ወክት በርቲን ዎቀራሞም፤ መቱ ወክት ክኒን ቀሰሞም፤ ሰሱ ወክት መርከቡኤ ባር አሌን ቢጠሞኡ፤ ህትን መት ሀንከዕርተለከ በራሃ በሃር አሌን ዱንክዮም፤ ");
INSERT INTO alw_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","አን ልግብ ወክት ዎቄ አሌን ሄአን ድርሲን፥ ሽፍጢን፥ አይሁዲን፥ አይሁድ እህበ መኒን፥ ከተማንለከ ኡለ ኡድማን፥ በሃር አሌን ምዕረት እልቶኤ፤ ህትን ክዝብ አመዕናኖን ምዕርተዕዮም። ");
INSERT INTO alw_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","ህትን ልግቤ ሆጎን ሆጎም እቅ፤ ልግብ ወክት ግሰኛተ ሆጊንለከ ጎሪን፥ ሰገቤንለከ እቸተ ሆግ ኦርጨቀሞም፤ ህትን ቂዚንለከ ኦድኑተ ሆጊን ኦርጨቀሞም። ");
INSERT INTO alw_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","ህካን ጉዕመንከ ጠወ ዎለኡዕነ በሬን በሬን ጨነቀማሚሁ አመዕናኖ ጭሚቲሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","መቱ መንቹ ሆገኖ ወክት አን እሲን ሜጡበ ሆጋምሃበእንዶ? መቱ መንቹ ጩብ አዕዮ ጎሬ አን ኡሙዕራምሃበእንዶ? ");
INSERT INTO alw_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","ድከኡ ሀስሾኤጎሬ አን ድከኣሚሁ ላፈ እሁኤ ለሊሰኖ ጠውኒት። ");
INSERT INTO alw_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","ዘለለሚሃ ማሰአሞ ቀርቾሃ ኢስ አኑ መገኑ ክዝባምበእገ ደገኖ። ");
INSERT INTO alw_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","አን ደማስቆ ከተማን ሄዕዮም ወክት ዎመ አርስጦሴች ዎሮን ሄዕዮ ገሻንቹ አፎኤተ ሀሽ ደማስቆ ከተም ኡራከተ አገርሲሾ እቅ። ");
INSERT INTO alw_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","ጠዉ እኮጎሬ ኤሳሃ ቀርጫታን ዎሬን ከተምስ ኦታን ሄዕዮ መስኮቲን ድሪሴናን ህከን መንች አንጋች ፉሸኤም። ");
INSERT INTO alw_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","ቦኑ ደግለለኖሃ እህበጎሬ ቦኑ ሀስሾ ጎሬ ቀርቾሃ ኢሲች ኣሰሞኤ መናማንለከ መገኑ ለልሾኤ ጠዋን ቦናም። ");
INSERT INTO alw_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","መሲህሃ እኮ መቱ መንቹ ደጋም፤ ኩ መንቹ ቶነ ሾሎ ዘመኒች ብርተ ሰቅ ሰማሃ ኢለ መሰሞ፤ መሰሞንኩ ማልንከስ እሁን እሁ ሆጉን ደጋንበአ፤ መገኑ ደገኖ። ");
INSERT INTO alw_vpl VALUES ("C212_3","077_12_3","2CO","12","3","3","ጠው እኮጎሬ መንቹ መገን ጄነት መሩስ ደጋም፤ ጠው እኮጎሬ ማልንከስ እሁን እሁ ሆጉን ደጋምበአ፤ መገኑ ደገኖ፤ ");
INSERT INTO alw_vpl VALUES ("C212_4","077_12_4","2CO","12","4","4","እስን ህከኔ ኩሎኖተ አታሌንበለከ መኑ ጠወኦተ አታልቡርቹ ሞጮጬእ። ");
INSERT INTO alw_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","አኒሁ ህትኔ መኒን ድከኣም፤ ገዪኤተኔሃ እኮጎሬ ሆንጌእ ቤሉ ድከኣም ጠው ዮኤበአ። ");
INSERT INTO alw_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","ህከኒሃ አን ሀንቅ ጠወኣምቤቺሃ ድከዕዮሚች ገወ እሃምበአ፤ ጠው እኮጎሬ አዪሁ ኢ አሌን ለአኖርቹሃ ኢች ሞጮጨኖሀኒች ኤሰሃ ሎረ አት ለኣበእገ ይ ድከኢች አገዕራም። ");
INSERT INTO alw_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","ከ ኑር እክ ለሌኤ አበ ጠዊች ኬዕዮሀንን ቦናምበእገ ማለኤ ኡትገ ቀሳኤ ኦርሸት ኣሰንቶኤ፤ ህት ኦርሸት ሶቀማንቹ ሽይጣንገ እሀን ኦርጨመን ቦናምበእገ አአኖኤ። ");
INSERT INTO alw_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","ሁኩ ኦርሰኖኤርቹ ኢ አሊች ሽቆተ ቀርቹኤ ሰሱ ወክት ኡጬም። ");
INSERT INTO alw_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","ጠው እኮጎሬ እስ «ኢ ወልቀት ሎረ እክ ለልታኢሁ ኪ ሆንጌን እኮቤቺሃ ኣስቱኤ እካሄ» ዬኤ፤ ህካን እኮቤቺሃ መሲህ ወልቀት ኢ አሌን እኮተ መ ወክቲቺ በትሽ ሆንጌንተኤ ተሽ የዕኔ ድከኦስተ ኢታም። ");
INSERT INTO alw_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","ወልቀተ ደኣሚሁ ሆጎም ወክት እኮቤቺሃ መሲህተኔሃ ቦሮረሙኤ፥ ኦርጨቀሙኤለከ ሆቸሙኤ ተሽ የኖኤ። ");
INSERT INTO alw_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","አን ገወ መንችገ ጠወዕዮም፤ እኮጎሬ ገወ እሃምገ አቴንተኤሁ አዕኖንት፤ አዕኑ እተኔሃ ጡመ ጠወ ጠወኡ ገበአኖህዕኔሁ አዕኖት እቅ፤ መሰንትስ አን መ ቀዉ መንቹሃ እኮም እቃ ህከን ሎርሎራኖ አሳባች መቶርቾን ሆፈኣምበአ። ");
INSERT INTO alw_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","አን ሀንቅ አሳቤቹ እሁኤ ለሊሰኖ ጠዉ አን በላንከክዕኔ ሄአን አደቢን አዕዮምተ ሆጉ፤ ህት መላንት አጅበተለከ ገረምሲሳእታን። ");
INSERT INTO alw_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","አን ክዕኔተ ብረ ጠዕሙ ሆግንከኤ አሌንከክዕኔ እጅነተ እሁዕነ ፈቆም ቤሉ ዎሎ አመዕናኖ ዱእ ምኒች ሆፍሾንክዕኔሁ ማኒት? ሁኩን ቤሱ እኮጎር ማሬእ። ");
INSERT INTO alw_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","አን ክዕኔበ አሜቲሀእ ሰቅያ ወክት፤ አን ክዕኔተ ገዉክዕኔት ቤሉ ክዕኔርቹ ሀሳምበእቤቺሃ ክዕኔ አሌን እጅነተ እሆተ ሀሳምበአ፤ ቴሁ አናኑት ኦሶተሰ ብረ ጭምአት አፉሹ ሀስሰኖሰ ቤሉ ኦሱት አናኖተ ብረ ጭም አታበአ። ");
INSERT INTO alw_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","አን ክዕኔተኔሃ ብሩኤ ፈቅያን ፎልኤ ህግሽ ኣስዮም እቃ አበ ሙንደኣም፤ ህከረ አን ኬንከ በትሽ ኢታንክዕኔሃ እኮች አዕኑ ኤሳሃ ኢቱ ሀስሰኖህዕኔሁ ቀዉሃትንዶ? ");
INSERT INTO alw_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","እሁን ቤሉ አን ክዕኔ አሌን እጅነተ እኮምበአ፤ ጠዉ እኮጎሬ አዕኑ ይቴንተገን ጣንስ ተንኮን አፎንክዕኔሃ አጉደኖ። ");
INSERT INTO alw_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","ክዕኔቤቹ ሶኮም መኒች መትስ አዲኒ እኮዕቃ ክዕኔች ጣንስ ኣእዮክዕኔዶ? ");
INSERT INTO alw_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","ቲቱ ክዕኔ አደ መሮተ ኡጭዮንስ፤ ኒ አመ ቤቱንከ እሲን ሜጡበ ሶኮም፤ ቲቱ ጣንስ አእዮህእኔዶ? አንለከ እስ አዕኖሚሁ መቶ ቀልብንበእንዶ? ህትን ለምኔ ቀልቡንኩ መቱሃበእንዶ? ");
INSERT INTO alw_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","አዕኑ ቴሱ ኢለ ነኡ ክዕኔ መዴን ገዉኔ ከዕመቀማሚሃ አቴን ሰውይቴነንታት? ነኡ መሲህን እንክ ጠወዕናሚሁ መገን ብሬኒት፤ ኒ ጃላ! ጠወዕናሚሃ ጉዕመንከ ጠወዕኖሚሁ ክዕኔተ ጠረኝንሳም ይኒት። ");
INSERT INTO alw_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","አን ክዕኔቤቹ አሜታም ወክት አይደጎ እኮኖተ ሀሳምገ እኮኑዕናን አኒሁ አዕኑ እሆተ ሀሴነንተገ እሁዕናን ደቀሞምጎር ይ ዋጃም፤ ህትን ክዕኔ በላን ብተት፥ አቄሸት፥ አሙዕርት፥ ገጉ ኢቱ፥ መን ሱዕመ ቤሱ፥ ሄምት፥ ቦኑ፥ ጨንጨነት ሄኣ ይ ዋጃም። ");
INSERT INTO alw_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","ህትን አን ለንኪሃ ክዕኔበ አሜቾም ወክት ኢ መገኑ ክዕኔ መዴን ሙልሰኖኤ ጎሬ ይ ዋጃም፤ ህትን ከኒች ብርተ ጩብ አት ህከን አቶ ሂለ ንጃሲን፥ ዝነተ አእተኔሃ፥ ህትን አለ ቅልቢን ቶበቱ ሆጎ መን ሻዞ አሌን ኡባም ይ አበ ዋጃም። ");
INSERT INTO alw_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","አን ክዕኔበ አሜቶተ ኩን ሰቅያ ወክት፤ ጠዉ ጉዕሙንኩ ኡረኖሁ ለሞ ህከረንገ ሰሶ ምስክር ላጋኒት። ");
INSERT INTO alw_vpl VALUES ("C213_2","077_13_2","2CO","13","2","2","ለንክ ወክት ክዕኔቤቹ ለኦህዕኔተ መሮም ወክት ጠረኝሽ ጠወዕዮም እቅ፤ ቴሁ ህትን ቄዕራሻን እክ ከኒች ብርተ ጩብ አቶሀኑኡተለከ ወሊሃሰ ጠረኝሽ ጠወኣም፤ ቴሱ ክዕኔቤቹ ፈንቀል አሜታም ወክት ሜጢሃ አሙዛምበአ፤ ");
INSERT INTO alw_vpl VALUES ("C213_3","077_13_3","2CO","13","3","3","አዕኑ ኢን ሄዕይ ጠወአኖሁ መሲህ እሁሰ አጥራመቶኖተ ሀሴነንታት፤ ክዕኔቤቾን ለለኖንኩ እስተ ወልቀ ቤሉ ሆንጌተስበአ። ");
INSERT INTO alw_vpl VALUES ("C213_4","077_13_4","2CO","13","4","4","መሰንትስ እስ ሰቀለም ሬዮሁ ሆንጌን እኮጎሬሁ ቴሱ መገን ወልቃን ፎሊን ሄአኖ፤ ህትን ነኡ እሲን ሜጡበ ላፋኑተ እንኮም፤ እኮጎሬ ነኡ ክዕኔሃ ዮኔ ደቀሺን እኮጎሬ እሲን መገን ወልቃን ሜጡበ ሄዕናም። ");
INSERT INTO alw_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","አመዕነትንከክዕኔ ሄኡክዕኔ ደጊሃ ገዉክዕኔ አጥራመቴን ለዕዬ፤ ህትን ገዉክዕኔ ፌተኜ፤ መሲህ ኢስ ኣዜንከክዕኔ ሄኡስ አጥራመቴንታበእንዶ? ህካን እህባች ሀንቅንከ ፌተናን ኡቤንታ ዩሃን። ");
INSERT INTO alw_vpl VALUES ("C213_6","077_13_6","2CO","13","6","6","ነኡ ፌተናን ኡቡ ሆጉኔ ደጌነንተገ ተብሳሃ አዕናም። ");
INSERT INTO alw_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","አዕኑ ሂለርቹ አቴነንተበእገ መገን ቤቹ ዱአ አዕናም፤ እስን ነኡ መቱርቹሃ ፌተናተ በቀንዕበረ እንኮም ጎሬ አዕኑ ጉዕመንከ ወክት ጡመ ጠወ አቶኖታት ቤሉ ነኡ ፌተናንተስ ህንጋም ጠረኛኑተ እሁኔ ለሊንሶታበአ። ");
INSERT INTO alw_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","መሰንትስ ነኡ ሀንቅ ቤሉ ሀንቅ አሌን መቱርቹሃ አዕኖተ አታልናምበአ። ");
INSERT INTO alw_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","ነኡ ላፋኑተ እንካን አዕኑ ጠረኛኑተ እኬንተ ወክት አበ ሙንደዕናም፤ ኒ ዱኡ አዕኑ አመዕነቲንከክዕኔ ጠረኛኑተ እኮኖታት። ");
INSERT INTO alw_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","አን ከ ሶህኑተ ክዕኔች ቄዕር ዮም ወክት ከተቦንክዕኔሁ ክዕኔቤቹ አሜቾም ወክት ቀርቹንኩ ኣሴኤ ሹሚነቲን ጨነቃንክዕኔበእጋት፤ መሰንትስ ቀርቹ ኣሴኤ ሹምነት ወልቀት ክዕኔተ ጠረኝሲሃት ቤሉ ሆግሲሃበአ። ");
INSERT INTO alw_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","በትሽን አመኤ ኦሶ! ወገሬቲን ሄዕዬ፤ አመዕነቲንከክዕኔ ሆፈአኖህዕኔርቹ ዮህዕኔበእረ እኬ፤ ሸዘነእ አጥራመቼ፤ ገገይንከክዕኔ ኢተቀሜ፤ ወገሬቲን ሄዕዬ፤ ኢተለከ ወገሬት መገኑ ክዕኔን ሜጡበ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("C213_12","077_13_12","2CO","13","12","12","አመዕናኖተ ሀስሰኖ ሱንቃቀንሺን ሱንቃቀሜ። ");
INSERT INTO alw_vpl VALUES ("C213_13","077_13_13","2CO","13","13","13","አመዕናኑት ጉዕሙንኩ «ወገሬት ዮንተንዶ?» ይቶህዕኔ። ");
INSERT INTO alw_vpl VALUES ("C213_14","077_13_14","2CO","13","14","14","ቀርቾ መሲህ ኢስ ኣስቱቲ፥ መገን ኢተቲ፥ ጠሊለ አያን ሜጡ እሁ ጉዕሚንከክዕኔ እሁን። ");
INSERT INTO alw_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","2","አን አሳቤቹ ጳዉሎስለከ ኢን ሜጡበ ዮ አመዕናኑተ ጉዕመንከ አመኦሱት ገለትይ ባዶን ዮ አመዕናኑተ ሶንኮምሃን፤ አን አሳቤቹ እኮም መኒች ህከረንገ መን አዲን እሁዕነ መሲህ ኢሲንለከ ኢሰ ሬሆች ኬሾ አነ መገኒንት። ");
INSERT INTO alw_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","አናኔ መገን አዲችለከ ቀርቾ መሲህ ኢሲች ኣስቱትለከ ወገሬቱሁ ክዕኔሃ እሁን። ");
INSERT INTO alw_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","ኢስን ከን ሂለ ዘማኒች ፌሶኔተ አናኔ መገን ሰውቲን ጩብሀኔ ገዉስ ህግሽ ኣሴእ። ");
INSERT INTO alw_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","ዘላለሚሃ መገኒሃ ኬዕምኙ እሁንስ! ኣሚዕን። ");
INSERT INTO alw_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","መሲህ ኣስቶን ገኤህዕኔ መገን አዲች ደዕልቴን አደ እኬን ዎሎ ተሽት ላገቤቹ ፈንቀሉክዕኔ አጀብሲሰኖኤ። ");
INSERT INTO alw_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","ህካን ያሚሁ ጉረተ ኣግሶተለከ መሲህ እንጂል ላገተ ሾክሶተ ሀሳ መት-መቱ መኑ ዮቤቺሃት ቤሉ ዎሉ እንጂል ላገት ዮቤቺሃበአ። ");
INSERT INTO alw_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","ጠዉ እኮጎሬ ዎዕነ ዱዱብስኖንክዕኔ እንጂል ላጋን ቶቀምባሃ ዎሉ ነኡ እንኮምዕቃ ሰሜ መላይከት እኮ እቃ ዱዱብስቶህዕኔጎሬ ቦሮረንቶኢሃ እኩን። ");
INSERT INTO alw_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","ወዕናሃ ይኖንክዕኔገ አኒሁ ቴሁ ያንክዕኔ፤ አዪሁ አዕኑ ቶጌንተ እንጂል ላጋ ቤሉ ዎሉ ቶቀምባ እንጂል ላገተ ዱዱብሴህዕኔጎሬ ቦሮረሞኢሃ እሁን። ");
INSERT INTO alw_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","ህከረ አን ሀሳሚሁ መኑ ገለትጮኤታትንዶ? ህከረንገ መገኑ ገለትጮኤታት? ህከረንገ አን መነ ሙንዲሲሶተ ሀሳሚት? ቴሶ ኢለ መነ ሙንዲሲሶተ ሀሾም እቃን መሲህ ካዲንቹ እሆተ አታላምበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","አመኤ ኦሶ! አን ዱዱብሴንክዕኔ እንጂል ላገት መኒች እሁ ሆጉሴ ደጎኖተ ሀሳም። ");
INSERT INTO alw_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","መሰንትስ ህካን ኤሳሃ ደግስሾኤሁ መሲህ ኢሳት ቤሉ አን ቶጎሚሁ መኒችበአ፤ ህከረንገ መኑ ተማርስዮኤበአ። ");
INSERT INTO alw_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","ወዕና አይሁድ አመዕነቶን ዮም ወክት ሀት ዮም ጎሬ ሞጮጭቴንታአ፤ አመዕናኑተ ሸረን ቤሶተ አጰማሚት እቅ። ");
INSERT INTO alw_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","አይሁድ አመዕነቱ አገሪን ዘሬኤ በሊች ኢ ደረቦች ጉዕሚችን በተኣምየ እቅ፤ ህትን አናከኤ ሴረ በአኖበእገ ጠረኝሽ ሀሳም እቅ። ");
INSERT INTO alw_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","ጠዉ እኮጎሬ እለሙዕነ ሄጭ መገኑ መጠሮኤ፤ ኣስቶንከስ ገኤኤ። ");
INSERT INTO alw_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","አይሁደ እህበ መኒሃ ቤትስተኔሃ ተሽት ላገተ ዱዱብሶተ መገኑ ቤቱስ ለሊሶኤተ ኢቴ ወክት አን አዬኒ አማዕለሞምበአ። ");
INSERT INTO alw_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","ህትን ኢች ብርተ አሳበተ እኮሀኑኡቤቹ ደቀሞተ ዬሩሳሌም ከተመ መሮምበአ፤ ጠዉ እኮጎሬ ሄጭ አረብ ባዱ መሮም፤ ህከኒች ኤተሮን ደማስቆ ከተመ ፈንቀሎም። ");
INSERT INTO alw_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","ሰሶ ዘማኒች ኤተሮን ኬፋ ዬኖ ጴጥሮሴ ለኦተ ዬሩሳሌመ ኦሮዕይ እሲን ሜጡበ ቶነ ኦንቱ በር ዱንኬም። ");
INSERT INTO alw_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","ጠዉ እኮጎሬ ቀርቾ ኢስ አመቤቲ ያቁብ ቤሉ አሳባች ዎሉ መቱሃ ለዕዮምበአ። ");
INSERT INTO alw_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","ኩ ከተቦንክዕኔሁ ክዝብ እሁ ሆጉስ መገን ብሬን ተሬገጭ ኩላንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","ህከኒች ኤተሮን ሶርይለከ ክልቅይ ባዱ ኦሮዕዮም። ");
INSERT INTO alw_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","ይሁድ ባዶን ዮ አመዕናኑት ሚንተ ሚኔን ለአቀንት ከሰበአ። ");
INSERT INTO alw_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","ጠዉ እኮጎሬ እሰ «ወዕና ኔሳሃ ኦርሰኖኔ መንቹ ወዕና ቤሶተ አጰመን ሄዕዮ አመዕነቱ ገዉንኩስ ዱዱብሰኖት» ዬኖሃ ሞጮጭቶ እቅ። ");
INSERT INTO alw_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","ኢ መሳን መገኑ ገለትጭታኢት እቅ። ");
INSERT INTO alw_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","ቶነ ሾሎ ዘማኒች ኤተሮን በርናባሴን ሜጡበ ዬሩሳሌመ ፈንቀል ኦሮዕዮም፤ ቲቶ ኢን ሜጡበ አእ መሮም እቅ። ");
INSERT INTO alw_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","ህከ ቤቹ መሮሚንኩ መገኑ ለልሾኤ አዲንት፤ አን ከኒች ብርተ አዕዮም ሆጉትለከ ቴሁ አኣሚሁ ህትን ተሰ እሀኖበእገ ይ አይሁደ እህበ መን በላን ዱዱብሴም እንጂል ላገተ ሎርሎረ አዎንሳኖተ አደ አዕይ ኩሎንሰ። ");
INSERT INTO alw_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","ኢን ሜጡበ ሄዕዮ ቲቱ ግሪክ ባድ መንቹ እኮጎሬሁ ጡርከመሞተ ግድሴማስበአ። ");
INSERT INTO alw_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","ጠዉ እኮጎሬ በላንከኔ ሉኩት ማጠንት ኣጎ መት-መቱ ክዝብ አመዕናኑት ቲቱ ጡርከመሞተ ሀሶ እቅ፤ ሁኩ መናከት ዳንድቶተ ኣዝኔ ማጠንት ኣጎኢሁ መሲህ ኢሲን ደዕኖም ሰዎልድመተ ወልቅስ ሮሶማን ፈንቀሽቶተ ሰውይቲት። ");
INSERT INTO alw_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","እኮጎሬ ነኡ ተሽት ላገ ሀንቅ ክዕኔቤቾን ጠረኝት ሄኦተ ቀዎ ጌሲሃ ህከኑኡሃ ቄለሞምበአ። ");
INSERT INTO alw_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","መገኑ መን ሚንተ ለዕይ ሀዕለኖበእቤቺሃ ሁኩ አዎንሳኑተ እኮእሩ መ መነሃ እኮጎሬ ኤሳሃ ግዱ ዮኤበአ፤ እሰ አን ዱዱብሴም ተሽት ላገ አሌን መቱ ሃዕሮርቹሃ በርግቶበአ። ");
INSERT INTO alw_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","ጠዉ እኮጎሬ ህከን ወጥ ጴጥሮስ ተሽት ላገተ አይሁዲሃ ዱዱብሶተ ኤገት ኣሰሞስ ሃሌን ኤሳሃ አይሁደ እህበ መኒሃ ተሽት ላገተ ዱዱብሶተ ኤገት ኣሰንቶኤገ አጥራመቶኡ። ");
INSERT INTO alw_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","መሰንትስ ጴጥሮሴ አይሁድ መኒሃ አሳቤቹ አዕዮ መገኑ ኤሳሁ አይሁደ እህበ መኒሃ አሳቤቹ አዕዮኤ። ");
INSERT INTO alw_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","ቱቅገ እክ ለልታ አሳበት ያቁብ፥ ጴጥሮስለከ ያህይ መገኑ አዕዮኤ ኣስቱተ ደጎ ወክት ነኡ አይሁደ እኮበእ መንቤቹ መርኖተ እሰ አይሁዲቤቹ መርቶተ አማዕለንት ኤሳለከ በርናባሴ ሜጡበ እህኔ መላተ እሆተ መኬ አንጋን ዚያርቶኔ። ");
INSERT INTO alw_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","መቱ ጠወ አዕኖተ ሀስ ጠረኝሶኔ ጠዉ በለሰ ዮ ቡጥቻኑተ ሰውይኖተ ኤገተ ኣቶኔ፤ ሁኩንን አን አኦተ ኢትዮምየ ጠወ። ");
INSERT INTO alw_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","ጴጥሮስ ሶርያን ዮ አንጾክ ከተመ አሜቾ ወክት ቤሾቤቺሃ ብሬስ አቶንቲሁ ሀንቅያበአ ይዮንስ። ");
INSERT INTO alw_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","ያቁብ ሶኮሰ መት-መቱ መኑ አንጾክ ከተመ አሜቶተ ብርተ አይሁደ እህበ መኒን ሜጡበ እተኖት እቅ፤ እሰ አሜቶች ኤተሮን «አይሁደ እህቡ መን አዲች አመዕንቶእሩ ጡርከመሙ ሀስሰኖሰ» ይታ አይሁድ አመዕናኑተ ዋጅት ኤተሩ ዋልት አይሁደ እህበ መኒች አደ እኮ። ");
INSERT INTO alw_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","አይሁድ አዲች እኮ አመዕናኑት ጴጥሮሴ ሉሰተ አዎንቶኡ፤ ሁኩን ዎሉ ፈቃን በርናባሴሃ ጣንስዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","ጠዉ እኮጎሬ እሰገ ተሽት ላገ ሀንቂን ሄኡ ሆጉሰ ለዕዮም ወክት ጉዕማንከ መን ብሬን ጴጥሮሴ «አት አይሁዳውቹ እከን አይሁድ ሴሪን እሁዕነ አይሁደ እህበ መን ሴሪን ሄኣንቲት፤ ህከረ አይሁደ እህቡ መኑ አይሁድ ሴሪን ሄኦተ ሀት ግዳጅሳንትሳት?» ይዮንስ። ");
INSERT INTO alw_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","ነኡ እለንሹኔ አይሁዳ ቤሉ ጩበኛ አይሁደ እህቡሃ መነበአ። ");
INSERT INTO alw_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","ጠዉ እኮጎሬ መኑ ፈየ እሀኖሁ መሲህ ኢሳን አመዕኒንት ቤሉ ሕገ አገሪን እሁ ሆጉስ ደንጋም፤ ነኡ ሕገ አገሪን እሁዕነ መሲሁ አመዕኒን ፈየ እንኮተ መሲህ ኢሳን አመዕንኖም፤ አዪሁ ተዉራት ሕገ አገሪን ፈየ እሀኖበአ። ");
INSERT INTO alw_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","መሲሂን አመዕኒን ፈየ እንኮተ ሀሱኔ ነኡ ገዉንኩኔ ጩበኛኑተ እሁኔ ለሊሰኖ፤ ህከረ ጩብ አዕኖተ አአኖኔሁ መሲሁት ዩሃንዶ? ሆሮን ህትጎተበአ። ");
INSERT INTO alw_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","አን ገዉንኩኤ ድጄም ሕገ ፈንቀሽ መክሳሚሃ እኮምጎሬ አን ገውንኩኤ ሕገ አገርባሃ እሁኤ ተሬገጥሲሳሚት ዩሃን። ");
INSERT INTO alw_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","አን መሲህን ሜጡበ ሰቀለሞምገ ዎለአሞምቤቺሃ መገኒሃ ሄኦተ ይ ሕግ ሬሆን መለዕለም ጌሰ ሕጊች አደ እኮም። ");
INSERT INTO alw_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","ከኒች ኤተሮን መሲሁ ኢ ኣዜን ሄአኖ ቤሉ አን ገዪሀኤ ሄኣምያበአ፤ ቴሁ ጅስሚን ሄኣሚሁ ኢቴኤለከ ኢተኔሃ ገዉስ ህግሽ ኣሴ መገን ቤቶን አመዕኒን ደገመኖ ሄእኒት። ");
INSERT INTO alw_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","ህካን እኮቤቺሃ መገን ኣስቱተ ተሰ ቤሳምበአ፤ መኑ ፈየ እሀኖሁ ሕገ አገሪን እኮች መሲሁ ከልበንከ ሬዮኡ ዩሃን። ");
INSERT INTO alw_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","አዕኑ ኩ ገዋኑት ገለትይ ባድ መኑ! አዬት ሲረ አዕይ ሉስሾህዕኔሁ? መሲህ ኢስ መስቀል አሌን ሰቀለም ብሬንከክዕኔ ዮሀንገ ኩለሞህዕኔ እቅ። ");
INSERT INTO alw_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","ክዕኔች ደጎተ ሀሳሚሁ ጠለዕል መቱ ጠወዪት፤ ጠሊለ አያነ ቶጌንታሁ ሕገ አገርኒትንዶ ህከረንገ ተሽት ላገተ ሞጮጭቴን አመዕንኒት? ");
INSERT INTO alw_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","አዕኑ መገን አያኒን ጀመርቴን ቴሱ ገይክዕኔ ዎልቃን ሹልቶኖተ ሀሴነንታት፤ አደ ኬንከ ኢለ ገዋኖተ! ");
INSERT INTO alw_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","እንጂል መሳን ቶጌንተ ኦርሸት ጉዕሙንኩ ተሰ እክ ፈቆ ዩሃን? ህካን አቴንተጎሬ ሀንቅንከ ተሰ እክ ፈቆኡ። ");
INSERT INTO alw_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","መገኑ ጠሊለ አያነ ኣሰኖህዕኔሁለከ በላንከክዕኔ አጀብሲሰኖ ጠወ አአኖሁ ሕገ አገርቴንተቤቺሃትንዶ? ህከረንገ ተሽት ላገተ ሞጮጭቴን አመዕንቴንተቤቺሃት? ");
INSERT INTO alw_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","«እብራሂም መገኖን አመዕኔእ፤ ህከ አመዕነትስ መሳን መገኑ ፈየ አዕይ ዎለዕዮስ» የመም ከተበሞጋት። ");
INSERT INTO alw_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","ህካን እኮች አመዕንታእሩ እብራሂም እለተ እሁሰ ደጌ። ");
INSERT INTO alw_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","መገኑ አይሁደ እኮበእ መነ አመዕነቲን ፈያኑተ አአኖገ ጠሊሉ መጻፉ ወዕናንከ «ኡመቱ ጉዕሙንኩ ኪን ማሰአመኖ» ይ ሄጭ እብራሂሚሃ ተሽት ላገተ ኩሎስ። ");
INSERT INTO alw_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","ህካን እኮቤቺሃ አመዕንታሩ ጉዕሙንኩ አመዕኔ እብራሂሚን ማሰአንቶእራን። ");
INSERT INTO alw_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","«ሙስ ሕግ መጻፋን ከተበሞ ትዛዝ ጉዕመንከ ጠረኝ አገርባሁለከ ሄእባሁ ጉዕሙንኩ ቦሮረሞእሃን» የመም ከተበሞቤቺሃ «ሕገ አገሪን ፈያኑተ እንካም» ይታእሩ ጉዕሙንኩ ቦሮረንቶእራን። ");
INSERT INTO alw_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","«ፈዩ መንቹ አመዕነቲን ሄኡ ደአኖ» የመም ከተበሞቤቺሃ አዪሁ ሕገ አገሪን መገን ብሬን ፈየ እሀኖበኢሃ እሁስ ለልዮእሃን። ");
INSERT INTO alw_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","ሕጉ አመዕነት አሌን ኡርዮእሃበአ፤ መሰንትስ «መንቹ ሕጋን ሄኦተ አታለኖሁ ሕግ ትዛዝ ጉዕመንከ አገረኖራት» የመም ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","«ሀቅ አሌን ሰቀለም ሬሀኖሁ ጉዕሙንኩ ቦሮረሞእሃን» የመም ከተበሞቤቺሃ መሲህ ኒተኔሃ ቦሮረሞ መንቹ እክ ሕጊን አሜተኖ ቦሮሪች ዎዦኔ። ");
INSERT INTO alw_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","ሁኩን እኮሁ መገኑ እብራሂሚሃ ኣሴ በረከተ መሲህ ኢስ አዲን አይሁደ እህቡ መኒሃ ኢሎተለከ ነኡን መገኑ ኣሳንክዕኔ ዬ ጠሊለ አያነ አመዕነቲን ቶንጎታት። ");
INSERT INTO alw_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","አመኤ ኦሶ! ህንዴ ከ ጠወ መንቤቾን ሮሰሞ ጠዊን ሜጡበ ለዕዬ፤ መቱ መንቹ ኣጎ ወኣድ ላገተ ቶጌማች ኤተሮን አዪሁ ቤሶተ ህከረንገ በርጎተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","መገኑ እብራሂሚሃለከ እስ ዘሬተ ልግብ ተብሴ ላገተ ኣሴኢሁ ከን ሃሊንት፤ ተብሴ ላገት ልግብ እኮገ አዕይ «ዘሬተክዕኔ» የኖበአ፤ ጠዉ እኮጎሬ መቲሃ እኮገ አዕይ «ዘሬተክ» የኖ፤ ሁኩን «ዘርክ» የመሞሁ መሲህት። ");
INSERT INTO alw_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","አን ያሚሁ ከኒት፤ ተብሶሁ እብራሂሚሃ ኣሰሞች ሾል ጥብተ ሰጆ ዘመኒች ኤተሮን ኣሰሞ ሕጉ ዎዕናሃ መገኑ ተሬገጭ ኣሴ ወኣድ ላገተ ሻር ተብሴ ላገተ ቤሶተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","መቱርቹ ረገኤኖሁ ሕግ መሳን እኮ እቃ ተብሴ ላጋን እሁስ ፈቀኖ እቅ፤ ጠዉ እኮጎሬ መገኑ ረግተ እብራሂሚሃ ኣሴኢሁ ተብሴ ላጋኒት። ");
INSERT INTO alw_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","ህከረ ሕጉ ኣሰሞሁ ሚሃት? ሕጉ በርገሞሁ እብራሂሚሃ ተብሴን ኣሰሞ መት ዘርት አሜቶተ ኢለ ኒ ጩቢች ኬዕይት፤ ሴሩንኩ መላይከ አዲን መንለከ መገን በላን ሄዕዮ መንቺሃ ኣሰሞ። ");
INSERT INTO alw_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","እሁን ቤሉ በላን እክ ሀራርሰኖ መንቹ ለሞ አዲንካት ቤሉ ጠለዕል መቶ አዲሃበአ፤ እኮጎሬ መገኑ ሜጥቹሃን። ");
INSERT INTO alw_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","ህከረ ሕጉ መገን ተብሴ ላገተ ግበኖንዶ? ሆሮ ግበኖበአ! ሄኡ ደገመኖ ሕጉ ኣሰሞ እቃኔተ ፈየ እሁ ሕግ አዲን ደገመኖ እቅ። ");
INSERT INTO alw_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","ጠዉ እኮጎሬ መሲህ ኢስን አመዕኒን ደገመኖ ተብሴ ላገት አመዕንታሀኑኡተ ኣሰንቶተ ጠሊሉ መጻፉ የኖ ሃሊን ኣዱንያ አሉ ጉዕሙንኩ ጩቢሃ ጠገንት ጩብ ኡሱረኘ እኮኡ። ");
INSERT INTO alw_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","አመዕነቱ አሜቱዕናን ብርተ ሕጉ ጠቅዮኔ እቅ፤ ሁኩንን አመዕነቱ ለሎተ ኢለ ሕጉ ጡፍ አፎኔ እቅ። ");
INSERT INTO alw_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","ከን ሃሊን አመዕነቲን ፈየ እንኮተ መሲህ አሜቶተ ኢለ ሕጉ አገራንቹኔ እኮ እቅ። ");
INSERT INTO alw_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","እኮጎሬ ቴሱ አመዕነቱ አሜቾቤቺሃ ሕጉ አገራንቹኔ እሁስ ፈቆኡ። ");
INSERT INTO alw_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","መሲህ ኢሳን አመዕኒን ጉዕሙንኩክዕኔ መገንተ እለ፤ ");
INSERT INTO alw_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","ጠመቀንቴን መሲሂን ሜጡበ እኬንተሩ ጉዕሙንኩ መሲህ ኦድኖገ ኦደኤንታአ። ");
INSERT INTO alw_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","ጉዕሙንኩክዕኔ መሲህ ኢሲን ሜጡ እኬንተቤቺሃ አይሁድችለከ ግርክቺ፥ ሮስችለከ ሰዎልድቺ፥ ጎንለከ ሜንት በላን አደዶመት ዮበአ። ");
INSERT INTO alw_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","አዕኑ መሲህረ እኬንታች እብራሂምተ ዘር፤ ተብሴስ ላገ መሳን ረገኣኑታን። ");
INSERT INTO alw_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","ቴሁ ያሚሁ ከኒት፤ ረገአኖሁ ቀዉ ጩል እሀኖ ወክት ዱንያተስ ጉዕሚንከ ቀርቹ እኮ እቃ መቶርቺንከስ ሮስቺች አደ እሀኖበአ። ");
INSERT INTO alw_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","ጠዉ እኮጎሬ አኑስ ቀደሮ ወክቱ ኢሎተ ኢለ አገርታሀኑኡለከ ኤገተ ኣሴመ መን አንጋን አገረኖ። ");
INSERT INTO alw_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","ህትን ነኡ አያን ጠዊሃ ጩለገ ዮም ወክት ከን ኣዱንያ አሌን ዮ ሴሪሃ ጠገም ሮስ እንኮም እቅ። ");
INSERT INTO alw_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","ጠዉ እኮጎሬ ቀደሮ ዘማኑ ኢሌ ወክት መገኑ ቤቱስ ሶኮኔ፤ እስ ሕጊች ዎሮን እክ መንቾች እለሞ፤ ");
INSERT INTO alw_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","ህካን አዕዮሁ ሕግ ኣዜን ዮእረ ዎዞተለከ ነኡን መገን እለተ እንካምገ አኦታት። ");
INSERT INTO alw_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","መገን እለተ እኬንተቤቺሃ መገኑ «አበ» የን ገአኖ ቤትስ አያነ ቀልቢሃኔ ሶኮ። ");
INSERT INTO alw_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","ህካን እኮቤቺሃ ከኒች ኤተሮን ቤቱሃን ቤሉ ሮስሃበአ፤ ቤቱስ እኮንቲች መገኑ ረገኣንቹ አዕዮሄ። ");
INSERT INTO alw_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","ከኒች ብርተ መገኑ ደጉ ሆግክዕኔ መሳን ክልቀቲንከሰ መገኑ እኮበእሀኑኡተ ሮስ እኬን ጠገንቴንታ እቅ። ");
INSERT INTO alw_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","እኮጎሬ ቴሱ መገኑ ደጌንታአ፤ በትሽን መገኑ ክዕኔተ ደገኖህዕኔ፤ ህከረ ሀት ላፋለከ ሂለ ኣዱንያ አል ሴርቤቹ ፈንቀልቴን? ሀት ለንኪሃ እሰ ሮስ እኮኖተ ሀሴነንታት? ");
INSERT INTO alw_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","አዕኑ በሪሃ፥ አገኒሃ፥ ወክቲሃለከ ዘማኒሃ ጠረኝሴን አበ ኬዕምኝ ኣቴነንታት። ");
INSERT INTO alw_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","ክዕኔ በላን ሆጎን ሆጎሚሁ ጉዕሙንኩ ተሰ እክ ፈቀኖ ይ ዋጃም። ");
INSERT INTO alw_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","አመኤ ኦሶ! አን ክዕኔገ እኮምቤቺሃ አዕኑሁ ኢገ እኬ ይ ኡጫንክዕኔ፤ አዕኑ መቱ ብድልሃ ኢልሴንታኤበአ። ");
INSERT INTO alw_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","ዎዕኔ ወክት ተሽት ላገተ ክዕኔሃ ዱዱብሶተ እድል ደኤሚሁ ጥዘነ መሳን እሁስ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","ሄንከ ጥዘነኤ ፌተነተ እኮህዕኔጎሬ ህንቄንታኤበአ ህከረንገ ሽግግ ይቴንታኤበአ፤ በትሽን መገን መላይኬቹ ቶጌነንተሀኒገ አቴን ቶጌንታኤ፤ ህትን መሲህ ኢሰ ቶጌነንተሀኒገ አቴን ቶጌንተኤ። ");
INSERT INTO alw_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","ከኒች ዎዕናሃ ሄኦህዕኔ ሙንዲኑት ሀከቤቹ መርቶኡ? አታልሲሾህዕኔ እቃ እልክዕኔ ፉሽቴን ኣቴነንተኤገ አን ገዉንኩእ መሰከራም። ");
INSERT INTO alw_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","ህከረ ቴሱ ሀንቅ ኩሎንክዕኔቤቺሃ ዲነክዕኔ እኮምንዶ? ");
INSERT INTO alw_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","ዎሉ መኑ ክዕኔተኔሃ ጨነቀንት ሰውይታኢት፤ እሁን ቤሉ ህካን አታኢሁ ጡመ ጠዊሃበአ፤ እሰ ሃሽኣቱት አዕኑ ኒች አደ እኮኖታትለከ እሰተኔሃ አበ ሰውይቶኖታት። ");
INSERT INTO alw_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","ሰውቱሰ ጡመ እኮች ጠረኙ ጉዕመ ወክት ጡመሃን፤ ጠዉ እኮጎሬ ኩ ጠረኝመክዕኔ አን ክዕኔን ሜጡበ ሄኣም ወክት ጠለዕል እሁንከ። ");
INSERT INTO alw_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","ኢ ኦሶ! መሲህ ክዕኔ ኣዜን ለሎተ ኢለ ቴሁ ክዕኔተኔሃ ኒጠን አበ ጨነቀማሚት። ");
INSERT INTO alw_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","ክዕኔሃ መ አኡ ሀሲሰኖኤጎሬ ደጉ ሆግንከኤ ጉረተ ኣጋዕኔ አበ ጨነቀሞም፤ ቴሱ በላንከክዕኔ ደገም አደደ አፎን ጠወዕዮም እቃ ሄንከ ኢታም እቅ። ");
INSERT INTO alw_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","አዕኑ ሕጊሃ ጠገንቴን ሄኢሃ ሀሴነንተሩ ህንዴ ኩሌኤ፤ ሕጉ የኖሃ ሞጮጭቴነንተበእንዶ? ");
INSERT INTO alw_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","ጠሊለ መጻፋን «እብራሂሚሃ ለም እለት ሄኦስ እቅ፤ መቱስ እለሞሁ ሮስቾ መንቾች እሀን ዎሉስንገ ሰዎልድቾ መንቾቺት» የመም ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","ሮስቾ መንቾ ቤቱ እለሞሁ ማል ሄዕላቸገ እሀን ሰዎልድቾ መንቾ ቤቱ እለሞሁ ኣሰንቶ ተብሴ ላጋኒት። ");
INSERT INTO alw_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","ኩ ለሙ ሜንቱ ለሞ ወኣድ ላገተ ለሊሰኖቤቺሃ ኩን ምሳሌገ ለለኖሃን፤ መትሴ ወኣድ ላገተ ሲና ዬኖ ቆታች እከን ሮሶማተ እካ እለተ እልታእታን፤ እሴን አጋራት፤ ");
INSERT INTO alw_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","አጋር አረብ ባዶን ዮ ሲና ቆተተ ምሳልተ እቅ፤ ህካን እኮቤቺሃ ቴሱ ዮ ዬሩሳሌሚን አጉጠንታአ፤ እሴን እላንተሴን ሮሶማን ሄኣእታን። ");
INSERT INTO alw_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","አሊች ሰሜች እኮእ ዬሩሳሌሙ ሰዎልድቾታን፤ እሴን አመተኔ። ");
INSERT INTO alw_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","«አት ጎደቡ ዮሄበኢት ተሽ ዩንኬ! አት እልቶተ ኒጥ ከሲባት ‹እልል!› ይ፤ ምኒ አኑ ዮሴ መንቾች በትሽ ምንሴ አኑ አጉራንሴ ዮ መንቾተ ልግብ እለት ዮሴ» የመም ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","አመኤ ኦሶ! አዕኑ ቴሱ ኢሳቅገ ተብሴ ላገተ እለ። ");
INSERT INTO alw_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","ጠዉ እኮጎሬ ህከ ወክት ማሊን እለሞሁ ጠሊለ አያኒን እለሞሃ ሸሬገን ከበሪሁ ህትዪንት። ");
INSERT INTO alw_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","ጠዉ እኮጎሬ ጠሊሉ መጻፉ የኖሁ መርቾሃን? ጠሊሉ መጻፉ «ሮስቹት መንቹት እልቶ ጩሉ ሰዎልድቹት እልቶሀኒን ሜጡበ ረገአኖበእቤቺሃ ሮስቹተ ጩሊንከሴን ሜጡበ ሸር» የኖ። ");
INSERT INTO alw_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","ህካን እኮቤቺሃ አመኤ ኦሶ! ነኡ ሰዎልድቾተ እለ ቤሉ ሮስቾተ እለበአ። ");
INSERT INTO alw_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","መሲህ ሰዎልድማን ፉሼኔሁ ሰዎልድማን ሄዕኖታት። ህካን እኮቤቺሃ ጠረኝቴን ኡርዬ ቤሉ ለንኪሃ ፈንቀልቴን ሮስ እኬን ጠገንቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","ቴሱ አን ጳዉሎስ ያንክዕኔሁ ጡርከመንቴንተ ጎሬ መሲህ መቱርቹሃ ደግለለኖህዕኔበአ፤ ");
INSERT INTO alw_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","ጡርከመመኖሁ ጉዕሙንኩ «ሕገ ጉዕመንከ አኦተ ግዳጁ ዮስ» ይ ለንኪሃ ጠረኝሳም። ");
INSERT INTO alw_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","አዕኑ ሕገ አገርቴነን ፈይቶኖተ ሀሴነንተሩ ጉዕሙንኩ መሲህች አደ እኬንታአ፤ መገን ኣስቶችስ ፉልቴንታአ። ");
INSERT INTO alw_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","ጠዉ እኮጎሬ ነኡ መገን አያኒን ፈይመ ተብሳሃ አመዕነቲን አገዕሪናም። ");
INSERT INTO alw_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","መሲህ ኢሲን ሄኤማች ጡርከመሙ ህከረንገ ጡርከመሙ ሆጉ ደግለለኖበአ፤ ደግለለኖሁ ኢታን ለለኖሃ አመዕነቱ። ");
INSERT INTO alw_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","አመዕነቲን ጡመገ ሃንቴነንታት እቅ፤ ቴሱ ሀንቂሃ አዘዘንቴንበገ ከሞህዕኔሁ አዬት? ");
INSERT INTO alw_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","ህትኔ ሸዘነት ገኤህዕኔ መገኒች አሜቶበእተ። ");
INSERT INTO alw_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","ቀቅቹ ራጭቱ ቡኩተ ጉዕመንከ አቦከኖ። ");
INSERT INTO alw_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","ጠዉ እኮጎሬ ከኒች አደ እኮ ዎሉ ሰውቱ ሄአኖህዕኔበእገ ተሬገጭ ቀርቾን አመዕናም፤ ጉረተ ኣግሰኖህዕኔሁ አዪሁ ፍርደስ ኣአኖ። ");
INSERT INTO alw_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","አመኤ ኦሶ! አን ቴሱ ኢለ ዱዱብሰን «ጡሚሃ ጡርከመሙ ሀስሰኖ» ይዮም እቃ ቴሱ ኢለ ሚሃ ሸርታኤ እቅ? ህካን እኮእቀ መሲህ መስቀሉ መኒሃ ጉፉተ እሀኖበ እቅ። ");
INSERT INTO alw_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","ህካን እኮቤቺሃ ኩ ጉረተ ኣግሳህዕኔ መናከት ሀሶ ጎሬ ጡርከመሙ ጠለዕለ እሁዕነ ገዉንኩሰ ፎልሰ ኡለተ ቃርቶ እቃ ኢታም እቅ። ");
INSERT INTO alw_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","አመኤ ኦሶ! አዕኑ ሰዎልድማሃ ገአንቴንታአ፤ ጠዉ እኮጎሬ መት-መቱስ ኢታን ካደሙን ቤሉ ኩ ሰዎልድመክዕኔ ማል ሃሽኣቱተ አቴነንተ መሰተ እሁንከ። ");
INSERT INTO alw_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","ሕጉ ጉዕሙንኩ «ዎሉ መነ ገይክገ አት ኢት» የኖ መቴ ላጋን ጎፎኡ። ");
INSERT INTO alw_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","ጠዉ እኮጎሬ ገገዉክዕኔ ገዕመቀንቴነንለከ እተቀንቴነን በኤነንተበእገ አገዕርዬ። ");
INSERT INTO alw_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","ቴሱ ጠሊለ አያነ አዎንቴን ሄኤንተ ጎሬ ማል ሃሽኣቱተ አቴነንተበአ ያም። ");
INSERT INTO alw_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","ማል ሃሽኣቱት ጠሊለ አያን ሃሽኣቶን ቶቃቀንታበአ፤ ህትን ጠሊለ አያን ሃሽኣቱት ማል ሃሽኣቶን ቶቃቀንታበአ፤ ጠሊለ አያን ሃሽኣቱትለከ ማል ሃሽኣቱት ገገዪሀሰ ባለጋረተ፤ ህካን እኮቤቺሃ አዕኑ ሀሴንተርቹ አቶኖተ አታልቴነንተበአ። ");
INSERT INTO alw_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","ጠሊለ አያነ አዎንቴንተጎሬ ሕጊሃ ጠገንቴነንተበአ። ");
INSERT INTO alw_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","ማል ሃሽኣቱት ደገንቶእራን፤ እሰን ዝነተ፥ ሂለ ንጃስ አኡ፥ ገዉ አገዕሩ ሆጉ ");
INSERT INTO alw_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","ሽርክተ አኡ፥ ኪሉ፥ ዲኖመተ፥ ኦደተ፥ አቄሸተ፥ ኡሙዕርተ፥ ገዉ ኢቱ፥ አደዶመተ፥ አድመ አኡ፥ ");
INSERT INTO alw_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","ምቀኞመተ፥ ሰከሩ፥ መጠረቁ ዮበእ ሙንዲኑተ አጉዳእራን፤ ከኒች ዎዕናንከ ጠረኝሽ ኩሎምገን ቴሁ በርግ ጠረኝሽ ኩላንክዕኔ፤ ህትኔ ጠወ አታ መናከት መገን ዎምነቱ ኣጋበአ። ");
INSERT INTO alw_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","ጠዉ እኮጎሬ ጠሊለ አያን ላልቹ ኢተተ፥ ሙንዲኑተ፥ ወገሬት፥ አደብ፥ ጡምመተ፥ ጡመ ጠወ አኡ፥ አመዕነሙ ");
INSERT INTO alw_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","ጎደበ ላፋለከ ገዉ አገዕሩሃን፤ ህትኔ ጠወ ግበኖ ሕጉ ዮበአ፤ ");
INSERT INTO alw_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","መሲህ ኢስረ እኮእሩ ማለሰ ሄዕላቻንተስለከ ሃሽኣቶንከስን መስቀላን ሰቀልቶኡ። ");
INSERT INTO alw_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","ጠሊለ አያኒን ሄዕናሚሃ እንኮሚች ጠሊለ አያነ አዎኖ። ");
INSERT INTO alw_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","መቱ ዎሉ ሂለ ጠዊሃ ኬሰንሰን ገገዉንኩኔ ምቀኝነን ተሳን ቦኑንከ። ");
INSERT INTO alw_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","አመኤ ኦሶ! መቱ መንቹ ጩብ አዕይ ደገሞጎሬ አመዕነቲን ጠረኛኑተ እኬንተሩ ህትኔ መንቹ ጎደበ ላፍማን ብዝ አዕዬስ፤ ጠዉ እኮጎሬ አቲሁ ህትኔ ፌተናን አጋንትበእገ አገዕር። ");
INSERT INTO alw_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","ክዕኔች መት-መቱክዕኔ ዎልስ ኬዕምታ እጅነተ እጁን፤ ከን ሃሌን መሲህ ሕገ ዊንሽቴነንተ። ");
INSERT INTO alw_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","አዪሁ ዎሎ መኒች ቆሀኖርቹ ዮስበኢንከ «አን ዎሎ መኒች በተኣም» ይ ሰውዬጎሬ ገዉስ ጣንሰኖት። ");
INSERT INTO alw_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","ጠዉ እኮጎሬ ገገዉንኩስ ገይስ ሆጉተ መረመር ለኡን፤ ህከኒች ኤተሮን ገዉስ ዎሎ መኒን ሜዛኝ እሁዕነ ጠለዕል ገይሃስ ድከአኖርቹ ደአኖ። ");
INSERT INTO alw_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","መሰንትስ ገገዉንኩስ ገይስ እጅነተ እጁ ሀስሰኖ። ");
INSERT INTO alw_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","ላገስ ተማረኖ መንቹ አስተማርቺንከስን ሜጡበ ጡመርቹ ጉዕመንከ ቤቀሙን። ");
INSERT INTO alw_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","ገዉክዕኔ ሉሲሶኖቼ፤ መኑ ምደኖሁ ዉጮሃት፤ አዪሁ መገኖን ቀለዶተ አታለኖበአ፤ ");
INSERT INTO alw_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","ማለ ሙንዲሲሶተ ዉጠኖሁ ማሊችስ ሬሁተ ምደኖ፤ ጠሊለ አያነ ሙንዲሲሶተ ዉጠኖሁ ጠሊለ አያኒች ዘላለም ሄኡ ምደኖ። ");
INSERT INTO alw_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","ተብሳ ሙርንባች ወክቱ ኢሌሃን ዉጠተ ጭምአዕናምቤቺሃ ጡመ ሆጉተ አኡ አጉርኑንከ። ");
INSERT INTO alw_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","ቴሱ ጡሙ ወክቱ ዮኔቤቺሃ መኒሃ ጉዕሚንከ በትንስ አመዕንቶ መኒሃ ጡመ ጠወ አዕኖ። ");
INSERT INTO alw_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","ሀትኔ ሎርሎረ ፍደሊን ገይኤ አንጋን ከተቦንክዕኔገ ለዕዬ! ");
INSERT INTO alw_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","ጡርከመንቶኖተ ግደጅሳእሩ አብሊን ጡመ አጉድ ለሊሃ ሀሳእተ መናከ፤ ህካን አታኢሁ መሲህ መስቀል መሳን ሸረንታበእገ ሰውይቲት። ");
INSERT INTO alw_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","እሰ ጡርከመንቶኖተ ሀሳኢሁ ጡርከመምንከክዕኔ ቦንቶታት ቤሉ ጡርከመንቶሩ ገዉንኩሰ ሕገ አገርቶበአ። ");
INSERT INTO alw_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","ቀርቹሃኔ መሲህ ኢስ መስቀል ቤሉ ዎሎርቾን ድከኡ ኢች ቄዕሩን፤ ከን መስቀል መሳን ኣዱንያ አሉ አደ እኮኡ፤ አኒሁ ኣዱንያ አሊች አደ እኮም። ");
INSERT INTO alw_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","ህካን እኮቤቺሃ ጡርከመሙ እኮ ጡርከመሙ ሆጉ መቱርቹሃ ደግለለኖበአ፤ ደግለለኖሁ ሃዕሮ ክልቀት እሆሃን። ");
INSERT INTO alw_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","ከ ትዛዝ አዎነኖሀኒሃ ጉዕሚንከለከ መገን ዎገነ እኮ ሀንቅ እስራኤሊሃ ወገሬቱለከ ማርቱት እኩን። ");
INSERT INTO alw_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","ጅስምኤ አሌን ዮ ገረፌመኤ መላት ኢስ ካዲንቹ እሁኤ ለሊሰኖቤቺሃ ከኒች ኤተሮን አዪሁ ኦርሱንከኤ። ");
INSERT INTO alw_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","አመኤ ኦሶ! ቀርችኔ መሲህ ኢስ ኣስቱት ክዕኔን ሜጡበ እኩን! ኣሚዕን። ");
INSERT INTO alw_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","መገን ሰውቲን መሲህ ኢስ አሳቤቹ እኮ ጳዉሎሴችለከ መሲህ ኢሲን አመዕነንቶሀኑኡተ፥ ኤፌሶናን ሄኣ ጠሊላኖ አመዕናኖተ፥ ");
INSERT INTO alw_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","አናኔ መገኒችለከ ቀርቾሃ መሲህ ኢሲች ኣስቱትለከ ወገሬቱሁ ክዕኔሃ እሁን። ");
INSERT INTO alw_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","ሰሜ ቤቾን ጠሊለ አያኒን ደገንታ በረካን ጉዕሚንን መሲህ አዲን ማሰዕዮኔ ቀርችኔ መሲህ ኢሲን አኑኔ መገኑ ማሰአሙን። ");
INSERT INTO alw_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","ጠሊላኑተለከ ኩሌኖርቹ ዮበእረ እንክ ብሬስ ደገሞተ ኣዱንያት ከለቀንቱዕነ ሄጭ መሲሂን መጠሮኔ። ");
INSERT INTO alw_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","መገኑ ሀሰኖ ሃሊን መሲህ ኢስ መሳን እለስ እንኮተ ሄጭ ኢታንከስ መጠሮኔ። ");
INSERT INTO alw_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","መገኑ ህካንን አዕዮሁ ኢተሞ ቤትስ መሳን ኔሳሃ ነጣን ኣሴኔ ኬዕምኝ ኣስቶተ እሱ ገለትጭኖታት። ");
INSERT INTO alw_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","መገን ኣስቶ ዊምማች ኬሽ ቤትስ ቄጊን ዎዝኑተ ደእን ጩብሃኔ ማርቱተ ደዕኖም። ");
INSERT INTO alw_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","ኣስቱስ በትሾኔ። ሀይማንለከ ኤንኬዕኒን ");
INSERT INTO alw_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","መገኑ ጎደበ ላፍማንከስ መሲህ መሳን ሄጭ ያጆገ ምስጥር ደንጋምገ አዕዮኔ። ");
INSERT INTO alw_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","ወክቱስ ኢለኖ ወክት መገኑ ሆጎን ሆስሰኖ ኩ ያደስ ሰማንለከ ኡላን ዮ ክልቀቱ ጉዕሙንኩ ሜጡበ መቶ መሲህ ሹምነት ኣዜን እካጋት። ");
INSERT INTO alw_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","ጉዕመ ጠወንከ ገይስ ሰውቲን አአኖ መገኑ ሄጭ ያጆ ሃሊን መሲህ መሳን እስ ወገነ እንኮተ መጠሮኔ። ");
INSERT INTO alw_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","ሁኩንን እኮሁ መሲህ ተብሳሃ አኢን ዎኔሃ እንኮምሩ መገን ኬዕምኝ ገለቲን ለሊንሶታት። ");
INSERT INTO alw_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","አዕኑ ህትን ሀንቅ ላገተ ኩንን ጡምቴንተ እንጂለ ሞጮጭቴንተ ወክት መሲሂን በርገንቴንታአ፤ አመዕንቴን እስን እህን ተብሳሃ እክ ኣሰሞ ጠሊለ አያን ማተቢን ዎቀረንቴንታአ። ");
INSERT INTO alw_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","ሁኩ ጠሊሉ አያኑ መገኑ ገይስረ እኮረ ጉዕመንከ ዎዞተ ኢለ ርስቲሀኔ ሩብት እሀኖሃ ቀብደ፤ ሁኩንን ክዕምኚሀስ ገለትሃን። ");
INSERT INTO alw_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","ህካን እኮቤቺሃ ቀርቾ ኢሳን ዮህዕኔ አመዕነትለከ አመዕናኖተ ጉዕሚንከ ዮህዕኔ ኢተተ ሞጮጬም ወክቲች ኬሽ ");
INSERT INTO alw_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","ክዕኔተ ዱኢን ቃገን ክዕኔ መሳን መገኒሃ ገለት ሆንጠህሱኤ አጉራምበአ። ");
INSERT INTO alw_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","ኬዕምኙ ሀስሰኖስ ቀርችሃኔ መሲህ ኢስ አነ መገኑ በትሴን ደጎኖተ ሀይመ አያነ ኣሶህዕኔተለከ ገውስ ለሊሶህዕኔተ ዱአ አኣም። ");
INSERT INTO alw_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","ሀትኔ ተብሴሃ ገአንቴንታጎሬ ጠሊላኑት ረገኣ ኬዕምኝ ርስቱ ሄንከ ልግብየ ጎሬ ደጎኖተ ቀልብክዕኔ እልት ፈንተኦተ ዱአ አኣም። ");
INSERT INTO alw_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","ዎለአንትበ ሎረ ዎልቀስ ኔሳሃ አመዕንናምሀኑኡተ ሄንከ ሎረሃ ጎሬ ደጎኖተ ዱአ አኣም፤ ");
INSERT INTO alw_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","ህከ ሎረ ዎልቀስ ሆጎን ለሊሾሁ ሬሆች ኬሽ ሰማን መኬንከስ አፉሼ መሲህ አዲንት። ");
INSERT INTO alw_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","አኑ መገኑ መሲህ ሰማን መኬንከስ አፉሼኢሁ ጉዕመ ዳኝነቲችለከ ዎልቃች ቀርቻኖች ሎረ ህትን ከን ኣዱንያ አሌን ጠለዕል እሁዕነ አሜተኖ ኣዱንያ አሌን ሱዕሚች ጉዕሚችን ሎረ እኮ ኬዕምኝ ሱዕመ ኣሲንት። ");
INSERT INTO alw_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","ጉዕመ ጠወንከ ዳኝነትስ ኣዜን አዕይ ጠገመኖገ አዕዮስ፤ መገን አመዕናኖ ዱእ ምኒ ጉዕመርቾንን ቡዕለ አዕዮስ። ");
INSERT INTO alw_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","መገን አመዕናኖ ዱእ ምኑ መሲህሃ ጅስመሃን፤ መገን አመዕናኖ ዱእ ምኑ ጉዕመ ጠዋን ዊመ አአኖሴ እሲን ዊመ እኮእተ። ");
INSERT INTO alw_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","አዕኑ ቤሲክዕኔለከ ጩብክዕኔ መሳን ሬቴንታእረ እቅ፤ ");
INSERT INTO alw_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","ህከ ወክት ከን ኣዱንያ አል ሂለ ዎቃሃ አዎንቴነንተ እቅ፤ ህትን ቦብር አሌን ሄኣ ሂለ አያን ቀርቻኖተ ጠገንቴነንተ እቅ፤ እስን መገኒሃ አዘዘንታበእ መን አሌን አአኖሃ ሂለ አያነ። ");
INSERT INTO alw_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","ነኡ ጉዕሙንኩኔ ከኒች ብርተ እሰ በላን ማልኔ ያደተለከ ቀልብኔ ሰውት አዎነን ማልኔ ሄዕላቻን ሄዕናምረ እቅ፤ ዎሎ አዘዘንትበ መንገን ክልቀትንከኔ መገን ኡሙዕሬ ኣዜን ሄዕናምረ እቅ። ");
INSERT INTO alw_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","ጠዉ እኮጎሬ መገን ማርቱት አበ እህንከስለከ ኔሳሃ ዮስ ኢተት ሎረ እህንከስ ");
INSERT INTO alw_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","ቤስንከኔ ሬኖምረ እንኮም እቃ መገኑ መሲሂን ፎሊን ሄዕኖተ አዕዮኔ፤ አዕኑሁ ጡሚቴንታሁ ኣስቶንከሲት። ");
INSERT INTO alw_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","መገኑ መሲህ ኢስ አዲን እሲንን ሬሆች ኬሽ ሰማን እሲን ሜጡበ አፉሼኔ። ");
INSERT INTO alw_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","ህካንን አዕዮሁ መሲህ ኢሲን ኔሳሃ ለልሾ ማርቱስለከ ዎሊንሹ ዮበእ ኣስቶ ቀባጡተ አሜተኖ ዘማን ለሊሶኔተ ይይት። ");
INSERT INTO alw_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","መሰንትስ አዕኑ ጡምቴንታሁ አመዕነት መሳን ኣስቶንከስት፤ ሁኩንን መገንተ ኣስቱ ቤሉ ክዕኔ ሆጎን ደገሞበእሃን። ");
INSERT INTO alw_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","አዪሁ ድከአኖበእገ ጡሙ ደገመኖሁ ሆጎኒበአ፤ ");
INSERT INTO alw_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","ነኡ መገኑ ሄጭ ቅጥአዕዮ ጡመ ሆጉተ አዕኖተ መሲህ ኢስ አዲን ለንኪሃ ከለቀሞምሃ መገኒሃ ክልቀት። ");
INSERT INTO alw_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","ህካን እኮቤቺሃ አዕኑ ዎዕናሃ ክልቀቲንከክዕኔ አይሁደ እኬንበሩ፥ አይሁድ መኑ መን አንጋን ጡርከመንት ሄኦገን ክዕኔተ ጡርከመንቴንታበእሩ ይተን ቦሮርተንክዕኔ ሄኦገ ቃጌ። ");
INSERT INTO alw_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","አዕኑ እስራኤል መነ እኬንበሩ ተብሴ ላገ ወኣዲሃ ኮህቹ እኬንተሩ፥ ከን ኣዱንያ አሌኒ መቱ ተብሶሁ ዮህዕኔበእሩ፥ መገኒች አደ ሄኤነንተሩለከ መሲህች አደ እኬንተረ እሁክኔ ቃጌ። ");
INSERT INTO alw_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","ቴሱ እኮጎሬ አዕኑ ከኒች ብርተ ቄዕርቴን ሄኤንተሩ መሲህ ኢሲረ እኬን እስ ቄጊን ሆንጠኬንታአ። ");
INSERT INTO alw_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","መሰንትስ አደ አዕዮኔ ብተ ግድግደ ድጄኢሁ፥ አይሁደለከ አይሁደ እክበረ ሜጡ አዕዮ ወገሬቱኔ መሲህት። ");
INSERT INTO alw_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","ለሞንከ ኡመቲች እሲን ሜጡ እኮ መቱ ሃዕሮ ኡመት ከለቆተ አይሁድ ሕግ ትዛዝለከ ሴራ ማሊንከስ ሻር ወገሬት አዕዮ። ");
INSERT INTO alw_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","እስን መስቀል አሌን ሬሆንከስ ድኖመተ ቤሾ፤ ለሙንከስ ሜጡ ጅስመ አዕይ መገኒን ሀራርሴሰ። ");
INSERT INTO alw_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","አሜች ክዕኔሃ ቄዕርቴን ሄኤነንተሀኑኡተለከ ሆንጠክ ሄኦ አይሁዲሃ ወገሬት ተማርሴእ። ");
INSERT INTO alw_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","እስ አዲን ጉዕሙንኩኔ መቶሃ አያኒን አዎን መገን ቤቹ ሆንጠንካም። ");
INSERT INTO alw_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","ህካን እኮቤቺሃ አዕኑ መገኒሃ አደ እኮሀኑኡን መቶሃ ባድሃ መነለከ መገንየ አበሮስ ቤሉ ከኒች ኤተሮን ኮህቻኑተለከ ዎሎ ቤቺች አሜቴንታእራበአ። ");
INSERT INTO alw_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","አሳበለከ ነቢያኖ ቀበብ አሌን እጃረንቴንታእራን፤ ሙረበ ቡዕል ክኑ መሲህ ኢሳት። ");
INSERT INTO alw_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","ግንቡስ ጉዕሙንኩ እሲን መክ ቀርች ጠሊለ ምኒ እሆተ ነጰኖ። ");
INSERT INTO alw_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","መገኑ አያኒንከስ ገለኖ ግንበ እኮኖተ አዕኑሁ በርገንቴን መሲህን መክቴነንተ። ");
INSERT INTO alw_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","ህካን እኮቤቺሃ አን ጳዉሎስ ክዕኔሃ አይሁደ እኬንበሀኑኡተ ይ መሲህ ኢስ ካዲንቹ እህንከኤ ኡሱረኘሃን። ");
INSERT INTO alw_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","ክዕኔሃ ደግለለኖገ አኦተ መገኑ ኣስቶንከስ ካደሞስተ እድል ኣሴኤገ ሀንቂንከ ሞጮጭቴንታአ። ");
INSERT INTO alw_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","አን ሄጭ ገበንቹ አዕይ ከተቦክዕኔገን መገኑ ማጠሞርቹ ለልሾኤ። ");
INSERT INTO alw_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","ህካን እኮቤቺሃ ካን አነበቤነንተ ወክት መሲህ ማጠሞርቹ ሚ ጌሰ ኣጎኤ ጎር ደጎኖተ አታልቴነንተ። ");
INSERT INTO alw_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","ኩ ማጠሞርቹ መገን አያኒን ጠሊላኖ አሳባተስለከ ነብያኖተስ ቴሱ ለሌ ሃሊን ህጎ ዘማኔን ሄኦ መኒሃ ለልዮበአ። ");
INSERT INTO alw_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","ኩን ለሊሰኖሁ አይሁደ እህቡ መኑ አይሁዲን ሜጡበ ርስተ ረገኣእረለከ መቶ ጅስም ብሊተ እክ መገኑ ኣሴ ተብሳሃ እንጂል አዲን መሲህ ኢስ ቤቀማኑተ እሁሳት። ");
INSERT INTO alw_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","መገኑ ዎልቃንከስ ኣሴኤ ኣስቶን አኒሁ ከን እንጂል ካዲንቹ እኮም። ");
INSERT INTO alw_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","አን ጠሊላኖች ጉዕሚችን ሆፈኣሚሃ እኮምጎሬሁ ዳንጉ ዮበእ መሲህ ቀባጦ እንጂለ አይሁደ እህበ መኒሃ ዱዱብሶተ መገን ኣስቶን ኩ ዕድሉ ኣሰሞኤ። ");
INSERT INTO alw_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","ህትን ህጎ ዘማኔን ጉዕመንከ ከለቆ መገኒን ማጠም ሄዕዮ ምስጥር መገን ያደት መሃጎር ጉዕሚንከ ለሊሶተ ኣስቱት ኣሰንቶኤ። ");
INSERT INTO alw_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","ሁኩንን እኮሁ ከን ዘማኔን አመዕናኖ ዱእ ምኒ አዲን ሰማን ሄኣ ሹመትለከ ሀለቀት መገን ኤንኬዕኑ አደደ ደኒን ደጋገት። ");
INSERT INTO alw_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","መገኑ ቀርቹሃኔ መሲህ ኢሲን ካን አዕዮሁ አበ ዘማኒች ብርተ ያጆ ሃሊኒት። ");
INSERT INTO alw_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","መሲህረ እህንከኔለከ እሲን አመዕኒንከኔ መገን ብሬን መለልን አመዕነትን ሆንጠሁ አታልናም። ");
INSERT INTO alw_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","አን ክዕኔተኔሃ ቶጋም ኦርሸት ኬዕምኝክዕኔ እኮቤቺሃ ኦርሸኤ መሳን ተብሳሃ ሙርቶኖቼ ይ ኡጫንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","ቴሁ አነ መገን ብሬን ጉሉቤንከኤ ጉሉጵ ዱአ አኣሚሁ ከን መሳኒት። ");
INSERT INTO alw_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","ሰማንለከ ኡላን ዮ ጉዕሙንኩ አበሮሱ ሱዕመስ ደአኖሁ መገኒችት። ");
INSERT INTO alw_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","መገኑ ኣዝ ጅስመክዕኔ ጠረኝሰኖ ዎልቀተ አያንስ መሳን ኬዕምኝስ ሎርመተ ኣሶህዕኔተ ዱአ አኣም። ");
INSERT INTO alw_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","ህትን መሲህ አመዕነቲን ቀልቤንከክዕኔ ሄኦተለከ አዕኑሁ ጠጰ አቴን ኢታን ጠረኝቴንተረ እኮኖተ ዱአ አኣም። ");
INSERT INTO alw_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","ቴሁ መሲህ ኢተት አልባዕልመስለከ ቄዕራሽመስ፥ ጎቴመስለከ ጥዕላሽመስ ሄንከ ጎሬ ጠሊላኖን ሜጡበ ሰውዩ አታልቶኖተለከ ");
INSERT INTO alw_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","መን ኤንኬዕኒች በተኣ መሲህ ኢተተ ደጎኖተ መገን ዊምማን ዊመ እኮኖተ ዱአ አኣም። ");
INSERT INTO alw_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","ህካን እኮቤቺሃ ኒ ኣዜን አታ ዎልቀስ መሳን ኡጭናምለከ ሰውይናምሀኒች በትሽ ደፈፍሽ ኣሶተ አታለመኖስ መገኒሃ ");
INSERT INTO alw_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","እሲሃ አመዕናኖ ዱእ ምኒ መሲህ ኢስ አዲን ዘማኔን ጉዕማን ዘላለሚች ዘላለሚሃ ኬዕምኙ እሲሃ እሁን፤ ኣሚዕን። ");
INSERT INTO alw_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","ቀርቹ ካደሞንከኤ ኡሱረኛ እኮም አን ገአንቴንተ ገአሚሃክዕኔ ሀስሰኖ ሄኡ ሄኦኖተ ኡጫንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","ኢታንለከ ገገዊንከክዕኔ አታዕሊን ጉዕመ ወክት ገዉ ሆፍሲንለከ ጎደብ ላፍማን መት-መቱ አታዕለቀሚን ሄዕዬ። ");
INSERT INTO alw_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","ወገሬቲን ሜጡ እኬን መገን አያኒን ደገመኖ ሜጦመተ ጠረኝሴን አገሬ። ");
INSERT INTO alw_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","አዕኑ መቶ ተብሴሃ ገአንቴንተሀንገን መቱ ጅስሙለከ መቱ አያኑ ዮኡ። ");
INSERT INTO alw_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","ህትን መቱ ቀርቹ፥ መቱ አመዕነቱለከ መቱ ጠመቀሙ ዮኡ። ");
INSERT INTO alw_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","ጉዕሚችን ሎረ እኮሁ፥ ጉዕማንን አአኖሁ፥ ጉዕማንን ሄአኖሁ፥ ጉዕሚንከ አነ እኮሁ መቱ መገኑ ዮኡ። ");
INSERT INTO alw_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","ጠዉ እኮጎሬ መሲህ ኣሶተ ሀሾ ጌሲን መት-መትሃኔ መገን ኣስቱት ኣሰንቶኔ። ");
INSERT INTO alw_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","ሁኩንን «አሌ ፉሎ ወክት ልግብ አገንቶእረ አእ ኦሮዕዮ፤ መኒሃ ሽልማት ኣሴእ» የመሞጋት። ");
INSERT INTO alw_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","ህከረ ሁኩ «አሌ ፉሎ» ይታ ላገት ሄጭ ኡላችን አበ ጥዕላሸ ቤቹ ድሩ እህባች ዎሉ መ እሆተ አታለኖ? ");
INSERT INTO alw_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","ኩን ጥዕላሸ ቤቹ ድሬኢሁ ህትን ጉዕመንከ ዊመ አኦተ ሰሜች ጉዕሚችን አሌ ዋል ፉሎሁ እሶት። ");
INSERT INTO alw_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","እስን መት-መቱሰ አሳበተ፥ መት-መቱሰንገ ነብያኑተ፥ መት-መቱሰ እንጂለ ዱዱብስታእረ፥ መት-መቱሰንገ አመዕናኖ ዜማኑተ፥ መት-መቱሰንገ አስተማረተ እካገ ሽልማት ኣሴሰ። ");
INSERT INTO alw_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","ካን አዕዮንኩ መሲህ ጅስመ እኮእ አመዕናኖ ዱእ ምኒ ነሲሃ አመዕናኑተ አመዕነት ክድማተ ቅጥ አእሃት። ");
INSERT INTO alw_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","ህትን መገን ቤቱ ደጊን አመዕነቲን ደገመኖ ሜጦመተ ኢልን መሲህ ዊመ እኮገን ነኡሁ ዊመ መነ እንክ ነጵኖታት። ");
INSERT INTO alw_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","ከኒች ኤተሮን መን ተንኮ ክዝቢንለከ ጣንሲን ቅጠሞ ክዝብ ትምርቲን ቦብሩለከ ዊ ሁሉ ከበሃ ካጰ ሀንበለንት መርታ ጩለገ እንካምበአ። ");
INSERT INTO alw_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","በትሽን ሀንቅ ኢታን ጠወዕነን ጉዕመ ጅስሚሃ ቡዕለ እኮ መሲህበ ጉዕመርቺን ነጵናም። ");
INSERT INTO alw_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","አደዱ መኖመ ጅስሙ መቱ እሀኖሁ መሲሂንት፤ ጅስሙ ጉዕሙንኩ ሜጡ እኮሁ መኖመት ደቀንታ ቤቾኒት፤ ህካን እኮቤቺሃ መት-መቱ ጅስም ብሊቱ ኣሰሞስ ሆጉተ ብዝ አዕይ አአኖ ወክት ጅስሙ ጉዕሙንኩ ነጰኖ፤ ገውስ ኢታን ነሰኖ። ");
INSERT INTO alw_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","ከኒች ኤተሮን ሰውቱሰ ተሰ እኮ አይሁደ እክበ መንገ ሄኦኖቼ ይ ቀርች ሱዕሚን ጠረኝሽ ኩላንክዕኔ፤ ");
INSERT INTO alw_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","እሰ ቀልቡ ቱንስዮኡ፤ ህትን ቀልብ ዱድማች ኬዕዮሀኒንለከ ኤንኬዕኑ ሆግሰ መሳን መገኑ ኣሰኖ ሄኢች አደ እኮኡ። ");
INSERT INTO alw_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","ሙልት ሰውቱሰ በዕዮቤቺሃ ንጃስ እኮ ጠወ ጉዕመንከ አኢሃ ገዉሰ ሙልሰኖ ማልሰ ሄዕላቻተ ህግስ ኣቶኡ። ");
INSERT INTO alw_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","አዕኑ እኮጎሬ መሲህ ደጌንታሁ ህትናሞ ዎቄንበአ። ");
INSERT INTO alw_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","ሀንቅንከ እስተኔሃ ሞጮጭቴንታአ፤ ህትን እሲሃ እኬንተቤቺሃ ሀንቁንኩ ኢሳን ሄኡስ ተማርቴንታአ። ");
INSERT INTO alw_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","ህካን እኮቤቺሃ ጣንስ ጩብቤቹ አዎንሰኖ ሄዕላቻን በዕዮ ዎዕናሃ ሄኤነንተ ኑባጴ ሃለት ከሜ። ");
INSERT INTO alw_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","ቀልብክዕኔ ሰውቱ ሃዕሮ እሁን። ");
INSERT INTO alw_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","ሀንቅ ፈይማንለከ ጠሊልማን መገን ምሳሌን ከለቀሞ ሃዕሮ ክልቀት ኦደዕዬ። ");
INSERT INTO alw_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","ህካን እኮቤቺሃ ክዝብ ጠወኦኖቼ፤ ጉዕሙንኩኔ መቱ ጅስመ እንኮምቤቺሃ ገገዉንኩኔ ሀንቅ ጠወዕኖ። ");
INSERT INTO alw_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","ኡሙዕርዬ! ኡሙዕርቴንተጎሬሁ ጩብ አቶኖቼ፤ ህትን ኡሙዕርቴንተገን አሩ ኣጉንከ። ");
INSERT INTO alw_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","ህትን እልብሲሃ ሆሮን ቤቹ ኣቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","ህትን ሞገኖሁ ከ ኤተሩ ሞጉንከ፤ ጠዉ እኮጎሬ ህከን ወጥ ኦርጨቀሞሀኒሃ ኣሶተ ገይስ አንጋን ጡመርቹ አኡን። ");
INSERT INTO alw_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","ሆሮ አፌችክዕኔ ሂለ ላገት ፉልቱንከ፤ ጠው እኮጎሬ ሞጮጨኖሀኒሃ ተሽየኖለከ ጠረኝሲሃ ደግለለኖ ጠወ ጠወዕዬ። ");
INSERT INTO alw_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","ህትን ዎዘንቴነንተ በሬተ ዊመ እሆህዕኔተ አሌክዕኔ መተብገ ዎቀረሞ ጠሊለ መገን አያነ ሻዝሶኖቼ። ");
INSERT INTO alw_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","ህትን ቀራርስጩ፥ ንዴት፥ ኡሙዕርት፥ ጨንጨነተ፥ ያርት፥ ቦሮዕረንሹለከ ሂሉ ጠዉ ጉዕሙንኩ ክዕኔች ካጰ ሽቁን። ");
INSERT INTO alw_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","ህትን መት-መቲሃክዕኔ ጡማኑተለከ አሙዜነንተረ፥ ጎደበ ላፋኑተለከ መረርሲጫኑተ እኬ፤ መገኑ መሲሂን አጉሮህዕኔገን ገገዊንከክዕኔ አጉዕራቀሜ። ");
INSERT INTO alw_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","ኢቴኖ ኦሶገ አዕኑሁ መገኑ አዎንቴነንተረ እኬ። ");
INSERT INTO alw_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","መሲህ ኢቴኔገን መገኑ ተሽ አአኖ ጡሙ ሽቱት ዮስ ክትም አዕይ ገውስ ኒተኔሃ ህግሽ ኣሴገን አዕኑሁ እስ ኢታን ሄዕዬ። ");
INSERT INTO alw_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","ህትኔ ጠዉ መገን ኡመቲሃ ሀሲሰኖበእቤቺሃ ዝነት ህከረንገ ዎሉ ንጃስ እኮ ጠወ አኡ ህከረንገ ጎራሜቹ እሁ ፈቅ ሞጮጩሁ ሀስሰኖበአ። ");
INSERT INTO alw_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","ህከን ወጥ መገኒሃ ሹኩሪ ሆንጠህሼ ቤሉ ሂለለከ ገወ ጠወ ህከረንገ ሂለ ቀልድ ጠወ ጠወኡ ሀስሰኖህዕኔበአ፤ ህትኔ ጠዉ ክዕኔሃ መከኖበአ። ");
INSERT INTO alw_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","ዝነተ ህከረንገ ጉዕመ ንጃስ አኡ ህከረንገ ሽርኬሃ ሰገድገ ዮ ጎራምመተ መሲሂንለከ መገን ዎምነቴን ቤቹ ደአኖበእገ ደጌ። ");
INSERT INTO alw_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","ከን ጠው መሳን አዘዘንታበእ መን አሌን መገን ኡሙዕርት አሜታቤቺሃ አዪሁ ተሰ ጠዊን ጣንሱንከህዕኔ። ");
INSERT INTO alw_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","ህካን እኮቤቺሃ ከን አዘዘንታበእ መኒን ሜጡ እኮኖቼ፤ ");
INSERT INTO alw_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","ዎዕናሃ አዕኑ ቱንስቹሃን እቅ፤ እኮጎሬ ቴሱ ቀርችረ እኬንተቤቺሃ ኑርሃን፤ ህካን እኮቤቺሃ ኑር ኣዜን ሄአኖ መኒገ ሄዕዬ። ");
INSERT INTO alw_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","መሰንትስ ጡሙ ጠዉ ጉዕሙንኩ ፈይመለከ ሀንቅ ላልቹ ደገመኖሁ ኑርቺት። ");
INSERT INTO alw_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","ህካን እኮቤቺሃ ቀርቺሃ ተሽ አአኖስ ጠዉ መሃጎሬ መረመርቴን ደጌ። ");
INSERT INTO alw_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","አዕኑ ህከ ላልቹ ዮበእ ቱንስች ሆጉተ ፉሽቴን ለሊሼ ቤሉ ህከን ሆጎን ሀዕላቀንቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","ቱንስቾን ሄኣ መኑ ማጥ አታ ጠወ ጠወኡ ሙልሲሰኖ። ");
INSERT INTO alw_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","ጉዕሙርቹንኩ ኑርቤቹ ፉለኖረ በራ እክ ለለኖ። ");
INSERT INTO alw_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","በራ እክ ለለኖ ጠዉ ጉዕሙንኩ ኑርሃን፤ ህካን እኮቤቺሃ «አት ኩ ግሳንቲሁ በቅይ! ሬሆች አደ እክ ኬእ! መሲህ ኑር ለሊሰኖሄ» የመሞኡ። ");
INSERT INTO alw_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","ቴሱ ሀት እኬን ሄኤነንተጎሬ አጥራመቴን ሰውይዬ፤ ሀይቾ መንጋት ቤሉ ገዋኖገ ሄኦኖቼ። ");
INSERT INTO alw_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","ኩ ዘማኑ ሂለ እኮቤቺሃ ወክትክዕኔ ከልባን ቤሶኖቼ። ");
INSERT INTO alw_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","ህካን እኮቤቺሃ ቀርች ያደት መሃጎር ሰውይዬ ቤሉ ገዋኑተ እኮኖቼ። ");
INSERT INTO alw_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","ህትን ጠሊለ አያኒን ዊሜ ቤሉ ሂለ ዎቃሃ መሰኖህዕኔቤቺሃ ወይን ጠጂን ሰከርቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","ህትን መዝሙራን ገለቲን አመዕናኑት ዘመርታ ሃሊን ገገዊንከክዕኔ ጠወዕዬ፤ ገለቲንለከ መዝሙርን ዊመ ቀልቢንከክዕኔ ቀርቹ ገለትጭዬ፤ ");
INSERT INTO alw_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","ቀርቹሃኔ መሲህ ኢስ ሱዕሚን ጉዕመ ጠዊንከ አነ መገኑ ጉዕመ ወክት ገለትጭዬ። ");
INSERT INTO alw_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","መሲህ ከበጂሃ ዮህዕኔ ዋጃቶች ኬዕዮሀኒን ገገዉንኩክዕኔ መት-መትክዕኔ ትዛዝ ቶጌ። ");
INSERT INTO alw_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","ምኒ አማኖ! ቀርቾሃ ኢሲሃ አዘዘንቴነንተሀንገን ምኒክዕኔ አናኖተ አዘዘሜ፤ ");
INSERT INTO alw_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","መሲህ አመዕናኖ ዱእ ምኒሃ ቡዕለ እኮገን ምኒ አኑሁ ምንስ አማተ ቡዕለሃን፤ ህትን መሲህ ጅስመ እኮ መገን አመዕናኖ ዱእ ምኒሃ ጡምሳንቹሃን። ");
INSERT INTO alw_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","አመዕናኖ ዱእ ምኑንኩ መሲህሃ አዘዘንታገን ህትን ምኒ አማኑት ምኒ አናኖተሰ ጉዕመ ጠዋንን አዘዘንቱን። ");
INSERT INTO alw_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","ምኒ አናኖ! መሲህ አመዕናኖ ዱእ ምኒ ኢቴገለከ ገዉስ ህግሽ ኣሴገን አዕኑሁ ምኒክዕኔ አማኑተ ኢትዬ፤ ");
INSERT INTO alw_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","መሲህ ህካን አዕዮሁ አመዕናኖ ዱእ ምኒ ጠሊለተ አኦተ ሀሽት፤ ነጠ አዕዮሴንኩ ላገስ መሳን ዊን ኣንሽንት። ");
INSERT INTO alw_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","ከን ሃሌን ጡሩ ህከረንገ ሚንተ ኡሱሩ ህከረንገ ካን አጉደኖ ደገሙዕነ ጠሊለተ፥ ኩሌኖርቹ ዮበኢተለከ ምልካምተ አዕይ ገይስቤቹ ሆንጠህሰኖ። ");
INSERT INTO alw_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","ህትን ምኒ አናከት ገይሰ ጅስመ ኢትታሀንገ ምንሰ አማኑተ ኢቱ ሀስሰኖሰ፤ ምንስ አመተ ኢተኖሁ ገዉስ ኢተኖ። ");
INSERT INTO alw_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","ገይስ ጅስመ ግበኖሁ አዪሁ ዮበአ፤ ህከን ወጥ መሲህ መገን አመዕናኖ ዱእ ምኒ አአኖ ሃሊን ገዉስ እትሰኖ፤ አገረኖሁ። ");
INSERT INTO alw_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","ነኡ መሲህ ጅስምሃ ብልት፤ ");
INSERT INTO alw_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","«ከን መሳን መኑ አነስለከ አመስ አጉር ምንስ አማን ሜጡ እሀኖ፤ ለሙንኩሰ መቱ ጅስመ እካአ» የመሞኡ። ");
INSERT INTO alw_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","ኩ ምስጥሩ ሎረሃን፤ ካን ያሚሁ መሲህተኔሃለከ መገኑ አመዕንቶ ዱእ ምኒ ምሳልተ አዕዪት። ");
INSERT INTO alw_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","ጠዉ እኮጎሬ ኩ ጠዉ ክዕኔንተ ለአኖ፤ ህካን እኮቤቺሃ ምኒ አኑ ምንስ አማተ ገይስገ አዕይ ኢቱን፤ ምኒ አመት ምንሴ አነ ኬዕምሱን። ");
INSERT INTO alw_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","ኦሶ! ሀስሰኖ ጠወ እኮቤቺሃ ቀርቺን አናኖተክዕኔለከ አማኖተክዕኔ አዘዘሜ። ");
INSERT INTO alw_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","«ህትን አነክለከ አመክ ኬዕምስ» የኖ ትዛዙ ተብሴ ላገት ዮስ ዎኔሃ ትዛዝ፤ ");
INSERT INTO alw_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","ካን አቶንትጎሬ «ጉዕሙ ጠዉንኩ ጡመ እሀኖሄ፤ ከን ኣዱንያ አሌኒ ኡሙሩክ ዱንከኖ» ይታእታን። ");
INSERT INTO alw_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","አዕኑ አናከትለከ አማኑት! ቀርቾ ኢሲን ጡመ ዎቃሃ ተማርስቴነን፥ ሸዜነንለከ ሻቄነን ነስዬሰ ቤሉ እለክዕኔ ኡሙርሲሶኖቼ። ");
INSERT INTO alw_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","አዕኑ ሮሰት! ዱንየ አል ቀርቻኑተ እኮህዕኔሀኑኡተ ዋጂንለከ ሁጢን አዘዘሜ፤ መሲህ ካደንቴነንተ ሃሊን ጡመ ቀልቢን አዘዘሜሰ። ");
INSERT INTO alw_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","አዘዘንቴነንታሁ መገን ሰውት ቀልቢች አታ መሲህ አሳበገ እኬኒት ቤሉ መነ ሙንደእስሲሃ ይቴን ለልጪሃ እሁንከ። ");
INSERT INTO alw_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","መነ እሁዕነ ቀርቹ ካደንቴነንተገ አቴን ጡመ ቀልቢን ካደሜ። ");
INSERT INTO alw_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","ሮስ እኮ ሰዎልድቹ ገገዉሰ አቶ ጡመ ሆጎን ቀርቺች ዋጋ ቶጋኢሃ እሁሰ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","ህትን ቀርቻኑት! መን ሚንተ ለዕይ ጎልበ ክዕኔለከ እሰ ቀርቹ ሰማን ሄኡስ ሰውይቴን ዋጅሲሱክዕኔ አጉርቴን ሮሳተክዕኔ ጡመ አዕዬ። ");
INSERT INTO alw_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","ቀርቾንለከ እስ ሎረ ዎልቃን ጠረኝዬ፤ ");
INSERT INTO alw_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","ሻይጣን ሂለ ሆጉተ ግቦኖተ አታልቴነንተ መገኑ ኣሰኖህዕኔ በገዝ ኦዳተ ጉዕመንከ ኦደዕዬ። ");
INSERT INTO alw_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","ኒ ኦሉ መኒን እሁዕነ ከን ኣዱንያ አሌን አታ ገሻኖኒ፥ ሹማን፥ ከን ኣዱንያ አል ዎልቃንለከ ኡላች አሌን ሄኣ ሂለ አያኒ ዎታደርኒት። ");
INSERT INTO alw_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","ህካን እኮቤቺሃ ሂለ በር ባለጋር ዎልቀተ ፈንቀሽቶኖተ አታልቴነንተለከ ጉዕመንከስ ሹልቴን ጠረኝቴን ኡሪሃ አታልቶኖተ መገን በገዝ ኦዳተ ጉዕመንከ ቆዕርዬ! ");
INSERT INTO alw_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","ቴሱ ሀንቅ ዝናርገ ረመዞንከክዕኔ ቆዕርቴን ወዘናን ኦደኤኖ በገዝ ኦድኖገ ፈይመ በገዝ ኦዳተ ኦደኤን፥ ");
INSERT INTO alw_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","ወገሬት እንጂለ ዱዱብሲሃ ተቃጠቡክዕኔ ጫዕመገ ሎካንከክዕኔ ዎዕርቴን ኡርዬ። ");
INSERT INTO alw_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","ከኒች ጉዕሚችን አበ ጊረ ለበነገ ቡበኖ እልብስ በገዙ ጉዕመንከ አሊችክዕኔ ከዕሙ አታልቴነንተ አመዕነቱ ጌሬንጌርገ አፌ። ");
INSERT INTO alw_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","ጡሙክዕኔ ብረት ቆሜገ ቡዕላንከክዕኔ ወዕርዬ፤ ህትን ጠሊለ አያኒች ደገመኖ ሲፈ ሁኩንን መገን ላገተ አፌ። ");
INSERT INTO alw_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","ጉዕመ ወክት ጠሊለ አያነ አዎንቴነን ዱአ አዕዬ፤ ከን ሃሊን መገኑ መጠሮሰ መኒሃ በቅ ይቴንለከ ጠረኝቴን ዱአ አዕዬ። ");
INSERT INTO alw_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","እንጂል ምስጥር መለል ኩሎተ ጠወኣም ወክት ሀስሳ ላገት ኣሰንታኤገ ኤሳሃ ዱአ አዕዬ። ");
INSERT INTO alw_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","ቴሁ ሰንሰለቲን ኡሱረም ከን እንጂሊሃ አሳቤቹሃን፤ ህካን እኮቤቺሃ ሀስሰኖገ መለል ጠወኦተ ዱአ አዕዬ። ");
INSERT INTO alw_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","ኢተሞ አመኔቤቱለከ ቀርች ሆጎን አመዕነሞ ካድንቹ ቲኪቆስ አን ሀት ዮም ጎሬ መ አኣም ጎሬ ጉዕመርቹንከ ኩለኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","ህካን እኮቤቺሃ ነኡ ሀት እንኮምጎር ደጎኖተለከ ክዕኔተ ጠረኝሶህዕኔተ ይ እሱ ክዕኔቤቹ ሶኮም። ");
INSERT INTO alw_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","አነ መገንለከ ቀርቾሃ መሲህ ኢስን ወገሬቱለከ ኢተት አመዕነቲን ሜጡበ አመ ኦሶተ እሁን። ");
INSERT INTO alw_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","ሙርተእበ ኢታን ቀርቹኔ መሲህ ኢሰ ኢትታሀኑኡተ ጉዕሚንከ ኣስቱት እኩንሰ። ");
INSERT INTO alw_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","ኩ ሶህኑት መሲህ ኢስ ካዲመተ እኮ ጳዉሎሴችለከ ጥማቶሴች ሶሀንቶእተ ሶህኑ፤ ሶሃሞንኩ «ፍልጵስዩስ» ዬኖ ከተማን ሄኣ አመዕናኖ ጭምት አዎንሳኖሃ፥ ድያቆናከተለከ መሲህ ኢሳን አመዕንት ጠሊላኑተ እኮሀኑኡሃ ጉዕሚንካት። ");
INSERT INTO alw_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","አናኔ መገኒቺ ቀርቹሃኔ መሲህ ኢሲች ኣስቱትለከ ወገሬቱ ክዕኔሃ እሁን። ");
INSERT INTO alw_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","አን ክዕኔተ ቃጋም ወክት ጉዕመንከ መገኑኤ ገለትጫሚት። ");
INSERT INTO alw_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","አን ክዕኔተኔሃ ዱአ አኣም ወክት ጉዕመንከ ሙንዲኖን ዱአ አኣሚት። ");
INSERT INTO alw_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","ወዕኔ በሬች ጀመር ከበሬ ኢለ ተሽት ላገተ ኢን ሜጡበ እኬን አቴንተቤቺሃ መገኑ ገለትጫም። ");
INSERT INTO alw_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","ከ ጡመ ሆጉተ ክዕኔን አኦተ ጀመሮ መገኑ መሲህ ኢስ አሜተኖ በር ሹሎተ ኢለ አገረኖገ አመዕናም። ");
INSERT INTO alw_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","ቴሱ ኡሱር ምኔን ዮም ወክትለከ ኡሱረምችኤ ብርተ እንጂል ሀንቂሃ ከዕመቀሞተለከ እሱንከ ጠረኝሲሃ አኣም ወክት መገኑ ኣስቶንከስ ኣሴኤ ዕድሊን ጉዕሙንኩክዕኔ ቤቀማኑተ እኬንተቤቺሃ አዕኑ ጉዕመ ወክት ቀልቤንከኤ ዮንተ። ህካን እኮቤቺሃ ክዕኔተኔሃ ሞጮጨመኖኤሁ ሀንቅሃን። ");
INSERT INTO alw_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","መሲህ ኢስ ኢታን ጉዕመንከክዕኔ ሄንከ ሱናሚት ጎሬ መገኑ ደገኖ። ");
INSERT INTO alw_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","ኢተክዕኔ ኤንኬዕኑለከ ሀይመተ ሰውዩ ዊሞሀ እክ ነጰን መረኖገ ዱአ አኣም። ");
INSERT INTO alw_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","እስን ጡመ ጠወ አጥራመቴን ደጎኖተለከ መሲህ ፈንቀል አሜተኖ በር ነጣኑተለከ ሙልሲሰኖ ጠዉ ዮህዕኔበእረ እኬን ደገንቶኖታት። ");
INSERT INTO alw_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","ህትን መሲህ ኢሲን ደገመኖ ፈይመ ላልቺን ዊንቴን መገኒሃ ኬዕምኝለከ ገለት ደግሲሴነንታሃ እኬነንተ። ");
INSERT INTO alw_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","አመኤ ኦሶ! ኢ አሌን ኢሌ ጠዉ ጉዕሙንኩ እንጂሉ አበ አልባዕለኖገ አኡስ ደጎኖተ ሀሳም። ");
INSERT INTO alw_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","ህካን እኮቤቺሃ አን ኡሱረሞሚሁ መሲህተኔሃ እሁስ ሮም ዎም ምኒ ዘበኛኑትለከ ዎሉ ህከኔ ዮ መኑ ጉዕሙንኩ ደጋአ። ");
INSERT INTO alw_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","ቀርቾን አመዕንቶ አመኦሶች ልግቡሰ ኢ ኡሱረምተኔሃ ቀርቾን አመዕነንት መገን ላገተ ዎዕኔች በትስ ዋጅቱዕነ መለልት ዱዱብስታኢት። ");
INSERT INTO alw_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","እኮጎሬ መት-መቱ መኑ መሲህተኔሃ ዱዱብስታኢሁ አቄሻንትለከ ዎሉሰ ጢቄኒት፤ ጠዉ እኮጎሬ ዎሉስ መኑ መሲህተኔሃ ጡመ ቀልቢን ዱዱብስታኢት። ");
INSERT INTO alw_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","እሰ ተሽት ላገተ ፈየ ቀልቢን ዱዱብስታኢሁ ኢታች ኬዕዮሀኒንት፤ መሰንትስ አን ኡሱረሞሚሁ ተሽት ላገተ ሀንቂን ሰበኮተ አጰማምገ ደጋቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","ጠዉ እኮጎሬ አቄሻንለከ ጢቄን መሲህ ዱዱብስታኢሁ ሀንቂን እሁዕነ ገዉሰ ኢቲንለከ ኡሱረምኤ አሌን ዎልት ኦርሸተ በርግታኢሃ አጉጆሰቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","መሃ እኮጎሬ ሀካንስ እኮጎሬ ጉዕማንከ ዎቄን አመሰሊን እኮ ሀንቂን እኮ እቃ መሲህተኔሃ ዱዱብሰመኖቤቺሃ ሙንደኣም። ");
INSERT INTO alw_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","ከኒች ኤተሪሃ ሙንደኣም፤ መሰንትስ ክዕኔ ዱኢንለከ መሲህ ኢስ ጠሊለ አያኒ ሀዕለንሺን ዮኤ ኦርሻች ፉላምገ ደጎምቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","ህካን እኮቤቺሃ መ ጠዊኒ ሙላምበእገ ዊሙ ሃሽኣቱትለከ ተብሶሁ ዮኤ፤ ጠዉ እኮጎሬ ጉዕመ ወክት አኣምሀንገን ቴሁ ሄዕዮምጎሬ ህከረንገ ሬዮምጎሬ መሲህ ዊመ ጅስምኤ አሌን ሎረ እሀኖገ ዊሙ መለሉ ዮኤ። ");
INSERT INTO alw_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","ህካን እኮቤቺሃ ኢ ሄኡ መሲሂን ሄኡሃን፤ ሬሁተ እኮጎሬ ኤሳሃ ደግለለኖኤሃን። ");
INSERT INTO alw_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","ጠዉ እኮጎሬ ፎሊን ሄዕዮምጎሬ ላልቹ ዮስ ሆጉተ ቀርቺሃ አኦተ አታላም፤ እኮጎሬ ሬሆችለከ ሄኢች ሀካንስ መጠራም ጎር ደጎምበአ። ");
INSERT INTO alw_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","ከን ለሞ ጠዋን ቀልቡኤ ለሙ ቤቹ እኮኡ፤ እስን መቶ አዲን ከን ሄኢች አደ እክ መሲህን እሆተ ሀሳም፤ መሰንትስ ሁኩን ጉዕመርቺችን በተአኖሃ እኮቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","ጠዉ እኮጎሬ አን ሬሁዕነ ፎሊን ሄዕዮምጎሬ ክዕኔሃ በትሽ ጡመሃን። ");
INSERT INTO alw_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","አን ከ ጠወ አመዕንዮም፤ ሁኩንን ሙንዲኑክዕኔለከ አመዕነቱክዕኔ ነጰኖገ ሬሁዕነ ፎሊን ሄኣምገ ደጎም። ");
INSERT INTO alw_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","ህካን እኮቤቺሃ አን ክዕኔኤን ለንኪሃ ደቀሞምጎር ኢ መሳን መሲህ ኢሳን ዮህዕኔ ቦኑ አበ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","ጉዕሚችን በትሴን መሲህ እንጅሊሃ ሀስሰኖገ ሄዕዬ፤ አሜች ለዕዮንክዕኔጎሬ ህከረንገ ክዕኔች ቄዕር ክዕኔተኔሃ ሞጮጬምጎሬ መቶ ቀልቢን እንጂል አመዕነትተኔሃ ሜጡበ እኬን አጰንቴነንተገ ደጋም። ");
INSERT INTO alw_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","ክዕኔተ ግባህዕኔረ መ ጠዋኒ ዋጅቶኖቼ፤ ኩንን እሳሃ በእሰተ መላ፤ ጠዉ እኮጎሬ ክዕኔሃ ጡምተ መላ፤ ሁኩንን መገን አዲቺት። ");
INSERT INTO alw_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","መሰንትስ መሲህን አመዕንቶኖተ ጠለዕል እሁዕነ እስተኔሃ ኦርሸተ ቶጎኖተ ኩን ኣሰሞህዕኔ። ");
INSERT INTO alw_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","ህካን እኮቤቺሃ አዕኑ ከኒች ብርተ አጰንሸኤ ለኤንታአ፤ ቴሁ ኢ አጰንሸ ለኤነንታት፤ አዕኑሁ ህትናሙ አጰንሸ አጰንቴነንተ። ");
INSERT INTO alw_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","መሲህን እኬንተቤቺሃ መት-መቱክዕኔ ሸዜነን ጠረኝቴንታአ፤ ህትን እስ ኢታን ጠረኝጨቀንቴነንተ፤ ህትን ጠሊለ አያኒን ሜጡ እኬንታአ፤ ህትን መት-መቲሃክዕኔ ጡምመትለከ ጎደበ ላፍመተ ለሊሴንታች፥ ");
INSERT INTO alw_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","ህካን ሰውቲን፥ ኢታንለከ ቀልብን ሙርስጭቴን ሜጡ እኬን ሙንዲሲሼኤ። ");
INSERT INTO alw_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","ገዉ ኢቲን ህከረንገ ቦኒን መቱርቹ አቶኖቼ፤ ጠዉ እኮጎሬ ዎሉ መኑ ክዕኔች ቆሀኖገ ገዉ ሆፍሲን ዎለዕዬ፤ ");
INSERT INTO alw_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","ህትን ገገዉክዕኔ ዎሎ መን መኩተ ሀሼ ቤሉ ገይክዕኔ መኩተ ጠለዕል ሀሶኖቼ። ");
INSERT INTO alw_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","ህትን ኩ መሲህ ኢሳን ዮ ሰውቱ ክዕኔ በላን ሄኡን። ");
INSERT INTO alw_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","እስ መገኑ እኮጎሬ መገኒን ቅጡ አአኖ ሀል አፍ አገሮተ ሀሾበአ ");
INSERT INTO alw_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","ጠዉ እኮጎሬ ሮስ ደነ አፎ መነ እኮ ገውስ ኦነ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","ገዉስ ሆፍሽ ሬሆተ ኢለ መስቀል አሌን ሰቀለም ሬሆተ ኢለ አዘዘሞ። ");
INSERT INTO alw_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","ህካን እኮቤቺሃ መገኑ ጉዕሚችን አሌ ዋሽ ኬዕምኝ ቤቾን አዕዮስ፤ ጉዕመ ሱዕሚችን ሎረ ሱዕመ ኣሴስ። ");
INSERT INTO alw_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","ህካን እኮቤቺሃ ኢስ ሱዕም ኬዕምኝተኔሃ ኡላን፥ ሰማንንለከ ኡለ ኣዜን ዮሩ ጉዕሙንኩ ጉሉቤንከሰ ጉሉጵታአ። ");
INSERT INTO alw_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","ህትን አረቤንከሰን «መሲህ ኢስ ቀርቹሃን» ይት መሰከርት አነ መገኒሃ ኬዕምኝ ኣታአ። ");
INSERT INTO alw_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","ህካን እኮቤቺሃ ኢ ጃላ! ጉዕመ ወክት አዘዘንቴንተኤገን ክዕኔቤቾን ሄዕዮም ወክት ጠለዕል እሁዕነ በትሽን ቴሱ ክዕኔች ቄዕሬም ወክትሃ ጡሙክዕኔ ለሊሳ ሆጉተ ዋጅንለከ ሁጢን አዕዬ። ");
INSERT INTO alw_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","መሰንትስ እስ ጡመ ስውት ሀሶኖተለከ አቶኖተ ክዕኔ ኣዜን አአኖሁ መገኑሃን። ");
INSERT INTO alw_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","ጉዕመንከ ሆጉተ አቴነንተ ወክት ቁንቁቶኖቼ፤ ህትን ኦዶኖቼ። ");
INSERT INTO alw_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","15","ህካን እኮቤቺሃ አዕኑ ከን ሂለ ክልቀት በላን ሆፍኙለከ ህንቄኖህዕኔርቹ ዮህዕኔበኢሃ ነጣኑተ መገን ኦሱተ እኬን ዱንያ አል መኒሃ ኑር እኬን ለሊሴነንተ። ");
INSERT INTO alw_vpl VALUES ("PP2_16","080_2_16","PHP","2","16","16","ኩን እሀኖንኩ ሄኡ ደገመኖ ላገተ ሙርቶኑዕናን ጠረኝሴን አፊኒት፤ ከን ሃሌን ደጉዱኤ እኮ ሆጉኤ ተሰ እክ ፈቃበእቤቺሃ መሲህ ፈንቀል አሜተኖ ወክት ድከኣም ሄአኖኤ ዩሃን። ");
INSERT INTO alw_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","አዕኑ መገኒሃ አመዕነቲን ሆንጠህሴንተ ክትምለከ ክድመ አሌን አኒሁ ዱንተአኖ ክትምገ ሆንጠኮምጎሬ ክዕኔን ጉዕሚንከክዕኔ ሜጡበ ተሽ የኖኤ። ");
INSERT INTO alw_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","ህትን አዕኑሁ ኢንን ሜጡበ ሙንደኤነንተ። ");
INSERT INTO alw_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","ቀርቹ ኢስ ዬጎሬ ክዕኔተኔሃ ሞጮጭ ሙንደኦተ ጢሞትዎሴ ደዕል ክዕኔቤቹ ሶሆተ ተብሳሃ አኣም። ");
INSERT INTO alw_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","ክዕኔተኔሃ ጡመ ቀልቢን ሰውየን ሻዘኖሁ ጢሞትዎሴገ ዮኢሁ አዪሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","ዎሉ ጉዕሙንኩ ገይሰ ጠው ቤሉ መሲህ ኢስ ሆጎተ ሰውይቶበአ። ");
INSERT INTO alw_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","ጠዉ እኮጎሬ ጢሞትዎስ ቤቱ አነስ ካደመኖሀንገን ኢን ሜጡበ እክ እንጂለ ካደሚንከስለከ አመዕነንሸስ መሰከርሲሱስ አዕኑሁ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","ኢ ጠዉ መ ደረጀተ ኢለኖ ጎሬ ለዕዮሚች ኤተሮን ጢሞትዎሴ ደዕል ክዕኔቤቹ ሶሆተ ተብሳሃ አኣም። ");
INSERT INTO alw_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","ህትን አን ገዉንኩእ ደዕል ክዕኔቤቹ አሜቶተ አታላምገ ቀርቹ ሀዕለኖኤገ አመዕናም። ");
INSERT INTO alw_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","ህትን ኤሳሃ ሀሲሰኖኤርቺን ጉዕሚን ሀዕሎኤተ ሶኬንተ አመኤቤቱ ኤጳፍሮዲቱሴ ክዕኔቤቹ ሶሁ ሀሲሰኖሃ እክ ደጎም፤ እስ ኢን ሜጡበ ኡሬ ዎታደርቹለከ ሆጎኤ ጃለ እክ አአን ዱንክዮሃን። ");
INSERT INTO alw_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","እሱ ክዕኔቤቹ ሶሃሚሁ ጉዕመንከክዕኔ ለኦተ ሱኞገለከ እስ ጥዙስ ሞጮጭቴንተቤቺሃ አበ ጨነቀሞኡ። ");
INSERT INTO alw_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","ሀንቅንከ እስ አበ ጥዥ ሬሆተ ሆንጠኮ እቅ፤ ጠዉ እኮጎሬ መገኑ መረርሲጭ ፈይሾስ፤ ጠለዕል እስ እሁዕነ ኤሳሃ መረርሲጬቤቺሃ ሻዙተ ሻዞ አሌን በርገመኖኤበእገ አዕዮ። ");
INSERT INTO alw_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","ህካን እኮቤቺሃ አዕኑ እሱ ለንኪሃ ለኤን ሙንደኦኖተለከ ኢ ጨነቀሙ ቢሎተ አን እሱ ክዕኔቤቹ ደዕል ሶሆተ አበ ሀሾም። ");
INSERT INTO alw_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","ቴሱ ቀርች ሱዕሚን አመዕናንቹ እኮቤቺሃ አበ ሙንዲኖን ቶጌስ፤ ህትን እስገ ዮ መነ ጉዕመንከ ከበጅዬሰ። ");
INSERT INTO alw_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","መሰንትስ አዕኑ ግደኖን ሄኤን አቶኖኤተ አታልቴንበ ሀዕለንሸ እስ ደግለሎኤተ መሲህ ሆጎተ ነብሳስ ህግሽ ኣሲን ሬሆተ ኢለ አጰሞኡ። ");
INSERT INTO alw_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","አመኤ ኦሶ! ቀርቾን ሙንደዕዬ፤ አን ከኒች ብርተ ከተቦንክዕኔሃ ፈንቀሽ ከተቦንክዕኔ ጎሬሁ ህፈትሰኖኤበአ፤ ሁኩንን ክዕኔተ አደጊች ጉዕሚችን አገሮህዕኔተ አታለኖ። ");
INSERT INTO alw_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","ዉሸገ ንጃስሳሀኑኡችለከ ሂለ ጠወ አታሀኑኡች አገዕርዬ፤ ህትን ህለተ ሆጉተ አታሀኑኡችለከ ክዝብ ጡርከመሚች አገዕርዬ። ");
INSERT INTO alw_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","ነኡ መገን ጠሊለ አያኒን ሰገንዳምረለከ መሲህ ኢሲን ድከዕናምረ እንኮምቤቺሃ ሀንቂን ጡርከመሞምረ፤ ጠዉ እኮጎሬ እሰ ህትናመተበአ። ");
INSERT INTO alw_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","ህትን አን ማሊን እኮ እቃ ድከኣሚሁ ዮኤ፤ አዪሁ ማሊን ድከአኖሁ ዮሲሃ አጉጆስእቃ አን ድከኣም ልግቡ ዎቆ ዮኤ። ");
INSERT INTO alw_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","አን እለሞም ህዜትቅ በር ጡርከመሞምየ፤ ቢንያሜ ደቦች እኮም እስራኤላውቹሃን፤ ከኒች ኬዕዮሀኒን ነጠ እኮም ዕብራውቹሃን፤ አይሁድ ሕገ አገዕሪን እኮ እቃ ፈርሳውቹሃን። ");
INSERT INTO alw_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","ሀይማኖትሃኤ ይ መሲህ ኢሳን አመዕንቶረ ሸራምሃ እቅ፤ ህትን ሙስ ሕገ አገዕሪን ፈይተኔሃ እኮ እቃ ኩሌኖኤርቹ ዮኤበአ። ");
INSERT INTO alw_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","ጠዉ እኮጎሬ ከኒች ብርተ ኤሳሃ ደግለለኖኤ ዬሚሃ ጉዕመንከ መሲህተኔሃ ይ ተሰ ጠውገ አዕይ ዎለኣንሰ። ");
INSERT INTO alw_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","ጠለዕል ህካን እሁዕነ ቀርቹኤ መሲህ ኢሰ ደጉ ዎሎርቺች ጉዕሚችን በተአኖሃ እኮቤቺሃ ሁኩን ጉዕሙንኩ ክሳርገ ዎለኣንስ፤ እስተኔሃ ጉዕመርቹንከ አጉሮም፤ መሲሁ ደኦተ ጉዕመርቹንከ ቶሬመ ሁርገ ዎለኣም። ");
INSERT INTO alw_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","አን ሕገ አገሪን ደኣም ገይኤሃ እኮ ፈዩት ዮኤበአ፤ መሲህ አመዕኒንለከ እሲን ሜጡበ እሂን ደገንታ ፈዩት መገን ቤቺች አሜታ ፈዩት ቴሱ ዮኤ። ");
INSERT INTO alw_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","አን መሲህ ደጎተለከ ሬሆች ኬእስ ዎልቀተ ደጎተ ሀሳም፤ አን እስ ኦርሸተ ቤቀሞተለከ ሬሆንከስ እሱ አጉዶተ ሄዕላታም። ");
INSERT INTO alw_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","ህትን ሬሆች ኬኣምገ ተብሳሃ አኣም። ");
INSERT INTO alw_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","ህካን ጉዕመንከ ደእዮምበአ፤ ህከረንገ መገኑ ሀሰኖ ሃሊን ሆሮ አን ዊማበአ፤ ጠዉ እኮጎሬ መሲህ ኢስ ኤሳሃ ገይሲሃ አዕዮኤቤቺሃ ሽልማት ደኦተ ብርተ ዋሽ ደጉዱ አጉራምበአ። ");
INSERT INTO alw_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","አመኤ ኦሶ! አን ህካን ገይኤሃ አዕዮምሀንገ ዎለኣምበአ፤ ጠዉ እኮጎሬ መቱ ጠወ አኣም፤ ሁኩንን ኤተርንከኤ ዮኢሃ ሀበን ብሬንከኤ ዮኢሃ አፎተ ደጉዳም። ");
INSERT INTO alw_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","መገኑ መሲህ ኢስ አዲን ገኤኤሁ ሰሜች ደኣም ዋገ ዘማን ጉዕሚንከ ሄኡ ደኦተ ኢሉ ሀስሰኖኤቤቹ ኢሎተ ደጉዳም። ");
INSERT INTO alw_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","ቴሱ አመዕነቲን ጠረኝኖምሩ ጉዕሙንኩ ካን አጉደኖ ሰውቱ ሄኦኔተ ሀስሰኖ፤ አዕኑ አደ እኮ ሃሊን ሰውይቴንተ ጎሬ መገኑ በራሃ አዕይ ለሊሰኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","ህካን እኮቤቺሃ ቴሱ ኢለ ደዕኖም ሀንቅ ጠረኝንስ አንፎ። ");
INSERT INTO alw_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","አመኤ ኦሶ! ኤሳሃ አጉዴነንተረ እኬ፤ ነኡ ዎልሀስ ምሳልተ እንኮምገን ህካን አጉደን ሄኣረ አጥራመቴን ለዕዬ። ");
INSERT INTO alw_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","መሰንትስ ከኒች ብርተ ልግብ ወክት ኩሎምገን ቴሁ ኦአን ኩላንክዕኔ፤ ልግቡ መኑ ሄእንከስ መሲህ መስቀሊሃ ዲነ እክ ሄኣገ አአኖሰ። ");
INSERT INTO alw_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","እሳሃ ጎደቡሰ መገኑዋሰ፤ ሙልሲሰኖርቹ እሳሃ ኬዕምኝየሰ፤ ሰውቱሰ ዱንየ አልየ ጠወ፤ እሰ ኤተሩሰ በኡሃ። ");
INSERT INTO alw_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","ጠዉ እኮጎሬ ኒ ባዱ ሰማሃን፤ ህከንቤቺች አሜተኖ ጡምሳንቹ ቀርቹኔ መሲህ ኢሰ አገርናሚት። ");
INSERT INTO alw_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","እስ ኒ ህከ ህንቀሞ ጅስመኔ ዶር እስ ኬዕምኝ ጅስመ አጉደኖገ አአኖ፤ ህካን አአኖሁ ጉዕሙንኩስ ገይሃስ ጠገመኖገ አአኖ ዎልቃንተሲት። ");
INSERT INTO alw_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","አመኤ ኦሶ! ኢታንክዕኔሁለከ ሱናንክዕኔሩ ሙንዲኑኤ እኬንተሩ ሆጎተኤ አክሊለ እኬንተሩ ቴሱ ቀርቾን ጠረኝቴን ኡርዬ። ");
INSERT INTO alw_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","ኤዎድያለከ ሲንጢኪ ቀርቺን ሜጡ እኬን ሄኦኖተ ኡጫንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","አት አመዕነንቶንት ሆጎኤ ጃለ! ከ ሜንቱ ሀዕልቶተ ኡጫንኬ፤ መሰንትስ ኩ ሜንቱ ቀሌምንጦሴንለከ ሱዕሙሰ ሄእ መጻፋን ከተበሞ ሆጎ ጃላን ሜጡበ እንጂል ላገተ ኢልሶተ ደግለልቶኤረ። ");
INSERT INTO alw_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","ጉዕመንከ ወክት ቀርቾን ተሽ ዩንክዕኔ፤ ቴሁ ያንክዕኔ ተሽ ዩንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","ጡምመክዕኔ ጉዕመንከ መንቤቾን ለልቶኢተ እኩን፤ ቀርቹንኩ አሜቶተ ሆንጠኮኡ። ");
INSERT INTO alw_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","ሀስሰኖህዕኔርቺሃ ጉዕሚንከ ሹኩሩ ዊሞ ዱኢን መገኑ ኡጭዬ ቤሉ መቶርቾን ሻዞኖቼ። ");
INSERT INTO alw_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","መን ኤንኬዕኒች ጉዕሚች ሎረ እኮ መገን ወገሬቱ መሲህ ኢሳን ዮንተቤቺሃ ቀልብክዕኔለከ ሰውትክዕኔ አገረኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","መጨረሻንን አመኤ ኦሶ! ቀልቡክዕኔ ከኒች ጉዕሚችን በተአኖሃለከ ገለትጭሲሰኖ ጡመ ጠዊን ዊንቴንታረ እኬ፤ ሀንቅ እኮ ጠወ ጉዕመንከ፥ ኬዕምኙ ዮ ጠወ ጉዕመንከ፥ ሀቂቀተ እኮ ጠወ ጉዕመንከ፥ ነጠ እኮ ጠወ ጉዕመንከ፥ ኢቴኖ ጠውተኔሃ ጉዕሚንከለከ ሙንዲሲሰኖ ጠውተኔሃ ሰውይዬ፤ ");
INSERT INTO alw_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","ኢች ተማርቴንታሃለከ ቶጌንታሃ፥ ሞጮጭቴንታሃለከ ለኤንታሃ ጉዕመንከ አዕዬ፤ ወገሬት መገኑንኩ ክዕኔን ሜጡበ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","ጠዉ እኮጎሬ ልግብ ወክቲች ኤተሮን ኦርሸኤተኔሃ ሰውዩ ጀመርቴንተቤቺሃ ቀርቾን አበ ሙንደኣም፤ ወክት ደእቴንታበአ ቤሉ ኢተኔሃ ሰውዩ አጉርቴንታበአ። ");
INSERT INTO alw_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","ህት ያም ወክት ሆፈዕዮኤርቺሃ ሻዥበአ፤ መሰንትስ «ዮኤ ጌሱ ኤሳሃ እሀኖኤ» ዩ ተማሮምቤቺሃ ዮኤሀኒን ሙንደኣምሃን። ");
INSERT INTO alw_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","ህካን እኮቤቺሃ ደኡለከ ደኡ ሆጉ ደጋም፤ ጉዕመንከ ጠዋን ጉዕመ ወክት ዱቢን እኮ ጎሪን ደእን እኮ ደኡ ሆግን «ዮኤሁ እሀኖኤ» ዩ ሮሾም። ");
INSERT INTO alw_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","ዎልቀተ ኣሰኖኤ መሲሂን ጉዕመንከ አኦተ አታላም። ");
INSERT INTO alw_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","እኮጎሬ አዕኑ ኦርሸኤ ቤቀማኑተ እኬን ጡመ ጠወ አቴንታኤ። ");
INSERT INTO alw_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","ፍልጵሱሳን ዮንተ መኑ! ወኔችን ኬሽ እንጂል ላገተ ተማርሰን መቄዶን ባዲች ፉሎም ወክት ክዕኔ ቤሉ ዎሉ አመዕናኑት ኣሲንለከ ቶጊን ኤሳሃ ሀዕሉ ሆጉሰ አዕኑ ገዉክዕኔ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","ህትን ተሰሎንቄ ከተማን ሄዕዮም ወክት ሀስሰኖኤርቹ ሶኬን ልግብ ወክት ሀዕልቴንታኤ። ");
INSERT INTO alw_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","አን ለኡ ሀሳሚሁ ከኒች ብርተ አቴንተሀኒች አበ ጡመ ሆጉት በርገንቶታት። ");
INSERT INTO alw_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","ኤሳሃ ሀስሰኖለከ ሀስሰኖሀኒች በትሽ እኮ ሽልማትክዕኔ ኤጳፍሮድቱ አንጋች ቶጎም፤ ሁኩ ክዕኔ ሽልማቱ ጡመ አንጀነተ ዊሞ ክትምገ መገኑ ሙንዲሲሰኖሃለከ መገኑ ቶገኖሃን። ");
INSERT INTO alw_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","ህካን እኮቤቺሃ ኢ መገኑ ዳንጉ ዮበእ ቀባጦችስ መሲህ ኢስ አዲን ሀስሰኖህዕኔ ጠወ ጉዕመንከ በትሽ ኣሶህዕኔ። ");
INSERT INTO alw_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","አናኔ መገኒሃ ዘላለሚሃ ኬዕምኙ እሁንስ፤ ኣሚዕን። ");
INSERT INTO alw_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","መሲህ ኢሳን አመዕንቶ መኒሃ ጉዕሚንከ ወገሬት ኢልሼ፤ ኢን ሜጡበ ዮ አመኤ ኦሱት «ወገሬቴ» ይታህዕኔት። ");
INSERT INTO alw_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","ዎሉ አመዕናኑት ጉዕሙንኩ አደንከ ሮም ዎም ምኔን ካደንታ አመዕናኑንት «ወገሬቴ» ይታህዕኔት። ");
INSERT INTO alw_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","ቀርቾ መሲህ ኢስ ኣስቱት ጉዕሚንከክዕኔ ሜጡበ እኩን፤ ኣሚዕን። ");
INSERT INTO alw_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","መገን ሀስሻን መሲህ ኢሲ አሳቤቹ እኮም ጳዉሎሴችለከ አመኔቤቲች ጢሞትዎሴች ሶሀንቶእተ ሶህኑ። ");
INSERT INTO alw_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","ቈላስያሳን ሄኣሀኑኡ መሲሂን ጠሊልቶ አመዕነንቶ አመዕናኖተ መገኒች አኒችኔ ኣስቱትለከ ወገሬቱ እሁንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","ክዕኔሃ ዱአ አዕናም ወክት ቀርችኔ መሲህ ኢስ አነ መገኑ ጉዕመ ወክት ገለትጭናንስ። ");
INSERT INTO alw_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","መሲህ ኢሳን ዮህዕኔ አመዕነቱለከ አመዕናኖተ ጉዕሚንከ ዮህዕኔ ኢተተ ሞጮጭኖም። ");
INSERT INTO alw_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","ሀንቅ ላገተ እኮ እንጂለ ሄጭ ክዕኔቤቹ ኢሌ ወክት እሲን ዮ ተብሳሃ ሞጮጭቴንታአ፤ ህካን እኮቤቺሃ አመዕነቱክዕኔለከ ኢተክዕኔ እጃረንቶኢሁ ሰማን ተቃጠብ አገረኖ ህከን ተብሴ አሌኒት። ");
INSERT INTO alw_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","አዕኑ እንጂለ ሞጮጭቴንታችለከ መገን ኣስቶ ሀንቅ ደጌንተ በር ጀመር ኩ ኢንጂሉ ክዕኔ በላን እኮሀንገን ኣዱንያ አሌን ጉዕማንን አቶት አሌንትለከ ነጵ አሌኒት። ");
INSERT INTO alw_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","ህካንን ክዕኔተኔሃ መሲህ አመዕነሞ ካዲንቹ እኮሃለከ ኒን ሜጡበ አአኖ ኢተሞ ኤጵፋራ ኩሎህዕኔ። ");
INSERT INTO alw_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","ህትን እስ መገን አያኒን ገገዉክዕኔ ኢተቀሙክዕኔ ኩሎኔ። ");
INSERT INTO alw_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","ህካን እኮቤቺሃ ከ ጠወ ሞጮጭኖም በሬች ጀመር አዕኑ ሀይመተለከ ሰውት ጉዕመንከ መገን ሰውት ደጌነንተ ዊሙ ደጉ ሄኦህዕኔተ ክዕኔሃ ዱአ አኡለከ መገኑ ኡጩ ኡጉርኖምበአ። ");
INSERT INTO alw_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","ህትን ቀርቺሃ ሀስሰኖገ ሄኤነንለከ ጉዕማንከ ጠዋን እሱ ሙንዲሲሴነን ጡመ ሆጎን አቶተ አቶቴነን መገኑ ደጊን ነጵቶኖተ ዱአ አዕናም። ");
INSERT INTO alw_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","አታዕሊን ጉዕመንከ ጠወ አታሊሃ ተቃጠቤንተረ እኮኖተ ቀርቹ ሎረ ዎልቃን ጠረኝመስ ጉዕመንከ ኣሱንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","ህትን ኑር ዎምነት ኣዜን ጠሊላኖን ሜጡበ ርስተ ቤቀንቴነንተገ አበቀዕዮህዕኔ መገኑ አነ ሙንዲኖን ገለትጭዬስ። ");
INSERT INTO alw_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","እስ ቱንስች ዎልቃች ጡምሽኔ ኢተሞ ቤትስ ዎምነቴን ኣንጋምገ አዕዮኔ። ");
INSERT INTO alw_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","እሲን ዎዘም ጩብኔ ማርቱተ ደእኖም። ");
INSERT INTO alw_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","ቤቱስ ለልበ መገን ሀንቅተ ምሳል፤ እስን ክልቀቲች ጉዕሚችን ሀንገፈሃን። ");
INSERT INTO alw_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","መሰንትስ ሰማንለከ ኡላን ዮእሩ ጉዕሙንኩ ለለኖሁለከ ለለኖበእሁ ዎልቃመትለከ ገሽታእሩ ሀለቀትለከ ሹመት ጉዕሙንኩ ከለቀንቶኢሁ እስ አዲንት፤ ጉዕሙርቹንኩ እስ አዲን እሲንከ ከለቀሞኡ። ");
INSERT INTO alw_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","እስን ጉዕመርቺች ብርንተ ሄዕዮ፤ ጉዕሙርቹንኩ አጳቀም ኡሬኢሁ እሲንት። ");
INSERT INTO alw_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","እስን ገይስ ጅስመ እኮ መገን አመዕናኖ ዱእ ምኒሃ ቡዕለሃን፤ እስ ጉዕመ ጠዊሃ ብሬተ፤ ጉዕመ ጠዋንን ዎኔሃ እሆተ ሬሆች ኬእንከስ ዎዕኔሃን። ");
INSERT INTO alw_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","አኑ መገኑ ቤትስ ኣዜን መገኑ ዊመ ዊሚን ሄአኖገ ኢትዮኡ። ");
INSERT INTO alw_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","መስቀል አሌን ዱንተዕዮ ቄጊንከስ ወገሬት አኢን ኡላን እኮ ሰማን ዮ ጠወ ጉዕመንከ እስ አዲን እሲን ሀራርሴእ። ");
INSERT INTO alw_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","ሰውቲንከክዕኔለከ ሂለ ሆጎንተክዕኔ ባለጋረ እኬን መገኒች ቄዕርቴን ሄኤነንተ እቅ። ");
INSERT INTO alw_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","ቴሱ እኮጎሬ ሆፍኙለከ ቀነጤኖህዕኔርቹ ዮህዕኔበእረ ጠሊላኑተ አዕይ እስ ብሬን ሆንጠህሶህዕኔተ መሲህ ጅስምስ ሬሆ አዲን ሀራርሴህዕኔ። ");
INSERT INTO alw_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","አመዕነቲንከክዕኔ እጃረንቴን ጠጰ ገቴን ኡሪን ሞጮጭቴንተ እንጅሊን ተብሴች ሌንቄቅቶኑዕናን ጠረኝቴን ሄዕዬ። አዕኑ ሞጮጭቴንታሁለከ ሰሜች ዎሮን ዮ ክልቀቲሃ ጉዕሚንከ ዱዱብሰሞ እንጂሉ ከኒት፤ አን ጳዉሎስ ከ እንጂሊሃ ካዲንቹ እኮም። ");
INSERT INTO alw_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","ቴሁ ክዕኔተኔሃ ቶጎም ኦርሻን ሙንደኣም፤ መሲህ ጅስመስ እኮ መገን አመዕናኖ ዱእ ምኒሃ ኣኤ ኦርሻች ሆፈአኖሃ ማሊንከኤ ዊንሻም። ");
INSERT INTO alw_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","መገን ላጋች መቱርቹሃ ፌሱዕናን ክዕኔሃ ኩሎተ መገኒች ኣሰሞኤ ኤጋን መገን አመዕናኖ ዱእ ምኒሃ ካዲንቹ እኮም። ");
INSERT INTO alw_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","ኩ ላገት ልግቤ ዘመኒሃ ክልቀቲሃ ጉዕሚንከ ለሉዕናን ምስጥር እክ ሄዕዮ እቅ፤ ቴሁ እኮጎሬ መገኑ አመዕንታ መኒሃ ጉዕሚንከ ለልሾኡ። ");
INSERT INTO alw_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","መገኑ ከ ምስጥር እሳሃ ለሊሾሰ፤ ሁኩንን አይሁደ እህበ መን በላን አበተ ቀባጡ፤ ካን ዩ መሲህ ክዕኔ ኣዜን ሄእሃስ እስን ኬዕምኚሃኔ ተብሳሃ። ");
INSERT INTO alw_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","ነኡ መሲህ አዋጅናም፤ መኑ ጉዕሙንኩ ጉዕመንከ መነ መሲሂን አመዕነቲንከስ ጠረኘ አዕን ሆንጠህንሶተ ሀይመተ ጉዕመንከ ተማርስነን ሸንዛም። ");
INSERT INTO alw_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","እስ ሎረ ዎልቃን ኣዜንከኤ አአኖቤቺሃ ህከን ዎልቃን አጰመን ቆንዶዳም። ");
INSERT INTO alw_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","ክዕኔተኔሃ ሎዶቅ ከተማን ዮ መንተኔሃለከ ህትን እልኤ ለእ ደጋበእ መንተኔሃ ጉዕሚንከ ሄንከ አጰማምጎር ደጎኖተ ሀሳም። ");
INSERT INTO alw_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","አጰማሚሁ ቀልቡሰ ጠረኜሃን ኢታን ሜጡበ እክ ዊመ ቀልብ ደእት መገን ምስጥር እኮ መሲህ ደጋገት። ");
INSERT INTO alw_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","ሀይመለከ ኤንኬዕን ቀባጡት ማጠንት ዮኢሁ መሲህ ቤቾንት። ");
INSERT INTO alw_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","ካን ያሚሁ አዪሁ ጡመ ላጋን ጠወአን ጣንሰኖህዕኔበእገ ይዪት። ");
INSERT INTO alw_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","ማሊን ክዕኔች ቄዕርዮም እቃ ሰውቲን ክዕኔን ሜጡበ ዮምቤቺሃ ጡመ ሴሪን ሄኦንከክዕኔለከ መሲህን ዮህዕኔ አመዕነት ጠረኝመተ ለዕይ ተሽ ይዮኤ። ");
INSERT INTO alw_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","ቴሱ ቀርቾ መሲህ ኢሳን አመዕንቴንተገን እሲን ሜጡ እኬን ሄዕዬ። ");
INSERT INTO alw_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","እሶን ጠጰ አቴንለከ እጃረንቴን ተማርቴንተ ሃሊን አመዕነቶንከክዕኔ ጠረኝቴን ሄዕዬ፤ ዊም ደፈፎ ገለት ሆንጠህሼ። ");
INSERT INTO alw_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","መሲህ አሌን እሁዕነ መን ሮሲንለከ ከን ኣዱንያ አሌን እጃረሞ ሴሪንለከ ተሰ ጣንሲን አዪሁ አግ መሰኖህዕኔበእገ አገዕርዬ። ");
INSERT INTO alw_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","መገን ጉዕመ ዊምመት ጅስማን ለልት ሄኣኢሁ መሲሂንት። ");
INSERT INTO alw_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","ህትን አዕኑ ዊመ ሄኡ ደዕቴንታሁ ክልቀት ጉዕም አሌን ገሽለከ ሹምነት ጉዕም አሌን ሎረ ገሻንቹ እኮ መሲህ አዲኒት። ");
INSERT INTO alw_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","እሲን ሜጡ እህንከክዕኔ ጡርከመንቴንታአ፤ ሁኩ ጡርከሙንኩ ጩበኘ ጅስመ ከሞተ መሲሂን እኮሃ ጡርከሙ ቤሉ መን አንጋን እኮበእሃን። ");
INSERT INTO alw_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","ጠመቀንቴንተ ወክት መሲሂን ሜጡበ ሞገንቴን ጠመቀሚንከክዕኔ መሲህን ሬሆች ኬኤንታአ፤ ሁኩንን መሲህ ሬሆች ኬሾ መገን ዎልቃን አመዕንቴንተቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","አዕኑ ጩብ አእንከክዕኔለከ ጩብክዕኔ ጅስመ ጡርከሙ ሆግንተክዕኔ ሬቴንታእረ እቅ፤ ቴሱ እኮጎሬ መገኑ ጩብክዕኔ ጉዕመንከ «ፈቁን» ይ መሲሂን ሜጡበ ሄኤነንተገ አዕዮህዕኔ። ");
INSERT INTO alw_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","እስ ህከ ከሰሰኔለከ ግበኔ ሄዕዮ ኤዴ ቤሱኔ ለልሶተ ከተበሞ ሕገ ሽንሼእ፤ ህካንን መሲህ ኢስ መስቀል አሌን ሰቀል ኒ አልች ከሞ። ");
INSERT INTO alw_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","ህትን ዎልቃመተለከ ዳኛኑተ መስቀል ዎልቃን ቄል በነቻን ዘህሰን መኑ ጉዕሙንኩ ለአኖሰገ አዕዮሰ። ");
INSERT INTO alw_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","ቴሱ እቸተኔሃ እኮ እቃ፥ አግተኔሃ እኮ እቃ፥ በዓል በሬተኔሃ እኮ እቃ፥ አገኑ ኣገኖ በርተኔሃ እኮ እቃ፥ አበ በሬተኔሃ አዪሁ አሌንከክዕኔ ፈረዱንከ። ");
INSERT INTO alw_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","ሁኩን ጉዕሙንኩ አሜቶተ ዮ ጠዊሃ ሀላሃን፤ እኮጎሬ ሀንቁስ ደገመኖሁ መሲሂንት። ");
INSERT INTO alw_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","ክዝቢን ገው ሆፍሲንለከ መላይካተ ሰገዲን ድከአኖ መቱ መንቹሁ ዋግቤሉ ፌሰኖህኔበእገ አገርዕዬ፤ ህትኔ መንቹ ለአኖ መናማን ጌሲች አበ ገውስ ቦነን ጩብስ ሰውቲን ተሳን ቦነኖ። ");
INSERT INTO alw_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","ቡዕለ እኮ መሲህን ህትናሞ መንቺን መቱርቹሁ ደቀንሹ ዮስበአ፤ ጅስሙ ጉዕሙንኩ ንጊንለከ ቡንቺን ሜጡበ እክ መገኑ ነሰኖ ሃሊን ነጵቶተ እቸተ ደእታኢሁ ቡዕል አዲኒት። ");
INSERT INTO alw_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","መሲህን ሜጡበ ሬቴን ከን ኣዱንያ አል ዎጊች ሹልቴን አደ እኬንታች ቴሱ ኣዱንያ አልች አደ እህበ መንገ ሚሃት ህትኔ ትዛዝሃ ጠገንቴነንታት። ");
INSERT INTO alw_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","ትዛዙንኩ አፎት፥ ቀመሶትለከ ኡልቶት የኖሃን። ");
INSERT INTO alw_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","ከ ጉዕመንከ ጠወ ጠወኣኢሁ ጥቅም ኣቶች ኤተሮን በአኖ ጠውጋት፤ እሰን መኑ ፉሼሃ ትምርትሃለከ ትዛዝሃ ጠለዕለ። ");
INSERT INTO alw_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","ኩ ትዛዙንኩ ገግሰ ሀስሻች ሰገደን፥ ገዉ ሆፍሲንለከ ገይ ጅስመ ሚዕረን ህካን አኦተ አጰሚንከስ ሀይመት ዮስሃ አጉደኖ፤ ጠዉ እኮጎሬ ሁኩን ጅስም ሂለ ጠወ አገዕርሃ መቱርቹሃ ደግለለኖበአ። ");
INSERT INTO alw_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","ቴሱ መሲሂን ሜጡበ ሬሆች ኬኤንተቤቺሃ አሌ ሰማን መሲህ መገን መኬ አዲን አፉዕል ዮቤቾን ዮ ጠወ ሀሼ። ");
INSERT INTO alw_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","አሌ ሰማን ዮ ጠውተኔሃ ሰውይዬ ቤሉ ኣዱንያ አሌን ዮ ጠውተኔሃ ሰውይቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","መሰንትስ አዕኑ ሬቴንተቤቺሃ ህትን ሄኡክዕኔ መሲሂን መገን ኣዜን ማጠሞኡ። ");
INSERT INTO alw_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","ሄኡክዕኔ እኮ መሲህ አሜተኖ በር አዕኑ እሲን ሜጡበ ኬዕምኚን ለልቴነንተ። ");
INSERT INTO alw_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","ቴሱ ከን ኣዱንያ አሊች እኮ ማልክዕኔ ሄዕላቸተ ጉዕመንከ ሽዬ፤ ሁኩንን ዝነተ፥ ኣዝ ንጃስመተ፥ ማል ሂለ ሄዕላቸተለከ ሽርኬተ ሰገዱ እኮ ሄዕላቸታን። ");
INSERT INTO alw_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","ከን ጠው መሳን አዘዘምበ መን አሌን መገን ኡሙዕርት አሜታአ። ");
INSERT INTO alw_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","አዕኑ ገዉክዕኔ ከኒች ብርተ ህከ ጠወ አቴነን ሄኤነንተረ እቅ። ");
INSERT INTO alw_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","ቴሁ እኮጎሬ ኡሙዕርተ፥ ንዴቱ፥ ሂልመተ፥ ቦሮዕረንሸ ክዕኔች ከሜ፤ አፌች ፉለኖ ሙልሰኖ ጠዉሁ አፌችክዕኔ ፉሉንከ። ");
INSERT INTO alw_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","መሰንትስ ኑባጴ መንቹ ሆጎንተስ ፉሽቴን ኡጅቴንታች መት-መትሃክዕኔ ክዝብ ጠወኦኖቼ። ");
INSERT INTO alw_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","ካልቅ ደነ አጉዲሃ ኤንኬዕኒን ሃዕሮ እኮ መንቹ ኦደዕዬ። ");
INSERT INTO alw_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","ህከን ግርክለከ አይሁድ በላን ህከረንገ ጡርከመሞለከ ጡርከመምበ መን በላን ህከረንገ ኤንኬዕናሙለከ ገው በላን ህከረንገ ሰዎልድቹ ህከረንገ ሮስች በላን አደዶመት ዮበአ፤ ጠዉ እኮጎሬ መሲህ ጉዕመ ጉዕሚኒት። ");
INSERT INTO alw_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","መገን መጠረንቴንተ ጠሊላኑተ ኢተንቴንታእረ እኬንተቤቺሃ መረርሲጩ፥ ጎደበ ላፍመተ፥ ጡምመተ፥ ገው ሙግ አኡ፥ አታዕሉ ኦድኖገ ኦደዕዬ። ");
INSERT INTO alw_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","መት-መትክዕኔ ጠወ አታሌ፤ መቱክዕኔ መትክዕኔ አሌን ጎደበ አፌንተ ገዱት ዮህዕኔጎሬ ፈቁን የቀሜ፤ ቀርቹ «ፈቁን» ዬገን አዕኑሁ «ፈቁን» ዩ ሀስሰኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","ከን ጠውችን አበ ጉዕመንከ ጠወ ጭምአዕይ አፈኖ ዊመ ሜጦመተ ደግሲሳ ኢተተ ኦደዕዬ። ");
INSERT INTO alw_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","መቱ ጅስመ እኬን ገአንቴንታሁ ወገሬቲሃ እኮቤቺሃ መሲህ ወገሬቱ ቀልብክዕኔ ሀላዕሉን፤ ህትን ገለትጭቴነንተረ እኬ። ");
INSERT INTO alw_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","መሲህ ላገት ኣዜንከክዕኔ ዊንት ሄኡን፤ መት-መቱክዕኔ ሀይማን መት-መቱክዕኔ ተማርስዬ ህትን ሸጫቀሜ፤ መዝሙሪን፥ ዝክሪን፥ ጉዕመ መዝሙሪን መገኑ ቀልቢንከክዕኔ መዝሙሪን ገለትጭዬ። ");
INSERT INTO alw_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","አነ መገኑ እሲን ገለትጭቴነን ላጋን እኮ እቃ ሆጎን አቴነንተ ጠወ ጉዕመንከ ቀርቾ ኢስ ሱዕሚን አዕዬ። ");
INSERT INTO alw_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","ምኒ አማኖ! ቀርቾ ኢሲሃ ሀስሰኖሃ እኮቤቺሃ ምኒክዕኔ አኒሃ አዘዘሜ። ");
INSERT INTO alw_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","ምኒ አናከ! ምኒክዕኔ አማኑተ ኢትዬ፤ ጎደበ ጠረኝቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","ኦሶ! ኩን ቀርቹ ሙንዲሲሰኖ እኮቤቺሃ ጉዕመርቾንን አናካተክዕኔለከ አማኖተክዕኔ አዘዘሜ። ");
INSERT INTO alw_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","አናከትለከ አማኑት! ተብሳ ሙርታበእገ ኦሱክዕኔ አሙዕርት ገዝ ገዝ ይታገ አቶኖቼሰ። ");
INSERT INTO alw_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","ሮሶመ ሴራን ዮንተሩ! መነ ሙንዲስሲሃለከ ለሊሃ እሁዕነ ጡመ ቀልቢን ቀርቹ ዋጅቴነን ኣዱንያ አል ቀርቻኖተ ጉዕመርቺንን አዘዘሜ። ");
INSERT INTO alw_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","አቴነተርቹ ጉዕመንከ መኒሃ እሁዕነ መገኒሃ አቴነንተሀንገ አቴን ዊመ ቀልቢንከክዕኔ አዕዬ። ");
INSERT INTO alw_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","መገን ቤቺች ሌቄገ ኣእቴነንተ ርስቱ ዮገ ደጌነንተ፤ ካደንቴነታንኩ ቀርቹ መሲሂት። ");
INSERT INTO alw_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","ሂለ አዕዮ መንቹ ሆጎስ ወጥ ደአኖ፤ መገን አኔን ጎልትት ዮበአ። ");
INSERT INTO alw_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","ቀርቻኖ! ክዕኔሃ ሰማን ቀርቹ ዮህዕኔገ ደጌነንተቤቺሃ ካደንታህዕኔረ ጡምማንለከ ቅጡ አቴን ገሽዬሰ። ");
INSERT INTO alw_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","ገለትጭቴነን ጉዕመንከ ወክት ጠረኝቴን ዱአ አዕዬ። ");
INSERT INTO alw_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","አን ኡሱረኘ እኮሚሁ መሲህ ምስጥር አዋጆተ መገኑ ላገስ ኡሩተ ፈኖኔተ ኔሳሃ ዱአ አዕዬ። ");
INSERT INTO alw_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","ህትን ጠወኡ ሀስሰኖኤገ ላገስ መኒሃ ኣጋገ ጠወኦተ ዱአ አዕዬኤ። ");
INSERT INTO alw_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","አብሌ ዮ መኒን ሜጡበ ዮህዕኔ ደቀንሺን ሀይማን ሄዕዬ፤ ደገሞ ገንባቴን ጉዕማን ደግለሸቀሜ። ");
INSERT INTO alw_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","መት-መቶ መኒሃ ሀት አቴን መስለ ኣሱ ሀስሰኖህዕኔገ ደጎኖተ ጠወኡክዕኔ መጥኔገ ጤአኖሃለከ ጉዕመ ወክት ኣስቶን ዊሞሃ እሁን። ");
INSERT INTO alw_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","ኢተሞ አመ ቤቱለከ አመዕነሞ ካድንቹ ኢን ሜጡበ ቀርች ሆጉተ አአኖ ቲቂቆስ ኢ ጠወ ጉዕመንከ ኩለኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","እሱሃ ክዕኔቤቹ ሶኮሚሁ ነኡ ሄዕናም ሀል ክዕኔሃ ኩሎተለከ ቀልብክዕኔ ጠረኝሶታት። ");
INSERT INTO alw_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","እሲንን ሜጡበ ክዕኔ አዲሃ እኮ አመዕነሞለከ ኢተሞ አመኔቤቱ አናሲሞስ አሜተኖ፤ እሰ ከኔ እኮ ጠወ ጉዕመንከ ኩልታህዕኔ። ");
INSERT INTO alw_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","ኢን ሜጡበ ኡሱረሞ አርስጥሮኮስለከ ባርናባሴ ለንካመ ቤቱ ማርቆስ ወገሬቴ የኖህዕኔት፤ ማርቆሴተኔንከ ቃግሾንክዕኔ ሶህኑት ኢልቶህዕኔ፤ ቴሱ ክዕኔቤቹ አሜቾ ወክት ቶጌስ። ");
INSERT INTO alw_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","«ኢዮስጦሴ» ዬን ገኤኖ ኢያሱ «ወገሬቴ» የኖህዕኔት፤ መገን ዎምነትተኔሃ ኢን ሜጡበ አታ መን በላን አይሁደ እኮእሩ ጠለዕል እሳት፤ ኤሳንከ ጠረኝሶኤ። ");
INSERT INTO alw_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","ክዕኔ አዲች እኮ መሲህ ኢስ ካዲንቹ ኤጳፍራ ወገሬቴ የኖህዕኔት፤ እስን ሆሮ ጠረኝቴን ዊመ ዊሚን ረጀ ይቴን መገን ሀስሻን ጉዕማን ጠረኝቴን ኡርቶኖተ ጉዕመ ወክት ክዕኔተኔሃ ዱኢን አጰመኖት። ");
INSERT INTO alw_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","ለንኪሃ እስ ክዕኔተኔሃ፥ ሎዶቅለከ ሂራፖሊስ ከተማን ዮ መኒሃ ጠረኝ አአኖገ ገዉእ መሰከራም። ");
INSERT INTO alw_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","ኢተሞ ሀኪንቹ ሉቃስለከ ህትን ዴማሲ «ወገሬቴ» ይታህዕኔት። ");
INSERT INTO alw_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","ሎዶቃን ዮ አመኔ ኦሱተለከ ቴሁ ንምፉነለከ ምኔንከሴ ዮ መገን አመዕናኖ ዱእ ምናተ «ወገሬቴ» ይዬ። ");
INSERT INTO alw_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","ተ ደብዳቤተ አዕኑ አነበቤንታች ኤተሮን ሎዶቃን ዮ መገን አመዕናኖ ዱእ ምነ በላን አነበበመኖገ አዕዬ፤ አዕኑ ሎዶቂች ሶሀንታህዕኔ ደብዳቤተ አነበቤ። ");
INSERT INTO alw_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","አርኪጳሴንከ «ቀርቺች ቶጎንት ክድመተ መጨረሸስ ኢለ ሹል» ይቴን ኩሌ። ");
INSERT INTO alw_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","ከ ወገሬት ገይኤ አንጋን ከተቦሚሁ አን ጳዉሎሴት፤ ኡሱር ምኔን ዮምገ ሰውይዬ፤ መገን ኣስቱት ክዕኔኤን እኩን። ");
INSERT INTO alw_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","አነ መገንለከ ቀርቾሃ መሲህ ኢስረ እኮሀኑኡተ ተሰሎንቄን ዮ መገን አመዕናኖ ዱእ ምኒ መኒሃ ጳዉሎሴች፥ ሲላሴችለከ ጢሞትዎሴች ሶሀንቶእተ ሶህኑ፤ ኣስቱትለከ ወገሬቱ ክዕኔሃ እሁን። ");
INSERT INTO alw_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","ነኡ ዱአ አዕናም ወክት ጉዕመንከ ክዕኔተ ቃንገን ክዕኔተኔሃ መገኑ ገለትጭናም። ");
INSERT INTO alw_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","አናኔ መገን ብሬን አመዕነቲን አቴንተ ሆጉተ ኢታን ጠረኝቴን አኡክዕኔለከ ቀርቹሃኔ መሲህ ኢሳን ዮህዕኔ ተብሴክዕኔ ጠረኝመተ ጉዕመ ወክት ቃንጋም። ");
INSERT INTO alw_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","መገኒን ኢተንቴንተ አመኦሶ! መገኑ ዶዕሬህዕኔገ ደንጋም። ");
INSERT INTO alw_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","ነኡ እንጂለ ክዕኔቤቹ ኤንቦሚሁ ጠለዕል ላጋን እሁዕነ ወልቃንለከ ጠሊለ አያን እንጂል ሀንቅ አመዕኒንት፤ ህትን ክዕኔን ሜጡበ ሄዕኖም ወክት ክዕኔተ ሀዕልኖተ ሀት እንክ ሄዕኖም ጎር አዕኑ ገውንኩክዕኔ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","ልግብ ኦርሸት እልቶህዕኔ ጎሬሁ ጠሊለ አያኒን ደገንቶ ሙንዲኖን ላገስ ቶጌንታአ፤ ኔሳለከ ቀርቹ አጉዴንታአ። ");
INSERT INTO alw_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","ህካን እኮቤቺሃ አዕኑ መቄዶናንለከ አካይ ባዶን ዮ አመዕናኖተ ጉዕሚንከ ጡመ ምሳልተ እኬንተሰ። ");
INSERT INTO alw_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","ቀርች ላገት ክዕኔች ፉልት ሞጮጨንቶኢሁ መቄዶንለከ አካይ ባዶን ጠለዕል እሁዕነ መገኖን ዮህዕኔ አመዕነቱ ጉዕመ ቤቾን ሞጮጨሞቤቺሃ ከን ጠዊሃ ነኡ መቱርቹሃ ጠወኡ ሀስሰኖኔበአ። ");
INSERT INTO alw_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","ክዕኔቤቹ አሜንቶም ወክት ጡመገ ቶጌነንተገለከ አዕኑ ሽርክክዕኔ ጌኝአቴን ሀንቅለከ ሄአኖ መገኑ ካደሚሃ ሀት እኬን ፈንቀልቴንተ ጎር እሰ ገውንኩሰ ኩልታአ። ");
INSERT INTO alw_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","ህትን መገኑ ሬሆች ኬሾሲሃ፥ አሜታ መገን ኡሙዕሬች ጡምሰኖኔሃ፥ ቤቱስ ኢስ ሰሜች አሜተኖገ ሀት እኬን አገርቴነንተ ጎሬ ኩልታአ። ");
INSERT INTO alw_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","አመኤ ኦሶ! ነኡ ክዕኔቤቹ አሜቱኔ ተሰ እሁ ሆጉስ አዕኑ ገዉክዕኔ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","አዕኑ ደጌነንተገን ከኒች ብርተ ፍልጵሱስ ከተማን ዮም ወክት ኦርሸትለከ ቦሮዕረንሹ ኢሌኔገ አዕኑ ገውንኩክዕኔ ደጌነንተ፤ ጠዉ እኮጎሬ አበ ሀንበዕለንሺን መገን እንጂል ላገተ ክዕኔሃ ጠወዕኖተ መገኑኔ ጠረኝመተ ኣስዮኔ። ");
INSERT INTO alw_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","ነኡ ክዕኔተ ሸንዞንክዕኔሁ ሉጨንሺን ህከረንገ ሂለ ያዳን ህከረንገ ጣንስኖህዕኔተ ሀንስበአ። ");
INSERT INTO alw_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","ጠዉ እኮጎሬ መገኑ እንጂለ ኤገተ ኔሳሃ አመዕን ኣሴኔቤቺሃ ቀልብኔ አጥራመች ደገኖ መገኑ ሙንዲሲስ ቤሉ መነ ሙንዲሲንሶተ ጠወዕናምበአ። ");
INSERT INTO alw_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","መቱ ወክትሃ ክዝቢን ናንደን ህከረንገ ብር ጎራምመት ሄኣኔ ሆሮ አሜቱ ሆጉኔ አዕኑ ገዉንኩክዕኔ ደጌነንተ፤ መገኑ ምስክርሃኔ። ");
INSERT INTO alw_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","ነኡ ክዕኔች እኮ ህከረንገ ዎሎ መኒች አዬችሁ ኬዕምኝ ሀንሶምበአ። ");
INSERT INTO alw_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","ነኡ መሲህ አሳበተ እንኮምገን ሀስሰኖኔሃ ክዕኔች ጠዕምኖተ አታልናም እቅ፤ ጠዉ እኮጎሬ አመት እለሴ አገርታሀንገን ክዕኔ በላን ጎደበ ላፍማን ሄዕኖም። ");
INSERT INTO alw_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","ህትን አበ ኢትናንክዕኔቤቺሃ መገን እንጂለ ክዕኔኤሃ ኩሉ ጠለለ እሁዕነ ነብሳኔ ህግንስ ኣስኖተ ተቃጠንቦም እቅ፤ አዕኑ ኔሳሃ ጤዕንሻመተኔ። ");
INSERT INTO alw_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","አመኤ ኦሶ! ሆጉኔለከ ሆንግኔ ደጌነንተ፤ ክዕኔሃ መገን እንጂለ ጠወዕናንክዕኔ ወክት ክዕኔተ ኦርንሶህዕኔበእተ ሀንከዕርተለከ በራሃ አዕኖም። ");
INSERT INTO alw_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","ክዕኔ አመዕናኖ በላን ሄዕኖም ወክት ነኡ ሀትኔ ጠሊልማን፥ ፈያኑተለከ ቀነጤኖርቹ ዮበእረ እንክ ሄኢሃኔ አዕኑለከ መገኑ ምስክርሃን። ");
INSERT INTO alw_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","አኑ እላተስ አአኖሀንገን ነኡሁ ክዕኔሃ መት-መቲሃክዕኔ አኡኔ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","ጉዕመ ወክት ሸንዘንለከ ጠረኝንሰን ጄነትስለከ ኬዕምኝስ ቤቀንቶኖተ ገኤህዕኔ መገኑ ተሽ የኖ ሃሊን ሄኦኖተ ኤገተ ይኖንክዕኔገ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","ኒች መገን ላገተ ሞጮጭቴንተ ወክት መን ላገገ እሁዕነ መገን ላገገ አቴን ቶጌንተቤቺሃ መገኑ ጉዕመ ወክት ገለትጭናም፤ ሁኩ ላገንት ሀንቅንከ መገንተ ላገ እቅ፤ እሴን አመዕንቴንተ ክዕኔ ኣዜን ቴሁ አታኢት። ");
INSERT INTO alw_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","አመኤ ኦሶ! አዕኑሁ መሲህ ኢስ አዲን መገኑ አመዕኔ መን ጭምት ይሁድ ባዶን ዮእረ አጉዴነንተረ እኬንታአ፤ መሰንትስ እሰ አይሁድ መኒች ኦርሸተ ቶጎገን አዕኑሁ ገይክዕኔ አድ መኒች ኦርሸተ ቶጌንታአ። ");
INSERT INTO alw_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","አይሁድ መኑ ቀርቹ ኢሰለከ ነብያከተ ሽቶእራን፤ ኔሳሁ ሸርቶእራን፤ ህትን እሰ መገኑ ሻዝሳእረለከ መነ ጉዕመንከ ግቦእረ። ");
INSERT INTO alw_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","ህትን አይሁደ እህቡ መኑ ጡምቶተ መገን ላገተ ኩልናምበእገ ከንታኔ፤ ከኒን ጩቢ ጩብ አሌን በርግተን መርታእረ እኮቤቺሃ ኤተር ገዳን መገን ኡሙዕርት እሰ አሌን አሜቶኡ። ");
INSERT INTO alw_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","አመኤ ኦሶ! ሰውቲን እሁዕነ ማሊን አደ እንክ እልተ እሌን ለአቀሙዕነ ቀዉ ጌሰ አገርኖምቤቺሃ ለዕኖህኔተ አበ ሄዕላንቶም። ");
INSERT INTO alw_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","ክዕኔቤቹ አሜንቶተ አበ ሀንሳም እቅ፤ አበንከ አን ጳዉሎስ ክዕኔቤቹ አሜቶተ ልግብ ወክት ሀሾም እቅ፤ ጠዉ እኮጎሬ ሼይጣኑ ከሞኔ። ");
INSERT INTO alw_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","ቴሱ ተብሶኔለከ ሙንዲኑኔ ህከረንገ ቀርቹኔ ኢስ አሜቾ ወክት ብሬስ ቦናም ድሉኔ አዬት? አዕኖትበእንዶ? ");
INSERT INTO alw_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","ኤ ሀንቅያን፤ ኬዕምኙኔለከ ሙንዲኑኔ አዕኖት። ");
INSERT INTO alw_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","ከኒች ኤተሮን አታዕሉ ሆንጎምቤቺሃ ነኡ ጠለዕል አቴን ከተማን ፈቁ ጡመ አጉጅ ለሌኔ። ");
INSERT INTO alw_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","ኒንን ሜጡበ መሲህ ኢስ ተሽት ላገተ ኩለኖ መገን ካዲንቹ አመኔቤቱ ጥማቶስ ክዕኔተ ጠረኝሶህዕኔተለከ አመዕነቶንከክዕኔ ጠረኝቶኖተ ሸዞህዕኔተ ሶንኮም። ");
INSERT INTO alw_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","ሁኩንን ኢልቶህዕኔ ኦርሻን ጠረኝቴን ኡርቴነንተገ አሰኖህዕኔ፤ መሰንትስ ት ኦሪሸት ኔሳሃ መገኒች እኮሃ እሁስ አዕኑ ገዉንኩክዕኔ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","ክዕኔን ሜጡበ ሄዕኖም ወክት ኦሪሸት ኢልታኔገ ሄጭን ኩልኖንክዕኔገን ቴሁ ሁኩ ኦሪሸት ኢልቶኔ፤ ህካንን አዕኑ ደጌንታአ። ");
INSERT INTO alw_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","ህካን እኮቤቺሃ አታዕሉ ሆንጎምቤቺሃ አይደጎ ሻይጣንቹ ፌተነንክዕኔ ቆንዶዱኔ ተሰ በዕዮንዶ ይ ዋጅ አመዕነቱክዕኔ ደጎተ ጥማቶሴ ክዕኔቤቹ ሶኮም። ");
INSERT INTO alw_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","ጠዉ እኮጎሬ ቴሱ ጥማቶስ ክዕኔቤቹ ፈንቀል አመዕነትክዕኔተኔሃለከ ኢተክዕኔተኔሃ ነኡ ክዕኔተ ለዕኖተ ሄዕላንቶምገን አዕኑሁ ኔሳሃ ለኦኖተ ሄዕላቴነንተገለከ ጡመ ጠወ ሰውይቴንተገ ክዕኔተኔሃ ተሽ የኖ ዱዱቡ ኩሎኔ። ");
INSERT INTO alw_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","አመኤ ኦሶ! አበ ኦርሸለከ ሸረም ኣዜን ሄዕኖምጎሬሁ አመዕነትክዕኔ መሳን ክዕኔን ጠረኝኖም። ");
INSERT INTO alw_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","መሰንትስ አዕኑ ቀርቾ ኢሳን ጠረኝቴን ኡሩክዕኔ ኔሳሃ ጡመ ሄኢን ሄዕናምገ አአኖኔ። ");
INSERT INTO alw_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","ክዕኔ መሳን መገን ብሬን ሙንደዕናም ሙንዲኖሃ መገኑ ሄንከ ገለትጭናም። ");
INSERT INTO alw_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","ክዕኔተ ለዕኖህዕኔተለከ አመዕነቶንከክዕኔ ሆፈዕዮሃ ዊንሽኖተ ሀንከዕርተለከ በራሃ ጠረኝንስ ዱአ አዕናም። ");
INSERT INTO alw_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","አነኔ እኮ መገኑኔለከ ቀርቹኔ ኢስ ክዕኔቤቹ አሜንቶተ ዎቃኔ ብዝ አኡን። ");
INSERT INTO alw_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","ነኡ ክዕኔተ ኢትናምገን ገገውክዕኔ ዮህዕኔ ኢተትለከ ዎሎ መኒሃ ዮህዕኔ ኢታን ቀርቹ በትሶህዕኔ ነሶህዕኔ። ");
INSERT INTO alw_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","ቀርቹኔ ኢስ ጠሊላኖን ጉዕሚን ሜጡበ አሜተኖ ወክት መገንኔለከ አንኔ ብሬን ኩሌኖርቹ ዮበኢሃለከ ጠሊላኑተ እኬን ደገንቶኖተ ቀልብክዕኔ ጠረኝሱን። ");
INSERT INTO alw_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","መጨረሻን አመኤ ኦሶ! መገኑ ሙንዲስሲሃ ሀት እኬን ሄኡ ሀስሰኖህዕኔጎሬ ኒች ተማርቴንታአ፤ ቴሁ ህትን ሄኤነንታት፤ ቀርቾ ኢስ ሱዕሚን ኡጭናንክዕኔሁለከ ሸንዛንክዕኔሁ ከኒች ብርተ አቴንተሀኒች በትሴን አቶኖታት። ");
INSERT INTO alw_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","ቀርቾ ኢስ ሱዕሚን ሀትኔ ትዛዝ ኣስኖንክዕኔገ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","መገኑ ሀሰኖሁ አዕኑ ጠሊላኑተ እኮኖታትለከ ዝናች ቄዕርቶኖታት። ");
INSERT INTO alw_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","ክዕኔች ጉዕሙንኩ ጎኑ ምንስ አማን ጠሊልማንለከ ኬዕምኝን ሄኡ ደጉን። ");
INSERT INTO alw_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","መገኑ ደግበ ኡመትገ ማል ሄዕላቸት ጠቅቱንከህዕኔ። ");
INSERT INTO alw_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","ከን ጠዋን አዪሁ አመስ ቤት አሌን ሂለ ጠወ አኡንከ ህከረንገ ጣንሱንከ፤ ከኒች ብርተ ጠረኝንስ ኩልኖንክዕኔገለከ ሸንዞንክዕኔገን ህት አታ መነ ቀርቹ ቀጠአኖሰ። ");
INSERT INTO alw_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","መሰንትስ መገኑ ገኤኔሁ ጠሊልማን ሄዕኖታት ቤሉ ንጃስ እኮ ጠወ አዕነን ሄዕኖታበአ። ");
INSERT INTO alw_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","ህካን እኮቤቺሃ ከ ሸዘነተ ግበኖሁ አዪሁ መነ እሁዕነ ጠሊለ አያነ ኣሴኔ መገኑ ግበኖሃን። ");
INSERT INTO alw_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","ገገዉክዕኔ ኢተቀንቶኖተ አዕኑ ገውክዕኔ መገኒች ተማርቴንታቤቺሃ አመዕናኖ ኢተተኔሃ አዪሁ ክዕኔኤሃ ከተቦህዕኔተ ሀስሰኖበአ። ");
INSERT INTO alw_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","መቄዶን ባዶን ሄኣ አመዕናኑተ ሀንቅንከ ኢትቴነንታት፤ እኮጎሬ አመኤ ኦሶ! ቴሱ ሸዛንክዕኔሁ ዎዕኔች በትሴን ኢትቶኖታት። ");
INSERT INTO alw_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","ከኒች ብርተ ኩልኖንክዕኔሁ አደቢን ሄኦኖታቲ፥ ገይክዕኔ ጠወ አገርቶኖታትለከ አንጋንተክዕኔ አቴን ገልቶኖታት። ");
INSERT INTO alw_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","ህት አቴንተጎሬ አመዕንቡ መኑ ኬዕምሰኖህዕኔረለከ ቡዕለክዕኔ አታልቴን ገልቴንተረ እኬነንተ። ");
INSERT INTO alw_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","አመኤ ኦሶ! ተብሶሁ ዮበእ መንገ ሻዜነንተበእገ ሀሳም፤ መሰንትስ ሬዮ መንተኔሃ ሀንቅስ ደጎኖተ ሀንሳም። ");
INSERT INTO alw_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","ኢስ ሬዮገለከ ሬሆች ኬዕዮገ አመዕንኖም፤ ህካን እኮቤቺሃ ኢሳን አመዕንት ሬቶ መነ መገኑ ኢሲን ሜጡበ ኤበኖሰገ አመዕንናም። ");
INSERT INTO alw_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","ቀርቺች ቶንጎም ላጋን ኩልናንክዕኔ ቀርቹ አሜቶተ ኢለ ፎሊን ሄዕናም ነኡ ሬቶ መነ ሄጭናምበአ። ");
INSERT INTO alw_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","ቀርቹ ገዉንኩስ ትዛዝ ሎረ ላጋን፥ መላይከ ሀለቅ ላጋንለከ መገን ጡሩምብ ላጋን ሰሜች አሜተኖ፤ መሲህ አመዕንት ሬቶእሩ ሄጭት ሬሆች ኬኣአ። ");
INSERT INTO alw_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","ህከኒች ኤተሮን ነኡ ፎሊን ሄዕናምሩ እሳንን ሜጡበ ጎመ አሌን ጭምይን ቀርቾ ኢሲን ቦብር አሌን ደቀሞተ ኬዕናም፤ ህትን ጉዕመንከ ወክት ቀርቺን ሜጡበ ሄዕናም። ");
INSERT INTO alw_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","ህካን እኮቤቺሃ ገገዉክዕኔ ህከን ላጋን ጠረኝጨቀሜ። ");
INSERT INTO alw_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","አመኤ ኦሶ! ኩ ጠዉ እሀኖ ዘማንለከ ወክትተኔሃ መቱርቹሁ ከተበሞተ ሀስሰኖበአ። ");
INSERT INTO alw_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","መሰንትስ ቀርች በሩ አሜተኖሁ ሞጋንቹ ሀንከዕርተ ድንገቴን አሜተኖሀንገ አሜተኖሃ እሁስ አዕኑ ገዉንኩክዕኔ አጥራመቴን ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","መኑ «ጉዕሙርቹንኩ ወገሬትየለከ አደጉ ዮበአ» ይተንን ኒጠናት ላፈ ሜንቱ አፋሀንገን ህከ ወክት በኡ ድንገቴን አሜች አፈኖሰ፤ ፉሸኢንከ አታልታበአ። ");
INSERT INTO alw_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","እኮጎሬ አመኤ ኦሶ! በሩስ ሞጋንችገ እክ ድንገቴን ኢለኖህዕኔበእገ አዕኑ ቱንስቾንበአ። ");
INSERT INTO alw_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","ጉዕሙንኩክዕኔ ኑርለከ በሬተ ኦሱ፤ ነኡ ሀንከዕሬ ህከረንገ ቱንስችያረበአ። ");
INSERT INTO alw_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","ህካን እኮቤቺሃ ነኡ በቅይን ገዉኔ አገዕሪን ሄዕኖ ቤሉ ዎሎ መንገ ግንሱንከ። ");
INSERT INTO alw_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","ግሳእሩ ሀንከዕሬን ግሳአ፤ ሰከርታእሩ ሀንከዕርተ ሰከርታአ። ");
INSERT INTO alw_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","ነኡ እኮጎሬ ኑር ኦሱተ እንኮምቤቺሃ አመዕነቱለከ ኢተተ ወዘናን ኦደኤኖ ብረት ኦድኖገ ኦደዕን ጡም ተብሳ ቡዕላን ዎዕሬኖ ቆሜገ ዎዕርን ገኡ አገዕሪን ሄዕኖ። ");
INSERT INTO alw_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","መገኑ ገኤኔሁ ኡሙዕሬ እሁዕናን ቀርቹሃኔ መሲህ ኢስ አዲን ጡሙ ደእኖታት። ");
INSERT INTO alw_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","ፎሊን ሄዕኖም ጎሬ ሬኖምጎሬ እሲን ሜጡበ ሄዕኖተ መሲህ ኒተኔሃ ሬዮ። ");
INSERT INTO alw_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","ህካን እኮቤቺሃ ወዕና አቴነንተገን መት-መቱክዕኔ ጠረኝጨቀንቴነን ገገዉክዕኔ ሀዕላቀሜ። ");
INSERT INTO alw_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","አመኦሶ! ክዕኔ በላን ቀርቺን እክ ሆጎን ቆንዶድታረ ሀለቀክዕኔለከ ሸዛህዕኔረ ከበጅቶኖተ ኡጭናንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","ሆጎሰተኔ ከበጅዬሰ፥ ኢትዬሰ፤ ህትን ገገዊንከክዕኔ ወገሬቲን ሄዕዬ። ");
INSERT INTO alw_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","አመኤ ኦሶ፥ «ሆጉተ ኢትትበረ ሻቄ፤ ዘፉራኑተ መለልታገ አዕዬ፤ ላፋኑተ ሀዕልዬ፤ መነ ጉዕመንከ አታዕልዬ» ይን ሸንዛንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","አዪሁ ሂለ አዕዮሀኒሃ ሂለ አዕይ ፈንቀሽበገ አገዕሩን፤ ህከን ወጥ ጉዕመ ወክትንከ መት-መቲሃክዕኔ ጡመ ጠወ አቶኖተ ጠረኝዬ፤ ህትን ጉዕማንከ መኒሃ ጡመ አዕዬ። ");
INSERT INTO alw_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","ጉዕመ ወክትንከ ሙንደዕዬ። ");
INSERT INTO alw_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","ኡርሶኑዕናን ዱአ አዕዬ። ");
INSERT INTO alw_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","ጉዕመ ጠዋንን መገኑ ገለትጭዬ፤ መሰንትስ መሲህ ኢስ አዲን ዮህዕኔ ሄኢን መገኑ ክዕኔች ሀሰኖሁ ካኒት። ");
INSERT INTO alw_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","ጠሊለ አያን ጊረተ ጠእሶኖቼ። ");
INSERT INTO alw_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","ራገ ህንቆኖቼ። ");
INSERT INTO alw_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","ጠው እኮጎሬ ጉዕመ ጠወ ፌተንቴን ደጌን ጡመ ጠወስ አፌ። ");
INSERT INTO alw_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","ሂለ ጠዊች ጉዕሚችን ሁኜ። ");
INSERT INTO alw_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","ወገሬት መገኑ ጉዕመ ጠዋንን ጠሊለ አኡክዕኔ፤ አያኑክዕኔ፥ ፎሉክዕኔለከ ጅስሙክዕኔ ቀርቹኔ መሲህ ኢስ ፈንቀል አሜተኖ በሬተ ቀነጤኖርቹ ዮበኢሃ አገረም ሄኡን። ");
INSERT INTO alw_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","ገኤኔሁ አመዕነሞሃ እኮቤቺሃ ካን አአኖ። ");
INSERT INTO alw_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","አመኤ ኦሶ! ኔሳሃ ዱአ አዕዬኔ። ");
INSERT INTO alw_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","አመዕናኑተ ጉዕመንከ አመዕናኖተ አጉደኖ ተሽ የኖ ሃሊን ዝያዕረሜ። ");
INSERT INTO alw_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","ኩ ሶህኑት አመዕናኖተ ጉዕሚንከ አነበበንቶተ ቀርች ሱዕሚን ኤገተ ያንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","ቀርቹሃኔ መሲህ ኢስ ኣስቱት ክዕኔን ሜጡበ እኩን። ");
INSERT INTO alw_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","ጳዉሎስ፥ ስላስ፥ ጥማቶስ አናኔ መገንለከ ቀርቾሃ መሲህ ኢስረ እኮ ተሰሎንቄ ከተማን ዮንተ መገን አመዕናኖ ዱእ ምናተ ሶንኮምተ ሶህኑ። ");
INSERT INTO alw_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","አና መገኒችለከ ቀርቾሃ መሲህ ኢሲች ኣስቱትለከ ወገሬቱ ክዕኔሃ እሁን። ");
INSERT INTO alw_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","አመኤ ኦሶ! አመዕነቱክዕኔ ዎዕኔች በትሽ ነጰን አሜቾቤቺሃ መት-መቱክዕኔ ኢተቀንቴነንተ ኢተት በርግተን መርታቤቺሃ መገኑ ገለትጩ ሀስሰኖቤቺሃ ክዕኔ መሳን መገኑ ጉዕመ ወክትንከ ገለትጭናም። ");
INSERT INTO alw_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","ኢልቶህዕኔ ኦርሸተለከ ሸረሙ አታዕሊን አመዕነቲንከክዕኔ ጠረኝቴን ኡርቴንተቤቺሃ ክዕኔተኔሃ መገን አመዕናኖ ጭምት ዱእ ምናን ጉዕማን ጠወኢሃ ሙልናምበአ። ");
INSERT INTO alw_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","ኩ ጉዕሙንኩ ጠዉ ለሊሰኖሁ መገን ፍርዱ ሀንቅ እሁስለከ አዕኑ ኦርሸተ ቶጌንተሲሁ መገን ጄነትተኔሃ አበቀአኖህዕኔሃ እኮቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","መገኑ ሀንቅ ፍርደ ፈረደኖቤቺሃ ኦሪሸተ ኤባህዕኔሀኑኡ አሌን ፈንቀሽ ኦሪሸተ ኤበኖ። ");
INSERT INTO alw_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","ቀርቹ ኢስ ሎረ ወልቀት ዮሰ መላይካን ሜጡበ ሰሜች ጊረ ለበናን አሜተኖ ወክት ቴሱ ኦሪሸተ ቶጌነንተ ክዕኔሃ ኒንን ሜጡበ ፎሎጩ ኣሰኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","መገኑ ደግበረለከ ቀርቹሃኔ ኢስ ተሽት ላጋተ አዘዘንትበረ ጊረ ለበናን ቀጠአኖሰ። ");
INSERT INTO alw_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","እሰ ቀርች ብሬችለከ ኬዕምኝስ ዎልቃች አደ እካን ዘላለሚሃ ቤሲን ቀጠአኖሰ። ");
INSERT INTO alw_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","እስ ህከ ወክት ኬዕምኚንከስ ፈንቀለኖ ወክት ኬዕምኝለከ ገለት ጉዕማንከ ጠሊላኖ ኡመቲችለከ አመዕንቶሀኑኡች ጉዕሚች ቶገኖ፤ አዕኑሁ እሲን ሜጡበ እኬነንተ፤ መሰንትስ ምስክርነቱኔ አመዕነቲን ቶጌንታአ። ");
INSERT INTO alw_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","ካን ሰው ይነን ክዕኔተኔሃ ሙርኑዕነ ዱአ አዕናሚሁ መገኑኔ ገኤኔሀኒሃ በቀዕናምረ አኦህዕኔተ ጡመ አኢሃ ዮህዕኔ ሀስሸተለከ አመዕነት ሆጉክዕኔ ጉዕመንከ ወልቃንተስ አኦህዕኔታት። ");
INSERT INTO alw_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","ህትን ቀርችኔ ኢስ ሱዕሙ ክዕኔን ከበጀሞተለከ አዕኑሁ መገንኔለከ ቀርቹሃኔ መሲህ ኢስ ኣስቶን እሶን ከበጀንቶኖተ ዱአ አዕናም። ");
INSERT INTO alw_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","አመኤ ኦሶ ቀርቹሃኔ መሲህ ኢስ አሜትተኔሃለከ ነኡሁ እሲን ሜጡበ እንክ ጭምይናምቤቺሃ ዱአ አዕናሚሁ ህካኒት። ");
INSERT INTO alw_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","ራጊን ህከረንገ ላጋን ጠወአሞሀንገ ህከረንገ ኒች ሶህኑተ እክ ከተበሞሀንገ አቴን «ቀርች በሩ አሜቾኡ» ዪን ደዕልቴን ቀልብክዕኔ ሆርጥቶኖቼ፤ ጨነቀንቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","አዪሁ ሀከን አዲን ሉሲሱንከህዕኔ፤ መሰንትስ ሄጭ ለግት አሜቱዕነ አዛብ ጊረት በቀኣስ፤ እስን ኤተር ለገኣንቹ አሜቶተ ኢለ ህከረንገ ሾኩ መንቹ እስን በኦተ ዮኢሁ ለሎተ ኢለ ሁኩ በሩ አሜተኖበአ። ");
INSERT INTO alw_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","ሁኩ ሾኩ መንቹ ሽርክተ ዬን ሰገዴኖሰሀኑኡች ጉዕሚች አሌን ገውስ ሎረ አአኖ፤ ህትን «አን መገኑሃን» የንን መገን ጠሊለ ምኔን ፈቁዕነ አፉዕሎተ መለለኖ። ");
INSERT INTO alw_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","ክዕኔን ሜጡበ ሄዕዮም ወክት ከ ጠወ ኩሎንክዕኔገ ሰውይቴነንተበእንዶ? ");
INSERT INTO alw_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","እስን ወክቱስ ኢልያን ለለኖሃ ኢለ ቴሱ ለሉ ከመኖሲሁ መሃጎር አዕኑ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","መሰንትስ ሂለ ሆጉተ ማጥ አታኢት፤ ሁኩንን ቴሱ ከሚሃ ዮ ሂለ ምስጥር ዎልቀት ቴሱ ሆጎ አሌኒት፤ ሁኩንን እሀኖሁ ዎቄች ሽቆተ ኢላት። ");
INSERT INTO alw_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","ህከኒች ኤተሮን ሁኩ ሂሉ መንቹ ለለኖ፤ እሱንከ ቀርቹ ኢስ አፌችስ ፉለኖ ፎገሊንለከ አሜትስ ኬዕምኚን ሸኖ። ");
INSERT INTO alw_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","ሁኩ ሂሉ መንቹ አሜተኖሁ ሻይጣን ዎልቃን ሉሲሰኖ አጀብሲሰኖ ጠወለከ መላተ ገረምሲጬኖርቹ ጉዕመንከ አኢኒት። ");
INSERT INTO alw_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","ህትን በኣ መነ ጣንስታኢሁ እኮስ ሂለርቹ አኢኒት፤ ሁኩ መኑ በኣኢሁ ጡምቶተ አበቀአኖሰ ሀንቅ ኢተተ ቶጉ ግባቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","ህካን እኮቤቺሃ ክዝቢን አመዕንቶተ መገኑ ሎረ ሉሲሳ ወልቀተ ሶሀኖሰ። ");
INSERT INTO alw_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","ሁኩን እሀኖሁ ሀንቂን አመዕኑ ግብ ጩብ አሌን ሙንደኣሀኑኡ አሌን ፈረደሞታት። ");
INSERT INTO alw_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","ቀርቺን ኢተንቴንተ አመኤ ኦሶ! እኮጎሬ ነኡ ክዕኔ መሳን መገኑ ጉዕመ ወክት ገለት ኣሱ ሀስሰኖኔ፤ ገለት ኣስናሚሁ ክዕኔተ ጠሊለ አያኒን ጠሊልቴንተቤቺሃ ሀንቅ አመዕኖንከክዕኔ ጡምቶኖተ መገኑ ሄጭ ዶዕሬህዕኔቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","ነኡ ኩልኖንክዕኔ ተሽት ላገ አዲን ቀርቹሃኔ መሲህ ኢስ ኬዕምኝ ደእቶኖተ መገኑ ገኤህዕኔሁ ከኒሃት። ");
INSERT INTO alw_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","አመኤ ኦሶ! ህካን እኮቤቺሃ ቴሱ ጠረኝቴን ኡርዬ፤ አፌችኔ ፉልቶ ላጋን ህከረንገ ሶህኖን ተማርስኖንክዕኔ ሀንቅ ትምርት ሀቦኖቼ። ");
INSERT INTO alw_vpl VALUES ("H22_16","083_2_16","2TH","2","16","16","ቀርቹኔ መሲህ ኢስ ገውስለከ መገኑ አኑኔ ኢቴኔሁ ኣስቶንከስ ዘላለሚሃ እካ ጠረኝመተለከ ጡመ ተብሳሃ ኣሴኔ ");
INSERT INTO alw_vpl VALUES ("H22_17","083_2_17","2TH","2","17","17","ጡመ እኮ ጠወ ጉዕመንከ አቶኖተለከ ጠወኦኖተ ቀልብክዕኔ ሰበርሶህዕኔ፤ ጡመ ጠወ ጉዕመንከ አቶኖተለከ ጠወኦኖተ ጠረኝሶህዕኔ። ");
INSERT INTO alw_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","አመኤ ኦሶ! ክዕኔቤቾን እኮሀንገን ቀርች ላገት ደዕልት አልባዕልቶተለከ ኬዕምኚን ቶገሙ ደእቶተ ኒተኔሃ ዱአ አዕዬ። ");
INSERT INTO alw_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","ህትን መናን ጉዕማንን አመዕነቱ ሄእበቤቺሃ ሾከለከ ሂለ መኒች ጡምኖተ ዱአ አዕዬ። ");
INSERT INTO alw_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","ጠዉ እኮጎሬ ጠረኝሰኖህዕኔለከ ሸይጣኒች አገረኖህዕኔ ቀርቹ አመዕነሞእሃን። ");
INSERT INTO alw_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","አዘንዛንክዕኔ ጠወ ቴሁ እኮ ከ ኤተሩ አቴነንተገ ቀርቺን አመዕንናንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","ቀርቹ ቀልብክዕኔ መገን ኢተተ ደጎኖተለከ መሲህ አታዕሉ ደጎኖተ አዎንሱንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","አመኤ ኦሶ! ኒች ተማርቴንተ ትምርቲን እሁዕነ ሆጉተ ኢትበ አመዕናንቺች አዬቺሁ አደ እኮኖተ ቀርቹሃ መሲህ ኢስ ሱዕሚን አዘንዛንክዕኔ። ");
INSERT INTO alw_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","ነኡ ክዕኔቤቾን ሄዕኖም ወክት ዋንክዕላመተ እሁ ሆጉኔ አዕኑሁ ደጌነንተቤቺሃ ኔሳሃ አጉዴን ሄኡ ሀስሰኖህዕኔገ ደጌነንተ። ");
INSERT INTO alw_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","አዬ አሌኒ እጅነተ እንካምበእገ ሀንከዕርተለከ በራሃ አጰመን ሆጉተ አዕነን ሄዕኖም ቤሉ አዬቺ ጣብተ ጠለዕለ እንቶምበአ። ");
INSERT INTO alw_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","ሁኩንን አዕኑ ኒ ምሳልተ አዎንቶኖተ ይኒት ቤሉ ሁኩን ኔሳሃ ሀዕለንሸ ደእኖተ መብትት ሄኡዕናኔ ፈንቅትበአ። ");
INSERT INTO alw_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","መሰንትስ ነኡ ክዕኔቤቾን ዮም ወክት «ሆጉተ አሲሃ ኢትቡ መንቹ እቱንከ» ይን ከ ትዛዝ ኣስኖንክዕኔ እቅ። ");
INSERT INTO alw_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","መሰንትስ መት-መቱ ሆጉተ አሲሃ ኢትቡ መኑ በላንከክዕኔ ሄኡሰ ሞጮጭኖም፤ እሰን ኣግስበሰ ጠዋን ኣገን መቱርቹሃ አቱዕነ ሄኣእራን። ");
INSERT INTO alw_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","ህትኔ መነ ረጀይት ሆጉተ አተን ገይሰ እቸተ እቶተ ቀርቹሃኔ መሲህ ኢስ ሱዕሚን አዘንዛንሰ፤ ሸንዛንሰ። ");
INSERT INTO alw_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","አመኤ ኦሶ! አዕኑ እኮጎሬ ጡመ ሆጉተ አቶኖተ «ቆንዶድኖም» ይቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","ተን ዳብዳቤን ክዕኔኤሃ ኩልኖም ሸዘነተ ሞጮጭቡ መንቹ ሄዕዮ ጎሬ ህትናሙ መንቹ አጥራመቴን ደጌ፤ እስን ሙሎተ እሲን ደቀንቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","ጠው እኮጎሬ አመቤትገ ኡሙዕርዬስ ቤሉ ዲንገ አቴን ለኦኖቼስ። ");
INSERT INTO alw_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","ወገሬት ቀርቹ ገውንኩስ ጉዕመ ወክት ጉዕመ ጠዋንን ወገሬት ኣሱንክዕኔ፤ ቀርቹ ጉዕሚንከክዕኔ ሜጡበ እሁን። ");
INSERT INTO alw_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","ከ ወገሬት ገይኤ አንጋን ከተቦንክዕኔሁ አኔት ጳዉሎሴት፤ አን ሶኮም ዳብዳቤን ጉዕማንን ደገንታ መላት ተኒት፤ ከተባሚንኩ ህትጎታን። ");
INSERT INTO alw_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","ቀርቹሃኔ መሲህ ኢስ ኣስቱት ክዕኔን ጉዕሚንከክዕኔ ሜጡበ እኩን። ");
INSERT INTO alw_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","ፌሳንቹኔ እኮ መገንለከ ተቢሳሃ እኮ መሲህ ኢስ ትዛዚን መሲህ ኢስ አሳቤቹ እኮም ጳዉሎሴች፦ ");
INSERT INTO alw_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","አመዕነቲን ሀንቅ ቤቱእ እኮ ጢማቶሴሃ ሶሃንቶእተ ሶህኑ፤ አናኔ መገኒችለከ ቀርቹሃኔ መሲህ ኢሲች ኣስቱቲ፥ ማርቱትለከ ወገሬቱሁ ኪን እሁን። ");
INSERT INTO alw_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","አን መቄዶን ባዱ መሮም ወክት መቱ-መቱ መኑ ክዝብ ትምህርት ተማርሲታበእገ፥ ");
INSERT INTO alw_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","ማቁተለከ ዎለኤናን ጎፍበ እለንሽ ዎሊንሽበ ፈንቀልታበእገ አዘዘን ኤፌሶን ከተማን አፉዕልቶተ ኤገተክ ያንኬ፤ ህትናሙ ጠዉንኩ ኦደተ ኤበኖ ቤሉ መገን አመዕነቲን ነጵኖተ ደግለለኖኔበአ። ");
INSERT INTO alw_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","ከን ትዛዚች መሰስ ጠሊለ ቀልብቺ፥ ጡመ ሰውቲችለከ ሀንቅ አመዕነቲች ደገንታእተ ኢተ። ");
INSERT INTO alw_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","መት-መቱ መኑንኩ ህትናሞ ጠዊች አደ እክ ደግለሊቶበእ ኦደበ ፈንቀልቶኡ። ");
INSERT INTO alw_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","እሰን ሕገ ሮስሳእራ እኮተ ሀሰን የኖስርቹ ደጋበአ፤ ህከረንገ «ደጊን ጠወዕናሚት» ይተን ጠወኣኢንከ አጥራመታበአ። ");
INSERT INTO alw_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","መኑ ሕገ ጡመ እሁስ ደግለሸቀሞ ጎሬ ጡመ እሁስ ደንጋም። ");
INSERT INTO alw_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","ህትን ሕጉ ኣሰሞሁ ሕገ ድጅታሀኑኡተለከ አዘዘንትበ መኒሃ፥ መገኑ ዮሰበእሀኑኡተለከ ጩበኛኖተ፥ ጠሊልመት ዮሰበእሀኑኡተለከ አመዕነት ጠወ ግባሀኑኡተ፥ አናኖተለከ አማኖተ፥ ሽታሀኑኡታትለከ ነቢሳሃ ቤሳሀኑኡተ ");
INSERT INTO alw_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","ዝነተ አታሀኑኡተለከ ለቦሁ ለቤን ዝነተ አታሀኑኡተ፥ መነ ነገዳሀኑኡተለከ ክዝባሀኑኡተ፥ ክዝቢን ጤሌዕሊታሀኑኡተለከ ሀንቅ ትምህርቲን ሀንበዕለመኖ ጠወ ጉዕመንከ አታሀኑኡታት፤ ጡመ ሴሪን ኦደንታ መኒሃት ቤሉ ጡመ መኒሃበአ። ");
INSERT INTO alw_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","ኩንን ሀንቅ ትምህርቱ ደገመኖሁ ገለትጨሞ መገን አዲች ዱዱብሰኖ ከበጀሞ እንጂሊቺት፤ ኩ እንጂሉ ኤሳሃ ኤገተ ኣሰሞኤሃን። ");
INSERT INTO alw_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","ኤሳሃ ሆጎሃስ ካዲንቹ መጠር አመዕነሞሚሃ አዕይ ዎለዕዮኤሁለከ ዎልቀተ ኣሴኤ ቀርቹኔ መሲህ ኢሰ ገለትጫም። ");
INSERT INTO alw_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","አንን ከኒች ብርተ ሸራሚሃ፥ መሲህ ኢሰ ቦሮሮሚሃለከ ሆፍሾሚሃ እኮምጎሬሁ ህካን ጉዕመንከ አዕዮሚሁ ደጉ ሆጊንለከ አመዕኑ ሆጊን እኮቤቺሃ ማርቱተ ደኤም። ");
INSERT INTO alw_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","ህትን መሲህ ኢሲን ደገመኖ አመዕነቲንለከ ኢታን ሜጡበ ቀርችኔ ኣስቱት በተእ ኣሰንቶኤ። ");
INSERT INTO alw_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","«ጩበኛኑተ ፌሶተ መሲህ ኢስ ከ ኣዱንያ አል አሜቾ» ይታ ላገት ሀንቅያለከ መኑ ጉዕሙንኩ ኣኡ ሀስሰኖሃን፤ አንን ጩበኛኖች ጉዕሚችን ዎዕኔስሃን። ");
INSERT INTO alw_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","ጠዉ እኮጎሬ መገኒች ማርቱተ ደኤም፤ ማርቱተ ደኤሚሁ መሲህ ኢስ ዳንጉ ዮበኢሃ አታዕሉስ ጉዕሚችን ባሾም ጩበኛ እኮም ኢ አሌን ለሊሽ እሲን አመዕንታሀኑኡተ ዘላለሚሃ ሄኡ ደእታሀኑኡተ ምሳልተ እሆታት። ");
INSERT INTO alw_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","ህካን እኮቤቺሃ ዘላለሚሃ ዎመ እክ ሬሀኖበእለከ ለለኖበእ ሜጦሃ መገኒሃ ሎርመትለከ ከበጁ ዘላለሚሃ እሁንስ፤ ኣሚዕን! ");
INSERT INTO alw_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","ኢ ቤቶ ጢሞቲዎሴ! ዎዕናንከ ኪተኔሃ ኩለሞ ራግገን ጡመ ኦለንሸ ኦለንቶተ፥ ");
INSERT INTO alw_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","አመዕነቱሁ ጡሙ ቀልቡሁ ሄኦሄተ ከ ትዛዝ ኤገተ ኣሳንኬት፤ መሰንትስ መት-መቱ መኑ መርከበ ሸረኖሁ ዮበእ ጎሬ በአኖሀንገን ቀልብ ሆጊን አመዕነቱሰ ቤሶኡ። ");
INSERT INTO alw_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","እሰ በላንን ሄሜኖስለከ እስክንድር ደገንታአ፤ እሰን መገን አሌን ቦሮር ላገተ ጠወኢች ተማርቶተ ሼይጣኒሃ አን ህግሽ ኣስዮንሰረ። ");
INSERT INTO alw_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","መኑ ጉዕሙንኩ መገን አደ ኡጭቱተ፥ ዱአሃ፥ ዎሎ መኒሃ ዱአ አኡለከ ገለትጩሁ መኑ ጉዕሙንኩ አኦተ ሸዛም። ");
INSERT INTO alw_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","መገኑ ዋጂን ጡመ ሃሊን አዎነን ወገሬቲንለከ ጨለዪን ሄዕኖተ በትሽን ዎማተለከ አበ ሆጎ አሌን ዮሀኑኡተ ዱአ አዕዬ። ");
INSERT INTO alw_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","ሁኩንን ፌሳንቹሃኔ መገን ብሬን ጡማለከ ተሽ የኖሃ ጠወ። ");
INSERT INTO alw_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","መገን ሃሽኣቱት መኑ ጉዕሙንኩ ጡሞተለከ ሀንቅ ደጋጋት። ");
INSERT INTO alw_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","መገኑ ሜጥቹሃን፤ ህትን መገንለከ መን በላን እኮ መቱ መንቹ ዮኡ፤ እስን መንቹ እኮ መሲህ ኢሳት። ");
INSERT INTO alw_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","እስን መነ ጉዕመንከ ዎዞተ ገዉስ ዎዝኑተ አዕይ ኣሴእ፤ ሁኩንን መገኑ መነ ጡምሶተ ሀሾገ ሀስሰኖ ወክቴን ሀሴማእሃ ምስክር። ");
INSERT INTO alw_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","አን አይሁደ እህበ መኒሃ አመዕነቱለከ ሀንቅ ተማርሶተ ዱዱብሳንቹለከ አሳቤቹ እክ ሾመሞም፤ ህካን ያም ወክት ሀንቅ ጠወኣሚት ቤሉ ክዝቦምበአ። ");
INSERT INTO alw_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","ቴሱ ጎኑ ቤቾን ጉዕማንን ኡሙዕርተለከ ብተት ዮበኢሃ ጠሊለተ አንገተ አሌ ኬስ ዱአ አቶተ ሀሳም። ");
INSERT INTO alw_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","ህትን ሜንቱ ሙምሰ ደደን ህከረንገ ወርቂን፥ ናሲን ህከረንገ ጤአተ እኮ ኦድኑተ ሹልምሰን እሁዕናን ማሌን ጡምማን ሀስሰኖጊን ጡመተ ኦድኑተ ኦደኡን፤ ");
INSERT INTO alw_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","መገኒሃ ሰገንዳሚት ይታ ሜንቱ አኡ ሀስሰኖሰገ ጡመ ሆጉተ አቱን። ");
INSERT INTO alw_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","ህትን መንቹት ጉዕመ ጠዋን አዘዘሚን ሎድት ተማርቱን። ");
INSERT INTO alw_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","ህትን መንቹት ጨለ ይቱን ቤሉ ተማርስቶተ ህትን ጎን አሌን ሹመ እኩን ያምበአ። ");
INSERT INTO alw_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","መሰንትስ ሄጭ ከለቀሞሁ ኣደማት፤ ህከኒች ኤተሮን ሐዋ ከለቀንቶኡ። ");
INSERT INTO alw_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","ህትን ጣንሰንት መገን ሕገ ድጅቶኢት ሐዋት ቤሉ ኣደም ጣንሰሞበአ። ");
INSERT INTO alw_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","ጠው እኮጎሬ መንቹት አመዕነቲኒ፥ ኢታኒ፥ ጠሊልማንለከ ገው አገዕርን ሄኦ ጎሬ እለተ እሊን ጡምታአ። ");
INSERT INTO alw_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","«አዪሁ አመዕናኖ አዎንሳንቹ እሆተ ሀሾ ጎር ሎረ ሆጉተ ሃሸአኖት» ይታ ላገት ሀንቅሃን። ");
INSERT INTO alw_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","አመዕናኖ አዎንሳንቹንኩ ኩሌኖስ ጠዉ ዮስበኢሃ፥ መቴ መንቾተ ምኒ አነ እኮሃ፥ ጌሲን ሄአኖሃ፥ ገዉስ አገዕረኖሃ፥ ኬዕምኝስ አገዕረኖሃ፥ ኮሀ ቶገኖሃ፥ ተማርሲሃ አታለኖሃ፥ ");
INSERT INTO alw_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","ሰከሪባሃ፥ ኡሙዕሪባሃ፥ ጎደበ ላፈ፥ ብተምባሃ፥ ብረ ኢትባሃ፥ ");
INSERT INTO alw_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","ገይስ ምኒ አበሮሱ ጡመገ ገሾተ አታለኖሃ፥ እለስ አዘዘንታሲሃ፥ ጉዕመንከ አዲን ኬዕምሳሲሃ እሁ ሀስሰኖስ። ");
INSERT INTO alw_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","መሰንትስ መቱ መንቹ ምንስ ገሾተ አታልባች መገኑ አመዕኔ መነ ገሾተ ሀት አታለኖ? ");
INSERT INTO alw_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","ህትን እልቢስ አሌን ፈረደሞገን ቦኝያን አሌስ ፈረደመኖበእገ ሃዕሮ አመዕኔ መንቹ አዎንሳንቹ እሁንከ። ");
INSERT INTO alw_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","ህትን ሆፍኚንለከ ሻይጣን ዎሻድን ኣገኖበእገ አመዕንበ መንቤቾን ገለትጨሞኢሃ እሁ ሀስሰኖስ። ");
INSERT INTO alw_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","ህትን ድያቆናከተ ኬዕምኙ ሀስሰኖሰረ፥ ለሙ ጠወኣበእረ፥ ዎይን ጠጂን ሰከርታበእረ፥ ብሪሃ ጎራይትበረ እሁ ሀስሰኖሰ። ");
INSERT INTO alw_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","ህትን አመዕነቲን ለሌ ሀንቅ ነጠ ቀልቢን ጠረኝስ አፉ ሀስሰኖሰ። ");
INSERT INTO alw_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","እሰንተ ሄጬን ፌተኔን ለኡ ሀስሰኖ፤ ህከኒች ኤተሮን ኩሌኖሰ ጠዉ ዮበእራ እኮኢች ዲያቆነ እኮተ አታልታአ። ");
INSERT INTO alw_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","ህትን ምንሰ አማኑት ኬዕምሴኖሰረ፥ ሄዕምታበእረ፥ ገዉሰ አገዕርታእረለከ ጉዕመርቾንን አመዕነንቶእራ እሁ ሀስሰኖሰ። ");
INSERT INTO alw_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","ህትን ዲያቆነት መቴ መንቾ ምኒ አነ እኮረ፥ ኦሱሰለከ አበሮሱሰ ጡመገ ገሽታእረ እሁ ሀስሰኖሰ። ");
INSERT INTO alw_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","መሰንትስ ዲያቆነት ጡመገ ሆጉተ አታእሩ ገይሀሰ አበ ኬዕምኝ ደእታአ፤ ህትን መሲህ ኢሲን ዮሰ አመዕነትተኔ ልግብ መለሉ ደእታአ። ");
INSERT INTO alw_vpl VALUES ("T13_14","084_3_14","1TI","3","14","15","ፎሊን ሄአኖ ዱእ ምኒ በላን መቱ መንቹ ሀት እክ ሄኡ ሀስሰኖሰ ጎሬ ሀት እክ ፈንቀላመኖ ጎር ደጋገ ከተቦንኬ፤ ሁኩ መገን ምኑንኩ ሀንቅ ቱቃለከ ቀበበ። ");
INSERT INTO alw_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","አመዕነትኔ ማጠሞ ጠዉ ሸክሲስበ ሎረሃን፤ እስን መንቹ እክ ለልዮእሃ፤ ሀንቅ እሁስ ጠሊለ አያኒን አዋጀሞእሃ፤ መላይካተ ለልዮእሃ፤ መኒሃ ጉዕሚንከ ዱዱብሰሞእሃ፤ ከን ኣዱንያ አል መኑ አመዕንዮስሃ፤ ኬዕምኚን ሰማሃ ኦሮዕዮእሃ። ");
INSERT INTO alw_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","ጠሊሉ አያኑ ለሊሽ «ኤተር ዘማኔን መት-መቱ መኑ ሉሲሰኖ ሂለ አያነለከ ሩሃንይ ትምርት አዎንተን አመዕነቲች አደ እክ ቄዕርታአ» የኖ። ");
INSERT INTO alw_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","ሁኩ ትምርቱ አሜተኖሁ አታኢሁ ሀንቅ እሁስለከ ሀንቅ እሁ ሆጉስ ደገንን አመሰልታ ክዝበኛኖችት። ");
INSERT INTO alw_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","እሰን ኤበቀንሸ ከንታአ፤ አመዕንታለከ ሀንቅ ደጋ መኑ እሱ ገለትጭተን እታገ መገኑ ከለቆሰ እቸተ «እቶኖቼ» ይት ከንታአ። ");
INSERT INTO alw_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","ጠዉ እኮጎሬ መገን ክልቀቱ ጉዕሙንኩ ጡመ እኮቤቺሃ ገለትጬን ቶጌመጎሬ ኡጄኖሁ መቱሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","መሰንትስ ሁኩን መገን ላጋንለከ ዱአ አኢን ጠሊለ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","ከ ትምህርት አመዕናኖተ ኣቶንትጎር አመዕነት ላገተለከ አዎንቶንት ጡመ ትምርተሃ እት ነጵቶንት ጡመ መሲህ ኢስ ካድንቹ እካንት። ");
INSERT INTO alw_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","ህትን ከን ኣዱንያ አሊች ደግለሊበ ጠዊችለከ ዱንየ አል ማቁተ አጉደኖ ጠዊች ሁን፤ ገዉክ መገን ጠዊሃ ሮስስ። ");
INSERT INTO alw_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","መሰንትስ ገዉ ጠረኝሰኖ ጠወ ሮስሱ ቀዉ ደግለለኖ፤ እኮጎሬ ገዉ መገን ጠዊ ሮስሱ ከን ሄኢሃለከ አሜተኖ ሄኢሃ ተቢሶሁ ዮስቤቺሃ ጉዕመ ጠዊንከ ደግለለኖ። ");
INSERT INTO alw_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","ህካን ዩ መኑ ጉዕሙንኩ ሹል ቶጉ ሀስሰኖሰ አመዕነሞሃ ጠወ። ");
INSERT INTO alw_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","ነኡን መነ ጉዕመንከ አደንከ አመዕንታሀኑኡተ ጡምሰኖለከ ሄአኖ መገኖን ተቢሳሃ አዕናምቤቺሃ ሆጎን ሆንጋሚሁለከ አጰማሚሁ ከ ጠወ ደኢሃት። ");
INSERT INTO alw_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","አት ከ ጠወ አዘዝለከ ተማርስ። ");
INSERT INTO alw_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","ህትን ጠወኦንት ጠዊን፥ ሃሊን፥ ኢታን፥ አመዕነቲንለከ ሙጩርማን አመዕናኖተ ምሳልተ እህ ቤሉ አዪሁ ኦስመክ ህንቁንከ። ");
INSERT INTO alw_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","ህትን አን አሜቶተ እለሬተ ጠልለ መጻፈ መኒሃ አነበቡ፥ ዱዱብሱለከ ተማርሱ ጠረኝ። ");
INSERT INTO alw_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","ህትን ባልቀት አሌንከክ አንገሰ አታን ራጉ ጠወአሞሄ ወክት ኣሰሞሄ ኪን ዮ ኣስቱት ህንቆት። ");
INSERT INTO alw_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","ነጱክ መኑ ጉዕሙንኩ ደጎተ ወክትክ ጉዕመንከ ከን ጠዊሃ አእ፤ ከ ጠወ ሆጎ አሌን ሆሲስ ገዉክ እሲሃ ኣስ። ");
INSERT INTO alw_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","ገይሃክለከ ተማርስታንት ትምርተክ አገዕር፤ ከ ጠወ አተን ጠረኝ፤ ህካን አቶንትጎር ገዉክለከ ኪች ሞጮጨኖ መነሃ ጡምሳንት። ");
INSERT INTO alw_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","ባሊቆ መንቹ አንክገ ሆንጠህ ቤሉ ሻቆት፤ ህትን ዎደልቹ አመክ ኦሱተ ጠውሲሳንትገ ጠውሲስ ");
INSERT INTO alw_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","ባሊቅ ሜንቱ አማኖገ ሀርድ ሜንቱ አመክ ኦሶገ አት ዊመ ሙጩርማን ለእ። ");
INSERT INTO alw_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","ሀንቅንከ ምንሰ አኑ ሬዮ ሜንቱ ሀዕልተን ከበጅሰ። ");
INSERT INTO alw_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","ጠዉ እኮጎሬ ምንሴ አኑ ሬዮ መንቾ እለት ህከረንገ እለ እለት ዮሴጎር ሁኩ እለት ሄጭት ምንሰ መነ ደግለሊን ኤዳሰ ፈንቀሽቱን፤ ህከን አመዕነቲን ሆጉተ ተማርቱን፤ መሰንትስ ሁኩን መገኑ ሙንዲሲሰኖሃ ጠወ። ");
INSERT INTO alw_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","ምንሴ አኑ ሬዮ ሀንቅ ህዬሸት ሜጢሃሴ ሄኣ መንቹት መገኖን ተቢሳሃ አታቤቺሃ ሀንከዕርተለከ በራሃ መገኑ ጠዕሚንለከ ዱአ አተን ጠረኝት ሄኣአ። ");
INSERT INTO alw_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","ጠለዕል ከን ዱንያ አል መኩተ ሀሳ ምንሴ አኑ ሬዮ መንቹት ነቢሴን ሄኦ ጎሬ ሬቶእታን። ");
INSERT INTO alw_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","እሰን ቀነጤኖሰርቹ ዮበእረ እኮተ ከ ትምርተ ኣስ። ");
INSERT INTO alw_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","ህካን እኮቤቺሃ እሊሃስ አደደንከ ምንስ መኒሃ ሰውየኖበእ መንቹ አዪሁ አመዕነቱስ ካጆእሃን፤ ህትን ሁኩ መንቹ አመዕንዮበእ መንቺች ባሰ ሂላን። ");
INSERT INTO alw_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","ዎዕነሃ መቶ መንቾን ገልት እለንቶች ሌሃዉ ዘማን ዊምበሴ ምንሴ አኑ ሬዮ መንቹት ምንሰ አኑ ሬዮሀኑኡ መዝገባን ከተበንቱንከ። ");
INSERT INTO alw_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","ህትን እለተ ነሲን፥ ኮሀ ቶጊን፥ አመዕናኖ ሎከተ ኣንሺን፥ ኦርጨሞ መነ ሀዕሊን፥ ጡመ ሆጉተ ጉዕመንተ አኢን ጡመ ሆጎንከሴ ገለትጨንቶኢተ እሁ ሀስሰኖሴ። ");
INSERT INTO alw_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","ጠዉ እኮጎሬ ምንሰ አኑ ሬዮ ሀርድ ሜንቱ ምንሰ አኑ ሬዮ ሜንት መዝገባን ከተቦት፤ መሰንትስ እሰ ማል ሄዕላቸት ቄልትየንሰ መሲህ ኢሳን ዮሰ ኢተት በአን ጎናን ገልቶተ ሀሳኢት። ");
INSERT INTO alw_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","ኩ ሜንቱ ዎዕነሃ ይቶ ላገተ ድጅቶቤቺሃ አሌንከሰ ፍርደ ኤባአ። ");
INSERT INTO alw_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","ህከኒችን አበንከ ሆጉተ ገፈሩለከ ምኒች ምኒ ዘሁ ሮሳአ፤ ህትን ሆጉተ ገፈሩ እሁዕናን ሄዕምታእረለከ መን ጠዋን ኣገን ጠወኡ ገበእበሳሃ ጠወኣራ እካአ። ");
INSERT INTO alw_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","ህካን እኮቤቺሃ አን ምንሰ አኑ ሬዮ ሀርዴ ሜንቱ ገልቶተ፥ እለተ እልቶተ፥ ምንሰ ጡመገ ገሽቶተ ሸዛም፤ ህት አኦን ዲኑኔ ቦሮረኖ ጠወ ሆገኖ። ");
INSERT INTO alw_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","መሰንትስ ከኒች ዎዕነሃ ምንሰ አኑ ሬዮ መት-መቱ ሜንቱ ሻይጣነ አዎንተን አመዕነት ዎቄች ፉልቶኡ። ");
INSERT INTO alw_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","መቴ አመዕናንቾ መንቾ ምኔን ምንሰ አኑ ሬዮ ሜንቱ ሄኦጎር አመዕናኖ ማበሪሃ ኬዕመኖበእገ እሴ ሀዕልቱንሰ፤ ከን ሃሊን አመዕናኖ ማበሩንኩ ሀዕለኖሳሁ ዮበእ ምንሰ አኑ ሬዮ ሜንቲሃ ሀዕለኖ። ");
INSERT INTO alw_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","አመዕናኖ ማበረ ጡመገ ገሽታ ባሊቀት ዱዱብሲንለከ ተማርሲን ጠረኝት አታሀኑኡተ ለሙ አፎሁ ኬዕምኙ ሀስሰኖሰ። ");
INSERT INTO alw_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","መሰንትስ ጠሊሉ መጻፉ «ውጠተ ዎቀርተን ቦር አፎ ኡሱርቶት» ህትን «ሆጉተ አአኖሀኒሃ ደሞዙ ሀስሰኖስ» የመሞኡ። ");
INSERT INTO alw_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","ለሙ ህከረንገ ሰሱ መንቹ መሰከርትባች አመዕናኖ ማበር ባሊቅ አሌን ሆንጠህሴኖ ኦደተ ቶጎት። ");
INSERT INTO alw_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","ህትን ዎሉ መኑ ዋጅታገ ጩብ አታ መነ ጉዕመንከ መን ብሬን ኡሙዕር። ");
INSERT INTO alw_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","ህትን መነ አደ አኡ ዮበኢሃ መቱ-መቲች በትሱዕናን ከ ኩሌመሄ ጠወ አገርቶተ መገን ብሬንለከ መሲህ ኢስ ብሬን መጠረንቶ መላይከ ብሬን ኤገተክ ያንኬ። ");
INSERT INTO alw_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","ህትን አንገክ አዬ አሌኒ ደዕልት አቶት፤ ዎሎ መን ጩብ ቤቀንቶት፤ ገዉክ ሙጩሩ አት አገዕር። ");
INSERT INTO alw_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","ልግብ ወክት ጎደበክ ጥዘኖሄቤቺሃለከ ጥዘነት ዮሄቤቺሃ ቀዉንከ ወይን ጠጀ አግ ቤሉ ከ ኤተሩ ጠለዕል ዋሃ አጎት። ");
INSERT INTO alw_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","መት-መቶ መን ጩቡ አገንቹ እክ ለለኖ፤ ሁኩንን ፍርድበ ኢልሰኖ፤ ህትን ዎሎ መን ጩቡ ዱንክ ለለኖ። ");
INSERT INTO alw_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","ህትን ጡመት ሆጉት ኑሪ እክ ለልታአ፤ ኑሪ እክ ለልትበጎሬ ማጠንቶገ ሄኣበአ። ");
INSERT INTO alw_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","መገን ሱዕሙለከ ትምርቱ ቦሮረመኖበእገ ሮሶመ ኣዜን ሄኦሩ ጉዕሙንኩ ቀርቻኖተሰ ዊሙ ኬዕምኙ ሀስሰኖሰገ ደጉን። ");
INSERT INTO alw_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","ህትን አመዕናኖ ቀርቻኑት ዮሰ ሮሰት ቀርቾ መሲህ ኢሲን አመኦሱተ እኮቤቺሃ ቀርቻኑሰ ኬዕምስበረ እሁ ሀስሰኖሰበአ፤ ህከን ወጢ ጡመ ሆጎንከሰ ሀዕልታእረ አመዕናኑተለከ ኢተንቶእረ እኮቤቺሃ ዎዕኔች አበ አኡ ሀስሰኖሰ፤ ከ ጠወንከ ተማርስተን ሸዝ። ");
INSERT INTO alw_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","አዪሁ ቀርቹሃኔ መሲህ ኢስ ላጋንለከ መገኑ አጉዲን ትምርታን ሀንበዕለመን ዎሉ ትምርተ ተማርሴጎሬ ");
INSERT INTO alw_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","ሁኩ መንቹ ቦኒን ቡሰሞሃ ቤሉ መቱርቹሃ ደግበሃን፤ ጠዉ እኮጎሬ ወገሬቱ ዮበእ ሄዕላቸት አፎስ፤ ሁኩንን ኤበኖሁ ምቀኝመተ፥ ብተተ፥ ቦሮዕረንሸለከ ሂለ ሸክተ ");
INSERT INTO alw_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","ቀልቡሰ በዕዮለከ ሀንቂች ፉልቶ መን በላን እኮ ተንቅታበእ ኦደተ ኤበኖሃን፤ እሳንከ መገኑ አመዕኑ ዱንያተ ደኤኖ ዎቃሃ አጉጆሰረን። ");
INSERT INTO alw_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","ጠዉ እኮጎሬ «ዮኤሁ እሀኖኤ» የኖ መንቺሃ መገኑ አጉጅ ሄኡ ትርፈ ደግሲሰኖ፤ አመዕነቶን ሀንቅንከ ልግቡ ትርፉ ዮስሃን። ");
INSERT INTO alw_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","መሰንትስ ነኡ ከን ኣዱንያ አል አሜንቶሚሁ መቱርቹሃ አንፉዕናንት፤ ህትን ከን ኣዱንያ አሊች መቱርቹሃ አንፍ መርኖተ አታልናምበአ። ");
INSERT INTO alw_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","ጠዉ እኮጎሬ እንታሚሁለከ ኦደዕናሚሁ ሄዕዮኔች ሁኩን እሀኖኔ። ");
INSERT INTO alw_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","ህትን ቀባጣሙ እህሃ ሀሳ መኑ ፌተናን፥ ዎሻዶንለከ መኒ በኡ ኤበኖ ገውሰኖለከ ምዕረኖ ልግቤ ሄዕላቶን ኡባአ። ");
INSERT INTO alw_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","መሰንትስ ብረ ኢቱ ልግቤ ሂልማተ ጉዕሚንከ ጠጳን፤ መት-መቱ መኑንኩ ብረ ደኢሃ አበ ሄዕላቶቤቺሃ አመዕነቲች ኡቦኡ፤ ልግቤ ሻዞን ቀልቡሰ ቢጠመኖገ አቶኡ። ");
INSERT INTO alw_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","ጠዉ እኮጎሬ አት መገን መንቾ! ከን ጉዕማንከ ጠዊች ሁን፤ ፈይመተ፥ መገን ጠወሃ፥ አመዕነቱሃ፥ ኢተታ፥ አታዕሉለከ ጎደበ ላፍመተ አኡሃን። ");
INSERT INTO alw_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","ጡመ አመዕነት ኦለንሸ ኦለም፤ ዘማን ጉዕሚንከ ሄኡ አፍ፤ ህከ ዘላለም ጉዕሚንከ ሄኢሃ ገአንት ልግብያ ምስክር ብሬን ጡመ ምስክርነቱ መሰከርቶንት። ");
INSERT INTO alw_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","ህትን ጉዕመርቺንከ ሄኡ ኣሰኖ መገንለከ ጴንጤናዌቾሃ ጵላጦሴ ብሬን ጡመ ምስክር መሰከሮ መሲህ ኢስ ብሬን ");
INSERT INTO alw_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","ቀርቹኔ መሲህ ኢስ ፈንቀል አሜቶተ እለ ከ ትዛዝ ሉጨንሹለከ ህንቄኖስ ጠዉ ዮበእገ እክ አገርቶተ አዘዛንኬ። ");
INSERT INTO alw_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","መሲህ ኢሲ አሜቱ ማሰአሞለከ ሜጥሃስ ገሻንቹ እኮ ዎመ ዎሙለከ ቀርቻኖ ቀርቹ መገኑ ለልሾ በሬን እሀኖ። ");
INSERT INTO alw_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","ህትን ጠለዕሉ እስ ሬሀኖበእሃን፤ አዪሁ ሆንጠሆተ አታለኖበእ ኑሬን ሄአኖሃን፤ እሱንከ አዪሁ ለዕይ ከሰበአ፤ ህትን አዪሁ ለኦስተ አታለኖበአ፤ እሲንከ ኬዕምኙለከ ዎልቀት ዘላለሚሃ እኩንስ፤ ኣሚዕን! ");
INSERT INTO alw_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","ነኡ ሙንደዕኖተ ጉዕመንከ በትሽ ኣሰኖ መገን ቤሉ ከን ኣዱንያ አሌን ዮ ቀባጣመት ቦንታበእገ ህከረንገ አመንስሾበእ ቀባጦን ተቢሳሃ አታበእገ አዘዝሰ። ");
INSERT INTO alw_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","ህትን ጡመተ ሆጉተ አቶተ፥ ጡመ ሆጎን ቀባጣመተ እኮተ፥ መኒሃ ሀዕሊሃ ዮሳሃ ቤኮተ ተቃጠባገ አዘዝሰ። ");
INSERT INTO alw_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","ህትንን ሀንቅ ሄኡ ደእቶተ ቀበቡሰ ጠረኘ እኮ ቀባጡተ አሜተኖ ዘማኒሃ ገይሃሰ ጭምአታአ። ");
INSERT INTO alw_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","ጥማቶሴ! ኣሰንቶሄ ኤገተ አገር፤ ህትን ገገይንከስ ሀንበእለንሺን ኤንኬዕኒን እሁዕነ መኑ ክዝብን «ኤንኬዕነኑሃን» ይት ገእታ ኤንኬዕኒችለከ ደግለለኖበእ ኣዱንያ አል ጠዊች ሁን። ");
INSERT INTO alw_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","መት-መቱ መኑ «ህትኔ ኤንኬዕኑ ዮኔ» ይተን አመዕነት ዎቃሃ ሉሶኡ፤ መገን ኣስቱት ክዕኔን እኩን!");
INSERT INTO alw_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","መሲህ ኢስን ደገሞ ሄእ ተብሴ መሳን መገን ሰውቲን መሲህ ኢስሃ አሳቤቹ እኮም ጳዉሎሴች ሶሃሞእሃን፤ ");
INSERT INTO alw_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","ጠረኝሽ ኢታም ቤቲሃኤ ጢማቶሴሃ ሶሄማእተ ሶህኑ፤ አናኔ መገን አዲች ቀርቹሃኔ መሲህ ኢሲች ኣስቱት፥ ማርቱትለከ ወገሬቱሁ ኬሳሃ እሁን። ");
INSERT INTO alw_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","ጉዕመ ወክት ሀንከዕርተለከ በራሃ ኬሳሃ ዱኢን ሰዉ ያም ወክት አናኑኤ አቶገን አን ነጠ ቀልቢን ካደማም መገኑኤ ገለትጫም። ");
INSERT INTO alw_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","ህትን ኢንጂጀክ ሰውየን ኬሳሃ ለዕይ አበ ሙንደኦተ ሃሸኣም። ");
INSERT INTO alw_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","ህትን ኪን ዮ ሀንቅ አመዕነቱ ሰውያሚት፤ ሁኩ አመዕነቱንኩ ሄጭ አበመክ ሎይድኒለከ አመክ ኤዉንቄኒ ዮሃ እቅ፤ ኪን ሁኩ አመዕነቱ ዮገ ደጎም። ");
INSERT INTO alw_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","ህካን እኮቤቺሃ አንገእ አሌክ አዕዮም ወክት ኪ ኣዜን ዮ ኣሰሞሄ መገን ኣስቱተ ቴሁ ኬሰንስቶተ ቃግሳንኬት። ");
INSERT INTO alw_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","መሰንትስ መገኑ ወልቀተ፥ ኢቱለከ ገዉ አገዕር አያን ቤሉ ዋጄኖ አያነ ኣስዮኔበአ። ");
INSERT INTO alw_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","ቴሱ ቀርችሃኔ ዱዱብሱ ሙልቶት፤ እስተኔሃ ኡሱረሞም ኢን ሙልቶት፤ ጠዉ እኮጎሬ መገኑ ኣሰኖ ወልቃን እንጂልተኔሃ ኢን ሜጡባ ኦርሸተ ቶግ። ");
INSERT INTO alw_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","ህትን ነኡ አዕኖም ጡመ ሆጎገ እሁዕነ ገይስ ሃሽኣቶንለከ ኣስቶ ጠሊልማን ገእ ፌሾኔ፤ ጠሊልማንተ ገኤኔ፤ ከ ኣስቱንተ ዘመኒች ብርተ መሲህ ኢስ መሳን ኣሴኔ። ");
INSERT INTO alw_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","ሁኩ ኣስቱንት ፌሳንቹኔ መሲህ ኢሲ አሜቲንከስ ቴሱ ለሌእ፤ እስን ሬሁተ ቤሽ እንጂል ላገ አዲን ሬሁ ዮበኢሃ ዘላለሚሃ ጉዕሚንከ ሄዕናም ሄኡ ለሊሾኔ። ");
INSERT INTO alw_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","አን ህከን እንጂል ላገ ዱዱብሳንቹ፥ አሳቤቹለከ አስተማርቹ እክ ሾመሞም። ");
INSERT INTO alw_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","ከ ኦርሸተ ቶጋሚሁ ከኒሃት፤ ጠዉ እኮጎሬ አዬ አመዕኔም ጎሬ ደጋምቤቺሃ ሙላምበአ፤ ህትን አን እሲሃ ኣሴም ኤገተ ሁኩ በሩ ኢሎተ ኢለ አገሩ አታለኖገ አመዕናም። ");
INSERT INTO alw_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","አት መሲህ ኢሳን ዮ አመዕነቲንለከ ኢታን ኢች ሞጮጭቶንት አመዕነንቶ ላገተ ምሳልተ አት አገር። ");
INSERT INTO alw_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","ህትን ኒ በላን ዮ ጠሊለ አያኒን ኣሰንቶሄ ኤገተ አገር። ");
INSERT INTO alw_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","እስይ ባዶን ዮ አመዕናኑት ጉዕሙንኩ ግብ መርቶኤገ አት ደጋንት፤ እሰ በላን ፊጌሉስለከ ሄርሞጌኔስ ደገንታአ። ");
INSERT INTO alw_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","ኡሱረሚንከኤ ሙሉዕናን ኦኖስፎሮስ ልግብ ወክት ፎሎሲሾኤቤቺሃ ቀርቹ ኢስ ኦኖስፎሮሴ አበሮሲ አሙዙንሰ። ");
INSERT INTO alw_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","ህትን ሮም ከተመ አሜቾም ወክት አበ ሀሽ ኢን ደቀሞ። ");
INSERT INTO alw_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","ህካን እኮቤቺሃ ቀርቹ ኢስ ህከ በር መገኒች ማርቱተ ደአኖገ አኡንስ፤ ህትን ኤፌሶን ከተማን ዮም ወክት ሄንከ ሀዕሌኤ ጎር አት ጡመገ አት ደጋንት። ");
INSERT INTO alw_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","ኢ ቤቶ! አት መሲህ ኢሳን ዮ ኣስቶን ጠረኝ። ");
INSERT INTO alw_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","ህትን ልግቤ ምስክር ብሬን ኢች ሞጮጭቶንቲሃ ዎሉ መነ ተማርስቶተ አታልታ አመዕነሞ መኒሃ ኤገተ ኣስ። ");
INSERT INTO alw_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","አት ገዉክ መሲህ ኢሲሃ ጠረኘ ዎታደረ እክ ኦርሸተ ቶግ። ");
INSERT INTO alw_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","ህትን በገዝ አነ ሙንደእሲሶተ ሀሾ ወታደሩ አዪሁ ወታደር ሆጉተ እኮበእ ሆጎን ሆሰኖበአ። ");
INSERT INTO alw_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","ህትን ደጉዶን ሄጫቀሞተ ሀሾ መኑ ሴርስ ሃሌን ሄጫቀምበጎር ቄል ሽልማት ደአኖበአ። ");
INSERT INTO alw_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","ጠረኝ አቡረኖ ገበሬቹ ዉጣች ወዕኔስ ላልቹ ደኡ ሀስሰኖስ። ");
INSERT INTO alw_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","ቀርቹ ኢስ ጉዕመንከ ጠዋን ደጉ ኣሰኖሄቤቺሃ አን ያንኬ ጠወ ሰውይ። ");
INSERT INTO alw_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","ሬሆች ኬዕዮ ደዉዴ ዘሬች እኮ መሲህ ኢሰ አጥራመት፤ አን ዱዱብሳም እንጂል ላገት ተኒት። ");
INSERT INTO alw_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","ሂለ ሆጉተ አዕዮ መንችገ ከን እንጂል ላገ መሳን ሰንሰለቲን ኡሱረሞተ ኢለ ኦርሸተ ቶጋሚት፤ ጠዉ እኮጎሬ መገን ላገት ኡሱረንታበአ። ");
INSERT INTO alw_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","ህካን እኮቤቺሃ እሰ መሲህ ኢስ መሳን ደገመኖ ጡሙለከ ዘላለም ኬዕምኝ ደዕቶተ መገኑ መጠሮ መንተኔሃ ይኬዕይ ጉዕመ ጠወንከ አታዕላም። ");
INSERT INTO alw_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","ህትን «እሲን ሜጡበ ሬኖም ጎር እሲን ሜጡበ ፎሊን ሄዕናም። ");
INSERT INTO alw_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","አታዕሊን ጠረኝን ሄዕኖም ጎር እሲን ሜጡበ ዎመ እንካም ነኡ እሱ ለገዕኖምጎር እስን ኔሳሃ ለገአኖኔ። ");
INSERT INTO alw_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","ህትን ነኡ አመዕነምባ ጎሬሁ እስ ገዉስ ለገኦተ አታለኖበእቤቺሃ አመዕነሞሃ እክ ሄአኖ» ይታ ላገት ሀንቅሃን። ");
INSERT INTO alw_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","ከን ጠውተኔሃ ቃጋገ አእሰ፤ ህትን ሞጮጨኖ መነ ቤስ ቤሉ መቱርቹሃ ደግለልባሃ እኮቤቺሃ ላጋተስ ኦደንትበገ መገን ብሬን ጠረኝስ ኩልሰ። ");
INSERT INTO alw_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","ህትን ሀንቅ ላገተ ጌጥ አዕይ ተማርሰኖ ሙልስበ ጠረኘ ሆጎ መንቹ እክ መለልት ገዉክ መገን ብሬን ሆንጠህሶተ ጠረኝ። ");
INSERT INTO alw_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","ህትን ከን ኣዱንያ አሌን መገኑ ዮበእ ጠውችለከ ገውመተ ጠወኢች ሁን፤ መሰንትስ ህትኔ ሆጉት መኑ መገኒች ቄዕረኖገ አታእተ። ");
INSERT INTO alw_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","እሰ ጠወኣ ጠዉ ጠረኘ ጡሌገለከ ሆሰን ገለን እተን አልባዕለን መረኖሃን፤ ህካን እኮቤቺሃ መን በላን ሄሜኖስለከ ፌለጦስ ሄኣአ። ");
INSERT INTO alw_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","ሁኩ መኑንኩ «ሬዮ መን ኬኡ ከኒች ብርንተ እኮኡ» ይተን ሀንቅ ዎቄች ፉልቶእረን፤ እሰን መት-መቶ መን አመዕነቱ ሌንቄቅሳእት። ");
INSERT INTO alw_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","ጠው እኮጎሬ «መገኑ ገይስ መነ ደገኖ፤ አን ቀርችየ የኖሁ ጉዕሙንኩ ሂለ ሆጎች ሁኑን» የኖ ማተሙ ዮ ሌንቄቅበ መገን ሀንቁ ምኒ ቀበብገ ጠረኝ ሄአኖ። ");
INSERT INTO alw_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","መቶ ቀባጣሞ መንች ምኔን ጠለዕል ዎርቅለከ ብር ኦደተ እሁዕናን ሀቅለከ ትብ ኦደት ዮኡ፤ እሳችን መት-መቱሰ ኬዕምኚሃ ዎሉሰንገ ኬዕምኙ ዮበእ ክድማተ እካአ። ");
INSERT INTO alw_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","ቴሁ አዪሁ ከን ሂለ ጠዊች ገዉስ ነጠ አዕዮ ጎሬ ቀርቺሃስ ደግለልታ ጡመ ሆጎተ ጉዕሚንከ ቅጥይቶ ኬዕምኝ ኦዳተ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","ህካን እኮቤቺሃ ሂለ ዎደልመ ሄዕላቻች ሁን፤ ነጠ ቀልቢን ቀርቾሃ ኢስ ሱዕመ ገእታሀኑኡን ሀንቅ እኮ ጠወ አተን አመዕነቱ፥ ኢተተለከ ወገሬት ጠረኝት አዎን። ");
INSERT INTO alw_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","ጠዉ እኮጎሬ ብተተ ኤበኖሃ እሁስ ደጋንትቤቺሃ ገውመለከ ደግለልትበ ኦዳች ሁን። ");
INSERT INTO alw_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","ቀርቾ ኢስ ካድንቹ መኒሃ ጉዕሚንከ ጎደበ ላፈ፥ ተማርሶተ አታለኖሃለከ እጀቀኖሃ እሁ ሀስሰኖስ ቤሉ ብተመኖሃ እሁ ሀስሰኖስበአ። ");
INSERT INTO alw_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","ሀንበዕለንታ መነ ጎደበ ላፍማን ሸዙ ሀስሰኖ፤ አይደጎ መገኑ ቶበት ሀንቅ ደግ ሀንቅቤቹ አሜቶተ ሳመ ኣሰኖሳሃ እሆተ አታለኖ። ");
INSERT INTO alw_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","ከን ሃሌን እልቢስ ሰውት ዊንሽቶተ ኡሱረንት ሄኦ እቅ ሼይጣን ዎሻዲች ገፈርሲጭቶተ ቀልቡሰ ፈንቀለኖሃ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","መጨረሽ ዘማኔን ኦርሸ ወክቱ አሜተኖገ ካን ደግ። ");
INSERT INTO alw_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","መሰንትስ መኑ ገውሰ ኢትታእረ፥ ብረ ኢትታእረ፥ ለዕዬኔ ለዕዬኔ ይታእረ፥ ቦንታእረ፥ ቦሮዕረንታእረ፥ አኒሀለከ አማተ አዘዘንትበረ፥ ዉለቱ ዮሰበእረ፥ ጠሊልመት ዮሰበእረ፥ ");
INSERT INTO alw_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","ኢተት ዮሰበእረ፥ መ ጠዋኒ መኒን ኢተቀንትበረ፥ መን ሱዕመ ቤሳእረ፥ ገውሰ አገዕርትበረ፥ ጎደበ ጠረኛኑተ፥ ጡመርቹ ግባእረ፥ ");
INSERT INTO alw_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","ለገኣስንቻኑተ፥ ደዕለንስታእረ፥ ቦኒን ቡሰንታእረ፥ መገኑ ኢቲች በትስ ተስቄነጡ ኢትታእረ እካአ። ");
INSERT INTO alw_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","ህትን እሰን ሀይማኖቱ ዮሰረ አጉዳአ፤ እኮጎሬ አመዕነትሰ ዎልቀተ ካዳአ፤ ህትናሞ መኒች ገበጭ ይት ሁን። ");
INSERT INTO alw_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","ህትን እሰን ምነተ ደጉደን ኣግ ሰውቲን ላፈ እኮ አደደ ጩቢን ዊንቶረለከ ልግቤ ሄዕላቻን ቀልቡሰ በዕዮ ሜንቱ አፋአ። ");
INSERT INTO alw_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","ህትኔ ሜንቱ ጉዕመ ወክት ተማርታአ፤ ጠዉ እኮጎሬ ሀንቅ ደጋ ቤቹ አሜቶተ አታልታበአ። ");
INSERT INTO alw_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","ህትን ኢያኔሲለከ ኢያንበሬስ ሙሲን ኦደንቶሀንገን ኩ መኑሁ ሀንቅ ግባአ፤ እሰን ቀልቡሰ በዕያን አመዕነቲችሰ ኡባአ። ");
INSERT INTO alw_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","ጠው እኮጎሬ ኢያኔሴለከ ኢያንበሬሴ ገውመት ለልቶሀንገን ከን መን ገውመት ጉዕመ መን ብሬን ለልታቤቺሃ መከኖሰበአ። ");
INSERT INTO alw_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","ጠው እኮጎሬ አት ትምርትኤ፥ አን ሄዕዮምገ፥ ሰውትኤ፥ አመዕነቱኤ፥ አታዕሉኤ፥ ኢተኤ፥ ጠረኝመኤ፥ ሸረሙኤለከ ኦርሸኤ አዎንቶንት። ");
INSERT INTO alw_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","ህትን አንጦከሃ፥ እቆንዮነሃ፥ ልስጥረሃ ዬኖ ከተማን አሌንከኤ ኢሌኤ ጠወለከ አታዕሌም ቶቸሙ ደጋንት፤ ጠው እኮጎሬ ጉዕመርቺችን ቀርቹ ኢስ ጡምሾኤ። ");
INSERT INTO alw_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","ሀንቅንከ መሲህ ኢሲን መገኑ አጉደን ሄኦተ ሀሳ መኑ ጉዕሙንኩ ሸረንታአ። ");
INSERT INTO alw_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","ጠው እኮጎሬ ሂሉለከ አመዕነንትቡ መኑ ሉስሰን፥ ሉሰን ሂልመ አሌን ሂልመተ በርግተን መርታአ። ");
INSERT INTO alw_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","እኮጎሬ አት አዬች ተማርቶንት ጎሬ ደጋንትቤቺሃ ተማርቶንትለከ አመዕንቶንት ጠዋን ጠረኝት ኡር። ");
INSERT INTO alw_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","አትን ኦስማችክ ኬስ መሲህ ኢሳን አመዕኒን ጡም አደ አዎንስቶተ አታልታ ጠሊላኑተ መጻፈተ ደጎንት። ");
INSERT INTO alw_vpl VALUES ("T23_16","085_3_16","2TI","3","16","17","ጠሊላኑት መጻፈት ጉዕሙንኩ መገን አያኑ አዎንሰን ከተበንቶእራን፤ እስን መገን መንቹ ቀነጤኖርቹ ዮበኢሃ፥ ጡመ ሆጎተ ጉዕሚንከ ቅጠሞሃ እሆተ ተማርሲሃ፥ ዎቀሻተ፥ ሉጨንሺች ፈንቀሺሃ፥ ነጥማን ሮስሲሃ ደግለልታእረ። ");
INSERT INTO alw_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","መገን ብሬን ፈንቀል አሜተኖለከ ዎመ እሀኖ ወክት ፎሊን ዮ መን አሌንለከ ሬዮ መን አሌን ፈረደኖ መሲህ ኢስ ብሬን ኤገተ ያንኬ። ");
INSERT INTO alw_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","መገን ላገንተ ዱዱብስ፤ ወክቴንለከ አለወክቴን ጠረኝ፤ አታዕሊን ተማርስተን ሆጉዕናን ኩልተንለከ ኡሙዕርተን ሸዝ። ");
INSERT INTO alw_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","መሰንትስ መኑ ጡመ ትምርት ሞጮጭቶተ ሀስቡ ወክቱ አሜተኖ፤ ጠው እኮጎሬ መጫተሰ ተሽ የኖ ጠወ ኩልታሰቤቺሃ ገይሰ ሃሽኣቶገ ተሽ የኖሰ ጠወ ኩልታሰ አስተማረተ ጭምአታአ። ");
INSERT INTO alw_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","እሰ ሀንቅ ሞጮጭታሀኒች መጨሰ ማቁተ ሞጮጭቶተ ፈንቀሽታአ። ");
INSERT INTO alw_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","ጠው እኮጎሬ አት ጉዕመ ጠዋንን አጥራመቶንቲሃ እህ፤ ኦርሸንተ አታዕል፤ እንጂለ ዱዱብሱ ሆጉክ አእ፤ ሆጉክን ዊንሽት አእ። ");
INSERT INTO alw_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","አን ክትም እሃም ወክቱ ሆንጠኮኡ፤ ህትን ከን ኣዱንያ አሊች መለዕለም ኦሮኣም ወክቱ ኢልዮኡ። ");
INSERT INTO alw_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","ጡመ አጰንሸ አጰሞም፤ ሄጫቀመኖ መንቹ ሄጫቀሙስ ሹሎሀንገን ክድመኤ ሹሎም፤ አመዕነቱኤ አገሮም። ");
INSERT INTO alw_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","ቴሱ ከኒች ኤተሮን ፈዩ ሽልማቱ ቅጥይ አገረኖኤ፤ ኩ ሽልማቱ መገኑ እስ ሃሽኣቶገ ሄዕዮምቤቺሃ ኣሰኖኤሃ ሽልማት፤ ህካን እኮቤቺሃ ጡመ ፍርደ ፈረደኖ ቀርቹ ኢስ ህከ በር ኣሰኖህዕኔ፤ ህካንን ጠለዕል ኤሳሃ እሁዕነ እስ አሜተኖገ ኢተኖ መኒሃ ጉዕሚንከ ኣሰኖሰ። ");
INSERT INTO alw_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","ደዕልት ኢቤቹ አሜቶተ አታልስሾሄሃ ጉዕመንከ አእ። ");
INSERT INTO alw_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","መሰንትስ ዴማስ ከን ኣዱንያ አል ጠወ ኢት ኢች መለዕለም ተሰሎንቄ ከተመ ኦሮዕዮኡ፤ ቄርቂስ ገለትይ ባዱ ኦሮዕዮኡ፤ ህትን ቲቶስ ድልማጥ ባዱ ኦሮዕዮኡ። ");
INSERT INTO alw_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","ጠለዕል ሉቃስ ኢን ሜጡበ ዮኡ፤ ማርቆስ ሆጎተ አበ ሀዕለኖኤቤቺሃ እሱ ኣእት አም። ");
INSERT INTO alw_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","ጠዉ እኮጎሬ ትልቆሴ ኤፌሶን ከተመ ሶኮም። ");
INSERT INTO alw_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","ህትን አሜታንት ወክት ጢሮአድ ከተማን ካርፑስ ቤቾን ዮ ኮርቦተለከ አደደ ጎጊች መክሴመሀኔን ከተበንቶ መጻፈተ ኣእት አም። ");
INSERT INTO alw_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","ናሰ መክሰኖ አለክሰንደር ኢ አሌን ሂለ አበ ጠወ አዕዮኡ፤ እሲንከ ቀርቹ ሆጎስገ ባተኖስ። ");
INSERT INTO alw_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","ነኡ ጠወዕናም ጠዋን እስ አበ ሀንበዕለመኖቤቺሃ አት ገዉክ እሲች አገዕር። ");
INSERT INTO alw_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","ከሰሰሞም ጠዊሃ ወዕና መስለ ፈንቀሼም ወክት ጉዕሙንኩ ኢች አደ እኮ ቤሉ ሀዕሌኤሁ አዪሁ ዮበአ፤ ህካን መገኑ እሰ አሌን ጩብ አዕይ ወለኡንከ። ");
INSERT INTO alw_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","ጠዉ እኮጎሬ ኢ አዲን መገን ላገት ጉዕሙንኩ ዱዱብሰንቶተለከ አይሁደ እህቡ መኑ ሞጮጮተ ቀርቹ ኢስ ኢ መዴን ኡር ጠረኝሾኤ፤ ዞቤ አፌች ፌሾኤ። ");
INSERT INTO alw_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","ቀርቹ ኢስን ሂለ ጠዊች ጉዕሚችን አገረኖኤ፤ ሰሜ ጄነቲንከ ኢልሰኖኤ፤ እሲንከ ዘላለሚሃ ኬዕምኙ እሁን፤ ኣሚዕን! ");
INSERT INTO alw_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","ጵርስቂልለከ አቂላ ኦኔስፎርም አበሮስ ምኒ መኒሃ «ወገሬቴ» ይ። ");
INSERT INTO alw_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","ኤራስጦስ ቆሮንቶስ ከተማን ፈቆ፤ ህትን ጥሮፊሞስ ጥዦቤቺሃ ሚሊጢን ከተማን አጉሮም። ");
INSERT INTO alw_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","አት ከርሙ ኣጉዕነ አታልስሾሄ ጌሳን ሄጭት ኢቤቹ አም፤ ኤዉብሎስ፥ ጱዴስ፥ ሊኖስ፥ ቅላዉድየለከ አመዕናኑት ጉዕሙንኩ «ወገሬት ዮንትንዶ» ይታሄት። ");
INSERT INTO alw_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","ቀርቹ መሲህ ኢስ ኪን ሜጡበ እሁን፤ መገን ኣስቱት ክዕኔን ሜጡበ እኩን። ");
INSERT INTO alw_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","መገን ካዲንቹለከ መሲህ ኢስ አሳቤቹ እኮም ጳዉሎስ መገኑ መጠሮሰ መነ አመዕነትቤቹ ገኢሃለከ መገኑ አጉድ ሀት እክ ሄኡ ሀስሰኖሰ ጎሬ ለሊሰኖ ሀንቅ ደጎተ ተማርሶተ ሹመ እኮም ጳዉሎሴች ሶሀሞእሃ፦ ");
INSERT INTO alw_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","ሁኩ ሀንቁ ዘላለሚሃ ሄኡ ተሬገጥሲሽ ኣሰኖ፤ ህካንን ዘላለሚሃ ሄኡ ኣሰኖኔገ ዘመኒች ብርተ ሄጭ ጠወዕዮሁ ክዝብበሃ መገኑ። ");
INSERT INTO alw_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","ዘማኑስ ኢሌ ወክት ፌሳንቹሃኔ መገን ትዛዚን አን ዱዱብሶተ ኣሰሞኤ ዱዱብስ ኤገ መሳን መገኑ ሶህኑስ ለልሾ። ");
INSERT INTO alw_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","ሜጡበ አመዕንኖም አመዕነቲን ሀንቅ ቤቱኤ እኮ ቲቶ አነ እኮ መገኒችለከ ፌሳንቾ መሲህ ኢሲች ኣስቱትለከ ወገሬቱ ኬሳሃ እሁን። ");
INSERT INTO alw_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","ኬሳሃ ቀርጤሳን አጉሮም መሰት መክበርቹ መክሶተለከ አን አዘዦንኬገን ከተማን ጉዕማንን አመዕናኖ ባልቀተ ሾንቶታት። ");
INSERT INTO alw_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","አመዕናኖ ባልቁንኩ ቀነጤኖስርቹ ዮበኢሃ፥ መቴ መንቾ ምኒ አነ እኮኢሃ፥ ማሊተ አኢንለከ አዘዛሙ ሆጊን ዎቀሰንትቡ መገኑ አመዕንቶ እለት ዮሲሃ እሁ ሀስሰኖስ። ");
INSERT INTO alw_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","መሰንትስ አመዕናኖ ዱእ ምኒ አዎንሳንቹ መገን ሆጎ ኤገተ ቶጎሃ እኮቤቺሃ ቀነጤኖስርቹ ዮበኢሃ እሁ ሀስሰኖስ፤ እስን ቦንባሃ፥ ኡሙዕርባሃ፥ ሰከርባሃ፥ ብተምባሃለከ ብሪሃ ጎራይባሃ እሁ ሀስሰኖስ። ");
INSERT INTO alw_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","ጠዉ እኮጎሬ ኮሃ ቶገኖሃ፥ ጡመ ጠወ ኢተኖሃ፥ ገዉስ አገዕረኖሃ፥ ሀንቅ ኢተኖሃ፥ መገን ሆጎተ አደ እኮሃለከ ዮስ ጌሲን ሄአኖ እሁ ሀስሰኖስ። ");
INSERT INTO alw_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","እስን ዎሉ መነ ሀንቅ ትምህርት ተማርሰን ሸዞተለከ ህከ ላገተ ኦደ መኒሃ መስለ ኣሶተ ከኒች ብርተ ተማሮ ትምርት ሃሊን አመዕነንቶ ላጋን ጠረኙን። ");
INSERT INTO alw_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","ልግቡ መኑ በትሽን አይሁድ አድረ እኮእሩ ጡርከሜኖ ሴረ አዎንታሩ፥ አዘዘንትበረለከ ተሰ እኮ ጠወ ጠወአን ሉሲሳእሩ ዮኡ። ");
INSERT INTO alw_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","ከ መናከተ ሰዕም ይታገ አኡ ሀስሰኖ፤ እሰን ገበእበ ትርፈ ደእቶተ ገበእበ ጠወ ተማርስተን አበሮሱ ጉዕመንከ ኩማዳአ። ");
INSERT INTO alw_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","እሳች መቱስ ገይሰ ራጋንቹ «ቀርጤስ መኑ ጉዕመ ወክት ክዝበኛኑተ፥ ሂለ ቡሳወ እኮእራ፥ ሆጉተ ኢትቲበለከ ጎራሜቻኖታን» ዬእ። ");
INSERT INTO alw_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","ኩ መሰከረሞ ጠዉንኩ ሀንቅሃን፤ ህካን እኮቤቺሃ ዊሙ አመዕነቱ ሄኦሰተ ከ መነ ጠረኝስ ኡሙዕር። ");
INSERT INTO alw_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","አይሁድ መን ማቁተ አዎንትበገለከ ሀንቅ ግብ ኦዳ መን ትዛዝ ሞጮጭትበገ ጠረኝስ ኡሙዕርሰ። ");
INSERT INTO alw_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","ነጠ መኒሃ ጉዕሙርቹንኩ ነጠሃን፤ ጠው እኮጎሬ ንጃሶሀኑኡተለከ አመዕንትበሀኑኡተ መቱርቹሁ ነጣበአ፤ ህትን ቀልቡሰለከ ሰው ይታርቹ ንጃሾእሃን። ");
INSERT INTO alw_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","እሰን «መገኑ ደንጋም» ይተን ሆጎንተሰ እሱ ለገኣእረ፤ ህትን ኮፍ ይታእረ፥ አዘዘንትበረለከ ጡመ ሆጉተ አኡ አታልትበረ። ");
INSERT INTO alw_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","አት እኮጎሬ ሀንቅ ትምህርት ተማርስ። ");
INSERT INTO alw_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","ኡሙሪን ባልቆ ጎኑ ወልቀሰ ጌሲን ሄኣእራን፥ ኬዕምኝሰ አገርታእረ፥ ገውሰ አገርታእረ፥ አመዕነቲንለከ ኢታን አታዕሊኒን ሂልመት ዮሰበእረ እካገ ሸዝሰ። ");
INSERT INTO alw_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","ህትን ኡሙሪን ባሊቆ ሜንቱ አመዕነቱሰ አገርት ሄኣእረ ሄዕምትበረለከ ሰከርትበረ ጡመ ጠወ ተማርስታእረ እካገ ሸዝሰ። ");
INSERT INTO alw_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","ህትን ባሊቆ ሜንቱ ሀርድ ሜንቱ ምንሰ አናኑተለከ እለሰ እትታእረ፥ ");
INSERT INTO alw_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","ገውሰ አገዕርታእረ፥ ነጣኑተ፥ ጉዕመርቾንን ምንሰ አገርታእረለከ ምንሰ አናኑተ ኬዕምሳእረ እካገ ተማርስቱንሰ፤ ህካንን አታኢሁ መገን ላገት ህንቀንታበእጋት። ");
INSERT INTO alw_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","ህትን ዎደልቹ ገውስ አገዕር ሄአኖገ ሸዝ። ");
INSERT INTO alw_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","አት ጡመ ጠወ አተን ጉዕመ ጠዋንን ምሳልተ እህ፤ ትምርቲንከክ ሀንቅ መንቹ እሁክለከ ደግለለኖ ጠዉ ዮሄ መንቹ እሁክ ለሊስ። ");
INSERT INTO alw_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","ህንቄኖበእ ጡመ ጠወ ለሊስሰ፤ ከን ሃሌን ኔሳሃ ግባኔሩ ኒ አሌን ጠወአ ሂለ ጠወ ሆጋረ ሙልታአ። ");
INSERT INTO alw_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","ካዲመት ቀርቻኖተሰ አዘዘንታገ፥ ጉዕመርቾንን ቀርቻኑሰ ሙንዲሲሳገ፥ ሂለ መስለ ፈንቀሽት ጠወኣበእገ፥ ");
INSERT INTO alw_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","ሞግትበገ ሸዝሰ፤ በትሽን ፌሳንቹሃኔ መገን ትምርቱ ጉዕመ ጠዋንን ኢተሞሃ እሆተ ጉዕመ ወክት ዊመ ደገንቶእረ እኩን። ");
INSERT INTO alw_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","መገኑ መነ ጡምሰኖ ኣስቱስ ጉዕሚንከ ለሊሾኡ። ");
INSERT INTO alw_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","ሁኩ ኣስቱንት ለግተለከ ኣዱንያ አል ሄዕላቸተ አጉሬን ገዉ አገዕሪን፥ ጌጥዬለከ መገኑ አጉዲን ከን ዘማኔን ሄዕኖተ ተማርሰኖኔ። ");
INSERT INTO alw_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","ከን ሃሊን ማሰአሞ ተብሳኔ ሁኩንን ሎሩ መገኑኔለከ ጡምሳንቹኔ መሲህ ኢስ ኬዕምኚን አሜቱስ አገዕርናም። ");
INSERT INTO alw_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","መሲህ ኢስ ሾክማች ጉዕሚችን ጡምሶኔተለከ ጡመ ሆጉተ አዕኖተ ጠረኛኑተለከ እሲሃ አደ እንኮም ነጠ ኡመት እንኮተ ነጠ አኦኔተ ኒተኔሃ ገዉስ ህግሽ ኣሴእ። ");
INSERT INTO alw_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","ቴሱ ከ ጉዕመንከ ጠወ ዊመ ሹምነቲን ተማርስ፤ ሸዝ፤ ኡሙዕር፤ አዪሁ ህንቁንከሄ። ");
INSERT INTO alw_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","መኑ ጉዕሙንኩ ገሽታሰሀኑኡተለከ ዳኛኖተ ገዉሰ ሆፍስ አዘዘንቶተ ጡመ ሆጉተ ጉዕመንከ አቶተ ተቃጠቦረ እኮተ ");
INSERT INTO alw_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","ሀከን መንች አሌኒ ሂለ ጠወ ጠወኣበእገ ሰዉ ይታገ አእሰ፤ በትሽን መኒን ብተንትበረለከ ጎደበ ላፋኑተ፥ ገዉ ሙግ አኤን ሄኡ መኒሃ ጉዕሚንከ ለሊሳእረ እኩን። ");
INSERT INTO alw_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","ነኡን ከኒች ብርተ ገዋኑተ፥ ትዛዝ ቶንግበረ፥ ጡመ ዎቃሃ ሉንሶምረ፥ አደደ ሂለ ሄዕላቻተለከ ማል ተሽቲሃ ጠገሞምረ፥ ተንኮንለከ ምቀኞማን ሄዕናምረ፥ ግበሞምረለከ መት-መቲንከኔ ኢተቀምበረ እቅ። ");
INSERT INTO alw_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","ጠው እኮጎሬ ጩብችኔ ጡምሾኔ መገንኔ ጎደብ ለፍመትለከ ኢተት ዊንቶ አሙዙ ለሌ ወክት ");
INSERT INTO alw_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","ነኡ አዕኖም ፈየ ሆጎንተኔ እሁዕናን ገዉንኩስ ማርቶንከስ ጡምሾኔ፤ ጡምሾኔንኩ ሃዕሮ እለሚን አዕሊንለከ ጠሊለ አያኒን ደገሞ ሃዕሮሃ ሄኡ። ");
INSERT INTO alw_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","መገኑ ኣስቶንከስ ጡምሳንቹሃኔ መሲህ ኢስ አዲን አያነስ ኒ አሌን በትሽ ደፈፍሾኔ። ");
INSERT INTO alw_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","ህካንን አዕዮሁ ኣስቶንከስ ፈያኑተ እንክ ተብሴን አገርናም ዘላለሚሃ ሄአኖ ሄኡ ረገዕኖታት። ");
INSERT INTO alw_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","ኩን አመዕነሞእሃ ጠወ፤ መገኖን አመዕንቶ መናከት ጡመ ሆጎተ ጠረኝቶተ ከ ጠወ ጉዕመንከ ጠረኝስ ቃግሶተ ሀሳም፤ ኩ ጠዉንኩ ጡመለከ ጉዕመ መኒንከ ደግለለኖሃን። ");
INSERT INTO alw_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","ጠዉ እኮጎሬ ተሰ እኮ ኦዳች፥ ደቦ ዎልንሺች፥ ብታች፥ ሕግ መሳን ኬአኖ ጠዊች ቄዕር፤ ህትኔ ጠዉንኩ ደግለልባሃለከ ተሰሃን። ");
INSERT INTO alw_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","አደዶመተ ኤበኖ መንቹ መቶረ ህከረንገ ለሞረ ሸዞንትሲች ኤተሮን እሲች አደ እህ። ");
INSERT INTO alw_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","ህትኔ መንቹ ሂላለከ ጩበኛሃን፤ እስ ገይስ አሌን ፈረጆ እሁስ ደግ። ");
INSERT INTO alw_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","አርጤማሴ ህከረንገ ትኪቆሴ ኪቤቹ ሶሃም ወክት አን ዮም ቤቹ ኒቆጵልዮነ ደዕልት አም፤ አን ከርም ህከኔ ዱንኮተ ሙዕርዮም። ");
INSERT INTO alw_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","ሕገ ደገኖ ዜናስለከ አጵሎስ ዎቃሰ ሃንቶተ ደግለለኖሰርቹ ጉዕመንከ ሀዕልሰ። ");
INSERT INTO alw_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","ኒ መኑንኩ አቶቱ ዮበኢሃ ፈቃበእገለከ ደግለሸቀም ኦርሻች ጡምቶተ ጡመ ሆጉተ አኡ ተማርቱን። ");
INSERT INTO alw_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","ኢን ሜጡበ ዮኢሩ ጉዕሙንኩ «ዎገሬቴ ዮንተንዶ?» ይቶህዕኔ ይሰ፤ አመዕነቲን ኒን ሜጡበ እኮ ጃላተኔ ጉዕሚንከ ወገሬት ኢልስ። መገን ኣስቱት ጉዕሚንከክዕኔ ሜጡበ እኩን። ");
INSERT INTO alw_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","መሲህ ኢስተኔሃ ኡሱረኛ እኮም ኢች ጳዉሎሴችለከ አመኔቤቲች ጢማቶሴች ኢተሞ አመኔቤቱለከ ሆጎኔ ጃለ እኮ ፍልሞኒሃ ");
INSERT INTO alw_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","አመኔቤቶተ አፍብያሃ፥ ኒን ሜጡበ መሲህ ኢስ ዎታደረ እኮ አርክጳሴለከ ህትን ምኔክ ጭምይቶ አመዕናኖተ፤ ");
INSERT INTO alw_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","አንችኔ መገኒችለከ ቀርቾ መሲህ ኢሲች ኣስቱትለከ ወገሬቱ ክዕኔሃ እሁን። ");
INSERT INTO alw_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","4","ዱአ አኣም ወክት ኬሳሃ ሰውየን መገኑኤ ጉዕመ ወክት ገለትጫሚት። ");
INSERT INTO alw_vpl VALUES ("PM1_5","087_1_5","PHM","1","5","5","ቀርቾ ኢሳን ዮሄ አመዕነቱለከ ኢተተ ህትን አመዕናኖተ ዬሄ ኢተክ ሞጮጭዮም። ");
INSERT INTO alw_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","ኔሳሃ ሜጡ አዕዮኔ አመዕነቱ መሲህ ኢሲን ዮኔ ጡመ ጠወ ጉዕመንከ ብዝ አት አጥራመታንትገ አኦሄተ አን ኬሳሃ ዱአ አኣም። ");
INSERT INTO alw_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","ኢ አመቤቶ! ኪ መሳን አመዕናኖ ቀልብ ብዝ አዕይ ጠረኝሾቤቺሃ ኢተክ አበ ሙንዲኑተለከ ጠረኝመተ ኣቶኤ። ");
INSERT INTO alw_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","ህካን እኮቤቺሃ አኡ ሀስሰኖኤሃ አእ ይ ኬሳሃ አዘዞተ መሲህ ኢሲን መለል ጠወኦተ አታላም እቅ። ");
INSERT INTO alw_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","እኮጎሬ ካን አኣምሀኒች መሲህ ኢስተኔሃ ኡሱረኛ እኮም አን ባሊቆም ጳዉሎስ ኢታን ኡጩ መጠሮም። ");
INSERT INTO alw_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","አን ኡሱር ምኔን ሄአን ቤቱእ እኮ ኦናሲሞሴተኔሃ ኬሳሃ ኡጫንኬ። ");
INSERT INTO alw_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","አናሲሞስ ከኒች ብርተ ደግለሎሄበ እቅ፤ ቴሱ እኮጎር ኬሳሃ እኮ ኤሳሃ ደግለለኖኤ። ");
INSERT INTO alw_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","12","ህትን እሱንከ ኪቤቹ ፈንቀሽ ሶኮም፤ እሱ ኪቤቹ ፈንቀሽ ሶሃም ወክት ገዉኤ አዕይ ኢታምሀንገ አዕይ ወለኣም። ");
INSERT INTO alw_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","ተሽት ላገ መሳን ከኔ ኡሱረሞምሀኔን ኪቤቾን እክ ሀዕሎኤተ እስ ኢን ሜጡበ እኮ እቅ ተሽ የኖኤ እቅ። ");
INSERT INTO alw_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","ጠዉ እኮጎሬ አት አታንት ጡመ ሆጉተ ግዳጂን እሁዕነ ኢታን እሆተ ኬሳሃ ጠዕሙዕነ መቱርቹሃ አኦተ ሀሾምበአ። ");
INSERT INTO alw_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","አናስሞስ ቀዎ ወክቲሃ ኪች አደ እኮጎሬሁ ከ ኤተሩ ልግብ ወክት ኪን ሜጡበ ሄኦተ አታለኖ። ");
INSERT INTO alw_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","ከኒች ኤተሮን ኪን ሜጡበ ሄአኖሁ ሮስችገ እሁዕነ ሮስቺች በተዕዮሃ እክ ኢተሞ አመቤትጋት፤ እስ ኤሳሃ ኢታም አመኤሃ ቤቱ፤ ጠዉ እኮጎሬ እስ ኤሳሃ ኢታም አመኤቤቱ እኮች በትሽን ኬሳሃ ደግለሸቀሜኖ ሄኦንለከ ቀርቺን ሀት ኢተሞ አመክቤቱ እሀኖበአ? ");
INSERT INTO alw_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","ቴሱ ኤሳሃ አመክቤትገ አት ዎለኦንቴኤች ኢገ አት ቶግስ። ");
INSERT INTO alw_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","ኢልሾሄ ብድሉ ዮ ጎሬ ህከረንገ ኤዶ ዮስጎሬ ኢ አሌን ዎለእ። ");
INSERT INTO alw_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","አን ጳዉሎስ «ኤዳስ ባታም» ይ ገይኤ አንጋን ከተቦም፤ እኮጎሬ ኪ ሄእተኔሃ አት ገዉክ እኮንት እቃ ኢ ኤዶሁ ዮሄሃ እሁክ ቃግሱ ሀስሰኖበአ። ");
INSERT INTO alw_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","ቴሱ ኢ አመቤቶ! ቀርች ሱዕሚን ከ ጡመርቹ አቶኤተ ኡጫንኬ፤ ሀዕይ ቀልብኤ መሲህ ኢሲን ፎሎጨኖገ አኤኤ። ");
INSERT INTO alw_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","ካን አን ከተቦንኬሃ አታንትገ አመዕናም፤ ሆሮን አን ጠዕሜምሀኒች በትስ አታንትገ ደጋም። ");
INSERT INTO alw_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","ህትን መገኑ ዱአክዕኔ ሞጮጭ ክዕኔቤቹ አሜታምገ አአኖኤገ ተብሳሃ አኣምቤቺሃ ኤሳሃ ፎሎጫም ቤቹ ቅጥ አኤኤ። ");
INSERT INTO alw_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","ኢን ሜጡበ መሲህ ኢስተኔሃ ኡሱረሞ ኤጳፍረ «ወገሬት ዮንተንዶ?» የኖሄት። ");
INSERT INTO alw_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","ህትን ሆጎእ ጃለተ ማርቆስ፥ አርስጥሮኮስ፥ ዴማስለከ ሉቃስ «ወገሬት ዮንትንዶ?» ይታሄት። ");
INSERT INTO alw_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","ቀርቾ መሲህ ኢስ ኣስቱት ክዕኔን ሜጡበ እኩን። ");
INSERT INTO alw_vpl VALUES ("HB1_1","088_1_1","HEB","1","1","1","ብሬ ዘማኔን መገኑ ልግብ አደደ እኮ ዎቃን አበናኖተኔ ነብያኖ አዲን ልግብ ወክት ጠወዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("HB1_2","088_1_2","HEB","1","2","2","እኮጎሬ ከን መጨረሽ ዘማኔን ጉዕመንከ ረገአኖሃ አዕዮስ ቤትስ አዲን ኔሳሃ ጠወዕዮኔ። ህትን ጉዕመንከ ከለቆሁ እስ አዲንት። ");
INSERT INTO alw_vpl VALUES ("HB1_3","088_1_3","HEB","1","3","3","ቤቱስ መገን ኬዕምኝ ለሊሰኖሃን፤ እስን ዊመ ዊሚን መገኑ አጉደኖሃን፤ ወልቀት ዮ ላጋንከስ ጉዕመንከ ድክሽ አፎኡ፤ ህትን መነ ጩቢች ነጠ አዕዮች ኤተሮን ሎረ መገን መኬ አዲን ሰማን አፉዕልዮኡ። ");
INSERT INTO alw_vpl VALUES ("HB1_4","088_1_4","HEB","1","4","4","መገን ቤቱ መላይከ ሱዕሚች ሎሩ ሱዕሙ ኣሰሞስ ሃሊን እሳች በትሽ በተዕዮሃ እኮ። ");
INSERT INTO alw_vpl VALUES ("HB1_5","088_1_5","HEB","1","5","5","መሰንትስ መገኑ መላይካችስ መቲሀሲ «አት ቤቱሃኤ፤ አን አናክ» ህከረንገ «አን አነ እሃንስ፤ እሲሁ ቤቱእ እሀኖ» ዬኢሁ አዬህት? ");
INSERT INTO alw_vpl VALUES ("HB1_6","088_1_6","HEB","1","6","6","ህትን ሀንገፈ ቤቱስ ኣዱንያ አል ኤቦ ወክት «መገን መላይከት ጉዕሙንኩ እሲሃ ሰገዶስተ» ሀስሰኖ። ");
INSERT INTO alw_vpl VALUES ("HB1_7","088_1_7","HEB","1","7","7","እኮጎሬ መላይከተኔሃ ጠወአን «መላይከስ ቦብረ፥ ካዲመተ ጊረ ለበነተ አአኖ» የኖ። ");
INSERT INTO alw_vpl VALUES ("HB1_8","088_1_8","HEB","1","8","8","ጠው እኮጎሬ ቤትስተኔሃ፤ «መገኖ! ዳኞመክ ቦርጭመት ዘላለሚሃ ሄኣአ። ዎምነቶንከክ ጡመገ አት ገሽታንት፤ ");
INSERT INTO alw_vpl VALUES ("HB1_9","088_1_9","HEB","1","9","9","አት ፈዩተ ኢትት ሂለ ጠወ ግቦንት፤ ህከን መሳን መገኑ መጠሮሄ፤ ሙንዲኑተ ኣሰኖ ዘይተ ቡር ጃላችክ በትሽ ኢቴሄ» የኖ። ");
INSERT INTO alw_vpl VALUES ("HB1_10","088_1_10","HEB","1","10","10","ቴሁ ቤትስተኔሃ ህት የኖ፤ «ቀርቾ! አት ሄጭት ኡለተ ከለቆንት፤ ሰሞንኩ አንገክተ ሆጉ። ");
INSERT INTO alw_vpl VALUES ("HB1_11","088_1_11","HEB","1","11","11","እሰ ጉዕሙንኩሰ በኣአ፤ እኮጎሬ አት ሄኣንት፤ እሰ ጉዕሙንኩሰ ኦድኖገ ኑባጵታአ። ");
INSERT INTO alw_vpl VALUES ("HB1_12","088_1_12","HEB","1","12","12","ቡሉኮገን ጣጣንትሰ፤ እሰ ኦድኖገን ዶረንታአ። 2 አት ጉዕመ ወክትንከ አቴት፤ ዘማኑክ ሆሮ ጎፈኖበአ» የኖ። ");
INSERT INTO alw_vpl VALUES ("HB1_13","088_1_13","HEB","1","13","13","ጠው እኮጎሬ መገኑ መላይከ በሊች፤ «ባለጋረክ ሎካችክ ዎሮን አኦተ ኢለ መኬእ አዲን አፉዕል» ዬኢሁ አዬት? ");
INSERT INTO alw_vpl VALUES ("HB1_14","088_1_14","HEB","1","14","14","ህከረ መላይከት ጉዕሙንኩ ጡሙ ደእታ መነ ካደንቶተ ሶሀንቶ አያናከተበእንዶ? ");
INSERT INTO alw_vpl VALUES ("HB2_1","088_2_1","HEB","2","1","1","አይደጎ ነኡ ሞጮጭኖም ጠዊች ኤተሩ ዋልን ኡምባምበእገ አገዕሩ ሀስሰኖኔ። ");
INSERT INTO alw_vpl VALUES ("HB2_2","088_2_2","HEB","2","2","2","መላይከ አዲን ኩለንቶ ላገት ሀንቂተ እኮጎሬ ህተ ላገተ ቶጉ ግበኖ መንቹ ሀስሰኖ ሃሊን ቀጠአመኖሃ እኮጎሬ ");
INSERT INTO alw_vpl VALUES ("HB2_3","088_2_3","HEB","2","3","3","ነኡ ህከ ሎረ ጡሙ ሀምቦምጎሬ ሀት እንክ ፉሸእኖተ አታልናም? ከ ጡሙኔ ወዕና ኩሎኔሁ ቀርቹ ገዋስ፤ ህካን ጠረኝስ ኩልቶኔሩ እሲች ሞጮጭቶእሃ መነ። ");
INSERT INTO alw_vpl VALUES ("HB2_4","088_2_4","HEB","2","4","4","ህትን መገኑሁ ህከን ጡምተኔሃ መላተ፥ አበ አጀብሲሰኖ ሆጎን፥ አደደ ገረምሲጬኖ ጠዊን፥ እስ ሀሾ ሃሊን ኣሴ ጠሊለ አያን ኣስቶን መሰከሮኡ። ");
INSERT INTO alw_vpl VALUES ("HB2_5","088_2_5","HEB","2","5","5","ነኡ «ከ ኤተሩ አሜታአ» ይን ጠወዕናም ኣዱንያ አል መገኑ መላይከስ ጠቅቶተ ኣስዮበአ። ");
INSERT INTO alw_vpl VALUES ("HB2_6","088_2_6","HEB","2","6","6","መጻፍ ኣዜን መቶ ቤቾን መቱ መንቹ «አት እሱ ሰው ይቶተ መኑ መርቾሃን? ህትን ጨነቀንቶስተ መን እለት መርቾሃን? ");
INSERT INTO alw_vpl VALUES ("HB2_7","088_2_7","HEB","2","7","7","እሱንከ መላይካች ቀዎ ወክቲሃ ሆፍሶንትስ፤ ኬዕምኝለከ ገለት ዘዉደሃ ዎርቶንትስ፤ አንገክ ሆጎ አሌንን መክሶንትስ፤ ");
INSERT INTO alw_vpl VALUES ("HB2_8","088_2_8","HEB","2","8","8","መገኑ ጉዕመርቹንከ ሹምነቲችስ ዎሮን አቶንት» ህት ይ መሰከሮኡ። ጉዕመርቹንከ ደኞመስ ኣዜን አአኖረ፤ ዳኞማስ ኣዜን አኡዕነ ፌሾርቹ መቱርቹሁ ዮበአ። እኮጎሬ ቴሱ ጉዕሙርቹንኩ እስ ሹምነት ኣዜን እሁስ ለዕኖምበአ። ");
INSERT INTO alw_vpl VALUES ("HB2_9","088_2_9","HEB","2","9","9","ጠው እኮጎሬ መገን ኣስቶን ጉዕማንከ መንተኔ ሬሁተ ለዕኖተ ቀዎ ወክቴን መላይካች ዎሮ አዲን እክ ለሌ ኢስ ሬሆ ኦርሸተ ቶጎቤቺሃ ኬዕምኝለከ ገለት ዘውደ ዎሮሃ ለዕናም። እስ መገን ኣስቶን ጉዕምኔተኔሃ ሬዮኡ። ");
INSERT INTO alw_vpl VALUES ("HB2_10","088_2_10","HEB","2","10","10","መገኑ ጉዕመርቹንከ ከለቆ፤ ጉዕሙርቹንኩ ህትን ሄኦተ አዕዮ፤ ኢሰ ኦርሸ ኣዜን ህግሲን ጉዕመርቺሃ በቀዕዮሃ እሀኖገ አኡ እሲሃ ገበአኑሃን፤ መነ ጡምቤቹ አዎንሰኖሁለከ ልግብ ኦሱተ መገን ኬዕምኝ ቤቀንታገ አአኖሁ ኢሳት። ");
INSERT INTO alw_vpl VALUES ("HB2_11","088_2_11","HEB","2","11","11","መነ ጠሊላኑተ አአኖሳሁለከ እሶን ጠሊላኑተ እኮ መኑ መቶ አንተ ኦሱ፤ ህከን መሳን ኢስ እሰንተ «አመኤ ኦሶ» ይ ገኦተ ሙለኖበአ። ");
INSERT INTO alw_vpl VALUES ("HB2_12","088_2_12","HEB","2","12","12","ህካን እኮቤቺሃ አን መገኒሃ «ሱዕመክ አመኤ ኦሶተ ኩላም፤ አመዕናኖ ጭምት በላን ኬሳሃ ገለትጫንኬ» የኖ። ");
INSERT INTO alw_vpl VALUES ("HB2_13","088_2_13","HEB","2","13","13","ህትን «አመዕነቱኤ እስ አሌን አኣም» ህትን «አንለከ መገኑ ኣሴኤ ኦሱት ሁኩዕኑን» የኖ። ");
INSERT INTO alw_vpl VALUES ("HB2_14","088_2_14","HEB","2","14","14","ኦሱት ማሉለከ ቄጉ ዮእረ እኮገን ኢስሁ እሰገን መንቹ እኮ፤ ሁኩንን ሬሆንከስ ሬሆ አሌን ወልቀት ዮስ እልቢስ ቤሶታት። ");
INSERT INTO alw_vpl VALUES ("HB2_15","088_2_15","HEB","2","15","15","ህትን ሄአኖ ዘማኔን ጉዕማንን ሬሆገ ዋጄኖ ሮሶመ ኣዜን ጠገንቶረ ጉዕመንከ ዎዝሃት። ");
INSERT INTO alw_vpl VALUES ("HB2_16","088_2_16","HEB","2","16","16","ሀንቅ እሀኖረ ኢስ ሀሾ መላይከተ ሀዕሎተ እሁዕነ እብራሂም ዘርተ ሀዕሎታት። ");
INSERT INTO alw_vpl VALUES ("HB2_17","088_2_17","HEB","2","17","17","ህካን እኮቤቺሃ ማርቱተ አአኖለከ አመዕነሞ ሎረ ቂስቹ እክ መገኒሃ አኦተለከ መን ጩብ አጉሮተ መ ጠዋኒ አመስ ኦሱተ አጉዱ ገበዕዮስ። ");
INSERT INTO alw_vpl VALUES ("HB2_18","088_2_18","HEB","2","18","18","እስ ገዉንኩስ ፌተነም ኦርሸተ ቶጎቤቺሃለከ ፌተነሞቤቺሃ ፌተናን ኣጋእረ ሀዕሎተ አታለኖ። ");
INSERT INTO alw_vpl VALUES ("HB3_1","088_3_1","HEB","3","1","1","ህካን እኮቤቺሃ ሰሜ ጄነትሃ ገአንቴን ቤቀማኑተ እኬንተ ጠሊላኑት አመኤ ኦሶ! ጠወዕናም አመዕነት ሎረ ቂስቹ እሆተ መገኒን ሶሀሞ ኢሰ ሰዉ ይዬ። ");
INSERT INTO alw_vpl VALUES ("HB3_2","088_3_2","HEB","3","2","2","ሙስ ዱእ ምኒ ሆጎን ጉዕማን አመዕነሞኢሃ እኮገን ኢሲሁ እሱ ሾሞስ መገኒሃ አመዕነሞእሃ እቅ። ");
INSERT INTO alw_vpl VALUES ("HB3_3","088_3_3","HEB","3","3","3","ምኒ እጃረኖሁ ምኒች ሎሩ ኬዕምኙ ሄአኖስሀንገን ኢሲሃ ሙስ ኬዕምኚች በተአኖ ኬዕምኙ ሀስሰኖስ። ");
INSERT INTO alw_vpl VALUES ("HB3_4","088_3_4","HEB","3","4","4","መሰንትስ ምኒሃ ጉዕሚንከ መቱ እጃረኖሁ ሄአኖ፤ ጠዉ እኮጎሬ ጉዕመርቹንከ እጃሮሁ መገኑሃን። ");
INSERT INTO alw_vpl VALUES ("HB3_5","088_3_5","HEB","3","5","5","ሙስ ከ ኤተሩ ኩለመኖ ጠዊሃ ምስክር እሆተ መገን ምኔን ጉዕማን ካድንችገ እክ አመዕነሞእሃ እቅ። ");
INSERT INTO alw_vpl VALUES ("HB3_6","088_3_6","HEB","3","6","6","መሲህ መገን ምኔን ጉዕማን ሹምነቱ ኣሰሞስ ቤትገ አመዕነሞሃ እቅ፤ ነኡን አመዕንናምለከ ድከዕናም ተብሳሃ ኤተሩ ኢለ ጠረኝንስ አንፎምጎሬ እስ ምኒ እንካም። ");
INSERT INTO alw_vpl VALUES ("HB3_7","088_3_7","HEB","3","7","7","ህካን እኮቤቺሃ ጠሊሉ አያኑ «ከበር ላገስ ሞጮጭቴነን ");
INSERT INTO alw_vpl VALUES ("HB3_8","088_3_8","HEB","3","8","8","አዕኑ ኡለ ኡድማን ፌተንቴንተኤ ወክት አበናኑክዕኔ ሾክቶኤገን ቀልብክዕኔ ዱድሶኖቼ። ");
INSERT INTO alw_vpl VALUES ("HB3_9","088_3_9","HEB","3","9","9","ህከኔን አበናኑክዕኔ ፌተንቶኤሁ፥ አሙዕርሲሶኤሁ፤ አዕዮምርቹንከ ሸይሉ ዘማን ለኦኡ» የኖ መገኑ። ");
INSERT INTO alw_vpl VALUES ("HB3_10","088_3_10","HEB","3","10","10","«ህካን እኮቤቺሃ አን ህከን ዘማን መናን ኡሙዕሬም፤ ‹ጉዕመ ወክት ቀልቡሰ ሉጨሞእሃ፥ ዎቃንከኤ ደግበረሁ› ዬም።» ");
INSERT INTO alw_vpl VALUES ("HB3_11","088_3_11","HEB","3","11","11","አንን አሙዕሬን «‹እሰ ኢ ፎሎጭቤቹ ሆሮ ኣጋባአ› ይ ጤሌዕሌም።» ");
INSERT INTO alw_vpl VALUES ("HB3_12","088_3_12","HEB","3","12","12","ኢ ጃላ! ዘላለሚሃ ሄአኖ መገኑ ለገእሲሰኖ ሂሉ አመዕንቡ ቀልቡ ክዕኔኤች አዬሃ ሄአኖበእገ አገዕርዬ። ");
INSERT INTO alw_vpl VALUES ("HB3_13","088_3_13","HEB","3","13","13","እኮጎሬ ክዕኔኤች አዪሁ ጩቢን ጣንሰም ቀልብስ ዱድሱዕነ «ከበር» የመሞ በሩ ጎፉዕነ ጉዕመ ወክት ገገዉክዕኔ አማዕለሜ። ");
INSERT INTO alw_vpl VALUES ("HB3_14","088_3_14","HEB","3","14","14","ወዕና ሄዕዮኔ አመዕነቱ መጨረሸ ኢለ ጠረኝንስ አንፎምጎሬ መሲህን ሜጡበ ቤቀማምረ እንካም። ");
INSERT INTO alw_vpl VALUES ("HB3_15","088_3_15","HEB","3","15","15","ከኒች ብርተ «ከበር ላገስ ሞጮጭቴነን ህከ ወክት አበናኑክዕኔ ሾክማን አቶገን ቀልብክዕኔ ዱድሶኖቼ» የመም ከተበሞጋት። ");
INSERT INTO alw_vpl VALUES ("HB3_16","088_3_16","HEB","3","16","16","ላገስ ሞጮጭት ሾክቶእሩ አዬኤታን? ሙስ አዎንስ ግብጽ ባዲች ፉሼሰሩ ጉዕማንከሰበእንዶ? ");
INSERT INTO alw_vpl VALUES ("HB3_17","088_3_17","HEB","3","17","17","ሸይሉ ዘማን ዊመ መገኑ አሙዕርስሶሩ አዬኤታን? ጩብ አቶቤቺሃ ጀናዘሰ ኡለ ኡድማን ፈቆእረበእንዶ? ");
INSERT INTO alw_vpl VALUES ("HB3_18","088_3_18","HEB","3","18","18","ህካን እኮቤቺሃ አዘዘንቶበእ መን ቤሉ «ፎሎጭኤ ቤቹ ኣጌነንተበአ» ይ መገኑ ጠሌዕሌሰሩ አዬኤታን? ");
INSERT INTO alw_vpl VALUES ("HB3_19","088_3_19","HEB","3","19","19","ቴሁ እሰ አመዕኑ ሆጎ መሳን ፎሎጭቤቹ ኣጎተ አታሉ ሆጉሰ ደንጋም። ");
INSERT INTO alw_vpl VALUES ("HB4_1","088_4_1","HEB","4","1","1","ህካን እኮቤቺሃ ኣሰኖኔ ፎሎጭቤቹ ኣጊሃ ላገተ አጎኔሁ ጠረኘ እኮቤቺሃ ክዕኔች አዪሁ ህከ ፎሎጭቤቹ ኣገኖ ሳመ ደኡዕነ ፈቀኖበእገ ጉዕሙንኩኔ አገዕርኖ። ");
INSERT INTO alw_vpl VALUES ("HB4_2","088_4_2","HEB","4","2","2","እሳሃ እንጂል ላገት ኩለንቶገን ኔሳሃ ኩለንቶኔ፤ ጠዉ እኮጎሬ እሰ ሞጮጭቶ ላገተ አመዕነቲን ቶጉሆጎቤቺሃ ደግለሎሰበአ። ");
INSERT INTO alw_vpl VALUES ("HB4_3","088_4_3","HEB","4","3","3","ነኡ አመዕንኖም መኑ ህከ መገኑ ኣሰኖኔ ፎሎጭቤቹ አንጋም፤ እስን « ‹እሰ ፎሎጭቤቹ ሆሮ ኣጋበአ› ይ ኡሙዕሬን ጤሌዕሌም» ዬሀንገን ት ሆጉት ኣዱንያት ከለቀንቶች ኬሽ እክ ጎፎኡ። ");
INSERT INTO alw_vpl VALUES ("HB4_4","088_4_4","HEB","4","4","4","ቴሁ ጠሊለ መጻፍ ኣዜን መቶ ቤቾን ለመልቅ በርተኔሃ «መገኑ ለመልቅ በር ሆጎችስ ጉዕሚችን ፎሎጬእ» የመም ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("HB4_5","088_4_5","HEB","4","5","5","ህትን ወዕና የመሞገን ለንኪሃ «ፎሎጭኤቤቹኤ ሆሮ ኣጋበአ» የኖ። ");
INSERT INTO alw_vpl VALUES ("HB4_6","088_4_6","HEB","4","6","6","ሁኩ ዎዕነ እንጂል ላገት ዱዱብሰንታንሰ አዘዘሙ ግቦእሩ ፎሎጭኤ ቤቹ ኣጎበአ፤ ጠዉ እኮጎሬ ህከ ቤቹ ኣጋ መት-መቱ መኑ ሄኡሰ ሀንቅሃን። ");
INSERT INTO alw_vpl VALUES ("HB4_7","088_4_7","HEB","4","7","7","ሁኩን ሄጭ የመሞገን «ከበር ላገስ ሞጮጭቴነን ቀልብክዕኔ ዱድሶኖቼ» ይ መገኑ አበ ዘማኒች ኤተሮን ደዉዴን ጠወዕዮ ላገት «ከበር» ዬኖ መቱ በር ወሰኞኡ። ");
INSERT INTO alw_vpl VALUES ("HB4_8","088_4_8","HEB","4","8","8","ኢያሱ ፎሎጭሾሰ እቃን መገኑ ለንኪሃ ዎሎ በርተኔ ጠወአኖበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("HB4_9","088_4_9","HEB","4","9","9","መገን ኡመቲሃ አበ በሬ ፎሎጩ አጉደኖ ፎሎጩ ከ ኤተሩ እሀኖ። ");
INSERT INTO alw_vpl VALUES ("HB4_10","088_4_10","HEB","4","10","10","ህትን መገን ፎሎጭቤቹ ኣገኖሁ አዪሁ መገኑ ሆጎችስ ፎሎጬገን እሲሁ ሆጎችስ ፎሎጨኖ። ");
INSERT INTO alw_vpl VALUES ("HB4_11","088_4_11","HEB","4","11","11","ህካን እኮቤቺሃ ነኡ ብሬ ዘማን መኒሃ አዘዘሙ ግብ ምሳልተ አዎኒን ኡምባምበእገ ህከን ፎሎጮን ኣንጎተ ጠረኝኖ። ");
INSERT INTO alw_vpl VALUES ("HB4_12","088_4_12","HEB","4","12","12","መገን ላገት ፎሊን ሄኣኢተለከ ሆጉተ አታእታን፤ ለሞ አዲን ሙረኖ ብሲች አበ እጳሸታን፤ ነቢሳለከ አያነ መላይመተለከ ሀምቡተ አደ አኦተ ኢለ ሙረንስታእታን፤ ቀልብ ኣዜን ማጠሞ ሰውትለከ ሄዕላቸተ አደ አት ደጋእታን። ");
INSERT INTO alw_vpl VALUES ("HB4_13","088_4_13","HEB","4","13","13","ከለቀሞርቹ ጉዕሙንኩ መገን ብሬች ማጠመኖበአ፤ እስ ብሬን ጉዕሙርቹንኩ ግልጠለከ ከል እክ ለለኖሃን፤ ነኡን መስለ ኣስናሚሁ እስ ብሬኒት። ");
INSERT INTO alw_vpl VALUES ("HB4_14","088_4_14","HEB","4","14","14","መገኑ ዮ ቤቹ ሰማሃ ኦሮዕዮ ሎሩ ቂስቹ መገን ቤቱ ኢስ ዮኔቤቺሃ አመዕነቱኔ ጠረኝንስ አንፎ። ");
INSERT INTO alw_vpl VALUES ("HB4_15","088_4_15","HEB","4","15","15","መሰንትስ ኔሳሃ ዮ ሎሩ ቂስቹ ሆንጋምረ መረርሲጨኖኔሃን፤ ጉዕመ ጠዋንን ኒገ ፌተነሞኢሃን፤ እኮጎሬ ጩብ አዕዮበእሃን። ");
INSERT INTO alw_vpl VALUES ("HB4_16","088_4_16","HEB","4","16","16","መገኒች ማርቱተ ቶንጎተለከ ሀዕለንሹ ሀስሰኖኔ ወክት ኣስቱተ ኣእኖተ ማረኖ መገን ብርተ አመዕነቲን ሆንጠንኮ። ");
INSERT INTO alw_vpl VALUES ("HB5_1","088_5_1","HEB","5","1","1","ጉዕሙንኩ ሎሩ ቂሰት መን በሊች መጠረንታአ፤ ጩብ አቶ መን ወጥ መገኒሃ ክትምለከ ሰደቀ ሆንጠህሲሃ መገኒን መጠረንቶእረ። ");
INSERT INTO alw_vpl VALUES ("HB5_2","088_5_2","HEB","5","2","2","ሁኩ ቂስቹንኩ ሆጎሃ እኮቤቺሃ ገዋኑተለከ ሉሳእረ መረርስጮተ አታለኖ። ");
INSERT INTO alw_vpl VALUES ("HB5_3","088_5_3","HEB","5","3","3","እስ ገውንኩስ ሆጎሃ እኮቤቺሃ ኡመት ጩቢሃ ጠለዕል እሁዕናን ገይስ ጩቢሃለከ መን ጩቢሃ ክትመ ሆንጠህሱ ሀስሰኖስ። ");
INSERT INTO alw_vpl VALUES ("HB5_4","088_5_4","HEB","5","4","4","ሀሩንገ መገኒን ገአምባች ሎረ ቂሰ እህ ኬዕምኝ አዪሁ ደኦተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("HB5_5","088_5_5","HEB","5","5","5","ህትን መሲህ ሎረ ቂስቹ እሆተ ገዉስ ሎሪስዮበአ፤ ጠዉ እኮጎሬ ህከ ሎርመተ ደኤኢሁ «አት ኢሃ ቤቱ፤ አንን ከበር እሎንኬ» ዬ መገኒችት። ");
INSERT INTO alw_vpl VALUES ("HB5_6","088_5_6","HEB","5","6","6","ህትን መገኑ ዎሎ ቤቾን «አት መልከ-ጼዴቄገ ቂሶመ ሹምነትገ ዘላለሚሃ ቂሰሃን» የኖ። ");
INSERT INTO alw_vpl VALUES ("HB5_7","088_5_7","HEB","5","7","7","ኢስን መንቹ እክ ዱንያ አሌን ሄዕዮ ዘማኔን ሬሆች ፌሶስተ አታለኖ መገን ቤቹ አበ ያረናንለከ እንጂጃን አበ ዱአ አዕዮ፤ ኢስን መገኑ ዋጀኖሃ እኮቤቺሃ ዱኡስ ሞጮጨሞ። ");
INSERT INTO alw_vpl VALUES ("HB5_8","088_5_8","HEB","5","8","8","እስን መገን ቤቱ እክ ኦርሸ ኣዝን ህጎጎሬሁ ህከ ቶጎ ኦርሻች አዘዘሙ ተማሮ። ");
INSERT INTO alw_vpl VALUES ("HB5_9","088_5_9","HEB","5","9","9","እስን ኩሌኖስርቹ ዮበኢሃ እክ አዘዘንታስሀኑኡተ ጉዕሚንከ ዘላለም ጡሚሃ መሰተ እኮሰ። ");
INSERT INTO alw_vpl VALUES ("HB5_10","088_5_10","HEB","5","10","10","መገኑ ኢሰ መልከ-ጼዴቄ ቂሶማ ሹምነትገ ሎረ ቂስቹ አዕዮስ። ");
INSERT INTO alw_vpl VALUES ("HB5_11","088_5_11","HEB","5","11","11","ከን ጠውተኔሃ ልግቡ ጠወዕናም ጠዉ ዮኔ፤ ጠዉ እኮጎሬ ቴሱ ገበንቺን ተማሩ ሆጌንተቤቺሃ ሂሬን ክዕኔሃ ኩሉ ኦርሸተ። ");
INSERT INTO alw_vpl VALUES ("HB5_12","088_5_12","HEB","5","12","12","ከ ወክት ኢለ አስተማረተ እኬንታ እቅ፤ እኮጎሬ መቱ መንቹ መገን ላገ ዎኔ ትምርቲሃ ክዕኔሃ ለንኪሃ ተማርሱ ሀስሰኖ፤ ህትን እሰገን ጠረኘ እቸተ እሁዕነ አዙት ሀስሳህዕኔ። ");
INSERT INTO alw_vpl VALUES ("HB5_13","088_5_13","HEB","5","13","13","መሰንትስ አዙተ አዎንሱ ጉዕሙንኩ ኦሶተ እኮቤቺሃ ጡመርቹ ሂለርቺች አደ አዕይ ደገኖበአ። ");
INSERT INTO alw_vpl VALUES ("HB5_14","088_5_14","HEB","5","14","14","ጠረኘት እቸት ሀሲሳኢሁ ጡመለከ ሂለ አደ አዕይ ደገኖ ሎርሎረ መኒሃት። ");
INSERT INTO alw_vpl VALUES ("HB6_1","088_6_1","HEB","6","1","1","መሲህተኔሃ ዎዕና ኩለሞ ትምርተ አጉርን ጠረኘ ትምህርትበ ህንጎ፤ ሂለ ሆጉተ አጉርን ቶበንት መገኖን አመዕን ቀበበ ለንኪሃ እጃርኑንከ። ");
INSERT INTO alw_vpl VALUES ("HB6_2","088_6_2","HEB","6","2","2","ህትን ጠመቀምተኔሃ፥ መን አሌን አንገተ አኤን ዱአ አእተኔሃ፥ ሬዮ መን ኬእተኔሃለከ ጉዕመ ዘማንከ እሀኖ ፍርድተኔሃ ኩለሞ ትምህተ ለንኪሃ እጃርኑንከ። ");
INSERT INTO alw_vpl VALUES ("HB6_3","088_6_3","HEB","6","3","3","ህካን አጉርን መገኑ ዬጎሬ ብርተ ዋልን መርኖ። ");
INSERT INTO alw_vpl VALUES ("HB6_4","088_6_4","HEB","6","4","4","አመዕነቱሰ ካዶ መኑ ቶበት ሀት እክ ፈንቀልቶተ አታልታአ? ኩ መኑ ከኒች ብርተ ኑሩ ለልዮሰ እቅ፤ ሰሜ ሽልማት ቀመሶ እቅ፤ ጠሊለ አያኒን ሜጡበ ቤቀማኑተ እኮ እቅ። ");
INSERT INTO alw_vpl VALUES ("HB6_5","088_6_5","HEB","6","5","5","መገን ጡመ ላገተለከ አሜተኖ ኣዱንያ አል ዎልቀተ ቀመሶ እቅ፤ ");
INSERT INTO alw_vpl VALUES ("HB6_6","088_6_6","HEB","6","6","6","ፈንቀልት ካዶ ጎሬ ጩብ አጉርታቤቹ እሰተ ፈንቀሹ አታልሲስበሃን፤ መሰንትስ እሰ ገውንኩሰ ገይሰ ቤሲሃ መገን ቤቱ ለንኪሃ ሰቀልቶእረለከ ሆፍሶእረ። ");
INSERT INTO alw_vpl VALUES ("HB6_7","088_6_7","HEB","6","7","7","ልግብ ወክት መቱ መንቹ ኡለስ አሌን ኡቦ ጤነ አጋን አቡረኖሴ መንቺሃ ውጠተ ኣታ ኡለት መገኒች ማሰተ ደእታ ኡለተ አጉዳአ። ");
INSERT INTO alw_vpl VALUES ("HB6_8","088_6_8","HEB","6","8","8","እኮጎሬ ህት ኡለት ኡተለከ ሽርፍቱተ ነስቶጎሬ ሀሴንባተ እካአ፤ ደዕልት ቦሮሪሃ እካአ፤ መጨረሹስ ግራን ቡባአ። ");
INSERT INTO alw_vpl VALUES ("HB6_9","088_6_9","HEB","6","9","9","ኢተንቴንተ አመኤ ኦሶ! መሃ ክዕኔተኔሃ ህትን ጠወዕኖምጎሬ ጡሚሃ ሀዕለኖሁ ቆሀኖ ጠው ዮህዕኔገ ደንጋም። ");
INSERT INTO alw_vpl VALUES ("HB6_10","088_6_10","HEB","6","10","10","መገን ሱዕምተኔሃ ይቴን ጠሊላኑተ ሀዕሎተ ዎዕነሃ እኮ ቴሁ አቴንተ ሆጉተለከ ለሊሴንተ ኢተተ ሀቦተ መገኑ ሾካበአ። ");
INSERT INTO alw_vpl VALUES ("HB6_11","088_6_11","HEB","6","11","11","አዕኑ ጉዕሙንኩክዕኔ ተብሴን አገዕርቴነንተረ አፎኖተ ኢለ ጠረኝመክዕኔ መጨረሸ ኢለ ለሊሶኖተ ሄዕላንታም። ");
INSERT INTO alw_vpl VALUES ("HB6_12","088_6_12","HEB","6","12","12","ነኡ ሄዕላንታሚንኩ አመዕነቲንለከ አታዕሊን ተብሳሃ ኣሰሞሰ ጠወ ረገኣ መነ አጉዶኖታት ቤሉ ዋንክዕላሙ መነ እኮኖታበአ። ");
INSERT INTO alw_vpl VALUES ("HB6_13","088_6_13","HEB","6","13","13","መገኑ እብራሂሚሃ ተብሳሃ ኣሴ ወክት ገዪችስ ሎሩ ጤሌዕለኖርቹ ዮስበእቤቺሃ እስ ገዎንከስ ጤሌዕለን ");
INSERT INTO alw_vpl VALUES ("HB6_14","088_6_14","HEB","6","14","14","«ሀንቅንከ አን ማሰኣንኬ፤ ዘርክን በትሳንኬ» ዬስ። ");
INSERT INTO alw_vpl VALUES ("HB6_15","088_6_15","HEB","6","15","15","እብራሂምን አታዕል አበ ዘማን አገሮቤቺሃ ተብሳሃ ኣሰሞስርቹ ደኤእ። ");
INSERT INTO alw_vpl VALUES ("HB6_16","088_6_16","HEB","6","16","16","መኑ ጤሌዕለን ገይችስ በተአኖርቾን ጤሌዕለኖ፤ ሀሳወሰ ቦሮርን ኡርስ በለሰ ዮ ኦደተ ጉዕመንከ በሊችሰ ከንታአ። ");
INSERT INTO alw_vpl VALUES ("HB6_17","088_6_17","HEB","6","17","17","ህትን መገኑ እስ አላመት እኩዕነ ፈቅባሃ እሁስ ለሊሶተ ሀሾቤቺሃ ተብሳስ ቶጋ መኒሃ ቦሮርን ጠረኝሾ። ");
INSERT INTO alw_vpl VALUES ("HB6_18","088_6_18","HEB","6","18","18","እስ ዶረንትበለከ ክዝቤንበ ለሙ ጠወ ኣስዮኔ፤ እሰን ተብሳለከ ጤሌዕሉሃን፤ ከን ለሞ ጠዊ መሳን ብሬንከኔ ዮ ተብሳሃ ጠረኝንስ አፉ አታልኖተ ሆቀንሸ ደእኖተ እስቤቹ ሁኖምሩ ነኡ አበ ጠረኝመተ ደእናም። ");
INSERT INTO alw_vpl VALUES ("HB6_19","088_6_19","HEB","6","19","19","ኩ ተብሶሁ ዌደሩ ኒ አሌን ኡሱሬን ዎሎ ዌደር ሰኑት መጋረጀ ህግ መገኑ ደገመኖ ኣዝ ጠሊለ ቤቹ ኣገኖ። ");
INSERT INTO alw_vpl VALUES ("HB6_20","088_6_20","HEB","6","20","20","ሁኩ መልከ-ጼዴቄ ቂስ ሹምነትገ ዘላለሚሃ ሎረ ቂስቹ እኮ ኢስ ኒተኔሃ ዎዕኔሃ እክ ኣጎእሃን። ");
INSERT INTO alw_vpl VALUES ("HB7_1","088_7_1","HEB","7","1","1","ኩ «ሳሌመ» ዬኖ ባድ ዳኘለከ ጉዕሚችን ሎረ ቂስቹ እኮ መልከ-ጼዴቅ እብራሂም ዎመተ ቄል ፈንቀሎ ወክት እሲን ዎቃን ደቀም ማሰዕዮስ። ");
INSERT INTO alw_vpl VALUES ("HB7_2","088_7_2","HEB","7","2","2","እብራሂምን እሲሃ አግ አፎርቺች ጉዕሚቺን ቶኒች መቱስ ኣሴስ፤ መልከ ጼዴቄ ሱዕምስ ፍሳረት ወዕናሃ «ፈየ ዎመ» ዩሃን፤ ህትን ዎሉስ «ሳሌም ዎመ» ህከረንገ «ወገሬት ዎመ» ዩሃን። ");
INSERT INTO alw_vpl VALUES ("HB7_3","088_7_3","HEB","7","3","3","መልከ-ጼዴቂሃ አኑለከ አመት ዮስበአ፤ እለንሽ ዘርት ዮስበአ፤ ዘማንሀስ ብርት ሄእሀስ ኤተሩ ዮስበአ፤ ጠዉ እኮጎሬ መገን ቤት ምሳልተ እክ ዘላለሚሃ ቂስቹ እክ ሄአኖ። ");
INSERT INTO alw_vpl VALUES ("HB7_4","088_7_4","HEB","7","4","4","ወዕኔ አኑ እብራሂም አግ ኤቦሀኒች ቶኒች መቱስ ኣሴስ ኩ መንቹ ሄንከ ሎረ ጎር ለዕዬ! ");
INSERT INTO alw_vpl VALUES ("HB7_5","088_7_5","HEB","7","5","5","ሌዌ ዘሬች ቂሰ እኮእሩ ኡመቲችስ እብራሂም ዘርተ እኮ አመሰ ኦሶች ቶኒች መቱ ኣእታገ ትዛዙ ሕጊን አዘዘሞሰ። ");
INSERT INTO alw_vpl VALUES ("HB7_6","088_7_6","HEB","7","6","6","ሁኩ መልከ-ጼዴቅ ሌዋውያን ዘርተ እህበጎሬ እብራሂሚች ቶኒች መቱ ኣኤእ፤ ተብሴ ላገተ ኣሰሞስ እብራሂመ ማሰዕዮስ። ");
INSERT INTO alw_vpl VALUES ("HB7_7","088_7_7","HEB","7","7","7","ህካን እኮቤቺሃ ማዕኑ ሀንገፊች ማሰተ ኣአኖገ ሸክት ዮስበአ። ");
INSERT INTO alw_vpl VALUES ("HB7_8","088_7_8","HEB","7","8","8","መቶ አዲን ቶኒች መቱ ቶጋዕሩ ሬታእሃ መነ፤ ህትን ዎሎ አዲን ቶኒች መቱ ቶገኖሁ ህትን ሄአኖሃ እክ መሰከረሞሲሁ ጠሊለ መጻፋን ከተበሞገን መልከ ጼዴቄት። ");
INSERT INTO alw_vpl VALUES ("HB7_9","088_7_9","HEB","7","9","9","ቴሁ ቶኒች መቱ ጭምአአኖ ሌዊ ገውንኩስ እብራሂም አዲን ቶኒች መቱስ ባቾ ዩሃን። ");
INSERT INTO alw_vpl VALUES ("HB7_10","088_7_10","HEB","7","10","10","መሰንትስ መልኬ-ጼዴቄ እብራሂምን ዎቄ አሌን ደቀሞ ወክት ሌዊ እብራሂሚች ከለቀሞበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("HB7_11","088_7_11","HEB","7","11","11","ቴሁ ሕጉ እስረኤል ኡመቲሃ ኣሰሞሁ ሌዌ ቂሶመ አዲኒት፤ ህትን ቂሶማን ጉዕሙርቹንኩ ዊመ እክ ደገሞ እቃን ሀሩንገ እሁዕነ መልከ-ጼዴቄገ ዮእ ዎሉ ቂስቹ ሚ ሀስሰኖ እቅ? ");
INSERT INTO alw_vpl VALUES ("HB7_12","088_7_12","HEB","7","12","12","መሰንትስ ቂሶመት ዶረንቶች ህትን ቂሶመ ሕጉ ዶረሙ ሀስሰኖስ። ");
INSERT INTO alw_vpl VALUES ("HB7_13","088_7_13","HEB","7","13","13","ኩ ጠው እስተኔ ኩለሞ ቂስቹ ዎሎ ደቦቺት፤ ህከን ደቦችን አዪሁ መገኒሃ ክትም ሆንጠህሴኖ ጠረጴዝበ ሆንጠክ ካደሞሁ ዮበአ። ");
INSERT INTO alw_vpl VALUES ("HB7_14","088_7_14","HEB","7","14","14","መሰንትስ ቀርቹ እለሞሁ አይሁድ ደቦች እሁስ ለልዮእሃ ጠወ፤ ሙስን አይሁድ ዘሬ ቂሰተኔሃ መቱርቹሃ ኩሎበአ። ");
INSERT INTO alw_vpl VALUES ("HB7_15","088_7_15","HEB","7","15","15","መልኬ-ጼዴቄገ ዮ ዎሉ ቂስቹ አሜቾ ወክት ኩ ጠው ኑር እክ ለለኖ። ");
INSERT INTO alw_vpl VALUES ("HB7_16","088_7_16","HEB","7","16","16","እስ ቂሶመ ሹምነቱ መን ዘሬችስ አሜቾ ሴሪን አሜቶእተ እኩዕናን ህግበ ሄእ ወልቃን አሜቶእታን። ");
INSERT INTO alw_vpl VALUES ("HB7_17","088_7_17","HEB","7","17","17","መሰንትስ «አት መልከ-ጼዴቅ ቂሶመገ ጉዕመ ዘማኒንከ ቂስቹሃን» የመም ጠሊለ መጻፋን መሰከረሞስ። ");
INSERT INTO alw_vpl VALUES ("HB7_18","088_7_18","HEB","7","18","18","ህካን እኮቤቺሃ ወዕኔ ዘማን ሕጉ ላፈለከ ደግለልባሃ እኮቤቺሃ ድጀሞኡ። ");
INSERT INTO alw_vpl VALUES ("HB7_19","088_7_19","HEB","7","19","19","እኮጎሬ ነኡ መገን ቤቹ ሆንጠንካም ቆሀኖ ተብሶሁ አሜቾኡ፤ መሰንትስ ሙስ ሕግ አዲን ሀኩ መንቹሁ መገን ብሬን ነጠ እሆተ አታሎበአ። ");
INSERT INTO alw_vpl VALUES ("HB7_20","088_7_20","HEB","7","20","20","ኩ ቂሶመት አሜቶኢሁ መገን ወኣድ ቤሉ እኮበአ፤ እኮጎሬ ዎሉሰ ቂሰ እኮኢሁ ወኣድ ቤሉሃት። ");
INSERT INTO alw_vpl VALUES ("HB7_21","088_7_21","HEB","7","21","21","እኮጎሬ እስ ቂሶመት ወኣዲን እኮእታን፤ መሰንትስ «መገኑ ‹አት ዘላለሚሃ ቂስቹሃን› ይ ወኣድ ኣጎቤቺሃ ሰጨኖበአ» የመም እስተኔ ጠወአሞኡ። ");
INSERT INTO alw_vpl VALUES ("HB7_22","088_7_22","HEB","7","22","22","ህከን ወኣድ መሳን ኬዕዮሀኒን ኢስ ቆሀኖ ወኣዲሃ ሩበታስንቹ እኮኡ። ");
INSERT INTO alw_vpl VALUES ("HB7_23","088_7_23","HEB","7","23","23","ዎኔ ዘማን ቂሰት ሆጉሰ አጉርቱዕናን አታበእገ ሬሁት ከንቶቤቺሃ እሰ ወሊንሹ ልግብያ እቅ። ");
INSERT INTO alw_vpl VALUES ("HB7_24","088_7_24","HEB","7","24","24","እኮጎሬ ኢስ ዘላለሚሃ ሄአኖሃ እኮቤቺሃ ዶረንትበ ቂሶመት ዮስ። ");
INSERT INTO alw_vpl VALUES ("HB7_25","088_7_25","HEB","7","25","25","ኢስ እሰተኔሃ መገኑ ኡጮሰተ ጉዕመ ወክትንከ ሄአኖሃ እኮቤቺሃ እስ አዲን መገንበ ሆንጠካረ ዘላለሚሃ ጡምሶሰተ አታለኖ። ");
INSERT INTO alw_vpl VALUES ("HB7_26","088_7_26","HEB","7","26","26","ኔሳሃ ህትናሙ ጠሊሉ፥ ኩሌኖስርቹ ዮስበኢሁ፥ ነጠ፥ ጩበኛኖች አደ እኮሃ፥ ሰሜች አሌ ዋል ጎት ዬኢሁ ሎሩ ቂሰ ሀለቁ ሀስሰኖኔ። ");
INSERT INTO alw_vpl VALUES ("HB7_27","088_7_27","HEB","7","27","27","እስን ዎሎ ሎረ ቂስገ ሄጭ ገይስ ጩብተኔሃ ኤተሮን ኡመት ጩብተኔሃ በሬን በሬን ክትም ሆንጠህሱ ሀስሰኖስበአ፤ ገውስ ክትም አዕይ ሆንጠህሾ ወክት ለንኪሃ በርጌኖበእገ ሜጥቾረን ሹል ቅጥ አዕዮኡ። ");
INSERT INTO alw_vpl VALUES ("HB7_28","088_7_28","HEB","7","28","28","ሙስ ሕጉ ላፈ መነ ሎረ ቂሰ አዎንሳኑተ አዕይ ሾመኖሰ፤ እኮጎሬ ሕጊች ኤተሮን አሜቾሁ ወኣድ ላጋን እኮጎሬ ዘላለሚሃ ኩሌኖስርቹ ዮበኢሃ መገን ቤቱ ሹመ አዕዮስ። ");
INSERT INTO alw_vpl VALUES ("HB8_1","088_8_1","HEB","8","1","1","ቴሁ ጠወዕኖም ጠዊች ቡዕሉስ ከኒት፤ ሁኩንን ጉዕሚች ሎረ እኮ መገን ዎመ ቦርጭመ መኬ አዲን ሰማን አፉዕሌ ህትናሙ ሎሩ ቂሰ ሀለቁ ዮኔ። ");
INSERT INTO alw_vpl VALUES ("HB8_2","088_8_2","HEB","8","2","2","እስ ሀንቅ ዱካነ እኮ ዱእ ምኒ ኣዜን ቂሰ ሀለቀ እክ ካደመኖሃን፤ ዱካኑስ መን አንጋን እሁዕነ ቀርች አንጋን ካሰሞእሃን። ");
INSERT INTO alw_vpl VALUES ("HB8_3","088_8_3","HEB","8","3","3","ሎሩ ቂሰ ሀለቀት ጉዕሙንኩ ሾመንታኢሁ መገኒሃ ሰደቀለከ ክትመ ሆንጠህሲሃት፤ ህካን እኮቤቺሃ ከን ቂስቺሃ ክትሚ ሆንጠህሴኖ መቱርቹ ሄኡ ሀስሰኖስ። ");
INSERT INTO alw_vpl VALUES ("HB8_4","088_8_4","HEB","8","4","4","እስ ኣዱንያ አሌን ሄዕዮእቃን ቂስቹ እሀኖበአ እቅ፤ ሁኩንን ሕግጊን መገኒሃ አኤኖርቹ ሆንጠህሳ ዎሉ ቂሰት ሄኦቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("HB8_5","088_8_5","HEB","8","5","5","እሰ አቶኢሁ ሰማን ዮኢሃ ምሳልተለከ ሀላሃ እኮሀን ኣዜኒት እቅ፤ ሁኩን እኮሁ ሙስ ዱካነ መክሶተ ቅጥዬ ወክት መገኑ «ቆተ አሌን ለሌሄ ሃሊን ጉዕመርቹንከ አገርት አእ» ይ አዘዦስጋት። ");
INSERT INTO alw_vpl VALUES ("HB8_6","088_8_6","HEB","8","6","6","ቴሱ እኮጎሬ ኢስ በል መንቹ እኮ ወኣድ ላገተ ኑባቾ ወኣድ ላጋች ሎረ እኮቤቺሃለከ ቆሀኖ ወኣድ ላጋን ጀመረሞሃ እኮቤቺሃ እሲሃ ኣሰንቶ ሆጉት ሎረታን። ");
INSERT INTO alw_vpl VALUES ("HB8_7","088_8_7","HEB","8","7","7","ዎዕኔ ወኣዴን ሉጨንሹ ዮበእቃን ለንክ ወኣድ ላገት ሀሲሳሰበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("HB8_8","088_8_8","HEB","8","8","8","መሰንትስ ቀርቹ መገኑ እሳን ሉጨንሸ ደግ «ቴሱ አን እስራኤልለከ አይሁድ ባድ መኒን ሃዕሮ ወኣድ ላገተ ኣጋም ወክቱ አሜተኖ» የኖ ቀርቹ። ");
INSERT INTO alw_vpl VALUES ("HB8_9","088_8_9","HEB","8","9","9","ኩ ወኣድ ላገተ አን ግብጽ ባዲች ፉሾሰተ አንገሰ አፎም በር አበናኖንከሰ ኣጎም ወኣድ ላጋ ደነበአ፤ መሰንትስ እሰ ኢ ወኣድ ላገተ ጠረኝት ሄኡ ሆጎቤቺሃ አጉሮንሰ። ");
INSERT INTO alw_vpl VALUES ("HB8_10","088_8_10","HEB","8","10","10","«ህከን ዘማኒች ኤተሮን እስረኤል መኒሃ ኣጋም ወኣድ ላገት ተኔት ይ ጠወዕዮ ቀርቹ፤ ኢ ሕገንከ ቀልቤንከሰ አኣም፤ ወዘናንከሰን ከተባም፤ አነሰ መገኑ እሃም፤ እሰን ኢ ኡመት እካአ። ");
INSERT INTO alw_vpl VALUES ("HB8_11","088_8_11","HEB","8","11","11","እሳችን አዪሁ ዎሉ መነሃ አመስቤቱ ‹መገኑ ደግ› ይ ተማርሰኖስበአ፤ መሰንትስ ቀዊች ኬሽ ሎረ ኢለ ጉዕሙንኩ ኤሳሃ ደጋኤ። ");
INSERT INTO alw_vpl VALUES ("HB8_12","088_8_12","HEB","8","12","12","አን እሰ ሂልመተ አጉረንሰ፤ ጩብሰን ለንኪሃ ሰውያምበአ» የኖ ቀርቹ። ");
INSERT INTO alw_vpl VALUES ("HB8_13","088_8_13","HEB","8","13","13","ቴሱ «ሃዕሮ ወአድ ላገተ» የኖ ወክት ወዕኔ ወኣድ ላገተ ኑባቹ አዕዮኡ ዩሃን፤ ህካን እኮቤቺሃ ኑባጴኢሁ በአኖ ወክቱ ኢልዮኡ ዩሃን። ");
INSERT INTO alw_vpl VALUES ("HB9_1","088_9_1","HEB","9","1","1","ዎዕኔ ወኣድ ላገ ሰገዴኖ ሴሩለከ መን አንጋን እጃረሞ መገኒሃ ሰገዴኖ ምኑ ዮስሃ እቅ። ");
INSERT INTO alw_vpl VALUES ("HB9_2","088_9_2","HEB","9","2","2","ለሙ ክፍሉ ዮስ ዱካኑ ቅጥይዮ እቅ፤ ወዕኔ አብል ክፍሉ ኩራዘ አፉሼኖሁለከ ጠረጴዙ፥ ክትም ዳቡቲ ሄኦ ዎዕኔ ክፍሉ «ጠሊለተ» የመንታ እቅ። ");
INSERT INTO alw_vpl VALUES ("HB9_3","088_9_3","HEB","9","3","3","ለንክ መጋረጂች ኤተር አዲን ደገመኖሁ ኣዝ ክፍሉ «ጠሊልች ጠሊለ» ዬኖቤቹ ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("HB9_4","088_9_4","HEB","9","4","4","ህከን ክፍል ኣዜን ዎርቂን መክሴመ ህጣነ አጪሴኖ ጠረጴዙለከ ጉዕመንከስ ቤቹ ዎርቀ ቡሬን መክሴመ ወኣድ ላገ ሳጥኑ ሄዕዮ እቅ፤ ህከን ሳጥን ኣዜን «መና» ዬኖ እቸት ሄኦ ዎርቅ መሶቡ፥ ለቶ ሀሩን በርትቹትለከ ቶኑ ትዛዙ ከተበሞ ክኑ ሄዕዮ እቅ። ");
INSERT INTO alw_vpl VALUES ("HB9_5","088_9_5","HEB","9","5","5","ታቦት አሌን ዮ ጩቡ አጉረመኖ ቤቹ ቴለኖ መዴንከሰ ጌረዳ ጎንት ዮሰ መገን ኬዕምኝ ለሊሳ ክልቀቱ ሄኦ እቅ፤ ጠዉ እኮጎሬ ከን ጠውተኔሃ ጉዕሚንከ ቴሱ መቱርቹሃ ጠወዕኖተ አታልናምበአ። ");
INSERT INTO alw_vpl VALUES ("HB9_6","088_9_6","HEB","9","6","6","ጉዕሙርቹንኩ ህት ቅጥ ዬች ኤተሮን ቂሰት ሆጉሰ አቶተ ዱካን ዎኔ ክፍል ኣዝ ጉዕመ ወክት ኣጋ እቅ። ");
INSERT INTO alw_vpl VALUES ("HB9_7","088_9_7","HEB","9","7","7","ጠዉ እኮጎሬ ዎዕኔ ኣዝ ክፍል ጠለዕል ሎሩ ቂስቹ ዘማኔን መቱ ወክት ኣገኖ፤ እስን ገይስለከ መኑ ደጉዕነ አቶ ጩብሃ ቄጉ አፉዕነ ህከ ቤቹ ኣገኖበአ። ");
INSERT INTO alw_vpl VALUES ("HB9_8","088_9_8","HEB","9","8","8","ዎዕኔ ዱካኑ ሄከን ቤቾን ኡር ሄአንን ጠሊልች ጠሊለ ቤቹ መሰኖ ዎቆሁ ፈንተኡ ሆጉስ ጠሊሉ አያኑ ኩለኖ። ");
INSERT INTO alw_vpl VALUES ("HB9_9","088_9_9","HEB","9","9","9","ኩ ጠው ከን ዘማኒሃ ምሳልተ እሀኖ፤ ኩንን ለሊሰኖሁ ሰደቀተለከ ክትመ ሆንጠህሰኖስ መንች ቀልብ መገን ብሬን ነጠ አኦስተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("HB9_10","088_9_10","HEB","9","10","10","ጉዕሙንኩ ጠዉ መገኑ ጉዕመርቹንከ ሃዕሮ አኦተ ኢለ ጠለዕል ሆጎ አሌን ዱንክታ እትለከ አግ ህትን ዊን ኣዕሌን ነጠ እሄኖ ሴሪን እኮእራን። ");
INSERT INTO alw_vpl VALUES ("HB9_11","088_9_11","HEB","9","11","11","ጠው እኮጎሬ መሲህ ቴሱ እሀኖ ጡመ ጠዊሃ ሎረ ቂስቹ እክ አሜቾኡ፤ እስ ኣጎ መገን ዱካኑ ሎረለከ ዊመ ዊሚን እክ መክዮእሃን፤ ሁኩ ዱካኑ መን አንጋን መክዮበኢሃለከ ከን ኣዱንያ አሌን ዮበእሃ። ");
INSERT INTO alw_vpl VALUES ("HB9_12","088_9_12","HEB","9","12","12","ጠሊልች ጠሊለ ቤቹ ሜጦረን ገይስ ቄጊን ኣጎ ቤሉ ፌላእለከ ዎርጀመ ቄጉ አፍ ኣጎበአ፤ ህትን ዘማን ጉዕመንከ ሄኣ ዎዝኑተ ኣሴኔ። ");
INSERT INTO alw_vpl VALUES ("HB9_13","088_9_13","HEB","9","13","13","ፌዕላእለከ ዎርጃመ ቄጉ፥ ህትን ክትሚሃ ቡሴመ ሱሉም ጠበሩ ንጃሶ መን አሌን ብን አኤኖረ ማል ንጃሲች ነጠ አዕይ ጠሊለ አሰኖሳሃ እኮች፥ ");
INSERT INTO alw_vpl VALUES ("HB9_14","088_9_14","HEB","9","14","14","ጉዕመ ዘማኒሃ ሄአኖ ጠሊለ አያን አዲን ገውስ ህንቄኖርቹ ዮበእ ክትም አዕይ መገኒሃ ሆንጠህሾ መሲህ ቄጉ ሄአኖ መገኒሃ ካደሞተ ቀልብኔ ሄንከ ሬሁተ ኤበኖ ሂለ ሆጎች ነጠ አአኖ? ");
INSERT INTO alw_vpl VALUES ("HB9_15","088_9_15","HEB","9","15","15","መገኑ ገኤሰሩ እስ ተብሴን ኣሴሰ ዘላለሚሃ ጎፍበ ኡለተ ረገኦተ መሲህ ሃዕሮ ወኣድ ላገ በል መንቹ እኮ፤ ሁኩንን መኑ ዎዕኔ ወኣድ ላጋ ኣዜን ጠገም ሄዕዮ ወክት አዕዮ ጩቢች ገይስ ሬሆን ጡምሶታት። ");
INSERT INTO alw_vpl VALUES ("HB9_16","088_9_16","HEB","9","16","16","ሬሀኖ መንቹ ወስያተ ኩዕሌርቹ ሄዕዮ ጎሬ መንችስ ሬሁተ አጥራመቴን ደጉ ሀስሰኖ። ");
INSERT INTO alw_vpl VALUES ("HB9_17","088_9_17","HEB","9","17","17","መሰንትስ ሬሀኖ መንቹ ኩዕሌርቹ ዊመኖሁ ሬዮች ኤተሮንት፤ ጠው እኮጎሬ ኩዕሌስ መንቹ ሬህባች ጠውስ ዊሞተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("HB9_18","088_9_18","HEB","9","18","18","ህካን እኮቤቺሃ ዎዕኔስ ወኣድ ላጋ ቄጉ ዱንተኡዕነ ህትን ጠረኝዮበአ እቅ። ");
INSERT INTO alw_vpl VALUES ("HB9_19","088_9_19","HEB","9","19","19","ሙስን ሕግ ትዛዝ ኡመቲሃ ኩሎች ኤተሮን ዎርጃምለከ ፌዕላእ ቄጉ ዊን ልቀለቅ ቢሸ ሆለ ኦርዛንለከ «ህሶጰ» ዬኖ ሀሚን ሕግ መጻፋንለከ ኡመት አሌን ኪፎ። ");
INSERT INTO alw_vpl VALUES ("HB9_20","088_9_20","HEB","9","20","20","ህካን ኪፎንኩ «ኩን መገኑ አገርቶኖተ አዘዦህዕኔ ወኣድ ላጋ ቄጉ ከኒት» ዬእ። ");
INSERT INTO alw_vpl VALUES ("HB9_21","088_9_21","HEB","9","21","21","ህትን ሙስ ዱካናንለከ ኣዜንከስ ሄኦ ጉዕማንከ ደግለሸቀሜኖ ኦዳ አሌን ቄጉ ኪፎ። ");
INSERT INTO alw_vpl VALUES ("HB9_22","088_9_22","HEB","9","22","22","ሀንቅንከ ሙስ ሕግ ሃሊን ቀዎርች ቤሉ ጉዕሙርቹንኩ ቄጊን ነጠ እሀኖ፤ ቄጉ ዱንተኡዕነ ጩቡ አጉረመኖበአ። ");
INSERT INTO alw_vpl VALUES ("HB9_23","088_9_23","HEB","9","23","23","ቴሁ ኩ ሰማን ዮ ምሳልተ እኮ ኦዳት ጉዕሙንኩ ከን ክትሚን ነጠ እካአ፤ እኮጎሬ ሰማን ዮ ምሳልት ከኒች በተአኖ ክትሚን ነጠ እሁ ሀስሰኖሰ። ");
INSERT INTO alw_vpl VALUES ("HB9_24","088_9_24","HEB","9","24","24","መሲህ ሀንቅ ምሳልተ እኮ መን አንጋን እጃረሞ ጠሊልች ጠሊለ ቤቹ ኣጎበአ፤ ጠው እኮጎሬ ኒተኔሃ ይ መገን ብሬን ለሎተ እስ ሰማሃ ኣጎ። ");
INSERT INTO alw_vpl VALUES ("HB9_25","088_9_25","HEB","9","25","25","አይሁድ ሎረ ቂሰ ሀለቁንኩ ዘማን ዘማኔን ገይሲሃ እህበ ቄጉ አፍ ጠሊልች ጠሊለ ቤቹ ኣገኖገን መሲህ ገዉስ ልግብ ወክት ክትሚ አዕይ ሆንጠህሶተ ኣጎበአ። ");
INSERT INTO alw_vpl VALUES ("HB9_26","088_9_26","HEB","9","26","26","ህት እኮች ኣዱንያት ከለቀንቶች ኬሽ ልግብ ወክት ኦርሸተ ቶጉ ሀስሰኖስ እቅ፤ ቴሱ እኮጎሬ ዘማን መጨረሻን እስ ገዉስ ክትም አዕይ ሆንጠህሽ ጩብ ቤሶተ በረገምበ ሃሊን ለልዮኡ። ");
INSERT INTO alw_vpl VALUES ("HB9_27","088_9_27","HEB","9","27","27","መኒሃ መቶረ ሬሁ ሀስሰኖስ፤ ህትን ሬሆች ኤተሮን ፍርዱ ዮኡ። ");
INSERT INTO alw_vpl VALUES ("HB9_28","088_9_28","HEB","9","28","28","ህትን መሲህ ልግብ መን ጩብ ቤሶተ መቶረ ክትመሞኡ፤ ህትን ጩብ እጂሃ እሁዕነ እሱ አገርታእረ ጡምሶተ ለምቅ ወክት ለለኖ። ");
INSERT INTO alw_vpl VALUES ("HB10_1","088_10_1","HEB","10","1","1","ቴሱ ሕጉ ከ ኤተሩ አሜተኖሁ ጡመ ጠዊሃ ሀላሃ ቤሉ ሀንቅ ደናስበአ እቅ፤ ህካን እኮቤቺሃ ጉዕመ ወክትንከ ዘማን ዘማኔን ክትመንታ ክትመተ አፍ መገን ቤቹ ሆንጠካ መነ ሆሮን ነጣኑተ አኦተ ሆሮ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("HB10_2","088_10_2","HEB","10","2","2","አታሎሃ እኮ እቃን ሁኩ ክትም ሆንጠህሳ መኑ መቶረ ጩብችሰ ነጠ እኮች ኤተሮን ነጠ እኮገ ቀልቡሰ ደገኖቤቺሃ ክትምስ ሆንጠህሱ አጉርታ እቅ። ");
INSERT INTO alw_vpl VALUES ("HB10_3","088_10_3","HEB","10","3","3","ጠዉ እኮጎሬ ሁኩ ክትመት ዘማን ዘማኔን ጩብ ቃግሳእራን። ");
INSERT INTO alw_vpl VALUES ("HB10_4","088_10_4","HEB","10","4","4","መሰንትስ ዎርጃመለከ ፌዕላእ ቄጉ ጩብ ቤሶተ አታለኖበአ። ");
INSERT INTO alw_vpl VALUES ("HB10_5","088_10_5","HEB","10","5","5","ህካን እኮቤቺሃ መሲህ ከ ኣዱንያ አል አሜቾ ወክት «ክትመለከ መገን ምኒሃ ሆንጠህሴኖርቹ ሀሶንትበአ፤ ጠዉ እኮጎሬ ጅስመ ቅጥ አቶንቴኤ፤ ");
INSERT INTO alw_vpl VALUES ("HB10_6","088_10_6","HEB","10","6","6","ህትን ጉዕመንከስ ቡሴኖ ክትምለከ ጩብ ነጠ አአኖ ክትሜን ሙንደኦንትበአ። ");
INSERT INTO alw_vpl VALUES ("HB10_7","088_10_7","HEB","10","7","7","ህከ ወክት መጻፋን፥ ‹ኢተኔሃ ከተበሞገን ሁኩዕኑን ኢ መገኖ! አን ኪ ሙራድ ዊንሾተ ከቤቹ አሜቾም› ዬም» ዬእ። ");
INSERT INTO alw_vpl VALUES ("HB10_8","088_10_8","HEB","10","8","8","ወዕናሃ «ክትመለከ ሰደቀተ፥ ቡሴኖ ክትመለከ ጩብተኔሃ ክትሜኖ ክትም ሀሶንትበአ፤ እሶኒን ሙንደኦንትበአ» ኩሩኡት ሕግገ ሆንጠካእረ ዬእ። ");
INSERT INTO alw_vpl VALUES ("HB10_9","088_10_9","HEB","10","9","9","ህከኒች ኤተሮን «ኢ መገኖ! አን ኪ ሙራድክ ዊንሾተ አሜቾም» ዬእ፤ ህትን ዎኔሲሃ ክትመ ከም ቤቾንከስ ለምቅ ክትም ጠረኝሾ። ");
INSERT INTO alw_vpl VALUES ("HB10_10","088_10_10","HEB","10","10","10","ህካን እኮቤቺሃ መሲህ ኢስ መገን ሰውት አኢን ሜጦረ ሹል ማለስ ክትም አዕይ ሆንጠህሲንከስ ነኡ ጩብችኔ ጠሊላኑተ እንኮም። ");
INSERT INTO alw_vpl VALUES ("HB10_11","088_10_11","HEB","10","11","11","ሁኩ ሎሩ ቂሰት ጉዕሙንኩ ህከ ጩብ ቤሶተ ሆሮን አታልትቡ ህከ ክትማከተ ልግብ ወክት ሆንጠህሰን በሬን በሬን ኡር ካደመኖ። ");
INSERT INTO alw_vpl VALUES ("HB10_12","088_10_12","HEB","10","12","12","ጠዉ እኮጎሬ መሲህ ዘላለሚሃ መቱ ክትመ ሆንጠህሾች ኤተሮን መገን መኬ አዲን አፉዕልዮኡ። ");
INSERT INTO alw_vpl VALUES ("HB10_13","088_10_13","HEB","10","13","13","ከኒች ኤተሮን ዲነስ ሎካችስ ዎሮን እኮተ ኢለ አገረኖት። ");
INSERT INTO alw_vpl VALUES ("HB10_14","088_10_14","HEB","10","14","14","መሰንትስ መገኒሃ አደ እኮሁ ሜጦረ ሆንጠህሾ ክትሚን ዘማኒሃ ጉዕሚሃ ሹል ነጣኑተ አዕዮሰቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("HB10_15","088_10_15","HEB","10","15","15","ሄጭ ጠሊሉ አያኑ ከን ጠዋን መሰከረኖኔ፤ ");
INSERT INTO alw_vpl VALUES ("HB10_16","088_10_16","HEB","10","16","16","«ህከን ዘመኒች ኤተሮን እሳን ኣጋም ወኣድ ላገት ተኒት የኖ ቀርቹ፤ ቀልቤንከሰ ኢ ሕገ አፉሻም፤ ቡዕልሰ ኣዜን ከተቦም» ዬእ፤ ");
INSERT INTO alw_vpl VALUES ("HB10_17","088_10_17","HEB","10","17","17","ህትን «ጩብሰለከ ሂለ ሆጉሰ ሆሮ ሰውያምበአ» የኖ። ");
INSERT INTO alw_vpl VALUES ("HB10_18","088_10_18","HEB","10","18","18","ህካን እኮቤቺሃ ጩቡ ጉዕሙንኩ አጉረሞች ኤተሮን ጩብተኔሃ ሆንጠህሴኖ ክትሙ ሆሮን ሄአኖበአ። ");
INSERT INTO alw_vpl VALUES ("HB10_19","088_10_19","HEB","10","19","19","አመኤ ኦሶ! ኢስ ቄግ መሳን ጠሊልች ጠሊለ ቤቹ ኣንጎተ አታልሲሰኖኔ መለልመተ ደእኖም። ");
INSERT INTO alw_vpl VALUES ("HB10_20","088_10_20","HEB","10","20","20","ኣንጋሚንኩ መጋረጅ አዲን ሁኩንን ገይስ ጅስም አዲን ፈኞኔ ሃዕሮ ዘመኒሃ ጉዕሚንከ ሄአኖ ዎቄኒት። ");
INSERT INTO alw_vpl VALUES ("HB10_21","088_10_21","HEB","10","21","21","መገን ምኔን ሹምነቱ ዮስ ሎሩ ቂስቹ ዮኔ። ");
INSERT INTO alw_vpl VALUES ("HB10_22","088_10_22","HEB","10","22","22","ህካን እኮቤቺሃ ሂለ ጠዊች ነጠ እንኮተ ቀልብኔ መሲህ ኢስ ቄጊን ነጠ አዕን ጅስመኔ ነጠ ዊን ኣዕልን ሀንቅ አመዕነቲንለከ ነጠ ቀልቢን መገን ቤቹ ሆንጠንኮ። ");
INSERT INTO alw_vpl VALUES ("HB10_23","088_10_23","HEB","10","23","23","ከ ወኣድ ላገተ ኣሴኔሁ አመዕነሞኢሃ እኮቤቺሃ ከን አመዕንን መሰከርናም ተብሳሃ ለሞንሱዕነ ጠረኝንስ አንፎ። ");
INSERT INTO alw_vpl VALUES ("HB10_24","088_10_24","HEB","10","24","24","ኢታንለከ ጡመ ሆጎን መት-መቱኔ ጠረኝጨቀሞ ቤሉ ሀበቀሙንከ። ");
INSERT INTO alw_vpl VALUES ("HB10_25","088_10_25","HEB","10","25","25","ጉዕመ ወክትንከ ደቀመን መት-መቱኔ ጠረኝንሶ ቤሉ መት-መቱ መኑ ጭምዩ ሮሶገን ጭምዩ አጉርኑንከ፤ ዎዕኔች ባሰንከስ ቀርች አሜት በሩ ሆንጠኮገ ሰውይቴነን ከ ጠወ አዕዬ። ");
INSERT INTO alw_vpl VALUES ("HB10_26","088_10_26","HEB","10","26","26","ነኡ ሀንቅ ደእኖሚች ኤተሮን ኢትን ጩብ አዕኖምጎሬ ጩብሃኔ እሀኖ ዎሉ ክትሙ ሄአኖበአ። ");
INSERT INTO alw_vpl VALUES ("HB10_27","088_10_27","HEB","10","27","27","ጠዉ እኮጎሬ ከ ኤተሩ አገረመኖሁ ዋጅሲሰኖ ፍርድ በሩለከ መገኑ ግባ መነ እታ ጠረኘት ጊረት ዮኡ። ");
INSERT INTO alw_vpl VALUES ("HB10_28","088_10_28","HEB","10","28","28","ሙሲ ሕገ ህንቆ መንቹ ለሙ ህከረንገ ሰሱ ምስክሩ አሌስ መሰከሮች መረርሲጩ ዮበኢሃ ሬሀኖ። ");
INSERT INTO alw_vpl VALUES ("HB10_29","088_10_29","HEB","10","29","29","ህከረ መገን ቤቱ ህንቆሁ፥ ገዉንከስ ጠሊለ አዕዮስ ወኣድ ላገ ቄጉ ንጀስሾሁለከ መገን ኣስቶ አያነ ቦሮሮሁ ሄንከ ጠረኘገ ቀጠአመኖሃ አጉደኖህዕኔ? ");
INSERT INTO alw_vpl VALUES ("HB10_30","088_10_30","HEB","10","30","30","መሰንትስ «ገዱተ ፉላሚሁለከ ሀስሰኖ ኤዳሃ ባታሚሁ አኔት» ህትን «መገኑንኩ ኡመትስ አሌን ፈረደኖ» ዬኢሁ አዬት ጎር ደንጋም። ");
INSERT INTO alw_vpl VALUES ("HB10_31","088_10_31","HEB","10","31","31","ህካን እኮቤቺሃ ሄአኖ መገን አንጋን ኡቡ አበ ዋጅሲሰኖሃን። ");
INSERT INTO alw_vpl VALUES ("HB10_32","088_10_32","HEB","10","32","32","መሲህ ኑር ቶጌንታች ኤተሮን ልግብ ኦርሸተ ኣእቴን ጠረኘ አጰንሺን እጅቴንተ ዎኔ ዘማን ሰውይዬ። ");
INSERT INTO alw_vpl VALUES ("HB10_33","088_10_33","HEB","10","33","33","መት-መቱ ወክት መን ብሬን ቦሮሬማህዕኔ እቅ፤ ጀልጀልይቴንታአ እቅ፤ መት-መቱ ወክት ህትናሙ ኦርሸት ኢሌሰሀኑኡን ሜጡበ አዕኑሁ መዲንከሰ እኬን ኦሪሸተ ቶጌንታአ። ");
INSERT INTO alw_vpl VALUES ("HB10_34","088_10_34","HEB","10","34","34","አዕኑ ኡሱረሞ መኒሃ አሙዜነንታ፤ ቆሀኖለከ ጎፊበ ዱንያት ሰማን ዮህዕኔገ ደጌነንተቤቺሃ ዱንያክዕኔን ዘረፈንቶ ጎሬ ፈረኬን ጠወስ ሙንዲኖን ቶጌንታአ። ");
INSERT INTO alw_vpl VALUES ("HB10_35","088_10_35","HEB","10","35","35","ቴሱ ሎረ ሽልማት ደእቴነንተገ አአኖ አመዕነሙክዕኔ ኡጅቶኖቼ። ");
INSERT INTO alw_vpl VALUES ("HB10_36","088_10_36","HEB","10","36","36","መገኑ ኢተኖርቹ አቴን ሹልቴንታች ኤተሮን መገኑ ኣሶህዕኔተ ወኣድ ኣጎርቹ ደእቶኖተ ፈረኬን አገሩ ሀስሰኖህዕኔ። ");
INSERT INTO alw_vpl VALUES ("HB10_37","088_10_37","HEB","10","37","37","መሰንትስ «ሁኩ አሜተኖሁ ቀዎ ወክቲች ኤተሮን አሜተኖ፤ ዱንከኖበአ፤ ");
INSERT INTO alw_vpl VALUES ("HB10_38","088_10_38","HEB","10","38","38","ኢሀ እኮ ፈዩ መንቹ አመዕነትን ሄኡ ደአኖ፤ ጠዉ እኮጎሬ ኤተሩ ዋል ፈንቀሎ ጎሬ አን እሲን ሙንደኣምበአ» የመም ከተበሞኡ። ");
INSERT INTO alw_vpl VALUES ("HB10_39","088_10_39","HEB","10","39","39","ነኡ እኮጎሬ አመዕነቲን ጡምታሀኑኡኒት ቤሉ ኤተሩ ዋልት በኣሀዕኑኒበአ። ");
INSERT INTO alw_vpl VALUES ("HB11_1","088_11_1","HEB","11","1","1","አመዕነቱ ዩ ተብሴን አገዕርናምረ ደእናምገለከ ለዕንበርቹ ሄኡስ አጥራመች ኩለኖኔሃን። ");
INSERT INTO alw_vpl VALUES ("HB11_2","088_11_2","HEB","11","2","2","ዎዕኔ ዘማን መኑ መሰከረሞሳሁ አመዕነትሰ መሳኒት። ");
INSERT INTO alw_vpl VALUES ("HB11_3","088_11_3","HEB","11","3","3","ከለቀሞርቹ ጉዕሙንኩስ መገን ላጋን ከለቀሞገለከ ለዕናምርቹ ጉዕሙንኩ ለዕንበርቺች እሁስ አመዕነቲን ደንጋም። ");
INSERT INTO alw_vpl VALUES ("HB11_4","088_11_4","HEB","11","4","4","አቤል ቃኤሌ ክትሚች በተአኖ መገኑ ሙንዲሲሰኖ ክትም አመዕነቲን ሆንጠህሾ፤ እስ ሆንጠህሾ ክትም መገኑ ኢት ቶጎ ወክት ኣቤል አመዕነትስ መሳን ፈየ እኮገ መገኑ መሰከሮስ፤ ኣቤል ሬዮ ጎሬ አመዕነቲንከስ አዕዮ ሆጎን ከበሬ ኢለ ጠወአመኖት። ");
INSERT INTO alw_vpl VALUES ("HB11_5","088_11_5","HEB","11","5","5","ሄኖክ ሬሁተ ለኡዕነ ሰማሃ ኦሮዕዮሁ አመዕነቲኒት፤ እስን መገኑ መሴስቤቺሃ ደገሞበአ፤ ሄኖክን መገኑ መሱዕናንስ ሄጭ መገኑ ሙንደእሲሾጉ መሰከረሞስ። ");
INSERT INTO alw_vpl VALUES ("HB11_6","088_11_6","HEB","11","6","6","ህትን አመዕነቱ ዮበኢሃ መገኑ ሙንዲሲሱ አታለመኖበአ፤ መሰንትስ መገን ቤቹ ሆንጠሀኖሁ ጉዕሙንኩ መገን ሄኡስለከ እሱ ሀሳሀኑኡተ ሽልማት ኣሰኖ እሁስ አመዕኑ ሀስሰኖስ። ");
INSERT INTO alw_vpl VALUES ("HB11_7","088_11_7","HEB","11","7","7","ኑህ እሌን ለእባንከ እሀኖሃ እሁስ መገኑ ኩላንስ መገኑ ዋጅ ምንስ አበሮሱ ጡምሶተ መርከበ መክሾሁ አመዕነቲኒት፤ ኑህ አመዕነት መሳን ኣዱንያ አሉ ጩበኘ እክ ደገሞቤቺሃ ፈረደሞሰ፤ ኑህ አመዕነቲን ደኤኖ ፈይመተ ደእቶ መን በሊች መቱስ እኮ። ");
INSERT INTO alw_vpl VALUES ("HB11_8","088_11_8","HEB","11","8","8","እብራሂም እርስተ አዕይ አፈኖበ መሮተ ገአሞ ወክት መረኖስቤቹ ሀከንቤቹጎር ደጉዕናን ትዛዝ ቶግ መሮሁ አመዕነቲንት። ");
INSERT INTO alw_vpl VALUES ("HB11_9","088_11_9","HEB","11","9","9","እስገን ተብሴ ላገተ ረገኣኑተ እኮሀኑኡች ይሳቂንለከ ያቁቢን ተቢሴን ኣሰሞ ባዶን ሆቀንሸ ኣግ ዱካናን ሄዕዮሁ አመዕነቲንት። ");
INSERT INTO alw_vpl VALUES ("HB11_10","088_11_10","HEB","11","10","10","መሰንትስ እብራሂም መገኑ አቀጆሁለከ ጠረኝሽ እጃሮ ጠረኙ ቀበቡ ዮ ዘላለም ከተመ አገዕረኖሴቤቺሃት እቅ። ");
INSERT INTO alw_vpl VALUES ("HB11_11","088_11_11","HEB","11","11","11","ህትን ሳራሃ ተቢሳ ኣሴ መገኑ አመዕነሞሃ እኮገ ደጎቤቺሃ ሄንከሃ ኑባቹተ እሆንከሴ እሉ አታልትባተ እኮጎሬ ላፈተ እኮተ አታልታ ወልቀተ ደእቶኢሁ አመዕነቲኒት። ");
INSERT INTO alw_vpl VALUES ("HB11_12","088_11_12","HEB","11","12","12","ህካን እኮቤቺሃ ሬዮ መንገ ዎለአመኖ መቲች እብራሂሚች ሰሜ ቤዜገ በተዕዮለከ ባር ሽፋርገ ዎለኤንቡ ዘርት ደገንቶኡ። ");
INSERT INTO alw_vpl VALUES ("HB11_13","088_11_13","HEB","11","13","13","ሁኩ መኑ ጉዕሙንኩ ሬቶተ ኢለ አመዕነቱሰ አገርት ሄኦኡ፤ እሰን ኣሰሞሰ ተብሳሃ ደእቶበአ፤ ጠው እኮጎሬ ህካንን ቄዕራሻን ለእ ሙንዲኖን ኣእቶኡ፤ እሰን ኣዱንያ አሌን ኮሃለከ ዎሎ ባዲች አሜቶረ እሁሰ ጠወኦኡ። ");
INSERT INTO alw_vpl VALUES ("HB11_14","088_11_14","HEB","11","14","14","ህት ጠወኣ መኑ ሀንቅ እኮ ገይሰ እሀኖ ባዱ አገርታገ ግልጠ አት ለሊሳአ። ");
INSERT INTO alw_vpl VALUES ("HB11_15","088_11_15","HEB","11","15","15","ህከ አጉርት ፉልቶ ባዱ ቃጎእቃኔተ ህከ ቤቹ ፈንቀልቶተ አታልታ እቅ። ");
INSERT INTO alw_vpl VALUES ("HB11_16","088_11_16","HEB","11","16","16","ቴሱ እኮጎሬ በተአኖሲሃ ሰማን ዮ ባዱ ሱንታአ፤ ህካን እኮቤቺሃ መገኑ ከተመ ቅጥ አዕዮሰቤቺሃ «መገኑኔ» ይት ገእቶጎሬ ሙልሰኖስበአ። ");
INSERT INTO alw_vpl VALUES ("HB11_17","088_11_17","HEB","11","17","17","እብራሂም ፌተነሞ ወክት አመዕነቲን ኢሳቀ ክትሚሃ ሆንጠህሾ፤ ተቢሴ ላገተ ኣኤ እብራሂምን ሜጥቹስ ቤቱ ክትሞተ ተቃጠቦ እቅ። ");
INSERT INTO alw_vpl VALUES ("HB11_18","088_11_18","HEB","11","18","18","ሁኩንን መገኑ «ዘርክ ኢሳቂን ገአንታአ» ይዮስ እቅ። ");
INSERT INTO alw_vpl VALUES ("HB11_19","088_11_19","HEB","11","19","19","እብራሂምን መገኑ ሬሆች ኬሶተ አታለኖገ ደጎቤቺሃ ሬሆች ኬዕዮሀንገ ዎለዕይ ቤቱስ ኢሳቀ ደኤእ። ");
INSERT INTO alw_vpl VALUES ("HB11_20","088_11_20","HEB","11","20","20","ኢሳቅን ብርተ ዋሽ አሜተኖ ጠወ ሰውይ ያቁበለከ ኤሳ ማሰዕዮሳሁ አመዕነቲንት። ");
INSERT INTO alw_vpl VALUES ("HB11_21","088_11_21","HEB","11","21","21","ያቁብ ሬሀኖ ወክቱ ኢሌ ወክት ዩሱፍ እለተ መት-መቱሰ ማሰዕዮሁለከ ሽካንከስ ሽከዕይ መገኒሃ ሰገጆሁ አመዕነቲንት። ");
INSERT INTO alw_vpl VALUES ("HB11_22","088_11_22","HEB","11","22","22","ዩሱፍን ኤተሮን ሬሆተ ሆንጠኮ ወክት እስራኤል ኦሱት ግብጽ ባዲች ፉልታገ ጠወዕዮሁለከ ምቀስ አጉርት መርታበእገ አዘዦሳሁ አመዕነቲንት። ");
INSERT INTO alw_vpl VALUES ("HB11_23","088_11_23","HEB","11","23","23","ሙስ እለሞ ወክት አበ ተሽ የኖ ጩል እሁስ ሙስ አመስለከ አኑስ ለኦቤቺሃ ዎም ትዛዝ ዋጅቱዕናን አመዕነቲን ሰሱ አገነ ገበጭ አቶስ። ");
INSERT INTO alw_vpl VALUES ("HB11_24","088_11_24","HEB","11","24","24","ሙስን ነጴ ወክት «ፍራኦኔ ቤቶ ቤቱ» ዬን ገኤኖስበእገ አመዕነቲን ግቦ። ");
INSERT INTO alw_vpl VALUES ("HB11_25","088_11_25","HEB","11","25","25","መሰንትስ ጩቢን ቀዎ ወክቲሃ ደኤኖ ሙንዲኖች አበ መገን ኡመቲን ሜጡበ እክ ኦርሸተ ቶጉ መጠሮቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("HB11_26","088_11_26","HEB","11","26","26","ሙስ ብርተ ዋሽ አገረኖስ ሽልማት ደአኖገ መገኑ ቱክ ይ ለዕይ አመዕኔቤቺሃ ግብጽ ባድ ቀባጦች በትሽ መሲህተኔሃ ህንቀሙ አበ እሁስ ሰውዬእ። ");
INSERT INTO alw_vpl VALUES ("HB11_27","088_11_27","HEB","11","27","27","እስን ዎም ኡሙዕርተ ዋጁዕነ ግብጽ ባዲች አመዕነቲን ፉሎ፤ እሌን ለኤንበ መገኑ ለዕዮሀንገ አዕይ አላማንተስ ጠረኝ ኡሬእ። ");
INSERT INTO alw_vpl VALUES ("HB11_28","088_11_28","HEB","11","28","28","ሀንገፈ እለተ ቤሰኖ መላይኬቹ እስራኤል ሀንገፈ እለተ ኡለኖበእገ ሻሽግለከ ጡፋን ቄጉ ክፍ ሴረ አመዕነቲን አዕዮ። ");
INSERT INTO alw_vpl VALUES ("HB11_29","088_11_29","HEB","11","29","29","እስራኤል መኑ ሞልቶ ኡላን ቶልታሀንገ እክ አመዕነቲን ኤርትር ባረ ቶልቶኡ፤ እኮጎሬ ግብጽ ባድ መኑ «እሰገን ቶልናም» ይት ኬኦ ወክት ባር ዋን ኣአንቶኡ። ");
INSERT INTO alw_vpl VALUES ("HB11_30","088_11_30","HEB","11","30","30","ህትን ኢያሪኮ ከተም ግንቡ እስራኤል ኦሱት ለመለ በር አመዕነቲን ዘህቶች ኤተሮን ድጀም ኡቦ። ");
INSERT INTO alw_vpl VALUES ("HB11_31","088_11_31","HEB","11","31","31","ዝነተ አተ ረኣብ ኡለተ ዳንድታ መነ ወገሬቲን ቶጎቤቺሃ ህከ መገኒሃ አዘዘንቶበእ መኒን ሜጡበ በኡዕነ ሬሆች ጡምቶኢሁ አመዕነቲንት። ");
INSERT INTO alw_vpl VALUES ("HB11_32","088_11_32","HEB","11","32","32","ቴሱ ዎሉ መ ያም? መሰንትስ ጌድዎኔተኔሃ፥ ባረቄተኔሃ፥ ሶምሶኔተኔሃ፥ ዩፍታሄተኔሃ፥ ደዉዴተኔሃ፥ ሳሙኤሌተኔሃለከ ነቢያከተኔሃ ኩላምበኢሁ ወክቱ ሄዕበኤቤቺሃት። ");
INSERT INTO alw_vpl VALUES ("HB11_33","088_11_33","HEB","11","33","33","እሰን አመዕነቲን ዎመተ ቄልቶኡ፤ ጡመ ሆጉተ አቶኡ፤ መገኑ ኣሴሰ ተብሴ ላገተ ደእቶኡ፤ ዞቤ አፎንከ ጡፎኡ። ");
INSERT INTO alw_vpl VALUES ("HB11_34","088_11_34","HEB","11","34","34","ህትን ጊረ ዎልቀተ ቤሶኡ፤ ገመጠሞ ሲፍችን ፉሸእቶኡ፤ ላፍማች ጠረኝማን ህጎኡ፤ በገዞንን ጠረኝቶኡ፤ አብል ዲን በገዙንከ ሸርቶኡ። ");
INSERT INTO alw_vpl VALUES ("HB11_35","088_11_35","HEB","11","35","35","ሜንቱንኩ ሬቶ እሉሰ ሬሆች ኬኣን ደእቶኡ፤ ዎሉሰንገ ቆሀኖ ኬኡ ደእቶተ ሰውይት ሬቶተ ኢለ ኦለንቶኡ፤ ኡሱሮችን ሂረሙ ግቦኡ። ");
INSERT INTO alw_vpl VALUES ("HB11_36","088_11_36","HEB","11","36","36","ህትን ዎሉሰንገ ህንቄን ኦሌመሰ፤ ህከኒችን አበ ሰንሰለቲን ኡሱሬን ኡሱር ምኒ ኣግሴመሰ። ");
INSERT INTO alw_vpl VALUES ("HB11_37","088_11_37","HEB","11","37","37","ህትን ክኒን ቀሴናንሰ ሬቶኡ፤ መጋዚን ለሙ ቤቹ ፊሌመሰ፤ ሲፍን ሼመ፤ ጉዕመርቹንከ ሆግ ሸረንተንለከ ጨነቀንተን ሆለ ጎገለከ ፌዕላእ ጎገ ኦደእ ዞህቶኡ፤ ቡጥቻኑተለከ ሸሬመሰ መነ እክ ኦርጨቀንተን ሄኦኡ። ");
INSERT INTO alw_vpl VALUES ("HB11_38","088_11_38","HEB","11","38","38","እሳንከ ኩ ኣዱንያ አሉ ገበእበሰቤቺሃ ኡለ ኡድማን፥ ቆታን፥ ሻንቃንለከ ክን ረባን ዘህተን ሄኦኡ። ");
INSERT INTO alw_vpl VALUES ("HB11_39","088_11_39","HEB","11","39","39","ኩ ጉዕሙንኩ መኑ አመዕነትሰተኔሃ መሰከረሞሰጎሬ ኣሰሞሰ ተቢሳሃ ደእቶበአ። ");
INSERT INTO alw_vpl VALUES ("HB11_40","088_11_40","HEB","11","40","40","መገኑ ኔሳሃ ጉዕመ ቆሀኖርቹ ቅጥአዕዮቤቺሃ ሁኩ መኑ ነኡ ሄዕንባሃ ዊመ እኮተ አታልቶበአ። ");
INSERT INTO alw_vpl VALUES ("HB12_1","088_12_1","HEB","12","1","1","ህካን እኮቤቺሃ ጎመገ አደንከኔ ረብ ዮ ሁኩ ጉዕሙንኩ ምስክሩ ዮኔቤቺሃ እጅነገ ኬዕመኖርቹ ጉዕመንከለከ ኡሱር አፎኔ ጩብ አሊችኔ ከም ብሬንከኔ ዮ ሄጫቀንሸ ጠረኝን ደጉንዶ። ");
INSERT INTO alw_vpl VALUES ("HB12_2","088_12_2","HEB","12","2","2","ደጉንዳሚንኩ አመዕነቲሃኔ ቡዕለለከ ዊንሸኖሃ እኮ ኢሰ ለዕኒት፤ እስን ብሬንከስ ዮ ሙንዲኖተኔሃ ይ መስቀል አሌን ሬሀኖ ሬሆ ሆፍኝ መቱርቹሃ ዎለኡዕነ አታዕል መገን ዳኝነት ቦርጭማን መኬ አዲን አፉዕልዮኡ። ");
INSERT INTO alw_vpl VALUES ("HB12_3","088_12_3","HEB","12","3","3","ህትን አዕኑ ህፈቶኑዕናንለከ ተቢሳሃ ሙርቶኑዕናን ጩበኛኖ ኦደተ አታሎ ኢሰ ሰውይዬ። ");
INSERT INTO alw_vpl VALUES ("HB12_4","088_12_4","HEB","12","4","4","አዕኑ ጩቢን አጰንቴነን ቄጉክዕኔ ዱንተኦተ ኢለ ግቤንታበአ። ");
INSERT INTO alw_vpl VALUES ("HB12_5","088_12_5","HEB","12","5","5","መገኑ ክዕኔተ ገይስ እለገ «ኢ ቤቶ! ቀርች ሸዘነተ ህንቆት፤ ቀጠአኖሄ ወክትንከ ተቢሳሃ ሙርቶት። ");
INSERT INTO alw_vpl VALUES ("HB12_6","088_12_6","HEB","12","6","6","መሰንትስ ቀርቹ ኢተኖሲሃ ሻቀኖስ፤ ቤትስገ አዕይ ለአኖሃ ጉዕመንከ ቀጠአኖ» ዬ ሸዘነተ ሀቤንንዶ? ");
INSERT INTO alw_vpl VALUES ("HB12_7","088_12_7","HEB","12","7","7","አኑ ሻቅ ሸዝበስ ቤቱ አዬት? መገኑ ክዕኔተ እለስገ አዕይ ለአኖህዕኔቤቺሃ ሻቅ ሸዦህዕኔጎሬ አታዕልዬ። ");
INSERT INTO alw_vpl VALUES ("HB12_8","088_12_8","HEB","12","8","8","ህትን እለስ እኮእሩ ጉዕሙንኩ ቀጠአንተ ቅጣቲሃ አዕኑ ቀጠአንቶኑዕናን ፈቄንተጎሬ ህንጨረባሃ ቤሉ እለተስበአ። ");
INSERT INTO alw_vpl VALUES ("HB12_9","088_12_9","HEB","12","9","9","ማሊን እልቶህዕኔ አናኑት ቀጠኦህዕኔ እቅ፤ እኮጎሬ ነኡ እሰተ ኬዕምንሳንሰ እቅ፤ ህካን እኮች ሄኢሃ ጉዕሚንከ አነ እኮ መገኒሃ ሄንከ በትንስ ጠገሙለከ ሄኡ ሀስሰኖኔ? ");
INSERT INTO alw_vpl VALUES ("HB12_10","088_12_10","HEB","12","10","10","አናከክዕኔ ቀዎ ወክቲሃ ጡመ አጉጅ ለሌሰገ ቀጠኦኔ እቅ፤ እኮጎሬ እስ ጠሊለ እኮገን ጠሊላኑተ እንኮተ ኒ መኮተ ይ ቀጠአኖኔ። ");
INSERT INTO alw_vpl VALUES ("HB12_11","088_12_11","HEB","12","11","11","ቅጣቱ ጉዕሙንኩ ወክቲሃስ ሻዝሰኖ ቤሉ ሙንዲሲስበሃን፤ ኤተሮንገ ሮሶ መኒሃ ወገሬትለከ ፈይመ ላልቹ ላልታገ አአኖ። ");
INSERT INTO alw_vpl VALUES ("HB12_12","088_12_12","HEB","12","12","12","ህካን እኮቤቺሃ ናፎ አንገክዕኔለከ ሆጎ ጉበክዕኔ ጠረኝሼ። ");
INSERT INTO alw_vpl VALUES ("HB12_13","088_12_13","HEB","12","13","13","አዕኑ ድኑ እኮ ሎከክዕኔ ፈይቶታት ቤሉ