﻿USE sofia;
DROP TABLE IF EXISTS sofia.alqALGNT_vpl;
CREATE TABLE alqALGNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES alqALGNT_vpl WRITE;
INSERT INTO alqALGNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Niga mikoma Jesos Christ. Ogima Davidikag odaiagizigoban aa Jesos, acitc dac ogima David 8in Abanaamikag (Abraham) odaiagizigoban. Midac oo 8edaiagizipan Jesos: ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abanaam ini og8izisibanin Aisikan (Isaac). Aisik ini og8izisibanin Tcekapan (Jacob). Tcekap ini og8izisibanin Codan (Juda) acitc Codan ka iji 8idjiki8endjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Coda ini og8izisibanin Peresan (Pharès) acitc Zaran. Mi ini odjodjomi8abanin Tamaran. Peres ini og8izisibanin Esroman. Esrom ini og8izisibanin Araman. ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ini og8izisibanin Aminadaban. Aminadab ini og8izisibanin Naassonan. Naasson ini og8izisibanin Salmon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmo ini og8izisibanin Boozan. Mi ini Booz odjodjombanin Raaban. Booz ini og8izisibanin Obedan. Mi ini Obed odjodjombanin Ruthan. Obed ini og8izisibanin Jessen. ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse ini og8izisibanin ogima Davidan. David ini og8izisibanin Sanamo (Salomon). Sanamo odjodjoman, mi ini ockadok Ori (Urie) okokomimbanin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sanamo ini og8izisibanin Roboaman. Roboam ini og8izisibanin Abian. Abia ini og8izisibanin Asafan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaf ini og8izisibanin Josapatan. Josapat ini og8izisibanin Joraman. Joram ini og8izisibanin Oziasan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ozias ini og8izisibanin Joataman. Joatam ini og8izisibanin Akazan. Akaz ini og8izisibanin Ezekiasan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekias ini og8izisibanin Manasan. Manasa ini og8izisibanin Amonan. Amon ini og8izisibanin Josiasan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josias ini og8izisibanin Iekonian acitc ka iji 8idjiki8edj Iekonia. Midac ii apitc ka iji8inagani8i8adj Israel a8iagog 8edi Babilon (Babylone) akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ka ick8a iji8inagani8i8adj Israel a8iagog 8edi Babilon akikag, Iekonia ini og8izisibanin Salatielan. Salatiel ini og8izisibanin Zorobabelan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel ini og8izisibanin Abiodan. Abiod ini og8izisibanin Eliakiman. Eliakim ini og8izisibanin Azoran. ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor ini og8izisibanin Sadokan. Sadok ini og8izisibanin Akiman. Akim ini og8izisibanin Eliodan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliod ini og8izisibanin Eleazaran. Eleazar ini og8izisibanin Matanan. Matan ini og8izisibanin Tcekapan (Jacob). ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Tcekap ini og8izisibanin Josepan, mi ini Mani o8idigemaganibanin. Mi aa Mani kagi nta8igiadjin Jesosan, 8in “Kije Manido ka pidjinija8adjin” ka ijinikanagani8indjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Midatcin acitc ni8in dac ki ani aianike nta8igi8ag ka ako tedj Abanaam (Abraham) pinici David. Mina8adj dac midatcin acitc ni8in inigik ki ani aianike nta8igi8ag ka ako tedj David pinici kidji odjitcisenig apitc kagi ijinija8agani8i8agobanen Israel a8iagog 8edi Babilon akikag. Mina8adj dac midatcin acitc ni8in ki ani aianike nta8igi8ag ka ako ijinija8agani8i8agobanen Israel a8iagog 8edi Babilon akikag pinici kidji nta8igindjin Jesosan, mi ini Kije Manido kagi ikidogobanen kidji pidjinija8agobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","8adan adi ka ijiseg apitc Jesos Christ ka pi nta8igidj. Odjodjoman Manin aja ki iji pagidinimagani8inigoban Josepikag kidji iji niba8indjin. Ab8amaci dac madji 8idji tajikemidi8adj, abinodjijan ogi kigicka8an Mani, kagi minigodjin Mino Manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kitci k8aiak8adizigoban aa nabe Josep, Manin ke iji 8idigemadjin. Apitc Josep ka kikendag Manin kidji otcidjicimindjin, ogi inendanaban kidji naganadjin, ka8in dac o8i ki8enija8asi8abanin meg8adj e kijigabamagani8idj, acitc ogi inendanaban kidji kimodji madjinija8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ka8in maci ododji onendasinaban adi ke inakamigizidj, apitc ka pi nda 8abamigodjin ka Tibendjigendjin odajenimini meg8adj e nibadj. Ajenin dac ogi igon: “Josep, kin David odanike ojisan, ka8in segiziken Mani kidji iji o8idigemaganian. Teb8e mega Mino Manidon ogi minigon kidji kigicka8adjin abinodjijan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kada og8izisi. Jesos kiga ijinikana. Oga ag8aciman mega odanicinabeman adi ka iji patadindjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kakina dac ii ki iji8eban, 8eckadj kagi minapanin ka Tibendjigedj niganadjimo8innin kidji tibadjimondjin: ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ockinigik8e kada kigicka8aso. Kada og8izisi. Emmanuel kada ijinikazo8an.” Emmanuel dac ikidomagan: “Kije Manido ki8idjiogonan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Apitc ka kockozidj Josep, mi ka inakamigizidj kagi igodjin ka Tibendjigendjin odajenimini. Ogi 8idigeman Manin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ka8in dac ododji pamenimasi8an Manin, pinici kidji nta8igindjin og8izisini. Josep dac ogi 8inan ini abinodjijan, “Jesos” ogi ijinikanan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesos ki nta8igigoban Betleem (Bethléem) odenakag, Coda (Judée) akikag, meg8adj Herod ka ogima8igobanen. Ka ick8a nta8igidj, nandam nabeg ka nanada kikenima8adjin 8anagocan, acitc 8abanog ka odji8adj, Jerusalem odenani ogi oditana8a. ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ki k8ag8ed8e8ag dac: “Adi apan abinodjij kagi nta8igidj acitc ke Coda8inni ogima8idj? Nigi 8abamananan o8anagociman 8abanog inekena. Nigi pijamin dac e pi nda manadjiagidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Apitc ogima Herod ka nodagedj ii, ki kitci migockadendam, acitc ke8ina8a kakina a8iagog Jerusalemikag ka tajike8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herod dac ogi ma8adjian kakina Coda8inni kitci aiamie ogiman acitc Coda8inni kikinoamage8innin. Midac ka iji k8ag8edjimadjin adi ke iji nta8iginipanin ini8eni8an Kije Manidon kagi ikidonigobanen kidji pidjinija8andjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ogi nak8e8ajia8an dac: “8edi Betleem odenag, Coda akikag. Mi mega oo niganadjimo8inni kagi ojibiamogobanen: ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Kin Betleem, misa8adj e kitci agacinojag kidodenam, Coda akikag ka iji tag8ag, kin ma8adji kitci apitendag8an kidodenam kakina ka inigok8ag Coda aki. Kidakikag mega kada odji nta8igi pejig Ogima kakina Israel a8iagon kidji nosoneogodjin,’ mi ejibiigadeg,” ki ikido8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herod dac ogi kimodji nd8e8eman ini8e naben 8abanog ka odjindjin, kidji 8idamagodjin anapitc maia ka nagozindjin 8anagocan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Midac 8edi Betleemikag ogi ijinija8an acitc ogi inan: “Madjaok, k8ag8e mika8ik dac ataji maia e tedj aa abinodjij. Apitc dac ick8a mika8eg, pi nda 8idamaocik, kenin kidji gi nda manadjiag,” ogi inan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Apitc ka ick8a aiamiigo8adjin ogiman, igi8e nabeg ki madja8ag. Mina8adj dac ki koki nagozi8an ini 8anagocan kagi 8abama8agobanen 8edi 8abanog inekena. Ki ani nigani8an ini 8anagocan ke ani ija8adj, pinici kidji iji kibisikandjin iima ka iji tegobanen aa abinodjij. ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ki kitci min8endamog apitc mina8adj ka koki 8abama8adjin ini 8anagocan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ki pidige8ag dac migi8amikag acitc ogi 8abama8an ini abinodjijan acitc odjodjomini Manin. Ogi nibak8ita8a8an dac acitc ogi manadjia8an. Mina8adj dac ogi cebidona8an omackimoda8an acitc ogi ca8enima8an oza8iconian, acitc ka minomatenig pig8ini, acitc ka minomag8anig pig8ini “mir” (myrrhe) ka ijinikadenig. ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mina8adj dac Kije Manido ogi inan ini naben meg8adj e nibandjin ega kidji koki nda 8abama8adjin ogiman Herodan. Midac kodag mikanani ka iji madjiado8adj e ki8e8adj odaki8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ka ick8a madja8adj igi8e nabeg 8abanog ka odji8adj, ka Tibendjigedj odajeniman ogi pi nda 8abamigon Josep meg8adj e nibadj, acitc ogi igon: “8anickan, madji8ij aa abinodjij kigi odjodjoman, acitc Idjip (Égypte) akikag ipai8en. Tajiken 8edi, pinici kidji 8idamonan anapitc ke pi koki ki8ean. Ogima Herod mega oga nanada 8abaman ini abinodjijan kidji nisadjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josep dac ki 8anicka, ogi madji8inan ini abinodjijan acitc odjodjomini, acitc Idjip akikag ki ipai8e8ag meg8a tibik. ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ki tajike8ag dac 8edi pinici kidji nibondjin Herodan. Kakina dac ii ki ani iji8ebani kagi inapanin ka Tibendjigedj kidji tibadjimondjin niganadjimo8innin: “Nigi nd8e8ema nig8izis kidji nagadag Idjip akini.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Meg8adj kiabadj e pimadizipan ogima Herod, apitc ka kikendag egi 8agackibinigodjin ini naben 8abanog ka odjindjin, ki kitci nickadizi. Ki anoki dac kidji nisimagani8indjin kakina ockina8esan Betleem ka tajikendjin acitc 8ajagam iima, ka nijopibon8ezindjin iji tcabacic. Mi mega ii ka iji tibaigepan, e abadjitodj ka igopanin ini naben kagi 8abamanipanin 8anagocan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kakina dac ii ki iji8ebani kagi iji tibadjimogobanen niganadjimo8inni Jeremi: ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Nodjigade e pabibaginani8ag iima Rama odenakag. Kitci ma8inani8an acitc kitci kackendjigade. Racel (Rachel) omoka8anan odabinodjijiman. Ka8in kackiagani8isi kidji kagidjiagani8idj, kakina mega ki nisagani8i8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Apitc ka nibodj ogima Herod, ka Tibendjigedj odajeniman ogi pi nda 8abamigon Josep, 8edi Idjip (Égypte) akikag, meg8adj e nibadj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ajenin dac ogi igon: “8anickan, madji8ij aa abinodjij kigi odjodjoman. Koki ki8en dac 8edi Israel akikag. Aja mega ki nibo8ag igi8e ka 8i nisa8apanin ini abinodjijan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Josep dac ki 8anicka, ogi madji8inan ini abinodjijan kigi odjodjomini, acitc ki koki ki8e8ag Israel akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Josep dac ki nodage Akiliosan (Archélaüs), Herodan og8izisini, egi nabicka8andjin odadamini kidji ogima8indjin 8edi Coda (Judée) akikag. Midac ka iji segizidj kidji iji a8i tajikedj iima. Mina8adj dac ki 8idama8agani8i meg8adj e nibadj adi ke todag, midac ka iji ijadj Galilee akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","8edi dac ki nda tajike pejig odenani, Nazaret (Nazareth) ka ijinikadenig. Midac ka iji8ebag adi kagi ikido8agobanen niganadjimo8innig: “Kada Nazareti8inni8i aa Kije Manidon ke pidjinijaogodjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ii apitc, Cabadis ki odji tag8icinogoban pig8adakamig Coda (Judée) akikag, e paba kagik8edj oo8e: ");
INSERT INTO alqALGNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“An8endizok, aja mega peconag8ani Kije Manido Odogima8i8in.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Mi ini Cabadisan kagi mikomadjin niganadjimo8inni Isaia apitc ka tibadjimogobanen: “A8iag kada tag8icin kidji pabibagidj pig8adakamigokag. Mi oo8eni ke ikidodj: Eco8iok kidji tag8icig ka Tibendjigedj. Ojitamaok e k8aiakojimonig mikanani.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Aa8e Cabadis ka nijo pik8aoganendjin a8esizi8aianan ijiogoban, acitc pack8egino kitcipizonan okigicka8abanin opik8anakag. Papakinen inadjigegoban acitc amo sizibak8adoni pig8adakamigokag kagi iji mikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","A8iagog dac ka tajike8agobanen Jerusalem odenani acitc mizi8ena Coda akikag acitc pecodj Jourdain sibikag ogi pi nda 8abama8abanin Cabadisan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","8idamage8agoban egi patadi8adj, Cabadis dac Jourdain sibikag ogi iji sigaada8agoban. ");
INSERT INTO alqALGNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Cabadis ogi 8abaman mane Coda8innin ka nagadjitonigobanen inakonige8inan, “Parisienag” (Pharisiens) ka ijinikanagani8inigobanen, acitc Coda8innin ega ka teb8etamindjin abidjiba8ini, “Sadose8innig” (Sadducéens) ka ijinikanagani8inigobanen, e pi nda 8abamigodjin kidji gi sigaada8adjin. Cabadis dac ogi inan ini: “Kina8a madji a8iagog! Tabickotc ka pitcibo8inezi8adj kinebigog kidijinagozim! A8enen kagi kikinoamago8eg kidji kackito8eg kidji ojidameg Kije Manido otibakonige8in ke pijamaganig? ");
INSERT INTO alqALGNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kicpin teb8e an8endizo8eg, kidinendagozim kidji 8abadjigadeg e mino ijitcigeieg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ka8in inendakegon: ‘Ka8in kiga tibakonigosimin, Abanaamikag (Abraham) mega kidiji kitci odadamimin.’ Ceck8at iidi kidinendana8a! Ki8idamonom kidji kijigabameg8a igi asinig. Kije Manido ogagi meckodjian ini asinin Abanaam odanike ojisan kidji gi ijinagozindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Aja ick8a tacaigade ozidak kidji kicka8agani8i8adj mitigog ka odji 8adadabigicino8adj. A8enatigigotc ega mino minatigo8idj kada kicka8agani8i acitc kada madjocte8ebinagani8i.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Nin nibikag kidiji sigaadaonom kidji nag8ag aja egi an8endizo8eg. Anic dac aa8e nage ke pi tag8icig, na8adj kitci macka8izi apitc8in nin. Ka8in tibise nidapitendagozisi kidji maninam8agin omakizinan. 8in dac Mino Manidokag acitc ickodekag kiga iji sigaadago8a. ");
INSERT INTO alqALGNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Mi maia tabickotc a8iag ka ick8atadj kidji kizi8adjin anominan ejinagozidj. Oga papa8ibanian kidji managodenig ega ka iji minozindjin. Oga ma8adjian dac anominan, otatasonigi8amikag oga iji naasan. Oga ick8azanan dac ega ka min8acinigin kegonan ickodekag ega 8ikad ka ata8enig.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kegapitc Jesos ki tag8icin 8edi Jourdain sibikag, Galilee akikag egi pi odosedj. Ogi pi nda 8abaman Cabadisan kidji gi sigaadagodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Cabadis dac ka8in ododji 8i sigaada8asi8an acitc ogi inan: “Nin sa kinada8enimin kidji sigaadaojian. Adi dac 8edji pi nazikaojian kidji gi sigaadaonan?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesos ogi nak8e8ajian: “Mi iji pagidinan iidi kidji iji8ebag pinama. Panima mega iidi ki todamak kidji iji8ebag kakina adi ka iji nda8endag Kije Manido.” Cabadis dac ogi sigaada8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Teci8ag ka ick8a sigaadazodj Jesos, ki ag8azi. Ii dac maia apitc ki cese 8ak8ig, acitc ogi 8abaman Kije Manidon Omino Manidomini e pi najisendjin 8agidj 8inikag, mi maia omimi ka 8abizidj ejinagozindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Midac a8iag 8ak8ig ki odji mad8e anim8e: “Mi aa Nig8izis ka kitci sagiag. Nikitci min8endamiig aa.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kegapitc Jesos ogi iji8inigon Mino Manidon ka iji pig8adakamiganig, kitci madji manidon kidji k8ag8e 8agackibinigodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ka ick8a nimidana8egonaganig acitc nimidana taso tibik ega kegon egi midjigobanen, Jesos ki odji 8i 8isinigoban. ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kitci madji manidon ogi pi nazikagon, kidji k8ag8e 8agackibinigodjin. Ogi igon dac: “Kicpin Kije Manido Og8izisan aiaa8ian, ijik igi asinig kidji ani pak8ejigani8i8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesos dac ogi nak8e8ajian: “Mazinadeni oo8e Kije Manido Omazinaiganikag: ‘Ka8in pak8ejiganan eta kadagi odji pimadjiosi a8iag. Panima onada8endanan kakina Kije Manido odanim8e8inan kidji odji pimadjiodj,’ ” ogi inan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mina8adj dac kitci madji manido ogi iji8inan Jesosan Jerusalem odenakag, mi ii Kije Manidon ododenamini, acitc 8agidj Coda8inni kitci aiamiemigi8amikag ogi iji 8agidasan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ogi inan dac: “Ack8e sa pinig8ackonin, kicpin Kije Manido Og8izisan aiaa8ian. Mazinadeni mega oo8e Kije Manido Omazinaiganikag: ‘Oga anonan odajeniman kidji nagadjiik8a. Kiga midjiminigog dac, ega 8a8adj kidji 8isagizidecinian asinikag,’ ” ki ikido aa madji manido. ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesos dac ogi nak8e8ajian: “Mazinadeni acitc Kije Manido Omazinaiganikag: ‘Ka8in k8ag8e kadjinija8akegon ka Tibendjigedj Kikije Manidomi8a kidji abadjitodj omacka8izi8in.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Mina8adj dac kitci madji manido ogi iji8inan Jesosan 8agidadin pik8adinani e kitci icpadinanig. Ogi 8abadaan kakina ogima8i8inan ooma akikag acitc adi eji kitci minonag8anigin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ogi 8idama8an dac: “Kakina ini ogima8i8inan kiga minin, kicpin nibak8itaojian kidji icpenimijian.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesos dac ogi inan: “A8as 8edi ijan madji manido! Mazinadeni mega oo8e Kije Manido Omazinaiganikag: ‘Kiga icpenima8a ka Tibendjigedj Kikije Manidomi8a, acitc 8in eta kiga anokita8a8a.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Midac ka iji naganigodjin kitci madji manidon. Ajenig dac ogi pi nda nazika8a8an Jesosan acitc ogi pi nda 8idoka8a8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Apitc Jesos ka nodagedj egi takonagani8indjin Cabadisan, Galilee akikag ki ija. ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ka8in dac odji nda tajikesi 8edi Nazaret odenakag. Tiegodj 8edi Kaponaom (Capernaüm) odenakag ki a8i tajike, pecodj Galilee sagaiganikag, 8edi akikag ka iji tajike8agobanen igi8e Coda8innig Sebilan (Zabulon) acitc Napitali (Neftali) ka odakanezi8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Midac kidji gi iji8ebanig ka ikidogobanen niganadjimo8inni Isaia: ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“8edi Sebilan (Zabulon) akikag acitc Napitali (Neftali) akikag, pecodj kitcigamikag ka tag8agin, pinici k8ekagam Jourdain kitci sibikag, mizi8e Galilee akig, taji ka odji8adj ega ka Coda8inni8i8adj, ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","igi8e a8iagog iima ka tajike8adj ka iji kacki tibikanig, ogi odji 8abadana8a e pi kitci 8aseanig. Igi8e odji ka iji kacki tibikanig akini ka tajike8adj, nibo8ini ka iji tag8anig, ki odji kitci tcakateni.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ii apitc Jesos ki madjitagoban kidji kagik8edj oo8eni: “An8endizok! Aja mega peconag8ani Kije Manido Odogima8i8in.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Meg8adj e pimosepan tcigagam Galilee sagaiganikag, Jesos ogi 8abaman nijin kigozike8innin e taji pagida8andjin. Simo Pien dac aa pejig ijinikazo, kodag dac mi ini o8idjiki8en, Andre ijinikazo8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesos dac ogi inan: “Pijaok! Nosoneocik! Kiga 8abadainom dac adi ke todameg kidji pidji8ineg8a a8iagog ninikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Teci8ag dac ogi nagana8an odasabi8an. Midac ka iji nosone8a8adjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","A8acic 8edi ki iji madja Jesos, acitc ogi 8abaman nijin naben e iji 8idjiki8emidindjin, Jak (Jacques) acitc John e ijinikazondjin, mi ini Zebedee og8izisan. Otcimani8akag te8agoban kigi odadami8an, e taji 8a8ejaasabi8agobanen. Jesos dac ogi nd8e8eman. ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Teci8ag ogi nagadana8a otcimani8a acitc odadami8an. Midac ka iji nosone8a8adjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesos ki paba ijagoban mizi8e Galilee akikag. Kikinoamageban pepakan Coda8inni aiamiemigi8amikag, e paba kagik8edj min8adjimo8ini ka odji kikendjigadenig Kije Manidon Odogima8i8ini, acitc okigeabanin kakina ka akozindjin adigotc ka inapinendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jesos ki ani mikomagani8i mizi8e Siria (Syrie) akikag. Kakina dac ka akozi8adj pepakan ka inapine8adj ki pidji8inagani8i8ag Jesosikag kidji kigeigo8adjin. Nandam e taci8adj kitci 8isagendamobanig, nandam okigickago8abanin madji manidon, nandam majise8apinebanig, acitc nandam op8ana8itona8aban kidji pimose8adj. Jesos dac kakina ogi kigean. ");
INSERT INTO alqALGNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kitci mane a8iagog onosone8a8agoban Jesosan. Galilee akikag odose8agoban, acitc Midatcin Odenan ka ijinikadenig akini, Jerusalem odenakag, Coda (Judée) akikag, acitc k8ekagam Jourdain sibikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Apitc ka 8abamadjin e kitci manendjin a8iagon e nosoneogodjin, Jesos ki ik8amadji8e pik8adinajicini. Apitc dac ka abidj, okikinoamaganan ogi pi nazikagon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ki madji kikinoamage dac. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ca8endagozi8ag igi8e ka kikendamo8adj ega eta 8ina8akag kidji gi iji apacenimo8adj, Kije Manidokag dac maia kidji iji apacenimo8adj, Kije Manidon mega Odogima8i8inikag iji tibendagozi8ag! ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ca8endagozi8ag igi8e ka kackendamo8adj, Kije Manidon mega oga kagidjiigo8an! ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ca8endagozi8ag igi8e ka nokidee8adj, kada minagani8i8ag mega ii akini Kije Manidon kagi ikidonipanin kidji migi8endjin! ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ca8endagozi8ag igi8e ka kitci nda8endamo8adj Kije Manidon ka iji nda8endamindjin kidji inadizi8adj, oga aiana8a mega kakina kagi iji pagosendamo8adj! ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ca8endagozi8ag igi8e ka kidimagenima8adjin kodagian a8iagon, Kije Manidon mega oga kidimagenimigo8an! ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ca8endagozi8ag igi8e ka paiekidee8adj, oga 8abama8an mega Kije Manidon! ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ca8endagozi8ag igi8e ka 8idjia8adjin kodagian kidji mino 8idji8idindjin, Kije Manidon mega ‘nidabinodjijimag’ oga ijinikanigo8an! ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ca8endagozi8ag igi8e ka nanekadjiagani8i8adj e ndota8a8adjin Kije Manidon adi eji nda8endamindjin, Kije Manidon mega Odogima8i8inikag iji tibendagozi8ag!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Kica8endagozim apitc a8iagog manazomigo8eg, nanekadjiigo8eg, acitc kagina8icki8adj e madji mikomigo8eg, e nosoneojieg odji. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Min8endamok acitc modjigendamok. Teb8e mega Kije Manido kiga kitci ca8enimigo8a 8ak8ig. Mi iidi maia kagi iji nanekadjiagani8i8adj niganadjimo8innig, kagi pimadizi8apan ab8amaci kina8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesos kiabadj ki ikido: “Ci8itagan kidijinagozim ooma akikag. Kicpin dac ani ijiseg ci8itagan ega kidji ci8itaganipog8ag, adi dac kegi todjigadegiban kidji koki ci8itaganipog8ag? Ka8in aja odji pejig abadasinon. Sagidji8ebinigade dac, acitc a8iagog omamagockana8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“8asakonendamagan kidijinagozim ooma akikag. Kakina dac a8iag o8abadan odenani kicpin pik8adinakag iji tag8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ka8in a8iag 8asakonendjigani osakaasin, anamig akikokag kidji iji atodj. Tiegodj 8asakonendjiganatigokag odiji aton, kakina a8iagon pidigamig ka tendjin kidji 8asakonendama8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mi iidi enendag8ag kidji inasakoneg ki8asakonendjigani8a a8iagog odji, kidji gi 8abadamo8adj adi eji mino ijitcigeieg, acitc kidji gi odji icpenima8adjin Kije Manidon Kidadami8an, 8ak8ig ka tendjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ka8in inendakegon egi pijaian kidji pi nda pigobida8ag Mois odinakonige8in, kek8an niganadjimo8innig okikinoamage8ini8a. Ka8in nidodji pijasi kidji pi nda pigobido8anin, nigi pija sa kidji pi 8abadai8eian adi maia 8a ikidomagagin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Teb8e ki8idamonom, inigikigotc ke tag8ano8ag8en 8ak8i acitc aki, ka8in 8a8adj pejig ka agacinojag ojibiigan kek8an pejig ega ka apitendag8ag inakonige8in kada 8ebinigadesinon, pinici kakina kidji iji8ebagin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kicpin dac a8iag ana8endag pejig eta ini inakonige8inan, misa8adj ma8adji ega ka apitendag8anig, acitc kikinoama8adjin kodagian a8iagon kidji kagikina8abamigodjin, mi aa ma8adji ke tabasendagozidj Kije Manidon Odogima8i8inikag. Aa8e dac ka nosoneagin ini inakonige8inan acitc kikinoama8adjin kodagian a8iagon kidji kagikina8abamigodjin, mi aa8e ke kitci icpendagozidj Kije Manidon Odogima8i8inikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Teb8e ki8idamonom, kicpin ega na8adj k8aiak8adizieg apitc8in Coda8inni kikinoamage8innig acitc Coda8innig ka nagadjito8adjin inakonige8inan, ka8in kigagi pidigesim Kije Manido Odogima8i8inikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kigi nodana8adok adi ka inagani8i8adj 8eckadj kikitci anicinabeminabanig: ‘Ka8in kiga nici8esim. Kicpin a8iag nici8edj, kada tibakonagani8i.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nin dac 8in ki8idamonom oo8e. A8enenigotc ke kiji8azig8en o8idjiki8en odji kada tibakonagani8i. Aa8e ka inadjin o8idjiki8en: ‘Kikikimadizinan!’ kada iji8inagani8i nigan Coda8inni kitci aiamie onakonige8innikag. Aa dac ka inadjin: ‘Ka8in odji pejig kidabadizisi!’ kackitamadizo kitci ickodekag kidji madjocte8ebinagani8idj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Apitc dac nda migi8ean kipagidinige8in kitcit8a 8isini8aganikag taji ka iji icpenimagani8idj Kije Manido, odji mika8ian dac egi kiji8aadj kidjiki8e, ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","mi iji nagadan iima kipagidinige8in. Pinama dac a8i nda kagidjii kidjiki8e, midac pidjinag ke nda migi8ean kipagidinige8in.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kicpin a8iag inactaonik egi madji toda8adj, acitc ani 8idjiok tibakonige8igi8amikag e ijaieg, nanada8i todan teci8ag kidji gi 8a8ejibido8an ii, ab8amaci kidji oditameg. Kicpin mega ega mikidaman ii, kiga iji8inig nigan tibakonige8innikag, tibakonige8inni dac kiga pagidenimig takoni8e8innikag, acitc takoni8e8inni kiga kibaog kibaodimigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Teb8e dac ki8idamonom, ka8in kiga sagaasi iima, pinici kidji ick8a kijikazo8an ick8eag somanike inigik ka inendagozian kidji kijikazo8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Kigi nodana8adok adi ka inakonigani8ag: ‘Ka8in madji aido8in pamendakegon.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nin dac 8in ki8idamonom oo8e. Aa nabe ka kana8abamadjin e mosa8enimadjin ik8e8an, aja madji aido8ini opamendan odeikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kicpin kickijig kikitcinikikag inekena pataigo8an, manibidon, midac 8asag inatig8en. Na8adj kiga minose kidji 8anito8an pejig kickijig apitc8in kidji madjocteigadeg kakina kia8 kitci ickodekag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kicpin kikitcinidji pataigo8an, kickijan, midac 8asag inatig8en. Na8adj kiga minose kidji 8anito8an pejig kinidji apitc8in kidji madjocteigadeg kakina kia8 kitci ickodekag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ki inakonigani8an acitc: ‘A8enenigotc 8ebinadjin okokomiman, panima ojibiigani oga minan e 8ebinadjin.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nin dac 8in ki8idamonom oo8e. A8enenigotc 8ebinadjin okokomiman ega egi nodjiandjin kodag naben, opatadian ini ik8e8an, madji aido8ini mega oga pabamendamini kicpin koki niba8indjin. Acitc aa8e ke 8idigemadjin ini ik8e8an, ke8in madji aido8ini opabamendan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kigi nodana8adok adi ka inagani8i8adj 8eckadj kikitci anicinabeminabanig: ‘Kicpin inadj ka Tibendjigedj ketcinam kegoni kidji todam8adj, todan adi kagi ikido8an kidji todaman.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nin dac 8in ki8idamonom oo8e. Apitc ikido8eg kegon kidji todameg, ka8in kegon 8idakegon kidji odji na8adj teb8etago8eg. Ka8in ikidokegon: ‘Icpimig nidodji teb8e,’ mi mega iima eji abidj Kije Manido ka ogima8idj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ka8in ikidokegon: ‘Akikag nidodji teb8e,’ mi mega iima eji tajigaba8idj Kije Manido. Acitc ka8in ikidokegon: ‘Jerusalemikag nidodji teb8e,’ mi mega ii kitci ogima ododenam. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Acitc ka8in ikidokegon: ‘Nictig8anikag nidodji teb8e,’ ka8in mega iaga pejig 8ina8anisis kikackitosin kidji makade8ag kek8an kidji 8abag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","‘Ee’ eta ikidok, konigotc ‘Ka8in.’ 8egonenigotc kodag ikido8eg kidji 8abadai8eieg e teb8eieg, madji manidokag odjimagan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jesos kiabadj ki ikido: “Kigi nodana8adok adi ka inakonigani8ag: ‘Kicpin ki potcabinik a8iag, mi kekin ke toda8adj. Kicpin ki pok8abideok a8iag, mi kekin ke toda8adj.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nin dac 8in ki8idamonom oo8e. Ka8in nak8ita8akegon a8iag ka madji todago8eg. Kicpin a8iag pasabaok, pagidin k8ekinekena acitc kidji iji pasabaok. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kicpin a8iag 8i tibakonik acitc 8i makamik kipabagi8ani, mi iji mij acitc kipizika8agani. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kicpin a8iag k8ag8edjimik kidji pimi8ida8adj omackimod pejigotibaigan inigik, nijotibaigan inigik iji8idao. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kicpin a8iag k8ag8edjimik kegoni, mi iji mij. Kicpin a8iag 8i a8iazomik kegoni, mi iji a8ii.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Kigi nodana8adok adi ka inakonigani8ag: ‘Kiga sagia8a kidjipimadizimi8a, pekic dac kiga madjenima8a ka madjenimigo8eg.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nin dac 8in ki8idamonom oo8e. Sagiikog ka madjenimigo8eg acitc aiamietamaokog igi8e ka nanekadjiigo8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kicpin iidi inakamigizieg, Kije Manido Kidadami8a 8ak8ig ka tedj odabinodjijiman kiga ijinikanigom. 8in mega opagidinan kizison kidji mokaamindjin taji e tendjin ka madjideendjin acitc ka minodeendjin, acitc opagidinan kidji kimi8anig taji e tendjin ka madji inakamigizindjin acitc ini8e ka mino inakamigizindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kicpin sagieg8a eta igi8e ka sagiigo8eg, 8egonen 8edji inendameg kidji ca8endagozieg? 8a8adj igi8e ka ma8adjia8adjin conian kitci ogiman odji mi iidi e todamo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kicpin anamika8eg8a eta kidjiki8e8ag, ka8in ii odji pejig kegon. 8a8adj igi8e ega ka teb8eta8a8adjin Kije Manidon mi iidi e todamo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kina8a dac, apanigotc k8aiakoziok, tabickotc Kidadami8a 8ak8ig ka tedj 8edjidagotc ka kitci k8aiakozidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesos kiabadj ki ikido: “Iag8amig! Apitc mino kegon todameg, ka8in ii todakegon ka iji manenani8ag, kidji gi 8abamigo8eg kakina a8iagog. Ka8in mega Kidadami8a, 8in icpimig ka tedj, kiga ca8enimigosi8a, kicpin iidi todameg.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Apitc dac ca8enimeg8a conian ka kidimagizi8adj, ka8in iidi todakegon kakina a8iagog kidji kikendamo8adj adi ka pi inakamigizieg. Mi iidi e todamo8adj ka kimodizi8adj aiamiemigi8amikag acitc mikanakag, kidji gi min8adjimagani8i8adj. Teb8e ki8idamonom, aja kakina ogi odisigona8a ka iji kackitamadizo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kina8a dac 8in, apitc ako ca8enimeg8a conian ka kidimagizi8adj, todamok iidi ega 8a8adj ma8adji ka kitci pec8abameg ki8idji8agani8a kidji kikendag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ka8in dac a8iag oga kikendasin egi ca8enimeg8a. Kije Manido dac Kidadami8a, 8in kabena ka 8abamigo8eg adi enakamigizieg, kiga ca8enimigo8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Apitc aiamieieg, ka8in inadizikegon tabickotc 8ina8a ka kimodizi8adj. Okitci min8endana8a e tajigaba8i8adj e aiamie8adj aiamiemigi8amikag acitc kikeag mikanakag, kakina a8iagon kidji gi 8abamigo8adjin. Teb8e ki8idamonom, aja kakina ogi odisigona8a ka iji kackitamadizo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kina8a dac 8in, apitc 8i aiamieieg, pidigeok kina8a eta kipakesagami8akag, kibaamok kidick8ademi8a, acitc pagosenimik Kidadami8a, iima ka tedj misa8adj ega e 8abameg. Kidadami8a dac, 8in kabena ka 8abamigo8eg adi enakamigizieg, kiga ca8enimigo8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Apitc aiamieieg, ka8in motci migodjimokegon, tabickotc ega ka teb8eta8a8adjin Kije Manidon ka todamo8adj. ‘Niga kitci ndotagonan Kije Manido kicpin kin8ej aiamieiag,’ inendamog. ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ka8in todakegon tabickotc ka todamo8adj! Kije Manido mega Kidadami8a aja okikendan 8egonen ka nodeseieg ab8amaci k8ag8edjimeg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Apitc dac aiamieieg, mi oo8e ke ikido8eg: Nidadaminan, 8ak8ig ka tean, 8egona kakina a8iag kitcit8a8endag kidijinikazo8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","8egona pijamagag kidogima8i8in. 8egona iji8ebag ooma akikag eji nda8endaman, tabickotc ka iji8ebag 8ak8ig. ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mijicinam ogajigag midjim ke odji pimadiziag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kasiamaocinam ka iji patadiag, tabickotc acitc ka iji ponenimagid8a igi8e kagi madji todago8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ka8in pagidenimi8eken kidji pakebinigo8ag, 8ack8ebinicinam dac madji manidokag. Kin mega ka tibendaman ogima8i8in, macka8izi8in, acitc icpendagozi8in, kagigekamig. Amen.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Kicpin mega ponenimeg8a 8ina8a kagi madji todago8eg, Kije Manido Kidadami8a 8ak8ig ka tedj kiga kasiamago8a kipatado8ini8a. ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kicpin dac ega ponenimeg8a 8ina8a kagi madji todago8eg, Kije Manido Kidadami8a ka8in kiga kasiamagosi8a adi kagi iji patadieg.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Mina8adj kodag kegon. Apitc pagidadjigeieg, ka8in kackendaminagozikegon, tabickotc ka kimodizi8adj ka todamo8adj. 8i paietenagozi8ag mega e pagidadjige8adj, kakina a8iagon kidji gi 8abamigo8adjin. Teb8e ki8idamonom, aja kakina ogi odisigona8a ka iji kackitamadizo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kina8a dac 8in, apitc pagidadjigeieg, kiziabiok acitc pinak8eok. ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ka8in dac a8iagog kiga kikenimigosi8ag e pagidadjigeieg. Mi eta Kidadami8a oga kikendan, iima ka tedj misa8adj ega e 8abameg. Kidadami8a dac, 8in kabena ka 8abamigo8eg adi enakamigizieg, kiga ca8enimigo8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ka8in ma8adjitamadizokegon 8anadizi8inan ooma akikag, ke 8anadjito8adjin mandjocag, acitc ke ani ag8ag8abikagin, acitc kimodi8innig ke odji pig8aamo8adjin kidick8ademabiko8an kidji kimodimigo8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tiegodj, ma8adjitamadizok 8anadizi8inan 8ak8ig ka tag8agin. Iima dac, ka8in oga kackitosina8a mandjocag kidji 8anadjito8adjin, acitc ka8in kada ani ag8ag8abikasino8an, acitc ka8in kimodi8innig oga pig8aasina8an kidick8ademabiko8an kidji kimodimigo8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ke ijinag8agin mega ki8anadizi8ini8an, mi acitc ke ijideeieg.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mi maia 8asakonendjigan epitendag8agin kickijigon kia8ikag. Kicpin min8acigin kickijigon, ka iji 8aseag kada tag8an mizi8e kia8. ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kicpin dac ega min8acigin kickijigon, mizi8e kia8 ka iji kacki tibikag kada tag8an. Kicpin dac ega 8aseag pidigamig kinikag, acitc motci kacki tibikag, mi aja maiagotc ka iji kitci kacki tibikag kidiji pimadizinan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jesos kiabadj ki ikido: “Ka8in a8iag nijin kackan ogagi anokita8asi8an. Pejig mega ini8e oga madjeniman, kodagian dac ini8e oga sagian. Kek8an pejig ini8e oga anokita8an, kodagian dac ini8e ka8in oga pabiziskenimasi8an. Ka8in midjinijin kigagi anokita8asi8a8ag Kije Manido acitc conia.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ki8idamonom dac, ka8in nigod inendakegon 8egonen ke midjieg kek8an 8egonen ke minik8eieg, kidji odji pimadizieg. Ka8in kek8an animendakegon adi ke ijio8eg kia8i8akag. Kana na8adj apitendag8asinodok pimadizi8in apitc8in midjim? Acitc kana na8adj apitendag8asinodok kia8i8a apitc8in kegojican? ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kana8abamikog pinecijag icpimig ka pabamise8adj. Ka8in kitigesi8ag, acitc ka8in oma8adjitosina8an kitiganan kagi kitige8adj, acitc ka8in tag8asini ke iji asadjigo8adj. Misa8adj dac, Kije Manido Kidadami8a 8ak8ig ka tedj, odacaman. Kana na8adj kina8a kidapitendagozisina8adok apitc8in igi pinecijag? ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","A8enen aa e tacieg keckitodj kidji pagojatodj opimadizi8in e kitci 8a8anendag inigik kiabadj ke pimadizidj?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“8egonen 8edji kitci animendamiigo8eg adi ke ijio8eg? Kana8abadamokon 8abig8anin cibeckodeg adi ejigigin. Ka8in mikimomagasino8an acitc ka8in ojitamadizomagasino8an kegojican. ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kidininom dac, misa8adj kitci ogima Sanamo (Salomon) egi aiagin ka kitci sanaganigin kegojican, ka8in iaga pejig apitci kitci min8acisini okegojiciman ka apitci min8acinigin ini 8abig8anin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kije Manido iidi omin8acitonan mijackoni, nogom cibeckodeg ka nta8iginigin, acitc ne8ad 8abanig ke madjocte8ebinigadenigin ickodekag. Kana a8acamej kekina8a kiga odji kana8abamigosi8a Kije Manido kidji 8a8epinigo8eg? Kotadji agacinoja eji teb8etameg!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Ka8in dac animendakegon kidji inendameg: ‘8egonen ke midjiag?’ kek8an: ‘8egonen ke minik8eiag?’ kek8an: ‘Adi ke ijio8ag?’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mi mega igi8e ega ka teb8eta8a8adjin Kije Manidon apanigotc ka nanada 8abadamo8adjin kakina ini kegonan. Kina8a dac 8in, Kidadami8a 8ak8ig ka tedj okikendan e nda8endamegon ini kakina kegonan kidji pimadjio8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tiegodj pinama mamidonendamok Kije Manido Odogima8i8in acitc adi ke iji k8aiakopimadizieg adi eji nda8enimigo8eg Kije Manido. Misa dac kiga minigo8a kakina ini kegonan kegi nda8endamegon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ka8in dac animendakegon adi ke iji8ebag 8abag. Kiga aiana8an 8abag kodagian kegonan kidji animendamiigo8egon. Tibise tag8an taso kajik adi ke iji animendameg, ega mamakadj kidji mamidonendameg adi ke iji8ebag 8abag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesos kiabadj ki ikido: “Ka8in onenimakegon a8iag, ka8in dac Kije Manido kiga tibakonigosi8a. ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Adi kagi iji onenimeg8a kidjipimadizimi8ag, mi iidi ke iji tibakonigo8eg Kije Manido. Adi kagi iji toda8eg8a kidjipimadizimi8ag, mi iidi Kije Manido ke todago8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","8egonen 8edji kitci kana8abadam8adj kidjiki8e e pizinidj minigonacini, kin dac 8in ka8in kipabiziskendasin mitigoc e pizinian? ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Adi dac kegi odji ikido8aban: ‘Nidjiki8e! Ack8e niga manibidon ii ka pizinian,’ pekic dac ka8in 8a8adj ki8abadasin mitigoc ka pizinian? ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kikitci kimodizinan! Pinama ki manibido8an ii mitigoc kagi pizinian, kidji gi 8abian kicpin 8i manibida8adj kidjiki8e ka pizinidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ka8in minakegon ka kitcit8a8endag8anigin kegonan animocag. Kicpin iidi todameg, kada motci k8ekigaba8i8ag kidji mag8amigo8eg. Acitc ka8in minakegon asinin ka kitci sanagizindjin kokocag. Kicpin mega iidi todameg, oga motci mamagocka8a8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“K8ag8ed8eok, kiga minigom dac. Nanada 8abadamok, kiga mikana8a dac. Papa8aamok ick8adem, kiga cenamagom dac. ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","A8enenigotc mega k8ag8ed8edj kegoni, oga odisigon. A8enenigotc nanada 8abadag kegoni, oga mikan. Acitc a8enenigotc papa8aag ick8ademini, kada cenama8agani8i. ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kicpin pejig e tacieg abinodjijan aia8adjin, asinin na oga minan kicpin pak8ejiganan k8ag8edjimigodjin odabinodjijiman? ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kek8an dac, kinebigon na oga minan kicpin kigozan k8ag8edjimigodjin? ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Misa8adj madjideeieg, kikikendana8a mino kegonan kidji mineg8a kidabinodjijimi8ag. Midac na8adj a8acamej Kidadami8a 8ak8ig ka tedj ke iji minadjin mino kegonan ini8e ka k8ag8edjimigodjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Mi iidi iji mino todaokog kodagiag a8iagog adi kina8a eji nda8endameg kidji iji mino todago8eg. Mi mega ekidomaganigobanen Mois odinakonige8in acitc niganadjimo8innig omazinaigani8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Nijin tag8anon ick8ademan. Pidigeok dac ka iji agasick8ada8eag. Ka magick8ada8eag mega ick8adem, mi iima ke iji mikameg nici8anadjio8in. Minojimon dac ii mikana kidji ijani8ag, acitc dac mane8ag igi ka iji pimaado8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ka agasick8ada8eag dac ick8adem, mi iima ke iji mikameg pimadizi8in. Sanagan kidji ani ijani8ag ii mikana, ka8in dac manesi8ag igi8e ka mikamo8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Iag8amenimikog niganadjimo8innig ka kagina8icki8adj. Mi tabickotc mantcenicag ejinagozi8adj, pekic mi maia tabickotc maiganag ka kitci kotanigozi8adj ejidee8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kiga nisida8ina8a8ag apitc kikenimeg8a adi enadizi8adj. Kakina mega pepejig minatig odji nisida8inagozi adi ejinag8anigin ominiman. Ka8in a8iag oga mikasinan minan azadikag, acitc ka8in a8iag kada ma8izosi kibisatigokag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kitci minogini8an ominiman ka minozidj minatig, acitc ka8in minogisini8an ominiman minatig ega minozidj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ka8in kada ijisesinon ega kidji min8acinigin ominiman minatig ka minozidj, acitc ega ka minozidj ka8in kadagi min8acisini8an ominiman. ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","A8enatigigotc ega min8acinigin ominiman, kicka8agani8i acitc madjocte8ebinagani8i. ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kigagi nisida8ina8a8ag dac niganadjimo8innig ka kagina8icki8adj apitc kikenimeg8a adi enadizi8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ka8in kakina a8iagog ka ijinikaniji8adj ‘Tebendjigean!’ kadagi pidigesi8ag Kije Manidon Odogima8i8inikag. Mi eta igi8e ka ijitcige8adj ka iji nda8endamindjin Nidadaman, 8ak8ig ka tendjin, kadagi pidige8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Apitc odjitciseg Kije Manido kidji tibakonigedj, mane a8iagog niga igog: ‘Tebendjigean! Tebendjigean! Nigi paba tibadjimomin Kije Manido omin8adjimo8in, ki8izon e abadjito8ag! Nigi abadjitonanan ki8izon kidji sagidjinija8agid8a madji manidog a8iagokag! Kitci mane nigi iji mamada8izimin, ki8izon e abadjito8ag!’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Midac niga inag: ‘Ka8in 8ikad kidodji kikenimisinonom. A8as 8edi ijaok, kina8a ka nta madji inakamigizieg!’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“A8enenigotc ke ndotamog8enin nidikido8inan nogom kagi ikido8an, acitc ke nosoneagin, mi maia tabickotc ka kagita8endag nabe, asinikag kagi iji migi8amikedj, ke ijinagozidj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ki kitci kimi8ani, ki kitci pajidjibi8anon sibin, acitc ki kitci nodinicinomagan ii migi8am. Ka8in dac odji ka8i8ebasasinon, asinikag mega ki iji sakakisidjigade.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“A8enenigotc dac ke ndotamog8enin nidikido8inan nogom kagi ikido8an, ega dac nosoneagin, mi maia tabickotc ega teb8e ka kagita8endag nabe, nega8ikag kagi iji migi8amikedj, ke ijinagozidj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ki kitci kimi8ani, ki kitci pajidjibi8anon sibin, acitc ki kitci nodinicinomagani omigi8am. Midac ka iji ka8asanig, acitc ki ick8a abadani.” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Apitc Jesos ka ick8a kikinoamagedj, kakina a8iagon iima ka tendjin ki kitci mamakadendamon adi ka iji kikinoamagedj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ka8in mega odji iji kikinoamagesi tabickotc Coda8inni kikinoamage8innin ka iji kikinoamagendjin odinakonige8inikag. Apitc e kikinoamagegobanen Jesos, kikenimagani8iban ako e kitci macka8izidj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesos ki pi pinazi8e pik8adinajicikag, acitc mane a8iagon ogi pi nosoneogon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Pejig a8ian e kitci omigi8apinendjin ogi pi nazikagon. Ogi pi nibak8itagon, acitc ogi igon: “Tebendjigean! Kicpin iji nda8endaman, kikackiton kidji kigeijian.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesos ki tesindjita, acitc ogi saminan, e inadjin: “Kinada8enimin kidji kigean. Kigen sa dac.” Teci8ag dac ki kige aa nabe ka inapinedj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesos dac ogi inan: “Ndotan! Ka8in a8iag 8idama8aken egi kigeinan. Anic dac nda 8abadai Coda8inni aiamie ogima adi ejinagozian nogom, acitc migi8en ii pagidinige8ini Mois kagi inakonigedj kidji todjigadenig. Mi kidji gi teb8etamo8adj kakina a8iagog egi kigean.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Apitc Jesos ka tag8icig Kaponaom (Capernaüm) odenakag, pejig cimaganici ogiman ega ka Coda8inni8indjin ogi pi nda 8abamigon, acitc ogi pagosenimigon kidji 8idoka8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ogi igon: “Tebendjigean! Nidanodagan kitci akozi. Pimicin onibe8inikag 8edi nimigi8amikag. Midjimicka acitc kitci mamida8endjige.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesos dac ogi inan: “Niga pi nda kigea.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pekic dac aa cimaganici ogima ogi nak8e8ajian: “Tebendjigean! Ka8in tibise nidapitendagozisi kidji gi pi pidigean nimigi8amikag. Anic pejig eta kegon ikidon, misa dac kidji kigedj nidanodagan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kenin mega nidaia8a pejig nikackam, acitc nidaia8ag cimaganicag e kackakanag8a. Pejig aa8e nidina kidji ijadj 8edi, mi eji ijadj. Kodag aa8e nidina kidji pijadj, mi eji pijadj. Acitc nidanodagan nidanona: ‘Ijitan oo8e!’ misa eji ijitadj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Apitc Jesos ka nodag ii, ogi kitci mamakazita8an, acitc ogi inan a8iagon kagi nosoneogodjin: “Teb8e ki8idamonom, ka8in 8ikad nidodji mika8asi pejig a8iag Israel a8iagokag epitci sogi teb8etag tabickotc aa8e nabe. ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ki8idamonom oo8e. Mane a8iagog 8abanog acitc nigabianog ka odji8adj kada pidige8ag Kije Manidon Odogima8i8inikag acitc kada iji abi8ag ka iji magocani8anig kidji 8idji 8isinima8adjin Abanaaman (Abraham), Aisikan (Isaac) acitc Tcekapan (Jacob). ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Igi8e dac ka inendagozi8apan Kije Manidon Odogima8i8inikag kidji iji tibendagozi8adj, ka iji kacki tibikanig kada iji 8ebinagani8i8ag. Iima dac, kada kitci ma8i8ag acitc kada kitci mamad8eabidecka8ag ke apitci kodagito8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Midac Jesos ogi inan ini cimaganici ogiman: “Mi iji ki8en. Kigi teb8etan e kackitodj Kije Manido kidji kigeadjin kidanodaganan, acitc mi ke toda8adjin.” Mi maiagotc ii apitc ki kigeagani8i8an odanodaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesos dac ki tag8icin Pien omigi8amikag. Iima dac ogi 8abaman Pienan ozigosini e pimakocinindjin onibe8inikag, e kitci kijizo8apinendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesos ogi samindjinan, midac ka iji poni kijizondjin. Ki pazig8i dac aa ik8e, acitc ki madjita kidji mikimodj kidji acamadjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Apitc e ani onag8icinig, Jesosikag ki iji8inagani8i8ag kitci mane a8iagog ka kigickago8adjin madji manidon. Jesos dac ogi aiamian madji manidon e sagidjinija8adjin, acitc dac ogi kigean kakina iima ka akozindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Midac iidi ka iji8ebag ii kagi mazinadenig niganadjimo8inni Isaia omazinaiganikag: “Ogi manibidonan kikodagito8inanan. Kigi kigeigonan adi ka iji akoziakoban.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Apitc e 8abamadjin mane a8iagon 8ajagam 8inikag, Jesos ogi inan okikinoamaganan: “Ijadan 8edi agamig sagaiganikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pejig Coda8inni kikinoamage8inni ogi pi nazika8an Jesosan acitc ogi inan: “Kikinoamage8inni! Kiga nosoneon adigotc ke ija8anen.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesos dac ogi inan: “8agocag o8aji8ag acitc pinecijag o8asasoni8ag, pekic dac nin, Ka pi Anicinabe8iidizodj, ka8in nidaiasin migi8am ke iji an8ecimono8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Pejig kodag a8ian, ka okikinoamaganipan, ogi igon Jesos: “Tebendjigean! Pinama pagidinicin kidji nda naata8ag nidadam o8ia8.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesos dac ogi inan: “Nosoneocin! Igi8e mi maia ka nibo8adj ka ijinagozi8adj oga kackitona8a kidji naatama8a8adjin o8ia8ini ka nibondjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesos dac tcimanikag ki pozigoban, acitc okikinoamaganan ogi 8idjiogon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kitata, ki madji kitci nodin sagaiganikag, acitc kegat ki kozabi tciman, epitci mamagaag. Jesos dac 8in taji nibagoban. ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Okikinoamaganan ogi pi kockonigon, acitc ogi igon: “Tebendjigean! Ag8acimicinam! Aja kiga nisaba8emin!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesos dac ogi inan: “8egonen 8edji kitci segizieg? Kitci agacinoja eji teb8etameg!” Jesos dac ki pazig8i, acitc ogi kitci aiamiton e kitci nodinig acitc e kitci mamagaanig. Midac ki ani kitci an8atini. ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kakina dac ka taci8adj ki kitci mamakadendamo8agoban acitc ikido8agoban: “A8enen dac aa nabe maiagotc? 8a8adj e nodinig acitc nibini onadotagon!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Apitc Jesos ka mijagagobanen Gadara akikag, k8ekagam Galilee sagaiganikag, nijin naben ki pi odji sagaamon 8ibabikiniganikag, acitc ogi pi nda nagickagon. Igi8e nabeg ogi pidigeckago8agoban madji manidon, acitc kakina a8iagon okosigo8agoban kidji nagickago8adjin iima mikanakag, osa mega kitci kotadendagozibanig igi. ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ki kitci pabibagi8ag dac: “Kije Manido Og8izisan! Adi eji nda8enimijiag? Kigi pi nda pajacteojinam na, ab8amaci kidji odjitciseg kidji tibakonige8igijigag?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tebanig iima pecodj kitci mane kokocag e nanada 8isini8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Midac igi madji manidog ogi kitci pagosenima8an Jesosan: “Kicpin 8i sagidjinijaojiag, todan kidji pidigecka8agid8a igi kokocag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesos dac ogi inan: “Ijaok.” Igi dac madji manidog ki sagaamog nabekag, acitc ogi pidigecka8a8an ini kokocan. Teci8ag dac kakina igi kokocag ki pakobig8ackoni8ag acitc ki nisaba8e8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","A8iagog dac ka kana8enima8adjin kokocan ki ojimo8ag. Odenag ki ipai8e8ag, acitc ki tibadjimo8ag kakina adi ka iji8ebanig, acitc adi ka iji8ebizindjin ini nijin naben kagi pidigeckagondjin madji manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kakina dac a8iagog iima odenakag ka tajike8apan ogi pi nda nagicka8a8an Jesosan. Apitc dac ka 8abama8adjin, ogi kitci k8ag8edjima8an kidji madjandjin iima odaki8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kegapitc dac Jesos ki pozigoban tcimanikag kidji ajo8aag sagaigani. Ogi oditan dac ododenam. ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ki pidji8idama8agani8i pejig a8ian ega e mazikandjin tesiniganikag. Apitc Jesos 8eabamadjin ini a8iagon kagi pidji8inandjin ini naben adi epitci sogi teb8etamindjin, ogi inan ini8e ega ka mazikandjin: “Nig8izis! Ka8in ana8endjigeken! Aja ki kasiigade8an kipatado8inan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nandam dac Coda8inni kikinoamage8innig ki inidi8ag: “Omanazoman Kije Manidon aa nabe!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesos okikendanagoban adi enendaminigobanen acitc ogi inan: “8egonen 8edji madji inendameg? ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Na8adj na 8edandok kidji inag: ‘Aja ki kasiigade8an kipatado8inan,’ kek8an: ‘8anickan acitc pimosen’ kidji inag? ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kinada8eniminom mega kidji kikendameg Aa8e Ka pi Anicinabe8iidizodj e kackitodj kidji kasiamagedj patado8ini ooma 8akidakamig,” ki ikido. Ogi inan dac ini8e ega ka mazikandjin: “8anickan, odapinan kitesinigan, acitc ki8en kimigi8amikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ki 8anicka dac aa nabe acitc ki ki8e. ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Apitc ka 8abadamo8adj ii, kakina a8iagog ki kitci segizi8ag. Ogi icpenima8an dac Kije Manidon egi minandjin a8ian ii macka8izi8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesos iima ki odji madja, acitc meg8adj e pimaadodj, ogi odji 8abaman pejig naben, Matio e ijinikazonigobanen. Ojibiige8igi8amikag ka iji ma8adjiagani8indjin conian e kijikaomagani8indjin kitci ogiman taji abigoban. Jesos dac ogi inan: “Nosoneocin.” Matio dac ki pazig8i acitc ogi nosone8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kegapitc Jesos ki nda 8isinigoban Mation omigi8aminikag. Kitci mane8agoban ka ma8adjia8adjin conian kitci ogiman odji acitc kodagiag madji a8iagog ka inenimagani8i8apan e pi nda 8idji 8isinima8adjin Jesosan acitc okikinoamaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Coda8innig dac ka nagadjito8agobanen inakonige8inan ogi 8abama8agoban, acitc ogi ina8agoban Jesosan okikinoamaganan: “8egonen kikikinoamage8innimi8a 8edji 8idji 8isinimadjin ini8e ka ma8adjiandjin conian kitci ogiman odji acitc ini8e ka madji inadizindjin?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesos dac ogi noda8an acitc ki ikido: “A8iagog ka mino pimadizi8adj ka8in onada8enimasi8a8an mackiki8innin, mi eta ka akozi8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","K8ag8e nisidotamok adi 8a ikidomaganig kagi ojibiigadenig Kije Manido Omazinaiganikag: ‘Kinada8eniminom kidji kije8adizieg, acitc ega mamakadj kidji pagidinigetamaojieg a8esizag.’ Ka8in mega nidodji pijasi kidji nd8e8emag8a ka kitci k8aiak8enimidizo8adj a8iagog, tiegodj nigi pija kidji nd8e8emag8a ka patadi8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nigodin Cabadis okikinoamaganan ogi nazika8a8agoban Jesosan. Ogi k8ag8edjima8an dac: “Mojag nipagidadjigemin nina8it acitc ke8ina8a ka nagadjito8adjin inakonige8inan. 8egonen dac 8edji ega pagidadjige8adj kikikinoamaganag?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesos dac ogi nak8e8ajian: “Kidinendana8a na kadagi kackendamog igi8e kagi nd8e8emagani8i8adj e niba8inani8anig, meg8adj ini naben ka niba8indjin e 8idji8a8adjin? Ketcinadj ka8in ii ijisesinon! Kegapitc dac kada odjitcise panima kidji madjadj aa ka niba8idj. Midac pidjinag ke pagidadjige8adj ka nd8e8emagani8i8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ka8in a8iag odabadjitosin ocki kegojicini kidji pag8aag kete kegojicini. Ii mega ocki kegojic kada odji manise kete kegojicikag. Midac kiabadj kada ani magi tadocka. ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Acitc dac ka8in kete nibi8ajikag ka pack8egino8agin iji siginigadesinon ocki cominabo. Kicpin mega iidi todjigadeg, mi ke iji pakodjisegin ini. Motcikag dac kada inajiga8in ii cominabo, acitc mi eck8a abadagin ini nibi8ajan. Tiegodj, ocki pack8egino nibi8ajikag iji siginigade ocki cominabo. Ka8in dac nigodisinon cominabo acitc kin8ej kada min8acinon pack8egino nibi8ajan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Meg8adj Jesos e taji ikidodj oo8eni, pejig Coda8inni ka niganizidj ki pi tag8icin, acitc ogi nibak8ita8an Jesosan. Ki ikido dac aa nabe: “Nidanis nogom maia odji nibo. Pijan dac kidji pi nda taginadj, midac kada koki pimadizi.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesos ki pazig8i kigi okikinoamaganan, ogi 8idji8an dac. ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Pejig dac ik8e, aja midatcin acitc nijopibon inigik o8anitonagoban omisk8i, odakanag ogi pi odji nazika8an Jesosan, acitc ogi taginan 8ajagameig okonasini. ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Inendamogoban mega: “Kicpin iaga taginam8ag Jesos okonas, mi ke iji kigeian.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesos ki k8ekigaba8i, acitc ogi odji 8abaman ini ik8e8an. Ogi inan dac: “Nidanis! Ka8in ana8endjigeken! Kiteb8etamo8in kigi kigeigon.” Teci8ag dac ki kige aa ik8e. ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesos dac ki odji tag8icin 8edi Coda8inni ka niganizindjin omigi8aminikag. Ogi 8abaman nodag8atcige8innin e ick8atandjin kidji nodag8atcigendjin meg8adj e nig8aakani8anig, acitc a8iagon e kitci mad8etondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ki ikido dac: “Kakina ka tacieg, sagaamok ooma! Ka8in mega nibosi aa ik8eses, motci niba eta.” Kakina dac ogi maskita8a8an Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Apitc ka ick8a sagidjinija8adjin kakina a8iagon, Jesos ki pidige ik8esesan opakesagamini. Ogi na8adjindjibinan acitc ki pazig8i8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mizi8e dac iima akikag ki nodagani8an oo kagi iji8ebanig. ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesos dac ki odji madja iima migi8amikag. Meg8adj dac e ani pimosedj, nijin a8iagon ega ka 8abindjin ogi madji nosoneogon, e pabibagimigodjin: “Kin ogima David odanike ojisan! Kidimagenimicinam!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Apitc Jesos ka oditag migi8amikag, ogi pi nazikagon ini8e ega ka 8abindjin. Jesos dac ogi k8ag8edjiman: “Kiteb8etana8a na e kackito8an kidji kigeinagok?” “Ee, Tebendjigean! Niteb8etananan!” ki ikido8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jesos dac ogi tagickijig8enan, acitc ki ikido: “Kiga iji8ebizim adi ka iji teb8etameg.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ki odji 8abi8agoban dac. Jesos dac ogi kitci sogi aiamian: “Ndotaocik 8e8enda! Ka8in a8iag 8idama8akegon adi ka ijiseieg.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Misa8adj dac, apitc ka ick8a sagaamo8adj, ogi paba mikoma8an Jesosan mizi8e iima akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Meg8adj e ani sagaamo8apan igi nabeg ega ka 8abi8apan, Jesos ki pidama8agani8i pejig a8ian ega ka nta8endjin, e kigickagondjin madji manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Apitc dac Jesos ka ick8a sagidjinija8adjin madji manidon, aa nabe okackitonagoban aja kidji anim8edj. Kakina dac a8iagog iima ka te8agobanen ki kitci mamakadendamog, acitc ki ikido8ag: “Ka8in 8ikad ooma Israel akikag kidodji 8abadasinanan kegon e apitci mamakadendag8ag!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Anic dac Coda8innig ka nagadjito8agobanen inakonige8inan ki ikido8ag: “Aa8e ka kackakanadjin madji manidon, mi aa8e ka minadjin Jesosan macka8izi8ini kidji gi sagidjinija8andjin madji manidon.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesos paba ijagoban kakina odenakag acitc odenajicikag iima akikag. Paba kikinoamagegoban Coda8inni aiamiemigi8amikag, acitc paba kagik8egoban min8adjimo8ini, ka odji kikendjigadenig Kije Manidon Odogima8i8ini. Okigeagoban kakina ka akozindjin adigotc ka inapinendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kitci mane a8iagon ogi 8abaman egi pi nda nagickagodjin, acitc ogi kitci kidimageniman. Kitci aiekozi8agoban mega igi a8iagog acitc 8i ani ana8endjigebanig, tabickotc mantcenicag ega ka tendjin a8ian kidji kana8enimigo8adjin ijinagozi8agoban. ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jesos dac ogi inan okikinoamaganan: “Mi maia kitiganan ejinagozi8adj igi a8iagog. Kitci manedon kitiganan ke ma8adjitcigadegin, midac eta ka8in tibisesi8ag mikimo8innig. ");
INSERT INTO alqALGNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pagosenimik dac Kije Manido, 8in ka tibendagin kitiganan, kidji ijinija8adjin mane kodagian mikimo8innin kidji ma8adjitondjin okitiganan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesos dac ogi nd8e8eman ka midatcin acitc nijindjin okikinoamaganan, acitc ogi minan macka8izi8ini kidji gi sagidjinija8andjin madji manidon, acitc kidji gi kigeandjin ka akozindjin adigotc enapinendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","8adan ono8e o8izoni8an ka midatcin acitc nijindjin Jesos Odanodaganan: Simo, Pien ka ijinikanagani8idj, acitc Andre, 8in Simo o8idjiki8en; Jak (Jacques) acitc John, 8ina8a midjinijin Zebedee og8izisan; ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip (Philippe), acitc Batelemi (Barthélemy); Tomas (Thomas) acitc Matio (Matthieu), 8in ka ma8adjiadjin conian kitci ogiman odji; Jak, 8in Alpi (Alphée) og8izisan, acitc Tadi (Thaddée); ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simo, 8in ka acidagimagani8igobanen taji ka iji ma8asag8akonidindjin ega ka nda8endaminigobanen kidji tibenimigo8adjin ogiman Rom ka odjindjin, acitc Judas Iskaniot (Iscariote), 8in nage ka mamijimadjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesos ogi madjinija8an ini ka midatcin acitc nijindjin naben kidji a8i paba kagik8endjin. Ogi inan dac ab8amaci madjandjin: “Ka8in ijakegon iima akin adi eji tajike8adj ega ka Coda8inni8i8adj, acitc ka8in pidigekegon odenan Samani (Samarie) akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Tiegodj, ijaok ka iji tajike8adj Israel a8iagog, tabickotc mantcenicag ka 8anicino8adj ka ijinagozi8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Apitc dac paba ijaieg, mi oo8e ke paba tibadjimo8eg: ‘Aja kegat kada tag8icinomagani Kije Manido Odogima8i8in.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kigeikog ka akozi8adj, abidjibaikog ka nibo8adj, kigeikog ka omigi8apine8adj, acitc sagidjinijaokog madji manidog. Ka8in kegon odji inagidag8asinon ii macka8izi8in kagi minigo8eg kidji todameg ii, kiga kitci abadjitona8a dac, ega mamakadj kidji kijikago8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ka8in conia madji8inakegon adigotc enagidagozidj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ka8in madji8idokegon mackimod e pabamodeieg, ka8in nijin pabagi8anan, ka8in kek8an makizinan konigotc sakaon. Mikimo8inni mega inendagozi kidji minagani8idj adi ke odji pimadjiodj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Apitc tag8icinieg pejig odenakag kek8an odenajicikag, nanada 8abamik a8iag ke 8i kana8enimigo8eg omigi8amikag, acitc mi iima tajikeok, pinici kidji odjitciseg kidji odji madjaieg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Apitc pidigeieg a8iag omigi8amikag, ikidok oo8e: ‘Kije Manido kiga minigo8a pekadendamo8ini.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kicpin igi8e ka tajike8adj iima migi8amikag 8i kana8enimigo8eg, teb8e oga odisigona8a pekadendamo8ini. Kicpin dac ega nda8enimigo8eg, kiga pagosenima8a Kije Manido ega kidji minadjin pekadendamo8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kicpin dac ega tedj a8iag iima migi8amikag kek8an odenakag e nda8enimigo8eg acitc e 8i ndotago8eg, mi iji madjaok acitc papa8izidecimonok e minigonaci8akizineieg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Teb8e ki8idamonom, apitc odjitcisenig Kije Manido kidji tibakonigedj, na8adj a8acamej oga sogi pajacte8an ini8e a8iagon iima odenag ka tajikendjin, apitc8in ini8e madji a8iagon 8eckadj ka tajikenipanin Sodom odenag acitc Gomora (Gomorrhe) odenag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ndotaocik! Mi tabickotc mantcenicag ka ijinija8agani8i8adj nena8idj maiganikag e ijinagozieg e madjinijaonagok. Iag8amig dac, tabickotc ka iji kitci iag8ami8adj kinebigog, acitc k8aiak8adiziok, tabickotc ka inadizi8adj omimig ka 8abizi8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Iag8amig! A8iagog mega kiga takonigo8ag acitc nigan tibakonige8innikag kiga iji8inigo8ag. Kiga papajacteogo8ag odaiamiemigi8ami8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","E nosoneojieg mega ke odji takonigo8eg acitc ke odji iji8inigo8eg nigan ka niganizi8adj acitc ogimakag kidji tibakonigo8eg. Ii dac apitc, kiga 8idama8a8ag min8adjimo8ini, 8ina8a igi8e acitc ega ka Coda8inni8i8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Apitc dac iji8inigo8eg nigan tibakonige8innikag, ka8in nigod inendakegon adi ke ikido8eg acitc ke todameg. Kiga 8idamagom mega adi ke ikido8eg ii apitc. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ka8in mega kina8akag kada odjisesino8an kidikido8ini8an, Kidadami8a dac Omino Manidoman kiga 8idamago8a adi ke ikido8eg.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Nandam a8iagog oga mamijima8an o8idjiki8e8an kidji nisimagani8indjin, acitc mi nandam nabeg pejig8an ke toda8a8adjin odabinodjijimi8an kidji gi nisimagani8indjin. Nandam abinodjijag oga ana8eta8a8an onigiigo8an, acitc oga pagidenima8an kidji nisimagani8indjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","E nosoneojieg, kakina a8iagog kiga odji madjenimigo8ag. Aa8e dac ega ke ana8endjigedj, ka sogigaba8idj dac, mi aa8e ke ag8acimagani8idj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Apitc nanekadjiigo8eg pejig odenakag, kodag odenag ipai8eg. Teb8e ki8idamonom, ka8in 8a8adj maci kiga ick8a paba tibadjimosim min8adjimo8in kakina odenan Israel akikag, ab8amaci tag8icig Aa8e Ka pi Anicinabe8iidizodj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Aa ka kikinoamazodj ka8in na8adj apitendagozisi apitc8in ini8e ka kikinoamagodjin, acitc anokitage8inni ka8in na8adj apitendagozisi apitc8in okackaman. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Oda kitci inendan kikinoamagan toda8agani8idj tabickotc ka todaomagani8indjin okikinoamage8inniman, acitc anokitage8inni oda kitci inendan toda8agani8idj tabickotc ka todaomagani8indjin okackaman. Tabickotc ka niganendagozidj pejigodenakag nidapitendagozinan. Nigi manazomigo e ijinikanigo8an: ‘Beelzebul, ka niganizidj madji manidokag.’ Na8adj dac a8acamej kiga manazomigo8a, kidji madji ijinikanigo8eg, kina8a ninikag ka iji tibendagozieg.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ka8in dac kosakegonig a8iagog. Kakina kegon ka kadjigadeg kada nag8an, acitc kakina kegon ega maci ka kikendjigadeg kada kikendag8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kakina kegon ka 8idamonagok ka iji kacki tibikag, koki 8idamageok ka iji 8aseag. Kakina kegon ka kimodji 8idamago8eg, mi iji pabibagiok e 8idamageieg kakina a8iagokag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ka8in kosakegonig a8iagog ka kackito8adj kidji nisigo8eg. Okackitona8a kidji nici8anadjito8adj 8ia8ini, ka8in dac 8in okackitosina8a kidji nici8anadjia8adjin a8ian odjitcagocini. Tiegodj, kosik Kije Manido, 8in ka kackitodj kitci ickodekag kidji nici8anadjitodj 8ia8ini acitc dac kidji nici8anadjiadjin a8ian odjitcagocini. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kije Manido kakina kegoni onagadjiton, 8a8adj kegoni ka kitci agacinojanig. Anic dac kina8a ma8adji kidapitenimigo8a. 8adan oo8e. Pejig somanike eta kidinada8emin nijin k8ig8icig, midac 8in Kije Manido Kidadaminan eji kikendag apitc nibondjin pejig ini k8ig8icin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Okikendan 8a8adj adi e tasinigin ki8ina8anisisi8an kictig8ani8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ka8in sa dac kotadjikegon, na8adj mega kina8a kikitci apitenimigo8a apitc8in kitci mane k8ig8icig!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“A8enenigotc ega ke cag8enimog8en kidji 8idama8adjin kodagian a8iagon ninikag e iji tibendagozidj, kenin acitc niga 8idama8a Nidadam 8ak8ig ka tedj e tibenimag 8aa8e. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","A8enenigotc dac ke inag8en a8iagon ega e kikenimijidj, kenin acitc niga ina Nidadam 8ak8ig ka tedj ega e kikenimag 8aa8e.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ka8in inendakegon e pido8an pekadendamo8in ooma akig. Ka8in nidodji pijasi kidji pido8an pekadendamo8in, tiegodj nigi pi nda nenicikebinag a8iagog, acitc kidji migadi8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nigi pija kidji ijisenig nabe kidji ana8eta8adjin odadaman, ik8e kidji ana8eta8adjin odjodjoman, acitc naaganik8e kidji ana8eta8adjin ozigosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kakina dac pepejig a8iag oga madjenimigon ini8e a8iagon ka 8idji tajikemadjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Aa8e na8adj a8acamej ka kitci sagiadjin odadaman kek8an odjodjoman apitc8in nin, ka8in inendagozisi ninikag kidji iji tibendagozidj. Acitc aa8e na8adj a8acamej ka kitci sagiadjin og8izisan kek8an odanisan apitc8in nin, ka8in inendagozisi ninikag kidji iji tibendagozidj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Aa8e ega pimi8inadjin otcibaiatigoman acitc ega ijadj adigotc ke ija8ag, ka8in inendagozisi ninikag kidji iji tibendagozidj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Aa8e ka kitci manadjitodj opimadizi8in kada nibo, aa8e dac pekic ke nibog8en nin odji, kada koki pimadizi.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Aa8e ka mino todago8eg, kenin nimino todag. Acitc aa8e mino todaojidj, omino toda8an ke8in ini8e kagi pidjinijaojindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Aa8e ka mino toda8adjin Kije Manidon pejig oniganadjimo8innimini, osa mega Kije Manidokag iji tibendagozi8an e niganadjimo8inni8indjin, ka iji ca8enimagani8idj niganadjimo8inni kada iji ca8endagozi ke8in. Aa8e ka mino toda8adjin a8ian e k8aiakozindjin, osa mega k8aiakozi8an, kada ca8endagozi tabickotc a8ian ka k8aiakozindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Teb8e ki8idamonom, aa8e ka minadjin 8a8adj pejigonagan e min8agaminig anisibini ini8e ega odji pejig ka apitendagozindjin nikikinoamaganan, osa mega nin ini nikikinoamaganan, ketcinadj kada ca8enimagani8i.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Apitc Jesos ka ick8a 8idama8adjin ka midatcin acitc nijindjin okikinoamaganan adi ke todamindjin, iima ki odji madja kidji paba kikinoamagedj acitc kidji paba kagik8edj odenakag iima Galilee akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kibaodimigi8amikag tegoban Cabadis ii apitc, acitc ki nodagegoban peba ijitandjin Jesosan. Ogi ijinija8an dac nandam okikinoamaganan ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kidji nda k8ag8edjimandjin Jesosan: “Kin na aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin? Kek8an kodag panima niga pianan?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesos ogi nak8e8ajian: “Nda tatibadjimotaok Cabadis adi ka iji nodameg acitc ka iji 8abadameg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ega ka 8abi8apan aja 8abi8ag, ega ka mazika8apan aja pimose8ag, ka omigi8apine8apan aja kige8ag, ega ka ozite8apan aja ozite8ag, ka nibo8apan koki pimadizi8ag, acitc ka kidimagizi8adj aja 8idama8agani8i8ag Kije Manidon omin8adjimo8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ca8endagozi aa a8iag ega ke ana8enimijidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Apitc ka ick8a madjandjin Cabadisan okikinoamaganan, Jesos ogi mikoman Cabadisan a8iagokag e ikidodj: “Apitc ka ijaieg pig8adakamigokag, a8enen kagi a8i nda 8abameg? Kidinendana8aban na kidji 8abameg a8iag e kitci cagozidj, tabickotc nibic ka kitci mamadji8ebasag e nodinig e ijinagozidj? Ka8in sa iidi! ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","A8enen dac kagi a8i nda 8abameg? Kigi a8i nda 8abama8a na a8iag e kitci minokonaedj? Ka kitci minokonae8adj, kitci ogiman omigi8aminikag iji tajike8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","A8enen dac kagi a8i nda 8abameg? Niganadjimo8inni na kagi a8i nda 8abameg? Ee! Ki8idamonom, Cabadis na8adj apitendagozi apitc8in niganadjimo8inni. ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Cabadis dac 8in, mi 8aa Kije Manidon Omazinaiganikag ka mikomagani8idj, oo8e e mazinadenig: ‘Kije Manido ikido: Niniganinija8a aa8e ke tibadjimodj nidikido8ini, kidji nigani ojitamaok kimikanani adi ke ani ijaian.’ Mi mezinadenig. ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Teb8e ki8idamonom, ka8in a8iag tesi ooma akikag na8adj e kitci apitendagozidj apitc8in Cabadis. Pekic dac aa8e ma8adji ka tabasendagozidj Kije Manidon Odogima8i8inikag, na8adj apitendagozi apitc8in Cabadis. ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Apitc ka odji madji kagik8edj Cabadis pinici nogom, ki kitci sogapineigadeni Kije Manido Odogima8i8in, acitc ka kitci sogendagozi8adj a8iagog ki k8ag8e makazo8ag ii Ogima8i8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ab8amaci tag8icigiban Cabadis, kakina niganadjimo8innig omazinaigani8akag acitc Mois odinakonige8inikag, ogi mikodana8a Kije Manidon Odogima8i8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kicpin dac 8i teb8etaojieg, mi 8aa Cabadis ka mikomigodjin niganadjimo8innin apitc ka ikidonigobanen kidji koki tag8icinindjin Elin ooma akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kakina kina8a keckito8eg kidji nisidotameg, 8e8enda ndotamok.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“A8enen kegi iji tibaageiaban a8iagog nogom ka pimadizi8adj ejinagozi8adj? Mi maia tabickotc abinodjijag ka odamino8adj ejinagozi8adj, pepakan ka taji okogaba8i8adj ka iji ada8ani8anig, acitc ka pabibagimidi8adj oo8eni: ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nigi nodag8atcigemin, ka8in dac kidodji nimisim. Mina8adj dac nibo8ini nigamo8inan nigi nigamomin, kiabadj dac ka8in kidodji ma8isim.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Midac pejig8an, apitc ka tag8icig Cabadis e pi nda kagik8edj, ka8in ododji am8asi8agoban pak8ejiganan acitc ka8in odji minik8esigoban cominaboni. Ki ikidonani8anogoban dac e kigickagogobanen madji manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nin dac, Ka pi Anicinabe8iidizodj, apitc ka tag8icinian kidji pi nda kagik8eian, ka8in nidodji mana 8isinisi acitc ka8in nidodji mana minik8esi. Midac kiabadj ka iji ikidonani8ag: ‘Kana8abamik aa nabe! Mi eta kidji 8isinidj acitc kidji minik8edj cominaboni eji mika8idj. Omino 8idji8an ini8e ka ma8adjiandjin conian kitci ogiman odji, acitc ini8e ka madji inadizindjin,’ ikidonani8an. Eji pimadizi8adj dac a8iagog, mi 8edji nagozi8adj ka apitci odisigo8ag8en Kije Manidon okagita8endamo8ini.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Igi8e a8iagog ka tajike8apan iima odenan taji kagi iji kitci mamada8izindjin Jesosan, ka8in 8i an8endizosi8agoban acitc ka8in 8i poni patadisi8agoban. Jesos dac ogi kaganonan ini a8iagon, e ikidodj: ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kiga kitci madji iji8ebizim, kina8a ka tajikeieg Korazin (Chorazin) odenag acitc kina8a ka tajikeieg Betseda (Bethsaïda) odenag! Kitci mane mega nigi iji mamada8izinan kidodenami8akag, ka8in dac misa8adj ki8i odji an8endizosim. Kicpin ini mamada8izi8inan ki todjigadegibanin 8eckadj 8edi Tir (Tyr) acitc Sidon odenakag, igi madji a8iagog iima ka tajike8apan aja 8eckadj kadagi makade8eginoobanig kidji 8abadai8e8adj e an8endizo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Teb8e dac ki8idamonom, apitc odjitcisenig Kije Manido kidji tibakonigedj, na8adj a8acamej kiga sogi pajacteogom apitc8in igi8e a8iagog 8eckadj Tir acitc Sidon ka tajike8apan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kina8a dac Kaponaom (Capernaüm) odenag ka tajikeieg, ‘Nikitci apitendagozimin’ kidinendana8a na? Tiegodj dac Kije Manido kiga kitci sogi pajacteogo8a. Kitci mane mega nigi iji mamada8izinan kidodenami8akag, ka8in dac misa8adj kigi odji an8endizosim. Kicpin ki todjigadegibanin ini mamada8izi8inan Sodom odenag, kadagi an8endizobanig igi8e a8iagog, acitc kiabadj nogom kadagi pimadjiomaganiban ododenami8a. ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Teb8e dac ki8idamonom, apitc odjitcisenig Kije Manido kidji tibakonigedj, na8adj a8acamej kiga sogi pajacteogom apitc8in igi8e a8iagog 8eckadj Sodom odenag ka tajike8apan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ii dac apitc Jesos ki ikido: “Nidadam, kin ka Tibendamanin 8ak8ig acitc aki, mig8etc kidinin, osa mega kigi kikendamonag abinodjijag kegonan ka kadama8ad8a a8iagog ka kagita8endamo8adj acitc ka omidonendjigani8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nidadam! Teb8e mi ii8e kin kagi iji nda8endaman kidji ijinag8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Kakina macka8izi8ini Nidadam nigi minig. Ka8in a8iag nikikenimigosi, midac eta Nidadam nikikenimig. Ka8in a8iag okikenimasin Nidadaman, midac eta nin Og8izisan nikikenima, acitc igi8e ka nda8enimag8a kidji kikenima8adjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Pi nazikaocik, kina8a kakina ka kitci aiekozieg acitc ka kitci k8azigo8aneieg. Kiga mininom dac kidji an8ebieg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Pagidenimidizok kidji anokitaojieg, acitc kagikina8abamicik. Nikitci kije8adizinan mega, acitc nikitci nokidee. Midac iidi ke odji mikameg an8ebi8in kina8a tibina8e odji. ");
INSERT INTO alqALGNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kitci 8edan mega ii ka inanoninagok, acitc nagan ii ka mininagok kidji pimi8ido8eg.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nigodin meg8adj e Coda8inni aiamie kijiganig, Jesos acitc okikinoamaganan opimi cabocta8eckana8agoban ka iji kitigani8anig anominan. Kitci 8i 8isinibanin ini okikinoamaganan. Ki madjita8agoban dac kidji ma8adjia8adjin nandam anominan acitc ogi am8a8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nandam Coda8innig ka nagadjito8agobanen inakonige8inan ogi 8abamigo8an e todamo8adj ii, acitc ogi ina8an Jesosan: “Kijigabamik! Kikikinoamaganag oma8adjia8an anominan meg8adj e aiamie kijiganig! Ikidomaganon kidinakonige8inanan ega e inendagozi8adj kidji todamo8adj iidi.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesos dac ogi nak8e8ajian: “Kana 8ikad kidodji nabo8adasina8a Kije Manido Omazinaiganikag adi ka todamogobanen ogima David? Nigodin ki mamida8askade8agoban 8in acitc o8idji8aganan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","David dac ki pidigegoban Kije Manidon odaiamiemigi8aminikag. 8in dac acitc o8idji8aganan ogi am8a8agoban pak8ejiganan Kije Manidon kagi ca8enimagani8indjin. Kidinakonige8inanan ikidomaganon ega e inendagozi8adj kidji am8a8adjin ini pak8ejiganan, inazinade Coda8inni aiamie ogimag eta kidji am8a8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mina8adj dac, kana 8ikad kidodji nabo8adasina8a kidinakonige8inakag adi ako e todamo8adj aiamie ogimag? Maiagotc kitci mikimo8ag aiamiemigi8amikag e aiamie kijiganig, ka8in dac onosoneasina8a kagi inakonigani8anig e Coda8inni aiamie kijiganig. Misa8adj dac, ka8in tibakonagani8isi8ag ii odji. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ki8idamonom, tag8an kegon ooma na8adj e kitci apitendag8ag apitc8in Coda8inni kitci aiamiemigi8am! ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mazinadeni mega Kije Manido Omazinaiganikag: ‘Kinada8eniminom kidji kije8adizieg acitc ega mamakadj kidji pagidinigetamaojieg a8esizag.’ Ka8in kidagi inactaonasi8a8ag igi8e ega kagi madji todamo8adj, kicpin maiagotc nisidotamegoban adi 8a ikidomagag oo8e. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nin mega, Ka pi Anicinabe8iidizodj, nitibendan ii ka Coda8inni aiamie kijigag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesos dac ki odji madja iima, acitc Coda8inni aiamiemigi8amikag ki ija. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Pejig nabe iima tegoban ega e mazikanig onidji. Nandam dac a8iagog iima ka te8agobanen ogi k8ag8edjima8an Jesosan: “Ikidomaganon na kidinakonige8inanan kidji kigeagani8idj a8iag e aiamie kijiganig?” Ok8ag8e nanada8i ina8abanin mega kidji k8ag8e katcidina8adjin ke iji nak8e8ajii8endjin, kidji gi inactaona8adjin egi panaagendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesos dac ogi nak8e8ajian: “Kicpin pejig e tacieg aia8adjin e motci pejigondjin mantcenican, acitc podazig8egodjinindjin ka iji kitci pagonekamiganig e aiamie kijiganig, kana oga a8i 8ik8adjiasi8an? ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Teb8e na8adj kitci apitendagozi pejig a8iag apitc8in pejig mantcenic! Ikidomaganon sa dac kidinakonige8inanan kidji mino toda8agani8idj a8iag e Coda8inni aiamie kijiganig.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jesos dac ogi inan ini naben: “Pi ijindjitan.” Midac ka todag, acitc teci8ag k8aiak ki koki mikimomagani onidji, tabickotc kodag ii8eni. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Igi dac Coda8innig ka nagadjito8agobanen inakonige8inan ki odji sagaamog aiamiemigi8amikag, acitc ki nda ma8adjiidi8ag kidji nanada8i kikendamo8adj adi ke todamo8apan kidji gi nisa8apanin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Apitc Jesos ka nodagedj e 8i nisigodjin, ki madja, acitc mane a8iagon ogi nosoneogon. Jesos dac ogi kigean kakina ka akozindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pekic dac ogi kitci sogineman e 8idama8adjin ega kidji tibadjimondjin a8enen 8in. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Midac iidi ka ani iji8ebanig adi kagi ikidogobanen niganadjimo8inni Isaia: ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Mi ka ikidodj Kije Manido: 8adan 8aa nidanodagan, kagi onabamag. Nikitci sagia acitc nikitci min8endamiig. Nimino Manidoman niga mina kidji kigickagodjin, acitc oga paba tibadjimota8an kakina a8iagon kidji pi nda ag8acimimagin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ka8in a8ian oga k8ag8e cagozomasin, acitc ka8in kada pabibagisi. Ka8in kada kiji8esi ka iji manenani8anig kidji gi noda8agani8idj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kada kitci nokadizi apitc paba tedj ka iji cagozindjin a8iagon, tabickotc ka kagan8ackosi8agagin mijackon ka ani piskiginigin ka ijinagozindjin. Oga 8idjian ini8e ka cagozindjin oteb8etamo8inikag, tabickotc 8asakonendjigan ana8iz ka 8asakoneg ka ijinagozindjin. Oga todan ii pinici kidji ndotaomagani8indjin Kije Manidon, kakina a8iagon kidji gi odji ag8acimagani8indjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kakina dac ka inakanezi8adj a8iagog kada iji apacenimo8ag 8inikag.” Mi ii8eni kagi ojibiag niganadjimo8inni Isaia omazinaiganikag, Jesosan e mikomadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Pejig naben Jesos ki pidji8idama8agani8i. Ka8in 8abisigoban acitc ka8in nta8esigoban, osa mega okigickagobanin madji manidon. Jesos dac ogi kigean ini naben, kidji gi anim8endjin acitc kidji gi 8abindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kakina dac a8iagog iima ka te8agobanen ki kitci mamakadendamobanig, acitc ki ikido8ag: “Mi ini ne8ad Kije Manido kagi ikidopan kidji pidjinija8adjin, 8aa Davidikag ke pi odaiagizindjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Apitc dac Coda8innig ka nagadjito8agobanen inakonige8inan ka nodage8agobanen ii, ki ikido8ag: “Mi aa madji manido ogima, ‘Beelzebul’ ka ijinikazodj, kagi minadjin Jesosan macka8izi8ini kidji gi sagidjinija8andjin madji manidon a8iagokag!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesos dac okikenimabanin adi enendaminigobanen. Midac ogi inan: “Kicpin a8iagog pejig ogima8i8inikag ka tajike8adj iji ma8asago migadi8adj pepejig e taci8adj, kada ani nici8anadjiomagan ii ogima8i8in. Kicpin a8iagog pejig odenakag ka tajike8adj iji ma8asago migadi8adj, kada ani nici8anadjiomagan ii odena. Acitc kicpin a8iagog ka pejigode8izi8adj migadi8adj, ka8in kadagi pimadjiomagasinon ii pejigodena. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kicpin dac kitci madji manido sagidjinija8adjin kodagian madji manidon ka tibenimadjin, kitci madji manido 8inigotc tibina8e migandizo! Adi dac ke odji pimadjiomaganig odogima8i8in? ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kitci madji manido Beelzebul niminig omacka8izi8in kidji gi sagidjinija8ag8a madji manidog kidikidom. Pekic dac nandam igi8e ka nosoneogo8eg, ke8ina8a okackitona8a kidji sagidjinija8a8adjin madji manidon. Adi dac 8edinamo8adj 8ina8a omacka8izi8ini8a? Ka nosoneogo8eg 8abadai8e8ag ega e teb8eieg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ka8in kitci madji manido ogima Beelzebul ka minijidj macka8izi8ini kidji sagidjinija8ag8a madji manidog, 8in Kije Manido Omino Manidoman ka minijidj. Ki8abadaigona8a dac Kije Manido Odogima8i8in aja egi pi odisigo8eg.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ka8in a8iagigotc kadagi pidigesi ka macka8izindjin a8iagon omigi8aminikag kidji gi nda kimodimadjin odaimini kicpin ega pinama mag8apinadjin ini ka macka8izindjin naben. Apitc ick8a mag8apinadjin, oga kackiton kidji kimodimadjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Kicpin a8iag ega 8idji mikimomijidj, onagabidon nimikimo8ini. Kicpin a8iag ega 8idjiijidj kidji ma8adjiimagin a8iagon, tiegodj odobenija8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Midac 8edji 8idamonagok, kadagi kasiama8agani8i8ag a8iagog kakina opatado8ini8an, acitc kakina kagi iji manad8e8adj acitc ka iji madjigij8e8adj kadagi kasiama8agani8i8ag. Anic dac a8enenigotc ke maskenimag8enin Mino Manidon, ka8in kada kasiama8agani8isi. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","A8enenigotc ke madji mikomijig8en nin, Ka pi Anicinabe8iidizodj, kada kasiama8agani8i. Anic dac a8enenigotc ke madji mikomag8enin Mino Manidon, ka8in 8ikad kada kasiama8agani8isi, ka8in nogom acitc ka8in kek8an pidjinag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Kicpin minatig minozidj, kada minogini8an ominiman. Kicpin dac ega minozidj minatig, ka8in kada minogisini8an ominiman. Kakina mega pepejig minatig odji nisida8inagozi adi ejinag8anigin ominiman. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kina8a madji a8iagog, tabickotc ka pitcibo8inezi8adj kinebigog kidijinagozim! Adi dac kegi odji mikodamegon mino kegonan, e kitci madjideeieg? Ejigij8edj mega a8iag, odji nag8ani adi ejideedj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mino a8iag mino kegonan odjimagani8an odeikag, osa mega minodee. Madji a8iag dac madji kegonan odjimagani8an odeikag, madjidee mega.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Teb8e ki8idamonom, apitc tibakonige8igijigag, kakina pepejig a8iag panima kada tibadjimo kakina ka pi anica aikidodj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kije Manido oga abadjitonan kidikido8ini8an apitc tibakonigo8eg kakina pepejig e tacieg. E abadjitodjin dac kidikido8ini8an, kiga odji 8idamagom kicpin ka apitci k8aiak8adizi8eg8en kek8an ka apitci panaage8eg8en.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nandam Coda8innig ka nagadjito8agobanen inakonige8inan acitc nandam Coda8inni kikinoamage8innig ogi ina8an Jesosan: “Kikinoamage8inni! Mamada8izin, kidji 8abadai8ean teb8e kimacka8izi8in Kije Manidokag epitci odjimaganog8en.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesos dac ogi nak8e8ajian: “A8iagog nogom ka te8adj kitci madji a8iago8i8ag acitc ka8in o8i teb8eta8asi8a8an Kije Manidon! Nik8ag8edjimigog kidji mamada8izi8ag kidji nda motci kikendamo8adj epitci teb8emaganig8en ii egi pidjinijaojindjin Kije Manidon. Ka8in sa dac niga mamada8izi8asin. Aja mega okikendana8a 8eckadj adi kagi iji8ebizindjin niganadjimo8innin Jonasan. Midac iima ke iji 8abadamo8adj mamada8izi8ini ka k8ag8ed8e8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nisokajik acitc nisotibik Jonas ki tajikegoban ka kitci mididondjin kigozan omisadanikag. Midac pejig8an nin, Ka pi Anicinabe8iidizodj, nisokajik acitc nisotibik niga tajike anamakamig. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","8eckadj a8iagog Ninip (Ninive) ka tajike8agobanen ki an8endizo8ag apitc ka noda8a8adjin Jonasan e kagik8endjin. Aja dac te nogom ooma pejig a8iag na8adj e kitci apitendagozidj apitc8in Jonas. Apitc dac Kije Manido tibakonadjin a8iagon, Ninip ka tajike8agobanen a8iagog kada pazig8i8ag kidji inactaona8adjin ini8e a8iagon nogom ka tendjin ega ka 8i an8endizondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Acitc dac aa 8eckadj kitci ogimak8e, ca8anog ka odjipan, kitci 8asag ki odose e pi nda ndotagin Sanamon (Salomon) odikido8inan, e kitci kagita8endamindjin. Aja dac te nogom ooma pejig a8iag na8adj e kitci apitendagozidj apitc8in Sanamo. Apitc dac Kije Manido tibakonadjin a8iagon, aa ogimak8e kada pazig8i kidji inactaonadjin ini a8iagon nogom ka tendjin ega ka 8i ndotamindjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Apitc madji manido ick8a sagidjinija8agani8idj a8iagokag, pig8adakamigokag paba ija kidji k8ag8e mikag ke iji an8ecimonodj. Ka8in dac omikasin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ikido dac: ‘Niga koki ki8e taji ka iji tajikeiaban kagi odji sagidjinijaogo8an.’ Midac koki ki8e acitc omika8an ini a8ian ka odji sagidjinija8agani8ipan, tabickotc migi8amini ka kitci paiekinag8anig e ijinagozindjin, ega dac kodag a8ian iima e tajikendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Aa dac madji manido onada 8abaman nij8atcin kiabadj kodagian madji manidon, na8adj kiabadj e madji inadizindjin apitc8in 8in. Mama8 dac opidigecka8a8an ini a8ian acitc mi iima eji tajike8adj. Ick8a dac ii, na8adj kiabadj kitci kotadendagozi aa a8iag apitc8in ockadok. Mi ke iji8ebizi8adj a8iagog nogom ka pimadizi8adj ka kitci madji a8iago8i8adj.” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Meg8adj Jesos kiabadj e aiamiadjin a8iagon, odjodjoman acitc o8idjiki8en ki tag8icinobanin. Ag8adjik paba tajigaba8ibanig acitc o8i aiamia8abanin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Jesos dac ki inagani8i: “Kidjodjom acitc kidjiki8eg ag8adjik paba tajigaba8i8ag, e 8i aiamiik8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesos dac ogi nak8e8ajian: “A8enen dac aa nidjodjom acitc a8eneni8ag igi nidjiki8eg?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Okikinoamaganan dac ogi ino8an, acitc ki ikido: “Kijigabamikog! Mi ogo8e nidjodjom acitc nidjiki8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","A8enenigotc mega ke ijitcigedj adi eji nda8endamindjin Nidadaman 8ak8ig ka tendjin, mi aa nidjiki8e kek8an nidjodjom.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ii pejig8an e kijiganig, Jesos ki sagaamogoban migi8amikag ka iji tegobanen acitc tcigagam sagaiganikag ki iji nda abi kidji kikinoamagedj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kitci manebanin a8iagon e ma8adjiidindjin 8ajagam 8inikag, pidonag dac ki iji nda abigoban. Ag8idinoban ii tciman nibikag, a8iagog dac tcigagam tajigaba8i8agoban. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Adisokanan dac odabadjitonagobanin e kikinoamagedj mane kegoni. Ogi inan dac: “Nigodin pejig kitige8inni ki nda kitigegoban. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Meg8adj dac e taji kitigegobanen odanominiman okitigan akikag, nandam mikanakag ki inagodjino8an. Pinecijag dac ogi pi nda am8a8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kodagiag dac anominag ka iji asini8akamiganig ki inagodjinog, ka iji ega kipagakamiganig. Teci8ag dac ki madjigi8ag anominag, ega e manenig akini. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Apitc dac ka ani icpagodjig kizis, ki ick8ade8an ini kitiganijican acitc ki pate8an, ega tibise e kin8agin 8adabin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nandam dac kodagiag anominag ka iji minesatigo8anig ki inagodjinog. Meg8adj dac ka pimigigin ka min8acigin kitiganan, minesatigog acitc ki ani madjigi8ag, midac ka iji ani kib8anamockigadegin kidji gi minogigin ka min8acigin kitiganan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kodagiag dac nandam anominag ka iji min8acinig akini ki inagodjinog. Kitiganan dac ki madjiginon acitc minan ki nta8iginon, nanandam memidasomidana8edon e azaodegin, nanandam dac nenigod8asomidana8edon, acitc dac nanandam nenisomidana8edon e azaodegin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jesos kiabadj ki ikido: “Kakina kina8a keckito8eg kidji nisidotameg, 8e8enda ndotamok.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jesos dac okikinoamaganan ogi pi nazikagon acitc ogi k8ag8edjimigon: “8egonen adisokanan 8edji abadjito8anin e aiamiad8a a8iagog?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ogi nak8e8ajian dac: “Kina8a kigi odisigona8a kidji kikendameg Kije Manido Odogima8i8in, ega 8ikad a8iag kagi kikendag. Igi8e dac 8ina8a, ka8in ododji odisigosina8a. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","A8iag mega kegoni ka aiag, a8acamej oga odisigon, kitci mane dac kegoni oga aian. Aa dac a8iag ega kegoni ka aiag, misa8adj pagi eta kegoni aiag kada makamagani8i. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","8edji abadjito8anin dac adisokanan e kikinoama8ag8a, osa ka8in kegoni o8abadasina8a apitc inabi8adj, acitc ka8in kegoni onodasina8a acitc ka8in kegoni onisidotasina8a apitc ndotamo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Midac oodi eji8ebizi8adj 8eckadj kagi iji tibadjimogobanen niganadjimo8inni Isaia: ‘Kije Manido ikido: Kiga kitci paietetana8a, ka8in dac kiga nisidotasina8a. 8e8enda kiga kijigabadana8a, ka8in dac kiga nisida8inasina8a. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ani kitci cibictig8ane8ag mega igi a8iagog. Ki kibota8agendizo8ag acitc ki pazag8abi8ag. Ka8in ockijigo8an o8i abadjitosina8an kidji 8abi8adj, acitc ka8in ota8aga8an o8i abadjitosina8an kidji nodamo8adj, acitc ka8in omidonendjigani8a o8i abadjitosina8a kidji nisidotamo8adj. Ka8in ninikag 8i inasamigaba8isi8ag. Ka8in dac nikackiasi8ag kidji kigeag8a.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Kina8a dac, kica8endagozim, ki8abim mega acitc kidozitem! ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Teb8e ki8idamonom, kitci mane niganadjimo8innig acitc a8iagog ka k8aiakozi8adj ogi kitci nda8endana8a kidji iji 8abadamo8adj ka iji 8abadameg, ka8in dac ododji 8abadasina8a. Ogi kitci nda8endana8a kidji nodamo8adj ka iji nodameg, ka8in dac ododji nodasina8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“8e8enda ndotamok kidji nisidotameg adi ekidomagag oo8e adisokan kitige8inni e mikomagani8idj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Igi8e a8iagog ka nodage8adj e mikodjigadenig Kije Manidon Odogima8i8ini, acitc ega ka nisidotamo8adj, mi maia tabickotc anominag mikanakag kagi inagodjino8agobanen ejinagozi8adj. Kitci madji manidon opi nda manibidoni kagi kitigani8anig odei8akag, kidji 8anike8adj min8adjimo8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nandam dac kodagiag a8iagog, mi maia tabickotc anominag ka iji asini8akamiganig kagi inagodjino8agobanen ejinagozi8adj. Onodana8a min8adjimo8ini acitc teci8ag oteb8etana8a e modjigendamo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ka8in dac macka8izimagasini oteb8etamo8ini8a acitc ka8in kin8ej okana8endasina8a. Apitc dac madjise8adj, kek8an nanekadjiagani8i8adj Kije Manidon omin8adjimo8ini odji, teci8ag o8ebinana8a oteb8etamo8ini8a. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nandam dac kodagiag a8iagog, mi maia tabickotc anominag ka iji minesatigo8anig akini kagi inagodjino8agobanen ejinagozi8adj. Onodana8a Kije Manidon omin8adjimo8ini. Pekic dac odanimendamiigona8an kegonan ka nda8endamo8adjin kidji pimadjio8adj, acitc omotci nda8endana8a kidji 8anadizi8adj, ega e kikendamo8adj ega odji pejig e apitendag8anig. Kib8anamockigade dac ii min8adjimo8in, ka8in dac odji pejig abadasini opimadizi8ini8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nandam dac kiabadj kodagiag a8iagog, mi maia tabickotc anominag ka iji min8acinig akini kagi inagodjino8agobanen ejinagozi8adj. Onodana8a min8adjimo8ini acitc 8e8enda onisidotana8a. Odabadjitona8a dac opimadizi8ini8akag, nandam pagi eta, nandam enigok, acitc nandam okitci abadjitona8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesos ogi abadjiton kodagini adisokani e kikinoamagedj, e ikidodj: “8adan oo ejinag8anig Kije Manido Odogima8i8in. Pejig nabe ki kitigegoban ka minozindjin anominan okitigan akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nigodin dac e tibikanig, meg8adj kakina a8iagon e nibandjin, pejig a8ian ka kitci madjenimigodjin ki kimodji tag8icinon. Madji mijackoni dac ki kitigenigoban iima okitigan akikag, nena8idj anominikag ka minozindjin. Midac ka iji madjandjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Apitc dac ka madjigi8adj ka minozi8adj anominag, acitc minan ka ani nta8igigin, mi acitc madji mijackon ka iji madjigigin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Odanokitage8inniman dac aa ka tibendag akini ogi pi igon: ‘Kacka! Mino anominag eta kigi kitigenaban kikitigan akikag. Adi dac 8edjisegin madji mijackon?’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Aa dac kacka ogi inan: ‘A8iag e madjenimijidj ii ka todag.’ ” “Igi8e dac anokitage8innig ogi k8ag8edjima8an: ‘Kinada8endan na kidji nda mamanibido8agin madji mijackon?’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ogi nak8e8ajian dac: ‘Ka8in ii todakegon. Meg8adj mega taji manibido8egon madji mijackon, ne8ad acitc ka min8acigin kitiganan kiga pitci pidona8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mi ijitaokon manodj kada ma8asago madjiginon, pinici kidji odjitciseg kidji ma8adjitcigadegin kitiganan. Ii dac apitc, niga inag ka ma8adjito8adjin kitiganan: Manibidaokon pinama madji mijackon, acitc ok8abidaokon kidji ick8azamegon. Mina8adj dac ma8adjitaokon ka min8acigin kitiganan acitc nidatasonigi8amikag ataokon, mi ke inag8a,’ ki ikido aa nabe.” Mi ka inadisokedj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesos dac ogi abadjiton kodagini adisokani e kikinoamagedj, e ikidodj: “8adan oo8e ejinag8anig Kije Manido Odogima8i8in. Mi maia tabickotc anomines ejinag8anig, pejig kitige8inni kagi kitigedj okitigan akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mi aa ma8adji ka kitci agasiminagizidj kakina ka taci8adj anominag. Apitc dac ka madjigidj, mi aa ma8adji ka mitcakozidj. Ani kin8akozi tabickotc mitig, acitc pinecijan pi nda 8asasonike8an o8adik8anikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesos ogi abadjiton kodagini adisokani e kikinoamagedj, e ikidodj: “8adan oo ejinag8anig Kije Manido Odogima8i8in. Mi maia tabickotc obisidjigan ejinag8anig, pejig ik8e kagi iji kiniga8isidodj kitci mane kapanekag, pinici kidji kitci obicinindjin mizi8e odobiziganiman.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Kakina ini kegonan Jesos ogi iji 8a8idama8an a8iagon adisokanan e abadjitodjin. Ka8in kegoni ikidosiban ega e abadjitodjin adisokanan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Otodanagoban iidi kidji iji8ebanig kagi ikidonigobanen niganadjimo8innin: “Adisokanan niga abadjita8anan e aiamiag8a, niga 8idama8ag kegonan kagi kadjigadenigin ka ako kijendjigadeg aki.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesos dac ogi naganan kakina a8iagon, acitc ki ki8e ka iji tajikepan. Okikinoamaganan dac ogi pi nazikagon acitc ogi k8ag8edjimigon: “8a8idamaocinam adi 8a ikidomagag madji mijacko adisokan ka nta8iginogobanen kitigan akikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesos ogi nak8e8ajian: “Aa8e ka kitigedj ka minozindjin anominan, mi 8aa Kagi pi Anicinabe8iidizodj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kitigan aki dac, mi maia tabickotc a8iagog ooma akig ijinag8an. Ka minozi8adj dac anominag, mi maia tabickotc igi a8iagog Kije Manidon Odogima8i8inikag ka iji tibendagozi8adj ejinagozi8adj. Madji mijackon dac 8in, mi maia tabickotc igi8e ka tibenimigo8adjin madji manidon ejinag8agin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Madji a8iag dac ka kitigedj madji mijackoni, mi aa madji manido. Apitc dac ma8adjitcigadegin kitiganan, mi maia tabickotc ka ponaki8ag ejinag8ag. Ka ma8adjito8adjin dac kitigani, mi igi ajenig.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Ka ijinag8ag dac kagi ma8adjitcigadegin madji mijackon kidji ick8azigadegin, mi pejig8an ke ijiseg apitc ponaki8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ii apitc Ka pi Anicinabe8iidizodj oga pidjinija8an odajeniman. Kada paba ija8ag dac Kije Manidon Odogima8i8inikag, e ma8adjia8adjin ini8e ka pakebinandjin kodagian a8iagon e 8ik8adjiandjin kidji patadindjin, acitc ini8e ka madji inakamigizindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kitci ickodekag dac oga iji8ebina8an. Iima dac kada kitci ma8i8ag a8iagog acitc kada kitci mamad8eabidecka8ag ke apitci kodagito8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ka k8aiakozi8adj dac 8ina8a, mi maia tabickotc kizis ka kitci tcakasigedj ke ijinagozi8adj Odadami8an Odogima8i8inikag. Kakina kina8a keckito8eg kidji nisidotameg, 8e8enda ndotamok!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“8adan oo8e ejinag8anig Kije Manido Odogima8i8in. Mi maia tabickotc pejig kegon ka kitci sanagag egi kadjigadeg kitigan akikag ejinag8anig. Pejig dac a8iag ogi mikan, acitc ogi koki kadon. Ki kitci modjigendam. Kakina dac ki nda ada8e odaiman, acitc ogi kicpinadon ii kitigan akini.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Mina8adj dac, mi maia tabickotc ada8e8inni ka nanada 8abamadjin ka kitci minojicindjin migisan ejinag8anig Kije Manido Odogima8i8in. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Apitc dac pejig ka mika8adjin ka kitci sanagizindjin, ki nda ada8e kakina odaiman, acitc ogi kicpinanan ini migisan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Mina8adj dac, mi maia tabickotc asab kagi pakobiatig8ani8ag sagaiganikag ejinag8anig Kije Manido Odogima8i8in, acitc kakinagotc aijinagozi8ag kigozag kagi pidaamo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Apitc kicpone kigozi8idj aa asab, ki ag8azidabi8ag ka pagida8a8adj, acitc ki onabi8ag kidji onina8adjin kigozan. 8adabi8akikokag ogi iji asa8an ka minozindjin kigozan, acitc ogi 8ebina8an ini8e ega ka minozindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Apitc ponaki8ag, mi pejig8an ke ijiseg. Ajenig oga pi nda onina8an madji a8iagon acitc ka k8aiakozindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Oga madjocte8ebina8an dac madji a8iagon. Iima dac, kada kitci ma8i8ag acitc kada kitci mamad8eabidecka8ag ke apitci kodagito8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesos dac ogi k8ag8edjiman: “Kakina na kigi nisidotana8a ii?” “Ee, ninisidotananan,” ogi igon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ogi inan dac: “A8enenigotc 8e8enda ka kikendagin Coda8inni Inakonige8inan, acitc ani kikendag adi eji kikinoamage8ag e mikodam8ag Kije Manidon Odogima8i8ini, 8adan oo ejinagozidj. Mi maia tabickotc ka kitci 8anadizidj a8iag ejinagozidj, ka kitci manenigin o8anadizi8inan omigi8amikag, nandam ocki kegonan acitc nandam 8eckadj kegonan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ka ick8a adisokedj e kikinoamagedj, Jesos ki odji madja iima. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ki ijagoban dac 8edi Nazaret odenakag, taji kagi odji obigigobanen. Ki madji kikinoamage dac iima Coda8inni aiamiemigi8amikag, acitc kakina a8iagon ka tenipanin iima ki kitci mamakadendamon. Ikido8agoban dac: “Adi 8edinag ii okagita8endamo8in? A8eneni8an kagi minigodjin macka8izi8ini kidji gi iji mamada8izidj iidi? ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kana mi 8aa mitigonabe og8izisan? Mani ijinikazo8an odjodjoman! Mi ini Jak (Jacques) o8idjiki8en, Josep (Joseph), Simo (Simon), acitc Jod (Jude)! ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ocimejan ka ik8e8indjin kakina tajike8an ooma kina8itinakag! Adi dac 8edinag ii okagita8endamo8in acitc omacka8izi8in?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Onagabinigona8aban dac ii kidji teb8eta8a8adjin Jesosan. Jesos dac ogi inan: “Kitci manadjiagani8i ako niganadjimo8inni. Kagi iji obigidj dac odenani acitc omigi8amikag eta ka8in iji manadjiagani8isi,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ka8in dac Jesos mane ki iji mamada8izisi 8edi Nazaretikag, ka8in mega teb8eta8agani8isiban. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ii apitc Herod (Hérode), ka ogima8igobanen Galilee akikag, ki nodagegoban Jesosan e mikomagani8indjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ogi inan dac odanodaganan: “Mi aa Cabadis, kagi abidjibag8en! Mi 8edji kackitodj kidji mamada8akamigizidj!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Mi mega oo8e ka iji8ebag kidji nibodj Cabadis. Herod acitc Herodiad (Hérodiade) ki iji niba8i8agoban, misa8adj Herodiad egi iji niba8igobanen Pilipikag, Herod o8idjiki8en. Cabadis dac odinagoban Herodan: “Ka8in kidinendagozisi kidji makazo8an aa ik8e, mi mega ekidomagagin inakonige8inan.” Herod dac ki anokigoban kidji na8adinimagani8indjin Cabadisan, acitc kidji mag8apinagani8indjin acitc kidji kiba8agani8indjin kibaodimigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod onada8endanagoban kidji nisimagani8indjin Cabadisan. Okosabanin dac ini a8iagon ka nosone8andjin Cabadisan, kakina mega niganadjimo8inni8i odinenima8agoban ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Apitc Herod ka tibickamogobanen, Herodiad odanisan ki niminigoban nigan a8iagon kagi nd8e8emagani8indjin. Herod dac ogi kitci min8endamiigon ini ik8esesan e nimindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ogi inan dac: “Teb8e ketcinadj kiga minin kakina kegon ke k8ag8edjimiji8anen.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ogi igon dac aa ik8eses odjodjoman 8egoneni ke iji k8ag8ed8edj. Midac ka inadjin Herodan aa ik8eses: “Pidamaocin Cabadis octig8an kitci nabaginaganikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herod dac ki kitci kackendamisegoban. Pekic dac kakina iima kagi nd8e8emagani8inigobanen ogi nodagon adi kagi inadjin ini ik8esesan kidji minadjin 8egonenigotc ke iji k8ag8edjimigog8en. Midac ka iji ikidodj kidji minadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ogi ijinija8an dac a8ian kidji nda kickig8ega8andjin Cabadisan 8edi kibaodimigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kitci nabaginaganikag dac ki iji pidji8idjigadeni Cabadis octig8an. Ki minagani8i dac aa ik8eses, midac ka iji minadjin odjodjoman. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Cabadis dac okikinoamaganan ogi pi nadji8idoni o8ia8, acitc ogi naatoni. Ogi a8i nda 8abama8an dac Jesosan, e nda 8idama8adjin adi kagi iji8ebanig. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Apitc Jesos ka nodagedj Cabadisan egi nibondjin, 8in nicikena ki pozi tcimani e madjiodj, ega ka iji tani8anig e ijadj. A8iagog dac ki nodage8ag. Ogi nagadana8an dac ododenami8an, acitc ogi nosone8a8an Jesosan tcigibiag e pimajagame8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Apitc dac Jesos ka kabadj tcimanikag, ogi 8abaman kitci mane a8iagon. Ogi kitci kidimageniman dac ini a8iagon, acitc ogi kigean ka akozindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Apitc e ani onag8icinig, Jesos okikinoamaganan ogi pi nazikagon acitc ogi igon: “Ka8in tag8asinon kegon ooma, acitc aja kitci 8ikadi8an. Ijinijaok dac igi a8iagog, odenajicikag kidji nda manimidjime8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesos ogi inan: “Ka8in mamakadj kada ijasi8ag. Kina8a tibina8e mijikog kidji 8isini8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Midac ka ina8adjin Jesosan: “Motci nanani8ag obiziganesag e aia8agid8a acitc niji8ag kigozag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesos dac ki ikido: “Ack8e pijiokog igi obiziganesag acitc kigozag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mina8adj Jesos ogi inan kakina a8iagon kidji abindjin motakamig. Ogi odapinan dac ini ka nananindjin obiziganesan acitc ka nijindjin kigozan. Ki icpanabi 8ak8ig acitc mig8etc ogi inan Kije Manidon. Ogi papak8ebinan obiziganesan, acitc ogi minan okikinoamaganan. 8ina8a dac ogi madinama8a8an kakina a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ki 8isini8an dac kakina, acitc ki tebickono8an. Jesos dac okikinoamaganan ogi ma8adjitona8a midjimini kagi odji ickosenig. Midatcin acitc nijin 8adabi8akik8an ki kicpone8an inigik ka ickosenig midjimini. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","8aiej nanan kitci midasomidana (5000) taci8agoban nabeg kagi 8isini8adj, ega ik8e8ag acitc abinodjijag e acidagimagani8i8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Teci8ag dac ka ick8a acamadjin a8iagon, Jesos ogi pozinija8an okikinoamaganan tcimanikag, 8ina8a nitam kidji gi ajo8aamindjin sagaigani. 8in dac ki tajike iima, e ki8enija8adjin ini mane a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ick8a dac ii, pik8adinajicikag ki 8agidamadji8e e nda aiamiedj. Apitc e ani onag8icinig, Jesos kiabadj teban iima, 8in eta. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nena8agam dac sagaiganikag ki ani inasan tciman, acitc ki naga8ebasan e kitci nodig acitc e kitci mamagaag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Apitc e ani pidabanig, Jesos ogi nda nazika8an okikinoamaganan, 8agidjibig e iji pimosedj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Apitc ka 8abamigodjin e pimosedj 8agidjibig, kakina ki kitci kock8endamon. Midac ekidondjin: “Tcibai mada aa!” Acitc ki kitci pabibagi8an, epitci kitci segizindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Teci8ag dac Jesos ogi aiamian: “Ka8in segizikegon! Nin Jesos! Ka8in nigod inendakegon!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Midac Pien ogi inan: “Tebendjigean! Kicpin teb8e kin e aiaa8anen, ikidon kidji nda nagickaonan nibikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesos dac ogi inan: “Pijan!” Pien dac ki kaba tcimanikag acitc 8agidjibig ki iji pimose e nda nagicka8adjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Apitc dac ka 8abadag e madjino8enig, mi ka iji kotag. Kegapitc dac ki ani kozabi. Midac ki pabibagi: “Tebendjigean! Ag8acimicin!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Teci8ag dac Jesos ki ijindjita. Ogi na8adjibinan dac acitc ogi inan: “Kitci agacinoja eji teb8etaman! 8egonen 8edji ega ki apacenimo8an ninikag?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Midjinijin dac ki pozi8ag tcimanikag, acitc mi ka iji ponino8enig. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Igi dac kikinoamaganag tcimanikag ka te8adj ogi nibak8ita8a8an Jesosan e ikido8adj: “Kin teb8e Kije Manido Og8izisan!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jesos acitc okikinoamaganan ki ick8a ajo8agame8agoban sagaigani acitc ki kaba8ag Jenesaret akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","A8iagog iima ka tajike8apan ogi nisida8ina8a8an Jesosan, acitc ki paba ija8ag mizi8e iima akikag e paba 8a8idamage8adj egi tag8icinindjin. Ogi iji8idama8a8an dac kakina ka akozindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Okitci k8ag8edjima8agoban dac Jesosan kidji gi pagidinigo8adjin pagigotc eta kidji taginamo8adj 8ajagameig okonasini. Kakina dac ka taginamo8adj ki kige8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nandam Coda8innig ka nagadjito8agobanen inakonige8inan acitc nandam Coda8inni kikinoamage8innig, Jerusalem ka odji8adj, ogi pi nazika8a8an Jesosan, acitc ogi k8ag8edjima8an: ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“8egonen 8edji ega nosoneamo8adj kikikinoamaganag ka iji kikinoamage8apan 8eckadj kikitci anicinabeminabanig? Ka8in mega kizindjisi8ag ab8amaci 8isini8adj, tabickotc kagi ikidomaganig aiamie inakonige8ini!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesos dac ogi nak8e8ajian: “Kina8a dac, 8egonen 8edji ega ndotamegon Kije Manido odinakonige8inan? Tiegodj, kinosoneana8an kina8a tibina8e kikikinoamage8ini8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kije Manido mega ki ikido: ‘Kiga manadjia8ag kidadami8a acitc kidjodjomi8a.’ Acitc dac mina8adj ki ikido: ‘Aa8e ke madji inadjimag8en odadaman kek8an odjodjoman inendagozi kidji nisagani8idj.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kina8a dac, pakan kidiji kikikinoamagem, e ikido8eg: ‘Kicpin pejig a8iag odadaman kek8an odjodjoman nodesendjin kegoni, okackiton kidji inadjin: Nida min8endan kidji mininan kegon kidji gi 8idjiinan. Sanagadakamig dac kidji gi todamaban, aja mega nigi nakomonan kidji minag Kije Manido.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Kipagidina8a dac aa a8iag ega kidji manadjiadjin odadaman ke 8idjiapanin. Midac iidi e todameg e 8ebinameg Kije Manido odikido8in, e kikinoamageieg kina8a tibina8e kikikinoamage8ini8a. ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kikitci kimodizim! Kikitci teb8emigo8agoban e mikomigo8eg niganadjimo8inni Isaia, apitc ka ojibiag oo8eni: ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Kije Manido ikido: Ogo8e a8iagog nimin8adjimigog odikido8ini8an e abadjito8adjin, anic dac nikitci na8abamigog odei8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kitci anica dac nidaiamitagog. Kikinoamage8ag mega ini inakonige8inan a8iagon kagi ojitondjin, mi maia tabickotc nin kagi ojita8agin ini inakonige8inan 8a in8eto8adjin.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesos dac ogi nd8e8eman kakina a8iagon acitc ogi inan: “Ndotaocik, acitc k8ag8e nisidotamok oo8e. ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ka8in 8in ka pidigemaganig a8iag odonikag ka pataigodj, tiegodj ka sagidjisenig.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jesos dac okikinoamaganan ogi pi nazikagon acitc ogi igon: “Coda8innig ka nagadjito8adjin inakonige8inan ki kitci nickadizi8ag egi nodaok8a e ikido8adj ii.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesos dac ogi inan: “Kada manakibidjigade8an kakinagotc kitiganan ega kagi kitigedj Nidadam 8ak8ig ka tedj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ka8in pabiziskenimakegonig Coda8innig ka nagadjito8adjin inakonige8inan! Mi tabickotc ega ka 8abi8adj ka k8ag8e kikino8ina8adjin e 8idji pimosema8adjin kodagian ega ka 8abindjin ejinagozi8adj. Kicpin dac a8iag ega ka 8abidj k8ag8e kikino8inadjin e 8idji pimosemadjin kodagian ega ka 8abindjin, midjinijin kada podazig8egodjinog ka iji 8anakamiganig.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pien dac ogi k8ag8edjiman Jesosan: “8a8idamaocinam adi maia 8a ikidomagag ii adisokan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesos ogi inan: “Kekina8a, kana maci kiabadj kikackitosina8a kidji nisidotameg? ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Aja kinisidotana8adok ka midjig a8iag, omisadakag pidigemagani acitc kegapitc sagaamomagani o8ia8ikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Anic dac a8iag odeikag odjiseni8an odikido8inan apitc anim8edj, acitc mi ii8eni ka pataigodj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Odeikag mega odjimagani8an a8iag omadji midonendamo8inan, kidji nici8edj, madji aido8ini kidji pabamendag, kidji madjakamigizidj, kidji kimodidj, kidji kagina8ickidj e inactaonadjin kodagian a8iagon, acitc kidji manazomadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mi ii8eni ka pataigodj a8iag. Kicpin dac ega kizindjidj ab8amaci 8isinidj tabickotc kagi ikidomaganig aiamie inakonige8ini, ka8in 8in ii opataigosin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Mina8adj dac Jesos ki odji madja iima, acitc ki ija 8edi akikag pecodj Sidon acitc Tir (Tyr) odenakag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Pejig ik8e iima tajikegoban ega e Coda8inni8idj, Kenan (Canaan) akini kagi odjinipanin okitci anicinabeman. Ogi pi nda 8abaman Jesosan acitc ogi pabibagiman: “Ka Tibendjigean! Kin ogima David odanike ojisan! Kidimagenimicin! Nidanis okigickagon madji manidon, kitci kodagito dac!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ka8in dac kegoni ododji iji nak8e8ajiasin Jesos. Okikinoamaganan dac ogi pi nazikagon e pi nda pagosenimigodjin: “8ack8enijao aa ik8e. Ka8in mega kicko8esi e pabibagimigo8ak e pimi nosoneogo8ak.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesos dac ogi nak8e8ajian: “Nigi pidjinijaogo ooma akikag kidji 8idjiag8a Israel a8iagog eta, tabickotc mantcenicag ka 8anicino8adj ka ijinagozi8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ogi pi nibak8itagon dac ini ik8e8an, acitc ogi igon: “Tebendjigean! 8idjiicin!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesos dac ogi nak8e8ajian: “Ka8in min8acisinon kidji makameg8a abinodjijag omidjimimi8a acitc dac kidji iji 8ebinama8eg8a animocag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ogi igon dac: “Tebendjigean. Teb8e ii, anic dac 8a8adj animocag omamojagadana8a ka pabi8isenig midjimini ka odji pinagodenig okackami8an o8isini8agani8akag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesos dac ogi inan: “Maiagotc kikitci sogi teb8etan. Kiga minigo sa ka iji pagosendaman.” Maia dac ii apitc ki kige8an odanisan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesos ki odji madja iima, acitc ki ija tcigagam Galilee sagaiganikag. Ki ik8amadji8e pik8adinajicikag acitc ki 8a8enabigoban iima. ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kitci mane a8iagon ogi pi nda 8abamigobanin iima. Ki pidji8inagani8i8ag dac a8iagog ka atci8icka8adj, ega ka 8abi8adj, ka makizi8adj, ega ka nta8e8adj, acitc kitci mane kodagiag ka akozi8adj. Nigan Jesosikag ki iji pagidinagani8i8ag, ogi kigean dac. ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ki kitci mamakadendamog dac kakina a8iagog apitc ka 8abama8adjin e anim8endjin ega kagi nta8enipanin, e kigendjin kagi makizinipanin, e mino pabamosendjin kagi atci8ickanipanin, acitc e 8abindjin ega kagi 8abinipanin. Kakina dac ogi icpenima8an Israel a8iagon Okije Manidomini. ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kegapitc Jesos ogi nd8e8eman okikinoamaganan acitc ogi inan: “Nikidimagenimag igi8e a8iagog. Aja nisokajik ni8idjiogog acitc aja ka8in kegoni odaiasina8a kidji 8isini8adj. Ka8in ni8i ki8enija8asi8ag ega egi 8isini8adj. Ne8ad mega ozam kada kitci cagozi8ag kidji ki8e8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Okikinoamaganan dac ogi k8ag8edjimigon: “Adi dac ke odinamak midjim kakina kidji gi acamaiakonig ooma pig8adakamigokag?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesos dac ogi k8ag8edjiman: “Adi inigik obiziganesag e aia8eg8a?” Ogi nak8e8ajiigon dac: “Nij8atci8ag, acitc pagi kigozesag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesos dac ogi inan kakina a8iagon kidji abindjin motakamig. ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ogi odapinan dac ini ka nij8atcindjin obiziganesan acitc kigozan, acitc mig8etc ogi inan Kije Manidon. Ogi papak8ebinan dac, acitc ogi minan okikinoamaganan, 8ina8a dac ogi madinama8a8an a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kakina dac ki 8isini8an acitc ki tebickono8an. Jesos dac okikinoamaganan ogi ma8adjitona8a ka ickosenig midjimini, nij8atcin dac 8adabi8akik8an ki kicpone8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ni8in kitci midasomidana (4000) tacibanig nabeg kagi 8isini8adj, ega ik8e8ag acitc abinodjijag e acidagimagani8i8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jesos dac ogi ki8enija8an ini a8iagon, midac ka iji pozidj tcimanikag acitc Magadan akikag ki ija. ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nandam Coda8innig ka nagadjito8agobanen inakonige8inan acitc nandam Coda8innig ega ka teb8etamo8agobanen abidjiba8ini ogi pi nda 8abama8an Jesosan. O8i k8ag8e katcidina8abanin anodj kidji iji nak8e8ajii8endjin. Ogi k8ag8edjima8an dac kidji mamada8izindjin, kidji gi odji kikendamo8adj kicpin teb8e Kije Manidokag epitci odjimaganig8en omacka8izi8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesos dac ogi nak8e8ajian: “Apitc pagicimog, kidikidom oo8e: ‘Kitci mamisk8anak8an, kada minokijigan dac.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Acitc 8ibadj e kijeba8acig, kidikidom oo8e: ‘Kitci makade misk8aban, kada kimi8an dac ogajigag.’ Apitc kijigabadameg 8ak8ig, maiagotc kikackitona8a kidji odji kikendameg adi ke ijigijigag, ka8in dac kikackitosina8a kidji nisidotameg adi 8a ikidomagag oo8e eji8ebag nogom. ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","A8iagog nogom ka te8adj kitci madji a8iago8i8ag, acitc ka8in o8i teb8eta8asi8a8an Kije Manidon! Nik8ag8edjimigog kidji mamada8izi8ag kidji nda motci kikendamo8adj epitci teb8emaganig8en ii egi pidjinijaojindjin Kije Manidon. Ka8in sa dac niga mamada8izi8asin. Aja mega okikendana8a adi kagi iji8ebizindjin niganadjimo8innin Jonasan 8eckadj. Midac iima ke iji 8abadamo8adj mamada8izi8ini ka k8ag8ed8e8adj.” Midac Jesos ka iji naganadjin e madjadj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Apitc Jesos acitc okikinoamaganan ka ajo8aamo8agobanen sagaigani, okikinoamaganan ki 8anikenigoban kidji madji8inandjin pak8ejiganan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesos dac ogi inan: “Iag8amig Coda8innig ka nagadjito8adjin inakonige8inan acitc Coda8innig ega ka teb8etamo8adj abidjiba8ini odobisidjigani8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ka8in dac ododji nisidotagosibanin okikinoamaganan adi 8a ikidopan. Ki k8ag8edjimidi8an dac: “Adi 8a ikidodj ii? Misa egi 8anike8aiak pak8ejiganan 8edji ikidodj ii.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesos dac ogi odji pabiziskita8an adi ekidondjin e aiamiidindjin. Ogi inan dac: “Kotadji agacinoja eji teb8etameg! 8egonen 8edji inidieg ega e aia8eg pak8ejigan? ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kana maci kinisidotasina8a? Mik8endamok kagi papak8ebinama8ag8aban igi8e ka nano kitci midasomidana8e8apan (5000) a8iagog ka nananipanin obiziganesan. Adi inigik dac kagi kicponaieg8a 8adabi8akikog apitc ka ma8adjito8eg inigik ka ickoseg midjim ii apitc? ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Mina8adj dac mik8endamok kagi papak8ebinama8ag8aban igi8e ka nio kitci midasomidana8e8apan (4000) a8iagog ka nij8atcinipanin obiziganesan. Adi inigik dac kagi kicponaieg8a 8adabi8akikog apitc ka ma8adjito8eg inigik ka ickoseg midjim ii apitc? ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Adi dac 8edji ega nisidotameg ega pak8ejigan aa ka mikodamonagok? Mina8adj dac kidininom, iag8amig Coda8innig ka nagadjito8adjin inakonige8inan acitc Coda8innig ega ka teb8etamo8adj abidjiba8ini odobisidjigani8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Okikinoamaganan dac ki odji nisidotamo8an ega 8in iidi e inadjin kidji iag8amindjin obisidjigani ka abadjitcigadenig kidji obiziganikani8anig. Tiegodj, ogi inan kidji iag8amindjin okikinoamage8ini ini8e Coda8innin ka nagadjitondjin inakonige8inan acitc ini8e ega ka teb8etamindjin abidjiba8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesos ki ija 8edi akikag pecodj odenani Sesani Pilip (Césarée Philippe) ka ijinikadenig. Iima dac ogi k8ag8edjiman okikinoamaganan: “Adi ekido8adj a8iagog e mikomiji8adj, nin, Ka pi Anicinabe8iidizodj?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ogi nak8e8ajiigon dac: “Nandam ikido8ag e Cabadisi8i8adj, kodagiag ikido8ag e Eli8i8adj, kodagiag kiabadj ikido8ag e Jeremi8i8adj kek8an kodag 8eckadj niganadjimo8inni.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesos dac ogi k8ag8edjiman: “Kina8a dac, a8enen enenimijieg?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simo Pien dac ogi nak8e8ajian: “Kin aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin, 8in aa8e ‘Christ’ ka ijinikanagani8idj, Kije Manido ka pimadizidj Og8izisan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesos dac ogi inan: “Kica8endagozinan, Simo, John og8izisan. Ka8in mega a8iagog kidodji kikinoamagosig oo8e teb8e8ini, tiegodj Nidadam 8ak8ig ka tedj kagi minik kidji iji kikendam8adj ii. ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nin dac ki8idamon oo8e. Pien kidijinikazonan, ‘asini’ ka ikidomagag. Misa dac iima asinikag ke iji ma8adjiag8a kakina ka tibenimag8a. Ka8in dac 8a8adj kakina nibo8in omacka8izi8inan ogagi cagodjiigosina8a. ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kiga minin Kije Manido Odogima8i8in kidabikaiganan. Kakinagotc kegon ke nagabido8anen ooma 8akidakamig, kada nagabidjigade 8ak8ig. Kakina dac kegon ke pagidinamo8anen ooma 8akidakamig, kada pagidinigade 8ak8ig.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jesos dac 8e8enda ogi 8idama8an okikinoamaganan ega kidji paba tibadjimondjin 8in aa8e kagi ikidonipanin Kije Manidon kidji pidjinijaogodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ii dac apitc Jesos ki madjita 8e8enda kidji 8a8idama8adjin okikinoamaganan: “Panima Jerusalem ki ijaian, acitc panima niga kitci kodagiigog ka niganizi8adj Coda8innig, Coda8inni kitci aiamie ogimag acitc Coda8inni kikinoamage8innig. Niga nisigo, ki nisogonaganig dac niga abidjiba8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pien dac pagi pakan ogi iji8inan Jesosan, 8in eta kidji aiamiadjin, acitc ogi kaganonan, e inadjin: “Kije Manido kiga nagadjiig, Tebendjigean! Ka8in iidi kiga iji8ebizisi!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesos dac ki k8ekigaba8i acitc ogi inan Pienan: “A8as 8edi ijan, kitci madji manido! Ki8i nagabinijinan mega kidji todaman adi enendagozian kidji todaman. Ka8in Kije Manido ka inendag kidinendasin, tiegodj tabickotc a8iagog ka inendamo8adj kidinendan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jesos dac ogi inan kakina okikinoamaganan: “Kicpin a8iag 8i 8idjiojidj, panima ki poni mik8enimidizodj, panima ki pimi8inadjin otcibaiatigoman, acitc panima ki nosoneojidj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Aa8e mega ka kitci manadjitodj opimadizi8in kada nibo, aa8e dac pekic ke nibog8en nin odji, kada koki pimadizi. ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Adi dac inasag a8iag kakina kegonan ka kitci min8acinigin tibendagibanin ooma akikag, kicpin 8anitodj opimadizi8in? Tag8anidok na kegoni kegi meckodonag kidji gi koki aiag opimadizi8in? ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Aa8e mega Ka pi Anicinabe8iidizodj kada pi tag8icin kigi odajeniman, e 8abadai8edj Odadaman odicpendagozi8ini. Oga kijika8an dac pepejig a8ian kagi iji kackitamadizondjin adi ka pi inadizindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Teb8e ki8idamonom, nandam a8iagog ooma ka te8adj ka8in kada nibosi8ag ab8amaci 8abama8adjin Ka pi Anicinabe8iidizondjin e pi nda ogima8indjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ka ick8a nigod8asogonaganig, Jesos ogi madji8inan Pienan, Jakan, acitc Jak o8idjiki8en Johnan. Ogi iji8inan dac ka iji kitci icpadinanig pik8adinani, 8ina8a eta kidji te8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Meg8adj dac e kana8abamigodjin, ki ani kitci pakanabaminagozi Jesos. Mi maia tabickotc kizis ka ani ijig8easodj, acitc mi maia tabickotc ka 8asakonenigin odaiman ka apitci 8abiganigin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Igi dac nisin kikinoamaganag ogi 8abama8an Moisan acitc Elin, e taji aiamiandjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pien dac ogi inan Jesosan: “Ka Tibendjigean! Kitci min8acin egi pijaiak ooma. Kicpin dac nda8endaman, niga padakisidonan nisin nibaganan, pejig kin odji, pejig Mois odji, acitc pejig Eli odji.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Meg8adj e taji anim8edj, 8ak8ini e kitci tcakatenig ogi pi nigockagona8a. Ogi noda8a8an dac a8ian iima 8ak8ikag e odji mad8e anim8endjin e ikidondjin: “Mi aa Nig8izis ka kitci sagiag. Nikitci min8endamiig. Ndotaok dac!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Apitc kikinoamaganag ka nodamo8adj ii anim8e8ini, ki kitci panaskabicinog motakamig ka apitciniji8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesos dac ogi nazika8an acitc ogi taginan. Ogi inan dac: “Pazig8iok! Ka8in segizikegon!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ki 8ajagameabi8ag dac 8ina8akag, ka8in dac kodag a8ian ododji 8abamasi8a8an, mi eta Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Meg8adj e ani nisamadji8e8adj pik8adinakag, Jesos ogi inan oo8eni: “Ka8in a8iag mikodama8akegon adi kagi iji 8abadameg, pinici kidji abidjibadj Ka pi Anicinabe8iidizodj nibo8inikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ogi k8ag8edjimigon dac okikinoamaganan: “Coda8inni kikinoamage8innig ikido8ag: ‘Eli pinama kada pi koki tag8icin ab8amaci tag8icig aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin.’ 8egonen dac 8edji ikido8adj ii?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesos ogi nak8e8ajian: “Teb8e Eli kada pi koki tag8icin, kidji pi nda 8a8ejibidodjin kakina kegonan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Anic dac, ki8idamonom oo8e. Eli aja ki pi koki tag8icin, ka8in dac a8iagog ododji nisida8ina8asi8an, tiegodj adigotc 8a toda8a8adjin ogi toda8a8an. Midac pejig8an ke iji kodagia8adjin ini8e Ke pi Anicinabe8iidizondjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ogi nisidotagon dac okikinoamaganan maiagotc Cabadisan egi mikomadjin apitc ka mikomadjin Elin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Apitc Jesos acitc nisin okikinoamaganan ka odisa8adjin ini mane a8iagon ka taji piigo8adjin, pejig naben ogi pi nazikagon Jesos, acitc ogi nibak8itagon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ogi igon dac: “Tebendjigean! Kipagosenimin kidji kidimagenimadj nig8izis. Majise8apine acitc kitci kodagito. Mojag ako madjoctegodjin kek8an pakobise. ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kikikinoamaganag nigi iji8idama8ag, ka8in dac ododji kackiasi8a8an kidji kigea8adjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesos dac ogi inan: “8esada ako kina8a nogom ka pimadizieg, ega ka teb8etameg, acitc pijicig madji kegonan ka 8i pamendamegon! Anigik kiabadj ke 8idji tajikeminagok? Anigik panima ke tanendamiijieg? Pidji8idamaocik aa abinodjij ooma.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesos dac ogi kitci kanonan ini madji manidon, midac ka iji sagaamindjin iima ockina8esikag. Teci8ag dac ki kige aa ockina8es. ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nage dac, apitc Jesos acitc okikinoamaganan 8ina8a eta meg8adj e te8agobanen, ogi pi nazikagon okikinoamaganan acitc ogi k8ag8edjimigon: “8egonen dac 8edji ki p8a8inija8agidj kidji sagidjinija8agidj aa madji manido?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesos dac ogi nak8e8ajian: “Ka8in mega tibise kiteb8etasina8a. Teb8e ki8idamonom, kicpin anomin ka iniginidj inigok8agiban kiteb8etamo8ini8a, kida kackitona8a kidji idameg ii pik8adina: ‘Ooma odji madjan, acitc 8edi ijan,’ kida ndotagona8a dac. Ka8in dac kegon kida p8ana8itosina8a. ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Anic dac, mi eta aiamie8in acitc pagidadjige8in kadagi abadanon kidji gi sagidjinija8agani8idj aa ka inakanezidj madji manido.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nigodin Jesos acitc okikinoamaganan ma8asag ki te8agoban Galilee akikag. Jesos dac ogi inan: “Nin, Ka pi Anicinabe8iidizodj, niga 8agackibinigo, kidji gi tibenimiji8adj a8iagog ooma akig. ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Niga nisigog, anic dac, ki nisogonaganig niga abidjiba8an.” Okikinoamaganan dac ki kitci kackendamon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Apitc Jesos acitc okikinoamaganan ka oditamo8adj Kaponaom odenani, nandam nabeg ogi pi nda nazika8a8an Pienan. Mi igi ka ma8adjia8agobanen conian ka inendagozindjin pepejig Coda8innin kidji kijikamindjin taso pibon kitci aiamiemigi8amini. Ogi k8ag8edjima8an dac Pienan: “Kikikinoamage8innimi8a dac, kana okijikasin kitci aiamiemigi8amini?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pien ogi nak8e8ajian: “Tcemekasa, okijikan.” Apitc Pien ka pidigegobanen taji ka iji tenigobanen Jesosan, 8intam Jesos ki anim8egoban acitc ogi igon: “Adi kin enendaman, Simo? A8enen enendagozi8adj kidji kijika8a8adjin ogiman ka tendjin ooma akig? Odabinodjijimi8an na kek8an kodagiag a8iagog?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pien dac ogi nak8e8ajian: “Kodagiag a8iagog oda kijika8a8an.” Jesos dac ogi inan: “Ka8in dac mamakadj kitci ogimag odabinodjijimi8an kada inendagozisibanig kidji kijikazo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pekic dac, kasa 8in ki8i kiji8aasi8ananag igi8e ka ma8adjia8adjin conian. A8i ijan sa dac tcigagam sagaiganikag acitc nimina8eatig8en kik8ack8enabanabi nibikag. Ag8azidabin aa nitam kigoz ke k8ack8ebina8ad8en acitc ta8anobij. Kiga mika8a dac iima conia kidji gi tibisean kidji gi kijikaman nin inigik mezinaigeian kitci aiamiemigi8amikag, acitc kidji gi kijikadamadizo8an kekin. Odapin dac aa, acitc kijikazon inigik enendagoziak kidji kijikazo8ak.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ii apitc, Jesos okikinoamaganan ogi pi nazikagon acitc ogi k8ag8edjimigon: “A8enen ma8adji ketci apitendagozidj Kije Manido Odogima8i8inikag?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesos ogi nd8e8eman pejig abinodjijan, acitc ogi asan nigan 8ina8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ogi inan dac okikinoamaganan: “Teb8e ki8idamonom, kicpin ega adadizieg, tabickotc abinodjijag ka ijinagozi8adj kidji ijinagozieg, ka8in 8ikad kigagi pidigesim Kije Manido Odogima8i8inikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Aa8e dac ke tabasenimidizog8en, tabickotc 8aa8e abinodjij ka iji tabasenimidizodj, mi aa8e ma8adji ke kitci apitendagozidj Kije Manido Odogima8i8inikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Acitc aa8e nin odji ke mino toda8ag8enin pejig abinodjijan tabickotc ono8e, nimino todag kenin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“A8enenigotc dac ke 8ik8adjiag8enin kidji patadindjin pejig ini ega ka apitendagozindjin ka teb8etaojindjin, na8adj kada minoseni kidji acodapinagani8indjin kitci asinin og8ei8akag aa a8iag, acitc kidji nisaba8anagani8idj kitcigamikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kitci madji iji8eban nogom akikag! Kitci mane kegoni okadjinijaogona8a kidji patadi8adj a8iagog. Ketcinam apanigotc kada tag8anon ini kegonan. Kije Manido dac oga kitci pajacte8an ini8e ke patadiag8enin kodagian a8iagon.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Kicpin kinidji kek8an kizid pataigo8an, kickijan, 8asag dac inatig8en. Na8adj kiga minose kagige pimadizi8in kidji odisigo8an e motci pejigondjian kek8an e motci pejigozidean, apitc8in kidji aiamanin midjinijin kinidjin acitc midjinijin kizidan, kidji gi odji iji8ebinigo8an dac kitci ickodekag ega 8ikad ke ata8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Acitc dac kicpin kickijig pataigo8an, manibidon, 8asag dac inatig8en. Na8adj kiga minose kidji odisigo8an kagige pimadizi8in e motci nabanedjabian, apitc8in kidji aiamanin midjinijin kickijigon, kitci ickodekag dac kidji gi odji iji8ebinigo8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Iag8amig! Ka8in tabasenimakegon pejig ii e taci8adj igi8e ega ka kitci apitendagozi8adj. Teb8e ki8idamonom, odaia8a8an ajenin 8ak8ig ka tendjin e nagadjiigo8adjin, acitc apanigotc Nidadaman 8ak8ig ka tendjin o8idji tajikema8an igi ajenig. ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nin dac, Ka pi Anicinabe8iidizodj, nigi pi nda ag8acimag kagi 8anicino8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Adi dac enendameg? Kicpin a8iag aia8adjin midasomidana (100) mantcenican, odji 8aniadjin dac pejig, kana oga naganasi8an kodagian ka cagidasomidana acitc cagidatcinindjin (99) omantceniciman pik8adinajicikag, kidji a8i nanada 8abamadjin ini8e kagi 8aniadjin? ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Teb8e ki8idamonom, kicpin mika8adjin, na8adj kada kitci min8endam egi mika8adjin ini mantcenican, apitc8in ini8e ka aia8adjin kodagian ka cagidasomidana acitc cagidatcinindjin omantceniciman ega 8ikad ka 8anicinindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Midac pejig8an, Kidadami8a 8ak8ig ka tedj, ka8in 8a8adj iaga pejig onada8enimasi8an kidji 8anicinindjin ini ega ka apitendagozindjin a8iagon.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Kicpin kidjiki8e madji todaok, a8i nda 8abam acitc 8idamao 8e8enda adi eji 8isagendamiik, apitc kina8a eta e teieg. Kicpin dac nisidotag, kigi kackima kidji gi koki mino 8idjiok. ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kicpin dac ega 8i ndotag, mina8adj koki nda 8abam, acitc k8ag8edjim pejig kek8an nijin kodagiag a8iagog kidji 8idjiok8a. Midac iidi ke iji nosoneameg kagi ikidomaganig Kije Manido Omazinaigan: ‘Kicpin a8iag inactaonagani8idj egi panaagedj, panima nijin kek8an nisin a8iagon kada ikido8an teb8e egi iji panaagedj iidi.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kicpin dac ega 8i ndota8adjin ini a8iagon, a8i 8idamaok kodagiag ka teb8etamo8adj ka ma8adjiidi8adj kidji aiamie8adj. Kicpin dac aa a8iag ega 8a8adj 8i ndota8adjin ka ikidondjin ka teb8etamindjin ka ma8adjiidindjin, ka8in odji pejig pabiziskenimaken. Tabickotc a8iag ega ka teb8eta8adjin Kije Manidon inenim, kek8an tabickotc patado8inni ega ka 8i an8endizodj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Teb8e ki8idamonom, kakinagotc kegon ke nagabido8eg8en ooma 8akidakamig, kada nagabidjigade 8ak8ig. Kakina dac kegon ke pagidinameg8en ooma 8akidakamig, kada pagidinigade 8ak8ig.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Teb8e ki8idamonom acitc, kicpin nijin ii e tacieg ooma akikag ma8asag onendameg kegon kidji k8ag8ed8eieg apitc aiamieieg, kiga minigo8a Nidadam 8ak8ig ka tedj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Apitc mega 8a8adj nijin kek8an nisin a8iagog ka teb8etaoji8adj ma8adjiidi8adj kidji aiamie8adj, kenin iima niga te, kidji 8idji8ag8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pien dac ogi nazika8an Jesosan acitc ogi k8ag8edjiman: “Ka Tibendjigean! Atasinanaj enendagozian kidji ponenimag nidjiki8e, kicpin ega ponitodj kidji madji todaojidj? Pinici na nij8atcinanaj?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesos dac ogi nak8e8ajian: “Ka8in nij8atcinanaj eta kiga ponenimasi, apanigotc sa kiga ponenima, 8a8adj pinici nij8atcinanaj nij8asomidana8e8inaj inigik kiga ponenima. ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Mi mega oo8e ejinag8anig Kije Manido Odogima8i8in. Pejig ogima ogi onendanagoban oconiaman kidji koki ndodama8adjin kakina odanokitage8inniman. ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Maiagotc dac madjitagoban, kagi odji pidji8inagani8indjin pejig odanokitage8inniman kitci mane e mazinaamagodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ka8in dac aa anokitage8inni okackitosinagoban kidji koki ki8e migi8edj ini conian. Ki anoki dac aa ogima kidji ada8ecimagani8indjin ini anokitage8innin kidji tibenimagani8indjin, acitc kidji ada8ecimagani8indjin okokomini acitc odabinodjijimini, acitc mizi8e kakina kegoni ka tibendamindjin, kidji gi kijikadamosenig kakina inigik mezinaamagodjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Aa dac anokitage8inni ki nibak8ibanio nigan ogimakag, acitc ogi pagoseniman e inadjin: ‘8enibik kiabadj piicin! Kakina dac mizi8e kiga kijikaon.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","“Ogi kidimageniman dac aa ogima. Ogi 8anikadan kakina ka iji mazinaamagodjin, midac ka iji pagidinadjin kidji sagaamindjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Aa dac anokitage8inni ki sagaam, acitc ogi nagicka8an pejig o8idji mikimomaganan, pagi eta ka mazinaamagodjin. Ogi na8adjibinan, acitc kegat ogi kipisk8enan, e inadjin: ‘Kijikaocin inigik mezinaamaojian.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“O8idji8aganan dac ki panaskicimono8an motakamig, acitc ogi kitci pagosenimigon e igodjin: ‘8enibik kiabadj piicin! Kakina dac mizi8e kiga kijikaon!’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ka8in dac ododji kidimagenimasi8an. Tiegodj, ki anoki kidji kiba8agani8indjin kibaodimigi8amikag, pinici kakina kidji gi koki kijikagodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Apitc dac kodagiag anokitage8innig ka 8abadamo8adj adi ka pi iji8ebanig, ki kitci kackendamog acitc ogi a8i 8idama8a8an ogiman kakina ka pi iji8ebanig.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Ogima dac ogi nd8e8eman ini anokitage8innin acitc ogi inan: ‘Kimadji anokitage8inni8inan! Kakina nin nigi 8anikadan ka mazinaamaojian apitc ka pagosenimijian kidji kidimageniminan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kekin kidinendagozinaban kidji kidimagenimadj aa ki8idji8agan, tabickotc nin kagi iji kidimageniminan!’ ogi inan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Aa dac ogima ki kitci kiji8azi. Kibaodimigi8amikag dac ogi iji8ebinan ini anokitage8innin kidji kiba8agani8indjin iima pinici kakina kidji gi koki kijikazondjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Midac pejig8an ke todago8eg Nidadam 8ak8ig ka tedj pepejig e tacieg, kicpin ega enigokodeeieg ponenimeg kidjiki8e8a adi kagi pi iji madji todago8eg.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ka ick8a ikidodj ii, Jesos ogi nagadan Galilee akini, acitc ki ijagoban 8edi Coda (Judée) akikag, 8edi agamig Jourdain sibikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kitci mane a8iagon ogi nosoneogobanin, acitc ogi kigean iima ka akozindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nandam Coda8innig ka nagadjito8agobanen inakonige8inan ogi pi nazika8a8an Jesosan, kidji k8ag8e katcidina8adjin anodj kidji iji nak8e8ajii8endjin. Ogi k8ag8edjima8an dac: “Pagidini8emaganon na kidinakonige8inanan pejig nabe kidji 8ebinadjin okokomiman 8egonenigotc odji?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesos ogi nak8e8ajian: “Kana kidodji nabo8adasina8a Kije Manido Omazinaigan? Mazinadeni oo8eni: ‘Apitc ka kijendagin kakina kegonan, Kije Manido ogi kijeniman naben acitc ik8e8an.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ki ikido dac Kije Manido: ‘Ii dac odji, nabe oga naganan odadaman acitc odjodjoman, kidji 8idji8adjin okokomiman, acitc kada pejig8eiendagozi8ag e iji niji8adj.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Midac ii odji, ka8in aja nij8eiegimagani8isi8ag, mi eta motci pejig8eiendagozi8ag. Ka8in dac a8iag oda nicikebidosin Kije Manidon kagi mama8atondjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ini dac Coda8innin ka nagadjitonigobanen inakonige8inan ogi k8ag8edjimigon: “Mois dac ki inakonige oo8eni. Kicpin nabe 8i 8ebinadjin okokomiman, panima oga minan ojibiigani e tibadjimomaganig teb8e egi 8ebinadjin ini okokomiman. 8egonen dac 8edji ki inakonigedj ii8eni?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesos dac ogi nak8e8ajian: “Mois kigi pagidinigo8a kidji 8ebineg8a kikokomimi8ag, osa mega kikitci cibictig8anem. Anic dac apitc ka kijendagin kakina kegonan Kije Manido, ka8in 8in iidi ki ijinag8asiniban. ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Teb8e ki8idamonom, kicpin pejig nabe 8ebinadjin okokomiman ega kagi nodjiandjin kodagian naben, acitc niba8idj kodagian ik8e8an, madji aido8ini opabamendan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jesos dac okikinoamaganan ogi igon: “Kicpin ega kackitodj nabe kidji 8ebinadjin okokomiman 8egonenigotc odji, na8adj kada minoseni ega 8ikad kidji niba8idj!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesos ogi inan: “Ka8in kakina a8iagog okackitosina8a maiagotc kidji nisidotamo8adj oo kikinoamage8ini, nandam eta Kije Manido ominan macka8izi8ini kidji gi nisidotamindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ka8in niba8isi8ag nandam nabeg, ka8in mega okackitosina8a, mi gotc ii e to8adj ka ako nta8igi8adj. Ka8in nandam nabeg okackitosina8a kidji niba8i8adj, osa mega ki madij8agani8i8ag onini8akag. Ka8in niba8isi8ag nandam a8iagog, na8adj 8e8enda kidji gi anokita8a8adjin Kije Manidon. Aa dac a8iag ka kackitodj kidji nisidotag ii kikinoamage8ini, oda ndotan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nandam a8iagog ogi iji8ina8an abinodjijesan Jesosikag, kidji gi saminandjin acitc kidji gi aiamietama8andjin. Kikinoamaganag dac ogi kaganona8an ini a8iagon ka pidji8inandjin ini abinodjijan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesos dac ki ikido: “Pagidinikog abinodjijag kidji pi nazikaoji8adj! Ka8in odjiakegonig. A8iagog mega tabickotc abinodjijag ka apitendagozi8adj, Kije Manidon Odogima8i8inikag kada iji tibendagozi8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jesos dac ogi saminan ini abinodjijan. Midac ka iji madjadj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nigodin pejig nabe ogi pi nazika8an Jesosan, acitc ogi k8ag8edjiman: “Kikinoamage8inni! Adi ke iji mino ijitcigeian kidji gi odisigo8an kagige pimadizi8in?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesos dac ogi inan: “8egonen 8edji k8ag8edjimijian adi ke iji mino ijitcigean? Kije Manido eta teb8e mino ijitcige. Kicpin nda8endaman kagige pimadizi8in, panima ki nosoneamanin Kije Manido odinakonige8inan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ogi k8ag8edjimigon dac: “Adi ini8eni8an?” Jesos dac ogi nak8e8ajian: “Ka8in kiga nici8esim. Ka8in madji aido8in kiga pamendasina8a. Ka8in kiga kimodisim. Ka8in anodjigotc kiga iji inactaonasi8a8a kidjipimadizimi8a. ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kiga manadjia8ag kidadami8a acitc kidjodjomi8a. Kiga sagia8a kidjipimadizimi8a tabickotc kina8a ka iji sagiidizo8eg.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Midac aa ockina8e ogi inan: “Kakina nigi nosoneanan ini inakonige8inan. Adi dac kegi todaman a8acamej?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesos dac ogi inan: “Kicpin maiagotc 8i k8aiakozian, a8i ada8en kakina kidaiman, acitc ca8enimik ka kidimagizi8adj kiconiaman, midac kidji aiamanin 8anadizi8inan 8ak8ig. Pijan dac acitc nosoneocin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Apitc dac aa ockina8e ka nodag ii, ki madja acitc ki kitci kackendamise. Kitci 8anadizigoban mega. ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesos dac ogi inan okikinoamaganan: “8esa kitci sanagizi ka 8anadizidj kidji gi pidigedj Kije Manidon Odogima8i8inikag! ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Teb8e mina8adj ki8idamonom, kitci sanagizi ka nijo pik8aoganedj a8esiz kidji gi cabocta8eckapan cabonigani ka iji pagoneanig, anic dac na8adj kiabadj sanagizi a8iag ka 8anadizidj kidji gi pidigedj Kije Manidon Odogima8i8inikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Apitc dac ka nodamindjin okikinoamaganan adi kagi ikidodj Jesos, ogi kitci mamakazitagon acitc ogi k8ag8edjimigon: “A8enen dac kegi ag8acimagani8idj?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesos ogi kana8abaman okikinoamaganan, acitc ogi inan: “Ka8in a8iagigotc kadagi ag8acimidizosi. Kije Manido dac 8in kakina kegoni okackiton.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pien dac ogi inan: “Nina8it, kakina kegon nigi nagadananan acitc kigi nosoneogo. 8egonen dac ke odisigo8ag?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesos dac ogi nak8e8ajian: “Teb8e ki8idamonom, apitc Kije Manido koki ojitodjin kakina kegonan, Ka pi Anicinabe8iidizodj kada taji abi odogima8i tesabi8aganikag ka kitci icpendag8anig. Ii dac apitc, kina8a ka midatcin acitc nijieg kagi nosoneojieg, kiga abim kekina8a pepejig e tacieg kidogima8i tesabi8agani8akag, kidji tibakoneg8a ka midatcin acitc niji8adj ka inakanezi8adj Israel a8iagog. ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kakina a8iagog ke nagadamo8ag8en omigi8ami8an kek8an okitigan aki8an kidji nosoneoji8adj, kek8an ke nagana8ag8en o8idjiki8e8an, odadami8an, odjodjomi8an, kek8an odabinodjijimi8an kidji nosoneoji8adj, oga odisigona8an midasomidana a8acamej ini kegonan, acitc oga aiana8a kagige pimadizi8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mane dac a8iagog nogom ma8adji ka kitci apitendagozi8adj, ma8adji kada kitci tabasendagozi8ag ii apitc, acitc mane a8iagog nogom ma8adji ka kitci tabasendagozi8adj, ma8adji kada kitci apitendagozi8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesos mina8adj ki ikidogoban: “8adan oo ejinag8anig Kije Manido Odogima8i8in. Nigodin 8ibadj e kijeba8acinig pejig a8iag ka tibendag kitigan akini ki sagaamogoban e nanada 8abamadjin nandam anokitage8innin kidji gi mikimondjin okitigan akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ki nakomo dac kidji kijika8adjin pepejig ini anokitage8innin pejig 8abiconia8abikon pejigokajik e mikimondjin. Ogi ijinija8an dac kidji nda mikimondjin okitigan akikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ki koki sagaamogoban dac mina8adj 8aiej e cagidasotibaiganeanig e kijeba8acinig. Ogi odji 8abaman dac nandam kodag a8iagon e paba naniba8indjin ka iji ada8ani8anig, ega e nigod ijitandjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ogi inan dac: ‘A8i mikimok kekina8a nikitigan akikag. K8aiak dac kiga kijikaonom.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ki ija8ag dac kitigan akikag.” “Aa8e dac ka tibendag kitigan akini mina8adj ki koki sagaamogoban 8aiej e abitakijiganigobanen acitc mina8adj 8aiej e ani nisotibaiganeanigobanen e ick8a abitakijiganig, acitc mi pejig8an ka todag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kegapitc dac, 8aiej e nanotibaiganeanigobanen e ick8a abitakijiganig, mina8adj ki koki sagaamogoban acitc ogi odji mika8agoban nandam kodagian naben kiabadj e paba naniba8indjin ka iji ada8ani8anig ega e nigod ijitandjin. Ogi k8ag8edjiman dac: ‘8egonen 8edji paba naniba8ieg ooma kabe kijik, ega e nigod ijitaieg?’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ogi nak8e8ajiigon dac: ‘Ka8in mega a8iag nidodji anonigosinan.’ ” “Ogi inan dac: ‘A8i mikimok sa kekina8a nikitigan akikag.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Apitc dac e ani onag8icinig, aa8e ka tibendag kitigan akini ogi inan ini ka kackakanandjin kakina anokitage8innin: ‘Nd8e8emik kakina anokitage8innig, acitc kijikaok egi mikimo8adj. Igi8e dac ick8eag kagi anonagani8i8adj nitam kiga kijika8ag, acitc dac igi8e nitam kagi madjita8adj, ick8eag kiga kijika8ag.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Igi8e dac kagi madjita8apan kidji mikimo8adj e nanotibaiganeanig e ick8a abitakijiganig ki pija8ag, acitc pepejig ki minagani8i8ag pejig 8abiconia8abikon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Apitc dac ka pija8adj igi8e nitam kagi madjita8apan kidji mikimo8adj, ogi inendana8aban na8adj mane conian kidji kackia8adjin. Anic dac ke8ina8a pepejig ki minagani8i8ag pejig 8abiconia8abikon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Apitc dac ka minagani8i8adj oconiami8an, ogi kitci kiji8aigo8an ini8e ka tibendamindjin kitigan akini. ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ogi ina8an dac: ‘Igi8e anokitage8innig ick8eag ki madjita8ag, pejigotibaigan eta inigik ki mikimo8ag, tabickotc dac nina8it ka iji kijikaojiag kigi iji kijika8ag, nina8it kagi kitci aiekoziag kabe kijik egi mikimo8ag meg8adj e kitci kijateg!’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Aa8e dac ka tibendag kitigan akini ogi nak8e8ajian pejig ii e tacindjin anokitage8innin: ‘Ni8idji8agan! Ka8in kidodji 8aiejimisinon. Kigi nakomonan kidji mikimo8an pejig 8abiconia8abik kidji kijikago8an pejigokajik, kana? ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Odapinan sa dac kikackitason acitc madjan. Mi pejig8an 8a iji kijika8ag aa8e ick8eag kagi madjitadj tabickotc kin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nin mada aa niconiam. Niga inabadjia dac gotc adi 8a inabadjiag, kana? Kek8an kidodendan na osa e minodeeian?’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jesos dac ogi inan okikinoamaganan: “Midac ejinag8ag, igi8e nogom ick8eag ka te8adj, nigan kada te8ag, acitc dac igi8e nogom nigan ka te8adj, ick8eag kada te8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Meg8adj Jesos e pimi ijagobanen Jerusalem odenakag, ogi ma8adjian ka midatcin acitc nijindjin okikinoamaganan, acitc ogi aiamian 8ina8a eta meg8adj e pimode8adj, e inadjin: ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ndotamok! Jerusalem kidijamin. Iima dac, nin, Ka pi Anicinabe8iidizodj, niga takonigo, acitc niga tibenimigog Coda8inni kitci aiamie ogimag acitc Coda8inni kikinoamage8innig. Niga ick8aienimigog dac. ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Niga iji8inigog ega ka Coda8inni8indjin kidji tibenimijindjin. Igi8e dac niga manenimigog, niga papajacteogog, acitc niga acidak8aogog tcibaiatigokag. Ki nisogonaganig dac, niga abidjiba8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kegapitc Zebedee odik8eman ogi pi nazika8ani Jesosan, kigi midjinijin og8izisan. Ogi nibak8ita8an dac, kegoni e pagosenimadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesos dac ogi k8ag8edjiman: “8egonen neda8endaman?” Ogi nak8e8ajiigon dac: “Kinada8enimin kidji ijian kidji kitci apitendagozi8adj ogo8e ka niji8adj nig8izisag kidogima8i8inikag, kidji abi8adj dac opimena kinikag, pejig kikitcinikikag acitc pejig kinamadinikikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesos dac ogi inan Jakan acitc Johnan: “Ka8in kikikendasina8a 8egonen e k8ag8edjimijieg. Kikackitona8a na kidji kodagito8eg adi nin ke iji kodagito8an?” Ki ikido8ag dac: “Ee, nikackitonanan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesos dac ogi inan: “Teb8e kiga kodagitom adi ke iji kodagito8an. Anic dac ka8in nin ke onaco8anag a8enen ke pi abidj nikitcinikikag kek8an ninamadinikikag. Nidadam aja ogi onendan a8eneni8an ke abindjin iima.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Apitc kodagiag ka midatci8adj kikinoamaganag ka nodamo8adj ii, ogi kitci kiji8aigo8an ini ka nijindjin e iji 8idjiki8edindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesos dac ogi nd8e8eman kakina okikinoamaganan acitc ogi inan: “Kikikenima8ag igi8e ka ogima8i8adj ooma akikag kitci kacka8enimidizo8ag, acitc igi8e ka kitci apitendagozi8adj okitci 8i abadjitona8a omacka8izi8ini8a. ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ka8in dac kina8a kida todasina8a iidi. Tiegodj, kicpin pejig aa8e e tacieg 8i kitci apitendagozidj, panima ki anokitago8eg, ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","acitc kicpin pejig aa8e e tacieg 8i kitci niganizidj, panima ki tabasenimidizodj, tabickotc anokitage8inni ka tibenimeg kidji inenimidizodj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Midac pejig8an, kenin, Ka pi Anicinabe8iidizodj, ka8in nidodji pijasi kidji anokitago8an. Nigi pija dac kidji anokitageian, acitc kidji migi8eian nipimadizi8in kidji gi odji ag8acimag8a mane a8iagog.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Apitc Jesos acitc okikinoamaganan ka nagadamo8adj Jeriko (Jéricho) odenani, mane a8iagon ogi nosoneogo8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nijin nabeg ega e 8abi8adj taji abi8agoban opimekana. Apitc dac ka nodage8adj Jesosan kidji pimi ijandjin iima, ki madji pabibagi8ag: “Tebendjigean! Ogima David odanike ojisan! Kidimagenimicinam!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mane a8iagon ogi kaganonigo8an acitc ogi igo8an kidji ponimo8adj. Na8adj dac kiabadj ki kiji8e8agoban e pabibagi8adj: “Tebendjigean! Ogima David odanike ojisan! Kidimagenimicinam!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesos ki kibitcigaba8i, ogi nd8e8eman, acitc ogi k8ag8edjiman: “8egonen eji nda8endameg kidji todaonagok?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ogi nak8e8ajia8an dac: “Tebendjigean! Kipagosenimigo kidji kigeijiag kidji gi 8abiag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ogi kidimageniman dac Jesos, acitc ogi taginan ockijigoni. Teci8ag dac ogi kackitona8agoban kidji 8abi8adj, acitc ogi nosone8a8an Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Apitc Jesos acitc okikinoamaganan e ani pec8abadamo8adj Jerusalem odenani, pecodj Betapaje (Bethphagé) odenajicini ani tebanig, Olip (Oliviers) pik8adinajic ka iji tag8ag. Iima dac, Jesos ogi niganinija8an nijin okikinoamaganan, ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","acitc ogi inan: “A8i ijaok 8edi odenajicikag nigan ka tag8ag. Iima dac kiga mika8a8a pejig noje misaboz e sagapizodj, kigi omisabozociman. Pagidabaokog dac acitc pidji8ijikog ooma. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kicpin dac kegon igo8eg, nak8e8ajit8ag oo8e: ‘Ka Tibendjigedj onada8eniman,’ teci8ag dac kada pagidinagani8i8ag,” ogi inan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Midac ii kidji gi iji8ebag 8eckadj kagi ikidodj niganadjimo8inni: ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“8idamaokog oo8eni a8iagog Sion odenakag ka tajike8adj: Kijigabamik! Kipi nazikago8a kidogimami8a, ka kitci nokadizidj. Misabozokag dac iji 8agida8aganebi. Misabozocikag pi iji 8agida8aganebi.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ki madja8ag dac igi ka niji8adj kikinoamaganag, acitc ki ijita8ag adi kagi igo8apanin Jesosan kidji todamo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ogi iji8idama8a8an dac Jesosan ini noje misabozon acitc omisabozocimini. Ogi pakidjisidona8an dac opizika8agani8an 8agidj misabozokag acitc 8agidj misabozocikag, acitc Jesos ki 8agida8aganebi ini misabozon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kitci mane a8iagog ogi taj8egisidona8an opizika8agani8an mikanakag taji Jesosan ke ani ijandjin. Kodagiag dac a8iagog ogi ndogaana8an 8adik8anan acitc ogi atona8an iima mikanakag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","A8iagog ka pimose8apan nigan Jesosikag, acitc ke8ina8a igi8e ka nosone8a8agobanen, kitci pabibagi8agoban: “Kitcit8a8endagozi ogima David odanike ojisan! Ca8endagozi aa8e ka Tibendjigendjin kagi pidjinijaogodjin! Kitcit8a8endagozi Kije Manido icpimig ka tedj!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Apitc Jesos ka pidigedj Jerusalem odenakag, kakina a8iagog iima ka tajike8apan ogi kitci ki8ack8eiendamiigona8a adi eji8ebanig. “A8enen dac aa nabe?” iji k8ag8edjimidibanig. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mane dac a8iagog ogi nak8e8ajia8an: “8in aa niganadjimo8inni, Jesos ka ijinikazodj, Nazaret odenakag 8edi Galilee akikag ka odjidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesos dac ki pidige Coda8inni kitci aiamiemigi8amikag, acitc ogi sagidjinija8an kakina a8ian ka ada8endjin acitc ka kicpinadjigendjin iima. Ogi k8anabi8ebinanan o8isini8agani8an ini8e ka meckodonandjin conian acitc otesabi8agani8an ini8e ka ada8endjin omimin ka 8abizindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ogi inan dac: “Mazinadeni Kije Manido Omazinaiganikag: ‘Kidji iji aiamiani8ag kada inabadan nimigi8am.’ Kina8a dac, kimodi8innimigi8am kidinabadjitona8a,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ega ka 8abindjin acitc ega ka kackitondjin kidji pimosendjin ogi pi nazikagon Jesos iima kitci aiamiemigi8amikag, acitc ogi kigean. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Coda8inni kitci aiamie ogimag acitc Coda8inni kikinoamage8innig ogi 8abadana8an ini kegonan ka kitci mamakadendag8anigin kagi todamindjin Jesosan, acitc ogi noda8a8an abinodjijan kitci aiamiemigi8amikag e pabibagindjin: “Kitcit8a8endagozi ogima David odanike ojisan!” Ki kitci nickadizi8ag dac. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ogi ina8an dac Jesosan: “Kinoda8ag na adi ekido8adj?” Jesos dac ogi nak8e8ajian: “Ee, ninoda8ag. Mazinadeni Kije Manido Omazinaiganikag: ‘8a8adj abinodjijag acitc tcidjicag kigi kikinoama8ag kidji icpenimik8a.’ Kana dac 8ikad kidodji nabo8adasina8a ii?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jesos dac ogi naganan ini Coda8innin, acitc Jerusalem ki odji madja, Betani (Béthanie) odenakag kidji ijadj. Ki niba dac iima. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","8ibadj dac 8iabanig, apitc Jesos e ani koki ijagobanen Jerusalemikag, ki kitci mamida8askadegoban. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ogi 8abaman dac pejig minatigon e padakicinindjin opimekana mikanakag, acitc dac ogi nazika8an. Nibicibagon dac eta o8abadanabanin. Jesos dac ogi inan ini minatigon: “Ka8in 8ikad mina8adj kiga mini8isi!” Teci8ag dac aa minatig ki kitci pasogoban. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Okikinoamaganan ogi 8abamigon adi ka todag acitc ki kitci mamakadendamon. Ogi k8ag8edjimigon dac: “Adi ka ijisedj 8edji kitci kaiezigotc ki pasodj aa minatig?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesos dac ogi nak8e8ajian: “Teb8e ki8idamonom, kicpin teb8etameg, acitc ketcinamendameg, kekina8a kida kackitona8a kidji toda8eg adi kagi toda8ag aa minatig. Acitc dac 8a8adj kigagi idana8a ii pik8adina: ‘Ta8ickan iima acitc pakobi8ebinidizon kitcigamikag,’ midac iidi ke ijiseg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kicpin teb8etameg, kakina kegon ke iji pagosendameg e aiamieieg kiga odisigona8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesos ki pidige kitci aiamiemigi8amikag, acitc ki madji kikinoamage. Nandam Coda8inni kitci aiamie ogimag acitc ka niganizi8adj Coda8innig ogi pi nazika8a8an acitc ogi k8ag8edjima8an: “8egonen 8edji todamanin ini kegonan? A8enen kagi pagidinik kidji todaman ii?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesos ogi nak8e8ajian: “Nintam kegon kiga k8ag8edjiminom. Kicpin dac nak8e8ajiijieg, kiga 8idamonom 8egonen 8edji kackito8an kidji todamanin ini kegonan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","8idamaocik dac, a8enen ka pidjinija8adjin Cabadisan kidji sigaadagendjin, Kije Manido na, kek8an a8iagog?” Igi8e dac Coda8innig ki kitci aiamiidi8ag 8ina8a tibina8e, e inidi8adj: “Kicpin nak8e8ajit8aiak: ‘Kije Manido ka pidjinija8adjin Cabadisan,’ kiga k8ag8edjimigonan: ‘8egonen dac 8edji ega ki teb8eta8eg Cabadis?’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kicpin dac ikido8ak: ‘A8iagog ka pidjinija8a8adjin Cabadisan,’ panima ki kosaiakonig a8iagog adi ke inakamigizi8adj. Kakina mega inendamog e niganadjimo8inni8inipanin ini Cabadisan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ogi nak8e8ajia8an dac Jesosan: “Ka8in nikikenimasi8anan a8enen kagi pidjinija8adjin.” Jesos dac ogi inan: “Misa dac kenin ka8in kiga 8idamaosinonom 8egonen 8edji todamanin ini kegonan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesos dac mina8adj ogi inan: “Adi enendameg oo adisokan? Pejig nabe nijibanin og8izisan. Ogi inan dac ka keteadizindjin: ‘Nig8izis! Nda mikimon ogajigag kitigan akikag.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Og8izisan dac ogi nak8e8ajiigon: ‘Ka8in ni8i nda mikimosi ogajigag.’ Nage dac ki ani adendamon, midac ka iji nda mikimondjin kitigan akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Aa dac nabe ogi aiamian kodagian og8izisan, acitc mi pejig8an ka inadjin. ‘Aode, Papa’ ki ikido8an, ka8in dac ki odji ijasi8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Adi dac aa8e eji niji8adj enendameg ka ndota8adjin odadaman?” Ki ikido8ag: “Nitam og8izisan.” Jesos dac ogi inan: “Teb8e ki8idamonom, igi8e ka ma8adjia8adjin kitci ogiman oconiamini, acitc madji ik8e8ag, misa8adj ka kitci patadi8adj, na8adj oga kackitona8a kidji pidige8adj Kije Manidon Odogima8i8inikag, apitc8in kina8a. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Cabadis mega ki pija kina8akag, e 8abadaigo8eg adi eji nda8enimigo8eg Kije Manido kidji inadizieg. Ka8in dac kidodji teb8eta8asi8a8a Cabadis. Igi8e dac ka ma8adjia8adjin conian kitci ogiman odji, acitc madji ik8e8ag, ogi teb8eta8a8an Cabadisan. Misa8adj egi 8abadameg ii, ka8in kidodji an8endizosim kidji teb8eta8eg.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“K8ag8e nisidotamok oo8e kodag adisokan. Pejig nabe ki kitigegoban cominici kitiganan odakikag. Ki meniganatigoke dac 8ajagam okitigan akikag, kijadj ki monaige ke iji cacagocka8agani8indjin cominican, acitc ogi ojiton tecibidagani kidji gi odji nagadjitodj okitigan aki. Mina8adj dac ogi a8ian nandam kodagian kitige8innin okitigan aki, midac ka iji nda pabamadizidj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Apitc ka ani odjitcisenig kidji ma8adjiagani8indjin ini cominican, aa nabe ogi ijinija8an nandam odanokitage8inniman kidji nda 8abamandjin ini a8iagon kagi a8iadjin okitigan aki, kidji a8i nadji8inandjin inigik cominican kagi inendagozinipanin kidji minigodjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Igi8e dac kitige8innig ogi na8adjibina8an ini anokitage8innin. Pejig dac ini ogi migana8an, kodagian ogi nisa8an, ick8eag dac ini8e ogi pabim8asinaa8an pinici kidji abida8a8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Aa dac ka tibendag kitigan akini mina8adj ogi ijinija8an kodagian odanokitage8inniman 8edi okitigan akikag, na8adj mane ogi ijinija8an apitc8in ockadok. Midac maia pejig8an ka toda8a8adjin igi madji kitige8innig. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ick8eag dac, ogi ijinija8an og8izisan, e inendag: ‘Oga manadjia8an nig8izisan.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Apitc dac igi kitige8innig ka 8abama8adjin okackami8an og8izisini, ki inidi8ag: ‘Mi aa ockina8e nage ke kacka8idj ick8a nibondjin odadaman. A8isa nisadan, kina8it dac kiga tibendam8anan ii okitigan aki.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ogi na8adjibina8an dac ini ockina8en, ogi sagidji8ebina8an iima kitigan akikag, acitc ogi nisa8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jesos dac ogi k8ag8edjiman Coda8innin: “Apitc dac tag8icig aa ka tibendag kitigan akini, adi ke toda8adjin ini kitige8innin?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ogi nak8e8ajiigon dac: “Oga nisan ini madji a8iagon, ega odji pejig kidji kidimagenimadjin. Oga a8ian dac kodagian kitige8innin okitigan aki, ke minigodjin cominican ka inendagozidj kidji aia8adjin apitc odjitcisenig kidji ma8adjiandjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesos dac ogi inan: “Mazinadeni Kije Manido Omazinaiganikag: ‘Migi8amike8innig ogi ana8enima8an ini asinin. Anic dac mi aa asini ma8adji ka ani kitci apitendagozidj. Ka Tibendjigedj dac ii ka todag, kikitci mamakadendananan dac e 8abadamak.’ Kana dac 8ikad kidodji nabo8adasina8a ii? ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Mi 8edji 8idamonagok oo8e. Kiga makamigom Kije Manido Odogima8i8in. Kada minagani8i8ag dac kodagiag a8iagog ke iji pimadizi8adj adi ka iji nda8endamindjin Kije Manidon kidji todamo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kada ojig8icin aa8e ke pagicinog8en iima asinikag, acitc kicpin pejig a8iagokag inagodjinindjin ini asinin, oga cacagockagon.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Igi8e Coda8inni kitci aiamie ogimag acitc Coda8innig ka nagadjito8agobanen inakonige8inan ogi noda8a8an Jesosan e inadisokendjin e kikinoamagendjin, acitc ogi nisidota8a8abanin egi mikomigo8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ogi nanada8i kikendana8a dac adi ke todamo8apan kidji gi takona8adjin Jesosan. Pekic dac ogi kosa8abanin ini mane a8iagon “niganadjimo8inni8i Jesos” ka inenimandjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesos mina8adj ogi abadjitonagobanin adisokanan kidji kikinoama8adjin a8iagon. Ogi inan dac: ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“8adan oo8e ejinag8anig Kije Manido Odogima8i8in. Nigodin pejig ogima odojitonagoban kidji kitci magocani8anig e niba8indjin og8izisan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ogi ijinija8an dac odanodaganan kidji nda 8idama8andjin ini a8iagon kagi nd8e8emadjin kidji pi nda 8isinindjin. Ka8in dac 8i pijasinigoban ini8e kagi nd8e8emadjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Ogi ijinija8an dac aa ogima kodagian odanodaganan e inadjin: ‘Ijikog igi ka nd8e8emag8a: Meg8adj taji ojitcigade nimagocan nogom. Ninabe mictozomag acitc ka kitci pimideo8adj nida8esizimag ki nisagani8i8ag, kakina dac aja ick8atani8an. Pi nda 8isiniok dac.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Igi8e dac kagi nd8e8emagani8i8adj ka8in ododji pabiziskenimasi8a8an, acitc ki nda mikimo8ag, pejig okitigan akikag, kodag dac odada8agamigokag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nandam dac kodagiag kagi nd8e8emagani8i8adj ogi na8adjibina8an ini ogiman odanodagani, ogi manenima8an acitc ogi nisa8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ki kitci nickadizi dac aa ogima. Ogi ijinija8an dac ocimaganiciman kidji nda nisandjin ini8e nici8e8innin, acitc ododenamini kidji sakaamindjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Ogi inan dac odanodaganan: ‘Aja ick8a ojitcigade niba8i magocan, ka8in dac odji kackitamadizosi8ag kidji pija8adj igi kagi nd8e8emagani8i8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","A8i ijaok dac 8edi kitci mikanakag, acitc nd8e8emikog kakina igi8e ke 8abameg8a.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Midac ka iji ija8adj mikanakag igi anodaganag, acitc ogi ma8adjia8an kakina ini8e kagi mika8a8adjin, madji a8iagon acitc dac mino a8iagon. Midac panima iidi ka ani iji kitci manenani8ag ka iji magocani8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Aa dac ogima ki pi pidige ka iji magocani8anig e nda pojoka8adjin ini8e kagi pijandjin. Ogi odji 8abaman dac pejig naben iima, ega egi pisikamindjin pitcikonaani ka minapanin a8iagon kidji ijikonaendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ogi inan dac: ‘Ni8idji8agan! Adi 8edji ki pidigean ooma ega k8aiak e ijoo8an?’ Ka8in dac kegon odji nak8e8ajit8asi aa nabe.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Aa dac ogima ogi inan odanodaganan: ‘Nabogadepinik acitc nabonikepinik, midac iji8ebinik ka iji kacki tibikanig. Iima dac kada kitci ma8i acitc kada kitci mamad8eabidecka ke apitci kodagitodj.’ ” Mi ka inadisokedj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Mina8adj dac Jesos ki ikido: “Kitci mane nd8e8emagani8i8ag, nandam dac eta onabamagani8i8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Coda8innig dac ka nagadjito8agobanen inakonige8inan ki ma8adjiidi8ag kidji onendamo8adj adi kegi iji k8ag8ed8e8apan kidji gi katcidina8adjin Jesosan anodj kidji iji nak8e8ajii8endjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ogi ijinija8a8an dac nandam okikinoamagani8an acitc nandam kitci ogima Herod odanodaganan kidji nda 8idama8andjin Jesosan: “Kikinoamage8inni! Nikikendananan kin e teb8ean. K8aiak kikikinoamage adi ke todjigadenig 8e8enda kidji gi nosoneigadenig Kije Manido omikana. Ka8in kikosasi8ag adi enendamo8adj a8iagog, ka8in mega kipabiziskendasin adi eji apitenimagani8idj a8iag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","8idamaocinam dac, ikidomaganon na kidinakonige8inanan kidji kijika8aiak ma8adji kitci ogima Sesar (César), Rom ka tajikedj, kek8an ka8in?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesos dac ogi kikeniman ini8e a8iagon adi eji k8ag8e 8agackibinigodjin. Ogi inan dac: “Kikitci kimodizim! 8egonen 8edji k8ag8e katcidinijieg anodj kidji iji nak8e8ajii8eian? ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","8abadaicik conias ka abadjiagani8idj kidji kijika8agani8idj kitci ogima.” Ogi 8abadaa8an dac pejig coniasan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesos dac ogi k8ag8edjiman: “Kana8abamik 8aa conias. A8enen aa ka mazinazodj? A8enen ii o8izon?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Kitci ogima Sesar,” ogi ina8an. Jesos dac ogi inan: “Mijik sa dac kitci ogima Sesar kegoni ka tibendag, acitc Kije Manido mijik kegoni ka tibendag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Apitc dac ka nodamo8adj ii adi kagi iji nak8e8ajiagani8i8adj, ki kitci mamakadendamog. Ogi nagana8an dac Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Pejig8an ii apitc e kijigag, nandam Coda8innig “Sadose8innig” (Sadducéens) ka ijinikazo8adj ogi pi nazika8a8an Jesosan. Mi igi ako ka ikido8adj ega kidji abidjibandjin a8iagon. Ogi pi k8ag8edjima8an dac Jesosan: ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Kikinoamage8inni! Mois kigi minigonanaban oo8e inakonige8ini: ‘Kicpin pejig nabe odji nibodj, ega egi aia8adjin abinodjijan, inendagozi8an o8idjiki8en kidji iji niba8indjin okokomiman, kidji gi odabinodjijimiadjin o8idjiki8en kagi nibondjin.’ Mi ka inakonigedj Mois. ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nigodin dac nina8itinakag tebanig e nij8atci8apan nabeg e iji 8idjiki8emidi8adj. Kitci oseezima dac ki niba8i, acitc ki nibo ega egi tendjin odabinodjijiman. Midac o8idjiki8en ka iji niba8indjin okokomiman. ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ke8in dac ki nibo ega egi aia8adjin abinodjijan. Midac pejig8an ka ijisendjin mina8adj ini8e o8idjiki8en, acitc mi pejig8an kakina ka ani ijise8adj kakina eji nij8atci8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ick8eag dac igi8e kakina, aa ik8e ke8in ki nibo. ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Apitc dac odjitcisenig kidji abidjiba8adj ka nibo8adj, adi ini8e maia ke iji o8idigemaganidj aa ik8e? Kakina mega ka nij8atci8adj igi nabeg ki iji niba8i8ag ini pejig8an ik8e8an!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesos dac ogi nak8e8ajian: “Anodj kidinendana8a. Ka8in mega kikikendasina8a Kije Manido Omazinaigan kek8an omacka8izi8in. ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Apitc ki abidjiba8adj igi kagi nibo8adj, ka8in kada niba8isi8ag nabeg acitc ik8e8ag. Tiegodj, mi maia pejig8an ke iji pimadizi8adj ajenin ka iji pimadizindjin 8ak8ig ka tendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kicpin dac 8i kikendameg ke apitci abidjiba8ag8en kagi nibo8adj, kana panima kida nabo8adasina8a adi eji 8idamago8eg Kije Manido Omazinaiganikag oo8e ekidodj? ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nin Abanaam (Abraham), Aisik (Isaac) acitc Tcekap (Jacob) Okije Manidomi8an,’ ki ikido. Kije Manidon dac 8in Okije Manidomi8ag igi8e ka pimadizi8adj, ka8in 8in igi8e kagi nibo8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kakina dac a8iagog ka noda8a8adjin Jesosan adi kagi iji nak8e8ajitagendjin, ogi kitci mamakazita8a8an adi eji kikinoamagendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Apitc Coda8innig ka nagadjito8agobanen inakonige8inan ka nodage8adj adi kagi iji cagozomandjin Jesosan ini Sadose8innin, ki ma8adjiidi8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Pejig e taci8adj, e Coda8inni kikinoamage8inni8idj, o8i k8ag8e katcidinabanin Jesosan anodj kidji pitci odji ikidondjin. Ogi k8ag8edjiman dac: ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Kikinoamage8inni! Kidinakonige8inanakag, adi ii8e inakonige8in ma8adji ketci apitendag8anog8en?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesos dac ogi nak8e8ajian: “ ‘Kiga sagia8a ka Tibendjigedj Kikije Manidomi8a enigokodeeieg, enigokodjitcagocieg, acitc enigokomidonendjiganieg.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mi oo8e ma8adji ketci inendag8ag acitc ketci apitendag8ag inakonige8in. ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","8adan dac oo8e kodag inakonige8in, pejig8an ketci apitendag8ag apitc8in kodag: ‘Kiga sagia8a kidjipimadizimi8a tabickotc kina8a ka iji sagiidizo8eg.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kakina dac Mois odinakonige8inan acitc kakina niganadjimo8innig okikinoamage8ini8an, mi kakina eji pagisigin ono8edi ka nijigin inakonige8inan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Meg8adj igi8e Coda8innig ka nagadjito8agobanen inakonige8inan kiabadj ma8adjiidibanig iima, Jesos ogi k8ag8edjiman oo8eni: ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Adi enenimeg aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin? Adi enenimeg 8edadabigicig?” Ogi nak8e8ajia8an dac: “Ogima David ini odanike ojisan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesos dac ogi inan: “Adi dac 8edji ki ijiseg David kidji ijinikanadjin ‘Tebendjigean’? David mega, e kigickagodjin Mino Manidon, ki ikidogoban oo8eni: ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ka Tibendjigedj ogi inan ka Tibenimijindjin: Nikitcinikikag iji pi nda abin, pinici kidji cagodjiag8a ka madjenimik8a, kinikag kidji iji tabasendizo8adj.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David dac ‘Ka Tibenimijidj’ odijinikanan ini a8ian Kije Manidon kagi ikidonipanin kidji pidjinija8andjin. Adi dac kegi odji ijisedj David kidji odanike ojisidj ini?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ka8in odji pejig a8ian iima ka tenipan ododji kackiigosin kidji nak8e8ajiigodjin. Ick8a dac ii, ka8in mina8adj a8ian kegoni ododji k8ag8edjimigosin. Kakina mega cag8enimobanin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesos dac ogi aiamian okikinoamaganan acitc kodagian a8iagon iima ka tendjin, ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","e inadjin: “Coda8inni kikinoamage8innig acitc Coda8innig ka nagadjito8adjin inakonige8inan kikinoamage8ag adi ekidomaganigin Mois odinakonige8inan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kidinendagozim dac kidji ndota8eg8a, acitc kidji todameg kakina adi ego8eg kidji todameg. Anic dac ka8in kagikina8abamakegonig adi ka inadizi8adj. Ka8in mega onosoneasina8an 8ina8a tibina8e okikinoamage8ini8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kitci mane inakonige8inan omina8an a8iagon, e kitci sanagiigondjin kidji nosoneamindjin. Ka8in dac 8a8adj o8idjiasi8a8an kidji nosoneamindjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Kakina ka ijita8adj, kidji motci pabiziskenimigo8adjin a8iagon eta 8edji ijita8adj ii. Odani micatona8a ii mitigo8ajicini ka panaskapido8adj oskatigo8akag acitc oniki8akag, taji ka iji pidjisinigin nandam mazinaiganesan eji mazinadenig pagi Kije Manido Omazinaigan adi ekidomaganig. Acitc odani kagan8abigitona8an odagog8adjigani8an odaimi8akag, ‘kitci aiamie8ag’ kidji inenimagani8i8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ma8adji dac ka iji min8acinig 8i iji abi8ag e magocani8anig, acitc ma8adji ke iji paietenagozi8adj 8i iji abi8ag Coda8inni aiamiemigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kitci min8endamog e anamika8agani8i8adj ka iji manenani8anig, acitc ‘Kikinoamage8inni’ e ijinikanigo8adjin a8iagon.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Kina8a dac 8in, ka8in pagidinakegon a8iag ‘Kikinoamage8inni’ kidji ijinikanigo8eg. Motci pejigo mega eta kikikinoamage8innimi8a, acitc kakina tabickotc kidapitendagozim, mi maia pejig8an eji 8idjiki8edieg ejinagozieg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Motci pejigo eta Kidadami8a, mi aa Kije Manido, 8ak8ig ka tedj. Ka8in dac ‘Nidadaminan’ kiga ijinikanasi8a8a a8iag ooma akig kidji gi odji manadjieg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Motci pejigo eta kidogimami8a, mi aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin. Ka8in dac pagidinakegon a8iag ‘Ogima’ kidji ijinikanigo8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Aa8e dac ma8adji ka apitendagozidj kina8akag, inendagozi kidji anokitago8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","A8enenigotc dac icpenimidizodj, kada tabasendagozi, anic dac a8enenigotc tabasenimidizodj, kada icpendagozi.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Kiga kitci madji iji8ebizim, kina8a Coda8innig ka kikinoamageieg acitc kina8a ka nagadjito8egon inakonige8inan! Kikitci kimodizim! Kinagabina8ag a8iagog kidji pidige8adj Kije Manidon Odogima8i8inikag. Kina8a tibina8e ka8in kipidigesim, acitc dac ka8in kipagidinasi8a8ag kidji pidige8adj igi8e ka 8i pidige8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Kiga kitci madji iji8ebizim, kina8a Coda8innig ka kikinoamageieg acitc kina8a ka nagadjito8egon inakonige8inan! Kikitci kimodizim! Kikimodima8ag ik8e8ag ka pejigo8adj kakina odaimi8an, pekic dac kitci kin8ej kidaiamiem kidji mino inabaminagozieg. Midac ke odji na8adj kitci sogi pajacteogo8eg kina8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kiga kitci madji iji8ebizim, kina8a Coda8innig ka kikinoamageieg acitc kina8a ka nagadjito8egon inakonige8inan! Kikitci kimodizim! Kikitci paba ijam kitcigamig acitc mizi8ekamig, kidji gi kackimeg eta pejig a8iag kidji nosoneagin Coda8inni Inakonige8inan. Apitc dac ki iji kackimeg, mi eta nijinanaj a8acamej kackitamadizo kidji iji8ebinagani8idj kitci ickodekag apitc8in kina8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kiga kitci madji iji8ebizim, kina8a mi maia tabickotc ega ka 8abi8adj ka ijinagozieg, ka k8ag8e kikino8ina8adjin kodagian a8iagon! Kidikidom oo8e: ‘Kicpin a8iag ikidodj kegoni kidji todag, “Kitci aiamiemigi8amikag nidodji teb8e” e ikidodj, ka8in nigod kicpin ega todag ii kagi ikidopan. Kicpin dac ikidodj: “Ka iji oza8iconia8ag kitci aiamiemigi8amikag nidodji teb8e,” panima oga todan adi kagi ikidopan,’ kidikidom. ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kikitci ki8ack8em acitc mi maia tabickotc ega ka 8abi8adj epitendagozieg, ka8in mega kegon kinisidotasina8a! Na8adj na apitendagozi oza8iconia, kek8an kitci aiamiemigi8am? Kitci aiamiemigi8am sa ma8adji apitendag8an, acitc mi eta egi abadizidj oza8iconia kitci aiamiemigi8amikag 8edji kitcit8a8endagozidj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kidikidom acitc oo8e: ‘Kicpin a8iag ikidodj kegoni kidji todag, “Kitcit8a 8isini8aganikag taji ka iji icpenimagani8idj Kije Manido nidodji teb8e” e ikidodj, ka8in nigod kicpin ega todag ii kagi ikidopan. Kicpin dac ikidodj: “8iasikag kagi pagidinigetama8agani8idj Kije Manido iima kitcit8a 8isini8aganikag nidodji teb8e,” panima oga todan adi kagi ikidopan,’ kidikidom. ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mi maia tabickotc ega 8abiegoban ejinagozieg! Adi ii8e ma8adji epitendag8anog8en, pagidinige8in kek8an kitcit8a 8isini8agan? Kitcit8a 8isini8agan sa ma8adji apitendag8an, acitc mi eta egi iji 8agidatcigadeg pagidinige8in iima kitcit8a 8isini8aganikag 8edji kitcit8a8endag8ag pagidinige8in. ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Aa8e dac ka ikidodj: ‘Kitcit8a 8isini8aganikag nidodji teb8e,’ maiagotc ikido: ‘Kitcit8a 8isini8aganikag acitc kakina kegon iima ka atcigadeg nidodji teb8e.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aa8e dac ka ikidodj: ‘Kitci aiamiemigi8amikag nidodji teb8e,’ maiagotc ikido: ‘Kitci aiamiemigi8amikag acitc Kije Manido iima ka tajikedj nidodji teb8e.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aa8e dac ka ikidodj: ‘Icpimig nidodji teb8e,’ maiagotc ikido: ‘Kije Manido okitci ogima8i tesabi8aganikag acitc Kije Manido iima ka iji abidj nidodji teb8e.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kiga kitci madji iji8ebizim, kina8a Coda8innig ka kikinoamageieg acitc kina8a ka nagadjito8egon inakonige8inan! Kikitci kimodizim! Kitci 8e8enda kinosoneana8an nandam aiamie inakonige8inan ega abidji ka apitendag8agin, e mineg Kije Manido pejig e taso midatcigin kitiganan kagi ma8adjito8egon. Anic dac ka8in odji pejig kipabiziskendasina8an ini ma8adji ka kitci apitendag8agin inakonige8inan: kidji k8aiakozieg, kidji kidimagenimi8eieg, acitc kidji teb8eiendagozieg. Midac iidi maia enendagozieg kidji todamegoban, kidji nosoneamegon ka apitendag8agin inakonige8inan, ega dac acitc kidji 8anikeieg ini kodagian ega abidji ka apitendag8agin! ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kina8a mi maia tabickotc ega ka 8abi8adj ka ijinagozieg, ka k8ag8e kikino8ina8adjin kodagian a8iagon! Kicab8ajiga8itona8a kinibimi8a ega kidji mandjoci8agamig, pekic dac kikona8a ka nijo pik8aoganedj a8esiz.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kiga kitci madji iji8ebizim, kina8a Coda8innig ka kikinoamageieg acitc kina8a ka nagadjito8egon inakonige8inan! Kikitci kimodizim! Ag8adjik mega eta inekena kikizisibadona8an kidonagani8an acitc kiminik8anagani8an. Pekic dac kikitci kicponadona8an kikimodi8ini8an acitc kegonan kagi makameg8a a8iagog. ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kin Coda8inni ka nagadjito8anin inakonige8inan, ega ka 8abian! Pinama pidigeabik kiziabikinan kiminik8anagan, kada ani paiekabikan dac ag8adjik inekena.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kiga kitci madji iji8ebizim, kina8a Coda8innig ka kikinoamageieg acitc kina8a ka nagadjito8egon inakonige8inan! Kikitci kimodizim! Mi maia tabickotc 8ibabikiniganan kagi 8abibiigadegin ejinagozieg. Kitci minonag8anon ag8adjik inekena. Pidigamig dac, a8iagog kagi nibo8adj e cigoganecino8adj kicponeckine8ag, acitc kakinagotc kegonan ka 8anadagin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Midac pejig8an kina8a, ‘kitci mino a8iago8i8ag’ kidinenimigom, ejideeieg dac kikitci kimodizim acitc kikitci 8i madji todana8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kiga kitci madji iji8ebizim, kina8a Coda8innig ka kikinoamageieg acitc kina8a ka nagadjito8egon inakonige8inan! Kikitci kimodizim! Kidojitama8a8ag e kitci min8acinig taji e tanaki8adj niganadjimo8innig, acitc kikitci min8acitona8a taji ka tanaki8adj igi8e kagi k8aiak8adizi8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kidikidom dac oo8e: ‘Kekina8it ki pimadiziakoban meg8adj ka pimadizi8apan 8eckadj kikitci anicinabeminabanig, ka8in kidagi 8idjiasi8ananag kidji nisa8adjin niganadjimo8innin.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Midac oo8e maia ekido8eg, kina8a tibina8e ki8idamagem 8ina8akag e odaiagizieg igi8e kagi nisa8adjin niganadjimo8innin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ka8in dac ponitokegon. Kijitaok kagi madjito8agobanen 8eckadj kikitci anicinabemi8abanig!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Kina8a madji a8iagog, tabickotc ka pitcibo8inezi8adj kinebigog ka ijinagozieg! Adi enendameg ke todameg kidji gi ojimo8eg kidji ick8aienimigo8eg kidji madjocte8ebinigo8eg kitci ickodekag? ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Midac ke odji ijinijaamaonagok niganadjimo8innig kina8akag, acitc a8iagog ka kitci kagita8endamo8adj, acitc a8iagog kidji kikinoamago8eg. Nandam kiga nisa8ag acitc nandam kiga acidak8a8a8ag tcibaiatigokag. Kiga papajacte8a8ag kodagiag kidaiamiemigi8ami8akag acitc kiga paba minijao8a8ag adigotc ke paba ija8adj odenan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kina8a dac kiga odji pajacteogom kakina ka k8aiak8adizi8adj ka pi nisagani8i8adj ooma akikag. Nitam mega Abel ka kitci k8aiak8adizidj ki nisagani8igoban 8eckadj. Ick8eag dac, nogom ka8in 8eckadj, Zakani (Zacharie), Banaki (Barachie) og8izisan kigi nisa8a, maiagotc pidigeatig kitci aiamiemigi8amikag, nasa8idj kitcit8a 8isini8aganikag taji ka iji ick8az8agani8i8adj a8esizag e pagidinigetama8agani8idj Kije Manido acitc taji ma8adji ka iji kitcit8a8endag8ag aiamiemigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Teb8e ki8idamonom, a8iagog nogom ka pimadizi8adj kada pajacte8agani8i8ag kakina ini8e egi pi nisimagani8indjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Kina8a Jerusalemikag ka tajikeieg! Kinisa8ag niganadjimo8innig acitc kipabim8asinaa8ag pinici kidji niseg8a igi8e Kije Manidon kagi pidjinijaogo8adjin! Mojag nigi kitci nda8endanaban kidji ma8adjiinagok pecodj ninikag, tabickotc pakaak8an ka ma8adjiadjin opakaak8anesiman cegodj omig8anakag. Ka8in dac kidodji iji nda8endasina8a. ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Midac ii ke odji nagadag Kije Manido kidodenami8a, ka8in aja oga nagadjitosin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ki8idamonom oo8e, ka8in mina8adj kiga 8abamijisim pinici kidji odjitciseg kidji ikido8eg: ‘Ca8endagozi aa8e Ka Tibendjigendjin ka pidjinijaogodjin.’ ” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesos ki sagaam Coda8inni kitci aiamiemigi8amikag, acitc meg8adj e ani madjadj, okikinoamaganan ogi pi nazikagon e 8abadaigodjin adi kagi ijitcigadenig kitci aiamiemigi8amini acitc kodagian migi8aman iima ka iji acidakisinigin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesos dac ogi inan: “Ki8abadana8a na kakina ii? Teb8e ki8idamonom, kada odjitcise nigodin ega iaga pejig asinig kidji aiag8ita8abi8adj. Kakinagotc kada k8enabagodjinog.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesos ki a8i abigoban Olip (Oliviers) pik8adinajicikag. Okikinoamaganan dac eta ogi pi nazikagon, acitc ogi k8ag8edjimigon: “8idamaocinam anapitc ke iji8ebag ii, acitc 8egonen ke 8abadai8emagag e odjitciseg kidji pi koki tag8icinian, acitc kidji ponaki8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesos ogi nak8e8ajian: “Iag8amendamok ega kidji 8aiejimigo8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mane mega a8iagog kada pija8ag ni8izoni e abadjito8adj, acitc kada ikido8ag: ‘Nin aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin.’ Mane dac a8iagon oga 8aiejima8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kiga nodana8a e mad8e migadinani8ag pecodj acitc kiga nodagem e mad8e migadinani8ag 8asag anodj 8edi. Ka8in dac segizikegon ii odji. Panima ii kada iji8eban, ka8in dac maci kada ponaki8asinon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Pejig8eieg a8iagog ka inakanezi8adj oga migana8an a8iagon pakan ka inakanezindjin, acitc a8iagog pejig aki ka tajike8adj oga migana8an a8iagon pakan akin ka tajikendjin. Kada ka8askadani8an acitc kada k8ig8an aianodjigotc. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Apitc ii iji8ebag, mi maia tabickotc ik8e ka madapinedj kidji nta8igindjin odabinodjijiman ke ijinag8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kina8a dac kiga takonigom kidji nanekadjiigo8eg acitc kiga nisigom. Kakina ka inakanezi8adj a8iagog kiga madjenimigo8ag, e nosoneojieg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ii dac apitc, kitci mane ka teb8etamo8adj oga 8ebinana8a oteb8etamo8ini8a. Kada mamijimidi8ag, acitc kada madjenimidi8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kada kitci mane8ag ke kagina8icki8adj, e ikido8adj e niganadjimo8inni8i8adj, acitc oga 8aiejima8an kitci mane a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kada kitci obese eckam eckam madjido8in. Ii dac odji, kitci mane a8iagog kada poni sagiidi8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Aa8e dac ega ke ana8endjigedj, ka sogigaba8idj dac, mi aa8e ke ag8acimagani8idj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mizi8ekamig dac kada tibadjimonani8an oo8e min8adjimo8in, ka odji kikendjigadenig Kije Manidon Odogima8i8ini. Kakina dac ka inakanezi8adj a8iagog kada nodage8ag oo min8adjimo8ini. Ick8a dac ii, mi apitc ke ponaki8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“8eckadj ako, niganadjimo8inni Danian (Daniel) omikomaban ini a8ian ‘Kitci madji kegon ka kitci kotadendag8ag’ ka ijinikazondjin. Kiga 8abama8a dac aa madji a8iag pidigamig kitci aiamiemigi8amikag, taji ma8adji ka iji kitcit8a8endag8anig. Aa8e ke nabo8adag oo8e, panima 8e8enda oda k8ag8e nisidotan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ii dac apitc, igi8e Coda (Judée) akikag ka tajike8adj, panima pik8adinakag kada ipai8e8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Aa8edi 8agidabak8an omigi8amikag ke teg8en, ka8in kadagi pidigebatosi kidji a8i ma8adobidodjin odaiman. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mi pejig8an, aa8e okitigan akikag ke teg8en, ka8in kadagi koki ki8esi kidji nda nadji8idodj opizika8agan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ii dac apitc, kada kitci kodagito8ag ik8e8ag ke kigicka8a8ag8en abinodjijan acitc igi8eni8ag ke tcodjocikea8aso8ag8en. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Aiamieok dac ega panima kidji madjipai8eieg meg8adj e pibog kek8an e aiamie kijigag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ii mega apitc, na8adj kada kitci sogendag8an kodagito8in apitc8in kakina kodagian ka pi tag8agin, ka ako madji tag8ag aki pinici nogom, acitc ka8in mina8adj 8ikad pejig8an kada iji8ebasinon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kicpin Kije Manido ega ki inendagiban kidji adji8inag inigik ke iji kodagitonani8anig, ka8in a8iag kadagi pimadjiosiban. Ini8e dac a8iagon odji kagi onabamadjin 8edji ki adji8inag inigik ke iji kodagitonani8anig.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Kicpin dac a8iag igo8eg: ‘Inabiok! Aja ooma te aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin!’ kek8an: ‘Iima te!’ ka8in teb8eta8akegon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nandam mega a8iagog kada pija8ag e kagina8icki8adj e ikido8adj: ‘Nin aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin’ kek8an: ‘Nin niniganadjimo8inni8inan.’ Kada kitci mamada8izi8ag acitc kada mamada8akamigizi8ag, kidji k8ag8e 8agackibina8adjin 8a8adj ini8e a8iagon Kije Manidon kagi onabamigondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ndotamok! Kigi 8idamonom nigan ke iji8ebag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Kicpin dac igo8eg: ‘Inabiok! Pig8adakamigokag 8edi te!’ ka8in 8edi ijakegon. Kicpin igo8eg: ‘Inabiok! Mi ooma eji kazodj!’ ka8in teb8eta8akegon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Apitc mega tag8icig Aa8e Ka pi Anicinabe8iidizodj, kakina a8iagon oga 8abamigon. Mi maia tabickotc ka kitci 8asakoneseg 8abanog pinici nigabianog, mi ke ijinag8anig apitc pi tag8icig Ka pi Anicinabe8iidizodj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Taji ke iji tanatenig8en o8ia8 a8esiz kagi nibodj, mi iima ke iji ma8adjiidi8adj kakagig.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Teci8agigotc dac ick8asenigin ini kodagito8inan, kada ani makade8asige kizis acitc ka8in kada tcakasigesi tibikikizis. 8ak8ikag kada odagodjinog 8anagocag acitc kakina kegonan icpimig kada ninigise8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Midac 8ak8ig niga odji pi nagozinan e pi tag8icinian, nin, Ka pi Anicinabe8iidizodj. Kakina dac a8iagog ooma akikag kada kitci pabibagi8ag acitc kada kitci ma8i8ag, acitc niga 8abamigog, nin Ka pi Anicinabe8iidizodj, kidji pi najiseian nena8idj 8ak8ikag, e kitci macka8izian acitc e kitci icpendagozian. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kada nodag8an kitci podadjigan acitc niga ijinija8ag nidajenimag mizi8ekamig kidji a8i ma8adjia8adjin kakina a8iagon kagi onabamimagin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Pagidinik minatig kidji kikinoamago8eg kegoni. Apitc o8adik8anan madjiginigin acitc onibicibagoman sagiginigin, kikikendana8a aja pecodj kidji nibig. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Midac pejig8an, apitc 8abadamegon ini kegonan e iji8ebagin, kiga kikendana8a aja e ani peconag8anig kidji tag8icig Ka pi Anicinabe8iidizodj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Teb8e ki8idamonom, ka8in kakina kada nibosi8ag a8iagog nogom ka pimadizi8adj, ab8amaci kakina ii iji8ebag ka ikido8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","8ak8i acitc aki kada ponise8an, nidikido8inan dac 8in ka8in 8ikad kada ponisesino8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ka8in dac a8iag okikendasin anapitc maia ke ponaki8anig. Ka8in 8a8adj ajenig 8ak8ig ka te8adj okikendasina8a, ka8in 8a8adj Kije Manido Og8izisan okikendasini. Mi eta Kije Manido Kidadaminan okikendan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kagi iji8ebag meg8adj No8a (Noé) ka tepan, mi maia pejig8an ke iji8ebag apitc tag8icig Aa8e Ka pi Anicinabe8iidizodj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ii apitc, ab8amaci nikibig, a8iagog 8isini8agoban acitc minik8e8agoban, acitc nabeg acitc ik8e8ag niba8i8agoban, pinici No8a kidji pidigedj kitci tcimanikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ka8in dac kegoni ododji nisidotasina8a igi a8iagog, pinici kidji kitci nikibinig acitc kidji ani nisaba8e8adj kakina. Mi iidi ke iji8ebag apitc tag8icig Ka pi Anicinabe8iidizodj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ii dac apitc, nijin nabeg kada te8ag kitigan akikag. Pejig dac kada madji8inagani8i, kodag dac kada naganagani8i. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nijin ik8e8ag ma8asag kada tcibak8e8ag. Pejig dac kada madji8inagani8i, kodag dac kada naganagani8i.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Eco8iok dac! Ka8in mega kikikendasina8a apitc ke tag8icig ka Tibenimigo8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","K8ag8edjitaok kidji nisidotameg oo8e. Aa a8iag ka tibendag migi8amini ka8in okikenimasi8an anapitc ke odisigodjin kimodi8innin meg8a tibik. Kicpin dac kikenimapanin anapitc ke odisigodjin, kada eco8iban, acitc oda taji pian ega kidji kimodji pidigendjin omigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Midac ke odji eco8ieg kekina8a. Aa mega Ka pi Anicinabe8iidizodj kitci kaiezigotc kada odji tag8icin maia apitc ega odji pejig e pieg.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“A8enen dac aa8e anokitage8inni ka teb8eiendagozidj acitc ka kagita8endagozidj? Mi aa ke igodjin okackaman: ‘Kiga nagadjiag kakina a8iagog nimigi8amikag ka anokitaoji8adj meg8adj ke tanedian. Kakina pepejig e taci8adj kiga minag midjimini eko tibise8adj apitc odji 8i 8isini8adj,’ inagani8i. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kicpin dac okackaman apitc pi ki8endjin 8abamigodjin 8e8enda e anokita8adjin, kada mino iji8ebizi aa anokitage8inni. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Teb8e ki8idamonom, okackaman oga minigon kakina odaimini kidji nagadjitodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mamidonendamok dac adi ke ijisegiban kicpin ega k8aiak anokitagepan aa anokitage8inni, acitc dac inendagiban oo8eni: ‘Kin8ej kiabadj kada inedi nikackam.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Omiganan dac kodagian o8idji anokitage8inniman, acitc o8idji 8isiniman acitc o8idji minik8eman ini8e ka nta ki8ack8ebindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kegapitc dac nigodin kada tag8icino8an okackaman, apitc ega pabajine piadjin, ka8in mega okikendasin adi ke ijigijiganig kek8an ke taso tibaiganeanig apitc ke tag8icinindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Aa dac kacka oga kitci sogacte8an ini anokitage8innin. Oga sagidji8ebinan kidji 8idji8andjin ini8e ka kimodizindjin, taji ke iji kitci ma8indjin acitc ke iji kitci mamad8eabideckandjin ke apitci kodagitondjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesos kiabadj ki ikido: “Apitc tag8icig Ka pi Anicinabe8iidizodj, mi oo8e ke ijinag8anig Kije Manido Odogima8i8in. Midatcin ik8esesag ki 8a8ejio8agoban kidji ija8adj ka iji niba8inani8anig. Ogi madji8idona8an dac o8asakonendjigani8an acitc ki sagaamog e nda nagicka8a8adjin ini naben ke niba8indjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nanan dac ii e taci8adj ki8ack8eiendagozibanig, kodagiag dac igi8e nanan piziskadizibanig. ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ik8esesag dac ka ki8ack8eiendagozi8adj ogi madji8idona8an o8asakonendjigani8an, ka8in dac odji nimi pimide8esi8ag kidji koki kicponebado8adjin o8asakonendjigani8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Igi8e dac ka piziskadizi8adj ogi madji8idona8an o8asakonendjigani8an, acitc ki nimi pimide8e8ag modaiabikokag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kitci kin8ej ki taji piagani8i aa ke niba8idj nabe. Kegapitc dac ki nodeg8aci8ag igi ka midatci8adj ik8esesag, misa dac kakina ki nibese8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Apitc dac e abitatibikag, ki odji kitci pibaginani8an: ‘8adan aa ke niba8idj! Sagaamok acitc a8i nda nagickaok!’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Kakina dac igi ik8esesag ki kockozi8ag, acitc ogi nagadjitona8an o8asakonendjigani8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Igi dac ka ki8ack8eiendagozi8adj ik8esesag ogi ina8an ka piziskadizindjin ik8esesan: ‘Minicinam pagi kipimidemi8a. Aja mega ani ata8e8an ni8asakonendjigananan.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ka piziskadizi8adj dac ki nak8e8ajit8a8ag: ‘Ka8in niga tibisesimin kenina8it acitc dac kekina8a. A8i nda odapinamadizok sa ada8agamigokag.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ogi nda odapinana8a dac pimideni igi8e ka ki8ack8eiendagozi8adj. Meg8adj dac e tanedi8adj, aa8e ke niba8idj ki odji tag8icin. Igi8e nanan ik8esesag ka ick8ata8adj ki pidige8ag kigi ke niba8indjin ka iji niba8inani8anig. Midac ka iji kibaigadegin acitc ka iji kidabikaigadegin ick8ademan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Kegapitc dac nanage, ki tag8icinog igi kodagiag nanan ik8esesag. Ki kitci pabibagi8ag dac: ‘Cebidaok! Cenamaocinam!’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Aa dac ka niba8idj ki ikido: ‘Teb8e ki8idamonom, ka8in kikikenimisinonom.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Midac Jesos ikidogoban: “Panima dac apanigotc kiga eco8im! Ka8in mega kikikendasina8a apitc maia ke tag8icig Aa8e Ka pi Anicinabe8iidizodj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Mina8adj dac Jesos ki ikido: “Apitc tag8icig Aa8e Ka pi Anicinabe8iidizodj, 8adan oo8e ke ijinag8anig Kije Manido Odogima8i8in. Pejig nabe 8i a8i pabamadizigoban. Ogi nd8e8eman dac odanokitage8inniman acitc ogi anonan kidji kana8enimandjin oconiaman, acitc ani8ag kidji nda kackiandjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ogi minan dac pepejig pepagi kidji kana8enimandjin eji kackitondjin. Pejig dac ogi minan nano midasomidana oza8iconia8abikon, kodagian dac nijo midasomidana oza8iconia8abikon, acitc dac kiabadj kodagian pejigo midasomidana oza8iconia8abikon. Midac ka iji madjadj aa nabe. ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Aa dac anokitage8inni nano midasomidana oza8iconia8abikon kagi minagani8ipan, teci8ag ki nda mikimo e abadjiadjin ini conian, kidji gi nda kackiadjin a8acamej. Nano midasomidana dac oza8iconia8abikon ani8ag ogi nda kackian. ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Aa dac anokitage8inni nijo midasomidana oza8iconia8abikon kagi minagani8ipan, mi ke8in ka todag tabickotc nitam anokitage8inni. Nijo midasomidana dac oza8iconia8abikon ani8ag ogi nda kackian. ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Aa dac anokitage8inni pejigo midasomidana oza8iconia8abikon kagi minagani8ipan, ki nda monaige acitc ogi kanan ini okackaman oconiamini.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Kin8ej dac ka ick8a madjandjin, ki odji tag8icino8an ini okackami8an, acitc ogi k8ag8edjimigo8an adi ka inabadjia8adjin ini conian kagi kana8endamoigo8apanin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Aa dac anokitage8inni nano midasomidana oza8iconia8abikon kagi minagani8ipan ogi pi nazika8an okackaman acitc ogi minan ini conian kagi minigopanin, acitc dac ini nano midasomidana oza8iconia8abikon ani8ag kagi nda kackiadjin. Ogi inan dac: ‘Nikackam! Kigi minijinaban nano midasomidana oza8iconia8abikog. Kana8abadan! 8adan ogo8e nano midasomidana oza8iconia8abikog ani8ag kagi nda kackiag8a.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Okackaman dac ogi igon: ‘Mi iidi k8aiak! Maiagotc kimino anokitage8inni8inan acitc kikitci teb8eiendagozinan! K8aiak kigi todan, misa8adj pagi eta egi inanoninaban. Kiga anonin dac mane kegonan kidji nagadjito8anin. Pi nda 8idji mina8azimicin.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Mina8adj dac aa anokitage8inni nijo midasomidana oza8iconia8abikon kagi minagani8ipan ogi pi nazika8an okackaman acitc ogi inan: ‘Nikackam! Kigi minijinaban nijo midasomidana oza8iconia8abikog. Kana8abadan! 8adan ogo8e nijo midasomidana ani8ag kagi nda kackiag8a.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Okackaman dac ogi igon: ‘Mi iidi k8aiak! Maiagotc kimino anokitage8inni8inan acitc kikitci teb8eiendagozinan! K8aiak kigi todan, misa8adj pagi eta egi inanoninaban. Kiga anonin dac mane kegonan kidji nagadjito8anin. Pi nda 8idji mina8azimicin.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ick8eag dac, aa anokitage8inni pejigo midasomidana oza8iconia8abikon kagi minagani8ipan ogi pi nazika8an okackaman acitc ogi inan: ‘Kacka! Kikikenimin e ak8adizian, acitc e ma8adjito8anin ako kitiganan 8a8adj iima kodag a8iag kagi iji kitigegobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kikosinaban dac acitc nigi nda kana kiconiam anamakamigokag. Kana8abadan! 8adan 8aa kiconiam.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Okackaman dac ogi igon: ‘Kimadji anokitage8inni8inan acitc kikitci kitiminan! Kikikenimijinaban e ma8adjito8anin kitiganan 8a8adj iima kodag a8iag kagi iji kitigepan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Conia8igi8amikag dac kidagi asa niconiam. Apitc dac koki tag8icinian, nidagi 8ikobina niconiam acitc na8adj mane kadagi ik8agidagoziban.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Ki ikido dac: ‘Makamik ini midasomidana oza8iconia8abikon, acitc dac mijik aa pejig kitci midasomidana oza8iconia8abikon ka aia8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Aa mega a8iag kegoni ka aiag, a8acamej oga odisigon, acitc kitci mane kegoni oga aian. Aa dac a8iag ega kegoni ka aiag, misa8adj pagi eta kegoni aiag kada makamagani8i. ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Sagidji8ebinik dac ag8adjik ka iji tibikanig aa anokitage8inni ega odji pejig ka abadizidj. Iima dac kada kitci ma8i acitc kada kitci mamad8eabidecka ke apitci kodagitodj.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Apitc pi tag8icig Aa8e Ka pi Anicinabe8iidizodj kigi kakina ajenig, kidji pi ogima8idj, kada pi nda abi okitci ogima8i tesabi8aganikag ka kitci icpendag8anig kidji tibakonadjin a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kakinagotc dac adi enakanezi8adj a8iagog ooma akikag kada ma8adjiidi8ag nigan 8inikag acitc oga nenijo nenicikenan, tabickotc aa8e ka kana8enimadjin a8esizan ka nenicikenadjin pepakan mantcenican acitc minago mantcenican. ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Oga asan dac ini8e ka k8aiakozindjin okitcinikikag inekena acitc dac ini8e ka madjakamigizindjin onamadinikikag inekena.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Aa dac ogima oga inan ini8e okitcinikikag ka tendjin: ‘Pijaok, kina8a Nidadam ka ca8enimigo8eg! Mi iima ke iji tibendagozieg Ogima8i8inikag kagi ojitamago8eg ka ako kijendjigadeg aki. ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nigi kitci mamida8askadenaban mega, acitc kigi acamijim. Nigi mamida8abag8enaban, acitc kigi minaijim. Nigi pi8ide8inaban, acitc kigi nd8e8emijim kimigi8ami8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nigi moceckadenaban, acitc kigi 8a8epinijim. Nigi akozinaban, acitc kigi pamiijim. Nigi takonigonaban, acitc kigi ndaodeomijim.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ini8e dac ka k8aiakozindjin oga nak8e8ajiigon: ‘Tebendjigean! Anapitc ka 8abamigo8an kidji mamida8askadean acitc kagi acamigo8an, kek8an kagi mamida8abag8ean acitc kagi minaigo8an? ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Anapitc ka 8abamigo8an e pi8ide8ian acitc kagi nd8e8emigo8an nimigi8aminakag, kek8an kagi moceckadean acitc kagi 8a8epinigo8an? ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Anapitc ka 8abamigo8an e akozian, kek8an e takonigo8an, acitc kagi ndaodeomigo8an?’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Aa dac ogima oga nak8e8ajian: ‘Teb8e ki8idamonom, tasinigotc kagi mino toda8eg pejig oo ka taci8adj, nidjiki8eg ka inenimag8a, ega a8iagon ka apitenimigo8adjin, kenin kigi mino todaojim.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Mina8adj dac aa ogima oga inan ini8e onamadinikikag ke tendjin: ‘A8as 8edi ijaok, kina8a ka ick8aienimigo8eg Kije Manido! 8edi ijaok kagige ickodekag, kagi ojitama8agani8idj madji manido acitc odajeniman! ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nigi kitci mamida8askadenaban mega, acitc ka8in kidodji acamijisim. Nigi mamida8abag8enaban, acitc ka8in kidodji minaijisim. ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nigi pi8ide8inaban, acitc ka8in kidodji nd8e8emijisim kimigi8ami8akag. Nigi moceckadenaban, acitc ka8in kidodji 8a8epinijisim. Nigi akozinaban acitc nigi takonigonaban, acitc ka8in kidodji 8idjiijisim.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Oga nak8e8ajiigon dac ke8ina8a: ‘Tebendjigean! Anapitc ka 8abamigo8an e mamida8askadean, kek8an e mamida8abag8ean, kek8an e pi8ide8ian, kek8an e moceckadean, kek8an e akozian, kek8an e takonigo8an, ega dac egi pi 8idjiigo8an?’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ogima dac oga inan: ‘Teb8e ki8idamonom, tasinigotc ega kagi mino toda8eg pejig oo ka taci8adj, ega a8iagon ka apitenimigo8adjin, kenin ka8in kidodji mino todaojisim.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Kada ijinija8agani8i8ag dac, kagige kidji pajacte8agani8i8adj. Ka k8aiakozi8adj dac kada ijinija8agani8i8ag kagige kidji pimadizi8adj.” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Apitc Jesos ka ick8a kikinoamagedj kakina ii, ogi inan okikinoamaganan: ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kikikendana8adok ick8a nijogonagag kada Kitci Magocani8an, Pak ka ijinikadeg. Ii dac apitc, nin, Ka pi Anicinabe8iidizodj, niga takonigo kidji acidak8aogo8an tcibaiatigokag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Coda8inni dac kitci aiamie ogimag acitc Coda8innig ka niganizi8adj ki ma8adjiidi8ag Kaiapasan (Caïphe) okitci migi8aminikag, 8in ka aiamie ogima8inipanin ma8adji ka niganizinipanin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ma8asag dac ogi onendana8a kidji kimodji takona8adjin Jesosan, acitc kidji nisa8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ki ikido8ag dac: “Ka8in kida takonasi8anan meg8adj e Kitci Magocani8anig. A8iagog mega kiga odji kitci nickiananag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesos tegoban Betani (Béthanie) odenakag, acitc ki ijagoban Simon omigi8aminikag. Simo dac kitci omigi8apinegoban. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Meg8adj e taji 8isinani8anig, pejig ik8e8an ogi pi nazikagogoban Jesos, acitc e kitci min8acinig modaiabikoni e kicponebinig ka minomag8anig ka kitci sanaganig ogi pidon. Ogi siginan dac ii ka minomag8anig Jesosan octig8anikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Apitc Jesos okikinoamaganan ka 8abadamo8adj ii, ki kiji8azi8ag acitc ki ikido8ag: “8egonen 8edji ki 8anadjitodj ii? ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kadagi ada8ani8anoban mega ii ka minomag8ag ka kitci sanagag, acitc dac kadagi minagani8ibanig conian ka kidimagizi8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesos ogi odji pabiziskeniman adi ekidondjin acitc ogi inan: “8egonen 8edji animieg aa ik8e? Kitci min8acini ii kagi todaojidj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kabena ka kidimagizi8adj kiga 8idji tajikemigo8ag, nin dac 8in ka8in apanigotc kiga 8idji tajikemisinonom. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ogi siginan nia8ikag oo ka minomag8anig, kidji iji medoni ojitodj ab8amaci naatcigadenig nia8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Teb8e ki8idamonom, adigotc ke iji paba tibadjimonani8anig Kije Manido omin8adjimo8in mizi8ekamig, kada tibadjimonani8ani adi kagi todag 8aa ik8e, acitc kada mik8enimagani8i.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pejig dac ii e midatcin acitc nijindjin Jesos okikinoamaganan, Judas Iskaniot (Iscariote) ka ijinikazonigobanen, ogi nda 8abaman Coda8inni kitci aiamie ogiman. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ogi k8ag8edjiman dac: “8egonen ke minijiegoban kicpin 8idokaonagogiban kidji takoneg Jesos?” Ogi minigon dac nisomidana 8abiconia8abikon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Midac ii maia apitc, Judas ka madji nanada kikendag anapitc maia ke minosenigiban kidji gi mamijimapanin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Apitc e madjita8agobanen e kitci ijigijiganoke8adj, apitc ako ka am8agani8igobanen ega ka obicig pak8ejigan, Jesos okikinoamaganan ogi pi nda k8ag8edjimigon: “Ataji iima eji nda8endaman kidji nda 8isinanikeiag, kidji gi Kitci Magocanikeiak?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesos dac ogi nak8e8ajian: “Ijaok odenag, acitc aa nabe kagi mikomag a8i nda 8abamik. Kiga ina8a dac: ‘Kikinoamage8inni ikido oo8e: Aja kegat kada odjitcise kidji iji8ebizian ka inateg kidji iji8ebizian. Kimigi8amikag dac ni8i iji nda magoce kigi nikikinoamaganag.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ki ijita8an dac Jesos okikinoamaganan adi kagi inanonapanin acitc ogi ojitona8a kidji magocani8anig e kitci ijigijiganig. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Apitc e ani onag8icinig, Jesos acitc ka midatcin acitc nijindjin okikinoamaganan ki 8akanabi8ag 8isini8aganikag kidji magoce8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Meg8adj e taji 8isini8adj, Jesos ki ikido: “Teb8e ki8idamonom, pejig oo e tacieg niga mamijimig.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Okikinoamaganan dac ki kitci kackendamise8an acitc pepejig aiackodj ogi k8ag8edjimigon: “Tebendjigean! Ka8in nin ke todaman, kana?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesos ogi nak8e8ajian: “Aa8e ke8in ke kidagaminadjin opak8ejiganiman apitc nin kidagaminimagin, mi aa8e ke mamijimijidj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ketcinam nin, Ka pi Anicinabe8iidizodj, niga nibonan, maia tabickotc ka iji mazinadenig Kije Manido Omazinaiganikag. Anic dac 8in aa nabe ke mamijimijidj, kada kitci madji iji8ebizi. Na8adj kadagi minoseniban aa nabe ega ki nta8igipan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas dac, 8in ke mamijimadjin Jesosan, ogi k8ag8edjiman: “Kikinoamage8inni! Ka8in nin aa, kana?” Jesos dac ogi nak8e8ajian: “Kinigotc kidikidonan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Meg8adj e taji 8isini8adj, Jesos ogi odapinan pak8ejiganan, mig8etc ogi inan Kije Manidon, acitc ogi papak8ebinan. Ogi minan dac okikinoamaganan, e ikidodj: “Odapinik acitc amok. Mi oo8e nia8.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Mina8adj dac ogi odapinan minik8anagani, mig8etc ogi inan Kije Manidon, acitc ogi minan okikinoamaganan e ikidodj: “Minik8eok kakina e tacieg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mi oo8e nimisk8i, 8edji madjitamaganig Kije Manido onakomo8in kidji mama8ise8adj Kije Manido acitc odanicinabeman. Kitci mane a8iagog odji siginigade, kidji kasiigadegin patado8inan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ki8idamonom, ka8in 8ikad mina8adj niga minik8esi oo cominabo pinici kidji 8idji minik8eminagok ocki cominabo Nidadam Odogima8i8inikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ki nigamo8ag dac ini aiamie nigamo8inan ka nigamonani8anig ako apitc e Kitci Magocani8anig, midac ka iji ija8adj 8edi pik8adinajicikag Olip (Oliviers) ka ijinikadenig. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesos dac ogi inan okikinoamaganan: “Nogomigotc ke tibikag, kakina e tacieg kiga naganijim, maia tabickotc ka iji mazinadenig Kije Manido Omazinaiganikag: ‘Mantcenican ka kana8enimadjin niga nisa, midac kakina kada obebaidi8ag mantcenicag,’ mi e mazinadeg. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ick8a abidjibaian dac, Galilee akikag kiga iji nda piinom.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pien dac ogi inan: “Misa8adj kakina 8ina8a naganik8a, ka8in 8ikad nin kiga naganisinon.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesos ogi nak8e8ajian: “Teb8e ki8idamon, nogomigotc ke tibikag, ab8amaci nabe pakaak8an nodagozidj, aja nisinanaj kigagi odji ikidonan ega e kikenimijian.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pien dac ogi inan: “Ka8in 8ikad niga ikidosi ega e kikeniminan, misa8adj 8idji nibominaban.” Midac pejig8an kodagian okikinoamaganan ka ikidonigobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jesos acitc okikinoamaganan ogi oditana8agoban Getsemane (Gethsémané) ka ijinikadenig kitigan akini. Ogi inan dac okikinoamaganan: “Ooma abiok, meg8adj e nda aiamieian 8edi.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Mi eta nisin ogi madji8inan, Pienan acitc ka nijindjin Zebedee og8izisan. Tedago dac Jesos ki odji kitci kackendam acitc ki kitci animendam. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ogi inan dac: “Nikitci ka8enimonan. Tajikeok ooma acitc 8idabimicik e nibebian.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","A8acic pagi ki ija taji eji tenipanin okikinoamaganan, acitc ki 8anijibanio. Ki aiamie dac e ikidodj: “Nidadam! Kicpin minoseg, 8ack8ebidon nidanimizi8in! Pekic dac ka8in nin ka iji nda8endaman todaken, tiegodj kin ka iji nda8endaman todan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ogi koki nda 8abaman dac ini ka nisindjin okikinoamaganan, acitc ogi mika8an e pajigog8acinindjin. Ogi inan dac Pienan: “Kana 8a8adj pejigotibaigan kikackitosina8a kidji 8idabimijieg? ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","K8ag8e cibig8aciok, acitc aiamieok kidji macka8izieg, ega kidji gi pakebinigo8eg madji manido. Teb8e ki8i k8ag8e k8aiak8adizim, pekic dac kia8i8a kitci cagozimagan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Mina8adj Jesos a8acic pagi ki ija taji eji tenipanin okikinoamaganan acitc ki aiamie e ikidodj: “Nidadam! Kicpin ega kackitomagag oo animizi8in kidji 8ack8ekamagag, mi panima kin ka iji nda8endaman kada iji8eban.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ogi koki nda 8abaman dac okikinoamaganan acitc mina8adj ogi mika8an e pajigog8acinindjin. Kitci aiekozi8agoban mega acitc ka8in okackitosina8agoban kidji cibig8aci8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kiabadj mina8adj Jesos ogi naganan, a8acic pagi ki ija taji e tenipanin, acitc mina8adj mi pejig8an ka ikidodj e aiamiedj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Mina8adj dac ogi koki nda 8abaman okikinoamaganan, acitc ogi inan: “Kiabadj na kinibam acitc kidan8ecimonom? Inabiok! Aja odjitcise nin, Ka pi Anicinabe8iidizodj, kidji pagidenimigo8an kidji gi tibenimiji8adj ka patadi8adj a8iagog. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","8anickaok! Ijadan! Kijigabamik, aa nabe ke mamijimijidj aja tag8icin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kiabadj Jesos taji anim8egoban, apitc Judas ka odji tag8icinogobanen, mi aa pejig ka midatcin acitc nijindjin okikinoamaganan. Kitci manebanin a8iagon Judas e 8idjiogogobanen, kitci mokomanan acitc mitigon e pimi takonamo8agobanen. Ogi pidjinijaogo8agoban Coda8inni kitci aiamie ogiman acitc ka niganizindjin Coda8innin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas dac, aa8e kagi mamijimadjin Jesosan, aja ogi 8idama8abanin a8iagon adi ke inakamigizidj. Ogi inagobanin dac: “Aa8edi ke nda odjimag, mi aa8e ka nda8enimeg. Takonik dac aa.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Teci8ag dac Judas ogi pi nda nazika8an Jesosan acitc ogi inan: “K8e, Kikinoamage8inni!” Ogi odjiman dac. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesos ogi nak8e8ajian: “Ni8idji8agan! 8ibadj ick8a ijitan adi ka pi nda ijitaian.” Igi8e dac kodagiag a8iagog ogi pi nazika8an Jesosan, ogi na8adina8an acitc ogi takona8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Pejig dac ii e taci8adj ka 8idji8a8adjin Jesosan ogi odapinan okitci mokoman, ogi pakite8an Coda8inni aiamie ogiman ma8adji ka niganizindjin odanodagani acitc ogi kickita8age8eba8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesos dac ogi inan: “Koki pinaan ii kikitci mokoman. Kakina mega a8iagog mokomani ka abadjito8adj mi ii8eni ke odjine8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kana kikikendasin e kackito8an kidji pagosenimag Nidadam kidji pi nda 8idjiijidj? Teci8ag dac ogagi ijinija8an kitci mane midasomidana ajenin kidji gi pi nda 8idokaojindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kicpin dac pekic iidi todamaban, ka8in kada iji8ebasinoban kagi ojibiigadenig Kije Manido Omazinaiganikag! Mazinade dac panima iidi kidji iji8ebag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jesos dac ogi inan kakina ini8e a8iagon ka pi takonigodjin: “Mi na e ijio8eg, e omokomanieg acitc e omitigomieg e pi nadji8inijieg, tabickotc kimodi8inni8iaban? Taso kajik nigi nda abinan Coda8inni kitci aiamiemigi8amikag e kikinoamageian, ka8in dac kidodji takonijisim. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Midac 8edji iji8ebag ii, kidji gi ijiseg adi kagi iji ojibiamo8adj niganadjimo8innig.” Kakina dac okikinoamaganan ogi naganigon acitc ki ojimobanin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Igi8e a8iagog kagi takona8adjin Jesosan, ogi iji8ina8an Kaiapasan (Caïphe) omigi8aminikag, 8in ka Coda8inni aiamie ogima8inipanin ma8adji ka niganizinipanin. Iima dac aja taji ma8adjiidibanig Coda8inni kikinoamage8innig acitc ka niganizi8adj Coda8innig. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pien dac 8asag odakanag ogi pi odji nosone8agoban Jesosan, pinici pidigeatig taji ka iji tag8anig aiamie ogiman ma8adji ka niganizindjin omigi8amini. Ki pidigeako dac, acitc ogi a8i 8idabiman ini ka kana8endamindjin aiamie ogiman ma8adji ka niganizindjin omigi8amini, kidji kikendag adi ke iji8ebizindjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Igi8e Coda8inni kitci aiamie ogimag acitc kakina Coda8inni kitci aiamie onakonige8innig, ogi k8ag8e mikana8a kegoni kegi odji inactaona8apanin Jesosan, misa8adj ega e teb8emaganig ii, kidji gi odji ick8aienima8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ka8in dac kegoni ododji mikasina8a kegi odji ick8aienima8apanin, misa8adj mane a8iagon egi pi kagina8ickindjin e inactaonandjin Jesosan. Kegapitc dac nijin nabeg ki pija8ag, ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","acitc ki ikido8ag: “8aa nabe ki ikido: ‘Niga kackiton kidji nici8anadjito8an Kije Manido okitci aiamiemigi8am acitc nisogon inigik niga tajikan kidji koki ojito8an.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Coda8inni aiamie ogima ma8adji ka niganizidj ki pazig8i acitc ogi inan Jesosan: “Kana kegon kinak8e8ajii8esi? Teb8e8ag na igi ka inactaonik8a?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ka8in dac Jesos odji kidosi. Aa dac aiamie ogima ma8adji ka niganizidj ogi inan: “Kik8ag8edjimin kidji teb8ean e 8idamaojian, e kikendaman Kije Manido ka pimadizidj e kijigabamik. Kin na aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin, Kije Manido Og8izisan?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesos ogi nak8e8ajian: “Mi ekido8an kin. Ki8idamonom dac, aja pecodj kiga 8abamijim nin, Ka pi Anicinabe8iidizodj, kidji abian Kije Manido ma8adji ka kitci macka8izidj okitcinikikag, acitc kiga 8abamijim kidji pi najiseian nena8idj 8ak8ikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Aa dac aiamie ogima ma8adji ka niganizidj ogi tadobidon okonas epitci kitci madjita8adjin, acitc ki ikido: “Ogi manazoman Kije Manidon! Ka8in aja kodag a8iag ninada8enimasi8anan kegoni kidji pi nda tibadjimodj! Kakina e tacieg kigi noda8a8a adi kagi iji kitci manazomadjin Kije Manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Adi enendameg?” Ogi nak8e8ajiigon dac: “Maiagotc ki kitci panaage! Kackitamadizo kidji nisagani8idj!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nandam dac a8iagog ogi sik8ana8an acitc ogi papakite8a8an. Nandam dac ogi pasaba8a8an, ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","e ina8adjin: “Kin Kije Manido ka pidjinija8adjin! 8idamaocinam, a8enen ka pakiteok?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pien dac ag8adjik taji abigoban, pidigeatig taji ka iji tag8anig aiamie ogima ma8adji ka niganizindjin omigi8amini. Pejig dac anodaganik8e ogi pi nazika8an acitc ogi inan: “Kekin kipaba 8idji8aban Jesos, aa nabe Galilee ka odjidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pien dac ki ikido ega e teb8emaganig ii, e nak8e8ajiadjin: “Ka8in nikikendasin 8egonen ka mikodaman.” Kakina dac a8iagon ogi nodagon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pien dac ki ijagoban pecodj 8akaak8aiganikag taji ka iji ick8ademi8anig. Kodagian dac anodaganik8en ogi 8abamigon acitc ogi inan kakina ini8e iima ka tendjin: “Mi 8aa pejig nabe ka paba 8idji8apanin Jesosan, Nazaret ka odjindjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kiabadj dac Pien ki ikido ega e teb8emaganig ii, e ikidodj: “Niteb8e! Ka8in nikikenimasi aa nabe!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nanage dac, igi8e iima ka tajigaba8i8agobanen ogi nazika8a8an Pienan acitc ogi ina8an: “Kiketcinamenimigo, kekin kipaba 8idji8aban Jesos! Kinisidotagozinan mega e anim8ean.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pien dac ki ikido: “Manodj pajacteojidj Kije Manido kicpin kagina8ickian! Teb8e ki8idamonom, ka8in nikikenimasi aa nabe!” Maiagotc dac ii apitc, ki nodagozi nabe pakaak8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pien dac ki odji mika8ise adi kagi igogobanen Jesosan: “Ab8amaci nabe pakaak8an nodagozidj, aja nisinanaj kigagi odji ikidonan ega e kikenimijian.” Pien dac ki madja acitc ki nda kitci ma8i. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","8ibadj e kijeba8acinig, kakina Coda8inni kitci aiamie ogimag acitc Coda8innig ka niganizi8adj ma8asag ogi onendana8a kidji nisagani8indjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ogi mag8apina8an dac, acitc ogi madji8ina8an, acitc Pilatikag ogi iji8ina8an, 8in ka kitci ogima8indjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, 8in kagi mamijimapanin Jesosan, apitc ka kikenimadjin egi ick8aienimagani8indjin, ki an8endizo egi mamijimadjin, acitc ogi a8i koki ki8e minan ini nisomidana 8abiconia8abikon Coda8inni kitci aiamie ogiman acitc Coda8innin ka niganizindjin kagi minigopanin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ogi inan dac: “Nigi kitci patadinan egi mamijimag a8iag ega 8ikad madji kegoni egi todagiban kidji gi odji nisagani8idj.” Ogi nak8e8ajiigon dac: “Ka8in nigod nidinendasinanan nina8it. Kin ii kimikimo8in, ka8in nina8it.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas dac ogi iji8ebinan ini conian kitci aiamiemigi8amikag acitc ki madja. Midac ka iji a8i agondizodj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Coda8inni kitci aiamie ogimag ogi ma8adona8an ini conian acitc ki ikido8ag: “Ka8in kipagidinigosinan kidinakonige8inan kidji abadizidj aa conia pidigamig kitci aiamiemigi8amikag, ki odji nisagani8i mega a8iag ini odji.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ki nakomo8ag dac kidji abadjia8adjin ini conian kidji kicpinadona8adj pejig ojidjicki8aginige8innin odakini, iima dac pi8ideg kidji gi iji nig8aakanagani8i8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Midac ii 8edji ijinikadjigadeg ii aki “Misk8i Aki” pinici nogom. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Midac kakina ki ani iji8ebani adi kagi ikidopan niganadjimo8inni Jeremi (Jérémie) 8eckadj: “Ogi odapina8an ini nisomidana 8abiconia8abikon. Mi inigik ka pagidinigenipanin Israel a8iagon kidji nisagani8idj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ogi abadjia8an dac kidji odapinamo8adj pejig ojidjicki8aginige8innin odakini, tabickotc Kije Manido kagi inanonijipan kidji iji 8idama8ag8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesos dac ki iji8inagani8i nigan Pilatikag, midac ka iji k8ag8edjimigodjin: “Kin na Coda8innig odogimami8an?” Jesos dac ogi nak8e8ajian: “Kin ka in8ean.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mina8adj dac, Coda8inni kitci aiamie ogimag acitc Coda8innig ka niganizi8adj ogi inactaona8an Jesosan, ka8in dac kegoni odji ikidosi8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilat dac ogi inan: “Kana kinodasinan kakina ini kegonan ka inactaonik8a?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ka8in dac kegoni ki odji nak8e8ajii8esi adi kagi iji inactaonigodjin. Pilat dac ki kitci mamakadendam. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","E taso pibonig, meg8adj e Coda8inni Kitci Magocani8anig, Pilat opagidinabanin ako pejig takoniganan, ini8e ka nda8enimandjin a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Teban dac ii apitc pejig takonigan e kitci kikenimagani8idj, Jesos-Barabbas ijinikazogoban. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pilat dac ogi k8ag8edjiman ini a8iagon ka pi ma8adjiidindjin: “A8enen neda8enimeg kidji pagidinag, Jesos-Barabbas kek8an aa Jesos ‘Kije Manidon ka pidjinijaogodjin’ ka ijinikanagani8idj?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilat mega okikendanaban Jesosan egi pagidenimagani8inigobanen osa e odenimagani8inipanin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Meg8adj Pilat e taji abigobanen iima tibakonige8igi8amikag, okokomiman ogi pidjinija8ani a8ian kidji pi nda igodjin: “Ka8in pabamendaken ka iji 8i tibakonagani8idj aa nabe ega odji pejig ka panaagedj. Nogom ka tibikag nigi kitci ainabadan, acitc nigi kitci kodagito8an 8in odji.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Coda8inni kitci aiamie ogimag acitc ka niganizi8adj Coda8innig ogi kadjinija8a8agoban kakina a8iagon kidji k8ag8ed8endjin Barabbasan kidji pagidinagani8indjin, acitc kidji nisimagani8indjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilat dac ki ikido: “Adi dac aa8e e niji8adj neda8enimeg kidji pagidinag?” Ki ikido8ag dac: “Barabbas!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilat dac ogi k8ag8edjiman: “Adi dac ke toda8ag Jesos, ‘Kije Manidon ka pidjinijaogodjin’ ka ijinikanagani8idj?” Kakina dac ogi nak8e8ajiigon: “Acidak8ao tcibaiatigokag!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilat dac ki k8ag8ed8e: “Adi dac ka iji panaagedj?” Kiabadj dac enigok ki kitci pabibagi8ag: “Acidak8ao tcibaiatigokag!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilat dac ogi nisidotan ega pabajine eji kackitodj kidji cagozomadjin ini a8iagon, tiegodj, na8adj ki ani kitci pabibagi8an. Ki anoki dac kidji pidama8agani8idj nibini, acitc mi ka iji kizindjidj, meg8adj e kijigabamigodjin kakina a8iagon. Ki ikido dac: “Ka8in nin ka toda8ag 8edji nisagani8idj aa nabe. Kina8a ii kimikimo8ini8a!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kakina dac a8iagog ki ikido8ag: “Nina8it acitc nidabinodjijiminanag ninakomomin kidji pajacteogo8ag egi nisagani8idj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilat dac ogi pagidinan Barabbasan. Ki anoki dac kidji papajacteomagani8indjin Jesosan, acitc ogi anonan cimaganican kidji acidak8a8andjin Jesosan tcibaiatigokag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pilat dac ocimaganiciman ogi pidige8ina8an Jesosan kitci ogima8imigi8amikag, acitc kakina ka taci8adj ki ma8asagogaba8i8ag 8ajagam 8inikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ogi kitcikonaebina8an opitcikonaanan, acitc ogi pisikamodina8an e misk8eganig okonasini. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Minesatigoni dac ki apikage8ag, sizok8epizoni e ojito8adj, acitc ogi 8agidatona8a Jesosan octig8anikag, acitc mitigoni ogi mina8an okitcinikinikag kidji takonamindjin. Ogi nibak8ita8a8an dac e manenima8adjin e ina8adjin: “Kidanamikago, Coda8innig odogimami8an!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ogi sasik8ana8an, acitc ogi koki odapinana8a ii mitigoni kagi mina8apanin acitc ogi papakitectig8ane8a8an ii mitigoni e abadjito8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Apitc ka ick8a manenima8adjin, ogi kitcikonaebina8an ii okonasini acitc ogi koki pisikamodina8an opitcikonaani. Midac ogi madji8ina8an kidji nda acidak8a8a8adjin tcibaiatigokag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","E sagaamo8adj odenakag, ogi nagicka8a8an pejig naben, Simo e ijinikazondjin, Sinen (Cyrène) odenakag e odjindjin. Cimaganicag dac ogi na8adina8an acitc ogi mina8an Jesosan otcibaiatigomini kidji pimi8inandjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kegapitc dac ogi oditana8a 8edi “Golgota” ka ijinikadenig, “Golgota” dac ikidomagan “Tcibaictig8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Iima dac ogi minaa8an cominaboni eji mama8agamisinig mackiki8aboni e kitci madjipog8anig. Jesos ogi kodjipidan, ka8in dac 8i minik8esigoban. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ogi acidak8a8a8an dac tcibaiatigokag, midac ka iji padakicima8adjin, acitc dac ki madinamadi8ag opitcikonaani, e k8ag8e mikose8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Midac ki abi8ag kidji taji kana8abama8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","8agidj octig8anikag, ojibiigani agokenigoban e tibadjimomaganig adi 8edji ki ick8aienimagani8idj. Mazinadeniban dac: “Mi 8aa Jesos, Coda8innig odogimami8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nijin kimodi8innig ki acidak8a8agani8i8ag ke8ina8a otcibaiatigomi8akag, midac nenida8ina Jesosikag ka iji padakicimagani8inigobanen otcibaiatigomi8an, pejig okitcinikikag inekena acitc pejig onamadinikikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","A8iagog ka pimose8agobanen iima ki kitci 8e8ebik8ebanio8ag acitc okitci mamanazoma8abanin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Odina8abanin dac: “Kin ka 8i nici8anadjito8aban kitci aiamiemigi8am, acitc kidji gi koki ojito8an kodag nisokajik eta kidji tajikaman, kin tibina8e pimadjiidizon, kicpin teb8e Kije Manido Og8izisan epitci aiaa8i8anen, acitc nisada8en kitcibaiatigomikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mi pejig8an, Coda8inni kitci aiamie ogimag, Coda8inni kikinoamage8innig, acitc Coda8innig ka niganizi8adj omanenima8abanin e ikido8adj: ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Kodagian a8iagon ogi pimadjian, 8in dac tibina8e ka8in okackitosin kidji pimadjiidizodj! Kicpin teb8e Israel a8iagog odogimami8an aiaa8idj, kada nisada8eban nogom otcibaiatigomikag, nida teb8eta8anan dac.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Acitc dac ogi ina8an: “Kije Manidokag ki iji apacenimogoban. 8a8adj ki ikidogoban: ‘Nin Kije Manido Og8izisan.’ Misa dac kiga 8abadananan ke apitci nda8enimag8enin nogom Kije Manido kidji pimadjiadjin!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ke8ina8a kimodi8innig, nenida8ina Jesosikag kagi iji acidak8a8agani8i8apan, mi pejig8an okitci mamanazoma8abanin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","E abitakijigag, ki odji kacki tibikise mizi8e akikag, pinici kidji nisotibaiganeag e ick8a abitakijigag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","8aiej e ani nisotibaiganeanig, Jesos ki kitci pibagi: “Eli! Eli! Lema sabaktani?” mi ekidomagag: “Nikije Manidom! Nikije Manidom! 8egonen 8edji ki naganijian?” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nandam iima ka te8apan ogi noda8a8an, acitc ki ikido8ag: “Niganadjimo8inni Elin onad8e8eman!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Teci8ag dac pejig ii e taci8adj ogi a8i nadjibat8an ka opani8anig kasiigani. Ogi kidagaminan dac cominabokag ka kitci 8isagagaminig, acitc ogi inak8aama8an Jesosan odonikag, mitigoni e abadjitodj, kidji minik8endjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kodagiag dac a8iagog ikidobanig: “Keck! Kiga 8abadananan kicpin teb8e Eli ke apitci pijag8en kidji pi nda ag8acimadjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mina8adj dac Jesos ki kitci pibagi, midac ka iji ick8anamodj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ii maia apitc, Coda8inni kitci aiamiemigi8amikag kitci kibigaigan abita ki tadose, icpimig pinici tcabacic. Ki kitci k8ig8an, acitc asinig ki kitci kibickise8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","8ibabikiniganan ki cegode8an, acitc kitci mane Kije Manido odanicinabeman kagi nibonipanin ki abidjiba8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ki sagidjise8ag dac igi o8ibabikinigani8akag, acitc apitc ka ick8a abidjibadj Jesos, ki pidige8ag Jerusalemikag, kitcit8a odenakag. Kitci mane a8iagon dac ogi 8abamigo8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Cimaganici ogima dac acitc kakina ocimaganiciman ka kana8enima8apanin Jesosan ogi 8abadana8a e kitci k8ig8anig acitc kakinagotc eji8ebanig. Ki kitci segizi8ag dac acitc ki ikido8ag: “Teb8e mi aa Kije Manido Og8izisan!” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Mane ik8e8ag te8agoban iima, pagi 8asag e odji kana8abi8adj adi eji8ebanig. Galilee akikag ogi pi odji nosone8a8agoban Jesosan kidji 8idoka8a8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mani Magdala iima tegoban, acitc ke8in kodag Mani, mi ini Jak acitc Josep odjodjomi8an, acitc dac Zebedee odik8eman, mi ini Jak acitc John odjodjomi8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","E ani onag8icinig dac, pejig nabe ka kitci oconiamidj ki odji tag8icinogoban, Animati (Arimathée) odenag ka odjipan. Josep ijinikazogoban acitc ke8in oteb8eta8abanin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ogi nda 8abaman dac Pilatan kidji k8ag8edjimadjin Jesosan o8ia8ini. Pilat dac ki ikido kidji minagani8indjin Josepan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Midac Josep ka iji odapinag Jesosan o8ia8ini, acitc ogi 8ik8eiginan ocki 8abiskiginokag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ogi nda naaton dac 8inigotc o8ibabikiniganikag, maiagotc nogom kagi iji monaigadenig asinikag. Ogi taditibinan dac kitci asinin kidji kibaag 8ibabikinigani. Midac ka iji madjadj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mani Magdala acitc kodag Mani iima te8agoban ke8ina8a, e taji abi8agobanen nigan 8ibabikiniganikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mina8adj e kijeba8aganig, apitc e Coda8inni aiamie kijiganig, Coda8inni kitci aiamie ogimag acitc igi8e ka nagadjito8agobanen inakonige8inan ma8asag ogi nda 8abama8an Pilatan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ogi ina8an dac: “Nidogimaminan! Nimika8imin egi ikidopan aa ka kagina8ickidj nabe meg8adj kiabadj e pimadizipan: ‘Ick8a nisogonagag, niga abidjiba.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Anonik dac kicimaganicimag 8e8enda kidji kana8endamo8adj 8ibabikinigani, pinici kidji ick8a nisogonaganig, ega dac okikinoamaganan kidji gi pi nadji8idondjin o8ia8, acitc dac ega kidji gi tibadjimondjin egi abidjibadj nibo8inikag. Kicpin mega kagina8icki8apan e ikido8adj egi abidjibandjin Jesosan, na8adj a8acamej kada madjiseban apitc8in kagi iji madjiseg apitc ka kagina8ickidj Jesos e mikomidizodj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilat dac ogi inan: “8adan ogo cimaganicag. Madjaok acitc a8i nagadjitaok kitci 8e8enda adi eji kackito8eg 8ibabikinigan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ki ija8ag dac 8ibabikiniganikag, acitc ogi kikina8adjibi8a8an ini kitci asinin ka kibockodjigendjin 8ibabikiniganikag, kidji gi odji kikendamo8adj kicpin a8ian ka apitci adjibinag8enin asinin kidji pidigendjin 8ibabikiniganikag, acitc cimaganican ogi anona8an kidji nagadjitondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ka ick8a Coda8inni aiamie kijiganig, apitc ka mokaamindjin kizison e manadjitagani8anig, Mani Magdala acitc kodag 8aa Mani ki ija8agoban 8ibabikiniganikag ka iji asagani8igobanen Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ii apitc ki kitci k8ig8ani. Pejig dac Kije Manido odajeniman 8ak8ikag ki pi odji najise8an. Ogi nda taditibinan kitci asinin ka odji pidigani8anig 8ibabikiniganikag, acitc ki 8agidabi asinikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ki kitci 8aseasige aa ajeni, acitc mi maia tabickotc kon ka apitci 8abiganigin odaiman. ");
INSERT INTO alqALGNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Cimaganicag dac ka kana8endamo8adj 8ibabikinigani ki kitci ninigise8ag ka apitciniji8adj, acitc ki pagicinog motcikag mi maia ka nibo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Aa dac ajeni ogi inan ik8e8an: “Ka8in segizikegon! Nikikendan e nanada 8abameg Jesos, 8in kagi acidak8a8agani8idj tcibaiatigokag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ka8in aja ooma tesi. Ki abidjiba nibo8inikag, maiagotc kagi ikidopan kidji iji8ebizidj. Inabiok! 8adan ooma ka iji asagani8ipan. ");
INSERT INTO alqALGNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","8ibadj a8i 8idamaokog okikinoamaganan: ‘Jesos ki abidjiba nibo8inikag, acitc kiga piigo8a Galilee akikag. 8edi dac kiga odji 8abama8a.’ Mi oo8e ka pi ininagok,” ki ikido ajeni. ");
INSERT INTO alqALGNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kitci 8ibadj dac ogi nagadana8a 8ibabikinigani, e kitci segizi8adj pekic acitc e kitci modjigendamo8adj. Ki ipato8ag dac e nda 8a8idama8a8adjin Jesosan okikinoamagani. ");
INSERT INTO alqALGNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kitci kaiezigotc Jesosan ogi pi nda nagickago8an acitc ogi anamikago8an. Igi dac ik8e8ag ogi nazika8a8an, ki nibak8ibanio8ag e na8adjizidebina8adjin, acitc ogi icpenima8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesos dac ogi inan: “Ka8in segizikegon! A8i 8idamaokog nidjiki8eg kidji ija8adj Galilee akikag. Mi iima ke iji 8abamiji8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Meg8adj e ani pimose8adj igi ik8e8ag, nandam cimaganicag ka kana8endamo8agobanen 8ibabikinigani ki koki ija8ag odenakag acitc ogi 8idama8a8an Coda8inni kitci aiamie ogiman kakina adi kagi iji8ebanig. ");
INSERT INTO alqALGNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Coda8inni kitci aiamie ogimag dac mama8 ki ma8adjiidi8ag acitc ka niganizi8adj. Ki nakomo8ag dac kidji mina8adjin cimaganican kitci mane conian. ");
INSERT INTO alqALGNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ogi ina8an dac: “8adan oo8e ke inadjimo8eg: ‘Jesos okikinoamaganan ki pija8an 8ibabikiniganikag meg8a tibik, acitc ki kimodi8an o8ia8 meg8adj e taji nibaiag.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kicpin dac Pilat nodagedj oo8eni, nina8it niga nda aiamianan. Ka8in dac kiga odji animiigosim.” ");
INSERT INTO alqALGNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Igi8e dac cimaganicag ogi odapina8an ini conian acitc ki inadjimo8ag ka inanonagani8i8adj kidji ikido8adj. Midac iidi kakina Coda8innikag ki ani obeckamagan ii tibadjimo8in, pinici nogom. ");
INSERT INTO alqALGNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ka midatcin acitc pejigondjin dac Jesos okikinoamaganan ki ija8an Galilee akikag, acitc ogi oditana8a iima pik8adinakag adi Jesos kagi inadjin kidji ijandjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Apitc ka 8abama8apanin Jesosan, ogi icpenima8an. Nandam dac pekic e taci8adj ki k8ina8i inendamo8agoban. ");
INSERT INTO alqALGNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesos dac ogi nazika8an acitc ogi inan: “Nigi minigo macka8izi8in kidji ogima8ian 8ak8ig acitc akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Paba nda 8abamikog dac kakina a8iagog kakinagotc ka inakanezi8adj, acitc kikinoamaokog kidji nosoneoji8adj. Sigaadaokog dac e abadjito8egon o8izoni8a Kije Manido Kidadaminan acitc Og8izisan acitc Omino Manidoman. ");
INSERT INTO alqALGNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Kikinoamaokog dac kidji nosoneamo8adjin kakina ini inakonige8inan kagi mininagok. Nin dac, apanigotc kiga 8idjionom, pinici kidji ponaki8ag.”");
INSERT INTO alqALGNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Mi oo8e e odji madjitamagag min8adjimo8in, ka iji mikomagani8idj Jesos Christ, Kije Manido Og8izisan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Niganadjimo8inni Isaia omazinaiganikag 8eckadj ki niganadjimogoban e ojibiigedj: “Kije Manido ikido: Niniganinija8a aa8e ke tibadjimodj nidikido8ini, kidji nigani ojitamaok kimikanani adi ke ani ijaian.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“A8iag kada tag8icin kidji pabibagidj pig8adakamigokag. Mi oo8eni ke ikidodj: Eco8iok kidji tag8icig ka Tibendjigedj. Ojitamaok e k8aiakojimonig mikanani.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Cabadis dac ki odji tag8icinogoban pig8adakamig. Sigaadagegoban acitc kagik8egoban oo8eni e ikidodj: “An8endizok acitc sigaadazok. Midac Kije Manido kiga kasiamago8a kipatado8ini8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kitci mane a8iagog ka tajike8agobanen Coda (Judée) akikag acitc Jerusalem odenani ogi pi nda 8abama8an ini Cabadisan. 8idamage8agoban egi patadi8adj, Cabadis dac Jourdain sibikag ogi iji sigaada8agoban. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ka nijo pik8aoganendjin a8esizi8aianan ijiogoban Cabadis, acitc pack8egino kitcipizonan okigicka8abanin opik8anakag. Papakinen inadjigegoban acitc amo sizibak8adoni pig8adakamigokag kagi iji mikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","O8idama8abanin a8iagon: “Aa a8iag nage ke pi tag8icig, na8adj kitci macka8izi apitc8in nin. Ka8in tibise nidapitendagozisi kidji camagian acitc kidji abiskobida8agin omakizinan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nin nibikag kigi sigaadaonom. 8in dac, Mino Manidokag kiga iji sigaadago8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ii apitc, Jesos Nazaret odenajicikag ki odosegoban, Galilee akikag, acitc Cabadisan ogi sigaadagon Jourdain sibikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Apitc dac Jesos ka ag8azigobanen nibikag, ogi 8abadan 8ak8ig e cesenig, acitc ogi 8abaman Mino Manidon e pi najisendjin 8agidj 8inikag, mi maia omimi ka 8abizidj ejinagozindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Midac ogi noda8an a8ian 8ak8ig e odji mad8e anim8endjin: “Kin Nig8izis ka kitci sagiinan. Kikitci min8endamiijinan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Teci8ag dac Mino Manido ogi ijinija8an Jesosan ka iji pig8adakamiganig. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nimidana tasogon inigik Jesos ki tajikegoban 8edi pig8adakamig. Iima dac kitci madji manidon ogi k8ag8e 8agackibinigon Jesos. Pig8adakamig a8esizan o8idji tajikemabanin ii apitc, acitc ajenin o8idokagobanin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kegapitc ki takonagani8i Cabadis. Jesos dac ki ija Galilee akikag, e paba kagik8edj min8adjimo8ini Kije Manidokag ka odjimaganig. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ki ikido dac: “Aja peconag8ani Kije Manido Odogima8i8in. An8endizok dac acitc teb8etamok Kije Manido omin8adjimo8in,” ki ikidogoban Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Meg8adj e pimosepan tcigagam Galilee sagaiganikag, Jesos ogi 8abaman nijin kigozike8innin e taji pagida8andjin. Simo dac aa pejig ijinikazo, kodag dac mi ini o8idjiki8en, Andre ijinikazo8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesos dac ogi inan: “Pijaok! Nosoneocik! Kiga 8abadainom dac adi ke todameg kidji pidji8ineg8a a8iagog ninikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Teci8ag dac ogi nagana8an odasabi8an. Midac ka iji nosone8a8adjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","A8acic 8edi ki iji madja Jesos, acitc ogi 8abaman nijin naben, Jak (Jacques) acitc o8idjiki8en John ka ijinikazondjin, mi ini Zebedee og8izisan. Otcimani8akag te8agoban, e taji 8a8ejaasabi8agobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Apitc Jesos ka 8abamadjin Jakan acitc Johnan, teci8ag ogi nd8e8eman. Ogi nagana8an odadami8an tcimanikag kigi odanokitage8innimi8an. Midac ka iji nosone8a8adjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesos acitc okikinoamaganan ki ija8agoban Kaponaom (Capernaüm) odenani. E Coda8inni aiamie kijiganig, Jesos ki pidige Coda8inni aiamiemigi8amikag acitc ki madjita kidji kikinoamagedj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kakina a8iagog ka noda8a8adjin ki kitci mamakadendamog adi ka iji kikinoamagendjin. Ka8in mega odji iji kikinoamagesi tabickotc Coda8inni kikinoamage8innig ka iji kikinoamage8apan odinakonige8ini8akag. Apitc e kikinoamagegobanen Jesos, kikenimagani8iban ako e kitci macka8izidj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kitata dac pejig nabe e kigickagodjin madji manidon ki pidige Coda8inni aiamiemigi8amikag. Ki pabibagi oo8e: ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“8egonen neda8endaman nina8itinakag, Jesos Nazareti8inni? Kigi pi nda nici8anadjiijinam na? Kikikenimin, kin ka kitcit8a8izian, Kije Manido kagi pidjinijaogo8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesos ogi kitci kaganonan ini8e madji manidon acitc ogi inan oo8eni: “Ponimon! Sagaan 8inikag!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Aa madji manido ogi kitci mamadjibinan ini naben acitc ki odji sagaam o8ia8inikag e kitci pabibagidj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kakina a8iagog ki kitci mamakadendamobanig acitc ki k8ag8edjimidi8agoban: “8egonen dac ii? Ocki kikinoamage8ini ka kitci macka8izimaganig odaian 8aa nabe. Okaganonan 8a8adj madji manidon, onadotagon dac.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kitci 8ibadj dac mizi8ena Galilee akikag ki nodagani8an e mikomagani8idj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesos acitc okikinoamaganan ogi nagadana8a ii8e Coda8inni aiamiemigi8amini, midac teci8ag Simon acitc Andren omigi8aminikag ka iji ija8agobanen, Jak acitc John e 8idjiogo8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simo ozigosan pimakocinobanin onibe8inikag, e kitci kijizo8apinendjin. Teci8ag dac ka tag8icig Jesos, ki 8idama8agani8i e akozindjin ini8e ik8e8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ogi nda 8abaman dac acitc ogi na8adjindjibinan, midac ogi pazig8ian. Ki poni kijizo, acitc ki madjita kidji mikimodj aa ik8e kidji acamadjin kakina a8ian. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Apitc e ani onag8icinig, ka ick8a pagicimonig, ki iji8inagani8i8ag Jesosikag kakina ka akozi8adj acitc a8iagog ka kigickago8adjin madji manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kitci mane a8iagog iima odenag ka odji8apan ki ma8adjiidibanig pecodj ick8ademikag iima Simon omigi8aminikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesos dac ogi kigean mane a8ian anodjigotc ka inapinendjin acitc ogi sagidjinija8an ii apitc kitci mane madji manidon a8iagokag. Ka8in dac Jesos ododji pagidinasi8an ini madji manidon kidji anim8endjin, okikenimigobanin mega a8enen 8in maia. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kitci 8ibadj mina8adj e kijeba8acinig, ab8amaci mokaag kizis, Jesos ki 8anicka acitc ki sagaam Simon omigi8aminikag. Midac ag8adjik odenag ki ija, ega ka iji tani8anig, kidji nda aiamiedj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simo acitc o8idji8aganan ogi nanada 8abama8an Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Apitc dac ka mika8a8adjin, ogi ina8an: “Kakina a8iagog kinanada 8abamigog.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesos dac ogi inan: “Paba ijadan kodagian odenajican. Panima acitc ki kagik8eian 8edi, mi mega 8edji ki pijaian ooma.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ki paba ija dac mizi8e Galilee akini. Paba kagik8egoban pepakan Coda8inni aiamiemigi8amikag acitc osagidjinija8agoban madji manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Pejig nabe e kitci omigi8apinedj ogi nda 8abaman Jesosan. Ogi pi nibak8ita8an acitc ogi kitci pagoseniman kidji kigeigodjin, e ikidodj: “Kicpin iji nda8endaman, kikackiton kidji kigeijian.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesos ogi kitci kidimageniman. Ki tesindjita, acitc ogi saminan, e inadjin: “Kinada8enimin kidji kigean. Kigen sa dac.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Teci8ag dac odakozi8in ogi pagidinigon aa nabe acitc ki kige. ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Midac Jesos teci8ag ogi madjinija8an acitc 8e8enda ogi 8idama8an: ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ndotan! Ka8in a8iag 8idama8aken egi kigeinan. Anic dac nda 8abadai Coda8inni aiamie ogima adi ejinagozian nogom, acitc migi8en ii pagidinige8ini Mois kagi inakonigedj kidji todjigadenig. Mi kidji gi teb8etamo8adj kakina a8iagog egi kigean.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Misa8adj dac, aa nabe ki madja acitc ki paba tibadjimo adi ka iji8ebizidj. Ka8in dac mina8adj Jesos ogi odji kackitosin kidji 8abamagani8idj anodjigotc odenakag. Panima ag8adjik odenakag tajikegoban adi ega eji tani8anig. Kakina dac a8iagog ogi pi nda 8abama8an Jesosan, kakinagotc e odose8agobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Maneogon ick8a ii, Jesos ki koki pija Kaponaom (Capernaüm) odenag, acitc mane a8iagog ogi kikendana8a egi koki pi ki8endjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kitci mane dac a8iagog ki iji ma8adjiidi8ag iima migi8amikag ka iji tajikenigobanen. Ka8in dac tibise ta8atesinogoban ke iji abinani8ag, ka8in 8a8adj ag8adjik ick8ademikag. Jesos dac ki kikinoamage. ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nandam a8iagog ki odji tag8icino8agoban, e iji8ina8adjin Jesosikag pejig naben ega e mazikandjin, ni8in e taci8adj e pimi8ina8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ka8in dac okackitosina8aban kidji pidige8ina8apanin adi e tendjin Jesosan, epitci kitci manenani8anigobanen. 8agidabak8an dac ogi ik8ada8e8ina8an, acitc ogi pagonebak8eana8a tibickotc adi Jesos eji tegobanen. Midac iima ka odji pagonebak8eamo8adj ka iji nisabikena8adjin ini8e ega ka mazikandjin, apicimonikag e iji pimakocinogobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Apitc Jesos 8eabamadjin ini a8iagon kagi pidji8inandjin ini naben adi epitci sogi teb8etamindjin, ogi inan ini8e ega ka mazikandjin: “Nig8izis! Aja ki kasiigade8an kipatado8inan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nandam Coda8inni kikinoamage8innig e taji abi8agobanen iima ki inendamo8agoban: ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Adi 8edji ikidodj ii? Omanazoman Kije Manidon! Ka8in a8iag tesi e kackitodj kidji kasiamagedj patado8inan, Kije Manido eta okackiton!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesos teci8ag okikendanagoban adi enendaminigobanen, acitc ogi inan: “8egonen 8edji inendameg ii? ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Na8adj na 8edandok kidji inag aa8e ega ka mazikadj: ‘Aja ki kasiigade8an kipatado8inan,’ kek8an: ‘8anickan, odapinan kidapicimon, acitc pimosen’ kidji inag? ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kinada8eniminom mega kidji kikendameg Aa8e Ka pi Anicinabe8iidizodj e kackitodj kidji kasiamagedj patado8ini ooma 8akidakamig,” ki ikido. Ogi inan dac ini8e ega ka mazikandjin: ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ki8idamon, 8anickan, odapinan kidapicimon, acitc ki8en kimigi8amikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Meg8adj dac kakina a8iagon e kana8abamigogobanen 8aa ega ka mazikadj, teci8ag ki 8anicka, ogi odapinan odapicimon, acitc ki ki8e. Kakina ka 8abama8adjin ki kitci mamakadendamog acitc ogi icpenima8an Kije Manidon, e ikido8adj: “Ka8in 8ikad nidodji 8abadasinanan oo8e kegon ka iji8ebag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesos ki koki ija tcigagam Galilee sagaigani. Kitci mane a8iagon ogi pi nda 8abamigobanin, acitc ogi kikinoama8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Meg8adj e pimaadodj, Lepin (Lévi) ogi odji 8abaman, Alpi (Alphée) og8izisan. Ojibiige8igi8amikag ka iji ma8adjiagani8indjin conian e kijikaomagani8indjin kitci ogiman taji abigoban. Jesos dac ogi inan: “Nosoneocin.” Lepi dac ki pazig8i acitc ogi nosone8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kegapitc Jesos ki nda 8isinigoban Lepin omigi8aminikag. Kitci mane8agoban ka ma8adjia8adjin conian kitci ogiman odji acitc kodagiag madji a8iagog ka inenimagani8i8apan, e 8idji 8isinima8apanin Jesosan acitc okikinoamaganan. Kitci mane mega igi ka inadizi8agobanen onosone8a8agoban Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nandam dac Coda8innig ka nagadjito8agobanen inakonige8inan, ka kikinoamage8agobanen acitc ini inakonige8inan, ogi 8abama8agoban Jesosan e 8idji 8isinimandjin ini8e a8iagon. Ogi ina8agoban dac Jesosan okikinoamaganan: “8egonen 8edji 8idji 8isinimadjin ini8e ka ma8adjiandjin conian kitci ogiman odji acitc ini8e ka madji inadizindjin?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesos dac ogi noda8an acitc ogi inan ini Coda8inni kikinoamage8innin: “A8iagog ka mino pimadizi8adj ka8in onada8enimasi8a8an mackiki8innin, mi eta ka akozi8adj. Ka8in nidodji pijasi kidji nd8e8emag8a ka kitci k8aiak8enimidizo8adj a8iagog, tiegodj nigi pija kidji nd8e8emag8a ka patadi8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nigodin Cabadis okikinoamaganan acitc Coda8innig ka nagadjito8agobanen inakonige8inan pagidadjigebanig. Nandam dac a8iagog ogi pi nda k8ag8edjima8an Jesosan: “Cabadis okikinoamaganan acitc Coda8innig ka nagadjito8adjin inakonige8inan okikinoamagani8an pagidadjige8an. 8egonen dac 8edji ega pagidadjige8adj kin kikikinoamaganag?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesos dac ogi nak8e8ajian: “Kidinendana8a na kadagi pagidadjige8ag igi8e kagi nd8e8emagani8i8adj e niba8inani8anig, meg8adj ini naben ka niba8indjin e 8idji8a8adjin? Ketcinadj ka8in ii ijisesinon! Inigikigotc ke 8idji8a8adjin ini naben ka niba8indjin, ka8in kadagi pagidadjigesi8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kegapitc dac kada odjitcise panima kidji madjadj aa ka niba8idj. Midac pidjinag ke pagidadjige8adj ka nd8e8emagani8i8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ka8in a8iag odabadjitosin ocki kegojicini kidji pag8aag kete kegojicini. Ii mega ocki kegojic kada odji manise kete kegojicikag. Midac kiabadj kada ani magi tadocka. ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Acitc dac ka8in a8iag kete nibi8ajikag ka pack8egino8anigin odiji siginasin ocki cominaboni. Kicpin mega iidi todag, kada pakodjisemaganon ini nibi8ajan ka pack8egino8agin ocki cominabo kagi iji siginigadeg. Midac kicominabom acitc kinibi8ajan ma8asag eck8a abadagin. Ka8in 8in iidi! Panima ocki pack8egino nibi8ajikag ki iji siginigadeg ocki cominabo.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nigodin meg8adj e Coda8inni aiamie kijiganig, Jesos acitc okikinoamaganan opimi cabocta8eckana8agoban ka iji kitigani8anig anominan. Meg8adj e pimode8adj, igi kikinoamaganag ki madjita8agoban kidji ma8adjia8adjin nandam anominan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nandam Coda8innig ka nagadjito8agobanen inakonige8inan ogi ina8an Jesosan: “Kijigabamik! 8egonen kikikinoamaganag 8edji ma8adjia8adjin anominan meg8adj e aiamie kijiganig? Ikidomaganon kidinakonige8inanan ega e inendagozi8adj kidji todamo8adj iidi.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesos dac ogi nak8e8ajian: “Kana 8ikad kidodji nabo8adasina8a Kije Manido Omazinaiganikag adi ka todamogobanen ogima David? Nigodin midjimini onada8endana8agoban 8in acitc o8idji8aganan e mamida8askade8agobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","David dac ki pidigegoban Kije Manidon odaiamiemigi8aminikag acitc ogi am8an pak8ejiganan Kije Manidon kagi ca8enimagani8indjin. Ii apitc Abiatar Coda8inni aiamie ogima8igoban ma8adji ka niganizipan. Kidinakonige8inanan ikidomaganon Coda8inni aiamie ogimag eta kidji am8a8adjin ini pak8ejiganan. Anic dac David ogi odapinan acitc ogi minan o8idji8aganan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesos kiabadj ogi inan: “Kije Manido ogi ojiton e aiamie kijiganig a8iagog odji. Ka8in ododji kijenimasin ini a8iagon kidji tibenimigondjin ii ka aiamie kijiganig. ");
INSERT INTO alqALGNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nin dac, Ka pi Anicinabe8iidizodj, nitibendan ii ka Coda8inni aiamie kijigag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nigodin Coda8inni e aiamie kijiganig Jesos ki koki pidige Coda8inni aiamiemigi8amikag. Pejig nabe iima tegoban ega e mazikanig onidji. ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nandam dac a8iagog iima ka te8agobanen, kitci 8e8enda okijigabama8agoban Jesosan kidji gi 8abama8adjin kicpin ke apitci kigeag8enin ini naben e aiamie kijiganig, kidji gi inactaona8adjin egi panaagendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesos ogi inan ini naben ega ka mazikanig onidjini: “Pazig8in iima, kakina a8iagog kidji gi 8abamik8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Midac Jesos ogi k8ag8edjimagoban a8iagon ka kana8abamigodjin: “Adi maia enakonigemagagin kidinakonige8inanan? Ikidomaganon na kidji mino toda8aiak a8iag meg8adj e Coda8inni aiamie kijigag, kek8an kidji madji toda8aiak? Inakonigemaganon na kidji 8idoka8aiak a8iag kidji gi kana8endag opimadizi8in, kek8an kidji nici8anadjita8aiak opimadizi8in?” Ka8in dac odji kidosi8agoban. ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesos dac kakina ini a8iagon ogi kana8abaman e kiji8azidj. Pekic dac kitci kackendamoban, kitci cibictig8anenigoban mega ini a8iagon. Jesos dac ogi inan ini naben: “Pi ijindjitan.” Midac ka todag, acitc teci8ag k8aiak ki koki mikimomagani onidji. ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Igi dac Coda8innig ka nagadjito8agobanen inakonige8inan ki odji sagaamog aiamiemigi8amikag, acitc ki nda ma8adjiidi8ag kigi Herod odanodaganan, kidji nanada8i kikendamo8adj adi ke todamo8apan kidji gi nisa8apanin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesos acitc okikinoamaganan ki ija8ag Galilee sagaiganikag, acitc kitci mane a8iagon ogi nosoneogo8an. Galilee akikag odji8agoban igi a8iagog, acitc Coda (Judée) akikag, ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem odenag, Idome (Idumée) akikag, kodag akikag k8ekagam Jourdain sibi, acitc ii akikag pecodj Tir (Tyr) acitc Sidon odenan. Igi dac a8iagog ogi nda 8abama8an Jesosan egi nodage8apan kakina kegoni kagi inakamigizinigobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Epitci manenani8anig, Jesos ogi k8ag8edjimabanin okikinoamaganan tcigagam kidji pido8adj tcimanijicini kidji gi pozidj, ega a8iagon kidji sidjickagodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mane mega a8iagog ka akozi8adj ok8ag8e pec8abama8abanin Jesosan kidji gi tagina8adjin, egi nodage8apan mane a8iagon egi kigeagobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","A8iagog ka kigickago8agobanen madji manidon, apitc ka 8abama8agobanen Jesosan, ozidinikag pagicino8agoban acitc pabibagi8agoban: “Kin Kije Manido Og8izisan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Midac Jesos ki kitci sogigij8e ega kidji tibadjimondjin a8enen 8in. ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesos pik8adinajicikag ki ijagoban. Ogi nd8e8eman dac ini8e ka nda8enimadjin, ogi pi nazikagon dac. ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Midatcin acitc nijin ogi onabaman, Odanodaganan kidji ijinikanagani8indjin. Ogi onabaman kidji gi paba 8idjiogodjin, kidji gi ijinija8adjin kidji nda paba kagik8endjin, ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","acitc kidji gi aiamindjin macka8izi8ini kidji gi sagidjinija8andjin madji manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Mi ono8e ka midatcin acitc nijindjin a8iagon ka onabamadjin: Simo, Jesos ka adjinikanadjin, Pien e ijinikanadjin; ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jak (Jacques) acitc John, midjinijin Zebedee og8izisan, Jesos ka adjinikanadjin, Bo8anejes (Boanergès) kidji ijinikanadjin, “A8iagog ka macka8izi8adj tabickotc inimikin” ka ikidomagag; ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andre, Pilip (Philippe), Batelemi (Barthélemy), Matio (Matthieu), Tomas (Thomas), Jak, 8in Alpi (Alphée) og8izisan, Tadi (Thaddée), Simo, 8in ka acidagimagani8igobanen taji ka iji ma8asag8akonidindjin ega ka nda8endaminigobanen kidji tibenimigo8adjin ogiman Rom ka odjindjin, ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","acitc Judas Iskaniot (Iscariote), 8in nage ka mamijimadjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jesos dac ki koki ki8e migi8amikag ka iji tajikegobanen acitc mina8adj kitci mane a8iagog ki ma8adjiidi8ag iima. Ka8in dac Jesos acitc okikinoamaganan ick8atasi8agoban kidji 8isini8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Apitc Jesos otcina8emaganan ka kikendamindjin ii, ki pija8an kidji pi nadji8inigodjin. Odinenima8abanin mega: “Ki8ack8edok aa!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nandam Coda8inni kikinoamage8innig, Jerusalem ka odji8adj, ikido8agoban: “Kitci madji manido ogima, ‘Beelzebul’ ka ijinikazodj okigickagon.” Acitc kiabadj ki ikido8agoban: “Aa8e ka kackakanadjin madji manidon, mi aa8e ka minadjin Jesosan macka8izi8ini kidji gi sagidjinija8andjin madji manidon.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesos dac ogi nd8e8eman ini Coda8inni kikinoamage8innin acitc ogi aiamian, adisokani e abadjitodj kidji kikinoamagedj: “Kidinendana8a kitci madji manidokag e odjimagag nimacka8izi8in. Adi dac kitci madji manido ke odji sagidjinija8adjin kodagian madji manidon ka tibenimadjin? ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kicpin a8iagog pejig ogima8i8inikag ka tajike8adj iji ma8asago migadi8adj pepejig e taci8adj, ka8in kadagi pimadjiomagasinon ii ogima8i8in. ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Acitc kicpin a8iagog ka pejigode8izi8adj migadi8adj, ka8in kiabadj kadagi pimadjiomagasinon ii pejigodena. ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Midac pejig8an, kicpin kitci madji manido 8inigotc tibina8e migandizodj, kicpin nenicikesenig odogima8i8in, ka8in kadagi pimadjiomagasini odogima8i8in. Kada ick8aseni omacka8izi8in.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ka8in a8iagigotc kadagi pidigesi ka macka8izindjin a8iagon omigi8aminikag kidji gi nda kimodimadjin odaimini kicpin ega pinama mag8apinadjin ini ka macka8izindjin naben. Apitc ick8a mag8apinadjin, oga kackiton kidji kimodimadjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Teb8e ki8idamonom, kadagi kasiama8agani8i8ag a8iagog kakina opatado8ini8an, acitc kakina kagi iji manad8e8adj acitc ka iji madjigij8e8adj kadagi kasiama8agani8i8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Anic dac a8enenigotc ke maskenimag8enin Mino Manidon, ka8in 8ikad kada kasiama8agani8isi. Kagige patado8ini oga kigickan,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Mi ka iji nak8e8ajiadjin ini a8iagon ka ikidondjin: “Jesos madji manidon okigickagon.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesos odjodjoman acitc o8idjiki8en ki tag8icinobanin. Ag8adjik migi8amikag paba tajigaba8ibanig acitc pejig a8ian ogi ijinija8a8agoban kidji a8i nd8e8emandjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kitci mane a8iagog taji abi8agoban 8ajagam Jesosikag acitc ki inagani8i Jesos: “Kidjodjom acitc kidjiki8eg ag8adjik te8ag, kinada8enimigog dac.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesos dac ogi nak8e8ajian: “A8enen dac aa nidjodjom acitc a8eneni8ag igi nidjiki8eg?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Midac ogi kana8abamagoban a8iagon ka 8ajagamebindjin 8inikag acitc ki ikido: “Kijigabamikog! Mi ogo8e nidjodjom acitc nidjiki8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","A8enenigotc mega ke ijitcigedj adi eji nda8endamindjin Kije Manidon, mi aa nidjiki8e kek8an nidjodjom.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesos mina8adj ki madjita e kikinoamagedj tcigagam Galilee sagaiganikag. Kitci manebanin a8iagon e ma8adjiidindjin 8ajagam 8inikag, pidonag dac ki iji nda abigoban. Ag8idinoban ii tciman nibikag, a8iagog dac tcigagam te8agoban. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Adisokanan dac odabadjitonagobanin e kikinoamagedj mane kegoni. Ogi inan dac: ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ndotamok! Nigodin pejig kitige8inni ki nda kitigegoban. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Meg8adj dac e taji kitigegobanen odanominiman okitigan akikag, nandam mikanakag ki inagodjino8an. Pinecijag dac ogi pi nda am8a8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kodagiag dac anominag ka iji asini8akamiganig ki inagodjinog, ka iji ega kipagakamiganig. Teci8ag dac ki madjigi8ag anominag, ega e manenig akini. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Apitc dac ka ani icpagodjig kizis, ki ick8ade8an ini kitiganijican acitc ki pate8an, ega tibise e kin8agin 8adabin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nandam dac kodagiag anominag ka iji minesatigo8anig ki inagodjinog. Meg8adj dac ka pimigigin ka min8acigin kitiganan, minesatigog acitc ki ani madjigi8ag, midac ka iji ani kib8anamockigadegin kidji gi minogigin ka min8acigin kitiganan, ka8in dac ki odji mini8asino8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kodagiag dac nandam anominag ka iji min8acinig akini ki inagodjinog. Kitiganan dac ki madjiginon acitc ki minoginon, acitc minan ki nta8iginon, nanandam nenisomidana8edon e azaodegin, nanandam dac nenigod8asomidana8edon, acitc dac nanandam memidasomidana8edon e azaodegin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jesos kiabadj ki ikido: “Kakina kina8a keckito8eg kidji nisidotameg, 8e8enda ndotamok.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Apitc Jesos ka naganadjin ini kitci mane a8iagon, mi eta ka midatcin acitc nijindjin okikinoamaganan acitc pagi kodagian a8iagon o8idjiogobanin. Ogi k8ag8edjimigon dac kidji 8idama8adjin adi ekidomaganigin ini adisokanan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ogi nak8e8ajian dac: “Kina8a kigi odisigona8a kidji kikendameg Kije Manido Odogima8i8in, ega 8ikad a8iag kagi kikendag. Kodagiag dac a8iagog adisokanan nidabadjitonan kidji kikinoama8ag8a kakina kegoni, ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kidji gi iji8ebizi8adj ii ka iji mazinadenig Kije Manidon Omazinaiganikag: ‘8e8enda oga kijigabadana8a, ka8in dac oga nisida8inasina8a. Oga paietetana8a, ka8in dac oga nisidotasina8a. Kicpin dac teb8e nisidotamo8apan ii, kada an8endizobanig acitc Kije Manidon oda kasiamago8an ka iji patadi8adj.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesos dac ogi inan: “Kana kinisidotasina8a ii adisokan? Adi dac ke todameg kidji nisidotameg kodagian adisokanan? ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kitige8inni mi aa ka tibadjimodj Kije Manidon omin8adjimo8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nandam a8iagog e nodamo8adj Kije Manidon omin8adjimo8ini, mi maia tabickotc anominag mikanakag kagi inagodjino8agobanen ejinagozi8adj. Apitc nodamo8adj min8adjimo8ini, teci8ag kitci madji manidon opi nda manibidoni ii min8adjimo8ini kagi kitigani8anig 8ina8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nandam dac kodagiag a8iagog e nodamo8adj min8adjimo8ini, mi maia tabickotc anominag ka iji asini8akamiganig kagi inagodjino8agobanen ejinagozi8adj. Onodana8a min8adjimo8ini acitc teci8ag oteb8etana8a e modjigendamo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ka8in dac macka8izimagasini oteb8etamo8ini8a, acitc ka8in kin8ej okana8endasina8a. Apitc dac madjise8adj, kek8an nanekadjiagani8i8adj Kije Manidon omin8adjimo8ini odji, teci8ag o8ebinana8a oteb8etamo8ini8a. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nandam dac kodagiag a8iagog, mi maia tabickotc anominag ka iji minesatigo8anig akini kagi inagodjino8agobanen ejinagozi8adj. Onodana8a Kije Manidon omin8adjimo8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pekic dac odanimendamiigona8an kegonan ka nda8endamo8adjin kidji pimadjio8adj, acitc omotci nda8endana8a kidji 8anadizi8adj, ega e kikendamo8adj ega odji pejig e apitendag8anig, acitc kodag mosa8endamo8ini ododisigona8a. Kib8anamockigade dac ii min8adjimo8in, ka8in dac odji pejig abadasini opimadizi8ini8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nandam dac kiabadj kodagiag a8iagog, mi maia tabickotc anominag ka iji min8acinig akini kagi inagodjino8agobanen ejinagozi8adj. Onodana8a min8adjimo8ini, oteb8etana8a, acitc odabadjitona8a opimadizi8ini8akag, nandam pagi eta, nandam enigok, acitc nandam okitci abadjitona8a,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesos kiabadj ogi inan a8iagon: “A8iagigotc na o8asakonendjigan odaton anamig akikokag konigotc anamig onibe8inikag? Kana na8adj kada minosesinoban kidji iji atodj 8asakonendjiganatigokag? ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kakina mega kegon ka kadjigadeg kada nag8an, acitc kakina kegon ega maci ka kikendjigadeg kakina a8iag oga kikendan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kakina kina8a keckito8eg kidji nisidotameg, 8e8enda ndotamok.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Iag8amendamok 8e8enda kidji ndotameg! Adi kagi iji toda8eg8a kidjipimadizimi8ag, mi iidi Kije Manido ke todago8eg, acitc 8a8adj kiga todago8a na8adj a8acamej apitc8in kagi iji todameg. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","A8iag mega kegoni ka aiag, a8acamej oga odisigon. Aa dac a8iag ega kegoni ka aiag, misa8adj pagi eta kegoni aiag kada makamagani8i,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kiabadj Jesos ki ikidogoban: “8adan oo ejinag8anig Kije Manido Odogima8i8in. Pejig nabe kitige anominan okitigan akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Taso tibik dac niba acitc 8anicka e kijeba8acinig. Meg8adj dac ii, igi anominag sagigi8ag, acitc kitiganan ani madjiginon. Aa dac nabe ka8in maia okikendasin adi ejisenig kidji nta8iginigin okitiganan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Aki mega tibina8e odobigitonan ini kitiganan, nitam kidji mijacko8agin, mina8adj kidji ani kitigani8anigin, ick8eag dac kidji kiji nta8igi8adj anominag iima kitiganikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Apitc dac igi anominag ick8a kijigi8adj, aa nabe kickija8ani odabadjiton, aja e ijisenig kidji ma8adjitodjin okitiganan,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesos kiabadj ki ikidogoban: “Adi dac kegi ikido8aban kidji 8abadai8eian adi ejinag8anig Kije Manido Odogima8i8in? 8egoneni adisokan kegi abadjito8aban kidji mikodaman Odogima8i8in? ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mi oo ejinag8anig. Mi maia tabickotc anomines ejinag8anig, ma8adji ka kitci agasiminagizidj kakina ka taci8adj anominag apitc kitigani8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Apitc dac kitigani8ag aa anomin, kitci madjigi acitc na8adj ani mitcakozi apitc8in kodagian kitiganan. Kitci madjiginon 8adik8anan acitc dac pinecijag pi nda 8asasonike8ag iima, ega kidji nigodi8adj,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesos ogi abadjitonagobanin kitci mane adisokanan ini ka inakaneanigin kidji gi tibadjimodj Kije Manidon omin8adjimo8ini, inigik a8iagog eji kackito8agobanen kidji nisidotamo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ka8in kegoni ikidosiban ega e abadjitodjin adisokanan. Anic dac apitc ako e 8idji8apanin eta okikinoamaganan, ega e tendjin kodagian a8iagon, kitci 8e8enda o8idama8agoban ini adisokanan, 8e8enda kakina kegoni kidji gi nisidotamindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Apitc e ani onag8icinig ii e kijiganig, Jesos ogi inan okikinoamaganan: “Ijadan 8edi agamig sagaiganikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ogi nagana8an dac ini8e kitci mane a8iagon. Aja tegoban Jesos tcimanikag, okikinoamaganan dac ki pozi8an iima pidonag acitc ogi madji8inigon. Kodagian a8iagon pecodj taji agomonigobanin, ogi nosoneogo8an dac. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kegapitc ki madji kitci nodini acitc ki kitci mamagaani. Kitci pizibigoban ii tciman, maia kegat kozabi8agoban. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Meg8adj dac ii, Jesos odakeonag taji nibagoban, apik8ecimoban. Okikinoamaganan ogi pi kockonigon, acitc ogi igon: “Kikinoamage8inni! Aja kiga nisaba8emin! Kana kinigodinendasin?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesos dac ki kockozi acitc ogi kitci aiamiton e kitci nodinig acitc e kitci mamagaanig: “Pekadj! Pekadizik!” Midac teci8ag ki kitci pekadani acitc ki kitci an8atini. ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesos dac ogi inan okikinoamaganan: “8egonen 8edji kitci segizieg? Kana maci kiteb8etasina8a?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ki kitci segizi8agoban dac acitc ki k8ag8edjimidi8ag: “A8enen dac aa nabe maiagotc? 8a8adj e nodinig acitc nibini onadotagon!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesos acitc okikinoamaganan ki mijaga8agoban Jenasa (Gérasa) ka ijinikadenig akini, k8ekagam Galilee sagaiganikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Apitc Jesos ka kabadj tcimanikag, teci8ag pejig a8ian ki odji sagaamon tcibaigamigokag acitc ogi pi nda nagickagon. Aa nabe ogi pidigeckagogobanin madji manidon, ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","acitc 8ibabikiniganikag iji paba tegoban. Ka8in a8ian okackiigosibanin kidji sagapinigodjin, misa8adj pi8abiko sagapizoneabini e abadanig. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mane8inaj ki mag8apidjigadeni8an onidjin acitc ozidan pi8abiko sagapizoneabin e abadanigin, midac ka iji pigobidodjin ini pi8abiko sagapizoneabin. Ka8in a8ian tibise macka8izisibanin kidji midjiminigodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pijicig ako kabe tibik acitc kabe kijik tegoban 8ibabikiniganikag acitc pik8adinakag, e kitci pabibagigobanen acitc e migandizogobanen asinin e abadjiadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","8asag ogi odji 8abaman Jesosan, ki ipato dac aa nabe Jesosan ka iji tenipanin, acitc ogi pi nibak8ita8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ki kitci kiji8e dac e pabibagidj: “Jesos! Kije Manido ma8adji ka icpendagozidj Og8izisan! Adi eji nda8enimijian? Kipagosenimin, ka8in sanagendjigeijiken!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","8edji ki ikidodj dac ii, Jesos mega ki ikidogoban: “Madji manido! Sagaan iima 8inikag!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesos dac ogi k8ag8edjiman ini naben: “Adi e ijinikazo8an?” Aa nabe ogi nak8e8ajian: “ ‘Mane’ nidijinikazonan, nimanemin mega.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Aa dac nabe ogi kitci pagoseniman Jesosan ega kidji ijinija8andjin ini madji manidon 8asag anodj 8edi. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tebanig iima pecodj kitci mane kokocag e nanada 8isini8adj pik8adinajicikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Midac igi madji manidog ogi kitci pagosenima8an Jesosan: “Kokocikag ijinijaocinam kidji pidigecka8agid8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesos ogi pagidinan. Igi dac madji manidog ki sagaamog nabekag, acitc ogi pidigecka8a8an ini kokocan. Kakina dac igi kokocag, 8aiej nijin kitci midasomidana8ebanig (2000), ki pakobig8ackoni8ag acitc ki nisaba8e8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","A8iagog dac ka kana8enima8adjin kokocan ki madjibato8ag kidji nda tibadjimo8adj odenakag acitc kitige8innikag adi ka iji8ebanig. Mane dac a8iagog ki pija8ag kidji 8abadamo8adj adi ka iji8ebanigiban. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ogi pi nazika8a8an Jesosan, acitc ogi 8abama8an ini naben kagi kigickagonipanin mane madji manidon. Aja taji abiban, ki 8a8epizoban acitc aja kitci pagakadiziban. Midac ki kitci segizi8ag igi8e a8iagog. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Igi8e dac ka 8abadamo8adj adi ka iji8ebanig ogi 8idama8a8an kodagian a8iagon adi ka iji8ebizindjin ini naben kagi pidigeckagonipanin madji manidon acitc adi ka iji8ebizindjin kakina ini kokocan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Midac igi a8iagog ogi kitci k8ag8edjima8an Jesosan kidji madjandjin iima odaki8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesos dac meg8adj e ani pozidj tcimanikag, aa nabe ka kigickagopanin mane madji manidon ogi pagoseniman Jesosan kidji gi paba 8idji8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesos dac ka8in ododji pagidinasi8an. Ogi inan dac: “Ki8en 8edi kimigi8amikag ka iji tajike8adj kakina ka tcina8emad8a, acitc 8idamaok adi kagi iji kitci mino todaok ka Tibendjigedj acitc adi kagi iji kitci kidimagenimik.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Aa dac nabe ki madja, acitc ki madjita kidji paba tibadjimodj iima akikag Midatcin Odenan ka ijinikadenig, kakina adi kagi iji kitci mino todagodjin Jesosan. Kakina dac a8iagog ka nodamo8adj ii ki kitci mamakadendamog. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesos mina8adj ki koki ajo8aam sagaigani tcimanikag. Apitc ka kabadj tcigagam, kitci mane a8iagog ki ma8adjiidi8ag 8ajagam 8inikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Pejig nabe ki pi tag8icin, Tceros (Jaïrus) e ijinikazodj, mi aa8e pejig e niganizipan Coda8inni aiamiemigi8amikag iima odenag. Apitc ka 8abamadjin Jesosan, ogi pi nibak8ita8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ogi kitci pagoseniman dac kidji 8idokagodjin, e ikidodj: “Nidanis aja kegat nibo. Kipagosenimin dac kidji pijaian, kidji pi nda saminadj, midac kada kige acitc kada koki mino pimadizi.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesos dac ogi 8idji8an. Kitci mane a8iagon onosoneogobanin acitc okitci sidjickagobanin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tegoban iima pejig ik8e, aja midatcin acitc nijopibon inigik o8anitonagoban omisk8i. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ki kitci kodagitogoban e nda 8abamadjin kitci mane mackiki8innin odakozi8in odji, acitc kakina oconiaman ogi tcaginabanin egi kijika8adjin ini mackiki8innin. Pekic dac ka8in ani mino pimadizisiban, tiegodj eckam na8adj ani akoziban. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ogi nodanaban Jesosan e mikomagani8indjin. Odakanag dac ogi pi odji nazika8an Jesosan ka iji kitci manenani8anig, acitc ogi taginan okonasini. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Inendamogoban mega: “Kicpin iaga taginam8ag Jesos okonas, mi ke iji kigeian.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Teci8ag dac ki kibitajiga8ini omisk8i acitc ogi kikendan aja egi kigedj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Teci8ag dac Jesos ogi kikendan omacka8izi8in egi kigeigondjin a8ian. Ki k8ekigaba8i a8iagokag acitc ki ikido: “A8enen ka taginag nikonasini?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Okikinoamaganan dac ogi nak8e8ajiigon: “Kitci mane a8iagog kikitci sidjickagonanag, misa8adj dac kidikidonan: ‘A8enen ka taginijidj?’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesos dac aiagineabigoban 8ajagam 8inikag, kidji gi 8abamadjin a8enen ka taginamindjin okonasini. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Midac aa ik8e ki kitci ninigickagoban epitci kitci segizigobanen, e kikendagiban adi ka iji8ebizipan. Ki pi nibak8i dac Jesosan ozidinikag acitc kakina kegoni ogi 8idama8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesos ogi inan ini ik8e8an: “Nidanis! Kiteb8etamo8in kigi kigeigon. Ki8en acitc min8endan, aja kigi kige ka inapineaban.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Meg8adj Jesos e taji aiamiapanin ini ik8e8an, ki pi odji tag8icinog nandam a8iagog Tcerosan omigi8aminikag e odose8adj acitc ogi ina8an Tcerosan: “Aja ki nibo kidanis. Ceck8at kiabadj kidji 8anasadjiadiban Jesos.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesos dac ka8in ododji pabiziskita8asi8an ini a8iagon ka tag8icinindjin acitc ogi inan ini Tcerosan: “Ka8in segiziken, mi eta teb8etaocin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ka8in a8iagon ododji pagidinasi8an kidji nosoneogodjin, mi eta Pien, Jak, acitc dac Jak ocimejan John. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Apitc dac ka tag8icino8agobanen 8edi Coda8inni ka niganizindjin omigi8aminikag, Jesos ogi 8abaman iima mane a8iagon e kitci mad8etondjin, e kitci ma8indjin, acitc e kitci pabibagademondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ki pidige dac migi8amikag acitc ogi inan: “Adi enakamigag ooma? 8egonen 8edji kitci mad8eto8eg acitc 8edji kitci ma8ieg? Ka8in nibosi aa ik8eses, motci niba eta.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kakina dac ogi maskita8a8an Jesosan. Jesos dac ogi sagidjinija8an ini a8iagon, acitc ogi madji8inan eta ini abinodjijan odadamini acitc odjodjomini, acitc ini nisin okikinoamaganan ka pi 8idjiogopanin. Ki pidige8ag dac pakesagakag adi ka iji pimicinipanin ini ik8esesan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ogi na8adjindjibinan ini ik8esesan acitc ogi inan: “Talita kom,” mi ekidomagag: “Ik8eses! 8anickan, kidinin!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Teci8ag ki 8anicka aa ik8eses acitc ki pabamose. Midatcin acitc nijopibon8ezigoban. Apitc dac ii ka 8abadamo8adj, ki kitci mamakadendamog. ");
INSERT INTO alqALGNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Midac Jesos 8e8enda ogi inan ega a8iagon kidji 8idama8andjin ii kagi todag. Acitc dac ogi inan: “Kegoni acamik.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesos ogi nagadan ii odenajicini, ki ijagoban dac 8edi Nazaret odenag, taji ka iji obigigobanen. Okikinoamaganan dac o8idji8agoban. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","E Coda8inni aiamie kijiganig, ki madjita e kikinoamagedj Coda8inni aiamiemigi8amikag. Igi mane a8iagog ka noda8a8agobanen Jesosan ki kitci mamakadendamog. Ikido8agoban: “Adi 8edinag ii kakina ka ikidodj? Adi 8edinag ii okagita8endamo8in acitc omamada kackito8in? ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kana mi 8aa mitigonabe? Kana 8in aa Mani og8izisan? 8in Jak (Jacques), Coses (Joses), Jod (Jude), acitc Simo o8idjiki8e8an, kana? Ocimejan ka ik8e8indjin kakina tajike8an ooma kina8itinakag, kana?” Onagabinigona8aban dac ii kidji teb8eta8a8adjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesos dac ogi inan: “Kitci manadjiagani8i ako niganadjimo8inni. Kagi iji obigidj dac odenani, acitc ka iji tcina8enimagani8idj, acitc omigi8amikag eta ka8in iji manadjiagani8isi,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ka8in dac Jesos ododji kackitosin kidji mamada8akamigizidj iima, mi eta nandam a8iagon ogi saminan kidji kigeadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesos dac okitci mamakadenimagoban ini a8iagon e kitci nodesendjin teb8etamo8ini. Mina8adj dac Jesos ki paba kikinoamage pepakan odenajican egi tag8anigin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ogi nd8e8eman ka midatcin acitc nijindjin okikinoamaganan acitc nenijin ogi madjinija8an kidji a8i paba kagik8endjin. Pepejig ogi minan macka8izi8ini kidji gi sagidjinija8andjin madji manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ogi inan dac: “Ka8in kegon madji8idokegon e pabamodeieg, mi eta sakaon. Ka8in madji8inakegon pak8ejigan, ka8in kek8an madji8idokegon mackimod, acitc ka8in kek8an conia. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Pisikamokon nibinakizinan. Ka8in nijin pabagi8anan madji8idokegonin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kiabadj dac ogi inan: “Apitc tag8icinieg pejig odenakag, tajikeok migi8am taji ke iji nd8e8emigo8eg, pinici kidji odjitciseg kidji odji madjaieg ii odenag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kicpin dac a8iagog pejig odenakag ka te8adj ega iji nda8enimigo8eg kek8an ega 8i ndotago8eg, mi iji madjaok acitc papa8izidecimonok e minigonaci8akizineieg. Midac kidji kikendamo8adj ega e min8endamia8adjin Kije Manidon,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jesos okikinoamaganan ki madja8an acitc ki kagik8e8an kidji an8endizonani8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kitci mane madji manidon osagidjinija8a8abanin acitc kitci mane a8iagon okigea8abanin, pagi pimideni e cijona8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ogima Herod ki nodagegoban Jesosan e mikomagani8indjin, kakina mega a8ian omin8adjimigobanin ako Jesos. Nandam dac ikido8agoban: “Mi aa Cabadis kagi abidjibag8en! Mi 8edji kackitodj kidji mamada8akamigizidj!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nandam kodagiag ikidobanig: “Mi aa8e niganadjimo8inni Eli.” Acitc kiabadj nandam kodagiag ikidobanig: “Niganadjimo8inni8i aa, maia tabickotc igi niganadjimo8innig ka pi pimadizi8adj 8eckadj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herod dac e nodamogobanen ii, ki ikido: “Ketcinadj mi aa Cabadis! Nigi anoki kidji kickig8ega8agani8idj, ki abidjiba dac!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Mi mega oo8e ka iji8ebag kidji nibodj Cabadis. Herod acitc Herodiad ki iji niba8i8agoban, misa8adj Herodiad egi iji niba8igobanen Pilipikag, Herod o8idjiki8en. Cabadis dac odinagoban Herodan: “Ka8in kidinendagozisi kidji makamadj kidjiki8e okokomiman, mi mega ekidomagagin inakonige8inan.” Herod dac ki anokigoban kidji na8adinimagani8indjin Cabadisan acitc kidji kiba8agani8indjin kibaodimigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodiad okitci madjenimagoban Cabadisan acitc onada8endanagoban kidji nisimagani8indjin. Ka8in dac okackitosinagoban, ega Herod e pagidini8egobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herod mega okosabanin Cabadisan, e kikenimagobanen e kitci k8aiak8adizinipanin acitc e paiekideenipanin. Onagadjiagoban dac. Ka8in ako ominotasinaban adi ekidonipanin e anim8endjin, pekic dac omin8enimabanin e ndota8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nigodin dac ki ijiseni kidji min8endag aa Herodiad. Apitc Herod ka tibickamogobanen, magocani ogi ojitonagoban. Ogi nd8e8eman kitci ogima anodaganan ka kacka8indjin, cimaganici kackan acitc kodagian a8iagon ka kitci apitendagozindjin Galilee akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodiad dac odanisan ki pidige8an iima kitci migi8amikag, acitc ki nda nimi8an. Herod acitc o8idji 8isinimaganan ogi kitci min8endamiigo8an ini ik8esesan e nimindjin. Ogima Herod dac ogi inan ini ik8esesan: “K8ag8edjimicin 8egonenigotc e nda8endaman, kiga minin dac. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Maiagotc niteb8e, kiga minin kakinagotc kegon ke k8ag8edjimiji8anen, 8a8adj abita nidogima8i8in,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Aa ik8eses ki sagaam acitc ogi k8ag8edjiman odjodjoman: “8egonen ke k8ag8ed8eiaban?” Ogi igon dac odjodjoman: “Cabadis octig8an!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Aa dac ik8eses ki koki pidigebato kitci migi8amikag acitc ogi inan ini ogiman: “Kinadodamaon kidji pidamaojian teci8ag Cabadis octig8an kitci nabaginaganikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herod dac ki kitci kackendamisegoban. Pekic dac ka8in onada8endasinaban kidji ana8eta8adjin. Kakina mega iima kagi nd8e8emagani8inigobanen ogi nodagon adi kagi inadjin ini ik8esesan ketcinadj kidji minadjin 8egonenigotc ke iji k8ag8edjimigog8en. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Teci8ag dac aa ogima ogi ijinija8an pejig cimaganican ka anokitagodjin, acitc ogi inan kidji pidondjin Cabadisan octig8ani. Aa dac cimaganic ki madja, ki ija kibaodimigi8amikag, acitc ogi kickig8ega8an Cabadisan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kitci nabaginaganikag dac ogi iji pidji8idon Cabadisan octig8ani, acitc ogi minan ini ik8esesan. Aa dac ik8eses ogi minan odjodjoman. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Apitc Cabadis okikinoamaganan ka nodagendjin egi kickig8ega8agani8idj, ogi pi nadji8idoni o8ia8 acitc ogi naatoni 8ibabikiniganikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesos Odanodaganan ki koki pi ki8e8an acitc ogi pi nazikagon, e 8idamagodjin kakina kagi inakamigizindjin acitc kakina kagi iji kikinoamagendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kitci manebanig a8iagog aiackodj e tag8icino8agobanen kidji pi ndota8a8adjin Jesosan acitc e koki madja8agobanen. Jesos dac acitc okikinoamaganan ka8in 8a8adj tebapitcisibanig kidji 8isini8adj. Jesos dac ogi 8idama8an: “Ijadan kina8it eta anodj 8edi adi ega eji tani8ag, kidji gi an8ecimono8eg pagi.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ki pozi8ag dac tcimani e madjio8adj, 8ina8a eta, ega ka iji tani8anig e ija8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kitci mane dac a8iagog ogi 8abama8an Jesosan acitc okikinoamaganan e madjandjin acitc ogi nisida8ina8a8an. Mane a8iagog pepakan odenag e 8aodji8adj 8ibadj ki ija8ag, e inaado8adj iima ka ijanipanin Jesosan acitc okikinoamaganan ab8amaci oditamindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Apitc Jesos ka kabadj tcimanikag, ogi 8abaman kitci mane a8iagon. Ogi kitci kidimageniman dac, e inenimagobanen mi maia mantcenican ejinagozindjin ega ka tendjin a8ian kidji kana8enimigo8adjin. Midac ki madjita kitci mane kegoni kidji kikinoama8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Apitc e ani onag8icinig, Jesos okikinoamaganan ogi pi nazikagon acitc ogi igon: “Ka8in tag8asinon kegon ooma, acitc aja kitci 8ikadi8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ijinijaok dac igi a8iagog kidji ija8adj kitige8inni8igi8amikag acitc odenajicikag pecodj ooma kidji nda odapinamadizo8adj midjimini.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesos dac ogi inan: “Kina8a tibina8e mijikog kidji 8isini8adj.” Midac ka ina8adjin Jesosan: “Kinada8endan na kidji nda odapinagid8a pak8ejiganag kidji gi acamagid8a igi a8iagog? Panima a8iag kidji mikimopan a8acamej nianeniokizis, mi inigik ke ijisepan conia kakina kidji acamagani8i8adj!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesos dac ogi inan: “Adi inigik pak8ejiganag e aia8eg8a? Nda kikendamok.” Apitc ka kikendamo8adj, ogi ina8an Jesosan: “Nanani8ag obiziganesag e aia8agid8a acitc niji8ag kigozag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesos ogi 8idama8an okikinoamaganan kidji abinija8andjin kakina a8iagon, pepagi kidji ok8abindjin motakamig. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Midac ki abi8ag kakina, nandam memidasomidana8ebanig acitc nandam nenanomidana8ebanig e ok8abi8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesos dac ogi odapinan ini ka nananindjin obiziganesan acitc ka nijindjin kigozan. Ki icpanabi 8ak8ig acitc mig8etc ogi inan Kije Manidon. Ogi papak8ebinan obiziganesan, acitc ogi minan okikinoamaganan kidji gi madinama8andjin kakina a8iagon. Ogi minan acitc ka nijindjin kigozan kidji madinama8andjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ki 8isini8an dac kakina acitc ki tebickono8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jesos dac okikinoamaganan ogi ma8adjia8an obiziganesan acitc kigozan kagi odji ickosendjin. Midatcin acitc nijin 8adabi8akik8an ki kicpone8an inigik ka ickosenig midjimini. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nanan kitci midasomidana (5000) taci8agoban nabeg kagi am8a8adjin ini obiziganesan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Teci8ag dac ka ick8a acamadjin a8iagon, Jesos ogi pozinija8an okikinoamaganan tcimanikag, 8ina8a nitam kidji gi ajo8aamindjin sagaigani, Betseda (Bethsaïda) odenag kidji ijandjin. 8in dac ki tajike iima e ki8enija8adjin ini mane a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ka ick8a ki8enija8adjin a8iagon, pik8adinajicikag ki 8agidamadji8e e nda aiamiedj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Apitc e ani tibikanig, Jesos okikinoamaganan tcimanikag tebanin nena8agam sagaiganikag, acitc Jesos 8in eta teban tcigagam. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ogi 8abaman okikinoamaganan e kitci mamida8endjigendjin e pimak8aji8endjin e odickaamindjin. Apitc e ani pidabanig, Jesos ogi nda nazika8an okikinoamaganan, 8agidjibig e iji pimosedj, acitc aja odani adimine8abanin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Apitc ka 8abamigodjin e pimosedj 8agidjibig, ki inendaminigoban tcibai ini ka 8abamandjin acitc ki kitci pabibagi8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kakina mega o8abamigobanin acitc ki kitci segizi8an. Teci8ag dac Jesos ogi aiamian: “Ka8in segizikegon! Nin Jesos! Ka8in nigod inendakegon!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ki pozi dac tcimanikag kidji 8idji8adjin, acitc mi ka iji ponino8enig. Okikinoamaganan dac ki kitci mamakadendamon. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ka8in mega maci ododji nisidotasina8aban Jesosan omacka8izi8ini, misa8adj egi 8abama8adjin e madina8endjin pak8ejiganan. Nagabinagani8i8agoban kidji gi nisidotamo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jesos acitc okikinoamaganan ki ick8a ajo8agame8agoban sagaigani. Ki kaba8ag Jenesaret akikag, acitc ogi midjimapidona8a otcimani8a. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Apitc ka ick8a kaba8adj tcimanikag, a8iagog iima ka tajike8apan ogi nisida8ina8a8an Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Igi dac a8iagog ki paba ija8ag mizi8e iima akikag, acitc Jesosan ogi iji8idama8a8an ka akozindjin otesinigani8akag, adi eji nodage8agobanen e tendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesos ki paba ijagoban odenajican, odenan, acitc kitige8inni odaki8an iima akikag. Adigotc dac e paba ijagobanen, ki iji8idama8agani8i ka akozindjin, e asagani8indjin ka iji ada8ani8anig. Okitci k8ag8edjima8agoban dac Jesosan kidji gi pagidinigo8adjin pagigotc eta kidji taginamo8adj 8ajagameig okonasini. Kakina dac ka taginamo8adj ki kige8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nandam Coda8innig ka nagadjito8agobanen inakonige8inan acitc nandam Coda8inni kikinoamage8innig, Jerusalem ka odji8adj, ki okogaba8i8ag 8ajagam Jesosikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ogi 8abama8an dac nandam Jesosan okikinoamagani ega e nosoneamindjin Coda8inni aiamie inakonige8ini, e taji 8isinindjin ega e paiekindjindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Coda8innig ka nagadjito8agobanen inakonige8inan, acitc kakina kodagiag Coda8innig, kitci 8e8enda onosoneana8aban ii kikinoamage8ini kagi minigo8apanin 8eckadj okitci anicinabemi8abanin. Ka8in dac 8ikad 8isinisi8agoban ega 8e8enda egi kizindji8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ka8in 8ikad 8isinisibanig e tag8icino8agobanen egi nda odapinige8adj, ega pinama egi kizisibandizo8adj. Kitci mane kodag kegoni otodana8aban 8eckadj ka todaminipanin okitci anicinabemi8abanin. Onosoneana8aban adi kagi iji kikinoamagani8i8apan kidji kizisibado8adjin onaganan, akik8an acitc pi8abikonaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Igi dac Coda8innig ka nagadjito8agobanen inakonige8inan acitc Coda8inni kikinoamage8innig ogi k8ag8edjima8an Jesosan: “8egonen 8edji ega nosoneamo8adj kikikinoamaganag ka iji kikinoamage8apan 8eckadj kikitci anicinabeminabanig, mi eji 8isini8adj ega e paiekindji8adj?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesos dac ogi nak8e8ajian: “Niganadjimo8inni Isaia kikitci teb8emigo8agoban e mikomigo8eg, kina8a ka kitci kimodizieg. Mazinadeni mega oo8eni omazinaiganikag: ‘Kije Manido ikido: Ogo8e a8iagog nimin8adjimigog odikido8ini8an e abadjito8adjin, anic dac nikitci na8abamigog odei8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kitci anica dac nidaiamitagog. Kikinoamage8ag mega ini inakonige8inan a8iagon kagi ojitondjin, mi maia tabickotc nin kagi ojita8agin ini inakonige8inan 8a in8eto8adjin,’ mi mezinadenig. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kigi 8ebinana8an dac Kije Manido odinakonige8inan, tiegodj dac kinosoneana8a 8eckadj ka todamo8apan kikitci anicinabeminabanig.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mina8adj dac ogi inan: “Kikitci kackitona8a kidji 8ebinamegon Kije Manido odinakonige8inan, kidji nosoneamegon dac kina8a tibina8e kikikinoamage8ini8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mois mega ki ikido: ‘Kiga manadjia8ag kidadami8a acitc kidjodjomi8a.’ Acitc dac mina8adj ki ikido: ‘Aa8e ke madji inadjimag8en odadaman kek8an odjodjoman inendagozi kidji nisagani8idj.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kina8a dac, pakan kidiji kikikinoamagem, e ikido8eg: ‘Kicpin pejig a8iag odadaman kek8an odjodjoman nodesendjin kegoni, okackiton kidji inadjin: Nida min8endan kidji mininan kegon kidji gi 8idjiinan. Sanagadakamig dac kidji gi todamaban, aja mega nigi nakomonan kidji minag Kije Manido.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kipagidina8a dac aa a8iag ega kegoni kidji todag kidji 8idjiadjin odadaman kek8an odjodjoman. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Midac iidi e todameg e 8ebinameg Kije Manido odikido8in, e kikinoamageieg kina8a tibina8e kikikinoamage8ini8a ka pi aianike odisigo8eg. Kodag acitc kitci mane anodj kegonan kitodana8an ii ka ijinag8agin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesos dac ogi koki nd8e8eman kakina a8iagon acitc ogi inan: “Ndotaocik, kina8a kakina, acitc k8ag8e nisidotamok oo8e. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ka8in kegoni ka pidigemaganig a8iag o8ia8ikag ogagi pataigosin. Tiegodj, odeikag ka odji sagidjisenig, mi ii8e ka pataigodj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kakina kina8a keckito8eg kidji nisidotameg, 8e8enda ndotamok.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Apitc Jesos ka naganadjin a8iagon, ki pidige migi8amikag ka iji tajikepan. Okikinoamaganan dac ogi k8ag8edjimigon adi e ikidomaganig ii adisokani. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesos dac ogi inan: “Kekina8a, kana kikackitosina8a kidji nisidotameg? Kana kinisidotasina8a ega kidji gi pataigodj a8iag adigotc inadjigedj? ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ka8in mega pidigemagasini odeikag, mi eta omisadakag pidigemagani, acitc kegapitc sagaamomagani o8ia8ikag.” E ikidodj dac ii, Jesos 8i ikidoban kakinagotc midjimini kidji gi midjigadenig. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kiabadj dac ki ikido: “8egonenigotc odeikag ke odji sagidjisenig, mi ke pataigodj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Pidigamig mega a8iagokag, odeikag odjimagani8an omadji midonendamo8inan, kidji madjakamigizidj, kidji kimodidj, kidji nici8edj, ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","madji aido8ini kidji pabamendag, kidji mosa8endag kodagian a8iagon odaimini, kidji madji aiaa8idj, kidji kagina8ickidj, kidji madji inadizidj, kidji odendag, kidji paba pag8anomi8edj, kidji kitci inendizodj, acitc kidji kikimadendagozidj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kakina ini madji kegonan a8iag odeikag odjimagani8an, acitc mi ii8eni ka pataigodjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Mina8adj dac Jesos ki odji madja iima, acitc ki ija 8edi akikag pecodj Tir (Tyr) odenag. Ki pidige pejig migi8amikag acitc ka8in a8iagon onada8enimasi8abanin kidji kikenimigodjin e tepan iima. Pekic dac ka8in ododji kackitosin kidji kazodj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Pejig ik8e ki nodageban e mikomagani8indjin Jesosan. Odanisiban aa ik8e, madji manidon dac okigickagobanin aa ik8eses. Teci8ag dac aa ik8e ogi pi nda 8abaman Jesosan acitc ogi nibak8ita8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ka8in Coda8innik8e8isiban aa ik8e, Pinicia (Phénicie) ki iji nta8igiban 8edi Siria (Syrie) akikag. Ogi pagoseniman dac Jesosan kidji sagidjinija8andjin madji manidon odanisikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesos dac ogi inan: “Pinama mijik abinodjijag kidji 8isini8adj pinici kidji tebickono8adj. Ka8in min8acisinon kidji makameg8a abinodjijag omidjimimi8a acitc dac kidji iji 8ebinama8eg8a animocag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Aa dac ik8e ogi nak8e8ajian: “Tebendjigean! Teb8e ii, anic dac 8a8adj animocag anamig 8isini8aganikag ka te8adj omamojagadana8a ka pabi8isenig midjimini e pinadjigendjin abinodjijan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesos dac ogi inan: “Kigi kitci mino nak8e8ajiijinan. Ki8en dac. Aja madji manido ki sagaam kidanisikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Aa ik8e ki ki8e omigi8amikag acitc 8edi ogi mika8an odabinodjijiman e pimakocinindjin nibe8inikag, madji manidon egi sagaamindjin 8inikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesos ogi nagadan ii akini pecodj Tir (Tyr) odenag, acitc Sidon odenakag ki ija. Mina8adj dac ki koki ija Galilee sagaiganikag, 8edi akini Midatcin Odenan ka ijinikadenig egi ani ijadj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Iima dac, pejig nabe ki pinagani8i Jesosikag. Ka8in ozitesiban acitc ka8in maia nta8esiban. Ki pagosenimagani8i dac Jesos kidji saminadjin ini naben kidji gi kigendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesos ogi madji8inan ini naben pagi 8asag a8iagokag. Ogi podjita8agenan, mina8adj dac ogi taginan odenanani ini naben, osiko8in e abadjitodj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ki icpanabi dac 8ak8ig, acitc ki azanamo e kidimagenimadjin ini naben, acitc ogi inan: “Eppata,” mi ekidomagag: “Oziten!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Teci8ag dac ki ozite aa nabe acitc odenanakag ki kige, acitc ogi kackiton 8e8enda kidji anim8edj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesos 8e8enda ogi inan ini8e a8iagon ega kidji paba tibadjimondjin. Midac na8adj egi odjiadjin ega kidji pabamadjimondjin, na8adj eckam ogi ani mikodanaban ii. ");
INSERT INTO alqALGNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","A8iagog dac ki kitci mamakadendamog acitc ikidobanig: “Kitci min8acini kakina kegoni ka todag. 8a8adj okackiton kidji oziteadjin ega ka ozitendjin acitc okackiton kidji anim8eadjin ega ka nta8endjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ii apitc, kitci mane a8iagog mina8adj ki ma8adjiidi8agoban acitc ka8in kegoni odaiasina8agoban kidji 8isini8adj. Jesos dac ogi nd8e8eman okikinoamaganan acitc ogi inan: ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nikidimagenimag igi8e a8iagog. Aja nisokajik ni8idjiogog acitc aja ka8in kegoni odaiasina8a kidji 8isini8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kicpin ki8enija8ag8a ega egi 8isini8adj, ozam kada kitci cagozi8ag kidji ki8e8adj, nandam mega 8asag odji8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Okikinoamaganan dac ogi nak8e8ajiigon: “Adi dac ke odinamak midjim kakina kidji gi acamaiakonig ooma pig8adakamigokag?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesos dac ogi k8ag8edjiman: “Adi inigik obiziganesag e aia8eg8a?” Ogi nak8e8ajiigon dac: “Nij8atci8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesos dac ogi inan kakina a8iagon kidji abindjin motakamig. Ogi odapinan dac ini ka nij8atcindjin obiziganesan, acitc mig8etc ogi inan Kije Manidon. Ogi papak8ebinan dac, acitc ogi minan okikinoamaganan kidji madinama8andjin a8iagon, midac ka todamindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Odaia8a8abanin acitc pagi kigozan. Mina8adj mig8etc ogi inan Kije Manidon acitc ogi inan okikinoamaganan kidji madina8endjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kakina a8iagog ki 8isini8ag acitc ki tebickono8ag. Jesos dac okikinoamaganan ogi ma8adjitona8a ka ickosenig midjimini, nij8atcin dac 8adabi8akik8an ki kicpone8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","8aiej ni8in kitci midasomidana (4000) tacibanig a8iagog kagi 8isini8adj. Midac Jesos ka iji ki8enija8adjin ini a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Teci8ag dac Jesos acitc okikinoamaganan ki pozi8ag tcimanikag acitc Damanota (Dalmanoutha) akikag ki ija8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nandam Coda8innig ka nagadjito8agobanen inakonige8inan ki tag8icino8agoban, acitc ogi aiamia8agoban Jesosan, e k8ag8edjima8adjin kegoni. O8i k8ag8e kadjinija8a8abanin kidji abadjitondjin omacka8izi8ini. Ogi k8ag8edjima8an dac kidji mamada8izindjin, kidji gi odji 8abadai8endjin teb8e Kije Manidokag epitci odjimaganig8en omacka8izi8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesos ki kitci azanamo acitc ki ikido: “8egonen a8iagog nogom ka te8adj 8edji k8ag8edjimiji8adj kidji mamada8izi8ag, kidji nda motci kikendamo8adj epitci teb8emaganig8en ii egi pidjinijaojindjin Kije Manidon? Teb8e ki8idamonom, ka8in niga mamada8izi8asin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Midac ogi naganan ini Coda8innin ka nagadjitonigobanen inakonige8inan. Ki koki pozi tcimanikag acitc ki ajo8aamogoban sagaigani, k8ekagam kidji ijadj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesos okikinoamaganan ki 8anikenigoban kidji madji8inandjin pak8ejiganan, acitc motci pejigobanin opak8ejiganimi8an otcimani8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesos dac 8e8enda ogi inan: “Iag8amig Coda8innig ka nagadjito8adjin inakonige8inan acitc Herod odobisidjigani8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ka8in dac ododji nisidotagosibanin okikinoamaganan adi 8a ikidopan. Ki k8ag8edjimidi8an dac: “Adi 8a ikidodj ii? Misa egi 8anike8aiak pak8ejiganan 8edji ikidodj ii.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesos dac ogi odji pabiziskita8an adi ekidondjin e aiamiidindjin. Ogi inan dac: “8egonen 8edji ikido8eg ega e aia8eg pak8ejigan? Kana maci kinisidotasina8a? Kana maci kikikendasina8a adi 8a ikido8an? Kicibictig8anem na? ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ockijigon kidaiana8an, kana ki8abi8agesim? Ota8agan kidaiana8an, kana kinodasina8a? Kana kimika8isim? ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Apitc kagi papak8ebinama8ag8aban igi8e ka nano kitci midasomidana8e8apan (5000) a8iagog ka nananipanin obiziganesan, adi inigik kagi kicponaieg8a 8adabi8akikog apitc ka ma8adjito8eg inigik ka ickoseg midjim?” “Midatcin acitc nijin,” ki ikido8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Mina8adj ki k8ag8ed8e Jesos: “Acitc dac apitc kagi papak8ebinama8ag8aban igi8e ka nio kitci midasomidana8e8apan (4000) a8iagog ka nij8atcinipanin obiziganesan, adi inigik kagi kicponaieg8a 8adabi8akikog apitc ka ma8adjito8eg inigik ka ickoseg midjim?” “Nij8atcin,” ki ikido8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Midac Jesos ogi inan: “Kana dac kiabadj kinisidotasina8a?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesos acitc okikinoamaganan ki tag8icinog Betseda (Bethsaïda) odenakag. Iima dac a8iagog ogi iji8ina8an pejig a8ian ega e 8abindjin Jesosikag acitc ogi k8ag8edjima8an Jesosan kidji saminandjin kidji gi kigendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesos dac ogi sagindjinan ini a8ian acitc ogi madji8inan ag8adjik odenajicikag. Ogi aton dac osiko8in ini naben ockijigokag. Ogi saminan acitc ogi k8ag8edjiman: “Kegon na ki8abadan?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Aa nabe ki pakada8abi acitc ki ikido: “A8iagog ni8abamag, anic mi maia mitigog ejinagozi8adj, pekic dac pabamose8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesos kiabadj ogi saminan ini naben ockijigokag. Mina8adj ki pakada8abi aa nabe. Aja dac ki kige acitc kakina kegoni ogi paieteabadan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Midac Jesos ogi ki8enija8an omigi8aminikag e inadjin: “Ka8in koki ijaken ii odenajicikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesos acitc okikinoamaganan ki ija8ag 8edi pepakan odenajicini pecodj odenani Sesani Pilip (Césarée Philippe) ka ijinikadenig. Meg8adj e taji pimode8adj, Jesos ogi k8ag8edjiman okikinoamaganan: “Adi ekido8adj a8iagog e mikomiji8adj?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ogi nak8e8ajiigon dac: “Nandam ikido8ag e Cabadisi8i8adj, kodagiag ikido8ag e Eli8i8adj, kodagiag kiabadj ikido8ag kin pejig 8eckadj niganadjimo8inni.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesos dac ogi k8ag8edjiman: “Kina8a dac, a8enen enenimijieg?” Pien dac ogi nak8e8ajian: “Kin aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin, 8in aa8e Christ ka ijinikanagani8idj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesos dac 8e8enda ogi 8idama8an ega kidji paba tibadjimondjin ii. ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Mina8adj dac Jesos ki madjita kidji kikinoama8adjin okikinoamaganan, e ikidodj: “Nin, Ka pi Anicinabe8iidizodj, panima niga kitci kodagito. Ka niganizi8adj Coda8innig, Coda8inni kitci aiamie ogimag acitc Coda8inni kikinoamage8innig niga ana8etagog. Niga nisigo, midac apitc ki ick8a nisogonaganig niga abidjiba8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kitci 8e8enda ogi 8idama8an kidji gi nisidotamindjin. Pien dac pagi pakan ogi iji8inan Jesosan, 8in eta kidji aiamiadjin, acitc ogi kaganonan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesos dac ki k8ekigaba8i, ogi kana8abaman okikinoamaganan acitc ogi kitci kaganonan Pienan e inadjin: “A8as 8edi ijan, kitci madji manido! Ka8in Kije Manido ka inendag kidinendasin, tiegodj tabickotc a8iagog ka inendamo8adj kidinendan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Midac Jesos ogi nd8e8eman okikinoamaganan acitc ini kitci mane a8iagon ka tenipanin iima, acitc ogi inan: “Kicpin a8iag 8i 8idjiojidj, panima ki poni mik8enimidizodj, panima ki pimi8inadjin otcibaiatigoman, acitc panima ki nosoneojidj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Aa8e mega ka kitci manadjitodj opimadizi8in kada nibo, aa8e dac pekic ke nibog8en nin odji acitc min8adjimo8ini odji, oga pimadjiton opimadizi8in. ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Adi dac inasag a8iag kakina kegonan ka kitci min8acinigin tibendagibanin ooma akikag, kicpin 8anitodj opimadizi8in? ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tag8anidok na kegoni kegi meckodonag kidji gi koki aiag opimadizi8in? ");
INSERT INTO alqALGNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","A8iagog nogom ka te8adj odana8enima8an Kije Manidon acitc pijicig nta patadi8ag. Kicpin pejig e taci8adj agadenimijidj acitc agadendagin nidikido8inan, mi aa8e kenin, Ka pi Anicinabe8iidizodj, ke agadenimag, apitc pi tag8icinian Nidadam odicpendagozi8inikag, e pi 8idji8ag8a kitcit8a ajenig.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesos kiabadj ogi inan: “Teb8e ki8idamonom, nandam a8iagog ooma ka te8adj ka8in kada nibosi8ag ab8amaci 8abadamo8adj Kije Manidon Odogima8i8ini ke pijamaganig ka kitci macka8izimaganig.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ka ick8a nigod8asogonaganig, Jesos ogi madji8inan Pienan, Jakan, acitc Johnan. Ogi iji8inan dac ka iji kitci icpadinanig pik8adinani, 8ina8a eta kidji te8adj. Meg8adj dac e kana8abamigodjin, ki ani kitci pakanabaminagozi Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Okonas maia ki tcakigideni ka apitci 8abiginag8anig, ka8in a8iag akikag oda kackitosin na8adj kidji gi 8abinag8atodj kegojicini. ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Igi dac nisin kikinoamaganag ogi 8abama8an Elin acitc Moisan, e taji aiamiandjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pien dac ogi inan Jesosan: “Kikinoamage8inni! Kitci min8acin egi pijaiak ooma. Niga padakisidonananan nisin nibaganan, pejig kin odji, pejig Mois odji, acitc pejig Eli odji.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","K8ina8i ikidogoban Pien epitci kotadjipan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","8ak8ini ki pi nag8ani acitc ogi nigockagona8a. Ogi noda8a8an dac a8ian iima 8ak8ikag e odji mad8e anim8endjin e ikidondjin: “Mi aa Nig8izis ka kitci sagiag. Ndotaok dac!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Teci8ag dac, Pien, Jak, acitc John ki 8ajagameabi8ag 8ina8akag, ka8in dac aja o8abamasi8a8abanin kodag a8ian kidji tendjin iima, mi eta Jesosan o8idjiogo8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Meg8adj e ani nisamadji8e8adj pik8adinakag, Jesos 8e8enda ogi inan ega kidji pabamadjimondjin adi ka iji 8abadamindjin, pinici kidji abidjibadj Ka pi Anicinabe8iidizodj nibo8inikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ogi todana8a dac ka ikidondjin, pekic e taji inendamo8adj adi 8a ikidomaganig ii: “Pinici kidji abidjibadj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ogi k8ag8edjima8an dac Jesosan: “Coda8inni kikinoamage8innig ikido8ag: ‘Eli pinama kada pi koki tag8icin ab8amaci tag8icig aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin.’ 8egonen dac 8edji ikido8adj ii?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesos ogi nak8e8ajian: “Teb8e Eli nitam kada pi koki tag8icin, kidji pi nda 8a8ejibidodjin kakina kegonan. Pekic dac 8egonen 8edji mazinadenig Kije Manido Omazinaiganikag, Ka pi Anicinabe8iidizodj panima kidji kitci kodagitodj acitc kidji manenimagani8idj? ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Anic dac, ki8idamonom oo8e, Eli aja ki pi koki tag8icin, acitc a8iagog adigotc 8a toda8a8adjin ogi toda8a8an, maia tabickotc ka inazinadenig Kije Manido Omazinaiganikag 8in e mikomagani8idj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Apitc Jesos acitc nisin okikinoamaganan ka odisa8adjin kodagian okikinoamaganan, ogi 8abama8an mane a8iagon 8ajagam 8ina8akag. Nandam Coda8inni kikinoamage8innin otajimigo8abanin igi kikinoamaganag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Apitc kakina igi8e a8iagog ka 8abama8adjin Jesosan, ki kitci mamakadendamog acitc ki ipato8ag Jesosikag kidji anamika8a8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesos dac ogi k8ag8edjiman okikinoamaganan: “8egonen 8edji tajimidieg?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Pejig nabe iima ka tepan ogi nak8e8ajian: “Kikinoamage8inni! Kipidamaon nig8izis. Okigickagon madji manidon, ega e pagidinigodjin kidji anim8edj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Apitcigotc pidigeckagodjin, oka8ebinigon motakamig, acitc kitci pite8idone, kitci mamad8eabidecin acitc kitci tcida8akose. Nigi pagosenimag kikikinoamaganag kidji sagidjinija8a8adjin ini madji manidon, ka8in dac ododji kackitosina8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesos dac ogi inan: “8esada ako kina8a nogom ka pimadizieg, ega ka teb8etameg! Anigik kiabadj ke 8idji tajikeminagok? Anigik panima ke tanendamiijieg? Pidji8idamaocik aa ockina8es ooma.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Midac ki pidama8agani8i ini ockina8esan. Apitc aa madji manido ka 8abamadjin Jesosan, ogi kitci mimigobinan ini ockina8esan. Ki pagicin dac aa abinodjij acitc ki kitci sinigocimono motakamig acitc ki kitci ani pite8idone. ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesos dac ogi k8ag8edjiman ini ockina8esan odadamini: “Anapitc ka odji madji ijinagozidj?” Ogi nak8e8ajiigon dac: “Eko abinodjiji8idj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Acitc dac aa madji manido mojag ogi toda8an kidji madjoctesendjin nig8izisan kek8an kidji pakobisendjin, e k8ag8e nisadjin. Kicpin dac kin kegon kackito8an kidji todaman, kipagosenimin kidji kidimagenimijiag acitc kidji 8idokaojiag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesos ogi inan: “ ‘Kicpin kackito8an’ kidikidonan. Aa8e ka teb8etaojidj, kakinagotc kegoni oga kackiton.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Teci8ag dac aa ockina8es odadaman ki madji pabibagi8an e ikidondjin: “Kiteb8etaon! 8idokaocin enigok kidji ani teb8etaman!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesos ogi 8abaman kitci mane a8iagon e pi ma8inanigodjin. Midac ogi kitci kanonan ini madji manidon acitc ogi inan: “Kin madji manido, ega ka pagidinadj kidji anim8edj acitc kidji ozitedj aa ockina8es! Sagaan 8inikag, kidinin, acitc ka8in 8ikad mina8adj koki pidigeken 8inikag!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Aa madji manido ki pabibagi, ogi kitci mimigobinan ini ockina8esan, midac ka iji sagaag. Aa abinodjij mi maia kagi nibodj ka ijinagozidj, nandam dac a8iagog ikido8agoban: “Ki nibo.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesos dac ogi na8adjindjibinan acitc ogi pazig8idjibinan ini abinodjijan, acitc ki tajigaba8i8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Apitc dac Jesos acitc okikinoamaganan ka pidige8adj migi8amikag, 8ina8a eta meg8adj e te8agobanen, ogi k8ag8edjimigon: “8egonen dac 8edji ki p8a8inija8agidj kidji sagidjinija8agidj aa madji manido?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesos dac ogi inan: “Mi eta aiamie8in kadagi abadan kidji gi sagidjinija8agani8idj aa ka inakanezidj madji manido.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesos acitc okikinoamaganan ki odji madja8ag iima acitc ki ani cabocta8ecka8ag Galilee akini. Jesos dac ka8in onada8endasinaban kidji kikenimagani8idj adi e tepan, ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","e 8i kikinoama8adjin okikinoamaganan. Ogi inagoban dac: “Nin, Ka pi Anicinabe8iidizodj, niga 8agackibinigo, kidji gi tibenimiji8adj a8iagog ooma akig. Niga nisigog, anic dac apitc ki ick8a nisogonaganig niga abidjiba8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ka8in dac onisidotasina8aban kikinoamaganag adi 8a ikidonipanin, acitc kocimobanig kidji k8ag8edjima8adjin 8egonen 8edji ikidonipanin ii. ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jesos acitc okikinoamaganan ki tag8icinog Kaponaom (Capernaüm) odenakag. Apitc Jesos ka pidigedj migi8amikag, ogi k8ag8edjiman okikinoamaganan: “8egonen ka mikodameg meg8adj ka pidaado8ak?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ka8in dac odji kidosi8ag. Meg8adj mega e pidaado8adj, ki kitci kaganondi8ag e nanada kikendamo8adj a8eneni8an ma8adji ketci apitendagozindjin 8ina8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesos dac ki abi, ogi nd8e8eman ka midatcin acitc nijindjin okikinoamaganan acitc ogi inan: “Kicpin a8iag kitci 8i niganizidj, panima 8in ick8eag ki tedj acitc panima kakina a8ian ki anokita8adjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Midac ogi odapinan abinodjijesan acitc ogi asan nigan 8ina8akag, ogi sagian acitc ogi inan okikinoamaganan: ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Aa8e ka mino toda8adjin pejigigotc abinodjijan nin odji, kenin nimino todag. Acitc aa8e mino todaojidj, ka8in nin eta nimino todagosi, omino toda8an ke8in ini8e kagi pidjinijaojindjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John ogi inan Jesosan: “Kikinoamage8inni! Nigi 8abamanan pejig nabe ega e nosoneogo8ak e sagidjinija8adjin madji manidon ki8izoni e abadjitodj. Nigi k8ag8e odjianan dac.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesos dac ogi nak8e8ajian: “Ka8in odjiakegon. Ka8in mega a8iag okackitosin kidji mamada8izidj ni8izoni e abadjitodj, acitc dac teci8ag ick8a mamada8izidj kidji madji mikomijidj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","A8enenigotc ega ke nagabidog8en kimikimo8inani, ki8idji mikimomigonan sa. ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Teb8e ki8idamonom, a8enenigotc ke minigo8eg8en pejigonagan anisibini, osa ninikag eji tibendagozieg, nin Kije Manido ka pidjinijaojidj, ketcinadj kada ca8enimagani8i.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“A8enenigotc dac ke 8ik8adjiag8enin kidji patadindjin pejig ini ega ka apitendagozindjin ka teb8etaojindjin, na8adj kada minoseni kidji acodapinagani8indjin kitci asinin og8ei8akag aa a8iag, acitc kidji pakobi8ebinagani8idj kitcigamikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kicpin kinidji pataigo8an, kickijan. Na8adj kiga minose kagige pimadizi8in kidji odisigo8an e motci pejigondjian, apitc8in kidji aiamanin midjinijin kinidjin, kidji iji8ebinigo8an dac kitci ickodekag ega 8ikad ka ata8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Iima dac, ‘mandjocesag ka am8a8adjin a8iagon ka8in 8ikad nibosi8ag, acitc ka8in 8ikad ata8esinon ii kitci ickode.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kicpin kizid pataigo8an, kickizidejodizon. Na8adj kiga minose kagige pimadizi8in kidji odisigo8an e motci pejigozidean, apitc8in kidji aiamanin midjinijin kizidan, kidji iji8ebinigo8an dac kitci ickodekag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Iima dac, ‘mandjocesag ka am8a8adjin a8iagon ka8in 8ikad nibosi8ag, acitc ka8in 8ikad ata8esinon ii kitci ickode.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Acitc dac kicpin kickijig pataigo8an, manibidon. Na8adj kiga minose kidji pidigean Kije Manido Odogima8i8inikag e motci nabanedjabian, apitc8in kidji aiamanin midjinijin kickijigon, kitci ickodekag dac kidji iji8ebinigo8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Iima dac, ‘mandjocesag ka am8a8adjin a8iagon ka8in 8ikad nibosi8ag, acitc ka8in 8ikad ata8esinon ii kitci ickode.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Kije Manido oga abadjiton animizi8ini kakina a8ian kidji ani minodeendjin, tabickotc ci8itagan ka abadjitcigadeg kidji minopog8ag midjim. ");
INSERT INTO alqALGNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kitci mino abadan ako ci8itagan. Anic dac, kicpin ani ijiseg ci8itagan ega kidji ci8itaganipog8ag, adi dac kegi todjigadegiban kidji koki ci8itaganipog8ag? Kina8a dac, k8ag8e mino 8idjiidiok kakina pepejig e tacieg, acitc k8ag8e mino 8idji tajikemidiok pekadendamo8inikag, maia tabickotc ci8itagan kidji ijinagozieg adi eji pimadizieg.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesos ki madja acitc ki ija Coda (Judée) akikag, acitc dac 8edi k8ekagam Jourdain sibini. Mina8adj dac, kitci mane a8iagon ogi pi nazikagon acitc ogi kikinoama8an, kabe ako ka todagiban. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nandam Coda8innig ka nagadjito8agobanen inakonige8inan ogi pi nazika8a8an Jesosan, kidji k8ag8e katcidina8adjin anodj kidji iji nak8e8ajii8endjin. Ogi k8ag8edjima8an dac: “Pagidini8emaganon na kidinakonige8inanan pejig nabe kidji 8ebinadjin okokomiman?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesos dac ogi nak8e8ajian: “Adi Mois ka ikidodj kidji todameg?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ki ikido8ag dac: “Mois ogi pagidinan naben kidji ojitondjin ojibiigani e tibadjimomaganig teb8e egi 8ebinadjin ini okokomiman, kidji gi odji 8ebinadjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesos dac ogi nak8e8ajian: “Mois ogi ojibian oo inakonige8ini kina8a odji, osa mega kikitci cibictig8anem. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Anic dac apitc ka kijendagin kakina kegonan, ‘Kije Manido ogi kijeniman naben acitc ik8e8an,’ mi ii ka mazinadenig. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Ii dac odji, nabe oga naganan odadaman acitc odjodjoman, kidji 8idji8adjin okokomiman, ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","acitc kada pejig8eiendagozi8ag e iji niji8adj.’ Midac ii odji, ka8in aja nij8eiegimagani8isi8ag, mi eta motci pejig8eiendagozi8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ka8in dac a8iag oda nicikebidosin Kije Manidon kagi mama8atondjin,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Apitc ka koki pidige8adj migi8ami8akag ka iji tajike8adj, Jesos okikinoamaganan ogi k8ag8edjimigon adi ekidomaganig ii. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesos dac ogi inan: “Kicpin pejig nabe 8ebinadjin okokomiman, kodagian dac ik8e8an iji niba8idj, madji aido8ini opabamendan, e madji toda8adjin nitam okokomiman. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Acitc dac kicpin pejig ik8e 8ebinadjin ocomisiman, kodagian dac naben iji niba8idj, madji aido8ini opabamendan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nandam a8iagog ogi iji8ina8an abinodjijesan Jesosikag, kidji gi aiamit8anandjin e saminandjin. Kikinoamaganag dac ogi kaganona8an ini a8iagon ka pidji8inandjin ini abinodjijan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Apitc Jesos ka 8abadag ii, ki kiji8azi acitc ogi inan okikinoamaganan: “Pagidinikog abinodjijag kidji pi nazikaoji8adj! Ka8in odjiakegonig. A8iagog mega tabickotc abinodjijag ka apitendagozi8adj, Kije Manidon Odogima8i8inikag kada iji tibendagozi8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Teb8e ki8idamonom, a8iag ega nda8endag Kije Manidon Odogima8i8ini, tabickotc abinodjij ke iji nda8endagiban, ka8in 8ikad oga kackitosin kidji pidigedj Kije Manidon Odogima8i8inikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jesos dac ogi sagian ini abinodjijan, pepejig ogi saminan acitc ogi aiamit8anan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Apitc Jesos ka 8i madjadj, pejig nabe ki pidjibato, ogi nibak8ita8an Jesosan, acitc ogi k8ag8edjiman: “Kikinoamage8inni! Kin e kije8adizian! Adi ke todamaban kidji odisigo8an kagige pimadizi8in?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesos ogi inan: “8egonen 8edji inijian e kije8adizian? Kije Manido eta kije8adizi. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kikikendanan Kije Manido odinakonige8inan: ‘Ka8in kiga nici8esim. Ka8in madji aido8in kiga pamendasina8a. Ka8in kiga kimodisim. Ka8in anodjigotc kiga iji inactaonasi8a8a kidjipimadizimi8a. Ka8in kiga kimodizisim. Kiga manadjia8ag kidadami8a acitc kidjodjomi8a.’ Mi ka inakonigedj Kije Manido.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Aa dac nabe ka 8anadizidj ogi inan: “Kikinoamage8inni! Kakina nigi nosoneanan ini inakonige8inan ka ako abinodjiji8ian.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesos ogi kijigabaman e sagiadjin, acitc ogi inan: “Pejig kegon kinodese. A8i ada8en kakina kidaiman, acitc ca8enimik ka kidimagizi8adj kiconiaman, midac kidji aiamanin 8anadizi8inan 8ak8ig. Pijan dac acitc nosoneocin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Apitc dac aa nabe ka nodag ii, ki pagisig8ese, acitc ki madja e kitci kackendamisedj. Kitci 8anadizigoban mega. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesos ogi kana8abaman okikinoamaganan 8ajagam 8inikag acitc ogi inan: “8esa kitci sanagizi8ag ka 8anadizi8adj kidji gi pidige8adj Kije Manidon Odogima8i8inikag!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Okikinoamaganan ogi kitci mamakazitagon ii8e ka ikidodj Jesos. Midac kiabadj ogi inan: “Nidabinodjijimag! Kitci sanagan kidji gi pidigenani8ag Kije Manidon Odogima8i8inikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kitci sanagizi ka nijo pik8aoganedj a8esiz kidji gi cabocta8eckapan cabonigani ka iji pagoneanig, anic dac na8adj kiabadj sanagizi a8iag ka 8anadizidj kidji gi pidigedj Kije Manidon Odogima8i8inikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Okikinoamaganan kiabadj na8adj ogi kitci mamakazitagon ii8e ka ikidodj Jesos. Ki k8ag8edjimidi8ag dac: “A8enen dac kegi ag8acimagani8idj?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesos ogi kana8abaman okikinoamaganan, acitc ogi inan: “Ka8in a8iagigotc kadagi ag8acimidizosi, Kije Manido dac 8in okackiton kidji ag8acimi8edj. 8in mega kakina kegoni okackiton.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pien dac ogi inan: “Nina8it, kakina kegon nigi nagadananan acitc kigi nosoneogo.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesos dac ogi nak8e8ajian: “Teb8e ki8idamonom, kicpin a8iag nagadag omigi8am acitc okitigan akin, kek8an naganadjin o8idjiki8en, odjodjoman, odadaman, acitc odabinodjijiman, nin odji acitc min8adjimo8ini odji, ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","oga odisigon midasomidana a8acamej ini kegonan. Ooma ka iji pimadiziak nogom oga aian na8adj mane migi8aman acitc kitigan akin, acitc na8adj kada mane8an o8idjiki8en, odjodjoman, acitc odabinodjijiman. Pekic dac acitc kada nanekadjiagani8i. Nage dac acitc oga aian kagige pimadizi8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mane dac a8iagog nogom ma8adji ka kitci apitendagozi8adj, ma8adji kada kitci tabasendagozi8ag ii apitc, acitc mane a8iagog nogom ma8adji ka kitci tabasendagozi8adj, ma8adji kada kitci apitendagozi8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesos acitc okikinoamaganan pimi ijabanig 8edi Jerusalem odenag. Jesos niganiban e pimose8adj. Kikinoamaganag kitci mamakadendamobanig, acitc a8iagon ka nosoneogo8adjin kotadjibanin. Jesos mina8adj ogi madji8inan okikinoamaganan, 8ina8a eta kidji gi aiamiadjin, acitc ogi 8idama8an adi ke iji8ebizidj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ogi inan dac: “Ndotamok! Jerusalem kidijamin. Iima dac, nin, Ka pi Anicinabe8iidizodj, niga takonigo, acitc niga tibenimigog Coda8inni kitci aiamie ogimag acitc Coda8inni kikinoamage8innig. Niga ick8aienimigog dac acitc niga iji8inigog ega ka Coda8inni8indjin kidji tibenimijindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Igi8e dac niga manenimigog, niga sasik8anigog, niga papajacteogog, acitc niga nisigog. Midac apitc ki ick8a nisogonaganig, niga abidjiba8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kegapitc dac Jak (Jacques) acitc John, Zebedee og8izisan, ogi pi nda nazika8a8an Jesosan. Ogi ina8an dac: “Kikinoamage8inni! Kinada8enimigo kidji todaojiag adi ke iji k8ag8edjimigo8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesos dac ogi k8ag8edjiman: “8egonen neda8endameg kidji todaonagok?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ogi nak8e8ajiigon dac: “Apitc ke ogima8ian Kidogima8i8inikag ka kitci icpendag8ag, pagidinicinam kidji kitci apitendagoziag, kidji abiag dac opimena kinikag, pejig kikitcinikikag, acitc pejig kinamadinikikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesos dac ogi inan: “Ka8in kikikendasina8a 8egonen e k8ag8edjimijieg. Kikackitona8a na kidji kodagito8eg adi nin ke iji kodagito8an? Kikackitona8a na kidji sigaadazo8eg adi nin ke iji sigaadazo8an?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ogi nak8e8ajia8an dac: “Ee, nikackitonanan.” Jesos dac ogi inan: “Teb8e kiga kodagitom adi ke iji kodagito8an, acitc kiga sigaadazom adi ke iji sigaadazo8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Anic dac, ka8in nin ke onaco8anag a8enen ke pi abidj nikitcinikikag kek8an ninamadinikikag. Kije Manido aja ogi onendan a8eneni8an ke abindjin iima,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Apitc kodagiag ka midatci8adj kikinoamaganag ka nodamo8adj ii, ogi kitci kiji8aigo8an Jakan acitc Johnan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesos dac ogi nd8e8eman kakina okikinoamaganan acitc ogi inan: “Kikikenima8ag igi8e nogom ka ogima8endagozi8adj ooma akikag kitci kacka8enimidizo8ag, acitc igi8e ka kitci apitendagozi8adj okitci 8i abadjitona8a omacka8izi8ini8a. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ka8in dac kina8a kida todasina8a iidi. Tiegodj, kicpin pejig aa8e e tacieg 8i kitci apitendagozidj, panima ki anokitago8eg, ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","acitc kicpin pejig aa8e e tacieg 8i kitci niganizidj, panima ki tabasenimidizodj, tabickotc anokitage8inni ka tibenimigodjin kakina a8ian kidji inenimidizodj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","8a8adj nin, Ka pi Anicinabe8iidizodj, ka8in nidodji pijasi kidji anokitago8an. Nigi pija dac kidji anokitageian, acitc kidji migi8eian nipimadizi8in kidji gi odji ag8acimag8a mane a8iagog,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesos acitc okikinoamaganan ki tag8icinog Jeriko (Jéricho) odenag. Apitc ka ani sagaamo8adj iima odenag, kitci mane a8iagon onosoneogo8an. Pejig nabe ega ka 8abidj, Batime (Bartimée) ka ijinikazogobanen, Time (Timée) og8izisan, taji abigoban opimekana e pagosenimodj conian. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Apitc ka nodagedj Jesosan, Nazaret ka odjindjin, e tenipanin iima, ki madji pabibagi: “Jesos! Ogima David odanike ojisan! Kidimagenimicin!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mane a8iagon ogi kaganonigon acitc ogi igon kidji ponimodj. Na8adj dac kiabadj ki kiji8egoban e pabibagidj: “Ogima David odanike ojisan! Kidimagenimicin!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesos ki kibitcigaba8i, acitc ki ikido: “Nd8e8emik.” Ki nd8e8emagani8i dac aa nabe acitc ki inagani8i: “Pazig8in, ka8in ana8endjigeken, pijan kidigo!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Aa nabe ogi kitcikonan opizika8agan, ki pazig8i, acitc ogi nda nazika8an Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesos ogi k8ag8edjiman: “8egonen eji nda8endaman kidji todaonan?” Aa nabe ega ka 8abidj ogi nak8e8ajian: “Kikinoamage8inni! Kipagosenimin kidji kigeijian kidji gi koki 8abian.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesos dac ogi inan: “Mi iji madjan, kiteb8etamo8in kigi kigeigon.” Teci8ag dac ogi kackitonagoban kidji 8abidj, acitc ogi nosone8an Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Apitc Jesos acitc okikinoamaganan e ani pec8abadamo8adj Jerusalem odenani, pecodj Betapaje (Bethphagé) acitc Betani (Béthanie) odenajicikag, ki tag8icinog Olip (Oliviers) pik8adinajicini ka ijinikadenig. Iima dac, Jesos ogi niganinija8an nijin okikinoamaganan, ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","acitc ogi inan: “A8i ijaok 8edi odenajicikag nigan ka tag8ag. Apitc oditameg, kiga mika8a8a pejig misabozoc e sagapizodj, ega maci a8iag egi iji 8agidabi8agedj. Pagidabaok acitc pidji8ijik ooma. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kicpin dac a8iag k8ag8edjimigo8eg: ‘Adi 8edji todameg ii?’ 8idamaok: ‘Ka Tibendjigedj onada8eniman, acitc teci8ag ick8a abadjiadjin oga koki pinan.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ki madja8ag dac acitc ogi mika8a8an pejig misabozon opimekana, e sagapizondjin pecodj pejig ick8ademikag. Ogi pakaba8a8an dac. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nandam a8iagog iima ka te8apan ki k8ag8ed8e8ag: “Adi enakamigizieg? Adi 8edji pakaba8eg aa misaboz?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ogi ina8an dac Jesosan ka igo8apanin kidji ikido8adj. Midac ini a8iagon ka iji pagidinigo8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ogi iji8idama8a8an dac Jesosan ini misabozocan. Ogi pakidjisidona8an dac opizika8agani8an 8agidj misabozocikag, acitc Jesos ki 8agida8aganebi. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mane a8iagog ogi taj8egisidona8an opizika8agani8an mikanakag taji Jesosan ke ani ijandjin. Kodagiag dac a8iagog ogi atona8an iima mikanakag 8adik8anan kagi nda ndogaamo8adjin anodjigotc ka iji cibeckodenig. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","A8iagog ka pimose8apan nigan Jesosikag, acitc ke8ina8a igi8e ka nosone8a8agobanen, kitci pabibagi8agoban: “Kitcit8a8endagozi Kije Manido! Ca8endagozi aa8e ka Tibendjigendjin kagi pidjinijaogodjin! ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ca8endag8an ii ogima8i8in ka pijamagag, David 8eckadj kikitci anicinabeminaban odogima8i8in. Kitcit8a8endagozi Kije Manido icpimig ka tedj!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesos ki pidige Jerusalem odenani acitc ki ija iima Coda8inni kitci aiamiemigi8amikag. Aja 8ikadi8anoban. Midac apitc ka ick8a aiagineabidj, ki sagaam, acitc ki ija Betani (Béthanie) odenakag, kigi ka midatcin acitc nijindjin okikinoamaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","8iabanig, apitc ka nagadamo8adj Betani (Béthanie), Jesos ki kitci mamida8askadegoban. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ogi 8abaman 8edi 8asag pejig minatigon e padakicinindjin, e kitci nibicibago8inigobanen. Jesos dac ki ija pecodj iima mitigokag, e inabidj epitci mini8indjin. Apitc dac pec8abamadjin ini mitigon, nibicibagon eta o8abadanabanin, ka8in mega maci odjitcisesinigoban kidji mini8indjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesos dac ogi inan ini mitigon: “Ka8in 8ikad mina8adj a8iag oga midjisinan kiminiman!” Jesos dac okikinoamaganan ogi nodagon. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ki tag8icinog Jerusalem odenakag. Jesos ki pidige Coda8inni kitci aiamiemigi8amikag acitc ki madjita kidji sagidjinija8adjin kakina a8ian ka ada8endjin acitc ka kicpinadjigendjin iima. Ogi k8anabi8ebinanan o8isini8agani8an ini8e ka meckodonandjin conian acitc otesabi8agani8an ini8e ka ada8endjin omimin ka 8abizindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ka8in a8ian ododji pagidinasi8an kegoni kidji pimi8idondjin pidigamig Coda8inni kitci aiamiemigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ogi kikinoama8an dac e ikidodj: “Mazinadeni Kije Manido Omazinaiganikag: ‘Kidji iji aiamie8adj kakina a8iagog kada inabadan nimigi8am.’ Kina8a dac, kimodi8innimigi8am kigi inabadjitona8a,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Coda8inni kitci aiamie ogimag acitc Coda8inni kikinoamage8innig ki nodage8ag adi Jesosan ka inakamigizindjin kitci aiamiemigi8amikag, acitc onanada kikendana8aban adi ke todamo8apan kidji gi nisa8apanin Jesosan. Pekic dac okosa8abanin, kakina mega a8iagog ogi kitci mamakazita8a8agoban Jesosan adi eji kikinoamagendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Apitc e ani onag8icinig, Jesos acitc okikinoamaganan ogi nagadana8a Jerusalemini. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","8ibadj e kijeba8acinig, meg8adj Jesos acitc okikinoamaganan e pimose8agobanen mikanakag, ogi 8abama8an ini minatigon ka 8abama8apanin onago. Midac aa minatig kitci pasogoban, 8a8adj o8adabimikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pien ki mika8i adi ka iji8ebanig acitc ogi inan Jesosan: “Kikinoamage8inni! Kana8abam! Aa minatig ka ana8enimadiban kitci paso.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesos dac ogi inan okikinoamaganan: “Teb8etaok Kije Manido! ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Teb8e ki8idamonom, kicpin a8iag ketcinamendag odeikag acitc teb8etag kidji ijisenig adi ka ikidodj, oda kackiton kidji idag ii pik8adinani: ‘Ta8ickan iima acitc pakobi8ebinidizon kitcigamikag,’ midac iidi ke ijisenig. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mi 8edji 8idamonagok, apitc aiamieieg e pagosendameg kegon, teb8etamok aja egi odisigo8eg, kiga odisigona8a dac. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Acitc dac apitc pazig8ieg kidji aiamieieg, kicpin ki madji todago8eg a8iag, ponenimik. Kije Manido dac 8in, Kidadami8a 8ak8ig ka tedj, kiga kasiamago8a kipatado8ini8a. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kicpin dac ega ponenimeg8a kodagiag a8iagog, ka8in Kidadami8a 8ak8ig ka tedj kiga kasiamagosi8a adi kagi iji patadieg,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ki ija8ag mina8adj Jerusalem odenakag. Meg8adj Jesos e pabamosegobanen Coda8inni kitci aiamiemigi8amikag, Coda8inni kitci aiamie ogiman, Coda8inni kikinoamage8innin, acitc ka niganizindjin Coda8innin ogi pi nazikagon. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ogi k8ag8edjimigon dac: “8egonen 8edji todamanin ini kegonan? A8enen kagi pagidinik kidji todaman ii?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesos ogi nak8e8ajian: “Pejig kegon kiga k8ag8edjiminom. Kicpin dac nak8e8ajiijieg, kiga 8idamonom 8egonen 8edji kackito8an kidji todamanin ini kegonan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","8idamaocik dac, a8enen ka pidjinija8adjin Cabadisan kidji sigaadagendjin, Kije Manido na, kek8an a8iagog?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Igi8e dac Coda8innig ki kitci aiamiidi8ag 8ina8a tibina8e, e inidi8adj: “Kicpin nak8e8ajit8aiak: ‘Kije Manido ka pidjinija8adjin Cabadisan,’ kiga k8ag8edjimigonan: ‘8egonen dac 8edji ega ki teb8eta8eg Cabadis?’ ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kicpin dac ikido8ak: ‘A8iagog ka pidjinija8a8adjin Cabadisan,’ kakina a8iagog kada kiji8azi8ag.” Okosa8abanin a8iagon, kakina mega inendamobanin maia e niganadjimo8inni8inipanin ini Cabadisan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ogi nak8e8ajia8an dac Jesosan: “Ka8in nikikenimasi8anan a8enen kagi pidjinija8adjin.” Jesos dac ogi inan: “Misa dac kenin ka8in kiga 8idamaosinonom 8egonen 8edji todamanin ini kegonan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesos ki madjita kidji anim8edj, adisokani e abadjitodj e kikinoamagedj: “Pejig nabe ki kitigegoban cominici kitiganan odakikag. Ki meniganatigoke dac 8ajagam okitigan akikag, kijadj ki monaige ke iji cacagocka8agani8indjin cominican, acitc ogi ojiton tecibidagani kidji gi odji nagadjitodj okitigan aki. Mina8adj dac ogi a8ian nandam kodagian kitige8innin okitigan aki, midac ka iji nda pabamadizidj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Apitc ka ani odjitcisenig kidji ma8adjiagani8indjin ini cominican, aa nabe ogi ijinija8an pejig odanokitage8inniman kidji nda 8abamandjin ini a8iagon kagi a8iadjin okitigan aki, kidji a8i nadji8inandjin inigik cominican kagi inendagozinipanin kidji minigodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Igi8e dac kitige8innig ogi na8adjibina8an ini anokitage8innin, ogi migana8an, acitc ogi ki8enija8a8an ega kegoni e mina8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Aa dac ka tibendag kitigan akini mina8adj ogi ijinija8an pejig kodagian odanokitage8inniman 8edi okitigan akikag. Igi8e dac kitige8innig ogi papakitectig8ane8a8an acitc ogi manenima8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Aa dac ka tibendag kitigan akini ogi ijinija8an kiabadj kodagian pejig odanokitage8inniman, kitige8innin dac ogi nisigon. Midac maia pejig8an ka toda8a8adjin igi madji kitige8innig mane kodagian anokitage8innin kagi pidjinija8agani8indjin. Nandam ogi migana8an acitc nandam ogi nisa8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Aa dac ka tibendag kitigan akini, mi eta aja ka kitci sagiadjin og8izisan tebanin. Ick8eag dac, ogi ijinija8an ini og8izisan 8edi okitigan akikag, e inendag: ‘Oga manadjia8an nig8izisan.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Igi8e dac kitige8innig ki inidi8ag: ‘Mi aa ockina8e nage ke kacka8idj ick8a nibondjin odadaman. A8isa nisadan, kina8it dac kiga tibendam8anan ii okitigan aki.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ogi na8adjibina8an dac ini ockina8en, ogi nisa8an acitc ogi sagidji8idona8a o8ia8ini iima kitigan akikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jesos dac ki k8ag8ed8e: “Adi dac enendameg ke todag aa ka tibendag kitigan akini? Mi oo8e ke todag. Kada ija okitigan akikag, oga nisan kakina ini kitige8innin acitc oga a8ian kodagian a8iagon okitigan aki. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kigi nabo8adana8adok oo8eni ka mazinadenig Kije Manido Omazinaiganikag: ‘Migi8amike8innig ogi ana8enima8an ini asinin. Anic dac mi aa asini ma8adji ka ani kitci apitendagozidj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ka Tibendjigedj dac ii ka todag, kikitci mamakadendananan dac e 8abadamak,’ ” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Coda8innig dac ka niganizi8adj ogi nanada8i kikendana8a adi ke todamo8apan kidji takona8adjin Jesosan. Ogi kikendana8aban mega egi mikomigo8adjin apitc ii ka inadisokendjin. Pekic dac okosa8abanin ini kitci mane a8iagon iima ka tenipanin. Ogi nagana8an dac Jesosan, acitc mi ka iji madja8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nandam Coda8innig ka nagadjito8agobanen inakonige8inan acitc nandam ogima Herod odanodaganan ki ijinija8agani8i8ag kidji nda nagicka8a8adjin Jesosan, kidji nda k8ag8edjima8adjin kegoni, kidji gi k8ag8e katcidina8apanin anodj kidji iji nak8e8ajii8endjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ogi pi ina8an: “Kikinoamage8inni! Nikikendananan kin e teb8ean. Ka8in kikosasi8ag adi enendamo8adj a8iagog, ka8in mega kipabiziskendasin adi eji apitenimagani8idj a8iag. K8aiak kikikinoamage adi ke todjigadenig 8e8enda kidji gi nosoneigadenig Kije Manido omikana. 8idamaocinam dac, ikidomaganon na kidinakonige8inanan kidji kijika8aiak ma8adji kitci ogima Sesar (César), Rom ka tajikedj, kek8an ka8in? Kida kijika8anan na?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesos dac ogi kikendanaban adi maia enendamindjin ini a8iagon. Ogi inan dac: “8egonen 8edji k8ag8e katcidinijieg anodj kidji iji nak8e8ajii8eian? 8abadaicik peconias.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ogi 8abadaa8an dac pejig peconiasan. Jesos dac ogi k8ag8edjiman: “A8enen dac aa ka mazinazodj? A8enen ii o8izon?” “Kitci ogima Sesar,” ogi ina8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesos dac ogi inan: “Mijik sa dac kitci ogima Sesar kegoni ka tibendag, acitc Kije Manido mijik kegoni ka tibendag.” Ogi kitci mamakazita8a8an dac Jesosan kagi ikidondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nandam Coda8innig “Sadose8innig” (Sadducéens) ka ijinikanagani8i8agobanen ogi pi nazika8a8an Jesosan. Mi igi ako ka ikido8agobanen ega kidji abidjibandjin a8iagon. Ogi pi k8ag8edjima8an dac: ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Kikinoamage8inni! Mois kigi minigonanaban oo8e inakonige8ini: ‘Kicpin pejig nabe ka o8idigemaganidj odji nibodj, ega egi aia8adjin abinodjijan, inendagozi8an o8idjiki8en kidji iji niba8indjin okokomiman, kidji gi odabinodjijimiadjin o8idjiki8en kagi nibondjin.’ Mi ka inakonigedj Mois. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nigodin dac tebanig e nij8atci8apan nabeg e iji 8idjiki8emidi8adj. Kitci oseezima dac ki niba8i, acitc ki nibo ega egi tendjin odabinodjijiman. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mina8adj dac teci8ag o8idjiki8en aa8e ki iji niba8i ini ka pejigondjin ik8e8an, acitc mi ke8in ki nibo ega egi aia8adjin abinodjijan. Midac pejig8an ka ijisendjin kodag o8idjiki8en, ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","acitc mi pejig8an kakina ka ani ijise8adj e midjinij8atci8adj. Ki niba8i8ag acitc ki nibo8ag ega egi odabinodjijimi8adj kakina eji nij8atci8adj ka iji 8idjiki8emidi8adj. Ick8eag dac, aa ik8e ke8in ki nibo. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Apitc dac odjitcisenig kidji abidjiba8adj ka nibo8adj, adi ini8e maia ke iji o8idigemaganidj aa ik8e? Kakina mega ka nij8atci8adj igi nabeg ki iji niba8i8ag ini pejig8an ik8e8an,” ogi iji k8ag8edjima8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesos dac ogi nak8e8ajian: “Anodj kidinendana8a! Ka8in mega kikikendasina8a Kije Manido Omazinaigan kek8an omacka8izi8in. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Apitc ki abidjiba8adj igi kagi nibo8adj, ka8in kada niba8isi8ag nabeg acitc ik8e8ag. Tiegodj, mi maia pejig8an ke iji pimadizi8adj ajenin ka iji pimadizindjin 8ak8ig ka tendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kicpin dac 8i kikendameg ke apitci abidjiba8ag8en kagi nibo8adj, kana panima kida nabo8adasina8a adi eji mazinadenig Mois omazinaiganikag e mikomadjin mitigon ka taji piskanenigobanen? Mazinadeni iima adi Kije Manido ka iji 8idama8agobanen Moisan: ‘Nin Abanaam (Abraham), Aisik (Isaac) acitc Tcekap (Jacob) Okije Manidomi8an,’ mi mezinadenig. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kije Manidon dac 8in Okije Manidomi8ag igi8e ka pimadizi8adj, ka8in 8in igi8e kagi nibo8adj. Maia dac anodj kina8a kidinendana8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Pejig Coda8inni kikinoamage8inni ogi noda8an Jesosan acitc ini Sadose8innin e taji aiamiidindjin. Ogi noda8an Jesosan 8e8enda egi nak8e8ajiandjin ini8e Sadose8innin. Aa dac nabe ogi pi nazika8an Jesosan acitc ogi k8ag8edjiman: “Kakina ka tag8agin inakonige8inan, adi ii8e inakonige8in ma8adji ketci apitendag8anog8en?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesos ogi nak8e8ajian: “8adan oo8e inakonige8in ma8adji ka kitci apitendag8ag: ‘Ndotamok kina8a Israel a8iagog! Pejigo eta ka Tibendjigedj Kikije Manidominan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kiga sagia8a ka Tibendjigedj Kikije Manidomi8a enigokodeeieg, enigokodjitcagocieg, enigokomidonendjiganieg, acitc kakina epitcieg.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","8adan dac oo8e kodag inakonige8in ka kitci apitendag8ag: ‘Kiga sagia8a kidjipimadizimi8a tabickotc kina8a ka iji sagiidizo8eg.’ Ka8in kodag tag8asinon inakonige8in na8adj e kitci apitendag8ag apitc8in ono8e,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Aa Coda8inni kikinoamage8inni ogi inan Jesosan: “Kikinoamage8inni! Maia kiminotagozinan. Kiteb8e. Motci pejigo eta Kije Manido, ka8in kodag tesi. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Panima dac a8iag oda sagian Kije Manidon enigokodeedj, enigokomidonendjiganidj, acitc kakina epitcidj, acitc panima oda sagian o8idjipimadiziman tabickotc ka iji sagiidizodj. Na8adj min8acin a8iag kidji nosoneagin ono8e inakonige8inan apitc8in kidji pagidinigetama8adjin Kije Manidon a8esizan kek8an kodag pagidinige8inan,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesos ogi 8abadan 8e8enda egi nak8e8ajiigodjin. Ogi inan dac: “Ka8in kina8abadasin Kije Manido Odogima8i8in.” Ka ick8a ikidodj ii, ka8in mina8adj a8ian kegoni ododji k8ag8edjimigosin. Kakina mega cag8enimobanin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Apitc Jesos e kikinoamagepan Coda8inni kitci aiamiemigi8amikag, ki k8ag8ed8e oo8eni: “Adi dac 8ina8a Coda8inni kikinoamage8innig 8edji ikido8adj Davidan ini odanike ojisini ini a8ian Kije Manidon kagi ikidonipanin kidji pidjinija8andjin? ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David mega, e kigickagodjin Mino Manidon, 8inigotc ki ikidogoban oo8eni: ‘Ka Tibendjigedj ogi inan ka Tibenimijindjin: Nikitcinikikag iji pi nda abin, pinici kidji cagodjiag8a ka madjenimik8a, kinikag kidji iji tabasendizo8adj.’ ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David dac 8inigotc ‘Ka Tibenimijidj’ odijinikanan ini a8ian Kije Manidon kagi ikidonipanin kidji pidjinija8andjin. Adi dac kegi odji ijisedj David kidji odanike ojisidj ini?” Mane a8iagog ogi kitci minota8a8an Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Meg8adj dac e kikinoamagegobanen, Jesos ki ikido: “Iag8amenimikog Coda8inni kikinoamage8innig, ka kitci min8endamo8adj kidji paba kigickamo8adjin okonasan ka kitci kin8eganigin acitc ka kitci min8acinigin. Kitci min8endamog e anamika8agani8i8adj ka iji manenani8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Nigan ma8adji 8i iji abi8ag Coda8inni aiamiemigi8amikag kidji gi 8abamagani8i8adj. Ma8adji dac ka iji min8acinig 8i iji abi8ag e magocani8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Okimodima8an ik8e8an ka pejigondjin, pekic dac kitci kin8ej aiamie8ag kidji mino inabaminagozi8adj. Na8adj kada sogakonagani8i8ag 8ina8a,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesos ki abi pecodj ka iji pagidinigani8anig conian iima Coda8inni kitci aiamiemigi8amikag acitc ogi kana8abaman a8iagon e pagidinigendjin. Ka kitci 8anadizi8adj kitci mane odasa8abanin conian. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pejig ik8e egi pejigopan e kitci kidimagizipan nijin somaniken eta ki pagidinige. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesos dac ogi nd8e8eman okikinoamaganan acitc ogi inan: “Teb8e ki8idamonom, aa ka kidimagizidj ik8e 8in ma8adji mane ki migi8e apitc8in kakina kodagiag a8iagog. ");
INSERT INTO alqALGNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Igi8e ogi asa8an oconiami8an ega teb8e ka nda8enima8adjin. 8in dac, misa8adj e kitci kidimagizidj, kakina oconiaman ogi asan. Kegi pimadjio8agepan kakina ki migi8e,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Apitc Jesos e ani sagaag Coda8inni kitci aiamiemigi8amikag, pejig okikinoamaganan ogi igon: “Kikinoamage8inni! Kijigabadan ii aiamiemigi8am! Kitci minojici8ag asinig kagi abadizi8adj kidji ojitcigadeg! Kitci micadon ii aiamiemigi8am acitc kodagian migi8aman ooma ka iji acidakisigin!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesos ogi nak8e8ajian: “Ki8abadan na ii aiamiemigi8am acitc kakina ini kodagian migi8aman ooma ka iji acidakisigin? Kada odjitcise nigodin ega iaga pejig asinig kidji aiag8ita8abi8adj. Kakinagotc kada k8enabagodjinog,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesos ki abi Olip (Oliviers) pik8adinajicikag, nigan Coda8inni kitci aiamiemigi8amikag. Pien, Jak, John, acitc Andre, 8ina8a eta o8idji8a8abanin Jesosan. Ogi k8ag8edjima8abanin dac: ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“8idamaocinam anapitc ke iji8ebag ii, acitc 8egonen ke 8abadai8emagag e odjitciseg kidji iji8ebagin kakina ini kegonan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesos dac ogi inan: “Iag8amendamok ega kidji 8aiejimigo8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mane mega a8iagog kada pija8ag ni8izoni e abadjito8adj, acitc kada ikido8ag: ‘Nin aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin.’ Mane dac a8iagon oga 8aiejima8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Apitc nodameg e mad8e migadinani8ag pecodj acitc nodageieg e mad8e migadinani8ag 8asag anodj 8edi, ka8in segizikegon ii odji. Panima ii kada iji8eban, ka8in dac maci kada ponaki8asinon. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Pejig8eieg a8iagog ka inakanezi8adj oga migana8an a8iagon pakan ka inakanezindjin, acitc a8iagog pejig aki ka tajike8adj oga migana8an a8iagon pakan akin ka tajikendjin. Kada k8ig8an aianodjigotc, acitc kada ka8askadani8an. Apitc ii iji8ebag, mi maia tabickotc ik8e ka madapinedj kidji nta8igindjin odabinodjijiman ke ijinag8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kina8a dac, iag8amendamok. A8iagog mega kiga takonigo8ag acitc nigan tibakonige8innikag kiga iji8inigo8ag. Kiga papajacteogo8ag Coda8inni aiamiemigi8amikag. E nosoneojieg mega ke odji takonigo8eg acitc ke odji iji8inigo8eg nigan ka niganizi8adj acitc ogimakag kidji tibakonigo8eg. Ii dac apitc, kiga 8idama8a8ag min8adjimo8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pinama dac, kada tibadjimonani8an min8adjimo8in kakina ka inakanezi8adj a8iagog kidji nodage8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Apitc dac takonigo8eg kidji iji8inigo8eg nigan tibakonige8innikag, ka8in nigod inendakegon adi ke ikido8eg. Midac ii apitc, ikidok adi eji 8idamago8eg kidji ikido8eg. Ka8in mega kina8akag kada odjisesino8an kidikido8ini8an, Mino Manidokag kada odjimaganon.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Nandam a8iagog oga mamijima8an o8idjiki8e8an kidji nisimagani8indjin, acitc mi nandam nabeg pejig8an ke toda8a8adjin odabinodjijimi8an kidji gi nisimagani8indjin. Nandam abinodjijag oga ana8eta8a8an onigiigo8an, acitc oga pagidenima8an kidji nisimagani8indjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","E nosoneojieg, kakina a8iagog kiga odji madjenimigo8ag. Aa8e dac ega ke ana8endjigedj, ka sogigaba8idj dac, mi aa8e ke ag8acimagani8idj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Kiga 8abama8a aa8e ‘Kitci madji kegon ka kitci kotadendag8ag’ ka ijinikazodj. Kada te dac iima ega ka iji inendagozidj kidji tedj. Aa8e ke nabo8adag oo8e, panima 8e8enda oda k8ag8e nisidotan. Ii dac apitc, igi8e Coda (Judée) akikag ka tajike8adj, panima pik8adinakag kada ipai8e8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Aa8edi 8agidabak8an omigi8amikag ke teg8en, ka8in kadagi pidigebatosi kidji a8i ma8adobidodjin odaiman. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mi pejig8an, aa8e okitigan akikag ke teg8en, ka8in kadagi koki ki8esi kidji nda nadji8idodj opizika8agan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ii dac apitc, kada kitci kodagito8ag ik8e8ag ke kigicka8a8ag8en abinodjijan acitc igi8eni8ag ke tcodjocikea8aso8ag8en. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Aiamieok dac ega kidji iji8ebag meg8adj e pibog. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ii mega apitc, na8adj kada kitci sogendag8an kodagito8in apitc8in kakina kodagian ka pi tag8agin, ka ako madji tag8ag aki, apitc Kije Manido kakina kegonan ka kijendamogobanen, pinici nogom, acitc ka8in mina8adj 8ikad pejig8an kada iji8ebasinon. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kicpin ka Tibendjigedj ega ki inendagiban kidji adji8inag inigik ke iji kodagitonani8anig, ka8in a8iag kadagi pimadjiosiban. Ini8e dac a8iagon odji kagi onabamadjin 8inikag kidji iji tibendagozindjin 8edji ki adji8inag inigik ke iji kodagitonani8anig.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Kicpin dac a8iag igo8eg: ‘Inabiok! Aja ooma te aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin!’ kek8an: ‘Iima te!’ ka8in teb8eta8akegon. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nandam mega a8iagog kada pija8ag e kagina8icki8adj e ikido8adj: ‘Nin aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin’ kek8an: ‘Nin niniganadjimo8inni8inan.’ Kada mamada8izi8ag acitc kada mamada8akamigizi8ag, kidji k8ag8e 8agackibina8adjin 8a8adj ini8e a8iagon Kije Manidon kagi onabamigondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kina8a dac, iag8amig! Kigi 8idamonom nigan kakina ke iji8ebag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ii dac apitc, ki ick8a tag8anigin ini kodagito8inan, kada ani makade8asige kizis acitc ka8in kada tcakasigesi tibikikizis. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","8ak8ikag kada odagodjinog 8anagocag, acitc kakina kegonan icpimig kada ninigise8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ii dac apitc, nin, Ka pi Anicinabe8iidizodj, niga 8abamigo, kidji pi najiseian nena8idj 8ak8ikag, e kitci macka8izian acitc e kitci icpendagozian. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Niga ijinija8ag dac nidajenimag mizi8ekamig kidji a8i ma8adjia8adjin kakina a8iagon kagi onabamimagin, adigotc ke tenig8enin.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Pagidinik minatig kidji kikinoamago8eg kegoni. Apitc o8adik8anan madjiginigin acitc onibicibagoman sagiginigin, kikikendana8a aja pecodj kidji nibig. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Midac pejig8an, apitc 8abadamegon ini kegonan e iji8ebagin, kiga kikendana8a aja e ani peconag8anig kidji tag8icig Ka pi Anicinabe8iidizodj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Teb8e ki8idamonom, ka8in kakina kada nibosi8ag a8iagog nogom ka pimadizi8adj, ab8amaci kakina ii iji8ebag ka ikido8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","8ak8i acitc aki kada ponise8an, nidikido8inan dac 8in ka8in 8ikad kada ponisesino8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ka8in dac a8iag okikendasin anapitc maia ke ponaki8anig. Ka8in 8a8adj ajenig 8ak8ig ka te8adj okikendasina8a, ka8in 8a8adj Kije Manido Og8izisan okikendasini. Mi eta Kije Manido Kidadaminan okikendan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Iag8amig dac! Eco8iok! Ka8in mega kikikendasina8a anapitc ke ponaki8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mi maia tabickotc pejig nabe e 8i a8i pabamadizidj ke ijinag8ag apitc 8i ponaki8ag. Onagadan omigi8am aa a8iag, e anonadjin odanokitage8inniman kidji kana8endamindjin. Pepejig ominan kegoni kidji ijitandjin acitc 8e8enda o8idama8an ick8ademini ka kana8endamindjin ega kidji ka8ig8acinindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Eco8iok dac! Ka8in mega kikikendasina8a apitc ke koki pi ki8edj aa ka tibendag migi8amini. Ne8ad kada onag8icini, kek8an meg8a tibik, kek8an apitc mokaag kizis, kek8an apitc maia ani 8abanig. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kicpin kitata odji tag8icig, panima ega ki mikago8eg meg8adj e nibaieg. ");
INSERT INTO alqALGNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Oo8e ka ininagok, kakina a8iagog ni8idama8ag: ‘Eco8iok!’ ” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nijogon eta aja ab8amaci Coda8inni Kitci Magocani8ag, Pak ka ijinikadeg, apitc ako ka am8agani8igobanen pak8ejigan ega ka obicig. Ii dac apitc, Coda8inni kitci aiamie ogimag acitc kikinoamage8innig ogi nanada8i kikendana8a adi ke todamo8apan kidji gi kimodji takona8apanin Jesosan acitc kidji gi nisa8apanin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ki ikido8ag dac: “Ka8in kigagi takonasi8anan meg8adj e Kitci Magocani8anig. A8iagog mega kigagi odji kitci nickiananag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesos tegoban Betani (Béthanie) odenakag, acitc ki ijagoban Simon omigi8aminikag. Simo dac kitci omigi8apinegoban. Meg8adj Jesos e taji 8isinipan iima, pejig ik8e ki tag8icin, e kitci min8acinig modaiabikoni e pidodj, e kicponebinig ka minomag8anig ka kitci sanaganig, “nard” ka ijinikadenigobanen. Aa dac ik8e ogi cenan ii modaiabikoni acitc ogi siginan ii ka minomag8anig Jesosan octig8anikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nandam dac a8iagog ki kiji8azi8ag acitc ki inidi8ag: “8egonen 8edji ki 8anadjitodj ii ka minomag8anig? ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Pejigopibon inigik a8iag e mikimodj apitendag8an kidji kijikadamosegiban ii ka minomag8ag. Kadagi ada8ani8anoban dac, acitc kadagi minagani8ibanig conian ka kidimagizi8adj.” Ogi kitci kaganona8an dac ini ik8e8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesos dac ki ikido: “Ka8in pamenimakegon. 8egonen 8edji animieg? Kitci min8acini ii kagi todaojidj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kabena ka kidimagizi8adj kiga 8idji tajikemigo8ag, acitc mojag kigagi 8idoka8a8ag apitcigotc neda8endameg. Nin dac 8in, ka8in apanigotc kiga 8idji tajikemisinonom. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Aa ik8e eji kackitodj ogi todan. Ogi siginan nia8ikag oo ka minomag8anig, kidji iji medoni ojitodj ab8amaci naatcigadenig nia8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Teb8e ki8idamonom, adigotc ke iji paba tibadjimonani8anig Kije Manido omin8adjimo8in mizi8ekamig, kada tibadjimonani8ani adi kagi todag 8aa ik8e, acitc kada mik8enimagani8i,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iskaniot (Iscariote), pejig ii e midatcin acitc nijindjin Jesos okikinoamaganan, ogi nda 8abaman Coda8inni kitci aiamie ogiman, e nda inadjin e 8i 8idoka8adjin kidji takonandjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ogi kitci min8endana8a e nodamo8apan ii, acitc ogi ina8an conian kidji mina8adjin. Judas dac ogi madji nanada kikendanaban anapitc maia ke minosenigiban kidji gi mamijimapanin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Madjita8agoban e kitci ijigijiganoke8adj, apitc ako ka am8agani8igobanen ega ka obicig pak8ejigan, acitc odjitcisenigoban kidji nisa8agobanen mantcenicesan kidji gi pagidinige8adj. Jesos dac okikinoamaganan ogi pi nda k8ag8edjimigon: “Ataji iima eji nda8endaman kidji nda 8isinanikeiag, kidji gi Kitci Magocanikeiak?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jesos dac ogi ijinija8an nijin okikinoamaganan acitc ogi inan: “Ijaok odenag. 8edi dac kiga nagicka8a8a pejig nabe, nibi8ajini e pimi8idodj. Nosoneok dac. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Taji ke iji pidigedj, 8idamaok aa ka tibendag migi8amini: ‘Kikinoamage8inni k8ag8ed8e: Ataji e tag8ag nipakesagam ke iji magoceian kigi nikikinoamaganag?’ ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kiga 8abadaigo8a dac icpimisagog omigi8amikag pejig kitci pakesagani aja egi ick8a ojitcigadenig kidji abadanig. Mi iima ke iji a8i ojito8eg midjim kidji gi 8isiniak,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ki madja8ag dac igi nijin kikinoamaganag, acitc odenag ki ija8ag. Ogi mikana8a kakina Jesosan kagi ikidonigobanen, acitc ogi ojitona8a kidji magocani8anig e kitci ijigijiganig. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Apitc e ani onag8icinig Jesos acitc ka midatcin acitc nijindjin okikinoamaganan ki tag8icinog iima pakesagakag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Meg8adj e 8akanabi8adj 8isini8aganikag e taji 8isini8adj, Jesos ki ikido: “Teb8e ki8idamonom, pejig oo e tacieg niga mamijimig, pejig ka taji 8idji 8isinimijidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kakina dac okikinoamaganan ki kitci kackendamise8an acitc pepejig aiackodj ogi k8ag8edjimigon: “Ka8in nin ke todaman, kana?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesos ogi nak8e8ajian: “Pejig oo e midatcin acitc nijieg, aa8e ke8in ke kidagaminadjin opak8ejiganiman apitc nin kidagaminimagin, mi aa8e ke todag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ketcinam nin, Ka pi Anicinabe8iidizodj, niga nibonan, maia tabickotc ka iji mazinadenig Kije Manido Omazinaiganikag. Anic dac 8in aa nabe ke mamijimijidj, kada kitci madji iji8ebizi. Na8adj kadagi minoseniban aa nabe ega ki nta8igipan,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Meg8adj e taji 8isini8adj, Jesos ogi odapinan pak8ejiganan, mig8etc ogi inan Kije Manidon, acitc ogi papak8ebinan. Ogi minan dac okikinoamaganan, e ikidodj: “Odapinik. Mi oo8e nia8.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mina8adj dac ogi odapinan minik8anagani, mig8etc ogi inan Kije Manidon, acitc ogi minan. Kakina dac pepejig ki minik8e8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesos dac ogi inan: “Mi oo8e nimisk8i, 8edji madjitamaganig Kije Manido onakomo8in kidji mama8ise8adj Kije Manido acitc odanicinabeman. Kitci mane a8iagog odji siginigade. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Teb8e ki8idamonom, ka8in 8ikad mina8adj niga minik8esi cominabo pinici kidji minik8eian ocki cominabo Kije Manido Odogima8i8inikag,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ki nigamo8ag dac ini aiamie nigamo8inan ka nigamonani8anig ako apitc e Kitci Magocani8anig, midac ka iji ija8adj 8edi pik8adinajicikag Olip (Oliviers) ka ijinikadenig. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesos ogi inan okikinoamaganan: “Kakina e tacieg kiga naganijim, maia tabickotc ka iji mazinadenig Kije Manido Omazinaiganikag: ‘Mantcenican ka kana8enimadjin niga nisa, midac kakina kada obebaidi8ag mantcenicag,’ mi e mazinadenig. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ick8a abidjibaian dac, Galilee akikag kiga iji nda piinom,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pien dac ogi inan: “Misa8adj kakina 8ina8a naganik8a, ka8in 8ikad nin kiga naganisinon.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesos ogi nak8e8ajian: “Teb8e ki8idamon, ogajigag, nogomigotc ke tibikag, ab8amaci nabe pakaak8an nijinanaj nodagozidj, aja nisinanaj kigagi odji ikidonan ega e kikenimijian.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Na8adj dac kiabadj Pien ki k8ag8e teb8e e ikidodj: “Ka8in 8ikad niga ikidosi ega e kikeniminan, misa8adj 8idji nibominaban.” Midac pejig8an kodagian okikinoamaganan ka ikidonigobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesos acitc okikinoamaganan ogi oditana8agoban Getsemane (Gethsémané) ka ijinikadenig kitigan akini. Jesos dac ogi inan okikinoamaganan: “Ooma abiok, meg8adj e nda aiamieian.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Mi eta nisin ogi madji8inan, Pienan, Jakan, acitc Johnan. Tedago dac Jesos ki odji segizi acitc ki kitci animendam. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ogi inan dac: “Nikitci ka8enimonan. Tajikeok ooma, ka8in dac nibakegon e taji piijieg,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","A8acic pagi ki ija taji eji tenipanin okikinoamaganan, acitc ki 8anijibanio. Ki aiamie dac ega mamakadj kidji kodagitodj, kicpin minosegiban. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ki ikido e aiamiedj: “Nidadam! Kakina kegon kikackiton. 8ack8ebidon nidanimizi8in! Pekic dac ka8in nin ka iji nda8endaman todaken, tiegodj kin ka iji nda8endaman todan,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ogi koki nda 8abaman dac ini ka nisindjin okikinoamaganan, acitc ogi mika8an e pajigog8acinindjin. Ogi inan dac Pienan: “Simo! Kiniba na? Kana 8a8adj pejigotibaigan kikackitosin kidji cibig8acian? ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Cibig8aciok, acitc aiamieok kidji macka8izieg, ega kidji gi pakebinigo8eg madji manido. Teb8e ki8i k8ag8e k8aiak8adizim, pekic dac kia8i8a kitci cagozimagan,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mina8adj Jesos a8acic pagi ki ija taji eji tenipanin okikinoamaganan, midac kiabadj pejig8an ka ikidodj e aiamiedj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ogi koki nda 8abaman dac okikinoamaganan acitc mina8adj ogi mika8an e pajigog8acinindjin. Kitci aiekozi8agoban mega acitc ka8in okackitosina8agoban kidji cibig8aci8adj. Ki agadji8ag dac, acitc ka8in ododji kikendasina8a ke ina8adjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Apitc dac nisinanaj Jesos e koki nda 8abamadjin okikinoamaganan, ogi inan: “Kiabadj na kinibam acitc kidan8ecimonom? Aja tibise! Aja odjitcise nin, Ka pi Anicinabe8iidizodj, kidji pagidenimigo8an kidji gi tibenimiji8adj ka patadi8adj a8iagog. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","8anickaok! Ijadan! Kijigabamik, aa nabe ke mamijimijidj aja tag8icin,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kiabadj Jesos taji anim8egoban, apitc Judas ka odji tag8icinogobanen, mi aa pejig ka midatcin acitc nijindjin okikinoamaganan. Kitci manebanin a8iagon Judas e 8idjiogogobanen, kitci mokomanan acitc mitigon e pimi takonamo8agobanen. Ogi pidjinijaogo8agoban Coda8inni kitci aiamie ogiman, Coda8inni kikinoamage8innin, acitc ka niganizindjin Coda8innin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas dac, aa8e kagi mamijimadjin Jesosan, aja ogi 8idama8abanin a8iagon adi ke inakamigizidj. Ogi inagobanin dac: “Aa8edi ke nda odjimag, mi aa8e ka nda8enimeg. Takonik dac aa acitc madji8ijik, 8e8enda kana8enimik.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Apitc dac ka tag8icig Judas, teci8ag ogi pi nda nazika8an Jesosan, acitc ogi inan: “Kikinoamage8inni!” Ogi odjiman dac. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Igi dac kodagiag a8iagog ogi na8adina8an Jesosan acitc ogi takona8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pejig dac ii e taci8adj ka tegobanen iima ka 8idji8agobanen Jesosan, ogi odapinan okitci mokoman, ogi pakite8an Coda8inni aiamie ogiman ma8adji ka niganizindjin odanodagani acitc ogi kickita8age8eba8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesos dac ki ikido: “Mi na e ijio8eg, e omokomanieg acitc e omitigomieg e pi nadji8inijieg, tabickotc kimodi8inni8iaban? ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Taso kajik kigi 8idjionom acitc nigi kikinoamage Coda8inni kitci aiamiemigi8amikag, ka8in dac kidodji takonijisim. Iji8eban dac ii kidji gi ijiseg adi kagi mazinadenig Kije Manido Omazinaiganikag,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kakina dac ka 8idjiogopanin ogi naganigon acitc ki ojimobanin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pejig ockina8e onosone8agoban Jesosan, 8abo8ani eta apag8aniban. Ki k8ag8e na8adjibinagani8i, ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","midac ka iji pagidji8ebinag 8abo8ani aa ockina8e acitc ki ojimo e moceckadedj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ogi iji8ina8an dac Jesosan Coda8inni aiamie ogiman ma8adji ka niganizindjin omigi8aminikag. Kakina Coda8inni kitci aiamie ogimag, ka niganizi8adj Coda8innig, acitc Coda8inni kikinoamage8innig ki iji ma8adjiidi8ag iima. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pien dac 8asag odakanag ogi pi odji nosone8agoban Jesosan, acitc ki pidigeako taji ka iji tag8anig Coda8inni aiamie ogiman ma8adji ka niganizindjin omigi8amini. Iima dac, ogi a8i 8idabiman ini ka kana8endamindjin aiamie ogiman ma8adji ka niganizindjin omigi8amini, acitc ki a8azo pecodj ickodekag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Igi8e Coda8inni kitci aiamie ogimag acitc kakina Coda8inni kitci aiamie onakonige8innig, ogi k8ag8e mikana8a kegoni kegi odji inactaona8apanin Jesosan, kidji gi odji ick8aienima8adjin. Ka8in dac kegoni ododji mikasina8a kegi odji ick8aienima8apanin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mane a8iagog ki pi kagina8icki8ag e inactaona8adjin Jesosan, pekic dac ka8in ododji kackitosina8a kakina pejig8an kidji ikido8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nandam dac a8iagog ki pazig8i8ag acitc ki kagina8icki8ag e inactaona8adjin Jesosan, e ikido8adj: ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nigi noda8anan e ikidodj: ‘Niga nici8anadjiton oo kitci aiamiemigi8am nabeg kagi ojito8adj acitc nisogon inigik niga tajikan kidji ojito8an kodag ega nabeg egi ojito8adj.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ka8in dac kiabadj ododji kackitosina8a pejig8an kidji ikido8adj kakina. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Coda8inni aiamie ogima ma8adji ka niganizidj ki pazig8i acitc ogi k8ag8edjiman Jesosan: “Kana kegon kidiji nak8e8ajii8esi? Teb8e8ag na igi ka inactaonik8a?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ka8in dac Jesos odji kidosi acitc ka8in odji nak8e8ajii8esi. Aa dac Coda8inni aiamie ogima ma8adji ka niganizidj kiabadj ogi k8ag8edjiman: “Kin na aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin, Kije Manido ka icpenimaiak Og8izisan?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesos ogi inan: “Ee, acitc kakina kiga 8abamijim nin, Ka pi Anicinabe8iidizodj, kidji abian Kije Manido ma8adji ka kitci macka8izidj okitcinikikag, acitc kiga 8abamijim kidji pi najiseian nena8idj 8ak8ikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Aa dac Coda8inni aiamie ogima ma8adji ka niganizidj ogi tadobidon okonas epitci kitci madjita8adjin, acitc ki ikido: “Ka8in aja kodag a8iag ninada8enimasi8anan kegoni kidji pi nda tibadjimodj! ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kakina e tacieg kigi noda8a8a e manazomadjin Kije Manidon. Adi enendameg?” Midac ogi inakona8an Jesosan kidji nisagani8indjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nandam dac a8iagog ki madjita8ag kidji sik8ana8adjin. Ogi nigeabapina8an dac, acitc ogi papakite8a8an e ina8adjin: “A8enen ka pakiteok? 8idamaocinam!” Igi8e dac ka kana8endamo8adj aiamie ogiman ma8adji ka niganizindjin omigi8amini ogi madji8ina8an Jesosan acitc ogi papasaba8a8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pien dac ag8adjik taji abigoban kiabadj 8edi nisisag. Pejig dac Coda8inni aiamie ogima ma8adji ka niganizidj odanodaganik8eman ki odji tag8icinon iima. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ogi 8abaman Pienan e taji a8azonipanin. 8e8enda dac ogi kijigabaman acitc ogi inan: “Kekin kipaba 8idji8aban Jesos, aa nabe Nazaret ka odjidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pien dac ki ikido ega e teb8emaganig ii, e nak8e8ajiadjin: “Ka8in nikikendasin 8egonen ka mikodaman, ka8in kinisidotaosinon.” Pien dac ki ijagoban pecodj 8akaak8aiganikag taji ka iji ick8ademi8anig. Ii dac apitc nabe pakaak8an ki nodagozi. ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Aa dac anodaganik8e ogi koki 8abaman Pienan acitc kiabadj ogi inan kakina ini8e iima ka tendjin: “Ke8in opaba 8idji8abanin Jesosan.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kiabadj dac Pien ki ikido ega e teb8emaganig ii. Ka8in kin8ej ick8a ii, igi8e iima ka te8apan ogi ina8an Pienan: “Kiketcinamenimigo, kekin kipaba 8idji8aban Jesos! Kekin mega Galilee akikag kidodji.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pien dac ki ikido: “Manodj pajacteojidj Kije Manido kicpin kagina8ickian! Teb8e ki8idamonom, ka8in nikikenimasi aa nabe ka mikomeg!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Maiagotc dac ii apitc, kiabadj ki nodagozi nabe pakaak8an acitc Pien ki odji mika8ise adi kagi igogobanen Jesosan: “Ab8amaci nabe pakaak8an nijinanaj nodagozidj, aja nisinanaj kigagi odji ikidonan ega e kikenimijian.” Midac Pien ka iji kitci ma8idj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","8ibadj e kijeba8acinig, Coda8inni kitci aiamie ogimag, ka niganizi8adj Coda8innig acitc Coda8inni kikinoamage8innig acitc kakina Coda8inni kitci aiamie onakonige8innig ki ma8adjiidi8ag kidji onakona8adjin Jesosan. Ogi mag8apina8an dac, acitc Pilatikag ogi iji8ina8an. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat dac ogi k8ag8edjiman Jesosan: “Kin na Coda8innig odogimami8an?” Jesos dac ogi nak8e8ajian: “Kin ka in8ean.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Coda8inni kitci aiamie ogimag kitci mane kegonan ogi inactaona8an Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilat dac mina8adj ogi k8ag8edjiman Jesosan: “Kana kegon kidikidosi? Kinodanadok kakina ini kegonan ka inactaonik8a!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ka8in dac kegoni ki odji nak8e8ajii8esi Jesos. Pilat dac ki kitci mamakadendam. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","E taso pibonig, meg8adj e Coda8inni Kitci Magocani8anig, Pilat opagidinabanin ako pejig takoniganan, ini8e ka nda8enimandjin a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pejig dac takonigan ii apitc Barabbas ijinikazogoban, kiba8agani8igoban egi nici8egobanen meg8adj e nak8itaomagani8inigobanen kitci ogiman. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kakina dac a8iagog ogi nda 8abama8an Pilatan acitc ogi k8ag8edjima8an kidji pagidinandjin pejig takoniganan, ka todaminigobanen ako. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilat dac ki ikido: “Kinada8endana8a na kidji pagidinag kina8a ka Coda8inni8ieg kidogimami8a?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Okikenimabanin mega Coda8inni kitci aiamie ogiman egi pagidenimanipanin Jesosan osa e odenimandjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Igi dac Coda8inni kitci aiamie ogimag ogi kadjinija8a8agoban kakina a8iagon kidji k8ag8ed8endjin Barabbasan kidji pagidinagani8indjin, ka8in 8in Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Mina8adj dac Pilat ogi inan a8iagon: “Adi dac eji nda8endameg kidji toda8ag aa8e Coda8innig odogimami8a ka ijinikaneg?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ki kitci pabibagi8ag dac: “Acidak8ao tcibaiatigokag!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilat dac ki k8ag8ed8e: “Adi dac ka iji panaagedj?” Kiabadj dac enigok ki kiji8e8ag e pabibagi8adj: “Acidak8ao tcibaiatigokag!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilat onada8endanaban kidji min8endamiadjin ini a8iagon, ogi pagidinan dac Barabbasan. Ki anoki dac kidji papajacteomagani8indjin Jesosan, acitc ogi anonan cimaganican kidji acidak8a8andjin Jesosan tcibaiatigokag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Cimaganicag dac ogi pidige8ina8an Jesosan kitci ogima8imigi8amikag. Ogi nd8e8ema8an dac kakina ka tacindjin cimaganican. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ogi pisikamodina8an e misk8eganig okonasini, acitc minesatigoni ki apikage8ag, sizok8epizoni e ojito8adj, acitc ogi 8agidatona8a Jesosan octig8anikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ogi ina8an dac: “Kidanamikago, Coda8innig odogimami8an!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ogi papakitectig8ane8a8an dac mitigoni e abadjito8adj, ogi sasik8ana8an acitc ki kitci nibak8ikazo8ag nigan Jesosikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Apitc ka ick8a manenima8adjin, ogi kitcikonaebina8an ii ka misk8eganig okonasini acitc ogi koki pisikamodina8an opitcikonaani. Midac ogi sagidji8ina8an kidji nda acidak8a8a8adjin tcibaiatigokag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Pejig nabe kitigan akikag odosegoban, Simo ijinikazogoban. Sinen (Cyrène) odenag odjigoban aa, mi aa8e Aleksanden (Alexandre) acitc Ropos (Rufus) odadami8an. Cimaganicag dac ogi na8adina8an ini naben acitc ogi mina8an Jesosan otcibaiatigomini kidji pimi8inandjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ogi iji8ina8an dac Jesosan 8edi “Golgota” ka ijinikadenig, “Golgota” dac ikidomagan “Tcibaictig8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ogi k8ag8e minaa8an cominaboni eji mama8agamisinig mackiki8aboni, “mir” (myrrhe) ka ijinikadenig. Ka8in dac Jesos odji minik8esi. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ogi acidak8a8a8an dac tcibaiatigokag. Ki madinamadi8ag dac opitcikonaani, e k8ag8e mikose8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Cagidasotibaiganeaban e kijeba8acinig apitc ka acidak8a8agani8igobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ojibiigani agokenigoban kidji tibadjimomaganig adi 8edji ki ick8aienimagani8idj, mazinadeniban dac: “Coda8innig odogimami8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Nijin kimodi8innig ki acidak8a8agani8i8ag ke8ina8a otcibaiatigomi8akag, midac nenida8ina Jesosikag ka iji padakicimagani8inigobanen otcibaiatigomi8an, pejig okitcinikikag inekena acitc pejig onamadinikikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Midac iidi ka ani iji8ebag ii kagi mazinadenig Kije Manido Omazinaiganikag: “Madji a8iagokag ki iji acidagimagani8i.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","A8iagog ka pimose8agobanen iima ki kitci 8e8ebik8ebanio8ag acitc okitci mamanazoma8abanin. Odina8abanin dac: “Kin ka 8i nici8anadjito8aban kitci aiamiemigi8am, acitc kidji gi koki ojito8an kodag nisokajik eta kidji tajikaman, ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","kin tibina8e pimadjiidizon, acitc nisada8en kitcibaiatigomikag!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mi pejig8an, Coda8inni kitci aiamie ogimag acitc Coda8inni kikinoamage8innig omanenima8abanin Jesosan acitc ki inidi8ag: “Kodagian a8iagon ogi pimadjian, 8in dac tibina8e ka8in okackitosin kidji pimadjiidizodj! ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Aa8e Kije Manidon ka pidjinijaogodjin, aa8edi Israel a8iagog odogimami8an, kada nisada8eban nogom otcibaiatigomikag. Kicpin dac 8abamagidj, nida teb8eta8anan.” Igi8e nenida8ina Jesosikag kagi iji acidak8a8agani8i8apan ke8ina8a okitci mamanazoma8abanin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","E abitakijigag, ki odji kacki tibikise mizi8e akikag, pinici kidji nisotibaiganeag e ick8a abitakijigag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Apitc ka nisotibaiganeanig, Jesos ki kitci pibagi: “Eloi! Eloi! Lema sabaktani?” mi ekidomagag: “Nikije Manidom! Nikije Manidom! 8egonen 8edji ki naganijian?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nandam iima ka te8apan ogi noda8a8an, acitc ki ikido8ag: “Ndotaok! Niganadjimo8inni Elin onad8e8eman.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Pejig ii e taci8adj ogi a8i kidagaminan ka opani8anig kasiigani cominabokag ka kitci 8isagagaminig, acitc ogi inak8aama8an Jesosan odonikag, mitigoni e abadjitodj, kidji minik8endjin. Ki ikido dac: “Keck! Kiga 8abadananan kicpin teb8e Eli ke apitci pijag8en kidji nisada8e8inigodjin tcibaiatigokag.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesos dac ki kitci pibagi, midac ka iji ick8anamodj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Coda8inni kitci aiamiemigi8amikag kitci kibigaigan abita ki tadose, icpimig pinici tcabacic. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Cimaganici ogima nigan Jesosikag e tajigaba8igobanen ogi 8abaman Jesosan adi ka iji nibondjin acitc ki ikido: “Aa8e nabe, teb8e mi aa Kije Manido Og8izisan!” ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nandam ik8e8ag ke8ina8a te8agoban iima, pagi 8asag e odji kana8abi8adj adi eji8ebanig. Mani Magdala iima tegoban, acitc ke8in kodag Mani, mi ini Jak (Jacques), 8in “Ka ocki pimadizidj” ka ijinikanagani8ipan ako, acitc Coses (Joses) odjodjomi8an, acitc dac Salome. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ogi nosone8a8agoban Jesosan meg8adj Galilee akikag ako ka paba ijanipanin, acitc o8idoka8a8agoban ako. Te8agoban acitc mane kodagiag ik8e8ag kagi pi nosone8a8agobanen Jesosan pinici Jerusalem odenag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tcibaiatigogijiganogoban ii apitc, apitc ako meg8adj e medoni mikidamo8agobanen kidji Coda8inni aiamie kijiganig. E ani onag8icinig dac, ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","pejig nabe ki odji tag8icinogoban, Josep ka ijinikazogobanen, Animati (Arimathée) odenag ka odjipan. Coda8inni kitci aiamie onakonige8innig iji acidagimagani8igoban, acitc kitci inenimagani8igoban. Ke8in opitonagoban Kije Manidon Odogima8i8ini. Ki sogidee dac kidji nda k8ag8edjimadjin Pilatan Jesosan o8ia8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilat ki kitci mamakadendam e nodagedj Jesosan aja egi nibondjin. Ogi nd8e8eman dac cimaganici ogiman acitc ogi k8ag8edjiman kicpin aja 8eckadj Jesosan ka apitci nibondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Aa dac cimaganici ogima ogi 8idama8an Pilatan teb8e egi nibondjin Jesosan. Pilat dac ogi pagidinan Josepan kidji madji8idondjin Jesosan o8ia8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josep ogi nda kicpinadon pejig 8abiskiginoni. Ogi nisakonan dac Jesosan o8ia8ini tcibaiatigokag, acitc ogi 8ik8eiginan 8abiskiginokag. Ogi nda naaton dac 8ibabikiniganikag kagi iji monaigadenig asinikag. Ogi taditibinan dac kitci asinin kidji kibaag 8ibabikinigani. ");
INSERT INTO alqALGNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mani Magdala acitc Mani, mi ini Coses odjodjoman, ogi 8abadana8a adi kagi iji naatcigadenigobanen Jesosan o8ia8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ka ick8a Coda8inni aiamie kijiganig, Mani Magdala, Mani, mi ini Jak (Jacques) odjodjoman, acitc Salome, ogi nda kicpinadona8a pimideni ka minomag8anig kidji ato8adj Jesosan o8ia8inikag. Mi ako e toda8agani8ipan a8iag e nibodj. ");
INSERT INTO alqALGNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","8ibadj e kijeba8acinig e manadjitagani8anig, apitc ka mokaamindjin kizison, ki ija8ag 8ibabikiniganikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","E ani inaado8adj, ki inidi8ag: “A8enen ke taditibinadjin kitci asinin ka odji pidigani8ag 8ibabikiniganikag?” ");
INSERT INTO alqALGNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Apitc ka inabi8adj, ogi 8abama8an ini kitci asinin opimena e abindjin aja egi taditibinagani8indjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ki pidige8ag dac 8ibabikiniganikag. Ogi 8abama8an pidigamig opimena okitciniki8akag pejig ockina8en e taji abindjin e 8abiginoondjin. Igi8e dac ik8e8ag ki kitci segizi8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Aa dac ockina8e ogi inan ik8e8an: “Ka8in segizikegon! Kinanada 8abama8a Jesos, Nazaret ka odjidj, 8in kagi acidak8a8agani8idj tcibaiatigokag. Ki abidjiba nibo8inikag! Ka8in aja ooma tesi. Inabiok! 8adan ooma ka iji asagani8ipan. ");
INSERT INTO alqALGNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","A8i 8idamaokog dac oo8eni Pien acitc kodagian Jesosan okikinoamaganan: ‘Kiga piigo8a Galilee akikag. 8edi dac kiga odji 8abama8a, tabickotc kagi ikidopan ab8amaci nibopan,’ ” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Igi dac ik8e8ag ki sagaamog 8ibabikiniganikag acitc ki ojimo8ag, e kitci ninigicka8adj acitc e kitci segizi8adj. Ka8in dac a8ian ododji 8idama8asi8a8an, epitci kotadji8agobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Apitc Jesos ka abidjibagobanen, 8ibadj e kijeba8acinig e manadjitagani8anig, ogi todan nitam kidji 8abamigogobanen Mani Magdalan. Mi ini ik8e8an Jesos kagi odji sagidjinija8agobanen nij8atcin madji manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mani dac ogi a8i 8idama8an kakina ini a8ian kagi paba 8idji8a8apanin ako Jesosan. Kitci kackendamobanig igi a8iagog acitc taji ma8ibanig. ");
INSERT INTO alqALGNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Apitc ka noda8a8adjin ini ik8e8an e ikidondjin Jesosan egi abidjibandjin acitc egi 8abamandjin, ka8in ododji teb8eta8asi8a8agoban. ");
INSERT INTO alqALGNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mina8adj dac Jesos ki pakanabaminagozi apitc ka todag kidji 8abamigodjin nijin okikinoamaganan e pimaadondjin, kitige8innin ako ka iji manendjin e pimi ijandjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Igi nijin nabeg ogi koki nda 8abama8an kodagian kikinoamaganan acitc ogi 8idama8a8an adi ka ijisenig. Midac kiabadj ka8in ododji teb8etagosi8a8agoban. ");
INSERT INTO alqALGNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kegapitc dac Jesos ogi todan kidji 8abamigodjin ka midatcin acitc pejigondjin okikinoamaganan meg8adj e taji 8isinindjin. Ogi kaganonan osa kitci nodesebanin teb8etamo8ini. Ki kitci cibictig8anebanig, ega 8i teb8eta8a8adjin ini a8ian kagi 8abamandjin Jesosan ka ick8a abidjibandjin. ");
INSERT INTO alqALGNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesos dac ogi inan: “Paba ijaok kakina mizi8ekamig, acitc paba tibadjimotaokog kakina a8iagog Kije Manidon omin8adjimo8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","A8enenigotc ke teb8etamog8en acitc ke sigaadazog8en kada ag8acimagani8i. A8enenigotc dac ega ke teb8etamog8en kada tibakonagani8i opatado8inan odji. ");
INSERT INTO alqALGNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Midac ono8e mamada8izi8inan ke kacki todamo8adjin igi8e ke teb8etamo8adj. Oga sagidjinija8a8an madji manidon ni8izoni e abadjito8adj. Kada pakanigij8e8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kicpin odapina8adjin kinebigon konigotc minik8e8adj pitcibo8ini ka8in kada nigodisi8ag. Oga samina8an a8iagon ka akozindjin, kada kige8an dac.” ");
INSERT INTO alqALGNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Apitc ka ick8a aiamiadjin Jesos ka Tibendjigedj okikinoamaganan, ki icpika 8ak8ig acitc ki nda abi Kije Manidon okitcinikinikag. ");
INSERT INTO alqALGNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Okikinoamaganan dac ki madja8an kidji paba tibadjimondjin Kije Manidon omin8adjimo8ini mizi8ekamig. Ka Tibendjigedj dac ogi 8idoka8an acitc ki 8abai8e e teb8emaganig okagik8e8ini8a, e minadjin kidji gi mamada8izindjin.");
INSERT INTO alqALGNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kin Teopil (Théophile) ka kitci apitendagozian kidojibiamon. Mane a8iagog ogi k8ag8e ojibiana8a adi ka pi iji8ebiziag nina8itinakag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ogi ojibiana8a ka pi iji kikinoamago8adjin ini8e ka pi 8abadamindjin ockadok kagi iji8ebanig, kagi anonagani8indjin kidji tibadjimondjin Kije Manidon omin8adjimo8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nogom dac 8e8enda nigi nanada8i kikendan kakina adi ka pi iji8ebag. Nigi inendan dac kada min8acinoban oo8e kidji ojibiamonan, ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","kidji gi ketcinamendaman kekin e teb8emagag ii kagi pi kikinoamago8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Meg8adj Herod e ogima8igobanen Coda (Judée) akikag, tegoban iima pejig Coda8inni aiamie ogima Zakani (Zacharie) e ijinikazogobanen, mi aa8e pejig igi8eni8ag Abiabanikag ka iji tibendagozi8adj, 8eckadj kagi aiamie ogima8igobanen. Sabet (Élisabeth) dac ijinikazonigoban Zakani okokomiman. Kitci aiamie ogima Eraniban (Aaron) iji odaiagiziban ke8in Sabet. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Eji niji8adj ok8aiak8abamigo8agoban Kije Manidon. Kitci 8e8enda onadotana8a8abanin kakina ka Tibendjigendjin odinakonige8inan acitc kakina adi kagi iji 8idamagendjin Kije Manidon kidji todjigadenig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Anic dac ka8in odabinodjijimisibanig, Sabet mega ki ijigigoban ega kidji aia8adjin abinodjijan, acitc aja kitci anicinabe8ibanig Sabet acitc Zakani. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nigodin Zakani otaji anokita8abanin Kije Manidon e aiamie ogima8idj. 8intami8a mega ijinag8aniban kidji aiamie8adj, igi8eni8ag Abiabanikag ka iji tibendagozi8adj, 8eckadj kagi aiamie ogima8igobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Aiamie ogimag 8ikobidjigadenibanin ako o8izoni8an pejig e taci8adj kidji pidigedj ka Tibendjigedj okitci aiamiemigi8amikag acitc ka minomatenig aiamie pig8ini kidji iji ick8azag. Ii dac apitc, Zakani ki onabamagani8igoban. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Meg8adj dac e ick8azamogobanen ka minomatenig aiamie pig8ini, kakina a8iagog kagi ma8adjiidi8apan ag8adjik aiamiebanig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zakani dac ogi 8abaman ka Tibendjigendjin pejig odajenimini, e tajigaba8indjin okitcinikikag ineke kitcit8a 8isini8aganikag taji ka iji ick8azigadenig ka minomatenig aiamie pig8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Apitc dac Zakani ka 8abamadjin, ki kitci kock8endam acitc ki kitci segizigoban. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ini dac ajenin ogi 8idamagon: “Zakani, ka8in segiziken. Kije Manido mega ogi nodan kidaiamie8ini. Sabet kikokomim oga nta8igian kig8izisan. John kiga ijinikana. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Maiagotc kiga kitci sogi min8endan, acitc mane a8iagog kada modjigendamog apitc nta8igindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Aa8e mega kig8izis oga kitci inenimigon ka Tibendjigendjin. Panima ega 8ikad kidji minik8edj cominaboni kek8an ka macka8agaminig. Mizi8ena oga pidigeckagon Mino Manidon teci8ag ki ick8a nta8igidj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Oga 8idjian mane Israel a8iagon kidji gi koki teb8eta8andjin ka Tibendjigendjin Okije Manidomi8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","8in nitam kada pi tibadjimo, ab8amaci tag8icinindjin ka Tibendjigendjin. Tabickotc 8eckadj niganadjimo8inni Eli kagi kitci macka8izidj e 8idjiigodjin Mino Manidon, mi pejig8an ke ijinagozidj kig8izis. Oga 8idjian naben kidji koki sagiandjin odabinodjijimini, acitc oga 8idjian ini8e ega ka ndota8andjin Kije Manidon kidji gi kagita8endamindjin, midac kidji k8aiak8adizindjin. Mi ke todag kig8izis, a8iagog kidji gi ick8ata8adj apitc pi tag8icinindjin ka Tibendjigendjin,” ki ikido8an ini ajenin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakani dac ogi inan ajenin: “Adi ke odji kikendaman ii8e teb8e kidji iji8ebag? Nin nikitci comisi8inan, acitc nikokomim ke8in aja kitci kokomi8i.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ajeni ogi nak8e8ajian: “Nin Gabriel, kabe nidanokita8a Kije Manido. Nigi pidjinijaog kidji aiamiinan acitc kidji pidamonan oo8e min8adjimo8in. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ndotan! Teb8e kada odjitcise kagi ininan kidji iji8ebag. Anic dac ka8in kidodji teb8etasinan nidikido8inan. Mi ke odji ega nta8ean, acitc ka8in kiga kackitosin kidji anim8ean pinici ini8e kegonan kidji iji8ebagin,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Meg8adj dac ii apitc, kakina a8iagog ag8adjik ka te8apan otaji pia8abanin Zakanin. Ki kitci mamakadendamobanig kitci kin8ej e tanedindjin pidigamig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Apitc ka sagaag, ka8in ododji kackitosinagoban kidji anim8edj. Ogi nisidotana8a dac egi ijinamindjin Zakanin pidigamig kitci aiamiemigi8amikag. Motci mamadjinikebaniobanin acitc ka8in nta8esibanin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Apitc Zakani ka ick8atadj egi mikimodj aiamiemigi8amikag, ki ki8e. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kegapitc okokomiman Sabetan ki kigicka8asonigoban. Nanokizis inigik ka8in odji sagaasi omigi8ami8akag aa8e Sabet. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ki ikido: “Ka Tibendjigedj nigi kitci kidimagenimig. Ka8in 8ikad mina8adj a8iagog kegoni nigagi odji igosig ega egi pi odabinodjijimi8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Apitc nigod8asokizis inigik Sabet e ani kigicka8adjin ini abinodjijan, Kije Manido ogi ijinija8an odajeniman, Gabriel ka ijinikazondjin, pejig odenakag Nazaret ka ijinikadenig Galilee akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ogi ijinija8an pejig ockinigik8ekag, Mani ka ijinikazondjin. Aja Mani ki inaco8anagani8igoban kidji 8idigemadjin pejig naben, Josep ka ijinikazonigobanen, ogima Davidiban odanike ojisan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Midac aa ajeni ki pidige adi eji tenipanin Manin acitc ogi inan: “Kidanamikon! Ka Tibendjigedj kigi kitci ca8enimig acitc ki8idjiog!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mani ki kitci kock8endam e nodag ii, acitc ki mamidonendam adi 8a ikidomaganig ajeni odanamikage8in. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ini dac ajenin ogi igon: “Mani, ka8in segiziken. Teb8e Kije Manido kica8enimig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Abinodjij kiga kigicka8a. Kiga og8izisinan, acitc dac Jesos kiga ijinikana. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kada kitci apitendagozi acitc Kije Manido ma8adji ka icpendagozidj Og8izisan kada ijinikanagani8i. Kije Manido ka Tibendjigedj oga minan kidji ogima8indjin tabickotc Davidiban, 8eckadj okitci anicinabembanin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kagige kada ogima8i Israel a8iagokag. Ka8in dac 8ikad kada poni ogima8isi,” ki ikido ajeni. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mani dac ogi inan ajenin: “Ka8in maci ni8idji tajikemasi nabe, adi dac kegi odji iji8ebizian iidi?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ajenin dac ogi nak8e8ajiigon: “Mino Manido kiga pidigeckag, acitc ma8adji ka icpendagozidj Kije Manido kiga minig omacka8izi8in. Mi ke odji kitcit8a8izidj aa abinodjij ke nta8igidj, acitc Kije Manido Og8izisan ke odji ijinikanagani8idj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ndotan! Kitcina8emagan Sabet ke8in kigicka8aso, ockina8esan opian. Aja kitci kokomi8i. Ikidonani8anoban ega 8ikad kidji odabinodjijimidj. Misa8adj dac, nogom aja nigod8asokizis8ezi8an e kigicka8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ka8in mega kegoni op8ana8itosin Kije Manido.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Misa Mani ki ikido: “Ka Tibendjigedj nidanokita8a. 8egona todaojidj Kije Manido ii ka ikido8an.” Midac ka iji naganigodjin ajenin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ka8in kin8ej ka ick8a 8abamadjin ajenin, Mani ki madja, kitci kijika e ijadj pejig odenakag, ka iji pik8adina8anig Coda (Judée) akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zakani omigi8amikag ki iji tag8icin, Sabet ocomisimikag. Ki pidige, acitc ogi anamika8an Sabetan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Apitc Sabet e nodag e anamikagodjin Manin, ki odji mamadji8an ka kigicka8adjin otcidjiciman. Sabet dac ogi pidigeckagon Mino Manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ogi inan dac Manin, e kitci kiji8edj: “Kakina e taci8adj ik8e8ag kin a8acamej Kije Manido kica8enimig, acitc oca8eniman ini abinodjijan ka kigickaomadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ka Tibenimijidj odjodjoman nipi odisig. Nikitci mina8azinan dac! ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Apitc ka nodaman e anamikaojian, abinodjij ka kigicka8ag ki odji mamadji epitci mina8azidj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kica8endagozinan! Kigi teb8etan ka ikidopan Kije Manido kidji iji8ebanig.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mani dac ki ikido: “Nidjitcagoc odicpeniman ka Tibendjigendjin, ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","acitc Kije Manido ka Ag8acimijidj niminig kidji kitci modjigendaman. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nigi mik8enimig mega, nin odanodaganik8eman ka tabasendizondjin. Apanigotc dac kakina a8iagog ke ani aianike nta8igi8adj kada ikido8ag egi kitci ca8enimijindjin Kije Manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kije Manido mega, 8in ma8adji ka macka8izidj, ka kitci mamakadendag8anigin kegonan ogi todanan nin odji. Kitcit8a8endag8ani o8izon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Apanigotc okije8anan kakina a8iagon ka manadjiigodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Odojitonan ka kitci mamakadendag8anigin kegonan kidji 8abadai8edj omacka8izi8in. Odobenija8an a8iagon ka kitci kitenimondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ota8ebicka8an kitci ogiman acitc odapitendagozian ini8e ka kidimagizindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kitci mane mino kegonan ominan a8iagon ka ka8askadendjin, acitc otoja8an ka kitci oconiamindjin ega kegonan kidji aiamindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","O8idoka8an Israel a8iagon, ka anokitagodjin. Ka8in odji 8anikesi apanigotc kidji mino toda8adjin Abanaaman (Abraham) acitc kakina odanike ojisini, mi mega ka inagobanen 8eckadj kikitci anicinabeminabanin.” Mi ka ikidodj Mani. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","8aiej nisokizis Mani ogi 8idji tajikeman Sabetan. Kegapitc dac ki koki ki8e. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Aja ijiseniban kidji nta8igindjin Sabet odabinodjijiman, ki og8izisi dac. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","A8iagog pecodj ka tajike8adj Sabetikag acitc otcina8emaganan ki nodage8an ka Tibendjigendjin egi kitci mino todagodjin, kakina dac ogi 8idji modjigendamoma8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Apitc ini abinodjijesan ka pejigota8ate8ezindjin, kakina mina8adj ki tag8icinog kidji pak8ej8agani8indjin. Onada8enima8abanin odadaman o8izoni “Zakani” kidji ijinikazondjin ini abinodjijan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","“Ka8in” dac ki ikido8an odjodjoman. “ ‘John’ kada ijinikazo.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ki inagani8i dac: “Ka8in a8iag iidi ijinikazosi kitcina8emaganikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ogi k8ag8edjima8abanin dac ka iji odadamindjin e mamadjinik8ebanio8adj, kidji kikendamo8adj adi 8a ijinikanadjin odabinodjijiman. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakani dac ki k8ag8ed8e kegoni kidji iji ojibiigedj acitc mi oo8e ka ojibiag: “ ‘John’ ijinikazo.” Midac kakina a8iagog ki kitci mamakadendamog. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Teci8ag dac Zakani ogi kackiton kidji koki anim8edj, acitc teci8ag ogi icpeniman Kije Manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kakina dac a8iagog pecodj ka tajike8adj ki kitci segizi8ag, acitc mizi8e ka iji pik8adina8anig Coda (Judée) akikag ki nodagani8ani adi ka pi iji8ebag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kakina a8iagog ka nodage8adj e ikidonani8anig ki mamidonendamog, acitc ki k8ag8ed8e8ag: “Adi ke ani iji8ebizidj aa abinodjij?” Ki paietenag8ani mega ka Tibendjigendjin omacka8izi8ini e 8idjiogodj aa8e abinodjij. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakani, aa abinodjij odadaman, Mino Manidon ogi pidigeckagon acitc ki niganadjimo oo8e: ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Icpenimik ka Tibendjigedj, mi aa Israel a8iagog Okije Manidomi8an. Ogi pi ag8aciman mega odanicinabeman. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kigi pidjinijaamagonan a8ian e kitci macka8izindjin kidji ag8aciminak. 8in odanodaganan kitci ogiman David, odaiagizi aa a8iag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Aja 8eckadj oo8e kagi pi tibadjimogobanen Kije Manido, e abadjiadjin okitcit8a niganadjimo8inniman. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Teb8e Kije Manido ki ikido kidji nagadjiigo8ak, ega kidji gi madji todago8ak igi8e ka 8i miganigo8ak acitc igi8e ka kitci madjenimigo8ak. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ki ikido kidji kidimagenimadjin 8eckadj kikitci anicinabeminabanin, acitc kidji mik8endag okitcit8a nakomo8in. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kije Manido teb8e ogi inan Abanaaman (Abraham), 8eckadj kikitci anicinabeminaban, ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kidji 8idjiinak, ega kidji madji todago8ak igi8e ka madjenimigo8ak, midac kidji gi anokita8aiak ega kidji tajinijiak, ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","midac kidji paiekideeiak acitc kidji k8aiakoziak inigik ke pimadiziak e anokita8aiak. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kin dac, nidabinodjijim, ‘Kije Manido ma8adji ka icpendagozidj oniganadjimo8inniman’ kiga ijinikanigo. Ab8amaci pi tag8icig ka Tibendjigedj, kin nitam kiga tibadjimonan, kidji 8idama8ad8a a8iagog kidji eco8i8adj kidji tag8icinindjin ka Tibendjigendjin, ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","acitc kidji 8idama8ad8a ka Tibendjigedj odanicinabeman kidji pi ag8acimadjin e kasiama8adjin opatado8ini8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kikije Manidominan mega kitci minodee acitc kitci kije8adizi. Kina8it odji Kije Manido 8edji ki pidjinijaag 8asea8ini 8ak8ig ka odjimaganig, tabickotc ako ka mokaag kizis ka ijinag8anig, ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","misa kidji 8aseanig a8iagog ka iji kacki tibikanig ka te8adj, ka kotamo8adj kidji nibo8adj, acitc kidji kikinoamaonak adi ke todamak kidji pimadiziak pekadendamo8inikag.” Mi ka ikidodj Zakani. ");
INSERT INTO alqALGNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Misa ki ani obigi aa abinodjij, acitc mane ogi ani nisidotan kegoni, eckam e ani kitci k8aiak8adizidj. Ki tajike pig8adakamigokag pinici kidji odjitcisenig kidji kikenimagani8ipan Israel a8iagokag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ii apitc Ogost (Auguste) ma8adji kitci ogima8iban kakina akin Rom odenakag ka iji tibendag8anigin. Ki onakonige dac kakina a8ian odakikag ka tajikendjin kidji agimagani8indjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mi ii enag e todjigadegiban. Ii apitc, Kirinios (Quirinius) ogima8iban Siria (Syrie) akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kakina dac a8iagog ki nda ojibiodizo8ag. Kakina pepejig ki ija8ag ii odenani kagi odjindjin 8eckadj okitci anicinabemi8abanin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep dac, Nazaret odenakag 8edi Galilee akikag ki odji madja, Betleem (Bethléem) odenag Coda (Judée) akikag e ijadj. Mi ii 8eckadj ogima David ododenam. David mega odanike ojisan ini Josepan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josep dac ki nda ojibiodizo. Mani ogi 8idji8an, 8in kagi inaco8anagani8igobanen Josepikag kidji iji niba8idj. Mani aja kigicka8asogoban. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Meg8adj Betleem e te8agobanen, ki odjitciseni kidji madapinedj Mani kidji nta8igindjin odabinodjijiman. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ki og8izisi dac, mi ini nitam odabinodjijiman. Ogi 8ik8enan 8abo8anikag acitc adiko8isini8aganikag ogi iji pimakociman, ka8in mega ta8atesinogoban nibe8igi8amikag kidji iji tajike8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Pecodj Betleem odenag, te8agoban a8iagog ka kana8enima8adjin omantcenicimi8an. Meg8a tibik dac onagadjia8agoban omantcenicimi8an odaki8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kije Manido pejig odajeniman ki pi odji nagozi8an, acitc Kije Manido odicpendagozi8in ogi 8aseasigona8a igi a8iagog. Ki kitci segizi8ag dac. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Aa dac ajeni ogi inan: “Ka8in segizikegon. Kipi 8idamonom min8adjimo8in, kakina a8iagog kidji kitci modjigendamo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nogom ka onag8icig David ododenamikag, pejig a8iag ki pi nta8igi ke ag8acimadjin a8iagon. Mi aa Kije Manidon ka ikidonigobanen kidji pidjinijaogodjin, mi aa ka Tibendjigedj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ke odji nisida8ina8eg dac, kiga mika8a8a tcidjic 8abo8anikag e iji 8ik8enagani8idj. Adiko8isini8aganikag dac kada iji pimicin,” ki ikido ajeni. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kitata ki pi odji nagozi8ag kitci mane kodagiag ajenig, e icpenima8adjin Kije Manidon, e ikido8adj oo8e: ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Icpenimadan Kije Manido icpimig 8ak8ig ka tedj! Oga minan opekadendamo8in kakina a8iagon mizi8ekamig ka min8endamiigodjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Apitc ajenig 8ak8ig ka koki ki8e8agobanen, igi8e a8iagog ka kana8enima8adjin mantcenican ki inidi8ag: “Ijadan 8edi Betleem odenag. Kida nda inabimin adi ka iji8ebag, ka Tibendjigedj kagi iji kikendamoninak.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kitci 8e8ibit8a8agoban dac kidji madja8adj. Ogi mika8a8an dac Manin acitc Josepan, acitc ogi 8abama8an ini tcidjican e pimicinindjin adiko8isini8aganikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Apitc dac ka 8abama8adjin ini tcidjican, ki tibadjimo8agoban adi ajenin kagi inadjimotago8agobanen e mikomandjin ini abinodjijan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kakina a8iagog ka noda8a8agobanen adi kagi ikidondjin ki kitci mamakadendamog. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mani dac omamik8endanagoban adi ka pi iji8ebanig, acitc kin8ej ogi taji mamidonendanagoban. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Igi8e ka kana8enima8adjin mantcenican ki koki ki8e8ag. Ogi kitcit8a8ina8an Kije Manidon acitc ogi icpenima8an, kakina kagi iji nodamo8adj acitc kagi iji 8abadamo8adj odji. Mi mega kakina ka iji8ebanig kagi iji tibadjimogobanen ajeni. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ka nianeniogonaganig ka ick8a nta8igigobanen aa tcidjic, ki odjitciseni kidji pak8ej8agani8idj. Ki 8inagani8i dac, “Jesos” e ijinikanagani8idj, mi mega kagi ikidogobanen ajeni, ab8amaci Mani kigicka8asopan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kegapitc odjitciseban Josep acitc Mani kidji ijitcige8adj adi Mois kagi inakonigedj kidji ani paiekideeiendagozinani8anig egi nta8igindjin tcidjican. Midac ka iji iji8ina8adjin Jesosan Jerusalemikag kidji nda mina8adjin ka Tibendjigendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kije Manido Omazinaiganikag mega mazinadeni ii inakonige8ini: “Kicpin pejig ik8e nitam aia8adjin abinodjijan e ockina8esi8indjin, Kije Manidokag kada iji tibendagozi aa ockina8es.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Jesos dac onigiigon ogi nda pagidinigetama8a8an ka Tibendjigendjin, kidji todamo8adj ka ikidomaganig odinakonige8ini: “Kiga pagidinigetama8a nijin omimin ka 8abizindjin kek8an nijin omimisesan,” ki ikidomagani mazinaigani. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ii apitc Jerusalemikag pejig nabe tegoban, Simian (Siméon) e ijinikazogobanen. Aa nabe kitci k8aiak8adizigoban acitc okitci manadjiabanin Kije Manidon. Okitci piabanin ini8e Kije Manidon kagi ikidondjin kidji pidjinija8andjin, Israel a8iagog kidji gi ag8acimagani8i8adj. Mino Manidon okigickagobanin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ogi igobanin dac Mino Manidon kidji 8abamadjin ab8amaci kidji nibodj ini8e ka Tibendjigendjin kagi ikidonipanin kidji pidjinija8andjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Simian ogi iji8inigon Mino Manidon Coda8inni kitci aiamiemigi8amikag. Aa8e dac abinodjij Jesos ogi pi pidige8inigon onigiigon, 8in odji kidji todamindjin adi enazinadenig inakonige8ini kidji todamindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simian dac ogi odapinan Jesosan, acitc ogi icpeniman Kije Manidon e ikidodj: ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ka Tibendjigedj! Nogom aja ka ijiaban ki iji8eban. Aja kidanodagan kadagi nibo e pekadendag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nigi 8abama mega aa8e kagi pidjinija8adj kidji ag8acimi8edj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Kakina ka inakanezi8adj a8iagog oga 8abadana8a egi pidjinija8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mi aa8e 8asea8in mizi8ekamig a8iagog ke odji kikenimik8a. Oga todan kidji kitci inenimagani8indjin kidanicinabeman Israel a8iagon,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jesos odadaman acitc odjodjoman ki kitci mamakadendamobanin adi Simianan ekidonipanin e mikomandjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simian dac ogi inagoban Jesosan acitc onigiigoni: “Kije Manido kiga ca8enimigo8a.” Ogi inan dac Manin: “Teb8e Kije Manido ogi onabaman ono8e abinodjijan mane Israel a8iagog kidji odji ag8acimagani8i8adj acitc mane kidji odji 8anicino8adj. Kada 8abadai8e ka iji nda8endamindjin Kije Manidon, mane dac a8iagon oga madji mikomigon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kegonan dac ka kimodji inendamo8adj kada mokimagani8an. Kin dac, Mani, kiga kitci kackendan kideikag.” Mi ka ikidodj Simian. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Iima tegoban acitc pejig niganadjimo8innik8e, Anne e ijinikazogobanen. Panio8el (Phanuel) ini odanisan Anne, acitc Aserikag odaiagiziban. Aja kitci kokomi8igoban. Nij8asopibon ogi 8idji tajikemabanin o8idigemaganan egi iji niba8ipan meg8adj e ockinigik8e8igobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ki nibobanin dac o8idigemagan, midac ki motci pejigo. Aja dac nianeniomidana acitc niopibon8eziban. Pijicig dac tajikegoban Coda8inni kitci aiamiemigi8amikag. Meg8a tibik acitc meg8a kijik ogi manadjiabanin Kije Manidon, e aiamiepan acitc e pagidadjigepan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Meg8adj dac Simian e taji anim8egobanen, maia ii apitc ke8in ki pi tag8icinogoban aa ik8e. Mig8etc dac ogi inan Kije Manidon, ogi mikoman dac ini8e abinodjijan, e aiamiadjin kakina a8iagon ka pia8adjin Kije Manidon kidji 8ack8ebidondjin Jerusalemini ka iji madjisenig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Apitc Jesos onigiigon ka ick8a todamindjin kakina kegoni kagi mazinadenig ka Tibendjigedj odinakonige8inikag, ki koki ki8e8an ka iji tajikendjin, Nazaret odenakag, Galilee akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jesos dac ki ani obigiban acitc ki ani macka8iziban. Ki ani kagita8endamogoban acitc Kije Manidon ogi kitci min8abamigobanin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Taso pibon ako, Jesos onigiigon ijanigoban Jerusalemikag, Coda8inni Kitci Magocan e ijandjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Apitc Jesos ka midatcin acitc nijopibon8ezigobanen, ogi 8idji8an onigiigon, mi mega ako e todjigadenigiban. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Apitc ka ick8a magocani8anig, ki koki ki8e8an onigiigon, Jesos dac 8in ki tajike Jerusalemikag. Ka8in dac ododji kikenimigosin onigiigon Jesos egi tajikegobanen 8edi. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Inendamo8agoban mi ke8in pemidedj meg8adj e pimodani8anig acitc kabe kijik ki pimose8agoban. Midac ogi nanada 8abama8an o8idji8agani8akag acitc ka iji otcina8emagani8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ka8in dac ododji mika8asi8a8an. Ki koki ija8ag dac Jerusalemikag kidji nanada 8abama8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Aja nijokajik o8ania8abanin. Midac kegapitc mina8adj e ani kijiganig ogi mika8a8an pidigamig Coda8inni kitci aiamiemigi8amikag, e taji abinigobanen nena8idj Coda8inni kikinoamage8innikag. Otaji ndota8abanin acitc ok8ag8edjimabanin kegonan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kakina a8iagog kagi noda8a8adjin Jesosan ogi kitci mamakazita8a8an e kitci omidonendjiganindjin acitc adi e iji nak8e8ajii8endjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Apitc Jesos onigiigon ka 8abamigodjin, ki kitci mamakadendamon. Odjodjoman dac ogi igon: “Nig8izis! 8egonen 8edji ki todaojiag ii? Kidadam acitc nin nigi kitci segizimin e nanada 8abamigo8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesos dac ogi nak8e8ajian: “8egonen dac 8edji ki nanada 8abamijieg? Kana kikikendasina8a panima Nidadam omigi8amikag kidji teian?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ka8in dac ododji nisidota8asi8a8abanin adi 8a igo8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jesos dac ogi ki8e 8idji8an onigiigon Nazaretikag, acitc ogi ndota8an adi egodjin. Odjodjoman dac ki kitci mamik8endamobanin adi kagi iji8ebanig kakina kegoni. ");
INSERT INTO alqALGNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesos dac eckam ki ani madjigiban acitc eckam ki ani kagita8endamogoban. Kije Manidon acitc kakina a8iagon omin8enimigobanin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Aja midatcin acitc nanopibon inigik ma8adji e kitci ogima8ipan aa Tipirias (Tibère). Iima dac Coda (Judée) akikag, Pons Pilat (Ponce Pilate) kitci ogima8iban. Iima Galilee akikag, Herod (Hérode) kitci ogima8iban. Pilip (Philippe), Herod o8idjiki8en, Itoria (Iturée) acitc Tarakonitis (Trachonite) akikag iji kitci ogima8ibanin. Iima Abilin (Abilène) akikag, Lisanias (Lysanias) kitci ogima8iban. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annas (Anne) acitc Kaiapas (Caïphe) aiamie ogima8ibanig ma8adji ka niganizi8adj. Mi ii apitc Cabadis (Jean-Baptiste), Zakani (Zacharie) og8izisan, ka odisigodjin Kije Manidon odikido8inan meg8adj pig8adakamigokag ka tegobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Cabadis dac ki paba ijagoban mizi8ena 8ajagam Jourdain sibini. Paba kagik8egoban oo8e: “An8endizok acitc sigaadazok. Midac Kije Manido kiga kasiamago8a kipatado8ini8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Mi ka ijisenig adi niganadjimo8inni Isaia kagi iji ojibiamogobanen omazinaiganikag: “A8iag kada tag8icin kidji pabibagidj pig8adakamigokag. Mi oo8eni ke ikidodj: Eco8iok kidji tag8icig ka Tibendjigedj. Ojitamaok e k8aiakojimonig mikanani. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kakina pasadinan kada tabida8ise8an acitc kakina pik8adinan acitc pik8adinajican kada tabida8ise8an. Kakina mikanan ka 8agackijimogin kada k8aiakojimonon. Kakina aianodj ka inijimogin kada minojimonon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Midac kakina ka taci8adj a8iagog oga 8abadana8a adi Kije Manidon eji ag8acimigo8adjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kitci mane a8iagon ogi pi nda 8abamigobanin Cabadis, kidji gi sigaada8adjin. Ogi inan dac: “Kina8a madji a8iagog! Tabickotc ka pitcibo8inezi8adj kinebigog kidijinagozim! A8enen kagi kikinoamago8eg kidji kackito8eg kidji ojidameg Kije Manido otibakonige8in ke pijamaganig? ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kicpin teb8e an8endizo8eg, kidinendagozim kidji 8abadjigadeg e mino ijitcigeieg. Ka8in inendakegon: ‘Ka8in kiga tibakonigosimin, Abanaamikag (Abraham) mega kidiji kitci odadamimin.’ Ceck8at iidi kidinendana8a! Ki8idamonom kidji kijigabameg8a igi asinig. Kije Manido ogagi meckodjian ini asinin Abanaam okitci anike ojisan kidji gi ijinagozindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Aja ick8a tacaigade ozidak kidji kicka8agani8i8adj mitigog ka odji 8adadabigicino8adj. A8enatigigotc ega mino minatigo8idj kada kicka8agani8i acitc kada madjocte8ebinagani8i.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Igi8e dac a8iagog ogi k8ag8edjima8abanin: “Adi dac kegi todamagiban?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Cabadis dac ogi nak8e8ajian: “Aa ka aiagin nijin pizika8aganan, pejig oda minan ini8e ega ka opizika8aganindjin, acitc aa ka aiag midjimini, mi pejig8an ke todagiban.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nandam ka ma8adjia8adjin conian kitci ogiman odji, ke8ina8a ogi pi nda 8abama8an kidji sigaadago8adjin acitc ogi k8ag8edjima8an: “Kikinoamage8inni! Adi kegi todamagiban?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ogi nak8e8ajian: “Ka8in a8acamej k8ag8ed8ekegon conia inigik ka iji inakonigo8eg kidji k8ag8ed8eieg.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Midac ke8ina8a nandam cimaganicag ogi k8ag8edjima8an: “Nina8it dac, adi kegi todamagiban?” Ogi nak8e8ajian: “Ka8in kimodimakegon a8iagog oconiami8an, acitc ka8in 8aiejimakegonig a8iagog kidji aia8eg oconiami8an. Mi iji min8endamok adi e taso conia8eieg.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","A8iagog nagazi8agoban kidji tag8icinindjin ini8e Kije Manidon kagi ikidonipanin kidji pidjinija8andjin. Kakina dac inendamo8agoban: “Mi ne8ad aa Cabadis Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Cabadis dac ogi inan: “Nin nibikag kidiji sigaadaonom. Anic dac pejig a8iag nage kada pi tag8icin, na8adj kitci macka8izi apitc8in nin. Ka8in tibise nidapitendagozisi kidji abiskobida8agin omakizinan. 8in dac Mino Manidokag acitc ickodekag kiga iji sigaadago8a. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Mi maia tabickotc a8iag ka ick8atadj kidji kizi8adjin anominan ejinagozidj. Oga papa8ibanian kidji managodenig ega ka iji minozindjin. Oga ma8adjian dac anominan, otatasonigi8amikag oga iji naasan. Oga ick8azanan dac ega ka min8acinigin kegonan ickodekag ega 8ikad ka ata8enig.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Cabadis mane kodag kegonan ogi mikodanan e kagik8edj, min8adjimo8ini e tibadjimota8adjin a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Cabadis ogi kaganonabanin kitci ogiman Herod. Herod mega ki iji niba8igoban o8idjiki8en o8idigemagani, Herodiad ka ijinikazonigobanen, acitc kitci mane kodag madji kegonan ki iji panaagegoban. Mi Cabadis 8edji ki kaganonapanin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Misa Herod ani8ag ki panaage, ogi kiba8an Cabadisan kibaodimigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Apitc ka taji sigaadazo8adj kakina a8iagog, ke8in Jesos ki sigaadazo. Meg8adj e taji aiamiegobanen Jesos, 8ak8ig ki ceseni, ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","acitc Mino Manidon ki pi najise8an 8agidj 8inikag, mi maia omimi ka 8abizidj ejinagozindjin ini Mino Manidon. Midac a8iag 8ak8ig ki odji anim8e: “Kin Nig8izis ka kitci sagiinan. Kikitci min8endamiijinan.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","8aiej nisomidana8e pibon8ezigoban Jesos apitc ka madji kikinoamagegobanen. Inenimagani8iban teb8e ini Josep og8izisan. Mi oo8e 8edaiagizipan Josep: Eli (Héli) ini og8izisibanin Josepan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matat (Matthat) ini og8izisibanin Elin. Lepi (Lévi) ini og8izisibanin Matatan. Melki (Melchi) ini og8izisibanin Lepin. Janai (Jannaï) ini og8izisibanin Melkin. Josep ini og8izisibanin Janain. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatias (Matthatias) ini og8izisibanin Josepan. Amos ini og8izisibanin Matatiasan. Neam (Nahum) ini og8izisibanin Amosan. Esli ini og8izisibanin Neaman. Nagai (Naggaï) ini og8izisibanin Eslin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maat (Maath) ini og8izisibanin Nagain. Matatias (Matthatias) ini og8izisibanin Maatan. Semein (Séméin) ini og8izisibanin Matatiasan. Josek (Josech) ini og8izisibanin Semeinan. Joda ini og8izisibanin Josekan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joanan ini og8izisibanin Jodan. Resa (Rhésa) ini og8izisibanin Joananan. Zorobabel ini og8izisibanin Resan. Salatiel ini og8izisibanin Zorobabelan. Neri ini og8izisibanin Salatielan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melki ini og8izisibanin Nerin. Addi ini og8izisibanin Melkin. Kosam ini og8izisibanin Addin. Elmadam ini og8izisibanin Kosaman. Er ini og8izisibanin Elmadaman. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Jesos ini og8izisibanin Eran. Eliezer ini og8izisibanin Jesosan. Jorim ini og8izisibanin Eliezeran. Matat (Matthat) ini og8izisibanin Joriman. Lepi (Lévi) ini og8izisibanin Matatan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simian (Siméon) ini og8izisibanin Lepin. Coda (Juda) ini og8izisibanin Simianan. Josep ini og8izisibanin Codan. Jonam ini og8izisibanin Josepan. Eliakim ini og8izisibanin Jonaman. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Melea ini og8izisibanin Eliakiman. Menna ini og8izisibanin Melean. Matata (Matthata) ini og8izisibanin Mennan. Natan (Nathan) ini og8izisibanin Matatan. David ini og8izisibanin Natanan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jesse ini og8izisibanin Davidan. Obed ini og8izisibanin Jessen. Booz ini og8izisibanin Obedan. Sala ini og8izisibanin Boozan. Naasson ini og8izisibanin Salan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadab ini og8izisibanin Naassonan. Admin ini og8izisibanin Aminadaban. Arni ini og8izisibanin Adminan. Esrom ini og8izisibanin Arnin. Peres (Pharès) ini og8izisibanin Esroman. Coda (Juda) ini og8izisibanin Peresan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Tcekap (Jacob) ini og8izisibanin Codan. Aisik (Isaac) ini og8izisibanin Tcekapan. Abanaam (Abraham) ini og8izisibanin Aisikan. Tara (Thara) ini og8izisibanin Abanaam. Nakor (Nachor) ini og8izisibanin Taran. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serok (Seruch) ini og8izisibanin Nakoran. Ragao (Ragau) ini og8izisibanin Serokan. Peleg (Phalek) ini og8izisibanin Ragaon. Eber ini og8izisibanin Pelegan. Sala ini og8izisibanin Eberan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kainam ini og8izisibanin Salan. Anapaksad (Arphaxad) ini og8izisibanin Kainaman. Sem ini og8izisibanin Anapaksad. No8a (Noé) ini og8izisibanin Seman. Lamek ini og8izisibanin No8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Matosala (Mathusala) ini og8izisibanin Lamekan. Enok (Hénok) ini og8izisibanin Matosalan. Jared ini og8izisibanin Enokan. Maleleiel (Maléléel) ini og8izisibanin Jaredan. Kainan ini og8izisibanin Maleleielan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enos ini og8izisibanin Kainanan. Set (Seth) ini og8izisibanin Enosan. Adam ini og8izisibanin Setan. Kije Manido dac ini og8izisibanin Adaman. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesos Jourdain sibikag ki odji madja, Mino Manidon e kigickagodjin. Ogi iji8inigon Mino Manidon ka iji pig8adakamiganig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Iima dac kitci madji manidon ogi k8ag8e 8agackibinigon, nimidana (40) tasogon inigik. Ii apitc ka8in kegoni ododji midjisin Jesos. Apitc dac ka ick8a nimidana tasogonaganig, ki odji 8i 8isinigoban. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kitci madji manidon dac ogi igon: “Kicpin Kije Manido Og8izisan aiaa8ian, iji aa asini kidji ani pak8ejigani8idj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesos dac ogi nak8e8ajian: “Mazinadeni oo8e Kije Manido Omazinaiganikag: ‘Ka8in pak8ejiganan eta kadagi odji pimadjiosi a8iag.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Mina8adj dac kitci madji manido 8agidadin ogi iji8inan Jesosan. Kaiezigotc dac ogi 8abadaan kakina ogima8i8inan ooma akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Midac ogi inan: “Kiga minin kakina macka8izi8inan acitc kakina 8anadizi8inan iima ogima8i8inikag ka iji tag8agin. Kakina mega ini nigi minigo acitc dac nigagi mina ini a8enenigotc 8a minag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kicpin dac nibak8itaojian kidji icpenimijian, kakina kiga tibendanan ini.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesos dac ogi nak8e8ajian: “Mazinadeni oo8e Kije Manido Omazinaiganikag: ‘Kiga icpenima8a ka Tibendjigedj Kikije Manidomi8a, acitc 8in eta kiga anokita8a8a.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Mina8adj dac kitci madji manido ogi iji8inan Jerusalem odenakag. 8agidj dac Coda8inni kitci aiamiemigi8amikag ogi iji 8agidasan Jesosan. Ogi inan dac: “Ack8e sa pinig8ackonin, kicpin Kije Manido Og8izisan aiaa8ian. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Mazinadeni mega oo8e Kije Manido Omazinaiganikag: ‘Oga anonan odajeniman kidji nagadjiik8a.’ ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kiabadj dac mazinadeni: ‘Kiga midjiminigog dac, ega 8a8adj kidji 8isagizidecinian asinikag,’ mazinadeni,” ki ikido aa madji manido. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesos dac ogi nak8e8ajian: “Mazinadeni acitc Kije Manido Omazinaiganikag: ‘Ka8in k8ag8e kadjinija8akegon ka Tibendjigedj Kikije Manidomi8a kidji abadjitodj omacka8izi8in.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ka ick8a kitci k8ag8edjitodj kidji 8agackibinadjin Jesosan, kitci madji manido ogi naganan, pinici kidji odjitcisenig mina8adj kidji gi k8ag8edjitodj kidji 8agackibinadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesos dac Galilee akikag ki koki ki8egoban. Mino Manidon omacka8izi8ini okigickanagoban, acitc mizi8e iima akikag ki mikomagani8i. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kitci mane Coda8innig odaiamiemigi8ami8akag ki iji kikinoamagegoban, acitc kakina a8ian omin8adjimigobanin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kegapitc Jesos Nazaret ki tag8icinogoban, taji ka odji obigidj. E aiamie kijiganig, ki pidige Coda8inni aiamiemigi8amikag ka nta todagiban ako. Ki pazig8i, acitc nigan a8iagokag ki ija kidji nda nabo8adjigedj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Midac ki minagani8i niganadjimo8inni Isaia omazinaigani ka tidibanakosinig. Ogi abiskonan ii ka tidibanakosinig mazinaigani, midac ogi mikan oo8eni ka iji mazinadenig: ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Nigi minig ka Tibendjigedj Omino Manidoman. Nigi onabamig kidji tibadjimota8ag8a ka kidimagizi8adj min8adjimo8ini. Nigi pidjinijaog kidji tibadjimota8ag8a ka takonagani8i8adj aja kidji pagidinagani8i8adj, acitc ega ka 8abi8adj aja kidji koki 8abi8adj. Nigi pidjinijaog kidji 8idjiag8a ka madji toda8agani8i8adj, ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","acitc kidji tibadjimo8an oo8e: Aja odjitciseni ka Tibendjigedj kidji ca8enimadjin odanicinabeman.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Midac Jesos ogi koki tidibanakonan ii mazinaigani, ogi koki minan aiamiemigi8ami anodaganan, mina8adj dac ki abi. Kakina a8iagog ka te8apan iima Coda8inni aiamiemigi8amikag okitci kijigabama8an Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jesos dac ogi inan: “Ini ikido8inan ka mazinadegin Isaia omazinaiganikag, nogom ogajigag ki iji8eban maiagotc apitc ka nodaojieg e nabo8adamanin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kakina a8iagog okitci min8enima8abanin, pekic okitci mamakadenima8abanin e kitci minotagozindjin. Ikido8agoban: “Kana mi 8aa Josep og8izisan?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesos dac ogi 8idama8an: “Ketcinadj kiga 8idamaojim oo8e ikido8in ka ikidonani8ag ako: ‘Mackiki8inni, kin tibina8e kigeidizon.’ Acitc kiga k8ag8edjimijim kidji mamada8izian ooma nin tibina8e nidodenamikag, tabickotc kagi iji nodageieg ka inakamigiziaban 8edi Kaponaom (Capernaüm) odenag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Teb8e ki8idamonom, ka8in 8ikad niganadjimo8inni ndota8agani8isi odenakag kagi odji nta8igidj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ki8idamonom, tabickotc 8eckadj, ki kitci mane8agoban ka pejigo8adj ik8e8ag Israel akikag meg8adj Eli e pimadizigobanen. Ii dac apitc, nisopibon acitc abita inigik ka8in odji kimi8asinon, acitc ki kitci pakadani8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ka8in dac Kije Manido ododji ijinija8asin Elin kidji nda 8idjiandjin ini8e ik8e8an Israel akikag ka tajikenigobanen, tiegodj 8edi Sidon akikag ogi ijinija8an kidji nda 8idjiandjin pejig ik8e8an, Sarepta odenakag ka tajikenigobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Acitc dac ki kitci mane8agoban ka omigi8apine8apan Israel akikag meg8adj e pimadizigobanen niganadjimo8inni Ilaica (Elisée). Ka8in dac pejig e taci8adj odji kigeagani8isi, mi eta 8aa Siria (Syrie) akikag ka odjipan, Naaman ka ijinikazopan,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kakina a8iagog iima Coda8inni aiamiemigi8amikag ki kitci kiji8azi8agoban apitc ka noda8a8adjin ka ikidondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ki pazigodjise8agoban, acitc ag8adjik odenag ogi nda a8i sagidji8ebina8an Jesosan. 8edi ka iji kitci kickanabikanig pecodj ododenami8akag ogi iji8ina8an kidji k8ag8e kadji8ebina8adjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Anic Jesos nena8idj 8ina8akag ki motci pimosegoban, midac ka iji madjadj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Mina8adj Kaponaom (Capernaüm) odenag Jesos ki ijagoban, Galilee akikag. E Coda8inni aiamie kijiganig ogi kikinoama8an a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ki kitci mamakadendamon adi ka iji kikinoamagedj. Apitc mega e anim8egobanen, kikenimagani8iban ako e kitci macka8izidj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Teban iima Coda8inni aiamiemigi8amikag pejig nabe e kigickagodjin madji manidon. Ki kitci pabibagi oo8eni: ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“8egonen neda8endaman nina8itinakag, Jesos Nazareti8inni? Kigi pi nda nici8anadjiijinam na? Kikikenimin, kin ka kitcit8a8izian, Kije Manido kagi pidjinijaogo8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesos ogi kitci kaganonan ini8e madji manidon acitc ogi inan oo8eni: “Ponimon! Sagaan 8inikag!” Meg8adj kakina a8iagon e kijigabamigodjin, aa madji manido ogi kitci ka8ak8e8ebinan motcikag ini naben, acitc ega e 8isagendamiadjin ki odji sagaam o8ia8inikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kakina a8iagog ki kitci mamakadendamobanig acitc ki inidi8agoban: “Adi 8edji kackitodj kidji iji anim8edj? Kitci macka8izi aa nabe kidji kanonadjin madji manidon, midac ka iji sagaamindjin!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Acitc mizi8ena iima akikag Jesos ki mikomagani8i. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kegapitc Jesos ogi nagadan ii8e Coda8inni aiamiemigi8amini, midac Simon omigi8aminikag ka iji ijagobanen. Simo ozigosan kitci kijizo8apinebanin, ki k8ag8edjimagani8i dac Jesos kidji kigeadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesos dac ogi nda 8abaman ini ik8e8an. E kitci sogitagozidj ogi madjinijaan ii kitci kijizo8apine8ini iima ik8ekag, midac ka iji poni kijizondjin. Teci8ag dac ki pazig8i aa ik8e, acitc ki madjita kidji mikimodj kidji acamadjin kakina a8ian. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Apitc e ani pagicimonig, kakina a8iagog ka kana8enima8adjin ka akozindjin aianodjigotc ka ainapinendjin ogi iji8ina8an Jesosikag. Jesos dac pepejig ogi saminan acitc ogi kigean. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mane madji manidog ki sagidjinija8agani8i8ag a8iagog ka kigickago8adjin, e pabibagi8adj: “Kin Kije Manido Og8izisan!” Jesos dac ogi kaganonan ini8e madji manidon, acitc ka8in ododji pagidinasi8an kidji anim8endjin, okikenimigobanin mega 8in aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","8ibadj mina8adj e kijeba8acinig, apitc e ani mokaag kizis, Jesos ogi nagadan ii odenani acitc ega ka iji tani8anig ki ijagoban. Kitci mane dac a8iagon ogi paba nanada 8abamigon. Apitc ka mika8a8adjin, ogi k8ag8e cagozoma8an ega kidji naganigo8adjin mina8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesos dac ogi inan: “Kodagian odenan panima acitc ki paba tibadjimo8an min8adjimo8in, e mikodaman Kije Manido Odogima8i8in. Mi mega 8edji ki pidjinijaojidj ooma.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ki paba kagik8egoban dac pepakan Coda8inni aiamiemigi8amikag iima Coda (Judée) akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nigodin Jesos tcigagam tajigaba8igoban Jenesaret (Génésareth) sagaiganikag. Kitci mane a8iagon 8ajagam 8inikag tenigoban e kakadji8ebickodadinipanin e 8i ndotamindjin Kije Manidon odikido8inan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesos ogi 8abadanan nijin tcimanan tcigagam. Kigozike8innig ogi nagadana8agoban iima, kidji gi kizisibana8adjin odasabi8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesos ki poziban pejig ii e nijinigin tcimanan, Simo otibendanaban ii tcimani. Jesos dac ogi k8ag8edjiman Simon pagi na8idj kidji inak8aji8endjin. Jesos dac ki abi pidonag acitc ogi kikinoama8an kakina a8iagon iima ka tendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Apitc ka ick8a kikinoamagedj, ogi inan Simon: “Na8idj inak8aji8en iima ka iji kickai8ag. Kin acitc ki8idji8aganag, pakobiokog kidasabi8ag, kigozag dac kada pidaamog.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simo ogi nak8e8ajian: “Kikinoamage8inni! Kabe tibik nigi kitci mikimomin ega kegon e nto8ag. Anic dac e 8idamaojian, kiabadj niga pakobi8ag nidasabimag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Midac ka iji pakobi8a8adjin odasabimi8an, acitc kegat ki ani papakickozo8an, epitci kitci manendjin kigozan e pidaamindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ogi 8actaama8a8an dac ini8e ka 8idji mikimoma8adjin, kodag tcimanikag ka tendjin, kidji pi nda 8idjiigo8adjin. Midac ka iji pijandjin, acitc ki mama8i mikimo8ag acitc ogi kicponatona8an midjinijin tcimanan. Kegat ki kozabickozo8ag, ka apitci kitci manendjin okigozimi8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Apitc Simo Pien ka 8abadag ejisenig, ogi nibak8ita8agoban Jesosan acitc ogi inan: “Tebendjigean! Ka8in pec8abamijiken, nipatado8inni8inan mega.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kitci kock8endamogoban mega, tabickotc kakina o8idji8aganan, ka apitci kitci manendjin kigozan kagi pidaamindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ini8e ka 8idji mikimomadjin Simo, mi ini nijin Zebedee og8izisan, Jak acitc John ka ijinikazondjin, ke8ina8a ki kock8endamo8agoban. Jesos dac ogi inan Simon: “Ka8in segiziken. Pinici ogajigag kigozag pijicig kigi pi na8adjibinag, nogom dac aja a8iagog kiga pidji8inag ninikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Midac ka iji mijagaamo8adj. Ogi 8ikobidona8an otcimani8an tcigagam. Kakina kegonan ogi nagadana8an, midac midjinisin ka iji nosone8a8adjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kegapitc Jesos ki ijagoban pejig odenani. Iima dac pejig nabe tajikegoban e kitci omigi8apinepan, kitci kotadendag8anoban ako ii inapine8in. Apitc ka 8abamadjin Jesosan, ogi pi nibak8ita8an acitc ogi pagoseniman e ikidodj: “Tebendjigean! Kicpin iji nda8endaman, kikackiton kidji kigeijian.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesos ki tesindjita, acitc ogi saminan, e inadjin: “Kinada8enimin kidji kigean! Kigen sa dac.” Teci8ag odakozi8in ogi pagidinigon aa nabe acitc ki kige. ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesos dac ogi inan: “Ka8in a8iag 8idama8aken egi kigeinan. Anic dac nda 8abadai Coda8inni aiamie ogima adi ejinagozian nogom, acitc migi8en ii pagidinige8ini Mois kagi inakonigedj kidji todjigadenig. Mi kidji gi teb8etamo8adj kakina a8iagog egi kigean.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Misa8adj dac eckam eckam Jesos ki kitci ani mikomagani8i. Kitci mane a8iagon onazikagobanin kidji ndotagodjin acitc kidji kigeadjin adi eji akozindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesos dac pig8adakamigokag ijagoban ako 8in eta, kidji nda aiamiedj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nigodin meg8adj Jesos e taji kikinoamagedj, nandam Coda8innig ka nagadjito8agobanen inakonige8inan acitc Coda8inni kikinoamage8innig ke8ina8a abi8agoban iima, kakinagotc odenan egi pi 8aodji8agobanen Galilee akikag acitc Coda (Judée) akikag acitc dac Jerusalem odenakag. Ka Tibendjigendjin omacka8izi8ini ki minagani8i Jesos, kidji gi kigeadjin a8iagon ka akozindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ii apitc, nandam a8iagog ki odji tag8icino8agoban, e pimi8ina8adjin tesiniganikag pejig naben ega e mazikandjin. Ogi k8ag8e pidige8ina8abanin migi8amikag, nigan Jesosikag kidji iji asa8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ka8in dac okackitosina8aban kidji pidige8ina8apanin, epitci kitci manenani8anigobanen. 8agidabak8an dac ogi ik8ada8e8ina8an, acitc ogi pagonebak8eana8a kidji gi odji nisabikena8adjin, otesiniganikag e iji pimakocinigobanen, acitc nigan Jesosikag ogi iji asa8an, ka iji manenani8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Apitc Jesos 8eabamadjin ini a8iagon kagi pidji8inandjin ini naben adi epitci sogi teb8etamindjin, ogi inan ini8e ega ka mazikandjin: “Ni8idji8agan! Aja ki kasiigade8an kipatado8inan.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Coda8inni kikinoamage8innig acitc Coda8innig ka nagadjito8agobanen inakonige8inan ki inendamo8agoban: “A8enen dac aa nabe? Omanazoman Kije Manidon! Ka8in a8iag tesi e kackitodj kidji kasiamagedj patado8inan, Kije Manido eta okackiton.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesos okikendanagoban adi enendaminigobanen acitc ogi inan: “8egonen 8edji inendameg ii? ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Na8adj na 8edandok kidji inag: ‘Aja ki kasiigade8an kipatado8inan,’ kek8an: ‘8anickan acitc pimosen’ kidji inag? ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kinada8eniminom mega kidji kikendameg Aa8e ka pi Anicinabe8iidizodj e kackitodj kidji kasiamagedj patado8ini ooma 8akidakamig,” ki ikido. Ogi inan dac ini8e ega ka mazikandjin: “Ki8idamon, 8anickan, odapinan kitesinigan, acitc ki8en kimigi8amikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Meg8adj dac kakina a8iagon e kana8abamigogobanen, teci8ag ki 8anicka aa nabe. Ogi odapinan otesinigan ka iji pimakocinogobanen, acitc ki ki8e, e icpenimadjin Kije Manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kakina dac a8iagog ki kitci mamakadendamog. Ke8ina8a ogi icpenima8an Kije Manidon acitc ki kitci segizi8ag. Ikido8agoban dac: “Ogajigag kigi 8abadananan ka kitci mamakazinag8agin kegonan.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kegapitc Jesos ki sagaam, acitc ogi odji 8abaman pejig naben ka ma8adjiandjin conian kitci ogiman odji, Lepi ijinikazogoban aa. Odojibiige8igi8amikag iji abigoban. Jesos dac ogi inan: “Nosoneocin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lepi dac ki pazig8i, ogi nagadan kakina kegoni acitc ogi nosone8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kegapitc Lepi ki kitci magocanike omigi8amikag Jesosan odji. Kitci mane8agoban kodagiag ka ma8adjia8adjin conian kitci ogiman odji acitc kodagiag a8iagog e magoce8apan iima ke8ina8a. ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Coda8innig dac ka nagadjito8agobanen inakonige8inan acitc Coda8inni kikinoamage8innig ka iji o8idji8agani8adj ka8in odji min8endasi8ag. Odina8abanin Jesosan okikinoamaganan: “8egonen 8edji 8idji minik8emeg8a acitc 8idji 8isinimeg8a igi8e ka ma8adjia8adjin conian kitci ogiman odji acitc igi8e ka madji inadizi8adj?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesos dac ogi nak8e8ajian: “A8iagog ka mino pimadizi8adj ka8in onada8enimasi8a8an mackiki8innin, mi eta ka akozi8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ka8in nidodji pijasi kidji nd8e8emag8a ka kitci k8aiak8enimidizo8adj a8iagog, tiegodj nigi pija kidji nd8e8emag8a ka patadi8adj, kidji gi an8endizo8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ogi ina8an dac Jesosan: “Cabadis okikinoamaganan mojag pagidadjige8an acitc aiamie8an, acitc mi ke8ina8a Coda8innig ka nagadjito8adjin inakonige8inan okikinoamagani8an. Anic dac kin kikikinoamaganag ka8in mana 8isinisi8ag acitc ka8in mana minik8esi8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesos dac ogi nak8e8ajian: “Kidinendana8a na enendagozi8adj kidji pagidadjige8adj igi8e kagi nd8e8emagani8i8adj e niba8inani8anig, meg8adj ini naben ka niba8indjin e 8idji8a8adjin? Ketcinadj ka8in ii ijisesinon! ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kegapitc dac kada odjitcise panima kidji madjadj aa ka niba8idj. Midac pidjinag ke pagidadjige8adj ka nd8e8emagani8i8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Mina8adj dac Jesos ogi 8idama8an oo8e adisokani kidji kikinoama8adjin: “Ka8in a8iag oga tadobidosin ocki kegojicini kidji agoctaag kete kegojicikag. Kicpin dac iidi todjigadegiban, ocki kegojic ki tadobidjigadeg, ka8in dac kada naisisinoban kete kegojicikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Acitc dac ka8in a8iag kete nibi8ajikag ka pack8egino8agin odiji siginasin ocki cominaboni. Kicpin mega iidi todag, kada pakodjisemaganon ini nibi8ajan ka pack8egino8agin, ocki cominabo kagi iji siginigadeg. Motcikag dac kada inajiga8in, acitc mi eck8a abadagin ini nibi8ajan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ka8in 8in iidi! Panima ocki pack8egino nibi8ajikag ki iji siginigadeg ocki cominabo. ");
INSERT INTO alqALGNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Anic dac ka8in a8iag onada8endasin ocki cominaboni apitc ick8a kodjipidag ka keteagaminig cominaboni. Kada ikido mega: ‘Na8adj min8agamin kete cominabo.’ ” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nigodin meg8adj e Coda8inni aiamie kijiganig, Jesos acitc okikinoamaganan opimi cabocta8eckana8agoban ka iji kitigani8anig anominan. Kikinoamaganag dac oma8adjia8agoban nandam anominan. Ogi cacagona8an onidji8akag, midac ka iji am8a8apanin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nandam Coda8innig ka nagadjito8agobanen inakonige8inan ogi 8abamigo8an e todamo8adj ii, acitc ogi ina8an: “8egonen 8edji ma8adjieg8a anominag meg8adj e aiamie kijigag? Ikidomaganon kidinakonige8inanan ega e inendagozieg kidji todameg iidi.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesos dac ogi nak8e8ajian: “Kana 8ikad kidodji nabo8adasina8a Kije Manido Omazinaiganikag adi ka todamogobanen ogima David? Nigodin ki mamida8askade8agoban 8in acitc o8idji8aganan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David dac ki pidigegoban Kije Manidon odaiamiemigi8aminikag. Ogi odapinan pak8ejiganan, Kije Manidon kagi ca8enimagani8indjin. Ogi am8agoban ini pak8ejiganan acitc ogi minagoban o8idji8aganan. Kidinakonige8inanan ikidomaganon Coda8inni aiamie ogimag eta kidji am8a8adjin ini pak8ejiganan.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesos mina8adj ogi inan: “Nin dac, Ka pi Anicinabe8iidizodj, nitibendan ii ka Coda8inni aiamie kijigag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kodag mina8adj e Coda8inni aiamie kijiganig, Jesos ki pidigegoban Coda8inni aiamiemigi8amikag, midac iima ka iji kikinoamagedj. Pejig nabe iima tegoban ega e mazikanig onidji okitcinikikag inekena. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nandam dac Coda8inni kikinoamage8innig acitc Coda8innig ka nagadjito8agobanen inakonige8inan kitci 8e8enda okijigabama8agoban Jesosan, kidji gi 8abama8adjin kicpin ke apitci kigeag8enin ini naben e aiamie kijiganig. O8i katcidina8abanin mega kidji pitci panaagendjin meg8adj e Coda8inni aiamie kijiganig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesos dac ogi kikendanaban adi enendamindjin. Ogi inan dac ini naben ega ka mazikanig onidjini: “Pazig8in iima, kakina a8iagog kidji gi 8abamik8a.” Misa dac ka inakamigizidj aa nabe. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesos dac ogi inan Coda8innin: “Kik8ag8edjiminom oo8e. Adi maia enakonigemagagin kidinakonige8inanan? Ikidomaganon na kidji mino toda8aiak a8iag meg8adj e Coda8inni aiamie kijigag, kek8an kidji madji toda8aiak? Inakonigemaganon na kidji 8idoka8aiak a8iag kidji gi kana8endag opimadizi8in, kek8an kidji nici8anadjita8aiak opimadizi8in?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ogi kana8abaman kakina a8iagon, acitc ogi inan ini naben: “Pi ijindjitan.” Midac ka todag, acitc teci8ag k8aiak ki koki mikimomagani onidji. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Igi Coda8innig ki kitci nickadizi8ag. Midac kimodj ka iji mikodamo8adj adi kegi toda8a8apanin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nigodin Jesos pik8adinajicikag ki ijagoban e nda aiamiedj. Kabe tibik dac ogi taji aiamita8an Kije Manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","8iabanig, ogi nd8e8eman okikinoamaganan acitc ogi onabaman midatcin acitc nijin e tacindjin kidji Odanodagani8agedj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Mi ono8e ka onabamadjin: Simo, Jesos ka adjinikanadjin, Pien e ijinikanadjin, acitc Andre, 8in Simo o8idjiki8en, Jak (Jacques), John, Pilip (Philippe), Batelemi (Barthélemy), ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matio (Matthieu), Tomas (Thomas), Jak, 8in Alpi (Alphée) og8izisan, Simo, 8in ka acidagimagani8igobanen taji ka iji ma8asag8akonidindjin ega ka nda8endaminigobanen kidji tibenimigo8adjin ogiman Rom ka odjindjin, ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, 8in Jak og8izisan, acitc Judas Iskaniot (Iscariote), 8in nage ka mamijimadjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesos acitc okikinoamaganan ki pi pinazi8e8ag pik8adinajicikag acitc ki kibisika8ag ka iji tabida8akamiganig. Mane ka nosone8a8adjin Jesosan opia8abanin iima, acitc kitci manebanig a8iagog kakinagotc e odose8agobanen. Nandam Coda (Judée) akikag odose8agoban, nandam Jerusalem odenag, acitc nandam Tir (Tyr) odenag acitc Sidon odenag pecodj kitcigamikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ogi pi ndota8a8abanin Jesosan acitc pagosendamobanig kidji kigeagani8i8adj. Igi8e ka kigickago8adjin madji manidon ki kige8ag ke8ina8a. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kakina a8iagog o8i k8ag8e tagina8abanin Jesosan, kitci macka8izi8ini mega odaianagoban kidji gi kigeadjin a8iagon, acitc kakina ki kigeagani8i8agoban. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesos ogi kijigabaman okikinoamaganan acitc ki ikido: “Kica8endagozim, kina8a ka kidimagizieg, Kije Manido mega Odogima8i8inikag kidiji tibendagozim. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kica8endagozim kina8a nogom ka ka8askadeieg, kiga tebickonom mega. Kica8endagozim kina8a nogom ka ma8ieg, kiga papim mega.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Kica8endagozim apitc a8iagog madjenimigo8eg, madjinijaogo8eg, manazomigo8eg, acitc madji a8iagog enenimigo8eg, e nosone8eg aa Ka pi Anicinabe8iidizodj odji. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Modjigendamok apitc ii iji8ebag, acitc k8ak8ackoniok ke apitci min8endameg. Teb8e mega Kije Manido kiga kitci ca8enimigo8a 8ak8ig. Igi a8iagog ka madjenimigo8eg, okitci anicinabemi8abanin mi maia pejig8an 8eckadj ka toda8a8adjin niganadjimo8innin e kitci madjenima8apanin, tabickotc nogom kina8a ka todago8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Anic dac kiga madji iji8ebizim, kina8a ka kitci oconiamieg, aja mega kijadj kigi mina8azim. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kiga madji iji8ebizim, kina8a nogom ka tebickono8eg, kiga ka8askadem mega. Kiga madji iji8ebizim kina8a nogom ka papieg, kiga madjendana8a mega acitc kiga ma8im.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Kiga madji iji8ebizim apitc kakina a8iagog mino mikomigo8eg, pejig8an ako ka todamo8agobanen 8eckadj okitci anicinabemi8abanin igi a8iagog, e mino mikoma8apanin ako niganadjimo8innin ka kagina8ickindjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Kina8a dac ka ndotaojieg, ki8idamonom oo8e. Sagiikog ka madjenimigo8eg acitc mino todaokog. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pagosenimik Kije Manido kidji mino iji8ebizi8adj igi8e ka nda8enimigo8eg kidji madji iji8ebizieg, acitc aiamietamaokog igi8e ka manenimigo8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kicpin a8iag pasabaok, pagidin k8ekinekena acitc kidji iji pasabaok. Kicpin a8iag kimodimik kipizika8agani, mi iji mij acitc kipabagi8ani. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kicpin a8iag k8ag8edjimik kegoni, mi iji mij. Kicpin a8iag makamik kidaiman, ka8in koki ndodama8aken. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mi maia pejig8an iji mino todaokog kodagiag a8iagog adi kina8a eji nda8endameg kidji iji mino todago8eg.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kicpin sagieg8a eta igi8e ka sagiigo8eg, ka8in ii kitci kegon. 8a8adj igi8e ega ka ndota8a8adjin Kije Manidon osagia8an ka sagiigo8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kicpin mino toda8eg8a eta igi8e ka mino todago8eg, ka8in ii kitci kegon. 8a8adj igi8e ega ka ndota8a8adjin Kije Manidon mi iidi e todamo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kicpin conian a8iieg8a eta igi8e ka ketcinamendameg kidji koki ki8e minigo8eg, ka8in ii kitci kegon. 8a8adj igi8e ega ka ndota8a8adjin Kije Manidon oda8ia8an conian kodagian ega ka ndota8andjin Kije Manidon, kicpin inendamo8adj kidji koki ki8e minigo8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tiegodj, sagiikog igi8e ka madjenimigo8eg. 8e8enda mino todaokog acitc a8ii8eg ega mamakadj kidji ki8e minigo8eg. Kiga kitci ca8endagozim, acitc ka kitci icpendagozidj Kije Manido odabinodjijiman kiga ijinagozim. Kakina mega a8ian Kije Manido omino toda8an, misa8adj ini8e ega mig8etc ka ikidondjin acitc ini8e ka madji inakamigizindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kije8adiziok dac, tabickotc Kije Manido Kidadami8a ka apitci kije8adizidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ka8in onenimakegon a8iag, ka8in dac Kije Manido kiga tibakonigosi8a. Ka8in inactaonakegon a8iag egi panaagedj, ka8in dac Kije Manido kiga inactaonigosi8a. Ponenimik adi ka iji madji todago8eg kodag a8iag, kiga kasiamago8a dac Kije Manido ka iji patadieg. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mijikog ka nodese8adj, midac Kije Manido kiga minigo8a ka nodeseieg. Kitci mane kiga minigo8a. Ka8in 8a8adj kiga kackitosina8a kakina kidji odapinameg, ke apitci kitci mane minigo8eg Kije Manido. Inigik ka mineg8a kodag a8iagog, Kije Manido kiga koki minigo8a.” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesos kiabadj ki adisoke e kikinoamagedj: “A8iag ega ka 8abidj ka8in okackitosin kidji kikino8inadjin e 8idji pimosemadjin kodagian ega ka 8abindjin, kana? Midjinijin mega kada podazig8egodjinog ka iji 8anakamiganig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Aa ka kikinoamazodj ka8in na8adj apitendagozisi apitc8in ini8e ka kikinoamagodjin. Anic dac ick8a kikinoamazodj, mi maia pejig8an okikinoamage8inniman ke apitendagozidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“8egonen 8edji kitci kana8abadam8adj kidjiki8e e pizinidj minigonacini, kin dac 8in ka8in kipabiziskendasin mitigoc e pizinian? ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Adi dac kegi odji ikido8aban: ‘Nidjiki8e! Ack8e niga manibidon ii ka pizinian’? Kin mega ka8in 8a8adj ki8abadasin mitigoc ka pizinian. Kikitci kimodizinan! Panima ki manibido8an ii mitigoc kagi pizinian, kidji gi 8abian kicpin 8i manibida8adj kidjiki8e ka pizinidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kitci minogini8an ominiman ka minozidj minatig, acitc ka8in minogisini8an ominiman minatig ega minozidj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kakina pepejig minatig odji nisida8inagozi adi ejinag8anigin ominiman. Ka8in a8iag oga mikasinan minan azadikag, acitc ka8in a8iag kada ma8izosi kibisatigokag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mino a8iag ododinan odeikag men8acinig kegoni osa mega minodee, madji a8iag dac ododinan madji kegoni osa mega madjidee. 8abadai8e dac a8iag ejideedj adi enitagozidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Adi 8edji kackito8eg kidji ijinikanijieg ‘Tebendjigean!’ ega ijitcigeieg ka iji 8idamonagok? ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kiga 8idamonom adi ejinagozidj aa8e ka pi nazikaojidj, e ndotagin nidikido8inan acitc e nosoneagin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Aa a8iag mi maia tabickotc nabe 8e8enda kagi migi8amikedj ejinagozidj. 8asag ki monaidjicki8aige acitc asinikag ogi iji sakakisidon omigi8am. Apitc dac ka mockaanig sibini, ka8in odji mazikasini omigi8am osa ki kitci sogakisini. ");
INSERT INTO alqALGNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Aa dac a8iag ka ndotagin nidikido8inan, ega dac nosoneagin, tabickotc nabe nega8ikag kagi iji migi8amikedj ijinagozi, ka8in dac sogakisisini. Apitc dac ka mockaanig sibini, ki mazikani omigi8am acitc teci8ag ki pagisini acitc ki ick8a abadani.” Mi ka inadisokedj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Apitc Jesos ka ick8a anim8edj, Kaponaom (Capernaüm) odenag ki ija. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Iima dac pejig cimaganici ogima ega ka Coda8inni8idj odaia8abanin pejig odanodaganan e kitci apitenimadjin. Akozibanin ini odanodaganan acitc kegat aja nibobanin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Apitc ka nodagedj e mikomagani8indjin Jesosan, aa cimaganici ogima ogi ijinija8an nandam Coda8innin ka niganizindjin kidji nda k8ag8edjimandjin Jesosan kidji gi pijandjin kidji gi pi nda kigeandjin odanodaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ogi nda 8abama8an dac Jesosan, acitc ogi kitci pagosenima8an e ikido8adj: “Aa8e cimaganici ogima teb8e inendagozi kidji 8idjiadj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Misa8adj ega e Coda8inni8idj, kikitci sagiigonan kina8it ka Coda8inni8iak, acitc 8in kagi ojitodj Coda8inni aiamiemigi8amini ooma.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesos dac ogi 8idji8an. Apitc e ani pec8abadamogobanen migi8amini, aa cimaganici ogima ogi ijinija8an o8idji8aganan kidji 8idamagendjin oo8eni: “Tebendjigean! Ka8in mamakadj kidagi pijasi. Ka8in mega tibise nidapitendagozisi kidji gi pi pidigean nimigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Acitc ka8in tibise nidapitendagozisi kidji gi pi nazikaonan nin tibina8e nidinendan. Anic pejig eta kegon ikidon, misa dac kidji kigedj nidanodagan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kenin mega nidaia8a pejig nikackam, acitc nidaia8ag cimaganicag e kackakanag8a. Pejig aa8e nidina kidji ijadj 8edi, mi eji ijadj. Kodag aa8e nidina kidji pijadj, mi eji pijadj. Acitc nidanodagan nidanona: ‘Ijitan oo8e,’ misa eji ijitadj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Apitc Jesos ka nodag ii, ogi kitci mamakazita8an. Ki k8ekigaba8i acitc ogi inan a8iagon kagi nosoneogodjin: “Teb8e ki8idamonom, ka8in 8ikad nidodji mika8asi pejig a8iag epitci sogi teb8etag tabickotc aa8e nabe. 8a8adj Israel a8iagokag ka8in nidodji mika8asi a8iag epitci teb8etag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Cimaganici ogima omigi8amikag ki koki pidige8ag igi8e ka ijinija8agani8i8apan. Ogi 8abama8an dac e kitci mino pimadizindjin ini8e anodaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kegapitc Jesos Nen (Naïn) odenag ki ijagoban. Okikinoamaganan o8idjiogobanin acitc kitci mane kodagian a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Apitc e ani pec8abadamo8agobanen ick8ademan iima odenani, pejig a8iag egi nibogobanen 8ibabikiniganikag iji8idjigadenigoban o8ia8. Aa8e kagi nibodj 8in eta pejig8abe8igoban, acitc odjodjoman ogi 8anianigoban o8idigemagani. Kitci mane a8iagog iima odenakag ka tajike8agobanen o8idji8a8agoban ini ik8e8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Apitc ka Tibendjigedj ka 8abamadjin ini ik8e8an, ogi kitci kidimageniman acitc ogi inan: “Ka8in ma8iken!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jesos dac ogi nazika8an acitc ogi taginan ii8e mitigo8ajini, acitc ka pimi8ido8adj mitigo8ajini ki kibitcigaba8i8ag. Ki ikido dac: “Ockina8e, 8anickan kidinin!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Aa ka nibodj ki abi acitc ki madji aianim8e. Jesos dac ogi inan ini ik8e8an: “Mi 8aa kig8izis.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kakina a8iagog ki kitci kotadji8ag. Kije Manidon ogi kitci icpenima8an, oo8eni e ikido8adj: “Kitci niganadjimo8inni kina8itinakag ki tag8icin. Teb8e Kije Manido ogi pi 8idjian odanicinabeman.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Midac mizi8e Coda (Judée) aki acitc 8ajagam akijican ki iji paba mikodjigade adi Jesos ka inakamigizigobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Cabadis okikinoamaganan ogi tibadjimotagon kakina kagi iji8ebanig. Cabadis dac ogi nd8e8eman nijin ii e tacindjin okikinoamaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ogi ijinija8an dac kidji nda 8abama8adjin Jesosan, kidji nda k8ag8edjima8adjin: “Kin na aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin? Kek8an kodag panima niga pianan?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Apitc dac ka nazika8a8adjin igi nabeg Jesosan, ogi ina8an: “Cabadis nigi pidjinijaogonan kidji pi nda k8ag8edjimigo8an oo8e. Kin na aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin? Kek8an kodag a8iag panima niga pianan?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Meg8adj ii apitc, mane a8iagon Jesos ogi kigeabanin ka akozinipanin, acitc ka kodagitonipanin, acitc ka kigickagonipanin madji manidon, acitc o8abiabanin mane a8iagon ega ka 8abinipanin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Midac Jesos ogi nak8e8ajian Cabadisan okikinoamagani: “Nda tatibadjimotaok Cabadis adi ka iji 8abadameg acitc ka iji nodameg. Ega ka 8abi8apan aja 8abi8ag, ega ka mazika8apan aja pimose8ag, ka omigi8apine8apan aja kige8ag, ega ka ozite8apan aja ozite8ag, ka nibo8apan koki pimadizi8ag, acitc ka kidimagizi8adj aja 8idama8agani8i8ag Kije Manidon omin8adjimo8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ca8endagozi aa a8iag ega ke ana8enimijidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Apitc ka ick8a madjandjin ini8e Cabadis kagi pidjinija8adjin, Jesos ogi mikoman Cabadisan a8iagokag e ikidodj: “Apitc ka ijaieg pig8adakamigokag, a8enen kagi a8i nda 8abameg? Kidinendana8aban na kidji 8abameg a8iag e kitci cagozidj, tabickotc nibic ka kitci mamadji8ebasag e nodinig e ijinagozidj? Ka8in sa iidi! ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","A8enen dac kagi a8i nda 8abameg? Kigi a8i nda 8abama8a na a8iag e kitci minokonaedj? Ki8idamonom, ka kitci minokonae8adj acitc mane ka kitci min8acinigin kegonan ka aiamo8adjin, kitci ogiman omigi8aminikag iji tajike8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","A8enen dac kagi a8i nda 8abameg? Niganadjimo8inni na kagi a8i nda 8abameg? Ee, mi iidi! Ki8idamonom, Cabadis na8adj apitendagozi apitc8in niganadjimo8inni. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Cabadis dac 8in, mi 8aa Kije Manidon Omazinaiganikag ka mikomagani8idj, oo8e e mazinadenig: ‘Kije Manido ikido: Niniganinija8a aa8e ke tibadjimodj nidikido8ini, kidji nigani ojitamaok kimikanani adi ke aniijaian.’ Mi mezinadenig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ki8idamonom, ka8in a8iag tesi ooma akikag na8adj e kitci apitendagozidj apitc8in Cabadis. Pekic dac aa8e ma8adji ka tabasendagozidj Kije Manidon Odogima8i8inikag, na8adj apitendagozi apitc8in Cabadis.” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kakina a8iagog kagi noda8a8agobanen, 8a8adj igi8e ka ma8adjia8adjin conian kitci ogiman odji, kakina odinendana8aban: “Kitci k8aiakozi Kije Manido.” Aja mega kaiet ogi sigaadago8agoban Cabadisan igi8e a8iagog. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Igi8e dac Coda8innig ka nagadjito8agobanen inakonige8inan acitc Coda8inni kikinoamage8innig ogi 8ebinana8aban Kije Manidon ka iji nda8enimigo8adjin kidji todamo8adj, ka8in dac ododji nda8enimasi8a8abanin Cabadisan kidji sigaadago8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesos kiabadj ki ikido: “A8enen kegi iji tibaageiaban a8iagog nogom ka pimadizi8adj ejinagozi8adj? Adi maia ejinagozi8adj? ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mi maia tabickotc abinodjijag ka odamino8adj ejinagozi8adj, pepakan ka taji okogaba8i8adj ka iji ada8ani8anig, acitc ka pabibagimidi8adj oo8eni: ‘Nigi nodag8atcigemin, ka8in dac kidodji nimisim. Mina8adj dac nibo8ini nigamo8inan nigi nigamomin, kiabadj dac ka8in kidodji ma8isim.’ ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Midac pejig8an, apitc ka tag8icig Cabadis e pi nda kagik8edj, ka8in ododji am8asi8agoban pak8ejiganan acitc ka8in odji minik8esigoban cominaboni. Kigi ikidona8aban dac e kigickagogobanen madji manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nin dac, Ka pi Anicinabe8iidizodj, apitc ka tag8icinian kidji pi nda kagik8eian, ka8in nidodji mana 8isinisi acitc ka8in nidodji mana minik8esi. Midac kiabadj ka iji ikido8eg: ‘Kana8abamik aa nabe! Mi eta kidji 8isinidj acitc kidji minik8edj cominaboni eji mika8idj. Omino 8idji8an ini8e ka ma8adjiandjin conian kitci ogiman odji, acitc ini8e ka madji inadizindjin,’ kigi ikidona8aban. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Igi8e dac kagi odisigo8adj Kije Manidon okagita8endamo8ini, okikendana8a e k8aiak8anig.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pejig e taci8adj Coda8innig ka nagadjito8agobanen inakonige8inan ogi nd8e8eman Jesosan kidji pi nda 8idji 8isinimigodjin. Jesos dac ki ija ini naben omigi8aminikag, midac ki onabi kidji 8isinidj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Teban iima odenakag pejig ik8e e madji ik8e8idj. Ka nodagedj aa ik8e Jesosan e nda 8isinindjin iima naben omigi8aminikag, ogi iji8idon e kitci min8acinig modaiabikoni e kicponebinig ka minomag8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ki nibak8i dac Jesosan ozidinikag, iji odakanag ineke. Taji ma8iban acitc mi ka iji ani nibi8itodjin Jesosan ozidini e najiga8abidj, mina8adj ogi kasianan o8ina8anisisan e abadjitodjin. Midac ogi odjidanan, acitc ogi minomag8atonan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Apitc aa Coda8inni ka nagadjitogobanen inakonige8inan kagi nd8e8emapanin Jesosan ka 8abadag ii, ki inendam: “Kicpin aa nabe maia niganadjimo8inni8ipan, oda kikeniman e madji inadizindjin ka saminigodjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesos ogi inan ini naben: “Simo! Kegon ki8i 8idamon.” Simo ogi nak8e8ajian: “Kikinoamage8inni! 8idamaocin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesos dac ogi 8idama8an: “Nigodin nijin nabeg omazinaama8a8abanin pejig a8ian. Pejig nano midasomidana8abik mazinaamageban, kodag dac nanomidana8abik. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ega dac e kackito8agobanen kidji kijikazo8adj, ‘ka8in mamakadj koki kijikazokegon’ ogi igo8an ini ka mazinaama8a8apanin. A8enen dac aa e niji8adj na8adj ke sagiadjin?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simo ogi nak8e8ajian: “Nidinendan aa8e na8adj mane kagi a8iazodj.” Jesos ogi inan: “Kiteb8e.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Mina8adj dac ogi kana8abaman ini ik8e8an acitc ogi inan Simon: “Ki8abama na aa ik8e? Ka pidigeian kimigi8amikag, ka8in nibi kidodji minijisi kidji kizisibadjizideian. 8in dac, nigi kizisibadjizidenig e najiga8abidj, acitc ogi kasianan o8ina8anisisan e abadjitodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kin, ka8in kidodji odjimijisi ka tag8icinian. 8in dac, ka8in ododji poni odjidasinan nizidan ka ako pidigeian. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ka8in 8e8enda kidodji todaojisi adi enendagozian kidji todaojian, ka8in kidodji siginamaojisi pimide nictig8anikag. 8in dac, nizidikag ogi siginan ka minomag8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ki8idamon dac, kakina opatado8inan ki kasiama8agani8i, misa8adj e manenigin. Midac 8edji 8abadai8edj e kitci sagiijidj. Aa dac pagi eta opatado8inan ka kasiama8agani8idj, pagi eta kada 8abadai8e e sagiijidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jesos dac ogi inan ini ik8e8an: “Aja kasiigade8an kipatado8inan.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ini dac ka 8idji 8isinimadjin ki inendamon: “A8enen aa nabe ka kasiagin patado8inan?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesos dac ogi inan ini ik8e8an: “Kiteb8etamo8in kigi ag8acimigon. Ki8en dac acitc min8endan.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kegapitc Jesos paba ijagoban mane odenakag acitc odenajicikag. Paba kagik8egoban min8adjimo8ini ka tibadjimomaganig Kije Manidon Odogima8i8ini. Ka midatcin acitc nijindjin okikinoamaganan opaba 8idjiogobanin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nandam ik8e8ag egi kigeagani8i8apan ka inapine8adj acitc egi odji sagidjinija8agani8indjin madji manidon ka kigickago8apanin, ke8ina8a opaba 8idjiogobanin. Pejig dac ii e taci8adj ik8e8ag, Mani Magdala ijinikazogoban, 8inikag ki odji sagidjinijaomagani8ibanin ka nij8atcinipanin madji manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Pejig kodag dac Jo8ana (Jeanne) ijinikazogoban, mi aa Kosa (Chuza) okokomiman. Kosa dac omikidanaban ogiman Herod omigi8amini. Pejig kodag ik8e Sosan (Suzanne) ijinikazogoban. Mane kodagiag ik8e8ag ke8ina8a opaba 8idji8a8agoban Jesosan. Igi8e ik8e8ag odabadjia8abanin 8ina8a tibina8e oconiami8an kidji 8idoka8a8adjin Jesosan acitc okikinoamaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kakinagotc odenan e aodji8adj a8iagog ogi pi nazika8a8abanin Jesosan. Kitci manebanig igi a8iagog e ma8adjiidi8adj, Jesos dac ki adisoke e kikinoamagedj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Ki ikido oo8e: “Nigodin pejig kitige8inni ki nda kitigegoban. Meg8adj dac e taji kitigegobanen odanominiman okitigan akikag, nandam mikanakag ki inagodjino8an. Ki mamagocka8agani8i8an dac ini odanominiman, acitc pinecijag ogi pi nda am8a8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kodagiag dac anominag ka iji asini8akamiganig ki inagodjinog. Apitc dac kitiganijican e ani madjigigin, ki pate8an, ka8in mega tibise minama8asinobanin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nandam dac kodagiag anominag ka iji minesatigo8anig ki inagodjinog. Meg8adj dac ka pimigigin ka min8acigin kitiganan, minesatigog acitc ki ani madjigi8ag, midac ka iji ani kib8anamockigadegin kidji gi minogigin ka min8acigin kitiganan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kodagiag dac nandam anominag ka iji min8acinig akini ki inagodjinog. Kitiganan dac ki madjiginon acitc minan ki kitci nta8iginon, e memidasomidana8egin e azaodegin.” Jesos kiabadj ki ikido: “Kakina kina8a keckito8eg kidji nisidotameg, 8e8enda ndotamok.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jesos dac okikinoamaganan ogi k8ag8edjimigobanin: “Adi ekidomagag ii adisokan?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesos dac ogi nak8e8ajian: “Kina8a kigi odisigona8a kidji kikendameg Kije Manido Odogima8i8in, ega 8ikad a8iag kagi kikendag. Kodagiag dac a8iagog adisokanan nidabadjitonan kidji kikinoama8ag8a, 8e8enda kidji inabi8adj ega mamakadj kidji 8abadamo8adj, acitc 8e8enda kidji nodamo8adj ega mamakadj teb8e kidji nisidotamo8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Mi ekidomagag oo8e adisokan. Mi maia pejig8an Kije Manido odikido8inan ejinagozi8adj anominag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nandam a8iagog e nodamo8adj Kije Manidon omin8adjimo8ini, mi maia tabickotc anominag mikanakag kagi inagodjino8agobanen ejinagozi8adj. Apitc nodamo8adj min8adjimo8ini, kitci madji manidon opi nda manibidoni ii min8adjimo8ini odei8akag, ega kidji gi teb8etamo8adj acitc ega kidji gi odji ag8acimagani8i8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nandam dac kodagiag a8iagog e nodamo8adj min8adjimo8ini, mi maia tabickotc anominag ka iji asini8akamiganig kagi inagodjino8agobanen ejinagozi8adj. Onodana8a min8adjimo8ini acitc oteb8etana8a e modjigendamo8adj. Ka8in dac macka8izimagasini oteb8etamo8ini8a acitc ka8in kin8ej okana8endasina8a. Apitc dac k8ag8e pakebinigo8adjin madji manidon, mi eji poni teb8etamo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nandam dac a8iagog e nodamo8adj Kije Manidon omin8adjimo8ini, mi maia tabickotc anominag ka iji minesatigo8anig akini kagi inagodjino8agobanen ejinagozi8adj. Ododisigona8a Kije Manidon omin8adjimo8ini. Ka iji pimadizi8adj dac, animendamog acitc kitci 8i oconiami8ag acitc mi eta nanada min8endamog. Onigockagona8an dac ini, ega kidji abadanig Kije Manidon omin8adjimo8ini opimadizi8ini8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kodagiag dac a8iagog e nodamo8adj Kije Manidon omin8adjimo8ini, mi maia tabickotc anominag ka iji min8acinig akini kagi inagodjino8agobanen ejinagozi8adj. Mi igi8e e nodamo8adj min8adjimo8ini, omino kana8endana8a odei8akag acitc o8i naitana8a. Okitci abadjitona8a dac opimadizi8ini8akag, ega 8ikad e poni teb8etamo8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesos kiabadj ki ikido: “Ka8in a8iag 8asakonendjigani osakaasin, anamig akikokag kidji iji atodj konigotc anamig onibe8inikag. Tiegodj, 8asakonendjiganatigokag odiji aton, kidji 8abi8adj igi8e ke pidige8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Kakina mega kegon ka kadjigadeg kada nag8an, acitc kakina kegon ega maci ka kikendjigadeg kakina a8iag oga kikendan.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Iag8amig dac adi eji ndotameg! A8iag mega kegoni ka aiag, a8acamej oga odisigon. Aa dac a8iag ega kegoni ka aiag, misa8adj pagi kegoni ka inendagiban e aiag kada makamagani8i.” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesos odjodjoman acitc o8idjiki8en ogi pi nda 8abamigon. Ka8in dac ododji kackitosina8a pecodj kidji pi nazika8a8adjin, osa e kitci manenani8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Jesos dac ki 8idama8agani8i: “Kidjodjom acitc kidjiki8eg ag8adjik paba tajigaba8i8ag, e 8i 8abamik8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesos dac ogi inan: “Igi8e Kije Manidon odikido8ini ka ndotamo8adj acitc ka nosoneamo8adj, mi igi8e nidjodjom acitc nidjiki8eg.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nigodin Jesos acitc okikinoamaganan tcimanikag ki pozi8agoban. Ogi inan dac: “Ijadan 8edi agamig sagaiganikag.” Midac ka iji madjio8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Meg8adj e ajo8agameaci8adj, Jesos taji nibagoban. Kegapitc ki kitci nodin sagaiganikag. Kitci pizibigoban ii tciman acitc kitci nanizanizi8agoban. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jesos dac okikinoamaganan ogi pi kockonigon, acitc ogi igon: “Kikinoamage8inni! Aja kiga nisaba8emin!” Jesos dac ki kockozi acitc ogi kitci aiamiton e kitci nodinig acitc e kitci mamagaanig. Midac teci8ag ki kitci pekadani acitc ki kitci an8atini. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesos dac ogi inan okikinoamaganan: “Adi 8edji ega teb8etaojieg?” Ki kitci segizi8agoban acitc ki kitci mamakadendamo8agoban, e inidi8adj: “A8enen dac aa nabe maiagotc? 8a8adj okaganodan e nodinig acitc nibini, onadotagon dac!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesos acitc okikinoamaganan ogi oditana8a Jenasa (Gérasa) ka ijinikadenig akini, iji k8ekagam ka iji tag8ag Galilee aki. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Apitc Jesos ka kabadj tcimanikag, pejig naben Jenasa odena ka odjindjin ogi pi nda nagickagon. Aa nabe ogi pidigeckagogobanin madji manidon. Aja kin8ej ka8in kegoni okigickasinagoban. Ka8in migi8amikag tajikesigoban, tiegodj dac 8ibabikiniganikag iji paba tegoban. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Mane8inaj ako opidigeckagobanin ini madji manidon. Ki takonagani8igoban dac, acitc ki mag8apidjigadeni8an onidjin acitc ozidan pi8abiko sagapizoneabini e abadanig kidji kana8enimagani8idj. Midac ka iji pigobidodj ii pi8abiko sagapizoneabini, acitc madji manidon ogi madjinijaogon pig8adakamig. Apitc ka 8abamadjin Jesosan aa nabe, ki pabibagi acitc ogi nibak8ita8an. Ki ikido dac e kitci kiji8edj: “Jesos! Kije Manido ma8adji ka icpendagozidj Og8izisan! Adi eji nda8enimijian? Kipagosenimin, ka8in sanagendjigeijiken!” 8edji ki ikidodj dac ii, Jesos mega ki ikidogoban: “Madji manido! Sagaan iima 8inikag!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesos dac ogi k8ag8edjiman ini naben: “Adi e ijinikazo8an?” Aa nabe ogi nak8e8ajian: “ ‘Mane’ nidijinikazonan.” Mane8an mega madji manidon kagi pidigeckagodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Igi dac madji manidog ogi kitci pagosenima8an Jesosan ega kidji ijinijaogo8adjin 8edi ka iji kitci 8ani pagonekamiganig taji ka iji kiba8agani8i8adj madji manidog. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tebanig iima pecodj kitci mane kokocag e nanada 8isini8adj pik8adinajicikag. Midac igi madji manidog ogi kitci pagosenima8an Jesosan kidji pagidinigo8adjin kidji gi pidigecka8a8apanin ini kokocan. Jesosan dac ogi pagidinigo8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Igi dac madji manidog ki sagaamog nabekag, acitc ogi pidigecka8a8an ini kokocan. Kakina dac igi kokocag ki pakobig8ackoni8ag acitc ki nisaba8e8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","A8iagog dac ka kana8enima8adjin kokocan, apitc ka 8abadamo8adj ejisenig, ki madjibato8ag kidji nda tibadjimo8adj odenakag acitc kitige8innikag adi ka iji8ebanig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mane dac a8iagog ki pija8ag kidji 8abadamo8adj adi ka iji8ebanig. Ogi pi nazika8a8an Jesosan, acitc ogi 8abama8an ini naben kagi odji sagaamindjin madji manidon. Aja Jesosan ozidinikag pecodj taji abiban aa nabe, ki 8a8epizoban, acitc aja kitci pagakadiziban. Midac ki kitci segizi8ag igi8e a8iagog. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Igi8e dac ka 8abadamo8adj adi ka iji8ebanig ogi 8idama8a8an kodagian a8iagon adi kagi iji kigeagani8indjin ini naben ka kigickagonipanin mane madji manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Midac kakina a8iagog iima Jenasa aki ka tajike8apan ogi kitci k8ag8edjima8an Jesosan kidji madjandjin iima odaki8akag. Ki kitci segizi8ag mega. Ki pozi dac Jesos tcimanikag kidji ki8edj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Aa nabe kagi odji sagaamindjin mane madji manidon ogi kitci pagoseniman Jesosan kidji gi paba 8idji8adjin. Jesos dac ka8in ododji pagidinasi8an. Ogi inan dac: ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ki8en kimigi8amikag acitc tibadjimon adi kagi iji kitci mino todaok ka Tibendjigedj.” Aa dac nabe ki madja, acitc ki paba tibadjimo mizi8ena iima odenakag adi kagi iji kitci mino todagodjin ka Tibendjigendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesos mina8adj ki koki ajo8aam. Apitc ka tag8icig, kitci mane a8iagon ogi pi nda nagickagon e kitci min8endamindjin. Kakina mega opia8abanin kidji tag8icinindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Pejig nabe ki pi tag8icin, Tceros (Jaïrus) e ijinikazodj, mi aa8e ka niganizipan Coda8inni aiamiemigi8amikag iima odenakag. Jesosan ozidinikag ki iji nibak8i acitc ogi kitci pagoseniman Jesosan kidji ijandjin omigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Motci pejigobanin mega odanisan, acitc aja kegat nibobanin. Motci midatcin acitc nijopibon8ezibanin ini odanisan. Jesos dac ogi 8idji8an. Meg8adj e ija8adj, kitci mane a8iagon okitci sidjickago8an 8akaag Jesosikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tegoban acitc iima pejig ik8e e kitci akozidj, aja midatcin acitc nijopibon inigik o8anitonagoban omisk8i. Kakina oconiaman ogi tcaginabanin egi kijika8adjin mackiki8innin, ka8in dac a8ian ododji kackitosini kidji kigeigodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Odakanag dac ogi pi odji nazika8an Jesosan, acitc ogi taginan 8ajagameig okonasini. Teci8ag dac ki kibitajiga8ini omisk8i. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesos ki k8ag8ed8e: “A8enen ka taginijidj?” Kakina dac ki ikido8ag ega egi tagina8adjin. Pien dac ki ikido: “Kikinoamage8inni! Kitci mane a8iagog ki8ik8eckagog acitc kikitci sidjickagog 8akaag kinikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Misa8adj dac Jesos ki ikido: “Maiagotc a8iag nigi taginig. Nikikendan mega nimacka8izi8ini egi kigeigodj pejig a8iag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aa dac ik8e ogi kikendan ega kidji gi kazodj. Ki pi nibak8i dac Jesosan ozidinikag, e kitci ninigickadj. Meg8adj dac kakina a8iagon e nodagodjin, ki 8idamage adi 8edji ki taginadjin Jesosan, acitc teci8ag egi kigeagani8idj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesos dac ogi inan: “Nidanis! Kiteb8etamo8in kigi kigeigon. Ki8en acitc min8endan.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Meg8adj Jesos e taji aiamiapanin ini ik8e8an, ki pi odji tag8icin a8iag Tcerosan omigi8aminikag e odosedj acitc ki ikido: “Aja ki nibo kidanis. Ka8in mamakadj 8anasadjiaken Jesos.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesos dac ogi nodan acitc ogi inan ini Tcerosan: “Ka8in segiziken, mi eta teb8etaocin, kada koki pimadizi dac kidanis.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Apitc dac ka tag8icig Jesos 8edi Tcerosan omigi8aminikag, ka8in kodag a8iagon ododji pagidinasi8an kidji pidigendjin, mi eta Pienan, Johnan, acitc Jakan, acitc dac ini abinodjijan onigiigoni. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kakina a8iagog kitci ma8ibanig e pabibagademo8adj. Jesos dac ogi inan: “Ka8in ma8ikegon. Ka8in mega nibosi aa ik8eses, motci niba eta.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kakina dac ogi maskita8a8an Jesosan, aja e ketcinamenima8adjin egi nibondjin ini ik8esesan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesos dac ogi na8adjindjibinan ini ik8esesan acitc ogi inan: “Ik8eses! 8anickan!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ki koki pimadizi aa ik8eses, acitc teci8ag ki 8anicka. Jesos dac ki ikido: “Kegoni acamik.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Aa dac ik8eses onigiigon ki kitci mamakadendamon. Jesos dac 8e8enda ogi inan ega a8iagon kidji 8idama8andjin ii kagi iji8ebanig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Kegapitc Jesos ogi ma8adjian ka midatcin acitc nijindjin okikinoamaganan. Ogi minan dac macka8izi8ini kidji gi sagidjinija8andjin madji manidon, acitc kidji gi kigeandjin ka akozindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ogi ijinija8an dac kidji paba tibadjimondjin Kije Manidon Odogima8i8ini, acitc kidji paba kigeandjin ka akozindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ogi inan dac: “Ka8in kegon madji8idokegon e pabamodeieg, ka8in sakaon, ka8in kek8an pak8ejigan, mackimod, konigotc conia. Ka8in nijin pabagi8anan madji8idokegonin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Atajigotc a8iagog pejig odenakag ka te8adj ke iji nda8enimigo8eg, mi kabe pejig8an migi8amikag tajikeok, pinici kidji odjitciseg kidji odji madjaieg. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Atajigotc a8iagog pejig odenakag ka te8adj ega ke iji nda8enimigo8eg, nagadamok ododenami8a acitc papa8izidecimonok e minigonaci8akizineieg. Midac kidji kikendamo8adj ega e min8endamia8adjin Kije Manidon,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jesos okikinoamaganan ki madja8an acitc kakina odenajicikag ki ani paba ija8an, mizi8ena e paba tibadjimondjin Kije Manidon omin8adjimo8ini acitc mane a8iagon e kigeandjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herod, ka ogima8igobanen Galilee akikag, ogi nodan kakina ka iji8ebanig acitc ka8in ododji nisidotasinaban. Nandam mega ikidobanig Cabadisan egi abidjibandjin, ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","acitc nandam kodagiag ikidobanig niganadjimo8innin Elin egi koki nagozindjin, acitc kiabadj nandam kodagiag ikidobanig pejig kodagian 8eckadj e tacindjin niganadjimo8innin egi koki pimadizindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herod dac ki inendam: “Nigi anoki kidji kickig8ega8agani8idj Cabadis. A8enen dac nogom ka mikomagani8idj?” Midac Herod ogi k8ag8e nda 8abaman Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesos Odanodaganan ki koki pi ki8e8an, ogi 8idamagon dac kakina kagi inakamigizindjin. Jesos dac ogi madji8inan acitc 8in eta ogi 8idji8an pecodj Betseda (Bethsaïda) odenakag e ija8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kitci mane a8iagog ki nodage8ag adi ejandjin Jesosan, ogi nosone8a8an dac. Jesos dac ogi inan: “Nimin8endan egi pijaieg.” Ki kagik8e, e mikodag Kije Manidon Odogima8i8ini, acitc ogi kigean ka akozindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Apitc e ani tibikanig, ka midatcin acitc nijindjin Jesos okikinoamaganan ogi pi nazikagon acitc ogi igon: “Ka8in tag8asinon kegon ooma. Ijinijaok dac igi a8iagog kidji ija8adj kitige8inni8igi8amikag acitc odenajicikag pecodj ooma kidji nda odapinamadizo8adj midjimini acitc kidji mikamo8adj ke iji niba8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesos dac ogi inan: “Kina8a tibina8e mijikog kidji 8isini8adj.” Ogi igon dac: “Motci nanani8ag obiziganesag e aia8agid8a, acitc niji8ag kigozag. Kinada8endan na kidji nda odapinamag midjim kidji gi acamagid8a kakina igi8e a8iagog?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","8aiej nanan kitci midasomidana (5000) taci8agoban nabeg. Ogi anonan dac okikinoamaganan: “Abinijaokog kakina a8iagog, kidji nenanomidana8e8adj e ok8abi8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Midac iidi ka todamo8adj. Kakina ogi abinija8a8an iima motakamig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesos dac ogi odapinan ini ka nananindjin obiziganesan acitc ka nijindjin kigozan. Ki icpanabi 8ak8ig, acitc mig8etc ogi inan Kije Manidon. Ogi papak8ebinan acitc ogi minan okikinoamaganan kidji gi madinama8andjin kakina a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ki 8isini8an dac kakina, acitc ki tebickono8an. Jesos dac okikinoamaganan ogi ma8adjitona8a midjimini kagi odji ickosenig. Midatcin acitc nijin 8adabi8akik8an ki kicpone8an inigik ka ickosenig midjimini. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nigodin Jesos taji aiamieban 8in eta. Okikinoamaganan ogi nda 8abamigon, midac Jesos ogi k8ag8edjiman: “Adi ekido8adj a8iagog e mikomiji8adj? A8enen enenimiji8adj?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ogi nak8e8ajiigon dac: “Nandam ikido8ag e Cabadisi8i8adj, kodagiag ikido8ag e Eli8i8adj, kodagiag kiabadj ikido8ag egi koki pimadizindjin pejig 8eckadj e tacindjin niganadjimo8innin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesos dac ogi k8ag8edjiman: “Kina8a dac, a8enen enenimijieg?” Pien dac ogi nak8e8ajian: “Kin aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin, 8in aa8e Christ ka ijinikanagani8idj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesos dac 8e8enda ogi 8idama8an ega kidji paba tibadjimondjin ii. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jesos ki ikido: “Nin, Ka pi Anicinabe8iidizodj, panima niga kitci kodagito. Ka niganizi8adj Coda8innig, Coda8inni kitci aiamie ogimag acitc Coda8inni kikinoamage8innig niga ana8etagog. Niga nisigo, ki nisogonaganig dac niga abidjiba8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mina8adj Jesos ogi inan kakina a8iagon: “Kicpin a8iag 8i 8idjiojidj, panima ki poni mik8enimidizodj, panima taso kajik ki pimi8inadjin otcibaiatigoman, acitc panima ki nosoneojidj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Aa8e mega ka kitci manadjitodj opimadizi8in kada nibo, aa8e dac pekic ke nibog8en nin odji, oga pimadjiton opimadizi8in. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Adi dac inasag a8iag kakina kegonan ka kitci min8acinigin tibendagibanin ooma akikag, kicpin 8anicig acitc odji nici8anadjiagani8idj? ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","A8iag dac agadenimijidj acitc agadendagin nidikido8inan, mi aa8e kenin, Ka pi Anicinabe8iidizodj, ke agadenimag, apitc pi tag8icinian e 8abadai8eian nidicpendagozi8in, acitc Nidadam odicpendagozi8in, acitc kitcit8a ajenig odicpendagozi8ini8a. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Teb8e ki8idamonom, nandam a8iagog ooma ka te8adj ka8in kada nibosi8ag ab8amaci 8abadamo8adj Kije Manidon Odogima8i8ini.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","8aiej pejigota8ate ka ick8a ikidopan ii, Jesos ogi madji8inan Pienan, Johnan, acitc Jakan, midac ka iji ik8amadji8e8adj pik8adinakag e nda aiamie8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Meg8adj e taji aiamiedj Jesos, pakan ki ani ijig8e, acitc okonas ki kitci 8abinag8ani tabickotc ka kitci 8asakoneseg e ijinag8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kitata ki te8ag nijin nabeg e taji aiamia8adjin Jesosan, Mois acitc Eli igi. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Kitci 8asea8inikag ki odji nagozi8ag. Omikodana8aban dac kidji ick8aikag Jesos ka odji pidjinija8agani8igobanen e ani nibodj 8edi Jerusalem odenakag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pien acitc ka 8idjiogodjin niba8agoban ii meg8adj. Apitc dac ka odji kockozi8adj, ogi 8abadana8a Jesosan odicpendagozi8ini acitc ogi 8abama8an ini nijin naben e 8idjigaba8itagodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Apitc Jesosan e 8i nagana8adjin igi nijin nabeg, Pien ogi inan Jesosan: “Kikinoamage8inni! Kitci min8acin egi pijaiak ooma. Niga padakisidonananan dac nisin nibaganan, pejig kin odji, pejig Mois odji, acitc pejig Eli odji.” Ka8in dac nisidotadizosiban adi e ikidodj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Meg8adj e taji ikidodj ii, 8ak8ini ki pi nag8ani, acitc ogi nigockagona8a. Ki kitci segizi8an dac Jesos okikinoamaganan apitc ka nigockago8adj ii 8ak8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ogi noda8a8an dac a8ian iima 8ak8ikag e odji mad8e anim8endjin e ikidondjin: “Mi aa Nig8izis, ka onabamag. Ndotaok dac!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Apitc ii8e ka ick8a nodamo8adj, Jesosan eta ogi 8abama8an, ka8in kodag a8ian tesi8an iima. Ka8in dac odji 8idamagesi8ag adi ka ijisenig, acitc ii apitc ka8in odji pabamadjimosi8ag adi ka iji 8abadamo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","8iabanig, apitc Jesos acitc nisin okikinoamaganan ka pi nisamadji8e8adj pik8adinakag, ogi pi nda nagickago8an kitci mane a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Pejig dac nabe iima ka tepan ki pabibagi: “Kikinoamage8inni! Kipagosenimin kidji kidimagenimadj nig8izis. Mi eta pejigo nig8izis. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Okigickagon dac madji manidon. Okitci pabibagickagon kitci kaiezigotc, okitci sogi mamadjibinigon, acitc kitci pite8idone. Okitci kodagiigon acitc kitci animendjige e 8i pagidjickagodjin o8ia8ikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nigi pagosenimag kikikinoamaganag kidji sagidjinija8a8adjin ini madji manidon, ka8in dac ododji kackitosina8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesos ogi inan kakina a8iagon: “8esada ako kina8a nogom ka pimadizieg, ega ka teb8etameg, acitc pijicig madji kegonan ka 8i pamendamegon! Anigik kiabadj ke 8idji tajikeminagok? Anigik panima ke tanendamiijieg?” Mina8adj dac ogi inan ini naben: “Pidji8idamaocin kig8izis ooma.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Meg8adj e iji8idama8agani8idj ini ockina8esan, aa madji manido motcikag ogi iji8ebinan acitc ogi kitci mimigobinan enigok. Jesos dac ogi kitci kanonan ini madji manidon acitc ogi kigean ini ockina8esan. Midac ka iji koki minadjin odadamini. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kakina dac a8iagog ki kitci mamakadendamog egi 8abadamo8adj epitci macka8izindjin Kije Manidon. Kakina dac a8iagon e kitci mamakadenimigodjin adi ka pi ijitcigedj, Jesos ogi inan okikinoamaganan: ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“8e8enda ndotamok oo8e ke ininagok. Nin, Ka pi Anicinabe8iidizodj, niga 8agackibinigo, kidji gi tibenimiji8adj a8iagog ooma akig.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ka8in dac onisidotasina8aban kikinoamaganag adi 8a ikidonipanin. Ki kadama8agani8i8ag mega adi maia 8a ikidomaganig ega kidji gi nisidotamo8adj, acitc kocimobanig kidji k8ag8edjima8adjin 8egonen 8edji ikidonipanin ii. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nigodin kikinoamaganag ki kitci kaganondi8ag e nanada kikendamo8adj a8eneni8an ma8adji ketci apitendagozindjin 8ina8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesos ogi kikeniman adi enendamindjin. Ogi odapinan dac abinodjijan acitc pecodj 8inikag ogi iji asan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ogi inan dac okikinoamaganan: “Aa8e ke mino toda8ag8enin ono8e abinodjijan nin odji, niga mino todag kenin. Acitc aa8e ke mino todaojidj, oga mino toda8an ke8in ini8e kagi pidjinijaojindjin. Aa8e ma8adji ke kitci tabasenimidizodj e tacieg, ma8adji kada kitci apitendagozi.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","John ogi inan Jesosan: “Kikinoamage8inni! Nigi 8abamanan pejig nabe e sagidjinija8adjin madji manidon ki8izoni e abadjitodj. Nigi k8ag8e odjianan dac, ka8in mega ki8idjiogosinan.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesos dac ogi nak8e8ajian: “Ka8in odjiakegon. A8enenigotc ega ke nagabidog8en kimikimo8ini8a, ki8idji mikimomigo8a sa.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Aja ani odjitciseniban Jesos 8ak8ig kidji ijadj. Ogi odji kitci sogi nda8endan dac Jerusalem odenag kidji ijadj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ogi niganinija8an dac nandam a8iagon. Ki madja8ag, acitc ki pidige8ag pejig odenajicikag 8edi Samani (Samarie) akikag, kidji a8i eco8i8adj Jesosan kidji tag8icinindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Midac a8iagog iima ka tajike8agobanen ka8in onada8enimasi8a8abanin Jesosan kidji odisigo8adjin, okikenima8abanin mega Jerusalem odenag e pimi ijandjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nijin dac kikinoamaganag, Jak acitc John, apitc ka 8abadamo8adj ii, ki ikido8ag: “Tebendjigean! Kinada8endan na kidji nd8e8edamag ickode 8ak8ig kidji pi odakoneseg, kidji nici8anadjiigo8adj dac?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesos dac ki k8ekigaba8i acitc ogi kaganonan ii ka ikidondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Midac kodag odenani ka iji ija8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Meg8adj e pimode8adj, pejig nabe ogi inan Jesosan: “Kiga nosoneon adigotc ke ija8anen.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesos dac ogi inan: “8agocag o8aji8ag acitc pinecijag o8asasoni8ag, pekic dac nin, Ka pi Anicinabe8iidizodj, ka8in nidaiasin migi8am ke iji an8ecimono8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesos dac ogi inan pejig kodagian a8iagon: “Nosoneocin.” Aa dac nabe ki ikido: “Tebendjigean! Pinama pagidinicin kidji nda naata8ag nidadam o8ia8.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesos dac ogi nak8e8ajian: “Igi8e mi maia ka nibo8adj ka ijinagozi8adj oga kackitona8a kidji naatama8a8adjin o8ia8ini ka nibondjin. Kin dac, paba tibadjimon Kije Manido Odogima8i8in.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kodag kiabadj nabe ki ikido: “Tebendjigean! Kiga nosoneon, pinama dac pagidinicin kidji nda anamika8ag8a igi8e nimigi8amikag ka tajike8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesos ogi 8idama8an: “A8iag ka madjitadj e mikimodj, odakanag dac ka inabidj, ka8in okackitosin kidji mikimodj Kije Manidon Odogima8i8inikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ick8a dac ii, Jesos ogi onabaman nij8asomidana acitc nijin (72) kodagian a8iagon, acitc nenijin ogi madjinija8an nigan, kakina odenan acitc odenajican kagi inendagiban 8in tibina8e kidji ijapan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ogi inan dac: “Mi maia kitiganan ejinagozi8adj a8iagog. Kitci manedon kitiganan ke ma8adjitcigadegin, midac eta ka8in tibisesi8ag mikimo8innig. Pagosenimik dac Kije Manido, 8in ka tibendagin kitiganan, kidji ijinija8adjin mane kodagian mikimo8innin kidji ma8adjitondjin okitiganan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mi iji ijaok! Mi tabickotc mantcenicesag ka ijinija8agani8i8adj nena8idj maiganikag e ijinagozieg e madjinijaonagok. ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ka8in madji8idokegon conia8aj, ka8in kek8an mackimod, ka8in kek8an makizinan. Ka8in kibisikakegon kidji anamika8eg a8iag meg8adj e pimodeieg.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Apitc pidigeieg a8iag omigi8amikag, pinama ikidok oo8e: ‘Kije Manido oga minan pekadendamo8ini kakina oo migi8amikag ka tajikendjin.’ ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kicpin a8iag iima ka tajikedj iji nda8endag Kije Manidon opekadendamo8ini ka migi8endjin, teb8e oga odisigon ii pekadendamo8ini kagi k8ag8ed8eieg 8in odji. Kicpin dac ega iji nda8endag, ka8in kada minagani8isi. ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Meg8adj dac e teieg iima odenakag, tajikeok iima migi8amikag, misa midjiok acitc minik8eok 8egonenigotc ke minigo8eg. Mikimo8inni mega inendagozi kidji kijika8agani8idj. Ka8in dac pijicig pabamadjigekegon.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Apitc pidigeieg pejig odenakag acitc nda8enimigo8eg, midjiok 8egonen ke acamigo8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Kigeikog ka akozi8adj iima odenag ka te8adj, acitc 8idamaokog a8iagog iima ka tajike8adj: ‘Aja pi peconag8ani Kije Manido Odogima8i8in kina8akag.’ ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Apitc dac pejig odena pidigeieg, ega dac iji nda8enimigo8eg, madjiadok mikanan iima odenakag. Ikidok dac: ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nipapa8isidonananan nimakizinanan, kidji papa8ibant8aagin kidodenami8akag ka odjiseg minigonac, kidji gi kikendameg Kije Manido ega e min8endamieg. Ka8in 8ikad 8anikekegon oo8e, aja pi peconag8ani Kije Manido Odogima8i8in kina8akag,’ kiga 8idamagem. ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ki8idamonom, apitc odjitcisenig Kije Manido kidji tibakonigedj, na8adj a8acamej oga sogi pajacte8an ini8e a8iagon iima odenag ka tajikendjin, apitc8in ini8e madji a8iagon 8eckadj Sodom odenag ka tajikenipanin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Kiga kitci madji iji8ebizim, kina8a ka tajikeieg Korazin (Chorazin) odenag acitc kina8a ka tajikeieg Betseda (Bethsaïda) odenag! Kitci mane mega nigi iji mamada8izinan kidodenami8akag, ka8in dac misa8adj ki8i odji an8endizosim. Kicpin ini mamada8izi8inan ki todjigadegibanin 8eckadj 8edi Tir (Tyr) acitc Sidon odenakag, igi madji a8iagog iima ka tajike8apan aja 8eckadj kadagi makade8eginoobanig kidji 8abadai8e8adj e an8endizo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Apitc dac odjitcisenig Kije Manido kidji tibakonigedj, na8adj a8acamej kiga sogi pajacteogom apitc8in igi8e a8iagog 8eckadj Tir acitc Sidon ka tajike8apan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kina8a dac Kaponaom (Capernaüm) odenag ka tajikeieg, ‘Nikitci apitendagozimin’ kidinendana8a na? Tiegodj dac Kije Manido kiga kitci sogi pajacteogo8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Okikinoamaganan kiabadj ogi inan: “Aa8e ke ndotago8eg8en, kenin ninadotag, acitc aa8e ke ana8etago8eg8en, kenin nidana8etag. Aa8e dac ke ana8etaojidj, odana8eta8an ke8in ini8e kagi pidjinijaojindjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ka nij8asomidana acitc niji8adj (72) a8iagog e neniji8adj kagi ijinija8agani8i8apan ogi kitci modjigendana8aban apitc ka pi koki ki8e8adj. Ki ikido8ag: “Tebendjigean! 8a8adj madji manidog ninadotagonanag apitc e sagidjinija8agid8a a8iagokag e abadjito8ag ki8izon.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesos ogi nak8e8ajian: “Nigi 8abama kitci madji manido 8ak8ig e odagodjig tabickotc inimiki. ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ndotamok! Kigi mininom macka8izi8in kidji gi magocka8eg8a kinebigog acitc ka pitcibo8inezi8adj mandjocag, acitc kidji gi cagodjito8eg mizi8e kitci madji manido omacka8izi8in. Ka8in kegoni kigagi iji madji todagosi8a. ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Misa8adj dac, ka8in kitci modjigendakegon madji manidog e ndotago8eg. Tiegodj, modjigendamok 8ak8ig e ojibiigadegin ki8izoni8a.” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Maiagotc ii apitc, Jesos ogi minigon Mino Manidon kidji kitci modjigendag. Ki aiamie dac e ikidodj: “Nidadam, kin ka Tibendamanin 8ak8ig acitc aki, mig8etc kidinin, osa mega kigi kikendamonag abinodjijag kegonan ka kadama8ad8a a8iagog ka kagita8endamo8adj acitc ka omidonendjigani8adj. Nidadam! Teb8e mi ii8e kin kagi iji nda8endaman kidji ijinag8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ogi inan dac a8iagon: “Kakina macka8izi8ini Nidadam nigi minig. Ka8in a8iag nikikenimigosi, midac eta Nidadam nikikenimig. Ka8in a8iag okikenimasin Nidadaman, midac eta nin Og8izisan nikikenima, acitc igi8e ka nda8enimag8a kidji kikenima8adjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Mina8adj Jesos ki iji k8ekigaba8i acitc okikinoamaganan eta ogi inan: “Kica8endagozim kina8a ka 8abadameg adi eji 8abadameg. ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ki8idamonom, kitci mane niganadjimo8innig acitc kitci ogimag ogi kitci nda8endana8a kidji iji 8abadamo8adj ka iji 8abadameg, ka8in dac ododji 8abadasina8a. Ogi kitci nda8endana8a kidji nodamo8adj ka iji nodameg, ka8in dac ododji nodasina8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nigodin pejig Coda8inni kikinoamage8inni ogi nda 8abamagoban Jesosan kidji k8ag8e katcidinadjin anodj kidji iji nak8e8ajii8endjin. Ogi k8ag8edjiman dac: “Kikinoamage8inni! Adi ke todamaban kidji gi odisigo8an kagige pimadizi8in?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesos ogi nak8e8ajian: “8egonen mezinadenig Kije Manido odinakonige8inikag? Adi eji nisidotaman apitc e nabo8adaman?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Aa nabe ogi nak8e8ajian: “Kiga sagia8a ka Tibendjigedj Kikije Manidomi8a enigokodeeieg, enigokodjitcagocieg, kakina epitcieg, acitc enigokomidonendjiganieg. Acitc dac kiga sagia8a kidjipimadizimi8a tabickotc kina8a ka iji sagiidizo8eg.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesos ogi inan: “8e8enda kigi nak8e8ajit8a. Misa todan ii, midac kidji aiaman kagige pimadizi8in.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Aa8e dac Coda8inni kikinoamage8inni 8i k8ag8e 8abadai8e ega e migodjimodj. Mina8adj dac ogi k8ag8edjiman Jesosan: “A8enen aa nidjipimadizim?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesos dac ogi nak8e8ajian: “Nigodin pejig nabe Jerusalem odenag ki odji madja, Jeriko (Jéricho) odenag e ani nisamadji8edj. Meg8adj dac e pimodedj, kimodi8innig ogi na8adjibina8an. Ogi manikonaebina8an acitc ogi kimodima8an odaimini. Ogi migana8an acitc mi ka ijia8adjin kegat egi nisa8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Maia mika pimosegoban, pejig aiamie ogima pejig8an mikanani ki ani ijagoban. Apitc dac ka 8abamadjin ini naben, ogi kabika8an k8ekikana mikanakag eji pimosedj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kegapitc pejig aiamie anodagan ogi oditan iima acitc ogi nazika8an ini naben, midac ke8in ogi kabika8an k8ekikana mikanakag eji pimosedj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kegapitc dac kiabadj pejig nabe, Samani (Samarie) akig ka odjipan, mi ii pejig8an mikanani ka iji pimodegobanen, ogi pi odisan. Apitc ka 8abamadjin ini naben, ogi kitci kidimageniman. ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ogi nazika8an dac. Ogi siginan cominaboni e kiziaba8adodjin iima ka iji namezindjin, acitc pimideni ogi pozinan ega kidji kitci 8isagendamindjin, midac ka iji sidopinadjin. Mina8adj omisabozomikag ogi iji 8agidasan acitc ogi iji8inan nibe8igi8amikag. Iima dac ogi taji kana8eniman. ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","8iabanig, ogi minan ka mikidamindjin nibe8igi8amini conian acitc ogi inan: ‘8e8enda kana8enim aa nabe. Apitc mina8adj pijaian ooma, nin kiga kijikaon kicpin ani8ag tcaginigean 8in odji.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesos dac ogi k8ag8edjiman ini kikinoamage8innin: “Aa8e nabe ka miganagani8idj, adi ini8e ka nisindjin maia o8idjipimadiziman, enendaman kin?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Aa Coda8inni kikinoamage8inni ogi nak8e8ajian: “Aa8e sa ka kidimagenimadjin.” Jesos dac ogi inan: “Mi iji madjan, acitc mi pejig8an inakamigizin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesos acitc okikinoamaganan pimodebanig. Ogi oditana8a pejig odenajicini, iima dac pejig ik8e8an, Mata (Marthe) ijinikazonigoban, ogi pidigeigo8an omigi8aminikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Pejig tebanin o8idjiki8en ka ik8e8indjin, Mani ijinikazonigoban. Aa dac Mani nigan Jesosikag ki abi, midac otaji ndota8abanin adi eji kikinoamagendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mata ka8in odji pejig omin8endasinaban meg8adj kitci tinataban e tcibak8edj kidji gi acamadjin kakina a8ian. Kegapitc ogi pi inan Jesosan: “Tebendjigean! Kana kinigodinendasin nicimej ega e 8idjiijidj kidji tcibak8eian kakina a8iagog kidji gi 8isini8adj? Kadjinijao kidji 8idjiijidj!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ka Tibendjigedj dac ogi nak8e8ajian: “Mata! Kikitci animendan acitc kikitci mamidonendan mane kegon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pejig dac eta kegon apitendag8an. Mani dac ogi onendan adi ma8adji ke iji mino ijitcigedj. Ka8in 8ikad a8ian ogagi makamigosin ii.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nigodin Jesos aiamieban 8aiejigotc. Apitc ka ick8a aiamiedj, pejig okikinoamaganan ogi igon: “Tebendjigean! Kikinoamaocinam kidji aiamieiag, tabickotc Cabadis kagi iji kikinoama8adjin okikinoamaganan.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesos dac ogi inan: “Apitc aiamieieg, mi oo8e ke ikido8eg: Nidadaminan, 8egona kakina a8iag kitcit8a8endag kidijinikazo8ini. 8egona pijamagag kidogima8i8in. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mijicinam taso kajik midjim ke odji pimadiziag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kasiamaocinam ka iji patadiag, tabickotc acitc ka iji ponenimagid8a igi8e kagi madji todago8ag. Ka8in pagidenimi8eken kidji pakebinigo8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesos kiabadj ki ikido: “Mamidonendamok oo8e. Pejig ii e tacieg onada 8abaman o8idji8aganan e abitatibikanig, acitc dac opagoseniman oo8eni: ‘Ni8idji8agan! A8iicin nisin pak8ejiganag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Pejig mega ni8idji8agan ka pabamadizidj ki odji tag8icin nimigi8amikag, ka8in dac kegon nidaiasin kidji acamag,’ odinan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ini8e dac pidigamig omigi8aminikag ka tendjin onak8e8ajiigon oo8eni: ‘Poniicin! Aja kibakosin nidick8adem, acitc aja ninibamin kakina. Ka8in dac nigagi 8anickasi kidji mininan pak8ejiganag,’ ikido8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Adi dac ke ijiseg? Ki8idamonom, kada 8anicka misa8adj, acitc oga minan kakina eji nda8endamindjin o8idji8aganan. E kitci cibagadjindjin kidji k8ag8edjimigodjin pinici kidji minadjin ke odji todag ii, ka8in eji omino 8idji8aganidj ke odji todag ii.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ki8idamonom dac oo8e. K8ag8ed8eok, kiga minigom dac. Nanada 8abadamok, kiga mikana8a dac. Papa8aamok ick8adem, kiga cenamagom dac. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","A8enenigotc mega k8ag8ed8edj kegoni, oga odisigon. A8enenigotc nanada 8abadag kegoni, oga mikan. Acitc a8enenigotc papa8aag ick8ademini, kada cenama8agani8i.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Kicpin pejig e tacieg abinodjijan aia8adjin, kinebigon na oga minan kicpin kigozan k8ag8edjimigodjin odabinodjijiman? ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kek8an dac pik8abagesin na oga minan kicpin 8a8ini k8ag8edjimigodjin? ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Misa8adj madjideeieg, kikikendana8a mino kegonan kidji mineg8a kidabinodjijimi8ag. Midac na8adj a8acamej Kidadaminan 8ak8ig ka tedj ke iji minadjin Mino Manidon ini8e ka k8ag8edjimigodjin.” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nigodin, Jesos ogi kigean pejig naben ega ka nta8endjin, e sagidjinija8adjin madji manidon ka kigickagonipanin. Apitc madji manidon ka sagidjisendjin, aa nabe okackitonagoban aja kidji anim8edj. Kakina dac a8iagog ki kitci mamakadendamog. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nandam dac a8iagog ikido8agoban: “Aa8e ka kackakanadjin madji manidon, aa8e ‘Beelzebul’ ka ijinikazodj, mi aa8e ka minadjin Jesosan macka8izi8ini kidji gi sagidjinija8andjin madji manidon.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nandam dac kodagiag o8i k8ag8e kadjinija8a8abanin kidji abadjitondjin omacka8izi8ini. Ogi k8ag8edjima8an dac kidji mamada8izindjin, kidji gi odji 8abadai8endjin teb8e Kije Manidokag epitci odjimaganig8en omacka8izi8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesos okikenimabanin adi enendaminigobanen. Ogi inan dac: “Kicpin a8iagog pejig ogima8i8inikag ka tajike8adj iji ma8asago migadi8adj pepejig e taci8adj, kada ani nici8anadjiomagan ii ogima8i8in. Acitc kicpin a8iagog ka pejigode8izi8adj migadi8adj, ka8in kadagi pimadjiomagasinon ii pejigodena. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Midac pejig8an, kicpin kitci madji manido 8inigotc tibina8e migandizodj, adi ke odji pimadjiomaganig odogima8i8in? ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nandam igi8e ka nosoneogo8eg, ke8ina8a okackitona8a kidji sagidjinija8a8adjin madji manidon. Kicpin Beelzebul minijidj macka8izi8ini kidji sagidjinija8ag8a madji manidog, adi dac 8edinamo8adj 8ina8a omacka8izi8ini8a? Ka nosoneogo8eg 8abadai8e8ag ega e teb8eieg. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ka8in kitci madji manido ogima Beelzebul ka minijidj macka8izi8ini kidji sagidjinija8ag8a madji manidog, 8in Kije Manido ka minijidj. Ki8abadaigona8a dac Kije Manido Odogima8i8in aja egi pi odisigo8eg.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Apitc a8iag macka8izidj acitc kitci aidjiodj e kana8endag omigi8am, ka8in 8ikad kada nigodisini8an odaiman. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Anic dac kicpin a8iag na8adj macka8izidj tag8icig acitc miganadjin ini a8ian acitc pakina8adjin, omakaman kakina omokomani ka iji apacenimonipanin, acitc kakina madina8e odaimini ini naben kagi pakina8adjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Kicpin a8iag ega 8idji mikimomijidj, onagabidon nimikimo8ini. Kicpin a8iag ega 8idjiijidj kidji ma8adjiimagin a8iagon, tiegodj odobenija8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Apitc madji manido ick8a sagidjinija8agani8idj a8iagokag, pig8adakamigokag paba ija kidji k8ag8e mikag ke iji an8ecimonodj. Kicpin dac ega mikag, kada ikido: ‘Niga koki ki8e taji ka iji tajikeiaban kagi odji sagidjinijaogo8an.’ ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Midac koki ki8e acitc omika8an ini a8ian ka odji sagidjinija8agani8ipan, tabickotc migi8amini ka kitci paiekinag8anig e ijinagozindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Aa dac madji manido onada 8abaman nij8atcin kiabadj kodagian madji manidon, na8adj kiabadj e madji inadizindjin apitc8in 8in. Mama8 dac opidigecka8a8an ini a8ian acitc mi iima eji tajike8adj. Ick8a dac ii, na8adj kiabadj kitci kotadendagozi aa a8iag apitc8in ockadok.” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Meg8adj Jesos e taji anim8egobanen, pejig ik8e8an nena8idj ka iji kitci manenani8anig ka tendjin, ogi igon: “Kitci ca8endagozi aa ik8e kagi nta8igiigo8an, acitc kagi iji tcodjocikean.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesos dac ogi nak8e8ajian: “Na8adj kitci ca8endagozi8ag igi8e Kije Manidon odikido8ini ka ndotamo8adj acitc ka nosoneamo8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Eckam ki ani kitci mane8ag a8iagog e ma8adjiidi8adj 8ajagam Jesosikag. Ii dac apitc, ki ikido: “A8iagog nogom ka te8adj kitci madji a8iago8i8ag. Nik8ag8edjimigog kidji mamada8izi8ag kidji nda motci kikendamo8adj epitci teb8emaganig8en ii egi pidjinijaojindjin Kije Manidon. Ka8in sa dac niga mamada8izi8asin. Aja mega okikendana8a 8eckadj adi kagi iji8ebizindjin niganadjimo8innin Jonasan. Midac iima ke iji 8abadamo8adj mamada8izi8ini ka k8ag8ed8e8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Apitc Jonas ka ag8acimagani8ipan nibikag, kakina a8iagog Ninip (Ninive) odenag ka tajike8agobanen ogi kikendana8agoban Kije Manidon egi ijinija8andjin ini Jonasan ododenami8akag. Midac pejig8an nogom nin, Ka pi Anicinabe8iidizodj, a8iagog nogom ka te8adj niga kikenimigog Kije Manidon egi pidjinijaojindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Aa 8eckadj kitci ogimak8e, ca8anog ka odjipan, kitci 8asag ki odose e pi nda ndotagin Sanamon (Salomon) odikido8inan, e kitci kagita8endamindjin. Aja dac te nogom ooma pejig a8iag na8adj e kitci apitendagozidj apitc8in Sanamo. Apitc dac Kije Manido tibakonadjin a8iagon, aa ogimak8e kada pazig8i kidji inactaonadjin ini a8iagon nogom ka tendjin ega ka 8i ndotamindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","8eckadj a8iagog Ninip (Ninive) ka tajike8agobanen ki an8endizo8ag apitc ka noda8a8adjin Jonasan e kagik8endjin. Aja dac te nogom ooma pejig a8iag na8adj e kitci apitendagozidj apitc8in Jonas. Apitc dac Kije Manido tibakonadjin a8iagon, Ninip ka tajike8agobanen a8iagog kada pazig8i8ag kidji inactaona8adjin ini8e a8iagon nogom ka tendjin ega ka 8i an8endizondjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ka8in a8iag 8asakonendjigani osakaasin kidji kadodj, kek8an anamig akikokag kidji iji atodj. Tiegodj, 8asakonendjiganatigokag odiji aton, kidji gi 8abi8adj igi8e ke pidige8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mi maia 8asakonendjigan epitendag8agin kickijigon kia8ikag. Kicpin min8acigin kickijigon, ka iji 8aseag kada tag8an mizi8e kia8. Kicpin dac ega min8acigin kickijigon, ka iji kacki tibikag kada tag8an kia8. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Midac maia 8asea8in epitendag8ag ka iji kikinoamaonagok. Misa nagadjiton ii 8asea8in kinikag ka tag8ag, ega kidji ata8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kicpin dac ka iji 8aseag tag8ag mizi8e kia8, maiagotc mizi8e kiga mockineckagon ii 8asea8in, ega iaga pagi kidji nigeateg. Midac tabickotc 8asakonendamagan ka 8asakonendamago8an ke ijinagozian.” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Apitc Jesos ka ick8a anim8egobanen, pejig Coda8innin ka nagadjitonigobanen inakonige8inan ogi nd8e8emigon kidji pi nda 8isinidj omigi8aminikag. Jesos dac ki pidigegoban, midac ka iji onabidj kidji 8isinidj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Aa Coda8inni ka nagadjitogobanen inakonige8inan ogi mamakadendanaban e 8abamadjin Jesosan ega e nosoneamindjin aiamie inakonige8ini osa mega ka8in 8e8enda odji kizindjisi8an ab8amaci 8isinindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ka Tibendjigedj dac ogi inan: “Mi enadizieg kina8a Coda8innig ka nagadjito8egon inakonige8inan! Ag8adjik mega eta inekena kikizisibadona8an kidonagani8an acitc kiminik8anagani8an. Pekic dac kidei8akag mi eta kidji kimodieg acitc kidji madjakamigizieg eji midonendameg. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ka8in kegon kinisidotasina8a! Kije Manido ogi kijendan mizi8e kia8i8a, ag8adjik inekena acitc kidee8a. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kida mina8ag ka kidimagizi8adj midjim ka ateg kidonagani8akag, misa dac maiagotc kiga paiekideem.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kiga kitci madji iji8ebizim, kina8a Coda8innig ka nagadjito8egon inakonige8inan! Kitci 8e8enda kinosoneana8an nandam aiamie inakonige8inan, e mineg Kije Manido pejig e taso midatcigin kitiganan kagi ma8adjito8egon. Anic dac ka8in kik8aiakozisim acitc ka8in enigokodeeieg kisagiasi8a8a Kije Manido. Midac iidi maia enendagozieg kidji todamegoban, ega dac acitc kidji 8anikeieg ini kodagian inakonige8inan!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kiga kitci madji iji8ebizim, kina8a Coda8innig ka nagadjito8egon inakonige8inan! Ma8adji ke iji paietenagozieg ki8i iji abim aiamiemigi8amikag. Acitc kikitci min8endana8a e anamikago8eg ka iji manenani8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kiga kitci madji iji8ebizim! Mi maia tabickotc tcibai akin ega ka kikina8adjitcigadegin ejinagozieg, midac a8iagog eji pabamose8adj iima, ega e kikendamo8adj.” Mi ka ikidodj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Pejig Coda8inni kikinoamage8inni ogi inan: “Kikinoamage8inni! E manazomad8a igi8e ka nagadjito8adjin inakonige8inan, kenina8it kimanazomijinam.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesos dac ogi nak8e8ajian: “Kiga kitci madji iji8ebizim kekina8a ka kikinoamageieg aiamie inakonige8inan! Kitci mane inakonige8inan kimina8ag a8iagog, e kitci sanagiigo8adjin kidji nosoneamo8adjin. Ka8in dac 8a8adj ki8idjiasi8a8ag kidji nosoneamo8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kiga kitci madji iji8ebizim! 8eckadj kikitci anicinabemi8abanig ogi nisa8abanin niganadjimo8innin, nogom dac kina8a kidojitama8a8ag e kitci min8acinig taji e tanaki8adj igi niganadjimo8innig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ki8abadai8em dac e min8endameg ka inakamigizi8agobanen 8eckadj kikitci anicinabemi8abanig, 8ina8a egi nisa8adjin niganadjimo8innin. Pekic dac kikitci min8acitona8a taji e tanaki8adj igi niganadjimo8innig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Mi 8edji ki 8idamagedj e kitci kagita8endag Kije Manido: ‘Niga ijinijaama8ag niganadjimo8innin acitc nidanodaganan kidji mikomijindjin. Nandam kada nisagani8i8ag acitc nandam kodagiag kada kodagiagani8i8ag,’ ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ka ako kijendag akini Kije Manido, mane ki nisagani8i8ag niganadjimo8innig. A8iagog dac nogom ka pimadizi8adj, kada pajacte8agani8i8ag egi nisagani8indjin kakina ini8e. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nitam mega Abel ki nisagani8igoban 8eckadj. Ick8eag dac, nogom ka8in 8eckadj, Zakani (Zacharie) ki nisagani8igoban, maiagotc pidigeatig kitci aiamiemigi8amikag, nasa8idj kitcit8a 8isini8aganikag taji ka iji ick8az8agani8i8adj a8esizag e pagidinigetama8agani8idj Kije Manido acitc taji ma8adji ka iji kitcit8a8endag8ag aiamiemigi8amikag. Ki8idamonom, a8iagog nogom ka pimadizi8adj kada pajacte8agani8i8ag kakina ini8e egi pi nisimagani8indjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kiga kitci madji iji8ebizim, kina8a Coda8innig ka kikinoamageieg aiamie inakonige8inan! Kigi kibaana8a mikana Kije Manidokag ka inijimog. Ka8in kina8a kidodji abadjitosina8a ii mikana. Acitc igi8e ka 8i iji madjiado8adj kigi kibicka8a8ag kidji pimose8adj.” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Apitc Jesos ka odji sagaag iima, Coda8inni kikinoamage8innig acitc igi8e ka nagadjito8agobanen inakonige8inan ogi kitci kijimigo8an. Ogi madjitona8a dac e k8ag8edjima8adjin mane kegonan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","O8i k8ag8e 8aiejima8abanin mega, kidji gi inactaona8adjin anodj egi pitci ikidondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Meg8adj ii apitc, kitci mane a8iagog ki ma8adjiidibanig. Ki mamagozideckodadibanig pepejig e taci8adj, ka apitci mane8apan. Jesos dac pinama ogi aiamian okikinoamaganan: “Iag8amig Coda8innig ka nagadjito8adjin inakonige8inan odobisidjigani8a. Kitci kimodizi8ag mega, acitc ka todamo8adj kidji 8ik8adjia8adjin kodagian ke8ina8a kidji kimodizindjin, mi maia obisidjigan ejinag8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kakina kegon ka kadjigadeg kada nag8an, acitc kakina kegon ega maci ka kikendjigadeg kada kikendjigade. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kakina kegon kagi ikido8eg ka iji kacki tibikag, kada nodjigade ka iji 8aseag, acitc kakina kegon kagi kimodji ikido8eg, kada pabibaginani8an kakina a8iagokag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ni8idji8aganag! Ki8idamonom, ka8in kosakegonig a8iagog ka kackito8adj kidji nisigo8eg. Okackitona8a kidji nici8anadjito8adj 8ia8ini, ka8in dac iaga pagi kegoni okackitosina8a kidji todamo8adj a8acamej. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kiga 8idamonom dac a8enen enendagozieg kidji koseg! Kida kosa8a Kije Manido, 8in ka kackitodj kidji nisadjin a8ian, acitc dac ka aiag macka8izi8ini kitci ickodekag kidji iji8ebinadjin. Teb8e ki8idamonom, mi aa8e enendagozieg kidji koseg!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","“Kije Manido kakina kegoni onagadjiton, 8a8adj kegoni ka kitci agacinojanig. Anic dac kina8a ma8adji kidapitenimigo8a. 8adan oo8e. Nijin somanike eta kidinada8emin nanan k8ig8icig, midac 8in Kije Manido ka8in 8a8adj pejig ini k8ig8icin o8anikanasi8an. Okikendan 8a8adj adi e tasinigin ki8ina8anisisi8an kictig8ani8akag. Ka8in sa dac kotadjikegon, na8adj mega kina8a kikitci apitenimigo8a apitc8in kitci mane k8ig8icig!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ki8idamonom, a8enenigotc ega ke cag8enimog8en kidji 8idama8adjin kodagian a8iagon ninikag e iji tibendagozidj, nin, Ka pi Anicinabe8iidizodj, kenin niga 8idama8ag Kije Manido odajeniman e tibenimag 8aa8e. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","A8enenigotc dac ke inag8en a8iagon ega e kikenimijidj, nin, Ka pi Anicinabe8iidizodj, kenin niga inag Kije Manido odajeniman ega e kikenimag 8aa8e.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“A8enenigotc ke madji mikomijig8en nin, Ka pi Anicinabe8iidizodj, kadagi kasiama8agani8i. Anic dac a8enenigotc ke maskenimag8enin Mino Manidon, ka8in kada kasiama8agani8isi.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Apitc aiamiemigi8amikag iji8inigo8eg kidji nda tibakonigo8eg kek8an nigan tibakonige8innikag kek8an ogimakag, ka8in nigod inendakegon adi ke iji nak8itamadizo8eg kek8an adi ke ikido8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mino Manido mega ii apitc kiga kikinoamago8a adi maia ke ikido8eg.” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Pejig a8iag ka iji kitci manenani8anig ka tegobanen, ogi inan Jesosan: “Kikinoamage8inni! 8idamao nidjiki8e abita kidji minijidj adi ka iji nagadamago8ag nidadaminan.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesos dac ogi nak8e8ajian: “Ni8idji8agan! A8enen kagi onabamijidj kidji onaco8edamanin kek8an kidji 8idamonagok adi ke iji madina8imadieg kidadami8a odaiman?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ogi inan dac kakina a8iagon: “Iag8a! Ka8in mojag nanada8i manetokegonin kidaimi8an! Ka8in mega e tasinigin odaiman odji pimadizisi a8iag. Misa8adj a8iag ka kitci 8anadizidj, ka8in a8acamej kin8ej kada odji pimadizisi.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Midac Jesos ka inadisokedj oo8eni e kikinoamagedj: “Nigodin pejig a8iag kitci 8anadizigoban. Otibendanabanin akin ka min8acinigin, kitci mane dac kitiganan ki madjiginon iima ka iji kitigedj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Otaji mamidonendanaban dac: ‘Adi ke todaman? Ka8in tibise ta8atesinon ke iji ato8anin nikitiganan.’ ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kiabadj dac ki taji ainendam: ‘Mi oo8e ke todaman. Niga pigobidonan nimijackogi8aman, kodagian dac niga ojitonan na8adj e micagin. Mi iima ke iji ato8anin nikitiganan acitc kodagian kegonan ka tibendamanin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Niga inidizonan dac: Kitci manedon kidaiman, kiabadj kitci mane pibon kigagi odji pimadjionan. An8ebin, 8isinin, minik8en, acitc min8endan, mi ke inidizo8an,’ ki inendam. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kije Manido dac ogi inan ini naben: ‘Kiki8ack8e! Nogom ke tibikag kiga nibonan. A8enen dac ke tibendagin kakina kegonan ka kana8endamadizo8an?’ ” Mi ka inadisokedj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jesos kiabadj ki ikido: “Mi ke ijisedj aa8e ka kitci ma8adjitamadizodj 8anadizi8inan, ega dac pekic ka ma8adjitamadizodj kidji min8abamigodjin Kije Manidon.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Mina8adj Jesos ogi inan okikinoamaganan: “Ki8idamonom dac, ka8in nigod inendakegon 8egonen ke midjieg kidji odji pimadizieg, kek8an adi ke ijio8eg kia8i8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Na8adj mega apitendag8anodok pimadizi8in apitc8in midjim, acitc na8adj apitendag8anodok kia8i8a apitc8in kegojic. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kana8abamikog kakagig. Ka8in kitigesi8ag, acitc ka8in oma8adjitosina8an kitiganan kagi kitige8adj, acitc ka8in tag8asini ke iji asadjigo8adj. Misa8adj dac Kije Manido odacaman. Na8adj kina8a kidapitendagozina8adok apitc8in igi pinecijag! ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","A8enen aa e tacieg keckitodj kidji pagojatodj opimadizi8in e kitci 8a8anendag inigik kiabadj ke pimadizidj? ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kicpin dac ega 8a8adj kackito8eg kegon kidji todameg ani8ag kidji pimadizieg, adi 8edji kitci mamidonendamegon kodagian kegonan?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Kana8abadamokon 8abig8anin cibeckodeg adi ejigigin. Ka8in mikimomagasino8an acitc ka8in ojitamadizomagasino8an kegojican. Kidininom dac, misa8adj kitci ogima Sanamo (Salomon) egi aiagin ka kitci sanaganigin kegojican, ka8in iaga pejig apitci kitci min8acisini okegojiciman ka apitci min8acinigin ini 8abig8anin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kije Manido iidi omin8acitonan mijackoni, nogom cibeckodeg ka nta8iginigin, acitc ne8ad 8abanig ke madjocte8ebinigadenigin ickodekag. Kana a8acamej kekina8a kiga odji kana8abamigosi8a Kije Manido kidji 8a8epinigo8eg? Kotadji agacinoja eji teb8etameg!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Ka8in dac apanigotc animendakegon 8egonen ke midjieg kek8an 8egonen ke minik8eieg. Ka8in nigod inendakegon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mi mega igi8e ega ka teb8eta8a8adjin Kije Manidon apanigotc ka nanada 8abadamo8adjin kakina ini kegonan. Kina8a dac 8in, Kidadami8a okikendan e nda8endamegon ini kakina kegonan kidji pimadjio8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Tiegodj pinama mamidonendamok Kije Manido Odogima8i8in, misa dac kiga minigo8a ini kegonan kegi nda8endamegon.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ka8in kotadjikegon, kina8a ninikag ka iji tibendagozieg. Kije Manido mega ki onendam kidji kikendamonigo8eg kidji teieg kekina8a Odogima8i8inikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ada8eok kidaimi8an, acitc mijikog ini conian ka kidimagizi8adj. Ojitamadizok dac conia8ajan ega 8ikad ke ick8a abadagin, e ma8adjitamadizo8eg 8anadizi8inan 8ak8ig ka tag8agin. Ini8e dac 8anadizi8inan apanigotc iima kada tag8anon. Iima dac, ka8in kadagi kimodisi8ag kimodi8innig, acitc mandjocag ka8in oga kackitosina8a kidji 8anadjito8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ka iji tag8ag mega ki8anadizi8ini8a, mi acitc kidee8a iima eji tag8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mojag eco8iok kidji anokita8eg Kije Manido. 8e8enda dac kitcipizok acitc 8asakonendamadizok. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Todamok tabickotc anokitage8innig ka pia8adjin okackami8an kidji koki tag8icinindjin omigi8aminikag, ka iji magocani8anig e niba8inani8anig ke odosendjin. Apitc dac tag8icinindjin acitc ke mad8e papa8aamindjin, teci8ag oga cenama8a8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kada mino iji8ebizi8ag igi8e anokitage8innig e mikago8adjin okackami8an e taji pio8adj, ega e taji niba8adj. Teb8e ki8idamonom, kada meckodjikonae aa kacka, tabickotc anokitage8inni kidji ijiodj, acitc oga nd8e8eman odanokitage8inniman kidji 8isinindjin acitc 8in tibina8e oga acaman. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kicpin abitatibikanig kek8an na8adj 8ikad tag8icig aa kacka, acitc mika8adjin odanokitage8inniman e piigodjin ega e taji nibandjin, kada kitci mino iji8ebizi8an ini anokitage8innin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","K8ag8edjitaok kidji nisidotameg oo8e. Aa a8iag ka tibendag migi8amini ka8in okikenimasi8an anapitc ke odisigodjin kimodi8innin. Kicpin dac kikenimapanin anapitc ke odisigodjin, oga nagadjian ega kidji kimodji pidigendjin omigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Eco8iok dac kekina8a. Aa mega Ka pi Anicinabe8iidizodj kitci kaiezigotc kada odji tag8icin, maia apitc ega odji pejig e pieg.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pien dac ikido: “Jesos! Kidadisoke na nina8it eta kidji kikinoamaojiag, kek8an kakina a8iagog kidji kikinoama8ad8a?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ka Tibendjigedj dac ki ikido: “A8enen dac aa8e anokitage8inni ka teb8eiendagozidj acitc ka kagita8endagozidj? Mi aa ke igodjin okackaman: ‘Kiga nagadjiag kakina a8iagog nimigi8amikag ka anokitaoji8adj meg8adj ke tanedian. Kakina pepejig e taci8adj kiga minag midjimini eko tibise8adj apitc odji 8i 8isini8adj,’ inagani8i. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kicpin dac okackaman apitc pi ki8endjin 8abamigodjin 8e8enda e anokita8adjin, kada mino iji8ebizi aa anokitage8inni. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Teb8e ki8idamonom, okackaman oga minigon kakina odaimini kidji nagadjitodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mamidonendamok dac adi ke ijisegiban kicpin aa anokitage8inni odji inendagiban oo8eni: ‘Kin8ej kiabadj kada inedi nikackam.’ Omiganan dac kodagian o8idji anokitage8inniman, naben acitc ik8e8an, acitc kitci 8isini, acitc minik8e pinici kidji ki8ack8ebidj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kegapitc dac nigodin kada tag8icino8an okackaman, apitc ega pabajine piadjin, ka8in mega okikendasin adi ke ijigijiganig kek8an ke taso tibaiganeanig apitc ke tag8icinindjin. Aa dac kacka oga kitci sogacte8an ini anokitage8innin, pejig8an ako e toda8adjin adigotc ini8e anokitage8innin ega k8aiak ka 8i mikimondjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Anokitage8inni ka kikendag adi eji nda8endamindjin okackaman, pekic dac ega kegoni e todag acitc ega e ndotag, kada kitci pajacte8agani8i. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kicpin dac anokitage8inni ega kikendag adi eji nda8endamindjin okackaman, acitc anodj inakamigizidj, pagi eta kada pajacte8agani8i. Aa mega ka kitci ca8enimagani8idj, Kije Manidon onada8enimigon kidji mino anokita8adjin. Kicpin dac a8acamej ki kitci ca8enimagani8idj, panima a8acamej kada anokitage.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nigi pi sakaa8e ooma akikag, acitc aja nikitci nda8endan kidji taji piskaneg! ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Niga sigaadazonan, e nanekadjiigo8an dac, mi ke odji sigaadazo8an. Nikitci kodagito pinici kidji ick8a cabockaman. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ka8in inendakegon e pido8an pekadendamo8in ooma akig. Tiegodj ki8idamonom, nigi pi nda nenicikebinag a8iagog. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","8adan oo8e ke ijiseg. Nanan a8iagog pejig migi8amikag ka tajike8adj kada nenicikese8ag. Kada nisi8ag e madjenima8adjin ka nijindjin, acitc kada niji8ag e madjenima8adjin ka nisindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Maiagotc kada nenicikese8ag. Nabe oga madjeniman og8izisan, ockina8e dac oga madjeniman odadaman. Ik8e oga madjeniman odanisan, ik8eses dac oga madjeniman odjodjoman. Ik8e oga madjeniman onaaganik8eman, aa dac naaganik8e oga madjeniman ozigosan.” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Mi acitc Jesos ka inadjin kakina a8iagon: “Apitc ako 8abadameg e pidanak8ag nigabianog, teci8ag kidikidom: ‘Kada kimi8an,’ acitc mi ejiseg. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Apitc ca8anino8eg, kidikidom: ‘Kada kitci kijide,’ midac iidi ejiseg. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kikitci kimodizim! E kana8abadameg aki, acitc 8ak8ig e kijigabadameg, maiagotc kikackitona8a kidji odji kikendameg adi ke ijigijigag. Adi dac 8edji ega kackito8eg kidji nisidotameg adi 8a ikidomagag oo8e eji8ebag nogom?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“8egonen 8edji ega nisidotameg adi ke iji k8aiak8adiziegoban? ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mamidonendamok oo8e. Kicpin a8iag inactaonik egi madji toda8adj, acitc ani 8idjiok tibakonige8igi8amikag e ijaieg, kitci nanada8i todan kidji gi 8a8ejibido8an ii, ab8amaci kidji oditameg. Kicpin mega ega mikidaman ii, kiga iji8inig nigan tibakonige8innikag, tibakonige8inni dac kiga pagidenimig takoni8e8innikag, acitc takoni8e8inni kiga kibaog kibaodimigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ki8idamonom dac, ka8in kiga sagaasi iima, pinici kidji ick8a kijikazo8an ick8eag somanike inigik ka inendagozian kidji kijikazo8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ii apitc, nandam a8iagog ogi pi nda 8abama8abanin Jesosan kidji mikodama8a8adjin ini8e a8iagon Pilat kagi anokigobanen kidji nisimagani8indjin, Galilee akikag ka odjinigobanen. Ki nisagani8i8agoban kitci aiamiemigi8amikag, meg8adj e pagidinigetama8a8agobanen Kije Manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesos dac ogi inan: “Kidinenima8ag na igi8e kagi nisagani8i8adj, 8ina8a ma8adji ki kitci patado8inni8i8ag apitc8in kodagiag a8iagog Galilee ka odji8adj? ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ki8idamonom, ka8in iidi ki ijisesinon. Kina8a dac, kicpin ega an8endizo8eg, kiga nibom kakina, tabickotc 8ina8a. ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Acitc igi8e ka midatcin acitc nianenio8adj (18) a8iagog kagi abidjickago8adj ka kitci icpanig migi8amini e pagisinig pecodj Silo8e (Siloé) sagaiganikag, na8adj na a8acamej madjakamigizibanig apitc8in kakina kodagiag a8iagog Jerusalemikag ka tajike8agobanen kidinenima8ag? ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ki8idamonom, ka8in teb8e ii. Kina8a dac, kicpin ega an8endizo8eg, kiga nibom kakina, tabickotc 8ina8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesos dac ki kikinoamage e adisokedj: “Nigodin pejig nabe odaia8abanin minatigon okitigan akikag. Nanigodin dac opi nadji8idonabanin minan, ka8in dac 8ikad ododji mikasinan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ogi inan dac odanokitage8inniman ka mikidamindjin okitigan aki: ‘Kana8abam aa8e minatig. Aja nisopibon ka8in maci nta8igisino8an minan. 8egonen 8edji anica padakicig ooma? Kickigao!’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Aa anokitage8inni ogi nak8e8ajian: ‘Kiabadj pejigopibon kodjii. Niga monaan aki 8ajagam, midac niga aton mictozomo. ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ne8ad dac mina8adj nibinig kada mini8i. Kicpin ega nta8iginigin minan, kiga anonijinan kidji kicka8ag.’ ” Mi ka inadisokedj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nigodin e aiamie kijiganig, Jesos kagik8egoban Coda8inni aiamiemigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Pejig ik8e teban iima e akozidj. Midatcin acitc nianeniopibon aja inigik okigickagobanin madji manidon, mi 8edji ki nepidji piskikagobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Apitc Jesos ka 8abamadjin, ogi nd8e8eman acitc ogi inan: “Ka8in aja kiga akozisi.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ogi saminan dac ini ik8e8an. Midac teci8ag ogi kackitoni kidji tajotandjin, acitc ogi icpeniman Kije Manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Aa8e dac ka niganizidj Coda8inni aiamiemigi8amikag ogi kiji8aigobanin Jesosan egi kigeandjin ini ik8e8an e aiamie kijiganig. Ogi inan dac a8iagon iima ka tendjin: “Nigod8asokajik ijinag8an kidji gi mikimonani8ag. Mi apitc ejinag8ag kidji pi nda kigeigo8egoban, ka8in 8in e aiamie kijigag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ka Tibendjigedj dac oo8e ogi iji nak8e8ajian: “Kikitci kimodizim! Kakina pepejig e tacieg kipagidaba8a8a mictozogi8amikag kimictozomi8a koni kimisabozomi8a, kidji iji8ineg kegi iji minik8edj e aiamie kijiganig, kana? ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Aa dac ik8e, Abanaam (Abraham) pejig odanike ojisan, madji manidon ogi tibenimigon midatcin acitc nianeniopibon inigik. Kana inendagozisigoban kidji pagidinagani8idj kidji kigedj meg8adj e aiamie kijiganig?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kakina ka madjenima8apanin ki kitci agadji8ag egi nak8e8ajitagendjin Jesosan. Kakina dac kodagiag a8iagog ki kitci min8endamog egi 8abadamo8adj ka kitci mamakazinag8anigin kegonan kagi todamindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesos dac mina8adj ki ikido: “Kiga 8idamonom adi e iji8ebanig Kije Manido e ogima8idj, acitc adi ejinag8anig Odogima8i8in. ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mi oo ejinag8anig. Pejig nabe ki nda kitigegoban pejig anominesan okitigan akikag. Aa anomin ki madjigi, acitc ki ani kin8akozi tabickotc mitig. Kegapitc dac pinecijag ki pi nda 8asasonike8ag ka iji 8adik8ani8indjin ini mitigon.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesos mina8adj ki ikido: “Mina8adj dac kiga 8idamonom adi ejinag8anig Kije Manido Odogima8i8in. ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Mi maia tabickotc obisidjigan ejinag8anig, pejig ik8e kagi iji kiniga8isidodj kitci mane kapanekag, pinici kidji kitci obicinindjin mizi8e odobiziganiman.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesos ani kikinoamagegoban odenag acitc odenajicikag, Jerusalemikag e ani ijagobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Pejig a8ian ogi k8ag8edjimigon: “Tebendjigean! Kada pagi8i8ag na eta a8iagog ke ag8acimagani8i8adj?” Jesos dac ogi inan: ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nijin tag8anon ick8ademan. Enigok dac k8ag8edjitaok kidji pidigeieg ka iji agasick8ada8eag. Ki8idamonom mega, mane a8iagog oga k8ag8edjitona8a kidji pidige8adj acitc ka8in oga kackitosina8a. ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Apitc aa ka tibendag migi8amini pazig8idj acitc kidabikaag ii ick8ademini, ag8adjik kina8a kiga tem. Kiga papakiteana8a ick8adem acitc kiga ikidom: ‘Cebidaok! Cenamaocinam!’ Midac kiga nak8e8ajiigo8a: ‘Ka8in kikikenimisinonom adi 8edjieg.’ ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Midac kiga ikidom: ‘Kigi 8idji 8isinimigo acitc kigi 8idji minik8emigo. Kigi kikinoamage nidodenaminakag.’ ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kiabadj dac kiga igo8a: ‘Ka8in kikikenimisinonom adi 8edjieg. A8as 8edi ijaok, kina8a ka nta madji inakamigizieg.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Mi iima ke taji ma8ieg acitc ke iji mamad8eabideckaieg, apitc 8abameg8a Abanaam (Abraham), Aisik (Isaac), Tcekap (Jacob) acitc kakina niganadjimo8innig ka te8adj iima Kije Manidon Odogima8i8inikag. Kina8a dac ka8in kiga pidigeigosim. ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mane a8iagog 8abanog, nigabianog, ki8edinog, acitc ca8anog ka odji8adj kada pidige8ag Kije Manidon Odogima8i8inikag acitc kada iji abi8ag ka iji magocani8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Midac nandam a8iagog nogom ick8eag ka te8adj, nigan kada te8ag, acitc dac nandam nogom nigan ka te8adj, ick8eag kada te8ag.” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Meg8adj ii8e e taji ikidogobanen, nandam Coda8innin ka nagadjitonigobanen inakonige8inan ogi pi nda 8abamigon Jesos. Ogi igon dac: “Kida madja ooma, acitc anodj 8edi kida ija. Herod mega 8i anoki kidji nisigo8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesos dac ogi nak8e8ajian: “A8i 8idamaok aa ka kitci 8agackizidj: ‘Ogajigag acitc 8abag niga sagidjinija8ag madji manidog acitc niga kigeag ka akozi8adj. Ki nisogonagag dac, niga kijiton nimikimo8in,’ kiga ina8a. ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Mi panima misa8adj ki ani madjaian ogajigag, 8abag acitc a8as8abag. Ka8in mega ijinag8asinon anodj kidji iji nisagani8idj niganadjimo8inni, mi eta Jerusalemikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Kina8a Jerusalemikag ka tajikeieg! Kinisa8ag niganadjimo8innig acitc kipabim8asinaa8ag pinici kidji niseg8a igi8e Kije Manidon kagi pidjinijaogo8adjin! Mojag nigi kitci nda8endanaban kidji ma8adjiinagok pecodj ninikag, tabickotc pakaak8an ka ma8adjiadjin opakaak8anesiman cegodj omig8anakag. Ka8in dac kidodji iji nda8endasina8a. ");
INSERT INTO alqALGNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Midac ii ke odji nagadag Kije Manido kidodenami8a, ka8in aja oga nagadjitosin. Ki8idamonom oo8e, ka8in mina8adj kiga 8abamijisim pinici kidji odjitciseg kidji ikido8eg: ‘Ca8endagozi aa8e ka Tibendjigendjin ka pidjinijaogodjin.’ ” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nigodin e aiamie kijiganig Jesos ki nda 8isinigoban pejig ka niganizindjin Coda8innin ka nagadjitonigobanen inakonige8inan omigi8aminikag. A8iagog iima ka te8agobanen okitci nagadjia8agoban Jesosan adi ke inakamigizindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Pejig nabe e kitci pagigadegobanen e akozidj tajigaba8igoban nigan Jesosikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesos dac ogi k8ag8edjiman Coda8inni kikinoamage8innin acitc ini8e ka nagadjitonigobanen inakonige8inan: “Kipagidinigonanan na kidinakonige8inanan kidji kigeaiak a8iag e aiamie kijiganig, kek8an ka8in?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ka8in dac odji kidosi8ag. Jesos dac ki iji k8ekigaba8i kidji kana8abamadjin ini ka akozindjin. Ogi kigean acitc ogi inan kidji ki8endjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Midac ka inadjin kodagian a8iagon: “Kicpin pejig e tacieg og8izisan kek8an omictozoman podazig8esendjin ka iji kitci 8anakamiganig, kana teci8ag onada 8ik8adjiasi8an, misa8adj e aiamie kijiganig?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ka8in dac ododji kackitosina8a kidji nak8e8ajia8adjin ii kagi igo8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesos ogi odji pabiziskina8abanin ini8e ka nd8e8emagani8indjin kidji 8isinindjin ma8adji nigan e iji onabiidizondjin. Ogi inan dac oo8e e adisokedj: ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Apitc nd8e8emigo8an kidji 8isinian e niba8inani8ag, ka8in ma8adji nigan tesabi8agan iji nda abiken. Ne8ad pejig a8iag na8adj e apitendagozidj apitc8in kin ki nd8e8emagani8idok. ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Aa8e dac kagi nd8e8emigo8eg e midjinijieg, kiga pi nda 8abamig acitc kiga inig: ‘Mij kidji abidj iima.’ Mi panima kin kiga a8i abinan ick8eag tesabi8aganikag odakanag, acitc kiga kitci agadjinan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Tiegodj, kicpin nd8e8emigo8an, ick8eag tesabi8agan iji nda abiidizon. Midac apitc tag8icig aa8e kagi nd8e8emik, kiga inig oo8e: ‘Ni8idji8agan! Na8adj ka peconag8ag tesabi8agan iji abin.’ Kakina dac a8iagog kagi nd8e8emagani8i8adj kiga 8abamigog adi epitci apitenimigo8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kakina mega a8iag ka icpenimidizodj, kada tabasendagozi, acitc dac kakina a8iag ka tabasenimidizodj, kada icpendagozi.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesos dac ogi inan ini naben kagi nd8e8emigodjin: “Apitc kitci magocean kimigi8amikag, e abitakijigag kek8an e onag8icig, ka8in nd8e8emakenig ki8idji8aganag, kidjiki8eg, kitcina8emaganag acitc ka 8anadizi8adj pecodj ka tajike8adj kimigi8amikag. 8intami8a mega kiga nd8e8emigog, midac kiga koki ki8e minigo kagi iji migi8eaban. ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tiegodj, apitc 8i magocean, nd8e8emik ka kidimagizi8adj, ka makizi8adj, ka atci8icka8adj, acitc ega ka 8abi8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kiga kitci ca8endagozinan dac. Ka8in mega 8ina8a oga kackitosina8a kidji koki ki8e minik8a. Kiga kijikago dac apitc abidjiba8adj igi8e ka k8aiak8adizi8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Apitc ka ick8a nodag adi ka ikidondjin Jesosan, pejig a8iag e taji 8idji 8isinimagobanen ogi inan: “Ca8endagozi aa a8iag ke 8isinidj ka iji magocani8anig Kije Manidon Odogima8i8inikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesos dac ogi inan: “Nigodin pejig nabe odojitonagoban kidji kitci magocani8anig. Mane dac a8iagon ogi nd8e8eman. ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Apitc e odjitcisenig kidji 8isini8adj, ogi ijinija8an pejig odanodaganan kidji nda 8idama8andjin ka nd8e8emadjin: ‘Pijaok! Aja kada 8isinani8an.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ini dac ka nd8e8emadjin pepejig ki ikido8an ega kidji kackitondjin kidji pijandjin. Nitam ka 8idama8agani8idj kidji pijadj ogi inan ini anodaganan: ‘Nogom maia nigi odapinan pejig kitigan aki, panima dac ki nda 8a8abadaman. Ka8in dac niga kackitosin kidji pijaian. Kipagosenimin ega nigod kidji inenimijian.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Mina8adj dac kodagian ogi igon: ‘Nogom maia nigi odapinag midatcin mictozog. Panima dac ki nda kikenimag8a epitci minozi8ag8en. Ka8in dac niga kackitosin kidji pijaian. Kipagosenimin ega nigod kidji inenimijian.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Mina8adj dac kodag ka nd8e8emagani8idj ki ikido: ‘Nogom maia nigi iji niba8inan. Megadacta 8edji ega kackito8an kidji pijaian.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Aa anodagan ki koki ki8e acitc ogi 8idama8an okackaman kagi ikidonipanin ini ka nd8e8emagani8indjin. Ki kiji8azi aa nabe apitc ka nodagedj ii. Ogi inan dac odanodaganan: ‘8ibadj sada ijan mikanakag acitc ka iji ma8adjiidinani8ag odenakag. Nanada 8abamik iima ka kidimagizi8adj, ka makizi8adj, ega ka 8abi8adj, acitc ka atci8icka8adj.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Apitc ka koki pi ki8edj aa anodagan, ogi inan okackaman: ‘Kacka! Aja ki todjigade kagi ikido8an, kiabadj dac ta8ate kidji abinani8ag.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Midac ka inadjin odanodaganan aa kacka: ‘Ijan 8edi ag8adjik odenag. Nanada 8abamik a8iagog mikanakag acitc pecodj kitigan akikag. Kadjinijaok dac igi a8iagog kidji pi pidige8adj, kidji gi mockinani8ag nimigi8amikag,’ ogi inan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ki8idamonom dac, igi8e nitam ka nd8e8emagani8i8adj, ka8in 8a8adj pejig e taci8adj kada pi nda 8isinisi8ag ka iji magocani8anig.” Mi ka inadisokedj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kitci mane a8iagon onosoneogobanin Jesos. Ki k8ekigaba8i dac acitc ogi inan: ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“A8enenigotc 8a paba 8idjiojidj, panima na8adj niga sagiig apitc8in ka apitci sagiadjin odadaman, odjodjoman, okokomiman, odabinodjijiman, oseezan, omisezan, ocimejan, kek8an ka apitci sagiidizodj. Kicpin ega iidi iji sagiijidj, ka8in nigagi nosoneogosi. ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","A8enenigotc ega pimi8inadjin otcibaiatigoman acitc ega ijadj adigotc ke ija8ag, ka8in nigagi nosoneogosi.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Kicpin pejig ka tacieg 8i ojitodj kitci migi8amini, pinama kada abi kidji agidag adi inigik ke inagidag8anig, kidji nda kikendag kicpin ke apitci tibiseg8en conian kidji gi kijitodj omigi8am. ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kicpin dac madjitodj, ega dac kacki kijitodj ii omigi8am kagi madjitodj, kakina a8iagon ka 8abamigodjin oga papiigon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Kada ikido8ag: ‘Aa nabe ogi madjiton kidji migi8amikedj, ka8in dac okackitosin kidji kijitodj!’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Kicpin kitci ogima midatcin kitci midasomidana (10 000) cimaganican aia8adjin, 8i miganadjin kodag kitci ogiman nijidana kitci midasomidana (20 000) cimaganican dac 8in aia8andjin, kada abi pinama kidji mamidonendag kicpin ke apitci kackitog8en kidji cagodjiadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kicpin dac inendag ega kidji kackitodj, oga madjinija8an nandam a8iagon kidji nagicka8andjin kodag kitci ogiman, meg8adj kiabadj 8asag e tendjin. Igi dac a8iagog oga k8ag8edjima8an adi eji nda8endamindjin ega kidji migadi8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Midac pejig8an ka 8idamonagok oo8e. Ka8in pejig e tacieg nigagi nosoneogosi kicpin ega pagidinag kakina ka tibendag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Kitci mino abadan ako ci8itagan. Anic dac, kicpin ani ijiseg ci8itagan ega kidji ci8itaganipog8ag, adi dac kegi todjigadegiban kidji koki ci8itaganipog8ag? ");
INSERT INTO alqALGNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ka8in odji pejig aja min8acisinon kidji abadjitcigadeg kitigan akikag, kek8an mictozogatcikag kidji gi atcigadeg, nanage kidji gi abadjitcigadeg ii mictozogatci kitigan akikag. Sagidji8ebinigade dac ii ci8itagan. Kakina kina8a keckito8eg kidji nisidotameg, 8e8enda ndotamok.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nandam ka ma8adjia8adjin conian kitci ogiman odji acitc kodagiag madji a8iagog ka inenimagani8i8adj ogi nazika8a8an Jesosan kidji ndota8a8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Coda8innig ka nagadjito8agobanen inakonige8inan acitc Coda8inni kikinoamage8innig, ka8in odji min8endasi8agoban. Ki ikidobanig: “Aa nabe okitci min8eniman e 8idji8adjin a8iagon ka madji inadizindjin, acitc o8idji 8isiniman.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jesos dac ki adisoke oo e kikinoamagedj: ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Mamidonendamok oo8e. Pejig ii ka tacieg aia8adjin midasomidana (100) mantcenican, odji 8aniadjin dac pejig, teb8e oga naganan kodagian ka cagidasomidana acitc cagidatcinindjin (99) omantceniciman cibeckodeg, kidji a8i nanada 8abamadjin ini8e kagi 8aniadjin, pinici kidji mika8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Apitc dac mika8adjin, maiagotc kitci min8endam. Pidjinige ini omantceniciman acitc ki8e omigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Apitc dac teg8icig omigi8amikag, onad8e8eman o8idji8aganan acitc ini8e pecodj ka tajikendjin acitc odinan: ‘Pijaok! 8idji modjigendamomicik! Nigi mika8a mega nimantcenicim kagi 8aniagiban.’ ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mi pejig8an ki8idamonom, na8adj kada min8endamog icpimig ka te8adj apitc pejig eta ka patadidj a8iag odji an8endizodj, apitc8in cagidasomidana acitc cagidatcin a8iagog ka mino inadizi8adj, ‘Ka8in mamakadj niga an8endizosimin’ ka inenimidizo8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Kek8an mamidonendamok oo8e. Pejig ik8e aia8adjin midatcin coniasan ka kitci agidagozindjin, pejig dac odji 8aniadjin, kana oga sakaasin 8asakonendamagani, acitc kana kada 8ebaigesi omigi8am, 8e8enda e nanada 8abamadjin pinici kidji mika8adjin? ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Apitc dac mika8adjin, onad8e8eman o8idji8aganan acitc ini8e pecodj ka tajikendjin acitc odinan: ‘8idji modjigendamomicik! Nigi mika8a mega conias kagi 8aniagiban.’ ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mi pejig8an ki8idamonom, min8endamo8an Kije Manido odajeniman apitc pejig ka patadidj a8iag odji an8endizodj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kiabadj Jesos ki inadisoke: “Pejig nabe nijibanin og8izisan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ocimejima ogi inan odadaman: ‘Nidadam! Adokam minicin kidaiman ka inendagozian kidji aiamanin ick8a nibo8an.’ Ki minagani8i dac.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Ka8in kin8ej ick8a ii, aa ockina8e ki ada8e odaiman kagi minigodjin odadaman. Midac ka iji madjadj kitci 8asag kodag akikag. 8edi dac ki kitci madji ijitcige acitc kakina ogi tcaginan oconiaman. ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Apitc kakina ka ick8a tcaginigedj, ki kitci pakadani8an iima akig kagi ijadj, acitc ke8in ki madji nodese midjimini. ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ogi nda 8abaman dac pejig a8ian iima ka tajikendjin kidji anokita8adjin, acitc ogi ijinijaogon odakinikag kidji nda kana8enimadjin kokocan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","O8i midjinaban dac aja kokocan omidjimimini epitaskadegobanen, ka8in dac a8ian ododji minigosin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Kegapitc ogi odji mamidonendan. Ki inendam dac: ‘Kakina nidadam odanodaganan kitci ag8aiadj midjimini odaiana8a, acitc 8a8adj kitci ickose8ag. Nin dac ooma nikitci mamida8askade. ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nda8adj dac niga ki8e nidadamikag, midac ke inag: Nidadam! Nigi kitci madji toda8a Kije Manido acitc kekin kigi kitci madji todaon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ka8in tibise niminozisi kig8izis kidji inenimijian. Pejig dac kidanodagan kida inenimijinan.’ ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Midac ka iji ki8edj odadamikag.” “Meg8adj dac kiabadj e na8inagozidj, odadaman ogi 8abamigon acitc ogi kitci kidimagenimigon. Ogi nda nagickagon dac e pimibatondjin, acitc ogi 8e8aginigon e odjimigodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Midac aa ockina8e ogi inan: ‘Nidadam! Nigi kitci madji toda8a Kije Manido acitc kekin kigi kitci madji todaon. Ka8in dac tibise niminozisi kig8izis kidji inenimijian.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Odadaman dac ogi inan odanodaganan: ‘8ibadj! Pidaok ma8adji ka min8acinig pitcikonaani, acitc pizikamodinik. Nabindjipizonan mijik, acitc pitakizineik. ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pijiok mictozoc ma8adji ka kitci adjibodj acitc nicik. Min8endadan acitc magocedan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nig8izis mega ooma ka tedj, ki nibo kagi inenimagiban, ki koki pimadizi. Ki 8anicinoban, acitc dac nigi koki mika8a,’ ki ikido. Midac ka iji kitci magocani8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Meg8adj dac ii, oseezima ki odji tag8icinogoban cibeckodeg e odosepan. Apitc dac e ani pec8abadag omigi8am, ogi odji nodanagoban e mad8e nodag8atcigani8anig acitc e mad8e niminani8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Pejig dac anodaganan ogi pibagiman, acitc ogi k8ag8edjiman adi eji8ebanig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ini anodaganan ogi igon: ‘Kicimej ki pi ki8e! Kidadam dac ki anoki kidji nisagani8indjin mictozocan ma8adji ka adjibondjin, egi koki mika8adjin og8izisan e mino pimadizindjin.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ki kitci kiji8azi dac e nodag ii, acitc ka8in odji nodasi kidji pidigedj migi8amikag. Odadaman dac ki pi sagaamon e pi nda k8ag8edjimigodjin kidji pidigedj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ogi inan dac odadaman: ‘Ndotaocin! Aja maneopibon inigik kidanokitaon. Ka8in 8ikad kidodji ana8etaosinon kegon ka iji anonijian. Misa8adj dac, ka8in 8ikad 8a8adj pejig minago mantcenices kidodji minijisi kidji 8idji magocemag8a ni8idji8aganag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Aa8e dac kig8izis koki tag8icin, 8in kakina mizi8e kagi tcaginadjin kiconiaman e paba 8ictadjika8adjin ik8e8an ka madji inadizindjin. 8in dac odji kidanoki kidji nisimagani8indjin ma8adji ka adjibondjin mictozocan.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Aa dac nabe ogi inan: ‘Nig8izis! Kabena ooma ki8idji tajikemijinan, acitc kakina kegonan ka tibendamanin kin kitibendanan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Panima dac kida magocemin acitc kida min8endananan, kicimej mega ki nibo nidinenimaban, ki koki pimadizi dac. Ki 8anicinoban, nigi koki mika8a dac.’ ” Mi ka inadisokedj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesos ogi inan okikinoamaganan: “Nigodin pejig nabe e kitci 8anadizigobanen odaia8abanin pejig odanodaganan e mikidaminigobanen odaiman. Ki pi odji 8idama8agani8i dac e 8anadjitondjin odaiman ini odanodaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ka 8anadizidj dac ogi nd8e8eman ini odanodaganan acitc ogi inan: ‘Nigi nodage adi enakamigizian. Nogom ojibian mazinaiganikag adi ka inabadjiadj niconiam, aja mega nogom kisagidji8ebinin.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Aa dac anodagan ki inendam: ‘Nikackam niga sagidji8ebinig. Adi dac ke todamaban? Ka8in tibise nimacka8izisi kidji mikimo8aban kitigan akikag, acitc niga agadjinan kidji paba nanadodamaiaban kidji pimadjio8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aja dac nimikan ke todaman, a8iagog kidji pidigeiji8adj omigi8ami8akag, misa8adj ick8a sagidji8ebinigo8an ka iji mikimo8aban,’ ki odji inendam.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Midac kakina pepejig ka iji nd8e8emadjin ini8e kagi mazinaigendjin okackamikag. Ogi inan dac ini8e nitam: ‘Adi inigik mezinaama8adj nikackam?’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“ ‘Midasomidana (100) mitigo makakon inigik pimide,’ ki ikido8an.” “Aa dac anodagan ogi inan: ‘8adan oo8e kimazinaigan. 8ibadj abin, kiga ijibiige dac nanomidana (50) mitigo makakon eta inigik pimide mezinaama8adj nikackam.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Mina8adj ogi inan kodagian a8iagon: ‘Kin dac, adi inigik mezinaama8adj nikackam?’ ” “Ki nak8e8ajiagani8i dac: ‘Midasomidana (100) mackimodan kapane.’ ” “Aa dac anodagan ogi inan: ‘8adan oo8e kimazinaigan. Kiga ijibiige dac nianeniomidana (80) mackimodan eta kapane inigik e mazinaigean.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Kegapitc dac aa anodagan ka 8agackizidj okackaman ogi kitci inadjimigon, ka apitci naidj kidji minobidodj aja e kitci madjisepan. A8iagog mega ega ka manadjia8adjin Kije Manidon, na8adj kitci nai8ag e 8idokodadi8adj apitc8in igi8e ka manadjia8adjin Kije Manidon.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jesos mina8adj ki ikido: “Nin dac oo8e ki8idamonom, min8abadjiik kiconiami8a ooma 8akidakamig ka aia8eg, kidji mino toda8eg8a kodagiag a8iagog. Ooma dac 8akidakamig, 8idji8aganag kiga ani aia8a8ag. Apitc dac kiconiami8a ani tcagisedj, Kije Manido kada min8endam kidji odiseg ka iji tedj, kagige kidji iji teieg.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Aa8e 8e8enda ka kana8endagin kegonan ega ka kitci apitendag8anigin, oga kana8endanan 8e8enda kitci kegonan ka kitci apitendag8anigin. Aa8e dac ka 8agackizidj apitc kana8endagin ega ka kitci apitendag8anigin kegonan, kada 8agackizi apitc kana8endagin ka kitci apitendag8anigin kegonan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kicpin dac ega 8e8enda ki inabadjito8egon 8anadizi8inan ooma akig, a8enen kegi anonigo8eg kidji kana8endamegon ini 8anadizi8inan teb8e ka kitci apitendag8agin? ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kicpin ega 8e8enda kana8endamegon kodag a8iag odaiman, a8enen kegi minigo8eg kegonan kina8a tibina8e kidji tibendamegon?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ka8in a8iag nijin kackan ogagi anokita8asi8an. Pejig mega ini8e oga madjeniman, kodagian dac ini8e oga sagian. Kek8an pejig ini8e oga anokita8an, kodagian dac ini8e ka8in oga pabiziskenimasi8an. Ka8in midjinijin kigagi anokita8asi8a8ag Kije Manido acitc conia.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nandam Coda8innig ka nagadjito8agobanen inakonige8inan ogi nodana8a adi e ikidondjin Jesosan. Ogi kitci maskita8a8an dac, osa mega okitci sagia8abanin conian. ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesos dac ogi inan: “Kina8a kikitci nda8endana8a a8iagog kidji inenimigo8eg e k8aiakozieg. Kije Manido dac kikikenimigo8a adi ejideeieg. Ini8eni8an kegonan a8iagog ka kitci apitendamo8adjin, Kije Manido 8in okitci madjendanan.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Inakonige8inan kagi ojibiamogobanen Mois, acitc mazinaiganan kagi ojitonigobanen Kije Manido oniganadjimo8inniman, ki apitendag8anon pinici kidji tag8icig Cabadis. Ka ako tag8icig dac Cabadis, tibadjimonani8an min8adjimo8in, ka odji kikendjigadenig Kije Manidon Odogima8i8ini. Kakina dac pepejig a8iag kitci nak8i kidji gi pidigedj iima Ogima8i8inikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pekic dac na8adj 8edan 8ak8i acitc aki kidji ponisegin, apitc8in kidji manibiigadenig ii8e ma8adji ega ka apitendag8anig inakonige8ini kakina kagi minigo8ak Kije Manido.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“A8enenigotc 8ebinadjin okokomiman, kodagian dac ik8e8an iji niba8idj, madji aido8ini opabamendan. Acitc aa8e ka 8idigemadjin ik8e8an egi 8ebinimagani8indjin, madji aido8ini opabamendan.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Mina8adj dac Jesos ki kikinoamage e ikidodj oo8e: “Nigodin pejig nabe kitci 8anadizigoban, acitc pitcikonaegoban kegojican ma8adji ka sanaganigin. Taso kajik magocegoban. ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pejig dac kodag nabe ka kitci kidimagizidj, Lazare ijinikazogoban. Kitci omigigoban, acitc odick8ademinikag iji pimakocinogoban ini8e ka kitci oconiamindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Odagi min8endan ki mamojagadagiban midjimini kagi odji pinagodenig iima ka oconiamindjin o8isini8aganikag. Acitc dac 8a8adj animocan osanagendjigeigobanin aa Lazare, e pi nda nanosk8adamindjin odomigi8inan.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Kegapitc ka kidimagizidj ki nibo, acitc ajenig ogi iji8ina8an 8ak8ig, pecodj Abanaamikag (Abraham) ogi iji asa8an. Ka oconiamidj dac ke8in ki nibo acitc ki naatcigadeni o8ia8. ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ka oconiamidj kitci kodagitoban iima ka iji te8adj ka nibo8adj. Ki icpanabi dac acitc 8asag ogi odji tebabaman Abanaaman acitc Lazaran e pec8abamidindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ki pibagi dac: ‘Abanaam nidadam, kidimagenimicin! Lazare pidjinijao kidji pakobindjitadj pagi acitc kidji pi pagigaga8inag nibini nidenanakag. Nikitci kodagito mega ooma ickodekag.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Abanaam dac ogi inan: ‘Nidabinodjijim! Mik8endan kitci mane egi odisigo8anin mino kegonan meg8adj e pimadiziaban. 8in dac Lazare ki kitci madji iji8ebiziban. Nogom dac Lazare kitci mina8azi, kin dac kikodagito. ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Acitc dac kitci kickanabika nina8it ka teiag acitc kina8a ka teieg. Kicpin dac a8iag 8i nda 8abamigo8eg ooma e odosedj, ka8in oga kackitosin, acitc kicpin a8iag 8i pi nazikago8ag, ka8in oga kackitosin.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ka oconiamidj dac ki ikido: ‘Abanaam nidadam! Kipagosenimin dac kidji ijinija8adj Lazare nidadaman omigi8aminikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Iima dac tajike8ag nanan nidjiki8eg. Oga nda 8idama8an dac ega kidji inakamigizindjin tabickotc nin kagi inakamigizian, ega ke8ina8a kidji pija8adj ooma ka iji kodagitonani8anig.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abanaam dac ogi nak8e8ajian: ‘Kidjiki8eg ogagi nabo8adana8a 8egonen Mois acitc niganadjimo8innig kagi ojibiamo8adj Kije Manidon Omazinaiganikag. Midac panima ki iag8aminamo8adj ii.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ka oconiamidj ki ikido: ‘Abanaam nidadam! Ka8in ii tibise. Kicpin dac a8iag ka nibodj acitc ka koki pimadizidj nda 8abamapanin nidjiki8en, kada an8endizobanin.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Midac Abanaam ka inadjin: ‘Kicpin ega 8i ndota8a8adjin Moisan acitc niganadjimo8innin, ka8in a8acamej oga teb8eta8asi8a8an a8ian, misa8adj ki abidjibandjin a8i nda 8abamigo8adjin.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesos ogi inan okikinoamaganan: “Apanigotc kada 8ikobinagani8i8ag a8iagog kidji patadi8adj. Kada madji iji8ebizi dac a8iag ka 8ik8adjiadjin kodagian kidji patadindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Na8adj kada minoseban aa a8iag kidji acodapinagani8indjin kitci asinin og8ei8akag, acitc kidji pakobi8ebinagani8idj kitcigamikag, apitc8in pejig a8ian ka agacinojanig oteb8etamo8ini kidji 8ik8adjiadjin kidji patadindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Iag8amenimidizok dac!” “Kicpin kidjiki8e patadidj, 8idamao 8e8enda. Kicpin dac an8endizodj, mi iji ponenim ka iji patadidj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kicpin madji todaok nij8atcinanaj pejigokajik, acitc tasinanaj ikidodj: ‘Nikackendan egi madji todaonan,’ mi iji ponenim.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ka Tibendjigedj Odanodaganan ogi igon: “Micaton niteb8etamo8ininan.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ka Tibendjigedj dac ogi nak8e8ajian: “Kicpin anomin ka iniginidj inigok8agiban kiteb8etamo8ini8a, kida kackitona8a kidji ineg aa8e mitig: ‘8ik8adabigitan, acitc a8i padakicimidizon kitcigamikag,’ kida ndotago8a dac.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“8adan oo8e. Pejig e tacieg odaia8an anokitage8innin e kitigendjin kitigan akikag koni e kana8enimandjin a8esizan. Apitc dac kitigan akikag odosendjin ini anokitage8innin, ka8in oga inasin: ‘Teci8ag pi nda 8isin!’ ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tiegodj oga inan: ‘Ojitamaocin kidji 8isinian. Adjikonaen kidji anokitaojian pinici nin kidji ick8a 8isinian acitc kidji ick8a minik8eian. Midac ick8ataian kigagi 8isin acitc kigagi minik8e kintam.’ ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ka8in mamakadj mig8etc oga inasin odanokitage8inniman adi ka inanonadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mi maia pejig8an kekina8a, apitc ick8ataieg kakina ka inanonigo8eg kida ikidom: ‘Nimotci anokitage8inni8imin. Nigi motci ijitamin ka inendagoziag kidji ijitaiag.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Meg8adj dac Jesos e pimi ijagobanen Jerusalemikag, ki ani nasa8icka Samani (Samarie) akini acitc Galilee akini. ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Apitc pejig odenajicikag ka ani pidigedj, midatcin a8iagon ka kitci omigi8apinendjin ogi pi nazikagon, kitci kotadendag8anoban ako ii inapine8in. Ka8in dac ododji pec8abamasi8a8an Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ki kitci madji pabibagi8ag dac: “Jesos, ka Tibeniminak! Kidimagenimicinam!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Apitc Jesos ka 8abamadjin ogi inan: “A8i 8abadaikog Coda8inni aiamie ogimag adi e ijinagozieg.” Meg8adj dac e ani ija8apan, ki kige8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pejig dac e taci8adj, apitc e kikendag egi kigegobanen, ogi koki nda 8abaman Jesosan, e kitci kiji8edj e icpenimadjin Kije Manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ki nibak8i dac acitc ki onijik8ebanio akikag, mig8etc e inadjin. Aa dac nabe Samani aki odjigoban. ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesos dac ki ikido: “Kakina midatcin e taci8adj ki kige8ag, kana? Adi dac apan kodagiag cagidatcin? ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kana kodag a8iag ogi inendasin kidji koki pijadj, mig8etc kidji inadjin Kije Manidon, mi na eta aa8e ega ka Coda8inni8idj?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Midac Jesos ogi inan ini a8ian: “Pazig8in, mi iji madjan. Kiteb8etamo8in kigi kigeigon.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nigodin Coda8innig ka nagadjito8agobanen inakonige8inan ogi k8ag8edjima8an Jesosan: “Anapitc ke 8abadamag Kije Manido Odogima8i8in?” Ogi nak8e8ajian dac: “Ka8in kadagi 8abadjigadesinon Kije Manido Odogima8i8in apitc pijamagag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ka8in kada ikidonani8asinon: ‘Kana8abadamok! Aja tag8icinomagan ooma!’ kek8an: ‘Aja tag8icinomagan 8edi!’ Kije Manido mega aja ogima8i kina8akag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ogi inan dac okikinoamaganan: “Kada ijise kidji kitci 8i 8abameg Aa8e Ka pi Anicinabe8iidizodj, misa8adj pejigokajik eta 8abamegoban. Ka8in dac kada minosesinon kidji 8abameg. ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kada ikidonani8an: ‘8edi te!’ kek8an: ‘Mi ooma e tedj!’ Ka8in dac 8edi ijakegon kidji nda 8abameg. ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mi maia tabickotc ka kitci 8asakoneseg, mizi8e dac 8ak8ig ka 8asakonemagag, mi ke ijinag8anig apitc pi tag8icig Ka pi Anicinabe8iidizodj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Panima dac ki kitci kodagitodj pinama, acitc panima ki 8ebinigodjin a8iagon nogom ka pimadizindjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Kagi iji8ebag meg8adj No8a (Noé) ka tepan, mi maia pejig8an ke iji8ebag apitc tag8icig Aa8e Ka pi Anicinabe8iidizodj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ii apitc, a8iagog 8isini8agoban acitc minik8e8agoban, acitc nabeg acitc ik8e8ag niba8i8agoban, pinici No8a kidji pidigedj kitci tcimanikag. Ii apitc ki kitci kimi8an pinici kidji kitci nikibinig, acitc kakina igi8e a8iagog ki nisaba8e8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Mi pejig8an ka iji8ebag apitc Lot ka pimadizipan. A8iagog 8isini8agoban acitc minik8e8agoban. Odapinige8agoban acitc ada8e8agoban. Kitige8agoban acitc migi8amike8agoban. ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Apitc dac Lot ka nagadamogobanen Sodom odenani, ki papagisin ickode ka kitci oza8abateg acitc ka kitci kotazomateg akikag, midac kakina ki nici8anadjio8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Mi maia pejig8an ke iji8ebag apitc pi nagozidj Aa8e Ka pi Anicinabe8iidizodj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ii kijigag aa8edi 8agidabak8an omigi8amikag ke teg8en, ka8in kadagi pidigebatosi kidji a8i nda 8abadagin odaiman. Mi pejig8an, aa8e okitigan akikag ke teg8en, ka8in kadagi koki ki8esi. ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mik8enimik ka ijisendjin Lot okokomiman. ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Aa8e ka 8i kana8endag opimadizi8in kada nibo, aa8e dac pekic ke nibog8en, oga pimadjiton opimadizi8in. ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ki8idamonom, meg8adj ii e tibikag, kada nijog8amo8ag a8iagog. Pejig dac kada madji8inagani8i, kodag dac kada naganagani8i. ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nijin ik8e8ag ma8asag kada tcibak8e8ag. Pejig dac kada madji8inagani8i, kodag dac kada naganagani8i. ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nijin nabeg kitigan akikag kada mikimo8ag tabickotc. Pejig dac kada madji8inagani8i, kodag dac kada naganagani8i.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jesos dac okikinoamaganan ogi k8ag8edjimigon: “Tebendjigean! Ataji dac ii ke iji iji8ebag?” Jesos dac ogi nak8e8ajian: “Taji ke iji tanatenig8en o8ia8 a8esiz kagi nibodj, mi iima ke iji ma8adjiidi8adj kakagig.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesos ki adisoke oo8e kidji kikinoama8adjin okikinoamaganan kabena kidji aiamiendjin, ega dac kidji ana8endjigendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ki inadisoke dac: “Teban pejig odenakag tibakonige8inni, ega e manadjiadjin Kije Manidon acitc ega a8ian e kidimagenimadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Teban acitc iima odenakag e pejigodj ik8e e nta nda 8abamapanin ini tibakonige8innin e pagosenimadjin: ‘8idjiicin kidji cagodjiag ka k8ag8e madjiseijidj.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Aa tibakonige8inni kin8ej ka8in ododji iji nda8endasin. Kegapitc dac ki inendam: ‘Teb8e ka8in nimanadjiasi Kije Manido acitc ka8in a8iag nikidimagenimasi. ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Misa8adj dac nidaieko8ig aa ka pejigodj ik8e. Niga 8idjia dac kidji 8ik8adjitama8ag adi eji nda8endag. Kicpin mega ega iidi todaman, apanigotc niga pi nda 8abamig, pinici kidji nickiijidj,’ ki inendam.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kiabadj dac ka Tibendjigedj ki ikido: “Ndotaok aa madji tibakonige8inni adi ekidodj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kije Manido dac 8in, kana oga ndota8asin ini8e kagi onabamadjin, ini8e kabena ka pagosenimigodjin meg8a kijik acitc meg8a tibik? Kin8ej na oga piton kidji 8idjiadjin? ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ki8idamonom, teci8ag oga 8idjian, adi e iji nda8endamindjin. Misa8adj dac ii, apitc koki pijaian, nin, Ka pi Anicinabe8iidizodj, niga mika8ag na a8iagog ka teb8etamo8adj ooma akikag?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesos oo8e ki inadisoke, e aiamiadjin nandam a8iagon “nik8aiakozimin” ka inenimidizondjin, ka maskenimandjin kodagian a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ki ikido: “Nijin a8iagog ki pidige8agoban kitci aiamiemigi8amikag kidji nda aiamie8adj. Pejig aa8e Coda8inni ka nagadjitodjin inakonige8inan inabadizigoban, kodag dac aa8e ka ma8adjiadjin conian kitci ogiman odji inabadizigoban 8in. ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nigan iji tajigaba8igoban aa Coda8inni ka nagadjitodjin inakonige8inan, acitc mi ekidogobanen e aiamiedj: ‘Kije Manido! Mig8etc kidinin ega nin e inadizian tabickotc kodagiag a8iagog, ka kimodi8adj, ka madji inadizi8adj, acitc ka pamendamo8adj madji aido8ini. Mig8etc kidinin ega nin e inadizian tabickotc aa8e ka ma8adjiadjin conian kitci ogiman odji. ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nijokajik taso ta8ate nipagidadjige, acitc midatcin somanike tas8abik e kackiag kiminin.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Aa dac ka ma8adjiadjin conian kitci ogiman odji, 8in odakanag iji tajigaba8igoban. Ka8in 8a8adj 8i icpanabisiban. Papakiteodizoban okakiganikag kidji 8abadai8edj e an8endizodj, acitc ki ikidoban: ‘Kije Manido! Kidimagenimicin, nin e kitci patado8inni8ian.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jesos dac ki ikido: “Ki8idamonom, ki ki8e aa nabe e k8aiak8abamigodjin Kije Manidon, ka8in dac 8in aa8e ka nagadjitodjin inakonige8inan. A8enenigotc mega icpenimidizodj, kada tabasendagozi, anic dac a8enenigotc tabasenimidizodj, kada icpendagozi.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nandam a8iagog ogi iji8ina8an 8a8adj abinodjijesan Jesosikag, kidji gi aiamit8anandjin e saminandjin. Kikinoamaganag dac ogi 8abama8an, acitc ogi kaganona8an ini a8iagon ka pidji8inandjin ini abinodjijesan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesos dac ogi nd8e8eman abinodjijan, acitc ogi inan okikinoamaganan: “Pagidinikog abinodjijag kidji pi nazikaoji8adj! Ka8in odjiakegonig. A8iagog mega tabickotc abinodjijag ka apitendagozi8adj, Kije Manidon Odogima8i8inikag kada iji tibendagozi8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Teb8e ki8idamonom, a8iag ega nda8endag Kije Manidon Odogima8i8ini, tabickotc abinodjij ke iji nda8endagiban, ka8in 8ikad oga kackitosin kidji pidigedj Kije Manidon Odogima8i8inikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Pejig Coda8inni ka niganizidj ogi k8ag8edjiman Jesosan: “Kikinoamage8inni, kin ka kije8adizian! Adi ke todamaban kidji odisigo8an kagige pimadizi8in?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesos ogi inan: “8egonen 8edji inijian e kije8adizian? Kije Manido eta kije8adizi. ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kikikendanan Kije Manido odinakonige8inan: ‘Ka8in madji aido8in kiga pamendasina8a. Ka8in kiga nici8esim. Ka8in kiga kimodisim. Ka8in anodjigotc kiga iji inactaonasi8a8a kidjipimadizimi8a. Kiga manadjia8ag kinigiigo8a.’ Mi ekidomaganigin Kije Manido odinakonige8inan.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Aa nabe ki ikido: “Kakina nigi nosoneanan ini inakonige8inan ka ako abinodjiji8ian.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Apitc Jesos ka nodag ii, ogi inan: “Kiabadj pejig kegon kinodese. Ada8en kakina kidaiman, acitc ca8enimik ka kidimagizi8adj kiconiaman, midac kidji aiamanin 8anadizi8inan 8ak8ig. Pijan dac acitc nosoneocin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Apitc dac aa nabe ka nodag ii, ki kitci kackendamise. Kitci 8anadizigoban mega. ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesos ogi 8abaman e kackendamisendjin, acitc ki ikido: “8esa kitci sanagizi8ag ka 8anadizi8adj kidji gi pidige8adj Kije Manidon Odogima8i8inikag! ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kitci sanagizi ka nijo pik8aoganedj a8esiz kidji gi cabocta8eckapan cabonigani ka iji pagoneanig, anic dac na8adj kiabadj sanagizi a8iag ka 8anadizidj kidji gi pidigedj Kije Manidon Odogima8i8inikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ini8e ka nodamindjin adi ka ikidodj ogi igon: “A8enen dac kegi ag8acimagani8idj?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesos dac ki ikido: “Kegoni a8iag ka p8ana8itodj, Kije Manido 8in okackiton.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pien dac ki ikido: “Nina8it, kakina kegon ka aiamagiban nigi nagadananan kidji nosoneogo8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesos dac ogi inan: “Teb8e ki8idamonom, kicpin a8iag nagadag omigi8am, kek8an naganadjin okokomiman, o8idjiki8en, onigiigon, kek8an odabinodjijiman, Kije Manidon Odogima8i8ini odji, ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kiabadj a8acamej oga odisigon ooma ka iji pimadiziak nogom, nage dac acitc oga aian kagige pimadizi8ini.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesos ogi madji8inan okikinoamaganan acitc ogi inan: “Ndotamok! Jerusalem kiga ijamin, teb8e kakina kidji ijiseg kagi ijibiige8adj niganadjimo8innig e mikomiji8adj, nin, Ka pi Anicinabe8iidizodj, kidji iji8ebizian. ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Niga iji8inigo ega ka Coda8inni8i8adj kidji tibenimiji8adj. Igi8e dac niga manenimigog, niga mamanazomigog, acitc niga sasik8anigog. ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Niga papajacteogog, acitc niga nisigog. Ki nisogonaganig dac, niga abidjiba8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ka8in dac odji pejig ododji nisidotasina8a adi 8a ikidondjin Jesosan. Ki kadama8agani8i8ag mega adi maia 8a ikidomaganig, ka8in dac ododji kikendasina8a adi 8a ikidondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesos acitc okikinoamaganan ogi ani pec8abadana8agoban Jeriko (Jéricho) odenani. Pejig nabe ega e 8abidj taji abigoban opimekana, e pagosenimodj conian. ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Apitc dac aa nabe ka nodag mane a8iagon e pimosendjin, ki k8ag8ed8e adi eji8ebanig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ki inagani8i dac: “Jesos, Nazaret ka odjidj, pimi ija ooma.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ki madji pabibagi dac: “Jesos! Ogima David odanike ojisan! Kidimagenimicin!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Igi8e dac ka nigani8adj ogi kaganona8abanin, acitc ogi ina8an kidji ponimondjin. Na8adj dac kiabadj ki kiji8egoban e pabibagidj: “Ogima David odanike ojisan! Kidimagenimicin!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesos dac ki kibitcigaba8i, acitc ki ikido: “Pidji8ijik aa.” Apitc dac ka pec8abamigodjin, Jesos ogi k8ag8edjiman: ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“8egonen eji nda8endaman kidji todaonan?” Aa nabe ki ikido: “Tebendjigean! Kipagosenimin kidji kigeijian kidji gi koki 8abian.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesos dac ogi inan: “Mi iji 8abin. Kiteb8etamo8in kigi kigeigon.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Teci8ag dac ogi kackitonagoban kidji 8abidj, acitc ogi nosone8an Jesosan, e icpenimadjin Kije Manidon. Apitc dac kakina a8iagog ka 8abadamo8adj adi eji8ebanig, ke8ina8a ogi icpenima8an Kije Manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Apitc ka pidigegobanen Jeriko (Jéricho) odenani, Jesos ki ani cabocta8eadogoban ii odenani. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tajikeban iima pejig nabe, Zaci (Zachée) ijinikazoban, 8in okackakanabanin mane a8iagon ka ma8adjiandjin conian kitci ogiman odji. Kitci 8anadizigoban aa. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Onanada8i todanaban dac kidji 8abamadjin Jesosan a8eneni8an ini. Kitci takozigoban, ka8in dac okackiasi8abanin kidji 8abamadjin, epitci kitci manenani8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nigan dac ki ipato acitc ki ik8ada8e mitigokag, kidji gi 8abamadjin Jesosan apitc ani iji pimosendjin iima. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ka tag8icig iima, Jesos ki icpanabi acitc ogi inan: “Zaci! 8ibadj nisada8en! Panima mega kimigi8amikag niga a8i tajike ogajigag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Teci8ag dac ki nisada8ese, acitc ki kitci min8endam e odisigodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kakina a8iagog kagi 8abage8adj, ka8in odji pejig min8endasibanig, acitc ki ikido8ag: “A8i tajike aa nabe ka madji inadizindjin omigi8aminikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaci dac ki pazig8i acitc ogi inan Jesosan: “Tebendjigean! Niga minag abita nidaiman ka kidimagizi8adj, acitc kicpin ki 8aiejimag a8iag, ni8inanaj na8adj a8acamej niga ki8e mina.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesos dac ki ikido: “Ka ogajiganig Kije Manido ogi ag8aciman kakina ka tajikendjin oo8e migi8amini. Abanaam (Abraham) mega ini odanike ojisan ke8in Zacin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nin mega, Ka pi Anicinabe8iidizodj, nigi pi nda nanada 8abamag acitc nigi pi nda ag8acimag ka 8anicino8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Aja pecodj Jerusalemikag tegoban Jesos, acitc a8iagog inendamo8agoban teci8ag kidji 8abadamo8adj Kije Manidon Odogima8i8ini. Jesos dac mina8adj ki adisokegoban, kidji gi kikinoama8adjin a8iagon kagi pi ndotamindjin odikido8inan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Midac oo ka inadisokedj: “Pejig nabe ka kitci apitendagozidj ijagoban 8edi 8asag akikag. 8i ijagoban 8edi kidji nda 8abamadjin kitci ogiman, kidji gi ogima8iigodjin odakikag, mina8adj dac kidji koki pi ki8epan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ab8amaci madjagobanen, ogi nd8e8emagoban midatcin odanokitage8inniman. Ogi minagoban dac pepejig oza8iconia8abikon acitc ogi inan: ‘Abadjiik aa conia kidji ani nta8igidj pinici kidji koki tag8icinian.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“A8iagog ka tajike8adj iima odakikag, okitci madjenima8agoban ini naben. Ogi ijinija8a8an dac nandam a8iagon kidji inandjin kitci ogiman: ‘Ka8in ninada8enimasi8anan aa nabe kidji ogima8idj ooma.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Misa8adj dac ki ogima8iagani8i, acitc ki pi koki ki8e odakikag. Ki anoki dac kidji nd8e8emagani8indjin odanokitage8inniman kagi minapanin conian, kidji nda kikendag adi inigik ka nda kackiandjin conian.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Nitam odanokitage8inniman ogi pi nda 8abamigon acitc ogi igon: ‘Kacka! Midatcin oza8iconia8abikog ani8ag nigi nda kackiag inigik kagi minijiaban.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Aa ogima ogi inan: ‘Mi iidi k8aiak! Maiagotc kimino anokitage8inni8inan! K8aiak kigi todan, misa8adj ega ka apitendag8ag kegon egi inanoninaban. Nikikendan dac kidji gi iji apacenimo8an kinikag. Kiga minin dac midatcin odenan kidji kana8abadamanin.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Mina8adj kodag odanokitage8inniman ogi pi nda 8abamigon acitc ogi igon: ‘Kacka! Nanan oza8iconia8abikog ani8ag nigi nda kackiag inigik kagi minijiaban.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Aa ogima ogi inan: ‘Kiga minin nanan odenan kidji kana8abadamanin.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Kodag dac odanokitage8inniman ogi pi nda 8abamigon acitc ogi igon: ‘Kacka! 8adan 8aa kiconiam. Nigi kackigapina nabikaganesikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kikosinaban, kikitci ak8adizinan mega. Kidodapinanan ako kegonan ega e tibendamanin, acitc kima8adjitonan ako kitiganan 8a8adj iima kodag a8iag kagi iji kitigegobanen.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Aa ogima ogi inan: ‘Kimadji anokitage8inni8inan! Niga abadjitonan kin tibina8e kidikido8inan kidji tibakoninan. Kikikenimijinaban e ak8adizian, e odapinamanin kegonan ega ka tibendamanin acitc e ma8adjito8anin kitiganan 8a8adj iima kodag a8iag kagi iji kitigepan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Adi dac 8edji ega ki asadj niconiam conia8igi8amikag? Apitc dac koki tag8icinian, nidagi 8ikobina niconiam acitc na8adj mane kadagi ik8agidagoziban.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ogi inan dac kodagian iima ka tendjin: ‘Makamik ini niconiaman! Mijik dac aa midatcin oza8iconia8abikon ka aia8adjin.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Ogi igon dac: ‘Kacka! Aja midatcin oza8iconia8abikon odaia8an!’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ki ikido dac ogima: ‘Ki8idamonom, a8iag kegoni ka aiag, a8acamej oga odisigon. Aa dac a8iag ega kegoni ka aiag, misa8adj pagi eta kegoni aiag kada makamagani8i. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Igi8e dac ka madjenimiji8adj, ega kagi nda8enimiji8adj kidji ogima8i8ag, pidji8ijikog acitc nisikog nigan ninikag!’ ” Mi ka inadisokedj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ka ick8a kikinoamagedj, Jesos ki niganicka, Jerusalem e ijadj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Apitc e ani pec8abadag Betapaje (Bethphagé) acitc Betani (Béthanie) odenajican, pecodj pik8adinajic Olip (Oliviers) ka ijinikadeg, Jesos ogi niganinija8an nijin okikinoamaganan acitc ogi inan: ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“A8i ijaok 8edi odenajicikag nigan ka tag8ag. Apitc oditameg, kiga mika8a8a pejig misabozoc e sagapizodj, ega maci a8iag egi iji 8agidabi8agedj. Pagidabaok acitc pidji8ijik ooma. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kicpin dac a8iag k8ag8edjimigo8eg: ‘Adi 8edji pakaba8eg?’ 8idamaok: ‘Ka Tibendjigedj onada8eniman.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ki madja8ag dac acitc ogi mika8a8an pejig misabozocan maiagotc Jesosan kagi igo8apanin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Meg8adj dac e taji pakaba8a8adjin, ini8e ka tibenimandjin ini misabozocan ogi igo8an: “Adi 8edji pakaba8eg aa misaboz?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ogi ina8an: “Ka Tibendjigedj onada8eniman.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ogi iji8idama8a8an dac Jesosan ini misabozocan. Ogi pakidjisidona8an opizika8agani8an 8agidj misabozocikag acitc Jesosan ogi 8agidabia8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Meg8adj e pimibaigodj, mane a8iagog ogi taj8egisidona8an opizika8agani8an mikanakag taji Jesosan ke ani ijandjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Apitc e ani pec8abadag Jerusalemini, e ani nisadji8ejimonig Olip pik8adinajicikag, ini8e ka kitci manendjin a8iagon ka nosoneogodjin ki kitci min8endamon. Ki kitci pabibagi8ag, e kitci icpenima8adjin Kije Manidon, kakina mamada8izi8inan kagi 8abadamo8adjin odji. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ki ikido8ag: “Ca8endagozi aa8e ogima Kije Manidon kagi pidjinijaogodjin! Kitcit8a8endagozi Kije Manido! Pekadendamo8ini kiminigonan!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nandam Coda8innig ka nagadjito8agobanen inakonige8inan ka te8apan ke8ina8a ka iji kitci manenani8anig, ogi ina8an Jesosan: “Kikinoamage8inni! Ijik kikikinoamaganag ega kidji pabibagi8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesos dac ogi inan: “Ki8idamonom, kicpin ega kido8adj, asinig kada pabibagi8ag!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Apitc Jesos e ani pec8abadag Jerusalem odenani, ki madji ma8igoban e 8abadag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ki ikido dac: “Kina8a, Jerusalem odenakag ka tajikeieg! 8egona sa kekina8a nisidotamegoban oo ka kijigag, pekadendamo8in kegi odji minigo8egoban! Midac nogom kikadamagom ii, ka8in kigagi 8abadasina8a! ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kada ijise mega ka madjenimigo8eg kidji 8isk8enakinigo8eg. Oga 8akackana8a kidji kibockamo8adj odenani ega kidji gi sagaameg. Oga migadana8a kidodenami8ani. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Maiagotc oga nici8anadjitona8a kidodenami8ani, acitc kakina kiga nisigom. Ka8in 8a8adj pejig asini kada ag8ita8abisi. Ka8in mega kidodji nisida8inasina8a apitc Kije Manido kagi pi k8ag8e ag8acimigo8eg.” Mi ka ikidodj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesos ki pidige Coda8inni kitci aiamiemigi8amikag, acitc ki madjita kidji sagidjinija8adjin kakina a8ian ka ada8endjin iima. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ogi inan dac: “Mazinadeni Kije Manido Omazinaiganikag: ‘Kidji iji aiamiani8ag kada inabadan nimigi8am.’ Kina8a dac, kimodi8innimigi8am kigi inabadjitona8a,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Taso kajik kikinoamageban Jesos iima kitci aiamiemigi8amikag. Coda8inni kitci aiamie ogimag acitc Coda8inni kikinoamage8innig acitc ka apitendagozi8adj iima odenakag, onanada8i kikendana8aban adi ke todamo8apan kidji gi nisa8adjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ka8in dac ododji mikasina8a adi ke odji madjita8apan. Jesos mega kakina a8iagon okitci ndotagobanin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nigodin, meg8adj Jesos e kikinoama8adjin a8iagon Coda8inni kitci aiamiemigi8amikag acitc e kagik8edj min8adjimo8ini, Coda8inni kitci aiamie ogiman, Coda8inni kikinoamage8innin, acitc ka niganizindjin Coda8innin ogi pi nazikagon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ogi igon dac: “8idamaocinam, 8egonen 8edji todamanin ini kegonan? A8enen kagi pagidinik kidji todaman ii?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesos ogi nak8e8ajian: “Mi kenin kegon kiga k8ag8edjiminom. 8idamaocik dac, ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","a8enen ka pidjinija8adjin Cabadisan kidji sigaadagendjin, Kije Manido na, kek8an a8iagog?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Igi8e dac Coda8innig ki kitci aiamiidi8ag 8ina8a tibina8e, e inidi8adj: “Kicpin nak8e8ajit8aiak: ‘Kije Manido ka pidjinija8adjin Cabadisan,’ kiga k8ag8edjimigonan: ‘8egonen dac 8edji ega ki teb8eta8eg Cabadis?’ ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kicpin dac ikido8ak: ‘A8iagog ka pidjinija8a8adjin Cabadisan,’ kakina a8iagog kiga pabim8asinaigonanag. Kakina mega ketcinamendamog e niganadjimo8inni8inipanin ini Cabadisan.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ogi nak8e8ajia8an dac Jesosan: “Ka8in nikikenimasi8anan a8enen kagi pidjinija8adjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesos dac ogi inan: “Misa dac kenin ka8in kiga 8idamaosinonom 8egonen 8edji todamanin ini kegonan.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesos mina8adj ki madjita kidji adisokedj e kikinoama8adjin a8iagon: “Nigodin pejig nabe ki kitigegoban cominici kitiganan odakikag. Ogi a8ian dac nandam kodagian kitige8innin ii okitigan aki, midac kin8ej ka iji nda pabamadizidj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Apitc ka ani odjitcisenig kidji ma8adjiagani8indjin ini cominican, aa nabe ogi ijinija8an pejig odanokitage8inniman kidji nda 8abamandjin ini a8iagon kagi a8iadjin okitigan aki, kidji a8i nadji8inandjin inigik cominican kagi inendagozinipanin kidji minigodjin. Igi8e dac kitige8innig ogi migana8an ini anokitage8innin, acitc ogi ki8enija8a8an ega kegoni e mina8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Aa dac kacka mina8adj ogi ijinija8an pejig kodagian odanokitage8inniman 8edi okitigan akikag. Igi8e kitige8innig ogi manenima8an ke8in, ogi migana8an, acitc ogi ki8enija8a8an ega kegoni e mina8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Aa kacka ogi ijinija8an kiabadj pejig kodagian odanokitage8inniman. Kitige8innig dac ogi mij8agania8an ke8in, ogi sagidji8ebina8an dac kitigan akikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Aa dac ka tibendag kitigan akini ki ikido: ‘Adi dac ke todaman? Niga ijinija8a nig8izis ka kitci sagiag. Ne8ad oga manadjia8an ini,’ ki ikido. Midac ka iji ijinija8adjin okitigan akikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Apitc dac igi8e kitige8innig ka 8abama8adjin, ki inidi8ag: ‘Mi aa ockina8e nage ke kacka8idj ick8a nibondjin odadaman. A8isa nisadan, kina8it dac kiga tibendam8anan ii okitigan aki.’ ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ogi sagidji8ebina8an dac ini ockina8en iima kitigan akikag, acitc ogi nisa8an.” “Adi dac enendameg ke toda8adjin aa ka tibendag kitigan akini? ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Mi oo8e ke todag. Kada ija okitigan akikag, oga nisan kakina ini kitige8innin acitc oga a8ian kodagian a8iagon okitigan aki.” Mi ka inadisokedj Jesos. E nodamo8adj dac ii, a8iagog ki ikido8ag: “Ka8in ninada8endasinanan iidi kidji iji8ebag!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesos dac ogi kana8abaman a8iagon acitc ki ikido: “Adi dac 8a ikidomagag oo8e ka mazinadenig Kije Manido Omazinaiganikag: ‘Migi8amike8innig ogi ana8enima8an ini asinin. Anic dac mi aa asini ma8adji ka ani kitci apitendagozidj.’ ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kada ojig8icinog kakina igi8e ke pagicino8ag8en iima asinikag, acitc kicpin pejig a8iagokag inagodjinindjin ini asinin, oga cacagockagon.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Coda8inni kikinoamage8innig acitc kitci aiamie ogimag ogi nanada8i kikendana8a adi ke todamo8apan teci8ag kidji gi takona8adjin Jesosan. Ogi kikendana8aban mega egi mikomigo8adjin apitc ii ka inadisokendjin. Pekic dac okosa8abanin a8iagon iima ka tendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Coda8inni kikinoamage8innig acitc kitci aiamie ogimag ogi kitci nagadjia8an Jesosan ke ani inakamigizindjin, acitc ogi ijinija8a8an nandam a8iagon kidji nda nagicka8andjin. Igi8e a8iagog ki k8aiakozikazo8ag. Pekic dac o8i k8ag8e katcidina8an Jesosan anodj kidji iji nak8e8ajii8endjin, kidji gi odji takona8adjin acitc kidji gi odji iji8ina8adjin kidji tibakonigondjin ini8e ka kitci ogima8indjin iima akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Igi8e dac a8iagog ogi k8ag8edjima8an Jesosan: “Kikinoamage8inni! Kikikenimigo e teb8ean acitc k8aiak e kikinoamagean. Kakina a8iagog pejig8an kidinenimag. K8aiak kikikinoamage adi ke todjigadenig 8e8enda kidji gi nosoneigadenig Kije Manido omikana. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","8idamaocinam dac, ikidomaganon na kidinakonige8inanan kidji kijika8aiak ma8adji kitci ogima Sesar (César), Rom ka tajikedj, kek8an ka8in?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesos dac ogi kikeniman ini8e a8iagon e 8i k8ag8e katcidinigodjin. Ogi inan dac: ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“8abadaicik peconias. A8enen dac aa ka mazinazodj? A8enen ii o8izon?” “Kitci ogima Sesar,” ogi ina8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesos dac ogi inan: “Mijik sa dac kitci ogima Sesar kegoni ka tibendag, acitc Kije Manido mijik kegoni ka tibendag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Meg8adj dac kakina a8iagog te8agoban iima, ka8in ododji kackitosina8a igi8e a8iagog kidji katcidina8adjin Jesosan anodj kidji pitci ikidondjin. Ogi kitci mamakazita8a8an adi kagi ikidondjin, ka8in dac kodag kegoni ododji k8ag8edjimasi8a8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nandam Coda8innig “Sadose8innig” (Sadducéens) ka ijinikanagani8i8agobanen ogi pi nazika8a8an Jesosan. Mi igi ako ega ka teb8etamo8agobanen kidji abidjibandjin a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ogi pi k8ag8edjima8an dac Jesosan: “Kikinoamage8inni! Mois kigi minigonanaban oo8e inakonige8ini: ‘Kicpin pejig nabe ka o8idigemaganidj odji nibodj, ega egi aia8adjin abinodjijan, inendagozi8an o8idjiki8en kidji iji niba8indjin okokomiman, kidji gi odabinodjijimiadjin o8idjiki8en kagi nibondjin.’ Mi ka inakonigedj Mois. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nigodin dac tebanig e nij8atci8apan nabeg e iji 8idjiki8emidi8adj. Kitci oseezima dac ki niba8i, acitc ki nibo ega egi tendjin odabinodjijiman. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Mina8adj dac teci8ag o8idjiki8en aa8e ki iji niba8i ini ka pejigondjin ik8e8an, acitc ke8in ki nibo ega egi aia8adjin abinodjijan. Midac pejig8an ka ani ijise8adj igi8e kodagiag. Ki niba8i8ag acitc ki nibo8ag ega egi odabinodjijimi8adj kakina e nij8atci8adj e iji 8idjiki8emidi8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ick8eag dac, aa ik8e ke8in ki nibo. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Apitc dac odjitcisenig kidji abidjiba8adj ka nibo8adj, adi ini8e maia ke iji o8idigemaganidj aa ik8e? Kakina mega ka nij8atci8adj igi nabeg ki iji niba8i8ag ini pejig8an ik8e8an,” ogi iji k8ag8edjima8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesos dac ogi nak8e8ajian: “Nabeg acitc ik8e8ag niba8i8ag ooma 8akidakamig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pekic dac igi8e ka onabamagani8i8adj 8ak8ig kidji ija8adj acitc kidji abidjiba8adj, ka8in kada niba8isi8ag apitc 8ak8ig te8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mi maia pejig8an ajenig ke ijinagozi8adj, ka8in dac 8ikad mina8adj kadagi nibosi8ag. Kije Manido ini odabinodjijiman, osa mega ki abidjiba8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mois kitci 8e8enda ki tibadjimo kidji abidjibandjin ka nibondjin. Apitc ka mikomadjin mitigon ka taji piskanenigobanen, mi oo ka ijinikanadjin ka Tibendjigendjin: ‘Abanaam (Abraham), Aisik (Isaac), acitc Tcekap (Jacob) Okije Manidomi8an,’ ogi ijinikanan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kije Manido dac 8in Okije Manidomi8ag igi8e ka pimadizi8adj, ka8in 8in igi8e kagi nibo8adj. Kakina mega a8iagog Kije Manidokag ka iji tibendagozi8adj minagani8i8ag kidji pimadizi8adj, misa8adj igi8e kagi nibo8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nandam Coda8inni kikinoamage8innig ogi ina8an: “Kikinoamage8inni! Teb8e kiminotagozinan.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ka8in dac kodag kegoni ododji k8ag8edjimasi8an Jesosan. Cag8enimobanig mega. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesos ogi inan: “Adi 8edji ikidonani8ag David ini odanike ojisan ini a8ian Kije Manidon kagi ikidonipanin kidji pidjinija8andjin? ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Apitc mega kagi ojibiagin David 8eckadj Kitci Nigamo8inan Kije Manido Omazinaiganikag, David 8inigotc ki ikidogoban oo8eni: ‘Ka Tibendjigedj ogi inan ka Tibenimijindjin: Nikitcinikikag iji pi nda abin, ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","pinici kidji cagodjiag8a ka madjenimik8a, kinikag kidji iji tabasendizo8adj.’ ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David dac ‘Ka Tibenimijidj’ odijinikanan ini a8ian Kije Manidon kagi ikidonipanin kidji pidjinija8andjin. Adi dac kegi odji ijisedj David kidji odanike ojisidj ini?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Meg8adj kakina a8iagon e ndotagodjin, Jesos ogi inan okikinoamaganan: ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Iag8amenimikog Coda8inni kikinoamage8innig, ka kitci min8endamo8adj kidji paba kigickamo8adjin okonasan ka kitci kin8eganigin acitc ka kitci min8acinigin. Kitci min8endamog e anamika8agani8i8adj ka iji manenani8anig. Nigan ma8adji 8i iji abi8ag Coda8inni aiamiemigi8amikag kidji gi 8abamagani8i8adj. Ma8adji dac ka iji min8acinig 8i iji abi8ag e magocani8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Okimodima8an ik8e8an ka pejigondjin, pekic dac kitci kin8ej aiamie8ag kidji mino inabaminagozi8adj. Na8adj kada sogakonagani8i8ag 8ina8a,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesos ki aiagineabi 8ajagam 8inikag, acitc ogi 8abaman ini8e ka kitci 8anadizindjin e pagidinigendjin Coda8inni kitci aiamiemigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ogi 8abaman acitc pejig ik8e8an egi pejigondjin acitc ka kidimagizindjin, nijin somaniken e pagidinigendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesos dac ki ikido: “Teb8e ki8idamonom, aa ka kidimagizidj ik8e 8in ma8adji mane ki migi8e apitc8in kakina kodagiag a8iagog. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Igi8e ogi asa8an oconiami8an ega teb8e ka nda8enima8adjin. 8in dac, misa8adj e kitci kidimagizidj, kakina oconiaman ogi asan. Kegi pimadjio8agepan kakina ki migi8e.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nandam a8iagog omikodana8aban Coda8inni kitci aiamiemigi8amini. Ikidobanig adi epitci kitci minojicindjin asinin kagi abadizindjin kidji ojitcigadenig, acitc adi epitci kitci min8acinigin kegonan Kije Manido kagi pagidinama8agani8idj. Jesos dac ki ikido: ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Kakina oo ka iji 8abadameg, kada odjitcise nigodin ega iaga pejig asinig kidji aiag8ita8abi8adj. Kakinagotc kada k8enabagodjinog.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ogi k8ag8edjima8an: “Kikinoamage8inni! Anapitc ke iji8ebag ii? 8egonen ke 8abadai8emagag e odjitciseg kidji iji8ebagin ini kegonan?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesos dac ogi nak8e8ajian: “Iag8amendamok ega kidji 8aiejimigo8eg. Mane mega a8iagog kada pija8ag ni8izoni e abadjito8adj, acitc kada ikido8ag: ‘Nin aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin,’ kek8an: ‘Aja kegat kada iji8eban.’ Ka8in dac nosone8akegonig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Apitc nodageieg e migadinani8ag acitc e madji iji8ebag, ka8in segizikegon ii odji. Panima ii kada iji8eban, ka8in dac teci8ag kada ponaki8asinon.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesos dac kiabadj ki ikido: “Pejig8eieg a8iagog ka inakanezi8adj oga migana8an a8iagon pakan ka inakanezindjin, acitc a8iagog pejig aki ka tajike8adj oga migana8an a8iagon pakan akin ka tajikendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Aianodjigotc kada kitci kotadendag8an e k8ig8ag, acitc kada kitci ka8askadani8an, acitc kada kitci akozinani8an. E kitci kotadendag8agin kegonan acitc e kitci mamakazinag8agin kegonan 8ak8ikag kada odji nag8anon. A8iagog dac kada kitci segizi8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ab8amaci dac ii, kiga takonigom acitc kiga kodagiigom. Coda8inni aiamiemigi8amikag kiga ijinijaogom kidji tibakonigo8eg, acitc kiga asigom kibaodimigi8amikag. E nosoneojieg mega ke odji iji8inigo8eg nigan kitci ogimakag acitc ka nigani8adj kidji tibakonigo8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ii dac apitc, kiga 8idama8a8ag min8adjimo8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mamidonendamok dac ega kidji segizieg adi ke ikido8eg kidji nak8itamadizo8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ninigotc mega kiga mininom ke ikido8eg, acitc kiga mininom kagita8endamo8in ega kidji kackito8adj kidji nak8itago8eg igi8e ka madjenimigo8eg, acitc ega kegoni kidji tag8anig ke ikido8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","8a8adj kinigiigo8ag, kidjiki8e8ag, kitcina8emagani8ag, acitc ki8idji8agani8ag kiga mamijimigo8ag. Nandam e tacieg kiga nisigom. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","E nosoneojieg, kakina a8iagog kiga odji madjenimigo8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pekic dac ka8in 8a8adj pejig ki8ina8anisisi8a kiga 8anitosina8a. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Sogigaba8iok dac, mi iidi ke odji aiameg kagige pimadizi8in.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Kiga 8abama8ag kitci mane cimaganicag kidji 8isk8enakinamo8adj Jerusalemini kidji migadamo8adj. Midac aja kidji kikendameg kidji nici8anadjitcigadeg ii odena. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ii dac apitc, igi8e Coda (Judée) akikag ka tajike8adj, panima pik8adinakag kada ipai8e8ag. Igi8e dac Jerusalem odenag ka te8adj, panima ki sagidjibai8e8adj, acitc igi8e kitige8ini8akig ka te8adj, ka8in ijinag8asini kidji pidige8adj iima odenakag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mi oo ke iji pajacte8adjin Kije Manido a8iagon ii apitc. Ojibiigadeni ii Kije Manido Omazinaiganikag, acitc teb8e kada iji8eban ii. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ii dac apitc, kada kitci kodagito8ag ik8e8ag ke kigicka8a8ag8en abinodjijan acitc igi8eni8ag ke tcodjocikea8aso8ag8en. Kada kotadji kitci madjise mega ooma akikag, acitc Kije Manido oga pajacte8an a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nandam kitci mokomani kada odjine8ag, kodagiag kada madji8inagani8i8ag 8edi pakan akin kidji nda kiba8agani8i8adj. A8iagog ega ka teb8eta8a8adjin Kije Manidon oga nici8anadjitona8a Jerusalemini. Midac ii ke iji8ebag pinici kidji ick8asenig inigik ke onaco8e8adj igi8e ega ka teb8eta8a8adjin Kije Manidon.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kizisokag acitc tibikikizisokag acitc 8anagocikag kada mamakadjisedon kegonan. Ooma akikag kakina a8iagog kada kitci animendamog acitc oga kitci segiigona8a kitcigamini e kitci kiji8emaganig acitc e kitci mamagaanig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mane a8iagog kada ka8iniji8ag ke apitci kitci segizi8adj apitc mamidonendamo8adj adi ke iji8ebanig mizi8ekamig. Kakina mega kegonan icpimig kada ninigise8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ii dac apitc, nin, Ka pi Anicinabe8iidizodj, niga 8abamigo, kidji pi najiseian nena8idj 8ak8ikag, e kitci macka8izian acitc e kitci icpendagozian. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Apitc dac madji iji8ebagin ini kegonan, pazig8iok acitc icpanabiok. Aja mega peconag8an kidji ag8acimigo8eg.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesos ki adisoke kidji kikinoamagedj, e ikidodj: “Kana8abamik minatig kek8an kodagiag mitigog. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Apitc 8eabadamegon onibicibagoman e sagiginigin, kikikendana8a aja pecodj kidji nibig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Midac pejig8an, apitc 8abadamegon ini kegonan e iji8ebagin, kiga kikendana8a aja e ani peconag8anig kidji tag8icinomaganig Kije Manido Odogima8i8in.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Teb8e ki8idamonom, ka8in kakina kada nibosi8ag a8iagog nogom ka pimadizi8adj, ab8amaci kakina ii iji8ebag ka ikido8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","8ak8i acitc aki kada ponise8an, nidikido8inan dac 8in ka8in 8ikad kada ponisesino8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Iag8amenimidizok! Ka8in pijicig mamidonendakegon kidji magoceieg acitc kidji minik8eieg, acitc ka8in animendakegon adi ke iji pimadjio8eg. Kicpin mega iidi inakamigizieg, kiga kitci kock8endana8a apitc ke koki tag8icig Ka pi Anicinabe8iidizodj, ega pabajine e pieg. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kaiezigotc pidaamog kigozag. Midac pejig8an, kada tadji8inagani8i8ag a8iagog mizi8ekamig apitc odjitcisenig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Eco8iok dac. Apanigotc aiamieok, kidji gi aiameg macka8izi8in kidji gi cabockameg ii ke iji8ebizieg e sogigaba8ieg, ega dac kidji segizieg apitc tibakonigo8eg Ka pi Anicinabe8iidizodj.” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","E kijiganig ako, Jesos kikinoamagegoban Coda8inni kitci aiamiemigi8amikag. E onag8icinig dac, 8edi pik8adinajicikag, Olip (Oliviers) ka ijinikadenig, ijagoban ako. ");
INSERT INTO alqALGNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","8ibadj dac e kijeba8aganig, kakina a8iagog pija8agoban ako Coda8inni kitci aiamiemigi8amikag, kidji pi ndota8a8adjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Aja ani peconag8anogoban Coda8inni Kitci Magocan, Pak ka ijinikadeg, apitc ako ka am8agani8igobanen pak8ejigan ega ka obicig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Coda8inni kitci aiamie ogimag acitc kikinoamage8innig okosa8abanin ini8e a8iagon ka ndota8andjin Jesosan. Ogi nanada8i kikendana8a dac adi ke todamo8apan kidji gi nisa8apanin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Madji manidon dac ogi pidigeckagon Judas, Iskaniot (Iscariote) ka ijinikazogobanen, mi aa pejig ii e midatcin acitc nijindjin Jesos okikinoamaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas dac ogi a8i aiamiagoban Coda8inni kitci aiamie ogiman acitc ini naben ka kackakanandjin a8iagon ka kana8endamindjin kitci aiamiemigi8amini, adi kegi todagiban kidji gi 8idoka8adjin kidji takonandjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ogi kitci min8endana8a, acitc ogi ina8an conian kidji mina8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas dac ki nakomo, acitc ogi madji nanada 8abadanaban anapitc maia ke minosenigiban kidji gi mamijimapanin Jesosan, apitc ega kitci manenani8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Meg8adj Coda8inni Kitci Magocan, apitc ako ka am8agani8igobanen ega ka obicig pak8ejigan, aja odjitcisenigoban kidji nisa8agobanen mantcenicesan kidji gi pagidinige8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesos dac ogi ijinija8agoban Pienan acitc Johnan, e inadjin: “A8i ojitaok midjim kidji gi magoceiak.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ogi k8ag8edjima8an dac: “Ataji iima eji nda8endaman kidji iji nda ojito8ag?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ogi inan: “Ndotamok! Ijaok odenag. Apitc pidigeieg odenakag, kiga nagicka8a8a pejig nabe, nibi8ajini e pimi8idodj. Nosoneok acitc pidigeok migi8amini ke iji pidigedj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","8idamaok dac aa ka tibendag migi8amini: ‘Kikinoamage8inni k8ag8ed8e: Ataji e tag8ag pakesaga ke iji magoceian kigi nikikinoamaganag?’ mi iidi ijik. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kiga 8abadaigo8a dac icpimisagog omigi8amikag pejig kitci pakesagani aja egi ick8a ojitcigadenig kidji abadanig. Mi iima ke iji a8i ojito8eg midjim kidji gi 8isiniak,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Odenag dac ki ija8ag igi nijin kikinoamaganag, acitc ogi mikana8a kakina Jesosan kagi ikidonigobanen. Ogi ojitona8a dac kidji magocani8anig e kitci ijigijiganig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Apitc ka odjitcisenig kidji 8isini8adj, Jesos acitc Odanodaganan ki 8akanabi8ag 8isini8aganikag kidji magoce8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesos dac ogi inan: “Nigi taji kitci mosa8endanaban mama8 kidji 8isiniak oo Kitci Magocan ab8amaci kodagito8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ki8idamonom oo8e, ka8in mina8adj niga iji 8isinisi oo Kitci Magocan, pinici kidji tag8icinomaganig Kije Manido Odogima8i8in. Ii dac apitc, kada nag8an maia 8egonen ii Kitci Magocan ekidomagag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jesos dac ogi odapinan minik8anagani, mig8etc ogi inan Kije Manidon, midac ka ikidodj: “Odapinamok oo8e minik8anagan, kakina dac pepejig e tacieg k8abadamok. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ki8idamonom, ick8a oo8e, ka8in 8ikad mina8adj niga minik8esi cominabo pinici kidji tag8icinomaganig Kije Manido Odogima8i8in.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Mina8adj dac Jesos ogi odapinan pak8ejiganan, mig8etc ogi inan Kije Manidon, acitc ogi papak8ebinan. Ogi minan dac okikinoamaganan, e inadjin: “Mi oo8e nia8 ka pagidinamago8eg. Mi oo kabe todamok kidji mik8enimijieg.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mi pejig8an, ka ick8a 8isini8adj, Jesos ogi minan minik8anagani, e ikidodj: “Oo8e minik8anagan 8abadaigemagan Kije Manido odocki nakomo8in kidji mama8ise8adj Kije Manido acitc odanicinabeman. Siginigade mega nimisk8i kina8a odji, mi 8edji madjitamagag oo ocki nakomo8in.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Anic dac ndotamok! Aa a8iag ka mamijimijidj, ke8in ooma ni8idji 8isinimig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ketcinam nin, Ka pi Anicinabe8iidizodj, niga nibonan adi eji nda8endag Kije Manido. Anic dac 8in aa nabe ke mamijimijidj, kada kitci madji iji8ebizi.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Midac ka iji k8ag8edjimidi8adj a8enen iidi ke todamindjin kakina e taci8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kikinoamaganag ki kitci aiamiidi8ag e nanada kikendamo8adj a8enen ma8adji e kitci apitendagozindjin ii ka taci8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesos dac ogi inan: “Igi8e ka ogima8i8adj ooma akikag kitci kacka8enimidizo8ag, acitc igi8e ka tibenima8adjin a8iagon nda8endamog kidji ijinikanagani8i8adj ‘Mino todage8innig.’ ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ka8in dac 8in iidi kiga iji8ebizisim. Tiegodj, a8iag ma8adji ka kitci apitendagozidj ii e tacieg, kada tabasenimidizo, tabickotc aa8e ma8adji ka ocki pimadizidj kidji inenimidizodj. Midac pejig8an aa8e ka anokita8agani8idj, panima tabickotc aa8e ka anokitagedj ki inenimidizodj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","A8enen ma8adji e apitendagozidj, aa8e ka abidj kidji 8isinidj konigotc aa ka anokitagedj? Kakina a8iagog ‘ini8e ka abindjin’ inendamog. Nin dac, meg8adj e 8idji tajikeminagogiban, mi tabickotc anokitage8inni ka inenimidizo8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Apanigotc kigi paba 8idjiojim taji ka iji paba kodagito8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nidadam nigi onabamig kidji ogima8ian. Mi kenin kidonabaminom kekina8a kidji ogima8ieg. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nidogima8i8inikag dac kiga 8idji 8isinimijim acitc kiga 8idji minik8emijim ni8isini8aganikag. Kiga abim kidogima8i tesabi8agani8akag, kidji tibakoneg8a ka midatcin acitc niji8adj ka inakanezi8adj Israel a8iagog.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simo, ndotan! Madji manido ki k8ag8ed8e kidji gi kitci mimigobaniigo8eg, tabickotc ako ka kitci mimigobaniagani8i8adj anominag kidji nenicikebaniagani8i8adj anominatigokag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kigi aiamietamaon dac, Simo, ega kidji poni teb8etaman. Apitc dac pi koki 8idjiojian, 8idjiik kidjiki8eg kidji sogidee8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pien dac ogi inan: “Tebendjigean! Nidick8ata kidji 8idjionan kibaodimigi8amikag acitc kidji 8idji nibominan!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesos dac ogi inan: “Pien! Ki8idamon, nogomigotc ke tibikag, ab8amaci nabe pakaak8an nodagozidj, aja nisinanaj kigagi odji ikidonan ega e kikenimijian.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesos dac ogi inan okikinoamaganan: “Apitc ka madjinijaonagok ega e oconia8ajieg, ega e omackimodaieg, acitc ega e omakizinieg, kigi nodesem na kegon?” “Ka8in kegon,” ki ikido8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ogi inan dac: “Nogom dac aa ka aiag conia8ajini panima ki madji8idodj, acitc aa ka aiag mackimodani panima ki madji8idodj. Aa ega aiag kitci mokomani, panima kada ada8e opizika8agan kidji gi odapinamadizodj ii kitci mokomani. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ikidomagani mega Kije Manido Omazinaigan: ‘Madji a8iagokag ki iji acidagimagani8i.’ Ki8idamonom dac, panima ki iji8ebizian ii. Teb8e kada iji8eban ii kagi ojibiigadegobanen nin odji.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Okikinoamaganan dac ki ikido8an: “Ka Tibendjigean! 8adan ono8e nijin kitci mokomanan.” Jesos dac ogi inan: “Mi tibise.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesos dac ki sagaam acitc ki ija 8edi pik8adinajicikag, Olip (Oliviers) ka ijinikadenig, mojag ako ka ijagobanen. Okikinoamaganan ogi nosoneogon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Apitc ka tag8icig iima, ogi inan okikinoamaganan: “Aiamieok kidji macka8izieg, ega kidji gi pakebinigo8eg madji manido.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","A8acic pagi ki ija taji eji tenipanin okikinoamaganan, acitc ki nibak8ise. Ki aiamie dac, ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","e ikidodj: “Nidadam! Kicpin nda8endaman, 8ack8ebidon nidanimizi8in! Pekic dac ka8in nin ka iji nda8endaman todaken, tiegodj kin ka iji nda8endaman todan.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Pejig dac ajenin 8ak8ig ki pi odji najise8an, e pi nda sogideeckagodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Epitci kitci sogi kodagitodj, na8adj kiabadj Jesos ki kitci nak8i e aiamiedj. Misk8ini ki odjiga8ini ka apitab8ezidj, acitc ki paba pagigaga8inigoban motakamig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ka ick8a aiamiegobanen, ki pazig8igoban, acitc ogi nda 8abaman okikinoamaganan. Ogi mika8an dac e pajigog8acinindjin, epitci aieko kackendamindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ogi inan dac: “8egonen 8edji nibaieg? 8anickaok acitc aiamieok kidji macka8izieg, ega kidji gi pakebinigo8eg madji manido.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Meg8adj e taji aiamiagobanen okikinoamaganan, kitci mane a8iagon ki odji tag8icinobanin. Judas dac, mi aa pejig ka midatcin acitc nijindjin Jesos okikinoamaganan, 8in ogi pidji8inagoban ini a8iagon. Ogi nazika8an dac Jesosan kidji odjimadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesos dac ogi inan: “Judas! Mi na iidi eji mamijimijian, nin, Ka pi Anicinabe8iidizodj, e odjimijian?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Apitc kikinoamaganag 8eabadamo8adj eji8ebanig, ogi k8ag8edjima8an Jesosan: “Tebendjigean! Nida abadjitonananan na nikitci mokomananan?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Pejig dac ii e taci8adj ogi pakite8an Coda8inni aiamie ogiman ma8adji ka niganizindjin odanodagani acitc ogi kickita8age8eba8an ka iji okitcinikindjin inekena. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesos dac ki ikido: “Mi tibise.” Ogi taginan ota8agani ini naben acitc ogi kigean. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesos dac ogi inan Coda8inni kitci aiamie ogiman, acitc ini naben ka kackakanandjin a8iagon ka kana8endamindjin kitci aiamiemigi8amini, acitc Coda8innin ka niganizindjin, kagi pi nda 8abamigodjin kidji takonigodjin: “Mi na e ijio8eg, e omokomanieg acitc e omitigomieg e pi nadji8inijieg, tabickotc kimodi8inni8iaban? ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Taso kajik kigi 8idjionom Coda8inni kitci aiamiemigi8amikag, ka8in dac kidodji nanada8i todasina8a kidji takonijieg. Anic dac nogom adigotc eji min8endameg kigagi todana8a, meg8adj e taji mikimodj aa8e ka tibendag ka iji kacki tibikanig.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ogi na8adjibina8an Jesosan, acitc Coda8inni aiamie ogiman ma8adji ka niganizindjin omigi8aminikag ogi iji8ina8an. Pien dac 8asag odakanag ogi pi odji nosone8agoban. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ki poda8ani8anogoban nena8idj pidigeatig, Pien dac ke8in ogi 8idabimagoban ini8e ka 8akanabinigobanen ickodekag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pejig anodaganik8e ogi 8abaman e abindjin pecodj ickodekag. Kitci 8e8enda dac ogi kana8abaman acitc ki ikido: “Ke8in opaba 8idji8abanin Jesosan aa nabe.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pien dac ki ikido ega e teb8emaganig ii, e ikidodj: “Ka8in nikikenimasi aa!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nanage dac kodag a8iag ogi 8abaman acitc ogi inan: “Kekin kipaba 8idji8aban Jesos.” Pien dac ki ikido: “Ka8in nin nidodji paba 8idji8asi!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","8aiej mina8adj ka ick8a pejigotibaiganeanig, kodag a8iag mina8adj ki ikido: “Maia teb8e ii ka ikido8an. Teb8e aa nabe ke8in opaba 8idji8abanin Jesosan. Galilee akikag mega odji aa!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pien dac ki ikido: “Ka8in nikikendasin 8egonen ka mikodaman!” Maiagotc ii apitc e anim8egobanen, nabe pakaak8an ki nodagozi. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ka Tibendjigedj dac ki k8ekigaba8i acitc ogi kana8abaman Pienan. Pien dac ki odji mika8ise adi kagi igogobanen Jesosan: “Ab8amaci nabe pakaak8an nodagozidj, aja nisinanaj kigagi odji ikidonan ega e kikenimijian.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pien dac ki madja acitc ki nda kitci ma8i. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Igi8e ka kana8enima8agobanen Jesosan okitci papia8agoban acitc opapakite8a8agoban. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Odag8anak8e8a8agoban, acitc dac ok8ag8edjima8agoban: “A8enen ka pakiteok? 8idamaocinam!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Mane kegoni ogi ina8an e manazoma8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Apitc e kijeba8acinig, Coda8innig ka niganizi8adj, kitci aiamie ogimag, acitc Coda8inni kikinoamage8innig ki ma8adjiidi8ag. Ki anoki8ag dac kidji pi iji8inagani8indjin Jesosan nigan 8ina8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ogi k8ag8edjima8an dac: “Kin na aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin? 8idamaocinam.” Jesos dac ogi inan: “Kicpin dac 8idamonagok, ka8in kiga teb8etaojisim, ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","acitc dac kicpin kegon k8ag8edjiminagok, ka8in kiga nak8e8ajitaojisim. ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nogom dac aja nin, Ka pi Anicinabe8iidizodj, niga abinan Kije Manido ma8adji ka kitci macka8izidj okitcinikikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kakina dac ki ikido8ag: “Kin na dac Kije Manido Og8izisan?” Ogi inan: “Mi ekido8eg, kiteb8em ii.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ki ikido8ag dac: “Ka8in aja kodag a8iag ninada8enimasi8anan kegoni kidji pi nda tibadjimodj! Nigi noda8anan nina8it tibina8e adi ka ikidodj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kakina ka ma8adjiidi8apan ma8asag ki pazig8i8ag, acitc Pilatikag ogi ijinija8a8an Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ki madjita8ag dac kidji inactaona8adjin, e ikido8agobanen: “Nigi katcidinanan 8aa nabe e taji 8agackibinadjin nidanicinabeminanan. Ododjian a8iagon kidji kijika8andjin adi ka inendagozindjin inigik kidji mina8apanin kitci ogiman, acitc ‘Nin aa Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin’ ikido, acitc ‘Nidogima8inan’ ikido.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilat dac ogi k8ag8edjiman Jesosan: “Kin na Coda8innig odogimami8an?” Jesos ogi nak8e8ajian: “Kin ka in8ean.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilat dac ogi inan kitci aiamie ogiman acitc kakina a8iagon: “Ka8in kegon nimikasin kidji gi panaagedj 8aa nabe.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kiabadj eckam ki ani kitci kiji8e8ag e ikido8adj: “O8ik8adjian a8iagon kidji nak8ita8andjin kitci ogiman. Galilee akikag ki odji madjita kidji kikinoamagedj, mizi8e dac Coda (Judée) akikag ki paba ija, nogom dac aja ki pi tag8icin ooma.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Apitc Pilat ka nodag ii, ki k8ag8ed8e kicpin Galilee aki epitci odjinig8enin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Apitc dac ka nodagedj Galilee aki e odjindjin, Herod ka iji ogima8ipan, ogi ijinija8an Herodikag. Jerusalemikag mega meg8adj teban ii apitc Herod. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod dac ki kitci min8endam kidji 8abamadjin Jesosan. Ki nodageban mega e mikomagani8indjin Jesosan acitc aja 8eckadj o8i k8ag8e 8abamabanin, kidji gi 8abamadjin e mamada8izindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kitci mane dac kegoni ogi k8ag8edjimabanin, ka8in dac kegoni Jesosan ogi odji nak8e8ajitagosin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kitci aiamie ogimag acitc Coda8inni kikinoamage8innig tebanig iima, acitc ogi kitci inactaona8abanin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod acitc ocimaganiciman okitci manenima8abanin acitc okitci papia8abanin Jesosan. Ogi pizikamodina8abanin e kitci min8acinig okonasini, midac Pilatikag ka iji koki ijinija8a8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herod acitc Pilat kitci madjenimidibanig ako, midac ii e kijiganig ki madji kitci inenimidi8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilat ogi ma8adjian Coda8inni kitci aiamie ogiman, ka niganizindjin, acitc kakina a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ogi inan dac: “Kigi pidji8idamaojim 8aa nabe e ikido8eg e 8ik8adjiadjin a8iagon kidji nak8ita8andjin kitci ogiman. Nigi k8ag8edjima dac mane kegoni meg8adj e kana8abamijieg. Ka8in dac odji pejig nidodji mikam8asin madji kegonan ka inactaoneg. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod ke8in, ka8in kegoni ododji mikasin, mi 8edji ki koki pidjinija8adjin. Ka8in kegoni odji madji ijitcigesi 8aa nabe kidji odji nisagani8ipan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Niga anoki dac kidji papajacte8agani8idj, midac ke iji pagidinag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","E taso pibonig, meg8adj e Coda8inni Kitci Magocani8anig, Pilat opagidinabanin ako pejig takoniganan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kakina dac a8iagog ma8asag ki pibagi8ag: “Nici aa nabe, ninada8enimanan Barabbas kidji pagidinagani8idj!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabbas ki kiba8agani8igoban egi ojitogobanen kidji nak8itaomagani8indjin kitci ogiman Jerusalem odenakag acitc egi nici8egobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilat dac o8i pagidinabanin Jesosan. Mina8adj dac ogi koki aiamian a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kiabadj dac ki pabibagi8ag: “Acidak8ao tcibaiatigokag! Acidak8ao tcibaiatigokag!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilat kiabadj ogi aiamian a8iagon, aja nisinanaj odaiamian. Ogi inan dac: “Adi dac ka iji panaagedj? Ka8in kegon nidodji mikasin kidji gi panaagedj kidji gi odji nisagani8ipan. Niga anoki dac kidji papajacte8agani8idj, midac ke iji pagidinag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kiabadj dac enigok ki kitci pabibagi8agoban kidji acidak8a8agani8indjin Jesosan. Ogi cagozoma8an dac kegapitc Pilatan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilat dac ki onendam kidji minadjin adi eji nda8endamindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ogi pagidinan dac ini kodagian naben ka nda8enimagani8inipanin, ini8e kagi kiba8agani8inigobanen egi ojitonipanin kidji nak8itaomagani8indjin kitci ogiman acitc egi nici8enipanin. Ki inakonige dac kidji nisagani8indjin Jesosan, adi eji nda8endamindjin ini a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Cimaganicag dac ogi madji8ina8an Jesosan kidji acidak8a8a8adjin. Meg8adj dac e iji8ina8adjin 8edi, ogi nagicka8a8an pejig naben, Sinen (Cyrène) odenakag e odjindjin, Simo ijinikazonigoban, kitigan akikag odosenigoban. Ogi na8adina8an dac acitc ogi mina8an Jesosan otcibaiatigomini kidji pimi8inandjin, odakanag Jesosikag e pimosendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kitci mane a8iagog onosone8a8agoban Jesosan, acitc kitci mane ik8e8ag ma8ibanig acitc pabibagademobanig Jesosan odji. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesos ki k8ekigaba8i kidji kana8abamadjin ini ik8e8an, ogi inan dac: “Kina8a ik8e8ag Jerusalem ka tajikeieg, ka8in ma8imijikegon. Tiegodj ma8iok kina8a odji acitc kidabinodjijimi8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kada odjitcise mega kidji ikidonani8ag: ‘Ca8endagozi8ag ik8e8ag ega ka kackito8adj kidji odabinodjijimi8adj, ega 8ikad egi nta8igia8adjin abinodjijan, acitc ega 8ikad egi tcodjocikea8adjin.’ ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ii dac apitc, a8iagog kada aikido8ag: ‘Pik8adinan! Pidagodjiniok nina8itinakag!’ acitc: ‘Pik8adinajican! Nigeckaocinam!’ ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Teb8e mega, kicpin iidi toda8agani8idj ajickatig, adi dac ke toda8agani8idj patesag?” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nijin kodagiag nabeg ka kitci panaage8adj ki acidji8inagani8ibanig kidji 8idji niboma8adjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Apitc ka oditamo8adj 8edi “Tcibaictig8an” ka ijinikadenig, ki acidak8a8agani8i Jesos tcibaiatigokag. Nijin igi8e ka kitci panaage8adj acitc ki acidak8a8agani8i8ag ke8ina8a otcibaiatigomi8akag, midac nenida8ina Jesosikag ka iji padakicimagani8inigobanen otcibaiatigomi8an, pejig okitcinikikag inekena acitc pejig onamadinikikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesos dac ki ikido: “Nidadam! Kasiamaok opatado8ini8a! Ka8in mega okikendasina8a adi enakamigizi8adj.” Ki madinamadi8ag Jesosan opitcikonaani, e k8ag8e mikose8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kitci mane a8iagog iima te8agoban e kijigabage8agobanen. Coda8innig ka niganizi8adj omanenima8abanin Jesosan e ikido8adj: “Kodagian a8iagon ogi pimadjian. Kada pimadjiidizoban sa 8in tibina8e, kicpin teb8e aiaa8idj aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin, Kije Manidon kagi onabamigodjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Cimaganicag onazika8a8agoban acitc opapia8agoban. Ogi k8ag8e minaa8an cominaboni ka kitci 8isagagaminig, ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","e ina8adjin: “Kicpin Coda8inni ogima aiaa8ian, kinigotc pimadjiidizon.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ojibiigani agokenigoban 8agidj octig8anikag e ikidomaganig: “Mi 8aa Coda8innig odogimami8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Pejig aa8e kagi kitci panaagedj ka agodjig tcibaiatigokag okitci mamanazomagoban Jesosan e inadjin: “Kana kin aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin? Pimadjiidizon dac kin tibina8e acitc pimadjiicinam!” ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kodag dac aa kagi kitci panaagedj ogi kaganonan ini8e, e ikidodj: “Kana kikosasi Kije Manido? Kekin kigi inakonigo kidji nibo8an tcibaiatigokag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","K8aiak kidinakonigomin kina8it, kitodadizomin mega 8edji nisigo8ag. 8in dac aa ka8in kegoni odji iji panaagesi.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ogi inan dac Jesosan: “Jesos! Mik8enimicin apitc tag8icinian kidji ogima8ian.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesos ogi inan: “Teb8e ki8idamon, ogajigag kiga 8idjiojinan 8ak8ig, 8edi ka iji8inagani8i8adj ka ca8endagozi8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Aja 8aiej abitakijiganogoban, ka odji poni tcakasigedj kizis. Ki odji kacki tibikise mizi8e akikag, pinici kidji nisotibaiganeag e ick8a abitakijigag. Coda8inni kitci aiamiemigi8amikag kitci kibigaigan abita ki tadose. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesos dac ki kitci kiji8e: “Nidadam! Kipagidinamon nidjitcagoc.” Ka ick8a ikidodj ii, ki ick8anamo. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Cimaganici ogima 8eabadag ka ijisenig, ogi icpeniman Kije Manidon, acitc ki ikido: “Ketcinadj k8aiakodeegoban aa nabe.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kakina igi8e kagi pija8agobanen e pi nda kijigabage8adj, ogi 8abadana8a adi ka iji8ebanig. Midac ka iji ki8e8adj e papakiteakiganeodizo8adj, kidji 8abadai8e8adj epitci kitci kackendamo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Kakina Jesos o8idji8aganan acitc igi8e ik8e8ag Galilee akikag kagi pi odji nosone8a8apanin Jesosan, 8asag tajigaba8ibanig, e kana8abi8adj adi eji8ebanig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Pejig nabe tegoban, Josep ka ijinikazopan, Animati (Arimathée) odenag Coda (Judée) akikag ka odjipan. Minodeegoban acitc k8aiak8adizigoban aa. Opitonagoban Kije Manidon Odogima8i8ini. Coda8inni kitci aiamie onakonige8innig iji acidagimagani8igoban, ka8in dac misa8adj odji min8endasigoban adi ka iji onendamindjin acitc adi ka todamindjin o8idji mikimomaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ogi nda 8abaman dac Pilatan kidji k8ag8edjimadjin Jesosan o8ia8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Josep dac ogi nisakonan Jesosan o8ia8ini tcibaiatigokag, acitc ogi 8ik8eiginan 8abiskiginokag. Ogi nda naaton dac 8ibabikiniganikag kagi iji monaigadenig asinikag, ega 8ikad maci egi abadanigobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tcibaiatigogijiganogoban ii apitc, apitc ako meg8adj e medoni mikidamo8agobanen kidji Coda8inni aiamie kijiganig, acitc aja maia kegat madjitamaganogoban ii ka Coda8inni aiamie kijigag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Igi8e ik8e8ag Galilee akikag kagi pi nosone8a8apanin Jesosan, ogi 8idji8a8an Josepan. Ki inabi8ag 8ibabikiniganikag, acitc ogi 8abadana8a adi kagi iji naatcigadenigobanen Jesosan o8ia8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Midac ka iji ki8e8adj, e nda ojito8adj ka minomag8anig acitc pimideni ka minomag8anig kidji ato8adj Jesosan o8ia8inikag, mi ako e toda8agani8ipan a8iag e nibodj. Ki an8ebi8ag dac meg8adj e Coda8inni aiamie kijiganig, kagi ikidomaganig aiamie inakonige8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","8ibadj e kijeba8acinig e manadjitagani8anig, ik8e8ag ki ija8ag 8ibabikiniganikag. Pimide ka minomag8anig ogi iji8idona8a kagi ojito8agobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ogi mika8a8an dac kitci asinin 8asag 8edi egi taditibinagani8indjin ka odji pidigani8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Midac ka iji pidige8adj. Ka8in dac ododji mikasina8a Jesosan o8ia8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Meg8adj e taji mamidonendamo8adj adi ka ijisenig, kitata ogi 8abama8an nijin naben e kitci 8asigitenigin okonasi8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ki onijik8ebanio8ag, ka apitci segizi8adj. Ogi igo8an dac ini naben: “8egonen 8edji iji nanada 8abameg ka nibo8adj ka iji te8adj aa8e ka pimadizidj? ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ka8in aja ooma tesi. Ki abidjiba nibo8inikag. Mika8iok adi kagi ikidopan meg8adj kiabadj Galilee akikag ka paba tepan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Mi oo8e ekidopan: ‘Panima Ka pi Anicinabe8iidizodj ki pagidenimagani8idj kidji tibenimigodjin ka patadindjin a8iagon, acitc ki acidak8a8agani8idj tcibaiatigokag, acitc ki abidjibadj ki nisogonaganig,’ ” mi ka igo8adjin ini naben. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ki odji mika8i8ag dac adi Jesosan ka ikidonipanin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ogi nagadana8a dac 8ibabikinigani, acitc ki koki ki8e8ag kidji nda 8idama8a8adjin ini ka midatcin acitc pejigondjin Jesosan Odanodagani acitc kodagian a8iagon kagi nosone8anipanin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mani Magdala, Jo8ana (Jeanne), acitc Mani, 8in Jak (Jacques) odjodjoman, acitc kodagiag ik8e8ag kagi 8idjiogo8agobanen, mi igi8e ik8e8ag kagi nda 8a8idama8a8agobanen Jesosan Odanodaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Igi dac Anodaganag “ka8in teb8esi8ag” inendamo8agoban, ka8in dac ododji teb8eta8asi8a8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Misa8adj dac Pien ki pazig8idjise, acitc dac ki ipato 8ibabikiniganikag. Ki camagi e podazig8eabadag 8ibabikinigani. Ogi mikanan dac 8ik8eiginiganan eta. Midac ka iji koki ki8edj, e kitci mamakadendag adi ka iji8ebanig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mi pejig8an ii e kijigag, nijin nabeg ka paba nosone8a8agobanen ako Jesosan ija8agoban odenajicikag, Imeos (Emmaüs) ka ijinikadenig, 8aiej nij8asotibaigan ka apisinag8anigobanen Jerusalemikag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Omikodana8agoban kakina ka pi iji8ebanigobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Meg8adj e pimi aiamiidi8adj, Jesos ogi nazika8an acitc ogi pimi 8idji8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","O8abama8agoban, pekic dac ka8in ododji nisida8ina8asi8a8an. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesos dac ogi k8ag8edjiman: “8egonen mekodameg meg8adj e pimoseieg?” Midac ka iji kibisika8adj, kitci kackendamobanig mega. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Pejig aa8e e niji8adj, Kleopas (Cléopas) ka ijinikazodj, ogi inan: “Kin na eta ooma Jerusalemikag ka8in kidodji nodagesi adi ka iji8ebag?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesos ogi inan: “Adi ka iji8ebag?” Ki inagani8i dac: “8adan ka ijisedj Jesos, Nazaret ka odjidj. Kitci macka8i niganadjimo8inni8iban, ka kitci mamada8izidj acitc ka sogigij8edj, ka min8enimigopanin Kije Manidon acitc kakina a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nikitci aiamie ogimaminanag acitc nidogimaminanag ogi pagidenima8an kidji nisimagani8indjin. Ki acidak8a8agani8i dac tcibaiatigokag. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nina8it dac, nidinendananaban mi aa8e Kije Manidon kagi pidjinijaogodjin kidji pi nda ag8acimadjin Israel a8iagon. Ogajigag dac aja nisogon ka ako iji8ebag ii. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nandam ik8e8ag ka 8idjiogo8ag, nigi kitci mamakadendamiigonanag. 8ibabikiniganikag ki ija8ag kitci 8ibadj ka kijeba8acinig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ka8in dac ododji mikasina8a Jesosan o8ia8ini. Ki koki pi ki8e8ag dac e pi tibadjimo8adj ajenin egi 8abama8adjin, egi igo8adjin: ‘Pimadizi Jesos.’ ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nandam ii e taciag ki ija8ag 8ibabikiniganikag, ogi 8abadana8a dac e teb8endjin ini ik8e8an. Ka8in dac ododji 8abamasi8a8an Jesosan.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesos dac ogi inan: “Ka8in odji pejig kinisidotasina8a! Kikitci ninamizim kidji teb8etameg adi ka pi iji tibadjimo8adj niganadjimo8innig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mi panima iidi ka inendagozigobanen kidji iji kodagitodj aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin, kidji gi minigodjin Kije Manidon odicpendagozi8ini.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jesos dac ogi 8a8idama8an adi ekidomaganig Kije Manidon Omazinaigani 8in e mikomagani8idj. Moisan omazinaiganikag ki odji madjita. Mina8adj dac niganadjimo8innin kakina omazinaigani ogi mikodanan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Apitc ka ani oditamo8adj pecodj odenajicini taji ka ija8apan, mi maia kiabadj ka 8i ani madjadj e todagiban Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ogi midjimina8an dac e ina8adjin: “Mi ooma iji niban. Aja ani onag8icin acitc aja kegat kada tibikan.” Midac Jesos ka iji pidigedj kidji 8idji tajikemadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Apitc ka onabidj 8isini8aganikag kidji 8idji 8isinimadjin, ogi odapinan pak8ejiganan, mig8etc ogi inan Kije Manidon, midac ka iji papak8ebinadjin ini pak8ejiganan acitc ka iji minadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ki minagani8i8ag dac kidji nisida8ina8a8adjin. Kaiezigotc dac Jesos ka8in odji nagozisi. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ki inidi8ag dac: “Mi maia ickode ka taji piskaneg pidigamig kina8itinakag enenimo8akoban meg8adj e pimi aiamiigo8ak, acitc e mikodamago8ak Kije Manidon Omazinaigani.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Teci8ag ki pazig8i8ag acitc ki koki ki8e8ag Jerusalem odenag. Iima dac ogi mika8a8an e ma8adjiidindjin ka midatcin acitc pejigondjin Jesosan okikinoamaganan acitc kodagian a8iagon kagi nosone8anipanin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ki inagani8i8ag dac igi8e nijin nabeg: “Teb8e Jesos ka Tibendjigedj ki abidjiba! Ogi toda8an Simon kidji 8abamigodjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ke8ina8a dac ki tatibadjimo8ag adi ka pi iji8ebanig meg8adj e pimode8adj, acitc adi kagi odji nisida8ina8a8adjin Jesosan apitc ka papak8ebinandjin pak8ejiganan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Meg8adj e taji tatibadjimo8adj, kitata Jesos iima ki odji nagozi, e tajigaba8idj nena8idj 8ina8akag. Ogi inan: “Pekadendamo8in kimininom.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ki kitci kock8endamo8agoban acitc ki kitci segizi8agoban. “Tcibai ni8abamanan,” inendamo8agoban. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesos dac ogi inan: “8egonen 8edji migockadendameg? 8egonen 8edji ega teb8etameg? ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kana8abadamokon ninidjin acitc nizidan. Nin oo maia. Taginicik acitc 8abadamok. Ka8in tcibai o8ia8isi acitc ka8in okani8isi. Ki8abamijim dac e o8ia8ian.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ka ick8a ikidodj ii, ogi 8abadaan onidjin acitc ozidan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kikinoamaganag dac ki kitci min8endamo8agoban acitc ki kitci mamakadendamo8agoban. Ka8in dac maci maia oteb8eta8asi8a8abanin. Jesos dac ogi inan: “Kidaiana8a na ooma kegon kidji midjigadeg?” ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ogi mina8an dac pejigonejigan kigozan e sasondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesos ogi odapinan acitc ogi am8an, meg8adj e kijigabamigodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jesos dac ogi inan: “Meg8adj ka 8idji tajikeminagogiban, kigi 8idamonom: ‘Nimikomigo Mois omazinaiganikag, niganadjimo8innig omazinaigani8akag acitc 8eckadj Kitci Aiamie Nigamo8inikag. Panima dac kada iji8eban kakina ka mazinadeg.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ogi minan dac kidji nisidotamindjin Kije Manidon Omazinaigani. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ogi inan: “Mi oo mezinadenig: ‘Aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin kada kodagito, midac kada abidjiba ki nisogonaganig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Panima ki mikomagani8idj e paba kagik8ani8anig taji ka tajike8adj a8iagog kakinagotc ka inakanezi8adj, Jerusalemikag dac kada odji madjitani8an. Panima ki 8idama8agani8i8adj a8iagog kidji an8endizo8adj acitc kidji kasiama8agani8i8adj opatado8ini8an.’ Mi mezinadenig. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kigi 8abadana8a adi ka iji8ebag, acitc kidinendagozim kidji paba 8idama8eg8a a8iagog. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nin dac kiga pidjinijaamonom ii8eni Nidadam kagi ikidodj kidji minigo8eg. Panima dac ki tajikeieg ooma odenakag, pinici kidji odisigo8eg macka8izi8in 8ak8ig ka odjimagag.” ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kegapitc dac Jesos ogi iji8inan okikinoamaganan ag8adjik odenakag pinici Betani (Béthanie) odenakag, midac iima ka iji icpiniketadj kidji aiamit8anadjin okikinoamaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Meg8adj e taji aiamit8anadjin, ogi naganan, 8ak8ig e ani icpikadj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kikinoamaganag dac ogi kitci icpenima8an Jesosan. Ki koki ki8e8ag Jerusalemikag e kitci min8endamo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Apan acitc ki tajike8agoban Coda8inni kitci aiamiemigi8amikag kidji icpenima8adjin Kije Manidon.");
INSERT INTO alqALGNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kitci 8eckadj, ab8amaci Kije Manido ka kijendag akini, aja tegoban a8iag, “Kije Manido Odanim8e8in” e ijinikanagani8igobanen. O8idji8agoban Kije Manidon acitc Kije Manido8iban. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ab8amaci dac kagi kijendjigadenig akini, ajagotc o8idji tajikemagoban Kije Manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kije Manido kakina kegoni ogi kijendan, ini8e “Odanim8e8in” ka ijinikanagani8indjin e abadjiadjin. Ka8in kegon ki ojitcigadesinon ega ini Odanim8e8in egi ojitondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","8in sa ka migi8edj pimadizi8ini. Ii dac pimadizi8ini mi maia 8asea8ini kagi minadjin a8iagon epitendag8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ii dac 8asea8in o8aseaton ka iji kacki tibikanig, acitc dac ii 8asea8in ka8in kacki ata8eigadesinon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pejig nabe tegoban, Cabadis (Jean-Baptiste) ijinikazogoban, Kije Manidon kagi pidjinijaogogobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ki pidjinija8agani8i dac kidji mikomadjin Jesosan, tabickotc 8asea8in ka apitendagozindjin, kakina a8ian kidji gi teb8etamindjin ka iji tibadjimodj Jesosan e mikomadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ka8in dac 8in Cabadis ka 8asenama8adjin a8iagon, mi eta ogi pi mikoman ini a8ian ke pi 8asenamagondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mi aa eta Jesos 8edjida 8asea8in epitendagozidj, kagi pijadj ooma akig e pi 8asenama8adjin kakina a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Aa8e “Kije Manido Odanim8e8in” ka ijinikanagani8igobanen teban ooma akikag. Ogi 8idjiagoban Kije Manidon ka kijendamindjin akini. Misa8adj dac, apitc ka tag8icig ooma akig, ka8in a8ian ododji nisida8inagosin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ki pija ooma 8in odakikag, misa8adj dac o8idji anicinabeman ka8in ododji nda8enimigosin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Anic dac nandam ogi nda8enima8an acitc ogi teb8eta8a8an. Ini dac a8iagon kagi nda8enimigodjin, ogi minan Kije Manidon odabinodjijimini kidji gi ijinagozindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Apitc a8iag nta8igidj ooma akig, odjodjoman acitc odadaman odji nta8igi. Kitci pakan dac iji8ebizi a8iag Kije Manidon odabinodjijimini kidji ijinagozidj. Kije Manido 8in ka minadjin ocki pimadizi8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Aa Jesos, “Kije Manido Odanim8e8in” ka ijinikanagani8igobanen, ki pi nta8igi ooma akig acitc 8enibik nigi 8idji tajikemigonan. Kabe kitci kije8adizi acitc kabe teb8e. Nigi 8abadananan odicpendagozi8in, Kije Manido kagi minadjin Og8izisan ka motci pejigondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Cabadis ogi mikoman e kagik8edj e kiji8edj: “Mi aa kagi mikomag apitc ka ikido8an: ‘Nintam nigi pija ab8amaci 8in, anic dac 8in na8adj kitci apitendagozi apitc8in nin. Aja mega teban ab8amaci nta8igian,’ ” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kakina kigi minigonan oca8endjige8inan. Epitci kije8adizidj, minamina8adj kigi ca8enimigonan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mois kigi minigonan Kije Manidon odinakonige8inan, anic dac Jesos Christ kigi minigonan okitci ca8endjige8in acitc teb8e8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ka8in 8ikad a8iag ododji 8abamasi8an Kije Manidon. Anic dac Kije Manido kagi pejigondjin Og8izisan, mi ke8in Kije Manido8i8an acitc o8idji8an Odadaman, midac ogi kikendamonan a8iagon adi ejinagozindjin Kije Manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Coda8innig ka niganizi8adj, Jerusalem ka odji8adj, ogi ijinija8a8an Coda8inni aiamie ogiman acitc aiamie anodaganan kidji k8ag8edjima8adjin Cabadisan: “A8enen dac kin?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Cabadis dac teci8ag ogi nak8e8ajian acitc 8e8enda ogi 8idama8an: “Ka8in nin aa8e ka taji pieg, Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Igi8e dac Coda8innig ogi k8ag8edjima8an: “A8enen dac kin? Kin na Eli ka piagidj?” Cabadis dac ki ikido: “Ka8in! Ka8in nin Eli.” Kiabadj dac ki k8ag8edjimagani8i: “Kin na niganadjimo8inni Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin?” “Ka8in!” ki ikido Cabadis. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kiabadj dac ki inagani8i Cabadis: “A8enen dac kin maia? Panima kegon nida inananag igi8e ka pidjinijaogo8ag. Adi ke iji inadjimidizo8aban?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Cabadis dac ogi nak8e8ajian: “8eckadj niganadjimo8inni Isaia ki ikido: ‘A8iag kada tag8icin kidji pabibagidj pig8adakamigokag. Mi oo8eni ke ikidodj: Eco8iok kidji tag8icig ka Tibendjigedj, e ojitama8eg e k8aiakojimonig mikanani.’ Misa nin ka mikomijidj,” ki ikido Cabadis. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nandam igi8e kagi ijinija8agani8i8agobanen kidji nda 8abama8adjin Cabadisan, acidagimagani8i8agoban Coda8innig ka nagadjito8agobanen inakonige8inan, Panisienag (Pharisiens) ka ijinikanagani8i8agobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ogi k8ag8edjima8an dac Cabadisan: “Kicpin ega kin aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin, konigotc ega Eli8ian, konigotc ega niganadjimo8inni8ian ka piagidj, 8egonen 8edji sigaadagean?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Cabadis dac ki nak8e8ajitage: “Nin, nibikag nidiji sigaadage. Anic dac a8iag aja ki nta8igi, ega maci e kikenimeg. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mi aa8e nage ke pi tag8icig. Ka8in tibise nidapitendagozisi kidji abiskobida8agin omakizinan.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mi ka iji8ebag Betani (Béthanie) odenakag, 8edi 8abanog ineke Jourdain sibikag, Cabadis ka iji sigaadagegobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","8iabanig, Cabadis ogi 8abaman Jesosan e pi nda 8abamigodjin acitc ki ikido: “8adan aa mi maia tabickotc mantcenices ejinagozidj, Kije Manido kagi migi8edj. Mi aa e manibidodj kakina a8ian opatado8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Mi aa ka mikomag apitc ka ikido8an: ‘Nintam nigi pija ab8amaci 8in, anic dac 8in na8adj kitci apitendagozi apitc8in nin. Aja mega teban ab8amaci nta8igian.’ ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ka8in dac maci nikikenimasi8aban a8enen aa ka mikomag. Misa8adj dac nigi pija e sigaadageian nibikag, kakina Israel a8iagog kidji gi kikenima8adjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Cabadis kiabadj ki ikido: “Nin dac, ka8in maci nikikenimasi8aban a8enen aa Kije Manidon kagi ikidonipanin kidji pidjinijaogogobanen. Anic dac Kije Manido, 8in ka pidjinijaojidj nibikag kidji sigaadageian, nigi inig: ‘Kiga 8abama Mino Manido e pi najisedj acitc e tedj pejig a8iagokag. Mi aa a8iag ke sigaadagedj Mino Manidokag.’ Mi ka ikidodj Kije Manido. Kegapitc mi teb8e ka ijiseg. Nigi 8abama Mino Manido e pi najisedj 8ak8ig, mi maia omimi ka 8abizidj ejinagozidj, acitc Jesosikag ki iji te Mino Manido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mi ka iji 8abadaman. Mi 8edji 8idamageian mi aa Kije Manido Og8izisan.” Mi kagi iji tibadjimodj Cabadis. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","8iabanig, Cabadis o8idjigaba8ita8abanin nijin okikinoamaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ogi 8abaman Jesosan e pimosendjin acitc ki ikido: “8adan aa mi maia tabickotc mantcenices ejinagozidj, Kije Manido kagi migi8edj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Igi8e dac nijin kikinoamaganag ogi noda8a8an Cabadisan acitc ogi nosone8a8an Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesos dac ki k8ekigaba8i, ogi 8abaman e nosoneogodjin acitc ogi k8ag8edjiman: “8egonen nenada8abadameg?” Ogi ina8an dac: “Adi e iji tajikean, Rabbi?” Ii anim8e8in Rabbi, “Kikinoamage8inni” 8i ikidomagan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesos ogi nak8e8ajian: “Pijaok, kiga 8abadana8a dac.” Ki ija8ag dac acitc ogi 8abadana8a adi eji tajikendjin. 8aiej niotibaiganeaban e ick8a abitakijiganig ka iji pidige8adj. Midac pinici e onag8icinig ogi 8idji tajikema8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andre, Simo Pien o8idjiki8en, mi aa pejig igi nijin nabeg kagi noda8a8adjin Cabadisan acitc dac kagi nosone8a8adjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Teci8ag dac Andre ogi nda 8abaman o8idjiki8en Simon acitc ogi inan: “Nigi mika8anan aa8e ‘Christ’ ka ijinikanagani8idj, aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andre dac ogi iji8inan Simon Jesosikag. Jesos dac ogi kana8abaman Simon acitc ogi inan: “Simo kidijinikazonan, John og8izisan. Aja Sepas (Céphas) kiga ijinikanigo.” Mi pejig8an ijinikazo8in “Sepas” acitc “Pien,” pakan ijigij8e8inan e abadjitcigadegin. Midjinijin dac ini 8izonan 8idamagemaganon tabickotc asini ejinagozindjin ini a8ian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","8iabanig, Jesos ogi onendanagoban Galilee akikag kidji ijadj. Ogi nagicka8an Pilipan acitc ogi inan: “Nosoneocin.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Aa dac Pilip Betseda (Bethsaïda) odena odjiban, mi ii pejig8an odena Andre acitc Pien ka odji8agobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip dac ogi nda 8abaman Natanienan acitc ogi inan: “Nigi mika8anan aa a8iag Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin, Mois kagi mikomagobanen odinakonige mazinaiganikag, acitc ke8ina8a Kije Manido oniganadjimo8inniman kagi mikomandjin. Jesos ijinikazo aa, Josep og8izisan, Nazaret ka odjidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanien dac ki ikido: “Kegon na e min8acig Nazaret odenag kadagi odjimagan?” Pilip ogi nak8e8ajian: “Pi nda inabin sa!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Apitc Jesos ka 8abamadjin Natanienan e pizagosendjin, ki ikido: “Teb8e k8aiakozi aa Israeli8inni. Ka8in odji pejig 8agackizisi aa.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanien dac ogi k8ag8edjiman Jesosan: “8egonen dac 8edji kikenimijian adi enadizian?” Jesos dac ogi nak8e8ajian: “Kigi 8abamin ab8amaci Pilip ka nd8e8emigo8an, apitc anamatig ka mini8idj e taji abiaban.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Midac Natanien ogi inan: “Kikinoamage8inni! Kin Kije Manido Og8izisan! Kin Israel a8iagog odogimami8an!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesos ogi inan: “Kiteb8etaojinan na eta egi 8idamonan egi 8abaminan anamatig ka mini8idj e taji abian? Kiga 8abadanan kegonan na8adj e kitci mamakadendag8agin apitc8in oo8e.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Acitc kiabadj ki ikido: “Teb8e ki8idamonom, kiga 8abadana8a 8ak8ig e ceteg acitc kiga 8abama8ag Kije Manido odajeniman kidji icpikandjin acitc kidji koki pi najisendjin nin ka iji teian, nin Ka pi Anicinabe8iidizodj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nijogon ka ick8a tag8icino8adj Galilee akikag, ki niba8inani8an Kana (Cana) odenag. Jesos odjodjoman tebanin iima. ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesos acitc okikinoamaganan ke8ina8a ki nd8e8emagani8i8agoban e niba8inani8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kegapitc ki nodeseban cominabo. Jesos dac odjodjoman ogi igon: “Ka8in aja odaiasina8a cominaboni.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Midac Jesos ogi nak8e8ajian: “Nidjodjom! Adi 8edji ikido8an ii? Ka8in maci odjitcisesinon kidji madjitamagag nimikimo8in.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Odjodjoman dac ogi inan ini a8iagon ka anokitagendjin e niba8inani8anig: “Mi iji todamok kakina ke ikidodj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tag8anobanin nigod8atcin asini modaiabikon kidji kizindji8adj Coda8innig, mi ako enakonigemaganigibanin 8eckadj Coda8innig odinakonige8ini8an kidji gi paiekideeiendagozi8adj. Tasin modaiabikon 8aiej nijidana tibaigan konigotc nisomidana tibaigan kadagi apisobi8an pepejig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesos ogi inan ini8e ka anokitagendjin: “Siginamok iima nibi modaiabikokag kidji kicponebigin.” Midac ogi kicponebadona8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesos dac ogi inan: “Pagi siginamaok, acitc iji8idamaok aa8e ka kackakadag niba8i magocani.” Midac ogi iji8idama8a8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Aa ka kackakadag ogi kodjipidan ii nibini, aja dac cominabo8anigoban. Ka8in okikendasinaban adi 8edjimaganig ii cominaboni, pekic dac igi8e ka anokitage8apan okikendana8aban. Aa dac kacka ogi nd8e8eman ini naben ka niba8indjin, ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","acitc ogi inan: “Apanigotc ma8adji ka min8agamig cominabo nitam migi8ani8an, midac apitc ani mojito8adj a8iagog, aja ega teb8e ka min8agamig cominabo migi8ani8an. Kin dac pekic nogom kiabadj kigi kana8endan ma8adji ka min8agamig cominabo.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Midac ii Jesos ka todag Kana odenag, Galilee akikag, nitam ka mamada8izigobanen. Ki 8abadai8e iidi odicpendagozi8in, acitc okikinoamaganan ogi teb8etagon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kegapitc dac, Kaponaom (Capernaüm) odenag ki ija. Odjodjoman, o8idjiki8en, acitc okikinoamaganan ogi 8idji8an. Ka8in dac kin8ej ki tajikesi8ag 8edi. ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Apitc e peconag8anig Coda8inni Kitci Magocani, Pak ka ijinikadenig, Jesos ki ija Jerusalem odenag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Iima dac, ki ija Coda8inni kitci aiamiemigi8amikag. 8edi pidigeatig, ogi 8abaman a8iagon e taji ada8endjin mictozon, mantcenican, acitc omimin ka 8abizindjin. Mina8adj dac ogi 8abaman a8iagon ka meckodonandjin conian e taji abindjin o8isini8aganikag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Midac ogi ojiton sesababi pajacteiganeabini acitc kakina ogi sagidjinija8an ini a8ian kigi omantcenicimini acitc omictozomini. Ogi k8anabi8ebinanan o8isini8agani8an ini8e ka meckodonandjin conian, e iji 8ebinadjin motakamig oconiamini. ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ogi inan ini8e ka ada8endjin omimin ka 8abizindjin: “Anodj 8edi iji8idaokon! Ka8in ada8eogamigo8asinon Nidadam omigi8am!” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Midac okikinoamaganan ki mika8i8an Kije Manidon Omazinaigani kagi ikidomaganigobanen: “Tebendjigean! E kitci sagito8an kimigi8am, mi kegi odji nisigo8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Midac nandam Coda8innig ka niganizi8adj ogi k8ag8edjima8an Jesosan: “Kicpin ikido8an Kije Manido kagi pagidinik kidji todaman ii, 8abadai8en e mamada8izian. Midac kidji kikendamag Kije Manido egi inik iidi kidji iji todaman!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesos dac ogi nak8e8ajian: “Kicpin nici8anadjito8eg oo kitci aiamiemigi8am, nisogon inigik niga tajikan kidji koki ojito8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ki inagani8i dac: “Nimidana acitc nigod8aso (46) pibon nigi tajikananan kidji gi ojito8ag oo kitci aiamiemigi8am. Kin dac, adi ke todaman nisogon eta kidji tajikaman kidji koki ojito8an?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","8ina8a dac ka8in onisidotasina8a adi Jesosan ka 8i ikidondjin. Ka8in Coda8inni aiamiemigi8amini ododji mikodasin Jesos. 8in o8ia8 omikodanaban, Kije Manidon omigi8amini ka apitendag8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nage dac, apitc Jesos ka abidjibagobanen, okikinoamaganan ki odji mika8i8an egi ikidogobanen ii. Midac ogi teb8etana8a Kije Manidon Omazinaigani acitc Jesosan odikido8inan kagi ikidondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Meg8adj Jesos kiabadj e tepan Jerusalem odenag Coda8inni Kitci Magocani odji, mane a8iagon ogi 8abamigon ka iji mamada8izidj, acitc ogi teb8etagon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jesos dac 8in, ka8in oketcinamenimasi8abanin ini a8iagon. 8edjidagotc mega okikenimabanin kakina a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ka8in onada8endasinaban mamakadj kidji 8idama8agani8ipan adi ejinagozindjin a8iagon. Okikenimabanin mega ejideendjin pepejig a8ian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Teban pejig nabe, Nikodem (Nicodème) ijinikazogoban. Coda8innig ka nagadjito8agobanen inakonige8inan iji acidagimagani8igoban, acitc iji abigoban ka iji ma8adjiidinigobanen ka niganizindjin Coda8innin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Meg8adj e tibikanig, aa Nikodem ogi pi nda 8abamagoban Jesosan acitc ogi inan: “Kikinoamage8inni! Nikikendananan Kije Manido egi pidjinijaok kidji kikinoamagean. Ka8in mega a8iag okackitosin kin ka iji kackito8an kidji mamada8izian kicpin ega Kije Manidon ki 8idjiogodjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesos dac ogi nak8e8ajian: “Teb8e ki8idamon, ka8in a8iag ogagi 8abadasin Kije Manidon Odogima8i8ini kicpin ega koki nta8igidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodem dac ogi k8ag8edjiman: “Adi ke todag kitci anicinabe kidji gi koki nta8igidj? Ka8in mina8adj kadagi koki pidigesi odjodjomikag mina8adj kidji gi koki nta8igidj!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesos dac ogi nak8e8ajian: “Teb8e ki8idamon, ka8in a8iag kadagi pidigesi Kije Manidon Odogima8i8inikag kicpin ega nibikag acitc Mino Manidokag odji nta8igidj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Apitc a8iag nta8igidj, onigiigokag eta odji nta8igi, acitc pimadizimagani o8ia8. Anic dac a8iag Mino Manidokag ka odji nta8igidj, teb8e aja pimadizi8an odjitcagocan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ka8in kock8endaken kagi 8idamonan panima kidji koki nta8igieg kakina. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Apitc ako anodjigotc ijino8eg, kinodanadok adi enitag8ag e nodig, pekic dac ka8in kikikendasin adi 8edjino8eg konigotc adi e ijino8eg. Mi pejig8an ejinagozidj pepejig a8iag Mino Manidokag kagi odji nta8igidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodem dac ogi k8ag8edjiman: “Adi dac ii maia ejiseg?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesos dac ogi nak8e8ajian: “Kikitci inenimigo e kikinoamagean ooma Israel akikag. Kana pekic kinisidotasinan ini kegonan? ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Teb8e ki8idamon, nimikodananan kagi kikendamag acitc ni8idamagemin kagi iji 8abadamag, anic dac ka8in ki8i odapinasina8a ekido8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ka8in kiteb8etaojisim apitc mikodamanin kegonan ooma akikag kagi iji8ebagin. Adi dac ke odji teb8etaojiegoban kicpin mikodamonagok kegonan 8ak8ig e iji8ebagin? ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ka8in 8ikad a8iag 8ak8ig ki ijasi, mi eta nin, Ka pi Anicinabe8iidizodj, 8ak8ig ka pi odjian.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“8eckadj pig8adakamigokag Mois ogi ojiagoban pi8abiko kinebigon, acitc ogi acidak8a8an mitigokag. Midac ogi icpak8aan, ini8e a8iagon kagi mag8amigondjin kinebigon kidji gi 8abamandjin kidji gi kigendjin. Mi maia pejig8an ke todago8an, nin, Ka pi Anicinabe8iidizodj, panima niga acidak8aogo acitc niga icpak8aogo. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kakina dac a8iagog e teb8etaoji8adj ogagi aiana8a kagige pimadizi8ini.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kije Manido mega epitci sagiadjin a8iagon, ogi pidjinija8an Og8izisan ka motci pejigondjin. Kakina dac a8iagog ke teb8eta8a8adjin Kije Manidon Og8izisini, ka8in kada 8anicisi8ag, tiegodj oga aiana8a kagige pimadizi8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kije Manido mega ka8in ododji pidjinija8asi8an Og8izisan ooma akikag kidji tibakonandjin a8iagon, tiegodj kidji ag8acimandjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","A8enenigotc teb8eta8adjin Kije Manidon Og8izisini, ka8in tibakonagani8isi. Anic dac a8enenigotc ega teb8eta8adjin, aja tibakonagani8i, ka8in mega ododji teb8eta8asi8an Kije Manidon Og8izisini ka motci pejigondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mi oo8e Kije Manido ke odji tibakonigedj. Ki pija8an ooma akig Og8izisan, 8in ka iji 8aseanig ka apitendagozindjin. Misa8adj dac a8iagog na8adj omin8endana8a ka iji kacki tibikanig kidji te8adj apitc8in ka iji 8aseanig. Madji inakamigizi8ag mega. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Aa8e ka madji inakamigizidj, ka8in omin8endasin e 8aseanig acitc ka8in 8i ijasi ka iji 8aseanig. Okotan mega kidji 8abadjigadenig omadji inakamigizi8in. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Aa8e dac ka k8aiak8adizidj, ka iji 8aseanig ija, adi ejitadj kidji odji paietenag8anig e nosone8adjin Kije Manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kegapitc Jesos acitc okikinoamaganan pakan ki ija8ag kiabadj Coda (Judée) akikag e te8adj. Pagi dac kin8ej ogi 8idji tajikeman okikinoamaganan 8edi, acitc dac ki sigaadageban. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ii apitc, Cabadis ke8in sigaadageban Ainon odenajicini, pecodj Salim odena, osa 8edi kitci maneban nibi. Mane a8iagog ogi nda 8abama8an Cabadisan acitc ogi sigaadago8abanin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ka8in maci takonagani8isibanin Cabadisan ii apitc. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nandam Cabadis okikinoamaganan acitc pejig kodag Coda8inni ki k8ag8e cagozomidi8ag e mikodamo8adjin odijitcige8ini8an ka todamo8apan ako kidji gi paiekideeiendagozi8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ogi nda 8abama8an dac Cabadisan acitc ogi ina8an: “Kikinoamage8inni! Kimika8inan na aa ka paba 8idji8adiban agamig Jourdain sibikag, aa ka mikomadiban? Mi aja sigaadage acitc kakina 8inikag ijani8ani!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Cabadis dac ki nak8e8ajitage: “Ka8in a8iag kegoni ogagi odisigosin kicpin Kije Manidon ega minigodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kigi nodaojim ka ikido8an: ‘Ka8in nin aa8e ka taji pieg, Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin. Nin dac nigi pidjinijaogo kidji 8idama8ag8a a8iagog kidji eco8i8adj apitc tag8icinindjin,’ nigi ikidonan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kikikendananan nabe ke niba8idj kitci modjigendam, kada o8idigemagani mega. O8idji8aganan dac aa nabe ka niba8idj, ke8in kitci min8endamon e nodagodjin epitci kitci modjigendag. Nin dac, mi maia tabickotc o8idji8aganan aa8e ke niba8idj epitendagozian. Nogom dac odjitcise mizi8e kidji modjigendaman. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","8in dac eckam eckam kada ani kitci apitenimagani8i, nin dac eckam eckam niga 8anikanigo.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Aa8e 8ak8ig ka pi odjidj, 8in ma8adji kitci apitendagozi. Aa8e dac ooma akikag ka odjidj, ooma akikag iji tibendagozi, acitc omikodanan kegonan ooma akig ka tag8anigin. Aa dac 8ak8ig ka odjidj, na8adj kitci apitendagozi apitc8in kakina kodag a8ian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","8idamage dac adi ka iji 8abadag acitc adi ka iji nodag. Misa8adj dac ka8in a8iag oteb8etasin ekidondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","A8enenigotc dac ka teb8etag adi ekidondjin, 8abadai8e maia e ketcinamendag e teb8emaganig ekidondjin Kije Manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Aa8e Kije Manidon ka pidjinijaogodjin 8idamage Kije Manidon ka ikidondjin. Kije Manidon mega omockinetamagon Mino Manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Kije Manido osagian Og8izisan, acitc kakina kegoni ogi minan kidji tibendamindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","A8enenigotc ka teb8eta8adjin Kije Manidon Og8izisini, kagige pimadizi8ini odaian. A8enenigotc dac ega teb8eta8adjin Kije Manidon Og8izisini, ka8in 8ikad oga aiasin ii kagige pimadizi8ini, tiegodj apanigotc onickenimigon Kije Manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Coda8innig ka nagadjito8agobanen inakonige8inan ki nodagebanig na8adj mane a8iagon e nosone8andjin Jesosan acitc na8adj mane e sigaadagendjin apitc8in Cabadisan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Anic dac ka8in 8in Jesos sigaadagesiban, mi ini8e okikinoamaganan ka sigaadagenipanin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Apitc Jesos ka nodagedj egi mikomagani8idj, Coda (Judée) akini ogi nagadan acitc Galilee akikag ki koki ija. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Kidji gi ijadj dac 8edi, panima Samani (Samarie) akig kadagi ani ijaban. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","8edi dac Samani akikag, ki tag8icin pejig odenajicikag, Sikan (Sychar) ka ijinikadeg. Iima dac peconag8anoban Tcekap (Jacob) okitigan aki, kitci 8eckadj ka minapanin og8izisan Josepan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tag8anoban 8edi pejig odaiban, Tcekap 8eckadj ododaiban. Jesos kitci aiekoziban e pimodedj, midac ki abi iima pecodj odaibanikag. 8aiej abitakijiganogoban. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jesos okikinoamaganan odenag ki ija8an kidji nda nadjimidjimendjin. Kegapitc pejig ik8e Samani aki ka odjidj ki pija kidji pi nadobidj. Jesos dac ogi inan: “Pidon nibi kidji minik8eian.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Aa ik8e ki kitci mamakadendam acitc ogi inan Jesosan: “Kin kiCoda8inni8inan, nin dac niSamanik8e8inan. 8egonen dac 8edji k8ag8edjimijian kidji minainan?” ki ikido. Coda8innig mega ka8in odji pejig onada8enimasi8a8abanin Samani ka odjindjin a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesos dac ogi nak8e8ajian: “Kicpin kikendamaban 8egonen Kije Manido e migi8edj, acitc kicpin kikenimijiaban, nin ka k8ag8edjiminan kidji minaijinan nibi, kidagi k8ag8edjimijinan acitc kidagi minin nibi ka migi8emagag pimadizi8in,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Aa dac ik8e ogi inan: “Ka8in akik kidaia8asi acitc kitci 8asag anamig iji tag8an nibi. Adi dac ke todaman kin kidji gi k8abaaman ii nibi ka migi8emagag pimadizi8in? ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","8eckadj kikitci anicinabeminaban Tcekap kigi minigonan oo odaibani. 8in ki minik8e oo nibini, acitc ke8ina8a og8izisan acitc omantceniciman ki minik8e8an. Kidinenimidizonan na na8adj e kitci apitendagozian apitc8in Tcekap?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesos dac ogi nak8e8ajian: “A8enenigotc ke minik8edj oo nibini kiabadj kada 8i minik8e. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","A8enenigotc dac minik8edj nibini ke minag, ka8in 8ikad mina8adj kada 8i minik8esi. Nibini mega ke minag, mi maia mokidji8anobi ke ani ijinag8anig 8inikag, taji ke odjidji8ag kagige pimadizi8in.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Aa dac ik8e ogi inan: “Minicin ii nibi, ega mina8adj kidji 8i minik8eian acitc ega mina8adj mamakadj kidji pijaian ooma kidji pi nadobian.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesos dac ogi inan ini ik8e8an: “Nadji8ij ki8idigemagan. Pidji8ij dac ooma.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Aa dac ik8e ogi nak8e8ajian: “Ka8in nido8idigemaganisi.” Jesos dac ogi inan: “Teb8e ii ka ikido8an ega e aia8adj 8idigemagan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Aja ki nanani8ag ki8idigemaganag egi iji niba8ian, acitc nogom aa nabe ka 8idji tajikemadj ka8in kigi iji niba8isi. Kiteb8e.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Midac aa ik8e ogi inan: “Kikikenimin e niganadjimo8inni8ian! ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","8eckadj nikitci anicinabeminabanig ogi pi nda icpenima8an Kije Manidon ooma pik8adinakag, anic dac kina8a ka Coda8inni8ieg kidikidom ako mi panima Jerusalemikag ki ijani8ag kidji nda icpenimagani8idj Kije Manido.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesos dac ogi nak8e8ajian: “Teb8etaocin. Kada ijise ega kidji icpenimagani8idj Kidadaminan ooma pik8adinakag, ka8in kek8an 8edi Jerusalemikag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kina8a Samani ka odjieg, kidicpenima8a Kije Manido misa8adj ega e kikenimeg. Nina8it dac Coda8innig nikikenimanan Kije Manido ka icpenimagidj. Coda8innikag mega kada odjimagan kidji ag8acimagani8i8adj kakina a8iagog.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","“Nogom pi peconag8an, acitc aja iji8eban, Mino Manido kidji 8idjiadjin a8iagon kidji icpenimandjin Kidadaminanan. Oga 8idjian kidji kikenimandjin a8eneni8an ini maia Kije Manidon. Mi mega iidi Kidadaminan eji nda8enimadjin a8iagon kidji icpenimigodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ketcinadj mega manido8endagozi Kije Manido, acitc a8iagog mi eta k8aiak oga kackitona8a kidji icpenima8adjin kicpin Mino Manidon 8idjiigo8adjin ii kidji todamo8adj. Mi iidi ke odji kikenima8adjin a8eneni8an ini maia Kije Manidon.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Aa dac ik8e ogi inan Jesosan: “Nikikendan aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin kidji tag8icig, aa8e ‘Christ’ ka ijinikanagani8idj. Apitc ki pijadj, kakina kegoni kiga 8idamagonan.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesos dac ogi nak8e8ajian: “Nin mada aa Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin, nin ka taji aiamiinan.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ii dac apitc, Jesos okikinoamaganan ki pi tag8icino8an, acitc ki kitci mamakadendamon e 8abamigodjin Jesos e taji aiamiadjin ini ik8e8an. Misa8adj dac ka8in a8iag ododji k8ag8edjimasi8an: “8egonen neda8endaman?” konigotc “8egonen 8edji taji aiamiadj aa ik8e?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Midac aa ik8e ogi naganan odakikon acitc ki koki ki8e 8edi odenani ka odjidj acitc ogi inan 8edi a8iagon: ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Pijaok! Pi nda 8abamik aa nabe kagi 8idamaojidj kakina kegoni kagi pi aidian! Kadagi ijiseban na mi ini teb8e Kije Manido kagi ikidodj kidji pidjinija8adjin?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kakina dac odenag ki pi odose8ag kidji pi nda 8abama8adjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Meg8adj dac ii, Jesos okikinoamaganan ogi kadjinijaogon: “Kikinoamage8inni! Kida 8isin pinama!” ogi igon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jesos dac ogi nak8e8ajian: “Nidaian midjim kidji midjian, ega e kikendameg.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jesos dac okikinoamaganan ki k8ag8edjimidi8an: “A8ian na ogi pidamagon kidji 8isinidj?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesos dac ogi inan: “Kidji ijitaian adi eji nda8enimijidj aa ka pidjinijaojidj, acitc kidji ick8aikaman nimikimo8in kagi pidjinijaamago8an odji, mi ii 8edji pimadizian, mi maia kagi 8isinian ako enenimo8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Kidikidom ako: ‘Kiabadj niokizis pinici kidji odjitcisenig kidji ma8adjiagani8i8adj anominag.’ Anic dac nin kidininom, 8e8enda inabiok 8edi. Mi maia tabickotc ka iji kitigani8ag ejinag8ag. Aja ick8a madjigi8ag anominag, mi eta aja kidji gi ma8adjiagani8i8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Aja taji kijika8agani8i aa8e ka ma8adjiadjin anominan. Kidji kagige pimadizindjin a8iagon, mi ii anomin ka mikodaman. Midac aa8e ka kitigedj acitc aa8e ka ma8adjiadjin anominan, modjigendamog eji niji8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Teb8e ii ka ikidonani8ag ako: ‘Pejig a8iag kitige, kodag dac oma8adjian anominan.’ ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Aja kodagiag a8iagog ki kitige8ag acitc ki kitci mikimo8ag ka iji kitigani8anig. Nogom dac aja kigi ijinijaonom kidji nda 8idjieg8a. Ka8in kidodji kitigesim iima, misa8adj dac kiga mikimom iima, kidji ma8adjieg8a anominag.” Mi kagi inadjin Jesos okikinoamaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mane Samani8innig iima odenag ka odji8adj ogi teb8eta8a8an Jesosan. Aa ik8e mega ki 8idamage: “Nigi 8idamag kakina ka pi todaman,” mi 8edji ki teb8eta8a8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Apitc dac igi Samani ka odji8adj a8iagog ka pi nda 8abama8adjin Jesosan 8edi odaibanikag, ogi midjimina8an kidji 8idji tajikemigo8adjin. Midac Jesos ki nda tajike 8edi nijogon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Na8adj dac mane a8iagog ogi teb8eta8a8an e nodage8adj adi Jesosan ka ikidondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ogi ina8an dac ini ik8e8an: “Aja nogom niteb8etananan egi noda8agidj nina8it tibina8e, ka8in dac eta kin ka ikido8an. Aja nikikenimanan teb8e 8in aa8e ke ag8acimadjin a8iagon ooma 8akidakamig.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Apitc nijogon inigik ka tajikedj 8edi Samani akikag, Jesos ki odji madja acitc Galilee akikag ki ija. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Abidin Jesos 8in tibina8e ki 8idamageban: “Niganadjimo8inni ka8in teb8e apitenimagani8isi 8in odakikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Apitc dac Galilee akig ka tag8icig, a8iagog iima ka tajike8apan min8endamobanig e 8abama8adjin. Ke8ina8a mega ki ijabanig ka iji Kitci Magocani8anig Jerusalem odenag acitc ogi 8abadana8aban kakina kagi todaminigobanen ii apitc. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ki koki ija 8edi Kana odenag, Galilee akig ka iji tag8anig, adi ka todagiban kidji cominabo8itodj nibini. Iima dac teban pejig nabe kitci ogiman e anokita8adjin. Aa dac nabe tebanin og8izisan, ka kitci akozindjin 8edi Kaponaom (Capernaüm) odenag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Apitc ka nodagedj aa nabe egi tag8icinigobanen Jesosan Galilee akikag, Coda (Judée) akig egi pi odosendjin, ogi nda 8abaman acitc ogi kitci pagoseniman kidji ijandjin Kaponaom odenag kidji nda kigeandjin og8izisan. Aja mega kegat nibobanin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesos dac ogi inan ini naben: “Ka8in 8ikad kiga kackitosina8a kidji teb8etaojieg kicpin ega 8abamijieg e mamada8izian!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Aa dac nabe ogi nak8e8ajian: “Tebendjigean! Pijan nimigi8amikag ab8amaci nibodj nig8izis!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesos dac ogi inan: “Mi iji ki8en, kig8izis kada pimadizi.” Aa nabe ogi teb8eta8an adi ka igodjin Jesosan, acitc ki ki8e. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Meg8adj dac e ki8edj, ogi pi nagickagon odanokitage8inniman acitc ogi igon: “Ka8in aja nigodisi kig8izis!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Aa dac nabe ki k8ag8ed8e adi e taso tibaiganeanigiban apitc ka odji min8enimondjin og8izisan. Ki inagani8i dac: “8aiej pejigotibaiganeaban e ick8a abitakijigag onago apitc ka poni kijizodj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Teci8ag ki mika8i aa nabe mi ii maia e taso tibaiganeanigiban apitc Jesosan ka 8idamagodjin: “Kig8izis kada pimadizi.” Midac 8in acitc kakina omigi8amikag ka tajikendjin ogi teb8eta8a8an Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Mi ka iji mamada8izidj Jesos ka ick8a koki tag8icig Galilee akikag, Coda (Judée) akig egi pi odosedj. Mi aja nijinanaj egi mamada8izidj 8edi, kidji kikenimagani8idj Kije Manidon egi pidjinijaogodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kegapitc Jesos ki koki ija 8edi Jerusalem, Coda8innig pejig omagocani8an odji. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Iima dac Jerusalem tag8anoban “mantcenici ick8adem” ka ijinikadenig. Pecodj iima tag8anoban ka iji kabacimonani8ag, e nanotesisagag ke iji tabina8icimonani8ag. Ii8e dac ka iji kabacimonani8ag “Betsata” (Bethzatha) ijinikade Coda8inni ijigij8e8in. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Manebanig dac iima ka akozi8adj e taji pimakocino8adj tesisagakag, ega ka 8abi8adj, ka atci8icka8adj, acitc ega ka mazika8adj. Opitona8aban dac nibini kidji mamadagamisenig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kije Manido mega pejig odajeniman pi nda otadigotobanin ako nanigodin nibini kidji mamadagamisenig. Apitc dac ijisenigiban, aa nitam ka akozidj ke ipaniodj nibikag kada kige adigotc enapinedj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Iima dac tegoban pejig nabe e akozipan, aja nisomidana acitc nianenio (38) pibon akozigoban. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Apitc Jesos ka 8abamadjin ini a8ian e pimakocinindjin, acitc e kikenimadjin aja kitci 8eckadj e odji akozinipanin, ogi k8ag8edjiman: “Ki8i kige na?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Aa ka akozidj ki ikido: “Ka8in a8iag tesi kidji iji8inijidj nibikag apitc ako e mamadagamiseg. Apitc ako k8ag8e ipanio8an nibikag, aja kodag a8iag ipanio ab8amaci nin.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesos dac ogi inan: “8anickan, odapinan kidapicimon acitc pimosen.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Teci8ag dac aa a8iag ki kige. Ogi odapinan odapicimon acitc mi ka iji pimosedj. Ii dac apitc kagi iji8ebagiban, Coda8inni aiamie kijiganogoban. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Midac nandam Coda8innig ka niganizi8adj ogi ina8an ini a8ian kagi kigendjin: “Ogajigag aiamie kijigan acitc ikidomaganon kidinakonige8inanan ega e inendagozian kidji pimi8ido8an kidapicimon.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Aa8e dac nabe ogi nak8e8ajian: “Aa8e ka kigeijidj nigi 8idamag: ‘Odapinan kidapicimon acitc pimosen,’ nigi inig.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Midac igi8e Coda8innig ka niganizi8adj ogi k8ag8edjima8an: “A8enen dac aa kagi inik kidji odapinam8adj kidapicimoni acitc kidji pimosean?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Midac aa nabe kagi kigeagani8idj ka8in okikenimasin a8eneni8an kagi kigeigodjin. Ki kitci manenani8anoban iima, midac Jesos ki odji madjagoban. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nage dac Coda8inni kitci aiamiemigi8amikag Jesos ogi nagicka8an ini a8ian ka kigeadjin acitc ogi inan: “Ndotan, nogom aja kigi kige. Ka8in mina8adj patadiken, ega a8acamej kidji madjisean.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Aa nabe ki madja acitc ogi nda 8idama8an Coda8innin ka niganizindjin Jesosan ini ka kigeigodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Midac Coda8innig ka niganizi8adj 8edji ki ani madjita8adj kidji manenima8adjin Jesosan, egi iji todamindjin e aiamie kijiganig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesos dac ogi 8idama8an: “Nidadam kabena omino todan, misa8adj e aiamie kijiganig. Midac kenin kabena nimino todan tabickotc 8in.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Apitc Jesos kagi ikidodj ii, Coda8innig ka niganizi8adj ki inendamog: “Nitam ogi ana8etanan kidinakonige8inanan ka ikidomaganigin adi enendagoziak kidji inakamigiziak e aiamie kijiganig. Mina8adj dac ikido Kije Manido 8in ini Odadaman! Mi maia Kije Manido inenimidizodj!” Na8adj dac ogi odji nanada8i nisa8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesos dac ogi inan: “Teb8e ki8idamonom, ka8in nin tibina8e nikackitosin kegon kidji todaman. Panima e 8abamag Nidadam ejitadj, mi kenin pejig8an ejitaian. Midac kakina Nidadam ka ijitadj mi kenin ejitaian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nidadam mega nisagiig acitc kakina kegoni ni8abadaig ka ijitadj. Niga 8idjiig dac kidji todaman na8adj e macka8izimaganigin mamada8izi8inan. Midac kiga kitci mamakadendana8a. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tabickotc Nidadam ka abidjibaadjin ka nibondjin kidji koki pimadizindjin, mi kenin niminag pimadizi8ini a8iagog ka nda8enimag8a. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nidadam ka8in a8ian otibakonasin. Nin dac Og8izisan, nigi minig kakina macka8izi8ini kidji gi tibakonigeian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Mi kakina a8iagog kidji kitci manadjiiji8adj, tabickotc ka kitci manadjiagani8idj Nidadam. Aa8e ega manadjiijidj, ka8in omanadjiasi8an Nidadaman kagi pidjinijaojindjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Teb8e ki8idamonom, a8enenigotc ndotag ka ikido8an acitc teb8eta8adjin ini8e ka pidjinijaojindjin, kagige pimadizi8ini odaian. Ka8in dac kada tibakonagani8isi, tiegodj aja ki ag8acimagani8i ega kidji nibodj, acitc aja odaian kagige pimadizi8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mi tabickotc kagi nibo8adj ejinagozi8adj igi8e ega ka kikenima8adjin Kije Manidon. Teb8e ki8idamonom, kada ijise, acitc aja ijise nogom, kidji nodaoji8adj, nin Kije Manido Og8izisan. Midac igi8e ke nodaoji8adj acitc ke teb8etaoji8adj, oga aiana8a kagige pimadizi8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nidadam mega opimadizian a8iagon, midac kenin nigi minig kidji gi pimadiziag8a a8iagog. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Acitc dac nigi minig macka8izi8ini kidji tibakonigeian, nin mega Ka pi Anicinabe8iidizodj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ka8in dac mamakadendakegon. Aja mega peconag8an ka ick8a pimadizi8adj kidji nodaoji8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Midac kada pazig8i8ag kidji koki pimadizi8adj. Igi8e dac kagi mino inakamigizi8adj kada abidjiba8ag kidji kagige pimadizi8adj. Igi8e dac kagi madji inakamigizi8adj kada abidjiba8ag kidji tibakonagani8i8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jesos kiabadj ki ikido: “Nin dac, ka8in nidodji minigosi kidji todaman nin tibina8e enendaman. E tibakonigeian, Kije Manido ka iji 8idamaojidj, mi e todaman. K8aiakonag8an dac nitibakonige8in. Ka8in mega nin tibina8e eji nda8endaman nitodasin. Mi eta aa ka pidjinijaojidj ka iji nda8endag, mi e todaman.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Kicpin nin eta mikomidizo8an, ii ka ikido8an ka8in niga teb8etagosi. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Anic dac kodag a8iag nimikomig, mi aa Nidadam. Nikikendan dac eji mikomijidj teb8emagan ii.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Kigi ijinija8a8ag a8iagog kidji nda 8abama8adjin Cabadisan. Midac ki teb8e eji mikomijidj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ka8in pekic mamakadj ninada8endasin a8iag kidji mikomijidj. Misa8adj dac, kikoki 8idamonom adi Cabadis kagi ikidodj kidji gi ag8acimigo8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Cabadis mi maia ka 8asakonedj ejinagozipan e mikomijidj kina8akag. Kigi min8endana8a dac 8enibik kidji ndota8eg.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Cabadis ki teb8e e mikomijidj. Anic dac adi ejitcigeian, na8adj kitci paietenag8an egi pidjinijaojidj Nidadam, 8in mega nigi 8idamag adi ke todaman acitc mi eji todaman. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nidadam dac kagi pidjinijaojidj, mi ke8in nimikomig. Anic dac ka8in 8ikad kidodji noda8asi8a8a e anim8edj acitc ka8in 8ikad kidodji 8abamasi8a8a adi ejinagozidj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ka8in kikana8endam8asi8ana8an odikido8inan kidei8akag. Ka8in mega kiteb8etaojisim, nin ka pidjinijaojidj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kitci 8e8enda kinanada kikendana8a Kije Manido Omazinaigan, e inendameg kidji odji kikendameg adi ke iji kagige pimadizieg. Iima dac Omazinaiganikag nimikomigo. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Anic dac ka8in ki8i teb8etaojisim kidji aiameg kagige pimadizi8in.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ka8in abidji nikitci inendasin a8iagog kidji min8adjimiji8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kikikeniminom dac ega iidi e tieg. Nikikendan ega enigokodeeieg e sagieg Kije Manido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nigi pija ooma akig egi pidjinijaojidj Nidadam, misa8adj dac ka8in ki8i ndotaojisim. Kicpin dac kodag a8iag pijadj ega egi pidjinijaogodjin Kije Manidon, kiga ndota8a8a. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Adi dac kegi odji teb8etaojieg? Kimin8endana8a mega kidji min8adjimigo8eg, anic dac ka8in kinanada 8abadasina8a kidji min8adjimigo8eg Kije Manido ka motci pejigodj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Misa8adj dac, ka8in inendakegon nin kidji inactaonagok 8edi Nidadamikag. Mi aa Mois ke inactaonigo8eg, misa8adj inendameg kidji ag8acimigo8eg e kana8endamegon Mois odinakonige8inan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kicpin maia ki teb8eta8egoban Mois, kidagi teb8etaojim kenin. Nimikomigoban mega ka ojibiigedj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ka8in dac pekic kiteb8etasina8a ii ka ojibiag. Adi dac kegi odji teb8etameg ekido8an?” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kegapitc dac, Jesos ki ijagoban Galilee sagaigani, nanigodin Tipeniat (Tibériade) sagaigan ka ijinikadeg, acitc ki k8ekagamecka. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kitci mane a8iagon onosoneogobanin egi 8abadamindjin mamada8izi8inan ka todamogobanen e kigeadjin ka akozindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesos dac ki ik8amadji8e pik8adinajicikag, acitc ki nda abi iima, acitc okikinoamaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ii dac apitc, aja mina8adj peconag8anoban Coda8inni Kitci Magocan, Pak ka ijinikadeg. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesos e ainabidj ogi 8abaman kitci mane a8iagon e pi nda nagickagodjin. Ogi inan dac Pilipan (Philippe): “Adi kegi iji odapinamakoban midjim kidji gi minaiakobanig igi a8iagog?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesos dac onada kikendanaban adi Pilip ke ikidogobanen, mi 8edji ki ikidodj ii. Jesos mega ajagotc okikendanaban adi ke todag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilip ogi nak8e8ajian: “Misa8adj kakina a8iagog pagi eta 8isini8adj, panima a8iag kidji mikimopan a8acamej nianeniokizis, mi inigik ke ijisepan conia kakina kidji acamagani8i8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Kodagian dac Jesos okikinoamaganan, Andre ka ijinikazogobanen, Simo Pien o8idjiki8en, ogi inan Jesosan: ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Te ooma ockina8es e aia8adjin nanan obiziganesan acitc nijin kigozan. Misa8adj dac, ketcinadj ka8in kada tibisesinon kakina a8iagog odji, kana?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesos dac ogi inan okikinoamaganan: “8idamaokog kidji abi8adj kakina a8iagog.” Kitci mijacko8anoban iima, midac ki abi8agoban. 8aiej nanan kitci midasomidana (5000) taci8agoban nabeg. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesos dac ogi odapinan ini obiziganesan, mig8etc ogi inan Kije Manidon, acitc ki anoki kidji madinama8agani8indjin a8iagon ka abinigobanen iima. Kigozan acitc ogi minan, inigik neda8enimandjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ka ick8a 8isini8adj kakina, Jesos ogi inan okikinoamaganan: “Ma8adjitaok kakina ka eckoseg midjim, ega kegon kidji 8anadjitcigadeg.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Midac ogi ma8adjia8agoban obiziganesan kagi odji ickosendjin acitc ogi kicponatona8agoban midatcin acitc nijin 8adabi8akik8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","A8iagog dac egi 8abama8adjin e todamindjin ii mamada8izi8ini, ki ikido8ag: “Ketcinadj mi aa niganadjimo8inni ka piaiak kidji pijadj ooma akikag!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesos dac ogi kikendanagoban kidji pi nadji8inigodjin, e 8i ogima8iigodjin. Midac mina8adj ki koki ija pik8adinajicikag 8in eta. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Apitc e onag8icinig, Jesos okikinoamaganan ki nazibi8an sagaiganikag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ki pozi8ag tcimanikag, kidji ajo8aamo8adj, Kaponaom (Capernaüm) odenani e 8i ija8adj. Ki ani tibikanogoban, acitc dac ka8in maci Jesos ododji nagicka8asi8abanin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kitci nodinigoban acitc kitci mamagaanogoban ii sagaigan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nisin kek8an niotibaigan inigik ki inak8aji8e8agoban, apitc ka odji 8abama8adjin Jesosan. Opi nda nagickago8agoban tcimanikag, 8agidjibig e iji pimosendjin. Ki kitci segizi8ag dac. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesos dac ogi inan: “Nin Jesos! Ka8in segizikegon!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ogi min8endana8a dac kidji pozia8adjin tcimanikag. Midac teci8ag ki mijagaamog ka 8i ija8apan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","8iabanig, kitci mane a8iagog kiabadj te8agoban k8ekagam sagaiganikag, adi Jesos mig8etc kagi iji inadjin Kije Manidon acitc a8iagog ka iji am8a8apanin pak8ejiganan. Ki mika8ibanig dac kagi motci pejig8anogobanen tcimani iima acitc okikendana8aban Jesosan ega egi pozinipanin ii tcimanikag, okikinoamaganan eta ki iji pozinigoban. Kegapitc dac kodag tcimanan Tipeniat (Tibériade) odena e odjimagagin ki mijagaamomaganon iima. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Apitc dac igi a8iagog ka pabiziskendamo8adj ega iima e tenipanin Jesosan kek8an okikinoamaganan, ki pozi8ag iima tcimanikag. Midac Kaponaom ki ija8ag kidji nanada 8abama8adjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Apitc dac Jesos kagi mika8agani8idj k8ekagam, ki k8ag8edjimagani8i: “Kikinoamage8inni! Anapitc ka tag8icinian ooma?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesos dac ogi nak8e8ajian: “Teb8e ki8idamonom, ka8in egi nisidotameg adi 8a ikidomagag kagi iji mamada8izian 8edji nanada 8abamijieg. Tiegodj, kinanada 8abamijim egi am8eg8a pak8ejiganag acitc egi odji tebickono8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nanada 8abadamok midjim kabena ke min8acig acitc kagige pimadizi8ini ke migi8emagag. Ka8in dac nanada 8abadakegon midjim ega apanigotc ke tag8ag. Nin, Ka pi Anicinabe8iidizodj, kiga mininom midjim ega 8ikad kidji 8anadag. Kije Manido mega, Nidadam, ki 8abadai8e egi min8abamijidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Midac ogi k8ag8edjima8an: “Adi ke todamagiban kidji gi anokita8agidj Kije Manido?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesos dac ogi nak8e8ajian: “Mi oo8e Kije Manido eji nda8endag kidji todameg. Kinada8enimigo8a kidji teb8etaojieg, nin ka pidjinijaojidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Midac ogi ina8an Jesosan: “8egonen mamada8izi8in kegi todamaban kidji gi teb8etago8an? 8eckadj kikitci anicinabeminabanig ogi am8a8abanin ini pak8ejiganan kagi minigo8adjin Kije Manidon pig8adakamigokag. Tabickotc Kije Manido Omazinaigan ekidomaganig: ‘Ki minagani8i8ag pak8ejiganan 8ak8ig e odjisendjin.’ Kin dac, adi ke todaman?” ogi k8ag8edjima8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesos dac ogi nak8e8ajian: “Teb8e ki8idamonom, ka8in Mois kagi minigo8eg pak8ejiganan 8ak8ig ka odjisendjin. Nidadam dac 8in kiminigo8a 8edjida pak8ejiganan 8ak8ig ka pi odjisendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ini dac pak8ejiganan Kije Manido ka migi8edj, mi ini8e a8ian 8ak8ig ka pi odjidj acitc ka minadjin pimadizi8ini a8iagon ooma akikag,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ogi ina8an dac Jesosan: “Jesos! Kabena mijicinam aa pak8ejigan.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesos dac ogi inan: “Nin aa pak8ejigan ka migi8edj pimadizi8ini. Aa8e ke pi nazikaojidj acitc ke teb8etaojidj, ka8in 8ikad kada 8i 8isinisi acitc ka8in 8ikad kada 8i minik8esi. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Oo8e dac aja kigi 8idamonom, kigi 8abamijim, misa8adj dac ka8in ki8i teb8etaojisim. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kakina ini8eni8an Nidadam ka minijidj niga nosoneogog. A8enenigotc dac ke pi nazikaojidj, ka8in 8ikad niga ana8eta8asi. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","8ak8ig mega nigi pi odji, kidji todaman ka iji nda8endag aa8e kagi pidjinijaojidj. Ka8in nidodji pijasi ooma akig kidji todaman nin eji nda8endaman. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","8adan dac oo8e eji nda8endag 8in kagi pidjinijaojidj, ega iaga pejig ii e tacindjin a8iagon kagi minijidj kidji gi odji 8aniimagin, tiegodj kidji gi abidjibaimagin kidji gi kagige pimadizindjin apitc ke ponaki8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nidadam mega onada8eniman kakina kagi nisida8inaojindjin nin Kije Manido Og8izisan e aiaa8ian, acitc kagi teb8etaojindjin, kidji aiamindjin kagige pimadizi8ini. Midac kidji abidjibaag8a apitc ke ponaki8anig,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Apitc ka ick8a anim8edj Jesos, nandam Coda8innig ogi madji inadjima8an Jesosan, egi ikidondjin: “Nin pak8ejigan 8ak8ig ka odjisedj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ikidobanig dac: “Kana mi 8aa Jesos, Josep og8izisan? Kikikenimananan odadaman acitc odjodjoman. Adi 8edji ikidodj ‘8ak8ig nidodji’?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesos dac ogi nak8e8ajian: “Ponitaok eji mikomijieg. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ka8in a8iag nigagi pi nazikagosi kicpin ega Nidadaman 8ikobinigodjin, midac niga abidjibaa apitc ke ponaki8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ki ojibiige8ag niganadjimo8innig oo8eni: ‘Kije Manido kakina oga kikinoama8an ka tacindjin,’ ojibiigade. Kakina dac niga pi nazikagog, kagi noda8a8adjin Nidadaman acitc kagi kikinoamago8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ka8in sa tesi a8iag egi 8abamadjin Nidadaman. Nin eta, Kije Manido ka pidjinijaojidj, nigi 8abama. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Teb8e ki8idamonom, a8enenigotc e teb8etaojidj odaian kagige pimadizi8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nin pak8ejigan kagige pimadizi8ini ka migi8edj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","8eckadj kikitci anicinabemi8abanig ogi am8a8an ini pak8ejiganan kagi minigo8adjin Kije Manidon pig8adakamigokag. Misa8adj dac ki nibo8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Anic dac a8enenigotc am8adjin pak8ejiganan 8ak8ig e odjisendjin, ka8in 8ikad kada nibosi. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nin pak8ejigan 8ak8ig kagi pi odjisedj, kagige pimadizi8ini e migi8edj. A8enenigotc ke am8ag8en ini pak8ejiganan, kagige kada pimadizi. 8adan oo8e nia8, mi 8aa pak8ejigan ke migi8eian, kidji gi pimadizi8adj a8iagog.” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ki odji kitci aiamiidi8ag Coda8innig Jesosan kagi ikidondjin. Nandam dac ikidobanig: “Adi 8aa nabe kegi odji minigo8akoban o8ia8 kidji midji8aiak?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesos dac ogi inan: “Teb8e ki8idamonom, kicpin ega midjieg Ka pi Anicinabe8iidizodj o8ia8 acitc ega minik8eieg omisk8i, ka8in kigagi aiasina8a kagige pimadizi8in. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Aa8e ke midjig8en nia8ini acitc ke minik8eg8en nimisk8ini oga aian kagige pimadizi8ini, acitc niga abidjibaa apitc ke ponaki8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Teb8e mega min8acin nia8 kidji midjigadeg, acitc teb8e min8agamin nimisk8i kidji minik8adjigadeg. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Aa8e ke midjig8en nia8ini acitc ke minik8eg8en nimisk8ini, ninikag iji tajike, acitc kabena ni8idji8a. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nidadam ka migi8edj pimadizi8ini nigi pidjinijaog, acitc nigi minig kidji pimadizian. Mi pejig8an, a8enenigotc ke amojig8en, niga mina kagige kidji pimadizidj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mi 8aa pak8ejigan 8ak8ig ka odjisedj. A8enenigotc dac ke am8ag8en ini pak8ejiganan kagige kada pimadizi. Ka8in 8in tabickotc ijinagozisi8an ini pak8ejiganan ka am8a8adjin 8eckadj kikitci anicinabemi8abanig. Misa8adj egi am8a8adjin, ki nibo8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Mi oo Jesos kagi kikinoamagedj Coda8inni aiamiemigi8amikag, meg8adj Kaponaom (Capernaüm) odenag e tepan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ka ick8a ndotagodjin Jesos, mane okikinoamaganan ikidobanin: “Ozam sanaganon kidji nisidotcigadegin ini kikinoamage8inan. A8enen kegi ndotagin ini?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesos okikendanaban okikinoamaganan e taji madji mikodamindjin adi ka ikidodj. Midac ogi inan: “Kidana8etana8a na oo ka ikido8an? ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Adi dac ke inendameg kicpin 8abamijieg nin, Ka pi Anicinabe8iidizodj, koki ki8eian adi ka odjian? ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mino Manido mi aa ka migi8edj pimadizi8ini, ka8in a8iag 8in tibina8e okackitosin kidji odisigodj. Ini anim8e8inan ka 8idamonagok, Mino Manidokag odjimaganon, 8in ka migi8edj kagige pimadizi8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","65","Misa8adj dac, nandam kina8a ka8in kiteb8etasina8a, mi 8edji ininagok ega a8iag kidji pi nazikaojidj kicpin ega Nidadaman pagidinigodjin,” ogi inan. Jesos mega aja 8eckadj okikendanaban a8eneni8an ega ke teb8etagodjin acitc a8eneni8an ke mamijimigodjin, ka ako madjitadj kidji kikinoamagedj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Midac ii apitc mane Jesos okikinoamaganan ogi naganigon, acitc ka8in mina8adj ododji nosoneogosin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesos dac ogi k8ag8edjiman ka midatcin acitc nijindjin okikinoamaganan kagi onabamadjin: “Ki8i madjam na kekina8a?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simo Pien ogi nak8e8ajian: “Tebendjigean! Adi dac ke ijaiagiban? Kin kikikinoamaojinam adi ke iji aiamag kagige pimadizi8in. ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nogom dac kiteb8etaogo acitc kiketcinamenimigo kin 8aa ka kitcit8a8izidj, Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesos dac ogi inan: “Kigi onabaminom e midatcin acitc nijieg, kana? Misa8adj dac, pejig e tacieg madji manidon okigickagon.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judasan omikomagobanin, Simo Iskaniot (Iscariote) og8izisan. Judas mega pidjinag oga ani mamijimabanin Jesosan, misa8adj e acidagimagani8igobanen ka midatcin acitc nijindjin Jesos okikinoamaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mina8adj dac, Jesos ki paba ija Galilee akini. Ka8in 8i paba ijasiban Coda (Judée) akini, Coda8innig mega iima ka niganizi8adj o8i nanada8i nisa8abanin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Aja peconag8anoban ka Coda8inni8ikijigag, mi apitc ako e ma8adjiidi8apan Jerusalemikag acitc nibaganikag ako tajikebanig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jesos dac o8idjiki8en ogi igon: “Ooma odji madjan, Coda akikag dac ijan, kidji 8abadamo8adj ke8ina8a 8edi ka 8i nosoneok8a adi e iji kitci kackito8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ka8in a8iag okadosin ka iji kackitodj kicpin nda8endag kidji kikenimagani8idj. Kicpin dac teb8e ii ka iji kitci kackito8an, 8abadaik kakina a8iagog 8edi adi eji kackito8an,” ki ikido8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ka8in mega 8a8adj o8idjiki8en oteb8etagosibanin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesos dac ogi inan: “Ka8in maci odjitcisesinon kidji madjaiaban, pekic dac kina8a kabe minoapitc ijise kidji ijaiegoban. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kina8a ka8in kimadjenimigosi8ag a8iagog ka ana8enima8adjin Kije Manidon, ka8in mega kegoni tag8asini ke odji madjenimigo8egoban. Nin dac nimadjenimigog, ni8idama8ag mega e madji ijitcige8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ijaok dac ka iji ma8adjiidinani8ag. Nin dac ka8in maci niga ijasi, ka8in mega maci odjitcisesinon kidji ijaiaban.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Oo dac ka ikidodj, Jesos kiabadj 8enibik ki tajike Galilee akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ka ick8a ijandjin dac Jesos o8idjiki8en ka iji ma8adjiidinani8anig, Jesos ki kimodji ija ke8in, ega kidji nisida8inagozidj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","8edi dac ka iji ma8adjiidinani8anig, Coda8innig ka niganizi8adj onanada 8abama8abanin Jesosan. Ikidobanig: “Adi dac e tag8en?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Igi kitci mane a8iagog kagi ma8adjiidi8agobanen 8edi, okimodji mamikoma8abanin Jesosan. Nandam ikidobanig: “Kitci k8aiakozi aa.” Kodagiag dac ikidobanig: “Ka8in ii! O8agackibinan mega a8iagon.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ka8in dac a8iag kiji8esiban e mikomadjin Jesosan, okosa8abanin mega Coda8innin ka niganizindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Apitc e ani abita ick8a ma8adjiidinani8anig, Jesos ki ija Coda8inni kitci aiamiemigi8amikag acitc ki madjita kidji kikinoamagedj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Coda8innig ka niganizi8adj kitci mamakadendamobanig. “Adi 8edji kackitodj kidji iji kikinoamagedj, ega 8ikad egi kikinoama8agani8idj?” ikidobanin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesos dac ogi nak8e8ajian: “Oo8e ka kikinoamageian, ka8in nin enendaman nidiji kikinoamagesi. Kije Manidokag odjimagan, 8in kagi pidjinijaojidj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","A8enenigotc ka 8i ijitadj adi Kije Manidon ka iji nda8endamindjin, oga kikendan kicpin Kije Manidokag odjimaganig nikikinoamage8ini kek8an ninikag eta odjimaganig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","A8iag e ikidodj adi enendag 8in tibina8e, 8in eta 8i apitenimagani8i. Anic dac a8iag e nda8endag kidji apitenimagani8indjin ini kagi pidjinijaogodjin, teb8e aa, ka8in kagina8ickisi. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mois kigi minigo8a aiamie inakonige8ini, kana? Pekic dac ka8in pejig iaga e tacieg mizi8e kinosoneasina8a. 8egonen dac 8edji nanada8i nisijieg?” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ini a8iagon ogi nak8e8ajiigon: “Ketcinadj kikigickagodok madji manido. A8enen nenada8i nisik?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesos dac ogi inan: “Pejig mamada8izi8in nigi todan e aiamie kijigag, acitc kakina kigi kitci mamakadenimijim. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mois kigi inakonigo8a kidji pak8ej8eg8a kig8izisi8ag. Ka8in dac 8in eta Mois kagi iji inakonigedj, ke8ina8a 8eckadj kikitci anicinabeminabanig ab8amaci Mois ogi aiana8a ii inakonige8ini. Midac kidanokim kidji pak8ej8agani8i8adj kig8izisi8ag nianeniokajik eck8a nta8igi8adj, misa8adj e aiamie kijiganig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kicpin dac kackito8eg kidji pak8ej8eg ockina8es e aiamie kijiganig kidji gi kana8endamegon Mois odinakonige8inan, adi 8edji kiji8azieg mizi8e egi kigeag pejig nabe e aiamie kijiganig? ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ka8in a8iag inactaonakegon egi panaagedj ab8amaci ketcinamendameg. Nanada 8abadamok teb8e8in, k8aiak kidji kikendameg adi ka inakamigizidj,” ogi inan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nandam a8iagog Jerusalem ka odji8adj ikidobanig: “Kana mi aa nabe ka k8ag8e nisagani8idj? ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","8adan aa! Taji kikinoamage ka iji manenani8anig acitc ka8in kegoni inagani8isi. Ka niganizi8adj ne8ad oketcinamenima8adog8enan mi ini8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin, kana? ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pekic dac apitc tag8icig aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin, ka8in a8iag oga kikendasin adi ka odjindjin. Aa dac nabe kikikenimanan adi 8edjidj,” ki ikido8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Meg8adj dac Jesos kagik8eban kitci aiamiemigi8amikag, ki ikido e kiji8edj: “Teb8e na kikikenimijim? Teb8e na kikikendana8a adi 8edjian? Ka8in nin tibina8e nidodji pidjinijaodizosi. Kije Manido kagi pidjinijaojidj, mi aa maiagotc e teb8eiendagozidj. Ka8in dac kina8a kikikenimasi8a8a. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nin dac nikikenima. Ka iji tedj mega nidodji acitc 8in aa kagi pidjinijaojidj,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Midac nandam igi8e a8iagog ogi k8ag8e takona8an Jesosan. Ka8in dac a8iag ododji kackiasin kidji katcidinadjin. Ka8in mega maci odjitcisesiniban kidji takonagani8idj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kitci mane dac a8iagog ka iji ma8adjiidi8adj ogi teb8eta8a8an. Ikidobanig dac: “Apitc tag8icig aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin, na8adj na mane kada iji mamada8izi apitc8in aa nabe eji kackitodj?” ki ikido8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Coda8innig ka nagadjito8agobanen inakonige8inan ki nodage8ag adi eji kimodji ikidonani8anig, Jesosan e mikomagani8indjin. Midac Coda8inni kitci aiamie ogimag acitc Coda8innig ka nagadjito8agobanen inakonige8inan ogi ijinija8a8an ini8eni8an ka kana8endamindjin kitci aiamiemigi8amini kidji a8i takonandjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesos dac ki ikido: “Ka8in aja kin8ej niga tesi kina8akag. Aja mega kegat niga nda 8abama aa8e kagi pidjinijaojidj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ii dac apitc, kiga nanada 8abamijim, ka8in dac kiga mikaojisim. Ka8in acitc kigagi ijasim adi ke teian,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Coda8innig ka niganizi8adj k8ag8edjimidibanig: “Adi ke ijadj ega kidji kackito8ak kidji mika8aiak? Kada ija na kidji nda 8abamadjin kodagian Coda8innin, omigi8aminikag kagi odji sagidjinija8agani8indjin, Kanes (Grèce) akikag ka a8i tajikendjin? Oga kikinoama8an na a8iagon Kanes aki ka odjindjin? ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ikido aa nabe: ‘Kiga nanada 8abamijim, ka8in dac kiga mikaojisim,’ acitc: ‘Ka8in kigagi ijasim adi ke teian.’ Adi 8a ikidodj?” ki inidi8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ma8adji apitendag8anoban ick8eag kijik ka ma8adjiidinani8ag. Ii apitc Jesos ki tajigaba8i acitc ki pibagi: “Kicpin a8iag 8i minik8edj, nida pi nazikag acitc niga mina kidji minik8edj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mi ke ijinagozidj aa ka teb8etaojidj, nibini ka migi8emaganig pimadizi8ini kidji kitci odjidji8anig odeikag, mi iidi ekidomaganig Kije Manido Omazinaigan,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesos omikomabanin Mino Manidon, ini8e ke teb8etagopanin kidji odisigondjin. Ka8in mega maci ododji odisigosi8an Mino Manidon ka teb8etamo8adj. Jesos mega ka8in maci odji koki ijasi Odadamikag kidji gi icpendagozidj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nandam a8iagog ka nodamo8adj ka ikidondjin Jesosan, ikidobanig: “Ketcinadj mi aa nabe niganadjimo8inni ka piaiak.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Kodagiag dac ikidobanig: “Mi aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin.” Kiabadj dac kodagiag ikidobanig: “Ka8in sa Galileekag kada odjisi aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin! ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mazinadeni mega Kije Manido Omazinaiganikag Davidikag kidji odaiagizidj aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin, acitc Betleem kidji iji nta8igidj, ka iji tajikegobanen David,” ikidobanig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Midac pepakan ogi inenima8an Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nandam o8i takona8abanin Jesosan, ka8in dac a8iag kegoni ododji toda8asin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Igi8e ka kana8endamo8adj kitci aiamiemigi8amini ogi koki nda 8abama8an Coda8inni kitci aiamie ogiman acitc Coda8innin ka nagadjitonigobanen inakonige8inan. Ki k8ag8edjimagani8i8ag dac: “Adi 8edji ega ki pidji8ineg?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Igi8e dac ka kana8endamo8adj kitci aiamiemigi8amini ki nak8e8ajit8a8ag: “Ka8in 8ikad a8iag odji kikinoamagesi ka iji kikinoamagedj aa nabe.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Midac Coda8innig ka nagadjito8agobanen inakonige8inan ogi k8ag8edjima8an ini8e ka kana8endamindjin kitci aiamiemigi8amini: “Kigi 8agackibinigom na kekina8a? ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Te na pejig Coda8inni ka niganizidj kek8an pejig Coda8inni ka nagadjitodjin inakonige8inan egi teb8eta8adjin? Ka8in 8a8adj pejig ka taci8adj ogi teb8eta8asi8an! ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Igi dac a8iagog ka teb8eta8a8adjin ka8in okikendasina8an Moisan odinakonige8inan. Mi ini8e Kije Manido kagi ikidodj kidji nici8anadjiondjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Aa dac nabe Nikodem ka ijinikazogobanen ke8in iima tegoban, mi aa pejig ka taci8adj Coda8innig ka nagadjito8agobanen inakonige8inan. Mi 8aa abidin kagi nda 8abamadjin Jesosan. Ogi inan dac kodagian o8idji niganizi8inniman: ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Kidinakonige8inanan ikidomaganon ega kidji tibakonagani8idj a8iag ab8amaci nodageiak adi e ikidodj acitc ab8amaci kikendamak adi maia ka inakamigizidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ogi nak8e8ajia8an dac: “Galileekag na kidodji kekin? Nabo8adan Kije Manido Omazinaigan, midac kiga kikendan ega 8ikad pejig niganadjimo8inni Galileekag egi odjidj,” ki ikido8ag.  ");
INSERT INTO alqALGNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Midac kakina ki ki8e8ag omigi8ami8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesos dac 8in ki ija pik8adinajicikag, “Olip” (Oliviers) ka ijinikadenigobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","8ibadj mina8adj e kijeba8acinig, Jesos ki koki ija Coda8inni kitci aiamiemigi8amikag. Kitci mane a8iagon ogi pi nazikagon. Ki abi, midac ka iji madjitadj kidji kikinoamagedj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Coda8inni kikinoamage8innig acitc Coda8innig ka nagadjito8agobanen inakonige8inan ogi iji8idama8a8an Jesosan pejig ik8e8an e niba8indjin egi katcidinagani8indjin e taji 8izig8amandjin kodagian naben. Nigan a8iagokag ogi iji8ina8an ini ik8e8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Midac ogi ina8an Jesosan: “Kikinoamage8inni! Aa ik8e ki katcidinagani8i e taji 8idji8adjin kodagian naben. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mois ki inakonige kidji nisagani8i8adj e pim8asinaagani8i8adj ik8e8ag kagi katcidinagani8i8adj kodagian naben e 8idji8a8adjin. Kin dac, adi enendaman?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","O8i k8ag8e katcidina8abanin mega Jesosan anodj kidji iji nak8e8ajii8endjin, kidji gi inactaona8adjin, mi 8edji ki ikido8agobanen ii. Jesos dac ki camagi, acitc ki madjita e ojibiigedj motcikag odinoigandjan e abadjitodj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ka8in ododji ponitosina8a kidji k8ag8edjima8adjin Jesosan adi enendamindjin. Jesos dac ki koki pazig8i, midac ogi inan: “A8enenigotc ega 8ikad egi patadidj, 8in nitam oga pim8asinaan.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Midac ki koki camagi, kiabadj e ojibiigedj motcikag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Apitc ka nodamo8adj adi ka ikidondjin, pejapejig ki ani madja8ag, pinama ma8adji ka keteadizi8adj. Kegapitc dac Jesos 8in eta teban acitc ini ik8e8an kiabadj taji tajigaba8ibanin nigan 8inikag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesos dac ki koki pazig8i acitc ogi inan: “Ik8e! Adi apan a8iagog? Kana a8iag kidick8aienimigosi?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ogi nak8e8ajian: “Ka8in a8iag, Tebendjigean.” Jesos dac ogi inan: “Ka8in kenin kidick8aienimisinon. Kigagi madja, anic dac ka8in mina8adj patadiken,” ogi inan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesos mina8adj ogi aiamian a8iagon kitci aiamiemigi8amikag ka tendjin, e inadjin: “Nin aa ka 8asenama8adjin kakina a8iagon ooma akikag. Aa8e ke nosoneojidj, ka8in 8ikad ka iji kacki tibikanig kada iji pimosesi, tiegodj oga aian 8asea8ini taji ka odjimaganig pimadizi8ini,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Coda8innig ka nagadjito8agobanen inakonige8inan ogi ina8an: “Kinigotc kimikomidizonan. Ka8in dac ii tibise kidji gi odji teb8etago8aban,” ki ikido8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesos dac ogi nak8e8ajian: “Misa8adj ninigotc e mikomidizo8an, niteb8e. Nikikendan mega adi 8edjian acitc adi ejaian. Kina8a dac ka8in kikikendasina8a adi 8edjian kek8an adi ejaian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mi maia pejig8an onenimijieg tabickotc ka onenimidi8adj ako a8iagog. Nin dac 8in ka8in a8iag nidonenimasi. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Anic dac kicpin onenimag a8iag, niga k8aiak8enima. Ka8in mega nin eta nitidesi, Nidadam ka pidjinijaojidj ni8idjiog. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ojibiigade kidinakonige8ini8akag kidji teb8eta8agani8i8adj nijin a8iagog tabickotc ikido8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ninigotc dac nimikomidizonan acitc mi ke8in Nidadam ka pidjinijaojidj nimikomig,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ogi k8ag8edjima8an dac Jesosan: “Adi dac e tadj kidadam?” Jesos dac ogi nak8e8ajian: “Ka8in maia kikikenimijisim, ka8in kek8an kikikenimasi8a8a Nidadam. Kicpin kikenimijiegoban, kida kikenima8a Nidadam acitc.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesos ki ikido ii meg8adj Coda8inni kitci aiamiemigi8amikag e kagik8epan, pecodj ka iji kana8enimagani8idj conia ka pagidinigenani8ag. Ka8in dac a8iag ododji pamenimasi8an Jesosan, ka8in mega maci odjitcisesiniban kidji takonagani8idj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesos ki ikido kiabadj: “Pidjinag niga madja acitc kiga nanada 8abamijim. Ka8in dac kiga kackitosina8a kidji pijaieg adi ke ijaian. Kiga nibom ega ki kasiigadegin kipatado8ini8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Coda8innig dac ka niganizi8adj ikidobanig: “Ne8ad 8i nisidizodok. Mi 8edji ikidodj: ‘Ka8in kiga kackitosina8a kidji pijaieg adi ke ijaian.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesos dac ogi nak8e8ajian: “Ooma akikag kidodjim, nin dac 8ak8ig nidodose. Ooma akikag kidiji tibendagozim, ka8in dac nin ooma nidiji tibendagozisi. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mi ii 8edji ki ininagok kidji nibo8eg ega egi kasiigadegin kipatado8ini8an. Kicpin dac ega teb8etaojieg e tibadjimo8an a8enen e aiaa8ian, teb8e kiga nibom ega egi kasiigadegin kipatado8ini8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Midac ogi k8ag8edjima8an Jesosan: “A8enen dac kin maia?” Jesos ogi nak8e8ajian: “Ka ako madji kikinoamageian, kigi 8idamonom a8enen e aiaa8ian nin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kitci mane kegon nidaian kidji ininagok acitc kidji odji tibakoninagok. Ni8idama8ag a8iagog ooma akikag kegonan eta kagi iji nodageian, kagi ikidodj aa8e kagi pidjinijaojidj, kabe ka teb8eiendagozidj,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","A8iagog iima ka te8agobanen, ka8in ododji nisidotasina8a Jesosan e mikomandjin Odadamini. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jesos dac ogi inan: “Apitc acidak8aojieg acitc icpak8aojieg, nin Ka pi Anicinabe8iidizodj, kiga kikenimijim a8enen e aiaa8ian. Kiga kikenimijim ega e todaman nin tibina8e enendaman. Ka iji kikinoamaojidj eta Nidadam, mi eji tibadjimo8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nigi pidjinijaog acitc ni8idjiog. Ka8in nidodji naganigosi, nin eta kidji te8ag. Kabena mega adi eji min8endag nitodan.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Apitc ka ikidodj ii, kitci mane a8iagon ogi teb8etagon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kegapitc Jesos ogi inan ini8e Coda8innin ka ani teb8etagodjin: “Kicpin 8e8enda ndotameg nikikinoamage8in, maiagotc kinosoneojim. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kiga nisidotana8a teb8e8in, midac ke odji pagidabaogo8eg.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nandam a8iagog ogi nak8e8ajia8an: “Abanaamikag (Abraham) nigi pi odaiagizimin, acitc ka8in 8ikad a8iag nidodji tibenimigosimin. Adi dac 8edji ikido8an: ‘Midac ke odji pagidabaogo8eg’?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesos ogi nak8e8ajian: “Teb8e ki8idamonom, aa8e ka patadidj, patado8ini otibenimigon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mamidonendamok oo8e. A8iag ka anokita8adjin kodagian, ka8in apanigotc kada tajikesi okackaman omigi8aminikag. Mi eta kacka og8izisan, 8in apanigotc inendagozi kidji iji tajikedj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kicpin dac Kije Manido Og8izisan pagidabaogo8eg, maiagotc kiga odji pagidabaogom. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nikikendan Abanaamikag egi pi odaiagizieg. Anic dac kinanada8i nisijim, ega e 8i ndotameg nikikinoamage8in. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nidadam ka 8abadaijidj, mi ii e mikodaman. Kina8a dac kidadami8a ka igo8eg, mi e todameg.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ogi nak8e8ajia8an: “Nidadaminan aa Abanaam.” Jesos dac ogi inan: “Kicpin maia teb8e Abanaam odabinodjijiman apitendagoziegoban, Abanaam ka ijitcigedj kida ijitcigem kekina8a. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kigi 8idamonom teb8e8ini Kije Manido ka 8abadaijidj, misa8adj dac kinanada8i nisijim. Abanaam dac ka8in 8ikad iidi ogi todasin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ii dac e ijitcigeieg, mi maia pejig8an kidadami8a kagi ijitcigedj ejitcigeieg!” Ogi nak8e8ajia8an: “Ka8in pig8adojanag nidijinagozisimin. Maiagotc Kije Manido mi aa Nidadaminan.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesos dac ogi inan: “Kicpin ii maia teb8e Odadamiegoban Kije Manido, kida sagiijim. Kije Manidokag mega nigi pi odji, acitc 8in odji 8edji teian ooma. Ka8in ninigotc ka pidjinijaodizo8an, 8in sa ka pidjinijaojidj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Adi 8edji ega nisidotameg ka 8idamonagok? Ka8in ki8i ndotasina8a ka ikido8an, mi eta 8edji ega nisidotameg. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Madji manido 8aa kidadami8a, acitc ki8i todana8a adi eji nda8endag 8in kidadami8a. Kabe ki nici8e8inni8i, ka ako tag8anig akini. Ka8in 8ikad odji teb8esi, ka8in mega tag8asini teb8e8ini 8inikag. Apitc ako kagina8ickidj, apanigotc ka pi ijitcigedj mi eta ijitcige. Kabe mega kagina8icki acitc mi ini odadami8an kakina ka kagina8icki8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nin dac 8in e teb8eian, mi ii 8edji ega teb8etaojieg! ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","A8enen kina8akag kegi 8abadai8edj egi patadian? E teb8eian dac, adi 8edji ega teb8etaojieg? ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Aa Kije Manidokag ka iji tibendagozidj, onadotan ka ikidondjin. Kina8a dac, ka8in Kije Manidokag kidiji tibendagozisim. Mi ii 8edji ega ndotaojieg.” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Igi Coda8innig ogi ina8an Jesosan: “Maiagotc niteb8enanagoban apitc kagi ikido8agiban Samani (Samarie) akikag 8edjian acitc madji manido e kigickaok!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesos ogi nak8e8ajian: “Ka8in nikigickagosi madji manido. Nimanadjia Nidadam, kina8a dac ka8in ki8i manadjiijisim. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ka8in ninanada 8abadasin kidji icpenimigo8an. Nidadam 8in ii ka iji nda8endag nin kidji manadjiigo8an, acitc 8in aa ke tibakonadjin ini8e ega ka manadjiijindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Teb8e ki8idamonom, aa8e ka ndotaojidj adi ekido8ag, ka8in 8ikad kada nibosi.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Coda8innin dac ogi igon: “Nogom dac niketcinamendananan e kigickaok madji manido! Abanaam (Abraham) mega ki nibo, niganadjimo8innig acitc ki nibo8ag. Pekic dac kin kidikidonan: ‘Aa8e ka ndotaojidj adi ekido8ag, ka8in 8ikad kada nibosi.’ ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kidinendan na kin na8adj e apitendagozian apitc8in Abanaam? Ki nibo Abanaam, acitc niganadjimo8innig ke8ina8a ki nibo8ag. A8enen dac kin enenimidizo8an?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesos dac ogi nak8e8ajian: “Kicpin min8adjimidizo8aban kidji gi manadjiigo8an, ceck8at ii kada ijiseban. Nidadam dac 8in nimanadjiig, 8in ‘Nikije Manidominan 8aa’ ka ikido8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ka8in maia kikikenimasi8a8a Kije Manido. Nin dac nikikenima. Kicpin ikido8aban: ‘Ka8in nikikenimasi,’ nida kagina8ickinan tabickotc kina8a. Teb8e dac nikikenima, acitc nitodan adi ekidodj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abanaam 8eckadj kikitci anicinabemi8aban ki kitci min8endam e kikendag kidji tag8icinian ooma akig. Ogi nigani 8abadan, midac ogi kitci min8endan.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Igi dac Coda8innig ogi ina8an: “Ka8in maci kinanomidana8e (50) pibon8ezisi. Adi dac 8edji ikido8an egi 8abamadj Abanaam?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesos dac ogi nak8e8ajian: “Teb8e ki8idamonom, ab8amaci Abanaam nta8igigobanen, Aja Nitidenaban.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Midac ogi ma8adjia8an asinin kidji pim8asinaa8adjin e 8i nisa8adjin. Jesos dac ki kazo, midac ka iji sagaag Coda8inni kitci aiamiemigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Meg8adj Jesos e 8idji pimaadomagobanen okikinoamaganan, ogi 8abaman pejig naben ega e 8abindjin ka ako pimadizindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Okikinoamaganan dac ogi k8ag8edjimigon: “Kikinoamage8inni! Adi 8edji ki ijinagozidj ega e 8abidj ka ako nta8igidj aa nabe? 8in na ki patadi kek8an onigiigon?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesos dac ogi nak8e8ajian: “Ka8in opatado8inan kek8an onigiigon opatado8ini 8edji ki ega 8abidj. Kidji 8abadjigadeg dac adi ke todagodjin Kije Manidon, mi 8edji ega 8abidj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","5","Meg8adj e teian ooma akikag, ni8asenama8ag a8iagog ooma akikag. Meg8adj dac e kijigag, panima kida anokita8anan aa ka pidjinijaojidj. Aja kegat kada tibikan, apitc ega a8iag ke kackitodj kidji mikimodj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ka ick8a ikidodj ii, Jesos ki siko motcikag. Ajickini dac ogi ojiton osiko8in e abadjitodj. Ogi cijonan dac ii ajickini ockijigokag ini ega ka 8abindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ogi inan dac: “Nda kiziabin ka iji kabacimonani8ag Silo8e (Siloé) ka ijinikadeg.” 8a ikidomagag dac Silo8e, “Ka pidjidji8anogobanen nibi.” Ki ija dac aa ega ka 8abidj kidji nda kiziabidj. Midac apitc e koki pi ki8edj, aja okackitonaban kidji 8abidj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","O8idji tajikemaganan acitc a8iagon ka 8abamigopanin e ndodamapan ako conian, ki ikido8an: “Kana aa nabe ka taji abipan ako, ka ndodamapan ako conian?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nandam ikidobanig: “Mi aa.” Kodagiag dac ikidobanig: “Ka8in 8in aa. Mi maia kegat ejinagozidj eta.” Aa8e dac ega ka 8abipan ki ikido: “Nin mada teb8e.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ki k8ag8edjimagani8i dac: “Adi dac kagi ijisean kidji gi 8abian?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ogi nak8e8ajian dac aa nabe ega ka 8abipan: “Aa nabe Jesos ka ijinikazodj, nigi kigeig. Ogi ojiton pagi ajickini, midac ogi cijonanan nickijigon. Nigi inig dac Silo8e ka iji kabacimonani8anig kidji nda kiziabi8ag. Nigi ija dac. Apitc ka ick8a kiziabian, teci8ag nigi 8abinan.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ki k8ag8edjimagani8i dac: “Adi apan aa nabe ka kigeik?” “Adidok apan,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Aa dac nabe ega ka 8abipan ki iji8inagani8i kidji nda 8abamadjin Coda8innin ka nagadjitonigobanen inakonige8inan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Meg8adj Coda8inni aiamie kijiganogoban apitc Jesos ka ojitogobanen ajickini acitc kagi kigeagobanen ini8e ega ka 8abindjin naben. ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Coda8innig dac ka nagadjito8agobanen inakonige8inan ke8ina8a ogi k8ag8edjima8an ini naben adi ka ijisenig kidji gi 8abindjin. Ogi nak8e8ajian dac aa nabe: “Pagi ogi aton nickijigokag ajickini. Nigi kiziabi dac, midac nogom ni8abinan.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nandam dac igi Coda8innig ka nagadjito8agobanen inakonige8inan ikidobanig: “Ka8in Kije Manidokag odjisidok aa8e. Ka8in mega onosoneasinan aiamie inakonige8inan ka ikidomaganigin adi enendagoziak kidji inakamigiziak e aiamie kijigag.” Pekic dac kodagiag ikidobanig: “Adi kegi odji kackitodj a8iag kidji mamada8izidj kicpin patado8inni8idj?” Midac pepakan ki inendamog. ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Coda8innig ka nagadjito8agobanen inakonige8inan mina8adj ogi k8ag8edjima8an ini ka kigeagani8indjin: “Kin dac, adi enenimadj aa8e kagi kigetodjin kickijigon?” Ogi nak8e8ajian dac: “Kije Manido oniganadjimo8inniman ini maia.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ka8in o8i teb8etasina8aban Coda8innig ka niganizi8adj ega e 8abinipanin ako ini naben, aja dac nogom e kackitondjin kidji 8abindjin. Midac ogi nd8e8ema8an ini naben onigiigoni. ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ogi k8ag8edjima8an dac: “Mi na aa teb8e kig8izisi8a? Teb8e na ka8in 8abisi ka ako pimadizidj? Adi dac ka ijiseg 8edji ki 8abidj nogom?” ki ikido8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Aa dac nabe onigiigon ki nak8e8ajit8a8an: “Nikikenimanan nig8izisinan aa, acitc nikikenimanan ega egi 8abidj ka ako pimadizidj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ka8in dac nikikendasinanan adi ka ijiseg kidji 8abidj nogom acitc ka8in kek8an nikikenimasi8anan a8enen kagi kigeigodjin. 8in k8ag8edjimik, aja tebapitadizi 8in tibina8e kidji nak8e8ajit8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Kotadjibanig mega, mi 8edji ki ikido8adj ii. Aja mega ki onaco8ebanig Coda8innig ka niganizi8adj kidji sagidjinija8agani8idj Coda8inni aiamiemigi8amikag a8enenigotc ke tibadjimog8en Jesosan mi ini Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Mi 8edji ki ikidondjin onigiigon: “Aja tebapitadizi 8in tibina8e kidji nak8e8ajit8adj, 8in k8ag8edjimik.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Coda8innig ka nagadjito8agobanen inakonige8inan mina8adj ogi nd8e8ema8an ini ega ka 8abinipanin ka ako pimadizinigobanen, midac ogi ina8an: “Teb8en maiagotc! Mamidonendan Kije Manido e kijigabamik! Nina8it nikikendananan aa nabe e patadidj!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ogi nak8e8ajian dac: “Ka8in nikikendasin kicpin e nta patadidj kek8an ega e patadidj. Mi eta pejig kegon nikikendan. Ka8in 8ikad nidodji 8abisi, nogom dac aja ni8abinan!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ogi k8ag8edjima8an dac: “Adi ka todaok? Adi ka todag kidji gi 8abian?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Midac ogi nak8e8ajian: “Aja kigi 8idamonom, ka8in dac kidodji k8ag8e ndotaojisim. Adi 8edji nda8endameg kiabadj kidji koki ikido8an? Kekina8a sa kinada8endana8adok kidji nosone8eg aa, kana?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ogi kitci mamanazoma8an dac ini naben ega ka 8abinipanin, e ina8adjin: “Kin kinosone8a aa nabe! Nina8it dac ninosoneananan Mois okikinoamage8inan! ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nikikendananan Kije Manido egi aiamiadjin Moisan. Aa dac nabe ka8in 8a8adj nikikenimasi8anan adi 8edjidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Aa dac nabe ogi nak8e8ajian: “Nikitci mamakadendan! Ka8in kikikenimasi8a8a adi 8edjidj, misa8adj egi 8abiijidj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kikikendananan Kije Manido ega e ndota8adjin a8ian ka nta patadindjin. Anic dac kicpin a8ian e icpenimigodjin acitc todamindjin adi eji nda8endag, 8in sa onadota8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ka8in 8ikad ki nodagani8asinon a8iag egi kigeadjin a8ian ega ka 8abindjin eko nta8igindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kicpin aa nabe ega Kije Manidokag odjipan, ka8in kegoni oda kackitosin kidji todag.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Midac ogi nak8e8ajia8an: “Kin dac mojag kigi nta patadinan, ka ako pimadizian. Nogom dac kidinendan na kidji gi pi kikinoamaojiag?” Midac ogi sagidjinija8a8an Coda8inni aiamiemigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesos ki nodage egi sagidjinija8agani8indjin ini naben acitc ogi a8i nda 8abaman. Apitc dac ka nagicka8adjin, ogi inan: “Kiteb8eta8a na aa8e Ka pi Anicinabe8iidizodj?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ogi nak8e8ajiigon dac: “A8enen dac aa maia, kegi teb8eta8agiban?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesos dac ogi inan: “Aja kigi 8abama aa. Ka taji aiamiik, mi aa8e.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Midac ki ikido: “Ka Tibendjigean! Kiteb8etaon.” Acitc ogi icpeniman. ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesos dac ogi inan: “Kidji kikenimagani8i8adj igi8e ka nosone8a8adjin Kije Manidon kek8an igi8e ega ka nosone8a8adjin, mi 8edji ki pijaian ooma akikag. Nigi pija kidji gi 8abi8adj a8iagog ega ka 8abi8adj, acitc a8iagog ka inendamo8adj ka 8abi8adj kidji kikendamo8adj ega maia e 8abi8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nandam Coda8innig ka nagadjito8agobanen inakonige8inan iima tebanig. Ogi nodana8a dac kagi ikidondjin Jesosan, midac ogi ina8an: “Kik8ag8e ikidonan na kenina8it ega e 8abiag?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesos dac ogi inan: “Kicpin ega 8abiegoban, ka8in kada ikidonani8asinoban e patadieg. Anic dac ‘Ni8abamin!’ kidikidom. Mi 8edji nisida8inagozieg kiabadj e kigickameg patado8in,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesos ki ikido: “Teb8e ki8idamonom, 8aa a8iag ega ka iji pidigedj ick8ademikag mantcenican ka iji tajikendjin, acitc pajidada8edj meniganatigoni, mi aa8e ka kimodi8inni8idj acitc ka kitci sogendagozidj e makamadjin kodag a8ian odaimini. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Anic dac 8aa a8iag ick8ademikag ka iji pidigedj, mi 8aa8e ka kana8enimadjin mantcenican. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ocebidamagon ick8ademini ini ka kana8endamindjin, acitc onadotagon mantcenican e nd8e8emadjin. Onad8e8eman pepejig mantcenican ejinikazondjin, acitc dac osagidji8inan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Apitc kakina ick8a sagiziadjin, 8in pimose nigan acitc mantcenican onosoneogon. Onisidotagon mega apitc e anim8edj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Midac ka8in oga nosone8asi8a8an igi mantcenicag a8ian ega e kikenima8adjin. Tiegodj, kada ojimo8ag, ka8in mega onisidota8asi8a8an apitc e nd8e8emigo8adjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Mi kagi iji adisokedj Jesos kidji kikinoamagedj. Ka8in dac nisidotcigadesini adi 8a ikidogobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ii dac odji Jesos kiabadj ki ikido: “Teb8e ki8idamonom, nin ick8adem ka iji pidige8adj mantcenicag nidijinagozinan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ab8amaci nin, ki pijabanig a8iagog e ikido8adj: ‘Nin mada ka kana8enimag8a igi8e,’ pekic dac mi maia kimodi8innig ejinagozi8apan. Nidanicinabemag dac ka teb8etaoji8agobanen ka8in onadota8asi8a8abanin, mi pejig8an mantcenicag ega ka nosone8a8adjin a8ian ega e kikenima8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nin ick8adem nidijinagozinan, taji ka iji kana8enimagani8i8adj mantcenicag. Tabickotc mantcenicag ka iji8ebizi8adj, pidige8ag taji ke iji ega nigodi8adj, acitc sagaamog kidji nda 8abadamo8adj ke midji8adj, mi pejig8an ke ijisedj a8iag ka odji pidigedj ninikag. Kada ag8acimagani8i. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kimodi8inni dac, mi eta 8edji pijadj kidji kimodidj, kidji nici8edj acitc kidji pigobidasodj. Nin dac 8in, nigi pija ooma akikag a8iagog 8edjidagotc kidji pimadizi8adj, acitc kidji kitci mockineckago8adj opimadizi8ini8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Nin 8aa kitci 8e8enda ka kana8enimadjin odanicinabeman, tabickotc a8iag ka iji nagadjiadjin omantceniciman. A8iag kitci 8e8enda ka kana8enimadjin omantceniciman, ick8ata kidji pagidendag opimadizi8in 8ina8a odji. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","A8iag ka kijika8agani8idj, ka8in maia pejig8an otoda8asin mantcenican e kana8enimadjin apitc8in aa8e maia ka tibenimadjin ini. Apitc dac 8abamadjin maiganan, mi eji nagadjibaadjin mantcenican, midac aa maigan kidji gi nicike8inadjin, acitc kidji gi katcidjibinadjin nandam. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Aa a8iag ka kijika8agani8idj, conian eta 8edji mikimodj, mi 8edji ojimodj. Ka8in opabiziskenimasin mantcenican.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Nin 8aa kitci 8e8enda ka kana8enimadjin odanicinabeman, tabickotc a8iag ka iji nagadjiadjin omantceniciman. Nidadam nikikenimig acitc nikikenima Nidadam. Mi pejig8an, nikikenimag nimantcenicimag acitc nikikenimigog. Midac nidick8ata kidji pagidendaman nipimadizi8in 8ina8a odji. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kiabadj kodagiag nidaia8ag e pakanizi8adj, ega maci e te8adj nogom meg8adj ka iji kana8enimag8a nimantcenicimag. Panima dac niga 8abadaag mikanani. Niga ndotagog apitc aiamiag8a. Midac kakina kada ma8asag8ino8ag, acitc dac kakina niga nagadjiag.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Nikitci sagiig Nidadam. Nimigi8e mega nipimadizi8in, mina8adj kidji gi koki pimadizian ick8a nibo8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ka8in a8iag okackitosin kidji nisijidj kicpin ega pagidenimidizo8an. Nin, mi eji nda8endaman, kidji pagidendaman nipimadizi8in. Nikackiton kidji onendaman kidji pagidendaman nipimadizi8in acitc mina8adj kidji koki aiaman. Mi iidi kagi inanonijidj Nidadam kidji todaman.” Mi ka ikidodj Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kiabadj Coda8innig pepakan ki inendamog Jesosan kagi ikidondjin odji. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mane e taci8adj ikidobanig: “Okigickagodog8enan madji manidon. Ki8ack8edok! Adi 8edji ndota8eg?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kodagiag dac ikidobanig: “A8iag kigickagopanin madji manidon ka8in iidi kada iji anim8esiban. Ka8in okackitosin madji manido kidji gi 8abiadjin a8ian ega e 8abindjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Meg8adj e pibonigobanen, Coda8innig ako magocebanig ii apitc Jerusalemikag, kidji mika8i8adj apitc ka cenigadenigiban kitci aiamiemigi8amini kidji gi icpenimagani8idj Kije Manido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesos pabamosegoban iima pidigesag kagi ojitcigadegobanen Sanamo (Salomon) odji pidigamig kitci aiamiemigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Kitci mane Coda8innig ka niganizi8adj ma8adjiidibanig 8ajagam Jesosikag, acitc ogi k8ag8edjima8an oo8e: “Aja 8eckadj nik8ina8i inendananan, ka8in mega kikikenimigosi. Anapitc dac ke 8idamagean a8enen kin maia. Kicpin kin teb8e aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin, misa 8idamaocinam.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesos dac ogi nak8e8ajian: “Aja kigi 8idamonom, ka8in dac ki8i teb8etasina8a. Nimamada8izi8inikag kigagi odji 8abadana8a nimacka8izi8in Nidadamikag ka odjimagag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ka8in dac kiteb8etasina8a, ka8in mega ninikag kidiji tibendagozisim. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nidanicinabemag nikikenimag. Ninadotagog dac acitc ninosoneogog. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Niminag kagige pimadizi8ini. Ka8in dac 8ikad kada 8anicisi8ag acitc ka8in a8iag niga pi nda makamigosi ini8e. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nidadam, 8in ma8adji ka kitci apitendagozidj, nigi minig nidanicinabeman. Ka8in dac a8iag okackitosin Nidadamikag kidji odji manibinadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nidadam acitc nin nipejig8eiendagozimin mega,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Aja mina8adj igi8e a8iagog ogi odapina8an asinin kidji pabim8asinaa8adjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesos dac ogi inan: “Kitci mane nigi paba mino ijitcige e 8abamijieg, Nidadam omacka8izi8in e abadjito8an. Adi dac ii8e mino ijitcige8inan 8edji 8i nisijieg?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Igi8e Coda8innig ogi nak8e8ajia8an: “Ka8in 8in egi mino ijitcigean ke odji nisigo8an. Ki8i nisigo osa mega kimanazoma Kije Manido. Kimotci anicinabe8inan, midac ‘Nikije Manido8inan’ eji ikido8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesos ogi nak8e8ajian: “Mazinadeni Kije Manido Omazinaiganikag egi inadjin oo8eni ini a8iagon kagi onabamadjin kidji tibakonandjin odanicinabeman: ‘Mi maia tabickotc Kije Manido epitenimigo8eg. Mi tabickotc eji manadjiigo8eg 8in ka iji manadjiagani8idj.’ ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kikikendananan apanigotc e teb8emaganig Kije Manido Omazinaigan. Ogi inan ini tibakonige8innin ka apitenimagani8indjin tabickotc 8in tibina8e. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Nin dac Kije Manido nigi onabamig acitc nigi pidjinijaog ooma akikag. Adi dac 8edji ikido8eg e manazomag, egi ikido8an nin Kije Manido Og8izisan? ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kicpin ega todaman ka iji nda8endag Nidadam, ka8in teb8etaojikegon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Anic dac kicpin teb8e todaman ka iji nda8endag, kida teb8etana8a Kije Manido omacka8izi8in e abadjita8ag apitc 8abamijieg e mino ijitcigean. Misa8adj ega teb8etaojieg ekido8an, kigagi odji ketcinamendana8a e kigicka8ag Nidadam acitc e kigickaojidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mina8adj dac Coda8innig ogi k8ag8e takona8an. Midac ka iji ojimigo8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kegapitc Jesos ki koki ijagoban k8ekagam Jourdain sibini, Cabadis kagi iji sigaadagegobanen. Midac iima ka tajikedj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Kitci mane a8iagon ogi pi nda 8abamigon 8edi. 8idamadibanig: “Ka8in odji mamada8izisi Cabadis, anic dac kakina ka ikidopan e mikomadjin ini naben teb8emagani.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Midac kitci mane a8iagog iima ogi teb8eta8a8an Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Pejig nabe akozigoban, Lazare ijinikazogoban. Nijibanin e ik8e8indjin o8idjiki8en, Mani acitc Mata (Marthe) ijinikazobanin. Betani (Béthanie) odenajicikag tajikebanig e midjinisi8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mi aa Mani nage ke atogobanen ka minomag8anig Jesosan ozidinikag acitc ke kasizide8agobanen, o8ina8anisisan kidji abadjitodjin. Akozibanin dac aa ik8e o8idjiki8en Lazare ka ijinikazonipanin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Igi dac ik8e8ag ogi madjinija8a8an a8ian kidji nda 8idama8andjin Jesosan: “Tebendjigean! Akozi aa ka sagiadj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Apitc Jesos ka nodagedj ii, ki ikido: “Misa8adj kitci mamida8apinedj, kiabadj kada pimadizi. Kidji odji icpenimagani8idj Kije Manido, mi 8edji akozidj Lazare, acitc kidji odji icpenimagani8indjin Kije Manido Og8izisan.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesos osagiabanin Matan, Manin, acitc Lazaran. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Misa8adj dac, apitc ka nodagedj Lazaran e akozindjin, kiabadj nijogon ki tajike iima ka iji tepan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ka ick8a nijogonaganig dac, ogi inan okikinoamaganan: “Coda (Judée) akikag koki ijadan.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Okikinoamaganan dac ogi nak8e8ajiigon: “Kikinoamage8inni! Ka8in 8eckadj Coda8innig kigi k8ag8e nisigog e pabim8asinaik8a. Mi na misa8adj 8a iji koki ijaian 8edi?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesos dac ogi inan: “Kana 8aiej midatcin acitc nijotibaigan tag8asinon kidji kijigag? Kicpin a8iag pimosedj meg8adj e kijiganig, ka8in kada pizogecisi. 8asea mega e kijigag ooma akikag, o8abadan dac adi ejadj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kicpin dac a8iag pimosedj e tibikanig, kada pizogecin, ka8in mega 8aseasini ka iji pimosedj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ka ick8a ikidodj ii, kiabadj ogi inan: “Ki8idji8agananan Lazare taji niba. Niga nda kockona dac.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Okikinoamaganan ogi nak8e8ajiigon: “Tebendjigean! Kicpin taji nibadj, kada kige.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesos 8i ikidoban Lazaran egi nibondjin. 8ina8a dac inendamobanig Jesosan ka nibani8anig ako e mikodamindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jesos dac k8aiak ogi 8idama8an: “Lazare aja ki nibo. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nimin8endan dac ega egi teian 8edi ab8amaci ka nibodj. Kina8a dac kiga odji teb8etaojim. A8isa, nda 8abamadan.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Midac Tomas (Thomas), 8in “Aa pejig ka nijonta8igi8adj” ka ijinikanagani8idj, ogi inan kodagian Jesosan okikinoamagani: “Ijadan dac kekina8it, kidji 8idji nibomaiak apitc Jesos nisagani8idj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Apitc Jesos ka tag8icig 8edi Betani (Béthanie), ki nodage Lazaran egi nibondjin acitc aja niogon ka ako asimagani8inigobanen 8ibabikiniganikag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","8aiej nijotibaigan Betani apisinag8anogoban Jerusalemikag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Kitci mane dac a8iagog Coda (Judée) aki ka odji8adj ogi nda 8idabima8abanin Matan acitc Manin, egi nibondjin o8idjiki8e8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Apitc Mata ka 8idama8agani8idj e pi tag8icinindjin Jesosan, ogi nda nagicka8an. Mani dac 8in kiabadj ki tajike migi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Apitc dac Mata ka nagicka8adjin Jesosan, ogi inan: “Tebendjigean! Kicpin ki teaban ooma, ka8in kadagi nibosiban nidjiki8e! ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Misa8adj dac nikikendan Kije Manido kidji minik kakina kegoni ke k8ag8edjimadj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesos dac ogi inan: “Kidjiki8e kada koki pimadizi.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mata ogi nak8e8ajian: “Nikikendan kidji koki pimadizidj apitc abidjiba8adj ka nibo8adj apitc ke ponaki8anig.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesos dac ogi inan: “Nin aa ka abidjibaag a8iag acitc ka minag pimadizi8ini. Aa8e ka teb8etaojidj kiabadj kada pimadizi, misa8adj ijisenig kidji nibodj, ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","acitc aa8e maiagotc ka pimadizidj acitc ka teb8etaojidj, ka8in 8ikad maiagotc kada nibosi. Kiteb8etan na ii?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Midac Mata ogi nak8e8ajian: “Ee, Tebendjigean! Niteb8etan kin aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin. Kin Kije Manido Og8izisan, kegi pijapan ooma akikag,” ogi inan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ka ick8a ikidodj ii, Mata ki ki8e kidji nda nd8e8emadjin o8idjiki8en Manin. Kimodj dac ogi inan: “Aja ki tag8icin Kikinoamage8inni. Kik8ag8edjimig dac kidji nda 8abamadj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Teci8ag ka ick8a nodag ii, Mani ki pazig8idjise acitc 8ibadj ogi nda 8abaman Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Kiabadj teban Jesos iima ka iji nagicka8apanin Matan, ka8in maci ki pidigesiban Betani odenakag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Coda8innig ka te8apan Manin omigi8aminikag kidji 8idabima8adjin ozam egi 8aniandjin o8idjiki8eni, ogi 8abama8an e kitci 8e8ibit8a sagidjisendjin. Ogi nosone8a8an dac, inendamobanig mega e nda ma8indjin 8ibabikiniganikag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Apitc Mani ka tag8icig ka iji tenipanin Jesosan, teci8ag ogi nibak8ita8an. Ogi inan dac: “Tebendjigean! Kicpin ki teaban ooma, ka8in kadagi nibosiban nidjiki8e.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Apitc ka 8abamadjin e ma8indjin Manin acitc e ma8indjin Coda8innin ka pi 8idjiogopanin, Jesos ki kitci kackendam acitc ki kitci migockadendam. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Midac ogi k8ag8edjiman: “Adi ka iji aseg?” “Pi nda inabin, Tebendjigean,” ki inagani8i. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesos ki ma8i. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Igi8e dac Coda8innig ki ikido8ag: “8adan epitci sagiapanin!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nandam dac ikidobanig: “8in egi kackitodj kidji 8abiadjin ega ka 8abindjin, kana acitc okackitosinadok kegoni kidji todag ega kidji nibondjin Lazaran?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesos mina8adj ki kitci kackendam. Ki tag8icin 8ibabikiniganikag. Kitci asini ki asagani8iban ka odji pidigani8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesos dac ki ikido: “Manibijik aa asini.” Mata, o8idjiki8en ini8e kagi nibondjin, ogi inan: “Tebendjigean! Aja madjimagozidok. Aja niogon ka ako asagani8idj iima.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesos ogi nak8e8ajian: “Kana kigi 8idamaosinon kidji 8abadaman Kije Manido odicpendagozi8in kicpin teb8etaman?” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Midac ki manibinagani8i kitci asini. Jesos dac ki icpanabi acitc ki ikido: “Nidadam! Mig8etc kidinin egi ndotaojian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nikikendan kabena e ndotaojian. Nidikidonan dac ii igi8e a8iagog odji 8ajagam ka te8adj, kidji gi teb8etamo8adj egi pidjinijaojian.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ka ick8a ikidodj ii, ki pabibagi: “Lazare! Pi sagaan!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Midac ka nibodj ki sagaam, ozidan acitc onidjin e sidopidjigadenigibanin acitc octig8an pabagi8anicini egi 8ik8epidenig. Jesos dac ki ikido: “Manibidamokon kakina ini pabagi8anican ka sidopinigodjin, kidji gi pimosedj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kitci mane Coda8innig, ka ndaodeoma8apanin Manin, acitc ka 8abadamo8apan Jesosan ka todamindjin, ogi teb8eta8a8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nandam dac kodagiag ogi nda 8abama8an Coda8innin ka nagadjitonigobanen inakonige8inan. Ogi 8idama8a8an dac adi Jesosan ka todamindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Midac ki ma8adjiidi8ag Coda8innig ka nagadjito8agobanen inakonige8inan acitc Coda8inni kitci aiamie ogimag acitc kakina Coda8inni kitci aiamie onakonige8innig. Ki ikidobanig dac: “Adi ke todamak? Kitci mane mamada8izi8inan otodanan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kicpin ega odjiaiak kidji todag ini kegonan ka todagin, kakina oga teb8eta8a8an. Midac ka niganizi8adj Rom ka odji8adj kada pija8ag kidji pigobido8adj kikitci aiamiemigi8aminani. Acitc kiga 8anadjiigonanag kina8it ka inakaneziak,” ki ikido8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pejig dac e taci8adj, Kaiapas (Caïphe) ka ijinikazogobanen, ka aiamie ogima8ipan ma8adji ka niganizipan ii apitc, ki ikido: “Ka8in kegon kikikendasina8a! ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kana kinisidotasina8a na8adj kidji minosenig pejig eta a8iag nibopan kakina Coda8innig odji, apitc8in kakina Coda8innig kidji nisagani8i8adj?” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ka8in 8in eta enendag ii 8edji ki ikidopan. Ikidoban ii Kije Manidon egi minigodjin kidji iji ikidodj, 8in meg8adj ka aiamie ogima8ipan ma8adji ka niganizipan ii apitc. Midac iidi ki niganadjimo kidji nibondjin Jesosan kakina Coda8innin odji. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ka8in dac eta Coda8innin ke odji nibodj Jesos, misa acitc kidji ma8adjiagani8indjin kakina Kije Manido odabinodjijiman mizi8ekamig, kidji gi pejig8eiendagozindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Midac ii e kijiganig ki onendamog igi8e Coda8innig ka niganizi8adj kidji nisagani8indjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jesos dac ka8in mina8adj ki paba ijasiban ka iji manenani8anig iima Coda (Judée) akikag. Ki ija dac pejig odenajicikag Ipaniam (Éfraïm) ka ijinikadenig, pecodj pig8adakamigokag. Mi iima ka iji tajike8adj Jesos acitc okikinoamaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Aja ani peconag8anoban Coda8inni Kitci Magocan, Pak ka ijinikadeg. Kitci mane dac a8iagog iima akig ka odji8agobanen, ki ija8agoban Jerusalem odenakag ab8amaci kidji magocani8anig, kidji nda todamo8adj ka inakonigemaganigin Coda8inni Inakonige8inan kidji gi paiekideeiendagozi8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Igi8e dac kagi pija8adj kidji magoce8adj, onanada 8abama8abanin Jesosan. Meg8adj Coda8inni kitci aiamiemigi8amikag e te8agobanen, k8ag8edjimidibanig: “Adi enendameg? Kada pija na, kek8an ka8in?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Coda8inni kitci aiamie ogimag mega acitc Coda8innig ka nagadjito8agobanen inakonige8inan o8i takona8abanin Jesosan. Midac aja ki inakonigebanig: “Kicpin a8iag kikenimadjin adi e tandjin Jesosan, panima niga 8idamagonan.” Mi kagi inakonige8adj, kidji gi a8i nda takona8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nigod8asokajik ab8amaci Coda8inni Kitci Magocani8ag, Jesos ki ija Betani (Béthanie) odenag, Lazaran ka iji tajikendjin, ini kagi abidjibaadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Iima dac ki nd8e8emagani8i kidji 8isinidj, Mata (Marthe) dac ag8aigeban kidji 8isinindjin a8iagon. Lazare teban ke8in iima, 8in pejig o8idji 8isinimabanin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mani dac ogi pidon kitci modaiabikoni, e kicponebinig ka minomag8anig ka kitci sanaganig, “nard” ka ijinikadenigobanen. Ogi siginan dac ii ka minomag8anig Jesosan ozidinikag. Ogi kasizide8an dac, o8ina8anisisan e abadjitodjin. Midac kakina migi8amikag ki kicponemag8an ii ka minomag8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Pejig Jesos okikinoamaganan, Judas Iskaniot ka ijinikazondjin, ini8e ke mamijimigodjin kidji gi nisagani8idj, ki ikido8an: ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kitci sanagan ii ka minomag8ag. Pejigopibon inigik a8iag e mikimodj apitendag8an kidji kijikadamosegiban ii ka minomag8ag. 8egonen dac 8edji ega ki ada8egobanen, kidji gi minagani8indjin conian ka kidimagizindjin.” Mi ka ikidondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ka8in Judas ii ki ikidosiban e kidimagenimagobanen ka kidimagizindjin. Tiegodj ki kimodi8inni8iban 8edji ki ikidodj. 8in mega okana8enimabanin Jesosan acitc okikinoamagani oconiami8an, midac nanigodin okimodji odapinabanin ini conian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesos dac ki ikido: “Ponii aa ik8e. Min8acini egi kana8endag ii ka minomag8anig kidji atodj nia8ikag. Ka8in mega aja kin8ej panima kidji naatcigadeg nia8. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kabena ka kidimagizi8adj kiga 8idji tajikemigo8ag, nin dac 8in ka8in apanigotc kiga 8idji tajikemisinonom,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kitci mane Coda8innig ki nodage8ag Jesosan e tendjin Betanikag. Ki ija8ag dac iima. Ka8in eta Jesosan o8i 8abamasi8a8abanin, Lazaran acitc o8i 8abama8abanin, Jesos kagi abidjibaapanin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Coda8inni kitci aiamie ogimag dac ki onaco8e8ag kidji nisagani8indjin ke8in Lazaran. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Osa mega egi abidjibaagani8igobanen Lazare, kitci mane Coda8innig odana8enima8abanin Coda8inni kitci aiamie ogiman, acitc ogi madji nosone8a8an Jesosan acitc ogi madji teb8eta8a8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","8iabanig, kitci mane a8iagog ka pija8apan e Coda8inni Kitci Magocani8anig ki nodage8ag Jesosan e peconagozindjin Jerusalemikag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ogi ndogaana8an dac 8adik8anan, midac ogi nda nagicka8a8an Jesosan, e pabibagi8adj: “Kitcit8a8endagozi Kije Manido! Ca8endagozi aa8e ka Tibendjigendjin kagi pidjinijaogodjin! Ca8endagozi aa8e ka ogima8idj Israel akig!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesos ogi mika8an misabozon, acitc ki 8agida8aganebi. Mi ka ojibiigadenig Kije Manido Omazinaiganikag: ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ka8in kotadjikegon, kina8a Jerusalem odena ka odjieg. 8adan kidogimami8a 8agidabi e pijadj ocki misabozocikag.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Okikinoamaganan dac, ka8in teci8ag ododji nisidotasina8aban ii. Apitc dac Jesos ka koki ijadj Odadamikag kidji gi icpendagozidj, mi ii apitc ki mika8i8ag Kije Manidon Omazinaiganikag egi tibadjimomaganig ii Jesosan e mikomagani8indjin, acitc ki mika8i8ag adi kagi aitoda8agani8inigobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Kakina ka 8idji8a8apanin Jesosan apitc ka nd8e8emapanin Lazaran kidji sagaamindjin o8ibabikiniganikag acitc ka abidjibaapanin, paba tibadjimobanig adi ka iji8ebanig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mi 8edji kitci mane a8iagog ki nda nagicka8a8apanin. Ki nodage8ag mega egi kitci mamada8izindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Coda8innig dac ka nagadjito8agobanen inakonige8inan ikidobanig: “8adan aa. Ka8in kegon kigagi todasinanan kidji nagabido8ak! Kakina a8iagog onosone8a8an!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kitci mane a8iagog Jerusalemikag ki ija8agoban Coda8inni Kitci Magocan odji. Nandam a8iagog, Kanes (Grèce) ka odji8adj, ke8ina8a tebanig iima kidji aiamie8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ogo8eni8ag dac ogi nda nazika8a8an Pilipan (Philippe), Betseda (Bethsaïda) odenag ka odjindjin Galilee akikag. Midac ogi ina8an: “Ni8i 8abamanan Jesos.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilip dac ogi nda 8idama8an Andren. Eji niji8adj dac ogi nda 8idama8a8an Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesos dac ogi nak8e8ajian: “Aja nogom odjitcise kidji icpenimigo8an, nin Ka pi Anicinabe8iidizodj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","“Teb8e ki8idamonom, kidji gi madjigidj anomin, acitc dac kitci mane anominan kidji odji nta8igindjin, panima ki asagani8idj aa anomin akikag, tabickotc a8iag kagi nibodj ka nig8aakanagani8idj kidji ijinagozidj. Kicpin dac ega asagani8idj akikag, tabickotc kagi nibodj kidji ijinagozidj, kada motci pejigo, acitc ka8in kadagi odji nta8igisi8an mane anominan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Aa8e ka kitci sagitodj opimadizi8in kada nibo. Aa8e dac pekic ega ka kitci apitendag opimadizi8in ooma akikag, oga kana8endan kidji gi kagige pimadizidj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kicpin a8iag 8i anokitaojidj, panima ki nosoneojidj. Adigotc dac nin ke teian, mi ke8in ke paba tedj aa ka anokitaojidj. Kicpin dac a8iag anokitaojidj, Nidadaman oga kitci apitenimigon.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jesos kiabadj ki ikido: “Nogom dac nikitci kackendan. Adi dac ke ikido8aban? Nida ikidonan na: ‘Nidadam! Pi nda 8idjiicin ega iidi kidji iji8ebizian nogom’? Ka8in! Ka8in iidi niga ikidosi. Mi mega 8edji ki pijaian ooma, kidji cabockaman oo8e ke iji8ebizian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nidadam! 8abadai8en epitci icpendag8ag ki8izon!” ki ikido Jesos. Midac ki noda8agani8i a8iag 8ak8ig e odji anim8edj, e ikidodj: “Aja nigi 8abadai8e adi epitci kitci icpendag8ag, acitc kiabadj mina8adj niga iji 8abadai8e.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kitci mane a8iagog te8agoban iima, acitc ogi noda8a8an ini ka teb8e8idamindjin. Nandam ikidobanig: “Inimiki aa.” Kodagiag dac ikidobanig: “Ajenin ogi aiamiigon.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesos dac ki ikido: “Ka8in nin ka odji nodamak ii, anic dac kina8a odji. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Aja odjitcise kidji tibakonagani8i8adj a8iagog ooma akig. Nogom kada madjinija8agani8i kitci madji manido, 8in ka kackakanadjin a8iagon ooma akig ega e teb8etaojindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nin dac, apitc akikag ke odji icpak8aogo8an, kakina a8iagog niga 8ikobinag ninikag,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","8edji ikidodj ii, o8i kikendamonabanin adi ke iji nag8anig onibo8in. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ini8e dac a8iagon ogi nak8e8ajiigon: “Mazinadeni Coda8inni Inakonige8ini mazinaiganikag kagige kidji pimadizidj aa8e Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin. Adi dac 8edji ikido8an kidji icpak8a8agani8idj Ka pi Anicinabe8iidizodj? A8enen aa Ka pi Anicinabe8iidizodj?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesos dac ogi inan: “Kiabadj 8enibik eta kiga aiana8a 8asea8in ooma akig. Pimoseok dac meg8adj e tag8ag 8asea8in, ega kidji pimoseieg ka iji kacki tibikag. Aa8e mega ka pimosedj ka iji kacki tibikanig, ka8in okikendasin adi ejadj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Meg8adj dac e tag8ag ii 8asea8in, teb8etaok aa ka 8asenamago8eg, 8asea8inikag kidji gi iji tibendagozieg,” ki ikido. Ka ick8a ikidodj ii, Jesos ki madja acitc ki a8i tajike taji ke iji ega mika8agani8idj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Misa8adj egi 8abamagani8idj kitci mane egi iji mamada8izidj, ka8in teb8eta8agani8isi. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Midac ii kidji gi iji8ebanig adi niganadjimo8inni Isaia kagi ikidopan: “Tebendjigean! A8enen ka teb8etag nitibadjimo8inan? A8eneni8an ka Tibendjigedj kagi 8abadaadjin adi epitci macka8izidj?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ka8in okackitosina8aban kidji teb8etamo8adj. Isaia mega acitc ki ikido oo8e: ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Kije Manido ega kidji 8abindjin ogi todan, ogi cibictig8anean, ega kidji gi 8abindjin, ega kidji gi nisidotamindjin, acitc ega kidji pi k8ekigaba8indjin ninikag, kidji gi kigeag8aban.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaia mega ogi niganabadan Jesosan odicpendagozi8ini, acitc opaba mikomabanin, mi 8edji ki ikidodj ii. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Misa8adj dac, mane8ag Coda8innig ka niganizi8adj e teb8eta8a8apanin Jesosan. Pekic dac okosa8abanin Coda8innin ka nagadjitonigobanen inakonige8inan. Ka8in dac 8idamagesibanig e teb8eta8a8adjin, ega kidji sagidjinija8agani8i8adj Coda8inni aiamiemigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Na8adj mega omin8endana8aban kidji min8adjimigo8adjin a8iagon apitc8in Kije Manidon kidji min8adjimigo8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesos ki kiji8e e ikidodj: “Aa8e ka teb8etaojidj, ka8in nin eta niteb8etagosi. Ini8e acitc ka pidjinijaojindjin oteb8eta8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Aa8e ka 8abamijidj, o8abaman acitc ini8e kagi pidjinijaojindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nin, nigi pi 8asenama8ag a8iagog ooma akig, ega ka iji kacki tibikanig kidji iji pimadizidj aa a8iag ka teb8etaojidj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kicpin a8iag nodaojidj adi ekido8ag, ega dac nosoneag, ka8in nin niga tibakonasi. Nigi pija mega ooma akikag kidji ag8acimag8a a8iagog, ka8in 8in kidji tibakonag8a. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Aa8e ka ana8etaojidj acitc ega ndotag nitibadjimo8ini, maiagotc kada tibakonagani8i. Ka iji kikinoamage8ag, mi ii ke tibakonigodj apitc ponaki8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nidadam ka pidjinijaojidj nigi 8idamag 8in tibina8e adi ke ikido8an acitc 8egonen ke kikinoamageian. Ka8in dac nin tibina8e ka odji anim8eian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nikikendan 8egonenigotc ka anoni8edj Kije Manido, mi ka odjimaganig kagige pimadizi8ini. Midac oo8e ka ikido8an, mi iidi maia Nidadam kagi inanonijidj kidji ikido8an,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Aja kegat Coda8inni Kitci Magocani8anoban. Jesos okikendanaban aja e ani odjitcisenig kidji nagadag oo8e akini kidji koki nda 8abamadjin Odadaman. Kabena ogi sagian ini8e ooma akig 8inikag ka iji tibendagozindjin, pinici kidji nibodj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesos acitc okikinoamaganan nibek8ebanig. Aja kitci madji manidon ogi minigogoban Judas, Simo Iskaniot (Iscariote) og8izisan, kidji mamijimadjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesos dac 8in okikendanaban Kije Manidon egi minigodjin macka8izi8ini kakina kegoni kidji gi todag. Okikendanaban Kije Manidokag e odjigobanen acitc kidji koki nda 8abamadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Meg8adj dac taji 8isinibanig, Jesos ki pazig8i, acitc ki kitcikonae 8agidj odaiman ka kigickagin. Ogi odapinan dac pabagi8anicini, midac ki kitcipizo8age ii. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ogi siginan dac nibini onaganikag, midac ogi madji kizisibadjizidenan okikinoamaganan, acitc ogi kasizidenan e abadjitodj ii pabagi8anicini ka kitcipizo8agepan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","E ani kizisibadjizidenadjin okikinoamaganan, kegapitc Simo Pienikag ka iji abindjin ogi oditan. Ogi igon dac: “Tebendjigean! Kin na kiga kizisibadjizidenijinan?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesos ogi nak8e8ajian: “Ka8in kikikendasin nogom adi e todaonan. Nage dac kiga nisidotan,” ogi inan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pienan dac ogi igon: “Ka8in! Ka8in 8ikad kiga kizisibadjizidenijisi!” Jesos ogi nak8e8ajian: “Kicpin ega kizisibadjizideninan, ka8in 8ikad mina8adj kiga 8idjiojisi.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simo Pien dac ogi inan: “Tebendjigean! Ka8in eta nizidan! Ninidjin acitc! Nictig8an acitc!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesos dac ogi inan: “Aa8e ka ick8a kabacimodj, ka8in mamakadj mina8adj kidji kizisibandizodj, mi eta kidji kizisibadjizidedj. Aja mega mizi8e paiekizi. Kina8a dac kipaiekizim, pekic dac pejig e tacieg ka8in paiekizisi,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesos mega aja okikendanaban a8eneni8an ke mamijimigodjin. Mi 8edji ki ikidodj: “Pejig e tacieg ka8in paiekizisi.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Apitc ka ick8a kizisibadjizidenadjin okikinoamaganan, Jesos ki koki pitcikonae acitc ki nda koki abi 8isini8aganikag. Midac ogi inan: “Kinisidotana8a na adi ka todaonagok? ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","‘Kikinoamage8inni’ kidijinikanijim acitc ‘Ka Tibeniminak.’ K8aiak sa kidikidom, teb8e mega ii. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kigi kizisibadjizideninom, nin ‘Kikinoamage8inni’ acitc ‘Ka Tibeniminak’ ka apitenimijieg. Midac kekina8a pepejig e tacieg kida kizisibadjizidenidim. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kigi 8abadainom adi ke todameg, kidji gi todameg kekina8a maiagotc kagi iji todaonagok. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Teb8e ki8idamonom, anokitage8inni ka8in na8adj apitendagozisi apitc8in okackaman, acitc aa ka pidjinija8agani8idj ka8in na8adj apitendagozisi apitc8in aa ka pidjinijaogodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Aja dac egi kikendameg oo8e, kiga ca8endagozim kicpin teb8e todameg oo.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ka8in kakina e tacieg kimikomisinonom. Nikikenimag igi8e ka onabamag8a. Panima dac ki iji8ebag Kije Manido Omazinaigan ka iji 8idamagemaganig: ‘Aa ka 8idji 8isinimijidj niga mamijimig.’ ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ab8amaci iji8ebag ki8idamonom, midac apitc iji8ebag kidji teb8etameg e aiaa8ian aa a8iag apanigotc mojag kagi tedj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Teb8e ki8idamonom, aa8e ka mino toda8adjin ini8e ke ijinijaomagin, kenin nimino todag. Acitc aa8e ka mino todaojidj, omino toda8an ke8in ini8e kagi pidjinijaojindjin,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ka ick8a ikidodj ii, Jesos ki kitci migockadendam acitc ki tibadjimo: “Teb8e ki8idamonom, pejig oo e tacieg niga mamijimig.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kikinoamaganag dac kijigabamidibanig pepejig e taci8adj, k8ina8i inendamobanig. K8ag8edjimidizo8ag a8eneni8an ka mikomandjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Pejig dac Jesos okikinoamaganan, ini8e ka kitci sagiapanin, opimena Jesosikag iji tenigoban. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simo Pien dac 8e8ebik8ebanio, e anonadjin ini kikinoamaganan kidji k8ag8edjimandjin Jesosan a8eneni8an ka mikomandjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Midac aa kikinoamagan ki ijik8eni Jesosikag acitc ogi k8ag8edjiman: “Tebendjigean! A8enen aa ka mikomadj?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesos ogi nak8e8ajian: “Niga kidagamina nipak8ejiganim. Aa dac ke minag, mi aa ke mamijimijidj.” Jesos dac ogi odapinan pak8ejiganan acitc ogi kidagaminan, midac ogi minan Judasan, Simo Iskaniot (Iscariote) og8izisan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Apitc Judas kagi minagani8igobanen pak8ejiganan, teci8ag madji manidon ogi pidigeckagon. Jesos dac ogi inan Judasan: “8ibadj ijitan enendagozian kidji todaman.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ka8in pejig igi8e ka te8apan 8isini8aganikag ododji nisidotasina8a 8egonen 8edji ikidonipanin ii. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas mega okana8enimagoban conian. Midac nandam ki inendamog Jesos egi 8idama8adjin Judasan kidji nda odapinamindjin 8egoneni ke nodesenig kidji gi magocani8anig, kek8an kidji nda minandjin ka kidimagizindjin conian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas dac ogi odapinan ini pak8ejiganan acitc teci8ag ki sagaam. Aja tibikanoban. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Apitc Judas ka ick8a sagaag, Jesos ki ikido: “Nogom aja kada nag8ani Aa Ka pi Anicinabe8iidizodj odicpendagozi8in. Aja dac 8inikag kada odji nag8ani epitci icpendagozidj Kije Manido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Acitc dac kicpin 8inikag odji nag8anig epitci icpendagozidj Kije Manido, midac ke8in Kije Manido oga minan Ka pi Anicinabe8iidizondjin kidji kitci icpendagozindjin. Misa aja peconag8ani kidji ijisenig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kina8a nidabinodjijimag ka kitci ineniminagok! Ka8in aja kin8ej kiga 8idjiosinonom. Kiga nanada 8abamijim. Ka 8idama8ag8a Coda8innig ka niganizi8adj, nogom kekina8a ki8idamonom, ka8in kiga kackitosina8a kidji pijaieg adi ke ijaian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ocki inakonige8in dac kimininom, kidji sagiidieg pepejig e tacieg. Panima kida sagiidim tabickotc kagi iji sagiinagok. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Midac kicpin sagiidieg pepejig e tacieg, kakina a8iag oga odji kikendan e nosoneojieg,” ogi inan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simo Pien ogi k8ag8edjiman Jesosan: “Tebendjigean! Adi ejaian?” Jesos dac ogi nak8e8ajian: “Ka8in kigagi nosoneojisim nogom adi ejaian. Pekic sa nage kiga nosoneojim.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pien dac ogi inan: “Tebendjigean! Adi dac 8in ii ke odji ega ki nosoneonan nogom? Nidick8ata kidji pagidendaman nipimadizi8in kin odji.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesos ogi nak8e8ajian: “Teb8e na kidick8ata kidji pagidendaman kipimadizi8in nin odji? Teb8e ki8idamon, ab8amaci nabe pakaak8an nodagozidj, aja nisinanaj kigagi odji ikidonan ega e kikenimijian,” ogi inan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesos ogi inan okikinoamaganan: “Ka8in animendakegon. Teb8etaok Kije Manido acitc kenin teb8etaocik. ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nidija adi e tedj Nidadam. Iima dac ka tedj, kitci magi ta8ate mane a8iagog kidji iji tajike8adj. Kicpin ega teb8emagagiban, kida 8idamonom. Kiga ojitamonom taji ke iji tajikeieg. ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Apitc ick8a ojito8an taji ke iji tajikeieg, kiga pi nadji8ininom. Midac taji ke teian, mi acitc kekina8a ke teieg. ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kikikendana8a mikana kidji oditameg adi ke ijaian.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas (Thomas) dac ogi inan: “Tebendjigean! Ka8in nikikendasinanan adi e ijaian. Adi dac ke odji kikendamag mikana?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesos ogi nak8e8ajian: “Misa nin mikana, nin teb8e8in, nin pimadizi8in. Ninikag eta a8iag oga odji kackiton kidji ijadj Nidadamikag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kicpin kikenimijieg, mi ke odji kikenimeg Nidadam. Aja dac kikikenima8a, acitc kigi 8abama8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilip (Philippe) ogi inan: “Tebendjigean! 8abadaicinam Kidadam, mi eta ii eji nda8endamag.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesos ogi nak8e8ajian: “Pilip! Kana maci kikikenimijisi? Aja 8eckadj ki8idji tajikeminom. Aa ka 8abamijidj, aja ogi 8abaman Nidadaman. Adi dac 8edji ikido8an: ‘8abadaicinam Kidadam’? ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kana kiteb8etasin e kigickaojidj Nidadam, acitc e kigicka8ag Nidadam? Kakina kegon kagi pi 8idamonagogiban ka8in nin eta enendaman ii 8edji ikido8aban. Nidadam nikigickaog, acitc kakina ejitaian, 8in sa ka ijitadj ii. ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Apitc ako ikido8an e kigickaojidj Nidadam, acitc e kigicka8ag Nidadam, teb8etaocik ii e ikido8an. Kicpin ega kackito8eg kidji teb8etameg ii e ikido8an, teb8etamok sa e 8abadameg adi ejitaian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Teb8e ki8idamonom, aa8e eji teb8etaojidj, oga kackiton kidji ijitadj ke8in ka ijita8ag. Acitc na8adj mane kada ijita apitc8in nin, nikoki ki8e mega Nidadamikag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Midac kakina kegon ke iji pagosendameg ni8izonikag, mi ke todaman, kidji gi odji icpenimagani8idj Nidadam kagi pi ijitaian, nin Og8izisan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kicpin dac kegon iji pagosenimijieg ni8izonikag, niga todan.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Kicpin sagiijieg, kiga nosoneana8a nikikinoamage8in. ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Niga k8ag8edjima Nidadam kodag a8ian kidji minigo8eg kidji 8idokago8eg, apanigotc dac kiga 8idji tajikemigo8a. ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mi aa Mino Manido ka teb8edj e mikomadjin Kije Manidon adi ejinagozindjin. Igi8e dac a8iagog ega ke teb8etamo8adj, ka8in okackitosina8a kidji odapina8adjin opimadizi8ini8akag. Ka8in mega okikenimasi8a8an, acitc ka8in onisida8ina8asi8a8an. Kina8a dac, kikikenima8a. Ki8idjiogo8a mega acitc kikigickago8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Apitc odji madjaian, ka8in kiga naganisinonom ega a8iag e nagadjiigo8eg, tabickotc abinodjij ega ka onigiigodj kidji ijinagozieg. Niga koki pija. ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Aja peconag8an igi8e ega ka teb8etamo8adj ega mina8adj kidji 8abamiji8adj. Kina8a dac, kiga 8abamijim. E pimadizian, kekina8a kiga odji pimadizim. ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Apitc ii ijiseg, kiga nisidotana8a e kigickaojidj Nidadam, acitc e kigickaonagok, tabickotc kenin eji kigickaojieg.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Aa8e ka odapinag nidikido8ini acitc ka nosoneag, mi aa8e maia ka sagiijidj. Acitc aa8e e sagiijidj, oga sagiigon Nidadaman. Midac kenin, niga sagia acitc niga kikendamona e 8idji8ag,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ogi aiamiigon dac ini Judasan, ka8in 8in aa Judas Iskaniot ka ijinikazodj. Ogi k8ag8edjimigon dac: “Tebendjigean! 8egonen ke odji kikendamonijiag e 8idjiojiag, ka8in dac igi8e kiga kikendamonasi8ag ega ke teb8etamo8adj?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesos ogi nak8e8ajian: “Aa8e ka sagiijidj, oga nosonean nikikinoamage8ini. Nidadaman dac oga sagiigon. Midac nin acitc Nidadam niga pi nazika8anan acitc niga 8idji tajikemanan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Aa8e ega ka sagiijidj, ka8in onosoneasin nikikinoamage8ini. Ka ininagok, ka8in nin eta ka inendamaban. Misa Nidadam nigi minig kidji ikido8ag, 8in ka pidjinijaojidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Kigi 8idamonom oo meg8adj kiabadj e 8idjionagok. ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Aa8e dac ke pi 8idokago8eg, Mino Manido aa, ke pidjinija8adjin Nidadam kidji nabickaojidj. Kakina kegoni kiga kikinoamago8a, acitc kiga mika8asomigo8a kakina kagi 8idamonagok.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nogom dac kiga naganinom. Pekadendamo8in kinagadamonom, mi tabickotc nin eji pekadendaman kimininom kidji pekadendameg. Ka8in 8in ii8e pekadendamo8ini odaiasina8a igi8e ega ka teb8etamo8adj. Ka8in dac animendakegon acitc ka8in kotadjikegon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kigi nodaojim e ikido8an: ‘Nimadja, anic dac niga koki pija.’ Kicpin teb8e sagiijieg, kiga min8endana8a e ijaian Nidadamikag. Nidadam mega na8adj kitci apitendagozi apitc8in nin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nogom aja kigi 8idamonom ab8amaci kidji iji8ebag, midac kidji gi teb8etaojieg apitc iji8ebag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ka8in aja kin8ej kiga aiamiisinonom. Madji manido mega, 8in ka kackakanadjin a8iagon ooma akig ega ka teb8etaojindjin, aja kada tag8icin. Ka8in 8in okackitosin kidji tibenimijidj, ");
INSERT INTO alqALGNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","anic dac panima niga 8abadaag a8iagog ooma akikag e sagiag Nidadam, acitc e todam8ag ka inanonijidj.” “A8isa dac, madjadan,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesos ogi inan okikinoamaganan: “Nin maia cominici8atig mi ejinagozian, acitc Nidadam 8in ka nta8igitodj ijinagozi. ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kakina omanibidonan kibisatigon ega ka mini8anigin aa8e ka nta8igitodjin cominici8atigon. Kakina dac ka mini8anigin o8a8ejitonan. Midac kada paiekani8an, a8acamej kidji gi minogindjin cominican. Mi iidi e toda8adjin Nidadam a8iagon ka tibenimimagin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Aja kipaiekizim egi pi kikinoamaonagok. ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kabena 8idjiocik, midac kiga 8idjionom. 8adan ejisedj 8adik8anijic. Ka8in kadagi mini8isi 8in eta, ega kitiganikag iji madjigidj. Midac pejig8an kekina8a, mi ke ijiseieg kicpin ega 8idjiojieg.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Kitigan nidijinagozinan, kina8a dac 8adik8anijican kidijinagozim iima kitiganikag. Aa a8iag kabena ka 8idjiojidj acitc ka 8idji8ag, mi tabickotc 8adik8anijic ka kitci mini8ag ke ijinagozidj. Ka8in mega mino kegonan kigagi todasina8a, kicpin ega 8idjiojieg. ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Aa ega ka 8idjiojidj, mi maia kibisatig ega ka min8acig ke toda8agani8idj. Ini kibisatigon kada 8ebinigade8an, midac ke iji pategin. Kada ma8adjitcigade8an acitc kada madjocte8ebinigade8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Kicpin dac 8idjiojieg acitc nosoneameg ka ikido8an, 8egonenigotc pagosenimeg Kije Manido, kiga minigo8a. ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kicpin kitci mane iji mino todameg, iidi e iji 8abadai8eieg e nosoneojieg, mi ke odji icpenimagani8idj Nidadam.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Kisagiinom, tabickotc Nidadam ka iji sagiijidj. Apanigotc dac 8idji tajikemicik, apanigotc kidji odisigo8eg nisagii8e8in. ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kicpin nosoneameg ka ikido8an, apanigotc kiga odisigona8a nisagii8e8in, tabickotc nin ka nosoneamanin Nidadam odikido8inan, midac apanigotc nidodisigo8an osagii8e8in.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Kigi 8idamonom oo8e, kidji iji kitci modjigendameg, tabickotc nin ka iji kitci modjigendaman. Kinada8eniminom mizi8e kidji modjigendameg. ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Mi oo e 8idamonagok panima kidji todamegoban. Sagiidiok kakina pepejig e tacieg, tabickotc eji sagiinagok. ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Aa8e ka pagidendag opimadizi8in o8idji8aganan odji, ka8in okackitosin a8acamej kidji 8abadai8edj adi epitci kitci sagiadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kina8a sa ni8idji8aganag kidapiteniminom, kicpin todameg adi e ikido8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ka8in mina8adj anokitage8innig kiga ijinikanisinonom. Anokitage8inni mega ka8in teb8e okikendasin adi enendamindjin okackaman. Ni8idji8aganag dac kidijinikaninom, egi kikinoamaonagok kakina ka 8idamaojidj Nidadam. ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ka8in kina8a ka onabamijieg. Nin sa ka onabaminagok acitc ka ijinijaonagok kidji paba ijaieg, kitci mane kidji mino todameg. Ini dac mino kegonan ke todameg kagige kada tag8anon. Kakina dac ke iji pagosenimeg Nidadam ni8izonikag, kiga minigo8a. ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Sagiidiok dac kakina pepejig e tacieg. Mi ka iji 8idamonagok kidji todameg.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jesos kiabadj ki ikido: “Apitc igi8e ka ana8enima8adjin Kije Manidon madjenimigo8eg, kikikendana8a nin nitam kagi madjenimiji8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kicpin kekina8a ana8enimegoban Kije Manido, igi8e a8iagog kidagi sagiigo8ag, tabickotc 8ina8a ka iji sagiidi8adj kakina pepejig e taci8adj. Kina8a dac, ka8in kidacidagimigosim igi8e ka ana8enima8adjin Kije Manidon. Kigi onabaminom mega ega kidji iji tibendagozieg 8ina8akag. Midac ii 8edji madjenimigo8eg igi8e.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","“Ka8in 8anikekegon ka 8idamonagok: ‘Anokitage8inni ka8in na8adj apitendagozisi apitc8in okackaman,’ kigi ininom. Nandam a8iagog nigi nanekadjiigog, midac kekina8a kiga nanekadjiigom. Kodagiag dac ogi odapinana8a ka iji kikinoamageian, midac acitc oga odapinana8a kekina8a ke iji kikinoamageieg. ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","E nosoneojieg, mi ke odji nanekadjiigo8eg. Ka8in mega okikenimasi8a8an ini a8ian kagi pidjinijaojindjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Kicpin ega ki pijaiaban, acitc ega ki aiamiag8aban, ka8in kadagi ikidonani8asiniban egi patadi8adj. Nogom dac ka8in okackitosina8a kidji ajide8e8adj egi patadi8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","A8enenigotc madjenimijidj, omadjeniman acitc Nidadaman. ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ega 8ikad kodag a8iag kagi ijitcigedj, nigi pi ijitcige. Kicpin ega iidi ki ijitcigeiaban, ka8in kadagi ikidonani8asiniban egi patadi8adj. Aja nogom ogi 8abadana8a ka pi ijitcigeian, misa8adj dac nimadjenimigog acitc Nidadaman omadjenima8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Midac iidi ka iji8ebag ii kagi mazinadenig Coda8innig odinakonige8ini8akag: ‘Anicagotc nigi madjenimigog,’ mazinadeni.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Apitc ijaian Nidadamikag, niga pidjinija8a kina8akag aa8e ke pi 8idokago8eg. Mi aa Mino Manido, Nidadamikag ka odjidj, ka teb8edj e mikomadjin Kije Manidon adi ejinagozindjin. Apitc dac pi tag8icig, niga mikomig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kekina8a kiga mikomijim. Kigi 8idjiojim mega ka ako madjitaian kidji kikinoamageian.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Kigi 8idamonom adi ke iji8ebag ega kidji poni teb8etameg apitc iji8ebag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Kiga sagidjinijaogom Coda8inni aiamiemigi8amikag. Kada ijise kidji nisigo8eg, midac ‘Nidanokita8anan Kije Manido’ kada inendamog igi8e ka nisigo8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Mi ke todamo8adj, ka8in mega ododji kikenimasi8a8an Nidadaman, ka8in kek8an nin nigi kikenimigosi. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nogom dac ki8idamonom ii. Midac apitc odjitcisenig ii kidji todamo8adj, kiga mika8im egi 8idamonagok ii.” “Ka8in oo kidodji 8idamaosinonom apitc nitam ka madjitaieg kidji nosoneojieg, kipaba 8idjiona8aban mega. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nogom dac nimadja, ninada 8abama aa8e kagi pidjinijaojidj. Ka8in dac 8a8adj pejig e tacieg kik8ag8edjimijisim: ‘Adi ejaian?’ ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kikitci kackendana8adok dac egi 8idamonagok kidji madjaian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Teb8e ki8idamonom, na8adj kiga mino iji8ebizim kicpin madjaian. Kicpin mega ega madjaian, aa8e ke pi 8idokago8eg ka8in kada pi tag8icisi. Kicpin dac madjaian niga pidjinija8a kina8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Midac apitc tag8icig, oga kikendamonan a8iagon ooma akig e patado8inni8indjin, acitc oga inan a8ian e k8aiak8abamijindjin Kije Manidon, acitc kidji pi tibakonigendjin Kije Manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Oga kikendamonan e patado8inni8indjin, egi ana8etamindjin kidji teb8etaojindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Oga inan e k8aiak8abamijindjin Kije Manidon, Nidadamikag mega nidija acitc ka8in mina8adj kiga 8abamijisim. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Oga inan kidji tibakonagani8indjin Kije Manidon, madji manido mega aja ki tibakonagani8i, 8in ka kackakanadjin a8iagon ooma akig ega e teb8etaojindjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Kiabadj manedon kegonan e 8i 8idamonagok, anic dac ka8in kikackitosina8a kidji nisidotamegon nogom. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Apitc dac pijadj Mino Manido ka teb8edj e mikomadjin Kije Manidon adi ejinagozindjin, kiga kikendamonigo8a kakina teb8e8ini Kije Manidokag ka odjimaganig. Ka8in 8inikag kada odjimagasini ke ikidodj. Misa kiga 8idamagom ka iji nodag acitc adi ke pi iji8ebag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Niga ndotaog ekido8an, 8in dac kiga kikendamonigo8a. Kiga 8abadaigo8a dac epitci icpendagozian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kakina mega kegonan Nidadam ka aiagin, mi kenin nitibendanan. Midac ii 8edji ikido8an Mino Manido kidji 8idamago8eg adi ka ikido8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jesos kiabadj ki ikido: “Peconag8an aja ega kidji 8abamijieg, midac ka8in kin8ej mina8adj kiga koki 8abamijim,” ogi inan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nandam dac Jesos okikinoamaganan ki k8ag8edjimidi8an: “Adi dac 8a ikidomaganig ii ka ikidodj: ‘Peconag8an aja ega kidji 8abamijieg, midac ka8in kin8ej mina8adj kiga koki 8abamijim’? Acitc dac ki ikido: ‘Nidadamikag mega nidija.’ ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Adi 8a ikidomaganig ‘Peconag8an aja’ acitc ‘Ka8in kin8ej’ ka ikidodj? Ka8in ninisidotasinanan adi 8a ikidodj,” ki ikido8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesos ogi kikendan kegoni e 8i k8ag8edjimagani8idj, midac ogi inan: “Kigi 8idamonom: ‘Peconag8an aja ega kidji 8abamijieg, midac ka8in kin8ej mina8adj kiga koki 8abamijim.’ Mi na ii ka iji k8ag8edjimidieg? ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Teb8e ki8idamonom, kiga ma8im acitc kiga kackendana8a, igi8e dac ka ana8enima8adjin Kije Manidon kada modjigendamog. Kina8a pinama kiga kackendana8a. Midac mina8adj kiga poni kackendana8a, kiga kitci min8endana8a. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","8adan ik8e e 8i akozidj kidji otcidjicimidj. Kitci sanagendam, okikendan mega aja e odjitcisenig kidji kodagitodj. Apitc dac nta8igindjin otcidjiciman, kakina 8anike ka iji kodagitodj. Kitci modjigendam mega egi nta8igindjin otcidjiciman. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Misa dac pejig8an kekina8a kikackendana8a nogom. Kiga modjigendana8a dac apitc mina8adj koki 8abamijieg. Ka8in dac a8iag kigagi makamigosi8a kimodjigendamo8ini8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Ii dac apitc, ka8in mamakadj kegon kiga k8ag8edjimijisim. Teb8e ki8idamonom, kakina kegoni ke pagosenimeg Nidadam ni8izonikag, kiga minigo8a. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ka8in maci kegoni kidodji pagosenimasi8a8a ni8izonikag. Pagosenimeg, midac kiga odisigona8a, ka8in dac kegon kiga nodesesim ke iji modjigendameg.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Kakina ii kigi 8idamonom e abadjito8anin adisokanan. Kada ijise dac kiabadj kidji aiamiinagok ega e abadjito8anin ini. Midac maia kiga aiamiinom e mikomag Nidadam. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ii apitc, kiga pagosenima8a Nidadam ni8izonikag. Ka8in dac nidikidosi nin kidji pagosenimag kina8a odji. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","8in mega Nidadam kisagiigo8a. Kikikenimigo8a e sagiijieg acitc e teb8etameg Kije Manidokag e odjian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Teb8e Nidadamikag nigi pi odji, ooma akikag egi pijaian. Nogom dac nimadja kidji koki nda 8abamag Nidadam,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Okikinoamaganan dac ogi igon: “Aja dac 8e8enda ninisidotananan, ega e abadjito8anin adisokanan kidji anim8ean. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nikikendananan nogom kakina kin kegon e kikendaman. Kicpin a8iag 8i kikendag kegoni, ka8in mamakadj kada k8ag8ed8esi. Aja mega kikikendan adi kagi iji onendag kidji k8ag8edjimik. Mi 8edji iji teb8etamag Kije Manidokag e odjian,” ogi igon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesos ogi nak8e8ajian: “Teb8e na ii ka ikido8eg ‘Niteb8etananan’? ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Aja pecodj kada ijise kakina pepejig e tacieg kidji ojimo8eg. Kiga ki8em kimigi8ami8akag. Kiga naganijim nin eta. Ka8in dac pekic teb8e nin eta niga tesi, kabena mega Nidadam ni8idji8a. ");
INSERT INTO alqALGNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mi oo kagi iji 8idamonagok, kidji gi pekadendameg eji 8idjiojieg. Ooma akikag kiga kodagitom. Anic dac sogideeok! Aja kakina kegon ooma akig nigi cagodjiton,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ka ick8a aiamiadjin okikinoamaganan, Jesos ki icpanabi acitc ki aiamie: “Nidadam! Aja odjitcise nogom. Nin sa Kig8izis. 8abadai8en epitci icpendagozian nin, midac nintam kidji gi odji 8abadai8eian epitci icpendagozian kin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Aja mega kigi minijinan kidji tibenimag8a kakina a8iagog, kidji gi minag8a kagige pimadizi8ini, kakina ka taci8adj kagi minijian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kicpin kikenimik8a, kin eta 8edjida maia Kije Manido, acitc kicpin kikenimiji8adj, nin Jesos Christ kagi pidjinijaojian, kagige kada odji pimadizi8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ooma akig nigi 8abadai8e epitci kitci icpendagozian kin. Kakina nigi todan adi kagi inanonijian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nidadam! Ab8amaci tag8agiban aki, nigi kitci icpendagozinan e 8idjiojian. Minicin dac nogom mina8adj kidji iji kitci icpendagozian e 8idjiojian.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Igi8e kagi minijian ooma akig, nigi kikendamonag a8eneni8ian kin. Kinikag iji tibendagozibanig, midac kigi minijinan igi a8iagog. Ogi todana8a dac kagi 8idama8ad8a kidji ijita8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nogom dac okikendana8a teb8e kinikag e odjimagagin kakina kegonan kagi minijian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nigi 8idama8ag mega kagi inanonijian kidji tibadjimo8an, midac ogi teb8etana8a. Nikikenimigog ketcinadj teb8e kinikag egi pi odjian, acitc teb8etamog egi pidjinijaojian.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nidaiamietama8ag dac ogo8eni8ag. Ka8in 8in nidaiamietama8asig igi8eni8ag ega ka teb8etamo8adj. Anic dac nidaiamietama8ag igi8eni8ag kagi minijian, kitibenimag mega. ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Kakina igi8e ka tibenimag8a, kin acitc kitibenimag. Kakina igi8e ka tibenimad8a, nin acitc nitibenimag. Ogo8eni8ag dac ka tibenimad8a, 8abadai8e8ag epitci icpendagozian nin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nogom niga nagadan aki, kinikag nipija. 8ina8a dac kiabadj akikag kada te8ag. Nidadam! Ma8adji kikitcit8a8izinan! Nagadjiik, ki8izon e abadjito8an, kidji gi pejig8eiendagozi8adj, tabickotc kin acitc nin ka iji pejig8eiendagoziak. Kitci macka8izimagan ki8izon kidji gi nagadjiad8a, mi ii 8izon kagi minijian kidji iji macka8izian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Meg8adj ka 8idji8ag8a, ninagadjiabanig, ki8izon kagi minijian e abadjito8an. Pejig dac eta ka taci8adj ki 8anicin, mi aa8e kagi inendagozidj kidji 8anicig. Kitci Mazinaiganikag ki nigani mazinadeni kidji 8anicig, midac ii kagi iji8ebizidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Nogom dac nipija kinikag. Nidikidonan dac ono kegonan ooma akikag kiabadj e teian, mizi8e kidji gi modjigendamo8adj ke8ina8a, tabickotc nin epitci modjigendaman. ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nigi 8idama8ag kagi iji inanonijian kidji tibadjimo8an. Ogi odji madjenimigo8an dac ini8e ka ana8enimik8a, ka8in mega iji acidagimagani8isi8ag 8ina8akag, tabickotc nin ega ka iji acidagimigo8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ka8in kipagosenimisinon kidji madji8inad8a ega kidji pimadizi8adj ooma akikag. Tiegodj kidiji pagosenimin kidji nagadjiad8a ega kegoni kidji todago8adjin ini madji manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ka8in iji acidagimagani8isi8ag 8ina8akag ka ana8enimik8a, tabickotc nin ega ka iji acidagimigo8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","“Kin eta kidji tibenimad8a iji todan, kiteb8e8in e abadjito8an. Mi sa ii teb8e8in kidikido8in. ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kigi pidjinijaojinan kidji tibadjimo8an min8adjimo8in a8iagokag ooma akig. Midac pejig8an nigi ijinija8ag ke8ina8a kidji tibadjimo8adj min8adjimo8ini a8iagokag ooma akig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nipagidenimidizonan kin eta kidji tibenimijian, 8ina8a odji. Mizi8e kin eta kidji gi tibenimad8a 8edji todaman.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ka8in 8ina8a eta nidaiamietama8asi8ag. Nidaiamietama8ag acitc kakina ini8e ke nodago8adjin, midac kidji odji teb8etaojindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nidaiamietama8ag dac kakina ka teb8etamo8adj, kidji gi pejig8eiendagozi8adj. Nidadam! Nidaiamietama8ag kidji gi kigicka8agid8a, tabickotc kin ka iji kigickaojian acitc nin ka iji kigickaonan, kakina a8iagog ooma akig kidji gi teb8etamo8adj teb8e egi pidjinijaojian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Kin kigi minijinan kidji icpendagozian. Mi pejig8an nigi minag kidji icpendagozi8adj, mama8i kidji gi pejig8eiendagozi8adj, tabickotc kin acitc nin ka iji pejig8eiendagoziak. ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nin ni8idji8ag, acitc kin ki8idjiojinan. Nidaiamietama8ag dac maiagotc kidji pejig8eiendagozi8adj. Midac a8iagog ooma akig kidji kikendamo8adj egi pidjinijaojian, acitc kidji kikendamo8adj e sagiad8a maia pejig8an ka iji sagiijian.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Nidadam! Igi8e kagi minijian, ninada8endan ka iji teian ke8ina8a kidji te8adj, mi kidji 8abamiji8adj epitci icpendagozi8ag. Kigi minijinan kidji iji icpendagozian, egi sagiijian ab8amaci ojitcigadeg oo aki. ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Nidadam! Kikitci k8aiakozinan! Igi8e ega ka teb8etamo8adj ka8in kikikenimigosig. Nin dac kikikenimin. Ogo8eni8ag dac ka teb8etamo8adj, kikikenimigog egi pidjinijaojian. ");
INSERT INTO alqALGNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nigi kikendamonag adi ejinagozian kin, acitc mi kiabadj ke kikendamonag8a. Midac pejig8an kagi iji sagiijian, ke8ina8a kodag a8iagon kidji sagia8adjin. Acitc dac nin niga 8idji8ag.” Mi ka ikidodj Jesos e taji aiamiedj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ka ick8a aiamiedj, Jesos acitc okikinoamaganan ki sagaamog, k8ekagam Sedinon (Cédron) sibi e ija8adj. Tag8anoban iima kitigan aki, mi iima ka ija8adj Jesos acitc okikinoamaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, 8in ka mamijimadjin Jesosan, okikendanagoban ke8in ii8e kitigan akini. Jesos mega acitc okikinoamaganan mojag ki ija8agoban iima. ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas dac ki ija iima kitigan akikag, cimaganican ogi 8idji8agoban acitc nandam naben ka kana8endaminigobanen kitci aiamiemigi8amini. Ini8eni8an dac naben, mi igi Coda8inni kitci aiamie ogimag acitc Coda8innig ka nagadjito8agobanen inakonige8inan ka ijinija8a8agobanen. 8asakonendamaganan otakonana8agoban acitc pajibaiganatigon. ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesos ogi nda nagicka8an, e kikendamogobanen adi ke iji8ebizidj. Midac ogi k8ag8edjiman: “A8enen ka nanada 8abameg?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“Jesos, Nazaret ka odjidj,” ogi iji nak8e8ajiigon. Jesos dac ki ikido: “Nin mada Jesos.” Judas dac, 8in ka mamijimadjin Jesosan, tajigaba8iban ke8in ka iji okogaba8inipanin cimaganican acitc ini naben ka kana8endaminipanin kitci aiamiemigi8amini. ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Apitc dac Jesos ka inadjin: “Nin mada Jesos,” ki ajecka8ag acitc motakamig ki pagicinog. ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Mina8adj dac Jesos ogi k8ag8edjiman: “A8enen ka nanada 8abameg?” Ki ikido8ag dac: “Jesos, Nazaret ka odjidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesos dac ogi nak8e8ajian: “Aja kigi 8idamonom nin mada Jesos. Kicpin dac nin ka nanada 8abamijieg, pagidinikog ogo ka 8idji8ag8a kidji madja8adj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Midac kidji iji8ebanig Jesos oo kagi ikidogobanen: “Nidadam! Igi8e ka minijian ka8in iaga pejig e taci8adj nidodji 8aniasi.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simo Pien odaianaban kitci mokomani. Ogi sagidjibidon, midac ogi pakite8an Coda8inni aiamie ogiman ma8adji ka niganizindjin odanodagani, acitc ogi kickita8age8eba8an ka iji okitcinikindjin inekena. Malkos (Malchus) ijinikazoban aa anodagan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesos dac ogi inan Pienan: “Koki pinaan ii kikitci mokoman. Kidinendan na ega kidji animizian Nidadam ka iji nda8enimijidj?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Cimaganicag acitc ocimaganici ogimami8an acitc Coda8innig ka kana8endamo8agobanen kitci aiamiemigi8amini ogi na8adjibina8an Jesosan acitc ogi mag8apina8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nitam dac ogi iji8ina8an Annasikag (Anne). Mi aa Kaiapas (Caïphe) ojicejibanin, ii apitc Coda8inni aiamie ogima8igoban ma8adji ka niganizigobanen 8aa Kaiapas. ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","8in dac Kaiapas kagi 8idama8agobanen Coda8innin ka niganizindjin oo: “Na8adj kada minose pejig eta a8iag nibopan kakina Coda8innig odji.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simo Pien acitc pejig kodag kikinoamagan ogi nosone8a8an Jesosan. Aa kikinoamagan Coda8inni aiamie ogiman ma8adji ka niganizindjin okikenimigobanin. Apitc dac ka tag8icino8adj aiamie ogiman ma8adji ka niganizindjin omigi8aminikag, ke8in ki pidigeako aa kodag kikinoamagan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pien dac ag8adjik ki tajigaba8i opimena ick8ademikag. Aa dac kikinoamagan aiamie ogiman ka niganizindjin ka kikenimigopanin ki pi koki sagaam. Ogi aiamian anodaganik8e8an ka kana8endamindjin ick8ademini. Midac ogi iji pidigean Pienan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Aa dac anodaganik8e ogi inan Pienan: “Kana kekin pejig okikinoamaganan aa nabe?” Pien dac ogi nak8e8ajian: “Ka8in.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Anokitage8innig acitc igi nabeg ka kana8endamo8agobanen kitci aiamiemigi8amini ki poda8e8ag kidji a8azo8adj, osa mega kitci takaianiban. Pien dac ke8in iima ki nda a8azo. ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Meg8adj dac ii, Coda8inni aiamie ogima ma8adji ka niganizidj ogi k8ag8edjiman Jesosan: “A8eneni8ag igi kikikinoamaganag? 8egonen kekinoamagean?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesos dac ogi nak8e8ajian: “Kakina a8iagog nigi aiamiag kabena, Coda8inni aiamiemigi8amikag acitc kitci aiamiemigi8amikag. Nigi taji kikinoamage ka iji ma8adjiidi8adj Coda8innig acitc ka8in 8ikad nidodji kimodji anim8esi. ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","8egonen dac 8edji k8ag8edjimijian ii8e? K8ag8edjimik kakina ka nodaoji8adj. Okikendana8a adi kagi iji kikinoamageian.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Apitc Jesos ka ikidodj ii, pejig ka taci8adj ka kana8endamo8agobanen kitci aiamiemigi8amini ogi pasaba8an Jesosan. Ogi inan dac: “Mi na iidi e iji nak8e8ajiadj Coda8inni aiamie ogima ma8adji ka niganizidj?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesos ogi nak8e8ajian: “Kicpin kegon kagi madji ikido8an, tibadjimon dac adi kagi iji madji ikido8an, kakina kidji nodaok8a. Kicpin dac k8aiak ki ikido8an, 8egonen 8edji pakiteojian?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Midac aa Annas (Anne) ogi madjinija8an Jesosan Kaiapas (Caïphe) ka iji tepan kidji iji8inagani8indjin, 8in Kaiapas Coda8inni aiamie ogima8iban ma8adji ka niganizidj ii apitc. Kiabadj dac mag8apinagani8iban Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Meg8adj dac ii, Pien kiabadj taji a8izoban. Ki k8ag8edjimagani8i dac: “Kana kekin pejig okikinoamaganan aa nabe?” Pien dac ki ikido ega e teb8emaganig ii, e nak8e8ajiadjin: “Ka8in!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pejig Coda8inni aiamie ogima ma8adji ka niganizidj odanodaganan, iji otcina8emagani ini naben Pien kagi kickita8age8eba8adjin. Ogi inan dac Pienan: “Kana iima kitigan akikag kigi 8abamisinon e 8idji8adj?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pien mina8adj ki ikido ega e teb8emaganig ii. Maiagotc dac ii apitc nabe pakaak8an ki nodagozi. ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jesos Kaiapasikag ki odji madjinagani8i, kitci ogima odogima8imigi8amikag kidji iji8inagani8idj. Aja pidabinogoban. Coda8innig ka niganizi8adj ka8in odji pidigesi8ag kitci ogiman odogima8imigi8aminikag. Ka8in mega kadagi paiekideeiendagozisi8agoban kicpin iima iji pidige8agobanen, midac ka8in kadagi inendagozisi8agoban kidji Coda8inni magoce8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Aa dac kitci ogima, Pilat ka ijinikazogobanen, ki pi sagaam. Ogi pi nazika8an Coda8innin ka niganizindjin acitc ogi inan: “8egonen eji anamenimeg 8aa a8iag?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ogi nak8e8ajia8an: “Kicpin ega ki panaagepan, ka8in kidagi pidamagosi.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilat dac ogi inan: “Koki odapinik kina8agotc tibina8e. Tibakonik adi e iji inakonigeieg.” Coda8innig ka niganizi8adj ogi ina8an: “Ka8in nidinendagozisimin kidji tibakonagidj a8iag kidji nisagani8idj,” ki ikido8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Midac kidji gi iji8ebanig Jesos ka ikidopan apitc ka mikodagiban adi ke iji nibodj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilat dac ki koki pidige odogima8imigi8amikag, midac ogi nd8e8eman Jesosan. Ogi k8ag8edjiman dac: “Kin na Coda8innig odogimami8an?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesos ogi nak8e8ajian: “Kin na tibina8e kagi inendaman oo ka k8ag8ed8ean? Konigotc kodag a8iag kigi iji 8idamag e mikomijidj?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilat ogi nak8e8ajian: “Ka8in Nicoda8inni8isi nin! Kidinakanezi8inag acitc kitci aiamie ogimag kigi pidjinijaogog kidji tibakoninan. Adi dac ka inakamigizian?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesos ogi nak8e8ajian: “Ka8in ooma akikag odjimagasinon nidogima8i8in. Kicpin ooma akikag odjimagagiban nidogima8i8in, kadagi migazobanig igi8e ka 8idji8ag8a. Ka8in odagi pagidinasi8abanin Coda8innin ka niganizindjin kidji takonijindjin. Anic dac ka8in ooma akikag odjimagasinon nidogima8i8in.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilat dac ogi inan: “Kidogima8inan na dac?” Jesos ogi nak8e8ajian: “Kin ka ikido8an e ogima8ian nin. Oo8e dac eta 8edji ki pijaian ooma akikag acitc 8edji ki nta8igian, teb8e8in kidji mikodaman. Igi8e ka nanada kikendamo8adj teb8e8ini, onadotana8a adi e ikido8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilat dac ogi inan: “8egonen ii teb8e8in?” Ka ick8a ikidodj ii, Pilat mina8adj ki sagaam kidji nda nagicka8adjin Coda8innin. Ogi inan dac: “Ka8in kegon nimikasin kidji gi panaagedj 8aa nabe. ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","E taso pibog meg8adj e Coda8inni Kitci Magocani8ag, pejig takonigan ki8ina8a kidji gi pagidinag, mi ii e todameg ako. A8enen dac ke pagidinag? Kinada8endana8a na kidji pagidinag kina8a ka Coda8inni8ieg kidogimami8a?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Midac ki madji pabibagi8ag: “Ka8in 8in! Barabbas aa ka 8i nda8enimagidj!” 8in Barabbas kimodi8inni8iban ka kitci sogendagozidj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilat dac ki anoki kidji madjinagani8indjin Jesosan acitc kidji pajacte8agani8indjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Cimaganicag dac minesatigoni ki apikage8ag, sizok8epizoni e ojito8adj, midac Jesos octig8anikag ka iji 8agidato8adj. Ogi pisikamodina8an e misk8eganig okonasini. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ogi nazika8a8an dac e papasaba8a8apanin acitc e ina8adjin: “Kidanamikago, Coda8innig odogimami8an!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilat kiabadj ki koki sagaam acitc kakina a8ian ogi inan: “Ndotamok, ooma niga pina ag8adjik kidji kikendameg ega e mikaman kidji gi panaagedj 8aa nabe.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesos dac ki sagaam, ka minesatigo8anig sizok8epizoni e kigickag acitc ka misk8eganig okonasini. Pilat dac ki ikido: “8adan 8aa nabe!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Apitc dac Coda8inni kitci aiamie ogimag acitc igi nabeg ka kana8endamo8agobanen kitci aiamiemigi8amini ka 8abama8adjin Jesosan, ki pabibagi8ag: “Acidak8ao tcibaiatigokag! Acidak8ao tcibaiatigokag!” Pilat dac ogi inan: “Odapinik acitc acidak8aok kina8a tibina8e. Nin dac ka8in kegon nimikasin kidji gi iji panaagedj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Coda8innig dac ogi nak8e8ajia8an: “Inakonige8in nidaiananan, ikidomagan dac ii inakonige8in e inendagozidj kidji nibodj. Ki ikido mega Kije Manido Og8izisan e aiaa8idj.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Apitc Pilat ka nodag e ikidondjin, kiabadj a8acamej ki kitci segizi. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Mina8adj dac ki koki pidige odogima8imigi8amikag. Jesosan dac ogi k8ag8edjiman: “Adi 8edosean?” Ka8in dac Jesos ki nak8e8ajitagesi. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilat dac ogi inan: “Kana ki8i nak8e8ajitaojisi? Kana kikikenimijisi kidji kackito8an kidji pagidininan konigotc kidji acidak8aonan?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesos ogi nak8e8ajian: “Ka8in kegon kida kackitosin kidji todaojian, kicpin ega ki iji minigo8aban Kije Manido, 8in icpimig ka tedj. Mi 8edji na8adj patadidj aa kagi 8aiejimijidj egi pidji8inijidj ooma.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Midac ka nodag ii, Pilat onanada 8abadanaban kidji gi pagidinadjin. Coda8innig dac ki kitci pabibagi8ag: “Kicpin pagidinadj aa a8iag, ka8in kimin8enimasi aa kitci ogima Sesar (César). A8enenigotc ka 8i ogima8iidizodj, odana8eniman ini kitci ogiman Sesar.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Apitc Pilat ka nodag e ikidondjin, ogi sagidji8inan Jesosan. Pilat dac ki abi otesabi8aganikag adi ka iji tibakonigedj ako. Mi 8edi kagi iji iji8ebag, taji ka ijinikadjigadeg “Ka asini8ag tesisagag.” Coda8inni dac ijigij8e8in, “Gabbata” ijinikadeban. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ii apitc kegat abitakijiganogoban, 8abag kidji Coda8inni Kitci Magocani8agiban. Pilat dac ogi inan Coda8innin: “Mi 8aa kidogimami8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ki pabibagi8ag dac: “Nici! Nici! Acidak8ao tcibaiatigokag!” Pilat dac ogi inan: “Niga acidak8a8a na kidogimami8a?” Coda8inni kitci aiamie ogimag ogi nak8e8ajia8an: “Ka8in kodag ogima nidaia8asi8anan, mi eta kitci ogima Sesar.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Midac Pilat ogi iji pagidinan Jesosan kidji acidak8a8agani8indjin tcibaiatigokag. Jesos dac ki madji8inagani8i. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ki iji8inagani8i ag8adjik odenakag, 8in tibina8e e pimi8inadjin otcibaiatigoman. Ogi odjitci8inan dac 8edi “Tcibaictig8an” ka ijinikadeg, Coda8innig dac ka ijigij8e8adj “Golgota” ka ijinikadeg. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Mi iima cimaganicag ogi acidak8a8a8an Jesosan tcibaiatigokag. Nijin kodagiag a8iagog acitc ki acidak8a8agani8i8ag ke8ina8a otcibaiatigomi8akag, midac nasa8idj Jesos ka iji padakicimagani8inigobanen otcibaiatigoman egi acidak8a8agani8idj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilat ki anoki kidji panaskak8eigadenig ojibiigani tcibaiatigokag. Midac kagi ojibiigadegobanen: “Mi 8aa Jesos Nazaret ka odjidj, Coda8innig odogimami8an.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Taji Jesos kagi iji nisagani8igobanen peconag8aniban odenakag. Kitci mane dac Coda8innig ogi nabo8adana8a ii ka mazinadenig. Nisin ijigij8e8inan mega ki abadanon e ojibiigadeg ii, Coda8innig odijigij8e8ini8a, Rom ka odji8adj odijigij8e8ini8a, acitc Kanes (Grèce) aki ka odji8adj odijigij8e8ini8a. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Coda8inni kitci aiamie ogimag dac ogi ina8an Pilatan: “Ka8in kidagi ojibiasin ‘Coda8innig odogimami8an.’ Kidagi ojibian ‘Nin Coda8innig odogimami8an ki ikido 8aa a8iag.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilat ogi nak8e8ajian: “Ka ojibiaman ii mi ke ijinag8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Apitc dac cimaganicag ka ick8a acidak8a8a8adjin Jesosan, ogi odapinana8an odaimini, acitc ki madinamadi8ag pepejig e taci8adj eji nio8adj. Acitc dac ogi odapinana8a okonasini ega ka kackig8adenig e mizi8eiganig icpimig pinici tabacic. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ki ikido8ag dac igi cimaganicag: “Ka8in kiga pigobidosinanan oo okonas. K8ag8e mikosedan a8enen ke tibendag.” Midac kidji gi iji8ebag Kije Manido Omazinaiganikag ka ikidomaganig: “Ki madinamadi8ag nidaiman, acitc ki k8ag8e mikose8ag nikonasini.” Mi ka todamo8adj cimaganicag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesos odjodjoman pecodj tajigaba8ibanin otcibaiatigomikag, acitc onocejan, acitc kodag ik8e Mani ka ijinikazogobanen, 8in aa Klopas okokomiman, acitc dac Mani Magdala. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesos dac ogi 8abaman odjodjoman acitc ogi 8abaman ini pejig okikinoamaganan ka kitci sagiadjin. Midac ogi inan odjodjoman: “Nidjodjom! Mi 8aa kig8izis.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Mina8adj dac ogi inan okikinoamaganan: “Mi 8aa kidjodjom.” Ick8a dac ii, aa kikinoamagan ogi kana8eniman Jesosan odjodjomini omigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesos ogi kikendan aja kakina kegoni egi iji8ebanig. Ki ikido dac: “Nipag8anamonan.” Mi ka ikidodj maiagotc kidji ick8a iji8ebanig ka ojibiigadenig Kije Manidon Omazinaigani. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Onagan dac ateban iima e kicponebig cominabo ka kitci 8isagagamig. Cimaganicag dac ogi kidagaminana8a ka opani8anig kasiigani. Ogi agodona8a kibisatigokag “isop” (hysope) ka ijinikazondjin, acitc ogi icpak8aama8a8an Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Apitc dac kagi minik8edj, Jesos ki ikido: “Mi kakina egi iji8ebag.” Ki onijik8ese, midac ka iji ick8anamodj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Tcibaiatigogijiganogoban ii apitc, apitc ako meg8adj e medoni mikidamo8agobanen kidji Coda8inni aiamie kijiganig. Ii8e dac apitc ka Coda8inni aiamie kijiganig ogi kitci apitendana8agoban Coda8innig. Ka8in dac onada8enimasi8a8abanin ini8e kagi nisagani8indjin kidji tanagodjinindjin meg8adj e aiamie kijiganig. Midac ka niganizi8adj Coda8innig ogi k8ag8edjima8an Pilatan kidji anokindjin kidji pokogadenagani8indjin Jesosan acitc kodagian kagi acidak8a8agani8indjin tcibaiatigokag, 8ibadj kidji gi nibondjin, kidji gi nisakonagani8indjin ab8amaci kidji aiamie kijiganig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Cimaganicag dac ki ija8ag kidji pokogade8a8adjin nijin kodagian ka 8idji acidak8a8agani8indjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Apitc dac ka odisa8adjin Jesosan, ogi 8abama8an aja egi nibondjin, ka8in dac ododji pokogade8asi8a8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pejig dac cimaganic opik8anakag ogi iji pajiba8an. Teci8ag dac misk8ini acitc nibini ki pi sagidajiga8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Aa dac kagi 8abadag tibadjimo, kekina8a kidji gi teb8etameg. Otibadjimo8in dac teb8emagani, acitc okikendan e teb8edj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Midac iidi ka iji8ebag ii kagi iji mazinadenigobanen Kije Manido Omazinaiganikag: “Ka8in 8a8adj pejig okan odji pig8aigadesinon,” ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","acitc dac kiabadj kagi iji mazinadenigobanen: “Oga kijigabama8an ini8e kagi pajiba8a8adjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kegapitc pejig nabe, Josep ka ijinikazodj, Pilatan ogi nda 8abaman. Animati (Arimathée) odenag odjiban aa Josep. Ogi teb8eta8abanin Jesosan. Ka8in dac odji 8idamagesiban, okitci kosabanin mega Coda8innin ka niganizindjin kidji kikendamindjin. Ogi k8ag8edjiman dac Pilatan kidji gi madji8ido8adj Jesosan o8ia8ini. Pilat ogi pagidinan. Midac ki ija Josep kidji nadji8idodj Jesosan o8ia8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodem (Nicodème), aa kagi pi nda 8abamagobanen Jesosan nigodin e tibikanig, ogi 8idji8an Josepan. Ogi pidonan ka minomag8anigin. Nij8aieginag8anibanin, pejig “mir” (myrrhe) ijinikadeniban acitc kodagini “anos” (aloes) ijinikadeniban, ki mama8isiginigadeno8agoban dac. 8aiej midasomidana (100) tibabadjigan apitanobanin ini ka minomag8anigin kagi pidodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ogi odapinana8a Jesosan o8ia8ini acitc ogi 8ik8epidona8a pabagi8anican e abadjito8adjin, e ato8adj ka minomag8anig. Mi e todamo8agobanen ako Coda8innig e nibonani8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Tag8anoban kitigan aki iima kagi iji nisagani8idj Jesos. Tag8anoban dac iima kitigan akikag ocki 8ibabikinigan, ega 8ikad maci egi abadanigobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Pecodj tag8anogoban ii 8ibabikinigan acitc aja peconag8anogoban kidji Coda8inni aiamie kijigag. Midac iima ka iji ato8adj Jesosan o8ia8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","8ibadj e kijeba8acinig e manadjitagani8anig, meg8adj kiabadj e tibikanogobanen, Mani Magdala ki ija 8ibabikiniganikag. Ogi 8abaman dac kitci asinin egi manibinagani8indjin ka odji pidigani8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","E 8abadag ii, ki kitci ki8ebato kidji nda 8abamadjin Simo Pienan acitc pejig kodagian kikinoamaganan, Jesos ka kitci sagiapanin. Mani dac ogi inan: “Ki madji8idjigadeni ka Tibendjigedj o8ia8 8ibabikiniganikag. Ka8in dac nikikendasinanan adi ka iji atcigadenig.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Simo Pien acitc kodag kikinoamagan ki ipaidi8ag 8ibabikiniganikag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kodag dac 8aa na8adj ki kijibatogoban apitc8in Simo Pien, midac 8intam ki odjitcibatogoban. ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ki camagita e podazig8eabadag 8ibabikinigani. Ogi 8abadanan dac 8ik8eiginiganan kagi abadanigin e 8ik8eiginigadenigobanen Jesosan o8ia8ini e atenigin. Ka8in dac odji pidigesi. ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Apitc Simo Pien ka odjitcibatodj, ki pidige 8ibabikiniganikag. Midac ogi 8abadanan 8ik8eiginiganan, ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","acitc pabagi8anicini Jesosan octig8ani kagi 8ik8eiginigadenigiban. Pepakan dac atebanin ini, egi ojiginigadegin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Aa dac kodag kikinoamagan ki pidige, 8in nitam kagi tag8icig 8ibabikiniganikag. Ogi 8abadan ega e tag8anig iima Jesosan o8ia8ini, midac ogi teb8etan egi abidjibandjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ii apitc, ka8in maci ododji nisidotasina8aban Kije Manidon Omazinaigani kagi ikidomaganigiban panima Jesos kidji abidjibadj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Midac midjinijin ki koki ki8e8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mani Magdala taji ma8iban ag8adjik 8ibabikiniganikag. Meg8adj dac e taji ma8idj, ki camagita e podazig8eabadag 8ibabikinigani. ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ogi 8abaman dac nijin ajenin e 8abiganigin okonasini8an, e taji abindjin adi ka iji atenigiban Jesosan o8ia8ini. Ka inik8ecinipanin Jesosan pejig taji abiban, kodag dac ka ijizidecininipanin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ini ajenin ogi k8ag8edjimigon: “Ik8e! 8egonen 8edji ma8ian?” Ogi nak8e8ajian: “Ki madji8idjigadeni ka Tibenimijidj o8ia8, acitc ka8in nikikendasin adi ka iji atcigadenig.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ka ick8a ikidodj ii, ki k8ekigaba8i acitc ogi 8abaman Jesosan e tajigaba8indjin iima. Ka8in dac ododji nisida8ina8asi8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesosan dac ogi k8ag8edjimigon: “Ik8e! 8egonen 8edji ma8ian? A8enen ka nanada 8abamadj?” “Kitige8inni aa,” inendamogoban Mani. Ogi inan dac: “Kicpin kin ka madjina8ad8en, 8idamaocin adi ka iji asadj, midac niga koki odapina.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesos ogi inan: “Mani!” Ki k8ekigaba8i dac Jesosikag acitc ogi inan: “Rabboni,” “Kikinoamage8inni” 8a ikidomagag e Coda8inni ijigij8ani8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesos dac ogi inan: “Ka8in midjiminijiken, ka8in mega maci nidodji ijasi Nidadamikag. A8i ijik nidjiki8eg Nidadamikag e ijaian, ka iji Odadamieg kekina8a. Mi aa Nikije Manidom, ka iji Okije Manidomieg kekina8a.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mani Magdala dac ogi nda tatibadjimota8an Jesosan okikinoamaganan. Ogi inan dac: “Nigi 8abama ka Tibeniminak!” Ogi 8idama8an dac adi kagi igodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","E ani onag8icig mi pejig8an ii e kijigag e manadjitagani8ag, kikinoamaganag ki ma8adjiidibanig. Ki kibak8aodizo8ag osa e kosa8adjin Coda8innin ka niganizindjin. Jesos dac kitata ki odji nagozi iima acitc ki tajigaba8i nena8idj 8ina8akag, acitc ogi inan: “Pekadendamo8in kimininom.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ka ick8a ikidodj ii, ogi 8abadaan okikinoamaganan onidjin acitc opimena kagi iji pajiba8agani8idj. E 8abama8adjin Jesosan, ki kitci min8endamog. ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesos dac mina8adj ogi inan: “Pekadendamo8in kimininom. Mi maia Nidadam kagi pidjinijaojidj ooma akig, mi kenin kidijinijaonom kidji paba ijaieg.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ka ick8a ikidodj ii, ogi podanan okikinoamaganan acitc ogi inan: “Odapinik Mino Manido kina8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Aa8e ke kasiama8eg opatado8inan kada kasiama8agani8i, acitc aa8e ega ke kasiama8eg opatado8inan ka8in kada kasiama8agani8isi,” ki ikido Jesos. ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pejig Jesos ka midatcin acitc nijindjin okikinoamaganan, Tomas (Thomas), “Aa pejig ka nijonta8igi8adj” ka ijinikanagani8igobanen, ka8in tesiban iima apitc Jesosan ka nagozinipanin. ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kodagiag dac kikinoamaganag ogi ina8an Tomasan: “Nigi 8abamanan ka Tibeniminak.” Tomas dac ogi inan: “Kicpin ega 8abadaman Jesos ka iji saga8agani8idj onidjikag, acitc kicpin ega taginam8ag ka iji agokenigibanin sagaiganan, acitc kicpin ega saminam8ag ka iji namezidj, ka8in niga teb8etasin.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ka ick8a pejigota8ateanig, Jesos okikinoamaganan mina8adj ki ma8adjiidi8an. Tomas dac aja teban iima ke8in. Misa8adj dac ick8ademan e kibakosigibanin, Jesos mina8adj ki nagozi acitc kitata nena8idj ki tajigaba8i. Ogi inan: “Pekadendamo8in kimininom.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ogi inan dac Tomasan: “Aton kinidji ooma acitc kana8abadan ninidjin. Pidon kinidji acitc saminicin nipig8adakag. Midac poni ana8etan, teb8etaocin.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas dac ogi nak8e8ajian: “Ka Tibenimijidj acitc Nikije Manidom!” ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesos dac ogi inan: “Mi panima egi 8abamijian ka teb8etaman. Ca8endagozi8ag igi8e ka teb8etamo8adj misa8adj ega ki 8abamiji8adj,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesos dac mane kodagini mamada8izi8ini ogi todan e 8abamigodjin okikinoamaganan. Ka8in dac kakina odji mazinadesinon oo8e mazinaiganikag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nigi ojibian dac oo8e kidji gi teb8etameg mi aa Jesos kagi ikidonipanin Kije Manidon kidji pidjinijaogodjin, acitc dac Kije Manido ini Og8izisan. Kicpin dac teb8etameg, Jesos kiga minigo8a pimadizi8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ka8in kin8ej ka ick8a 8abamigodjin Jesos okikinoamaganan, mina8adj ogi 8abamigon tcigibiag Tipeniat (Tibériade) sagaiganikag. 8adan kagi iji8ebag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simo Pien, Tomas (Thomas), 8in “Aa pejig ka nijonta8igi8adj” ka ijinikanagani8igobanen, Natanien (Nathanaël), 8in Kana odenag Galilee akikag ka odjigobanen, midjinijin Zebedee og8izisan, acitc nijin kodagian Jesos okikinoamaganan ma8asag tebanig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simo Pien dac ogi inan: “Niga nda pagida8a, kigozag kidji pidaanaan.” Ogi ina8an: “Mi kenina8it niga ijamin.” Ki pozi8ag dac kakina tcimanikag acitc ki a8i pagida8a8ag. Kabe tibik ki inedi8ag, ka8in dac odji pidaanasi8ag kigozan ii e tibikanig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Apitc ka madji pidabanig, Jesos tajigaba8igoban tcigibiag. Ka8in dac okikendasina8aban kikinoamaganag e Jesosi8indjin ini. ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesos dac ogi k8ag8edjiman: “Ni8idji8aganag! Kigozag na kigi pidaanam?” “Ka8in!” ogi iji nak8e8ajia8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesos dac ogi inan: “Kikitciniki8akag inekeonag iji pakobiok kidasabi8a, kigozag dac kada pidaamog.” Mi iidi ka todamo8adj. Ka8in dac okackitosina8aban kidji koki 8ikobina8adjin odasabi8an epitci maneopizonipanin kigozan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Aa dac kikinoamagan Jesosan ka kitci sagiigopanin ogi inan Pienan: “Ka Tibendjigedj aa!” Apitc Simo Pien ka nodag ii, ki pitcikonae egi kitcikonaepan kidji mikimodj, acitc ki pakobig8ackoni. ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Kodagiag kikinoamaganag ki koki ki8ek8aji8ebanig e pimaona8adjin odasabi8an ka kitci kigozi8indjin. Ka8in kitci kin8ej kidji oditamo8adj, 8aiej niso midasomidana (300) tasozid tcigagam tebanig. ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Apitc tcigibiag ka oditamo8adj, ogi 8abama8an e taji kijiz8agani8indjin kigozan acitc pak8ejiganan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesos dac ogi inan: “Pijiok pagi kigoz nogom kagi pidaanaieg.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simo Pien dac ki pozi tcimanikag acitc ogi 8ikobinan ka kitci kicponenigobanen odasabin mane kitci kigozan. Midasomidana acitc nanomidana acitc nisin (153) tacibanig kigozag. Misa8adj e kitci manendjin kigozan asabikag, ka8in odji pigosesi8an. ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesos dac ogi inan: “Pi nda 8isiniok.” Kakina pepejig ka taci8adj cag8enimobanig kidji k8ag8edjima8adjin “A8enen kin?” e kikenima8adjin ka Tibendjigendjin ini. ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesos dac ogi nda odapinan pak8ejiganan, ogi minan, mi acitc kigozan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Mi aja nisinanaj Jesos egi 8abamigodjin okikinoamaganan ka ako abidjibadj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ka ick8a 8isini8adj, Jesos ogi inan Simo Pienan: “Simo, John og8izisan! Na8adj na kisagiijinan apitc8in ogo8e ka iji sagiiji8adj?” Simo dac ogi nak8e8ajian: “Ee, Tebendjigean! Kikikendan e sagiinan.” Jesos dac ogi inan: “8e8enda kana8enimik dac nimantcenicesimag.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Mina8adj dac ogi inan: “Simo, John og8izisan! Kisagiijinan na?” Simo ogi nak8e8ajian: “Ee, Tebendjigean! Kikikendan e sagiinan.” Jesos dac ogi inan: “8e8enda kana8enimik dac nimantcenicimag.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kiabadj dac mina8adj ogi inan: “Simo, John og8izisan! Kisagiijinan na?” Pien ki kackendamise nisinanaj egi k8ag8edjimagani8idj “Kisagiijinan na?” Midac ogi inan: “Tebendjigean! Kakina kegon kikikendan. Kikikendan e sagiinan.” Jesos dac ogi inan: “8e8enda kana8enimik dac nimantcenicimag. ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Teb8e ki8idamon, e abinodjiji8iaban kinigotc kipisika8aban kikitcipizon, acitc kidijanaban adi 8a ijaiaban. Apitc dac ani keteadizian kiga tajonikeninan acitc kodag a8iag kiga kitcipinig. Midac kiga iji8inig adi ega 8a ijaian,” ogi inan. ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kidji kikendjigadeg dac adi ke iji nibodj Pien, kidji odji icpenimagani8indjin Kije Manidon, mi Jesos 8edji ki ikidopan ii. Ka ick8a ikidodj ii, Jesos ogi inan: “Nosoneocin.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pien ki k8ekigaba8i acitc ogi 8abaman ini kikinoamaganan Jesos ka kitci sagiapanin e pizagosendjin odakanag 8ina8akag. Aa dac kikinoamagan mi 8aa ka ijik8enipan Jesosikag e taji 8isini8apan kakina ka taci8adj, acitc ka k8ag8edjimapanin: “Tebendjigean! A8enen aa ke mamijimik?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pien dac ogi 8abaman ini kikinoamaganan acitc ogi inan Jesosan: “Tebendjigean! Adi ke iji8ebizidj 8aa8e?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesos ogi nak8e8ajian: “Kicpin iji nda8enimag kidji pimadizidj pinici kidji koki tag8icinian, adi dac kin kegi todaman? Kin dac, nosoneocin.” ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Anodj dac ki ikidonani8anogoban ii Jesos kagi ikidogobanen, e ikidonani8ag ega kidji nibondjin ini kikinoamaganan. Kitci mane ka teb8eta8a8agobanen Jesosan ki nodage8ag ii. Ka8in dac Jesos ododji inasi8abanin Pienan: “Ka8in kada nibosi.” Tiegodj ki ikidogoban: “Kicpin iji nda8enimag kidji pimadizidj pinici kidji koki tag8icinian, adi dac kin kegi todaman?” ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Mi aa pejig8an kikinoamagan kagi tibadjimodj oo kakina acitc kagi ojibiag. Kikikendananan dac e teb8edj kagi ikidodj. ");
INSERT INTO alqALGNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kitci mane kegoni kiabadj ki ijita Jesos. Kicpin ojibiigadenigiban kakina, ozam kada kitci manedobanin mazinaiganan. Ka8in kada tag8asinobanin adi kegi iji atcigadegibanin akikag.");
INSERT INTO alqALGNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Kin Teopil (Théophile), aja mina8adj kidojibiamon. Nitam mazinaigan kagi ojibiaman, nigi tibadjimonan kakina Jesos kagi ijitadj acitc kagi kikinoamagedj, apitc ka madjitadj omikimo8in pinici kidji icpikadj 8ak8ig. Ab8amaci dac 8ak8ig icpikadj, ogi 8idama8an adi ke todamindjin ini Odanodaganan kagi onabamapanin, Mino Manidon egi odji kikinoamagodjin ke ikidodj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Apitc ka ick8a nibodj, mane8inaj ki nagoidizo Odanodaganikag kidji gi odji ketcinamendamindjin teb8e e pimadizidj. Nimidana (40) tasogon inigik kiabadj ki paba 8abamagani8i acitc omikodanaban Kije Manidon Odogima8i8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nigodin e 8idji 8isinimagobanen Odanodaganan, ogi inan: “Ka8in nagadakegon oo Jerusalem odenag. Kiga pitona8a ii8e Nidadam kagi ikidodj kidji migi8edj, kagi mikodamonagok. ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Cabadis (Jean-Baptiste) nibini ogi abadjiton e sigaadagedj, midac ka8in aja kin8ej, Mino Manidokag kiga iji sigaadagom,” ogi inan. ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Meg8adj dac Anodaganag e paba 8idji8a8agobanen Jesosan, ogi k8ag8edjima8an: “Tebendjigean! Mi na ii apitc ke koki minad8a Israel a8iagog mina8adj kidji tibendamo8adj odogima8i8ini8a?” ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesos ogi nak8e8ajian: “Ka8in kiminigosim kidji kikendameg anapitc kegon ke ijiseg acitc adi ke iji8ebag. Nidadam mega aja 8in ogi onendan, 8in sa kakina kegoni ka tibendag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Macka8izi8ini dac kiga minigo8a, apitc Mino Manido odisigo8eg. Midac kiga mikomijim adi eji kikenimijieg, iima Jerusalem odenag acitc mizi8e Coda (Judée) acitc Samani (Samarie) akig, pinici mizi8ekamig,” ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Apitc ii8eni ka ick8a 8idamagedj, meg8adj e kana8abamigodjin Odanodaganan, Jesos ki icpika 8ak8ig pinici pejig 8ak8ini kidji nigeckagodj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Meg8adj kakina e icpanabi8adj adi Jesosan ka iji icpikandjin, nijin naben e 8abiginokonaendjin kitata ogi odji 8idjigaba8itago8agoban. ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ogi igo8an dac: “Galilee a8iagog! 8egonen 8edji nepidji icpanabieg 8ak8ig? Kigi 8abama8a Jesos ka naganigo8eg, 8ak8ig ka iji icpikadj. Mi maia pejig8an ke ijinagozidj apitc koki tag8icig kagi ijina8eg e madjadj,” ogi igo8an. ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Olip (Oliviers) pik8adinajicikag te8agoban kakina Anodaganag. Midac ki koki ki8e8ag Jerusalemikag. Ii dac pik8adinajic 8aiej abita tibaigan inigik apisinag8anoban Jerusalem odenakag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Apitc Jerusalem odenani ka oditamo8adj, ki ija8ag icpimisagog migi8amig mojag ka ija8apan ako. Iima tebanig Pien, John, Jak (Jacques), Andre, Pilip, Tomas, Batelemi (Barthélemy), Matio (Matthieu), Jak, 8in Alpi (Alphée) og8izisan, Judas, 8in Jak og8izisan, acitc Simon, 8in ka acidagimagani8igobanen taji ka iji ma8asag8akonidindjin ega ka nda8endaminigobanen kidji tibenimigo8adjin ogiman Rom ka odjindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ma8asag kakinagotc e taci8apan ma8adjiidibanig ako kidji aiamie8adj. Ik8e8ag ka teb8etamo8adj ogi 8idji8a8an, acitc Mani, Jesos odjodjoman acitc Jesos o8idjiki8en. ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ii dac apitc, nigodin igi8e ka teb8etamo8adj ki ma8adjiidi8ag. 8aiej dac midasomidana acitc nijidana (120) tacibanig. Pien ki pazig8i nena8idj acitc ogi 8idama8an: ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Nidjiki8eg! Aja ki inateban kidji ijiseg adi Mino Manido kagi ikidopan Kije Manidon Omazinaiganikag. Ogi anim8ean Davidan, kijadj e tibadjimodj Judasan kidji niganindjin apitc nda takonagani8indjin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas dac kina8itinakag acidagimagani8iban acitc ke8in ki minagani8i kidji 8idji mikimomigo8ak,” ki ikido Pien. ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas dac ogi kicpinadonagoban akini, conian kagi minagani8idj e kijika8agani8idj kagi iji madji inakamigizidj. Ki pakodjicin e onijagodjig acitc mizi8e ki sagidjinagijicin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kakina dac a8iagog Jerusalem ka tajike8adj ki nodage8ag. Midac ka ijinikadamo8adj ii akini “Akedama” (Akeldama) 8ina8a odijigij8e8ini8a, mi ekidomagag “Misk8i8aki.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Mina8adj Pien ki ikido: “Mi oo8e mezinadeg 8eckadj Kitci Nigamo8inan Kije Manido Omazinaiganikag: ‘Apanigotc kidji pijicig8atenig ka iji tajikegobanen, acitc ega a8iag kidji k8ag8e tajikedj.’ Mi acitc mezinadeg: ‘Kodagian a8ian kidji nabickagodjin ka iji mikimodj.’ Mi ekidomagag.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Nogom dac kida onabamanan a8iag kidji nabicka8adjin Judasan. Nandam a8iagog apanigotc kigi 8idjiogonanag adi Jesos ka Tibendjigedj ka paba tedj, ka ako madji kikinoamagedj Cabadis kidji sigaadazonani8anig, pinici 8ak8ig kidji iji icpikadj Jesos. Ijinag8an dac pejig a8iag ka taci8adj kidji acidagimagani8idj kina8itinakag kidji pi 8idjiinak kidji tibadjimo8ak Jesosan ka Tibendjigendjin odabidjiba8ini,” ki ikido Pien. ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nijin dac a8ian ogi onabama8an, pejig Josep Basabas (Barsabbas), Jostos (Justus) acitc ka ijinikanagani8idj, acitc kodag Matias (Matthias). ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ma8asag dac kakina ki aiamie8ag: “Tebendjigean! Kin ka kikenimadj pepejig a8iag adi ejideedj. 8abadaicinam a8enen e niji8adj kagi onabamadj kidji nabicka8adjin Judasan, kidji gi mikimodj acitc kidji gi Anodagani8idj ke8in. Judas mega ogi pagidinan omikimo8in kidji ijadj 8edi kagi iji kackitamadizogobanen,” ki aiamie8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pejig dac a8iag ki 8ikobinagani8i kidji onabamagani8idj. Midac Matias (Matthias) ki odapinagani8i kidji acidagimagani8idj, midac ki midatcin acitc niji8ag Anodaganag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Apitc ka odjitcisenig Pentikost (Pentecôte) Kijigan ka ijinikadenig, kakina ka teb8eta8a8agobanen Jesosan ki ma8adjiidi8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kitci kaiezigotc kegoni ki mad8etomagani 8ak8ig e odjisenig, mi maia ka kitci nodinisenig ejisenig. Mizi8e migi8amikag adi ka iji ma8adjiidi8apan, ki iji mad8etomagani. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ogi 8abadana8a e paba pagisinig ickodeni, tabickotc odenanajican e ijinag8anigin. Midac ka iji nenicike paba pagisinig 8agidj pepejig 8ina8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Mino Manidon dac ogi pidigeckago8an kakina a8iagog, acitc pepakan ki ijigij8e8ag, adi Mino Manidon kagi iji minigo8adjin kidji ijigij8e8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","8edi Jerusalem odenakag Coda8innig tebanig ka kitci aiamie8adj, aianodj e odji8apan. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Apitc ka nodamo8adj ka kitci mad8etomaganig, kakina ki ma8adjiidi8ag. Kakina dac ki kitci kock8endamog osa pepejig e noda8a8adjin ka teb8etamindjin mi gotc maia ka ijigij8e8adj ejigij8endjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Coda8innig ki kitci mamakadendamog, midac ki ikido8ag: “Igi8e a8iagog ka aianim8e8adj, kana kakina Galilee akig odjisidog8enag? ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Adi dac pekic kakina pepejig oo ka taciak 8edji noda8aiakonig e ijigij8e8adj maia ejigij8eiak. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nandam kina8it ka taciak Panit (Parthes) akikag odji8ag, nandam Midia (Médie), Elam, Mesopotamia, Coda (Judée), Kapados (Cappadoce), Ponit, Eja (Asie), ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Parijia (Phrygie), Pampilia (Pamphylie), Idjip (Égypte), acitc Libia (Libye) akikag pecodj Sinen (Cyrène). Rom ka odji8adj a8iagog te8ag, ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","nandam e Coda8inni8i8adj acitc nandam a8iagog kagi adjito8adj odaiamie8ini8a kidji gi Coda8inni8i8adj. Nandam Kanet (Crète) acitc Arabi (Arabie) odji8ag. Misa8adj dac pepejig ka taciak, kinoda8ananag maia tabickotc ka ijigij8eiak, e tibadjimo8adj adi ka kitci ijitcigendjin Kije Manidon,” ki ikido8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kakina dac kitci mamakadendamobanig acitc ka8in okikendasina8aban adi ke inendamo8adj. K8ag8edjimidibanig: “Adi dac ii 8a ikidomagag?” ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kodagiag dac 8in opapia8abanin ka teb8etamindjin acitc odina8abanin: “Aja maiagotc ki8ack8ebi8ag igi!” ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pien acitc kodagiag ka midatcin acitc pejigo8adj Anodaganag ki pazig8i8ag acitc Pien ki kitci kiji8e e anim8edj: “Kina8a ni8idji Coda8innimag, acitc kakina Jerusalemikag ka tajikeieg! Ndotamok oo ke ikido8an acitc k8ag8e nisidotamok adi 8a ikidomagag oo8e ka 8i 8idamonagok. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Igi8e a8iagog ka8in ki8ack8ebisi8ag, ii ka inenimeg8a. Motci cagidasotibaiganea e kijeba8agag! ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Tiegodj, mi aja ijise nogom adi niganadjimo8inni Joel kagi ojibiigepan: ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Kije Manido ikido: 8adan oo ke iji8ebag apitc ani ponaki8ag. Mino Manidon niga minag kakina a8iagog. Kig8izisi8ag acitc kidanisi8ag kada tibadjimo8ag nidikido8ini. Kidockinigimi8ag kada ijinamog. Kikitci anicinabemi8ag kada inabadamog. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Teb8e ii apitc kakina ka anokitaoji8adj niga minag Mino Manidon, nabeg acitc ik8e8ag. Kakina dac kada tibadjimo8ag nidikido8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Niga ojitonan e kitci mamada8izimagagin kegonan icpimig 8ak8ikag acitc ooma akikag. Misk8i acitc ickode kada 8abadjigade8an acitc kada kitci packine. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kizis kada poni tcakasige. Tibikikizis kada miskozi, mi maia misk8i ke ijinagozidj. Mi ke iji8ebag ab8amaci odjitcisenig ka Tibendjigedj okijigom ka kitci apitendag8anig acitc ka kitci icpendag8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Midac a8iagigotc ke nd8e8emadjin ka Tibendjigendjin kidji pi nda 8idjiigodjin, aa a8iag kada ag8acimagani8i.’ Mi ka ikidodj niganadjimo8inni Joel.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Israel a8iagog! Ndotamok adi ke iji 8idamonagok! Kiga mikodamonom Jesos, Nazaret odenag kagi odjidj. Kije Manido 8e8enda kigi 8abadaigo8a kagi onabamadjin Jesosan, e abadjiadjin kidji mamada ijitcigendjin acitc ka mamakazinag8anigin kegoni kidji todamindjin. Aja dac kikikendana8a oo8e, egi 8abadameg adi ka todag ooma kidaki8akag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kije Manido, e nigani kikendamogobanen ke iji8ebanig, aja ki inendamogoban kidji pagidinamago8eg Jesosan. Kigi nisa8a, egi pagidineg8a a8iagog ega ka teb8eta8a8adjin Kije Manidon kidji acidak8a8a8adjin tcibaiatigokag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Kije Manido dac ogi abidjibaan. Ogi kibitinama8an adi eji kodagitonipanin apitc ka nibondjin. Ka8in mega pabajine ijinag8asiniban kidji taji midjiminigodj nibo8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Mamidonendamok David 8eckadj kagi ikidogobanen e mikomadjin Jesosan: ‘Nikikenima apanigotc e pec8abamag ka Tibendjigedj. Opimena ninikag te. Ka8in dac a8iag nigagi cagodjiigosi. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Midac 8edji mina8azian, acitc 8edji 8idamageian adi epitci modjigendaman. Nidan8ecimonan, 8inikag e iji apacenimo8an. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kin mega, Kije Manido, ka8in kiga iji pagidji8ebinijisi ka iji te8adj kagi nibo8adj. Ka8in kiga pagidinasi aa8e ka kitcit8a8izidj ka tibenimadj kidji taji nici8anadanig o8ia8 iima nibo8inikag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kikikendamonijinan adi ke ijaian pimadizi8in kidji mikaman. Apitc 8idjiojian niga kitci modjigendan.’ Mi ka ikidodj David 8eckadj.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Nidjiki8eg! Nikackiton 8e8enda kidji mikomag 8eckadj kikitci anicinabeminaban David. Ki nibo, ki naatcigadeni o8ia8 acitc o8ibabikinigan mi ooma kiabadj nogom e tag8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","31","David ogi nigani 8abadan adi ke iji8ebanig, midac ogi mikoman kidji abidjibandjin ini8e Kije Manidon kagi ikidonipanin kidji pidjinija8andjin apitc ka ikidodj: ‘Ka8in odji pagidji8ebinagani8isi ka nibondjin ka iji tendjin. Ka8in odji pagidinigadesini kidji taji nici8anadanig o8ia8 iima nibo8inikag.’ Aa mega David niganadjimo8inni8iban acitc okikendanaban Kije Manidon 8e8enda egi 8idamagodjin pejig odanike ojisan kidji pi abindjin ke8in kidji ogima8indjin taji ka iji ogima8ipan.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Kije Manidon ogi koki abidjibaigon aa Jesos ka taji mikomag acitc kakina nina8it nigi 8abamanan egi koki pimadizidj acitc nitibadjimomin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kije Manidon okitcinikinikag ki iji asagani8i kidji gi odji icpenimagani8idj, acitc Odadaman ogi minigon Mino Manidon, kagi inapanin kidji minigodjin. Jesos dac kakina nigi minigonan ini Mino Manidon. Midac 8edji oo nogom nodameg acitc 8abadameg. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ka8in dac 8in tibina8e David 8ak8ig ki icpikasi. Anic oo8e ki ikido: ‘Ka Tibendjigedj ogi inan ka Tibenimijindjin: Nikitcinikikag iji pi nda abin, ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","pinici kidji cagodjiag8a ka madjenimik8a, kinikag kidji iji tabasendizo8adj.’ ” ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Midac kakina kina8a Israel a8iagog, kida ketcinamendana8a oo8e kegon. Aa8e Jesos, tcibaiatigokag kagi iji acidak8a8eg, mi aa8e Kije Manidon kagi Tibendjigeigodjin acitc mi aa8e kagi ikidondjin kidji pidjinijaogodjin.” Mi ka ikidogobanen Pien e kagik8edj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Apitc igi8e a8iagog ka nodamo8adj ini anim8e8inan, ki kitci kackendamise8ag. Midac ogi k8ag8edjima8an Pienan, acitc kodagian ini8e Anodaganan: “Nidjiki8enanag! Adi ke todamag?” ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pien dac ogi nak8e8ajian: “An8endizok, acitc panima kakina pepejig e tacieg ki sigaadazo8eg Jesos Christ o8izon kidji abadjito8eg, kipatado8ini8an kidji gi kasiamago8eg. Kiga odisigo8a dac Mino Manido, Kije Manido oca8endjige8in. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Mi ii8e Kije Manido kagi ikidodj kidji minigo8eg. Kidabinodjijimi8an dac acitc oga minan, acitc kakina a8iagon 8asag ka tendjin, acitc kakina a8iagon ka Tibeniminak Kikije Manidominan ke nd8e8emadjin,” mi ka ikidodj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pien kiabadj kin8ej ki tatibadjimo, kidji gi teb8etamindjin. 8e8enda ogi 8idama8an: “Panima ki ag8acimigo8eg! Ka8in acidagimidizokegon igi8e ega ka teb8eta8a8adjin Jesosan. Kada pajacte8agani8i8ag,” ogi inan. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ii apitc, 8aiej nisin kitci midasomidana8ebanig (3000) a8iagog ka odapinamo8adj Pienan odanim8e8ini acitc ka sigaadazo8adj. Midac ke8ina8a ki acidagimagani8i8ag ka iji teb8etamindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Midac pijicig ki ma8adjiidi8agoban, kidji ndota8a8adjin Anodaganan e kikinoamago8adjin, kidji 8idjiidi8adj, ma8asag kidji 8isini8adj, acitc ma8asag kidji aiamie8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Anodaganag kitci mamada8izibanig acitc ka mamakazinag8anigin kegonan ogi todana8abanin. Kakina dac a8iagog ogi odji kitcit8a8ina8abanin Kije Manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kakina ka teb8etamo8adj ki ma8asag8akonidi8ag acitc ogi ma8asag8abadjitona8an odaimi8an. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ki ada8e8agoban ka tibendamo8adjin acitc odakimi8an, acitc conian ki madinamadi8ag, kakina a8iag kidji gi aiag adi eji nodesedj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Taso kajik ako ma8adjiidibanig Coda8inni kitci aiamiemigi8amikag. Kitci min8endamobanig kakina pepejig e taci8adj kidji mama8i 8isini8adj omigi8ami8akag, e tabasenimidizo8adj eji 8idji8idi8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Omanadjia8agoban Kije Manidon acitc kakina a8iagon omin8abamigo8agoban. Midac ka Tibendjigedj taso kajik ani8ag odasabanin 8ina8akag, a8iagon kagi ag8acimagani8indjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nigodin Pien acitc John ki ija8agoban Coda8inni kitci aiamiemigi8amikag, e nisotibaiganeanig e ick8a abitakijiganig. Mi apitc ako e aiamiani8anogobanen taso kajik kitci aiamiemigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Eji ick8ademi8anig kitci aiamiemigi8amikag “Ka min8acig ick8adem” ka ijinikadenig, tegoban ako iima pejig nabe e makizidj, mi ii ejinagozipan ka ako nta8igidj. Taso kajik iji8inagani8igoban iima kidji pagosendjigedj conian e nda aiamianani8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","8aa dac nabe ka makizidj ogi 8abaman Pienan acitc Johnan e pimi pidigendjin kitci aiamiemigi8amikag. Ogi k8ag8edjiman dac conian. ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pien acitc John ogi kijigabama8an. Pien dac ki ikido: “Kijigabamicinam.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Midac 8aa ka makizidj ogi kijigabaman. Ki inendam: “Niga minigo conia.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Tiegodj dac, Pienan ogi igon: “Ka8in nidaia8asi conia kidji mininan. Anic dac nidaian kodag kegon kidji mininan. Jesos Christ, Nazaret ka odjidj, odaian macka8izi8in kidji kigeigo8an. Midac iji pazig8in, pimosen, kidinin!” ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Midac Pien ogi sagindjinan okitcinikini inekena, acitc ogi pazig8idjibinan. Teci8agigotc 8aa ka makizidj nabe ozidan acitc okadan ki kigeni8an. ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Teci8ag ki pazig8idjise acitc ki pabamose. Midac ogi pidige8idji8an Pienan acitc Johnan kitci aiamiemigi8amikag. Meg8adj e pimosedj acitc e aicpig8ackonidj epitci sa min8endag, ogi icpeniman Kije Manidon. ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Kakina a8iagog kitci aiamiemigi8amikag ka te8agobanen ogi nisida8ina8a8an ini naben, egi 8abama8adjin ick8ademig kitci aiamiemigi8amikag e taji pagosenimondjin conian. Ogi 8abama8an dac e pimosendjin acitc e icpenimandjin Kije Manidon. Midac ogi kitci mamakadendana8a egi kigeagani8indjin ini ka makizindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","8aa dac nabe ka8in ododji pagidinasin Pienan acitc Johnan. Ki ija8ag 8edi pidigesag kagi ojitcigadegobanen Sanamo (Salomon) odji pidigamig kitci aiamiemigi8amikag. Kakina a8iagog ki ipaidi8ag iima, kiabadj e kitci mamakadendamo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Apitc Pien ka 8abamadjin kakina a8iagon, ogi inan: “Israel a8iagog! Adi 8edji kitci mamakadendameg? Adi 8edji kitci kijigabamijiag? Kidinendana8a na mi epitci macka8iziag kek8an mi epitci k8aiakoziag 8edji ki kackito8ag kidji pimoseagidj 8aa nabe? Mi aa8e Kije Manido kagi todag! ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","8eckadj okitci icpenimigobanin Abanaaman (Abraham), Aisikan (Isaac) acitc Tcekapan (Jacob), acitc mama8 kakina 8eckadj kikitci anicinabeminabanig. Nogom dac ogi minan icpendagozi8ini Jesosan, ka anokitagodjin. Kina8a dac, kigi pagidina8a Jesos kidji nisagani8idj. Pilat dac ka8in o8i nisasi8abanin, o8i pagidinabanin. Ka8in dac kidodji nda8enimasi8a8a. ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ki kitci paiekideegoban acitc ka8in 8ikad ki odji patadisigoban. Kina8a dac kigi ana8enima8a. Kigi k8ag8edjima8a dac Pilat meckodj kidji pagidinadjin pejig naben egi nici8endjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Midac kigi nisa8a aa8e ka migi8edj pimadizi8ini. Kije Manido dac 8in ogi abidjibaan, nigi 8abadananan dac ii acitc nitibadjimomin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jesos omacka8izi8in, mi ii kagi kigeigodj aa nabe. Niteb8etananan Jesos omacka8izi8in, mi 8edji ki iji8ebanig. Ki8abama8a 8aa nabe acitc kikenima8a, acitc kakina kigi 8abadana8a adi ka ijiseg! Egi teb8etamag Jesos e kackitodj kidji kigeadjin, mi 8edji ki iji8ebanig!” ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ni8idji8aganag! Nikikendan egi niseg Jesos ega e nisidotamegoban adi enakamigiziegoban. Ka8in 8a8adj igi8e ka niganizi8adj kina8akag ododji nisidotasina8agoban. ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kije Manido ki ikido kidji iji8ebanig oo8e. Ogi anonabanin oniganadjimo8inniman kidji tibadjimondjin ini a8ian kagi ikidogobanen kidji pidjinija8agobanen kidji nanekadjiagani8indjin acitc kidji nibondjin. Midac Kije Manido ka iji onendagiban ki iji8ebani. ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","An8endizok dac, acitc koki nazikaok Kije Manido, kidji gi kasiigadegin kipatado8ini8an. ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Kicpin ii todameg, ka Tibendjigedj kiga minigo8a kidji an8ebieg kidei8akag, acitc oga pidjinija8adjin Jesosan, mi ini8e kagi ikidogobanen kidji pidjinija8agobanen, kagi onabamadjin kidji pi nda 8idokago8eg. ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nogom sa 8in, inendagozi Jesos 8ak8ig kidji tedj, pinici kakina kegoni kidji ocki madjitamaganig. Mi ii Kije Manido kagi iji tibadjimodj, kidji todag kakina kegoni kidji ocki madjitamaganig, okitcit8a niganadjimo8inniman e anonadjin kidji tibadjimondjin aja 8eckadj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mois ki ikidogoban: ‘Ka Tibendjigedj Kikije Manidomi8a kiga ijinijaamago8a niganadjimo8innin, tabickotc nin kagi pidjinijaojidj. Kina8a ka inakanezieg kada inakanezi. Midac panima ki ndota8eg adi ke ikidodj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kicpin a8iag ega ndota8adjin ini niganadjimo8innin, ka8in kada acidagimagani8isi Kije Manidon odanicinabeminikag, acitc kada nici8anadjio.’ Mi ka ikidodj Mois. ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Kakina niganadjimo8innig, Samian (Samuel) acitc kodagiag nage kagi minagani8i8adj kidji niganadjimo8adj, ke8ina8a ki tibadjimo8ag oo nogom ka taji iji8ebanig. ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","8eckadj Kije Manido ogi 8idama8an oniganadjimo8inniman adi ke todag. Kina8a odji ii kagi 8idamagedj. 8eckadj Kije Manido ogi ojiton nakomo8ini mama8 8eckadj kikitci anicinabemi8abanig, e inadjin Abanaaman (Abraham): ‘Kakina niga ca8enimag ooma akig, kakinagotc adi enakanezi8adj a8iagog, e abadjiag pejig kidanike ojis,’ ogi inan. Kina8a odji ii nakomo8in. ");
INSERT INTO alqALGNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kije Manido dac ogi onabaman Odanodaganan acitc kina8a nitam kigi pidjinijaamago8a, e 8i ca8enimigo8eg, e 8i odji k8ekigaba8iigo8eg kakina ka tacieg kimadji inakamigizi8ini8a ka iji pimoseieg.” Mi ka kagik8edj Pien. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Meg8adj Pien acitc John e taji kagik8e8agobanen, ogi pi odisigo8an nandam Coda8inni aiamie ogiman, acitc ini naben ka kackakanandjin a8iagon ka kana8endamindjin kitci aiamiemigi8amini, acitc nandam Coda8innin ka iji ma8asag8akonidindjin ega ka teb8etamindjin abidjiba8ini, “Sadose8innig” (Sadducéens) ka ijinikanagani8indjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ki kitci kiji8azi8ag. Pien mega acitc John okikinoama8a8abanin a8iagon, acitc paba tibadjimobanig Jesosan egi abidjibandjin, ikidomaganiban dac ii ke8ina8a kidji abidjiba8adj kakina kagi nibo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ogi na8adina8an dac acitc ogi kiba8a8an pinici 8eabanig, aja mega kitci ozaminagocinoban. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mane igi8e ka noda8a8adjin Pienan acitc Johnan e kagik8endjin ogi teb8etana8a. Aja nanan kitci midasomidana (5000) ani taci8agoban nabeg kagi teb8etamo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","8iabanig, Coda8innig kitci aiamie ogimag, acitc ka niganizi8adj acitc ka kikinoamage8adj ki ma8adjiidi8ag Jerusalemikag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ke8ina8a iima te8agoban Annas (Anne), 8in Coda8inni aiamie ogima ma8adji ka niganizidj, acitc Kaiapas (Caïphe), acitc kodag John acitc Aleksanden (Alexandre), acitc kakina Annas otcina8emaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nigan 8ina8akag ki iji8inagani8i8an Pienan acitc Johnan. Ogi k8ag8edjima8an dac: “A8enen kagi pagidinigo8eg kidji gi todameg ii? Adi 8edjimagag kimacka8izi8ini8a?” ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pien ogi kigickagon Mino Manidon, midac ogi nak8e8ajian: “Kidanamikonom kina8a kitci aiamie ogimag acitc ka niganizieg Israel a8iagokag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Nogom ooma nitidemin egi mino toda8agidj a8iag ka makizidj, e k8ag8edjimigo8ag dac adi 8edji ki kigeagani8idj aa. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ninada8endananan kidji kikendameg, kina8a kakina acitc kakina Israel a8iagog, Jesos Christ, Nazaret ka odjidj, 8in omacka8izi8in 8edji ki kackitodj kidji pimosedj aa nabe ka makizipan. Jesos kigi nisa8a tcibaiatigokag, Kije Manido dac ogi abidjibaan. 8aa nabe makiziban, nogom dac Jesos omacka8izi8ini 8edji ki kackitodj kidji naniba8idj egi kigedj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesos mi 8aa ka mikomagani8idj Kije Manido Omazinaiganikag: ‘Asini kagi ana8enimeg kidji abadjiagani8idj kidji migi8amikani8ag, mi aa asini ma8adji ka ani kitci apitendagozidj,’ mi mezinadeg. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Jesos eta okackiton kidji ag8acimadjin a8ian. Ka8in tesi kodag a8iag ooma akig kagi minigodjin Kije Manidon kidji ag8aciminak,” ki ikido Pien. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Coda8inni kitci aiamie onakonige8innig ogi 8abama8an Pienan acitc Johnan ega e kocimondjin kidji tibadjimondjin. Ogi kikenima8an ega teb8e e apitendagozindjin acitc ega mane egi kikinoamagozindjin. Midac ogi kitci mamakadenima8an. Midac ka odji mik8endamo8adj egi paba 8idji8a8anipanin Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ogi 8abama8an dac acitc ini naben kagi makizindjin e taji 8idjigaba8ita8agobanen Pienan acitc Johnan, aja egi kigeagani8idj. Ka8in dac ododji kackiasia8an kegoni kidji nak8e8ajia8adjin Pienan acitc Johnan. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ogi ina8an dac kidji sagaamindjin ka iji ma8adjiidinani8anig. Midac ka iji aiamiidi8adj kidji nda kikendamo8adj adi ke todamo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ki ikido8ag: “Adi ke toda8aiakonig ogo nabeg? Kakina aja a8iagog ooma Jerusalemikag okikendana8a egi mamada8izindjin. Ka8in dac kigagi ikidosimin ega e teb8emagag ii. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mi panima ki kitci kagikimaiakonig acitc ki k8ag8e segimaiakonig ega mina8adj kidji mikoma8adjin Jesosan, ega na8adj kidji ani teb8eta8agani8indjin,” ki ikido8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ogi ina8an dac Pienan acitc Johnan kidji koki pidigendjin ka iji ma8adjiidinani8anig. Ogi ina8an ega 8ikad mina8adj kidji mikomandjin Jesosan acitc ega kidji kikinoamagendjin adi Jesosan kagi iji kikinoamagenigobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","20","Midac Pien acitc John ogi nak8e8ajia8an: “Ka8in nigagi todasinanan ka iji nda8endameg. Mi panima ki mikomagidj Jesos, acitc adi kagi iji 8abadamag acitc kagi iji nodamag. Mi panima ki todamag Kije Manido ka iji nda8endag. Adi enendameg? Na8adj na apitendag8an kidji ndota8agani8idj Kije Manido konigotc kidji ndotago8eg?” ki ikido8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Coda8inni kitci aiamie onakonige8innig mina8adj ogi kitci kagikima8an Pienan acitc Johnan kidji poni mikomandjin Jesosan. Midac ka iji pagidina8adjin. Ok8ina8i toda8a8abanin kidji animia8adjin, kakina mega a8iagog ogi kitci icpenima8an Kije Manidon ii8e odji kagi iji8ebanig. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","8aa nabe ka makizipan nimidana (40) taso pibon8ezigoban a8acamej. Ki nag8ani dac Kije Manido odijitcige8in. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Apitc Pien acitc John ka pagidinagani8i8adj, ogi nda 8abama8an o8idji8agani8an. Ogi tibadjimota8a8an kakina Coda8inni kitci aiamie ogiman acitc ka kitci niganizindjin ka ikidondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Apitc ka nodamo8adj ii, mama8i ogi aiamita8a8an Kije Manidon e ikido8adj: “Tebendjigean! Kin kigi kijendanan 8ak8i, aki acitc kitcigami, acitc kakina kegonan iima ka tag8agin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kin kigi mina ke ikidodj kidanodagan David nikitci anicinabeminaban, egi iji minadj Mino Manidon. Midac oo8e kagi ojibiigedj David: ‘Adi 8edji kiji8azi8adj kakina enakanezi8adj a8iagog? Adi 8edji apanigotc kitci nanada8i todamo8adj kidji madjiseto8adjin kegonan? Anica dac eta ii! ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kitci ogimag ooma akikag ick8ata8ag kidji migazo8adj, acitc ka kitci niganizi8adj ma8adjiidi8ag, e 8i nak8ita8a8adjin ka Tibendjigendjin acitc ini a8ian kagi pidjinija8andjin.’ Mi kagi ikidodj David. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Tebendjigean! Teb8e mi ka ijiseg! Ooma Jerusalem odenakag, ki ma8asag8akonidi8ag Herod, Pontias Pilat (Ponce Pilate), Coda8innig acitc ega ka Coda8inni8i8adj, kakina e 8i nisa8agobanen Jesosan. Jesos, mi 8aa Kidanodagan ka kitcit8a8izidj, kagi onabamadj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Aja 8eckadj kin kigi onendan adi ke ijiseg, acitc ka iji macka8izian kigi ojiton kidji ijiseg. Eta dac ogi todana8a kagi iji nda8endaman. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Tebendjigean! Aja kinoda8ag e ikido8adj e 8i k8ag8e segimigo8ag. Nak8e8ajitaocinam nina8it ka anokitago8an. 8idokaocinam ega kidji kocimo8ag kidji tibadjimo8ag kidikido8in, tiegodj kidji sogideeiag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","8abadaicinam kimacka8izi8in, e kigead8a a8iagog acitc e mamada8izian acitc ka mamakazinag8agin kegonan e todamanin, kidji 8abadjigadeg adi epitci macka8izimaganig Jesos o8izon, 8in Kidanodagan ka kitcit8a8izidj.” Mi ka iji aiamie8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Apitc dac ka ick8a aiamie8adj, migi8amini taji ka iji ma8adjiidi8adj ki kitci ninigiseni. Kakina ogi kigickago8an Mino Manidon. Midac ki paba tibadjimo8ag Kije Manidon omin8adjimo8ini, ega aja e kocimo8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ii apitc, kakina ka teb8etamo8adj pejig8an ki inendamog acitc pejig8an ki iji mosa8endamog. Ka8in a8iag “nin ii nidaim” ikidosiban, misagotc mama8 odabadjitona8abanin kakina kegonan. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Anodaganag ki kitci minagani8i8ag macka8izi8ini kidji paba tibadjimo8adj egi abidjibandjin Jesosan ka Tibendjigendjin. Kakina ka teb8etamo8adj ogi kitci minigo8an Kije Manidon okitci ca8endjige8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Kakina ki tibise8ag kegonan. Igi8e ka omigi8ami8adj acitc ka odakimi8adj ki ada8e8ag. Conian dac ogi mina8an Anodaganan, kidji odji mina8adjin a8iagon ka nodesendjin kegoni. ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Pejig 8aa ka teb8etag, Josep ijinikazogoban. Mi 8aa pejig aiamie mikimo8inni, Sipinos (Chypre) aki kagi iji nta8igigobanen. Anodaganag ogi ijinikana8an Banabas, e ikidomagag dac ii “A8iag ka 8idjiadjin kodagian kidji sogideendjin.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Josep otibendanaban kitigan akini. Ki ada8e odaki, midac ka iji pinadjin oconiaman, e minadjin Anodaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pejig dac nabe Ananias ijinikazogoban, odik8eman dac Sapina (Sapphira) ijinikazobanin. Ki ada8e8ag odaki8a. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananias dac pagi conian ogi odji kimodji kana8eniman, e kikenimigodjin odik8eman. Ogi a8i minagoban ka ickosendjin conian Anodaganan acitc ogi inan: “8adan aa kakina inigik ka ijisedj conia.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pien dac ogi inan: “Ananias! Adi 8edji ki pagidinadj madji manido kidji kigickag kideini? Kigi kagina8ickima Mino Manido, e kana8enimadj pagi conia apitc ka ick8a ada8ean kidaki. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ab8amaci ada8eaban, kidaki kitibendanaban. Misa8adj ka ick8a ada8ean, kidagi abadjia conia adigotc 8a inabadjiadiban. Adi dac 8edji ki inendaman ii kidji todaman? Kigi kagina8ickima Kije Manido, ka8in 8in a8iagog!” ogi inan. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Apitc Ananias ka nodag ii, mi ka iji pagicig, acitc ki nibo. Ockina8eg ki pi pidige8ag, ogi 8ik8eiginana8a o8ia8ini, ogi sagidji8idona8a, midac ka iji nda naato8adj. Apitc kakina kodagiag a8iagog ka nodage8adj ii, ki kitci segizi8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Apitc nisotibaigan 8aiej ka ick8a iji8ebanig ii, okokomiman ki pi pidige8an. Ka8in maci okikendasinagoban adi ka iji8ebizinigobanen ocomisiman. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pien ogi k8ag8edjiman: “8idamaocin, mi na ii eta inigik ka inada8eieg kidaki8a?” Sapinan dac ogi nak8e8ajiigon: “Ee, mi ii eta inigik.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pien ogi inan: “Adi 8edji kin acitc kicomisim ki onendameg kidji nanada8i toda8eg Mino Manido, e 8i kikendameg adi ke inakamigizidj? Ndotan! Igi nabeg ka naato8adj kicomisiman o8ia8ini ick8ademikag te8ag! Kekin kiga sagidji8inigog.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Midac apan teci8agigotc Sapina ka iji pagicig nigan Pienikag, acitc ki nibo. Ockina8eg ki pi pidige8ag. Ogi 8abama8an egi nibondjin. Ogi sagidji8ina8an dac, ogi naatona8a o8ia8ini opimena ocomisimikag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kakina dac ka teb8etamo8adj acitc kakina kodagiag ka nodage8adj ki kitci segizi8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Anodaganag mane mamada8izi8ini ogi iji kackitona8a acitc ka mamakazinag8anigin kegonan, e 8abamigo8adjin a8iagon. Kakina ka teb8etamo8adj ma8asag ma8adjiidi8agoban ako, 8edi pidigesag kagi ojitcigadegobanen Sanamo (Salomon) odji pidigamig kitci aiamiemigi8amikag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kodagian a8iagon cag8enimobanin kidji 8idjiogo8adjin, anic dac ki kitci inenimagani8ibanig. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Misa8adj dac, eckam ani mane8agoban nabeg acitc ik8e8ag e ani teb8eta8a8adjin ka Tibendjigendjin. Midac ke8ina8a ki iji acidagimagani8i8agoban ka iji teb8etamindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ki pinagani8ibanig dac mikanakag a8iagog ka akozi8adj. Nibe8inikag acitc apicimonikag iji asagani8ibanig, iaga kidji gi pimi nigeateckago8adjin Pienan apitc odji pimosenigobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kitci mane a8iagog ijabanig 8edi Jerusalem odenakag, kodagian odenajican ka peconag8ani8agobanen ka odose8adj. Odiji8ina8abanin ka akozindjin acitc ini8e madji manidon ka kigickagondjin, midac kakina ki kigebanig. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Coda8inni aiamie ogima ma8adji ka niganizidj acitc kakina o8idji8aganan ogi kitci odenima8agoban Anodaganan, kegoni dac ogi onendana8a kidji todamo8adj. Coda8inni8ibanin ini8e o8idji8aganan, Sadose8innig e iji acidagimagani8indjin, ega ka teb8etamindjin abidjiba8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Midac ka iji takona8adjin Anodaganan acitc ki iji acidji kiba8agani8i8agoban mama8 kodagiag takoniganag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Anic dac meg8a tibik, ka Tibendjigedj odajeniman ogi cenamini ick8ademini kibaodimigi8amikag. Ogi 8abadaan dac adi ke odji sagaamindjin. Midac ka iji inadjin: ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Madjaok, nda pidigeok kitci aiamiemigi8amikag. 8idamaokog kakina a8iagog adi ejinag8anig oo ocki pimadizi8ini.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Mi iidi ka todamo8adj. 8ibadj e kijeba8acinig ki ija8ag kitci aiamiemigi8amikag, midac ka iji madji kagik8e8adj. Coda8inni aiamie ogima ma8adji ka niganizidj acitc o8idji8aganan ogi nd8e8ema8an Coda8innin ka apitendagozindjin acitc kakina Coda8inni kitci aiamie onakonige8innin. Ogi ijinija8an dac nandam naben kibaodimigi8amikag kidji nadji8inagani8indjin Anodaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Apitc igi nabeg ka oditamo8adj kibaodimigi8amini, ka8in ododji mika8asi8a8an Anodaganan. Midac ka iji ki8e8adj kidji nda 8idama8a8adjin Coda8innin ka niganizindjin ii. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ki ikido8ag: “Kibaodimigi8am kidabikaigade, acitc ka nagadjito8adj kibaodimigi8amini taji naniba8ibanig ick8ademikag. Apitc dac ka cenamag ick8adem, pijicig8ate kibaodimigi8am!” ki ikido8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Aa8e ka kackakanadjin a8iagon ka kana8endamindjin kitci aiamiemigi8amini, acitc Coda8innig kitci aiamie ogimag, apitc ka nodage8adj ii, ki inendamo8agoban: “Aniga dac apan ka ija8ag8en igi Anodaganag?” ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Midac pejig a8ian ogi pi 8idamago8an: “Ndotamok! Igi8e nabeg ka takonagani8i8apan, aja te8ag kitci aiamiemigi8amikag e kikinoama8a8adjin a8iagon!” ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Midac aa ka kackakanadjin a8iagon ka kana8endamindjin kitci aiamiemigi8amini acitc ocimaganiciman ki sagaamog. Ogi pi ki8e8ina8an dac Anodaganan. Ka8in dac ododji madji toda8asi8a8an apitc ka pi ki8e8ina8adjin, e kosa8adjin a8iagon kidji pim8asinaigo8adjin kidji nisigo8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Iji8inagani8i8agoban Anodaganag taji ka iji ma8adjiidinipanin Coda8inni kitci aiamie onakonige8innin. Aiamie ogima dac ma8adji ka niganizidj ogi 8idama8an: ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Kitci 8e8enda kigi 8idamagona8aban ega mina8adj kidji mikomeg aa Jesos e kikinoamageieg. Midac misa8adj mizi8e Jerusalem odenakag ka iji paba kikinoamageieg. Mi acitc kidikidom nina8it ii nidido8inan kagi nisigodj!” ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pien dac acitc kodagiag Anodaganag ogi nak8e8ajia8an: “Panima ki ndota8agidj Kije Manido, ka8in 8in a8iagog. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Kigi nisa8a Jesos, egi acidak8a8eg tcibaiatigokag. Anic dac Kije Manido ogi abidjibaan Jesosan ka ick8a niseg. Mi aa8e Kije Manido ka manadjia8agobanen 8eckadj kikitci anicinabeminabanig. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kije Manido ogi minan kidji kitci icpendagozindjin ini Jesosan, e asadjin kidji abindjin okitcinikikag kidji ogima8indjin acitc kidji ag8acimandjin kakina a8iagon, kidji odji minandjin Israel a8iagon kidji gi an8endizondjin acitc kidji gi kasiama8andjin opatado8ini8an. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nina8it dac nitibadjimomin adi kagi iji 8abadamag. Midac ke8in Mino Manido eji tibadjimodj e teb8emaganigin ini kegonan, 8in Kije Manido kagi ca8enimadjin ini8e ka naitagodjin,” ki ikido8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Apitc kitci aiamie onakonige8innig egi nodamo8adj ii, ki kitci kiji8azi8ag acitc ki onendamog kidji nisa8adjin Anodaganan. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pejig dac ii e taci8adj, Gamaliel ijinikazogoban. Acidagimagani8igoban iima Coda8innig ka nagadjito8agobanen inakonige8inan. Ki kikinoamage Coda8inni Inakonige8inan acitc kitci apitendagozigoban. Aa dac nabe ki odji pazig8i kidji anim8edj ka iji ma8adjiidinani8anig acitc ki k8ag8ed8e kidji sagidji8inagani8indjin Anodaganan taji ka iji ma8adjiidinani8anig. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Midac ka inadjin ini8e ka ma8adjiidindjin: “Kina8a Israel a8iagog! Ki8idamonom kidji iag8amig adi ke toda8eg8a igi a8iagog! ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ketcinadj kimik8endana8adok apitc ka tag8icigiban aa nabe Tiodas (Theudas) ka ijinikazogobanen. Ki ikidoban e kitci apitendagozidj acitc nio midasomidana (400) naben ogi nosoneogobanin. Misa8adj dac, ki nisagani8iban, midac kakina ka nosoneogopanin pepakan ki nenicikebaidi8an. Ki poniseni dac odijitcige8in. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nage dac, kodag nabe Codas (Judas) ka ijinikazogobanen, Galilee aki odjigoban apitc kagi agimagani8i8agobanen a8iagog. Mane a8iagon ke8in oteb8eta8agogoban. Midac ki nisagani8iban ke8in, acitc dac ka teb8etagodjin ki nenicikebaidi8an. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nogom dac ki8idamonom ega kidji pabiziskenimeg8a igi nabeg. Kicpin odinendamo8ini8a konigotc odijitcige8ini8a a8iagokag 8edjimagani8ag8en, ka8in kada abadasini8an. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kicpin dac teb8e Kije Manidokag 8edjimagani8ag8en, ka8in kiga kackitosina8a kidji odjieg8a. Iag8amig ega kidji nak8ita8eg Kije Manido!” Coda8inni kitci aiamie onakonige8innig ogi teb8eta8a8an Gamalielan kagi ikidondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ogi nd8e8ema8an dac mina8adj ini Anodaganan, acitc ki anoki8ag kidji papajacte8agani8indjin. Midac ka iji ina8adjin ega mina8adj kidji mikomandjin Jesosan, midac ka iji pagidina8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Igi Anodaganag ki sagaamog ka iji ma8adjiidinani8anig. Ki kitci min8endamog dac, tibise Kije Manidon egi apitenimigo8adjin kidji kodagito8adj Jesosan o8izoni odji. ");
INSERT INTO alqALGNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ka8in ki poni kikinoamagesi8ag Anodaganag. Taso kajik ki ija8ag kitci aiamiemigi8amikag acitc a8iagon omigi8aminikag e paba tibadjimo8adj min8adjimo8ini, e mikoma8adjin Jesosan, Kije Manidon kagi ikidonipanin kidji pidjinijaogodjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kegapitc dac, ki ani kitci mane8agoban ka teb8eta8a8adjin Jesosan. Ii dac apitc, Coda8innig Kanek (Grec) ka ijigij8e8adj ki madji animizi8ag, e ina8adjin Coda8innin Ebaro (Hébreux) ka ijigij8endjin: “Apitc ako migi8ani8ag taso kajik acamigo8izi8in, 8anikanagani8i8ag ka pejigo8adj ik8e8ag nina8itinakag,” ki ikido8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ka midatcin acitc niji8adj dac Anodaganag ogi nd8e8ema8an kakina kagi teb8etamindjin, ma8asag kidji ma8adjiidi8adj. Ogi ina8an dac: “Ka8in ijinag8asinon kidji iji ponito8ag e kagik8eiag kidji gi madinamageiagiban midjim. ");
INSERT INTO alqALGNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nidjiki8enanag! Nanada 8abamikog dac nij8atcin nabeg e kitci inenimagani8i8adj, Mino Manidon ka kigickago8adjin acitc ka kitci kagita8endagozi8adj. 8ina8a dac oga mikidana8a ii. ");
INSERT INTO alqALGNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nina8it dac niga tebapitcimin kidji aiamieiag acitc kidji kagik8eiag Kije Manido odikido8in.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kakina dac ki nakomobanig kagi iji ikidonani8anig. Ki onabamagani8i dac Stepan (Étienne), e kitci teb8etag acitc e kigickagodjin Mino Manidon. Ki onabamagani8i8ag acitc Pilip (Philippe), Panikon (Prochore), Nikanon (Nicanor), Timon (Timon), Parmenas acitc Nikolas, 8in Antiok odenag ka odjidj kagi adjitodj odaiamie8in kidji gi Coda8inni8idj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Anodaganikag ki iji8inagani8i8ag igi8e kagi onabamagani8i8agobanen. Anodaganag dac ki aiamie8ag 8ina8a odji, acitc ogi samina8an. ");
INSERT INTO alqALGNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Eckam dac a8iagog ogi ani teb8etana8a Kije Manidon odikido8ini. Eckam dac ki ani kitci mane8ag ka teb8etamo8adj Jerusalem odenakag. Kitci mane Coda8inni aiamie ogimag ke8ina8a ogi ani teb8eta8a8agoban Jesosan. ");
INSERT INTO alqALGNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stepan ogi kitci ca8enimigon Kije Manidon. Ogi minigon macka8izi8ini kidji mamada8izidj acitc ka mamakadendag8anigin kegonan kidji todagin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nandam dac Coda8innig ka8in ododji 8i nda8enimasi8a8an Stepanan. Pejig Coda8inni aiamiemigi8amini iji tibendagozi8agoban, “8eckadj ka tibenimagani8i8agobanen anokitage8innig aiamiemigi8am,” mi e ijinikadenigobanen. Igi8e dac Coda8innig Sinen (Cyrène) odena acitc Aleksandania (Alexandrie) odena odji8agoban. Igi8e dac, acitc ke8ina8a kodagiag Coda8innig, Silisia (Cilicie) aki acitc Eja (Asie) aki ka odose8adj, kakina ki pija8ag kidji k8ag8e cagozoma8adjin Stepanan. ");
INSERT INTO alqALGNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mino Manidon dac ogi 8idjiigon Stepan kidji kitci kagita8edj. Ka8in dac Coda8innig ododji kackitosina8a kidji cagozoma8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Midac ogi kijika8a8an nandam naben kidji ikidondjin: “Nigi noda8anan aa nabe e manazomadjin Moisan acitc Kije Manidon.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Midac igi8e Coda8innig ka iji kackito8adj kidji 8ikobina8adjin kakina a8iagon, acitc Coda8innin ka niganizindjin, acitc Coda8inni kikinoamage8innin. Ogi pi takona8an Stepanan, midac ka iji iji8ina8adjin ka iji ma8adjiidindjin Coda8inni kitci aiamie onakonige8innin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ogi pidji8ina8an acitc nandam naben kidji kagina8ickindjin, e ikidondjin: “8aa nabe kabe omamanazodan kitci aiamiemigi8amini Kije Manidon ka tibendamindjin acitc dac Mois odinakonige8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nigi noda8anan e mikomadjin Jesosan, Nazaret ka odosendjin, e ikidodj kidji pigobidondjin oo kitci aiamiemigi8amini acitc kidji adjitondjin ijitcige8inan Mois kagi minigo8ak,” ki ikido8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kakina igi8e kitci aiamie onakonige8innig 8e8enda ogi kijigabama8an Stepanan. Midac maia ajenin ka ijig8endjin ka ani ijina8a8adjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Coda8inni aiamie ogima ma8adji ka niganizidj ogi inan Stepanan: “Teb8e na ii ka ikido8adj?” ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stepan dac ogi nak8e8ajian: “Nidjiki8eg acitc kitci anicinabeg, ndotaocik. Kije Manido ka kitci icpendagozidj ogi todan kidji 8abamigodjin Abanaaman (Abraham), 8eckadj kikitci anicinabeminabanin, meg8adj Mesopotamia (Mésopotamie) aki ka tajikenipanin, ab8amaci Aran (Haran) odenag ka nda tajikendjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Kije Manido dac ogi inan Abanaaman: ‘Nagadan kidaki acitc nagajik kitcina8emaganag. Ijan dac pakan akikag ke 8abadainan,’ ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Abanaam dac ogi nagadan Kaldea8innin (Chaldéens) odakimini, kidji nda tajikedj Aran odenag. Apitc Abanaam odadaman ka nibondjin, Kije Manido ogi ijinija8an Abanaaman ooma nogom ka iji tajikeieg. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ka8in dac Kije Manido ododji minasin Abanaaman oo akini, ka8in 8a8adj pejigotibaigan inigik. Misa8adj dac Kije Manido ogi inan kidji minadjin akini, 8in kidji tibendamindjin acitc odabinodjijimini, ega dac 8a8adj maci Abanaaman egi odabinodjijimigobanen. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Mi oo Kije Manido ka inadjin: ‘Kidabinodjijimag kada tajike8ag pakan akikag, kada pi8ide8i8ag. A8iagon dac iima oga nanekadjiigo8an. Nio midasomidana8e (400) pibon inigik oga tibenimigo8an ini a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nin dac niga tibakonag ini8e ke todago8adjin. Apitc ki ick8a iji8ebanig, kidabinodjijimag oga kackitona8a kidji nagadamo8adj ii akini. Midac ooma niga pi nda aiamitagog,’ ki ikido Kije Manido. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kije Manido dac nakomo8ini ogi minan Abanaaman, e inakonigedj ockina8esan panima kidji pak8ej8agani8indjin kidji 8abadjigadenig ii nakomo8ini egi odapinigadenig. Midac apitc Abanaam ka og8izisidj Aisikan (Isaac), ogi pak8ej8an apitc e nianeniogonaganig ka odjitcisenig. Aisik acitc ogi pak8ej8an og8izisan Tcekapan (Jacob). Midac ka toda8adjin Tcekap kakina og8izisan, 8ina8a ka midatcin acitc niji8agobanen 8eckadj kikitci anicinabeminabanig.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Kegapitc Tcekap og8izisan ogi odenima8an ocimeji8an, Josepan ka ijinikazondjin. Ki ada8e8ag dac kidji tibenimagani8indjin kidji anokitagendjin 8edi Idjip (Égypte) akikag. Kije Manidon dac ogi kana8enimigon. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ogi ijiigon ega kidji nigodidj Josep, misa8adj e mamida8endjigegobanen. Ogi minigon acitc kidji kagita8endag acitc kidji min8abamigodjin Panaon (Pharaon), Idjip aki kitci ogiman. Midac Panao ogi kitci ineniman ini Josepan, acitc ogi minan kidji nagadjitondjin Idjip akini acitc kakina ka tibendag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Kegapitc kakina Idjip aki acitc Kenan (Canaan) aki ki kitci pakadani8an. Ka8in kegon ki nta8igisinon, acitc ki kitci mamida8endjige8ag kakina a8iagog. Ka8in ododji aiasina8a ke midji8adj 8eckadj kikitci anicinabeminabanig. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Apitc dac Tcekap ka nodagedj egi naatcigadenig acitc e tag8anig midjimini 8edi Idjip akikag, mi 8edi nitam ka ijinija8adjin og8izisan, 8ina8a 8eckadj kikitci anicinabeminabanig. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Apitc mina8adj ejandjin, Josep ogi todan kidji nisida8inagodjin o8idjiki8en. Midac Panao ka odji kikenimadjin Josepan otcina8emagani. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Midac Josep ogi ijinija8an a8iagon kidji nadji8inandjin odadaman Tcekapan acitc kakina otcina8emaganan, kidji pi nda tajikendjin Idjip akikag. Nij8asomidana acitc nanan (75) taci8agoban igi a8iagog ka nadji8inagani8i8adj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tcekap dac teb8e ki ija Idjip akikag, mi iima ka iji nibo8adj Tcekap acitc 8eckadj kikitci anicinabeminabanig. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Apitc pepejig ka nibo8adj, ki iji8idjigadeni o8ia8i8a 8edi Kenan (Canaan) akikag, Cekam (Sichem) odenag. 8ibabikiniganikag dac ki iji atcigadeni8agoban. Abanaam dac kagi kicpinadogobanen ii 8ibabikinigani e minadjin conian Emoran (Hémor) og8izisini.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Stepan ki ikido kiabadj: “E ick8a mane pibonaganig, eckam ki ani kitci mane8ag Israel a8iagog, 8eckadj kikitci anicinabeminabanig, 8edi Idjip akikag. Ki ani peconag8anogoban kidji iji8ebanig kagi inagobanen Kije Manido Abanaaman. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kegapitc dac kodag a8iag kitci ogima8igoban Idjip akikag, ega egi nodagegobanen a8eneni8an ini Josepan. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ogi 8agackibinan 8eckadj kikitci anicinabeminabanin acitc ogi kodagian, e kadjinija8adjin kidji naganandjin otcidjicimini pinici kidji nibondjin ini tcidjican. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Midac ii apitc kagi nta8igigobanen Mois, e kitci minozidj. Nisokizis ki taji nta8igiagani8i onigiigon omigi8aminikag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Apitc dac ag8adjik ka asagani8idj, Panao odanisan ogi mika8an. Ogi nta8igian dac omigi8amikag, tabickotc pejig8an 8in og8izisan e inenimadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Igi8e dac Idjip akikag ka tajike8agobanen ogi kikinoama8a8an Moisan kakina eji kikendamo8agobanen. Ki kitci macka8izi dac Mois ka ikidodj acitc ka ijitadj.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Apitc Mois ka nimidana8e (40) pibon8ezidj, ki inendam kidji nda 8abamadjin otcina8emaganan, Israel a8iagon. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ogi 8abaman e taji manenimagani8indjin pejig Israeli8innin. Ogi 8idjian, midac ka iji nisadjin ini ka manenimi8endjin, Idjip ka odjindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mois ogi ineniman otcina8emaganan kidji nisidotamindjin Kije Manidon kagi pidjinijaogodjin kidji pi 8idjiadjin kidji gi ojimondjin adi eji kodagitonipanin. Ka8in dac ododji nisidotagosin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mina8adj e kijeba8aganig Mois ogi 8abaman nijin Israel a8iagon e migadindjin. Ogi k8ag8e 8idjian kidji koki mino 8idji8idindjin, e ikidodj: ‘Kidiji 8idjiki8edim! Adi dac 8edji migadieg?’ ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","8aa dac ka manenimadjin kodagian ogi ta8i8ebinan Moisan. Ogi inan dac: ‘A8enen kagi pagidinik kidji ogima8ian acitc kidji tibakonijiag? ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kiga nisijinan na tabickotc pejig8an onago kagi nisadj aa Idjip a8iag?’ ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Apitc Mois ka noda8adjin e ikidondjin, ki ojimo, e nagadag Idjip akini. Midian akikag ki inadjige ega eji kikenimagani8ipan. Meg8adj iima ka tajikedj, ki niji8an og8izisan.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Apitc nimidana (40) taso pibon ka tajikegobanen iima Midian akikag, nigodin pig8adakamigokag tegoban Mois, pecodj pik8adinakag Sinai ka ijinikadenig. Ogi odji 8abaman dac pejig ajenin ickodekag, kibisatigon e taji piskanenigin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ki kitci mamakazabamogoban, na8adj dac pecodj ki nda inabi. Mois dac ogi noda8an ka Tibendjigendjin e ikidondjin: ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nin Abanaam (Abraham), Aisik (Isaac) acitc Tcekap (Jacob) Okije Manidomi8an. 8eckadj kikitci anicinabemi8abanig nigi icpenimigobanig.’ Mois ki kitci ninigicka epitci segizidj, acitc ki kotadjigoban kidji inabidj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ka Tibendjigendjin dac ogi igon: ‘Kitakizinen! Kitcit8a8an mega aki taji ka iji naniba8ian. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nigi 8abadan adi eji nanekadjiagani8i8adj nidanicinabemag 8edi Idjip akikag. Nigi noda8ag e ma8i8adj. Nigi pija dac ooma akikag kidji pi nda ag8acimag8a. A8isa Mois, kiga koki ijinijaon 8edi Idjip akikag,’ ogi igon.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“8aa Mois mi 8aa pejig8an nabe ega ka 8i nda8enimigopanin Israel a8iagon, acitc ka igopanin: ‘A8enen ka pagidinik kidji ogima8ian acitc kidji tibakonijiag?’ Mi 8aa Mois Kije Manidon kagi pidjinijaogodjin kidji ogima8idj acitc kidji 8idjii8edj, e abadjiadjin ajenin kidji aiamiandjin Moisan. Mi ini ajenin kagi 8abamadjin Mois iima kibisatigokag ka taji piskanenipanin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mi 8aa Mois ka mamada8izidj acitc ka kitci mamakadendag8anigin kegonan ka todag kidji gi sagidji8inadjin Israel a8iagon Idjip akikag. E mamada8izidj, ogi 8idjian kidji ajo8agamendjin kitcigamini, ‘Misko kitcigami’ ka ijinikadenig, acitc kidji pimadjiondjin pig8adakamig nimidana (40) pibon inigik. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mi 8aa Mois ka inadjin Israel a8iagon oo8eni: ‘Kije Manido kiga ijinijaamago8a niganadjimo8innin, tabickotc nin kagi pidjinijaojidj. Kina8a ka inakanezieg kada inakanezi,’ ki ikido. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mi 8aa Mois ke8in ka tepan e ma8adjiidi8apan 8eckadj kikitci anicinabeminabanig pig8adakamigokag. Ajenin ogi aiamiigon 8edi Sinai pik8adinakag. Kije Manidon ogi minigon inakonige8inan, kagige ke tag8anigin, kidji minigo8ag.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ka8in dac o8i ndota8asi8a8abanin 8eckadj kikitci anicinabeminabanig Moisan. Ka8in ododji nda8enimasi8a8an, acitc 8i koki ki8ebanig Idjip akikag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nigodin ogi ina8an Eranan (Aaron), Moisan oseezini: ‘Ojitamaocinam manidokanag kidji gi nosone8agid8a! Aa Mois nigi pi sagidji8inigonan Idjip akikag, ka8in dac nikikendasinanan adi ka ijadj,’ ki ikido8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Midac ogi ojia8an manidokanan kidji icpenima8adjin, tabickotc mictozocan e ijinagozindjin. Midac ka iji nisa8adjin a8esizan kidji gi manadjia8adjin ini manidokanan. Ki kitci magoce8ag ka apitci kitci inenimidizo8adj egi ojia8adjin ini. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Midac Kije Manido ogi naganan, acitc ka8in ododji odjiasin kegapitc 8anagocan e icpenima8adjin. Mamidonendamok adi kagi ojibiigadenig niganadjimo8innig omazinaigani8akag: ‘Kije Manido ikido: Kina8a Israel a8iagog! Ka8in nin aa kagi iji icpenimeg 8edi pig8adakamig, apitc ka pagidinigeieg ca8endjige8inan acitc a8esizag kagi niseg8a, nimidana (40) pibon meg8adj ka tajikeieg 8edi. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kigi pabami8ina8a aa manidokan Molok (Moloch) onibagan kidji gi nda aiamieieg iima, acitc kigi pabami8ina8a o8anagociman aa8e manidokan Repan (Rephan) ka iji icpenimeg. Kigi icpenima8ag dac igi manidokanag kagi ojieg8a. Midac ii odji, niga todan kidji iji8inigo8eg na8adj 8asag apitc8in ka apisinag8ag Babilon (Babylone) odena, ki ikido Kije Manido.’ Mi ka ojibiigadeg.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Stepan kiabadj ki ikido: “Meg8adj e tajike8agobanen pig8adakamigokag 8eckadj kikitci anicinabeminabanig, opaba kana8endana8agoban ako kitcit8a nibagani ke odji nag8anig Kije Manidon e paba 8idjiogo8adjin tajigotc eji tajike8agobanen. Ii dac nibagani, Kije Manido ogi inabanin Moisan adi ke ijitondjin. Mois dac ogi ojitonagoban maiagotc adi kagi inagani8idj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Mina8adj dac, Tcaco8a (Josué) ogi iji8inan 8eckadj kikitci anicinabeminabanin kodagian ka inakanezindjin a8iagon odakini. Midac ka iji pidige8adj acitc Kije Manido ogi madjinija8an ini kodagian ka inakanezindjin a8iagon. Apitc ka pidige8adj iima ocki akikag, ogi madjidona8a ii kitcit8a nibagani, 8eckadj okitci anicinabemi8akag kagi odinamo8adj. Pinici kidji ani ogima8idj David ki abadan ii nibagan. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Kije Manidon okitci min8enimigogobanin aa David. Ogi k8ag8edjiman dac Kije Manidon kidji gi ojitodj kitci aiamiemigi8amini, taji kegi tendjin apanigotc, 8in Tcekapan (Jacob) kagi manadjiigondjin 8eckadj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Anic dac Sanamo (Salomon) 8aa ka ojitogobanen kitci aiamiemigi8amini.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ka8in dac ma8adji ka icpendagozidj Kije Manido iji tajikesi migi8amini naben kagi ojitondjin. Mi oo ka ikidogobanen pejig niganadjimo8inni: ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ka Tibendjigedj ikido: 8ak8ig nidiji tanabinan e ogima8ian. Akikag dac nitaji an8esidonan nizidan. Adi kegi ijinag8ag migi8am 8i ojitamaojian? Ataji ke iji an8ecimono8an? ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kana 8in nin kagi ijito8anin ini kakina kegonan? ikido ka Tibendjigedj.’ Mi mezinadeg.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stepan ki ikido kiabadj: “Kina8a Coda8innig ka niganizieg! Kikitci cibictig8anem! Kidana8enima8a Kije Manido kidei8akag. Ka8in kinadota8asi8a8a apitc anim8edj. Ka8in 8ikad ki8i ndota8asi8a8a Mino Manido e aiamiigo8eg. Mi gotc maia 8eckadj kikitci anicinabemi8abanig enendagozieg. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","8eckadj kikitci anicinabemi8abanig ogi k8ag8e nisa8an kakina niganadjimo8innin ka pi pimadizindjin. 8eckadj igi niganadjimo8innig ki nigani tibadjimo8agoban pejig a8ian kidji pijandjin e k8aiakozindjin. Aja dac ki tag8icin. Kina8a dac kigi mamijima8a acitc kigi nisa8a. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kije Manido kigi minigo8a inakonige8inan, ajenig kagi pido8adjin, 8e8enda kidji pimadizieg. Ka8in dac maci kinosoneasina8an.” Mi ka ikidodj Stepan. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Apitc Coda8inni kitci aiamie onakonige8innig ka noda8a8adjin Stepanan e ikidondjin ono anim8e8inan, ki kitci nickadizi8ag. Ki mamad8eabideta8ag epitci na8eigo8adjin Stepanan. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Stepan dac 8in okigickagogoban Mino Manidon. Ki inabi 8ak8ig acitc ogi 8abadan Kije Manidon odicpendagozi8ini. Ogi 8abaman Jesosan e naniba8indjin Kije Manidon okitcinikinikag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ki ikido dac: “Inabiok! Ni8abadan 8ak8ig e ceteg. Ni8abama Jesos, Ka pi Anicinabe8iidizodj, e naniba8idj Kije Manido okitcinikikag!” mi ka ikidodj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Apitc ka nodamo8adj ka ikidondjin, ki kitci pibagi8ag acitc ki kibitendizo8ag, midac kakina ka iji ipaidi8adj Stepanikag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ki sagidjidabi8ag ag8adjik odenakag, midac ka iji pabim8asinaa8adjin. Igi8e kagi kagina8icki8adj e inactaona8adjin Stepanan, ke8ina8a 8edi te8agoban. Ki kitcikonae8ag opizika8agani8an, midac pejig naben ka iji mina8adjin kidji kana8endamindjin. Saul ijinikazogoban aa nabe. ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Stepan ki aiamie meg8adj e taji pabim8asinaagani8idj: “Jesos ka Tibendjigean! Odapin nidjitcagoc!” ");
INSERT INTO alqALGNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ki nibak8i. Midac ki kitci pibagi: “Ka Tibendjigean! Kasiamaok ii ka iji patadi8adj.” Apitc Stepan ka ick8a ikidodj ii, mi ka iji nibodj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Saul dac ogi min8abadan e nisagani8indjin Stepanan. Nandam nabeg ka teb8eta8a8adjin Kije Manidon ogi naatona8a Stepanan o8ia8ini, e kitci ma8i8adj. Mi gotc ii pejig8an ka kijigag, Coda8innig ki madjita8ag kidji kitci nanekadjia8adjin ka teb8etamindjin 8edi Jerusalem odenag. Ogi kitci mamida8ia8an. Kakina ka teb8etamo8adj ki ojimo8ag, pepakan e ipai8e8adj Coda (Judée) acitc Samani (Samarie) akin. Mi eta Anodaganag ka8in odji ojimosi8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saul dac 8in ogi kitci k8ag8edjiton kidji 8anadjiadjin ka teb8etamindjin. Ki paba papidige migi8amikag, e sagidjidabanadjin naben acitc ik8e8an ka teb8etamindjin kidji takonadjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Adigotc ka paba ija8adj ka teb8etamo8adj, ki tibadjimo8ag min8adjimo8ini. ");
INSERT INTO alqALGNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilip, 8aa pejig ka nij8atci8apan ka onabamagani8i8apan, ki ija ka niganendag8anig odenani Samani akikag, acitc ki kagik8e 8edi e mikomadjin ini8e Kije Manidon kagi ikidondjin kidji pidjinija8andjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","A8iagog 8edi ka tajike8adj ogi noda8a8an Pilipan e kagik8endjin acitc ogi 8abama8an e mamada8izindjin. Kakina 8e8enda ogi ndota8a8an adi ekidondjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kitci mane a8iagog okigickago8agoban madji manidon. Pilip dac ogi kigean, e sagidjinija8adjin ini madji manidon. Ki kitci pibagi8an madji manidon apitc ka sagidjinija8agani8indjin. Mane ogi kigean Pilip ega ka mazikandjin acitc ka makizindjin. ");
INSERT INTO alqALGNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Midac kakina a8iagog iima odenakag ki kitci min8endamog. ");
INSERT INTO alqALGNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tegoban iima odenakag pejig mandoke8inni, Simo e ijinikazogobanen. Ab8amaci tag8icinindjin Pilipan, aa nabe ogi kitci mamakadenimigobanin ini8e Samani ka tajikendjin, e kackitodj kidji mamada8izidj. Ki ikidogoban e kitci apitendagozidj. ");
INSERT INTO alqALGNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Kakina a8iagog, ega teb8e ka kitci apitendagozi8adj acitc ma8adji ka kitci apitendagozi8adj, ogi ndota8a8an adi Simon ekidondjin. “Ka kitci macka8izidj” ijinikanagani8igoban, acitc ikidonani8anogoban: “Kije Manidon ogi minigon aa nabe kidji kitci macka8izidj.” ");
INSERT INTO alqALGNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Kin8ej aja kitci mamakadenimagani8igoban, 8e8enda dac a8iagog onadota8a8agoban. ");
INSERT INTO alqALGNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Apitc dac Pilip ka pi nda tibadjimodj Kije Manidon odogima8i8ini acitc Jesos Christan omacka8izi8ini, mane a8iagon ogi teb8etagon. Midac ka iji sigaadazo8adj, nabeg acitc ik8e8ag. ");
INSERT INTO alqALGNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ke8in Simo ogi teb8etan acitc ki sigaadazo. Simo ogi paba 8idji8an Pilipan. Ogi kitci mamakadendan dac e 8abamadjin Pilipan e mamada kackitondjin acitc ka mamakazinag8anigin kegonan e todamindjin. ");
INSERT INTO alqALGNT_vpl VALUES (