﻿USE sofia;
DROP TABLE IF EXISTS sofia.akp_vpl;
CREATE TABLE akp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES akp_vpl WRITE;
INSERT INTO akp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kristo gɔ nɖe Igara David ɔwa tɛtɛ, fiɛ David ɔ̃ wũ ɔɖe Abraham ɔwa ɔɣekparɛ i ngbe ne. ");
INSERT INTO akp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ɔɣe Isak, Isak ɔ̃ wũ ɔɣe Yakob gɔ loɣe Yuda ku ɔ̃ manyiibi. ");
INSERT INTO akp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda gu ɔ̃ ɔre Tamai ɔɣe Perez gu Zera, fiɛ Perez ɔɣe Hezron, Hezron ɔɣe Aram, ");
INSERT INTO akp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ɔ̃ wũ ɔɣe Aminadab, Aminadab ɔɣe Naheson, Naheson ɔɣe Salmon. ");
INSERT INTO akp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon gu ɔ̃ ɔre Rahab ɔɣe Boaz fiɛ Boaz gu ɔ̃ ɔre Rut ɔɣe Obed, Obed ɔɣe Isai, ");
INSERT INTO akp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isai ɔɣe Igara David. Ita i Igara David iso isɛ iabo ɔwi gɔ mamɔɛ̃ Israel mabi makɛlɛgu sisande ame i Babilonia karɔ̃ iso ne, mawa ma nto maba i ngbe lowe ne, David gu ɔrɔ̃go gɔ ɔmɔɛ̃ ɔfɔ i Urea kɔrɛ ɔɣe Salomo. ");
INSERT INTO akp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo ɔɣe Rehoboam, Rehoboam ɔ̃ wũ ɔɣe Abiya, Abiya ɔɣe Asa. ");
INSERT INTO akp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ɔɣe Yosafat, Yosafat ɔɣe Yoram, fiɛ Yoram ɔɣe Uzia. ");
INSERT INTO akp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia ɔɣe Yotam fiɛ Yotam ɔɣe Ahaz, Ahaz ɔɣe Hezekia, ");
INSERT INTO akp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","fiɛ Hezekia ɔɣe Manase gɔ loɣe Amon, Amon ɔɣe Yosia. ");
INSERT INTO akp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia ɔɣe Yekoniya gu ɔ̃ manyiibi ku ɔwi gɔ makɛlɛ sisande ame i Babilonia. ");
INSERT INTO akp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Gɔ mabɔrɛ i sisande ame i Babilonia maba kama ne, Yekoniya ɔɣe Sealtiel fiɛ Sealtiel ɔɣe Zerubabel. ");
INSERT INTO akp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabel ɔɣe Abihud, Abihud ɔ̃ wũ ɔɣe Elyakim fiɛ Elyakim ɔɣe Azur, ");
INSERT INTO akp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azur ɔɣe Zadok, Zadok ɔɣe Akim, Akim ɔɣe Elihud, ");
INSERT INTO akp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elihud ɔɣe Eleazar, Eleazar ɔɣe Matan, fiɛ Matan ɔɣe Yakob, ");
INSERT INTO akp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakob ɔɣe Yosef gɔ loyiri Maria, Maria gɔ loɣe Yesu gɔ marɔ sɔ Kristo. ");
INSERT INTO akp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ne ɔso ita i Abraham iso isɛ iabo David iso ne, mawa iweo-ina maɣe masiaidzo. Ita i David iso isɛ iabo ɔwi gɔ i Israel mabi ɔkɛlɛ sisande ame i Babilonia karɔ̃ iso ana ne, mawa iweo-ina maɣe masiaidzo. Ana ne, ita i ɔwi gɔ mase i sisande ame maba isɛ iabo ɔwi gɔ maɣe Kristo ne, mawa iweo-ina maɣe masiaidzo. ");
INSERT INTO akp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kumɛgɔ isɛ karɔ̃ fiɛ maɣe Yesu i ngbe ne. Makarɛ Maria matã Yosef, ɣɛɛ si ɔ̃akɔ wũ lɛ ɔ̃ ɔre ne, manya sɔ Maria ka ɔto kayiri iki i Siwarã Bielea ɔle ame. ");
INSERT INTO akp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yosef ɖe ɔturi bɔlɔlɔa i Ɣaa anɔ, ɣɛɛ gɔ ɔ̃ito ɔbie sɔ ɔ̃apia Maria kunuarɛ ɔso ne, ɔbie sɔ ɔ̃anyua ɔrɔ̃go i iwɛrɛ ame. ");
INSERT INTO akp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ɔwi gɔ ɔto ɔbara adzuni wagbe i ɔ̃ iti ame ne, Ɣaa kpabo ɔwɛ̃ ɔɖi so ɔte wũ i kurɛ ame ɔɣere wũ sɔ, “Yosef, Igara David ɔwa tɛtɛ, daanigã sɔ aakɔ fɔ ɔre Maria abɔ so i kɔrɛ, ala kayiri ga ɔto ne, Siwarã Bielea kɔrɛ kabɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ɔto ɔ̃aɣe ɔbirɛrɛĩ, tã wũ iyere sɔ Yesu, alasɔ ɔ̃ loaɖi ɔ̃ maturi ɔbɔrɛgu i ma akpi ame ne.” ");
INSERT INTO akp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nwagbe ɔɖuɖu ɔba sɔ si nnɛ i Ɣaa ɔɣɛ ɔkigu i ɔ̃ kanyaɖidze ɔwɛ̃ iso aaba i ne ame sɔ, ");
INSERT INTO akp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ɔbitɛ gɔ loiɣe ɔrɛrɛ̃ to ɔ̃ala kayiri ɔɣe ɔbi birɛrɛĩ. Maatã wũ iyere sɔ Imanuel,” gɔ karɔ̃ nɖe sɔ Ɣaa piagu bo. ");
INSERT INTO akp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ne ɔso gɔ Yosef ɔta ne, ɔyiri Maria lɛ kumɛgɔ i Ɣaa kpabo ɔɣere wũ awe. ");
INSERT INTO akp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ɣɛɛ ne, Yosef iirɛgu wũ gbɔgbɔɔgbɔ Maria ɔɣe ɔ̃ ɔbi ɖeakatɔ̃ gɔ nɖe ɔbi birɛrɛĩ, fiɛ Yosef ɔtã wũ iyere sɔ Yesu. ");
INSERT INTO akp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maɣe Yesu i Betlehem ɔmagɛ̃ ame i Yudea ku ɔwi gɔ ame i Herodes to ɔɖe sigara. Ɔwi gɔmɔ ame ne, manɔgbadze ma nɣe ara i awãmi iso ɔbɔrɛ i kuɣɛ̃kabɔrɛkɔ̃ maba Yerusalem Ɔmagɛ̃ ame. ");
INSERT INTO akp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Gɔ maba ne, makarɛ sɔ, “Lɛ maɣe ɔbi gɔ loaɖe ma Yudase igara? Bonya ɔ̃ iwãmi i kuɣɛ̃kabɔrɛkɔ̃ ɔso boba sɔ si boba boasumu wũ.” ");
INSERT INTO akp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Gɔ Igara Herodes ɔnɔ itɔ̃me nɛgbe ne, itidza ɔ̃ gu mma ɔɖuɖu mpia i Yerusalem gbaã. ");
INSERT INTO akp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ne ɔso ɔkpere masɔrɛdze makpakpa ɔɖuɖu gu mmara matedze ɔsirakanya ɔkarɛ ma sɔ, “Lɛ maaɣe Kristo?” ");
INSERT INTO akp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ne maɣere wũ sɔ, “Maɣɛ sɔ maaɣe wũ i Betlehem ɔmagɛ̃ ame i Yudea ala Ɣaa kanyaɖidze ɔwɛ̃ ɔtsɛrɛ ɔsɛ sɔ, ");
INSERT INTO akp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Fɔ Betlehem ne, maturi sɛ maɣɛ sɔ ɔmagɛ̃ kosoi aɖe i Yudea karɔ̃ iso. Ɣɛɛ iiɖe ngbɔ iɖe! Alasɔ fɔ ame i tɔ̃ɖedze siare gɔ loakɔ wũ kaɖe Israel aabɔrɛ.’ ” ");
INSERT INTO akp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ne kama ne, Herodes ɔkpere mafɔ ma lobɔrɛ i kuɣɛ̃kabɔrɛkɔ̃ ɔnɔwɛ̃ ɔkɛlɛgu kawɛrɛkɔ̃ sɔ si ɔtsue ɔwi gɔ tutuutu manya iwãmi nɛmɔ. ");
INSERT INTO akp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ɔɖi ma ɔri sɔ makɛlɛ Betlehem ku atɔ̃me wagbe sɔ, “Misɛ mianyɔnyɔ ɔbi gɔgbe kukaakɔ, si minya wũ ne, mikpese miba miaɣere me sɔ mme wũ loasɛ loasumu wũ.” ");
INSERT INTO akp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ne ɔso mafɔ magbe ɔrui maɣo ɔri. I ɔri ne, iwãmi nɛ manya i kuɣɛ̃kabɔrɛkɔ̃ mmɔ ɔledza ibɔrɛ. Gɔ manya ne ne, mana isoɣɔ gbaã. Iɖe ma katɔ̃ gbɔgbɔɔgbɔ isɛ iatui i ngbegɔ i ɔbi ɣɛtɛ rɛ. ");
INSERT INTO akp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Gɔ mabo i iyo ame fiɛ manya ɔbi gu ɔ̃ ɔnyi Maria ne, mapɛ agɛgɛ̃ masumu wũ. Gɔ mabusi ma akpo ne, maɖi karatã sɛɛ ga nɖe sikãrɛtɛa, korobo gu ɔlufui matã wũ. ");
INSERT INTO akp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ne kama gɔ makpese ne, Ɣaa ɔsɛ̃ ɔtã ma i kurɛ ame sɔ madaasɛ maaki i Herodes kɔrɛ. Ne ɔso maki ɔri mama marui makɛlɛ ma aɖe. ");
INSERT INTO akp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Gɔ mafɔ mamɔ ɔɔrui kama ne, Ɣaa kpabo ɔwɛ̃ ɔɖi so ɔte Yosef i kurɛ ame ɔɣere wũ sɔ, “Herodes to ɔ̃abie ɔri gɔ iso ɔ̃aki ɔ̃aɖoe ɔbi, ne ɔso ta si akɔ wũ gu ɔ̃ ɔnyi si ateregu ma akɛlɛgu Egipte. Miwe i mmɔ gbɔgbɔɔgbɔ loaɣere mi sɔ mikpese miba.” ");
INSERT INTO akp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kasɛ̃ gamɔ ame ame ne, Yosef ɔta ɔkɔ ɔbi gu ɔnyi marui matere makɛlɛ Egipte. ");
INSERT INTO akp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Mawe i mmɔ gbɔgbɔɔgbɔ Herodes ɔkpi. Iba ngbɔ sɔ si nnɛ i Ɣaa kanyaɖidze ɔwɛ̃ ɔtsɛrɛ ɔsɛ aaba i ne ame sɔ, “Ta Egipte lokpere wũ Ɔbi lobɔrɛgu.” ");
INSERT INTO akp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Gɔ Herodes ɔnya sɔ manɔgbadze ma lobɔrɛ i kuɣɛ̃kabɔrɛkɔ̃ mmɔ ɔsɔsɔla wũ ne, sikpã ɔmɔɛ̃ wũ gbaã. Ɔpia makpakpɛ̃dze sɔ maɖoe mabi birɛrɛĩ ɔɖuɖu ma i Betlehem gu simagɛ̃ dzɛ loki silɔ ame. Mma ɔɖuɖu loɔfɔ ita i akɔ anyɔ iba karɔ̃ si ikategu ɔwi gɔ i mmamɔ ɔɣɛ sɔ manya iwãmi kanya. ");
INSERT INTO akp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mabi iɖoe nɛgbe ɔba sɔ si nnɛ i Ɣaa kanyaɖidze Yeremia ɔɣɛ ɔsɛ aaba i ne ame sɔ, ");
INSERT INTO akp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Kulu kuwɛ̃ to i Rama. Kaku gu isoma kulu kuɖe! Rahel nto ɔbiɛ ɔ̃ mabi, fiɛ ɔ̃ito ɔbie sɔ malora wũ, ala sɔ ɔ̃ mabi ɔkpi.” ");
INSERT INTO akp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Gɔ Herodes ɔkpi ne, Ɣaa kpabo ɔwɛ̃ ɔɖi so ɔte Yosef i kurɛ ame i Egipte. ");
INSERT INTO akp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ɔɣere wũ sɔ, “Ta si akɔ ɔbi gu ɔnyi si mikɛlɛ Israel karɔ̃ iso alasɔ mma lobie sɔ maaɖoe ɔbi ɔɔkpi.” ");
INSERT INTO akp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ne ɔso Yosef ɔta ɔkɔ ɔbi gu ɔnyi marui makɛlɛ Israel karɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ɣɛɛ gɔ Yosef ɔnɔ sɔ Arkelao masɛra sigara i ɔ̃ ɔse kanya i Yudea ne, ɔnigã mmɔ ikɛlɛ, ne ɔso i kurɛ ame ne, Ɣaa ɔɣere wũ sɔ ɔkɛlɛ Galilea karɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ɔsɛ ɔ̃awe i ɔmagɛ̃ gɔ marɔ sɔ Nasaret ame sɔ itɔ̃me nɛ i Ɣaa kanyaɖidze ɔwɛ̃ ɔɣɛ ɔsɛ aba i ne ame sɔ, “Maakpere wũ sɔ ɔ Nasaretse,” aaba i ne ame. ");
INSERT INTO akp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ɔwi gɔmɔ ame ne, Ndupiedze Yohanes ɔba Yudea fafuĩ ame ɔba ɔ̃atsɛ Ɣaa itɔ̃me iɣɛ ");
INSERT INTO akp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","sɔ, “Mifiniki i mi situ ame ala Ɣaa sigara ɔɖewi ɔɔɣo.” ");
INSERT INTO akp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohanes gɔgbe nɖe ngɔ iso i Ɣaa Kanyaɖidze Yesaya ɔɣɛ ɔsɛ sɔ, “Ɔwɛ̃ to ɔla kulu teteree i fafuĩ ame sɔ, ‘Miledza ɔri mitã Bosate iba. Mibara ɔ̃ ɔri gɔ iso ɔ̃asɛ tɔrɔrɔ.’ ” ");
INSERT INTO akp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Awu wa i Yohanes ɔpia ne, kapuipɔngɔ siwɛrɛ̃ masu mawe ala, fiɛ ɔsu bɔi ɔko kafiami ɔtɔ so ɔsɔ. Maɣendu gu kugbadzedzei loɖe ɔ̃ aɖera. ");
INSERT INTO akp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Maturi ɔbɔrɛ i Yerusalem gu Yudea ɔɖuɖu gu Yordan ɔwore kama abuiti ɔɖuɖu ame maba ɔ̃ kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Gɔ maɖi ma akpi maɣɛ ne, Yohanes ɔpie ma Ɣaa ndu i Yordan ɔwore ame. ");
INSERT INTO akp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Gɔ Yohanes ɔnya ma Farisise gu ma Zadukise gbodzoo ma loba sɔ ɔpie ma Ɣaa ndu ne, ɔɣere ma sɔ, “Mi ma lonyanyarĩ lɛ maɣɛ! Midaasɔsɔla so iki i Ɣaa itupie ifɔ ame sɔ miawo ɔtere i Ɣaa sikpã dzɛ nto siba i kayiiso kanya! ");
INSERT INTO akp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mite i mi nsɛgbai ame sɔ miɔfiniki mibɔrɛ i mi akpi ame. ");
INSERT INTO akp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Midaabu sɔ gɔ Abraham mawa miɖe ɔso ne, Ɣaa iibakpadzɛ̃ mi kutsue. Nto loɣere mi sɔ Ɣaa to ɔ̃awo mawa ɔbara ɔɖi i ata wa nfere i ngbe ame ɔtã Abraham. ");
INSERT INTO akp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Minyɔ! Maɔkarã kaɣɛ i adziri iso koko sɔ maatu wã ta siɖu ame. Kudziri biara gɔ loisɛ kuɣɔ̃ abi sɛɛ ne, maaɖaɛ kɔ̃ mapɛyu matsuedza.” ");
INSERT INTO akp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Mme ne, ndu losu nto lopie mi si ite sɔ miɔfiniki mibɔrɛ i mi akpi ame. Ɣɛɛ ngɔ nsiai me i kama ɔto ɔba ne, Ɣaa Siwarã gu ɔtɔ ɔ̃asu ɔpie mi ndu. Ɔmɔ ɔɖo me sɔ loikote sɔ loaɖe ɔ̃ ɔɖabo kɔra. ");
INSERT INTO akp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ɔto ɔ̃ ifɛra nɛ ɔ̃afɛ ala simɔɣo ɔɖi i kamɔ ame. Ɔ̃asu aɖera ɔfere i kawu ame, ɣɛɛ simɔɣo ne, ɔ̃atsuedza sɛ̃ ku ɔtɔ gɔ loisɛ ɔnyi!” ");
INSERT INTO akp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ɔwi gɔmɔ ame ne, Yesu ɔbɔrɛ i Galilea ɔba Yohanes kɔrɛ i Yordan ɔkpokpo sɔ Yohanes si ɔpie wũ Ɣaa ndu. ");
INSERT INTO akp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ɣɛɛ gɔ Yohanes to ɔbie sɔ ɔfinikira ɔ̃ adzuni ɔso ne, ɔɣere wũ sɔ, “Mme ikote sɔ loaba fɔ kɔrɛ apie me Ɣaa ndu ne iiɖe fɔ loaba wũ kɔrɛ!” ");
INSERT INTO akp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ɣɛɛ Yesu ɔtã wũ mmuai sɔ, “Tã ise ngbɔ si boawo ira biara nɛ i Ɣaa ɔbie sɔ bobara ɔbara.” Ne Yohanes ɔnɔ karɔ̃ ne. ");
INSERT INTO akp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Gɔ ɔpie Yesu ndu ɔro fiɛ ɔto ɔbɔrɛ i ɔwore ame ne, kuɖokpo ɔbusi kutã wũ. Ɔnya Ɣaa Siwarã ɔso lɛ ilɔpɔ siba siasia wũ iso. ");
INSERT INTO akp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ne manɔ silɔ ɔbɔrɛ i kato siɣɛ sɔ, “Wũ Ɔbi gɔ loisɛ lopia kuɣɛ i ngbe ne, ɔbo me anɔ gbaã.” ");
INSERT INTO akp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Siwarã Bielea ɔkɔ Yesu sikɛlɛgu fafuĩ ame sɔ Tsirise si ɔsɛ ɔ̃ala wũ ɔnyɔ. ");
INSERT INTO akp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Gɔ ɔnyi kanya akpɛnɛ sina kasɛ̃ sina ne, kukã ɔkpɛ̃ wũ. ");
INSERT INTO akp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mmɔ i Tsirise ɔba ɔ̃ kɔrɛ ɔɣere wũ sɔ, “Si fɔ nɖe Ɣaa Ɔbi ne, ɣere ata wagbe sɔ akpese aɖera.” ");
INSERT INTO akp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ne Yesu ɔɣere wũ sɔ, “Matsɛrɛ mapia i Ɔko Sekelea ame sɔ, ‘Iiɖe aɖera ɔnɔwɛ̃ iso i ɔturi aasɛ ngbã, ɣɛɛ Ɣaa itɔ̃me atsue ikã ɔso bowũ.’ ” ");
INSERT INTO akp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tsirise ɔkɔ Yesu ɔkɛlɛgu Yerusalem, Ɔmagɛ̃ Sekelea ame, ma Yudase kasɔrɛkɔ̃ kakɔlɛkɔ̃ pelepele. ");
INSERT INTO akp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ne ɔɣere wũ sɔ, “Si Ɣaa Ɔbi aɖe ne, nyua so sɛ aawuĩ i karɔ̃. Alasɔ Ɔko Sekelea ɔɣɛ sɔ, ‘Ɣaa ɔɣɛ sɔ ɔ̃apia ɔ̃ makpabo mamɔɛ̃-ɔ i nrɔɔ̃ ame sɔ aibasu fɔ kukpa awuĩ i ita kuiwɛ̃ iso.’ ” ");
INSERT INTO akp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu ɔtã wũ mmuai sɔ, “Ɔko Sekelea ɔɣɛ ana sɔ, ‘Daala Bosate Ɣaa anyɔ.’ ” ");
INSERT INTO akp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tsirise ɔledza Yesu ikɔ ikɛlɛgu kube kɔlɛa kuwɛ̃ itititɛ̃. Ɔte wũ kayiiso sigarakuɖekɔ̃ ɔɖuɖu ku kɔ̃ sile. ");
INSERT INTO akp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ne ɔɣere Yesu sɔ, “Si aapɛ agɛgɛ̃ atã me asɔrɛ me ne, loasu ara wagbe ɔɖuɖu lotã-ɔ.” ");
INSERT INTO akp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ne Yesu ɔtã wũ mmuai sɔ, “Satana, rui me i kɔrɛ! Ɔko Sekelea ɔɣɛ sɔ, ‘Bosate Ɣaa ɔnɔwɛ̃ nɖe ngɔ lokote sɔ maapɛ agɛgɛ̃ matã masɔrɛ.’ ” ");
INSERT INTO akp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ne Tsirise ɔrui i Yesu kɔrɛ, fiɛ Ɣaa makpabo ɔba maabuai wũ ne. ");
INSERT INTO akp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Gɔ Yesu ɔnɔ sɔ maɔmɔɛ̃ Yohanes mapia i iyo ne, ɔrui ɔkɛlɛ Galilea. ");
INSERT INTO akp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ɔ̃iwe i Nasaret, ɣɛɛ ɔkɛlɛ Kapernaum, ɔmagɛ̃ gɔ nse i Galilea itubu kanya i Zebulon gu Naftali karɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ɔsɛ ɔ̃awe i mmɔ, ne ɔso nnɛ i Ɣaa Kanyaɖidze Yesaya ɔɣɛ ɔba i ne ame sɔ, ");
INSERT INTO akp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Zebulon gu Naftali maturi ma nsi i idududu ame i itubu ɔri iso i Yordan ɔkpokpo i Galilea ngbegɔ i maturi ma loiɖe ma Yudase si ne, maanya ikpawaĩ siare. Fiɛ mma nsi i karɔ̃ ga iso i kukpi to kuɖe sigara ne, ikpawaĩ aafiɛ ifere ma.” ");
INSERT INTO akp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ita i ɔwi gɔgbe ame ne, Yesu ɔtsɛ imomo ipɛ iɣɛ sɔ, “Mifiniki i mi situ ame ala Ɣaa sigara ɔɖewi ɔɔbore ɔbo.” ");
INSERT INTO akp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Gɔ Yesu to ɔkila i Galilea ibu kɔrɛ ne, ɔnya manyiibi inyɔ, Simon gɔ marɔ Petro gu ɔ̃ ɔnyiibi Andrea to mapia asabu ala makpɛɖidze maɖe. ");
INSERT INTO akp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu ɔɣere ma sɔ, “Miba miasiai me si loakpesera mi maturi maɖidze mitã Ɣaa.” ");
INSERT INTO akp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ɔluwɛ̃ ne, manyua ma asabu masɛ marui masiai wũ. ");
INSERT INTO akp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Gɔ ɔrui i mmɔ ɔsɛ kɛkɛĩ ne, ɔnya manyiibi inyɔ mama, Yakobo gu Yohanes. Ma gu ma ɔse Zebedeo si i ɔkolo ame mato maledza ma asabu fiɛ Yesu ɔkpere ma. ");
INSERT INTO akp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ɔluwɛ̃ marui manyua ɔkolo gu ma ɔse masɛ masiai wũ. ");
INSERT INTO akp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu ɔwe ɔki i Galilea abuiti ɔɖuɖu ame ɔto ɔte Ɣaa itɔ̃me i ma Yudase kusarɛkɔ̃, ɔɣɛ Sigarakaɖekɔ̃ iso Itɔ̃me Bielea, ɔsa mma ɔɖuɖu nto manyɛ sinyɛ agbãagbã. ");
INSERT INTO akp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ɔ̃ iso itɔ̃me ɔki ikã i Siria karɔ̃ ɔɖuɖu iso, ne ɔso maturi ɔsore mma ɔɖuɖu nto manyɛ sinyɛ agbãagbã, mma i so to sibo, mma i siwarã lalaa to siɖaa, mma nto manyɛ kakpebubu gu mma lofɛfɛ̃ marɛ ɔɖuɖu ne, Yesu ɔsa ma ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Maturi gbodzoo ɔsiai wũ. Ma mawɛ̃ ɔbɔrɛ i Galilea gu Simagɛ̃ Iweo gu Yerusalem gu Yudea gu nrɔ̃ mɛ mpia i Yordan ɔwore kama isɛ ame. ");
INSERT INTO akp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Gɔ Yesu ɔnya maturi gbodzoo ma nsiai wũ ne, ɔya ɔsɛ ɔ̃asɛ i kabemi iso fiɛ ɔ̃ marasuãdze ɔba maasɛ wũ i kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ne ɔte ma ara ɔɣɛ sɔ, ");
INSERT INTO akp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“So si siɣɔ mma nɣe sɔ mawɛrɛba maɖe i Ɣaa itsue ame. Alasɔ ma ɔkpɛ nɖe Ɣaa sigarakaɖekɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","So si siɣɔ mma nto mamararã so ala ma i Ɣaa aatui kɔrɔ̃ i kagbegbe ne. ");
INSERT INTO akp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","So si siɣɔ mma lobɔ so karɔ̃, alasɔ ma loaɖe kayiiso ara ne. ");
INSERT INTO akp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","So si siɣɔ mma anɔ lorɛtɛ i Ɣaa kuɖɔɛ ibara iso, ala Ɣaa to ɔ̃abara ma kuɖɔɛ ɔtã ma. ");
INSERT INTO akp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","So si siɣɔ mma nsɛ manyɔ maturi nnya, ala ma i Ɣaa aanyɔ nnya ne. ");
INSERT INTO akp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","So si siɣɔ mma situ ame lokpa, ala ma loanya Ɣaa ne. ");
INSERT INTO akp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","So si siɣɔ mma nsɛ maledza manyii ndɛ̃, ala ma i Ɣaa aakpere sɔ ɔ̃ mabi ne. ");
INSERT INTO akp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","So si siɣɔ mma kama i maturi sɛ mati ala Ɣaa kuɖɔɛ ibara ɔso, ala ma ɔkpɛ nɖe Ɣaa sigarakaɖekɔ̃ ne. ");
INSERT INTO akp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“So si siɣɔ mi si maturi to matia mi, mati mi kama maɣɛ ara nyanyarĩa wa nɖe mila i mi iso alasɔ miɖe wũ masiaidze ɔso. ");
INSERT INTO akp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","So si siɣɔ mi, mina isoɣɔ alasɔ Ɣaa to ɔ̃atã mi kuso siare i kato. Ngbɔ makpɛ̃gu Ɣaa kanyamaɖidze ma loɖe mi katɔ̃ ne. ");
INSERT INTO akp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mi nse lɛ mma mitã maturi ɔɖuɖu, ɣɛɛ si mma ɔyu me ɔmɛrɛ̃ ne, maisibawo ɔri kuwɛ̃ iso ɔki ɔpia me ɔmɛrɛ̃. Misiina kusia kukuwɛ̃ iɖo sɔ maasu me mawiri maturi ɔsɛ me iso. ");
INSERT INTO akp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mi nɖe ikpawaĩ mitã kayiiso ɔɖuɖu. Ɔmagɛ̃ gɔ matsue masia i kube iso ne, ɔ̃ibawo ɔwɛrɛ. ");
INSERT INTO akp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kuwɛ̃ iisɛ ɔtsue ɔkaniɛ ɔsu kapoi ɔfu iso, ɣɛɛ ɔ̃atara ɔsia i kakɔlɛkɔ̃ sɔ ɔ̃asa ɔtã ɔbiara. ");
INSERT INTO akp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ngbɔ ame i mi sikaniɛ si sisa sitã maturi sɔ maanya mi kurabarara sɛɛ fiɛ maale mi Ɔse gɔ i kato ne. ");
INSERT INTO akp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Loiba lotindza Mose mmara gu Ɣaa kanyamaɖidze ara ite ɖuɖuuɖu, ɣɛɛ loba sɔ si wã ibiara aba i ne ame. ");
INSERT INTO akp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Gbagbaã nto loɣere mi sɔ ayi kumɛgɔ i kato gu karɔ̃ se ne, mmara katotoi ɣee kakpoi kukawɛ̃ iibakpase kabɔrɛ gbɔgbɔɔgbɔ ibiara ɔba i ne ame. ");
INSERT INTO akp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ne ɔso ɔbiara gɔ loatu mmara kosoi tsɔra fiɛ ɔ̃ate mamama sɔ mabara ngbɔ ne, maakpere wũ ɔtsɔra i Ɣaa sigarakaɖekɔ̃. Ngbɔ ame i ɔbiara gɔ loabara i mmara mɛgbe iso fiɛ ɔ̃ate maturi mama sɔ mabara i me iso ne, maakpere wũ sɔ ɔsiare i Ɣaa sigarakaɖekɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ne ɔso nto loɣere mi sɔ miibawo Ɣaa sigarakaɖekɔ̃ ame ɔbo si mi Ɣaa kuɖɔɛ iso ibara iikɔlɛ iɖo mmara matedze gu ma Farisise ɔkpɛ. ");
INSERT INTO akp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ɔwiɔ ne, minɔ maɣɛ sɔ, ‘Daaɖoe ɔturi.’ Ngɔ loɖoe ɔturi ne, ɔkote ɔtã atɔ̃me iɣɛgu. ");
INSERT INTO akp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ɣɛɛ nto loɣere mi sɔ ngɔ lonagu ɔ̃ ɔnyii sikpã ne, ɔkote ɔtã atɔ̃me iɣɛgu. Ngɔ loaɣere ɔ̃ ɔnyiibi sɔ, ‘Ailɛ atã kuira’ ne, makpakpa aaɣɛgu wũ atɔ̃me. Fiɛ ngɔ loakpere ɔ̃ ɔnyiibi sɔ, ‘Bɔi aɖe’ ne, ɔkote ɔtã Ɣaa kutsue ikpadzɛ̃ itɔkpe ame ikɛlɛ. ");
INSERT INTO akp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ne ɔso si asu karatã ato abɔ Ɣaa isɔrɛkasege iso fiɛ anyigi i mmɔ sɔ irere pia i fɔ ɔnyii ɔtu ame i fɔ iso ne, ");
INSERT INTO akp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nyua fɔ karatã sɛ i isɔrɛkasegetɔ̃ si akpese akɛlɛ mi gu fɔ ɔnyii si misɛ miafere kanya ndu fiɛ aaba aasu fɔ karatã atã Ɣaa. ");
INSERT INTO akp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Si atsue sɔ fɔ ɔnyii to ɔbie sɔ ɔ̃abara-ɔ itɔ̃me ne, nyɔ sɔ miaɣɛ mirara so fiɛ miabo atɔ̃mekaɣɛkɔ̃. Si iiɖe ngbɔ ne, fɔ gu ngɔ lona itɔ̃me to ɔ̃aɖi-ɔ ɔtã atɔ̃meɣɛdze fiɛ atɔ̃meɣɛdze ana aasu-ɔ ɔtã madzuɛ̃se mapia-ɔ i iyo. ");
INSERT INTO akp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Gbaã nto loɣere-ɔ sɔ ato aawe i iyo karɛkɔ̃ gbɔgbɔɔgbɔ ɔwi gɔ atã kuso gɔ ato kapɛrɛ tsɔra aro. ");
INSERT INTO akp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Misɛ minɔ maɣɛ sɔ, ‘Marã gu mare si madaaɖe asɔrɔ̃.’ ");
INSERT INTO akp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ɣɛɛ nto loɣere mi sɔ si anyɔ ɔrɔ̃go fiɛ ɔkpɛ̃-ɔ ɔkã sɔ aasiai wũ ne, ɔɔsiai wũ koko i fɔ ɔtu ame. ");
INSERT INTO akp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ne ɔso si fɔ kuɖearɔ̃ inɔmi sɛ itã abara ikpi ne, were ne ɖi pɛyu. Alasɔ si fɔ sosina kakɔi kawɛ̃ ɔkpɛti ne, ilɛ iɖo sɔ Ɣaa asu fɔ kuturidziri ɔɖuɖu ɔpia i itɔkpe nɛ loisɛ inyi ame. ");
INSERT INTO akp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Fiɛ si fɔ kuɖearɔ̃ nsɛ kutã abara ikpi ne, tu kɔ̃ pɛyu. Ilɛ iɖo sɔ fɔ iso kakɔi kawɛ̃ aakpɛti iɖo sɔ Ɣaa asu fɔ kuturidziri ɔɖuɖu ɔfuĩdza ɔpia i itɔkpe nɛ loisɛ inyi ame. ");
INSERT INTO akp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Masɛ maɣɛ sɔ, ‘Ɔrɛrɛ̃ gɔ losɛ̃ ɔ̃ ɔre si ɔtã wũ ɔko gɔ loate sɔ ɔ̃ɔsɛ̃ ɔ̃ ɔre.’ ");
INSERT INTO akp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ɣɛɛ nto loɣere mi sɔ, ɔrɛrɛ̃ ɔrere gɔ loasɛ̃ ɔ̃ ɔre fiɛ iiɖe kama i ɔrɔ̃go ɔfe wũ ne, ɔtã ɔrɔ̃go ɔbara asɔrɔ̃ iɖe ikpi si ɔyiri ɔrɛrɛ̃ mama, fiɛ ngɔ loayiri ɔrɔ̃go gɔ masɛ̃ mmɔ ana ɔbara asɔrɔ̃ iɖe ikpi. ");
INSERT INTO akp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ɔwiɔ ne minɔ masɛ maɣɛ ana sɔ, ‘Daatu ndamu, Ɣɛɛ bara i nnɛ aɣɛ sɔ aabara atã Ɣaa iso.’ ");
INSERT INTO akp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ɣɛɛ mme nto loɣere mi kiniɔ sɔ daatarĩgu kuira ɖuɖuuɖu si ato akã ndamu. Daatarĩgu kato ala mmɔ nɖe Ɣaa sigaraiyara ne. ");
INSERT INTO akp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Daatarĩgu karɔ̃ ala mmɔ nɖe Ɣaa ngba kasiakɔ̃ ne. Daatarĩgu Yerusalem ana ala Magara ɔɖuɖu Igara Ɔmagɛ̃ ɔɖe. ");
INSERT INTO akp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Daatarĩgu fɔ iti ala aibawo fɔ ɔwɛrɛ̃ ɔwɛ̃ ɔbara kpinakpina ɣee futututu. ");
INSERT INTO akp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Si nnɛ mato maɣɛ pia i ne ame ne, tɔrã kere sɔ aĩ, fiɛ si ina i ne ame ne, ɣɛ kere sɔ ooɣo. Si irere ka ibua i nnɛgbe iso ne, Tsirise kɔrɛ ibɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Minɔ masɛ maɣɛ sɔ, ‘Si abiɛ fɔ ɔlaa inɔmi ne, maabiɛ fɔ ire, fiɛ si akpa fɔ ɔlaa inyɛ ne, maakpa fɔ ire fɔ wũ.’ ");
INSERT INTO akp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ɣɛɛ kiniɔ ne, nto loɣere mi sɔ, daabara fɔ ɔlaa ikpi nɛ ɔbara-ɔ atikuso. Si ɔrere ɔpɛ-ɔ ɔrɔ̃ta i kuɖearɔ̃ kutsueti ne, finikira kunyɔare tã wũ si ɔpɛ. ");
INSERT INTO akp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Si ɔrere ɔbara-ɔ itɔ̃me sɔ si ɔfɔ fɔ awu wa apia asɛ karɔ̃ ne, ɖi nwa apia asia kato ana tã wũ. ");
INSERT INTO akp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ngbɔ ame si kpakpɛ̃dze ɔmɔɛ̃-ɔ sikitii sɔ soregu wũ ɔ̃ ato si asɛ igu iwɛ̃ ne, sɛgu wũ agu anyɔ. ");
INSERT INTO akp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Si ɔturi ɔkarɛ-ɔ ira ne, tã wũ, fiɛ si ɔrere ɔba sɔ ɔba ɔnyɛ ira i fɔ kɔrɛ ne, nyɛ tã wũ. ");
INSERT INTO akp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Misɛ minɔ maɣɛ sɔ, ‘Ɖɔɛ mma nto maɖɔɛ-ɔ si atsiri mma lotsiri-ɔ.’ ");
INSERT INTO akp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ɣɛɛ kiniɔ ne, nto loɣere mi sɔ miɖɔɛ mma lotsiri mi si mikparama kayi i mma nto mati mi kama iti ");
INSERT INTO akp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","si miakpese mi Ɔse gɔ i kato mabi. Alasɔ ɔ̃ nsɛ ɔtã kuɣɛ̃ ɔbɔrɛ kutã maturi sɛɛ gu malalaa ɔɖuɖu fiɛ ɔsɛ ɔtã kado ɔpɛ ɔtã maturi bɔlɔlɔa gu maturi nyanyarĩa. ");
INSERT INTO akp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Si misɛ miɖɔɛ mma nsɛ maɖɔɛ mi ɔnɔwɛ̃ ne, be kuso miafɔ i Ɣaa kɔrɛ? Ma lampofɔdze ma wũ masɛ mabara ngbɔ. ");
INSERT INTO akp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Fiɛ si fɔ malaa ɔnɔwɛ̃ asɛ aya ne, mme siba ipɛ aba gɔ mma loiɖe mafɔɖedze ma wũ masɛ mabara ngbɔ? ");
INSERT INTO akp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ne ɔso milɛ miwiri lɛ kumɛgɔ i mi Ɔse gɔ i kato lɛ ɔwiri. ");
INSERT INTO akp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Minyɔ so kukaakɔ sɔ miibabara mi kasumu kubarara i ɔgbami sɔ maturi aanya. Alasɔ si mibara ngbɔ ne, mi Ɔse Ɣaa gɔ i kato siina kukuso ɔ̃atã mi. ");
INSERT INTO akp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ne ɔso si atã wɛrɛba ira ne, daapɛ ne imomo sɔ maturi aanɔ. Ngbɔ i mma nsɛ mabara ara si mabo maturi anɔ sɛ mabara i kasɔrɛkɔ̃ gu kuɣa ame sɔ maturi aanya fiɛ maale ma ne. Lobie sɔ lotã mi itsue sɔ maɔfɔ ma kuso koko! ");
INSERT INTO akp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ne ɔso si abuai wɛrɛba ne, daatã nane fɔ ɔlaa gɔ lomatã-ɔ si ɔtsue nnɛ abara, ");
INSERT INTO akp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","iɖe iwɛrɛra, iyɔ mi Ɔse Ɣaa gɔ nsɛ ɔnya awɛrɛra ɔɖuɖu wa i maturi sɛ mabara to ɔ̃atã-ɔ kuso. ");
INSERT INTO akp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Fiɛ si mito mikparama kayi ne, midaase lɛ mma nsɛ mabara ara si mabo maturi anɔ. Masɛ mabie sɔ maata maya makparama kayi i kasɔrɛkɔ̃ gu kuɣa ame sɔ maturi si manya ma. Lobie sɔ lotã mi itsue sɔ ma kuso ame maɔfɔ mmɔ ne. ");
INSERT INTO akp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ɣɛɛ fɔ si ato akparama kayi ne, kɛlɛ fɔ iyo kame si asɛ̃ iyo apia so fiɛ aakpere fɔ Ɔse gɔ maisɛ manya ala anɔmi, iyɔ gɔ ɔ̃ ɔsɛ ɔnya ta awɛrɛra ne, ɔto ɔ̃atã-ɔ kuso. ");
INSERT INTO akp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Fiɛ si ato akparama kayi ne, daaɣɛ atɔ̃me gbodzoo wa nna karɔ̃ ala ngbɔ i maɣɔsɔrɛdze sɛ mabara ku adzuni sɔ mmɔ i ma aɣɔ aakã ma atsue ne. ");
INSERT INTO akp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Midaase lɛ ma, ala mi Ɔse ka ɔɣe ara wa lonya mi koko fiɛ miakarɛ wũ. ");
INSERT INTO akp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ne ɔso si mito mikparama kayi ne, miɣɛ sɔ, ‘Bo Ɔse gɔ i kato, tã marɔ fɔ iyere sɛɛ. ");
INSERT INTO akp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Fɔ sigara iɖe si siba i bo ndɛ̃. Maabara fɔ kuɖɔɛ i kayiiso lɛ kumɛgɔ masɛ mabara i kato. ");
INSERT INTO akp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tã bo nɔme ikpɛnɛ aɖera. ");
INSERT INTO akp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Su bo akpi tsɛ bo lɛ kumɛgɔ bosɛ bosu botsɛ mma loɣɛrɛ bo. ");
INSERT INTO akp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Daatã sɔ boabo i kalakanyɔ ame, ɣɛɛ ɖi bo bɔrɛgu i ikpi ame. Ala fɔ ɔkpɛ nɖe sigara iɖe gu ɔle gu ikpawaĩ ɔwi ɔɖuɖu ame.’ ");
INSERT INTO akp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Si misu maturi akpi mitsɛ ma ne, mi Ɔse gɔ i kato ana to ɔ̃asu mi are ɔtsɛ mi. ");
INSERT INTO akp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ɣɛɛ si miisu maturi akpi mitsɛ ma ne, mi Ɔse ana iibasu mi are ɔtsɛ mi.” ");
INSERT INTO akp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yesu ɔledza iɣɛ sɔ, “Si mito minyi kanya ne, midaanyi katɔ̃ mila lɛ mma nsɛ mabara ara si mabo maturi anɔ awe. Ala masɛ manyi katɔ̃ mala sɔ maturi si matsue sɔ mato manyi kanya, fiɛ gbaã loto loɣere mi sɔ maɔfɔ ma kuso koko. ");
INSERT INTO akp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Si mito minyi kanya ne, mifore anɔmi si mitara mi ati kukaakɔ miledza so. ");
INSERT INTO akp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ne loatã sɔ maturi iibatsue sɔ ato anyi kanya, ɣɛɛ fɔ Ɔse gɔ maisɛ manya, fiɛ ɔsɛ ɔnya ara wɛrɛa aatã-ɔ kuso. ");
INSERT INTO akp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Midaakɔla karana mitã so i kayi gagbe ame ala ngbe ne, makorokpɛ to maanina kã ɣee kapɛ matɔ, fiɛ mayukukpe ana to maawo kukui ɔbiɛ mabo iyo mayu kã. ");
INSERT INTO akp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ɣɛɛ ne, mikɔla karana misɛ so i kato. Ala mmɔ ne, makorokpɛ iisɛ manina ara, kaisɛ kapɛ matɔ fiɛ mayukukpe ana iisɛ mabo i mmɔ mayu ara. ");
INSERT INTO akp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Alasɔ ngbegɔ i fɔ karana se ne, mmɔ i fɔ ɔtu ana aawe ne. ");
INSERT INTO akp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Anɔmi se lɛ ɔkaniɛ atã kuturidziri. Si fɔ anɔmi ɔkpa ne, Fɔ kuturidziri ɔɖuɖu ame to kuakpa waĩ. ");
INSERT INTO akp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ɣɛɛ si fɔ anɔmi iikpa ne, fɔ kuturidziri ɔɖuɖu to kuase guduu. Ne ɔso si fɔ ikpawaĩ ɔgudu ne, fɔ idududu ɔwodoro gbaã! ");
INSERT INTO akp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Kuwɛ̃ iibawo makɔse inyɔ ɔsumu. Si iiɖe ngbɔ ne, ɔto ɔ̃aɖɔɛ ɔwɛ̃ ɔtsiri ɔwɛ̃. Ɣee ɔ̃awarɛ ɔwɛ̃ ɔta ɔya ɔwɛ̃ iso. Miibawo Ɣaa gu karana ɔsɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ne ɔso nto loɣere mi sɔ midaamararã so i mi ngbã, nnɛ miaɖe gu nnɛ mianɛ, ɣee mi sosina gu nnɛ miapia iso. Ɛɛbɛrɛ ngbã iifɔ kuɣa miɖo aɖera fiɛ kuturidziri iifɔ kuɣa kuɖo arapia? ");
INSERT INTO akp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Minyɔ kato kurodzai gɔ loisɛ kukpɛ̃ fiɛ kuisɛ kusɔrɛ̃ ɔraɖui, kuna siwu ɣɛɛ mi Ɔse gɔ i kato sɛ ɔkararã kɔ̃! Miifɔ kuɣa miɖo kurodzai? ");
INSERT INTO akp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mi nna loawo ikpɛnɛ iwɛ̃ ɔsu ɔbua i ɔ̃ agbanayi iso iki i imararãso ame? ");
INSERT INTO akp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Be ɔso mito mimararã so i nnɛ miapia iso? Minyɔ ipo ame adziri kumɛgɔ asɛ amɔ. Aisɛ ata ɖɔti ɣee awe sikati. ");
INSERT INTO akp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ɣɛɛ nto loɣere mi sɔ Igara Salomo kɔra si ɔkɛrɛ so ne, ɔ̃isɛ ɔlɛ ɔnyɔ lɛ kudziri gɔ lofere aɣɔ̃la. ");
INSERT INTO akp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ɣaa nsɛ ɔkɛrɛ sikua ngbɔ. Sikua dzɛ mpia nɔme kɔrãkaɖe maɔkpɛ̃ sɛ̃ mafere i ɔtɔ ame matsuedza. Si Ɣaa to ɔnyɔ sikua iso ngbɔ ne, ɔ̃ibabara ɔtã mi ma loɖo sikua? Be ɔso i mi kafɔkaɖe ɔfoforo ngbɔ? ");
INSERT INTO akp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Ne ɔso midaasɛ mimararã so sɔ ‘Be boaɖe? Be boanɛ? Be boapia?’ ");
INSERT INTO akp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ara wagbe i maɣɔsɔrɛdze sɛ mabie ne, ɣɛɛ mi Ɔse gɔ i kato ɣe sɔ nwagbe ɔɖuɖu ɔnya mi. ");
INSERT INTO akp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ɣɛɛ nnɛ iso i mi anɔ si arɛtɛ nɖe sɔ Ɣaa si ɔɖe sigara i mi iso gu si mibara sibɔlɔlɔ ara iyɔ ɔto ɔ̃asu ara wagbe ɔɖuɖu ɔtã mi. ");
INSERT INTO akp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ne ɔso midaamararã so i kɔrãkaɖe ga loisɛ̃ iso. Kɔrãkaɖe amɔrɛ̃ si ase ise ala nɔme are ɔɔfe isi. ");
INSERT INTO akp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Midaaɣɛgu maturi atɔ̃me si Ɣaa iibaɣɛgu mi atɔ̃me. ");
INSERT INTO akp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Alasɔ ɔri gɔ iso aɣɛgu fɔ ɔlaa atɔ̃me akigu ne, ɔ̃ ame iso i Ɣaa aɣɛgu-ɔ ne. Kaboũsuai ga igbã ako ala ara atã fɔ ɔlaa ne, kã ame igbã maasu mako matã-ɔ ne. ");
INSERT INTO akp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Nda ato abara fiɛ ato anya iku nɛ mpia i fɔ ɔlaa inɔmi fiɛ aito abara kuira i idzirikpo nɛ mpia fɔ mɔmɔ inɔmi iso? ");
INSERT INTO akp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nda aabara fiɛ aaɣere fɔ ɔlaa sɔ, ‘Tã loɖi-ɔ iku i inɔmi.’ ku ɔwi gɔ i idzirikpo pia-ɔ i inɔmi ");
INSERT INTO akp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ladze! Ɖe katɔ̃ ɖi idzirikpo nɛ mpia i fɔ mɔmɔ inɔmi tɔtɔ fiɛ aanya kukaakɔ aɖi iku i fɔ ɔlaa inɔmi. ");
INSERT INTO akp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Midaasu ara wa nse sekelee misa mifere maturi ma nse lɛ makpɛkpɛ alasɔ mato maafiniki mabo mi iso maɖoɖo mi. Ngbɔ ame si midaasu anyi wa lofɔ kuɣa mifuĩdza misɛ makparako ne. Si misu misɛ ma ne, ɔnene kere maanene mapia i iba ame. ");
INSERT INTO akp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mikarɛ ara si maatã mi ara, mibie ara si miana, mipɛ kukui kɔrɔ̃ si maasese mi iyo. ");
INSERT INTO akp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Alasɔ ɔbiara gɔ nsɛ ɔkarɛ ira sɛ ɔfɔ. Ɔbiara gɔ nsɛ ɔbie ira sɛ ɔna ne, fiɛ ɔbiara gɔ nsɛ ɔkpura kukui kɔrɔ̃ ne, masɛ masese matã wũ. ");
INSERT INTO akp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ɣese ɔwɛ̃ aasu ita ɔtã ɔ̃ ɔbi gɔ lokarɛ wũ aɖera? ");
INSERT INTO akp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ɣee ɔsu aɣɛ ɔtã ɔ̃ ɔbi si ɔkarɛ wũ ikpɛ? ");
INSERT INTO akp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Si mi ma nɖe makpibaradze kɔra ɣe kumɛgɔ miatã mi mabi ara sɛɛ ne, iyɔ mi Ɔse gɔ i kato to ɔ̃atã mma nto makarɛ wũ ara sɛɛ ɔɖo. ");
INSERT INTO akp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ne ɔso ira biara nɛ miabie sɔ maturi si mabara matã mi ne, mi wũ mibara wã mitã ma. Nnɛgbe ame kere i Mose mmara gu Ɣaa kanyamaɖidze ara wa matsɛrɛ masɛ to ate ne. ");
INSERT INTO akp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Miki i kayogodɔ̃ ga lomɔmɔrĩ ame, alasɔ kayogodɔ̃ ga nkpa Ɔbosam itɔkpe ame ne, kabɛ, kã ɔri ana iso isɛ se pɔkɔsɔɔ fiɛ maturi gbodzoo nsɛ i ɔri gɔmɔ iso. ");
INSERT INTO akp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ɣɛɛ kayogodɔ̃ ga nkpa ngbã mɛ loisɛ miro ame ne, kase mɔmɔrĩ, kã ɔri ana iso isɛ ba ɔle fiɛ maturi kɛkɛĩ pɛ nsɛ i ɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Minyɔ so i mila Ɣaa kanyamaɖidze ma nsɛ maba mi kɔrɛ iso. I anɔmi ame ne, manyɔ lɛ masɛrɛrerɔ̃, ɣɛɛ aketeke maɖe. ");
INSERT INTO akp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ma nsɛgbai miasu minya ma miɖi ite. Kuwɛ̃ iisɛ ɔtɔtɔrɛ figi abi i miyu kudziri iso, fiɛ maisɛ matɔtɔrɛ adziribi ɖea i itongbã iso. ");
INSERT INTO akp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ne ɔso ne, kudziri sɛɛ ne, abi sɛɛ kusɛ kuɣɔ̃ fiɛ kudziri lalaa ana ne, abi lalaa kusɛ kuɣɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kudziri sɛɛ iibawo abi lalaa ɔɣɔ̃, fiɛ ngbɔ ame i kudziri lalaa iibawo abi sɛɛ ɔɣɔ̃ ne. ");
INSERT INTO akp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kudziri biara gɔ loisɛ kuɣɔ̃ abi sɛɛ ne, masɛ matu kɔ̃ mapɛyu matsuedza. ");
INSERT INTO akp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ne ɔso mila kanyamaɖidze ne, ma nsɛgbai miasu minya ma miɖi ite. ");
INSERT INTO akp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Iiɖe ɔbiara gɔ nsɛ ɔɣere me sɔ, ‘Bosate, Bosate,’ loakɛlɛ Ɣaa sigarakaɖekɔ̃. Ɣɛɛ mma nto mabara wũ Ɔse gɔ i kato kuɖɔɛ loasɛ mmɔ. ");
INSERT INTO akp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Atɔ̃me iɣɛyi iso ne, maturi gbodzoo to maaɣere me sɔ, ‘Bosate! Boɣɛ fɔ itɔ̃me fiɛ bosa siwarã lalaa i fɔ iyere ame. Bobara awawãra i fɔ iyere ame.’ ");
INSERT INTO akp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mmɔ loaɣere ma sɔ, ‘Loiɣe mi kukakɔi! Mi ara lalaa mabaradze, mirui me i kɔrɛ.’ ");
INSERT INTO akp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ne ɔso ngɔ nsɛ ɔnɔ wũ itɔ̃me fiɛ ɔsɛ ɔbara i ne iso ne, ɔse lɛ nɔgbadze gɔ lotsue ɔ̃ iyo ɔsia i ita iso. ");
INSERT INTO akp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kado ɔpɛ, siwore ɔyi, awɛ ɔkpɛ̃ teteree ɣɛɛ iyo iirɔ̃ ala mapia ne karɔ̃ ame kukaakɔ. ");
INSERT INTO akp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ɣɛɛ ɔbiara gɔ nsɛ ɔnɔ wũ itɔ̃me fiɛ ɔ̃isɛ ɔbara i ne iso ne, ɔse lɛ dzimifɔ gɔ lotsue ɔ̃ iyo ɔsia i iwarĩ iso. ");
INSERT INTO akp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kado ɔpɛ, siwore ɔyi, awɛ ɔkpɛ̃ amɔɛ̃ iyo fiɛ irɔ̃ teteree ibiɛbiɛ.” ");
INSERT INTO akp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Gɔ Yesu ɔɣɛ ara wagbe ɔro ne, ɔ̃ ara ite ɔbara maturi gbodzoo mamɔ ɣii. ");
INSERT INTO akp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Alasɔ ɔte ara lɛ ngɔ mba ɔle fiɛ iiɖe lɛ ma mmara matedze awe. ");
INSERT INTO akp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Gɔ Yesu ɔso i kabemi iso ɔba ne, maturi gbodzoo ɔsiai wũ. ");
INSERT INTO akp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ne ɔrɛrɛ̃ ɔwɛ̃ gɔ nto ɔnyɛ ɔnyɛ rɛtɛa ɔba ɔ̃apɛ agɛgɛ̃ i ɔ̃ katɔ̃ ɔɣere wũ sɔ, “Bosate! Si aɖɔɛ ne, aawo me ɔsa lose sekelee.” ");
INSERT INTO akp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu ɔɖi kɔrɔ̃ ɔpɛgu wũ ɔɣere wũ sɔ, “Loɖɔɛ, se sekelee.” Ɔluwɛ̃ ne, ɔsarɛ, ɔse sekelee. ");
INSERT INTO akp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mmɔ i Yesu to ɔɣere wũ sɔ, “Nyɔ kukaakɔ, daaɣere kuwɛ̃ kuira, ɣɛɛ kɛlɛ aasu so te Ɣaa sɔrɛdze si atã ara wa i Mose mmara ɔkarɛ si ite sɔ ka ase sekelee.” ");
INSERT INTO akp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ne kama gɔ Yesu ɔbo i Kapernaum ɔmagɛ̃ ame ne, Roma kpakpɛ̃dzekpakpa ɔwɛ̃ ɔba ɔ̃atu wũ ɔtã wũ iti sɔ, ");
INSERT INTO akp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Bosate! Wũ ɔɖabo rɛ ɔto ɔnyɛ, ɔ̃ito ɔwo ɔta gɔ so to sibo wũ kukaakɔ.” ");
INSERT INTO akp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu Ɔɣere wũ sɔ, “Loaba loasa wũ.” ");
INSERT INTO akp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ɣɛɛ kpakpɛ̃dze gɔgbe ɔtã wũ mmuai sɔ, “Ooɣo! Bosate, loikote sɔ aaba wũ iyo, fɔ ɣɛ itɔ̃me iwɛ̃ kere ne wũ ɔɖabo to ɔ̃asarɛ. ");
INSERT INTO akp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Alasɔ mme wũ ɔkpakpa loɖe i makpakpa mama kayirinɔ. Loba makpakpɛ̃dze mama i wũ kayirinɔ. Nsɛ loɣere ngɔ sɔ, ‘Kɛlɛ ngbe,’ ɔkɛlɛ fiɛ nsɛ loɣere ɔmama ana sɔ, ‘Ba ngbe’ ɔba. Nsɛ loɣere wũ ɔɖabo sɔ, ‘Bara lɛ ngbe’ ɔbara.” ");
INSERT INTO akp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Gɔ Yesu ɔnɔ atɔ̃me wagbe ne, ibara wũ ɣaa, ne ɔɣere mma nsiai wũ sɔ, “I ɔnukuare ame ne, loinya kafɔkaɖe siare gagbe igbã lonya i Israel karɔ̃ ɔɖuɖu iso. ");
INSERT INTO akp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nto loɣere mi sɔ maturi gbodzoo to maabɔrɛ i kuɣɛ̃kabɔrɛkɔ̃ gu kɔ̃ iyo kabokɔ̃ maba maasɛ i ɔpɔrɔ̃ katɔ̃ maɖe ara ku Abraham gu Isak gu Yakob i Ɣaa sigarakaɖekɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ɣɛɛ mma nɖe sigarakaɖekɔ̃ mabi ne, maafuĩdza ma mapia i idududu nɛ mpia i kayoma ame. Mmɔ i kaku gu inyɛwe aawe ne.” ");
INSERT INTO akp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ne Yesu ɔɣere kpakpɛ̃dzekpakpa gɔmɔ sɔ, “Kɛlɛ! Iaba itã-ɔ lɛ kumɛgɔ afɔ aɖe awe.” Ɔwi gɔmɔ ame ame i iyo ne, ɔɖabo ɔna isosarɛ. ");
INSERT INTO akp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Gɔ Yesu ɔsɛ Petro iyo ne, ɔnya sɔ Petro masɔrɔ̃go rɛ, ɔbe ɔtɔ ɔto ɔnyɛ. ");
INSERT INTO akp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu ɔpɛgu wũ kɔrɔ̃, ɔluwɛ̃ ne, ɔsarɛ ɔta ɔwa aɖera ɔtã wũ. ");
INSERT INTO akp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ne kutsuɛ ne, makɔ maturi gbodzoo ma i siwarã lalaa si i iso mabɔ Yesu. Ɔsu itɔ̃me iwɛ̃ ɔsa siwarã lalaa ɔɖi i ma ame fiɛ ɔsa mma ɔɖuɖu nto manyɛ. ");
INSERT INTO akp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nnɛ ɔbara ngbe ɔtã sɔ nnɛ i Ɣaa Kanyaɖidze Yesaya ɔɣɛ ɔsɛ ɔba i ne ame sɔ, “Ɔ̃ mɔmɔ ɔɖu iti i bo isobo kayirinɔ, fiɛ ɔsa bo sinyɛ ɔɖuɖu.” ");
INSERT INTO akp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Gɔ Yesu ɔnya maturi gbodzoo ma nɣɛ wũ i kɔrɛ mmɔ ne, ɔɣere ɔ̃ marasuãdze sɔ matã mawara ibu makɛlɛ ɔkpokpo gɔmɔ isɛ. ");
INSERT INTO akp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mmaratedze ɔwɛ̃ ɔba ɔ̃atu wũ ɔɣere wũ sɔ, “Ratedze, loasiai-ɔ kakɔi biara ga aakɛlɛ.” ");
INSERT INTO akp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ne Yesu to ɔtã wũ mmuai sɔ, “Mabɔi lalaa ba awo wa ame masɛ mawɛrɛ fiɛ kurodzai ana ba ayo, ɣɛɛ mme, Ɔturi Awune Ɔbi, na iti kasiakɔ̃.” ");
INSERT INTO akp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Rasuãdze ɔwɛ̃ ana ɔɣere wũ sɔ, “Bosate, loasiai-ɔ, ɣɛɛ ɖi me ɔri si nsɛ loabiara tete tɔtɔ.” ");
INSERT INTO akp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu ɔɣere wũ sɔ, “Siai me si atã mma nse lɛ makpise si mabiara ma makpise.” ");
INSERT INTO akp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu gu ɔ̃ marasuãdze ɔbo i ɔkolo ɔwɛ̃ ame marui. ");
INSERT INTO akp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ɔluwɛ̃ ne, awɛ siare awɛ̃ ɔtsɛ ikpɛ̃ i itubu iso gɔ itã ndu to mita mibo i ɔkolo ame, ɣɛɛ Yesu rɛ ɔto ɔrɛ sirɛ. ");
INSERT INTO akp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Marasuãdze ɔbore mabo wũ matara wũ sɔ, “Bosate, ɖi bo ne ɔkpi boto!” ");
INSERT INTO akp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ne Yesu ɔtã ma mmuai sɔ, “Kafɔkaɖe tɛgɛlɛa maturi, midaanigã!” Ne ɔta ɔtɔ̃me ɔpia awɛ fiɛ anyua ɔkpɛ̃, ndu ana ɔlo kananana ne! ");
INSERT INTO akp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ibara ma ɔɖuɖu ɣaa, ne mato makarɛ so sɔ, “Mme ɔturi igbã ɔɖe ngbe fiɛ ta awɛ gu ndu to makã wũ atsue?” ");
INSERT INTO akp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Gɔ Yesu ɔwara itubu ɔbo i Gadara ibuiti ame ne, maturi inyɔ ma ame i siwarã lalaa si i iso ɔbɔrɛ i ɔkpolo gɔ ame masɛ mabiara maturi maba maasarɛgu wũ. Maba silalaa sɔ kuwɛ̃ iisɛ ɔki i ndɛ̃ mmɔ ɔfe. ");
INSERT INTO akp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ɔluwɛ̃ ne, mala kulu maɣɛ sɔ, “Fɔ Ɣaa Ɔbi, be mpia i bo gu-ɔ ndɛ̃? Ɔba ɔɔba sɔ aba aakpadzɛ̃ bo kutsue aɖegu ɔwi gɔ masɛ katɔ̃?” ");
INSERT INTO akp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Makparako ikuri iwɛ̃ ɣɛ i ndɛ̃ mɛmɔ isɛ mato maɖe ara. ");
INSERT INTO akp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Siwarã lalaa ɔtã Yesu iti sɔ, “Si aasa bo ne, tã bosɛ boabo i makparako ikuri nɛ nɣɛ i mmɔ ame.” ");
INSERT INTO akp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu ɔɣere ma sɔ, “Mikɛlɛ ma ame.” Ne ɔso sibɔrɛ sisɛ siabo i ma ame. Makparako ikuri ɔɖuɖu ɔtere kpitikpitikpiti maso kabemi mabo i itubu ame makpi. ");
INSERT INTO akp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mma nto manyɔ makparako iso ɔtere makɛlɛ ɔmagɛ̃ ame masɛ maaɣere ma magɛ̃se nnɛ ɔɖuɖu loba gu nnɛ loba i mma iso i siwarã lalaa si iso. ");
INSERT INTO akp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ne ɔso kaɖe ɔɖuɖu ɔba maasakanya sɔ si manyɔ Yesu. Gɔ manya wũ ne, matã wũ iti sɔ ɔbɔrɛ i ma karɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu ɔbo i ɔkolo ame ɔkpese ɔwara itubu ɔkɛlɛ ma aɖe. ");
INSERT INTO akp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mawɛ̃ ɔsu ɔrɛrɛ̃ ɔwɛ̃ gɔ lofɛfɛ̃ ɔrɛ i ɔkala iso mabɔ wũ. Gɔ Yesu ɔnya ma kafɔkaɖe ne, ɔɣere nyɛse sɔ, “Na ɔtu wũ ɔbi, losu fɔ akpi lotsɛ-ɔ.” ");
INSERT INTO akp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ne mmara matedze mawɛ̃ mmɔ to maɣere so sɔ, “Ngɔgbe to ɔɣɛ imusuora!” ");
INSERT INTO akp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu ɔtsue nnɛ mpia i ma adzuni ame ne ɔso ɔɣere ma sɔ, “Be ɔso mito misusu adzuni nyanyarĩa wagbe i mi situ ame? ");
INSERT INTO akp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Be iɣɛ nse pɔkɔsɔɔ iɖo sɔ ‘Losu fɔ akpi lotsɛ-ɔ,’ ɛɛbɛrɛ sɔ, ‘Ta ya si asɛ’? ");
INSERT INTO akp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Loate mi sɔ mme, Ɔturi Awune Ɔbi, ba ɔle i kayi gagbe ame sɔ loasu akpi lotsɛ.” Ne ɔso ɔɣere ngɔ lofɛfɛ̃ ɔrɛ sɔ, “Ta ya si asu fɔ ɔkala si akɛlɛ iyo.” ");
INSERT INTO akp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ɔrɛrɛ̃ ɔta ɔya ɔrui ɔkɛlɛ iyo. ");
INSERT INTO akp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Gɔ maturi ɔnya nnɛ loba ne, manigã, matsɛ Ɣaa ile sɔ ɔsu ɔle gɔgbe igbã ɔtã maturi. ");
INSERT INTO akp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Gɔ Yesu ɔrui i mmɔ ɔkɛlɛ katɔ̃ kɛkɛĩ ne, ɔnya lampofɔdze ɔwɛ̃ gɔ marɔ Mateo si i ɔ̃ karabara kabarakɔ̃. Ne Yesu ɔɣere wũ sɔ, “Ba siai me.” Ɔluwɛ̃ ne, Mateo ɔta ɔsiai wũ. ");
INSERT INTO akp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Gɔ Yesu si ɔto ɔɖe ara i Mateo iyo ne, ma lampofɔdze gbodzoo gu makpibaradze ɔba maasɛgu wũ i ɔpɔrɔ̃ iti gu ɔ̃ marasuãdze. ");
INSERT INTO akp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Gɔ ma Farisise ɔnya nnɛgbe ne, makarɛ ɔ̃ marasuãdze sɔ, “Be ɔso i mi ratedze to ɔɖe ara ku mmagbe igbã?” ");
INSERT INTO akp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu ɔnɔ nnɛ mato maɣɛ, ne ɔtã ma mmuai sɔ, “Manyɛse i kuabaradze ɔnya ne iiɖe mma nsarɛ. ");
INSERT INTO akp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Misɛ mianyɔnyɔ itɔ̃me nɛ mpia i Ɔko Sekelea ame sɔ, ‘Nnyainyɔ nto lobie ne iiɖe mabɔi isu ifɛ̃ ara itã’ karɔ̃. Alasɔ loiba lokpere mma nsɛ mabu so maturi sɛɛ sɔ mafiniki, ɣɛɛ makpibaradze loba lokpere.” ");
INSERT INTO akp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nwagbe kama ne, Ndupiedze Yohanes marasuãdze ɔba Yesu kɔrɛ maba maakarɛ wũ sɔ, “Be ɔso i bo gu ma Farisise sɛ bonyi kanya ɔwi biara, ɣɛɛ fɔ marasuãdze iisɛ manyi?” ");
INSERT INTO akp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu ɔtã ma mmuai sɔ, “Mibu sɔ ɔrɔ̃go kɔdze malaa aamararã so ayi kumɛgɔ i ɔrɔ̃go kɔdze pia i ma kɔrɛ? Ikpa sekelee sɔ maibabara ngbɔ! Ɣɛɛ iyi to iba gɔ mato maakɔ ɔrɔ̃go kɔdze maruigu i ma kɔrɛ. Ɔwi gɔmɔ mato maanyi kanya ne. ");
INSERT INTO akp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Kuwɛ̃ iisɛ ɔta ɔkati kuere ala kakatisɛi ɣɛtɛ, alasɔ si abara ngbɔ ne, kakatisɛi ɣɛtɛ gamɔ to kaakarĩ karui iyoi nɛ loabɛ iɖo iɖeakatɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Ngbɔ ame i kuwɛ̃ iisɛ ɔsu ndã ɣɛtɛ ɔfere i bɔi ɔko akpo kuere ame ne. Si abara ngbɔ fiɛ ndã ɣɛtɛ ɔtsɛ ifu ne, miatã sɔ akpo kuere aabiɛ gɔ ndã gu bɔi ɔko akpo ɔɖuɖu aanina. Ne ɔso ndã ɣɛtɛ ne, bɔi ɔko akpo ɣɛtɛ ame masɛ mafere me sɔ wã anyɔ aase kukaakɔ.” ");
INSERT INTO akp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Gɔ Yesu togu ma ika iɖe ne, ma Yudase tɔ̃ɖedze ɔwɛ̃ ɔba ɔ̃ kɔrɛ, ɔpɛ agɛgɛ̃ i ɔ̃ katɔ̃ ɔɣere wũ sɔ, “Wũ ɔbi birɔ̃gomi ɔkpi kiniɔkiniɔ ɣɛɛ ba sia wũ kɔrɔ̃ iso si arɛgɛ̃ra wũ.” ");
INSERT INTO akp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ne ɔso Yesu ɔta ɔsiai wũ ku ɔ̃ marasuãdze. ");
INSERT INTO akp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Gɔ Yesu to ɔkɛlɛ ne, ɔrɔ̃go ɔwɛ̃ gɔ i ara to afere akɔ aweo-anyɔ ɔki i Yesu kama isɛ ɔpɛgu ɔ̃ awu kutsueti. ");
INSERT INTO akp_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ɔbara ngbɔ ala ɔɣere so sɔ, “Si lopɛgu ɔ̃ awu kutsueti ne, loto loana isosarɛ.” ");
INSERT INTO akp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu ɔfiniki ɔnyɔ, ne ɔnya ɔrɔ̃go ne. Ɔɣere wũ sɔ, “Na ɔtu, wũ ɔbi, fɔ kafɔkaɖe ɔɔsa-ɔ.” Ɔluwɛ̃ ne, ɔna isosarɛ. ");
INSERT INTO akp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ne Yesu ɔkɛlɛ tɔ̃ɖedze gɔmɔ iyo ne. Gɔ ɔnya kudadã mafɛ̃dze gu mma nto mabiɛ kaku gu kulu titiiti ne, ");
INSERT INTO akp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ɔɣere ma sɔ, “Mibɔrɛ ne ɔbi iikpi, sirɛ kere ɔto ɔrɛ.” Gɔ ɔɣɛ ngbɔ ne, mama wũ. ");
INSERT INTO akp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Gɔ masa ɔbiara maɖi ne, Yesu ɔbo iyo ame i ɔbi kɔrɛ. Ɔmɔɛ̃ wũ kɔrɔ̃ ɔtara wũ ɔɣedza gbanadze. ");
INSERT INTO akp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Itɔ̃me nɛgbe ɔki ikã i karɔ̃ ndɛ̃ mɛmɔ ɔɖuɖu iso. ");
INSERT INTO akp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Gɔ Yesu ɔbɔrɛ i mmɔ ɔto ɔfe ne, manɔbiɛdze inyɔ ɔsiai wũ mato mala kulu teteree sɔ, “Igara David Ɔbi, nyɔ bo nnya!” ");
INSERT INTO akp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Gɔ Yesu ɔbo iyo ame ne, maba ɔ̃ kɔrɛ, ne ɔkarɛ ma sɔ, “Mifɔ miɖe sɔ loawo mi ɔsa?” Matã mmuai sɔ, “Aĩ, Bosate!” ");
INSERT INTO akp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ne Yesu ɔpɛgu ma anɔmi ɔɣere ma sɔ, “Iba itã mi lɛ kumɛgɔ mifɔ miɖe.” ");
INSERT INTO akp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ma anɔmi ɔbusi. Ne Yesu ɔsɛ̃ ɔtã ma teteree sɔ, “Midaaɣere kuwɛ̃ itɔ̃me nɛgbe.” ");
INSERT INTO akp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ɣɛɛ gɔ mabɔrɛ i mmɔ ne, mapɛ ne imomo i Yesu iso i karɔ̃ gamɔ ɔɖuɖu iso. ");
INSERT INTO akp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Gɔ mmagbe ɔrui mato makɛlɛ ne, mawɛ̃ ɔkɔ ɔmumu ɔwɛ̃ gɔ ame i siwarã lalaa pia mabɔ Yesu kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ne gɔ Yesu ɔsa siwarã lalaa ɔɖi i ɔ̃ ame ne, ɔtsɛ ika iɖe. Ibara maturi gbodzoo mamɔ ɣii, ne mato maɣere so sɔ, “Boinya nnɛgbe igbã bonya i Israel karɔ̃ iso.” ");
INSERT INTO akp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ɣɛɛ ma Farisise ɔɣɛ sɔ, “Siwarã lalaa igara lotã wũ ɔle ɔto ɔsu ɔsa siwarã lalaa.” ");
INSERT INTO akp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu ɔsɛ ɔ̃awe ɔki i simagɛ̃ gu nsɛkɔ̃ ame ɔte ara i ma kusarɛkɔ̃, ɔɣɛ sigarakaɖekɔ̃ iso Itɔ̃me Bielea, fiɛ ɔsa sinyɛ agbãagbã gu isobo igbã biara. ");
INSERT INTO akp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Gɔ ɔnya maturi gbodzoo magbe ne, ma ara ɔɖo wũ kayiri alasɔ so ɔɔtu ma fiɛ maɔre nrɔɔ̃ lɛ masɛrɛ ma nna kɔdze. ");
INSERT INTO akp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ne Ɔso ɔɣere ɔ̃ marasuãdze sɔ, “Ɔraɖui gɔ maasɔrɛ̃ ɔsi, ɣɛɛ marabaradze iisi. ");
INSERT INTO akp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ne ɔso mitã kakpɛkɔ̃ Sate iti sɔ ɔsese marabaradze ɔ̃ kakpɛkɔ̃ ame.” ");
INSERT INTO akp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu ɔrɔ ɔ̃ marasuãdze iweo-inyɔ ɔsirakanya ɔtã ma ɔle sɔ masa siwarã lalaa maɖi i maturi ame, masa sinyɛ agbãagbã gu isobo igbã biara. ");
INSERT INTO akp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Katɔ̃memasɛdze iweo-inyɔ mamɔ ayere ngbe ne. Simon gɔ masɛ marɔ ana sɔ Petro gu ɔ̃ ɔnyiibi Andrea gu Yakobo gu ɔ̃ ɔnyiibi Yohanes ma nɖe Zebedeo mabi ");
INSERT INTO akp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","gu Filipo gu Bartolomeo gu Toma gu lampofɔdze Mateo gu Yakobo gɔ nɖe Alfeo ɔbi gu Tadeo ");
INSERT INTO akp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","gu Simon gɔ nsɛ ɔɖɔɛ ɔ̃ kaɖe gu Yuda Iskariot gɔ loaɖi Yesu ɔtã. ");
INSERT INTO akp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu ɔpia marɛrɛ̃ iweo-inyɔ magbe ɔtã ma mmara sɔ, “Midaasɛ mma loiɖe ma Yudase karɔ̃ iso gu ma Samariase simagɛ̃ ame. ");
INSERT INTO akp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ɣɛɛ mikɛlɛ Israel mabi ma nse lɛ masɛrɛ ma loyu ɔri kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Si misɛ ne, mipɛ imomo miɣɛ sɔ, ‘Ɣaa sigara ɔɖewi ɔɔɣo!’ ");
INSERT INTO akp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Misa manyɛse si mitara makpise. Mitã mma nto manyɛ ɔnyɛ rɛtɛa iso si ikpa, misa siwarã lalaa miɖi i maturi ame. Miitã kuso kukuwɛ̃ i ɔle gɔ mifɔ iti, ne ɔso mi wũ midaafɔ kuwɛ̃ kuso. ");
INSERT INTO akp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Midaasu sikã kusiwɛ̃ mipia i mi sikoto ame. ");
INSERT INTO akp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Midaasu marawãnyidze akpo, awu pia aka anyɔ, ndokota ɣee ɔsɛdziri i mi irisɛ ame. Ikote sɔ maatã rabaradze ɔ̃ aɖera. ");
INSERT INTO akp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Si mibo ɔmagɛ̃ ɣee kasɛkɔ̃ biara ame ne, mibie ngɔ lonɔ karɔ̃ sɔ ɔ̃afɔ mi. Mibo i ɔ̃ kɔrɛ si miwe i mmɔ gbɔgbɔɔgbɔ miarui. ");
INSERT INTO akp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Si mibo iyo irere ame ne, miya ma miɣɛ sɔ, ‘Isobuɛ itã mi.’ ");
INSERT INTO akp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Si iyo ame maturi ɔfɔ mi ne, mi isobuɛ mibie mitã ma si iba itã ma, ɣɛɛ si maifɔ mi ne, mi isobuɛ mibie mitã ma si ikpese iba mi kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ɣɛɛ si iyo irere, ɣee kaɖe karere maturi iifɔ mi ɣee maikã mi atsue ne, mikpakpa mi ngba iso sise mifere si mito mirui. ");
INSERT INTO akp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nto losia ita lotã mi sɔ iase pɔkɔsɔɔ itã Sodom gu Gomora maturi ku atɔ̃me iɣɛyi iɖo ɔmagɛ̃ gɔmɔ maturi. ");
INSERT INTO akp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Minyɔ! Nto lopia mi lɛ masɛrɛrerɔ̃ i magidi ndɛ̃. Ne ɔso mikpa anɔ lɛ maɣɛ, ɣɛɛ miɣɔ lɛ alɔpɔ. ");
INSERT INTO akp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Minyɔ so kukaakɔ i maturi iso alasɔ mato maaɖi mi matã mamɔɛ̃ makɛlɛgu atɔ̃mekaɣɛkɔ̃, mato maapɛ mi i ma kusarɛkɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Wũ ɔso ne, mato maamɔɛ̃ mi makɛlɛgu matɔ̃ɖedze gu magara katɔ̃ sɔ maɣɛgu mi atɔ̃me, ɣɛɛ miɣɛ Itɔ̃me Bielea i mma loiɖe ma Yudase katɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Si makɔ mi makɛlɛgu atɔ̃mekaɣɛkɔ̃ ne, midaamararã so sɔ be miasɛ miaɣɛ ɣee nda miaɣɛ mikigu. Ɣɛɛ si ɔwi ɔɔɣo ne, Ɣaa to ɔ̃atã mi nnɛ miaɣɛ. ");
INSERT INTO akp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Alasɔ iiɖe mi loaɖe ika, ɣɛɛ mi Ɔse Siwarã loaɖe ika sikigu i mi iso. ");
INSERT INTO akp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ɔwi gɔmɔ ame ne, maturi to maaɖi ma manyii matã sɔ maɖoe fiɛ mase ana to maaɖi ma mabi matã. Mabi to maata maya ma maɣese iso maɖi ma matã maɖoe. ");
INSERT INTO akp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ɔbiara to ɔ̃atsiri mi ala wũ ɔso, ɣɛɛ ngɔ loaya teteree i kafɔkaɖe ame isɛ iabo kawirikɔ̃ ne, Ɣaa to ɔ̃atã wũ ngbã. ");
INSERT INTO akp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Si makpɛ̃gu mi i ɔmagɛ̃ ɔwɛ̃ ame ne, mitere mikɛlɛ ɔmama ame. Lobie sɔ lotã mi itsue sɔ miibaro karabara ɔbara i Israel simagɛ̃ ɔɖuɖu ame fiɛ Ɔturi Awune Ɔbi aakpese ɔba. ");
INSERT INTO akp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Rasuãdze kuwɛ̃ iisɛ ɔɖo ɔ̃ ratedze, fiɛ ɔɖabo kuwɛ̃ ana iisɛ ɔɖo ɔ̃ ɔkɔse. ");
INSERT INTO akp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ne ɔso ikote sɔ iawe rasuãdze ɔmɛrɛ̃ sɔ ɔ̃akotegu ɔ̃ ratedze, fiɛ ɔɖabo ɔ̃ wũ ne, iawe wũ ɔmɛrɛ̃ sɔ ɔ̃akotegu ɔ̃ ɔkɔse. Si mato makpere iyo ɔse sɔ Siwarã lalaa igara ne, mme iyere igbã maibakpere iyo maturi? ");
INSERT INTO akp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ne ɔso midaanigã maturi alasɔ ira biara nɛ mafu ara ne, mato maabusi ne. Fiɛ ira biara nɛ mabara i iwɛrɛ ame to iare kayi. ");
INSERT INTO akp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ara wa ɔɖuɖu loɣere mi i idududu ame ne, miɣɛ wã ku anɔwã fiɛ nwa nto loɣere mi i siwɔwɔi ame ne, mipɛ wã imomo. ");
INSERT INTO akp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Midaanigã mma loaɖoe siturina, ɣɛɛ maibawo ɔkala ɔɖoe. Ɣɛɛ minigã Ɣaa gɔ loawo siturina gu ɔkala ɔɖuɖu ɔwɔra i itɔkpe ame. ");
INSERT INTO akp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kapɛrɛ kere masɛ marɔdɛ̃ kunagini kunyɔ, ɣɛɛ maisɛ maɖoe kukawɛ̃ si mi Ɔse gɔ i Kato iitɔrã. ");
INSERT INTO akp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ɣɛɛ ta mi siwɛrɛ̃ dzɛ i mi ati iso ne, Ɣaa ɣe sɛ̃ kukame. ");
INSERT INTO akp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ne ɔso midaanigã alasɔ mifɔ kuɣa miɖo kunagini. ");
INSERT INTO akp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ngɔ loibakpɛ̃ kunuarɛ i wũ iso fiɛ ɔ̃aɣɛ i maturi katɔ̃ sɔ wũ ɔre ɔɖe ne, mme wũ loaɣɛ i wũ Ɔse gɔ i Kato kɔrɛ sɔ wũ ɔre ɔɖe. ");
INSERT INTO akp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ɣɛɛ ngɔ loasɛ̃ me i maturi katɔ̃ sɔ ɔ̃iɣe me ne, mme wũ loasɛ̃ wũ i wũ Ɔse gɔ i Kato kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Midaabu sɔ isobuɛ iɖe losu lobɔ kayiiso. Ooɣo! Iɣɛɣɛso iɖe lobɔ. ");
INSERT INTO akp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mabirɛrɛĩ to maata maya ma mase iso, fiɛ mabirɔ̃gomi ana to maata maya ma manyi iso. Mabi mare to maata maya i ma marã manyi iso. ");
INSERT INTO akp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ɔturi mɔmɔ iyo maturi loaɖe ɔ̃ matsirise. ");
INSERT INTO akp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ɔbiara gɔ loaɖɔɛ ɔ̃ ɔse ɣee ɔ̃ ɔnyi ɔɖo me iibawo wũ rasuãdze ɔɖe. Ngbɔ ame ngɔ nsɛ ɔɖɔɛ ɔ̃ ɔbi birɛrɛĩ ɣee ɔ̃ ɔbi birɔ̃gomi ɔɖo me iibawo wũ rasuãdze ɔɖe ne. ");
INSERT INTO akp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ngɔ loisore ɔ̃ inyɛwe ɔnyigbã ɔsiai wũ nsɛgbai ne, ɔ̃ibawo wũ rasuãdze ɔɖe. ");
INSERT INTO akp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ɔbiara gɔ loabie sɔ ɔ̃akɔkɔ ɔ̃ ngbã to ɔ̃ayura me, ɣɛɛ ɔbiara gɔ loasu ɔ̃ ngbã ɔtã ala wũ ɔso to ɔ̃ana ngbã. ");
INSERT INTO akp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ɔbiara gɔ loafɔ mi ne, mme iɖe ɔfɔ fiɛ ngɔ lofɔ me ne, ɔfɔ ngɔ lopia me katɔ̃me. ");
INSERT INTO akp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ɔbiara gɔ loafɔ Ɣaa kanyaɖidze ne, ɔto ɔ̃ana kaɖekɔ̃ i kanyaɖidze kuso ame. Ngɔ lofɔ ɔturi bɔlɔlɔa ala ɔ̃ sibɔlɔlɔ ɔso ne, ɔto ɔ̃afɔ sibɔlɔlɔ kuso. ");
INSERT INTO akp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mitã ikpa mi sekelee sɔ ɔrere gɔ loatã wũ masiaidze koso magbe ndu yululua ikɔi ala wũ ɔso ne, ɔto ɔ̃afɔ ne kuso kokooko.” ");
INSERT INTO akp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ɔwi gɔ i Yesu ɔɔro ɔ̃ marasuãdze katɔ̃me ɔpia ne, ɔrui i mmɔ ɔkɛlɛ sɔ ɔ̃ate ara ɔɣɛ Ɣaa Itɔ̃me i simagɛ̃ dzɛ mpia i mmɔ ame. ");
INSERT INTO akp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Gɔ ndupiedze Yohanes gɔ mamɔɛ̃ marara i iyo ɔnɔ ara wa i Kristo to ɔbara ne, ɔpia ɔ̃ marasuãdze mawɛ̃ Yesu kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Masɛ maakarɛ wũ sɔ, “Fɔ nɖe ngɔ maɣɛ sɔ ɔ̃aba ɛɛbɛrɛ bonyɔ ɔmama ɔri?” ");
INSERT INTO akp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ne Yesu to ɔtã ma mmuai sɔ, “Mikpese miaɣere Yohanes ara wa minya gu nwa minɔ. ");
INSERT INTO akp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Manɔbiɛdze to manya, mabafã to masɛ, mma nto manyɛ ɔnyɛ rɛtɛa iso to isekele, makpise to mata, fiɛ mato maɣere mawɛrɛba ana Itɔ̃me Bielea. ");
INSERT INTO akp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","So aaɣɔ mma i wũ kurabarara iita kuya iso.” ");
INSERT INTO akp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ɔwi gɔ mma i Yohanes ɔpia katɔ̃me ɔɔkpese mato makɛlɛ ne, Yesu ɔtsɛ ika iɖe i ɔ̃ iso iɣere mma losakanya i mmɔ sɔ, “Ɔwi gɔ mibɔrɛ mikɛlɛ Yohanes kɔrɛ i fafuĩ ame ne, be iɖe minyɔ ɔri sɔ mianya? Iyata nɛ i ɔwiri to ɔtidza? ");
INSERT INTO akp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Be mibɔrɛ misɛ mianyɔ? Ngɔ mpia ɔgo awu? Mma mpia ɔgo awu ne, magara ayo mapia. ");
INSERT INTO akp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mibua miɣere me nnɛ misɛ mianyɔ. Ɣaa kanyaɖidze? Gbaã nto loɣere mi sɔ ɔɖo Ɣaa kanyaɖidze. ");
INSERT INTO akp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Alasɔ ɔ̃ iso i Ɔko Sekelea ɔɣɛ sɔ, ‘Loasese kpabo ɔɖe-ɔ katɔ̃, sɔ ɔ̃aledza maturi ɔtã fɔ iba.’ ");
INSERT INTO akp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Gbaã nto loɣere mi sɔ Yohanes ɔɖo ɔturi igbã biara gɔ maɣe i kayi gagbe ame. Ɣɛɛ ngɔ lokoso ɔɖo i Ɣaa sigarakaɖekɔ̃ ɔɖo wũ. ");
INSERT INTO akp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ita i ɔwi gɔ i Ndupiedze Yohanes ɔtsɛ ɔ̃ itɔ̃me iɣɛ ipɛ i nɔme ne, maturi to makpɛ̃gu Ɣaa sigarakaɖekɔ̃, ɣɛɛ mma i anɔ ɔrɛtɛ mato mabie Ɣaa sigara iɖe kotoo loabo i mmɔ. ");
INSERT INTO akp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mose mmara gu Ɣaa kanyamaɖidze ɔɖuɖu ɔɖe ika i Ɣaa sigarakaɖekɔ̃ iso iba iabo Yohanes ɔwi iso. ");
INSERT INTO akp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Fiɛ si mibie sɔ miafɔ ma miɖe ne, minɔ sɔ Yohanes nɖe Eliya gɔ maɣɛ masɛ sɔ ɔ̃aba. ");
INSERT INTO akp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ngɔ mba atsue si ɔnɔ nnɛ loto loɣɛ. ");
INSERT INTO akp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Kiniɔ ne, be loasu nɔme maturi lokateragu? Mase lɛ mabiɛtɛ ma nto maɣa kaɣa i kuɣa ame. Ma malaa to maɣere ma sɔ, ");
INSERT INTO akp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Boka isoɣɔ aka botã mi, miitɔ, boɖi sikubiɛnɔ ana botã mi, mmɔ ana miibiɛ kaku.’ ");
INSERT INTO akp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Gɔ Yohanes ɔba ɔ̃ito ɔɖe ara ɔnɛ ndã mɛ loamɔɛ̃ ne, maturi sɔ siwarã lalaa mpia i ɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ɣɛɛ gɔ mme, Ɔturi Awune Ɔbi, ɔba fiɛ loto loɖe ara lonɛ ndã ne, maturi to maɣɛ sɔ, ‘Minyɔ ɖeɖei gu tarɛ̃dze gɔgbe! Ɔɖe ma lampofɔdze gu makpibaradze ɔlaa.’ Ɣɛɛ ne, Ɣaa iwola sɛ ite so i ɔturi nsɛgbai ame.” ");
INSERT INTO akp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Simagɛ̃ dzɛ ame i Yesu ɔbara awawãra gbodzoo maturi iifiniki, ne ɔso ɔbiɛ ma ɔɣɛ sɔ, ");
INSERT INTO akp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ndzo miɖe mitã mi Korazin maturi! Ndzo miɖe mitã mi Betsaida maturi! Alasɔ si awawãra wa igbã lobara i mi ame iɖe lobara i Tiro gu Sidon simagɛ̃ ame ne, tee maakpase masɛ i ndɔ̃ ame mapia ara wa loate sɔ maɔfiniki mabɔrɛ i ma akpi ame. ");
INSERT INTO akp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nto loɣere mi gbagbaã sɔ i atɔ̃me iɣɛyi ne, Ɣaa to ɔ̃anyɔ Tiro gu Sidon simagɛ̃ nnya ɔɖo mi. ");
INSERT INTO akp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mi Kapernaum maturi ne, i mi adzuni ame ne, mito mibie sɔ miakɔlɛ so kato misɛ miabo kato, ɣɛɛ Ɣaa to ɔ̃abɔ mi karɔ̃ mikɛlɛ ta ikpibiɔ. Alasɔ si awawãra wa lobara i fɔ ame mabara i Sodom ne, tee ɔmagɛ̃ gɔmɔ se ipɛ i nɔme. ");
INSERT INTO akp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nto loɣere-ɔ sɔ Ɣaa to ɔ̃anyɔ Sodom nnya ɔɖo-ɔ ku atɔ̃me iɣɛyi ɔɖo mi.” ");
INSERT INTO akp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ɔwi gɔmɔ ame ne, Yesu ɔɣɛ sɔ, “Tete, Kato gu Karɔ̃ Sate, nto lole-ɔ sɔ ara wa lowɛrɛ manɔgbadze gu makotsuese ne, aɖi wã ate mabiɛtɛ. ");
INSERT INTO akp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Alasɔ gbaã ne Tete, ngbɔ ikote-ɔ ne. ");
INSERT INTO akp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tete ɔsu ara ɔɖuɖu ɔpia me i nrɔɔ̃ ame. Kuwɛ̃kuwɛ̃ iiɣe Ɔbi iɖo Ɔse fiɛ kuwɛ̃ ana iiɣe Ɔse iɖo Ɔbi gu mma i Ɔbi ɔbie sɔ ɔ̃aɖi ɔ̃ Ɔse ɔte. ");
INSERT INTO akp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Mibore miba wũ kɔrɛ mi ma ɔɖuɖu nsore ato fiɛ iɔɖa mi si loatã mi iwarã. ");
INSERT INTO akp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Misu wũ ɔnyigbã misia so iso si misuã ara mibɔrɛgu i wũ kɔrɛ si miana iwarã alasɔ wũ kayiri ɔɣɔ fiɛ lobɔ so karɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Wũ ɔnyigbã se pɔkɔsɔɔ ku isore fiɛ wũ ato wa loasorera mi ana se foforoo.” ");
INSERT INTO akp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ɔwi gɔmɔ kama ne, gɔ Yesu sɛ ɔto ɔfe i kakpɛkɔ̃ kawɛ̃ ame ku Iwarãyi ne, kukã ɔkpɛ̃ ɔ̃ marasuãdze, ne ɔso mabɛse atita matsɛ iwe. ");
INSERT INTO akp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Gɔ ma Farisise ɔnya ne, maɣere Yesu sɔ, “Nyɔ, fɔ marasuãdze to mabara nnɛ i mmara iitã ɔri sɔ maabara ku Iwarãyi.” ");
INSERT INTO akp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Mmɔ i Yesu to ɔtã ma mmuai sɔ, “Miika i Ɔko Sekelea ame nnɛ i David ɔbara ɔwi gɔ i kukã ɔkpɛ̃ wũ gu ɔ̃ maturi? ");
INSERT INTO akp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ɔbo i Ɣaa iyo ame ɔsɛ ɔ̃asu aɖera wa masu masɔrɛ Ɣaa maɖe gɔ iikote sɔ ɔ̃ gu ɔ̃ maturi aaɖe iɖo Ɣaa masɔrɛdze ɔnɔwɛ̃. ");
INSERT INTO akp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ɛɛbɛrɛ miika i mmara ame sɔ masɔrɛdze ma nsɛ mabara karabara i isɔrɛyo sɛ matu Iwarãyi mmara ku Iwarãyi biara ɣɛɛ maiɖe ipɔ? ");
INSERT INTO akp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nto loɣere mi sɔ nnɛ loɖo Ɣaa isɔrɛyo pia i mi ndɛ̃ ngbe. ");
INSERT INTO akp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ɣaa ɔɣɛ i Ɔko Sekelea ame sɔ, ‘Nnyainyɔ nto lobie ne iiɖe mabɔi ma mafɛ̃ ala ara matã me.’ Si ɔnɔ minɔ itɔ̃me nɛgbe karɔ̃ kukaakɔ ne, tee mma loiɖe ipɔ ne, miibatã ma ipɔ. ");
INSERT INTO akp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Alasɔ Ɔturi Awune Ɔbi nɖe Iwarãyi Sate.” ");
INSERT INTO akp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Gɔ Yesu ɔrui i mmɔ ne, ɔkɛlɛ ma Yudase kasarɛkɔ̃ kawɛ̃. ");
INSERT INTO akp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ɔrɛrɛ̃ ɔwɛ̃ gɔ kɔrɔ̃ lokarĩ ɔwe i mmɔ. Mawɛ̃ ma nto mabie ɔri gɔ iso maaki fiɛ maaɖaɛ Yesu kanya ɔkarɛ wũ sɔ, “Mmara ɔtã ɔri sɔ maasa ɔturi ku Iwarãyi?” ");
INSERT INTO akp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ne Yesu ana ɔkarɛ ma sɔ, “Mi ndɛ̃ nna sɛrɛrerɔ̃ loakpase ɔbo i iwo ame ku Iwarãyi fiɛ ɔ̃ibaso ɔbo ɔɖi wũ? ");
INSERT INTO akp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ɣɛɛ ne, ɔturi ɔfɔ kuɣa ɔɖo sɛrɛrerɔ̃, ne ɔso mmara ɔtã ɔri sɔ ɔturi aabara isɛɛ ku Iwarãyi.” ");
INSERT INTO akp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ne Yesu ɔɣere ngɔ kɔrɔ̃ lokarĩ sɔ, “Nabarã fɔ kɔrɔ̃.” Ɔnabarã kɔ̃, ɔluwɛ̃ ne, ilɛ wũ kɔrɔ̃ karĩa ɔse lɛ ngɔ nsarɛ. ");
INSERT INTO akp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ma Farisise ɔrui i mmɔ masɛ maasɛ iti ame sɔ maaɖoe Yesu. ");
INSERT INTO akp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Gɔ Yesu ɔnɔ sɔ maɔbara adzuni sɔ maaɖoe wũ ne, ɔrui i mmɔ. Maturi gbodzoo ɔsiai wũ fiɛ ɔsa manyɛse ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ɣɛɛ ɔsɛ̃ ɔtã ma sɔ madaaɖi wũ mate ngɔ ɔɖe. ");
INSERT INTO akp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ɔbara ngbɔ, ne ɔso Ɣaa itɔ̃me nɛ maɣɛ i Kanyaɖidze Yesaya ɔko ame aaba i ne ame gbaã sɔ, ");
INSERT INTO akp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Wũ ɔɖabo gɔ loɖi lotã so i ngbe ne. Ɔmɔɛ̃ me ɔtu fiɛ loipia wũ kuɣɛ. Loafedza wũ Siwarã lofere wũ iso sɔ ɔ̃apɛ wũ atɔ̃me iɣɛgu imomo ɔtã abuiti ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ɔ̃ibakpadzɛ̃gu kuwɛ̃ atɔ̃me fiɛ ɔ̃ibafafã kuwɛ̃ ana. Kuwɛ̃ iibanɔ wũ silɔ i ɔgbami. ");
INSERT INTO akp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ɔto ɔ̃aɣara so ɔtã mma nna ɔle. Ɔto ɔ̃awe kayiribielea ɔtã mma i kayi ɔɔtɔrɛ. Ɔto ɔ̃akɛlɛgu i katɔ̃ ngbɔ gbɔgbɔɔgbɔ atɔ̃me iɣɛ tɔrɔrɔ aaɖe iso. ");
INSERT INTO akp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Abuiti ɔɖuɖu maturi to maasu ma ɔriinyɔ mapia i ɔ̃ ame.” ");
INSERT INTO akp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mawɛ̃ ɔkɔ ɔrɛrɛ̃ ɔwɛ̃ gɔ ame i siwarã lalaa pia fiɛ ɔɖe nɔbiɛdze gu ɔmumu mabɔ Yesu kɔrɛ. Yesu Ɔsa wũ ne ɔso ɔtsɛ ika iɖe fiɛ ɔtsɛ ara inya ana. ");
INSERT INTO akp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nnɛgbe ɔbara iturikuri nɛmɔ ɔɖuɖu ɣii, ne mato makarɛ so sɔ, “Iiɖe Igara David Ɔwa gɔ maɣɛ masɛ sɔ ɔ̃aba ɔɖe ngbe ɣɛɛ?” ");
INSERT INTO akp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Gɔ ma Farisise ɔnɔ nnɛgbe ne, ma wũ maɣɛ sɔ, “Si iiɖe siwarã lalaa igara Beelzebul ɔɖe lotã wũ ɔle ne, tee ɔ̃ibawo siwarã lalaa ɔsa ɔɖi i maturi ame.” ");
INSERT INTO akp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu ɣe ma adzuni, ne ɔso ɔɣere ma sɔ, “Karɔ̃ biara ga maturi loɣɛɣɛ so fiɛ mata maɣɛ so iso aakpese ikpakpi. Ngbɔ ame i ɔmagɛ̃ ɣee iyo biara nɛ maturi loɣɛɣɛ so fiɛ mata maɣɛ so iso iibawo ɔya ne. ");
INSERT INTO akp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ne ɔso si Ɔbosam sigarakaɖekɔ̃ ɔta siɣɛ so iso ne, nda ɔ̃abara fiɛ ɔ̃ sigarakaɖekɔ̃ aaya? ");
INSERT INTO akp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Si mi sɔ Beelzebul lotã me ɔle fiɛ nto losa siwarã lalaa ne, iyɔ nna ɔle iso i mi masiaidze to maki mato masa sɛ̃? Nnɛ i mi masiaidze to mabara loatã mi ipɔ. ");
INSERT INTO akp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ɣɛɛ si Ɣaa Siwarã ɔle ame nto losa siwarã lalaa ne, mitsue kukaakɔ sɔ Ɣaa sigara ɔɖewi ɔɔba ɔ̃abo mi ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Kuwɛ̃ iibawo ɔturi gɔ mba ɔle iyo ɔbo ɔmala ɔ̃ ara iɖo sɔ ɔ̃aɖe katɔ̃ ɔmɔɛ̃ wũ, ɔnyi wũ tɔtɔ fiɛ ɔ̃abo i ɔ̃ iyo ɔmala ɔ̃ ara. ");
INSERT INTO akp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ngɔ loiɣɛ me i kama ne, ɔta ɔɣɛ me iso, fiɛ ngɔ loito ɔsagu me ara kanya ne, ara ɔto ɔsamarã. ");
INSERT INTO akp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ne ɔso nto loɣere mi sɔ Ɣaa to ɔ̃asu ikpi igbã biara ku inyakpi igbã biara nɛ i maturi ɔɣɛ ɔtsɛ ma, ɣɛɛ ngɔ loaɣɛ inyakpi i Siwarã Bielea iso ne, Ɣaa iibasu ɔtsɛ wũ ɔnya. ");
INSERT INTO akp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ɔbiara gɔ loaɣɛ inyakpi i mme, Ɔturi Awune Ɔbi, iso ne, Ɣaa to ɔ̃asu ɔtsɛ wũ, ɣɛɛ ngɔ loaɣɛ inyakpi i Siwarã Bielea iso ne, Ɣaa iibasu ɔtsɛ, kiniɔ ɣee ɔwi gɔ nto ɔba i katɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Si kudziri lɛ ne, kɔ̃ abi ana sɛ alɛ, ngbɔ ame si kudziri iilɛ ne, kɔ̃ abi ana iisɛ alɛ. Abi wa i kudziri ɔɣɔ̃ nsɛ iɖi ite kudziri gɔ igbã kuɖe. ");
INSERT INTO akp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mi ma lonyanyarĩ lɛ maɣɛ! Nda miabara fiɛ miawo ara sɛɛ ɔɣɛ gɔ miɖe maturi lalaa? Alasɔ nnɛ loyi ɔturi ɔtu ame i kanya sɛ kaɣɛ. ");
INSERT INTO akp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ɔturi sɛɛ ne, ara sɛɛ ɔsɛ ɔɖi ɔbɔrɛgu i ɔ̃ ara sɛɛ kakɔlakɔ̃ i ɔ̃ ame fiɛ ɔturi lalaa ana ne, ara lalaa ɔsɛ ɔɖi ɔbɔrɛgu i ɔ̃ ara lalaa kakɔlakɔ̃ ga i ɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nto lotã mi itsue sɔ ɔbiara to ɔ̃atã itsuɛpɛ̃ biara nɛ ɔtua ɔsɛ kere kuso ku atɔ̃me iɣɛyi iso. ");
INSERT INTO akp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Alasɔ fɔ mɔmɔ kanya ame atɔ̃me maasu matã-ɔ ibɛ ɣee ipɔ.” ");
INSERT INTO akp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mmara matedze mawɛ̃ gu ma Farisise mawɛ̃ ɔɣere wũ sɔ, “Ratedze, boto bobie sɔ bara iwawãra irere si bofɔ-ɔ boɖe.” ");
INSERT INTO akp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ne Yesu ɔtã ma mmuai sɔ, “Minyɔ kumɛgɔ i kiniɔgbe maturi ba ɔtile fiɛ maisɛ manigã Ɣaa. Mato mabie iwawãra sɔ maanya, ɣɛɛ miibanya kuiwɛ̃ iɖo Ɣaa kanyaɖidze Yona ire igbã. ");
INSERT INTO akp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kumɛgɔ ame i Yona ɔwe i ikpɛ iyiri ame akpɛnɛ atɛ kasɛ̃ aka atɛ ne, ngbɔ ame i Ɔturi Awune Ɔbi ana aawe i karɔ̃ ame akpɛnɛ atɛ kasɛ̃ aka atɛ ne. ");
INSERT INTO akp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","I atɔ̃me iɣɛyi ne, Niniwe maturi to maatã mi ipɔ alasɔ mafiniki gɔ Yona ɔɣere ma Ɣaa itɔ̃me. Ɣɛɛ lobie sɔ mitsue sɔ ngɔ loɖo Yona pia i mi ndɛ̃ ngbe. ");
INSERT INTO akp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Atɔ̃me iɣɛyi ne, Igararɔ̃go gɔ lobɔrɛ i bo karɔ̃ kala isɛ to ɔ̃ata ɔya ɔtã mi kiniɔgbe maturi ipɔ alasɔ ɔsɛ ɔri dzoroo ɔbɔrɛ i kayi iti tsɔra ɔba ɔ̃akã Salomo atɔ̃me wa ame i inɔgba pia atsue. Ɣɛɛ nto loɣere mi sɔ ngɔ inɔgba loɖo Salomo ire pia i mi ndɛ̃ ngbe. ");
INSERT INTO akp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Si masa siwarã lalaa maɖi i ɔturi ame ne, sisɛ sikɛlɛ siawe siki sibie kawekɔ̃ i kakorekɔ̃. Si siina kukakɔi ne, ");
INSERT INTO akp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","sisɛ siɣere so sɔ, ‘Loakpese lokɛlɛ iyo nɛ ame masa me maɖi.’ Siaba sianya sɔ mmɔ se ikunu, maɔfiɛ iyo ame, maledza ira biara isɛ kukaakɔ. ");
INSERT INTO akp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Iyɔ siakpese sikɛlɛ siakɔ siwarã lalaa aka akɔdzɛ mama dzɛ lonyanyarĩ siɖo sɛ̃ sibua so iso. Maabo i ngɔmɔ ame mawe, ne ɔso ɔ̃ kawirikɔ̃ to kaanyanyarĩ kaɖo ɔ̃ karɔ̃kasɛkɔ̃. Ngbɔ tutuutu iase itã nɔme maturi ma lonyanyarĩ ngbe ne.” ");
INSERT INTO akp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ɔwi gɔ i Yesu to ɔɣɛ nwagbe ne, ɔ̃ ɔnyi gu manyiibi ɔba maɣɛ i inyamɔ mato mabie sɔ maɖegu wũ ika. ");
INSERT INTO akp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ne ɔso mma nɣɛ i mmɔ ɔwɛ̃ ɔɣere wũ sɔ, “Nyɔ, fɔ ɔnyi gu manyiibi ɣɛ i inyamɔ mato mabie sɔ manya-ɔ.” ");
INSERT INTO akp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu ɔtã mmuai sɔ, “Nna nɖe wũ ɔnyi gu manyiibi?” ");
INSERT INTO akp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ne ɔsɔ̃ ɔ̃ marasuãdze kɔrɔ̃ ɔɣɛ sɔ, “Minyɔ wũ ɔnyi gu manyiibi! ");
INSERT INTO akp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ɔbiara gɔ nsɛ ɔbara Tete gɔ i Kato kuɖɔɛ ne, ɔ̃ nɖe wũ ɔnyiibi rɛrɛ̃ gu ɔnyiiko gu wũ ɔnyi ne.” ");
INSERT INTO akp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Iyi nɛmɔ ame ne, Yesu ɔbɔrɛ i iyo ɔsɛ ɔ̃asɛ i ɔpo kanya ɔtsɛ ara ite. ");
INSERT INTO akp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Gɔ mma loki malɔ wũ ɔsi ɔso ne, ɔya ɔbo i ɔkolo ame i ndu iso fiɛ maturi ka maɣɛ i ɔkpokpo. ");
INSERT INTO akp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ɔte ma ara gbodzoo i agbã ame. Ɔɣere ma sɔ, “Kpɛ̃dze ɔwɛ̃ ɔsɛ ɔraɖui kasakɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Gɔ ɔto ɔsa ne, ɔwɛ̃ ɔɣo i ɔri kuruɛ, ne kurodzai ɔrɛrɛ kuɖe ne. ");
INSERT INTO akp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ɔwɛ̃ ɔɣo i ata iso ngbegɔ i sise iisi, ne ɔso ɔre mala. ");
INSERT INTO akp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Gɔ kuɣɛ̃ ɔsia kere ne, ɔ̃ ɔɖuɖu ɔkpi alasɔ ɔ̃ siɖu iibo karɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ɔraɖui ɔwɛ̃ ana ɔɣo i kuposɛ̃ ame, ne ɔso gɔ ɔre ne, kuɣa kufu wũ iso. ");
INSERT INTO akp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ɣɛɛ ɔwɛ̃ ana ɔɣo i karɔ̃ sɛɛ iso, ne ɔso ɔbara kukaakɔ. Ɔwɛ̃ ɔɣɔ̃ abi kulafa, ɔwɛ̃ abi sikuɔ, ɔwɛ̃ ana abi sitɛ.” ");
INSERT INTO akp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ne Yesu ɔwirigu ma sɔ, “Ngɔ mba atsue si ɔnɔ nnɛ nto loɣɛ.” ");
INSERT INTO akp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ne marasuãdze ɔba maakarɛ Yesu sɔ, “Be ɔso fiɛ asɛ asu agbã ate maturi ara?” ");
INSERT INTO akp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ɔtã ma mmuai sɔ, “Mi ne, Ɣaa ɔɖi ɔ̃ sigarakaɖekɔ̃ awɛrɛra karɔ̃ ɔte mi, ɔ̃iɖi ɔte matsɔra. ");
INSERT INTO akp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Alasɔ ngɔ mba ara ne, maatã wũ ara ɔ̃ ara ɔsi abua, ɣɛɛ ngɔ ina ne, kɛkɛĩ gɔ ame ɔba ne, maamɔɛ̃ mafɔ wũ iso. ");
INSERT INTO akp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nnɛ ɔso nto lote ma ara i agbã ame nɖe sɔ, mato manya ara, ɣɛɛ maito manya maɖi ite, mato makã atsue, ɣɛɛ maito manɔ fiɛ maaba maanɔ karɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Itã sɔ Kanyaɖidze Yesaya itɔ̃me nɛ ɔɣɛ ɔsɛ ɔba i ne ame sɔ, ‘Mmagbe to maanɔ ara, manɔ ara, ɣɛɛ maibanɔ karɔ̃! Mato maanyɔ ara, manyɔ ara, ɣɛ maibanya maɖi ite. ");
INSERT INTO akp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Alasɔ ma adzuni ɔrɛ sirɛ fiɛ matɛ̃ra atsue sɔ maibanɔ mama anɔmi ana sɔ ma anɔmi iibanya. Si iiɖe ngbɔ ne, tee maanya ala anɔmi fiɛ ma atsue aanɔ sɔ maanɔ karɔ̃ fiɛ maafiniki maba wũ kɔrɛ fiɛ loasa ma!’ ");
INSERT INTO akp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ɣɛɛ mi ne, iti ɔbua ilɛ mi sɔ mi anɔmi to anya ara fiɛ mi atsue ana to anɔ ara. ");
INSERT INTO akp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nto loɣere mi sɔ ne, Ɣaa kanyamaɖidze gbodzoo gu maturi bɔlɔlɔa ɔbie teteree sɔ si manya ara wa mito minya, ɣɛɛ mainya, ɣee si manɔ ara wa mito minɔ, ɣɛɛ mainɔ.” ");
INSERT INTO akp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesu ɔɣere ma sɔ, “Mikã atsue si loɖi ɔraɖuisadze igbã karɔ̃ lote mi. ");
INSERT INTO akp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ngɔ nto lonɔ Sigarakaɖekɔ̃ iso itɔ̃me fiɛ ɔ̃ito ɔnɔ karɔ̃ se lɛ ɔraɖui gɔ loɣo i ɔri kuruɛ. Tsirise sɛ ɔba ɔ̃amɔɛ̃ itɔ̃me nɛ ɔnɔ ɔɖi i ɔ̃ ɔtu ame. ");
INSERT INTO akp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ɔraɖui gɔ loɣo i ata karɔ̃ iso se lɛ ngɔ lonɔ fiɛ ɔfɔ ne ku isoɣɔ ɔluwɛ̃. ");
INSERT INTO akp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ɣɛɛ gɔ ɔ̃ siɖu iibo karɔ̃ kukaakɔ ɔso ne, si kutsuɛ iɖaa gu kama iti ɔba ala itɔ̃me iti ne, ɔsɛ ɔkpese kama. ");
INSERT INTO akp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ɔraɖui gɔ loɣo i kuposɛ̃ ame nɖe ngɔ lonɔ itɔ̃me, ɣɛɛ imararãso gu karana itere isiai sɛ iɣa ifu itɔ̃me sɔ ɔ̃isɛ ɔwo abi ɔɣɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ɔraɖui gɔ loɣo i karɔ̃ sɛɛ iso nɖe ngɔ lonɔ itɔ̃me fiɛ ɔnɔ ne karɔ̃. Ɔsɛ ɔɣɔ̃ abi, mawɛ̃ abi kulafa, mma sikuɔ fiɛ mawɛ̃ ana abi sitɛ.” ");
INSERT INTO akp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu ɔpɛ ma igbã mama ana ɔɣɛ sɔ, “Ɣaa sigarakaɖekɔ̃ se lɛ ɔrɛrɛ̃ ɔwɛ̃ gɔ lopɛ ɔraɖui sɛɛ i ɔ̃ kakpɛkɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kasɛ̃ gɔ maturi ka marɛ ne, ɔ̃ tsirise ɔsɛ ɔ̃asa sikua abi i ɔraɖui ame ɔledza ibɔrɛ malaa. ");
INSERT INTO akp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ɔwi gɔ i kamɔ ɔmɔ fiɛ kaatsɛ iɣe ne, sikua dzɛ i tsirise ɔsa ana ɔre. ");
INSERT INTO akp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Ɔrɛrɛ̃ gɔmɔ maɖabo ɔba maatu wũ maɣere wũ sɔ, ‘Bokɔse, iiɖe kamɔ sɛɛ kaɖe ako i kakpɛkɔ̃ ame? Lɛ i sikua dzɛgbe ɔse i kamɔ ame?’ ");
INSERT INTO akp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ne kakpɛkɔ̃ sate to ɔɣere ma sɔ, ‘Tsirise ɔɖe lobara karabara gagbe.’ “Ne maɖabo to makarɛ wũ sɔ, ‘Ato abie sɔ borurui sɛ̃ boɖi?’ ");
INSERT INTO akp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ɔtã ma mmuai sɔ, ‘Ooɣo. Si misɛ miatsɛ sikua irurui ne, mito miarurui kamɔ ana mibua i sɛ̃ iso. ");
INSERT INTO akp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mitã sikua gu kamɔ ɔɖuɖu si maya isɛ iabo kamɔ ɔruiwi si loatã marabaradze ɔɖe katɔ̃ maruɛ sikua matsuedza tɔtɔ fiɛ maarui kamɔ masɛ maafere i kawu ame.’ ” ");
INSERT INTO akp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu Ɔledza ma igbã mama ipɛ iɣere ma sɔ, “Ɣaa sigarakaɖekɔ̃ se lɛ idziribi kosoi iwɛ̃ nɛ i ɔrɛrɛ̃ ɔwɛ̃ ɔsu ɔsɛ ɔ̃apɛ i ɔ̃ ayo ame kakpɛkɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Idziribi nɛgbe ɔkoso iɖo atsɔra ɔɖuɖu, ɣɛɛ si imɔ ne, isɛ imɔ iɖo ayo ame kakpɛkɔ̃ ame siraɖui ɔɖuɖu ikpese kadzirimi ga akpa ame i kurodzai aabara ayo kuwe.” ");
INSERT INTO akp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu ɔledza ma igbã ipɛ iɣɛ sɔ, “Ɣaa sigarakaɖekɔ̃ se lɛ inyagɛ̃ kua gɔ i ɔrɔ̃go ɔwɛ̃ ɔsu ɔpia i mmɔre mɛ losi ame, ɔkpɔkɔtɔ ɔsakanya gbɔgbɔɔgbɔ mmɔre ɔɖuɖu ɔnyagɛ̃.” ");
INSERT INTO akp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu ɔki i agbã ame ɔte iturikuri nɛgbe ara wagbe ɔɖuɖu. Ɔ̃isɛ ɔɖe ma ika si iiɖe igbã ɔto ɔpɛ ma. ");
INSERT INTO akp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ɔbara ngbɔ gɔ itã sɔ nnɛ i Ɣaa kanyaɖidze ɔɣɛ ɔsɛ ɔba i ne ame sɔ, “Loaɖe ma ika i igbã ame. Fiɛ loaɖi ara wɛrɛa wa mpia ita i kayi karɔ̃kasɛkɔ̃ lote ma.” ");
INSERT INTO akp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Gɔ Yesu ɔɔɖi iturikuri nɛmɔ ɔri fiɛ ɔba iyo ne, ɔ̃ marasuãdze ɔba ɔ̃ kɔrɛ maba maaɣere wũ sɔ, “Ɖi igbã nɛ apɛ i sikua dzɛ mpia i ɔraɖui ame mmɔ karɔ̃ tã bo.” ");
INSERT INTO akp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu ɔɣere ma sɔ, “Ngɔ nto ɔpɛ ɔraɖui nɖe mme, Ɔturi Awune Ɔbi. ");
INSERT INTO akp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kakpɛkɔ̃ nɖe kayiiso. Mma nɖe Ɣaa sigarakaɖekɔ̃ maturi nɖe ɔraɖui gɔ mapɛ i kakpɛkɔ̃ ame. Tsirise masiaidze nɖe sikua. ");
INSERT INTO akp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Tsirise gɔ losa sikua nɖe Ɔbosam. Ɔraɖui ɔsɔrɛ̃wi nɖe kayi kawirikɔ̃, fiɛ mma loasɔrɛ̃ ɔraɖui nɖe Ɣaa makpabo. ");
INSERT INTO akp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Kumɛgɔ masa sikua kanya fiɛ matsuedza sɛ̃ ne, ngbɔ ame iase ku kayi kawirikɔ̃ ne. ");
INSERT INTO akp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mme, Ɔturi Awune Ɔbi, to loapia wũ makpabo sɔ masa mma ɔɖuɖu lokɔ maturi mapia i ikpi ame gu mma lobara ara lalaa kanya. ");
INSERT INTO akp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mato maasu ma mafuĩdza mapia i itɔkpe nɛ nto itsue ame ngbegɔ maabiɛ kaku maɖo arɔĩ makpa. ");
INSERT INTO akp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ɣɛɛ Ɣaa maturi to maafiɛ lɛ kuɣɛ̃ i ma Ɔse sigarakaɖekɔ̃ ame. Ngɔ mba atsue si ɔnɔ nnɛ nto loɣɛ! ");
INSERT INTO akp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ɣaa sigarakaɖekɔ̃ se lɛ karana ga makɔla i kakpɛkɔ̃ ame fiɛ ɔrɛrɛ̃ ɔwɛ̃ ɔnya ɔsu ɔledza isu ikɔla. Ɔna isoɣɔ gbaã, ne ɔso ɔsɛ ɔ̃asu ɔ̃ ira biara ɔrɔdɛ̃ ɔsu sikã ɔsɛ ɔ̃aɣa kakpɛkɔ̃ gamɔ.” ");
INSERT INTO akp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesu ɔɣere ma ana sɔ, “Ɣaa sigarakaɖekɔ̃ se lɛ kuɣaɖese ɔwɛ̃ gɔ nto ɔbie anyi wa lofɔ kuɣa. ");
INSERT INTO akp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Gɔ ɔsɛ ɔ̃anya kuwɛ̃ gɔ lobua kufɔ kuɣa ne, ɔsɛ ɔ̃asu ɔ̃ ira biara nɛ ɔba ɔrɔdɛ̃ ɔsu sikã ɔsɛ ɔ̃aɣa kɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ana ne, Ɣaa sigarakaɖekɔ̃ ɔre asabu wa mapia i ɔpo ame fiɛ maɖi akpɛ agbãagbã. ");
INSERT INTO akp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Gɔ asabu ɔyi ne, makpadzɛ̃ wã mabɔ ɔkpokpo fiɛ marɛrɛ akpɛ ame, maɖi nwa masɛ maɖe mafere i kusɛsɛi ame. Nwa maiɖe ana ne, mabodza wã mawiri. ");
INSERT INTO akp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ngbɔ ame iase ku kayi kawirikɔ̃ ne. Ɣaa makpabo to maabɔrɛ makɛlɛ maarɛrɛ maturi sɛɛ maɖi i malalaa ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Mato maasu maturi lalaa mafuĩdza mapia i itɔkpe ame ngbegɔ maabiɛ kaku maɖo arɔĩ makpa.” ");
INSERT INTO akp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu ɔkarɛ ma sɔ, “Minɔ ara wa loɣere mi i ngbe karɔ̃?” Matã mmuai sɔ, “Aĩ, bonɔ.” ");
INSERT INTO akp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ne ɔɣere ma ana sɔ, “Mmaratedze biara gɔ lokpese Ɣaa sigarakaɖekɔ̃ rasuãdze ne, ɔse lɛ iyosate gɔ nsɛ ɔɖi ara kuere gu aɣɛtɛ ɔbɔrɛgu i ɔ̃ iyo ame ɔte.” ");
INSERT INTO akp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Gɔ Yesu ɔpɛ agbã wagbe ɔro ne, ɔrui i mmɔ. ");
INSERT INTO akp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ɔkpese ɔkɛlɛ ma aɖe fiɛ ɔsɛ ɔ̃ate ara i ma kasarɛkɔ̃ gɔ ibara mma lonɔ ɔ̃ atɔ̃me ɣaa mato makarɛ sɔ, “Lɛ i ngɔgbe ɔsuã inɔgba nɛgbe ɔbɔrɛgu? Fiɛ lɛ ɔbɔrɛgu awawãra wagbe igbã? ");
INSERT INTO akp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Iiɖe rawedze ɔbi ɔɖe ngbe ɣɛɛ? Iiɖe Maria ɔbi ɔɖe fiɛ ɔ̃ manyiibi nɖe Yakobo gu Yosef gu Simon gu Yuda ma mpia i bo ndɛ̃? ");
INSERT INTO akp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ɔ̃ manyiiko ana pia i bo ndɛ̃ ni! Lɛ kowũ ɔna ara wagbe ɔɖuɖu ɔbɔrɛgu?” ");
INSERT INTO akp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ɔ̃ ara ɔtsue ma anɔ, ne ɔso maifɔ wũ. Ne ɔso ɔɣere ma sɔ, “Ɣaa kanyaɖidze ba kuwarɛ i kakɔi biara iɖo ɔ̃ mɔmɔ ɔmagɛ̃ gu ɔ̃ maturi kɔrɛ.” ");
INSERT INTO akp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Gɔ maifɔ wũ maɖe ɔso ne, ɔ̃iwo awawãra gbodzoo ɔbara i ma ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ɔwi gɔmɔ ne, Herodes gɔ nto ɔɖe sigara i Galilea ɔnɔ Yesu iso itɔ̃me. ");
INSERT INTO akp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ne ɔto ɔɣere ɔ̃ marabaradze sɔ, “Ndupiedze Yohanes loɔta ɔbɔrɛ i makpise ame ɔpia ngbã! Ne ɔso ɔba ɔle ɔto ɔbara awawãra ɔbara ngbɔ ne.” ");
INSERT INTO akp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tɔtɔ ne, Herodes ɔtã mamɔɛ̃ Yohanes manyi wũ marara i iyo. Ɔbara ngbɔ ala Herodia gɔ nɖe ɔ̃ ɔnyiibi Filipo ɔre ɔso. ");
INSERT INTO akp_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Alasɔ Yohanes ɔɣere Herodes sɔ, “Mmara iitã ɔri sɔ aayiri fɔ ɔnyiibi ɔre Herodia.” ");
INSERT INTO akp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ne ɔso Herodes ɔbie sɔ ɔ̃aɖoe wũ, ɣɛɛ ɔnigã ma Yudase alasɔ masɛ mabu Yohanes lɛ Ɣaa kanyaɖidze. ");
INSERT INTO akp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Iyi nɛ i Herodes ɔɖe ɔ̃ iɣeyi ne, Herodia ɔbi bitɛ ɔba ɔ̃atɔ ɔte maturi ma loba mmɔ gɔ ibua ipia Herodes isoɣɔ. ");
INSERT INTO akp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ne ɔkã ndamu ɔɣɛ sɔ, “Loatã-ɔ ira biara nɛ aakarɛ me.” ");
INSERT INTO akp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ɔbirɔ̃gomi ɔnyi ɔɣere wũ sɔ ɔkarɛ Ndupiedze Yohanes iti. Ne ɔso ɔsɛ ɔ̃aɣere igara sɔ, “Tã me Ndupiedze Yohanes iti i kategelei iso ngbe kiniɔ.” ");
INSERT INTO akp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Itɔ̃me nɛgbe ɔbo Herodes so, ɣɛɛ kumɛgɔ ɔkã ndamu i makpakpa ma nsigu wũ i ɔpɔrɔ̃ iti katɔ̃ ɔso ne, ɔpia sɔ masɛ maatu Yohanes iti mabɔ ɔbirɔ̃gomi. ");
INSERT INTO akp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ne ɔso ɔpia masɛ maatu Yohanes iti i ngbegɔ ɔrɛ i iyo. ");
INSERT INTO akp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Masu ituriti masia i kategelei iso masu mabɔ ɔbirɔ̃gomi fiɛ ka ɔsu ɔkɛlɛgu ɔ̃ ɔnyi. ");
INSERT INTO akp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Gɔ Yohanes marasuãdze ɔnɔ ne, masɛ maasu wũ masɛ maabiara fiɛ ka masɛ maaɣere Yesu. ");
INSERT INTO akp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Gɔ Yesu ɔnɔ nnɛ loba Yohanes iso ne, ɔbo i ɔkolo ame ɔwara ɔkɛlɛ ngbegɔ i maturi na. Ɣɛɛ gɔ maturi gbodzoo ɔtsue ne, masɛ ngba mabɔrɛ i ma simagɛ̃ ame makɛlɛ ɔ̃ kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Gɔ Yesu ɔso ɔbɔrɛ i ɔkolo ame fiɛ ɔnya maturi gbodzoo ma loba ne, ma ara ɔɖo wũ kayiri fiɛ ɔsa mma nto manyɛ. ");
INSERT INTO akp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kutsuɛ ɔwi ne ɔ̃ marasuãdze ɔbore mabo wũ maɣere wũ sɔ, “Kaɖe ɔɔro, fiɛ ngbe ɔdzorogu ayo ame ne ɔso ɖi ma ɔri si makɛlɛ ngorowase maabie aɖera maɣa maɖe.” ");
INSERT INTO akp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu ɔtã ma mmuai sɔ, “Iinya sɔ maakɛlɛ ne mi mɔmɔ mitã ma irere maɖe.” ");
INSERT INTO akp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ne marasuãdze ɔɣere wũ sɔ, “Abolo abo aru gu akpɛ fɛ̃a anyɔ kere nɖe aɖera wa boba.” ");
INSERT INTO akp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ne Yesu ɔɣere ma sɔ, “Misu mibɔ me i ngbe.” ");
INSERT INTO akp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ɔɣere maturi sɔ masɛ i karɔ̃ i sikua iso fiɛ ka ɔsu abolo abo aru gu akpɛ fɛ̃a anyɔ, ɔnyɔ kato ɔpɛ Ɣaa siba. Ɔbɛbɛse ɔsu ɔtã ɔ̃ marasuãdze sɔ masu maɣɛɣɛ maturi. ");
INSERT INTO akp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Gɔ ma ɔɖuɖu ɔɖe ara mami fiɛ marasuãdze ɔsa nwa lobuburi kanya ne, ayi kusɛsɛi kuweo-kunyɔ. ");
INSERT INTO akp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mma loɖe aɖera wamɔ aaɖe lɛ marɛrɛ̃ kukpi kuru gɔ maika marɔ̃go gu mabiɛtɛ. ");
INSERT INTO akp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ɔluwɛ̃ Yesu ɔtã ɔ̃ marasuãdze ɔya mabo i ɔkolo ame sɔ mawara makɛlɛ si ɔ̃ wũ ɔɖi maturi tsɔra ɔri. ");
INSERT INTO akp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Gɔ ɔ̃ɔɖi ma ɔri ɔro ne, ɔya ɔkɛlɛ kabemi iso ɔsɛ ɔ̃akparama kayi. Si iabara kutsuɛ buɛɛ ne, Yesu ɔnɔwɛ̃ loɔkuti ɔɣɛ i mmɔ. ");
INSERT INTO akp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ɔwi gɔgbe ame ne, ɔkolo ka ɔsia i itubu ndɛ̃, awɛ to akpɛ̃ fiɛ ndu to misɛgu ɔkolo mikpesegu. ");
INSERT INTO akp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ɔɖesɛrã ne, Yesu ɔsɛ i ndu iso ɔba ɔ̃atu ɔ̃ marasuãdze. ");
INSERT INTO akp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Gɔ manya wũ ɔsɛ i ndu iso ne, ɔtu ɔkpa ma maɣɛ sɔ, “Kpise ɔɖe!” Mala kulu i ifɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ɣɛɛ ɔluwɛ̃ ne, Yesu ɔɣere ma sɔ, “Mina ɔtu! Midaanigã. Mme loɖe!” ");
INSERT INTO akp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ne Petro ɔɣere wũ sɔ, “Bosate, si fɔ mɔmɔ aɖe ne, kpere me sɔ losɛ i ndu iso loba fɔ kɔrɛ.” ");
INSERT INTO akp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu ɔtã mmuai sɔ, “Ba!” Ne ɔso Petro ɔso ɔbɔrɛ i ɔkolo ame ɔtsɛ isɛ i ndu iso ikɛlɛ Yesu kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ɣɛɛ gɔ ɔnya kumɛgɔ i ɔwiri to ɔkpɛ̃ teteree ne, ɔnigã ɔtsɛ ndu iwã. Ne ɔla kulu teteree sɔ, “Bosate, ɖi me!” ");
INSERT INTO akp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ɔluwɛ̃ Yesu ɔɖi kɔrɔ̃ ɔmɔɛ̃ wũ ɔɣere wũ sɔ, “Fɔ kafɔkaɖe ɔtɛgɛlɛ, be ɔso fiɛ ato awararã?” ");
INSERT INTO akp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ma inyɔɔ ɔya mabo i ɔkolo ame kere ne ɔwiri ɔnyua ɔkpɛ̃ ne. ");
INSERT INTO akp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ne ɔso marasuãdze ma i ɔkolo ame ɔpɛ agɛgɛ̃ matã Yesu maɣɛ sɔ, “Gbaã ne, Ɣaa Ɔbi aɖe!” ");
INSERT INTO akp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Gɔ mawara itubu ne, maba maabo ɔkpokpo gɔ i Genezaret karɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Maturi ɔnya Yesu maɖi ite, ne ɔso masɛ maakɔ manyɛse ma ɔɖuɖu mpia i abuiti wamɔ ame ɔɖuɖu mabɔ wũ. ");
INSERT INTO akp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Mapɛ wũ nrɔɔ̃ sɔ ɔtã manyɛse si mapɛgu bidɛ ɔ̃ awu kutsueti. Mma ɔɖuɖu lopɛgu wũ ɔna isosarɛ. ");
INSERT INTO akp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ma Farisise mawɛ̃ gu ma Yudase mmara matedze mawɛ̃ ɔbɔrɛ i Yerusalem maba Yesu kɔrɛ makarɛ wũ sɔ, ");
INSERT INTO akp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Be ɔso fiɛ fɔ marasuãdze iisɛ mabara i bo mawa kubarara iso? Masɛ̃ maisɛ mafore nrɔɔ̃ i bo mmara kanya fiɛ masɛ maɖe aɖera.” ");
INSERT INTO akp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ne Yesu ɔtã ma mmuai sɔ, “Mi wũ ne, be ɔso fiɛ miisɛ mibara i Ɣaa mmara iso fiɛ mi mawa mire iso misɛ mibara? ");
INSERT INTO akp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ɣaa sɔ, ‘Warɛ fɔ ɔse gu fɔ ɔnyi. Si ɔrere ɔɣɛ inyakpi i ɔ̃ ɣese iso ne, ɔkote ɔtã kukpi ipɔ.’ ");
INSERT INTO akp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ɣɛɛ mi wũ mito mite sɔ si ɔrere ba ira nɛ ikote sɔ ɔ̃asu ɔbuai ɔ̃ maɣese fiɛ ɔɣɛ sɔ, ‘Nnɛ loasu lotã-ɔ loɔsu lotã Ɣaa.’ ne, iisinya sɔ ɔturi aawarɛ ɔ̃ ɔse ɣee ɔ̃ ɔnyi. ");
INSERT INTO akp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ne ɔso iki i mi kurabarara iso ne, miɔsɛ̃ Ɣaa mmara, mimɔɛ̃ mi mawa mire mito. ");
INSERT INTO akp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mi ma nsɛ mibara ara sɔ si mibo maturi anɔ! Ɣaa Kanyaɖidze Yesaya ɔkpɛ ɔya gɔ ɔɣɛ i mi iso sɔ, ");
INSERT INTO akp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Mmagbe ne, kanyakanya kere masu mato male me gɔ iibɔrɛ i ma situ ame. ");
INSERT INTO akp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Siefe kere mato mabara wũ karabara. Mato mate maturi mmara i wũ mire kanya.’ ” ");
INSERT INTO akp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ne Yesu ɔkpere maturi gbodzoo ɔbɔ so i kɔrɛ ɔɣere ma sɔ, “Mikã atsue si minɔ ara karɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nnɛ i ɔturi ɔɖe iibawo wũ ɔpukutura, ɣɛɛ nnɛ nsɛ ibɔrɛ i ɔturi kanya ame nsɛ ipukutura wũ.” ");
INSERT INTO akp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ne ɔ̃ marasuãdze ɔbore mabo wũ maɣere wũ sɔ, “Aɣe sɔ nnɛ aɣɛ mmɔ ɔta iya ma Farisise iso?” ");
INSERT INTO akp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu ɔtã ma mmuai sɔ, “Kudziri biara gɔ iiɖe Tete gɔ i kato lopia ne, maarui kɔ̃ mapɛyu. ");
INSERT INTO akp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ne ɔso minyua ma. Manɔbiɛdze maɖe fiɛ mato makɔ manɔbiɛdze. Si nɔbiɛdze to ɔkɔ nɔbiɛdze ne, iwo ame i ma inyɔɔ aakpase mabo.” ");
INSERT INTO akp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petro ɔɣere wũ sɔ, “Ɖi aɖera ɔturi iɣɛra igbã nɛmɔ karɔ̃ te bo.” ");
INSERT INTO akp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu ɔɣere ma sɔ, “Miinɔ itɔ̃me nɛ ana karɔ̃? ");
INSERT INTO akp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Minɔ karɔ̃ sɔ ira biara nɛ nsɛ ibo i ɔturi kanya ame ne, isɛ ikɛlɛ ɔ̃ iyiri ame, kama ne, ɔ̃anyi ne ɔpɛyu lɛ ɔdziriiso awe. ");
INSERT INTO akp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ɣɛɛ atɔ̃me wa nsɛ abɔrɛ i ɔturi kanya ame ne, ɔ̃ ɔtu ame abɔrɛ fiɛ asɛ apukutura wũ. ");
INSERT INTO akp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Alasɔ ɔturi ɔtu ame i adzuni nyanyarĩa wa nsɛgu ituriɖoe, maturire isiai gu marã irɔ, asɔrɔ̃ iɖe, kayu, mila aɖansiɛ iɖe, anyakpi iɣɛ i maturi iso sɛ ibɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nwagbe nsɛ aɣɛra ɔturi ne. Iiɖe nrɔɔ̃ mɛ maifore fiɛ maɖe ara nsɛ iɣɛra ɔturi.” ");
INSERT INTO akp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu ɔbɔrɛ i mmɔ ɔkɛlɛ Tiro gu Sidon awo ame. ");
INSERT INTO akp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mmɔ i ɔ Kananse rɔ̃go ɔwɛ̃ gɔ lobɔrɛ ndɛ̃ mɛmɔ ɔba Yesu kɔrɛ ku kulu teteree ɔba ɔ̃atã wũ iti sɔ, “Wũ Sate David ɔwa, nyɔ me nnya! Wũ ɔbi birɔ̃gomi to ɔwe inyɛ gbaã i siwarã lalaa nrɔɔ̃ ame.” ");
INSERT INTO akp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ɣɛɛ Yesu iiɣɛ kuira. Ne ɔ̃ marasuãdze ɔba maaɣere wũ sɔ, “Sa wũ si ɔnyua kulu ɔla ɔtɛ̃ra bo atsue!” ");
INSERT INTO akp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Mmɔ i Yesu ɔɣɛ sɔ, “Israel maturi ma nse lɛ masɛrɛ ma loyu kɔrɛ kere i Ɣaa ɔpia me.” ");
INSERT INTO akp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ɣɛɛ ne, ɔrɔ̃go gɔmɔ ɔba ɔ̃apɛ agɛgɛ̃ i ɔ̃ katɔ̃ ɔtã wũ iti sɔ, “Wũ Sate, buai me!” ");
INSERT INTO akp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu ɔɣere wũ sɔ, “Iilɛ sɔ maasu mabiɛtɛ aɖera matã makpɛkpɛ.” ");
INSERT INTO akp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ɔrɔ̃go ɔtã wũ mmuai sɔ, “Wũ Sate gbaã iɖe, ɣɛɛ makpɛkpɛ sɛ marɛrɛ aɖera wa lokpakpase i makɔse ɔpɔrɔ̃ iso afere i karɔ̃ maɖe.” ");
INSERT INTO akp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Gɔ Yesu ɔnɔ atɔ̃me wagbe ne, ɔɣere wũ sɔ, “Ɔrɔ̃go, fɔ kafɔkaɖe ɔmɔ gbaã! Nnɛ ato akarɛ si iba itã-ɔ.” Ɔluwɛ̃ ɔbi birɔ̃gomi ko losarɛ. ");
INSERT INTO akp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu ɔrui i mmɔ ɔsɛ Galilea itubu kuruɛkuruɛ ɔsɛ ɔ̃aya kabemi kawɛ̃ ɔkpase ɔsɛ i karɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Maturi gbodzoo ɔba ɔ̃ kɔrɛ. Gɔ mato maba ne, masɛgu mma lofɛfɛ̃ mafu, manɔbiɛdze, mabafã, mamumu gu manyɛse agbãagbã. Makɔ ma mabɔ Yesu katɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Gɔ maturi ɔnya sɔ mamumu to maɖe aka, mabafã ɔta masɛ, mma lofɛfɛ̃ mafu ɔna ɔle fiɛ manɔbiɛdze to manya ara ne, male Israel Ɣaa. ");
INSERT INTO akp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu ɔkpere ɔ̃ marasuãdze ɔbɔ so i kɔrɛ ɔɣere ma sɔ, “Mmagbe ara to akpɛ̃ me nnya, alasɔ maɔwe i wũ kɔrɛ akpɛnɛ atɛ fiɛ mana kuira nɛ maaɖe. Loito lobie sɔ makɛlɛ ayo ku kukã, si iiɖe ngbɔ ne, mato maasɛ maafɛ̃ i ɔri.” ");
INSERT INTO akp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ɔ̃ marasuãdze ɔkarɛ wũ sɔ, “Fafuĩ gɔgbe ame ne, lɛ boana aɖera botã maturi gbodzoo magbe ɔɖuɖu fiɛ maaɖe mami?” ");
INSERT INTO akp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu ɔkarɛ ma sɔ, “Abolo kuboi kurɛ̃ mito?” Ne matã wũ mmuai sɔ, “Abolo kuboi kukɔdzɛ gu kufarai wiriwiria kurɛ̃saã.” ");
INSERT INTO akp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ne Yesu ɔɣere maturi ɔɖuɖu sɔ masɛ i karɔ̃ ne. ");
INSERT INTO akp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ɔsu abolo kuboi kukɔdzɛ gu kufarai ne ɔpɛ Ɣaa siba i wã iti ne. Ɔbɛbɛse ɔsu ɔtã ɔ̃ marasuãdze fiɛ masu maɣɛɣɛ maturi. ");
INSERT INTO akp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ma ɔɖuɖu ɔɖe ara mami, ne gɔ marasuãdze ɔsa akutia kanya ne, mana kusɛsɛi kukɔdzɛ. ");
INSERT INTO akp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Marɛrɛ̃ kerekere kukpi kuna loɖe aɖera gɔ maika marɔ̃go gu mabiɛtɛ. ");
INSERT INTO akp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu ɔɖi maturi ɔri fiɛ ɔ̃ wũ ka ɔya ɔbo i ɔkolo ame ɔwara ɔkɛlɛ Magadan karɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ma Farisise gu ma Zadukise mawɛ̃ ɔba Yesu kɔrɛ maba maala wũ manyɔ sɔ ɔbara iwawãra ɔte sɔ Ɣaa kɔrɛ ɔbɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ɣɛɛ Yesu ɔtã ma mmuai sɔ, “Si kuɣɛ̃ to kusɛ kuabo iyo fiɛ kuɖokpo ɔrɛtɛ ne, misɛ miɣɛ sɔ, ‘Kayi to kaakpa kɔrãkaɖe.’ ");
INSERT INTO akp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ngbɔ ame si mita ku kaya fiɛ kuɖokpo ɔrɛtɛ, kayi ɔnyɔ guduu ne, misɛ miɣɛ sɔ, ‘Kado to ɔ̃apɛ nɔme.’ Misɛ miwo kuɖokpo ɔnyɔ ɔɣɛ kumɛgɔ i kayi aase ɣɛɛ miito miwo ɔwi gɔ ame mipia ɔnya ɔɖi ite! ");
INSERT INTO akp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kiniɔgbe maturi ma mba ɔtile fiɛ maisɛ manigã Ɣaa, mato mabie awawãra sɔ maanya, ɣɛɛ maibanya kuiwɛ̃ iɖo Ɣaa kanyaɖidze Yona ire igbã.” Gɔ ɔɣere ma ngbɔ ne, ɔrui ɔnyua ma. ");
INSERT INTO akp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Gɔ marasuãdze ɔwara itubu makɛlɛ kama isɛ ne, maɣara maito abolo kuawɛ̃. ");
INSERT INTO akp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ne Yesu to ɔɣere ma sɔ, “Midzuɛ̃ so i ma Farisise gu ma Zadukise inyagɛ̃ kua iso.” ");
INSERT INTO akp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ne matsɛ so ikarɛ sɔ, “Kumɛgɔ boito abolo ɔso fiɛ ɔto ɔɣere bo ngbɔ?” ");
INSERT INTO akp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ɣɛɛ Yesu ɣe nnɛ mato maɣɛ, ne ɔso ɔkarɛ ma sɔ, “Be ɔso fiɛ mito mikarɛ so atɔ̃me i aɖera wa miito iso? Mi kafɔkaɖe ɔtɛgɛlɛ gbaã. ");
INSERT INTO akp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Miito minya ara miɖi ite? Miito minyigi ɔwi gɔ losu abolo aru lotã marɛrɛ̃ kukpi kuru ɔɖe? Kusɛsɛi kurɛ̃ i akutia ɔyi? ");
INSERT INTO akp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Fiɛ ɔwi gɔ i maturi kukpi kuna ɔɖe abolo kuboi kukɔdzɛ ne, kusɛsɛi kurɛ̃ i akutia ɔyi? ");
INSERT INTO akp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nda ɔso fiɛ miito minɔ karɔ̃ sɔ iiɖe abolo iso loto loɖe ika? Midzuɛ̃ so i ma Farisise gu ma Zadukise inyagɛ̃ kua iso!” ");
INSERT INTO akp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Mmɔ ikpa marasuãdze sɔ iiɖe inyagɛ̃ kua gɔ masɛ masu mabara abolo iso ɔto ɔɖe ika ne, ma Farisise gu ma Zadukise ara ite ɔto. ");
INSERT INTO akp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu gu ɔ̃ marasuãdze ɔkɛlɛ Kaisarea Filipi ɔmagɛ̃ kɔrɛ. Mmɔ iɖe ɔkarɛ ɔ̃ marasuãdze sɔ, “Nna i maturi sɛ maɣɛ sɔ mme Ɔturi Awune Ɔbi ɖe?” ");
INSERT INTO akp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Matã wũ mmuai sɔ, “Mawɛ̃ sɔ Ndupiedze Yohanes, mawɛ̃ ana sɔ Eliya, fiɛ mawɛ̃ ana sɔ Yeremia ɣee Ɣaa kanyaɖidze ɔ aɖe.” ");
INSERT INTO akp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mmɔ i Yesu to ɔkarɛ ma sɔ, “Ne mi ɣɛɛ? Nna mibu sɔ loɖe?” ");
INSERT INTO akp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Petro ɔtara kanya sɔ, “Fɔ nɖe Kristo gɔmɔ, Ɣaa gɔ mba ngbã Ɔbi.” ");
INSERT INTO akp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ne Yesu ɔɣɛ sɔ, “So si siɣɔ-ɔ Simon, Yona ɔbi, alasɔ iiɖe ɔturi awune loɖi ɔnukuare gɔgbe ɔte-ɔ, ɣɛɛ wũ Ɔse gɔ i kato ɔɖe. ");
INSERT INTO akp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ne ɔso nto loɣere-ɔ sɔ fɔ nɖe Petro, gɔ karɔ̃ nɖe ita siare, fiɛ ita siare nɛgbe iso loatsue wũ mafɔɖedze ikuri losia gɔ kukpi kɔra iibawo ma iso ɔɖe. ");
INSERT INTO akp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Fiɛ nto loasu Ɣaa sigarakaɖekɔ̃ sibɔi lotã-ɔ sɔ nnɛ asɛ̃ i karɔ̃ iso ne, maasɛ̃ ne i kato fiɛ nnɛ asese i karɔ̃ iso ne, maasese ne i kato.” ");
INSERT INTO akp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ne Yesu ka ɔsɛ̃ ɔtã ɔ̃ marasuãdze sɔ madaaɣere kuwɛ̃ sɔ ɔ̃ nɖe Kristo ne. ");
INSERT INTO akp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ita i ɔwi gɔmɔ ne, Yesu ɔtsɛ ɔ̃ marasuãdze iɣere iɖi sɔ, “Nto loakɛlɛ Yerusalem fiɛ loawe inyɛ gbaã i makpakpa, masɔrɛdze makpakpa gu mmara matedze nrɔɔ̃ ame. Mato maaɖoe me, ɣɛɛ ikpɛnɛ tɛare ne, Ɣaa to ɔ̃atara me lowe ngbã.” ");
INSERT INTO akp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petro ɔkɔ wũ ɔɣedza i kuruɛ ɔtã wũ itai ɔɣɛ sɔ, “Kuiyikuiyi daasiɣɛ itɔ̃me nɛgbe! Iibaba-ɔ iso ngbɔ!” ");
INSERT INTO akp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu ɔfiniki ɔɣere Petro sɔ, “Re me kama, Satana! Ato abie sɔ akpesera so ɔri itɛ̃ra atã me alasɔ adzuni wagbe iibɔrɛ i Ɣaa kɔrɛ, ɣɛɛ ɔturi kɔrɛ abɔrɛ.” ");
INSERT INTO akp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ne Yesu to ɔɣere ɔ̃ marasuãdze sɔ, “Si mi ɔrere ɔbie sɔ ɔ̃asiai me ne, ɔsɛ̃ so si ɔsu ɔ̃ inyɛwe ɔnyigbã si ɔ̃awo me ɔsiai. ");
INSERT INTO akp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Alasɔ ɔbiara gɔ loakpɛ̃ i ɔ̃ ngbã iti ne, ɔto ɔ̃ayura me, ɣɛɛ ngɔ loayura ɔ̃ ngbã ala wũ ɔso ne, ɔto ɔ̃ana ngbã. ");
INSERT INTO akp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mme kusia i ɔturi aana si kayiiso ɔɖuɖu karana ɔkpese ɔ̃ kare fiɛ ɔ̃ayura ɔ̃ mɔmɔ ngbã? Ɣee ira iwɛ̃ pia gɔ ɔturi aasu ɔnyuarã ala ɔ̃ ngbã? ");
INSERT INTO akp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Alasɔ Ɔturi Awune Ɔbi to ɔ̃aba i ɔ̃ Ɔse ikpawaĩ ame gu ɔ̃ makpabo fiɛ ɔ̃atã ɔbiara kuso i ɔ̃ karabara kanya. ");
INSERT INTO akp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nto loɣere mi gbaã sɔ mi ndɛ̃ mawɛ̃ i ngbe iibakpi fiɛ maanya Ɔturi Awune Ɔbi to ɔba lɛ Igara awe.” ");
INSERT INTO akp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ayi akuɔ kama ne, Yesu ɔkɔ Petro gu Yakobo gu Yohanes makɛlɛ kube kɔlɛa kuwɛ̃ iso ma ɔnɔwɛ̃. ");
INSERT INTO akp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Gɔ mato manyɔ kere ne, Yesu kumiamia ɔkpaki, ɔ̃ katɔ̃ to kafiɛ lɛ kuɣɛ̃, fiɛ ɔ̃ arapia ana to afiɛ atsue anɔmi. ");
INSERT INTO akp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ne marasuãdze itɛ magbe ɔnya Mose gu Eliya to maɖegu Yesu ika ne. ");
INSERT INTO akp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ne Petro ɔɣere Yesu sɔ, “Bosate, bo ngbe iba ɔbua ilɛ gbaã! Si abie ne, tã bopɛ akpayo atɛ i ngbe. Iwɛ̃ itã-ɔ, iwɛ̃ itã Mose fiɛ iwɛ̃ ana itã Eliya.” ");
INSERT INTO akp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Gɔ ɔtogu ika iɖe ne, idɔdɔ fiɛa iwɛ̃ ɔso iba iafu ma iso fiɛ silɔ siwɛ̃ ɔɖe ika sibɔrɛgu i idɔdɔ ame siɣɛ sɔ, “Wũ Ɔbi mɔmɔ gɔ loipia kuɣɛ i ngbe ne, mikã wũ atsue.” ");
INSERT INTO akp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Gɔ marasuãdze ɔnɔ silɔ dzɛgbe ne, ifɔ̃ ɔmɔɛ̃ ma sɔ makɔlɛ mafu i karɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu ɔba ma kɔrɛ, ɔpɛgu ma ne ɔɣere ma sɔ, “Mita miya ne midaanigã.” ");
INSERT INTO akp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Gɔ matara anɔ kato ne, mainya kuwɛ̃ i mmɔ, iɖo Yesu ɔnɔwɛ̃. ");
INSERT INTO akp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Gɔ maso i kube iso mato maba ne, Yesu ɔsi ma mmara sɔ, “Midaaɣere kuwɛ̃ kaɖikate ga maɖi mate mi i ngbe gbɔgbɔɔgbɔ Ɔturi Awune Ɔbi ɔɔta ɔbɔrɛ i makpise ame.” ");
INSERT INTO akp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ne marasuãdze to makarɛ Yesu sɔ, “Be ɔso fiɛ mmara matedze sɛ maɣɛ sɔ Eliya aaɖe katɔ̃ ɔba tɔtɔ?” ");
INSERT INTO akp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu ɔɣere ma sɔ, “Gbaã iɖe sɔ Eliya aaɖe katɔ̃ ɔba ɔ̃aledza ira biara ɔsɛ. ");
INSERT INTO akp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ɣɛɛ ne, nto loɣere mi sɔ Eliya ɔɔba koko, maturi iinya wũ maɖi ite. Mabara wũ nnɛ mabie fiɛ ngbɔ ame mato maabara Ɔturi Awune Ɔbi ɔtile ana ne.” ");
INSERT INTO akp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mmɔ i marasuãdze ɔtsue sɔ Ndupiedze Yohanes ɔto ɔɣɛ ala ne. ");
INSERT INTO akp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Gɔ makpese maba iturikuri kɔrɛ ne, ɔrɛrɛ̃ ɔwɛ̃ ɔba ɔ̃apɛ agɛgɛ̃ i Yesu kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ne ɔɣere wũ sɔ, “Bosate, nyɔ wũ ɔbi nnya! Kakpebubu ɔnyɛ to ɔɖaa wũ gɔ isɛ inyɛdɛ̃ wũ teteree itã ɔpɛ ɔbo i ɔtɔ ɣee ndu ame. ");
INSERT INTO akp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Lokɔ wũ lobɔ fɔ marasuãdze sɔ masa wũ ɣɛɛ maiwo.” ");
INSERT INTO akp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ne Yesu ɔtã mmuai sɔ, “Mi kiniɔgbe maturi ma loifɔ maɖe fiɛ manyanyarĩ, ayi sirɛ̃ loawe i mi kɔrɛ isɛ iabo? Kɔ ɔbi bɔ me i ngbe!” ");
INSERT INTO akp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu ɔtɔ̃me ɔpia siwarã fiɛ sibɔrɛ i ɔbi ame. Ɔluwɛ̃ ne, ɔbi ɔsarɛ. ");
INSERT INTO akp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ne marasuãdze ɔbore mabo wũ makarɛ wũ pɔkɔsɔɔ sɔ, “Be ɔso fiɛ boiwo siwarã lalaa ɔsa ɔɖi?” ");
INSERT INTO akp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu ɔtã ma mmuai sɔ, “Mi kafɔkaɖe ɔfe ikoso ɔso. Gbaã nto loɣere mi sɔ si mi kafɔkaɖe ɔmɔ lɛ susuruba ibi ne, miaɣere kabemi gagbe sɔ, ‘Rui i ngbe kɛlɛ mmɔ,’ fiɛ iaba ngbɔ ana. Kuira ibara iibaɖo mi! ");
INSERT INTO akp_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ɣɛɛ si iiɖe kanya inyi gu kayi ikparama ame ne, aibawo siwarã dzɛgbe igbã ɔsa.” ");
INSERT INTO akp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Gɔ marasuãdze ɔɖuɖu ɔba maasakanya i Galilea ne, Yesu ɔɣere ma sɔ, “Mato maba maaɖi mme, Ɔturi Awune Ɔbi, matã maturi, ");
INSERT INTO akp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","maɖoe, ɣɛɛ ikpɛnɛ tɛare ne, loto loaledza ita ibɔrɛ i makpise ame.” Itɔ̃me nɛgbe ɔɖaa marasuãdze gbaã. ");
INSERT INTO akp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Gɔ Yesu gu ɔ̃ marasuãdze ɔba Kapernaum ne, mma nsɛ mafɔ kasɔrɛkɔ̃ toto ɔba maakarɛ Petro sɔ, “Mi ratedze ne, ɔsɛ ɔtã kasɔrɛkɔ̃ toto?” ");
INSERT INTO akp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ne Petro ɔtã ma mmuai sɔ, “Ɔsɛ ɔtã!” Gɔ Petro ɔsɛ ɔ̃abo iyo ne, Yesu loɖe katɔ̃ ɔkarɛ wũ sɔ, “Simon, be nɖe fɔ adzuni i nnɛ nto loba lokarɛ-ɔ iso? Kayiiso magara lampo ne, mabe nsɛ matã? Karɔ̃ ga iso i igara to ɔɖe maturi ɛɛbɛrɛ mafɔ ma mpia i karɔ̃ gamɔ iso?” ");
INSERT INTO akp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ne Petro ɔtã mmuai sɔ, “Mafɔ.” Yesu ɔtã wũ mmuai sɔ, “Ne karɔ̃ nɖe sɔ karɔ̃ gamɔ iso maturi iisɛ matã lampo gɔmɔ ne. ");
INSERT INTO akp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ɣɛɛ si boibata boya i mmagbe iso ne, kɛlɛ itubu kanya si apia ɖaɖiwa. Ikpɛ ɖeakatɔ̃ nɛ aaɖi ne, pia kɔrɔ̃ i ne kanya ame ne ato aanya sikã dzɛ loawo atã bo gu-ɔ isɔrɛyo lampo si asu atã ma.” ");
INSERT INTO akp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ɔwi kama ne, marasuãdze ɔba Yesu kɔrɛ makarɛ wũ sɔ, “Nna ɔɖe loɖo i Ɣaa sigarakaɖekɔ̃?” ");
INSERT INTO akp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ne Yesu ɔkpere ɔbiɛtɛ ɔba ɔ̃aɣedza ma i katɔ̃ ne. ");
INSERT INTO akp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ɔɣere ma sɔ, “Gbaã nto loɣere mi sɔ si miifiniki miibara so lɛ mabiɛtɛ awe ne, miito miakɛlɛ Ɣaa sigarakaɖekɔ̃ ame minya. ");
INSERT INTO akp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ngɔ lonya ɔɖo i Ɣaa sigarakaɖekɔ̃ ame ne, ɔ̃ nɖe ngɔ lobɔ so karɔ̃ ɔkpesera so lɛ ɔbiɛtɛ gɔgbe awe. ");
INSERT INTO akp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Ɔbiara gɔ loafɔ ɔbiɛtɛ gɔgbe i wũ iyere ame ne, mme iɖe ɔfɔ. ");
INSERT INTO akp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ɔrere gɔ loatã ɔbiɛtɛ gɔ mba kafɔkaɖe i wũ ame ɔfiniki i kafɔkaɖe kama ne, si masu ɔwɛ̃ manyi kukɔtɛ siare masarã wũ i ɔme mafuĩdza wũ mapia i ɔpo ame ne, ialɛgu wũ iɖo. ");
INSERT INTO akp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Ndzo miɖe mitã kayiiso ala ara wa loatã maturi ɔbo i kalakanyɔ ame pia, fiɛ ato aaba kokooko, ɣɛɛ ndzo miɖe mitã ngɔ iso i ara wamɔ aaki fiɛ aaba maturi iso! ");
INSERT INTO akp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ne ɔso si fɔ kɔrɔ̃ ɣee kukpa sɛ kukɔ-ɔ kupia i ikpi ame ne, tu kɔ̃ pɛyu! Ilɛ iɖo sɔ aabo i ngbã ame sɔ ana kɔrɔ̃ ɣee kukpa iɖo sɔ aawe nrɔɔ̃ minyɔ ngba minyɔ mafuĩdza-ɔ mapia i itɔkpe nɛ loibanyi inya ame. ");
INSERT INTO akp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Si fɔ inɔmi ana nsɛ itã abo i ikpi ame ne, were ne ɖi pɛyu! Ilɛ iɖo sɔ aawe inɔmi iwɛ̃ abo i ngbã ame iɖo sɔ aawe anɔmi anyɔ mafuĩdza-ɔ mapia i itɔkpe nɛ loisɛ inyi ame. ");
INSERT INTO akp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Minyɔ kukaakɔ sɔ miibanyɔ makosoi magbe kuwɛ̃ pupurii. Nto loɣere mi sɔ ma Ɣaa makpabo i kato ɣɛ i Ɣaa katɔ̃ ɔwi biara i ma kanya. ");
INSERT INTO akp_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Alasɔ Ɔturi Awune Ɔbi ɔba sɔ ɔ̃afɔ mma loyu ɔtã ma ngbã. ");
INSERT INTO akp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Si ɔturi ba masɛrɛ kulafa fiɛ ɔwɛ̃ ɔyu ne, be ɔ̃abara? Ɔ̃ibanyua kasiwɛ̃-kaiwɛ̃ ɔɣedza i kube ɔkparuɛ ɔsɛ ɔ̃anyɔnyɔ ngɔ nto ɔyu? ");
INSERT INTO akp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Fiɛ si ɔnya wũ ne, nto loɣere mi sɔ ɔ̃ana isoɣɔ i ɔwɛ̃ gɔ loyu ngbe iso ɔɖo kasiwɛ̃-kaiwɛ̃ ma loiyu. ");
INSERT INTO akp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ngbɔ ame i mi ɔse gɔ i kato iibabie sɔ makosoi magbe kuwɛ̃ si ɔyu ne. ");
INSERT INTO akp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Si fɔ ɔnyii ɔɣɛrɛ-ɔ ne, kɛlɛ ɔ̃ kɔrɛ si asɛ aaɖi ate wũ i mi gu wũ inyɔ ndɛ̃ kere. Si ɔkã-ɔ atsue ne, mi sinyii to siakɛlɛ i katɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ɣɛɛ si ɔ̃ikã-ɔ atsue ne, kɔ ɔturi ɔwɛ̃ ɣee inyɔ si misɛ ala Ɔko Sekelea ɔɣɛ sɔ, ‘Maɖansiɛ inyɔ ɣee itɛ kanya ame itɔ̃me iso maasia itɔ̃me biara ita.’ ");
INSERT INTO akp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Si mmɔ ana ɔ̃ikã ma atsue ne, ɣere mafɔɖedze ikuri ɔɖuɖu, ɣɛɛ si ɔ̃ikã ma atsue ana ne, ɖi wũ atsue lɛ ngɔ loifɔ ɔɖe ɣee lampofɔdze. ");
INSERT INTO akp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ne ɔso nto loɣere mi ɔɖuɖu sɔ, nnɛ misɛ̃ i kayiiso ngbe ne, Ɣaa aasɛ̃ ne i kato, fiɛ nnɛ miɖi ɔri i karɔ̃ iso ngbe ne, Ɣaa aasia kɔrɔ̃ i ne iso i kato ana. ");
INSERT INTO akp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Nto loledza mi iɣere sɔ ira biara nɛ i mi maturi inyɔ aatɔrã misia ita i kayi gagbe iso i kayi ikparama ame ne, wũ Ɔse gɔ i kato to ɔ̃abara ne ɔtã mi. ");
INSERT INTO akp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Alasɔ ngbegɔ i maturi inyɔ ɣee itɛ ɔsarɛ i wũ iɣere ame ne, lopia i ma ndɛ̃.” ");
INSERT INTO akp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Petro ɔbore ɔbo Yesu ɔkarɛ wũ sɔ, “Bosate, ikpɛ irɛ̃ loasu lotsɛ wũ ɔnyii gɔ nto ɔɣɛrɛ me? Ikpɛ ikɔdzɛ?” ");
INSERT INTO akp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu ɔɣere wũ sɔ, “Iiɖe ikpɛ ikɔdzɛ kere! Ɣɛɛ ikpɛ sikɔdzɛ aka akɔdzɛ si asu atsɛ wũ. ");
INSERT INTO akp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Ɣaa sigarakaɖekɔ̃ se lɛ ngbe. Ɔwi ɔwɛ̃ ne, igara ɔwɛ̃ ɔbie sɔ ɔ̃aki i ɔ̃ maɖabo siko ame ɔnyɔ kumɛgɔ mato mabara ɔ̃ karabara. ");
INSERT INTO akp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ku ɔ̃ isɛ karɔ̃ kere ne, makɔ ɔwɛ̃ gɔ nto wũ kuso titiiti mabɔ. ");
INSERT INTO akp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Gɔ ɔɖabo gɔmɔ na sikã ɔ̃atã kuso ɔso ne, igara ɔtã sɔ marɔdɛ̃ ɔ̃ gu ɔ̃ ɔre gu mabi lɛ masande gu ira biara nɛ ɔba si masu matã kuso. ");
INSERT INTO akp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ɔɖabo gɔgbe ɔpɛ agɛgɛ̃ i igara katɔ̃ ɔtã wũ iti sɔ, ‘Na ɔtu tã me ne nto loatã-ɔ kuso ɔɖuɖu gɔ loto-ɔ!’ ");
INSERT INTO akp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ɔrɛrɛ̃ gɔgbe ara ɔɖo igara kayiri ne ɔso ɔsu kuso ɔɖuɖu ɔtsɛ wũ ɔnyua wũ sɔ ɔkɛlɛ. ");
INSERT INTO akp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Gɔ ɔrui ne, ɔsɛ ɔ̃atu ɔ̃ ɔɖabo laa gɔ nto wũ kuso kɛkɛĩ. Ɔmɔɛ̃ ɔ̃ ɔlaa gɔgbe i ɔme gɔ ɔle ɔtsɛ wũ iro. Ɔɣere wũ sɔ, ‘Tã me kuso gɔ ato me!’ ");
INSERT INTO akp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ɔ̃ malaa ɔtã wũ iti sɔ ‘Na ɔtu tã wũ ne ɔto ɔ̃tã-ɔ kuso ɔɖuɖu gɔ ɔto-ɔ!’ ");
INSERT INTO akp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ɣɛɛ ɔsɛ̃, ɔtã mamɔɛ̃ wũ mapia i iyo gbɔgbɔɔgbɔ ɔ̃atã wũ kuso gɔ ɔto. ");
INSERT INTO akp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Gɔ ɔ̃ maɖabo laa ɔnya nnɛ loba ne, ibua iɖaa ma, ne masɛ maaɣere igara ira biara nɛ loba ne. ");
INSERT INTO akp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Ne ɔso igara ɔpia makpere ɔɖabo mabɔ ɔɣere wũ sɔ, ‘Ɔɖabo lalaa aɖe! Losu fɔ kuso gɔ ato me ɔɖuɖu lotsɛ-ɔ alasɔ atã me iti. ");
INSERT INTO akp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ikote sɔ fɔ wũ aanyɔ fɔ ɔlaa nnya lɛ kumɛgɔ lonyɔ-ɔ nnya.’ ");
INSERT INTO akp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Sikpã ɔkpɛ̃ igara gbaã ne ɔsu ɔɖabo gɔgbe ɔsese mapia wũ i iyo sɔ ɔwe mmɔ makpadzɛ̃ wũ kutsue gbɔgbɔɔgbɔ ɔ̃atã kuso gɔ ɔto wũ ɔro.” ");
INSERT INTO akp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ne Yesu ɔwiri sɔ, “Ngbɔ i wũ Ɔse gɔ i kato aabara mi ɔbiara si miisu mi manyii akpi mitsɛ ma ta mi situ ame ɔɖuɖu ne.” ");
INSERT INTO akp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Gɔ Yesu ɔɣɛ ara wagbe ɔro ne, ɔrui i Galilea ɔkɛlɛ Yudea awo ame i Yordan Ɔwore kama isɛ. ");
INSERT INTO akp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Maturi gbodzoo ɔsiai wũ fiɛ ɔsa ma i mmɔ. ");
INSERT INTO akp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ma Farisise mawɛ̃ ɔba ɔ̃ kɔrɛ mala wũ manyɔ makarɛ wũ sɔ, “Bo mmara ɔtã ɔrɛrɛ̃ ɔri sɔ ɔ̃awo ɔ̃ ɔre ɔsɛ̃ i katɔ̃mei biara iso?” ");
INSERT INTO akp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu ɔtã ma mmuai sɔ, “Miika i Ɔko Sekelea ame sɔ ta karɔ̃kasɛkɔ̃ ne, ɔrã gu ɔre i Ɣaa ɔbara? ");
INSERT INTO akp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Fiɛ Ɣaa ɔɣɛ sɔ, ‘Nnɛgbe ɔso i ɔrɛrɛ̃ aarui i ɔ̃ ɔse gu ɔnyi kɔrɛ ɔpɛ ɔmatã i ɔ̃ ɔre iso fiɛ ma inyɔɔ aakpese sosina siwɛ̃ ne.’ ");
INSERT INTO akp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ne ɔso maisiɖe maturi inyɔ ɣɛɛ ɔwɛ̃. Ne ɔso kuwɛ̃ si ɔdaabɛse nnɛ i Ɣaa ɔsu ɔmatãra so iso.” ");
INSERT INTO akp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ne ma Farisise ɔkarɛ wũ sɔ, “Iyɔ be ɔso i Mose ɔɖi ɔri sɔ ɔrɛrɛ̃ aatã ɔ̃ ɔre isɛ̃so ɔko iyɔ ɔ̃ɔɖi wũ ɔri?” ");
INSERT INTO akp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu ɔtã ma mmuai sɔ, “Mose ɔtã mi ɔri sɔ misɛ̃ mi mare ala mi atsuele ɔso, ɣɛɛ ne, iiɖe ngbɔ ise ta karɔ̃kasɛkɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ne ɔso nto loɣere mi sɔ ɔrɛrɛ̃ biara gɔ loasɛ̃ ɔ̃ ɔre fiɛ iiɖe kama iɖe i ɔrɔ̃go ɔfe wũ ne, ɔɖe asɔrɔ̃ si ɔyiri ɔrɔ̃go mama.” ");
INSERT INTO akp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ne ɔ̃ marasuãdze to maɣere Yesu sɔ, “Si ngbɔ ise i ɔrã gu ɔre ndɛ̃ ne, iyɔ ilɛ iɖo si miiyiri so kɔra.” ");
INSERT INTO akp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ne Yesu ɔɣere ma sɔ, “Iiɖe ɔturi biara loanɔ ara wagbe karɔ̃, mma i Ɣaa ɔtã kotoo loanɔ karɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Alasɔ ara agbãagbã ɔso i marɛrɛ̃ iisɛ mayiri marɔ̃go. Mawɛ̃ ne, ngbɔ maɣe ma ne, mawɛ̃ ana ne, maturi lobara ma ngbɔ, fiɛ mawɛ̃ ana iisɛ mayiri marɔ̃go ala Ɣaa sigarakaɖekɔ̃ ɔso. Ngɔ loawo ara ite nɛgbe ɔfɔ si ɔfɔ ne.” ");
INSERT INTO akp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mawɛ̃ ɔkɔ mabiɛtɛ mabɔ Yesu sɔ ɔsia ma kɔrɔ̃ iso si ɔkparama kayi ɔtã ma, ɣɛɛ ɔ̃ marasuãdze ɔnyagalagu mmamɔ. ");
INSERT INTO akp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu ɔɣɛ sɔ, “Mitã mabiɛtɛ si maba wũ kɔrɛ ne midaatɛ̃ ma ɔri, alasɔ Ɣaa sigarakaɖekɔ̃ se sitã ma igbã.” ");
INSERT INTO akp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yesu ɔsia ma nrɔɔ̃ iso, ɔtã ma kusɛkusɛ fiɛ ka ɔrui. ");
INSERT INTO akp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ɔwi ɔwɛ̃ ame ne, ɔporoporoi ɔwɛ̃ ɔba Yesu kɔrɛ ɔkarɛ wũ sɔ, “Ratedze, be nɖe ira sɛɛ nɛ loabara fiɛ loana ngbã mɛ loisɛ miro?” ");
INSERT INTO akp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ne Yesu ɔtã wũ mmuai sɔ, “Be ɔso ato akarɛ me itɔ̃me i ira sɛɛ iso? Ɔturi ɔwɛ̃ saã pɛ nɖe ɔsɛɛ, fiɛ si ato abie ngbã mɛ loisɛ miro ne, mɔɛ̃ Ɣaa mmara ɔɖuɖu la.” ");
INSERT INTO akp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ne ɔkarɛ Yesu sɔ, “Mme mmara?” Yesu ɔtã wũ mmuai sɔ, “Daaɖoe ɔturi, daaɖe asɔrɔ̃, daayu kayu, daaɖaɛ fɔ ɔlaa kanya. ");
INSERT INTO akp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Warɛ fɔ ɔse gu fɔ ɔnyi si aɖɔɛ fɔ ɔnyii lɛ kumɛgɔ ato aɖɔɛ so.” ");
INSERT INTO akp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ne ɔporoporoi gɔmɔ ɔtã mmuai sɔ, “Loɔbara ara wagbe ɔɖuɖu, be loɔkuti loabara?” ");
INSERT INTO akp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu ɔɣere wũ sɔ, “Si ato abie sɔ aayi pɛpɛɛpɛ ne, kɛlɛ aasu fɔ ira biara rɔdɛ̃ si asu sikã atsɛ mawɛrɛba, si aana kusia siare i kato. Si ɔɔro ne, kpese ba siai me.” ");
INSERT INTO akp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Gɔ ɔporoporoi gɔgbe ɔnɔ nnɛgbe ne, ɔruigu isoma alasɔ ɔba karana gbaã. ");
INSERT INTO akp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ne Yesu to ɔɣere ɔ̃ marasuãdze sɔ, “Nto loɣere mi sɔ ito iabua iɖa fiɛ ranase aabo i Ɣaa sigarakaɖekɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nto loledza mi iɣere sɔ, ma mmɔ ibo ba ɔle iɖo kumɛgɔ i kapuipɔngɔ aaki kafe i ɔdzirikaãra iyoi ame.” ");
INSERT INTO akp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Gɔ marasuãdze ɔnɔ ara wagbe ne, ibara ma ɣii ne mato makarɛ sɔ, “Iyɔ nna loabua ɔna iɖi?” ");
INSERT INTO akp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu ɔnyɔ ma i katɔ̃ ɔɣere ma sɔ, “Ɔturi kuwɛ̃ iibawo ɔbara, ɣɛɛ Ɣaa aawo ibiara ɔbara.” ");
INSERT INTO akp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ne Petro to ɔɣɛ sɔ, “Nyɔ, iyɔ bo ma lonyua bo ira biara bosɛ fiɛ bosiai-ɔ ne, mme kusia boana?” ");
INSERT INTO akp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu ɔtã mmuai sɔ, “Nto loɣere mi i ɔnukuare ame sɔ, ɔwi gɔ i Ɔturi Awune Ɔbi aasɛ i ɔ̃ ifiɛ sigaraiyara iso i Kayi Ɣɛtɛ ga nto kaba ame ne, mi ma nɖe wũ marasuãdze iweo-inyɔ ne, mito miasɛ i sigara ayara iso miɖe sigara i Israel nlɛ aka aweo-anyɔ iso. ");
INSERT INTO akp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ɔbiara gɔ lonyua ayo, manyiibi rɛrɛ̃ gu marɔ̃go, ɔ̃ ɔse gu ɔnyi, kukpɛkɔ̃ ɔsɛ ala wũ ɔso ne, ɔto ɔ̃afɔ ne ikpɛ kulafa fiɛ ɔ̃ana ngbã mɛ loisɛ miro ana. ");
INSERT INTO akp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ɣɛɛ gbodzoo ma nɖe maɖeakatɔ̃ kiniɔ to maakpese matsɔra fiɛ mawɛ̃ ma nɖe matsɔra kiniɔ to maakpese maɖeakatɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ɣaa sigarakaɖekɔ̃ se lɛ ɔrɛrɛ̃ ɔwɛ̃ gɔ lota kaya tutuutu ɔsɛ ɔ̃abie marabaradze sɔ masɛ maabara karabara i ɔ̃ adziribi kakpɛkɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ɔnɔ karɔ̃ sɔ ɔ̃atã ma ikpɛnɛ kuso lɛ kumɛgɔ masɛ matã fiɛ ɔsese ma sia. ");
INSERT INTO akp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Lɛ iɖɔwũ kaiwɛ̃ ne, ɔledza kuɣa ame isɛ, ne ɔnya gɔ mawɛ̃ ɣɛ mmɔ maito mabara kuira. ");
INSERT INTO akp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ne ɔɣere ma ma wũ sɔ, ‘Mikɛlɛ wũ kakpɛkɔ̃ miabara karabara ne nto loatã mi ikpɛnɛ kuso.’ ");
INSERT INTO akp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ne ɔso marui makɛlɛ. “Iɖɔwũ iweo-inyɔ gu iɖɔwũ itɛ ame ne, ɔledza ibara ngbɔ ame. ");
INSERT INTO akp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ito ikɛlɛ iɖɔwũ iru ame ana gɔ ɔsɛ kuɣa ame ne, ɔledza marɛrɛ̃ mawɛ̃ inya gɔ maɣɛ i mmɔ. Ɔkarɛ ma sɔ, ‘Be ɔso mito miwɔra ikpɛnɛ siefe sɔ miito mibara kuira?’ ");
INSERT INTO akp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ne matã mmuai sɔ, ‘Kuwɛ̃ iisu bo sɔ bosɛ boabara ɔ̃ karabara.’ “Ne ɔɣere ma sɔ, ‘Mi wũ mikɛlɛ wũ kakpɛkɔ̃ ame miabara karabara.’ ");
INSERT INTO akp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Gɔ kutsuɛ ɔɣo ne, kakpɛkɔ̃sate ɔɣere ngɔ nto ɔnyɔ marabaradze iso sɔ, ‘Kpere marabaradze bɔ si atã ma ma kuso. Sɛ karɔ̃ i mma lotsɔra sia ɔkɛlɛ iso si awirigu mma loɖe katɔ̃ makɛlɛ iso.’ ");
INSERT INTO akp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Marabaradze ma lokɛlɛ ku iɖɔwũ iru ame ne, matã ma ɔbiara ikpɛnɛ kuso. ");
INSERT INTO akp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ne ɔso gɔ marabaradze ma loɖe katɔ̃ makɛlɛ ɔba mafɔ ma kuso ne, mabu sɔ maatã ma iɖo ngbɔ, ɣɛɛ ma wũ ikpɛnɛ kuso matã ma ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Gɔ mafɔ sikã ne, matsɛ kakpɛkɔ̃ sate iɣɛtɛ sɔ, ");
INSERT INTO akp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Mma lotsɔra sia ɔba ne, ɔɖɔwũ ɔwɛ̃ pɛ mabara karabara atoa sɔ bo ne, bobara karabara ikpɛnɛ ɔɖuɖu i kuɣɛ̃ ame, ɣɛɛ kuso kuwɛ̃ ɔtã bo!’ ");
INSERT INTO akp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ne kakpɛkɔ̃ sate ɔtã ma ɔwɛ̃ mmuai sɔ, ‘Ɔrɛrɛĩ, loiɖe mi amumu alasɔ kuso gɔ boɣɛ bosia ita kuɖe lotã mi. ");
INSERT INTO akp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ne ɔso su fɔ sikã si akɛlɛ iyo. Mme mɔmɔ me lobie sɔ loatã mma lotsɔra ɔba lɛ kumɛgɔ lotã mi. ");
INSERT INTO akp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Fiɛ loba ɔri sɔ lobara wũ sikã karabara kumɛgɔ loɖɔɛ, ne ɔso anɔ si adaarɛtɛ-ɔ i wũ ara itsɛ iso.’ ” ");
INSERT INTO akp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ne Yesu ɔwirigu ma sɔ, “Ne ɔso mma nɖe matsɔra to maakpese maɖeakatɔ̃ fiɛ mma nɖe maɖeakatɔ̃ to maakpese matsɔra.” ");
INSERT INTO akp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Gɔ Yesu to ɔkɛlɛ Yerusalem ne, ɔkpere ɔ̃ marasuãdze iweo-inyɔ ɔɣedza i kuruɛ ɔɣere ma sɔ, ");
INSERT INTO akp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Mikã atsue, boto bokɛlɛ Yerusalem ngbegɔ mato maaɖi mme, Ɔturi Awune Ɔbi, matã masɔrɛdze makpakpa gu mmara matedze matã me kukpi ipɔ. ");
INSERT INTO akp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Maaɖi me matã mma loiɖe ma Yudase mabara me aɣiãra, mapɛ me, fiɛ maapɛ me mamatãra i kudziri iso, ɣɛɛ ikpɛnɛ tɛare iso ne, nto loaledza ita iwe ngbã.” ");
INSERT INTO akp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedeo ɔre ɔkɔ ɔ̃ mabi inyɔ maba Yesu kɔrɛ, mapɛ agɛgɛ̃ makarɛ wũ sɔ ɔbuai ma. ");
INSERT INTO akp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ne Yesu ɔkarɛ ma sɔ, “Be mito mibie?” Ne ma ɔnyi ɔtã mmuai sɔ, “Tã sɔ wũ mabi inyɔ magbe aasɛ i fɔ kuɖearɔ̃ gu fɔ kubena iso ku ɔwi gɔ aaɖe sigara.” ");
INSERT INTO akp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu ɔɣere ma sɔ, “Miiɣe nnɛ mito mikarɛ. Miawo inyɛwe gu kukpi gɔ ame loaki ɔki?” Ne matã mmuai sɔ, “Aĩ, boto boawo.” ");
INSERT INTO akp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Mmɔ i Yesu to ɔɣere ma sɔ, “Gbaã iɖe sɔ mito miawo. Ɣɛɛ ne, lona ɔri sɔ loaɖi mma loasɛ i wũ kuɖearɔ̃ gu kubena iso. Kusɛkɔ̃ gɔmɔ ne, mma i wũ Ɔse ɔledza ɔsɛ ɔkpɛ ɔɖe.” ");
INSERT INTO akp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Gɔ marasuãdze iweo tsɔra ɔnɔ itɔ̃me nɛgbe ne, managu manyiibi inyɔ magbe sikpã. ");
INSERT INTO akp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ne ɔso Yesu ɔkpere ma ɔɖuɖu ɔsirakanya ɔɣere ma sɔ, “Miɣe sɔ mma loiɖe ma Yudase magara sɛ mate so mapia mma mato maɖe iso, fiɛ ma matɔ̃ɖedze ana sɛ maɖe ma iso ku ɔle ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ɣɛɛ ne, idaawe i mi ame ngbɔ, si mi ndɛ̃ ɔrere to ɔbie sikpakpa ne, ɔbara so sumudze ɔtã matsɔra. ");
INSERT INTO akp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Fiɛ si mi ɔrere to ɔbie sɔ ɔ̃aɖe ɔɖeakatɔ̃ ne, ɔbara so ɔɖabo ɔtã matsɔra. ");
INSERT INTO akp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mme Ɔturi Awune Ɔbi kɔra ne, loiba sɔ masumu me, ɣɛɛ sɔ loasumu losu wũ ngbã lotã ala maturi gbodzoo iɖi ɔso.” ");
INSERT INTO akp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ɔwi gɔ i Yesu gu ɔ̃ marasuãdze to mabɔrɛ i Yeriko ne, maturi gbodzoo ɔsiai ma. ");
INSERT INTO akp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Manɔbiɛdze inyɔ ma nsi i ɔri kuruɛ ɔnɔ sɔ Yesu to ɔfe, ne ɔso matsɛ kulu teteree sɔ, “Yesu, Igara David Ɔbi, nyɔ bo nnya!” ");
INSERT INTO akp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Maturi ɔnyagalagu ma sɔ malo, ɣɛɛ makɔlɛ ma silɔ mabua sɔ, “Igara David Ɔbi nyɔ bo nnya soo!” ");
INSERT INTO akp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu ɔtui ɔya ne ɔkpere ma ɔkarɛ sɔ, “Be mito mibie sɔ lobara lotã mi?” ");
INSERT INTO akp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Matã mmuai sɔ, “Tete, boto bobie sɔ boanya ara!” ");
INSERT INTO akp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ma ara ɔɖo Yesu kayiri, ne ɔpɛgu ma anɔmi matsɛ inya fiɛ marui masiai wũ ne. ");
INSERT INTO akp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ɔwi gɔ i Yesu gu ɔ̃ marasuãdze ɔɔbore mabo Yerusalem ne, maba maabo Betfage i kube gɔ marɔ sɔ Oliva adziri Kube iso. Mmɔ ɔpia ɔ̃ marasuãdze inyɔ ɔɖegu katɔ̃ ");
INSERT INTO akp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ɔɣere ma sɔ, “Mikɛlɛ akorowa wa mpia i katɔ̃, si mibo ne, mito mianya ɔfirimu gɔ makɔra maɣedza, ɔ̃ ibi ɣɛ wũ i kɔrɛ. Mikurisi wũ mibɔ me. ");
INSERT INTO akp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Si ɔrere ɔɣɛ ira irere ne, miɣere wũ sɔ, ‘Bosate nto ɔbie ma’ iyɔ ɔluwɛ̃ ne, ɔto ɔ̃aɖi ma arɔĩ.” ");
INSERT INTO akp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Iba ngbɔ gɔ itã sɔ nnɛ i kanyaɖidze ɔɣɛ aaba i ne ame sɔ, ");
INSERT INTO akp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Miɣere Zion kaɖe sɔ, ‘Nyɔ, fɔ igara to ɔba fɔ kɔrɛ! Ɔsi i ɔfirimu gu ɔ̃ ibi iso i karɔ̃ ibɔso ame ɔto ɔba.’ ” ");
INSERT INTO akp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ne ɔso marasuãdze ɔrui masɛ maabara lɛ kumɛgɔ i Yesu ɔpia ma. ");
INSERT INTO akp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Makɔ ɔfirimu gu ɔ̃ ibi mabɔ, maɖi ma sikati masia i mabɔi iso fiɛ Yesu ɔta ɔsɛ i ma iso. ");
INSERT INTO akp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Maturi gbodzoo ɔɖi ma awu masɛ i ɔri fiɛ mawɛ̃ ana ɔɖaɛ kudzirikpai mafere i ɔri iso. ");
INSERT INTO akp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Maturi gbodzoo ma nɖe Yesu katɔ̃ gu mma ngbikama to mafa kayiɖu teteree sɔ, “Boale David Ɔbi, fiɛ Ɣaa aafere ngɔ nto ɔba i Bosate iyere ame kusɛkusɛ. Boale Ɣaa!” ");
INSERT INTO akp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Gɔ Yesu ɔbo Yerusalem ɔmagɛ̃ ame ne, kulu ko nto ɣee, ne maturi to makarɛ sɔ, “Ne nna ɔɖe ngbe?” ");
INSERT INTO akp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ne mawɛ̃ to matã mmuai sɔ, “Ɔ̃ nɖe Kanyaɖidze Yesu gɔ lobɔrɛ i Nasaret i Galilea ne.” ");
INSERT INTO akp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu ɔkɛlɛ Ɣaa isɔrɛyo ɔsɛ ɔ̃asa mma ɔɖuɖu nto maɣa ara gu mma nto marɔdɛ̃ ara ɔɖi i mmɔ. Ɔli mma nto manyuarã sikã sipɔrɔ̃ gu mma nto marɔdɛ̃ abɔrɔnuma ayara ɔpɛyu. ");
INSERT INTO akp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ne ɔɣere ma sɔ, “Matsɛrɛ i Ɔko Sekelea ame sɔ Ɣaa ɔɣɛ sɔ, ‘Maarɔ wũ iyo sɔ kayi kakparamakɔ̃,’ ɣɛɛ miɔsu ne mibara mayukukpe kawɛrɛkɔ̃!” ");
INSERT INTO akp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Manɔbiɛdze gu mabafã ɔba ɔ̃ kɔrɛ i kasɔrɛkɔ̃ mmɔ fiɛ ɔsa ma. ");
INSERT INTO akp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ɣɛɛ gɔ masɔrɛdze makpakpa gu mmara matedze ɔnya awawãra wa ɔto ɔbara gu kumɛgɔ i mabiɛtɛ to mala kulu i isɔrɛyo ame sɔ, “Maale David Ɔbi!” ne, ikpɛ̃ ma sikpã. ");
INSERT INTO akp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ne mato makarɛ Yesu sɔ, “Ato anɔ nnɛ mato maɣɛ i ngbe?” Yesu ɔtã ma mmuai sɔ, “Nto lonɔ. Miika itɔ̃me nɛgbe minya i Ɔko Sekelea ame sɔ, ‘Akararã mabiɛtɛ sɔ ma kanya ame i ile nɛ loyi sɛ ibɔrɛ.’ ” ");
INSERT INTO akp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ne kama ne, Yesu ɔrui ɔnyua ma ɔkɛlɛ Betania ɔmagɛ̃ ame ngbegɔ ɔsɛ ɔ̃arɛ. ");
INSERT INTO akp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kaɖesɛ̃a kaya tututu gɔ ɔ̃ɔkpese ɔto ɔba ɔmagɛ̃ ame ne, kukã ɔkpɛ̃ wũ. ");
INSERT INTO akp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","I ɔri kuruɛ ne, ɔnya figi kudziri gɔ kuɣɛ ne ɔso ɔkɛlɛ kɔ̃ kɔrɛ, ɣɛɛ gɔ ɔsɛ ne, ɔ̃inya ibi kuiwɛ̃ iɖo aɣata. Ne ɔɣere kudziri sɔ, “Ita i nɔme ne, aisibaɣɔ̃ abi anya.” Ɔluwɛ̃ kudziri ko loɣɔ. ");
INSERT INTO akp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Gɔ ɔ̃ marasuãdze ɔnya nnɛ loba ne ibara ma ɣii, ne mato makarɛ sɔ, “Nda i kuɖedziri ɔɣɔ ɔluwɛ̃ ngbɔ?” ");
INSERT INTO akp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ne Yesu ɔtã ma mmuai sɔ, “Nto loɣere mi gbaã sɔ si mifɔ miɖe fiɛ miiwararã ne, mito miawo nnɛ lobara kudziri gɔgbe ɔbara. Fiɛ iiɖe ne kere, ɣɛɛ mito miaɣere kube gɔgbe sɔ, ‘Kɛlɛ aafuĩdza so apia i ɔpo ame,’ fiɛ iaba ngbɔ. ");
INSERT INTO akp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Si mifɔ Ɣaa miɖe ne, ira biara nɛ miakarɛ wũ i kayi ikparama ame ne, mito miafɔ ne.” ");
INSERT INTO akp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu ɔkpese ɔba isɔrɛyo ame ne gɔ ɔto ɔte ara ne, masɔrɛdze makpakpa gu makpakpa ɔba ɔ̃ kɔrɛ makarɛ wũ sɔ, “Lɛ ana ɔle gɔ ato abara ala ara wagbe fiɛ nna lotã-ɔ ɔle gɔmɔ?” ");
INSERT INTO akp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu ɔtã ma mmuai sɔ, “Mitã lokarɛ mi itɔ̃me iwɛ̃ lonɔ, si mitã me mmuai ne, nto loaɣere mi ɔle gɔ loto lobara ala ara wagbe. ");
INSERT INTO akp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yohanes ne, nna lotã wũ ɔle fiɛ ɔpie maturi Ɣaa ndu? Ɣaa ɛɛbɛrɛ maturi lotã wũ?” Ne matsɛgu so iwararã sɔ, “Be boaɣɛ? Si boɣɛ sɔ Ɣaa kɔrɛ ne, ɔto ɔ̃akarɛ bo sɔ ‘Be ɔso miifɔ Yohanes miɖe?’ ");
INSERT INTO akp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ɣɛɛ si boɣɛ ana sɔ ‘Maturi kɔrɛ’ ne, boto bonigã maturi alasɔ ma ɔɖuɖu ɔfɔ maɖe sɔ Ɣaa kanyaɖidze ɔɖe.” ");
INSERT INTO akp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ne ɔso maɣere Yesu sɔ, “Boiɣe ngbegɔ i ɔ̃ ɔle ɔbɔrɛ.” Ne Yesu ɔ̃ wũ ɔɣere ma sɔ, “Mme wũ loibaɣere mi ngbegɔ i wũ ɔle gɔ loto lobara ala karabara gagbe ɔbɔrɛ.” ");
INSERT INTO akp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Nda minya itɔ̃me nɛgbe? Ɔrɛrɛ̃ ɔwɛ̃ ɔwe gɔ ɔba mabirɛrɛĩ inyɔ. Ɔɣere kpakpare sɔ, ‘Ɔbi, sɛ aabara karabara i kakpɛkɔ̃ ame nɔme.’ ");
INSERT INTO akp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ɔbi ɔɣere ɔ̃ ɔse sɔ, ‘Loibasɛ,’ ɣɛɛ ne kama ne, ɔfinikira ɔ̃ adzuni ɔrui ɔkɛlɛ sia. ");
INSERT INTO akp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Ɔse ɔkpere ɔbi nyɔare ɔpia wũ katɔ̃me gagbe ame. Ɔtɔrã i ɔ̃ ɔse katɔ̃ sɔ ɔ̃asɛ, ɣɛɛ ɔ̃isɛ. ");
INSERT INTO akp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Mabi inyɔ magbe ne, ma ɔmele lobara ɔ̃ ɔse kuɖɔɛ?” Matã mmuai sɔ, “Kpakpare.” Ne Yesu ɔɣere ma sɔ, “Nto loɣere mi sɔ, ma lampofɔdze gu asɔrɔ̃ maɖedze ɔɔɖe mi katɔ̃ makpa Ɣaa sigarakaɖekɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Alasɔ Ndupiedze Yohanes ɔba ɔ̃ate mi sibɔlɔlɔ ɔri, ɣɛɛ miifɔ wũ miɖe, ɣɛɛ ma lampofɔdze gu asɔrɔ̃maɖedze ɔfɔ wũ maɖe. Atoa sɔ minya nwagbe ne, miifinikira mi adzuni mifɔ wũ miɖe.” ");
INSERT INTO akp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu ɔɣere ma sɔ, “Minɔ igbã mama ana. Kpɛ̃dze ɔwɛ̃ ɔwe ku ɔwi gɔ lofe gɔ ɔkpɛ̃ adziribi wa masɛ masu mabara ala ndã kakpɛkɔ̃. Ɔtɛ̃ ɔkpã ɔki ɔlɔ kakpɛkɔ̃, ɔɖi itawo nɛ ame maakã ndã, fiɛ ka ɔtsue iyo kɔlɛa ngbegɔ i ngɔ loadzuɛ̃ kakpɛkɔ̃ aaya. Ɔsu kakpɛkɔ̃ ɔpia i marabaradze nrɔɔ̃ ame fiɛ ɔkɛlɛ ɔri. ");
INSERT INTO akp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Gɔ adziribi ɔsɔrɛ̃wi ɔɣo ne, ɔpia ɔ̃ maɖabo sɔ masɛ maafɔ ɔ̃ kaɖekɔ̃ mabɔ wũ i marabaradze kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Marabaradze ɔmɔɛ̃ maɖabo magbe, mapɛ ɔwɛ̃, maɖoe ɔwɛ̃, fiɛ mapɛ ɔwɛ̃ ata. ");
INSERT INTO akp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ɔrɛrɛ̃ gɔgbe ɔledza maɖabo mama isese iɖo maɖeakatɔ̃. Ma wũ ne, marabaradze ɔbara ma lɛ maɖeakatɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kawirikɔ̃ ne, ɔsese ɔ̃ ɔbi ala ɔɣere so sɔ, ‘Loɣe sɔ mato maawarɛ wũ ɔbi.’ ");
INSERT INTO akp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ɣɛɛ gɔ marabaradze ɔnya ɔbi ne, maɣere so sɔ, ‘Kakpɛkɔ̃ sate ɔbi gɔ loaɖe ɔ̃ ara i ngbe ne. Mitã boɖoe wũ si boaɖe ɔ̃ ara.’ ");
INSERT INTO akp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ne ɔso mamɔɛ̃ wũ mafuĩdza i ɔkpã kama fiɛ maɖoe wũ.” ");
INSERT INTO akp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ne Yesu ɔkarɛ ma sɔ, “Be mifɔ miɖe sɔ kakpɛkɔ̃ sate aabara marabaradze magbe si ɔba?” ");
INSERT INTO akp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Matã mmuai sɔ, “Ɔto ɔ̃aɖoe marabaradze lalaa magbe ɔsu kakpɛkɔ̃ ɔtã marabaradze mama ma loasu ɔ̃ kaɖekɔ̃ mabɔ wũ i ɔwi iso si masɔrɛ̃ ɔraɖui.” ");
INSERT INTO akp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ne Yesu ɔɣere ma sɔ, “Miika i Ɔko Sekelea ame sɔ, ‘Ita nɛ i mayotsuedze ɔsɛ̃ sɔ iilɛ ne, ne loba iakpese ita nɛ lofɔ kuɣa iɖo ata ɔɖuɖu pelepele ne. Bosate lobara ira siare nɛgbe fiɛ ibo bo anɔ gbaã!’ ” ");
INSERT INTO akp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yesu ɔkɛlɛgu i katɔ̃ sɔ, “Ɣaa to ɔ̃amɔɛ̃ ɔ̃ sigarakaɖekɔ̃ ɔfɔ mi iso ɔsu ɔtã mma loaɣɔ̃ abi sɛɛ. ");
INSERT INTO akp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ngɔ loakpase i itã nɛgbe iso ne, ɔto ɔ̃afɛfɛ̃ ɖukuɖuku, fiɛ ngɔ i ita nɛgbe aakpase iwuĩ ne, ito iakɔtɛ wũ ɖɛkpɛrɛɛ.” ");
INSERT INTO akp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Gɔ masɔrɛdze makpakpa gu ma Farisise ɔnɔ agbã wa i Yesu ɔpɛ ne, matsue sɔ ma ɔto. ");
INSERT INTO akp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ne ɔso mabie sɔ si mamɔɛ̃ wũ, ɣɛɛ manigã maturi gbodzoo ma mpia i mmɔ ala masɛ mabu Yesu lɛ Ɣaa kanyaɖidze awe. ");
INSERT INTO akp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu ɔledza agbã isu ite ma ara sɔ, ");
INSERT INTO akp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ɣaa sigarakaɖekɔ̃ se lɛ ngbe. Ɔwi ɔwɛ̃ ame ne, igara ɔwɛ̃ ɔkɔ ɔrɔ̃go ɔtã ɔ̃ ɔbi. ");
INSERT INTO akp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ɔpia ɔ̃ maɖabo sɔ masɛ maakpere mma matã itsue sɔ maba iyi kaɖekɔ̃ sɔ ka maba, ɣɛɛ masɛ̃ sɔ maito maba. ");
INSERT INTO akp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Ne ɔso ɔpia maɖabo mama sɔ maɣere ma sɔ, ‘Lotã maɖoe mabɔi gu ma nantsuĩ ma mba iɖa, mawa aɖera masɛ, ira biara ɔɔkote, ne ɔso ka miba wũ ɔpɔrɔ̃ gɔ lotu lotã irɔ̃gokɔ katɔ̃!’ ");
INSERT INTO akp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ɣɛɛ maturi ma makpere iipia wũ kanya. Makɛlɛ ma kurabara iso, ɔwɛ̃ ɔkɛlɛ sia, ɔwɛ̃ ana ɔkɛlɛ kuɣa kaɖekɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Mawɛ̃ ana ɔmɔɛ̃ maɖabo mamɔ mapɛ ma, maɖoe mma. ");
INSERT INTO akp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Sikpã ɔmɔɛ̃ igara gɔmɔ gbaã, ne ɔso ɔpia ɔ̃ makpakpɛ̃dze masɛ maaɖoe maturiɖoese mamɔ, matsuedza ma ɔmagɛ̃. ");
INSERT INTO akp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Ne ɔkpere ɔ̃ maɖabo ɔɣere ma sɔ, ‘Wũ ɔrɔ̃go ikɔ aɖera wa mawa ka ase, ɣɛɛ mma lokpere sɔ maba maaɖe ara iikote. ");
INSERT INTO akp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ne ɔso mikɛlɛ siri iso si mikpere ɔbiara gɔ mianya mibɔ.’ ");
INSERT INTO akp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ne maɖabo ɔrui makɛlɛ itiri gu siri iso masɛ maakpere maturi ɔɖuɖu ma manya, masɛɛ gu malalaa, itã sɔ iyo nɛ ame matu ɔpɔrɔ̃ ɔyi gu maturi. ");
INSERT INTO akp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Gɔ igara ɔba ɔ̃anyɔ mma loba aɖera kaɖekɔ̃ ne, ɔnya ɔrɛrɛ̃ ɔwɛ̃ gɔ loipia awu wa masɛ mapia i ɔrɔ̃go kakɔkɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ne igara ɔkarɛ wũ sɔ, ‘Wũ ɔlaa, nda abara fiɛ abo i ngbe gɔ aipia irɔ̃gokɔ awu?’ Ɣɛɛ ɔrɛrɛ̃ iinya kuira ɔɣɛ. ");
INSERT INTO akp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Ne igara ɔɣere ɔ̃ maɖabo sɔ, ‘Minyi wũ nrɔɔ̃ gu ngba si mifuĩdza wũ i kayoma i idududu ame. Mmɔ i kaku gu inyɛwe pia ne.’ ” ");
INSERT INTO akp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ne Yesu ka ɔwirigu ma sɔ, “Maturi gbodzoo i Ɣaa ɔkpere, ɣɛɛ kɛkɛĩ kere ɔ̃aɖi i ma ndɛ̃.” ");
INSERT INTO akp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ma Farisise ɔsɛ maabara adzuni sɔ maamɔɛ̃ Yesu i ma atɔ̃me ikarɛ ame. ");
INSERT INTO akp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ne ɔso mapia ma marasuãdze gu Herodes masiaidze mawɛ̃ ɔ̃ kɔrɛ makarɛ wũ sɔ, “Ratedze, boɣe sɔ asɛ aɣɛ ɔnukuare, asɛ ate maturi nnɛ nɖe Ɣaa kuɖɔɛ gɔ aisɛ akã siruɛ atsue alasɔ aisɛ anyɔ ɔturi i katɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ne ɔso ɣere bo fɔ adzuni. Lɛ sɔ boatã Roma Igarakpakpa lampo ɛɛbɛrɛ ita iya i bo mmara iso?” ");
INSERT INTO akp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu ɣe ma adzuni ne ɔso ɔɣere ma sɔ, “Mi ma nsɛ mibie sɔ mibo maturi anɔ! Be ɔso mito mibie sɔ miala me minyɔ? ");
INSERT INTO akp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mitã me sikã dzɛ misɛ mitã ala lampo lonyɔ.” Ne masu mabɔ wũ ne. ");
INSERT INTO akp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ne ɔkarɛ ma sɔ, “Nna katɔ̃ gu iyere iɖe nsia i sɛ̃ iso?” ");
INSERT INTO akp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Matã wũ mmuai sɔ, “Roma Igarakpakpa ire iɖe.” Ne Yesu ɔɣere ma sɔ, “Misu nnɛ nɖe Kaisaro ire mitã wũ si misu nnɛ nɖe Ɣaa ire ana mitã Ɣaa.” ");
INSERT INTO akp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Gɔ manɔ nnɛgbe ne, ibara ma ɣii, ne marui maɣɛ wũ ne. ");
INSERT INTO akp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Iyi nɛmɔ ame ne, ma Zadukise ma nsɛ maɣɛ sɔ makpise iisibata ɔba Yesu kɔrɛ maba maaɣere wũ sɔ, ");
INSERT INTO akp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ratedze, Mose ɔɣɛ sɔ si ɔrɛrɛ̃ ɔkpi ɔɣɛ ɔ̃ ɔre fiɛ maiɣe ɔbi ne, ɔ̃ ɔnyiibi si ɔsu ɔrɔ̃go ɔyiri si maɣe mabi. Maanyɔ mabi ma maaɣe mmɔ lɛ ɔ̃ ɔnyiibi gɔ lokpi mabi. ");
INSERT INTO akp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ɔwi ɔwɛ̃ ame ne, manyiibi rɛrɛ̃ ikɔdzɛ mawɛ̃ ɔwe i ngbe. Kpakpare ɔyiri ɔrɔ̃go ɣɛɛ ɔ̃iɣe ɔbi fiɛ ɔkpi ɔnyua ɔ̃ ɔre ɔsɛ ɔ̃ ɔkpeama. ");
INSERT INTO akp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ngbɔ ame ibara ɔbirɛrɛĩ nyɔare ɔtɛare gbɔgbɔɔgbɔ isɛ iabo ɔkɔdzɛva ne. ");
INSERT INTO akp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kawirikɔ̃ ne, ɔrɔ̃go ɔ̃ wũ ɔba ɔ̃akpi. ");
INSERT INTO akp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kiniɔ ne, ma nna ɔre i ɔrɔ̃go aaɖe ku iyi nɛ i makpise aaledza ita gɔ ma ɔɖuɖu ɔɔyiri wũ manya.” ");
INSERT INTO akp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu ɔɣere ma sɔ, “Mmɔ miɣɛrɛ ne, alasɔ miiɣe Ɔko Sekelea ame atɔ̃me fiɛ miiɣe Ɣaa ɔle ana. ");
INSERT INTO akp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Alasɔ si makpise ɔta ne, maase lɛ Ɣaa makpabo ma i kato fiɛ maibayiri so. ");
INSERT INTO akp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ɣɛɛ i makpise ita iso ne, miika nnɛ i Ɣaa ɔɣere mi? Ɔɣɛ sɔ, ");
INSERT INTO akp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Mme nɖe Abraham Ɣaa gu Isak Ɣaa gu Yakob Ɣaa ne.’ Magbanadze Ɣaa ɔɖe ne iiɖe makpise ɔre ɔɖe.” ");
INSERT INTO akp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Gɔ maturi gbodzoo ma mpia mmɔ ɔnɔ ara wagbe ne, ɔ̃ ara ite ɔbara ma ɣii. ");
INSERT INTO akp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Gɔ ma Farisise ɔnɔ kumɛgɔ i Yesu mmuai ɔpia ma Zadukise ibɔra i kanya ne, maba maasakanya. ");
INSERT INTO akp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ne ma ndɛ̃ ɔwɛ̃ gɔ nɖe mmaratedze ɔkarɛ Yesu itɔ̃me sɔ si ɔla wũ ɔnyɔ ne. ");
INSERT INTO akp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ɔkarɛ wũ sɔ, “Ratedze, mme mmara lomɔ miɖo?” ");
INSERT INTO akp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu ɔtã wũ mmuai sɔ, “Ɖɔɛ Bosate Ɣaa ku fɔ ɔtu ɔɖuɖu gu fɔ ɔkala ɔɖuɖu gu fɔ adzuni ɔɖuɖu ");
INSERT INTO akp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mmɛgbe nɖe mmara ɖeakatɔ̃ gu mmɛ lonya miɖo pelepele ne. ");
INSERT INTO akp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Minyɔare mɛ ka lonya se lɛ miɖeakatɔ̃, ‘Ɖɔɛ fɔ ɔnyii lɛ kumɛgɔ ato aɖɔɛ so.’ ");
INSERT INTO akp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mmara aka anyɔ wagbe iso matsue Mose mmara ɔɖuɖu gu Kanyamaɖidze ara ite masia ne.” ");
INSERT INTO akp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Gɔ ma Farisise mawɛ̃ ɔsakanya ne, Yesu ɔkarɛ ma sɔ, ");
INSERT INTO akp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nna mibu sɔ Kristo ɖe? Nna ɔbi ɔɖe?” Matã mmuai sɔ, “Igara David Ɔwa tɛtɛ ɔɖe.” ");
INSERT INTO akp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ne Yesu ɔkarɛ ma sɔ, “Si igara David ɔbi ɔɖe ne, lɛ ise ɔso i David ɔki i Ɣaa Siwarã ɔle ame ɔkpere wũ sɔ Bosate? David ɔɣɛ sɔ, ");
INSERT INTO akp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ɣaa ɔɣere Bosate sɔ, “Sɛ i wũ kuɖearɔ̃ iso gbɔgbɔɔgbɔ loatã asu ngba asia i fɔ matsirise iso.” ’ ");
INSERT INTO akp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Si igara David ɔkpere wũ Bosate ne, nda i Kristo aaɖe ɔ̃ ɔbi ɔɣɛ?” ");
INSERT INTO akp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ma kuwɛ̃ iiwo Yesu mmuai ɔtã, ne ɔso ita iyi nɛmɔ iso ne, ma kuwɛ̃ iisikarɛ wũ kuira. ");
INSERT INTO akp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ne Yesu ɔɖegu maturi gbodzoo gu ɔ̃ marasuãdze ika ne. ");
INSERT INTO akp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ɔɣere ma sɔ, “Mmara matedze gu ma Farisise nɖe mma maɖi ɔri sɔ mate Mose mmara. ");
INSERT INTO akp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ne ɔso mikã ma atsue si mibara ibiara nɛ maɣere mi sɔ mibara, ɣɛɛ ne, midaasiai ma kurabarara, alasɔ maisɛ mabara i nnɛ masɛ mate iso. ");
INSERT INTO akp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Masɛ manyi ato wa mba ɔrɔrã fiɛ asɛ aɖa isore masorera maturi, ɣɛɛ maisɛ mabie sɔ maapiagu ma kɔrɔ̃ si mabuai ma masore. ");
INSERT INTO akp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Masɛ mabara ira biara sɔ maturi aanyɔ ma. Minyɔ Ɣaa atɔ̃me siare wa matsɛrɛ i ɔkati iso masu manyi so iti gu nrɔɔ̃ si minyɔ kumɛgɔ i ma awu atsueti amɔ fiɛ akarã! ");
INSERT INTO akp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Si makpere ma i ɔpɔrɔ̃ katukɔ̃ ne, masɛ maɖɔɛ kusɛkɔ̃ kɔlɛa. Masɛ maɖɔɛ masɛ i kusɛkɔ̃ sɛɛ gu kusɛkɔ̃ kɔlɛa i ma kusarɛkɔ̃ ana. ");
INSERT INTO akp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Masɛ maɖɔɛ sɔ maturi si maya ma ku ibu i kuɣa ame si makpere ma ratedze. ");
INSERT INTO akp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Madaakpere mi sɔ ratedze, alasɔ mi ɔɖuɖu ne, manyii miɖe fiɛ ratedze ɔwɛ̃ saã miba. ");
INSERT INTO akp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Midaakpere kuwɛ̃ i karɔ̃ iso ngbe sɔ Tete alasɔ ɔse ɔwɛ̃ saã miba gɔ mpia i kato. ");
INSERT INTO akp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Madaakpere mi sɔ Tɔ̃ɖedze alasɔ mi tɔ̃ɖedze ɔwɛ̃ saã gɔ miba nɖe Kristo. ");
INSERT INTO akp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ngɔ nto ɔbie iyere i mi ndɛ̃ si ɔkpese mi ɔɖabo ");
INSERT INTO akp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ɔbiara gɔ lokɔlɛ so kato ne, maabɔ wũ karɔ̃ fiɛ ɔbiara gɔ lobɔ so karɔ̃ ne, makɔlɛ wũ kato. ");
INSERT INTO akp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ndzo miɖe mitã mi mmara matedze gu ma Farisise! Miɖɔɛ Ɣaa i anɔmi anɔmi ame kere! Misɛ misɛ̃ Ɣaa sigara kaɖekɔ̃ kayogodɔ̃ sɔ maturi si madaabo ku ɔwi gɔ i mi mɔmɔ ana ɔsɛ̃ sɔ miito mibo fiɛ misɛ̃ sɔ mma nto mabie sɔ maabo ana sɔ madaabo! ");
INSERT INTO akp_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ndzo miɖe mitã mi mmara matedze gu ma Farisise! Miɖɔɛ Ɣaa i anɔmi anɔmi ame kere! Alasɔ misɛ miɖe makpise mare amumu, fiɛ misɛ mikparama kayi dzoroo i iteso ame. Nwagbe ɔso ne, mi kutsue ikpadzɛ̃ to iamɔ! ");
INSERT INTO akp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ndzo miɖe mitã mi mmara matedze gu ma Farisise! Miɖɔɛ Ɣaa i anɔmi anɔmi ame kere! Alasɔ misɛ miwara ɔpo misɛ nrɔ̃ agbãagbã iso misɛ miaɖi ɔturi ɔwɛ̃ mitã Ɣaa, ɣɛɛ si mibara ngbɔ miro ne, misɛ mibara wũ ngɔ lonyanyarĩ ɔɖo mi i itɔkpe ame ikɛlɛ ame! ");
INSERT INTO akp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ndzo miɖe mitã mi ma nto mikɔ maturi ɣɛɛ manɔbiɛdze miɖe! Misɛ mite sɔ, ‘Si ɔturi ɔtarĩgu Ɣaa isɔrɛyo ne, mmara iinyi wũ, ɣɛɛ si ɔtarĩgu sikã dzɛ nse i isɔrɛyo ne, ɔ̃ i mmara ɔnyi ne.’ ");
INSERT INTO akp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Manɔbiɛdze dzimifɔ! Imele lonya iɖo? Sikã ɛɛbɛrɛ isɔrɛyo nɛ losekelera sikã? ");
INSERT INTO akp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Misɛ mite ana sɔ, ‘Si ɔturi ɔtarĩgu isɔrɛkasege ga iso masɛ mafɛ̃ ara matã Ɣaa ne, mmara iinyi wũ, ɣɛɛ si ɔtarĩgu karatã ga nsia i isɔrɛkasege iso ɣɛɛ ne, mmara ɔnyi wũ.’ ");
INSERT INTO akp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Anɔmi ɔbiɛ mi gbaã! Imele lonya iɖo? Karatã ɛɛbɛrɛ isɔrɛkasege ga losekelera karatã? ");
INSERT INTO akp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ne ɔso si ɔturi ɔtarĩgu isɔrɛkasege ne, ta ara wa nsia i isɔrɛkasege iso ɔɖuɖu iɖe ɔtarĩgu. ");
INSERT INTO akp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Fiɛ si ɔturi ɔtarĩgu Ɣaa isɔrɛyo ne, ɔtarĩgu ta Ɣaa gɔ nsi i mmɔ. ");
INSERT INTO akp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Fiɛ si ɔrere ɔtarĩgu Kato ne, ɔtarĩgu Ɣaa sigaraiyara gu ngɔ nsi iso. ");
INSERT INTO akp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ndzo miɖe mitã mi mmara matedze gu ma Farisise! Mi ma nsɛ mibara ara sɔ si mibo maturi anɔ! Misɛ miɖi mi araɖea ika weova ta aposarɛbi, ibura sikɔma agbãagbã mitã Ɣaa. Ɣɛɛ misɛ̃ sɔ miibabara ara wa lonya aɖo i mmara ame wa nɖe nnyainyɔ, atɔ̃me iɣɛ i ɔri iso gu ɔnukuare ame. Ara wagbe ikote sɔ miasu mibua i nwa mimɔɛ̃ mito iso ne. Ɣɛɛ miibanyua kuiwɛ̃ misɛ. ");
INSERT INTO akp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Matɔ̃ɖedze nɔbiɛdze! Misɛ mitua ɔnidzɔ gɔ lobo i mi ndã ame ɣɛɛ misɛ mimɛ kapuipɔngɔ! ");
INSERT INTO akp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ndzo miɖe mitã mi mmara matedze gu ma Farisise! Mi ma nsɛ mibara ara sɔ si mibo maturi anɔ! Misɛ mifore mi akɔi gu arɔi kama, ɣɛɛ wã kame ɔyi ku ara wa miɖe maturi amumu mifɔ ku so ɔle. ");
INSERT INTO akp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisise nɔbiɛdze, fore ikɔi ame tɔtɔ, iyɔ kama ka ito iare sekelee! ");
INSERT INTO akp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ndzo miɖe mitã mi mmara matedze gu ma Farisise! Mi ma nsɛ mibara ara sɔ si mibo maturi anɔ! Mise lɛ maturi akpibiɔ wa matsue makua kukaakɔ, ɣɛɛ wã ame ɔyi ku makpise buria ku akui. ");
INSERT INTO akp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ngbɔ ame i maturi ɔɖuɖu anɔmi ame ne, mire maturi sɛɛ, ɣɛɛ mi ame ɔyi ku mila gu akpi. ");
INSERT INTO akp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ndzo miɖe mitã mi mmara matedze gu ma Farisise! Mi ma nsɛ mibara ara sɔ si mibo maturi anɔ! Misɛ mitsue akpibiɔ mitã Ɣaa kanyamaɖidze fiɛ misɛ miledza mma losɛ ngbã sɛɛ akpibiɔ kukaakɔ. ");
INSERT INTO akp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Misɛ miɣɛ sɔ, ‘Si bo nsi ngbã ku bo mawa ɔwi ne, tee boiɖoe kanyamaɖidze mamɔ lɛ bo mawa awe.’ ");
INSERT INTO akp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ne ɔso mito misia ita sɔ mma loɖoe Ɣaa kanyamaɖidze mawa miɖe. ");
INSERT INTO akp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mikɛlɛ i katɔ̃ si mibara ara wa i mi mawa ɔsɛ karɔ̃ miwiri. ");
INSERT INTO akp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Maturi lalaa! Mise lɛ maɣɛ gu ma mabi. Mifɔ miɖe sɔ miawo ɔtere i itɔkpe kutsue ikpadzɛ̃ nɛ nto iba kanya? ");
INSERT INTO akp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ne ɔso nto loɣere mi sɔ nto loasese mi kanyamaɖidze gu manɔgbadze gu mmara matedze. Mito miaɖoe mawɛ̃, mipɛ mawɛ̃ mimatãra i kudziri iso, mipɛ mawɛ̃ i mi kusarɛkɔ̃, mitere misa ma ita i ɔmagɛ̃ ɔwɛ̃ ame ikpa ɔmama ame. ");
INSERT INTO akp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ne ɔso ne, maturi sɛɛ ma ɔɖuɖu maɔɖoe ita i Abel bɔlɔlɔa iso isɛ iabo Zakaria gɔ nɖe Berakia ɔbi gɔ miɖoe i Ɣaa isɔrɛyo ku Isɔrɛkasege ndɛ̃ kutsue ikpadzɛ̃ to iaba mi iso. ");
INSERT INTO akp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nto losia ita lotã mi sɔ ituriɖoe nɛgbe ɔɖuɖu ne, ne kutsue ikpadzɛ̃ to iaba kiniɔgbe maturi iso! ");
INSERT INTO akp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yerusalem, Yerusalem, asɛ aɖoe kanyamaɖidze ma i Ɣaa sɛ ɔpia fɔ kɔrɛ, fiɛ asɛ apɛ Ɣaa maɖabo ma ɔsɛ ɔpia-ɔ ata. Loɔkpɛ̃ sɔ si losu nrɔɔ̃ lofu-ɔ lɛ kumɛgɔ i kɔkɔ ɔnyi sɛ ɔwarɛ abue ɔfu akɔkɔibi, ɣɛɛ asɛ̃ me. ");
INSERT INTO akp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ne ɔso fɔ Isɔrɛyo to iakpese iyoku. ");
INSERT INTO akp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ita i kiniɔ ne, aisibanya me gbɔgbɔɔgbɔ miaɣɛ sɔ, ‘Ɣaa kusɛkusɛ si kuwegu ngɔ nto ɔba i Bosate iyere ame.’ ” ");
INSERT INTO akp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Gɔ Yesu ɔbɔrɛ i Ɣaa isɔrɛyo ɔto ɔkɛlɛ ne, ɔ̃ marasuãdze ɔba maakarɛ wũ si ɔkarã inɔ i kumɛgɔ matsue ne ayo iso. ");
INSERT INTO akp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ne ɔɣere ma sɔ, “Minyɔ ara wagbe ɔɖuɖu kukaakɔ. Alasɔ gbaã nto loɣere mi sɔ mato maabiɛbiɛ wã ɔɖuɖu gɔ ita kuiwɛ̃ iibakuti isia i ne ɔlaa iso sɔ maibasisi mapɛyu.” ");
INSERT INTO akp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Gɔ Yesu ɔsɛ ɔ̃asɛ i Nnɔĩ Adziri Kube iso ne, ɔ̃ marasuãdze ɔba maakarɛ wũ pɔkɔsɔɔ sɔ, “Ɣere bo ɔwi gɔ i ara wagbe aaba, ɔwi gɔ aakpese aba gu nnɛ loate sɔ kawirikɔ̃ ɔɔɣo.” ");
INSERT INTO akp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu ɔɣere ma sɔ, “Midzuɛ̃ so sɔ kuwɛ̃ iibasɔsɔla mi. ");
INSERT INTO akp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Alasɔ maturi gbodzoo to maasu wũ iyere maba maaɣere mi sɔ, ‘Mme nɖe Kristo,’ fiɛ maasɔsɔla maturi gbodzoo. ");
INSERT INTO akp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mito mianɔ kakpã gu kakpã iso atɔ̃me i mi kɔrɛ gu kadzorokɔ̃ ɣɛɛ midaamararã so, ara wagbe igbã to aaba ɣɛɛ iite sɔ kawirikɔ̃ ɔɔɣo. ");
INSERT INTO akp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Karɔ̃ kawɛ̃ iso maturi to maakpɛ̃gu karɔ̃ mama iso maturi, sigarakaɖekɔ̃ to siakpɛ̃gu sigarakaɖekɔ̃, kukã gu karɔ̃ iti to iaba i karɔ̃ agbãagbã iso. ");
INSERT INTO akp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nwagbe ɔɖuɖu se lɛ kuɣe iɖoɖo ibo ɖeakatɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Mato maamɔɛ̃ mi matã makpadzɛ̃ kutsue fiɛ maaɖoe mi. Nrɔ̃ ɔɖuɖu iso maturi to maatsiri mi ala wũ ɔso. ");
INSERT INTO akp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Maturi gbodzoo to maasɛ̃ ma kafɔkaɖe ku ɔwi gɔmɔ ame fiɛ maaɖi ma malaa matã, matsiri so. ");
INSERT INTO akp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mila kanyamaɖidze gbodzoo to maabɔrɛ masɔsɔla maturi gbodzoo. ");
INSERT INTO akp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ara lalaa ibara to iakɔlɛ kato sɔ maturi gbodzoo iisibaɖɔɛ so. ");
INSERT INTO akp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ɣɛɛ mma loaya teteree isɛ iabo kawirikɔ̃ to maana iɖi. ");
INSERT INTO akp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mato maaɣɛ Sigarakaɖekɔ̃ iso Itɔ̃me Bielea nɛgbe i kayiiso ɔɖuɖu sɔ iaɖe ikparĩ itã nrɔ̃ ɔɖuɖu iso maturi, ne kama ne, kawirikɔ̃ aaba. ");
INSERT INTO akp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Mito mianya Ɣaa itsirira ɔba iaya i kasekelekɔ̃, ngbegɔ iikote sɔ iaya lɛ kumɛgɔ i Ɣaa kanyaɖidze Daniel ɔɣɛ ɔsɛ. Ngɔ nto ɔka ɔko gɔgbe si ɔpia kubɛ sɔ ɔ̃anɔ karɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Ɔwi gɔmɔ ame ne, mma mpia i Yudea si matere makɛlɛ abe iso. ");
INSERT INTO akp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ngɔ nsia i ɔ̃ iyo isã si ɔdaaso ɔba iyo ame sɔ ɔto ɔba ɔ̃asu ɔ̃ ara. ");
INSERT INTO akp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ngɔ mpia i sia ana si ɔdaakɛlɛ ayo ame sɔ ɔ̃asu ɔ̃ awu. ");
INSERT INTO akp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ndzo miɖe mitã mayirise gu matalɛpo ma nto mabi ɣɛtɛ ku ɔwi gɔmɔ ame! ");
INSERT INTO akp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mitã Ɣaa iti sɔ ɔwi gɔ miatere iibaɖe ɔyu ɔwi ɣee iwarãyi iso. ");
INSERT INTO akp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Alasɔ inyɛwe siare nɛ loaba ku ɔwi gɔmɔ ne, ne igbã iiba inya ita i kayi karɔ̃kasɛkɔ̃ iba iabo nɔme, fiɛ ne igbã iisibaba inya ana. ");
INSERT INTO akp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ɣɛɛ ne, Ɣaa ɔɔtu ayi wamɔ koko alasɔ si iiɖe ngbɔ ne, kuwɛ̃ iibana iɖi, ɣɛɛ Ɣaa maturi ma ɔɖi ɔsɛ so ɔso ne, ɔ̃abɛrɛkɛ i ayi wamɔ iso. ");
INSERT INTO akp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ne ɔso si ɔrere ɔba ɔ̃aɣere mi sɔ, ‘Nyɔ, ɔɔnya Kristo i ngbe,’ ɣee ɔrere ɔɣere mi sɔ, ‘Ɔpia i mmɔ’ ne, midaafɔ miɖe. ");
INSERT INTO akp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Alasɔ mila ma Kristo gu kanyamaɖidze to maaba. Mato maabara awawãra siare gu ara wa loabara maturi ɣii sɔ si masu masɔsɔla ta mma nɖe Ɣaa maturi si maawo. ");
INSERT INTO akp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mikã me atsue! Alasɔ loɔɣere mi loɖegu katɔ̃ fiɛ ɔwi gɔmɔ aaɣo. ");
INSERT INTO akp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Si maɣere mi sɔ, ‘Ɔpia i fafuĩ ame’ ne, midaakɛlɛ sɔ mianyɔ. Si maɣere mi sɔ, ‘Ɔwɛrɛ i iyo kame i ngbe’ ne, midaafɔ miɖe. ");
INSERT INTO akp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Alasɔ mme, Ɔturi Awune Ɔbi ne, nto loaba lɛ kumɛgɔ i kado sɛ ɔma i kuɖokpo ɔbɔrɛ i kuɣɛ̃kabɔrɛkɔ̃ isɛ iabo kuɣɛ̃ iyo kabokɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ngbegɔ i ira kpia se ne, mmɔ i akolomo sɛ asakanya ne. ");
INSERT INTO akp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Si inyɛwe ɔwi gɔmɔ ɔfe ɔro kere ne, kuɣɛ̃ to kuagudu, ɔgbaworeti iisibafiɛ, awãmi to aakpakpase abɔrɛ i kato fiɛ kato sile to siati sibɔrɛ i sɛ̃ kawekɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Iyɔ Ɔturi Awune Ɔbi ikparĩ to iabɔrɛ i kato fiɛ kayiiso maturi aapɛ kaku kumɛgɔ manya wũ to ɔba i ɔle gu ifiɛ siare ame. ");
INSERT INTO akp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kadadã siare to kaare fiɛ ɔ̃apia ɔ̃ makpabo kayi akpakpai wã ana ɔɖuɖu sɔ masa ɔ̃ maturi ma ɔɖi ɔsɛ kanya ita i kayi iti nɛ isɛ iabo nnɛgbe. ");
INSERT INTO akp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Mitã kuɖedziri si kute mi ara. Si kuɔtsɛ akpa ɣɛtɛ itsue fiɛ ka kuto kuɖi aɣata ɣɛtɛ ne, mitsue sɔ kado ɔwi ɔɔbore ɔbo. ");
INSERT INTO akp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ngbɔ ame si minya sɔ ara wagbe ɔɖuɖu ka ato aba ne, mitsue sɔ kawirikɔ̃ ka kaba kaasɛ karɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mitsue sɔ ara wagbe ɔɖuɖu to aaba fiɛ maturi ma nsi ku kiniɔ aakpi maro. ");
INSERT INTO akp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kato gu karɔ̃ to kaafe, ɣɛɛ wũ atɔ̃me iibafe anya. ");
INSERT INTO akp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Kuwɛ̃ iiɣe iyi ɣee ɔwi gɔ i nwagbe aaba. Ɣaa makpabo ma i kato, ɣee Ɔturi Awune Ɔbi kɔra iiɣe iɖo wũ Ɔse ɔnɔwɛ̃ nɣe. ");
INSERT INTO akp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ɔturi Awune Ɔbi iba to iase lɛ kumɛgɔ i Noa ɔwi ɔse awe. ");
INSERT INTO akp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Si kado aaba ɔ̃apɛ ndu ayi minina kayiiso ɔɖuɖu ne, maturi ɔla maɔɖe ara maɔnɛ ndã, marɛrɛ̃ gu marɔ̃go to mayiri so gbɔgbɔɔgbɔ iyi nɛ i Noa ɔya ɔbo i ɔkolo ame. ");
INSERT INTO akp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ɣɛɛ maitsue nnɛ nto iba gbɔgbɔɔgbɔ ndu ɔyi miba miasore ma ɔɖuɖu miruigu. Ngbɔ ame i Ɔturi Awune Ɔbi ɔbawi ana aase ne. ");
INSERT INTO akp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ɔwi gɔmɔ ame ne, marɛrɛ̃ inyɔ to maaya i kakpɛkɔ̃, Ɣaa aasu ɔwɛ̃ ɔruigu ɔnyua ɔwɛ̃ ɔɣedza. ");
INSERT INTO akp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Marɔ̃go inyɔ to maaya i kukɔtɛ katɔ̃ mala maɔkɔtɛ ara, Ɣaa to ɔ̃asu ɔwɛ̃ ɔruigu ɔnyua ɔwɛ̃ ɔsɛ. ");
INSERT INTO akp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Ne ɔso midzuɛ̃ so alasɔ miiɣe iyi nɛ i Bosate aaba. ");
INSERT INTO akp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Si iyosate ɣe iyi nɛ i yukukpe aaba ɔ̃ayu wũ ne, tee ɔ̃ibarɛ sirɛ, ɔ̃asɛ ɔdzuɛ̃ sɔ ɔ̃ibatã yukukpe ɔbiɛ ɔ̃ iyo ɔbo ɔyu ara. ");
INSERT INTO akp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ne ɔso mi wũ midzuɛ̃ so alasɔ Ɔturi Awune Ɔbi to ɔ̃aba ku ɔwi gɔ miito minyɔ wũ ɔri ame. ");
INSERT INTO akp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Kiniɔ ne, nna nɖe ɔɖabo nukuarese gu nɔgbadze? Ɔ̃ nɖe ngɔ si makɔse ɔsu maɖabo tsɔra ɔpia i ɔ̃ kayirinɔ ne, ɔ̃atã ma aɖera i ɔwi sɛɛ iso. ");
INSERT INTO akp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","So aaɣɔ ɔɖabo gɔmɔ si makɔse ɔkpese ɔba ɔ̃anya sɔ ɔto ɔbara ngbɔ. ");
INSERT INTO akp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nto losia ita lotã mi sɔ makɔse to ɔ̃asu ɔ̃ karana ɔɖuɖu ɔpia wũ i nrɔɔ̃ ame sɔ ɔnyɔ iso. ");
INSERT INTO akp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ɣɛɛ si ɔɖabo lalaa ɔɖe ne, ɔto ɔ̃aɣere so sɔ, ‘Bokɔse to ɔ̃ana ɔpã fiɛ ɔ̃aba!’ ");
INSERT INTO akp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ne ɔso ɔto ɔ̃atsɛ ɔ̃ maɖabo laa ipɛ, itsɛ aɖera iɖe, inɛ ndã ku matarɛ̃dze. ");
INSERT INTO akp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ɔ̃ ɔkɔse to ɔ̃aba ku iyi nɛ ɔ̃ito ɔnyɔ wũ ɔri ku ɔwi gɔ ɔ̃iɣe. ");
INSERT INTO akp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Makɔse to ɔ̃akpadzɛ̃ wũ kutsue gbaã fiɛ ɔ̃ inyɛwe to iakotegu mma nsɛ mabie sɔ mabo maturi anɔ ɔkpɛ i ngbegɔ i kaku gu inyɛwe pia! ");
INSERT INTO akp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“I ɔwi gɔmɔ ame ne, Ɣaa sigarakaɖekɔ̃ aase lɛ ngbe. Ɔwi ɔwɛ̃ ame ne, mabitɛ iweo mawɛ̃ ɔsu ma sikaniɛ sɔ maasarɛgu ɔrɛrɛ̃ ɔwɛ̃ gɔ nto ɔkɔ ɔrɔ̃go. ");
INSERT INTO akp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mabitɛ iweo magbe ame ne, iru ɖe madzimifɔ fiɛ iru ana ɖe manɔgbadze. ");
INSERT INTO akp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Madzimifɔ ɔsu ma sikaniɛ, ɣɛɛ maisu nnɔĩ mabua i sikaniɛ iso. ");
INSERT INTO akp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Manɔgbadze ɣɛɛ ne, mato nnɔĩ i abui ame mabua i mmɛ mpia i ɔkaniɛ ame iso. ");
INSERT INTO akp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Gɔ ɔrɔ̃go kɔdze ɔgbikama ku iba ɔso ne, mabitɛ ɔtsɛ sirɛ itua kere ne marɛ sirɛ ne. ");
INSERT INTO akp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Lɛ kasɛ̃ ndɛ̃ ne, kulu ɔsia sɔ, ‘Ɔrɔ̃go kɔdze ɔɔba ɔ̃abo ne miba miasarɛgu wũ!’ ");
INSERT INTO akp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Mabitɛ iweo ɔɖuɖu ɔta, ne mayara ma sikaniɛ ne. ");
INSERT INTO akp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ne madzimifɔ to maɣere manɔgbadze sɔ, ‘Mitã bo mi nnɔĩ kɛkɛĩ alasɔ bo sikaniɛ ka sinyi.’ ");
INSERT INTO akp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ne manɔgbadze ɔɣere ma sɔ, ‘Ooɣo! Bo nnɔĩ iibaɣo bo gu mi inyɔ ne mikɛlɛ mma nto marɔdɛ̃ kɔrɛ miaɣa.’ ");
INSERT INTO akp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ku marui kere ne, ɔrɔ̃go kɔdze ɔba ɔ̃abo. Mabitɛ iru ma nɣɛ masia wũ ɔsiai wũ makɛlɛ ɔrɔ̃go kakɔkɔ̃ kere ne masɛ̃ kayogodɔ̃ ne. ");
INSERT INTO akp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ne kama ne, mabitɛ dzimifɔ iru mamɔ ɔba maabo, ne makpere sɔ, ‘Tete! Tete! Sese bo!’ ");
INSERT INTO akp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ne ɔrɔ̃go kɔdze ɔtã ma mmuai sɔ, ‘Ooɣo! Loiɣe mi!’ ” ");
INSERT INTO akp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ne Yesu ɔwirigu ma igbã sɔ, “Ne ɔso midzuɛ̃ so alasɔ miiɣe iyi ɣee ɔwi gɔ ame loaba. ");
INSERT INTO akp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ɔwi gɔmɔ ame ne, Ɣaa sigarakaɖekɔ̃ aase lɛ ngbe. Ɔwi ɔwɛ̃ ame ne, ɔrɛrɛ̃ ɔwɛ̃ to ɔkɛlɛ ɔri dzoroa, ne ɔso ɔkpere ɔ̃ maɖabo ɔsu ɔ̃ karana ɔpia ma i nrɔɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ɔtã ma ɔbiara i ma ɔle kanya. Ɔwɛ̃ ne, ɔtã wũ sikã sikoto iru, ɔwɛ̃ ana ikoto inyɔ fiɛ ɔwɛ̃ ana ɔkoto ɔwɛ̃ fiɛ ɔrui ɔkɛlɛ ɔri. ");
INSERT INTO akp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ɔɖabo gɔ lofɔ ikoto iru ɔkɛlɛ ɔsɛ ɔ̃afinikira nrɔɔ̃ i ɔ̃ sikã iso ɔna ikoto iru mama ɔsia i iso. ");
INSERT INTO akp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ngbɔ ame ngɔ lofɔ ikoto inyɔ ana ɔsɛ ɔ̃ana ikoto inyɔ ɔbua ne. ");
INSERT INTO akp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ɣɛɛ ɔɖabo gɔ lofɔ ɔkoto ɔwɛ̃ ne, ɔkɛlɛ ɔsɛ ɔ̃akuri iwo ɔsu makɔse sikã ɔkɔla. ");
INSERT INTO akp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ayi gbodzoo kama ne, makɔse ɔba sɔ si ɔba ɔ̃akigu ma i siko ame ɔnyɔ nnɛ maɔna masia. ");
INSERT INTO akp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ɔɖabo gɔ lofɔ sikã ikoto iru ɔsu sikoto iru nɛ ɔna ɔsia i iso ɔbɔ. Ɔɣere makɔse sɔ, ‘Tete, sikã ikoto iru atã me ɣɛɛ loɔna ikoto iru mama lobua iso.’ ");
INSERT INTO akp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Makɔse ɔɣere wũ sɔ, ‘Ɖafe, ɔɖabo sɛɛ gu nukuarese aɖe! Gɔ aɖe ɔnukuare i ara kosoi ame ɔso ne, loasu ara siare lopia i fɔ nrɔɔ̃ ame. Ba nagu me isoɣɔ!’ ");
INSERT INTO akp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ɔɖabo gɔ matã sikã ikoto inyɔ ana ɔba ɔ̃abo, ne ɔɣɛ sɔ, ‘Tete, sikã ikoto inyɔ iɖe atã me, ɣɛɛ ne, nyɔ, loɔna ikoto inyɔ losia i iso.’ ");
INSERT INTO akp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Makɔse ɔɣere wũ sɔ, ‘Ɖafe, ɔɖabo sɛɛ gu nukuarese aɖe. Kumɛgɔ aɖe ɔnukuare i ara kosoi ame ɔso ne, loasu ara siare lopia-ɔ i nrɔɔ̃ ame. Ba nagu me isoɣɔ!’ ");
INSERT INTO akp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ne ɔɖabo gɔ matã sikã ɔkoto ɔwɛ̃ ana ɔba ɔ̃abo ne. Ɔɣɛ sɔ, ‘Tete, loɣe sɔ ɔturi gɔ itɔ̃me mba ɔle aɖe. Asɛ asu aɖera i ngbegɔ aikpɛ̃, fiɛ asɛ asa ɔraɖui kanya i ngbegɔ aisa ɔraɖui. ");
INSERT INTO akp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ne ɔso gɔ loto lonigã-ɔ ɔso ne, lokuri karɔ̃ losu fɔ sikã lobiara. Nya fɔ sikã i ngbe!’ ");
INSERT INTO akp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ne makɔse ɔfɔ kanya sɔ, ‘Ɔɖabo lalaa gu dãdze aɖe. Aɣe sɔ nsɛ losu aɖera i ngbegɔ loikpɛ̃ fiɛ nsɛ losa ɔraɖui kanya i ngbegɔ loisa ɔraɖui? ");
INSERT INTO akp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Iyɔ be ɔso fiɛ aisu wũ sikã asɛ aasɛ i sikã kakɔlakɔ̃ sɔ si loba ne, loasɛ loafɔ sɛ̃ ku kusia?’ ");
INSERT INTO akp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Ne ɔ̃ ɔkɔse ɔɣɛ sɔ, ‘Mimɔɛ̃ sikã mifɔ i ɔ̃ kɔrɛ misu mitã ngɔ mba ikoto iweo.’ ");
INSERT INTO akp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Alasɔ ɔbiara gɔ mba ira ne, maatã wũ mabua ɔna isi gbodzoo, ɣɛɛ ngɔ nna kuira ne, kɛkɛĩ gɔ ame ɔba ne, maamɔɛ̃ mafɔ wũ iso. ");
INSERT INTO akp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ɔɖabo gɔ nna kusia kukuwɛ̃ i ngbe ɣɛɛ ne, mifuĩdza wũ mipia i idududu ame ngbegɔ i kaku gu arɔĩ iɖo ikpa pia. ");
INSERT INTO akp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ɔwi gɔ i Ɔturi Awune Ɔbi aaba lɛ igara gu ɔ̃ makpabo ne, ɔto ɔ̃asɛ i ɔ̃ sigaraiyara iso. ");
INSERT INTO akp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Fiɛ kayiiso maturi ɔɖuɖu aaya i ɔ̃ katɔ̃. Mmɔ ɔ̃aɣɛ ma ame lɛ kumɛgɔ i ngɔ nto ɔɣedza masɛrɛ sɛ ɔɣɛ kutepuĩ gu masɛrɛrerɔ̃ ame ne. ");
INSERT INTO akp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ɔto ɔ̃atã maturi bɔlɔlɔa ɔya i ɔ̃ kuɖearɔ̃ iso fiɛ malalaa ana aaya i ɔ̃ kubena iso. ");
INSERT INTO akp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ne igara aaɣere mma nɣɛ wũ i kuɖearɔ̃ iso sɔ, ‘Miba, mi ma i Tete ɔtã isobuɛ, miba miabo i sigarakaɖekɔ̃ ga maledza masɛ mi ta kayi karɔ̃kasɛkɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Alasɔ kukã ɔkpɛ̃ me, mitã me aɖera, ɔme ɔkore me, mitã me ndu lonɛ, loɖe ɔfɔ lobo mi, mifɔ me. ");
INSERT INTO akp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Minya me losɛ isɔ̃, mitã me arapia, gɔ lonyɛ ne, minyɔ me iso fiɛ gɔ mamɔɛ̃ me marara i iyo ne, miba minyɔ me.’ ");
INSERT INTO akp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Mmɔ i maturi bɔlɔlɔa aakarɛ wũ sɔ, ‘Bosate, ku mme ɔwi bonya-ɔ sɔ kukã to-ɔ botã-ɔ aɖera ɣee ɔme ɔkore-ɔ botã-ɔ ndu? ");
INSERT INTO akp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ku mme ɔwi bonya-ɔ aɖe ɔfɔ aba bo kɔrɛ fiɛ bofɔ-ɔ ɣee asɛ isɔ̃ botã-ɔ arapia? ");
INSERT INTO akp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ku mme ɔwi bonɔ sɔ ato anyɛ boba boaya-ɔ ɣee mamɔɛ̃-ɔ marara i iyo boba boaya-ɔ?’ ");
INSERT INTO akp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Mmɔ i igara aatã ma mmuai sɔ, ‘Ira biara nɛ miabara mitã manyii ma loire kuira i ngbe ne, mme mibara mitã.’ ");
INSERT INTO akp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ne ka ɔ̃aɣere mma i ɔ̃ kubena iso sɔ, ‘Mirui me i kɔrɛ mi ma i Ɣaa ɔgbarĩ. Mikɛlɛ itɔkpe nɛ mapia masɛ Ɔbosam gu ɔ̃ makpabo fiɛ iisɛ inyi ame! ");
INSERT INTO akp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Alasɔ kukã ɔkpɛ̃ me, miitã me aɖera, ɔme ɔkore me, miitã me ndu. ");
INSERT INTO akp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Loba loabo mi lɛ ɔfɔ, ɣɛɛ miifɔ me, losɛ isɔ̃ miitã me arapia. Nto lonyɛ, miinyɔ me iso mamɔɛ̃ me marara i iyo miiba mianyɔ me.’ ");
INSERT INTO akp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Mmɔ maakarɛ wũ sɔ, ‘Bosate, ku mme ɔwi bonya sɔ kukã ɣee ɔme ɔkore-ɔ ɣee aɖe ɔfɔ ɣee asɛ isɔ̃ ɣee ato anyɛ ɣee arɛ i iyo fiɛ boibuai-ɔ?’ ");
INSERT INTO akp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ne igara aatã ma mmuai sɔ, ‘Nto loɣere mi sɔ ira biara nɛ misɛ̃ sɔ miito mibara mitã manyii ma loire kuira i ngbe ne, mme miibara mitã!’ ");
INSERT INTO akp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Mmagbe ne, maakɛlɛ ngbegɔ inyɛwe iibaro inya fiɛ maturi sɛɛ ne, maakɛlɛ isoɣɔ nɛ loibaro inya ame.” ");
INSERT INTO akp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Gɔ Yesu ɔɔɣɛ ara wagbe ɔɖuɖu ɔro ne, ɔɣere ɔ̃ marasuãdze sɔ, ");
INSERT INTO akp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Miɣe sɔ iɔkuti ayi anyɔ gɔ maaɖe Kukpi Ɔtakuwara Bo Iyi fiɛ maaɖi mme, Ɔturi Awune Ɔbi, matã mapɛ me mamatãra i kudziri iso.” ");
INSERT INTO akp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Masɔrɛdze makpakpa gu kaɖe makpakpa ɔsarɛ i Kayafa gɔ nɖe masɔrɛdze ɔkpakpa pelepele iyo. ");
INSERT INTO akp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ne masɛ iti ame sɔ maamɔɛ̃ Yesu i iwɛrɛ ame maaɖoe. ");
INSERT INTO akp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ɣɛɛ maɣɛ sɔ, “Boiba bara ne ku iyi ɔɖewi, si iiɖe ngbɔ kulu to kuaba.” ");
INSERT INTO akp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Gɔ Yesu ɔsɛ Betania ne, ɔsɛ ɔrɛrɛ̃ gɔ marɔ Simon, fiɛ ɔnyɛ ɔnyɛrɛtɛa ɔnya iyo. ");
INSERT INTO akp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Gɔ Yesu si ɔto ɔɖe ara ne, ɔrɔ̃go ɔwɛ̃ ɔbɔ nnɔĩ mɛ nsɛ mifɔrɛ̃ kɔrɔ̃kɔrɔ̃ fiɛ mipia i ita inɔĩbui ame ɔba ɔ̃afere wũ iti. ");
INSERT INTO akp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Gɔ marasuãdze ɔnya nnɛgbe ne, ikpɛ̃ ma sikpã. Ne mato makarɛ sɔ, “Be nɖe karanina gagbe? ");
INSERT INTO akp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tee maawo nnɔĩ mɛgbe ɔrɔdɛ̃ ku kuɣa siare masu sikã matã mawɛrɛba!” ");
INSERT INTO akp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu ɣe nnɛ mato maɣɛ, ne ɔɣere ma sɔ, “Be ɔso mito miɖaa wũ? Ira sɛɛ iɖe ɔbara ɔtã me. ");
INSERT INTO akp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mawɛrɛba to maawe i mi kɔrɛ ɔwi biara, ɣɛɛ mme ne, loito loawe i mi kɔrɛ ɖaa. ");
INSERT INTO akp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ɔrɔ̃go gɔgbe nnɔĩ mɛ ɔsɔla me ngbe ne, ɔ̃ɔledza me ɔtã ibiara. ");
INSERT INTO akp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ne ɔso nto losia ita lotã mi sɔ, kakɔi biara ga maaɣɛ Itɔ̃me Bielea nɛgbe ne, maasu nnɛ ɔbara ɔtã me ngbe manyigi wũ ala.” ");
INSERT INTO akp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ne ɔ̃ marasuãdze iweo-inyɔ ndɛ̃ ɔwɛ̃ gɔ marɔ Yuda Iskariot ɔkɛlɛ masɔrɛdze makpakpa kɔrɛ, ");
INSERT INTO akp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ɔsɛ ɔ̃akarɛ ma sɔ, “Be miatã me si loɖi Yesu lotã mi?” Ne ɔso maka sikãfudza abi sitɛ matã wũ. ");
INSERT INTO akp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ita i ɔwi gɔmɔ ame ne, Yuda ɔtsɛ ɔri sɛɛ gɔ iso ɔ̃aki fiɛ ɔ̃aɖi Yesu ɔtã ma ibie. ");
INSERT INTO akp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","I iyi ɖeakatɔ̃ nɛ iso masɛ maɖe Boɖoboɖo Gɔ Loita Iyi ne, marasuãdze ɔba maakarɛ Yesu sɔ, “Lɛ ato abie sɔ bowa Kukpi Ɔtakuwara Bo iyi aɖera botã-ɔ?” ");
INSERT INTO akp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ne ɔpia ma ɔrɛrɛ̃ ɔwɛ̃ kɔrɛ i ɔmagɛ̃ ame ɔɣere ma sɔ, “Miɣere wũ sɔ, ‘Ratedze sɔ, “Wũ ɔwi ɔɔɣo, gu wũ marasuãdze aaɖe Kukpi Ɔtakuwara Bo aɖera i fɔ iyo.” ’ ” ");
INSERT INTO akp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Marasuãdze ɔbara lɛ kumɛgɔ i Yesu ɔɣere ma, ne mawa Kukpi Ɔtakuwara Bo aɖera ne. ");
INSERT INTO akp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Gɔ kutsuɛ ɔɣo ne, Yesu gu ɔ̃ marasuãdze iweo-inyɔ ɔsɛ i karɔ̃ matsɛ aɖera iɖe. ");
INSERT INTO akp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ɔwi gɔ mato maɖe ara ne, Yesu ɔɣere ma sɔ, “Nto loɣere mi sɔ mi ndɛ̃ ɔwɛ̃ to ɔ̃aɖi me ɔtã.” ");
INSERT INTO akp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Itɔ̃me nɛgbe ɔɖaa marasuãdze, ne mato makarɛ wũ isia isia sɔ, “Bosate, loɣe sɔ iiɖe mme ato. Bɛrɛ mme ɔɖe?” ");
INSERT INTO akp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu ɔɣere ma sɔ, “Ngɔ nto ɔpiagu me kɔrɔ̃ i irɔi ame ɔɖe loaɖi me ɔtã. ");
INSERT INTO akp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ɔturi Awune Ɔbi to ɔ̃akpi lɛ kumɛgɔ i Ɔko Sekelea ɔɣɛ ɔsɛ, ɣɛɛ ndzo miɖe mitã ngɔ loaɖi wũ ɔtã. Si maiɣe ɔnyiiɔ kɔra ne, ilɛ wũ iɖo!” ");
INSERT INTO akp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ne Yuda gɔ loɖi wũ ɔtã ɔtara kanya ɔkarɛ sɔ, “Ratedze, loɣe sɔ iiɖe mme ato lo?” Ne Yesu ɔɣere wũ sɔ, “Fɔ nto aɣɛ.” ");
INSERT INTO akp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ɔwi gɔ masi mato maɖe ara ne, Yesu ɔsu boɖoboɖo, ne gɔ ɔpɛ Ɣaa siba i ɔ̃ iti ne, ɔsu ɔtã ma ɔɣɛ sɔ, “Mifɔ miɖe, wũ sosina i ngbe ne.” ");
INSERT INTO akp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ne ɔsu ndã ikɔi ne, gɔ ɔpɛ Ɣaa siba i ne iti ne, ɔsu ɔtã ma, ɔɣere ma sɔ, “Mifɔ minɛ. ");
INSERT INTO akp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Wũ ima nɛ nto isia ita i Ɣaa ndamu ɣɛtɛ iso ne, ima nɛ mafere i karɔ̃ itã maturi gbodzoo akpi isu itsɛ. ");
INSERT INTO akp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nto loɣere mi gbaã sɔ loisibanɛ ndã gbɔgbɔɔgbɔ iyi nɛ loanɛgu mi miɣɛtɛ i wũ Ɔse sigarakaɖekɔ̃.” ");
INSERT INTO akp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ne gɔ maka kuka male Ɣaa ne, mabɔrɛ makɛlɛ Nnɔĩ Adziri Kube iso. ");
INSERT INTO akp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ne Yesu ɔɣere ma sɔ, “Kasɛ̃ gagbe ne, mi ɔɖuɖu to miatere minyua me, ikuti wũ ɔnɔwɛ̃, alasɔ Ɔko Sekelea ɔɣɛ sɔ, ‘Ɣaa to ɔ̃aɖoe masɛrɛkɔdze fiɛ ɔ̃ masɛrɛ aasame.’ ");
INSERT INTO akp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ɣɛɛ si loɔta lobɔrɛ i makpise ame ne, nto loaɖe mi katɔ̃ lokɛlɛ Galilea.” ");
INSERT INTO akp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petro ɔtara kanya sɔ, “Si matsɔra ɔɖuɖu aatere maɣɛ-ɔ kɔra ne, mme loibatere loɣɛ-ɔ lonya ɖa!” ");
INSERT INTO akp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ne Yesu ɔɣere Petro sɔ, “Si makɔkɔ aaɖi kanya nɔme ne, ato aasɛ̃ me ikpɛ itɛ sɔ aiɣe me.” ");
INSERT INTO akp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petro ɔtã mmuai sɔ, “Si inya sɔ loakpigu-ɔ kɔra ne, loibasɛ̃-ɔ lonya ɖa.” Marasuãdze tsɔra ana ɔɣɛ ngbɔ ame. ");
INSERT INTO akp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu gu ɔ̃ marasuãdze ɔrui makɛlɛ ngbegɔ marɔ sɔ Getsemane, ne ɔɣere ma sɔ, “Misɛ i ngbe si lokɛlɛ mmɔ loakparama kayi.” ");
INSERT INTO akp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ɔkɔ Petro gu Zebedeo mabi inyɔ, ne ɔtsɛ so imararã iti ikpakpa ne. ");
INSERT INTO akp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ɔɣere ma sɔ, “So to sima me ta wũ ɔtu ame gɔ loɔro ɔfɛ̃, misɛ i ngbe si midzuɛ̃gu me.” ");
INSERT INTO akp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ne gɔ ɔkɛlɛ katɔ̃ kɛkɛĩ ne, ɔkɔlɛ ɔfu i karɔ̃ ɔkparama kayi ɔɣɛ sɔ, “Tete, si ialɛ ne, tã inyɛwe ɔwi gɔgbe si ɔta ɔwara me! Ɣɛɛ ne, iiɖe wũ kuɖɔɛ, nnɛ i fɔ aɖɔɛ si abara.” ");
INSERT INTO akp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Gɔ ɔkpese ɔba marasuãdze itɛ mamɔ kɔrɛ ne, ɔnya sɔ maɔrɛ sirɛ, ne ɔɣere Petro sɔ, “Ne ɔso miibawo me ɔsɛ ɔdzuɛ̃gu bidɛ ɔɖɔwũ ɔwɛ̃? ");
INSERT INTO akp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Misɛ mila miɔdzuɛ̃ si mikparama kayi si miibabo i ilainyɔ ame. Siwarã ɣɛ teteree, ɣɛɛ siturina ɔɔfɛ̃.” ");
INSERT INTO akp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu ɔledza ikɛlɛ isɛ iakparama kayi iɣɛ sɔ, “Tete, si aibasɛnɛkɛ̃ra ikɔi nɛgbe aɖi me iso iɖo sɔ loanɛ ne, bara fɔ kuɖɔɛ, ne iiɖe wũ kure.” ");
INSERT INTO akp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Gɔ ɔkpese ɔba ne, ɔnya sɔ marasuãdze ɔɔrɛ sirɛ, ala sirɛ to si mɔɛ̃ ma. ");
INSERT INTO akp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesu ɔrui i ma kɔrɛ ɔsɛ ɔ̃aledza kayi ikparama iɣɛ atɔ̃me wamɔ ame. ");
INSERT INTO akp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ɔkpese ɔba marasuãdze kɔrɛ fiɛ ɔɣere ma sɔ, “Mikpese mirɛ mito miwarã? Minyɔ ɔwi ɔɔɣo, maɔɖi Ɔturi Awune Ɔbi mapia makpibaradze i nrɔɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mita si borui! Minyɔ, miɔnya ngɔ nto ɔɖi me ɔtã.” ");
INSERT INTO akp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu ɣɛ ɔto ɔɣɛ ara wagbe fiɛ Yuda gɔ nɖe marasuãdze iweo-inyɔ ɔwɛ̃ ɔba ɔ̃abo. Ɔsɛgu maturi gbodzoo ma i masɔrɛdze makpakpa gu kaɖe makpakpa ɔpia fiɛ mato atekpe gu kudziriku. ");
INSERT INTO akp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ngɔ loɖi wũ ɔtã ɔɣere ma sɔ, “Ngɔ minya sɔ loya fiɛ lofiɔ̃ irɛkpo ne, ɔ̃ ɔɖe ne, mimɔɛ̃ wũ!” ");
INSERT INTO akp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yuda ɔsɛ tiĩ ɔkɛlɛ Yesu kɔrɛ, ne ɔya wũ ɔɣɛ sɔ, “Isobuɛ itã-ɔ, ratedze.” Ne ɔfiɔ̃ wũ irɛkpo ne. ");
INSERT INTO akp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ne Yesu ɔɣere wũ sɔ, “Wũ ɔlaa nnɛ ɔso aba ne, tã ipɛ-ɔ siwa si abara ne!” Ne mma i Yuda sɛgu ɔbore mabo Yesu fiɛ mamɔɛ̃ wũ teteree ne. ");
INSERT INTO akp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mma nsiai Yesu mmɔ ɔwɛ̃ ɔɖi ɔ̃ itekpe ɔtu masɔrɛdze ɔkpakpa pelepele ɔɖabo kutsue. ");
INSERT INTO akp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ne Yesu ɔɣere wũ sɔ, “Pia fɔ itekpe i ɔyuɛ ame ala mma ɔɖuɖu nsɛ masu atekpe i maturi iso ne, atekpe kanya maakpi. ");
INSERT INTO akp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Bɛrɛ miiɣe sɔ loawo wũ Ɔse ɔbiɛ ɔkpere ɔluwɛ̃ ɔsese me Ɣaa makpabo kpakpɛ̃dze akuri aweo-anyɔ ɔbɔrɛgu i kato? ");
INSERT INTO akp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ɣɛɛ si iiba ngbɔ ne, nnɛ matsɛrɛ masɛ i Ɔko Sekelea ame iibaba i ne ame.” ");
INSERT INTO akp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ne Yesu ɔkarɛ maturi gbodzoo mamɔ sɔ, “Be ɔso fiɛ miaba miamɔɛ̃ me ku apɛmi gu kudziriku lɛ yukukpe loɖe? Gɔ iyi biara lopia i isɔrɛyo nto lote ara ne, be ɔso miimɔɛ̃ me? ");
INSERT INTO akp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ɣɛɛ nwagbe ɔɖuɖu ɔba i ne ame sɔ nnɛ i kanyamaɖidze ɔtsɛrɛ i Ɔko Sekelea ame aaba i ne ame.” Ne ɔ̃ marasuãdze ɔɖuɖu ɔrui matere maɣɛ wũ ne. ");
INSERT INTO akp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mma lomɔɛ̃ Yesu ɔkɔ wũ makɛlɛgu Kayafa iyo ngbegɔ i mmara matedze gu kaɖe makpakpa ɔsakanya. ");
INSERT INTO akp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petro ɔsiai ma kamakama ɔsɛ ɔ̃abo sɔrɛdzekpakpa pelepele kakpataku ame. Ɔsɛ ɔ̃asɛ i madzuɛ̃se kɔrɛ sɔ si ɔnyɔ kumɛgɔ i ira biara aakɛlɛ i katɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Masɔrɛdze makpakpa gu matɔ̃meɣɛdze ɔɖuɖu ɔbie itɔ̃me nɛ maanyi masia Yesu iso fiɛ maaɖoe wũ. ");
INSERT INTO akp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ɣɛɛ maina kuiwɛ̃ atoa sɔ maturi gbodzoo ɔba maala mila masia wũ iso. Kama ne, marɛrɛ̃ inyɔ mawɛ̃ ɔba, ");
INSERT INTO akp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ne maɣɛ sɔ, “Ɔrɛrɛ̃ gɔgbe ɔɣɛ sɔ, ‘Loabiɛ Ɣaa isɔrɛyo loledza ne itsue i ayi atɛ ame.’ ” ");
INSERT INTO akp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Sɔrɛdzekpakpa pelepele ɔta ɔya ɔɣere Yesu sɔ, “Nwa ɔɖuɖu mato maɣɛ ne, ana kuira aaɣɛ i wã iso?” ");
INSERT INTO akp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ɣɛɛ Yesu ɔma kanya kpa. Ne sɔrɛdzekpakpa pelepele ɔledza iɣɛ sɔ, “I Ɣaa iyere ame ne, nto lokã ndamu lotã-ɔ sɔ, ɣere bo si fɔ nɖe Kristo gɔ nɖe Ɣaa Ɔbi.” ");
INSERT INTO akp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ne Yesu ɔtã mmuai sɔ, “Aĩ, ngbɔ iɖe ne. Ɣɛɛ nto loɣere mi sɔ ita i kiniɔ ne, mito mianya Ɔturi Awune Ɔbi gɔ ɔsi i Ɔlesate kuɖearɔ̃ iso fiɛ ɔto ɔba i adɔdɔ ame!” ");
INSERT INTO akp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Gɔ ɔɣɛ ngbɔ ne, sɔrɛdzekpakpa pelepele ɔkɛ ɔ̃ awu ne ɔɣɛ sɔ, “Mmusuo! Maɖansiɛ kumawɛ̃ iisinya bo. Mi ɔɖuɖu ɔnɔ mmusuo itɔ̃me nɛ ɔɣɛ! ");
INSERT INTO akp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nda minya?” Ma ɔɖuɖu ɔtã mmuai sɔ, “Ikote sɔ ɔ̃akpi!” ");
INSERT INTO akp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Matua minyatu mafere wũ i katɔ̃, mapɛ wũ, fiɛ mma lopɛ wũ sirɔ̃ta ");
INSERT INTO akp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","to maɣere wũ sɔ, “Gɔ fɔ nɖe Kristo ne, ɣere bo ngɔ lopɛ-ɔ!” ");
INSERT INTO akp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Gɔ Petro si i kakpataku ame mmɔ ne, sɔrɛdzekpakpa pelepele ɔɖaborɔ̃go ɔwɛ̃ ɔba ɔ̃aɣere wũ sɔ, “Fɔ wũ asiai Yesu gɔ lobɔrɛ i Galilea karɔ̃ iso.” ");
INSERT INTO akp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ɣɛɛ Petro ɔsɛ̃ i ma ɔɖuɖu katɔ̃ sɔ, “Loiɣe nnɛ ato aɣɛ i ngbe.” ");
INSERT INTO akp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ne ɔbɔrɛ ɔkɛlɛ ɔsɛ ɔ̃aya i kayogodɔ̃ ne. Ɔɖaborɔ̃go mama ɔnya wũ gɔ ɔɣɛ, ne ɔɣere marɛrɛ̃ ma nɣɛ i mmɔ sɔ, “Ɔ̃ wũ ɔsiai Yesu Nasaretse.” ");
INSERT INTO akp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mmɔ ana Petro ɔsɛ̃ ɔɣɛ sɔ, “Lokã sɔ loiɣe ɔrɛrɛ̃ gɔmɔ!” ");
INSERT INTO akp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Iidzoro fiɛ marɛrɛ̃ ma nɣɛ i mmɔ ɔɣere Petro sɔ, “Fɔ wũ ma ndɛ̃ ɔwɛ̃ aɖe ala fɔ ikaɖe ɔɖi-ɔ itã!” ");
INSERT INTO akp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ne Petro ɔɣɛ sɔ, “Lokã sɔ ɔnukuare nto loɣɛ! Ɣaa si ɔkpadzɛ̃ me kutsue si iiɖe gbaã iɖe sɔ loiɣe ɔrɛrɛ̃ gɔmɔ!” Ɔluwɛ̃ ne, kɔkɔ ɔɖi kanya. ");
INSERT INTO akp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ne Petro ɔnyigi nnɛ i Yesu ɔɣere wũ sɔ, “Si kɔkɔ aaɖi kanya ne, ato aasɛ̃ me ikpɛ itɛ sɔ aiɣe me.” Ne ɔso Petro ɔbɔrɛ ɔkɛlɛ inyamɔ ɔsɛ ɔ̃abiɛ kaku teteree. ");
INSERT INTO akp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kaya tutuutu ne, masɔrɛdze makpakpa gu kaɖe makpakpa ɔbara adzuni sɔ maaɖoe Yesu. ");
INSERT INTO akp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Manyi wũ fiɛ masu wũ masɛ maapia i Roma Abã ɔkpakpa Pilato nrɔɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Gɔ Yuda gɔ loɖi Yesu ɔtã ɔnɔ sɔ maɔtã Yesu kukpi ipɔ ne, ibo wũ so, ne ɔso ɔkpesegu sikãfudza abi sitɛ wa ɔfɔ ɔkɛlɛgu masɔrɛdze makpakpa gu kaɖe makpakpa. ");
INSERT INTO akp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ɔɣere ma sɔ, “Lobara ikpi, alasɔ loɖi ɔturi gɔ loibara ikpi lotã sɔ maɖoe.” Ne matã wũ mmuai sɔ, “Fɔ itɔ̃me iɖe ne iisu bo kuira i mmɔ.” ");
INSERT INTO akp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ne Yuda ɔsa sikã ɔfere i isɔrɛyo fiɛ ɔrui ɔsɛ ɔ̃asa so ɔɖoe ne. ");
INSERT INTO akp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ne masɔrɛdze makpakpa ɔsu sikã fiɛ maɣɛ sɔ, “Ima sikã siɖe i ngbe fiɛ bo mmara iitã ɔri sɔ boasu sɛ̃ bopia i isɔrɛyo sikã ame.” ");
INSERT INTO akp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Gɔ maɣɛ manɔgu so karɔ̃ ne, masu sɛ̃ masɛ maaɣa karɔ̃ ga masɛ marɔ sɔ, “Rapɔdze Karɔ̃” sɔ maala ma ɔbiara mafɔ i mmɔ. ");
INSERT INTO akp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ne ɔso fiɛ ipɛ i nɔme ne, masɛ marɔ karɔ̃ gamɔ sɔ Ima Karɔ̃ ne. ");
INSERT INTO akp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ne ɔso nnɛ i kanyaɖidze Yeremia ɔɣɛ ɔba i ne ame sɔ, “Masu sikãfudza abi sitɛ wa i Israel maturi ɔnɔ karɔ̃ sɔ maatã i ɔ̃ iti, ");
INSERT INTO akp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","masɛ maaɣa rapɔdze karɔ̃ lɛ kumɛgɔ i Bosate ɔɣere me.” ");
INSERT INTO akp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu ɔya i Roma Abã Ɔkpakpa Pilato katɔ̃ fiɛ ɔkarɛ wũ sɔ, “Fɔ nɖe ma Yudase Igara?” Yesu ɔtã mmuai sɔ, “Aĩ. Nnɛ ato aɣɛ pia i ne ame.” ");
INSERT INTO akp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ɣɛɛ nwa ɔɖuɖu i masɔrɛdze makpakpa gu kaɖe makpakpa ɔɣɛ ne, ɔ̃itã mmuai. ");
INSERT INTO akp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ne Pilato to ɔkarɛ wũ sɔ, “Ato anɔ nwa ɔɖuɖu mato maɣɛ i fɔ iso?” ");
INSERT INTO akp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ibara abã ɔkpakpa ɣaa gbaã kumɛgɔ i Yesu ɔsɛ̃ sɔ ɔ̃ito ɔtã ku itɔ̃me mmuai. ");
INSERT INTO akp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ikɔ biara si ma Yudase to maɖe Kukpi Ɔtakuwara Bo Iyi ne, Roma abã ɔkpakpa sɛ ɔnyua yorɛdze ɔwɛ̃ gɔ i kaɖe ɔkarɛ ɔtã ma. ");
INSERT INTO akp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ɔwi gɔmɔ ame ne, yorɛdze ɔwɛ̃ gɔ iyere loɔre i ara lalaa ibara ame fiɛ marɔ wũ sɔ Baraba ɔwe. ");
INSERT INTO akp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ne ɔso gɔ maturi gbodzoo ɔsakanya ne, Pilato ɔkarɛ ma sɔ, “Nna mito mibie sɔ lonyua lotã mi? Baraba ɛɛbɛrɛ Yesu gɔ mato makpere sɔ Kristo?” ");
INSERT INTO akp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ɔbara ngbɔ alasɔ ɔnya sɔ ma Yudase makpakpa ne, sirerɛ ɔso kere maɖi wũ matã. ");
INSERT INTO akp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Gɔ Pilato si ɔ̃ atɔ̃mekaɣɛkɔ̃ iyo ame ne, ɔ̃ ɔre ɔpia wũ ɔturi ɔɣere wũ sɔ, “Daapia kanya i ɔrɛrɛ̃ gɔmɔ itɔ̃me ame alasɔ ɔ̃ibara kuira nɛ loatã maɖoe wũ. Losɛ̃ arɛ nyanyarĩa i ɔ̃ iti i kasɛ̃ ame.” ");
INSERT INTO akp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Masɔrɛdze makpakpa gu kaɖe makpakpa ɔɣɛ mapia maturi sɔ makarɛ Pilato sɔ ɔnyua Baraba ɔtã ma si ɔɖoe Yesu. ");
INSERT INTO akp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ne ɔso gɔ Pilato ɔkarɛ iturikuri sɔ, “Nna mito mibie sɔ lonyua lotã mi?” ne, matã mmuai sɔ, “Baraba!” ");
INSERT INTO akp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ne Pilato to ɔkarɛ ma sɔ, “Be si lobara Yesu gɔ marɔ sɔ Kristo?” Matã mmuai sɔ, “Pɛ wũ matãra i kudziri iso!” ");
INSERT INTO akp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato ɔkarɛ ma sɔ, “Mme ikpi iɖe ɔbara.” Ne masiagu kulu teteree sɔ, “Pɛ wũ matãra i kudziri iso!” ");
INSERT INTO akp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Gɔ Pilato ɔnya sɔ ɔ̃ibawo ma adzuni ɔfinikira ne kulu to kuaba ne, ɔsu ndu ɔfore nrɔɔ̃ i iturikuri katɔ̃ ɔɣɛ sɔ, “Wũ kɔrɔ̃ gu kukpa na i ɔrɛrɛ̃ gɔgbe kukpi ame. Mi itɔ̃me iɖe.” ");
INSERT INTO akp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ne iturikuri to matã mmuai sɔ, “Ɔ̃ kukpi ato si aba i bo gu bo mabi iti iso!” ");
INSERT INTO akp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilato ɔnyua Baraba ɔtã ma, ne gɔ ɔtã mapɛ Yesu ala iporoibi ne, ɔnyua wũ ɔtã ma sɔ masɛ maapɛ wũ mamatãra i kudziri iso. ");
INSERT INTO akp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ne Pilato makpakpɛ̃dze ɔkɔ Yesu mapia i Abã ɔkpakpa iyo ame fiɛ makpakpɛ̃dze ikuri ɔɖuɖu ɔki malɔ wũ ne. ");
INSERT INTO akp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Maɖi wũ ɔ̃ arapia fiɛ masu ɔgo rɛtɛa awu mapia wũ. ");
INSERT INTO akp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Masu miyu mabara ala igarakoto matɔ̃medza wũ fiɛ masu ɔdziri matã wũ. Mapɛ agɛgɛ̃ i ɔ̃ katɔ̃, fiɛ ka mato mabara wũ aɣiãra sɔ, “Ii iɖuu! Ma Yudase Igara si ɔsɛ ngbã dzoroo.” ");
INSERT INTO akp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Matua minyatu mafere wũ fiɛ masu ɔdziri maɖeɖe wũ iti. ");
INSERT INTO akp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Gɔ maɔbara wũ aɣiãra maro ne, maɖi wũ ɔgo rɛtɛa awu wa mapia wũ fiɛ makpesegu ɔ̃ are mapia wũ fiɛ maɣo ɔri sɔ maapɛ wũ mamatãra i kudziri iso. ");
INSERT INTO akp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Gɔ mato mabɔrɛ i ɔmagɛ̃ ame ne, manya ɔrɛrɛ̃ ɔwɛ̃ gɔ lobɔrɛ i Kirene fiɛ marɔ wũ sɔ Simon. Makpakpɛ̃dze ɔya wũ iso sɔ ɔfɔgu Yesu ɔnyigbã gɔ ɔsore. ");
INSERT INTO akp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Masɛ maabo ngbegɔ masɛ marɔ sɔ Golgata gɔ karɔ̃ nɖe sɔ Ɔturi Itikui. ");
INSERT INTO akp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Matã Yesu ndã mɛ masakanya ku kua gɔ mba ɔɖo sɔ ɔnɛ, ɣɛɛ gɔ ɔti ɔnyɔ ne, ɔsɛ̃ sɔ ɔ̃ito ɔnɛ. ");
INSERT INTO akp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Makpakpɛ̃dze ɔpɛ wũ mamatara i kudziri iso fiɛ ka mapɛ sibɔ ala atalebi i ɔ̃ awu iti si matsue ɔbiara nwa loaɣo wũ. ");
INSERT INTO akp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ne kama ne, masɛ i mmɔ mato madzuɛ̃ wũ. ");
INSERT INTO akp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","I ɔ̃ sitikpe ne, matsɛrɛ masia i kakoloi kawɛ̃ iso nnɛ ɔso maɖoe wũ. Matsɛrɛ sɔ, “Yesu, ma Yudase Igara ngbe ne.” ");
INSERT INTO akp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mapɛ mayukukpe inyɔ ana mamatãra ku wũ, ɔwɛ̃ i ɔ̃ kuɖearɔ̃ fiɛ ɔwɛ̃ ana i ɔ̃ kubena iso. ");
INSERT INTO akp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mma nto mafe to matidza ma ati fiɛ mato matia Yesu. ");
INSERT INTO akp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Maɣere wũ sɔ, “Fɔ gɔ fɔ sɔ aabiɛ Ɣaa iyo aledza ne itsue i ayi atɛ ame! Si Ɣaa Ɔbi aɖe ne, bɛse so i kudziri iso si aɖi so.” ");
INSERT INTO akp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ngbɔ ame i masɔrɛdze makpakpa, mmara matedze gu kaɖe makpakpa ana ɔma wũ maɣɛ sɔ, ");
INSERT INTO akp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ɔbuai mamama, ɣɛɛ ɔ̃ mɔmɔ iito ɔwo so ɔɖi. Iiɖe sɔ ɔ̃ nɖe Israel igara? Si ɔbɛse so i kudziri iso kiniɔ ne, boto boafɔ wũ boɖe! ");
INSERT INTO akp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ɔfɔ Ɣaa ɔɖe fiɛ ɔto ɔɣɛ sɔ ɔ̃ nɖe Ɣaa Ɔbi mɔmɔ, mitã bonyɔ si Ɣaa aaso ɔba ɔ̃aɖi wũ!” ");
INSERT INTO akp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ta mayukukpe ma mapɛ mamatãra ku wũ ana ɔtia wũ ngbɔ. ");
INSERT INTO akp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kakɔme iɖɔwũ iweo-inyɔ ame ne, kayi ɔsɛ̃ guduu ifɔ iɖɔwũ itɛ. ");
INSERT INTO akp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Lɛ kakɔme iɖɔwũ itɛ ame ne, Yesu ɔla kulu teteree sɔ, “Eli, Eli, lama sabaktani?” Gɔ karɔ̃ nɖe sɔ, “Wũ Ɣaa, wũ Ɣaa, be ɔso fiɛ anyua me asɛ ngbɔ?” ");
INSERT INTO akp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mma nɣɛ i mmɔ fiɛ manɔ wũ ne, maɣɛ sɔ, “Ɔto ɔkpere Eliya!” ");
INSERT INTO akp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ma ndɛ̃ ɔwɛ̃ ɔtere ɔsu ɖɔti pukupukua ɔpia i ndã bea ame ɔsu ɔɖu i ɔdziri iso ɔtara ɔtã wũ sɔ ɔnɛ. ");
INSERT INTO akp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ɣɛɛ matsɔra ɔɣɛ sɔ, “Miya! Mitã bonyɔ si Eliya aaba ɔ̃aɖi wũ i kudziri iso.” ");
INSERT INTO akp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu ɔledza kulu ila teteree kere ne ka ɔsɔra ne. ");
INSERT INTO akp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ɔwi gɔmɔ ame tutuutu ne ɔkati kpikpirikpi gɔ nsa i Kasɔrɛkɔ̃ ɔkɛ aka anyɔ ita i kato iba karɔ̃. Karɔ̃ ɔti fiɛ ata ɔbiɛbiɛ, ");
INSERT INTO akp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","akpibiɔ ɔbusi, fiɛ maturi sekelea gbodzoo ma loɔkpi mafegu ɔta mabɔrɛ i makpise ame. ");
INSERT INTO akp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Mabɔrɛ i ma akpibiɔ ame fiɛ ɔwi gɔ i Yesu ɔta ɔbɔrɛ i makpise ame ne, makɛlɛ Ɔmagɛ̃ Sekelea ame fiɛ maturi gbodzoo ɔnya ma. ");
INSERT INTO akp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Gɔ kpakpɛ̃dze ɔkpakpa gu makpakpɛ̃dze ma nɣɛ mato madzuɛ̃ Yesu ɔnya karɔ̃ iti gu ira biara nɛ loba ne, maɣɛ i ifɔ̃ ame sɔ, “Gbaã ne, Ɣaa Ɔbi ɔɖe i ngbe!” ");
INSERT INTO akp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Marɔ̃go gbodzoo ɔya dzoroo mala maɔnyɔ nnɛ nto ikɛlɛ i katɔ̃. Marɔ̃go magbe losiai wũ mabɔrɛ i Galilea fiɛ mala maɔbuai wũ ne. ");
INSERT INTO akp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ma nɖe Maria Magdalase gu Maria Yakobo gu Yosef mɛrɛ̃ ɔnyi gu Zebedeo ɔre. ");
INSERT INTO akp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Gɔ kutsuɛ ɔɣo ne, ranase ɔwɛ̃ gɔ marɔ Yosef fiɛ ɔbɔrɛ i Arimatea ɔba. Ɔ̃ wũ ne, Yesu rasuãdze ɔɖe. ");
INSERT INTO akp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ɔsɛ Pilato kɔrɛ ɔsɛ ɔ̃akarɛ sɔ ɔsu Yesu kpise ɔtã wũ, ne Pilato ɔɖi ɔri sɔ masu matã wũ ne. ");
INSERT INTO akp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ne ɔso Yosef ɔsu kpise ɔmini i ɔkati ɣɛtɛ ame, ");
INSERT INTO akp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ɔsu ɔrara i ɔ̃ ikpibiɔ nɛ ɔɖi ɔsɛ so i ita ame, ne ka ɔli ita siare ɔtɛ̃ i kanya fiɛ ɔrui ɔkɛlɛ iyo ne. ");
INSERT INTO akp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdalase gu Maria nyɔare si mato manyɔ ikpibiɔ katɔ̃. ");
INSERT INTO akp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kaɖesɛ̃a ga nɖe Iwarãyi ne, masɔrɛdze makpakpa gu ma Farisise ɔsarɛgu Pilato. ");
INSERT INTO akp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ne maɣere wũ sɔ, “Ɔbea, boto bonyigi sɔ gɔ ladze gɔmɔ si ngbã ne, ɔɣɛ sɔ, ‘Nto loaledza ita ibɔrɛ i makpise ame ku iyi tɛare si lokpi.’ ");
INSERT INTO akp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ne ɔso boto bobie sɔ tã ɔle si madzuɛ̃ ɔ̃ ikpibiɔ kukaakɔ sɔ ɔ̃ marasuãdze iibasɛ maayu ɔ̃ kpise mafiniki maɣere maturi sɔ ɔta ɔbɔrɛ i makpise ame. Sila tsɔra dzɛgbe to sianyanyarĩ siɖo siɖeakatɔ̃.” ");
INSERT INTO akp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ne Pilato ɔɣere ma sɔ, “Mikɔ makpakpɛ̃dze mikɛlɛgu si mitã madzuɛ̃ ikpibiɔ lɛ kumɛgɔ miɖɔɛ.” ");
INSERT INTO akp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ne ɔso marui masɛ maasɛ̃ ikpibiɔ kukaakɔ, masɛ ne ikparĩ fiɛ ka matã makpakpɛ̃dze ɣɛ mato madzuɛ̃. ");
INSERT INTO akp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Iwarãyi kama, ku Kɔsiɖa ɔɖesɛrã ne, Maria Magdalase gu Maria nyɔare ɔkɛlɛ sɔ maanyɔ Yesu ikpibiɔ. ");
INSERT INTO akp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ɔluwɛ̃ ne, karɔ̃ ɔti teteree, Ɣaa kpabo ɔso ɔbɔrɛ i kato ɔli ita nɛ masɛ̃ i ikpibiɔ kanya ɔsɛ i kuruɛ fiɛ ɔkpase ɔsɛ ne iso. ");
INSERT INTO akp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ɔnyɔ lɛ kumɛgɔ i kado sɛ ɔma fiɛ ɔ̃ arapia ɔfudza lɛ atumagɛrɛĩ. ");
INSERT INTO akp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ifɔ̃ ɔmɔɛ̃ makpakpɛ̃dze mati makpakpa, makpese lɛ makpise. ");
INSERT INTO akp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ne kpabo gɔmɔ ɔɣere marɔ̃go sɔ, “Midaanigã, loɣe sɔ Yesu gɔ mapɛ mamatãra i kudziri iso mito mibie. ");
INSERT INTO akp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ɔna i ngbe. Ɔ̃ɔta ɔpia ngbã lɛ kumɛgɔ ɔɣere mi ɔsɛ. Miba mianyɔ ngbegɔ marara wũ. ");
INSERT INTO akp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mikɛlɛ mala miaɣere ɔ̃ marasuãdze sɔ, ‘Ɔ̃ɔta ɔpia ngbã ne ɔɖe mi katɔ̃ ɔkpa Galilea. Mmɔ mianya wũ ne.’ Minyigi nnɛ loɣere mi.” ");
INSERT INTO akp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ne ɔso marui i ikpibiɔ kɔrɛ mmɔ ku ifɔ̃, ɣɛɛ ku isoɣɔ matere makɛlɛ masɛ maaɣere Yesu marasuãdze. ");
INSERT INTO akp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ɔluwɛ̃ ne, Yesu ɔbɔrɛ ɔya i ma katɔ̃ ɔɣere ma sɔ, “Isobuɛ itã mi.” Mabore mabo wũ mamɔɛ̃ ɔ̃ ngba masɔrɛ wũ. ");
INSERT INTO akp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu ɔɣere ma sɔ, “Midaanigã, mikɛlɛ miaɣere wũ manyiibi sɔ makɛlɛ Galilea ne mmɔ maasarɛgu me ne.” ");
INSERT INTO akp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Gɔ marɔ̃go ɔrui mato makɛlɛ ne, makpakpɛ̃dze ma wũ marui makɛlɛ ɔmagɛ̃ ame masɛ maaɣere masɔrɛdze makpakpa ara wa ɔɖuɖu manya. ");
INSERT INTO akp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Masɔrɛdze makpakpa ɔsarɛgu kaɖe makpakpa fiɛ mabara adzuni, matã makpakpɛ̃dze sikã titiiti. ");
INSERT INTO akp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ne maɣere ma sɔ, “Miɣɛ sɔ, ‘Gɔ borɛ ku kasɛ̃ ne, ɔ̃ marasuãdze ɔba maayu ɔ̃ kpise maruigu.’ ");
INSERT INTO akp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Si Roma abã ɔkpakpa ɔnɔ fiɛ ikpese itɔ̃me ne, boto boaɖiɖi ara karɔ̃ bote wũ sɔ miibana itɔ̃me.” ");
INSERT INTO akp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Makpakpɛ̃dze ɔfɔ sikã fiɛ mabara lɛ kumɛgɔ maɣere ma sɔ mabara, ne ɔso itɔ̃me nɛgbe ɔki ikã i ma Yudase ndɛ̃ iba iapɛ i nɔme. ");
INSERT INTO akp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ne kama ne, marasuãdze iweo-ɔwɛ̃ ɔkɛlɛ kabemi kawɛ̃ ga i Yesu ɔɣere ma sɔ makɛlɛ iso i Galilea. ");
INSERT INTO akp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Gɔ manya wũ ne, masɔrɛ wũ, atoa sɔ mawɛ̃ ɔwararã. ");
INSERT INTO akp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu ɔbore ɔbo ma ne ɔɣere ma sɔ, “Ɣaa ɔsu ɔle ɔɖuɖu gɔ i kato gu karɔ̃ ɔtã me. ");
INSERT INTO akp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ne ɔso mikɛlɛ maturi ɔɖuɖu kɔrɛ i kayiiso ɔɖuɖu si mibara ma sɔ maakpese wũ marasuãdze. Mipie ma Ɣaa ndu i Ɔse gu Ɔbi gu Siwarã Bielea iyere ame. ");
INSERT INTO akp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Si mite ma sɔ mabara ira biara nɛ loɣere mi. Fiɛ minɔ! Lopiagu mi ɔwi biara isɛ iabo kayi kawirikɔ̃.” ");
INSERT INTO akp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Itɔ̃me Bielea ise i Yesu Kristo, Ɣaa Ɔbi iso ngbe ne. ");
INSERT INTO akp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Koko ɔwi ne, Ɣaa Kanyaɖidze Yesaya ɔtsɛrɛ ɔsɛ sɔ Ɣaa ɔɣɛ i ɔ̃ Ɔbi iso sɔ, “Loasese kpabo ɔɖe-ɔ katɔ̃ sɔ ɔ̃aledza maturi ɔtã fɔ iba. ");
INSERT INTO akp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mito mianɔ ɔ̃ isãya gɔ ɔto ɔki i fafuĩ karɔ̃ ame sɔ, ‘Miledza ɔri mitã Bosate iba. Mikpɛ̃ ɔ̃ ɔri sekelee!’ ” ");
INSERT INTO akp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kpabo gɔgbe nɖe Yohanes gɔ lowe i fafuĩ ame ngbegɔ ɔpie maturi ndu i ɔwore ame lɛ ma Yudase sɛ mabara awe ne. Ɔɣere ma sɔ mafiniki i ma situ ame manyua akpi ɔbara si mafɔ ndu ipie kubarara si Ɣaa aasu ma akpi ɔtsɛ ma. ");
INSERT INTO akp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Maturi gbodzoo ɔbɔrɛ i Yudea karɔ̃ iso gu ma ɔmagɛ̃ siare gɔ nɖe Yerusalem makɛlɛ fafuĩ ame sɔ maakã Yohanes itɔ̃me atsue. Gɔ maɖi ma ara lalaa maɣɛ ne, Yohanes ɔpie ma ndu i Yordan ɔwore ame. ");
INSERT INTO akp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ɔwi gɔgbe ame ne, Yohanes awu wa ɔpia ne, kapuipɔngɔ siwɛrɛ̃ masu mawe, fiɛ ɔsu bɔi ɔko kafiami ɔtɔ so ɔsɔ. Aɖera wa ɔla ɔ̃ɔɖe nɖe maɣendu gu kugbadzedzei. ");
INSERT INTO akp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ɔ̃ itɔ̃me nɛ ɔla iɣɛ nɖe sɔ, “Ɔturi gɔ loaba i wũ kama ne, ɔɖo me fafaafã, ngɔ ndokota iikote sɔ loabɔdzo loɖi. ");
INSERT INTO akp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mme ne, ndu losu lopie mi. Ɣɛɛ ɔ̃ ɔto ɔ̃asu Siwarã Bielea ɔpie mi.” ");
INSERT INTO akp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ayi wamɔ ame ne, Yesu ɔbɔrɛ i Nasaret i Galilea karɔ̃ iso, ɔba ɔ̃ɔfɔ Yohanes itupie kubarara i Yordan ɔwere ame. ");
INSERT INTO akp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Gɔ Yesu to ɔbɔrɛ i ndu ame ne, ɔnya kato ɔbusi, Siwarã Bielea ɔso sisia wũ iso lɛ ilɔpɔ. ");
INSERT INTO akp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Manɔ silɔ ɔbɔrɛ i kato sɔ, “Fɔ nɖe wũ Ɔbi gɔ loipia kuɣɛ, fiɛ abo me anɔ ne.” ");
INSERT INTO akp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ɔluwɛ̃ ne, Siwarã Bielea ɔkɔ wũ sikɛlɛgu fafuĩ ame. ");
INSERT INTO akp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ɔwe i mmɔ ɔ̃ ɔnɔwɛ̃ ayi sina, ne Ɔbosam ɔba ɔ̃ala wũ ɔnyɔ ne. Ɔwe i mmɔ ku mabɔi lalaa. Ɔwi gɔmɔ ame ne, Ɣaa makpabo ɔso maba maabuai wũ mapia wũ ɔle. ");
INSERT INTO akp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Gɔ mamɔɛ̃ Yohanes mapia i iyo kama ne, Yesu ɔrui ɔkɛlɛ Galilea karɔ̃ iso ɔsɛ ɔ̃aɣɛ Ɣaa Itɔ̃me Bielea. ");
INSERT INTO akp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Mmɔ ɔto ɔɣɛ sɔ, “Ɔwi sɛɛ gɔmɔ ɔɔɣo. Ɣaa sigara ɔɖewi ɔɔbore ɔbo. Mifiniki si mifɔ Itɔ̃me Bielea nɛgbe miɖe.” ");
INSERT INTO akp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Gɔ Yesu to ɔkila i Galilea ibu kɔrɛ ne, ɔnya asabu mapiadze inyɔ ma nɖe Simon gu ɔ̃ ɔnyiibi Andrea mato mapia asabu mamɔɛ̃ akpɛ. ");
INSERT INTO akp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu ɔɣere ma sɔ, “Miba miasiai me si loakpesera mi maturi maɖidze mitã Ɣaa.” ");
INSERT INTO akp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ɔluwɛ̃ ne, manyua ma asabu masɛ marui masiai wũ. ");
INSERT INTO akp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ɔsɛ kɛkɛĩ kere ne ɔnya manyiibi inyɔ ma nɖe Zebedeo mabi Yakobo gu Yohanes. Masi i ɔkolo ame mato maledza ma asabu. ");
INSERT INTO akp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Gɔ Yesu ɔnya ma ne, ɔkpere ma sɔ masiai wũ. Ma wũ mata ɔluwɛ̃, marui i ma ɔse Zebedeo gu ɔ̃ marabaradze kɔrɛ i ɔkolo ame masiai Yesu. ");
INSERT INTO akp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu gu ɔ̃ masiaidze magbe ɔkɛlɛ ɔmagɛ̃ gɔ marɔ Kapernaum. Ma Yudase Iwarãyi ne, Yesu ɔsɛ ma kasarɛkɔ̃ ɔsɛ ɔ̃ate Ɣaa Itɔ̃me. ");
INSERT INTO akp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ibara mma lokã wũ atsue ɣii, alasɔ ɔte ara lɛ ngɔ mba ɔle, iiɖe lɛ ma Yudase mmara matedze awe. ");
INSERT INTO akp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ɔluwɛ̃ ne, ɔrɛrɛ̃ ɔwɛ̃ gɔ i siwarã lalaa si iso fiɛ ɔwe i kasarɛkɔ̃ mmɔ ");
INSERT INTO akp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ɔsiagu kulu teteree sɔ, “Yesu Nasaretse, be mpia i bo gu-ɔ ndɛ̃? Ɔba ɔɔba sɔ si aba aawɔra bo? Nɣe ɔturi gɔ igbã aɖe. Fɔ nɖe Ɣaa Ɔsesea Sekelea ne.” ");
INSERT INTO akp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu ɔtɔ̃me ɔpia siwarã sɔ, “Lo kutsuɛ si abɔrɛ i ɔ̃ ame.” ");
INSERT INTO akp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Siwarã ɔtidza ɔrɛrɛ̃ ku ɔle, sitã ɔla kulu fiɛ sibɔrɛ i ɔ̃ ame sife. ");
INSERT INTO akp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ibara mma lowe i mmɔ ɣaa, ne mato makarɛ so sɔ, “Be igbã iɖe ngbe ne? Mme ara ite igbã ka iɖe ngbe? Ngɔgbe ba ɔle ɔto ɔɖegu siwarã lalaa ika fiɛ sito sinɔ sibara i iso!” ");
INSERT INTO akp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ne ɔso Yesu iyere ɔre i Galilea karɔ̃ ɔɖuɖu iso. ");
INSERT INTO akp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Gɔ Yesu ɔbɔrɛ i kasarɛkɔ̃ mmɔ ne, ɔ̃ gu Yakobo gu Yohanes ɔkɛlɛ Simon gu Andrea iyo. ");
INSERT INTO akp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Gɔ mabo ne, mawɛ̃ ɔɣere Yesu sɔ Simon masɔrɔ̃go rɛ ɔto ɔnyɛ ɔbe ɔtɔ. ");
INSERT INTO akp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ne ɔso Yesu ɔbore ɔbo wũ, ɔmɔɛ̃ wũ kɔrɔ̃ ɔtara wũ ɔɣedza. Ɔluwɛ̃ ɔsarɛ ɔta ɔwa aɖera ɔtã ma. ");
INSERT INTO akp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Gɔ kuɣɛ̃ ɔbo iyo ne, maturi ɔsore manyɛse gu mma i siwarã lalaa si iso gbodzoo mabɔ Yesu kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ne ɔso ɔmagɛ̃ ame maturi ɔɖuɖu ɔbɔrɛ maba maɣɛ i kayogodɔ̃ mato manyɔ. ");
INSERT INTO akp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu ɔsa manyɛse ma nto manyɛ sinyɛ agbãagbã fiɛ ɔsa siwarã lalaa ɔɖi i mma ame sipia. Ɔ̃itã siɖe ika alasɔ siɣe sɔ ɔ̃ nɖe Kristo. ");
INSERT INTO akp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ɔɖesɛrã si kaɖe aaɖaɛ ne, Yesu ɔkɛlɛ ngbegɔ i kuwɛ̃ na ɔsɛ ɔ̃akparama kayi. ");
INSERT INTO akp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ɔwi kama ne, Simon gu ɔ̃ malaa ɔbie Yesu. ");
INSERT INTO akp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Gɔ manya wũ ne, maɣere wũ sɔ, “Maturi fu i mmɔ mato mabie-ɔ!” ");
INSERT INTO akp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ɣɛɛ ne, Yesu ɔɣere ma sɔ, “Mitã bokɛlɛ simagɛ̃ dzɛ loki silɔ ame. Ma wũ inya sɔ loaɣere ma Itɔ̃me Bielea, ala ne ɔso loba kayi ne.” ");
INSERT INTO akp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ne ɔso ɔki i Galilea karɔ̃ iso. Ɔkiki ngbegɔ masɛ masarɛ ɔɣɛ Itɔ̃me Bielea fiɛ ɔsa siwarã lalaa ɔɖi i maturi ame. ");
INSERT INTO akp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ɔrɛrɛ̃ ɔwɛ̃ gɔ nto ɔnyɛ ɔnyɛ rɛtɛa ɔsɛ Yesu kɔrɛ. Ɔpɛ agɛgɛ̃ ɔtã wũ iti ɔɣɛ sɔ, “Si aɖɔɛ ne, aawo me ɔsa lose sekelee.” ");
INSERT INTO akp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ɔ̃ itɔ̃me ɔɖo Yesu kayiri, ne ɔso ɔɖi kɔrɔ̃ ɔpɛgu wũ. Ne ɔɣere wũ sɔ, “Loɖɔɛ, se sekelee!” ");
INSERT INTO akp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ɔluwɛ̃ ɔsarɛ, ɔ̃ iso ɔse sekelee. ");
INSERT INTO akp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Mmɔ ame ne, Yesu ɔɣere wũ sɔ ɔrui ɔkɛlɛ. Ɔsi wũ mmara sɔ, ");
INSERT INTO akp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Daaɣere kuwɛ̃ nnɛ loba. Ɣɛɛ ne, kɛlɛ aasu so te Ɣaa sɔrɛdze si atã ara wa i Mose mmara ɔkarɛ si ite maturi sɔ ka ase sekelee.” ");
INSERT INTO akp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ɣɛɛ gɔ ɔrui ne, ɔtsɛ ɔtsɛ itɔ̃me ikararã kumɛgɔ i Yesu ɔsa wũ ɔnyɛ. Ne ɔso Yesu iisiwo ɔmagɛ̃ ame ɔbo kpawee. Ne ɔso ɔwe i fafuĩ ame fiɛ maturi ɔbɔrɛ i ngɔi gbodzoo maba ɔ̃ kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ayi arɛ̃saã kama gɔ Yesu ɔkpese ɔkɛlɛ Kapernaum ne, iifɔ ɔwi fiɛ maturi ɔnɔ sɔ ɔ̃ɔba ɔ̃abo ɔmagɛ̃ ame. ");
INSERT INTO akp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Maturi gbodzoo ɔba mmɔ gɔ kukpa kanɛkɔ̃ iisiwe i iyo nɛ kame mapia gu kayogodɔ̃. Ne ɔsɛ i mmɔ ɔɣɛ Itɔ̃me Bielea ne. ");
INSERT INTO akp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Marɛrɛ̃ ina mawɛ̃ ɔsore nyɛse gɔ lofɛfɛ̃ mato mabɔ wũ. ");
INSERT INTO akp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Maina ɔri mabo i iyo alasɔ maturi ɔɣede. Ne ɔso ne, masɛ maabusi isã makigu nyɛse masora wũ i ɔkala ame masɛ i Yesu katɔ̃. ");
INSERT INTO akp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Gɔ Yesu ɔnya ma kafɔkaɖe ne, ɔɣere nyɛse sɔ, “Ɔbi, losu fɔ akpi lotsɛ-ɔ.” ");
INSERT INTO akp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ma Yudase mmara matedze ma losɛ i ndɛ̃ mmɔ ɔbu i ma situ ame sɔ, ");
INSERT INTO akp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Be ɔso ɔto ɔɖe aka ngbɔ? Imusuora iɖe ɔɣɛ i Ɣaa iso ngbe. Ɣaa kotoo loawo akpi ɔsu ɔtsɛ.” ");
INSERT INTO akp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu ɔtsue ma adzuni, ne ɔso ɔkarɛ ma sɔ, “Be ɔso mito misusu ara wagbe i mi situ ame? ");
INSERT INTO akp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Be iɣɛ nse pɔkɔsɔɔ iɖo? Sɔ aaɣere nyɛse gɔ lofɛfɛ̃ sɔ, ‘Losu fɔ akpi lotsɛ-ɔ’ ɛɛbɛrɛ, ‘Ta, su fɔ ɔkala si asɛ’? ");
INSERT INTO akp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","“Loaɖi lote mi sɔ mme, Ɔturi Awune Ɔbi, ba ɔle i kayi gagbe iso sɔ loasu akpi lotsɛ, ne ɔso minyɔ!” Yesu ɔfiniki ɔnyɔ nyɛse, ne ɔɣere wũ sɔ, ");
INSERT INTO akp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ta si asu fɔ ɔkala si akɛlɛ iyo!” ");
INSERT INTO akp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ɔrɛrɛ̃ gɔgbe ɔta ɔluwɛ̃, ɔsu ɔ̃ ɔkala, ne ɔbɔrɛ i maturi ndɛ̃ ne. Nnɛgbe ɔbara ma ɣii, ne ɔso matsɛ Ɣaa ile. Maɣɛ sɔ mainya ara wagbe igbã manya. ");
INSERT INTO akp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu ɔkpese ɔkɛlɛ Galilea ibu kɔrɛ. Maturi gbodzoo ɔba ɔ̃ kɔrɛ fiɛ ɔtsɛ ma Itɔ̃me Bielea ite. ");
INSERT INTO akp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Gɔ ɔsɛ ne, ɔsɛ ɔ̃anya Levi gɔ nɖe Alfeo ɔbi gɔ ɔsi i ɔ̃ karabara kabarakɔ̃ ɔto ɔfɔ lampo. Ne Yesu ɔɣere wũ sɔ, “Ba siai me.” Ɔluwɛ̃ Levi ɔta ɔsiai wũ. ");
INSERT INTO akp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kama ne, Yesu gu ɔ̃ marasuãdze gu iturikuri nɛ nsiai wũ ɔba Levi iyo ame sɔ maaɖegu wũ aɖera. Ma lampofɔdze gu makpibaradze pia i mma nsiai wũ ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ne ɔso ɔwi gɔ mmara matedze ma nɖe ma Farisise ɔnya sɔ Yesu si ɔto ɔɖegu makpibaradze gu ma lampofɔdze aɖera ne, makarɛ ɔ̃ marasuãdze sɔ, “Nda ɔso fiɛ mi ɔkɔse gu mmagbe igbã nsi maɖe ara?” ");
INSERT INTO akp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Gɔ Yesu ɔnɔ nnɛ mato maɣɛ ne, ɔɣere ma sɔ, “Manyɛse i kuabaradze ɔnya ɔtã, iiɖe mma nsarɛ. Loiba sɔ loaɣere mma nsɛ mabu sɔ ma sekele sɔ mafiniki, ɣɛɛ loba lotã maturi lalaa gu makpibaradze.” ");
INSERT INTO akp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ɔwi gɔmɔ gɔ Yohanes gu ɔ̃ marasuãdze gu ma Farisise sɛ manyi kanya ɔso ne, mawɛ̃ ɔba Yesu kɔrɛ sɔ, “Be ɔso fiɛ fɔ marasuãdze iisɛ manyi kanya lɛ kumɛgɔ i Yohanes gu ma Farisise mare sɛ mabara?” ");
INSERT INTO akp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu ɔtã mmuai i igbã ame sɔ, “Ɔrɔ̃go yiridze malaa sɛ manyi kanya i ɔrɔ̃go kakɔkɔ̃? Ayi kumɛgɔ i ɔrɛrɛ̃ piagu ma ne, maibawo. ");
INSERT INTO akp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ɣɛɛ ne, iyi iwɛ̃ mato maakɔ wũ maruigu i ma kɔrɛ, iyɔ ɔ̃ malaa ka maanyi kanya. ");
INSERT INTO akp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Kuwɛ̃ iisɛ ɔta ɔkati kuere ala kakatisɛi ɣɛtɛ. Si abara ngbɔ ne, kakatisɛi ɣɛtɛ gamɔ to kaakarĩ karui iyoi nɛ loabɛ iɖo iɖeakatɔ̃. ");
INSERT INTO akp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ne ɔso ana ne, maisu ndã ɣɛtɛ mafere i bɔi ɔko akpo kuere ame. Si ndã ɣɛtɛ ɔtsɛ ifu ne, miatã sɔ ɔko kuere aabiɛ gɔ ndã gu bɔi ɔko akpo ɔɖuɖu aanina. Ne ɔso ndã ɣɛtɛ ne, akpo ɣɛtɛ ame masɛ mafere me.” ");
INSERT INTO akp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Iwarãyi iwɛ̃ gɔ Yesu sɛ ɔto ɔfe i kakpɛkɔ̃ kawɛ̃ ame gu ɔ̃ marasuãdze ne, marasuãdze ɔtsɛ atita ibɛbɛse iwe. ");
INSERT INTO akp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ne ma Farisise ɔkarɛ Yesu sɔ, “Be ɔso i fɔ marasuãdze to mabara nnɛ i bo mmara iitã ɔri sɔ maabara ku Iwarãyi.” ");
INSERT INTO akp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Mmɔ i Yesu ɔkarɛ ma sɔ, “Miika i Ɔko Sekelea ame nnɛ i David ɔbara ɔwi gɔ i kukã ɔkpɛ̃ wũ gu ɔ̃ maturi? David ɔkɛlɛ Ɣaa kasɔrɛkɔ̃ ɔwi gɔ i ");
INSERT INTO akp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiata ɖe masɔrɛdze ɔkpakpa. Ɔbo i Ɣaa iyo ɔsɛ ɔ̃asu aɖera wa masu masɔrɛ Ɣaa ɔɖe, ɔkuti ɔtã ɔ̃ masiaidze ɔɖe gɔ mmara iitã ɔri iɖo Ɣaa masɔrɛdze ɔnɔwɛ̃.” ");
INSERT INTO akp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu ɔɣere ma sɔ, “Ɣaa ɔbara Iwarãyi ɔtã ɔturi isɛɛ, ɔ̃ibara ɔturi ɔtã Iwarãyi. ");
INSERT INTO akp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ne ɔso Ɔturi Awune Ɔbi nɖe Iwarãyi Sate.” ");
INSERT INTO akp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ɔwi mama ne, Yesu ɔkɛlɛ ma Yudase kasarɛkɔ̃ ku Iwarãyi. Ɔrɛrɛ̃ ɔwɛ̃ gɔ kɔrɔ̃ lokarĩ ɔwe i mmɔ. ");
INSERT INTO akp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ɔwi gɔmɔ ne, Yesu matsirise mawɛ̃ ma nto mabie ɔri gɔ iso maaki fiɛ maaɖaɛ wũ kanya sɔ ɔɣɛrɛ ma mmara ɔkarã anɔ sɔ maanya si ɔ̃asa sinyɛ ku Iwarãyi. ");
INSERT INTO akp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu ɔɣere ɔrɛrɛ̃ gɔ kɔrɔ̃ lokarĩ sɔ ɔta ɔya i ma katɔ̃. ");
INSERT INTO akp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ne ɔki ɔnyɔ ma fiɛ ɔkarɛ ma sɔ, “Be i mmara ɔte? Sɔ ɔturi aabara isɛɛ, ɛɛbɛrɛ ilalaa ku Iwarãyi? Ɣee ilɛ sɔ aabuai ɔturi ɛɛbɛrɛ aanina ngbã?” Ɣɛɛ ne, ma kuwɛ̃ iiɣɛ kuira. ");
INSERT INTO akp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu ɔfiniki ɔnyɔ ma ku sikpã, ana ne, iɖo wũ kayiri ala ma situ gbogboroa iti. Ne ɔɣere nyɛse sɔ, “Nabarã fɔ kɔrɔ̃.” Ɔnabarã kɔ̃. Ɔluwɛ̃ kere, ilɛ wũ. ");
INSERT INTO akp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ne ma Farisise ɔrui masɛ maatu Herodes masiaidze mawɛ̃ sɔ si mabie ɔri matã ɔ̃ iɖoe ne. ");
INSERT INTO akp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesu gu ɔ̃ marasuãdze ɔkɛlɛ Galilea ibu katɔ̃. Maturi akuri wa lobɔrɛ i mmɔ abuiti gu Yudea gu Yerusalem gu Idumia gu mma lobɔrɛ i Yordan ɔwore kama gu mma lose i Tiro gu Sidon simagɛ̃ ame ana ɔsiai ma. Ɔ̃ awawãra wa ɔto ɔbara ɔɔkɛlɛ dzoroo, fiɛ maturi ɔbie sɔ maanya wũ ku ma anɔmi. ");
INSERT INTO akp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesu ɔɣere ɔ̃ marasuãdze sɔ mabie ɔkolo masɛ i ibu kuruɛ si ɔ̃abo ɔsɛ i ɔ̃ ame alasɔ maturi ɔɣede. ");
INSERT INTO akp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kumɛgɔ i maturi ɔsi ɔso ne, manyɛse to malili so sɔ maabore mabo wũ mapɛgu wũ fiɛ maasarɛ. ");
INSERT INTO akp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mma i siwarã lalaa si iso ne, si manya Yesu ne, masɛ marɔ̃ marɛ i ɔ̃ ngbatɔ̃ ku kulu sɔ, “Fɔ nɖe Ɣaa Ɔbi ne!” ");
INSERT INTO akp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ɣɛɛ ne, Yesu ɔsɛ̃ ɔtã ma sɔ madaaɖi wũ mate ngɔ ɔɖe. ");
INSERT INTO akp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ara wagbe kama ne, Yesu ɔkɛlɛ kabemi iso. Mmɔ ɔkpere mma ɔto ɔbie sɔ mawegu wũ ɔbɔ ɔ̃ kɔrɛ ne. ");
INSERT INTO akp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ma ndɛ̃ ɔɖi iweo-inyɔ fiɛ ɔtã ma iyere sɔ katɔ̃memasɛdze ne. Ɔɣere ma sɔ, “Loɖi mi sɔ si miawegu me, fiɛ loasese mi misɛ miaɣɛ Itɔ̃me Bielea. ");
INSERT INTO akp_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Lotã mi ɔle sɔ misa siwarã lalaa miɖi i maturi ame.” ");
INSERT INTO akp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ma iweo-inyɔ ma ɔɖi mmɔ nɖe Simon gɔ i Yesu ɔtã iyere sɔ Petro ");
INSERT INTO akp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","gu Yakobo gu ɔ̃ kpeama Yohanes mma nɖe Zebedeo mabi ma i Yesu ɔtã iyere sɔ Boanerges gɔ karɔ̃ nɖe sɔ Kado Kaɣɛ Mabi. ");
INSERT INTO akp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Matsɔra nɖe Andrea gu Filipo gu Bartolomeo gu Mateo gu Toma gu Yakobo gɔ nɖe Alfeo ɔbi gu Tadeo gu Simon gɔ nsɛ ɔɖɔɛ ɔ̃ aɖe kaɖe ");
INSERT INTO akp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","gu Yuda Iskariot gɔ loɖi Yesu ɔtã. ");
INSERT INTO akp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Gɔ Yesu ɔbɔrɛ i mmɔ ɔkɛlɛ iyo ne, maturi gbodzoo ɔba ma kɔrɛ ana. Ne ɔso ne, iwe ɔle gbaã sɔ Yesu gu ɔ̃ marasuãdze aana ɔwi maɖe ara. ");
INSERT INTO akp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Gɔ ɔ̃ manyii ɔnɔ ngbɔ ne, makɛlɛ sɔ maakɔ wũ mabɔ iyo, alasɔ maturi to maɣɛ sɔ, “Iti ame ka inina wũ iso!” ");
INSERT INTO akp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mmara matedze ma lobɔrɛ i Yerusalem ɔɣɛ sɔ, “Siwarã lalaa igara lotã wũ ɔle ɔso ɔto ɔwo siwarã lalaa ɔsa ɔɖi i maturi ame.” ");
INSERT INTO akp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ne ɔso Yesu ɔkpere maturi ɔɖe ma ika i igbã ame sɔ, “Nda iawo ɔba fiɛ Ɔbosam aasa so ɔɖi i ɔturi ame? ");
INSERT INTO akp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Si iba sɔ sigarakaɖekɔ̃ ɔɣɛɣɛ so mato makpɛ̃gu so ne, sigarakaɖekɔ̃ gamɔ iibawo ɔya. ");
INSERT INTO akp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Si iyo maturi ɔɣɛ so, mata maɣɛ so iso ne, iyo nɛmɔ iibawo ɔya. ");
INSERT INTO akp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ne ɔso si Ɔbosam sigarakaɖekɔ̃ ɔta siɣɛ so iso fiɛ siɣɛɣɛ so ne, ɔ̃ sigarakaɖekɔ̃ gamɔ iibawo ɔya, siɔba kawirikɔ̃. ");
INSERT INTO akp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Kuwɛ̃ iibawo ɔturi gɔ mba ɔle iyo ɔbo ɔmala ɔ̃ ara iɖo sɔ ɔ̃aɖe katɔ̃ ɔmɔɛ̃ wũ ɔnyi wũ tɔtɔ fiɛ ɔ̃abo ɔ̃ iyo ɔmala ɔ̃ ara. ");
INSERT INTO akp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Loto losia ita lotã mi sɔ Ɣaa to ɔ̃asu ara lalaa wa i ɔturi ɔbara gu anyakpi i Ɣaa iso ɔtsɛ. ");
INSERT INTO akp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ɣɛɛ ne, imusuora biara nɛ i ɔturi aaɣɛ i Siwarã Bielea iso ne, Ɣaa iibasu ɔtsɛ wũ kuiyikuiyi. Maibasu, aɣɛrɛ wagbe matsɛ manya.” ");
INSERT INTO akp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu ɔɣɛ ngbɔ alasɔ mato maɣɛ sɔ siwarã lalaa mpia i ɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ɔwi gɔmɔ ne, Yesu ɔnyi gu ɔ̃ manyiibi ɔba maaya i inyamɔ mapia wũ ɔturi sɔ mato mabie wũ. ");
INSERT INTO akp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ne mma lomini wũ i mmɔ ɔɣere wũ sɔ, “Nyɔ, fɔ ɔnyi gu manyiibi ɣɛ i inyamɔ mato makpere-ɔ!” ");
INSERT INTO akp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ne Yesu ɔkarɛ ma sɔ, “Loate mi ngɔ nɖe wũ ɔnyi mɔmɔ gu wũ manyiibi mɔmɔ.” ");
INSERT INTO akp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ne ɔki ɔnyɔ mma nsi maki malɔ wũ i mmɔ ɔɣɛ sɔ, “Minyɔ, mmagbe nɖe wũ ɔnyi gu wũ manyiibi ne! ");
INSERT INTO akp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ɔbiara gɔ nsɛ ɔbara Ɣaa kuɖɔɛ ne, ɔ̃ nɖe wũ ɔnyiibi gu wũ ɔnyi ne.” ");
INSERT INTO akp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Gɔ Yesu ɔkɛlɛ Galilea ibu kɔrɛ ana ne, ɔsɛ ɔ̃ate Itɔ̃me Bielea. Gɔ mma loki malɔ wũ ɔsi ɔso ne, ɔya ɔbo ɔsɛ i ɔkolo ame i ndu iso. Ne maturi ka maɣɛ i ɔkpokpo fiɛ Yesu to ɔɖegu ma ika ne. ");
INSERT INTO akp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ɔte ma ara gbodzoo i agbã ame. Ara wa ɔte ma i ngbe ne. ");
INSERT INTO akp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ɔɣere ma sɔ, “Kpɛ̃dze ɔwɛ̃ ɔsɛ ɔraɖui kasakɔ̃. ");
INSERT INTO akp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Gɔ ɔto ɔsa ne, ɔwɛ̃ ɔɣo i ɔri kuruɛ, ne kurodzai ɔrɛrɛ kuɖe ne. ");
INSERT INTO akp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ɔwɛ̃ ɔɣo i ata iso ngbegɔ i sise iisi, ne ɔso ɔre mala. ");
INSERT INTO akp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Gɔ kuɣɛ̃ ɔsia kere ne, ɔ̃ ɔɖuɖu ɔkpi, alasɔ ɔ̃ siɖu iibo karɔ̃. ");
INSERT INTO akp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ɔraɖui ɔwɛ̃ ɔɣo i kuposɛ̃ ndɛ̃ ne ɔso gɔ ɔre ne, kuɣa kufu wũ sɔ ɔ̃iwo ɔmɔ fiɛ ɔ̃aɣɔ̃ abi. ");
INSERT INTO akp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ɣɛɛ ne, ɔwɛ̃ ɔɣo i karɔ̃ sɛɛ iso. Gɔ ɔre ne, ɔbara kukaakɔ fiɛ ɔɣɔ̃, ɔwɛ̃ abi sitɛ, ɔwɛ̃ abi sikuɔ, fiɛ ɔwɛ̃ ana kulafa.” ");
INSERT INTO akp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kawirikɔ̃ ne, Yesu ɔɣere ma sɔ, “Ngɔ mba atsue si ɔnɔ nnɛ nto loɣɛ.” ");
INSERT INTO akp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ɔwi gɔ i Yesu ɔnɔwɛ̃ ka ɔsi ne, mma nsɛ masiai wũ ɔwi biara gu ɔ̃ marasuãdze iweo-inyɔ ɔba maakarɛ wũ sɔ ɔɖi igbã karɔ̃ ɔte ma. ");
INSERT INTO akp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ne Yesu ɔɣere ma sɔ, “Ɣaa ɔɖi ɔ̃ sigarakaɖekɔ̃ awɛrɛra karɔ̃ ɔte mi. Fiɛ mma i siruɛ ɣɛɛ ne, agbã lokote sɔ maanɔ. ");
INSERT INTO akp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Matsɛrɛ masɛ i Ɔko Sekelea ame sɔ, ‘Mato maanya, ɣɛɛ maibanya maɖi ite. Mato maanɔ, ɣɛɛ maibanɔ karɔ̃, sɔ si maibafiniki fiɛ Ɣaa aasu ma akpi ɔtsɛ ma.’ ” ");
INSERT INTO akp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ne Yesu ɔkarɛ ma sɔ, “Ɔnɔ miinɔ igbã nɛ karɔ̃? Nda miabara fiɛ mianɔ agbã tsɔra ɔɖuɖu karɔ̃? ");
INSERT INTO akp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ɔraɖui sadze gɔgbe to ɔsa Ɣaa itɔ̃me. ");
INSERT INTO akp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Maturi mawɛ̃ se lɛ ɔraɖui gɔ loɣo i ɔri kuruɛ. Gɔ manɔ ne Ɔbosam ɔmɔɛ̃ ɔɖi i ma iti ame ɔluwɛ̃. ");
INSERT INTO akp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mamama ana se lɛ ɔraɖui gɔ losia i ata karɔ̃ iso. Gɔ manɔ itɔ̃me ne, mafɔ ne ku isoɣɔ. ");
INSERT INTO akp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ɣɛɛ ne, itɔ̃me siɖu iibo karɔ̃ kukaakɔ. Mafɔ maɖe ɔwi kurukutu kere, ɣɛɛ si iɖaa gu kama iti ɔba ala Itɔ̃me Bielea iti ne, mato maafiniki makpese kama. ");
INSERT INTO akp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Fiɛ maturi mawɛ̃ ana se lɛ ɔraɖui gɔ lobo i kuposɛ̃ ame. Gɔ manɔ Itɔ̃me Bielea ne, ");
INSERT INTO akp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kayi gagbe imararãso gu karana itere isiai gu sosina ɔmɛrɛ̃ ɔyi ma i situ ame. Ara wagbe ɔnyi itɔ̃me ito sɔ iibaɣɔ̃ abi. ");
INSERT INTO akp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Mawɛ̃ ana ɔnɔ Ɣaa itɔ̃me lɛ ɔraɖui gɔ losia i karɔ̃ sɛɛ iso. Ma ne, mafɔ itɔ̃me ku ɔtu. Ne maɣɔ̃ abi lɛ ɔraɖui, mawɛ̃ abi sitɛ, mawɛ̃ sikuɔ, mawɛ̃ kulafa.” ");
INSERT INTO akp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu ɔkarɛ ma ana sɔ, “Ɔturi sɛ ɔtsue ɔkaniɛ ɔsu ɔpia i kapoi ame ɣee karɛkɔ̃ kayirinɔ? Iiɖe kasiakɔ̃ masɛ masia ɔkaniɛ fiɛ ɔ̃asa? ");
INSERT INTO akp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ira biara nɛ lowɛrɛ to iabɔrɛ kayi fiɛ mato maabusi ibiara nɛ mafu ara. ");
INSERT INTO akp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ne ɔso si miba atsue ne, si minɔ kukaakɔ!” ");
INSERT INTO akp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ne ɔɣere ma sɔ, “Mikã atsue kukaakɔ nwa mito minɔ lo! Alasɔ ikerera nɛ misu mikere mitã maturi mama ne, ne ame maasu makere matã mi makuti mafa mi ne! ");
INSERT INTO akp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Alasɔ ngɔ mba ara ne, maatã wũ mabua, ɣɛɛ ngɔ mba ara kɛkɛĩ ne, kɛkɛĩ gɔ ame ɔba ne, maamɔɛ̃ mafɔ wũ iso.” ");
INSERT INTO akp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu ɔɣere ma ana sɔ, “Ɣaa sigarakaɖekɔ̃ se lɛ ɔrɛrɛ̃ gɔ lopɛ ara i kakpɛkɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ɔsɛ ɔrɛ ɔta, iyi biara, ɔraɖui ɔre, fiɛ amɔ, fiɛ ɔ̃iɣe kumɛgɔ ibara fiɛ ara se lɛ ngbe. ");
INSERT INTO akp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Karɔ̃ ga iso mapɛ ara mɔmɔ lonyɔ ɔraɖui iso ngbɔ. Iɖeakatɔ̃ ne, ɔsɛ ɔre, ɔɖi aɣata, ɔfere aɣɔ̃la, ɔɣɔ̃ abi gbodzoo. ");
INSERT INTO akp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Si abi ɔrɛtɛ ne, kpɛ̃dze to ɔ̃asɔrɛ̃, alasɔ ɔraɖui ɔsɔrɛ̃wi ɔɔɣo.” ");
INSERT INTO akp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu ɔkarɛ sɔ, “Be boasu bokateragu Ɣaa sigarakaɖekɔ̃? Iɖe igbã nɛ loasu lokparara ne? ");
INSERT INTO akp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ise lɛ idziribi kosoi iwɛ̃ nɛ i ɔrɛrɛ̃ ɔwɛ̃ ɔsu ɔsɛ ɔ̃apɛ. ");
INSERT INTO akp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Isɛ ire ibɔrɛ, imɔ ibara kadzirimi ga lomɔ kaɖo i ayo ame kakpɛkɔ̃ ga matɛ̃ ɔkpã mapia ame, kata akpa katã ɔyu sɔ kato kurodzai aabara ayo i kã ame.” ");
INSERT INTO akp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu ɔɣere ma Itɔ̃me Bielea i agbã wagbe ame sɔ si maawo karɔ̃ ɔnɔ. ");
INSERT INTO akp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ɔ̃isɛ ɔɖe ma ika si iiɖe igbã ɔto ɔpɛ ma. Ɣɛɛ si ɔ̃ gu ɔ̃ marasuãdze ka masi ne, ɔsɛ ɔɖi wã karɔ̃ ɔte ma. ");
INSERT INTO akp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Iyi nɛmɔ kutsuɛ ame ne, Yesu ɔkpere marasuãdze ɔɣere ma sɔ, “Mitã bowara ibu bokɛlɛ ɔkpokpo gɔmɔ isɛ.” ");
INSERT INTO akp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ne marui i iturikuri kɔrɛ mmɔ mabo i ɔkolo ame ku Yesu sɔ maakɛlɛ ibu kama isɛ. Sikolo mama ana se i mmɔ. ");
INSERT INTO akp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ɔluwɛ̃ ne, awɛ ɔtsɛ ikpɛ̃, gɔ ato apɛ ndu apia i ɔkolo ame sɔ miɔro ɔyi fiɛ ɔ̃awã. ");
INSERT INTO akp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ɔwi gɔmɔ ame ne, Yesu rɛ i ɔkolo kama, ɔsu iti ɔsia i isumuɛ iso ɔto ɔrɛ sirɛ. Ne matara wũ sɔ, “Ratedze, bo kukpi iisu-ɔ kuira i mmɔ?” ");
INSERT INTO akp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu ɔta ɔya ɔtɔ̃me ɔpia awɛ ku silɔ teteree sɔ, “Awɛ, nyua ɔkpɛ̃! Ndu, sɛ kpoo!” Ɔluwɛ̃ awɛ ɔɣɔ kananana, fiɛ ndu iso ana ɔlo kpoo. ");
INSERT INTO akp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ne Yesu ɔkarɛ ɔ̃ marasuãdze sɔ, “Be ɔso miba ifɔ̃ ngbɔ? Miifɔ me miɖe?” ");
INSERT INTO akp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ifɔ̃ siare ɔmɔɛ̃ ma ne, mato makarɛ so sɔ, “Mme ɔturi igbã ɔɖe ngbe? Ndu gu ɔwiri to makã wũ atsue!” ");
INSERT INTO akp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nwagbe kama ne, Yesu gu ɔ̃ marasuãdze ɔsɛ Gadara ibuiti ame i Galilea ibu kama. ");
INSERT INTO akp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Gɔ Yesu ɔnya ɔbɔrɛ i ɔkolo ame ne, ɔrɛrɛ̃ ɔwɛ̃ gɔ ame i siwarã lalaa pia ɔsarɛgu wũ. ");
INSERT INTO akp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ɔrɛrɛ̃ gɔgbe kawekɔ̃ nɖe maturi kabiarakɔ̃. Kuwɛ̃ iisɛ ɔwo wũ ɔnyi ku ala nane ngɔsɔngɔsɔn. ");
INSERT INTO akp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ɔwi gbodzoo si mawo wũ nrɔɔ̃ gu ngba ɔnyi ne, ɔsɛ ɔtu ngɔsɔngɔsɔn gu kugbagɔrɔĩ ɔɖi so. Ɔwe ɔle gɔ kuwɛ̃ iisɛ ɔwo wũ ɔmɔɛ̃. ");
INSERT INTO akp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kasɛ̃ ɔɖuɖu gu anɔwã ne, ɔsɛ ɔwe ɔki i kabiarakɔ̃ gu kubemi iso, ɔla kulu, ɔsu ata ɔtutu so. ");
INSERT INTO akp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Gɔ ɔnya Yesu dzoroo ne, ɔtere ɔba ɔ̃apɛ agɛgɛ̃ i ɔ̃ katɔ̃. ");
INSERT INTO akp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ne ɔla kulu teteree ɔɣɛ sɔ, “Yesu, Ɣaa gɔ nɖe Ɔlesate Ɔbi! Be mpia i bo gu-ɔ inyɔ ndɛ̃? Loto-ɔ i kukpa i Ɣaa iyere ame sɔ daakpadzɛ̃ me kutsue!” ");
INSERT INTO akp_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ɔɣɛ ngbɔ alasɔ ɔnɔ Yesu ɔɣɛ sɔ, “Siwarã lalaa, bɔrɛ i ɔ̃ ame!” ");
INSERT INTO akp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ne Yesu ɔkarɛ sɔ, “Nda marɔ-ɔ?” Ɔtã mmuai sɔ, “Mme marɔ Isɛguri ne, alasɔ bo ma mpia i ɔ̃ ame ɔsi.” ");
INSERT INTO akp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ɔpɛ Yesu nrɔɔ̃ teteree sɔ ɔdaasa ma ɔɖi i karɔ̃ gamɔ ame. ");
INSERT INTO akp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Makparako gbodzoo ɣɛ mato maɖe ara i kabemi kawɛ̃ kuruɛ i mmɔ. ");
INSERT INTO akp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Siwarã lalaa ɔtã Yesu iti sɔ, “Sa bo pia i makparako ma nɣɛ i mmɔ ame.” ");
INSERT INTO akp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ne ɔtã ɔri fiɛ siwarã lalaa ɔbɔrɛ i ɔrɛrɛ̃ gɔgbe ame sibo i makparako ame ne. Makparako ma losi lɛ kukpi kunyɔ ɔtere kpitikpitikpiti maso kabemi mabo i itubu ame makpi. ");
INSERT INTO akp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mma nto manyɔ makparako iso ɔtere makɛlɛ miya gu simagɛ̃ tsɔra ame, masɛ maaɣɛ nwa loba. Ne ɔso maturi ɔtere masɛ sɔ maanyɔ. ");
INSERT INTO akp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Gɔ maba Yesu kɔrɛ ne, manya ngɔ ame i siwarã lalaa ɔwe sɔ ɔsi i karɔ̃, ɔpia awu, iti ame ɔɔkpa wũ waĩ. Ifɔ̃ ɔmɔɛ̃ ma ɔɖuɖu gbaã. ");
INSERT INTO akp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mma lonya nnɛ loba ɔɣere maturi nwa loba i ɔrɛrɛ̃ gɔmɔ gu makparako iso. ");
INSERT INTO akp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ne ɔso mapɛ Yesu nrɔɔ̃ sɔ ɔbɔrɛ i ma karɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Gɔ Yesu ɔbo i ɔkolo ame ne, ɔrɛrɛ̃ gɔ ame i siwarã lalaa ɔwe ɔpɛ wũ nrɔɔ̃ sɔ, “Tã me losiai-ɔ.” ");
INSERT INTO akp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu iitɔrãgu wũ. Ɣɛɛ ne, ɔɣere wũ sɔ, “Kpese kɛlɛ fɔ mɔmɔ maturi kɔrɛ sɛ aaɣere ma kumɛgɔ i Bosate ɔbuai-ɔ fiɛ ɔnyɔ-ɔ nnya.” ");
INSERT INTO akp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ne ɔso ɔrɛrɛ̃ gɔgbe ɔrui ɔkila simagɛ̃ iweo dzɛmɔ ame, ɔɣere ma ibiara nɛ i Yesu ɔbara ɔtã wũ gɔ ibara mma lonɔ ɣii. ");
INSERT INTO akp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu ɔkpese ɔbɔrɛ i mmɔ ɔkɛlɛ ibu ibesɛ nɛ i kama. Gɔ ɔbo mmɔ ne, maturi gbodzoo ɔsarɛgu wũ. ");
INSERT INTO akp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ɔrɛrɛ̃ ɔwɛ̃ gɔ marɔ Yairo fiɛ ɔɖe ma Yudase kasarɛkɔ̃ ɔkpakpa ɔba mmɔ. Gɔ ɔnya Yesu ne, ɔpɛ agɛgɛ̃ i ɔ̃ katɔ̃. ");
INSERT INTO akp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ne ɔpɛ wũ nrɔɔ̃ teteree ɔɣɛ sɔ, “Wũ ɔbi birɔ̃gomi to ɔnyɛ gbaã, ne ɔso ba sia wũ fɔ kɔrɔ̃ iso si ɔna isosarɛ!” ");
INSERT INTO akp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu ɔta ɔsiai wũ. Gɔ maturi ma nsiai wũ ɔsi ɔso ne, mamini wũ fiɛ masɛ. ");
INSERT INTO akp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ɔrɔ̃go ɔwɛ̃ gɔ i ara to afere akɔ aweo-anyɔ buu ɔwe i maturi ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Atoa sɔ sinyɛ masadze to matã wũ awa ne, ɔwe i ibo ame. Ɔ̃ɔnina ɔ̃ sikã ɔɖuɖu ɔsa ɔnyɛ gɔgbe, ɣɛɛ ɔ̃ito ɔsarɛ. Ɣɛɛ ɔnyagɛ̃ kere i ɔnyɛ togu. ");
INSERT INTO akp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ɔnɔ Yesu iyere, ne ɔso ɔbo i maturi ndɛ̃, ɔki i Yesu kama isɛ ɔpɛgu ɔ̃ awu kutsueti. ");
INSERT INTO akp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ala ɔɣere so sɔ, “Si loana ɔ̃ awu kere lopɛgu ne, loto loasarɛ.” ");
INSERT INTO akp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ne ɔso gɔ ɔpɛgu Yesu awu kere ne, ara wa nto afere wũ ko loɖaɛ! Ne ɔtsue i ɔ̃ ame sɔ ɔ̃ɔna isosarɛ ne. ");
INSERT INTO akp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ɔluwɛ̃ Yesu ɔtsue sɔ ɔle ɔwɛ̃ ɔbɔrɛ i ɔ̃ ame. Ne ɔso ɔtui ɔfiniki ɔkarɛ mma nsiai wũ sɔ, “Nna ɔɖe lopɛgu me awu?” ");
INSERT INTO akp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ɔ̃ marasuãdze ɔɣere wũ sɔ, “Nyɔ kumɛgɔ i maturi ɔki malɔ bo. Be ɔso fiɛ ato akarɛ sɔ nna lopɛgu-ɔ?” ");
INSERT INTO akp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesu ɣɛ ɔto ɔpiapia anɔmi sɔ ɔ̃anya ngɔ lopɛgu wũ. ");
INSERT INTO akp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ɔrɔ̃go ana ɔtsue kumɛgɔ ka ise wũ. Ne ɔso i ifɔ̃ ame ne, ɔsɛ ɔba ɔ̃apɛ agɛgɛ̃ i Yesu ngbatɔ̃. Ne ɔɖi ɔte wũ kumɛgɔ iba ne. ");
INSERT INTO akp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu ɔɣere wũ sɔ, “Wũ ɔbi birɔ̃gomi, fɔ kafɔkaɖe losa-ɔ. Rui kɛlɛ i isoɣɔ ame. Fɔ ɔnyɛ ɔɔlɛ-ɔ.” ");
INSERT INTO akp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Gɔ Yesu togu ika iɖe ne, maturi ɔbɔrɛ i Yario iyo maba maaɣere wũ sɔ, “Fɔ ɔbi birɔ̃gomi ɔɔkpi. Be ɔso akpese ato aɖaa Ratedze?” ");
INSERT INTO akp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu iifɔ itɔ̃me ne maɣɛ mmɔ. Ne ɔɣere Yairo sɔ, “Daanigã, fɔɖe kere!” ");
INSERT INTO akp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu iibie sɔ kuwɛ̃ si ɔsiai wũ, ne ɔso ɔkɔ Petro gu Yakobo gu ɔ̃ ɔnyiibi Yohanes marui makɛlɛ Yairo iyo. ");
INSERT INTO akp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Gɔ mabo iyo fiɛ Yesu ɔnya sikpabo, kulu gu kaku ga mato mabiɛ ne, ");
INSERT INTO akp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ɔbo i ma ndɛ̃, ne ɔkarɛ sɔ, “Be nsɛgu kulu gɔgbe? Be fiɛ mito mibiɛ? Ɔbi iikpi, sirɛ kere ɔto ɔrɛ!” ");
INSERT INTO akp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Gɔ ɔɣɛ ngbɔ ne, mma nɣɛ i mmɔ ɔtsɛ wũ ima. Ne Yesu ɔɖi ma ɔɖuɖu i iyo ne, ɔtã ɔbi ɔ̃ ɔse gu ɔbi ɔ̃ ɔnyi gu ɔ̃ marasuãdze ɔbo iyo ngbegɔ i ɔbi kpise rɛ. ");
INSERT INTO akp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesu ɔmɔɛ̃ wũ i kɔrɔ̃, ne ɔɣɛ sɔ, “Talita Kumi.” Ne karɔ̃ i ma aɖe siɖe ame nɖe sɔ, “Ɔbirɔ̃gomi, ta!” ");
INSERT INTO akp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ɔluwɛ̃ kabirɔ̃gomi ga loɔfɔ akɔ aweo-anyɔ kere lota katsɛ isɛ iki. Nnɛgbe ɔbara ma ɔɖuɖu ɣaa gbaã! ");
INSERT INTO akp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu ɔsi ma mmara sɔ madaaɣere kuwɛ̃ ɖuɖuuɖu. Ne ka ɔɣere ma sɔ, “Mitã wũ aɖera ɔɖe.” ");
INSERT INTO akp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu ɔbɔrɛ i mmɔ ɔkɛlɛ ma aɖe ku ɔ̃ marasuãdze. ");
INSERT INTO akp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Gɔ Iwarãyi ɔɣo ne, ɔsɛ ɔ̃ate ara ɔsegu i Itɔ̃me Bielea iso i ma Yudase kasarɛkɔ̃. Ibara mma lonɔ ɔ̃ atɔ̃me ɣaa. Makarɛ so sɔ, “Lɛ ɔsegu ara wagbe. Mme inɔgba igbã matã wũ fiɛ ɔto ɔwo awawãra wagbe ɔbara? ");
INSERT INTO akp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ɛɛbɛrɛ iɖe ɔ̃ nɖe Maria ɔbi gɔ nɖe rawedze? Yakobo gu Yose gu Yuda gu Simon mɛrɛ̃ ɔnyiibi? Fiɛ ɔ̃ manyiiko ana pia i bo ndɛ̃ ngbe.” Ne ɔso maifɔ wũ. ");
INSERT INTO akp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu ɔɣere ma sɔ, “Ɣaa kanyaɖidze ba kuwarɛ i kakɔi biara iɖo ɔ̃ mɔmɔ ɔmagɛ̃, ɔ̃ maturi gu ɔ̃ iyo maturi anɔmi ame.” ");
INSERT INTO akp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ɔ̃iwo awawãra gbodzoo ɔbara iɖo nrɔɔ̃ mɛ ɔsia manyɛse irɛ̃saã iti fiɛ masarɛ. ");
INSERT INTO akp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ɔmagɛ̃ ame maturi idaafɔ iɖe ɔbara wũ ɣaa. Nwagbe kama ne, Yesu ɔkila simagɛ̃ kosoi tsɔra i mmɔ ɔte Itɔ̃me Bielea. ");
INSERT INTO akp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ɔkpere ɔ̃ marasuãdze iweo-inyɔ ɔsirakanya, ne ɔsese ma inyɔ-inyɔ ne. Ɔtã ma ɔle sɔ masa siwarã lalaa. ");
INSERT INTO akp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ɔsɛ̃ ɔtã ma sɔ, “Midaasu kuira mila i mi irisɛ ame iɖo ɔsɛdziri. Midaasu aɖera ɣee akpo. Midaapia sikã i mi kukotoi ame. ");
INSERT INTO akp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mipia ndokota, ɣɛɛ midaasu awu mama iɖo nwa mipia.” ");
INSERT INTO akp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ɔɣere ma ana sɔ, “Kakɔi biara ga maafɔ mi ne, miwe i mmɔ gbɔgbɔɔgbɔ miarui. ");
INSERT INTO akp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ɣɛɛ kakɔi biara ga maturi loifɔ mi ɣee maikã mi atsue ne, mikpakpa mi ngba iso sise mifere lɛ Ɣaa kutsue ikpadzɛ̃ nɛ loaba ikparĩ.” ");
INSERT INTO akp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Marasuãdze ɔsame mabo mato maɣɛ Itɔ̃me Bielea sɔ maturi si mafiniki i ma ara lalaa kama si mabara Ɣaa kuɖɔɛ. ");
INSERT INTO akp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Masa siwarã lalaa gbodzoo maɖi i maturi ame, masɔla manyɛse kasɛ siare nnɔĩ fiɛ mana iso ɔsarɛ. ");
INSERT INTO akp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ɔwi gɔgbe ame ne, Igara Herodes ka ɔto ɔnɔ ara wagbe, alasɔ Yesu iyere ɔɔpɛ ibiɛ. Mawɛ̃ to maɣɛ sɔ, “Ndupiedze Yohanes loɔta ɔbɔrɛ i makpise ame ɔpia ngbã! Ne ɔso ɔba ɔle ɔto ɔbara awawãra ne!” ");
INSERT INTO akp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mawɛ̃ ana sɔ, “Ɣaa Kanyaɖidze Eliya ɔɖe.” Mamama ana sɔ, “Ɣaa kanyamaɖidze ɔwɛ̃ ɔɖe lɛ makuere ɔwi.” ");
INSERT INTO akp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ɔwi gɔ i Herodes ɔnɔ atɔ̃me wagbe ne, ɔ̃ wũ ɔɣɛ sɔ, “Yohanes gɔ lotã matu iti ɔɖe loɔta ɔba ngbã ana!” ");
INSERT INTO akp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tɔtɔ ne, Herodes ɔtã mamɔɛ̃ Yohanes, manyi wũ marara i iyo ala Herodia gɔ nɖe ɔ̃ ɔnyiibi Filipo ɔre gɔ ɔfɔ ɔyiri iti. ");
INSERT INTO akp_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Gɔ Yohanes ɔɣere Herodes sɔ, “Iilɛ sɔ aafɔ fɔ ɔnyiibi ɔ̃ ɔre” ɔso ne, ");
INSERT INTO akp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ɔ̃ itɔ̃me to Herodia sikpã, ne ɔso ɔbie sɔ ɔ̃aɖoe wũ, ɣɛɛ ɔ̃iwo. ");
INSERT INTO akp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes ɔla ɔ̃ɔnigã Yohanes, alasɔ ɔɣe sɔ ɔnukuarese gu ɔturi sekelea ɔɖe. Ne ɔso ɔto ɔdzuɛ̃ wũ. Ɔbie sɔ ɔ̃akã ɔ̃ itɔ̃me atsue ɔwi ku ɔwi ame atoa sɔ ɔ̃ atɔ̃me sɛ ɔtsue wũ ɔtu si ɔnɔ. ");
INSERT INTO akp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Katsɔrakɔ̃ ne, Herodia ɔna ɔri gɔ Herodes ɔɖe ɔ̃ iɣeyi. Herodes ɔkpere magarakpakpa i ɔ̃ sigarakaɖekɔ̃ gu makpãrɛrɛĩ, katɔ̃maɖedze gu Galilea karɔ̃ katɔ̃maɖedze ɔsirakanya itã ɔpɔrɔ̃ itu. ");
INSERT INTO akp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodia ɔbi bitɛ ana ɔba ɔ̃atɔ ɔte Herodes gu ɔ̃ malaa ɔpia ma isoɣɔ i aɖera kaɖekɔ̃ mmɔ. Ne ɔso Igara Herodes ɔkarɛ ɔbitɛ gɔgbe sɔ, “Be aɖɔɛ sɔ lotã-ɔ?” ");
INSERT INTO akp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ne ka ɔɣɛ ɔsia sɔ, “Lotarĩgu wũ sigaraiyara sɔ loatã-ɔ ira biara nɛ aakarɛ me, isɛ iatui i wũ sigarakaɖekɔ̃ kasɛ kawɛ̃!” ");
INSERT INTO akp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ne ɔso, ɔbitɛ gɔgbe ɔsɛ ɔ̃akarɛ ɔ̃ ɔnyi sɔ, “Be si lokarɛ?” Ne ɔ̃ ɔnyi ɔɣere wũ sɔ, “Karɛ wũ Ndupiedze Yohanes iti.” ");
INSERT INTO akp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ɔbitɛ ɔpɛ siwa ɔkɛlɛ igara kɔrɛ ɔɣere Herodes sɔ, “Lobie sɔ loafɔ Ndupiedze Yohanes iti i kategelei iso ngbe kiniɔ!” ");
INSERT INTO akp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Itɔ̃me nɛgbe ɔbo Herodes so kukaakɔ, ɣɛɛ kumɛgɔ ɔkã ndamu i makpakpa ma nsigu wũ i ɔpɔrɔ̃ iti katɔ̃ ɔso ne, ɔ̃isɛ̃ nnɛ i ɔbi ɔkarɛ. ");
INSERT INTO akp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ɔluwɛ̃ ɔpia ɔ̃ kaɖaɛsime sɔ ɔsɛ ɔ̃atu Yohanes iti ɔbɔ. Ne ɔkɛlɛ ngbegɔ i Yohanes rɛ i iyo ɔsɛ ɔ̃atu wũ iti ne. ");
INSERT INTO akp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ɔsu ne ɔsia i kategelei iso, ɔsu ɔba ɔ̃atã ɔbitɛ gɔgbe. Ne ɔfɔ, ɔsu ɔkɛlɛgu ɔ̃ ɔnyi ne. ");
INSERT INTO akp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Gɔ Yohanes marasuãdze ɔnɔ ne, masɛ maasu wũ masɛ maabiara. ");
INSERT INTO akp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Katɔ̃memasɛdze ma i Yesu ɔsese sɔ masɛ maaki maɣɛ Itɔ̃me Bielea ɔkpese maba maaɣere wũ nwa ɔɖuɖu mabara gu nwa masɛ maate i ma irisɛ ame. ");
INSERT INTO akp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Maturi ma nto maba ma kɔrɛ ɔfe iɣede sɔ Yesu gu ɔ̃ marasuãdze siina ɔwi sɔ maaɖe nane aɖera. Ne ɔso Yesu ɔɣere ma sɔ, “Mitã bo ɔnɔwɛ̃ saã si bokɛlɛ ngbegɔ i kuwɛ̃ na si bosɛ boawarã kɛkɛĩ.” ");
INSERT INTO akp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mata mabo i ɔkolo ame sɔ masɛ ngbegɔ i maturi na. ");
INSERT INTO akp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ɔwi gɔ marui ne, maturi ɔnya maɖi ite, ne masɛ ngba mabɔrɛ i ma simagɛ̃ ame ɔɖuɖu maɖe ma katɔ̃ masɛ maabo fiɛ Yesu gu ɔ̃ marasuãdze kɔra ɔbo mmɔ. ");
INSERT INTO akp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Gɔ Yesu ɔso ɔbɔrɛ i ɔkolo ame fiɛ ɔnya maturi gbodzoo ma loba ne, ma ara ɔɖo wũ kayiri, alasɔ mase lɛ masɛrɛrerɔ̃ ma nna kɔdze. Ne ɔso ɔtsɛ ma ara gbodzoo ite. ");
INSERT INTO akp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Gɔ kutsuɛ ɔɣo ne, marasuãdze ɔbore mabo wũ maɣere wũ sɔ, “Kaɖe ɔɔro fiɛ ngbe ɔdzorogu ayo ame. ");
INSERT INTO akp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ɖi ma ɔri si makɛlɛ simagɛ̃ kosoi gu miya mɛ lobore mibo ngbe si masɛ maaɣa aɖera maɖe.” ");
INSERT INTO akp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu ɔɣere ma sɔ, “Mi mɔmɔ mitã ma irere maɖe.” Ne maɣere wũ sɔ, “Nnɛmɔ to iafɔ lɛ ɔturi awa farafana kuso. Ato abie sɔ bonina ngbɔ itã ma aɖera?” ");
INSERT INTO akp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ne Yesu ɔkarɛ ma sɔ, “Abolo arɛ̃ miba i mi ara ame? Misɛ mianyɔ.” Gɔ masɛ maanyɔ ne, maɣere wũ sɔ, “Abolo abo aru gu kufarai kunyɔ lokuti.” ");
INSERT INTO akp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesu ɔɣere ɔ̃ marasuãdze sɔ matã maturi si masɛ i karɔ̃ akuri ame i sikua iso. ");
INSERT INTO akp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ne ɔso masɛ i karɔ̃ i akuri ame lɛ kulafa kulafa gu siru siru kusime. ");
INSERT INTO akp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu ɔsu abolo gu afara anyɔ wamɔ, ɔnyɔ kato. Gɔ ɔpɛ Ɣaa siba i wã iti ne, ɔbɛbɛse ɔtã ɔ̃ marasuãdze sɔ maɣɛɣɛ mmamɔ. Ɔkpɛkpɛti kufarai kunyɔ ana ɔtã ma. ");
INSERT INTO akp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Gɔ ma ɔɖuɖu ɔɖe ara mami, ");
INSERT INTO akp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","fiɛ marasuãdze ɔsa nwa lobuburi kanya ne, mana kusɛsɛi kuweo-kunyɔ. ");
INSERT INTO akp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mma loɖe aɖera wamɔ ne, marɛrɛ̃ kerekere ɔsi mabo kukpi kuru. ");
INSERT INTO akp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ɔluwɛ̃ Yesu ɔtã ɔ̃ marasuãdze ɔya mabo i ɔkolo ame sɔ mawara makɛlɛ Betsaida. Ne ɔ̃ wũ ka ɔɖi iturikuri ɔri ne. ");
INSERT INTO akp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Gɔ ɔ̃ɔɖi ma ɔri ɔro ne, ɔrui ɔkɛlɛ kube iso sɔ ɔ̃akparama kayi. ");
INSERT INTO akp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Si kutsuɛ aaɣo ne, ɔkolo ka ɔsɛ i ibu ndɛ̃, Yesu ɔnɔwɛ̃ ana ɣɛ i ibu katɔ̃. ");
INSERT INTO akp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ɔnya sɔ ɔ̃ maturi ba imɔrɛ̃ i ɔkolo iwa ame, alasɔ ɔwiri to ɔli ma. Ne ɔso si iapɛ kaya iɖɔwũ iru ne, Yesu ɔtsɛ isɛ ikɛlɛ ma kɔrɛ i ibu iso, ɔbie sɔ si ɔfe ma, ");
INSERT INTO akp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","mala kulu i ifɔ̃ ame sɔ, “Iɣii! Kpise ɔɖe!” ");
INSERT INTO akp_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Manigã gbaã sɔ manya wũ i ndu iso. Ne Yesu ɔɣere ma sɔ, “Midaanigã! Mme loɖe. Mina ɔtu.” ");
INSERT INTO akp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ne ɔya ɔbo i ɔkolo ame fiɛ ɔwiri ɔnyua ikpɛ̃ ne. Ibara ɔ̃ marasuãdze ɣaa gbaã! ");
INSERT INTO akp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Alasɔ maitsue kumɛgɔ ibara fiɛ ɔtã maturi kukpi kuru aɖera maɖe mami. Mainɔ karɔ̃, ne ɔso maifɔ maɖe. ");
INSERT INTO akp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Gɔ mawara itubu ne, maba maabo Genezaret karɔ̃ iso, ne ɔso mapɛ ma ɔkolo ikpo i ibu katɔ̃. ");
INSERT INTO akp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Gɔ maya mabɔrɛ ɔkolo ame kere ne, maturi ɔnya Yesu maɖi ite. ");
INSERT INTO akp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ne ɔso matere maɣere matsɔra. Kakɔi biara ga i Yesu ɔbo ne, masore manyɛse mabɔ wũ i ma sikala iso. ");
INSERT INTO akp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ne ɔso ngɔi mɛ pelepele i Yesu ɔki, simagɛ̃ ame o-o, nsɛkɔ̃ o-o ne, maturi ɔsore manyɛse mabɔ kuɣakaɖekɔ̃ fiɛ mapɛ wũ nrɔɔ̃ sɔ ɔtã mapɛgu bidɛ ɔ̃ awu kutsueti kere. Mma ɔɖuɖu lopɛgu wũ ne, mana isosare. ");
INSERT INTO akp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ma Farisise mawɛ̃ gu ma Yudase mmara matedze mawɛ̃ ɔbɔrɛ i Yerusalem maba Yesu kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Manya sɔ ɔ̃ marasuãdze mawɛ̃ si mato maɖe ara ku nrɔɔ̃ ɣɛa mɛ maifore i mmara kanya. ");
INSERT INTO akp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ma Farisise gu ma Yudase tsɔra siai ma mawa kubarara gɔ manyua masɛ ma. Ne ɔso ngbɛsi mafore nrɔɔ̃ lɛ kumɛgɔ mate ma fiɛ maaɖe ara. ");
INSERT INTO akp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Si mase i kuɣa ame fiɛ maipie ndu ne, maibaɖe ara. Mamɔɛ̃ ma kubarara mama mato i akɔi gu awabui gu ndu abui ifore iso. ");
INSERT INTO akp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ne ɔso ma Farisise gu mmara matedze magbe ɔkarɛ Yesu sɔ, “Be ɔso fiɛ fɔ marasuãdze iisɛ mabara i bo mawa kubarara iso? Mato maɖe ara gɔ maifore nrɔɔ̃ i kubarara kanya.” ");
INSERT INTO akp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu ɔtã ma mmuai sɔ, “Mi ne, maladze miɖe! Ɣaa Kanyaɖidze Yesaya ɔkpɛ ɔya gɔ ɔɣɛ i mi iso sɔ, ‘Mmagbe ne, kanya kunu kere masu mato male me gɔ iibɔrɛ i ma situ ame. ");
INSERT INTO akp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Siefe kere mato mabara wũ karabara. Mato mate maturi mmara i wũ mire kanya.’ ");
INSERT INTO akp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ite sɔ misu wũ mmara mibiara fiɛ misu ɔturi awune mire mito mite.” ");
INSERT INTO akp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu ɔɣere ma ana sɔ, “Misɛ̃ Ɣaa mmara sɔ si miawo mi mawa kubarara ɔla. ");
INSERT INTO akp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mose ɔtsɛrɛ ɔsɛ sɔ, ‘Warɛ fɔ ɔse gu fɔ ɔnyi. Si ɔrere ɔɣɛ inyakpi i ɔ̃ ɣese iso ne, ɔkote ɔtã kukpi ipɔ.’ ");
INSERT INTO akp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ɣɛɛ mi wũ mito mite sɔ si ɔrere ba ira nɛ ikote sɔ ɔ̃asu ɔbuai ɔ̃ maɣese fiɛ ɔɣɛ sɔ, ‘Nnɛ loasu lotã-ɔ loɔsu lotã Ɣaa’ ne. ");
INSERT INTO akp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Miitã ɔri sɔ ɔ̃asu karatã gagbe ɔbuai ɔ̃ maɣese. ");
INSERT INTO akp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ɔri gɔgbe iso misu mi mawa kubarara mito minina Ɣaa mmara fiɛ mito mibara ara mama lɛ ngbe ana ne.” ");
INSERT INTO akp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Mmɔ kama ne, Yesu ɔkpere maturi gbodzoo ɔbɔ so i kɔrɛ ɔɣere ma sɔ, “Ngɔ mba atsue si ɔnɔ nnɛ nto loɣɛ. ");
INSERT INTO akp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nnɛ i ɔturi ɔɖe iibawo wũ ɔpukutura, ");
INSERT INTO akp_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ɣɛɛ nnɛ nsɛ ibɔrɛ i ɔ̃ ame nsɛ ipukutura wũ.” ");
INSERT INTO akp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kama gɔ ɔrui i iturikuri kɔrɛ ɔkɛlɛ iyo ne, ɔ̃ marasuãdze ɔkarɛ wũ sɔ ɔɖi ara wamɔ karɔ̃ ɔte ma. ");
INSERT INTO akp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu ɔkarɛ ma sɔ, “Miinɔ itɔ̃me nɛ ana karɔ̃? Iikpa sɔ ira nɛ ɔturi ɔɖe ne, iibatã sɔ ɔ̃ibase sekelee? ");
INSERT INTO akp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Alasɔ iibo i ɔ̃ ɔtu ame. Ɣɛɛ ne, ɔ̃ iyiri ame ibo fiɛ ibɔrɛ ife ɔturi ame lɛ ɔdziriiso awe.” Ne ɔso Yesu to ɔɣɛ sɔ aɖera ɔɖuɖu lɛ atã iɖe. ");
INSERT INTO akp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ne ɔkɛlɛgu i katɔ̃ sɔ, “Atɔ̃me wa nsɛ abɔrɛ i ɔturi kanya ame nsɛ ipukutura wũ. ");
INSERT INTO akp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Alasɔ ɔturi ɔtu ame i adzuni nyanyarĩa sɛ abɔrɛ lɛ fɔ ɔre ɣee ɔrã kama ife, kayu, ituriɖoe, asɔrɔ̃ra, ");
INSERT INTO akp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","amumu, ɔtile, mila gu sosina ɔmɛrɛ̃ gɔ nsɛgu kunuarɛ, anɔ ibɛbɛ i ɔturi ira iso, ɔturi iyere inina, iteso lalaa, ɔɖegbodzo, adzimira, gu ituridaawarɛ. ");
INSERT INTO akp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nwagbe ɔɖuɖu ɔbɔrɛ i ɔturi ame gɔ atã wũ sɔ ɔ̃aɣɛ.” ");
INSERT INTO akp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu ɔbɔrɛ i mmɔ ɔkɛlɛ Tiro awo ame. Ɔkɛlɛ iyo iwɛ̃ ame si madaatsue sɔ ɔbo mmɔ, ɣɛɛ ɔ̃iwɛrɛ. ");
INSERT INTO akp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Gɔ ɔrɔ̃go ɔwɛ̃ gɔ ɔbi birɔ̃gomi iso i siwarã lalaa si ɔnɔ sɔ Yesu pia i mmɔ ne, ɔba ɔ̃apɛ agɛgɛ̃ i ɔ̃ katɔ̃. ");
INSERT INTO akp_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ɔpɛ wũ nrɔɔ̃ sɔ ɔsa siwarã lalaa ɔɖi i ɔ̃ ɔbi ame. Ɔrɔ̃go gɔgbe ne, ɔ Helase ɔɖe. Maɣe wũ i ɔmagɛ̃ gɔ marɔ Foinike i Siria karɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ɣɛɛ Yesu ɔɖi kanya sɔ, “Tã mabiɛtɛ si maɖe ara mami tɔtɔ. Iilɛ sɔ maasu mabiɛtɛ aɖera matã makpɛkpɛ.” ");
INSERT INTO akp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ɔrɔ̃go gɔgbe ɔɣere wũ sɔ, “Aĩ, Tete, makpɛkpɛ ma mpia i ɔpɔrɔ̃ kayirinɔ sɛ maɖe aɖera wa i mabiɛtɛ ɔɖe fiɛ akpakpase.” ");
INSERT INTO akp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ne Yesu ɔɣere wũ sɔ, “Fɔ mmuai mɛ atã ɔso ne, rui kɛlɛ iyo. Ato aasɛ aanya sɔ siwarã dzɛmɔ ɔɔta i ɔbi iso.” ");
INSERT INTO akp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Gɔ ɔrɔ̃go ɔkɛlɛ iyo ne, ɔsɛ ɔ̃anya sɔ ɔ̃ ɔbi rɛ ɔto ɔwarã fiɛ siwarã lalaa ɔɔta wũ iso. ");
INSERT INTO akp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Gɔ Yesu ɔrui i Tiro awo ame mmɔ ne, ɔki i Sidon, ɔkɛlɛ Galilea Ibu kɔrɛ ngbegɔ i simagɛ̃ iweo siwɛ̃ pia. ");
INSERT INTO akp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mabɔ wũ ɔrɛrɛ̃ gɔ i atsue ɔtɛ̃ fiɛ ɔsɛ ɔtoto siɖe ana. Ne mapɛ wũ nrɔɔ̃ sɔ ɔsia wũ kɔrɔ̃ iso si ɔsa wũ. ");
INSERT INTO akp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu ɔkɔ wũ ɔsɛgu kuruɛ, ne ɔpia wũ arɔĩ i atsue ame ne. Ɔti sinyatu ɔsu ɔpɛgu wũ ɔnyagɛmi. ");
INSERT INTO akp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ne Yesu ɔnyɔ kato, ɔwarã ɔkuti, ne ɔɣere ɔrɛrɛ̃ sɔ, “Hefata!” gɔ karɔ̃ i ma siɖe ame nɖe sɔ, “Busi!” ");
INSERT INTO akp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ɔluwɛ̃ atsue ɔbusi wũ, ɔ̃ ɔnyagɛmi ɔkurisi, fiɛ ɔtsɛ aka iɖe kukaakɔ. ");
INSERT INTO akp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu ɔsi ma mmara sɔ madaaɣere kuwɛ̃ ara wa manya. Ɣɛɛ ne, ita iso kere ɔfere ndu, alasɔ ma kanya ɔla teteree. ");
INSERT INTO akp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mma ɔɖuɖu lonɔ nwagbe ne, ibara ma ɣaa gbaã! Ne mato maɣere so sɔ, “Ɔbara ibiara i ɔri iso. Ɔtã ɔmumu ɔɖe aka, fiɛ matsuetɛ̃se ana ɔnɔ ara.” ");
INSERT INTO akp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ayi wamɔ ame ne, maturi gbodzoo ɔba maasakanya. Gɔ kuira iikuti gɔ maaɖe ɔso ne, Yesu ɔkpere ɔ̃ marasuãdze ɔbɔ so i kɔrɛ ɔɣere ma sɔ, ");
INSERT INTO akp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Mmagbe ara to akpɛ̃ me nnya alasɔ maɔwe i wũ kɔrɛ akpɛnɛ atɛ i ngbe ne. Kiniɔ ne, mana kuira nɛ maaɖe. ");
INSERT INTO akp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Si loɖi ma ɔri sɔ marui ne, mato maafɛ̃ i ɔri, alasɔ ma mawɛ̃ ɔbɔrɛ i ngɔi dzoroa.” ");
INSERT INTO akp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ne ɔ̃ marasuãdze ɔkarɛ wũ sɔ, “Fafuĩ gɔgbe ame ne, lɛ boana aɖera botã mmagbe ɔɖuɖu fiɛ maaɖe mami?” ");
INSERT INTO akp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mmɔ i Yesu ɔkarɛ ma sɔ, “Abolo kuboi kurɛ̃ mito?” Maɣere wũ sɔ, “Abolo kuboi kukɔdzɛ boba.” ");
INSERT INTO akp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesu ɔɣere ma ɔɖuɖu sɔ masɛ i karɔ̃. Ɔsu abolo akɔdzɛ, ɔpɛ Ɣaa siba fiɛ ɔbiɛbiɛ wã ɔsu ɔtã marasuãdze sɔ maɣɛ matã ɔbiara kɛkɛ. ");
INSERT INTO akp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Maba kufarai kurɛ̃ saã ana, ne Yesu ɔsu, ɔpɛ siba i kɔ̃ iti fiɛ ɔsu ɔtã marasuãdze maɣɛɣɛ ma ne. ");
INSERT INTO akp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ma ɔɖuɖu ɔɖe mami pɔpɔɔpɔ ne gɔ marasuãdze ɔsa akutia kanya ne, mana kusɛsɛi kukɔdzɛ. ");
INSERT INTO akp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Marɛrɛ̃ kerekere kukpi kuna loɖe ara. Ne gɔ Yesu ɔɔɖi ma ɔri ne, ");
INSERT INTO akp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ɔ̃ gu ɔ̃ marasuãdze ɔya mabo i ɔkolo ame mawara makɛlɛ Dalmanuta awo ame. ");
INSERT INTO akp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ma Farisise ɔba Yesu kɔrɛ maakarɛ atɔ̃me sɔ si mala wũ manyɔ. Ne maɣere wũ sɔ ɔbara iwawãra ɔte sɔ Ɣaa kɔrɛ ɔbɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ɣɛɛ Yesu ɔwarã ɔkuti ɔkarɛ ma sɔ, “Nda ɔso fiɛ kiniɔgbe maturi to mabie awawãra sɔ maanya? Ooɣo! Loiba sɔ loabara awawãra lote mi lɛ kumɛgɔ mito mibie!” ");
INSERT INTO akp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ne ɔrui i ma kɔrɛ ɔbo i ɔkolo ame ɔkɛlɛ ibu kama isɛ ne. ");
INSERT INTO akp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Gɔ mato mawara ibu ne, ɔ̃ marasuãdze ɔɣara sɔ maabɔ abolo. Kaboi kawɛ̃ kere mato i ɔkolo ame. ");
INSERT INTO akp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ne Yesu ɔɣere ma sɔ, “Mikã me atsue si midzuɛ̃ so kukaakɔ i Igara Herodes gu ma Farisise inyagɛ̃ kua iso.” ");
INSERT INTO akp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ne ma wũ matsɛ so ikarɛ sɔ, “Kumɛgɔ boito abolo ɔso fiɛ ɔto ɔɣere bo ngbɔ?” ");
INSERT INTO akp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Gɔ Yesu ɔtsue nnɛ mato maɣɛ ne, ɔkarɛ ma sɔ, “Be ɔso mito miɖe aka i abolo idaawe iso? Ikã kiniɔ ne, miito minya fiɛ mianɔ karɔ̃? Mi situ ba ɔle! ");
INSERT INTO akp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Miba anɔmi, ɣɛɛ miito minya! Miba atsue, ɣɛɛ miito minɔ! Miito minyigi, ");
INSERT INTO akp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ɔwi gɔ loɣɛ abolo aru lotã maturi kukpi kuru ɔɖe? Kusɛsɛi kurɛ̃ i aɖera kutia ɔyi?” Matã wũ mmuai sɔ, “Kɔ̃ kuweo-kunyɔ.” ");
INSERT INTO akp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesu ɔkarɛ ma ana sɔ, “Ne ɔwi gɔ loɣɛ abolo akɔdzɛ lotã maturi kukpi kuna ne, asɛsɛ arɛ̃ i akutia ɔyi?” Matã wũ mmuai sɔ, “Wã akɔdzɛ.” ");
INSERT INTO akp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ne ka ɔkarɛ ma sɔ, “Ikã kiniɔ ne, miitsue ɔturi gɔ loɖe?” ");
INSERT INTO akp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Gɔ mabo Betsaida ɔmagɛ̃ ame ne, mawɛ̃ ɔkɔ nɔbiɛdze mabɔ, ne mapɛ wũ nrɔɔ̃ sɔ ɔpɛgu wũ. ");
INSERT INTO akp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu ɔmɔɛ̃ wũ kɔrɔ̃ ɔbɔrɛgu i ɔmagɛ̃ ame. Gɔ ɔfɛ̃ sinyatu ɔfere ɔrɛrɛ̃ anɔmi ne, ɔsia wũ kɔrɔ̃ iso, ɔkarɛ wũ sɔ, “Ato anya ira iwɛ̃?” ");
INSERT INTO akp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Gɔ ɔtara anɔmi ne, ɔɣɛ sɔ, “Aĩ, nto lonya maturi mase kere lɛ adziri wa nsɛ.” ");
INSERT INTO akp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Gɔ Yesu ɔledza wũ anɔmi ipɛgu ne, ɔkɛ anɔmi teteree, ne abusi waĩ, ɔnya ara kukaakɔ ne! ");
INSERT INTO akp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Gɔ Yesu ɔtã wũ ɔri sɔ ɔkɛlɛ iyo ne, ɔɣere wũ sɔ, “Daakpese aki i ɔmagɛ̃ ame mmɔ!” ");
INSERT INTO akp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ne kama ne, Yesu gu ɔ̃ marasuãdze ɔkɛlɛ kusɛkɔ̃ gɔ i Kaisarea Filipi kɔrɛ. Gɔ masɛ i ɔri ne, Yesu ɔkarɛ ma sɔ, “Nna i maturi sɛ maɣɛ sɔ loɖe?” ");
INSERT INTO akp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Maɣere wũ sɔ, “Mawɛ̃ sɔ fɔ nɖe Ndupiedze Yohanes mawɛ̃ ana sɔ fɔ nɖe Eliya fiɛ mawɛ̃ ana sɔ Ɣaa kanyaɖidze ɔ aɖe.” ");
INSERT INTO akp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Mmɔ i Yesu to ɔkarɛ ma sɔ, “Ne mi ɣɛɛ? Nna mibu sɔ loɖe?” Petro ɔtara kanya sɔ, “Fɔ nɖe Kristo ne.” ");
INSERT INTO akp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu ɔsɛ̃ ɔtã ma sɔ madaaɣɛ ngɔ maɣe sɔ ɔɖe. ");
INSERT INTO akp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ne Yesu ɔtsɛ ara ite ɔ̃ marasuãdze sɔ, “Ikote sɔ mme, Ɔturi Awune Ɔbi, aawe inyɛ gbodzoo i ma Yudase makpakpa gu masɔrɛdze makpakpa gu mmara matedze nrɔɔ̃ ame, mato maaɖoe me. Ɣɛɛ ikpɛnɛ tɛare ne, Ɣaa to ɔ̃atara me lowe ngbã ana.” ");
INSERT INTO akp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ɔɣere ma nnɛgbe ɔɖi waĩ, fiɛ manɔ wũ karɔ̃ ana. Ne Petro ɔkɔ wũ ɔɣedza i kuruɛ ɔtã wũ itai sɔ kuiyikuiyi ɔdaasiɣɛ ngbɔ. ");
INSERT INTO akp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Gɔ Yesu ɔfiniki ɔnyɔ ɔ̃ marasuãdze ne, ɔsɛ̃ Petro teteree sɔ, “Re me kama, Satana!” Ne ɔto ɔɣɛ ana sɔ, “Ato abie sɔ akpesera so ɔri itɛ̃ra atã me adzuni wagbe iibɔrɛ i Ɣaa kɔrɛ, ɣɛɛ ɔturi kɔrɛ abɔrɛ.” ");
INSERT INTO akp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesu ɔkpere maturi gu ɔ̃ marasuãdze ɔbɔ ɔ̃ kɔrɛ fiɛ ɔte ma ara sɔ, “Si ɔrere ɔbie sɔ ɔ̃asiai me ne, ɔsɛ̃ so, si ɔsu ɔ̃ inyɛwe ɔnyigbã si ɔ̃awo me ɔsiai. ");
INSERT INTO akp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Alasɔ ngɔ loakpɛ̃ i ɔ̃ ngbã iti ne, ɔto ɔ̃ayura me ɣɛɛ ngɔ loayura ɔ̃ ngbã ala mme gu wũ Itɔ̃me Bielea ɔso ne, ɔto ɔ̃ana ngbã mɛ loisɛ miro. ");
INSERT INTO akp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mme kusia i ɔturi aana si kayiiso ɔɖuɖu karana ɔkpese ɔ̃ kare fiɛ ɔ̃ina ngbã mɛ loiɛ miro? ");
INSERT INTO akp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ɣee be i ɔturi aasu ɔnyuarã fiɛ ɔ̃ana ngbã mɔmɔ? ");
INSERT INTO akp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Si mme gu wũ ara ite aakpɛ̃ ɔrere kunuarɛ i ɔkparɛ lalaa gɔgbe ame ne, mme, Ɔturi Awune Ɔbi, mme wũ ɔnyiiɔ akpɛ̃ me kunuarɛ i ɔwi gɔ ame loaba gu Ɣaa makpabo sekelea ku Ɣaa ikpawaĩ ɔɖuɖu.” ");
INSERT INTO akp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ne Yesu ɔɣere ma ana sɔ, “Nto loɣere mi gbaã sɔ mi ndɛ̃ mawɛ̃ i ngbe iibakpi fiɛ Ɣaa sigara iɖe aaba ku ɔle.” ");
INSERT INTO akp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ayi akuɔ kama ne, Yesu ɔkɔ Petro gu Yakobo gu Yohanes masɛ kube kɔlɛa kuwɛ̃ iso ma ɔnɔwɛ̃. Gɔ marasuãdze to manyɔ kere ne, Yesu kumiamia ɔkpaki! ");
INSERT INTO akp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ɔ̃ awu ɔbara futututu atsɛ ifiɛ gelegelegele iɖo kumɛgɔ i ɔturi awune aawo ira ɔbara ifudza. ");
INSERT INTO akp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ne manya sɔ Mose gu Eliya ɔte so mato maɖegu Yesu ika ne. ");
INSERT INTO akp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ne Petro ɔɣere Yesu sɔ, “Ratedze, bo ngbe iba ɔbua ilɛ gbaã! Tã bopɛ akpayo atɛ. Iwɛ̃ itã-ɔ, iwɛ̃ itã Mose, fiɛ iwɛ̃ ana itã Eliya.” ");
INSERT INTO akp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ifɔ̃ ɔmɔɛ̃ Petro gu matsɔra gbaã sɔ ɔ̃isiɣe nwa ɔto ɔɣɛ. ");
INSERT INTO akp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Idɔdɔ ɔso ifu ma iso, ne silɔ ɔbɔrɛ i idɔdɔ ame sɔ, “Wũ Ɔbi gɔ loipia kuɣɛ i ngbe ne, mikã wũ atsue!” ");
INSERT INTO akp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ɔluwɛ̃ mabusi anɔmi, ɣɛɛ maisinya kuwɛ̃ iɖo Yesu ɔnɔwɛ̃ kere nɣɛ i ma kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Gɔ maso i kube iso mato maba ne, Yesu ɔsi ma mmara sɔ, “Midaaɣere kuwɛ̃ nwa minya ngbe gbɔgbɔɔgbɔ ɔwi ɔɣo sɔ mme, Ɔturi Awune Ɔbi, loata lobɔrɛ i makpise ame.” ");
INSERT INTO akp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mabara masia i atɔ̃me wagbe iso, ɣɛɛ si ma ɔnɔwɛ̃ si ne, masɛ makarɛ so sɔ, “Be i ita i makpise ame ɔbua iɖe?” ");
INSERT INTO akp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ne mato makarɛ Yesu sɔ, “Be ɔso fiɛ mmara matedze sɛ maɣɛ sɔ Eliya aaɖe katɔ̃ ɔba tɔtɔ?” ");
INSERT INTO akp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ne Yesu ɔɣere ma sɔ, “Gbaã iɖe sɔ Eliya aaɖe katɔ̃ ɔba ɔ̃aledza ira biara ɔsɛ. Fiɛ be ɔso matsɛrɛ i Ɔko Sekelea ana ame sɔ Ɔturi Awune Ɔbi aawe anyɛ fiɛ maasopara wũ? ");
INSERT INTO akp_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nto loɣere mi sɔ Eliya ɔɔba koko. Ɣɛɛ ne, maturi iinya wũ maɖi ite. Mabara wũ kumɛgɔ maɖɔɛ fiɛ matsɛrɛ masɛ i ɔ̃ iso.” ");
INSERT INTO akp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Gɔ makpese maba marasuãdze tsɔra kɔrɛ ne, manya sɔ maturi gbodzoo ɔki malɔ ma fiɛ ma gu mmara matedze to makpadzɛ̃ itɔ̃me. ");
INSERT INTO akp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Gɔ maturi ɔnya sɔ Yesu ka ɔba ne, ibara ma ɣii, ne matere masarɛgu wũ fiɛ matofora wũ ne. ");
INSERT INTO akp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu ɔkarɛ ɔ̃ marasuãdze sɔ, “Be kakpadzɛ̃ i mi gu ma to?” ");
INSERT INTO akp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ne ɔrɛrɛ̃ ɔwɛ̃ i ma ndɛ̃ ɔɣere Yesu sɔ, “Ratedze, lokɔ wũ ɔbi lobɔ-ɔ, alasɔ siwarã lalaa si wũ iso fiɛ sikpesera wũ ɔmumu. ");
INSERT INTO akp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ɔwi biara si sito sikpɛ̃gu wũ ne, sisɛ sitara wũ siwuĩ i karɔ̃, minyatu sɛ mibɔrɛ wũ i kanya kpɔɔ, fiɛ ɔsɛ ɔwewe kanya, ɔmɔɛ̃ ɔtɔ gogori. Ne ɔso lokɔ wũ lobɔ fɔ marasuãdze sɔ masa wũ, fiɛ maiwo ne.” ");
INSERT INTO akp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ne Yesu ɔɣere ma sɔ, “Mi kiniɔgbe maturi ma loifɔ maɖe fiɛ manyanyarĩ, ayi sirɛ̃ loawe i mi kɔrɛ isɛ iabo? Kɔ ɔbi bɔ me i ngbe!” ");
INSERT INTO akp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Makɔ wũ mabɔ Yesu kɔrɛ. Ɔluwɛ̃ gɔ siwarã lalaa dzɛgbe ɔnya Yesu ne, sikpɛ̃gu ɔbi sitara wũ siwuĩ i karɔ̃, ɔto ɔmɛrɛ̃ fiɛ minyatu kpɔɔ sɛ wũ i kanya. ");
INSERT INTO akp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ne Yesu ɔkarɛ ɔ̃ ɔse sɔ, “Gɔ isɛ wũ karɔ̃ ne, iɔfɔ ɔwi?” Ɔrɛrɛ̃ ɔɣere wũ sɔ, “Itsɛ ta ɔ̃ sibiɛtɛ ame. ");
INSERT INTO akp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ɔwi gbodzoo ne, siwarã dzɛgbe sɛ sibie sɔ siaɖoe wũ. Si iba ngbɔ ne, ɔsɛ ɔta sɔ si ɔbo i ɔtɔ ɣee ndu ame. Loto-ɔ i kukpa, nyɔ bo nnya si abuai bo, si iɖe ira ne aawo ɔbara!” ");
INSERT INTO akp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu ɔkarɛ wũ sɔ, “Be ɔso fiɛ ato aɣere me sɔ si loawo? Kuira na ngɔ lofɔ ɔɖe ɔle.” ");
INSERT INTO akp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ɔbi ɔse ɔsiagu kulu ɔɣɛ sɔ, “Mba kafɔkaɖe, ɔmɔ kere kaimɔ. Buai me si lona kafɔkaɖe lobua!” ");
INSERT INTO akp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Gɔ Yesu ɔnya sɔ maturi to malili so sɔ maabore mabo ma ne, ɔtɔ̃me ɔpia siwarã dzɛgbe sɔ, “Siwarã lalaa dzɛ lotɛ̃ra ɔbi atsue fiɛ atã sɔ ɔ̃ito ɔwo ika ɔɖe, nto loɣere-ɔ sɔ bɔrɛ i ɔ̃ ame, fiɛ daasikpese abo i ɔ̃ ame kuiyikuiyi ana!” ");
INSERT INTO akp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Siwarã ɔsia kulu titiiti, si tidza ɔbi i karɔ̃ fiɛ sibɔrɛ i ɔ̃ ame. Ɔbi rɛ i mmɔ lɛ ɔkpi ɔkpi. Ne mma nɣɛ i mmɔ to maɣɛ sɔ, “Ɔ̃ɔkpi!” ");
INSERT INTO akp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ɣɛɛ Yesu ɔmɔɛ̃ wũ kɔrɔ̃ ɔtara ɔɣedza. ");
INSERT INTO akp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kama gɔ Yesu gu ɔ̃ marasuãdze ɔbo iyo iwɛ̃ ame ne, makarɛ wũ pɔkɔsɔɔ sɔ, “Be ɔso fiɛ boiwo siwarã dzɛgbe ɔsa ɔɖi i ɔbi ame?” ");
INSERT INTO akp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ne Yesu ɔɣere ma sɔ, “Ngbɛsi ɔturi ɔsu kayi ikparama gu kanya inyi fiɛ ɔ̃awo siwarã dzɛgbe igbã ɔsa.” ");
INSERT INTO akp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu gu ɔ̃ marasuãdze ɔrui i mmɔ masɛ maaki i Galilea awo ame. Yesu iibie sɔ kuwɛ̃ si ɔtsue ngbegɔ ɔpia, ");
INSERT INTO akp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","alasɔ ɔto ɔte ma ara sɔ, “Mato maaɖi mme, Ɔturi Awune Ɔbi, matã maturi maɖoe, ikpɛnɛ tɛare ne, loata lowe ngbã.” ");
INSERT INTO akp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ɣɛɛ mainɔ nnɛ ɔɣere ma karɔ̃, fiɛ manigã sɔ maakarɛ wũ ana. ");
INSERT INTO akp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Gɔ masɛ maabo Kapernaum ɔmagɛ̃ ame ne, makɛlɛ iyo iwɛ̃, mmɔ i Yesu ɔkarɛ ɔ̃ marasuãdze sɔ, “Be itɔ̃me mito mikpadzɛ̃ gɔ bosɛ i ɔri boto boba?” ");
INSERT INTO akp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Maiwo wũ ɔɣere alasɔ gɔ masɛ i ɔri mato maba ne, mato makpadzɛ̃ so sɔ nna loɖo i ma ndɛ̃ pelepele. ");
INSERT INTO akp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ne Yesu ɔsɛ i karɔ̃ fiɛ ɔkpere ɔ̃ marasuãdze iweo-inyɔ ɔɣere ma sɔ, “Mi ndɛ̃ ɔrere gɔ lobie sɔ mawarɛ wũ ne, ɔbara so ɔtsɔra i mi ndɛ̃ si ɔsumu mamama.” ");
INSERT INTO akp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ɔkpere ɔbiɛtɛ ɔba ɔ̃aɣedza ma i katɔ̃. Ne ɔmɔɛ̃ wũ ɔsia so i ngba fiɛ ka ɔɣere ma sɔ, ");
INSERT INTO akp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ɔbiara gɔ loafɔ ɔbiɛtɛ gɔgbe i wũ iyere ame ne, mme iɖe ɔfɔ. Fiɛ ɔbiara gɔ lofɔ me ne, iiɖe mme kere ɔfɔ. Ɔfɔ Tete gɔ losese me ana.” ");
INSERT INTO akp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Rasuãdze gɔ marɔ sɔ Yohanes ɔɣere Yesu sɔ, “Ratedze, bonya ɔrɛrɛ̃ ɔwɛ̃ ɔto ɔsa siwarã lalaa ɔɖi i maturi ame i fɔ iyere ame. Ne boɣere wũ sɔ ɔnyua, alasɔ ɔ̃iɖe bo ndɛ̃ ɔwɛ̃.” ");
INSERT INTO akp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu ɔɣere ma sɔ, “Midaatɛ̃ wũ ɔri, alasɔ ngɔ loabara awawãra i wũ iyere ame ne, ɔ̃ibawo pɛ ɔfiniki mala ɔɣɛ wũ ilalaa. ");
INSERT INTO akp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ngɔ loita ɔɣɛ bo iso ne, mawɛ̃ boɖe. ");
INSERT INTO akp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","“Lotã mi itsue gbaã sɔ ɔbiara gɔ loatã mi ndu minɛ alasɔ miɖe wũ mare ɔso ne, ɔto ɔ̃afɔ ne kuso kokooko. ");
INSERT INTO akp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ngɔ loatã ɔbiɛtɛ gɔ mba kafɔkaɖe i wũ ame afiniki i kafɔkaɖe kama ne, si masu ɔwɛ̃ manyi kukɔtɛ siare masarã wũ i ɔme mafuĩdza wũ mapia i ɔpo ame ne, ialɛgu wũ iɖo. ");
INSERT INTO akp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","“Ne ɔso si fɔ kɔrɔ̃ kuwɛ̃ to kukpɔkpɔtɔra fɔ kafɔkaɖe ne, tu kɔ̃ ɖi. Ilɛ sɔ aawe kɔrɔ̃ kuwɛ̃ asɛ ngbã mɛ loibaro iɖo sɔ aba nrɔɔ̃ minyɔ ne, aakɛlɛ itɔkpe nɛ loisɛ inyi ame. ");
INSERT INTO akp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Si fɔ kukpa nto kukpɔkpɔtɔra fɔ kafɔkaɖe ne, tu kɔ̃ ɖi. Ilɛ iɖo sɔ aawe kukpa kuwɛ̃ ana ngbã iɖo sɔ aawe ngba minyɔ maapɛ-ɔ mapia i ɔtɔ ame. ");
INSERT INTO akp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Si fɔ inɔmi ana nsɛ itã abo i ikpi ame ne, were ne ɖi. Ilɛ sɔ aasu inɔmi iwɛ̃ abo i Ɣaa sigarakaɖekɔ̃ ame iɖo sɔ aba anɔmi anyɔ ne, mapɛ-ɔ mapia i ");
INSERT INTO akp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","itɔkpe ame lɛ kumɛgɔ maɣɛ sɔ, ‘Arɔrɛ̃ wa nsɛ anina ara i mmɔ ne, aibakpi! Fiɛ ɔtɔ gɔ nto ɔtsue mmɔ ne, ɔ̃ibanyi.’ ");
INSERT INTO akp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Alasɔ lɛ kumɛgɔ masɛ mapia mma i aɖera ame masekelera wã matã Ɣaa ne, ngbɔ ame i Ɣaa aatã sɔ ɔbiara aaki i inyɛwe ɔtɔ gɔmɔ ame ne. ");
INSERT INTO akp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Mma lɛ, ɣɛɛ si miyura me ɔmɛrɛ̃ ne, maibawo me ɔmɛrɛ̃ ɔpia. Ne ɔso mitã mma karabara sɛɛ si kawe i mi ame si misɛgu mi malaa i isobuɛ ame.” ");
INSERT INTO akp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu ka ɔrui i mmɔ ɔkɛlɛ Yudea karɔ̃ iso gu Yordan ɔwore kama. Maturi gbodzoo ɔba maasakanya i mmɔ ana, ne ɔte ma Itɔ̃me Bielea lɛ kumɛgɔ ame ɔsɛ ɔbara awe ne. ");
INSERT INTO akp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ma Farisise mawɛ̃ ɔba ɔ̃ kɔrɛ si mala wũ manyɔ. Makarɛ Yesu sɔ, “Ɣaa mmara ɔtã ɔri sɔ ɔrɛrɛ̃ aasɛ̃ ɔ̃ ɔre?” ");
INSERT INTO akp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ne Yesu ɔtã mmuai ɔkarɛ ma sɔ, “Nda i Mose mmara ɔte mi?” ");
INSERT INTO akp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Matã mmuai sɔ, “Mose ɔtã ɔri sɔ ɔrɛrɛ̃ gɔ nto ɔbie sɔ ɔ̃asɛ̃ ɔ̃ ɔre ne, ɔ̃atã wũ kusɛ̃so ɔko iyɔ ɔ̃ɔɖi wũ ɔri.” ");
INSERT INTO akp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu ɔɣere ma sɔ, “Mose ɔtsɛrɛ ngbɔ ala mi atsuele ɔso. ");
INSERT INTO akp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ta kayiiso karɔ̃kasɛkɔ̃ ne, ɔrã gu ɔre i Ɣaa ɔbara. ");
INSERT INTO akp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Nnɛgbe ɔso i ɔrɛrɛ̃ aarui i ɔ̃ ɔse gu ɔ̃ ɔnyi kɔrɛ ɔpɛ ɔmatã ɔ̃ ɔre iso, ");
INSERT INTO akp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","fiɛ ma inyɔɔ aakpese sosina siwɛ̃ ne.’ Ne ɔso maisiɖe maturi inyɔ, ɣɛɛ ɔwɛ̃! ");
INSERT INTO akp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ne ɔso kuwɛ̃ si ɔdaabɛse nnɛ i Ɣaa ɔsu ɔmatãra so iso.” ");
INSERT INTO akp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kama gɔ makɛlɛ iyo ne, ɔ̃ marasuãdze ɔkarɛ wũ itɔ̃me nɛmɔ iso ara. ");
INSERT INTO akp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu ɔɖi karɔ̃ sɔ, “Ɔrɛrɛ̃ biara gɔ losɛ̃ ɔ̃ ɔre fiɛ ɔyiri ɔmama ne, ɔfe ɔ̃ ɔre kama fiɛ ɔɣɛrɛ wũ. ");
INSERT INTO akp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ngbɔ ame i ɔrɔ̃go gɔ losɛ̃ ɔ̃ ɔrã fiɛ ɔsɛ ɔ̃ayiri kurã ɣɛtɛ ne, ɔfe ɔ̃ ɔrã kama fiɛ ɔɣɛrɛ wũ.” ");
INSERT INTO akp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ɔwi gɔmɔ ame ne, mawɛ̃ ɔkɔ mabiɛtɛ mabɔ Yesu sɔ ɔsia ma kɔrɔ̃ iso. Ɣɛɛ ne, ɔ̃ marasuãdze ɔnyagalagu ma. ");
INSERT INTO akp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Gɔ Yesu ɔnya ne, ɔnagu ma sikpã, ne ɔɣere ma sɔ, “Mitã mabiɛtɛ si maba wũ kɔrɛ ne midaatɛ̃ ma ɔri, alasɔ Ɣaa sigarakaɖekɔ̃ se sitã ma igbã. ");
INSERT INTO akp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Gbagbaã nto loɣere mi sɔ ɔbiara gɔ loifɔ Ɣaa sigara iɖe lɛ ɔbiɛtɛ awe ne, ɔ̃ibawo sɛ̃ ame ɔkɛlɛ ɖa.” ");
INSERT INTO akp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ɔsira mabiɛtɛ ma nɣɛ i mmɔ kanya ɔsia ma nrɔɔ̃ iso fiɛ ka ɔtã ma kusɛkusɛ. ");
INSERT INTO akp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Gɔ Yesu ɔta ɔɣo ɔri ne, ɔrɛrɛ̃ ɔwɛ̃ ɔtere ɔba ɔ̃apɛ agɛgɛ̃ i ɔ̃ katɔ̃ ɔkarɛ wũ sɔ, “Ratedze bielea, be loabara fiɛ loana ngbã mɛ nna katui?” ");
INSERT INTO akp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu ɔkarɛ wũ sɔ, “Be ɔso fiɛ ato akpere me Ɔbielea? Ɔturi kuwɛ̃ iiɖe ɔbielea iɖo Ɣaa ɔnɔwɛ̃. ");
INSERT INTO akp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Aɣe Ɣaa mmara. Daaɖoe ɔturi, daaɖe asɔrɔ̃, daayu kayu, daaɖaɛ fɔ ɔlaa kanya, daasɔsɔla fɔ ɔnyii afɔ ɔ̃ ara, warɛ fɔ ɔse gu fɔ ɔnyi.” ");
INSERT INTO akp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ɔrɛrɛ̃ gɔgbe ɔɣere wũ sɔ, “Ratedze, ita i wũ sibiɛtɛ ame ne, loɔɖe mmara mɛ ɔɖuɖu iso.” ");
INSERT INTO akp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu ɔnyɔ wũ ku kuɖɔɛ ne ɔɣere wũ sɔ, “Ikuti-ɔ ira ka iwɛ̃ aabara. Kɛlɛ aasu fɔ ira biara rɔdɛ̃ si asu sikã atsɛ mawɛrɛba, si aana kusia siare i kato. Si ɔɔro ne, kpese ba siai me!” ");
INSERT INTO akp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Gɔ ɔrɛrɛ̃ gɔgbe ɔnɔ nwagbe ne, ɔtu ɔbiɛ wũ, ne ɔruigu isoma alasɔ ɔba karana gbaã. ");
INSERT INTO akp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu ɔki ɔnyɔ ɔ̃ marasuãdze, ne ɔɣere ma sɔ, “Ito iabua iɖa fiɛ ranase aabo i Ɣaa sigarakaɖekɔ̃.” ");
INSERT INTO akp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Itɔ̃me nɛ ɔbara ɔ̃ marasuãdze ɣaa. Ɣɛɛ Yesu ɔɣere ma ana sɔ, “Wũ mabi, ito iabua iɖa fiɛ ranase aabo i Ɣaa sigarakaɖekɔ̃! ");
INSERT INTO akp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ma mmɔ ibo ba ɔle iɖo kumɛgɔ i kapuipɔngɔ aaki kafe i ɔdzirikaãra iyoi ame!” ");
INSERT INTO akp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Gɔ ɔɣere ma ngbɔ ne, ikpɔkpɔtɔra ma ibua! Ne mato makarɛ so sɔ, “Iyɔ nna loabua ɔna iɖi?” ");
INSERT INTO akp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ne Yesu ɔnyɔ ma totoroo fiɛ ɔɣere ma sɔ, “Ɔturi kuwɛ̃ iibawo ɔbara, ɣɛɛ Ɣaa aawo ibiara ɔbara.” ");
INSERT INTO akp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ne Petro ɔɣɛ sɔ, “Nyɔ, iyɔ bo ma lonyua bo ira biara bosɛ fiɛ bosiai-ɔ ɣɛɛ?” ");
INSERT INTO akp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ne Yesu ɔɣere ma sɔ, “Nto loɣere mi gbagbaã sɔ ɔbiara gɔ lonyua ɔ̃ iyo, ɣee manyiirɛrɛĩ gu manyiiko, ɣee ɔnyi, ɣee ɔse, ɣee ɔ̃ mabi, ɣee aputu ɔsɛ, fiɛ ɔsiai me sɔ si Itɔ̃me Bielea si isɛ katɔ̃ ne, ");
INSERT INTO akp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ɔ̃ wũ ɔ̃ana ara ikpɛ kulafa ɔsia i ngbã mɛ ngbe ame. Ɔ̃ana ayo gu manyiirɛrɛĩ gu manyiiko gu manyi gu mabi gu aputu gu kama iti. Fiɛ kama ne, ɔ̃ wũ ɔ̃ana ngbã mɛ nna katui i kayi ɣɛtɛ ga loaba ame. ");
INSERT INTO akp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ɣɛɛ ne, gbodzoo ma nɖe maɖeakatɔ̃ aakpese matsɔra, fiɛ matsɔra aakpese maɖeakatɔ̃.” ");
INSERT INTO akp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ɔwi gɔ masɛ i ɔri mato makɛlɛ Yerusalem ɔmagɛ̃ ame ne, Yesu ɖe katɔ̃ fiɛ ɔ̃ marasuãdze siai wũ. Ifɔ̃ ɔyu ɔtidza marasuãdze, fiɛ ifɔ̃ ɔmɔɛ̃ maturi ma nsiai ma ana. Yesu ɔkpere marasuãdze iweo-inyɔ ɔpia so fiɛ ɔɣere ma ara wa loabɔrɛ wũ iso. ");
INSERT INTO akp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ɔɣere ma sɔ, “Minɔ! Bosɛ Yerusalem, kakɔi ga mato maasu Ɔturi Awune Ɔbi mapia ma Yudase masɔrɛdze makpakpa gu mmara matedze nrɔɔ̃ ame. Mato maatã me kukpi ipɔ fiɛ maatara me matã mma loiɖe ma Yudase. ");
INSERT INTO akp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Mato maasopara me, matua minyatu mafere me, mapɛ me fiɛ maaɖoe me, ɣɛɛ iyi tɛare ne, nto loata ana.” ");
INSERT INTO akp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ne kama ne, Zebedeo mabi ma nɖe Yakobo gu Yohanes ɔba Yesu kɔrɛ, ne maɣere wũ sɔ, “Ratedze, ira ika iwɛ̃ pia aabara atã bo.” ");
INSERT INTO akp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu ɔkarɛ ma sɔ, “Be iɖe?” ");
INSERT INTO akp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Maɣere wũ sɔ, “Si akɛlɛ fɔ isekele sigaraiyara iso ne, tã sɔ bo ɔwɛ̃ aasɛ i fɔ kuɖearɔ̃ iso fiɛ ɔwɛ̃ ana aasɛ i fɔ kubena iso.” ");
INSERT INTO akp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu ɔɣere ma sɔ, “Miiɣe nnɛ mito mikarɛ! Miawo inyɛwe gu kukpi gɔ ame loaki ɔki? Fiɛ miawo Ɣaa itupie kubarara gɔ loafɔ i kayi ame ɔfɔ?” ");
INSERT INTO akp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ne matã wũ mmuai sɔ, “Boawo.” Yesu ɔɣere ma sɔ, “Aĩ, mito mianɛ ndu i ikɔi nɛ loanɛ ame, fiɛ miafɔ Ɣaa itupie kubarara gɔ loafɔ. ");
INSERT INTO akp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ɣɛɛ ne, lona ɔri sɔ loaɖi mma loasɛ i wũ kuɖearɔ̃ gu wũ kubena iso. Maturi ma i Ɣaa ɔledza mmɔ ɔsɛ mba mmɔ.” ");
INSERT INTO akp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Gɔ marasuãdze iweo tsɔra ɔnɔ itɔ̃me nɛ ne, mana sikpã i Yakobo gu Yohanes iso. ");
INSERT INTO akp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ne ɔso Yesu ɔkpere ma ɔɖuɖu ɔsirakanya ɔɣere ma sɔ, “Mi ɔɖuɖu ɣe sɔ kayiiso magara ma loiɖe ma Yudase sɛ mate so mapia mma mato maɖe iso fiɛ maba ɔle ɔɖuɖu i ma iso. ");
INSERT INTO akp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ɣɛɛ ne, idaawe i mi ame. Si mi ɔrere to ɔbie sikpakpa ne, ɔbara so sumudze ɔtã matsɔra. ");
INSERT INTO akp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Fiɛ si mi ɔrere to ɔbie iyere ne, ɔbara so ɔturi gɔ nna kayakpa i mi ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Alasɔ mme, Ɔturi Awune Ɔbi, kɔra iiba kayi gagbe ame sɔ masumu me. Ɣɛɛ ne, loba sɔ si loasumu maturi gu si loasu so losɔrɛ lotã maturi gbodzoo akpi iti sɔ si loafɔ ma.” ");
INSERT INTO akp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu gu ɔ̃ marasuãdze ɔba Yeriko ɔmagɛ̃ ame. Ne gɔ mato marui ne, maturi gbodzoo ɔsiai ma. Nɔbiɛdze ɔwɛ̃ gɔ marɔ sɔ Bartimeo gɔ nɖe Timeo ɔbi si ɔto ɔwanyi ara i ɔri kuruɛ. ");
INSERT INTO akp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Gɔ ɔnɔ sɔ Yesu Nasaretse nto ɔfe ne, ɔsiagu kulu sɔ, “Yesu! Igara David Ɔbi! Nyɔ me nnya!” ");
INSERT INTO akp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Maturi gbodzoo ɔsi wũ kanya iso sɔ ɔlo kulu. Ɣɛɛ ɔkɔlɛ ɔ̃ silɔ ɔbua ɔɣɛ sɔ, “Igara David Ɔbi! Nyɔ me nnya soo!” ");
INSERT INTO akp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Gɔ Yesu ɔnɔ ne, ɔtui ɔya ne ɔɣere ma sɔ, “Mikpere wũ mitã me.” Ne makpere nɔbiɛdze sɔ, “Na ɔtu! Ta mala, alasɔ ɔto ɔkpere-ɔ.” ");
INSERT INTO akp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ɔpɛyu ɔ̃ kato awu siare wa ɔpia, ɔkɔlɛ ɔɣo ne ɔba Yesu kɔrɛ ne. ");
INSERT INTO akp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu ɔkarɛ wũ sɔ, “Be ato abie sɔ lobara lotã-ɔ?” Nɔbiɛdze ɔɣere wũ sɔ, “Wũ Sate, tã wũ anɔmi si abusi si loledza ara inya.” ");
INSERT INTO akp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ne Yesu ɔɣere wũ sɔ, “Rui kɛlɛ. Fɔ kafɔkaɖe ɔsa-ɔ.” Ɔluwɛ̃ ɔ̃ anɔmi ɔbusi ɔtsɛ ara inya. Ne ka ɔsiai Yesu gu matsɔra makɛlɛ ɔri ne. ");
INSERT INTO akp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ɔwi gɔ ame mabore mabo Yerusalem fiɛ mabo Betfage gu Betania simagɛ̃ kɔrɛ gu kube gɔ marɔ sɔ Nnɔĩ Adziri Kube iso ne, Yesu ɔsese ɔ̃ marasuãdze inyɔ sɔ maɖe katɔ̃. ");
INSERT INTO akp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ɔɣere ma sɔ, “Si mibo ɔmagɛ̃ gɔ i mi katɔ̃ ame ne, mito mianya sɔ makɔra ɔfirimu ibi maɣedza i mmɔ gɔ kuwɛ̃ iisɛ ne iso ɔnya. Miɖi ne i ɔwɛ̃ ame mibɔ me. ");
INSERT INTO akp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Si ɔrere ɔkarɛ mi sɔ, ‘Be ɔso mito miɖi ne ne?’ ne miɣere wũ sɔ, ‘Sate nto ɔbie, ɔto ɔ̃akpesera wũ ɔbɔ i ɔwi kurukutu ame.’ ” ");
INSERT INTO akp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ne ɔso makɛlɛ masɛ maanya sɔ makɔra ɔfirimu ibi maɣedza i ɔrɛrɛ̃ ɔwɛ̃ kayogodɔ̃ i ɔri kuruɛ. Ne ɔwi gɔ maɖi wũ i ɔwɛ̃ ame ne, ");
INSERT INTO akp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","mma nɣɛ i mmɔ ɔkarɛ ma sɔ, “Be mito mikurisi wũ mibaragu?” ");
INSERT INTO akp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Maɣɛ lɛ kumɛgɔ i Yesu ɔɣere ma kere ne matã ɔri ne. ");
INSERT INTO akp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Gɔ makɔ bɔi gɔgbe mabɔ Yesu ne, maɖi ma sikati masia wũ i imatɛ̃, ne Yesu ɔta ɔsɛ wũ iso ne. ");
INSERT INTO akp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Maturi gbodzoo ana ɔwarɛ ma sikati masɛ i ɔri iso fiɛ mawɛ̃ ana ɔfɛfɛ̃ kudzirikpai mafere i ɔri iso sɔ Yesu ɔfirimu si ɔsɛ iso ɔfe. ");
INSERT INTO akp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mma nɖe katɔ̃ gu mma ngbikama to mafa kayiɖu sɔ, “Hosiana! Boto bole ngɔ nto ɔba i Bosate iyere ame! ");
INSERT INTO akp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mile bo ɔwa David sigarakaɖekɔ̃ dzɛ nto siba! Hosiana itã Ɣaa i kato dzoroo!” ");
INSERT INTO akp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Gɔ ɔbo Yerusalem ne, Yesu ɔkɛlɛ ma Yudase isɔrɛyo. Ɔnyɔ ara wa ɔɖuɖu mpia i mmɔ ɔkidza. Gɔ kaɖe ɔɔro ɔso ne, ɔrui ɔkɛlɛ Betania gu ɔ̃ marasuãdze iweo-inyɔ. ");
INSERT INTO akp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Gɔ kaɖe ɔsɛ̃ fiɛ maarui i Betania ɔmagɛ̃ ame ne, kukã ɔkpɛ̃ Yesu. ");
INSERT INTO akp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ɔnya ɔsese sɔ kuɖedziri kuwɛ̃ gɔ marɔ figi ɣɛgu aɣata wiawia. Ne ɔso ne, ɔsɛ sɔ ɔ̃anyɔ si ɔ̃anya abi. Gɔ ɔbore ɔbo kɔ̃ ne, ɔnya sɔ lɛ ibi na iso. Aɣata aɣata kere aɖe. Kɔ̃ ɔwi gɔ kuaɣɔ̃ ana iiɣo. ");
INSERT INTO akp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ne Yesu ɔɣere kudziri sɔ, “Kuwɛ̃ iisibasu fɔ ibi ɔpia i kanya ɔnya!” Ɔ̃ marasuãdze ɔnɔ sɔ ɔɣɛ ngbɔ. ");
INSERT INTO akp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Gɔ mabo Yerusalem ne, Yesu ɔkɛlɛ isɔrɛyo ame, ne ɔtsɛ mma nto maɖe kuɣa isa iɖi ne. Ɔli sikã manyuarãdze sipɔrɔ̃ ɔwiri gu maturi ma nto marɔdɛ̃ abɔrɔnuma ana ayara ɔpɛyu. ");
INSERT INTO akp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ɔ̃itã ma ɔri sɔ maasu kuira makigu isɔrɛyo sɔ maarɔdɛ̃. ");
INSERT INTO akp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ne ka ɔte ma ara sɔ, “Maitsɛrɛ masɛ i Ɔko Sekelea ame sɔ, ‘Maakpere wũ iyo sɔ iyo nɛ ame i kayi iso maturi ɔɖuɖu aakpere Ɣaa?’ Ɣɛɛ ne, miɔsu ne mikpesera mayukukpe kawɛrɛkɔ̃!” ");
INSERT INTO akp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ma Yudase masɔrɛdze makpakpa gu ma Yudase mmara matedze ma lowe i mmɔ ɔnɔ ara wa i Yesu ɔɣɛ. Ne ɔso ne, mabie ɔri gɔ iso maaki fiɛ mana wũ maɖoe. Ɣɛɛ mato manigã wũ alasɔ maturi ɔɖuɖu to maɖɔɛ ɔ̃ ara ite gbaã. ");
INSERT INTO akp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Gɔ kutsuɛ ɔɣo ne, Yesu gu ɔ̃ marasuãdze ɔbɔrɛ i ɔmagɛ̃ ame. ");
INSERT INTO akp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kaɖesɛ̃a kaya tutuutu gɔ masɛ mato maba ne, manya sɔ kuɖedziri gɔmɔ ɔɔkpi kuta i kɔ̃ siɖu ame. ");
INSERT INTO akp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petro ɔnyigi nnɛ loba ne ɔto ɔɣere Yesu sɔ, “Ratedze, nyɔ! Kudziri gɔ agbarĩ ɔɔkpi!” ");
INSERT INTO akp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu ɔɣere ma sɔ, “Mifɔ Ɣaa miɖe. ");
INSERT INTO akp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Gbaã nto loɣere mi sɔ ɔrere gɔ loaɣere kube gɔgbe sɔ kuta si kukɛlɛ ɔpo ame, fiɛ ɔ̃iwararã i ɔ̃ ɔtu ame fiɛ ɔba kafɔkaɖe ne, ito iaba itã wũ. ");
INSERT INTO akp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ne ɔso ne, nto loɣere mi sɔ ibiara nɛ miakarɛ Ɣaa i kayi ikparama ame ne, mifɔ miɖe sɔ mina ne, iyɔ iaba itã mi ngbɔ. ");
INSERT INTO akp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Si mito mitɔ̃me mitã Ɣaa, fiɛ minya sɔ ɔrere ɔɣɛrɛ-mi ne, misu mitsɛ wũ si mi Ɔse i kato ana aasu mi akpi ɔtsɛ mi. ");
INSERT INTO akp_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ɣɛɛ si miisu mitsɛ ne, mi ɔse gɔ mpia i kato iibasu mi akpi ɔtsɛ mi.” ");
INSERT INTO akp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Gɔ Yesu gu ɔ̃ marasuãdze ɔbo Yerusalem fiɛ ɔsɛ i isɔrɛyo ame ne, ma Yudase kasɔrɛkɔ̃ makpakpa gu mmara matedze gu mabea mawɛ̃ ɔba ɔ̃ kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ne makarɛ wũ sɔ, “Nna ɔle ame ato abara ara wagbe. Fiɛ nna tutuutu lobua ɔtã-ɔ ɔri?” ");
INSERT INTO akp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu ɔtã mmuai sɔ, “Tɔtɔ ne, loakarɛ mi itɔ̃me iwɛ̃ pɛ. Si mitã me mmuai ne, loaɣere mi ngɔ ɔle ame nto lobara nwagbe. ");
INSERT INTO akp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Miɣere me ngbegɔ i Yohanes ɔna ɔle ɔbɔrɛ gu fiɛ ɔpie maturi ndu i katu ame? Ɔle gɔmɔ ne, Ɣaa ame ɔse ɛɛbɛrɛ ɔturi lotã wũ? Mitã me mmuai!” ");
INSERT INTO akp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Matsɛ kakpadzɛ̃ i ma kerekere ndɛ̃ mato makarɛ so sɔ, “Be boaɣɛ? Si boɣɛ sɔ Ɣaa ɔle ɔɖe ne, ɔto ɔ̃akarɛ sɔ, ‘Si ngbɔ iɖe ne, be ɔso fiɛ miifɔ Yohanes miɖe?’ ");
INSERT INTO akp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Si boɣɛ sɔ ɔturi lotã wũ ana ne, ne iilɛ!” Alasɔ ɔbiara ɔfɔ ɔɖe sɔ Ɣaa kanyaɖidze ɔɖe. ");
INSERT INTO akp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ne ɔso ne, maɣere Yesu sɔ, “Boiɣe.” Ne Yesu ɔ̃ wũ ɔɣere ma sɔ, “Mme wũ loibaɣere mi ɔle gɔ nto lobara ala ara wagbe!” ");
INSERT INTO akp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ne Yesu ɔpɛ igbã sɔ, “Ɔwi ɔwɛ̃ ne, ɔrɛrɛ̃ ɔwɛ̃ ɔkpɛ̃ adziribi awɛ̃ kakpɛkɔ̃. Ɔtɛ̃ ɔkpã ɔki ɔlɔ. Ne ɔɖi itawo i kakpɛkɔ̃ ndɛ̃ kumɛgɔ ɔ̃afɔ adziribi ndu ɔfere maakã masirakanya. Ɔtsue kakɔi kɔlɛa ɔɣedza sɔ maaya iso madzuɛ̃ kakpɛkɔ̃. Ɔsu kakpɛkɔ̃ ɔtã marabaradze mawɛ̃ sɔ madzuɛ̃. Ne ɔrui ɔkɛlɛ ɔri ne. ");
INSERT INTO akp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Gɔ ɔwi ɔɣo sɔ maasɔrɛ̃ ɔraɖui ne, ɔrɛrɛ̃ gɔgbe ɔsese ma ɔ̃ ɔɖabo sɔ masu ɔ̃ ɔkpɛ matã mabɔ wũ. ");
INSERT INTO akp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ɣɛɛ marabaradze mamɔ ɔmɔɛ̃ wũ mapɛ, masa wũ, ne ɔruigu nrɔɔ̃ kunu ne. ");
INSERT INTO akp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kakpɛkɔ̃ sate ɔsese ɔɖabo mama. Gɔ ɔsɛ ne, marabaradze ɔpɛ wũ, maɖi wũ igbɛ i iti, masopara wũ gbaã. ");
INSERT INTO akp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ɔrɛrɛ̃ gɔ ɔsese ɔɖabo mama, ɔ̃ ne, maɖoe wũ. Ɔpia mamama ana, mapɛ mawɛ̃ fiɛ maɖoe matsɔra. ");
INSERT INTO akp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ɔturi gɔ kotoo loɔkuti sɔ ɔ̃apia katɔ̃me nɖe ɔ̃ ɔbi gɔ ɔ̃ipia kuɣɛ. Katsɔrakɔ̃ ne, ɔpia ɔ̃ ɔbi gɔgbe. Ne ɔɣere so sɔ, ‘Lofɔ loɖe sɔ mato maawarɛ wũ ɔbi.’ ");
INSERT INTO akp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ɣɛɛ ne, marabaradze mamɔ ɔɣere so sɔ, ‘Bo ɔkɔse ɔbi ngbe ne, ɔ̃ nɖe biarase ne. Mitã boɖoe wũ si kaɖekɔ̃ aaɣo bo!’ ");
INSERT INTO akp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ne ɔso mamɔɛ̃ ɔbi. Ne gɔ maɖoe wũ ne, masu wũ mafuĩdza masɛ i ɔkpã kama.” ");
INSERT INTO akp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ne Yesu ɔkarɛ mma i mmɔ sɔ, “Be mifɔ miɖe sɔ ɔrɛrɛ̃ gɔgbe aabara? Loɣere mi! Ɔto ɔ̃akɛlɛ ɔ̃aɖoe marabaradze ɔɖuɖu fiɛ ɔ̃asu kakpɛkɔ̃ ɔpia maturi mama i nrɔɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Miika i Ɔko Sekelea ame ngbegɔ maɣɛ sɔ, ‘Ita nɛ i mayotsuedze ɔsɛ̃ sɔ iilɛ ne, ikpese ita nyaa gu nnɛ lofɔ ma kuɣa iɖo atsɔra? ");
INSERT INTO akp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ɣaa lobara ira siare nɛ. Ibo bo anɔ, fiɛ ibara bo ɣaa ana.’ ” ");
INSERT INTO akp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Gɔ manɔ nwagbe ne, ma Yudase matɔ̃ɖedze ɔbie sɔ si maamɔɛ̃ Yesu. Alasɔ matsue sɔ ma iso ɔpɛ igbã. Ɣɛɛ ne, manigã maturi ma loya i mmɔ. Ne ɔso marui maɣɛ wũ. ");
INSERT INTO akp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ɔwi kama ne, masese ma Farisise gu Herodes masiaidze sɔ masɛ Yesu kɔrɛ mabie ɔ̃ kanya ame itɔ̃me fiɛ maana ɔ̃ kamɔɛ̃kɔ̃ ɔri. ");
INSERT INTO akp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Gɔ mabore mabo wũ ne, maɣere wũ sɔ, “Ratedze, boɣe sɔ asɛ aɖe ika sɛɛ ɔwi gbodzoo. Aisɛ afinikira fɔ itɔ̃me, fiɛ aisɛ anyɔ maturi i katɔ̃. Asɛ ate ɔbiara Ɣaa ɔri sɛɛ. Ne ɔso ne, ɣere bo si ɔri pia sɔ boatã Kaisaro lampo. ");
INSERT INTO akp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Botã wũ, ɛɛbɛrɛ bodaatã?” Yesu ɔtsue sɔ ɔnyɔnyɔ kere maba manyɔnyɔ wũ, ne ɔkarɛ ma sɔ, “Be fiɛ mito migbere me ibuɛ? Mitã me kapɛrɛ si lonyɔ.” ");
INSERT INTO akp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Masu mabɔ wũ. Ne ɔkarɛ ma sɔ, “Nna iti gu iyere nsia iso?” Matã mmuai sɔ, “Kaisaro ire iɖe.” ");
INSERT INTO akp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ne Yesu ɔɣere ma sɔ, “Ne ɔso ne, misu Kaisaro ira mitã wũ. Si misu Ɣaa ire ana mitã Ɣaa.” Kumɛgɔ ɔtã mmuai ɔso ne, mawa nnya mato, alasɔ ibara ma ɣaa. ");
INSERT INTO akp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ma Zadukise ma nsɛ mate sɔ si ɔturi ɔkpi ne, ɔ̃isibata mawɛ̃ ɔba Yesu kɔrɛ, ne makarɛ wũ sɔ, ");
INSERT INTO akp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ratedze, Mose ɔtsɛrɛ ɔsɛ bo sɔ si ɔrɛrɛ̃ ɔkpi ɔnyua ɔrɔ̃go maiɣe mabi ne, ɔ̃ ɔnyiibi aasu wũ ɔyiri sɔ si maɣe ɔbi ne, maabu wũ lɛ ɔrã ɖeakatɔ̃ ɔbi awe. ");
INSERT INTO akp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ɔwi ɔwɛ̃ ne, manyiibirɛrɛ̃ ikɔdzɛ ɔwe. Ɔɖeakatɔ̃ ɔyiri ɔrɔ̃go maiɣe ɔbi fiɛ ɔkpi. ");
INSERT INTO akp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ne ɔnyɔare ɔsu ɔrɔ̃go ne, maiɣe ɔbi kuwɛ̃ fiɛ ɔ̃ wũ ɔkpi. Ɔtɛare ɔsu ɔrɔ̃go ngbɔ ame ne, ɔ̃ wũ ɔkpi ɔnyua ɔrɔ̃go ɔbi idaaɣe ku wũ. ");
INSERT INTO akp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Manyi mabi ikɔdzɛ magbe ɔyiri ɔrɔ̃go gɔgbe makã ku ɔbi idaaɣe fiɛ ɔrɔ̃go ana ɔba ɔ̃akpi i katsɔrakɔ̃. ");
INSERT INTO akp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ɔwi gɔ i makpise ɔɖuɖu aata masɛ ngbã ne, ma nna loayiri ɔrɔ̃go gɔgbe gɔ ma ikɔdzɛ ɔɖuɖu ɔyiri wũ makã?” ");
INSERT INTO akp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu ɔɣere ma sɔ, “Mmɔ miɣɛrɛ ne. Lonya sɔ miinɔ itɔ̃me karɔ̃, alasɔ miiɣe Ɔko Sekelea ame itɔ̃me gu Ɣaa ɔle. ");
INSERT INTO akp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ɔwi gɔ i makpise aata ne, maase lɛ Ɣaa makpabo ma i kato, gɔ maibayiri so. ");
INSERT INTO akp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Fiɛ makpise ita itɔ̃me ne, Mose ɔtsɛrɛ ira ɔpia i Ɔko Sekelea ame ɔwi gɔ ɔnya kudzirimi to kutsue. Mmɔ ɔtsɛrɛ sɔ Ɣaa ɔɣere wũ sɔ, ‘Mme nɖe Abraham Ɣaa gu Isak Ɣaa gu Yakob Ɣaa.’ ");
INSERT INTO akp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ne ɔso gɔ Ɣaa to ɔnyɔ makpise lɛ manyɔdze ɔso ne, magbanadze Ɣaa ɔɖe, ɔ̃iɖe makpise Ɣaa. Mi ne, miyu ɔri gbaã!” ");
INSERT INTO akp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ne mmaratedze gɔ nɣɛ i mmɔ fiɛ ɔnɔ nwagbe ɔɖuɖu fiɛ ɔnɔ sɔ Yesu ɔtã mmuai kukaakɔ ɔbore ɔbo Yesu ɔkarɛ wũ sɔ, “Iɖe Ɣaa mmara mɛ nɖe misiare miɖo?” ");
INSERT INTO akp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Mmɔ i Yesu ɔɣere wũ sɔ, “Mmara mɛ loɖo me ɔɖuɖu nɖe sɔ, ‘Israel mabi, minɔ kukaakɔ! Bosate Ɣaa ne, ɔwɛ̃ saã ɔɖe fiɛ ɔ̃ ɔnɔwɛ̃ saã mpia. ");
INSERT INTO akp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ne ɔso ne, ikote sɔ aaɖɔɛ Bosate gɔ nɖe Ɣaa gu fɔ ɔtu gu fɔ siwarã gu fɔ kasusu gu fɔ ɔle ɔɖuɖu.’ ");
INSERT INTO akp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Fiɛ mmɛ nsiai mmɛgbe kama nɖe sɔ, ‘Ɖɔɛ fɔ ɔnyii lɛ kumɛgɔ ato aɖɔɛ so.’ Mmara kumiwɛ̃ siina miɖo mmɛgbe.” ");
INSERT INTO akp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mmaratedze gɔmɔ ɔtã mmuai sɔ, “Ratedze, aɖe ika gbaã! Titiriu kumɛgɔ aɣɛ sɔ Bosate pɛ nɖe Ɣaa, fiɛ ɔmama kuwɛ̃ siina iɖo wũ. ");
INSERT INTO akp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ne ɔso ne, ɔturi aaɖɔɛ Ɣaa gu ɔ̃ ɔtu ɔɖuɖu, gu ɔ̃ kasusu ɔɖuɖu gu ɔ̃ so ɔle ɔɖuɖu, sɔ ɔ̃aɖɔɛ ɔ̃ ɔnyii lɛ kumɛgɔ ɔto ɔɖɔɛ so. Fiɛ ilɛ iɖo sɔ ɔturi aasiai mmara mɛgbe ɔɖo sɔ ɔ̃asu mabɔi gu ara mama ɔfɛ̃ ɔtã Ɣaa.” ");
INSERT INTO akp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Gɔ Yesu ɔnya kumɛgɔ ɔtã mmuai gu inɔgba ne, ɔɣere wũ sɔ, “Fɔ ne, aidzorogu Ɣaa sigarakaɖekɔ̃.” Nnɛgbe kama ne, kuwɛ̃ iisibara kagbegbe sɔ ɔ̃akarɛ Yesu kuira kuira. ");
INSERT INTO akp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Gɔ Yesu to ɔte ara i Ɣaa iyo ame ne, ɔkarɛ sɔ, “Nda ɔso fiɛ mmara matedze sɛ maɣɛ sɔ Kristo ne, Igara David ɔbi ɔɖe? ");
INSERT INTO akp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Alasɔ Siwarã Bielea ɔki i David mɔmɔ iso ɔɣɛ sɔ, ‘Ɣaa ɔɣere wũ Sate sɔ, “Sɛ i wũ kuɖearɔ̃ iso gbɔgbɔɔgbɔ loabɔ fɔ matsirise karɔ̃ lopia i fɔ ngbatata kayirinɔ.” ’ ");
INSERT INTO akp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ngbe ne, si David mɔmɔ to ɔkpere wũ sɔ ɔ̃ Sate ne, nda iba sɔ Kristo aaɖe David ɔwa?” Maturi gbodzoo ɔya ku isoɣɔ manɔ ara wa i Yesu to ɔɣɛ ku ɔmɛrɛ̃. ");
INSERT INTO akp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Gɔ Yesu togu ara ite ne, ɔɣere ma sɔ, “Midzuɛ̃ so i mmara matedze iso. Masɛ mapia ara siare fiɛ masɛ mawe maki sɔ maturi si maya ma ku ibu i kuɣa ame. ");
INSERT INTO akp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Masɛ mabie sɔ maasɛ i kakɔlɛkɔ̃ i kusarɛkɔ̃ gu sipɔrɔ̃ katukɔ̃. ");
INSERT INTO akp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Masɛ maɖe makpise mare amumu mafɔ ma ara maɖe. Ɣɛɛ masɛ matɛ̃ra maturi atsue i kayi ikparama ame, alasɔ masɛ maɖe aka tagbaraa i iteso ame. Ma kutsue ikpadzɛ̃ ɔmɔ iɖo maturi tsɔra ɔɖuɖu.” ");
INSERT INTO akp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu ɔsɛ ɔ̃asɛ i karɔ̃ i kasɔrɛkɔ̃ ngbegɔ mato matã sikã, ɔsi ɔto ɔnyɔ kumɛgɔ i maturi to matã ara. Maranase ɔtã sikã siare. ");
INSERT INTO akp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ɣɛɛ kuɛdze wɛrɛba ɔwɛ̃ ɔba ɔ̃ɔpia kupɛrɛ kunyɔ. ");
INSERT INTO akp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ne Yesu ɔkpere ɔ̃ marasuãdze ɔsirakanya fiɛ ɔɣere ma sɔ, “Nto loɣere mi sɔ i Ɣaa anɔmi ame ne, kuɛdze wɛrɛba gɔgbe ɔtã ɔɖo maturi tsɔra. ");
INSERT INTO akp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Gbaã ne, mmagbe ara wa maɖe makuti masu maba maatã sɔ si mate so. Ɣɛɛ ɔrɔ̃go gɔgbe ne, bidɛ sɔ wɛrɛba ɔɖe ne, ɔ̃ iyo gu kayi ɔsu ɔtã. Ira nɛ ɔ̃asu ɔɣa aɖera ɔɖe ɔsu ɔba ɔ̃atã ngbe ne.” ");
INSERT INTO akp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Gɔ Yesu ɔbɔrɛ i ma Yudase isɔrɛyo mmɔ ne, ɔ̃ marasuãdze ɔwɛ̃ ɔɣere wũ sɔ, “Ratedze, nyɔ ata gu kulɛ wa masu matsue iyo siare nɛ gu kumɛgɔ matsue ne ana makigu. Ito ilɛ ɔnyɔ lo!” ");
INSERT INTO akp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu ɔɣere wũ sɔ, “Nyɔ iyo siare nɛgbe kukaakɔ, alasɔ ita kuiwɛ̃ iibakuti isia i ne ɔlaa iso, nɛ maibali mapɛyu!” ");
INSERT INTO akp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu ɔkɛlɛ ɔsɛ ɔ̃asɛ i Nnɔĩ Adziri Kube iso ɔto ɔnyɔ isɔrɛyo isɛ. Petro gu Yakobo gu Yohanes gu Andrea mɛrɛ̃ ɔba maakarɛ wũ pɔkɔsɔɔ sɔ, ");
INSERT INTO akp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Bosate, iɖe ɔwi gɔ i ara wagbe aaba? Ɣere bo ara wa loaba fiɛ boatsue sɔ ɔwi ɔɔkote sɔ ara wagbe aaba.” ");
INSERT INTO akp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ne Yesu ɔɣere ma sɔ, “Midzuɛ̃ so sɔ miibatã kuwɛ̃ aasɔsɔla mi. ");
INSERT INTO akp_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Maturi gbodzoo to maaba i wũ iyere ame, maɣere mi sɔ, ‘Mme nɖe Kristo!’ Fiɛ maasu wũ iyere masɔsɔla maturi gbodzoo. ");
INSERT INTO akp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Sitsue si sidaabɔrɛ mi si minɔ sɔ kakpã to i mi kɔrɛ ɣee kadzorokɔ̃. Ito iaba sɔ ara wagbe igbã aaba, ɣɛɛ iite sɔ kayi karokɔ̃ ɔɔwo. ");
INSERT INTO akp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Abuiti aakpɛ̃ gu abuiti. Fiɛ sigarakaɖekɔ̃ to siata siya sigarakaɖekɔ̃ iso. Karɔ̃ to kaati i ngɔi, fiɛ kukã to kuabo. Nwagbe ɔɖuɖu nɖe lɛ kumɛgɔ i kuɣe sɛ kusɛ karɔ̃ ku iɖoɖo ne. ");
INSERT INTO akp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Mi ne, midzuɛ̃ so kukaakɔ. Mato maamɔɛ̃ mi masɛgu atɔ̃mekaɣɛkɔ̃. Mato maapɛ mi i ma Yudase kasarɛkɔ̃ ala wũ ɔso, mito miaya i matɔ̃ɖedze gu magara anɔ miɣere ma wũ iso itɔ̃me, si iɖe ikparĩ itã ma. ");
INSERT INTO akp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Si kawirikɔ̃ aaba ne, ito iaba sɔ maɣere nɖebi ɔɖuɖu Ɣaa Itɔ̃me Bielea. ");
INSERT INTO akp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Si maamɔɛ̃ mi fiɛ makɛlɛgu mi atɔ̃mekaɣɛkɔ̃ ne, midaamararã so sɔ be miaɣɛ. Si ɔwi ɔɣo ne, miɣɛ nnɛ i Siwarã Bielea aatã mi. Alasɔ iiɖe mi mɔmɔ ati ame atɔ̃me miaɣɛ, ɣɛɛ ne, Ɣaa Siwarã loatã sɔ miaɣɛ ɔ̃ adzuni. ");
INSERT INTO akp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Maturi to maaɖi ma manyii matã sɔ maɖoe. Fiɛ mase to maaɖi ma mabi matã. Mabi to maata maya maɣese iso maɖi ma matã sɔ maɖoe. ");
INSERT INTO akp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ɔbiara to ɔ̃atsiri mi, ala wũ ɔso. Ɣɛɛ ne, ɔbiara gɔ loaya teteree ɔbo kawirikɔ̃ to ɔ̃ana iɖi. ");
INSERT INTO akp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Kiniɔ ne, mikã atsue kukaakɔ si minɔ karɔ̃. Si minya imusuora nɛ nsɛ iwɔra maturi fiɛ Ɣaa ɔtsiri sɔ iba iaya i ngbegɔ loikote ne, mma mpia i Yudea si matere teteree makɛlɛ abe iso maawɛrɛ. ");
INSERT INTO akp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ngɔ loya ɔsia i isã si ɔdaanina ɔwi sɔ ɔso ɔba iyo sɔ ɔ̃asu kuira i iyo kame. ");
INSERT INTO akp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ngɔ mpia i sia si ɔdaaɣɛ sɔ ɔsɛ kaa sɔ ɔ̃asu awu. ");
INSERT INTO akp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ɔwi gɔmɔ to ɔ̃awe ɔle gbaã ɔtã mayirise gu matalɛpo ɣɛtɛ. ");
INSERT INTO akp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mitã Ɣaa iti sɔ ɔwi gɔmɔ si ɔdaaba ku kulele ɔwi. ");
INSERT INTO akp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Alasɔ ibo gu ibɛbɛrɛ nɛ loaba ne, ito iaɖo ibiara nɛ i kayi gagbe ɔnya kanya ita i kayi karɔ̃kasɛkɔ̃ iba iabo nɔme. Fiɛ inyɛwe nɛgbe igbã iisibaba kuiyikuiyi. ");
INSERT INTO akp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ɣɛɛ ne, si Bo Ɔse Ɣaa iitu ayi wagbe ne, ɔturi kuwɛ̃ iibakuti. Ɣɛɛ mma ɔ̃ɔɖi ɔtã so ɔso ne, ɔ̃abɛrɛkɛ ayi wagbe. ");
INSERT INTO akp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ɔwi gɔmɔ ame si ɔrere ɔɣere-ɔ sɔ, ‘Nyɔ! Nya Kristo ngbe!’ ɣee, ‘Nya wũ mmɔ ne!’ daafɔ wũ aɖe! ");
INSERT INTO akp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Alasɔ mila ma Kristo gu mila kanyamaɖidze gbodzoo to maabara akparĩ gu awawãra gbodzoo, sɔ si maawo kɔra ne, maasɔsɔla kuta Ɣaa maturi ma ɔɖi ɔsɛ kokooko. ");
INSERT INTO akp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ne ɔso midzuɛ̃ so! Loɔɣere mi losɛ fiɛ ɔwi aaɣo. ");
INSERT INTO akp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ayi wa ka loasiai inyɛwe ɔwi ne, ‘kuɣɛ̃ to kuanyi, fiɛ ɔgbaworeti ana iibare. ");
INSERT INTO akp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Awãmi to aakpase abɔrɛ i kato, fiɛ kato sile ɔɖuɖu to siati kpukpukpu sibɔrɛ i sɛ̃ kawekɔ̃.’ ");
INSERT INTO akp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ne maturi aanya Ɔturi awune Ɔbi gɔ ɔto ɔso i adɔdɔ ame ɔba i ɔle siare gu ifiɛ ame. ");
INSERT INTO akp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Fiɛ ɔ̃asese ɔ̃ kato makpabo kayi abesɛ ana ɔɖuɖu sɔ ɔ̃ maturi ma ɔɖi ɔsɛ ita i kayi iti nɛ, ikɛlɛ iti nɛmɔ ne, masira ma kanya. ");
INSERT INTO akp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Misuã ara i kuɖedziri iso. Si minya sɔ kudziri gɔmɔ to kuɖi ayata ɣɛtɛ ne, mitsue sɔ kado ɔpɛwi ka ɔba. ");
INSERT INTO akp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ne ɔso si miɔtsɛ ara wa loɣere mi ngbe inya ne, mitsue sɔ, wũ iba ɔɔbore ibo iɣɛ i fɔ kayogodɔ̃! ");
INSERT INTO akp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nto loɣere mi sɔ ara wagbe aaba fiɛ mi kiniɔgbe maturi aakpi maro. ");
INSERT INTO akp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kato gu karɔ̃ ɔɖuɖu to kaafe, ɣɛɛ ne, wũ itɔ̃me iibafe kuiyikuiyi. ");
INSERT INTO akp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Fiɛ ɣɛɛ ne, kuwɛ̃ iiɣe iyi ɣee ɔɖɔwũ gɔ ame iaba, nane Ɣaa makpabo gu mme Ɣaa Ɔbi kɔra iiɣe, isu iɖo wũ Ɔse ɔnɔwɛ̃. ");
INSERT INTO akp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Midzuɛ̃ so si mila so, alasɔ miiɣe iyi nɛ i ɔwi gɔmɔ aaba. ");
INSERT INTO akp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Wũ iba to iase lɛ ɔrɛrɛ̃ gɔ lota sɔ ɔsɛ ɔri, fiɛ ɔrui ɔnyua ɔ̃ marabaradze ɔpia iyo. Ɔtã ɔbiara ɔ̃ karabara sɔ ɔbara. Ne kama ne, ɔɣere iyodzuɛ̃se sɔ ɔnyɔ ɔ̃ iba ɔri kukaakɔ. ");
INSERT INTO akp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Ne ɔso mi wũ midzuɛ̃ so. Alasɔ miiɣe ɔwi gɔ tutuutu i Bosate aaba ɔ̃abo. Ito iawo ɔba ku kutsuɛ ɣee kasɛ̃ ndɛ̃ ɣee ɔɖesɛrã siare, marodza silɔ ɔɖi ɔwi, ɣee kaya tutuutu. ");
INSERT INTO akp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Si ɔba ɔ̃ɔbɔrɛ mi iso ngbɔ ne, idaaba sɔ ɔ̃aba ɔ̃anya mi sɔ mito mirɛ sirɛ. ");
INSERT INTO akp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ira nɛ loɣere mi ngbe ne, ne ame nto loɣere matsɔra ne. Ne ɔso minyɔ ɔ̃ iba ɔri.” ");
INSERT INTO akp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ikuti ayi anyɔ fiɛ ma Yudase aaɖe ma iyi sekelea nɛ masɛ masu manyigi ma sisande ame ibɔrɛ i Egipte, iyi nɛ mato marɔ sɔ Kukpi Ɔtakuwara Bo gu Abolo Ɣɛtɛ Wa Loita Iɖe Iyi. Kasɔrɛkɔ̃ matɔ̃ɖedze gu mmara matedze mawɛ̃ ɔnyɔnyɔ ɔri gɔ maaki fiɛ maamɔɛ̃ Yesu maɖoe. ");
INSERT INTO akp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Maɣere so sɔ, “Iito ialɛ sɔ boabara ngbɔ ku iyi iɖe ayi wagbe ame. Alasɔ si iiɖe ngbɔ ne, kulu to kuapɛ.” ");
INSERT INTO akp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu ɔwe i Betania ɔmagɛ̃ ame i Simon gɔ lonyɛ ɔnyɛ rɛtɛa iyo. Gɔ Yesu si i aɖera kaɖekɔ̃ ne, ɔrɔ̃go ɔwɛ̃ ɔba mmɔ ku ita inɔĩbui sɔlɔsɔlɔa nɛ ame i nnɔĩ kɔrɔ̃kɔrɔ̃a ɔyi pɔpɔɔpɔ fiɛ mifɔ kuya gbaã. Ɔrɔ̃go gɔgbe ɔfɛ̃ inɔĩbui kanya, ne ɔfedza me ɔfere Yesu iti ne. ");
INSERT INTO akp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nnɛgbe ɔɖaa mma nɣɛ mmɔ mawɛ̃ fiɛ ibo ma so sɔ, “Be ɔso fiɛ ɔnina nnɔĩ mɛgbe? ");
INSERT INTO akp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tee ɔsu ɔrɔdɛ̃ ɔfɔ ɔturi ikɔ buu kuwakuso gɔ ɔ̃asu ɔtã mawɛrɛba.” Ne ɔso ne, manyagalagu wũ, managu wũ sikpã. ");
INSERT INTO akp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ɣɛɛ Yesu ɔɣere ma sɔ, “Minyua wũ! Be ɔso fiɛ miibatã wũ ɔwarã? Ɔbara me ira sɛɛ. ");
INSERT INTO akp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mawɛrɛba pia i mi kɔrɛ ɔwi biara. Fiɛ ɔwi biara miɖɔɛ ne, miawo ma ɔbuai. Mme ɣɛɛ ne, iiɖe ɔwi biara nto loawe i mi kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ɔrɔ̃go gɔgbe ne, ɔbara nnɛ ɔ̃awo ɔbara. Ɔsu nnɔĩ mɛ ɔfere me iso ɔledza me ɔtã wũ ibiara. ");
INSERT INTO akp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Fiɛ nto losia ita sɔ kakɔi biara ga maaɣɛ Ɣaa Itɔ̃me i kayi gagbe ame ne, maaɣɛ nnɛ i ɔrɔ̃go gɔgbe ɔbara.” ");
INSERT INTO akp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yuda Iskariot gɔ nɖe Yesu katɔ̃memasɛdze iweo-inyɔ ɔwɛ̃ ɔsɛ kasɔrɛkɔ̃ makpakpa kɔrɛ sɔ ɔ̃aɖi Yesu ɔtã ma sɔ maɖoe. ");
INSERT INTO akp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mana isoɣɔ gbaã, ne ɔso maɣɛ sɔ maatã wũ sikã. Ne ɔso ɔtsɛ ɔri gɔ iso ɔ̃aki fiɛ ɔ̃aɖi wũ ɔtã ma mamɔɛ̃ inyɔnyɔ. ");
INSERT INTO akp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","I Abolo Ɣɛtɛ Wa Loita Iɖe Iyi ikpɛnɛ ɖeakatɔ̃ nɛ iso masɛ maɖoe Kukpi Ɔtakuwara Bo sɛrɛ lɛ kumɛgɔ i ma Yudase kubarara se ne, Yesu marasuãdze ɔkarɛ wũ sɔ, “Lɛ abie sɔ boledza bosɛ botã bo iyi aɖera kaɖekɔ̃?” ");
INSERT INTO akp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ne Yesu ɔɖi ma inyɔ mawɛ̃ ɔɣere ma sɔ, “Mikɛlɛ ɔmagɛ̃ ame, mito mianya ɔwɛ̃ sore ndu kabui. Misiai wũ si minyɔ iyo nɛ ame ɔ̃abo. ");
INSERT INTO akp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Miɣere iyosate sɔ, ‘Ratedze sɔ te bo iyo nɛ ame i ɔ̃ gu ɔ̃ marasuãdze aaba maatu Kukpi Ɔtakuwara Bo Iyi ɔpɔrɔ̃.’ ");
INSERT INTO akp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ɔto ɔ̃ate mi iyo siare iwɛ̃ nɛ matsue masia ame ngbegɔ maledza masɛ. Miwa ikpɛnɛ bielea nɛgbe aɖera misɛ i mmɔ.” ");
INSERT INTO akp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Marasuãdze magbe ɔkɛlɛ ɔmagɛ̃ ame, ne manya sɔ ibiara nɛ i Yesu ɔɣɛ ɔba ngbɔ. Ne mawa Kukpi Ɔtakuwara Bo Iyi aɖera masɛ ne. ");
INSERT INTO akp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Gɔ kutsuɛ ɔɣo ne, Yesu gu ɔ̃ marasuãdze iweo-inyɔ ɔsɛ maabo mmɔ. ");
INSERT INTO akp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ne gɔ masɛ i ɔpɔrɔ̃ katɔ̃ mato maɖe ara ne, Yesu ɔɣɛ sɔ, “Nto loɣere mi sɔ ɔwɛ̃ i mi ndɛ̃ gɔ bo gu wũ nsi ngbe boto boɖe ara to ɔ̃aɖi me ɔtã.” ");
INSERT INTO akp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Itɔ̃me nɛgbe ɔɖaa ma, ne matsɛ wũ ikarɛ isia isia sɔ, “Loɣe sɔ iiɖe mme ato, ɛɛbɛrɛ mme loɖe?” ");
INSERT INTO akp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu ɔtã mmuai sɔ, “Mi iweo-inyɔ ndɛ̃ ɔwɛ̃ gɔ i bo gu wũ inyɔ to bopia kɔrɔ̃ i irɔi iwɛ̃ ame ngbe ɔɖe. ");
INSERT INTO akp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mme, Ɔturi Awune Ɔbi, to ɔsɛ ɔ̃akpi lɛ kumɛgɔ ame i Ɔko Sekelea ɔte. Ɣɛɛ iito iase ngɔ loaɖi wũ ɔtã pɔkɔsɔɔ. Si maiɣe wũ kɔra ne, ialɛgu wũ iɖo!” ");
INSERT INTO akp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Gɔ mato maɖe ara ne, Yesu ɔsu abolo. Ne gɔ ɔpɛ Ɣaa siba i wã iti ne, ɔkpɛkpɛti ɔtã ɔ̃ marasuãdze. Ne ɔɣere ma sɔ, “Mifɔ si miɖe. Wũ siturina i ngbe ne.” ");
INSERT INTO akp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ne ɔsu ndã ikɔi ne, gɔ ɔpɛ Ɣaa siba i ne iti ne, ɔsu ɔtã ma, ne manɛ ne. ");
INSERT INTO akp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ne ɔɣere ma sɔ, “Wũ ima nɛ loasu lofere i karɔ̃ i maturi gbodzoo iti fiɛ iɖe ndamu ɣɛtɛ i maturi awune gu Ɣaa ndɛ̃ i ngbe ne. ");
INSERT INTO akp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Gbaã ne, loisibanɛ ndã kumiwɛ̃, gbɔgbɔɔgbɔ loanɛ miɣɛtɛ i Ɣaa sigarakaɖekɔ̃.” ");
INSERT INTO akp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Gɔ maɖe ara maro ne, maka kuka male Ɣaa fiɛ makɛlɛ Nnɔĩ Adziri Kube iso. ");
INSERT INTO akp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Mmɔ i Yesu ɔɣere marasuãdze sɔ, “Mi ɔɖuɖu to miatere miɣɛ me. Alasɔ Ɣaa ɔɣɛ i Ɔko Sekelea ame sɔ, ‘Loaɖoe masɛrɛkɔdze, fiɛ ɔ̃ masɛrɛ aasame.’ ");
INSERT INTO akp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ɔwi gɔ loata lobɔrɛ i makpise ndɛ̃ ne, loaɖe mi katɔ̃ lokɛlɛ Galilea karɔ̃ iso.” ");
INSERT INTO akp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ne Petro ɔɣere wũ sɔ, “Mme loibatere loɣɛ-ɔ, si ɔbiara ɔnyua-ɔ ɔsɛ.” ");
INSERT INTO akp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu ɔɣere Petro sɔ, “Nto loɣere-ɔ gbagbaã sɔ, kasɛ̃ gagbe si rodza aaɖi kanya ɔkpɛ nyɔa ne, ato aasɛ̃ me ikpɛ itɛ sɔ aiɣe me.” ");
INSERT INTO akp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Petro ɔledza ita isia ɔɖo iɖeakatɔ̃ sɔ, “Si loakpigu-ɔ kɔra ne, loibaɣɛ sɔ loiɣe-ɔ.” Ne ɔ̃ marasuãdze ɔɖuɖu ana ɔɣɛ ngbɔ ne. ");
INSERT INTO akp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Gɔ masɛ maabo ngbegɔ marɔ Getsemane ne, Yesu ɔɣere ɔ̃ marasuãdze sɔ, “Misɛ i ngbe si nsɛ loakparama kayi.” ");
INSERT INTO akp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ne ɔkɔ Petro gu Yakobo gu Yohanes ɔruigu, ɔtsɛ so imararã iti ikpakpa ne. ");
INSERT INTO akp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ɔɣere ma sɔ, “Nto lona ibo ta wũ ame gbaã, lɛ kukpi lomɔɛ̃ me kuto. Miya i ngbe si midzuɛ̃gu me.” ");
INSERT INTO akp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Gɔ ɔkɛlɛ katɔ̃ kɛkɛĩ ne, ɔkɔlɛ ɔfu i karɔ̃ ɔpɛ ɔ̃ ɔse nrɔɔ̃ sɔ, “Si ialɛ ne, tã inyɛwe ɔwi gɔgbe si ɔta ɔwara me.” ");
INSERT INTO akp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ne ɔɣɛ sɔ, “Tete! Aawo ibiara ɔbara. Si atɔrã ne, aawo inyɛwe ikɔi nɛgbe sɛnɛkɛ̃ra ɔrera me kama, ɣɛɛ daabara wũ kuɖɔɛ, bara fɔ kuɖɔɛ.” ");
INSERT INTO akp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Gɔ ɔkpese ɔba marasuãdze itɛ kɔrɛ ne, ɔnya sɔ mato marɛ sirɛ. Ne ɔɣere Simon Petro sɔ, “Simon, sirɛ ato arɛ? Aibawo ɔsɛ ɔdzuɛ̃ iɣo ɔɖɔwũ ɔwɛ̃ pɛ kere?” ");
INSERT INTO akp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ne ka ɔɣere ma sɔ, “Misɛ midzuɛ̃, si mikparama kayi si miibabo i ilainyɔ ame. Siwarã to sibie, ɣɛɛ siturina ɔɔfɛ̃.” ");
INSERT INTO akp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ne ɔrui ɔkɛlɛ ɔsɛ ɔ̃akparama kayi ɔɣɛ atɔ̃me wamɔ ame ana ne. ");
INSERT INTO akp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Gɔ ɔkpese ɔba ne, ɔ̃ marasuãdze to marɛ sirɛ ana. Makpi sirɛ, ne ɔso maiɣe kumɛgɔ maaɖi so kanya. ");
INSERT INTO akp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Gɔ ɔkpese ɔba ɔkpɛ tɛare ne, ɔkarɛ ma sɔ, “Mitogu sirɛ? Mitogu iwarã? Ka ilɛ! Ɔwi ɔɔɣo! Maɔɖi mme, Ɔturi Awune Ɔbi, matã maturi lalaa! Minyɔ ka masɛ i ɔri. ");
INSERT INTO akp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mita si borui. Minyɔ, ngɔ loɖi me ɔtã nɖegu ma katɔ̃.” ");
INSERT INTO akp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Gɔ Yesu togu ma ika iɖe ne, Yuda gɔ nɖe marasuãdze iweo-inyɔ ɔwɛ̃ ɔba ɔ̃abo. Maturi ikuri nɛ i ma Yudase kasɔrɛkɔ̃ makpakpa gu mmara matedze gu ɔmagɛ̃ makpakpa ɔpia siai wũ maba. Mato apɛ gu kudziriku. ");
INSERT INTO akp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ngɔ loɖi wũ ɔtã ɔɣere ma sɔ, “Ngɔ minya sɔ loya fiɛ lofiɔ̃ irɛkpo ne, ɔ̃ ɔɖe ne, mimɔɛ̃ wũ teteree mikɛlɛgu!” ");
INSERT INTO akp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ne ɔso gɔ Yuda ɔbore ɔbo Yesu ne, ɔkpere wũ sɔ, “Ratedze!” Ɔmini wũ ɔpia wũ kɔrɔ̃. ");
INSERT INTO akp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mamɔɛ̃ Yesu mapɔrɛ wũ teteree. ");
INSERT INTO akp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mma nɣɛgu Yesu mmɔ ɔwɛ̃ ɔɖi itekpe, ɔtu kasɔrɛkɔ̃ ɔkpakpa pelepele ɔɖabo kutsue. ");
INSERT INTO akp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ne Yesu ɔkarɛ ma sɔ, “Be ɔso fiɛ miala akpo gu apɛ sɔ miba miamɔɛ̃ me lɛ yukukpe? ");
INSERT INTO akp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ikpɛnɛ biara bo gu mi mpia i Ɣaa isɔrɛyo, fiɛ lowe i mmɔ lote Itɔ̃me Bielea, miimɔɛ̃ me. Ɣɛɛ ne, iba ngbɔ sɔ nnɛ maɣɛ masɛ i Ɔko Sekelea ame aayi.” ");
INSERT INTO akp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ɔ̃ marasuãdze ɔɖuɖu ɔtere maɣɛ wũ. ");
INSERT INTO akp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ɔwi gɔgbe ne, ɔporoporoi ɔwɛ̃ gɔ nfu so ɔkati fudza siai Yesu i kama fiɛ ɔnya nwagbe ɔɖuɖu. Makpakpɛ̃dze ɔbie sɔ si mamɔɛ̃ wũ, ɣɛɛ ɔkpɛ̃ ɔbɔrɛ ma iso. Ɔ̃ ɔkati kere mana. ");
INSERT INTO akp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ɔbɔrɛ ma i nrɔɔ̃ ame ɔrui ɔtere isɔ̃isɔ̃. ");
INSERT INTO akp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Makɔ Yesu makɛlɛgu ma Yudase sɔrɛdzekpakpa pelepele iyo. Mmɔ i Ɣaa iyo masɔrɛdze gu ɔmagɛ̃ makpakpa gu mmara matedze ɔsarɛ ne. ");
INSERT INTO akp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petro ɔsiai ma kama dzoroo ɔba ɔ̃abo mmɔ, ne ɔsɛ i ikpata ame i madzuɛ̃se kɔrɛ ɔto ɔwa ɔtɔ ne. ");
INSERT INTO akp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ɣaa masɔrɛdze gu atɔ̃memaɣɛdze ma ɔɖuɖu nsi ne, mato manyɔnyɔ itɔ̃me nɛ maasu matã Yesu ipɔ fiɛ mana wũ maɖoe. Ɣɛɛ mainya kuira lalaa kuiwɛ̃. ");
INSERT INTO akp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Maturi gbodzoo ɔɖe aka maɖaɛ wũ kanya, ɣɛɛ ne, ma atɔ̃me ɔta aya so iso. ");
INSERT INTO akp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ne mawɛ̃ ɔta maya maɖaɛ wũ kanya sɔ, ");
INSERT INTO akp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Bonɔ ɔɣɛ sɔ, ‘Loabiɛ Ɣaa Isɔrɛyo nɛ masu nrɔɔ̃ matsue i ngbe. Fiɛ ayi atɛ kama ne, loatsue imama nɛ iiɖe maturi lotsue.’ ” ");
INSERT INTO akp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ɣɛɛ ma wũ ma atɔ̃me ana iikategu ma malaa are. ");
INSERT INTO akp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ɣaa sɔrɛdzekpakpa pelepele ɔta ɔya i ma ɔɖuɖu katɔ̃ ɔkarɛ Yesu sɔ, “Anɔ itɔ̃me nɛ mato maɣɛ? Be aba aaɣɛ?” ");
INSERT INTO akp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ɣɛɛ ne, Yesu ɔma kanya kpa, ɔ̃iɣɛ kuira. Sɔrɛdzekpakpa pelepele ɔkarɛ wũ ana sɔ, “Fɔ nɖe Kristo gɔ nɖe Bosate Sekelea mɔmɔ Ɔbi?” ");
INSERT INTO akp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu ɔɣere wũ sɔ, “Mme mmɔ ne. Mi ɔɖuɖu to mianya Ɔturi Awune Ɔbi sɔ ɔsi i Ɣaa Ɔlesate kuɖearɔ̃ iso. Fiɛ mianya sɔ ɔ̃abɔrɛ i kato i adɔdɔ ame ɔto ɔba!” ");
INSERT INTO akp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ɔluwɛ̃ sɔrɛdzekpakpa pelepele ɔkɛ so awu i sikpã ame sɔ, “Boisito bobie ku itɔ̃me kuiwɛ̃ i ɔmama kɔrɛ! ");
INSERT INTO akp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ɔɣɛ imusuora ɔsegu i Ɣaa iso! Nda minya?” Ne ma ɔɖuɖu ɔtɔrã masia ita sɔ matã wũ ipɔ sɔ ɔ̃akpi. ");
INSERT INTO akp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ma mawɛ̃ ɔtsɛ minyatu itua ifere Yesu. Manyi wũ anɔmi fiɛ matsɛ wũ ipɛ, mato maɣere wũ sɔ, “Ɣɛ ngɔ lopɛ-ɔ!” Ɔ̃ madzuɛ̃se mawɛ̃ to mapɛ wũ sirɔ̃ta. ");
INSERT INTO akp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Gɔ Petro si i ikpata ame mmɔ ne, iyo ame ɔsande birɔ̃gomi ɔwɛ̃ ɔbɔrɛ i sɔrɛdzekpakpa pelepele iyo ɔba. ");
INSERT INTO akp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Gɔ ɔnya Petro to ɔwa ɔtɔ ne, ɔnyɔ wũ totoroo ɔɣere wũ sɔ, “Fɔ wũ asiai Yesu Nasaretse!” ");
INSERT INTO akp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ne Petro ɔkarɛ wũ sɔ, “Be? Loiɣe itɔ̃me nɛ ato aɣere me ngbe kiniɔ!” Ne ɔta ɔya ɔkɛlɛ kayogodɔ̃ kɔrɛ, kere ne rodza ɔɖi kanya ne. ");
INSERT INTO akp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ɔbirɔ̃gomi gɔmɔ ɔledza wũ inya, ne ka ɔto ɔɣere mma nɣɛ i mmɔ sɔ, “Ɔrɛrɛ̃ gɔgbe ɔ̃ wũ ma ɔwɛ̃ ɔɖe!” ");
INSERT INTO akp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ɣɛɛ Petro ɔledza isɛ̃ ana. Iifɔ ɔwi kɔra fiɛ mma nɣɛ i mmɔ ɔtsɛ Petro iɣere sɔ, “Gbagbaã ma ɔwɛ̃ aɖe, alasɔ fɔ wũ abɔrɛ i Galilea karɔ̃ iso!” ");
INSERT INTO akp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ne Petro ɔtsɛ ndamu ikã itarĩgu ara iɣɛ sɔ, “Lotarĩgu Ɣaa sɔ ɔkpadzɛ̃ me kutsue si lola sila! Loiɣe ngɔ itɔ̃me mito miɣɛ i ngbe!” ");
INSERT INTO akp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ɔluwɛ̃ ne, rodza ɔɖi kanya ɔkpɛ nyɔare, ne ɔnyigi nnɛ i Yesu ɔɣere wũ sɔ, “Si rodza aaɖi kanya ɔkpɛ nyɔare ne, ato aasɛ̃ me ikpɛ itɛ sɔ aiɣe me.” Ɔtu ɔbiɛ Petro, ne ɔpɛ kaku ne. ");
INSERT INTO akp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Gɔ kaɖe ɔsɛ̃ kaya tutuutu ne, ma Yudase masɔrɛdze ɔsarɛgu ma ɔmagɛ̃ makpakpa gu mmara matedze gu matɔ̃meɣɛdze ɔɖuɖu. Gɔ masɛ iti ame i itɔ̃me iso ne, manyi Yesu fiɛ makɔ wũ makɛlɛgu Roma abã ɔkpakpa Pilato. ");
INSERT INTO akp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mmɔ i Pilato ɔkarɛ Yesu sɔ, “Fɔ nɖe ma Yudase Igara ne?” Yesu ɔɣere wũ sɔ, “Aĩ, ise lɛ kumɛgɔ ato aɣɛ.” ");
INSERT INTO akp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ɣaa masɔrɛdze ɔnyi atɔ̃me gbodzoo masia Yesu iso. ");
INSERT INTO akp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ne ɔso Pilato ana ɔkarɛ wũ sɔ, “Fɔ aito aɣɛ kuiwɛ̃? Kã atsue si anɔ atɔ̃me wa mato maɣɛ i fɔ iso!” ");
INSERT INTO akp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ɣɛɛ Yesu iibusi kanya, ne ɔso ibara Pilato ɣaa. ");
INSERT INTO akp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Iyi siare nɛgbe ɔɖewi ne, Pilato sɛ ɔtɔrã maɖi yorɛdze ɔwɛ̃ gɔ makarɛ ɔtã ma. ");
INSERT INTO akp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ɔwi gɔgbe ame ne, mamɔɛ̃ ɔrɛrɛ̃ ɔwɛ̃ gɔ marɔ sɔ Baraba mapia iyo gu mma lota maya ma Romase Igara iso, Gɔ mabara ngbɔ ɔso ne, mamɔɛ̃ ma fiɛ matã ma kukpi ipɔ alasɔ maɖoe maturi. ");
INSERT INTO akp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ne iturikuri ɔkarɛ Pilato sɔ ɔnyigi ɔ̃ nnyainyɔ ɔtã ayo marɛdze lɛ kumɛgɔ ame ɔbua ɔsɛ ɔbara ɔwi biara. ");
INSERT INTO akp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ɔkarɛ ma sɔ, “Mitɔrã sɔ lonyua ma Yudase Igara lotã mi?” ");
INSERT INTO akp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato ɔkarɛ ma ngbɔ alasɔ ɔɣe sɔ sirerɛ ɔso fiɛ makpakpa ɔmɔɛ̃ Yesu mabɔ wũ. ");
INSERT INTO akp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ɣɛɛ Ɣaa masɔrɛdze ɔɣɛ mapia maturi sɔ Pilato si ɔnyua Baraba ɔtã ma. ");
INSERT INTO akp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato ɔɖe iturikuri ika, ne ɔto ɔkarɛ ma sɔ, “Be mibie sɔ lobaragu ngɔ mito mirɔ sɔ ma Yudase Igara?” ");
INSERT INTO akp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ne masia kulu sɔ, “Tã mapɛ wũ mamatãra i kudziri iso!” ");
INSERT INTO akp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato ɔkarɛ ma sɔ, “Be iɖe ɔso? Iɖe iɣɛrɛ nɛ ɔɣɛrɛ?” Ma ɔɖuɖu ɔsia kulu titiiti mabua mato maɣɛ sɔ, “Tã mapɛ wũ mamatãra i kudziri iso.” ");
INSERT INTO akp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Gɔ Pilato to ɔbie sɔ ɔ̃abara ma kuɖɔɛ ɔso ne, ɔnyua Baraba ɔtã ma. Ne ka ɔtã mapɛ Yesu kukaakɔ fiɛ ɔsu wũ ɔtã sɔ makɛlɛgu wũ maapɛ mamatãra i kudziri iso ne. ");
INSERT INTO akp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Makɔ Yesu makɛlɛgu Roma abã ɔkpakpa iyo siare ame fiɛ makpere makpakpɛ̃dze tsɔra mabɔ. ");
INSERT INTO akp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Masu ɔgo rɛtɛa awu mapia wũ fiɛ masu igba miyu mabara igara ikoto masu matɔ̃medza wũ. ");
INSERT INTO akp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ne mato mabara wũ, aɣiãra sɔ, “Ɣii-ɣiiɖuu! Ma Yudase Igara, sɛ ngbã dzoroo!” ");
INSERT INTO akp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Masu sidziri maɖeɖe wũ iti, fiɛ matua minyatu mafere wũ. Ne mato mapɛ agɛgɛ̃ i ɔ̃ katɔ̃ sɔ mato masɔrɛ wũ ne. ");
INSERT INTO akp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ɔwi gɔ maɔbara wũ aɣiãra maro ne, manyuarã ɔgo rɛtɛa awu, fiɛ masu ɔ̃ are mapia wũ. Ne makɔ wũ maruigu sɔ maapɛ wũ mamatãra i kudziri iso ne. ");
INSERT INTO akp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Gɔ masɛ ne, masarɛgu ɔrɛrɛ̃ gɔ marɔ Simon gɔ ɔse i ɔ̃ kasɛkɔ̃ ɔto ɔba Yerusalem. Makpakpɛ̃dze ɔya wũ iso sɔ ɔfɔgu Yesu ɔnyigbã ɔsore. Simon ɔse i Sireni, fiɛ ɔ̃ mabi nɖe Aleksandra gu Rufo ne. ");
INSERT INTO akp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Makɔ Yesu makɛlɛgu kabemi kawɛ̃ ga marɔ sɔ Golgata, gɔ karɔ̃ nɖe sɔ ɔturi iti ikui. ");
INSERT INTO akp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Gɔ mabo mmɔ ne, mabie sɔ si matã wũ ndã bea mɛ malupu kua gɔ mba ɔɖo sɔ ɔnɛ si ɔ̃ibana ibo, ɣɛɛ Yesu iinɛ. ");
INSERT INTO akp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ne makpakpɛ̃dze ka mapɛ wũ mamatãra i kudziri iso ne. Mapɛ sibɔ ala atalebi i ɔ̃ arapia iti si matsue ɔbiara nwa loaɣo wũ, masu maɣɛɣɛ so. ");
INSERT INTO akp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mapɛ wũ mamatãra ku kaya iɖɔwũ kaiwɛ̃ tutuutu. ");
INSERT INTO akp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Matsɛrɛ nnɛ ɔbara masia i kakolo iso, masu mapɛ mamatãra i ɔ̃ sitikpe sɔ, “Ɔ̃ Nɖe Ma Yudase Igara Ne.” ");
INSERT INTO akp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mapɛ mayukukpe inyɔ ana mamatãra i Yesu kɔrɛ mmɔ, ɔwɛ̃ i ɔ̃ kuɖearɔ̃ iso, fiɛ ɔwɛ̃ ana sa i ɔ̃ kubena iso. ");
INSERT INTO akp_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Iba lɛ kumɛgɔ matsɛrɛ masɛ i Ɔko Sekelea ame sɔ, “Maɖoe wũ ku makpibaradze.” ");
INSERT INTO akp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mma ɔɖuɖu loki i mmɔ mafe ɔtidza ati fiɛ matiatia Yesu sɔ, “Yuɛ! Fɔ tutuutu fɔ loɣɛ sɔ aabiɛ bo isɔrɛyo siare nɛgbe aledza ne itsue i akpɛnɛ atɛ kama ne! ");
INSERT INTO akp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","So ba si aɖi so i kukpi nrɔɔ̃ ame si bonya.” ");
INSERT INTO akp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ngbɔ ame i masɔrɛdze gu mmara matedze ana ɔma wũ maɣere so sɔ, “Ɔɖi mawɛ̃, ɣɛɛ ɔ̃ito ɔwo so ɔɖi! ");
INSERT INTO akp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Si fɔ nɖe Israel Igara gu Kristo gɔ i Ɣaa ɔɖi ɔsɛ mɔmɔ ne, ɖi so i kudziri iso si boafɔ-ɔ boɖe.” Maturi inyɔ ma mapɛ mamatãra mabua wũ iso ana ɔtiatia wũ. ");
INSERT INTO akp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kakɔme iɖɔwũ iweo-inyɔ ame ne, kayi ɔsɛ̃ guduu, ifɔ iɖɔwũ itɛ. ");
INSERT INTO akp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Iɖɔwũ itɛ̃ nɛgbe kama ne, Yesu ɔla kulu teteree sɔ, “Eli, Eli, lama sabaktani?” Gɔ karɔ̃ nɖe sɔ, “Wũ Ɣaa, wũ Ɣaa, be ɔso anyua me asɛ ngbɔ?” ");
INSERT INTO akp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mawɛ̃ ma loya i mmɔ manɔ ɔɣɛ sɔ, “Minɔ! Ɔto ɔkpere Eliya.” ");
INSERT INTO akp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ma ɔwɛ̃ ɔtere ɔsu ɖɔti pukupukua ɔpia i ndã bea ame, ne ɔɖu ɔdziri ɔsu ɔtã Yesu ne. Ne ɔɣere matsɔra sɔ, “Mitã bonyɔ si Eliya aaba ɔ̃aɖi wũ i kudziri iso!” ");
INSERT INTO akp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu ɔla kulu teteree ana kere ne ɔma kanya ne. ");
INSERT INTO akp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ɔwi gɔmɔ tutuutu ne, ma Yudase isɔrɛyo ame ɔkati kpikpirikpi gɔ loɣɛ kasɔrɛkɔ̃ gu kasekelekɔ̃ ɔkɛ i ndɛ̃ndɛ̃ ita i kato iba iafere i karɔ̃. ");
INSERT INTO akp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Gɔ kpakpɛ̃dzekpakpa gɔ nɣɛ i Yesu katɔ̃ ɔnya kumɛgɔ ɔsu ɔkpi ne, ɔɣɛ sɔ, “Gbaã iɖe sɔ Ɣaa Ɔbi ɔɖe i ngbe.” ");
INSERT INTO akp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Marɔ̃go mawɛ̃ ana ɔya dzoroo mato manyɔ. Ma mawɛ̃ nɖe Maria Magdalase gu Salome gu Maria gɔ mabi nɖe Yakobo koso gu Yose ne. ");
INSERT INTO akp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ɔwi gɔ i Yesu ɔwe i Galilea karɔ̃ iso ne, ma losiai wũ mala maɔbuai wũ ne. Marɔ̃go gbodzoo mama ma losiai wũ maba Yerusalem ana ɔya i mmɔ. ");
INSERT INTO akp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nwagbe ɔɖuɖu ɔba ku iyi nɛ nɖe iledzaso itã ma Yudase Iwarãyi katɔ̃. Ne gɔ kutsuɛ to kuɣo ne, ");
INSERT INTO akp_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ma Yudase atɔ̃meɣɛdze ɔwɛ̃ gɔ marɔ sɔ Yosef, Arimatease, ɔpia so ɔle, ɔkɛlɛ Roma abã ɔkpakpa Pilato kɔrɛ. Yosef ɖe ɔturi ɔwɛ̃ gɔ masɛ mawarɛ fiɛ ɔ̃ anɔ sia i Ɣaa sigarakaɖekɔ̃ iba iso. Gɔ ɔbo Pilato kɔrɛ ne, ɔpɛ wũ nrɔɔ̃ sɔ ɔtã wũ ɔri si ɔsɛ ɔ̃abɛse Yesu kpise ɔsɛ ɔ̃abiara fiɛ Iwarãyi aaɣo. ");
INSERT INTO akp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ibara Pilato ɣii gɔ ɔnɔ sɔ Yesu ɔkpi mala ngbɔ. Ne ka ɔkpere kpakpɛ̃dzekpakpa gɔ loya i mmɔ ɔnya nwa loba pelepele, ɔkarɛ wũ sɔ iɔna ɔpã gɔ Yesu ɔkpi? ");
INSERT INTO akp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ne gɔ ɔkpakpa ɔɣere wũ sɔ ɔ̃ɔkpi koko ne, Pilato ɔtã Yosef ɔri sɔ ɔsɛ ɔ̃aɖi wũ ɔbiara. ");
INSERT INTO akp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ne Yosef ɔsɛ ɔ̃abɛse Yesu ɔbɔ karɔ̃, ɔmini wũ i ɔkati fudza gɔ ɔɣa ame. Ne ka ɔsu wũ ɔbiara i itawo nɛ makuri masɛ i kube kukpa ame ne. Ɔmɛrɛdza ita siare ɔtɛ̃ iwo kanya. ");
INSERT INTO akp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdalase gu Maria gɔ nɖe Yose ɔnyi ɣɛ i mmɔ manya ngbegɔ ɔbiara wũ. ");
INSERT INTO akp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ikpɛnɛ nyɔare kutsuɛ gɔ Iwarãyi ɔɔro ne, Maria Magdalase gu Maria gɔ nɖe Yakobo ɔnyi gu Salome ɔsɛ maaɣa korobo sɔ maasɛ maasɔla Yesu. ");
INSERT INTO akp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ne ɔso gɔ kaɖe ɔɖaɛ ku Kɔsiɖa kaya ne, mata sɔ masɛ kabiarakɔ̃. ");
INSERT INTO akp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Gɔ masɛ i ɔri ne, mato makarɛ so sɔ, “Nna loamɛrɛdza ita ɔɖi i iwo kanya ɔtã bo?” Makarɛ so ngbɔ alasɔ ita siare iɖe. Ɣɛɛ gɔ mabo mmɔ ne, manya sɔ ɔnyiiɔ ɔli ita sɛnɛkɛ̃ra ɔsɛ i kuruɛ. ");
INSERT INTO akp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ne ɔso maso mabo i iwo ame, ne manya ɔporoporoi ɔwɛ̃ si i kuɖearɔ̃ iso, ɔpia awu fudza futututu ne. Makpɛ̃ so. ");
INSERT INTO akp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ɔporoporoi gɔmɔ ɔɣere ma sɔ, “Midaanigã. Loɣe sɔ Yesu Nasaretse gɔ mapɛ mamatãra i kudziri iso mito mibie. Ɔna i ngbe! Ɔ̃ɔta, ɔpia ngbã! Minyɔ ngbegɔ marara wũ! ");
INSERT INTO akp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ne ɔso misɛ miaɣere ɔ̃ marasuãdze gu Petro ana sɔ, ‘Yesu ɔɔɖe mi katɔ̃ ɔkpa Galilea karɔ̃ iso. Mmɔ mianya wũ lɛ kumɛgɔ ɔɣɛ ɔsɛ ne.’ ” ");
INSERT INTO akp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ibara marɔ̃go magbe ɣii, ne marui i kabiarakɔ̃ mmɔ ku ifɔ̃ gu iti ikpakpa gu ise ne. Gɔ marui ne, maiwo kuwɛ̃ ɔɣere i ɔri iso, alasɔ ifɔ̃ ɔmɔɛ̃ ma. ");
INSERT INTO akp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Gɔ Yesu ɔta ɔbɔrɛ i makpise ame ku Kɔsiɖa kaya tutuutu ame ne, ɔɖe katɔ̃ ɔɖi so ɔte Maria Magdalase gɔ ame ɔsa siwarã lalaa ikɔdzɛ ɔɖi ɔnya. ");
INSERT INTO akp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ɔsɛ ɔ̃aɣere Yesu malaa sɔ, Yesu ɔɔta ɔwi gɔ ame mato mabiɛ mamararã so ala ɔ̃ kukpi ɔso. ");
INSERT INTO akp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Gɔ Maria ɔɣere ma sɔ Yesu ɔɔta ɔpia ngbã ne ɔnya wũ ne, maifɔ wũ maɖe. ");
INSERT INTO akp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ɔwi gɔgbe kama ne, Yesu ɔɖi so ɔte marasuãdze inyɔ ma nsɛ i Yerusalem ɔri. Mainya wũ maɖi ite i karɔ̃kasɛkɔ̃. ");
INSERT INTO akp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ɣɛɛ gɔ matsue ne, makpese masɛ maaɣere matsɔra. Ɣɛɛ ne, maifɔ ma maɖe. ");
INSERT INTO akp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Katsɔrakɔ̃ ne, Yesu ɔɖi so ɔte marasuãdze iweo-ɔwɛ̃ i aɖera kaɖekɔ̃. Ɔnyagalagu ma alasɔ mana kafɔkaɖe fiɛ ma atsue ba ɔle aɣede, fiɛ maifɔ mma lonya wũ maɖegu katɔ̃ maɖe sɔ ɔpia ngbã. ");
INSERT INTO akp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ɔɣere ma sɔ, “Mikɛlɛ kayi ɔɖuɖu ame si miɣɛ Ɣaa Itɔ̃me Bielea i maturi ɔɖuɖu ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ɔbiara gɔ loafɔ Itɔ̃me Bielea nɛ ɔɖe, fiɛ ɔ̃afɔ Ɣaa itupie kubarara ne, ɔ̃ana iɖi. Ɣɛɛ ngɔ loifɔ ɔɖe ne, Ɣaa to ɔ̃atã wũ kukpi ipɔ. ");
INSERT INTO akp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Akparĩ wagbe loasiai mma lofɔ maɖe ne. Maabara awawãra, maasa siwarã lalaa maɖi i wũ iyere ame. Maaɣɛ siɖe ɣɛtɛ agbãagbã dzɛ maiɣe fiɛ maisuã. ");
INSERT INTO akp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Si mamɔɛ̃ aɣɛ ɣee si manɛ ndu lalaa ne, iibabara ma kuira. Si masia manyɛse nrɔɔ̃ i ati ne, maana isosarɛ.” ");
INSERT INTO akp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Gɔ Bosate Yesu ɔɖe ma aka wamɔ kama ne, Ɣaa ɔsu wũ ɔkɛlɛgu kato ɔsɛra i ɔ̃ kuɖearɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ɔ̃ masiaidze ana ɔki nrɔ̃ ɔɖuɖu iso maɣɛ ɔ̃ Itɔ̃me Bielea. Ne Bosate ɔwe i ma ame, ɔsɛgu ma sɔ maɖi ɔ̃ Itɔ̃me Bielea mate iki awawãra agbãagbã wa mabara i ɔ̃ ɔle ame ne. ");
INSERT INTO akp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Wũ ɔnyii Tiofilo, maturi gbodzoo ɔɔpia so kubɛ kumɛgɔ maawo sɔ si matsɛrɛ ira masegu i ara wa loba i bo ndɛ̃ iso masɛ. ");
INSERT INTO akp_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Matsɛrɛ lɛ kumɛgɔ i mma lonya Itɔ̃me Bielea karɔ̃kasɛkɔ̃ ɔɣere bo awe, fiɛ mato maya ne isã ana. ");
INSERT INTO akp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ne ɔso ne, Bokɔse Tiofilo, gɔ mme wũ losu losia so iso lotsue ara wagbe ta karɔ̃kasɛkɔ̃ ɔso ne, lobara adzuni sɔ ilɛ sɔ loatsɛrɛ wã kukaakɔ losese-ɔ kumɛgɔ aba. ");
INSERT INTO akp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nto lobara ngbɔ ala lobie sɔ aatsue ira biara nɛ mate-ɔ wodoroo. ");
INSERT INTO akp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ɔwi gɔ ame i Herodes ɔɖe sigara i Yudea karɔ̃ iso ne, Ɣaa sɔrɛdze ɔwɛ̃ ɔwe gɔ marɔ Zakaria. Ɔbɔrɛ i sɔrɛdze Abia ikuri ame. Zakaria gɔgbe ɔre marɔ Elisabet ne. Ɔ̃ wũ ɔbɔrɛ i masɔrɛdze ɔɣekparɛ ame. ");
INSERT INTO akp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ɔrã gu ɔre gɔgbe ɔsɛ ngbã lɛ Ɣaa masɔrɛdze awe i Ɣaa anɔ. Maɖe ɔ̃ mmara ɔɖuɖu iso kukaakɔ. ");
INSERT INTO akp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ɣɛɛ ne, maiɣe ɔbi ala Elisabet ɖe ɔlɛma fiɛ ma inyɔɔ ana ɔɔsɛ katɔ̃ i akɔ ame. ");
INSERT INTO akp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Iyi iwɛ̃ ne, Zakaria ɔkɛlɛ ma Yudase isɔrɛyo sɔ ɔ̃abara ɔ̃ masɔrɛdze karabara ala ma ikuri iɔɣo sɔ maabara. ");
INSERT INTO akp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","I masɔrɛdze kubarara kanya ne, gɔ mabara kareremi ne, Zakaria iso isia, ne ɔso ɔkɛlɛ Ɣaa isɔrɛyo ame sɔ ɔ̃atsuedza kua kɔrɔ̃kɔrɔ̃a ɔtã Ɣaa i isɔrɛkasege iso. ");
INSERT INTO akp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ɔwi gɔ ɔto ɔtsuedza kua kɔrɔ̃kɔrɔ̃a mmɔ ne, masumudze tsɔra ɣɛ i inyamɔ mato makparama kayi. ");
INSERT INTO akp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ɣaa kpabo ɔwɛ̃ ɔɖi so ɔte wũ. Ɔɣɛ i isɔrɛkasege ga iso ɔto ɔtsuedza kua kɔrɔ̃kɔrɔ̃a kuɖearɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Gɔ Zakaria ɔnya wũ ne, ɔkpɛ̃ so, ifɔ̃ ɔmɔɛ̃ wũ gbaã. ");
INSERT INTO akp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ɣɛɛ Ɣaa kpabo gɔmɔ ɔɣere wũ sɔ, “Zakaria, daanigã! Ɣaa ɔɔnɔ fɔ kayi ikparama, ne ɔso fɔ ɔre Elisabet to ɔ̃aɣe ɔbirɛrɛĩ ɔtã-ɔ. Tã wũ iyere sɔ Yohanes. ");
INSERT INTO akp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Si maɣe wũ ne, ato aana isoɣɔ, alɛlɛ gbaã lɛ kumɛgɔ iaɖe maturi gbodzoo ana isoɣɔ. ");
INSERT INTO akp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ɔto ɔ̃aɖe ɔturi siare i Ɣaa anɔ. Ɔdaanɛ̃ ndã kpokporoa kumiwɛ̃ mɛ loamɔɛ̃ wũ ɖuɖuuɖu. Siwarã Bielea to siayi ɔ̃ ame fiɛ maaɣe wũ. ");
INSERT INTO akp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ɔ̃ loakpesera Israel maturi gbodzoo ɔbɔ ma Sate Ɣaa kɔrɛ ne. ");
INSERT INTO akp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ɔ̃ ɔɖe loaɖe Bosate iba katɔ̃ fiɛ siwarã gu ɔle gɔ lowe i Ɣaa kanyaɖidze Eliya ame to iawe i ɔ̃ ame. Ɔto ɔ̃afere mabi gu mase kanya ndu. Ɔto ɔ̃afinikira matsuelese ɔkpesera mma nsɛ mabu iti ame i ibɔlɔlɔ iso. Nnɛgbe loatã Bosate maturi ɔnyɔ tuee matã ɔ̃ iba ne.” ");
INSERT INTO akp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Mmɔ i Zakaria to ɔkarɛ kpabo gɔgbe sɔ, “Be loatã lofɔ nnɛgbe loɖe? Bo gu wũ iyo ɔnyi ɔɖuɖu somina ɔɔsɛ katɔ̃ i akɔ ame.” ");
INSERT INTO akp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ne kpabo to ɔtã wũ mmuai sɔ, “Mme nɖe Gabriel gɔ nsɛ ɔya i Ɣaa katɔ̃ ne. Ɔ̃ ɔɖe lopia me sɔ loɣere-ɔ kanya gagbe ne. ");
INSERT INTO akp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Atoa sɔ aifɔ nnɛ loɣere-ɔ aɖe ne, ito iaba lɛ kumɛgɔ loɣɛ ku ɔwi gɔ i Ɣaa ɔsia ita. Ɣɛɛ kumɛgɔ aifɔ aɖe ɔso ne, fɔ ɔnyagɛmi iisibata ɔnya gbɔgbɔɔgbɔ nnɛ loɣɛ ɔba i ne ame.” ");
INSERT INTO akp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ɔwi gɔ i nnɛgbe ɔɖuɖu to ikɛlɛ i katɔ̃ ne, mma nɣɛ masia Zakaria i isɔrɛyo inyamɔ ɔkpɔkpɔtɔ alasɔ maiɣe nnɛ ɔso fiɛ ɔ̃ɔna ɔpã ngbɔ. ");
INSERT INTO akp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Gɔ ɔba ɔ̃abɔrɛ i iyo ne, ɔ̃isito ɔwo ika ɔɖegu ma. Ne ɔso matsue sɔ ɔnya iɖi ite i isɔrɛyo mmɔ. Gɔ ɔ̃ito ɔwo ika ɔɖe ɔso ne, nrɔɔ̃ ka ɔto ɔɖiɖi si ɔ̃aɣere ma ira. ");
INSERT INTO akp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ɔwi gɔ i Zakaria ɔɔro ɔ̃ karabara i isɔrɛyo ne, ɔkpese ɔkɛlɛ ɔ̃ iyo. ");
INSERT INTO akp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ɔwi kurukutu kama ne, Elisabet ɔba ɔ̃ala kayiri, ne ɔso ɔkɔla so i iyo awa aru i kuɖokpo. ");
INSERT INTO akp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ne Elisabet ɔɖe ika ɔɣɛ sɔ, “Kiniɔ ne, Ɣaa ɔɔnyɔ me nnya. Ɔ̃ɔɖi me kunuarɛ i anɔ ɔkɔlɛ me anɔ kato i maturi ndɛ̃.” ");
INSERT INTO akp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ɔwi gɔ i Elisabet kayiri ɔɔfɔ awa akuɔ ne, Ɣaa ɔpia ɔ̃ kpabo Gabriel sɔ ɔkɛlɛ ɔmagɛ̃ gɔ marɔ Nasaret i Galilea karɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ɔsia wũ kanya i ɔbitɛ ɔwɛ̃ gɔ marɔ sɔ Maria kɔrɛ. Ɔbitɛ gɔgbe makarɛ matã Yosef gɔ lobɔrɛ i igara David ɔɣekparɛ ame ne. ");
INSERT INTO akp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gɔ kpabo ɔba ɔ̃abo Maria kɔrɛ ne, ɔɣere wũ sɔ, “Isobuɛ itã-ɔ! Bosate piagu-ɔ fiɛ ɔ̃ kusɛkusɛ ana sia-ɔ iso.” ");
INSERT INTO akp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kpabo gɔgbe atɔ̃me ɔkpɔkpɔtɔra Maria adzuni ala ɔ̃inɔ kaya gagbe karɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mmɔ i kpabo to ɔɣere wũ sɔ, “Maria, daanigã ala Ɣaa nnyainyɔ piagu-ɔ. ");
INSERT INTO akp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ato aba aala kayiri aɣe ɔbirɛrɛĩ, tã wũ iyere sɔ Yesu. ");
INSERT INTO akp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ɔto ɔ̃afɔ iyere gbaã fiɛ maarɔ wũ sɔ Ɣaa Ɔlesate mɔmɔ ɔbi. Bokɔse Ɣaa to ɔ̃asɛra wũ sigara lɛ ɔ̃ ɔwa tɛtɛ David awe. ");
INSERT INTO akp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ɔto ɔ̃aɖe sigara i Yakob mawa iso ɔwi ɔɖuɖu ame. Fiɛ ɔ̃ sigara iɖe iibafe inya ɖa.” ");
INSERT INTO akp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mmɔ i Maria to ɔkarɛ wũ sɔ, “Nda nwagbe aawo ɔba gɔ loiɣe ɔrɛrɛ̃ kuwɛ̃?” ");
INSERT INTO akp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mmɔ i kpabo gɔmɔ to ɔtã wũ mmuai sɔ, “Siwarã Bielea to siayi fɔ ame fiɛ Kato gu Karɔ̃ Baradze ɔle to ɔ̃aba-ɔ iso. Ne ɔso ɔbirɛrɛĩ gɔ aaɣe ne, maarɔ wũ sɔ, Ɔsekelea, Ɣaa Ɔbi Birɛrɛĩ. ");
INSERT INTO akp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Lobie sɔ loatã-ɔ itsue sɔ ne, fɔ ɔnyiibi gɔ nɖe Elisabet fiɛ ɔɖe ɔlɛma ne, ka ɔto kayiri awa akuɔ atoa sɔ ɔ̃ akɔ ɔɔsɛ katɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Alasɔ kuira iiɖo Ɣaa ibara.” ");
INSERT INTO akp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ne Maria ɔɣere wũ sɔ, “Nyɔ! Mme ne, Ɣaa ɔɖabo loɖe. Ɔbara ɔtã me lɛ kumɛgɔ aɣɛ.” Ne Ɣaa kpabo ɔrui ne. ");
INSERT INTO akp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Ayi wamɔ ame ne, Maria ɔledza so ɔpɛ siwa ɔkɛlɛ Yudea karɔ̃ iso i abe ndɛ̃. Ɔkɛlɛ Zakaria iyo ɔsɛ ɔ̃aya Elisabet. ");
INSERT INTO akp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Gɔ Elisabet ɔnɔ Maria kaya ne, ɔ̃ ɔbi gɔ i kayiri ame ko lotsue ngba, ɔluwɛ̃ Siwarã Bielea ɔyi Elisabet ame ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ne ɔto ɔkpagɛ silɔ kato ɔɣɛ sɔ, “Maafere-ɔ kusɛkusɛ i marɔ̃go ndɛ̃ fiɛ fɔ ɔbi gɔ aaɣe ne, mafere wũ kusɛkusɛ! ");
INSERT INTO akp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mme nɖe nna fiɛ Bosate ɔnyi aaba ɔ̃aya me? ");
INSERT INTO akp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Alasɔ ɔluwɛ̃ gɔ lonɔ fɔ kaya ne, ɔbi gɔ mpia me i kayiri ame ko lokpɛ̃ so i isoɣɔ ame. ");
INSERT INTO akp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Na isoɣɔ gbaã alasɔ afɔ kanya ga i Ɣaa kpabo ɔba ɔ̃aɣere-ɔ aɖe sɔ iaba ɔso.” ");
INSERT INTO akp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ne Maria ɔpia ɔnɔ kanya sɔ, “Wũ ɔtu to ɔle Bosate. ");
INSERT INTO akp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Fiɛ so ɔɣɔ me i Ɣaa gɔ nɖe wũ Ɖidze iso, ");
INSERT INTO akp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","alasɔ ɔnyigi me ɔ̃ ɔɖabo gɔ loire kuira. Ita i kiniɔ ito ikɛlɛ ne, mawa gu mawa tɛtɛ ɔɖuɖu to maakpere me sɔ ɔturi gɔ ilɛgu. ");
INSERT INTO akp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Alasɔ Ɔlesate ɔbara ara siare ɔtã me, fiɛ ɔ̃ iyere se sekelee. ");
INSERT INTO akp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ɔ̃ nnyainyɔ se itã mawa gu mawa ma ɔɖuɖu nsɛ manigã wũ. ");
INSERT INTO akp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ɔɖi ɔ̃ ɔle ɔte fiɛ ɔsamarã mma nsɛ makɔlɛ so kato i ma situ ame. ");
INSERT INTO akp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ɔkpasera magarakpakpa fiɛ ɔkɔlɛ mma lobɔ so karɔ̃ kato. ");
INSERT INTO akp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ɔsu ara sɛɛ ɔmidza mma i kukã to, ɔkpesera maranase mawɛrɛba. ");
INSERT INTO akp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ɔ̃ anɔ sia i itɔ̃me nɛ ɔɣere bo mawa ɔsɛ iso, fiɛ ɔ̃ɔba sɔ ɔ̃abuai Israel kaɖe. ");
INSERT INTO akp_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ɔnyigi ɔ̃ nnyainyɔ nɛ ɔsu ɔtã Abraham gu ɔ̃ mawa ikpa ta kayi karokɔ̃.” ");
INSERT INTO akp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ne ɔso Maria ka ɔwegu Elisabet awa atɛ ɔɖui fiɛ ɔkpese ɔkɛlɛ ɔ̃ aɖe. ");
INSERT INTO akp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Gɔ ɔwi ɔɣo sɔ Elisabet aaɣe ɔbi ne, ɔɣe ɔbirɛrɛĩ. ");
INSERT INTO akp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ɔ̃ magbamikui gu ɔ̃ manyii ɔɖuɖu ɔnɔ iwawãra siare nɛ i Ɣaa ɔbara ɔtã wũ. Ne ɔso managu wũ isoɣɔ gbaã. ");
INSERT INTO akp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Iyi nɛ maɖi ɔbi i iyo ne, masɛ maatu wũ sirɛrɛ̃ fiɛ mabie sɔ si masu ɔ̃ ɔse iyere Zakaria masia wũ. ");
INSERT INTO akp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ɣɛɛ ɔ̃ ɔnyi iinɔgu ma karɔ̃. Ɔɣere ma sɔ, “Misia wũ Yohanes.” ");
INSERT INTO akp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mawararã ku wũ sɔ, “Mi ɔlɛdze ɔmele masɛ marɔ ngbɔ?” ");
INSERT INTO akp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mmɔ maɖiɖi nrɔɔ̃ makarɛ ɔbi ɔse sɔ mme iyere ɔto ɔbie sɔ masia ɔbi. ");
INSERT INTO akp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakaria ɔkarɛ ita nɛ iso masɛ matsɛrɛ ara. Gɔ ɔfɔ ne ne, ɔtsɛrɛ sɔ, “Ɔ̃ iyere nɖe Yohanes.” Ne ɔso ibara ma ɔɖuɖu ɣii. ");
INSERT INTO akp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ɔluwɛ̃ Zakaria ɔnyagɛmi ɔkurisi ɔtsɛ ika iɖe ile Ɣaa. ");
INSERT INTO akp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ifɔ̃ siare ɔmɔɛ̃ ɔ̃ magbamikui itã sɔ itɔ̃me nɛgbe ɔki ikã Yudea simagɛ̃ dzɛ i abe iso abuiti ɔɖuɖu ame. ");
INSERT INTO akp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mma ɔɖuɖu lonɔ ara wagbe ɔla maɔkarɛ so sɔ, “Mme ɔturi igbã i ɔbi gɔgbe to ɔba ɔ̃aɖe?” Makarɛ so ngbɔ ala ite sekelee sɔ Ɣaa kɔrɔ̃ sia wũ iso. ");
INSERT INTO akp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Mmɔ i Siwarã Bielea ɔbo i ɔbi ɔse Zakaria ame ɔɣɛ ɔsɛ sɔ, ");
INSERT INTO akp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Mitã bole Bosate gɔ nɖe Israel Ɣaa alasɔ ɔbuai kaɖe, ɔɖi bo sɔ boana isobuɛ. ");
INSERT INTO akp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ɔsu Ɖidze gɔ mba ɔle ɔtã bo gɔ lobɔrɛ i ɔ̃ ɔɖabo igara David ɔkparɛ ame. ");
INSERT INTO akp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ɔɣɛ ɔsɛ kokooko ɔkigu i ɔ̃ kanyamaɖidze sekelea iso sɔ ");
INSERT INTO akp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ɔ̃aɖi bo ɔbɔrɛgu i mma nto mabie bo ikpi gu bo matsirise ɔɖuɖu nrɔɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ɔɣɛ sɔ ɔ̃anyɔ bo nnya lɛ kumɛgɔ ɔɣere bo mawa ɔsɛ fiɛ ɔ̃anyigi kanya ga ɔnyi ku bo mawa. ");
INSERT INTO akp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ɔkã ndamu ɔtã bo ɔwa Abraham teteree sɔ, ");
INSERT INTO akp_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ɔ̃aɖi bo ɔbɔrɛgu i bo matsirise nrɔɔ̃ ame ɔtã bo bobara ɔ̃ karabara sɔ ifɔ̃ iisibakpɛ̃ bo. ");
INSERT INTO akp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ɔto ɔ̃asekelera bo fiɛ ɔ̃abara bo bɔlɔlɔ i ɔ̃ anɔ i bo agbanayi ɔɖuɖu ame. ");
INSERT INTO akp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Fiɛ fɔ, wũ ɔbi ne, maakpere-ɔ sɔ, Ɣaa Ɔlesate kanyaɖidze. Fɔ loaɖe Bosate katɔ̃ aledza ɔri atã ɔ̃ iba ne. ");
INSERT INTO akp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ato aaɖi ate maturi sɔ maana iɖi ala mato maana akpi isu itsɛ. ");
INSERT INTO akp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Bo Ɣaa sɛ ɔɣara so pɔkɔsɔɔ fiɛ ɔba nnyainyɔ. Ɔto ɔ̃asese bo Ɖidze gɔ loafiɛ ɔfere bo lɛ kuɣɛ̃. ");
INSERT INTO akp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ɔto ɔ̃atã ikpawaĩ nɛgbe ɔba itã maturi ma nsi i idududu ame fiɛ kukpi ifɔ̃ to ma sɔ ɔ̃akɔ bo ɔkigu i isobuɛ ɔri iso.” ");
INSERT INTO akp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Gɔ ɔbi ɔba ɔ̃are iti ne, ɔwe ɔle i Siwarã Bielea ame. Ɔwe i fafuĩ ame ngbegɔ i maturi na gbɔgbɔɔgbɔ ɔwi gɔ ɔ̃ɔledza so ɔtã sɔ ɔ̃abara ɔ̃ karabara i Israel. ");
INSERT INTO akp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ɔwi gɔmɔ ame ne, Roma Igarakpakpa Kaisaro Augusto ɔtã ɔle sɔ matsɛrɛ maturi ma ɔɖuɖu mpia i Roma Sigarakaɖekɔ̃ ame ayere. ");
INSERT INTO akp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Maturi ayere itsɛrɛ ɖeakatɔ̃ nɛgbe ame ne, abã ɔkpakpa gɔ marɔ sɔ Kirenio nto ɔɖe Siria karɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ne ɔso ɔbiara ɔkɛlɛ ɔ̃ aɖe sɔ ɔ̃atsɛrɛ iyere. ");
INSERT INTO akp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosef ana ɔbɔrɛ i Nasaret ɔmagɛ̃ ame i Galilea karɔ̃ iso ɔkɛlɛ Betlehem ɔmagɛ̃ ame i Yudea karɔ̃ iso ngbegɔ maɣe igara David. Yosef ɔkɛlɛ mmɔ alasɔ David ɔkparɛ ame ɔbɔrɛ. ");
INSERT INTO akp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ɔkɔ Maria gɔ makarɛ mata wũ fiɛ ka ɔto kayiri ana ɔsɛgu. ");
INSERT INTO akp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ɔwi gɔ mapia i Betlehem mmɔ ne, Maria ɔwi ɔɣo sɔ ka ɔ̃aɣe ɔbi. ");
INSERT INTO akp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ɔɣe ɔ̃ ɔbi ɖeakatɔ̃ gɔ nɖe ɔbirɛrɛĩ. Ɔmini wũ i ɔkati ame ɔsu wũ ɔrara i ira nɛ ame masɛ mafere mabɔi aɖera, alasɔ maina kabokɔ̃ i mafɔ kawekɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ɔwi gɔmɔ ame i karɔ̃ gamɔ iso ne, masɛrɛkɔdze mawɛ̃ pia mmɔ mato manyɔ masɛrɛ iso ku kasɛ̃. ");
INSERT INTO akp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ɣaa kpabo ɔwɛ̃ ɔɖi so ɔte ma fiɛ Bosate ifiɛ ɔfere ma ibɔrɛ i kato. Itã sɔ ifɔ̃ ɔmɔɛ̃ ma gbaã, ");
INSERT INTO akp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ɣɛɛ Ɣaa kpabo ɔɣere ma sɔ, “Midaanigã. Itɔ̃me sɛɛ nɛ loatã maturi ɔɖuɖu isoɣɔ losu lobɔ mi. ");
INSERT INTO akp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nɔme ikpɛnɛ nɛgbe iso ne, maɣe Ɖidze gɔ nɖe Bosate Kristo matã mi i igara David ɔmagɛ̃ ame. ");
INSERT INTO akp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nnɛ miasu minya wũ miɖi ite nɖe sɔ ne, mito mianya ɔbi ɣɛtɛ gɔ mamini i ɔkati ame fiɛ ɔrɛ i mabɔi ara kaɖekɔ̃.” ");
INSERT INTO akp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ɔluwɛ̃ ne, Ɣaa makpabo ikuri siare ɔbɔrɛ i kato maba mabuai kpabo gɔmɔ iso matsɛ Ɣaa ile sɔ, ");
INSERT INTO akp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ikpawaĩ nɖe Ɣaa ɔkpɛ i kato dzoroo, isobuɛ itã karɔ̃ iso maturi ɔɖuɖu ma i Ɣaa sɛ ɔɖɔɛ!” ");
INSERT INTO akp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Gɔ Ɣaa makpabo ɔrui makɛlɛ kato ne, masɛrɛkɔdze ɔɣere so sɔ, “Mitã bokɛlɛ Betlehem boanyɔ nnɛ loba fiɛ Bosate to ɔɖi ɔte bo ngbe.” ");
INSERT INTO akp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ne ɔso mapɛ siwa masɛ maanya Maria gu Yosef gu ɔbi ɣɛtɛ gɔ nrɛ i mabɔi aɖera kaɖekɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Gɔ manya wũ ngbɔ ne, maɣɛ ara wa i Ɣaa kpabo gɔmɔ ɔɣere ma i ɔbi iso. ");
INSERT INTO akp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mma ɔɖuɖu lonɔ ara wa i masɛrɛkɔdze ɔɣɛ ne, ibara ma ɣii. ");
INSERT INTO akp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ɣɛɛ Maria ɔmɔɛ̃ ara wagbe ɔɖuɖu ɔpia i ɔ̃ adzuni ame ɔla ɔ̃ɔbu wã iti ame. ");
INSERT INTO akp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Masɛrɛkɔdze ɔkpese makɛlɛ mato male Ɣaa makɔlɛ ɔ̃ iyere kato i ira nɛ manya gu nwa manɔ ɔso alasɔ iba ngbɔ tutuutu lɛ kumɛgɔ i Ɣaa kpabo ɔɣere ma. ");
INSERT INTO akp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Iyi farafanava gɔ maɖi ɔbi i iyo fiɛ matu wũ sirɛrɛ̃ ne, masia wũ iyere sɔ Yesu lɛ kumɛgɔ i Ɣaa kpabo gɔmɔ ɔɣɛ fiɛ mala ɔ̃ kayiri. ");
INSERT INTO akp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Gɔ ɔwi ɔɣo sɔ Yosef gu Maria aabara so sekelee i kubarara kanya lɛ kumɛgɔ i Mose mmara ɔte ne, makɔ ɔbi ɣɛtɛ ana makɛlɛgu Yerusalem sɔ maasu wũ mapia i Bosate nrɔɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Lɛ kumɛgɔ matsɛrɛ mapia i Ɣaa mmara ɔko ame sɔ, “Ɔbirɛrɛĩ ɖeakatɔ̃ biara gu bɔi rɛrɛ̃ ɖeakatɔ̃ biara ne, ikote sɔ maatɛ wũ masɛ i kuruɛ matã Bosate.” ");
INSERT INTO akp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Masɛ maafɛ̃ ara matã Ɣaa alasɔ mmara ɔkarɛ sɔ maasu abɔrɔnuma ɣee kukpaboi kunyɔ mafɛ̃ ara mata wũ. ");
INSERT INTO akp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ɔwi gɔmɔ ame ne, ɔrɛrɛ̃ gɔ marɔ Simeon ɔwe i Yerusalem. Ɔɖe ɔturi sɛɛ gɔ nsɛ ɔnigã Ɣaa fiɛ ɔto ɔnyɔ ɔri ɔtã Israel iɖi. Siwarã Bielea sɛgu wũ fiɛ ");
INSERT INTO akp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","sisia ita sitã wũ sɔ ɔ̃ibakpi gbɔgbɔɔgbɔ ɔnya maɣe Ɣaa Kristo gɔ maɣɛ masɛ kokooko. ");
INSERT INTO akp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ne ɔso Siwarã Bielea ɔkɔ Simeon sikɛlɛgu ma Yudase isɔrɛyo. Gɔ maɣese ɔsu Yesu biɛtɛ mabɔ sɔ maba maabara kubarara gɔ i Mose mmara ɔkarɛ sɔ mabara ne, ");
INSERT INTO akp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon ɔfɔ ɔbi ɔla i nrɔɔ̃ ame ɔle Ɣaa sɔ, ");
INSERT INTO akp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Kiniɔ ne Bosate, gɔ ɔɔbara nnɛ aɣɛ asɛ atã me ne, ka aawo fɔ ɔɖabo ɔri ɔɖi i isobuɛ ame. ");
INSERT INTO akp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Mme mɔmɔ ku wũ anɔ ne, loɔnya Ɖidze ");
INSERT INTO akp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","gɔ asese sɔ ɔba ɔ̃aɖi maturi ɔɖuɖu katɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ɔ̃ nɖe ikpawaĩ nɛ loaɖi fɔ kuɖɔɛ ite maturi ma loiɖe ma Yudase ne. Fiɛ ɔ̃aɖi fɔ ibu ɔte fɔ kaɖe Israel maturi.” ");
INSERT INTO akp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ara wa i Simeon ɔɣɛ i ɔbi iso ɔbara Yosef gu Maria ɣii. ");
INSERT INTO akp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ne Simeon ɔtã ma kusɛkusɛ ɔɣere ɔbi ɔnyi sɔ, “Ɣaa ɔɣɛ ɔsɛ i ɔbi gɔgbe iso sɔ, iaki i ɔ̃ iso ne, maturi gbodzoo aarɔ̃, fiɛ iaki i ɔ̃ iso ana ne, gbodzoo ana to maata maya i Israel. Maledza wũ iɖi sɔ ɔ̃aɖe ikparĩ nɛ iso i maturi aaɖe ika mata maya. ");
INSERT INTO akp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ɔto ɔ̃aɖi maturi adzuni wɛrɛa ɔbɔ i ɔgbami. Nnɛgbe ɔso ne, ibo gu ibɛbɛrɛ to iabo-ɔ i ɔtu ame lɛ ipɛmi matsue-ɔ awe.” ");
INSERT INTO akp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ɔrɔ̃go ɔwɛ̃ gɔ nɖe Ɣaa kanyaɖidze marɔ wũ sɔ Hana ɔwe i mmɔ. Ɔ̃ ɔse Fanuel ɔbɔrɛ i Aser kalɛ ame. Akɔ akɔdzɛ pɛ ɔsɛ i kurã iyo fiɛ ɔ̃ ɔrã ɔkpi. ");
INSERT INTO akp_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ɔ̃ɔsɛ sikuɛdze ɔfɔ akɔ fasinafasina-ina. Kasɛ̃ i kakɔme ne, ɔsɛ ɔwe i ma Yudase isɔrɛyo ɔle Ɣaa ɔnyi kanya ɔkparama kayi ana. ");
INSERT INTO akp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ɔwi gɔmɔ ame ne, ɔ̃ wũ ɔba isɔrɛyo ɔba ɔ̃apɛ Ɣaa siba. Ɔɖe ika i ɔbi gɔgbe iso ɔɣere maturi ma ɔɖuɖu nto manyɔ ɔri sɔ Ɣaa aaɖi Yerusalem. ");
INSERT INTO akp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Gɔ Yosef gu Maria ɔɔro kubarara lɛ kumɛgɔ i Ɣaa mmara ɔte ne, makpese makɛlɛ ma aɖe Nasaret i Galilea karɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ɔbi ɔmɔ ɔre iti fiɛ ɔwe isosarɛ gu iwola ana gbaã gɔ itã sɔ ɔbo Ɣaa anɔ. ");
INSERT INTO akp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ikɔ biara ne, Yesu maɣese sɛ masɛ Yerusalem maaɖe iyi nɛ masɛ marɔ sɔ Kukpi Ɔtakuwara Bo Iyi. ");
INSERT INTO akp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ne ɔso gɔ Yesu ɔfɔ akɔ aweo-anyɔ ne, masɛ Yerusalem lɛ kumɛgɔ masɛ mabara kokooko awe. ");
INSERT INTO akp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Gɔ maɖe iyi maro fiɛ makpese mato makɛlɛ ma aɖe ne, Yesu ɔkpese ɔwe i Yerusalem gɔ ɔ̃ maɣese iitsue. ");
INSERT INTO akp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mabu sɔ ɔpia i maturi ma nsɛ i ɔri ndɛ̃, ne ɔso masɛ ɔri ikpɛnɛ iwɛ̃ buu fiɛ matsɛ wũ ibie i ma malɛdze gu malaa ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Gɔ mainya wũ ɔso ne, makpese makɛlɛ Yerusalem masɛ mapia manyɔnyɔ wũ. ");
INSERT INTO akp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ikpɛnɛ tɛare iso ne, masɛ maanya wũ i ma Yudase isɔrɛyo gɔ ɔ̃ gu ma Yudase maratedze mawɛ̃ si. Ɔto ɔkã ma atsue ɔkarɛ ma atɔ̃me ɔnɔ. ");
INSERT INTO akp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mma ɔɖuɖu lonɔ ɔ̃ ara karɔ̃ iɖiɖi ne, ibara ma ɣii i ɔ̃ iwola wodoroa nɛ ɔto ɔtã ala atɔ̃me mmuai ɔso. ");
INSERT INTO akp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ibara ɔ̃ maɣese lɛ kurɛ gɔ manya wũ ngbɔ. Ne ɔ̃ ɔnyi ɔkarɛ wũ sɔ, “Ɔbi, be ɔso fiɛ abara bo ngbɔ? Bo gu fɔ ɔse ɔɔmararã so bowe bobie-ɔ.” ");
INSERT INTO akp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ne Yesu to ɔtã mmuai sɔ, “Be ɔso fiɛ mipia mibie me? Miiɣe sɔ ikote sɔ loawe i wũ ɔse iyo?” ");
INSERT INTO akp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ɣɛɛ mainɔ nnɛ ɔɣere ma karɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ne Yesu ka ɔta ɔsiai ma marui makɛlɛ Nasaret, ɔbɔ so karɔ̃ ɔtã ma. Ɣɛɛ ɔ̃ ɔnyi ne, ɔkɔla ara wagbe i ɔ̃ iti ame. ");
INSERT INTO akp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu ɔre iti i sosina gu iwola ame, ɔbo maturi gu Ɣaa ɔɖuɖu anɔ. ");
INSERT INTO akp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Igarakpakpa Kaisaro Tiberio ikɔ weoruva i iyara iso ne, Pontio Pilato loɖe abã ɔkpakpa i Yudea karɔ̃ iso. Galilea karɔ̃ iso ana ne, Herodes loɖe ɔkpakpa fiɛ ɔ̃ kpeama gɔ marɔ Filipo ɔɖe Iturea gu Trakoniti abuiti iso ɔkpakpa. Lisania ana ɔɖe Abilene ibuiti iso. ");
INSERT INTO akp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Hana gu Kayafa loɖe Ɣaa masɔrɛdze makpakpa pelepele. Ikɔ nɛmɔ ame ne, Yohanes gɔ nɖe Zakaria ɔbi ɔfɔ silɔ ɔbɔrɛgu i Ɣaa kɔrɛ i fafuĩ ame. ");
INSERT INTO akp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ne ɔso Yohanes ɔwe ɔki i Yordan sikpokpo gu abuiti ame ɔɖuɖu ɔto ɔɣɛ Ɣaa itɔ̃me sɔ, “Mifiniki mibɔrɛ i mi akpi ame si mifɔ Ɣaa itupie kubarara si Ɣaa aasu mi akpi ɔtsɛ mi.” ");
INSERT INTO akp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Lɛ matsɛrɛ mapia i Ɣaa Kanyaɖidze Yesaya ɔko ame sɔ, “Ɔwɛ̃ to ɔla kulu i fafuĩ ame sɔ, ‘Miledza Bosate ɔri misɛ. Mibara ɔ̃ siri tɔrɔrɔ. ");
INSERT INTO akp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Miyira kugbolomi ɔɖuɖu si mibiɛ abe gu kubemi ɔɖuɖu mibɔ karɔ̃. Mibara siri gɔgɔlɔa ɔɖuɖu tɔrɔrɔ. Si mitã sɔ siri woworea ɔɖuɖu iso aase sɔlɔsɔlɔ. ");
INSERT INTO akp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mmɔ i maturi ɔɖuɖu aanya Ɖidze gɔ i Ɣaa ɔsese ne!’ ” ");
INSERT INTO akp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Maturi gbodzoo ɔba sɔ Yohanes si ɔpie ma ndu ɣɛɛ Yohanes ɔɣere ma sɔ, “Mi ma lo nyanyarĩ lɛ maɣɛ! Nna loɣere mi sɔ miawo ɔtere ɔbɔrɛ i Ɣaa kutsue ikpadzɛ̃ nɛ ɔ̃abɔ i maturi lalaa iso ame? ");
INSERT INTO akp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mite i mi nsɛgbai ame sɔ miɔfiniki mibɔrɛ i mi akpi ame. Midaabu sɔ gɔ Abraham mawa miɖe ɔso ne, Ɣaa iibakpadzɛ̃ mi kutsue. Nto loɣere mi sɔ Ɣaa to ɔ̃awo mawa ɔbara ɔɖi i ata wa nfere i ngbe ame ɔtã Abraham. ");
INSERT INTO akp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Minyɔ! Maɔkarã kaɣɛ i adziri iso koko sɔ maatu wã ta siɖu ame. Kudziri biara gɔ loisɛ kuɣɔ̃ abi sɛɛ ne, maaɖaɛ kɔ̃ mapɛyu matsuedza.” ");
INSERT INTO akp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mmɔ mato makarɛ wũ sɔ, “Be si bobara kiniɔ?” ");
INSERT INTO akp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ne Yohanes to ɔɣere ma sɔ, “Ngɔ mba awu aka anyɔ ne, ɔsu awɛ̃ ɔtã ngɔ nna kuawɛ̃. Ngɔ mba araɖea si ɔɣɛ wã ɔtã mma nna.” ");
INSERT INTO akp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ma lampofɔdze mawɛ̃ ana ɔba sɔ ɔpie ma ndu. Makarɛ wũ sɔ, “Ratedze, be si bobara?” ");
INSERT INTO akp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ne ɔto ɔɣere ma sɔ, “Midaafɔ sikã i maturi kɔrɛ miɖo kumɛgɔ i mmara ɔkarɛ.” ");
INSERT INTO akp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Makpakpɛ̃dze mawɛ̃ ana ɔba maakarɛ wũ sɔ, “Bo ne, be si bobara?” Ma wũ ɔɣere ma sɔ, “Mitã mi kuso si kusi mi. Midaasu ɔle mifɔ kuwɛ̃ sikã i ɔri gɔ loikote iso. Midaaɖaɛ kuwɛ̃ ana kanya.” ");
INSERT INTO akp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Maturi ɔriinyɔ ɔtsɛ kato ikɔlɛ. Matsɛ ibu sɔ bɛrɛ Yohanes nɖe Kristo gɔ mato manyɔ ɔri. ");
INSERT INTO akp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ne ɔso Yohanes ɔɣere ma ɔɖuɖu sɔ, “Ndu losu loto lopie mi, Ɣɛɛ ngɔ nsiai me i kama ne, ɔmɔ ɔɖo me fafaafã. Loikote sɔ loabɔdzo lokurisi ɔ̃ ndokota kɔra. Ngɔgbe nto ɔ̃asu Siwarã Bielea gu ɔtɔ ɔpie mi ndu. ");
INSERT INTO akp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ɔto ɔ̃ ifɛra nɛ ɔ̃asu ɔfɛ simɔɣo ɔɖi i araɖea ame fiɛ ɔ̃asu kamɔ ɔfere i kawu ame. Ɔto ɔ̃atsuedza simɔɣo gu ɔtɔ gɔ loibanyi ɔnya!” ");
INSERT INTO akp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","I siri agbãagbã iso ne, Yohanes ɔɖiɖi Ɣaa itɔ̃me karɔ̃ ɔte maturi ku ɔle sɔ mafinikira ma nsɛgbai. ");
INSERT INTO akp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ɣɛɛ Yohanes ɔkidza abã ɔkpakpa Herodes ala Herodia gɔ nɖe ɔ̃ ɔnyiibi ɔre fiɛ ɔfɔ ɔyiri iti. Ɔkidza wũ ala ara nyanyarĩa mama wa ana ɔto ɔbara ɔso. ");
INSERT INTO akp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nnɛ i Herodes ɔbara i ne kama gɔ inyanyarĩ iɖo nɖe sɔ ɔtã mamɔɛ̃ Yohanes mapia i iyo. ");
INSERT INTO akp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Gɔ Yohanes ɔɔpie maturi ɔɖuɖu ndu ɔro ne, Yesu ɔ̃ wũ mapie wũ ndu. Gɔ ɔto ɔkparama kayi ne, kato ɔbusi. ");
INSERT INTO akp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ne Siwarã Bielea ɔso siba siasɛ wũ iso lɛ ilɔpɔ ne. Manɔ silɔ ɔbɔrɛ i kato sito siɣɛ sɔ, “Fɔ nɖe wũ ɔbi gɔ loipia kuɣɛ ne, abo me anɔ gbaã.” ");
INSERT INTO akp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu ɔfɔ lɛ akɔ sitɛ fiɛ ɔtsɛ ɔ̃ karabara. Maturi ne, ɔbu masɛ mabu sɔ ɔ̃ ɔse nɖe Yosef gɔ ɔse nɖe Eli ");
INSERT INTO akp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","gɔ ɔse nɖe Mattat gɔ ɔse nɖe Levi gɔ ɔse nɖe Melki gɔ ɔse nɖe Yona gɔ ɔse nɖe Yosef ");
INSERT INTO akp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","gɔ ɔse nɖe Matatia gɔ ɔse nɖe Amos gɔ ɔse nɖe Nahum gɔ ɔse nɖe Esli gɔ ɔse nɖe Nagae ");
INSERT INTO akp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","gɔ ɔse nɖe Mahat gɔ ɔse nɖe Matatia gɔ ɔse nɖe Semein gɔ ɔse nɖe Yosef gɔ ɔse nɖe Yuda ");
INSERT INTO akp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","gɔ ɔse nɖe Yohanan gɔ ɔse nɖe Resa gɔ ɔse nɖe Zerubabel gɔ ɔse nɖe Sealtiel gɔ ɔse nɖe Neri ");
INSERT INTO akp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","gɔ ɔse nɖe Melki gɔ ɔse nɖe Adi gɔ ɔse nɖe Kosam gɔ ɔse nɖe Elmadam gɔ ɔse nɖe Er ");
INSERT INTO akp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","gɔ ɔse nɖe Yosua gɔ ɔse nɖe Eliezer gɔ ɔse nɖe Yorim gɔ ɔse nɖe Matat gɔ ɔse nɖe Levi ");
INSERT INTO akp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","gɔ ɔse nɖe Simeon gɔ ɔse nɖe Yuda gɔ ɔse nɖe Yosef gɔ ɔse nɖe Yonam gɔ ɔse nɖe Eliakim ");
INSERT INTO akp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","gɔ ɔse nɖe Melea gɔ ɔse nɖe Mena gɔ ɔse nɖe Matata gɔ ɔse nɖe Natan gɔ ɔse nɖe David ");
INSERT INTO akp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","gɔ ɔse nɖe Isai gɔ ɔse nɖe Obed gɔ ɔse nɖe Boaz gɔ ɔse nɖe Salmon gɔ ɔse nɖe Naheson ");
INSERT INTO akp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","gɔ ɔse nɖe Aminadab gɔ ɔse nɖe Admin gɔ ɔse nɖe Arni gɔ ɔse nɖe Ezron gɔ ɔse nɖe Perez gɔ ɔse nɖe Yuda ");
INSERT INTO akp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","gɔ ɔse nɖe Yakob gɔ ɔse nɖe Isak gɔ ɔse nɖe Abraham gɔ ɔse nɖe Tara gɔ ɔse nɖe Nahor ");
INSERT INTO akp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","gɔ ɔse nɖe Seruk gɔ ɔse nɖe Regu gɔ ɔse nɖe Peleg gɔ ɔse nɖe Eber gɔ ɔse nɖe Sala ");
INSERT INTO akp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","gɔ ɔse nɖe Kainan gɔ ɔse nɖe Arfaksad gɔ ɔse nɖe Sem gɔ ɔse nɖe Noa gɔ ɔse nɖe Lamek ");
INSERT INTO akp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","gɔ ɔse nɖe Metusala gɔ ɔse nɖe Henok gɔ ɔse nɖe Yared gɔ ɔse nɖe Mahalaleel gɔ ɔse nɖe Kainan ");
INSERT INTO akp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","gɔ ɔse nɖe Enok gɔ ɔse nɖe Set gɔ ɔse nɖe Adam gɔ ɔse nɖe Ɣaa. ");
INSERT INTO akp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Gɔ Yesu ɔbɔrɛ i Yordan ɔwore ame ne, Siwarã Bielea ɔyi i ɔ̃ ame, ne si kɔ wũ sikɛlɛgu fafuĩ ame ne. ");
INSERT INTO akp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mmɔ i Ɔbosam ɔla wũ ɔnyɔ akpɛnɛ sina buu ne. Ɔwi gɔgbe ame ɔɖuɖu ne, Yesu iiɖe kuira ne ɔso kukã ɔkpɛ̃ wũ i kawirikɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ɔbosam ɔɣere wũ sɔ, “Si fɔ nɖe Ɣaa Ɔbi ne, ɣere ita nɛgbe sɔ ikpese aɖera.” ");
INSERT INTO akp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ɣɛɛ Yesu ɔɣere wũ sɔ, “Matsɛrɛ mapia i Ɔko Sekelea ame sɔ, ‘Iiɖe aɖera ɔnɔwɛ̃ iso i ɔturi aasɛ ngbã.’ ” ");
INSERT INTO akp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ne kama ne, Ɔbosam ɔledza wũ ikɔ ikɛlɛgu kakɔi kɔlɛa kawɛ̃. Ɔte wũ kayiiso Sigarakuɖekɔ̃ ɔɖuɖu i ɔwi kurukutu ame. ");
INSERT INTO akp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ne ɔɣere wũ sɔ, “Loasu kayiiso ɔle gɔgbe ɔɖuɖu gu kã karana lotã-ɔ alasɔ mme masu matã fiɛ loawo ɔsu ɔtã ngɔ loɖɔɛ. ");
INSERT INTO akp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nwagbe ɔɖuɖu to aakpese fɔ are si abɔ iti karɔ̃ atã me.” ");
INSERT INTO akp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Mmɔ i Yesu to ɔɣere wũ sɔ, “Matsɛrɛ i Ɔko Sekelea ame sɔ ne, ‘Bosate Ɣaa ɔnɔwɛ̃ nɖe ngɔ lokote sɔ maapɛ agɛgɛ̃ matã, masɔrɛ.’ ” ");
INSERT INTO akp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ne kama ne, Ɔbosam ɔledza Yesu ikɔ ikɛlɛgu Yerusalem ma Yudase isɔrɛyo itititɛ̃ pelepele. Ne ɔɣere wũ sɔ, “Si Ɣaa ɔbi aɖe ne, nyua so sɛ aawuĩ i karɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Alasɔ matsɛrɛ i Ɔko Sekelea ame sɔ, ‘Ɣaa to ɔ̃atã sɔ ɔ̃ makpabo aaya madzuɛ̃-ɔ kukaakɔ.’ ");
INSERT INTO akp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","‘Mamɔɛ̃-ɔ i nrɔɔ̃ ame sɔ aibasu fɔ kukpa awuĩ i ita kuiwɛ̃ iso.’ ” ");
INSERT INTO akp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ɣɛɛ Yesu ɔɣere wũ sɔ, “Ɔko Sekelea ɔɣɛ sɔ, ‘Daala Bosate Ɣaa anyɔ.’ ” ");
INSERT INTO akp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Gɔ Ɔbosam ɔro Yesu ɔla ɔnyɔ ne, ɔrui ɔnyua wũ ɔwi kɛkɛĩ. ");
INSERT INTO akp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu ɔyi ku Siwarã Bielea ɔle fiɛ ɔkpese ɔba Galilea. Ɔ̃ iyere ɔre i abuiti wamɔ ɔɖuɖu ame. ");
INSERT INTO akp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ɔte ara i ma Yudase kasarɛkɔ̃ fiɛ ɔbiara ɔle ɔ̃ ara ite. ");
INSERT INTO akp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nnɛgbe kama ne, Yesu ɔkɛlɛ Nasaret ngbegɔ makararã wũ ita i ɔ̃ sibiɛtɛ ame. Ma Yudase Iwarãyi iso ne, ɔkɛlɛ ma Kasarɛkɔ̃ lɛ kumɛgɔ ɔsɛ ɔɖɔɛ ɔbara. Ne ɔta ɔya sɔ ɔ̃aka Ɔko Sekelea ne. ");
INSERT INTO akp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Masu Ɣaa Kanyaɖidze Yesaya ɔko matã wũ. Gɔ ɔbusi ɔko ne, ɔtsɛ ika i ngbegɔ matsɛrɛ sɔ, ");
INSERT INTO akp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Siwarã Bielea si me iso alasɔ Ɣaa ɔsɔla me nnɔĩ sɔ loasu ɔ̃ Itɔ̃me Bielea lokɛlɛgu mawɛrɛba. Ɔpia me sɔ losɛ loaɣere mayorɛdze sɔ maana iwarã. Mma anɔ lobiɛ ma wũ mato maanya ara. Mma mpia i inyɛwe ame ne, ma wũ maana isobuɛ. ");
INSERT INTO akp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Si lotã matsue sɔ Ɣaa ɔwi gɔ ɔ̃aɖi ɔ̃ mare ɔɔɣo.” ");
INSERT INTO akp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ne Yesu ɔkarĩ ɔko ɔsu ɔtã ngɔ nto ɔnyɔ kasarɛkɔ̃ iso fiɛ ɔrui ɔsɛ i karɔ̃ ne. Maturi ɔɖuɖu ma i kasarɛkɔ̃ mmɔ ɔɖi anɔ mafere wũ iso tuee. ");
INSERT INTO akp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ne Yesu to ɔɣere ma sɔ, “Ɔko Sekelea ame ara wa minɔ loka ngbe ne, nɔme kaɖe gagbe iba i ne ame.” ");
INSERT INTO akp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ɔ̃ atɔ̃me wa ɔɣɛ gu kumɛgɔ i ɔ̃ ɔnyagɛmi to ɔta ɔbara mma nto makã wũ atsue ɣii. Makarɛ sɔ, “Iiɖe Yosef ɔbi ɔɖe ngbe?” ");
INSERT INTO akp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Mmɔ i Yesu to ɔɣere ma sɔ, “Loɣe sɔ mito miapɛ me igbã nɛgbe sa sɔ, ‘Wase, sa so fɔ mɔmɔ.’ Fiɛ loɣe sɔ mito miaɣere me ana sɔ, ‘Ara wa bonɔ sɔ ato abara i Kapernaum ne, bara wã i fɔ aɖe ngbe ana.’ ” ");
INSERT INTO akp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ne Yesu to ɔɣere ma sɔ, “Lobie sɔ loɣere mi gbaã sɔ ne, Ɣaa kanyaɖidze kuwɛ̃ na kuwarɛ i ɔ̃ mɔmɔ aɖe. ");
INSERT INTO akp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Gbaã iɖe sɔ makuɛdze gbodzoo ɔwe i Israel karɔ̃ iso ku ɔwi gɔ i Ɣaa kanyaɖidze Eliya ɔwe fiɛ kado iipɛ akɔ atɛ gu awa akuɔ. Kukã ɔbo i karɔ̃ ɔɖuɖu iso. ");
INSERT INTO akp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ɣɛɛ ne, Ɣaa iipia Eliya sɔ ɔsɛ ɔ̃abuai Israel kuɛdze kuwɛ̃ iɖo kuɛdze gɔ i Zerepta ɔmagɛ̃ ame i Sidon karɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ana ne, ɔnyɛ rɛtɛa manyɛse gbodzoo ɔwe i Israel ku ɔwi gɔ i Ɣaa kanyaɖidze Elisa ɔwe. Ɣɛɛ ma kuwɛ̃ iina isosarɛ iɖo Naeman gɔ lobɔrɛ i Siria karɔ̃ iso ɔnɔwɛ̃.” ");
INSERT INTO akp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Gɔ mma mpia i kasarɛkɔ̃ mmɔ ɔnɔ ara wagbe ne, sikpã ɔmɔɛ̃ ma gbaã. ");
INSERT INTO akp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mata mali Yesu maɖi i ɔmagɛ̃ ame makɛlɛgu kuwaruɛ i kabemi ga iso matsue ɔmagɛ̃ masia kutsueti ku adzuni sɔ maali wũ makpasera si ɔkpi. ");
INSERT INTO akp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ɣɛɛ Yesu ɔki i ma ndɛ̃ ɔfe ɔrui ɔɣɛ ma. ");
INSERT INTO akp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nnɛmɔ kama ne, Yesu ɔrui ɔkɛlɛ Kapernaum ɔmagɛ̃ ame i Galilea karɔ̃ iso. Mmɔ ɔte maturi ara ku Iwarãyi iso ne. ");
INSERT INTO akp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ɔ̃ ara ite ɔbara ma ɔɖuɖu ɣii ala ɔte wã ku ɔle. ");
INSERT INTO akp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","I ma Yudase kasarɛkɔ̃ mmɔ ne, ɔrɛrɛ̃ ɔwɛ̃ ɔwe gɔ siwarã lalaa si wũ iso. Ɔsiagu kulu titiiti sɔ, ");
INSERT INTO akp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ao! Be aba abara i bo kɔrɛ ngbe Yesu Nasaretse? Ɔba ɔɔba sɔ aba aawɔra bo? Nɣe ɔturi gɔ aɖe! Fɔ nɖe Ɣaa Ɔturi Sekelea ne!” ");
INSERT INTO akp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mmɔ i Yesu ɔsa siwarã dzɛmɔ sɔ, “Lo kutsuɛ! Bɔrɛ i ɔ̃ ame fe!” Siwarã ɔnyɛdɛ̃ ɔrɛrɛ̃ gɔgbe, sipuri wũ siwuĩ i karɔ̃ i ma katɔ̃ fiɛ sibɔrɛ i ɔ̃ ame. Ɣɛɛ ɔ̃ire igbɛ kuiwɛ̃. ");
INSERT INTO akp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ibara maturi ɔɖuɖu ɣii ne mato makarɛ so sɔ, “Mme itɔ̃me igbã iɖe i ngbe? Ɔrɛrɛ̃ gɔgbe ba ɔle ɔto ɔtɔ̃me ɔpia siwarã lalaa i maturi ame fiɛ sito sibɔrɛ ana.” ");
INSERT INTO akp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ne ɔso Yesu iso itɔ̃me ɔkã mmɔ abuiti ɔɖuɖu ame. ");
INSERT INTO akp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Gɔ Yesu ɔbɔrɛ i ma Yudase kasarɛkɔ̃ mmɔ ne, ɔkɛlɛ Simon iyo. Ɔ̃ masɔrɔ̃go rɛ ɔto ɔnyɛ, ɔbe ɔtɔ ne ɔso matã Yesu itsue. ");
INSERT INTO akp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Gɔ ɔsɛ ɔ̃aya i ɔ̃ kɔrɛ i ngbegɔ ɔrɛ ne, ɔsa ɔnyɛ siwarã ɔɖi i ɔ̃ ame. Ɔluwɛ̃ ɔsarɛ ɔta ɔwa aɖera ɔtã ma. ");
INSERT INTO akp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ito ikɛlɛ iɣɛ̃kɛlɛ ne, maturi ɔkɔ ma manyii ma nto manyɛ sinyɛ agbãagbã mabɔ Yesu. Ɔsu nrɔɔ̃ ɔɔsia ma iso ɔwɛ̃ ɔwɛ̃ ɔsa ma ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Siwarã lalaa agbãagbã ana ɔbɔrɛ i maturi ame sito kulu sɔ, “Fɔ nɖe Ɣaa ɔbi ne!” Ɣɛɛ Yesu ɔsɛ̃ ɔtã sɛ̃ ɔ̃itã siɖe ika, alasɔ siɣe sɔ ɔ̃ nɖe Kristo. ");
INSERT INTO akp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Gɔ kaɖe ɔsɛ̃ ne, Yesu ɔbɔrɛ i ɔmagɛ̃ ame ɔkɛlɛ kawɛrɛkɔ̃, ne ɔso maturi ɔtsɛ wũ inyɔnyɔ. Gɔ manya wũ ne, maibie sɔ ɔkpese ɔrui i ma kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ɣɛɛ ɔɣere ma sɔ, “Ikote sɔ loaɣɛ Ɣaa sigarakaɖekɔ̃ itɔ̃me nɛgbe i simagɛ̃ tsɔra ame alasɔ ngbɔ i Ɣaa ɔpia me sɔ lobara ne.” ");
INSERT INTO akp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ne ɔso ɔɣɛ Itɔ̃me Bielea i ma Yudase kusarɛkɔ̃ i karɔ̃ ɔɖuɖu iso. ");
INSERT INTO akp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Iyi iwɛ̃ ne, Yesu ɣɛ i Genezaret ɔpo kanya ɔto ɔɣɛ Ɣaa itɔ̃me. Maturi to malili so sɔ maabore mabo wũ manɔ itɔ̃me nɛ ɔto ɔɣɛ. ");
INSERT INTO akp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ɔnya sɔ sikolo inyɔ ɣɛ i ɔpo kanya mmɔ gɔ akpɛ maɖidze ɔɔso mabɔrɛ mato mafore ma asabu. ");
INSERT INTO akp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ne Yesu ɔya ɔbo i ɔkolo ɔwɛ̃ gɔ nɖe Simon ɔre ame ɔɣere wũ sɔ ɔli ɔ̃asia i ndu iso kɛkɛĩ. Ne ka ɔsɛ i ɔkolo ame ɔte ara ne. ");
INSERT INTO akp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Gɔ ɔte ma ara ɔro ne, Yesu ɔɣere Simon sɔ, “Miwa ɔkolo mikɛlɛgu ngbegɔ ndu ɔwodoro kɛkɛĩ si minabarã mi asabu miɖi akpɛ.” ");
INSERT INTO akp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ne Simon ɔtã wũ mmuai sɔ, “Bokɔse, kasɛ̃ ɔɖuɖu bobara karabara ku anɔ rɛtɛa boiɖi kuira. Ɣɛɛ ne, lɛ kumɛgɔ aɣɛ ɔso ne, loatã boapia asabu.” ");
INSERT INTO akp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Gɔ mapia asabu ne, mamɔɛ̃ akpɛ asi gɔ ma asabu ɔtsɛ ikɛkɛ. ");
INSERT INTO akp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ne ɔso ne, makpere ma malaa i ɔkolo nyɔare ame sɔ maba maabuai ma. Maɖi akpɛ mafere i sikolo sɛ̃ inyɔ ame ayi gbegbeegbe gɔ ikuti kɛkɛĩ fiɛ sikolo aatsɛ ndu iwã. ");
INSERT INTO akp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Gɔ Simon Petro ɔnya nnɛ loba ne, ɔpɛ agɛgɛ̃ i Yesu katɔ̃ ɔɣere wũ sɔ, “Bosate, re me kama alasɔ kpibaradze loɖe.” ");
INSERT INTO akp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Akpɛ gbodzoo wa maɖi ngbe ɔtã sɔ ibara ma ɣii. ");
INSERT INTO akp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ngbɔ ame ibara Simon malaa Yakobo gu Yohanes ma nɖe Zebedeo mabi ana ɣii ne. Mmɔ i Yesu ɔɣere Simon sɔ, “Daanigã. Ita i kiniɔ ne, maturi ka aaɖi atã Ɣaa.” ");
INSERT INTO akp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ne kama ne, gɔ makpadzɛ̃ sikolo mabɔ i ɔkpokpo ne, manyua ira biara masɛ marui masiai Yesu. ");
INSERT INTO akp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ɔwi ɔwɛ̃ ne, Yesu ɔsɛ ɔmagɛ̃ gɔ ame i ɔrɛrɛ̃ ɔwɛ̃ gɔ nto ɔnyɛ ɔnyɛrɛtɛa pia. Gɔ ɔnya Yesu ne, ɔpɛ agɛgɛ̃ i ɔ̃ katɔ̃ ɔtã wũ iti sɔ, “Bosate, si aɖɔɛ ne, aawo me ɔsa lose sekelee.” ");
INSERT INTO akp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu ɔɖi kɔrɔ̃ ɔpɛgu wũ, ne ɔɣere ɔrɛrɛ̃ sɔ, “Loɖɔɛ, se sekelee.” Ɔluwɛ̃ ne, ɔna isosarɛ. ");
INSERT INTO akp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu ɔsɛ̃ ɔtã wũ sɔ, “Daaɣere kuwɛ̃ nnɛ loba. Ɣɛɛ kɛlɛ aasu so te Ɣaa sɔrɛdze si atã ara wa i Mose mmara ɔkarɛ si ite ɔbiara sɔ ɔɔsarɛ.” ");
INSERT INTO akp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ɣɛɛ Yesu iso itɔ̃me ɔki ikã i kakɔi biara ibua. Maturi gbodzoo ɔba maakã ɔ̃ ara ite atsue fiɛ ɔsa ma. ");
INSERT INTO akp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ɣɛɛ ɔsɛ ɔrui ɔkɛlɛ kawɛrɛkɔ̃ ngbegɔ i kuwɛ̃ na ɔsɛ ɔ̃akparama kayi. ");
INSERT INTO akp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Iyi iwɛ̃ gɔ Yesu to ɔte ara ne, ma Yudase ikuri nɛ marɔ sɔ ma Farisise gu Mose mmara matedze mawɛ̃ ɔbɔrɛ i Galilea simagɛ̃ ɔɖuɖu gu Yudea karɔ̃ iso gu Yerusalem maba masi i mmɔ. Ɣaa ɔle gɔ i Yesu to ɔsa ala sinyɛ ana pia i ɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Marɛrɛ̃ mawɛ̃ ɔsore ɔrɛrɛ̃ gɔ lofɛfɛ̃ ɔrɛ i ɔkala iso mabɔ wũ. Mabie ɔri gɔ iso maaki fiɛ maabogu wũ i iyo ame i Yesu katɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ɣɛɛ kumɛgɔ i maturi ɔsi ɔso ne, maiɣe ɔri gɔ iso maaki. Ne ɔso masore wũ maya isã. Gɔ makpa isã ne, masora wũ ku ɔkala gɔ iso ɔrɛ masɛ i Yesu katɔ̃ i iyo nɛ ame mapia. ");
INSERT INTO akp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Gɔ Yesu ɔnya ma kafɔkaɖe ne, ɔɣere ɔrɛrɛ̃ gɔmɔ sɔ, “Wũ ɔnyii, losu fɔ akpi lotsɛ-ɔ!” ");
INSERT INTO akp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ne ma Farisise gu mmara matedze ɔbu i ma situ ame sɔ, “Be ɔso i ɔrɛrɛ̃ gɔgbe to ɔɣɛ amusuora ngbɔ? Ɣaa ɔnɔwɛ̃ pɛ loawo ɔturi akpi ɔsu ɔtsɛ wũ!” ");
INSERT INTO akp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Gɔ Yesu ɔtsue ma adzuni ne, ɔkarɛ ma sɔ, “Be ɔso fiɛ mito misusu ara wagbe igbã i mi situ ame? ");
INSERT INTO akp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Be iɣɛ nse pɔkɔsɔɔ iɖo, ‘Losu fɔ akpi lotsɛ-ɔ’ ɛɛbɛrɛ ‘Ta ya si asɛ’? ");
INSERT INTO akp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Loaɖi lote mi sɔ mme, Ɔturi Awune Ɔbi, ba ɔle i kayi gagbe iso sɔ loasu akpi lotsɛ.” Ne ɔso ɔfiniki ɔɣere ngɔ lokpi kasɛkasɛ sɔ, “Nto loɣere-ɔ sɔ ta ya si asu fɔ ɔkala si akɛlɛ iyo!” ");
INSERT INTO akp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ɔluwɛ̃ i ma ɔɖuɖu anɔmi ame ne, ɔta ɔya ɔsu ɔ̃ ɔkala gɔ iso ɔrɛ ɔrui ɔɣo iyo ɔri ɔto ɔle Ɣaa. ");
INSERT INTO akp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ibara maturi ɔɖuɖu ɣii. Kumɛgɔ ifɔ̃ ɔmɔɛ̃ ma ɔso ne, matsɛ Ɣaa ile ikarɛ so sɔ, “Mme awawãra boto bonya i ngbe nɔme?” ");
INSERT INTO akp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nnɛmɔ kama gɔ Yesu ɔbɔrɛ i mmɔ ne, ɔnya lampofɔdze ɔwɛ̃ gɔ marɔ Levi gɔ ɔsi i ɔ̃ karabara ame. Ne Yesu ɔɣere wũ sɔ, “Ta siai me.” ");
INSERT INTO akp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi ɔta ɔsiai wũ ɔnyua ira biara ɔsɛ. ");
INSERT INTO akp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levi ɔtã mawa aɖera ɔtu ɔpɔrɔ̃ siare i ɔ̃ iyo ɔtã Yesu. Maturi gbodzoo gu ma lampofɔdze ana pia i mma ɔkpere ɔbɔ mmɔ ame. ");
INSERT INTO akp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ma Farisise gu mmara matedze ma mpia i mmɔ ɔtsɛ kawararã ku Yesu masiaidze sɔ, “Be ɔso mito miɖe minɛ ku lampo mafɔdze gu makpibaradze?” ");
INSERT INTO akp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ne Yesu to ɔtã ma mmuai sɔ, “Mma nsarɛ iisɛ mabie kuwabaradze, manyɛse nsɛ mabie. ");
INSERT INTO akp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Iiɖe maturi ma nse bɔlɔlɔ loba lokpere sɔ mafiniki ɣɛɛ makpibaradze.” ");
INSERT INTO akp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Maturi mawɛ̃ ɔkarɛ Yesu sɔ, “Be ɔso fiɛ Yohanes masiaidze sɛ manyi kanya makparama kayi, ma Farisise masiaidze ma wũ ngbɔ ame ne, ɣɛɛ fɔ mare ma ne, ɔɖe gu ɔnɛ ko mato?” ");
INSERT INTO akp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ne Yesu ɔtã ma mmuai sɔ, “Mifɔ miɖe sɔ ɔrɔ̃go kɔdze malaa aasɛ kukã gɔ ɔrɔ̃go kɔdze pia i ma kɔrɛ? Ooɣo! Iibakote ngbɔ! ");
INSERT INTO akp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ɣɛɛ ne, iyi iwɛ̃ to iba gɔ maakɔ ɔrɔ̃go kɔdze maruigu i ma kɔrɛ. Mmɔ ne, iisiɖe kuwɛ̃ loaɣere ma sɔ manyi kanya.” ");
INSERT INTO akp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nnɛgbe kama ne, Yesu ɔledza ma igbã ipɛ sɔ, “Kuwɛ̃ iisɛ ɔkɛ ɔkati ɣɛtɛ kasɛi ɔta ɔkuere iyoi. Si ɔbara ngbɔ ne, iibakote, ɔ̃ɔkɛ ɔkati ɣɛtɛ siefe. ");
INSERT INTO akp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ngbɔ ame maisɛ masu ndã ɣɛtɛ mafere i bɔi ɔko akpo kuere ame ne. Si iba ngbɔ ne, ndã ɣɛtɛ to miafu mitã sɔ akpo kuere aabiɛ itã ndã ɔwiri. ");
INSERT INTO akp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ɣɛɛ ndã ɣɛtɛ ne, sikomi akpo ɣɛtɛ ame masɛ mafere me. ");
INSERT INTO akp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ngbɔ ame ana si ɔturi ɔɔnɛ ndã kuere ka ɔto ɔrɛ̃ ne, ɔ̃isisɛ ɔbie miɣɛtɛ. Ɔsɛ ɔɣɛ sɔ, ‘Mikuere lɛ miɖo miɣɛtɛ!’ ” ");
INSERT INTO akp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Iwarãyi iwɛ̃ gɔ Yesu sɛ ɔto ɔfe i kakpɛkɔ̃ kawɛ̃ ame gu ɔ̃ marasuãdze ne, marasuãdze ɔtsɛ atita ibɛbɛse iɣɛrɛ iwe. ");
INSERT INTO akp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mmɔ i ma Farisise mawɛ̃ to makarɛ ma sɔ, “Be ɔso mito mibara nnɛ i mmara iitã ɔri sɔ maabara ku Iwarãyi?” ");
INSERT INTO akp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ne Yesu ɔtã ma mmuai sɔ, “Miika i Ɔko Sekelea ame nnɛ i David ɔbara ɔwi gɔ i kukã ɔkpɛ̃ wũ gu ɔ̃ maturi? ");
INSERT INTO akp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ɔbo i Ɣaa iyo ame ɔsɛ ɔ̃asu aɖera wa masu masɔrɛ Ɣaa ɔɖe ɔkuti ɔtã ɔ̃ masiaidze ɔɖe gɔ mmara iitã ɔri iɖo Ɣaa masɔrɛdze ɔnɔwɛ̃.” ");
INSERT INTO akp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kawirikɔ̃ ne, Yesu ɔɣere ma sɔ, “Ɔturi Awune Ɔbi nɖe Iwarãyi Sate.” ");
INSERT INTO akp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Iwarãyi mama ne, Yesu ɔsɛ ma Yudase kasarɛkɔ̃ ɔsɛ ɔ̃ate ara. Ɔrɛrɛ̃ ɔwɛ̃ gɔ kuɖearɔ̃ lokarĩ ɔwe i mmɔ. ");
INSERT INTO akp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ne gɔ mmara matedze gu ma Farisise mawɛ̃ to mabie ɔri gɔ iso maaki fiɛ maaɖaɛ Yesu kanya sɔ ɔɣɛrɛ ma mmara ɔso ne, makarã anɔ sɔ maanya si ɔ̃asa sinyɛ i Iwarãyi iso. ");
INSERT INTO akp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ɣɛɛ gɔ Yesu ɣe ma adzuni ɔso ne, ɔɣere ɔrɛrɛ̃ gɔ kɔrɔ̃ lokarĩ sɔ ɔta ɔya i ma katɔ̃. Ne ɔrɛrɛ̃ gɔmɔ ɔta ɔba ɔ̃aya i katɔ̃ ne. ");
INSERT INTO akp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ne Yesu to ɔkarɛ ma sɔ, “Be i mmara ɔte? Sɔ ɔturi aabara isɛɛ ɛɛbɛrɛ ilalaa ku Iwarãyi? Ilɛ sɔ aabuai ɔturi ɛɛbɛrɛ aanina ɔ̃ ngbã?” ");
INSERT INTO akp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesu ɔla anɔ i ma ɔɖuɖu iso ɔɣere ɔrɛrɛ̃ gɔmɔ sɔ, “Nabarã fɔ kɔrɔ̃.” Ɔnabarã kɔ̃, ɔluwɛ̃ ne, kɔrɔ̃ ko lolɛ wũ. ");
INSERT INTO akp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Sikpã ɔmɔɛ̃ ma ɔɖuɖu ne ɔso matsɛ adzuni imɔɛ̃ i nnɛ maabara Yesu iso. ");
INSERT INTO akp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ɔwi gɔmɔ ame ne, Yesu ɔkɛlɛ kabemi kawɛ̃ iso ɔsɛ ɔ̃akparama kayi kasɛ̃ ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Gɔ kaɖe ɔsɛ̃ ne, ɔkpere ɔ̃ marasuãdze ɔsirakanya i ɔ̃ kɔrɛ, ne ɔɖi ma iweo-inyɔ ɔtã ma iyere sɔ ɔ̃ katɔ̃memasɛdze ne. ");
INSERT INTO akp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ma nɖe Simon gɔ ɔtã iyere sɔ Petro gu ɔ̃ ɔnyiibi Andrea gu Yakobo gu Yohanes gu Filipo gu Bartolomeo ");
INSERT INTO akp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","gu Mateo gu Toma gu Alfeo ɔbi Yakobo gu Simon gɔ masɛ marɔ sɔ, “Ɔturi gɔ lokpɛ̃ i ɔ̃ kaɖe iti,” ");
INSERT INTO akp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","gu Yakobo ɔbi Yuda gu Yuda Iskariot gɔ lokpese ngɔ loaɖi wũ ɔtã. ");
INSERT INTO akp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ɔwi gɔ i Yesu gu ɔ̃ katɔ̃memasɛdze ɔso i kabemi gamɔ iso maba ne, maba maya i katɛfɛkɔ̃ kawɛ̃. Ɔ̃ masiaidze gbodzoo gu maturi ikuri titiiti nɛ lobɔrɛ i Yudea karɔ̃ ɔɖuɖu iso gu Yerusalem gu simagɛ̃ dzɛ mpia i ɔpo kuruɛ Tiro gu Sidon ɔba maasakanya. ");
INSERT INTO akp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Maba sɔ maanɔ ara wa i Yesu to ɔte fiɛ ɔ̃asa ma sinyɛ agbãagbã dzɛ mato manyɛ. Mma ana i siwarã lalaa to siɖaa ɔba fiɛ ɔsa ma. ");
INSERT INTO akp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ɔbiara to ɔbie sɔ ɔ̃apɛgu wũ alasɔ ɔle to ɔbɔrɛ i ɔ̃ ame ɔsa ma ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu ɔnyɔ ɔ̃ masiaidze i katɔ̃ ne ɔɣere ma sɔ, “So si siɣɔ mi mawɛrɛba alasɔ mi ɔkpɛ nɖe Ɣaa sigarakaɖekɔ̃! ");
INSERT INTO akp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","So si siɣɔ mi ma i kukã to kiniɔ, alasɔ mito miami! So si siɣɔ mi ma nto mibiɛ kiniɔ, alasɔ mito miama! ");
INSERT INTO akp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","So si siɣɔ mi si maturi ɔtsiri mi fiɛ masɛ̃ mi fiɛ mato matia mi, maɣɛ mi iso ara lalaa ala mme, Ɔturi Awune Ɔbi, iti! ");
INSERT INTO akp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Mina isoɣɔ si nwagbe ɔɖuɖu ɔba ngbɔ, mitɔ i isoɣɔ ame alasɔ Ɣaa to ɔ̃atã mi kuso siare i kato. Alasɔ ara wagbe igbã i ma mawa ɔbara Ɣaa Kanyamaɖidze ne. ");
INSERT INTO akp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ɣɛɛ ndzo miɖe mitã mi maranase alasɔ miɔna mi ɔkpɛ i ngbã mɛgbe ame! ");
INSERT INTO akp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ndzo miɖe mitã mi ma lomi kiniɔ, alasɔ Kukã to kuakpɛ̃ mi Ndzo miɖe mitã mi ma nto mima kiniɔ, alasɔ mito miamararã so mibiɛ nnɔmɛ! ");
INSERT INTO akp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Ndzo miɖe mitã mi ma i maturi ɔɖuɖu sɛ male kiniɔ. alasɔ ngbɔ ame i ma mawa ɔla maɔle maladze ma nsɛ maɣɛ sɔ Ɣaa kanyamaɖidze maɖe ne. ");
INSERT INTO akp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ɣɛɛ mi ma nto minɔ me ne, nto loɣere mi sɔ miɖɔɛ mi matsirise si mibara isɛɛ mitã ma. ");
INSERT INTO akp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mma nsɛ magbarĩ mi ne, mitã ma kusɛkusɛ. Mma ana nto mabara mi ɔtile ne, mikparama kayi i ma iti. ");
INSERT INTO akp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Si ɔrere ɔpɛ-ɔ ɔrɔ̃ta i kutsueti kuwɛ̃ ne, finikira kunyɔare tã wũ. Si ɔrere ɔmɔɛ̃ fɔ kato awu wa apia ɔbɛ-ɔ iso ne, ɖi nwa apia asɛ karɔ̃ ana tã wũ. ");
INSERT INTO akp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ɔturi biara gɔ loakarɛ mi ira ne, mitã wũ. Si ɔrere ɔmɔɛ̃ nnɛ nɖe fɔ ire ɔsu ne, daati wũ kama sɔ aakpese afɔ. ");
INSERT INTO akp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kumɛgɔ abie sɔ mabara matã-ɔ ne, fɔ wũ bara ngbɔ tã maturi mama. ");
INSERT INTO akp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Si maturi ma nsɛ maɖɔɛ-ɔ ɔnɔwɛ̃ asɛ aɖɔɛ ne, be ɔso fiɛ maale-ɔ? Akpi mabaradze ma wũ masɛ maɖɔɛ mma nsɛ maɖɔɛ ma. ");
INSERT INTO akp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Si maturi ma nsɛ mabara-ɔ isɛɛ ɔnɔwɛ̃ asɛ abara isɛ atã ne, be ɔso maale-ɔ? Akpi mabaradze ma wũ masɛ mabara ngbɔ. ");
INSERT INTO akp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Si ngɔ loana nnɛ ɔnyɛ i fɔ kɔrɛ ɔtã-ɔ kotoo aanyɛ ira atã ne, be ɔso fiɛ maale-ɔ? Akpi mabaradze ma wũ masɛ manyɛ ara matã mma loawo ma ɔkpesegu ɔtã. ");
INSERT INTO akp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ɣɛɛ ne, miɖɔɛ mi matsirise si mibara isɛɛ mitã ma. Minyɛ ara mitã ma ɣɛɛ midaanyɔ ɔri sɔ maakpesegu mabɔ mi kokooko. Si mibara ngbɔ ne, mi kuso to kuasi fiɛ maakpere mi sɔ Ɣaa Kato gu Karɔ̃ baradze mabi. Alasɔ Ɣaa ba kayiribielea ɔtã ta mma nsɛ masu karɔ̃ma mapɛ ala maturi siba gu maturi lalaa. ");
INSERT INTO akp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Minyɔ maturi nnya lɛ kumɛgɔ i mi ɔse Ɣaa sɛ ɔnyɔ nnya. ");
INSERT INTO akp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Midaaɣɛgu maturi atɔ̃me si Ɣaa iibaɣɛgu mi atɔ̃me. Daatã maturi ipɔ si Ɣaa iibatã-ɔ ipɔ. Su tsɛ maturi si Ɣaa aasu ɔtsɛ-ɔ. ");
INSERT INTO akp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mitã maturi ara si Ɣaa ana atã mi ara. Gbaã ne, kaboũsuai sɛɛ ga loyi pɔpɔɔpɔ, matitidza masɛra kabiɛ kawiri maako ala matã mi. Kaboũsuai ga igbã ako ala ara atã fɔ ɔlaa ne, kã ame igbã maasu mako matã-ɔ ne.” ");
INSERT INTO akp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Mmɔ i Yesu to ɔpɛ ma igbã nɛgbe sɔ, “Si nɔbiɛdze to ɔkɔ nɔbiɛdze ne, iwo ame i ma inyɔɔ aakpase mabo. ");
INSERT INTO akp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Rasuãdze kuwɛ̃ iisɛ ɔɖo ɔ̃ ratedze. Ɣɛɛ si ɔro ara ɔsuã ne, ɔ̃ase lɛ ɔ̃ ratedze awe. ");
INSERT INTO akp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Nda ato abara fiɛ ato anya iku nɛ mpia i fɔ ɔlaa inɔmi fiɛ aito abara kuira i idzirikpo nɛ mpia fɔ mɔmɔ inɔmi iso? ");
INSERT INTO akp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nda aabara fiɛ aaɣere fɔ ɔlaa sɔ, ‘Wũ ɔnyii, tã loɖi-ɔ iku i inɔmi’ ku ɔwi gɔ nnɛ lomɔ iɖo pia i fɔ inɔmi ame? Ladze! Ɖi idzirikpo nɛ mpia-ɔ inɔmi tɔtɔ fiɛ aanya kukaakɔ aɖi fɔ ɔnyii iku i inɔmi.” ");
INSERT INTO akp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kudziri sɛɛ iisɛ kuɣɔ̃ abi nyanyarĩa fiɛ kudziri lalaa ana iibawo abi sɛɛ ɔɣɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kudziri biara ne, kɔ̃ abi aasu anya kɔ̃ aɖi ite. Kuwɛ̃ iisɛ ɔtɔtɔrɛ figi abi i miyu kudziri iso fiɛ maisɛ matɔtɔrɛ adziribi ɖea i itongbã iso. ");
INSERT INTO akp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ɔturi sɛɛ ne, ara sɛɛ ɔsɛ ɔɖi ɔbɔrɛgu i ɔ̃ ara kakɔlakɔ̃ ga nɖe ɔ̃ ɔtu ame. Ɔturi lalaa ɔ̃ wũ ne, ara lalaa ɔsɛ ɔɖi ɔbɔrɛgu i ɔ̃ ɔtu ame. Alasɔ nnɛ loyi ɔturi ɔtu ame ɔsɛ ɔɖi ɔbɔrɛgu i ɔ̃ kanya ame. ");
INSERT INTO akp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Be ɔso fiɛ mito mikpere me sɔ Bosate, Bosate, ɣɛɛ miito mibara ara wa loto loɣere mi iso? ");
INSERT INTO akp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ɔturi biara gɔ nsɛ ɔba wũ kɔrɛ fiɛ ɔto ɔnɔ ara wa nto lote fiɛ ɔsɛ ɔbara iso ne, loate mi nnɛ i ngɔmɔ ɔre. ");
INSERT INTO akp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ɔse lɛ ɔturi gɔ si ɔ̃atsue iyo ne, ɔpia ne i karɔ̃ ame ku ata siare kukaakɔ fiɛ ɔtsue kubereku ɔsia iso. Si ɔwore ɔyi fiɛ ndu ɔbo kabereku gamɔ iso ne, iyo nɛmɔ iibabiɛ alasɔ mapia ne i karɔ̃ ame kukaakɔ. ");
INSERT INTO akp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ɣɛɛ ɔbiara gɔ nsɛ ɔnɔ wũ itɔ̃me fiɛ ɔ̃isɛ ɔbara i ne iso ne, ɔse lɛ ngɔ lotsue ɔ̃ iyo ɔsia i karɔ̃ kunu iso ɔ̃ipia ne i karɔ̃ ame. Si ɔwore ɔyi fiɛ ndu ɔbo iyo nɛmɔ iso ne, iabiɛ ifu i karɔ̃ pelepele!” ");
INSERT INTO akp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Gɔ Yesu ɔɔro ma nwagbe ɔɖuɖu ɔɣere ne, ɔrui ɔkɛlɛ Kapernaum. ");
INSERT INTO akp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Roma kpakpɛ̃dzekpakpa ɔwɛ̃ i mmɔ ba ɔɖabo gɔ ɔbua ɔsɛ ɔɖɔɛ gbaã. Ɔɖabo gɔgbe ɔmɔɛ̃ ɔnyɛ gɔ ɔ̃ɔro ɔkpi. ");
INSERT INTO akp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Gɔ ɔkpakpa gɔgbe ɔnɔ Yesu iyere ne, ɔpia ma Yudase makpakpa mawɛ̃ sɔ makpere Yesu matã wũ si ɔba ɔ̃asa ɔ̃ ɔɖabo ɔtã wũ. ");
INSERT INTO akp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Maba maatã wũ iti teteree sɔ, “Ɔrɛrɛ̃ gɔgbe ɔkote ɔtã sɔ aabuai, ");
INSERT INTO akp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","alasɔ ɔsɛ ɔɖɔɛ bo aɖe kaɖe. Ɔ̃ mɔmɔ lotsue bo kasarɛkɔ̃ ɔtã bo.” ");
INSERT INTO akp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ne ɔso Yesu ɔta ɔsiai ma. Gɔ iɔkuti kɛkɛĩ fiɛ ɔ̃abo iyo mmɔ ne, ɔkpakpa gɔgbe ɔpia ɔ̃ malaa sɔ masɛ maaɣere wũ sɔ, “Tete, loito lobie sɔ loaɖa-ɔ. Loikote sɔ aaba wũ iyo. ");
INSERT INTO akp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Loikote ana sɔ loaba fɔ katɔ̃. Ne ɔso ɣɛ itɔ̃me sese kere si wũ ɔɖabo si ɔna isosarɛ. ");
INSERT INTO akp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mme wũ ɔkpakpa loɖe i makpakpa mama kayirinɔ. Loba makpakpɛ̃dze mama i wũ kayirinɔ. Nsɛ loɣere ngɔ sɔ, ‘Kɛlɛ ngbe’ ɔkɛlɛ, fiɛ nsɛ loɣere ɔmama ana sɔ, ‘Ba ngbe’ ɔba. Nsɛ loɣere wũ ɔɖabo sɔ, ‘Bara lɛ ngbe’ ɔbara.” ");
INSERT INTO akp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Gɔ Yesu ɔnɔ atɔ̃me wagbe ne, ibara wũ ɣaa. Mmɔ ɔto ɔfiniki ɔɣere mma nsiai wũ sɔ, “Nto loɣere mi sɔ loinya kafɔkaɖe siare gagbe igbã lonya i Israel karɔ̃ ɔɖuɖu iso!” ");
INSERT INTO akp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Maturi ma lokpese makɛlɛ kpakpɛ̃dze ɔkpakpa gɔgbe iyo mmɔ ɔnya sɔ ɔ̃ ɔɖabo ɔɔsarɛ. ");
INSERT INTO akp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nnɛmɔ kama ne, Yesu ɔkɛlɛ ɔmagɛ̃ gɔ marɔ Nain ame gu ɔ̃ marasuãdze gu maturi gbodzoo ma nsiai wũ. ");
INSERT INTO akp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Gɔ mabo kabenya ne, masarɛgu maturi ma nsore kpise maabiara. Ngɔ lokpi ne, kuɛdze ɔwɛ̃ ɔbi ɔwɛ̃ saã gɔ ɔɣe ɔɖe. Ne ɔso maturi gbodzoo ɔbɔrɛ i kaɖe ame maki malɔ kuɛdze gɔgbe. ");
INSERT INTO akp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Gɔ Bosate ɔnya ɔrɔ̃go ne, ɔ̃ ara ɔɖo wũ kayiri. Ne ɔɣere wũ sɔ, “Lo kaku.” ");
INSERT INTO akp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yesu ɔbo i maturi ndɛ̃ ɔsɛ ɔ̃apɛgu nnɛ iso masore kpise. Gɔ mma nsore ɔtui ne, ɔɣɛ sɔ, “Ɔporoporoi! Mme sɔ ta!” ");
INSERT INTO akp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ɔluwɛ̃ kpise ɔkpɛ̃ ɔta ɔsɛ ɔtsɛ ika iɖe. Ne Yesu ɔtara wũ ɔtã ɔ̃ ɔnyi ne. ");
INSERT INTO akp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ifɔ̃ ɔmɔɛ̃ maturi ɔɖuɖu gbaã ne matsɛ Ɣaa ile iɣɛ sɔ, “Ɣaa kanyaɖidze siare ɔɔba i bo ndɛ̃. Ɣaa ɔɔba sɔ ɔ̃aba ɔ̃aɖi ɔ̃ mare!” ");
INSERT INTO akp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesu ira nɛ ɔbara ngbe ɔki ikã Yudea karɔ̃ gu abuiti ɔɖuɖu iso. ");
INSERT INTO akp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Gɔ Yohanes marasuãdze ɔɣere wũ ara wagbe ɔɖuɖu ne, ɔkpere ma inyɔ. ");
INSERT INTO akp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ɔpia ma Bosate kɔrɛ sɔ masɛ maakarɛ wũ sɔ, “Fɔ nɖe ngɔ maɣɛ sɔ ɔ̃aba ɛɛbɛrɛ bonyɔ ɔmama ɔri?” ");
INSERT INTO akp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Gɔ maba Yesu kɔrɛ ne, maɣere wũ sɔ, “Ndupiedze Yohanes lopia bo sɔ bo karɛ-ɔ sɔ, ‘Fɔ nɖe ngɔ maɣɛ sɔ ɔ̃aba ɛɛbɛrɛ bonyɔ ɔmama ɔri?’ ” ");
INSERT INTO akp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ɔwi gɔmɔ ame ne, Bosate ɔɔsa maturi gbodzoo sinyɛ, ɔsa siwarã lalaa, ɔtã sɔ manɔbiɛdze gbodzoo ana to manya ara. ");
INSERT INTO akp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ne ɔɣere mma mapia katɔ̃me sɔ, “Mikpese miaɣere Yohanes ara wa minya gu nwa minɔ. Manɔbiɛdze to manya, mabafã to masɛ, mma nto manyɛ ɔnyɛ rɛtɛa iso to isekele, matsuetɛ̃se to manɔ, makpise to mata fiɛ mato maɣere mawɛrɛba ana Itɔ̃me Bielea. ");
INSERT INTO akp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","So aaɣɔ mma i wũ kurabarara iita kuya iso.” ");
INSERT INTO akp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Gɔ Yohanes marasuãdze ɔɔrui kama ne, Yesu ɔtsɛ ika iɖe i ɔ̃ iso iɣere mma losakanya mmɔ sɔ, “Ɔwi gɔ mibɔrɛ mikɛlɛ Yohanes kɔrɛ i fafuĩ ame ne, be iɖe minyɔ ɔri sɔ mianya? Iyata nɛ i ɔwiri to ɔtidza? ");
INSERT INTO akp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Be mibɔrɛ misɛ mianyɔ? Ngɔ mpia ɔgo awu? Mma mpia ɔgo awu fiɛ mato maɖe isoɣɔ ne, magara ayo masɛ mawe. ");
INSERT INTO akp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mibua miɣere me nnɛ misɛ mianyɔ! Ɣaa kanyaɖidze? Gbaã nto loɣere mi sɔ ɔɖo Ɣaa kanyaɖidze. ");
INSERT INTO akp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Alasɔ ɔ̃ iso i Ɔko Sekelea ɔɣɛ sɔ, ‘Loasese kpabo ɔɖe-ɔ katɔ̃, sɔ ɔ̃aledza maturi ɔtã fɔ iba.’ ” ");
INSERT INTO akp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu ɔledza ma iɣere ana sɔ, “Yohanes ɔɖo ɔturi igbã biara gɔ maɣe i kayi gagbe ame. Ɣɛɛ ngɔ lokoso ɔɖo i Ɣaa sigarakaɖekɔ̃ ɔɖo wũ.” ");
INSERT INTO akp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tɔtɔ ne, maturi ɔɖuɖu ɔɔnɔ itɔ̃me nɛ i Yohanes ɔɣɛ titirio ma lampofɔdze ma lobara Ɣaa kuɖɔɛ fiɛ mafɔ Ɣaa itupie kubarara i ɔ̃ kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ɣɛɛ ma Farisise gu Mose mmara matedze ɔsɛ̃ ara wa nɖe Ɣaa kuɖɔɛ kutã ma fiɛ maibie sɔ ɔpie ma ndu. ");
INSERT INTO akp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Kiniɔ ne, mabe loasu nɔme maturi lokateragu? Nda mase? ");
INSERT INTO akp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mase lɛ mabiɛtɛ ma nto maɣa kaɣa i kuɣa ame. Mawɛ̃ to maɣere ma malaa sɔ, ‘Boka isoɣɔ aka botã mi, miitɔ! Boɖi sikubiɛnɔ ana botã mi, miibiɛ kaku.’ ");
INSERT INTO akp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Gɔ Ndupiedze Yohanes ɔba ɔ̃ito ɔɖe ara ɔnɛ ndã mɛ loamɔɛ̃ ne, miɣɛ sɔ, ‘Siwarã lalaa mpia i ɔ̃ ame!’ ");
INSERT INTO akp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mme Ɔturi Awune Ɔbi gɔ loba fiɛ loto loɖe ara lonɛ ndã ne, mi sɔ, ‘Minyɔ ɖeɖei gu tarɛ̃dze gɔgbe! Ma lampofɔdze gu makpibaradze ɔlaa ɔɖe!’ ");
INSERT INTO akp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ɣɛɛ Ɣaa iwola sɛ ite so i ɔturi nsɛgbai ame.” ");
INSERT INTO akp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ɔ Farisise ɔwɛ̃ ɔkpere Yesu sɔ ɔba ɔ̃aɖe aɖera i ɔ̃ iyo, ne ɔsɛ ɔ̃asɛ ɔtsɛ araɖea iɖe ne. ");
INSERT INTO akp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ɔrɔ̃go ɔwɛ̃ pia i ɔmagɛ̃ gɔmɔ ame gɔ nsi ngbã nyanyarĩa. Gɔ ɔnɔ sɔ Yesu to ɔɖe ara i ɔ Farisise gɔmɔ iyo ne, ɔsu nnɔĩ miwɛ̃ mɛ nsɛ mifɔrɛ̃ kɔrɔ̃kɔrɔ̃ fiɛ me ibui ɔnyɔ sɔlɔsɔlɔ ɔbɔ mmɔ. ");
INSERT INTO akp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ɔba ɔ̃aya i Yesu kama ɔto ɔbiɛ nnɔmɛ ɔfere i ɔ̃ ngba iso. Ɔrɔ̃go gɔgbe ɔsu ɔ̃ iti siwɛrɛ̃ ɔnyɛnyɛdɛ̃ Yesu ngba, ɔfiɔfiɔ̃ me fiɛ ka ɔsu nnɔĩ kɔrɔ̃kɔrɔ̃a mɛmɔ ɔfere wũ i ngba ana. ");
INSERT INTO akp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Gɔ Farisise gɔ lokpere Yesu ɔnya ira nɛgbe ne, ɔɣɛ i ɔ̃ iti ame sɔ, “Si ɔrɛrɛ̃ gɔgbe ne Ɣaa kanyaɖidze ɔɖe ne, tee ɔ̃atsue ɔturi gɔ igbã i ɔrɔ̃go gɔ nto ɔpɛpɛgu wũ ngbe ɖe gu ngbã nyanyarĩa mɛ igbã ɔsi!” ");
INSERT INTO akp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ne Yesu ɔfɔ kanya ɔɣere wũ sɔ, “Simon, lobie sɔ loaɣere-ɔ ira iwɛ̃.” Ne Simon ɔɣere wũ sɔ, “Ratedze, ɣɛ nnɛ aba.” ");
INSERT INTO akp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ne Yesu ɔsɛ karɔ̃ ɔɣere wũ sɔ, “Maturi inyɔ mawɛ̃ ɔla ɔrɛrɛ̃ ɔwɛ̃ kuso. Ɔwɛ̃ to wũ lɛ kuwa kuwɛ̃ kuso. Ɔnyɔare to wũ lɛ awa aweo kuso. ");
INSERT INTO akp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ma inyɔ magbe kuwɛ̃ iiwo wũ kuso ɔtã. Ne ɔso ɔsu kuso gɔ mato wũ ɔɖuɖu ɔtsɛ ma. Maturi inyɔ magbe ndɛ̃ ne, nna loaɖɔɛ ɔrɛrɛ̃ gɔgbe ɔɖo?” ");
INSERT INTO akp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ne Simon ɔɣɛ sɔ, “Lofɔ loɖe sɔ ngɔ masu kuso siare matsɛ.” Mmɔ i Yesu ɔɣere wũ sɔ, “Aɣɛ kukaakɔ.” ");
INSERT INTO akp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesu ɔfiniki ɔnyɔ ɔrɔ̃go gɔgbe, ne ɔɣere Simon sɔ, “Ato anya ɔrɔ̃go gɔgbe? Gɔ loba fɔ iyo ne, aitã me ndu sɔ lofore ngba. Ɣɛɛ ɔrɔ̃go gɔgbe ɔsu ɔ̃ nnɔmɛ ɔfore me ngba fiɛ ɔsu ɔ̃ iti siwɛrɛ̃ ɔnukutu me. ");
INSERT INTO akp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Gɔ loba fɔ iyo ne, aipɔrɛ me apia me isoɣɔ. Ɣɛɛ ita i ɔwi gɔ lobo i fɔ iyo ne, ɔrɔ̃go gɔgbe iinyua wũ ngba ɔsɔla. ");
INSERT INTO akp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Aitã me nnɔĩ sɔ lopia i iti. Ɣɛɛ ɔ̃ ɔsu nnɔĩ kɔrɔ̃kɔrɔ̃a ɔfere me ngba ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ne ɔso nto loɣere-ɔ sɔ ne, ɔ̃ kuɖɔɛ gɔ ɔɖi ɔte me ɔso ne, ɔna ɔ̃ akpi gbodzoo wa ɔbara isu itsɛ. Ɔturi gɔ masu akpi kɛkɛĩ matsɛ ne, ɔ̃ kuɖɔɛ ana ne, kɛkɛĩ kere kuse.” ");
INSERT INTO akp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mmɔ i Yesu to ɔɣere ɔrɔ̃go gɔmɔ sɔ, “Ɔɔna fɔ akpi isu itsɛ.” ");
INSERT INTO akp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Gɔ mma nsi i ɔpɔrɔ̃ katɔ̃ gu Yesu ɔnɔ ara wa ɔɣɛ ne, makarɛ so sɔ, “Nna ɔɖe ngbe fiɛ ɔto ɔwo maturi akpi ɔsu ɔtsɛ ma?” ");
INSERT INTO akp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ne Yesu ɔɣere ɔrɔ̃go gɔmɔ sɔ, “Fɔ kafɔkaɖe ɔɖi-ɔ ne ɔso kɛlɛ i isobuɛ ame.” ");
INSERT INTO akp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ɔwi kama ne, Yesu ɔki i simagɛ̃ gu ngorowase wiriwiria ame ɔɣɛ Itɔ̃me Bielea i sigarakaɖekɔ̃ iso. Ɔ̃ marasuãdze iweo-inyɔ ana siai wũ. ");
INSERT INTO akp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Marɔ̃go mawɛ̃ ma i Yesu ɔsa sinyɛ agbãagbã gu mma ame ɔsa siwarã lalaa ɔɖi ana ɔsiai wũ. Ma ndɛ̃ mawɛ̃ nɖe Maria gɔ masɛ marɔ Magdalase, ngɔ ame i Yesu ɔsa siwarã lalaa aka akɔdzɛ ɔɖi. ");
INSERT INTO akp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ɔwɛ̃ ana nɖe Yohana gɔ ɔrã marɔ Kusa gɔ nsɛ ɔbara karabara i Igara Herodes atɔ̃mekaɣɛkɔ̃ lɛ ɔkpakpa awe. Ɔmama ana nɖe Susana gu mamama gbodzoo ma losiai Yesu masu ma karana mabuai wũ gu ɔ̃ marasuãdze. ");
INSERT INTO akp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Maturi gbodzoo to mabɔrɛ i simagɛ̃ agbãagbã ame maba Yesu kɔrɛ. Gɔ maba maasakanya ne, Yesu ɔpɛ ma igbã nɛgbe sɔ, ");
INSERT INTO akp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Kpɛ̃dze ɔwɛ̃ ɔsɛ ɔraɖui kasakɔ̃. Gɔ ɔto ɔsa ne, ɔwɛ̃ ɔfere i ɔri iso maturi ɔsɛ iso ne kurodzai ɔrɛrɛ kuɖe ne. ");
INSERT INTO akp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ɔwɛ̃ ana ɔɣo i ata iso ɣɛɛ gɔ ɔre kere ne, ɔ̃ ɔɖuɖu ɔkpi alasɔ ɔ̃ siɖu iibo karɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ɔraɖui ɔwɛ̃ ana ɔbo i kuposɛ̃ ndɛ̃, ne ɔso gɔ ɔre ne, kuɣa kufu wũ iso, ne ɔso ɔkpi pelepele. ");
INSERT INTO akp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ɣɛɛ ɔwɛ̃ ana ɔɣo i karɔ̃ sɛɛ iso. Gɔ ɔre ne, ɔɣɔ̃ abi, ɔwɛ̃ abi kulafa kulafa.” Ne Yesu ɔɣere ma sɔ, “Ngɔ mba atsue si ɔnɔ nnɛ nto loɣɛ!” ");
INSERT INTO akp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesu marasuãdze ɔkarɛ wũ sɔ ɔɖi igbã nɛgbe karɔ̃ ɔtã ma. ");
INSERT INTO akp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ne ɔɣere ma sɔ, “Ɣaa ɔɖi ɔ̃ sigarakaɖekɔ̃ awɛrɛra karɔ̃ ɔte mi. Ɣɛɛ maturi mama ne, agbã ame maanɔ sɔ, ‘si mato manya ne, maibatsue. fiɛ si mato manɔ ne, maibanɔ karɔ̃.’ ");
INSERT INTO akp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Igbã nɛ lopɛ karɔ̃ ngbe ne. Ɔraɖui gɔ mato masa nɖe Ɣaa itɔ̃me. ");
INSERT INTO akp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ɔraɖui gɔ loɣo i ɔri kuruɛ se lɛ maturi ma nsɛ manɔ itɔ̃me fiɛ Ɔbosam sɛ ɔba ɔ̃amɔɛ̃ ne ɔɖi i ma situ ame. Isɛ itã sɔ maibawo ɔfɔ ɔɖe fiɛ maana iɖi. ");
INSERT INTO akp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ngɔ ana loɣo i ita iso ne, ɔse lɛ maturi ma lonɔ itɔ̃me fiɛ mafɔ ne ku isoɣɔ ɔluwɛ̃, ɣɛɛ iibo i ma ame wodoroo. Ne ɔso ma kafɔkaɖe ɔwi se kurukutu gɔ si ita iya iso ɔba ma iso ne, masɛ mafɛ̃. ");
INSERT INTO akp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ngɔ ana loɣo i kuposɛ̃ ame ne, ɔse lɛ maturi ma lonɔ itɔ̃me ɣɛɛ kayiiso imararã gu karana gu ngbã iɖe sɛ iɣa ifu ma sɔ maisɛ mawo iti ɔre fiɛ maaɣɔ̃ abi abe. ");
INSERT INTO akp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ɔraɖui gɔ loɣo i karɔ̃ sɛɛ iso ɔ̃ wũ ne, ɔse lɛ maturi ma lonɔ itɔ̃me fiɛ imɔɛ̃ ma ɔtu gbaã gu karɔ̃ ibɔso. Maya teteree gbɔgbɔɔgbɔ isɛ iabo kawirikɔ̃ maɣɔ̃ abi gbodzoo. ");
INSERT INTO akp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Kuwɛ̃ iisɛ ɔtsue ɔkaniɛ ɔsu ɔkɔla i kabui ame ɣee ɔsu ɔɣedza i karɛkɔ̃ kayirinɔ. Ɣɛɛ ɔ̃atara wũ ɔsia i ira kɔlɛa iso sɔ si ɔ̃asa ɔfere i kakɔi biara sɔ si ɔturi biara ɔbo iyo ne, ɔ̃anya kame sekelee. ");
INSERT INTO akp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ira biara nɛ makɔla i kakɔi biara ne, mato maaɖi ne mabɔ i ɔgbami. Ira biara nɛ mafu ara ne, mato maaɖi ne mabɔ ikpawaĩ ame. ");
INSERT INTO akp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Midzuɛ̃ so i kumɛgɔ miakã atsue alasɔ ngɔ mba ara ne, maatã wũ mabua, ɣɛɛ ngɔ mba ara kɛkɛĩ ne, kɛkɛĩ gɔ ame ɔbu sɔ ɔba ne, maamɔɛ̃ mafɔ wũ iso.” ");
INSERT INTO akp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesu ɔnyi gu ɔ̃ manyiibi ɔba ɔ̃ kɔrɛ, ɣɛɛ maiwo Yesu ɔnya ala kumɛgɔ i maturi ɔmini wũ ɔso. ");
INSERT INTO akp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ɔwɛ̃ ɔba ɔ̃aɣere Yesu sɔ, “Fɔ ɔnyi gu manyiibi ɣɛ i inyamɔ mato mabie-ɔ.” ");
INSERT INTO akp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ne Yesu to ɔɣere ma ɔɖuɖu sɔ, “Wũ ɔnyi gu wũ manyiibi nɖe mma nsɛ manɔ Ɣaa itɔ̃me fiɛ masɛ mabara i ne iso.” ");
INSERT INTO akp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Iyi iwɛ̃ ne, Yesu gu ɔ̃ marasuãdze ɔbo i ɔkolo ame. Ne ɔɣere ma sɔ, “Mitã bowara ibu bokɛlɛ ɔkpokpo gɔmɔ isɛ.” Ne ɔso mabo i ɔkolo ame marui. ");
INSERT INTO akp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Gɔ masia ndu iso kɛkɛĩ kere ne, sirɛ ɔsu Yesu. Ɔluwɛ̃ awɛ ɔtsɛ ikpɛ̃ teteree gɔ mma ɔɖuɖu mpia i ɔkolo ame ngbã ɔwe i imɔrɛ̃ ame ala ndu ɔtsɛ ɔkolo ame ibo. ");
INSERT INTO akp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Marasuãdze ɔbore mabo wũ maatara wũ sɔ, “Tete! Ɔkpi boto lo!” Mmɔ i Yesu ɔta ɔya ɔtɔ̃me ɔpia ɔwiri gu ndu mɛ nto miɖa so. Ɔluwɛ̃ ne, ira biara ko lolo kananana. ");
INSERT INTO akp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ne ɔto ɔkarɛ marasuãdze sɔ, “Be iɖe ɔso fiɛ mina kafɔkaɖe?” Ɣɛɛ ifɔ̃ ɔmɔɛ̃ ma ibara ma ɣii ne mato makarɛ so sɔ, “Mme ɔturi igbã ɔɖe ngbe? Ɔto ɔɖegu ɔwiri gu ndu ika makã wũ atsue!” ");
INSERT INTO akp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu gu ɔ̃ marasuãdze ɔwara ɔpo makɛlɛ Gadara ibuiti ame si abɔrɛ i Galilea isɛ. ");
INSERT INTO akp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ɔluwɛ̃ gɔ Yesu ɔso ɔbɔrɛ i ɔkolo ame ne, ɔrɛrɛ̃ ɔwɛ̃ gɔ ame i siwarã lalaa pia ɔsarɛgu wũ. Ɔrɛrɛ̃ gɔgbe ɔbɔrɛ i ɔmagɛ̃ gɔmɔ ame fiɛ ɔwi gbodzoo ne, ɔsɛ ɔwe ɔki isɔ̃isɔ̃. Ɔ̃isɛ ɔbie sɔ ɔ̃asɛ i ayo ame, ɣɛɛ ɔwi biara ne, ɔsɛ ɔwe i maturi kabiarakɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Gɔ ɔnya Yesu ne, ɔla kulu teteree ɔpɛ agɛgɛ̃ i Yesu ngbatɔ̃. Ɔɣere wũ teteree sɔ, “Yesu, Ɣaa gɔ nɖe Ɔlesate Ɔbi! Be ato abie abɔrɛgu i wũ kɔrɛ? Loto-ɔ i kukpa daakpadzɛ̃ me kutsue!” ");
INSERT INTO akp_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ɔrɛrɛ̃ gɔgbe ɔɣɛ ngbɔ ala Yesu ɔtɔ̃me ɔpia siwarã dzɛ mpia i ɔ̃ ame sɔ, “Bɔrɛ i ɔ̃ ame fe!” Ɔwi gbodzoo si siwarã dzɛgbe si ɔrɛrɛ̃ gɔgbe iso ne, si manyi wũ nrɔɔ̃ gu ngba ala ngɔsɔngɔsɔn kɔra ne, ɔsɛ ɔmɔɛ̃ ɔfɛfɛ̃ fiɛ sisɛ siɖi wũ ɔbɔrɛ ɔkɛlɛ fafuĩ ame. ");
INSERT INTO akp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu ɔkarɛ wũ sɔ, “Nda marɔ-ɔ?” Ne ɔtã mmuai sɔ, “Mme marɔ Isɛguri ne.” Ɔɣɛ ngbɔ alasɔ siwarã lalaa dzɛ mpia i ɔ̃ ame ɔsi. ");
INSERT INTO akp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mmɔ i Siwarã to sitã Yesu iti sɔ ɔdaafuĩdza ma ɔpia i iwo gudua nɛ ame maawe inyɛ. ");
INSERT INTO akp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Makparako gbodzoo mawɛ̃ ɣɛ i kabemi iso mato maɖe ara. Ne siwarã lalaa to sitã Yesu iti sɔ ɔtã ma mabo i makparako ma mmɔ ame. Ne Yesu ɔtã ma ɔri ne. ");
INSERT INTO akp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Siwarã dzɛgbe ɔbɔrɛ i ɔrɛrɛ̃ ame sibo i makparako ame, ma ɔɖuɖu ɔtere kpitikpitikpiti maso kabemi mabo i itubu ame makpi. ");
INSERT INTO akp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Gɔ mma nto manyɔ makparako iso ɔnya nnɛ loba ne, matere makɛlɛ ɔmagɛ̃ ame masɛ maaɣere maturi ɔɖuɖu gu ngorowase ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Maturi ɔbɔrɛ maba sɔ si maba maanyɔ nnɛ loba. Gɔ mabo Yesu kɔrɛ ne, manya sɔ ɔrɛrɛ̃ gɔ ame i Yesu ɔsa siwarã lalaa ɔɖi ka ɔsi i Yesu ngbatɔ̃, ɔpia awu, iti ame ɔɔkpa waĩ. Ne ɔso ifɔ̃ ɔmɔɛ̃ ma ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mma lonya nnɛ loba ne, maɣere matsɔra kumɛgɔ ibara fiɛ siawarã lalaa ɔbɔrɛ i ɔ̃ ame fiɛ ɔsarɛ. ");
INSERT INTO akp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nnɛgbe ɔso ne, Gadara karɔ̃ gu kã abuiti maturi ɔɣere Yesu sɔ ɔbɔrɛ i ma karɔ̃ iso alasɔ manigã. Ne ɔso Yesu ɔbo i ɔkolo ame ɔledza irui. ");
INSERT INTO akp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mmɔ i ɔrɛrɛ̃ gɔ i Yesu ɔsa ɔpɛ wũ nrɔɔ̃ sɔ, “Tã me losiai-ɔ.” Ɣɛɛ Yesu iinɔgu wũ karɔ̃, ɔɣere wũ sɔ, ");
INSERT INTO akp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kpese kɛlɛ fɔ iyo si asɛ aaɣɛ nnɛ i Ɣaa ɔbara ɔtã-ɔ.” Ne ɔso ɔrɛrɛ̃ gɔgbe ɔkpese ɔkɛlɛ ma ɔmagɛ̃ ame ɔsɛ ɔ̃awe ɔɣɛ ara wa ɔɖuɖu i Yesu ɔbara ɔtã wũ. ");
INSERT INTO akp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ɔwi gɔ i Yesu ɔwara ɔpo ɔkpese ɔba kama isɛ ne, maturi gbodzoo ɔsarɛgu wũ kukaakɔ alasɔ mato manyɔ wũ ɔri. ");
INSERT INTO akp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ɔrɛrɛ̃ ɔwɛ̃ gɔ marɔ Yairo fiɛ ɔɖe ma Yudase kasarɛkɔ̃ makpakpa ndɛ̃ ɔwɛ̃ ɔba ɔ̃apɛ agɛgɛ̃ i Yesu katɔ̃ ɔtã wũ iti sɔ ɔsiai wũ ɔba ɔ̃ iyo, ");
INSERT INTO akp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","alasɔ ɔ̃ ɔbi birɔ̃gomi ɔwɛ̃ saã gɔ loɔfɔ lɛ akɔ aweo-anyɔ ne, ɔrɛ ɔto ɔnyɛ ɔ̃ɔro ɔkpi. Gɔ Yesu ɔrui ɔsiai wũ ne, maturi ɔmini wũ mato malili so. ");
INSERT INTO akp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Maturi magbe ndɛ̃ ne, ɔrɔ̃go ɔwɛ̃ gɔ i ara to afere akɔ aweo-anyɔ buu ana pia. Ɔrɔ̃go gɔgbe ɔɔnina ɔ̃ sikã ɔɖuɖu ɔsu ɔbie so kua ɣɛɛ ɔ̃ina isosarɛ. ");
INSERT INTO akp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ɔbo i maturi ndɛ̃ ɔbara pɔkɔsɔɔ ɔpɛgu Yesu awu kutsueti i kama isɛ. Ɔluwɛ̃ ne, ara ko lonyua wũ ɔfere. ");
INSERT INTO akp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mmɔ i Yesu to ɔkarɛ sɔ, “Nna ɔɖe lopɛgu me?” Ɣɛɛ ɔbiara ɔsɛ̃. Ne Petro ɔɣere wũ sɔ, “Bokɔse, nyɔ kumɛgɔ i maturi ɔki malɔ-ɔ!” ");
INSERT INTO akp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ɣɛɛ Yesu ɔɣɛ sɔ, “Loɣe sɔ ɔnyiiɔ ɔpɛgu me alasɔ ɔle ɔwɛ̃ ɔbɔrɛ i wũ ame.” ");
INSERT INTO akp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Gɔ ɔrɔ̃go ɔnya sɔ ɔ̃ibawo ɔwɛrɛ ɔso ne, ɔbɔrɛgu ifɔ̃ ɔto ɔti ɔkpakpa ɔba ɔ̃apɛ agɛgɛ̃ i Yesu katɔ̃ i maturi ɔɖuɖu anɔ. Ɔɣere Yesu nnɛ ɔso ɔpɛgu wũ gu kumɛgɔ ɔna isosarɛ ɔluwɛ̃. ");
INSERT INTO akp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ne Yesu ɔɣere wũ sɔ, “Wũ ɔbi birɔ̃gomi, fɔ kafɔkaɖe losa-ɔ. Kɛlɛ i isobuɛ ame.” ");
INSERT INTO akp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Gɔ Yesu ɣɛ i mmɔ ɔtogu itɔ̃me nɛgbe iɣɛ ne, mapia ɔturi mabɔrɛgu i ma Yudase kasarɛkɔ̃ ɔkpakpa gɔ marɔ Yairo iyo sɔ ɔba ɔ̃aɣere wũ sɔ, “Fɔ ɔbi birɔ̃gomi ɔɔkpi ne ɔso kanyua ratedze kutsuɛ ɔɖaa.” ");
INSERT INTO akp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ɣɛɛ gɔ Yesu ɔnɔ ne, ɔɣere Yairo sɔ, “Daanigã, fɔɖe kere sɔ fɔ ɔbi to ɔ̃asarɛ.” ");
INSERT INTO akp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Gɔ masɛ maabo Yairo iyo ne, Yesu iitã kuwɛ̃ ɔri sɔ ɔbo iyo kame iɖo Petro gu Yohanes gu Yakobo gu ɔbirɔ̃gomi maɣese. ");
INSERT INTO akp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Maturi ɔɖuɖu ɣɛ i mmɔ mato mabiɛgu kulu, ɣɛɛ Yesu ɔɣere ma sɔ, “Minyua ɔbiɛ, alasɔ ɔbi iikpi, sirɛ kere ɔto ɔrɛ.” ");
INSERT INTO akp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Gɔ ɔɣɛ ngbɔ ne, mama wũ alasɔ maɣe sɔ ɔ̃ɔkpi. ");
INSERT INTO akp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ne Yesu ɔmɔɛ̃ ɔbirɔ̃gomi kɔrɔ̃, ɔkpere wũ sɔ, “Ɔbi, ta ya!” ");
INSERT INTO akp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ɔbirɔ̃gomi ko lorɛgɛ̃ ɔta ɔsɛ. Yesu ɔɣere ma sɔ mabie irere matã ɔbi si ɔɖe. ");
INSERT INTO akp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ira nɛgbe ɔbara ɔ̃ maɣese ɣii, ɣɛɛ Yesu ɔɣere ma sɔ madaaɣere kuwɛ̃ nnɛ loba i mmɔ. ");
INSERT INTO akp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu ɔkpere ɔ̃ marasuãdze iweo-inyɔ ɔsirakanya ne ɔtã ma ɔri gu ɔle sɔ masa siwarã lalaa ɔɖuɖu si masa sinyɛ agbãagbã ana. ");
INSERT INTO akp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ɔsese ma sɔ makɛlɛ maaɣɛ Ɣaa sigarakaɖekɔ̃ iso itɔ̃me si masa manyɛse. ");
INSERT INTO akp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Si maarui ne, Yesu ɔɣere ma sɔ, “Midaasu kuira mila i irisɛ ame lɛ ɔsɛdziri ɣee akpo ɣee aɖera ɣee sikã. Midaasu awu nyɔare sɔ mianyuarã i ɔri. ");
INSERT INTO akp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Iyo biara nɛ ame mafɔ mi ne, miwe i mmɔ gbɔgbɔɔgbɔ miarui i ɔmagɛ̃ gɔmɔ ame. ");
INSERT INTO akp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ngbegɔ masɛ̃ maifɔ mi ne, si miarui i mmɔ ne, mikpakpa mi ngba sise mifere lɛ Ɣaa kutsue ikpadzɛ̃ nɛ loaba ikparĩ.” ");
INSERT INTO akp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Marasuãdze ɔrui mabo i nsɛkɔ̃ mɛmɔ ame mato maɣɛ Itɔ̃me Bielea masa maturi sinyɛ i kakɔi biara. ");
INSERT INTO akp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Gɔ Herodes gɔ nto ɔɖe Galilea karɔ̃ iso ɔnɔ ara wa nto aba ngbe ne, ɔkpɔkpɔtɔ alasɔ maturi mawɛ̃ to maɣɛ sɔ Ndupiedze Yohanes loɔta ɔbɔrɛ i makpise ame ɔpia ngbã. ");
INSERT INTO akp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mawɛ̃ ana to maɣɛ sɔ Eliya ɔɖe loɔledza iba. Fiɛ mawɛ̃ ana sɔ Ɣaa kanyamaɖidze kuere ɔwɛ̃ ɔɖe loɔkpese ɔba maɣe wũ. ");
INSERT INTO akp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ne Herodes to ɔɣɛ sɔ, “Lotã matu Yohanes iti, ne ɔso nna ɔɖe nto ɔbara ara wa nto lonɔ ngbe?” Ne ɔso Herodes ɔbie ɔri gɔ iso ɔ̃aki fiɛ ɔ̃anya Yesu. ");
INSERT INTO akp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Katɔ̃memasɛdze ɔba maaɣere Yesu nwa ɔɖuɖu mabara. Ne ka ɔkɔ ma kerekere marui makɛlɛ ɔmagɛ̃ gɔ marɔ sɔ Betsaida ame ne. ");
INSERT INTO akp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Gɔ maturi ɔnɔ ngbɔ ne, masiai ma kama makɛlɛ mmɔ. Yesu ɔ̃ wũ ɔfɔ ma ɔɣere ma Ɣaa sigarakaɖekɔ̃ itɔ̃me fiɛ ɔsa mma nto manyɛ. ");
INSERT INTO akp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Iɣɛ̃kɛlɛ ame ne, katɔ̃memasɛdze iweo-inyɔ ɔba maaɣere Yesu sɔ, “Ɖi ma ɔri si makɛlɛ ngorowase mɛ lobore mimatã ngbe si masɛ maabie aɖera gu ngbegɔ maarɛ ala ngbe ɔfe idzoro gu ayo ame.” ");
INSERT INTO akp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mmɔ i Yesu to ɔɣere ma sɔ, “Mi mɔmɔ mitã ma irere maɖe.” Ne mato maɣere wũ sɔ, “Araɖea wa ɔɖuɖu boba ngbe nɖe abolo abo aru gu afara anyɔ. Ato abie sɔ bosɛ boaɣa araɖea botã maturi gbodzoo magbe?” ");
INSERT INTO akp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Marɛrɛ̃ kerekere i ma ndɛ̃ aaɖe lɛ maturi kukpi kuru mmɔ. Ne Yesu to ɔɣere ɔ̃ marasuãdze sɔ, “Mitã ma masɛ i akuri ame lɛ siru siru awe.” ");
INSERT INTO akp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ne gɔ marasuãdze ɔbara ngbɔ ne, ");
INSERT INTO akp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu ɔsu abolo abo aru gu afara anyɔ wamɔ, ɔkɔlɛ anɔ kato. Gɔ ɔpɛ Ɣaa siba i wã iti ne, ɔbɛbɛse ɔtã ɔ̃ marasuãdze sɔ masu maɣɛɣɛ mmamɔ. ");
INSERT INTO akp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Gɔ ma ɔɖuɖu ɔɖe ara mami fiɛ marasuãdze ɔsa nwa lobuburi kanya ne, mana kusɛsɛi kuweo-kunyɔ. ");
INSERT INTO akp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Gɔ Yesu ɔnɔwɛ̃ to ɔkparama kayi iyi iwɛ̃ ne, ɔ̃ marasuãdze ɔwe i ɔ̃ kɔrɛ. Ne ɔto ɔkarɛ ma sɔ, “Nna i maturi sɛ maɣɛ sɔ loɖe?” ");
INSERT INTO akp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ne matã wũ mmuai sɔ, “Mawɛ̃ sɛ maɣɛ sɔ fɔ nɖe Ndupiedze Yohanes, mawɛ̃ ana sɔ fɔ nɖe Eliya, fiɛ mawɛ̃ ana sɛ maɣɛ sɔ Ɣaa kanyamaɖidze kuere ɔwɛ̃ loɔkpese ɔba ngbã.” ");
INSERT INTO akp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mmɔ ɔto ɔkarɛ ma sɔ, “Ne mi ɣɛɛ? Nna miɣe sɔ loɖe?” Petro ɔfɔ kanya sɔ, “Fɔ nɖe Ɣaa Kristo ne.” ");
INSERT INTO akp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Mmɔ i Yesu ɔsɛ̃ ɔtã ma teteree sɔ madaaɣere kuwɛ̃ itɔ̃me nɛgbe. ");
INSERT INTO akp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yesu ɔledza ma iɣere sɔ, “Ikote sɔ mme, Ɔturi Awune Ɔbi, awe inyɛ gbodzoo i ma Yudase makpakpa gu masɔrɛdze makpakpa gu mmara matedze nrɔɔ̃ ame maasɛ̃ me, maɖoe me. Ɣɛɛ ikpɛnɛ tɛare ne, Ɣaa to ɔ̃atara me lowe ngbã.” ");
INSERT INTO akp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mmɔ ɔto ɔɣere ma ɔɖuɖu sɔ, “Si ɔrere ɔbie sɔ ɔ̃asiai me ne, ɔsɛ̃ so si ɔsu ɔ̃ inyɛwe ɔnyigbã si ɔ̃awo me ɔsiai. ");
INSERT INTO akp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Alasɔ ɔbiara gɔ loakpɛ̃ i ɔ̃ ngbã iti ne, ɔto ɔ̃ayura me, ɣɛɛ ngɔ loanyua ɔ̃ ngba ala wũ ɔso ne, ɔto ɔ̃ana ngbã mɛ loisɛ miro. ");
INSERT INTO akp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mme kusia i ɔturi ana si kayi iso ɔɖuɖu karana ɔkpese ɔ̃ kare fiɛ ɔ̃ina ngbã mɛ loisɛ miro? ");
INSERT INTO akp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Si mme gu wũ ara ite to ikpɛ̃ ɔrere kunuarɛ ne, mme, Ɔturi Awune Ɔbi, mme wũ ɔto ɔ̃akpɛ̃ me kunuarɛ ku ɔwi gɔ ame loaba i wũ ikpawaĩ gu wũ ɔse Ɣaa ɔle gu ɔ̃ makpabo sekelea ɔɖuɖu ikpawaĩ ame. ");
INSERT INTO akp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nto loɣere mi gbaã sɔ mi ndɛ̃ mawɛ̃ i ngbe iibakpi fiɛ Ɣaa aaɖi ɔ̃ Sigarakaɖekɔ̃ ɔle ɔte.” ");
INSERT INTO akp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Lɛ ɖapɛ ɔwɛ̃ kama gɔ Yesu ɔɣere ma ara wagbe ne, ɔkɔ Petro gu Yohanes gu Yakobo maya kube kuwɛ̃ makɛlɛ itititɛ̃ sɔ maakparama kayi. ");
INSERT INTO akp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Gɔ ɔto ɔkparama kayi ne, ɔ̃ katɔ̃ ko lokpaki kato kafiɛ futututu gɔ ta ɔ̃ ara wa ɔpia to atsue anɔmi. ");
INSERT INTO akp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ɔluwɛ̃ ne, marɛrɛ̃ inyɔ ma nɖe Mose gu Eliya ɔba maaya i ɔ̃ kɔrɛ mato maɖegu wũ ika. ");
INSERT INTO akp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Maba i Ɣaa sigarakaɖekɔ̃ ikpawaĩ ame fiɛ maɖe ku Yesu ika i ɔri gɔ iso ɔ̃aki fiɛ ɔ̃abara Ɣaa kuɖɔɛ i ɔ̃ kukpi i Yerusalem iso. ");
INSERT INTO akp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petro gu ɔ̃ malaa ɔrɛ sirɛ dzoroo, ɣɛɛ gɔ mata ne, manya Yesu i ɔ̃ ikpawaĩ ame gu maturi inyɔ ma nɣɛ wũ i kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Gɔ maturi inyɔ mamɔ to marui ne, Petro ɔɣere Yesu sɔ, “Tete, bo ngbe iba ɔbua ilɛ gbaã! Tã bopɛ akpayo atɛ i ngbe. Iwɛ̃ itã-ɔ, iwɛ̃ itã Mose fiɛ iwɛ̃ ana itã Eliya.” Ɔ̃ mɔmɔ kɔra iiɣe ara wa ɔɣɛ i ngbe. ");
INSERT INTO akp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Gɔ ɔɣɛ i mmɔ ɔto ika iɖe ne, idɔdɔ ɔso ifu ma iso ne ɔso ifɔ̃ ɔmɔɛ̃ marasuãdze gbaã. ");
INSERT INTO akp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ne manɔ silɔ i idɔdɔ ame gɔ sito siɣɛ sɔ, “Wũ ibiete gɔ losia ikparĩ ngbe ne, mikã wũ Atsue!” ");
INSERT INTO akp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Gɔ silɔ dzɛmɔ ɔlo ikaɖe ne, manya sɔ Yesu ɔnɔwɛ̃ lokuti ɔɣɛ i mmɔ. Marasuãdze ɔma kanya i ara wagbe iso. Maiɣere kuwɛ̃ nnɛ manya ku ɔwi gɔmɔ ame. ");
INSERT INTO akp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Gɔ kaɖe ɔsɛ̃ ne, Yesu gu ɔ̃ marasuãdze itɛ mammɔ ɔso mabɔrɛ i kube iso maba. Maturi gbodzoo ɔba maasarɛgu wũ. ");
INSERT INTO akp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ne ɔrɛrɛ̃ ɔwɛ̃ i mmɔ to ɔla kulu ɔɣɛ sɔ, “Ratedze! Loto-ɔ i kukpa, nyɔ wũ ɔbi! Wũ ɔbi ɔwɛ̃ saã! ");
INSERT INTO akp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Siwarã lalaa ɔ to siɖaa wũ gɔ sito sitã sɔ ɔ̃ala kulu teteree, ɔluwɛ̃ sipuri wũ siwuĩ i karɔ̃ iyɔ minyatu ka misɛ wũ i kanya. Si iba ngbɔ ne, isɛ ibua iwe ɔle, ina ɔpã fiɛ isɛ ikpa wũ. ");
INSERT INTO akp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Lotã fɔ marasuãdze iti sɔ masa siwarã dzɛgbe matã me ɣɛɛ maiwo.” ");
INSERT INTO akp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Mmɔ i Yesu to ɔɣere ma sɔ, “Mi kiniɔgbe maturi ma kafɔkaɖe lotɛgɛlɛ fiɛ miba atsuele! Ku mme ɔwi loawe i mi kɔrɛ fiɛ loaɣara so lotã mi lotui?” Ne ɔɣere ɔrɛrɛ̃ gɔmɔ sɔ, “Kɔ fɔ ɔbi bɔ me ngbe.” ");
INSERT INTO akp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Gɔ ɔbi to ɔba ne, ɔluwɛ̃ siwarã ɔpuri wũ siwuĩ i karɔ̃ ɔleso ɔto. Ne Yesu ɔtɔ̃me ɔpia siwarã lalaa dzɛmɔ ɔsa ɔbi ɔtara wũ ɔta ɔ̃ ɔse ne. ");
INSERT INTO akp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ɣaa ɔle siare gɔgbe ɔbara maturi ɔɖuɖu ɣii. Gɔ Yesu Kurabarara togu maturi ibara ɣii ne, ɔɣere ɔ̃ marasuãdze sɔ, ");
INSERT INTO akp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Midaaɣara nnɛ nto loba loaɣere mi! Mato maaɖi mme, Ɔturi Awune Ɔbi, matã maturi.” ");
INSERT INTO akp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ɣɛɛ mainɔ nnɛ ɔɣere ma karɔ̃. Ɣaa ɔsu ira nɛgbe ɔkɔla ma sɔ mainɔ karɔ̃ fiɛ mato manigã sɔ maakarɛ wũ ana. ");
INSERT INTO akp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kakpadzɛ̃ ɔba i marasuãdze ndɛ̃ sɔ ma nna nɖe ngɔ loɖo pelepele. ");
INSERT INTO akp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Gɔ Yesu ɔtsue ma adzuni ɔso ne, ɔkɔ ɔbiɛtɛ ɔwɛ̃ ɔba ɔ̃aɣedza ma i katɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ne ɔto ɔɣere ma sɔ, “Ɔbiara gɔ loafɔ ɔbiɛtɛ gɔgbe i wũ iyere ame ne, mme iɖe ɔfɔ. Fiɛ ɔbiara gɔ lofɔ me ne, ɔfɔ ngɔ lopia me katɔ̃me. Alasɔ ɔturi gɔ nsɛ ɔbɔ so karɔ̃ i mi ɔɖuɖu ndɛ̃ ne, ɔ̃ nɖe ngɔ lokɔlɛ ɔɖo pelepele ne.” ");
INSERT INTO akp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Mmɔ i Yohanes to ɔɣere wũ sɔ, “Bokɔse, bonya ɔwɛ̃ gɔ ɔto ɔsa siwarã lalaa i fɔ iyere ame ɣɛɛ ne, botindza wũ sɔ ɔnyua ala ɔ̃iɖe bo ndɛ̃ ɔwɛ̃.” ");
INSERT INTO akp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ne Yesu to ɔɣere ɔ̃ marasuãdze sɔ, “Midaatɛ̃ wũ ɔri, alasɔ si ɔturi iita ɔɣɛ mi iso ne, mitsue sɔ ɔɣɛ mi i kama.” ");
INSERT INTO akp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Gɔ ɔwi gɔ i Ɣaa aasu Yesu ɔkɛlɛgu kato ɔɔpɛtɛpɛtɛ ne, ɔbara ɔ̃ adzuni sɔ ɔ̃akɛlɛ Yerusalem. ");
INSERT INTO akp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ɔpia mawɛ̃ ɔɖegu katɔ̃ sɔ masɛ maaledza ara masɛ i Samaria akorowa awɛ̃ matã ɔ̃ iba. ");
INSERT INTO akp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ɣɛɛ gɔ mmɔ maturi ɔtsue sɔ Yerusalem ɔto ɔfe ɔkɛlɛ ɔso ne, maifɔ wũ. ");
INSERT INTO akp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Gɔ ɔ̃ marasuãdze inyɔ ma nɖe Yohanes gu Yakobo ɔnya ne, makarɛ wũ sɔ, “Bokɔse, ato abie sɔ bokpere ɔtɔ si ɔbɔrɛ i kato ɔba ɔ̃atsuedza ma?” ");
INSERT INTO akp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ne Yesu ɔfiniki ɔsɛ̃ ma sɔ, “Miiɣe siwarã dzɛ nto siɖe mi iso! Alasɔ mme, Ɔturi Awune Ɔbi, iiba sɔ loawɔra maturi ngbã ɣɛɛ ɔba loba sɔ loaɖi me bowũ.” ");
INSERT INTO akp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ne ɔ̃ gu marasuãdze ɔrui makɛlɛ ɔmagɛ̃ mama ame ne. ");
INSERT INTO akp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Gɔ mato makɛlɛ ne, ɔrɛrɛ̃ ɔwɛ̃ ɔba ɔ̃aɣere Yesu sɔ, “Loasiai-ɔ kakɔi biara ga aakɛlɛ.” ");
INSERT INTO akp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ne Yesu ɔtã wũ mmuai sɔ, “Mabɔi lalaa ba awo wa ame masɛ mawɛrɛ fiɛ kurodzai ana ba ayo, ɣɛɛ mme, Ɔturi Awune Ɔbi, na iti kasiakɔ̃.” ");
INSERT INTO akp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ne Yesu to ɔɣere ɔmama ana sɔ, “Siai me.” Ɣɛɛ ngɔmɔ ɔtã wũ mmuai sɔ, “Bosate, loasiai-ɔ, ɣɛɛ ɖi me ɔri si nsɛ loabiara tete tɔtɔ.” ");
INSERT INTO akp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ne Yesu to ɔɣere wũ sɔ, “Tã mma nse lɛ makpise si mabiara ma makpise, ɣɛɛ fɔ ne kɛlɛ aaɣɛ Ɣaa sigarakaɖekɔ̃ itɔ̃me.” ");
INSERT INTO akp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ɔwɛ̃ ana ɔɣɛ sɔ, “Bosate lobie sɔ loasiai-ɔ, ɣɛɛ ne, tã me losɛ loamala wũ maturi so tɔtɔ.” ");
INSERT INTO akp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ne Yesu ɔɣere wũ sɔ, “Ngɔ loisɛ ɔbara ɔ̃ karabara ku ɔ̃ ɔtu ɔɖuɖu iikote ɔtã Ɣaa sigarakaɖekɔ̃.” ");
INSERT INTO akp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nnɛgbe kama ne, Bosate ɔɖi marɛrɛ̃ sikɔdzɛ-inyɔ mama gɔ ɔpia ma inyɔ inyɔ, ɔɣere ma sɔ maɖe wũ katɔ̃ makɛlɛ simagɛ̃ gu ngorowase mɛ ame ɔto ɔbie sɔ ɔ̃asɛ. ");
INSERT INTO akp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ɔɣere ma sɔ, “Ɔraɖui gɔ maasɔrɛ̃ ɔsi ɣɛɛ marabaradze iisi. Ne ɔso mitã kakpɛkɔ̃ sate iti sɔ ɔsese marabaradze ɔ̃ kakpɛkɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mikɛlɛ! Nto lopia mi lɛ masɛrɛrerɔ̃ abi i magidi ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Midaasu sikã kawumi ɣee ndokota ɣee akpo mila. Midaatui i ɔri sɔ mito miya kuwɛ̃. ");
INSERT INTO akp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Iyo biara nɛ ame miabo ne, miɖe katɔ̃ miɣere ma sɔ, ‘Isobuɛ itã iyo nɛgbe maturi.’ ");
INSERT INTO akp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Si ngɔ nsɛ ɔɖɔɛ isobuɛ pia i iyo nɛmɔ ame ne, mitã sɔ mi isobuɛ si isiai wũ. Ɣɛɛ si kuwɛ̃ na ngbɔ ne, misu mi isobuɛ kaya miruigu. ");
INSERT INTO akp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Miwe i iyo biara nɛ ame maafɔ mi. Araɖea igbã biara nɛ maatã mi ne, miɖe si minɛ. Ikote sɔ maatã rabaradze ɔ̃ aɖera. Midaawe mikiki, mibɔrɛ i iyo nɛ ame mikɛlɛ imama ame. ");
INSERT INTO akp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ɔmagɛ̃ biara gɔ ame maafɔ mi ne, miɖe nnɛ masu matã mi. ");
INSERT INTO akp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Misa manyɛse i ɔmagɛ̃ gɔmɔ ame si miɣere ma sɔ, ‘Ɣaa sigara ɔɖewi ɔɔbore ɔbo mi.’ ");
INSERT INTO akp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ɣɛɛ si misɛ ɔmagɛ̃ ɔrere ame fiɛ maifɔ mi ne, mirui mikɛlɛ ma itiri si miɣere ma sɔ, ");
INSERT INTO akp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Mi ɔmagɛ̃ ame ɔsebu gɔ lota ɔfere bo i ngba kɔra ne, boɔkpakpa bofere mi. Ɣɛɛ minyigi sɔ Ɣaa sigara ɔɖewi ɔɔbore ɔbo mi!’ ");
INSERT INTO akp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nto losia ita lotã mi sɔ iase pɔkɔsɔɔ itã Sodom ɔmagɛ̃ iɖo ɔmagɛ̃ gɔmɔ maturi! ");
INSERT INTO akp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ndzo miɖe mitã mi Korazin maturi! Fiɛ ndzo miɖe mitã mi Betsaida maturi! Alasɔ si awawãra wa igbã lobara i mi ame iɖe lobara i Tiro gu Sidon simagɛ̃ ame ne, tee maakpase masɛ i ndɔ̃ ame mapia ara wa loate sɔ maɔfiniki mabɔrɛ i ma akpi ame! ");
INSERT INTO akp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ɣaa to ɔ̃anyɔ Tiro gu Sidon simagɛ̃ nnya ɔɖo mi ku atɔ̃me iɣɛyi. ");
INSERT INTO akp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mi Kapernaum maturi ne, i mi adzuni ame ne, mito mibie sɔ miakɔlɛ so misɛ miabo kato, ɣɛɛ Ɣaa to ɔ̃abɔ mi karɔ̃ mikɛlɛ ta ikpibiɔ!” ");
INSERT INTO akp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mmɔ i Yesu to ɔɣere ɔ̃ marasuãdze sɔ, “Ɔbiara gɔ loakã mi atsue ne, mme iɖe ɔkã atsue fiɛ ɔbiara gɔ loasɛ̃ mi ne, mme iɖe ɔsɛ̃. Ɔbiara gɔ loasɛ̃ me ne, ngɔ lopia me katɔ̃me ɔsɛ̃.” ");
INSERT INTO akp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Maturi sikɔdzɛ-inyɔ mamɔ ɔkpese maba ku isoɣɔ maba maaɣere wũ sɔ, “Bosate, ta siwarã lalaa to sikã bo atsue i fɔ iyere ame.” ");
INSERT INTO akp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ne Yesu to ɔɣere ma sɔ, “Lonya Ɔbosam ɔkpase ɔbɔrɛ i kato lɛ kumɛgɔ i kado sɛ ɔma awe. ");
INSERT INTO akp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mikã atsue! Lotã mi ɔle sɔ miawo maɣɛ gu siboitɛtɛ iso ɔnene ɣɛɛ kuira iibabara mi. Miaɖe Tsirise ɔle ɔɖuɖu iso fiɛ kuira iibabara mi. ");
INSERT INTO akp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","So si sidaaɣɔ mi sɔ siwarã lalaa to sikã mi atsue. Ɣɛɛ so si siɣɔ mi sɔ Ɣaa ɔtsɛrɛ mi aɣere ɔpia i ɔ̃ sigarakaɖekɔ̃ ɔko ame.” ");
INSERT INTO akp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ɔwi gɔmɔ ame ne, Siwarã Bielea isoɣɔ ɔbo i Yesu ame ɔɖuɖu ne ɔɣɛ sɔ, “Tete, Kato gu Karɔ̃ Sate, nto lole-ɔ sɔ asu ara wa lowɛrɛ manɔgbadze gu makotsuese ne, aɖi wã ate mabiɛtɛ. Fiɛ gbaã ne, Tete, ngbɔ ikote-ɔ ne.” ");
INSERT INTO akp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mmɔ ɔtsɛ ma iɣere sɔ, “Tete ɔsu ara ɔɖuɖu ɔpia me i nrɔɔ̃ ame. Kuwɛ̃kuwɛ̃ iiɣe Ɔbi iɖo Ɔse ɔnɔwɛ̃, fiɛ kuwɛ̃ ana iiɣe Ɔse iɖo Ɔbi gu mma i Ɔbi ɔbie sɔ ɔ̃aɖi ɔ̃ Ɔse ɔte.” ");
INSERT INTO akp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ne Yesu ɔfiniki ɔnyɔ ɔ̃ marasuãdze i iwɛrɛ ame ɔɣere ma sɔ, “So si siɣɔ mi gbaã sɔ mito minya ara wa mito minya i ngbe! ");
INSERT INTO akp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nto loɣere mi sɔ ne, Ɣaa kanyamaɖidze gbodzoo gu magara ana ɔbie teteree sɔ manya ara wa mito minya, ɣɛɛ mainya, ɣee si manɔ ara wa mito minɔ, ɣɛɛ mainɔ.” ");
INSERT INTO akp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mmaratedze ɔwɛ̃ ɔba Yesu kɔrɛ sɔ si ɔba ɔ̃ala Yesu ɔnyɔ. Ɔkarɛ wũ sɔ, “Ratedze, be loabara fiɛ loana ngbã mɛ loisɛ miro?” ");
INSERT INTO akp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ne Yesu ɔta wũ mmuai ɔkarɛ wũ sɔ, “Be i Ɔko Sekelea Ɔɣɛ? Fiɛ nda anɔ itɔ̃me nɛmɔ karɔ̃?” ");
INSERT INTO akp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ne ɔrɛrɛ̃ gɔmɔ to ɔɣere wũ sɔ, “Ɖɔɛ Bosate Ɣaa ku fɔ ɔtu ɔɖuɖu ku fɔ siwarã ɔɖuɖu ku fɔ ɔle ɔɖuɖu ku fɔ adzuni ɔɖuɖu ana si aɖɔɛ fɔ ɔnyii lɛ kumɛgɔ ato aɖɔɛ so.” ");
INSERT INTO akp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ne Yesu to ɔɣere wũ sɔ, “Gbaã iɖe. Bara ngbɔ ne ato aasɛ ngbã.” ");
INSERT INTO akp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ɣɛɛ gɔ mmaratedze gɔgbe to ɔbie sɔ ɔ̃atã so ibɛ ɔso ne, ɔledza Yesu i karɛ sɔ, “Nna nɖe wũ ɔnyii?” ");
INSERT INTO akp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ne Yesu to ɔɣere wũ sɔ, “Ɔwi ɔwɛ̃ ame ne, ɔrɛrɛ̃ ɔwɛ̃ ɔbɔrɛ i Yerusalem isɛ ɔto ɔkɛlɛ Yeriko ɔmagɛ̃ ame. Mayukukpe ɔsɛ maamɔɛ̃ wũ i ɔri iso, mapɛ wũ maɖi wũ igbɛ maɖi ta ɔ̃ iso ara fiɛ manyua wũ masɛ sɔ ka ɔtsɔra ɔkpi. ");
INSERT INTO akp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Iba sɔ Ɣaa sɔrɛdze ɔwɛ̃ to ɔfe i ɔri gɔmɔ iso. Ɣɛɛ gɔ ɔnya ngɔ maɖi igbɛ i ɔri kuruɛ ne, ɔki isɛ isɛ ɔfe. ");
INSERT INTO akp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Iifɔ ɔwi, ɔ Levise ɔwɛ̃ ɔ̃ wũ ɔba ɔ̃aki i mmɔ ɔfe. Gɔ ɔnya ɔrɛrɛ̃ gɔgbe ne, ɔki i kuruɛ ɔfe. ");
INSERT INTO akp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ɣɛɛ ɔ Samariase ɔwɛ̃ gɔ nto ɔfe i ɔri gɔmɔ iso ne, gɔ ɔba ɔ̃anya ɔrɛrɛ̃ gɔgbe ne, ɔ̃ ara ɔɖo wũ kayiri. ");
INSERT INTO akp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ɔbore ɔbo wũ, ɔsu nnɔĩ gu ndã ɔnukutu wũ aɣɛi ame ɔnyi wã kukaakɔ. Ɔputa ɔrɛrɛ̃ gɔgbe ɔsia i ɔ̃ mɔmɔ bɔi iso. Ɔkɔ wũ ɔkɛlɛgu mafɔ kafɔkɔ̃ fiɛ ka ɔnyɔ wũ iso. ");
INSERT INTO akp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Gɔ kaɖe ɔsɛ̃ ne, ɔɖi sikã ɔtã mafɔ kafɔkɔ̃ nyɔisose ɔɣere wũ sɔ, ‘La ɔɔnyɔ wũ iso. Si loɔkpese loba ne, loatã-ɔ ira biara nɛ aledza inina i ɔ̃ iso.’ ” ");
INSERT INTO akp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ne Yesu to ɔkarɛ mmaratedze gɔgbe sɔ, “I fɔ adzuni kanya ne, maturi itɛ magbe ndɛ̃ ne, nna afɔ aɖe sɔ ɔɖe ɔnyii ɔtã ngɔ lobo i mayukukpe nrɔɔ̃ ame?” ");
INSERT INTO akp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ne mmaratedze to ɔtã mmuai sɔ, “Ngɔ lonyɔ wũ nnya.” Ne Yesu to ɔɣere wũ sɔ, “Fɔ wũ kɛlɛ si asɛ aabara ngbɔ.” ");
INSERT INTO akp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Gɔ Yesu gu ɔ̃ marasuãdze ɔrui maɣo ɔri ne, masɛ maabo ɔmagɛ̃ ɔwɛ̃ ame. Mmɔ masɛ maatu ɔrɔ̃go ɔwɛ̃ gɔ marɔ Marta fiɛ ɔfɔ ma i ɔ̃ iyo ne. ");
INSERT INTO akp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta ba ɔnyiibi gɔ marɔ sɔ Maria. Ɔ̃ ne, ɔkpase ɔsɛ i Yesu katɔ̃ ɔto ɔnɔ ɔ̃ ara wa ɔto ɔte. ");
INSERT INTO akp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Iyo karabara ɔɖuɖu ɔba kaasia i Marta ɔnɔwɛ̃ iso gɔ iɖaa wũ ɔtu. Ne ɔso ɔba ɔ̃aɣere Yesu sɔ, “Bosate, gɔ wũ ɔnyiibi ɔnyua iyo karabara ɔɖuɖu ɔsia me i iso ne, aibaɣere wũ kuira? Ɣere wũ sɔ ɔba ɔ̃abuai me!” ");
INSERT INTO akp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mmɔ i Yesu to ɔɣere wũ sɔ, “O Marta, ato aɖaa so i ara gbodzoo iso lo! ");
INSERT INTO akp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ɣɛɛ ne, ira ka iwɛ̃ pɛ lonya sɔ aabie, fiɛ isɛɛ nɛmɔ i Maria ɔɖi gɔ kuwɛ̃ iisibafɔ wũ ne iso.” ");
INSERT INTO akp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Iyi iwɛ̃ ne, Yesu ɔwe i kakɔi kawɛ̃ ɔto ɔkparama kayi. Gɔ ɔro ne, ɔ̃ marasuãdze mawɛ̃ ɔba ɔ̃ kɔrɛ maɣere wũ sɔ, “Bosate, te bo kumɛgɔ boakparama kayi lɛ Yohanes ɔte ɔ̃ marasuãdze awe.” ");
INSERT INTO akp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ne Yesu to ɔɣere ma sɔ, “Si mito mikparama kayi ne, miɣɛ sɔ, ‘Bo ɔse, tã sɔ boarɔ fɔ iyere i kuwarɛ ame. Fɔ sigara iɖe si iba i bo ndɛ̃. Tã bobara fɔ kuɖɔɛ i karɔ̃ iso lɛ masɛ mabara i kato. ");
INSERT INTO akp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tã bo ikpɛnɛ ame araɖea iyi biara. ");
INSERT INTO akp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Si asu bo akpi atsɛ bo, alasɔ bo wũ bosɛ bosu botsɛ ɔturi biara gɔ loɣɛrɛ bo. Daatã sɔ boabo i kalakanyɔ ame. Ɣɛɛ ɖi bo borɛgu i akpi ame.’ ” ");
INSERT INTO akp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ne Yesu to ɔɣere ɔ̃ marasuãdze sɔ, “Si mi ndɛ̃ ɔrere ɔsɛ ɔ̃ ɔlaa iyo ku kasɛ̃ ndɛ̃ ɔsɛ ɔ̃atara wũ sɔ, ‘Wũ ɔlaa, nyɛ abolo abo atɛ tã me, ");
INSERT INTO akp_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","alasɔ wũ ɔlaa ɔwɛ̃ ɔse i ɔri ɔba ɔ̃abo me kiniɔ, ɣɛɛ lona ku araɖea wa loatã wũ!’ ");
INSERT INTO akp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Si fɔ ɔlaa gɔmɔ ɔɣere-ɔ sɔ, ‘Daaba aaɖa me! Bo gu wũ mabi ka borɛ fiɛ boɔsɛ̃ akui ana. Loisibawo ɔledza ita iba iatã-ɔ kuira.’ ");
INSERT INTO akp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Si iba ngbɔ ne, be iɖe aabara? Nto loɣere mi sɔ si kulaa kerekere ɔso ne, ɔ̃ibata. Ɣɛɛ kumɛgɔ aɣɛ atogu wũ iti itã ɔso ne, ɔto ɔ̃ata ɔtã-ɔ ira biara nɛ ato abie. ");
INSERT INTO akp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ne ɔso nto loɣere mi sɔ, mikarɛ ara si maatã mi ara, mibie ara si miana, mipɛ kukui kɔrɔ̃ si maasese mi iyo. ");
INSERT INTO akp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Alasɔ ɔbiara gɔ nsɛ ɔkarɛ ira ne, ɔsɛ ɔfɔ. Ɔbiara gɔ nsɛ ɔbie ira ne, ɔsɛ ɔna ne, fiɛ ɔbiara gɔ nsɛ ɔkpura kukui kɔrɔ̃ ne, masɛ masese matã wũ. ");
INSERT INTO akp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Fiɛ mi ma nɖe maɣese ne, mi ɔwɛ̃ aasu aɣɛ ɔtã ɔ̃ ɔbi si ɔkarɛ wũ ikpɛ? ");
INSERT INTO akp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ɣee ɔsu ɔboitɛtɛ ɔtã wũ si ɔkarɛ wũ ikɔkɔɣɔ? ");
INSERT INTO akp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Si mi ma nɖe makpibaradze kɔra ɣe kumɛgɔ miasu ara sɛɛ mitã mi mabi ne, iyɔ mi ɔse gɔ mpia i kato ɣɛɛ? Be ɔso ɔ̃ibasu ɔ̃ Siwarã Bielea ɔtã mma nto makarɛ wũ?” ");
INSERT INTO akp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ɔwi ɔwɛ̃ ne, Yesu to ɔsa siwarã lalaa dzɛ lotã sɔ ɔturi iito ɔwo ika ɔɖe. Ne gɔ siwarã dzɛmɔ ɔbɔrɛ i ɔmumu gɔmɔ ame ne, ɔtsɛ ika iɖe ne ɔso ibara mma nɣɛ i mmɔ ɣii. ");
INSERT INTO akp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ɣɛɛ ma ndɛ̃ mawɛ̃ ɔɣɛ sɔ, “Siwarã lalaa igara Beelzebul ɔɖe lotã wũ ɔle gɔ ɔsu ɔto ɔsa siwarã lalaa ɔɖi.” ");
INSERT INTO akp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mawɛ̃ ana ɔla Yesu manyɔ ne ɔso maɣere wũ sɔ ɔbara iwawãra ɔte sɔ Ɣaa kɔrɛ ɔbɔrɛ. ");
INSERT INTO akp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ɣɛɛ Yesu ɣe nnɛ mpia i ma adzuni ame. Ne ɔso ɔɣere ma sɔ, “Karɔ̃ biara ga maturi loɣɛɣɛ so mato makpɛ̃gu so ne, karɔ̃ gamɔ to kaakpese ikpakpi. Ngbɔ ame si iyo irere maturi ɔta maɣɛ so iso mato makpɛ̃gu so ne, iyo nɛmɔ to iasasame. ");
INSERT INTO akp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ne ɔso si Ɔbosam sigarakaɖekɔ̃ ɔta siɣɛ so iso ne, nda i sigarakaɖekɔ̃ dzɛmɔ aawo ɔya? Nto loɣɛ ngbɔ ala mito miɣɛ sɔ nto losa siwarã lalaa i Beelzebul iyere ame. ");
INSERT INTO akp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Si Beelzebul ɔle iso nto losa sɛ̃ ne, nna ɔle iso i mi masiaidze to masa siwarã lalaa maɖi i maturi ame? Mi mɔmɔ masiaidze to maatã mi ipɔ. ");
INSERT INTO akp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ɣɛɛ si Ɣaa Siwarã ɔle ame nto losa siwarã lalaa ne, mitsue kukaakɔ sɔ Ɣaa sigara ɔɖewi ɔɔba ɔ̃abo mi ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Si ɔturi gɔ mba ɔle ɔnyɔme akpadza ɔto ɔdzuɛ̃ ɔ̃ iyo ne, ɔ̃ kuira iibayu. ");
INSERT INTO akp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ɣɛɛ si ngɔ mba ɔle ɔɖo wũ ɔba ɔ̃akpɛ̃gu wũ fiɛ ɔɖe wũ iso ne, ɔto ɔ̃afɔ ɔ̃ akpakpɛ̃ra wa ɔɖuɖu ɔsu ɔto ɔdzuɛ̃ so ala ɔsu ɔ̃ karana ɔ̃aɣɛɣɛ ɔ̃ malaa. ");
INSERT INTO akp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ngɔ loiɣɛgu me ne, mitsue sɔ ɔta ɔɣɛ me iso gbaã. Ngɔ loito ɔsagu me ara kanya ne, ɔto ɔsamarã ara. ");
INSERT INTO akp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Si masa siwarã lalaa maɖi i ɔturi ame ne, sisɛ sikɛlɛ siawe siki sibie kawekɔ̃ i kakorekɔ̃. Si siina kukakɔi ne, sisɛ siɣere so sɔ, ‘Loakpese lokɛlɛ iyo nɛ ame masa me maɖi.’ ");
INSERT INTO akp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ne ɔso siaba sianya sɔ maɔfiɛ iyo nɛmɔ ame maledza ira biara se kukaakɔ. ");
INSERT INTO akp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Iyɔ siakpese sikɛlɛ siakɔ siwarã lalaa aka akɔdzɛ mama dzɛ lonyanyarĩ siɖo sɛ̃ sibua so iso. Maabo i ngɔmɔ ame mawe, ne ɔso ɔ̃ kawirikɔ̃ to kaanyanyarĩ kaɖo ɔ̃ karɔ̃kasɛkɔ̃.” ");
INSERT INTO akp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Gɔ Yesu ɔɣɛ ara wagbe ɔro ne, ɔrɔ̃go ɔwɛ̃ i maturi ndɛ̃ mmɔ ɔla kulu ɔɣɛ sɔ, “So aaɣɔ ɔrɔ̃go gɔ loɣe-ɔ gu ngɔ lotã-ɔ inyɛ ameme!” ");
INSERT INTO akp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ne Yesu to ɔtã wũ mmuai sɔ, “Mma nto manɔ Ɣaa itɔ̃me fiɛ mato mabara i ne iso i so aaɣɔ!” ");
INSERT INTO akp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Gɔ maturi ma loki malɔ Yesu ɔɔsi mabua ne, ɔɣere ma sɔ, “Minyɔ kumɛgɔ kiniɔgbe maturi ba ɔtile! Mato mabie awawãra sɔ maanya ɣɛɛ maibanya kuiwɛ̃ iɖo Ɣaa kanyaɖidze Yona ire igbã. ");
INSERT INTO akp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kumɛgɔ ame i Ɣaa kanyaɖidze Yona ɔɖe ikparĩ ɔtã Niniwe maturi ne, ngbɔ ame i Ɔturi Awune Ɔbi ana aaɖe ikparĩ ɔta kiniɔgbe maturi ne. ");
INSERT INTO akp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Atɔ̃me iɣɛyi ne, Igararɔ̃go gɔ lobɔrɛ i bo karɔ̃ kala isɛ to ɔ̃ata ɔya ɔtã mi kiniɔgbe maturi ipɔ, alasɔ ɔsɛ ɔri dzoroo ɔbɔrɛ i kayi iti tsɔra ɔba ɔ̃akã Salomo atɔ̃me wa ame i inɔgba pia atsue. Ɣɛɛ nto loɣere mi sɔ ngɔ inɔgba loɖo Salomo ire pia i mi ndɛ̃ ngbe. ");
INSERT INTO akp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Niniwe maturi to maata maya masɔ̃ mi arɔĩ i katɔ̃ ku atɔ̃me iɣɛyi. Alasɔ ɔwi gɔ i Yona ɔɣere ma Ɣaa itɔ̃me ne, mafiniki i ma ara lalaa wa mato mabara ame. Ɣɛɛ nto loɣere mi sɔ ne, ngɔ loɖo Yona pia i mi ndɛ̃ ngbe! ");
INSERT INTO akp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Kuwɛ̃ iisɛ ɔtsue ɔkãniɛ ɔsu ɔwɛrɛra ɣee ɔfu ara. Ɣɛɛ ɔsɛ ɔtara ɔsia i ngbegɔ i maturi ma loabo iyo aanya kukaakɔ. ");
INSERT INTO akp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ɔturi anɔmi nɖe ɔkaniɛ atã wũ. Si fɔ anɔmi to anya kukaakɔ ne, iyɔ fɔ ame ɔɖuɖu ɔkpa. Ɣɛɛ si fɔ anɔmi iito anya kukaakɔ ne, idududu sɔɔ̃ iɖe i fɔ ame. ");
INSERT INTO akp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ne ɔso nyɔ sɔ aibatã ikpawaĩ nɛ mpia i fɔ ame ɔkpese idududu. ");
INSERT INTO akp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Si ikpawaĩ ɔyi i fɔ ame ɔɖuɖu fiɛ fɔ kukakɔi na i idududu ame ne, tsue sɔ fɔ iso ɔɖuɖu ɔɔkpa lɛ kumɛgɔ matsue ɔkaniɛ masia i ira iso fiɛ iyo ɔɖuɖu ame ɔkpa awe.” ");
INSERT INTO akp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Gɔ Yesu ɔɖe ika ɔro ne, ɔ Farisise ɔwɛ̃ ɔkpere wũ sɔ ɔba ɔ̃aɖe ara i ɔ̃ iyo. Ɔkɛlɛ ɔsɛ ɔ̃asɛ i iyo ame sɔ maaɖe ara. ");
INSERT INTO akp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ibara ɔ Farisise gɔmɔ ɣii gɔ ɔnya sɔ Yesu iifore nrɔɔ̃ lɛ kumɛgɔ i kubarara ɔte kanya fiɛ ɔtsɛ aɖera iɖe. ");
INSERT INTO akp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ne ɔso Bosate ɔɣere wũ sɔ, “Mi ma Farisise ne, misɛ mifore mi aɖerɔi gu akɔi kama ɣɛɛ ne, mi ame ɔyigu ɔtile gu anyanyara ɔɖuɖu ibara. ");
INSERT INTO akp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Madzimifɔ! Ɣaa gɔ lobara ira kama ne, iiɖe ɔ̃ ame lobara kame ne? ");
INSERT INTO akp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Misu ira biara nɛ mpia i mi arɔi gu akɔi ame mitã mawɛrɛba si mi ira biara aakpa sekelee i Ɣaa katɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ndzo miɖe mitã mi ma Farisise! Misɛ miɖi mi araɖea ika weova ta aposarɛbi, ibura, sikɔma agbãagbã mitã Ɣaa. Ɣɛɛ misɛ̃ sɔ miibaɣɛ atɔ̃me i ɔri iso fiɛ miiɖɔɛ Ɣaa ana. Ara wagbe ikote sɔ miasu mibua i nwa mimɔɛ̃ mito iso ne. Ɣɛɛ miibanyua kuiwɛ̃ misɛ. ");
INSERT INTO akp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ndzo miɖe mitã mi ma Farisise! Alasɔ misɛ mibie nsɛkɔ̃ kɔlɛa i mi kusarɛkɔ̃. Misɛ mibie sɔ maturi si maya mi ku karɔ̃ ibɔso i kuɣa ame. ");
INSERT INTO akp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Ndzo miɖe mitã mi, alasɔ mise lɛ akpibiɔ wa maisɛ ikpo fiɛ maturi sɛ maki i wã iso i idaatsue ame.” ");
INSERT INTO akp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mmɔ i mmaratedze ɔwɛ̃ i ma ndɛ̃ to ɔɣere wũ sɔ, “Ratedze, Si aɣɛ ngbɔ ne, ato atia bo bo wũ.” ");
INSERT INTO akp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ne Yesu ɔtã wũ mmuai sɔ, “Ndzo miɖe mitã mi mmara matedze ana. Ato wa i maturi iibawo ɔsore ne, wã aɖe misu misorera ma fiɛ miito mibara adzuni sɔ miabuai ma masore wã. ");
INSERT INTO akp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Ndzo miɖe mitã mi alasɔ mitsue Ɣaa kanyamaɖidze ma loɔkpi akpibiɔ, ɣɛɛ ne, mi mawa loɖoe ma. ");
INSERT INTO akp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Fiɛ mi mɔmɔ to mitɔrã misia sɔ ara wa i mi mawa ɔbara ne, apia mi isoɣɔ. Maɖoe Ɣaa kanyamaɖidze, ne mi wũ miɔtsue ma akpibiɔ ne. ");
INSERT INTO akp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nnɛgbe ɔso i Ɣaa iwola ɔɣɛ sɔ, ‘Loasese wũ kanyamaɖidze gu makpabo i ma ndɛ̃, maaɖoe mawɛ̃, makpɛ̃gu mawɛ̃.’ ");
INSERT INTO akp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ne ɔso kiniɔgbe maturi ɔɖuɖu ne, mato maakpadzɛ̃ ma kutsue i Ɣaa kanyamaɖidze ma ɔɖuɖu maɔɖoe, ita i karɔ̃kasɛkɔ̃ iba iabo kiniɔ. ");
INSERT INTO akp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ita i ɔwi gɔ maɖoe Abel isɛ iabo Zakaria gɔ maɖoe i isɔrɛkasege gu ngbegɔ marɔ sɔ kasekelekɔ̃ ndɛ̃. Gbaã nto loɣere mi sɔ Ɣaa to ɔ̃akpadzɛ̃ kiniɔgbe maturi kutsue i ma ɔɖuɖu iti! ");
INSERT INTO akp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ndzo miɖe mitã mi mmara matedze! Alasɔ iyo nɛ ame i iwola pia ne, misɛ̃ ne akui misɛ. Mi mɔmɔ ne, misɛ̃ sɔ miito mibo i ne ame. Mma ana nto mabie sɔ maabo ne, mitɛ̃ ma ɔri sɔ madaabo.” ");
INSERT INTO akp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Gɔ Yesu ɔrui i mmɔ ne, ma Farisise gu mmara matedze ɔnagu wũ sikpã gbaã matsɛ wũ atɔ̃me ikpadzɛ̃ gu i ara agbãagbã iso. ");
INSERT INTO akp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Mabie ɔri gɔ iso maaki fiɛ ɔ̃aɣɛ inyakpi irere fiɛ maaya i ne iso matã wũ ipɔ. ");
INSERT INTO akp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Gɔ maturi kukpi kukpi ɔba maasakanya fiɛ mato malili so manene so ne, Yesu ɔtsɛ ɔ̃ marasuãdze iɣere sɔ, “Midzuɛ̃ so i ma Farisise mila ara wa loakpɔkpɔtɔra maturi iso. ");
INSERT INTO akp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ira biara nɛ mafu ara ne, mato maabusi ne. Fiɛ ira biara nɛ mabara i iwɛrɛ ame to iare kayi. ");
INSERT INTO akp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ne ɔso ibiara nɛ maɣɛ i idududu ame ne, ito iaba i inyamɔ. Awɛrɛra gu ara wa maɣɛ i iyo kame ɔɖuɖu ne, mato maapɛ wã imomo. ");
INSERT INTO akp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Wũ malaa, nto loɣere mi sɔ midaanigã mma loaɖoe siturina fiɛ ne kama ne, maisibawo kuira ɔbara. ");
INSERT INTO akp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ɔturi gɔ ikote sɔ mianigã ne, loaɖi wũ lote mi. Minigã Ɣaa gɔ si ɔ̃ɔɖoe ɔturi ɔro ne, ɔba ɔle ana sɔ ɔ̃asu wũ ɔpia i itɔkpe nɛ loisɛ inyi ame. Loaɣere mi sɔ ɔ̃ lokote sɔ mianigã ne. ");
INSERT INTO akp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Iiɖe kupɛrɛ kunyɔ masɛ marɔdɛ̃ kunagini kuru? Ɣɛɛ Ɣaa anɔ iisɛ ata i kukawɛ̃ iso. ");
INSERT INTO akp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mi ati siwɛrɛ̃ kɔra ne, Ɣaa ɣe sɛ̃ kusime. Ne ɔso ne, midaanigã alasɔ mifɔ kuɣa miɖo kunagini gbodzoo. ");
INSERT INTO akp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Loto loɣere mi kukaakɔ sɔ ngɔ loaya i maturi katɔ̃ ɔɣɛ sɔ wũ ɔre ɔɖe ne, Mme Ɔturi Awune Ɔbi mme wũ nto loaɣɛ ngbɔ ame i Ɣaa makpabo ɔɖuɖu katɔ̃ i ɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ɣɛɛ ɔbiara gɔ loasɛ̃ me i maturi katɔ̃ ne, Mme Ɔturi Awune Ɔbi mme wũ nto loasɛ̃ wũ i Ɣaa makpabo anɔ. ");
INSERT INTO akp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ɔturi biara gɔ loaɣɛ inyakpi i mme, Ɔturi Awune Ɔbi, iso ne, Ɣaa to ɔ̃asu ɔtsɛ wũ. Ɣɛɛ ngɔ loaɣɛ imusuora i Siwarã Bielea iso ne, Ɣaa iibasu ɔtsɛ wũ. ");
INSERT INTO akp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Si makpadzɛ̃ mi makɛlɛgu ma Yudase kasarɛkɔ̃ ɣee makpakpa ɣee magara katɔ̃ sɔ maaɣɛgu mi atɔ̃me ne, midaamararã so sɔ be miasɛ miaɣɛ ɣee nda miaɖi so kanya. ");
INSERT INTO akp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Alasɔ Siwarã Bielea to siate mi nnɛ miaɣɛ si ɔwi gɔmɔ ɔɔɣo.” ");
INSERT INTO akp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ɔrɛrɛ̃ ɔwɛ̃ i maturi ndɛ̃ i mmɔ ɔɣere Yesu sɔ, “Ratedze, ɣere wũ ɔnyiibi sɔ ɔtã boɣɛ so bo ɔse ara wa ɔnyua ɔsɛ bo.” ");
INSERT INTO akp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mmɔ i Yesu to ɔtã wũ mmuai sɔ, “Wũ ɔturi, nna lobara me atɔ̃meɣɛdze gu ngɔ loaɣɛ mi ara?” ");
INSERT INTO akp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ne Yesu to ɔɣere ma ɔɖuɖu sɔ, “Minyɔ tuee si minyɔ so i kanɔbɛbɛ biara iso, alasɔ ɔturi ngbã mɔmɔ na i ɔ̃ karana ga ɔba ame.” ");
INSERT INTO akp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ne Yesu to ɔpɛ ma igbã nɛgbe sɔ, “Ranase ɔwɛ̃ ɔwe gɔ karɔ̃ lolɛ kukaakɔ ɔso ɔ̃ ɔraɖui ɔbua ɔlɛ gbaã. ");
INSERT INTO akp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ne ɔso ɔɣere so sɔ, ‘Gɔ nna ngbegɔ loafere wũ ɔraɖui kiniɔ ne, be loabara? ");
INSERT INTO akp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“ ‘Nnɛ loabara nɖe sɔ, loabiɛbiɛ wũ siwu lotsue siɣɛtɛ dzɛ lomɔ siɖo ndzɛgbe. Iyɔ loana ngbegɔ loafere wũ ɔraɖui ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Loaɣere so sɔ, “Iti ɔbua ilɛ me. Ɔraɖui gɔ lona to ɔ̃ase akɔ akɔ. Loawarã, loɖe ara, lonɛ ara, lona isoɣɔ.” ’ ");
INSERT INTO akp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ɣɛɛ Ɣaa ɔɣere wũ sɔ, ‘Fɔ dzimifɔ! Kasɛ̃ gagbe ame nto loafɔ fɔ ngbã ne. Nna loaɖe ara wa ɔɖuɖu asakanya asɛ so ngbe?’ ” ");
INSERT INTO akp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ne Yesu ɔwirigu ma sɔ, “Ngbɔ iase itã ngɔ lotã karana ɔfu so ɣɛɛ ɔna kuira i Ɣaa anɔ ne.” ");
INSERT INTO akp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ne Yesu to ɔɣere ɔ̃ marasuãdze sɔ, “Ne ɔso nto loɣere mi sɔ midaamarã so i mi ngbã, nnɛ miaɖe gu nnɛ miapia iso. ");
INSERT INTO akp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ngbã ɔfɔ kuɣa miɖo aɖera fiɛ sosina ɔfɔ kuɣa siɖo arapia. ");
INSERT INTO akp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Minyɔ kukparodza gɔ i ɔwiri ame, kuisɛ kupɛ ɔraɖui, ngbɔ ame kuisɛ kusɔrɛ̃ ɔraɖui ana ne. Kuna siwu gu awumi. Ɣɛɛ Ɣaa sɛ ɔtã kɔ̃ aɖera. Mi ne, mifɔ kuɣa miɖo kukparodza kokooko. ");
INSERT INTO akp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mi nna loawo ikpɛnɛ iwɛ̃ ɔsu ɔbua i ɔ̃ agbanayi iso iki i imararãso ame? ");
INSERT INTO akp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Si miibawo kuira ɔbara i ara wiriwiria wagbe iso ne, iyɔ midaamararã so i ara mama iso. ");
INSERT INTO akp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Minyɔ kumɛgɔ adziri sɛ alɛ ɔnyɔ si afere aɣɔ̃la. Aisɛ ata ɖɔti ɣee awe ɔkati atã so. Ɣɛɛ loɣere mi sɔ, Igara Salomo kɔra si ɔkɛrɛ so ne, ɔ̃isɛ ɔlɛ ɔnyɔ lɛ kudziri gɔ lofere aɣɔ̃la. ");
INSERT INTO akp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ɣaa nsɛ ɔkɛrɛ sikua ngbɔ. Sikua dzɛ mpia nɔme kɔrãkaɖe maɔkpɛ̃ sɛ̃ mafere i ɔtɔ ame matsuedza. Si Ɣaa to ɔnyɔ sikua iso ngbɔ ne, ɔ̃ibabara ɔtã mi ma loɖo Sikua? Be ɔso i mi kafɔkaɖe ɔfoforo ngbɔ? ");
INSERT INTO akp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ne ɔso midaasu mi ɔtu misia i nnɛ miaɖe ɣee mianɛ iso, midaamararã so i ne iso. ");
INSERT INTO akp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Alasɔ mma loifɔ Ɣaa maɖe ne, ara wagbe iso masu ma ati masia ne. Mi ɔse ɣe ara wa ɔɖuɖu lonya mi. ");
INSERT INTO akp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ɣɛɛ ne, mila miɔbu iti ame i Ɣaa sigarakaɖekɔ̃ iso si ɔ̃asu ara wagbe ɔɖuɖu ɔbua mi. ");
INSERT INTO akp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Wũ masiaidze ma loisi, midaanigã. Alasɔ Ɣaa isoɣɔ iɖe sɔ ɔ̃atã mi ɔ̃ sigarakaɖekɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Misu mi iso ara mirɔdɛ̃ si mibara mi karana karabara i mawɛrɛba iso. Mibie sikã akpo wa loisɛ anina misɛ so i kato. Mmɔ ne, kaase kpoo, kuwɛ̃ iibapɛgu fiɛ kaibaro ana. Alasɔ yukukpe iibawo mmɔ ɔbo fiɛ makorokpɛ ma nsɛ manina ara ana iibawo mmɔ ɔbo. ");
INSERT INTO akp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Alasɔ ngbegɔ i fɔ karana se ne, mmɔ i fɔ ɔtu ana aawe ne. ");
INSERT INTO akp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Miledza so mitã ira biara nɛ loaba si mi sikaniɛ ana si sidaanyi ");
INSERT INTO akp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","lɛ maɖabo ma nto manyɔ ma ɔkɔse gɔ ngba ɔrɔ̃go kakɔkɔ̃ ɔri sɔ ɔ̃aba. Fiɛ si ɔba ɔ̃akpura kukui kɔrɔ̃ ne, maasese wũ ɔluwɛ̃. ");
INSERT INTO akp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Maɖabo mamɔ aana isoɣɔ si ma ɔkɔse aaba ɔ̃anya ma sɔ manyɔ tuee mato manyɔ ɔ̃ iba ɔri. Nto loɣere mi sɔ, ɔ̃akpasa ɔkati ɔtã masɛ i karɔ̃, ɔ̃ mɔmɔ ɔtã ma araɖea sɔ maɖe. ");
INSERT INTO akp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","So abua siɣɔ ma si ɔ̃aba ku kasɛ̃ ndɛ̃ ɣee ɔɖesɛrã ɔba ɔ̃anya sɔ manyɔ ne, sirɛ iisu ma. ");
INSERT INTO akp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kiniɔ ne, mitsue sɔ si iyosate ɣe ɔwi gɔ ame i yukukpe aaba ɔ̃ayu wũ ne, ɔ̃ibatã wũ ɔri sɔ ɔbiɛ ɔ̃ iyo ɔbo i kame. ");
INSERT INTO akp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ne ɔso mi wũ ne, minyɔ tuee alasɔ mme, Ɔturi Awune Ɔbi, to loaba loabɔrɛ mi iso ku ɔwi gɔ miito minyɔ ɔri.” ");
INSERT INTO akp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Mmɔ iɖe i Petro to ɔkarɛ Yesu sɔ, “Bosate, bo kere ato apɛ igbã nɛgbe ɛɛbɛrɛ maturi ɔɖɔɖu ato?” ");
INSERT INTO akp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mmɔ i Yesu to ɔɣɛ sɔ, “Ɔɖabo gɔ mba iwola fiɛ ɔsɛ ɔbara ara i ɔri iso ne, ɔ̃ i ɔ̃ ɔkɔse sɛ ɔsu ɔbara maɖabo tsɔra nyɔisose sɔ ɔ̃atã ma araɖea i ɔwi sɛɛ iso ne. ");
INSERT INTO akp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nyɔ, so to siaɣɔ ɔɖabo gɔmɔ gbaã, si ɔ̃ ɔkɔse ɔba ɔ̃anya sɔ ɔto ɔbara ngbɔ! ");
INSERT INTO akp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Gbaã ne, nto loɣere mi sɔ ɔkɔse gɔmɔ to ɔ̃asu ɔɖabo gɔgbe ɔsɛra i ɔ̃ ara ɔɖuɖu kanya. ");
INSERT INTO akp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ɣɛɛ si ɔɖabo gɔmɔ ɔɣere so sɔ, ‘Wũ ɔkɔse to ɔ̃awe ina ɔpã i ɔri gɔ ɔkpa ame,’ Ne ɔso ɔtsɛ ɔɖe gu ɔnɛ, ɔrɛ̃ ndã, ɔpɛ maɖabo tsɔra, marɛrɛ̃ gu marɔ̃go ɔɖuɖu ne, ");
INSERT INTO akp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ɔ̃ ɔkɔse to ɔ̃aba ɔ̃abo ku ɔwi gɔ i ɔɖabo iito ɔnyɔ wũ ɔri. Mmɔ ne, ɔ̃ ɔkɔse to ɔ̃akpadzɛ̃ wũ kutsue i matsuelese ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ɔɖabo gɔ nɣe ira nɛ i ɔ̃ ɔkɔse sɛ ɔbie sɔ ɔbara ɔtã wũ ɣɛɛ ɔsɛ̃ sɔ ɔ̃ito ɔbara ne, ipɛ to iabo wũ gbaã. ");
INSERT INTO akp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ɣɛɛ ɔɖabo gɔ loiɣe nnɛ i ɔ̃ ɔkɔse to ɔbie sɔ ɔbara fiɛ ɔbara nnɛ lokote itã ipɛ ne, ɔ̃ ipɛ iibafe isi. Ngɔ matã ara gbodzoo ne, mato maakarɛ ara gbodzoo mabɔrɛgu i ɔ̃ kɔrɛ. Ngɔ ana matã ara abua afe isi ne, ngbɔ ame maakarɛ mabɔrɛgu i ɔ̃ kɔrɛ ne. ");
INSERT INTO akp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ɣaa kutsue ikpadzɛ̃ nɛ nse lɛ ɔtɔ losu lobɔ kayiiso. Fiɛ wũ kayiri tee ɔtɔ gɔmɔ ɔɔwara. ");
INSERT INTO akp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ɣaa itupie iwɛ̃ to iaba me iso fiɛ lona iwarã kuiwɛ̃ gbɔgbɔɔgbɔ inyɛwe nɛgbe ɔwi ɔfe ɔro. ");
INSERT INTO akp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mibu sɔ isobuɛ iɖe losu lobɔ kayiiso? Ooɣo! Iiɖe isobuɛ losu lobɔ ɣɛɛ iɣɛɣɛ so iɖe. ");
INSERT INTO akp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ita i kiniɔ ne, iyo nɛ ame i maturi iru pia ne, mato maata maya so iso. Ma inyɔ to maata maya itɛ iso fiɛ itɛ ana to maata maya i inyɔ iso. ");
INSERT INTO akp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ɔse to ɔ̃ata ɔya i ɔ̃ ɔbi birɛrɛĩ iso fiɛ ɔbirɛrɛĩ to ɔ̃ata ɔya ɔ̃ ɔse iso. Mabi manyi to maata maya ma mabi birɔ̃gomi iso fiɛ mabirɔ̃gomi ana to maata maya ma manyi iso. Marã manyi to maata maya ma mabire iso fiɛ mabire ana to maata maya ma marã manyi iso.” ");
INSERT INTO akp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu ɔɣere ma ana sɔ, “Si minya sɔ adɔdɔ to abɔrɛ i kuɣɛ̃ iyo kabokɔ̃ ne, misɛ miɣɛ sɔ kado to ɔ̃apɛ, fiɛ isɛ iba ngbɔ ana. ");
INSERT INTO akp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Si minya sɔ ɔwiri to ɔkpɛ̃ ɔbɔrɛ i kala isɛ ne, misɛ miɣɛ sɔ awururu ka aba fiɛ isɛ iba ngbɔ. ");
INSERT INTO akp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Maladze! Misɛ miwo kuɖokpo ɔnyɔ ɔɣɛ kumɛgɔ i kayi aase, ɣɛɛ miito miwo ɔwi gɔ ame mipia ɔnya ɔɖi ite! ");
INSERT INTO akp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Be ɔso miibabo i ara ame minyɔ sɔ imele nlɛ gɔ miabara? ");
INSERT INTO akp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Si fɔ gu ɔturi ɔna atɔ̃me fiɛ ɔkɔ-ɔ ɔto ɔkɛlɛgu atɔ̃mekaɣɛkɔ̃ ne, ki i ɔri biara iso si aledza mi gu wũ inyɔ ndɛ̃ fiɛ miabo atɔ̃mekaɣɛkɔ̃. Si iiɖe ngbɔ ne, ɔto ɔ̃asu-ɔ ɔtã matɔ̃meɣɛdze, ma wũ masu-ɔ matã mma nsɛ mamɔɛ̃ maturi mamɔɛ̃-ɔ mapia i iyo. ");
INSERT INTO akp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Fiɛ lobie sɔ mitsue sɔ ato aawe i iyo karɛkɔ̃ gbɔgbɔɔgbɔ ɔwi gɔ atã kuso gɔ ato kapɛrɛ tsɔra aro.” ");
INSERT INTO akp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ɔwi gɔmɔ ame ne, mawɛ̃ ma mpia i mmɔ ɔɣere Yesu kumɛgɔ i Pilato ɔɖoe Galilea maturi mawɛ̃ ku ɔwi gɔ mato mafɛ̃ ara matã Ɣaa. ");
INSERT INTO akp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mmɔ i Yesu ɔkarɛ ma sɔ, “Mifɔ miɖe sɔ Galilea maturi mamɔ nɖe makpibaradze maɖo ɔso fiɛ maɖoe ma ngbɔ? ");
INSERT INTO akp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ooɣo, iiɖe ngbɔ iɖe! Ɣɛɛ nto loɣere mi sɔ si miinyua ara lalaa ibara ne, mi wũ ngbɔ ame miakpi ne. ");
INSERT INTO akp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Maturi iweo-farafana ma i Siloa iyo kɔlɛa nɛmɔ ɔbiɛ ifu ɣɛɛ? Mifɔ miɖe sɔ ma nɖe makpibaradze maɖo mma ɔɖuɖu mpia i Yerusalem? ");
INSERT INTO akp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ooɣo, iiɖe ngbɔ iɖe! Nto loɣere mi sɔ si miifiniki minyua mi akpi ibara ne, ngbɔ ame i mi ɔɖuɖu aakpi ne.” ");
INSERT INTO akp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu ɔpɛ igbã nɛgbe sɔ, “Ɔwi ɔwɛ̃ ame ne, ɔrɛrɛ̃ ɔwɛ̃ ɔwe gɔ lopia kuɖedziri i ɔ̃ kakpɛkɔ̃ ame. Ɔsɛ kuɖedziri gɔgbe katɔ̃ sɔ ɔ̃abie kɔ̃ abi, ɣɛɛ ɔ̃ina kuiwɛ̃. ");
INSERT INTO akp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mmɔ ɔɣere ngɔ nto ɔnyɔ kakpɛkɔ̃ iso sɔ, ‘Akɔ atɛ sɔɔ̃ loɔba loabie adziribi i kudziri gɔgbe iso fiɛ loina kuiwɛ̃ ne. Ɖaɛ kɔ̃ alasɔ kuto kunina karɔ̃ ga iso kuɣɛ.’ ");
INSERT INTO akp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Ɣɛɛ ngɔ nto ɔnyɔ kakpɛkɔ̃ iso ɔtã wũ mmuai sɔ, ‘Bokɔse, tã botã kɔ̃ ikɔ iwɛ̃ saã bobua bonyɔ. Loakuri kɔ̃ kayirinɔ lofere ara wa loatã karɔ̃ iɖa lonyɔ. ");
INSERT INTO akp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Si kuɣɔ̃ abi ne, iyɔ ilɛ. Ɣɛɛ si kuiɣɔ̃ abi ne, boawo kɔ̃ ɔɖaɛ ɔpɛyu.’ ” ");
INSERT INTO akp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Iwarãyi iwɛ̃ iso ne, Yesu ɔsɛ ɔ̃ate ara i ma Yudase kasarɛkɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ɔrɔ̃go ɔwɛ̃ ana ɔwe i mmɔ gɔ siwarã lalaa ɔɔnyɛra wũ akɔ aweo-farafana sɔɔ̃. Siwarã dzɛgbe ɔtã sɔ ɔrɔ̃go gɔgbe ɔkɔ, ɔ̃isɛ ɔwo ɔta ɔya tɔrɔrɔ. ");
INSERT INTO akp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Gɔ Yesu ɔnya wũ ne, ɔkpere wũ ɔɣere sɔ, “Ɔrɔ̃go, ɔɔna isosarɛ!” ");
INSERT INTO akp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yesu ɔsu ɔ̃ nrɔɔ̃ ɔsia wũ iso. Ɔluwɛ̃ ne, ɔrɔ̃go gɔgbe ko lota ɔya tɔrɔrɔ ɔtsɛ Ɣaa ile. ");
INSERT INTO akp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sikpã ɔmɔɛ̃ ɔkpakpa gɔ nto ɔnyɔ kasarɛkɔ̃ mmɔ iso gbaã sɔ Yesu ɔsa nyɛse ku Iwarãyi iso. Ne ɔso ɔɣere maturi ɔɖuɖu sɔ, “Boba ayi akuɔ wa boasu bobara bo karabara ne ɔso si irere to mi ndɛ̃ ɔrere fiɛ ɔto ɔbie sɔ masa wũ ne, ɔba i ayi wamɔ ame ne iiɖe Iwarãyi iso!” ");
INSERT INTO akp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mmɔ i Bosate to ɔtã wũ mmuai sɔ, “Mi maladze, manantsuĩ gu mafirimu ma nsɛ mabara mi karabara ne, mi nna loikurisi ma i siwɛ̃ ame sɔ makɛlɛ ndu kanɛkɔ̃? ");
INSERT INTO akp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ɣɛɛ ne, Abraham ɔ̃ ɔwa tɛtɛ gɔ i Ɔbosam ɔpia ɔnyɛ akɔ aweo farafana ngbe ne, iikote sɔ maasa wũ ku Iwarãyi?” ");
INSERT INTO akp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Itɔ̃me nɛ i Yesu ɔɣɛ ngbe ɔtã sɔ kunuarɛ ɔkpɛ̃ ɔ̃ matsirise ɣɛɛ maturi tsɔra ɔna isoɣɔ i awawãra wa ɔto ɔbara ɔɖuɖu iso. ");
INSERT INTO akp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ne Yesu to ɔkarɛ ma sɔ, “Miɣe nnɛ maasu Ɣaa sigarakaɖekɔ̃ makateragu? Be iɖe boasu bokateragu iakote? ");
INSERT INTO akp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ise lɛ idziribi kosoi iwɛ̃ nɛ i ɔrɛrɛ̃ ɔsu ɔsɛ ɔ̃apɛ i ɔ̃ kakpɛkɔ̃ ame. Gɔ ɔraɖui gɔgbe ɔre ne, ɔmɔ ɔkpese kudziri siare gɔ kurodzai aabara ayo i kɔ̃ akpa ame.” ");
INSERT INTO akp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu ɔledza ma igbã mama ipɛ iɣɛ sɔ, “Ɣaa sigarakaɖekɔ̃ sɛ siɣa lɛ ngbe. ");
INSERT INTO akp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ɔrɔ̃go ɔwɛ̃ ɔsu inyagɛ̃ kua ɔpia i mmɔre mɛ losi ame, ɔkpɔkɔtɔ ɔsakanya gbɔgbɔɔgbɔ mmɔre ɔɖuɖu ɔnyagɛ̃.” ");
INSERT INTO akp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu ɔwe ɔki i simagɛ̃ gu ngorowase ame ɔto ɔte maturi ara ku ɔwi gɔ ɔto ɔkɛlɛ Yerusalem. ");
INSERT INTO akp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mmɔ i ɔrɛrɛ̃ ɔwɛ̃ to ɔkarɛ wũ sɔ, “Tete, maturi kɛkɛĩ kere loana iɖi?” Ne Yesu to ɔtã wũ mmuai sɔ, ");
INSERT INTO akp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Pia kubɛ si aki i kayogodɔ̃ mɔmɔrĩa ame. Alasɔ maturi gbodzoo to maabie sɔ maaki i mmɔ mabo ɣɛɛ maibawo ɔbo. ");
INSERT INTO akp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ɔwi to ɔba gɔ iyosate to ɔ̃ata ɔmɔɛ̃ kukui ɔsɛ̃. Iyɔ mi ma lokuti miɣɛ i kayoma to miatsɛ kukui ikpukpura iɣɛ sɔ, ‘Tete, sese bo iyo!’ “Ɣɛɛ iyosate gɔmɔ to ɔ̃aɣɛ sɔ, ‘Loiɣe mi!’ ");
INSERT INTO akp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Iyɔ mito miaɣɛ sɔ, ‘Bo gu-ɔ ɔɖe ara bonɛ ara fiɛ ate ara i bo ɔmagɛ̃ ame!’ ” ");
INSERT INTO akp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Ɣɛɛ ɔto ɔ̃aledza mi iɣere sɔ, ‘Loiɣe ngbegɔ mibɔrɛ! Mirui me i kɔrɛ, mi ara lalaa mabaradze ɔɖuɖu.’ ");
INSERT INTO akp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Kaku gu inyɛwe aaba si minya Abraham gu Isak gu Yakob gu Ɣaa kanyamaɖidze ɔɖuɖu i Ɣaa sigarakaɖekɔ̃ ame ɣɛɛ Ɣaa aasa mi sɔ midaabo. ");
INSERT INTO akp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Maturi to maabɔrɛ i kuɣɛ̃kabɔrɛkɔ̃ gu kɔ̃ iyo kabokɔ̃ maba. Maabɔrɛ i kato gu kala isɛ maba maasakanya i Ɣaa sigarakaɖekɔ̃ maɖe ara manɛ ara. ");
INSERT INTO akp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Maturi mawɛ̃ ma nɖe matsɔra to maakpese maɖeakatɔ̃. Fiɛ maɖeakatɔ̃ mawɛ̃ to maakpese matsɔra.” ");
INSERT INTO akp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ɔwi gɔmɔ ame ne, ma Farisise mawɛ̃ ɔba Yesu kɔrɛ maba maɣere wũ sɔ, “Bara mala si abɔrɛ ngbe akɛlɛ kakɔi mama ala Igara Herodes to ɔbie sɔ ɔ̃aɖoe-ɔ.” ");
INSERT INTO akp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ne Yesu to ɔɣere ma sɔ, “Mikɛlɛ miaɣere raninadze gɔmɔ sɔ, ‘Nɔme ne, loasa siwarã lalaa loɖi i maturi ame, losa manyɛse isɛ iabo kɔrãkaɖe. Ikpɛnɛ tɛare iso ne, loaro wũ karabara.’ ");
INSERT INTO akp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ne ɔso kiniɔ ne, ita i nɔme isɛ iabo kɔranɔwɛ̃ ne, loaɣo ɔri. Alasɔ iikote sɔ maaɖoe Ɣaa kanyaɖidze i kakɔi mama iɖo Yerusalem ɔmagɛ̃ ame. ");
INSERT INTO akp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yerusalem, Yerusalem! Fɔ gɔ maturi nto maɖoe Ɣaa kanyamaɖidze, fiɛ masɛ mabara mma i Ɣaa ɔpia katɔ̃me i fɔ kɔrɛ ɔtile mapɛ ma ata. Ɔwi gbodzoo ame loɔwarɛ nrɔɔ̃ losɔ̃-ɔ sɔ loafu fɔ maturi lɛ kɔkɔ ɔnyi sɛ ɔwarɛ ɔ̃ abue ɔfu ɔ̃ mabi ɣɛɛ masɛ̃ sɔ lodaabara. ");
INSERT INTO akp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nnɛgbe ɔso ne, Ɣaa to ɔ̃aɖi ɔmagɛ̃ gɔgbe atsue. Nto loɣere-ɔ gbaã sɔ ne, aisibanya me gbɔgbɔɔgbɔ ɔwi gɔ miala kulu miɣɛ sɔ, ‘Maale ngɔ nto ɔba i Bosate iyere ame!’ ” ");
INSERT INTO akp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Iwarãyi iwɛ̃ ne, Yesu ɔsɛ ma Farisise ɔkpakpa ɔwɛ̃ iyo gɔ makpere wũ sɔ ɔba ɔ̃aɖe ara. Mma lowe mmɔ ɔkarã anɔ i ɔ̃ iso totoroo. ");
INSERT INTO akp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ɔrɛrɛ̃ ɔwɛ̃ gɔ nrɔɔ̃ gu ngba loɣe ɔba ɔ̃ kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ne Yesu to ɔkarɛ mmara matedze gu ma Farisise mamɔ sɔ, “Bo mmara ne, mitã bo ɔri sɔ bosa ɔnyɛ ku Iwarãyi ɛɛbɛrɛ miitã bo ɔri?” ");
INSERT INTO akp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ɣɛɛ maiwo kuira ɔɣɛ. Ne Yesu ɔmɔɛ̃ ɔrɛrɛ̃ gɔgbe kɔrɔ̃ ɔsa wũ fiɛ ɔɖi wũ ɔri ne. ");
INSERT INTO akp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mmɔ ɔto ɔɣere ma sɔ, “Mi ndɛ̃ nna ɔbi ɣee nantsuĩ loakpase ɔbo i ibu ɣee iwo ame ku Iwarãyi fiɛ ɔ̃ibaɖi wũ i Iwarãyi nɛmɔ iso?” ");
INSERT INTO akp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ɣɛɛ maiwo wũ itɔ̃me mmuai ɔtã. ");
INSERT INTO akp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Gɔ Yesu ɔnya kumɛgɔ i mma makpere mabɔ aɖera kaɖekɔ̃ i mmɔ to makpɛ̃ mabie nsɛkɔ̃ kɔlɛa ne, ɔpɛ ma igbã nɛgbe sɔ, ");
INSERT INTO akp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Si ɔturi ɔkpere-ɔ sɔ ba ɔ̃ ɔrɔ̃go kakɔkɔ̃ ne, daasɛ aasɛ i kasɛkɔ̃ kɔlɛa pelepele. Alasɔ iawo ɔba sɔ ɔkpere ɔmama gɔ lokɔlɛ ɔɖo-ɔ ana ɔbɔ i mmɔ. ");
INSERT INTO akp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Daatã sɔ ngɔ lokpere mi inyɔ ɔɖuɖu aaba ɔ̃aɣere-ɔ sɔ, ‘Tã ngɔgbe si ɔba ɔ̃asɛ i mmɔ.’ Iyɔ ka aba aata aasɛ i katsɔrakɔ̃ gɔ kunuarɛ amɔɛ̃-ɔ. ");
INSERT INTO akp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ɣɛɛ si makpere-ɔ makɛlɛgu kakɔi ne, sɛ aasɛ i iyara kosoi iso. Si ngɔ lokpere-ɔ ɔbɔ ɔba ɔ̃anya-ɔ ne, ɔ̃aɣere-ɔ sɔ, ‘Wũ ɔlaa, ta ba sɛ i iyara siare nɛgbe iso.’ Nnɛgbe to iakɔlɛ-ɔ kato i maturi mama ma makpere mabɔ ɔɖuɖu anɔ. ");
INSERT INTO akp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Alasɔ ɔbiara gɔ nsɛ ɔkɔlɛ so kato ne, Ɣaa to ɔ̃abɔ wũ karɔ̃ fiɛ ɔturi biara gɔ lobɔ so karɔ̃ ne, Ɣaa to ɔ̃akɔlɛ wũ kato.” ");
INSERT INTO akp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ne Yesu to ɔfiniki ɔɣere ngɔ lokpere wũ ɔbɔ araɖea kaɖekɔ̃ sɔ, “Si ato akpere maturi sɔ maba maaɖe aɖera i fɔ iyo ne, daakpere fɔ malaa ɣee fɔ manyiibi ɣee fɔ malɛdze ma mba karana. Alasɔ ma wũ mato maakpere-ɔ lɛ kumɛgɔ akpere ma sɔ maba maaɖe ara. Si iba ngbɔ ne, tsue sɔ maɔbara mati-ɔ kuso. ");
INSERT INTO akp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ɣɛɛ si ato ana isoɣɔ nɛgbe igbã ne, kpere mawɛrɛba gu mma lofɛfɛ̃ mafu maisɛ mawo ɔsɛ, mma lokpi kasɛkasɛ gu manɔbiɛdze. ");
INSERT INTO akp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nnɛgbe loatã Ɣaa ɔfere-ɔ kusɛkusɛ ne. Alasɔ mmamɔ iibawo-ɔ kuso kukuwɛ̃ ɔtã. Ɣaa to ɔ̃atã-ɔ kuso ku iyi nɛ i maturi sekelea aata mabɔrɛ i makpise ame.” ");
INSERT INTO akp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Gɔ mma nsi mato maɖe ara ɔwɛ̃ ɔnɔ itɔ̃me nɛgbe ne, ɔɣere Yesu sɔ, “So to siaɣɔ mma loaɖe ara i Ɣaa sigarakaɖekɔ̃ gbaã!” ");
INSERT INTO akp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ne Yesu to ɔɣere wũ sɔ, “Ɔwi ɔwɛ̃ ame ne, ɔrɛrɛ̃ ɔwɛ̃ ɔkpere maturi gbodzoo sɔ maba ɔ̃ ɔpɔrɔ̃ katukɔ̃ maba maaɖe ara. ");
INSERT INTO akp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ɔwi gɔ maɔwa aɖera maro fiɛ ira biara ɔɔkote ne, ɔpia ɔ̃ maɖabo sɔ masɛ maaɣere mma ɔɖuɖu ɔkpere sɔ ka maba alasɔ ira biara ɔɔkote! ");
INSERT INTO akp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ɣɛɛ ma ɔɖuɖu ɔtsɛ kafara itu. Ɔɖeakatɔ̃ ɔɣere ɔɖabo sɔ, ‘Loɣa karɔ̃ kawɛ̃, ne ɔso losɛ loanyɔ kã gɔ itã sɔ loibawo ɔba.’ ” ");
INSERT INTO akp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ɔmama ana sɔ, ‘Loɣa manantsuĩ iweo ma loakpɛ̃ matã me i wũ kakpɛkɔ̃ ame. Ɔri ka nto loɣo sɔ loanyɔ kumɛgɔ maawo karabara ɔbara ne ɔso loibawo ɔba.’ ” ");
INSERT INTO akp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ɔmama ana sɔ, ‘Kiniɔ ame loyiri ɔrɔ̃go ne, ne ɔso loibawo ɔba.’ ");
INSERT INTO akp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ɔɖabo ɔkpese ɔsɛ ɔ̃aɣere ɔ̃ ɔkɔse ara wagbe ɔɖuɖu. Sikpã ɔmɔɛ̃ ɔkɔse gbaã ne ɔɣere ɔɖabo sɔ, ‘Pɛ siwa kɛlɛ siri iso gu amamai ɔɖuɖu ame i simagɛ̃ ame si akpere mawɛrɛba gu maturi ma lofɛfɛ̃ mafu gu manɔbiɛdze gu mma lokpi kasɛkasɛ ɔɖuɖu abɔ.’ ");
INSERT INTO akp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ɔɖabo ɔsɛ ɔ̃abara ngbɔ, ne ɔkpese ɔba ɔ̃aɣere ɔ̃ ɔkɔse sɔ ɔɔkpere ma ɔbɔ ɣɛɛ ne, kasɛkɔ̃ ɔkuti kase gbodzoo ana. ");
INSERT INTO akp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Mmɔ i ɔ̃ ɔkɔse to ɔledza wũ iɣere sɔ, ‘Kɛlɛ aaki i sivurã iso gu nsɛkɔ̃ si akpere maturi abɔ sɔ wũ iyo ɔɖuɖu ayi ku maturi. ");
INSERT INTO akp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nto loɣere-ɔ sɔ mma ɔɖuɖu lokpere sɔ tee maba wũ ɔpɔrɔ̃ katukɔ̃ ne, ma kuwɛ̃ iibati wũ aɖera ɔnyɔ!’ ” ");
INSERT INTO akp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ɔwi ɔwɛ̃ ame gɔ maturi gbodzoo siai Yesu ne, ɔfiniki ɔɣere ma sɔ, ");
INSERT INTO akp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ɔbiara gɔ loasiai me ne, ɔ̃ibawo wũ siaidze ɔɖe si ɔ̃iɖɔɛ me ɔɖo ta ɔ̃ ɔse gu ɔ̃ ɔnyi gu ɔ̃ ɔre gu mabi gu ɔ̃ manyiibi gu ɔ̃ mɔmɔ. ");
INSERT INTO akp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ngɔ loisore inyɛwe ɔnyigbã ɔsiai wũ nsɛgbai ne, ɔ̃ibawo wũ rasuãdze ɔɖe. ");
INSERT INTO akp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Si ɔrere to ɔbie sɔ ɔ̃atsue iyo siare ne, ɔ̃aɖe katɔ̃ ɔsɛ i karɔ̃ ɔbu ara wa ɔɖuɖu lonya gu wã kuɣa ɔnyɔ si ɔba sikã ɔ̃awo ɔtsue ɔro tɔtɔ fiɛ ɔ̃asɛ karɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Si ɔ̃ibara ngbɔ ne, si ɔ̃ɔpia ne i karɔ̃ ame ɔro ne, ɔ̃anyua iyoku ɔɣedza. Mma ɔɖuɖu lonya iyoku nɛgbe to maatsɛ wũ ima iɣɛ sɔ, ");
INSERT INTO akp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Ngɔgbe ɔtsɛ iyo itsue ɣɛɛ ɔ̃iwiri.’ ");
INSERT INTO akp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Si igara ɔrere to ɔkɛlɛ ɔ̃akpɛ̃ kakpã ku makpakpɛ̃dze kukpi kuweo fiɛ ma gu igara gɔ loakpɛ̃ ba makpakpɛ̃dze kukpi sinyɔ ne, ikote sɔ ɔ̃abu iti ame ɔnyɔ tɔtɔ si sɔ ɔ̃ ɔle gɔ ɔba aawo ɔ̃ tsirise gɔmɔ ɔkpɛ̃gu. ");
INSERT INTO akp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Si ɔnya sɔ ɔna ɔle ngbɔ ne, ɔ̃apia ɔ̃ maturi masɛ maasarɛgu igara nyɔare gɔmɔ matã wũ iti sɔ ɔ̃ibawo wũ ɔkpɛ̃gu ne ɔtã mafere kanya ndu tɔtɔ kɔra fiɛ igara gɔmɔ aaba kakpãtɔ̃.” ");
INSERT INTO akp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kawirikɔ̃ ne, Yesu ɔɣere ma sɔ, “Ngbɔ ame i mi ndɛ̃ kuwɛ̃ iibawo wũ rasuãdze ɔɖe si ɔ̃isɛ̃ so pelepele ne. ");
INSERT INTO akp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mma ba ɔmɛrɛ̃. Ɣɛɛ si me ɔmɛrɛ̃ ɔɔro ne, aisibawo ɔri kuwɛ iso ɔki ɔpia me ɔmɛrɛ̃. ");
INSERT INTO akp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Miiɖe ira nɛ maasu mapia karɔ̃ iɖa ɣee mafere me i aku kawirikɔ̃. Maasu me masa mawiri. “Ne ɔso mi ma mba atsue si minɔ nnɛ nto loɣɛ!” ");
INSERT INTO akp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Iyi iwɛ̃ ne, ma lampofɔdze gu akpi mama mabaradze ɔba Yesu kɔrɛ sɔ si maba maanɔ ɔ̃ itɔ̃me. ");
INSERT INTO akp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ma Farisise gu mmara matedze mawɛ̃ ɔtsɛ wũ iɣɛtɛ iɣereso sɔ, “Ɔrɛrɛ̃ gɔgbe sɛ ɔfɔ makpibaradze ɔɖegu ma ta aɖera!” ");
INSERT INTO akp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ne ɔso Yesu ɔpɛ ma igbã nɛgbe sɔ, ");
INSERT INTO akp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Si mi ndɛ̃ ɔrere ba masɛrɛ kulafa fiɛ ma ndɛ̃ ɔwɛ̃ ɔyu ne, be ɔ̃abara? Ɔ̃ibanyua kasiwɛ̃-kaiwɛ̃ ɔɣɛdza i aɖera kaɖekɔ̃ ɔ̃anyɔnyɔ ngɔ loyu gbɔgbɔɔgbɔ ɔ̃anya wũ? ");
INSERT INTO akp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Fiɛ si ɔnya wũ ne, ɔ̃ana isoɣɔ gbaã ɔputa wũ ɔsia i iloi. ");
INSERT INTO akp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ɔsore wũ ɔbɔ iyo ɔba ɔ̃akpere ɔ̃ mala gu magbamikui ɔɣere ma sɔ, ‘So ɔɣɔ me gbaã alasɔ lonya wũ sɛrɛ gɔ loyu ne ɔso minagu me isoɣɔ!’ ");
INSERT INTO akp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nto loɣere mi sɔ ngbɔ ame i isoɣɔ siare aawe i Ɣaa sigarakaɖekɔ̃ ɔɖuɖu i kpibaradze ɔwɛ̃ saã gɔ lofiniki i ɔ̃ ɔtu ame ɔso iɖo maturi kasiwɛ̃-kaiwɛ̃ ma loinya ifiniki ne. ");
INSERT INTO akp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Si ɔrɔ̃go ba sikãfudza abi aweo fiɛ ɔyura iwɛ̃ ne, be mifɔ miɖe sɔ ɔ̃abara? Ɔ̃atsue ɔkaniɛ ɔfiɛ ɔ̃ iyo ɔɖuɖu ame ɔnyɔnyɔ siyokã ɔɖuɖu ame gbɔgbɔɔgbɔ ɔ̃anya ne. ");
INSERT INTO akp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Fiɛ si ɔnya ne ne, ɔto ɔ̃akpere ɔ̃ mala gu magbamikui ɔsirakanya ɔɣere ma sɔ, ‘So ɔɣɔ me gbaã alasɔ lonya wũ sikã ibi nɛ loyu ne ɔso minagu me isoɣɔ.’ ");
INSERT INTO akp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nto loɣere mi sɔ gbaã ne, ngbɔ ame i Ɣaa makpabo ana aana isoɣɔ i kpibaradze ɔwɛ̃ saã gɔ lofiniki ɔso ne.” ");
INSERT INTO akp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu ɔkɛlɛgu i katɔ̃ ɔɣere ma sɔ, “Ɔrɛrɛ̃ ɔwɛ̃ ɔwe mabirɛrɛĩ inyɔ. ");
INSERT INTO akp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kosore ɔba ɔ̃atu ɔ̃ ɔse ɔɣere wũ sɔ, ‘Tete, su wũ kaɖekɔ̃ ga loaɣo me si akpi tã me kiniɔ.’ Ne ɔso ɔ̃ ɔse ɔɣɛ ɔ̃ ara ɔtã mabi ma inyɔɔ. ");
INSERT INTO akp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Ayi arɛ̃saã kama ne, kosore ɔsu ɔ̃ ara wa loɣo wũ ɔɖuɖu ɔrɔdɛ̃ ɔfɔ sikã ɔpia i ɔkoto ame ɔrui ɔkɛlɛ karɔ̃ dzoroa kawɛ̃ iso ngbegɔ ɔsɛ ɔ̃asɛ ngbã nyanyarĩa ɔnina ɔ̃ sikã ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ɔwi gɔ ɔ̃ɔnina ira biara nɛ ɔba ɔro kama ne, kukã siare kuwɛ̃ ɔbo i karɔ̃ gamɔ ɔɖuɖu iso gɔ itã sɔ kukã ɔkpɛ̃ wũ gbaã. ");
INSERT INTO akp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ne ɔso ɔsu so ɔsɛ ɔ̃atã karɔ̃ gamɔ iso ɔturi ɔwɛ̃ sɔ ɔ̃abara karabara igbã biara ga ɔ̃atã wũ. Ɔrɛrɛ̃ gɔmɔ ɔsese wũ sɔ ɔsɛ ɔ̃anyɔ ɔ̃ makparako iso i akorowa awɛ̃. ");
INSERT INTO akp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kukã ɔso ne, ɔbie sɔ si ɔna makparako aɖera wa ɔto ɔtã ma ne, tee ɔ̃aɖe fiɛ ɣɛɛ kuwɛ̃ iitã wũ. ");
INSERT INTO akp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Kawirikɔ̃ ne, ɔledza ikpese ibo so ame ɔɣere so sɔ, ‘Wũ ɔse maɖabo ma nsɛ mabara ɔ̃ karabara kɔra ne, masɛ mana aɖera maɖe mami akuti. Ne mme losi ngbe kukã to kuɖoe me ne! ");
INSERT INTO akp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Loata lokɛlɛ tete kɔrɛ losɛ loaɣere wũ sɔ, “Tete, lobara ikpi, loɣɛrɛ ɔ gu Ɣaa. ");
INSERT INTO akp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Loisikote sɔ aakpere me sɔ fɔ ɔbi. Ɣɛɛ su me bara lɛ fɔ maɖabo ma nsɛ mabara fɔ karabara ndɛ̃ ɔwɛ̃.” ’ ");
INSERT INTO akp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ne ɔta ɔmala ɔ̃ ara ɔɣo ɔ̃ ɔse kɔrɛ ɔri ne. “Gɔ ɔsɛ dzoroo ne, ɔ̃ ɔse ɔnya wũ ɔɖi ite sɔ ɔ̃ ɔbi ɔɖe nto ɔba. Ɔ̃ ara ɔɖo wũ kayiri ne ɔtere ɔsɛ ɔ̃ɔmini wũ ku isoɣɔ ne. ");
INSERT INTO akp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Mmɔ i ɔbi gɔgbe ɔɣere ɔ̃ ɔse sɔ, ‘Tete, lobara ikpi i Ɣaa gu fɔ iso. Loisikote sɔ aakpere me sɔ fɔ ɔbi.’ ");
INSERT INTO akp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ɣɛɛ ne, ɔ̃ ɔse ɔkpere ɔ̃ maɖabo ɔɣere ma sɔ, ‘Mipɛ siwa si miɖi ara sɛɛ mipia wũ. Mipia wũ inyi si misu ndokota sɛɛ ana miba miapia wũ. ");
INSERT INTO akp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ne kama ne, misɛ mianyɔ nantsuĩ gɔ loɔbo iɖa miɖoe si boba boaɖe iyi. ");
INSERT INTO akp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Alasɔ wũ ɔbi gɔgbe ne, bosu wũ sɔ ɔ̃ɔkpi ɣɛɛ ɔkpese ɔba ngbã. Ɔyu fiɛ boledza wũ inya ana.’ Ne ɔso matsɛ iyi iɖe. ");
INSERT INTO akp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ɔwi gɔmɔ ame ne, ɔbi kpakpare ɔ̃ wũ ɔkpa iputu ame. Gɔ ɔsɛ ɔto ɔba fiɛ ɔ̃ɔbore ɔbo iyo ne, ɔtsɛ aka gu katɔ kulu inɔ iyo ame. ");
INSERT INTO akp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ne ɔkpere ɔɖabo ɔwɛ̃ ɔkarɛ wũ sɔ, ‘Be nto ikɛlɛ i katɔ̃ i iyo ame?’ ");
INSERT INTO akp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Ɔɖabo ɔtã wũ mmuai sɔ, ‘Fɔ ɔnyiibi loɔkpese ɔba kaa. Ne ɔso i fɔ ɔse ɔtã maɖoe nantsuĩ gɔ mba iɖa alasɔ ɔ̃iɣe sɔ ɔ̃akpese ɔnya wũ ɔnyɔa.’ ");
INSERT INTO akp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Nnɛgbe ɔtã sɔ sikpã ɔmɔɛ̃ ɔbirɛrɛĩ kpakpare gbaã ne ɔso ɔsɛ̃ sɔ ɔ̃ito ɔkɛlɛ iyo. Ne ɔ̃ ɔse ɔbɔrɛ ɔkɛlɛ ɔ̃ kɔrɛ i inyamɔ ɔsɛ ɔ̃atã wũ iti sɔ ɔrui ɔba iyo. ");
INSERT INTO akp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ɣɛɛ ɔbi ɔfiniki ɔkarɛ ɔ̃ ɔse sɔ, ‘Be ɔso i mme gɔ mme nto lobara-ɔ karabara akɔ gbodzoo nɖe nwagbe lɛ fɔ ɔɖabo fiɛ loibara kuira lota loya-ɔ iso ne, aitã me nane katepuĩ sɔ bo gu wũ malaa si bosu bopia so isoɣɔ? ");
INSERT INTO akp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ɣɛɛ gɔ fɔ ɔbi gɔ lonina fɔ karana ɔsɛ̃ ɔ̃asu ɔsiai marɔ̃go ɔbara ara nyanyarĩa ɔkpese ɔba ɔmagɛ̃ ame ne, aɖoe bɔi gɔ mba iɖa atã wũ.’ ");
INSERT INTO akp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Mmɔ i ɔ̃ ɔse to ɔɣere wũ sɔ, ‘Wũ ɔbi, fɔ ne, bo gu-ɔ mpia ngbe ɔwi biara fiɛ wũ ira biara ne, fɔ ire iɖe. ");
INSERT INTO akp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ɣɛɛ ne, ikote sɔ boaɖe iyi, bona isoɣɔ alasɔ fɔ ɔnyibi gɔgbe ne, bosu sɔ ɔkpi ɣɛɛ ɔkpese ɔba ngbã. Ɔyu fiɛ boledza wũ inya.’ ” ");
INSERT INTO akp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu ɔɣere ɔ̃ marasuãdze sɔ, “Ɔwi ɔwɛ̃ ame ne, ranase ɔwɛ̃ ɔwe gɔ ɔba ɔɖabo gɔ nsɛ ɔnyɔ ɔ̃ ara iso. Maba maaɣere ranase gɔgbe sɔ ɔɖabo gɔ nto ɔnyɔ ɔ̃ ara iso to ɔnina wũ sikã. ");
INSERT INTO akp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ne ɔso ranase ɔkpere ɔ̃ ɔɖabo gɔgbe ɔɣere wũ sɔ, ‘Be iɖe nto lonɔ i fɔ iso ngbe? Wũ ara wa ɔɖuɖu ato anyɔ iso ne, su siko bɔ si boki i ara ame alasɔ aisibawo wũ ara ɔnyɔ iso ita i kiniɔ.’ ");
INSERT INTO akp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Mmɔ i ɔɖabo gɔgbe to ɔɣere so sɔ, ‘Wũ ɔkɔse ka ɔfɔ me karabara iso. Be loala loɔbara? Lona ɔle gɔ loakpɛ̃. Ara iwanyi ana to iakpɛ̃ me kunuarɛ. ");
INSERT INTO akp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ɛɣɛɛ̃! Loɣe nnɛ loabara fiɛ si wũ karabara ɔbɔrɛ me i nrɔɔ̃ ame ne, wũ malaa aafɔ me manyɔ me iso i ma ayo.’ ");
INSERT INTO akp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ne ɔso ɔkpere mma ɔɖuɖu nto ɔ̃ ɔkɔse kuso ɔwɛ̃ ɔwɛ̃. Ɔkarɛ ɔɖeakatɔ̃ sɔ ‘Nda ato wũ ɔkɔse?’ ");
INSERT INTO akp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ne ngɔmɔ ɔtã wũ mmuai sɔ, ‘Nnɔĩ akuku siare kulafa.’ “Ne ɔɖabo gɔgbe ɔɣere wũ sɔ, ‘Su fɔ kuso gɔ ato ɔko bɔ. Sɛ i karɔ̃ si atsɛrɛ sɔ akuku siru kere loɔkuti aatã.’ ");
INSERT INTO akp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ngbɔ ame ɔkpere ɔmama ana gɔ nto ma kuso sɔ, ‘Fɔ ɣɛɛ? Nda kuso ato?’ “Sose gɔmɔ ɔ̃ wũ ɔɣɛ sɔ, ‘Loto atita sikoto kulafa kuso.’ “Ne ɔɖabo gɔgbe ɔɣere wũ sɔ, ‘Su fɔ ɔko gɔ ame botsɛrɛ fɔ kuso bopia bɔ si atsɛrɛ fasinafasina apia.’ ");
INSERT INTO akp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Nnɛgbe ɔso ne, ɔkɔse gɔgbe ɔle ɔ̃ ɔɖabo gɔ nna ɔnukuare ngbe ala ɔ̃ inɔgba i kayu siri dzɛ iso ɔkigu wũ ɔso. Gbaã ne, mma nsi ngbã matã kayi gagbe ara ne, masu ma anɔ masia nnɛ mato mabara iso kɔra maɖo mma nto mabara Ɣaa sigarakaɖekɔ̃ karabara.” ");
INSERT INTO akp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ne Yesu ɔkɛlɛgu i katɔ̃ ɔɣere ma sɔ, “Misu mi kayiiso karana mibuai maturi. Iyɔ si kaba kaaro ne, Ɣaa aafɔ mi ɔpia i ɔ̃ kasɛkɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ɔbiara gɔ nsɛ ɔmɔɛ̃ ara wiriwiria ɔla i ɔnukuare ame ne, maatã wũ ɔri i ara siare ana iso. Ɔbiara gɔ loisɛ ɔɖe ɔnukuare i ara wiriwiria ame ne, ɔ̃ibaɖe ɔnukuare i ara siare ana iso. ");
INSERT INTO akp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ne ɔso si miimɔɛ̃ kayiiso karana mila i ɔnukuare ame ne, nda maabara fiɛ mafɔ mi maɖe i siwarã ara wa i Ɣaa sɛ ɔtã iso? ");
INSERT INTO akp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Fiɛ si aiɖe ɔnukuare i ara wa nɖe ɔturi mama are iso ne, nda iabara fiɛ maasu fɔ mɔmɔ are matã-ɔ? ");
INSERT INTO akp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ɔɖabo kuwɛ̃ iibawo makɔse inyɔ ɔsumu. Si iiɖe ngbɔ ne, ɔto ɔ̃aɖɔɛ ɔwɛ̃ ɔtsiri ɔwɛ̃. Ɣee ɔ̃awarɛ ɔwɛ̃ ɔta ɔya ɔwɛ̃ iso. Miibawo Ɣaa gu karana ɔsɔrɛ.” ");
INSERT INTO akp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Gɔ ma Farisise ɔnɔ ara wa i Yesu ɔɣɛ ne, mabara wũ aɣiãra alasɔ masɛ maɖɔɛ sikã gbaã. ");
INSERT INTO akp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mmɔ i Yesu ɔɣere ma sɔ, “Miɖe maturi ma nsɛ mate so lɛ masɛɛ i maturi anɔ. Ɣɛɛ Ɣaa ɣe mi situ ɔɖuɖu ame. Alasɔ ara wa lofɔ kuɣa i maturi anɔ ne, anyanyara aɖe i Ɣaa anɔ. ");
INSERT INTO akp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Mose mmara ɔko gu Ɣaa kanyamaɖidze ara wa matsɛrɛ masɛ ne, abara wã karabara isɛ iabo Ndupiedze Yohanes ɔwi. Ita i ɔwi gɔmɔ ne, minɔ sɔ mato maɣɛ Itɔ̃me Bielea i Ɣaa sigarakaɖekɔ̃ iso. Fiɛ ɔbiara to ɔkpɛ̃ sɔ ɔ̃ana ɔri ɔbo i mmɔ. ");
INSERT INTO akp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ɣɛɛ ne, ise pɔkɔsɔɔ sɔ kato gu karɔ̃ aawã iɖo sɔ maakpasera mmara kakpoi kosoi tsɔra maɖi. ");
INSERT INTO akp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ɔrɛrɛ̃ biara gɔ losɛ̃ ɔ̃ ɔre fiɛ ɔyiri ɔmama ne, marɔ̃go rɔdze ɔɖe. Fiɛ ɔrɛrɛ̃ gɔ loyiri ɔrɔ̃go gɔ masɛ̃ ne, ɔsiai ɔturire. ");
INSERT INTO akp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ɔrɛrɛ̃ ranase ɔwɛ̃ gɔ nsɛ ɔpia ara wa lofɔ kuɣa fiɛ ɔwe i isoɣɔ ame i ɔ̃ ngba ayi ɔɖuɖu ame ɔwe. ");
INSERT INTO akp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Wɛrɛba ɔwɛ̃ ana gɔ marɔ sɔ Lazaro ɔwe. Aɣɛi ɔkã ɔ̃ iso ɔɖuɖu fiɛ masɛ masu wũ maasɛ i ranase gɔmɔ kayogodɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ɔsɛ ɔnyɔ ɔri sɔ si ranase gɔmɔ to ɔɖe ara ne, kupupui gɔ nsɛ kukpakpase i mmɔ aaɣo wũ ɔɖe. Ta makpɛkpɛ sɛ maba maaɣaɣa ɔ̃ aɣɛi ame. ");
INSERT INTO akp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Wɛrɛba gɔgbe ɔba ɔ̃akpi, ne Ɣaa makpabo ɔba maasore wũ makɛlɛgu Abraham kɔrɛ i kato ne. Ranase gɔmɔ ana ɔba ɔ̃akpi ne mabiara wũ ne. ");
INSERT INTO akp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","I makpise aɖe ne, ranase ɔwe i inyɛwe ame. Ne gɔ ɔkɔlɛ anɔ kato ne, ɔnya Abraham i kato gɔ Lazaro si wũ i kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Mmɔ ɔto ɔkpere sɔ, ‘Tete Abraham! Nyɔ me nnya si atã Lazaro si ɔsu ɔ̃ irɔi ɔpia i ndu ame ɔba ɔ̃asora ɔɣora me i ɔnyagɛmi iso si ibara me pɔkɔsɔɔ alasɔ nto lona ibo i ɔtɔ gɔgbe ame!’ ");
INSERT INTO akp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ɣɛɛ Abraham ɔɣere wũ sɔ, ‘Wũ ɔbi, nyigi sɔ i fɔ ngbã ame ne, afɔ fɔ ara sɛɛ ɔɖuɖu. Fiɛ Lazaro ɔ̃ wũ ne, ara nyanyarĩa kerekere ɔfɔ. Ɣɛɛ kiniɔ ne, ka ɔto ɔna isoɣɔ fiɛ fɔ wũ ato awe inyɛ. ");
INSERT INTO akp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ne kama ana ne, kuwɛ titiiti kuwɛ̃ pia i bo gu-ɔ inyɔ ndɛ̃. Si ɔturi ɔbie sɔ ɔ̃awara ɔba mmɔ ne, ɔ̃ibawo. Ngbɔ ame i kuwɛ̃ iibawo mi kɔrɛ mmɔ ana ɔbɔrɛ ɔba ngbe ne.’ ");
INSERT INTO akp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Mmɔ i ranase gɔmɔ to ɔɣere wũ sɔ, ‘Tete Abraham, loto-ɔ i kukpa sɔ pia Lazaro si ɔsɛ wũ ɔse iyo. ");
INSERT INTO akp_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Loba manyiibi rɛrɛ̃ iru ma mpia ngbã. Tã ɔsɛ ɔ̃aka ma teteree sɔ madaaba ngbe ne inyɛwe ɔɣede.’ ");
INSERT INTO akp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ne Abraham to ɔɣere wũ sɔ, ‘Fɔ manyiibi ba ara wa i Mose gu Ɣaa kanyamaɖidze ɔtsɛrɛ masɛ. Ikote sɔ maakã ara wamɔ atsue mabara i wã iso!’ ");
INSERT INTO akp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Mmɔ i ranase to ɔɣɛ sɔ, ‘Tete Abraham, maibakã itɔ̃me nɛmɔ atsue. Ɣɛɛ si ɔturi ɔbɔrɛ i makpise ame ɔsɛ ɔ̃aɣere ma ne, mato maakã wũ atsue mafiniki i ma akpi ibara ame.’ ");
INSERT INTO akp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ɣɛɛ Abraham ɔɣere wũ sɔ, ‘Si maibakã Mose gu Ɣaa kanyamaɖidze itɔ̃me atsue ne, si ɔturi ɔta ɔbɔrɛ i makpise ame ngbe ɔkɛlɛ ma kɔrɛ kɔra ne, maibakã wũ atsue!’ ” ");
INSERT INTO akp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu ɔɣere ɔ̃ marasuãdze sɔ, “Ara wa loatã ɔturi ɔbara ikpi to aaba, ɣɛɛ ne, ndzo miɖe mitã ngɔ iso aaki fiɛ aaba. ");
INSERT INTO akp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Si masu kukɔtɛ siare manyi masarã wũ i ɔme fiɛ mafuĩdza wũ mapia i ɔpo ame kɔra ne, ialɛ wũ iɖo kutsue gɔ i Ɣaa aakpadzɛ̃ ngɔ loatã mabiɛtɛ magbe ɔbo i ikpi ame. ");
INSERT INTO akp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ne ɔso minyɔ so kukaakɔ nnɛ mito mibara. “Si fɔ ɔnyii ɔbara-ɔ ikpi ne, sɛ̃ tã wũ. Si ɔfiniki ne, su tsɛ wũ. ");
INSERT INTO akp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Si ɔɣɛrɛ-ɔ ikpɛ ikɔdzɛ i ikpɛnɛ iwɛ̃ ame fiɛ ɔkpese ɔba ɔ̃atã-ɔ iti ikpɛ ikɔdzɛ ɔɖuɖu ne, su tsɛ wũ.” ");
INSERT INTO akp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yesu katɔ̃memasɛdze ɔtã wũ iti sɔ, “Bokɔse, tã sɔ bo kafɔkaɖe aamɔ kabua.” ");
INSERT INTO akp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ne Bokɔse ɔɣere ma sɔ, “Si mi kafɔkaɖe ɔmɔ lɛ susuruba ibi ne, miaɣere kudziri gɔgbe sɔ, ‘Rui ngbe kɛlɛ ɔpo ame.’ Fiɛ iaba ngbɔ ana. ");
INSERT INTO akp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Mibu nnɛgbe minyɔ. Si mi ndɛ̃ ɔwɛ̃ ba ɔɖabo gɔ nto ɔkpɛ̃ ɔtã-ɔ ɣee ɔto ɔnyɔ fɔ mabɔi iso fiɛ ɔse i sia ɔba ɔ̃abo ne, aaɣere wũ sɔ ɔba ɔ̃asɛ i karɔ̃ mala si ɔɖe ɔ̃ araɖea? ");
INSERT INTO akp_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ooɣo! Ɣɛɛ ɔɣere aaɣere wũ sɔ, ‘Ledza so si asɛ̃ ɔkati ndɛ̃ si awa aɖera atã me. Si loɔɖe lonɛ loro ne, fɔ wũ aaɖe anɛ fɔ are.’ ");
INSERT INTO akp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Iinya sɔ aapɛ ɔɖabo siba i ɔ̃ Karabara iti. ");
INSERT INTO akp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ngbɔ ame ise itã mi ana ne. Si mibara ira biara nɛ loɣere mi sɔ mibara ne, miɣɛ sɔ, ‘Maɖabo kere boɖe fiɛ nnɛ lokote sɔ boabara kere iɖe bobara.’ ” ");
INSERT INTO akp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Gɔ Yesu ɔɣo Yerusalem ɔri ne, ɔki i Samaria gu Galilea kumɛ iso. ");
INSERT INTO akp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ne gɔ ɔto ɔba ɔ̃abo akorowa awɛ̃ ame ne, marɛrɛ̃ iweo mawɛ̃ ma nto manyɛ ɔnyɛ rɛtɛa ɔba matu wũ. Manyɛse magbe ɔya dzoroo, ");
INSERT INTO akp_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ne mala kulu teteree sɔ, “Tete Yesu, nyɔ bo nnya!” ");
INSERT INTO akp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Gɔ Yesu ɔnya ma ne, ɔɣere ma sɔ, “Mikɛlɛ maisu so mite Ɣaa Masɔrɛdze si manyɔ mi kukaakɔ.” Gɔ marui mato makɛlɛ ne, manya sɔ maɔna isosarɛ. ");
INSERT INTO akp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ɣɛɛ gɔ ma ndɛ̃ ɔwɛ̃ ɔnya sɔ ɔ̃ɔna isosarɛ ne, ɔpɛ ɔfiniki ɔto ɔle Ɣaa ku silɔ teteree. ");
INSERT INTO akp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ɔba ɔ̃apɛ agɛgɛ̃ i Yesu katɔ̃ ɔpɛ wũ siba. Ɔrɛrɛ̃ gɔgbe ne, ɔ Samariase ɔɖe. ");
INSERT INTO akp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Mmɔ i Yesu to ɔkarɛ sɔ, “Iiɖe mi maturi iweo miɖe losa ɣɛɛ? Kaiwɛ̃ tsɔra ne lɛ maki? ");
INSERT INTO akp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nda ibara fiɛ ɔfɔ gɔ loiɖe ɔ Yudase ɔnɔwɛ̃ loakpese ɔba ɔ̃apɛ Ɣaa siba?” ");
INSERT INTO akp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Mmɔ i Yesu ɔɣere wũ sɔ, “Ta ya si akɛlɛ. Fɔ kafɔkaɖe ɔtã-ɔ isosarɛ.” ");
INSERT INTO akp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ma Farisise mawɛ̃ ɔkarɛ Yesu sɔ mabie sɔ maatsue ɔwi gɔ tutuutu i Ɣaa sigara ɔɖewi aaba. Ne Yesu to ɔtã ma mmuai sɔ, “Ɣaa sigara iɖe iibaba i ɔri gɔ iso i maturi aanya. ");
INSERT INTO akp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kuwɛ̃ iibaɣɛ sɔ, ‘Minyɔ! Iɔba ngbe!’ ɣee ‘Nyɔ mmɔ.’ Alasɔ Ɣaa sigara iɖe ka ipia i mi ndɛ̃.” ");
INSERT INTO akp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ne Yesu to ɔɣere ɔ̃ marasuãdze sɔ, “Ɔwi to ɔba gɔ miabie sɔ mianya mme, Ɔturi Awune Ɔbi, iyi iwɛ̃, ɣɛɛ miibanya! ");
INSERT INTO akp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Maturi to maaba maaɣere mi sɔ ‘Minyɔ wũ i mmɔ!’ ɣee ‘Minyɔ wũ i ngbe!’ Ɣɛɛ midaasɛ mianyɔnyɔ me i mmɔ! ");
INSERT INTO akp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Alasɔ lɛ kumɛgɔ i kado sɛ ɔma i kato kasɛ kawɛ̃ isɛ iabo kasɛ nyɔa ne, ngbɔ i Ɔturi Awune Ɔbi iyi nɛmɔ to iase ne. ");
INSERT INTO akp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ɣɛɛ tɔtɔ ne, ikote sɔ loaki i inyɛwe gbodzoo ame kiniɔgbe maturi ɔsɛ̃ me. ");
INSERT INTO akp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ara wa loba ku Noa ɔwi ne, wã ame loaba ku ɔwi gɔ ame i Ɔturi Awune Ɔbi aaledza iba ne. ");
INSERT INTO akp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Maturi to maɖe manɛ, marɛrɛ̃ to mayiri marɔ̃go fiɛ mato masu marɔ̃go matã sɔ mayiri gbɔgbɔɔgbɔ iyi nɛ i Noa ɔbo i ɔkolo siare gɔmɔ ame. Kado ɔpɛ, siwore ɔyi si fɔ karɔ̃, ndu ɔɖoe maturi ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ito iase lɛ kumɛgɔ i Lot ɔwi ɔse awe. Maturi to ɔɖe gu ɔnɛ mato maɖe kuɣa ana. Mawɛ̃ to mapia ɔraɖui mma to matsue ayo. ");
INSERT INTO akp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Iyi nɛ i Lot ɔbɔrɛ i Sodom ne, ɔtɔ gu akaĩ wa nsɛ afɔrɛ̃ nyanyarĩ ɔpɛ abɔrɛ i kato afere ɔmagɛ̃ iso, ma ɔɖuɖu ɔtsue. ");
INSERT INTO akp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ngbɔ ame iase ku iyi nɛ mme, Ɔturi Awune Ɔbi, aaba ne. ");
INSERT INTO akp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Iyi nɛmɔ ne, ngɔ nsia i ɔ̃ isã si ɔdaaso ɔba karɔ̃ sɔ ɔto ɔba ɔ̃abo iyo kame ɔsu ɔ̃ kuira. Ngbɔ ame ngɔ nɣɛ i sia si ɔdaaɣɛ sɔ ɔ̃akpese ɔsɛ kaa ɔ̃asu kuira ne. ");
INSERT INTO akp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Minyigi nnɛ lobara Lot ɔre! ");
INSERT INTO akp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ɔbiara gɔ loakpɛ̃ sɔ si ɔ̃aɖi ɔ̃ ngbã ne, ɔto ɔ̃ayura me. Ɣɛɛ ɔbiara gɔ loayura ɔ̃ ngbã to ɔ̃aledza me ina. ");
INSERT INTO akp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kasɛ̃ gamɔ ne, maturi inyɔ to maarɛ i ara iso. Ɣaa to ɔ̃akɔ ɔwɛ̃ ɔnyua ɔwɛ̃ ɔrara. ");
INSERT INTO akp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Marɔ̃go inyɔ to maala maɔkɔtɛ ɔraũ i kukɔtɛ iso Ɣaa to ɔ̃akɔ ɔwɛ̃, ɔnyua ɔwɛ̃ ɔsɛ. ");
INSERT INTO akp_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Marɛrɛ̃ inyɔ to maaya mala maɔbara karabara, Ɣaa to ɔ̃akɔ ɔwɛ̃ ɔnyua ɔwɛ̃ ɔɣedza.” ");
INSERT INTO akp_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ne marasuãdze to makarɛ Yesu sɔ, “Bokɔse, lɛ isɛ?” Ne Yesu to ɔɣere ma sɔ, “Ngbegɔ i ira kpia se ne, mmɔ i akolomo sɛ asakanya ne.” ");
INSERT INTO akp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu ɔpɛ ɔ̃ marasuãdze igbã si ɔte ma sɔ inya sɔ maakparama kayi ɔwi biara fiɛ nrɔɔ̃ iibafɛ̃ ma. ");
INSERT INTO akp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ɔɣere ma sɔ, “Atɔ̃meɣɛdze ɔwɛ̃ ɔwe i ɔmagɛ̃ ɔwɛ̃ ame gɔ loisɛ ɔnigã Ɣaa fiɛ ɔ̃isɛ ɔwarɛ ɔturi ana. ");
INSERT INTO akp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ɔmagɛ̃ gɔmɔ ame ame ne, kuɛdze ɔwɛ̃ pia gɔ ɔsɛ ɔba atɔ̃meɣɛdze kɔrɛ ɔba ɔ̃atã wũ iti sɔ, ‘Buai me ala wũ matsirise ɔso.’ ");
INSERT INTO akp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Ifɔ ɔwi gbodzoo gɔ atɔ̃meɣɛdze gɔgbe ɔsɛ̃ sɔ ɔ̃ito ɔbara kuira i itɔ̃me nɛmɔ iso. Ɣɛɛ kawirikɔ̃ ne, ɔɣere so sɔ, ‘Atoa sɔ loito lonigã Ɣaa fiɛ loisɛ lowarɛ ɔturi ne, ");
INSERT INTO akp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Kumɛgɔ i kuɛdze gɔgbe to ɔɖaa me ɔso ne, loanyɔ sɔ lokpɛ̃ lofɔ wũ i ɔ̃ tsirise nrɔɔ̃ ame. Si iiɖe ngbɔ ne, ɔto ɔ̃amararã me ɔɖoe.’ ” ");
INSERT INTO akp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ne Bosate ɔkɛlɛ i katɔ̃ ɔɣere ma sɔ, “Minɔ nnɛ i atɔ̃meɣɛdze lalaa gɔgbe to ɔɣɛ. ");
INSERT INTO akp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kiniɔ ne, Ɣaa gɔ nɖe atɔ̃meɣɛdze i ɔri bɔlɔlɔa iso ne, ɔ̃ibaɖi ɔ̃ maturi ma nsɛ mabiɛ makpere wũ kasɛ̃ i kakɔme? Ɣaa iibaɣɛ itɔ̃me ɔtã ɔ̃ maturi ma nto mabiɛ makpere wũ kasɛ̃ i kakɔme? ");
INSERT INTO akp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nto loɣere mi gbaã sɔ Ɣaa to ɔ̃aɣɛ ma itɔ̃me ɔtã ma ibɛ i ɔwi iso. Ɣɛɛ ne, si Ɔturi Awune Ɔbi ɔba ne, ɔ̃anya maturi ma mba kafɔkaɖe?” ");
INSERT INTO akp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu ɔpɛ igbã nɛgbe i maturi ma nsɛ mabu so sɔ ma ɔnɔwɛ̃ nlɛ fiɛ masɛ manyɔ maturi tsɔra pupurii iso. ");
INSERT INTO akp_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ne ɔɣere ma sɔ, “Ɔwi ɔwɛ̃ ame ne, maturi inyɔ mawɛ̃ ɔsɛ Ɣaa isɔrɛyo sɔ maakparama kayi. Ɔwɛ̃ ɖe ɔ Farisise fiɛ ɔwɛ̃ ana ɖe lampofɔdze. ");
INSERT INTO akp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisise ɔkpɛ so ɔɣedza i kuruɛ ne ɔkparama kayi ɔɣɛ sɔ, ‘Ɣaa nto lopɛ-ɔ siba sɔ lona kanɔbɛbɛ, loisɛ lobara maturi akpi fiɛ loisɛ losiai maturire lɛ maturi mama awe. Nto lopɛ-ɔ siba ana alasɔ loise lɛ lampofɔdze gɔgbe awe. ");
INSERT INTO akp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nsɛ lonyi kanya akpɛnɛ anyɔ i ɖapɛ ame fiɛ nsɛ lotã-ɔ wũ ira ɔɖuɖu ika weova.’ ");
INSERT INTO akp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ɣɛɛ lampofɔdze ɔ̃ wũ ɔya dzoroo gɔ ɔ̃ibie sɔ ɔ̃akɔlɛ ɔ̃ iti kato kɔra. Ɣɛɛ ɔsu nrɔɔ̃ ɔfu so igbegbe, ɔɣɛ sɔ, ‘Ɣaa nyɔ me gɔ nɖe kpibaradze nnya!’ ” ");
INSERT INTO akp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ne Yesu ɔɣere ma sɔ, “Nto loɣere mi sɔ gɔ ma inyɔɔ ɔkpese makɛlɛ ma ayo ne, lampofɔdze ɔbo Ɣaa anɔ ɔɖo ɔ Farisise. Alasɔ ɔturi biara gɔ nsɛ ɔkɔlɛ so kato ne, Ɣaa to ɔ̃abɔ wũ karɔ̃. Fiɛ ɔturi biara gɔ nsɛ ɔbɔ so karɔ̃ ne, Ɣaa to ɔ̃akɔlɛ wũ kato.” ");
INSERT INTO akp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mawɛ̃ ɔkɔ ma mabi mabɔ Yesu sɔ ɔsia ma kɔrɔ̃ iso. Gɔ Yesu katɔ̃memasɛdze ɔnya nnɛgbe ne, manyagalagu maturi mamɔ. ");
INSERT INTO akp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ɣɛɛ Yesu ɔkpere mabiɛtɛ ɔbɔ so i kɔrɛ ɔɣere ma sɔ, “Mitã mabiɛtɛ si maba wũ kɔrɛ ne midaatɛ̃ ma ɔri, alasɔ Ɣaa sigarakaɖekɔ̃ se sitã ma igbã. ");
INSERT INTO akp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Gbagbaã nto loɣere mi sɔ, ɔbiara gɔ loifɔ Ɣaa sigara iɖe lɛ ɔbiɛtɛ awe ne, ɔ̃ibawo sɛ̃ ame ɔkɛlɛ ɖa.” ");
INSERT INTO akp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ma Yudase tɔ̃ɖedze ɔwɛ̃ ɔkarɛ Yesu sɔ, “Ratedze bielea, be loabara fiɛ loana ngbã mɛ loisɛ miro minya?” ");
INSERT INTO akp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ne Yesu ɔkarɛ wũ sɔ, “Be ɔso fiɛ ato akpere me Ɔbielea? Ɔturi kuwɛ̃ iiɖe ɔbielea iɖo Ɣaa ɔnɔwɛ̃. ");
INSERT INTO akp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Aɣe Ɣaa mmara mɛ loɣɛ sɔ, ‘Daaɖoe ɔturi, daaɖe asɔrɔ̃, daayu kayu daaɖaɛ fɔ ɔlaa kanya, warɛ fɔ ɔse gu fɔ ɔnyi.’ ” ");
INSERT INTO akp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mmɔ i ɔrɛrɛ̃ gɔmɔ to ɔɣɛ sɔ, “Ita i wũ sibiɛtɛ ame ne, loɔbara i mmara mɛgbe ɔɖuɖu iso.” ");
INSERT INTO akp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Gɔ Yesu ɔnɔ nnɛ ɔɣɛ ne, ɔɣere wũ sɔ, “Ikuti-ɔ ira ka iwɛ̃ aabara. Kɛlɛ aasu fɔ ira biara rɔdɛ̃ si asu sikã atsɛ mawɛrɛba, si aana kusia siare i kato. Si ɔɔro ne, kpese ba siai me.” ");
INSERT INTO akp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ɣɛɛ gɔ ɔrɛrɛ̃ gɔgbe ɔnɔ nnɛgbe ne, ɔruigu isoma alasɔ ɔba karana gbaã. ");
INSERT INTO akp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Gɔ Yesu ɔnya kumɛgɔ i so ɔma wũ ne, ɔɣɛ sɔ, “Ito iabua iɖa fiɛ ranase aabo i Ɣaa sigarakaɖekɔ̃! ");
INSERT INTO akp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Gbaã ne, ma mmɔ ibo ba ɔle iɖo kumɛgɔ i kapuipɔngɔ aaki kafe i ɔdzirikaãra iyoi ame.” ");
INSERT INTO akp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mma lonɔ itɔ̃me nɛgbe ɔkarɛ Yesu sɔ, “Iyɔ nna loabua ɔna iɖi?” ");
INSERT INTO akp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ne ɔtã ma mmuai sɔ, “Ira nɛ i ɔturi iibawo ɔbara ne, Ɣaa aawo ɔbara.” ");
INSERT INTO akp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ne Petro ɔɣere wũ sɔ, “Nyɔ, iyɔ bo ma lonyua bo ara ɔɖuɖu bosɛ bosiai-ɔ ɣɛɛ?” ");
INSERT INTO akp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ne Yesu to ɔɣere ma sɔ, “Gbagbaã iɖe. Fiɛ lobie sɔ mitsue sɔ ɔturi biara gɔ lonyua ɔ̃ iyo gu ɔ̃ ɔre, ɔ̃ ɔnyiibi rɛrɛ̃ gu ɔ̃ ɔnyiibi rɔ̃go gu ɔ̃ maɣese, ɣee mabi ɔsɛ ala Ɣaa sigarakaɖekɔ̃ ɔso ne, ");
INSERT INTO akp_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ɔto ɔ̃ana ara wagbe gbodzoo i ngbã mɛgbe ame gu ngbã mɛ loisɛ miro minya i ɔwi gɔ nto ɔba i katɔ̃ ame ana.” ");
INSERT INTO akp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu ɔkɔ ɔ̃ marasuãdze iweo-inyɔ ɔkɛlɛgu kuruɛ ɔɣere ma sɔ, “Mikã atsue. Boto bokɛlɛ Yerusalem ngbegɔ i ara wa i Ɣaa kanyamaɖidze ɔtsɛrɛ masɛ i mme, Ɔturi Awune Ɔbi, iso ɔɖuɖu aaba i ne ame. ");
INSERT INTO akp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Mato maaɖi me matã mma loiɖe ma Yudase sɔ mabara me aɣiãra. Mato maatia me, matua minyatu mafere me iso. ");
INSERT INTO akp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Mato maapɛ me fiɛ maaɖoe me. Ɣɛɛ akpɛnɛ atɛ kama ne, loata lobɔrɛ i makpise ame.” ");
INSERT INTO akp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ɣɛɛ ara wagbe ɔɖuɖu ne, marasuãdze iinɔ wã karɔ̃. Atɔ̃me wagbe karɔ̃ inɔ ana ɔwɛrɛ ma. Maiɣe nnɛ i Yesu ɔɣere ma ngbe karɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ɔwi gɔ i Yesu ka ɔto ɔbore ɔbo Yeriko ne, nɔbiɛdze ɔwɛ̃ si i ɔri kuruɛ ɔto ɔwanyi ara. ");
INSERT INTO akp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Gɔ ɔnɔ maturi gbodzoo to mafe ne, ɔkarɛ sɔ, “Be nto iba?” ");
INSERT INTO akp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ne mato maɣere wũ sɔ, “Yesu Nasaretse nto ɔfe.” ");
INSERT INTO akp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mmɔ ɔsia kulu teteree sɔ, “Yesu! Igara David Ɔbi! Nyɔ me nnya!” ");
INSERT INTO akp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Maturi ma nɖe katɔ̃ ɔnyagalagu wũ sɔ ɔlo kulu. Ɣɛɛ ɔkɔlɛ ɔ̃ silɔ ɔbua ɔɣɛ sɔ, “Igara David Ɔbi! Nyɔ me nnya soo!” ");
INSERT INTO akp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ne ɔso Yesu ɔtui ɔya ne ɔɣɛ sɔ makɔ nɔbiɛdze mabɔ ɔ̃ kɔrɛ. Gɔ ɔba ɔ̃abo ɔ̃ kɔrɛ ne, Bosate ɔkarɛ wũ sɔ, ");
INSERT INTO akp_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Be ato abiɛ sɔ lobara lotã-ɔ.” Nɔbiɛdze ɔtã mmuai sɔ, “Tete, lobie sɔ loanya ara.” ");
INSERT INTO akp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ne Yesu ɔɣere wũ sɔ, “Nya ara! Fɔ kafɔkaɖe losa-ɔ.” ");
INSERT INTO akp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ɔluwɛ̃ ne, ɔtsɛ ara inya, ɔsiai Yesu ɔto ɔle Ɣaa. Maturi gbodzoo ma lonya nnɛgbe ne, ma ɔɖuɖu ɔle Ɣaa. ");
INSERT INTO akp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu ɔsɛ ɔ̃aki i Yeriko ɔmagɛ̃ ame ɔfe. ");
INSERT INTO akp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ma lampofɔdze ɔkpakpa ɔwɛ̃ gɔ marɔ sɔ Zakeo fiɛ ɔba karana gbaã ɔwe mmɔ. ");
INSERT INTO akp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ɔto ɔbie ɔri gɔ iso ɔ̃aki fiɛ ɔ̃atsue ɔturi gɔ igbã i Yesu ɖe. Ɣɛɛ gɔ ɔkurukutu fiɛ maturi ana ɔsi i ɔri ɔso ne, ɔ̃inya wũ. ");
INSERT INTO akp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ne ɔso ɔtere ɔɖe ma katɔ̃ ɔsɛ ɔ̃aya ɔsia i kudziri ame sɔ ɔ̃anya Yesu ala ɔɣe sɔ ɔto ɔ̃aki i mmɔ. ");
INSERT INTO akp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Gɔ Yesu ɔbo kudziri kayirinɔ ne, ɔtui ɔya, ɔkɔlɛ anɔ kato ne ɔɣere Zakeo sɔ, “Zakeo, so ba mala, alasɔ fɔ iyo loabo nɔme.” ");
INSERT INTO akp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakeo ɔso mala ɔba karɔ̃ ɔfɔ Yesu ku isoɣɔ. ");
INSERT INTO akp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mma ɔɖuɖu lonya nnɛgbe ɔtsɛ Yesu iɣɛtɛ iɣɛ sɔ, “Ɔrɛrɛ̃ gɔgbe to ɔkɛlɛ ɔ̃abo i kpibaradze iyo.” ");
INSERT INTO akp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mmɔ i Zakeo ɔta ɔya ne ɔɣere Bosate sɔ, “Tete! Nyɔ, loasu wũ karana kasɛ kawɛ̃ lotã mawɛrɛba. Mma ɔɖuɖu loɖe amumu lofɔ nnɛ loikote sɔ loafɔ ne, loakpesera ma ara lotã ma ikpɛ ina.” ");
INSERT INTO akp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ne Yesu ana to ɔɣere wũ sɔ, “Nɔme ne, iɖi ɔba i iyo nɛgbe ame. Alasɔ ɔrɛrɛ̃ gɔgbe ɔ̃ wũ ne, Abraham ɔwa tɛtɛ ɔɖe. ");
INSERT INTO akp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Fiɛ mme, Ɔturi Awune Ɔbi, ne, loba lonyɔnyɔ mma ɔɖuɖu loyu, loɖi ma.” ");
INSERT INTO akp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Maturi to makã ara wa i Yesu to ɔɣɛ atsue. Ne ɔpɛ ma igbã nɛgbe alasɔ ka ɔbore ɔbo Yerusalem fiɛ mabu sɔ Ɣaa sigara ɔɖewi to ɔ̃aba kiniɔ. ");
INSERT INTO akp_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ɔɣere ma sɔ, “Ɔwi ɔwɛ̃ ne, ɔrɛrɛ̃ ɔwɛ̃ gɔ nɖe ɔturi nyaa ɔkɛlɛ karɔ̃ dzoroa kawɛ̃ iso sɔ maamɔɛ̃ wũ sigara. Si maɔro ne, ɔbara ɔ̃ adzuni sɔ ɔ̃akpese ɔba. ");
INSERT INTO akp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Si ɔ̃arui ne, ɔkpere ɔ̃ marabaradze iweo ɔsirakanya. Ɔtã ma ɔbiara sikãrɛtɛa ibi iwɛ̃, ɔɣere ma sɔ, ‘Misu sikã dzɛgbe miɖe ala kuɣa si bonyɔ kusia gɔ miana si lona.’ ");
INSERT INTO akp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ɣɛɛ ɔ̃ mɔmɔ aɖe maturi ɔtsiri wũ. Ne ɔso mapia ma kpabo sɔ masiai wũ i kama si masɛ maaɣere igarakpakpa sɔ, ‘Boito bobie sɔ ngɔgbe aaɖe bo igara.’ ");
INSERT INTO akp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ɣɛɛ gɔ masɛra wũ sigara maro ne, ɔkpese ɔba ɔ̃ aɖe. Ɔpia sɔ marɔ ɔ̃ maɖabo ma ɔtã sikã mabɔ si maba maaɣɛ kusia gɔ maɔna. ");
INSERT INTO akp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Ɔɖabo ɖeakatɔ̃ ɔba ɔ̃aya ne ɔɣere wũ sɔ, ‘Tete, sikã dzɛ atã me ne, loɔna sɛ̃ ikpɛ iweo losia iso.’ ");
INSERT INTO akp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Ne ɔ̃ ɔkɔse ɔɣere wũ sɔ ‘Ɖafe! Ɔɖabo sɛɛ aɖe. Gɔ awo ara kɛkɛĩ wagbe ɔsu ɔbara karabara ɔso ne, loasu-ɔ losɛra i simagɛ̃ iweo kanya.’ ");
INSERT INTO akp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ɔɖabo nyɔare ɔ̃ wũ ɔba ɔ̃aɣere wũ sɔ, ‘Tete, lona sikã dzɛ atã me ikpɛ iru losia iso!’ ");
INSERT INTO akp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Ne ɔ̃ ɔkɔse ɔɣere ɔɖabo gɔgbe ɔ̃ wũ sɔ, ‘Fɔ ne, loasu-ɔ losɛra i simagɛ̃ iru kanya!’ ");
INSERT INTO akp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ɔɖabo mama ɔ̃ wũ ɔba ɔ̃aɣɛ sɔ, ‘Tete, ɔɔnya fɔ sikã dzɛ atã me i ngbe. Losu sɛ̃ lopɛ ikpo i wũ ɔkati ikpakpai ame. ");
INSERT INTO akp_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nto lonigã-ɔ alasɔ aba ɔle, asɛ asu ara wa loiɖe fɔ are sɔ fɔ are. Ngbegɔ aikpɛ̃ ana ne, mmɔ asɛ asu fɔ araɖea ne.’ ");
INSERT INTO akp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ne ɔ̃ ɔkɔse to ɔɣere wũ sɔ, ‘Ɔɖabo lalaa aɖe! Fɔ mɔmɔ kanya ame atɔ̃me loasu lotã-ɔ ipɔ! Aɣe sɔ ɔturi gɔ mba ɔle loɖe, fiɛ nsɛ losu nnɛ loiɖe wũ ire lokpesera wũ ire. Nsɛ losu araɖea i ngbegɔ loipɛ ɔraɖui. ");
INSERT INTO akp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Gɔ aɣe ngbɔ ne, be ɔso fiɛ aisu wũ sikã asɛ aapia i sikã kakolakɔ̃? Mmɔ ne, kumɛkumɛ iɖe ne, loɣe sɔ nto loana sɛ̃ gu kusia lofɔ.’ ");
INSERT INTO akp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ne ɔɣere mma nɣɛ i mmɔ sɔ, ‘Mimɔɛ̃ ɔ̃ sikã mifɔ mitã ɔɖabo gɔ lona kusia ikpɛ iweo.’ ");
INSERT INTO akp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Ɣɛɛ maturi ma nɣɛ i mmɔ ɔɣere wũ sɔ, ‘Tete, ɔɖabo gɔmɔ ka ɔba sikã abi aweo koko!’ ");
INSERT INTO akp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ne igara gɔmɔ ɔɣere ma sɔ, ‘Gbaã nto loɣere mi sɔ ngɔ mba ara ne, maatã wũ mabua. Ɔbiara gɔ nna kuira ne, kɛkɛĩ gɔ ame ɔba ne, maamɔɛ̃ mafɔ wũ iso. ");
INSERT INTO akp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kiniɔ ne, wũ matsirise ma loito mabie sɔ loɖe sigara ne, mibɔ ma i wũ katɔ̃ miba miaɖoe.’ ” ");
INSERT INTO akp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Gɔ Yesu ɔɣere ma ara wagbe ɔro ne, ɔɖe ma katɔ̃ ɔɣo Yerusalem ɔri. ");
INSERT INTO akp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ɔwi gɔ ɔ̃ɔbore ɔbo Betfage gu Betania i Nnɔĩ Adziri Kube kuruɛ ne, ɔpia ɔ̃ marasuãdze inyɔ sɔ maɖe katɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ɔɣere ma sɔ, “Misɛ kamagɛĩ ga i bo katɔ̃ ngbe ame. Si mibo ne, mito mianya ɔfirimu ibi iwɛ̃ nɛ makɔra maɣedza fiɛ kuwɛ̃ iisɛ ne iso ɔnya. Mikurisi ne mibɔ me ngbe. ");
INSERT INTO akp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Si ɔrere ɔkarɛ mi sɔ be ɔso mito mikurisi ne ne, miɣere wũ sɔ, ‘Bokɔse nto ɔbie ne.’ ” ");
INSERT INTO akp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Gɔ marasuãdze magbe ɔrui maɣo ɔri ne, manya ira biara lɛ kumɛgɔ i Yesu ɔɣere ma awe. ");
INSERT INTO akp_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ɔwi gɔ mato makurisi bɔi ne, ɔ̃ masate ɔkarɛ ma sɔ, “Be ɔso mito mikurisi wũ?” ");
INSERT INTO akp_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ne marasuãdze ɔtã ma mmuai sɔ, “Bokɔse nto ɔbie wũ.” ");
INSERT INTO akp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Makɔ ɔfirimu ibi mabɔ Yesu. Mawarɛ ma sikati masia bɔi kama ne ka mabuai Yesu ɔta ɔsɛ iso ne. ");
INSERT INTO akp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Gɔ marui ne, mawɛ̃ ɔwarɛ ma sikati masɛ i ɔri sɔ ɔsɛ iso. ");
INSERT INTO akp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ɔwi gɔ i Yesu ɔɔbore ɔbo Yerusalem ngbegɔ i ɔri ɔtsɛ iso i Nnɔĩ Adziri Kube iso ne, ɔ̃ marasuãdze gbodzoo ɔtsɛ Ɣaa siba ipɛ mato mafa kayiɖu teteree iki ɔ̃ ara siare wa manya ɔso. ");
INSERT INTO akp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Mato maɣɛ sɔ, “Ɣaa kusɛkusɛ itã igara gɔ nto ɔba i Bosate iyere ame! Isobuɛ si iwe i Ɣaa sigarakaɖekɔ̃ ɔɖuɖu! Ɣaa ɔkpɛ nɖe ikpawaĩ!” ");
INSERT INTO akp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ne ma Farisise mawɛ̃ i maturi ndɛ̃ to maɣere Yesu sɔ, “Ratedze, sɛ̃ fɔ marasuãdze sɔ malo kulu!” ");
INSERT INTO akp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ne Yesu ɔtã ma mmuai sɔ, “Gbaã nto loɣere mi sɔ si malo kulu ne, ata to aatsɛ kulu ila.” ");
INSERT INTO akp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Gɔ Yesu ɔbore ɔbo ɔmagɛ̃ fiɛ ɔnya wũ ɔsese ne, ɔbiɛ nnɔmɛ i ɔ̃ iti. ");
INSERT INTO akp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ne ɔɣɛ sɔ, “Lobie sɔ tee gbaã ne, aatsue nɔme nnɛ lokotegu-ɔ fiɛ iatã-ɔ isobuɛ. Ɣɛɛ ipɛ i kiniɔ ne, aito anya aɖi ite! ");
INSERT INTO akp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ɔwi to ɔba gɔ fɔ matsirise to maaki malɔ-ɔ i kakɔi biara. Mato maatɛ̃-ɔ mapia masɛ̃ kuyogodɔ̃ gɔ ɔɖuɖu ame aawo ɔki ɔbɔrɛ. ");
INSERT INTO akp_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Mato maabiɛ ɔmagɛ̃ gɔgbe maɖoe maturi ma ɔɖuɖu mpia i ɔ̃ ame. Maibanyua ita kuiwɛ̃ masɛ i ne kasɛkɔ̃. Alasɔ asɛ̃ sɔ aibatsue ɔwi gɔ i Ɣaa ɔba sɔ ɔba ɔɖi-ɔ!” ");
INSERT INTO akp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu ɔsɛ ɔ̃abo Ɣaa isɔrɛyo ɔtsɛ kuɣa maɖese ma mpia i mmɔ isa iɖi. ");
INSERT INTO akp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ne ɔɣere ma sɔ, “Matsɛrɛ mapia i Ɔko Sekelea ame sɔ Ɣaa ɔɣɛ sɔ, ‘Wũ iyo ne, maakpere ne sɔ iyo nɛ ame masɛ makparama kayi.’ Ɣɛɛ miɔsu ne mibara mayukukpe kawɛrɛkɔ̃!” ");
INSERT INTO akp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Iyi biara ne, Yesu ɔte ara i Ɣaa kasɔrɛkɔ̃ mmɔ. Ɣaa masɔrɛdze makpakpa gu kaɖe matɔ̃ɖedze gu mmara matedze ɔbie sɔ maaɖoe wũ. ");
INSERT INTO akp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ɣɛɛ maiɣe ɔri gɔ iso maaki alasɔ maturi gbodzoo pia mmɔ fiɛ mato makã wũ atsue totoroo. ");
INSERT INTO akp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Iyi iwɛ̃ gɔ Yesu pia ɔto ɔte maturi ara i Ɣaa isɔrɛyo ɔɣere ma Itɔ̃me Bielea ne, masɔrɛdze makpakpa gu mmara matedze gu kaɖe matɔ̃ɖedze ɔba mmɔ. ");
INSERT INTO akp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ne maɣere wũ sɔ, “Ɣere bo ngbegɔ ana ɔle gɔ ato abara ala karabara abɔrɛgu. Nna lotã-ɔ ɔle gɔ?” ");
INSERT INTO akp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ne Yesu ɔɣere ma sɔ, “Mitã lokarɛ mi ira iwɛ̃ si mitã me mmuai. ");
INSERT INTO akp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohanes gɔ lopie maturi ndu ne, lɛ ɔna ɔ̃ ɔle ɔbɔrɛgu. Ɣaa kɔrɛ ɛɛbɛrɛ maturi kɔrɛ ɔbɔrɛ?” ");
INSERT INTO akp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ne matsɛ so iwararãgu sɔ, “Be iɖe boaɣɛ? Si boɣɛ sɔ Ɣaa kɔrɛ ɔna ɔle ɔbɔrɛgu ne, ɔto ɔ̃akarɛ bo sɔ, ‘Be ɔso fiɛ miifɔ wũ miɖe?’ ");
INSERT INTO akp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Fiɛ si boɣɛ sɔ maturi kɔrɛ ɔfɔ ɔbɔrɛ gu ne, mma loba maasakanya ngbe to maapɛ bo ata alasɔ ma ɔɖuɖu ɔfɔ maɖe sɔ Ɣaa kanyaɖidze i Yohanes ɖe.” ");
INSERT INTO akp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ne ɔso ne, matã wũ mmuai sɔ, “Boiɣe ngbegɔ ɔna ɔ̃ ɔle ɔbɔrɛgu.” ");
INSERT INTO akp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ne Yesu ɔ̃ wũ ɔɣere ma sɔ, “Mme wũ loibaɣere mi ngbegɔ lona wũ ɔle lobɔrɛgu fiɛ nto lobara karabara gagbe.” ");
INSERT INTO akp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ne Yesu ɔpɛ ma igbã nɛgbe sɔ, “Ɔwi ɔwɛ̃ ne, ɔrɛrɛ̃ ɔwɛ̃ ɔkpɛ̃ adziribi kakpɛkɔ̃. Gɔ ɔto ɔkɛlɛ ɔri dzoroa ɔwɛ̃ ɔso ne, ɔsu kakpɛkɔ̃ ɔpia i mapaase nrɔɔ̃ ame sɔ manyɔ kã iso matã wũ. ");
INSERT INTO akp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Gɔ ɔwi ɔɣo sɔ maasɔrɛ̃ adziribi wamɔ ne, ɔpia ɔ̃ ɔɖabo ɔwɛ̃ sɔ ɔsɛ ɔ̃afɔ ɔ̃ kaɖekɔ̃ ga loaɣo wũ ɔbɔ i mapaase ma mpia i sia kɔrɛ. Ɣɛɛ mapaase mamɔ ɔmɔɛ̃ ɔɖabo gɔgbe mapɛ wũ, masa wũ masese nrɔɔ̃ kunu. ");
INSERT INTO akp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ne ɔso ɔpia ɔɖabo mama. Ɣɛɛ ɔ̃ wũ mapaase mamɔ ɔpɛ wũ, masopara wũ, makpesera wũ masese nrɔɔ̃ kunu. ");
INSERT INTO akp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ɔledza ɔɖabo tɛare ipia. Ɔ̃ ne, mapɛ wũ maɖi wũ igbɛ masa wũ maɖi i sia mmɔ. ");
INSERT INTO akp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ne kakpɛkɔ̃ Sate gɔmɔ ɔkarɛ so sɔ, ‘Be loabara? Loasese wũ ɔbi ɖɔɛse. Lofɔ loɖe sɔ mato maawarɛ wũ.’ ");
INSERT INTO akp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ɣɛɛ gɔ mapaase ɔnya ɔbi gɔmɔ ne, maɣere so sɔ, ‘Nya kakpɛkɔ̃ Sate mɔmɔ ɔbi nto ɔba ngbe. Mitã boɖoe wũ si ara wagbe ɔɖuɖu aakpese bo are!’ ");
INSERT INTO akp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ne ɔso mafuĩdza wũ maɖi i ɔkpã ame ne maɖoe wũ ne.” Ne Yesu ɔkarɛ ma sɔ, “Be i kakpɛkɔ̃ sate aabara mafɔ magbe? ");
INSERT INTO akp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ɔto ɔ̃aba ɔ̃aɖoe mapaase magbe ɔɖi i kakpɛkɔ̃ ame ɔbie maturi mama ɔpia i kã ame.” Gɔ maturi ɔnɔ ngbɔ ne, maɣɛ sɔ, “Ooɣo, iibaba ngbɔ!” ");
INSERT INTO akp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu ɔkarã ma anɔ iso ɔkarɛ ma sɔ, “Ɣaa itɔ̃me nɛ matsɛrɛ masɛ ngbe karɔ̃ ɣɛɛ? ‘Ita nɛ i mayotsuedze ɔsɛ̃ sɔ iilɛ ne, ne loba iakpese ita nɛ lonya iɖo pelepele ne.’ ");
INSERT INTO akp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ɔbiara gɔ loatura i ita nɛmɔ iso ne, ɔto ɔ̃afɛfɛ̃ ɖukuɖuku. Fiɛ si ita nɛmɔ ɔkpase iwuĩ ɔrere ne, ito iakɔtɛ wũ ɖɛkpɛrɛɛ.” ");
INSERT INTO akp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mmara matedze gu masɔrɛdze makpakpa ɔbie sɔ si mamɔɛ̃ Yesu mmɔ alasɔ maɣe sɔ ma iso ɔpɛ igbã nɛmɔ. Ɣɛɛ manigã maturi mamɔ. ");
INSERT INTO akp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ne ɔso ne, matsɛ ɔri mama gɔ iso maaki fiɛ maamɔɛ̃ wũ ibie. Mapia maturi i iwɛrɛ ame sɔ mabara so lɛ mma nto manyɔnyɔ ɔnukuare si masɛ maakarɛ Yesu atɔ̃me wa loapia wũ i kulu ame si maawo wũ ɔɖi ɔtã ma Romase abã. ");
INSERT INTO akp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ne ɔso kanyamaɖaɛse magbe ɔkɛlɛ Yesu kɔrɛ masɛ maakarɛ wũ sɔ, “Ratedze boɣe sɔ fɔ ne, ɔnukuare ara asɛ ate ɔwi biara. Boɣe sɔ fɔ ara ite ame ne, aisɛ anyɔ ɔturi i katɔ̃ ɣɛɛ asɛ aɣɛ nnɛ loabo Ɣaa anɔ iiɖe nnɛ i maturi sɛ maɖɔɛ. ");
INSERT INTO akp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Bobie sɔ ɣere bo si ilɛ sɔ boatã ma Romase Igarakpakpa lampo.” ");
INSERT INTO akp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ɣɛɛ gɔ Yesu ka ɔɣe ma adzuni nyanyarĩa ɔso ne, ɔkarɛ ma sɔ, ");
INSERT INTO akp_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Misu sikãfudza ibi iwɛ̃ mibɔ me. Nna iti gu iyere nsia iso ngbe?” ");
INSERT INTO akp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ne matã wũ mmuai sɔ, “Igarakpakpa Kaisaro ire iɖe.” Ne Yesu ɔɣere ma sɔ, “Misu nnɛ nɖe Kaisaro ire mitã wũ si misu nnɛ nɖe Ɣaa ire ana mitã Ɣaa.” ");
INSERT INTO akp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","I maturi katɔ̃ mmɔ ne, maiwo wũ ɔmɔɛ̃ i itɔ̃me kuiwɛ̃ iso. Ati ɔmɔ ma i mmuai mɛ i Yesu ɔtã ma iso fiɛ ibara ma ɣii ana. ");
INSERT INTO akp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ma Zadukise ma nsɛ maɣɛ sɔ makpise iisibata ɔba Yesu kɔrɛ maba maakarɛ wũ sɔ, ");
INSERT INTO akp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ratedze, Mose ɔtsɛrɛ ɔpia i mmara ame ɔtã bo sɔ, ‘Si ɔrɛrɛ̃ ɔkpi ɔnyua ɔ̃ ɔre fiɛ maiɣe ɔbi ne, ɔrɛrɛ̃ gɔmɔ ɔnyiibi si ɔsu kpise ɔre ɔyiri. Mabi ma i ɔ̃ gu kpise ɔre gɔmɔ aaɣe ne, maanyɔ ma lɛ ɔ̃ ɔnyiibi gɔ loɔkpi mabi.’ ");
INSERT INTO akp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ɔwi ɔwɛ̃ ame ne, manyiibi rɛrɛ̃ ikɔdzɛ mawɛ̃ ɔwe. Kpakpare ɔyiri ɔrɔ̃go, iina ɔpã kere ɔba ɔ̃akpi ɔɣɛ wũ gɔ maiɣe ɔbi. ");
INSERT INTO akp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ɔ̃ ɔkpeama gɔ nsiai wũ ɔyiri kuɛdze gɔmɔ. ");
INSERT INTO akp_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ɔtɛare ɔ̃ wũ ngbɔ ame gbɔgbɔɔgbɔ isɛ iabo ɔkɔdzɛva. Ma ɔɖuɖu ɔyiri ɔrɔ̃go gɔmɔ makã maiɣe ɔbi. ");
INSERT INTO akp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kawirikɔ̃ ne, ɔrɔ̃go ɔ̃ wũ ɔba ɔ̃akpi. ");
INSERT INTO akp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kiniɔ ne, si makpise ɔba maatã ne, ma ndɛ̃ ɔmele loayiri ɔrɔ̃go gɔgbe gɔ ma ikɔdzɛ ɔɖuɖu ɔyiri wũ manya?” ");
INSERT INTO akp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu Ɔtã ma mmuai sɔ, “Marɛrɛ̃ gu marɔ̃go sɛ mayiri so i ngbã mɛgbe ame. ");
INSERT INTO akp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ɣɛɛ marɛrɛ̃ gu marɔ̃go ma ɔɖuɖu ma lokote sɔ maata masɛ ngbã mɛ loisɛ miro ne, maisibayiri so i ngbã mɛmɔ ame. ");
INSERT INTO akp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Maase lɛ Ɣaa makpabo awe gɔ maisibakpi manya. Ka maɖe Ɣaa mabi ala maɔta mabɔrɛ i makpise ame. ");
INSERT INTO akp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mose ɔtsɛrɛ ɔpia i Ɔko Sekelea ame sɔ makpise to maaledza ita iwe ngbã. Alasɔ ɔwi gɔ ame ɔɣɛ i miyu kadzirimi ga nto katsue kɔrɛ ne, ɔkpere Ɣaa sɔ Abraham Ɣaa gu Isak Ɣaa gu Yakob Ɣaa. ");
INSERT INTO akp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Magbanadze Ɣaa ɔɖe, iiɖe makpise ɔre ɔɖe. Ne ɔso i ɔ̃ kɔrɛ ne, makpise ana ba ngbã.” ");
INSERT INTO akp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mmara matedze mawɛ̃ ma nɣɛ i mmɔ ɔɖi kanya sɔ, “Ratedze, abua atã mmuai gbaã!” ");
INSERT INTO akp_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ne kama ne, kuwɛ̃ iisiwe ɔtu ɔkarɛ wũ kuira. ");
INSERT INTO akp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu ɔkarɛ ma sɔ, “Be ɔso fiɛ maturi sɛ maɣɛ sɔ Kristo ne, David ɔwa tɛtɛ ɔɖe? ");
INSERT INTO akp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Alasɔ David mɔmɔ ɔɣɛ i ɔ̃ Sinɔ ɔko ame sɔ, ‘Bosate ɔɣere Wũ Sate sɔ, “Sɛ i wũ kuɖearɔ̃ iso ");
INSERT INTO akp_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","gbɔgbɔɔgbɔ loasu fɔ matsirise lopia i fɔ ngba kayirinɔ?” ’ ");
INSERT INTO akp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Si David to ɔkpere wũ sɔ ɔ̃ Sate ne, nda iabara fiɛ Kristo aaɖe David ɔ̃ ɔwa tɛtɛ?” ");
INSERT INTO akp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ɔwi gɔ i ma ɔɖuɖu ɣɛ mato makã nnɛ i Yesu to ɔɣɛ atsue ne, ɔɣere ɔ̃ marasuãdze sɔ, ");
INSERT INTO akp_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Midzuɛ̃ so i mmara matedze iso. Masɛ maɖɔɛ mawe maki ku ma awu siare. Masɛ mabie sɔ maturi si mabɔ so karɔ̃ maya ma i kuɣa ame. Masɛ mabie nsɛkɔ̃ kɔlɛa i ma Yudase kasarɛkɔ̃ gu sipɔrɔ̃ katukɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Masɛ mate so lɛ makuɛdze mabuaidze ɣɛɛ masɔsɔla ma mafɔ ma ara. Masɛ mate so iki i ma kayi ikparama tagbaraa ame. Ne ɔso ma kutsue ikpadzɛ̃ to iasi gbaã!” ");
INSERT INTO akp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","I Isɔrɛyo mmɔ ne, Yesu ɔtara anɔ kato ɔnya kumɛgɔ i maranase to masu ma karatã mapia i ira nɛ ame mato mato ara mapia. ");
INSERT INTO akp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ɔnya wɛrɛba kuɛdze ɔwɛ̃ gɔ ɔ̃ wũ ɔsu kupɛrɛ kunyɔ ɔba ɔ̃apia i kame. ");
INSERT INTO akp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ne ɔɣere ma sɔ, “Nto loɣere mi sɔ kuɛdze gɔgbe ne, ɔtã ara ɔɖo ma ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Alasɔ matsɔra ne, ma karana ame kere maɖi kɛkɛĩ maba maatã. Ɣɛɛ kuɛdze gɔgbe ne, i ɔ̃ kusa ame nnɛ ɔɖuɖu ɔba ɔ̃aɖe iɖe ɔsu ɔba ɔ̃ato ngbe.” ");
INSERT INTO akp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Marasuãdze mawɛ̃ to maɖe ika i Ɣaa kasɔrɛkɔ̃ iso kumɛgɔ ibua ito ilɛ ɔnyɔ, ata wa masu matsue ala gu karatã ga i maturi sɛ matã i mmɔ. Ne Yesu ɔɣere ma sɔ, ");
INSERT INTO akp_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ira biara nɛ mito minya ngbe ne, ɔwi to ɔba gɔ ku ita iibasia i nɛ ɔlaa iso. Mato maasasamara ira biara mafere i karɔ̃.” ");
INSERT INTO akp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mmɔ mato makarɛ wũ sɔ, “Ratedze, ku mme ɔwi iaba ngbɔ? Fiɛ be loate sɔ ɔwi ɔɔɣo gɔ ara wagbe aaba?” ");
INSERT INTO akp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu ɔɣere ma sɔ, “Midzuɛ̃ so sɔ kuwɛ̃ iibasɔsɔla mi. Maturi gbodzoo to maaba i wũ iyere ame sɔ wũ itɔ̃me mato maɣɛ. Mato maaɣɛ sɔ, ‘Mme nɖe wũ’ fiɛ ‘Ɔwi ɔɔɣo.’ Ɣɛɛ midaasiai ma. ");
INSERT INTO akp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Midaanigã si minɔ kakpã kulu gu maturi ita iya so iso. Ara wagbe igbã to aaba, ɣɛɛ iite sɔ kawirikɔ̃ ɔɔɣo.” ");
INSERT INTO akp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesu ɔkɛlɛgu i katɔ̃ ɔɣere ma sɔ, “Karɔ̃ to kaakpɛ̃ gu karɔ̃ fiɛ sigarakaɖekɔ̃ aka anyɔ to aakpɛ̃gu so. ");
INSERT INTO akp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Karɔ̃ to kaati i ngɔi. Kukã siare to kuabo fiɛ sinyɛ agbãagbã ana to siaba. Afɔ̃ra ana to aabɔrɛ i kuɖokpo. ");
INSERT INTO akp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Si ara wagbe aaba ne, mato maamɔɛ̃ mi, makpɛ̃gu mi. Mato maakɔ mi makɛlɛgu ma Yudase kasarɛkɔ̃, maapia mi iyo. Mato maakɔ mi makɛlɛgu magara gu matɔ̃ɖedze katɔ̃ sɔ maaɣɛgu mi atɔ̃me ala wũ ɔso. ");
INSERT INTO akp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ɔwi gɔmɔ ame loaɖe ɔwi sɛɛ gɔ ame miaɣɛ Ɣaa Itɔ̃me Bielea ne. ");
INSERT INTO akp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mibara mi adzuni sɔ miibamararã so kumɛgɔ miaɖi so kanya iso. ");
INSERT INTO akp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Alasɔ nto loatã mi atɔ̃me gu iwola nɛ kanya i mi matsirise kuwɛ̃ iibawo ɔya manya. ");
INSERT INTO akp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mi maɣese gu manyiibi gu mi mɔmɔ malɛdze gu mi malaa to maaɖi mi matã. Mato maaɖoe mi mawɛ̃. ");
INSERT INTO akp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ɔbiara to ɔ̃atsiri mi ala wũ ɔso. ");
INSERT INTO akp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ɣɛɛ nane ɔnidzɔ iibasɛ mi i iso. ");
INSERT INTO akp_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Miya teteree fiɛ miana ngbã mɛ loisɛ miro. ");
INSERT INTO akp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ɔwi gɔ mianya sɔ makpakpɛ̃dze ɔba maaki malɔ Yerusalem ne, mitsue sɔ ɔmagɛ̃ ɔbiɛwi ɔɔɣo. ");
INSERT INTO akp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mma mpia i Yudea si matere makɛlɛ abe iso, mma mpia i ɔmagɛ̃ ame si matere mabɔrɛ. Mma mpia i miya si madaakpese maba ɔmagɛ̃ ame. ");
INSERT INTO akp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Alasɔ ɔwi gɔmɔ to ɔ̃aɖe kutsue ikpadzɛ̃ ɔwi lɛ kumɛgɔ i Ɔko Sekelea Ɔɣɛ ɔsɛ awe. ");
INSERT INTO akp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ɔwi gɔmɔ to ɔ̃awe ɔle ɔtã marɔ̃go ma nto nyiri gu matalɛpo ma nto mabi ɣɛtɛ. Inyɛwe siare to iaba i karɔ̃ gagbe iso. Ɣaa kutsue ikpadzɛ̃ to iaba maturi magbe iso. ");
INSERT INTO akp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mato maaɖoe mawɛ̃ ala ipɛmi fiɛ maamɔɛ̃ mawɛ̃ ana makɛlɛgu nrɔ̃ mama iso. Mma loiɖe ma Yudase to maaɖe sigara ku ɔtile i Yerusalem iso isɛ iabo ɔwi gɔ i Ɣaa ɔtɔrã ɔtã ma. ");
INSERT INTO akp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Awawãra agbãagbã to aaba i kuɣɛ̃ gu ɔgbaworeti gu awami iso. Kayiiso ɔɖuɖu to kaayu ɔriinyɔ. Ifɔ̃ siare to iamɔɛ̃ maturi ala kumɛgɔ i ɔpo to ɔ̃asia so ara ɔso. ");
INSERT INTO akp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Maturi to maasɛ̃ kulele ala ifɔ̃ nɛ nto ma gɔ maiɣe nnɛ nto iaba i kayi ɔɖuɖu iso ɔso. Sile dzɛ i kuɖokpo ame ɔɖuɖu to siati teteree i sɛ̃ kusɛkɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ne kama ne, Ɔturi Awune Ɔbi to ɔ̃abɔrɛ i adɔdɔ ame gu ɔ̃ ɔle gu ifiɛ teteree ame. ");
INSERT INTO akp_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Si ara wagbe ɔnya asɔ̃ katɔ̃ ne, miledza so si mitsɛ ɔri inyɔ alasɔ mi iɖi ɔwi ɔɔbore ɔbo.” ");
INSERT INTO akp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ne Yesu to ɔpɛ ma igbã iwɛ̃ sɔ, “Mikarã inɔ i kuɖedziri gu adziri agbã mama iso. ");
INSERT INTO akp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Si minya sɔ ato aɖi aɣata ɣɛtɛ ne, misɛ miɣɛ sɔ kusɛ ɔɔɣo. ");
INSERT INTO akp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ngbɔ ame si minya ara wagbe to aba ne, mitsue sɔ Ɣaa sigarakaɖekɔ̃ ɔɔbore sibo. ");
INSERT INTO akp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nto loɣere mi sɔ ara wagbe ɔɖuɖu to aaba fiɛ mi mawɛ̃ ma nɣɛ ngbe aakpi miro. ");
INSERT INTO akp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kato gu karɔ̃ to kaafe, ɣɛɛ wũ atɔ̃me iibafe anya ɖa. ");
INSERT INTO akp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Minyɔ so kukaakɔ sɔ miibanina ɔwi i ɔɖegbodzo gu itarɛ̃ iso. Midaasɛ mimararã so i kayiiso ara iti. Si iiɖe ngbɔ ne, iyi nɛmɔ to iapatu imɔɛ̃ mi lɛ iyebi. ");
INSERT INTO akp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ito iapatura kayiiso maturi ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","“Ne ɔso midzuɛ̃ so si mila miɔkparama kayi ɔwi biara sɔ miana ɔle miya teteree mibɔrɛ i inyɛwe nɛmɔ ame sɔ miaya bɔlɔlɔ i Ɔturi Awune Ɔbi anɔ.” ");
INSERT INTO akp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ayi wamɔ ɔɖuɖu ne, Yesu ɔsu ɔte maturi ara i Ɣaa kasɔrɛkɔ̃. Kutsuɛ biara ne, ɔsɛ ɔkɛlɛ Nnɔĩ Adziri Kube iso ɔ̃awe i kasɛ̃ ame. ");
INSERT INTO akp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kaya tutuutu biara ne, maturi ɔɖuɖu sɛ mata maba isɔrɛyo maba maakã ɔ̃ ara ite atsue. ");
INSERT INTO akp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ɔwi ɔɔɣo gɔ ma Yudase aaɖe Boɖoboɖo Gɔ Loita Iyi nɛ masɛ marɔ ana sɔ Kukpi Ɔtakuwara Bo Iyi. ");
INSERT INTO akp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ɣɛɛ gɔ Ɣaa masɔrɛdze makpakpa gu mmara matedze to manigã maturi ɔso ne, matsɛ ɔri gɔ iso maaki fiɛ maaɖoe Yesu i iwɛrɛ ame ibie. ");
INSERT INTO akp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ɔbosam ɔbo i Yuda gɔ marɔ Iskariot fiɛ ɔ̃ wũ ɔɖe Yesu marasuãdze iweo-inyɔ ndɛ̃ ɔwɛ̃ ame. ");
INSERT INTO akp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ne ɔso Yuda ɔkɛlɛ Ɣaa masɔrɛdze makpakpa gu mma nsɛ madzuɛ̃ Ɣaa isɔrɛyo makpakpa kɔrɛ masɛ maasɛ iti ame i ɔri gɔ iso ɔ̃aki fiɛ ɔ̃aɖi Yesu ɔtã ma. ");
INSERT INTO akp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Mana isoɣɔ gbaã, ne ɔso maɣɛ sɔ maatã wũ kuso. ");
INSERT INTO akp_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda ɔ̃ wũ ɔnɔ karɔ̃, ne ɔso ɔtsɛ ɔri sɛɛ gɔ iso ɔ̃aki fiɛ ɔ̃aɖi Yesu ɔtã ma ibie. ");
INSERT INTO akp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Iyi ɔba iaɣo nɛ masɛ maɖe Boɖoboɖo Gɔ Loita Iyi fiɛ ɔwi gɔmɔ ame ame masɛ maɖoe Kukpi Ɔtakuwara Bo Sɛrɛ maɖe ana ne. ");
INSERT INTO akp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu Ɔpia Petro gu Yohanes ɔɖegu katɔ̃ sɔ, “Misɛ mialedza Kukpi Ɔtakuwara Bo aɖera wa boaɖe misɛ.” ");
INSERT INTO akp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ne mato makarɛ wũ sɔ, “Lɛ ato abie sɔ boledza bosɛ?” ");
INSERT INTO akp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ne ɔɣere ma sɔ, “Si mibo Yerusalem ɔmagɛ̃ ame ne, Ɔrɛrɛ̃ ɔwɛ̃ gɔ nsore ndu ku ibui to ɔ̃asarɛgu mi. Misiai wũ misɛ miabo i iyo nɛ ame ɔ̃abo. ");
INSERT INTO akp_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Miɣere iyo nɛmɔ sate sɔ, ‘Ratedze sɔ bokarɛ-ɔ sɔ, “Mme iyo nse gɔ mme gu wũ marasuãdze aaɖe Kukpi Ɔtakuwara Bo aɖera?” ’ ");
INSERT INTO akp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ɔto ɔ̃ate mi iwɛ̃ i iyo siare nɛ matsue masia i kato fiɛ maledza ne, masɛ kuta ayara. Miledza ibiara misɛ i mmɔ.” ");
INSERT INTO akp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Gɔ maɣo ɔri ne, masɛ maanya ira biara lɛ kumɛgɔ i Yesu ɔɣere ma. Ne mawa Kukpi Ɔtakuwara Bo aɖera ne. ");
INSERT INTO akp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Gɔ ɔwi ɔɣo ne, Yesu gu ɔ̃ katɔ̃memasɛdze ɔsɛ i karɔ̃ sɔ maaɖe ara. ");
INSERT INTO akp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ne ɔɣere ma sɔ, “Iɖe wũ kuɖɔɛ kokooko sɔ loaɖegu mi Kukpi Ɔtakuwara Bo aɖera wagbe fiɛ inyɛwe aatu me. ");
INSERT INTO akp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nto loɣere mi sekelee sɔ loisibaɖe aɖera wagbe lonya gbɔgbɔɔgbɔ ɔwi gɔ boanɔ wã karɔ̃ i Ɣaa sigarakaɖekɔ̃.” ");
INSERT INTO akp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ne kama ne, Yesu ɔsu itãkɔi, ɔpɛ Ɣaa Siba. Ne ɔɣere ma sɔ, “Mifɔ si minɛ mitã so. ");
INSERT INTO akp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nto loɣere mi sɔ ita i kiniɔ ito ikɛlɛ ne, loisibanɛ ndã mɛgbe gbɔgbɔɔgbɔ ɔwi gɔ i Ɣaa sigara iɖe aaba.” ");
INSERT INTO akp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ne ka ɔsu boɖoboɖo ɔpɛ Ɣaa siba i ɔ̃ iti ne. Ɔbɛse wũ kusɛkusɛ ɔsu ɔtã ma. Ne ɔɣere ma sɔ, “Wũ sosina dzɛ losu lotã i mi iti ngbe ne. Mibara ne si misu minyigi me.” ");
INSERT INTO akp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ngbɔ ame ɔsu itãkɔi nɛ ame i ndã pia ɔtã ma gɔ maɖe ara maro. Ne ɔɣere ma sɔ, “Ikɔi nɛgbe nɖe Ɣaa kanya ɣɛtɛ ga ɔto ɔnyigu mi ikparĩ ala wũ ima nɛ loafere i karɔ̃ ala mi ɔso ne. ");
INSERT INTO akp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ɣɛɛ ne, mitsue sɔ ngɔ loaɖi me ɔtã wũ matsirise si ɔto ɔɖegu me aɖera i ngbe. ");
INSERT INTO akp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mme, Ɔturi Awune Ɔbi ne, nto loakpi lɛ kumɛgɔ i Ɣaa ɔsia ita. Ɣɛɛ ne, ndzo mitã ngɔ loaɖi me ɔtã.” ");
INSERT INTO akp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ne matsɛ so ikakarɛ sɔ, ma ndɛ̃ nna loabara ira nɛgbe igbã. ");
INSERT INTO akp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kakpadzɛ̃ kawɛ̃ ɔbo i marasuãdze ndɛ̃ mabie sɔ matsue ma ndɛ̃ ngɔ nɖe ɔsiare pelepele. ");
INSERT INTO akp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ne Yesu ɔɣere ma sɔ, “Kayiiso magara ma loiɖe ma Yudase sɛ mate so mapia mma mato maɖe iso fiɛ maba ɔle i ma iso. Magara magbe sɛ mafera so sɔ ma nɖe Maturi Malaa. ");
INSERT INTO akp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ɣɛɛ iikote sɔ iase ngbɔ i mi ndɛ̃. Ngɔ nɖe ɔsiare i mi ɔɖuɖu ndɛ̃ ne, ɔ̃ ikote sɔ ɔ̃abara so ɔbiɛtɛ si mi tɔ̃ɖedze si ɔsu so ɔbara ɔɖabo. ");
INSERT INTO akp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nna nɖe ɔkpakpa? Ngɔ nsi i karɔ̃ ɔto ɔɖe ara ɛɛbɛrɛ ngɔ nto ɔtu wũ ɔpɔrɔ̃? Ikpa sekelee sɔ ngɔ nsi i karɔ̃ ɔto ɔɖe ara loɖo. Ɣɛɛ lopia i mi ndɛ̃ lɛ ngɔ nto ɔsumu mi awe. ");
INSERT INTO akp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Miɔpia kubɛ misiai me i wũ amɔrɛ̃ ɔwi ɔɖuɖu ame. ");
INSERT INTO akp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kumɛgɔ ame i Tete ɔtã me ɔle sɔ loɖe maturi iso ne, ngbɔ ame loatã mi ɔle mi wũ ne. ");
INSERT INTO akp_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mito miaɖe minɛgu me ara i wũ sigarakaɖekɔ̃ fiɛ miasɛ i sigara ayara iso miɖe sigara i Israel nlɛ aka aweo-anyɔ iso.” ");
INSERT INTO akp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ne Yesu to ɔɣere Simon Petro sɔ, “Simon Simon! Kã atsue! Ɣaa ɔtã Ɔbosam ɔri sɔ ɔla mi ɔnyɔ si ɔnyɔ mma nɖe masɛɛ gu mma loilɛ lɛ kumɛgɔ i kpɛ̃dze sɛ ɔfuri simɔɣo ɔɖi i kamɔ ame. ");
INSERT INTO akp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ɣɛɛ ne, Simon, loɔkparama kayi i fɔ iti sɔ fɔ kafɔkaɖe iibakpase. Si ɔɔkpese aya parataa ne, pia fɔ manyiibi tsɔra ɔle.” ");
INSERT INTO akp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ne Petro to ɔɣere wũ sɔ, “Bokɔse, loɣɛ teteree sɔ si inya ne, maapia bo gu-ɔ i iyo ɣee lokpigu-ɔ.” ");
INSERT INTO akp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ne Yesu ɔɣere Petro sɔ, “Petro, nto loɣere-ɔ sɔ kasɛ̃ gagbe si kɔkɔ aaɖi kanya ne, ato aasɛ̃ me ikpɛ itɛ sɔ aiɣe me.” ");
INSERT INTO akp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ne Yesu to ɔkarɛ ɔ̃ marasuãdze sɔ, “Ɔwi gɔ lofe ame gɔ lopia mi katɔ̃me fiɛ mme sɔ midaasu sikã kakotoi ɣee akpo ɣee ndokota ne, ira iwɛ̃ ɔnya mi?” Ne matã wũ mmuai sɔ, “Ooɣo kuira iinya bo kuwɛ̃.” ");
INSERT INTO akp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Mmɔ i Yesu to ɔɣere ma sɔ, “Ɣɛɛ kiniɔ ne, ɔbiara gɔ mba sikã kawumi ɣee akpo ne, ɔsu ɔla. Ngɔ nna ipɛmi ne, ɔsu ɔ̃ arapia ɔrɔdɛ̃ si ɔsɛ ɔ̃aɣa ipɛmi. ");
INSERT INTO akp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Fiɛ nto loɣere mi sɔ, Ɔko Sekelea ame itɔ̃me nɛ loɣɛ sɔ, ‘Maaka wũ mapia i maturi lalaa ndɛ̃’ ne, ka iba ngbɔ. Alasɔ ira nɛ matsɛrɛ i wũ iso ne, ikote sɔ iaba i ne ame.” ");
INSERT INTO akp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ne marasuãdze to maɣere wũ sɔ, “Bokɔse, Nyɔ! Nya apɛmi anyɔ ngbe!” Ne ɔɣere ma sɔ, “Ka ilɛ.” ");
INSERT INTO akp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu ɔbɔrɛ i ɔmagɛ̃ ame ɔkɛlɛ Nnɔĩ Adziri Kube iso lɛ kumɛgɔ ɔsɛ ɔɖɔɛ ɔbara. Ɔ̃ marasuãdze ana siai wũ. ");
INSERT INTO akp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Gɔ ɔbo mmɔ ne, Yesu ɔɣere ɔ̃ marasuãdze sɔ, “Mikparama kayi si miibabo i ilainyɔ ame.” ");
INSERT INTO akp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ɔrui ɔnyua ma ɔkɛlɛ katɔ̃ kɛkɛĩ ne ɔpɛ agɛgɛ̃ ɔkparama kayi ɔɣɛ sɔ, ");
INSERT INTO akp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tete, si aatɔrã ne, ɖi inyɛwe ikɔi nɛgbe bɔrɛgu me iso iiɖe wũ kuɖɔɛ sɔ bara ne fɔ kure.” ");
INSERT INTO akp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ne Ɣaa Kpabo ɔwɛ̃ ɔbɔrɛ i kato ɔba ɔ̃apia wũ ɔle ne. ");
INSERT INTO akp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","I isomararã siare ame ne, ɔledza kayi ikparama ku anɔ rɛtɛa. Awururu wa nto abɔrɛ wũ iso se lɛ ima nto ifere i karɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Gɔ Yesu ɔta i ngbegɔ ɔto ɔkparama kayi ne, ɔkpese ɔkɛlɛ ɔ̃ marasuãdze kɔrɛ. Ɔba ɔ̃anya sɔ mato marɛ sirɛ alasɔ isoma ɔmɔɛ̃ ma. ");
INSERT INTO akp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ne ɔɣere ma sɔ, “Be ɔso mito mirɛ sirɛ? Mita si mikparama kayi si miibabo i ilainyɔ ame.” ");
INSERT INTO akp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Gɔ Yesu ɣɛ ɔtogu ma ika iɖe ne, maturi gbodzoo ɔba maabo ma iso. Yuda gɔ nɖe marasuãdze iweo-inyɔ ndɛ̃ ɔwɛ̃ nɖe ma katɔ̃. Ɔkɛlɛ Yesu kɔrɛ ɔsɛ ɔ̃amini wũ. ");
INSERT INTO akp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ɣɛɛ Yesu ɔkarɛ Yuda sɔ, “Yuda, iminigu asu ato aɖi me, Ɔturi Awune Ɔbi atã?” ");
INSERT INTO akp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ɔwi gɔ i marasuãdze ma mpia i mmɔ gu Yesu ɔnya nnɛ nto iba ne, makarɛ wũ sɔ, “Bokɔse, bokpɛ̃gu ma ala bo apɛmi?” ");
INSERT INTO akp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ne marasuãdze ndɛ̃ ɔwɛ̃ ɔɖi ipɛmi ɔtu masɔrɛdze ɔkpakpa pelepele ɔɖabo kuɖearɔ̃ kutsue ɔɖi ne. ");
INSERT INTO akp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ɣɛɛ Yesu ɔsɛ̃ ɔtã ma sɔ, “Midaabara!” Ɔpɛgu ɔɖabo gɔmɔ kutsue kere ne ɔsa wũ ne. ");
INSERT INTO akp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ne Yesu to ɔkarɛ masɔrɛdze makpakpa gu kasɔrɛkɔ̃ madzuɛ̃se makpakpa gu kaɖe makpakpa ma loba mamɔɛ̃ wũ sɔ, “Be ɔso fiɛ mito kudziriku gu apɛmi lɛ turiɖoese loɖe? ");
INSERT INTO akp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Lowe i mi kɔrɛ i ma Yudase isɔrɛyo iyi biara ɣɛɛ miimɔɛ̃ me. Ɣaa lotã mi ɔri gɔgbe fiɛ idududu ame ɔle nto ɔɖe mi iso kiniɔ.” ");
INSERT INTO akp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Mamɔɛ̃ Yesu makɔ wũ makɛlɛgu masɔrɛdze ɔkpakpa pelepele iyo. Petro ana siai ma i kama kama. ");
INSERT INTO akp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mapia ɔtɔ i inyamɔ, ne ɔso Petro ɔ̃ wũ ɔsɛ ɔ̃asɛ i ma kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Gɔ ɔɖabo rɔ̃go ɔwɛ̃ ɔnya Petro si i ɔtɔ katɔ̃ mmɔ ne, ɔnyɔ wũ totoroo ɔɣɛ sɔ, “Ngɔgbe ɔ̃ wũ Yesu siaidze ɔwɛ̃ ɔɖe.” ");
INSERT INTO akp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ɣɛɛ Petro ɔsɛ̃ ɔɣɛ sɔ, “Ɔrɔ̃go, loiɣe wũ kɔra!” ");
INSERT INTO akp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ɔwi kurukutu kama ne, ɔwɛ̃ ana ɔnya Petro ɔɖi ite ne ɔɣere wũ sɔ, “Fɔ wũ ma ndɛ̃ ɔwɛ̃ aɖe.” Ɣɛɛ Petro ɔledza iɣɛ sɔ, “Ɔrɛrɛĩ, iiɖe mme loɖe!” ");
INSERT INTO akp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Si iabara lɛ ɔɖɔwũ kama ne, ɔrɛrɛ̃ mama ana gɔ nɣɛ i mmɔ ɔledza irɔĩ ikarã teteree sɔ, “Kakpadzɛ̃ kukawɛ̃ na i ne ame sɔ ɔrɛrɛ̃ gɔgbe ana ɔsiai Yesu alasɔ Galilea ɔturi ɔɖe.” ");
INSERT INTO akp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ɣɛɛ Petro ɔtã mmuai sɔ, “Nyɔ me ɔrɛrɛ̃, nnɛ ato aɣɛ ngbe ne, loiɣe kuira i ne iso.” Gɔ ɔɣɛ ɔto ɔɣɛ nnɛgbe ne, makɔkɔ ɔɖi kanya. ");
INSERT INTO akp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ne Bosate ɔfiniki ɔnyɔ Petro ne. Ɔnyigi nnɛ i Bosate ɔɣere wũ sɔ, “Si makɔkɔ aaɖi kanya nɔme kasɛ̃ gagbe ne, ato aasɛ̃ me ikpɛ itɛ sɔ aiɣe me.” ");
INSERT INTO akp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Petro ɔbɔrɛ ɔkɛlɛ inyamɔ ɔsɛ ɔ̃abiɛ teteree. ");
INSERT INTO akp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mma nto madzuɛ̃ Yesu ɔtsɛ wũ aɣiãra ibara ipɛ wũ. ");
INSERT INTO akp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Masu ira manyi wũ katɔ̃ mapɛ wũ iyɔ maɔkarɛ wũ sɔ, “Ɣere bo ngɔ lopɛ-ɔ!” ");
INSERT INTO akp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Matia wũ i siri agbãagbã ana iso. ");
INSERT INTO akp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Gɔ kaɖe ɔsɛ̃ ne, kaɖe makpakpa gu Ɣaa masɔrɛdze makpakpa gu mmara matedze ɔsakanya ne makɔ Yesu mabɔ ma katɔ̃ ne. ");
INSERT INTO akp_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Mma losakanya i mmɔ ɔkarɛ Yesu sɔ, “Ɣere bo si fɔ nɖe Kristo.” Ne ɔtã ma mmuai sɔ, “Si loɣere mi ira irere kɔra ne, miibafɔ miɖe. ");
INSERT INTO akp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Fiɛ si lokarɛ mi itɔ̃me irere ne, miibatã me mmuai. ");
INSERT INTO akp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ɣɛɛ ita i kiniɔ ito ikɛlɛ ne, Ɣaa, Ɔlesate to ɔ̃atara me, Ɔturi Awune Ɔbi, ɔsɛra i ɔ̃ kuɖearɔ̃ iso.” ");
INSERT INTO akp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ne ma ɔɖuɖu to makarɛ wũ sɔ, “Iyɔ ite sɔ fɔ nɖe Ɣaa ɔbi?” Ne ɔtã mmuai sɔ, “Ise lɛ kumɛgɔ miɣɛ.” ");
INSERT INTO akp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ne maɣɛ sɔ, “Iisinya sɔ kuwɛ̃ aaba ɔ̃aɣere bo kuira i ɔ̃ iso. Bo mɔmɔ ɔɔnɔ ara wa ɔto ɔɣɛ!” ");
INSERT INTO akp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ne ma ɔɖuɖu ɔta makɔ Yesu makɛlɛgu Pilato ne. ");
INSERT INTO akp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Matsɛ wũ kanya iɖaɛ sɔ, “Bomɔɛ̃ ɔrɛrɛ̃ gɔgbe gɔ ɔto ɔkã bo aɖe kaɖe ɔyura. Ɔto ɔɣere ma sɔ madaatã lampo gɔ i ma Romase igarakpakpa ɔsia. Ɔɣɛ sɔ ɔ̃ nɖe Kristo fiɛ ɔmɔɛ̃ so sigara ana.” ");
INSERT INTO akp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ne Pilato ɔkarɛ wũ sɔ, “Fɔ nɖe ma Yudase igara?” Ne Yesu ɔta wũ mmuai sɔ, “Ise lɛ kumɛgɔ aɣɛ.” ");
INSERT INTO akp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ne Pilato ɔɣere masɔrɛdze makpakpa gu mmamɔ sɔ, “Loinya sɔ ɔɣɛrɛ mmara kumiwɛ̃.” ");
INSERT INTO akp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ɣɛɛ ma kanya ɔwe ɔle teteree sɔ, “Ɔ̃ ara wa ɔto ɔte to abɔ ikpɔkpɔtɔ i ma Yudase ɔɖuɖu ndɛ̃. Ɔsɛ ne karɔ̃ i Galilea, ne ɔ̃ɔbɔ ne i ngbe ana ne.” ");
INSERT INTO akp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ɔwi gɔ i Pilato ɔnɔ itɔ̃me nɛgbe ne, ɔkarɛ sɔ, “Galilea ɔturi ɔɖe ngbe?” ");
INSERT INTO akp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Gɔ ɔtsue sɔ Yesu ɔbɔrɛ i Galilea ibuiti nɛ iso i Herodes to ɔɖe ne, ɔsu wũ ɔsese Herodes ala ɔba ɔpia i Yerusalem ku ɔwi gɔmɔ ame. ");
INSERT INTO akp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","So ɔɣɔ Herodes gbaã gɔ ɔnya Yesu alasɔ ɔ̃ɔnɔ wũ iyere fiɛ ɔto ɔbie sɔ ɔ̃anya wũ kokooko. Ɔbie sɔ ɔ̃anya Yesu ɔbara iwawãra iwɛ̃. ");
INSERT INTO akp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ne ɔso Herodes ɔkarɛ Yesu atɔ̃me gbodzoo ɣɛɛ Yesu iipia wũ kanya. ");
INSERT INTO akp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Masɔrɛdze makpakpa gu mmara matedze ɔbɔrɛ maba maɖaɛ nnya masia Yesu iso. ");
INSERT INTO akp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes gu ɔ̃ makpakpɛ̃dze ɔbara Yesu aɣiãra, matia wũ. Ne masu awu sɛɛ awɛ̃ mapia wũ lɛ igara awe fiɛ makpesera wũ masese Pilato ne. ");
INSERT INTO akp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Iyi nɛmɔ iso ne, Herodes gu Pilato ɔkpese malaa, ɣɛɛ sasaasa ne, maisɛ mafe. ");
INSERT INTO akp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato ɔkpere masɔrɛdze makpakpa gu matɔ̃ɖedze gu maturi tsɔra ɔsakanya. ");
INSERT INTO akp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ne ɔɣere ma sɔ, “Mikɔ ngɔgbe mibɔ me sɔ ɔto ɔkɔ maturi ɔyura i ɔri lalaa iso. I mi mɔmɔ anɔmi ame ne, loɔkarɛ wũ atɔ̃me ɣɛɛ loinya kuira nyanyarĩa nɛ iso miɣɛ mito miɖaɛ wũ kanya. ");
INSERT INTO akp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes ana ɔkpesera wũ ɔsese alasɔ ɔ̃inya kuira lalaa i ɔ̃ iso. Ngɔgbe iibara kuira nɛ loatã sɔ maaɖoe wũ. ");
INSERT INTO akp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ne ɔso loatã mapɛ wũ kere lonyua wũ ɔkɛlɛ.” ");
INSERT INTO akp_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kukpi Ɔtakuwara Bo Iyi iɖe biara ame ne, Pilato sɛ ɔnyua yorɛdze ɔwɛ̃ ɔtã ma. ");
INSERT INTO akp_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ne ma ɔɖuɖu ɔtsɛ kulu teteree sɔ, “Ɖoe wũ! Si anyua Baraba atã bo!” ");
INSERT INTO akp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraba gɔgbe ne, mapia wũ i iyo ala kulu gɔ ɔbara i Yerusalem ɔmagɛ̃ ame gu ituriɖoe. ");
INSERT INTO akp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Gɔ Pilato to ɔbie sɔ ɔ̃anyua Yesu ɔso ne, ɔledza ma ika iɖegu. ");
INSERT INTO akp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ɣɛɛ mala kulu teteree mabua sɔ, “Pɛ wũ matãra i kudziri iso! Pɛ wũ matãra i kudziri iso!” ");
INSERT INTO akp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ne Pilato ɔledza ma ikarɛ ɔkpɛ̃ tɛare sɔ, “Mme ikpi ɔbua ɔbara? Loinya nnɛ ɔbara fiɛ ikote sɔ loatã wũ kukpi ipɔ. Loatã mapɛ wũ iyɔ loɔnyua wũ.” ");
INSERT INTO akp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ɣɛɛ matogu kulu teteree sɔ, “Ikote sɔ aatã mapɛ Yesu mamatãra i kudziri iso.” Kawirikɔ̃ ne, maɖe iso iki i ma kulu ila ame. ");
INSERT INTO akp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ne ɔso Pilato ɔɖaɛ itɔ̃me lɛ kumɛgɔ mato mabie. ");
INSERT INTO akp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ɔnyua ngɔ mato mabie ɔtã ma, ngɔ mapia iyo ala ɔ̃ kulu ibara gu ituriɖoe ɔso. Ɔnyua Yesu ana ɔtã ma sɔ masɛ maabara wũ kumɛgɔ maɖɔɛ. ");
INSERT INTO akp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Makpakpɛ̃dze ɔkɔ Yesu maruigu. Gɔ masɛ i ɔri mato makɛlɛ ne, manya ɔ Kirenese ɔwɛ̃ gɔ marɔ Simon gɔ ɔbɔrɛ i akorowa awɛ̃ ɔto ɔba Yerusalem. Matindza wũ maya wũ iso sɔ ɔfɔ ɔnyigbã gɔ i Yesu sore si ɔsiai wũ i kama. ");
INSERT INTO akp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Maturi gbodzoo siai Yesu i kama. Marɔ̃go mawɛ̃ pia i ma ndɛ̃ gɔ mato mabiɛ masiai wũ. ");
INSERT INTO akp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Mmɔ i Yesu ɔfiniki ɔɣere ma sɔ, “Yerusalem marɔ̃go, midaabiɛ me. Ɣɛɛ mibiɛ mitã so gu mi mabi. ");
INSERT INTO akp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Alasɔ ɔwi to ɔba gɔ maturi aaɣɛ sɔ, ‘Iti lɛ malɛma gu ayiri wa ame i mabi iisɛ gu mma loitã mabi inyɛ mameme!’ ");
INSERT INTO akp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ɔwi gɔmɔ ame i maturi aaɣere abe sɔ, ‘Biɛ fu bo iso!’ Fiɛ maaɣere kubemi sɔ, ‘Kɔla bo!’ ");
INSERT INTO akp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Alasɔ si kudziri yuɛ to kutsue kumɛgɔgbe ne, nda i kukorea aabara?” ");
INSERT INTO akp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Makpakpɛ̃dze ɔmɔɛ̃ marɛrɛ̃ inyɔ ma nɖe maturi lalaa masɛgu sɔ maaɖoe gu Yesu. ");
INSERT INTO akp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Gɔ masɛ maabo ngbegɔ masɛ marɔ sɔ, itikui ne, mapɛ Yesu mamatãra i kudziri iso. Marɛrɛ̃ lalaa mamɔ ana ne, mapɛ ma mamatãra i kudziri iso, ɔwɛ̃ i kuɖearɔ̃ iso ɔnyɔare i kubena iso, ");
INSERT INTO akp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ne Yesu ɔɣɛ sɔ, “Tete, su tsɛ ma alasɔ maiɣe nnɛ mato mabara.” Ne kama ne, makpakpɛ̃dze ɔɣɛ so Yesu arapia gɔ mabara kareremi maro. ");
INSERT INTO akp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Maturi ɣɛ i mmɔ mato manyɔ fiɛ ma Yudase matɔ̃ɖedze ana to mabara Yesu aɣiãra sɔ, “Ɔɖi maturi mama, ne ɔso si ɔ̃ nɖe Kristo gɔ i Ɣaa ɔsia ikparĩ ne, ɔɖi so si bonyɔ!” ");
INSERT INTO akp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Makpakpɛ̃dze ma wũ ngbɔ ame mabara Yesu aɣiãra ne. Masu ndã bea mabɔ wũ sɔ ɔnɛ. ");
INSERT INTO akp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ne maɣere wũ sɔ, “Si fɔ nɖe ma Yudase igara ne, kpɛ̃ ɖi so!” ");
INSERT INTO akp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","I ɔ̃ sitikpe ne, matsɛrɛ mamatãra sɔ, “Ma Yudase Igara i ngbe ne.” ");
INSERT INTO akp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Maturi lalaa ma mapɛ mamatãra i kudziri iso mmɔ ɔwɛ̃ ana ɔtia Yesu ɔɣere sɔ, “Iiɖe fɔ nɖe Kristo? Ɖi so si aɖi bo bo wũ!” ");
INSERT INTO akp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ne ɔ̃ ɔnyɔare to ɔnyagalagu wũ sɔ, “Aisɛ anigã Ɣaa? Kutsue ikpadzɛ̃ iwɛ̃ saã i makpakpɛ̃dze ɔtã bo gu wũ. ");
INSERT INTO akp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Bo kutsue ikpadzɛ̃ ne, ikotegu bo. Alasɔ nnɛ bobara ne, ne kuso boto bofɔ ne. Ɣɛɛ ɔ̃ ne, ɔ̃ibara ikpi kuiwɛ̃.” ");
INSERT INTO akp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ne ɔɣere Yesu sɔ, “Yesu, nyigi me si abo fɔ sigarakaɖekɔ̃.” ");
INSERT INTO akp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ne Yesu ɔɣere wũ sɔ, “Gbaã nto loɣere-ɔ sɔ nɔme ne, bo gu-ɔ aasarɛ i Paradiso ame.” ");
INSERT INTO akp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ɔwi gɔ ipɛ lɛ iɖɔwũ iweo-inyɔ ne, kayi ɔbara guduu gbɔgbɔɔgbɔ isɛ iabo lɛ iɖɔwũ itɛ ame. ");
INSERT INTO akp_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kuɣɛ̃ ɔnyi, Ɣaa isɔrɛyo ɔkati gɔ nsa i mmɔ ɔkɛ aka anyɔ. ");
INSERT INTO akp_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ne Yesu ɔla kulu teteree sɔ, “Tete, fɔ nrɔɔ̃ ame losu wũ siwarã lopia.” Gɔ ɔɣɛ ngbɔ ne, ɔsɔra. ");
INSERT INTO akp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Makpakpɛ̃dze ɔkpakpa gɔ nɣɛ i mmɔ fiɛ ɔnya nnɛ loba ɔle Ɣaa ɔɣɛ sɔ, “Gbaã iɖe sɔ ɔrɛrɛ̃ gɔgbe ne, ɔturi sɛɛ ɔɖe.” ");
INSERT INTO akp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Gɔ maturi gbodzoo ma loba maɣɛ mato manyɔ ara ɔnya nnɛ loba ne, masore nrɔɔ̃ i ati makpese makɛlɛ ayo ku isomararã. ");
INSERT INTO akp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mma ɔɖuɖu nɣe Yesu gu marɔ̃go ma losiai wũ mabɔrɛ i Galilea ɔya dzoroo manyɔ ara wa lokɛlɛ i katɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ɔrɛrɛ̃ ɔwɛ̃ gɔ marɔ sɔ Yosef fiɛ ɔbɔrɛ i ɔmagɛ̃ gɔ marɔ Arimatea i Yudea karɔ̃ iso ɔwe i mmɔ. Ɔturi sɛɛ gɔ masɛ mawarɛ gbaã ɔɖe. Ɔ̃ wũ ɔto ɔnyɔ Ɣaa sigara iɖe iba ɔri. Atoa sɔ ɔpia i ma Yudase matɔ̃meɣɛdze ndɛ̃ ne, ɔ̃inɔgu ma karɔ̃ i nɛ mabara i ngbe iso. ");
INSERT INTO akp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ɔkɛlɛ Pilato kɔrɛ ɔsɛ ɔ̃akarɛ ɔri sɔ ɔtã wũ ɔbɛse Yesu kpise. ");
INSERT INTO akp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Gɔ mabɛse wũ i kudziri iso ne, ɔsu ɔkati fudza ɔmini wũ. Ne ɔsu wũ ɔsɛ ɔ̃apia i itawo nɛ ame maibiara kuwɛ̃ manya ne. ");
INSERT INTO akp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Iyi nɛmɔ ne, Fiɖa iɖe ne ɔso Iwarãyi ka iba iasɛ karɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Marɔ̃go ma losiai Yesu mabɔrɛ i Galilea ne, masiai Yosef masɛ maanya ngbegɔ ɔbiara Yesu gu kumɛgɔ ɔrara ɔ̃ kpise. ");
INSERT INTO akp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Makpese makɛlɛ iyo masɛ maakɔtɛ awa wa nsɛ afɔrɛ̃ kɔrɔ̃kɔrɔ̃ fiɛ masɛ masu maledza ala makpise masɛ. Iwarãyi iso ne, mawarã lɛ kumɛgɔ i mmara ɔte awe. ");
INSERT INTO akp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kɔsiɖa kaya tutuutu ne, marɔ̃go magbe ɔta makɛlɛ maturi kabiarakɔ̃ ku ara wa maaledza wũ ala. ");
INSERT INTO akp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Gɔ masɔ̃ ne, manya sɔ ita nɛ mali matɛ̃ ikpibiɔ kanya ne, maɔli ne masɛ i kuruɛ. ");
INSERT INTO akp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ne ɔso mabo i ikpibiɔ ame, ɣɛɛ mainya Bosate Yesu kpise. ");
INSERT INTO akp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nnɛgbe ɔbara ma ɣii. Ne gɔ maɣɛ mato mabu ne iso ne, maturi inyɔ ma awu nto afiɛ atsue anɔmi ɔbɔrɛ maya ma i katɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ifɔ̃ ɔmɔɛ̃ marɔ̃go gbaã ne ɔso mabɔ ma ati karɔ̃ matã ma. Ne mmamɔ ɔkarɛ ma sɔ, “Be ɔso mito minyɔnyɔ gbanadze i makpise ndɛ̃? ");
INSERT INTO akp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ɔna i ngbe. Ɔ̃ɔta! Minyigi nnɛ ɔɣere mi gɔ ɔpiagu mi i Galilea sɔ, ");
INSERT INTO akp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Mato maaɖi Ɔturi Awune Ɔbi matã maturi lalaa. Mato maapɛ wũ mamatãra i kudziri iso. Fiɛ ayi atɛ kama ne, ɔto ɔ̃aledza ita ibɔrɛ i makpise ndɛ̃.’ ” ");
INSERT INTO akp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ne marɔ̃go ɔnyigi atɔ̃me wamɔ ne. ");
INSERT INTO akp_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Gɔ mabɔrɛ i maturi kabiarakɔ̃ mmɔ ne, masɛ maaɣere katɔ̃memasɛdze iweo-ɔwɛ̃ gu matsɔra ara wagbe. ");
INSERT INTO akp_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Marɔ̃go magbe nɖe Maria Magdalene gu Yohana gu Maria gɔ nɖe Yakobo ɔnyi. Ma gu marɔ̃go mama ɔsɛ maaɣere katɔ̃memasɛdze ara wagbe. ");
INSERT INTO akp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ɣɛɛ katɔ̃memasɛdze ɔbu sɔ ara wa i marɔ̃go to maɣɛ ne, adzimira aɖe. Ne ɔso maifɔ maɖe. ");
INSERT INTO akp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ɣɛɛ Petro ɔta ɔtere ɔkɛlɛ mmɔ. Gɔ ɔbɔdzo ɔnyɔ ikpibiɔ ame ne, ɔnya ɔkati gɔ mamini kpise. Ɔ̃isinya kuira, ne ɔso ɔkpese ɔkɛlɛ iyo ɔto ɔbu nnɛ loba ngbe iti ame. ");
INSERT INTO akp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Iyi nɛmɔ ame iso ne, Yesu masiaidze inyɔ mawɛ̃ sɛ i ɔri mato makɛlɛ ɔmagɛ̃ kosoi ɔwɛ̃ gɔ marɔ Emaus. Ita i mmɔ iba Yerusalem aaɖe lɛ agu akɔdzɛ ɔɖui. ");
INSERT INTO akp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Masɛ mato maɖe ika i ara wa loba iso. ");
INSERT INTO akp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Gɔ masɛ mato maɖe ika maɣɛ ara wagbe ne, Yesu mɔmɔ ɔba ɔ̃atu ma ɔsiai ma. ");
INSERT INTO akp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Gɔ manya wũ ne, maiɣe sɔ ɔ̃ ɔɖe. ");
INSERT INTO akp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Mmɔ i Yesu ɔkarɛ ma sɔ, “Be misɛ miɣɛ i ɔri iso?” Matui maya mabara so nnya nnya. ");
INSERT INTO akp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ne ma ndɛ̃ ɔwɛ̃ gɔ marɔ Kleopa ɔkarɛ Yesu sɔ, “Fɔ ɔnɔwɛ̃ fɔ nɖe ɔfɔ i Yerusalem fiɛ aiɣe ara wa loba i ɔwi kurukutu gɔgbe ame?” ");
INSERT INTO akp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ne Yesu ɔkarɛ ma sɔ, “Be ara?” Ne mapia kanya sɔ, “Ara wa lobɔrɛ i Yesu Nasaretse iso gɔ nɖe Ɣaa kanyaɖidze iso. Ɔbara awawãra fiɛ ɔte ara ana ku ɔle i Ɣaa gu maturi ɔɖuɖu anɔ. ");
INSERT INTO akp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ma Yudase Ɣaa masɔrɛdze makpakpa gu bo matɔ̃ɖedze ɔsu wũ mapia i Roma abã makpakpa nrɔɔ̃ ame sɔ matã wũ kukpi ipɔ fiɛ mapɛ wũ mamatãra i kudziri iso. ");
INSERT INTO akp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ɣɛɛ bonyɔ ɔri sɔ ɔ̃ nɖe ngɔ loaɖi Israel kaɖe ɔɖuɖu fiɛ. Ne kama ne, nɔme nɖe ikpɛnɛ tɛare gɔ ara wagbe ɔba. ");
INSERT INTO akp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Bo ikuri ame marɔ̃go mawɛ̃ ɔba maatara bo situ maɣedza gɔ masɛ maturi kabiarakɔ̃ maba ku kaya gagbe. ");
INSERT INTO akp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Mainya ɔ̃ kpise, ne makpese maba maaɣere bo sɔ Ɣaa makpabo mawɛ̃ ɔɖi so mate ma. Maɣere ma sɔ Yesu pia ngbã. ");
INSERT INTO akp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bo ndɛ̃ mawɛ̃ ɔsɛ maturi kabiarakɔ̃ masɛ maanya lɛ kumɛgɔ i marɔ̃go ɔɣere bo pɛpɛɛpɛ, ɣɛɛ mainya wũ.” ");
INSERT INTO akp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ne mmɔ i Yesu to ɔɣere ma sɔ, “Miikpa anɔ ɖuɖuuɖu. Mi kafɔkaɖe i Ɣaa kanyamaɖidze ara wa maɣɛ iso se tɛgɛlɛ. ");
INSERT INTO akp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Miiɣe sɔ ikote sɔ Kristo aaki i inyɛwe nɛgbe igbã ame fiɛ ɔ̃akɛlɛ ɔ̃ sigarakaɖekɔ̃ i ikpawaĩ ame?” ");
INSERT INTO akp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ne Yesu ɔɖiɖi ara wa matsɛrɛ i ɔ̃ iso mapia i Ɔko Sekelea ame ita i Mose gu ara wa i Ɣaa kanyamaɖidze ɔɖuɖu ɔtsɛrɛ masɛ karɔ̃ ɔte ma ne. ");
INSERT INTO akp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Gɔ mabore mabo ɔmagɛ̃ kosoi gɔmɔ ne, Yesu ɔbara lɛ ɔfe ɔto ɔfe awe. ");
INSERT INTO akp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ɣɛɛ matɛ̃ wũ ɔri maɣere wũ sɔ, “Kaɖe ɔɔro ɔso ne, tui we i bo kɔrɛ ngbe.” Ne ɔso ɔsɛ ɔ̃abo i ma kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ɔsɛ ɔ̃asɛ i karɔ̃ sɔ si ɔɖegu ma ara. Gɔ ɔsu boɖoboɖo ne, ɔpɛ Ɣaa siba, ne ɔbɛbɛse ɔsu ɔtã ma ne. ");
INSERT INTO akp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ɔluwɛ̃ ma anɔ ɔbusi manya wũ maɖi ite, ɣɛɛ ɔyu ma iso. ");
INSERT INTO akp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ne maɣere so sɔ, “Ɔwi gɔ ɔto ɔɖegu bo ika fiɛ ɔɖiɖi Ɣaa itɔ̃me karɔ̃ ɔte bo i ɔri iso ne, isoɣɔ siare ɔwe i bo situ ame.” ");
INSERT INTO akp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mata ɔluwɛ̃ makpese maɣo Yerusalem ɔri. Masɛ maanya katɔ̃memasɛdze iweo-ɔwɛ̃ gɔ masi fiɛ maturi mama ana si i ma kɔrɛ ");
INSERT INTO akp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","mato maɣɛ sɔ, “Bokɔse ɔta gbaã ɔbɔrɛ i makpise ame fiɛ ɔɖi so ɔte Simon.” ");
INSERT INTO akp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ne maturi inyɔ mamɔ ana ɔɣɛ ara wa manya i ɔri gu kumɛgɔ ɔɖi so ɔte ma gɔ ɔkpɛti boɖoboɖo ɔtã ma ne. ");
INSERT INTO akp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Gɔ maɣɛ mato maɣɛ nnɛgbe ne, ɔluwɛ̃ Yesu ɔba ɔ̃aya i ma ndɛ̃. Ne ɔɣere ma sɔ, “Isobuɛ itã mi.” ");
INSERT INTO akp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ifɔ̃ ɔmɔɛ̃ ma gbaã ne maɣɛ sɔ kpise ɔɖe manya. ");
INSERT INTO akp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ɣɛɛ ɔkarɛ ma sɔ, “Be ɔso fiɛ mikpɔkpɔtɔ mito miwararã so? ");
INSERT INTO akp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Minyɔ wũ nrɔɔ̃ gu ngba si mipɛgu me minyɔ sɔ mme loɖe. Alasɔ kpise na sosina gu akui lɛ mito minya sɔ loba.” ");
INSERT INTO akp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Gɔ ɔɣere ma ngbɔ ne, ɔsu ɔ̃ nrɔɔ̃ gu ngba ɔte ma. ");
INSERT INTO akp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Isoɣɔ siare ɔso ne, iɖa ma ifɔ iɖe, ibara ma ɣii. Ne Yesu ɔkarɛ ma sɔ, “Araɖea awɛ̃ se i ngbe?” ");
INSERT INTO akp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ne masu ikpɛ fɛ̃a matã wũ ne. ");
INSERT INTO akp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ɔfɔ ɔwe i ma katɔ̃. ");
INSERT INTO akp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Mmɔ ɔto ɔɣere ma sɔ, “Ara wagbe iso lola loɔɖe mi ika gɔ lopia i mi kɔrɛ ne. Ira biara nɛ matsɛrɛ i Mose mmara ɔko ame gu Ɣaa kanyamaɖidze siko ame gu David Sinɔ ɔko ame i wũ iso ne, ikote sɔ iaba ngbɔ.” ");
INSERT INTO akp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ne ka ɔbusi ma adzuni ame sɔ maanɔ Ɔko Sekelea ame atɔ̃me karɔ̃ ne. ");
INSERT INTO akp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ɔɣere ma sɔ, “Ngbɔ matsɛrɛ sɔ Kristo aawe inyɛ ɔta ɔbɔrɛ i makpise ame ku ikpɛnɛ tɛare iso ne. ");
INSERT INTO akp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","I ɔ̃ iyere ame ne, maaɣɛ ifiniki gu kasukatsɛ itɔ̃me i kayi ɔɖuɖu iso ita i Yerusalem. ");
INSERT INTO akp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mi loaɖi atɔ̃me wa ɔɖuɖu minɔ gu nwa minya kanya. ");
INSERT INTO akp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mme mɔmɔ to loasese mi nnɛ i Ɣaa ɔɣɛ ɔsɛ sɔ ɔ̃asese mi. Ɣɛɛ miya misia Ɣaa ɔle i Yerusalem gbɔgbɔɔgbɔ ɔwi gɔ ame ɔ̃aba mi iso ɔbɔrɛ i kato.” ");
INSERT INTO akp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ne ka ɔkɔ ma ɔbɔrɛgu i Yerusalem masɛ maabo Betania kɔrɛ. Ɔkɔlɛ ɔ̃ nrɔɔ̃ ɔfere ma kusɛkusɛ iso. ");
INSERT INTO akp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ne gɔ ɔto ɔtã ma kusɛkusɛ ne, Ɣaa ɔsu wũ ɔkɛlɛgu kato. ");
INSERT INTO akp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Mapɛ agɛgɛ̃ masɔrɛ wũ, ne makpese makɛlɛ Yerusalem ku isoɣɔ siare ne. ");
INSERT INTO akp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Mala maɔsɛ maɔle Ɣaa i kasɔrɛkɔ̃ ɔwi biara. ");
INSERT INTO akp_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ta kayi karɔ̃kasɛkɔ̃ ne, Itɔ̃me pia. Itɔ̃me gu Ɣaa mpia, fiɛ Ne nɖe Ɣaa. ");
INSERT INTO akp_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Itɔ̃me gu Ɣaa pia fiɛ ira biara ɔsɛ karɔ̃. ");
INSERT INTO akp_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ɔ̃ iso i Ɣaa ɔki ɔbara ira biara, fiɛ kuira na nɛ iiɖe ɔ̃ iso iki fiɛ mabara ne. ");
INSERT INTO akp_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Itɔ̃me nɛgbe ame i ngbã mɔmɔ pia ne. Fiɛ ngbã mɛgbe nsɛ mitã maturi ikpawaĩ ne. ");
INSERT INTO akp_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ikpawaĩ nɛgbe sɛ ifiɛ ibo i idududu ame, fiɛ idududu iisɛ iwo ikpawaĩ ɔɖe iso. ");
INSERT INTO akp_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ɣaa ɔpia ɔ̃ ɔɖabo ɔwɛ̃ gɔ marɔ Yohanes. ");
INSERT INTO akp_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ɔba ɔ̃aɖe maturi ika i ikpawaĩ iso, sɔ ma ɔɖuɖu aaki i ɔ̃ iso mafɔ maɖe. ");
INSERT INTO akp_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Iiɖe Yohanes nɖe ikpawaĩ, ɣɛɛ ne, aɖansiɛ kere ɔba ɔ̃aɖe i ikpawaĩ iso. ");
INSERT INTO akp_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ikpawaĩ mɔmɔ nɛ nsɛ ifiɛ itã ɔbiara to iba kayiiso. ");
INSERT INTO akp_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Itɔ̃me nɛgbe ka ipia i kayi ame, fiɛ ɔ̃ iso maki fiɛ mabara kayi, ɣɛɛ kayiiso iiɣe wũ. ");
INSERT INTO akp_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ɔba ɔ̃ mɔmɔ aɖe maturi kɔrɛ, ɣɛɛ ɔ̃ aɖe maturi iifɔ wũ. ");
INSERT INTO akp_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ɣɛɛ mma ɔɖuɖu lofɔ wũ fiɛ mafɔ wũ maɖe ne, ɔtã ma ɔle sɔ maakpese Ɣaa mabi. ");
INSERT INTO akp_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Maikpese Ɣaa mabi iki i iɣe ame, ana ne iiɖe ɔrã gu ɔre kere ikpɛ̃ ɔkã fiɛ maɣe ma, ɣɛɛ Ɣaa mɔmɔ lobara ma ɔ̃ mabi. ");
INSERT INTO akp_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Itɔ̃me nɛgbe ɔkpese ɔturi awune gɔ loyi ku abualɛra gu ɔnukuare, ɔba ɔ̃awe i bo ndɛ̃. Bonya ɔ̃ ikpawaĩ nɛ ɔfɔ i Ɣaa kɔrɛ lɛ ɔ̃ Ɔbi ɔwɛ̃ saã. ");
INSERT INTO akp_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohanes ɔɖe ika i ɔ̃ iso. Ɔla kulu ɔɣɛ sɔ, “Ngɔgbe nɖe ɔturi gɔ itɔ̃me lola loɔɣere mi sɔ ɔto ɔ̃aba i wũ kama ne ɔɖo me fafaafã ne. Ka ɔpia kokooko fiɛ maɣe me.” ");
INSERT INTO akp_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kumɛgɔ ɔyi ku abualɛra i ɔ̃ ame ɔso ne, ɔ̃ɔfedza kusɛkusɛ ɔfere i bo ɔbiara iso gɔ kufere bo iso ɔwi biara. ");
INSERT INTO akp_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ɣaa ɔtã bo mmara ɔkigu i Mose iso, ɣɛɛ ɔtã bo abualɛra gu ɔnukuare iki i Yesu Kristo iso. ");
INSERT INTO akp_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kuwɛ̃ iinya Ɣaa ɔnya. Ɣaa Ɔbi ɔwɛ̃ saã gɔ lokategu Ɣaa fiɛ ɔpia i ɔ̃ Ɔse kɔrɛ ne, ɔ̃ loɖi wũ ɔte maturi ne. ");
INSERT INTO akp_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ma Yudase makpakpa ma i Yerusalem ɔpia masɔrɛdze gu ma Levise sɔ masɛ maakarɛ Yohanes sɔ, “Nna kowũ abua aɖe?” ");
INSERT INTO akp_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohanes iikɔla ma kuira, ɣɛɛ ɔɣere ma ɔɖi sekelee sɔ, “Iiɖe mme nɖe Kristo gɔmɔ.” ");
INSERT INTO akp_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ne makarɛ wũ sɔ, “Iyɔ fɔ nɖe nna? Fɔ nɖe Kanyaɖidze Eliya?” Ɔtã ma mmuai sɔ, “Iiɖe mme nɖe wũ.” Maledza wũ ikarɛ sɔ, “Fɔ nɖe Kanyaɖidze gɔ maɣɛ masɛ sɔ ɔ̃aba?” Ɔtã ma mmuai sɔ, “Ooɣo.” ");
INSERT INTO akp_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ne maɣere wũ sɔ, “Ɣere bo ngɔ kowũ abua aɖe alasɔ ikote sɔ boasɛ boatã mma lopia bo katɔ̃me mmuai. Fɔ nɖe nna?” ");
INSERT INTO akp_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohanes ɔtã ma mmuai lɛ kumɛgɔ i Kanyaɖidze Yesaya ɔɣɛ sɔ, “Mme nɖe ngɔ nto ɔla kulu i fafuĩ ame ɔɣɛ sɔ, miledza Bosate ɔri misɛ itã ɔ̃ iba.” ");
INSERT INTO akp_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ne mma i ma Farisise ɔpia katɔ̃me, ");
INSERT INTO akp_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","makarɛ Yohanes sɔ, “Si iiɖe fɔ nɖe Kristo, ɣee Eliya, ɣee Ɣaa Kanyaɖidze gɔ boto bonyɔ ɔri ne, be ɔso fiɛ ato apie maturi Ɣaa ndu?” ");
INSERT INTO akp_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohanes ɔɣere ma sɔ, “Mme ne, losu ndu nto lobara mi ala kubarara gɔgbe, ɣɛɛ ɔwɛ̃ ɣɛ i mi ndɛ̃ gɔ miiɣe. ");
INSERT INTO akp_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ɔ̃ nɖe ngɔ loaba i wũ kama ne, ɣɛɛ mme ne, loikote sɔ loabɔdzo loɖi ɔ̃ ndokota.” ");
INSERT INTO akp_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nwagbe ɔɖuɖu ɔkɛlɛ i katɔ̃ i Betania ɔmagɛ̃ i Yordan ɔwore ɔkpokpo gɔmɔ ngbegɔ i Yohanes to ɔpie maturi Ɣaa ndu. ");
INSERT INTO akp_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Gɔ kaɖe ɔsɛ̃ fiɛ Yohanes ɔnya Yesu sɛ ɔto ɔba ɔ̃ kɔrɛ ne, ɔɣɛ sɔ, “Minyɔ, Ɣaa Sɛrɛrerɔ̃ Ibi nɛ loafore kayiiso maturi akpi ɔɖi ma iso ne! ");
INSERT INTO akp_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ɔ̃ nɖe ngɔ iso loɣere mi sɔ, ‘Ɔwɛ̃ to ɔba i wũ kama gɔ loɖo me, alasɔ ka ɔpia kokooko fiɛ maɣe me.’ ");
INSERT INTO akp_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mme wũ loiɣe wũ loɖegu katɔ̃, ɣɛɛ loba nto lopie maturi Ɣaa ndu si Ɣaa aaɖi wũ ɔte Israel kaɖe.” ");
INSERT INTO akp_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohanes ɔɣɛ i ɔ̃ iso ana sɔ, “Lonya Ɣaa Siwarã ɔso lɛ ilɔpɔ sibɔrɛ i Kato siba siasɛ wũ iso. ");
INSERT INTO akp_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Loiɣe wũ loɖegu katɔ̃, ɣɛɛ Ɣaa gɔ lopia me sɔ lopie maturi ndu ɔɣere me sɔ, ‘Ngɔ iso aanya wũ Siwarã ɔso siba siasia ne, ɔ̃ nɖe ngɔ loapie maturi Siwarã Bielea ne.’ ");
INSERT INTO akp_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Lonya iba ngbɔ, ne ɔso loto loɣere mi sɔ ɔ̃ nɖe Ɣaa Ɔbi ne.” ");
INSERT INTO akp_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kaɖesɛ̃a gɔ Yohanes gu ɔ̃ marasuãdze inyɔ ɣɛ ");
INSERT INTO akp_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","fiɛ ɔnya Yesu to ɔfe ne, ɔɣɛ sɔ, “Minyɔ, Ɣaa Sɛrɛrerɔ̃ Ibi mmɔ!” ");
INSERT INTO akp_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Marasuãdze inyɔ magbe ɔnɔ nnɛ i Yohanes ɔɣɛ, ne ɔso marui masiai Yesu. ");
INSERT INTO akp_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Gɔ Yesu ɔpɛ ɔfiniki fiɛ ɔnya sɔ masiai wũ ne, ɔkarɛ ma sɔ, “Be mito mibie?” Matã wũ mmuai sɔ, “Rabi,” gɔ karɔ̃ nɖe, Ratedze, “Botã-ɔ iti i lɛ isɛ asi?” ");
INSERT INTO akp_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ɔɣere ma sɔ, “Miba mianyɔ.” Ɔwi gɔmɔ ame ne, ka ito isɛ kutsuɛ iɖɔwũ ina ame, ne ɔso masiai wũ masɛ maawe i ɔ̃ kɔrɛ kutsuɛ gɔmɔ ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Marasuãdze inyɔ ma lonɔ nnɛ i Yohanes ɔɣɛ fiɛ masiai Yesu mmɔ ɔwɛ̃ nɖe Andrea, Simon Petro ɔnyiibi. ");
INSERT INTO akp_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ira ɖeakatɔ̃ nɛ ɔbara nɖe sɔ ɔnyɔnyɔ ɔ̃ ɔnyiibi Simon. Gɔ ɔnya wũ ne, ɔɣere wũ sɔ, “Boɔnya Mesia,” gɔ karɔ̃ nɖe Kristo ngɔ masɔla nnɔĩ. ");
INSERT INTO akp_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andrea ɔkɔ Simon ɔkɛlɛgu Yesu kɔrɛ. Gɔ Yesu ɔnya wũ ne, ɔnyɔ wũ totoroo ɔɣere wũ sɔ, “Fɔ nɖe Yohanes ɔbi Simon ne, ɣɛɛ ita i kiniɔ ne, maarɔ-ɔ sɔ Kefas,” ɣee Petro, gɔ karɔ̃ nɖe ita siare. ");
INSERT INTO akp_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kaɖesɛ̃a ne, Yesu ɔbara adzuni sɔ ɔ̃akɛlɛ Galilea karɔ̃ iso. Gɔ ɔsɛ i ɔri ne, ɔnya ɔwɛ̃ gɔ marɔ Filipo, ne ɔɣere wũ sɔ, “Siai me.” ");
INSERT INTO akp_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo ana ne, Betsaida gɔ nɖe Andrea gu Petro mɛrɛ̃ ɔmagɛ̃ ame iɖe ɔbɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ne kama ne, Filipo ɔsɛ ɔ̃ɔnya Nataniel, ɔɣere wũ sɔ, “Boɔnya ngɔ iso i Mose gu Ɣaa kanyamaɖidze ɔtsɛrɛ ara masegu i Ɔko Sekelea ame. Ɔ̃ nɖe Yosef ɔbi Yesu gɔ lobɔrɛ i Nasaret ne.” ");
INSERT INTO akp_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniel ɔkarɛ wũ sɔ, “Akuã! Ira sɛɛ iwɛ̃ aawo ɔbɔrɛ i Nasaret?” Filipo ɔɣere wũ sɔ, “Fɔ ba nyɔ kere!” ");
INSERT INTO akp_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Gɔ Yesu ɔnya Nataniel sɛ ɔto ɔba ɔ̃ kɔrɛ ne, ɔɣɛ sɔ, “Israelse mɔmɔ gɔ iso i sila kusiwɛ̃ na i ngbe ne!” ");
INSERT INTO akp_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniel ɔkarɛ wũ sɔ, “Nda abara fiɛ atsue ɔturi gɔ igbã loɖe?” Yesu ɔɣere wũ sɔ, “Lonya-ɔ i kubo kayirinɔ fiɛ Filipo aakpere-ɔ.” ");
INSERT INTO akp_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniel ɔɣere wũ sɔ, “Rabi, Ɣaa Ɔbi aɖe. Fɔ nɖe Israel Igara ne.” ");
INSERT INTO akp_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu ɔɣere wũ sɔ, “Be! Ɔɔfɔ aɖe alasɔ loɣere-ɔ sɔ lonya-ɔ i kubo kayirinɔ? Ato aanya ara wa lomɔ aɖo nwagbe!” ");
INSERT INTO akp_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ne ɔɣere ma sɔ, “Gbagbaã ne, mito mianya kato ɔbusi minya Ɣaa makpabo to maya maso i mme, Ɔturi Awune Ɔbi, iso.” ");
INSERT INTO akp_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ikpɛnɛ tɛare i nnɛmɔ kama ne, makɔ ɔrɔ̃go i ɔmagɛ̃ gɔ marɔ Kana i Galilea. Yesu ɔnyi ana ɔwe i mmɔ. ");
INSERT INTO akp_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Makpere Yesu gu ɔ̃ marasuãdze ana makɛlɛgu ɔrɔ̃go kakɔkɔ̃. ");
INSERT INTO akp_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Gɔ ndã mɛ karabara mato mabara ɔro ne, Yesu ɔnyi ɔbore ɔbo wũ ɔɣere wũ sɔ, “Ma ndã ɔɔro ma iso.” ");
INSERT INTO akp_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ne Yesu ɔɣere ɔ̃ ɔnyi sɔ, “Mmã, iiɖe fɔ itɔ̃me iɖe mmɔ. Wũ ɔwi iiɣo.” ");
INSERT INTO akp_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ne Yesu ɔnyi ɔɣere maɖabo ma i iyo mmɔ sɔ, “Ibiara nɛ ɔɣere mi sɔ mibara ne, mibara.” ");
INSERT INTO akp_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Gɔ iɖe ma Yudase kurabara sɔ maafofore so ɔso ne, maɣedza ndu ita abuiku akuɔ i inyamɔ i mmɔ. Ibuiku biara sɛ ifɔ kusorebui kuna ɣee kuru. ");
INSERT INTO akp_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu ɔɣere maɖabo sɔ maɖu ndu mafere i abuiku wamɔ ame si miyi, ne mabara ngbɔ ne. ");
INSERT INTO akp_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ne ka ɔɣere ma sɔ, “Mika ndu mikɛlɛgu ɔkpakpa gɔ nto ɔnyɔ araɖea iso.” Ne maka makɛlɛgu wũ ne. ");
INSERT INTO akp_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Gɔ ɔtu ndu mɛ loɔkpese ndã ɔnyɔ, fiɛ ɔ̃iɣe ngbegɔ mise, ɣɛɛ maɖabo ma maɣe ne, ɔtã makpere ɔrɔ̃go kɔdze matã wũ. ");
INSERT INTO akp_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ne ɔɣere wũ sɔ, “Ɔbiara ne, ndã sɛɛ miɖe ɔsɛ ɔɖe katɔ̃ ɔɖi ɔtã maturi manɛ, si ka mato marɛ̃ ne, ne ɔsɛ ɔɖi mibea ɔbɔ ne. Ɣɛɛ fɔ ne, kini ato aɖi ndã sɛɛ abɔ ne!” ");
INSERT INTO akp_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu ɔbara iwawãra ɖeakatɔ̃ nɛgbe i Kana i Galilea karɔ̃ iso. Mmɔ ɔɖi ɔ̃ ɔle ɔte fiɛ ɔ̃ marasuãdze ɔfɔ wũ maɖe ne. ");
INSERT INTO akp_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ne kama ne, Yesu gu ɔ̃ ɔnyi gu ɔ̃ manyiibi gu ɔ̃ marasuãdze ɔkɛlɛ Kapernaum masɛ maawe i mmɔ ayi kɛkɛĩ. ");
INSERT INTO akp_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Gɔ ma Yudase Kukpi Ɔtakuwara Bo Iyi ɔɔro ɔɣo ne, Yesu ɔkɛlɛ Yerusalem. ");
INSERT INTO akp_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","I Ɣaa Isɔrɛyo ame ne, ɔnya maturi to marɔdɛ̃ manantsuĩ, masɛrɛ gu ayo ame alɔpɔ gu mma nto manyuarã sikã si i karɔ̃ mmɔ. ");
INSERT INTO akp_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ne ɔso Yesu ɔfɛ̃ iporoibi ala awɛĩ ɔsu ɔsa manantsuĩ gu masɛrɛ ɔɖuɖu ɔɖi i Isɔrɛyo ame, ɔturi sikã manyuarãdze sipɔrɔ̃ gu ma sikã ɔfere i karɔ̃. ");
INSERT INTO akp_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ne ɔɣere mma nto marɔdɛ̃ ayo ame alɔpɔ sɔ, “Mimala mi ara miɖi i ngbe si minyua Tete iyo ɔsu ɔbara kuɣa ame.” ");
INSERT INTO akp_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ne ɔ̃ marasuãdze ɔnyigi itɔ̃me nɛ matsɛrɛ masɛ sɔ, “Wũ kuɖɔɛ gɔ loba lotã fɔ iyo ɔtã wũ anɔmi ɔrɛtɛ.” ");
INSERT INTO akp_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ne ma Yudase makpakpa ɔba Yesu kɔrɛ makarɛ wũ sɔ, “Mme iwawãra aawo ɔbara asu asia ita sɔ aba ɔle aabara nnɛ abara i ngbe?” ");
INSERT INTO akp_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu ɔtã ma mmuai sɔ, “Mibiɛ Isɔrɛyo nɛgbe, ɣɛɛ akpɛnɛ atɛ kama ne, loaledza ne itsue!” ");
INSERT INTO akp_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ne ma Yudase ɔkarɛ wũ sɔ, “Be ato aɣɛ? Aawo akpɛnɛ atɛ ɔsu ɔledza iyo nɛ masu akɔ sina akuɔ matsue ɔtsue?” ");
INSERT INTO akp_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ɣɛɛ mainɔ karɔ̃ sɔ ɔ̃ sosina ɔsu ɔto ɔkateragu Isɔrɛyo. ");
INSERT INTO akp_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ne ɔso ɔwi gɔ i Ɣaa ɔɔtara wũ ɔbɔrɛgu i makpise ame ne, ɔ̃ marasuãdze ɔnyigi sɔ ɔɣɛ itɔ̃me nɛgbe. Itã mafɔ Ɣaa Itɔ̃me nɛ matsɛrɛ masɛ maɖe gu ara wa i Yesu ɔɣere ma. ");
INSERT INTO akp_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Gɔ Yesu ɔwe i Yerusalem ku Kukpi Ɔtakuwara Bo Iyi iɖe ɔwi gɔmɔ ame ne, maturi gbodzoo ɔfɔ wũ maɖe ala awawãra wa manya ɔbara ɔso. ");
INSERT INTO akp_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ɣɛɛ Yesu iibaragu ma mawɛ̃, alasɔ ɔɣe maturi ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Iinya sɔ kuwɛ̃ aaɣere wũ kumɛgɔ i maturi awune se alasɔ ɔ̃ mɔmɔ ɣe ma situ ame. ");
INSERT INTO akp_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ma Yudase tɔ̃ɖedze ɔwɛ̃ gɔ marɔ sɔ Nikodemo fiɛ ɔpia i ikuri nɛ masɛ marɔ sɔ ma Farisise ɔwe. ");
INSERT INTO akp_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kasɛ̃ kawɛ̃ ne, ɔba Yesu kɔrɛ ɔba ɔ̃aɣere wũ sɔ, “Rabi, boɣe sɔ Ratedze aɖe abɔrɛ i Ɣaa kɔrɛ ala ara wa ato abara ne, kuwɛ̃ iibawo wã ɔbara si Ɣaa kɔrɔ̃ iisia wũ iso.” ");
INSERT INTO akp_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu ɔɣere wũ sɔ, “Gbagbaã nto loɣere-ɔ sɔ si mailedza ɔturi iɣe ne, ɔ̃ibanya Ɣaa sigara iɖe ɔnya.” ");
INSERT INTO akp_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ne Nikodemo ɔkarɛ wũ sɔ, “Nda maabara maaledza ɔkpakpa iɣe gɔ ɔ̃isibawo ɔ̃ ɔnyi kayiri ame ɔkpese ɔbo?” ");
INSERT INTO akp_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ne Yesu ɔɣere wũ sɔ, “Gbagbaã nto loɣere-ɔ sɔ, si maiɣe ɔturi makigu i ndu gu Ɣaa Siwarã ame ne, ɔ̃ibawo Ɣaa sigarakaɖekɔ̃ ame ɔbo. ");
INSERT INTO akp_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Maɣese nsɛ maɣe ɔturi i siturina ame, ɣɛɛ Ɣaa Siwarã nsɛ siɣe ɔturi i siwarã ame. ");
INSERT INTO akp_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ne ɔso daatã ibara-ɔ ɣaa sɔ nto loɣere-ɔ sɔ ikote sɔ maaledza mi ɔɖuɖu iɣe. ");
INSERT INTO akp_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ɔwiri sɛ ɔkpɛ̃ ɔkɛlɛ ngbegɔ iɖe ɔɖɔɛ, ɣɛɛ ɔ̃ kulu kere iɖe aanɔ, aibatsue ngbegɔ iɖe ɔbɔrɛ, ɣee ngbegɔ iɖe ɔsɛ. Ngbɔ ame nɖe ɔbiara gɔ maɣe makigu i Siwarã ame ne.” ");
INSERT INTO akp_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ne Nikodemo ɔkarɛ wũ sɔ, “Nda i nnɛgbe aabara iaba?” ");
INSERT INTO akp_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu ɔɣere wũ sɔ, “Fɔ lɛ ratedzekpakpa i Israel ne, aiɣe nnɛgbe? ");
INSERT INTO akp_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Gbagbaã nto loɣere-ɔ sɔ, ara wa boɣe boto boɣere mi, fiɛ nwa bonya iso boto boɖe mi ika, ɣɛɛ miito mibie sɔ miafɔ nnɛ boto boɣere mi. ");
INSERT INTO akp_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Si aito afɔ me aɖe si loɣere-ɔ kayiiso ngbe ara ne, nda aabara fiɛ aafɔ me aɖe si loɣere-ɔ ara wa mpia i kato? ");
INSERT INTO akp_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kuwɛ̃ iisɛ kato ɔnya iɖo mme, Ɔturi Awune Ɔbi, gɔ lose i kato ɔba karɔ̃. ");
INSERT INTO akp_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Lɛ kumɛgɔ i Mose ɔsu aɣɛ wa mabara ala ibɔra ɔsa i ɔdziri iso i fafuĩ ame ne, ngbɔ ame iɖe maakɔlɛ mme, Ɔturi Awune Ɔbi, kato ne, ");
INSERT INTO akp_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","sɔ mma ɔɖuɖu lofɔ me maɖe ne, maana ngbã mɛ loisɛ miro. ");
INSERT INTO akp_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Alasɔ Ɣaa ɔbua ɔto ɔɖɔɛ kayiiso maturi sɔ ɔsu ɔ̃ Ɔbi ɔwɛ̃ saã ɔtã sɔ ɔbiara gɔ lofɔ wũ ɔɖe ne, ɔ̃ibawɔ, ɣɛɛ ɔ̃ana ngbã mɛ loisɛ miro. ");
INSERT INTO akp_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Alasɔ Ɣaa iipia ɔ̃ Ɔbi sɔ ɔba ɔ̃atã kayiiso maturi ipɔ, ɣɛɛ sɔ si ɔba ɔ̃aɖe ma Ɖidze. ");
INSERT INTO akp_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Mma lofɔ Ɔbi maɖe ne, Ɣaa iitã ma ipɔ, ɣɛɛ mma loifɔ wũ maɖe ne, maɔɖe ipɔ koko alasɔ maifɔ Ɣaa Ɔbi ɔwɛ̃ saã maɖe. ");
INSERT INTO akp_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nnɛ ɔso i Ɣaa sɛ ɔtã maturi ipɔ nɖe sɔ, ikpawaĩ ɔba kayiiso, ɣɛɛ mato maɖɔɛ idududu maɖo ikpawaĩ alasɔ ma kurabarara ɔnyanyarĩ. ");
INSERT INTO akp_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mma ɔɖuɖu nsɛ mabara ara lalaa ɔtsiri ikpawaĩ, fiɛ maisɛ mabie sɔ maabore mabo ne alasɔ maito mabie sɔ ma ara lalaa si are kayi. ");
INSERT INTO akp_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ɣɛɛ mma nsɛ mabara ara i ɔnukuare ɔri iso, masɛ mabore maba ikpawaĩ kɔrɛ sɔ si iate sɔ mato makã Ɣaa atsue.” ");
INSERT INTO akp_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nnɛgbe kama ne, Yesu gu ɔ̃ marasuãdze ɔkɛlɛ Yudea ibuiti ame. Ɔwegu ma i mmɔ kɛkɛĩ fiɛ ɔpie maturi Ɣaa ndu i ɔwore ame. ");
INSERT INTO akp_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ɔwi gɔmɔ ame ne, Yohanes ɔ̃ wũ ɔto ɔpie maturi Ɣaa ndu i Aenon gɔ lobore ɔbo Salim alasɔ ndu ɔsi i mmɔ. Maturi to maba ɔ̃ kɔrɛ fiɛ ɔto ɔpie ma Ɣaa ndu. ");
INSERT INTO akp_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ɔwi gɔmɔ ame ne, maimɔɛ̃ Yohanes mapia i iyo. ");
INSERT INTO akp_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Iyi iwɛ̃ ne, karawararã ɔbo i Yohanes marasuãdze gu ɔ Yudase ɔwɛ̃ ndɛ̃ i ma Yudase ifoforeso kubarara iso. ");
INSERT INTO akp_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ne ɔso maba maaɣere Yohanes sɔ, “Ratedze, ato anyigi ɔrɛrɛ̃ ɔwɛ̃ gɔ lowegu-ɔ i Yordan kama isɛ fiɛ aɖe ɔ̃ iso aɖansiɛ mmɔ? Kiniɔ ne, ɔ̃ ka nto ɔpie maturi Ɣaa ndu fiɛ ma ɔɖuɖu ɔɔsore so makpa ɔ̃ kɔrɛ ne.” ");
INSERT INTO akp_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohanes ɔtã ma mmuai sɔ, “Ɔturi iibawe kuira si iiɖe Ɣaa lotã wũ. ");
INSERT INTO akp_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mi mɔmɔ ɖe me aɖansiɛ sɔ loɣere mi sɔ, iiɖe me nɖe Kristo gɔmɔ, ne Ɣaa lopia me sɔ loɖe wũ katɔ̃. ");
INSERT INTO akp_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ɔrɛrɛ̃ gɔ nto ɔkɔ ɔrɔ̃go ne, ɔ̃ mba ɔrɔ̃go ne. Ɔ̃ ɔlaa gɔ nɖe ɔ̃ masaa fiɛ ɔɣɛ i ɔ̃ kɔrɛ ɔto ɔkã wũ atsue sɛ ɔna isoɣɔ si ɔto ɔnɔ ɔ̃ silɔ. Ngbɔ ame i isoɣɔ ɔɔyi i wũ ame ne. ");
INSERT INTO akp_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ne ɔso ɔ̃ iyere aakɔlɛ kato, ɣɛɛ wũ ire aaba karɔ̃. ");
INSERT INTO akp_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Ngɔ lose i Ɣaa sigarakaɖekɔ̃ ɔmɔ ɔɖo ɔbiara. Ngɔ lose i karɔ̃ iso ne, karɔ̃ iso ɔre ɔɖe fiɛ karɔ̃ iso ara iso ɔsɛ ɔɖe ika. Ɣɛɛ ngɔ lose i kato ne, ɔɖo ma ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ɔsɛ ɔɣɛ ara wa ɔnya gu nwa ɔnɔ, ɣɛɛ kuwɛ̃ iisɛ ɔfɔ ɔ̃ itɔ̃me. ");
INSERT INTO akp_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ɣɛɛ ngɔ lofɔ ɔ̃ itɔ̃me ɔɖe ɔsia ita sɔ Ɣaa ne, ɔnukuarese ɔɖe. ");
INSERT INTO akp_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ngɔ i Ɣaa ɔpia katɔ̃me ne, ɔsɛ ɔɣɛ Ɣaa itɔ̃me, alasɔ Ɣaa sɛ ɔtã ɔ̃ Siwarã ɔyi i ɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ɣaa sɛ ɔɖɔɛ ɔ̃ Ɔbi, fiɛ ɔsu ira biara ɔpia i ɔ̃ ɔle kayirinɔ. ");
INSERT INTO akp_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","“Ɔbiara gɔ lofɔ Ɔbi ɔɖe ba ngbã mɛ loibaro, ɣɛɛ ɔbiara gɔ losɛ̃ Ɣaa Ɔbi atsue ikã ne, ɔ̃ibana ngbã, ɣɛɛ Ɣaa kutsue ikpadzɛ̃ sia wũ iso.” ");
INSERT INTO akp_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ma Farisise ɔnɔ sɔ Yesu to ɔpie maturi Ɣaa ndu, fiɛ ɔto ɔna marasuãdze ɔɖo Yohanes. ");
INSERT INTO akp_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Atoa sɔ Yesu mɔmɔ iipie kuwɛ̃ Ɣaa ndu, ɣɛɛ ɔ̃ marasuãdze nto mabara. ");
INSERT INTO akp_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ne ɔso Yesu ɔrui i Yudea ɔkpese ɔkɛlɛ Galilea. ");
INSERT INTO akp_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ɣɛɛ ne, ipia sɔ ɔ̃aki i Samaria karɔ̃ iso fiɛ ɔ̃akɛlɛ. ");
INSERT INTO akp_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yesu ɔba ɔ̃abo Samaria ɔmagɛ̃ gɔ marɔ sɔ Sikar kabenya. Ɔmagɛ̃ gɔgbe ɔbore ɔbo iputu nɛ i ma ɔwa Yakob ɔtã ɔ̃ ɔbi Yosef. ");
INSERT INTO akp_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yakob itubiɔ nɛ ɔɖi pia i mmɔ. Gɔ Yesu ɔba ɔ̃abo mmɔ lɛ kakɔme iɖɔwũ iweo-inyɔ ame ne, iɖa wũ ala ɔsɛ ɔso, ne ɔso ɔkpase ɔsɛ i itubiɔ nɛgbe kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samaria ɔrɔ̃go ɔwɛ̃ ɔba sɔ ɔba ɔ̃aɖu ndu, ne ɔso Yesu ɔɣere wũ sɔ, “Tã me ndu lonɛ.” ");
INSERT INTO akp_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ɔwi gɔmɔ ame ne, Yesu marasuãdze ɔrui makpa ɔmagɛ̃ ame maaɣa araɖea. ");
INSERT INTO akp_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ɔrɔ̃go gɔgbe ɔkarɛ Yesu sɔ, “Nda ibara fiɛ fɔ ɔ Yudase to akarɛ me Samaria ɔrɔ̃go ndu nɛa?” Ɔkarɛ wũ ngbɔ alasɔ ma Yudase gu ma Samariase iisɛ mafe. ");
INSERT INTO akp_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu ɔtã wũ mmuai sɔ, “Si ɔɣe aɣe Ɣaa karatã gu ngɔ nto ɔkarɛ-ɔ ndu ne, tee fɔ bowũ fɔ loakarɛ wũ sɔ ɔtã-ɔ ndu mɛ nsɛ mitã ngbã.” ");
INSERT INTO akp_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ɔrɔ̃go ɔkarɛ wũ sɔ, “Tete, gɔ ana nnɛ aaɖu ala ndu, fiɛ itubiɔ ana ɔwodoro ne, lɛ aaka ndu mɛ nsɛ mitã ngbã ngbe abɔrɛgu? ");
INSERT INTO akp_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ɛɛbɛrɛ fɔ loɖo bo Ɔwa Yakob gɔ loɖi itubiɔ nɛgbe ɔtã bo fiɛ ɔ̃ gu ɔ̃ mabi gu ma mabɔi ɔnɛ ndu mɛgbe?” ");
INSERT INTO akp_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ne Yesu ɔɣere wũ sɔ, “Ɔbiara gɔ nsɛ ɔnɛ ndu mɛgbe ne, ɔme to ɔ̃aledza wũ ikore. ");
INSERT INTO akp_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ɣɛɛ ngɔ loanɛ ndu mɛ loatã wũ ne, ɔme iisibakore wũ ɔnya. Alasɔ ndu mɛ loatã wũ ɔnɛ to miakpese ndu gɔdɛ̃a mɛ nto mibore mife ɔwi biara i ɔ̃ ame mitã wũ ngbã mɛ loisɛ miro.” ");
INSERT INTO akp_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ɔrɔ̃go ɔɣere wũ sɔ, “Bosate, tã me ndu mɛgbe lonɛ si ɔme iisibakore me ɔnya sɔ loibakpese loba ngbe sɔ loba loaɖu ndu.” ");
INSERT INTO akp_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ne Yesu ɔɣere wũ sɔ, “Kɛlɛ aakpere fɔ ɔrã si miba.” ");
INSERT INTO akp_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ɔrɔ̃go ɔɣere Yesu sɔ, “Lona kurã.” Ne Yesu ɔɣere wũ sɔ, “Aɣɛ ɔnukuare sɔ ana kurã. ");
INSERT INTO akp_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Gbaã iɖe aɣɛ. Alasɔ ɔɔyiri marɛrɛ̃ iru anya, fiɛ ngɔ iyo asi kiniɔ ana ne, iiɖe fɔ ɔrã ɔɖe.” ");
INSERT INTO akp_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ɔrɔ̃go ɔɣere Yesu sɔ, “Tete, lonya sɔ Ɣaa kanyaɖidze aɖe! ");
INSERT INTO akp_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bo ma Samariase mawa ɔsɔrɛ Ɣaa i kube gɔgbe iso, ɣɛɛ mi ma Yudase sɔ Yerusalem nɖe ngbegɔ boasɔrɛ Ɣaa.” ");
INSERT INTO akp_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ne Yesu ɔɖi kanya sɔ, “Ɔrɔ̃go, fɔ me ɖe sɔ ɔwi to ɔba gɔ maturi iisibasɔrɛ bo Ɔse Ɣaa i kube gɔgbe iso, ɣee Yerusalem. ");
INSERT INTO akp_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mi ma Samariase ne, miiɣe ngɔ mito misɔrɛ. Ɣɛɛ bo ma Yudase ne, boɣe ngɔ boto bosɔrɛ, alasɔ bo kɔrɛ i Ɣaa iɖi ɔbɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ɣɛɛ ɔwi to ɔba fiɛ ɔwi gɔmɔ ɔɔɣo sɔ Ɣaa masɔrɛdze gbaã aasɔrɛ wũ i Ɔ̃ Siwarã gu ɔnukuare ame, alasɔ masɔrɛdze magbe igbã i Ɣaa to ɔbie ne. ");
INSERT INTO akp_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Gɔ Ɣaa ne Siwarã ɔɖe ɔso ne, ɔ̃ Siwarã ɔle gu ɔnukuare ame pɛ i maturi aawo ɔki fiɛ maasɔrɛ wũ lɛ kumɛgɔ ikote.” ");
INSERT INTO akp_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ne ɔrɔ̃go ɔɣere Yesu sɔ, “Loɣe sɔ Mesia gɔ marɔ sɔ Kristo to ɔ̃aba, fiɛ si ɔba ne, ɔto ɔ̃aɖi ira biara ɔɣere bo.” ");
INSERT INTO akp_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ne Yesu ɔɣere wũ sɔ, “Mme gɔ mme nto loɖegu-ɔ ika ne, mme nɖe wũ ne.” ");
INSERT INTO akp_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ɔwi gɔmɔ ame ne, Yesu marasuãdze ɔba maabo fiɛ ibara ma ɣaa sɔ ɔto ɔɖegu ɔrɔ̃go ika, ɣɛɛ ma kuwɛ̃ iiwo ɔrɔ̃go ɔkarɛ sɔ, “Be ato abie?” ɣee makarɛ Bosate sɔ, “Be ɔso ato aɖegu wũ ika?” ");
INSERT INTO akp_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ɔrɔ̃go ɔnyua ɔ̃ ituɖura ɔsɛ ɔrui ɔkɛlɛ ɔmagɛ̃ ame ɔsɛ ɔ̃aɣere maturi sɔ, ");
INSERT INTO akp_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Miba mianyɔ ɔrɛrɛ̃ gɔ loɣere me ira biara nɛ loɔbara lonya i wũ ngbã ame! Bɛrɛ ɔ̃ nɖe Kristo gɔmɔ?” ");
INSERT INTO akp_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ne ɔso maturi ɔbɔrɛ i ɔmagɛ̃ ame makɛlɛ sɔ maanyɔ Yesu. ");
INSERT INTO akp_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ɔwi gɔmɔ ame ne, marasuãdze to mapɛ Yesu nrɔɔ̃ sɔ, “Ratedze, boto-ɔ i kukpa sɔ ba ɖe ara!” ");
INSERT INTO akp_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ɣɛɛ Yesu ɔɣere ma sɔ, “Loba aɖera wa loaɖe ɣɛɛ miiɣe wã.” ");
INSERT INTO akp_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ne ɔso marasuãdze ɔtsɛ so ikarɛ sɔ, “Bɛrɛ ɔwɛ̃ ɔbɔ wũ aɖera fiɛ boiɣe?” ");
INSERT INTO akp_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu ɔɣere ma sɔ, “Wũ aɖera nɖe sɔ loabara ngɔ lopia me katɔ̃me kuɖɔɛ, lobara karabara ga ɔpia me lowiri. ");
INSERT INTO akp_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mi nsɛ miɣɛ sɔ, ‘Awa ana loɔkuti fiɛ ɔraɖui aabo kaa,’ ɣɛɛ mme nto loɣere mi sɔ, si minyɔ nkpɛkɔ̃ iso kukaakɔ ne, mianya sɔ kamɔ ɔɔbe kanya irui! ");
INSERT INTO akp_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ngɔ nto ɔsɔrɛ̃ ɔraɖui fiɛ ɔto ɔsa ɔraɖui kanya ɔtã ngbã mɛ loisɛ miro i Ɣaa sɛ ɔtã kuso. Ne ɔso ngɔ losa ɔraɖui gu ngɔ losɔrɛ̃ ɔraɖui isoɣɔ aaɖe iwɛ̃. ");
INSERT INTO akp_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ne ɔso itɔ̃me nɛgbe pia i ne ame sɔ, ‘Ɔturi ɔwɛ̃ sɛ ɔsa ɔraɖui fiɛ ɔmama ana sɛ ɔsɔrɛ̃ ɔraɖui.’ ");
INSERT INTO akp_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Lopia mi sɔ misɛ miasɔrɛ̃ ɔraɖui i kakpɛkɔ̃ ga iiɖe mi lokpɛ̃ ame, maturi mama lobara karabara i mmɔ, ɣɛɛ mi loana kã kusia.” ");
INSERT INTO akp_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ma Samariase gbodzoo i ɔmagɛ̃ gɔmɔ ame ɔfɔ Yesu maɖe, alasɔ ɔrɔ̃go gɔmɔ ɔɣere ma sɔ, “Ɔɣere me ira biara nɛ loɔbara lonya i wũ ngbã ame.” ");
INSERT INTO akp_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Gɔ mabɔrɛ maba ɔ̃ kɔrɛ ne, mapɛ wũ nrɔɔ̃ sɔ ɔwe i ma kɔrɛ kɛkɛĩ, ne ɔso Yesu ɔwe i ma kɔrɛ ayi anyɔ. ");
INSERT INTO akp_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Maturi gbodzoo mama ana ɔfɔ wũ maɖe gɔ manɔ ɔ̃ itɔ̃me. ");
INSERT INTO akp_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ne maɣere ɔrɔ̃go sɔ, “Kiniɔ ne, bofɔ wũ boɖe, iiɖe nnɛ aɣere bo ɔso, ɣɛɛ bo mɔmɔ ɔɔnɔ ɔ̃ itɔ̃me fiɛ boɣe sɔ ɔ̃ nɖe kayiiso Ɖidze gbaã.” ");
INSERT INTO akp_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ayi anyɔ kama ne, Yesu ɔbɔrɛ i mmɔ ɔkɛlɛ Galilea karɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Atoa sɔ Yesu mɔmɔ ɔɣɛ ku ɔwi gɔ lofe ame sɔ, “Ɣaa kanyaɖidze na kuwarɛ i ɔ̃ mɔmɔ aɖe ne,” ");
INSERT INTO akp_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","gɔ ɔba ɔ̃abo Galilea ne, mafɔ wũ kukaakɔ, alasɔ gɔ masɛ Kukpi Ɔtakuwara Bo Iyi iɖe i Yerusalem ne, manya ira biara nɛ ɔbara i iyi kaɖekɔ̃. ");
INSERT INTO akp_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu ɔkpese ɔkɛlɛ Kana i Galilea ngbegɔ ɔfinikira ndu ɔbara ndã ɔnya. Abã ɔkpakpa ɔwɛ̃ pia i mmɔ gɔ ɔbi birɛrɛĩ nto ɔnyɛ i Kapernaum. ");
INSERT INTO akp_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Gɔ ɔnɔ sɔ Yesu ɔbɔrɛ i Yudea ɔba Galilea ne, ɔba ɔ̃apɛ wũ nrɔɔ̃ ɔɣere wũ sɔ ɔba makɛlɛ Kapernaum si ɔba ɔ̃asa ɔ̃ ɔbi gɔ nto ɔnyɛ fiɛ ɔ̃ɔro ɔkpi. ");
INSERT INTO akp_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu ɔɣere wũ sɔ, “Si miinya awawãra gu akparĩ ne, miisɛ mifɔ miɖe.” ");
INSERT INTO akp_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ɣɛɛ ɔkpakpa gɔmɔ ɔtã Yesu iti sɔ, “Bosate, loto-ɔ i kukpa sɔ ba bokɛlɛ si wũ ɔbi iibakpi.” ");
INSERT INTO akp_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ne Yesu ɔɣere wũ sɔ, “Kɛlɛ ne fɔ ɔbi to ɔ̃awe ngbã.” Ɔkpakpa gɔgbe ɔfɔ nnɛ i Yesu ɔɣere wũ ɔɖe, ne ɔso ɔrui ɔɣo ma aɖe ɔri. ");
INSERT INTO akp_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ɔwi gɔ ɔsɛ ɔto ɔkɛlɛ ne, ɔ̃ maɖabo ɔba maaɣere wũ sɔ, “Fɔ ɔbi ɔɔsarɛ!” ");
INSERT INTO akp_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ɔkarɛ ma sɔ mme ɔwi ame iɖe ɔsarɛ. Ne matã wũ mmuai sɔ, “Lɛ kakɔme ɔɖɔwũ ɔwɛ̃ ame ku kɔmakaɖe i kubetɔ ɔta wũ iso.” ");
INSERT INTO akp_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ne ɔ̃ ɔse ɔnyigi sɔ ɔwi gɔmɔ ame tutuutu iɖe i Yesu ɔɣere wũ sɔ, “Fɔ ɔbi to ɔ̃awe ngbã,” ne. Ne ɔso ɔ̃ gu ɔ̃ iyo maturi ɔɖuɖu ɔfɔ Yesu maɖe. ");
INSERT INTO akp_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nnɛgbe nɖe iwawãra nyɔare nɛ i Yesu ɔbara i Galilea karɔ̃ iso gɔ ɔse i Yudea ɔba. ");
INSERT INTO akp_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nnɛgbe kama ne, gɔ ma Yudase to maɖe ma iyi iwɛ̃ ne, Yesu ɔsɛ Yerusalem. ");
INSERT INTO akp_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","I ɔmagɛ̃ ame ne, kayogodɔ̃ kawɛ̃ pia ga masɛ marɔ sɔ Masɛrɛ Kayogodɔ̃. I kã kɔrɛ ne, ibu iwɛ̃ nɛ i kukpakɛ kuru ɔki kulɔ se fiɛ masɛ marɔ ibu nɛgbe sɔ Betesda i ma Yudase siɖe ame. ");
INSERT INTO akp_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Manyɛse gbodzoo rɛ i kukpakɛ gɔgbe kayirinɔ. Ma mawɛ̃ ɖe manɔbiɛdze, mawɛ̃ ɖe mabafã gu mma lokpi kasɛkasɛ. ");
INSERT INTO akp_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(Marɛ i mmɔ alasɔ ipɔlɛipɔlɛ ne, Ɣaa kpabo sɛ ɔba ɔ̃atidza ndu. Nyɛse gɔ loaɖe katɔ̃ ɔbo me ame si matidza ndu sɛ ɔna isosarɛ ɔluwɛ̃.) ");
INSERT INTO akp_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ɔrɛrɛ̃ ɔwɛ̃ rɛ i mmɔ gɔ ɔto ɔnyɛ akɔ sitɛ farafana. ");
INSERT INTO akp_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Gɔ Yesu ɔnya wũ fiɛ ɔtsue sɔ ɔ̃ɔrɛ i mmɔ ɔwi ɔdzoro ne, ɔkarɛ wũ sɔ, “Ato abie sɔ aasarɛ?” ");
INSERT INTO akp_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ne nyɛse to ɔtã wũ mmuai sɔ, “Tete, lona kuwɛ̃ gɔ loaputa me ɔpia i ndu ame si matidza me, fiɛ si loto lokpɛ̃ sɔ loabo i ibu ame ne, ɔturi mama sɛ ɔɖe me katɔ̃.” ");
INSERT INTO akp_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu ɔɣere wũ sɔ, “Ta si akarĩ fɔ ɔkala si asɛ.” ");
INSERT INTO akp_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ɔluwɛ̃ ne, ɔsarɛ, ɔsu ɔ̃ ɔkala ɔtsɛ isɛ. Iyi nɛ ira nɛgbe ɔba ne, ma Yudase Iwarãyi iɖe. ");
INSERT INTO akp_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ne ɔso gɔ ma Yudase makpakpa ɔnya ɔrɛrɛ̃ gɔgbe gɔ ɔto ɔ̃ ɔkala ne, maɣere wũ sɔ, “Iwarãyi iɖe nɔme, ne ɔso ita iya i bo mmara iso sɔ aala fɔ ɔkala asɛ.” ");
INSERT INTO akp_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ɣɛɛ ɔrɛrɛ̃ gɔgbe ɔɣere ma sɔ, “Ɔrɛrɛ̃ gɔ losa me loɣere me sɔ, ‘Su fɔ ɔkala si asɛ.’ ” ");
INSERT INTO akp_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ne makarɛ wũ sɔ, “Nna ɔɖe loɣere-ɔ sɔ bara ngbɔ?” ");
INSERT INTO akp_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ɣɛɛ ɔrɛrɛ̃ gɔgbe iiɣe ngɔ i Yesu ɖe, fiɛ maturi ana ɔsi i mmɔ, ne ɔso Yesu ɔma ɔbo i ma ndɛ̃ ɔrui i mmɔ. ");
INSERT INTO akp_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ne kama ne, Yesu ɔnya wũ i Isɔrɛyo, ne ɔɣere wũ sɔ, “Nyɔ, kiniɔ gɔ ɔɔsarɛ ne, daasibara ikpi sɔ nnɛ loɖo ngbe aaba iabara-ɔ.” ");
INSERT INTO akp_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ɔrɛrɛ̃ gɔmɔ ɔrui ɔsɛ ɔ̃aɣere ma Yudase makpakpa sɔ Yesu ɔɖe losa wũ. ");
INSERT INTO akp_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ne ɔso matsɛ Yesu kama iti, alasɔ ɔsa ɔturi ku Iwarãyi. ");
INSERT INTO akp_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ɣɛɛ Yesu ɔɣere ma sɔ, “Wũ Ɔse to ɔbara karabara ɔwi biara ame, ne ɔso me wũ loto lobara karabara.” ");
INSERT INTO akp_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nnɛ i Yesu ɔɣɛ ngbe ɔtã ma Yudase makpakpa ɔsia ita sɔ ngbɛsi maɖoe wũ. Manya sɔ iiɖe ma mmara kere miɖe ɔtu, ɣɛɛ ana ne, ɔsu so ɔbara Ɣaa Ɔbi gɔ ite sɔ ɔkategu Ɣaa. ");
INSERT INTO akp_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ne Yesu ɔɣere ma sɔ, “Gbagbaã nto loɣere mi sɔ, Ɣaa Ɔbi iibawo kuira ɔbara i ɔ̃ mɔmɔ ɔle ame iɖo nnɛ ɔnya ɔ̃ Ɔse to ɔbara, fiɛ nnɛ i Ɔse to ɔbara ne, ne i Ɔbi sɛ ɔbara ne. ");
INSERT INTO akp_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Alasɔ Ɔse to ɔɖɔɛ Ɔbi ne ɔso ɔsɛ ɔte wũ ira biara nɛ ɔto ɔbara. Ɔse to ɔ̃ate ara wa lomɔ aɖo ngbe gɔ ito iabara mi ɣii. ");
INSERT INTO akp_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kumɛgɔ ame i Ɔse sɛ ɔtara makpise ɔtã ma ngbã ne, ngbɔ ame i Ɔbi ana sɛ ɔtã mma ɔto ɔɖɔɛ ngbã ne. ");
INSERT INTO akp_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ɔse mɔmɔ iisɛ ɔɣɛgu kuwɛ̃ atɔ̃me, ɣɛɛ ɔsu atɔ̃me iɣɛ ɔle ɔɖuɖu ɔpia i Ɔbi nrɔɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ɔse ɔbara ngbɔ sɔ si maturi ɔɖuɖu aawarɛ Ɔbi lɛ kumɛgɔ masɛ mawarɛ Ɔse. Ɔbiara gɔ loisɛ ɔwarɛ Ɔbi iisɛ ɔwarɛ Ɔse gɔ lopia wũ katɔ̃me. ");
INSERT INTO akp_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Gbaã nto loɣere mi sɔ ngɔ nsɛ ɔnɔ wũ itɔ̃me fiɛ ɔfɔ ngɔ lopia me katɔ̃me ɔɖe ba ngbã mɛ loisɛ miro. Ɣaa iibaɣɛgu wũ atɔ̃me, ɣɛɛ ɔ̃ɔbɔrɛ i kukpi ame ɔbo i ngbã ame. ");
INSERT INTO akp_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Gbaã nto loɣere mi sɔ ɔwi to ɔba fiɛ ɔwi ɔɔɣo gɔ makpise aanɔ Ɣaa Ɔbi silɔ fiɛ mma lonɔ to maata masɛ ngbã. ");
INSERT INTO akp_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kumɛgɔ ame i Ɔse ɖe ngbã Sate ne, ngbɔ ame iɖe ɔbara Ɔbi ana sɔ ɔɖe ngbã Sate ne. ");
INSERT INTO akp_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Fiɛ ɔtã wũ ɔle sɔ ɔɣɛgu maturi atɔ̃me alasɔ ɔ̃ nɖe Ɔturi Awune Ɔbi. ");
INSERT INTO akp_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Nnɛgbe si idaabara mi ɣaa alasɔ ɔwi to ɔba gɔ makpise ɔɖuɖu to maanɔ ɔ̃ silɔ, ");
INSERT INTO akp_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","fiɛ maata mabɔrɛ i ma akpibiɔ ame. Mma lobara ara sɛɛ to maata masɛ ngbã, ɣɛɛ mma lobara ikpi ana to maata matã kutsue ikpadzɛ̃. ");
INSERT INTO akp_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Loibawo kuira ɔbara i wũ ɔle ame, nsɛ loɣɛgu maturi atɔ̃me lɛ kumɛgɔ i Ɣaa ɔɣere me. Ne ɔso wũ atɔ̃me iɣɛ se tɔrɔrɔ, alasɔ loisɛ lobara nnɛ loɖɔɛ, ɣɛɛ nnɛ i ngɔ lopia me katɔ̃me ɔɖɔɛ nsɛ lobara. ");
INSERT INTO akp_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Si loɖe so aɖansiɛ ne, iyɔ wũ aɖansiɛ iibaɖe ɔnukuare. ");
INSERT INTO akp_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ɣɛɛ ɔmama pia gɔ nsɛ ɔɖe me aɖansiɛ fiɛ loɣe sɔ nnɛ ɔsɛ ɔɣɛ i wũ iso ne, gbaã iɖe. ");
INSERT INTO akp_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Mipia mi makpabo Yohanes kɔrɛ i wũ iso, fiɛ ɔɖe aɖansiɛ i ɔnukuare iso. ");
INSERT INTO akp_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Iiɖe sɔ ɔnya ko inya sɔ loana ɔturi awune ɔɖe me aɖansiɛ, ɣɛɛ loto loɣɛ ngbɔ sɔ si miana iɖi. ");
INSERT INTO akp_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohanes se lɛ ɔkaniɛ gɔ losa, fiɛ miɖɔɛ ɔwi kurukutu sɔ miawe i ɔ̃ ikpawaĩ ame ku isoɣɔ. ");
INSERT INTO akp_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ɣɛɛ loba aɖansiɛ wa mba ɔrɔrã aɖo Yohanes ɔkpɛ. Wã nɖe wũ kurabarara gɔ losɛ lobara ne. Karabara ga i Tete ɔtã me sɔ lobara loro ne, kã nsɛ kaɖe me aɖansiɛ sɔ ɔ̃ lopia me katɔ̃me ne. ");
INSERT INTO akp_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Fiɛ Tete gɔ lopia me katɔ̃me ana sɛ ɔɖe me aɖansiɛ. Miinɔ ɔ̃ silɔ minɔ fiɛ miinya wũ ana minya. ");
INSERT INTO akp_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Miisɛ mimɔɛ̃ ɔ̃ itɔ̃me mipia i mi situ ame, alasɔ miifɔ ngɔ ɔpia katɔ̃me miɖe. ");
INSERT INTO akp_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Misɛ mifafarɛ Ɔko Sekelea ame, alasɔ minyɔ sɔ ne ame miana ngbã mɛ loisɛ miro, ɣɛɛ wũ iso matsɛrɛ ara wagbe ɔɖuɖu masegu. ");
INSERT INTO akp_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ɣɛɛ miito mibie sɔ miaba wũ kɔrɛ fiɛ miana ngbã mɛmɔ. ");
INSERT INTO akp_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Loito lobie ɔturi awune ile, ");
INSERT INTO akp_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","alasɔ loɣe maturi ma igbã miɖe fiɛ loɣe sɔ miisɛ miɖɔɛ Ɣaa i mi situ ame. ");
INSERT INTO akp_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Loba i wũ Ɔse ɔle ame, ɣɛɛ miifɔ me, si ɔrere ɔba i ɔ̃ mɔmɔ ɔle ame ne, mito miafɔ wũ. ");
INSERT INTO akp_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Misɛ miɖɔɛ sɔ mi malaa si male mi, ɣɛɛ miisɛ mibie sɔ ngɔ ɔnɔwɛ̃ nɖe Ɣaa si ɔle mi. Ne ɔso nda miabara fiɛ miafɔ me miɖe? ");
INSERT INTO akp_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Midaanyɔ ɔri sɔ me loatã mi ipɔ i Tete kɔrɛ. Mose gɔ ame i mi ɔɖuɖu ɔriinyɔ pia ne, ɔ̃ mɔmɔ loatã mi ipɔ ne. ");
INSERT INTO akp_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Si gbaã iɖe sɔ mifɔ Mose miɖe ne, tee miafɔ me miɖe, alasɔ wũ iso ɔtsɛrɛ ara ɔsegu. ");
INSERT INTO akp_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ɣɛɛ gɔ miifɔ nnɛ ɔtsɛrɛ miɖe ne, nda miabara fiɛ miafɔ nnɛ loɣere mi miɖe?” ");
INSERT INTO akp_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nnɛgbe kama ne, Yesu ɔwara Galilea itubu nɛ masɛ marɔ ana sɔ Tiberia itubu. ");
INSERT INTO akp_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Maturi gbodzoo siai wũ alasɔ kumɛgɔ ɔto ɔsa sinyɛ ɔbara ma ɣii. ");
INSERT INTO akp_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu gu ɔ̃ marasuãdze ɔya kabemi kawɛ̃ masɛ maasɛ i kã iso. ");
INSERT INTO akp_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ma Yudase Kukpi Ɔtakuwara Bo Iyi iɖe ana ɔɔbore ibo. ");
INSERT INTO akp_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Gɔ Yesu ɔnyɔ ne, ɔnya maturi gbodzoo to maba ɔ̃ kɔrɛ, ne ɔso ɔkarɛ Filipo sɔ, “Lɛ boaɣa aɖera wa losi aaɣo mmagbe ɔɖuɖu maɖe?” ");
INSERT INTO akp_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ɔɣɛ ngbɔ si ɔkere Filipo ɔnyɔ atoa sɔ ka ɔɣe koko nnɛ ɔto ɔba ɔ̃abara. ");
INSERT INTO akp_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ne Filipo to ɔtã wũ mmuai sɔ, “Maturi alafa anyɔ ikpɛnɛ kuso kɔra iibawo aɖera ɔɣa aɣo mmagbe ɔɖe nane kɛkɛĩ kɛkɛĩ!” ");
INSERT INTO akp_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mmɔ ne rasuãdze mama gɔ nɖe Andrea gɔ nɖe Simon Petro ɔnyiibi ɔɣɛ sɔ, ");
INSERT INTO akp_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ɔbirɛrɛĩ ɔwɛ̃ pia i ngbe gɔ mba abolo kuboi kuru gu kufarai kunyɔ, ɣɛɛ ne, be i nnɛmɔ aabara maturi gbodzoo magbe?” ");
INSERT INTO akp_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ne Yesu ɔɣere ma sɔ, “Mitã maturi si masɛ i karɔ̃.” Mmɔ ɔkpa ne ɔso masɛ i sikua iso. Marɛrɛ̃ kerekere aaɖe lɛ kukpi kuru ɔɖui. ");
INSERT INTO akp_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ne Yesu ɔfɔ aɖera ne, ɔpɛ ɣaa siba i wã iti fiɛ ka ɔsu ɔɣɛɣɛ mma nsi karɔ̃. Ɔfɔ kufarai kuna fiɛ ɔbara ngbɔ ame, ɔbiara ɔɖe ara ɔmi. ");
INSERT INTO akp_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Gɔ ma ɔɖuɖu ɔɔɖe mami ne, ɔɣere ɔ̃ marasuãdze sɔ, “Mimala kupupui ɔɖuɖu ne midaatã kukawɛ̃ si kanina.” ");
INSERT INTO akp_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ne ɔso masa kupupui gɔ lokpɛkpɛti i abolo kuboi kuru gɔ i maturi ɔɖe ɔɖuɖu kanya ne, kuyi kusɛsɛi kuweo-kunyɔ. ");
INSERT INTO akp_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Gɔ mma mpia i mmɔ ɔnya iwawãra nɛ i Yesu ɔbara ne, maɣɛ sɔ, “Gbaã ne, Kanyaɖidze gɔ sɔ ɔto ɔ̃aba i ngbe ne!” ");
INSERT INTO akp_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ne gɔ Yesu ɔnya sɔ mato mabie sɔ maaba maamɔɛ̃ wũ sigara i so ɔle ame ne, ɔrui i ma kɔrɛ ɔkɛlɛ kube iso ɔ̃ ɔnɔwɛ̃. ");
INSERT INTO akp_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kutsuɛ gɔmɔ ne, ɔ̃ marasuãdze ɔrui makɛlɛ itubu kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Gɔ maya mabo i ɔkolo ame ne, matsɛ iwa ikɛlɛ Kapernaum isɛ, atoa sɔ kaɖe ɔɔro ne, Yesu iiba ɔ̃abo ma kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ɔwi gɔmɔ ne, ndu to miɖa so ala ɔwiri to ɔkpɛ̃ teteree. ");
INSERT INTO akp_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Gɔ marasuãdze ɔɔwa ɔkolo masɛ i ndu iso lɛ agu atɛ ito ikɛlɛ ana kere ne, manya Yesu sɛ i ndu iso ɔto ɔba ɔkolo kɔrɛ, ne ɔso ifɔ̃ ɔmɔɛ̃ ma! ");
INSERT INTO akp_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ɣɛɛ Yesu ɔɣere ma sɔ, “Midaanigã ne mme loɖe!” ");
INSERT INTO akp_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ma situ ɔkpase sisɛ, mafɔ wũ mapia i ɔkolo ame kere fiɛ mabo ɔkpokpo ngbegɔ masɛ ne. ");
INSERT INTO akp_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Gɔ kaɖe ɔsɛ̃ ne, maturi gbodzoo ma lowe i itubu ɔkpokpo gɔmɔ isɛ ɔnya sɔ ɔkolo ɔwɛ̃ pɛ lose i mmɔ. Maɣe sɔ Yesu iibo i ɔkolo gɔmɔ ame gu ɔ̃ marasuãdze ne ma ɔnɔwɛ̃ lorui. ");
INSERT INTO akp_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ɔwi gɔmɔ ne, sikolo mama dzɛ lose i Tiberia ɔba siabo i ngbegɔ i Bosate ɔpɛ Ɣaa siba i aɖera iti ɔsu ɔtã maturi ɔɖe kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ne ɔso gɔ maturi gbodzoo mamɔ ɔnya sɔ Yesu ɣee ɔ̃ marasuãdze na i mmɔ ne, mata mabo i sikolo ame makɛlɛ Kapernaum sɔ maanyɔnyɔ wũ. ");
INSERT INTO akp_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Gɔ manya Yesu i itubu ɔkpokpo gɔmɔ isɛ ne, makarɛ wũ sɔ, “Ratedze, ku mme ɔwi abo ngbe?” ");
INSERT INTO akp_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ne Yesu ɔɣere ma sɔ, “Gbaã loto loɣere mi sɔ, miito mibie me alasɔ minɔ wũ awawãra karɔ̃, ɣɛɛ sɔ mina aɖera miɖe mimi ɔso. ");
INSERT INTO akp_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Midaamararã so i aɖera wa loanina iso, ɣɛɛ i nwa loase atã ngbã mɛ loisɛ miro. Aɖera wagbe i Ɔturi Awune Ɔbi aatã mi ne, alasɔ Ɣaa gɔ nɖe Ɔse ɔɔpɛ wũ kufe.” ");
INSERT INTO akp_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ne makarɛ wũ sɔ, “Nda boabara fiɛ boawo nnɛ i Ɣaa to ɔɖɔɛ ɔbara?” ");
INSERT INTO akp_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu ɔtã ma mmuai sɔ, “Nnɛ i Ɣaa to ɔbie sɔ mibara nɖe sɔ miafɔ ngɔ ɔpia katɔ̃me miɖe.” ");
INSERT INTO akp_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Makarɛ wũ sɔ, “Mme iwawãra aabara ate bo bonya fiɛ boafɔ-ɔ boɖe? Be aawo ɔbara? ");
INSERT INTO akp_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bo mawa ɔɖe aɖera wa marɔ sɔ mana i fafuĩ ame lɛ kumɛgɔ i Ɣaa itɔ̃me ɔɣɛ sɔ, ‘Ɣaa ɔtã ma aɖera wa lobɔrɛ i kato maɖe.’ ” ");
INSERT INTO akp_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ne Yesu ɔɣere ma sɔ, “Gbaã loto loɣere mi sɔ, iiɖe Mose ɔɖe lotã mi aɖera wa lobɔrɛ i kato, ɣɛɛ wũ Ɔse nsɛ ɔtã aɖera gbaã wa lobɔrɛ i kato. ");
INSERT INTO akp_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Alasɔ aɖera wa i Ɣaa sɛ ɔtã nɖe ngɔ lose i kato ɔba fiɛ ɔsɛ ɔtã kayiiso maturi ngbã.” ");
INSERT INTO akp_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ne maɣere wũ sɔ, “Bosate, la ɔɔtã bo aɖera wagbe ɔwi biara.” ");
INSERT INTO akp_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu ɔɣere ma sɔ, “Mme nɖe ngbã aɖera wamɔ ne. Ngɔ loba wũ kɔrɛ ne, kukã iibakpɛ̃ wũ kunya, fiɛ ngɔ lofɔ me ɔɖe ne, ɔme iibakore wũ ɔnya. ");
INSERT INTO akp_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ɣɛɛ, nto loɣere mi sɔ atoa sɔ miɔnya me ne, miifɔ me miɖe. ");
INSERT INTO akp_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ɔbiara gɔ i wũ Ɔse ɔsu ɔtã me ne, ɔto ɔ̃aba wũ kɔrɛ, fiɛ loibasɛ̃ kuwɛ̃ gɔ loba wũ kɔrɛ lonya. ");
INSERT INTO akp_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Alasɔ loise i kato loba sɔ loaba loabara wũ kuɖɔɛ, ɣɛɛ ngɔ lopia me katɔ̃me kuɖɔɛ loabara. ");
INSERT INTO akp_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Fiɛ ngɔ lopia me katɔ̃me kuɖɔɛ nɖe sɔ loibayura kuwɛ̃ i mma ɔɖuɖu ɔsu ɔtã me ndɛ̃, ɣɛɛ sɔ loatara ma ɔɖuɖu lobɔ ngbã ku iyi tsɔra. ");
INSERT INTO akp_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Alasɔ nnɛ i wũ Ɔse to ɔbie nɖe sɔ, ɔbiara gɔ lonya Ɔbi fiɛ ɔfɔ wũ ɔɖe ne, ɔ̃ana ngbã mɛ loisɛ miro, fiɛ iyi tsɔra ne, loatara wũ ɔsɛ ngbã.” ");
INSERT INTO akp_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ma Yudase ɔtsɛ siwũti alasɔ ɔɣɛ sɔ, “Mme nɖe aɖera wa lose i kato.” ");
INSERT INTO akp_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ne maɣɛ sɔ, “Ɔrɛrɛ̃ gɔgbe ne, iiɖe Yosef ɔbi Yesu ɔɖe ɣɛɛ? Boɣe ɔ̃ ɔse gu ɔ̃ ɔnyi, ne ɔso lɛ ise ɔto ɔɣɛ sɔ kato ɔse?” ");
INSERT INTO akp_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ne Yesu ɔɣere ma sɔ, “Minyua so ɔwararã. ");
INSERT INTO akp_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kuwɛ̃ iibawo wũ kɔrɛ ɔba si iiɖe Tete gɔ lopia me katɔ̃me loboregu wũ ɔpia me, fiɛ loatara wũ lobɔrɛgu i makpise ame ku iyi tsɔra. ");
INSERT INTO akp_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ɣaa kanyamaɖidze ɔtsɛrɛ masɛ sɔ, ‘Ɣaa to ɔ̃ate ma ɔɖuɖu ara.’ Ne ɔso ɔbiara gɔ nsɛ ɔkã atsue fiɛ ɔsɛ ɔsuã ara ɔbɔrɛgu i Tete kɔrɛ ne, ɔsɛ ɔba wũ kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nnɛgbe iite sɔ kuwɛ̃ ɔɔnya Tete ɔnya. Ngɔ lobɔrɛ i Ɣaa kɔrɛ pɛ nɖe ngɔ loɔnya Tete ɔnya. ");
INSERT INTO akp_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Gbaã loto loɣere mi sɔ ngɔ lofɔ ɔɖe ne, ɔba ngbã mɛ loisɛ miro. ");
INSERT INTO akp_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mme nɖe aɖera wa nsɛ atã ngbã. ");
INSERT INTO akp_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mi mawa ɔɖe aɖera wa marɔ mana i fafuĩ ame, ɣɛɛ makpi. ");
INSERT INTO akp_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ɣɛɛ aɖera wa nsɛ abɔrɛ i kato ne, aɖe aɖera wa i ɔbiara gɔ loɖe wã iibakpi. ");
INSERT INTO akp_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mme nɖe aɖera wa mba ngbã fiɛ abɔrɛ i kato ne. Ɔbiara gɔ loaɖe aɖera wagbe ne, ɔto ɔ̃asɛ ngbã sɔ ɔ̃ibakpi. Aɖera wa loatã wũ nɖe wũ sosina dzɛ loasu lotã sɔ kayiiso maturi aana ngbã.” ");
INSERT INTO akp_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ne ma Yudase ɔtsɛgu so kakpadzɛ̃ i sikpã ame mato makarɛ sɔ, “Nda i ɔrɛrɛ̃ gɔgbe aasu ɔ̃ siturina ɔtã bo boɖe?” ");
INSERT INTO akp_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ne Yesu ɔɣere ma sɔ, “Gbaã loto loɣere mi sɔ, si miiwe Ɔturi Awune Ɔbi sina, minɛ ɔ̃ ima ne, ngbã kumiwɛ̃ iibawe i mi ame. ");
INSERT INTO akp_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ngɔ lowe wũ siturina, fiɛ ɔnɛ wũ ima ba ngbã mɛ nna katui fiɛ loatara wũ lobɔrɛgu i makpise ame ku iyi tsɔra. ");
INSERT INTO akp_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Alasɔ wũ siturina nɖe aɖera mɔmɔ fiɛ wũ ima nɖe ira sɛɛ nɛ maanɛ. ");
INSERT INTO akp_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ngɔ lowe wũ siturina fiɛ ɔnɛ wũ ima ne, ɔpia i wũ ame fiɛ mme wũ lopia i ɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kumɛgɔ i Tete gɔ mba ngbã ɔpia me katɔ̃me fiɛ iki i ɔ̃ ame ne loba ngbã ne, ngbɔ ame i ngɔ lowe wũ siturina aawe ngbã ne. ");
INSERT INTO akp_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nwagbe nɖe aɖera wa lose i kato aba ne, aise lɛ nwa i mi mawa ɔɖe ɣɛɛ makpi. Ɔbiara gɔ loaɖe aɖera wa loto loɣɛ ala ngbe iibakpi ɔnya.” ");
INSERT INTO akp_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu ɔɣɛ ara wagbe gɔ ɔto ɔte ara i ma Yudase kasarɛkɔ̃ i Kapernaum. ");
INSERT INTO akp_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Gɔ marasuãdze gbodzoo ɔnɔ ara ite nɛgbe ne, maɣɛ sɔ, “Ara wa ɔto ɔte ngbe ba ɔle gbaã! Nna loafɔ wã?” ");
INSERT INTO akp_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Atoa sɔ kuwɛ̃ iiɣere Yesu kuira ne, ɔɣe nnɛ siwũti mato, ne ɔɣere ma sɔ, “Mi wũ nnɛgbe ɔta iya mi iso? ");
INSERT INTO akp_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ne iyɔ nda iabara mi si minya Ɔturi Awune Ɔbi ɔya ɔkɛlɛ kato ngbegɔ ɔwe koko. ");
INSERT INTO akp_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ɣaa Siwarã nsɛ sitã ngbã, ɔturi ɔle na i kuira ame. Atɔ̃me wa loɣere mi ne, siwarã gu ngbã aɖe. ");
INSERT INTO akp_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ɣɛɛ mi mawɛ̃ iifɔ me miɖe.” Yesu ɔɣere ma ngbɔ ala ta karɔ̃kasɛkɔ̃ ne, ɔɣe mma loifɔ wũ maɖe gu ngɔ loaɖi wũ ɔtã. ");
INSERT INTO akp_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ne ka ɔɣere ma ana sɔ, “Nnɛgbe ɔso loɣere mi sɔ kuwɛ̃ iibawo wũ kɔrɛ ɔba si iiɖe Tete loɖi wũ ɔri ne.” ");
INSERT INTO akp_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ita i ɔwi gɔgbe ame ne, Yesu marasuãdze gbodzoo ɔkpese wũ i kama sɔ maisibasiai wũ. ");
INSERT INTO akp_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ne Yesu ɔfiniki ɔkarɛ marasuãdze iweo-inyɔ ma wũ sɔ, “Mi wũ miakpese me i kama?” ");
INSERT INTO akp_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Petro ɔtã mmuai sɔ, “Bosate, nna kɔrɛ boakɛlɛ? Aba atɔ̃me wa nsɛ atã ngbã. ");
INSERT INTO akp_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Fiɛ ana ne, bofɔ boɖe, fiɛ boɣe sɔ fɔ nɖe Ɔsekelea gɔ lobɔrɛ i Ɣaa kɔrɛ.” ");
INSERT INTO akp_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ne Yesu ɔɣere ma sɔ, “Iiɖe mi maturi iweo-inyɔ loɖi lotã so? Ɣɛɛ mi ndɛ̃ ɔwɛ̃ ɖe Ɔbosam!” ");
INSERT INTO akp_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesu ɔɣɛ nnɛgbe i Yuda gɔ nɖe Simon Iskariot ɔbi iso. Alasɔ atoa sɔ ɔɖe maturi iweo-inyɔ ndɛ̃ ɔwɛ̃ ne, ɔ̃ nto ɔ̃aɖi wũ ɔtã ne. ");
INSERT INTO akp_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nnɛgbe kama ne, Yesu ɔwe ɔki i Galilea, ɔ̃ibie sɔ ɔ̃akpese ɔkiki i Yudea karɔ̃ iso ala ma Yudase makpakpa to mabie sɔ maɖoe wũ. ");
INSERT INTO akp_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ɔwi gɔ ame masɛ maɖe Kukpakɛ Ame Isɛ Iyi ɔɔbore ibo. ");
INSERT INTO akp_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ne ɔso Yesu manyiibi ɔɣere wũ sɔ, “Bɔrɛ i ngbe si akɛlɛ Yudea sɔ fɔ marasuãdze aanya ara wa ato abara. ");
INSERT INTO akp_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Alasɔ ɔbiara gɔ nto ɔbie sɔ ɔfɔ iyere iisɛ ɔbara ara ɔwɛrɛ. Gɔ ato abara ara wagbe ne, tã kayiiso ɔɖuɖu si matsue-ɔ!” ");
INSERT INTO akp_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Maɣɛ ngbɔ ala nane ɔ̃ manyiibi iifɔ wũ maɖe. ");
INSERT INTO akp_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu ɔɣere ma sɔ, “Wũ ɔwi iiɣo, mi ne, ɔwi biara lɛ ɔtã mi. ");
INSERT INTO akp_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kayiiso maturi iibawo mi ɔtsiri, ɣɛɛ matsiri me, alasɔ nsɛ loɖi ma ara nyanyarĩa loɣere ma. ");
INSERT INTO akp_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mikɛlɛ iyi kaɖekɔ̃ ne mme loito loba alasɔ wũ ɔwi sɛɛ iiɣo.” ");
INSERT INTO akp_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Gɔ ɔɣere ma ngbɔ ne, ka ɔwe i Galilea. ");
INSERT INTO akp_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Gɔ ɔ̃ manyiibi ɔɔkɛlɛ iyi kaɖekɔ̃ kama ne, Yesu ɔ̃ wũ ɔba ɔ̃akɛlɛ i iwɛrɛ ame, ɣɛɛ ɔ̃ikɛlɛ kpawee. ");
INSERT INTO akp_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ma Yudase makpakpa ɔtsɛ wũ inyɔnyɔ, ne mato makarɛ sɔ, “Lɛ i ɔrɛrɛ̃ gɔmɔ pia?” ");
INSERT INTO akp_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Maturi gbodzoo ɔɣɛ siwɔwɔi i Yesu iso. Mawɛ̃ sɔ ɔturi sɛɛ ɔɖe, mawɛ̃ ana sɔ, “Ooɣo! Ɔto ɔkã maturi ɔyura!” ");
INSERT INTO akp_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ɣɛɛ kuwɛ̃ iiɣɛ kuira i ɔ̃ iso kpawee alasɔ mato manigã ma Yudase makpakpa. ");
INSERT INTO akp_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Iyi nɛ mato maɖe ndɛ̃ndɛ̃ ne, Yesu ɔba ɔ̃abo Ɣaa Isɔrɛyo ame ɔtsɛ ara ite. ");
INSERT INTO akp_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ibara ma Yudase makpakpa ɣii matsɛ ikarɛ sɔ, “Nda ibara fiɛ ɔrɛrɛ̃ gɔgbe ɣe ara ngbɔ gɔ ɔ̃ifɔ ikpadzɛ̃ kuiwɛ̃?” ");
INSERT INTO akp_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ne Yesu ɔɣere ma sɔ, “Ara wa loto lote ne, iiɖe mme mɔmɔ are aɖe, ɣɛɛ Ɣaa gɔ lopia me katɔ̃me are aɖe. ");
INSERT INTO akp_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ɔbiara gɔ nto ɔbie sɔ ɔ̃abara Ɣaa kuɖɔɛ to ɔ̃atsue si ara wa loto lote ne, wũ ɔle iso iɖe, ɣee Ɣaa ɔle ame abɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ɔturi gɔ nsɛ ɔɖe ika i ɔ̃ ɔle ame sɛ ɔbie iyere ɔtã so, ɣɛɛ ngɔ nto ɔbie iyere ɔtã ngɔ lopia wũ katɔ̃me sɛ ɔɣɛ ɔnukuare fiɛ sila kusiwɛ̃ na i ɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Iiɖe Mose lotã mi mmara? Ɣɛɛ mi kuwɛ̃ iito miɖe mmara iso. Be ɔso mito mibie sɔ miaɖoe me?” ");
INSERT INTO akp_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mmamɔ ɔɣɛ sɔ, “Siwarã lalaa pia i fɔ ame! Nna nto ɔbie sɔ ɔ̃aɖoe-ɔ?” ");
INSERT INTO akp_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ne Yesu ɔtã ma mmuai sɔ, “Iwawãra iwɛ̃ saã nɛ lobara ɔbara mi ɣii. ");
INSERT INTO akp_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mose ɔtã mi mmara sɔ mitu sirɛrɛ̃, ɣɛɛ iiɖe Mose ɔwi i sirɛrɛ̃ itu ɔsɛ karɔ̃, ka masɛ mabara ne ta mi mawa ɔwi, ne ɔso misɛ mitu mi mabi sirɛrɛ̃ ku Iwarãyi ne. ");
INSERT INTO akp_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Si maawo ɔturi sirɛrɛ̃ ɔtu ku Iwarãyi, ɣɛɛ maitu Mose mmara ne, be ɔso fiɛ mito minagu me sikpã sɔ losa ɔturi ku Iwarãyi? ");
INSERT INTO akp_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Midaanyɔ maturi i katɔ̃ miɣɛgu ma atɔ̃me, ɣɛɛ miɣɛ atɔ̃me i ɔri iso.” ");
INSERT INTO akp_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Mawɛ̃ i Yerusalem ɔtsɛ ikarɛ sɔ, “Iiɖe ɔrɛrɛ̃ gɔgbe i makpakpa to mabie sɔ maɖoe ne? ");
INSERT INTO akp_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ɣɛɛ minyɔ wũ! Ɔ̃ nɣɛ i ngbe ɔto ɔɖe ika i ɔgbami, ɣɛɛ maito mawo wũ kuira ɔɣere! Ɛɛbɛrɛ ɔfɔ maɔfɔ wũ gbaã sɔ ɔ̃ nɖe Kristo? ");
INSERT INTO akp_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Si Kristo ɔba ne, kuwɛ̃ iibatsue ngbegɔ ɔbɔrɛ, ɣɛɛ ɔrɛrɛ̃ gɔgbe ne, boɣe ngbegɔ ɔbɔrɛ.” ");
INSERT INTO akp_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Gɔ Yesu to ɔte ara i Isɔrɛyo ame ne, ɔla kulu teteree ɔɣɛ sɔ, “Mibua miɣe me gu ngbegɔ lobɔrɛ? Loiba i mme mɔmɔ ɔle ame. Ngɔ lopia me katɔ̃me ne, nukuarese ɔɖe, fiɛ miiɣe wũ. ");
INSERT INTO akp_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ɣɛɛ mme loɣe wũ alasɔ ɔ̃ kɔrɛ lobɔrɛ fiɛ ɔ̃ lopia me katɔ̃me.” ");
INSERT INTO akp_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nnɛgbe ɔso ne, mabie sɔ si mamɔɛ̃ wũ, ɣɛɛ kuwɛ̃ iiwo kɔrɔ̃ ɔɖi ɔsia wũ iso alasɔ ɔ̃ ɔkpiwi iiɣo. ");
INSERT INTO akp_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ɣɛɛ maturi gbodzoo i ma ndɛ̃ ɔfɔ wũ maɖe mato makarɛ sɔ, “Si Kristo ɔba ne, ɔ̃abara awawãra wa loɖo nwa i ɔrɛrɛ̃ gɔgbe ɔɔbara?” ");
INSERT INTO akp_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ma Farisise ɔnɔ maturi gbodzoo to maɣɛ siwɔwɔi dzɛgbe i Yesu iso, ne ɔso ma gu masɔrɛdze makpakpa ɔpia madzuɛ̃se sɔ mamɔɛ̃ wũ mabɔ. ");
INSERT INTO akp_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ne Yesu ɔɣɛ sɔ, “Loto loawe i mi kɔrɛ ɔwi kɛkɛĩ, ne kama ne, loakpese lokɛlɛ ngɔ lopia me katɔ̃me kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mito miabie me, ɣɛɛ miito mianya me, alasɔ miito miaɣo ngbegɔ loawe ɔba.” ");
INSERT INTO akp_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ne ma Yudase makpakpa ɔkarɛ so sɔ, “Lɛ ɔto ɔba ɔ̃akɛlɛ fiɛ boabie wũ boibanya wũ? Ɔbie ɔto sɔ ɔ̃akɛlɛ ma Yudase ma mpia i ma Helase simagɛ̃ ame ɔsɛ ɔ̃ate ma Helase ara? ");
INSERT INTO akp_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Itɔ̃me nɛ ɔɣɛ ngbe karɔ̃ ɣɛɛ? Ɔɣɛ sɔ, ‘Mito mianyɔnyɔ me, ɣɛɛ miibanya me.’ Ɔɣɛ ana sɔ, ‘Ngbegɔ losɛ ne, miibawo ɔba.’ ” ");
INSERT INTO akp_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Iyi tsɔra nɛ lobua inya iɖo i iyi iɖe ame ne, Yesu ɔta ɔya ɔla kulu teteree sɔ, “Ɔbiara gɔ i ɔme to ɔkore si ɔba wũ kɔrɛ ɔba ɔ̃anɛ ndu. ");
INSERT INTO akp_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ɔbiara gɔ lofɔ me ɔɖe fiɛ ɔnɛ ndu mɛgbe ne, lɛ kumɛgɔ i Ɔko Sekelea ɔɣɛ ne, ‘Ndu mɛ loisɛ misɔ̃ fiɛ misɛ mitã ɔturi ngbã aabore ɔkore mibɔrɛ i ɔ̃ ɔtu ame.’ ” ");
INSERT INTO akp_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu ɔɣɛ nnɛgbe i Siwarã dzɛ mma lofɔ wũ maɖe aafɔ iso. Ɔwi gɔmɔ ame ne, gɔ Yesu iita ɔbɔrɛ i makpise ame ɔkɛlɛ ikpawaĩ ame ɔso ne, Ɣaa iisu Siwarã Bielea ɔtã marasuãdze. ");
INSERT INTO akp_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Maturi gbodzoo mamɔ mawɛ̃ ma lonɔ nnɛ i Yesu ɔɣɛ ɔɣɛ sɔ, “Gbaã ɔrɛrɛ̃ gɔgbe ne, Ɣaa Kanyaɖidze ɔɖe.” ");
INSERT INTO akp_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Mamama ana sɔ, “Ɔ̃ nɖe Kristo.” Ɣɛɛ mamama ana sɔ, “Kristo iibabɔrɛ i Galilea. ");
INSERT INTO akp_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ɔko Sekelea ɔɣɛ sɔ Kristo ne, David ɔwa tɛtɛ ɔ̃aɖe fiɛ ɔ̃abɔrɛ i Betlehem ngbegɔ i David ɔse.” ");
INSERT INTO akp_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ne ɔso iɣɛɣɛso ɔbo i ma ɔɖuɖu ndɛ̃ ala Yesu ɔso. ");
INSERT INTO akp_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mawɛ̃ ɔbie sɔ si mamɔɛ̃ wũ, ɣɛɛ kuwɛ̃ iiwo kɔrɔ̃ ɔɖi ɔsia wũ iso. ");
INSERT INTO akp_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Gɔ madzuɛ̃se ɔkpese makɛlɛ ne, masɔrɛdze makpakpa gu ma Farisise ɔkarɛ ma sɔ, “Be ɔso fiɛ miimɔɛ̃ wũ mibɔ?” ");
INSERT INTO akp_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Madzuɛ̃se ɔtã mmuai sɔ, “Boinɔ bonɔ kuwɛ̃ ɔɖe ika lɛ ɔrɛrɛ̃ gɔgbe!” ");
INSERT INTO akp_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ne ma Farisise ɔkarɛ ma sɔ, “Mi wũ ne, ɔ̃ɔpia mi iti ndu? ");
INSERT INTO akp_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Miɔnya minya ɔkpakpa ɔwɛ̃, ɣee ɔ Farisise ɔwɛ̃ ɔfɔ wũ ɔɖe? ");
INSERT INTO akp_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Maturi gbodzoo magbe iiɣe Mose mmara, ne ɔso Ɣaa sigbarĩ siai ma!” ");
INSERT INTO akp_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemo gɔ nɖe ma ndɛ̃ ɔwɛ̃ fiɛ ɔ̃ɔsɛ Yesu kɔrɛ ɔnya ɔɣere matsɔra sɔ, ");
INSERT INTO akp_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Bo mmara iitã bo ɔri sɔ boatã ɔturi ipɔ ku ɔwi gɔ ame boiɣɛgu wũ atɔ̃me bonɔ ɔ̃ kanya ame itɔ̃me.” ");
INSERT INTO akp_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ɣɛɛ matã wũ mmuai sɔ, “Fɔ wũ Galilea abɔrɛ? Fafarɛ Ɔko Sekelea ame kukaakɔ ne ato aatsue sɔ Ɣaa Kanyaɖidze kuwɛ̃ iibabɔrɛ i Galilea ɔnya.” ");
INSERT INTO akp_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","(Ne ɔso ɔbiara ɔrui ɔkɛlɛ ɔ̃ iyo.) ");
INSERT INTO akp_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu ɔ̃ wũ ɔrui ɔkɛlɛ Nnɔĩ Adziri Kube iso. ");
INSERT INTO akp_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kaɖesɛ̃a kaya tutuutu ne, ɔkpese ɔba Ɣaa Isɔrɛyo. Maturi ɔɖuɖu ɔba ɔ̃ kɔrɛ fiɛ ɔsɛ i karɔ̃ ɔtsɛ ma ara ite. ");
INSERT INTO akp_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Maratedze gu ma Farisise ɔkɔ ɔrɔ̃go ɔwɛ̃ gɔ mamɔɛ̃ gɔ ɔto ɔɖe asɔrɔ̃ mabɔ maaɣedza i ɔgba ame. ");
INSERT INTO akp_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Maɣere Yesu sɔ, “Ratedze, mamɔɛ̃ ɔrɔ̃go gɔgbe kɔrɔ̃ kɔrɔ̃ gɔ ɔto ɔɖe asɔrɔ̃. ");
INSERT INTO akp_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","I mmara mɛ i Mose ɔtã bo kanya ne, ikote sɔ boapɛ wũ ata boɖoe, ɣɛɛ ne, be ato aɣɛ i ne iso?” ");
INSERT INTO akp_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Makarɛ Yesu itɔ̃me nɛgbe si mala wũ manyɔ si maana itɔ̃me nɛ iso maaya fiɛ maatã wũ ipɔ. Ɣɛɛ Yesu ɔkadza ɔto ɔtsɛrɛ ara i karɔ̃ ala ɔ̃ irɔĩ. ");
INSERT INTO akp_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Gɔ maɣɛ matogu Yesu itɔ̃me ikarɛ ne, ɔtara iti kato ɔɣere ma sɔ, “Mi ndɛ̃ ngɔ loibara ikpi ɔnya si ɔɖe katɔ̃ ɔpɛ ɔrɔ̃go gɔgbe ita.” ");
INSERT INTO akp_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yesu ɔledza ikadza ɔto ɔtsɛrɛ ara i karɔ̃. ");
INSERT INTO akp_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Gɔ manɔ itɔ̃me nɛgbe ne, marui ɔwɛ̃ ɔwɛ̃ ita i makpakpa iso iba iakuti Yesu gu ɔrɔ̃go ɔnɔwɛ̃. ");
INSERT INTO akp_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Gɔ Yesu ɔtara so fiɛ ɔnya sɔ ma ɔɖuɖu ɔɔrui ne, ɔkarɛ wũ sɔ, “Ɔrɔ̃go, i ɖe ma? Ma kuwɛ̃ iitã-ɔ ipɔ?” ");
INSERT INTO akp_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ne Ɔrɔ̃go ɔtã mmuai sɔ, “Ooɣo, Bosate.” Ne Yesu ɔɣere wũ sɔ, “Iyɔ mme wũ loitã-ɔ ipɔ. Kɛlɛ, ɣɛɛ daasibara ikpi ana.” ");
INSERT INTO akp_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nnɛmɔ kama ne, Yesu ɔɖegu mmamɔ ika ɔɣere ma sɔ, “Mme nɖe kayiiso ikpawaĩ, ne ɔso ɔbiara gɔ losiai me iibasɛ i idududu ame ɔnya ɣɛɛ ɔ̃ana ngbã ame ikpawaĩ.” ");
INSERT INTO akp_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ma Farisise ɔɣere wũ sɔ, “Ato aɖe aɖansiɛ i fɔ mɔmɔ iso, ne ɔso fɔ aɖansiɛ iiɖe ɔnukuare.” ");
INSERT INTO akp_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ne Yesu ɔtã ma mmuai sɔ, “Si loɖe so aɖansiɛ kɔra ne, wũ aɖansiɛ ɖe ɔnukuare alasɔ loɣe ngbegɔ lose loba gu ngbegɔ losɛ. Mi ne, miiɣe ngbegɔ lose gu ngbegɔ losɛ. ");
INSERT INTO akp_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mi ne, maturi ara inyɔ kanya misɛ miɣɛ mi atɔ̃me, ɣɛɛ mme ne, loisɛ loɣɛgu kuwɛ̃ atɔ̃me. ");
INSERT INTO akp_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Fiɛ si loɣɛ itɔ̃me ana ne, wũ atɔ̃me iɣɛ to iaya, alasɔ iiɖe wũ ɔnɔwɛ̃ mme nsɛ loɣɛ, ɣɛɛ bo gu ngɔ lopia me katɔ̃me. ");
INSERT INTO akp_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Matsɛrɛ mapia i mi mmara ɔko ame sɔ si maturi inyɔ ɔɖe aɖansiɛ i ira iso ne, iyɔ ma itɔ̃me ɖe ɔnukuare. ");
INSERT INTO akp_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mme ne, nsɛ loɖe so aɖansiɛ fiɛ Tete gɔ lopia me katɔ̃me ana sɛ ɔɖe me aɖansiɛ.” ");
INSERT INTO akp_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ne mato makarɛ Yesu sɔ, “Lɛ i fɔ Ɔse pia?” Ɔtã ma mmuai sɔ, “Miiɣe me, fiɛ miiɣe Tete ana. Si ɔɣe miɣe me ne, tee miatsue wũ Ɔse ana.” ");
INSERT INTO akp_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu ɔte ara wagbe i Isɔrɛyo ngbegɔ masɛ mato ara masɛ. Kuwɛ̃ iiwo wũ ɔmɔɛ̃ alasɔ ɔ̃ ɔkpiwi iiɣo. ");
INSERT INTO akp_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu ɔledza ma iɣere sɔ, “Loto loarui i mi kɔrɛ, miabie me, ɣɛɛ miakpi i mi akpi ame. Ngbegɔ losɛ ne, miibawo mmɔ ɔba.” ");
INSERT INTO akp_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ne ma Yudase to makarɛ so sɔ, “Ɔɖoe ɔto ɔbie sɔ ɔ̃aɖoe so ɔso fiɛ ɔto ɔɣɛ sɔ ‘Ngbegɔ losɛ ne miibawo ɔba’?” ");
INSERT INTO akp_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ne Yesu ɔɣere ma sɔ, “Mi ne, kayiiso ngbe mibɔrɛ, ɣɛɛ mme ne, kato lobɔrɛ. Mi ne, kayiiso maturi miɖe, ɣɛɛ mme ne, loibɔrɛ i kayi gagbe iso. ");
INSERT INTO akp_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ne ɔso loto loɣere mi sɔ mito miakpi i mi akpi ame ne. Si miifɔ miɖe sɔ mme nɖe ngɔ loɖe ne, miakpi miwe i mi akpi ame.” ");
INSERT INTO akp_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Makarɛ wũ sɔ, “Fɔ nɖe nna?” Ne ɔtã ma mmuai sɔ, “Loɔɣere mi ta karɔ̃kasɛkɔ̃ fiɛ ngbɔ ame loto loɣere mi ne. ");
INSERT INTO akp_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Loba atɔ̃me gbodzoo i mi iso wa loasu lotã mi ala ipɔ, ɣɛɛ ngɔ lopia me katɔ̃me ne, nukuarese ɔɖe. Fiɛ nnɛ lonɔ lobɔrɛgu i ɔ̃ kɔrɛ imomo loto lopɛ lotã kayiiso.” ");
INSERT INTO akp_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Maitsue sɔ Ɣaa iso i Yesu to ɔɖe ika. ");
INSERT INTO akp_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ne ɔso Yesu ɔɣere ma sɔ, “Ɔwi gɔ miakɔlɛ Ɔturi Awune Ɔbi kato ne, ɔwi gɔmɔ ame miatsue sɔ Mme nɖe ngɔ Loɖe ne. Ana ne, miatsue sɔ loisɛ lobara kuira i wũ ɔle ame, ɣɛɛ nnɛ i Tete ɔɣere me losɛ loɣɛ. ");
INSERT INTO akp_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ngɔ lopia me katɔ̃me piagu me fiɛ ɔ̃isɛ ɔnyua me ɔsɛ, alasɔ nsɛ lobara ɔ̃ kuɖɔɛ ɔwi biara ame.” ");
INSERT INTO akp_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Maturi gbodzoo ma lonɔ ara wa i Yesu ɔɣɛ ngbe, ɔfɔ wũ maɖe. ");
INSERT INTO akp_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ne Yesu ɔɣere ma Yudase ma lofɔ wũ maɖe sɔ, “Si mibara i ara wa lote mi iso ne, iyɔ wũ marasuãdze mɔmɔ miɖe. ");
INSERT INTO akp_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Miatsue ɔnukuare, fiɛ ɔnukuare aatã mi isɛguso.” ");
INSERT INTO akp_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Maɣere wũ sɔ, “Abraham mawa boɖe, fiɛ boiɖe kuwɛ̃ masande. Ne ɔso be ɔso fiɛ ato aɣɛ sɔ boana isɛguso?” ");
INSERT INTO akp_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ne Yesu ɔɣere ma sɔ, “Gbaã loto loɣere mi sɔ ɔbiara gɔ nsɛ ɔbara ikpi ne, ikpi ɔsande ɔɖe. ");
INSERT INTO akp_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ɔsande iisɛ ɔwe i iyo ɔwi biara ame, ɣɛɛ iyo ɔbi sɛ ɔwe i iyo ɔwi biara. ");
INSERT INTO akp_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ne ɔso si Ɣaa Ɔbi ɔtã mi isɛguso ne, miasɛgu so gbaã. ");
INSERT INTO akp_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Loɣe sɔ Abraham mawa miɖe, ɣɛɛ mito mibie sɔ si miɖoe me alasɔ wũ atɔ̃me iimɔɛ̃ mi ɔtu. ");
INSERT INTO akp_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nnɛ lonya i Tete kɔrɛ loto loɣere mi, fiɛ mi wũ nnɛ minɔ i mi ɔse kɔrɛ mito mibara.” ");
INSERT INTO akp_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Matã wũ mmuai sɔ, “Abraham mawa boɖe.” Yesu ɔɣere ma sɔ, “Si Abraham mawa miɖe ne, tee miabara ara lɛ Abraham awe. ");
INSERT INTO akp_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ɣɛɛ kiniɔ ne, mito mibie sɔ miaɖoe me, mme gɔ nto loɣere mi ɔnukuare gɔ lonɔ lobɔrɛgu i Ɣaa kɔrɛ. Abraham iisɛ ngbã ngbɔ. ");
INSERT INTO akp_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mi ne, ara wa i mi ɔse mɔmɔ ɔbara mito mibara.” Ma Yudase ɔtã Yesu mmuai sɔ, “Iiɖe ɔmagɛ̃ ame mabi boɖe. Ɔse ɔwɛ̃ saã gɔ boba nɖe Ɣaa!” ");
INSERT INTO akp_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ne Yesu ɔɣere ma sɔ, “Si biele ne Ɣaa nɖe mi Ɔse ne, tee miaɖɔɛ me alasɔ Ɣaa kɔrɛ lobɔrɛ loba i ngbe. Loiba i wũ mɔmɔ ɔle ame, ɣɛɛ ɔ̃ lopia me katɔ̃me. ");
INSERT INTO akp_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Be ɔso fiɛ miito minɔ nnɛ loto lote mi karɔ̃? Gɔ miito mibie sɔ minɔ wũ itɔ̃me ɔso. ");
INSERT INTO akp_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ɔbosam mabi miɖe, fiɛ mito mibie sɔ miabara ara wa nsɛ akpɛ̃ mi ɔse ɔkã. Ta karɔ̃kasɛkɔ̃ ne, turiɖoese ɔɖe fiɛ ɔ̃isɛ ɔɖɔɛ ɔnukuare alasɔ ɔnukuare na i ɔ̃ ame. Si ɔto ɔla sila ne, ɔtu iisɛ ɔkpa wũ alasɔ ne nɖe ɔ̃ ngbã ne. Ladze ɔɖe fiɛ ɔ̃ nɖe maladze ɔɖuɖu ɔse. ");
INSERT INTO akp_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ɣɛɛ mme ne, ɔnukuare loto loɣere mi, fiɛ ne ɔso miifɔ me miɖe ne. ");
INSERT INTO akp_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mi nna loawo me ɔɣere sɔ loɖe ipɔ ala lobara ikpi? Si loto loɣere mi ɔnukuare ne, be ɔso miito mifɔ me miɖe? ");
INSERT INTO akp_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ngɔ lobɔrɛ i Ɣaa kɔrɛ sɛ ɔkã Ɣaa itɔ̃me atsue. Mi ɣɛɛ ne, iiɖe Ɣaa kɔrɛ mibɔrɛ, ne ɔso miito mikã atsue ne.” ");
INSERT INTO akp_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ne ma Yudase ɔɣere wũ sɔ, “Si boɣere-ɔ sɔ ɔ Samariase aɖe ne siwarã lalaa pia i fɔ ame ne, bola sila?” ");
INSERT INTO akp_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu ɔtã ma mmuai sɔ, “Siwarã lalaa na i wũ ame. Loto lokɔlɛ Tete iyere kato, ɣɛɛ mito mibɔ me karɔ̃. ");
INSERT INTO akp_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Loito lole so, ɣɛɛ ɔwɛ̃ pia gɔ nsɛ ɔle me. Ɔ̃ nɖe atɔ̃meɣɛdze bɔlɔlɔa ne. ");
INSERT INTO akp_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Gbaã loto loɣere mi sɔ ngɔ nsɛ ɔbara i wũ ara ite iso iibakpi ɔnya.” ");
INSERT INTO akp_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ne ma Yudase ɔɣere wũ sɔ, “Kini bosia ita sɔ gbaã ne, siwarã lalaa pia i fɔ ame ne! Abraham ɔkpi, fiɛ kanyamaɖidze ana ɔkpi. Ɣɛɛ ato aɣere bo sɔ ngɔ lobara i fɔ ara ite iso iibakpi ɔnya. ");
INSERT INTO akp_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Boifɔ nnɛ ato aɣɛ boɖe alasɔ bo ɔwa Abraham ɔkpi, fiɛ kanyamaɖidze ana ɔkpi. Mme ɔturi igbã ato abu so sɔ aɖe?” ");
INSERT INTO akp_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ne Yesu ɔɣere ma sɔ, “Si ɔle loto so ne, iyɔ ile nɛmɔ iiɖe kuira. Ɣɛɛ ngɔ nsɛ ɔle me nɖe wũ Ɔse, ngɔ ame mito mikpere sɔ mi Ɣaa. ");
INSERT INTO akp_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Miiɣe wũ, ɣɛɛ mme loɣe wũ. Si loɣɛ sɔ loiɣe wũ ne, loakpese ladze lɛ mi. Ɣɛɛ mme loɣe wũ fiɛ losɛ lokã wũ atsue. ");
INSERT INTO akp_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","So ɔɣɔ mi ɔwa Abraham gɔ ɔtsue sɔ loto loaba. Ɔnya ne, fiɛ so ɔɣɔ wũ.” ");
INSERT INTO akp_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ma Yudase ɔɣere wũ sɔ, “Gɔ aifɔ akɔ siru ne ɔɣɛ ato sɔ anya Abraham?” ");
INSERT INTO akp_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu ɔɣere ma sɔ, “Gbaã loto loɣere mi sɔ si maaɣe Abraham ne, ka lopia kayi.” ");
INSERT INTO akp_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Gɔ ɔɣɛ ngbɔ ne, mamala ata sɔ si mapɛ wũ maɖoe ɣɛɛ Yesu ɔwɛrɛ ɔbɔrɛ i ma ndɛ̃ i Isɔrɛyo ame mmɔ. ");
INSERT INTO akp_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Gɔ Yesu sɛ ɔto ɔfe ne, ɔnya ɔrɛrɛ̃ ɔwɛ̃ gɔ maɣe nɔbiɛdze. ");
INSERT INTO akp_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ɔ̃ marasuãdze ɔkarɛ wũ sɔ, “Ratedze, nna lobara ikpi ɔso fiɛ maɣe wũ nɔbiɛdze? Ɔ̃ mɔmɔ ɛɛbɛrɛ ɔ̃ maɣese lobara ikpi?” ");
INSERT INTO akp_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ne Yesu ɔɣere ma sɔ, “Iiɖe ɔrɛrɛ̃ gɔgbe ɣee ɔ̃ maɣese lobara ikpi, ɣɛɛ maɣe wũ ngbɔ sɔ si Ɣaa aaɖi ɔ̃ ɔle ɔte iki i ɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ayi kumɛgɔ bopia i ikpɛnɛ ame ne, ikote sɔ boabara ngɔ lopia me katɔ̃me karabara. Kasɛ̃ to kaba gɔ kuwɛ̃ iisibabara karabara. ");
INSERT INTO akp_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ayi kumɛgɔ lopia i kayiiso ne, mme nɖe kayiiso ɔkaniɛ.” ");
INSERT INTO akp_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Gɔ Yesu ɔɣɛ ngbɔ ne, ɔtua sinyatu ɔfere i karɔ̃ ɔsu ɔbara ibata ɔsu ɔnukutu i ɔrɛrɛ̃ gɔmɔ anɔmi iso. ");
INSERT INTO akp_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ɔɣere wũ sɔ, “Kɛlɛ aapie ndu i Siloa ibu ame.” Siloa karɔ̃ nɖe sɔ ɔpia wũ katɔ̃me. Ne ɔso ɔrɛrɛ̃ gɔgbe ɔrui ɔsɛ ɔ̃apie ndu i ibu ame ɔtsɛ ara inya, fiɛ ɔkpese ɔba. ");
INSERT INTO akp_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Gɔ ɔ̃ kagbamiku maturi gu mma nsɛ manya ɔwanyi ara ɔnya wũ ne, makarɛ sɔ, “Iiɖe ɔrɛrɛ̃ gɔgbe nsɛ ɔsɛ ɔwanyi ara?” ");
INSERT INTO akp_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mawɛ̃ sɔ ɔ̃ ɔɖe, mamama ana sɔ, “Ooɣo, ɔre kere ɔre wũ.” Ne ɔ̃ mɔmɔ ɔɣere ma sɔ, “Mme loɖe.” ");
INSERT INTO akp_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Makarɛ wũ sɔ, “Nda ibara fiɛ fɔ anɔmi ɔbusi?” ");
INSERT INTO akp_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ɔtã ma mmuai sɔ, “Ɔrɛrɛ̃ gɔ marɔ sɔ Yesu ɔɖe lobara ibata ɔnukutu me anɔmi fiɛ ɔɣere me sɔ lokɛlɛ loapie ndu i Siloa ibu ame. Ne gɔ lobara ne, lotsɛ ara inya.” ");
INSERT INTO akp_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Makarɛ wũ sɔ, “I lɛ ɔpia?” Ne ɔɣere ma sɔ, “Loiɣe.” ");
INSERT INTO akp_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Makɔ ɔrɛrɛ̃ gɔ loɖe nɔbiɛdze ngbe makɛlɛgu ma Farisise kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Iyi nɛ i Yesu ɔbara ibata ɔsu ɔsa ɔrɛrɛ̃ gɔgbe ne, Iwarãyi iɖe. ");
INSERT INTO akp_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ma Farisise ɔledza wũ ikarɛ kumɛgɔ iɖe ɔbara fiɛ ɔ̃ anɔmi ɔbusi. Ɔɣere ma sɔ, “Ɔbara ibata ɔsia me i anɔmi iso fiɛ losɛ loafore katɔ̃ kere ne lotsɛ inya ne.” ");
INSERT INTO akp_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ma Farisise mawɛ̃ ɔɣɛ sɔ, “Ɔrɛrɛ̃ gɔ lobara ira nɛgbe ne, iiɖe Ɣaa kɔrɛ iɖe ɔbɔrɛ ala ɔ̃isɛ ɔwarɛ Iwarãyi mmara.” Ɣɛɛ mamama ana sɔ, “Nda i ngɔ nɖe kpibaradze aawo awawãra wagbe igbã ɔbara?” Ne ɔso iɣɛɣɛso ɔbo i ma ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ma Farisise ɔledza ɔrɛrɛ̃ gɔgbe ikarɛ sɔ, “Gɔ ɔ̃ losa-ɔ ne, be abu sɔ ɔɖe?” Ne ɔrɛrɛ̃ ɔtã ma mmuai sɔ, “Ɣaa Kanyaɖidze ɔɖe.” ");
INSERT INTO akp_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ma Yudase makpakpa iifɔ maɖe sɔ ɔ̃ anɔmi ɔbiɛ fiɛ kiniɔ ne, ka ɔto ɔnya ara, ne ɔso mapia masɛ maakpere ɔ̃ maɣese mabɔ. ");
INSERT INTO akp_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ne makarɛ ma sɔ, “Mi ɔbi ɔɖe ngbe? Mi sɔ nɔbiɛdze ɔɖe miɣe wũ, nda ibara fiɛ ka ɔto ɔnya ara?” ");
INSERT INTO akp_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Maɣese ɔtã mmuai sɔ, “Boɣe sɔ bo ɔbi ɔɖe fiɛ ɔ̃ anɔmi ɔbiɛ fiɛ boɣe wũ. ");
INSERT INTO akp_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ɣɛɛ kumɛgɔ ibara fiɛ ka ɔto ɔnya ara ne, boiɣe, fiɛ boiɣe ngɔ losa wũ ana. Mikarɛ wũ ne ɔ̃ɔkpa anɔ gɔ ɔ̃awo so kanya ɔɖi!” ");
INSERT INTO akp_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ɔ̃ maɣese ɔtã mmuai ngbɔ alasɔ mato manigã ma Yudase makpakpa ma loɔsɛ iti ame maɣɛ masɛ sɔ ɔrere gɔ loaɣɛ sɔ ɔfɔ Yesu ɔɖe sɔ ɔ̃ nɖe Kristo ne, maasa wũ maɖi i ma kasarɛkɔ̃. ");
INSERT INTO akp_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ne ɔso i ɔ̃ maɣese ɔɣɛ sɔ, “Mikarɛ wũ ne ɔ̃isiɖe ɔbiɛtɛ ne!” ");
INSERT INTO akp_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Maledza ɔrɛrɛ̃ gɔgbe ikpere ibɔ ɔkpɛ nyɔare maɣere wũ sɔ, “Kã ndamu tã Ɣaa sɔ aaɣere bo ɔnukuare. Bo boɣe sɔ ɔrɛrɛ̃ gɔ losa-ɔ ne, kpibaradze ɔɖe.” ");
INSERT INTO akp_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ɔrɛrɛ̃ gɔ lona isosarɛ ɔtã ma mmuai sɔ, “Kpibaradze ɔɖe o-o, kpibaradze ɔ̃iɖe o-o ne, loiɣe. Ira ka iwɛ̃ loɣe, ne nɖe sɔ, ɔwiɔ ne, anɔmi ɔbiɛ me, ɣɛɛ kiniɔ ne, ka loto lonya ara.” ");
INSERT INTO akp_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ne makpakpa mamɔ ɔkarɛ wũ sɔ, “Be iɖe ɔbara-ɔ? Nda iɖe ɔbara fiɛ ɔsa-ɔ atsɛ inya?” ");
INSERT INTO akp_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ne ɔrɛrɛ̃ gɔmɔ to ɔtã ma mmuai sɔ, “Loɔɣere mi koko, ɣɛɛ misɛ̃ sɔ miito minɔ. Be ɔso si loledza mi iɣere? Ɛɛbɛrɛ mi wũ ɔbie mito sɔ miakpese ɔ̃ marasuãdze?” ");
INSERT INTO akp_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ne matia wũ maɣere sɔ, “Fɔ nɖe ɔ̃ rasuãdze. Bo ɣɛɛ ne, Mose marasuãdze boɖe. ");
INSERT INTO akp_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Boɣe sɔ Ɣaa ɔɖegu Mose ika, ɣɛɛ ɔrɛrɛ̃ gɔgbe ne, boiɣe nane ngbegɔ ɔbɔrɛ!” ");
INSERT INTO akp_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ne ɔrɛrɛ̃ gɔgbe to ɔtã ma mmuai sɔ, “Iba ɣaa sɔ miiɣe ngbegɔ ɔbɔrɛ, ɣɛɛ ɔ̃ lobusi me anɔmi ne! ");
INSERT INTO akp_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Boɣe sɔ Ɣaa iisɛ ɔkã makpibaradze atsue, ɣɛɛ mma nsɛ mawarɛ wũ fiɛ masɛ mabara ɔ̃ kuɖɔɛ ne, ɔsɛ ɔkã ma atsue. ");
INSERT INTO akp_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ita i kayiiso karɔ̃kasɛkɔ̃ ne, boinɔ bonɔ sɔ kuwɛ̃ ɔbusi ɔturi gɔ maɣe nɔbiɛdze anɔmi. ");
INSERT INTO akp_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ne ɔso si iiɖe Ɣaa kɔrɛ ɔbɔrɛ ne, ɔ̃ibawo ira nɛgbe igbã ɔbara.” ");
INSERT INTO akp_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ne makpakpa mamɔ ɔɣere wũ sɔ, “Fɔ gɔ maɣe i ikpi ame, makararã-ɔ i ikpi ame ne, fɔ loaba aate bo ara?” Ne masa wũ maɖi i ma ikuri ame ne. ");
INSERT INTO akp_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu ɔnɔ sɔ maɔsa nɔbiɛdze maɖi i ma ikuri ame, ne ɔso gɔ ɔnya wũ ne, ɔkarɛ wũ sɔ, “Afɔ Ɔturi Awune Ɔbi aɖe?” ");
INSERT INTO akp_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ne ɔrɛrɛ̃ ɔtã mmuai sɔ, “Tete, te me ɔnyiiɔ si loafɔ wũ loɖe.” ");
INSERT INTO akp_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu ɔɣere wũ sɔ, “Ɔɔnya wũ koko, ɔ̃ nto ɔɖegu-ɔ ika ne.” ");
INSERT INTO akp_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ɔluwɛ̃ ne, ɔrɛrɛ̃ ɔɣɛ sɔ, “Bosate, lofɔ loɖe!” Ne ɔpɛ agɛgɛ̃ i Yesu katɔ̃ ɔsɔrɛ wũ ne. ");
INSERT INTO akp_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu ɔɣɛ sɔ, “Loba kayiiso sɔ si loɣɛgu kã atɔ̃me sɔ mma loito manya ara si manya, fiɛ mma nto manya si madaasinya.” ");
INSERT INTO akp_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Gɔ ma Farisise mawɛ̃ ma mpia i mmɔ ɔnɔ nnɛ i Yesu ɔɣɛ ne, makarɛ wũ sɔ, “Be ato aɣɛ? Bo wũ manɔbiɛdze boɖe?” ");
INSERT INTO akp_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ne Yesu ɔɣere ma sɔ, “Si manɔbiɛdze miɖe ne, tee miiɖe makpibaradze, ɣɛɛ gɔ mi sɔ mito minya ara ne, ne ɔso miɖe ipɔ ne.” ");
INSERT INTO akp_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu ɔɣere ma sɔ, “Gbaã loto loɣere mi sɔ ngɔ loiki i kayogodɔ̃ ɔbo i isɛrɛyo ame, ɣɛɛ ɔya ɔkpã ɔbo i kame ne, yukukpe gu raninadze ɔɖe. ");
INSERT INTO akp_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ngɔ nsɛ ɔki i kayogodɔ̃ ɔbo i ɔkpã ame ne, ɔ̃ nɖe masɛrɛkɔdze ne. ");
INSERT INTO akp_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kayogodɔ̃ dzuɛ̃se sɛ ɔsese wũ kukui, masɛrɛ sɛ manɔ ɔ̃ silɔ si ɔto ɔkpere ɔ̃ masɛrɛ ayere fiɛ ɔ̃akɔ ma ɔbɔrɛgu. ");
INSERT INTO akp_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Fiɛ si ɔ̃ɔkɔ ɔ̃ masɛrɛ ɔɖi ne, ɔsɛ ɔɖe ma katɔ̃ fiɛ ka maasiai wũ, alasɔ maɣe ɔ̃ silɔ. ");
INSERT INTO akp_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Maibasiai ɔturi mama, ɣɛɛ maatere maɣɛ wũ alasɔ maiɣe ɔ̃ silɔ.” ");
INSERT INTO akp_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu ɔpɛ ma igbã nɛgbe, ɣɛɛ mainɔ nnɛ ɔɣere ma karɔ̃. ");
INSERT INTO akp_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ne ɔso Yesu ɔledza ma iɣere sɔ, “Gbaã loto loɣere mi sɔ mme nɖe kayogodɔ̃ lotã masɛrɛ. ");
INSERT INTO akp_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mma ɔɖuɖu loɖe me katɔ̃ maba ne, mayukukpe gu maraninadze maɖe ne ɔso masɛrɛ iikã ma atsue. ");
INSERT INTO akp_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mme nɖe kayogodɔ̃ fiɛ ɔbiara gɔ loki i wũ ame ɔbo i kame ne, ɔ̃ana iɖi. Ɔ̃abo ɔbɔrɛ fiɛ ɔ̃ana aɖera kaɖekɔ̃. ");
INSERT INTO akp_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Yukukpe ne, kayu gu ituriɖoe gu ara inina ɔso fiɛ ɔsɛ ɔba, ɣɛɛ mme ne, loba sɔ si maturi aana ngbã mɛ loyi. ");
INSERT INTO akp_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Mme nɖe masɛrɛkɔdze sɛɛ gɔ loabie sɔ ɔ̃akpi ala masɛrɛ iti. ");
INSERT INTO akp_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ɣɛɛ ngɔ masu sɔ ɔnyɔ masɛrɛ iso fiɛ iiɖe ɔ̃ mɔmɔ mare maɖe ne, si ɔnya ɔgidi to ɔba ne, ɔsɛ ɔrui ɔtere ɔnyua mabɔi. Ɔgidi aabo i masɛrɛ ndɛ̃ ɔmɔɛ̃ ma, ɔsamarã ma. ");
INSERT INTO akp_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Rabaradze gɔgbe aarui ɔtere alasɔ kuso ɔ̃afɔ, ne ɔso ɔ̃isu kuira i masɛrɛ iso. ");
INSERT INTO akp_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Mme nɖe masɛrɛkɔdze sɛɛ ne. Loɣe wũ mare, fiɛ ma wũ maɣe me lɛ ");
INSERT INTO akp_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","kumɛgɔ ame i Tete ɣe me fiɛ mme wũ loɣe wũ. Losu wũ ngbã lotã i masɛrɛ iti. ");
INSERT INTO akp_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Loba masɛrɛ mama ma loibɔrɛ i ɔkpã gɔgbe ame fiɛ ipia sɔ loakɔ ma lobɔ. Maanɔ wũ silɔ fiɛ ma ɔɖuɖu aakpese ikuri iwɛ̃ ku kɔdze ɔwɛ̃. ");
INSERT INTO akp_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Tete sɛ ɔɖɔɛ me alasɔ losu wũ ngbã lotã fiɛ loakpese lofɔ me ana. ");
INSERT INTO akp_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kuwɛ̃ iibawo wũ ngbã ɔfɔ i wũ kɔrɛ, ɣɛɛ mme mɔmɔ kuɖɔɛ ame losu me lotã. Loba ɔle sɔ loasu lotã fiɛ loba ɔle ana sɔ loakpese lofɔ me. Nnɛgbe i Tete ɔpia me sɔ lobara ne.” ");
INSERT INTO akp_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesu atɔ̃me wagbe ɔledza iɣɛɣɛso ibɔ i ma Yudase ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Gbodzoo i ma ndɛ̃ ɔɣɛ sɔ, “Siwarã lalaa pia i ɔ̃ ame. Ɔto ɔlala, ne ɔso midaakã wũ atsue.” ");
INSERT INTO akp_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ɣɛɛ mamama ana ɔɣɛ sɔ, “Ngɔ ame i siwarã lalaa pia iibawo ika ɔɖe kumɛgɔgbe! Siwarã lalaa iibawo nɔbiɛdze anɔmi ɔbusi.” ");
INSERT INTO akp_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ɔyu ɔwi ne, ma Yudase ɔɖe Ɣaa Isɔrɛyo Isekelera iyi i Yerusalem. ");
INSERT INTO akp_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Gɔ Yesu sɛ ɔki i Salomo kakpataku ame i Isɔrɛyo ame ne, ");
INSERT INTO akp_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ma Yudase ɔba maaki malɔ wũ makarɛ wũ sɔ, “Ku mme ɔwi aaɣere bo ɔnukuare? Si fɔ nɖe Kristo ne, ɣere bo ɖi.” ");
INSERT INTO akp_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ne Yesu ɔɣere ma sɔ, “Loɔɣere mi koko, ɣɛɛ miito mifɔ me miɖe. Ara wa loto lobara i wũ Ɔse iyere ame nto aɖe ika i wũ iso. ");
INSERT INTO akp_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ɣɛɛ miito mifɔ me miɖe, alasɔ iiɖe wũ masɛrɛ miɖe. ");
INSERT INTO akp_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Wũ masɛrɛ sɛ makã me atsue, loɣe ma, fiɛ masɛ masiai me. ");
INSERT INTO akp_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nsɛ lotã ma ngbã mɛ loibaro fiɛ maibawɔ. Kuwɛ̃ iibawo ma ɔpɛ ɔfɔ i wũ nrɔɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tete gɔ losu ma ɔtã me ne, ɔmɔ ɔɖo ɔturi biara, ne ɔso kuwɛ̃ iibawo ma ɔpɛ ɔfɔ i ɔ̃ nrɔɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Bo gu Tete ne, mawɛ̃ boɖe.” ");
INSERT INTO akp_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ne ma Yudase ɔledza ata imala sɔ si mapɛ wũ ne. ");
INSERT INTO akp_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu ɔkarɛ ma sɔ, “Loɔbara ara sɛɛ gbodzoo wa i Tete ɔpia me sɔ lobara i mi ndɛ̃. Wã ndɛ̃ imele ɔso mito miba miapɛ me ata?” ");
INSERT INTO akp_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Matã wũ mmuai sɔ, “Boito bobie sɔ boapɛ-ɔ ata ala ara sɛɛ wa abara ɔso, ɣɛɛ imusuora nɛ aɣɛ ɔso! Ɔturi awune kere aɖe, ɣɛɛ asu so ato akateragu Ɣaa!” ");
INSERT INTO akp_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ne Yesu ɔɣere ma sɔ, “Matsɛrɛ mapia i Ɔko Sekelea ame sɔ Ɣaa ɔɣɛ sɔ, ‘Mi se lɛ Ɣaa.’ ");
INSERT INTO akp_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Si Ɣaa ɔkpere mma ɔso i ɔ̃ itɔ̃me ɔba sɔ mase lɛ Ɣaa, fiɛ nnɛ matsɛrɛ masɛ i Ɔko Sekelea ame ne, maibawo ne ɔfinikira ne, ");
INSERT INTO akp_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ɔɣere mito me sɔ mme gɔ i Ɣaa ɔɖi ɔsese kayiiso ne, loɣɛ imusuora sɔ loɣɛ sɔ Ɣaa Ɔbi loɖe? ");
INSERT INTO akp_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Si loito lobara Tete karabara ne, iyɔ midaafɔ me miɖe. ");
INSERT INTO akp_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ɣɛɛ si loto lobara Tete karabara ne, si miifɔ me miɖe kɔra ne, mifɔ wũ karabara miɖe. Ne loatã mitsue, fiɛ mianɔ karɔ̃ sɔ Tete pia i wũ ame fiɛ mme wũ lopia i Tete ame ne.” ");
INSERT INTO akp_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ngbe ana ne, mabie sɔ si mamɔɛ̃ Yesu, ɣɛɛ ɔbɔrɛ ma ndɛ̃ ɔwi. ");
INSERT INTO akp_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ɔkpese ɔsɛ ɔ̃awara Yordan ɔwore ɔkɛlɛ ngbegɔ i Yohanes ɔpie maturi Ɣaa ndu ku ɔwi gɔ lofe, ne ka ɔwe i mmɔ ne. ");
INSERT INTO akp_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Maturi gbodzoo ɔba ɔ̃ kɔrɛ maba maaɣɛ sɔ, “Yohanes iibara awawãra, ɣɛɛ ara wa ɔɖuɖu ɔɣɛ i ɔrɛrɛ̃ gɔgbe iso ne, gbaã iɖe.” ");
INSERT INTO akp_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ne ɔso maturi gbodzoo ɔfɔ Yesu maɖe i mmɔ. ");
INSERT INTO akp_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ɔrɛrɛ̃ ɔwɛ̃ gɔ marɔ sɔ Lazaro fiɛ ɔbɔrɛ i Betania ɔmagɛ̃ ame ɔmɔɛ̃ ɔnyɛ. Ɔmagɛ̃ gɔgbe nɖe Maria gu ɔ̃ ɔnyiibi Marta mɛrɛ̃ aɖe ne. ");
INSERT INTO akp_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria gɔgbe ɔɖe loba ɔ̃afedza nnɔĩ kɔrɔ̃kɔrɔ̃a ɔfere i Bosate Yesu ngba fiɛ ɔsu ɔ̃ iti siwɛrɛ̃ ɔnukutu ne. Ɔ̃ ɔnyiibi nɖe Lazaro gɔ nto ɔmɔɛ̃ ɔnyɛ i ngbe ne. ");
INSERT INTO akp_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lazaro manyiiko ɔpia Yesu ɔturi sɔ, “Bosate, fɔ ɔlaa gɔ abua asɛ aɖɔɛ to ɔnyɛ.” ");
INSERT INTO akp_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Gɔ Yesu ɔnɔ kanya gagbe ne, ɔɣɛ sɔ, “Ɔnyɛ gɔgbe iiɖe ɔkpinyɛ, ɣɛɛ ɔɖe ira nɛ loakɔlɛ Ɣaa iyere kato, fiɛ iaki i ne iso ana ne, maakɔlɛ Ɣaa Ɔbi ɔ̃ wũ kato.” ");
INSERT INTO akp_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu ɔbua ɔsɛ ɔɖɔɛ Lazaro gu ɔ̃ manyiiko kukaakɔ. ");
INSERT INTO akp_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ɣɛɛ gɔ ɔnɔ Lazaro ɔnyɛ ne, ɔwe i ngbegɔ ɔpia akpɛnɛ anyɔ ɔbua. ");
INSERT INTO akp_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ne ɔɣere ɔ̃ marasuãdze sɔ, “Mitã bokpese bokɛlɛ Yudea.” ");
INSERT INTO akp_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ne ɔ̃ marasuãdze ɔkarɛ wũ sɔ, “Ratedze, iifɔ ɔwi gɔ ma Yudase ɔbie sɔ si mapɛ-ɔ ata, ne ato abie sɔ boakpese bokɛlɛ mmɔ ana?” ");
INSERT INTO akp_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu ɔtã ma mmuai sɔ, “Iɖɔwũ iweo-inyɔ iɖe mpia i ikpɛnɛ ame. Ne ɔso ɔbiara gɔ nsɛ i ikpɛnɛ ikpawaĩ ame ne, ɔ̃isɛ ɔtura, alasɔ ɔsɛ ɔnya kayiiso gagbe ikpawaĩ. ");
INSERT INTO akp_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ɣɛɛ si ɔsɛ i kasɛ̃ ame ne, ɔsɛ ɔtura, alasɔ ɔna ikpawaĩ.” ");
INSERT INTO akp_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Gɔ Yesu ɔɣere ma ngbɔ ne, ɔɣɛ ana sɔ, “Bo ɔlaa Lazaro ɔɔrɛ sirɛ, ɣɛɛ losɛ loatara wũ.” ");
INSERT INTO akp_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ne marasuãdze ɔɣere Bosate sɔ, “Si sirɛ ɔɔsu wũ ne, iyɔ ɔto ɔ̃asarɛ.” ");
INSERT INTO akp_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ɔɣɛ i Yesu to sɔ Lazaro ɔɔkpi, ɣɛɛ marasuãdze ɔbu sɔ sirɛ gbaã ɔto ɔɣɛ ala. ");
INSERT INTO akp_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ne ɔso ɔɣere ma ɔɖi sɔ, “Lazaro ɔɔkpi. ");
INSERT INTO akp_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ɣɛɛ mi ɔso ne, iba me isoɣɔ sɔ lona i ɔ̃ kɔrɛ si miafɔ miɖe. Mitã bokɛlɛ ɔ̃ kɔrɛ.” ");
INSERT INTO akp_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ne Toma gɔ marɔ sɔ Inyɔɔbi ɔɣere marasuãdze sɔ, “Mitã bosiai Ratedze si bosɛ boakpigu wũ!” ");
INSERT INTO akp_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Gɔ Yesu ɔsɛ ɔ̃abo mmɔ ne, ɔnya sɔ iɔfɔ akpɛnɛ ana gɔ mabiara Lazaro. ");
INSERT INTO akp_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ita i Yerusalem iba Betania ne, iaɖe agu anyɔ kere, ");
INSERT INTO akp_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ne ɔso ma Yudase gbodzoo ɔba sɔ si maba maatã Maria gu Marta ndzo i ma ɔnyiete kukpi iso. ");
INSERT INTO akp_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Gɔ Marta ɔnɔ sɔ Yesu ka ɔba ne, ɔta ɔkɛlɛ sɔ ɔ̃asarɛgu wũ, ɣɛɛ Maria ɔwe i iyo ame. ");
INSERT INTO akp_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mmɔ i Marta to ɔɣere Yesu sɔ, “Bosate, si ɔpia apia ne, tee bo ɔnyiete iikpi! ");
INSERT INTO akp_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ɣɛɛ kiniɔ kɔra ne, loɣe sɔ Ɣaa to ɔ̃abara ira biara nɛ akarɛ wũ.” ");
INSERT INTO akp_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ne Yesu ɔɣere wũ sɔ, “Fɔ ɔnyiete to ɔ̃ata ɔwe ngbã.” ");
INSERT INTO akp_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ne Marta to ɔɣɛ sɔ, “Loɣe sɔ ɔto ɔ̃ata ɔwe ngbã ku Iyi Tsɔra nɛ i makpise aata iso.” ");
INSERT INTO akp_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ne Yesu ɔɣere wũ sɔ, “Mme nɖe makpise ita gu ngbã ne. Ngɔ lofɔ me ɔɖe to ɔ̃asɛ ngbã atoa sɔ ɔkpi, ");
INSERT INTO akp_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","fiɛ ɔbiara gɔ nsi ngbã fiɛ ɔfɔ me ɔɖe ne, ɔ̃ibakpi. Afɔ nnɛgbe aɖe?” ");
INSERT INTO akp_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ɔtã mmuai sɔ, “Aĩ, Bosate. Lofɔ loɖe sɔ fɔ nɖe Kristo, Ɣaa Ɔbi gɔ maɣɛ masɛ sɔ ɔ̃aba kayiiso.” ");
INSERT INTO akp_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Gɔ Marta ɔɣɛ ngbɔ ne, ɔkpese ɔkɛlɛ ɔsɛ ɔ̃akpere ɔ̃ ɔnyiibi Maria ɔɣedza i kuruɛ ɔɣere wũ sɔ, “Ratedze ɔba ɔto ɔkarɛ-ɔ iti.” ");
INSERT INTO akp_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Gɔ Maria ɔnɔ ngbɔ ne, ɔta ɔluwɛ̃ sɔ ɔ̃asarɛgu wũ. ");
INSERT INTO akp_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ɔwi gɔgbe ame ɔɖuɖu ne, Yesu iibo ɔmagɛ̃ ame, ɔɣɛ i ngbegɔ i Marta ɔba ɔ̃asarɛgu wũ. ");
INSERT INTO akp_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ma Yudase ma mpia i iyo mato matã Maria katetere ɔta masiai wũ gɔ manya sɔ ɔpɛ siwa ɔbɔrɛ i iyo. Mabu sɔ siainyɔ ne, ikpibiɔ katɔ̃ ka ɔsɛ ɔ̃abiɛ kaku. ");
INSERT INTO akp_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ɔwi gɔ Maria ɔbo ngbegɔ i Yesu ɣɛ fiɛ ɔnya wũ ne, ɔpɛ agɛgɛ̃ i ɔ̃ katɔ̃ ɔɣɛ sɔ, “Si ɔpia apia i ngbe ne, tee wũ ɔnyiete iikpi.” ");
INSERT INTO akp_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Gɔ Yesu ɔnya kumɛgɔ i Maria to ɔbiɛ gu kumɛgɔ i ma Yudase ma loba maaya wũ ana to mabiɛ ne, imararã Yesu fiɛ ikpɛ̃ wũ nnya. ");
INSERT INTO akp_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ne ɔkarɛ ma sɔ, “Lɛ mibiara wũ?” Matã wũ mmuai sɔ, “Bosate, ba nyɔ.” ");
INSERT INTO akp_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Mmɔ ne, Yesu ɔbiɛ. ");
INSERT INTO akp_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ne ma Yudase to maɣɛ sɔ, “Minyɔ kumɛgɔ ɔɖɔɛ wũ!” ");
INSERT INTO akp_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ɣɛɛ mawɛ̃ ana ɔɣɛ sɔ, “Gɔ ɔwo nɔbiɛdze anɔmi ɔbusi ne, ɔ̃ibawo ɔtã sɔ Lazaro iibakpi?” ");
INSERT INTO akp_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu ɔtɔrɛ̃ i ɔ̃ ame, ɔsɛ ɔkɛlɛ ikpibiɔ nɛ mpia i ɔkpolo ame fiɛ mali ita masɛ̃ kanya kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ne ɔɣere ma sɔ, “Mili ita miɖi i ɔkpolo kanya.” Ne Lazaro ɔnyiiko gɔ nɖe Marta ɔɣere Yesu sɔ, “Ɔfiã ka ɔpia ala iɔfɔ ayi ana gɔ mabiara wũ!” ");
INSERT INTO akp_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu ɔɣere Marta sɔ, “Loiɣere-ɔ sɔ si afɔ me aɖe ne, ato aanya Ɣaa ɔle?” ");
INSERT INTO akp_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Gɔ mali ita maɖi ne, Yesu ɔnyɔ kato ɔɣɛ sɔ, “Tete, nto lopɛ-ɔ siba, sɔ asɛ akã me atsue. ");
INSERT INTO akp_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Loɣe sɔ asɛ akã me atsue ɔwi biara, ɣɛɛ mma nɣɛ i ngbe ɔso loto loɣɛ si maafɔ maɖe sɔ fɔ lopia me katɔ̃me.” ");
INSERT INTO akp_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Gɔ ɔɣɛ nnɛgbe ɔro ne, ɔla kulu teteree sɔ, “Lazaro, ta bɔrɛ ba!” ");
INSERT INTO akp_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ɔluwɛ̃ ɔturi gɔ lokpi ɔta ɔbɔrɛ. Ɔkati gɔ mamini wũ nrɔɔ̃ gu ngba mini wũ iso, fiɛ ngɔ ana nyi wũ i katɔ̃ fiɛ ɔta ɔbɔrɛ ɔba. Ne Yesu ɔɣere ma sɔ, “Mikurisi wũ ara iso si ɔkɛlɛ.” ");
INSERT INTO akp_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Maturi gbodzoo ma loba maaya Maria ɔnya ara wa i Yesu ɔbara, ne ɔso mafɔ wũ maɖe. ");
INSERT INTO akp_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ɣɛɛ mawɛ̃ ɔrui makɛlɛ ma Farisise kɔrɛ masɛ maaɣere ma nnɛ i Yesu ɔbara. ");
INSERT INTO akp_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ne ɔso ma Farisise gu masɔrɛdze makpakpa ɔsarɛgu matɔ̃meɣɛdze makarɛ sɔ, “Be boabara? Minyɔ awawãra gbodzoo wa i ɔrɛrɛ̃ gɔgbe to ɔbara! ");
INSERT INTO akp_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Si botã ɔkɛlɛgu i katɔ̃ kumɛgɔgbe ne, maturi ɔɖuɖu to maafɔ wũ maɖe, iyɔ ma Romase abã to maaba maabiɛ bo Isɔrɛyo gu bo karɔ̃!” ");
INSERT INTO akp_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ma ndɛ̃ ɔwɛ̃ gɔ nɖe Kayafa fiɛ ɔ̃ nɖe sɔrɛdzekpakpa pelepele ku ikɔ nɛmɔ ɔɣɛ sɔ, “Mibo ndu miɣede! ");
INSERT INTO akp_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Miiɣe sɔ ilɛ sɔ miatã ɔturi ɔwɛ̃ ɔkpi i kaɖe iti iɖo sɔ kaɖe ɔɖuɖu aawɔ?” ");
INSERT INTO akp_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Gbaã ne, iiɖe ɔ̃ mɔmɔ adzuni aɖe ɔɣɛ ngbe, ɣɛɛ lɛ sɔrɛdzekpakpa pelepele ku ikɔ nɛmɔ ne, itɔ̃me iɖe ɔɣɛ ɔsɛ sɔ Yesu to ɔba ɔ̃akpi i ma Yudase iti. ");
INSERT INTO akp_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Fiɛ iiɖe ma Yudase ɔnɔwɛ̃ kere iti, ɣɛɛ si ɔ̃asa Ɣaa mabi ma ɔɖuɖu loki makã kayiiso kanya. ");
INSERT INTO akp_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ita i iyi nɛmɔ iso ne, ma Yudase makpakpa ɔsɛ iti ame kumɛgɔ maabara fiɛ maaɖoe Yesu. ");
INSERT INTO akp_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ne ɔso Yesu iisisɛ ɔsɛ kpawee i Yudea karɔ̃ iso, ɣɛɛ ɔrui ɔkɛlɛ fafuĩ ame i ɔmagɛ̃ gɔ marɔ sɔ Efrayim ame ku ɔ̃ marasuãdze masɛ maawe i mmɔ. ");
INSERT INTO akp_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ma Yudase Kukpi Ɔtakuwara Bo Iyi ɔɔbore ibo, ne ɔso maturi gbodzoo ɔbɔrɛ i abuiti ame maba Yerusalem si maba maasekelera so matã iyi iɖe. ");
INSERT INTO akp_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Gɔ masakanya i Ɣaa Isɔrɛyo ame ne, mala maɔnyɔnyɔ Yesu, ne ɔso mato makarɛ so sɔ, “Nda minya? Ɔ̃ito ɔ̃aba iyi kaɖekɔ̃ lo?” ");
INSERT INTO akp_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ɣɛɛ masɔrɛdze makpakpa gu ma Farisise ɔpia maturi sɔ si ɔrere ɣe ngbegɔ Yesu pia ne, ɔte ma si maakɛlɛ masɛ maamɔɛ̃ wũ. ");
INSERT INTO akp_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Gɔ iɔkuti ayi akuɔ fiɛ maaɖe Kukpi Ɔtakuwara Bo Iyi ne, Yesu ɔkɛlɛ Betania i Lazaro gɔ ɔtara ɔbɔrɛgu i makpise ame aɖe. ");
INSERT INTO akp_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mawa kutsuɛ aɖera i mmɔ matã wũ. Marta loɖe ngɔ losia ma aɖera i ɔpɔrɔ̃ iso fiɛ Lazaro ɔ̃ wũ ɔwe i mma losɛ i ɔpɔrɔ̃ iti ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maria ɔfedza nnɔĩ kɔrɔ̃kɔrɔ̃ miwɛ̃ mɛ lofɔ kuɣa gbaã ibui ɔfere Yesu i ngba fiɛ ka ɔsu ɔ̃ iti siwɛrɛ̃ ɔnukutu me. Nnɔĩ ɔfiã ɔfɔ iyo ame ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ɔ̃ marasuãdze ɔwɛ̃ gɔ nɖe Yuda Iskariot gɔ loaɖi Yesu ɔtã ɔɣɛ sɔ, ");
INSERT INTO akp_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Be ɔso fiɛ maibarɔdɛ̃ nnɔĩ mɛgbe sikãfudza abi alafa atɛ masu sikã matã mawɛrɛba?” ");
INSERT INTO akp_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ɔɣɛ nnɛgbe iiɖe sɔ mawɛrɛba ara nsɛ aɖo wũ kayiri, ɣɛɛ yukukpe ɔɖe ɔso. Ɔ̃ nto sikã kakotoi, ne ɔso ɔsɛ ɔyu nnɛ mpia i kame. ");
INSERT INTO akp_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ɣɛɛ Yesu ɔɣere ma sɔ, “Minyua wũ, mitã wũ ɔledza me ɔtã wũ ibiarayi. ");
INSERT INTO akp_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mawɛrɛba to maawe i mi kɔrɛ ɔwi biara, ɣɛɛ mme ne, loito loawe i mi kɔrɛ ɔwi biara.” ");
INSERT INTO akp_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ma Yudase gbodzoo ɔnɔ sɔ Yesu pia i Betania, ne ɔso masiai wũ kama maba mmɔ. Iiɖe Yesu ɔnɔwɛ̃ ɔso fiɛ maba, ɣɛɛ si maba maanya Lazaro gɔ ɔtara ɔbɔrɛgu i makpise ame ana. ");
INSERT INTO akp_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ne ɔso masɔrɛdze makpakpa ɔsɛ iti ame sɔ maaɖoe Lazaro ɔ̃ wũ, ");
INSERT INTO akp_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","alasɔ ɔ̃ ɔso i ma Yudase gbodzoo to makpese ma i kama mafɔ Yesu maɖe. ");
INSERT INTO akp_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Gɔ kaɖe ɔsɛ̃ ne, maturi gbodzoo ma loba Kukpi Ɔtakuwara Bo Iyi kaɖekɔ̃ ɔnɔ sɔ Yesu to ɔba Yerusalem. ");
INSERT INTO akp_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ne ɔso masu sikɛ mato fiɛ mabɔrɛ sɔ maasarɛgu wũ. Mato mafa kayiɖu sɔ, “Hosiana! Maale ngɔ nto ɔba i Bosate iyere ame! Maale Israel Igara!” ");
INSERT INTO akp_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu ɔna ɔfirimu ɔsi i iso lɛ kumɛgɔ i Ɔko Sekelea ɔɣɛ sɔ, ");
INSERT INTO akp_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Zion Ɔmagɛ̃, daanigã! Ɔɔnya fɔ Igara nto ɔba, ɔsi i ɔfirimu ibi iso!” ");
INSERT INTO akp_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yesu marasuãdze iinɔ ira nɛgbe karɔ̃ ku ɔwi gɔmɔ ame, ɣɛɛ ɔwi gɔ ɔ̃ɔta ɔbɔrɛ i makpise ame ɔkɛlɛ ikpawaĩ ame ne, manyigi sɔ Ɔko Sekelea ɔɣɛ ngbɔ, fiɛ mabara ngbɔ matã wũ ana. ");
INSERT INTO akp_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mma lowe i Yesu kɔrɛ ku ɔwi gɔ ɔkpere Lazaro ɔbɔrɛgu i ikpibiɔ ame fiɛ ɔtara wũ ɔbɔrɛgu i makpise ame ɔsɛ maaɣɛ nnɛ loba. ");
INSERT INTO akp_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nnɛgbe ɔso i maturi gbodzoo mamɔ ɔsarɛgu wũ ne, alasɔ manɔ iwawãra nɛ ɔbara i ngbe. ");
INSERT INTO akp_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ne ma Farisise to maɣere so sɔ, “Minya sɔ boito bona kayakpa ɖuɖuuɖu? Kayiiso maturi ɔɖuɖu ka masiai wũ!” ");
INSERT INTO akp_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ma Helase mawɛ̃ pia i mma loba masɔrɛ Ɣaa i iyi kaɖekɔ̃ i Yerusalem ame. ");
INSERT INTO akp_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Maba maaɣere Filipo gɔ lobɔrɛ i Betsaida i Galilea sɔ, “Tete, boto bobie sɔ boanya Yesu.” ");
INSERT INTO akp_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo ɔsɛ ɔ̃aɣere Andrea fiɛ ma inyɔɔ ka masɛ maaɣere Yesu. ");
INSERT INTO akp_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu ɔɣere ma sɔ, “Ɔwi ɔɔɣo gɔ maapia Ɔturi Awune Ɔbi kuwarɛ siare. ");
INSERT INTO akp_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Gbaã loto loɣere mi sɔ si ititabi iibo i karɔ̃ ame iburi ne, ne ɔnɔwɛ̃ saã kere iɖe mpia, ɣɛɛ si iburi ne, isɛ ipia abi gbodzoo. ");
INSERT INTO akp_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ngɔ nsɛ ɔɖɔɛ ɔ̃ ngbã ne, ɔto ɔ̃ayura me, ɣɛɛ ngɔ lotsiri ɔ̃ ngbã i kayi gagbe ame ne, ɔkɔla me ɔtã ngbã mɛ loibaro minya. ");
INSERT INTO akp_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ɔbiara gɔ nto ɔbie sɔ ɔ̃asumu me ne, ɔsiai me si wũ maɖabo aawegu me i ngbegɔ lopia. Tete to ɔ̃awarɛ ɔbiara gɔ nsɛ ɔsumu me. ");
INSERT INTO akp_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Kiniɔ ne, loto lomararã so i wũ ɔtu ame, fiɛ loiɣe nnɛ loaɣɛ. Ɔɣɛ si loɣɛ sɔ, ‘Tete, ɖi me bɔrɛgu i inyɛwe ɔwi gɔgbe ame’? Ooɣo, ala ɔwi gɔgbe ɔso fiɛ loba kayi ne. ");
INSERT INTO akp_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tete, kɔlɛ fɔ iyere kato!” Ne silɔ ɔɖe ika sibɔrɛgu i kato sɔ, “Loɔkɔlɛ wũ iyere kato koko, fiɛ loto loaledza ibara ana.” ");
INSERT INTO akp_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Maturi gbodzoo ma nɣɛ i ɔ̃ kɔrɛ ɔnɔ silɔ, ne ma mawɛ̃ to maɣɛ sɔ kado loɖu. Mawɛ̃ ana sɔ, “Ɣaa kpabo loɖegu wũ ika.” ");
INSERT INTO akp_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ne Yesu ɔɣere ma sɔ, “Iiɖe wũ ɔso fiɛ silɔ ɔɖe ika, ɣɛɛ mi ɔso. ");
INSERT INTO akp_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","“Ɔwi ɔɔɣo gɔ maaɣɛgu kayiiso maturi atɔ̃me, fiɛ maaturi ngɔ nto ɔɖe kayiiso iso iyara. ");
INSERT INTO akp_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Fiɛ si maɔkɔlɛ me kato i kayiiso ne, loaboregu maturi ɔɖuɖu lopia so.” ");
INSERT INTO akp_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu ɔɣɛ nnɛgbe ɔte kukpi gɔ igbã ɔ̃akpi. ");
INSERT INTO akp_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ne maturi gbodzoo mamɔ to maɣere wũ sɔ, “I bo Ɔko Sekelea ame ne, matsɛrɛ mapia sɔ Kristo iibakpi ɔnya, ne ɔso be ɔso fiɛ ato aɣɛ sɔ maakɔlɛ Ɔturi Awune Ɔbi kato? Nna nɖe Ɔturi Awune Ɔbi gɔgbe?” ");
INSERT INTO akp_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ne Yesu ɔɣere ma sɔ, “Ɔkaniɛ to ɔ̃awe i mi kɔrɛ ɔwi kɛkɛĩ, ne ɔso misɛ i ɔkaniɛ ame si idududu iibafu mi iso. Alasɔ ngɔ nsɛ ɔsɛ i idududu ame iisɛ ɔtsue ngbegɔ ɔsɛ. ");
INSERT INTO akp_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ne ɔso mifɔ ɔkaniɛ miɖe gɔ ɔpia i mi kɔrɛ si miaɖe ikpawaĩ ame maturi.” Gɔ Yesu ɔɣere ma ara wagbe ɔro ne, ɔrui ɔsɛ ɔ̃akɔla so. ");
INSERT INTO akp_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Atoa sɔ Yesu ɔbara awawãra wagbe ɔɖuɖu i ma ndɛ̃ ne, maifɔ wũ maɖe. ");
INSERT INTO akp_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ɣɛɛ iba ngbɔ sɔ nnɛ i Ɣaa Kanyaɖidze Yesaya ɔtsɛrɛ ɔsɛ aaba i ne ame sɔ, “Bosate, nna lofɔ bo itɔ̃me nɛ boɣɛ ɔɖe? Fiɛ mabe ndɛ̃ iɖe ɔɖi ɔ̃ ɔle ɔte?” ");
INSERT INTO akp_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ne ɔso maiwo ɔfɔ ɔɖe alasɔ Yesaya ɔtsɛrɛ ana sɔ, ");
INSERT INTO akp_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ɣaa ɔbiɛ ma anɔmi fiɛ ɔtã maba atsue ɔle. Sɔ ma anɔmi iibanya, fiɛ ma adzuni ana iibanɔ ara karɔ̃, ‘Fiɛ maafiniki maba wũ kɔrɛ fiɛ loasa ma.’ Ngbɔ i Ɣaa ɔɣɛ ne.” ");
INSERT INTO akp_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesaya ɔɣɛ ngbɔ alasɔ ɔnya Yesu ikpawaĩ fiɛ ɔɖe ika i ɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Atoa sɔ ise kumɛgɔgbe ne, ma Yudase makpakpa gbodzoo ɔfɔ Yesu maɖe, ɣɛɛ gɔ mato manigã ma Farisise ɔso ne, maisɛ maɖe ika i ne iso kpawee sɔ maaba maasa ma maɖi i kasarɛkɔ̃. ");
INSERT INTO akp_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Alasɔ masɛ maɖɔɛ maturi ile maɖo Ɣaa ile. ");
INSERT INTO akp_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu ɔla kulu teteree ɔɣɛ sɔ, “Ngɔ lofɔ me ɔɖe ne, iiɖe wũ ɔnɔwɛ̃ iɖe ɔfɔ, ɣɛɛ bo gu ngɔ lopia me katɔ̃me iɖe ɔfɔ. ");
INSERT INTO akp_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ɔbiara gɔ lonya me ana ne, ɔ̃ɔnya ngɔ lopia me katɔ̃me. ");
INSERT INTO akp_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Loba kayi ame lɛ ikpawaĩ awe, sɔ ɔbiara gɔ lofɔ me ɔɖe iisibawe i idududu ame. ");
INSERT INTO akp_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Si ɔrere ɔnɔ wũ itɔ̃me fiɛ ɔ̃ibara i ne iso ne, loibaɣɛgu wũ atɔ̃me. Loiba loɣɛgu kayiiso atɔ̃me, ɣɛɛ loba lotã kã iɖi. ");
INSERT INTO akp_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ngɔ losɛ̃ me fiɛ ɔ̃ifɔ wũ itɔ̃me ne, ɔba ngɔ loaɣɛgu wũ atɔ̃me. Wũ ara wa lote loaɣɛgu wũ atɔ̃me ku iyi tsɔra. ");
INSERT INTO akp_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Alasɔ loiɖe ika i mme mɔmɔ ɔle ame, ɣɛɛ Tete gɔ lopia me katɔ̃me lotã me ɔle sɔ loɖe ika loɣɛ nnɛ loaɣɛ. ");
INSERT INTO akp_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Loɣe sɔ ɔ̃ itɔ̃me sɛ itã ngbã mɛ nna katui. Ne ɔso nnɛ losɛ loɣɛ ne, ne nɖe nnɛ i Tete ɔɣere me sɔ loɣɛ ne.” ");
INSERT INTO akp_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Iyi nɛ i kaɖe aasɛ̃ fiɛ maaɖe Kukpi Ɔtakuwara Bo Iyi ne, Yesu ka ɔɣe sɔ ɔ̃ ɔwi ɔɔɣo gɔ ɔ̃abɔrɛ i kayi gagbe iso ɔkɛlɛ ɔ̃ Ɔse kɔrɛ. Ɔɖɔɛ mma nɖe ɔ̃ mare i kayiiso fiɛ ɔɖɔɛ ma ɔsɛ ɔ̃ɔbo ta kawirikɔ̃. ");
INSERT INTO akp_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kutsuɛ gɔmɔ gɔ Yesu gu ɔ̃ marasuãdze si mato maɖe ara ne, Ɔbosam ɔɔsu adzuni lalaa ɔpia i Yuda gɔ nɖe Simon Iskariot ɔbi ame koko sɔ ɔɖi Yesu ɔtã. ");
INSERT INTO akp_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu ɣe sɔ ɔ̃ Ɔse ɔsu ɔle ɔɖuɖu ɔtã wũ, ɔɣe sɔ Ɣaa kɔrɛ ɔbɔrɛ fiɛ Ɔ̃ kɔrɛ ɔto ɔkpese ɔkɛlɛ. ");
INSERT INTO akp_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ne ɔso ɔta i ɔpɔrɔ̃ katɔ̃, ɔɖi ɔ̃ awu tagbaraa wa ɔpia ɔsɛ, fiɛ ka ɔsu ɔsa ɔkpasa. ");
INSERT INTO akp_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ne ɔka ndu ɔfere i kapoi ame, ne ɔtsɛ ma ngba ifore, isu ɔsa gɔ ɔkpasa iɖiɖi ma ndu i ngba. ");
INSERT INTO akp_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Gɔ Yesu ɔbo Simon Petro kɔrɛ ne, Petro ɔkarɛ wũ sɔ, “Bosate, ɔbie ato sɔ aba aafore me ngba?” ");
INSERT INTO akp_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ne Yesu ɔɣere wũ sɔ, “Kiniɔ ne, ainɔ nnɛ loto lobara karɔ̃, ɣɛɛ ɔwi kama ne, ato aanɔ karɔ̃.” ");
INSERT INTO akp_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petro ɔɖi kanya sɔ, “Ooɣo! Aibafore me ngba anya.” Yesu ɔɣere wũ sɔ, “Si aitã lofore-ɔ ngba ne, tsue sɔ ana kaɖekɔ̃ i wũ ame.” ");
INSERT INTO akp_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ne Simon Petro ɔɣɛ sɔ, “Bosate, si ngbɔ ne, iyɔ daafore me ngba kere, ɣɛɛ fore me nrɔɔ̃ gu iti ana!” ");
INSERT INTO akp_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu ɔɣere wũ sɔ, “Ngɔ loɔpie ndu ɔɔsekele koko, ne ɔso ɔ̃isinya itupie iɖo ngba ifore. Mi ɔɖuɖu ɔɔsekele, iɖo ɔwɛ̃.” ");
INSERT INTO akp_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu ɔɣɛ ngbɔ alasɔ ka ɔɣe ngɔ loaɖi wũ ɔtã. Ne ɔso ɔɣɛ sɔ, “Mi ɔɖuɖu ɔɔsekele iɖo ɔwɛ̃” ne. ");
INSERT INTO akp_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Gɔ Yesu ɔɔfore ma ngba ɔro ne, ɔkpesegu ɔ̃ awu ɔpia, fiɛ ka ɔsɛ ɔ̃asɛ i ɔ̃ kasɛkɔ̃ i ɔpɔrɔ̃ iti. Ne ɔkarɛ ɔ̃ masiaidze sɔ, “Minɔ nnɛ lobara ngbe karɔ̃? ");
INSERT INTO akp_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Misɛ mikpere me sɔ Ratedze gu Bosate, ilɛ ngbɔ, alasɔ ngbɔ loɖe ne. ");
INSERT INTO akp_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mme gɔ mme nɖe mi Sate gu Ratedze ne, lofore mi ngba. Ne ɔso mi wũ mifore mi malaa ngba. ");
INSERT INTO akp_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Loɔsɛ ikparĩ lotã mi, ne ɔso mi wũ mibara nnɛ lobara lotã mi mitã so. ");
INSERT INTO akp_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Gbaã loto loɣere mi sɔ ɔɖabo iisɛ ɔɖo ɔ̃ ɔkɔse, fiɛ katɔ̃mesɛdze iisɛ ɔɖo ngɔ lopia wũ katɔ̃me. ");
INSERT INTO akp_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kiniɔ gɔ ka miɣe ɔnukuare gɔgbe ne, so aaɣɔ mi si misu ara wagbe mipia i kurabarara ame. ");
INSERT INTO akp_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Iiɖe mi ɔɖuɖu ɔso loto loɣɛ nnɛgbe, loɣe mma loɖi. Ɣɛɛ si itɔ̃me nɛ matsɛrɛ mapia i Ɔko Sekelea ame aaba i ne ame sɔ, ‘Bo gu ngɔ nto bopia kɔrɔ̃ i irɔi ame boɖe ara lota ɔya me iso.’ ");
INSERT INTO akp_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Loto loɣere mi nnɛgbe tɔtɔ fiɛ iaba, sɔ si iba ne, miatsue sɔ, ‘Mme nɖe ngɔ Loɖe.’ ");
INSERT INTO akp_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Gbaã loto loɣere mi sɔ ɔbiara gɔ lofɔ ngɔ mme lopia katɔ̃me ne, mme iɖe ɔfɔ. Fiɛ ɔbiara gɔ lofɔ me ne, ngɔ lopia me katɔ̃me iɖe ɔfɔ.” ");
INSERT INTO akp_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Gɔ Yesu ɔɣɛ ara wagbe ɔro ne, ɔmararã so ta ɔ̃ ɔtu ame. Ne ɔɣere ma ɔɖi sɔ, “Gbaã loto loɣere mi sɔ mi ndɛ̃ ɔwɛ̃ to ɔ̃aɖi me ɔtã.” ");
INSERT INTO akp_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Marasuãdze ɔkpɔkpɔtɔ pelepele mato manyɔ so i katɔ̃ sɔ ma nna ɔto. ");
INSERT INTO akp_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Rasuãdze gɔ i Yesu sɛ ɔɖɔɛ ɔɖo si ɔmatã wũ. ");
INSERT INTO akp_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ne Simon Petro ɔma wũ anɔmi sɔ, “Karɛ wũ sɔ nna ɔto ɔɣɛ ala.” ");
INSERT INTO akp_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ne rasuãdze gɔmɔ ɔbore ɔbo Yesu ɔkarɛ wũ sɔ, “Bosate, nna ɔɖe?” ");
INSERT INTO akp_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu ɔɣere wũ sɔ, “Ngɔ loakpɛti aɖera loti kutu losu lotã ne, ɔ̃ ɔɖe ne.” Ne ɔso Yesu ɔkpɛti aɖera, ɔti kutu fiɛ ka ɔsu ɔtã Yuda, Simon Iskariot ɔbi. ");
INSERT INTO akp_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ɔluwɛ̃ gɔ Yuda ɔfɔ aɖera ne, Satana ɔbo i ɔ̃ ame. Ne Yesu ɔɣere wũ sɔ, “Pɛ siwa si abara nnɛ ato abie sɔ abara.” ");
INSERT INTO akp_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mma nsi i ɔpɔrɔ̃ katɔ̃ kuwɛ̃ iinɔ nnɛ i Yesu ɔɣere Yuda karɔ̃. ");
INSERT INTO akp_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Gɔ Yuda kɔrɛ i sikã kakotoi se ɔso ne, marasuãdze mawɛ̃ ɔbu sɔ ɔɣere i Yesu to wũ sɔ ɔsɛ ɔ̃aɣa ara ɔtã iyi iɖe, ɣee ɔbie irere ɔtã mawɛrɛba. ");
INSERT INTO akp_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Gɔ Yuda ɔfɔ aɖera ne, ɔbɔrɛ i iyo ɔluwɛ̃. Kasɛ̃ ka iɖe. ");
INSERT INTO akp_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Gɔ Yuda ɔbɔrɛ i iyo kama ne, Yesu ɔɣɛ sɔ, “Kiniɔ ne, maɔɖi Ɔturi Awune Ɔbi ikpawaĩ mate, fiɛ iki i ɔ̃ iso ne, Ɣaa ikpawaĩ ana ɔɔte sekelee. ");
INSERT INTO akp_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Si makɔlɛ Ɣaa iyere kato iki Ɔbi iso ne, iyɔ Ɣaa to ɔ̃akɔlɛ Ɔbi iyere iki i ɔ̃ mɔmɔ iso ɔluwɛ̃. ");
INSERT INTO akp_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Wũ mabi, loisibawe i mi kɔrɛ ɔwi ɔdzoro. Mito miabie me, ɣɛɛ lɛ kumɛgɔ loɣere ma Yudase makpakpa ne, ‘Ngbegɔ losɛ ne, miito miawo mmɔ ɔba.’ ");
INSERT INTO akp_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Kiniɔ ne, mmara ɣɛtɛ loto lotã mi sɔ miɖɔɛ so. Lɛ kumɛgɔ loɖɔɛ mi ne, mi wũ miɖɔɛ so ngbɔ. ");
INSERT INTO akp_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Si mito miɖɔɛ so ne, ɔbiara to ɔ̃atsue sɔ wũ marasuãdze miɖe.” ");
INSERT INTO akp_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ne Simon Petro ɔkarɛ wũ sɔ, “Bosate, i lɛ asɛ?” Ne Yesu ɔɣere wũ sɔ, “Ngbegɔ losɛ ne, aito aawo ɔba kiniɔ, ɣɛɛ ɔwi kama ne, ato aaba mmɔ.” ");
INSERT INTO akp_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petro ɔkarɛ wũ sɔ, “Be ɔso loibawo-ɔ ɔsiai kiniɔ? Si inya kɔra ne, loakpi i fɔ iti!” ");
INSERT INTO akp_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ne Yesu ɔtã wũ mmuai sɔ, “Afɔ aɖe sɔ aakpi i wũ iti? Gbaã loto loɣere-ɔ sɔ, si kɔkɔ ɖeakatɔ̃ aaɖi kanya ne, ɔɔsɛ̃ me ikpɛ itɛ sɔ aiɣe me.” ");
INSERT INTO akp_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ne Yesu ɔɣere ma sɔ, “Midaati mikpakpa, mifɔ Ɣaa miɖe si mifɔ me wũ miɖe. ");
INSERT INTO akp_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Kuwekɔ̃ gbodzoo pia i Tete iyo ame, ne ɔso losɛ loaledza kɔ̃ losɛ mi. Si iise ngbɔ ne, loibaɣere mi. ");
INSERT INTO akp_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Si loɔsɛ loaledza kabokɔ̃ losɛ mi ne, loakpese loba loakɔ mi sɔ ngbegɔ lopia ne, mi wũ miawe i mmɔ. ");
INSERT INTO akp_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Miɣe ɔri gɔ iso miaki fiɛ miaba ngbegɔ losɛ.” ");
INSERT INTO akp_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ne Toma ɔɣere wũ sɔ, “Bosate, gɔ boiɣe ngbegɔ asɛ ne, nda boabara fiɛ boatsue ɔri?” ");
INSERT INTO akp_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu ɔɣere wũ sɔ, “Mme nɖe ɔri, ɔnukuare gu ngbã. Kuwɛ̃ iibawo Tete kɔrɛ ɔkɛlɛ si ɔ̃iki i wũ iso. ");
INSERT INTO akp_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Si ɔɣe miɣe me ne, tee miɣe Tete ɔ̃ wũ. Ɣɛɛ ita i kiniɔ ne, miɔtsue wũ fiɛ miɔnya wũ ana.” ");
INSERT INTO akp_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Mmɔ i Filipo to ɔɣere Yesu sɔ, “Bosate, te bo Tete, si imi bo.” ");
INSERT INTO akp_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu ɔkarɛ wũ sɔ, “Filipo, kokooko gɔ lopia i mi kɔrɛ ne, aiɣe me, ɣɛɛ? Ɔbiara gɔ loɔnya me ne, ɔ̃ɔnya Tete. Be ɔso fiɛ ato aɣɛ sɔ, ‘Te bo Tete’? ");
INSERT INTO akp_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ɛɛbɛrɛ aifɔ aɖe sɔ Tete pia i wũ ame fiɛ mme wũ lopia i Tete ame? Atɔ̃me wa losɛ loɣere mi ne, iiɖe wũ kɔrɛ abɔrɛ. Tete mɔmɔ gɔ mpia i wũ ame nto ɔbara ɔ̃ karabara. ");
INSERT INTO akp_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mifɔ me miɖe sɔ lopia i Tete ame fiɛ Tete ɔ̃ wũ ɔpia i wũ ame. Si miibawo ne ɔfɔ ɔɖe ne, mifɔ miɖe ala wũ kurabarara ɔso. ");
INSERT INTO akp_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Gbaã loto loɣere mi sɔ ɔbiara gɔ lofɔ me ɔɖe ne, ara wa loto lobara ne, ɔto ɔ̃abara wã, fiɛ ɔto ɔ̃abara nwa loɖo ngbɔ ana ala losɛ Tete kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Fiɛ loabara ira biara nɛ miakarɛ i wũ iyere ame sɔ Tete iyere aakɔlɛ kato iki i Ɔbi iso. ");
INSERT INTO akp_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ira biara nɛ miakarɛ me i wũ iyere ame ne, loabara ne.” ");
INSERT INTO akp_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ne Yesu ɔɣɛ ana sɔ, “Si mito miɖɔɛ me ne, mito miabara i wũ mmara iso. ");
INSERT INTO akp_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nto loakarɛ Tete fiɛ ɔ̃asese mi Buaidze mama gɔ loibarui i mi kɔrɛ ɔnya. ");
INSERT INTO akp_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ɔ̃ nɖe Siwarã dzɛ nsɛ siɖi ɔnukuare i Ɣaa iso site ne. Kayiiso maturi iibawo wũ ɔfɔ alasɔ maibawo wũ ɔnya fiɛ maatsue wũ. Ɣɛɛ mi ne, miɣe wũ alasɔ ɔpiagu mi, fiɛ ɔpia i mi ame. ");
INSERT INTO akp_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Loibanyua mi losɛ lɛ makpise mabi. Loto loakpese loba mi kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ikuti kɛkɛĩ gɔ kayiiso iisibanya me, ɣɛɛ mi mito mianya me. Gɔ losi ngbã ɔso ne, mi wũ mito miasɛ ngbã. ");
INSERT INTO akp_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ɔwi gɔmɔ ne, mito miatsue sɔ lopia i Tete ame, mi wũ mipia i wũ ame, fiɛ mme wũ lopia i mi ame. ");
INSERT INTO akp_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ngɔ lomɔɛ̃ wũ mmara ɔto fiɛ ɔto ɔɖe me i iso ne, ɔ̃ nɖe ngɔ nto ɔɖɔɛ me ne. Ngɔ nto ɔɖɔɛ me ne, Tete to ɔ̃aɖɔɛ wũ, fiɛ mme wũ loto loaɖɔɛ wũ fiɛ loaɖi so lote wũ.” ");
INSERT INTO akp_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ne Yuda gɔ loiɖe Iskariot ɔɣɛ sɔ, “Bosate, nda ibara fiɛ bo kere aaɖi so ate fiɛ iiɖegu kayiiso maturi?” ");
INSERT INTO akp_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu ɔtã wũ mmuai sɔ, “Si ɔrere to ɔɖɔɛ me ne, ɔɖe wũ mmara iso. Iyɔ Tete to ɔ̃aɖɔɛ wũ, fiɛ mme gu Tete aaɖi kasɛkɔ̃ i ɔ̃ kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ngɔ loito ɔɖɔɛ me ne, ɔ̃isɛ ɔmɔɛ̃ wũ itɔ̃me ɔla. Atɔ̃me wa loɣɛ minɔ ne, iiɖe mme mɔmɔ are aɖe, ɣɛɛ Tete gɔ lopia me katɔ̃me are aɖe. ");
INSERT INTO akp_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Loɣere mi atɔ̃me wagbe gɔ lokpese lopia i mi kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ɣɛɛ Buaidze gɔ nɖe Siwarã Bielea dzɛ i Tete aasese i wũ iyere ame ne, ɔ̃ nto ɔ̃ate mi ira biara fiɛ ɔ̃anyigira mi ara wa ɔɖuɖu loɣere mi ne. ");
INSERT INTO akp_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Isobuɛ si iwegu mi. Wũ isobuɛ loto lotã mi. Iiɖe kumɛgɔ i kayiiso sɛ katã isobuɛ loto lotã mi. Midaamararã so, midaanigã ana. ");
INSERT INTO akp_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Minɔ loɣere mi sɔ, ‘Si lorui i mi kɔrɛ ne, loto loakpese loba.’ Si mito miɖɔɛ me ne, miana isoɣɔ sɔ loto lokɛlɛ Tete kɔrɛ, alasɔ ɔmɔ ɔɖo me. ");
INSERT INTO akp_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kiniɔ ne loɔɣere mi nnɛgbe loɖegu katɔ̃ sɔ si iba ne, miafɔ miɖe. ");
INSERT INTO akp_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Loisibakɛlɛgu i katɔ̃ loɖe ika gbodzoo, alasɔ ngɔ nto ɔɖe kayi gagbe iso ka ɔba, ɣɛɛ ɔna ɔle i wũ iso. ");
INSERT INTO akp_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ɣɛɛ ikote sɔ kayiiso aatsue sɔ nsɛ loɖɔɛ Tete, fiɛ nsɛ lobara i ɔ̃ itɔ̃me iso. “A o-o, mita si borui i ngbe. ");
INSERT INTO akp_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Mme nɖe kuɖedziri gbaã, fiɛ Tete nɖe adziribi kpɛ̃dze. ");
INSERT INTO akp_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Wũ idzirikpa biara nɛ loisɛ iɣɔ̃ abi ne, ɔsɛ ɔtu ne ɔɖi, fiɛ ibiara nɛ nsɛ iɣɔ̃ abi ne, ɔsɛ ɔyuɛ ne ɔledza sɔ iawo abi gbodzoo ɔɣɔ̃. ");
INSERT INTO akp_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mi iso ɔɔsekele koko ala ara wa loɔte mi ɔso. ");
INSERT INTO akp_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Miwe i wũ ame si mme wũ lowe i mi ame. Kumɛgɔ ame i idzirikpa iibawo abi ɔɣɔ̃ si iito i kudziri iso ne, ngbɔ ame mi wũ miibawo abi ɔɣɔ̃ si miiwe i wũ ame ne. ");
INSERT INTO akp_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Mme nɖe kuɖedziri fiɛ mi nɖe akpa. Ngɔ mpia i wũ ame fiɛ mme wũ lopia i ɔ̃ ame ne, ɔto ɔ̃aɣɔ̃ abi gbodzoo, alasɔ si lona i mi ame ne, miibawo kuira ɔbara. ");
INSERT INTO akp_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ɔbiara gɔ loisɛ ɔwe i wũ ame ne, ɔse lɛ idzirikpa nɛ matu maɖi i kudziri iso fiɛ maafuĩdza masɛ ikore. Akpa wamɔ igbã ne, masɛ masa wã kanya mapia wã ɔtɔ atsue. ");
INSERT INTO akp_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Si miwe i wũ ame fiɛ wũ itɔ̃me ana ɔwe i mi ame ne, iyɔ mito miakarɛ ira biara nɛ miɖɔɛ fiɛ miana ne ana. ");
INSERT INTO akp_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Si miɣɔ̃ abi gbodzoo ne, isɛ ikɔlɛ Tete iyere kato fiɛ isɛ isia ita sɔ wũ marasuãdze miɖe. ");
INSERT INTO akp_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nsɛ loɖɔɛ mi lɛ kumɛgɔ i Tete sɛ ɔɖɔɛ me, miwe i wũ kuɖɔɛ ame. ");
INSERT INTO akp_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Si mibara i wũ mmara iso ne, miakɛlɛgu i katɔ̃ miwe i wũ kuɖɔɛ ame lɛ kumɛgɔ lokã Tete atsue fiɛ lopia i ɔ̃ kuɖɔɛ ame. ");
INSERT INTO akp_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Loɔɣere mi ara wagbe sɔ wũ isoɣɔ aawe i mi ame fiɛ mi isoɣɔ aayi pɔpɔɔpɔ. ");
INSERT INTO akp_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Wũ mmara nɖe sɔ, miɖɔɛ so lɛ kumɛgɔ loto loɖɔɛ mi. ");
INSERT INTO akp_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kuɖɔɛ gɔ loɖo gɔ i ɔturi aawe ɔtã ɔ̃ malaa nɖe sɔ ɔ̃asu ɔ̃ ngbã ɔtã i ma iti. ");
INSERT INTO akp_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Wũ malaa miɖe si mibara i nnɛ loɣere mi iso. ");
INSERT INTO akp_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Loisito lokpere mi sɔ maɖabo, alasɔ ɔɖabo iisɛ ɔtsue nnɛ i ma ɔkɔse sɛ ɔbara. Ɣɛɛ ne, ka loto lokpere mi sɔ wũ malaa, alasɔ loɔɣere mi ira biara nɛ lonɔ lobɔrɛgu i Tete kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Iiɖe mi loɖi me, ɣɛɛ mme loɖi mi, fiɛ losɛra mi sɔ si miasɛ miaɣɔ̃ abi gbodzoo fiɛ mi abi aase ɔwi biara. Iyɔ Tete aatã mi ira biara nɛ mikarɛ i wũ iyere ame. ");
INSERT INTO akp_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mmara mɛ loto lotã mi nɖe sɔ, miɖɔɛ so.” ");
INSERT INTO akp_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ne Yesu ɔɣɛ ana sɔ, “Si kayiiso maturi ɔtsiri mi ne, mitsue sɔ maɔɖe katɔ̃ matsiri me koko. ");
INSERT INTO akp_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Si kayiiso maturi miɖe ne, tee maaɖɔɛ mi lɛ ma malaa. Ɣɛɛ kayiiso ame lokpere mi loɖi fiɛ miisiɖe kayiiso maturi, ne ɔso fiɛ matsiri mi ne. ");
INSERT INTO akp_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Minyigi sɔ loɣere mi sɔ, ‘Ɔɖabo iisɛ ɔɖo ɔ̃ ɔkɔse.’ Si mati me kama ne, mi wũ mato maati mi kama. Si makã wũ ara ite atsue ne, mi wũ mato maakã mi ara ite atsue. ");
INSERT INTO akp_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ɣɛɛ mato maabara mi ara wagbe ɔɖuɖu alasɔ miɖe wũ mare fiɛ maiɣe ngɔ lopia me katɔ̃me. ");
INSERT INTO akp_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Si lodaaba loaɖe ma ika ne, tee maibaɖe ipɔ i ikpi iti. Ɣɛɛ kiniɔ ne, masiina kafara itu kuiwɛ̃ i ma akpi iti. ");
INSERT INTO akp_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ɔbiara gɔ lotsiri me ɔtsiri Tete ana. ");
INSERT INTO akp_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Si iiɖe ɔbara lobara karabara ga igbã i kuwɛ̃ iibara i ma ndɛ̃ ɔnya ne, tee maibaɖe ipɔ i ikpi iti. Ɣɛɛ kiniɔ ne, manya ara wa lobara fiɛ matsiri bo gu Tete inyɔ. ");
INSERT INTO akp_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Iba ngbɔ sɔ nnɛ matsɛrɛ mapia i ma mmara ɔko ame aaba i ne ame sɔ, ‘Matsiri me siefe.’ ");
INSERT INTO akp_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Loto loasese mi Buaidze gɔ loabɔrɛ i Tete kɔrɛ. Ɔ̃ nɖe Siwarã dzɛ nsɛ siɖi ɔnukuare i Ɣaa iso site. Si ɔ̃ɔse i Tete kɔrɛ ɔba ne, ɔto ɔ̃aɖe aɖansiɛ i wũ iso ɔtã mi. ");
INSERT INTO akp_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mi wũ maɖansiɛ miɖe me alasɔ miɔwegu me ita i karɔ̃kasɛkɔ̃. ");
INSERT INTO akp_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Loɔɣere mi ara wagbe ɔɖuɖu si nrɔɔ̃ iibafɛ̃ mi i mi kafɔkaɖe ame. ");
INSERT INTO akp_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Mato maasa mi maɖi i ma kusarɛkɔ̃, fiɛ ɔwi to ɔ̃aba gɔ si ɔrere ɔɖoe mi ne, ɔ̃abu sɔ Ɣaa karabara kaɖe ɔto ɔbara. ");
INSERT INTO akp_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Maturi to maabara mi ara wagbe alasɔ maiɣe me, ɣee Tete. ");
INSERT INTO akp_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ɣɛɛ loto loɣere mi ara wagbe sɔ si ɔwi ɔɣo fiɛ mato mabara wã ne, mianyigi sɔ loɔɣere mi. “Loiɣere mi ara wagbe ta karɔ̃kasɛkɔ̃ alasɔ lopia i mi kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kiniɔ ne, ka losɛ ngɔ lopia me katɔ̃me kɔrɛ, ɣɛɛ mi kuwɛ̃ iito mikarɛ me sɔ lɛ losɛ. ");
INSERT INTO akp_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ɣɛɛ gɔ loɣere mi ara wagbe ɔso ne, ka mito mimararã so. ");
INSERT INTO akp_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Atoa sɔ ise ngbɔ ne, gbaã loto loɣere mi sɔ ilɛ itã mi sɔ loakɛlɛ, alasɔ si loikɛlɛ ne, Buaidze iibawo mi kɔrɛ ɔba. Ɣɛɛ si lokɛlɛ ne, loasu wũ losese mi. ");
INSERT INTO akp_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Si ɔba ne, ɔto ɔ̃aɖi ɔte kayiiso maturi sɔ mayu ɔri i ikpi gu sibɔlɔlɔ gu atɔ̃me iɣɛgu iso. ");
INSERT INTO akp_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Mayu ɔri i ikpi iso alasɔ maifɔ me maɖe. ");
INSERT INTO akp_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Mayu ɔri i sibɔlɔlɔ iso alasɔ loto lokɛlɛ Tete kɔrɛ fiɛ miisibanya me minya. ");
INSERT INTO akp_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Mayu ɔri i atɔ̃me iɣɛgu iso alasɔ Ɣaa ɔɔɣɛgu ngɔ nto ɔɖe kayi gagbe iso atɔ̃me ɔtã wũ ipɔ. ");
INSERT INTO akp_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Loba atɔ̃me gbodzoo loaɣere mi, ɣɛɛ kiniɔ ne, ato aaɖo mi iti. ");
INSERT INTO akp_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ɔwi gɔ i Siwarã dzɛ nsɛ siɖi ɔnukuare i Ɣaa iso site ɔɔba ne, sito siate mi ɔnukuare ɔɖuɖu i Ɣaa iso. Ɔ̃ibaɖe ika i ɔ̃ mɔmɔ ɔle ame, ɣɛɛ ara wa ɔnɔ ɔ̃aɣɛ, fiɛ ɔto ɔ̃aɣere mi ara wa nto aaba i katɔ̃. ");
INSERT INTO akp_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ɔ̃ gɔmɔ loatã makɔlɛ wũ iyere kato ne, alasɔ ɔto ɔ̃aɖi ara wa ɔfɔ i wũ kɔrɛ ɔte mi. ");
INSERT INTO akp_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ara wa ɔɖuɖu nɖe Tete are ne, wũ are aɖe, ne ɔso loɣere mi sɔ nnɛ i Siwarã ɔnɔ sibɔrɛgu i wũ kɔrɛ siaɣere mi ne.” ");
INSERT INTO akp_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ne Yesu ɔsɔgu i katɔ̃ ɔɣɛ sɔ, “Ikuti kɛkɛĩ ne, miisibanya me, ɣɛɛ ɔwi kurukutu kama ne, mito mianya me ana.” ");
INSERT INTO akp_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ne ɔ̃ marasuãdze ɔkarɛ so sɔ, “Mme itɔ̃me igbã iɖe ɔto ɔɣɛ sɔ, ‘Ikuti kɛkɛĩ ne, miisibanya me, ɣɛɛ ɔwi kurukutu kama ne, mito mianya me ana,’ fiɛ ɔto ɔɣɛ ana sɔ, ‘Alasɔ losɛ Tete kɔrɛ’? ");
INSERT INTO akp_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nnɛ ɔɣɛ sɔ ikuti kɛkɛĩ ne boisibanya wũ karɔ̃, ɣɛɛ? Boinɔ itɔ̃me nɛ ɔɣɛ ngbe karɔ̃.” ");
INSERT INTO akp_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu ɣe sɔ ɔ̃ marasuãdze to mabie sɔ makarɛ wũ itɔ̃me, ne ɔso ɔɣere ma sɔ, “Itɔ̃me nɛ loɣɛ sɔ ikuti kɛkɛĩ ne miibanya me, ɣɛɛ ɔwi kɛkɛĩ kama ne mito mianya me mito mikakarɛ so ɛɛbɛrɛ? ");
INSERT INTO akp_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Gbaã loto loɣere mi sɔ mito miabiɛ misɛ kaku, ɣɛɛ kayiiso maturi to maana isoɣɔ. Mito miamararã so, ɣɛɛ mi isomararã to iakpese isoɣɔ. ");
INSERT INTO akp_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Si ɔrɔ̃go ɔɣewi ɔɣo ne, ɔsɛ ɔwe i isoma ame, alasɔ ɔɣe sɔ ibo ɔnawi ɔɔɣo, ɣɛɛ si ɔ̃ɔɣe ɔbi ne, ka ɔsɛ ɔɣara ɔ̃ inyɛwe, alasɔ ɔba isoɣɔ sɔ ɔ̃ɔɣe ɔbi ɔbɔ kayiiso. ");
INSERT INTO akp_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ngbɔ mito mimararã so kiniɔ ne, ɣɛɛ loto loaledza mi inya, fiɛ so aaɣɔ mi gbaã sɔ kuwɛ̃ iibawo mi isoɣɔ ɔmɔɛ̃ ɔfɔ. ");
INSERT INTO akp_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Ɔwi gɔmɔ ame ne, miisibakarɛ me kuira. Fiɛ gbaã loto loɣere mi sɔ si mikarɛ Tete ira biara ne, ɔto ɔ̃atã mi i wũ iyere ame. ");
INSERT INTO akp_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ipɛ i kiniɔ ne, miikarɛ kuira i wũ iyere ame. Mikarɛ ara fiɛ miafɔ, sɔ mi isoɣɔ aayi. ");
INSERT INTO akp_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Losu agbã loɣere mi ara wagbe, ɣɛɛ ɔwi to ɔba gɔ loisibaɖe mi aka i agbã ame. Ɔwi gɔmɔ ne, loaɣere mi ara loɖi i Tete iso. ");
INSERT INTO akp_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Iyi nɛmɔ ne, mito miakarɛ ara i wũ iyere ame. Loito loɣɛ sɔ mme loakarɛ Tete ara i mi kanya, ");
INSERT INTO akp_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","alasɔ Tete mɔmɔ to ɔɖɔɛ mi. Ɔto ɔɖɔɛ mi alasɔ mito miɖɔɛ me fiɛ mifɔ miɖe sɔ Ɣaa kɔrɛ lobɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Gbaã, Tete kɔrɛ lobɔrɛ loba kayiiso, fiɛ loɔbɔrɛ i kayiiso loto lokpese lokɛlɛ ɔ̃ kɔrɛ.” ");
INSERT INTO akp_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Marasuãdze ɔɣere wũ sɔ, “Ɛɣɛɛ̃, kini ato aɖe bo ika aɖi fiɛ iiɖe agbã ame ne. ");
INSERT INTO akp_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kini botsue sɔ aɣe ira biara ne iinya sɔ kuwɛ̃ aakarɛ-ɔ kuira ne. Iki i nnɛgbe iso ne, boɔfɔ boɖe sɔ Ɣaa kɔrɛ abɔrɛ.” ");
INSERT INTO akp_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu ɔtã ma mmuai sɔ, “Miɔfɔ miɖe kini? ");
INSERT INTO akp_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ɔwi to ɔba fiɛ ɔ̃ɔɣo, gɔ mi ɔɖuɖu to miasame miɣɛ me mikɛlɛ mi ayo ikuti wũ ɔnɔwɛ̃. Ɣɛɛ loiɖe wũ ɔnɔwɛ̃ alasɔ Tete piagu me. ");
INSERT INTO akp_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Loɔɣere mi ara wagbe si so aaɣɔ mi i mi mawɛ̃ ibaragu me ame. Kayiiso to kaatã miwe inyɛ, ɣɛɛ mina ɔtu alasɔ loɔɖe kayiiso iso!” ");
INSERT INTO akp_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Gɔ Yesu ɔɣɛ ara wagbe ɔro ne, ɔkɔlɛ anɔ ɔnyɔ kato, ɔɣɛ sɔ, “Tete, ɔwi ɔɔɣo. Kɔlɛ fɔ Ɔbi iyere kato si fɔ Ɔbi ana aakɔlɛ fɔ ire kato. ");
INSERT INTO akp_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Alasɔ atã wũ ɔle i maturi ɔɖuɖu iso sɔ ɔ̃atã mma ɔɖuɖu asu atã wũ ngbã mɛ nna katui. ");
INSERT INTO akp_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ngbã mɛ nna katui karɔ̃ nɖe sɔ maatsue sɔ fɔ ɔnɔwɛ̃ nɖe Ɣaa gbaã fiɛ maatsue Yesu Kristo gɔ apia katɔ̃me ana. ");
INSERT INTO akp_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Loɔkɔlɛ fɔ iyere kato i karɔ̃ iso, alasɔ loɔro karabara ga apia me sɔ lobara. ");
INSERT INTO akp_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kiniɔ ne Tete, kɔlɛ wũ iyere kato i fɔ anɔ isɛ iabo ngbegɔ losia ku ɔwi gɔ lowe i fɔ kɔrɛ ta kayi karɔ̃kasɛkɔ̃. ");
INSERT INTO akp_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Loɔɖi-ɔ lote mma atã me abɔrɛgu i kayi ame. Fɔ mare maɖe, fiɛ fɔ losu ma atã me. Makã fɔ itɔ̃me atsue, ");
INSERT INTO akp_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","fiɛ kiniɔ ne, ka maɣe sɔ ira biara nɛ atã me ne, fɔ kɔrɛ ibɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Loɣere ma katɔ̃me ga apia me, fiɛ mafɔ kã. Maɣe sɔ gbaã ne, fɔ kɔrɛ lobɔrɛ fiɛ mafɔ maɖe sɔ fɔ lopia me katɔ̃me. ");
INSERT INTO akp_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Loito lokparama kayi lotã kayiiso, ɣɛɛ mma atã me iti loto lokparama kayi, alasɔ fɔ mare maɖe. ");
INSERT INTO akp_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","“Mma ɔɖuɖu nɖe wũ mare ne, fɔ mare maɖe. Fiɛ mma ɔɖuɖu nɖe fɔ mare ne, wũ mare maɖe. Ma iso asɛ akɔlɛ wũ iyere kato akigu. ");
INSERT INTO akp_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Kiniɔ ne, ka loba fɔ kɔrɛ, losiina i kayiiso, ɣɛɛ ma mapia i kayiiso. Tete Sekelea, dzuɛ̃ ma i ɔle gɔ mpia i fɔ iyere nɛ atã me ame sɔ maaɖe mawɛ̃ lɛ kumɛgɔ i bo gu-ɔ ɖe mawɛ̃. ");
INSERT INTO akp_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ɔwi gɔ lopia i ma kɔrɛ ne, lodzuɛ̃ ma ala ɔle gɔ mpia i iyere nɛ atã me ame. Lodzuɛ̃ ma sɔ ma kuwɛ̃ iiyu iɖo ngɔ ikote sɔ ɔ̃ayu, sɔ nnɛ matsɛrɛ masɛ i Ɔko Sekelea ame aaba i ne ame. ");
INSERT INTO akp_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ɣɛɛ kiniɔ ne, ka loba fɔ kɔrɛ. Loɣɛ atɔ̃me wagbe i kayiiso sɔ wũ isoɣɔ aayi ma situ ame pɔpɔɔpɔ lɛ kumɛgɔ mme wũ loba isoɣɔ kiniɔ. ");
INSERT INTO akp_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Loɣere ma fɔ itɔ̃me fiɛ kayiiso ɔtsiri ma alasɔ maiɖe kayiiso mare lɛ kumɛgɔ mme wũ loiɖe kayiiso ɔre. ");
INSERT INTO akp_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Loito lokarɛ sɔ mɔɛ̃ ma ɖi i kayiiso, ɣɛɛ nnɛ loto lokarɛ nɖe sɔ dzuɛ̃ ma ɖi bɔrɛgu i Tsirise nrɔɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kumɛgɔ ame loiɖe kayiiso ɔre ne, ngbɔ ame ma wũ maiɖe kayiiso mare ne. ");
INSERT INTO akp_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Bara ma sekelee iki i ɔnukuare ame, fɔ itɔ̃me nɖe ɔnukuare. ");
INSERT INTO akp_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Lopia ma kayiiso maturi kɔrɛ lɛ kumɛgɔ fɔ wũ apia me kayiiso. ");
INSERT INTO akp_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ma ɔso ne, lobara so sekelee lotã-ɔ sɔ ma wũ ne, maabara so sekelee gbaã matã-ɔ. ");
INSERT INTO akp_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Iiɖe ma ɔnɔwɛ̃ saã iti loto lokparama kayi, ɣɛɛ mma ana ɔɖuɖu loafɔ me maɖe iki i ma itɔ̃me iso iti. ");
INSERT INTO akp_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tete! Tã sɔ ma ɔɖuɖu aaɖe mawɛ̃. Mawe i bo ame lɛ kumɛgɔ apia i wũ ame fiɛ mme wũ lopia i fɔ ame. Maɖe mawɛ̃ si kayiiso maturi aafɔ maɖe sɔ fɔ lopia me katɔ̃me. ");
INSERT INTO akp_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","“Lopia ma kuwarɛ lɛ kumɛgɔ apia me kuwarɛ sɔ si maaɖe mawɛ̃ lɛ kumɛgɔ i bo gu-ɔ ɖe mawɛ̃. ");
INSERT INTO akp_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Lopia i ma ame, fiɛ fɔ wũ apia i wũ ame sɔ maaɖe mawɛ̃ pelepele sɔ kayiiso aatsue sɔ fɔ lopia me katɔ̃me fiɛ asɛ aɖɔɛ fɔ mabi lɛ kumɛgɔ asɛ aɖɔɛ me. ");
INSERT INTO akp_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tete! Fɔ losu ma atã me fiɛ loto lobie sɔ mawe i ngbegɔ lopia fiɛ maanya wũ ikpawaĩ nɛ atã me. Alasɔ ato aɖɔɛ me fiɛ abara kayiiso. ");
INSERT INTO akp_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Tete Bɔlɔlɔa! Kayiiso maturi iiɣe-ɔ, ɣɛɛ mme loɣe-ɔ, fiɛ mmagbe ɣe sɔ fɔ lopia me katɔ̃me. ");
INSERT INTO akp_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Loɖi-ɔ lote ma fiɛ loto loakɛlɛgu i katɔ̃ lobara ngbɔ sɔ kuɖɔɛ gɔ aba atã me aawe i ma ame fiɛ mme wũ loawe i ma ame.” ");
INSERT INTO akp_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Gɔ Yesu ɔkparama kayi ɔro ne, ɔruigu ɔ̃ marasuãdze mawara Kidron Kaworenya makɛlɛ nnɔĩ adziri kakpɛkɔ̃ kawɛ̃ ame. ");
INSERT INTO akp_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda gɔ loɖi Yesu ɔtã ana ɣe mmɔ, alasɔ ɔwi gbodzoo ame ne, Yesu sɛ ɔkɔ ɔ̃ marasuãdze masɛ maasarɛ i mmɔ. ");
INSERT INTO akp_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ne ɔso Yuda ɔkɔ makpakpɛ̃dze ikuri iwɛ̃ gu kasɔrɛkɔ̃ madzuɛ̃se ma i masɔrɛdze makpakpa gu ma Farisise ɔsese kakpɛkɔ̃ gamɔ ame. Mato akpira, kaka sitɔ gu sikaniɛ. ");
INSERT INTO akp_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu ɣe ira biara nɛ loabɔrɛ wũ iso, ne ɔso ɔbɔrɛ ɔya i katɔ̃ ɔkarɛ ma sɔ, “Nna mito mibie?” ");
INSERT INTO akp_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Matã wũ mmuai sɔ, “Yesu Nasaretse boto bobie.” Ne Yesu ɔɣere ma sɔ, “Mme nɖe wũ.” Yuda gɔ loɖi wũ ɔtã ana ɣɛ i ma kɔrɛ mmɔ. ");
INSERT INTO akp_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Gɔ Yesu ɔɣere ma sɔ, “Mme nɖe wũ” ne, masɛ simasima mabɔrɛ marɔ̃. ");
INSERT INTO akp_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ɔledza ma ikarɛ sɔ, “Nna mito mibie?” Maledza wũ mmuai itã sɔ, “Yesu Nasaretse.” ");
INSERT INTO akp_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ne Yesu ɔɣere ma sɔ, “Loɔɣere mi koko sɔ mme nɖe wũ ne, ne ɔso si mme mito mibie ne, miɖi mmagbe ɔri si makɛlɛ.” ");
INSERT INTO akp_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ɔɣɛ nnɛgbe si itɔ̃me nɛ ɔ̃ɔɣere ma ɔɖegu katɔ̃ aaba i ne ame sɔ, “Tete, mma asu atã me ne, loiyura ma kuwɛ̃.” ");
INSERT INTO akp_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ne Simon Petro gɔ nto ipɛmi ɔɖi ne i ɔyuɛ ame ɔwe sɔrɛdzekpakpa pelepele ɔɖabo kuɖearɔ̃ kutsue ɔtara. Ɔɖabo gɔmɔ marɔ sɔ Malkos ne. ");
INSERT INTO akp_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ɣɛɛ Yesu ɔɣere Petro sɔ, “Kpesera fɔ ipɛmi pia i ne kawekɔ̃. Iikote sɔ loanɛ inyɛwe ikɔi nɛ i Tete ɔtã me?” ");
INSERT INTO akp_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ne kama ne, Roma makpakpɛ̃dze gu ma ɔkpakpa gu ma Yudase madzuɛ̃se ɔmɔɛ̃ Yesu, manyi wũ. ");
INSERT INTO akp_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Makɔ wũ makɛlɛgu Hana kɔrɛ. Hana gɔgbe nɖe mase ɔtã Kayafa gɔ nɖe sɔrɛdzekpakpa pelepele ku ikɔ nɛmɔ ne. ");
INSERT INTO akp_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa gɔgbe ame ɔɖe lotã ma Yudase adzuni sɔ ilɛ iɖo sɔ ɔturi ɔwɛ̃ aakpi i kaɖe ɔɖuɖu iti ne. ");
INSERT INTO akp_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Petro gu rasuãdze ɔwɛ̃ ɔsiai Yesu i kama. Gɔ makɛlɛ sɔrɛdzekpakpa pelepele iyo ne, rasuãdze gɔmɔ ɔ̃ ɔbo i iyo ame, alasɔ ma gu Sɔrɛdzekpakpa ɣe so kukaakɔ. ");
INSERT INTO akp_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ɣɛɛ Petro ɣɛ i inyamɔ. Rasuãdze gɔmɔ ɔkpese ɔkɛlɛ kayogodɔ̃ ɔsɛ ɔ̃aɖegu ɔbirɔ̃gomi gɔ nto ɔdzuɛ̃ mmɔ ika fiɛ ɔtã wũ ɔri ɔkɔ Petro ɔbogu i iyo. ");
INSERT INTO akp_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ɔbirɔ̃gomi gɔ nɣɛ i kayogodɔ̃ mmɔ ɔkarɛ Petro sɔ, “Fɔ wũ iiɖe ɔrɛrɛ̃ gɔgbe rasuãdze ɔwɛ̃ aɖe, ɣɛɛ?” Ne Petro sɔ, “Ooɣo lo, loiɖe ma ɔwɛ̃!” ");
INSERT INTO akp_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ɔyu pia, ne ɔso maɖabo gu madzuɛ̃se ɔpia ɔtɔ maɣɛ maki malɔ mato mawa. Ne ɔso Petro ɣɛ i ma kɔrɛ ɔto ɔwa ɔtɔ. ");
INSERT INTO akp_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Sɔrɛdzekpakpa pelepele ɔkarɛ Yesu atɔ̃me ɔsegu i ɔ̃ marasuãdze gu ɔ̃ ara wa ɔto ɔte iso. ");
INSERT INTO akp_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ne Yesu ɔɣere wũ sɔ, “Ɔwi biara lopia loto lote maturi ara i ɔgbami, fiɛ wũ ara ite ɔɖuɖu ana ne, lote wã i kasarɛkɔ̃ gu Isɔrɛyo ame ngbegɔ i ma Yudase ɔɖuɖu ɔsakanya, ne ɔso loite kuira i iwɛrɛ ame. ");
INSERT INTO akp_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Be ɔso mme ato akarɛ atɔ̃me? Karɛ mma lonɔ wũ ara wa lote ma. Maɣe nnɛ loɣɛ.” ");
INSERT INTO akp_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Gɔ Yesu ɔɣɛ ngbɔ ne, dzuɛ̃se ɔwɛ̃ gɔ nɣɛ i mmɔ ɔpɛ wũ ɔrɔ̃ta i kutsueti ɔkarɛ wũ sɔ, “Sɔrɛdzekpakpa pelepele ato aɖegu ika ngbɔ?” ");
INSERT INTO akp_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ne Yesu ɔɣere wũ sɔ, “Si loɣɛ nnɛ loilɛ ne, ɣere ɔbiara i ngbe nnɛ loɣɛ fiɛ iilɛ, ɣɛɛ si loiɣɛ kuira nyanyarĩa ne, be ɔso ato apɛ me ɔrɔ̃ta?” ");
INSERT INTO akp_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ne ɔso Hana ɔkpesegu Yesu gɔ manyi nrɔɔ̃ ɔsese Kayafa gɔ nɖe sɔrɛdzekpakpa pelepele kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Gɔ Simon Petro ɣɛ ɔtogu ɔtɔ iwa ne, mma nɣɛ i mmɔ ɔkarɛ wũ sɔ, “Fɔ wũ ne, iiɖe ɔrɛrɛ̃ gɔgbe rasuãdze ɔwɛ̃ aɖe, ɣɛɛ?” Ɣɛɛ Petro ɔsɛ̃, ɔɣɛ sɔ, “Loiɖe ma ɔwɛ̃!” ");
INSERT INTO akp_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Sɔrɛdzekpakpa pelepele maɖabo ɔwɛ̃ gɔ i Petro ɔtu kutsue ɔnyii ana ɔɣɛ sɔ, “Nnisɔ lonya-ɔ fɔ wũ i kakpɛkɔ̃ ame ku ɔrɛrɛ̃ gɔgbe?” ");
INSERT INTO akp_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ngbe ana ne, Petro ɔɣɛ sɔ, “Ooɣo!” Ɔluwɛ̃ ne, kɔkɔ ɔbo. ");
INSERT INTO akp_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kaya tutuutu ne, makɔ Yesu mabɔrɛgu i Kayafa iyo makɛlɛgu abã ɔkpakpa iyo. Gɔ ma Yudase makpakpa ɔɔsekelera so sɔ maawo Kukpi Ɔtakuwara Bo Iyi aɖera ɔɖe ɔso ne, maibo i iyo ame. ");
INSERT INTO akp_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ne ɔso Pilato ɔbɔrɛ ɔkɛlɛ ma kɔrɛ i inyamɔ ɔkarɛ ma sɔ, “Mme ikpi i ɔrɛrɛ̃ gɔgbe ɔbara?” ");
INSERT INTO akp_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Matã mmuai sɔ, “Si ɔ̃ibara ikpi kuiwɛ̃ ne, boibakɔ wũ bobɔ-ɔ.” ");
INSERT INTO akp_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ne Pilato to ɔɣere ma sɔ, “Iyɔ mi mɔmɔ mikɔ wũ mikɛlɛgu miaɣɛgu wũ atɔ̃me i mi mmara kanya.” Matã wũ mmuai sɔ, “Maitã bo ɔri sɔ boatã ɔturi kukpi ipɔ.” ");
INSERT INTO akp_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nnɛgbe ɔba ngbɔ sɔ nnɛ i Yesu mɔmɔ ɔɣɛ ɔsu ɔte kukpi gɔ igbã ɔ̃akpi ɔba i ne ame. ");
INSERT INTO akp_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato ɔkpese ɔbo i atɔ̃mekaɣɛkɔ̃ ɔkarɛ Yesu sɔ, “Fɔ nɖe ma Yudase igara?” ");
INSERT INTO akp_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ne Yesu ɔkarɛ wũ sɔ, “Fɔ mɔmɔ kɔrɛ i itɔ̃me nɛgbe ɔbɔrɛ ɛɛbɛrɛ manyiiɔ loɖe-ɔ wũ iso ika?” ");
INSERT INTO akp_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato ɔtã wũ mmuai sɔ, “Ɔ Yudase loɖe? Fɔ mɔmɔ maturi gu masɔrɛdze makpakpa lokɔ-ɔ mabɔ me. Be iɖe abara?” ");
INSERT INTO akp_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ne Yesu ɔɣɛ sɔ, “Wũ sigarakaɖekɔ̃ iibɔrɛ i kayi gagbe iso, si ngbe sibɔrɛ ne, tee wũ makpabo aakpɛ̃ mafɔ me mabɔrɛgu i ma Yudase nrɔɔ̃ ame, ɣɛɛ ne, wũ sigarakaɖekɔ̃ iibɔrɛ i ngbe!” ");
INSERT INTO akp_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato ɔkarɛ wũ sɔ, “Ne iyɔ igara aɖe?” Ne Yesu ɔtã mmuai sɔ, “Fɔ nto aɣɛ sɔ igara loɖe. Ira ka iwɛ̃ nɛgbe ɔso fiɛ maɣe me mapia i kayi gagbe ame ne, sɔ loaɣɛ ɔnukuare. Ɔbiara gɔ nɖe ɔnukuare ɔre sɛ ɔkã me atsue.” ");
INSERT INTO akp_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ne Pilato ɔkarɛ wũ sɔ, “Be nɖe ɔnukuare?” Ne Pilato ɔbɔrɛ ɔkɛlɛ ma Yudase kɔrɛ i inyamɔ ɔɣere ma sɔ, “Loinya ikpi kuiwɛ̃ nɛ iso loaya fiɛ loatã wũ kukpi ipɔ lo. ");
INSERT INTO akp_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ɣɛɛ i mi kubarara kanya ne, nsɛ loɖi yorɛdze ɔwɛ̃ lotã mi ku Kukpi Ɔtakuwara Bo Iyi ɔɖewi biara. Ne ɔso lonyua ma Yudase Igara lotã mi?” ");
INSERT INTO akp_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Mala kulu matã mmuai sɔ, “Ooɣo, boibie wũ! Bobie Baraba!” Baraba gɔgbe ne, ɔturi gɔ lota ɔya abã iso ɔɖe. ");
INSERT INTO akp_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ne ɔso Pilato ɔtã makpakpɛ̃dze ɔkɔ Yesu maruigu masɛ maapɛ wũ nyanyarĩ ku ala iporoibi. ");
INSERT INTO akp_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Masu miyu mabara ala sigaraikoto masu matɔ̃medza wũ fiɛ ka masu ɔgo rɛtɛa ɔkati mafu wũ lɛ igara. ");
INSERT INTO akp_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Mabore mabo wũ mafa kayiɖu sɔ, “Ɣii-ɣiiɖuu! Ma Yudase Igara o-o!” Maɣɛ ngbɔ ne mapɛ wũ sirɔ̃ta. ");
INSERT INTO akp_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato ɔledza ibɔrɛ ikɛlɛ isɛ iaɣere ma Yudase sɔ, “Minyɔ, loto lokɔ wũ lobɔ mi si minya sɔ loinyagu wũ ku ikpi nɛ ɔso loatã wũ kukpi ipɔ.” ");
INSERT INTO akp_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ne ɔso Yesu ɔbɔrɛ ɔba ɔtɔ̃me miyu ikoto fiɛ ka ɔpia ɔgo awu rɛtɛa tagbaraa. Ne Pilato ɔɣere ma sɔ, “Minyɔ wũ! Ɔturi i ngbe ne!” ");
INSERT INTO akp_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Gɔ masɔrɛdze makpakpa gu Isɔrɛyo madzuɛ̃se ɔnya wũ ne, mala kulu sɔ, “Pɛ wũ matãra i kudziri iso! Pɛ wũ matãra i kudziri iso!” Ne Pilato ɔɣere ma sɔ, “Mikɔ wũ mikɛlɛgu miapɛ wũ mimatãra i kudziri iso, ɣɛɛ mme ne, loinya ikpi kuiwɛ̃ nɛ ɔso loatã wũ kukpi ipɔ.” ");
INSERT INTO akp_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ne maturi to mala kulu maɣɛ sɔ, “Boba mmara mɛ loɣɛ sɔ ikote sɔ ɔ̃akpi, alasɔ ɔto ɔkpere so sɔ Ɣaa Ɔbi ɔɖe.” ");
INSERT INTO akp_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Gɔ Pilato ɔnɔ nnɛgbe ne, ifɔ̃ ɔmɔɛ̃ wũ ibua. ");
INSERT INTO akp_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ne ɔkpese ɔkɛlɛ iyo ame fiɛ ɔkarɛ Yesu sɔ, “I lɛ abɔrɛ?” Ɣɛɛ Yesu iitã wũ mmuai. ");
INSERT INTO akp_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato ɔkarɛ wũ sɔ, “Be, aito apia me kanya? Tsue sɔ loba ɔle gɔ loawo-ɔ ɔnyua ɣee lotã mapɛ-ɔ mamatãra i kudziri iso!” ");
INSERT INTO akp_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Mmɔ i Yesu ɔtã wũ mmuai sɔ, “Ɔle gɔ kɔra aba i wũ iso ne, Ɣaa pɛ lotã-ɔ ɔso. Ne ɔso ngɔ loɖi me ɔtã-ɔ ɔbara ikpi siare ɔɖo-ɔ.” ");
INSERT INTO akp_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nnɛgbe ɔso ne, Pilato ɔbie sɔ si ɔnyua wũ, ɣɛɛ ma Yudase ɔla kulu teteree sɔ, “Si anyua ɔrɛrɛ̃ gɔgbe ne, iyɔ aiɖe Roma Igarakpakpa ɔlaa. Ɔbiara gɔ losɛra so sigara ne, ɔta ɔya i Igarakpakpa iso!” ");
INSERT INTO akp_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Gɔ Pilato ɔnɔ atɔ̃me wagbe ne, ɔkɔ Yesu ɔkɛlɛgu inyamɔ. Ɔsɛ ɔ̃asɛ i iyara nɛ iso masɛ masɛ maɣɛ atɔ̃me fiɛ masɛ marɔ ne sɔ Itabɛbɛa iso. I ma Yudase siɖe ame ne, masɛ marɔ mmɔ sɔ Gabata. ");
INSERT INTO akp_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Iyi nɛmɔ nɖe Iledzaso itã Kukpi Ɔtakuwara Bo Iyi iɖe ne. Ne Pilato ɔɣere ma sɔ, “Nya mi Igara ngbe!” ");
INSERT INTO akp_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ne mala kulu teteree sɔ, “Kɔ wũ ruigu! Kɔ wũ ruigu! Pɛ wũ matãra i kudziri iso!” Ne Pilato ɔkarɛ ma sɔ, “Lopɛ mi Igara lomatãra i kudziri iso?” Ne masɔrɛdze makpakpa ɔtã mmuai sɔ, “Bona igara kuwɛ̃ iɖo Roma Igarakpakpa Kaisaro!” ");
INSERT INTO akp_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Gɔ maɣɛ ngbɔ ne, Pilato ɔtara Yesu ɔpia ma i nrɔɔ̃ ame sɔ masɛ maapɛ wũ mamatãra i kudziri iso. Ne ɔso makpakpɛ̃dze ɔkɔ Yesu maruigu. ");
INSERT INTO akp_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Gɔ matã wũ ɔsore ɔdziri ne, makɔ wũ makɛlɛgu ngbegɔ marɔ Itikui Kabemi. Fiɛ si Hebrise ame ne, masɛ marɔ mmɔ sɔ Golgata. ");
INSERT INTO akp_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Mapɛ wũ mamatãra i kudziri iso i ngbe. Mapɛ maturi inyɔ mawɛ̃ ana mamatãra i ma adziri iso mabua wũ iso. Ɔwɛ̃ i kuɖearɔ̃ iso, ɔwɛ̃ ana i kubena iso fiɛ Yesu ka ɔpia ma i ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato ɔtã matsɛrɛ mamatãra i Yesu sitikpe sɔ, “Yesu Nasaretse, Ma Yudase Igara.” ");
INSERT INTO akp_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ma Yudase gbodzoo ɔka ira nɛ matsɛrɛ masia i kudziri iso alasɔ ngbegɔ mapɛ Yesu mamatãra i kudziri iso ɔbore imatã Yerusalem. Ana ne, matsɛrɛ i si Hebrise gu si Romase gu si Helase ame. ");
INSERT INTO akp_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Masɔrɛdzekpakpa iitɔrã, maɣere Pilato sɔ, “Daatsɛrɛ sɔ ‘Ma Yudase Igara,’ ɣɛɛ tsɛrɛ sɔ, ‘Ngɔgbe nto ɔɣɛ sɔ ɔ̃ nɖe ma Yudase Igara ne.’ ” ");
INSERT INTO akp_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ɣɛɛ Pilato ɔsɛ̃, ɔɣere ma sɔ, “Nnɛ loɔtsɛrɛ ne, loɔtsɛrɛ koko.” ");
INSERT INTO akp_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Gɔ makpakpɛ̃dze ɔpɛ Yesu mamatãra i kudziri iso maro ne, maɣɛ ɔ̃ arapia aka ana, kpakpɛ̃dze biara ɔfɔ ika iwɛ̃. Awu awɛ̃ ɔkuti wa iiɖe ɔkã makã ɣɛɛ ɔwe mawe wã ita i kato isɛ iabɔrɛ i kala. ");
INSERT INTO akp_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Makpakpɛ̃dze ɔɣere so sɔ, “Midaatã bokɛ wã, ɣɛɛ mitã bobara kareremi si bonyɔ sɔ nna aaɣo.” Iba ngbɔ sɔ nnɛ matsɛrɛ mapia i Ɔko Sekelea ame aaba i ne ame sɔ, “Masu wũ arapia maɣɛ so. Fiɛ mabara kareremi i wũ awu iso.” Ne ɔso ngbɔ tutuutu i makpakpɛ̃dze ɔbara ne. ");
INSERT INTO akp_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Kudziri gɔ iso mapɛ Yesu mamatãra kɔrɛ ne, marɔ̃go mawɛ̃ ɣɛ. Ma nɖe Yesu ɔnyi gu ɔ̃ ɔnyiibi gu Klopa ɔre Maria gu Maria Magdalase. ");
INSERT INTO akp_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Gɔ Yesu ɔnya ɔ̃ ɔnyi gu ɔ̃ rasuãdze gɔ ɔ̃isɛ ɔpia kuɣɛ ɣɛ mabore mamatã wũ ne, ɔɣere ɔ̃ ɔnyi sɔ, “Mmã, nya fɔ ɔbi!” ");
INSERT INTO akp_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ne ɔɣere rasuãdze gɔmɔ ana sɔ, “Fɔ wũ, nya fɔ ɔnyi.” Ne ɔso ita i iyi nɛmɔ ne, rasuãdze gɔgbe ɔkɔ Yesu ɔnyi ɔkɛlɛgu ɔ̃ iyo ɔnyɔ wũ iso. ");
INSERT INTO akp_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu ɣe sɔ ira biara ɔɔba kawirikɔ̃, ɣɛɛ si nnɛ matsɛrɛ masɛ aaba i ne ame ne, ɔɣɛ sɔ, “Ɔme to ɔkore me.” ");
INSERT INTO akp_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ituɖura iwɛ̃ se i mmɔ iyi ku ndã bea. Ne ɔso masu ɖɔti pukupukua mapia i me ame maɖu i ɔdziri iso masɔ̃ Yesu i kanya. ");
INSERT INTO akp_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Gɔ ɔfɔ ndã bea mɛmɔ ɔro ne, ɔɣɛ sɔ, “Iɔro kini!” Gɔ ɔɣɛ ngbɔ ne, ɔbɔ iti karɔ̃ kere ne ɔsora ne. ");
INSERT INTO akp_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Iledzaso itã Iwarãyi iyi iso iɖe i ara wagbe ɔba, fiɛ kaɖesɛ̃a ɖe Iwarãyi sekelea itã ma Yudase, ne ɔso maibie sɔ makpise si mamatã i adziri iso ku Iwarãyi. Ne ɔso masɛ maaɣere Pilato sɔ ɔtã ɔri si masɛ maafɛfɛ̃ ma ngba si mabɛse ma i adziri iso. ");
INSERT INTO akp_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ne ɔso makpakpɛ̃dze ɔba maturi inyɔ ma mapɛ mamatãra i adziri iso ku Yesu kɔrɛ. Mafɛ̃ ɔɖeakatɔ̃ gu ɔnyɔare ngba. ");
INSERT INTO akp_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ɣɛɛ gɔ mabo Yesu iso ne, manya sɔ ɔ̃ɔkpi koko ne ɔso maisifɛ̃ ɔ̃ ngba. ");
INSERT INTO akp_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ɣɛɛ kpakpɛ̃dze ɔwɛ̃ ɔsu ɔ̃ ifele ɔtsue Yesu iwãgɛsɛ fiɛ ndu gu ima ɔbɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ngɔ lonya sɔ ara wagbe ɔba ɔɖe loɖe wã aɖansiɛ sɔ si fɔ wũ aafɔ aɖe. Ara wa ɔɣɛ ne, gbaã iɖe fiɛ ɔɣe sɔ ɔnukuare iɖe ɔɣɛ. ");
INSERT INTO akp_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Iba ngbɔ sɔ nnɛ matsɛrɛ masɛ i Ɔko Sekelea ame aaba i ne ame sɔ, “Maibafɛ̃ ɔ̃ ikui kuiwɛ̃.” ");
INSERT INTO akp_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Matsɛrɛ masɛ i kakɔi mama ana sɔ, “Mato maanyɔ ngɔ matsue ira.” ");
INSERT INTO akp_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nnɛgbe kama ne, Yosef gɔ lose i Arimatea ɔba ɔ̃akarɛ Pilato sɔ ɔsu Yesu kpise ɔtã wũ. Ɔɖe Yesu rasuãdze ɣɛɛ i iwɛrɛ ame alasɔ ɔto ɔnigã ma Yudase makpakpa ɔso ne. Pilato ɔɖi wũ ɔri, ne ɔso ɔsu kpise ɔruigu. ");
INSERT INTO akp_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemo gɔ loba Yesu kɔrɛ ku kasɛ̃ ɔnya ana ɔba. Ɔsu awa wa masu korobo gu awa kɔrɔ̃kɔrɔ̃a mabara ala fiɛ masɛ masu maledza ala makpise fiɛ wã ɔrɔrã aaɖe lɛ ito iwɛ̃ ɔbɔ. ");
INSERT INTO akp_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Marɛrɛ̃ inyɔ magbe ɔsu awa mapia i ɔkati ame mamini kpise, kumɛgɔ i ma Yudase sɛ mabara fiɛ masɛ mabiara ɔturi. ");
INSERT INTO akp_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","I ngbegɔ mapɛ Yesu mamatãra i kudziri iso ne, kakpɛkɔ̃ kawɛ̃ pia i mmɔ. Ikpibiɔ ɣɛtɛ nɛ ame maibiara ɔturi manya ana se i kã ame. ");
INSERT INTO akp_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Gɔ kaɖesɛ̃a to iaɖe Iwarãyi fiɛ ikpibiɔ nɛmɔ ɔɔbore imatã mmɔ ɔso ne, masu Yesu mabiara i mmɔ. ");
INSERT INTO akp_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kɔsiɖa kaya tutuutu gɔ kayi iikpa karo ne, Maria Magdalase ɔkɛlɛ ikpibiɔ kɔrɛ fiɛ ɔnya sɔ maɔli ita nɛ mali matɛ̃ ikpibiɔ kanya maɖi. ");
INSERT INTO akp_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ɔtere ɔkɛlɛ Simon Petro gu rasuãdze gɔ i Yesu iisɛ ɔpia kuɣɛ kɔrɛ ɔsɛ ɔ̃aɣere ma sɔ, “Maɔmɔɛ̃ Bosate maɖi i ikpibiɔ ame fiɛ boiɣe ngbegɔ masu wũ masɛ!” ");
INSERT INTO akp_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Petro gu rasuãdze gɔmɔ ɔta sɔ makɛlɛ ikpibiɔ kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ma inyɔɔ ɔtere ise, ɣɛɛ rasuãdze gɔmɔ ɔtere ɔɖe Petro katɔ̃ ɔbo ikpibiɔ kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ɔbɔ iti karɔ̃ ɔnya sikati fudza dzɛmɔ, ɣɛɛ ɔ̃ibo i ikpibiɔ ame. ");
INSERT INTO akp_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Gɔ Simon Petro ɔtere ɔba ɔ̃abo ne, ɔfe ɔbo i iwo ame, ɔnya sikati fudza dzɛmɔ gɔ sise. ");
INSERT INTO akp_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ɔnya ɔkati gɔ masu manyi Yesu iti ana. Ɔ̃isakanyagu ɔkati gɔ masu mamini Yesu kɔrɛ, ɣɛɛ makarĩ masɛ i kuruɛ. ");
INSERT INTO akp_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Mmɔ i rasuãdze nyɔare gɔ loɖe katɔ̃ ɔ̃ wũ ɔbo i ikpibiɔ ame. Ɔnya ara wagbe fiɛ ka ɔfɔ ɔɖe. ");
INSERT INTO akp_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ɣɛɛ ta kiniɔ ne, mainɔ karɔ̃ nnɛ i Ɔko Sekelea ɔɣɛ sɔ Yesu aata ɔbɔrɛ i makpise ame. ");
INSERT INTO akp_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ne marasuãdze ɔkpese makɛlɛ iyo ne. ");
INSERT INTO akp_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ɣɛɛ Maria Magdalase ɔba ɔɣɛ i ikpibiɔ kɔrɛ ɔto ɔbiɛ. Gɔ ɔtogu kaku ibiɛ ne, ɔbɔ iti karɔ̃ ɔnyɔ ikpibiɔ ame ne, ");
INSERT INTO akp_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ɔnya Ɣaa makpabo inyɔ ma mpia ara fudza gɔ masi i ngbegɔ marara Yesu. Ɔwɛ̃ si i sitikpe fiɛ ɔwɛ̃ ana si i ngbalɔ. ");
INSERT INTO akp_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ne makarɛ wũ sɔ, “Ɔrɔ̃go, be ɔso ato abiɛ?” Ne ɔɣere ma sɔ, “Manyiiɔ ɔsu wũ ɔkɔse maruigu fiɛ loiɣe ngbegɔ masu wũ masɛ.” ");
INSERT INTO akp_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Gɔ ɔpɛ ɔfiniki ne, ɔnya Yesu ɣɛ wũ i kɔrɛ, ɣɛɛ ɔ̃iɣe sɔ Yesu ɔɖe. ");
INSERT INTO akp_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ne Yesu ɔkarɛ wũ sɔ, “Ɔrɔ̃go, be ɔso ato abiɛ? Nna ato abie?” Ɣɛɛ Maria ɔbu sɔ ngɔ nto ɔnyɔ mmɔ iso ɔɖe, ne ɔso ɔɣere wũ sɔ, “Bokɔse, loto-ɔ i kukpa, si fɔ losu wũ asɛ i kakɔi karere ne, te me ngbegɔ asɛ wũ si losɛ loasu wũ.” ");
INSERT INTO akp_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Mmɔ i Yesu ɔkpere wũ sɔ, “Maria!” Gɔ Maria ɔfiniki ɔnyɔ wũ ne, ɔla kulu i si Hebrise ame sɔ, “Rabuni!” gɔ ne karɔ̃ nɖe sɔ Ratedze. ");
INSERT INTO akp_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ne Yesu ɔɣere wũ sɔ, “Daasimɔɛ̃ me, alasɔ loikɛlɛ Tete kɔrɛ i kato. Ɣɛɛ ne, kɛlɛ wũ manyiibi kɔrɛ si asɛ aaɣere ma sɔ, loto lokpese lokɛlɛ wũ Ɣaa gɔ nɖe ma Ɣaa gu wũ Ɔse gɔ nɖe ma Ɔse kɔrɛ.” ");
INSERT INTO akp_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ne ɔso Maria Magdalase ɔsɛ ɔ̃aɣere marasuãdze sɔ ɔnya Bosate fiɛ ka ɔɣere ma ara wa i Yesu ɔɣere wũ. ");
INSERT INTO akp_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kɔsiɖa gɔmɔ kutsuɛ ne, marasuãdze ɔsakanya. Masɛ̃ iyo mapia so ala mato manigã ma Yudase makpakpa. Ɔluwɛ̃ ne, Yesu ɔba ɔ̃aya i ma ndɛ̃ ɔɣere ma sɔ, “Isobuɛ itã mi.” ");
INSERT INTO akp_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Gɔ ɔɣere ma ngbɔ ɔro ne, ɔsu ɔ̃ nrɔɔ̃ gu iwãgɛsɛ ɔte ma. So ɔɣɔ marasuãdze gbaã alasɔ manya Bosate. ");
INSERT INTO akp_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ne Yesu ɔledza ma iɣere sɔ, “Isobuɛ itã mi, kumɛgɔ ame i Tete ɔpia me katɔ̃me ne, ngbɔ ame loto lopia mi ne.” ");
INSERT INTO akp_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ne ɔwarã ɔfere ma iso ɔɣere ma sɔ, “Mifɔ Siwarã Bielea. ");
INSERT INTO akp_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Si misu maturi akpi mitsɛ ma ne, Ɣaa to ɔ̃asu ɔtsɛ ma, ɣɛɛ si miisu mitsɛ ma ne, Ɣaa iibasu ɔtsɛ ma.” ");
INSERT INTO akp_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ɔwi gɔ i Yesu ɔba ma kɔrɛ ne, marasuãdze iweo-inyɔ ndɛ̃ ɔwɛ̃ gɔ nɖe Toma fiɛ masɛ marɔ sɔ Inyɔɔbi na i ma ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ne ɔso marasuãdze tsɔra ɔɣere wũ sɔ, “Bonya Bosate!” Ne Toma ɔɣere ma sɔ, “Gbɔgbɔɔgbɔ lonya aɣɛipã wa i ɔ̃ nrɔɔ̃, losu wũ kɔrɔ̃ lopia i apã wamɔ ame gu ɔ̃ iwãgɛsɛ ame ne, loibafɔ loɖe lonya.” ");
INSERT INTO akp_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ɖapɛ ɔwɛ̃ kama ne, marasuãdze pia i iyo fiɛ Toma ana ɔwe i ma ndɛ̃. Masɛ̃ akui mapia so ɣɛɛ Yesu ɔba ɔ̃aya i ma ndɛ̃. Ne ɔɣere ma sɔ, “Isobuɛ itã mi.” ");
INSERT INTO akp_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ne ɔɣere Toma sɔ, “Ba su fɔ irɔĩ pia i ngbe. Nyɔ wũ nrɔɔ̃ si asu fɔ kɔrɔ̃ apia i wũ iwãgɛsɛ ame. Nyua ɔwararã si afɔ aɖe!” ");
INSERT INTO akp_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ne Toma ɔɖi kanya sɔ, “Wũ Sate gu wũ Ɣaa!” ");
INSERT INTO akp_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ne Yesu ɔkarɛ wũ sɔ, “Ɔɔfɔ aɖe alasɔ ɔɔnya me? So aaɣɔ mma loisɛ manya fiɛ masɛ mafɔ me maɖe!” ");
INSERT INTO akp_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu ɔbara awawãra gbodzoo i ɔ̃ marasuãdze kɔrɛ wa maitsɛrɛ mapia i ɔko gɔgbe ame. ");
INSERT INTO akp_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ɣɛɛ matsɛrɛ nwagbe masɛ sɔ si aafɔ aɖe sɔ Yesu nɖe Kristo gu Ɣaa Ɔbi, fiɛ iki i ɔ̃ ifɔ iɖe ame ne, aana ngbã. ");
INSERT INTO akp_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nwagbe kama ne, Yesu ɔledza so iɖi ite ɔ̃ marasuãdze i Tiberia Ɔpo kanya. Kumɛgɔ ɔɖi so ɔte ma i ngbe ne. ");
INSERT INTO akp_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Iyi iwɛ̃ ne, Yesu marasuãdze mawɛ̃ ɔsikanya. Ma nɖe Simon Petro gu Toma gɔ masɛ marɔ sɔ Inyɔɔbi gu Nataniel gɔ lobɔrɛ i Kana i Galilea karɔ̃ iso gu Zebedeo mabi gu marasuãdze inyɔ mama. ");
INSERT INTO akp_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ne Simon Petro ɔɣere ma sɔ, “Losɛ akpɛ kaɖikɔ̃.” Ne matsɔra ana ɔɣɛ sɔ, “Bo wũ boaba bokɛlɛ.” Ne ɔso ma ɔɖuɖu ɔbo i ɔkolo ame makɛlɛ, ɣɛɛ kasɛ̃ ɔɖuɖu ne, maiɖi ikpɛ kuiwɛ̃. ");
INSERT INTO akp_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kaya gɔ kuɣɛ̃ ɔsɔ̃ kuto kuba ne, Yesu ɔba ɔ̃ɔya i ɔpo kanya, ɣɛɛ marasuãdze iiɣe sɔ ɔ̃ ɔɖe. ");
INSERT INTO akp_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ne ɔkpere ma ɔkarɛ sɔ, “Maporoporoi, miɔɖi akpɛ awɛ̃?” Matã wũ mmuai sɔ, “Ooɣo!” ");
INSERT INTO akp_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ne ɔɣere ma sɔ, “Mipia mi asabu i mi ɔkolo kuɖearɔ̃ iso ne mito miaɖi akpɛ.” Gɔ mapia asabu ne, maiwo ɔkpadzɛ̃ ala akpɛ gbodzoo wa mamɔɛ̃ ɔso. ");
INSERT INTO akp_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Rasuãdze gɔ i Yesu iisɛ ɔpia kuɣɛ ɔɣere Petro sɔ, “Bosate ɔɖe lo!” Gɔ Petro ɔnɔ sɔ Bosate ɔɖe ne, ɔsu ɔ̃ kato awu ɔkpasa alasɔ ɔɖi wã ɔsɛ. Ɔkɔlɛ ɔbo i ndu ame ɔɣa ndu ɔkɛlɛ ɔkpokpo. ");
INSERT INTO akp_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Marasuãdze tsɔra ɔsɛ ɔkolo ame maba mato makpadzɛ̃ asabu wa loyi ku akpɛ. Ma gu ɔkpokpo ndɛ̃ aaɖe lɛ nrɔɔ̃ siru kere. ");
INSERT INTO akp_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Gɔ maso i ɔkpokpo ne, manya sɔ mapia ɔtɔ i mmɔ ikpɛ sia iso, abolo ana se i mmɔ. ");
INSERT INTO akp_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ne Yesu ɔɣere ma sɔ, “Miɖi akpɛ wa mimɔɛ̃ awɛ̃ mibɔ.” ");
INSERT INTO akp_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ne Simon Petro ɔya ɔbo i ɔkolo ame ɔkpadzɛ̃ asabu wa loyigu akpɛ siare ɔbɔ ɔkpokpo ne. Akpɛ ɔɖuɖu ɖe kulafa gu siru-atɛ, ɣɛɛ atoa sɔ asi ngbɔ ne, asabu iikɛkɛ. ");
INSERT INTO akp_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ne kama ne, Yesu ɔɣere ma sɔ, “Miba miaɖe ara.” Ɣɛɛ ma kuwɛ̃ iiwe ɔtu ɔkarɛ wũ sɔ, “Fɔ nɖe nna?” alasɔ maɣe sɔ Bosate ɔɖe. ");
INSERT INTO akp_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ne Yesu ɔbore ɔbo ɔsu abolo ɔtã ma, ne kama ne, ɔsu ikpɛ ana ɔtã ma. ");
INSERT INTO akp_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nnɛgbe nɖe ɔkpɛ tɛare gɔ i Yesu ɔɖi so ɔte ɔ̃ marasuãdze gɔ ɔta ɔbɔrɛ i makpise ame ne. ");
INSERT INTO akp_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Gɔ maɖe ara maro ne, Yesu ɔkarɛ Simon Petro sɔ, “Simon, Yohanes ɔbi, ato aɖɔɛ me aɖo matsɔra magbe?” Ne Petro ɔɣɛ sɔ, “Aĩ, Bosate, fɔ mɔmɔ aɣe sɔ loto loɖɔɛ-ɔ.” Ne Yesu ɔɣere wũ sɔ, “Nyɔ wũ asɛrɛbi iso.” ");
INSERT INTO akp_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ɔkpɛ nyɔare ne, Yesu ɔledza wũ ikarɛ sɔ, “Simon, Yona ɔbi, ato aɖɔɛ me?” Ne Petro ɔledza iɣɛ sɔ, “Aĩ, Bosate, fɔ mɔmɔ aɣe sɔ loto loɖɔɛ-ɔ.” Ne Yesu ɔɣere wũ sɔ, “Nyɔ wũ masɛrɛ iso.” ");
INSERT INTO akp_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ɔkpɛ tɛare ne, Yesu ɔledza Petro ikarɛ sɔ, “Simon, Yona ɔbi, ato aɖɔɛ me?” Iɖaa Petro, alasɔ Yesu ɔledza wũ ikarɛ ɔkpɛ tɛare sɔ ato aɖɔɛ me, ne ɔso ɔtã mmuai sɔ, “Bosate! Fɔ mɔmɔ aɣe ira biara, fiɛ aɣe sɔ loto loɖɔɛ-ɔ.” Ne Yesu ɔɣere wũ sɔ, “Nyɔ wũ masɛrɛ iso. ");
INSERT INTO akp_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Gbaã loto loɣere-ɔ sɔ ɔwi gɔ aɖe ɔporoporoi ne, asɛ aledza so abɔrɛ asɛ ngbegɔ aɖɔɛ, ɣɛɛ si ɔɔbe ne, ato atara fɔ nrɔɔ̃ kato, ɔturi mama ɔnyi-ɔ ɔkati, ɔkɔ-ɔ ɔkɛlɛgu ngbegɔ aito abie sɔ aasɛ.” ");
INSERT INTO akp_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu ɔɣɛ nnɛgbe si ɔsu ɔte kukpi gɔ igbã i Petro aakpi ɔsu ɔkɔlɛ Ɣaa iyere kato. Gɔ ɔɣɛ ngbɔ ɔro ne, ɔɣere wũ sɔ, “Siai me.” ");
INSERT INTO akp_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ne gɔ Petro ɔfiniki ne, ɔnya rasuãdze gɔ i Yesu iisɛ ɔpia kuɣɛ sɔ ɔɣɛ i mmɔ. Rasuãdze gɔgbe ɔɖe lopiɛtɛ i Yesu iso ku ɔwi gɔ mato maɖe kutsuɛ aɖera ɔkarɛ Yesu sɔ, “Bosate, nna loaɖi-ɔ ɔtã ne.” ");
INSERT INTO akp_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ne ɔso gɔ Petro ɔnya wũ ne, ɔkarɛ Yesu sɔ, “Bosate, ne ngɔgbe ɔ̃ ne, nda iase wũ?” ");
INSERT INTO akp_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ne Yesu ɔtã wũ mmuai sɔ, “Si mme sɔ ɔsɛ gbɔgbɔɔgbɔ loakpese loba ne, be isu-ɔ i mmɔ? Fɔ ne, siai me.” ");
INSERT INTO akp_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Nnɛgbe ɔso ne, iki ikã i marasuãdze ndɛ̃ sɔ rasuãdze gɔmɔ iibakpi. Ɣɛɛ Yesu iiɣɛ sɔ ɔ̃ibakpi, ɔɣɛ ɔɣɛ sɔ, “Si mme sɔ ɔsɛ gbɔgbɔɔgbɔ loakpese loba ne, be isu-ɔ i mmɔ?” ");
INSERT INTO akp_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Rasuãdze gɔgbe ɔɖe loɣɛ ara wagbe fiɛ ɔtsɛrɛ wã ɔsɛ fiɛ boɣe sɔ nnɛ ɔɣɛ ne, gbaã iɖe ne. ");
INSERT INTO akp_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu ɔbara ara gbodzoo gɔ si sɔ matsɛrɛ wã ɔɖuɖu masɛ iwɛ̃ iwɛ̃ ne, lofɔ loɖe sɔ kayiiso ɔɖuɖu iibana siko dzɛmɔ karɔ̃kasɛkɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Wũ ɔnyii Tiofilo, i wũ ɔko ɖeakatɔ̃ ame ne, lotsɛrɛ loɣere-ɔ ara wa ɔɖuɖu i Yesu ɔbara gu nwa ɔte, ");
INSERT INTO akp_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ita i ɔwi gɔ ɔsɛ ɔ̃ karabara karɔ̃ isɛ iabo ɔwi gɔ i Ɣaa ɔsu wũ ɔkɛlɛgu kato. Si ɔ̃akɛlɛ kato ne, Yesu ɔki i Siwarã Bielea ɔle iso ɔte katɔ̃memasɛdze ma ɔɖi ɔtã so ara. ");
INSERT INTO akp_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","I ɔ̃ kukpi kama ne, ɔɖi so ɔte ma i siri agbãagbã iso i ayi sina ame sɔ gbaã ne, ɔpia ngbã. Ɔɖe mma lonya wũ ika i Ɣaa sigarakaɖekɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ɔwi ɔwɛ̃ gɔ masakanya ne, ɔsɛ̃ ɔtã ma sɔ, “Midaarui i Yerusalem. Ɣɛɛ miwe misia Siwarã Bielea dzɛ loɣere mi sɔ wũ Ɔse ɔɣɛ ɔsɛ sɔ ɔ̃atã mi. ");
INSERT INTO akp_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohanes ne, ndu miɖe ɔsu ɔbara Ɣaa itupie kubarara ɔtã maturi. Ɣɛɛ ayi kɛkɛĩ ame ne, Ɣaa to ɔ̃asu Siwarã Bielea ɔpie mi.” ");
INSERT INTO akp_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Gɔ katɔ̃memasɛdze gu Yesu ɔledza isarɛ ne, makarɛ wũ sɔ, “Bosate, kiniɔkiniɔ ato abie sɔ aaledza Israel sigarakaɖekɔ̃ itara?” ");
INSERT INTO akp_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ne Yesu ɔɣere ma sɔ, “Iinya sɔ miatsue ɔwi ɣee ayi wa i Tete ɔɣɛ ɔsɛ i ɔ̃ ɔle ame sɔ nnɛmɔ aaba. ");
INSERT INTO akp_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ɣɛɛ ne, mito miafɔ ɔle ɔwi gɔ i Siwarã Bielea ɔɔba mi iso, miaɣɛ wũ itɔ̃me ita i Yerusalem gu Yudea ɔɖuɖu gu Samaria isɛ iabo kayiiso katsɔrakɔ̃.” ");
INSERT INTO akp_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Gɔ ɔɣere ma ara wagbe ɔro ne, Ɣaa ɔsu wũ ɔkɛlɛgu kato gɔ maɣɛ mato manyɔ wũ gbɔgbɔɔgbɔ ɔbo i idɔdɔ ame fiɛ ɔyu ma i anɔ. ");
INSERT INTO akp_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Gɔ maɣɛ mato manyɔ ɔ̃ kuɖokpo ikɛlɛ ne, ɔluwɛ̃ marɛrɛ̃ inyɔ mawɛ̃ ma mpia ara fudza ɔɖi so mate ma, ");
INSERT INTO akp_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ne maɣere ma sɔ, “Galilea marɛrɛ̃, be ɔso fiɛ miɣɛ minyɔ kato ngbɔ? Yesu gɔ i Ɣaa ɔfɔ ɔbɔrɛgu i mi kɔrɛ fiɛ ɔkɛlɛ kato ne, ɔto ɔ̃aledza ikpese iba lɛ kumɛgɔ minya wũ ɔse fiɛ ɔkɛlɛ kato.” ");
INSERT INTO akp_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ne kama ne, katɔ̃memasɛdze ɔso mabɔrɛ i kube gɔ marɔ sɔ Nnɔĩ adziri Kube iso makɛlɛ Yerusalem. Ita i mmɔ ibo ɔmagɛ̃ ame aaɖe lɛ igu iwɛ̃ kere. ");
INSERT INTO akp_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Gɔ masɛ maabo ɔmagɛ̃ ame ne, maya makɛlɛ ma kawekɔ̃ i iyo nɛ matsue masia iso ame. Mma lowe i mmɔ nɖe Petro gu Yohanes gu Yakobo gu Andrea gu Filipo gu Toma gu Bartolomeo gu Mateo gu Yakobo gɔ nɖe Alfeo ɔbi gu Simon gɔ nto ɔkpɛ̃ ɔtã isɛguso gu Yuda gɔ nɖe Yakobo ɔbi. ");
INSERT INTO akp_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mmagbe ɔɖuɖu gu marɔ̃go mawɛ̃ gu Yesu ɔnyi Maria gu Yesu makpeama ɔwe adzuni awɛ̃ mala maɔsarɛ maɔkparama kayi ɔwi biara. ");
INSERT INTO akp_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ayi wamɔ ame ne, mma lofɔ maɖe ɔba maasarɛ, maaɖe lɛ maturi kulafa gu sinyɔ. Ne Petro ɔta ɔya ɔɣere ma sɔ, ");
INSERT INTO akp_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Wũ manyii, ara wa matsɛrɛ i Ɔko Sekelea ame ne, ikote sɔ iaba i ne ame lɛ kumɛgɔ i Siwarã Bielea ɔki i Igara David iso ɔɣɛ ɔsɛ kokooko i Yuda gɔ loɖi Yesu ɔtã mamɔɛ̃ iso. ");
INSERT INTO akp_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda ɔ̃ wũ ɔɖe bo ikuri ame ɔwɛ̃ gɔ i Bosate ɔɖi sɔ tee ɔ̃abara katɔ̃memasɛdze karabara.” ");
INSERT INTO akp_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Masu ɔ̃ ikpi sikã dzɛ ɔfɔ maɣa karɔ̃ ga iso ɔsɛ ɔ̃akpi. Gɔ ɔkpase ne, ɔfã ɔbiɛ, ne ɔ̃ ayirira ɔɖuɖu ɔbɔrɛ afere i karɔ̃ ne. ");
INSERT INTO akp_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ɔ̃ kukpi itɔ̃me ɔki ikã i Yerusalem maturi ɔɖuɖu ɔnɔ ne. Ngbegɔ ɔkpi masɛ makpere sɔ Hakeldamak i ma siɖe ame gɔ karɔ̃ nɖe sɔ Ima Karɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ne Petro ɔkɛlɛgu i katɔ̃ sɔ, “Matsɛrɛ i David Kuka Ɔko ame sɔ, ‘Ɔ̃ iyo si ikpese iyoku, kuwɛ̃ si ɔdaasɛ i mmɔ.’ Matsɛrɛ ana sɔ, ‘Mitã sɔ ɔturi mama si ɔya i ɔ̃ kanya.’ ");
INSERT INTO akp_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ne ɔso ne, ikote sɔ ɔmama aabo i bo ndɛ̃ lɛ aɖansiɛ ɔtã Bosate Yesu ita ibɔrɛ i makpise ame. Iaɖe ngɔ lowe i bo ikuri ame ku ɔwi gɔ ɔɖuɖu i bo gu Yesu sɛ boki, ");
INSERT INTO akp_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ita i ɔwi gɔ i Yohanes ɔpɛ Ɣaa itupie kubarara imomo isɛ iabo ɔwi gɔ i Ɣaa ɔsu Yesu ɔkɛlɛgu kato.” ");
INSERT INTO akp_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ne ɔso maɖi maturi inyɔ ma nɖe Matia gu Yosef gɔ masɛ makpere sɔ Barsaba, ana ne, masɛ makpere wũ sɔ Yusto. ");
INSERT INTO akp_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ne kama makparama kayi maɣɛ sɔ, “Bosate, fɔ nɣe maturi ɔɖuɖu adzuni ame. Ne ɔso te bo ngɔ aɖi i maturi inyɔ magbe ndɛ̃ ");
INSERT INTO akp_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","sɔ ɔ̃aya i katɔ̃memasɛdze ndɛ̃ ngbegɔ i Yuda ɔnyua fiɛ ɔkɛlɛ ngbegɔ lokote wũ.” ");
INSERT INTO akp_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Gɔ makidza atalebi sɔ si masu manyɔ sɔ ma nna i Ɣaa ɔɖi ne, Matia ɔkpɛ loya, ne ɔso masu wũ mabua i katɔ̃memasɛdze iweo-ɔwɛ̃ mamɔ iso. ");
INSERT INTO akp_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Gɔ iyi nɛ masɛ makpere sɔ Pentekoste Iyi ɔɣo ne, mafɔɖedze ɔɖuɖu ɔsakanya i kakɔi kawɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ɔluwɛ̃ ne, manɔ kulu lɛ ɔwiri nto ɔkpɛ̃ teteree kubɔrɛ i kato. Kulu gɔgbe ɔba kuayi iyo nɛ ame mapia ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ira iwɛ̃ nɛ nse lɛ ɔtɔ sinyagɛmi ɔɣɛɣɛ so iba iasia i ma ati iso. ");
INSERT INTO akp_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Siwarã Bielea ɔbo i ma ɔɖuɖu ame matsɛ ikaɖe mato male Ɣaa i siɖe agbãagbã ame lɛ kumɛgɔ i Siwarã ɔtã ma ɔle. ");
INSERT INTO akp_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ɔwi gɔgbe ame tutuutu ne, ma Yudase ma nsɛ manigã Ɣaa fiɛ mase i kayiiso abuiti ɔɖuɖu ame ɔba mapia i Yerusalem. ");
INSERT INTO akp_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Gɔ manɔ kulu gɔgbe ne, maturi gbodzoo ɔtere makɛlɛ mmɔ. Gɔ manya sɔ Yesu masiaidze nɣɛ mato maɣɛ abuiti ɔɖuɖu wa ame mabɔrɛ siɖe ne, ibara ma ɣii. ");
INSERT INTO akp_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ne ɔso ifɔ̃ ɔtidza ma, makpɔkpɔtɔ, ne matsɛ ikarɛ so sɔ, “Mmagbe ɔɖuɖu ne, iiɖe Galilea maturi maɖe? ");
INSERT INTO akp_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nda ibara fiɛ boto bonɔ maɖe ika i bo abuiti siɖe ame? ");
INSERT INTO akp_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ma Partise gu ma Mediase gu ma Elamse gu mawɛ̃ ma lobɔrɛ i Mesopotamia gu Yudea gu Kapadokia gu Ponto gu Asia gu ");
INSERT INTO akp_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia gu Pamfilia gu Egipte gu Libia kasɛ ga lomatã Kirene gu mafɔ ma lobɔrɛ i Roma fiɛ maɖe ma Yudase gu mma lokpese ma Yudase ikuri ame maturi, ");
INSERT INTO akp_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","gu ma Kretase gu ma Arabiase. Bo ɔɖuɖu to bonɔ mato mafa Ɣaa kaɣiɖu i bo siɖe ame.” ");
INSERT INTO akp_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Gɔ ibara ma ɣaa fiɛ makpɔkpɔtɔ ne, makarɛ so sɔ, “Mme itɔ̃me igbã iɖe ngbe?” ");
INSERT INTO akp_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ne mawɛ̃ to maɣɛ sɔ, “Ndã miɖe nto mimɔɛ̃ ma. Iiɖe kuira iɖe.” ");
INSERT INTO akp_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Mmɔ i Petro gu maturi iweo-ɔwɛ̃ ɔta maya fiɛ Petro ɔkɔlɛ ɔ̃ silɔ sɔ, “Mi ma Yudase gu mi ma nsi i Yerusalem ɔɖuɖu, lobie sɔ loaɖi ara wagbe karɔ̃ lote mi. Mikã me atsue kukaakɔ si minɔ. ");
INSERT INTO akp_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Marɛrɛ̃ magbe iito marɛ̃ ndã lɛ kumɛgɔ mibu. Mi mɔmɔ minya sɔ kaya iɖɔwũ kaiwɛ̃ ame kere bopia. ");
INSERT INTO akp_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ɣɛɛ ne, nnɛ mito minya ngbe nɖe nnɛ i Ɣaa Kanyaɖidze Yoel ɔɣɛ ɔsɛ kokooko. ");
INSERT INTO akp_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ɔɣɛ sɔ, ‘Ɣaa ɔɣɛ sɔ, “Ayi tsɔra ame ne, nto loafedza wũ Siwarã lofere i maturi ɔɖuɖu iso. Mi mabibirɛrɛ̃ gu mabi birɔ̃gomi to maaɣɛ wũ itɔ̃me, mi maporoporoi to maanya kaɖikate, mi makpakpa ana to maasɛ̃ arɛ. ");
INSERT INTO akp_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Gbaã ne, i ayi wamɔ ame ne, wũ Siwarã to siaba wũ maɖabo rɔ̃go gu marɛrɛ̃ iso, fiɛ maaɣɛ wũ itɔ̃me. ");
INSERT INTO akp_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Loatã sɔ awawãra wa loabara ɣii aabɔrɛ i kuɖokpo gu karɔ̃ iso ɔɖuɖu. Mito mianya ima gu ɔtɔ gu kuɣɔ gɔ lota lipii. ");
INSERT INTO akp_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kuɣɛ̃ to kuabara kpinaa. Ɔgbaworeti to ɔ̃arɛtɛ lɛ ima, fiɛ kuɖokpo Ɔlesate iyi siare nɛmɔ aaba. ");
INSERT INTO akp_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ɔwi gɔmɔ ame ne, ɔbiara gɔ loakpere Ɣaa sɔ ɔnyɔ wũ nnya aana ngbã.” ’ ” ");
INSERT INTO akp_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ne Petro ɔɣɛ ana sɔ, “Bo aɖe Israel kaɖe, mito minɔ? Yesu Nasaretse nɖe ngɔ i Ɣaa kɔrɔ̃ sia iso fiɛ ɔsɔla wũ nnɔĩ. Ɣaa ɔsia nnɛgbe ita gɔ ɔki i ɔ̃ iso ɔɖi ɔle gu awawãra gu akparĩ ɔte i mi ndɛ̃ lɛ kumɛgɔ i mi mɔmɔ miɣe. ");
INSERT INTO akp_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ɣɛɛ i Ɣaa ɔri iɖi ame gu ɔ̃ itsue iɖegu katɔ̃ ame ne, ɔnyua wũ ɔtã mi. Mi gu matilese ɔɖi wũ miɖoe ku ɔwi gɔ mipɛ wũ mimatãra i kudziri iso. ");
INSERT INTO akp_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ɣɛɛ Ɣaa ɔtara wũ ɔbɔrɛgu i makpise ame. Ɔbɔrɛ i kukpi nrɔɔ̃ ame, alasɔ kukpi iiwo wũ ɔmɔɛ̃ ɔpia i kugbagɔrɔĩ ame. ");
INSERT INTO akp_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Igara David ɔɣɛ ɔsɛ i ɔ̃ iso sɔ, ‘Lonya sɔ Bosate ɣɛ me i kɔrɛ ɔwi biara. Gɔ ɔɣɛ me i kuɖearɔ̃ iso ɔso ne, loibanigã. ");
INSERT INTO akp_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nnɛgbe ɔso ne, wũ ɔtu ɔyi ku isoɣɔ, loasu silɔ lole wũ ɔwi ɖaa. Loawe i ɔriinyɔ ame atoa sɔ wũ sosina to siakpi. ");
INSERT INTO akp_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Alasɔ aibanyua wũ ɔkala atã ikpibiɔ. Ana ne, aibatã fɔ Ɔbi Sekelea sina ɔburi. ");
INSERT INTO akp_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ate me fɔ ngbã ɔri. Fɔ kɔrɛ iwe isoɣɔ pia i wũ ame gbaã.’ ");
INSERT INTO akp_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Ne ɔso ne, wũ manyii, nto loɣere mi kukaakɔ sɔ bo ɔwa David ɔkpi. Mabiara wũ. Ɔ̃ ikpibiɔ ana se i bo ndɛ̃ ipɛ i nɔme. ");
INSERT INTO akp_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ɣɛɛ ne, Ɣaa kanyaɖidze ɔɖe. Ɣaa ɔkarã irɔĩ iso sɔ ɔ̃abara David ɔwa tɛtɛ ɔɖe sigara i David sigaraiyara iso. ");
INSERT INTO akp_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Gɔ David ɔnya nnɛ nse i katɔ̃ ɔso ne, ɔɣɛ ɔsɛ sɔ Kristo to ɔ̃ata ɔbɔrɛ i makpise ame. Ɔɣɛ sɔ, ‘Ɔ̃ibanyua wũ ɔtã kukpi fiɛ ɔ̃ibanyua ɔ̃ sina ɔburi i ikpibiɔ ame.’ ");
INSERT INTO akp_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesu gɔgbe i Ɣaa ɔtara ɔbɔrɛgu i makpise ame ɔso i bo ɔɖuɖu ɖe itɔ̃me nɛgbe maɖansiɛ ne. ");
INSERT INTO akp_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kiniɔ ne, ɔ̃ Ɔse Ɣaa ɔtã wũ kasɛkɔ̃ kɔlɛa i ɔ̃ kuɖearɔ̃ iso, ɔsu Siwarã Bielea ɔtã wũ lɛ kumɛgɔ ɔɣɛ ɔsɛ fiɛ mito minya, minɔ ana ngbe. ");
INSERT INTO akp_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Iiɖe David lota ɔbɔrɛ i makpise ame ɔkɛlɛ kato. Ɣɛɛ ne, ɔɣɛ ɔsɛ sɔ, ‘Bosate Ɣaa ɔɣere wũ Sate sɔ, “Sɛ i wũ kuɖearɔ̃ iso, ");
INSERT INTO akp_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","gbɔgbɔɔgbɔ loasu fɔ matsirise lopia i fɔ ngba kayirinɔ.” ’ ");
INSERT INTO akp_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ne ɔso nto lobie sɔ loɣere mi Israel kaɖe ɔɖuɖu sɔ, Ɣaa ɔɖe lobara Yesu gɔ mipɛ mimatãra i kudziri iso sɔ ɔ̃ɔkpese Bosate gu Kristo.” ");
INSERT INTO akp_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Gɔ manɔ Petro atɔ̃me ne, itsue ma situ. Ne ɔso makarɛ wũ gu katɔ̃memasɛdze tsɔra sɔ, “Bo manyii, be si bobara?” ");
INSERT INTO akp_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ne Petro ɔɣere ma sɔ, “Ikote sɔ mi ɔbiara kɛkɛ aanyua ikpi ɔbara ɔfiniki ɔba Bosate kɔrɛ, ɔfɔ Ɣaa itupie kubarara i Yesu Kristo iyere ame sɔ Ɣaa asu ɔ̃ akpi ɔtsɛ wũ iyɔ miɔfɔ Siwarã Bielea lɛ kumɛgɔ ɔɣɛ ɔsɛ. ");
INSERT INTO akp_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nnɛ ɔɣɛ ɔsɛ ne, ise itã mi gu mi mabi gu mma lobɔrɛ i kadzorokɔ̃. Mma ɔɖuɖu i Bosate Ɣaa aakpere ɔbɔ ɔ̃ kɔrɛ.” ");
INSERT INTO akp_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petro ɔɣere ma ara gbodzoo, ɔpɛ ma nrɔɔ̃, ɔtã ma kuka sɔ, “Miɖi so mibɔrɛgu i kutsue ikpadzɛ̃ nɛ nto iaba i ɔɣekparɛ nyanyarĩa gɔgbe iso.” ");
INSERT INTO akp_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nɛgbe ɔso ne, maturi gbodzoo i ma ndɛ̃ ɔfɔ Petro itɔ̃me maɖe, ne mapie ma ndu i Yesu iyere ame gɔ maaɖe lɛ maturi kukpi kutɛ. Masu so mabua i mma lofɔ Ɣaa maɖe iso ku iyi nɛmɔ. ");
INSERT INTO akp_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Mana ɔwi matã katɔ̃memasɛdze. Ne ɔso mate ma ara, makparama kayi, maɖe ara masakanya fiɛ masɛ i kanya kawɛ̃ ibara ame ana. ");
INSERT INTO akp_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kumɛgɔ i katɔ̃memasɛdze ɔbara awawãra gu akparĩ ɔtã maturi ɔsu kuwarɛ matã Ɣaa. ");
INSERT INTO akp_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Mafɔɖedze ɔɖuɖu ɔla maɔsarɛ ɔwi biara, ana ne, ibiara nɛ i ɔwɛ̃ ba ne, ma ɔɖuɖu ire iɖe. ");
INSERT INTO akp_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Si marɔdɛ̃ ma ira irere ne, masɛ masu sikã maɣɛ so kumɛgɔ inya ɔbiara kanya. ");
INSERT INTO akp_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Mala maɔsɛ Ɣaa iyo iyi biara kɛkɛ, ana ne, mala maɔsarɛ i akuri akuri ame i ma ayo maɔɖe ara i isoɣɔ gu ɔtu sekelea ame. ");
INSERT INTO akp_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Mala maɔpɛ Ɣaa siba maɔle wũ ana, ne ɔso maturi ɔɖuɖu sɛ mawarɛ ma. Iyi biara Bosate ɔla ɔ̃ɔsu mma lona iɖi ɔ̃ɔbua i ma iso. ");
INSERT INTO akp_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Iyi iwɛ̃ ne, Petro gu Yohanes ɔkɛlɛ Isɔrɛyo ku kakɔme iɖɔwũ itɛ ame, ɔwi gɔ i ma Yudase sɛ makparama kayi. ");
INSERT INTO akp_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Gɔ mabo kayogodɔ̃ ga masɛ marɔ Kulɛ Kayogodɔ̃ ne, manya ɔrɛrɛ̃ ɔwɛ̃ gɔ nɖe bafã ita i ɔwi gɔ maɣe wũ. Ɔ̃ masate sɛ masu wũ masɛ i mmɔ iyi biara sɔ si ɔla ɔ̃ɔwanyi ara i mma nsɛ maki i mmɔ makɛlɛ Isɔrɛyo ame kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Gɔ ɔnya Petro gu Yohanes to mafe mabo iyo ne, ɔkarɛ ma sɔ matã wũ sikã. ");
INSERT INTO akp_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Matui maya manyɔ wũ totoroo, ne Petro ɔɣere wũ sɔ, “Nyɔ bo!” ");
INSERT INTO akp_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ɔrɛrɛ̃ gɔmɔ ɔkɔlɛ anɔ ɔto ɔnyɔ ma ku adzuni sɔ mato maba maatã wũ ira iwɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ne Petro ɔɣere wũ sɔ, “Mme lona sikã kusiwɛ̃ loatã-ɔ! Ɣɛɛ ne, loatã-ɔ nnɛ loba! Loɣere-ɔ i Yesu Kristo Nasaretse iyere ame sɔ ta ya si asɛ!” ");
INSERT INTO akp_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Petro ɔmɔɛ̃ wũ kuɖearɔ̃ sɔ ɔta ɔya. Ɔluwɛ̃ ne, ɔle ɔbo i ɔ̃ ngba gu akpakpokpo ame! ");
INSERT INTO akp_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ne ɔkɔlɛ ɔɣo ɔtsɛ isɛ ɔsiai ma ɔbo Isɔrɛyo ame ɔsɛ ɔkiki ɔkɔlɛ ɔɣo ɔle Ɣaa ne. ");
INSERT INTO akp_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Gɔ maturi ɔɖuɖu ɔnya wũ ɔsɛ ɔto ɔle Ɣaa, ");
INSERT INTO akp_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","fiɛ matsue sɔ ɔ̃ nsɛ ɔɖɔɛ ɔsɛ i Isɔrɛyo Kulɛ Kayogodɔ̃ ɔwanyi ara ne, makpɔkpɔtɔ, ibara ma ɣaa i kumɛgɔ ɔsarɛ iti. ");
INSERT INTO akp_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Maturi ɔɖuɖu ɔtere maba ngbegɔ marɔ sɔ Salomo Kakpakɛ i Isɔrɛyo ame. Maba maanya ɔrɛrɛ̃ gɔ losarɛ ɔɖo ɔmatã Petro gu Yohanes iso kpa gɔ ɔ̃ isarɛ ɔbara ma ɣii. ");
INSERT INTO akp_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Gɔ Petro ɔnya maturi ne, ɔɣere ma sɔ, “Israel kaɖe, be ɔso fiɛ nnɛgbe to ibara mi ɣaa? Be ɔso fiɛ mito minyɔ bo lɛ sɔ bo isekele kaɖu ɣee bo ɔle ame iɖe bobara ngɔgbe ɔsarɛ! ");
INSERT INTO akp_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ɣaa gɔ nɖe Abraham gu Isak gu Yakob gu bo mawa Ɣaa ne, ɔ̃ loɔkɔlɛ ɔ̃ Ɔbi Yesu kato ne. Misɛ̃ wũ i Pilato katɔ̃ sɔ miiɣe wũ gɔ Pilato ɔbie sɔ si ɔnyua wũ. ");
INSERT INTO akp_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Misɛ̃ ɔturi Sekelea gu Ɔbɔlɔlɔa, ɣɛɛ minɔ karɔ̃ sɔ ɔnyua turiɖoese i ɔ̃ kanya ɔtã mi. ");
INSERT INTO akp_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Miɖoe ngɔ nsɛ ɔtã maturi ngbã. Ɣɛɛ ne, Ɣaa ɔledza wũ itara ibɔrɛgu i makpise ame. Bo mɔmɔ bonya wũ ku bo anɔ. ");
INSERT INTO akp_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Iki i Yesu iyere ame fiɛ ɔrɛrɛ̃ gɔ miɣe fiɛ mito minya ngbe ɔna isosarɛ. Gɔ ɔfɔ Yesu ɔɖe ɔso ne, Bosate ɔtã wũ isosarɛ nɛ loyi fiɛ mi ɔɖuɖu to minya. ");
INSERT INTO akp_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Manyii, loɣe sɔ idaatsue lotã mi gu mi makpakpa ɔbara nnɛgbe. ");
INSERT INTO akp_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ɣɛɛ ne, Ɣaa ɔki i kanyamaɖidze ɔɖuɖu iso ɔɣɛ ɔsɛ sɔ Kristo to ɔ̃aki i ibo nɛmɔ igbã ame. Ne ɔso fiɛ ɔtã ma atɔ̃me ɔba i ne ame ne. ");
INSERT INTO akp_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ne ɔso mifiniki misiai Ɣaa si ɔsu mi akpi ɔtsɛ mi si isobuɛ aaba ibɔrɛ i Ɔ̃ kɔrɛ, ");
INSERT INTO akp_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","iyɔ ɔ̃ɔsese mi Kristo gɔ i ɔ̃ mɔmɔ ɔɖi ɔsɛ mi. ");
INSERT INTO akp_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ipia sɔ Yesu aawe i kato gbɔgbɔɔgbɔ ɔwi gɔ i ɔ̃ Ɔse aasu ira biara ɔsɛ i ne kasekɔ̃ lɛ kumɛgɔ ɔɣɛ koko ɔkigu i ɔ̃ kanyamaɖidze sekelea iso. ");
INSERT INTO akp_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Lɛ kumɛgɔ i Mose ɔɣɛ sɔ, ‘Bosate gɔ nɖe mi Ɣaa to ɔ̃asese mi kanyaɖidze mama ɔbɔrɛgu i mi ndɛ̃ lɛ me. Ne ɔso mikã wũ atsue i ibiara nɛ ɔ̃aɣere mi ame. ");
INSERT INTO akp_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ɔbiara gɔ loibakã ɔ̃ itɔ̃me atsue ne, Ɣaa aaɖi wũ ɔbɔrɛgu i ɔ̃ maturi ndɛ̃ pelepele.’ ");
INSERT INTO akp_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Gbagbaã ne, Ɣaa kanyamaɖidze ɔɖuɖu ita i Samuel iso ne, maɣɛ masɛ koko i ara wa nto aaba ku ayi wagbe ame. ");
INSERT INTO akp_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mi nɖe Ɣaa kanyamaɖidze mabi, fiɛ Ɣaa mɔmɔ lonyi kanya ku mi mawa ɔkigu i ɔ̃ kanyamaɖidze iso. Ɔɣere Abraham sɔ iaki ɔ̃ ɔwa tɛtɛ iso ɔ̃atã kayiiso ɔɖuɖu iwarã gu isobuɛ. ");
INSERT INTO akp_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ne ɔso gɔ Ɣaa ɔɖi ɔ̃ ɔɖabo Kristo ne, ɔɖe katɔ̃ ɔpia wũ mi kɔrɛ sɔ ɔtã mi kusɛkusɛ si mi ɔbiara aafiniki ɔbɔrɛ i mi akpi ame.” ");
INSERT INTO akp_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ɔwi gɔ i Petro gu Yohanes ɣɛ mato maɖe maturi ika ne, masɔrɛdze gu isɔrɛyo madzuɛ̃se ɔkpakpa gu ma Zadukise mawɛ̃ ɔba maabo mmɔ. ");
INSERT INTO akp_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Gɔ manɔ sɔ Petro gu Yohanes ɣɛ mato mate ara sɔ mma loɔkpi to maaledza ita lɛ kumɛgɔ i Yesu ɔta ɔbɔrɛ i makpise ame ne, sikpã ɔkpɛ̃ ma gbaã. ");
INSERT INTO akp_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ne ɔso mamɔɛ̃ ma. Gɔ kaɖe ɔɔro ɔso ne, masu ma mapia i iyo gbɔgbɔɔgbɔ kaɖesɛ̃a. ");
INSERT INTO akp_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ɣɛɛ maturi gbodzoo ma lonɔ atɔ̃me wagbe ɔfɔ Itɔ̃me Bielea maɖe. Mafɔɖedze kusime ɔba iaɖe lɛ marɛrɛ̃ kukpi kuru ɔɖui. ");
INSERT INTO akp_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Gɔ kaɖe ɔsɛ̃ ne, ma Yudase matɔ̃ɖedze gu kaɖe makpakpa gu mmara matedze ɔsarɛ i Yerusalem. ");
INSERT INTO akp_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Masarɛgu sɔrɛdzekpakpa pelepele Hana gu Kayafa gu Yohanes gu Aleksandro gu sɔrɛdzekpakpa pelepele manyii mawɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ne ka maɖi Petro gu Yohanes mabɔ i ma katɔ̃ makarɛ ma sɔ, “Nna iyere gu ɔle ame iɖe mibara ara wagbe?” ");
INSERT INTO akp_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Mmɔ i Petro gɔ loyi ku Siwarã Bielea ɔle ɔɣere ma sɔ, “Bo matɔ̃ɖedze gu makpakpa, ");
INSERT INTO akp_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","si mikarɛ sɔ bokparara kayiribielea ga bobara bafã gɔgbe gu kumɛgɔ bosa wũ ne, ");
INSERT INTO akp_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","mitã loɣere mi gu Israel kaɖe ɔɖuɖu ira iwɛ̃. Iki i Yesu Kristo gɔ lobɔrɛ i Nasaret iyere ame, ngɔ mipɛ mimatãra i kudziri iso, fiɛ Ɣaa ɔledza wũ itara ibɔrɛgu i makpise ame iyere ame i ngɔgbe ɔna isosarɛ. ");
INSERT INTO akp_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu gɔgbe iso i Ɔko Sekelea ɔɖe ika sɔ, ‘Ita nɛ i mi mayotsuedze ɔsɛ̃ ne, ne lokpese ita nɛ lofɔ kuɣa iɖo ata ɔɖuɖu ne.’ ");
INSERT INTO akp_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ɔ̃ ɔnɔwɛ̃ saã nɖe Ɖidze, alasɔ ɔ̃ nɖe ngɔ i Ɣaa ɔtã iyere gu ɔle sɔ maturi ɔɖuɖu i kayiiso aaki i ɔ̃ iso mana ngbã.” ");
INSERT INTO akp_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Gɔ manya kumɛgɔ i Petro gu Yohanes ɔɖe ika gu ɔtu fiɛ maɣe ana sɔ mma loiɣe ɔko gu mma nna ɖibia kuwɛ̃ i kaɖe ame maɖe ne, ibara ma ɣii. Manya maɖi ite sɔ masiai Yesu. ");
INSERT INTO akp_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ɣɛɛ gɔ mato manya ngɔ masa ɣɛ i ma katɔ̃ mmɔ ne, maiwo kuira ɔɣɛ. ");
INSERT INTO akp_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Gɔ makɔ ma maɖi i kayaso ame mmɔ ne, makpakpa kerekere ɔsɛ iti ame. ");
INSERT INTO akp_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Mawɛ̃ ɔkarɛ sɔ, “Be iɖe boabara mmagbe? Boibawo ɔsɛ̃ sɔ iiɖe ma lobara iwawãra nɛgbe! Ɔbiara i Yerusalem ɣe, fiɛ maɔnɔ itɔ̃me nɛgbe. ");
INSERT INTO akp_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ɣɛɛ ne, mitã bosɛ̃ botã ma sɔ madaasiɖe ika i ngɔ marɔ Yesu iyere ame ana, si itɔ̃me nɛgbe iisibasamarã.” ");
INSERT INTO akp_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Gɔ maledza ma ikpere ibɔ i ma kasarɛkɔ̃ ne, masɛ̃ matã ma sɔ ita i kiniɔ ne, madaasiɣɛ ɣee mate kuira i Yesu iyere ame. ");
INSERT INTO akp_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ne Petro gu Yohanes ɔkarɛ ma sɔ, “Mi mɔmɔ minyɔ ne kukaakɔ. Be loabo Ɣaa anɔ iɖo? Si bokã mi atsue ɣee si bobara Ɣaa kuɖɔɛ? ");
INSERT INTO akp_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nwa bonya gu nwa bonɔ ne, boibawo kanya ɔma i wã iso.” ");
INSERT INTO akp_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Gɔ makpakpa mamɔ ɔkɛkɛ anɔ mapia ma ne, manyua ma. Kumɛgɔ i maturi ɔɖuɖu to male Ɣaa ala ɔ̃ kurabarara ɔso ne, mainya kuira nɛ iso maakpadzɛ̃ ma kutsue. ");
INSERT INTO akp_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ɔrɛrɛ̃ gɔ lona isosarɛ ɔɔfɔ lɛ akɔ sina gu kama. ");
INSERT INTO akp_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Gɔ manyua Petro gu Yohanes ne, makɛlɛ ma maturi kɔrɛ masɛ maaɣere ma nnɛ i makpakpa ɔɣere ma. ");
INSERT INTO akp_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Mafɔɖedze ɔɖuɖu ɔsakanya, ne makɔlɛ silɔ kato makparama kayi sɔ, “O Bosate, fɔ gɔ lobara kato gu karɔ̃ gu ɔpo gu ara ɔɖuɖu wa mpia i wã ame. ");
INSERT INTO akp_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Fɔ loki i fɔ Siwarã Bielea ame aɖe ika akigu i bo ɔwa David gɔ nɖe fɔ ɔɖabo iso sɔ, ‘Be ɔso i kayiiso maturi to mata matui, fiɛ nɖebi ana to mabu adzuni siefe? ");
INSERT INTO akp_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kayiiso magara ɔbara kanya kawɛ̃ fiɛ ma matɔ̃ɖedze ɔsa so kanya mata sɔ maakpɛ̃gu Ɣaa gu ɔ̃ Kristo.’ ");
INSERT INTO akp_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Gbagbaã iɖe sɔ Herodes gu Pontio Pilato gu Israel kaɖe gu mma loiɖe Israel maturi ɔsa so kanya i ɔmagɛ̃ gɔgbe ame mata maya i fɔ Ɔɖabo Sekelea Yesu gɔ asɔla nnɔĩ iso. ");
INSERT INTO akp_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ɣɛɛ i fɔ ɔle gu iwola ame ne, atã ma ɔri sɔ mabara ara wa fɔ aɣɛ asɛ sɔ maabara. ");
INSERT INTO akp_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Kiniɔ ne, O Bosate, nyɔ anɔ wa mato makɛkɛ mapia bo! Tã bo ma nɖe fɔ maɖabo kagbegbe, sɔ boawo fɔ itɔ̃me ɔɣɛ. ");
INSERT INTO akp_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pɛgu maturi si asa ma abara awawãra gbodzoo i fɔ Ɔɖabo Sekelea Yesu iyere ame.” ");
INSERT INTO akp_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Gɔ makparama kayi maro ne, iyo nɛ ame mapia ɔti, ne Siwarã Bielea ɔba siayi i ma ame ɔɖuɖu matsɛ Ɣaa Itɔ̃me Bielea iɣɛ ku kagbegbe ne. ");
INSERT INTO akp_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ɔwi gɔmɔ ame ne, mma ɔɖuɖu lofɔ maɖe ɖe mawɛ̃ i ɔbara gu adzuni ame, ma kuwɛ̃ iisɛ ɔbu ɔ̃ ɔnɔwɛ̃ saã ɔkpɛ. Ɣɛɛ ne, ira biara nɛ i ɔwɛ̃ ba ɖe ma ɔɖuɖu ire. ");
INSERT INTO akp_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ne ɔso katɔ̃memasɛdze ɔɣɛ Bosate Yesu ita ibɔrɛ i makpise ame iso itɔ̃me gu ɔle siare fiɛ Ɣaa nnyainyɔ siare ɔwegu ma ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kuwɛ̃ iiɖe wɛrɛba i ma ndɛ̃ alasɔ mma mba ayo ɣee nrɔ̃ ne, masu ma ara marɔdɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ne masu sikã dzɛ mana mapia i katɔ̃memasɛdze nrɔɔ̃ ame maɣɛ ɔbiara kumɛgɔ i ɔ̃ anyaa ɔsi kanya ne. ");
INSERT INTO akp_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ɔrɛrɛ̃ ɔwɛ̃ ɔwe mmɔ gɔ marɔ sɔ Yosef ɔbɔrɛ i Levi ɔɣekparɛ ame fiɛ ɔbɔrɛ i Kipro karɔ̃ iso. Katɔ̃memasɛdze ɔtã wũ iyere sɔ Barnaba gɔ karɔ̃ nɖe Kateteretãse. ");
INSERT INTO akp_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ɔ̃ wũ ɔsu ɔ̃ karɔ̃ ɔrɔdɛ̃ ɔsu sikã ɔbɔ katɔ̃memasɛdze. ");
INSERT INTO akp_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ɔrɛrɛ̃ ɔwɛ̃ ana ɔwe gɔ marɔ sɔ Anania fiɛ ɔ̃ ɔre nɖe Safira. Ma wũ makpɛti ma karɔ̃ marɔdɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","I ɔrɔ̃go itsue ame ne, ɔrɛrɛ̃ ɔsu sikã siwɛ̃ ɔkɔla fiɛ ɔsu sikutia ɔba ɔ̃apia i katɔ̃memasɛdze nrɔɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ne Petro ɔkarɛ wũ sɔ, “Anania, be ɔso fiɛ atã Satana ɔɖe-ɔ iso fiɛ ato ala sila atã Siwarã Bielea? Mikuti karɔ̃ ga mikpɛti mirɔdɛ̃ sikã siwɛ̃ misɛ so. ");
INSERT INTO akp_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mi mba karɔ̃ ga misu mirɔdɛ̃, fiɛ kuso gɔ matã mi ana ne, mi mba. Be ɔso fiɛ atã sɔ mibara ira nyanyarĩa nɛgbe igbã? Iiɖe maturi awune iɖe mila sila mitã, ɣɛɛ Ɣaa.” ");
INSERT INTO akp_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Gɔ Anania ɔnɔ atɔ̃me wagbe ne, ɔluwɛ̃ ɔrɔ̃ ɔfere i karɔ̃ ɔkpi! Ifɔ̃ siare ɔmɔɛ̃ mma ɔɖuɖu lonɔ nnɛ loba. ");
INSERT INTO akp_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ne maporoporoi ma mpia i ma ndɛ̃ i mmɔ ɔsu ɔkati mamini wũ, maputa wũ masɛ maabiara ne. ");
INSERT INTO akp_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Lɛ iɖɔwũ itɛ kama ne, ɔ̃ ɔre ɔba ɔ̃ɔbo mmɔ gɔ ɔ̃iɣe nnɛ loba. ");
INSERT INTO akp_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ne Petro ɔɣere wũ sɔ, “Ɣere me, karɔ̃ ga i mi gu fɔ ɔrã ɔrɔdɛ̃ ne, sikã dzɛ matã mi ɔɖuɖu i ngbe ne?” Ne ɔrɔ̃go ɔfɔ kanya sɔ, “Aĩ, sikã ɔɖuɖu mmɔ ne.” ");
INSERT INTO akp_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Petro ɔɣere wũ sɔ, “Be ɔso fiɛ mi gu fɔ ɔrã ɔbara kanya kawɛ̃ sɔ miala Siwarã Bielea minyɔ? Nyɔ, maporoporoi ma loputa fɔ ɔrã masɛ maabiara ɔɔba maɣɛ sɔ maaputa-ɔ fɔ wũ makɛlɛgu.” ");
INSERT INTO akp_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ɔluwɛ̃ ne, ɔ̃ wũ ɔrɔ̃ ɔfere i karɔ̃ i Petro ngbatɔ̃ ɔkpi kɛrɛrɛ. Gɔ maporoporoi ɔba maanya sɔ ɔ̃ɔkpi ɔrɛ ne, maputa wũ makɛlɛgu masɛ maabiara i ɔ̃ ɔrã kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ne ɔso ifɔ̃ siare ɔmɔɛ̃ mafɔɖedze gu mma ɔɖuɖu lonɔ ara wa loba. ");
INSERT INTO akp_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Katɔ̃memasɛdze ɔbara awawãra gu akparĩ gbodzoo i maturi ndɛ̃. Mafɔɖedze ɔɖuɖu sɛ masarɛ i isɔrɛyo ngbegɔ marɔ sɔ Salomo kakpakɛ ame. ");
INSERT INTO akp_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Maturi mama ma loifiniki sɛ manigã ma ibore ibo, ɣɛɛ mala maɔwarɛ ma. ");
INSERT INTO akp_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ɣɛɛ maturi gbodzoo, marɛrɛ̃ gu marɔ̃go, ɔfiniki mafɔ Bosate maɖe maba maabo i mafɔɖedze ikuri ame. ");
INSERT INTO akp_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Maturi ɔsu manyɛse maba maarara i sikala iso i siriruɛ ngbegɔ mafɔ maɖe sɔ si Petro to ɔfe ne, bidɛ ɔ̃ kusɔ aasia i manyɛse iso. ");
INSERT INTO akp_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Masu manyɛse gbodzoo gu mma ɔɖuɖu i siwarã lalaa to siɖaa mabɔrɛgu i simagɛ̃ dzɛ loki silɔ Yerusalem mabɔ ma kɔrɛ fiɛ masa ma ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Sɔrɛdzekpakpa pelepele gu ma ikuri nɛ marɔ sɔ ma Zadukise ɔtsɛ sirerɛ ikpɛ̃gu katɔ̃memasɛdze teteree. ");
INSERT INTO akp_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ne ɔso mamɔɛ̃ katɔ̃memasɛdze masɛ maapia i iyo ame. ");
INSERT INTO akp_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ɣɛɛ kasɛ̃ ne, Ɣaa kpabo ɔba ɔ̃asese ma kayogodɔ̃ ɔɖi ma. ");
INSERT INTO akp_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Ne ɔɣere ma sɔ, “Mikɛlɛ Isɔrɛyo si misɛ miaɣere maturi ngbã ɣɛtɛ mɛgbe iso ara ɔɖuɖu!” ");
INSERT INTO akp_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Gɔ kaɖe ɔsɛ̃ ne, makɛlɛ isɔrɛyo ame masɛ maatsɛ ara ite lɛ kumɛgɔ i Ɣaa kpabo ɔɣere ma. Ɔwi gɔmɔ ame ne, sɔrɛdzekpakpa pelepele gu ɔ̃ makpakpa laa gu ma Yudase matɔ̃ɖedze ɔsarɛ, ne mapia iyo madzuɛ̃se sɔ masɛ maaɖi katɔ̃memasɛdze i iyo mabɔ. ");
INSERT INTO akp_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ɣɛɛ gɔ makɛlɛ ne, maisɛ maanya ma! Ne ɔso makpese maba maaɣere ma sɔ, ");
INSERT INTO akp_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Gɔ bosɛ ne, bonya sɔ kukui ɔsɛ̃ kpakpara, madzuɛ̃se ana ɣɛ i kanya. Ɣɛɛ gɔ bosese ne, mma bomɔɛ̃ bopia mmɔ kuwɛ̃ na i iyo ame!” ");
INSERT INTO akp_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Gɔ isɔrɛyo madzuɛ̃se ɔkpakpa gu sɔrɛdzekpakpa ɔnɔ itɔ̃me nɛgbe ne, awururu ɔkpɛ̃ ma gbaã, alasɔ maitsue nnɛ iɖe loba. ");
INSERT INTO akp_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ne ɔwɛ̃ ɔba ɔ̃aɣere ma sɔ, “Mma mimɔɛ̃ mipia iyo ne, maɣɛ i isɔrɛyo mato mate maturi ara.” ");
INSERT INTO akp_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mmɔ i isɔrɛyo madzuɛ̃se ɔkpakpa gu ɔ̃ maturi ɔta makɛlɛ sɔ maamɔɛ̃ ma mabɔ. Ɣɛɛ gɔ mato manigã sɔ mma losakanya i mmɔ aapɛ ma ata ɔso ne, maimɔɛ̃ ma sikitii. ");
INSERT INTO akp_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Gɔ masɛ maakɔ katɔ̃memasɛdze mabɔ ne, maɖi ma maɣedza i ma Yudase matɔ̃ɖedze katɔ̃ sɔ masɔrɛdze ɔkpakpa pelepele si ɔkarɛ ma itɔ̃me. Ɔkarɛ ma sɔ, ");
INSERT INTO akp_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Boiɣere mi sɔ midaasiɣɛ kuira i Yesu gɔgbe iso? Ɣɛɛ miɔkararã itɔ̃me nɛgbe i Yerusalem ɔɖuɖu. Mibie ana sɔ miatã bo ipɔ i Yesu kukpi iti!” ");
INSERT INTO akp_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Mmɔ i Petro gu katɔ̃memasɛdze mama ɔɣɛ sɔ, “Ikote sɔ boakã Ɣaa atsue boɖo maturi awune. ");
INSERT INTO akp_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yesu gɔ mitã mapɛ mamatãra i kudziri iso fiɛ ɔkpi ne, bo mawa Ɣaa ɔtara wũ ɔbɔrɛgu i makpise ame ɔpia ngbã. ");
INSERT INTO akp_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ɣaa ɔtara wũ ɔsia i kakpakpakɔi i ɔ̃ kuɖearɔ̃ iso. Ɔsu wũ ɔbara Ɔkpakpa gu Ɖidze sɔ Israel kaɖe ana ɔri mafiniki i ma situ ame mana akpi isu itsɛ. ");
INSERT INTO akp_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Bo gu Siwarã Bielea dzɛ i Ɣaa ɔsu ɔtã mma nsɛ makã wũ atsue ne, bo nɖe ara wagbe maɖansiɛ ne.” ");
INSERT INTO akp_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Gɔ manɔ atɔ̃me wagbe ne, sikpã ɔmɔɛ̃ ma gbaã. Ne ɔso masia ita sɔ maaɖoe katɔ̃memasɛdze magbe. ");
INSERT INTO akp_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ɣɛɛ ma ndɛ̃ ɔ Farisise ɔwɛ̃ gɔ marɔ Gamaliel fiɛ ɔɖe Mose mmara tedze ɔsɛ̃ ɔtã ma. Maturi ɔɖuɖu sɛ mawarɛ ɔrɛrɛ̃ gɔgbe kukaakɔ. Ɔta ɔya i atɔ̃mekaɣɛkɔ̃ ɔɣɛ sɔ matã maɖi katɔ̃memasɛdze si ma kerekere si masɛ iti ame. ");
INSERT INTO akp_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Mmɔ ɔto ɔɣere ma sɔ, “Israel maturi, minyɔ kukaakɔ nnɛ mito mibie sɔ miabaragu mmagbe! ");
INSERT INTO akp_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ɔwi gɔ lofe ame ne, ɔrɛrɛ̃ ɔwɛ̃ gɔ marɔ sɔ Teuda ɔbara so lɛ ngɔ lobua ɔnya. Maturi alafa ana ɔta masiai wũ. Ɣɛɛ gɔ maɖoe wũ ne, ɔ̃ masiaidze ɔsame, ne ɔ̃ ikuri nɛmɔ ɔbiɛ ne. ");
INSERT INTO akp_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ne kama ɔwi gɔ maka maturi ne, Yuda gɔ lobɔrɛ i Galilea ɔsa maturi mawɛ̃ kanya mata maya i abã iso. Gɔ maɖoe wũ ne, ɔ̃ masiaidze ɔsame. ");
INSERT INTO akp_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ne ɔso nnɛ nto loɣere mi nɖe sɔ, minyua mmagbe. Si ara wa mato mate gu nwa mato mabara ne ma mɔmɔ are aɖe ne, ɔwi kurukutu ame ne wã ɔɖuɖu to atui. ");
INSERT INTO akp_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ɣɛɛ si Ɣaa kurabarara kuɖe ne, miibawo ma ɔtindza. Si iiɖe ngbɔ ne, iyi to iba gɔ mianya sɔ Ɣaa mɔmɔ mito mikpɛ̃gu!” ");
INSERT INTO akp_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ɔ̃ kuka ɔtã mafinikira ma adzuni. Ne ɔso makpere katɔ̃memasɛdze mabɔ ma ndɛ̃, ne mapɛ ma maɣere ma sɔ madaasiɖe ika kuiwɛ̃ i Yesu itɔ̃me iso fiɛ manyua ma ne. ");
INSERT INTO akp_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Gɔ mato makɛlɛ ne, isoɣɔ lala ɔbo i ma ame, alasɔ manya sɔ Ɣaa ɔka ma ɔpia i mma lokote sɔ maana kunuarɛ i Yesu iti. ");
INSERT INTO akp_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ne kama ne, iyi biara mala maɔte Itɔ̃me Bielea sɔ Yesu nɖe Kristo i ma Yudase isɔrɛyo gu maturi ayo. ");
INSERT INTO akp_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ɔwi gɔ i marasuãdze ɔtsɛ isi ibua ne, kakpadzɛ̃ ɔba i ma Yudase ma nsɛ maɣɛ Griki siɖe gu mma nsɛ maɣɛ si Hebrise ndɛ̃ sɔ si maɣɛ ikpɛnɛ araɖea ne, aito aɣo makuɛdze ma nto maɣɛ Griki siɖe. ");
INSERT INTO akp_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ne ɔso katɔ̃memasɛdze iweo-inyɔ ɔkpere marasuãdze tsɔra ɔɖuɖu maɣere ma sɔ, “Ikote sɔ boasu bo ɔwi botã Ɣaa itɔ̃me iɣɛ ne iiɖe araɖea kutsuɛ. ");
INSERT INTO akp_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ne ɔso kiniɔ ne, manyii, minyɔ mi ndɛ̃ si miɖi marɛrɛ̃ ikɔdzɛ ma anɔ lokpa fiɛ Siwarã Bielea ana pia i ma ame. Mmamɔ boasu boɣedza i karabara gamɔ kanya, ");
INSERT INTO akp_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","si bosu bo ɔwi botã kayi ikparama gu Itɔ̃me Bielea iɣɛ.” ");
INSERT INTO akp_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Itɔ̃me nɛgbe ɔkote ma ɔɖuɖu, ne ɔso maɖi Stefano gɔ nɖe ɔturi gɔ mba kafɔkaɖe, fiɛ Siwarã Bielea ana pia i ɔ̃ ame. Maɖi Filipo, Prokoro, Nikanor, Timon, Parmena gu ɔfɔ gɔ lokpese ɔ Yudase gɔ marɔ Nikolao fiɛ ɔbɔrɛ i Antiokia sɔ mabuai Stefano. ");
INSERT INTO akp_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Maturi ikɔdzɛ magbe maɖi mate katɔ̃memasɛdze ne. Makparama kayi masu ma nrɔɔ̃ masia ma iso itã karabara. ");
INSERT INTO akp_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Maturi gbodzoo ɔfɔ Itɔ̃me Bielea gɔ itã sɔ mma lofɔ maɖe ɔba maasi i Yerusalem. Ma Yudase masɔrɛdze gbodzoo ana ɔfiniki masiai kafɔkaɖe gagbe. ");
INSERT INTO akp_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefano gɔ loyi ku abualɛra gu ɔle ɔbara awawãra gbodzoo i maturi ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ma Yudase masande ikuri nɛ i ma makɔse ɔnyua fiɛ mabɔrɛ i Kirene gu Aleksandria gu mma lobɔrɛ i Kilikia gu Asia ɔtsɛ atɔ̃me ikpadzɛ̃gu Stefano. ");
INSERT INTO akp_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ɣɛɛ kuwɛ̃ i ma ndɛ̃ iiwo ɔya i Stefano kanya, alasɔ Siwarã ɔtã wũ iwola nɛ ɔɖe ala ika. ");
INSERT INTO akp_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ne ɔso mabara kanya kawɛ̃ ku mawɛ̃ sɔ maaɖaɛ kanya masia wũ iso sɔ, “Bonɔ sɔ Stefano ɔɣɛ ara wa lota aya i Mose gu Ɣaa iso.” ");
INSERT INTO akp_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kanya iɖaɛ nɛgbe ɔtã sikpã ɔmɔɛ̃ mmara matedze gu ma Yudase makpakpa gu maturi ɔɖuɖu. Ne ɔso mamɔɛ̃ wũ makɛlɛgu ma atɔ̃mekaɣɛkɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Mma makɔ mabɔ sɔ maɖaɛ wũ kanya ɔɣɛ sɔ, “Stefano ne, ɔsɛ ɔɖe ika ɔta ɔya i Isɔrɛyo Sekelea gu Mose mmara iso ɔwi biara. ");
INSERT INTO akp_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Bonɔ ɔɣɛ ana sɔ ɔrɛrɛ̃ gɔ lobɔrɛ i Nasaret fiɛ marɔ wũ Yesu ne, ɔto ɔ̃abiɛ Isɔrɛyo nɛgbe fiɛ ɔ̃afinikira Mose mmara mɛ ɔtã bo.” ");
INSERT INTO akp_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Mma ɔɖuɖu nsi i atɔ̃mekaɣɛkɔ̃ mmɔ ɔkarã anɔ i Stefano iso, ne manya sɔ ɔ̃ katɔ̃ to ka fiɛ lɛ Ɣaa kpabo kare. ");
INSERT INTO akp_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Sɔrɛdzekpakpa pelepele ɔkarɛ Stefano sɔ, “Ara wa mato maɣɛ ne gbaã iɖe?” ");
INSERT INTO akp_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ne Stefano ɔtã mmuai sɔ, “Tete mɛrɛ̃ gu wũ manyii, mikã me atsue. Ɣaa, Isekelesate ɔɖi so ɔte bo ɔwa Abraham i Mesopotamia karɔ̃ iso fiɛ ɔta i mmɔ ɔkɛlɛ karɔ̃ ga marɔ Haran iso. ");
INSERT INTO akp_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ɣaa ɔɣere wũ sɔ, ‘Rui i fɔ maturi kɔrɛ gu fɔ karɔ̃ iso si akɛlɛ karɔ̃ ga loate-ɔ iso!’ ");
INSERT INTO akp_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ne ɔso ɔbɔrɛ i ɔ̃ karɔ̃ iso, ɔkɛlɛ ɔ̃asɛ i Haran gbɔgbɔɔgbɔ ɔ̃ ɔse ɔkpi. Ne Ɣaa ɔkɔ wũ ɔbɔ ngbegɔ misi ngbe nɔme ne. ");
INSERT INTO akp_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ɣaa iitã Abraham kaɖekɔ̃ kukawɛ̃, nane karɔ̃ kɛkɛĩ ngbe. Ɣɛɛ ne, ɔɣere wũ ɔɖegu katɔ̃ sɔ karɔ̃ gagbe to kaakpese ɔ̃ gu ɔ̃ mabi kare i ɔwi gɔ nto ɔba ame atoa sɔ ɔ̃iɣe ɔbi kuwɛ̃ iba iabo ɔwi gɔmɔ ame. ");
INSERT INTO akp_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ɣaa ɔɣere wũ kumɛgɔ i ɔ̃ mawa ɔɖuɖu to maakpese masande i kafɔrɔ̃ iso, mmamɔ to maabara ma ɔtile gbɔgbɔɔgbɔ akɔ alafa ana aafe. ");
INSERT INTO akp_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ɔɣere wũ ana sɔ, ‘Loto loakpadzɛ̃ karɔ̃ ga iso maaɖe masande maturi kutsue. Ne kama ne, mato maabɔrɛ i mmɔ maba maafɛ̃ ara matã me i karɔ̃ ga iso bosi ngbe.’ ");
INSERT INTO akp_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ne Ɣaa to ɔsu sirɛrɛ̃ itu ndamu ɔtã Abraham sɔ ɔwi gɔ nto ɔba ame ne, ne loaɖe ikparĩ i ɔ̃ Ɣaa gu Abraham ɔɣekparɛ ndɛ̃ ne. Gɔ Abraham ɔɣe Isak ne, ɔtu wũ sirɛrɛ̃ ku ɔ̃ iyi farafanava. Isak ana ɔɣe Yakob fiɛ Yakob ana ɔɣe nlɛ miweo-minyɔ fiɛ ma ɔɖuɖu ana ɔtu sirɛrɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Yakob mabi ɔbɛbɛ anɔ i ma ɔnyiibi Yosef iso. Ne ɔso mamɔɛ̃ wũ marɔdɛ̃ matã maturi ma losu wũ makɛlɛgu Egipte karɔ̃ iso. Ɣɛɛ ne, Ɣaa ɔwegu wũ, ");
INSERT INTO akp_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","fiɛ ɔɖi wũ ɔbɔrɛgu i ɔ̃ inyɛwe ɔɖuɖu ame. Ɣaa ɔtã wũ abualɛra gu inɔgba wodoroa, ne ɔso Egipte igara ɔsu wũ ɔbara ɔ̃ karɔ̃ ɔɖuɖu gu ɔ̃ iyo nyɔisose. ");
INSERT INTO akp_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Ɔwi gɔmɔ ame ne, kukã siare kuwɛ̃ ɔba i Egipte gu Kanan karɔ̃ ɔɖuɖu iso gɔ ibɔ inyɛwe i bo mawa iso ala mana araɖea. ");
INSERT INTO akp_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Gɔ Yakob ɔnɔ sɔ araɖea pia i Egipte ne, ɔpia ɔ̃ mabi sɔ masɛ maaɣa araɖea mabɔ ɔkpɛ ɖeakatɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ne gɔ Yakob mabi ɔkpese makɛlɛ mmɔ ɔkpɛ nyɔa sɔ maaɣa araɖea ne, Yosef ɔɖi so ɔte ma, ne ka ɔɖi ma ɔte Igara Farao ne. ");
INSERT INTO akp_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ne kama ne, Yosef ɔpia ma sɔ masɛ maakɔ ɔ̃ ɔse Yakob gu ɔ̃ manyii ɔɖuɖu mabɔ Egipte gɔ ma ɔɖuɖu aaɖe lɛ maturi sikɔdzɛ-iru. ");
INSERT INTO akp_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ne ɔso Yakob ɔrui ɔkɛlɛ ɔsɛ ɔ̃ɔwe i Egipte mmɔ gbɔgbɔɔgbɔ ɔ̃ gu bo mawa ɔkpi. ");
INSERT INTO akp_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Masore ma makpesegu masɛ maabiara i ɔmagɛ̃ gɔ marɔ Sikem. Mabiara ma i kabiarakɔ̃ ga i Abraham ɔɣa i Hemor mabi kɔrɛ ala sikãfudza. ");
INSERT INTO akp_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ɔwi gɔ i Ɣaa ɔwi gɔ ɔɣɛ ɔsɛ sɔ ɔ̃abara nnɛ ɔɣere Abraham ɔbore ɔbo ne, bo mawa ɔɔsi gbodzoo i Egipte. ");
INSERT INTO akp_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Iba ana sɔ igara ɣɛtɛ gɔ loiɣe Yosef ɔtsɛ iɖe iso i Egipte. ");
INSERT INTO akp_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Farao gɔgbe ɔbara bo mawa ɔtile sɔ si ɔwɔra ma. Ɔtã sɔ masu ma mabi ɣɛtɛ mapɛyu si makpi. ");
INSERT INTO akp_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Ɔwi gɔmɔ ame maɣe Mose ne. Gɔ ɔ̃ ara ɔbo Ɣaa anɔ ɔso ne, ɔ̃ maɣese ɔsu wũ makɔla i ma iyo manyɔ wũ iso awa atɛ i kuɖokpo. ");
INSERT INTO akp_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Gɔ manya sɔ maisibawo wũ ɔkɔla ne, maɖi wũ masɛ i ɔgbami. Ne Farao ɔbi birɔ̃gomi ɔsɛ ɔ̃ɔnya wũ ɔsu ɔba ɔ̃abara ɔ̃ kayiri ame ɔbi ne. ");
INSERT INTO akp_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ɔla wũ fiɛ mate wũ Egipte maturi kubarara gu ma iwola ɔɖuɖu, ɔwe ɔle i ikaɖe gu kurabara ame. ");
INSERT INTO akp_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Gɔ Mose ɔfɔ akɔ sina ne, iba wũ iti ame sɔ ɔ̃akɛlɛ ɔ̃aya ɔ̃ manyii ma Israelse. ");
INSERT INTO akp_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Gɔ ɔsɛ ɔ̃ɔbo ne, ɔnya ɔ Egiptese sɔ ɔto ɔbara ɔ Israelse amumuɣɔ. Mose ɔkɛlɛ sɔ ɔ̃afɔ ɔ Israelse, ne ɔɖoe ɔ Egiptese gɔmɔ ne. ");
INSERT INTO akp_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mose ɔfɔ ɔɖe sɔ ɔ̃ manyii aanya wũ lɛ ngɔ i Ɣaa ɔpia sɔ ɔba ɔ̃aɖi ma, ɣɛɛ mainya wũ ngbɔ. ");
INSERT INTO akp_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Gɔ kaɖe ɔsɛ̃ fiɛ Mose ɔledza ma kɔrɛ isɛ ne, ɔnya gɔ ma Israelse inyɔ to makpɛ̃. Gɔ ɔkɛlɛ sɔ ɔ̃akpura ma ne, ɔkarɛ ma sɔ, ‘Wũ maturi, manyiibi miɖe, ne ɔso minyua ɔkpɛ̃.’ ");
INSERT INTO akp_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Ɣɛɛ ngɔ nto ɔbara ɔ̃ ɔnyii ɔtile ɔli Mose ɔkarɛ ana sɔ ‘Nna lobara-ɔ bo isoɖedze gu atɔ̃meɣɛdze? ");
INSERT INTO akp_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ɛɛbɛrɛ abie sɔ aaɖoe me lɛ kumɛgɔ aɖoe ɔ Egiptese gɔmɔ kɔmakaɖe?’ ");
INSERT INTO akp_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Gɔ Mose ɔnɔ itɔ̃me nɛgbe ne, ifɔ̃ ɔmɔɛ̃ wũ, ne ɔtere ɔsɛ ɔ̃awɛrɛ i Midian karɔ̃ iso lɛ ɔfɔ ne. Mmɔ ɔɣe ɔ̃ mabi birɛrɛĩ inyɔ ne. ");
INSERT INTO akp_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Akɔ sina kama ne, Ɣaa kpabo ɔɖi so ɔte wũ i ɔtɔ gɔ nto ɔtsue i kadzirimi kawɛ̃ iso i fafuĩ ame i Sinai kube kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Gɔ Mose ɔnya ira nɛgbe ne, ibara wũ ɣii, ne ɔso ɔbore ɔbo sɔ si ɔnyɔ kukaakɔ ɣɛɛ, Ɣaa ɔkpere wũ ɔɣere sɔ, ");
INSERT INTO akp_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Mme nɖe fɔ mawa Abraham gu Isak gu Yakob mɛrɛ̃ Ɣaa ne.’ Iti pɛ̃ gu ifɔ ɔmɔɛ̃ Mose, ne ɔso ɔ̃ibie sɔ ɔ̃anyɔ mmɔ isɛ. ");
INSERT INTO akp_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Ne Bosate to ɔɣere wũ sɔ, ‘Ɖi fɔ ndokota! Alasɔ karɔ̃ ga iso aɣɛ ne, karɔ̃ sekelea kaɖe. ");
INSERT INTO akp_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Gbaã ne, lonya inyɛwe nɛ ame i wũ maturi pia i Egipte karɔ̃ iso. Nto lonɔ kumɛgɔ mato mabiɛ makpere me. Ne ɔso loba sɔ si loba loaɖi ma. Ba, nto lopia-ɔ Egipte.’ ");
INSERT INTO akp_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mose gɔ masɛ̃ fiɛ makarɛ wũ sɔ, ‘Nna loɖi-ɔ bo isoɖedze gu atɔ̃meɣɛdze?’ ne, ɔ̃ ame i Ɣaa ɔpia sɔ ɔsɛ ɔ̃aɖi ma si ɔkpese Ɖidze gu isoɖedze iki i Ɣaa kpabo gɔ ɔnya i kadzirimi ga nto katsue kɔrɛ ne. ");
INSERT INTO akp_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ɔɖi ma ɔbɔrɛgu i Egipte fiɛ ɔbara awawãra gbodzoo i Egipte mmɔ gu Ɔpo Rɛtɛa katɔ̃ ku ɔwi gɔ mawe makiki i fafuĩ ame akɔ-sina buu. ");
INSERT INTO akp_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Mose mɔmɔ ɔɖe loɣere ma Israelse sɔ, ‘Mi Ɣaa to ɔ̃asese mi kanyaɖidze mama lɛ me ɔbɔrɛgu i mi ndɛ̃.’ ");
INSERT INTO akp_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mose nɖe ngɔ losa bo mawa kanya ku ɔwi gɔ ma Israelse pia i fafuĩ ame. Ɔ̃ ame nɖe ngɔ i Ɣaa kpabo ɔɖegu ika i Sinai kube iso ne. Ɔ̃ ɔɖe lowegu bo mawa fiɛ ɔfɔ Ɣaa itɔ̃me nɛ nsɛ itã ngbã ɔtã bo ne. ");
INSERT INTO akp_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ɣɛɛ bo mawa ɔta maya Mose iso, masɛ̃ wũ, fiɛ i ma situ ame ne, mabie sɔ si makpese makɛlɛ Egipte karɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ne maɣere Mose ɔnyiibi Aron sɔ, ‘Bara aɣɔ wa loakɔ bo tã bo, alasɔ boiɣe nnɛ lobara Mose gɔ lokɔ bo ɔbɔrɛgu i Egipte.’ ");
INSERT INTO akp_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ne ɔso mabara kuɣɔ gɔ nse lɛ inantsuĩbi, mafɛ̃ ara matã kɔ̃, fiɛ matsɛ iyi iɖe ku isoɣɔ i ara wa mabara ngbe ɔso. ");
INSERT INTO akp_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nnɛgbe ɔso i Ɣaa ɔkpese ma i kama fiɛ matsɛ kuɣɛ̃ gu ɔgbaworeti gu awami isɔrɛ ne. Nnɛgbe i Ɣaa kanyamaɖidze ɔtsɛrɛ i Ɔko Sekelea ame maɣɛ sɔ, ‘Israel kaɖe, iiɖe me misu mabɔi mifɛ̃ ara mitã i akɔ sina wa miwe i fafuĩ ame! ");
INSERT INTO akp_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Bowũ ne, misu Molok kuɣɔ iyo gu Romfa iwãmi wa nɖe aɣɔ wa mipɔ sɔ miasɔrɛ. Ne ɔso nto loatã sɔ maamɔɛ̃ mi sisande makɛlɛgu ta Babilonia kama.’ ");
INSERT INTO akp_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Sikati ikpayo nɛ ame i Ɣaa sɛ ɔɖi so ɔte ɔwe i ɔwa mɛrɛ̃ kɔrɛ ku ɔwi gɔ mawe i fafuĩ ame. Mabara ikpayo nɛgbe lɛ kumɛgɔ i Ɣaa ɔɖi ɔte Mose sɔ abara ne tutuutu. ");
INSERT INTO akp_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Akɔ gbodzoo kama ne, Yosua ɔkɔ bo mase ma losore sikati ikpayo nɛgbe masɛ maakpɛ̃gu mma i Ɣaa ɔsa ɔbɔrɛgu i nrɔ̃ mɛgbe iso. Ikpayo ɔwe i karɔ̃ gagbe iso gbɔgbɔɔgbɔ ibo Igara David ɔwi ame. ");
INSERT INTO akp_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ɣaa ɔwegu David gbaã, ne ɔso David ɔkarɛ Ɣaa sɔ ɔtã wũ ɔri si ɔtsue iyo ɔtã Yakob Ɣaa. ");
INSERT INTO akp_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ɣɛɛ ne, Igara Salomo ɔɖe lotsue iyo nɛmɔ. ");
INSERT INTO akp_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ɣaa kato gu karɔ̃ baradze ɣɛɛ ne, ɔ̃isɛ ɔsɛ i ayo wa i maturi awune ɔtsue ame. Ɣaa ɔki i ɔ̃ kanyamaɖidze iso ɔɣɛ sɔ, ");
INSERT INTO akp_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Kuɖokpo nɖe wũ sigaraiyara, fiɛ karɔ̃ nɖe wũ kukpa kasiakɔ̃. Ne ɔso mme iyo igbã miawo ɔtsue ɔtã me, ɛɛbɛrɛ lona kasɛkɔ̃? ");
INSERT INTO akp_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Iiɖe mme lobara ira biara?’ ” ");
INSERT INTO akp_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ne Stefano ɔɣere ma ana sɔ, “Mi matsuelese! Mitɛ̃ra atsue i Ɣaa itɔ̃me iso lɛ kumɛgɔ i mi mase ɔbara. Ɔwi biara mita miɣɛ i Siwarã Bielea iso. ");
INSERT INTO akp_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ɣaa kanyaɖidze ɔmele i mi mawa iibie sɔ maaɖoe? Maɖoe Ɣaa kanyamaɖidze ma loɣɛ masɛ sɔ Ɔsekelea to ɔ̃aba. Ɔsekelea gɔmɔ ana ne, miɖi wũ mitã maɖoe. ");
INSERT INTO akp_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mi lofɔ Ɣaa mmara mibɔrɛgu i Ɣaa makpabo nrɔɔ̃ ame, ɣɛɛ misɛ̃ me iso ibara.” ");
INSERT INTO akp_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Gɔ manɔ atɔ̃me wa i Stefano ɔɣɛ i ma iso ne, ma situ ɔta siya gbaã, itã makɛrɛ̃ anyɛ i sikpã ame. ");
INSERT INTO akp_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ɣɛɛ Stefano gɔ ame i Siwarã Bielea ɔyi ɔkɔlɛ ɔ̃ anɔmi ɔnyɔ kato, ne ɔnya Ɣaa ifiɛ gu Yesu gɔ ɔɣɛ i ɔ̃ kuɖearɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ne ɔɣere ma sɔ, “Minyɔ! Lonya sɔ kuɖokpo ɔbusi, Maturi Awune Ɔbi ɣɛ i Ɣaa kuɖearɔ̃ iso!” ");
INSERT INTO akp_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Matsɛ sikpabo teteree, matɛ̃ arɔĩ i atsueyoi, matere mamɔɛ̃ wũ. ");
INSERT INTO akp_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ne gɔ mabore wũ maɖi i ɔmagɛ̃ ame ne, matsɛ wũ ata ipɛ, mma lola sila masia wũ iso ɔɖi ma awu siare masɛ i ɔporoporoi ɔwɛ̃ gɔ marɔ Saulo ngbatɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ɔwi gɔ mato mapɛ wũ ata ne, Stefano ɔkparama kayi ɔɣɛ sɔ, “Bosate Yesu, fɔ wũ siwarã!” ");
INSERT INTO akp_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ne ɔpɛ agɛgɛ̃ ɔla kulu teteree sɔ, “Tete, daasu ikpi nɛgbe atã ma kuso!” Gɔ ɔɣɛ ngbɔ ɔro ne, ɔkpi. ");
INSERT INTO akp_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ɔwi gɔ mato maɖoe Stefano ne, Saulo lola ɔ̃ɔpia ma ɔle. Ita i iyi nɛmɔ ne, matsɛ mafɔɖedze ma i Yerusalem ikpɛ̃gu teteree. Ma ɔɖuɖu ɔtere makɛlɛ Yudea gu Samaria. Ɣɛɛ katɔ̃memasɛdze ɔwe i Yerusalem. ");
INSERT INTO akp_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Mafɔɖedze mawɛ̃ ɔba maasu Stefano masɛ maabiara ku kaku gu imararãso siare. ");
INSERT INTO akp_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulo ɔsu ɔsia so iso teteree sɔ ɔ̃awɔra mafɔɖedze ikuri. Ɔsɛ ɔbo i ayo ɔmɔɛ̃ marɛrɛ̃ gu marɔ̃go ɔkɛlɛgu ɔ̃apia i iyo. ");
INSERT INTO akp_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Mma losame ɔɣɛ Itɔ̃me Bielea i kakɔi biara ga makɛlɛ. ");
INSERT INTO akp_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipo ɔkɛlɛ Samaria ɔmagɛ̃ ɔwɛ̃ ame ɔsɛ ɔ̃aɣɛ Kristo iso itɔ̃me i mmɔ. ");
INSERT INTO akp_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Maturi gbodzoo ɔkã wũ atsue ala awawãra gbodzoo wa ɔbara fiɛ manya ɔso. ");
INSERT INTO akp_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ɔsa siwarã lalaa ɔɖi i maturi gbodzoo ame. Sila kulu fiɛ sibɔrɛ i ma ame. Ɔsa mma lokpi kasɛkasɛ gu mma lofɛfɛ̃ masi i karɔ̃ ana. ");
INSERT INTO akp_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nnɛgbe ɔso ne, isoɣɔ ɔba i Samaria ɔmagɛ̃ ame gbaã! ");
INSERT INTO akp_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ɔrɛrɛ̃ ɔwɛ̃ pia i Samaria gɔ marɔ Simon. Ɔɖe wase fiɛ ɔwi gbodzoo ame ngbe ne, ɔ̃ awa ibara sɛ ibara maturi ɣaa. Ɔbua ɔsɛ ɔkɔlɛ so kato sɔ ɔturi nyaa ɔɖe. ");
INSERT INTO akp_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Samaria marɛrɛ̃ gu marɔ̃go gu mabiɛtɛ ɔɖuɖu sɛ mawarɛ wũ ala ɔ̃ kurabarara ɔso. Ne ɔso maɖe ika i ɔ̃ iso sɔ, “Ɔ̃ nɖe kuɖokpo ikpa!” ");
INSERT INTO akp_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Kumɛgɔ i ɔ̃ awa ibara ɔfɔ ma ati ame ɔso ne, masɛ makã wũ atsue. ");
INSERT INTO akp_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ɣɛɛ kiniɔ ne, mafɔ Filipo Itɔ̃me Bielea nɛ ɔɣɛ i Ɣaa sigarakaɖekɔ̃ gu Yesu Kristo iyere maɖe. Marɛrɛ̃ gu marɔ̃go gbodzoo ɔfɔ Ɣaa itupie kubarara. ");
INSERT INTO akp_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon ana ɔfɔ ɔɖe, ne ɔso gɔ ɔfɔ Ɣaa itupie kubarara ne, ɔla ɔ̃ɔsiai Filipo ɔsɛ kakɔi biara. Awawãra wa i Filipo to ɔbara ana ɔbara wũ ɣaa. ");
INSERT INTO akp_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Gɔ katɔ̃memasɛdze ma mpia i Yerusalem ɔnɔ sɔ ma Samariase ɔfɔ Ɣaa itɔ̃me ne, mapia Petro gu Yohanes ma kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Gɔ maba maabo ne, makparama kayi ku mafɔɖedze ɣɛtɛ magbe sɔ mafɔ Siwarã Bielea. ");
INSERT INTO akp_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Alasɔ iba iabo ɔwi gɔmɔ ne, maifɔ Siwarã Bielea. Ɣaa itupie kere maɔfɔ i Bosate Yesu iyere ame. ");
INSERT INTO akp_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Petro gu Yohanes ɔsu nrɔɔ̃ masia ma iso, ne mafɔ Siwarã Bielea ne. ");
INSERT INTO akp_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Gɔ Simon ɔnya sɔ katɔ̃memasɛdze ne nrɔɔ̃ kere masia ma iso fiɛ mafɔ Siwarã Bielea ne, ɔsu sikã si ɔtã katɔ̃memasɛdze ");
INSERT INTO akp_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ɔɣere ma sɔ, “Mitã sɔ mme wũ loana ɔle gɔgbe sɔ ɔbiara gɔ iso loasia nrɔɔ̃ ne, ɔ̃afɔ Siwarã Bielea.” ");
INSERT INTO akp_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ne Petro ɔɣere wũ sɔ, “Mi gu fɔ sikã ɔɖuɖu si miwɔ! Daabu sɔ aawo Ɣaa karatã ɔɣa ku sikã! ");
INSERT INTO akp_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Aito aawo karabara gagbe ame ɔwe, alasɔ fɔ ɔtu ame iikpa i Ɣaa anɔ. ");
INSERT INTO akp_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Finiki i adzuni nyanyarĩa wagbe ame si akparama kayi, siainyɔ Bosate to ɔ̃asu fɔ ikpi ɔtsɛ-ɔ ala fɔ adzuni iilɛ! ");
INSERT INTO akp_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ala ne, lonya sɔ aba kanɔbɛbɛ, fiɛ ikpi ibara ana ɔyi i fɔ ame.” ");
INSERT INTO akp_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ne Simon ɔɣere wũ sɔ, “Pɛ Bosate nrɔɔ̃ i wũ iti sɔ ara nyanyarĩa wa aɣɛ ngbe kuiwɛ̃ iibabɔrɛ me iso!” ");
INSERT INTO akp_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Gɔ Petro gu Yohanes ɔɣɛ Itɔ̃me Bielea i mmɔ maro ne, makpese makɛlɛ Yerusalem gɔ makiki i Samaria simagɛ̃ gbodzoo ame maɣɛ Itɔ̃me Bielea. ");
INSERT INTO akp_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ɣɛɛ Ɣaa kpabo ɔɣere Filipo sɔ, “Kɛlɛ ɔri gɔ lobɔrɛ i Yerusalem fiɛ ɔki i fafuĩ ame ɔso ɔkpa Gasa iso!” ");
INSERT INTO akp_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Bielea ɔta ɔkɛlɛ ɔri gɔmɔ iso. Gɔ ɔsɛ ɔto ɔkɛlɛ ne, ɔsɛ ɔ̃ɔtu ɔrɛrɛ̃ gɔ nɖe sikã nyɔisose ɔkpakpa i Etiopia igararɔ̃go gɔ marɔ sɔ Kandake sigarakaɖekɔ̃. Ɔkpakpa gɔgbe ɔbɔrɛ i Yerusalem ɔsɛ ɔkparama kayi. ");
INSERT INTO akp_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Gɔ ɔ̃ɔsɛ ɔkpese ɔto ɔkɛlɛ iyo ne, ɔsi i keke gɔ i ipɔngɔ to ikpadzɛ̃ ame ɔto ɔka Ɔko Sekelea gɔ i Ɣaa Kanyaɖidze Yesaya ɔtsɛrɛ. ");
INSERT INTO akp_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ne Siwarã Bielea ɔɣere Filipo sɔ, “Sɛ kɛlɛ si abore abo keke!” ");
INSERT INTO akp_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipo ɔtara ngbã ɔbore ɔmatã wũ, kere ɔnɔ gɔ ɔkpakpa to ɔka Yesaya ɔko. Ne ɔkarɛ wũ sɔ, “Ato anɔ nnɛ ato aka ngbe karɔ̃?” ");
INSERT INTO akp_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ne ɔkpakpa gɔgbe ɔtã wũ mmuai sɔ, “Nda loabara loanɔ karɔ̃ gɔ kuwɛ̃ na ɔ̃aɖi karɔ̃ ɔtã me?” Ne ɔtã Filipo iti sɔ ɔya ɔba i keke ame ɔba ɔ̃asɛ i ɔ̃ kɔrɛ ne. ");
INSERT INTO akp_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Atɔ̃me wa ɔto ɔka i Ɔko Sekelea ame nɖe sɔ, “Masɛgu wũ lɛ sɛrɛrerɔ̃ gɔ masɛ maaɖoe. Ɔsiai ma lɛ sɛrɛrerɔ̃ gɔ maakparɛ̃ siwɛrɛ̃ fiɛ ɔ̃ito ɔbiɛ. Ɔ̃ibusi ɔ̃ kanya ana. ");
INSERT INTO akp_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Mapia wũ kunuarɛ, ɣɛɛ ɔ̃ina ngɔ loafɔ wũ kanya. Ɔna ɔɣekparɛ, Alasɔ maɖoe wũ maɖi i kayi gagbe ame?” ");
INSERT INTO akp_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ne ɔkpakpa gɔmɔ to ɔkarɛ Filipo sɔ, “Yesaya ne, ɔ̃ mɔmɔ iso iɖe ɔɖe ika, ɛɛbɛrɛ ɔturi mama iso iɖe?” ");
INSERT INTO akp_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipo ɔsɛ karɔ̃ ɔsu Ɔko Sekelea gɔgbe itɔ̃me ɔɖiɖi Itɔ̃me Bielea karɔ̃ ɔte wũ ise i Yesu iso. ");
INSERT INTO akp_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Gɔ masɛ mato makɛlɛ ne, masɛ maanya itubu gɔ iɣɛ i kakɔi kawɛ̃ i ɔri kuruɛ. Ne ɔkpakpa gɔmɔ to ɔkarɛ sɔ, “Nyɔ ndu. Be ɔso loibawo Ɣaa itupie kubarara ɔfɔ?” ");
INSERT INTO akp_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ɔtã matindza keke maɣedza, ne ma inyɔɔ ɔso mabo i ndu ame fiɛ Filipo ɔpie wũ ndu ne. ");
INSERT INTO akp_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Gɔ mabɔrɛ i ndu ame ne, Bosate Siwarã ɔsu Filipo siruigu, ne ɔso ɔkpakpa gɔgbe iisinya wũ ana. Ɔ̃ wũ ne, ɔkɛlɛ kaa ku isoɣɔ. ");
INSERT INTO akp_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Nnɛgbe kama ne, Filipo ka ɔnya sɔ ɔɣɛ i Azoto ɔmagɛ̃ ame. Ka ɔɣɛ Ɣaa itɔ̃me i mmɔ gu simagɛ̃ dzɛ mpia i ɔri iso ɔɖuɖu isɛ iabo ta Kaisarea ɔmagɛ̃ ame ana. ");
INSERT INTO akp_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ɔwi gɔmɔ ame ɔɖuɖu ne, Saulo to ɔnyɔnyɔ Bosate masiaidze gu anɔmi rɛtɛa sɔ ɔ̃aɖoe. Ɔkɛlɛ ma Yudase sɔrɛdzekpakpa pelepele kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ɔsɛ ɔ̃akarɛ wũ sɔ ɔtã wũ siko dzɛ ɔ̃asu ɔkɛlɛgu ma Yudase kusarɛkɔ̃ i Damasko fiɛ ɔ̃ana ɔle ɔmɔɛ̃ marɛrɛ̃ gu marɔ̃go ma ɔɖuɖu nsiai kafɔkaɖe ɣɛtɛ ɔkɛlɛgu Yerusalem. ");
INSERT INTO akp_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ɔwi gɔ ɔ̃ɔbore ɔbo Damasko ne, ɔluwɛ̃ ikpawaĩ ɔfiɛ ibɔrɛ i kato ifere wũ. ");
INSERT INTO akp_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ɔbɔrɛ ɔfere i karɔ̃, ne ɔnɔ silɔ siwɛ̃ ɔkarɛ wũ sɔ, “Saulo, Saulo, be ɔso fiɛ ato akpɛ̃gu me ngbɔ?” ");
INSERT INTO akp_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ne Saulo ɔkarɛ sɔ, “Bosate, fɔ nna aɖe?” Silɔ dzɛmɔ ɣere wũ sɔ, “Mme nɖe Yesu gɔ ato akpɛ̃gu teteree ne. ");
INSERT INTO akp_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kiniɔ ne, kpɛ̃ ta si akɛlɛ ɔmagɛ̃ ame ne mato maaɣere-ɔ nnɛ ikote sɔ aabara.” ");
INSERT INTO akp_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Marɛrɛ̃ ma nsɛgu Saulo ɔkpɛ̃ so kpara. Manɔ ikaɖe, ɣɛɛ mainya kuwɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Gɔ Saulo ɔta ɔya fiɛ ɔbusi anɔmi ne, ɔ̃isito ɔnya. Ne ɔso mamɔɛ̃ wũ kɔrɔ̃ makɔ wũ mabogu i Damasko ɔmagɛ̃ ame. ");
INSERT INTO akp_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ɔwe i mmɔ akpɛnɛ atɛ gɔ ɔ̃inya, ɔ̃iɖe ara fiɛ ɔ̃inɛ ndu ana. ");
INSERT INTO akp_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ɔwi gɔmɔ ame ne, fɔɖedze ɔwɛ̃ pia i Damasko gɔ marɔ Anania. Bosate ɔɖi so ɔte wũ ɔkpere wũ sɔ, “Anania!” Ne ɔtɔrã wũ sɔ, “Bosate, ɔɔnya me!” ");
INSERT INTO akp_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ne Bosate ɔɣere wũ sɔ, “Ta si aki ɔri gɔ masɛ marɔ sɔ Tɔrɔrɔ iso si akɛlɛ Yuda iyo si akarɛ ɔ Tarsose gɔ marɔ Saulo iti. Ɔpia i mmɔ ɔto ɔkparama kayi. ");
INSERT INTO akp_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Alasɔ loɔɖi lote wũ sɔ ɔrɛrɛ̃ gɔ marɔ Anania to ɔ̃aba ɔ̃asia wũ nrɔɔ̃ iso fiɛ ɔ̃atsɛ inya.” ");
INSERT INTO akp_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Mmɔ i Anania ɔɖi kanya sɔ, “Bosate, loɔnɔ i kakɔi biara ɔtile gɔ i ɔrɛrɛ̃ gɔgbe to ɔbara mafɔɖedze i Yerusalem! ");
INSERT INTO akp_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Fiɛ lonɔ ana sɔ ɔfɔ ɔle ɔbɔrɛgu i masɔrɛdze makpakpa kɔrɛ sɔ ɔ̃aba ɔ̃amɔɛ̃ mafɔɖedze ɔɖuɖu ma mpia i Damasko!” ");
INSERT INTO akp_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ɣɛɛ Bosate ɔɣere wũ sɔ, “Ta si akɛlɛ aabara nnɛ loto loɣere-ɔ. Alasɔ loɖi Saulo lɛ ngɔ loasu wũ Itɔ̃me Bielea ɔkɛlɛgu mma loiɖe ma Israelse gu magara katɔ̃ gu Israel kaɖe ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nto loate wũ kumɛgɔ ɔ̃awe inyɛ i wũ iti.” ");
INSERT INTO akp_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ne ɔso Anania ɔta ɔkɛlɛ, gɔ ɔbo iyo fiɛ ɔnya Saulo ne, ɔsu kɔrɔ̃ ɔsia wũ iso, ɔɣere wũ sɔ, “Wũ ɔnyii Saulo, Bosate Yesu gɔ loɖi so ɔte-ɔ i ɔri iso ne, ɔ̃ lopia me fɔ kɔrɛ sɔ si atsɛ inya si Siwarã Bielea aaba siayi fɔ ame ne.” ");
INSERT INTO akp_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ɔluwɛ̃ ne, ibara Saulo lɛ akolo lokpa i ɔ̃ anɔmi iso, ne ɔtsɛ ara inya ne. Ɔta ɔtã mabara wũ Ɣaa itupie kubarara. ");
INSERT INTO akp_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Gɔ ɔɖe aɖera ne, ka ɔna ɔle. Saulo ɔwe i mafɔɖedze ma mpia i Damasko kɔrɛ ayi kɛkɛĩ. ");
INSERT INTO akp_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ɔwi gɔmɔ ame ne, ɔkɛlɛ ma Yudase kusarɛkɔ̃ ɔtsɛ ma Yesu iso itɔ̃me iɣere sɔ Ɣaa Ɔbi ɔɖe. ");
INSERT INTO akp_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ibara mma ɔɖuɖu lonɔ ɔ̃ itɔ̃me ɣii. Ne makarɛ so sɔ, “Iiɖe ɔrɛrɛ̃ gɔgbe ɔɖe mpia ɔto ɔɖoe Yesu masiaidze i Yerusalem ayi wa lofe ɣɛɛ? Bonɔ ana sɔ mafɔɖedze ɔba ɔmɔɛ̃ i ngbe ɔkɛlɛgu masɔrɛdze makpakpa.” ");
INSERT INTO akp_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ɣɛɛ Saulo itɔ̃me iɣɛ ɔwe ɔle ibua fiɛ ɔ̃ ara karɔ̃ iɖi ite sɔ Yesu nɖe Kristo ɔtã sɔ ma Yudase ma mpia i Damasko mmɔ kuwɛ̃ iiwo kuira ɔɣɛ. ");
INSERT INTO akp_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ayi gbodzoo kama ne, ma Yudase ɔsɛ iti ame sɔ maaɖoe wũ. ");
INSERT INTO akp_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ɣɛɛ mayu maɣere Saulo sɔ ngbɔ i mawɛ̃ to mabie sɔ maaɖoe wũ ne. Matsirise magbe ɔdzuɛ̃ kayogodɔ̃ kasɛ̃ gu anɔwã sɔ si maana wũ maɖoe. ");
INSERT INTO akp_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ɣɛɛ mafɔɖedze ɔsu wũ mapia i kasɛsɛi ga iso mapia ɔwɛ̃ ame fiɛ makigu i iyoi nɛ mpia i ibere ame masora wũ ku kasɛ̃! ");
INSERT INTO akp_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Gɔ ɔsɛ ɔ̃abo Yerusalem ne, ɔbie sɔ si ɔbo i mafɔɖedze ma mpia i mmɔ ndɛ̃. Ɣɛɛ ma ɔɖuɖu to manigã wũ. Mabu sɔ ɔsɔsɔla ɔto ma sɔ ɔ̃ɔfiniki. ");
INSERT INTO akp_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ne Barnaba ɔkɔ wũ ɔkɛlɛgu katɔ̃memasɛdze kɔrɛ fiɛ ɔɣere ma kumɛgɔ i Saulo ɔsarɛgu Bosate gɔ ɔto ɔkɛlɛ Damasko ne. Ɔɣere ma nnɛ i Bosate ɔɣere wũ gu Itɔ̃me Bielea nɛ ɔɣɛ ku katetere i Yesu iyere ame i Damasko. ");
INSERT INTO akp_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ne ɔso Saulo ka ɔwe i ma ndɛ̃ faa ɔwi ɔɖuɖu fiɛ ɔɣɛ Bosate itɔ̃me ku kagbegbe i Yerusalem. ");
INSERT INTO akp_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Gɔ ma Yudase mawɛ̃ ma nsɛ maɣɛ Griki siɖe gu Saulo ɔtsɛ ikaɖe gu kakpadzɛ̃ ne, mabie sɔ si maɖoe wũ. ");
INSERT INTO akp_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Gɔ mafɔɖedze ɔnɔ sɔ mawɛ̃ to mabie sɔ maɖoe wũ ne, makɔ wũ makɛlɛgu Kaisarea fiɛ ka masese wũ kaa ga nɖe Tarso. ");
INSERT INTO akp_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ne ɔso mafɔɖedze ma mpia i Yudea gu Galilea gu Samaria karɔ̃ iso ɔna iwarã gɔ kunigã iisiwe. Mana ɔtu gu ɔle gɔ lobɔrɛ i Siwarã Bielea ame gɔ itã masi fiɛ masu kuwarɛ matã Bosate. ");
INSERT INTO akp_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Gɔ Petro pia ɔkiki ɔnyɔ mafɔɖedze i ma simagɛ̃ ame ne, ɔba ɔ̃ɔbo mafɔɖedze ma mpia i ɔmagɛ̃ gɔ marɔ Lida kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ɔnya ɔrɛrɛ̃ ɔwɛ̃ gɔ marɔ Ainea gɔ lofɛfɛ̃ ɔrɛ i ɔkala iso akɔ farafana. ");
INSERT INTO akp_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ne gɔ Petro ɔnya wũ ne, ɔɣere wũ sɔ, “Ainea, nyɔ! Yesu Kristo ɔɔsa-ɔ! Ta ya, si akarĩ fɔ ɔkala.” Ɔluwɛ̃ ne, ɔta ɔya ku isosarɛ. ");
INSERT INTO akp_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Gɔ manya sɔ Ainea ɔɔta ɔsɛ ne, Lida gu Saron maturi ɔɖuɖu ɔsu so matã Bosate. ");
INSERT INTO akp_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","I Yopa ne, ɔrɔ̃go ɔwɛ̃ pia marɔ sɔ Tabita. I Griki siɖe ame ne, marɔ wũ Dorkas gɔ karɔ̃ nɖe Kuɔ. Ɔɖe fɔɖedze gɔ mba kayiribielea fiɛ ɔsɛ ɔtã mawɛrɛba ara ɔwi biara. ");
INSERT INTO akp_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ɔba ɔ̃amɔɛ̃ ɔnyɛ kere, ne ɔkpi ne. Gɔ mapie wũ ndu maledza wũ ne, masɛ wũ i iyo nɛ matsue masia i kato ame. ");
INSERT INTO akp_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Gɔ manɔ sɔ Petro ɔba ɔpia i Lida fiɛ iidzorogu Yopa ne, mapia maturi inyɔ sɔ masɛ maapɛ wũ nrɔɔ̃ si ɔsiai ma kukpakukpa ɔba. ");
INSERT INTO akp_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ɔ̃ wũ ɔta ɔsiai ma, ne gɔ ɔba ɔ̃ɔbo ne, makɔ wũ makɛlɛgu iyo nɛ masɛ kpise. Makpisemare ɔki malɔ Petro mato mabiɛ mate wũ arapia wa i Dorkas ɔkã ɔtã ma ku ɔwi gɔ ɔsi ngbã. ");
INSERT INTO akp_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petro ɔɣere ma ɔɖuɖu sɔ mabɔrɛ i iyo ame, ne ɔpɛ agɛgɛ̃ ɔkparama kayi ne. Ɔpɛ ɔfiniki ɔnyɔ kpise i katɔ̃ ɔɣere wũ sɔ, “Tabita, ta!” Ɔluwɛ̃ ne, ɔbusi anɔmi. Gɔ ɔnya Petro ne, ɔta ɔsɛ. ");
INSERT INTO akp_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petro ɔmɔɛ̃ wũ i kɔrɔ̃ ɔtara ɔɣedza fiɛ ka ɔkpere mafɔɖedze ɔɖuɖu gu makpisemare sɔ maba, ne ɔtara Dorkas gbanadze ɔpia ma i nrɔɔ̃ ame ne. ");
INSERT INTO akp_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Itɔ̃me nɛgbe ɔki ikã Yopa ɔɖuɖu, ne ɔso maturi gbodzoo ɔfɔ Bosate maɖe. ");
INSERT INTO akp_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ne kama ne, Petro ka ɔwe i Yopa ɔmagɛ̃ ame ayi gbodzoo i Simon ɔwɛ̃ gɔ nsɛ ɔbara mabɔi siko karabara kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ɔwi gɔmɔ ne, ɔrɛrɛ̃ ɔwɛ̃ ɔsɛ i Kaisarea ɔmagɛ̃ ame gɔ marɔ Kornelio. Ɔkpakpa ɔɖe i ma Romase makpakpɛ̃dze ma marɔ sɔ ma Italiase makpakpɛ̃dze ame. ");
INSERT INTO akp_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ɔɖe ɔturi sɛɛ fiɛ ɔ̃ gu ɔ̃ iyo maturi ɔɖuɖu sɛ manigã Ɣaa. Ɔsɛ ɔtã mawɛrɛba ara fiɛ ɔsɛ ɔɖɔɛ kayi ikparama ɔwi biara. ");
INSERT INTO akp_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Iyi iwɛ̃ ito ikɛlɛ iɖɔwũ itɛ ku kakɔme ne, ɔnya iɖi ite. Iɖi ite nɛgbe ame ne, ɔnya sɔ Ɣaa kpabo ɔwɛ̃ ɔba ɔ̃ kɔrɛ ɔkpere wũ sɔ, “Kornelio!” ");
INSERT INTO akp_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Gɔ Kornelio ɔnya wũ ne, ifɔ̃ ɔmɔɛ̃ wũ gbaã. Ne ɔkarɛ wũ sɔ, “Bosate, be ato abie?” Ne Ɣaa kpabo ɔɣere wũ sɔ, “Fɔ kayiribielea ibara gu fɔ kayi ikparama ɔɔbo Ɣaa kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Pia maturi si makɛlɛ Yopa masɛ maakpere ɔrɛrɛ̃ gɔ marɔ Simon Petro mabɔ. ");
INSERT INTO akp_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ɔpia i Simon gɔ nsi i ɔpo katɔ̃ fiɛ ɔsɛ ɔbara mabɔi siko karabara kɔrɛ.” ");
INSERT INTO akp_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Gɔ Ɣaa kpabo gɔgbe ɔrui ne, Kornelio ɔkpere ɔ̃ iyo maturi inyɔ gu ɔ̃ kpakpɛ̃dze ɔwɛ̃ gɔ nto ɔdzuɛ̃ wũ fiɛ ɔɖe ɔturi sɛɛ. ");
INSERT INTO akp_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ɔɣere ma nnɛ loba, fiɛ ka ɔpia ma sɔ makɛlɛ Yopa. ");
INSERT INTO akp_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kaɖesɛ̃a gɔ masɛ i ɔri mato makɛlɛ fiɛ maɔbore mabo Yopa ne, Petro ɔya ɔkɛlɛ ɔ̃ isã sɔ ɔ̃ɔkparama kayi ku kakɔme iɖɔwũ iweo-inyɔ ame. ");
INSERT INTO akp_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kukã ɔba kuakpɛ̃ wũ teteree, ɣɛɛ ɔwi gɔmɔ ne, kini matsɛ aɖera iwa ne. Ibara wũ kere lɛ sirɛ ame ɔto ɔbo. ");
INSERT INTO akp_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Mmɔ iɖe ɔnya sɔ kuɖokpo ɔbusi, ɔnya ira iwɛ̃ lɛ ɔkati siare gɔ mamɔɛ̃ akpakpai ana mato masora mabɔ karɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ɔkati gɔgbe ame ne, mabɔi agbãagbã, mma nsɛ mabore i karɔ̃ gu mma nsɛ i ngba iso gu kurodzai ana pia. ");
INSERT INTO akp_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ɔnɔ silɔ siwɛ̃ ɔɣere wũ sɔ, “Petro, ta si aɖoe si aɖe.” ");
INSERT INTO akp_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ne Petro ɔɣɛ sɔ, “Ooɣo! Iibaba ngbɔ! Bosate, loiɖe mabɔi ma i bo ma Yudase iisɛ bopɛgu lonya!” ");
INSERT INTO akp_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Silɔ ɔledza wũ iɣere sɔ, “Ira nɛ i Ɣaa ɔɔsekelera ne, daarɔ ne sɔ iikpa!” ");
INSERT INTO akp_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ɔnya iɖi ite nɛgbe ikpɛ itɛ buu. Ɔkpɛ tɛa ne, masu ɔkati gɔgbe makɛlɛgu kato. ");
INSERT INTO akp_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ira nɛ i Petro ɔnya ɔbara wũ ɣii, ne ɔkarɛ so sɔ, “Be i iɖi ite nɛgbe to ite?” Ɔwi gɔmɔ ana ne, mma i Kornelio ɔpia ɔɔba maabo ɔmagɛ̃ ame. Ne gɔ manya iyo nɛ mato mabie ne, maba maaya i kayogodɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ne makarɛ si mmɔ i Simon Petro si ne. ");
INSERT INTO akp_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Gɔ Petro si ɔto ɔbu iti ame i ɔ̃ iɖi ite iso gu kumɛgɔ ɔ̃abara ɔ̃anɔ karɔ̃ ne, Siwarã Bielea ɔɣere wũ sɔ, “Maturi itɛ ɔba mato mabie-ɔ. ");
INSERT INTO akp_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ta si asɛ aanya ma. Daanigã sɔ aasiai ma akɛlɛ ala me lopia ma.” ");
INSERT INTO akp_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ne Petro ɔta ɔkɛlɛ ma kɔrɛ ɔɣere ma sɔ, “Mme nɖe ngɔ mito mibie. Wũ kɔrɛ pɔkɔsɔɔ?” ");
INSERT INTO akp_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ne maɣere wũ sɔ, “Bo wũ boisɛ ku ikpi, Kornelio gɔ nɖe ma Romase makpakpɛ̃dze ɔkpakpa lopia bo fɔ kɔrɛ. Ɔturi sɛɛ ɔɖe gɔ nsɛ ɔwarɛ Ɣaa. Ma Yudase ɔɖuɖu sɛ maɖɔɛ ɔ̃ itɔ̃me gbaã. Ɣaa kpabo ɔwɛ̃ loɣere wũ sɔ ɔpia si makpere-ɔ si ɔnɔ fɔ kanya ame kutsuɛ.” ");
INSERT INTO akp_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ne ɔso Petro ɔtã ma mabo i kawekɔ̃, ɔfɔ ma lɛ ɔ̃ mafɔ awe. Gɔ kaɖe ɔsɛ̃ ne, ɔ̃ gu mafɔɖedze mawɛ̃ ma lobɔrɛ i Yopa ɔsiai ma makɛlɛ. ");
INSERT INTO akp_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Si maasɛ maabo Kaisarea gu kaɖesɛ̃a ne, Kornelio ɔɔsa ɔ̃ iyo maturi kanya gu ɔ̃ malaa masi masia Petro iba. ");
INSERT INTO akp_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Gɔ Petro ɔbo kayogodɔ̃ ne, Kornelio ɔpɛ agɛgɛ̃ i Petro katɔ̃, ɔbɔ iti karɔ̃ ɔtã wũ. ");
INSERT INTO akp_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ne Petro ɔɣere wũ sɔ, “Ta ya! Mme wũ ɔturi loɖe.” ");
INSERT INTO akp_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Gɔ mato maɖe ika ne, Kornelio ɔkɔ wũ ɔbogu i iyo fiɛ ɔnya sɔ maturi gbodzoo ɔsakanya. ");
INSERT INTO akp_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ne Petro ɔɣere ma sɔ, “Mi mɔmɔ miɣe sɔ bo ma Yudase mmara iitã me ɔri sɔ loawo ngɔ loiɖe bo aɖe ɔturi iyo ɔbo, ɣee losu so lomatãra i ɔ̃ iso. Ɣɛɛ Ɣaa ɔɖi ɔte me sɔ lodaanyɔ ɔturi kuwɛ̃ lɛ ɔturi gɔ loikpa. ");
INSERT INTO akp_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ne ɔso fiɛ gɔ maba maakpere me ne, lota loba ne. Be ɔso fiɛ ato abie me?” ");
INSERT INTO akp_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ne Kornelio ka ɔpia kanya ɔɣere wũ sɔ, “Ka iaɖe lɛ ayi ana ngbe gɔ loto lokparama kayi ku kakɔme. Ɔluwɛ̃ ne, ɔrɛrɛ̃ ɔwɛ̃ ɔbɔrɛ me i katɔ̃ gɔ ɔpia ara wa nto afiɛ atsue anɔmi! ");
INSERT INTO akp_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ɔ̃ loɣere me sɔ, ‘Kornelio, fɔ kayiribielea ibara gu fɔ kayi ikparama ɔɖuɖu ɔɔbo Ɣaa kɔrɛ! ");
INSERT INTO akp_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Pia maturi si makɛlɛ Yopa si masɛ maakpere Simon Petro gɔ mpia i Simon gɔ nsɛ ɔbara mabɔi siko karabara i ɔpo kanya kɔrɛ.’ ");
INSERT INTO akp_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ɔluwɛ̃ ne lopia sɔ maba maakpere-ɔ, fiɛ fɔ wũ abara kukaakɔ sɔ aba ne. Ne ɔso bosi bosia-ɔ i Ɣaa anɔ ame sɔ ka ba ɣere bo nnɛ i Bosate ɔtã-ɔ sɔ ɣere bo ne.” ");
INSERT INTO akp_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ne Petro ɔɣere ma sɔ, “Loɔnya sekelee sɔ Bosate iisɛ ɔnyɔ maturi i katɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ɣɛɛ i karɔ̃ biara iso ne, ngɔ lonya ɔbɔ so karɔ̃ ɔtã Ɣaa fiɛ ɔsɛ ɔbara ɔ̃ kuɖɔɛ ne, Ɣaa sɛ ɔfɔ wũ. ");
INSERT INTO akp_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Lofɔ loɖe sɔ minɔ itɔ̃me nɛ i Ɣaa ɔɣere Israel mabi sɔ, Itɔ̃me Bielea iki Yesu Kristo gɔ nɖe maturi ɔɖuɖu Sate ame boaki boana isobuɛ. ");
INSERT INTO akp_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Fiɛ miɣe ara nyaa wa loba i Yudea karɔ̃ iso ɔɖuɖu wa losɛ karɔ̃ i Galilea karɔ̃ iso ita i ɔwi gɔ i Yohanes ɔpɛ imomo i Ɣaa itupie kubarara iso. ");
INSERT INTO akp_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Minɔ ana kumɛgɔ i Ɣaa ɔsu Siwarã Bielea ɔsia Yesu gɔ lobɔrɛ i Nasaret ikparĩ fiɛ ɔsu ɔle ana ɔtã wũ. Ɔwe ɔki ɔbara ara sɛɛ fiɛ ɔsa mma ɔɖuɖu i Ɔbosam to ɔkpɛ̃gu, alasɔ Ɣaa sɛgu wũ. ");
INSERT INTO akp_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ara wa ɔba ɔ̃abara i Israel karɔ̃ iso gu Yerusalem ne, bonya wã ala anɔ. Mmɔ i maɖoe wũ iki ipɛ wũ imatãra i kudziri iso ne. ");
INSERT INTO akp_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ɣɛɛ ne, Ɣaa ɔledza wũ itara ibɔrɛgu i kukpi ame ku iyi tɛare iso, fiɛ ɔtã sɔ maturi ɔnya wũ. ");
INSERT INTO akp_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Iiɖe maturi ɔɖuɖu lonya wũ. Ɣɛɛ bo ma i Ɣaa ɔɖi ne, bo lonya wũ ne. Boɖe fiɛ bonɛgu wũ ana i ɔ̃ ita kama. ");
INSERT INTO akp_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Bo iɖe i Yesu ɔpia sɔ bosɛ boaɣɛ Itɔ̃me Bielea nɛgbe i kakɔi biara, si boɣere ma sɔ, Ɣaa ɔsu Yesu ɔbara makpise gu manyɔdze atɔ̃meɣɛdze. ");
INSERT INTO akp_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ɣaa kanyamaɖidze ɔɖuɖu ɔtsɛrɛ i ɔ̃ iso sɔ ɔturi biara gɔ loafɔ wũ ɔɖe ne, Ɣaa to ɔ̃asu ɔ̃ akpi ɔtsɛ wũ i Yesu iyere ame.” ");
INSERT INTO akp_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ɔwi gɔ i Petro ɣɛ ɔto ɔɣɛ atɔ̃me wagbe ne, Siwarã Bielea ɔso sifere mma nsi mato makã wũ atsue ɔɖuɖu iso! ");
INSERT INTO akp_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ma Yudase fɔɖedze ma losiai Petro masɛ mmɔ ne, nnɛgbe ɔbara ma ɣaa, alasɔ Siwarã Bielea ɔba i mma loiɖe ma Yudase iso. ");
INSERT INTO akp_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Manɔ mma loiɖe ma Yudase to maɣɛ siɖe agbãagbã male Ɣaa. Ne Petro ɔkarɛ sɔ, ");
INSERT INTO akp_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Gɔ maɔfɔ Siwarã Bielea lɛ kumɛgɔ bo wũ bofɔ ne, boibawo ma ɔri ɔtɛ̃ sɔ madaafɔ Ɣaa itupie.” ");
INSERT INTO akp_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ne ɔso ɔtã sɔ mapie ma ndu i Yesu Kristo iyere ame. Ne kama ne, mapɛ Petro nrɔɔ̃ sɔ ɔwegu ma ayi kɛkɛĩ. ");
INSERT INTO akp_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Katɔ̃memasɛdze gu mafɔɖedze ma i Yudea ɔnɔ sɔ mma loiɖe ma Yudase ana ɔɔfɔ Ɣaa itɔ̃me. ");
INSERT INTO akp_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ɣɛɛ gɔ Petro ɔkpese ɔkɛlɛ Yerusalem ne, ma Yudase fɔɖedze mawɛ̃ ɔtsɛgu wũ atɔ̃me ikpadzɛ̃gu, mabie sɔ mma loiɖe ma Yudase fiɛ mafiniki si matu sirɛrɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Maɣere wũ sɔ, “Asɛ aabara mawɛ̃ ku mafɔ ma loitu sirɛrɛ̃ fiɛ apia kɔrɔ̃ aɖegu ma aɖera i irɔi ame!” ");
INSERT INTO akp_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ne Petro ɔɖiɖi ara wagbe ɔɖuɖu karɔ̃ ɔɣere ma sɔ, ");
INSERT INTO akp_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Gɔ lopia i Yopa nto lokparama kayi ne, lɛ sirɛ nto lorɛ ne, lonya kaɖikate. Lonya kato ɔbusi fiɛ ira nɛ nse lɛ ɔkati siare gɔ mamɔɛ̃ akpakpai ana i kato ɔso ɔba i karɔ̃ i wũ kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Gɔ lonyɔ ɔ̃ ame ne, lonya ayo ame mabɔi gu mabɔi lalaa, ma nsɛ masɛ i ngba iso, mma nsɛ mabore i karɔ̃ gu kurodzai. ");
INSERT INTO akp_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Lonɔ silɔ ɔɣere me sɔ, ‘Petro! Ta si aɖoe mawɛ̃ si aɖe.’ ");
INSERT INTO akp_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Ne loɖi kanya sɔ, ‘Bosate, ooɣo! Iibaba ngbɔ! Loiɖe mabɔi ma i bo ma Yudase iisɛ bopɛgu lonya.’ ");
INSERT INTO akp_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ɣɛɛ silɔ dzɛgbe ɔledza iɣɛ sɔ, ‘Ira nɛ i Ɣaa ɔɔsekelera ne, daaɣɛ sɔ iikpa.’ ");
INSERT INTO akp_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ibara ngbɔ ikpɛ itɛ buu. Ne kama ne, makpesegu ɔkati siare gɔgbe gu mabɔi i kame makɛlɛgu kato. ");
INSERT INTO akp_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ɔwi gɔmɔ ame tutuutu ne, maturi itɛ ma mapia mabɔrɛgu i Kaisarea sɔ maba maakpere me mabɔ ɔɔba maɣɛ i iyo nɛ ame lopia kayogodɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Siwarã Bielea ɔɣere me sɔ lota losiai ma ne lodaanigã. Ne ɔso mafɔɖedze ikuɔ mawɛ̃ magbe ɔta masiai me fiɛ bokɛlɛ ɔrɛrɛ̃ gɔ lopia me ɔturi iyo. ");
INSERT INTO akp_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ɔrɛrɛ̃ gɔgbe ɔɣere bo sɔ, ‘Ɣaa kpabo ɔwɛ̃ ɔɖi so ɔte wũ i ɔ̃ iyo ɔɣere wũ sɔ ɔpia maturi Yopa si masɛ maakpere ɔrɛrɛ̃ ɔwɛ̃ gɔ marɔ sɔ Simon Petro. ");
INSERT INTO akp_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ɔ̃ loaɣere-ɔ nnɛ i mi gu fɔ iyo maturi ɔɖuɖu aabara fiɛ miana iɖi ne.’ ");
INSERT INTO akp_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Ne kama ne, lotsɛ ma Itɔ̃me Bielea iɣere. Ɔluwɛ̃ ne, Siwarã Bielea ɔba siayi ma ame lɛ kumɛgɔ siba bo iso ku karɔ̃kasɛkɔ̃! ");
INSERT INTO akp_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Mmɔ lonyigi nnɛ i Bosate ɔɣere bo sɔ, ‘Gbagbaã ne, Yohanes ɔsu ndu ɔpie maturi. Ɣɛɛ ne, Ɣaa to ɔ̃asu Siwarã Bielea ɔpie mi.’ ");
INSERT INTO akp_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Gɔ Ɣaa lotã mma loiɖe ma Yudase karatã ga ame ɔsu ɔtã bo ku ɔwi gɔ bofɔ Bosate Yesu Kristo boɖe ne, mme nɖe nna fiɛ loatɛ̃ Ɣaa ɔri?” ");
INSERT INTO akp_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Gɔ manɔ atɔ̃me wagbe ne, manyua ma kakpadzɛ̃, ne matsɛ Ɣaa ile iɣɛ sɔ, “Gbaã ne, Ɣaa ɔɔtã mma loiɖe ma Yudase ɔri sɔ maaba ɔ̃ kɔrɛ fiɛ maana ngbã.” ");
INSERT INTO akp_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ɔwi gɔ i ara wagbe to aba ne, mafɔɖedze ma lotere inyɛwe nɛ loba ma iso iki i Stefano iɖoe ame ɔsɛ maabo Foinike gu Kipro gu Antiokia ame. Makiki mato maɣɛ Itɔ̃me Bielea. Ɣɛɛ ne, ma Yudase kere mato maɣere. ");
INSERT INTO akp_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ɣɛɛ mafɔɖedze mawɛ̃ ma lobɔrɛ i Kipro gu Kirene ɔkɛlɛ Antiokia sɔ maaɣere mma loiɖe ma Yudase Bosate Yesu iso itɔ̃me. ");
INSERT INTO akp_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kumɛgɔ i Bosate ɔle piagu ma ɔso ne, maturi gbodzoo ɔfiniki mafɔ Bosate maɖe. ");
INSERT INTO akp_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Gɔ mafɔɖedze ma i Yerusalem ɔnɔ ara wa nto aba i mmɔ ne, mapia Barnaba sɔ ɔkɛlɛ Antiokia. ");
INSERT INTO akp_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Gɔ ɔbo mmɔ fiɛ ɔnya kumɛgɔ i Ɣaa nnyainyɔ piagu ma ne, so ɔɣɔ wũ gbaã, ne ɔpia ma ɔtɔ ɔbua sɔ mawe i Bosate ame teteree ku ma situ ɔɖuɖu ne. ");
INSERT INTO akp_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnaba ɖe ɔturi sɛɛ gɔ mba kafɔkaɖe, fiɛ Siwarã Bielea ɔyi ɔ̃ ame. Iki i ɔ̃ ibuai ame ne, mafɔɖedze ɔba maasi gbodzoo. ");
INSERT INTO akp_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnaba ɔkɛlɛ Tarso sɔ ɔ̃abie Saulo. ");
INSERT INTO akp_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Gɔ ɔnya wũ ne, ɔkɔ wũ ɔbɔ Antiokia, fiɛ ma inyɔɔ ɔwe i mmɔ ikɔ iwɛ̃ buu. Mawe i mmɔ mate maturi gbodzoo ara. Antiokia mmɔ iɖe maɖe katɔ̃ makpere mafɔɖedze sɔ Kristo mare ne. ");
INSERT INTO akp_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ayi wamɔ ame ne, Ɣaa kanyamaɖidze mawɛ̃ ɔbɔrɛ i Yerusalem maba Antiokia. ");
INSERT INTO akp_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ma ɔwɛ̃ gɔ marɔ Agabo ɔta ɔya i Siwarã Bielea ɔle ame ɔɣɛ sɔ kukã siare to kuabo kayiiso ɔɖuɖu. Nnɛgbe ɔba ngbɔ ku ɔwi gɔ i Klaudio to ɔɖe sigara. ");
INSERT INTO akp_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ne ɔso mafɔɖedze ma i Antiokia ɔsia ita sɔ maato ara i ɔbiara ɔle kanya masese manyii ma mpia i Yudea. ");
INSERT INTO akp_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Gɔ masa ara wagbe kanya ne, masu matã Barnaba gu Saulo sɔ masu makɛlɛgu mafɔɖedze makpakpa i Yerusalem. ");
INSERT INTO akp_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ɔwi gɔmɔ ame ne, Igara Herodes ɔtsɛ mafɔɖedze mawɛ̃ kama iti si ɔbara ma ɔtile. ");
INSERT INTO akp_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ɔtã maɖoe Yakobo gɔ nɖe Yohanes ɔnyiibi ala ipɛmi. ");
INSERT INTO akp_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Gɔ ɔnya sɔ nnɛ ɔbara ɔwe ma Yudase ɔmɛrɛ̃ ne, ɔtã mamɔɛ̃ Petro ana ku ɔwi gɔ nɖe Boɖoboɖo Gɔ Loita Iyi ɔɖewi. ");
INSERT INTO akp_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Masu wũ mapia i iyo nɛ i madzuɛ̃se ina akuri ana wa nsɛ manyuarã so to madzuɛ̃ ame. Herodes adzuni loɖe sɔ ɔ̃aɖi wũ ɔtã ɔ̃ maturi maɣɛgu atɔ̃me i itiri ku iyi nɛ masɛ marɔ sɔ Kukpi Ɔtakuwara Bo Iyi iɖe kama. ");
INSERT INTO akp_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Gɔ Petro rɛ i iyo ne, mafɔɖedze ɔkparama kayi i ɔ̃ iti teteree. ");
INSERT INTO akp_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Iyi nɛ kaɖesɛ̃a i Herodes aaɖi Petro ɔtã maɣɛgu atɔ̃me kasɛ̃ ame ne, Petro rɛ i madzuɛ̃se inyɔ ndɛ̃ ɔto ɔrɛ sirɛ. Mapia wũ i kugbagɔrɔĩ kunyɔ ame i madzuɛ̃se inyɔ ndɛ̃, fiɛ madzuɛ̃se mawɛ̃ ana ɣɛ i kayogodɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ɔluwɛ̃ ne, Ɣaa kpabo ɔwɛ̃ ɔba ɔ̃ɔya i Petro kɔrɛ. Ikpawaĩ ɔfiɛ ibo i iyo ame, ne ɔpɛ Petro iwãgɛsɛ ɔtara sɔ, “Ta ya mala!” Kugbagɔrɔĩ gɔ mpia wũ i nrɔɔ̃ kere lokpase kuse i karɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kpabo gɔgbe ɔɣere wũ sɔ, “Nyi so kafiami si apia fɔ ndokota!” Petro ɔbara ngbɔ. Ne kpabo ɔledza wũ iɣere sɔ, “Su fɔ awu tagbaraa pia si asiai me!” ");
INSERT INTO akp_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ne Petro ɔbɔrɛ ɔsiai wũ ne. Ɔwi gɔgbe ame ɔɖuɖu ne, ito ibara wũ lɛ kurɛ ɔto ɔsɛ̃, ɔ̃itsue sɔ gbaã iɖe ");
INSERT INTO akp_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Maki mabɔrɛ i kayogodɔ̃ ɖeakatɔ̃ gu kanyɔare ame gu kɔ̃ madzuɛ̃se ndɛ̃. Gɔ masɛ maabo ibɔra kukui gɔ nɖe kayogɔdɔ̃ siare ga losese kabo i ɔmagɛ̃ ame ne, kã mɔmɔ ɔsese so. Maki mabɔrɛ i mmɔ ana. Gɔ mata masia i ɔri ɔwɛ̃ iso masɛ kɛkɛĩ ne, Ɣaa kpabo gɔmɔ ɔyu i Petro anɔ. ");
INSERT INTO akp_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Gɔ Petro ɔba ɔ̃atsue nnɛ loba ne, ɔɣere so sɔ, “Gbagbaã ne, Bosate lopia ɔ̃ kpabo sɔ ɔba ɔ̃ɔɖi me ɔbɔrɛgu i Herodes nrɔɔ̃ ame gu ara wa i ma Yudase ɔbu sɔ maabara me ame!” ");
INSERT INTO akp_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Gɔ Petro ɔbu nnɛ loba ne, ɔrui ɔkɛlɛ Maria gɔ nɖe Yohanes gɔ marɔ ana sɔ Marko ɔnyi iyo. Mmɔ i mafɔɖedze gbodzoo ɔsakanya mato makparama kayi ne. ");
INSERT INTO akp_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Gɔ ɔkpukpura ɔkpã kayogodɔ̃ ga nsɔ̃ ɔri ne, ɔɖabo birɔ̃gomi gɔ marɔ Roda ɔba sɔ ɔba ɔ̃asese. ");
INSERT INTO akp_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ɣɛɛ gɔ ɔnɔ Petro silɔ ɔɖi ite ne, isoɣɔ lala ɔmɔɛ̃ wũ ɔso ɔ̃isese iyo. Ɔtere ɔkɛlɛ ɔ̃ maturi kɔrɛ ɔsɛ ɔ̃aɣere ma sɔ Petro ɔɔba ɔɣɛ i kayogodɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ɣɛɛ maifɔ maɖe. Makarɛ wũ sɔ, “Ɔlala ato?” Ɣɛɛ gɔ ɔtogu isɛ̃ ipia ma sɔ gbaã iɖe ne, maɣere so sɔ, “Siainyɔ ɔ̃ Ɣaa kpabo ɔɖe loɔba ɔɣɛ i mmɔ.” ");
INSERT INTO akp_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ɔwi gɔgbe ɔɖuɖu ame ne, Petro ɣɛ i mmɔ ɔtogu kukui ikpukpura. Gɔ masɛ maasese kukui fiɛ manya wũ ne, ibara ma ɣii! ");
INSERT INTO akp_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Gɔ ɔlora ma ala kɔrɔ̃ ne, ɔɣere ma ara wa loba gu kumɛgɔ i Bosate ɔba ɔ̃aɖi wũ ɔbɔrɛgu i iyo. Ɔɣere ma sɔ maɣere Yakobo gu matsɔra nnɛ loba. Ne kama ne, ɔrui i mmɔ ɔkɛlɛ kakɔi mama. ");
INSERT INTO akp_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Gɔ kaɖe ɔsɛ̃ ne, ikpɔkpɔtɔ siare ɔbo i madzuɛ̃se ndɛ̃ alasɔ maiɣe nnɛ lobɔrɛ Petro iso. ");
INSERT INTO akp_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Gɔ Herodes ɔnyɔnyɔ Petro kukaakɔ fiɛ ɔ̃inya wũ ne, ɔtã mamɔɛ̃ madzuɛ̃se mamɔ mabɔ wũ. Gɔ ɔɣɛgu ma atɔ̃me ne, ɔtã sɔ maɖoe ma. Ne kama ne, Herodes ɔrui i Yudea ɔkɛlɛ Kaisarea sɔ ɔ̃asɛ i mmɔ kɛkɛĩ. ");
INSERT INTO akp_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ɔwi gɔmɔ ame ne, kulu ɔwe i Herodes gu Tiro gu ma Sidonse ndɛ̃. Mapia makpabo mabɔrɛgu i Tiro gu Sidon sɔ masɛ maanya wũ. Gɔ masɛ ne, makarɛ ibuai mabɔrɛgu i Blasto gɔ nɖe Herodes ɔɖabo kɔrɛ sɔ ɔtã Herodes iti ɔtã ma si mafere kanya ndu i ma simagɛ̃ gu Herodes ndɛ̃ alasɔ Herodes karɔ̃ iso i ma aɖera sɛ abɔrɛ. ");
INSERT INTO akp_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Iyi nɛ i Igara Herodes ɔsɛ ma sɔ maba ne, ɔpia ɔ̃ agagã gu ɔ̃ sigara ara fiɛ ɔsɛ i ɔ̃ sigaraiyara iso ɔtsɛ ika iɖe. ");
INSERT INTO akp_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Gɔ ɔɖe ika ɔro ne, maturi ɔla kulu maɣɛ sɔ, “Ɣaa silɔ siɖe ngbe ne iiɖe ɔturi sire siɖe!” ");
INSERT INTO akp_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ɔluwɛ̃ ne, Ɣaa kpabo ɔtã Herodes ɔbo ɔnyɛ, alasɔ ɔ̃isu ile ɔtã Ɣaa. Makorogbarɛ ɔwe wũ fiɛ ɔkpi. ");
INSERT INTO akp_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Bosate Itɔ̃me Bielea ɔɣa gbaã, itã sɔ mafɔɖedze ana ɔsi mabua. ");
INSERT INTO akp_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Gɔ Barnaba gu Saulo ɔro ma karabara ga mapia ma ɔbara ne, marui i Yerusalem fiɛ makɔ Yohanes gɔ marɔ ana sɔ Marko maruigu. ");
INSERT INTO akp_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","I Antiokia ne, Bosate kanyamaɖidze gu maratedze ɔwe i mafɔɖedze ikuri ame. Ma nɖe Barnaba gu Simon gɔ marɔ Ɔturi Kpinakpina gu Lukio gɔ lobɔrɛ i Kirene gu Manaen gɔ nɖe Igara Herodes sibiɛtɛ ame ɔlaa gu Saulo. ");
INSERT INTO akp_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Gɔ mapia mato manyi kanya male Ɣaa ne, Siwarã Bielea ɔɣere ma sɔ, “Miɖi Barnaba gu Saulo misɛ mitã karabara ga ɔso lokpere ma.” ");
INSERT INTO akp_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Gɔ manyi kanya, makparama kayi i ma iti ne, masia ma nrɔɔ̃ iso, ne maɖi ma ɔri ne. ");
INSERT INTO akp_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Gɔ Siwarã Bielea ɔɖi Barnaba gu Saulo ɔri ne, makɛlɛ ɔmagɛ̃ gɔ marɔ Seleukia. Mmɔ iɖe masɛ maasu ɔkolo mawara makɛlɛ karɔ̃ ga i ndu ɔki milɔ marɔ sɔ Kipro iso ne. ");
INSERT INTO akp_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Gɔ masɛ maabo ɔmagɛ̃ gɔ marɔ Salami ame ne, makɛlɛ ma Yudase kusarɛkɔ̃ masɛ maaɣɛ Bosate itɔ̃me. Marko Yohanes ana siai ma lɛ ma buaidze. ");
INSERT INTO akp_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nnɛgbe kama ne, mafe makɛlɛ ɔmagɛ̃ gɔ marɔ Pafo. Mmɔ iɖe masarɛgu ɔ Yudase gɔ marɔ Bar-Yesu. Ɔsɛ ɔpɛ sibɔ fiɛ ɔɖe mila kanyaɖidze. ");
INSERT INTO akp_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Wase gɔgbe gu abã ɔkpakpa gɔ marɔ Sergio Paulo ne, malaa maɖe. Ɔkpakpa nɔgbadze gɔgbe ɔpia sɔ makpere Barnaba gu Saulo mabɔ si ɔnya ma, alasɔ ɔto ɔbie sɔ ɔnɔ Ɣaa itɔ̃me. ");
INSERT INTO akp_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ɣɛɛ gɔ masɛ ne, wase gɔ masɛ marɔ ana sɔ Elima i Griki siɖe ame ne, ɔkpadzɛ̃gu ma atɔ̃me. Ɔbie sɔ si ɔfinikira ɔkpakpa adzuni i itɔ̃me nɛ i Saulo gu Barnaba ɔba maɣɛ iso. ");
INSERT INTO akp_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ɣɛɛ Saulo gɔ masɛ marɔ Paulo ana fiɛ Siwarã Bielea ɔyi i ɔ̃ ame ɔnyɔ Elima totoroo ");
INSERT INTO akp_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ɔɣere wũ sɔ, “Fɔ Satana ɔbi, ayigu mila gu kasɔla fiɛ atsiri ira sɛɛ, mme ɔwi aanyua ita iya i Ɣaa ɔnukuare iso? ");
INSERT INTO akp_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Bosate to ɔ̃akpadzɛ̃-ɔ kutsue ɔtã sɔ fɔ anɔmi aabiɛ, aisibanya kuɣɛ̃ gbɔgbɔɔgbɔ iafɔ ɔwi!” Ɔluwɛ̃ ɔ̃ anɔ ko lobara wũ guduu ɔ̃isito ɔnya ɔtsɛ nrɔɔ̃ ilala ibie maturi sɔ mamɔɛ̃ wũ kɔrɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gɔ abã ɔkpakpa ɔnya nnɛ loba ne, Bosate Itɔ̃me Bielea ite ɔbara wũ ɣaa, ne ɔso ɔfɔ ɔɖe. ");
INSERT INTO akp_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo gu mma nsiai wũ ɔbo i ɔkolo ame marui i Pafo makɛlɛ Perge ɔmagɛ̃ gɔ mpia i Pamfilia. Mmɔ i Marko Yohanes ɔkpese ma i kama ɔkɛlɛ Yerusalem ne. ");
INSERT INTO akp_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Gɔ mabɔrɛ i Perge ne, makɛlɛ Antiokia ɔmagɛ̃ i Pisidia kumɛ iso. Iwarãyi iso ne, makɛlɛ ma Yudase kasarɛkɔ̃ masɛ maasɛ i karɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ɔwi gɔ maɔka ara mabɔrɛgu i Mose mmara ɔko gu Ɣaa kanyamaɖidze ara itsɛrɛ ame maro ne, kasarɛkɔ̃ matɔ̃ɖedze ɔɣere ma sɔ, “Manyii, si mi ɔrere ba itɔ̃me nɛ loapia bo ɔle ne, ɔba ɔ̃aɣɛ.” ");
INSERT INTO akp_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ne Paulo ɔta ɔkɔlɛ kɔrɔ̃ ɔɣere ma sɔ, “Ma Israelse gu mi mma loiɖe ma Israelse ɔɖuɖu, mi mma nsɛ mawarɛ Ɣaa ne, mikã atsue si minɔ! ");
INSERT INTO akp_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ɣaa gɔ i ma Israelse sɛ manigã ɔɖi bo mawa fiɛ ɔkɔlɛ ma kato ɔbara ma kaɖe siare ɔwi gɔ maɖe mafɔ i Egipte. Ɔ̃ mɔmɔ loɖi ma ɔbɔrɛgu i sisande ame i Egipte karɔ̃ iso ku ɔ̃ ɔle. ");
INSERT INTO akp_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ɔnyɔ ma iso i fafuĩ ame gɔ mawe makiki i akɔ sina ame. ");
INSERT INTO akp_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Gɔ ɔwɔra abuiti akɔdzɛ maturi ma i Kanan ne, ɔsu ma nrɔ̃ ɔtã ma Israelse lɛ ma kaɖekɔ̃ awe. ");
INSERT INTO akp_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ara wagbe ɔɖuɖu ɔba lɛ akɔ alafa ana gu siru ame. “Ne kama ne, Ɣaa ɔtã ma atɔ̃memaɣɛdze ma loɖe ma iso isɛ iabo kanyaɖidze Samuel ɔwi. ");
INSERT INTO akp_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ne matã wũ iti sɔ ɔsɛra igara ɔtã ma. Ɣaa ɔtã ma Kis ɔbi Saulo gɔ lobɔrɛ i Benyamin ɔɣekparɛ ame, fiɛ ɔɖe sigara akɔ sina. ");
INSERT INTO akp_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ɣɛɛ Ɣaa ɔtara wũ i iyara iso fiɛ ɔsu David ɔsɛra i ɔ̃ kanya. David gɔgbe nɖe ngɔ iso i Ɣaa ɔɣɛ sɔ, ‘Yese Ɔbi David nɖe ɔturi gɔ ara lomɔɛ̃ me ɔtu, alasɔ ɔto ɔ̃abara wũ kuɖɔɛ.’ ");
INSERT INTO akp_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“David gɔgbe ɔɣekparɛ ame ne, Ɣaa ɔɖi Ɖidze gɔ nɖe Yesu gɔ ɔtã ma Israelse lɛ kumɛgɔ ɔkã ndamu ɔtã bo ne. ");
INSERT INTO akp_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Si Yesu aaba ne, Ndupiedze Yohanes ɔba ɔ̃aɣere ɔturi biara i Israel sɔ ɔfiniki ɔbɔrɛ i ɔ̃ akpi ame si ɔsu ɔ̃ anɔ ɔsia i Ɣaa iso si ɔtã mapie wũ ndu. ");
INSERT INTO akp_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ɔwi gɔ i Yohanes karabara ɔɔbo kawirikɔ̃ ne, ɔkarɛ sɔ, ‘Mibu sɔ mme nɖe Mesia? Ooɣo! Ɔsiai me i kama ɔto ɔba, fiɛ loikote sɔ loasɛ i ɔ̃ ngbatɔ̃ ɖuɖuuɖu.’ ");
INSERT INTO akp_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Manyii, mi ma nɖe Abraham mabi gu mi ma loiɖe ma Yudase ɣɛɛ misɛ miwarɛ Ɣaa ne, mikã atsue si minɔ! Iɖi nnɛgbe ne, bo ɔɖuɖu ire iɖe! ");
INSERT INTO akp_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Mma mpia i Yerusalem gu ma makpakpa iitsue sɔ Yesu nɖe Ɖidze gɔ boto bonyɔ ɔri. Mainɔ Ɣaa kanyamaɖidze ara wa maɣɛ masɛ fiɛ masɛ maka ku iwarãyi biara iso karɔ̃. Ɣɛɛ gɔ matã wũ kukpi ipɔ ne, matã sɔ kanyamaɖidze atɔ̃me ɔba i ne ame. ");
INSERT INTO akp_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Mainyagu wũ ikpi kuiwɛ̃ nɛ ɔso maatã wũ kukpi ipɔ, ɣɛɛ maɣere Pilato sɔ ɔɖoe wũ. ");
INSERT INTO akp_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Gɔ maɔbara ara wa ɔɖuɖu i Ɔko Sekelea ɔɣɛ ɔsɛ i ɔ̃ kukpi iso maro ne, mabɛse wũ i kudziri iso masɛ maabiara i ikpibiɔ ame. ");
INSERT INTO akp_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ɣɛɛ Ɣaa ɔtara wũ ɔɖi i makpise ndɛ̃ ɔpia ngbã. ");
INSERT INTO akp_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ne kama ne, ma gu mma lobɔrɛ i Galilea makɛlɛ Yerusalem ɔnya wũ ɔwi gbodzoo. Mmamɔ nɖe ɔ̃ maɖansiɛ matã ma Israelse ne. ");
INSERT INTO akp_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Ɣaa ndamu mɛ ɔkã ɔtã bo mawa ne, me Itɔ̃me Bielea bosu bobɔ mi ");
INSERT INTO akp_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","si miatsue sɔ Ɣaa ɔbara i ɔ̃ ndamu iso ɔtã bo. Ne ɔso i Ɣaa ɔtara Yesu ɔbɔrɛgu i makpise ame ɔtã bo lɛ kumɛgɔ i David ɔtsɛrɛ i ɔ̃ kuka nyɔare ame sɔ Ɣaa ɔɣɛ i Yesu iso sɔ, ‘Wũ Ɔbi aɖe. fiɛ nɔme lokpese fɔ ɔse.’ ");
INSERT INTO akp_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Gɔ Ɣaa ɔtara Yesu ɔbɔrɛgu i makpise ame sɔ ɔ̃ibaburi ɔnya lɛ kumɛgɔ i Ɣaa ɔɣɛ i ɔ̃ iso sɔ, ‘Loatã-ɔ wũ kusɛkusɛ sekelea ndamu mɛ lokã lotã David.’ ");
INSERT INTO akp_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Fiɛ ana ne, ɔɣɛ i David kuka mama ame sɔ, ‘Aibatã sɔ fɔ Ɔturi Sekelea aaburi ɔwe i ikpibiɔ ame.’ ");
INSERT INTO akp_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Iiɖe David itɔ̃me nɛgbe to, alasɔ gɔ ɔ̃ɔsɛ ngbã ɔbara Ɣaa mɔmɔ kuɖɔɛ ne, ɔkpi mabiara wũ, fiɛ ɔ̃ sosina ana ɔburi. ");
INSERT INTO akp_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ɣɛɛ Yesu gɔ i Ɣaa ɔtara ɔbɔrɛgu i makpise ame ne, ɔ̃ sosina iiburi. ");
INSERT INTO akp_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Manyii, mikã atsue! Iki i Yesu gɔgbe iyere ame ne, Ɣaa to ɔ̃asu mi akpi ɔtsɛ mi. ");
INSERT INTO akp_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ɔbiara gɔ lofɔ Yesu ɔɖe ne, Ɣaa to ɔ̃atã wũ ibɛ. Ira nɛ i Mose mmara iiwo ɔbara ");
INSERT INTO akp_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ne ɔso minyɔ kukaakɔ! Midaatã sɔ Ɣaa kanyamaɖidze atɔ̃me wa maɣɛ masɛ aaba mi iso. ");
INSERT INTO akp_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Alasɔ Ɣaa ɔɣɛ sɔ, ‘Mi mma loisɛ miwarɛ wũ itɔ̃me ne, minyɔ kukaakɔ ito iabara mi ɣaa fiɛ miawɔ! Alasɔ loto loabara ira iwɛ̃ i mi ɔwi ame gɔ si minɔ ɣee maɣere mi ne, miibafɔ miɖe.’ ” ");
INSERT INTO akp_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ɔwi gɔ Paulo gu Barnaba to marui i kasarɛkɔ̃ ne, maturi ɔɣere ma sɔ maledza ikpese iba iaɖe ma ika i ara wagbe iso ku iwarãyi nɛ loaba iso. ");
INSERT INTO akp_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Gɔ masame ne, ma Yudase gbodzoo gu mma lofiniki makpese ma Yudase fiɛ masɛ manigã Ɣaa i kasarɛkɔ̃ mmɔ ɔsiai Paulo gu Barnaba. Maka ma kumɛgɔ maaya teteree i Ɣaa nnyainyɔ nɛ ɔsu ɔtã ma ngbe ame. ");
INSERT INTO akp_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Iwarãyi nɛ ka losiai nnɛmɔ ne, ikuti kɛkɛĩ tee kaɖe gamɔ maturi ɔɖuɖu ɔsɛ kasarɛkɔ̃ sɔ maanɔ Bosate itɔ̃me. ");
INSERT INTO akp_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Gɔ ma Yudase makpakpa ɔnya maturi kposu ma loba kasarɛkɔ̃ ne, ma anɔmi ɔrɛtɛ ne matsɛ kakpadzɛ̃ ku Paulo mato maɣɛ atsuɛ pɛ̃ i nnɛ ɔto ɔɣɛ iso. ");
INSERT INTO akp_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ne Paulo gu Barnaba ɔɣere ma ku kagbegbe sɔ, “Mi ma Yudase ikote sɔ boaɣere Itɔ̃me Bielea nɛgbe tɔtɔ. Ɣɛɛ ngbɔ minɔ ne fiɛ misɛ̃ sɔ miito mifɔ ngbã mɛ nna katui itɔ̃me nɛgbe ne, bosu ne botã mma loiɖe ma Yudase. ");
INSERT INTO akp_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Nnɛgbe nɖe katɔ̃me ga i Ɣaa ɔpia bo sɔ, ‘Loasu-ɔ lobara ɔkaniɛ lotã mma loiɖe ma Yudase si aasu iɖi nɛgbe abɔ kayiiso ɔɖuɖu.’ ” ");
INSERT INTO akp_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Gɔ mma loiɖe ma Yudase ɔnɔ nnɛ maɣɛ ne, so ɔɣɔ ma male Bosate Itɔ̃me. Mma ɔɖuɖu i Bosate ɔɖi ɔtã ngbã ɔfiniki makpese mafɔɖedze. ");
INSERT INTO akp_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Bosate itɔ̃me ɔki ikã karɔ̃ gamɔ iso ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ma Yudase ɔnina ɔmagɛ̃ makpakpa gu marɔ̃go mawɛ̃ ma mba kawarɛtɔ̃ fiɛ masɛ manigã Ɣaa adzuni, ne ɔso kulu ɔba i ma gu Paulo mɛrɛ̃ ndɛ̃, masa ma maɖi ta ma ibuiti ame. ");
INSERT INTO akp_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Paulo gu Barnaba ɔkpakpa ma ngba sise mafere i ɔmagɛ̃ ame si ite sɔ ɔmagɛ̃ gɔmɔ maturi ɔsɛ̃ ma. Ne kama marui makɛlɛ Ikonion. ");
INSERT INTO akp_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ɣɛɛ mafɔɖedze ma i Antiokia ne, so ɔɣɔ ma fiɛ Siwarã Bielea ɔyi ma ame gbaã! ");
INSERT INTO akp_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Gɔ mabo Ikonion ana ne, Paulo gu Barnaba ɔkɛlɛ ma Yudase kasarɛkɔ̃. Ne gɔ maɣere ma Yudase gu mma loiɖe ma Yudase Itɔ̃me Bielea ne, ma gbodzoo ɔfɔ maɖe. ");
INSERT INTO akp_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ma Yudase ma loifɔ Bosate itɔ̃me maɖe ɔsu kakpadzɛ̃ mapia i mma loiɖe ma Yudase gu Paulo gu Barnaba ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ɣɛɛ katɔ̃memasɛdze ɔwe i ɔmagɛ̃ gɔgbe ame ɔwi kɛkɛĩ. Mawe kafɔkaɖe i Bosate ame fiɛ maɣɛ Itɔ̃me Bielea gu ɔle. Ɣaa ana ɔki i awawãra gbodzoo wa mabara ame ɔsia ita sɔ nnyainyɔ itɔ̃me nɛ mato maɣɛ ne, gbaã iɖe. ");
INSERT INTO akp_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Itã sɔ ɔmagɛ̃ ame maturi ɔɣɛ so aka anyɔ. Mawɛ̃ ɔsiai ma Yudase, fiɛ mawɛ̃ ana ɔsiai katɔ̃memasɛdze. ");
INSERT INTO akp_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Gɔ mma loiɖe ma Yudase gu ma Yudase gu ma makpakpa ɔta sɔ maabara katɔ̃memasɛdze ɔtile fiɛ maapɛ ma ata ne, ");
INSERT INTO akp_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","katɔ̃memasɛdze ɔnɔ, ne matere makɛlɛ Likaonia simagɛ̃ dzɛ nɖe Listra gu Derbe gu simagɛ̃ dzɛ mpia i ndɛ̃ mmɔ ame ne. ");
INSERT INTO akp_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Masɛ maaɣɛ Itɔ̃me Bielea i mmɔ. ");
INSERT INTO akp_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","I Listra ne, manya ɔrɛrɛ̃ ɔwɛ̃ gɔ nɖe bafã fiɛ ɔ̃ita ɔsɛ ɔnya gɔ maɣe wũ. ");
INSERT INTO akp_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ɔsi i mmɔ ɔto ɔkã Itɔ̃me Bielea nɛ i Paulo to ɔɣɛ atsue. Gɔ Paulo ɔnyɔ wũ totoroo sɔ ɔba kafɔkaɖe i Yesu ame fiɛ ɔfɔ ɔɖe sɔ ɔ̃awo isosarɛ ɔna ne, ");
INSERT INTO akp_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ɔla kulu ɔɣere wũ sɔ, “Ta ya i fɔ ngba iso!” Ne ɔrɛrɛ̃ gɔgbe ɔkɔlɛ ɔɣo ɔtsɛ isɛ ikiki ne. ");
INSERT INTO akp_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Gɔ mma nɣɛ mato manɔ itɔ̃me ɔnya nnɛ i Paulo ɔbara ne, mala kulu teteree i Likaonia siɖe ame sɔ, “Aɣɔ loso aba i bo ndɛ̃ lɛ maturi!” ");
INSERT INTO akp_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ne ɔso matã Barnaba iyere sɔ Seus fiɛ makpere Paulo ɔ̃ wũ sɔ Herme, alasɔ ɔ̃ loɖe ika. ");
INSERT INTO akp_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ne Seus ɔbia gɔ kuɣɔ iyo lobore imatã ɔmagɛ̃ ibere ɔsu manantsuĩ rɛrɛ̃ gu aɣatati aɣɔ̃la ɔbɔ sɔ ɔ̃ gu ɔ̃ maturi aasu masɔrɛ katɔ̃memasɛdze i ɔmagɛ̃ kayogodɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Gɔ Paulo gu Barnaba ɔnɔ nnɛ mato mabie sɔ mabara ne, makɛkɛ ma awu wa mapia. Matere mabo i maturi ndɛ̃ mato kulu ");
INSERT INTO akp_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","sɔ, “Tete mɛrɛ̃, be iɖe mito mibara? Bo wũ maturi awune kere boɖe lɛ mi. Boba mi kɔrɛ ngbe gu Itɔ̃me Bielea. Minyua ara wa nna karɔ̃ ngbe ɔbara si mifiniki misu ile mitã Bosate gɔ mba ngbã. Ɔ̃ lobara kato gu karɔ̃ gu ɔpo gu ara wa ɔɖuɖu mpia i ɔ̃ ame! ");
INSERT INTO akp_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Kokooko ne, ɔɖi kayi atsue sɔ maturi si mabara nnɛ maɖɔɛ. ");
INSERT INTO akp_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ɣɛɛ ne, ɔtogu ɔ̃ ara sɛɛ iɖi ite wa nto ate sɔ ɔpia gbaã. Ɔsɛ ɔtã kado ɔpɛ i ɔwi iso ɔtã siraɖui gu araɖea gu isoɣɔ ana.” ");
INSERT INTO akp_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Atoa sɔ katɔ̃memasɛdze ɔɣɛ nwagbe ɔɖuɖu ne, ibua iɖa fiɛ mawo ma ɔtindza sɔ madaasɔrɛ ma. ");
INSERT INTO akp_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Gɔ ma Yudase mawɛ̃ ma lobɔrɛ i Antiokia gu Ikonion ɔba maafinikira mmagbe adzuni ne, matã sɔ mapɛ Paulo ata mabore wũ maɖi i ɔmagɛ̃ ame gɔ mabu sɔ ɔ̃ɔkpi. ");
INSERT INTO akp_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ɣɛɛ gɔ mafɔɖedze ma mpia i mmɔ ɔki malɔ wũ ne, ɔledza ita ikpese ikɛlɛ ɔmagɛ̃ ame. Gɔ kaɖe ɔsɛ̃ ne, ɔ̃ gu Barnaba ɔrui makɛlɛ Derbe. ");
INSERT INTO akp_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Gɔ masɛ maaɣɛ Itɔ̃me Bielea i Derbe ne, mana mafɔɖedze gbodzoo. Ne ka makpese makɛlɛ Listra gu Ikonion gu Antiokia i Pisidia ne. ");
INSERT INTO akp_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Masɛ maapia mafɔɖedze ma mpia i mmɔ ɔle sɔ maya teteree i ma kafɔkaɖe ame. Maɣere ma ana sɔ, “Ikote sɔ boawe anyɛ gbodzoo fiɛ boana Ɣaa sigarakaɖekɔ̃ ame bobo.” ");
INSERT INTO akp_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Gɔ Paulo gu Barnaba ɔɖi matɔ̃ɖedze matã mafɔɖedze akuri ɔɖuɖu ne, manyi kanya makparama kayi, ne masu ma mapia i Bosate gɔ mafɔ maɖe nrɔɔ̃ ame ne. ");
INSERT INTO akp_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Gɔ mabɔrɛ i Pisidia simagɛ̃ ame ne, makpese makɛlɛ Pamfilia karɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Maɣɛ Itɔ̃me Bielea i Perge fiɛ mafe makɛlɛ Atalia. ");
INSERT INTO akp_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Gɔ mabɔrɛ i Atalia ne, maki i ndu iso makɛlɛ Antiokia ngbegɔ i matɔ̃ɖedze ɔsu ma mapia i Bosate nrɔɔ̃ ame ku ɔwi gɔ lofe ame sɔ ɔnyɔ ma nnya si ɔtã ma maro karabara ga mato maro ngbe. ");
INSERT INTO akp_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Gɔ masɛ maabo Antiokia ne, makpere mafɔɖedze ma mpia i mmɔ masakanya fiɛ maɣere ma nnɛ manya i ma irisɛ ame. Maɣere ma nwa i Ɣaa ɔbara ɔkigu i ma iso gu kumɛgɔ ɔ̃ɔbusi kafɔkaɖe ɔri ɔtã mma loiɖe ma Yudase. ");
INSERT INTO akp_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ne ka mawe i Antiokia gu mafɔɖedze igu ame ne. ");
INSERT INTO akp_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ɔwi gɔ i Paulo gu Barnaba pia i Antiokia ne, marɛrɛ̃ mawɛ̃ ɔbɔrɛ i Yudea maba maatsɛ mafɔɖedze ara ite sɔ, “Ikote sɔ ɔbiara aafɔ sirɛrɛ̃ itu kubarara lɛ kumɛgɔ i Mose mmara ɔte fiɛ ɔ̃ana iɖi.” ");
INSERT INTO akp_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ɣɛɛ Paulo gu Barnaba gu mmagbe ɔkpadzɛ̃ itɔ̃me nɛgbe kukaakɔ. Ne ɔso maɖi Paulo gu Barnaba gu mafɔɖedze mawɛ̃ sɔ makɛlɛ Yerusalem si ma gu katɔ̃memasɛdze gu makpakpa ma i mmɔ si manyɔ sirɛrɛ̃ itu kubarara atɔ̃me wagbe ame. ");
INSERT INTO akp_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Gɔ mafɔɖedze ɔɖi ma ɔri ne, masɛ maaki i Foinike gu Samaria mato maɣɛ kumɛgɔ i mma loiɖe ma Yudase to mafiniki masiai Bosate. Itɔ̃me nɛgbe ɔpia mafɔɖedze ɔɖuɖu isoɣɔ gbaã. ");
INSERT INTO akp_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Gɔ maba maabo Yerusalem ne, katɔ̃memasɛdze gu mafɔɖedze makpakpa gu mafɔɖedze ikuri ɔfɔ ma kukaakɔ. Ne Paulo gu Barnaba ka maɣere ma ara wa ɔɖuɖu i Ɣaa ɔbara ɔkigu i ma iso ne. ");
INSERT INTO akp_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Mafɔɖedze mawɛ̃ ma lobɔrɛ i ma Farisise ikuri ame ɔfɔ kanya maɣɛ sɔ, “Iɖe sɔ manyii ma loiɖe ma Yudase aatu sirɛrɛ̃ si mabara i Mose mmara iso.” ");
INSERT INTO akp_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ne ɔso makpakpa gu katɔ̃memasɛdze ɔsarɛ lɛ ikuri mabu itɔ̃me nɛgbe iso. ");
INSERT INTO akp_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Gɔ masarɛ mafɛ ara wagbe manyɔ gbidii ne, Petro ɔta ɔya ɔɣere ma sɔ, “Manyii, ɔwi gɔ lofe ame ne, mi mɔmɔ ɣe sɔ Ɣaa ɔɖi me ɔbɔrɛgu i mi ndɛ̃ sɔ losɛ loaɣere mma loiɖe ma Yudase Itɔ̃me Bielea nɛgbe si mafɔ maɖe. ");
INSERT INTO akp_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ɣaa gɔ nɣe maturi situ ame ne, ɔɖi ɔte sɔ ɔfɔ ma gɔ ɔtã ma Siwarã Bielea lɛ kumɛgɔ ɔtã bo. ");
INSERT INTO akp_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ɔ̃ipia ikpaki kuiwɛ̃ i bo gu ma ndɛ̃, alasɔ ɔfɔ ma i ma kafɔkaɖe iso, fiɛ ɔsu ma akpi ɔtsɛ ma lɛ kumɛgɔ ɔtsɛ bo bo are. ");
INSERT INTO akp_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Be ɔso mito mibie sɔ miala Ɣaa minyɔ kumɛgɔgbe? Bo gu bo mawa iiwo ato wagbe ɔsore! Be ɔso fiɛ mito misu wã misia i mafɔɖedze magbe iso? ");
INSERT INTO akp_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ɣɛɛ bofɔ boɖe sɔ bona iɖi iki i Bosate Yesu nnyainyɔ ame lɛ kumɛgɔ ma wũ mana iɖi.” ");
INSERT INTO akp_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ma ɔɖuɖu ka malo makã atsue awawãra siare wa i Banaba gu Paulo ɔɣere ma sɔ Ɣaa ɔbara ɔkigu i ma iso ɔtã mma loiɖe ma Yudase. ");
INSERT INTO akp_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Gɔ maro ɔɣɛ ne, Yakobo ana ɔta ɔya ɔɣere ma sɔ, “Manyii, mikã atsue si minɔ. ");
INSERT INTO akp_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon Petro ɔɔnyigira bo kumɛgɔ i Ɣaa ɔɖe katɔ̃ ɔɖi ɔ̃ kuɖɔɛ ɔte mma loiɖe ma Yudase fiɛ ɔɖi mawɛ̃ ɔbɔrɛgu i ma ndɛ̃ ɔtã so. ");
INSERT INTO akp_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Itɔ̃me nɛ i ɔ̃ kanyamaɖidze ɔɣɛ masɛ ɔkotegu Ɣaa itɔ̃me nɛ loɣɛ sɔ, ");
INSERT INTO akp_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Nnɛgbe kama ne, loaledza Igara David ayoku itara. Loaledza ara wa lonina sɔ aakpese alɛ. ");
INSERT INTO akp_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Mmɔ i mma lokuti gu mma loiɖe ma Yudase ɔɖuɖu fiɛ lokpere ma sɔ maaɖe wũ maturi aanyɔnyɔ me ne. ");
INSERT INTO akp_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ɣaa ɣe ara wagbe fiɛ ɔtã maturi ɔtsue wã ta karɔ̃kasɛkɔ̃.’ ");
INSERT INTO akp_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Ne ɔso mme Yakobo nto loɣere mi sɔ, mma loiɖe ma Yudase fiɛ masu so matã Ɣaa ne, midaatã botɛ̃ ma ɔri i kuira ame. ");
INSERT INTO akp_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ɣɛɛ ne, mitã botsɛrɛ ɔko botã ma sɔ manyua so ɔpukutura iki i aɖera wa masu masɔrɛ aɣɔ iɖe gu marɛrɛ̃ gu marɔ̃go isiai. Madaaɖe mabɔi ma manyɛdɛ̃ simɔ maɖoe si manyua ima iɖe ana. ");
INSERT INTO akp_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Alasɔ ta kokooko ne, ara wa i Mose ɔtsɛrɛ ɔsɛ ne, wã ame masɛ maka matã bo ɔwi biara i ma Yudase kasarɛkɔ̃ ku Iwarãyi fiɛ masɛ maɣɛ ne ana i simagɛ̃ ame ne.” ");
INSERT INTO akp_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Katɔ̃memasɛdze gu makpakpa gu mafɔɖedze ɔɖuɖu ma losakanya ɔnɔ karɔ̃ sɔ maaɖi maturi mawɛ̃ masiaira Paulo gu Barnaba sɔ maakɛlɛ Antiokia. Maturi inyɔ ma maɖi nɖe mafɔɖedze makpakpa Yuda gɔ marɔ ana sɔ Barsaba gu Silas. ");
INSERT INTO akp_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ɔko gɔ matsɛrɛ matã ma mato ame atɔ̃me nɖe sɔ, Nnɛgbe lobɔrɛ i katɔ̃memasɛdze gu makpakpa ma nɖe mi manyii i Yerusalem kɔrɛ ne. Boya manyii ma loiɖe ma Yudase fiɛ mabɔrɛ i Antiokia gu Siria gu Kilikia. ");
INSERT INTO akp_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Bonɔ sɔ mafɔɖedze mawɛ̃ ɔbɔrɛ i bo ndɛ̃ ngbe maba maatsɛgu mi kakpadzɛ̃ ise i bo ma Yudase sirɛrɛ̃ itu iso. Ɣɛɛ ne, boipia ma sɔ maba maaɣere mi ara wamɔ igbã. ");
INSERT INTO akp_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Gɔ bosɛ iti ame ne, bosese bo ndɛ̃ makpakpa inyɔ sɔ masiai bo manyii ɖɔɛse Banaba gu Paulo maba mi kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Masu ma ngbã matsɛ ala Bosate Yesu Kristo ɔso. ");
INSERT INTO akp_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Yuda gu Silas ana to maaledza mi ara wa iso botsɛrɛ mi ɔko ngbe iɣere. ");
INSERT INTO akp_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Alasɔ bo gu Siwarã Bielea kuɖɔɛ kuɖe sɔ boibasu ato siare kuawɛ̃ bosia mi iso, iɖo ara nyaa wagbe sɔ, ");
INSERT INTO akp_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Misɛ̃ ara wa masu masɔrɛ ala aɣɔ iɖe gu ima iɖe gu mabɔi ma manyɛdɛ̃ simɔ iɖe. Miɖi so i marɛrɛ̃ gu marɔ̃go isiai akpi ame. Si mimɔɛ̃ ara wagbe mila ne, ibua ilɛ. Ɣaa isobuɛ itã mi. ");
INSERT INTO akp_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ne ɔso mapia marɛrɛ̃ magbe Antiokia. Gɔ mabo ne, makpere mafɔɖedze ɔɖuɖu masirakanya. Ne masu ɔko gɔ mabɔrɛgu i Yerusalem matã ma ne. ");
INSERT INTO akp_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Mma ɔɖuɖu mpia mmɔ ɔna isoɣɔ gbaã i katetere atɔ̃me wa maka maɖi i ɔko ame iso. ");
INSERT INTO akp_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Gɔ Yuda gu Silas ana ɖe Ɣaa kanyamaɖidze ɔso ne, maka ma ku atɔ̃me gbodzoo mapia katetere gu ɔle. ");
INSERT INTO akp_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ayi kɛkɛĩ kama ne, mafɔɖedze ɔɖi ma ɔri sɔ makpese makɛlɛ Yerusalem ku isobuɛ. ");
INSERT INTO akp_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ɣɛɛ Silas ɔkpese ɔwe i mmɔ. ");
INSERT INTO akp_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo gu Barnaba gu mamama ɔkpese mawe i Antiokia mate ara fiɛ maɣɛ Bosate Itɔ̃me. ");
INSERT INTO akp_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Gɔ ayi ɔsia kɛkɛĩ ne, Paulo ɔɣere Barnaba sɔ, “Tã boakiki i bo manyii ma mpia i simagɛ̃ dzɛ ame bowe boɣɛ Itɔ̃me Bielea bofegu si bonyɔ kumɛgɔ mato mamɔ i Ɣaa ame.” ");
INSERT INTO akp_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnaba ɔnɔ karɔ̃ ɣɛɛ ne, ɔbie sɔ maakɔ Yohanes gɔ marɔ Marko makɛlɛgu. ");
INSERT INTO akp_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ɣɛɛ Paulo iitɔrã ɖuɖuuɖu! Alasɔ ɔwi gɔ ɔsiai ma masɛ Pamfilia ne, Marko Yohanes ɔkpese ma i kama, ɔ̃iwe maro karabara. ");
INSERT INTO akp_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ma inyɔɔ ɔkpadzɛ̃ so i Marko Yohanes itɔ̃me iso gbɔgbɔɔgbɔ itã sɔ masame so iso. Barnaba ɔkɔ Marko maki i ndu iso makɛlɛ Kipro. ");
INSERT INTO akp_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paulo ɔ̃ wũ ɔkɔ Silas, ne gɔ mafɔɖedze ma mpia i mmɔ ɔsu ma mapia i Bosate nrɔɔ̃ ame ne, marui. ");
INSERT INTO akp_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ɔsɛ ɔ̃aki i Siria gu Kilikia ɔto ɔpia mafɔɖedze akuri ɔtɔ. ");
INSERT INTO akp_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo ɔrui ɔkɛlɛ simagɛ̃ dzɛ marɔ sɔ Derbe gu Listra. Mmɔ iɖe ɔsɛ ɔ̃anya fɔɖedze gɔ marɔ Timoteo ne. Ɔ̃ ɔnyi ne, ɔ Yudase ɔɖe fiɛ ɔfɔ Kristo ɔɖe. Ɔ̃ ɔse ɣɛɛ ne, ɔ Grikise ɔɖe. ");
INSERT INTO akp_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Mafɔɖedze ma ɔɖuɖu mpia i Listra gu Ikonion ne, masɛ mawarɛ Timoteo kukaakɔ. ");
INSERT INTO akp_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo ɔbie gbaã sɔ ɔ̃akɔ wũ ɔbua so iso. Ne ɔso ɔtu wũ sirɛrɛ̃ lɛ kumɛgɔ i ma Yudase mmara ɔte, alasɔ ma Yudase ma mpia i ndɛ̃ mɛmɔ ɔɖuɖu ɣe sɔ ɔ̃ ɔse ne, ɔ Grikise ɔɖe. ");
INSERT INTO akp_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Gɔ mata ne, maki i simagɛ̃ dzɛ ɔɖuɖu i mmɔ ame, maɣere ma ara wa i katɔ̃memasɛdze gu makpakpa ma i Yerusalem ɔsia ita sɔ mabara iso. ");
INSERT INTO akp_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ne ɔso mafɔɖedze ɔɣe masia iyi biara fiɛ mawe ɔle i kafɔkaɖe ame mabua. ");
INSERT INTO akp_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ne kama ne, mafe makɛlɛ Frigia gu Galatia, alasɔ Siwarã Bielea iitã ma ɔri sɔ maɣɛ Itɔ̃me Bielea i Asia karɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Gɔ masɛ maabo Misia ne, mabie sɔ si mabo Bitinia karɔ̃ iso. Ɣɛɛ ngbe ana ne, Yesu Siwarã iitã ma ɔri sɔ makɛlɛ mmɔ. ");
INSERT INTO akp_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ne ɔso maledza ikpese iki i Misia fiɛ masɛ maabo ɔmagɛ̃ gɔ marɔ Troa. ");
INSERT INTO akp_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Kasɛ̃ gamɔ ne, Paulo ɔnya kaɖikate. Ɔnya ɔrɛrɛ̃ gɔ lobɔrɛ i Makedonia gɔ ɔɣɛ ɔto ɔtã wũ iti sɔ, “Wara ba Makedonia ngbe si aba aabuai bo so o-o!” ");
INSERT INTO akp_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Kaɖikate gagbe ɔso ne, ɔluwɛ̃ ne boledza so borui bokɛlɛ Makedonia. Alasɔ bonya sɔ Bosate to ɔbie sɔ ɔpia bo sɔ bosɛ boaɣɛ Itɔ̃me Bielea i mmɔ. ");
INSERT INTO akp_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Gɔ bobo i ɔkolo ame i Troa ne, bofe bokɛlɛ Samotrake. Gɔ kaɖe ɔsɛ̃ ne, bosɛ boabo Neapoli. ");
INSERT INTO akp_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Bobɔrɛ i mmɔ bokɛlɛ Filipi gɔ nɖe Makedonia ɔmagɛ̃kpakpa fiɛ ɔɖe ma Romase kasɛkɔ̃ ana. Ne ɔso bowe i mmɔ ayi kɛkɛĩ. ");
INSERT INTO akp_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Iwarãyi iso ne, bobɔrɛ i ɔmagɛ̃ ame bokɛlɛ ɔwore kuruɛ i ngbegɔ bobu sɔ mmɔ i maturi sɛ masɛ maakparama kayi. Bosɛ i karɔ̃, ne botsɛ marɔ̃go ma loba mmɔ Bosate itɔ̃me iɣere ne. ");
INSERT INTO akp_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ɔrɔ̃go ɔwɛ̃ ɔwe i ma ndɛ̃ gɔ marɔ sɔ Lidia. Ɔsɛ ɔrɔdɛ̃ sikati rɛtɛa fiɛ ɔbɔrɛ i Tiatira. Ɔɖe ɔturi gɔ nsɛ ɔnigã Ɣaa gbaã. Gɔ ɔsi ɔto ɔkã nnɛ boto boɣɛ atsue ne, Bosate ɔbusi wũ adzuni sɔ ɔfɔ atɔ̃me wa ɔɖuɖu i Paulo ɔɣɛ ɔɖe. ");
INSERT INTO akp_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ne gɔ ɔ̃ gu ɔ̃ iyo maturi ɔɖuɖu ɔfɔ Ɣaa itupie kubarara ne, ɔtã bo iti sɔ, “Si minɔ karɔ̃ sɔ Bosate fɔɖedze loɖe gbaã ne, miba miawe i wũ kɔrɛ.” Ɔkpadzɛ̃gu bo itɔ̃me nɛgbe gbɔgbɔɔgbɔ bonɔ karɔ̃ sɔ boawe i ɔ̃ kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Iyi iwɛ̃ gɔ boto bokɛlɛ boakparama kayi ne, bosarɛgu ɔsande bitɛ ɔwɛ̃ gɔ ame i siwarã lalaa pia fiɛ ɔsɛ ɔpɛ sibɔ. Ɔsɛ ɔbara sikã kukaakɔ ɔtã makɔse. ");
INSERT INTO akp_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ɔbitɛ gɔgbe ɔsiai bo gu Paulo ɔto kulu sɔ, “Mmagbe ne, Ɣaa gɔ i kuɖokpo marabaradze maɖe fiɛ maba mate mi ɔri gɔ miaki miana ngbã!” ");
INSERT INTO akp_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nnɛgbe ɔkɛlɛ i katɔ̃ ayi gbodzoo. Gɔ iɔɖa Paulo ɔnɔ ne, ɔfiniki ɔɣere siwarã dzɛ mpia i ɔbitɛ gɔgbe ame sɔ, “Losa-ɔ loɖi i Yesu Kristo iyere ame sɔ bɔrɛ i ɔ̃ ame!” Ɔluwɛ̃ ne, siwarã lalaa ɔbɔrɛ i ɔ̃ ame! ");
INSERT INTO akp_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Gɔ ɔ̃ makɔse ɔnya sɔ ma karana ɔbieri ɔɔyu ne, mamɔɛ̃ Paulo gu Silas makpadzɛ̃ ma makɛlɛgu matɔ̃meɣɛdze kɔrɛ i itiri ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Maɖaɛ ma kanya i matɔ̃meɣɛdze kɔrɛ sɔ, “Mmagbe ne, ma Yudase maɖe fiɛ maba mapia manina bo ɔmagɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Mapia mate maturi ara wa lota aya ma Romase kubarara gu mmara iso.” ");
INSERT INTO akp_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Maturi gbodzoo ɔki malɔ Paulo gu Silas, ne matsɛ ma ikpakpadzɛ̃ ne. Matɔ̃meɣɛdze ɔkpadzɛ̃ awu maɖi ma iso fiɛ ka matã ɔri sɔ mapɛ ma kama. ");
INSERT INTO akp_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Gɔ mapɛ ma kukaakɔ ne, masu ma masɛ maapia i iyo. Maɣere ngɔ nto ɔdzuɛ̃ mayorɛdze sɔ ɔdzuɛ̃ Paulo gu Silas kukaakɔ. ");
INSERT INTO akp_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kumɛgɔ maɣere wũ ɔso ne, ɔsu ma ɔpia ta iyo kame pelepele fiɛ ɔpia ma i akpo ame. ");
INSERT INTO akp_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kasɛ ndɛ̃ gɔ Paulo gu Silas to makparama kayi fiɛ mato maka aka male Ɣaa ne, mma nrɛ i iyo mmɔ to makã ma atsue. ");
INSERT INTO akp_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ɔluwɛ̃ ne, karɔ̃ ɔti teteree, iyo ɔɖuɖu ɔti ta karɔ̃ ame sɔ ne akui ɔɖuɖu ɔsese fiɛ akpo wa ame mapia mma nrɛ i iyo ɔɖuɖu ɔfɛfɛ̃ aɖi ma. ");
INSERT INTO akp_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Gɔ iyo dzuɛ̃se ɔta i sirɛ fiɛ ɔnya sɔ iyo akui ɔɖuɖu ɔsese ase fiɛ ɔbu sɔ mayorɛdze ɔɖuɖu ɔɔtere mabɔrɛ ne, ɔsu ɔ̃ ipɛmi sɔ si ɔɖoe so. ");
INSERT INTO akp_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Gɔ Paulo ɔnya nnɛ ɔbie sɔ si ɔbara so ne, ɔfã ɔɣere wũ sɔ, “Daabara! Bo ɔɖuɖu pia i ngbe!” ");
INSERT INTO akp_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ne ɔrɛrɛ̃ gɔgbe ɔkpere sɔ masu ɔkaniɛ mabɔ wũ. I iti pɛ̃ gu ifɔ̃ lalaa nɛ lomɔɛ̃ wũ ame ne, ɔtere ɔkɛlɛ ɔsɛ ɔ̃apɛ agɛgɛ̃ i Paulo gu Silas katɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ne gɔ ɔkɔ ma ɔɖi i iyo ame ne, ɔkarɛ ma sɔ, “Tete mɛrɛ̃, be iɖe loabara fiɛ loana iɖi?” ");
INSERT INTO akp_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ne maɣere wũ sɔ, “Fɔ Bosate Yesu ɖe, si fɔ gu fɔ iyo maturi ɔɖuɖu aana iɖi.” ");
INSERT INTO akp_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Masɛ maaɣere ɔ̃ gu ɔ̃ iyo maturi ɔɖuɖu Itɔ̃me Bielea. ");
INSERT INTO akp_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kasɛ̃ gamɔ ame ame ne, ɔwiri ma aɣɛi wa maɖi ma, ne ka ɔtã ɔ̃ iyo maturi ɔɖuɖu ɔfɔ Ɣaa itupie kubarara ne. ");
INSERT INTO akp_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Gɔ ɔkɔ ma ɔpia iyo ame ne, ɔtã ma aɖera maɖe. Isoɣɔ ɔba i ɔ̃ gu ɔ̃ iyo maturi ɔɖuɖu ame gbaã, alasɔ mafɔ Ɣaa maɖe. ");
INSERT INTO akp_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Gɔ kaɖe ɔsɛ̃ ne, ɔmagɛ̃ matɔ̃meɣɛdze ɔpia makpakpɛ̃dze sɔ masɛ maaɣere ɔrɛrɛ̃ gɔ nto ɔdzuɛ̃ mayorɛdze sɔ, “Nyua mafɔ mamɔ si makɛlɛ!” ");
INSERT INTO akp_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ne dzuɛ̃se gɔgbe ɔɣere Paulo gu Silas sɔ, “Matɔ̃memaɣɛdze sɔ ka lonyua mi si mikɛlɛ. Ne ɔso ka miawo ɔkɛlɛ i isobuɛ ame.” ");
INSERT INTO akp_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ne Paulo ɔɣere makpakpɛ̃dze sɔ, “Mapɛ bo i maturi ndɛ̃ gɔ maiɣɛgu bo atɔ̃me, ana ne, masu bo mapia i iyo ame. Ɣɛɛ ne, ma Romase boɖe! Kiniɔ ka mabie sɔ borui i iwɛrɛ ame? Ooɣo! Ma mɔmɔ si maba maaɖi bo.” ");
INSERT INTO akp_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Makpakpɛ̃dze ɔkpese masɛ maaɣere matɔ̃meɣɛdze katɔ̃me gagbe. Gɔ manɔ sɔ Paulo gu Silas ne ma Romase maɖe ne, ifɔ̃ ɔmɔɛ̃ ma gbaã! ");
INSERT INTO akp_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ne ɔso mata makɛlɛ masɛ maapɛ ma nrɔɔ̃ fiɛ makɔ ma maɖi i iyo ame. Ne ka mapɛ ma nrɔɔ̃ sɔ mabɔrɛ i ɔmagɛ̃ ame ne. ");
INSERT INTO akp_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paulo gu Silas ɔrui makɛlɛ Lidia iyo. Gɔ manya mafɔɖedze tsɔra ne, mapia ma ɔtɔ mabua fiɛ mabɔrɛ i ɔmagɛ̃ ame. ");
INSERT INTO akp_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Gɔ maki i Amfipoli gu Apolonia ne, masɛ maabo Tesalonika ngbegɔ i ma Yudase kasarɛkɔ̃ kawɛ̃ pia. ");
INSERT INTO akp_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Lɛ kumɛgɔ i Paulo sɛ ɔɖɔɛ ɔbara ne, ɔkɛlɛ kasarɛkɔ̃. Awarãyi atɛ wa losiaidzo ne, ɔte Ɔko Sekelea ame atɔ̃me. ");
INSERT INTO akp_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ɔɖiɖi karɔ̃ ɔte inyɛwe nɛ maɣɛ masɛ koko sɔ Kristo aba ɔ̃anya gu kumɛgɔ ɔ̃aledza ita iwe ngbã. Paulo ɔɣere ma sɔ, “Yesu gɔ iso itɔ̃me nto loɣere mi ngbe nɖe Kristo ne.” ");
INSERT INTO akp_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Atɔ̃me wagbe ɔfinikira ma Yudase mawɛ̃, ne ɔso mafɔ maɖe masiai Paulo gu Silas. Ma Grikise gbodzoo mawɛ̃ ma nsɛ manigã Ɣaa gu marɔ̃go ma masɛ mawarɛ gbodzoo ana ɔsu so matã Ɣaa i ɔmagɛ̃ ame. ");
INSERT INTO akp_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ɣɛɛ anɔmi ɔrɛtɛ ma Yudase. Ne ɔso mabie kuturipɛmi masakanya i ɔmagɛ̃ ame sɔ si mapia kulu. Makɔ kulumapiadze magbe masɛ maaki malɔ Yason iyo sɔ mato mabie Paulo gu Silas si mamɔɛ̃ ma makɛlɛgu itiri. ");
INSERT INTO akp_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Gɔ maina ma mamɔɛ̃ ɔso ne, mamɔɛ̃ Yason gu mafɔɖedze mawɛ̃ makpadzɛ̃ ma makɛlɛgu kasarɛkɔ̃. Mato kulu sɔ, “Marɛrɛ̃ ma nto mapia kulu i kakɔi biara ɔɔba maabo i ngbe ana soo! ");
INSERT INTO akp_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yason nɖe ngɔ lofɔ ma ɔpia i ɔ̃ iyo. Mmagbe lota maɣɛ i Igarakpakpa Kaisaro mmara iso mato mate sɔ ɔrɛrɛ̃ ɔwɛ̃ gɔ marɔ Yesu ka nɖe igara ne!” ");
INSERT INTO akp_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Gɔ mma losakanya gu ɔmagɛ̃ makpakpa ɔnɔ ira nɛgbe ne, situ ɔtsue ma gbaã. ");
INSERT INTO akp_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ne ɔso matã sɔ Yason gu ɔ̃ maturi ɔtã sikã maɣedza so i kama fiɛ manyua ma. ");
INSERT INTO akp_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kasɛ̃ gamɔ ame ne, mafɔɖedze ma i Tesalonika ɔsu Paulo gu Silas materegu makɛlɛgu Beroia. Gɔ masɛ maabo mmɔ ne, makɛlɛ ma Yudase kasarɛkɔ̃ sɔ maaɣere ma Itɔ̃me Bielea. ");
INSERT INTO akp_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beroia maturi ɔte sɔ makpa anɔ maɖo Tesalonika maturi. Makã atsue kukaakɔ manɔ nnɛ mato maɣɛ. Iyi biara kɛkɛ ne, mato manyɔnyɔ Ɔko Sekelea ame manyɔ sɔ nnɛ i Paulo to ɔɣɛ ne, gbaã iɖe. ");
INSERT INTO akp_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ne ɔso ma Yudase gbodzoo ɔfɔ maɖe. Ma Grikise marɔ̃go gu marɛrɛ̃ gbodzoo ma masɛ mawarɛ ana ɔfiniki i ma situ ame. ");
INSERT INTO akp_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ɣɛɛ ɔwi gɔ i ma Yudase ma mpia i Tesalonika ɔnɔ sɔ Paulo pia ɔto ɔɣɛ Itɔ̃me Bielea i Beroia ne, makɛlɛ sɔ maapia ikpɔkpɔtɔ i ɔmagɛ̃ ame. ");
INSERT INTO akp_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Mafɔɖedze ma mpia i mmɔ ɔta ɔluwɛ̃ makɔ Paulo makɛlɛgu ɔpo katɔ̃. Ɣɛɛ Silas gu Timoteo ɔkpese mawe i Beroia. ");
INSERT INTO akp_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Mma lokɔ Paulo maruigu ɔsiai wũ masɛ maabo Atene. Gɔ makpese mato makɛlɛ ne, Paulo ɔsia ma kanya sɔ masɛ maaɣere Silas gu Timoteo sɔ mapɛ siwa si maba maatu wũ i mmɔ. ");
INSERT INTO akp_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ɔwi gɔ i Paulo pia i Atene ɔsia Silas gu Timoteo mɛrɛ̃ ne, so ɔma wũ gbaã gɔ ɔnya kumɛgɔ i ɔmagɛ̃ ɔyi ku aɣɔ. ");
INSERT INTO akp_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ne ɔso ɔsɛ ɔ̃aɖiɖi ara karɔ̃ ɔte ma Yudase gu mma nsɛ manigã Ɣaa i ma kasarɛkɔ̃. Iyi biara ne, ɔla ɔ̃ɔɖi ara karɔ̃ ɔ̃ɔte mma ɔsɛ ɔnya i itiri gu mma nto mafe i siri iso. ");
INSERT INTO akp_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ɔwi ɔwɛ̃ ame ne, mma mpia i Epikuro gu Stoa akuri ame ma nɖe kayiiso manɔgbadze ɔtsɛ kakpadzɛ̃ ku Paulo sɔ, “Be iso i ɔrɛrɛ̃ kutsuɛɣɛdze gɔgbe to ɔɖe ika?” Ne mawɛ̃ ana ɔɣɛ sɔ, “Ibara lɛ karɔ̃ mama aɣɔ iso itɔ̃me ɔto ɔɣɛ.” Mmamɔ ɔɣɛ ngbɔ, alasɔ manɔ gɔ Paulo to ɔɣɛ ara i Yesu gu makpise ita iso. ");
INSERT INTO akp_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ne ɔso makɔ wũ makɛlɛgu ngbegɔ masɛ marɔ sɔ Areopago fiɛ iɖe makpakpa kasarɛkɔ̃ maɣere wũ sɔ, “Bobie sɔ boatsue ara ɣɛtɛ wa ato ate ngbe. ");
INSERT INTO akp_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ara wa ato aɣɛ to abara bo ɣaa, ne ɔso bobie sɔ bonɔ wã karɔ̃.” ");
INSERT INTO akp_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atene maturi ɔɖuɖu gu mafɔ ma mpia i karɔ̃ gamɔ iso ɔɖuɖu ne, maba kɔrɔ̃ matã ara ɣɛtɛ iɣɛ gu wã inɔ ɔwi biara. ");
INSERT INTO akp_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Gɔ Paulo ɔta ɔya i kasarɛkɔ̃ i ma katɔ̃ ne, ɔɣere ma sɔ, “Lonya sɔ mi Atene maturi ne, mipia i kasumu ame gbaã. ");
INSERT INTO akp_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Alasɔ gɔ lopia loki i mi ɔmagɛ̃ ame fiɛ lokarã inɔ ne, lonya itĩ iwɛ̃ nɛ masɛ masɔrɛ fiɛ matsɛrɛ i ne iso sɔ, ‘Ɣaa gɔ boiɣe ɔkpɛ i ngbe ne.’ Ɣaa gɔ miiɣe fiɛ misɛ misɔrɛ ne, ɔ̃ iso itɔ̃me iɖe loto lobie sɔ loɣere mi kiniɔ ne. ");
INSERT INTO akp_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Ɣaa gɔ lobara kayiiso gu ira biara nɛ mpia i kã ame, ɔ̃ nɖe kato gu karɔ̃ Sate ne. Ɔ̃isɛ ɔsɛ i iyo nɛ matsue ala ɔturi nrɔɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Fiɛ ɔ̃isɛ ɔbie sɔ ɔturi loasu ɔ̃ nrɔɔ̃ ɔbara kuira ɔtã wũ lɛ ngɔ i ira ɔnya alasɔ ɔ̃ mɔmɔ lotã ɔbiara ngbã gu iwarã gu nwa ɔɖuɖu nsɛ anya ma. ");
INSERT INTO akp_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ɔ̃ lobara maturi ɔɖuɖu iki i ɔturi ɔwɛ̃ iso fiɛ ɔtã sɔ maɣa makã kayi ɔɖuɖu iso. Ɔ̃ lotã kaɖe biara kɛkɛ ngbegɔ masi. Ɔ̃ mɔmɔ losɛ ɔwi gu agbanayi ɔtã ɔbiara kɛkɛ. ");
INSERT INTO akp_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ɣaa ɔbara nwagbe ɔtã bo lɛ ɔ̃ maturi sɔ si boanyɔnyɔ wũ bonya wũ atoa sɔ tee ɔ̃idzorogu bo kuwɛ̃ fiɛ. ");
INSERT INTO akp_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Lɛ kumɛgɔ ɔwɛ̃ ɔɣɛ sɔ, ‘Ɔ̃ ɔso boba ngbã boto bopɛpɛgu so fiɛ boawe ana.’ Fiɛ mi agbã mapɛdze mawɛ̃ ana ɔɣɛ sɔ, ‘Ɔ̃ mabi gu mawa boɖe.’ ");
INSERT INTO akp_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Gɔ Ɣaa mabi boɖe ɔso ne, midaatã bobu sɔ Ɣaa kumiamia se lɛ ara wa bobaragu ala sikãrɛtɛa, ɣee ala sikãfudza, ɣee ita, ɣee ira nɛ mawe. ");
INSERT INTO akp_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ita i kayi karɔ̃kasɛkɔ̃ iba iabo ɔwi gɔgbe ame ne, Ɣaa iikpadzɛ̃ maturi atsue sɔ be ɔso maiɣe wũ. Ɣɛɛ kiniɔ ne, ɔto ɔkpere maturi ɔɖuɖu sɔ mafiniki. ");
INSERT INTO akp_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Alasɔ ɔ̃ɔsɛ iyi nɛ iso i ngɔ ɔɖi ɔsɛ aaba ɔ̃aɣɛgu bo atɔ̃me i ɔri iso. Fiɛ ɔɖi ngɔ ɔsia ikparĩ ɔsɛ ɔte bo sekelee gɔ ɔtara wũ ɔbɔrɛgu i makpise ame.” ");
INSERT INTO akp_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Gɔ manɔ Paulo ɔɖe ika i makpise ita iso ne, mawɛ̃ i ma ndɛ̃ ɔtsɛ wũ ima. Mawɛ̃ ana ɔɣɛ sɔ, “Boabie sɔ aaba aaɣere bo itɔ̃me nɛgbe ku iyi mama.” ");
INSERT INTO akp_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Gɔ iba ngbɔ ne, Paulo ɔrui ɔnyua ma. ");
INSERT INTO akp_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ɣɛɛ mawɛ̃ ɔsiai wũ, mafiniki makpese mafɔɖedze. Ma ndɛ̃ ɔwɛ̃ nɖe Areopago ɔturi gɔ marɔ Dionisio gu ɔrɔ̃go gɔ marɔ Damari gu mamama ana. ");
INSERT INTO akp_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ne kama ne, Paulo ɔrui i Atene ɔkɛlɛ Korinto. ");
INSERT INTO akp_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Mmɔ iɖe ɔsɛ ɔ̃anya ɔ Yudase gɔ marɔ Akwila fiɛ maɣe wũ i Ponto. Ɔ̃ gu ɔ̃ ɔre Priskila gɔ lobɔrɛ i Italia ɔba mmɔ iidzoro, alasɔ Roma Igarakpakpa gɔ marɔ Klaudio ɔɣɛ sɔ ma Yudase ɔɖuɖu si mabɔrɛ i Roma. Paulo ɔsɛ ɔ̃atu ma, ");
INSERT INTO akp_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ɔwe i ma kɔrɛ ɔbuai ma ku mabɔi siko ikã karabara alasɔ ɔ̃ wũ karabara gamɔ ɔsuã ne. ");
INSERT INTO akp_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Iwarãyi biara ne, Paulo sɛ ɔkɛlɛ ma Yudase kasarɛkɔ̃ ɔ̃afafarɛgu ma Yudase gu ma Grikise ɔɖuɖu Itɔ̃me Bielea sɔ si maafiniki. ");
INSERT INTO akp_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Gɔ Silas gu Timoteo ɔse i Makedonia maba ne, Paulo ɔna ɔwi kukaakɔ ɔtã Itɔ̃me Bielea iɣɛ gu ara ite ma Yudase sɔ Yesu nɖe Mesia gbaã. ");
INSERT INTO akp_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Gɔ ma Yudase ɔta maya Paulo iso fiɛ maɣɛ anyakpi i ɔ̃ iso ne, ɔkpakpa so ɔte ma ɔɣere ma sɔ, “Si mikpi miwɔ ne, wũ nrɔɔ̃ gu wũ ngba na i ne ame, loɔbara wũ karabara. Ita i kiniɔ ne, ka loakɛlɛ mma loiɖe ma Yudase kɔrɛ loaɣere ma Itɔ̃me Bielea.” ");
INSERT INTO akp_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Gɔ ɔrui i ma kɔrɛ ne, ɔsɛ ɔ̃ɔwe i ɔrɛrɛ̃ ɔwɛ̃ gɔ loiɖe ɔ Yudase fiɛ marɔ wũ Tito Yusto gɔ nsɛ ɔɖɔɛ Ɣaa fiɛ ɔsi ɔmatã ma Yudase kasarɛkɔ̃ kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kasarɛkɔ̃ ɔkpakpa gɔ marɔ Krispo gu ɔ̃ iyo maturi ɔɖuɖu ɔfɔ Bosate maɖe, ne mafɔ Ɣaa itupie ne. Itã sɔ maturi gbodzoo ɔfɔ maɖe ne mafɔ Ɣaa itupie i Korinto mmɔ ne. ");
INSERT INTO akp_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Kasɛ̃ kawɛ̃ ne, Bosate ɔɣere Paulo i kurɛ ame sɔ, “Daanigã! Daanyua itɔ̃me nɛgbe ɔɣɛ. ");
INSERT INTO akp_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Alasɔ lopiagu-ɔ fiɛ kuwɛ̃ iibawo-ɔ ikpi kuiwɛ̃ ɔbara. Maturi gbodzoo pia i ɔmagɛ̃ gɔgbe ame gɔ maɖe wũ mare.” ");
INSERT INTO akp_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ne ɔso Paulo ɔwe i mmɔ ikɔ ku awa akuɔ ɔte ma Ɣaa itɔ̃me. ");
INSERT INTO akp_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ɣɛɛ gɔ Galio ɔba ɔ̃akpese Roma abã ɔkpakpa i Akaya ibuiti iso ne, ma Yudase ɔbara kanya kawɛ̃ makpadzɛ̃ Paulo makɛlɛgu atɔ̃mekaɣɛkɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Maɖaɛ wũ kanya sɔ, “Ɔrɛrɛ̃ gɔgbe to ɔte maturi Ɣaa kasumu i ɔri gɔ loikotegu bo mmara iso.” ");
INSERT INTO akp_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Gɔ Paulo ɔbie sɔ si ɔɖi so kanya ne, Galio ɔɣere ma Yudase sɔ, “Si ira nyanyarĩa irere, ɣee mmara itu iɖe misu mibɔ ne, loana ɔtu lokã mi atsue. ");
INSERT INTO akp_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ɣɛɛ gɔ kakpadzɛ̃ siefe ga lose i mi atɔ̃me, ayere gu mmara iso iɖe ne, mi mɔmɔ misɛ miaɣɛ. Iiɖe me nɖe mi atɔ̃meɣɛdze i ara wamɔ iso.” ");
INSERT INTO akp_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ne ɔso ɔsa ma ɔɖi i atɔ̃mekaɣɛkɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ne iturikuri nɛgbe ɔsɛ maamɔɛ̃ Sostene gɔ nɖe ma Yudase kasarɛkɔ̃ tɔ̃ɖedze mapɛ wũ i atɔ̃mekaɣɛkɔ̃ kɔrɛ. Ɣɛɛ Galio iipia ma kanya. ");
INSERT INTO akp_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo ɔwe i Korinto ɔmagɛ̃ ame ayi gbodzoo. Ne kama ɔkala mafɔɖedze fiɛ ɔ̃ gu Akwila gu Priskila ɔki i ndu iso makɛlɛ Siria ne. Ɣɛɛ si ɔ̃arui ne, Paulo ɔtã sɔ mafiɛ ɔ̃ iti i Kenkrea ala ma Yudase kubarara kuwɛ̃ gɔ ɔbara ɔso. ");
INSERT INTO akp_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Gɔ ɔso i Efeso ne, ɔnyua Priskila gu Akwila ɔsɛ i mmɔ. Ɣɛɛ ɔ̃ ne, ɔkɛlɛ ma Yudase kasarɛkɔ̃ sɔ ɔ̃aki i ara awɛ̃ ame ku ma. ");
INSERT INTO akp_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Matã wũ iti sɔ ɔwe i ma kɔrɛ ɔbua, ɣɛɛ ɔnya sɔ ɔna ɔwi. ");
INSERT INTO akp_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ne ɔso gɔ ɔto ɔrui ne, ɔɣere ma sɔ, “Si Ɣaa ɔtɔrã ne, nto loaledza ikpese iba mi kɔrɛ.” Ne ɔkpese ɔbo i ɔkolo ame fiɛ ɔrui i Efeso ne. ");
INSERT INTO akp_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Gɔ ɔsɛ ɔ̃abo Kaisarea ne, ɔrui ɔkɛlɛ Yerusalem ɔsɛ ɔ̃aya mafɔɖedze. Ne ka ɔfe ɔkɛlɛ Antiokia ne. ");
INSERT INTO akp_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Gɔ ɔwe i mmɔ kɛkɛĩ ne, ɔledza ikɛlɛ isɛ iaki i Galatia gu Frigia karɔ̃ iso. Ɔwi gɔgbe ɔɖuɖu ne, ɔwe ɔkiki i mafɔɖedze ma nto masarɛ ɔpia ma ɔle. ");
INSERT INTO akp_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ɔ Yudase ɔwɛ̃ ɔba Efeso gɔ marɔ Apolo, fiɛ maɣe wũ i Aleksandria. Ɔɖe ɔturi gɔ nɣe ɔko kukaakɔ, fiɛ ɔɣe Ɔko Sekelea ame atɔ̃me ana. ");
INSERT INTO akp_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Kɔra sɔ maɔte wũ Bosate iso ara fiɛ ɔsɛ ɔɣɛ Yesu itɔ̃me ikote kukaakɔ ku ɔtɔ ne, Yohanes itupie iso ara kere ɔɣe. ");
INSERT INTO akp_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Gɔ ɔta ɔya ɔto ɔɣɛ itɔ̃me ku katetere i ma Yudase kasarɛkɔ̃ fiɛ Priskila gu Akwila ɔnɔ ne, makɔ wũ makɛlɛgu ma iyo masɛ maɖiɖi Bosate itɔ̃me ame mate wũ kukaakɔ mabua. ");
INSERT INTO akp_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Gɔ Apolo ɔsia ita sɔ ɔ̃akɛlɛ Akaia ne, mafɔɖedze ma mpia i Efeso ɔpia wũ ɔle matsɛrɛ ɔko matã wũ sɔ ɔkɛlɛgu mafɔɖedze ma i mmɔ sɔ si ɔba ɔ̃abo ne, mafɔ wũ kukaakɔ. Gɔ ɔsɛ ɔ̃abo ne, ɔbuai maturi gbodzoo ma lofɔ maɖe iki i Bosate abualɛra ame. ");
INSERT INTO akp_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ma Yudase iina kayakpa i atɔ̃me kanya alasɔ ɔsu Ɔko Sekelea ame atɔ̃me wa lote sekelee sɔ Yesu nɖe Kristo. ");
INSERT INTO akp_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ɔwi gɔ i Apolo pia i Korinto ne, Paulo ana ɔki i ngba ɔri ɔfe ɔkɛlɛ Efeso ɔsɛ ɔ̃anya mafɔɖedze mawɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ɔkarɛ ma sɔ, “Ita i ɔwi gɔ mifɔ miɖe ne, miɔfɔ Siwarã Bielea?” Ne matã wũ mmuai sɔ, “Ooɣo! Be nɖe Siwarã Bielea? Boinɔ ne iso kuira.” ");
INSERT INTO akp_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ne ɔledza ma ikarɛ sɔ, “Ne iyɔ be Ɣaa itupie mifɔ?” Ne maɣere wũ sɔ, “Yohanes itupie itɔ̃me nɛ ɔɣɛ iɖe bofɔ.” ");
INSERT INTO akp_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ne Paulo ka ɔɖiɖi karɔ̃ ɔte ma sɔ, “Yohanes ɔpie maturi ndu sɔ mafiniki mabɔrɛ i ma akpi ame. Ɔɣere ma sɔ ngɔ nsiai wũ ɔto ɔba si mafɔ maɖe. Ngɔmɔ nɖe Yesu ne.” ");
INSERT INTO akp_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Gɔ manɔ ngbɔ ne, matã ɔbara ma Ɣaa itupie kubarara i Bosate Yesu iyere ame. ");
INSERT INTO akp_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ne gɔ Paulo ɔsu nrɔɔ̃ ɔsia ma iso ne, Siwarã Bielea ɔba siayi ma ame ɔɖuɖu, fiɛ matsɛ siɖe agbãagbã iɣɛ, maɣɛ Bosate itɔ̃me ana. ");
INSERT INTO akp_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Maaɖe lɛ marɛrɛ̃ iweo-inyɔ ɔɖui. ");
INSERT INTO akp_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulo ɔla ɔ̃ɔsɛ ma Yudase kasarɛkɔ̃ ɔla ɔ̃ɔɣɛ itɔ̃me ku ɔle awa atɛ, ɔɖiɖi ara karɔ̃ ɔte ma si ma adzuni si afiniki i Ɣaa sigarakaɖekɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ɣɛɛ mawɛ̃ ma loikã Itɔ̃me Bielea atsue ɔta maya Bosate itɔ̃me gu ara tea iso i kaɖe ɔɖuɖu anɔ. Ne ɔso Paulo ɔrui i ma kɔrɛ. Ɔruigu mma lofɔ maɖe makɛlɛ Tirano kasarɛkɔ̃. Mmɔ iɖe ɔla ɔ̃ɔte ma ara iyi biara ne. ");
INSERT INTO akp_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ɔte ma ara akɔ anyɔ. Itɔ̃me Bielea ɔki ikã Asia abuiti ɔɖuɖu ame, ne ɔso ma Yudase ɔɖuɖu gu mma loiɖe ma Yudase ana ɔnɔ. ");
INSERT INTO akp_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Bosate ɔtã Paulo ɔle siare gɔ ɔsu ɔbara awawãra. ");
INSERT INTO akp_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ne ɔso si masu ɔ̃ kuɖukui gu awu masɛ maapɛgu manyɛse ne, masɛ masarɛ, isɛ iwo siwarã lalaa ana ɔsa ɔɖi i mma ame sipia. ");
INSERT INTO akp_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ma Yudase mawase ma mpia maki ɔbu sɔ maawo Bosate Yesu iyere ɔsu ɔsa siwarã lalaa. Masɛ maɣɛ sɔ, “Losa mi i Yesu gɔ itɔ̃me i Paulo to ɔɣɛ sɔ mibɔrɛ i ngɔgbe ame!” ");
INSERT INTO akp_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ma Yudase sɔrɛdzekpakpa gɔ marɔ Skeva mabirɛrɛĩ ikɔdzɛ nto mabara nnɛgbe. ");
INSERT INTO akp_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ɣɛɛ gɔ masɛ maaɣere siwarã lalaa siwɛ̃ ngbɔ ne, sikarɛ ma sɔ, “Loɣe Yesu, fiɛ loɣe Paulo ana. Ɣɛɛ mi ne, mi nɖe mabe?” ");
INSERT INTO akp_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ngɔ iso i siwarã lalaa si ɔta ɔbo ma iso ɔpɛ ma! Mafɔ agbɛ fiɛ matere mabɔrɛ iyo isɔ̃isɔ̃ ala ɔkɛkɛ ma awu! ");
INSERT INTO akp_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ira nɛgbe ɔki ikã Efeso sɔ ma Yudase gu mma loiɖe ma Yudase i ɔmagɛ̃ gɔmɔ ame ɔɖuɖu ɔnɔ. Itã sɔ ifɔ̃ ɔmɔɛ̃ ma gbaã fiɛ masu kuwarɛ matã Bosate Yesu iyere mabua. ");
INSERT INTO akp_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Mma lofiniki fiɛ mafɔ maɖe ɔba maabusi ma akpi maɣɛ i maturi ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ne mma mpia i ma ndɛ̃ maɖe mawase ɔsu ma sisɔbɛ gu siko dzɛ ame matsɛrɛ ma awara mapia mabɔ maatsuedza i maturi ndɛ̃ ne. Siko dzɛ matsuedza mmɔ kuɣa aaɖe lɛ sikãfudza kukpi siru ɔɖui. ");
INSERT INTO akp_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ne ɔso Bosate itɔ̃me ɔki ikã gu ɔle ifɔ ndɛ̃ mmɔ ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Nnɛgbe kama ne, Siwarã Bielea ɔtã Paulo ɔsia ita i ɔ̃ ɔtu ame sɔ ɔsɛ ɔ̃aki i Makedonia gu Akaia fiɛ ɔ̃akɛlɛ Yerusalem. Ne ɔɣɛ sɔ, “Si lobo mmɔ ne, loto loafe lokɛlɛ Roma ana.” ");
INSERT INTO akp_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ɔpia ɔ̃ mabuaidze inyɔ, Timoteo gu Erasto, sɔ maɖe wũ katɔ̃ makɛlɛ Makedonia. Ne ka ɔkpese ɔwe i Asia kɛkɛĩ ɔbua ne. ");
INSERT INTO akp_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ɔwi gɔmɔ ame ne, kulu siare kuwɛ̃ ɔba i mafɔɖedze ma mpia i Efeso iso iki i ma kafɔkaɖe iso. ");
INSERT INTO akp_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ngɔ losɛ kulu gɔgbe karɔ̃ nɖe Demetrio gɔ nsɛ ɔsu sikãfudza ɔpɔ ala Artemi kuɣɔ iyo wiriwiria. Ara wagbe irɔdɛ̃ sɛ ibɔ ma gu ɔ̃ mabuaidze kusia gbodzoo. ");
INSERT INTO akp_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Iyi iwɛ̃ ne, Demetrio ɔkpere ma gu mma nsɛ mabara karabara ɔsirakanya ɔɣere ma sɔ, “Wũ manyii, miɣe sɔ bosɛ bona kusia gbaã i bo karabara gagbe ame. ");
INSERT INTO akp_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Mito minɔ, fiɛ mito minya kukaakɔ kumɛgɔ i Paulo to ɔbɔ bo karabara karɔ̃, alasɔ ɔ̃ɔfinikira maturi gbodzoo adzuni sɔ aɣɔra wa boto bobara ɔɖuɖu iikote sɔ maabɔ ati karɔ̃ matã! Ne ɔso i bo karabara ɔɔba karɔ̃ ne! Fiɛ iiɖe Efeso ngbe kere ito iba ngbɔ. Ɣɛɛ ne, Asia karɔ̃ iso ɔɖuɖu! ");
INSERT INTO akp_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ɣɛɛ ne, iiɖe bo karabara ɔnɔwɛ̃ kere loanina! Gbagbaã ne, bo kuɣɔ Rɔ̃gokpakpa Artemi iyo siare gu ɔ̃ kuwarɛ ɔɖuɖu ana to kuayu i Asia gu kayiiso ɔɖuɖu!” ");
INSERT INTO akp_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Gɔ manɔ Demetrio ikaɖe ne, sikpã lalaa ɔmɔɛ̃ ma matsɛ kulu teteree mato maɣɛ sɔ, “Efeso kuɣɔ Rɔ̃gokpakpa Artemi nɖe ɔkpakpa pelepele!” ");
INSERT INTO akp_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kulu siare gɔgbe ɔki kukã ɔmagɛ̃ ɔɖuɖu ame. Ne ɔso masakanya lɛ ikuri fiɛ masɛ maamɔɛ̃ Paulo masiaidze inyɔ ma marɔ Gaio gu Aristarko ma lobɔrɛ i Makedonia makɛlɛgu ɔmagɛ̃ kasarɛkɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo ana ɔbie sɔ si ɔkɛlɛ mmɔ, ɣɛɛ mafɔɖedze ma mpia i mmɔ iitã wũ ɔri. ");
INSERT INTO akp_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ta makpakpa ma nto manyɔ ibuiti nɛmɔ iso fiɛ maɖe Paulo malaa ɔpia wũ ɔturi sɔ matã wũ iti ne, ɔdaasɛ mmɔ ɖuɖuuɖu! ");
INSERT INTO akp_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Iyo ame ɔɖuɖu ɔyigu kulu fiɛ mma loba maasakanya ɔbiara to ɔɣɛ ɔ̃ ire. Ma kasɛ siare kɔra iiɣe nnɛ ɔso fiɛ maba mmɔ. ");
INSERT INTO akp_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ma Yudase ɔli Aleksandro masɛ maaɣedza i katɔ̃ sɔ ɔɣɛ nnɛ loba. Ne ɔkɔlɛ nrɔɔ̃ ɔɣere ma sɔ malo kulu si ɔɣere ma ira iwɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Gɔ matsue sɔ ɔ Yudase ɔɖe ne, mala kulu teteree lɛ iɖɔwũ inyɔ buu mato maɣɛ sɔ, “Efeso kuɣɔ Rɔ̃gokpakpa Artemi nɖe ɔkpakpa pelepele!” ");
INSERT INTO akp_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ɔwi kurukutu ame ne, abã ɔkpakpa ɔwɛ̃ ɔba ɔ̃ɔwo ma ɔlora sɔ, “Mi Efeso maturi, mi ɔbiara ɣe sɔ Efeso ngbe i kuɣɔkpakpa Artemi iyo pia fiɛ ɔ̃ ita nɛ lokpase ibɔrɛ i kuɖokpo bosɛ bosɔrɛ ana ne, bo ndɛ̃ ise. ");
INSERT INTO akp_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kuwɛ̃ na gɔ ɔ̃awo nnɛgbe ɔsɛ̃. Ne ɔso mina ɔtu si sikpã si siɣɔ mi. ");
INSERT INTO akp_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Alasɔ mma mimɔɛ̃ mibɔ ngbe ne, maiyu kayu i kuɣɔ iyo fiɛ mainina kuira i Artemi iyere ana iso. ");
INSERT INTO akp_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Si Demetrio gu ɔ̃ matorese laa ɔnya sɔ maba itɔ̃me irere gu ɔrere ne, boba matɔ̃meɣɛdze. Fiɛ boba ayi wa iso masɛ maɣɛ atɔ̃me ana. Maawo ma akpi ɔɖi ɔte mmagbe iyɔ maɔtã maɣɛgu ma atɔ̃me i ɔri iso. ");
INSERT INTO akp_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ɣɛɛ si ira mama pia mito mibie sɔ miaɖi mibɔ ne, misu misɛ i matɔ̃meɣɛdze katɔ̃ si maaɣɛ ne i mmara kanya. ");
INSERT INTO akp_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Boto boamɔrɛ̃ si maɣɛgu bo atɔ̃me i nɔme kulu gɔgbe iso alasɔ bona nnɛ boasu boɖi so kanya.” ");
INSERT INTO akp_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Gɔ ɔɣere ma nnɛgbe ne, ɔtã masame. ");
INSERT INTO akp_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Gɔ kulu gɔmɔ ɔba kualo ne, Paulo ɔkpere mafɔɖedze ɔsirakanya ɔpia ma ɔle i kafɔkaɖe ame, ɔmala ma so fiɛ ɔrui ɔkɛlɛ Makedonia. ");
INSERT INTO akp_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Gɔ ɔɣo ɔri ne, Paulo ɔki i abuiti ɔɖuɖu ame ɔtã ma kuka gbodzoo ɔsu ɔpia ma katetere gbɔgbɔɔgbɔ ɔsɛ ɔ̃ɔbo Akaia. ");
INSERT INTO akp_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ɔwe i mmɔ awa atɛ. Gɔ ɔto ɔledza so sɔ ɔ̃arui ɔkɛlɛ Siria ne, ɔnya sɔ ma Yudase mawɛ̃ ma mpia i mmɔ to mabie sɔ maaɖoe wũ. Ne ɔso ɔbara adzuni sɔ ɔ̃akpese ɔki i Makedonia. ");
INSERT INTO akp_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Gɔ ɔto ɔkɛlɛ ne, mma losiai wũ mawɛ̃ nɖe Sopater gɔ lobɔrɛ i Beroia fiɛ ɔɖe Piro ɔbi gu Aristarko gu Sekundo gɔ lobɔrɛ i Tesalonika gu Gayo gɔ lobɔrɛ i Derbe gu Tihiko gu Trofimo ma lobɔrɛ i Asia abuiti gu Timoteo. ");
INSERT INTO akp_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Mmagbe ɔɖe bo katɔ̃ sɔ masɛ maawe masia bo i ɔmagɛ̃ gɔ marɔ Troa. ");
INSERT INTO akp_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Gɔ Boɖoboɖo Gɔ Loita Iɖe Iyi ɔfe ne, bosu ɔkolo i Filipi. Ayi aru kama ne, bosɛ boatu ma i Troa fiɛ ka bowe i mmɔ ayi akɔdzɛ. ");
INSERT INTO akp_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ɖapɛ iyi ɖeakatɔ̃ iso ne, bosakanya sɔ boasɛ ɔpɔrɔ̃ katɔ̃. Ne kumɛgɔ i Paulo to ɔ̃arui ku kaɖesɛ̃a ɔso ne, ɔɖe ma ika isɛ iabo kasɛ̃ ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Matsue sikaniɛ gbodzoo masɛ i iyo nɛ ame mapia i kato. ");
INSERT INTO akp_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ɔporoporoi ɔwɛ̃ gɔ marɔ Eutiko fiɛ ɔsi i fesere iso ɔtsɛ sirɛ itua gɔ Paulo to ɔɖe ika. Gɔ ikaɖe to ikarã ne, sirɛ ɔsu wũ. Ɔkpase ɔbɔrɛ i iyo nɛ matsue masia ikpɛ itɛ iso ɔba ɔ̃awuĩ i karɔ̃. Gɔ masɛ maaputa wũ ne, manya sɔ ɔkpi. ");
INSERT INTO akp_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ɣɛɛ gɔ Paulo ɔso ɔkɛlɛ fiɛ ɔmɔɛ̃ wũ ɔpia so ne, ɔɣere ma sɔ, “Midaapɛ sikpabo ne ɔpia ngbã!” ");
INSERT INTO akp_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Gɔ Paulo ɔledza iya iba kato mmɔ ne, bosɛ ɔpɔrɔ̃ katɔ̃. Ne ka ɔledza ika iɖe gbɔgbɔɔgbɔ kaɖe ɔsɛ̃ fiɛ ɔrui ne. ");
INSERT INTO akp_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Maturi ɔsu ɔporoporoi gɔ mpia ngbã makɛlɛgu iyo fiɛ ɔtu ɔɣɔ ma gbaã. ");
INSERT INTO akp_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Paulo ɔki i ngba ɔri ɔkɛlɛ Aso, ɣɛɛ bo mma nsɛgu wũ sɔ boasɛ wũ ɔri ɔsu ɔkolo boɖe wũ katɔ̃ sɔ boasarɛ i mmɔ fiɛ ka boasu wũ lɛ kumɛgɔ ɔɣɛ. ");
INSERT INTO akp_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Gɔ ɔba ɔ̃ɔtu bo i Aso ne, ɔbo i ɔkolo ame fiɛ ka bokɛlɛ Mitilene. ");
INSERT INTO akp_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Kaɖesɛ̃a ne, bokɛlɛ Kio. Ne kaɖesɛ̃a bokɛlɛ Samo. Iyi tɛare ne, borui bokɛlɛ Mileto. ");
INSERT INTO akp_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo ɔtã sɔ boiki i Efeso, alasɔ ɔ̃ito ɔbie sɔ ɔ̃ɔnina ɔwi gbodzoo i Asia. Ɔsia ita sɔ si ɔ̃awo ne, ɔ̃abo Yerusalem ku Pentekoste iyi iso. ");
INSERT INTO akp_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Gɔ bosɛ boabo Mileto ne, Paulo ɔpia Efeso mafɔɖedze makpakpa ɔturi sɔ maba maanya wũ i mmɔ. ");
INSERT INTO akp_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Gɔ maba ne, ɔɣere ma sɔ, “Mi ɔɖuɖu ɣe kumɛgɔ losɛgu mi ita i iyi nɛ loba Asia karɔ̃ iso iba iabo nɔme gɔgbe. ");
INSERT INTO akp_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Minya sɔ losiai Bosate i karɔ̃ ibɔso ame atoa sɔ lona inyɛwe gu nnɔmɛ iki kumɛgɔ i ma Yudase ɔbie sɔ maaɖoe me ɔso. ");
INSERT INTO akp_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Gbaã ne, loisɛ̃ sɔ loaɣere mi ara wa loɣe i Bosate iso i mi ayo gu ɔgbami. Lobara ngbɔ alasɔ lobie sɔ mitsue ara wa loaɖe mi kusia. ");
INSERT INTO akp_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Kakɔi biara ga losɛ ne, loɣere ma Yudase gu mma loiɖe ma Yudase sɔ manyua ara nyanyarĩa ɔbara si mafiniki masiai Ɣaa si mafɔ Bosate Yesu maɖe. ");
INSERT INTO akp_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Kiniɔ ne, Siwarã ɣɛ me iso sɔ lokɛlɛ Yerusalem atoa sɔ loiɣe nnɛ loabɔrɛ me iso i mmɔ. ");
INSERT INTO akp_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Simagɛ̃ dzɛ ɔɖuɖu ame loɔkiki ne, Siwarã Bielea to sitã me lotsue sɔ iyo irɛ gu inyɛwe se isia me i Yerusalem. ");
INSERT INTO akp_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Wũ ngbã iisu me kuira, nnɛ lonya me iɖo nɖe sɔ loabara karabara ga i Bosate Yesu ɔpia me sɔ lobara. Fiɛ nnɛ ɔpia me sɔ lobara nɖe sɔ loɣere maturi Itɔ̃me Bielea sɔ Ɣaa sɛ ɔnyɔ bo nnya. ");
INSERT INTO akp_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Loɔwe lokiki loɣere mi Itɔ̃me i Ɣaa sigarakaɖekɔ̃ iso, ɣɛɛ kiniɔ ne, loɣe sɔ mi kuwɛ̃ iisibanya me minya. ");
INSERT INTO akp_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nto loɣere mi nɔme sɔ, loisibatã mi kuwɛ̃ ngbã akɔnta. ");
INSERT INTO akp_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Loɔɣere mi ira biara nɛ i Ɣaa to ɔbie sɔ mitsue. ");
INSERT INTO akp_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ne ɔso minyɔ so kukaakɔ gu mma ɔɖuɖu i Siwarã Bielea ɔsu sipia i mi nrɔɔ̃ ame sɔ mikɔkɔ. Miɖe matɔ̃ɖedze sɔ miakɔkɔ mma i Ɣaa ɔsu ɔtã mi sɔ mikararã. Midzuɛ̃ ma kukaakɔ alasɔ Ɣaa ɔsu ɔ̃ Ɔbi ima ɔfere i karɔ̃ sɔ si ɔɖi ma. ");
INSERT INTO akp_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Loɣe kukaakɔ sɔ si lorui ne, maturi to maata maya mi iso masamarã mi lɛ kumɛgɔ i ɔgidi sɛ ɔkpɛ̃gu masɛrɛ fiɛ ɔ̃isɛ ɔnyɔ ma nnya. ");
INSERT INTO akp_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Mi ndɛ̃ mawɛ̃ ana to maasu itɔ̃me sɛɛ mapɛyu makɔ maturi gbodzoo maayura iki ma mila ara ite ame. ");
INSERT INTO akp_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Midzuɛ̃ so si minyigi kumɛgɔ lobiɛ i mi iti gu kumɛgɔ lote mi ara kasɛ̃ i kakɔme akɔ atɛ wa lowe i mi kɔrɛ ame. ");
INSERT INTO akp_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Kiniɔ ne, losu mi nto lopia i Ɣaa nrɔɔ̃ ame sɔ ɔdzuɛ̃ mi i ɔ̃ itɔ̃me nɛ nsɛ ibuai maturi si ipia mi kafɔkaɖe ɔle, itã sɔ miaɖe mma loaɖe sigarakaɖekɔ̃ ara gu mma ɔɖi ɔsɛ so. ");
INSERT INTO akp_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Anɔ iirɛtɛ me i kuwɛ̃ sikã ɣee sikati ara iso. ");
INSERT INTO akp_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mi mɔmɔ ɣe sɔ wũ nrɔɔ̃ mɛgbe lobara ala karabara fiɛ loɖe ara lokuti losu lonyɔ mma nsiai me iso. ");
INSERT INTO akp_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Lobara ara wagbe ɔɖuɖu lote mi kumɛgɔ ikote sɔ boabuai mawɛrɛba fiɛ si lonyigira mi Bosate Yesu itɔ̃me nɛ ɔɣɛ sɔ, ‘Kusɛkusɛ pia i ara itã ame iɖo ifɔ.’ ” ");
INSERT INTO akp_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Gɔ Paulo ɔro ikaɖe ne, ɔpɛ agɛgɛ̃ ku ma ɔɖuɖu ɔkparamagu ma kayi. ");
INSERT INTO akp_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ma ɔɖuɖu ɔpɔrɛ wũ matsɛ kaku ala kumɛgɔ ɔto ɔmala ma so ɔso. ");
INSERT INTO akp_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Nnɛ lotã so ɔkɔ̃ ma kɔra nɖe kumɛgɔ ɔɣere ma sɔ maisibanya wũ manya. Makɔ wũ masɛ maabo ɔkolo katɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Gɔ boro so ɔmala ne, bobo i ɔkolo ame bowara bokɛlɛ Kos. Kaɖesɛ̃a ne, bosɛ boabo Roda fiɛ ka bobɔrɛ i mmɔ bokɛlɛ Patara. ");
INSERT INTO akp_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Mmɔ iɖe bosu ɔkolo ɔwɛ̃ gɔ nto ɔkɛlɛ Foinike ne. ");
INSERT INTO akp_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Gɔ bonya Kipro karɔ̃ bosese ne, boki i kã kala isɛ bofe bokɛlɛ Tiro i Siria ngbegɔ masɛ maaɖi ato wa mpia i ɔkolo ame. ");
INSERT INTO akp_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Gɔ bonya mafɔɖedze ma mpia i mmɔ ne, bowegu ma akpɛnɛ akɔdzɛ. Siwarã Bielea ɔki i mafɔɖedze magbe iso maka Paulo sɔ ɔdaakɛlɛ Yerusalem. ");
INSERT INTO akp_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Gɔ bo ayi wa boawegu ma ɔɔsɔ̃ fiɛ ka boarui ne, mafɔɖedze gu ma mare gu mabi ɔkɔ bo makɛlɛgu ɔpo katɔ̃, ne bo ɔɖuɖu ɔpɛ agɛgɛ̃ bokparama kayi ne. ");
INSERT INTO akp_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Gɔ bo mala ma so boro ne, bobo i ɔkolo ame, ne ma wũ ka makpese makɛlɛ ma ayo ne. ");
INSERT INTO akp_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Gɔ borui i Tiro ne, boba boatui i Ptolemai. Bosɛ boaya mafɔɖedze ma mpia i mmɔ fiɛ bowegu ma ikpɛnɛ iwɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kaɖesɛ̃a ne, bota bokɛlɛ Kaisarea, bosɛ boabo Itɔ̃me Bielea ɣɛdze Filipo iyo. Ɔ̃ wũ ɔpia i mabuaidze ikɔdzɛ ma maɖi i Yerusalem ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ɔba mabirɔ̃gomi ina ma loiyiri marã fiɛ maɖe Ɣaa kanyamaɖidze. ");
INSERT INTO akp_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Bowe i mmɔ ayi kɛkɛĩ fiɛ Ɣaa kanyaɖidze ɔwɛ̃ gɔ marɔ Agabo ɔbɔrɛ i Yudea ɔba. ");
INSERT INTO akp_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Gɔ ɔba bo kɔrɛ ne, ɔɖi kafiami ga mpia i Paulo ɔsɔ ame ɔnyi so nrɔɔ̃ gu ngba ɔɣɛ sɔ, “Siwarã Bielea sɔ ngbɔ i ma Yudase ma i Yerusalem aanyi ngɔ kafiami kaɖe i ngbe fiɛ maasu wũ mapia i mma loiɖe ma Yudase nrɔɔ̃ ame ne.” ");
INSERT INTO akp_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Gɔ bonɔ atɔ̃me wagbe ne, bo gu mafɔɖedze ma mpia i mmɔ ɔɖuɖu ɔtã Paulo iti sɔ ɔdaakɛlɛ Yerusalem. ");
INSERT INTO akp_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ne ɔɣere bo sɔ, “Be ɔso fiɛ mito mibiɛ mifɛfɛ̃ me nrɔɔ̃ ngbɔ? Loito lonyɔ ɔri sɔ iyo kere maapia me i Bosate Yesu iti, ɣɛɛ lotɔrã sɔ maɖoe me i Yerusalem ala ɔ̃ ɔso.” ");
INSERT INTO akp_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Gɔ bonya sɔ boibawo ɔ̃ adzuni ɔfinikira ne, bonyua wũ boɣɛ sɔ, “Ɣaa si ɔbara ɔ̃ kuɖɔɛ.” ");
INSERT INTO akp_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ayi kurukutu kama ne, bosa bo ara kanya boɣo Yerusalem ɔri. ");
INSERT INTO akp_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Kaisarea mafɔɖedze mawɛ̃ ana ɔsiai bo. Makɔ bo makɛlɛgu ɔ Kiprose fɔɖedzekpakpa kuere gɔ marɔ Mnason sɔ si bosɛ boasora i ɔ̃ kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Gɔ bobo Yerusalem ne, mafɔɖedze ma mpia i mmɔ ɔfɔ bo kukaakɔ. ");
INSERT INTO akp_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kaɖesɛ̃a ne, Paulo ɔkɔ bo bosɛ boanya Yakobo gu Yerusalem mafɔɖedze makpakpa ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Gɔ boya so boro ne, Paulo ɔɣere ma ara wa ɔɖuɖu i Ɣaa ɔbara ɔkigu i ɔ̃ iso i mma loiɖe ma Yudase ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Mma ɔɖuɖu lonɔ atɔ̃me wagbe ɔle Ɣaa, maɣere Paulo sɔ, “Bo ɔnyii ɖɔɛse, aɣe ma Yudase kukpi gbodzoo ma lofɔ maɖe fiɛ makpese mamɔɛ̃ Mose mmara mato teteree. ");
INSERT INTO akp_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Manyiiɔ ɔɣere ma sɔ ato ate ma Yudase ma mpia i abuiti sɔ madaasiai Mose mmara gu bo mawa kubarara, fiɛ aɣɛ ana sɔ madaatu ma mabi sirɛrɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Be boabara kiniɔ? Alasɔ mato maanɔ kokooko sɔ aba.” ");
INSERT INTO akp_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ne matã wũ adzuni sɔ, “Boba marɛrɛ̃ ina mawɛ̃ i bo ɔmagɛ̃ ame i ngbe gɔ makã ndamu. ");
INSERT INTO akp_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Kɔ ma si mikɛlɛ ma Yudase isɔrɛyo si misɛ miasekelera so, si abuai ma ku ati ikparɛ̃ kuso. Ne loatã maturi ɔɖuɖu aatsue sɔ sila siɖe mala maisia-ɔ iso ku ɔwi gɔ ame amɔɛ̃ Mose mmara ato kukaakɔ ne. ");
INSERT INTO akp_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ɔwi gɔ lofe ne, botsɛrɛ ɔko botã mma loiɖe ma Yudase fiɛ mafiniki makpese mafɔɖedze sɔ manyua ara wa masu masɔrɛ aɣɔ ɔɖe, manyua ima ɔɖe, si madaaɖe mabɔi ma manyɛdɛ̃ simɔ maɖoe, ana ne, manyua marɛrɛ̃ gu marɔ̃go kasɛ ga loikote.” ");
INSERT INTO akp_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Gɔ kaɖe ɔsɛ̃ ne, Paulo ɔkɔ marɛrɛ̃ mamɔ makɛlɛ masɛ maabara so ati ikparɛ̃ kubarara. Ne kama ɔkɛlɛ ma Yudase isɔrɛyo sɔ maatã masɔrɛdze itsue ayi wa iso i ma ati ikparɛ̃ aaba fiɛ maasu ma karatã mabɔ maasu makpakpa so. ");
INSERT INTO akp_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Gɔ iɔkuti kɛkɛĩ fiɛ maaro ayi akɔdzɛ wamɔ ne, ma Yudase mawɛ̃ ma lobɔrɛ i Asia abuiti ɔba maanya Paulo i Isɔrɛyo. Masa maturi gbodzoo kanya, ne mamɔɛ̃ wũ ne. ");
INSERT INTO akp_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Matsɛ kulu i mmɔ sɔ, “Israel marɛrɛ̃, mibuai bo soo! Ɔrɛrɛ̃ gɔgbe pia ɔki ɔɣere maturi ɔɖuɖu i kakɔi biara ara nyanyarĩa i bo kaɖe gu Mose mmara gu bo Isɔrɛyo iso. Ana ne, ɔkɔ ma Grikise ɔba ɔ̃ɔbogu i kakɔi sekelea gagbe!” ");
INSERT INTO akp_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Maɣɛ ngbɔ alasɔ ɔwi ɔwɛ̃ ame ne, manya sɔ Paulo gu Trofimo gɔ nɖe ɔ Efesose sɛ i Yerusalem. Ne ɔso mabu sɔ ɔkɔ wũ ɔbogu i Isɔrɛyo ame. ");
INSERT INTO akp_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Kulu gɔgbe ɔtara ɔmagɛ̃ kuɣedza, ne ɔso maturi ɔɖuɖu ɔtere masɛ maasakanya i Isɔrɛyo. Makpadzɛ̃ Paulo maɖi i Isɔrɛyo masɛ̃ akui ɔɖuɖu ɔluwɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ɔwi gɔ mabie sɔ si maɖoe wũ ne, ma Romase makpakpɛ̃dze tɔ̃ɖedze ɔnɔ sɔ ma Yerusalemse ɔɖuɖu to mabara kulu. ");
INSERT INTO akp_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ɔluwɛ̃ ne, ɔkɔ makpakpɛ̃dze gu makpakpɛ̃dzekpakpa mawɛ̃ makɛlɛ ngbegɔ mato mabara kulu. Gɔ kulu mabaradze ɔnya makpakpɛ̃dze gu ma tɔ̃ɖedze ne, manyua Paulo ɔpɛ. ");
INSERT INTO akp_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Makpakpɛ̃dze tɔ̃ɖedze ɔmɔɛ̃ Paulo ɔtã mapia wũ kugbagɔrɔĩ kunyɔ. Ne ka ɔkarɛ sɔ si ɔtsue ɔturi gɔ igbã ɔɖe gu nnɛ ɔbara ne. ");
INSERT INTO akp_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Mmagbe ndɛ̃ ɔbiara to ɔɣɛ ɔ̃ ire. Ne gɔ makpakpɛ̃dze tɔ̃ɖedze iito ɔnɔ itɔ̃me suɖea kuiwɛ̃ ɔbɔrɛgu i ma kɔrɛ ala kulu ɔso ne, ɔtã masu Paulo maapia i makpakpɛ̃dze iyo ame. ");
INSERT INTO akp_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Gɔ mabo kayogodɔ̃ ne, ipia sɔ makpakpɛ̃dze aaputa Paulo, alasɔ maturi situ to sitsue ala ɔ̃ ɔso. ");
INSERT INTO akp_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Mma nsiai ma i kama to mala kulu teteree sɔ, “Miɖoe wũ! Miɖoe wũ!” ");
INSERT INTO akp_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ɔwi gɔ mabie sɔ si masu wũ mapia i iyo ame ne, Paulo ɔɣere makpakpɛ̃dze tɔ̃ɖedze sɔ, “Lobie sɔ loɖegu-ɔ ika kɛkɛĩ.” Ne makpakpɛ̃dze tɔ̃ɖedze ɔkarɛ wũ sɔ, “Nene ato anɔ Griki siɖe? ");
INSERT INTO akp_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Iiɖe fɔ nɖe ɔ Egiptese gɔ lokɔ maturiɖoese kukpi kuna ma lota maya i abã iso ɔwi gɔ lofe ngbe fiɛ matere makɛlɛ fafuĩ ame?” ");
INSERT INTO akp_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ne Paulo ɔtã wũ mmuai sɔ, “Ooɣo, ɔ Yudase loɖe. Maɣe me i Tarso i Kilikia karɔ̃ iso. Ɔmagɛ̃ gɔmɔ ne, iiɖe ɔmagɛ̃ kosoi ɔɖe kɔra. Ne ɔso lotã-ɔ iti tã loɖe ma ika.” ");
INSERT INTO akp_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Tɔ̃ɖedze gɔgbe ɔnɔ karɔ̃ sɔ Paulo si ɔɖe ma ika. Ne Paulo ɔba ɔ̃ɔya i sitĩ iso i kayogodɔ̃ ɔkɔlɛ ɔ̃ kɔrɔ̃ kato sɔ maturi si malo. Gɔ malo kananana ne, ɔɖe ma ika i si Yudase ame sɔ, ");
INSERT INTO akp_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Tete mɛrɛ̃ gu wũ manyii ma losakanya, misɛ o-o! Mitã loɖi so kanya si mi ɔɖuɖu si minɔ.” ");
INSERT INTO akp_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Gɔ manɔ sɔ si Yudase ame ɔto ɔɖe ika ne, maledza ma kulu ibɔ karɔ̃. Ne Paulo ɔɣere ma sɔ, ");
INSERT INTO akp_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ɔ Yudase loɖe. Maɣe me i Tarso i Kilikia karɔ̃ iso. Ɣɛɛ ne, Yerusalem ngbe iɖe losɛ suku. Gamaliel kayirinɔ losuã ara fiɛ mate me bo mawa mmara, ma kubarara gu ma akisi ɔɖuɖu kukaakɔ. Losu wũ ɔtu lotã Ɣaa lɛ kumɛgɔ i mi ɔɖuɖu to mibara i ngbe kiniɔ. ");
INSERT INTO akp_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ita i ɔwi gɔmɔ ne, lotsɛ ikpɛ̃gu mma nsiai kafɔkaɖe Ɔri ɣɛtɛ gɔgbe, lobie sɔ maɖoe ma, ne ɔso lomɔɛ̃ marɛrɛ̃ gu marɔ̃go lopia i iyo. ");
INSERT INTO akp_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Sɔrɛdzekpakpa pelepele gu kasarɛkɔ̃ makpakpa aawo nnɛ loto loɣɛ ngbe ɔtsue, alasɔ ɔwi gɔ loto lokɛlɛ Damasko ne, matã me ɔko sɔ lokɛlɛgu ma Yudase ma i mmɔ si lomɔɛ̃ mafɔɖedze ma mpia i mmɔ, lonyi ma lobɔ Yerusalem si makpadzɛ̃ ma kutsue. ");
INSERT INTO akp_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Gɔ loto lokɛlɛ fiɛ iɔkuti kɛkɛĩ loabo Damasko fiɛ iaɖe lɛ kakɔme ndɛ̃ ne, ɔluwɛ̃ ifiɛ siare iwɛ̃ ɔfiɛ ibɔrɛ i kato ifere me iso! ");
INSERT INTO akp_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Lobɔrɛ lofere i karɔ̃, ne lonɔ silɔ siwɛ̃ ɔɣere me sɔ, ‘Saulo, Saulo, be ɔso fiɛ ato akpɛ̃gu me ngbɔ?’ ");
INSERT INTO akp_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Ne lokarɛ sɔ, ‘Bosate, fɔ nna aɖe?’ “Ne ɔtã me mmuai sɔ, ‘Mme nɖe Yesu Nasaretse gɔ ato akpɛ̃gu ne.’ ");
INSERT INTO akp_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Mma nsɛgu me ɔnya ifiɛ nɛgbe, ɣɛɛ mainɔ silɔ dzɛ loɖegu me ika. ");
INSERT INTO akp_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Ne lokarɛ wũ sɔ, ‘Bosate, be iɖe si lobara?’ “Ne ɔledza me iɣere sɔ, ‘Ta, si akɛlɛ Damasko. Mmɔ loate-ɔ karabara ga ɔso lokpere-ɔ ne.’ ");
INSERT INTO akp_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ifiɛ siare nɛgbe ɔbiɛ me anɔmi, ne ɔso mma nsiai me ka lomɔɛ̃ me i kɔrɔ̃ fiɛ bosɛ boabo Damasko. ");
INSERT INTO akp_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Ɔmagɛ̃ gɔmɔ ame ne, ɔrɛrɛ̃ ɔwɛ̃ pia gɔ marɔ Anania. Ɔɖe ngɔ nsɛ ɔnigã Ɣaa, fiɛ ɔmɔɛ̃ bo mmara ana ɔto teteree. Ma Yudase ɔɖuɖu ma mpia i mmɔ sɛ mawarɛ wũ kukaakɔ. ");
INSERT INTO akp_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ɔrɛrɛ̃ gɔgbe ɔba ɔ̃ɔya i wũ kɔrɛ ɔɣere me sɔ, ‘Wũ ɔturi Saulo, busi anɔmi!’ Ɔluwɛ̃ ne, wũ anɔmi ɔkpa sekelee lonya wũ! ");
INSERT INTO akp_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ne ɔɣere me sɔ, ‘Bo mawa Ɣaa loɖi-ɔ sɔ si aatsue ɔ̃ kuɖɔɛ, aanya ɔ̃ Ɔbi Sekelea fiɛ aanɔ ɔ̃ kanya ame itɔ̃me. ");
INSERT INTO akp_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Fɔ loasɛ aaɣere maturi ɔɖuɖu i kakɔi biara ara wa anya gu nwa anɔ ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Kiniɔ ne, kuira iisikuti. Ta si afɔ Ɣaa itupie kubarara si akparama kayi i ɔ̃ iyere ame fiɛ aafɔ fɔ akpi isu itsɛ.’ ");
INSERT INTO akp_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Ne kama ne, lokpese lokɛlɛ Yerusalem. Gɔ lopia i isɔrɛyo loto lokparama kayi fiɛ ibara me lɛ sirɛ nto sisu me, ne lonya kaɖikate kawɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Mmɔ i Bosate ɔɣere me sɔ, ‘Pɛ siwa si arui i Yerusalem, alasɔ ngbe maturi iibakã-ɔ atsue manɔ wũ itɔ̃me nɛ aaɣɛ.’ ");
INSERT INTO akp_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Ɣɛɛ loɣere wũ sɔ, ‘Bosate, ma ɔɖuɖu ɣe sɔ me lola loɔmɔɛ̃ mma lofɔ-ɔ maɖe sɔ boapɛ ma, bopia ma i iyo i kasarɛkɔ̃ biara. ");
INSERT INTO akp_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ɔwi gɔ mato maɖoe fɔ ɔɖabo Stefano ne, lopia kɔrɔ̃ i ne ame, fiɛ loya lodzuɛ̃ mma nto mapɛ wũ ata maɖoe awu.’ ");
INSERT INTO akp_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Ɣɛɛ Bosate ɔɣere me sɔ, ‘Ta kɛlɛ kadzorokɔ̃ ngbegɔ loapia-ɔ i mma loiɖe ma Yudase kɔrɛ!’ ” ");
INSERT INTO akp_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ɔwi gɔgbe ɔɖuɖu ne, maturi magbe ɔlo maɣɛ kananana mato makã Paulo atsue. Ɣɛɛ ɔwi gɔ ɔɣɛ itɔ̃me tsɔra nɛgbe ne, ma ɔɖuɖu ɔtsɛ kulu teteree sɔ, “Aã! Miyura wũ mala! Miɖi wũ i karɔ̃ iso pelepele!” ");
INSERT INTO akp_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Mato kulu teteree ne matsɛ ma awu ikɛkɛ, mato masa ɔsebu ana mapia i ɔwiri ame i sikpã ame. ");
INSERT INTO akp_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ne makpakpɛ̃dze tɔ̃ɖedze ɔɣere ma sɔ masu wũ mapia i iyo ame si mapɛ wũ fiɛ ɔ̃aɣere ma nnɛ ɔso fiɛ ma Yudase to mala kulu i ɔ̃ iti ngbɔ. ");
INSERT INTO akp_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ɔwi gɔ matsɛ wũ inyi ne, Paulo ɔkarɛ kpakpɛ̃dze ɔkpakpa ɔwɛ̃ gɔ nɣɛ i mmɔ sɔ, “Ɔri pia sɔ mapɛ ɔ Romase gɔ maiɣɛgu atɔ̃me matã ipɔ?” ");
INSERT INTO akp_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ne ɔkpakpa gɔgbe ɔkɛlɛ ma tɔ̃ɖedze kɔrɛ ɔsɛ ɔ̃akarɛ wũ sɔ, “Be ato abie sɔ abara i ngbe? Ɔrɛrɛ̃ gɔgbe ne, ɔ Romase ɔɖe lo!” ");
INSERT INTO akp_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ne ɔso makpakpɛ̃dze tɔ̃ɖedze ɔkɛlɛ Paulo kɔrɛ ɔsɛ ɔ̃akarɛ wũ sɔ, “Biele ne ɔ Romase aɖe?” Ne Paulo ɔtã wũ mmuai sɔ, “Ɔ Romase gɔdɛĩ loɖe!” ");
INSERT INTO akp_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ne tɔ̃ɖedze gɔgbe ɔɣere wũ sɔ, “Mme wũ ne, ɔ Romase loɖe. Me ɣɛɛ ne, kuso lotã titiiti fiɛ lokpese ɔ Romase!” Ne Paulo ɔɣere wũ sɔ, “Me ne, wũ maɣese ɔɖuɖu ne, ma Romase maɖe.” ");
INSERT INTO akp_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ɔluwɛ̃ gɔ mma ikote sɔ maakarɛ wũ atɔ̃me ɔnɔ sɔ ɔ Romase ɔɖe ne, ma ɔɖuɖu ɔkɛlɛ simasima. Gɔ ma tɔ̃ɖedze ɔtsue sɔ ɔ Romase ɔɖe ne, ifɔ̃ ɔmɔɛ̃ wũ gbaã, alasɔ ɔ̃ lotã ɔri fiɛ mapia wũ kugbagɔrɔĩ. ");
INSERT INTO akp_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Makpakpɛ̃dze tɔ̃ɖedze ɔbie sɔ ɔ̃ɔtsue nnɛ loba ɔso fiɛ mato maɖaɛ Paulo kanya. Ne ɔso gɔ kaɖe ɔsɛ̃ ne ɔkpere ma Yudase masɔrɛdze makpakpa gu ma atɔ̃memaɣɛdze ɔɖuɖu maba maasakanya. Ɔtã sɔ maɖi Paulo mabɔ i ma katɔ̃ si mabo i ɔ̃ itɔ̃me ame. ");
INSERT INTO akp_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Gɔ Paulo ɔrara anɔ ɔnyɔ ma Yudase matɔ̃meɣɛdze ma loba maasɛ i atɔ̃mekaɣɛkɔ̃ mmɔ kukaakɔ ne, ɔɣere ma sɔ, “Wũ manyii, wũ ɔtu iitã me ipɔ i Ɣaa anɔmi ame iba iabo nɔme ikpɛnɛ nɛgbe iso.” ");
INSERT INTO akp_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Gɔ Anania gɔ nɖe ma Yudase sɔrɛdzekpakpa pelepele i ma ndɛ̃ ɔnɔ Paulo ikaɖe ne, ɔɣere mma nɣɛ i Paulo kɔrɛ sɔ mapɛ wũ ɔrɔ̃ta i kanya. ");
INSERT INTO akp_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ne Paulo ɔɣere wũ sɔ, “Ɣaa si ɔpɛ-ɔ ɔrɔ̃ta fɔ wũ! Ibere nɛ makua futututu aɖe! Mme atɔ̃meɣɛdze igbã aɖe? Mmara mɛ iso asi sɔ ato aɣɛgu me atɔ̃me ne, me ame iso iɖe ato ata aya gɔ ato aɣɛ sɔ mapɛ me ne!” ");
INSERT INTO akp_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ne mma nɣɛ i Paulo kɔrɛ i mmɔ to makarɛ wũ sɔ, “Ɣaa sɔrɛdzekpakpa pelepele ato atia?” ");
INSERT INTO akp_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ne Paulo ɔtã mmuai sɔ, “Manyii, loiɣe sɔ ɔ̃ nɖe sɔrɛdzekpakpa pelepele, tee loiɖegu wũ ika ngbɔ. Alasɔ matsɛrɛ masɛ i Ɔko Sekelea ame sɔ, ‘Midaaɣɛ ira nyanyarĩa i mi tɔ̃ɖedze iso.’ ” ");
INSERT INTO akp_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Gɔ Paulo ɔnya ɔɖi ite sɔ mma loba maasakanya ne, ma ndɛ̃ mawɛ̃ ɔbɔrɛ i ikuri nɛ marɔ ma Zadukise, fiɛ mawɛ̃ ana ɖe ma Farisise ne, ɔla kulu teteree sɔ, “Wũ manyii, ɔ Farisise loɖe, fiɛ ma Farisise ana loɣe me! Mato maɣɛgu me atɔ̃me alasɔ lofɔ loɖe sɔ makpise to maaledza ita!” ");
INSERT INTO akp_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Gɔ ɔɣɛ itɔ̃me nɛgbe ne, kakpadzɛ̃ ɔbo i aturikuri wagbe ndɛ̃, maɣɛ so aka anyɔ. ");
INSERT INTO akp_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Alasɔ ma Zadukise sɛ maɣɛ sɔ makpise iisibata gu Ɣaa makpabo na gu siwarã agbãagbã ana na. Ɣɛɛ ma Farisise ɔfɔ ara wagbe ɔɖuɖu maɖe. ");
INSERT INTO akp_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Kulu siare ɔbo i ma ndɛ̃. Mmara matedze ma nɖe ma Farisise ɔya Paulo i kama sɔ gbaã iɖe. Matsɛ iɣɛ ku silɔ kpagɛa sɔ, “Boinya kuira nyanyarĩa i ɔ̃ iso! Siainyɔ Siwarã sirere ɣee Ɣaa kpabo loba ɔ̃ɔɖegu wũ ika!” ");
INSERT INTO akp_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kakpadzɛ̃ gagbe ɔkɔlɛ kato kabua. Ma ɔɖuɖu ɔmɔɛ̃ Paulo matsɛ wũ ikpakpadzɛ̃. Ne gɔ makpakpɛ̃dze tɔ̃ɖedze ɔnigã sɔ mato maakpadzɛ̃ wũ matutu ne, ɔɣere ɔ̃ makpakpɛ̃dze sɔ masɛ maafɔ wũ mabɔ maapia i iyo ame. ");
INSERT INTO akp_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Iyi nɛmɔ kasɛ̃ ne, Bosate ɔba ɔ̃aya i Paulo kɔrɛ ɔɣere wũ sɔ, “Paulo, na ɔtu! Kumɛgɔ ame aɣɛ wũ iso itɔ̃me ngbe i Yerusalem ne, ngbɔ ame aaɣɛ i Roma ana ne.” ");
INSERT INTO akp_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Gɔ kaɖe ɔsɛ̃ ne, ma Yudase mawɛ̃ ɔkã ndamu sɔ maibaɖe ɣee manɛ kuira si maiɖoe Paulo! ");
INSERT INTO akp_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Mma lobara adzuni wagbe aaɖe lɛ marɛrɛ̃ sina gu kama. ");
INSERT INTO akp_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Makɛlɛ masɔrɛdze makpakpa gu ma matɔ̃ɖedze kɔrɛ masɛ maaɣere ma sɔ, “Bokã ndamu sɔ boibaɖe ɣee bonɛ kuira si boiɖoe Paulo. ");
INSERT INTO akp_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ne ɔso mi gu atɔ̃memaɣɛdze si miɣere makpakpɛ̃dze ɔkpakpa sɔ ɔledza Paulo ikɔ ibɔ kasarɛkɔ̃ ngbe. Mibara lɛ mito mibie sɔ mikarɛ wũ atɔ̃me mibua. Si maɔɖi wũ mato mabɔ ne, iyɔ boɔɖoe wũ i ɔri.” ");
INSERT INTO akp_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ɣɛɛ gɔ Paulo ɔnyiiko ɔbirɛrɛĩ ɔnɔ ara wagbe ɔɖuɖu ne, ɔtere ɔkɛlɛ ngbegɔ mapia Paulo iyo ɔsɛ ɔ̃aɣere wũ. ");
INSERT INTO akp_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ne Paulo ɔkpere makpakpɛ̃dze ɔwɛ̃ gɔ nɣɛ i mmɔ ɔpia iyo ɔɣere wũ sɔ, “Kɔ ɔporoporoi gɔgbe kɛlɛgu mi tɔ̃ɖedze kɔrɛ. Ɔba itɔ̃me nyaa iwɛ̃ ɔ̃aɣere wũ.” ");
INSERT INTO akp_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ne ɔso kpakpɛ̃dze ɔkɔ ɔbi ɔkɛlɛgu ma tɔ̃ɖedze kɔrɛ. Ɔɣere wũ sɔ, “Paulo gɔ mapia i iyo ngbe loɣere me sɔ lokɔ ɔbi gɔgbe lobɔ fɔ kɔrɛ si ɔba ɔ̃aɣere-ɔ itɔ̃me nyaa iwɛ̃.” ");
INSERT INTO akp_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Makpakpɛ̃dze tɔ̃ɖedze ɔmɔɛ̃ ɔporoporoi gɔgbe i kɔrɔ̃, ne ɔkɔ wũ ɔkɛlɛgu kuruɛ ɔkarɛ wũ sɔ, “Be iɖe ato abie sɔ aaɣere me?” ");
INSERT INTO akp_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ne ɔɣere wũ sɔ, “Ma Yudase mawɛ̃ ɔbara kanya kawɛ̃ ku ma makpakpa sɔ maaba matã-ɔ iti sɔ miɖi Paulo mibɔ kasarɛkɔ̃ mmɔ kɔrãkaɖe ku adzuni sɔ maakarɛ wũ atɔ̃me awɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Daakã ma atsue, alasɔ ma mawɛ̃ ma loaɖe lɛ maturi sina wɛrɛ i ɔri iso masia wũ. Mmagbe ɔkã ndamu sɔ maaɖoe Paulo fiɛ maaɖe ara ɣee maanɛ ndu. Ne ɔso ne, mato mabie fɔ ibuai. Maɔsɛ mawɛrɛ koko i ɔri iso, alasɔ mafɔ maɖe sɔ ato aatɔrã atã ma.” ");
INSERT INTO akp_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Makpakpɛ̃dze tɔ̃ɖedze gɔgbe ɔsɛ̃ ɔtã wũ sɔ, “Daatã sɔ kuwɛ̃ aakpese ɔnɔ itɔ̃me nɛ aba aaɣere me i ngbe ɖuɖuuɖu!” Ne ka ɔɖi wũ ɔri ne. ");
INSERT INTO akp_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ne makpakpɛ̃dze tɔ̃ɖedze ɔkpere ɔ̃ makpakpɛ̃dze makpakpa inyɔ ɔɣere ma sɔ, “Mibie makpakpɛ̃dze alafa anyɔ ma loakɛlɛ Kaisarea nɔme kasɛ̃ lɛ iɖɔwũ kaiwɛ̃ ame. Ibua ne mibie mma loala afele maturi alafa anyɔ gu mma loasɛ i apɔngɔ iso ma wũ ma sikɔdzɛ. ");
INSERT INTO akp_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mitã Paulo apɔngɔ si ɔ̃asɛ iso si mikɔ wũ pɔkɔsɔɔ mikɛlɛgu abã ɔkpakpa Felike kɔrɛ.” ");
INSERT INTO akp_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ne ɔtsɛrɛ ɔko gɔ nse i karɔ̃ ngbe ɔtã abã ɔkpakpa sɔ, ");
INSERT INTO akp_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Ɔko gɔgbe ɔbɔrɛ i mme Klaudio Lisia kɔrɛ losu losese-ɔ, wũ Sate Felike, loya-ɔ. ");
INSERT INTO akp_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ma Yudase ɔmɔɛ̃ ɔrɛrɛ̃ gɔgbe sɔ si maɖoe fiɛ lotã makpakpɛ̃dze ɔfɔ wũ, alasɔ lonɔ sɔ ɔ Romase ɔɖe. ");
INSERT INTO akp_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Lokɔ wũ lokɛlɛgu ma kasarɛkɔ̃ sɔ si bonɔ nnɛ iɖe ɔbara. ");
INSERT INTO akp_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Lonya sɔ ara wa mato maɣɛ ɔse i ma Yudase mmara ara iso gɔ iiɖe iɣɛrɛ nɛ loatã sɔ mapia wũ iyo ɣee maɖoe wũ iɖe. ");
INSERT INTO akp_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Gɔ ɔwɛ̃ ɔɣere me sɔ mato mabara adzuni i ɔ̃ iso sɔ maaɖoe wũ ne, lonyɔ sɔ loasu wũ lobɔ fɔ kɔrɛ si akpere ɔ̃ gu mma lona itɔ̃me sɔ masu ma itɔ̃me mabɔ fɔ kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ne ɔso kasɛ̃ gamɔ ne, makpakpɛ̃dze ɔbara nnɛ maɣere ma tutuutu, makɔ Paulo masɛ maabo Antipatri. ");
INSERT INTO akp_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Gɔ kaɖe ɔsɛ̃ ne, makpakpɛ̃dze ma losɛ ngba ɔkpese makɛlɛ ma kawekɔ̃, ne matã mma nsi i apɔngɔ iso ɔkɔ Paulo makɛlɛgu Kaisarea ne. ");
INSERT INTO akp_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Gɔ masɛ maabo ne, masu Paulo gu ɔko gɔ matã ma matã abã ɔkpakpa. ");
INSERT INTO akp_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ɔwi gɔ ɔto ɔka ɔko ne, ɔkarɛ Paulo ngbegɔ ɔbɔrɛ. Gɔ ɔtsue sɔ Paulo ɔbɔrɛ i Kilikia ne, ");
INSERT INTO akp_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ɔɣere wũ sɔ, “Loabo i fɔ itɔ̃me ame kukaakɔ si fɔ kanya maɖaɛdze ɔɔba.” Ne ka ɔtã ɔ̃ makpakpɛ̃dze ma mpia i mmɔ ɔsu Paulo mapia i iyo nɛ i Herodes ɔtsue ame si madzuɛ̃ wũ ne. ");
INSERT INTO akp_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ayi aru kama ne, Sɔrɛdzekpakpa Anania gu ma Yudase matɔ̃ɖedze gu atɔ̃me kanyaɖidze gɔ marɔ Tertulo ɔkɛlɛ Kaisarea. Makɛlɛ Felike kɔrɛ sɔ maaɖi Paulo aɣɛrɛ ɔɖuɖu mate. ");
INSERT INTO akp_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Gɔ makpere Paulo ne, Tertulo ɔtsɛ ma kanya iɖi sɔ, “Ɔbea, ɔwi dzoroo nɖe ngɔgbe gɔ bopia i isobuɛ ame ala fɔ iwola nɛ asu aɖegu bo katɔ̃ ɔso. Boɔnya akpaki sɛɛ gbodzoo wa ana loɔba i bo karɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Kakɔi biara ne, ara wagbe sɛ abo bo anɔ, nnɛgbe ɔso fiɛ bo ma Yudase ɔɖuɖu sɛ bopɛ-ɔ siba ne. ");
INSERT INTO akp_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Loito lobie sɔ lonina-ɔ ɔwi ɔso ne, lotã-ɔ iti sɔ kã bo atsue si anɔ bo atɔ̃me wa boto boba bɔaɣɛ i ɔrɛrɛ̃ gɔgbe iso. ");
INSERT INTO akp_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Bonya ɔrɛrɛ̃ gɔgbe sɔ kulu piadze ɔɖe fiɛ ɔpia ɔki ɔwi biara ɔfinikira ma Yudase adzuni i kakɔi biara i kayiiso ɔɖuɖu. Ana ne, ɔɖe ikuri nɛ marɔ ma Nasaretse tɔ̃ɖedze. ");
INSERT INTO akp_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ɔbie sɔ si ɔpia ma Yudase isɔrɛyo anyini fiɛ bomɔɛ̃ wũ. ");
INSERT INTO akp_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ɣɛɛ makpakpɛ̃dze tɔ̃ɖedze Lisia ɔba ɔ̃afɔ wũ ɔɖi i bo nrɔɔ̃ ame ku ɔle. Ne kama ne, ɔɣere bo sɔ boba boaɣɛ itɔ̃me i fɔ katɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ne ɔso fɔ mɔmɔ karɛ ɔrɛrɛ̃ gɔgbe si anɔ si sila boto bola.” ");
INSERT INTO akp_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ma Yudase ɔɖuɖu ɔtɔrã masia sɔ nwa ɔɖuɖu i Tertulo ɔɣɛ pia i ne ame. ");
INSERT INTO akp_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Gɔ abã ɔkpakpa gɔmɔ ɔkpa Paulo kɔrɔ̃ sɔ ka ɔɖe ika ne, Paulo ɔsɛ karɔ̃ sɔ, “Tete, loɣe sɔ ka asɛ aɣɛ ma Yudase atɔ̃me i akɔ gbodzoo wagbe ame. Ne ɔso iba me ɔmɛrɛ̃ sɔ loaɖi so kanya i fɔ katɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Lɛ kumɛgɔ aatsue ne, iɖe lɛ akpɛnɛ aweo-anyɔ i ngbe gɔ loba Yerusalem sɔ si loba loasɔrɛ Ɣaa i Isɔrɛyo. ");
INSERT INTO akp_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Kuwɛ̃ iinya me sɔ loto lobaragu kuwɛ̃ kakpadzɛ̃ ɣee kulu i isɔrɛyo ame ɣee ma Yudase kusarɛkɔ̃ kukawɛ̃ ɣee ɔmagɛ̃ ame kukakɔi. ");
INSERT INTO akp_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Mmagbe kuwɛ̃ iibawo irɔĩ ɔkarã i kuira iso sɔ maɣe sɔ atɔ̃me wa mato maɣɛ ngbe ne, gbaã iɖe. ");
INSERT INTO akp_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ɣɛɛ ne, nnɛ lonɔgu ma karɔ̃ nɖe sɔ loto losɔsrɛ bo mawa Ɣaa i Ɔri gɔ ma mato marɔ ikuri nɛ lota iɣɛ ma iso. Lofɔ Mose mmara ɔɖuɖu loɖe gu ara wa matsɛrɛ mapia i Ɣaa kanyamaɖidze siko ame. ");
INSERT INTO akp_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Wũ anɔ sia i Ɣaa iso lɛ kumɛgɔ ma wũ ma are sia sɔ maturi sɛɛ gu malalaa ɔɖuɖu to maaledza ita mabɔrɛ i makpise ame. ");
INSERT INTO akp_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ne ɔso losɛ lopia kubɛ sɔ wũ adzuni ame aakpa sekelee i Ɣaa gu maturi katɔ̃ ɔwi ɖaa ne. ");
INSERT INTO akp_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Akɔ gbodzoo i ngbe gɔ lona i Yerusalem ne. Losɛ kere sɔ loasu karatã lokɛlɛgu mawɛrɛba fiɛ ka loafɛ̃ ara lotã Ɣaa. ");
INSERT INTO akp_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ɔwi gɔ lokpakpa so loro ne, ma Yudase mawɛ̃ ɔba maanya me i isɔrɛyo mmɔ. Iiɖe bo gu kulu mabaradze kumawɛ̃ nsɛ, fiɛ loibara kulu ana. ");
INSERT INTO akp_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ma Yudase ma lobɔrɛ i Asia karɔ̃ iso ikote sɔ maaba fɔ kɔrɛ fiɛ si bo gu ma ba atɔ̃me arere i bo ndɛ̃ ne, iyɔ maɔɣɛ. ");
INSERT INTO akp_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Fiɛ si abie ne, aawo tã mma nsi i ngbe ɔɣɛ ira lalaa nɛ manɔ i wũ iso ku ɔwi gɔ i ma Yudase matɔ̃meɣɛdze ɔɣɛgu me atɔ̃me. ");
INSERT INTO akp_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Itɔ̃me iwɛ̃ saã lokɔlɛ silɔ kato loɣɛ i kasarɛkɔ̃ ɔwi gɔ mato maɣɛgu me atɔ̃me sɔ lofɔ loɖe sɔ makpise to maaledza ita. Ne ɔso fiɛ mito miɣɛgu me atɔ̃me ne?” ");
INSERT INTO akp_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Mmɔ i Felike gɔ nɣe kafɔkaɖe ɔri ɣɛtɛ gɔgbe kukaakɔ ɔɣere ma Yudase sɔ, “Miya tɔtɔ gbɔgbɔɔgbɔ ɔwi gɔ ame i makpakpɛ̃dze tɔ̃ɖedze Lisia aaba fiɛ loaɖaɛ mi itɔ̃me nɛgbe.” ");
INSERT INTO akp_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ɔɣere makpakpɛ̃dze ɔkpakpa sɔ masu Paulo mapia i iyo si madzuɛ̃ wũ ɣɛɛ mala wũ kukaakɔ si matã ɔ̃ malaa ɔri mala maɔba ɔ̃ kɔrɛ, maɔbara ɔ̃ ara nyaa matã wũ. ");
INSERT INTO akp_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ayi kɛkɛĩ kama ne, Felike gu ɔ̃ ɔre Drusila gɔ nɖe ɔ Yudase ɔba, ne matã sɔ maɖi Paulo mabɔ fiɛ ɔɣere ma itɔ̃me i Yesu Kristo kafɔkaɖe iso ne. ");
INSERT INTO akp_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Gɔ ɔsɛ karɔ̃ ɔtsɛ ara karɔ̃ iɖi i ngbã sekelea isɛ gu iɖesoiso gu Ɣaa atɔ̃me iɣɛgu nɛ loaba i kayiiso karokɔ̃ ne, ifɔ̃ ɔmɔɛ̃ Felike gbaã, ne ɔɣere wũ sɔ, “Ta si akɛlɛ. Si loɔna kɔrɔ̃ kukaakɔ ne, loatã makpere-ɔ matã me.” ");
INSERT INTO akp_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Gɔ ɔla ɔ̃ɔnyɔ ɔri sɔ Paulo to ɔ̃abie ira ɔtã wũ ɔso ne, kɛkɛ ɔ̃ɔpia wũ ɔturi sɔ ɔba si maɖe ika. ");
INSERT INTO akp_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Akɔ anyɔ kama ne, maɖi Felike, ne masu Porkio Festo masɛra i ɔ̃ kanya ne. Ɣɛɛ gɔ Felike to ɔbie sɔ ma Yudase si maɖɔɛ ɔ̃ itɔ̃me ɔso ne, ɔnyua Paulo ɔpia i iyo. ");
INSERT INTO akp_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Gɔ Festo ɔba ɔ̃ɔbo ibuiti nɛ iso ɔto ɔba ɔ̃aɖe ikpɛnɛ tɛare ne, ɔrui i Kaisarea ɔkɛlɛ Yerusalem. ");
INSERT INTO akp_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Mmɔ i masɔrɛdze makpakpa gu ma Yudase matɔ̃ɖedze ɔɣere wũ Paulo iso itɔ̃me, matã wũ iti sɔ, ");
INSERT INTO akp_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ɔbualɛ ma si ɔɖi Paulo ɔbɔ i Yerusalem. Ma adzuni loɖe sɔ maawɛrɛ i ɔri iso maɖoe wũ. ");
INSERT INTO akp_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ɣɛɛ Festo ɔɣere ma sɔ, “Yorɛdze Paulo pia i Kaisarea, fiɛ mme wũ loto loakɛlɛ mmɔ i ɔwi kurukutu ame. ");
INSERT INTO akp_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ne ɔso mitã sɔ mi matɔ̃ɖedze si masiai me maba maɖi ɔ̃ aɣɛrɛ mate.” ");
INSERT INTO akp_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Lɛ akpɛnɛ farafana ito ikɛlɛ aweo ame ne, Festo ɔkpese ɔkɛlɛ Kaisarea. Iyi nɛ ɔbo mmɔ kaɖesɛ̃a ne, ɔsɛ i Paulo itɔ̃me iso. ");
INSERT INTO akp_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Gɔ Paulo ɔba atɔ̃mekaɣɛkɔ̃ ne, ma Yudase ma lobɔrɛ i Yerusalem ɔba maaki malɔ wũ matsɛ nnya siare gbodzoo iɖaɛ isia wũ iso i ara wa ma mɔmɔ maɣe sɔ ana i ne ame. ");
INSERT INTO akp_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paulo ɔɖi so kanya ɔɣere ma sɔ, “Loiɣɛrɛ ma Yudase mmara ɣee ma isɔrɛyo ɣee Igarakpakpa mmara iso.” ");
INSERT INTO akp_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ɣɛɛ gɔ Festo to ɔbie sɔ ma Yudase si maɖɔɛ ɔ̃ itɔ̃me ɔso ne, ɔkarɛ Paulo sɔ, “Abie sɔ aakɛlɛ Yerusalem si losɛ loaɣɛgu-ɔ atɔ̃me i mmɔ?” ");
INSERT INTO akp_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulo ɔɣere wũ sɔ, “Ooɣo! Loɣɛ i karɔ̃ gagbe ɔɖuɖu igara mɔmɔ atɔ̃mekaɣɛkɔ̃, ngbegɔ ikote sɔ maaɣɛgu me atɔ̃me. Fɔ mɔmɔ aɣe sɔ loiɣɛrɛ ma Yudase. ");
INSERT INTO akp_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Si lobara nnɛ lokote sɔ maaɖoe me ne, lotɔrã sɔ maɖoe me! Ɣɛɛ si loiɣɛrɛ ne, idaaba sɔ fɔ ɣee kuwɛ̃ aasu me ɔtã mmagbe. Ne ɔso nto lobie sɔ loasu wũ itɔ̃me lokɛlɛgu Igarakpakpa katɔ̃!” ");
INSERT INTO akp_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ne kama gɔ Festo ɔsɛ iti ame gu makpakpa ne, ɔɣere wũ sɔ, “Gɔ fɔ sɔ aasu fɔ itɔ̃me akɛlɛgu Igarakpakpa katɔ̃ ɔso ne, ɔ̃ katɔ̃ aakɛlɛ.” ");
INSERT INTO akp_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ayi arɛ̃saã kama ne, Igara Agripa gu ɔ̃ ɔnyiiko gɔ marɔ Bernike ɔba Festo kɔrɛ i Kaisarea sɔ si maba maya wũ. ");
INSERT INTO akp_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Mawe i mmɔ ayi gbodzoo, ne ɔso Festo ɔsu Paulo itɔ̃me ɔɣere igara gɔgbe sɔ, “Ɔrɛrɛ̃ ɔwɛ̃ pia i iyo ngbe gɔ Felike ɔnyua wũ ɔsɛ. ");
INSERT INTO akp_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Gɔ losɛ Yerusalem ne, masɔrɛdze makpakpa gu ma Yudase matɔ̃ɖedze ɔɣere me ara i ɔ̃ iso, maɣere me sɔ lotã wũ kukpi ipɔ. ");
INSERT INTO akp_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Loɖi karɔ̃ lote ma ɔluwɛ̃ sɔ ma Romase mmara iitã ɔri sɔ maatã ɔturi ipɔ fiɛ maaɣɛgu wũ atɔ̃me. Ikote sɔ maatã wũ ɔri sɔ ɔ̃ gu mma lona atɔ̃me aasarɛ maɖi so kanya tɔtɔ. ");
INSERT INTO akp_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ne ɔwi gɔ maba ngbe, i itɔ̃me nɛgbe ɔso ne, loinina ɔwi ɖuɖuuɖu. Iyi nɛmɔ ame kaɖesɛ̃a ne, losɛ i atɔ̃mekaɣɛkɔ̃ iyara iso lotã sɔ maɖi ɔrɛrɛ̃ gɔgbe mabɔ me. ");
INSERT INTO akp_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ɣɛɛ ne, atɔ̃me wa maɣɛ masegu i ɔ̃ iso ne, iiɖe nwa lonyɔ ɔri lotã. ");
INSERT INTO akp_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ara wa iso maɖaɛ wũ kanya nɖe ma kafɔkaɖe iso gu ɔrɛrɛ̃ gɔ marɔ Yesu gɔ lokpi, fiɛ Paulo to ɔɣɛ sɔ ɔpia ngbã iso! ");
INSERT INTO akp_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Lokpɔkpɔtɔ alasɔ loiɣe kumɛgɔ loaɖaɛ itɔ̃me. Ne ɔso lokarɛ Paulo si ɔ̃atɔrã bokɛlɛ Yerusalem si boasɛ boafafarɛ ɔ̃ itɔ̃me ame i mmɔ. ");
INSERT INTO akp_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ɣɛɛ Paulo ɔɣɛ sɔ ɔ̃asu ɔ̃ itɔ̃me ɔkɛlɛgu Igarakpakpa kɔrɛ. Ne ɔso lotã sɔ masu wũ mapia i iyo gbɔgbɔɔgbɔ ɔwi gɔ loasese wũ Igarakpakpa kɔrɛ.” ");
INSERT INTO akp_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ne Igara Agripa ɔɣere Festo sɔ, “Lobie sɔ mme mɔmɔ loanɔ ɔ̃ itɔ̃me.” Ne Festo ɔɣere wũ sɔ, “Ato anɔ ɔ̃ itɔ̃me kɔrãkaɖe!” ");
INSERT INTO akp_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ne gɔ kaɖe ɔsɛ̃ ne, Igara Agripa gu Bernike ɔpia ma agarara, fiɛ maba atɔ̃mekaɣɛkɔ̃ mmɔ. Makpakpɛ̃dze ɔkpakpa gu kaɖe makpakpa ɔsiai ma kama. Ne Festo ɔtã maɖi Paulo mabɔ ne. ");
INSERT INTO akp_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ne Festo ɔɣɛ sɔ, “Igara Agripa gu mi ma losakanya ngbe, ɔrɛrɛ̃ gɔgbe nɖe ngɔ i ma Yudase ma i Yerusalem gu mma i Kaisarea ngbe ɔɖuɖu to mabie sɔ maɖoe ne. ");
INSERT INTO akp_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ɣɛɛ i wũ adzuni kanya ne, ɔ̃ibara kuira nɛ lokote itã sɔ maaɖoe wũ, ɣɛɛ gɔ sɔ ɔ̃ itɔ̃me si ikɛlɛ Igarakpakpa kɔrɛ ɔso ne, lonyɔ sɔ loasese wũ. ");
INSERT INTO akp_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ɣɛɛ lona kuira pɔtĩ nɛ loatsɛrɛ losese Igarakpakpa i ɔ̃ iso. Ne ɔso fiɛ loɖi wũ lobɔ mi ɔɖuɖu katɔ̃ titirio fɔ Igara Agripa sɔ iaki itɔ̃me nɛgbe ame irere ne, loana nnɛ loatsɛrɛ. ");
INSERT INTO akp_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Alasɔ ne, iikote sɔ loasu yorɛdze losese Igarakpakpa atɔ̃mekaɣɛkɔ̃ gɔ loitsɛrɛ ɔ̃ aɣɛrɛ losese igara.” ");
INSERT INTO akp_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Ne Agripa ɔɣere Paulo sɔ, “Ɔri ka ɔpia, ɖi so kanya.” Paulo ɔkɔlɛ kɔrɔ̃ kato ɔɖi so kanya ɔɣɛ sɔ, ");
INSERT INTO akp_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Bo Igara Agripa, iti lɛ me sɔ loaɖi so kanya nɔme i fɔ katɔ̃ i ara wa iso i ma Yudase to maɖaɛ me kanya. ");
INSERT INTO akp_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Alasɔ loɣe sɔ fɔ ne, aɣe ma Yudase mmara gu kubarara ɔɖuɖu kukaakɔ. Ne ɔso ne, lotã-ɔ iti, na ɔtu si akã me atsue. ");
INSERT INTO akp_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Ma Yudase ɔɖuɖu ɣe kumɛgɔ lomɔɛ̃ so lola kukaakɔ ita i wũ sibiɛtɛ ame i bo aɖe gu Yerusalem ana. ");
INSERT INTO akp_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ngbɔ ame si maaɖe so ɔnukuare ne, maɣe sɔ ɔ Farisise gɔ nsɛ ɔbara i mmara iso tutuutu loɖe. ");
INSERT INTO akp_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ara wa ɔso fiɛ mato maɖaɛ me kanya ngbe nɖe wũ ɔriinyɔ sɔ Ɣaa to ɔba ɔ̃abara ara wa ɔɣere bo mawa ɔsɛ. ");
INSERT INTO akp_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Israel nlɛ miweo-minyɔ ɔɖuɖu ɔsu ma ɔle ɔɖuɖu i kasɛ̃ i kakɔme masumu Ɣaa sɔ si mawe ɔriinyɔ nɛ loba ngbe. Bo Igara Sɛɛ, nnɛgbe ɔso fiɛ ma Yudase to maɖaɛ me kanya ne. ");
INSERT INTO akp_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Be ɔso fiɛ ito iɖa mi karɔ̃ inɔ sɔ miafɔ miɖe sɔ Ɣaa to ɔ̃atara makpise? ");
INSERT INTO akp_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Losu losia so iso sɔ loabara ira biara sɔ loatindza Yesu Nasaretse masiaidze karabara. ");
INSERT INTO akp_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ma Yudase sɔrɛdzekpakpa pelepele ɔtã me ɔle lomɔɛ̃ maturi sekelea gbodzoo lopia i iyo i Yerusalem. Mma ana maɖoe ne, iɖe me isoɣɔ. ");
INSERT INTO akp_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Lota loya ma iso, lokpɛ̃gu ma lobara ma ɔtile ala sikpã dzɛ loba i ma iso ɔso ne, lokɛlɛ abuiti gu simagɛ̃ dzɛ lodzoro ame. Lotã sɔ mabara ma ara boa i ma Yudase kusarɛkɔ̃ ɔɖuɖu. Lobie sɔ ma mɔmɔ si mawa kanya maɣɛ amusuora i Yesu iso. ");
INSERT INTO akp_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Adzuni wagbe igbã ɔso fiɛ lota sɔ losɛ Damasko gu ɔle gu ɔri gɔ lofɔ lobɔrɛgu i masɔrɛdze makpakpa kɔrɛ ne. ");
INSERT INTO akp_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Igara Sɛɛ, gɔ losɛ i ɔri lɛ kakɔme ndɛ̃ ne, lonya ifiɛ teteree ɔbɔrɛ i kato nɛ loɖo kuɣɛ̃, ɔfiɛ ifere bo gu mma ɔɖuɖu nsɛ. ");
INSERT INTO akp_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Gɔ bo ɔɖuɖu ɔbɔrɛ borɔ̃ ne, lonɔ silɔ siwɛ̃ dzɛ loɖe ika i ma Yudase siɖe ame siɣɛ sɔ, ‘Saulo, Saulo, be ɔso fiɛ ato akpɛ̃gu me ngbɔ? Si atura i siyu iso ne, ato aare igbɛ.’ ");
INSERT INTO akp_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Ne lokarɛ wũ sɔ, ‘Tete, fɔ nna aɖe?’ “Ne silɔ dzɛmɔ to sitã me mmuai sɔ, ‘Mme nɖe Yesu gɔ ato akpɛ̃gu ngbɔ ne. ");
INSERT INTO akp_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ɣɛɛ ne, ta ya! Alasɔ loɖi so lote-ɔ si loasu-ɔ lobara wũ rabaradze. Ato aaɣere kayiiso ɔɖuɖu ara wa anya i ngbe gu nwa loaɖi lote-ɔ. ");
INSERT INTO akp_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ngbegɔ loapia-ɔ ne, loadzuɛ̃-ɔ i mi aɖe maturi ndɛ̃ gu mafɔ nrɔɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Loatã sɔ aasɛ aabusi ma anɔ sɔ maabɔrɛ i Ɔbosam ɔle gu idududu ame fiɛ maaba Ɣaa ɔle gu ikpawaĩ ame. Ɣaa to ɔ̃asu ma akpi ɔtsɛ ma fiɛ ɔ̃abara ma Ɣaa sigarakaɖekɔ̃ masɛdze gu mma ɔsekelera alasɔ mafɔ me maɖe ɔso.’ ");
INSERT INTO akp_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Ne ɔso ne, Igara Agripa, loisɛ̃ kaɖikate ga lonya lobɔrɛgu i kato! ");
INSERT INTO akp_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Lotsɛ Itɔ̃me Bielea iɣere ma Damaskose gu ma Yerusalemse gu ma Yudase ɔɖuɖu gu mma loiɖe ma Yudase sɔ mafiniki i ma siri nyanyarĩa iso si masu so matã Ɣaa si mabara ara sɛɛ wa loate sɔ maɔfiniki gbaã. ");
INSERT INTO akp_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Nnɛgbe ɔso fiɛ ma Yudase ɔmɔɛ̃ me i ma isɔrɛyo gɔ loto loɣɛ atɔ̃me wagbe ne. Mabie sɔ si maɖoe me fiɛ. ");
INSERT INTO akp_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ɣɛɛ ne, Ɣaa ɔɖi me ɔbɔrɛgu i ma nrɔɔ̃ ame. Ne ɔso lokpese lopia ngbã sɔ loaɖiɖi ara wagbe ame lote mi makpakpa gu maturi ɔɖuɖu ne. Nnɛ loto loɣɛ ngbe ne, ngbɔ ame i Ɣaa kanyamaɖidze gu Mose ɔɖuɖu ɔɣɛ sɔ ito iaba ne. ");
INSERT INTO akp_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Sɔ Kristo gɔ nɖe Ɣaa ɔre gɔ ɔsia ikparĩ aaba ɔ̃awe inyɛ. Ɔ̃ ɔɖe loaɖe ɔturi ɖeakatɔ̃ gɔ loata ɔbɔrɛ i makpise ame, fiɛ ɔ̃asu ikpawaĩ ɔbɔ ma Yudase gu mma loiɖe ma Yudase ɔɖuɖu.” ");
INSERT INTO akp_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Ɔluwɛ̃ ne, Festo ɔla kulu ɔɣɛ sɔ, “Paulo ka alala! Fɔ ɔko isuã kaɖu ɔɔnina-ɔ iti ame!” ");
INSERT INTO akp_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Paulo ɔ̃ta wũ mmuai sɔ, “Tete Festo, loito lolala. Wũ adzuni ɔnyɔ waĩ. Gbagbaã nto loɣɛ. ");
INSERT INTO akp_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Gbaã ne, Igara Agripa ɣe atɔ̃me wa loto loɣɛ ngbe ne ɔso loawo wã ɔɣɛ ku kagbegbe. Lofɔ loɖe sɔ ara wagbe kuiwɛ̃ iiwɛrɛ i ɔ̃ katɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Igara Agripa, afɔ Ɣaa kanyamaɖidze magbe aɖe? Loɣe sɔ afɔ ma aɖe.” ");
INSERT INTO akp_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ne Agripa ɔkarɛ Paulo sɔ, “Abu sɔ akpesera me Kristo ɔre i ɔwi kurukutu gɔgbe ame?” ");
INSERT INTO akp_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Ne Paulo to ɔtã wũ mmuai sɔ, “Kiniɔkiniɔ ɣee ɔwi gɔ nto ɔba iɖe o-o ne, nto lokparama kayi sɔ mi ma mpia i ngbe ɔɖuɖu aase lɛ kumɛgɔ lose iɖo kugbagɔrɔĩ gɔ lopia ngbe!” ");
INSERT INTO akp_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ne Igara Agripa gu Festo gu Bernike gu maturi tsɔra ɔɖuɖu ɔta ne. ");
INSERT INTO akp_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Gɔ maɔbɔrɛ i mmɔ ne, maɖe ika i Paulo atɔ̃me wagbe iso maɣɛ sɔ, “Ɔrɛrɛ̃ gɔgbe iibara kuira nɛ loatã sɔ maaɖoe wũ ɣee mapia wũ iyo.” ");
INSERT INTO akp_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ne Igara Agripa to ɔɣere Festo sɔ, “Tee boawo wũ ɔnyua si iiɖe sɔ ɔ̃ɔsu ɔ̃ itɔ̃me ɔkɛlɛgu Kaisaro katɔ̃.” ");
INSERT INTO akp_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ɔwi gɔ masɛ sɔ boakɛlɛ Italia ne, masu Paulo gu mayorɛdze mama mapia i makpakpɛ̃dze ɔkpakpa gɔ marɔ Yulio nrɔɔ̃ ame. Ɔɖe ɔkpakpa i igarakpakpa makpakpɛ̃dze ikuri ame. ");
INSERT INTO akp_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Bosu ɔkolo gɔ lobɔrɛ i Adramitio fiɛ ɔsɛ Asia ibuiti. Bo gu ɔ Makedoniase gɔ marɔ Aristarko fiɛ ɔbɔrɛ i Tesalonika losɛ i ɔkolo gɔgbe ame. ");
INSERT INTO akp_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Kaɖesɛ̃a ne, boɔbore bobo Sidon ɔpo kanya. Yulio ɔbara Paulo kayiribielea ɔtã wũ ɔri sɔ ɔkɛlɛ ɔmagɛ̃ ame ɔsɛ ɔ̃anya ɔ̃ malaa si mabie ɔ̃ ara wa ɔ̃asu ɔsɛ ala ɔri matã wũ. ");
INSERT INTO akp_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ne gɔ boledza ita i mmɔ ne, ɔwiri gɔ nto ɔkpɛ̃ kanya ne, boki i Kipro ngbalɔ isɛ si boibabo i ɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Gɔ bofe mmɔ ne, bosɛ boaki i Kilikia gu Pamfilia ɔpo kanya bobore bomatã ɔmagɛ̃ gɔ marɔ Mira i Likia ibuiti ame. ");
INSERT INTO akp_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Kpakpɛ̃dzekpakpa gɔ nsɛgu bo ɔnya ɔkolo gɔ lobɔrɛ i Aleksandria fiɛ ɔsɛ Italia karɔ̃ iso. Ɔsu bo ɔɖuɖu ɔpia i ɔkolo gɔgbe ame. ");
INSERT INTO akp_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Kumɛgɔ i ɔwiri to ɔkpɛ̃ ɔso ne, ifɔ ayi gbodzoo fiɛ bobore bobo Knido ɔmagɛ̃. Ɔwiri teteree gɔ nto ɔkpɛ̃ i mmɔ ɔso ne, boisɛ tɔrɔrɔ. Gɔ bobo Salmone ne, bolɔ boki i Kreta kuruɛ gɔ itã karɔ̃ ɔfɔ ɔwiri ɔle. ");
INSERT INTO akp_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ɔle ame bosɛ i ndu kuruɛ kuruɛ bosɛ boabo kakɔi ga marɔ “Sikolo Katuikɔ̃ Sɛɛ” gɔ loidzorogu ɔmagɛ̃ gɔ marɔ Lasea. ");
INSERT INTO akp_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Bonina ɔwi gbodzoo ne ɔso ma Yudase Kanya ɔnyiwi ɔɔfe. Ndu iso irisɛ ku ɔwi gɔgbe ame ba ɔle ibua, ne ɔso Paulo ɔtã ma adzuni sɔ, ");
INSERT INTO akp_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Tete mɛrɛ̃, lonya sɔ bo irisɛ ita i kiniɔ to iawe ɔle ibua, alasɔ ɔkolo gɔgbe to ɔ̃abo i kukpakpi ame fiɛ boto boayura ato gu maturi ana.” ");
INSERT INTO akp_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ɣɛɛ makpakpɛ̃dze ɔkpakpa ɔfɔ ɔkolo kãse gu ɔkolo sate adzuni ɔɖo nnɛ i Paulo ɔɣɛ. ");
INSERT INTO akp_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Gɔ ɔkolo katuikɔ̃ gamɔ iilɛ katã sɔ maaya idzoro ala ɔyu ɔwi ka ɔba ɔso ne, marisɛdze ɔsia ita sɔ maarui makɛlɛ Foinike. Mmɔ ne, mato maawo ɔwe ku ɔyu ɔwi, alasɔ Foinike ɖe ɔmagɛ̃ i Kreta karɔ̃ iso gɔ mba sikolo kayakɔ̃ i kuɣɛ̃ iyo kabokɔ̃ isɛ ga loatɛ̃ ɔwiri ɔri. ");
INSERT INTO akp_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ɔwi gɔmɔ ame ne, ɔwiri sɛɛ ɔtsɛ ikpɛ̃ ibɔrɛ i kala isɛ gɔ lote lɛ ɔwi sɛɛ ɔɖe sɔ maasɛ ɔri. Ne ɔso maledza so marui maki i Kreta karɔ̃ kuruɛ. ");
INSERT INTO akp_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ɣɛɛ ɔluwɛ̃ ne, awɛ teteree ɔtsɛ ikpɛ̃ abɔrɛ i karɔ̃ iso asarɛgu bo gɔ bobɔrɛ i Kreta boro kere. ");
INSERT INTO akp_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Awɛ ɔsarɛgu ɔkolo gɔ boisibawo wũ ɔfinikira ɔsɔ̃ karɔ̃ iso. Ne ɔso manyua wũ sɔ ɔwiri si ɔkpadzɛ̃ wũ ɔkɛlɛgu. ");
INSERT INTO akp_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Kama ne, bosɛ boabo i karɔ̃ kɛkɛĩ kawɛ̃ ga i ndu ɔki milɔ ga marɔ Kauda kama. Ɔle ame fiɛ bowo ɔkolo kosoi gɔ bosɛgu ɔnyi ɔmatãra i ɔsiare gɔ ame bopia iso. ");
INSERT INTO akp_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Gɔ manyi wũ maro ne, masu siwɛ̃ manyi ɔsiare ana. Gɔ ifɔ̃ to ma sɔ ɔwiri aasu wũ ɔkɛlɛgu iba wodoroa iso i Libia ɔpo kanya ɔso ne, masora sikati dzɛ nsɛ simɔɛ̃ ɔwiri i ɔkolo kato ɔɖuɖu. Ne ɔso ɔwiri ne, ɔsɛ kere ka ɔsɛgu ɔkolo i ndu iso. ");
INSERT INTO akp_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Gɔ kaɖe ɔsɛ̃ fiɛ ɔwiri iito ɔnyua ɔkpɛ̃ ne, matsɛ ato wa i ɔkolo sore iɖi iwiri i ndu ame. ");
INSERT INTO akp_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Iyi tɛare iso ne, matsɛ ɔkolo mɔmɔ ana ara iɖi ipɛyu. ");
INSERT INTO akp_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Awɛ wagbe ɔkpɛ̃ ayi gbodzoo sɔ boinya kuɣɛ̃ ɣee awãmi. Boyu ɔriinyɔ ɔɖuɖu! ");
INSERT INTO akp_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Gɔ maɔsɛ ayi gbodzoo fiɛ maina kɔrɔ̃ maɖe ara ne, Paulo ɔta ɔya i ma katɔ̃ ɔɣere ma sɔ, “Manyii, si ɔkã mikã me atsue ne, tee boirui i Kreta fiɛ ara wagbe ɔɖuɖu aba aabɔrɛ bo iso. ");
INSERT INTO akp_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Lobie sɔ loaɣere mi sɔ mina ɔtu ne mi kuwɛ̃ iibakpi. Ɣɛɛ ɔkolo ne, ɔto ɔ̃awã ndu! ");
INSERT INTO akp_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kɔma kasɛ̃ ame ne, Ɣaa gɔ ɔre loɖe, fiɛ ɔ̃ nto losumu kpabo ɔba ɔ̃ɔya i wũ kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Ɔɣere me sɔ, ‘Paulo, daanigã. Ato aaya i Kaisaro katɔ̃ asu fɔ itɔ̃me asɛ wũ i katɔ̃. Ɣaa ɔɔsu mma ɔɖuɖu mpia i ɔkolo ame ngbã ɔpia-ɔ i nrɔɔ̃ ame, mi kuwɛ̃ iibakpi.’ ");
INSERT INTO akp_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ne ɔso ne, wũ maturi, mina ɔtu. Lofɔ Ɣaa loɖe sɔ ira biara nɛ ɔɣere me sɛ iba i ne ame. ");
INSERT INTO akp_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ɣɛɛ ne, ɔwiri to ɔ̃akpadzɛ̃ bo ɔkɛlɛgu ɔ̃amɔrɛ̃dza i karɔ̃ kawɛ̃ ga i ndu ɔki milɔ ɔkpokpo.” ");
INSERT INTO akp_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ɔwiri siare gɔgbe ɔfuri bo ɔsɛgu ɔkpesegu i Adria ɔpo iso ayi aweo ana. Iyi weo-naare kasɛ̃ ndɛ̃ ne, bo ɔkolo ame marabaradze ɔbu sɔ maɔbore mamatã karɔ̃ kawɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ne gɔ masusu ndu iwodoro manyɔ ne, manya sɔ miwodoro lɛ ngba kulafa gu sinyɔ ɔɖui. Gɔ makɛlɛ katɔ̃ kɛkɛĩ ana ne, maledza isusu manya sɔ ka miɖe ngba kasiwɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Gɔ ifɔ̃ to ma sɔ ɔwiri to ɔ̃asore ɔkolo ɔsɛ ɔ̃awuĩ i ata siare arere iso ɔso ne, makpakpasera abɔra ana wa lobua aba ɔrɔrã fiɛ manyi wã siwɛ̃ mamatãra i ɔkolo iso mapia i ndu karɔ̃ sɔ si matindza ɔkolo maɣedza. Mawe i ɔriinyɔ ame teteree sɔ kaɖe si kasɛ̃ mala. ");
INSERT INTO akp_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Gɔ ɔkolo ame marabaradze ɔbie sɔ maatere maɣɛ bo ɔso ne, mabara lɛ abɔra wa nsɛ amɔɛ̃ ɔkolo ala maakpasera mapia i ndu ame i ɔkolo katɔ̃. ");
INSERT INTO akp_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ɣɛɛ ne, Paulo ɔɣere makpakpɛ̃dze gu tɔ̃ɖedze sɔ, “Si mmagbe iiwe i ɔkolo ame ne, mito miawɔ.” ");
INSERT INTO akp_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ne ɔso makpakpɛ̃dze ɔtu ɔkolo kosoi gɔgbe siwɛ̃ dzɛ lomɔɛ̃ wũ manyua wũ mapia i ndu ame. ");
INSERT INTO akp_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ɔwi gɔ i kaɖe to kaba kaasɛ̃ ne, Paulo ɔtã ma ɔɖuɖu iti sɔ maɖe ara. Ɔɣere ma sɔ, “Ayi aweo-ana i ngbe gɔ bopia i itikpi nɛgbe ame fiɛ aɖera iipɛgu mi kuwɛ̃ kanya ne. ");
INSERT INTO akp_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ne ɔso loto mi i kukpa sɔ miɖe ara si miana ɔle fiɛ miibakpi. Alasɔ nane ɔnidzɔ iibasɛ i kuwɛ̃ iso.” ");
INSERT INTO akp_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Ne gɔ Paulo ɔsu ɔ̃ aɖera ne, ɔpɛ Ɣaa siba i wã iti i ma ɔɖuɖu katɔ̃, ne ɔkpɛti ɔɖe ne. ");
INSERT INTO akp_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ɔluwɛ̃ ne, ma ɔɖuɖu ɔna ɔtu, ne matsɛ ara iɖe ne. ");
INSERT INTO akp_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Mma mpia i ɔkolo ame aaɖe lɛ maturi alafa anyɔ gu sikɔdzɛ-ikuɔ. ");
INSERT INTO akp_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Ɔwi gɔ maro aɖera ɔɖe ne, maledza aɖera sikoto tsɔra dzɛ mpia i ɔkolo ame iɖi ifere i ndu ame si mabara ɔkolo foforofo. ");
INSERT INTO akp_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ɔwi gɔ i kaɖe ɔsɛ̃ waĩ ne, mainya ɔpo kanya ga iɖe maɖi ite. Ɣɛɛ manya kamabokɔ̃ kawɛ̃ i ɔkpokpo gɔ mabu sɔ mawo ɔbo. Ne ɔso mabie sɔ si maawo ne, maasu ɔkolo mabogu i ɔpo ɔkpokpo mmɔ. ");
INSERT INTO akp_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ne ɔso matu siwɛ̃ dzɛ lomɔɛ̃ abɔra wa manyi mamatãra i ɔkolo iso, fiɛ ka makurisi ɔdziri gɔ masɛ madzuɛ̃ ala ɔkolo makɛlɛgu ngbegɔ masɛ. Makɔlɛ ɔkolo sikati kato sɔ ɔwiri si ɔbo ɔkpadzɛ̃ ma ɔkɛlɛgu. ");
INSERT INTO akp_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Gɔ mato makɛlɛ katɔ̃ ne, ɔkolo katɔ̃ ɔsɛ iamɔrɛ̃ i iwarĩ ame sɔ ɔ̃isito ɔwo ɔsɛ. Ɔwiri gu ndu ɔba miabo wũ iso mibiɛbiɛ wũ buruburuburu. ");
INSERT INTO akp_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Gɔ makpakpɛ̃dze ɔbu sɔ mayorɛdze to maatere ma iso ɔso ne, mabie sɔ maaɖoe ma. ");
INSERT INTO akp_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ɣɛɛ gɔ ma tɔ̃ɖedze ɔbie sɔ ɔ̃afɔ Paulo ngbã ɔso ne, ɔ̃itɔrãgu ma. Ne ɔso ɔtã silɔ sɔ mma loawo ndu ɔɣa ɔbɔrɛ si makɔlɛ mabo i ndu ame si maɣa makɛlɛ ɔkpokpo. ");
INSERT INTO akp_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Mma ɔɖuɖu lokuti ana ne, mabie kukolo gu ara wa iso maasɛ mabo ɔkpokpo. Iki nnɛgbe ɔso ne, bo ɔɖuɖu ɔwo ɔkpokpo ɔbo sɔ kuwɛ̃ iikpi. ");
INSERT INTO akp_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Gɔ boso i ɔkpokpo ne, botsue sɔ karɔ̃ gamɔ marɔ sɔ Malta ne. ");
INSERT INTO akp_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Karɔ̃ gamɔ iso maturi ɔnyɔ bo nnya mafɔ bo kukaakɔ. Ɔyu pia fiɛ kado ana to ɔpɛ, ne ɔso mapia ɔtɔ i ɔpo kanya sɔ si boawa. ");
INSERT INTO akp_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Gɔ Paulo ɔsɛ ɔ̃ɔbodza kudzirikpai sɔ si ɔba ɔ̃asu ɔpia i ɔtɔ ame ne, aɣɛ lalaa ɔbɔrɛ amini wũ kɔrɔ̃ ala ɔtɔwiri ɔso. ");
INSERT INTO akp_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Gɔ karɔ̃ gamɔ iso maturi ɔnya ne, maɣɛ sɔ, “Turiɖoese ɔɖe ngbe gbaã! Atoa sɔ ɔtere ndu iwã ne, Ɣaa iibatã wũ ɔsɛ ngbã.” ");
INSERT INTO akp_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ɣɛɛ Paulo ɔkpa aɣɛ ɔsisi so i kɔrɔ̃ ɔpia i ɔtɔ ame, aibara wũ kuira. ");
INSERT INTO akp_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Karɔ̃ gamɔ maturi ɔbu sɔ Paulo aaɣe ɣee ɔ̃abɔrɛ ɔrɔ̃ ɔkpi. Ɣɛɛ gɔ ifɔ ɔwi fiɛ kuira iibara wũ ne, mafinikira ma adzuni sɔ kuɣɔ bowũ ɔɖe. ");
INSERT INTO akp_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Nkpɛkɔ̃ miwɛ̃ pia i ngbegɔ boba boaso gɔ miɖe karɔ̃ gamɔ ɔkpakpa gɔ marɔ Publio mire. Ɔkpakpa gɔgbe ɔfɔ bo ku isoɣɔ, ɔnyɔ bo iso akpɛnɛ atɛ ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ɔwi gɔmɔ ame ne, Publio ɔse to ɔnyɛ. Ɔ̃ iso ɔbe ɔtɔ fiɛ ɔto ɔfedza kayiri ana. Gɔ Paulo ɔkɛlɛ ɔ̃ kɔrɛ fiɛ ɔkparama kayi ɔtã wũ ɔsu nrɔɔ̃ ɔsia wũ iso ne, ɔsarɛ ɔluwɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Gɔ manɔ ɔ̃ isosarɛ nɛgbe ne, manyɛse ma mpia i karɔ̃ gamɔ ɔɖuɖu iso ɔba Paulo kɔrɛ, ne ɔsa ma ne. ");
INSERT INTO akp_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ara wagbe ɔso ne, matã bo karatã gbodzoo fiɛ gɔ ɔwi ɔɣo sɔ boarui i mmɔ ne, masu ara wa ɔɖuɖu boala i ɔri matã bo. ");
INSERT INTO akp_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Bowe i mmɔ awa atɛ fiɛ borui. Bo irui ame ne, bosɛ i ɔkolo gɔ marɔ sɔ Inyɔ Aɣɔ gɔ lobɔrɛ i Aleksandria fiɛ ɔya i karɔ̃ gamɔ iso ku ɔyu ɔwi. ");
INSERT INTO akp_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Gɔ bota i mmɔ ne, ɔmagɛ̃ siare gɔ bosɛ boatui nɖe Sirakusa. Bowe i mmɔ ana ayi atɛ. ");
INSERT INTO akp_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Gɔ borui i mmɔ ne, bosɛ boabo Regio. Ne kaɖesɛ̃a ne, ɔwiri sɛɛ ɔfuri ɔbɔrɛ i bo kama gɔ lobuai bo fiɛ ɔsu bo ɔsɛ ɔ̃ɔbo Puteoli ku iyi nyɔare iso. ");
INSERT INTO akp_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Mmɔ iɖe bosɛ boanya mafɔɖedze mawɛ̃ fiɛ matã iti sɔ bowe i ma kɔrɛ ayi akɔdzɛ ne. Gɔ bota i ngbe kama ne, bosɛ boabo Roma. ");
INSERT INTO akp_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Gɔ manyii ma mpia i Roma ana ɔnɔ sɔ bosɛ i ɔri boto boba ne, ma mawɛ̃ ɔba masarɛgu bo i Apia Kuɣa ame. Mawɛ̃ ana ɔba maatu bo i ngbegɔ marɔ Mafɔ Kubokɔ̃ Kutɛ. Gɔ Paulo ɔnya ma ne, ɔpɛ Ɣaa siba fiɛ ɔna katere ana ɔbua. ");
INSERT INTO akp_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Gɔ bosɛ boabo Roma ne, maɖi Paulo ɔri sɔ ɔsɛgu so i ngbegɔ ɔɖɔɛ. Matã sɔ kpakpɛ̃dze ɔwɛ̃ si ɔla ɔ̃ɔdzuɛ̃ wũ. ");
INSERT INTO akp_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ayi atɛ kama ne, Paulo ɔkpere ma Yudase matɔ̃ɖedze ma ɔɖuɖu mpia i mmɔ ɔsirakanya. Gɔ masarɛ ne, ɔɣere ma sɔ, “Manyii, mamɔɛ̃ me i Yerusalem masu matã ma Romase abã sɔ maɣɛgu me atɔ̃me atoa sɔ loiɣɛrɛ bo maturi ɣee bo mawa kubarara kukuwɛ̃. ");
INSERT INTO akp_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ma Romase ɔɣɛgu me atɔ̃me fiɛ mabie sɔ si manyua me. Alasɔ mainya nnɛ iso maaya fiɛ maaɖoe me lɛ kumɛgɔ i ma Yudase matɔ̃ɖedze ma lomɔɛ̃ me ɔbie. ");
INSERT INTO akp_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ɣɛɛ gɔ ma Yudase ɔta maya ne iso ɔso ne, itã sɔ loɣere ma sɔ loasu wũ itɔ̃me lokɛlɛgu Igarakpakpa Kaisaro katɔ̃. Iiɖe sɔ lobie sɔ loaɖaɛ wũ aɖe maturi kanya. ");
INSERT INTO akp_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Nnɛgbe ɔso lokpere mi si botsue so loɖegu mi ika ne. Ngɔ i Israel kaɖe to manyɔ ɔri ne, ɔ̃ ɔso fiɛ mapia me kugbagɔrɔĩ mito minya me ngbɔ ne.” ");
INSERT INTO akp_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ne maɣere wũ sɔ, “Bo ne, boinɔ kuira i fɔ iso. Boifɔ ɔko kuwɛ̃ ɣee kanya nyanyarĩa i fɔ iso ibɔrɛ i manyii ma lobɔrɛ i Yudea kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ɣɛɛ bobie sɔ boanɔ ira bosegu i fɔ kafɔkaɖe iso. Alasɔ gbaã ne, maito maɣɛ ira sɛɛ i ikuri nɛgbe iso i kukakɔi.” ");
INSERT INTO akp_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Gɔ masɛ iyi ne, maturi gbodzoo ɔba ɔ̃ kɔrɛ. Mmɔ ka ɔɣere ma Ɣaa sigarakaɖekɔ̃ iso itɔ̃me. Ɔkɔ ma adzuni ɔkɛlɛgu ngbegɔ i Mose gu Ɣaa kanyamaɖidze ɔtsɛrɛ ara masɛ i Yesu iso. Ɔɖe ma ika ita i kaya isɛ iabo kutsuɛ. ");
INSERT INTO akp_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ma ndɛ̃ mawɛ̃ ɔfɔ wũ maɖe, ɣɛɛ ma mawɛ̃ ana iifɔ wũ maɖe. ");
INSERT INTO akp_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Kakpadzɛ̃ ɔbo i ma ndɛ̃ fiɛ matsɛ irui gɔ Paulo ɔɣɛ atɔ̃me tsɔra wagbe sɔ, “Gbagbaã iɖe i Siwarã Bielea ɔki i Yesaya iso siɣere bo mawa sɔ, ");
INSERT INTO akp_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Kɛlɛ aaɣere ma Yudase sɔ, “Mianɔ ɣɛɛ miibanɔ karɔ̃, mito mianya ɣɛɛ miibanya miɖi ite.” ");
INSERT INTO akp_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Alasɔ mmagbe situ ɔsɛ̃, fiɛ ma atsue ana ba ɔle, fiɛ mama anɔmi ana. Si iiɖe ngbɔ ne, tee ma anɔmi aanya ara, fiɛ ma atsue ana aanɔ, fiɛ ma situ ana aanɔ ara karɔ̃ iyɔ maɔfiniki maba wũ kɔrɛ fiɛ mme, Ɣaa, loasa ma.’ ” ");
INSERT INTO akp_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","Ne Paulo ɔtsɔra ma ɔɣere sɔ, “Mitsue sɔ, itɔ̃me nɛ i Ɣaa sɔ ɔ̃asu ɔɖi ala maturi ne, maɔsu ne makɛlɛgu mma loiɖe ma Yudase. Ma ne, mato maafɔ ne!” ");
INSERT INTO akp_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paulo ɔwe i mmɔ akɔ anyɔ i iyo nɛ ɔfɔ ɔto ɔtã kuso ame ɔla ɔ̃ɔfɔ maturi ma ɔɖuɖu nsɛ maba ɔ̃ kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ɔɣere ma Ɣaa sigarakaɖekɔ̃ iso itɔ̃me ku katetere, ɔte ma ara i Yesu Kristo iso, fiɛ kuwɛ̃ iitɛ̃ wũ ɔri. ");
INSERT INTO akp_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Mme Paulo gɔ nɖe Yesu Kristo ɔsande gu katɔ̃mesɛdze gɔ i Ɣaa ɔɖi sɔ lopɛ ɔ̃ Itɔ̃me Bielea imomo ne, mme lotsɛrɛ ɔko gɔgbe ne. ");
INSERT INTO akp_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Itɔ̃me Bielea nɛ i Ɣaa ɔki i ɔ̃ kanyamaɖidze iso ɔɣɛ ɔsɛ sɔ ɔ̃aɖi ɔte ne, matsɛrɛ mapia i Ɔko Sekelea ame. ");
INSERT INTO akp_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Itɔ̃me nɛgbe ɔse i Ɣaa Ɔbi gɔ nɖe Bosate Yesu Kristo iso. Maɣe wũ lɛ ɔturi awune awe i David ɔɣekparɛ ame. ");
INSERT INTO akp_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Iki i Ɣaa Siwarã iso ne, Ɣaa ɔɖi wũ ɔte maturi ku ɔle gɔ ɔtara wũ ɔbɔrɛgu i makpise ame. ");
INSERT INTO akp_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Fiɛ iki i ɔ̃ iso ne, Ɣaa ɔnyɔ bo nnya ɔsu bo ɔbara katɔ̃memasɛdze ɔtã Kristo sɔ boatã abuiti ɔɖuɖu maturi afɔ wũ maɖe, matsue ɔ̃ kuɖɔɛ. ");
INSERT INTO akp_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Mi wũ ne, Ɣaa ɔɖi mi ɔbua i mma nɖe Yesu Kristo mare iso. ");
INSERT INTO akp_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Nnɛgbe ɔso nto lotsɛrɛ ɔko gɔgbe lotã mi ma ɔɖuɖu mpia i Roma alasɔ Ɣaa to ɔɖɔɛ mi fiɛ ɔkpere mi sɔ miakpese ɔ̃ mare. Bo Ɔse Ɣaa gu Bosate Yesu Kristo si matã mi abualɛra gu isobuɛ. ");
INSERT INTO akp_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Lobie sɔ loaki i Yesu Kristo iso lopɛ wũ Ɣaa siba i mi ɔɖuɖu kanya alasɔ kayiiso maturi ɔɖuɖu ɔɔnɔ kumɛgɔ mifɔ Kristo miɖe. ");
INSERT INTO akp_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Ɣaa gɔ karabara nto lobara ku wũ ɔtu ɔɖuɖu iki ɔ̃ Itɔ̃me nɛ loto loɣɛ i ɔ̃ Ɔbi iso ne, ɔɣe sɔ loisɛ loɣara mi ku ɔwi kuwɛ̃ si loto lokparama kayi. Ɣaa ɖe me aɖansiɛ sɔ nnɛ loto loɣɛ ne, gbaã iɖe. ");
INSERT INTO akp_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Ɔwi biara nto lokparama kayi ne, nsɛ lotã Ɣaa iti sɔ si iɖe ɔ̃ kuɖɔɛ ne, ɔtã me ɔri sɔ loaba loanya mi. ");
INSERT INTO akp_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Anɔ ɔrɛtɛ me gbaã sɔ loaba loanya mi fiɛ loabuai mi i Ɣaa nnyainyɔ ame sɔ miana ɔle i siwarã ame. ");
INSERT INTO akp_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Nto lobie teteree sɔ loapia mi ɔle i mi kafɔkaɖe ame fiɛ mi wũ miapia me ɔle iyɔ bo aka wã anyɔɔ aaɖe ibuai botã so. ");
INSERT INTO akp_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Wũ manyii, miɣe sɔ loɔbara adzuni ɔwi gbodzoo ame sɔ si loba mi kɔrɛ, ɣɛɛ ara awɛ̃ ɔtɛ̃ me ɔri. Lobie sɔ loabuai maturi i mi ndɛ̃ makpese Kristo mare lɛ kumɛgɔ loɔbara i mma loiɖe ma Yudase ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Karabara gagbe nɖe kuso gɔ loto maturi ɔɖuɖu, mma anɔ lobusi gu mapoamese, manɔgbadze gu madzimifɔ ne. ");
INSERT INTO akp_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Nnɛgbe ɔso i wũ anɔ ɔrɛtɛ gbaã sɔ loaɣere mi ma mpia i Roma ana Itɔ̃me Bielea nɛgbe ne. ");
INSERT INTO akp_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Itɔ̃me Bielea nɛgbe iisɛ ikpɛ̃ me kunuarɛ alasɔ ne nɖe Ɣaa ɔle gɔ nsɛ ɔtã ɔturi biara gɔ lofɔ ɔɖe ɔna ngbã ne. Ma Yudase tɔtɔ gu mma loiɖe ma Yudase ana. ");
INSERT INTO akp_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Itɔ̃me Bielea nɛgbe sɛ iɖi ɔri gɔ iso i Ɣaa sɛ ɔnyɔ ɔturi sɔ ɔse bɔlɔlɔ ite. Ɔri sɛɛ gɔgbe ɔɖe ika ɔsegu i kafɔkaɖe itɔ̃me iso ita i karɔ̃kasɛkɔ̃ isɛ iabo kawirikɔ̃. Lɛ kumɛgɔ matsɛrɛ masɛ i Ɔko Sekelea ame sɔ, “Ngɔ nse bɔlɔlɔ to ɔ̃asɛ i kafɔkaɖe ame.” ");
INSERT INTO akp_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Ɣaa ɔɖi ɔ̃ sikpã kayi ɔbɔrɛgu i kato i ara wa lota aɣɛ wũ iso gu ɔtile ara wa nto atɛ̃ maturi ɔri sɔ maibatsue Ɣaa Itɔ̃me Bielea nɛgbe. ");
INSERT INTO akp_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Sikpã to wũ alasɔ maturi ɔɔnya Ɣaa kurabarara gɔ ɔ̃ mɔmɔ ɔbara sekelee. Ɣaa mɔmɔ ɔɖi ɔte ma kukaakɔ. ");
INSERT INTO akp_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Alasɔ ita i ɔwi gɔ ɔbara kayi ne, ɔ̃ ɔle gɔ nna katui gu ɔ̃ Ɣaa iɖe ɔɔɖi so ite i ara wa ɔɖuɖu ɔbara ɔpia i kayiiso ame. Ne ɔso ɔturi awune iisibawo ɔɣɛ sɔ ɔ̃ifɔ Ɣaa ɔɖe. ");
INSERT INTO akp_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Alasɔ atoa sɔ maturi ɣe Ɣaa ne, maisɛ mata wũ kuwarɛ gɔ lokotegu wũ lɛ Ɣaa, fiɛ maisɛ mapɛ wũ siba ana. Ɣɛɛ masɛ makɔlɛ so kato i ma adzuni ame mabara adzimira, idududu si ma iso. ");
INSERT INTO akp_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Masɛ manyɔ so sɔ makpa anɔ ɣɛɛ makpesera so madzimifɔ. ");
INSERT INTO akp_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Masɛ̃ sɔ maibasumu Ɣaa gɔ mpia ngbã ɔwi biara, mapia male ara mama wa loakpi. Masu ara lɛ maturi, ɣee kurodzai, ɣee mabɔi, ɣee ara wa nsɛ akpɛ̃ i karɔ̃ lɛ maɣɛ masu makpesera aɣɔ matã so. ");
INSERT INTO akp_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Ne ɔso ne, Ɣaa ɔnyua ma ɔtã sɔ mabara ɔnɔle ara wa loatã sɔ maapukutura so. Masɛ mabara anuarɛra i ma ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Manyuarã Ɣaa Itɔ̃me Bielea ku sila ire fiɛ mato masɔrɛ ara wa i Ɣaa ɔbara. Ɣɛɛ ne, Ɣaa ikote sɔ mafɛ̃ ara matã alasɔ ɔ̃ i ile gu ibu ɔkote itã ɔwi ɖaa. Si iba ngbɔ! ");
INSERT INTO akp_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Ara wagbe ɔso ne, Ɣaa ɔnyua maturi ɔtã sɔ mabara ara wa loakpɛ̃ ma kunuarɛ. Itã sɔ ma marɔ̃go to marɛgu so lɛ marɛrɛ̃ gu marɔ̃go awe. ");
INSERT INTO akp_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ngbɔ ame ana i marɛrɛ̃ ana ɔnyua marɔ̃go masɛ mato mabara anuarɛra marɛgu ma marɛrɛ̃ laa lɛ ɔrã gu ɔre awe ne. Nnɛgbe ɔso ne, Ɣaa kutsue ikpadzɛ̃ nɛ loba ma iso ɔkotegu ma ngbã nyanyarĩa. ");
INSERT INTO akp_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Gɔ masɛ̃ sɔ maibasuã ara wa maɣe ɔso ne, Ɣaa ɔnyua ma ɔtã ɔtile ɔbo i ma adzuni ame. Masɛ mabara ara wa loikote sɔ maabara. ");
INSERT INTO akp_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Ɔtile ara wa masɛ mabara ɔɔfɔ ma ima. Wã awɛ̃ nɖe, wũ ɔnɔwɛ̃ saã ɔkpɛ, silalaa, ma anɔ sɛ arɛtɛ i maturi ara iso, ituriɖoe, kulu, mila gu manyii ndɛ̃ inina. Masɛ matsiri maturi, maɣɛ maturi iso ara. ");
INSERT INTO akp_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Masɛ maɣɛ maturi iso ara nyanyarĩa. Maɖe maturi ma loisɛ maɖɔɛ Ɣaa. Masɛ matia ma manyii, maɖi ma malaa matã, makɔlɛ so kato, manyɔnyɔ siri ɣɛtɛ dzɛ iso maaki maabara ara nyanyarĩa. Maisɛ mawarɛ ma maɣese. ");
INSERT INTO akp_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Maɖe maturi ma loiɣe ikpaki i isɛɛ gu ilalaa ndɛ̃. Maisɛ mamɔɛ̃ ma mɔmɔ itɔ̃me nɛ maɣɛ mala. Kuira iisɛ iɖo ma kayiri, fiɛ maisɛ manyɔ ɔturi nnya. ");
INSERT INTO akp_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Maɣe sɔ Ɣaa ɔtã bo mmara sɔ mma nsi ngbã mɛgbe igbã ne, ɔto ɔ̃akpadzɛ̃ ma kutsue, ɣɛɛ ne, maɣɛ teteree i ara nyanyarĩa wagbe ame. Iiɖe sɔ nnɛgbe kere, ɣɛɛ masɛ mawarɛ mma nsɛ mabara wã ana. ");
INSERT INTO akp_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ne ɔso fɔ gɔ fɔ nto aɣɛgu ɔturi atɔ̃me fiɛ ato atã wũ ipɔ ne, aisibawo so kanya ɔɖi. I ɔri biara gɔ iso atã fɔ ɔlaa ipɔ ne, tsue sɔ fɔ mɔmɔ fɔ wũ aɖe ipɔ. Alasɔ ara wa ɔto ɔbara ne, wã ame igbã tutuutu fɔ̃ wũ ato abara ne. ");
INSERT INTO akp_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Bo ɔɖuɖu ɣe sɔ Ɣaa ɔnɔwɛ̃ saã mba ɔri sɔ ɔ̃aɣɛgu maturi ma nsɛ mabara ara wagbe atɔ̃me. ");
INSERT INTO akp_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Si fɔ lɛ ɔturi awune gɔ nsɛ ɔbara ara wagbe igbã to atã maturi mama ipɔ ne, afɔ aɖe sɔ aawo Ɣaa atɔ̃me iɣɛgu ɔtere? ");
INSERT INTO akp_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ɛɛbɛrɛ afɔ aɖe sɔ siefe kere iɖe i Ɣaa to ɔnyɔ bo nnya fiɛ ɔɣɔra so ɔtã bo? Mitsue sɔ Ɣaa to ɔbara bo kayiribielea gagbe alasɔ ɔto ɔbie sɔ ɔ̃abuai bo sɔ boafiniki i bo situ ame. ");
INSERT INTO akp_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Gɔ mi atsue ba ɔle fiɛ misɛ̃ sɔ miibafiniki i situ ame ɔso ne, Ɣaa to ɔ̃akpadzɛ̃ mi kutsue gbaã ku iyi nɛ ɔɣɛ sɔ ɔ̃aɣɛgu kayiiso maturi ɔɖuɖu atɔ̃me i ɔ̃ ɔri bɔlɔlɔa iso. ");
INSERT INTO akp_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Fiɛ Ɣaa to ɔ̃atã ɔbiara kuso i ɔ̃ kurabarara gɔ ɔbara iso. ");
INSERT INTO akp_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Mma lopia kubɛ i ara sɛɛ ibara ame fiɛ masiai ikpawaĩ i ngbã mɛgbe ame ne, ngbã mɛ nto miba ame ne, Ɣaa to ɔ̃atã mana ngbã mɛ loisɛ miro. ");
INSERT INTO akp_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ɣɛɛ maturi ma nsɛ mabie ma ɔnɔwɛ̃ ire fiɛ masɛ̃ Itɔ̃me Bielea nɛgbe fiɛ masiai ngbã nyanyarĩa ne, Ɣaa sikpã to siaba ma iso fiɛ ɔ̃akpadzɛ̃ ma kutsue gbaã. ");
INSERT INTO akp_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Mma ɔɖuɖu nsɛ mabara ara lalaa ne, mato maana inyɛwe fiɛ maibana iwarã kuiwɛ̃. Ma Yudase loaɖe katɔ̃ mafɔ kutsue ikpadzɛ̃ fiɛ mma loiɖe ma Yudase asiai. ");
INSERT INTO akp_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ɣɛɛ mma nsɛ mabara ara sɛɛ ne, Ɣaa to ɔ̃atã ma kuwarɛ, ɔtara ma anɔ kato ku isobuɛ. Ma Yudase loaɖe katɔ̃ mafɔ ara wagbe iyɔ mma loiɖe ma Yudase ɔsiai. ");
INSERT INTO akp_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Alasɔ Ɣaa iisɛ ɔnyɔ ɔturi i katɔ̃ i atɔ̃me iɣɛ ame. ");
INSERT INTO akp_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Mma ɔɖuɖu lobara ikpi fiɛ maiɣe Mose mmara ne, mato maawɔ. Ɣɛɛ Ɣaa iibasu mmara ɔɣɛgu ma atɔ̃me. Mma mpia i Mose mmara kayirinɔ ne, si mabara ikpi ne, mmara mɛmɔ iso i Ɣaa aaɣɛgu ma atɔ̃me. ");
INSERT INTO akp_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Alasɔ iiɖe mma nto manɔ nnɛ i mmara to miɣɛ nɖe maturi sɛɛ i Ɣaa anɔ. Ɣɛɛ mma nto mabara i nnɛ miɣɛ iso nɖe maturi sɛɛ. ");
INSERT INTO akp_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Gbaã ne, mma loiɖe ma Yudase ne, maiɣe Mose mmara. Ɣɛɛ si i ma situ ame matsue ara wa mite ne, iyɔ ma kurabarara ɔɔte sɔ maba mmara i ma situ ame atoa sɔ mainɔ mmara mɛgbe iso itɔ̃me manɔ. ");
INSERT INTO akp_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Nnɛgbe to ite sɔ Ɣaa ɔsu ara wa mpia i Mose mmara ame ɔpia i ma situ ame. Fiɛ ma situ ana ɔte ma sɔ gbaã ne, ngbɔ iɖe alasɔ ma kaɣere sɛ katã ma ipɔ si mabara ikpi fiɛ kasɛ katã ma ibɛ si mabara isɛɛ ana. ");
INSERT INTO akp_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Itɔ̃me Bielea nɛ loto loɣɛ ɔte sɔ iyi iwɛ̃ ne, Ɣaa to ɔ̃atã Yesu Kristo ɔɣɛgu maturi atɔ̃me i ara wa mabara mawɛrɛ i ma adzuni ɔɖuɖu ame iso. ");
INSERT INTO akp_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Fiɛ fɔ gɔ fɔ nsɛ aɣɛ sɔ ɔ Yudase aɖe ne, asu so asia i Mose mmara iso fiɛ asɛ akɔlɛ so kato sɔ Ɣaa ɔre aɖe. ");
INSERT INTO akp_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Asɛ aɣɛ ana sɔ aɣe ara wa loabo Ɣaa anɔ, aɣe ira sɛɛ gu ilalaa alasɔ asuã ara sɛɛ i ara wa matsɛrɛ masɛ ame. ");
INSERT INTO akp_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Afɔ so aɖe sɔ aɖe manɔbiɛdze kɔdze fiɛ aɖe ɔkaniɛ atã mma mpia i idududu ame. ");
INSERT INTO akp_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Asɛ aɣɛ sɔ asɛ aka madzimifɔ fiɛ asɛ ate mabiɛtɛ ara. Afɔ aɖe gbaã sɔ Ɣaa mmara ame ne, fɔ inɔgba ɔyi pɔpɔɔpɔ. ");
INSERT INTO akp_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Ɣɛɛ fɔ gɔ fɔ nsɛ ate maturi mama ara ne, aisɛ ate so ara wamɔ? Asɛ aɣere maturi Ɣaa Itɔ̃me sɔ madaayu kayu, ɣɛɛ fɔ mɔmɔ ato ayu kayu? ");
INSERT INTO akp_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Asɛ aɣere maturi sɔ madaabara asɔrɔ̃ra ɣɛɛ fɔ asɛ aɖe asɔrɔ̃? Asɛ ata aya i aɣɔ kasumu iso gbaã, ɣɛɛ asɛ ayu ara i aɣɔ ayo? ");
INSERT INTO akp_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Asɛ akɔlɛ so kato sɔ aɣe Ɣaa mmara, ɣɛɛ ato apia Ɣaa kunuarɛ alasɔ aisɛ abara i ɔ̃ mmara iso. ");
INSERT INTO akp_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","I Ɔko Sekelea ame ne, matsɛrɛ masɛ sɔ, “Mi ma Yudase nsɛgbai nyanyarĩa ɔso ne, mma loiɖe ma Yudase sɛ marɔ Ɣaa iyere lalaa.” ");
INSERT INTO akp_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Si asɛ abara i mmara iso ne, iyɔ fɔ sirɛrɛ̃ itu ɖe ira nɛ mba kusia. Ɣɛɛ si aisɛ abara i me iso ne, iyɔ fɔ sirɛrɛ̃ itu na karɔ̃. ");
INSERT INTO akp_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Si ngɔ loiɖe ɔ Yudase fiɛ ɔ̃itu sirɛrɛ̃ ɔbara i mmara iso ne, Ɣaa sɛ ɔnyɔ wũ lɛ ngɔ lotu sirɛrɛ̃. ");
INSERT INTO akp_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ngɔ lobara i mmara iso ɣɛɛ ɔ̃itu sirɛrɛ̃ ne, ɔto ɔ̃atã-ɔ ipɔ sɔ fɔ gɔ matã mmara fiɛ atu sirɛrɛ̃ ne, aibara i me iso. ");
INSERT INTO akp_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Iiɖe siturina iso boanya ɔ Yudase mɔmɔ. Sirɛrɛ̃ itu mɔmɔ ne, iiɖe sosina ame karabara ga i maturi aanyɔ kere iɖe. ");
INSERT INTO akp_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Ɣɛɛ ngɔ nɖe ɔ Yudase mɔmɔ nɖe ngɔ nsɛ ɔte i ɔ̃ kurabarara ame sɔ ɔɔsu ɔ̃ ɔtu ɔtã Ɣaa. Iiɖe siturina dzɛ matu i mmara kanya iɖe lonya, ɣɛɛ nnɛ mabara i Ɣaa Siwarã ame. Iiɖe kuwɛ̃ nsɛ ɔkɔlɛ ɔturi iyere kato ɣɛɛ Ɣaa nsɛ ɔbara. ");
INSERT INTO akp_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Si ise ngbɔ ne, iyɔ mme kusia i ɔ Yudase gɔ lotu sirɛrɛ̃ ba ɔɖo mma loiɖe ma Yudase? ");
INSERT INTO akp_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","I siri gbodzoo iso ne, kusia titiiti pia alasɔ ma Yudase nrɔɔ̃ ame i Ɣaa ɔsu ɔ̃ kaɖikate sekelea ga matsɛrɛ masɛ ɔpia. ");
INSERT INTO akp_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ɣɛɛ si iba sɔ ma mawɛ̃ iifɔ maɖe ne, iatã sɔ Ɣaa iibabara i ɔ̃ nnɛ ɔɣɛ ɔsɛ iso? ");
INSERT INTO akp_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ooɣo! Si ɔturi biara ɖe ladze kɔra ne, tsue sɔ Ɣaa sɛ ɔbara i ɔ̃ itɔ̃me iso. Lɛ kumɛgɔ matsɛrɛ mapia i Ɔko Sekelea ame sɔ, “Ira biara ɔte sɔ fɔ kanya ame atɔ̃me ne, atɔ̃me gbaã aɖe. Fiɛ aaɖe maturi ɔɖuɖu ibɛ si maɣɛgu-ɔ atɔ̃me.” ");
INSERT INTO akp_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Si bo nsɛgbai nyanyarĩa sɛ miɖi mite sɔ Ɣaa ɔkpɛ ɔya ne, boawo ɔɣɛ sɔ Ɣaa ɔbara ikpi si ɔkpadzɛ̃ bo kutsue? Kuɣɛme ne, ilɛ si boɣɛ ngbɔ? ");
INSERT INTO akp_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Ooɣo! Si Ɣaa iise bɔlɔlɔ ne, be iso ɔ̃aya fiɛ ɔ̃aɣɛgu kayiiso maturi ɔɖuɖu atɔ̃me? ");
INSERT INTO akp_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Maturi mawɛ̃ sɛ makarɛ sɔ, “Si wũ sila ila sɛ iɖi Ɣaa ɔnukuare ite sekelee itã sɔ maale wũ ne, be ɔso fiɛ mato makpere me kpibaradze?” ");
INSERT INTO akp_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Si ise ngbɔ ne, be ɔso boibakɛlɛ i katɔ̃ bobara ikpi sɔ si isɛɛ aabɔrɛ i ne ame? Mawɛ̃ to mala sila sɔ ngbɔ boto bote ne. Loito lote ngbɔ ne ɔso mma nto maɣɛ ngbɔ ne, Ɣaa to ɔ̃atã ma ipɔ. ");
INSERT INTO akp_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Kiniɔ ne, be boaɣɛ i bo ma Yudase iso? Boba kayakpa sɛɛ boɖo mma loiɖe ma Yudase? Ooɣo! Alasɔ loɔɖi lote koko sɔ ikpi ɔɖe ma Yudase gu mma loiɖe ma Yudase ɔɖuɖu iso. ");
INSERT INTO akp_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Alasɔ ngbɔ matsɛrɛ i ngɔi miwɛ̃ i Ɔko Sekelea ame sɔ, “Ɔturi kuwɛ̃ iise bɔlɔlɔ i Ɣaa anɔ. Ooɣo, kuwɛ̃ na! ");
INSERT INTO akp_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ɔturi kuwɛ̃ na gɔ ɔto ɔnya ira sɛɛ ɔɖi ite. Kuwɛ̃ ana na gɔ ɔto ɔnyɔnyɔ Ɣaa ɔri.” ");
INSERT INTO akp_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Matsɛrɛ ana sɔ, “Maturi ɔɖuɖu ɔkora kama matã Ɣaa fiɛ ma ɔɖuɖu ɔɣɛrɛ. Kuwɛ̃ na gɔ ɔto ɔbara isɛɛ, kuwɛ̃ kere!” ");
INSERT INTO akp_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Matsɛrɛ ana sɔ, “Ma nnya se lɛ ikpibiɔ nɛ lowarɛ ise. Ma sinyagɛmi ɔta siɣɛ ala mila ɔso. Fiɛ maɣɛ kabiɛtɛ pia ma i kanya.” ");
INSERT INTO akp_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Maɣɛ ana sɔ, “Sigbarĩ dzɛ loaɖoe maturi ɔyi ma i kanya.” ");
INSERT INTO akp_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Matsɛrɛ i kakɔi mama sɔ, “Ma ngba sɛ mita malamala i ituriɖoe iso. ");
INSERT INTO akp_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Situ ibiɛ gu inyɛwe masɛ manyua masɛ i kakɔi biara. ");
INSERT INTO akp_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Maiɣe kuira i isobuɛ ngbã iso.” ");
INSERT INTO akp_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Matsɛrɛ ana sɔ, “Ma nsɛgbai ana ɔte sɔ mana Ɣaa kunigã.” ");
INSERT INTO akp_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Kiniɔ ne, boɣe sɔ ara wa ɔɖuɖu maɣɛ masɛ i Mose mmara ɔko ame ɔmɔɛ̃ maturi ma mpia i mmara kayirinɔ sɔ kayiiso ɔturi kuwɛ̃ iibaɖe Ɣaa ibɛ. Alasɔ Ɣaa to ɔ̃aɣɛgu kayiiso ɔɖuɖu atɔ̃me. ");
INSERT INTO akp_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Ne ɔso ne, mmara isiai iibabara kuwɛ̃ bɔlɔlɔ i Ɣaa katɔ̃. Ɣɛɛ ne, misɛ mitã maturi ɔtsue sɔ makpibaradze maɖe. ");
INSERT INTO akp_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ɣɛɛ ɔri gɔ i Ɣaa ɔɖi ɔte sɔ ɔ̃ iso i maturi aki fiɛ maase bɔlɔlɔ ne, iiɖe mmara iso ibara. Mmara mɔmɔ gu kanyamaɖidze ɔɖi ara wagbe mate sekelee. ");
INSERT INTO akp_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Ɣaa sɛ ɔtã maturi ɔse bɔlɔlɔ si mafɔ Kristo maɖe. Fiɛ ɔ̃isɛ ɔpia ikpaki i ma ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Maturi ɔɖuɖu ɔbara ikpi. Ne ɔso maikote sɔ maabore mabo ɔ̃ ikpawaĩ. ");
INSERT INTO akp_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Ɣɛɛ ne, Ɣaa ɔki i Kristo Yesu iso ɔtã kuso i bo iti. Ɔbara bo sɔ boase bɔlɔlɔ ala ɔ̃ nnyainyɔ ɔso. ");
INSERT INTO akp_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Ɣaa ɔsu Yesu ɔtã ala bo ikpi iti. Fiɛ iki i ɔ̃ ima nɛ ɔfere i karɔ̃ ɔso ne, maturi ɔna kasukatsɛ si mafɔ Kristo maɖe. Ɣaa ɔbara nnɛgbe ɔte bo sɔ ɔsɛ ɔbara ɔ̃ ara ɔɖuɖu i sibɔlɔlɔ ɔri iso. Ɔna ɔtu ku ɔwi gɔ lofe ame gɔ ɔ̃ikpadzɛ̃ bo kutsue gɔ bobara ikpi. ");
INSERT INTO akp_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Ɔbara ngbɔ si ɔsu ɔte, sɔ ɔsɛ ɔbara ɔ̃ ira biara i ɔri bɔlɔlɔa iso fiɛ ɔsɛ ɔbara mma ɔɖuɖu lofɔ Yesu maɖe bɔlɔlɔ. ");
INSERT INTO akp_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Be iso boawo ɔya ɔtui kɔrɔ̃ i kagbegbe sɔ ne bobara fiɛ bona iɖi? Kuira na! Alasɔ ɔturi iisɛ ɔse bɔlɔlɔ iki i mmara iso ibara ame ɣɛɛ kafɔkaɖe ame. ");
INSERT INTO akp_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Alasɔ boɣe kukaakɔ sɔ kafɔkaɖe kotoo ame i ɔturi aase bɔlɔlɔ i Ɣaa anɔ fiɛ iiɖe mmara iso ibara ame. ");
INSERT INTO akp_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ɛɛbɛrɛ Ɣaa ne, ma Yudase kere ɔre ɔɖe? Mma loiɖe ma Yudase ana ne, iiɖe ma Ɣaa ɔɖe? Aĩ, ma wũ ma ɔre ɔɖe. ");
INSERT INTO akp_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Gɔ Ɣaa ɔwɛ̃ saã ɔɖe ɔso ne, ɔ̃ gɔ ame loabara ma Yudase bɔlɔlɔ iki kafɔkaɖe ame ne, ɔ̃ ame loabara mma loiɖe ma Yudase bɔlɔlɔ iki kafɔkaɖe ame ame ne. ");
INSERT INTO akp_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Nnɛgbe karɔ̃ ɣɛɛ? Ito ite sɔ boɔnyua mmara bosɛ i kuruɛ sɔ kafɔkaɖe si ka fɔ me kanya? Ooɣo! Ɣɛɛ ara wa i mmara ɔte boledza isɛra. ");
INSERT INTO akp_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Be nɖe nnɛ boawo ɔɣɛ sɔ bo ɔwa tɛtɛ Abraham ɔnya i Itɔ̃me nɛgbe iso? ");
INSERT INTO akp_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Si sɔ kurabarara iso iki fiɛ Ɣaa ɔnya Abraham sɔ ɔbɔlɔlɔ ne, iyɔ ɔba nnɛ iso ɔ̃aya ɔ̃aɖe ndamu. Ɣɛɛ ɔ̃ibawo ndamu ɔɖe i Ɣaa anɔ alasɔ iiɖe ɔ̃ kurabarara kuɖe ɔnyɔ. ");
INSERT INTO akp_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Ɔko Sekelea ɔɣɛ sɔ, “Abraham ɔfɔ Ɣaa ɔɖe ne ɔso Ɣaa ɔnyɔ wũ sɔ ɔse bɔlɔlɔ.” ");
INSERT INTO akp_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Ngɔ lobara karabara iisɛ ɔsu ɔ̃ kuso lɛ ira tsɛa, ɣɛɛ ɔsɛ ɔsu ɔ̃ kuso lɛ ira nɛ nɖe ɔ̃ karabara kusia. ");
INSERT INTO akp_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ɣɛɛ mma losu so masia i kafɔkaɖe iso fiɛ iiɖe ma kurabarara iso, mafɔ Ɣaa gɔ nsɛ ɔbara ɔturi bɔlɔlɔ maɖe ne, ma i Ɣaa sɛ ɔnyɔ sɔ mase bɔlɔlɔ ne. ");
INSERT INTO akp_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Igara David ɔɣɛ sɔ ɔturi gɔ i Ɣaa ɔnyɔ sɔ ɔse bɔlɔlɔ iiɖe ɔ̃ kurabarara ɔso ne, ɔ̃awe isoɣɔ gbaã. David ɔɣɛ sɔ, ");
INSERT INTO akp_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“So aaɣɔ mma ikpi i Ɣaa ɔsu ɔtsɛ fiɛ ɔ̃ibakpadzɛ̃ ma kutsue. ");
INSERT INTO akp_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","So aɣɔ ngɔ ikpi i Bosate ɔkpa ara ɔfu.” ");
INSERT INTO akp_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Isoɣɔ nɛ iso Itɔ̃me i David to ɔɣɛ ngbe ne, mma lotu sirɛrɛ̃ ire kere iɖe? Ooɣo! Mma ɔɖuɖu loitu sirɛrɛ̃ ana ire iɖe alasɔ Ɔko Sekelea ɔɣɛ sɔ, “Abraham ɔfɔ Ɣaa ɔɖe, ne ɔso Ɣaa ɔfɔ wũ sɔ ɔse bɔlɔlɔ.” ");
INSERT INTO akp_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Mme ɔwi iɖe i Ɣaa ɔfɔ wũ sɔ ɔse bɔlɔlɔ? Ɔwi gɔ ame ɔ̃itu sirɛrɛ̃ ɛɛbɛrɛ ɔwi gɔ ame ɔ̃ɔtu? Iiɖe ɔwi gɔ ɔ̃ɔtu sirɛrɛ̃, ɣɛɛ fiɛ ɔ̃atu. ");
INSERT INTO akp_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Sirɛrɛ̃ itu kubarara gɔ i Abraham ɔbara ne, ikparĩ kere iɖe nɛ lote sɔ Ɣaa ɔfɔ wũ. Alasɔ ɔ̃ kafɔkaɖe lotã sɔ Ɣaa ɔfɔ wũ sɔ ɔse bɔlɔlɔ fiɛ ɔ̃aba ɔ̃atu sirɛrɛ̃. Iki kafɔkaɖe ame ne, Abraham ɔkpese mafɔɖedze ɔɖuɖu ɔse. Ɣaa ɔki i Abraham iso ɔfɔ ma ɔɖuɖu sɔ mase bɔlɔlɔ atoa sɔ maitu sirɛrɛ̃. ");
INSERT INTO akp_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Abraham ɖe ɔse ɔtã mma lotu sirɛrɛ̃ ana. Ɣɛɛ iiɖe gɔ matu sirɛrɛ̃ ɔso, ɣɛɛ kumɛgɔ masɛ ngbã i kafɔkaɖe ame lɛ ma ɔse Abraham awe tɔtɔ fiɛ ɔ̃atu sirɛrɛ̃. ");
INSERT INTO akp_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Ɣaa ɔkã ndamu ɔtã Abraham gu ɔ̃ mawa tɛtɛ sɔ maaɖe kayiiso ɔɖuɖu ara. Iiɖe kumɛgɔ i Abraham gu ɔ̃ mawa ɔsiai Mmara kama ɔso fiɛ Ɣaa ɔkã ndamu mɛgbe. Ɣɛɛ ɔkã ndamu mɛgbe alasɔ ɔfɔ Abraham sɔ ɔse bɔlɔlɔ iki i ɔ̃ kafɔkaɖe ɔso. ");
INSERT INTO akp_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Si kayiiso ara iɖe ndamu mɛ i Ɣaa ɔkã ne mma lobara i mmara iso mire kere miɖe ne, iyɔ kafɔkaɖe ɖe siefe. Fiɛ iyɔ Ɣaa ndamu na kusia kukuwɛ̃. ");
INSERT INTO akp_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Alasɔ mmara sɛ miɖi Ɣaa sikpã mite bo, fiɛ si mina ne, me ita iya iso ana iisɛ iwe. ");
INSERT INTO akp_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Ne ɔso ndamu mɛgbe ne, kafɔkaɖe kama miɣɛ. Alasɔ iiɖe mma i Ɣaa ɔtã mmara ɔnɔwɛ̃ nɖe Abraham mawa. Ɣɛɛ mma losiai ɔ̃ kafɔkaɖe kama ana. Alasɔ Abraham nɖe mafɔɖedze ɔɖuɖu ɔse. ");
INSERT INTO akp_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Alasɔ ngbɔ i Ɔko Sekelea ɔɣɛ sɔ, “Loɔsu-ɔ lobara abuiti gbodzoo ɔse.” Ne ɔso ndamu mɛgbe ɔya i Ɣaa anɔ. Ɣaa gɔ i Abraham ɔfɔ ɔɖe ne, ɔ̃ nsɛ ɔtara makpise ɔbɔ ngbã ame, ɔkpere ara wa nna i kayi koko ɔbɔ kayi ne. ");
INSERT INTO akp_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Ɔwi gɔ i ɔriinyɔ na kɔra ne, Abraham ɔya i kafɔkaɖe ame teteree. Ɔfɔ ɔɖe sɔ ɔto ɔ̃akpese abuiti gbodzoo ɔse lɛ kumɛgɔ i Ɣaa ɔɣɛ i Ɔko Sekelea ame sɔ, “Fɔ ɔɣekparɛ to ɔ̃asi gbodzoo lɛ awãmi.” ");
INSERT INTO akp_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Abraham ɔɔfɔ lɛ akɔ kulafa, ɣɛɛ ne, nrɔɔ̃ ifɛfɛ̃ wũ i kafɔkaɖe ame atoa sɔ ɔnya sɔ ka ɔɣɛ i ikpibiɔ ɔkpokpo fiɛ Sara ana ɔɔfe ɔbi ɔɣewi. ");
INSERT INTO akp_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ara wagbe iifɛfɛ̃ wũ nrɔɔ̃ i kafɔkaɖe ame ɣɛɛ ɔmɔɛ̃ Ɣaa ndamu ɔla teteree fiɛ ɔ̃ kafɔkaɖe ana ɔwe ɔle kabua ɔsu ile ɔtã Ɣaa. ");
INSERT INTO akp_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Ɔtsue sekelee sɔ Ɣaa ba ɔle gɔ ɔ̃abara nnɛ ɔɣɛ ɔsɛ. ");
INSERT INTO akp_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Iki i kafɔkaɖe gagbe ɔso ne, Ɣaa ɔnyɔ wũ sɔ ɔse bɔlɔlɔ. ");
INSERT INTO akp_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Fiɛ iiɖe ɔ̃ ɔnɔwɛ̃ saã iso matsɛrɛ ara wagbe masɛ sɔ, “Ɣaa ɔnya wũ sɔ ɔse bɔlɔlɔ.” ");
INSERT INTO akp_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Ɣɛɛ ise i bo ma ana i Ɣaa aanya sɔ bose bɔlɔlɔ iki i kumɛgɔ bofɔ wũ boɖe sɔ ɔtara Bosate Yesu ɔbɔrɛgu i makpise ame ɔso. ");
INSERT INTO akp_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Ɣaa ɔtã maɖi Kristo matã ala bo ikpi ɔso. Fiɛ ɔtara wũ ɔbɔrɛgu i makpise ame sɔ si ɔ̃abara bo bose bɔlɔlɔ. ");
INSERT INTO akp_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Kiniɔ gɔ Ɣaa ɔɔbara bo bɔlɔlɔ iki i bo kafɔkaɖe iso ne, isobuɛ ka ipia i bo gu wũ ndɛ̃ iki i Bosate Yesu Kristo iso. ");
INSERT INTO akp_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Gɔ bofɔ Kristo boɖe ɔso ne, itã sɔ bona Ɣaa nnyainyɔ nɛ ame bopia kiniɔ. So ɔɣɔ bo gbaã alasɔ boba ɔriinyɔ sɔ boasɛgu Kristo i Ɣaa sigarakaɖekɔ̃ dzɛ lokpa waĩ ame. ");
INSERT INTO akp_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Fiɛ ana ne, so sɛ siɣɔ bo si bopia i imɔrɛ̃ ame alasɔ boɣe sɔ imɔrɛ̃ nɛgbe igbã sɛ itã boya teteree. ");
INSERT INTO akp_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Fiɛ bo iya teteree ne, isɛ itã sɔ boana iwola sɛɛ nɛ loatã sɔ boana ɔriinyɔ. ");
INSERT INTO akp_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Fiɛ ɔriinyɔ nɛgbe iibatã sɔ kunuarɛ aakpɛ̃ bo. Alasɔ Ɣaa ɔki i ɔ̃ Siwarã Bielea dzɛ ɔfedza ɔfere bo iso ɔtã sɔ ɔ̃ kuɖɔɛ ɔyi bo situ ame ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Ɔwi gɔ bona ibarara ne, Kristo ɔba ɔ̃akpi i makpibaradze iti. Iba ngbɔ ku ɔwi gɔ i Ɣaa mɔmɔ ɔɣɛ ɔsɛ ame. ");
INSERT INTO akp_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Isɛ iwe ɔle sɔ ɔturi aakpi i ngɔ nse bɔlɔlɔ kanya. Ɣɛɛ iawo ɔɖe sɔ ɔrere aana ɔtu sɔ ɔ̃akpi i ɔturi sɛɛ iti. ");
INSERT INTO akp_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ɣɛɛ Ɣaa ɔɖi ɔte bo kukaakɔ kumɛgɔ ɔto ɔɖɔɛ bo. Alasɔ ɔwi gɔ bopia i bo akpi ame ne, ɔtã sɔ Kristo ɔkpi i bo iti. ");
INSERT INTO akp_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Si iki i ɔ̃ kukpi iso fiɛ ɔbara bo maturi bɔlɔlɔa i Ɣaa anɔ ne, iyɔ ɔto ɔ̃aɖi bo ɔbɔrɛgu i Ɣaa sikpã siare ame ana! ");
INSERT INTO akp_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Si Ɣaa ɔfere bo gu wũ kanya ndu iki i ɔ̃ Ɔbi kukpi iso ku ɔwi gɔ boɖe ɔ̃ matsirise ne, kiniɔ gɔ i bo gu wũ ndɛ̃ ka ilɛ ne, Ɣaa to ɔ̃anyɔ bo nnya gbodzoo sɔ boana ngbã mɛ loisɛ miro iki i Kristo iso. ");
INSERT INTO akp_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Fiɛ iiɖe nnɛgbe kere, ɣɛɛ so ɔɣɔ bo gbaã alasɔ Ɣaa mɔmɔ ɔki i Bosate Yesu Kristo iso ɔfere bo gu wũ kanya ndu. ");
INSERT INTO akp_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Ikpi ɔki i ɔturi ɔwɛ̃ iso iba i kayiiso fiɛ ikpi nɛmɔ lobɔ kukpi ne. Fiɛ kukpi pia kutã ɔturi biara alasɔ ɔbiara ɔbara ikpi. ");
INSERT INTO akp_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Ikpi ka ipia i kayiiso fiɛ Ɣaa ɔtã bo Mose mmara. Ɣɛɛ ɔwi gɔ i mmara na ne, Ɣaa ɔkpa anɔ ɔfu i maturi akpi iso. ");
INSERT INTO akp_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ita i Adam ɔwi isɛ iabo Mose ɔwi ne, kukpi ɔɖe maturi ɔɖuɖu iso. Mma loibara atsuele ikpi nɛ igbã i Adam ɔbara ana ɔkpi. Fiɛ Adam gɔgbe ɣɛ ɔtã ɔturi gɔ nto ɔ̃aba. ");
INSERT INTO akp_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ɣɛɛ ne, ma inyɔɔ iiɖe mawɛ̃. Alasɔ Ɣaa nnyainyɔ nɛ i ɔturi ɔwɛ̃ ɔbɔ iiɖe ira nɛ i Adam ikpi ɔbara igbã. Adam ɖe ɔturi gɔ ikpi ibara lotã maturi gbodzoo ɔkpi. Ɣɛɛ Ɣaa to ɔ̃atã iɖi nnyainyɔ gbodzoo nɛ loaki i Yesu iso ikɔ maturi gbodzoo ibɔ ala ɔ̃ kayiribielea ɔso. ");
INSERT INTO akp_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Lobie sɔ loɣɛ sɔ Ɣaa nnyainyɔ iise lɛ ikpi nɛ i ɔturi ɔbara. Alasɔ ikpi nɛmɔ ɔbɔ ipɔ. Ɣɛɛ akpi gbodzoo wamɔ kama ne, Yesu nnyainyɔ ɔbara maturi ɔkpese maturi bɔlɔlɔa. ");
INSERT INTO akp_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Iki i ɔturi ɔwɛ̃ iso fiɛ kukpi ɔɖe maturi iso ala ɔ̃ ikpi ɔso. Ɣɛɛ nnɛ lobɔrɛ i Yesu Kristo kukpi ame ɔmɔ iɣede. Mma ɔɖuɖu lona Ɣaa nnyainyɔ ne, ɔbara ma bɔlɔlɔ sɔ maabo i ɔ̃ sigarakaɖekɔ̃ ame maɖegu wũ sigara iki i ɔturi ɔwɛ̃ gɔ nɖe Kristo iso. ");
INSERT INTO akp_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Ne ɔso kumɛgɔ iki i ɔturi ɔwɛ̃ ikpi ibara ɔso i maturi ɔɖuɖu ɔɖe ipɔ ne, ngbɔ ame iki i ira sɛɛ iwɛ̃ ibara iso ne, Ɣaa sɛ ɔtã maturi ɔɖuɖu ibɛ ne. ");
INSERT INTO akp_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Kumɛgɔ ame iki i ɔturi ɔwɛ̃ atsuele ɔso fiɛ maturi ɔɖuɖu ɔkpese makpibaradze ne, ngbɔ ame i Ɣaa aaki i ɔturi ɔwɛ̃ gɔ lokã Ɣaa atsue iso ɔtã sɔ maturi gbodzoo aakpese maturi bɔlɔlɔa ne. ");
INSERT INTO akp_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Gɔ mmara ɔba ne, itã sɔ maturi ɔnya ma akpi gbodzoo maɖi ite. Fiɛ si bonya bo akpi gbodzoo wa bobara ne, ne boanya Ɣaa nnyainyɔ nɛ ɔsu ɔtã bo ana boɖi ite ne. ");
INSERT INTO akp_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Ne ɔso kumɛgɔ i ikpi ɔtã kukpi ɔɖe maturi iso ne, ngbɔ ame i Ɣaa nnyainyɔ aatã sɔ boakpese maturi bɔlɔlɔa fiɛ boabo i ngbã mɛ loisɛ miro i Ɣaa sigarakaɖekɔ̃ iki i bosate Yesu Kristo iso ne. ");
INSERT INTO akp_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Ne ɔso be boaɣɛ? Boakɛlɛgu i katɔ̃ bobara ikpi sɔ Ɣaa nnyainyɔ si isi ibua? ");
INSERT INTO akp_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Ooɣo! Gɔ boɔkpi ɔso ne, ikpi siina ɔle i bo iso! Ne ɔso be ɔso fiɛ boala boɔbara ikpi? ");
INSERT INTO akp_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Ɔwi gɔ mabara bo Ɣaa itupie iki i Yesu Kristo ame ne, miitsue sɔ Ɣaa itupie ɔbara bo gu Kristo mawɛ̃ i ɔ̃ kukpi ana ame? ");
INSERT INTO akp_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Iki i itupie nɛmɔ ame ne, ite sɔ bo wũ boɔkpi fiɛ mabiara bo gu wũ. Ɣaa ɔki i ɔ̃ ikpawaĩ ɔle iso ɔtara Yesu ɔbɔrɛgu i makpise ame sɔ si bo wũ boata boba boasɛgu wũ i ngbã ɣɛtɛ ame. ");
INSERT INTO akp_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Fiɛ gɔ bobaragu wũ mawɛ̃ i ɔ̃ kukpi ame ne, Ɣaa to ɔ̃atã sɔ boabaragu wũ mawɛ̃ i ɔ̃ ita ame ana. ");
INSERT INTO akp_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Boɣe sɔ bo ngbã kuere ne, mapɛ me ku Kristo mamatãra i kudziri iso. Ne ɔso nsɛgbai mɛ nsɛ miɖɔɛ ikpi ibara iisibana ɔle i bo siturina iso sɔ boabara ikpi alasɔ boisiɖe ikpi masande. ");
INSERT INTO akp_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Alasɔ si ɔturi ɔɔkpi ne, ikpi siina ɔle i ɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Ne ɔso si bo gu Kristo ɔkpi ne, bofɔ boɖe sɔ boasɛgu wũ ngbã. ");
INSERT INTO akp_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Boɣe sɔ Ɣaa ɔtara Kristo ɔbɔrɛgu i makpise ame fiɛ ɔ̃isibakpi ala kukpi siina ɔle i ɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Kristo kukpi gɔ ɔkpi ne, ɔkpi ɔkpɛ ɔwɛ̃ sɔ si ikpi iisibaɖe wũ iso. Ngbã mɛ ka ɔsi kiniɔ ne, ɔsi ɔtã Ɣaa. ");
INSERT INTO akp_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Ngbɔ ame ikote sɔ mi wũ mianyɔ so sɔ miɔkpi ne ɔso ikpi iisibaɖe mi iso ne. Ngbã mɛ misi kiniɔ ne, miasɛ mitã Ɣaa i mawɛ̃ ibaragu Kristo Yesu ame. ");
INSERT INTO akp_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Midaatã sɔ ikpi aaɖe mi sosina dzɛ nto siakpi ngbe iso sɔ mianyua so mitã ara wa nsɛ awe sosina ɔmɛrɛ̃. ");
INSERT INTO akp_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Midaatã ɔri sɔ ikpi aaɖe mi sosina iso i ɔri kuwɛ̃ iso sɔ miabara ara lalaa. Ɣɛɛ misu so mitã Ɣaa lɛ mma ɔ̃ɔtara ɔbɔrɛgu i makpise ame ɔbɔ ngbã ame. Minyua so i ɔri biara iso mitã wũ lɛ karabara abarara wa nse sekelee fiɛ ɔ̃asu ɔbara ɔ̃ karabara. ");
INSERT INTO akp_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Ikpi siina ɔle i mi iso alasɔ mina i mmara kayirinɔ. Ɣɛɛ ne, Ɣaa nnyainyɔ kayirinɔ mipia. ");
INSERT INTO akp_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Be ka boaɣɛ? Sɔ bosiina i mmara kayirinɔ ne Ɣaa nnyainyɔ kayirinɔ bopia ɔso ne, boakɛlɛgu i katɔ̃ bobara ikpi? Ooɣo! ");
INSERT INTO akp_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Miiɣe gbaã sɔ si anɔ so karɔ̃ sɔ aasu so apia i ɔturi kayirinɔ ala ɔɔbara ɔ̃ karabara ne, iyɔ ɔkpesera so ngɔmɔ ɔsande? Ne ɔso midaakpesera so makpibaradze nɛ loakɔ ɔturi ikɛlɛgu kukpi ame. Misu so mikpesera ara sɛɛ mabaradze nɛ loakɔ ɔturi ikɛlɛgu ibɔlɔlɔ karabara ame. ");
INSERT INTO akp_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Ɣɛɛ bopɛ Ɣaa siba alasɔ ɔwi ɔwɛ̃ ame ne, miɖe makpibaradze. Ɣɛɛ kiniɔ ne, miɔsu mi situ ɔɖuɖu mifɔ itɔ̃me nɛ lote mi miɖe. ");
INSERT INTO akp_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Miɔbɔrɛ i ikpi nrɔɔ̃ ame alasɔ miɔsu so mitã sibɔlɔlɔ ara ibara. ");
INSERT INTO akp_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Lobie sɔ loɣere mi i ɔturi kuɣɛme si mianɔ karɔ̃ pɔkɔsɔɔ sɔ ne, ɔwi gɔ lofe ame ne, minyua so pelepele mitã ikpi ibara nɛ lopukutura mi. Kiniɔ ne, ngbɔ ame si misu so mitã pelepele i ara bɔlɔlɔa ibara nɛ loabara mi sekelee itã ara sɛɛ ibara ne. ");
INSERT INTO akp_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Ɔwi gɔ miɖe makpibaradze ne, sibɔlɔlɔ iiɖe mi iso. ");
INSERT INTO akp_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Mme kusia mina i ara wa mila miɔbara wa nto akpɛ̃ mi kunuarɛ kiniɔ ame? Ara wamɔ ɔɖuɖu kusia nɖe kukpi ne. ");
INSERT INTO akp_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Kiniɔ ne, miɔbɔrɛ i ikpi nrɔɔ̃ ame, ne ɔso miɔna iwarã. Misu so mibara Ɣaa masande. Alasɔ kusia gɔ miana miɖi si misu so mitã wũ pelepele fiɛ mibara so sekelee nɖe ngbã mɛ loisɛ miro minya. ");
INSERT INTO akp_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Alasɔ ikpi kusia nɖe kukpi. Ɣɛɛ Ɣaa nnyainyɔ ne, iatã bo ngbã mɛ loibaro minya iki Kristo Yesu gɔ nɖe Bokɔse iso. ");
INSERT INTO akp_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Gbaã ne, manyii, mianɔ ara wa nto loɣɛ ngbe karɔ̃ alasɔ mi ɔɖuɖu ɣe mmara iso ara. Mmara ba ɔle i ɔturi iso ayi kumɛgɔ ɔsi ngbã. ");
INSERT INTO akp_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Nto losu nnɛgbe lote sɔ, ɔrɔ̃go gɔ nsi i kurã iyo ne, kuyiri mmara ɔnyi wũ mimatã i ɔrã iso ayi kumɛgɔ i ɔrɛrɛ̃ si ngbã. Ɣɛɛ si ɔrɛrɛ̃ ɔkpi ne, iyɔ ɔrɔ̃go gɔmɔ siina i mmara kayirinɔ. ");
INSERT INTO akp_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Ne ɔso si ɔrɔ̃go gɔgbe ɔsɛ ɔ̃ayiri ɔrɛrɛ̃ mama ku ɔwi gɔ i ɔ̃ ɔra si ngbã ne, maakpere wũ sɔ rãrɔdze ɔɖe. Ɣɛɛ si ɔ̃ ɔrã ɔɔkpi ne, iyɔ ɔsiina i mmara kayirinɔ. Ka ɔba ɔri sɔ ɔ̃ayiri kurã mama gɔ ɔ̃isiɖe rãrɔdze. ");
INSERT INTO akp_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Wũ manyii, ngbɔ ame ise mi ana ne. Alasɔ i mmara kanya ne, ite sɔ mikpi ku ɔwi gɔ i Kristo ɔkpi. Ne ɔso mikpesera so mma i Ɣaa ɔtara ɔbɔrɛgu i makpise ame sɔ bo nsɛgbai ka miaɖe ira sɛɛ mitã Ɣaa. ");
INSERT INTO akp_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Ɔwi gɔ bosɛ ngbã i siturina kanya ne, ikpi ɔwe ɔle i bo ame. Mmara ɔtara ara wagbe miɣedza sɔ bo siturina ɔrakolo ɔtã bobara akpi wa loakɔ bo akɛlɛgu kukpi ame. ");
INSERT INTO akp_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ɣɛɛ kiniɔ ne, gɔ boɔkpi bobɔrɛ i ara wa lonyi bo mmɔ ame ne, mmara siina ɔle i bo iso. Alasɔ boisisɛ bobara kuira i ɔri kuere iso, ɣɛɛ ɔri ɣɛtɛ gɔ iso i Ɣaa Siwarã pia boto bobara karabara. ");
INSERT INTO akp_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Si ise ngbɔ ne, boaɣɛ sɔ Ɣaa mmara nɖe ikpi? Ooɣo! Gbaã ne, mmara iso iki fiɛ botsue ara wa nɖe ikpi. Si mmara si midaaɣɛ sɔ, “Daatã fɔ anɔ si arɛtɛ-ɔ i ɔturi ira iso” ne, tee loibatsue nnɛ nɖe kanɔbɛbɛ. ");
INSERT INTO akp_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Ɣɛɛ ne, ikpi ɔba iana ɔri iki mmara iso itã sɔ kanɔbɛbɛ agbãagbã ɔna ɔle i wũ ame. Si mmara na ne, ikpi na ɔle. ");
INSERT INTO akp_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Mme wũ losɛ ngbã mɛgbe igbã ɔwi gɔ lofe gɔ loiɣe mmara. Ɣɛɛ ɔwi gɔ lotsue mmara fiɛ miitã me ɔri sɔ loabara ara gbodzoo ne, ikpi ibara ana ɔta iya i wũ ame. ");
INSERT INTO akp_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Ne ɔso mmara mɛ loatã me ngbã fiɛ ne, mibɔ me kukpi bowũ. ");
INSERT INTO akp_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Ikpi ɔna ɔri iki i mmara iso isɔsɔla me iɖoe. ");
INSERT INTO akp_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Ne ɔso mmara mɔmɔ se sekelee, ara wa mite ana se sekelee, ise bɔlɔlɔ fiɛ ilɛ ana. ");
INSERT INTO akp_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Ne iyɔ ɔte ito sɔ ira nɛ nsɛ ibɔ ira sɛɛ ɔbɔ me kukpi? Ooɣo! Iiɖe ngbɔ iɖe. Ɣɛɛ ikpi losu ira sɛɛ ikpadzɛ̃ kukpi ibɔ me. Iba ngbɔ si ite kumɛgɔ i ikpi ɔnyanyarĩ. Fiɛ iki i mmara iso ne, ikpi ɔɔɖi ne nsɛgbai mɔmɔ ite. ");
INSERT INTO akp_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Boɣe sɔ mmara ne, Siwarã ame ira iɖe. Ɣɛɛ mme ne, sosina ame ɔturi loɖe fiɛ ikpi ɔɖe me iso. ");
INSERT INTO akp_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Loisɛ lonɔ ara wa nsɛ lobara karɔ̃. Alasɔ ara wa nsɛ lobie sɔ loabara ne, iiɖe wã aɖe nsɛ lobara. Ɣɛɛ ara wa loisɛ loɖɔɛ ne, wã nsɛ lobara ne. ");
INSERT INTO akp_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Fiɛ si ara wa loisɛ loɖɔɛ nsɛ lobara ne, iɔte sɔ lonɔ karɔ̃ sɔ mmara lɛ. ");
INSERT INTO akp_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Ne ɔso ne, iɔte sɔ iiɖe mme mɔmɔ me nsɛ lobara ara wamɔ ɣɛɛ ikpi nɛ mpia i wũ ame nsɛ ibara. ");
INSERT INTO akp_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Loɣe sɔ i wũ ame ne, ira sɛɛ kuiwɛ̃ na ayi kumɛgɔ loɖe ɔturi awune. Alasɔ losɛ lobie gbaã sɔ tee loabara isɛɛ fiɛ, ɣɛɛ loisɛ lowo ɔbara. ");
INSERT INTO akp_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Alasɔ isɛɛ nɛ loto lobie sɔ loabara ne, iiɖe ne nsɛ lobara. Ɣɛɛ ikpi nɛ loito lobie sɔ lobara ne, ne iɖe losɛ lobara ne. ");
INSERT INTO akp_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ne ɔso si loto lobara ara wa loito lobie ne, iyɔ iiɖe mme mɔmɔ me nto lobara. Ɣɛɛ ne, ikpi nɛ mpia i wũ ame iɖe. ");
INSERT INTO akp_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Ne ɔso lonya ira ɔ nɛgbe loɖi ite i wũ ame sɔ, si loto lobie sɔ lobara isɛɛ ne, ikpi ɔmatã me iso teteree. ");
INSERT INTO akp_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Gbaã iɖe sɔ i wũ ɔtu ame tee ne, Ɣaa mmara sɛ mitã me isoɣɔ gbaã. ");
INSERT INTO akp_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Ɣɛɛ lonya sɔ ara mama wa nsɛ abɔrɛ i wũ ame sɛ akpɛ̃gu ara wa i wũ adzuni ɔte me sɔ alɛ fiɛ. Ne ɔso atã sɔ ikpi ɔnyi me lɛ yorɛdze awe. ");
INSERT INTO akp_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Wũ ara ba nnya gbaã. Nna loaɖi me ɔbɔrɛgu i sosina ɔmɛrɛ̃ kuere gɔ nto me ikɔ isɛgu kukpi ame? ");
INSERT INTO akp_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Lopɛ Ɣaa siba alasɔ ɔsɛ ɔki i Bosate Yesu Kristo iso ɔɖi me! Kiniɔ ne, i wũ adzuni ame ne, loɖe Ɣaa mmara iso baradze. Ɣɛɛ i wũ sosina kurabarara kanya ne, loɖe kpibaradze. ");
INSERT INTO akp_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Nnɛgbe ɔso ne, ipɔ kuiwɛ̃ siina itã mma lobara mawɛ̃ ku Kristo Yesu i ma kasɛ ame. ");
INSERT INTO akp_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Alasɔ iki i Kristo Yesu iso ne, mmara mɛ nsɛ miki i Ɣaa Siwarã ame mitã maturi ngbã ɔtã sɔ loɔbɔrɛ i mmara mɛ loakɔ mɛ misɛgu ikpi ame. ");
INSERT INTO akp_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Alasɔ ira nɛ i Ɣaa mmara mɛ ɔsu ɔtã Mose fiɛ boiwo ɔbara ana maturi iiwo me ɔɖe iso ne, Ɣaa ɔɔbara ne. Ɔpia ɔ̃ Ɔbi lɛ ɔturi gɔ mba sosina dzɛ ikpi ɔkpɛ̃gu. Ɔba ɔ̃atã kuso i bo iti, ɔtã ikpi ipɔ ɔle gɔ iba i bo iso ɔnina. ");
INSERT INTO akp_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Ɣaa ɔbara nnɛgbe ɔtã bo ma nsi lɛ kumɛgɔ i Ɣaa Siwarã ɔɖɔɛ, iiɖe kumɛgɔ i siturina sɛ siɖɔɛ awe. Ɔbara ara wagbe ɔɖuɖu i ɔri bɔlɔlɔa iso lɛ kumɛgɔ i ɔ̃ mmara ɔte awe. ");
INSERT INTO akp_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Mma nsɛ masɛ i ma sosina ɔmɛrɛ̃ kanya ne, ma adzuni sia i ara wa i ma sosina sɛ siɖɔɛ iso. Ɣɛɛ mma nsi iki i Ɣaa Siwarã ɔso ne, ma adzuni sia i ara wa i Ɣaa Siwarã sɛ si ɖɔɛ iso. ");
INSERT INTO akp_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Ɔturi gɔ adzuni nsia i sosina ara iso ne, kukpi ɔsɛ ɔna. Ɣɛɛ ngɔ adzuni nsia i Ɣaa Siwarã iso ne, ɔsɛ ɔna ngbã gu isobuɛ. ");
INSERT INTO akp_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Ngɔ adzuni nsia i sosina ara kere iso ne, Ɣaa tsirise ɔɖe alasɔ ɔ̃isɛ ɔkã Ɣaa mmara atsue. Fiɛ gbaã ne, ɔ̃ibawo me iso ɔbara ana kuiyikuiyi. ");
INSERT INTO akp_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Mma nsɛ mabara ma sosina kuɖɔɛ ne, maibawo Ɣaa anɔ ɔbo. ");
INSERT INTO akp_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Si Ɣaa Siwarã ɔyi i mi ame ne, miibasɛ lɛ kumɛgɔ i mi sosina nsɛgbai ɔte kanya, ɣɛɛ lɛ kumɛgɔ i Ɣaa Siwarã ɔɖɔɛ. Fiɛ si Kristo Siwarã na i ɔrere ame ne, ɔ̃iɖe Kristo ɔre. ");
INSERT INTO akp_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Kiniɔ gɔ i Kristo pia i mi ame ne, mi siturina to siakpi ala ikpi ɔso. Ɣɛɛ mi Siwarã to siawe ngbã alasɔ Ɣaa ɔɔbara mi bɔlɔlɔ. ");
INSERT INTO akp_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Fiɛ si Ɣaa Siwarã dzɛ lotara Yesu sibɔrɛgu i makpise ame pia i mi ame ne, ɔ̃ gɔ lotara Kristo Yesu ɔbɔrɛgu i makpise ame to ɔ̃atã mi siturina dzɛ loakpi ngbã iki i ɔ̃ Siwarã dzɛ mpia i mi ame ɔso. ");
INSERT INTO akp_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Ne ɔso ne, wũ manyii, boito sosina kuso sɔ boasɛ bobara sosina kuɖɔɛ. ");
INSERT INTO akp_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Si misiai sosina ɔmɛrɛ̃ nyanyarĩa kama ne, mito miakpi. Ɣɛɛ si miki i Ɣaa Siwarã iso miɖoe mi sosina ngbã kuere lalaa ne, mito miana ngbã. ");
INSERT INTO akp_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Alasɔ mma i Ɣaa Siwarã to sikɔ ne, ma nɖe Ɣaa mabi ne. ");
INSERT INTO akp_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Ɣaa iitã mi Siwarã dzɛ loatã sɔ miakpese masande mila miɔnigã. Ɣɛɛ ndzɛ loatã mikpese ɔ̃ mabi. Iki i Siwarã dzɛmɔ iso ne, bosɛ bokpere Ɣaa sɔ, “Abba” gɔ karɔ̃ nɖe sɔ Tete. ");
INSERT INTO akp_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ɣaa Siwarã gu bo siwarã ɔbara mawɛ̃ mato mate sɔ Ɣaa mabi boɖe. ");
INSERT INTO akp_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Gɔ ɔ̃ mabi boɖe ɔso ne, bo loaɖe ɔ̃ ara ana. Bo gu Kristo loatoto boɖe Ɣaa ara. Fiɛ boafiɛ ana lɛ ɔ̃ si bowe inyɛ lɛ kumɛgɔ i Kristo ɔwe inyɛ. ");
INSERT INTO akp_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","I wũ itsue kanya ne, inyɛwe nɛ boba kiniɔ ne, iibawo ɔkategu Ɣaa ikpawaĩ gu isoɣɔ nɛ boana. ");
INSERT INTO akp_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Ɣaa kurabarara ɔɖuɖu to kunyɔ ɔri totoroo kutã ɔwi gɔ i Ɣaa aaɖi ɔ̃ mabi ɔte. ");
INSERT INTO akp_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Ɣaa kurabarara gɔgbe ɔɖuɖu ɔbo i inyɛwe ame gɔ iiɖe kɔ̃ mɔmɔ kuɖɔɛ ɔso. Ɣɛɛ Ɣaa mɔmɔ lotã ɔri sɔ iba ngbɔ si ɔ̃atã ma ɔriinyɔ sɔ, ");
INSERT INTO akp_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ɔto ɔ̃akpadzɛ̃ ara wamɔ ɔɖuɖu ɔɖi i kukpi nrɔɔ̃ ame fiɛ aana iwarã afiɛ lɛ ɔ̃ mabi awe. ");
INSERT INTO akp_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Boɣe sɔ ipɛ i kiniɔ ne, Ɣaa kurabarara ɔɖuɖu to kutɔrɛ̃ lɛ ɔrɔ̃go gɔ nto ɔkpɛ̃ kuɣe. ");
INSERT INTO akp_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Fiɛ iiɖe ara wamɔ kere, ta bo ma i Ɣaa ɔsu ɔ̃ Siwarã ɔtã ana to botɔrɛ̃ i bo ame bosu bo ɔriinyɔ bosia sɔ Ɣaa to ɔ̃atã bo ikpi iti kuso sɔ si boana iwarã lɛ ɔ̃ mabi. ");
INSERT INTO akp_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Gɔ boba ɔriinyɔ nɛgbe ɔso ne, boba iɖi. Ɣɛɛ ɔriinyɔ nɛ boto bonya ala anɔ ne, iisiɖe ɔriinyɔ. Alasɔ ɔturi iisisɛ ɔnyɔ ira nɛ ɔto ɔnya ɔri. ");
INSERT INTO akp_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ɣɛɛ si bo anɔ sia i ara wa i bo anɔ iito anya iso ne, iyɔ boana ɔtu bonyɔ ɔri sɔ isɛ i ɔri. ");
INSERT INTO akp_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","I ɔri gɔgbe ame iso i Ɣaa Siwarã sɛ sibuai bo alasɔ bona ɔle fiɛ boiɣe kumɛgɔ boakparama kayi bokigu. Ɣɛɛ ɔ̃ Siwarã mɔmɔ sɛ si tɔrɛ̃ i bo ati kumɛgɔ ikote fiɛ boibawo ɔɖi ɔte. ");
INSERT INTO akp_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Ɣaa gɔ nɣe maturi situ ame ne, ɔɣe ira nɛ mpia i Ɣaa Siwarã adzuni ame ana. Alasɔ Siwarã sɛ sitã Ɣaa iti i bo iti lɛ kumɛgɔ i Ɣaa ɔɖɔɛ. ");
INSERT INTO akp_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Boɣe sɔ ira biara nɛ i Ɣaa ɔbara ne, ilɛ itã maturi ma nsɛ maɖɔɛ wũ fiɛ ɔkpere ma sɔ mabara ɔ̃ karabara. ");
INSERT INTO akp_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Fiɛ mma i Ɣaa ɣe ɔsɛ ne, ɔsia ma ikparĩ nɛ loatã sɔ maare ɔ̃ Ɔbi sɔ ɔ̃ Ɔbi aaɖe ɔɖeakatɔ̃ i manyiibi gbodzoo ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Ne ɔso mma i Ɣaa ɔsia ikparĩ ne, ma iɖe ɔkpere ne. Mma ɔkpere ne, ɔbara ma bɔlɔlɔ. Fiɛ mma ɔbara bɔlɔlɔ ne, ma ati ɔtara kato ne. ");
INSERT INTO akp_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Nwagbe ɔso ne, be iɖe boaɣɛ? Si Ɣaa ɣɛ bo i kama ne, nna loawo bo ɔkpɛ̃gu? ");
INSERT INTO akp_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Si Ɣaa iisɛ̃ sɔ ɔ̃ito ɔsu ɔ̃ Ɔbi ɔtã i bo iti ne, be ɔso fiɛ ɔ̃ibasu ara ɔɖuɖu ɔtã bo i kayiribielea ame ala ɔ̃ Ɔbi ɔso? ");
INSERT INTO akp_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Nna loawo Ɣaa maturi kanya ɔɖaɛ? Ɣaa mɔmɔ nɖe ma kanyaɖidze fiɛ ɔ̃inyagu ma ikpi kuiwɛ̃. ");
INSERT INTO akp_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Nna ɔɖe loawo ma ipɔ ɔtã? Kristo Yesu nɖe ngɔ lokpi fiɛ Ɣaa ɔledza wũ itara ibɔrɛgu i makpise ame, ɔpia ngbã fiɛ ɔsi i Ɣaa kuɖearɔ̃ iso ɔto ɔpɛ wũ nrɔɔ̃ i bo iti. ");
INSERT INTO akp_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Nna ɔɖe loawo bo gu Kristo kuɖɔɛ gɔ mpia bo i ndɛ̃ ɔɖaɛ? Inyɛwe, ɛɛbɛrɛ ibo inɔ, ɛɛbɛrɛ ɔnyɛ, ɛɛbɛrɛ ita iya iso, kukã ɛɛbɛrɛ isɔ̃ isɛ, ɛɛbɛrɛ itikpi, ɛɛbɛrɛ kukpi iki i ipɛmi iso? ");
INSERT INTO akp_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Ipia i Ɔko Sekelea ame sɔ, “Fɔ ɔso ne, bopia i kukpi ifɔ̃ ame iyi biara. Masɛ mabara bo lɛ masɛrɛ ma masɛgu kaɖoekɔ̃.” ");
INSERT INTO akp_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","I nwagbe ɔɖuɖu ame ne, boɖo mma loɖe iso iki i Kristo gɔ loɖɔɛ bo ɔso. ");
INSERT INTO akp_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","39","Alasɔ ikpa me sekelee sɔ kuɖɔɛ gɔ mpia i bo gu Ɣaa ndɛ̃ iki i Kristo Yesu gɔ nɖe Bosate iso ne, kuira iibawo bo ndɛ̃ ɔɖaɛ. Kukpi o-o, ngbã o-o, Ɣaa makpabo o-o, siwarã lalaa o-o, ɔwi nyanyarĩa gɔ loaba o-o, ɔle ɔrere i kato o-o, karɔ̃ o-o ne, kuira na nɛ i Ɣaa ɔbara sɔ iawo bo ndɛ̃ ɔɖaɛ. ");
INSERT INTO akp_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Ayi kumɛgɔ loɖe Kristo ɔre ne, ɔnukuare loto loɣɛ, fiɛ loito lola sila. Siwarã Bielea ana to siɖe wũ ɔtu iso fiɛ loibala sila. ");
INSERT INTO akp_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Lobie sɔ mitsue sɔ isoma pia i wũ ɔtu ame gbaã. ");
INSERT INTO akp_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Alasɔ loto lobie sɔ loabuai wũ aɖe maturi. Si Ɣaa aanɔ karɔ̃ ne, ɔbɛse me i Kristo iso ɔfinikira wũ iɖi ɔtã wũ maturi si mme lowɔ pelepele. ");
INSERT INTO akp_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Alasɔ Ɣaa maturi ma ɔɖi maɖe. Ɔsu ma ɔbara ɔ̃ mabi, fiɛ ɔɖi ɔ̃ sigarakaɖekɔ̃ ikpawaĩ ɔte ma. Ma iɖe ɔnyigu kanya fiɛ ɔsu ɔ̃ mmara ana ɔtã. Ma iɖe i Ɣaa ɔte kumɛgɔ maafɛ̃ ara matã wũ fiɛ ma iɖe ɔtã ɔ̃ kaɣɛkasɛ ana. ");
INSERT INTO akp_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Ma mawa nɖe Israel makpakpa ma i Ɣaa ɔɖi fiɛ ma ɔɣekparɛ ame i Kristo gɔ loba kayiiso lɛ ɔturi awe ɔbɔrɛ. Boale Ɣaa gɔ nto ɔɖe ara ɔɖuɖu iso ita i kiniɔ ito ikɛlɛ dzoroo. Si iba ngbɔ. ");
INSERT INTO akp_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Iise lɛ sɔ Ɣaa kaɣɛkasɛ ga ɔɣɛ ɔsɛ ne, ɔ̃ibara i kã iso. Alasɔ iiɖe ma Yudase ɔɖuɖu nɖe maturi ma i Ɣaa ɔɖi lɛ ɔ̃ mare. ");
INSERT INTO akp_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Ite sɔ iiɖe Abraham mawa ɔɖuɖu nɖe Ɣaa mabi. Ɣaa ɔɣere Abraham sɔ, “Isak iso loaka-ɔ mawa.” ");
INSERT INTO akp_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Nnɛgbe ɔte sɔ iiɖe Abraham mabi ɔɖuɖu ma ɔɣe nɖe Ɣaa mabi. Ɣɛɛ mabi ma maɣe iki i Ɣaa kaɣɛkasɛ ame ne, ma ɔsɛ ɔnyɔ lɛ Abraham mabi mɔmɔ ne. ");
INSERT INTO akp_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Itɔ̃me nɛ i Ɣaa ɔɣɛ i kaɣɛkasɛ ame nɖe sɔ, “Loakpese loba ku ikɔlɛaba ɔwi gɔgbe ame fiɛ Sara aaɣe ɔbirɛrɛĩ.” ");
INSERT INTO akp_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Fiɛ iiɖe nnɛgbe kere. Ɣɛɛ Rebeka ɔɣe inyɔmabi gɔ maɖe mabirɛrɛĩ mabɔrɛ i ɔse ɔwɛ̃ saã gɔ nɖe bo ɔwa Isak ame. ");
INSERT INTO akp_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Ɣɛɛ ne, Ɣaa ba ɔri gɔ iso ɔsɛ ɔki ɔsɛ ɔɖi maturi. Fiɛ kumɛgɔ iba i ne ame ne, Ɣaa ɔɣɛ ira ɔsɛ fiɛ maɣe inyɔmabi magbe kɔra fiɛ maatsue isɛɛ gu ikpi. Ɔri gɔ iso ɔki ɔɖi ma iiki ma karabara kukawɛ̃ iso. Alasɔ ɔɣere Rebeka sɔ, “Ɔbi kpakpare to ɔ̃akpese kosore ɔɖabo.” ");
INSERT INTO akp_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Lɛ kumɛgɔ i Ɣaa ɔɣɛ i Ɔko Sekelea ame sɔ, “Yakob loɖi, fiɛ Esau losɛ̃.” ");
INSERT INTO akp_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Iyɔ be boaɣɛ i nnɛgbe iso iyɔ? Boaɣɛ sɔ Ɣaa iibara ara i ɔri iso? Ooɣo! Iiɖe ngbɔ iɖe. ");
INSERT INTO akp_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Ala ɔɣere Mose sɔ, “Ngɔ loanyɔ nnya ne, loanyɔ wũ nnya. Fiɛ ngɔ ara loaɖo me kayiri ne, ɔ̃ ara aaɖo me kayiri.” ");
INSERT INTO akp_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Ne ɔso Ɣaa nnyainyɔ ne, iiɖe ɔturi karabara ɣee ɔ̃ kubɛ iso isɛ iki ɣɛɛ ise i Ɣaa mɔmɔ nnyainyɔ iso. ");
INSERT INTO akp_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","I Ɔko Sekelea ame ne, Ɣaa ɔɣere igara Farao sɔ, “Nnɛgbe ɔso losɛra-ɔ sigara sɔ si loaɖi wũ ɔle lote maturi i fɔ iso fiɛ maale wũ iyere teteree i kayiiso ɔɖuɖu ne.” ");
INSERT INTO akp_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Ne ɔso Ɣaa sɛ ɔnyɔ ngɔ ɔto ɔɖɔɛ nnya fiɛ ɔsɛ ɔgbã atsue ana i mma mba atsuele iso. ");
INSERT INTO akp_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Mi ɔwɛ̃ to ɔ̃akarɛ me sɔ, “Si ise ngbɔ ne, lɛ ise ɔso fiɛ Ɣaa aakpese ɔtã ɔturi ipɔ? Alasɔ kuwɛ̃ iibawo ɔta ɔya i Ɣaa kuɖɔɛ iso.” ");
INSERT INTO akp_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Fɔ nɖe nna fiɛ aaɖegu Ɣaa ika ngbɔ? Ibui sɛ ikarɛ pɔse gɔ lopɔ ne sɔ, “Be ɔso fiɛ apɔ me ngbɔ?” ");
INSERT INTO akp_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Ne kama ne, pɔse ba ɔri ɔ̃asu sipɔse ɔbara ira biara nɛ ɔɖɔɛ. Ɔ̃awo abui anyɔ ɔpɔ ɔɖi i sise siwɛ̃ saã ame sɔ maasu ibui iwɛ̃ mabara ndu nɛa ire itsɔra ana masu mabara irubui. ");
INSERT INTO akp_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Ngbɔ ame i Ɣaa ɔbara ne. Ɔto ɔbie sɔ ɔ̃aɖi ɔ̃ sikpã ɔte sɔ maatsue ɔ̃ ɔle. Ɣɛɛ ɔɣara so ɔtã mma mpia i ɔ̃ sikpã kayirinɔ gbɔgbɔɔgbɔ ɔwi gɔ ɔsɛ sɔ ɔ̃awɔra ma aaɣo. ");
INSERT INTO akp_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Ngbɔ ame ɔto ɔbie sɔ ɔ̃aɖi ɔ̃ ara sɛɛ wa mpia i ɔ̃ ikpawaĩ gu isoɣɔ siare ame ɔte mma ɔ̃anyɔ nnya ne. Fiɛ bo nɖe mma ɔledza ɔsɛ ɔtã sɔ boaba boafiɛ. ");
INSERT INTO akp_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Ne ɔso ɔɖi bo iiɖe ma Yudase kere, ɣɛɛ ta mma loiɖe ma Yudase ana ne. ");
INSERT INTO akp_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Lɛ kumɛgɔ i Ɣaa ɔɣɛ i kanyaɖidze Hosea ɔko ame sɔ, “Mma loiɖe wũ maturi ne, loakpere ma wũ mare. Fiɛ mma loiɖe wũ maɖɔɛse ne, loakpere ma sɔ wũ maɖɔɛse. ");
INSERT INTO akp_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Ngbegɔ ame loɣɛ sɔ, Miiɖe wũ mare ne, mmɔ ame i maturi aakpere ma sɔ Ɣaa gɔ nna karokɔ̃ mabi ne.” ");
INSERT INTO akp_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Ɣaa Kanyaɖidze Yesaya ɔ̃ wũ ɔɣere ma Yudase ku sikpabo teteree sɔ, “Si ma Yudase ɔsi lɛ ɔpo ame iwarĩ kɔra ne, ma ndɛ̃ irɛ̃saã kere loana iɖi. ");
INSERT INTO akp_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Alasɔ Bosate to ɔ̃aɣɛgu kayiiso maturi ɔɖuɖu atɔ̃me mala ɔro.” ");
INSERT INTO akp_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Ito iaba lɛ kumɛgɔ i Yesaya ɔɣɛ ɔwi gɔ lofe sɔ, “Si Bosate Ɔle Ɔɖuɖu Sate iikuti bo mabi gu mawa kɛkɛĩ ne, boto boawɔ lɛ kumɛgɔ i Sodom gu Gomora Simagɛ̃ ɔwɔ awe!” ");
INSERT INTO akp_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Nnɛgbe ɔso ne, be boaɣɛ? Mma loiɖe ma Yudase fiɛ maito makpɛ̃ sɔ maase bɔlɔlɔ ne, maba maakpese maturi ma nse bɔlɔlɔ i Ɣaa anɔ gɔ mafɔ wũ maɖe ɔso. ");
INSERT INTO akp_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Ɣɛɛ ma Yudase ma nsiai mmara iso ibara kama teteree sɔ maase bɔlɔlɔ i Ɣaa anɔ ne, maiwo ɔse bɔlɔlɔ. ");
INSERT INTO akp_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Be ɔso fiɛ maiwo? Alasɔ maiki i kafɔkaɖe iso sɔ kaabara ma bɔlɔlɔ ɣɛɛ maki i ma kurabarara iso. ");
INSERT INTO akp_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Alasɔ matura i Kristo gɔ nse lɛ ita siare nɛ nse i ma ɔri iso lɛ kumɛgɔ ipia i Ɔko Sekelea ame sɔ, “Minyɔ! Losɛ ita iwɛ̃ i Sion nɛ loatã maturi ɔtura. Maatura i ne iso marɔ̃. Ɣɛɛ ɔbiara gɔ loafɔ wũ ɔɖe ne, kunuarɛ iibakpɛ̃ wũ kunya ɖa.” ");
INSERT INTO akp_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Wũ manyii, iɖe kuɖɔɛ gɔ lobɔrɛ i wũ ɔtu ame gu wũ kayi ikparama sɔ ma Yudase aana iɖi. ");
INSERT INTO akp_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Loawo ma kanya ɔɣɛ sɔ ma anɔ ɔrɛtɛ̃ i Ɣaa kasumu iso gbaã. Ɣɛɛ ma anɔ irɛtɛ isia i ɔri gɔ lokote iso. ");
INSERT INTO akp_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Alasɔ maiɣe ɔri gɔ iso i Ɣaa sɛ ɔki ɔbara ɔturi bɔlɔlɔ i ɔ̃ anɔ. Ɣɛɛ ma mɔmɔ masɛ mabie ma ɔri matã so. Alasɔ maito mabie sɔ maabɔ so karɔ̃ matã Ɣaa sɔ ɔ̃ate ma ɔri gɔ iso maaki fiɛ maase bɔlɔlɔ. ");
INSERT INTO akp_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Alasɔ Kristo nɖe Mose mmara ɔɖuɖu kawirikɔ̃. Ne ɔso ɔbiara gɔ lofɔ Kristo ɔɖe ne, ɔɖe ɔturi bɔlɔlɔa i Ɣaa anɔ. ");
INSERT INTO akp_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Mose ɔtsɛrɛ i ɔturi biara gɔ loase bɔlɔlɔ iki i mmara iso sɔ, “Ɔbiara gɔ loabara i mmara mɛgbe iso ne, mmara aatã wũ ngbã.” ");
INSERT INTO akp_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Ɣɛɛ Ɔko Sekelea ɔɣɛ i ngɔ loase bɔlɔlɔ i Ɣaa anɔ iki i kafɔkaɖe iso sɔ, “Daakarɛ so sɔ, ‘Nna loakɛlɛ kato?’ ” Ne karɔ̃ nɖe sɔ, nna loaya ɔkɛlɛ kato ɔ̃akɔ Kristo ɔbɔ? ");
INSERT INTO akp_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","“Daakarɛ so sɔ, ‘Nna loakɛlɛ karɔ̃ ame?’ ” Ne karɔ̃ nɖe sɔ nna loakɛlɛ makpise aɖe ɔ̃atara Kristo ɔbɔ? ");
INSERT INTO akp_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Ɣɛɛ nnɛ ɔte nɖe sɔ, “Ɣaa Itɔ̃me ɔbore imatã- ɔ, ipia i fɔ kanya gu fɔ ɔtu ame.” Fiɛ ne nɖe kafɔkaɖe itɔ̃me nɛ imomo boto bopɛ ne. ");
INSERT INTO akp_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Si abusi fɔ kanya aɣɛ sɔ Yesu nɖe Bosate fiɛ afɔ aɖe i fɔ ɔtu ame sɔ Ɣaa ɔtara wũ ɔbɔrɛgu i makpise ame ne, Ɣaa to ɔ̃atã-ɔ ngbã. ");
INSERT INTO akp_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Alasɔ fɔ ɔtu ame iɖe aafɔ aɖe fiɛ aase bɔlɔlɔ i Ɣaa anɔ, ɣɛɛ fɔ kanya aasu abusi fɔ kafɔkaɖe ate fiɛ aana iɖi. ");
INSERT INTO akp_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Alasɔ ngbɔ matsɛrɛ i Ɔko Sekelea ame sɔ, “Ɔbiara gɔ lofɔ wũ ɔɖe ne, kunuarɛ iibakpɛ̃ wũ kunya.” ");
INSERT INTO akp_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Nnɛgbe ɔte sɔ ne, ikpaki kuiwɛ̃ na i ma Yudase gu mma loiɖe ma Yudase ndɛ̃. Bosate nɖe bo ɔɖuɖu ɔse fiɛ ɔsɛ ɔbara mma ɔɖuɖu nsɛ masiai wũ isɛɛ. ");
INSERT INTO akp_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Lɛ kumɛgɔ ipia i Ɔko Sekelea ame sɔ, “Ɔbiara gɔ loakpere Bosate iyere aana iɖi.” ");
INSERT INTO akp_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Fiɛ ngɔ maifɔ maɖe ne, nda maabara fiɛ maakarɛ wũ ira? Fiɛ ngɔ iso Itɔ̃me maiɣere ma manya ne, nda maabara maafɔ wũ maɖe? Fiɛ si kuwɛ̃ iipɛ imomo ɔtã ma i ɔwi gɔ lofe ne, nda maanɔ maɣɛ? ");
INSERT INTO akp_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Fiɛ si maipia ma katɔ̃me sɔ maɣɛ ne, nda maaɣɛ ne maɣɛ? Lɛ kumɛgɔ matsɛrɛ sɔ, “Mma nsɛgu itɔ̃me sɛɛ ngba to milɛ ɔnyɔ ala ma itɔ̃me ba ɔmɛrɛ̃.” ");
INSERT INTO akp_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Ɣɛɛ ne, iiɖe ma ɔɖuɖu lofɔ Itɔ̃me Bielea nɛgbe. Alasɔ Yesaya ɔɣɛ sɔ, “Bosate, mabe lofɔ bo itɔ̃me maɖe?” ");
INSERT INTO akp_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Ne ɔso ne, kafɔkaɖe sɛ kaya i itɔ̃me nɛ anɔ iso. Fiɛ itɔ̃me inɔ ɔse i Kristo itɔ̃me iɣɛ iso. ");
INSERT INTO akp_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Ɣɛɛ ira nɛ lobie sɔ loakarɛ nɖe sɔ, ma Yudase ne, ɔnɔ mainɔ Ɣaa Itɔ̃me? Manɔ lɛ kumɛgɔ i Ɔko Sekelea ɔɣɛ sɔ, “Manɔ ma kulu i kayiiso ɔɖuɖu, fiɛ ma Itɔ̃me ɔki ikã kayiiso.” ");
INSERT INTO akp_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Lobie sɔ loaledza ikarɛ sɔ mainɔ karɔ̃? Mose mɔmɔ nɖe ngɔ loɖe katɔ̃ ɔtsɛ Ɣaa Itɔ̃me kanya iɖi fiɛ ɔɣɛ sɔ, Ɣaa sɔ, “Loatã sɔ mi anɔ aarɛtɛ i mma loiɖe ma Yudase iso. Fiɛ loasu mma anɔ loibusi lopia mi sikpã.” ");
INSERT INTO akp_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Fiɛ Yesaya ana ɔwe ɔtu ɔɣere ma sekelee sɔ Ɣaa sɔ, “Maturi ma loinyɔnyɔ me ne, ma lonya me ne, Fiɛ loɖi so lote mma loikarɛ wũ iti.” ");
INSERT INTO akp_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Ɣɛɛ ma Yudase iso ne, Ɣaa ɔɣɛ sɔ, “Lowarɛ wũ nrɔɔ̃ losɔ̃ ma ikpɛnɛ ɔɖuɖu sɔ si lofɔ ma. Ɣɛɛ maɖi me atsue, alasɔ maɖe maturi ma mba atsuele fiɛ mata maɣɛ me iso.” ");
INSERT INTO akp_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Lobie sɔ lokarɛ kiniɔ sɔ, Ɣaa ne, ɔsɛ̃ ɔsɛ̃ ɔ̃ maturi? Ooɣo. Alasɔ mme wũ ne, ɔ Yudase gɔ nɖe Abraham ɔwa fiɛ lobɔrɛ i Benyamin ɔɣekparɛ ame loɖe. ");
INSERT INTO akp_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Ɣaa iisɛ̃ ɔ̃ maturi ma ɔɣe ɔsɛ koko. Miɣe ara wa matsɛrɛ mapia i Ɔko Sekelea ame ɔwi gɔ i kanyaɖidze Eliya ɔtã Ɣaa iti i ma Yudase iso ɔɣɛ sɔ, ");
INSERT INTO akp_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Bosate, maɔɖoe fɔ kanyamaɖidze mabiɛbiɛ fɔ isɔrɛkusege ɔɖuɖu. Wũ ɔnɔwɛ̃ pɛ me loɔkuti fiɛ mato mabie sɔ maaɖoe me!” Ne be i Ɣaa ɔɣere Eliya? ");
INSERT INTO akp_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Ɔtã wũ mmuai sɔ, “Lokɔla maturi kukpi kukɔdzɛ lotã so gɔ maipɛ igɛgɛ̃ matã Baal kuɣɔ.” ");
INSERT INTO akp_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Ngbɔ ame ise kiniɔ ne. Maturi kɛkɛĩ to maakuti gɔ Ɣaa aaɖi ma ɔsɛ i kuruɛ ɔtã so iki i ɔ̃ nnyainyɔ ɔso. ");
INSERT INTO akp_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Ɔ̃ nnyainyɔ iso ɔki ɔɖi ma gɔ iiɖe ma kurabarara kukuwɛ̃ ɔso. Alasɔ si Ɣaa ɔɖi maturi ala ma kurabarara kanya ne, iyɔ ɔ̃ nnyainyɔ iiɖe igbaãre. ");
INSERT INTO akp_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Gbaã ne, ira nɛ iso i ma Yudase ɔriinyɔ sia teteree ne, maina ne. Ɣɛɛ mma i Ɣaa ɔɖi ne, ma lona ne. Fiɛ matsɔra ana ɔwe atsuele. ");
INSERT INTO akp_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Ngbɔ i Ɔko Sekelea ɔɣɛ sɔ, “Ɣaa ɔnyua ma ɔtã sidzimi ɔmini ma situ gu adzuni ɔɖuɖu. iba iabo nɔme ne, maito makã atsue fiɛ maito manya fiɛ maatsue.” ");
INSERT INTO akp_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Ne ɔso i igara David ɔɣɛ sɔ, “Ɣaa si ɔtã sɔ ma ɔpɔrɔ̃ katukɔ̃ si ikpese ma kagbaraĩ ga loapɛ ma. Si ma isɛɛ si ikɔ ma ipia i itikpi ame. ");
INSERT INTO akp_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Ɔtã sɔ ma anɔ abiɛ sɔ maibanya kuira maɖi ite, si ɔtã sɔ ma inyɛwe aakpese ma ato masore ɔwi biara ame.” ");
INSERT INTO akp_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Lokarɛ ana sɔ ɔwi gɔ i ma Yudase ɔtura fiɛ marɔ̃ ne, marɔ̃ mayu pelepele sɔ maisibaledza ita? Ooɣo! Ɣɛɛ iki i ma iɣɛrɛ ɔso ne, iɖi ɔba itã mma loiɖe ma Yudase sɔ ɔ̃atã anɔ ɔrɛtɛ ma Yudase. ");
INSERT INTO akp_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Ma Yudase ikpi ɔso fiɛ Ɣaa ɔtã sɔ kayi ɔɖuɖu ɔna kusɛkusɛ. Si ikpi aatã kusɛkusɛ gɔgbe igbã ɔba kayiiso ne, iyɔ ɔwi gɔ i ma Yudase tsɔra aaba maakpese Ɣaa mare pelepele ne, ɔ̃ kusɛkusɛ to kuabua kusi gbaã! ");
INSERT INTO akp_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Mi ma loiɖe ma Yudase ne, loto loɣere mi sɔ ayi kumɛgɔ loɖe mi katɔ̃mesɛdze ne, loana isoɣɔ kukaakɔ i wũ karabara iso. ");
INSERT INTO akp_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Nto lonyɔ sɔ iaki nnɛgbe iso ne, wũ maturi anɔ arɛtɛ fiɛ ma mawɛ̃ ana ngbã. ");
INSERT INTO akp_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Alasɔ ɔwi gɔ i Ɣaa ɔɖi ma atsue ne, Ɣaa ɔfere ma gu kayiiso maturi kanya ndu. Ne ɔso be loaba ku ɔwi gɔ i Ɣaa aaledza ma ifɔ? Ito iase lɛ kumɛgɔ i kpise ata ɔwe ngbã. ");
INSERT INTO akp_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Alasɔ si boɖoboɖo kasɛi kawɛ̃ ga makpɛti mafɛ̃ ara matã Ɣaa ɔsekele ne, iyɔ boɖoboɖo tsɔra ana ɔsekele. Fiɛ si kudziri siɖu ɔsekele ne, iyɔ kudziri gɔmɔ akpa ana ɔsekele. ");
INSERT INTO akp_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Si mabɛse akutu kudziri ikpa iwɛ̃ i kɔ̃ iso fiɛ matu mi lɛ ipo ame kudziri ikpa kosoi manyi mamatãra sɔ si mianɛ akutu kudziri gɔmɔ ndu ne, mitsue sɔ akutu kudziri gɔmɔ siɖu ndu mito minɛ. ");
INSERT INTO akp_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Ne ɔso midaakɔlɛ so kato mipia idzirikpa nɛ mabɛse i mmɔ. Alasɔ si mibara ngbɔ ne, mitsue sɔ iiɖe mi lomɔɛ̃ siɖu mito. Ɣɛɛ siɖu siɖe lomɔɛ̃ mi sito. ");
INSERT INTO akp_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Miawo ɔɣɛ sɔ, “Adzirikpa wamɔ ɔbɛse sɔ si boamatã i ma kanya.” ");
INSERT INTO akp_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Ise ngbɔ, ɣɛɛ mitsue sɔ ma idaafɔ iɖe lotã mabɛse. Mina kamatakɔ̃ ala mi kafɔkaɖe ɔso. Ɣɛɛ nnɛmɔ si idaatã sɔ miakɔlɛ so kato ɣɛɛ minigã bowũ. ");
INSERT INTO akp_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Alasɔ si Ɣaa iimɔɛ̃ ma Yudase ma nɖe adzirikpa mɔmɔ ɔla fiɛ ɔbɛse ma ne, mibu sɔ ɔto ɔ̃aya ɔnyɔ mi kere? ");
INSERT INTO akp_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Nnɛgbe ɔte bo Ɣaa kayiribielea gu kumɛgɔ i ɔ̃ Itɔ̃me ba ɔle. Ɔ̃ Itɔ̃me ba ɔle i maturi ma lorɔ̃ kɔrɛ, fiɛ iɖe kayiribielea itã mi si miya i mi kafɔkaɖe gagbe iso teteree ɔwi ɔɖuɖu. Si miibara ngbɔ ne, Ɣaa to ɔ̃abɛse mi ɔɖi i kudziri gɔmɔ iso. ");
INSERT INTO akp_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Si ma Yudase ana ɔnyua ma idaafɔ iɖe ne, Ɣaa to ɔ̃asu ma ana ɔba ɔ̃amatãra i kudziri gɔmɔ iso. Alasɔ Ɣaa ba ɔle sɔ ɔ̃akpesera idzirikpa ɔmatãra i kudziri iso imatã. ");
INSERT INTO akp_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Mi ma loiɖe ma Yudase ne, mise lɛ ipo ame kudziri gɔ matu maba maamatãra i akutu kudziri iso. Ma Yudase ɣɛɛ ne, mase lɛ akutu kudziri gɔ mapia, ne ɔso ise pɔkɔsɔɔ itã Ɣaa sɔ ɔ̃akpesegu kɔ̃ ikpa ɔmatãra i kɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Manyii, ara wɛrɛa wa lowɛrɛ ta makuere ɔwi fiɛ loito lobie sɔ miwe i idaatsue ame pelepele fiɛ miaba miatsɛ so kato ikɔlɛ nto loɣere mi ngbe. Ne nɖe sɔ, ma Yudase mawɛ̃ atsuele gɔ mabara ne, iibase ngbɔ ɔwi biara. Ɣɛɛ atsuele gɔmɔ to ɔ̃atui ku ɔwi gɔ ame i Ɣaa ɔɔsa mma ɔɖuɖu loiɖe ma Yudase kanya fiɛ maɔyi mma ɖoɖooɖo ɔto ɔbie. ");
INSERT INTO akp_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Ɔri gɔgbe iso ne, ma Yudase ɔɖuɖu to maana iɖi lɛ kumɛgɔ i Ɣaa ɔɣɛ i Ɔko Sekelea ame sɔ, “Ɖidze to ɔ̃abɔrɛ i Sion fiɛ ɔ̃aba ɔ̃aɖi ɔtile ɔbɔrɛgu i Yakob mawa ame. ");
INSERT INTO akp_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Loamɔɛ̃ kanya ga lonyi gu ma lola ku ɔwi gɔ loaɖi ma lobɔrɛgu i ma akpi ame.” ");
INSERT INTO akp_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Ma Yudase ɖe Ɣaa matsirise alasɔ maifɔ Itɔ̃me Bielea maɖe. Ne ɔso ne, mi ma loiɖe ma Yudase ɔna kayakpa. Ɣɛɛ gɔ Ɣaa ɔɖi ma ɔso ne, ɔto ɔɖɔɛ ma gu ma mawa kuerekuere. ");
INSERT INTO akp_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Alasɔ si ɔɖi ɔturi ɔrere ɣee ɔbara wũ abualɛra arere ne, ɔ̃isɛ ɔfinikira ɔ̃ adzuni i ngɔmɔ iso. ");
INSERT INTO akp_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Mi ma loiɖe ma Yudase ne, kumɛgɔ miɣɛrɛ Ɣaa ɔwi gɔ lofe ame ɣɛɛ kiniɔ ne, Ɣaa ɔnyɔ mi nnya i ma Yudase atsuele ɔso ne, ");
INSERT INTO akp_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ngbɔ ame ɔ̃anyɔ ma Yudase ma wũ nnya i ma atsuele ame ne. ");
INSERT INTO akp_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Ɣaa ɔpia maturi ɔɖuɖu iyo ala ma atsuele ɔso sɔ si ɔ̃anyɔ ma ɔɖuɖu nnya. ");
INSERT INTO akp_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Ɣaa ɔmɔ gbaã fiɛ ara sɛɛ ɔɖuɖu ɔbɔrɛ i ɔ̃ kɔrɛ. Gbaã ne, ɔ̃ inɔgba ame ɔwodoro kukaakɔ. Kuwɛ̃ iibatsue ɔri gɔ iso i Ɣaa sɛ ɔɣɛ ɔ̃ atɔ̃me ɔkigu karɔ̃. Fiɛ kuwɛ̃ iibanɔ siri dzɛ iso ɔsɛ ɔbara ɔ̃ ara ɔkigu. ");
INSERT INTO akp_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Ngbɔ ame i Ɔko Sekelea ɔɣɛ sɔ, “Nna nɣe Bosate iti ame ɔwi gɔ lofe? Fiɛ nna nɣe ɔ̃ adzuni?” ");
INSERT INTO akp_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","“Nna lotã Ɣaa ira ɔwi gɔ lofe sɔ Ɣaa to wũ kuso?” ");
INSERT INTO akp_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Ara ɔɖuɖu ne, Ɣaa are aɖe. Ɔ̃ mɔmɔ iso aki aba fiɛ ɔ̃ are aɖe. Mitã bokɔlɛ ɔ̃ iyere ita i kiniɔ ito ikɛlɛ ɔɖuɖu. Si iba ngbɔ. ");
INSERT INTO akp_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Ne ɔso ne, wũ manyii, kumɛgɔ i Ɣaa ɔbara bo kayiribielea ɔso ne, loto mi i kukpa sɔ misu so mitã Ɣaa lɛ ara wa masu masɔrɛ wũ, wa losekele fiɛ abo wũ anɔ i mi ngbã isɛ ame. Nnɛmɔ nɖe mi siwarã ame karabara ne. ");
INSERT INTO akp_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Midaasɛ ngbã sɔ miabara mawɛ̃ ku kayiiso kurabarara. Ɣɛɛ mitã sɔ Ɣaa afinikira mi adzuni ɔɖuɖu si mikpese maturi ɣɛtɛ. Ne loatã sɔ mianya ara wa nsɛ apia Ɣaa isoɣɔ gu nwa miabara fiɛ miabo wũ anɔ fiɛ ayi pɔpɔɔpɔ ne. ");
INSERT INTO akp_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Iki i karabara ga ɔtã me i ɔ̃ abualɛra ɔso ne, nto loɣere mi ɔɖuɖu sɔ midaakɔlɛ so kato miɖo kumɛgɔ mise. Ɣɛɛ ne, i mi adzuni ame ne mite sɔ mibɔ so karɔ̃ mitã ɔbiara kɛkɛ si miasu so mikoteragu kafɔkaɖe ga miba kanya. ");
INSERT INTO akp_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Kumɛgɔ i bo kuturidziri ɖe kuwɛ̃ gɔ mba ngɔi gbodzoo mɛ loisɛ mibara karabara kawɛ̃ saã ne, ");
INSERT INTO akp_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ngbɔ ame boɖe maturi gbodzoo i Kristo ame ɣɛɛ bo ɔɖuɖu ɔgɔgɔda so lɛ sosina siwɛ̃ dzɛ mma ngɔi gbodzoo ne. ");
INSERT INTO akp_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Ne ɔso ne, mitã bosu Siwarã ame karatã agbãagbã wa i Ɣaa ɔki i ɔ̃ abualɛra ame ɔsu ɔtã bo bobara ala karabara. Si ɔturi karatã nɖe sɔ ɔ̃aɣɛ Ɣaa Itɔ̃me ne, ikote sɔ ɔ̃aɣɛ ne ku kafɔkaɖe ga ɔɖuɖu i Ɣaa ɔta wũ. ");
INSERT INTO akp_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Si fɔ karatã nɖe maturi kasumu ne, pia kubɛ si asumu. Si ara ite ne, te ku fɔ iso ɔle ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Si katetere ipia maturi ne, pia katetere. Si ara itã maturi ne, bara ne ku kayiri ɣɔa. Si maturi ikɔkɔ ne, su fɔ iwola ɔɖuɖu kɔ ma. Si nnyainyɔ ne, nyɔ nnya ku fɔ ɔtu ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Miɖi mi kuɖɔɛ karabara mite maturi. Misɛ̃ ikpi si mimɔɛ̃ isɛɛ ibara mila. ");
INSERT INTO akp_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Miɖɔɛ so ku ɔtu ɣɔa lɛ manyii fɔɖedze awe. Warɛ fɔ ɔlaa ɖo so. ");
INSERT INTO akp_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Midaawe ndã ɣɛɛ mitã Siwarã Bielea si siyi mi ame pɔpɔɔpɔ i ɔ̃ karabara iso. ");
INSERT INTO akp_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","So si siɣɔ mi i mi ɔriinyɔ ame. Miya teteree i inyɛwe biara ame si mikparama kayi ɔwi biara iso. ");
INSERT INTO akp_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Miɣɛ mi iso ara mitã Ɣaa maturi ma nna kuira, si miwarɛ nrɔɔ̃ mifɔ mafɔ. ");
INSERT INTO akp_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Mma nto makpɛ̃gu mi ne, mitã ma kusɛkusɛ. Mitã ma kusɛkusɛ, midaagbarĩ ma. ");
INSERT INTO akp_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Mina isoɣɔ ku mma nto mana isoɣɔ si mibiɛ ku mma nto mabiɛ. ");
INSERT INTO akp_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Minɔgu mi manyii ara karɔ̃. Midaakɔlɛ so kato, mibɔ so karɔ̃ misakanya ku mma loire kuira i maturi anɔ. Daanyɔ so sɔ alɛ aɖo matsɔra. ");
INSERT INTO akp_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Midaabara ikpi miti kuso. Mibara ara wa loakɔlɛ mi anɔ kato i maturi ɔɖuɖu katɔ̃. ");
INSERT INTO akp_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Si iabɔrɛ i mi kɔrɛ ne, miwe i isobuɛ ame ku maturi ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Manyii, midaasu kuwɛ̃ ikpi mitã wũ kuso ɣɛɛ mitã Ɣaa ɔri si ɔɖi ɔ̃ sikpã ɔte i ngɔmɔ iso, alasɔ Ɣaa ɔɣɛ i Ɔko Sekelea me sɔ, “Mme nɖe ngɔ loakarɛ mi iti, mme nɖe ngɔ loati kuso.” ");
INSERT INTO akp_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Ɣɛɛ i Ɔko Sekelea ame ne, maɣere bo sɔ, “Si kukã to fɔ tsirise ne, tã wũ araɖea si ɔɖe. Si ɔme to ɔkore wũ ne, tã wũ ndu ɔnɛ. Alasɔ si abara ngbɔ ne, ato asia inyɛdu ɔtɔ i ɔ̃ iti iso.” ");
INSERT INTO akp_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Midaatã ikpi si iɖe mi iso, ɣɛɛ misu isɛ miɖe ikpi iso. ");
INSERT INTO akp_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Ikote sɔ ɔturi biara aasu kuwarɛ ɔtã karɔ̃ iso matɔ̃ɖedze. Alasɔ matɔ̃ɖedze ma mpia kiniɔ ne, Ɣaa mɔmɔ losɛra ma. ");
INSERT INTO akp_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Si ɔrere ɔta ɔya ma iso ne, Ɣaa ira nɛ ɔsɛ iso iɖe ɔta ɔya. Fiɛ mma loabara ngbɔ ne, mato mabie atɔ̃me iɣɛgu matã so. ");
INSERT INTO akp_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Maturi ma nsɛ mabara isɛɛ ne, maibanigã matɔ̃ɖedze, ɣɛɛ mma nsɛ mabara ara lalaa loanigã. Si mito mibie sɔ miibanigã tɔ̃ɖedze ne, mibara ara wa loatã sɔ ɔ̃ale mi. ");
INSERT INTO akp_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Alasɔ Ɣaa rabaradze ɔɖe sɔ ɔ̃abara nnɛ loalɛ itã- ɔ. Ɣɛɛ si abara ikpi ne, iyɔ ikote sɔ aanigã wũ. Alasɔ iiɖe siefe kere iɖe matã wũ ɔle. Ɣaa ɔɖabo ɔɖe. Ɔ̃ nsɛ ɔnyɔ sɔ ɔbiara ɔbara ara i ɔri gɔ lokote iso fiɛ ɔ̃akpadzɛ̃ matsuelese kutsue. ");
INSERT INTO akp_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Ne ɔso mibɔ so karɔ̃ mitã matɔ̃ɖedze. Iiɖe Ɣaa sikpã dzɛ loaba mi iso ɔso ɣɛɛ mi mɔmɔ kaɣere ɔso. ");
INSERT INTO akp_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Nnɛgbe ana ɔso fiɛ misɛ mitã lampo mitã matɔ̃ɖedze alasɔ Ɣaa karabara mato mabara ne. Masu ma ɔwi ɔɖuɖu matã maturi ikɔkɔ. ");
INSERT INTO akp_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Ne ɔso ne, mitã ɔbiara ɔ̃ kuso gɔ mito wũ. Si kaɖe toto masia ne, mitã, si lampo ɔɖe ana ne, ɔ̃ wũ mitã. Ngɔ lokote ɔtã iwarɛ ne, miwarɛ wũ. Ngɔ ile lokotegu ana ne, ɔ̃ wũ mile wũ. ");
INSERT INTO akp_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Si mito ɔrere kuso ne, midaasɛ̃ sɔ miito mitã. Tã kɔ̃ ɔɖuɖu ro. Ɣɛɛ kuso gɔ si mila mi malaa nɖe kuɖɔɛ kuso. Alasɔ ɔbiara gɔ mba kuɖɔɛ ɔtã ɔ̃ ɔlaa ne, ite sɔ ɔto ɔkã Ɣaa mmara atsue. ");
INSERT INTO akp_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Mmara mɛ matã bo sɔ, “Daabara asɔrɔ̃ra, daaɖoe ɔturi, daayu kayu, fɔ anɔ si adaarɛtɛ i ɔturi kuira iso,” ku mmara mama mɛ lobua i mmɛgbe iso ne, me ɔɖuɖu itera nɛ lobua me iso kere nɖe sɔ, “Ɖɔɛ fɔ ɔlaa lɛ kumɛgɔ ato aɖɔɛ so.” ");
INSERT INTO akp_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Kuɖɔɛ iisɛ kubara kɔ̃ ɔlaa ikpi. Ne ɔso kuɖɔɛ nɖe ira nɛ iso matsue mmara ɔɖuɖu masia. ");
INSERT INTO akp_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Mirɛgɛ̃! Si misɛ i ɔri gɔgbe iso alasɔ miɣe ɔwi gɔ ame bopia. Ɔwi gɔ ame i Ɣaa aaɖi bo ɔɔbore ɔmatã ɔɖo ɔwi gɔ ame boɖe katɔ̃ bofɔ Kristo boɖe. ");
INSERT INTO akp_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Kasɛ̃ ɔɔfe karo, ɔɖesɛrã ɔɔɣo. Ne ɔso minyua idududu ame ara ɔbara, si minyi so akpadza lɛ mma mpia i ikpawaĩ ame. ");
INSERT INTO akp_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Mimɔɛ̃ so mila kukaakɔ lɛ mma nsɛ i ikpawaĩ ame. Iiɖe ɔɖegbodzo, itarɛ̃ gu asɔrɔ̃ra gu amumuɣɔ gu iɣɛɣɛ so gu anɔ ikɛkɛ ame. ");
INSERT INTO akp_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Ɣɛɛ misu Yesu Kristo mipia lɛ awu si mimɔɛ̃ adzuni miɖi i sosina ɔrakolo gu ara wa nna kusia iso. ");
INSERT INTO akp_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Miwarɛ nrɔɔ̃ mifɔ mi malaa ma loire siɖu i kafɔkaɖe ame. Midaawararãgu ma i ara wa i mi gu ma adzuni iibara awɛ̃ iso. ");
INSERT INTO akp_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Ɔturi ɔmɔi kafɔkaɖe ɔtã wũ ɔri sɔ ɔ̃aɖe ira biara. Ɣɛɛ ɔmama gɔ kafɔkaɖe nna ɔle ngbɔ ne, araɖea wa ame maipia sina kere ɔsɛ ɔɖe. ");
INSERT INTO akp_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Ngɔ nsɛ ɔɖe ira biara ne, ɔdaanyɔ ɔ̃ ɔnyii gɔ nsɛ ɔrɛrɛ ara ala ɔ̃ kafɔkaɖe ɔso sɔ ɔ̃iyi. Ngɔ nsɛ ɔrɛrɛ ara ana si ɔdaanyɔ ngɔ nsɛ ɔɖe ira biara pupurii, alasɔ Ɣaa ɔfɔ wũ ɔ̃ wũ. ");
INSERT INTO akp_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Nna lotã-ɔ ɔri sɔ aɣɛgu ɔturi mama ɔɖabo atɔ̃me? Ɔ̃ Ɣaa mɔmɔ loawo nyɔ si ɔɣɛ ɔtã wũ teteree ɣee ɔ̃iɣɛ. Fiɛ ɔɖabo gɔmɔ to ɔ̃aya alasɔ Bosate to ɔ̃awo tã sɔ ɔ̃aya teteree. ");
INSERT INTO akp_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Ɔturi ɔmɔi sɛ ɔwarɛ iyi iwɛ̃ sɔ isekele iɖo imama. Ɔmɔi ana sɛ ɔnyɔ sɔ wã ɔɖuɖu ɔkote. Ira nɛ lonya iɖo nɖe sɔ ɔbiara aafɔ ɔɖe kukaakɔ i nnɛ ɔto ɔbara iso. ");
INSERT INTO akp_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Ngɔ nsɛ ɔwarɛ iyi iwɛ̃ ne, Bosate ɔto ɔwarɛ ne ɔtã. Ngɔ nsɛ ɔɖe ira biara ana ne, Bosate ɔsɛ ɔwarɛ alasɔ ɔsɛ ɔpɛ Ɣaa siba i wã iti. Ngɔ loisɛ ɔɖe ara awɛ̃ ana ne, ɔsɛ̃ ara wagbe si ɔsu ɔwarɛ Bosate. Ɔ̃ wũ ɔsɛ ɔpɛ Ɣaa siba. ");
INSERT INTO akp_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Bo kuwɛ̃ iisi ngbã ɔtã so. Fiɛ bo kuwɛ̃ ana iibakpi ɔtã so. ");
INSERT INTO akp_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Si bosi ngba ne, bosi botã Bosate. Si bokpi ana ne, bokpi botã Bosate. Ne ɔso ngbã bosi o-o, ɔkpi bokpi o-o ne, Bosate mare boɖe. ");
INSERT INTO akp_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Nnɛgbe ana ɔso fiɛ Kristo ɔkpi fiɛ ɔledza ita ibɔrɛ i makpise ame ɔpia ngbã sɔ si ɔ̃akpese Ɔkɔse i makpise gu magbanadze ɔɖuɖu iso ne. ");
INSERT INTO akp_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Be ɔso fiɛ ato atã fɔ ɔnyii ipɔ? Ɣee be ɔso fiɛ ato awɔdza fɔ ɔnyii irɔĩ sɔ ɔ̃iyi? Bo ɔɖuɖu to boaya i Ɣaa sigaraiyara katɔ̃ fiɛ ɔ̃aɣɛgu bo atɔ̃me. ");
INSERT INTO akp_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Alasɔ matsɛrɛ sɔ, “Bosate sɔ, ‘Ayi kumɛgɔ losi ngbã ne, nto loɣere mi sɔ, ɔbiara to ɔ̃apɛ agɛgɛ̃ ɔtã me Fiɛ ɔbiara to ɔ̃akɔlɛ wũ iyere kato sɔ me nɖe Ɣaa.’ ” ");
INSERT INTO akp_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Ne ɔso ne, bo ndɛ̃ ɔbiara to ɔ̃atã ɔ̃ ngbã iso akɔnta i Ɣaa kɔrɛ. ");
INSERT INTO akp_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Ne ɔso mitã bonyua so atɔ̃me ɔɣɛgu. Si bonyɔ kumɛgɔ boabara mawɛ̃ sɔ boibaɖe ɔri itɛ̃ra botã kuwɛ̃ kafɔkaɖe sɔ ɔ̃atura ɔbo i ikpi ame. ");
INSERT INTO akp_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Gɔ lopia i Bosate Yesu ame ɔso ne, loɣe kukaakɔ i wũ ɔtu ame sɔ araɖea kuawɛ̃ i wã mɔmɔ ame iipukutu. Ɣɛɛ si ɔrere ɔnya sɔ irere ɔpukutu ne, nnɛmɔ loapukutura wũ ne. ");
INSERT INTO akp_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Si aɣe sɔ nnɛ ato aɖe to iɖaa fɔ ɔnyii ne, iyɔ iiɖe kuɖɔɛ ato aɖi ate wũ. Daatã sɔ nnɛ ato aɖe aanina fɔ ɔnyii kafɔkaɖe alasɔ Kristo ɔkpi i ɔ̃ wũ ɔ̃ iti. ");
INSERT INTO akp_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Midaatã sɔ maturi aɖe ika i ira nɛ i mi minyɔ sɔ ilɛ i Ɣaa maturi ndɛ̃ iso. ");
INSERT INTO akp_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Alasɔ Ɣaa sigarakaɖekɔ̃ ame ne, iiɖe ɔɖe gu ɔnɛ ɔɖe. Ɣɛɛ sibɔlɔlɔ gu isobuɛ gu isoɣɔ i Siwarã Bielea ame iɖe. ");
INSERT INTO akp_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Alasɔ ngɔ nsɛ ɔbara Kristo karabara i ɔri gɔgbe iso ne, ɔ̃ nsɛ ɔbo Ɣaa gu maturi anɔ fiɛ masɛ wawarɛ wũ ne. ");
INSERT INTO akp_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Ne ɔso mitã bonyɔ kukaakɔ sɔ boabara ara wa loabɔ isobuɛ fiɛ aabuai bopia so ɔle. ");
INSERT INTO akp_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Midaanina Ɣaa karabara ala araɖea ɔso. Araɖea biara iso ɔkpa, ɣɛɛ ne, iilɛ si nnɛ aaɖe aatã sɔ ɔturi aatura ɔbɔrɛ ɔrɔ̃ ɔbo i ikpi ame. ");
INSERT INTO akp_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Si aito aɖe sina ɣee anɛ ndã mɔɛ̃a ɣee abara kuira nɛ loatã sɔ fɔ ɔnyii aarɔ̃ ɔbo i ikpi ame ne, ibua ilɛ. ");
INSERT INTO akp_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Ne ɔso ara wa afɔ aɖe i nwagbe iso ne, tã awe i mi gu Ɣaa inyɔ ndɛ̃. So to siaɣɔ ngɔ nsɛ ɔbara ara wa i ɔ̃ kaɣere iisɛ katã wũ ipɔ. ");
INSERT INTO akp_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Ɣɛɛ si ɔturi to ɔɖe ira fiɛ ɔ̃ kaɣere ɔta kaɣɛ i ne iso ne, ɔ̃ɔtã so ipɔ koko alasɔ, ɔ̃ikã ɔ̃ kaɣere atsue i kafɔkaɖe ame. Ira biara nɛ i ɔturi iibara i kafɔkaɖe ame ne, iɖe wũ ikpi. ");
INSERT INTO akp_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Bo ma loɔmɔ i kafɔkaɖe ame koko ne, ikote sɔ boana ɔtu botã mma kafɔkaɖe loimɔ fiɛ mana ɔle bobuai ma. Iikote sɔ boabara ara wa loaɣɔ bo ɔnɔwɛ̃ so. ");
INSERT INTO akp_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Ikote sɔ bo ndɛ̃ ɔbiara aabara ira nɛ loaɣɔ ɔ̃ ɔlaa so sɔ iatã sɔ ɔ̃are iti i Siwarã ame. ");
INSERT INTO akp_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Alasɔ nane Kristo kɔra ne, iiɖe nnɛ loaɣɔ wũ so iɖe ɔbara. Ɣɛɛ matsɛrɛ i ɔ̃ iso sɔ ɔɣere Ɣaa sɔ, “Sitia dzɛ i maturi ɔtia-ɔ ne, sɛ̃ ɔɖuɖu ɔba i wũ iso.” ");
INSERT INTO akp_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Ara wa ɔɖuɖu matsɛrɛ masɛ ku ɔwi gɔ lofe ame ne, matsɛrɛ masɛ sɔ si iate bo ara sɔ si boya teteree, si ila iɔpia bo ɔle sɔ bo anɔ aasia i nnɛ boto bonyɔ ɔri iso. ");
INSERT INTO akp_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Nto lokarɛ Ɣaa sɔ ɔbuai bo sɔ boawo ɔya teteree i inyɛwe biara kanya sɔ boabara nnɛ i Bosate Kristo Yesu sɛ ɔɖɔɛ iso. ");
INSERT INTO akp_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Iyɔ mi ɔɖuɖu situ gu kanya aaɖe kawɛ̃ sɔ miasu ile mitã Ɣaa gɔ nɖe Bosate Yesu Kristo Ɔse. ");
INSERT INTO akp_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Ne ɔso miwarɛ nrɔɔ̃ mifɔ mi manyii lɛ kumɛgɔ i Kristo ɔwarɛ ɔ̃ mire ɔfɔ mi ala ne loatã Ɣaa kuwarɛ ne. ");
INSERT INTO akp_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Lobie sɔ loɣere mi sekelee sɔ Kristo ɔba ɔ̃akpese ma Yudase ɔɖabo sɔ si ɔ̃aɖi kaɣɛkasɛ ga i Ɣaa ɔɣere ma Yudase mawa tɛtɛ ɔte sɔ Ɣaa sɛ ɔbara i ɔ̃ nnɛ ɔɣɛ ɔsɛ iso. ");
INSERT INTO akp_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Ɣaa Itɔ̃me nɛgbe aatã sɔ mma loiɖe ma Yudase ana aale Ɣaa i ɔ̃ nnyainyɔ ɔso. Ɣaa kanyaɖidze ɔwɛ̃ ɔɣɛ i Ɔko Sekelea ame sɔ, “Nnɛgbe ɔso loale-ɔ i mma loiɖe ma Yudase ndɛ̃ ne. Loasu kafɔkaɖe sinɔ lole fɔ iyere.” ");
INSERT INTO akp_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Fiɛ maledza iɣɛ sɔ, “Mi ma loiɖe ma Yudase, minagu Ɣaa maturi isoɣɔ.” ");
INSERT INTO akp_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Maledza iɣɛ ana sɔ, “Mi ma loiɖe ma Yudase ɔɖuɖu si mile Bosate. Si mi abuiti ɔɖuɖu maturi si miɖi sinɔ dzɛ loale wũ.” ");
INSERT INTO akp_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Yesaya ana ɔledza itsɛrɛ sɔ, “Yese ɔdziriɖu to ɔ̃atata. Fiɛ ɔ̃ loaɖe ngɔ loata ɔya ɔɖe sigara i abuiti ɔɖuɖu maturi iso ne. Mma loiɖe ma Yudase to maawe ɔriinyɔ i ɔ̃ ame.” ");
INSERT INTO akp_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Lokarɛ Ɣaa gɔ nɖe bo ɔriinyɔ sɔ ɔtã sɔ so aaɣɔ mi ta kame ame ɔɖuɖu si ɔtã mi isobuɛ lɛ kumɛgɔ misu so mitã wũ kanya sɔ, Siwarã Bielea ɔle si sitã sɔ miawe i ɔriinyɔ ame ɔwi biara. ");
INSERT INTO akp_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Manyii, mme mɔmɔ lofɔ loɖe sɔ miyi ku ara sɛɛ ibara pɔpɔɔpɔ. Miɣe ara wagbe ɔɖuɖu ne ɔso mite so. ");
INSERT INTO akp_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","I ɔko gɔgbe ame ne, loɣara so lotsɛrɛ ara wagbe sɔ si lonyigira mi ara wa iki i Ɣaa abualɛra ame lobara. ");
INSERT INTO akp_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Alasɔ ɔbara me sɔ lokpese Kristo rabaradze lotã mma loiɖe ma Yudase. Lobara kasumu karabara ga nɖe Ɣaa Itɔ̃me iɣɛ itã mma loiɖe ma Yudase sɔ loakɔ ma loba loakpesera Ɣaa ara fɛ̃a wa i Siwarã Bielea ɔbara sekelee i Ɣaa anɔ. ");
INSERT INTO akp_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Loawo ndamu ɔɖe i ara wa i Yesu Kristo ɔbara ɔkigu i wũ karabara ga loto lobara lotã Ɣaa ɔso. ");
INSERT INTO akp_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Loibaɖe ndamu i kuira mama kuiwɛ̃ iso iɖo nnɛ i Kristo ɔbara ɔkigu i wũ iso. Ɔtã sɔ lokɔ mma loiɖe ma Yudase lobɔ Ɣaa kɔrɛ sɔ si maaɖe Ɣaa mare iki ara wa loɣere ma fiɛ lobara ana ɔso. ");
INSERT INTO akp_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Nnɛgbe ɔba i ne ame iki i awawãra wa manya gu Ɣaa ɔle karabara ga ɔtã lobara ɔso. Ne ɔso ita i Yerusalem isɛ iabɔrɛ i Iliriko ndɛ̃ mmɔ ɔɖuɖu ne, loɣɛ Kristo Itɔ̃me Bielea nɛgbe. ");
INSERT INTO akp_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Ta kokooko ne, anɔ ɔrɛtɛ me sɔ loaɣɛ Ɣaa Itɔ̃me i ngbegɔ maiɣe Kristo. Alasɔ loibie sɔ loatsue ibere losia i kuwɛ̃ kabereku ga ɔpia i karɔ̃ ame ɔsɛ iso. ");
INSERT INTO akp_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Ɣɛɛ ira nɛ matsɛrɛ masɛ i Ɔko Sekelea ame sɔ, “Mma maiɣere ɔ̃ iso Itɔ̃me ku ɔwi gɔ lofe ne, mato maatsue wũ. Fiɛ mma loinɔ kuira ku ɔwi gɔ lofe ne, ma loanɔ karɔ̃ ne.” ");
INSERT INTO akp_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Karabara gagbe lotɛ̃ra me ɔri ɔso fiɛ loiwo mi kɔrɛ ɔba ne. ");
INSERT INTO akp_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Ɣɛɛ kiniɔ gɔ loɔro karabara ga i ibuiti nɛgbe ame fiɛ akɔ gbodzoo nɖe nwagbe gɔ loto lobie sɔ loaba loanya mi ɔso ne, ");
INSERT INTO akp_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","lobara adzuni sɔ loaki i mi kɔrɛ si loto lofe Spania. Lobie sɔ loaki i mi kɔrɛ lowarã kɛkɛĩ bopia so ɔle fiɛ ka miaɖi me ɔri. ");
INSERT INTO akp_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Ɣɛɛ tɔtɔ ne, losɛ Yerusalem losu karatã lokɛlɛgu Ɣaa maturi i mmɔ. ");
INSERT INTO akp_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Alasɔ mafɔɖedze ma mpia i Makedonia gu Akaia ne, imɔɛ̃ ma ɔtu sɔ maato sikã matã mafɔɖedze wɛrɛba ma mpia i Yerusalem. ");
INSERT INTO akp_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Iba ma ɔmɛrɛ̃ sɔ maabara ngbɔ. Fiɛ mato ma kuso gbaã! Alasɔ si mma loiɖe ma Yudase ɔna kaɖekɔ̃ i ma Yudase siwarã ame ara sɛɛ ame ne, mitsue sɔ ma wũ ne, ikote sɔ maabuai ma Yudase ku ma karana. ");
INSERT INTO akp_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Ne ɔso si losu ara wa mato ngbe lokɛlɛgu ma lokpese ne, loto loaki i mi kɔrɛ lokɛlɛ Spania. ");
INSERT INTO akp_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Loɣe sɔ si loto loba mi kɔrɛ ne, loto loasɛgu Kristo kusɛkusɛ ɔɖuɖu lobɔ mi. ");
INSERT INTO akp_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Manyii, loto mi i kukpa i Bosate Yesu Kristo iyere ame gu Siwarã Bielea kuɖɔɛ ame sɔ mibuai me i kakpã ga kanya loɣɛ sɔ loana ɔle iki i mi kayi ikparama ame. ");
INSERT INTO akp_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Mikarɛ Ɣaa mitã me sɔ ɔ̃aɖi me ɔbɔrɛgu i ma Yudase ma losɛ̃ kafɔkaɖe nrɔɔ̃ ame sɔ wũ karabara i Yerusalem aabo Ɣaa maturi anɔ. ");
INSERT INTO akp_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Fiɛ si Ɣaa ɔbie ne, loaba loabo i mi ndɛ̃ ku isoɣɔ fiɛ loawarã i mmɔ. ");
INSERT INTO akp_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Ɣaa gɔ nsɛ ɔtã isobuɛ si ɔwegu mi ɔɖuɖu. Si iba ngbɔ. ");
INSERT INTO akp_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Loɖi bo ɔnyiiko Foibe lote mi. Ɔɖe buaidze i Kenkrea mafɔɖedze ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Loto mi i kukpa sɔ miwarɛ nrɔɔ̃ mifɔ wũ i Bosate iyere ame i ɔri gɔ lokote Ɣaa maturi iso. Mitã wũ ibuai biara nɛ ɔ̃abie ɔbɔrɛgu i mi kɔrɛ alasɔ ɔbuai maturi gbodzoo gu me ana. ");
INSERT INTO akp_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Loya Priska gu Akwila ma nɖe wũ marabaradze laa i Kristo Yesu ame. ");
INSERT INTO akp_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Mayagu me teteree sɔ maakpi i wũ iti kɔra. Iiɖe wũ ɔnɔwɛ̃ me nto lopɛ ma siba ɣɛɛ mma loiɖe ma Yudase mafɔɖedze ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Loya mafɔɖedze ma nsɛ masarɛ i ma iyo mmɔ ana. Miya wũ ɔlaa Epaineto gɔ loɖe katɔ̃ ɔfiniki ɔfɔ Kristo i Asia karɔ̃ iso. ");
INSERT INTO akp_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Loya Maria gɔ lobara karabara teteree i mi ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Loya Androniko gu Yunia ma nɖe wũ aɖe maturi ma bo gu ma inyɔ lowe i iyo. Maturi ma lofɔ iyere maɖe i katɔ̃memasɛdze ndɛ̃. Maɖe me katɔ̃ i Kristo ifɔ ame. ");
INSERT INTO akp_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Loya Amplia gɔ nɖe wũ ɖɔɛse i Bosate iyere ame. ");
INSERT INTO akp_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Loya Urbana gɔ nɖe bo rabaradze laa i Kristo ame. Loya wũ ɔlaa Staki. ");
INSERT INTO akp_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Loya Apele gɔ makere manyɔ fiɛ ɔya i Kristo ame. Loya Aristobulo iyo maturi ɔɖuɖu. ");
INSERT INTO akp_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Loya Herodian, wũ aɖe ɔturi. Loya Narkiso iyo maturi ma losu so matã Bosate. ");
INSERT INTO akp_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Ya Trifaina gu Trifosa, marɔ̃go rabaradze i Bosate ame. Loya wũ ɔlaa ɖɔɛse Persi gɔ nɖe ɔrɔ̃go mama gɔ nto ɔbara karabara teteree i Bosate ame. ");
INSERT INTO akp_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Loya Rufo gɔ lofɔ iyere i Bosate ame gu ɔ̃ ɔnyi gɔ lomɔɛ̃ me lɛ ɔ̃ ɔbi awe. ");
INSERT INTO akp_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Loya Asinkrito gu Flegon gu Herme gu Patroba gu Herma gu ma manyii fɔɖedze ma mpiagu ma. ");
INSERT INTO akp_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Loya Fologo gu Yulia gu Nerea gu ɔ̃ ɔnyiiko gu Olimpa gu Ɣaa maturi ma mpiagu ma. ");
INSERT INTO akp_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Miya so ku kɔrɔ̃ ipia i kuɖɔɛ gu isekele ame. Kristo mafɔɖedze akuri wa ɔɖuɖu mpia i Kreta sɔ maya mi o-o. ");
INSERT INTO akp_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Manyii, lobie sɔ loka mi kukaakɔ sɔ minyɔ so i mma loasu iɣɛɣɛso mapia i maturi ndɛ̃ iso. Masu ara wa lota aɣɛ i nwa bote mi iso mato matɛ̃ mi ɔri. Mibɛse so i ma iso. ");
INSERT INTO akp_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Alasɔ mmamɔ igbã ne, iiɖe Bosate Yesu Kristo karabara mato mabara. Ɣɛɛ ma mɔmɔ kuɖɔɛ mato mabara. Maba ɔnyamɛrɛ̃ gu kasɔla ga maasu makpɔkpɔtɔra mma loiɣe kuira adzuni. ");
INSERT INTO akp_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Ɔturi biara ɔnɔ kumɛgɔ mikã Itɔ̃me Bielea atsue, ne ɔso so ɔɣɔ me gbaã i mi iso. Ɣɛɛ nnɛ loto lobie lotã mi nɖe sɔ mi anɔ aabusi i isɛɛ ibara iso, ɣɛɛ ikpi iso ne, miaɖe mma loiɣe kuira. ");
INSERT INTO akp_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Ɣaa gɔ nɖe isobuɛ tãse si ɔkɔtɛ Tsirise ɖɛkpɛrɛɛ si ɔtã sɔ miaɖe wũ iso i ɔwi kurukutu ame. Bosate Yesu Kristo abualɛra si awegu mi. ");
INSERT INTO akp_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timoteo gɔ nɖe wũ rabaradze laa ɔya mi. Ngbɔ ame ana i Lukio gu Yason gu Sosipatro ma nɖe wũ maturi ɔya mi ne. ");
INSERT INTO akp_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Mme Tertio gɔ lotsɛrɛ ɔko gɔgbe lotã Paulo ana loya mi i Bosate iyere ame. ");
INSERT INTO akp_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gaio gɔ lofɔ bo kukaakɔ ngbe gu mafɔɖedze ɔɖuɖu ma nsɛ masarɛ i ɔ̃ iyo ɔya mi. Erasto gɔ nɖe ɔmagɛ̃ gɔgbe sikãladze gu bo ɔnyii Kwarto sɔ maya mi. ");
INSERT INTO akp_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Bosate Yesu Kristo abualɛra si awegu mi ɔɖuɖu. Si iba ngbɔ. ");
INSERT INTO akp_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Kiniɔ ne, mitã bole Ɣaa. Ɔto ɔ̃awo mi ɔmɔɛ̃ ɔla teteree iki i Itɔ̃me Bielea nɛ lobɔrɛ i Bosate Yesu Kristo iso. Itɔ̃me Bielea nɛgbe ɔse i ara wɛrɛa wa i Ɣaa to ɔɖi ɔbɔrɛgu i ngbegɔ awe akɔ gbodzoo wa lofe ame. ");
INSERT INTO akp_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Ɣɛɛ kiniɔ ne, maɔɖi wã mabɔ ɔgbami itã maturi ɔɖuɖu karɔ̃ inɔ, ara wa i kanyamaɖidze ɔtsɛrɛ masɛ. Ɣaa gɔ mba ngbã ɔwi ɖaa kuɖɔɛ kuɖe sɔ maaɣɛ Itɔ̃me nɛgbe i abuiti ɔɖuɖu ame fiɛ maafɔ maɖe mabara i ne iso. ");
INSERT INTO akp_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Ɣaa gɔ ɔnɔwɛ̃ inɔgba loyi ne, ikote sɔ boale wũ ita i kiniɔ ito ikɛlɛ ɔwi ɔɖuɖu i Kristo Yesu iyere ame. Si iba ngbɔ. ");
INSERT INTO akp_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Mme Paulo gɔ iki i Ɣaa mɔmɔ kuɖɔɛ ame loɖe Yesu Kristo Katɔ̃mesɛdze gu bo ɔnyiibi Sostene lotsɛrɛ mi ɔko gɔgbe. ");
INSERT INTO akp_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Boto botsɛrɛ ɔko gɔgbe botã Korinto mafɔɖedze ma iki i Yesu Kristo iso ne, Ɣaa ɔɖi ma ɔsɛ ɔtã so. Ɔkpere ma sɔ maaɖe ɔ̃ maturi Sekelea lɛ kumɛgɔ ɔkpere mma ɔɖuɖu ana nsɛ makpere Bosate Yesu Kristo. Ɔ̃ nɖe bo gu ma ɔɖuɖu Ɔkɔse ne. ");
INSERT INTO akp_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Bo Ɔse Ɣaa gu Bosate Yesu Kristo si matã mi abualɛra gu isobuɛ. ");
INSERT INTO akp_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Nsɛ lopɛ Ɣaa siba ɔwi biara i mi iti ala nnyainyɔ nɛ ɔtã mi iki i Yesu Kristo iso. ");
INSERT INTO akp_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Gɔ mibara mawɛ̃ ku Kristo ɔso ne, miɔsɛ katɔ̃ i ira biara ame, ta ikaɖe ɔɖuɖu gu inɔgba ɔɖuɖu ame. ");
INSERT INTO akp_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Kristo iso itɔ̃me ana ɔɔre siɖu i mi ame kukaakɔ. ");
INSERT INTO akp_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Ne ɔso ne, siwarã ame karatã kukawɛ̃ iibo mi kusa gɔ misi misia Ɣaa sɔ ɔ̃atã Bosate Yesu Kristo ɔledza iba. ");
INSERT INTO akp_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Ɔto ɔ̃adzuɛ̃ mi gɔ mimɔɛ̃ mi kafɔkaɖe mito sekelee isɛ iabo kawirikɔ̃. Ɔto ɔ̃atã sɔ ɔwi gɔ i Bosate Yesu Kristo aaba ɔ̃aɣɛgu kayiiso atɔ̃me ne, ɔ̃atã mi ibɛ. ");
INSERT INTO akp_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Ɣaa gɔ lokpere mi sɔ mibara mawɛ̃ gu ɔ̃ Ɔbi Bosate Yesu Kristo ne, ɔɖe ngɔ iso miawo iti ɔsia. ");
INSERT INTO akp_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","I ɔle gɔ i Bokɔse Yesu Kristo ɔtã me kanya ne, loto mi i kukpa teteree sɔ lɛ manyii awe ne, minɔgu so ara karɔ̃ sɔ iɣɛɣɛso kuiwɛ̃ iibawe i mi ndɛ̃. Minyɔ sɔ mi kanya aaɖe kawɛ̃ i ara wa misɛ mibu gu nwa misɛ misia ita iso. ");
INSERT INTO akp_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Wũ manyii, bo manyii ma lobɔrɛ i Kloe iyo ame ɔɣere me sɔ kakpadzɛ̃ pia i mi ndɛ̃. ");
INSERT INTO akp_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Nnɛ loto loɣɛ nɖe sɔ, mi ndɛ̃ ɔbiara to ɔɣɛ sɔ, “Mme ne, Paulo kama losiai.” Ɔmama ana sɔ, “Mme, Apolo kama losiai.” Ɔmama ana sɔ, “Mme, Petro kama losiai.” Fiɛ mamama ana sɔ, “Mme, Kristo losiai.” ");
INSERT INTO akp_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Lokarɛ mi ne, Kristo ne, ɔɣɛ maɣɛɣɛ wũ? Ɛɛbɛrɛ Paulo ɔɖe lokpi i kudziri iso i mi iti? Mapie mi ndɛ̃ ɔwɛ̃ Ɣaa ndu i Paulo iyere ame? Ooɣo! ");
INSERT INTO akp_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Lopɛ Ɣaa siba sɔ loibara Ɣaa itupie kubarara lotã mi kuwɛ̃ iɖo Krispo gu Gaio ɔnɔwɛ̃. ");
INSERT INTO akp_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Ne ɔso kuwɛ̃ iibawo ɔɣɛ sɔ wũ iyere ame ɔfɔ Ɣaa itupie. ");
INSERT INTO akp_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Loɔnyigi sɔ Stefana gu ɔ̃ iyo maturi ana ne, lotã ma Ɣaa itupie. Ne kama ne, loisito lonyigi kuwɛ̃ gɔ lobara ana. ");
INSERT INTO akp_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Kristo iipia me sɔ loba loabara maturi Ɣaa itupie kubarara. Ɣɛɛ ɔpia me sɔ losɛ loaɣere kayiiso maturi Itɔ̃me Bielea. Loisɛ loɣɛ ne ku kayiiso inɔgba, alasɔ loito lobie sɔ ɔle gɔ mpia i Kristo kukpi gɔ ɔkpi i kudziri iso aayu kɔ̃ ɔle kukpese kukpi gɔ nna kusia. ");
INSERT INTO akp_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Mma nsɛgbai lote sɔ maɔkpi i Siwarã ame ne, Kristo kukpi i kudziri iso itɔ̃me ɖe idzimira itã ma. Ɣɛɛ bo ma lona iɖi i Ɣaa ame ne, itɔ̃me nɛmɔ ɖe ɔle itã bo. ");
INSERT INTO akp_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","I Ɔko Sekelea ame ne, Ɣaa ɔɣɛ sɔ, “Loanina manɔgbadze inɔgba. Fiɛ loatã sɔ makotsuese inɔgba aakpese siefe.” ");
INSERT INTO akp_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Iyɔ lɛ i kayi gagbe manɔgbadze pia? Lɛ i makotsuese pia? Fiɛ mma nsɛ makpadzɛ̃ atɔ̃me ne, lɛ mapia ma wũ? Ɣaa ɔɔte sɔ kayiiso gagbe inɔgba ne, sidzimi siɖe. ");
INSERT INTO akp_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Ɣaa ɔki i ɔ̃ iwola nɛgbe iso ɔbara maturi ngbɔ sɔ maibaki i kayiiso inɔgba iso matsue wũ. Ɔ̃ itɔ̃me nɛ boto boɣɛ fiɛ ire sidzimi itɔ̃me i mawɛ̃ kɔrɛ i ngbe ne, ne iso i Ɣaa ɔki ɔtã mma lofɔ maɖe ngbã ne. ");
INSERT INTO akp_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Ma Yudase to mabie iwawãra sɔ manya fiɛ ma Helase ana to mabie kayiiso inɔgba sɔ matsue. ");
INSERT INTO akp_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Ɣɛɛ bo ne, Kristo gɔ mapɛ mamatãra i kudziri iso itɔ̃me boto boɣɛ. Itɔ̃me nɛgbe ɔta iya ma Yudase iso fiɛ mma loiɖe ma Yudase ana ne, ire ma sidzimi itɔ̃me. ");
INSERT INTO akp_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Ɣɛɛ ne, mma i Ɣaa ɔɖi ɔtã so i ma Yudase gu ma Helase ndɛ̃ ne, Kristo iso itɔ̃me nɛ boto boɣɛ ɖe Ɣaa ɔle gu iwola itã ma. ");
INSERT INTO akp_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Alasɔ nnɛ i maturi sɛ manyɔ sɔ iɖe Ɣaa sidzimi ne, iɖo ma inɔgba, fiɛ nnɛ nɖe Ɣaa ɔle idaawe ne, iba ɔle iɖo maturi ɔle. ");
INSERT INTO akp_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Manyii, si Ɣaa aaɖi mi ne, minyigi kumɛgɔ mise i maturi anɔ. Mi gbodzoo iiɖe mma mba ɔle ɣee manɔgbadze fiɛ miibɔrɛ i siɣekparɛ dzɛ masɛ mawarɛ ame ana. ");
INSERT INTO akp_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Ɣɛɛ ne, Ɣaa ɔɖi mma loire kuira i kayiiso maturi anɔ sɔ si ɔ̃asu ɔpia kayi gagbe manɔgbadze kunuarɛ. Ɔɖi mma nna ɔle i kayiiso ara inyɔ kanya sɔ si ɔsu ɔpia kayi gagbe maturi ma mba ɔle kunuarɛ. ");
INSERT INTO akp_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Ɣaa ɔɖi mma loire kuira i maturi anɔ i ɔri kuwɛ̃ iso, fiɛ mana kuwarɛ kukuwɛ̃ sɔ si ɔsu ɔsopara mma nsɛ mabu so sɔ maba kuwarɛ. ");
INSERT INTO akp_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Nnɛgbe loate sɔ ɔturi kuwɛ̃ iibawo so kato ɔkɔlɛ i Ɣaa katɔ̃ ne. ");
INSERT INTO akp_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Ɣaa ɔtã sɔ miɔbara mawɛ̃ ku Yesu Kristo. Ɔ̃ nɖe bo iwola nɛ i Ɣaa ɔsu ɔtã bo. Iki i ɔ̃ iso fiɛ Ɣaa ɔnyɔ bo sɔ bose bɔlɔlɔ. Boɔkpese Ɣaa maturi sekelea fiɛ ɔ̃ɔtã bo akpi iti kuso. ");
INSERT INTO akp_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Ne ɔso i Ɔko Sekelea ɔɣɛ sɔ, “Ngɔ loaɖe ndamu ne, ɔɖe ndamu i nnɛ i Bosate ɔbara iso ne.” ");
INSERT INTO akp_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Manyii, ɔwi gɔ loba loaɣere mi Ɣaa itɔ̃me wɛrɛa ne, iiɖe ɔnyamɛrɛ̃ gu kayiiso inɔgba ame loba loaɣere mi. ");
INSERT INTO akp_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Ɔwi gɔ lowe i mi kɔrɛ ne, loiɖe mi ika i kuira iso iɖo Yesu Kristo iso gu ɔ̃ kukpi i kudziri iso. ");
INSERT INTO akp_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Ɔturi gɔ nna ɔle gu ngɔ nsɛ ɔnigã ɔti ɔkpakpa loɖe ku ɔwi gɔmɔ ame. ");
INSERT INTO akp_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Minya i wũ ara ite ame ɔɖuɖu sɔ loiɖe ɔturi gɔ nsɛ ɔɣɛ atɔ̃me siare loɖe. Ɣɛɛ wũ itɔ̃me ɔte sɔ Ɣaa Siwarã ɔle pia gbaã. ");
INSERT INTO akp_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Ne ɔso loibabie sɔ mi kafɔkaɖe si kasia i maturi inɔgba iso ɣɛɛ ne, kasia i Ɣaa ɔle iso. ");
INSERT INTO akp_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Ɣɛɛ mma loɔmɔ i Ɣaa Siwarã ame ne, losɛ loɣere ma Ɣaa itɔ̃me i inɔgba kɔlɛa ame, iiɖe kayi gagbe inɔgba gu atakere ma ɔle maɔfɔ ma iso itɔ̃me nto loɣɛ. ");
INSERT INTO akp_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Iwola nɛ loto loɣɛ ala ngbe ne, Ɣaa ɔfu ne ara, ɔkɔla ne i ɔ̃ ame. Ɣɛɛ ɔsia ne ita kokooko ta kayi karɔ̃kasɛkɔ̃ sɔ ne iso ɔ̃aki fiɛ ɔ̃aɖi bo. ");
INSERT INTO akp_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Kayi gagbe atakere kuwɛ̃ iiɣe iwola nɛgbe. Alasɔ si maɣe ne ne, tee maibapɛ Bosate mamatãra i kudziri iso. ");
INSERT INTO akp_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Ɣɛɛ matsɛrɛ i Ɔko Sekelea ame sɔ, “Ara wa i kuwɛ̃ iinya, ɣee kutsue iinɔ gu nnɛ i kuwɛ̃ iibu ɔnya ne, ne i Ɣaa ɔledza ɔsɛ ɔtã mma nsɛ maɖɔɛ wũ ne.” ");
INSERT INTO akp_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Ɣɛɛ bo ɔso i Ɣaa ɔɖi awɛrɛra wagbe ɔbɔ i ɔgbami iki i ɔ̃ Siwarã iso. Ɣaa Siwarã sɛ sinyɔnyɔ ira biara sitsue fiɛ siɣe ta Ɣaa ara wɛrɛa. ");
INSERT INTO akp_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Kumɛgɔ i ɔturi siwarã dzɛ mpia i ɔ̃ ame ɣe ira biara i ɔ̃ iso ne, ngbɔ ame i Ɣaa Siwarã ɣe ira biara i Ɣaa iso ne. ");
INSERT INTO akp_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Bo ne, iiɖe siwarã dzɛ nto siɖe kayi gagbe iso mpia i bo ame. Ɣɛɛ Ɣaa Siwarã dzɛ nsɛ sitã bonɔ bo karatã ga i Ɣaa ɔtã bo karɔ̃ mpia i bo ame. ");
INSERT INTO akp_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Ne ɔso ne, iiɖe kayi gagbe iwola nɛ bosuã bobɔrɛgu i maturi kɔrɛ ara boto bote mi. Ɣɛɛ bosɛ boɖi Siwarã ame ara karɔ̃ bote mi ma ame i Siwarã pia. ");
INSERT INTO akp_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Ɔbiara gɔ i Ɣaa Siwarã iito siɖe iso ne, ɔ̃ibawo Ɣaa Siwarã karatã gagbe ɔfɔ. Ɔ̃ibanɔ kã karɔ̃ ana alasɔ kare adzimira i ɔ̃ kɔrɛ. Ngɔ ame i Ɣaa Siwarã pia to ɔ̃anɔ ara wagbe karɔ̃ fiɛ ɔ̃ana wã kusia. ");
INSERT INTO akp_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Ngɔ i Ɣaa Siwarã to siɖe iso ne, ɔsɛ ɔnya isɛɛ gu ilalaa ɔɖi ite. Ɣɛɛ maturi iisɛ manya wũ maɖi ite. ");
INSERT INTO akp_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Ɔko Sekelea ɔɣɛ sɔ, “Nna nɣe Bosate iti ame? Fiɛ nna loate wũ ara?” Ɣɛɛ bo ne, Kristo adzuni mpia i bo ame. ");
INSERT INTO akp_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Manyii, i ɔnukuare ame ne, loiwo mi ika ɔɖe lɛ mma i Ɣaa Siwarã to siɖe iso. Ɣɛɛ loɖe mi ika lɛ kayiiso maturi awe. Loɖe mi ika lɛ mabiɛtɛ i Kristo kafɔkaɖe ame. ");
INSERT INTO akp_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Wũ ara wa lote mi ne, ase ɖɔbɔrɔɔ lɛ inyɛdu mɛ i ɔbiɛtɛ sɛ ɔmeme, iiɖe makpakpa aɖera. Alasɔ ɔwi gɔmɔ ame ne, miimɔ mitã makpakpa aɖera fiɛ ipɛ i kiniɔ ana ne, miito miwo makpakpa aɖera ɔɖe. ");
INSERT INTO akp_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Misi ngbã lɛ mma adzuni ɔɖuɖu nsia i kayi gagbe ara iso. Si mito mikpɛ̃gu so sirerɛ fiɛ mito milɔgu so ne, ne kerekere ɔɔte sɔ sosina ara kere misi mitã, fiɛ mikotegu kayi gagbe maturi. ");
INSERT INTO akp_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Si mi ndɛ̃ mawɛ̃ to maɣɛ sɔ, “Mme, Paulo kama losiai.” Ɔmama ana sɔ, “Mme, Apolo kama losiai” ne, iyɔ mito mibara ara lɛ mma i kayiiso adzuni kere nto aɖe ma iso. ");
INSERT INTO akp_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Fiɛ nwagbe ɔɖuɖu kama ne, nna nɖe Apolo fiɛ nna nɖe Paulo? Ɣaa marabaradze kere boɖe. Bo iso kere miki mifɔ miɖe fiɛ bo ndɛ̃ ɔbiara to ɔbara nnɛ i Ɣaa ɔtã wũ sɔ ɔbara. ");
INSERT INTO akp_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Mme losɛ karabara karɔ̃ lɛ kumɛgɔ masɛ mapɛ ɔraɖui fiɛ Apolo ka ɔfere ɔraɖui ndu. Ɣɛɛ Ɣaa ɔɖe lotã sɔ ɔraɖui ɔre iti. ");
INSERT INTO akp_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Ne ɔso ne, iiɖe ngɔ lopɛ ɔraɖui, ɣee ngɔ lofere ndu lonya, ɣɛɛ Ɣaa gɔ lotã sɔ ɔre iti lonya ɔɖo. ");
INSERT INTO akp_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Ikpaki kuiwɛ̃ na i ngɔ lopɛ ɔraɖui gu ngɔ lofere wũ ndu ame. Ɣaa loatã ma ɔɖuɖu kuso i ma karabara kanya. ");
INSERT INTO akp_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Malaa boɖe i Ɣaa karabara ame fiɛ mi nɖe Ɣaa kakpɛkɔ̃. Ɣaa iyo ana miɖe. ");
INSERT INTO akp_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Ɣaa ɔle gɔ ɔtã me kanya ne, nto lobara karabara lɛ yotsuese sɛɛ awe. Lopia iyo i karɔ̃ ame gu ata. Ɔmama ɔ̃ wũ ɔba ɔ̃atsue ɔsia iso. Ɣɛɛ ɔbiara si ɔnyɔ kukaakɔ kumɛgɔ ɔ̃atsue ɔsia iso. ");
INSERT INTO akp_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Alasɔ Yesu Kristo nɖe lɛ ita nɛ mapia ala iyo i karɔ̃ ame fiɛ ɔturi biara aatsue ɔsia iso. Kuwɛ̃ iisibawo ita mama ɔpia i karɔ̃ ame. ");
INSERT INTO akp_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Si ɔrere ɔsu sikãrɛtɛa ɣee sifudza ɣee ata wa lofɔ kuɣa ɣee sidziri ɣee katĩ ɔtsue iyo nɛmɔ ne, ");
INSERT INTO akp_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ɔbiara karabara ga ɔbara to kaabɔrɛ kayi. Kristo iyi siare nɛmɔ loaɖi ɔbiara karabara ite. Iyi nɛmɔ ne, ɔtɔ loaɖi ɔbiara karabara ɔte. Ɔtɔ maasu makere ɔbiara karabara manyɔ si kasɛɛ kaɖe. ");
INSERT INTO akp_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Si sɔ nnɛ i ɔturi ɔsu ɔtsue iyo ɔwo ɔtɔ gɔgbe ame ɔki ɔbɔrɛ fiɛ iitsue ne, ɔ̃afɔ kuso gɔ lokote. ");
INSERT INTO akp_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Ɣɛɛ si ɔrere ara wa ɔtsue ala iyo ɔtsue i ɔtɔ ame ne, ɔ̃ibana kuso kukuwɛ̃ ɔfɔ. Ɣɛɛ ɔ̃ mɔmɔ to ɔ̃ana iɖi lɛ ngɔ lotere ɔbɔrɛ i ɔtɔ ame. ");
INSERT INTO akp_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Mitsue sɔ mi mɔmɔ nɖe Ɣaa isɔrɛyo fiɛ Ɣaa Siwarã pia i mi ame. ");
INSERT INTO akp_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Ɣaa isɔrɛyo se sekelee fiɛ mi nɖe isɔrɛyo nɛmɔ. Si ɔrere ɔnina ne ne, Ɣaa to ɔ̃awɔra ɔnyiiɔ gɔmɔ ɔ̃ wũ. ");
INSERT INTO akp_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Mi ndɛ̃ kuwɛ̃ si ɔdaasɔsɔla so. Si mi ɔrere ɔbu so sɔ ɔɖe kayi gagbe iso nɔgbadze ne, ɔbara so lɛ dzimifɔ i maturi anɔ si ɔ̃akpese nɔgbadze bielea i Ɣaa anɔ. ");
INSERT INTO akp_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Alasɔ ara wa i kayiiso maturi sɛ manyɔ sɔ aɖe iwola ne, wã nɖe adzimira i Ɣaa anɔ ne. Matsɛrɛ mapia i Ɔko Sekelea ame sɔ, “Manɔgbadze inɔgba i Ɣaa sɛ ɔsu ɔmɔɛ̃ ma i iyebi ame.” ");
INSERT INTO akp_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Maledza itsɛrɛ ana sɔ, “Ɣaa ɣe sɔ manɔgbadze adzuni ne, siefe kere aɖe.” ");
INSERT INTO akp_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Ne ɔso kuwɛ̃ si ɔdaakɔlɛ so kato i ara wa i maturi aawo ɔbara iso. Alasɔ ira biara se itã mi isɛɛ. ");
INSERT INTO akp_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Paulo ɣee Apolo ɣee Petro ɣee kayi gagbe ɣee kukpi gu ngbã, kiniɔ ɣee ɔwi gɔ nto ɔba i katɔ̃ ne, wã ɔɖuɖu ɖe mi are. ");
INSERT INTO akp_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Kristo mare miɖe, fiɛ Kristo ɔ̃ wũ Ɣaa ɔre ɔɖe. ");
INSERT INTO akp_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Mila miɔnyɔ bo lɛ Kristo marabaradze ma nto manyɔ Ɣaa atɔ̃me wɛrɛa iso. ");
INSERT INTO akp_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Nnɛ i ɔkɔse sɛ ɔbie ɔbɔrɛgu i marabaradze magbe igbã kɔrɛ nɖe sɔ maabara ma karabara i ɔnukuare ame. ");
INSERT INTO akp_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Kiniɔ ne, iito iɖa me si mi ɣee ɔrere aaɣɛgu me atɔ̃me. Mme mɔmɔ kɔra loisɛ loɣɛgu so atɔ̃me. ");
INSERT INTO akp_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Wũ kaɣere iisɛ katã me ipɔ i ɔri kuwɛ̃ iso. Ɣɛɛ iiɖe ne nto ite sɔ loisɛ lobara ikpi alasɔ Bokɔse loaɣɛgu me atɔ̃me. ");
INSERT INTO akp_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Ne ɔso ne, kuwɛ̃ si ɔdaaɣɛgu ɔ̃ ɔlaa atɔ̃me fiɛ ɔwi aaɣo. Ɔwi gɔ i Bosate ɔɔba ne, ɔ̃ loaɣɛgu ɔbiara atɔ̃me ku iyi tsɔra ne. Ɔ̃ nto ɔ̃aba ɔ̃aɖi awɛrɛra ɔɖuɖu ɔbɔ ɔgbami fiɛ ɔ̃aɖi ta nwa mpia i maturi adzuni ame ɔte. Mmɔ i Ɣaa aale ɔbiara gɔ lokote ɔtã ile ne. ");
INSERT INTO akp_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Manyii, si mianɔ ara karɔ̃ ɔso fiɛ losu mme gu Apolo lotã mi ikparĩ. Misuã nnɛ itɔ̃me nɛ matsɛrɛ masɛ ngbe to ite sɔ, “Mibara ara i ɔri iso.” Ne ɔso midaanyɔ kuwɛ̃ sɔ ɔkɔlɛ ɔɖo ɔ̃ ɔlaa. ");
INSERT INTO akp_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Nna lobara-ɔ fiɛ afɔ kuɣa aɖo fɔ ɔlaa? Ara wa ɔɖuɖu aba ne, Ɣaa losu ɔtã-ɔ. Si ngbɔ iɖe ne, be ɔso fiɛ ato akɔlɛ so kato lɛ iiɖe Ɣaa lotã-ɔ. ");
INSERT INTO akp_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Ka miba ira biara nɛ mito mibie? Miɔkpese maranase miro? Miɔkpese magara ku ɔwi gɔ ame bo boikpese magara? Aĩ, wũ kayiri tee magara ka miɖe fiɛ bo wũ boaɖegu mi sigara. ");
INSERT INTO akp_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Ibara me lɛ bo katɔ̃memasɛdze ne, kasɛkɔ̃ tsɔra i Ɣaa ɔsu ɔtã bo. Bo nɖe mma matã ipɔ gu ira nɛ i maturi aanyɔ botã kayiiso ɔɖuɖu fiɛ maaɖoe bo i kaɖe ɔɖuɖu gu Ɣaa makpabo anɔ. ");
INSERT INTO akp_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Kristo ɔso ne, boɖe madzimifɔ. Ɣɛɛ mi ne, miɖe manɔgbadze. Boɔkpese maturi ɣɔa ma nna ɔle, ɣɛɛ mi ne, miba ɔle. Boire kuira i maturi anɔ, ɣɛɛ mi ne, masɛ mawarɛ mi. ");
INSERT INTO akp_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Ta kiniɔ ne, kukã gu ɔme to ɔkore bo, bopia aradzɛ, maturi to mapɛ bo fiɛ bona kawekɔ̃ kukawɛ̃. ");
INSERT INTO akp_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Bosu bo mɔmɔ arɔĩ boto bobara karabara bonyɔ so iso. Si magbarĩ bo ne, boɔtã kusɛkusɛ. Si mato mati bo kama i amumuɣɔ ɔri iso ne, bosɛ bopia so katetere. ");
INSERT INTO akp_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Si maturi ɔtia bo ne, atɔ̃me wa loaɣɔra situ bosɛ boɣere ma. Boɔkpese kayiiso aku kawirikɔ̃ gu ara wa loisilɛ ipɛ i kiniɔ. ");
INSERT INTO akp_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Iiɖe kunuarɛ nto lopia mi i ara wa nto lotsɛrɛ mi ngbe iso, ɣɛɛ ɔka loto mi lɛ wũ mabi ɖɔɛse awe. ");
INSERT INTO akp_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Si miba nane maturi gbodzoo lɛ mi maratedze i kafɔkaɖe ame ne, ɔse ɔwɛ̃ saã kere ɔɖe mi. Alasɔ i mi ngbã mɛ ame miɖe mawɛ̃ ku Kristo ne, loɔkpese mi ɔse ala mme losu Itɔ̃me Bielea lobɔ mi. ");
INSERT INTO akp_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Ne ɔso loto mi i kukpa sɔ misuã wũ nsɛgbai. ");
INSERT INTO akp_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Nnɛgbe ɔso nto loapia Timoteo gɔ nɖe wũ ɔbi ɖɔɛse fiɛ ɔsɛ ɔbara Bosate Karabara i ɔnukuare ame ne. Ɔto ɔ̃anyigira mi Kristo ame ngbã mɛ losi fiɛ me nsɛ lote mafɔɖedze ɔɖuɖu i kakɔi biara ne. ");
INSERT INTO akp_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Mi ndɛ̃ mawɛ̃ to makɔlɛ so kato alasɔ mabu sɔ loibaba mi kɔrɛ mmɔ lonya. ");
INSERT INTO akp_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Si Bokɔse ɔbie ne, nto loaba loanya mi i ɔwi kurukutu ame. Nto loabie sɔ loanya ɔle gɔ mmamɔ ba gu atɔ̃me wa mato maɣɛ. ");
INSERT INTO akp_v