﻿USE sofia;
DROP TABLE IF EXISTS sofia.akh_vpl;
CREATE TABLE akh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES akh_vpl WRITE;
INSERT INTO akh_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ngo wi o Ngaorom Eben Ke Aol Njiseson ab sumb wilon imbi wi. Ngo tomb Debir obu Eberehemon sem sisaol, Njises obu Debiron sem sisesa. ");
INSERT INTO akh_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ngo tomb Eberehemom Isak maru wisesa. Isakom Njekob maru wisesa. Ngo tomb Njekobom Njura di nas mendbor di andub maru wisesa. ");
INSERT INTO akh_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Njuram Peres hesa Sira kab maru wisaol, mbinin am di Temar sisesa. Peresom Hesron maru wisesa. Ngo tomb Hesronom Erem maru wisesa. ");
INSERT INTO akh_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Eremom Aminarab maru wisesa. Ngo tomb Aminarabom Nason maur wisesa. Nasonom Salmon maru wisesa. ");
INSERT INTO akh_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ngo tomb Salmonom Bowas maru wisaol, obun am di Erehab sisesa. Bowasom Ober maur wisaol, obun am di Urur sisea. Ngo tomb Oberom Njesi maru wisesa. ");
INSERT INTO akh_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ngo tomb Njesim aol wesmbao aondao Debir maru wisesa. Debirom Soloman maur wisaol, obun am di mbes Yurayan were sisesa. ");
INSERT INTO akh_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomanom Iriyabowam maru wisesa. Iriyabowamom Abasa maru wisesa. Abasam Esa maur wisesa. ");
INSERT INTO akh_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ngo tomb Esam Njehosapar maru wisesa. Njehosaporom Njoram maru wisesa. Ngo tomb Njoram Usaya maru wisesa. ");
INSERT INTO akh_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usayam Njotam maru wisesa. Ngo tomb Njotam Ehas maru wisera. Ehasom Hesekaya maru wisera. ");
INSERT INTO akh_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ngo tomb Hesekayam Manasa maru wisesa. Manasam Emon maru wisesa. ");
INSERT INTO akh_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Emonom Njosaya maru wisesa. Ngo tomb Njosayam Njekonaya di nas mendbor di maru wisaol, mbini ngo baeben hasmi tomb Babilon semom Isreyel tenaol baeben mbinin su Babilon bor kemi po mao baraesmisa. ");
INSERT INTO akh_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ngo tomb mbini su Babilon ngo bor ngub kemi po mao baraesmi tomb Njekonayam Salliyel maru wisesa. ");
INSERT INTO akh_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Salliyelom Serababel maru wisesa. Serababelom Abayar maru wisesa. Ngo tomb Abayarom Elayakim maru wisesa. Elayakimom Eso maru wisesa. ");
INSERT INTO akh_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ngo tomb Esom Serok maru wisesa. Serokom Ekim maru wisesa. Ekimom Elayar maru wisesa. ");
INSERT INTO akh_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ngo tomb Elayarom Eleyasa maru wisesa. Eleyasam Matan maru wisesa. Matanom Njekob maru wisesa. ");
INSERT INTO akh_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Njekobom Njoseb maru wisesa. Ngo tomb aol Njoseb ngo nong Mariyan aoli sisesa. Ngo tomb Mariyam Njises maru wisaol, aol ngo obu Ngaorom Eben Ke Aol ora hae kismisa. ");
INSERT INTO akh_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ngo tomb Eberehemom maru wam en en bisao o, Debirom tuma pabur sem ngo baeben maoklaopun kab oran ha himismisa. Ngo tomb Debirom maru wam aeben aeben bisao o, Babilon tenaolom mbini su Babilon bor kemi po mao baraesmi tomb di, sem maoklaopun kab mende ha himismisa. Su Babilon ngo bor kemi pismi tomb tuma pabur Ngaorom Eben Ke Aol obu ngo en anga ol pindib paesao o, sem tebo nan maoklaopun kab mend di ha himismisa. ");
INSERT INTO akh_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Eben Ke Aol Njises marisao on arman ngub wiyao. Mabor Njises marisao o nong Mariya sisaol, obu Njosebon tuman ke sokl kal hae birisao o, Njosebom Mariya nao taol bi hae tomb Wesao Ebe Tangarom Mariya obun kone bor hondaesaol nongnas pangisaol hindismisa. ");
INSERT INTO akh_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ngo tomb Mariya obun tuman ke di Njoseb ngo hasao o obu kone ebe wi ora sisaol, obum Mariya bor di tenaol hambunom henden, sakl mao pola menjao nao bi sub ngub hondbao pango win bao wabur nao osisao pungun muklwao ko nen sabisesa. ");
INSERT INTO akh_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ngo tomb Njosebom nong ndam ngo hondbao pango wisaon was bao nen sab ha wisaol, ko mend oran obun obam hindisao tomb Aorao Aondaon angal mini wesao bombor mend obobur kakl, Debir semon isi Njoseb o, njem njen tuman ke nong Mariya taol bun be? nao taol bun ko kone taol bu pakl pakl nao homaebe ora kisesa. Ngub kobur kakl, Pangal. Obum nongnas ngo pango wi o Wesao Ebe Tangarom ora kalaonao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ngo tomb wakl kakl, Obum kang wen sao nas maruklaol obum tenaol hambunon kone bor kho wiyao o kunabur bu muklaong, njem obun imbi Njises kaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ngo tomb Njosebom angal hambun sao ngo obam hindisao baeben, Aorao Aondao obum mbes man mini aol is mend bor ngub kao ko kao kalisao ub heneng ora ngo il so pind bile o ka. Man mini aol ngom ngub kisao. ");
INSERT INTO akh_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Pangal. Nong mondom nongnas pangobur Obum nas maruklaol Mbinim obun imbi Imanyuwel lemi ko mbes Ngaoron man mini aol is mondom waeb bu wisao ub angal mini wesaom oba nda bor Njoseb kao kalisesa. Ngub kao kalisao o obun imbi ngon te, Ngaorom nao hesa haru was hayao ko karu wisao ora. ");
INSERT INTO akh_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ngo tomb Njoseb obu u paolu wisao nda teka peyobur, obum Aorao Aondaon angal mini wesaom kisao nda ub was bubur kisaon obum nong Mariya taol bisesa. ");
INSERT INTO akh_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ngo tomb obum ngub taol bisao o, Njosebom nong Mariya biri nao pe haen was nas Njises mbes maru wisaol, Njosebom obun imbi Njises ko karu wisesa. ");
INSERT INTO akh_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ngo tomb aol wesmbao Herorom su Njuriya hambun maomb bo haenbur, Njuriya and lobokl lobokl Berlehem bor nong Mariyam nas Njises marisesa. Ngub marisaol mabor saosolbaem kongon bismi on hambun sao pange aol mendbor yu ora bor hakl, Njurusalem obo tenaol hambun bor ne mubur kakl, ");
INSERT INTO akh_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Naom saosolbaem aondao ora mend wen pindib paesaol hindismao tomb Nju semon aol wesmbao aondao ora haen ko wen maraonao ko pangobur, naom obu bor kaoya kokl obomaong obu abor pindib panao? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ngo tomb ngub kismil aol wesmbao Herorom pangobur obu aondao ora soklao ni kang ora soklao ko pangobur, obum pakl aondao ora homo burisao po wisaol, Njurusalem tenaol hambunom di ngub burir bismisa. ");
INSERT INTO akh_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ngo tomb aol wesmbao Heror ndam Nju semon baolum aol aondao baeben di, mbinin man buwaloklme aol baeben di mbini hambun ora obo kiril mbaklaob kobur kisaon, aol wesmbao Herorom mbini hambun bor me mubur kakl, Ngaorom Eben Ke Aol obu su abor ora pindib paklaob? Kisesa. ");
INSERT INTO akh_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ngo tomb mbinim obu bor kakl, Mbes Ngaorom man mini aol mondom obu Berlehem bor pindib paklao kobur, mbuk waeb ngub bu wisao. ");
INSERT INTO akh_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Su Njuriya bor paoloklme baebenon Berlehem tenaol o hakl o Su Njuriyan tenaol maomb bo haroklme aol baeben Aondao hayem ub ini di kang ora nao soklao. Ngub inj ka. Mabor ini ngo haklon maomb bo haraoklao aol Aondao bombor mend pindib pabur Nao Isreyel sem hambun maeb ha maomb bo haklao ke wiyao ko, mbuk waeb bor wisao ub mbinim Heror kao kalismisa. ");
INSERT INTO akh_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ngo tomb aol wesmbao Heror ndam saosolbaem hondo hasmi on hambun sao pange aol is teb nda kor bu ubuklub kobur, obum Njises luklwao ko sub kone mende marubur o, hambun sao pange aol is teb yu ora bor hakl ibismi nda baeben bor kakl, Saosolbaem o pindib paesao kaemnda, atomb ora pindib paesaob ko? ne misesa. ");
INSERT INTO akh_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ngo tomb obum hambun sao pange aol is teb nda Berlehem puklub kobur kakl, Inim pobur lemin buri palo nas kang ngo es aondao ora bibaebe. Inim obu hend waklemi tomb hend warum ko ni hae ol angal eben lowaebe. Ngo tomb nim di obu bor kaoya kokl poklwao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ngo tomb mbinim aol wesmbao aondao ndam ngub kisaol pangaoklbir pismi tomb, mbes mbinim yu ora bor habur saosolbaem hasaol haondaokl ibismi nda was taol mi pobur kismin, saosolbaem ngom nas kang Njises maru birisao nda dund so oral hasaol hindismisa. ");
INSERT INTO akh_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ngo tomb mbinim saosolbaem ndam ngub hasaol hondobur kismin, mbinin kone bor werek bu turi aondao ora bin was pismisa. ");
INSERT INTO akh_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ngo tomb mbinim and Njises maru birisao ndan pobur hindismil, nas kang Njises do obun am Mariya di birismil hondobur, saosolbaem hondo hasmi on hambun sao pange aol is teb ndam tumu karu dombes ubur mbinim nas kang Njises bor kaoya kobur kismin, mbinin nu bor taoklubur mbinim Njises turi aondao ora homobur kismin han ngol di, haoroklme sao kao ebe ora pebe mend di, wel menden imbi mer ebe ora mend di ngo sao hakl Njises bisur bu kalismisa. ");
INSERT INTO akh_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ngo tomb hambun sao pange aol is teb nda baeben wakl mbinim aol wesmbao Heror biri nao pen ko Ngaorom oba nda bor kao kalisaol, harer tangar menden mbinin anda wakl bokesmisa. ");
INSERT INTO akh_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ngo tomb saosolbaem hondo hasmi on hambun sao pange aol is teb nda paokl pismi tomb Njoseb bor Aorao Aondaon angal mini wesaom oba nda bor kao kalobur kakl, Aol wesmbao Herorom nas kang ngo pe paen luklbur beng, ngub nao lin ub njem nas kang Njises ingiyakl kemibir su Isib bor kemi paokl pu ora kisesa. Ngub kobur kakl, Njem su Isib ngo bor bao hanin was nim nje bo wakl angal kao njuklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ngo tomb Njosebom somna ora tomb nas kang Njises hesa nas kang ngon ingi Mariya kab kemibir kisaon, su Isib paokl ora pismisa. ");
INSERT INTO akh_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ngo tomb Njoseb obu su Isib ngo bor haen was mabor aol wesmbao Heror Njises lukl bisao nda himisaol wakl su Isreyel pismil, mbes Aorao Aondaom obun man mini aol is mend bor ngub kao ko kao kalisao ub mbuk waeb ngub wisesa. Nao isi ngo su Isib bor bao haklao o Nim wakl ib lowao ke wisao ub ngo tomb heneg ora il so pind bisesa. ");
INSERT INTO akh_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ngo tomb Herorom nen sabisaol saosolbaem hondo hasmi on hambun sao pange aol nda baebenom obu bor nas kang Njises hend warum sin kao njukl oboklmao kismi o, obu maobowakl pobur nao ibismil ko aondao ora homobur kisaon, mbinim obu bor mbes kao kalismi ub nen sabobur, obum aol mendbor Berlehem bor nas kang wen ora karasmas ukl kab nao pibi hae Njises marisao ekon marismi o su Berlehem teb sol maru buruklemi baeben lukl puklub kisaol, hambun ora sarbe lismisa. ");
INSERT INTO akh_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Ngo tomb mbes Ngaoron man mini aol Njeremayam mbuk waeb bu wisao ub heneng ora il so pind bisesa. Obum kakl, Mbinim pangismil su Arama bor Angal aondao bu ora mend kisaol pangismi tomb Tenom de aondao ora kisaol pangismisa. De aondao ora ngo kisao o Ten Eresel* obun nongnas maru birisao baeben Pe paen lu tuwaesmil Obum hibi kho sobur de ngub kisao o Mondom sowa paen ko Obun kone bor mao dam kakl buwaesesa. Ngo bisao sao Njeremayam ngub buklao ko mbuk waeb bu wisao ub ngo tomb heneng ora il so pind bisesa. ");
INSERT INTO akh_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ngo tomb aol wesmbao Heror himisao tomb Njosebom su Isib ngo bor oba bisaol, Aorao Aondaon angal mini wesao mend obobur kakl, ");
INSERT INTO akh_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Aol mendbor Njises lukl bismi baeben pe paesming, njem nas kang Njises di Mariya di ini ngubi tomb su Isreyel puklub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ngo tomb Njosebom nas kang Njises di Mariya di kemibir mbini teb su Isreyel pismisa. ");
INSERT INTO akh_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ngo tomb ngub pismi o, Njosebom aol wesmbao Heroron isi, aol Akelasom obun ab Heroron wakl akl bubur Njuriya tenaolon aol wesmbao hae kismil, obum su ngo bor pebe pakl himisesa. Ngub bisaol oba nda bor Ngaorom Njoseb bor kakl, Njem su Kalili bor pu kisaol ngo bor pisesa. ");
INSERT INTO akh_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ngo tomb mbini ngo bor pobur kismin, su and lobokl lobokl menden imbi Nasaser kismil ngo bor bao birismi o, mbes man mini aol baebenom obu Nasarer aol ora soklao ko, ko hasmi ub ngo ora tomb il so pind bisesa. ");
INSERT INTO akh_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ngo tomb Njon Mbabtas Biyao Aol obu su Njuriyan tenaol nao biri solo maon nan po habur kisaon, obum Ngaoron angal kao kal ha habur kakl, ");
INSERT INTO akh_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Yu heben maomb bo haraokaomon ini maeb ha maomb bo haklao ub teb seng, ini tenaol hambun kone baol monoklwaebe ko kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ngo tomb aol Njon ngo obum ngub buklao ko Ngaoron man mini aol Asayam mbes mbuk waeb ngub bu wisesa. Su tenaol nao biri bor Aol mondom angal aondao bu ora mend kobur kakl Aorao Aondao poklao hareron oborob ora kareyo Mao dund sa man man bibaebe ko Asayam mbuk waeb bu wisao o heneng ora ngo tomb il so pind bisaol, aol Njon Mbabtas Biyao Aol ngo bor kisesa. ");
INSERT INTO akh_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ngo tomb aol Njon ngom obun lab lab di some kamelon irim bi was samo habur, obum hakom tukunol dengi tanga mbabur samo hasesa. Ngub bubur kisaon obum ne di nollae nen hesa is ibao non bi kab was no hasesa. ");
INSERT INTO akh_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ngo tomb Njurusalem tenaol di, tenaol su Njuriya hambun bor paolismi baeben di, tenaol mendbor su Njoran teb so bor paolismi baeben di, mbini hambun ora Njon Mbabtas Biyao Aol hasaol obo kiril mba was bu habur ");
INSERT INTO akh_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","mbinim khorob bismi sao Njon obu bor maokl peyu kao kalismi tomb obum mbini ib Njoranol mbabtas bu hasesa. ");
INSERT INTO akh_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ngo tomb Njonom hindisaol Peresi sem di Sarusi sem mendbor di mbini hambun Njonom mbabtas bin ko ibismil hondobur Njonom mbini bor kakl, Ini suklumb sem o hakl o, Ngaorom ini ko homo ke mao handaklao ub aem was ini ke ngo nao hondoklemi ko kao njaonaob? Kisesa. ");
INSERT INTO akh_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Wakl kakl, Ngub inj, njem oborob buklesi ub Ngaorom njen kone baol minisi ko henden, inin kone ora bor em we ebe sao por ken haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ngo tomb Njonom wakl kakl, Nao Eberehem obu Ngaorol hul ha hasao on isi wane hayom ol, nao ebe soklao ko nen nao saboklwaebe ora. Ngub inj, nim ini bor heneng ora kao njurukl, Ngaorom Eberehemon isi wane haklemi ub hobao sao ora ko hem kokl beyaon obum han ngo wi o baeben di Eberehemon isi wane ebe mao ingiyakl beyao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ngo tomb Njonom ngub kobur kakl, Kuwi kakeb is te bor man man bu pa wisao o bao wiyao ora. Is mendbor il oborob nao saoklao baeben obum bobur is de bor haoruklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ngub kobur kakl, Nim inim kone baol menemel ibom ora mbabtas biyu o, mabor aol hobao sao mend obu oboklao on burim nao buri men mbae ora yao. Ni di kho ora hae ol, nim obun aongao su heneg o di nao mu manaklaeb se hae kisesa. Ngub kobur kakl, Obum ini obun Wesao Ebe Tangar di is sung kabom ini mbabtas buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ngo tomb Njonom wakl kakl, Obun ki bor ang honde hesa mondolom kab* sarbe kobaraoklao is hul mend meneyaom, ang tu honde hesa mondolom kab sarbe koboklme nda ub obum ang noklme anda bor sarbe maomb kobur, mondolom baeben isaolao nao hindili dao hakol bi bor hi haoruklao ko Njon Mbabtas Biyao Aolom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ngo tomb Njises obu su Kalili bor haklbir ib Njoran teb so bor pisesa. Ngo tomb obum Njon Mbabtas Biyao Aol hasaol pobur, obu Njonom mbabtas bin ko pisesa. ");
INSERT INTO akh_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ngo tomb Njonom ni non bim obu mbabtas nao bib se hae ol nao buklwao ko nen sabobur kakl, Njem ni mbabtas bukl baen ebe ora sokl baonaong, ni non bim nje mbabtas bun ko obae o asub ko obaeb? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ngub kisao o Njisesom obun angal ngon ko san lubur kakl, Njem heneng ora kal o, ngubi tomb nim nje bor ngo kakl ub ni mbabtas bi ora. Yaom ngub buklbao tomb kone ebe dund se woroklme ub ora buklbaol ebe ora saoklao kisesa. Ngub kisaol Njon obum Njisesom ngo kisao ub obun angal taolisesa. ");
INSERT INTO akh_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ngo tomb Njonom Njises obu mbabtas bu paesaol, Njises obu ib ngo tuwaklbir ib ngon marel yin ibisaol, bombor ngo tomb yu heben kebe kobabur kisaon, Ngaoron Wesao sao ebeyabukl non bi oram Njises obo men mbaesaol hindisesa. ");
INSERT INTO akh_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ngo tomb yu heben bor angal bombor mend obobur kakl, Aol ngo obu nao Isi ora hael nim obul ora kone uruklul, nao kone ora bor di obu nen sabeyo tomb turi aondao ora bin hae kisesa. ");
INSERT INTO akh_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ngo tomb Njises bor Seranom khorob mao ba henden ko Ngaorom Wesaom obu su tenaol nao biri bor kemi pisesa. ");
INSERT INTO akh_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ngo tomb Njises obu su tenaol nao biri ngo bor ne nao ne, hora di somna di bao hor supu hakl hakl hor makl oran bao hasaol, ma ora bor obu dem aondao ora himisesa. ");
INSERT INTO akh_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ngo tomb tenaol khorob mao baraoklao sao ngo Njises obu bor khorob mao bakl bisao ndam Njises hasaol teb so obobur kakl, Nje heneng ora Ngaoron Isi ora yao sin, njem han ngo wi hakl wakl palawe men aolin kao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ngub kisaol Njisesom ko san lubur kakl, Ngaoron mbuk waebom ke wiyao ub tenaolom su bao haklemi tomb ne noklme saon was nen nao saboklwaebe buklemi ke wiyao. Ngub inj, tenaolom haeben saroklme sao angal hambun sao Ngaor hayaol hakl ebeyao o di men hakol bu, ne sao nao ha haklwaebe ke wiyao ko Njisesom kisesa. ");
INSERT INTO akh_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ngo tomb Njisesom ngub kisaol Seran ndam Njises kemibir kisaon, su and lobokl lobokl aondao komb bi ora bor kemi pisesa. Ngub kemi pobur Ngaor Hen Moroklme Anda and hom kem yu ora bor kemi po haen kobur ");
INSERT INTO akh_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","obum Njises bor kakl, Ngaoron mbuk waebom ke wiyao ub nje hanom aongao lu menjao nao bin ko Ngaorom obun angal mini wesao baeben kao kaloklaol, nje mbinin ki hobaol po tibanin leming, nje heneng ora Ngaoron Isi yao sin ngol habur unu ngo ora bor bonge kisesa. ");
INSERT INTO akh_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ngub kisaol Njisesom obun angal ngon ko san lubur kakl, Ngaoron angal ukl mend di ngub ke wiyao. Njen Aorao Ngaor bor menjao mejao nao mao ba handaebe ke wiyao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ngo tomb Seran ndam wakl harbor aondao yu manda ora mendel kemi pobur kisaon, obum su hambun bor tangar tangarom maomb bo haroklme ub hesa mbinin osisao hambun sao ebe ebe sao su bor haraoklao sao baeben kab muwalisesa. ");
INSERT INTO akh_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ngub muwalobur obum Njises bor kakl, Njem tumu kar munu dombes ubur ni bor kaoya ko turi homae sin, yaom ngo hendeyob sao baeben hambun sao nje was njuklwao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ngo tomb Njisesom obun angal ngon ko san lubur kakl, Seran o Ngaoron mbuk waebom ngub ke wiyao. Njen Aorao Ngaor bor ora kaoya ko, obun kongon bombor o ora bibi ke wiyaong nje pu ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ngo tomb Seran ndam Njises tuwaklbir paokl pisaol, Ngaoron angal mini wesao mendborom obobur Njises obu bisur bismisa. ");
INSERT INTO akh_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ngo tomb Njisesom Njon Mbabtas Biyao Aol kalabus mao palarim ke pangaoklbir kisaon obu su Kalili pisesa. ");
INSERT INTO akh_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Obum Nasarer hakl ngub pobur kisaon su Kabenam bor po hasesa. Ngub po hasao o su Kabenam ngo ib Kalili marel sao wisaol, su ngo aol sem Sebulan hesa Naptala sem kabon su sisesa. ");
INSERT INTO akh_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ngo tomb mbes Ngaoron man mini aol Asayam waeb bu wisao ub heneng ora il so pind bisesa. Obum ngub kobur kakl, ");
INSERT INTO akh_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebulan su bor di Naptala semon su bor di Ib Kalili teb so bor di Ib Njoran kakl aeben nan paoleme baeben di Kalili tenaol sem tangar baeben di ");
INSERT INTO akh_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mbini hambun em hundur wi bor was birismi o Bao aondao ora hondoklemi. Mbini tenaol hambun em hundur wi bor was burubur Pe pae non bi birismi o Ngubi tomb mbini hayem ol bao oboklao ko man mini aol Asayam mbes ngub waeb bu wisao ub ngo tomb heneng ora il so pind bisesa. ");
INSERT INTO akh_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ngo tomb Njisesom tenaol hambun bor obun angal bib kao kalobur kakl, Yu heben maomb bo haraoklaomon ini maeb ha maomb bo haklao ub teb seng, inin kone baol monoklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ngo tomb Njises obu ib Kalili mare mare pisao tomb aol Simon obun imbi wen pange mende Pita kismil, obun haeme Andur kab wen ongon bu murukl hasbil hindisesa. ");
INSERT INTO akh_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ngub hondobur kisaon Njisesom mbibi bor kakl, Nim ibim tenaol men mereklebin lowaong ni taol mi ubuklub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ngub kisaol Pita Andur kabom penar bu ora mbibin wen ongon bimi sao nda hakl ngol bao u haen kaoklbir Njises taol mi pisbisa. ");
INSERT INTO akh_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ngo tomb kang mend aeben sao pismi tomb Njisesom hindisaol, aol is kab mend di Seberin isi Njemus Njon kab mbibin ab Seberi di mbini hambun di taokaollon burubur mbinin ib wen moroklme sao hakl bu warakl wisbil, Njisesom mbibi kab di ubuklub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ngo tomb ngub kisaol penar bu ora mbibin ib taokaoll nda hakl ngol bao u baen, mbibin ab di tuwaklbir kisbin Njises taol mi pisbisa. ");
INSERT INTO akh_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ngo tomb Njisesom su Kalili hambun bor akol bu habur kisaon, Nju semon man pangoklme anda baeben hambunon honda was bubur tenaol hambunom pangen Ngaoron angal kao kalo, obum Ngaorom ngub maeb ha maomb bo hayao ko Angal Bib Hobao Sao ngo di tenaol hambunom pangen kao kalobur, obum tenaol sen ha wismi baeben di mao enja peb bu, tenaol hambun sen tangar tangar saom kam mundub mundub habur tenaol mao kho saesao baeben di wakl mao ebe saesesa. ");
INSERT INTO akh_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ngo tomb Njisesom hambun sao ngo bu hasao sao su Siriya hambun bor pangismisa. Ngub pangobur kismin tenaol sen kam mundub mundub hae khorob ora homo wismi baeben di, tombao ndaon bor sam biri baeben di, tenaol mendbor dur mao ka sul komb hakl pub bu homo wismi baeben di, ki aongao tibae baeben di Njises obu hasaol was taokl obo wismil obum hambun mao ebe saesesa. ");
INSERT INTO akh_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ngo tomb tenaol sem aondao andub ora Kalili tenaol di, Dikapolis tenaol di, and te and lobokl lobokl aondao Njurusalem tenaol di, Njuriya tenaol di, ib Njoran kakl aeben nan paolismi baeben di, mbini hambunom Njises hasaol obo kiril mba was bubur obu was taol mi pismisa. ");
INSERT INTO akh_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ngo tomb Njisesom tenaol andub ora dengeb dengeb kismil hondobur yu manda bor sul po birisesa. Ngub birisaol obun man pange baebenom obu birisaol obo kiril mbaesmisa. ");
INSERT INTO akh_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ngo tomb obum mbini bor angal ngub kao dund bisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Mbinim mbinin kone bor dimb aolu boroklme hakl yu heben maomb bo haraoklaomon maeb ha maomb bo haen hayem ngao, mbinim bimi ub nim bun sa ko nen saboklwaebe. ");
INSERT INTO akh_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mbini de ko boroklme hakl Ngaorom taeki kobur el ib mao kur kaklaong, mbinim bimi ub nim bun sa ko nen saboklwaebe. ");
INSERT INTO akh_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Sub boroklme hakl Ngaorom nim njuklwao kisao o heneng ora hambun sao kaloklaong, mbinim bimi ub nim bun sa ko nen saboklwaebe. ");
INSERT INTO akh_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mbini oborob bimi sao dem homoklme haklon kone bor ebe no tombao hakleming, mbinim bimi ub nim bun sa ko nen saboklwaebe. ");
INSERT INTO akh_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mbini tenaol mende hond homobur saongao nao maroklme hakl Ngaorom mbini bor di hond homobur saongao nao maruklaong, mbinim bimi ub nim bun sa ko nen saboklwaebe. ");
INSERT INTO akh_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mbini kone ukl bombor u hayem haklom Ngaor hondokleming, mbinim bimi ub nim bun sa ko nen saboklwaebe. ");
INSERT INTO akh_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mbini tenaol mende bor saond nao bi taeki kao kao bu baoraoklaob ko mao bararoklme hakl bor Ngaorom nao isi wane ora hayem ko bember ha peb buklaong, mbinim bimi ub nim bun sa ko nen saboklwaebe. ");
INSERT INTO akh_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mbinim Ngaorom bibaebe keyao ub buklemil tangarom mao ke handaklemi tomb, ke hondoklemi baeben yu heben maomb bo haraoklaomon maeb ha maomb bo haen hayem ngao, mbinim bimi ub nim bun sa ko nen saboklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ngo tomb Njisesom wakl kakl, Inim ni hem ko haklemil mendborom ini maobowa peb bu hondo ko bowes bu inin mangal di andub sao buklemi tomb, inin kone bor kho nao sen turi homo was haklwaebe. ");
INSERT INTO akh_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Inin sokl aondao ora yu heben bor wiyaong turi aondao ora homo haklwaebe. Mendborom ngo bimi ub mbes ini ngo baeben nao birismi tomb di mbini Ngaoron man mini aol baeben bor di khorob ngub was bismi ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ngo tomb Njisesom ngub kobur kakl, Kunjam ne dend mao baraoklao nda ub inim tenaol hambunon kunja sao hangaen haklwaebe. Aoh, kunja ngo dend nao bi kho sa sin inim wakl asub ora bubur mao dend baklemi? Kunja ngo kho sa sin tuwaklemil tenaol hambunom do huni hisis bu hala bowes buklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Njisesom wakl kakl, Ini tenaol hambunon hib non bi hayem. Mendborom and te el isi mandal bu haklemim, and ngo mupangokl bukwaklemi ora. ");
INSERT INTO akh_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mondom laomb mao dabur be bor nao bomb pa woroklme. Ngub inj, tenaol and ngon buruklemi baeben hambun bao hael birin ko laomb mao dabur to kemol woroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Wakl kakl, Laomb mao dao ha win boroklme nda ub inim di tenaol hambun bor bao bin lowaebe. Inim ngub buklemi tomb inim oborob ngo buklemi sao hondobur mbinim inin Aorao yu heben hayao bor kaoya lemi ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ngo tomb Njisesom ngub kobur kakl, Mosesom man kisao hesa Ngaoron man mini aolom kismi ub kab nim mu tuwaklbur ibisao ko nen nao saboklwaebe ora. Nim man ngo mu tuwakl inj obowao o, nim man ngon kungni bor was ko uklu lu kang mend wakl kao dund bukl obowao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ngub kobur kakl, Nim ini bor heneng ora kao njurukl, su hesa saohar kab nao bum hae bao haenbur, Mosesom man ngo ko hase on el mend hesa angal waeb ngon ukl mend kab mondom nao mu tuwaklao ora. Ngaorom hambun sao nao bu pae tomb man ngo wi aeben ora saoklao. ");
INSERT INTO akh_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Aol mondom man ngo tuwabur tenaol mendem di man ngo tuwaen ko buwala sin, mabor Ngaorom maomb bo haklao tomb aol ngo obu imbi nao wi kang ora soklao. Ngub inj, aol mondom man ngo nao tuwaebur tenaol mendem di man ngo nao tuwaen ko kao kala sin, yu heben maomb bo haraoklaomon maeb ha maomb bo haklao tomb aol ngo obu imbi wi aondao ora haklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Njisesom ngub kobur kakl, Nim ini bor kao njun ub pangaoklaob. Nju semon man buwaloklme aol hesa Peresi baeben kabom Ngaorom man oborob ora men hakol nao bimi o, inim di man ngo oborob ora men hakol bu, oborob buklemi sao di aondao bu kond ba sao nao bu harim sin, inim Ngaorom maeb ha maomb bo hayao bor pokl buwaklemi ora ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Njisesom ngub kobur kakl, Mbes mbinim kismi ub inim ngub pangismi. Tenaol pe paen nao libi ora. Mondom pe paen la sin obu howes pangaoklao aol buruklaol teka haklao ko kam aeben aeben bismisa. ");
INSERT INTO akh_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Inim ngub pangismi o ngubi tomb nim wakl kao njun ub pangoklaob. Mondom obun aorao haeme bor ko homa sin, howes pangaoklao aol aondao buruklaol teka haen lao. Mondom obun aorao haeme bor nje kho ora hael ka sin, mbini Nju semon kansol baeben haklemi bor teka haen lao. Mondom di obun aorao haeme nor nje ne bung bi ora hael ka sin, obu Ngaorom ke mao handaraoklao is de teb sol hayao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ngub kobur kakl, Njem Ngaor bor menjao menjao kaloklbur buklesi tomb njen haemem nje turi nao heme hae ko pangae sin, ");
INSERT INTO akh_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","njem Ngaor bor kalokl buklesi sao Ngaor bor kaloklme tol bao u mbabur njen haeme mbes penar bu taeki kaebe. Ngub taeki kao kao bu paklebi tomb njem Ngaor bor kalokl buklesi sao nda kalaebe ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ngub kobur kakl, Mondom nje bor howes kokl mbao ka sin, wen harerol aol ngo nje bor howes kokl mbao lao hesa poklebi tomb njem obu bor oborob ora taeki kao kao bab kaebe. Njem ngub bab nao ke bao wabur obum nje bor ngub howes kokl kemi pen bao wari sin, obum nje howes pangaoklao aol biri kemi poklaol, howes pangoklao aol ndam nje polisman munu kaloklao. Ngo tomb polismanom nje kalabus anda bor mao palaklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Njisesom wakl kakl, Nim ini bor heneng ora kao njurukl, howes pangaoklao aol ndam nji lao sao baebenon hambun sao kang ora di nao kalae sin, njem kalabus anda ngo tuwaklbir njen anda pokl buwaklesi ora ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ngo tomb Njisesom ngub kobur kakl, Mbes mbinim kismi ub inim di ngub pangismi. Ten aol kabom paes nao puklwaebe ora. ");
INSERT INTO akh_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ngub kismi o ngubi tomb nim wakl kao njun. Mondom ten elom hondobur heb homa sin obun kone bor paes kemi peyao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ngub kobur kakl, Njen el tao nanom nje saokl mao waeb so ba sin njen el ngo toklo tuwaebe. Njen toklo kang ora par hakl pa sin nje ebe haklesi o, njen toklo hambun is de bor pa sin nje khorob ora haklesi ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Njen ki tao nanom nje saokl mao waeb so ba sin njen ki ngo pe tuwaebe. Njen ki aongao kab pe tuwabur hari sin ebe haklesi o, njen toklo hambun is de bor pa sin nje khorob ora haklesi ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Njisesom ngub kobur kakl, Mbes ngub di kismi. Aol mondom obun were anda pu lowao ko nen soba sin, obun ten ngo anda pu koklbur bobae waeb buklao kismisa. ");
INSERT INTO akh_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ngub kismi o ngubi tomb nim wakl kao njun. Ten mend aol paes nao penbur obun aolim ten ngo anda pu ka sin, aol ngom obun were ngo paes mao paklao ora. Aol mondom di ten obun aolim tuwae mend buruklao o taol ba sin, obum ten ngo di paes ora kemi poklao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Njisesom ngub kobur kakl, Mbinim mbes tenaol mende bor kao kalismi ub inim di ngub pangismi. Njem Aorao Aondao bor mao kobur nao peyaebe ora. Njem mao kobur Aorao Aondao bor nim buklwao lesi sao bib ora kismisa. ");
INSERT INTO akh_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ngub kismi o ngubi tomb nim wakl kao njun. Nim ngub buklwao ora kobur mao nao lowaebe ora. Yu heben bor Ngaorom maomb bo haraoklao on seya non bi wiyaong, heben mao* nao lowaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Njisesom ngub kobur kakl, Su ngo di Ngaor obun aongao mao aolaraoklao to non bi wiyaong, su ngo mao di nao lowaebe ora. Su Njurusalem di Aol Wesmbao Aondao ndan and lobokl lobokl hayaong, su ngo mao di nao lowaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Njen wesmbao iri bombere sa sin ukl mend haek bin kokl buwaklesi. Aoh, haek bi was sa sin ukl mend bomb den kokl buwaklesing, inin wesmbao mao di nao lowaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ngub inj, inin kone bor e kokl ko nen sobaem sin e ora lowaebe. Inj kokl ko nen sobaem sin, ngo inj ora lowaebe. Inim kang mend habara kaem sin, khorob mao baraoklaomon kao lao ub lemi ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Njisesom ngub kobur kakl, Mbes mbinim kismi ub inim ngub pangismi. El kab kab dob, waonu kab kab di dob was bimao kismisa. ");
INSERT INTO akh_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ngub kismi o ngubi tomb nim wakl kao njun. Mondom nje bor khorob ba sin njem wakl obu bor khorob bu san nao libi. Aol mondom njen payo mende nan la sin, njem wakl payo mende nan lin ub baol minibi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ngub kobur kakl, Mondom njen siyor muklbur nje bor howes ka sin, njen toklo and turub bi di bao kalaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Wakl kakl, Polisman mondom di obun mbek nu nje bor kang el bombor ora mu taka ko nja sin, njem kang mend enderael sao aol sem tangar menden su ungulabur tu kalaebe. ");
INSERT INTO akh_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mondom di san luklwaong nji ka sin bao kalaebe. Mondom di ora nji ka sin ngo di bao kalaebe ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Njisesom ngub kobur kakl, Mbes mbinim kismi ub inim di ngub pangismi. Inim inin tenaol sango baeben was hond homobur kone wibaebe. Inim inin saond bi baeben bor hond nao hemebur ko was homoklwaebe kismisa. ");
INSERT INTO akh_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ngub kismi o ngubi tomb nim wakl kao njun. Inin saond bi bor di hond homobur kone wibaebe ora. Mendborom ini hondo ko bowes baem sin, tenaol ngo hakl bisur bibi ko Ngaor bor kao kaloklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Wakl kakl, Inim ngub buklemi tomb Ngaorom biyao ub ora buklemil, ini inin Aorao yu heben hayaon isi wane ora buruklemi. Obum obun nar di tenaol kho ebe hambunon den kaesao. Obum tenaol khorob bimi baeben hesa oborob bimi baeben kab kobaranon em bor se di eben ko haraoklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ngub kobur kakl, Inim tenaol mendbor ini bor turi homo kone uklemi o bor was inim di turi homo kone u harim sin, mone takis paes habara bor bor mu khorob bimi aol baebenom di ngub biming, Ngaorom ini asub ko turi homo bisur buklaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Njisesom ngub kobur kakl, Inim inin tenaol sango baeben was turi homo ki siken baem sin, man nao pange baebenom di mbini hakl hakl ngub biming inim oborob sao asao was buklemib? kisea. ");
INSERT INTO akh_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Wakl kakl, Ngub inj, inin Aorao yu heben hayao om tenaol hambun bor hond homo kone dund se ukl bombor ora u hayao ub, inim di ngub bibaebe ko Njisesom ngu kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Njisesom ngub kobur kakl, Inim Ngaor bor kaloklemi sao tenaol mendem henden ko pangobur kaloklemi hondoklwaebe. Tenaolom was henden ko pangobur kalaem sin, inin Aorao heben hayaomon inin ngon san nao luklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ngub kobur kakl, Inim tenaol menjao nao wi boroklme baeben bor kang menjao kalaem sin, mendborom Nju semon man pangoklme anda bor di harer pobobur di ebekone pobur kaloklme nda ub, inim di tenaol mendem henden ko pangobur nao kaloklwaebe ora kisesa. Wakl kakl, Tenaolom mbini aol hobao hae ken ko kaloklme o nim ini kao njun ub pangoklaob. Tenaolom mbini bor nje aol hobao hael lemi tomb kone bor mao haongaoklaroklme anga ngo mbinim sokl ora moroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ngub inj, inim tenaol menjao nao wi buruklemi baeben bisur baem sin, inim menjao nen nao sabebur sub kal suba kaloklwaebe ora. ");
INSERT INTO akh_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Inim mende hond homobur ngub buklemi tomb inin Aoraom hambun sao mupango buklemi sao di hend ha was hayaol, obum inim ngo buklemi on sokl njuklao ora ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Njisesom ngub kobur kakl, Inim Ngaor kao kaloklemi tomb tenaol maobowa ebekone puklmi baebenom bimi nda ub nao bibaebe ora. Mbinim Nju semon man pangoklme anda bor di harer pobobur di tenaol hambunom mbinim Ngaor bor lome ken ko teka haroklme. Ngub bimi o nim kao njun ub pangaoklaob. Tenaolom mbini bor nje aol hobao hael lemi tomb, know bor mao haongaoklaroklme angal ngo mbinin sokl ora moroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Wakl kakl, Ngub inj, inim Ngaor bor kao kaloklemi tomb inin anda andaon tiriyao bo mbabur lemin, inim inin Aorao nao hendebur kao kaloklwaebe. Ngo tomb Aorao ndam hambun sao mupango buklemi sao di hend ha was hayaol, obum ebe pangobur inim ngo lemi sao heneng buklao ora ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ngub kobur kakl, Inim Ngaor bor kao kaloklemi tomb Ngaorom man nao pange baebenom tuman ko umaol lome nda ub angal andub ko soklo nao lowaebe ora kisera. Wakl kakl, Naom angal andub sao kam sin, mbinim Ngaorom ebe pangaoklao ko nen saboklme kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ngub kobur kakl, Ngub lomeng mbinim ngo lome ub nao lowaebe ora. Inim Ngaor bor nao kao kal hae tomb di inin Aorao Ngaorom inim asao was nao wi burubur dem homo bereyem ko ora hendeyao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Wakl kakl, Inim Ngaor bor kao kaloklemi tomb ngub lowaebe. Naon Ab nje yu heben bor bao hael Nje nao non bi inj hael ol Njen imbi baehaemen nao lomao ora. ");
INSERT INTO akh_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Njen mbib tenaol hambun maeb ha Maomb bo hakl ebebe. Heben bor njen konem nen sobale ub beme o Sul tenaolom di ngub baomun kaebe. ");
INSERT INTO akh_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Naon ne ngubi tomb naomun di taol bu njibi. ");
INSERT INTO akh_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tenaol mendborom nao bor khorob bimi sao Saongao nao mari tuwaroklmao nda ub Njem di naom khorob bimao sao Saongao nao mari kunaebe. ");
INSERT INTO akh_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Naon kone bor khorob bi lao tom Khorob nao baomun kaebe. Kho hambun sao oboklao tomb nao hambun bu mibi. Njen mbib was tenaol hambun maomb bo harili. Njen mbib was buri palo harili. Njen mbib was bao bi hakol bili. Heneng ora. lowaebe ko kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ngub kobur kakl, Tenaol mendborom ini bor khorob bimi sao inim saongao nao maribur tuwarim sin, inin Aorao heben hayaomon di inim khorob bimi saon saongao nao mari kunaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ngub inj, tenaol mendborom ini bor khorob buklemi sao saongao mar hakol bubur nao tuwarim sin, inin Ab yu heben hayaom di inim khorob bimi sao saongao mar hakol bubur nao kunaklao ora ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ngo tomb Njisesom ngub kobur kakl, Inim Ngaor bor nen saboklbur ne tuwa paolaem sin, mendborom ebekone pobur bimi nda ub wil nao homo wibaebe ora. Ngaor bor nen saboklbur ne tuwa paoloklme ko tenaol hambunom henden ko, mbinim wil homo taokl akol akol bimi. Ngub bimi o nim heneng ora kao njurukl, tenaolom mbini bor oborob ora bili lemi tomb kone bor mao haongaoklaroklme angal ngo mbinin sokl ora moroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ngub inj, inim Ngaor bor nen saboklbur ne tuwa paolaem sin, inin el wil bor wes wes lubur, inim wesmbao iri bor di oborob ora kom bu perekeklemi tomb ");
INSERT INTO akh_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tenaol mendborom inim menjao beyem ko nen nao saboklemi. Ngo tomb inim inin Aorao nao hende haklemi o, obu bomborom ebe hend ha hayao. Inin Aorao ndam inim bimi sao hend ha was habur obum was inin san luklao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Njisesom ngub kobur kakl, Inim su ngol osisao hambun sao nao maru u haklwaebe. Su ngol woroklme sao non aoll horom di naoklao. Kuwi i taoklao nda ub i di taoklao. Paes noklme aolom di tiriyao kombo paes muklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Wakl kakl, Ngub inj, inin osisao hambun sao ebe baeben hebenol maru wi non bu haklwaebe. Heben bor uklemi sao aoll horom di nao naoklao. Kuwi i taoklao nda ub di nao taoklao. Paes noklme aolom di paes nao muklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Wakl kakl, Inin sul ebe sao was mondom ini hibi lao mib biyao ndisao baebenol was kone u harim sin, inin kone di ngol bao uklao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Njisesom ngub kobur kakl, Njen el njen toklon laomb ora yao. Njen el ebe ora soklaol oborob ora hendae sin, njen toklo hambun bao bi ora soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ngub inj, njen el di kho sa sin njen toklo hambun di em hundur wi ora soklao. Njen toklo bao mao baraoklao saom oborob bao nao mao barob sin, em hundur waoraoklao nda ub aondao bu ora mao mur komb pae sao uklao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Njisesom ngub kobur kakl, Kongon biyao aol bomborom maomb bo haroklbe aol kabon kongon bukl buwaklao ora kisesa. Wakl kakl, Aol ngo obum aol mende bor turi homo kone uklao o obum mende bor makl was homoklao. Is mende turi homo taol mi poklao o is mende makl homobur mesao kaloklao kisesa. Ngub kobur kakl, Inim Ngaor hesa mone kab kobaranol kone ukl buwaklemi ora ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ngub kobur kakl, Ngubi tomb nim ini bor kao njanda ub inin mbib haklemi on nen sabobur, naom ne asao was noklmao? ib di asao was noklmao? toklol samoklme sao di asao was samoklmaob ko? inin kone bor kang sao aondao sao bin buru kho nao sen boroklwaebe ora. Ngaorom inim ne was neklemin ko ini mao hasao be? Obum inim samoklme sao was sameklemin ko ini warisao be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ngub kobur kakl, Sao ngo pebeyem o haondaoklaob. Mbinim ne noklme sao is il we nao boklme. Mbinim and bor di ne noklemi sao hakl nao maru woroklme o, inin Aorao heben hayaomon was mbini ne taol bu kalaoklao kisesa. Wakl kakl, Ngaorom sao nao hobao sao hakl ne taol bu kalekle om, ini tenaol hobao sao ora hayem ol daol bibir ora taol bu njuklao ko nen nao sabeyem be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wakl kakl, Mondom obun kone kimb bubur mendborom penar bu homoklme ub nao heme, ni ngo tomb homoklwao ko ndi tibakl buwaklao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ngub kobur kakl, Asub ko inin kone bor kang sao aondao sao bin burubur inin toklol samoklme sao asao was samoklmaob ko nen sabo hem ko hayem? Inim is humb il ki kao ko saoklao nda ub nen sabaoklaob. Is ngo baebenom kongon di menjao nao bimi. Mbinim lab lab kongon di nao bimi o ");
INSERT INTO akh_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","nim ini kao njun ub pangaoklaob. Mbes Solomon obu aol homa aondao ora habur obun lab lab di osisao hambun sao di buklhoma iri non bi maru u hasao o, is humb il ki kao ko saoklao ndam aol Solomon ngon yaor ngo bu hasao ub men mbaraoklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Wakl kakl, Em hinim den kang kang nao hobao sao mend haraoklao ndisao haklon daol Ngaorom oborob sor mubur yaor baraoklao o, ekera nan mondom den ngo bo den haoreyao tomb bao dao peklao ora. Ngub buklao o den nao hobao sao ngo hakl yaor mao barekle om, obum ini daol bibir maeb ha inim samoklemi sao di taol bu njuklaong, inim asub ko obul hul nao hae hayem? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Wakl kakl, Inim ngub biming, naom ne asao was noklmao? Ib di asao was noklmaob ko? inin kone bor kang sao aondao sao bin buru kho sen nao boroklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ngub kobur kakl, Hambun sao ngo sao hakl sun tenaol mbinin aorao ngubi mend nao hae haroklme baebenom was asub buklwaob ko? nen sabo hem kaeb se hayem kisesa. Wakl kakl, Ngub bimi o ini non inin Aorao yu heben hayaom inim asao was nao wi hayem ko ora hendeyao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Njisesom ngub kobur kakl, Ngub beyaol inim pibnao oran ni Ngaorom maeb ha maomb bo haen ko hesa obum kone ebe dund se ukl bombor u hayao ub kab was hem ko es baem sin, obum inim tangar tangar sao ngo wa win habur hem lemi sao baeben hambun sao ebe njuklao ora kisea. ");
INSERT INTO akh_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ngub kobur kakl, Inim ngub nen sabobur lemin, ekera asub buklwaob ko nen sabobur inin kone bor kang sao aondao sao bin nao boroklwaebe ora. Ni ekera ke kang mend hondoklwao saol ko and kend nao bembero wibaebe ora. Ekera asao was buklaob ko inim nao hendebur, baehaemen ora and kend bembero uklemi ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Njisesom ngub kobur kakl, Njem tenaol mende bor nje kho hael ebe hael ko te mao sara nao sablo haebe. Njem tenaol mende bor kho ebe ko ngub te mao sara nao sablae sin, mondom nje di te mao sara nao sabloklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ngub kobur kakl, Njem tenaol mendem khorob buklemi sao hondo haklesi ub Ngaorom njem buklesi sao di hondo haklao. Njem tenaol mende bor obum khorob ngub baeben ora bisao ko ya pubung lu u haklesi ub Ngaorom njem khorob buklesi sao di ya pubung lu u haklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Wakl kakl, And kindbarom njen elol as mba hayaol nje el kho ora hael o, njen elol ngo as mba hayao on mbes nen nao sabebur njen tenaol sangon elol huni kang ora uklao o asub hondobur mu tuwakan lesib? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Wakl kakl, And kindbaron njen elol as mba haenbur, njem asub bubur njen tenaol sango bor njen elol huni kang abo wi o mu tuwakan lesib ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wakl kakl, Songolol aol hobao o, njen elol and kindbar o mbes mu tuwaebe. Ngub mu tuwari sin njen tenaol sangon elol huni kang uklao o di ebe hondo maklesi ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ngub kobur kakl, Bombor sao mende hobao sao ora komb bi wa sin buklhoma nao kalaebe ora. Njem kalae sin wakl mbinim baol munubur nje noklemi ora. Njen kullmundu di njen mone andub ora tuwabur dob bising, some hae bor nao wibi. Njem some haklaol wae sin, inin kullmundu ebe ngo mbinin aongaom hala bowes buklemi ora ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Njisesom ngub kobur kakl, Tenaol mondom Ngaor bor nji ka sin nji lao sao kaloklao. Tenaol mondom di menjao es ba sin hend waklao. Tenaol mondom di tiriyao kombael ni obom ko lu nga nga ko harob sin Ngaorom tiriyao komboklao ora. Inim Ngaor bor nji lemi tomb njuklao ora. Inim es buklemi sao di hend waklemi. Inim tiriyao kombael ni obon ko lu nga nga lemi tomb Ngaorom tiriyao komboklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ngub kobur kakl, Nongnason aorao o hakl o, inin isi kang mend buruklao om ne kang mend non nji ka sin inim obu han kaloklemi be? ");
INSERT INTO akh_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nas kang ngom ib wen non nji ka sin inim obu suklumb kaloklemi be? Ngub inj ora. ");
INSERT INTO akh_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ini aol kone kho u haroklme haklom o, inin nongnas bor oborob ora kone kimb bu kaloklme ndal, inin Aorao yu heben hayaomon daol non bibir ora tenaol mendbor obu bor kao kaloklme baeben o bor aondao bu ora hobao sao was taol bu kaloklao ora ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ngub kobur kakl, Mosesom man hambun sao kisao o hesa Ngaoron man mini aol baeben kabom kismi ub kabon man te bombor ngo lowaong pangoklwaebe. Tenaol mendborom njem turi hemenin ko bimi nda ub, inim di tenaol aebenol haklemim turi hemem sao was bibaebe ora ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Njisesom ngub kobur kakl, Paeb tiriyao dengbele on puklwaebe. Ke hondokl puklmi harer on aondao baklaebele yaol, harer ngon tenaol andubom es nao bibur bao was puklmi. ");
INSERT INTO akh_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Haeben sakl puklmi tiriyao paeb kerob non bi yaol, harer ngon tenaol kang baoklmend es beme om was hend waroklme. Tiriyao ngon kang mendborom hend waklbur hayem ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Njisesom ngub kobur kakl, Man kho mini aolom lome ub lemi o pangobur, heneng lem ko nen saboklemi hondoklwaebe. Mbini ngo baeben some sib lu noklbur buklhoma aondao deran ker sem non bi hayem o, mbinim some sib men aolubur ini maobowakl oboklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ngub kobur kakl, Mbinim il so pind biklemi tomb mbinim ngo sao ngo beyem ko inim mbinin kone bor wiyao ub ebe hondoklemi kisesa. Wakl kakl, Saon hesmbulom timbaol saoklaol taloklme be? Bundinom ang saoklaol taloklme be? Nao saoklao orang ");
INSERT INTO akh_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","is ebe baebenom di il ebe was saoklao. Is kho baebenom il di kho was saoklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ngub kobur kakl, Is ebem il kho nao saoklao nda ub is khom di il ebe sokl buwaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Wakl kakl, Is mondom il ebe nao sa sin, mbinim is ngo wesu haoruklemi ora. ");
INSERT INTO akh_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Isom il ngo saoklao nda ub man kho mini aolom bu pind biklemi sao di inim ebe hondoklemi ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ngub kobur kakl, Ni bor Aorao o Aorao o lome baeben hambun ora Ngaorom maeb ha maomb bo hayao bor nao poklemi ora. Ngub inj, nao Ab yu heben hayaomon keyao sao hul nao haroklme baebenom was poklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Wakl kakl, Bao ngo bu pindib paklao tomb mendborom ni bor Aorao o nao Aorao ka lemi. Ngub kobur lemin naom njen imbi kobur Ngaoron man kao kalismao. Sam di andub taol deraesmao. Naom njen imbi kobur, tenaolom hambun sao bukl buwaesmi sao hakl di ebe bismao lom nde lemi. ");
INSERT INTO akh_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ngub lemi tomb nim ngub lowao. Inim khorob was bismil nim ini ngo baeben mbes kang ora di nao hondowaong, ni hae ol nao hae puklub ora lowae ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Njisesom ngub kobur kakl, Tenaol mendbor nao angal pangobur hul nao haroklme baeben aol kone ebe wi and han kemol bi mend hasesa ubi haklemi. Aol ngom obun and han biri oral bisesa. ");
INSERT INTO akh_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ngo tomb se aondao ora obobur ib wae aondao ora disesa. Ib wae ngub dobur kisaon popo di su and te ngo bor aondao ora ibisesa. Ngub ibisao o aol ngom obun and han biri oral han mandaemol bisaol, obun and ngol kho so kundi bowes nao bisao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Wakl kakl, Tenaol mendbor nao angal pangobur o hul haroklme baeben aol mende kon nao wi ib mu kolokl barael and bi mend hasesa ubi haklemi. Aol ngom obun and su tombo taem se ib mul bisesa. ");
INSERT INTO akh_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ngo tomb se aondao ora ibisaol, ib wae di aondao bu ora dobur posabsu di aondao bu ora ibisesa. Ngub ibisao tomb and ngo kundi taokl paokl ora pobur kisaon, sul karu tibabur khorob ora kundi hakl buri kisao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ngo tomb Njisesom angal ngo baeben kao paesao tomb tenaol aondao khorob ora ngo hasmi baebenom obum angal ngo kao kalisao nda pangobur burir bismisa. ");
INSERT INTO akh_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ngo tomb Njisesom angal ebe ngo kao dund bisao ub mbini Nju semon man buwaloklme aolom buwaloklme ub inj, obum kone kikil bi, bi make lome aolom angal buri palobur lome nda ub kobur, angal ngo kao kalisaol mbinim burir aondao ora bismisa. ");
INSERT INTO akh_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ngo tomb Njises obu yu manda bor haklbir inin ibisaol, tenaol andub ora obun mama taol mi ibismisa. ");
INSERT INTO akh_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ngo tomb aol maollun bi is mend hasao o, Njises obu hasaol teb so obobur tumu kar munu dombes ubur kakl, Aol aondao o njem ni ebe mao sakl ko pangal sin, njem ni ebe mao saklesi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ngub kisaol Njisesom obun kim aol ndan toklol men mbabur kakl, Nim nje ebe sen ko pangakl ol, njen toklo bor der nog biye baeben di ngubi tomb ebe saokl kisaol, bombor ngo tomb aol maollun bi nda ebe bao sisaol obun toklo songol heneng bao ibisesa. ");
INSERT INTO akh_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ngo tomb Njisesom aol ngo bor angal buriyao ora kobur kakl, Njem ni ebe mao sanao ko mendel nao kao kalaebe ora. Ngub inj, njem ngubi tomb Nju semon baolum aol bor bombor o nao songol ebe sa ko muwalokl pu. Ngub pobur lesin mbes Mosesom nje non bi baebenom bibaebe kisao ub, tenaol hambunom njen toklo songol wakl ebe sene ko henden ub njem Ngaor bor kalo mabaorao haoribi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ngo tomb Njises obu su Kabenam pisaol, Orom semon ami sem maomb bo haraoklao aol mondom obobur Njises bor kao deb deb bubur kakl, ");
INSERT INTO akh_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Aol aondao o, nao kongon biyao nas sen habur nao anda bor bao u mba hayao o, obun ki aongao tibarabur tenda aondao ora no wiyao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ngub kisaol Njisesom obu bor kakl, Nim nas ngo ebe mao enjakl pon kisesa. ");
INSERT INTO akh_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ngo tomb ami sem maomb bo haraoklao aol ndam obun angal ngon ko san lubur kakl, Aol aondao o, ni kho ora hae ol njem di nao anda ebeb nao se haeng, njen angalom kang menjao kokl sin nao kongon biyao nas ngo wakl mao enjakla kisesa. ");
INSERT INTO akh_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ngub kobur kakl, Nim ngo kakl o, ni kongon bibi ko mao hasaomon ni bor di ngo sao ngo sao bibi keyao tomb biyu. Nim di nao ami baeben maomb bo haruklu o, nim nao ami ngon is mend bor ngub kaklo. Nje pu kaklo, ngo tomb puklao. Is mende bor ngub kaklo. Nje ib kaklo, ngo tomb ubuklao. Ngo tomb nao kongon biyao aol bor ngub kaklo. Njem kongon ngo bibi kaklo ngo tomb biyaol, njem di angalom manjao lesi tomb buklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ngub kisaol Njisesom aol ndan angal pango burir biyubur kisaon tenaol obun mama taol mi ibismi baeben bor kakl, Nim ini bor heneng ora kao njurukl, aol sem tangar ngom nil ngo hul ha harekle ub Nju sem tenaol baebenon ngubi is mend nao hondowao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ngub kobur kakl, Tenaol mendbor yu nan boroklme baeben di, unu nan boroklme baeben di, mbini hambun Eberehem Isak Njekob ngo baeben daol yu heben maomb bo haraoklaomon maeb ha maomb bo haraoklao bor maomunu burubur ne no buruklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Wakl kakl, Ngub buklemi o tenaol mendbor Ngaor obum maeb ha maomb bo hayao bor eben ko nen sabisao o makl homo nao ubuklmi baeben, Ngaorom mbini dera nan em hundur aondao ora wi bor pen taol deraklaol, mbinim ngo bor saongao kengorokl no de khorob ora ko haklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ngub kobur Njisesom ami sem maomb bo haraoklao aol nda bor kakl, Nje anda pu. Njem nil hul ha harili ub menjao buklao ko pangae sin, heneng buklao ora kisesa. Bombor ngo tomb was ami sem maomb bo haraoklao aol ndan kongon biyao nas nda ebe bao sisesa. ");
INSERT INTO akh_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ngo tomb Njisesom Pitan anda po hondabur hindisaol, Pitan weren ingi obun toklo turub aondao ora bu sen habur u paolu wisaol hindisesa. ");
INSERT INTO akh_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ngub u mba hasaol Njisesom ten ndan kil waraesao tomb pob turub bu sen khorob ora ngo homo wisao nda ebe sobur kur kisaol, ten ndam Njiseson ne nen ko man baesesa. ");
INSERT INTO akh_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ngo tomb ombonao nar anda bombisao tomb tenaol mbinin tombao bor sam biri andub ora Njises hasaol was taokl obo kiril mbaesmil, Njisesom sam ngo tenaolon tombao bor birisao hakl obun angalom pen ko taol derabur, obum tenaol sen kam mundub mundub bi hae himismi baeben di hambun mao ebe saesesa. ");
INSERT INTO akh_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ngo tomb Njisesom ngub ngo bu hasao o, mbes Ngaoron man mini aol Asayam mbuk waeb ngub bu wisesa. Obum nao tenaol kho mao saraoklao sao baeben Taol peyo sen menjao menjao hambun saom Nao tenaol mao homaklao tomb di Obum mu tuwa peb bu ebe mao saklao ko Asayam mbuk waeb bu wisao ub ngo tomb heneng ora il so pind bisesa. ");
INSERT INTO akh_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ngo tomb Njises obu hasaol tenaol andub ora ha akol bismil hondobur kakl, Naom ib mal ngon mare mende nan mbi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ngo tomb Nju semon man buwaloklao aol bombor mend obobur Njises bor kakl, Aol aondao o, su nje poklesi baeben hambun bor di nim nje taol mi was obobur, nje haru akol was buklwao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ngub kisaol Njisesom obu bor kakl, Buklhoma deran ker baebenom su sowal tomb pae bor paoloklme. Sao baebenom di and bu paoloklme kisesa. Mbinim ngub bimi o Aolon Isi Ora obu haraoklao su mend nao wiyaong, njem heneng ora ni turi homo taol mi akol was buklesi be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ngo tomb obun man pange mend ngol birisao om di Njises bor kakl, Aol aondao o nim di nje taol mi oboklwao o, nao ab mbes homoklao tomb maol bu mbaklbir oboklwaong, njem menjao nen nao sobaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ngub kisaol Njisesom obu bor kakl, Inj ora, mbinin kone bor pe pae non bi haroklme baebenom tenaol pe pae ebe maol bukleming, njem ni taol mi ib ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ngo tomb Njises obu ib taokaollon baoraoklbir pisaol, obun man pange baeben di obu taol mi pismil mbini haru pismisa. ");
INSERT INTO akh_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ngo tomb ib mal aondao ngo bor posabsu aondao ora obobur ib aondao bu ora lu taongul taongul ko lu dengeno taokl en aeben bubur kisaon, ib taokaoll ngon ndaon bor ib do tu ndakl ke ke bisao o, Njises obu ib taokaoll ndaon ngo bor u paolu wisesa. ");
INSERT INTO akh_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ngo tomb mbinim obu po mao tekabur obu bor kakl, Aorao Aondao o, ib ngo bor nao ngo pe barakl ke ke bu bum hayom ngao, njem nao bu mi kismisa. ");
INSERT INTO akh_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ngub kismil Njisesom mbini bor kakl, Inim asub ko pakl hemeklem? Inim kone kab teb marubur Ngaorol hul nao hae haroklme be? kisesa. Ngub kobur obum teka peyobur kisaon, posabu nda hesa ib ngo lu dengeno taokl en aeben bisao nda kab bor taolu lubur ngub nao bi kur kao kisaol, posabsu nda kur kisaol ib ndam di el el kang ora di nao bi sowa paesesa. ");
INSERT INTO akh_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ngo tomb Njisesom ngub bisaol hondobur, pakl homo burisao po burir biyubur mbini hakl hakl kakl, Wao. Posabsu hesa ib kabom hul nao hae angal pangen ke aol ngo obu asub bi mend e bo? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ngo tomb Njises obu ib mal aondao ngon mare mende nan Ngerasa semon su bor pisaol, aol mbibin tombao bor sam biri is kab mend mbibi aol maol bor and waru paolu hasbi o Njises obu hen mukl ibisbisa. Ngo tomb aol ngo kab mbibi deran ker pe non bi ora hasbil, tenaol hambunom pakl homobur mbibi kab and waru paolisbi hareron teb sol nao pibismisa. ");
INSERT INTO akh_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ngo tomb aol nda kabom angal aondao bu ora kobur kakl, Nje Ngaoron Isi ora hael ol nje tangar aondao ora hael ngao, njem yao bor asub ko ora ke mao handakl ibil balem? kisbisa. Mbibim ngub kobur kakl, Hambun sao nao bu pae tomb njem penar bu enjo ngo bor yao ke mao handak ibil be? kisbisa. ");
INSERT INTO akh_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ngo tomb some aondao andub ora mend, kang mend enderael sao pil nao mba hasmisa. ");
INSERT INTO akh_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ngo tomb aol nda kabon tombao bor sam birismi nda baebenom Njises bor buri palo kao deb deb bubur kakl, Njem nao lu taol derak sin, naom some ngo hayem baebenom tombao bor ora taol ndaebe kismisa. ");
INSERT INTO akh_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ngo tomb Njisesom mbini bor kakl, Ini some ngo baebenon tombao bor hondakl puklub kisaol, sam ngo birismi nda baebenom aol nda kab tuwaklbir some nda baebenon tombao bor bombokl engel was bismisa. Ngo tomb some nda baeben su bare kho ora mendbor akl was hellenj kao mi pobur ib mal aondao mend wisao bor was bongeyokl engel bismil, hambun ora ib no pe baraesmisa. ");
INSERT INTO akh_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ngo tomb aol some ngo baeben kalo hasmi nda baebenom pakl khorob ora pobur kismin, mbinin su and lobokl lobokl bor po pindib pabur tenaol hambunom pangen ngo bisao hindismi sao baeben kao kalobur, aol is kab nda mbibin tombao bor mbes sam birisao o Njisesom taol deraesao on te di tenaol hambunom pangen kao kalismisa. ");
INSERT INTO akh_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ngo tomb su and lobokl lobokl ngo bor tenaol birismi baeben hambunom Njises hen mukl pismisa. Ngub pobur Njises obu birisaol hindismi tomb obum ngo bisao sao hondo pakl homo obu bor kao deb deb bubur kakl, Nje naon su ngol nao hae su tangar bor paokl pu ora kismisa. ");
INSERT INTO akh_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ngo tomb Njises obu ib taokaollon baoraoklbir wakl ib mal ngon mare mende nan bokeyobur, obun su ora bor po pindib paesesa. ");
INSERT INTO akh_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ngo tomb aol aongao tibae mend obun to bor win kobur Njises obu hasaol taokl ibismil, aol ngo baebenom Njises obul ngo hul ha ora habur, ngo bismi sao hondobur Njiseson aol aongao tibae nda bor kakl, Nao isi o, nim njen kone bor kho wiyao o kunarukl ngao, njen kone bor hul ha saor peyo haebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ngo tomb Nju semon man buwaloklme aol mendborom mbinin kone bor nen sab nda nda bu sub kao kao bubur kakl, Aol ngom Ngaor bor maobowa hul ha angal ngo be o kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ngo tomb mbinim ngo bu hasmi ub Njisesom ora hende sakl obum mbini bor kakl, Inim inin kone bor khorob aondao bu ora ngo nen sabeyem ub asub ko ora ngub nen sabeklem balem? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ngub kobur kakl, Inim angal awo was kend bi ko pangeyem? Aoh, nim njen kone bor kho wiyao o kunaruk kanda ub kend bi soklaol bukl buwaklwao be? be? nje tekakl pu lowao ub kend bi soklaol bukl buwaklwao ko pangeyem? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ngub kobur kakl, Ni Aolon Isi Ora hae ol sun tenaol hambunon kone bor kho wiyao sao kuna, tenaol heme di ebe tekakl pu kaeb se hae ko hendeklemin ub kobur, aol aongao tibae ngo bor kakl, Nje teka peyo, njen to abo mu minibir njen anda pu kisesa. ");
INSERT INTO akh_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ngub kisaol teka peyaoklbir obun anda pisesa. ");
INSERT INTO akh_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ngo tomb tenaol hambunom Njisesom ngo bisao sao hondobur pakl aondao ora homobur, Ngaorom obun buri ngubi tenaol bor taol bu kalekle ko nen sab heneng bubur kismin mbinim Ngaor bor kaoya kismisa. ");
INSERT INTO akh_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ngo tomb Njisesom su mendel pobur hindisaol, mone takis moroklme anda menden aol mend obun imbi Matiyu birisaol hindisesa. Ngub hondobur Njisesom obu bor kakl, Njem ni taol mi ib kisaol, obum teka peyaoklbir taol mi pisesa. ");
INSERT INTO akh_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ngo tomb Njises di obun man pange baeben di mbini aol ngon anda bor ne nklbur birismil, mone takis moroklme aol di aol mendbor khorob was bu hasmi baeben di ibismil mbini haru ne no birismisa. ");
INSERT INTO akh_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ngo tomb ngub ne no birismil, Peresi sem mendborom hondobur mbinim Njiseson man pange aol baeben bor kakl, Inin aol aondao ngom asub ko mone takis moroklme aol baeben daol khorob bimi aol baeben di maomunu ne no bereyem? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ngo tomb Njisesom ngo kismi o pangobur kakl, Tenaol sen nao hae baebenom dokta biri nao buklmi ora. Ngub inj, tenaol sen ha wimi baebenom was dokta biri puklmi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Njisesom wakl kakl, Inim Ngaorom mbuk waebom ke wiyao ub nao hendeme be? Nim tenaolom mabaorao haoroklme ub Turi nao homaklo. Nim tenaolom tenaol mende bor sub kone u Hond homoklme ub was turi homaklo ko mbuk waeb bor wisao ub Njisesom ngub kisesa. Ngub kobur kakl, Nim tenaol oborob bu haroklme baeben bor kone baol monoklwaebe kokl inj obowao ora. Ngub inj, nim tenaol khorob bimi baeben bor kone baol munu inim khorob bismi sao tuwaklwaebe kokl obowao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ngo tomb Njon Mbabtas Biyao Aolon man pange aol baebenom Njises hasaol obobur mbinim Njises bor kakl, Peresi sem baeben daol naom non Ngaor bor nen saboklbur ne tuwa paoloklmao o, njen man pange aol baebenom ngub nao bi ne bao was noklme kismisa. ");
INSERT INTO akh_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ngub kismil Njisesom mbini bor kakl, Aol mondom obun ten wen taol bubur obun tenaol sango baeben daol mbini haru bao buruklemi tomb mbinin kone bor hem ko kend bin buruklemi be? Ngub inj ka. Aol ten wen taol bi ngo obu mabor mondom su tangar bor pen laol, obun tenaol sango baeben hesa ko mende nao haklemi tomb mbinim obu hem kobur ebe ne tuwa paoluklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ngo tomb Njisesom mbini bor angal mar mende di kobur kakl, Toklo and turub bi mbes pange piri mend kaollu dir wiyao tomb, dir ngo wiyao bor mange taombuluklbur mondom lab lab buri ebe wen pange on mend nao heya moroklme. Ngub inj, mondom ngub ba sin, mbes pange piri ngon dir uklao bor manga taombuluklbur, lab lab buri ebe wen pange on mend heya muklao tomb lab lab mbes pange kang bu dir uklao nda di wakl aondao bu men and sen lao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ngub kobur kakl, Mondom ib waen wen pange di some songol be mbes pange bor nao kowe tu ndaroklme o, mondom ngub ba sin some songol be ngo dallmbe bowes bu kho soklao, ib waen ngo di sul ora kowe bowes buklao ora kisesa. Ngub inj, mbinim ib waen wen pange o some songol be di wen pange bor was kowe tu ndabur humu waem sin, kobaran wen pange kab kab sakl oborob ora uklao ko Njisesom angal mar ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ngo tomb Njisesom mbini bor angal ngub bao kao kalakl hasaol, Nju semon man pangoklme anda maomb bo haraoklao aol mend Njises obu hasaol obo tumu kar munu dombes ubur kakl, Nao wane ngubi tomb ora pe parob o, njen kim obu kang mend obo waraklesi tomb obu wakl enjoklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ngub kisaol Njises obu aol ngo hesa pisbil, Njises obun man pange baeben di mbini haru pismisa. ");
INSERT INTO akh_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ngo tomb ten is mend obu bullim anda buru kimb was bisao o, obum bao hor hambunon ngub bao ber ha haen was karasmas duteb oran pibi hasao o, ten ngom Njiseson mesao nan teb so obobur kisaon obum Njiseson lab lab kungni bor obun kim waraesesa. ");
INSERT INTO akh_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ngub waraesao o ten ngom mbes Njiseson lab labol nao waraesao tomb obun kone bor kao ndan sabur kakl, Nim Njiseson lab lab oral waraklwao tomb di nao sen ngo hae ub ebe bao soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ngo tomb Njisesom ten nda baol munu hondobur obu bor kakl, Nao wane o njem nil hul ha harili saom njen sen ngo ebe saokl ngao, njen kone bor hul ha saor peyo haebe kisesa. Ngub kisaol ten ndam bullim nda ngo buru kimb bu hasao nda ub bombor ngo tomb kur kobur ebe bao sisesa. ");
INSERT INTO akh_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ngo tomb Njises obu Nju semon man pangoklme anda maomb bo haraoklao aolon anda po pindib pabur hindisaol, aol mendborom ngon ngo hond homo hombara buburbur poll pib menger hakl ko, tenaol mendborom di de aondao bu ora kobur wi allbob ko men mba hasmisa. ");
INSERT INTO akh_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ngub bismil hondobur Njisesom tenaol ngo baeben bor kakl, Nong kang ngo obu ora nao pe pae u paolu wing ini dera puklub kisaol, mbinim obu ora pe parob nda o le ko pangobur kismin mbinin Njises obu bor khorob ora kir ko maobowaesmisa. ");
INSERT INTO akh_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ngo tomb Njisesom tenaol ngo baeben puklub ko taol peyobur kisaon, obu nong kang nda u mba hasaol hondabur nong pe pae kang ngon kil men misaol tekasesa. ");
INSERT INTO akh_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ngub bisaol Njisesom ngo bisao saon arman angal bib su ngo baeben hambun bor pib ngaesaol tenaol hambunom pangismisa. ");
INSERT INTO akh_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ngo tomb Njises obu su ngol haklbir su mendel pisaol, aol el bokl mini kab mondom Njises obu taol mi obo angal aondao bu ora kobur kakl, Nje Debir semon isi o njem yao kab hond hom kisbisa. ");
INSERT INTO akh_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ngo tomb obu and menden hondaesaol, aol el kho ngo kab di ngol ibisbil Njisesom mbibi bor kakl, Nim ibi ebe mao saeb se hae ko pangekleb be? kisaol mbibim obu bor kakl, Aol aondao o, e ka kisbisa. ");
INSERT INTO akh_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ngo tomb Njisesom aol nda kabon el bor obun kim men mbabur kakl, Ibim nil ngo hul ha habur heneng buklao ko nen saboklbe ub ibi bor heneng ora buklao kisaol ");
INSERT INTO akh_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","mbibin el bor bao bisesa. Ngo tomb Njisesom mbibi bor angal buriyab ora kao kalobur kakl, Obum yaon el mao ebe sanao ko tenaol mondom pangen kao kaloklebi hondoklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ngub kisao o aol el kho Njisesom ebe mao saesao nda kabom pobur kisbin, mbibim hul habur Njisesom ngo bisao sao tenaol hambunom pangen kisbil, su ngo baeben hambun bor pangismisa. ");
INSERT INTO akh_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ngo tomb Njises obun man pange baeben di mbini hambun pismil, aol angal nao ke obun tombao bor sam biri mend kemi ibismil aol angal nao ke ndam Njises obu hasaol ibisesa. ");
INSERT INTO akh_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ngo tomb Njisesom aol ngon tombao bor sam ngo birisao nda taol deraesaol aol nda wakl angal kisesa. Ngub bisaol tenaol mendborom ngo bisao nda hondobur burir biyu pakl homobur kakl, Mbes Isreyel tenaolon su ngo bor ngubi mend bisaol nao hindismao kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ngub kismi o Peresi tenaol baebenom kakl, Obum tenaolon sam taol dera hae o, Seran semon wesmbao aondao oran burim taol dera hae kismisa. ");
INSERT INTO akh_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ngo tomb Njisesom su and lobokl lobokl baeben bor di su and te kang baeben bor di akol bu habur kisaon, obum Nju semon man pangoklme anda baeben hambunon honda was bubur, Ngaoron angal bib hobao sao kao kalo Ngaorom ngub maeb ha maomb bo hayao ko tenaol hambunom pangen kao kalisesa. Obum ngub bubur kisaon tenaol mendbor sen kam mundub mundub ha homo wismi baeben di, mendbor mbinim toklo kone bor kend bin birismi baeben di ebe mao sam akol bu hasesa. ");
INSERT INTO akh_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ngo tomb tenaol andub ora some sib aorao nao hae non bi khorob ora habur, mondom nao bisur bib se hayao ko nen nao sabe mbinin kone bor ngil ngaol ken burubur kend aondao ora bin birismil, Njisesom obun kone bor mbini hond aondao ora himisesa. ");
INSERT INTO akh_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ngo tomb Njisesom ngub hondobur obun man pange aol baeben bor kakl, Aoraon em bor ne andub ora ngo bo do kimb be o, em il ngo baeben talaeb se kongon bimi aol andub nao hayem ngao, ");
INSERT INTO akh_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Em Aoraom aol mendbor obun em il ngo talo maemb kokl eben ken ub inim obu bor kao kal ha was haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ngo tomb Njisesom obun man pange aol duteb ubuklub kobur kisaon, tenaolon tombao bor sam buruklao baeben taol dera, mendbor sen hae uklemi baeben di mao enja, sen mendbor mbinin toklo buri nao palebur kend bin buruklemi baeben di ebe mao sa, mbinim ngub bin ko Njisesom mbini bor obun buri taol bu kalisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ngub bisao o Njiseson angal bib hobao sao kam akol bu hasmi aol duteb ngon imbi ngo was sisesa. Pibnao oran Simon obun imbi mende Pita sisaol obun haeme Andur di, Seberin isi Njemus hesa Njon kab di, ");
INSERT INTO akh_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilib hesa Batolimu kab di, Tomas di, Matiyu obu mbes mone takis mu hasao aol nda di, Njemus mende Aolpason isi sisaol obu di, Tariyas di, ");
INSERT INTO akh_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon mende obu Selor sem sisaol ngo obu di, Iskeriyaor Njuras obum mabor Njises karu lubur Njises lukl bismi baeben munu kalisao aol nda di ngo baeben sisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ngo tomb Njisesom aol duteb ngo baeben angal bib hobao sao ngo kam akol bukl puklub kobur kakl, Inim mbini su Tenaol Sem Tangar baeben haroklme bor nao puklwaebe. Inim su and lobokl Sameriya bor di nao puklwaebe ora. ");
INSERT INTO akh_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ngub inj, inim Isreyel tenaol some sib aorao nao hae non bi habur bum haroklme baeben bor was puklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ngub kobur kakl, Inim ngub po angal bib ngo kao kalobur lemin, mbini bor yu heben maomb bo haraoklaomon maeb ha maomb bo haklao ub teb se ko kao kaloklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Wakl kakl, Inim ngub bubur lemin tenaol sen ha uklemi baeben mao ebe sa, tenaol mendbor ora pe paklemi baeben di wakl mao enja peb bu, tenaol mendbor maollun bi baeben di ebe mao sa songol heneng eben ko, tenaolon tombao bor sam buruklao baeben di taol deraklwaebe kisesa. Ngub kobur kakl, Nim ini bor hobao sao ngo taol bu njurukl sao baeben di inim sokl nao bi pone was mukleming, inim mbini bor di sokl nao muklbur ngub bisur bu kaloklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Njisesom ngub kobur kakl, Mone ngol di mone silba di mone hundbi kang ndisao di inin nu bor kang ora di nao maroklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Wakl kakl, Inin nu harer poboklbur maroklme sao o di nao maroklwaebe. Siyor aongao su kab di bombor was bubur mende nao maroklwaebe. Hakla tom harer poboklbur monoklme sao di nao monoklwaebe. Ngub inj, aol kongon beme baebenom sokl mib se kongon bimil, es nao buwae ne di ebe mu noklme kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Njisesom ngub kobur kakl, Inim su and lobokl lobokl aondao mendel di su kang mendel di poklemi tomb inim aol awom was ini turi homo heben heben bim ko ebe hondoklemi kisesa. Inim ngub hondobur lemin inim aol kone ebe ora wi ngo ini turi homo heben heben buklao o kab was bao ham ham bubur, inim su ngo tuwakl poklbur oran aol ngo tuwakl puklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ngub kobur kakl, Inim and ngon poklemi tomb tenaol and ngon buruklemi baeben bor ini ebe soklaong as ko haklwaebe lowaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Njisesom ngub kobur kakl, Tenaol and ngon buruklemi baebenon ebe ora ini turi homo heben heben bam bam bukl bi mend bara sin, inim mbini bor as ko haklwaebe ko ngo lemi ub mbinin kone bor hondaklaol ini turi homaem sin ebe ora soklao. Ngub inj, tenaol kone ngubi wi mend nao bara sin, inim mbini bor ngo lemi ub mbinin kone bor nao hondaklaol, mbinim ini turi nao homaem sin ngub nao ke men mba bao waklbir paokl ora puklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Wakl kakl, Aol mondom ini obun anda bor ini oborob obaeming paolemin ubuklub nao ke bao wabur inin angal di nao panga sin, inim and ngo di su and lobokl lobokl ngo tuwaklbir inin aongao bor mbinin su ngon pange su huni haklao baeben di ngol tandoklo tuwaklbir paokl puklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Njisesom ngub kobur kakl, Nim ini bor heneng ora kao njurukl, Ngaorom tenaol hambun taol buklao bao o pindib paklao tomb, su and lobokl lobokl ngo bor ke aondao ora hondoklemi om, mbes su Sorom hesa Komora kab bor ke aondao ora hindismi ub men mbae ora soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Njisesom ngub kobur kakl, Pangeklem. Nim ini some sib non bi buklhoma aondao deran ker sem hae bor ora puklub kakl ngao, suklumbom mondom ni nao lin ko nim asub ora bun ko oborob ora kone kimb bimi nda ub, inim di oborob ora kone kimb bibaebe. Ngub bubur lemin sao ebeyabuklom sao sango bor saond nao bu kale sub oborob ora boroklme nda ub, inim di tenaol mende bor saond nao bu kal kal bi sub haklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Wakl kakl, Aol mendbor ini men pae po mbinin kansol baebenon el sol mao habur howes kokl buklemi baeben, inim oborob ora hondo haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Njisesom ngub kobur kakl, Mbinim ni men mbaklwao ko nen sabobur lemin, mbinim ini kabmanon maomb bo haroklme aol aondao baeben hesa aol wesmbao baeben kabon el sol mao haklemi kisesa. Ngub buklemi tomb inim mbini bor di Tenaol Sem Tangar bor di inim buklemi sao hobao sao was kao kalobur, Angal Bib Hobao Sao o was kao kaloklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ngub kobur kakl, Mbinim ini men pae po howes lemi tomb inim pakl homo nen nen sabobur naom angal asao was lomao? mbinim nao bor howes ngo lemi on ko san di asub was luklmaob ko nen nao saboklwaebe ora. Ngub inj, bombor ngo ora tomb Ngaorom angal ngon ngub laob ko kao njuklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Wakl kakl, Angal ngo inim inin mbib was nao lemi ora. Ngub inj, inin Ab Aondaon Wesaom inim angal oborob ora lemin lao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ngub kobur kakl, Mabor aol mendborom mbinin haeme o howes kobur karu luklemil, mbinim pe paen luklemi. Ngo tomb bombor ngub was aol baebenom di mbinin nongnas sisao ngub bi bi buklemi. Ngub buklemi tomb nongnas baebenom di mbinin ingi aorao baeben bor saond bi sao ha ha bubur lemin, mbinin ingi aorao ngo baeben karubur pe paen luklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Njisesom wakl kakl, Inim nil hul ha haklemil, tenaol su hambun bor paoleme baeben hambunom ini hendaebe bakl aondao ora homobur nar wen ebe hende non buklemi kisesa. Wakl kakl, Mbinim ngub buklemi o tenaol mendbor nil hul ha saor pe was bao harim sin, Ngaorom mbini bu muklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ngub kobur kakl, Inim su and lobokl lobokl mendel haklemi tomb mbinim ini bor hondo ko bowes baem sin, inim su and lobokl lobokl tangar mende bor paokl ora puklwaebe kisesa. Wakl kakl, Nim ini bor heneng ora kao njurukl, inim su Isreyel and lobokl lobokl hambun bor angal bib hobao sao ngo nao kao kal pae hareklemin was, Aolon Isi Ora oboklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","Njisesom wakl kakl, Tenaol sukul lome baebenom mbinin tisam buwaloklao ub bao wa mbinin tisa men mbabur tangar ub bukl bukwaklemi ora. Ngub inj, sukul tenaol baebenom mbinin tisa non bi harim sin ngon ebe. Mende di mbini kongon bimi aol baebenom di mbinin aol aondao o men mbakl buwaklemi o, mbinin aol aondao ubi harim sin ngo di ebe ora soklao kisesa. Ngub kobur kakl, Mbinim ngo bimi ub inim ngub nen saboklwaebe. Tenaolom and aorao bor nje Seran Belsebaol hael ko imbi karu waem sin, mbinim and aorao ngon isi wane baeben bor di imbi khorob aondao bu ora karu uklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Njisesom ngub kobur kakl, Inim ngub nen sabobur mbini pakl nao homoklwaebe ora. Hambun sao tenaolom kowes bubur buklemi sao baeben mabor tenaol hambunom hondoklemi ora. Hambun sao sub hala mba uklao sao baeben di, mabor perekle pa uklaol tenaol hambunom ora hondoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ngub kobur kakl, Angal nim ini bor somna sub kao njuruklu nda baeben di, inim tenaol hambunom pangen hora lowaebe. Nim angal sub kao towem kobur kakl ol inin hal bor sub pangoklme o di, tenaol hambunom pangen and hom kemol habur lowaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Wakl kakl, Aol mendbor tenaol sango pe paen lib se haklemi baebenom mabor tenaolon wesao pe paen nao lib se hakleming, inim mbini pakl nao homoklwaebe ora. Ngub inj, aol mend inin toklo hesa wesao kab kobaran is de bor pen kaeb se hayao o bombor o pakl homoklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Njisesom ngub kobur kakl, Sao kang is kab maomunu mone hundbi kang hond mondom sokl bib se hakl o, inin Abom sao kang ngubi on is bombor ora di sul nao tibaen ko panga sin nao tibaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Wakl kakl, Ngub biyao o obum inin wesmbao iri baeben di ndi men payaong, ");
INSERT INTO akh_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","sao nao hobao sao kang kang mone hundbim sokl bib se ngubi hakl ndi menekle om ini daol bibir ndi meneyaol, ini di is mend nao baondib munuklaong pakl nao homoklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Njisesom ngub kobur kakl, Aol mondom ni Karas sem hae ko tenaol hambunom pangen kao parob sin, nim aol ngo obu ni sem ora hae ko nao Ab yu heben hayaom pangen lowao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Wakl kakl, Ngub inj, aol mondom tenaol hambunon el sol ni nao hende non bu mesao njubur besao kon wa sin, nim aol ngo obu di nao Ab yu heben hayaon elol nao hende non bu mesao kaloklwao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Njisesom ngub kobur kakl, Inim nim tenaol hambun bor turi homo taeki koklbur ibise ko nen nao saboklwaebe ora. Ngub inj, nim tenaol hambun bor taeki kokl inj obowao o, nim kuwi kuwinj saoll hakl mini obowao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Wakl kakl, Nim tenaolon kone bor saond bi ha ha bin koklbur obowaol, nas baebenom di mbinin ab bor saond bi men koro haklemi. Nong baebenom di mbinin am bor saond bi men koro haklemi. Ten baebenom di mbinin aolin am bor saond bi men koro haklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ngub kobur kakl, And bomboron haklemi baebenom di saond bi ha ha buklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Wakl kakl, Tenaol mendborom mbinin ingi aoraol aondao bu turi homo kone ubur mbinim nil kang bu kone waem sin, mbinim ni hae ol obokl buwaklemi ora kisesa. Ngub kobur kakl, Tenaol mendborom mbinin nongnasol aondao bu turi homo kone ubur mbinim nil kang bu kone waem sin, mbinim ni hae ol obokl buwaklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Njisesom ngub kobur kakl, Tenaol mendbor mbini pe pae non bi ora ha, mbinin is pe kowal bi nao taokl ebebur ni taol mi ubuklmi baeben, mbinim ni hae ol obokl bukwaklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Wakl kakl, Aol mondom obu tenaol hambunom imbi ken haklwao ko nen soba sin, obun hambun sao baondib munuklaol obu imbi nao wi kang ora haklao. Ngub inj, aol mondom ni hem ko taol mi oboklaol obu imbi nao wi kang ora harob sin, obu haeben soklao obu heneng ora imbi wi aondao ora haklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ngo tomb Njisesom wakl kakl, Tenaol mendborom ini bor turi homobur oborob obaeming ubuklub ko bisur baem sin, mbinim ni bor ora turi homo oborob buklemi. Mbinim ni bor ora turi homo oborob baem sin, Ngaorom ni obon kisaol mbinim obu bor ora turi homo oborob buklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ngub kobur wakl kakl, Tenaol mondom man mini aol mend oboklao o hondobur turi homo, aol ngo obu man mini aol ora hael bisur buklwao ora ko pangobur obum oborob obaeng ib ka sin, obum man mini aolom sokl muklemi ubi was muklao kisesa. Mende di aol mondom aol kone ebe wi ora mend oboklao o hondobur turi homo, aol ngo obu aol kone ebe wi hael bisur buklwao ko nen sabobur oborob obaeng ib ka sin, obun sokl di aol ebe baeben muklemi ubi was muklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Wakl kakl, Aol mondom nao man pange baebenon tenaol ndi nao mini kang ora mend buruklaol hondobur, obun kone bor nim Njiseson man pange kang ngo bisur buklwao ko nen sabobur obum ib kong de heneng ora o nen humu kala sin di, nim ini bor heneng ora kao njurukl, aol ngo obun sokl es nao bi aondao ngol panaem ora uklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ngo tomb Njisesom obun man pange aol dutebom kongon bam akol buklemi on angal hambun sao ngub kao kal paesao tomb, obum su ngol haklbir su ngon and lobokl lobokl baeben bor hondabur kisaon, obum tenaol hambun bor Ngaoron angal bib hobao sao ngub wiyao ko kao kalo obum angal ngon te di tenaol hambunom pangen kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ngo tomb Njon Mbabtas Biyao Aol obu kalabus anda bor paolubur, Eben Ke Aolom tenaol hambun bor angal ebe ngo kao kalo kongon hambun sao ngo bu hasao ub pangisesa. Ngub pangobur kisaon Njon obun man pange aol mendbor Njises hasaol puklub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ngo tomb Njonon man pange aol nda baebenom Njises hasaol po obu ne mubur kakl, Naom aol mend oboklao ko hondo haroklmao nde, nje ngo obae o be? be? naom aol tangar mende wen oboklao ko bao hondo haklmaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Inim Njon obu hayaol pobur lemin, inim elom hendeklem sao baeben di pangeklem ub di Njon obum pangen kao kaloklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ngo tomb tenaol mendbor el kho baeben di wakl el tin ko, tenaol mendbor aongao kho baeben di wakl harer peben ko, tenaol maollum bi mendboron toklo bor der bisao hakl di wakl songol heneng eben ko, hal bowe baeben di wakl hal mao komba, tenaol pe pae baeben di wakl mao enjarob lowaebe. Aoh, mbini tenaol dimb menjao nao wi boroklme baebenom di Ngaoron Angal Bib Hobao Sao pangaem lowaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ngo tomb Njisesom wakl kakl, Tenaolom nil hul ha habur kone taol taol nao buklemi baeben, mbinim turi hom na was haklemi ka ko kao kaloklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ngo tomb Njonon man pange aol ngo baeben anda pismi tomb, Njisesom tenaol andub ora ngo dengeb dengeb kao mba hasmi baebenom pangen Njon Mbabtas Biyao Aolon arman kao kalobur kakl, Inim mbes su tenaol nao biri bor pismisa ndis tomb asao was hondokl pismi? Posabsum kaemb isao ukl mend kar paesao hondokl pismi be? Ngub inj orang, ");
INSERT INTO akh_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","inim asao ora hondokl pismi? Inim aol mondom obun lab lab ebe ora was bu hasaol hondokl pismi be? Ngub di inj ora. Aol lab lab ebe was bi ngubi di aol wesmbao aondao baebenon anda bor was haroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ngub biming inim asao was hondokl pismi? Inim man mini aol bombor mend hasaol hondokl pismi be? E ka. Nim ini bor heneng ora kao njurukl, Njon man mini aol ngo obum man mini aol mendbor hambun men mbayao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ngub kobur kakl, Ngaoron mbuk waebom Njonom ngub buklao ke wiyao. Pangeklem. Aol bombor ngo nim mabor nao angal mini Nje mbes pu lowao Obum nje poklesi hareron kare Mao dund sarukl burukl poklao ko Ngaoron mbuk waebom ke wisao ub Njisesom kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Njisesom ngub kobur kakl, Nim ini bor heneng ora kao njurukl, Njon Mbabtas Biyao Aol ngom, mbes tenaol sul ngo hayem baeben hambun men mbaesao ora kisesa. Wakl kakl, Ngub men mbaesao o yu heben bor maeb ha maomb bo haen haroklme haklon ndi nao mini kang bombor mondom, aol aondao Njon di ebe men mbaeb se hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ngub kobur kakl, Njon Mbabtas Biyao Aol hasndis tomb di ngubi tomb di heben bor maeb ha maomb bo hayao ub men mbakl ke ke was bimi ka. Ngub bubur lomen tenaol mendborom ni di heben ngo bor pon ko nen sabobur buri palo haong lukl engel beyem kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ngub kobur kakl, Aol Njon ngo pindib paesao tomb Ngaoron man mini aol baeben hesa Moseson man kabom wen buklao ko kismi ub ngo tomb il so pind bisaol, ");
INSERT INTO akh_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","inim mbinim heneng kismi ko nen sabeyem sin, aol Njon obu aol Ilanja ngo oboklao kismi o sise ko nen saboklwaebe ora ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ngub kobur kakl, Ini angal ngubin te oborob nen saboklme baebenom angal ngo inin hal ora bor pen oborob ora pangoklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ngo tomb Njisesom wakl kakl, Nim tenaol man nao pange ngubi tomb hayem baeben bor menger asao was muklwao? Mbini menger ngubi ora hayem ka. Nongnas kang kang mendborom homal ber mba habur, nongnas sango mbini bombor ubi baeben bor ubuklub kobur kakl, ");
INSERT INTO akh_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Naom non ini bor pollpib keyom o inim non we nao keyem. Naom non hond homo de keyom o inim non de di nao keyem lome ubi hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Njisesom ngub kobur kakl, Nim menger bombor ngo murukl ub mbinim Njon ibisao tomb obum ne di ib di nao nisaol hondobur ngub kismi. Aol ngo obun tombao bor san biri hae kismi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ngubi tomb Aolon Isi Ora obobur obum ne di ib waen di neyaol hendeme tomb mbinim obu bor kakl, Haondaoklaob. Aol ngo obum ne di andub ora was no, ib waen di andub ora nekle lome kisesa. Wakl kakl, Aol ngo obu aol mendbor mone takis moroklme aol baeben hesa tenaol khorob was bu haroklme kabon tenaol sango ora hae lome o, Ngaor obum menjao bukl buwao nao bo oborob was biyao ub heneng ora ngo il so pindib paklbur be ol, Ngaor obum oborob sao was bu haraoklao ko tenaol hambunom ebe hondoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ngo tomb Njisesom su and lobokl lobokl mendbor bor tenaolom ko mend nao hindismi sao andub ora bu hasao o mbinim ora kone nao baol minismil, Njisesom mbini bor taolu lubur kakl, ");
INSERT INTO akh_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ini su Korasin tenaol o hakl o, ini ke aondao ora hondoklbur hayem. Ini Bersara tenaol baeben o, ini di ke aondao ora hondoklbur hayem alem. Nim inin su bor tenaolom ko mend nao hindismi sao di burir biklme sao di ngo bu haruklu nda ub su Taya hesa Siron kab bor bukl pokl buwaon, su Taya tenaol hesa Siron tenaol baeben kabom mbinim penar bu ora dimb men aolu lab lab kho samo, mbinim timbaol tel burubur kone baol munukl bismi o, inin kone nao baol meneyem kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ngub kobur kakl, Pangeklem. Mabor Ngaorom tenaol hambun taol buklao bao on ini ke aondao ora hondoklemim, si Taya hesa Siron kab bor ke hondoklemi ub di men mbaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Wakl kakl, Ini su Kabenam tenaol baeben o, inim naon mbib yu heben bor bao poklmao ko nen sabeyem be? Pangeklem. Ini sakl polaokl polaokl is de ke hondokl puklmi on ora poklemi kisesa. Wakl kakl, Nim inin su bor tenaolom ko mend nao hindismi sao di burir biklme sao di bu haruklu nda ub su Sorom tenaolom henden bukl buwaon, mbinin kone baol munbur su ngo bor ke aondao ora hindismi ub nao hondokl bismil, ngubi tomb di su ngo ebe was bao ukl beyao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ngub kobur kakl, Pangeklem. Ngaorom tenaol hambun taol buklao bao on ini ngo baeben ke aondao ora hondoklemim, su Sorom ngo bor ke hindismi ub di men mbaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ngo tomb Njisesom wakl kakl, Ab Aondao o nje yu heben hesa su ngo kabon Aorao Aondao ora habur, njem hambun sao ngo bu harili ub kone kikil bi sukul ko hambun sao pange baebenom henden muwalo pangokl di nao pangen kebur, sukul nao ke baebenom was henden muwalalel ");
INSERT INTO akh_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","nim njen kone wirili ub ngo bel o kobur, Ab o nje bor tengiyu aondao ora ko hae kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ngo tomb wakl kakl, Nao Abom nim hambun sao bu han kisaol, tenaol hambunom Aoraon Isi nao hendeyem o Aoraom was obun Isi hendeyao. Mende di tenaol hambunom Isin Aorao nao hendeyem o Isi obum was obun aorao hondobur, Isim tenaol mendbor obun Aorao henden muwalaoklao baebenom was hendeme kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ngo tomb Njisesom kakl, Ini tenaol mendbor kone bor kho sen burubur kend aondao ora bin haklemi baeben, nim inin kone bor sisab mao ban ub inim ni hae ol ubuklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Wakl kakl, Nim ebekone nao pe tenaol mende bor sub was haruklu ndang, nim sisab bi sao turuklu nda ub ini buwalon ko ni hesa haru tu hab kam obae sin, njen kone bor kend nao bin sisab mao baklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Wakl kakl, Nim turuklu ub inim tereklemin njurukl sao, inim sisab bi ngo tuklemi sao kend nao bi ebe ora soklao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ngo tomb mabor Njises obu Nju semon hor boroklme bao* on wir il em hinin pibisaol, Njises obun man pange baeben dem aondao ora himismisa. Dem ngub homobur kismin mbinim wir il ngon mendbor talobur nismisa. ");
INSERT INTO akh_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ngub bismil Peresi aol mendborom Njises bor kakl, Hend. Njen man pange aol baebenom ngo beyem ub naon manom hor boroklme bao on ngub nao bibaebe ke wiyao ub hul habur, asub ko beyem balem? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ngub kismil Njisesom mbini bor kakl, Inim mbes aol wesmbao aondao Debirom bisao sao arman mbuk waeb bor wiyao ub nao hendeme be? kisesa. Ngub kobur kakl, Nim ngo kakl o, mbes Debir obu di obu haru hasmi baeben di mbini hambun dem khorob ora himismi tomb ");
INSERT INTO akh_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Debir di obu haru hasmi baeben di mbini hambun Ngaor bor kaoya lome anda bor hondabur, and ngon palawe Ngaor bor kalismi o wisaol, tenaol hambunom nao noklwaebe ora baolum aol baebenom was noklemi ke wisao o, mbinim bao bibir bu mu nisming, inim arman ngo mbuk waeb bor wiyao ub nao hendeme be? ");
INSERT INTO akh_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Wakl kakl, Mende di Mosesom mbuk waeb bu wisao ub nao hendeme be? kisesa. Ngub kobur kakl, Hor boroklme bao on baolum aol baebenom Ngaor Hen Moroklme Anda bor kongon bimi ub, mbinim man ngo men mbabur hor boroklme bao on ngub bao kongon bimi o mbinim khorob sao kang menjao nao bimi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ngub kobur kakl, Nim ini kao njun ub pangoklwaebe. Ngaor Hen Moroklme Anda hobao sao inj, enjo ngo ini hayem ol hombor sao mondom Ngaor Hen Moroklme Anda men mbayao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Wakl kakl, Ngaoron mbuk waeb bor ngub di ke wiyao. Nim mabaorao haroklme ub was turi nao homaklo o Tenaolom tenaol mende bor sub Kone u hond homoklme ub turi homaklo ke wiyao ub nen sabokl bemen, inim tenaol mendborom khorob nao binbur te nao mao sarakl beme kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ngub kobur kakl, Aolon Isi Ora obu inin hor boroklme bao on Aorao Aondao ora yao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ngo tomb Njises obu ngol haklbir kisaon Nju semon man pangoklme anda on pisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ngub pisaol aol ki kho tibae mend birisaol hindisesa. Ngo tomb Njisesom mbinin hor boroklme bao* on aol ngo ebe mao sarob sin howes koklbur kismin, mbinim Njises bor ne mubur kakl, Naom hor boroklme bao on tenaol sen ha uklemi o ebe mao saklmao be? inj, naon manom asub was ke wiyao? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ngub kismil Njisesom mbini bor kakl, Ini aol ngo haklon mondom obun some sib mend kalo hayao o hor boroklme bao on sowaol tomb pae bor hondayao tomb, aol ngom wakl men maoraoklao be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ngub kobur kakl, Tenaol hobao sao ora saoklaol, some sib nao hobao sao ngo sao hakl di men mbae ora hayem ol, hor boroklme bao on di naom tenaol mende bor kone ebe ubur bisur bam sin, naon manom ke wiyao ub ora buklmao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ngub kobur aol ki kho nda bor kakl, Njen ki abo dundukl pe kisesa. Ngub kisaol aol ndam obun ki nda dundukl pesao tomb ebe bao sisaol, obun ki mende ebe ha birisao ubi was sisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ngo tomb Peresi aol birismi nda baeben tekakl po kiril mbabur mbinim Njises pe paen lem ko kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ngo tomb Njisesom angal ngo kismi o pangobur kisaon obu paokl ora pisesa. Ngub pisao o tenaol andub ora obun mama taol mi ibismil, obum mbini tenaol mendbor sen ha wismi baeben ebe mao saesesa. ");
INSERT INTO akh_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Njisesom ngub bu habur kisaon obum ngo bu hasao sao tenaol hambunom pangen kam aeben aeben nao bin ko, obum mbini bor nim ngub bu hae ko nao lowaebe ora kobur angal buriyab ora kao kalo hasesa. ");
INSERT INTO akh_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ngo tomb mbes man mini aol Asaya bor Ngaorom ngub waeb bu wi ko kao kalisaol, Asayam mbuk waeb bu wisao ub heneng ora ngo tomb il so pind bisesa. Obum kakl, ");
INSERT INTO akh_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Aol ngo obu nim ora haen kowaol Obu nao kongon biyao aol ora hae Nim obul kone u turi aondao ora homaklol Nao kone bor obu turi aondao ora bin hae. Nim nao Wesaom obun kone bor honda haen lowaol Nim kone ebe u habur tenaol hambun bor Bombor ub was taol bu kalo maeb haklwao ub Obum Tenaol Sem Tangar baeben pangen kao kaloklao. ");
INSERT INTO akh_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ngub kao kaloklao o Obum ko homo angal aondao bu di nao lao. Obum harer to and te hakl bor di tenaol kor bu Akol bu angal aondao bu di menjao laol Mbinim nao hondoklemi ora. ");
INSERT INTO akh_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tenaol mendborom buri nao pale demi ora haklemil Kaemb isao kang sao teklelo Bowes bib se haklemi o Ora teklelo bowes nao buklao. Mende di mendborom laomb mend sung kang bu ora Hundi mbaeb se daoklao nda ubi haklemi o Obum nao hundi mbaen lao. Tenaol mendborom sub boroklme baeben Ke mao handa lu bowes bu haroklme ub Mbinin kone ngubi men mbaklbur Obum tenaol hambun bor Kone bombor ub was u maeb habur laon Obum kone ngubi ora Men mbaklao ub oran tu suwaklao. ");
INSERT INTO akh_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mbini Tenaol Sem Tangar baebenom di Obul hul ha habur Hambun sao obum ebe mao saen ko Bao hondo haklemi ora Ngaorom man mini aol Asaya bor Njisesom ngub buklao ko waeb bu wi kisao ub ngo tomb heneng ora il so pind bisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ngo tomb aol mend obun tombao bor sam birisaol mbinim Njises hasaol mini ibismisa. Ngub mini ibismi o aol ngon el di kho sisaol, obu angal di nao ke pondo dengi mini sisesa. Ngubi sisao o wakl Njisesom ebe mao saesaol, aol angal nao ke ngo wakl angal di ebe sisaol osisao hakl ebe hindisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ngo tomb tenaol aondao ngo hasmi baebenom burir aondao ora biyubur mbini hakl hakl kakl, Wao. Aol ngo obu aol wesmbao aondao Debiron sem aol buri ora mend wen pindi paklao ko nen saboklmao nda, aol ngo obu ye be? nao hende ko nen sab sab bismisa. ");
INSERT INTO akh_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ngo tomb Peresi aol baebenon ngo bisao sao hondobur kismin mbini hakl hakl kakl, Aol ngo obum bombor sao mondom ora tenaolon tombao bor sam bereyao o taol dera hae ka. Obum Seran semon wesmbao aondao Belsebaolon buri oram tenaolon tombao bor sam bereyao o taol dera hae kismisa. ");
INSERT INTO akh_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ngo tomb ngo kismi ub Njisesom mbinin kone bor hondobur mbini bor kakl, Aol is bomborom maomb bo haraoklao semom tomb kab bu taol bu kobabur saond baem sin, mbinim maomb bo haroklme ub di kho soklao ora. Mende di su and te di and bomboron haroklme baebenom tomb kab bu taol bu kobabur saond baem sin, and ukl bombor kang baondib mini ora di nao haklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ngub kobur kakl, Seranom Seran sango taol derarob sin obum sem kab bu ngo taol bu kobae ong, mbinim wakl asub bubur oborob ora buri palo maomb bo haklemi? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Wakl kakl, Heneng ora inim ngo keyem ub ni Belsebaolom bisur bukl beyaol nim tenaolon tombao bor sam bereyao o taol derakl beyon, inin sem mendborom tenaolon tombao bor sam bereyao o taol dera ngo bu haroklme nda ub aem was bisur biyaob? kisesa. Ngub kobur kakl, Inin semom di ngub taol deraroklme ndal, inim angal ngo lem o kakla ora lem ko panaem ora hendeyom kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Njisesom wakl kakl, Ngub inj, Ngaoron Wesaom ora ni bisur biyaol nim tenaolon tombao bor sam bereyao o taol deraruklung, ngubi tomb Ngaorom ini maeb ha maomb bo haklao ub ini hayem ol teb so ebene ko pangoklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ngo tomb obum angal mar mend di kao kalobur kakl, Aol mend obu buri ora harob sin, asub bubur aol mondom aol buri ngo obun anda bor honda obun osisao uklao o maobala paes muklao? kisesa. Ngub kobur kakl, Aol ngo obu paes nokl buklaomon, aol and aorao buri ngo obu mbes yam ki aongao kab tanga pa u mbarob sin, obum aol buri ngon anda bor osisao uklao sao baeben di ebe muklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Wakl takl, Tenaol mendbor ni taol mi nao ubuklmi baeben nao saond bi ora hayem. Aol mendbor nao some sib ni hae ol nao obo maembelem lome baebenom, heneng ora nao some sib ngo baeben lu taolu tuwa peb bu hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ngub kobur kakl, Nim ngo kakl ub nen sabobur ini bor kao njurukl, Ngaor obum tenaolom khorob buklemi sao baeben di, tenaol mende bor maobowa peb bu hel hondo angal bu ngo hakl ub buklemi baeben non kunaklao o, mondom Ngaoron Wesao ora bor maobowa peb bu hel hondo angal ba sin ngon nao kunaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Wakl kakl, Mondom Aolon Isi Ora bor hel hondo maobowa angal ba sin, obun kone bor kho ngo wiyao ub di kunaeb se hayao o, mondom Wesao Ebe Tangar ora bor maobowa angal ba sin, obum khorob ngo lao sao ngubi tomb di ereb ora di nao kunaklaol wi aeben soklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ngo tomb Njisesom kakl, Is ebe sa sin il di ebe was saoklao. Is kho sa sin il di kho was saoklao. Ngub biyaol tenaolom is ngom il saoklao ub hondoklemi tomb, is ngo ebe be? kho eb ko ebe hondoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ngub kobur kakl, Ini suklumb sem o hakl o, inim khorob was bu hayem ngao inim angal ebe asub bubur lemi? Pangeklem. Tenaolon ne bor angal kao deraeme tomb mbinin kone bor wiyao ubi was kao deraroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Wakl kakl, Tenaol kone ebe wi baebenon kone bor hambun sao ebe sao was wiyaol, mbinim buklemi sao di oborob sao was buklemi. Bombor ngub was tenaol khorob bimi baebenon kone bor khorob bimi sao was wiyaol, mbinim buklemi sao di khorob sao was buklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Njisesom ngub kobur kakl, Nim ini bor heneng ora kao njurukl. Mabor Ngaorom tenaol hambun taol buklao bao on tenaolom kone kimb nao bibur angal me ko haroklme on te es bu ne muklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Wakl kakl, Njen angal kale om was mabor Ngaorom nje ebe hael lao. Njen angalom was Ngaorom njem khorob bisil nje kho hael laol ke hondoklesi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ngo tomb Nju semon man buwaloklme aol mendbor di Peresi aol mendbor di mbinim Njises bor kakl, Aol aondao o, njem tenaolom ko mend nao hindismi sao mend naom haondaomun ub bi hend dao kismisa. ");
INSERT INTO akh_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ngub kismi o obum mbinin angal ngon ko san lubur kakl, Ini sun tenaol ngo baebenon Ngaorol hul ha nao hae khorob was bu habur, inim ni bor tenaolom ko mend nao hindismi sao mend haondaomun bi lem o, nim ini bor tenaolom ko mend nao hindismi sao bombor ora di nao muwaloklwao ora. Pangeklem. Nim tenaolom ko mend nao hindismi sao, mbes man mini aol Njona bor bisao sao bombor o inim hendeklemin muwaloklwao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ngub kobur kakl, Mbes Njona obu ib wen aondao oran tombao bor bao hora hor teb somna hor teb bu birisao ub, bombor ngub was Aolon Isi Ora obu di bao hora hor teb somna hor teb bu, aol wesao haroklme bor bao haklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ngub kobur kakl, Mabor Ngaorom tenaol hambun taol buklao tomb su Niniba tenaol baebenom teka habur lemin, ini tenaol ngubi tomb ngo khorob was bu hayem baeben sakl mao pola, ini ngo was hayem ko bember ha peb puklemi ora. Pangeklem. Su Niniba tenaol ngo baebenom Njonam man kisao o pangobur oborob ora kone baol minismi o, aol ngubi tomb ngo hae om Njona men mbayao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ngub kobur kakl, Mabor Ngaorom tenaol hambun taol buklao tomb, mbes maomb bo haraoklao ten mend obun su enderae ana ora bor haklbir aol wesmbao Solomonom hambun sao oborob ora kone kikil bu ko hasao ub hondo pangokl ibisaomon teka habur laon, ini tenaol ngubi tomb ngo khorob was bu hayem baeben sakl mao pola, ini ngo was hayem ko bember ha peb buklao ora. Pangeklem. Ten ngom su enderae ora bor haklbir hobao sao ngo kisao ub hem ko pangokl ibisao o, Solomonom hambun sao oborob ora kone kikil bu ko hasao ub di aol ngubi tomb ngo hae om men mbayao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ngo tomb Njisesom kakl, Tenaolon tombao bor sam buruklao o taol deraklemi tomb obun su tenaol nao biri bor paokl pobur bao haklao o, obum mbes birisao ndabi mend es buwaklao tomb ");
INSERT INTO akh_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","obum ngub lao. Nim nao mbes and waru buruwao bor wakl poklwao saol lao. Ngub kobur laon obum tenaolon tombao mbes birisao nda bor hondokl poklaol, obu birisao nda bor mbinim menjao nao win oborob ora kunu bu ware haklemil hend u mbaklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ngub hend u mbaklbir laon obum aol ngo men mba khorob aondao bu ora mao baklbur, obum sam kho buri ora is haoklao mend kaomukl poklao kisesa. Ngub kaomukl pobur mbini hambun aol ngon tombao bor hondaklemil aol ngo obu mbes khorob ora hasao ub di men mbabur, ko mende ngo tomb ora khorob aondao bu ora bu haklao kisesa. Ngub kobur kakl, Ini tenaol khorob bu haroklme ngubi tomb hayem baeben o di ngub buklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ngo tomb Njises obum tenaol hambun bor angal ngub bao kao kalakl hasaol, Njises obun ingi di haeme wil baeben di Njises obu daol angal menjao kao kao bem koklbur dera nan obo hasmisa. ");
INSERT INTO akh_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ngub obo hasmil aol is mondom Njises bor kakl, Pangal. Njen am di njen haeme wil baeben di, mbinim nje bor angal menjao kao kao bem koklbur tubu dera nan bao hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ngub kisaol Njisesom aol ngo obun angal ngon ko san lubur kakl, Nao am aeb? Nao haeme aeb hakl hayem? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ngub kobur Njisesom obun man pange ngo hasmi nda baeben obun ki hondem bember ha aol nda bor hend ko muwalobur kakl, Nao ingi haeme wil ngo hayem o kisesa. ");
INSERT INTO akh_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Wakl kakl, Tenaol mendbor nao ab yu heben hayaomon turi homo bib ko nen sabeyao ub bu haroklme baeben, ninao ingi mbaoli haeme ora hayem ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ngo tomb bao bombor ngon Njisesom and ngo bor haklbir dera pobur kisaon, ib Kalili mare bor tenaolom Ngaoron angal pangen kao kalokbur birisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ngo tomb tenaol andub ora obu hasol teb so obo kiril mbaesmisa. Ngub obo kiril mbaesmil Njises obum ib taokaoll mend ngol wisao bor hondabur kang mend ib wil sao birisao tomb, tenaol ngo hasmi baeben mbini hambun ib ngon mare bor bao hasmisa. ");
INSERT INTO akh_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ngo tomb Njisesom tenaol ngo hasmi baeben bor angal mar andub ora kao kalobur kakl, Pangaoklaob. Aol mondom obun em bor em we tand kokl pisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ngub tand kokl pisao tomb em we ngon mendbor harer tol kolokl baraesaol, saom obobur arer bu nismisa. ");
INSERT INTO akh_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Em we ngon mendbor han kel kel su andub nao wibur unu ora bor di su oborob nao u taokl hondael tandokl baraesesaol, em we ngom penar bu ora por kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ngub por kisao o pi oborob nao pe ora sisaol, narom hindisao tomb kaeb so bung bisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ngo tomb em we ngon mendbor den nene haen te bor kolokl baraesaol, den nene hae ngo haom mu and sobur em we ngo men mbaesesaol il nao sisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ngo tomb em we ngon mendbor su ebe oral tand kisaol oborob ora and so il sobur kisaon, mendborom supu hakl hakl hor su pabklim lisesa.* Mendborom supu hakl hakl hor teb pabklim lisesa. Mendborom supu kab kab hor kab pabklim lisaong, ");
INSERT INTO akh_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ini angal ngubin te oborob nen saboklme baebenom angal ngo inin hal ora bor pen oborob ora pangoklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ngo tomb Njises obun man pange baebenom Njises obu hasaol obobur kakl, Njem asub ko tenaol hambun bor angal mar kaleb? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Ini ngo baeben bor yu heben bor maeb ha maomb bo hayao on te mupango wiyao ub Ngaorom inim hendeklemin ko ngo muwale o, tenaol ngo baeben hambunom nao hondoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ngub kobur kakl, Tenaol mondom menjao u harob sin, Ngaorom obu andub ora kond ba kaloklaol obun andub ora uklao. Ngub inj, mondom menjao nao wi harob sin, obum kang mend u buruklao o di Ngaorom wakl muklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ngub kobur kakl, Nim angal mar ngo ko haruklu on te, nim ngub nen sabobur ko haruklu. Mbinim elom hondoklemi o menjao hend heneng nao buklemi ora. Mbinim halom di pangoklemi o mbinim pang heneng bu nen sab heneng nao buklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ngub kobur kakl, Tenaol ngo baebenom ngub buklemi ko Ngaorom mbes man mini aol Asaya bor kao kisaol, Asayam mbuk waeb bu wisao ub heneng ora il so pind bisesa. Obum kakl, Inim pang ha was buruklemi o Ngon te nen nao saboklemi. Inim hend ha was buruklemi o ");
INSERT INTO akh_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Inim te nen sab heneng nao buklemi ora. Tenaol ngo baebenon kone bor Khorob bimi saom ora men mbayaol Mbinin halom angal ngo pangaebe makl homobur Mbinin el di hundbi mbaroklme. Mbinim ngub nao bukl bemen Mbinin el di wakl tu hal di komb pa Kone bor di oborob kimb bu Ni bor wakl nen sabo kone u bokeyokl bemel Nim mbini mao enjakl beyo ko mbes Ngaorom obun man mini aol Asaya bor kao kisaol, mbuk waeb bor wisao ub Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ngub kobur kakl, Ngub inj, ini ngo baebenom inin elom di hondobur inin kone bor di ngo sao ora hendeyem. Inin halom di ora pangeyem ngao, inim turi aondao ora homoklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Wakl kakl, Nim ini bor heneng ora kao njurukl, mbes Ngaoron man mini aol hasmi baebenom di, aol mendbor ora kone dund se wi Ngaoron man hem ko hasmi baebenom di, inim ngubi tomb ngo hendeyem ub haondaomun sa ko nen sabismi o nao hindismi ora. Inim ngubi tomb angal ngo pangeyem ub di naom pangaomun sa ko nen sabismi o, nao pangismi ora ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Njisesom ngub kobur kakl, Inim pangaemnda ub aolom em bor em we tand kokl pisao on te, ");
INSERT INTO akh_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","em we harerol kolokl baraesao o saom arer bu nismi ub menger, tenaol hambunom Ngaorom maeb ha maomb bo hayao ub pangoklemi o nen sab heneng nao buklemi tomb, tenaol khorob mao baraoklao ndam penar bu ora obobur laon Ngaorom tenaolon kone bor angal bib hobao sao ngo we boklao o, mbinin kone bor nao hondaen ko lao hokl pelen lao. ");
INSERT INTO akh_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Tenaol mendbor di em we ngo han kel kel su oborob nao wil tand kisao ndabi hayem. Mbinim wen tomb penar bu ora Ngaoron angal bib hem ko pangobur turi aondao ora homoklemi. ");
INSERT INTO akh_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ngub buklemi o mbinin kone ndaon ora bor nao hondaen haklemil, kang baoklmend oran Ngaoron angal bib ebe ngo hem ko nen sab hakol bu haklemi o, mabor aol mendborom Ngaoron angal ngo men mbakl obobur ke mao handa mbinin kone bor kend bi sao mend buklao tomb di, mbinim hul ha haklemi ub penar bu tuwabur mbinim hul ha, ha kimb nao buklemi ora. ");
INSERT INTO akh_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Em we mendbor den nene haen te bor kolokl baraesao nda ub menger, Ngaoron angal bib ngo pangoklemi o sul woroklme sao hambun sao tenaolon kone bor heb mao homa hem mao karaoklao sao baeben, mone momak ngo sao haklom Ngaoron angal ebe ngo nao hondaen ko tenaolon kone bor men mbaklaol, mbinin kone bor ne sao and nao sen haklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ngub kobur kakl, Em il mendbor su ebel por kisao ub menger, tenaol mendborom Ngaoron angal bib ngo pangoklemi tomb oborob ora nen sab hakol bu hem kobur, tenaol ngo baebenom em il sao sen habur mendborom supu hakl hakl hor su pabklim lin haklemi.* Mendborom supu hakl hakl hor teb pabklim lin haklemi. Mendborom supu kab kab hor kab pabklim lin haklemi ko Njisesom angal maron te ngub kao dund bisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ngo tomb Njisesom mbini bor angal mar mende di kao kalobur kakl, Heben bor maeb ha maomb bo haraoklaom ngub maomb bo hayao. Aol mondom obun em bor em we ebe ora tand kokl pisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ngub bisaol somna tenaol hambun u paol mba hasmi tomb aol em we ebe tand kokl pisao ndan saond bim sub obobur kisaon, em we ebe tand kaokl pisao nda darukl o bor den kho sem mendbor maomunu tand kao mbakl pisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ngo tomb mabor em we ebe ndam and so il soklbur bisao tomb, tenaol hambunom hindismil den kho baeben hesa maomunu and so hasmil hindismisa. ");
INSERT INTO akh_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ngo tomb em aorao ndan kongon bimi aol baebenom em aorao nda hasaol pobur kakl, Aol aondao o njem njen em bor we ebe ora tand kisi ko pangismaong, asub ko den kho ngo and seb? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ngub kismil em aorao ndam mbini bor kakl, Nao saond bi mondom bise kisao kisesa. Ngub kisaol obun kongon biyao aol nda baebenom kakl, Njem naom den kho ngo baeben kobo maemb kokl paomun ko nen sobal be? kismi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ngub kismi o em aorao ndam kakl, Inj ka. Inim den kho ngo baeben kobo maemb lemi tomb inim ne ebe bor bor maomunu koboklemi ko, inj ora kisao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Em aorao ndam wakl kakl, Inim il kho ngo nao kobo tuwae, ne ebe o hesa ngub haru and sao sao bubur naeb sen waklwaebe ora kisao kisesa. Wakl kakl, Mabor em il ngo talokl buklwao ora tomb nim aol em il ngo taloklemi baeben bor ngub lowao. Inim pibnao oran den kho ngo baeben haoruklemi o is kaebis mbes bu mbabur, den kho ngo baeben kobo maemb laob lowao. Ngub bubur lemin inim em il ebe baeben em il ebe talo woroklme anda bor talo wib lowao kisao ko Njisesom angal mar ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ngo tomb Njisesom mbini bor angal mar mend di kao kalobur kakl, Heben bor maeb ha maomb bo hayao ub is il menden imbi sowar il menger maeb ha maomb bo hayao kisesa. Ngub kobur kakl, Aol mondom sowar il ngo obun emol we boweyao tomb ");
INSERT INTO akh_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","em we boklme sao baeben hambun saom sowar il ngo men mbae ora soklao kisesa. Wakl kakl, Ngub biyao o mabor sowar il ngo por ko and seyao tomb aondao bu ora sem biyaol, em il tangar tangar sao baeben kang was saoklaol sowar il ngom em il hambun ora men mbae ora, is sao sem bu and so haraoklao ora. Ngub beyaol sao sem hambunom is ngon baoklaol and bu burukl engel bimi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ngo tomb Njisesom mbini bor angal mar mend di kao kalobur kakl, Yu heben maomb bo hayaomon palawe and mao saraoklao sao yis menger maeb ha maomb bo hayao ora. Ten mondom palawe ki teb mao ha mubur yis ngo hesa maomunu pinjaom bu hereyao tomb, yis ngom palawe nda aondao bu ora and mao saraoklao nda ub menger ora maomb bo hayao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ngo tomb Njisesom tenaol aondao ngo dengebe mba hasmi baeben bor angal ngo kao kalisao baeben mbini bor angal ukl mend kao pa nao kao kalisesa. Ngub inj, obum angal ngo kao kalisao baeben angal mar was kobur kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ngub bisao o mbes man mini aol is mend bor Ngaorom ngub kao ko kao kalisao ub ngo tomb heneng ora il so pind bisesa. Obum kakl, Nim mbini bor angal kao kaloklwao tomb Angal mar was lowao. Mbes angal mupango ora wisao o Mbinim pangen kao dund buklwao ko Ngaorom man mini aol is mend bor ngub kao kisaol, mbuk waeb bor wisao ub ngo tomb il so pind bisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ngo tomb Njises obu tenaol ngo birismi baeben ngol bao birin kaoklbir obu and andaon hondaesesa. Ngo tomb Njises obun man pange aol baeben obu birisaol obobur mbinim Njises bor kakl, Njem emol den kho mend dalisesa kaendan te naom pangaomun kao dund bi kismisa. ");
INSERT INTO akh_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Em bor we ebe tand kokl pisao ngo obu menger, Aolon Isi Ora obu yao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ngub kobur kakl, Em menger su hambun bor tenaol paoleyem baeben bor kanda. Em we ebe ora o menger, tenaol mendbor Ngaorom maeb ha maomb bo haen hayem baeben o yao kisesa. Ngub kobur kakl, Den kho menger, tenaol Seranon sem baeben o bor kanda kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Njisesom wakl kakl, Saond bi mondom em we ebe darukl o bor den kho tand kisao o obu Seran. Em il naeb soklaol taloklemi kandan te, su ngo baeben hambun bor mabor bao bu kowes buklao o bor kanda. Em il ebe ora ngo taloklemi baeben Ngaoron angal mini wesao yao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ngub kobur kakl, Mbinim den kho baeben maomunubur haoruklemi on te, mabor bao bu kowes buklao tomb mbinim su ngo baeben hambun bor buklemi o bor kanda kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ngo tomb wakl kakl, Aolon Isi Oram obun angal mini wesao baeben su Ngaorom maomb bo hayao ngo baeben hambun bor puklub kobur laon, tenaol mende saokl mao waroklme baeben hambun di, tenaol mendbor khorob was bu haroklme baeben di, ");
INSERT INTO akh_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","isaolao aondao dao hakol bi ora bor pen lemi kisesa. Ngub pen lemil mbinim is de ngo bor habur saongao kengorokl no de aondao ora ko haklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ngo tomb tenaol Ngaoron sem oborob bimi baeben mbini nar el non bi bao bi hakol bi ora habur, mbinin Ab Aondaom maeb ha maomb bo hayao bor hakleming, ini angal ngubin te oborob nen saboklme baebenom angal ngo inin hal ora bor pen oborob ora pangoklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Njisesom ngub kobur kakl, Menger ngub mubur inim yu heben maomb bo haraoklaomon maeb ha maomb bo haen haklwaebe. Aol mondom tenaol tangaron su bor akol akol buklao tomb mbinim mbes mone ber pae bawis mend sowal tombo mupang mbaesmi mend, aol ngom hend waklao tomb obum turi aondao ora homobur hend subaklbir obun anda pobur laon, obun osisao uklao baeben tenaol mendborom dob bin mone mubur, obum su ngo mone sowal bu mbaesmi nda obun sen ko wakl su ngo dob bukl poklao ko Njisesom angal mar ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Njisesom ngub kobur kakl, Menger mende di ngub mubur, inim yu heben maomb bo haraoklaomon maeb ha maomb bo haen haklwaebe. Aol mondom obun bisnis buklao tomb obum momak ebe ora on was es bu dob bu u haklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ngub buklao o aol ngom aol mondom momak ebe ora, momak aeben baeben hambun ora men mbae ora mend uklaol hondobur laon, obun osisao baeben hambun sao tenaol mendborom dob bin mone mubur, obum mone ngo muklao baebenom wakl momak hul ebe ora nda dob buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Njisesom kakl, Mende di yu heben hayaomon maeb ha maomb bo hayao ub, tenaolom ib wen ongon bu moroklme sao bombor mend ib ndan bor pen kobur wen tangar tangar mundub mundub bi andub ora taol nda moroklme ub menger maomb bo hayao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ngub kobur kakl, Ib wen ongon bu moroklme sao ngo bor ib wenom tumbi hayao tomb ib mare nan men mu, mbinim sul ber pabur ib wen ebe baeben sablo maemb ko u mbasker nu bor marubur, kho baeben sablo tuwaroklme ub menger maomb bo hayao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Wakl kakl, Menger ngub mubur mabor bao bu kowes buklao tomb Ngaoron angal mini wesao baebenom su hambun bor buri kobur, tenaol kone ebe wi oborob bimi baeben darukl o bor tenaol khorob bu haroklme baeben haklemi o sablo mbakl mib bubur, ");
INSERT INTO akh_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","isaolao aondao dao hakol bi ora bor pen lemil, mbinim is de ngo bor habur saongao kengorokl no de aondao ora ko haklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ngo tomb Njisesom mbini bor ne mubur kakl, Angal ngo kanda baeben hambunon te ebe nen sabeyem be? kisaol, mbinim obu bor kakl, E ka. Nen sabeyom kismisa. ");
INSERT INTO akh_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ngo tomb Njisesom mbini bor kakl, Nju semon man buwaloklme aol mendborom yu heben maomb bo haraoklaomon maeb ha maomb bo hayao on angal oborob ora pangobur hem kaem sin, mbini and aorao non bi haklemi. And aorao ngo baebenom tenaol tiyao obo paoloklme baeben bor mbinin ne woroklme panda bor uklemi o, ne mbes pange hesa wen pange kab maomunubur ebe taol bu kaloklme ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ngo tomb Njisesom angal mar ngo baeben kao kal paesao tomb su ngol haklbir ");
INSERT INTO akh_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","obun su Nasarer bor pobur kisaon, mbinin man pangoklme anda on hondabur tenaol hambun bor Ngaoron angal bib kao kalisaol, tenaol ngo birismi baebenom burir biyu mbini hakl hakl kao kao bubur kakl, Aol ngo obum angal ngo ke ub di obum tenaolom ko mend nao hindismi sao di ngo bu hae sao hakl aebom kao kalaonao ub beb? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ngub kobur wakl kakl, Aol ngo obu kabnda biyao aolon isi inj ye be? Wao. Obun am di Mariya inj ye sa bo? Obun haeme baeben Njemus Njoseb kab di Simon Njuras kab di ngo baeben daol obun haeme sanda ka. ");
INSERT INTO akh_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Obun mbaoli baeben di enjo nao buru hayom ngao, obum ngo bu hae sao baeben aem kao kaleyao ub bu haeb? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Mbinim ngub kobur kismin Njises obu makl aondao ora homo mesao kalismi o, Njisesom mbini bor kakl, Man mini aol mondom Ngaoron angal bib ko tenaol hambunom pangen kam akol bu haklao tomb su hambun bor obun imbi wi ngaklao o, obun su and te ora bor hesa obun and ora bor kab obun imbi nao uklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ngo tomb mbinim Njisesol hul ha nao haesmil obum tenaolom ko mend nao hindismi sao mbinim andub ora henden nao muwalisao ora. ");
INSERT INTO akh_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","2","Ngo tomb ma ora bor aol wesmbao Heror ndam Njisesom hambun sao bu hasao sao arman pangisesa. Obum ngub pangobur obun kongon bimi aol baeben bor kakl, Nim Njon Mbabtas Biyao Aol pe paen lundis o obun maol bor wakl enjaokl pobur, obum hambun sao aondao bu buri palo ngo bu haril o kisesa. ");
INSERT INTO akh_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Ngo tomb aol Heror obu su ngon aol wesmbao ora habur kisaon, obun haeme Pilibon were o heb homobur obu akl ba hasaol, Njon Mbabtas Biyao Aolom Heror bor kakl, Njem njen haemen were ngo akl ba haril ub ebe inj, njem khorob aondao ora baenda ko kao kal was bisesa. Ngub kisaol ten Heroriyas ke ngom Njon ko aondao ora himisaol, ten Heroriyas ngon aoli aol wesmbao Herorom Njon Mbabtas Biyao Aol nda obun werem turi hemen ko, obu men habur kalabus anda bor hend ha ndi mbaesesa. Ngo tomb aol wesmbao Herorom Njon Mbabtas Biyao Aol nda pe paen lun ko nen sabisao o, tenaol hambunom Njon obu Ngaoron man mini aol ora hae ko ora hindismil, obum tenaol hambun pakl homobur nao lisesa. ");
INSERT INTO akh_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ngo tomb ko mend oran maomb bo haraoklao aol ngo obun amom obu marisao bao o pindib paesaol, tenaol mendbor andub ora ne nokl ubuklub kobur ne haorisesa. Ngo tomb ten Heroriyas ngon wane mend obobur kisaon, mbini ngo ne nao mba hasmi ndal san ponam ibisaol hondobur, aol wesmbao Herorom nong nda turi aondao ora homo heb himisesa. ");
INSERT INTO akh_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ngo tomb aol wesmbao Heror ndam ngub heb homobur nong nda bor mao kobur kakl, Heneng ora njem ni bor turi homo ngo sao ora nji ko kao njuklesi sao njuklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ngo tomb nong ndam aol wesmbao Herorom ngub ka ko obun am Heroriyas kao kalisao tomb, ten ngom obun wane bor kakl, Njem Njon Mbabtas Biyao Aolon wesmbao kaol pae peler barnao oral ubur nji kaebe ko karu mao kikil baesaol, nong ndam aol wesmbao Heror bor kakl, Njem ni Njon Mbabtas Biyao Aolon wesmbao kaol pae oran peler barnao oral ubur, pen ngo oral nji kisesa. ");
INSERT INTO akh_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ngo tomb ngub kisaol aol wesmbao Heror ndam obun kone bor kho so hem aondao ora kisao o, obum aol aondao ngo ne no birismi nda baebenom di pangen obum mao kobur njem nji lesi sao bao njuklwao ora kao minisao nda nen sabobur kakl, Njem ngo kal ub nim Njonon wesmbao njuklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ngo tomb aol wesmbao Herorom aol mendbor Njonon ma peyu tukl puklub kisaol, ");
INSERT INTO akh_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","mbinim Njon Mbabtas Biyao Aolon ma peyu peler barnao oral ubur nong nda kalismil, nong ngom Njonon ma kaol pae nda obun am Heroriyas mini po kalisesa. ");
INSERT INTO akh_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ngo tomb Njon Mbabtas Biyao Aol ngo obun man pange aol baebenom Njonon toklo tukl pobur kismin maol bismisa. Ngub maol bu mbaklbir kismin, Njon Mbabtas Biyao Aol pe paen lismil maol bumao ko Njises kao kalokl pismisa. ");
INSERT INTO akh_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ngo tomb Njisesom Njon Mbabtas Biyao Aol ngub pe paen laem ke pangaoklbir kisaon, su ngo obu hasaol haklbir ib taokaollon su tenaol nao biri ora mend sisao bor obu hungum ora pisesa. Ngub pisao o tenaol hambunom Njises obu ngub pa ke pangobur kismin, mbinin su and te ngo baeben bor tuwaklbir Njises pisao nda bor su kab kab obun mama taol mi pismisa. ");
INSERT INTO akh_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ngo tomb mabor Njisesom ib marel po pindib pabur hindisaol, tenaol andub ora obo kiril mbaesmil hindisesa. Ngub hondobur obum mbini hond homo hem aondao ora kobur kisaon, obum mbini Ngaoron angal bib kao kalo tenaol mendbor sen ha wismi baeben di mao enja peb bisesa. ");
INSERT INTO akh_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ngo tomb mbon sisaol Njiseson man pange aol baebenom Njises birisaol obobur kakl, Nao su ngo bor tenaol nao biri bor hayom ngao, tenaol ngo baeben dem homoklemi mbon seng, mbinim su tenaol biri bor pobur ne hakl dob bukl buri ken kao kismisa. ");
INSERT INTO akh_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ngub kismi o Njisesom mbini bor kakl, Mbini asub ko ora poklemi? Inim mbini ne taol bu kalaoklaob ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ngub kisaol mbinim Njises obu bor kakl, Naon ne andub nao wi, naon palawe pao su mend ib wen is kab bu ngo ora wiyom kismisa. ");
INSERT INTO akh_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ngub kismil Njisesom mbini bor kakl, Inim kang ngo wimi o enjo ngo ni bere ol mini ubuklub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ngo tomb mbinim ngub mini obo kalismi tomb Njisesom tenaol ngo hasmi baeben hambun den so mend sisaol was baoraoklaob kobur, obum palawe pao su nda hesa ib wen is kab nda kab mu munu, obum yu heben bor hend ya Ngaor bor tengiyu kao peyobur obum palawe nda munu konde barabur kisaon, obum obun man pange aol nda baeben bor tenaol hambun taol bu kalaoklaob ko kalisaol mbinim tenaol hambun taol bu kalismisa. ");
INSERT INTO akh_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ngub taol bu kalismi tomb tenaol hambunom ebe no tombao hasmisa. Ngub no tombao hasmil nokl nao bisaol bao win waesmi baeben, mbasker nu tokl duteb oran tumbi haen was mar pa wismisa. ");
INSERT INTO akh_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ngo tomb aol ngo ne no birismi baeben ndi minismi tomb mbinin ten nongnas baeben nao ke aol baeben was ndi munubur, buklhoma iri non bi andub ora 5,000 oran sisesa. ");
INSERT INTO akh_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ngo tomb Njisesom obun man pange aol nda baeben bor ini mbes ib taokaollon honda baoraoklbir ib mal aondao ngon mende nan puklub kobur, mbini pismi tomb obu bombor ora bao habur kisaon, tenaol aondao ngo ne taol bu kalismi nda baeben di obum inin anda puklub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ngo tomb obum tenaol aondao ngo hasmi nda baeben ngub anda pen kaoklbir kisaon, obu hungum ora yu manda mend sisao bor yin pobur Ngaor bor kao kalokl pisesa. Ngo tomb nar anda bombisaol em hundur u mbaesao tomb obu hungum ora yu manda ngo bor bao hasesa. ");
INSERT INTO akh_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ngo tomb ib taokaoll Njises obun man pange aol baeben puklub kisao nda, ib mal aondao ngon tukun ora bor pismi tomb posabsu aondao ora mbini pokl bismi nan hakl obobur kisaon, ib aondao bu ora lu taongul taongul kobur ib taokaoll nda baol munukl ke ke bisesa. ");
INSERT INTO akh_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ngub bisao tomb wen bao buklbur hoklob kebeyam ibisao o bao ora nao bu hebe kobae em hundur bao u mba haenbur sisaol, Njises obu obun man pange aol nda baeben pukl hasmi ndal ib hu kem kem aongao hakl hakl ibisesa. ");
INSERT INTO akh_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ngo tomb Njiseson man pange aol nda baebenom obu ib hu kem kem aongao hakl hakl ibisao nda hondobur, mbinim burisao po pakl aondao ora homobur kakl, Domo aol wesao mend ebe kismisa. Ngub kobur kismin mbinim pakl homo karaeklae aondao bu ora kismisa. ");
INSERT INTO akh_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ngo tomb Njisesom mbini bor penar bu ora angal kao kalobur kakl, Ni Njises ora ebeng, inim pakl nao heme inin kone bor hul ha saor peyo ora baoraoklaob kisesa. ");
INSERT INTO akh_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ngub kisaol Pitam Njiseson angal ngon ko san lubur kakl, Aorao Aondao o heneng ora nje Njises sin, nim di ib hu kem kem aongao hakl hakl abo nje hael ol obon ub ni ib kao dao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ngo tomb Njisesom kakl, Nje ib kisaol, Pita obu ib taokaoll bor birisao nda ib mal ngo bor bonge peyaoklbir ib hu kem kem aongao hakl hakl pobur, Njises obu hasaol pisesa. ");
INSERT INTO akh_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ngub pisao o obum posabsu aondao ora ngo ibisao nda hondobur pakl himisaol, Pita nda ib ndaon bor men pae hondaklbur bisesa. Ngub bisaol Pitam kakl, Aorao Aondao o njem ni men mukl ib kisesa. ");
INSERT INTO akh_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ngub kisaol Njisesom penar bu ora Pita ib ndaon hondaklbur bisaol men misesa. Ngub men mubur Njisesom Pita bor kakl, Njem nil hul ha nao haebur, asub ko njen kone bor taol taol bu kone kab mareleb? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ngo tomb Njises hesa Pita kab ib taokaoll nda bor honda birisbi tomb posabsu aondao ngo ibisao nda kur kao paesesa. ");
INSERT INTO akh_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ngo tomb aol ngo ib taokaollon birismi nda baebenom Njises bor kaoya kobur kakl, Heneng ora nje Ngaoron Isi Ora e kismisa. ");
INSERT INTO akh_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ngo tomb mbinim taokaollon ngub baoraoklbir ib mal aondao ngon mare mende nan su Kenesarer wisaol, su ngo pindib paesmisa. ");
INSERT INTO akh_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ngo tomb su ngo bor tenaol birismi baebenom aol ngo obu Njises e ko ora hindismil, mbinim su Kenesarer ngon teb so baeben bor tenaol sen ha wismi baeben mini ubuklub ko kam aeben aeben bismil, su ngo bor tenaol sen kam mundub mundub ha homo wismi baeben hambun ora Njises obu hasaol was mini obo kiril mbaesmisa. ");
INSERT INTO akh_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ngo tomb mbinim ngub mini obo kiril mbabur kismin, mbinim Njises bor kao deb deb bubur kakl, Tenaol andub ora e ngao, tenaol sen ha berae ngo baeben mbini wakl enjaokl pen ub mbinim njen lab lab kungni bor warakl engel bin waebe kismil, tenaol sen ha barae ngo wismi nda baebenom Njiseson lab lab kungni bor warakl engel bismi tomb mbini hambun ebe bao was sisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ngo tomb Peresi sem mendbor di Nju semon man buwaloklme aol baeben di su Njurusalem haklbir Njises hasaol obobur, mbinim Njises bor ne mubur kakl, ");
INSERT INTO akh_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Mbes naon ab sumb wilom bismi ub inin ki wes wes mbes lu warer bubur ne noklwaebe ko kam aeben aeben bismi o, njen man pange aol ngo baebenom mbinin ki wes wes lu warer nao bi ne bao was nobur, asub ko naon ab sumb wilom kismi ub hul was habur men mbayem? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Inim di asub ko inin mbib nen saboklme ub was bu habur Ngaoron man men mba hul ha hayem? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Njisesom mbini bor ngub kobur kakl, Ngaorom ngub keyao. Njen am ab kab bor ebekone nao pe oborob ora hond homo bisur bibi. Mondom obun am ab kab bor khorob bu angal kho ka sin obu pe paen libaebe ke wiyao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Wakl kakl, Ngub wiyao o inim ngub lome. Aol mone di hambun sao maru u haeme baebenom kakl, Nao am ab kab o nim mone ngo di osisao ngo hakl ibi bisur bu njukl buwao o, nim mbes Ngaor bor kaloklwao ko kao beyawe sa lome kisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ngub kobur kakl, Inim ngo lome ub kobur inin am ab kab bor bisur bu oborob sao nao bi bao waklwaebe lome kisesa. Wakl kakl, Inim ngub bu hayem ol inin ab sumbom bismi ub was hem ko bam aeben bu habur, inim Ngaoron man bibaebe ke wiyao sao baeben nao hende non bu, hala bowes ora bu hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Njisesom ngub kobur kakl, Ini songolol aol hobao o hakl o, mbes Ngaoron man mini aol Asayam inim heneng ora ngub buklemi ko mbuk waeb ngub bu wisao. ");
INSERT INTO akh_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Tenaol ngo baebenom Mbinin ne komb pae bor ni bor kaoya lome o Mbinin kone bor Ngaor nao honda hae Enderael haenbur lome. ");
INSERT INTO akh_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mbinim aol henengon man ora ko habur o Naom Ngaoron man ko hayom lome. Mbinim ngub bimil Mbinim ni bor kaoya ko hor bere ko boroklme ub Baehaemen ora boroklme ko mbes man mini aol Asayam mbuk waeb bu wisao ub Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ngo tomb Njisesom tenaol hambun ni hae ol was ubuklub kobur obum mbini bor kakl, Nim ini bor angal ngo lowao o oborob ora pangobur nen sab hakol bibaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ngub kobur kakl, Hambun sao dera nan haklbir tenaolon ne bor hondaklao saom tenaol kho nao mao saklao. Ngub inj, hambun sao tenaolon kone ndaon bor baoraoklbir deran pubuklao saom ora tenaol kho mao saraoklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ngo tomb Njiseson man pange aol baebenom Njises obu hasaol obobur kakl, Peresi aol baebenom njem angal ngo kaenda pangobur mbinim nje makl aondao ora hemeyem ngao, njem ngo beyem ub hendel be? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Nao Ab yu heben hayao o obun em mend wiyao o bor osisao hambun sao obun mbib we nao bowe, baehaemen daklam poklao baeben obum te pilao bor bor kobo tuwaklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Wakl kakl, Ngub buklaong inim mbini ngub bao haen waklwaebe ora kisesa. Ngub kobur kakl, Mbini el kho habur mbinim tenaol el kho sango mende harer muwalo hayem o, tenaol el hukl bi ngubi baebenom el hukl bi sango harer muwala sin, mbibi kobaran el kho kab kab yaol ib kena bor kundukl halabur saokl uklebi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ngo tomb Pitam Njiseson angal ngon ko san lubur kakl, Njem angal mar ngo kalon te naom pangaomun kao dund bi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ngub kisaol Njisesom mbini bor kakl, Ini ngubi tomb di ora kon nao wi bombor ubi was hayem ol, inim di angal mar ngon te nen nao sabeyem be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ngub kobur wakl kakl, Inim ora nen nao sabeyem be? Ne hambun sao dera nan haklbir ne ndaon bor hondaraoklao sao baeben tombao bor hondaraoklaol, tombao ngo bor baoraoklbir i to anda bor hondaraoklao ko nen nao sabeyem be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Njisesom ngub kobur kakl, Ngub biyao o hambun sao tenaolon kone ndaon bor baoraoklbir ne bor dera pubuklao sao baebenom tenaol kho mao saraoklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ngub kobur kakl, Tenaolon kone bor ngo sao was baoraokl deran pubuklao. Tenaolom khorob was nen saboklme. Tenaol pe paen lu tuwaroklme. Tenaol dobaenom paes pu pu bimi. Tenaol hambunom di paes pu pu bu, khorob ngub was heb homo bam bam bimi. Paes noklme. Tenaol mende bor kakla kao beyaroklme. Tenaol mende dobaekeyo mangal bimi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Njisesom ngub kobur kakl, Ngo sao baebenom tenaol kho mao saraoklao kisesa. Ngub biyao o mbinim ini bor bibaebe lome ub, tenaolom mbinin ki wes wes nao libur ne bao noklemi tomb ngo saom tenaol kho nao mao saraoklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ngo tomb Njises obu su ngol haklbir kisaon, su Taya hesa Siron kab teb so bor pisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ngo tomb su Kenan ten is mend su Taya ngo bor obo birisao o obobur Njises bor kakl, Debir semon isi ka. Aorao Aondao o, nao wane oran obun tombao bor sam burubur khorob ora hul waru no haraoklaong, njem ni hond homo nao wane ngo bisur bi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ngub kisao o ten ndam angal ngo kisao on ukl mend ko san nao lisaol, Njiseson man pange aol baebenom Njises obu hasaol obobur kakl, Ten ngom nao kor bu mi obobur taol mi ebeng, ngub taol mi nao eben ub njem obu bor nje pu ora kaebe kismisa. ");
INSERT INTO akh_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Ngaorom ni pu kisaol Isreyel tenaol baebenon was some sib sao bum haklemi baeben bu muklbur obowao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ngo tomb ten ndam Njises hasaol obo tumu kar munu dombes ubur kakl, Aorao Aondao o, njem ni hond homo bisur bi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ngub kisaol Njisesom ten ndan angal ngon ko san lubur kakl, Naom nongnas kangon ne u buruklemi o mubur buklhoma* haklemi bor pen kam sin, ebe nao soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Njisesom ngub kisao o ten ndam wakl kakl, Aorao Aondao o njem heneng ora kal o, buklhoma baebenom mbinin aorao baebenom ne neme on ombo sul tibarayao baeben ebe bao mu noklme kisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ten ndam ngub kisaol Njisesom ten ngo obun angal ngon ko san lubur kakl, Ten o njem nil aondao bu ora kone ubur hul ha harilil, njem ngo hem ko bi ko nen sobal ub heneng buklao ora kisesa. Ngub kisaol bombor ngo ora tomb ten ngo obun wanen tombao bor sam birisao nda paokl ora pisaol ebe bao sisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ngo tomb Njises obu su ngol haklbir kisaon, ib Kalili mare mare was pisesa. Ngub pobur kisaon yu manda mend sisaol sul po birisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ngo tomb tenaol andub ora Njises obu birisaol tenaol sen hae mendbor aongao kho baeben di, el kho baeben di, tenaol mendbor hul singbi kobabur mesao akl bu barae baeben di, angal nao ke baeben di, tenaol sen kam mundub mundub hae mendbor andub di Njises hasaol was mini obobur kismin, Njiseson aongao ma teb so bor was taokl obo wismil, obum hambun ebe mao sa peb bisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ngo tomb tenaol hambunom hindismil Njisesom tenaol mendbor angal nao ke baeben wakl angal ken ko, tenaol mendbor hul singbi kobae baeben di wakl mao ebe sa, aongao kho baeben di wakl harer peben ko, el kho baeben di ebe mao sabur osisao hend heneng bin ko Njisesom ngub bisaol hondobur tenaol hambunom Isreyel tenaolon Ngaor bor was kaoya kismisa. ");
INSERT INTO akh_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ngo tomb Njisesom obun man pange aol baeben ubuklub kobur kakl, Tenaol aondao ngo baeben mbini nao haru bao hor teb oran enjo ngo bor was bao harumnda o, ngubi tomb ne nao wi pond bandal nim mbini hond aondao ora homakl ol, nim mbini dem aondao ora ngub homo taoklbir anda puklub ka sin ebe nj ka. Mbinim ngub baem sin, dem homo taoklbir anda poklemi tomb harerol dem lomaokl hab hab komb hakl po u kimb buklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ngub kisaol Njiseson man pange aol nda baebenom obu bor kakl, Nao su ngo tenaol nao biri bor hayom ngao, naom tenaol aondao andub ngo hayem baeben ubi ne taol bu kalaeb se al wiyao o taol bu kalemin? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ngub kismil Njisesom mbini bor kakl, Inim palawe asub baeben ora wiyem? kisaol, mbinim obu bor kakl, Palawe pao haoklao, ib wen kang is kab teb bu wiyom kismisa. ");
INSERT INTO akh_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ngo tomb Njisesom tenaol hambun bor sul baoraoklaob kisaol birismisa. ");
INSERT INTO akh_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ngo tomb Njisesom palawe pao haoklao nda di ib wen nda baeben di mu munubur kisaon, Ngaor bor tengiyu kao peyobur munu konde baraesesa. Ngub bubur obun man pange aol nda baeben bor tenaol hambun taol bu kalaoklaob kisaol, Njiseson man pange aol nda baebenom tenaol ngo birismi nda baeben taol bu kalismisa. ");
INSERT INTO akh_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ngub taol bu kalismil tenaol hambunom ebe no tombao hasmi tomb nokl nao bisaol bao win waesmi baeben, mbasker nu tokl haoklao oran tumbi haen was mar pa wismisa. ");
INSERT INTO akh_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ngo tomb aol ngo ne taol bu kalisao baebenon ten nongnas ndi nao mini, aol baeben was ware pe ora ndi munubur buklhoma iri non bi andub ora 4,000 oran sisesa. ");
INSERT INTO akh_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ngo tomb Njisesom tenaol ngo baeben mbinin anda sisao puklub kisaol pismi tomb, Njises obu ib taokaollon baoraoklbir su Makaran bor pisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ngo tomb Peresi sem hesa Sarusi sem kabon mendborom Njises hasaol obo, mbinim obu maobowaklmao ko nen sabobur maobowa hondobur kakl, Njem naom nao hendemao sao yu heben pange mend haondaomun bi hend dao kismisa. ");
INSERT INTO akh_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Inim mbon sam sam beyao tomb saohar bor ingi beyao o hondobur, mabor ban ebe ora buklao e lome kisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ngub kobur kakl, Inim hokloben tomb saoharol bomb do ingi beyao o hondobur kakl, Se oboklao e lome kisesa. Ngub kobur wakl kakl, Inim saoharol biyao sao menger oborob ora hondobur, se oboklao e ban buklao e ko oborob ora taol bimi o, Ngaorom ini bor wen buklao sao menger ngubi tomb ngo be o inim nao hendeyem ol, inin su ngo bor ngo be sao hondokl buwayem kisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Njisesom ngub kobur kakl, Ini tenaol sul bao haroklme baebenom Ngaorol hul ha nao hae khorob was bu habur, inim ni bor tenaolom ko mend nao hindismi sao mend naom haondaomun bi lem o, nim ini bor tenaolom ko mend nao hindismi sao bombor ora di nao muwaloklwao ora. Pangeklem. Nim tenaolom ko mend nao hindismi sao, mbes man mini aol Njona bor bisao sao bombor o inim hendeklemin muwaloklwao kisesa. Ngo tomb tenaol ngo baeben ngol bao haen tuwaklbir paokl ora pisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ngo tomb Njiseson man pange aol nda baeben hambun ib Kalili malon tukun oral kombe kobabur ib mare mende nan po pindi pa hasmi o, mbinin ne noklemi o palawe kang mend nao mari pe hemen haklbir pismisa. ");
INSERT INTO akh_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ngo tomb Njisesom obun man pange aol ngo baeben bor kakl, Inim Peresi sem hesa Sarusi sem kabon palawe and mao saraoklao sao yis menger wiyao ub inim hondo ora habur oborob ora hend ha was haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ngub kisaol Njiseson man pange aol nda baebenom mbini hakl hakl kakl, Naom palawe di ne menjao nao mari obamndal, obum nao bor ngub le nde kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Mbinim ngub kismil Njisesom mbinin kone bor hondobur kakl, Aol o hakl, asub ko ini hakl hakl naom palawe nao mari obomesa kao kao bim? Inim nil hul nao hae ora haroklme be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Njisesom ngub kobur kakl, Inim nao buri nao hendeme be? Mbes aol andub ora buklhoma iri non bi 5,000 oran, nim mbini palawe pao su mend taol bu kalowaol nisimndis nen nao sabeyem be? Mbinim ne ngo no tombao hasmi tomb ne ngon nokl nao bisaol bao win wasmi baeben, inim mbasker nu tokl aeker ora bao mar pa wisim bo? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Njisesom ngub kobur kakl, Nim palawe pao haoklao mend aol andub ora 4,000 oran taol bu kalondis tomb mbinim nokl nao bisaol bao win wasmi baeben, inim mbasker nu tokl aeker ora bao mar pa wismib? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ngub kobur kakl, Nim ini bor palawe heneng bor inj kandang, inim asub ko nen nao sabeyem? Nim ini bor Peresi sem hesa Sarusi sem kabon palawe and mao saraoklao sao yis menger oborob ora hondoklwaebe kobur kanda kisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ngo tomb Njisesom ngub kisaol obun man pange aol nda baebenom oborob ora nen sab heneng bismil, obum mbini bor palawe and mao saraoklao sao yis heneng bor inj, obum mbini bor Peresi sem hesa Sarusi sem kabon man buwaloklemi o oborob ora hondoklwaebe kobur kene ko nen sab heneng bismisa. ");
INSERT INTO akh_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ngo tomb Njises obu su Sisari Pilibi bor pobur kisaon, su ngo bor pindib pakl ke ke pismi tomb obum obun man pange aol nda baeben bor ne mubur kakl, Tenaol hambunom Aolon Isi Ora obu aeb hae lomeb? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ngub kisaol mbinim obu bor kakl, Mendborom obu Njon Mbabtas Biyao Aol hae lome. Mendborom obu Ilanja hae lome. Mendborom obu Njeremaya e be? Ngaoron man mini aol mbes hasmi haklon mend ye lome kismisa. ");
INSERT INTO akh_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ngub kismil Njisesom obun man pange aol ngo baeben bor kakl, Mbinim ngub ngo lome ong, inim ni aeb ora lemib? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ngub kisaol Simon Pitam obun angal ngon ko san lubur kakl, Nje Ngaorom Eben Ke Aol ora, nje Ngaor obu haeben saraoklaon Isi ora hael kisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ngub kisaol Njisesom Pitan angal ngon ko san lubur kakl, Njonan isi Simon Pita o, njem angal ngo kal o sun tenaol mondom nje bor ngub kao ko nao kao njaonao ora. Ngub inj, nao Ab yu heben hayaom ora njem angal ngo kao kaonao ub kao njaendang, njem ngubi tomb turi aondao ora hom kisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Wakl kakl, Pita o nim di nje bor heneng ora kao njurukl. Njen imbi ngo kakl on te nje han hubib non bi hael ol, nim han aondao ngon mandaemol ninao sem baeben mao haklwaol, tenaol mao homaraoklao sao baebenon burim nao sem ngo baeben men mbakl buwaklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ngub kobur Njisesom Pita bor wakl kakl, Nim yu heben bor maeb ha maomb bo hayao on tiriyao ki menger nje njuklwaol, njem su ngo bor nao hesbele bao tanga mba haen waklesi sao, Ngaorom yu heben bor di nao hesbele bao tanga mba haen waklao ora. Aoh, njem su ngo bor tuwa bao waklesi sao, Ngaorom yu heben bor di tuwa bao waklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ngo tomb Njisesom obun man pange aol ngo baeben bor, ni Ngaorom Eben Ke Aol hae ko tenaol hambunom pangen nao lowaebe ora kobur angal buriyab ora kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ngo tomb Njisesom obun man pange aol baebenom pangen, mabor obu Njurusalem poklaol Nju semon maomb bo haroklme aol, aol kon wi baeben di, mbinin baolum aol aondao baeben di, mbinin man buwaloklme aol baeben di, ngo baebenom obu tenda aondao ora mao nabur pe paen luklemi o, bao hor tebo nanon obu wakl enjaokl poklao on pibnao tibiyabur kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ngub kisaol Pitam Njises obu isu solo mend sisao nan kemi pobur, obum Njisesom ngo kisao ub makl homobur kakl, Aorao Aondao o inj ora, Ngaorom ngub bin bao wao nao buklaol, nje bor ngo buklao kaenda ngub nao buklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ngub kisaol Njisesom Pita baol munu hondobur kakl, Seran o njem ni saokl mao waklbur hael ngao, nim nje nao hondoklwaong nje pu ora. Njem ngo kal o Ngaorom nen sabeyao ub nen sabobur inj, njem aol henengom nen saboklme nda ub ora nen sabobur kal kisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ngo tomb Njisesom obun man pange aol nda baeben bor kakl, Tenaol mondom ni taol mi oba sin, obum ni imbi ken haklwao ko nen saboklao ub tuwaklbir obum obu pe pae non bi ora habur, obun is pe kowal bi taoklbir ni taol mi ebebe buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Njisesom ngub kobur kakl, Tenaol mondom ni imbi ken ora haklwao ko nen soba sin, obun hambun sao baondib munuklaol obu imbi nao wi kang ora soklao. Ngub inj, tenaol mondom ni hem ko taol mi oboklaol obu imbi nao wi kang ora harob sin, mabor obu imbi wi aondao ora habur haeben saklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ngub kobur kakl, Tenaol mondom obu imbi wi aondao ora habur sun osisao hambun sao maru u haklao tomb obu haeben sakl buwaeb se harob sin, obun osisao ngo maru u haklao sao baebenom asub bubur obu bisur bu haeben saen laob? kisesa. Ngub kobur kakl, Obu haeben nao saeb se ora ba sin, obum wakl asaom ora haeben saroklme sao sokl buklaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Njisesom ngub kobur kakl, Aolon Isi Ora obu obun Abom bao aondao ora bin laol angal mini wesao baeben daol haru oboklemi tomb, sun tenaol hambunom oborob di khorob di mbinim bu haklemi ub ngo ora tomb san luklaol muklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Njisesom ngub kobur kakl, Nim ini bor heneng ora kao njurukl, tenaol ngo hayem baebenon mendbor nao heme bao haen was, Aolon Isi Ora obu aol wesmbao aondao ora men aolaoklbir oboklaol hondoklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ngo tomb mabor bao hor dowa oran pibi hasao tomb Njisesom Pita di Njemus Njon kab haemeyakl di ngo baeben kemibir kisaon, har manda yu ora hond pele mend sisao bor pobur, yu manda ngo ora bor mbini was ware pe hasmisa. ");
INSERT INTO akh_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ngo tomb mbinin elom hindismi tomb Njiseson songol tangar ubi bao bi hakol bi ora sisaol hindismi tomb, Njiseson el wil di nar el non bi ora men aolubur kisaon, obun lab lab samo hasao baeben di nar el non bi haek bi ora men aolisaol hindismisa. ");
INSERT INTO akh_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ngo tomb mbinim oborob ora hend heneng bismil, man mini aol mbes hasbi o Moses hesa Ilanja kab obobur kisbin, Njises daol angal kao kao bi hasmil hindismisa. ");
INSERT INTO akh_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ngo tomb Pitam ngo bisao saon te nen sabokl buwabur Njises bor kakl, Aorao Aondao o naom ngo bor bao harum sin ebe ora soklaong, njem di ngub turi homal sin nim and kang ukl teb mend ngol bun wao. Ukl mend njen ukl mend Moseson ukl mend Ilanjan bu, ngub baeben oran bun wao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ngo tomb Pitam angal ngon ngub bao kakl hasaol, mulaol kombaebe pae bao bi ora mondom obobur mbini u tingi mbaesesa. Ngo tomb mulaol darukl ngo bor angal bombor mend obobur kakl, Aol ngo obu nao Isi ora hael, nim obul kone u turi aondao ora homaklong, inim obun angal was pangoklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ngub kisaol Njises obun man pange aol is teb ndam pangobur pakl aondao ora homobur kismin, mbinin el wil su bor haen dombes wismisa. ");
INSERT INTO akh_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ngo tomb Njisesom mbini dombes u mba hasmi ndal teb so obo habur mbini warabur kakl, Inim pakl nao heme tekaklaob kisesa. ");
INSERT INTO akh_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ngo tomb mbinim hend peb bismil, aol o hasbi nda kab di mendel ora nao hae Njises obu bombor o ora hasaol hindismisa. ");
INSERT INTO akh_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ngo tomb mbinim yu manda ngo bor haklbir wen harerol inin pukl hasmi tomb Njisesom mbini teb nda bor angal buriyab ora kao kalobur kakl, Inim ngo handaem ndisao oran mabor Aolon Isi Ora obun maol bor wakl enjaokl poklao ub nao bi bao haenbur oran, inim tenaol mondom pangen nao lowaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ngo tomb Njises obun man pange aol is teb ndam Njises bor ne mubur kakl, Njem nao bor nao lowaebe ngo kal o, Nju semon man buwaloklme aol baebenom asub ko Ilanja obu mbes oboklao o, Aolon Isi Ora obu mabor oboklao lomeb? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, E ka. Heneng ora Ilanja obum Aolon Isi Ora eben ko hambun sao mao dund sa peb bu, obu mbes oboklao ke wisao ub ");
INSERT INTO akh_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ilanja obu mbes ibisndis o, mbinim obu Ilanja e ko nen nao sabismi ora. Ngub inj, mbinim mbinin mbib nen sabismi ub was bubur kismin, mbinim Ilanja obu bor di khorob tangar tangar andub sao bismi kisesa. Wakl kakl, Mbinim bombor ngo bismi ub was, Aolon Isi Ora obu bor di tenda mao na khorob was buklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ngo tomb Njisesom ngub kisaol obun man pange aol nda baebenom oborob ora nen sab heneng bismi tomb, obum Njon Mbabtas Biyao Aol bor le ko ora hindismisa. ");
INSERT INTO akh_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ngo tomb mbinim tenaol andub ora ber mba hasmil pindib paesmi tomb aol is mend Njises obu ubukl hasao ndal hen mukl obobur kisaon, Njiseson aongao ma bor tumu kar munu dombes ubur ");
INSERT INTO akh_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","obum Njises bor kakl, Aorao Aondao o, nao isi oran obu kone nao hae non bi dur ko haraoklao ub bubur, obum hor hor was isaolao bor di ib bor di komb hakl po wi was biyaong, njem nao isi ngo hond homo bisur bi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ngub kobur kakl, Nao isi ngo ngub was biyaol, nim njen man pange aol baeben bor di nao isi ngo mao ebe saklaob kowao o, mbinim ebe mao sakl buwarim kisesa. ");
INSERT INTO akh_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ngo tomb Njisesom obun angal ngon ko san lubur mbini bor kakl, Ini tenaol ngo hayem baeben o inim Ngaorol hul nao hae haroklmel, inin kone bor di kho ora hayem kisesa. Ngub kobur kakl, Ini daol nao maomunu was haemao tomb inim nao hibi kho was mao sa hayem ngao, inim nao kone bor ngub kho mao sa hareklemin ko, ni ini daol hor asub baeben ora bao haklmao balem? kisesa. Ngub kobur kakl, Nas ngo enjo ngo ni hae ol mini ib kisesa. ");
INSERT INTO akh_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ngo tomb Njisesom nason tombao bor sam ngo birisao nda bor angal buriyab ora kobur nje pu ora kisaol, nason tombao bor sam ngo birisao ndam nas nda tuwaklbir paokl ora pisaol, bombor ngo tomb nas ndan sen ngo ha wisao o ebe bao sisesa. ");
INSERT INTO akh_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ngo tomb mabor Njises obu hungum ora birisaol, obun man pange aol nda baebenom obobur mbinim obu bor ne mubur kakl, Naom nas ndan tombao bor sam ngo birisao o asub ko ora taol derakl buwame sa bo? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ngub kismil Njisesom mbini bor kakl, Inim Ngaorol oborob ora hul nao hae haroklmel inim sam ngo taol derakl buwarmi ka. Nim ini bor heneng ora kao njurukl, inim Ngaorol hul ha haklemi ub sowar il kang ora moklo bor baoraoklao nda ubi menger hul ha harim sin, inim harbor ngo ase o bor nje ngol nao hae kobaol hakl pu kaem sin heneng kobaol hakl poklaol, inim tangar sao hambun sao di bukl buwa nao bi ebe buklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Njisesom ngub kobur kakl, Ngub inj, inim Ngaor bor nen sab ha was buru ne tuwa paolubur kao kal ha was nao harim sin, inim sam ngubi sem di taol derakl buwaklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ngo tomb mbini hambun su Kalili bor pismi tomb Njisesom obun man pange aol baeben bor kakl, Kang mend mabor aol mendborom Aolon Isi Ora obu karu lubur, obu lukl buklemi aol baeben bor men pae puklub ko kaloklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ngub kobur kakl, Mbinim ngub kaloklemil obu ora pe paen luklemi o, mabor bao hor tebo nanon obu wakl enjaokl poklao ora kisesa. Ngub kisaol obun man pange aol baebenon kone bor kend bu win was burubur hem aondao ora kao ha win birismisa. ");
INSERT INTO akh_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ngo tomb Njises di mbini hambun su Kabenam pismil, su ngo bor Nju semon Ngaor Hen Moroklme Andan mone takis moroklme aol baeben Pita hasaol obobur mbinim Pita bor kakl, Inin aol aondao ndam naon Ngaor Hen Moroklme Andan mone takis kalaoklao be? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ngub kismil Pitam kakl, E ka, kalaoklao kisesa. Pitam ngub kaoklbir Njises birisao bor hondaesaol, Njisesom Pita obu bor mbes kao kalo ne mubur kakl, Pita o njem asub nen sobal? Su hambun bor aol wesmbaon mone takis moroklme aol baebenom takis mone non bi ngub meme tomb mbinim aeben mone was moroklme? Mbinim mbinin semon mone di moroklme be? mbinim tenaol tangaron mone was moroklmeb? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Njisesom ngub kisaol Pitam kakl, Tenaol tangaron mone was moroklme kisesa. Ngo tomb Njisesom kakl, Heneng ora mbinim tenaol tangaron mone was moroklmel, mbinin semom mone takis nao kaloklme ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Njisesom ngub kobur kakl, Mbinim ngub bimil yao Ngaoon sem ora hayob ol, yaom Ngaor Hen Moroklme Andan takis nao kalaeb se hayob o, yaom ora nao kalab sin mbini makl aondao ora mao homaklbao kisesa. Ngub kobur Njisesom Pita bor wakl kakl, Njem ib mal bor pobor lesin njem ib wen hend haroklme sao wen huk ngo mini pobur, ib ndaon bor wen menin ub pen kaebe kisesa. Wakl kakl, Njem ya ngo wakl men muklesi tomb ib wen aondao ebe ora mend men muklesing, obun ne komb pae bor dangaebe munubur hondoklesi tomb mone mend buruklaol hondoklesing, njem mone ngo mubur yao kobaranon takis ebe ngaorukl peklaong, mbini Ngaor Hen Moroklme Andan takis moroklme aol baeben kalaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ngo tomb Njiseson man pange aol baebenom Njises hasaol obobur kakl, Heben bor maeb ha maomb bo hayao ub nao ngo hayom haklon imbi wi aondao oran aeb haeb? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ngub kismil Njisesom nongnas kang mend ib ko men mubur kisaon, obun man pange aol ngo baeben hasmil mao hasesa. ");
INSERT INTO akh_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ngub mao habur kakl, Nim ini bor heneng ora kao njurukl, inim inin kone wakl u bokeyobur nongnas kang ngubi men aolu nao harim sin, inim yu heben bor maeb ha maomb bo hayao bor pokl buwaklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Njisesom ngub kobur kakl, Mondom obun mbib nen sabaoklao ub tuwabur obum nongnas kang ngubi men aolu harob sin, yu heben maomb bo haraoklaomon maeb ha maomb bo hayao ub obu imbi wi ora habur, obu bomborom mbini mendbor men mbae ora hayao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Njisesom ngub kobur kakl, Tenaol mondom ni hem kobur nongnas kang ngubi mend hem ko kone u bisur ba sin, obum ni ora hem ko kone ubur buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ngo tomb Njisesom kakl, Mondom njen mal han aondao ora hond mend hend ha tu ndiyabur ib mal aondao oran ndaon bor haoklu tu kobarob sin, nje ib ndaon ngo bor bao pe paklesi ub nje ke kang bu sao hondoklesi. Ngub buklesi o njem nongnas kang bombor ora mend nil hul ha haenbur saokl mao wari sin nje ke aondao bu ora hondoklesing, njem mende saokl mao waklesi hondo ora haebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tenaol mendborom tenaol mende bor saokl mao warim sin, mbini ngo tenaol mende saokl mao waklemi baeben mabor ke aondao ora hondoklemi. Heneng ora tenaol mendborom tenaol mende saokl mao woroklme o, mbini ke aondao ora hondoklbur hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Njisesom ngub kobur kakl, Njen ki aongao kabom nje saokl mao waeb so ba sin, njen ki aongao ngo kabon mende kab kab peyu tuwaebe. Heneng ora njen ki aongao mende kab kab pe tuwa habur haeben saroklme bor pae sin, ebe ora haeben soklesi. Ngub inj, njem njen ki aongao kabon mende kab kab nao peyu tuwae bao habaklae hari sin, Ngaorom nje isaolao nao hundili dao hakol bi ora bor penin laol nje ke hondo haeben ora soklesi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Njisesom ngub kobur kakl, Njen elom nje saokl mao waeb so ba sin, njen el ngo toklo tuwaebe ora. Njen el mende toklo tuwabur bombor ora tu habur haeben saroklme bor pae sin, nje ebe ora haklesi. Ngub inj, njen el kab kobaran bao tu haklesil Ngaorom nje is de ora bor penin tu warob sin, nje ke hondo haeben ora soklesi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ngo tomb Njisesom mbini bor kakl, Inim Ngaoron sem tenaol kang mendbor haklemi o hondobur, tenaol kang ngo hakl non ndi nao mini nao hobao sao hayem ko nen saboklemi, oborob ora hondoklwaebe kisesa. Wakl kakl, Pangeklem. Heben bor angal mini wesao nao Ab hayaol haeme baebenom tenaol kang ngo baeben hor hambunon oborob ora maomb bo hend ha haroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ngub kobur kakl, Aolon Isi Ora obum tenaol mendbor bum haroklme baeben wakl bu muklbur ora ibisaol kakl kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Njisesom ngub kobur kakl, Inim asub ora nen sabeyem? Aol mondom obun some sib supu hakl hakl hor su oran kalo haklao o is bombor ora mend bum harob sin, obum es nao bi bao waklao be? Ngub inj, obum obun some sib supu hakl hakl hor makl hor su nanon supun teb mend di yu manda bor ngo ne no bao haklemi baeben bao haen kaoklbir laon, obun some sib bombor ngo bum haklao nda es bukl poklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Njisesom ngub kobur kakl, Nim ini bor heneng ora kao njurukl, obun some sib bombor ngo bum haklao o hend wa muklao tomb obun some sib mendbor andub ora ngo bao haklemi baeben turi homaoklao nda ub inj, obun bombor ngo bum haklao o wakl muklao tomb, nao some sib ngo ora bum hasndis o murukl kobur turi aondao ora homoklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Njisesom ngub kobur kakl, Menger bombor ngub mubur, inin Ab yu heben hayaomon tenaol kang ngubi baebenon is mend bum ha, ke nao henden ko nen sabeyao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ngo tomb Njisesom kakl, Njen haemem nje bor khorob ba sin, njem obu buruklaol pobur obu hesa ibi hungum ora buruklebi tomb njem obu bor ni bor khorob ngo sao was bising, njem ngo bili nda ub nao bibi ko kao kalaebe kisesa. Wakl kakl, Obum njem ngo lesi ub e ko panga sin, njem njen haeme ngom nje ko nao hemebur wakl njen haeme haen ko bu muklesi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Wakl kakl, Ngub inj, obum njen angal nao panga sin, njem tenaol kab teb di mend hondokl pobur ibim kao kao buklebi sao oborob ora pango, mbinim obu bor man ken ub nao haru mbi kaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Njisesom wakl kakl, Obum mbini ngo baebenom man lemi ub di ora nao panga sin, njem Ngaoron sem hambun bor kao kalebe kisesa. Wakl kakl, Ngaoron sem baeben hambunom lemi ub di ora nao pangokl bi ora sa sin, obu man hem nao ke obu aol tangar mone takis habara maoraoklao aol non bi hae ko pangaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Njisesom ngub kobur kakl, Nim ini bor heneng ora kao njurukl, inim su ngo bor nao hesbele bao tanga mba haen waklemi sao di, Ngaorom yu heben bor di nao hesbele bao tanga mba haen waklao ora. Aoh, inim su ngo bor tuwa bao waklemi sao Ngaorom yu heben bor di tuwa bao waklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ngub kobur kakl, Nim ini bor wakl heneng ora kao njurukl, ini su bor tenaol hayem haklon is kab mondom mbibin kone bombor ub ubur lebin, mbibim Ngaor bor ngo sao bibi ora ko kao kalaeb sin, nao Ab yu heben hayaom mbibim lebi sao buklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Njisesom ngub kobur kakl, Tenaol kang is kab teb ora mondom sa sin di mbinim ni bor hem ko kone kimb bubur mendel obo maembe baraem sin, mbini ngo buruklemi o bor ni di mbini haru obo buruklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Bombor ngo ora tomb Pitam Njises hasaol obobur kakl, Aorao Aondao o nao haemem ni bor khorob buklao tomb, nao haeme ngom ni bor khorob ngo buklao ub nim obu bor ko aeker ora saongao nao mari tuwaklwao? Ko haoklao oran ebe soklao be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ngub kisaol Njisesom Pita bor kakl, Ko haoklao inj ka. Njen haemem nje bor khorob ba sin, supu hakl hakl hor haoklao ko andub ngub baeben oran saongao nao mari tuwaklwao ko kao kal was bibi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ngub kobur kakl, Yu heben maomb bo haraoklaomon maeb ha maomb bo hayao ub, aol wesmbao aondao mondom obun kongon bimi aol baeben bor nao san haeme baeben lukl ubuklub lowao ko nen sabisao ubi menger, maeb ha maomb bo hayao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ngo tomb aol wesmbao aondao ndam obun mone san hasao on pibnao tibiya kao kao buklbur birisaol, obun kongon biyao aol is mend obun mone san buklhoma iri non bi andub ora hasao o mbinim obu birisaol kemi ibismisa. ");
INSERT INTO akh_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ngub kemi ibismi o obun kongon biyao aol ngom obun san ngo lib se mone mend nao wisaol, aol wesmbao aondao ndam makl aondao ora homobur kakl, Obun mone san hasao aol ngo di, aol ngo obu mone san hasaon ten nongnas baeben di, obun osisao wisao baeben hambun di, aol tangarom dob bin mone sokl mubur nao mone ngon san ebe muklwao kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ngub kisaol aol wesmbao aondao ngo obun kongon biyao aol ndam, obun aol wesmbao aondao ngo hasaol teb so obo sul tumu karu munu dombes u kao deb deb bubur kakl, Nim njen san ngo baeben hambun mabor ebe luklwaong, njem ni hond homobur el mend oram bao ha kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ngo tomb kongon biyao aol ngo obun aol wesmbao aondao ndam obun kongon biyao aol ngo hond aondao ora homobur kisaon, obum obun kongon biyao aol ngo bor di menjao nao ke bao wa, obun mone san aondao ngo hasao nda di nje ora mbibi kobur bao waesao ko Njisesom angal mar ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ngub kobur kakl, Kongon biyao aol ndam dera pobur hindisaol, aol is mend obu hesa mbibi haru kongon bombor o bu hasbi o obun mone aol ngo kalisao o, obun san kang ora pao kab teb oran hasao nda aol ngo hasaol hondobur men ha ma dengi munu munubur kakl, Njem nao mone san nda baeben hambun li kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ngub kisaol mbibi kongon bombor o bibi o, obun san minisao aol ndam mone aorao nda bor tumu kar munu dombes u kao deb deb bu taeki kobur kakl, Nim kang mend mabor njen mone san ngo hambun ebe luklwaong, kang mend bao ha kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ngo tomb ngub kisao o aol mende mbibin aol wesmabo aondao on mone san aondao andub ora buklhoma iri non bi hasao ndam, inj ora kobur mbibi kongon bombor o bu hasbi aol nda kalabus anda mini po mao palabur, njem nao mone ngo san luklesi ub oran njem kalabus anda ngo ebe tuwakl poklesi kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ngo tomb obum ngub bisaol, aol mendbor obu daol haru kongon bu hasmi baebenom ngo bisao sao hondobur mbinim makl aondao ora homobur kismin, obum ngo bisao sao baeben mbinin aol wesmbao aondao nda po kao kalismi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ngo tomb aol wesmbao aondao ndam, obun kongon biyao aol ngo obun san bao haen hond homobur paokl pisao aol nda ib kobur obu bor kakl, Nje kongon biyao aol kho ora hael. Njem pibnao oran ni de kao njisi tomb njem nao san hasi baeben baehaemen ora bao menin wandis kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Aol wesmbao aondao ndam ngub kobur kakl, Nim nje hond aondao ora homondis o, njem asub ko ibi kongon bombor o bu haroklbe aol ngo obu di hond nao himisib? kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ngo tomb obun aol aondao ndam ngub kobur obun kongon biyao aol ngo obun san hasao aol nda ko aondao ora homobur kisaon, aol mendbor tenaol tenda mao na ke mao handaroklme baeben bor kalabus mini puklub ko kalobur kakl, Njem nao san ngo nao lae sin, ngo bor was bao ke hondo haklesi kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Njisesom ngub kobur kakl, Inin aorao haemem ini bor khorob buklemi sao inim saongao mar hakol bubur nao tuwarim sin, nao Ab yu heben hayaom di aol wesmbao ndam ngo bise ub was, inim khorob buklemi sao di inin kone bor wiyao o nao kunae saongao maruklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ngo tomb Njisesom obun angal hambun sao ngub kao kal paesao tomb obum su Kalili ngo tuwaklbir kisaon, wakl ib Njoran mende nan Njuriyan su pisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ngo tomb tenaol andub ora Njises obun mama taol mi ibismil, su ngo bor tenaol mendbor sen ha wismi baeben Njisesom mao enja peb bisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ngo tomb Peresi aol mendborom Njises hasaol obobur mbinim Njises obu maobowa hondobur kakl, Naon manom ke wiyao ub tenom khorob hambun sao kang bu di aondao bu di buklemi tomb obun aolim ebe anda pu was lao be? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ngo tomb Njisesom mbinin angal ngon ko san lubur kakl, Inim Ngaoron mbuk waeb bor ke wiyao ub nao hendeme be? Ngub ke wiyao. Mbes ora Ngaorom hambun sao warisao tomb obum ten aol kab maomunu warisao ora. ");
INSERT INTO akh_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ngub warisaol aol mondom obun am ab kab tuwabur obun ten taol buklaol, obun were kab maomunu ora buruklebi tomb mbibin toklo is bombor non bi ora soklao. ");
INSERT INTO akh_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ngub soklaol mbes mbibi nongnas tomb mbibin toklo is kab non bi hasbi ub ko mende nao haklebi ora. Ngub inj, mbibin toklo is bombor non bi ora haklebing, hambun sao Ngaorom tangarob sin tenaolom nao hesbeklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ngo tomb Peresi aol nda baebenom Njises bor ne mubur kakl, Njem anda pu nao lowaebe ko ngo kal o, mbes Mosesom kisao ub aol mondom obun were anda pu lowao ko panga sin, aolom ten anda pu lome bobae mend waeb bu ubur inin were ebe anda pu lemi ko waeb bu wisaong, asub ko waeb bu wisaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ngo tomb Njisesom mbini bor kakl, Inim ebekone po awis ora hon moroklmel, Mosesom inin ten anda puklub lowaebe ko ngub kise o, pibnao Ngaorom hambun sao warisao tomb ten anda pu lowaebe ke angal ngubi mend nao wisao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Njisesom ngub kobur kakl, Nim ini kao njun ub pangoklaob. Aol mondom obun werem aol paes nao penbur o aolom njen anda pu kobur obum ten tangar mende taol ba sin, aol ngo obum ten tangar ngo taol buklao o paes ora kemi poklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ngo tomb Njises obun man pange aol baebenom obu bor kakl, Ngub sin aolom ten hesa biri tomb ngub was bukleming, aol mendbor ten nao taol bi hayem baeben non ebe ora kismisa. ");
INSERT INTO akh_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ngub kismil Njisesom mbini bor kakl, Inim ngo lem on tenaol hambun bor was inj, Ngaorom tenaol mendbor mbinin kone bor kao kalaoklao ub was buklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ngub kobur kakl, Pangeklem. Aol mendbor mbinin amom ten nao taol bib se bu baeklae mari ub ten nao taol bimi. Aol mendbor di mbinim ten taol nao bin ko aol tangarom menjao bismil ten nao taol bib se haroklme. Aol mendborom di heben bor maeb ha maomb bo hayao ub hem ko Ngaoron kongon was buklbur ten nao taol biming, tenaol mendborom angal ngo pangobur ni di ngub ten taol nao buklwao ko pangaem sin, mbinim ngub ebe buklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ngo tomb tenaol mendborom nongnas kang mendbor Njisesom kim men mba peb bu Ngaor bor kao kalen ko nen sabobur kismin, Njises hasaol mini ibismisa. Ngub mini ibismi o Njiseson man pange aol nda baebenom obun hobao sao bukl bi hakol ngub nao bib ko makl homo taolu lismisa. ");
INSERT INTO akh_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ngub kismil hondobur Njisesom kakl, Yu heben maomb bo haraoklaomon maeb ha maomb bo hayao bor nongnas kang ngubim kone woroklme ub u haroklme baeben was pokleming, nongnas kang ngubi baeben di ni hae ol eben ub ngub nao lowaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ngub kobur kisaon obum mbini kim men mbabur Ngaor bor kao kalaoklbir paokl pisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ngo tomb aol nas is mend Njises hasaol obobur kakl, Aol aondao o, nim kone ebe ora woroklme ub nim haeben ora saklbur asub ora buklwaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ngub kisaol Njisesom obu bor kakl, Njem asub ko ni bor kone ebe woroklme sao es buwa ne miril? Is bombor ora obu ebe ora yaong, njem haeben ora sakl ko pangae sin njem obun man hambun sao bibi ke wiyao ub hul nao haebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ngub kisaol aol ndam kakl, Man awo was hul nao haklwaob? kisesa. Ngub kisaol Njisesom obu bor kakl, Man ngo ngub wiyao. Njem tenaol mende pe paen nao libi. Njem ten paes nao kemi pebe. Tenaol menden hambun sao di paes nao naebe. Njem tenaol mende bor kakla nao kao beyaebe. ");
INSERT INTO akh_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Njen am ab kabom lebi sao di hul nao hae oborob ora pangaebe. Njem njen mbib was nen sabo hem kale ub njem njen tenaol sango di kone u hond homaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ngo tomb aol nas ndam Njises bor kakl, Njem ni bor ngo bibi kal sao baeben nim ukl mend nao baondib mini hambun sao biyung, nim asao ora nao bi baondib munuweb? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ngub kisaol Njisesom nas nda bor kakl, Njem hambun sao oborob was bu, nje menjao nao baondib mini ebe ngaorukl pelen hakl sin, njen osisao hambun sao maru u harili sao baeben tenaol tangar mendborom dob bin mone mibi ora. Ngub bubur lesin njen mone ngo muklesi baeben, njem tenaol mendbor menjao menjao nao wi buruklemi baeben bisur bu taol bu kalaebe ora. Njem ngub buklesi tomb njen osisao hobao sao ora yu heben bor maru u hae non bu haklesing, njem ni taol mi ebebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ngo tomb nas ndam Njisesom angal ngo kisao o pangobur obun osisao andub ora maru u hasao o sisaol, obun kone bor Njsesom ngo le ub nao buklwao o le ko nen sabobur, kend aondao ora bin pobur paokl ora pisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ngo tomb Njisesom obun man pange aol baeben bor kakl, Nim ini bor heneng ora kao njurukl, aol homa osisao andub ora maru u haroklme baebenom yu heben bor maeb ha maomb bo hayao bor poklbur es aondao ora bubur kekeb haong lib se ora yao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Njisesom ngub kobur kakl, Nim ini bor ko mende heneng ora kao njurukl, aol homa baebenom Ngaorom maeb ha maomb bo hayao bor aondao bu ora es buwa kekeb haong lib se ora yao om, some kamelom lab lab taombuloklme sao kem haolon dir bor es buwa kekeb hondakl buwabur puklmi ub di men mbaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ngo tomb Njiseson man pange aol nda baebenom obum angal ngo kisao nda pangobur kismin, mbinim burir biyu pakl aondao ora homobur kakl, Ngub sin mondom haeben nao saeb se ora saol ngao, aebom was haeben saklaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ngub kismil Njisesom mbini oborob ora hend heneng bubur mbini bor kakl, Tenaol henengom mbinin mbib menjao bukl buwaklemi o, Ngaor obum bombor o hambun sao ebe biyao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Njisesom ngub kisaol Pitam obun angal ngon ko san lubur kakl, Pangal. Nao ngo baebenom non naon hambun sao tuwaklbir naom nje was taol mi ebeyom ngao, naom mabor asao was muklmaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ngub kisaol Njisesom mbini bor kakl, Nim ini bor heneng ora kao njurukl, mabor hambun sao wen pange was pindib paklao tomb Aolon Isi Ora obu bao bi hakol bi oram, obun maomb bo haraoklao seyal buruklao tomb, ini ngo ni taol mi ebeyem baeben di aol wesmbao maomb bo haroklme on seya duteb mendel burubur lemin, inim Isreyel tenaol sem duteb o te mao bembera sarbeklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Njisesom ngub kobur kakl, Tenaol mendborom ni hem ko taol mi oboklbur obun and baeben di, obun aorao haeme di, obun ingi mbaoli di, obun nongnas di, obun su em di ngo sao baeben tuwarim sin, mabor mbini ngo baebenon san aondao bu andub ora pone haen kond bam bam bu kaloklaol, mbini di haeben ora soklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Njisesom ngub kobur kakl, Tenaol andub ora mendbor ngubi tomb aondao hayem baeben mabor kang haklemi. Tenaol andub ora mendbor ngubi tomb kang hayem baeben mabor aondao ora haklemi ko Njisesom angal mar ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ngo tomb Njisesom angal mar kobur kakl, Yu heben maomb bo haraoklaomon maeb ha maomb bo hayao ub, aol is mend obun waen il em kongon bin ko aol mend saond mukl pisesa ub menger maeb ha maomb bo hayao kisesa. Ngub kobur kakl, Aol em aondao ngon aorao ndam hokloben ora aol mendbor obun waen il em kongon bakl ubuklub ko saond mukl pisesa. ");
INSERT INTO akh_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ngo tomb aol em aorao ngo daol obun em kongon bakl bi aol baeben daol kone ukl bombor ora u kao kao bubur, aol em aorao ndam ini bao bombor ngon mone so pao bombor ora mukleming, nao em kongon bakl puklub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ngo tomb aol em aorao ndam 9 kolok nar do turi biyao nda bi tomb sisaol wakl pobur hindisaol, aol ngo haklon mendbor mbinin and te bor baehaemen hasmil hindisesa. ");
INSERT INTO akh_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ngub hondobur aol ngo hasmi baeben bor kakl, Nim ini di sokl ebe njuklwaong, nao waen il em kongon bakl puklub kisaol pismisa. ");
INSERT INTO akh_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ngo tomb em aorao ndam nar wesmbao tukun oral hasaol 12 kolok tomb di, mabor nar as baekeyaesaol 3 kolok tomb di, aol mendbor ngo baehaemen hasmi baeben obum pibnao bisao nda ub obun waen il em kongon bakl puklub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ngo tomb ombonao ora nar unu ora bor bombokl haong haong kisaol 5 kolok tomb sao di em aorao ndam pobur hindisaol, aol mendbor mbinin and te bor baehaemen ha hasmil hondobur mbini bor kakl, Inim bao hor mend ngon hora kongon bib se tomb asub ko baehaemen harmib? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ngub kisaol mbinim obu bor kakl, Nao aol mondom kongon ngo bibaebe ko di mend nao mu njaonaol hamao kismisa. Ngub kismil em aorao ndam kakl, Ebe ka. Ini di nao waen il em kongon bakl puklub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ngo tomb mabor mbon ora sisao tomb aol waen il em aorao ndam obun em ngon kongon bismi aol baeben maomb bo hasao aol o bor kakl, Mbon se ngao, njem em kongon baemnda baeben ubuklub kao kisesa. Ngub kobur kakl, Njem mbinin sokl mone taol bu kaloklesi tomb njem aol mendbor mama kongon bukl obaemnda baeben mbes kalobur kalam aeben aeben bubur lesin, pibnao hokloben ora kongon bukl obaemnda baeben mbini kalo kowes ora bibi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ngub kisaol mbinin sokl mone taol bu kalisao tomb aol mendbor ombonao ora 5 kolok tomb kongon bukl ibismi nda baeben mone so pao mend was kal kal bisaol hindismisa. ");
INSERT INTO akh_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ngo tomb aol mendbor mbini hokloben ora kongon tibiya bismi nda baebenom nao non mone kang mend aondao bu sao muklmao ko nen sabismisa. Mbinim ngub nen sabismi o ngo nen sabismi ub inj, mbini di bombor ub was mone so pao bombor was mi mi bismisa. ");
INSERT INTO akh_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mbinim ngub mubur makl homo hem aondao ora kobur em aorao nda bor kakl, ");
INSERT INTO akh_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Mbini aol ngo baeben non mabor ora, nao kongon bu ham ham bi tomb obobur kongon andub nao baemnda o, naom non nar tenda bi aondao ndan kongon aondao bu kend bi ora bumaol narom nao daol khorob ora li panao o, njem naon sokl di mbini kalal ub was ngo njiril o alem kismisa. ");
INSERT INTO akh_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ngub kismil em aorao ndam mbini ngo hasmi on aol is mend bor obun angal ngon ko san lubur kakl, Nao aol sango o, nim nje bor khorob nao banda ka. Njem nao kongon nao bi hae wen tomb nim nje sokl mone so pao bombor ora njuklwao kandang, yaom kone ukl bombor ora ubur oborob ora nao kao kobarub bo? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Em aorao ndam ngub kobur kakl, Nim njen sokl ngo njanda mini pu ora. Nim nje sokl bombor ngo nje njanda ub was, aol ma ora bor kongon bukl obonao ngo obu di kaloklwao ko nen sabowaong ");
INSERT INTO akh_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","mone ngo ninao ora yaong, mondom ni bor ngub bi ngub bi ko man man lao be? Nim oborob ora banda o, njem aol mende bor daongirir ko makl homal be? ko em aorao ndam kisao ko Njisesom angal mar ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ngo tomb Njisesom ngub kobur kakl, Menger bombor ngub was mubur, tenaol kang hayem baeben mabor aondao haklemi. Tenaol aondao hayem baeben mabor kang ora haklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ngo tomb Njises obu su Njurusalem bor yin poklbur kisaon obun man pange aol baeben di haru pismil, mbinim wen harerol pukl hasmi tomb Njisesom obun man pange aol duteb nda baeben daol mbini was ware pe ora pismi tomb mbini bor kakl, ");
INSERT INTO akh_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Pangeklem. Naom embi ngubi tomb su Njurusalem di mend ngo pukl hayom tomb ora kao njurukl ngao, aol is mondom Aolon Isi Ora karu lubur laon obum Nju semon baolum aol aondao baeben di, mbinin man buwaloklme aol baeben di ngo baeben bor men pae puklub ko kaloklaol, mbinim obu bor te mao sara howes kobur pe paen lemin ora ko kao paklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Njisesom wakl kakl, Mbinim ngub kao pabur lemin Aol Sem Tangarom obu maobowa angal bu, doroklom di khorob ora lu bowes bu, obu ora pe paen is pe kowal bil nil li mbaen ko kaloklemil, mbinim pe paen luklemi o bao hor tebo nanon wakl mao enjaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ngo tomb aol Sebirin isi kab Njemus Njon kabon amom obun isi ngo kab Njises hasaol kemi obobur, ten ndam tumu karu dombes ubur nim nje bor menjao kao njun ub bibi ora ko kao deb deb bisesa. ");
INSERT INTO akh_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ngub kisaol Njisesom ten nda bor kakl, Nim njen asao ora bakan ko kal? kisesa. Ngub kisaol ten ndam Njises bor kakl, Njem mabor aol wesmbao aondao ora haklesi tomb njem nao isi ngo kab oran, is mende njen ki kowes nan is mende njen ki tao nan bu, nje buruklesi ol teb so birin kaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ngub kisaol Njisesom obun angal ngon ko san lubur kakl, Inim ni bor ngo bibi ko kao deb deb bim saon te inim oborob ora nen nao sabebur lem ngao, Njemus Njon kab ibim nim mabor kab bor ib karae bi ber pae mend noklwao ub, ibim di ebe noklbao ko nen sabeyeb be? kisesa. Ngub kisaol mbibim Njises bor kakl, Yaom ebe naeb se hayob kisbisa. ");
INSERT INTO akh_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ngo tomb Njisesom mbibi kab bor kakl, Heneng ora nim kab bor ib karae bi ber pae ngo noklwao ub ibim di noklebi o, ibim ni bor mende aol nao ki tao nan mende aol ki kowes nan bu baoraobun kaebe kaebnda ub non, ninao kongon menjao inj sakl. Nao Ab obun mbib was panda ngol aol ngom was buruklao ko mbes man man bisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ngo tomb Njiseson man pange aol tobon kab mend aebenol sao hasmi nda baebenom Njemus Njon kab haemeyaklom angal ngo kisbi nda pangobur, mbibi makl homo khorob ora taolu lismisa. ");
INSERT INTO akh_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ngub bismi o Njisesom mbini hambun obu hasaol teb so was ubuklub kobur obum mbini bor kakl, Inim di ora hendeyem ub mbini su tenaol sem tangaron aol wesmbao aondao haroklme baebenom tenaol hambun buri palobur ora maomb bo haroklmel, tenaol hambunom mbinin maomb bo haroklme baebenom menjao keme tomb mbinin angal ngo keme ub was pangoklme kisesa. ");
INSERT INTO akh_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Njisesom ngub kobur kakl, Mbinim ngub bimi o inim kone ngubi nen nao saboklwaebe ora. Ngub inj, ini ngo hayem haklon is mondom obu aol aondao imbi wi ora haklwao ko panga sin, obum inin kongon biyao aol men korobur inin bisur biyao aol ora haebe buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ngub kobur kakl, Ini ngo haklon mondom di inin maomb bo haraoklao aol haklwao ko panga sin, obum di imbi nao wi kang ora men korobur inin kongon biyao aol men koro haebe buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Njisesom ngub kobur kakl, Menger bombor ngub was Aolon Isi Ora obu tenaol hambunom obu bisur bin ko inj ibisao ka. Ngub inj, obum kongon buri ora bubur tenaol hambun bisur bukl obobur kisaon, obun mbib obu imbi wi haraoklao ub tuwa, obu pe pabur obum tenaol andub ora bu muklbur ibisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ngo tomb Njises obu di mbini su Njeriko haklbir pismil, tenaol andub ora Njiseson mama taol mi pismisa. ");
INSERT INTO akh_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ngub pismil aol el kho is kab mend harer solol buru wisbi o, Njises obu harer ngo mbibi birisbi on ebe ke pangobur kisbin mbibim aondao bu ora kor bubur kakl, Debir semon isi o, njem yao kab hond hom ora ko kao deb deb bisbisa. ");
INSERT INTO akh_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ngub bisbil tenaol aondao ngo ibismi nda baebenom el hukl bi kho ngubi kabom asub buklbur keyeb kobur, mbibim angal nao ke men mbaen ko buriyab ora taolu lismisa. Ngub bismi o aol el kho nda kabom aondao bu ora kor bi hakol bubur kakl, Aorao Aondao o Debir semon isi o, njem yao kab hond hom ora kisbisa. ");
INSERT INTO akh_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ngo tomb Njisesom nimil tu habur obum mbibi kab kor bubur kakl, Nim ibi bor asao was bun ko ni kor baebib? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ngub kisaol aol el kho nda kabom obu bor kakl, Njem yaon el ebe mao sanin ko kobao kisbisa. ");
INSERT INTO akh_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ngo tomb Njisesom mbibi kab hond homobur kisaon mbibin el kho nda bor obun kim waraesaol, bombor ngo ora tomb mbibin el ebe bao sisaol mbibim osisao ebe hend heneng bisbisa. Ngo tomb mbibim Njises taol mi pisbisa. ");
INSERT INTO akh_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ngo tomb mbinim Njurusalem teb sol sao su kang menden imbi Betpasi, har Olib manda teb sol sisaol ngol pindib paesmisa. Ngo tomb Njisesom obun man pange aol is kab mend puklub ko ");
INSERT INTO akh_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","mbibi bor we kobur kakl, Ibim su isu ngo ibim hendeyeb o enderae inj teb sol ora eng, ngo oral poklebi tomb some dongi hondbao il ingiyakl mend mbinim hendom indi mbaklemil hondoklebing, ibim kolobur komae ubuklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ngub kobur kakl, Some dongi ngo koloklebil mondom ibi bor menjao kaem sin ibim ngub lowaebe. Aorao Aondaom obu buruklbur yao bor some dongi ngo kab ngo komakl pu kene o lowaebe. Ibim ngub lebi tomb some dongi aorao ndam penar bu ora kemi puklub lao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ngo tomb ngo bisao sao mbes Ngaoron man mini aolom mbuk waeb ngo bu wisao ub ngo tomb heneng ora il so pind bisesa. Obum kakl, ");
INSERT INTO akh_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Inim su Siyon tenaol bor ngub lowaebe. Hondoklaob. Inin aol wesmbao aondao nda Ini biri abo ngo ebe o Obum sub was haraoklao o Obu some dongin mesaol baoraoklbir ngo ebe o Obu some dongi hondbaon mesaol Ngo baoraokl ebe o ka. Mbes man mini aolom mbuk waeb bu wisao ub ngo ora tomb il so pind bisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ngo tomb Njiseson man pange aol is kab ndam pobur kisbin, Njisesom mbibi bor we kisao nda ub was bisbisa. ");
INSERT INTO akh_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ngo tomb mbibim some dongi hondbao hesa ingi nda kab kobaran Njises hasol kemi ibisbil, tenaol ngo hasmi nda baebenom some dongi ngon mesaol mbinin lab lab baeben tuwis hasmil Njises ngol birisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ngub birisaol tenaol aondao andub ora ngo Njiseson mama taol mi ibismi nda baebenom Njises obu pokl bisao hareron mbinin lab lab baeben tuwis mba kimb bismil, mendborom di is baoklao sandobur so hapae tuwis mba kimb bismisa. ");
INSERT INTO akh_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ngub bubur kismin tenaol mendbor Njises mao tukun sabur mbini mendborom mbakla pen mendborom mama pobur, mbini hambunom taom bu taokl po angal aondao bu ora kobur kakl, Debir semon isi ngo bor kaoya kem ora Ngaorom imbi wi haen kisao aol ngo obu Aorao Aondao hayao bor hakl ebene ngao Obu bor kaoya kem ora. Aorao Aondao ngo obu yubu ora yao ko Kaoya kem kobur angal aondao bu ora kobur kaoya kismisa. ");
INSERT INTO akh_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ngo tomb Njises obu Njurusalem hondaesao tomb tenaol aondao ngo su and lobokl lobokl ngo bor birismi baebenom burir aondao ora biyubur kakl, Aol ngo obu aeb e bo? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ngub kismil tenaol aondao ngo Njiseson mama taol mi ibismi nda baebenom mbini bor kakl, Man mini aol aondao Njises obaokl ka. Obu Kalilin su Nasarer aol yao kismisa. ");
INSERT INTO akh_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ngo tomb Njisesom Ngaor Hen Moroklme Anda bor hondabur kisaon, tenaol andub ora Ngaor Hen Moroklme Anda ngo bor mbinin osisao baeben tenaol tangarom dob bin mone murukl wismi nda baeben di, tenaol mendbor osisao ngo hakl dob bukl ibismi nda baeben di, ngo baeben hambun ora lu taol deraesesa. Ngub bubur kisaon tenaol mendborom di mbinin mone woroklme to ngo mone ubur, mone su tangar tangar pange kab kab kowal bi bi bu, ngo bi wismi nda to ngo nda hakl baol munu bo kolo bowes bisesa. Ngub bubur kisaon tenaol mendbor sao ebeyabukl dob bi wismi nda baebenon to mbini birismi nda baeben di baol men peb bu bo nuklu bowes bisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ngub bubur kisaon Njisesom mbini bor kakl, Ngaoron mbuk waebom ngub ke wiyao. Nao and ngo ni bor kaoya lome anda hae lemi ke wiyao o inim and ngo paes noklme aolon mupange anda non bi men mao korarmi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ngo tomb Njises obu Ngaor Hen Moroklme Anda ngo bor bao hasaol, tenaol mendbor el kho baeben di tumu kho baeben di obu hasaol was ibismil, mbini hambun ebe mao sa peb bisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ngo tomb Nju semon baolum aol aondao baeben di mbinin man buwaloklme aol baeben di mbini hambunom Njisesom oborob ngo bu hasao sao baeben hindismisa. Ngo tomb Ngaor Hen Moroklme Anda ngo bor nongnas kang ngo birismi baebenom angal aondao bu ora ne bombor ub kombobur kakl, Aol wesmbao Debir semon isi bor kaoya kem ko aondao bu ora kaoya kismil, Nju semon baolum aol aondao baeben di mbinin man buwaloklme aol baeben di mbinim ngo kismi o pangobur ko aondao ora himismisa. ");
INSERT INTO akh_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Mbinim ngub ko homobur Njises bor kakl, Mbinim angal ngo kaolim o njem pangal be? kismisa. Ngub kismil Njisesom mbini bor kakl, E ka. Nim pangakl ngao, mbinim ngub lemi ko mbes Ngaoron mbuk waeb bor wisao ub nao hendeme be? Mbuk waeb ngo bor ngub ke wiyao. Njem nongnas kang angal nao kaeb se baeben di Ora kang ora aondu ne baeben di Njem angal ken lesil Mbinim nje bor oborob ora kaoya lemi ke wiyao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Njisesom ngub kaoklbir kisaon mbini ngol bao haen su and lobokl lobokl ngon dera nan pobur, obum bao ngon somna su Betani bor bao hasesa. ");
INSERT INTO akh_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ngo tomb Njises obu hokloben wakl and lobokl lobokl bor poklbur pisao o obu dem himisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ngo tomb Njisesom harer tol dullub isao mend hasaol il seyao ko pangobur hondokl pisaol, il hond bombor ora di ao sebur kisaon baehaemen so was bu hasaol hondobur dullub isao ngo bor kakl, Njem il ko mend nao soklesi ora kisesa. Ngub kisaol bombor ngo tomb dullub isao nda kaeb sisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ngub bisaol Njiseson man pange aol nda baebenom pakl homo burir aondao ora biyubur kakl, Asub ko dullub isao ngo penar bu ora kaeb saokl bo? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Nim ini bor heneng ora kao njurukl, inim Ngaorol hul ha ora habur inin kone bor taol taol nao bibur kaem sin, inim di nim dullub isao bor ngo bi ub buklemi ora kisesa. Wakl kakl, Inim heneng ora ngub hul ha harim sin, bombor ngo sao was inj buklemi ka. Ngub inj, inim harbor ngo ase hakl bor njem kobaol hakl pobur unu ib kunja tukun oral po saor kaem sin, heneng ngub buklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ngub kobur kakl, Pangeklem. Inim Ngaorol hul ha ora habur Ngaor bor ngo sao bibi ko kao kalaem sin, inim ngo bibi lemi sao hambun sao heneng buklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ngo tomb Njises obu Ngaor Hen Moroklme Anda bor hondabur kisaon, tenaol hambunom pangen Ngaoron angal bib kao kalisesa. Ngo tomb Nju semon baolum aol aondao baeben di, mbinin maomb bo haroklme aol, aol kon wi baeben di mbinim Njises hasaol obobur kakl, Njen buri ngo asub bi ora mondom ngo sao baeben bu hael? Njem ngo bu harili ub benin ko, buri ngo aebom ora taol bu njisao? Njem ngo sao baeben aem bibi ko kao njisao ub ora bu hael? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Nim di ini bor angal kang bombor ora mend ne mun ub inim angal ngo oborob ora ko san laem sin, nim di ini bor aol ngon burim ora ngo sao baeben bu haruklu ko kao njuklwao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ngub kobur kakl, Njonom mbabtas bu hasao ub obum aem bibi kisao ub ora bu hasao? Obum Ngaorom bi kisao ub bisao be? be? baehaemen sul aol henengom bimi ub bu hasaob? kisesa. Ngub kisaol mbini hakl hakl ab saond bi bi bu, naom asub ora kem yeb kao kao bubur kakl, Naom Ngaorom bi kisao ub bisao lomao tomb, obum nao bor inim asub ko Njonom ngo kisao sao oborob ora pango angal ngol hul ha nao hasmib? lao. ");
INSERT INTO akh_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Aoh, naom Njon obum sul aol henengom bimi ub baehaemen bisao lomao tomb di, tenaol hambunom Njon obu Ngaoron man mini aol hasao ko ora hendeyem ol naom mbini pakl hemeyom ngao, naom asub ora kem yeb? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ngub kobur mbinim Njises obun angal ndan ko san lubur kakl, Nao nao hende kismisa. Ngub kismil Njisesom mbini bor kakl, Nim di inim ngo lem ub was, nim hambun sao ngo bu haruklu e ub aol ngon burim bu haruklu ko ini nao kao njuklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ngo tomb Njisesom mbini bor angal mar kobur kakl, Inim asub nen sabeyem? Aol mend obun isi is kab oran hasbil, aol ngom obun isi mubao o birisaol pobur kakl, Embi njem nao waen il em bor kongon bakl pu kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ngub kisaol nas ndam obun aoraon angal ngon ko san lubur kakl, Nim njen em bor kongon ngo nao bukl poklwao kisao o, wakl mabor nas ndam obun kone u bokeyobur kisaon obun aoraon em ngo bor kongon bakl pisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ngo tomb nas is kabon aorao ndam obun isi is mende hasaol pobur obum pibnao nas is mende bor kisao nda ub was kisaol, nas ndam kakl, E ka. Nao ab nim njen em kongon bakl poklwao kisao o, obum baehaemen kobur nao pisao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Njisesom mbini bor ngub kobur kakl, Nas is kab ngom awom ora mbibin abom kone waoraoklao ub bise saol ko pangeyem? kisesa. Ngub kisaol mbinim obu bor kakl, Nas mende mubao pibnao kao kalisao o kismisa. Ngub kismil Njisesom mbini bor kakl, Nim ini bor heneng ora kao njurukl, aol mendbor mone takis habara moroklme aol baeben di, ten mendbor pamuk buru khorob bu hasmi baeben di, mbinim kone baol munu ini mu ma nan saoklbir mbini mbakla Ngaorom maeb ha maomb bo haen ora hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ngub kobur kakl, Pangeklem. Njon Mbabtas Biyao Aolom ini hasmil mbes obobur obum kone ebe woroklme ub ini muwalisao o, inim obun angal pango obum ngo kisao saol hul ha nao hasmi kisesa. Wakl kakl, Inim ngub bismi o aol mendbor mone takis habara moroklme aol baeben di, ten mendbor pamuk buru khorob bu hasmi baeben di, mbinim Njonom ngo kisao saol oborob ora hul ha hasmi. Ngub bismil inim di mbinim ngo bismi ub ora hindismi o, inim mabor di inin kone u bokeyo obum ngo kisao saol hul ha nao hasmi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ngo tomb Njisesom mbini bor inim angal mar mend di pangeklemin kon kobur kakl, Aol mondom obun waen il em bobur kisaon, obum paeb bu tu ndabur em ndaon ngo bor waen il ngo baeben hala sing biyukl bi sowal ongor sao tombo u ib mal mend win kobur, obum em ngo bor waen il em ngo maomb bo hakl bi and mend yu kem bor sao taokl tumu ora bisesa. Ngub bubur kisaon obum em ngo aol mendbor bisnis kongon bimi aol baeben bor maeb hakaklwaebe kaoklbir em aorao ngo obu su enderae ora mendel pobur ngo bor bao hasesa. ");
INSERT INTO akh_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ngo tomb mabor waen il ngo naeb saoklao bao o teb sisaol, aol em aorao ndam obun kongon bimi aol mendbor, waen il ngo maeb haroklme aol aondao baeben hasmil waen il ngon baoklmend obu njuklemi ko nen sabobur makl puklub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ngub kisaol em aorao obun kongon bimi aol nda baeben pismi tomb waen il maeb haroklme aol nda baebenom mbini ngub ibismil hondobur kismin, mbinim is mend doroklom khorob ora lubur is mende ora pe paen lismi. Is mend di hanom lismi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ngub bismil em aorao ndam wakl obun kongon bimi aol mendbor pibnao puklub kisao nda ub waen il mendbor makl puklub kisaol, waen il em maeb haroklme aol nda baebenom em aorao obun kongon bimi aol nda baeben bor di pibnao puklub kisao baeben bor bismi nda ub was bismi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ngo tomb mbinim ngub was bismil, waen il em aorao ndam mabor obun isi kuwis akl bombor ora o waen il em maeb haroklme aol nda baeben hasmil pen kobur, obun isi ngo waen il em maeb haroklme aol baeben hasmi ol pu kisao ndan abom kakl, Mabor mbinim nao isi ngon angal non ebe pangoklemil, pu kakl kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ngub pen kisao o aol waen il em maeb hasmi nda baebenom em ngon aoraon isi nda ibisaol hondobur mbini hakl hakl kakl, Aol ngo obum obun abom wiyao sao baeben hambun sao obum was maeb habur, waen il em ngo naom maeb hayom o di obun ora soklaong, waen il em ngo di naon ora sen ub naom obu penar bu pe paen lem kismi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mbinim ngub kobur kismin em aoraon isi nda waen il em ngon paeb dera nan pen munu haoklu turabur pe paen lismi ko Njisesom angal mar ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ngo tomb Njisesom Nju semon baolum aol aondao baeben di, mbinin maomb bo haroklme aol, aol kon wi baeben di ngo baeben bor kakl, Inim asub nen sabeyem? Mabor aol em ngon aorao ndam obobur, obun waen il em maeb haroklme aol baeben bor asub ora buklao ko pangeyem? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ngub kisaol mbinim obu bor kakl, Em aorao ngom aol kho ngo baeben khorob ora ke mao handa pe beraen lubur laon, obun waen il em ngo di aol tangar mendbor obun waen il ngo naeb soklao tomb obu bor kaloklemi baebenom maomb bo haen lao kismisa. ");
INSERT INTO akh_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ngo tomb Njisesom mbini bor kakl, Inim Ngaoron mbuk waeb bor ke wiyao ub nao hendeme be? Ngub ke wiyao. And kongon bimi aol baebenom And ndaol tokl mend kang kho e ko nen sabobur Tuwaesmi o wakl ngubi tomb And pinj* tao tao aondao hobao sao ora men aolisao Aorao aondaom ngub mao haesaol hendemao tomb Oborob ora bise ko nen sabeyom ko mbuk waeb bor ke wisao ub Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Njisesom wakl kakl, Nim ini bor kao njurukl, Ngaorom ini maeb ha maomb bo han ko nen sabeyao ub wakl bao wabur laon, obum tenaol sem tangar mendbor obum bibaebe lao sao hul nao haebur oborob il sen haklemi baeben was maeb ha maomb bo haklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ngub kobur wakl kakl, Aol mondom and pinj ngo bo kaolu bowes buklwao ko nen soba sin, aol ngub nen saboklao ngo obun toklo baklu bowes buklao kisesa. Mende di and pinj ngom aol is menden toklol kar hakl po tibarob sin, ngo di obun toklo lu hesu bowes ora buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ngo tomb Nju semon baolum aol aondao baeben di Peresi sem mendbor di mbinim Njisesom angal ngo kisao nda pangismi tomb, obum angal mar ngo nao bor menger mubur le ko mbinim ora hindismisa. ");
INSERT INTO akh_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ngub kisaol pangobur mbinim ko aondao ora homobur kismin, mbinim ngo ora tomb Njises bao men haklbur bismi o, tenaol hambunom obu Ngaoron man mini aol aondao ora hae ko ora hindismil mbinim tenaol hambun pakl homobur bao wasmisa. ");
INSERT INTO akh_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ngo tomb Njisesom mbini bor angal mar ukl mend di kao kalobur kakl, ");
INSERT INTO akh_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Yu heben maomb bo haraoklaomon maeb ha maomb bo hayao ub menger, aol wesmbao mondom obun isin ten taol bisaol, aol aondao ngom ne mend haorisesa ub menger maeb ha maomb bo hayao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ngub kobur kakl, Aol wesmbao aondao ngom mbes ne aondao ora haorubur kisaon, tenaol mendbor ne nokl ubuklwaebe kisesa. Ngo tomb mabor ne haoraoklao aol ndam ne haorukl bisao bao o ora pindib paesao tomb, aol wesmbao aondao ndam obun kongon bimi aol baeben bor tenaol mendbor nim ne nokl ubuklwaebe kowao baeben kaomukl puklub kisao o, tenaol hambunom ne ngo nokl ebebe makl himismi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ngo tomb ne haoraoklao aol aondao ndam obun kongon bimi aol baeben wakl puklub kobur mbini bor kakl, Nim tenaol mendbor nao ne ngo nokl ubuklwaebe kowao baeben bor ngub lowaebe. Inim pangeklem. Nim nao ne ngo inim neklemin ko man man bu mbabur, nao some kawao tu ebe baeben di nao some kawao hondbao hobao hae aondao baeben di mbes lu sawo, ne hambun sao mbes man man bu mbaru ngao, inim ne ngo nokl ubuklub lowaebe kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ngo tomb aol aondao ndan kongon bimi aol nda baebenom ngub kao kalismi o, tenaol hambunom angal ngo pangaebe makl homo paokl buri kobur, is mondom obun em bor pisao, is mendem di obun bisnis kongon bu njaesao bor pisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Njisesom ngub kobur kakl, Mbinim ngub was bubur kismin mendborom aol wesmbao aondao ndan kongon bimi aol ngo baebenon mendbor khorob ora men ha lu bowes bubur, mbinim mendbor di ora pe paen lismi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ngo tomb aol wesmbao aondao ndam obun kongon bimi aol o baeben lismi aol nda baeben ko aondao ora homobur kisaon, obum obun ami aol mendbor, aol ngo obun kongon bimi aol nda baeben lismi ngo hakl hambun ora lu bowes bu, mbinin and te baeben di su tokl nao peyokl puklub kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ngo tomb aol wesmbao aondao ndam obun kongon bimi aol baeben bor wakl kakl, Ne ngo man man bu u mba hae o, nim tenaol ngo mbini ne nokl ubuklub kowao baeben mbinin kone bor kho ora yaol, ne ngo nokl obokl buwaklemi ora kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ngo tomb aol wesmbao aondao ndam obun kongon bimi aol baeben bor kakl, Inim harer to to tiriyao kombae kombae baeben bor pobur lemin, inim tenaol harer to to hen muklemi baeben hambun bor aol aondaom ten taol bimi bao on ne aondao ngo hereyao o nokl ubuklub lowaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ne haoraoklao aol ndam ngub kisaol obun kongon bimi aol nda baebenom su harer to to hambun bor buri kobur kismin, mbinim tenaol kho ebe hindismi baeben obo kiril mba was bin ko kemi obobur, mbinim ne haoraoklao aol aondao ndan anda bor hakl kang ora di nao haen tumbi hakl peben ora birismisa. ");
INSERT INTO akh_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ngo tomb tenaol hambun ngub birismil, aol wesmbao aondao ndam tenaol ngo ne noklbur birismi baeben hondabur hindisaol, aol mondom obun lab lab di samisao sao hakl yaor ebe ten taol bimi bao on bimi ubi nao bibur birisaol hindisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Aol wesmbao ndam ngub hondobur aol ngo birisao bor kakl, Aol sango o, njem asub ko lab lab di njen samel sao hakl yaor ebe ten taol bimi bao on bimi ubi nao bibur and ngo bor honda baraeb kisao o, aol ndam e beb nao kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ngo tomb aol ndam ngub e beb nao kisao tomb aol wesmbao aondao ndam obun kongon bimi aol baeben bor kakl, Inim aol ngo obun ki aongao kab tanga pabur, and te ngon dera nan isu em hundur wi ngo ora bor tuwaklaob kisao kisesa. Ngub kobur kakl, Mbinim ngub tuwaesmil obum em hundur wi ngo ora bor saongao kengerokl no de khorob ora ko hasao ko Njisesom angal mar ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Njisesom ngub kobur kakl, Heneng ora Ngaorom tenaol hambun ubuklub lao o, bombor bombor obu hem ko obul kone uklemi baeben was bember ha peb bu mbakl mib buklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ngo tomb Peresi aol mendborom mbini hakl hakl kakl, Naom Njises bor oran obum angal khorob mendbor naom obu te mao saraeb se oran mendbor ken ub, inim sub kakla sowa pabur angal andub ora mundub baol baol bu, obum angal khorob kaeb se haklon ne mibaebe ko karu mao kikil paesmisa. ");
INSERT INTO akh_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ngo tomb mbinim ngub kobur kismin, mbinin man pange aol mendbor di mbinin aol wesmbao Heroron tenaol sango mendbor di mbinim Njises hasaol obum khorob sao dim bib ko hondokl puklub kismil, mbinim Njises hasaol pobur kakl, Aol aondao o naom di nje ora hendeyom. Njem angal di heneng was kale. Mende di njem tenaol hambun bor heneng ora was kobur Ngaorom nen sabeyao ub was kale. Njem mbini aol aondao hayem baeben di, mbini aol aondao mend harilim ko sor nao mirili ora. Mend di njem aol aondao imbi wi hayem baeben bor angal tangar ubi ora kobur, aol mendbor imbi nao wi kang sao hayem baeben o bor kone tangar ubi u angal tangar ub kao kao nao bili ora. Ngub inj, njem tenaol hambun bor kone bombor ub was wirili ora kismisa. ");
INSERT INTO akh_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mbinim ngub kobur kakl, Njem oborob ngub was bilil laom ngao, njem asub nen sobal? Naom Orom semon aol wesmbao aondao Sisan mone takis moroklme aol baeben bor takis kalemin be? nao kalemin ko pangal. Naon manom asub ke wiyaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ngub kismi o Njisesom mbini kone bor khorob ngo nen sabismi ub ora hondobur kakl, Ini songolom man mini non bubur kakla lome aol o hakl o, inim ni bor kakla asub ko maobowa hendeklem? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ngub kobur kakl, Inim ni mone ngo takis kaloklme on hond mend hondon njib kisaol, mbinim obu mone hond mend henden kalismisa. ");
INSERT INTO akh_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ngub kalismil Njisesom mbini bor ne mubur kakl, Mone il ngol piksa ngo wi o hesa imbi ngo wi o kab aeben non bi eb? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ngub kisaol mbinim obu bor kakl, Orom semon aol wesmbao aondao Sisa ndan non bi e kismisa. Ngub kismil Njisesom mbini bor kakl, Ebe ka. Sisa obun sa sin obu ora kaloklwaebe. Ngub inj, Ngaoron menjao sa sin Ngaor kaloklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ngo tomb Njisesom mbini bor angal ngo kisao o pangobur, mbinim burir aondao ora biyaoklbir Njises obu ngol bao haen paokl ora pismisa. ");
INSERT INTO akh_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ngo tomb bao bombor ngon was Sarusi tenaol baebenom tenaol pe paklemi baeben wakl ko mende nao enjoklemi kismi ub kobur, Sarusi sem mendbor Njises obu hasaol obobur mbinim obu bor ne mubur kakl, ");
INSERT INTO akh_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Aol aondao o, mbes Mosesom kisao ub aol mend obun ten taol buklao o nongnas is mend and nao senbur bao homa sin, ten weyao ngo obun haemem taol bubur obun haeme ngo homoklao on nongnas maru waklao ora ko waeb bu wisesa ko mbinim Njises kao kalismisa. ");
INSERT INTO akh_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mbinim ngub kobur kakl, Mbes aol mbini haemeyaen is haoklao mend nao hasmaol hasmi o, mubao ndam obun ten taol bisao o obum nongnas is mend nao maru wisao tomb obu bao himisaol, ten weyae ngo obun haemem taol bisao kismisa. ");
INSERT INTO akh_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ngub taol bisao o haeme kabo nan ngom di nongnas is mend nao maru wisao tomb ngub was bao himisaol, haeme is tebo nanom taol bisao. Ngub bisao o ngom di is mend nao maru wi ngub was bisaol, ten ngo obu weyae baram aeben was bisaol, mbini haemeyaen is haoklao hambunon were sisao kismisa. ");
INSERT INTO akh_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ngub kobur kakl, Aol ngo baeben hambun ngub himismil, mabor ten weyae baram aeben bisao ngo obu di himisao kismisa. ");
INSERT INTO akh_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mbinim ngb kobur Njises bor kakl, Njem di ora nen sobal ngao, ten ngo obu mbini haemeyaen ngo baeben hambunon were ora sisaong, njem tenaol heme baeben wakl enjoklemi kale nda ub enjoklemi tomb ten ngo obu aeben were ora soklaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Inim Ngaoron mbuk waeb bor wiyao ub hesa Ngaoron buri kab nao hende sakl, inim angal ngo lem o khorob ora lem kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ngub kobur kakl, Tenaol heme baeben wakl enjoklemi tomb mbini Ngaoron angal mini wesao yu heben bor haeme ubi ora haklemil, tenom aol po aolom ten taol bu ngub nao buklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ngub buklemi o nim ini bor tenaol heme wakl enjoklemi on ne mun kobur kakl, Angal ngo Ngaorom ini bor mbes kao njisaol mbuk waeb bor wiyao ub nao hendeme be? Obum ngub kisao. ");
INSERT INTO akh_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ni Eberehem di Isak di Njekob di ngo himismi baebenon Ngaor ora hae kisao o, Ngaor obu tenaol pe pabur songol bung biyao saon Ngaor inj, wesao pobur haeben soklme baebenon Ngaor ora hayao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Njisesom ngub kisaol tenaol hambunom obun angal ngo pangobur burir aondao ora bismisa. ");
INSERT INTO akh_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ngo tomb mbini Sarusi aol nda baebenom angal menjao lomao ko pangismi o, Njisesom angal ngo kisao ndam ora men mbaen kisesa. Ngub bisaol Peresi aol baebenom angal ngo kisao o pangobur kismin, mbinim Njises hasaol teb so obo kiril mbaesmisa. ");
INSERT INTO akh_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ngo tomb ngo obo kiril mba hasmi darukl o bor mbinin man buwalaoklao aol is mend habur, obum Njisesom angal khorob dim leb ko hondoklbur ne mi hondobur kakl, ");
INSERT INTO akh_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Aol aondao o, Ngaoron man hambun sao wiyao on hobao sao aondao bombor oran awo wiyaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ngub kisaol Njisesom obun angal ngon ko san lubur kakl, Njem njen Aorao Aondao Ngaor turi aondao ora homobur lesin, njen hibim di njen konem di njen wesaom di njen Aorao Ngaorol turi homo kone wibi. ");
INSERT INTO akh_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Man bombor ngo hobao sao aondao ora yao kisesa. Ngub kobur kakl, Man bombor ngo hobao sao ora yaol, man ngom Ngaoron man wiyao baeben hambun men mbayao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Njisesom ngub kobur kakl, Man ngon kabo ngub wiyao. Njem njen mbib was nen sabo hem kale ub, njem njen tenaol sango mende di hem kobur hond homo kone wibi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ngub kobur kakl, Man ukl kab ngom Moseson man hambun wiyao baeben hesa mbes man mini aol baebenom kismi ub kab kao dund bi hayao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ngo tomb Peresi aol mendbor ber mba hasmil Njisesom mbini bor ne mubur kakl, ");
INSERT INTO akh_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Inim Ngaorom Eben Lao Aol obu bor asub nen sabeyem? Obu aeben isi ora soklaob? kisesa. Ngub kisaol mbinim Njises bor kakl, Obu aol wesmbao Debiron sem soklao kismisa. ");
INSERT INTO akh_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ngub kismil Njisesom mbini bor kakl, Obu ngub Debir semon isi soklao sin, mbes Ngaoron Wesaom Debir obun kone bor hondaesao tomb Debirom asub ko Ngaorom Eben Lao Aol bor nao Aorao Aondao kisaob? kisesa. Debirom ngub kisao. ");
INSERT INTO akh_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Hambun Saon Aoraom nao Aorao Aondao bor kakl Ngubi tomb njem nao ki tao nan bao berel o Mabor njen saond bi baeben Njen aongao ma bundur nan Hala mbanin lowao kisao ko Debirom waeb bu wisao ub Njisesom kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Njisesom mbini bor ngub kobur kakl, Debir obun mbib nao Aorao Aondao kisaong, mbinim asub ko Ngaorom Eben Lao Aol bor Debir semon isi heneng soklao lomeb? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ngo tomb Njisesom mbini bor angal ngo kisao on mondom ko san ora lukl buwabur, mbinim wakl ko mende menjao ne di nao mi pakl homobur bao waesmisa. ");
INSERT INTO akh_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ngo tomb Njisesom obun man pange baeben di tenaol aondao ngo birismi baeben di mbini hambun bor kakl, ");
INSERT INTO akh_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Mbini Nju semon man buwaloklme aol baeben hesa Peresi aol baeben kabom Mosesom mbuk waeb bu wisao ub tenaol hambun buwaloklme kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ngub kobur kakl, Mbinim ngub buwaloklmeng, mbinim ini bor man hambun sao kao njoroklme baeben inim pangobur hul nao haklwaebe. Aoh, ngub buklemi o inim mbinim hambun sao bu haroklme ub nao bibaebe ora. Ngub inj, mbinim tenaol hambun bor ngo sao ngo sao bibaebe lome o, mbinim mbinin mbib ngub nao bibur lome kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wakl kakl, Mbinim tenaolon pesaol kend bi sao aondao ora ngo mao taroklmel mbinim kongon buri ora bubur toroklme o, mbinim ki honde hond bombor oram di kend bi sao ngo tenaol bor taoraoklaob lome on kang mend bisur bu menya heneng ora di nao bimi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ngo tomb Njisesom ngub kobur kakl, Mbinim hambun sao ngo bu haroklme sao baeben baehaemen tenaolom henden ko bimi kisesa. Wakl kakl, Heneng ora mbinim man men hakol bimi ken ko mbinim wanul man waeb bu pae bobae kang mend suwim so sa bu mba, mbinin lab lab saoll baebenon kungnil di mao ha peb bu ngub bimi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ngub kobur kakl, Mbinim ne aondao mend noklbur bereme tomb di, mbinim pand tukun was mu pakl ke ke bubur mbinim mbinin man pangoklme anda bor hor burukl pobur di, tenaol hambunon el so panda tukun ebe ol was turi homo burukl ke ke bimi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ngub kobur kakl, Mbinim tenaol hambun obo kiril mba boroklme su o bor ebekone po, mbini bor kaoya ken ko mbinim tenaol hambunon el sol turi homo ki siken bukl nda pobobur, mbinin aol kang mend homa sao yao o bor, Aol Aondao o ko kor bubur kaoyakl ke ke was bimi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Njisesom ngub kobur kakl, Mbinim ngub lome o mondom ini bor Aol Aondao o ko kor nao buklemi ora. Ngub inj, inin Aol Aondao is bombor ora hael, inim mende kor bi bi buklbur aol sango o haeme o kao kao bu haklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Njisesom ngub kobur kakl, Sun aol is mend bor Ab ko kor nao bibaebe ora. Ngub inj, inin Ab is bombor ora obu yu heben hayao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ngub kobur kakl, Mend di mondom ini Maeb Haraoklao Aol o ko kor nao buklao ora. Ngub inj, inin Maeb Haraoklao Aol aondao ora Ngaorom Eben Ke Aol obu bombor ora yao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Njisesom ngub kobur kakl, Ini ngo haklon is mondom obu imbi wi aol aondao harob sin, obum inin kongon biyao aol men aolubur obum inin bisur biyao aol ora haebe buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Wakl kakl, Aol mondom obun mbib ni imbi wi ebe ora hae ko kaoya ka sin, Ngaorom obu men mbabur imbi nao wi kang ora men mao koraklao. Ngub inj, aol mend obu imbi nao win haklwao ko panga sin, Ngaorom obu imbi wi aondao ora haen lao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ngo tomb Njisesom kakl, Ini Nju semon man buwaloklme aol baeben o, ini Peresi aol baeben di ini ke aondao ora hondoklbur hayem. Ini songolol man mini non bubur angal kab ko hae aol o hakl o, tenaol hambunom yu heben maomb bo haraoklaomon maeb ha maomb bo hayao bor poklbur bimi o, mbinim nao pen ko inim pela ubur hondaen bao wa nao bimi o, inim inin mbib di makl homobur nao hondaroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Wakl kakl, Ini Nju semon man buwaloklme aol o hakl o, ini Peresi aol baeben di ini ke aondao ora hondoklbur hayem. Ini songolol man mini non bubur angal kab ko hae o hakl o, inim ten mendbor mbinin aoli heme baebenon and di mbinin osisao baeben di taol pe mu habur lomen, kakla inim khorob ngo beme saon pe kowes bubur tenaolom ini ebe ora hayem ken ko Ngaor bor ko soklo aondao bu ora ko haroklmel, Ngaorom tenaol hambun sarbeklao tomb mendborom ke hondoklemi ub men mbabur, ini ngo baeben ke aondao ora hondoklbur hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ngub kobur wakl kakl, Ini Nju semon man buwaloklme aol o hakl o, ini Peresi aol baeben di ini ke aondao ora hondoklbur hayem. Ini songolol man mini non bubur angal kab ko hae o hakl o, inim ib kunja bor di su heneng baeben bor di tenaol mendbor inin man pange tenaol haen koklbur akol akol bu haroklme. Ngub akol bu haroklme tomb mendborom inin man pango bereme tomb inim mbini is de bor pen ko man man bu haen lomel, mbini di ini hayem ubi was haroklme. Ngub haroklme o inim mbini khorob aondao bu ora mao baroklmel, inim khorob bu haroklme ub kang mend men mba sao bubur mbinim khorob aondao bu ora bu haroklmel, ke aondao ora hondoklbur haeme kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ngub kobur kakl, Ini el kho ora habur o inim tenaol sango mende harer muwalo hayem ol, ini ke aondao ora hondoklbur hayem. Inim ngub lome. Mondom nim Ngaor bor ngo sao buklwao kobur Ngaor Hen Moroklme Anda mao* lao o, obum mabor nao bi kor kusa sin ebe was lome. Ngub lome o mondom nim Ngaor bor menjao buklwao ora kobur Ngaor Hen Moroklme Anda bor han ngol mend wiyao o mao keyao tomb, obum ngo le ub kor nao kusi heneng ora bibi buklao ko nen saboklme kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Njisesom ngub kobur kakl, Ini mbaoli tumu mari non bi kon nao wi el hukl bi o hakl o, inim asao was hobao sao aondao ora e ko pangeyem? Han ngol ora aondao be? Ngaor Hen Moroklme Anda oram han ngol ngo komb bi win laong, Ngaor Hen Moroklme Anda ngo aondao ora e ko pangeyem? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ngub kobur kakl, Inim mende di ngub lome. Mondom nim Ngaor bor ngo sao buklwao kobur mabaorao haroklme to imbi kobur mao lao o, obum mabor nao bi kor kusa sin ebe was lome kisesa. Wakl kakl, Inim ngub lome o mondom nim Ngaor bor menjao buklwao ora kobur, mabaorao haoroklme tol osisao mend wiyao o mao keyao tomb, obum ngo le ub kor nao kusi heneng ora bibi buklao ko nen saboklme kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ngub kobur kakl, Ini el hukl bi o hakl o, asao was hobao sao e ko pangeyem? Ngaor bor osisao kaloklme sao hobao sao e ko pangeyem be? Mabaorao haoroklme tom osisao Ngaor bor kaloklme sao komb bi win laong, mabaorao haoroklme to hobao sao e ko pangeyem? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Njisesom ngub kobur kakl, Pangeklem. Tenaol mondom nim ngo kakl ub buklwao ora kobur Ngaor bor mabaorao haoroklme to mao lao tomb, obum to ngo di to ngo bor wiyao sao baeben di hambun sao maomunu mao ke non bi soklaol, obum mao ngo kor nao kusaeb se ora yao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Wakl kakl, Mondom di ngo sao buklwao kobur Ngaor Hen Moroklme Anda mao lao tomb, Ngaor obu di and ngo bor bao haraoklaol obu di maomunu mao ke non bi ora soklao. ");
INSERT INTO akh_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Pangeklem. Mondom di nim buklwao ora ko mao kobur yu heben mao ka sin, aol ngo obum Ngaoron maomb bo haraoklao seya on hesa Ngaor obu di seya ngo bor buruklaol obu di maomunu mao laol, obum mao ngo kor nao kusaeb se ora hayao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Njisesom mbinim bor wakl kakl, Ini Nju semon man buwaloklme sem hesa ini Peresi aol baeben kab o, ini ke aondao ora hondoklbur hayem. Ini songolol man mini non bubur angal kab lome aol o hakl o, inim eb sembi non bi semon di ne noklme sao nao hobao sao baeben hambunon tobon kab nan o Ngaor bor was kaloklme o, inim Ngaoron man hobao sao wiyao ub tuwaroklme kisesa. Ngub kobur kakl, Inim man ngo sao was tuwaesmi ka. Tenaol hambun bor kone bombor ub was u kone ebe ubur tenaol mende hond homoklme ub di, Ngaorol hul ha haroklme ub di, inim kone ebe ngub woroklme baeben tuwa haroklme kisesa. Wakl kakl, Inim Ngaoron man wiyao ub ne noklme sao hambun sao tobon kab nan o Ngaor bor kaloklwaebe ke wiyao ub ebe beyem o, nim hobao sao ora ngo kakl o di nao tuwaklwaebe buklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Njisesom ngub kobur kakl, Ini el kho ora habur o tenaol sango mende harer muwalokl nda pebe o hakl o, pungun mend inin ib ber pae kab bor hondayao tomb inim no tu kobaklwao ko hondobur oborob ora es bu mu tuwaroklme o, inim wakl nao hendebur aondao sao some kawao non bi is mend no tu kobaroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ngub kobur kakl, Ini Nju semon man buwaloklme aol hakl o, ini Peresi aol baeben di ini ke aondao ora hondoklbur hayem. Ini songolol man mini non bubur angal kab ko hae o hakl o, inim kab hesa peler kab dera nan oborob ora wes wes loroklme o, inin kone ndaon bor tenaol menden osisao maobala mu khorob bimi sao bao winbur, inin songolom bi keyao ub was bimi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Njisesom ngub kobur kakl, Ini Peresi aol el hukl bi o hakl ka. Inim pibnao oran inin kab ngon moklo ndaon bor oborob ora wes wes li peklwaebe. Inim ngub buklemi tomb dera nan di ebe was wes li pele ora soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ngub kobur kakl, Ini Nju semon man buwaloklme aol o hakl o, ini Peresi aol baeben di ini ke aondao ora hondoklbur hayem. Ini songolol man mini non bubur angal kab ko hae o hakl o, ini aol maol dera nan dind bongna haek bi ebe ora baekeklme nda ubi menger hayem. Tenaolom dera nan hendeme tomb aol maol ngo ebe ora saoklao o, moklo ndaon bor aol hul kolokl barae di kho sao buklaeb mba habur biyao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Njisesom ngub kobur kakl, Ini ngo baeben nim menger ngo murukl ubi hayem ka. Tenaolom ini toklo songol dera nan hendeme tomb mbinim ini kone dund se wi ebe ora hayem ko pangeyem kisesa. Wakl kakl, Mbinim ngub nen sabeyem o inin kone bor kakla lome sao di, Ngaoron man hul habur khorob bimi sao baeben hambun sao di, ngo sao was bu mba hayao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Njisesom ngub kobur kakl, Ini Nju semon man buwaloklme aol o hakl o, ini Peresi aol baeben di ini ke aondao ora hondoklbur hayem. Ini songolol man mini non bubur angal kab ko hae o hakl o, mbes Ngaoron man mini aol himismil tangaesmi baebenon maol o bor kundiyakl menakl bu wakl was bu habur, aol ebe himismi baeben di mbinim mbes oborob was bu hasmi kobur inim mbinin maolol oborob ora yaor mao ba hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ngub kobur kakl, Inim ngub bu habur wakl ngub lome. Naom mbes naon ab sumb wil baeben daol haru hakl bismaon, mbinim mbes Ngaoron man mini aol hasmi baeben lismi ub bukl bismi tomb nao haru lem ko, turi homo ngub nao bukl bismao ora ko hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Wakl kakl, Inim ngub ko hayem o inin mbib ngo ko hayem om ora, nao naon ab sumb wil ngo mbes Ngaoron man mini aol baeben pe paen lismi on sem hayom ko inin mbib kao pabur te muwalo hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ngub kobur kakl, Ebe ka. Inim di inin ab sumb wil baebenom ngo bismi ub was bam bam bubur, ngub was bu mae libaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Njisesom ngub kobur kakl, Suklumb sem o hakl o, ini suklumb hondbao o hakl ka. Ngaorom ini bor ngo sao was bismi ko te mao sarabur is de ora bor peklemin lao orang, inim asub buklemi? Ngaorom ini te mao sara ke mao handaklao ub nao bin ko pakl paokl poklemi be? Ngub inj ka. Ngaorom ini ke mao handaklao ub tuwaklbir ini non bim pakl paokl pokl buwaklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ngub kobur wakl kakl, Ngo kakl ub buklaong inim pangeklem. Nim ini haklemil nao man mini aol mendbor mbini kone kikil bi Ngaoron mbuk waeb oborob hende baeben eben lowao ora kisesa. Wakl kakl, Ngub eben lowao o inim ngo eben lowao haklon mendbor pe paen lubur, mendbor di is pe kowal bil pe paen nil li mba peb buklemi. Inim mbini mendbor di inin man pangoklme anda andaon doroklom luklemi kisesa. Njisesom ngub kobur kakl, Inim ngub bubur lemin mbini nao man mini aol ngo baeben su and lobokl lobokl mendel haklemi o, inim mbini taol mi akol bu luklemil mbinim su and lobokl lobokl mende bor poklemi o, inim ngo bor di taol mi po luklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ngub kobur kakl, inim ngub buklemi o aol mendbor mbes kone ebe wi su ngol hasmi baeben inin ab sumb wil baebenom pe paen lismil, ini mbinin poklon ndabur ke hondoklemi kisesa. Wakl kakl, Heneng ora aol kone ebe wi Ebel di pe paen lismil, aol ebe ngubi baeben ngub homam obam obam bubur, Berekayan isi Sekaraya di Ngaoron panda komb bi ora hesa Ngaor bor kalo mabaorao haoroklme to kabon tukun bor pe paen lismi ora. Ngub lismil ngo bu haroklme baeben hambunon Ngaorom ini ngo baeben te mao saraklaol, inim mbinin poklon ndabur ke hondoklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ngub kobur kakl, Nim ini bor heneng ora kao njurukl, inim di ngub was beyem ol hambun sao khorob ngo bu hasmi on poklon ndabur, ini tenaol ngubi tomb hayem baeben mabor ke aondao ora hondoklemi ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ngo tomb Njisesom Njurusalem tenaol hem ko hond homobur kakl, Is alem. Njurusalem tenaol o hakl o, inim Ngaoron man mini aol baeben pe paen lu, Ngaor obum man mini aol mendbor ini haemel pu kisao baeben di hanom loroklme tenaol o hakl o, nim mbes ora di hor hor was ini ngo baeben, sao kulaom obun hondbao baeben obun bobao bundur bor maembe mbaen kobur men mba paolaoklao nda ub bundis o, inim turi homo nao ebe bao waesimndis kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ngub kobur kakl, Pangeklem. Inin Ngaor Hen Moroklme Anda ngo hae o bor Ngaor obu nao haklaol, baehaemen and was haklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Wakl kakl, E ka. Nim ini bor heneng ora kao njurukl, ini ngo baebenom ni ko mende nao hondoklemi o, ma ora bor inim ni bor kaoya kem kobur, Ngaorom imbi wi haen kisao aol ngo obu Aorao Aondao hayao bor hakl ebene ngao Obu bor kaoya kem ora lemi tomb inim ngo tomb ora ni ko mende hondoklemi ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ngo tomb Njises obu Ngaor Hen Moroklme Anda ngol haklbir pisaol, obun man pange aol baebenom Njises obu hasaol obobur mbinim Njises obu bor Ngaor Hen Moroklme Anda baeben ebe ora was haeng hend ko muwalismisa. ");
INSERT INTO akh_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ngo tomb Njisesom mbinin angal ngon ko san lubur kakl, Inim and ebe ngo hae hakl hendeyem be? Nim ini bor heneng ora kao njurukl, mbinim han sango menden mandaemol di hond mend baondib munu bao win wa nao buklmi ora. Ngub inj, mbinim and ngo hakl hambun ora, kundi bowes buklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ngo tomb Njises obu har Olib manda bor birisaol, obun man pange aol baeben mbini was ware pe ora Njises obu birisaol obobur kakl, Njem ngo buklao kaendisao baeben atomb ora buklao bor kae bo? Njem nao kao nji kismisa. Wakl kakl, Njem ngo buklao kaendisao baeben buklbur buklao tomb naom pibnao oran asao ora mbes buklaol hondobur nje wakl oboklesil, naom su ngo ora soklao bao o teb saol ko pangoklmaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Pangeklem. Tenaol mendborom ini maobowabur kakla lemi hondo ora haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ngub kobur kakl, Aol andub ora ini haklemil obobur mbinim ni hae non bubur lemin, ni Ngaorom Eben Ke Aol ora hae lemi kisesa. Mbinim ngub kobur lemin tenaol andub ora maobowam akol bu haklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Njisesom mbini bor wakl kakl, Teb sol sao di enderael sao di saond aondao ora mend daoklu lili buklebil, inim poboklo oboklaol pangoklemi tomb saond ngo buklebi o hondobur inim pakl homo burir nao biklwaebe ora kisesa. Ngub kobur kakl, Nim ngo kakl sa mbes buklao o mabor bao bu kowes buklao o, nao pindib pae wen soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Wakl kakl, Aol sem tangar mondom sem mende saond bu kaloklao. Ngo tomb kabman semom di sem mende bor saond bu kal kal buklemi kisesa. Ngub buklao tomb su mendbor de aondao ora oboklao. Su mendbor di dull bere aondao ora oboklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Njisesom ngub kobur kakl, Tenom nongnas maruklbur beme tomb mabor tenda aondao bu buklbur o pibnao kang bu bam bam biyao nda ub menger, nim ngo kakl sao baeben mbes buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Njisesom ngub kobur wakl kakl, Ngo sao hakl buklao tomb inim nil hul ha haklemil, tenaol hambunom ini hendaebe makl aondao ora homobur nar wen ebe hende non buklemi. Ngo tomb mbinim ini men pae pobur lemin, lu bowes bu tenda mao na ini pe pareklemin di luklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Njisesom wakl kakl, Ngub buklemi tomb tenaol andub ora mendbor Ngaorol hul ha obul ora kone u haklemi baeben di mbinim besao kon ubur lemin, tenaol mende karu lili bubur tenaol hambunom mende bor ko was hom hom buklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ngo tomb Ngaoron man buwale non bubur man tangar sao buwaloklme aol mendborom tenaol hambun maobowaklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Njisesom wakl kakl, Tenaol kho mao saraoklao sao hambun sao aondao bu ora ngub and soklaol, tenaol andubom Ngaor bor di tenaol mende bor di hem ko kone woroklme ub ora tuwaklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ngub kobur kakl, Ngub buklemi o tenaol mendbor nil hul ha saor pe was bao harim sin, Ngaorom mbini bu muklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Njisesom ngub kobur kakl, Ngaorom ngub maeb ha maomb bo hayao ko, Angal Bib Hobao Sao ngo su hambun bor tenaol hambunom pangen kao kalam akol bu paklemi tomb oran bao bu kowes buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ngo tomb Njisesom kakl, Inim mabor hondoklemil kho mao sakl buklao sao ngom su enjo ngo bor kho mao saklao o, mbes Ngaoron man mini aol Daniyaolom kisao ub panda komb bi ora bor obo haklao kisao kisesa. Pangeklem. Tenaol mendbor mbuk waeb ngo bor wiyao ub hondoklesi baebenom oborob ora hondobur kone kimb bibaebe. ");
INSERT INTO akh_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ngo tomb Njisesom wakl kakl, Ngub buklao tomb tenaol mendbor su Njuriya bor buruklemi baeben yu har ne baeben bor pakl paokl puklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ngub kobur kakl, Aol mondom njen and wil dera nan hari sin, njen osisao uklesi o mukl wakl andaon nao hondaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Wakl kakl, Mende di aol mondom njen em bor hari sin, njen toklo and turub bi mukl anda nao pe, pakl paokl ora pebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ngub kobur kakl, Is ora alem. Ngo sao buklao tomb ten mendbor hondbao pango uklemi baeben hesa nongnas aondu ne baeben kab oran hond bu pae delib ebe ora soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Wakl kakl, Pibi hon oboklaol hub ingi soklao tomb hesa hor boroklme bao on kab naom pakl pokl buwaklmaong, khorob ngo sao nao eben kaebe ko Ngaor bor kao kaloklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ngub kobur wakl kakl, Is ora alem. Ngo ora tomb ke aondao ora hondoklemi ka. Mbes Ngaorom su wen warisao tomb di, karasmas hambunon ora ngubi tomb di, khorob sao aondao ngubi mend nao hindismi ora kisesa. Ngub kobur kakl, Ke aondao ngo hondoklemi ubi mend sul bao haklemi tomb mabor di nao hondoklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ngub kobur kakl, Ngaorom ngo sao buklao o bao hor andub ora nao ndi tibaklwao ko nen nao sabokl bisaon, tenaol is mend nao bulaokl pokl beme o, Ngaorom obun tenaol mbes sablo haen kisao baeben hond homobur bao hor andub ora ndi nao tibaklwao ko nen sabisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Njisesom ngub kobur kakl, Ngo sao baeben hambun sao buklao tomb aol mendborom ini bor ngub lemi. Ngaorom Eben Ke Aol obu enjo ngo bor ngo hae o haondaoklaob. Aoh, obu isu ngo bor hayao leming, mbinim ini bor ngo lemi ub heneng lem ko nen nao saboklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ngub kobur kakl, Mabor mendborom ni Ngaorom Eben Ke Aol ora hae, mendborom di man tangar mini obobur ni Ngaoron man mini aol hae ko tenaol hambun maobowakl obobur, mbinim tenaolom ko mend nao hindismi sao di burir biklme sao di aondao bu ora bam akol bubur, tenaol Ngaorom sablo haen kisao baebenon kone bor di ngil ngaol mao kabur maobowa hondoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Njisesom ngub kobur kakl, Pangeklem. Ngo sao baeben hambun sao wen buklao ub nim ini bor ngo kao njurukl ong, hondo ora haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Njisesom wakl kakl, Mbinim ini bor ngub lemi. Haondaoklaob. Ngaorom Eben Ke Aol obu su tenaol nao biri isu ngo bor hayao lemin, inim ngo bor es bukl nao puklwaebe. Mbinim ini bor ngub kobur kakl, Haondaoklaob. Eben Ke Aol obu enjo andaon ngo bor bereyao leming, mbinim ngo lemi ub inim heneng lem ko nen nao saboklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Wakl kakl, Ngub inj, yu nan bubiyab beyao tomb unu ora bor di saohar hambun bor bu kimb biyao nda ub, Aolon Isi Ora obu di ngub oboklaol hambunom hondoklemi o, ");
INSERT INTO akh_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","su bor baoraoklao sao menjao homo wiyao bor was sao hur mesim di obo kiril mbaroklme ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ngo tomb Njisesom ngub kobur kakl, Ke aondao ora ngo baeben hend paklemi tomb penar bu ora nar nao debur em hundur aondao ora uklaol, ek di nao doklao ora. Saosolbaem ngo saoharol harekle baeben di sul tol hakl ib ib buklaol, saoharol buri wiyao sao baeben di buri nao pale dur kobur demi ora men koroklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ngub kobur kakl, Ngo tomb Aolon Isi Ora obu oboklao on saoharol menger bombor mend buklaol hondobur, su hambun bor tenaol sem hayem baeben hambunom pakl homobur de aondao ora ko haklemi kisesa. Wakl kakl, Ngo ora tomb Aolon Isi Ora obu yu heben mulaol darukl ora bor haklbir obu buri paolaoklbir nar el sao bao bi hakol bi ora oboklaol hondoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ngo tomb biyukel mbel aondao ora luklaol obum obun angal mini wesao baeben su hambun bor pen kobur, yu nan di unu nan di umu nan di ana nan di su uklu lisao hakl hambun bor di, Ngaorom tenaol mbes sablo haen kisao baeben hambun ora obo kiril mbaen lao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ngo tomb Njisesom ngub kobur kakl, Inim is dullub ma biyao nda ub oborob ora nen saboklwaebe. Is baoklaol ib ib bubur ma bu kimb beyao tomb inim ngub lome. Is ma wen beneng ngubi tomb nar eben sene lome kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ngub kobur kakl, Menger bombor ngub mubur inim nim o kao njandisao baeben hambun sao bam bam buklaol hendaem sin, Aolon Isi Ora obu oboklbur teb so ora tiriyao kombael hend dera haril ko nen saboklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Njisesom ngub kobur kakl, Nim ini bor heneng ora kao njurukl, tenaol ngubi tomb hayem baeben nao heme bao haen was nim ini bor ngo buklao kandisao baeben buklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ngub kobur kakl, Su di saohar di mabor hambun sao bum haklao o, nao angal bombor o nao bum hae wi aeben soklao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ngo tomb Njisesom kakl, Ngo sao hora buklao be? somna buklao, ekera be? ndum buklaob ko mondom nao hende ora hayem kisesa. Ngub kobur kakl, Ngaoron angal mini wesao yu heben haeme baebenom di nao hende ora haeme. Aoraon Isim di nao hende ora hayao o, Aorao Ngaor ngo obum bombor o ora hendeyao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Njisesom ngub kobur kakl, Mbes aol Nowa hasao tomb tenaol hambunom bismi ub, Aolon Isi Ora oboklbur buklao tomb di bombor ngo bismi ub was buklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ngub kobur wakl kakl, Mbes se obo ib wae aondao ora ngo ibisao o, nao ib hae wen Nowam ib taokaoll warisao tomb tenaol hambunom ne nao pa ib nao pa was bismi. Ngub bubur aolom di ten taol buklemin was kone wi, tenom di aol poklemin was kone wi bubur, mbinim ngub besao ko u haen was Nowa obun sem ib taokaollon hondaesmi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wakl kakl, Mbinim ngub was ham ham bubur mabor mbini ke hondoklemi on nen nao sabe mbinim ngub besao kon was wismil, mabor ib wae do se aondao ora obobur kisaon, tenaol ngo baeben hambun nao pesao ora kisesa. Njisesom ngub kobur kakl, Bombor ngo bisao ub was mabor Aolon Isi Ora oboklao tomb di, mbinim nao hende besao kon u bao habur mbinim burir biyu ke ngo hindismi ub was hondoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ngub kobur kakl, Ngo tomb aol is kab mend em bor haklebi o, Ngaorom is mende men mubur is mende bao haen waklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wakl kakl, Ten is kab mend di mbibim palawe kongon bi uklebi o, Ngaorom is mende men mubur is mende bao birin waklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Njisesom ngub kobur kakl, Mabor inin Aorao Aondao obu bao ngon oboklao ko nao hende ora hayem ngao, nim ngo kakl ub buklaong oborob ora hondo haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ngub kobur wakl kakl, Inim ngo sao oborob ora nen saboklwaebe. Aol and aorao baebenom bao ngon somna ora paes naoklao aolom paes nokl oboklao ko hondokl bemen, paes naoklao aol ngom mbinin anda bor tiriyao kombo paes ngub nokl eben bao wa nao bi hend ha ora hakl beme kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Wakl kakl, Aolon Isi Ora obu di bao ngon oboklao ko inim nen nao sabe haklemi tomb oboklao ngao, inim di oborob ora man man bu hend ha ora haklwaebe ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ngo tomb Njisesom kakl, Kongon biyao aol mondom obun kone bor oborob ora kimb bubur kongon oborob was ba sin, wakl obun aol aondaom obu bor njem nao kongon bimi aol baeben hambun maeb ha, mbini bor ne di ngo tomb was taol bu kalaebe lao ub taol bu kalo haklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ngub kobur kakl, Mabor kongon biyao aol ngo obun aol aondao nda wakl obobur hondoklao tomb obun kongon biyao aol ndam obum mbes kao kaolaokl pisao nda ub bu harob sin, kongon biyao aol ngo obun mbib turi aondao ora homoklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Njisesom ngub kobur kakl, Nim ini bor heneng ora kao njurukl, aol aondao ngo obum obun hambun sao obun kongon biyao aol ngom was maeb haen lao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Wakl kakl, Ngub buklao o aol aondaon kongon biyao aol ngom khorob bubur obun kone bor nao aol aondao penar bu nao oboklao ko nen sabobur laon, ");
INSERT INTO akh_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","obum obu daol mbini haru kongon bimi aol baeben lu bowes bi habur, obum aol mendbor he soklme ib noklme baeben daol haru ne nao mba he soklme ib nao mba buklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Wakl kakl, Obum ngub buklaol kongon biyao aol ngo obun maomb bo haraoklao aol aondao nda mabor ko mend handam oboklao tomb, obun kongon biyao aol ndam nao maomb bo haraoklao aol aondao oboklao ko nao hondo bara sin, obum ngo tomb ebeyao saol ko nao hende haklao o obum sub obo pindib paklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Wakl kakl, Aol aondao ndam ngub obobur laon obun kongon biyao aol ngo khorob ora ke mao handabur, tenaol mendbor songolol man mini non bubur kakla ko haroklme baeben pen lao bor maomunu pen laol, obum saongao kengerokl no de khorob ora ko haklao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ngo tomb Njisesom angal mar mende di kobur kakl, Yu heben bor maomb bo haraoklao om maeb ha maomb bo hakl oboklao ub menger, nong is tobon kab mondom mend bismisa ub menger maeb ha maomb bo hakl oboklao kisesa. Ngub kobur kakl, Nong menden tuman ke aol aondao mondom, nong ngo penar bu embi was taol bukl oboklwao kisaol, nong tobon kab ndam mbinin laomb di tobon kab ta peb bu maribir mbinin haeki taol bukl bi nda harerol hen mu kaomukl pismisa. ");
INSERT INTO akh_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ngub pismi o nong tobon kab ngo pismi on is su mende kon nao wi sisesa. Is su mende oborob ora kone kimb bi sisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Njisesom ngub kobur kakl, Nong kon nao wi nda baebenom mbinin laomb marismi o, mbinin laombon wel keresin nao mari pismi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Wakl kakl, Ngub bismi o nong is su mende kone oborob kimb bi kon wi nda baebenom, mbinin wel keresin di mberol be bor bomb barabur, mbinin laomb baeben hesa ndi pa peb bu marismi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Njisesom ngub kobur kakl, Nong tobon kab ndam aol mbinin haeki taol bukl bi nda penar bu nao ibisaol nong nda baeben mbinin el bor enjmor ibisaol, u paol pesmi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ngub kobur wakl kakl, Ngub paol pesmi tomb somna undum tuku ora angal mend kisaol pangismil, aol ten taol bukl bi nda ebeng, inim obu kemi ebeklemin ub harerol hen mu kaomukl puklub kisaol pangismi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ngo tomb nong tobon kab ndam teka kaklal sobur, mbinin laomb nda baeben man man bu mao da peb bismi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ngo tomb nong is su mende kon nao wi nda baebenom nong is su mende kone oborob ora kimb bi nda baeben bor kakl, Naon laomb nao de hundileng, inin wel keresin ngon baoklmend nao kowe njib kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ngub kismil nong is su mende kon wi nda baebenom mbinin angal ngon ko san lubur kakl, Inj ka. Naom naon wel keresin ngon mendbor ini kowe njam sin, naon laomb di nao de hundi mba kho sobur, inin di nao hambunon kho soklaong, ngub nao bin ub inim sitowa anda bor wel keresin dob bukl puklub kismi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ngo tomb nong is su kon nao wi awis nda baeben sitowa anda bor wel keresin dob bukl pismi tomb, aol ten taol bukl bisao nda obo pindib paesesa. Ngub ibisaol nong is su mende mbinin wel keresin di maru burubur laomb mao da man man bu birismi nda baeben, aol aondao ngo ten taol bukl ibisao nda daol mbini haru and ngo ten taol bukl ibisaol ne haorismi anda on hondaesmil, aol aondao ngo ten taol bukl ibisao ndam tiriyao bo tu ndaesesa. ");
INSERT INTO akh_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ngo tomb mabor nong is su mende kon nao wi, wel keresin dob bukl pismi nda baeben obo tiriyaol lu nga nga ko habur kakl, Aol aondao o, aol aondao ka. Nao obomun ub tiriyao komb kismi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ngub kismil aol ten taol bukl ibisao ndam mbinin angal ngon ko san lubur kakl, Nim heneng ora kakl, nim ini nao hendeyo ora kisao ko Njisesom angal mar ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Njisesom ngub kobur kakl, Aol aondao ngom ngub kisaong, Aolon Isi Oran hora oboklao be? somna oboklao be? atomb oboklaob ko inim nao hende ora hayem ngao, inim oborob ora hondo haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ngo tomb Njisesom angal mar bombor ngubi mende di kobur kakl, Aol aondao mondom obu su tangar mendbor poklbur kisaon, obun kongon bimi aol baeben kor bu ubuklub kobur obun osisao wisao baeben inim was maeb haklwaebe ko kaolaokl pisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Njisesom ngub kobur kakl, Aol aondao ndam obun kongon bimi aol ngo baebenon kone hondo, mbinin buri wiyao ub mbinin kone armend sisao u haklemi ub hondoklbur kisaon, obun kongon bimi aol ngo baeben bor mone ngom bisnis bu haklwaebe ko taol bakabur, obun kongon biyao aol is mend oran mone so 1,000 was ber pae pao su kalisesa. Ngub bubur kisaon obun kongon biyao aol is mende mone so 1,000 was ber pae pao kab oran kalisesa. Ngo tomb obun kongon biyao aol is tebo nan di mone so 1,000 was ber pae pao bombor oran kalisaol, mbini hambun bor bisnis bu haklwaebe ko ngub kalisesa. Obum ngub taol bu kal peb bibir kisaon, obu su tangar bor paokl ora pisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ngo tomb aol is mend obu mone so andub ber pae pao su misao ndam penar bu bisnis bisao tomb mone so 1,000 was ber pae pao su mende pon paen misao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ngo tomb aol is mende obu mone so andub ngub baeben was ber pae pao kab misao ndam di 1,000 was ber pae pao kab mende pon paen misesa. ");
INSERT INTO akh_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ngo tomb is kab ngom ngub bisbi o aol is mend obu mone so 1,000 ber pae pao bombor misao ndam obun aol aondaon mone ngo mu bowes buklwao ko nen sabobur kisaon, men pae po obum su tomb pabur su bor sowaol bu mbaesesa. ");
INSERT INTO akh_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ngo tomb aol aondao ndam bao ham ham bubur kisaon, ma ora bor obun kongon bimi aol ngo baeben bor obun mone ngo bisnis bu haklwaebe kaokl pisao on, mbinim asub was bu haroklmeb ko angal kao kao bem koklbur wakl ibisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ngo tomb aol is mend obu mone so 1,000 was ber pae pao su misao ndm, wakl mone so 1,000 was ber pae pao su mende pon paen misao nda baeben mini obobur kakl, Aol aondao o hend. Njem mone so 1,000 was ber pae pao su mend njaokl pisndisom bisnis buwao tomb nim mone so 1,000 was ber pae pao su mende ngo pon paen muwe o kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ngo tomb aol aondao ndam obun kongon biyao aol ngo bor kakl, Nje kongon biyao aol ebe ora hael, njem njen kongon oborob ora hondobur bisi kisao kisesa. Obum ngub kobur obun kongon biyao aol ngo bor wakl kakl, Njem kang sao ngo oborob ora maeb harili ub njem nao andub sao maeb hanin lowaong, njem yao turi hom hom babon ib kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ngo tomb aol is mende mone so 1,000 was ber pae pao kab misao ndam di obobur kakl, Aol aondao o hend. Njem ni mone so 1,000 ber pae kab kab pao kab mend njaokl pisndisom bisnis buwao tomb nim mone so 1,000 ber pae kab kab pao kab mende ngo pon paen muwe o kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ngub kisaol obun aol aondao ndam obu bor kakl, Nje kongon biyao aol ebe ora hael, njem njen kongon oborob ora hondobur bisi kisao kisesa. Obum ngub kobur obun kongon biyao aol ngo bor wakl kakl, Njem kang sao ngo oborob ora maeb harili ub njem nao andub sao maeb hanin lowaong, njem yao turi hom hom babon ib kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ngo tomb aol is tebo nan obum mbes mone so 1,000 ber pae pao bombor misao nda obu di obobur kakl, Aol aondao o nim nje ora hendeyo nda ka. Nje aol buri ora habur, njem aol menden em bor mbinin mbib we boweme hakl di njem kobale nda. Njem aol tangar mendborom mbinin is il we boweme hakl di njem talale nda kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ngub kobur kakl, Njem ngub bili ndal nim nje pakl homobur, njen mone so 1,000 ber pae pao bombor mend njisndis su tombobur abo ngo sowaol bu haruklu e ong, njen ngo sao mi kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ngub kisaol aol aondao ndam obun angal ngon ko san lubur kakl, Nje makl hom ha was habur nje kongon biyao aol kho ora hael kisesa. Ngub kobur kakl, Heneng ora nim aol tangarom mbinin emol we boweme sao hakl kobo, nim aol tangarom is il we boweme hakl di il seyao tomb nim talo ngub biyul hondobur njem ni pakl homale sin, ");
INSERT INTO akh_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","nao mone ngo mendbor kond baen pone haen mun, mbeng bor asub ko nao wisil nim wakl obobur nao mone homaokl hae kang ngo was wakl murukl balem? kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ngo tomb aol aondao ndam ngub kobur aol mendbor ngol hasmi baeben bor kakl, Inim mone so 1,000 ber pae homaokl bi bao mend abo ngo bao u harekle o mubur, aol is mende mone so 1,000 was ber pae pao tobon kab u harekle aol ngo was mu kalaoklaob kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ngo tomb aol aondao ndam mbini bor kakl, Nim ngo bi o tenaol hambunon mondom menjao u harob sin, nim wakl tangar di kond bu kaloklwaol obun andub ora uklao. Ngub inj, mondom menjao nao wi harob sin, obum kang mend u buruklao o di nim wakl muklwao ora kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ngo tomb aol aondao ndam ngub kobur kakl, Inim kongon biyao aol kho abo ngo isu dera nan em hundur wi tenaol mendbor saongao kengerokl no, de khorob ora ko haroklme su ngo bor pen laob kisao ko Njisesom angal mar ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ngo tomb Njisesom ngub kobur kakl, Mabor Aolon Isi Ora obu bao bi hakol bi ora, obun angal mini wesao baeben daol haru oboklemi kisesa. Wakl kakl, Ngo oboklemi tomb Aolon Isi Ora obu aol wesmbao aondao ora habur, obun maomb bo haraoklao on seyal buruklaol tenaol su hambun bor paoloklme baeben hambun ora obu buruklaol obun el sol was obo kiril mbaen lao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ngub obo kiril mbaklemi tomb some sib maeb haroklme aolom some sib hesa meme kab taol bu kobaroklme nda ub tomb kab bu taol bu kobabur, some sib baeben di maon nan haen kao, meme baeben di sabol pabur armend haen kao buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Wakl kakl, Obum ngub bubur laon some sib baeben obun ki tao nan haen kobur, meme baeben ki kowes nan haen lao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Njisesom ngub kobur kakl, Aol Wesmbao Aondao ndam ngub bubur laon, tenaol obun ki tao nan haklemi nda baeben bor kakl, Nao Abom inim turi homeklemin ko obum mbes pibnao ora su wen warisao tomb, nao Abom ini maomb bo haklbur obum maeb ha maomb bo haraoklao ub inin ora man man bu pa wakaesaong, ngo man man bu wakaesao bor hakl ubuklub lao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ngo tomb Aol Wesmbao Aondao ndam ngub kobur kakl, Mbes ni dem homo uwao tomb inim ni ne non njisimndis. Ni ib nokl homowao tomb inim ni ib di non humu njisimndis. Ni aol sem tangar ora hawao o ni inin anda bor paolemin ib ko u paolisumndis. ");
INSERT INTO akh_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ni lab lab nao wi hawao tomb inim ni lab lab di njisimndis. Ni sen ha homo uwao tomb di inim ni bisur bu maeb hasimndis. Ni kalabus paoluwao tomb di inim ni hondokl ibisimndis ol, nim ini ebel mao harukl lao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ngub lao tomb tenaol kone ebe wi ngo ki tao nan haklemi baebenom obun angal ngon ngub ko san luklemi. Aorao Aondao o, naom nje al dem homo wisil hondobur ne nenin njisim bo? Naom nje ib di al was nokl himisil hondobur ib nenin humu njismao? ");
INSERT INTO akh_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nje aol sem tangar non bi atomb hasil hondobur nje naon anda bor paolemin ib kismao? Naom nje lab lab nao wi al was hasil hondobur naom nje lab lab njisum bo? ");
INSERT INTO akh_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Naom nje atomb sen ha u kalabus di paolisil hondobur naom nje hondokl ibisum bo? lemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ngub lemi tomb Aol Wesmbao Aondao ndam mbinin angal ngon ko san ngub luklao. Nim ini bor heneng ora kao njurukl, ninao sem imbi nao wi kang ngo hayem baebenon kang is bombor ora di, inim mbini bisur bu menjao menjao kalismi ub inim ni bor ora bismi lao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ngo tomb Aol Wesmbao Aondao ndam obun ki kowes nan haklemi baeben bor ngub lao. Ini tenaol mendbor haeben sakl puklmi bor nao pe ke hondoklbur hayem hakl o, ini ni hae ol nao hae isu isaolao nao hundili dao hakol bi ngo bor puklub ora. Isaolao dao hakol bi ngo mbes nao Abom Seran hesa Seran obun angal mini wesao baeben kabon man man bu win kaesao ora lao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Njisesom wakl kakl, Aol Wesmbao Aondao ndam ngub kobur laon tenaol ngo ke hondoklemi baeben bor kakl, Mbes ni dem homo uwao tomb inim ni ne nao njisimndis. Nim ib nokl homowao tomb inim ni ib non nao humu njisimndis. ");
INSERT INTO akh_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ni aol sem tangar hawao tomb di, ni inin anda bor paolemin ib nao kisimndis. Ni lab lab nao wi hawao tomb di, inim ni lab lab mend samon nao njisimndis ka. Ni sen ha u kalabus paoluwao tomb di, inim ni bisur bu nao hondokl ibisimndis lao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ngo tomb tenaol ngo ke hondoklemi baebenom Aol Wesmbao Aondaon angal ngon ko san ngub luklemi. Aorao Aondao o, nje atomb was dem homo wisil hondobur naom nje ne nao njisum bo? Naom nje ib di atomb was nokl homo weninbur nao humu njismao? lemi. Mbinim ngub kobur wakl kakl, Njem aol sem tangar non bi ha, lab lab nao wi ha, nje sen ha u, kalabus paolu ngo hakl atomb was bisi o naom nje hondobur nje bor oborob sao nao bismaob? lemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ngub lemi tomb Aol Wesmbao Aondao ndam mbinin angal ngon ngub ko san luklao. Nim ini bor heneng ora kao njurukl, inim tenaol mendbor imbi nao wi kang ora hasmi baebenon kang is bombor ora di bisur bu oborob sao nao bisimndis tomb, inim ngo sao baeben hambun sao ni bor ora bisimndis lao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Obum ngub kobur laon inim ngub bisming, ini ke hondoklme su bor puklub laol, ngo bor tanda aondao ora nao hakol bu haklemi ora. Ngub buklemi o tenaol mendbor kone ebe ora ubur oborob was bu haroklme baeben haeben saroklme su bor puklub laol, mbinim ngo bor pobur ko mend nao heme haeben ora soklemi ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ngo tomb Njisesom obun angal hambun kao pabur kisaon, obun man pange aol baeben bor kakl, ");
INSERT INTO akh_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Inim di ora hendeyem ub Waran Aeben Bisao hor so pindib paklao o bao hor kab ora bao wi ol, mbinim Aolon Isi Ora men pae poklemil is pe kowal bil nil li mbaklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ngo tomb Nju semon baolum aol aondao baeben di, mbinin maomb bo haroklme aol, aol kon wi baeben di mbini hambun ora baolum aol wesmbao aondao mend obun imbi Kayapason anda bor was obo kiril mbaesmisa. ");
INSERT INTO akh_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ngo tomb mbinim ngub obo kiril mba burubur kismin kar mba habur kakl, Naom asub ora bubur Njises oran kakla kao beya di, men habur pe paen lem yeb ko kar mba hasmisa. ");
INSERT INTO akh_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ngo tomb mbinim ngub kar mba habur kakl, Ngub bemin ora o, naom tenaol hambun kiril mba hor so boroklme ngon non ngub nao bemin ora. Naom ngo tomb Njises men harum sin, tenaol hambunom sob aondao bu ora lemi kismisa. ");
INSERT INTO akh_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ngo tomb Njises obu su Betani bor habur aol maollun bi mend obun imbi Simonon anda bor hasesa. ");
INSERT INTO akh_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ngo tomb ten mondom han alpastam* wari be ebe teraebi buri ora mend sisao bor, wel sem tangar kao ebe ora pebe mend mbinim mone andub ora deng ko mu hasmil, ten ndam wel be ngo sao bor bomb hae mend mini obobur, Njises obu ne noklbur birisaol Njiseson wesmbao bor kowe beyaesesa. ");
INSERT INTO akh_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ngo tomb Njiseson man pange aol baebenom ten ndam ngo bisao sao hondobur makl aondao ora homobur mbini hakl hakl kakl, Ten ngom wel hobao sao ngo asub ko mu bowes bi bo? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mbinim ngub kobur kakl, Ten ngom wel kao ebe ora pebe ngo kowe bowes bi ub nao bukl baonaon, obum tenaol tangarom wel ngo dob bin mone aondao bu ora mubur, obum tenaol mendbor menjao nao wi burubur dam nao bin bereyem baeben taol bu kalokl baonao kismisa. ");
INSERT INTO akh_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ngo tomb mbinim ngo kismi ub Njisesom mbinin kone bor hondobur mbini bor kakl, Ten ngom ni bor oborob ora bing, inim asub ko ten ngo obun kone bor kend mao ba kho mao sareklem? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Njisesom ngub kobur kakl, Inim tenaol mendbor menjao nao wi burubur dam nao bin boroklme baeben hesa non ini daol hor hor was haklemi o, ni non ini daol nao hor hor bao ha kimb was nao buklmao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ngub kobur kakl, Ten ngom nao toklol wel ebe ngo kowe beyaraokl o, mabor mbinim ni pe pan luklemil nao maol bor ni tangaklbur man man buklemi ub ngo bi o kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Njisesom ngub kobur kakl, Nim ini bor heneng ora kao njurukl, nim bu haruklu sao baeben hesa mbinim ni bor buklemi sao baeben kabon arman Angal Bib Hobao Sao ngo tenaol hambunom pangen su hambun bor kam akol buklemi darukl o bor, ten ngom ngo bi ub di haru kam akol buklemil ngo sao di tenaol hambunom nen saboklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ngo tomb Njiseson man pange aol baebenon duteb nan o Iskeriyaor Njuras, obum Nju semon baolum aol aondao baeben birismil pobur ");
INSERT INTO akh_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","obum mbini bor kakl, Nim inim aol Njises ke ngo men pae puklub ka sin, inim ni asao ora njuklemib? kisesa. Ngub kisaol mbinim obu mone il han silba was ware pe, hond du bellengpun kab oran kalismisa. ");
INSERT INTO akh_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ngub kalismil ngo ora tomb Njuras obum Njises men pae puklub lao on, bao awon ora men pae puklub lowao saol ko kone kimb bu birisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ngo tomb Nju semon palawe and mao saraoklao sao yis nao haru noklme bao o pindi paesaol, Njiseson man pange aol baebenom obu birisaol obobur kakl, Naom Waran Aeben Bisao bao on ne nemin ko njem abor ora man man baomun ko nen sobal? kismisa. ");
INSERT INTO akh_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ngub kismil Njisesom mbini bor kakl, And lobokl lobokl ora bor pobur aol mend ngol buruklao bor ngub lowaebe. Aol aondaom nim su ngo tuwaklwao o teb sal, nao man pange aol baeben daol haru njen anda bor Waran Aeben Bisao bao on ne noklmao ka lowaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ngo tomb Njiseson man pange aol nda baebenom obum kisao nda ub was bubur kismin, mbinim Waran Aeben Bisao hor son ne noklemi on man man bismisa. ");
INSERT INTO akh_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ngo tomb mabor somna Njises obun man pange aol duteb nda baeben di ne nao mba hasmi tomb ");
INSERT INTO akh_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Njisesom obun man pange aol ngo baeben bor kakl, Nim ini bor heneng ora kao njurukl, ini ngo bereyem haklon is bombor ora mondom ni karu luklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ngub kisaol obun man pange aol ngo baebenom aem ngub buklao bor leb ko nen sabobur kismin, mbinin kone bor kho so hem aondao ora kobur mbinim armend sisao Njises bor ne mi mi bubur kakl, Aorao Aondao o ni bor kal be? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Aol enjo ngo yao bomborol buburbur ndis bor ne ngo mib bu nakl wi om ni karu luklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Njisesom wakl kakl, Heneng ora Aolon Isi Ora obu non Ngaoron mbuk waebom ngub buklao ke wiyao ub mbinim obu heneng ora luklemil, obu harer ngon poklao ke wiyao on poklao o, aol ngo obu Aolon Isi Ora karu luklao aol o ke aondao bu ora hondoklaong, obun amom aol ngo obu hel nao marukl bisaon, ebe ora sokl bisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ngo tomb aol Njuras ke ngo Njises karu lisao ndam, Njiseson angal ngon ko san lubur kakl, Aol aondao o, njem ngo kal o ni bor kal be? kisaol, Njisesom obu bor kakl, Njen mbib ngo kal o kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ngo tomb mbini hambun ne ngub nao mba hasmil Njisesom palawe mend mubur kisaon, obum Ngaor bor mbes tengiyu kao pesao tomb obum munu konde barabur obun man pange aol nda baeben taol bu kalobur kakl, Palawe ngo nao toklo njurukl ngao, naoklaob kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ngo tomb Njisesom wakl ib waen ber pae kab mend mubur obum Ngaor bor tengiyu kao peyobur, kab ib waen ber pae ngo obun man pange aol baeben bor ini hambun no kalam aeben aeben bib ko kalisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ngub kalobur kakl, Nim ini ngo njurukl o nao ibao ora njurukl ol, Ngaorom nim tenaol hambun heneng ora bu muklwao kisao ub nao ibao ngom tenaol hambunom khorob bismi sao mbinin kone bor wiyao o kunaklbur peben karukl kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ngub kobur kakl, Nim ini bor heneng ora kao njurukl, naom waen il ibao ib ngo naoklaom on nim ko mende nao ne bao han was, mabor ini di haru nao Abom maeb ha maomb bo hayao bor ib waen wen pange oran ko mende noklmao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ngo tomb mbinim we ukl mend kaoya kao peyaoklbir kismin, dera bonge dera peb bibir har Olib manda bor yin pismisa. ");
INSERT INTO akh_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ngo tomb Njisesom obun man pange aol baeben bor kakl, Ngaoron mbuk waebom ngub ke wiyao. Nim some sib maeb haraoklao aol pe paen luklwaol some sib baeben pakl buri lemi ke wiyao ub embi somna il so pindib paklaol, mbinim ni bor buklemi sao haondaoklbir ini hambunom nil hul ha haroklme nda ub tuwaklbir pakl buri lemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ngub kobur kakl, Mbinim ni ngub pe pan luklemi o ni wakl mao enjaklaol, ni mbes su Kalili poklwaol ini nao mama oboklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ngo tomb Pitam obun angal ngon ko san lubur kakl, Mbini hambunom njel hul ha haroklme ub tuwakl paem sin, nim bombor o nje nao tuwae njel hul ha, ha kimb was buklwao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ngub kisaol Njisesom Pita bor kakl, Nim nje bor heneng ora kao njurukl, bao somna ngon sao kulao angal nao bi haen was njem ko teb oran nim Njises nao hendeyo lesi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ngub kisaol Pitam Njises bor wakl kakl, Ni di yao haru ora homabon ko hael, nim nje nao hendeyo nao lowao ora kisesa. Ngo tomb Njiseson man pange aol ngo birismi nda baeben hambunom di ngub was kismisa. ");
INSERT INTO akh_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ngo tomb Njises obu obun man pange aol baeben di haru su em obal menden imbi Kersemani bor pismisa. Ngub pobur Njisesom obun man pange aol baeben bor kakl, Ni kang mend isu ngol sao Ngaor bor kao kalokl pukl ngao, ini ngol bao ber mba haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ngo tomb obum Pita di Seberin isi kab Njemus Njon kab di, is teb ngo haru pismisa. Ngo tomb Njises obun kone bor ke di kab po kend aondao ora bin birisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ngo tomb Njisesom obun man pange aol is teb nda bor kakl, Nao kone bor ke di kab po kend aondao ora bubur ni pe pae non bi saol ngao, inim ngol ngub habur ni di naom oborb ora hend ha haemin kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ngo tomb Njises obu kang mend aeben sao pobur kisaon, obun el wil unu su nan haen dombes ubur Ngaor bor kao kalobur kakl, Ab o njem ebe soklao ko pangal sin, njem ni ke hondoklwao ib karae bi ber pae kab ngo mu tuwaebe ora kisesa. Wakl kakl, Njem ngub mu tuwaebe o njem nim nen sobakl ub inj bibi ora. Ngub inj, njen mbib nen sabele ub ora bibi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ngo tomb Njises obu obun man pange aol is teb nda birismil pobur hindisaol, mbinim enjmor kobur u paol pesmisa. Ngub bismil Njisesom Pita bor kakl, Inim asub was bim? Inim ni daol nao haru kang el bombor ora mend hend peb bu haem nao lemi be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Njisesom ngub kobur obun man pange aol is teb ngo bor wakl kakl, Inin kone bor non nim oborob was buklwao ko nen saboklemi o songolom bi lao ub ini saokl mao waraklaong, ini bor khorob mao bakl buklao saom ini khorob nao mao baen ub inim oborob hend ha habur Ngaor bor kao kalaoklaob kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ngo tomb Njisesom pibnao Ngaor bor kao kalisao nda bor wakl ko mende pobur obum Ngaor bor kao kalobur kakl, Ab o, nim ke hondoklwao ib karae bi ber pae kab ngo noklwao ub nao non ko mu tuwakl buwaeb se soklaol, njem ni bao ke hondon ko nen sobal sin, ebe ka. Njen kone oram nen saboklesi ub was bibi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ngub kao kal peyaoklbir wakl obun man pange aol nda baeben birismil obo hindisaol, mbinin el bor enjmor aondao ora ibisaol mbinim u paol pe wismisa. ");
INSERT INTO akh_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ngo tomb Njisesom ngub haondaoklbir kisaon, mbini ngub bao paolu win wakl Ngaor bor ko tebo kao kalokl pisesa. Obum Ngaor bor ngo kao kalisao o pibnao kao kalisao nda ub was wakl kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ngo tomb ngub kao kal peyaokl obobur obun man pange aol nda baeben bor kakl, Inim ngo bor hor so burukl obaemil u was bao paol pe wiyem be? Pangeklem. Mondom Aolon Isi Ora obu karu lubur khorob bimi aol baeben bor obu men pae puklub ko kaloklao o mbes teb se kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ngub kobur kakl, Nao paokl mbin ub ini tekaklaob kisesa. Wakl kakl, Aol ni luklbur karaonao aol o mbes isu ngo ebe bor kang haondaoklaob kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ngo tomb Njisesom obun man pange aol baeben bor angal ngub bao kao kalakl haen was, Njuras obu man pange aol duteb nan o obu sisao o, aol aondao andub ora ngo ibismi nda darukl o bor obu di haru ibismil hindismi tomb, aol aondao ngo ibismi nda baebenom kuwi kuwinj di kam dorokl hakl taokl taokl bombokl ibismil hindismisa. Ngub ibismi o ngo ibismi baeben Nju semon baolum aol aondao baeben di, mbinin maomb bo haroklme aol, aol kon wi baeben di ngo baebenom Njises men hakl puklub kismil ibismisa. ");
INSERT INTO akh_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ngo tomb aol Njuras ngo Njises karu lisao ndam wen aebenol ibismi tomb aol aondao ngo Njises men hakl ibismi nda baeben bor kakl, Nim aol mend men habur nunu ka sin aol ngo obu Njises ora soklaong, inim obu men haklwaebe ko karu mao kikil baesaol paongaokl ibismisa. ");
INSERT INTO akh_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ngo tomb Njurasom buklwao kisao nda ub obum Njises birisaol penar bu ora obobur kakl, Aol aondao o nje ebe soklaong as ko haebe kobur kisaon, obum Njises nunu kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ngub bisaol hondobur Njisesom obu bor kakl, Aol sango o njem bukl obae sao penar bu ora bi ka kisesa. Ngo tomb Njises obu men haklbur ibismi nda baebenom obu birisaol teb so obobur mbinim obu men hasmisa. ");
INSERT INTO akh_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ngo tomb aol is mend Njises obu daol haru hasmi on mondom obun kuwi kuwinj mend hak bor marisao o mubur, obum Nju semon baolum aol aondao oran kongon biyao aol mend sisao on hal taokl bo kobaesesa. ");
INSERT INTO akh_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ngub bisao o Njisesom aol ngo Nju semon baolum aol wesmbao aondao oran kongon biyao aol o lisao nda bor kakl, aol mendborom kuwi naol beme tomb mbini di kuwim nao pa woroklaong, njen kuwi kuwinj ngo njen hak bor marae ub wakl mar kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ngub kobur kakl, Njem aol ngo liril o njem te oborob nen nao sabebur sakl bil, nim saond bukl ko nen sabokl buwaon nim nao Ab kao kalokl buwaol, obum penar bu ora obun angal mini wesao andub ora ami sem duteb kang ngo men mbaeb se ora eben kokl baonao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Njisesom wakl kakl, Ngub bukl buwao o mbes Ngaoron mbuk waebom ngub buklao ke wisao ub wakl asub bubur il soklaob? kisesa. Wakl kakl, Mbuk waebom ngo sao ngub buklao ke wisao ub ora ngo be o kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ngub kobur bombor ngo tomb was Njisesom aol aondao ngo obu men hakl ibismi nda baeben bor kakl, Inim kuwi kam dorokl mini mini obobur inim aol menden osisao taol pe mu haraoklao aol mend men haklbur sao ubuklim be? kisesa. Ngub kobur wakl kakl, Nim hor hambunon Ngaor Hen Moroklme Anda bor honda ha was burubur tenaol hambun pangen Ngaoron angal kao dund bu haruklu nda tomb inim ni nao men haroklme nda kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ngub kobur kakl, Ngub bimi nda o ngubi tomb non, mbes Ngaoron man mini aolom ngub buklao ko mbuk waeb bu wismi o ngo il so pind bile ol sakl, embin hambun sao ngo beyem o kisesa. Ngo tomb Njiseson man pange aol nda baeben hambun Njises ngub bismil haondaoklbir pakl paokl pismisa. ");
INSERT INTO akh_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ngo tomb aol aondao ngo Njises men hakl ibismi nda baebenom Njises obu Nju semon baolum aol wesmbao aondao ora mend obun imbi Kayapason anda mini pismil, Nju semon man buwaloklme aol baeben di, mbinin maomb bo haroklme aol, aol kon wi baeben di ngo baeben hambun baolum aol wesmbao ngon anda bor was ber mba hasmisa. ");
INSERT INTO akh_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ngo tomb Pita obu mbinim Njises mini pismi bor mama taol mi pisao o, obu wen kang mend enderael sao pisesa. Ngub pobur kisaon obum baolum aol wesmbao aondao ngon anda saond paeb mbuklu tundae ngo oral po pindib paesesa. Ngub bubur kisaon obum paeb ndaon hondabur, mbinim Njises bor asub was bu mae lereklem ko hondoklbur polisman baeben birismi bor obu di haru birismisa. ");
INSERT INTO akh_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ngo tomb Nju semon baolum aol aondao baeben di mbinin kansol baeben di mbini hambunom, Njises obum bu hasao sao baebenon obu te mao sara obu pe paen lib se oran, aol aem ora Njisesom ngo sao ngo sao bisao ko oborob ora kakla kao beyaraokl ko es bu ne mam akol bismisa. ");
INSERT INTO akh_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ngub bismi tomb aol andub ora obobur Njises obum ngo sao ngo sao bisao ko mbini kao kalismi o, mondom te Njises obu pe paen lib se oran mend nao mao bemberaesmil, ma ora bor aol is kab ora mend ibisbisa. ");
INSERT INTO akh_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ngub obobur kisbin mbibim Njises bor kakla kao beyabur kakl, Aol ngom Ngaor Hen Moroklme Anda ngo kundi mbabur lowaon, nim bao hor teb oran bao burubur wakl ebe wen pange mend buklwao kisaol pangisbao kisbisa. ");
INSERT INTO akh_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ngo tomb Nju semon baolum aol wesmbao aondao ndam teka habur Njises bor kakl, Njem angal ngon ukl mend ko san nao luklesi be? Mbibim nje bor ngo te mao sararekleb ub asub buklbur bib ko pangal? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ngub kisao o Njises obum e beb nao kisaol, baolum aol wesmbao aondao ndam Njises bor wakl kakl, Nim nje bor heneng ora Ngaor aondao yubu haeben saraoklaon imbi bor ne murukl ngao, nje Ngaoron Isi Eben Ke Aol ora hael be? inj, njem nao kao nji kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ngub kisaol Njisesom obu bor kakl, Njem ngo kal ub ni ora hae o, nim ini bor heneng ora kao njurukl, inim ngubi tomb non Aolon Isi Ora obu hambun sao buri palo bu haraoklao Ngaor aondao oran ki tao nan buruklaol hondoklemi ora. Mabor di obum yu heben mulaol darukl ora bor haklbir oboklaol hondoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ngo tomb Njisesom ngub kisaol, baolum aol wesmbao aondao ndam ko aondao ora homobur, obun lab lab samisao on kang mend munu kaoll kobabur kakl, Aol ngo obum Ngaoron mangal bu hel hondo angal ngo be o ka. Naom di obum khorob was ko haraoklao ub ngo le ol ora haondaoklaom ngao, naom aol tangar mend aol ngo obum khorob bu haraoklao ub njem hendeleb ko, ko mend ne nao mem ora. Ngub inj, obum Ngaor bor maobowa angal baonao ub inim ngubi tomb ngo pangeklem ong, ");
INSERT INTO akh_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","inim asub ora nen sabeyem? kisesa. Ngub kisaol mbinim obun angal ngon ko san lubur kakl, Obum angal khorob aondao bu ora ngo le ol pangaoklaom tomb obum homokl san ora ngo be o kismisa. ");
INSERT INTO akh_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ngo tomb mbinim ngub kobur kismin, Njiseson el wil bor ne maeke tokl beyabur khorob ora lu bowes bismisa. Ngo tomb mendborom di obun el wil bor ki hobaom lubur ");
INSERT INTO akh_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","mbinim obu maobowabur kakl, Ngaorom Eben Ke Aol o, nje aebom was leyem? Njem mao bembera handale nda ub hend kismisa. ");
INSERT INTO akh_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ngo tomb Pita obu andaon nao biri deral birisao o, obu baolum aol wesmbao aondao ndan anda saond paeb mbuklu tundae bor birisesa. Ngub birisaol kongon biyao nong is mend Pita obu birisaol teb so obobur kakl, Nje di Kalili aol Njises hesa haru haroklbe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ngub kisao o Pitam tenaol hambunom di pangen inj ora kobur kakl, Njem ngo kal o ni nao hende ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ngo tomb Pita obu kang mend dera pobur paeb tiriyao kombae dera nan bao hasaol, kongon biyao nong is mendem di Pita hondobur tenaol ngo Pita obu hasaol teb so hasmi baeben bor kakl, Aol ngo hae o obu di Nasarer Njises obu kab haru haroklbe o hae kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ngub kisaol Pitam ko mende di kowes bu mao kobur kakl, Nim aol ngo obu nao hendeyo ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ngo tomb kang mend mabor sao aol mendbor Pita obu hasaol teb so hasmi baebenom obobur mbinim Pita obu bor kakl, Heneng ora njen angal abo kal ol panaem ora saol ngao, nje Njises obun sem ora hael kismisa. ");
INSERT INTO akh_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ngub kismil Pitam mao ko angal buriyab ora kobur kakl, Nim aol ngo nao hendeyo ora. Nim kakla ka sin Ngaorom ni ke mao handaklao ora kisesa. Ngo tomb Pitam ngub kao peyakl birinbur oran sao kulao angal bao bisesa. ");
INSERT INTO akh_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ngo tomb Njisesom Pita obu bor njem sao kulao angal nao bi haenbur ko teb oran njem ni nao hendeyo lesi kisao nda mao takl bisaol, Pita obum dera pobur kisaon hibi kho so de aondao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ngo tomb bao bisaol hokloben Nju semon baolum aol aondao baeben di, mbinin maomb bo haroklme aol, aol kon wi baeben di mbini hambunom Njises pe paen luklemi on oborob ora kar paesmisa. ");
INSERT INTO akh_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ngo tomb mbinim ngub kar pabur kismin, mbinim Njiseson ki kab yam tanga pa men pae pobur mbinin kabman maomb bo haraoklao aol aondao Paler kalismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ngo tomb aol Njuras obu Njises karu lisao aol ndam mbinim Njises pe paen lin ko te mao sara howes aondao bu ora kismil hondobur, obun kone wakl u bokeyo hem kobur kisaon, obum Nju semon baolum aol baeben hesa mbinin maomb bo haroklme aol, aol kon wi baeben kabon mone il han silba hond du bellengpun kab nda mbinin wakl kalokl mini pisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ngub mini pobur obum mbini bor kakl, Aol ngo obum menjao nao binbur o nim ora khorob buwe sal, mabor obu pe paklao ye alem kisesa. Ngub kisaol mbinim obu bor kakl, Ngo sao naom inj, njen mbib ora bisi kismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ngub kismil Njurasom obun kone bor ko so hem aondao ora kobur, mone il nda baeben Ngaor Hen Moroklme Anda andaon koloklo tu ndaklbir obum obun mbib obun mal hend ha pabur, is ma bor indi mbabur kisaon obun ma pe kobabur pe paesesa. ");
INSERT INTO akh_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ngo tomb Nju semon baolum aol aondao baebenom mone il ngo Ngaor Hen Moroklme Anda bor koloklo tu ndakl pisao nda mubur mbini hakl hakl kakl, Mone ngo aol pe paen lukl bi menden paoraolao is bi sandang, naon manom ke wiyao nda ub naom mone ngo Ngaor bor kale mone wi o hesa maomunu nao wemin kismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ngo tomb mbinim mone ngom ngub bem ko kao pabur kismin, kab peler waoraoklao aol is menden su mend wisao o, tenaol mendbor tiyao obo haklemi baeben homoklemi o maol bukl bi dob bubur win kismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ngo tomb mbinim ngub dob bu wismil, su ngon imbi Sul Ibao Wi ko karu wismil su ngon imbi ngub was bao wisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ngo tomb ngo bismi sao mbes Ngaoron man mini aol Njeremayam mbuk waeb bu wisao ub heneng ora ngo ora tomb il so pind bisesa. Obum kakl, Su Isreyel tenaol mendborom aol ngo obun mone sokl ngub baeben kalemin ko kao paesmi ub mbinim mone il han silba hond du bellengpun kab oran ndi men paesmi o, ");
INSERT INTO akh_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Aorao Aondaom ni kao njisao ub mbinim mone ngom kab peler waraoklao aol is menden su mend dob bismi ke wisao o, ngo ora tomb il so pind bisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ngo tomb mbinim Njises obu bor howes koklbur mbinin kabman maomb bo haraoklao aol aondao Paleron el sol teka haen kismil, aol Palerom Njises bor ne mubur kakl, Nje Nju semon aol wesmbao aondao ora harili be? kisesa. Ngub kisaol Njisesom obun angal ngon ko san lubur kakl, Njem ngo kal o kisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ngo tomb Nju semon baolum aol aondao baeben hesa mbinin aol kon wi ngo baeben kabom di Njises obu bor kakla kao beya te mao sarabur, obum ngo sao ngo sao bisaol hindismao ko howes andub ora kismi o, Njises obum angal ngo haklon ukl mend ko san nao lisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ngub bisaol hondobur maomb bo haraoklao aol Palerom Njises bor kakl, Mbinim nje bor te mao sara howes andub ora ngo keyem o nao pangal be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Palerom ngub kisao tomb di obum angal ngo kisao haklon ukl mend ko san nao lisaol, maomb bo haraoklao Palerom baehaemen ora inj e kobur burir biyu nimil nimil tu wisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ngo tomb karasmas hambunon Nju semon Waran Aeben Bisao bao o pindi pa was bisao tomb, Nju sem ngo baebenom mbinin kabman maomb bo haraoklao aol Paler bor njem naon sem kalabus bisi on is mend ngo ora eben kaebe ko, mbinin mbib bember ha imbi kao hasmi o mbinim ngo kismi ub Palerom is mend anda pen kao was bisao bao on sisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ngo tomb Nju sem ngo haklon aol is mend obun imbi Barabas, obum khorob aondao ora bisao ub tenaol hambunom di hindismil, Palerom kalabus mao paolaesao o obu ngo tomb di kalabus bao paolinbur sisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ngo tomb Nju sem tenaol hambun ora obo kiril mbaesmil Palerom mbini bor kakl, Nim inin sem kalabus paoleyem baebenon inim aol aeb ora kalabus wakl hesbeyon ko nen sabeyem? Nim Barabas hesbeyon be? Njises Ngaorom Eben Ke Aol hae lome o anda pu kon ko pangeyem? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ngo tomb ngub kisao o maomb bo haraoklao aol Palerom ora mao bembera hindisaol, tenaol hambunom Njises was turi homo taol mi bismil mbinim Njises hendaebe makl aondao ora homobur howes kismil hindisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ngo tomb Paler obu howes pangoklbur birisaol, obun werem angal mend kao kalokl puklub ko kao weyabur kakl, Nim somna obam aol Njises ke ngo hondobur oba mend buwe sal, nao kone bor hem ko kho sen ora bereng, aol kone dund se wi ngo bor njem buri palo sao oran menjao nao bibi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ngo tomb Nju semon baolum aol aondao baeben di, mbinin maomb bo haroklme aol, aol kon wi baeben di ngo baebenom mbinin tenaol baeben hambun bor kao ung bubur, Paler njem naon Barabas eben kabur njem Njises pe paen libi lowaebe ko kao ung bismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ngo tomb kabman maomb bo haraoklao aol Palerom mbini bor kakl, Aol is kab ngo Njises hesa Barabas ngo hayeb on, is mende aeb ora inin wakl eben kon ko pangeyem? kisesa. Ngub kisaol mbinim obu bor kakl, Barabas ora eben kaebe kismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ngo tomb Palerom mbini bor kakl, Nim Barabas ngub eben kobur aol ngo obu Njises Ngaorom Eben Ke Aol lome o bor asub buklwaob? kisesa. Ngub kisaol mbinim obun angal ngon ko san lubur kakl, Njem obu is pe kowal bil pe paen nil libi ora kismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ngub kismil Palerom mbini bor wakl kakl, Inim asub ko ora lem? Obu pe paen lib se obum khorob oran asao ora bisaol lem? kisesa. Ngub kisao o mbinim ne bombor ub kombo angal aondao bu ora kobur kakl, Obu is pe kowal bi bor pe paen nil libi ora kismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ngo tomb Palerom tenaol hambunon kone bor ora hindisaol, obum mbinin angal ngo kismi ub men mba Njises anda pu ko menjao nao bib se ora, mbinim sob aondao bu ora mao kaeb se sisaol, obum aol ngo nim inj lurukl ol nao kil ibao nao hae ora ko menger mubur, obum ib kang mendhumubur kisaon tenaol hambunom henden obun ki wes wes lisesa. Obum ngub bubur mbini bor kakl, Aol ngo nim inj pe paen lurukl. Ngub inj, inin mbib ora lereklem kisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ngo tomb Nju sem tenaol hambunom obun angal ngon ko san lubur kakl, Naom ngo bim on, nao bor di naon nongnas bor di menjao ba sin ngo hakl nao bor ora buklmaong, ngo hakl ngub bin ub bao luklmao ora kismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ngo tomb mbinim kismi nda ub Palerom Barabas kalabus hesbeyo mbinin anda pen kabur, obum obun ami nda baeben bor inim Njises doroklom mbes lu mao homabur, is pe kowal bil nil li mbakl puklub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ngo tomb Palerom ngub kisaol obun ami nda baebenom Njises men pae pobur kismin mbinim kabman maomb bo haraoklao aol aondao baoraoklao and on men pae hondabur, mbini ami baeben hambun ora obo kiril mbaklaob kismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ngub obo kiril mbaesmi tomb mbinim Njiseson lab lab samisao nda kolobur kismin, mbinim obu maobowa yaor mao babur lab lab ingi bi ebe mend mao somaesmisa. ");
INSERT INTO akh_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ngub bubur kismin mbinim aol wesmbao baebenom teng ebe ora ndibiklme ub menger, mbinim obu maobowa tenda mao nabur ya nene hae mend di pab bu pabur, Njiseson wesmbaol teng sao ndibiyakaesmisa. Ngub bubur kismin mbinim obun ki tao nanon is hul saoll mend tom sao minin karu mao manabur, mbinim Njises maobowabur obu bor kaoya ke non bu tumu kar munu dombes ubur kakl, Nju semon aol wesmbao aondao o, nje ebe soklaong as ko haebe kismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ngo tomb mbinim ngub bubur kismin obu ne maeke tokl beyabur, mbinim is hul saoll mend mao manaesmi nda mubur Njiseson wesmbaol khorob ora lismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ngo tomb mbinim obu bor maobowa angal bu ngo hakl ub bu paesmi tomb lab lab ingi bi mend Njises mao somaesmi nda kol mubur kismin, obun pibnao samisao nda wakl mao somaesmisa. Ngub bubur kismin mbinim obu is pe kowal bil nil li mbakl mini pismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ngo tomb mbinim Njises ngub men pae pismil, aol is mend obun imbi Simon obu su Sirini aol sisao o harerol ubukl hasaol, mbinim obu bor buri palobur njem Njises nil lukl bi is pe kowal bi ngo ti ora ko mao taesmisa. ");
INSERT INTO akh_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ngo tomb mbinim pobur kismin su menden imbi Kolkota kismil, su ngon imbi ngo karu wismi on te wesmbao hul kismil, mbinim yu manda ngol po pindi paesmisa. ");
INSERT INTO akh_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ngo tomb mbinim ib waen hesa marsin karae aondao bu ora bi mend kab maomunu singbi bombobur Njises nen kalismisa. Ngub kalismil Njises obum kang mend nao hindisao o nao ne bao waesesa. ");
INSERT INTO akh_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ngo tomb mbinim Njises is pe kowal bil nil li mbabur kismin, mbinim Njiseson lab lab kol barae wisao hakl taol bu kaob kaob bu mubur, bombor mend pon pae bao wisao o pone uklao om min ko mbinim han ngoll pile bimi nda ub menger, pile kang mend bismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ngo tomb ngub bubur kismin mbinim su ngo bor Njises nil li mbabur bao hondo birismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ngo tomb is pe kowal bi ngo Njises obu nil li mbaesmi ndan yu kungni ora, mbinim obu bor ngub te mao sara howes kismi ko bobae waeb ngub bu wismisa. OL NJISES KE NGO OBU NJU SEMON AOL WESMBAO AONDAO ORA YAO ko waeb bu wismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ngo tomb aol is kab mend mbibim tenaol menden osisao taol pe mu hasbil, mbinim is mende aol Njiseson ki tao nan is mende aol ki kowes nan bu nil li mbaesmisa. ");
INSERT INTO akh_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ngo tomb tenaol harer ngon en aeben bismi baebenom Njises is pe kowal bil ngub nil li mba hasaol hondobur, mbinim obu maobowa peb bu wil sara sara bubur kakl, ");
INSERT INTO akh_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Nje Ngaor Hen Moroklme Anda kundi mbabur bao hor tebon wakl wen pange bukl bi aol ngo ka. Nje heneng Ngaoron Isi ora yao sin, njem njen mbib buri palo bongeyaokl penin ub njem is pe kowal bi ngo tuwaklbir sul hond ha kismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ngo tomb Nju semon baolum aol aondao baeben di, mbinin man buwaloklme aol baeben di, mbinin maomb bo haroklme aol, aol kon wi baeben di, mbini ngo baebenom di Njises bor maobowa angal bubur kakl, ");
INSERT INTO akh_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Obum tenaol mende bor non ebe bisur bu, bu muklao o obum obun mbib bongeyaokl pokl buwaklao kismisa. Ngo tomb mbinim obu maobowabur kakl, Obu su Isreyel tenaolon aol wesmbao aondao ora yao be? Ngon ebe ka. Obum is pe kowal bi ngo tuwaklbir sul hond harob sin, naom di obul hul ha haklmao kismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ngo tomb mbinim wakl kakl, Obum ni Ngaoron Isi ora hae lao nda ub, obum heneng ora Ngaorol hul ha habur lo beyaon Ngaorom obu turi aondao ora homokl beyaol, obu ngubi tomb ebe bisur bukl baonao kismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ngo tomb aol is kab mend mbibim tenaol menden osisao taol pe mu hasbil mbinim Njises obu daol haru nil li mbaesmi nda kabom di, mbinim ngo kismi ub was Njises bor maobowa angal bisbisa. ");
INSERT INTO akh_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ngo tomb aond hora haklu nar wesmbao tukun oral hasao tomb nar el nda tokl mubur kisaon, su hambun bor em hundur aondao ora u mbabur nend kisaol, ngub bao nend kao mba haen was 3 kolok ora pangobur, nar nubu ngo ora bor as deyaesao tomb oran wakl bao bisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ngo ora tomb 3 kolok ngub pangisao tomb Njisesom angal aondao bu ora kobur kakl, Ila Ila lema sabaktani? kisesa. Ngub kisao o Njisesom ngo kisao on te angal heneng kobur ngub wiyao. Ab Ngaor o nao Ab Ngaor ka. Njem ni asub ko maru tuwaril? kisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ngo tomb tenaol mendbor Njises nil li mba hasaol teb so hasmi baebenom ngo kisao nda oborob pang heneng nao bibur kakl, Aol ngo obum Ilanja kor be kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ngo tomb ngub kismil aol ngo hasmi on is mondom akl was pobur kisaon, obum is kuwimb menger mendel ib waen karae bi dand bu pabur, is hul saoll mendel dukl bu pa mini obo Njises nen ko menyabur mao na hindisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ngub bisao o aol mendborom aol ngo Njises bor is kuwimb dand bu mao naesao nda bor Njises maobowabur kakl, Ngub nao bi. Ilanjam obu bu mukl obaokl be? nao obaokl ko hendemin ub kang mend bao hondo haem kismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ngo tomb Njisesom ko mende angal aondao bu ora ko, e kobur kisaon ora pe pa wesao pisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Bombor ngo ora tomb Ngaor Hen Moroklme Anda bor and tubal komb bi ora ndan lab lab aondao saoll ora mend manga tunda hasao nda tukun oral tomb kab bu, kaollu taokl yu nu bu pesesa. Ngub bubur kisaon su dull bere aondao ora obobur, han aondao ora wisao baeben di ha komb kob kob bisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ngo tomb tenaol Ngaoron sem andub ora mbes himismil tangaesmi baebenon maol bor tiriyao komb bara kimb bisaol, wakl enjobur teka kimb bismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ngo tomb ngub enjaokl enjaokl pobur kismin, mabor Njises obu di wakl enjaokl pisao tomb mbini su and lobokl lobokl Njurusalem bor hondaesmil tenaol andubom ora hindismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ngo tomb ami sem maomb bo haraoklao aol aondao is mend di, ami aol mendbor di mbini Njises nil li mbabur maomb bo hondo hasmi nda baebenom, dull bere obo andub sao ngo bisao nda baeben hondobur mbinim burisao po pakl aondao ora himismisa. Mbinim ngub pakl homobur kakl, Heneng ora aol ngo obu Ngaoron Isi ora sene kismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ngo tomb ten mendbor andub ora mbini Kalili haklbir Njises obu bisur buklbur taol mi ibismi baeben di, mbinim Njises nil li mba hasaol teb sol nao hae kang mend enderael sao habur bao hondo hasmisa. ");
INSERT INTO akh_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ngo tomb ten ngo hasmi baebenon is mend obun imbi Maktala Mariya kismil obu di, Njemus hesa Njoseb kabon ingi Mariya mende di, aol Seberin isi kab Njon hesa Njemus mende kabon ingi di, ten andub mendbor di ngo baeben sisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ngo tomb mbon sisaol aol homa mend obun imbi Njoseb kismil, obun su di Nju semon su bor was su Arimatiya sisaol, aol ngo obu di Njiseson angal bib ebe nda hem ko pangisao o ibisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ngo tomb obum ngub obobur kisaon, maomb bo haraoklao aol Paler birisaol pobur Njiseson toklo tangakl pon ko kao kalisaol, Palerom obun ami baeben bor Njiseson toklo tangakl pu lowaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ngo tomb Njosebom Njiseson toklo mu pabur kisaon, obum lab lab ebe wen pange haek bi ora mondom tanga paesesa. ");
INSERT INTO akh_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ngub tanga pa taokl pobur Njoseb obun han te wen pange mend waru u mbaesao bor Njiseson toklo ngo bor maol bu mbabur, han aondao ora mend ngol wisao ndam pere taokl obobur, han te ngo Njises tangaesao on dir komb pae o bor manga mbaklbir paokl pisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ngo tomb Maktala Mariya hesa Mariya mende kab mbibim Njiseson maol teb so ngol bao hondo birisbisa. ");
INSERT INTO akh_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ngo tomb embi ub kongon wes wes sisao o nend kisaol, ekera nan Nju semon baolum aol aondao baeben di Peresi aol baeben di mbini hambun mbinin kabman maomb bo haraoklao aol Paler birisaol was obo kiril mbaesmisa. ");
INSERT INTO akh_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ngo tomb mbinim ngub obo kiril mbabur kakl, Aol aondao o, aol kakla ko hae Njises ke ngo maol baemndam, obu nao li bao hasao tomb obum ngub kisao. Nim bao hor tebo nanon wakl enjaokl poklwao kisaol ubuklum kismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mbinim ngub kobur kakl, Ngub kisaong Njises obun man pange aol baebenom tenaol hambun maobowabur obum wakl enjaokl bene ko, obum mbes kakla nim wakl enjaokl poklwao kisao ub heneng ora bene ko, mabor mao heneng ora saklbur mbinim obun toklo sub tukl oboklemi ora. Ngub bukleming mbinim ngub nao bin ub, bao hor teb oran njem ami mendborom oborob ora maomb bo haen kae sin ebe ora soklao kismisa. ");
INSERT INTO akh_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ngo tomb maomb bo haraoklao aol Palerom kakl, Ebe ka. Ami aol mendbor abo ngo hayem aong, inim ngo kaemnda ub aol maol ngo bor buri palobur ora maomb bo haen lowaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ngub kisaol mbinim han te aol maol ngo bor pobur kismin, Njiseson maol han mangaesmi dir komb pae nda bor mondom hondarmib ko, ko hondoklbur soweb bi ha simen non bi sao mondom, han aondao ngon nomboklo nan para mba peb bu oborob ora ko u mbaesmisa. Ngub bubur kismin mbinim ami aol nda baeben maomb bo haen kaoklbir anda pismisa. ");
INSERT INTO akh_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ngo tomb Nju semon hor boroklme bao* on hor ber paesmil, Nju semon kongon mubaon hokloben wen nar pol bam ibisao tomb Maktala Mariya hesa Mariya mende kab mbibim Njiseson maol bor wakl hondokl pisbisa. ");
INSERT INTO akh_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ngub bisbil penar bu ora bombor ngo tomb su dull bere aondao ora ibisao tomb, Aorao Aondaon angal mini wesao mend yu heben haklbir bonge hasesa. Ngub bonge habur kisaon Njiseson maol bor han aondao mend tiriyao bo mbaesmi nda munu pere tu aeben sabur, han ngon mandaemol obu obo birisesa. ");
INSERT INTO akh_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ngo tomb ten nda kabom hindisbil angal mini wesao ngo obun el wil bor bubiyab sao bi haen birisaol, obun lab lab samisao o di nar el non bi bao bi hakol bi haek bi ora sisaol hindismisa. ");
INSERT INTO akh_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ngo tomb ngub birisaol hondobur ami ngo Njiseson maol bor maomb bo hasmi nda baebenom Ngaoron angal mini wesao nda hondobur kismin, pakl aondao ora homo burisao po dur kobur, tenaol pe paroklme nda ub menger sul komb hakl buri ko po ubur kone nao hae ora wismisa. ");
INSERT INTO akh_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ngub bismi o angal mini wesao ndam ten nda kab bor kakl, Ni hende ora ibim aol Njises obu mbinim is pe kowal bi bor nil li mbaesmi o es bukl obaebing, ibim pakl nao homaoklaob kisesa. ");
INSERT INTO akh_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Angal mini wesao ndam ngub kobur wakl kakl, Aol ngo obu enjo ngo obun maol bor bao nao wi, obum ni wakl enjaokl poklwao ko ini mbes kao njisao ub enjaokl pa ka. Obun maol ngo obun toklo waonao bor nao wi ngong, hondokl ubuklub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ngo tomb Ngaoron angal mini wesao ndam ten nda kab bor wakl kakl, Ibim ngubi tomb penar bu ora pobur, Njiseson man pange aol baeben bor Njises obu su Kalili bor enjaokl po hayaong, inim Kalili poklemi tomb obu ngo bor haklaol hondokleming, Njises obu wakl enjaokl pene ko nao angal ngo orang, kao kalokl puklub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ngo tomb ten nda kabom mbibin kone bor pakl himisbi o kone mende bor turi aondao ora homaokl homaokl, Njiseson man pange aol baeben kao kalokl akl ora pisbisa. ");
INSERT INTO akh_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ngo tomb ten nda kab ngub pukl hasbil penar bu ora Njises obu harerol obo pindib pabur mbibi bor kakl, Ibim as ko ora haklwaebe kisesa. Ngo tomb ten nda kabom obu hasaol teb so pobur kisbin, mbibim Njiseson aongao ma bor men habur mbibim obu bor turi homo kaoya kisbisa. ");
INSERT INTO akh_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ngo tomb Njisesom mbibi bor kakl, Ibim pakl nao hemebur, ninao haeme nda baeben bor inim Kalili poklemi tomb ni hondoklemi ka ko kao kalokl puklub kisesa. ");
INSERT INTO akh_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ngo tomb ten nda kab harer bor pisbi tomb ami mendbor Njiseson maol bor maomb bo hasmi nda baeben su and lobokl lobokl Njurusalem bor wakl pobur, mbinim Njiseson maol bor bisao sao hindismi nda baeben Nju semon baolum aol aondao baebenom pangen kao kalismisa. ");
INSERT INTO akh_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ngo tomb Nju semon baolum aol aondao ngo baeben di, mbinin maomb bo haroklme aol, aol kon wi baeben di mbini hakl hakl obo kiril mbabur, mone andub ora ami baeben kalem ko kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ngo tomb mbinim ngub kao kao bu pabur ami nda baeben bor kakl, Inim tenaol hambun bor ngub ora lowaebe. Njises obun man pange aol baebenom sup mupango obo hondo habur, naom u kang mend paol pemao tomb somna Njiseson toklo sub taokl paemisa lowaebe ko karu mao kikil baesmisa. ");
INSERT INTO akh_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mbinim ngub kobur kakl, Inin maomb bo haraoklao aol aondao ndam inim angal ngo lemi o pangoklao tomb obum ini bor asub ko u paolaemib kobur, ini bor ko homo menjao nao bin ko naom obu bor angal mendbor ebe kao kaloklmao ora kismisa. ");
INSERT INTO akh_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ngo tomb mbinim ngub kismil ami nda baebenom mone kalismi nda baeben mubur, mbinim ngo kismi ub hul nao hae mbinin angal taolubur ngub was kismisa. Ngub kismil Nju semon angal ngo su hambun bor kam aeben aeben bismil, ngubi tomb di ngub was lome. ");
INSERT INTO akh_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ngo tomb Njiseson man pange aol tobon teb nda su Kalili pobur kismin Njisesom puklwaebe ko kao kalisao ub mbinim yu manda bor pismisa. ");
INSERT INTO akh_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ngub pismi tomb mbinim Njises obu hasaol hondobur kismin mbinim turi aondao ora homobur obu bor kaoya kismi o, mendborom obu Njises heneng ora e be? baehaemen eb ko kone taol taol bismisa. ");
INSERT INTO akh_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ngo tomb Njisesom mbini hasmil teb so obobur kakl, Nao Ab Ngaorom yu heben hesa su ngo kab buri palo maomb bo han ko obun buri hambun sao taol bu njisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ngub kobur wakl kakl, Ngub bisaong inim di pobur inim tenaol hambun nao man pange tenaol was haen kobur lemin, Ab di Isi di Wesao Ebe Komb Bi ora nda di Ngaor bombor ngo obu ora yaong, mbinim obul hul ha habur obun sem ora haen ub inim mbini mbabtas bibaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ngub kobur kakl, Tenaol hambunom nim ini bor mbes angal hambun sao kao njuruklu nda baeben, hul nao hae men hakol bin ub kao kaloklwaebe kisesa. Ngub kobur kakl, Pangeklem. Bao bu kowes nao bi haenbur nim ini nao maru tuwae bao hor hambunon ini haru akol was bu haklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Angal ngo Ngaoron Isi Eben Ke Aol Njises obun Angal Bib Hobao Sao ora yaong pangoklwaebe ka. ");
INSERT INTO akh_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Pibnao oran Angal Bib Hobao Sao ngo Ngaorom obun man mini aol Asaya bor kao kalisao ub Asayam ngub waeb bu wisao. Pangeklem. Aol bombor ngo nim mabor nao angal mini Obu mbes pu lowao Obum nje poklesi harer on kare Mao dund sarukl burukl buklao ora. ");
INSERT INTO akh_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Su tenaol nao biri bor Aol mondom angal aondao bu ora kobur kakl Aorao Aondao poklao harer on Oborob ora kareyo Mao dund sa man man bibaebe ko Ngaorom obun man mini aol Asaya kao kalisao ub Asayam ngub waeb bu wisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ngo waeb bu wisao ub Njon mbabtas biyao aol obu su tenaol nao biri bor po habur kisaon, obum tenaol hambun bor kakl, Ini hambunom inin kone baol monoklwaebe ora. Inim ngub kone baol manaem sin, inim khorob bismi sao inin kone bor wiyao o Ngaorom kunaklaol nim ini mbabtas buklwao ko kao kalo hasesa. ");
INSERT INTO akh_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ng tomb Njuriya tenaol hambunon mendbor di, Njurusalem tenaol baebenon mendbor di, mbini hambun ora Njonom man kisao ub pangokl pobur, mbinim khorob bismi sao Njon obu bor maokl peyu kao kalismi tomb Njonom mbini ib Njoranol mbabtas bu hasesa. ");
INSERT INTO akh_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ngo tomb aol Njon ngom obun lab lab di some kamelon irim bi was samo habur, some songol hakom obun paklo paklol tengi tanga mba samo hasesa. Ngub bubur kisaon obum ne di nollae nen hesa is ibao non bi sem mend kab was no hasesa. ");
INSERT INTO akh_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ngo tomb Njon obum tenaol hambun bor man kao kalobur kakl, Ni kang nao hobao sao ora hae o, aol hobao sao aondao ora mabor oboklao ora. Ni di aol kho ora hae ol, nim sul ber munubur obun aongao su heneng o di nao kolaklaeb se ora hae kisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ngub kobur kakl, Nim ini ibom ora mbabtas bu hae o, obum ini Wesao Ebe Tangarom mbabtas buklao ko kao kalo hasesa. ");
INSERT INTO akh_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ngo tomb ko mend oran Njises obu su aondao Kalilin and lobokl lobokl Nasarer bor haklbir Njonom obu ib Njoranol mbabtas bin ko ibisaol, Njonom obu ib Njoranol mbabtas bisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ngub bisaol Njises obum ib ngo obu mbabtas bisao nda tuwaklbir ib ngon marel yin ibisao tomb, penar bu ora bombor ngo tomb yu heben bor saohar kebe kobaesesa. Ngub kebe kobaesao tomb Ngaoron Wesao sao ebeyabukl non bi oram Njises obo men mbaesaol hindisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ngo tomb yu heben bor angal mend obobur kakl, Nje nao Isi ora hael ol, nim njel kone uruklul nao kone bor di turi aondao ora bin hae kisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Bombor ngo tomb Ngaoron Wesaom Njises obu su tenaol nao biri bor kemi pisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ngub kemi pisaol Njises obu buklhoma some dera ker sem baeben daol haru, bao hor supu kab kab hor kab oran bao hasaol, Seranom obu bor khorob mao baklbur bisesa. Ngub bisao o angal mini wesao baebenom Njises obu oborob ora maeb ha bisur bu hasmisa. ");
INSERT INTO akh_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ngo tomb mbinim mabor Njon Mbabtas Biyao Aol kalabus mao palaesmi tomb Njises obu su Kalili bor pobur, tenaol hambunom pangen Ngaoron Angal Bib Hobao Sao kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ngub kao kalobur kakl, Ngaorom ini maeb ha maomb bo haklao ub ngubi Ora tomb ngo teb sam sam bu pindi pae ong, inin kone baol munubur Angal Bib Hobao Sao ngo kao njurukl ol hul ha haklwaebe ko kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ngo tomb Njises obu ib Kalili mare mare was pisao tomb aol Pita hesa Andur kab mbibi haemeyakl hasbil hindisaol, mbibi kab ib wen moroklbe aol habur mbibim wen ongon bu murukl wisbil hindisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ngub hondobur kisaon Njisesom mbibi bor kakl, Nim ibim tenaol men mereklebin lowaong, ni taol mi ubuklub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ngub kisaol Pita Andur kabom penar bu ora mbibin wen ongon bimi sao nda hakl ngol bao u haen kaoklbir Njises taol mi pisbisa. ");
INSERT INTO akh_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ngo tomb kang mend aeben sao pismi tomb Njisesom hindisaol, aol is kab mend di Seberin isi kab Njemus Njon kab haemeyakl mbibin ib taokaoll bor burubur, mbibin ib wen ongon bimi sao ndan dir wisao hakl bu waru taombulakl wisbil hindisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ngub hondobur obum mbibi kab di ubuklub kisaol, mbibim mbibin ib taokaoll nda hesa mbibin ab Seberi kab di, mbibin kongon bimi aol baeben di, ib taokaoll ngo bor bao buru haen kaoklbir mbibim Njises taol mi pisbisa. ");
INSERT INTO akh_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ngo tomb mbini hambun su and lobokl lobokl Kabenam bor honda hasmi tomb Nju semon hor boroklme bao* o pindib paesaol, Njisesom Nju semon man pangoklme anda bor hondabur obum Ngaoron angal bib tenaol hambunom pangen kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ngo tomb Njisesom angal bib ngo kao kalisao o, tenaol hambunom pangismi tomb Nju semon man buwaloklme aolom buwaloklme ub inj, obum kone kikil bi, bi make lome aolom angal buri palobur lome nda ub kobur kao kalisaol mbinim burir aondao ora bismisa. ");
INSERT INTO akh_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ngo tomb aol umubaoli samom men pae akol bu hae obun tombao bor sam biri mend mbinin man pangoklme anda ngo bor birisao ndam, Njises bor kaong lu angal aondao bu ora kobur kakl, ");
INSERT INTO akh_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Nasarer Njises o, njem nao bor asub ora buklbur obae balem? Nje Ngaoron komb bi aol ora hael ol nim nje ora hendeng, njem nao khorob ora lu bowes bukl obae be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ngub kisaol Njisesom sam ngo aolon tombao ndaon bor birisao nda bor buriyab ora taolu lubur kakl, Njem aol ngon tombao bor angal ko nao biri dera pib ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ngo tomb sam ngo aolon tombao bor birisao ndam aol nda khorob ora mao dur ka komb hakl po win ko, aondao bu ora karaklae kao peyaoklbir kisaon dera pibisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ngub bisaol tenaol ngo hasmi nda baebenom burisao po burir aondao ora biyubur mbini hakl hakl kao kao bubur kakl, Wao. Naom nao hindismao sao mend bang, ngo sao asao e? Obum angal wen pange ora mend le ka. Aol ngo obum aol aondao bi make lome aolom angal lome ub kaonao tomb, Seran baebenom di obun angal hul nao hae pangaoklbir paokl paemnda kismisa. ");
INSERT INTO akh_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ngub bisaol penar bu ora Njisesom ngo bisao sao tenaol hambunom pangen kam aeben aeben bismil su Kalili ngo bor paolismi baeben hambunom pangaesmisa. ");
INSERT INTO akh_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ngo tomb tenaol hambun hor baoraoklbir buri kismi tomb Njises di Pita hesa Andur kab di Njemus Njon kab di, mbini hambun Pita Andur kabon anda pismisa. ");
INSERT INTO akh_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ngo tomb Pitan weren ingi sen khorob ora ha pob turub bu homobur, obun to bor was bao u mba hasaol, mbinim penar bu ora Njises kao kalismisa. ");
INSERT INTO akh_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ngub kao kalismil Njisesom ten nda u mba hasaol pobur, ten ngon kil men mubur mao tekaesesa. Ngub bisao tomb ten nda pob turub bubur homo wisao nda penar bu ora ebe bao sisaol, ten ngom mbinin ne noklemi on man man bisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ngo tomb ombonao nar anda bombisao tomb mbini tenaol sen hae homo wismi baeben hesa umubaoli tombao bor sam biri baeben kab, mbinim Njises obu hasaol was taokl obo ukl engel bismisa. ");
INSERT INTO akh_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ngo tomb tenaol su and lobokl lobokl aondao ngo bor paolismi baebenom, obum ngo bisao sao hondoklbur and ngo Njises hasao on tiriyao kombae bor tenaol andub ora dengeb dengeb kobur hondo hasmisa. ");
INSERT INTO akh_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ngo tomb Njisesom tenaol sen kam mundub mundub hae ngo taokl ibismi nda baeben mao ebe sa peb bubur, obum tenaol umubaoli ngo baebenon tombao bor sam birisao baeben di taol dera mao ebe sa peb bisesa. Ngub bisaol sam ngo tenaolon tombao bor birisao o taol deraesao nda baebenom di Njises obu Ngaoron Isi ora hae ko ora hindismil, Njisesom mbini angal nao ke paokl was pen kisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ngo tomb ekera nan bao buklbur hoklob kebeyam ibisao tomb Njises obu hungum dera pobur kisaon, obum tenaol nao biri mend sisao bor pobur Ngaor bor kao kalo birisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ngo tomb mabor bao bu hebe kobaesao tomb Pita di aol ngo mbini haru akol bismi nda baeben di mbinim Njiseson mama obu es bu mi pismisa. ");
INSERT INTO akh_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Mbinim ngub es bam pobur kismin, obu hasaol hend wabur mbinim obu bor kakl, Tenaol hambunom nje es beyem kismisa. ");
INSERT INTO akh_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ngub kismil obum mbini bor kakl, Aoh, nim su mende bor haklbir tenaol hambun bor angal bib ngo ora kao kalokl obandang, su Kalili ngon tangar tangar hambun bor ngub angal bu kao kalon ub nao haru mbi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ngub kobur kisaon Njises obu su Kalili hambun bor akol bu habur, obum Nju semon man pangoklme anda baeben hambun bor honda was bubur, tenaol hambunom pangen Ngaoron angal bib kao kalo, obum tenaolon tombao bor sam birisao baeben di taol deram akol bu hasesa. ");
INSERT INTO akh_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ngo tomb aol maollun bi is mend hasao o, obum Njises hasaol obo tumu karu dombes ubur obu bor kao deb deb bubur kakl, Njem ni ebe mao sakl ko pangal sin, njem ni ebe mao saklesi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ngub kisaol Njisesom aol ngo hond aondao ora homobur kisaon, obun kim men mbabur obum aol ngo bor kakl, Nim nje ebe sen ko pangakl ol, njen toklo bor der ngo biye baeben di ngubi tomb ebe saokl kisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ngub kisaol bombor ngo ora tomb aol maollun bi nda ebe bao sisaol, obun toklo bor der bisao nda hakl di songol heneng bao ibisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ngo tomb Njisesom aol nda bor nje penar bu njen anda pu ora ko, angal buriyab ora kobur ");
INSERT INTO akh_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","aol ngo obu bor kakl, Njem ni ebe mao sanao ko mendel kao kaloklesi hendaebe ora. Ngub inj, Nju semon baolum aol bor bombor o nao songol ebe sa ko muwalokl pu. Ngub pobur lesin mbes Mosesom nje non bi semom bibaebe kisao ub tenaol hambunom njen toklo songol wakl ebe sene ko henden ub, njem Ngaor bor kalo mabaorao haoribi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ngub kisao o aol ngo obun songol wakl ebe sisao ndam ko ko was tenaol hambunom pangen kisaol, mbinim Njises obu turi homo mondom was munu baklu taokl poklemi ko, Njises obu su and lobokl lobokl tenaol biri baeben bor nao pisesa. Ngub bubur obum dera dera tenaol nao biri bor was bao hasaol, tenaol su ngo bor paolismi baeben hambunom Njisesom ngo bu hasao sao turi homo hondoklbur, Njises obu hasaol was obo kiril mbaesmisa. ");
INSERT INTO akh_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ngo tomb mabor bao mendbor pibi hasao tomb Njises obu su Kabenam and lobokl lobokl aondao bor wakl pisao tomb, tenaol andubom ora Njises obu, obu paolaonao anda on bao bereyao kismil pangismisa. ");
INSERT INTO akh_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ngo tomb tenaol andub ora obo kiril mbabur and ngo Njises obu hasao nda di tumbi hakl peben ora hasmil, ora isu tiriyao kombae ora bor di hakl kang ora di nao hasesa. Ngub bisaol tenaol andub ora dengeb dengeb kao mba hasmil, Njisesom tenaol aondao ngo dengbe mba hasmi nda baebenom pangen Ngaoron angal bib kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ngo tomb obum ngub kao kalakl hasaol, aol is makl mondom aol aongao tibae mend taokl ibismisa. ");
INSERT INTO akh_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mbinim ngub taokl ibismi o and ngo Njises hasao ndan tenaol andubom ora tiriyao kombael dengeb dengeb kismil, mbinim andaon Njises hasaol teb so taokl hondakl buwaesmisa. Ngub hondakl buwabur kismin mbinim aol aongao tibae nda and hom kem nan taokl yin pobur, Njises obu ora hasao dund so nan and ngon hom kebe kobaen kobur, aol aongao tibae ngon to obu u mba hasao nda bor bor, yam hend ha pabur unu Njises ora hasao ndal sub munu tibam tibam bismisa. ");
INSERT INTO akh_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ngo tomb Njisesom aol is makl ndam obul hul ha ora habur ngo bismi sao hondobur, obum aol aongao tibae nda bor kakl, Nao isi o, nim njen kone bor kho wiyao o kunarukl kisesa. ");
INSERT INTO akh_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ngo tomb Nju semon man buwaloklme aol mendbor and ngon birismi nda baebenom mbinin kone bor nen sab nda nda bu sub kao kao bubur kakl, ");
INSERT INTO akh_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Aol ngo obum asub ko ngub le bo? Tenaolon kone bor khorob bimi ub aol mondom kunakl buwaklao ora. Ngaor obum bombor o kunaeb se hayao o, obum ngo le ub Ngaor bor maobowa angal bu, hel hondo angal ngo bi o kismisa. ");
INSERT INTO akh_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ngub nen sabismil Njisesom obun konem mbinim ngo nen sabismi sao mbinin kone bor mao bembera hondobur, obum mbini bor kakl, Inim inin kone bor asub ko khorob ngub nen sabeklem balem? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Njisesom ngub kobur kakl, Nim angal awo ora kend bi ka bo? Nim njen kone bor kho wiyao o kunarukl kanda ub kend bi soklaol bukl buwaklwao be? be? nim aol aongao tibae ngo obu bor nje ebe sang, njen to abo mu mini, njen anda pu lowao ub kend bi soklaol bukl buwaklwaob ko pangeyem? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ngub kobur kakl, Ni Aolon Isi Ora hae ol, sun tenaol hambunon kone bor kho wiyao sao kuna, tenaol heme di ebe tekakl pu kaeb se hae ko hendeklemin ub kobur, obum aol aongao tibae ngo bor kakl, ");
INSERT INTO akh_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Nje teka peyo njen to abo daol mu minibir njen anda pu ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ngub kisaol obum tenaol aondao ngo ber mba hasmi ndan el so oral teka peyobur kisaon, obum penar bu ora obun to nda mu minibir pisesa. Ngub pisaol tenaol aondao ngo ber mba hasmi nda baebenom burir biyu pakl aondao ora homo, mbinim Ngaor bor kaoya kobur mbini hakl hakl kakl, Naom ngo haondaoklaom ubi oran mbes mend bisaol dim nao hindismao ora kismisa. ");
INSERT INTO akh_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ngo tomb Njises obu wakl ib mal aondao ndan mare mare bor po hasaol, tenaol andub ora Njises obu hasaol obo kiril mbaesmil, obum tenaol ngo baeben bor Ngaoron angal bib ebe nda pangen kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ngub kao kal peyaoklbir kang mend aeben sao pobur hindisaol, Aolpason isi Libae obu takis mone moroklme anda bor birisaol hondobur Njisesom Libae bor kakl, Njem ni taol mi ib kisaol, obum teka peyaoklbir taol mi pisesa. ");
INSERT INTO akh_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ngo tomb Njises di obun man pange aol ngo obu haru pibismi nda baeben di mbini Libaen anda bor ne noklbur birismil, tenaol ngubi baeben andubom ora ko ko was Njises obu taol mi po hasmi ub, mone takis moroklme aol andub ora di, khorob was bu haroklme aol andub ora di, Njises obu haru obun man pange aol baeben daol ne noklbur birismisa. ");
INSERT INTO akh_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ngub birismil Peresi semon man buwaloklme aol mendborom, Njises obum mone takis moroklme aol baeben hesa khorob was bu haroklme aol baeben kab daol maomunu ne no birismil hondobur, mbinim obun man pange aol baeben bor ne mubur kakl, Obum asub ko mbini mone takis moroklme aol ngo baeben hesa mbini tenaol khorob bimi kab daol maomunu ne no bereyem? kismisa. ");
INSERT INTO akh_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ngub kismil Njisesom pangobur mbinin angal ngon ko san lubur kakl, Tenaol sen nao hae baebenom dokta biri nao puklmi ora. Ngub inj, tenaol sen ha homo wimi baebenom was dokta biri puklmi kisesa. Njisesom ngub kobur kakl, Nim tenaol kone dund se wi oborob bu haroklme baeben bor kone baol monoklwaebe kokl inj obowao ora. Ngub inj, nim tenaol khorob bimi baeben bor kone baol munu, inim khorob bismi sao tuwaklwaebe kokl obowao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ngo tomb ko mend oran Njon Mbabtas Biyao Aolon man pange aol baebenom di Peresi semom di mbinim Ngaor bor nen saboklbur beyom kobur, ne nao ne tuwa paolismisa. Ngub bismil tenaol mendborom Njises hasaol obo kao kalobur kakl, Njonon man pange aol baeben hesa Peresi semon man pange aol baeben kabom mbinim ne tuwa paoloklmeng, njen man pange aol baebenom asub ko ne tuwa nao paoloklmeb? kismisa. ");
INSERT INTO akh_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ngub kismil Njisesom mbini bor kakl, Aol mondom obun ten wen taol bubur, obun tenaol sango baeben daol mbini haru turi hom hom bu bao buruklemi tomb mbinim ne nao ne tuwa paoluklemi be? Ngub inj ora. Aol ten wen taol bi ngo obu obun tenaol sango baeben daol maomunu bao haklemi aeben anga tomb ne tuwa nao paoluklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ngub kobur kakl, Aol ten wen taol bi ngo obu mabor mondom obu su tangar bor pen lao bao o pindib paklaol, obun tenaol sango baeben daol maomunu nao haklemi tomb mbinim obu hem kobur ebe ne tuwa paoluklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ngo tomb Njisesom angal mar mende di kobur kakl, Toklo and turub bi mbes pange piri mend kaollu dir wiyao tomb, dir ngo wiyao o bor manga taombuluklbur mondom lab lab buri ebe wen pange on mend nao heya moroklme. Ngub inj, mondom ngub ba sin, mbes pange piri ngon dir uklao bor manga taombuluklbur lab lab buri ebe wen pange on mend heya muklao tomb, lab lab mbes pange ngo kang bu dir uklao nda di wakl aondao bu men and sen lao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ngub kobur kakl, Mondom ib waen wen pange di some songol be mbes pange bor nao humu woroklme o, mondom ngub ba sin some songol be ngo dallmbe bowes bu kho soklaol, ib waen ngo di ora sul kowe bowes buklao ora kisesa. Ngub inj, mbini bimi ub ib waen wen pange sa sin, mbinim some songol be di wen pange bor was humu woroklme ko Njisesom angal mar ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ngo tomb Njises obu Nju semon hor boroklme bao* bombor menden wir il em hinin pibisao tomb, Njises obun man pange baeben di Njises obu daol haru akol bu habur kismin, obun man pange baeben ndam wir il ngon mendbor taolismisa. ");
INSERT INTO akh_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ngub bismil Peresi aol mendborom Njises bor kakl, Hend. Njen man pange aol baebenom ngo beyem ub naon manom hor boroklme bao on ngub nao bibi ke wiyao sao hul habur asub ko beyem balem? kismisa. ");
INSERT INTO akh_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ngub kismil Njisesom mbini bor kakl, Inim aol wesmbao aondao Debirom bisao sao arman mbuk waeb bor wiyao ub nao hendeme be? kisesa. Ngub kobur kakl, Nim ngo kakl o non mbes Debir obu di obu haru hasmi baeben di, mbinin ne nao wisaol dem khorob ora himismi tomb ");
INSERT INTO akh_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Debirom Ngaor bor kaoya lome anda bor hondabur and ngon palawe Ngaor bor kalismi o wisaol, tenaol kho ebe hambunom nao noklwaebe ora, baolum aol baebenom was noklemi ke wisao o, aol Abayata obu Nju semon baolum aol aondao ora haenbur Debirom palawe ngo bao bibir bu mu nisao ora. Ngub mu nobur obu haru hasmi baeben di kalisaol, mbini hambunom bao nisming, arman ngo mbuk waeb bor wiyao ub nao hendeme be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ngo tomb Njisesom mbini bor wakl kakl, Ngaor obum tenaol warisaol, hor boroklme bao o was hem ko mao sor maen ko inj warisao ka. Ngub inj, obum tenaol ora hem kobur, hor boroklme bao ngo win kisao om tenaol bisur bin ko win kisaol, ");
INSERT INTO akh_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Aolon Isi Ora obu di hor boroklme bao ngon Aorao Aondao ora yao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ngo tomb Njises obu Nju semon man pangoklme anda andaon wakl hondabur hindisaol, aol ki kho tibae mend birisaol hindisesa. ");
INSERT INTO akh_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ngo tomb Nju semom mbinin hor boroklme bao* on Njises obum aol ki kho ngo ebe mao sarob sin, mbinim ngol mao bembera obu bor te mao sara howes koklbur sub hondo hasmisa. ");
INSERT INTO akh_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ngo tomb Njisesom aol ki kho nda bor kakl, Nje tukun oral teka ha kisesa. ");
INSERT INTO akh_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ngub kisaol aol ndam ngub teka hasao tomb Njisesom Nju sem nda baeben bor kakl, Naom hor boroklme bao on naon kone ebe ora u haklmao ub tenaol mende bisur buklmao be? be? naom mbini bor khorob buklmao? Naom tenaol mende oborob ora haen ko bisur buklmao be? be? naom mbini pe paen lu tuwaklmao? Manom asao was ke wiyaob? kisao o, mbinim e beb kang ora di nao kismisa. ");
INSERT INTO akh_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ngo tomb Njisesom mbini hambun hondo akol bisaol, mbinin kone bor hul ha tundaesmil hondobur obum hem aondao ora ko, mbini ko homobur aol ki kho nda bor kakl, Njen ki abo dundukl pe kisaol, aol ndam obun ki dundukl pesao tomb ebe bao sisesa. ");
INSERT INTO akh_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ngo tomb mbini Peresi sem ngo birismi nda baebenom ko homobur, penar bu ora hi pa taokl dera pobur, mbinin maomb bo haraoklao aol aondao Heroron sem baeben hesa maomunu kiril mba burubur naom Njises pe paen lem ora ko karismisa. ");
INSERT INTO akh_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ngo tomb Njises di obun man pange baeben di mbinim su ngo mbini hasmi ol haklbir ib Kalili mal aondao mend wisao on teb so bor po hasmil, tenaol aondao andub ora Njises obu taol mi ibismisa. Ngub ibismi o tenaol aondao ngo ibismi baebenon mendbor su Kalili bor hakl di, mendbor su Njuriya hakl di, ");
INSERT INTO akh_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","mendbor su and lobokl lobokl Njurusalem hakl di, mendbor su Irumiya hakl di, mendbor ib Njoran mende nan hakl di, mendbor su and lobokl lobokl Taya hesa Siron kab bor paolismi baeben hambun ora di, mbini su ngo baeben bor haklbir Njisesom hambun sao ngo bu hasao saon arman kam aeben aeben bismil pangaoklbir, tenaol aondao ngo baeben obu hasaol ngub obo kiril mbaesmisa. ");
INSERT INTO akh_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Ngub obo kiril mbaesmi tomb Njisesom tenaol andub ora sen ha wismi baeben ebe mao sa peb bisaol, tenaol sen kam mundub mundub hae andubom ora mbinim Njiseson toklol waraklemi tomb mbinin sen wakl ebe sen ko warakl engel bubur dengeb dengeb aondao ora kismisa. Ngub dengeb dengeb kismil Njisesom obu ora dengi mbaen lemi ko nen sabobur obun man pange baeben bor kakl, Tenaol andub ora ngo dengeb dengeb keyem om ni hes mbaklemi, ni ib taokaollol burun ub ib taokaoll mend maenae obo wib kisesa. ");
INSERT INTO akh_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ngo tomb sam ngo tenaolon tombao bor birismi nda baebenom Njises hondobur, mbinim obun aongao ma bor obo dombes ubur mbinim karaklae ko, obu bor angal aondao bu ora kobur kakl, Nje Ngaoron Isi ora hael kismisa. ");
INSERT INTO akh_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ngub kismil Njisesom mbini bor ni Ngaoron Isi ora hae ko, tenaol hambunom nao pang doklaen ko buriyab ora taolu lisesa. ");
INSERT INTO akh_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","14","Ngo tomb Njisesom aol mendbor obun man pange aol mao ha peb bukl ko nen sabobur kisaon, obum yu manda bor pisesa. Ngub pobur kisaon obum aol ngo obun angal bib hobao sao kam akol bimi aol mao haklwao ko nen sabisao baeben, obu hasaol ubuklub kisaol ibismisa. Ngo tomb obum aol is duteb oran obu daol haru was bao haen ko mao habur kisaon, obum aol duteb ngom su hambun bor Ngaoron angal bib ebe ngo kao kalam akol bin ko mao ha peb bubur, ");
INSERT INTO akh_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","mbinim tenaolon tombao ndaon bor sam buruklao baeben taol deraen ko di buri taol bu kalisesa. ");
INSERT INTO akh_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Njisesom aol duteb ngon imbi ngo was mao hasao. Simon obun imbi mende Njisesom Pita ko karu wisaol obu di, ");
INSERT INTO akh_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Seberin isi kab Njemus Njon kab sisaol mbibin imbi wen pange Njisesom Bonesis kisao o, imbi ngo karu wisao on te ibi har kull lao nda ubi ora hayeb kisaol, mbibi ngo kab di, ");
INSERT INTO akh_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andur di, Pilib Batolimu kab di, Matiyu hesa Tomas kab di, Aolpason isi Njemus di, Tariyas di, Simon mende obu Selor sem sisaol ngo obu di, ");
INSERT INTO akh_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Iskeriyaor Njuras obum mabor Njises karu lubur Njises lukl bismi baeben munu kalisao aol nda di, ngo baeben sisesa. ");
INSERT INTO akh_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ngo tomb Njises obu and obu paolisao o bor pisesa. Ngub pisao tomb tenaol andub ora Njises obu hasaol wakl obo kiril mbaesmil, obum mbini bor Ngaoron angal bib nda was kao kal hakol bisao tomb Njises obu di obun man pange baeben di mbinin ne naeb se ko kang mend nao wisaol ne nao nismisa. ");
INSERT INTO akh_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ngo tomb mbinim ne ngo nao nismi nda, tenaol mendborom hondobur kam aeben aeben bismil, Njiseson am semom angal ngo pangobur mbini hakl hakl kakl, Njises obu he sene saol ngao, naom obu men hakl mbi kaoklbir Njises hasaol obo men hakl ibismisa. ");
INSERT INTO akh_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ngo tomb Nju semon buwaloklme aol mendbor Njurusalem hakl ibismi baebenom mbini hakl hakl kakl, Aol ngo obu Seran sem aondao ora Belsebaol kab habur, Seran semon wesmbao aondao ora ngon burim ora, tenaolon tombao bor sam bereyao o taol dera hae kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ngub kismil Njisesom tenaol ngo hasmi baeben bor ubuklub kobur, obum mbini bor angal mar ko angal mend kao kalobur kakl, Seran obum obun mbib was ebe taol deraklao ko pangeyem be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Njisesom wakl kakl, Aol is bomborom maomb bo haraoklao semom tom kab bu taol bu kobabur saond baem sin, mbinin maomb bo haroklme ub di kho soklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ngub kobur kakl, Mende di su and te di and bomboron haroklme baebenom di tom kab bu taol bu kobabur saond baem sin, and ukl bombor kang baondib mini ora di nao haklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ngo tomb Njisesom wakl kakl, Seranom mbinin mbib tom kab bu taol bu kobabur saond baem sin, mbinim oborob nao haklemi ora. Ngub inj, mbini hambun hom peyo, ora bum haklemi ko Njisesom angal mar ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ngub kobur kakl, Aol mondom aol buri ora menden anda bor obum hondabur, aol buri ngo obun osisao uklao sao baeben bao mukl buwaklao ora. Ngub inj, aol ngo paes nokl buklao om aol and aorao buri ngo obu mbes yam ki aongao tanga pa u mbarob sin, obum aol buri ngon anda bor osisao uklao sao baeben di ebe muklao ora ko Njisesom angal mar mend di ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Njisesom ngub kobur kakl, Nim ini bor heneng ora kao njurukl, Ngaorom tenaol hambunom khorob bu haroklme sao baeben di, menden mangal bu maobowa peb bu haroklme ub di, hambun sao ebe kunaklao ora. ");
INSERT INTO akh_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ngub buklao o tenaol mendbor Wesao Komb Bi Tangar Aondao ora bor maobowa angal buklemi baeben non, mbinim khorob aondao ora ngo lemi sao oran Ngaorom nao kunaklaol, ngubi tomb sao di ereb ora di mbinin kone bor khorob sao ngo lemi ub bao wi aeben ora soklao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Angal ngo, mbes Njises obu bor samom obu bisur beyaol, tenaolon tombao bor sam bereyao o taol dera hae kismil kisesa. ");
INSERT INTO akh_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Bombor ngo tomb Njises obun ingi di haeme wil baeben di mbini dera nan obo habur, mbinim tenaol ngol hasmi baeben bor Njises obu kao kalaoklaob kobur kakl, Naom nje daol angal kang mend kao kao bemin ub dera ib lem laob kismisa. ");
INSERT INTO akh_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ngo tomb tenaol andub ora Njises obu mao tukun sabur, aondao ngo buru pab bu mba hasmi baeben ngub ber mba haenbur mendborom Njises bor kakl, Pangal. Njen am di njen haeme wil baeben di mbini dera nan obo habur nje ib lem kismisa. ");
INSERT INTO akh_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Nao ingi haeme ngo hakl aeb hakl hayem? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ngub kobur kisaon obum tenaol aondao ngo buru akol bu mba hasmi nda baeben elom hondo akol bubur obum mbini bor kakl, Haondaoklaob. Ngo bereyem baeben nao ingi haeme wil ora bereyem kisesa. ");
INSERT INTO akh_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ngub kobur kakl, Tenaol mendbor Ngaorom turi homo bib ko nen sabeyao ub men hakol bu, bu haroklme baeben, ninao ingi maboli haeme ora hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ngo tomb Njisesom ib Kalili mare bor pobur, tenaol hambun bor wakl Ngaoron angal bib ebe nda kao kalokl pisaol, tenaol aondao khorob ora Njises obu hasaol obo kiril mbaesmisa. Ngub obo kiril mbaesmil Njises obu ib taokaoll mend ngol wisao bor honda burubur, obu kang mend moklo ib wi ol sao ib mandaemol birisao tomb tenaol aondao ngo hasmi nda baeben ib mal ngon mare teb sol was bao ha mba hasmisa. ");
INSERT INTO akh_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ngo tomb Njisesom mbini bor Ngaoron angal andub ora, angal mar was ko kao kalobur kisaon obum mbini bor ngub kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Inim oborob ora pangoklwaebe. Aol mondom obun em bor em we tand kokl pisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ngub tand kokl pisao tomb em we ngon mendbor harer tol kolokl baraesaol, sam obobur arer bu nismisa. ");
INSERT INTO akh_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Em we ngon mendbor han kel kel su aondao bu nao wibur, unu ora bor di su oborob nao u taokl hondael tandokl baraesesa. Ngub bisaol em we ngom penar bu ora por kisao o ");
INSERT INTO akh_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","pi oborob nao pe ora sisaol, narom hindisao tomb kaeb so bung bisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ngo tomb em we ngon mendbor den nene haen te bor kolokl baraesaol, den nene hae ngo ora haom mu and sobur, em we ngo men mbaesaol il nao sisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ngo tomb em we ngon mendbor su ebe oral tand kisaol, aondao bu ora sem bu and sobur il andub ora pabklim lisesa. Ngub pabklim lubur kisaon mendborom supu kab kab hor kab pabklim lisesa.* Mendborom supu hakl hakl hor teb pabklim lisesa. Ngub bubur mendborom supu hakl hakl hor su pabklim lisao ko Njisesom angal mar ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Obum ngub kobur mbini bor wakl kakl, Ini angal ngubin te oborob nen saboklme baebenom, angal ngo inin hal ora bor pen oborob ora pangoklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ngo tomb mabor Njises obu hungum hasao tomb obun man pange aol duteb nda di, Njises obun man pange tenaol mendbor obu haru hasmi baeben di, mbinim obu bor njem angal mar ngo kaendan te kao dund bi ko ne mismisa. ");
INSERT INTO akh_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ngub ne mismil obum mbini bor kakl, Ini ngo baeben bor Ngaorom maeb ha maomb bo haraoklao on te mupango wiyao ub hendeklemin ko ngo muwale o, tenaol aeben ngo Ngaorom maeb nao haen hayem baebenom angal mar was andub ora pangoklemi o, mbinim te nen nao saboklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ngub buklemil nim angal mar ngub ko haklwao tomb mbuk waeb bor ke wiyao ub, Mbinim elom hondoklemi o Mbinim menjao hend heneng nao buklemi ora. Mbinim halom di pangoklemi o Mbinim pang heneng bu Nen sab heneng nao buklemi ora. Ngub nen sabokl buwaklemi tomb Mbinin kone di nao baol munuklemil Mbinim khorob bimi sao mbinin kone bor wiyao ub Ngaorom nao kunaklao ora ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ngo tomb Njisesom obun man pange nda baeben bor kakl, Nim angal mar ngo kandan te ora nen sabokl buwayem be? Inim angal mar ngo nda ngub ora nen nao sobaemi sin, mabor angal mar ngub tangar andub ora lowao hakl di, inim asub ora bubur nen saboklemib? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wakl kakl, Pangeklem. Nim aol mondom em we tand kokl pisao kandan te, obum Ngaoron angal bib tenaol hambunon kone bor tand kokl pisao o menger mubur kanda kisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ngub kobur kakl, Tenaol mendbor harerol em we kolokl baraesao nda ubi hayem. Mbinim angal bib ngo pangoklemil, Ngaorom obun angal ebe ngo mbinin kone bor we boklbur buklao o, bombor ngo ora tomb Seranom mbinin kone bor angal bib ngo wi heneng nao bin lao hokl pelen lao ora. ");
INSERT INTO akh_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tenaol mendbor di em we ngo han kel kel su oborob nao wil tand kisao ndabi hayem. Mbinim wen tomb penar bu ora Ngaoron angal bib hem ko pangobur turi aondao ora homoklemi. ");
INSERT INTO akh_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ngub buklemi o mbinin kone ndaon ora bor nao hondaen haklemil, kang baoklmend oran Ngaoron angal bib ngo hem ko nen sab hakol bu haklemi o, mabor aol mendborom Ngaoron angal ebe ngo men mbakl obobur ke mao handaklemi tomb di, mbinin kone bor kend bi sao mend buklao tomb di, mbinim hul ha haklemi ub penar bu tuwabur mbinim hul ha, ha kimb nao buklemi ora. ");
INSERT INTO akh_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Em we mendbor den nene haen te bor kolokl baraesao nda ub menger, Ngaoron angal bib ebe ngo pangoklemi o, ");
INSERT INTO akh_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","sul woroklme sao hambun sao tenaolon kone bor heb mao homa hem mao karaoklao sao baeben, mone momak di ngo sao haklom Ngaoron angal ngo nao hondaen ko tenaolon kone bor men mbaklao ora. Ngub buklaol mbinin kone bor ne sao and nao sen haklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ngub kobur kakl, Tenaol mendbor em we su ebe oral tand kisao ndabi hayem. Mbinim Ngaoron angal bib ngo pangoklemi tomb oborob ora nen sab hakol bu hem aondao ora kobur, tenaol ngo baebenom mbinin kone bor em il sao sen habur, mendborom supu kab kab hor kab pabklim lin haklemi. Mendborom supu hakl hakl hor teb pabklim lin haklemi.* Mendborom supu hakl hakl hor su pabklim lin haklemi ko Njisesom angal maron te ngub kao dund bisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ngo tomb Njisesom mbini bor kakl, Mondom laomb mao dabur be bor bomb pa u, to bundur bor di mupango woroklme be? Ngub inj, laomb ngo mao dabur to mandaemol ora woroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ngub kobur kakl, Hambun sao mupang mba haklao sao baeben di mabor tenaol hambunom hondoklemi. Mbinim hambun sao kowes bu bimi sao baeben di, mabor Ngaorom tenaol hambunom henden muwaloklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Obum ngub kobur kakl, Ini angal ngubin te oborob nen saboklme baebenom, angal ngo inin hal ora bor pen oborob ora pangoklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Njisesom mbini bor wakl kakl, Inim angal ngo pangeklem o oborob ora nen sab hakol bu haklwaebe ora. Njem tenaol mende bor obum khorob ngub baeben ora bisao ko ya pubung lu u haklesi ub, Ngaorom njem khorob buklesi sao di ya pubung lu u haklao o, obum baoklmend kond babur sao ya pubung lu u haklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ngub kobur kakl, Tenaol mondom menjao u harob sin, Ngaorom obu andub ora kond bu kaloklao ora. Ngub inj, mondom menjao nao wi harob sin, obum kang mend u buruklao o di Ngaorom wakl muklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ngo tomb Njisesom wakl kakl, Ngaorom maeb ha maomb bo hayao ub aol mondom obun em bor em we mend tand kisao ub menger maomb bo hayao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Obum ngub kobur kakl, Aol ndam em bor em we tand kao mbabur, somna u paol was, bao bisao tomb tekabur hora besao kon u bao was hasesa. Ngub bubur kisaon obun em bor ne ngo tand kao mbaesao o di, asub was bubur and so hayao ko nao hende ora hasesa. ");
INSERT INTO akh_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Obum ngub nao hende ora hasao o su obun mbib em il ngo por mao ka and mao saesao ora. Ngub por kisao tomb pibnao oran so mbes marisao. Ngub bubur mabor aondao bu ora and sisao tomb il pabklim lisao ora. Ngub il sisaol em il ngo aondao bu ora and sobur naeb soklao tomb, ");
INSERT INTO akh_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","aol em il ngon aorao ndam obun em il ngo kuwim taloklao ko angal mar mend di ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ngo tomb Njisesom wakl kakl, Inim oborob ora nen sabeklemin ko, nim Ngaorom maeb ha maomb bo hayao ub oran nim asub ora menger muklwao? Nim angal mar di asao ora menger mubur lowaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ngub kobur wakl kakl, Ngaorom maeb ha maomb bo hayao ub is il menden imbi sowar il menger maeb ha maomb bo hayao kisesa. Ngub kobur kakl, Sowar il ngo sul wen we boweme tomb sowar il ngo Kao Dund 14:15 kang ndaon inj ora saoklaol, sul we boklme sao baeben hambun saom sowar il ngo men mbae ora saoklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Wakl kakl, Ngub biyao o mabor sowar il ngo por ko and seyao tomb aondao bu ora sem biyaol, em il tangar tangar sao baeben kang was soklaol, sowar il ngom em il hambun ora men mbae ora and soklao ka. Sowar ngom baoklao ke ke bubur sem andub ora biyaol, sao sem hambunom sowar ngon so kumbaem beyao bor and bu burukl engel bimi ko Njisesom angal mar ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ngo tomb Njisesom tenaol hambun bor angal mar andub ora kobur, Ngaoron angal bib ebe ngo mbinim turi homo pangismi ub was kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ngo tomb obum tenaol hambun bor angal bib ngo kao kalisao baebenon ukl bombor ora mend kao pa nao kao kalisesa. Ngub inj, obum angal mar was kobur kao kalo habur kisaon, mabor obun man pange baeben daol mbini was ware pe birismi tomb obum mbini bor angal mar ngo kisao baebenon te kao dund bi was bu hasesa. ");
INSERT INTO akh_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ngo tomb bao bombor ngon ombonao sao nend kam kam bisao tomb Njisesom obun man pange baeben bor kakl, Naom ib mal aondao ngon mende nan mbi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ngo tomb Njises obu di obun man pange baeben di, mbinim tenaol aondao ngo hasmi nda baeben ngol bao haen ib taokaoll ngo Njises obu honda birisao nda bor, obun man pange baeben di mbini hambun baoraoklbir pismil, ib taokaoll tangar mendbor di mbini haru pismisa. ");
INSERT INTO akh_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ngub pismi tomb ib mal aondao ngo bor posabsu aondao ora obobur kisaon, ib aondao bu ora lu taongul taongul ko, lu dengeno taokl en aeben bisao ndam ib taokaoll ngon ndaon bor ib aondao bu ora lu dengno tu ndabur, tumbi hakl ke ke bisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ngo tomb Njises ib taokaoll ngon kungni nan o bor obun wesmbao kand ubur u paol pe wisao nda, mbinim obu mao tekabur kakl, Aol aondao o, nao ngubi tomb ora ngo ib no pe barakl ke ke bu bum hayom ngao, njem nao hem nao kal be? kismisa. ");
INSERT INTO akh_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ngo tomb Njises obu teka peyo, posabsu aondao ngo ibisao nda makl homo taolu lubur, ib aondao ngo lu dengno taokl en aeben bisao nda bor kakl, Ngub nao bi kur kao ora kisesa. Ngub kisaol posabsu aondao ngo ubukl hasao nda kur kao paesaol, ib aondao ngo lu dengno taokl en aeben bisao ndam di, ora kang ora di el el nao bi sowa paesesa. ");
INSERT INTO akh_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ngo tomb Njisesom obun man pange nda baeben bor kakl, Inim asub ko ngub pakl hemeklem? Inim Ngaorol hul nao hae haroklme be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ngo tomb obun man pange baebenom Njises obum ngo bisao sao hondobur, burir biyu pakl aondao ora homobur mbini hakl hakl kakl, Wao. Posabsu hesa ib kabom hul nao hae angal pangen ke aol ngo obu aeb e bo? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ngo tomb Njises di obun man pange aol nda baeben di, mbinim ib mal aondao ngon mare mende nan, aol sem Ngerasa semon su bor po pindib paesmisa. ");
INSERT INTO akh_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ngo tomb mbinim ngub pindib paesmi tomb Njises obu ib taokaoll nda ngol bao win sul hond hasao tomb, aol umubaoli obun tombao bor sam biri mend obum aol maol bor and waru paolam akol bu hasao o, penar bu ora Njises hen mukl ibisesa. ");
INSERT INTO akh_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Aol umubaoli ngo obu aol maol bor was and waru paolu hasaol, aol mendborom obu sen yam di ki aongao kab munu tangaesmi o, ngo hakl lokl pe win paokl was pisaol, mondom obu ora mao pao kakl buwaesmisa. ");
INSERT INTO akh_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ngub bisaol hondobur mbinim aol umubaoli ngo hor hor was sen yam di hankabom di ki aongao kab munu tangaesmi o, obum sen ya ngo di hankab ngo hakl di, ya demi sao munu loklo bowes bu u mbaklbir paokl was pobur, obu buri ora sisaol mbinim obu men hakl buwaesmisa. ");
INSERT INTO akh_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ngo tomb aol umubaoli ngo obum hora di somna di aol maol bor hesa harbor manda bor kab was akol bu habur, obum kaong aondao bu ora lubur kisaon, obun mbib obun toklol arem heya kaob kaob bu ke bu mango hasesa. ");
INSERT INTO akh_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","Ngub bu hasao o Njises obu wen enderael sao ibisaol hondobur, aol umubaoli ngo obun tombao bor sam biri ndam akl was Njises hen mukl ibisesa. Ngub ibisaol Njisesom kakl, Sam sokoll o nje kho ora berel ngao, aolon tombao ndaon bor nao biri dera pib ora kisesa. Ngub kisaol aol umubaoli ngo obun tombao bor sam biri ndam akl was Njises hasaol teb so obo dombes ubur, obum Njises bor angal aondao bu ora kobur kakl, Njises o nje Ngaor aondao yubu oran Isi hael ngao, njem ni bor asub ko ora ke mao handakl ibil balem? Nim Ngaor aondao heneng heneng was laon imbi bor ora kakl ngao, njem ni bor tenda mao na khorob nao bukl ib alem kisesa. ");
INSERT INTO akh_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ngub kisaol Njisesom obu bor ne mubur kakl, Njen imbi aeb kisaol, aol obun tombao bor sam biri ndam kakl, Nao sam sem ndi nao minib se andub ora bereyom ol, ninao imbi Ndi Nao Minib Se kisesa. ");
INSERT INTO akh_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ngo tomb aol umubaoli ndam sam ngo obun tombao bor birisao om kao kisao ub Njises bor buri palo kao deb deb bubur kakl, Njem mbini su tangar bor oran nao pen kaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ngo tomb harbor manda kang mend teb sol sao wisao on some sem aondao andub ora mend pil nao mba hasmil hondobur, ");
INSERT INTO akh_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","sam ngo aolon tombao bor birismi nda baebenom Njises bor wakl was kao deb deb bubur kakl, Naom some aondao ngo pil nao mba hayem baebenon tombao bor haondaomun ub, njem nao some ngo baeben hayem o bor ora puklub kaebe kismisa. ");
INSERT INTO akh_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ngub kismil Njisesom mbini bor kakl, Ebe ka. Inim ngo lem ub bib kisaol, sam aondao ngo aolon tombao bor birismi nda baebenom aol ndan tombao bor baoraoklbir kismin, some nda baebenon tombao bor was hondakl engel bismisa. Ngub bismil some buklhoma iri non bi andub ora 2,000 ngo hasmi nda baeben su bare kho ora mendbor akl was hellenj kao mi pobur, ib mal aondao mend wisao o bor was bongeyokl engel bismil, hambun ora ib no pe baraesmisa. ");
INSERT INTO akh_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ngo tomb aol some ngo baeben kalo hasmi nda baebenom ngo bisao sao haondaoklbir pakl khorob ora akl was pobur kismin, mbinin su and lobokl lobokl aondao baeben bor di, su and te kang kang baeben bor di, mbinim ngo hindismi sao tenaol hambunom ora pangen kam buri kismil, tenaol hambun su ngo baeben bor birismi baebenom ngo bisao sao hondokl ibismisa. ");
INSERT INTO akh_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ngo tomb tenaol hambunom Njises hasaol ngub obobur kismin, mbinim aol ngo mbes obun tombao bor sam birisao nda hindismi tomb wakl obun kone anda ibisaol, obum oborob lab lab hakl bombo as ko birisaol hondobur, burisao po pakl aondao ora himismisa. ");
INSERT INTO akh_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ngo tomb mbini tenaol ngo aolon tombao bor sam birisao o Njisesom taol deraesaol hindismi nda baebenom, tenaol aondao ngo wen ibismi nda baeben pangen ko sam taol deraesaon arman di, some aondao nda baeben ib no pe baraesmi on arman di hambun sao kao kalismisa. ");
INSERT INTO akh_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ngub kismi tomb tenaol aondao ngo obo hasmi nda baebenom angal ngo pangobur, mbinim pakl aondao ora homobur Njises bor kakl, Aol o, nje naon su ngol nao hae su tangar bor paokl pu ora ko kao deb deb bismisa. ");
INSERT INTO akh_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ngub kismil Njises obu paokl poklbur ib taoklaoll on hond ya birisao tomb, aol ngo obun tombao bor mbes sam birisao ndam Njises bor ni yao haru poklbao ora ko kao deb deb bisesa. ");
INSERT INTO akh_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ngub kisao o aol umubaoli o wakl ebe mao saesao ndam ngo kisao ub Njisesom e nao ke inj kobur obu bor kakl, Njem njen anda njen sem baeben haeme bor pobur lesin, Aorao Aondaom nje hond aondao ora homobur banda ub di, nje bor hambun sao bandisao baeben tenaol hambunom ora pangen ub kao kalam pu ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ngo tomb aol obun tombao bor sam birisao o wakl ebe sisao ndam pobur kisaon, obum su and lobokl lobokl aondao menden imbi Dikapolis bor pobur, Njisesom obu bor bisao sao hambun sao tenaol hambunom pangen kao kalisaol, tenaol hambunom arman ngo pangobur kismin burir aondao ora bismisa. ");
INSERT INTO akh_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ngo tomb Njises obu ib taokaoll on honda baoraoklbir ib mal aondao ngon tukunol kombe kobabur, wakl ib mare mende nan po pindib aesao tomb tenaol andub ora Njises obu ngo obo pindib paesao ol obo kiril mbaesmisa. ");
INSERT INTO akh_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ngo tomb aol bombor mend obun imbi Njaras, obu Nju semon man pangoklme anda maomb bo haraoklao aol hasao o obu di obobur, obum Njises hondobur kisaon Njiseson aongao ma teb so ora bor obo tumu kar munu dombes wisesa. ");
INSERT INTO akh_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ngub dombes ubur obum Njises bor taeki ko kao deb deb bubur kakl, Nao wane kang mend yao o ngubi tomb ora penar bu pe pakl ke ke bi bereyao ora. Ngub beyaong njen kim obu waraklesi tomb obu sen ngo ha wiyao ub di wakl ebe soklaol obu enjaokl poklaong, njem nao wane kang ngo njen kim men mbanin ub nje nao anda mbao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ngub kisaol Njises obu Njarason anda mbibi haru pisbil, tenaol andub ora Njises taol mi obobur kismin, mbinim Njises obu dengi mbaen ora dengeb dengeb kao mi ibismisa. ");
INSERT INTO akh_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ngo tomb ten is mend obu bullim anda buru kimb was bisao o, obum bao hor hambunon ngub bao ber ha haen was karasmas duteb oran pibi hasesa. ");
INSERT INTO akh_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ngub buru hasao tomb ten ngom dokta baebenom obun sen ngo hasao ub ebe mao saen ko dokta ngo baeben bor obun mone di andub ora kalisao o, mondom obun sen ngo ebe nao mao saesao tomb obun kone bor kho so kend bin was birisesa. Ngub bisaol ten ngo obun sen ngo hasao ub di aondao bu and sam sam was bisesa. ");
INSERT INTO akh_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ngub bisao o ten ngo obum Njisesom bu hasao sao arman pangobur kisaon, obum Njises hasaol obobur tenaol aondao ngo dengeb dengeb kao mi pubukl hasmi darukl o bor obu di ibisesa. Ngub obobur kisaon obum Njiseson mesao nan obobur ");
INSERT INTO akh_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","obun kone bor kao ndan sabur kakl, Nim Njiseson lab lab oral waraklwao tomb di nao sen ngo hae ub ebe bao soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ten ndam ngub ora nen sabisao o sisaol, obum Njiseson lab labol ngub waraesao tomb penar bu ora bombor ngo ora tomb obun bullim nda ngo ber kimb was bu hasao nda bao kur kisaol, ten ngom obun toklol sisab bu misesa. Ngub bisaol nao sen ngo ora sa ko bao mao bemberaesesa. ");
INSERT INTO akh_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ngo tomb Njisesom obun toklo bor mao bemberaesaol, obun buri mendbor ten ngo Njises obun lab labol waraesao ndan toklo bor pisao ub mao bemberabur kisaon, obum tenaol aondao ngo hasmi nda daruklol obun mesao nan hasmi baeben baol munu hondobur kakl, Nao lab labol aebeom waraeb? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ngub kisaol Njises obun man pange baebenom obu bor kakl, Hend. Tenaol aondao andub ora nje hael ol ngo dengeb dengeb kao mba hayem ngao, njem asub ko nao lab labol aebom waraeb kal? kismisa. ");
INSERT INTO akh_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ngo tomb Njisesom obun lab labol ngo waraesao ub aebom ora beneb ko hondoklbur, obun elom tenaol hambun ora hondo sa kam akol bisesa. ");
INSERT INTO akh_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ngo tomb ten ndam Njiseson lab labol waraesao tomb obun sen ngo ebe sisao ub ora hindisaol, nim mupangokl buwaklwao ko nen sabobur kisaon, obum pakl homo dur kobur Njiseson aongao ma teb so bor obo dombes ubur, obum nim ora buwao ko kao pa obun arman hambun sao Njisesom pangen kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ngub kao kalisaol Njisesom ten nda bor kakl, Nao wane ka, njem nil hul ha harili saom ora njen sen ngo ebe saokl ngao, njen sen ngo di ebe sandal ko mende nao homoklesing, njen kone bor sub tibaen as kor ora pebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ngo tomb Njises obum angal ngub bao kakl haen was, aol mendbor Nju semon man pangoklme anda maomb bo haraoklao aol ngon anda hakl obobur, mbinim aol Njaras ngo bor kakl, Njen wane nda ora pe parob ngao, njem aol aondao ngo obu baehaemen harer haebeb asub ko kemi poklbur bil? kismisa. ");
INSERT INTO akh_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ngub kismi o Njisesom mbinim angal ngo kam ibismi ub nao pange non bubur, obum aol Njaras ngo bor kakl, Njem burir biyu hem nao ke nil hul ha haebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ngo tomb Njises obum ngub kobur kisaon, tenaol aondao ngo hasmi nda baeben obu haru mbi nao ke ini hambun ora bao haklwaebe kaoklbir obum Pita di Njon Njemus kab haemeyakl di, ngo baeben ora Njises obu haru pismisa. ");
INSERT INTO akh_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mbinim ngub pobur Nju semon man pangoklme anda maomb bo haraoklao aol ndan anda po pindib paesmi tomb Njisesom hindisaol, tenaol mendbor nong kang ngo himisao o hombara ber mba hasmi baebenom angal erer ko de aondao bu ora wi allbob ko men mba hasmisa. ");
INSERT INTO akh_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ngo tomb Njises obu andaon hondabur obum tenaol ngo de kao mba hasmi nda baeben bor kakl, Nong kang ngo obu ora nao pe pae u palu wing, inim asub ko angal erer aondao bu ora ko de aondao bu ora kao mba harmib? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ngub kisaol tenaol ngo hombora birismi nda baebenom nong ngo obu ora pe parob nda o le ko pangobur kismin, mbinim Njises obu bor khorob ora kir ko maobowaesmisa. Ngub bismi o Njisesom tenaol ngo baeben hambun dera puklub ora ko taol derabur kisaon, obum nong kang ngo himisao ndan ingi aorao kab di, obun man pange aol is teb o haru ibisao nda baeben di, obum ngo baeben oran haru and tubal ngo nong pe pae ngo u mba hasao nda bor hondaesmisa. ");
INSERT INTO akh_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ngub hondaesmi tomb Njisesom nong kang ngo pe pa wisao ndan kil men mubur nong pe pae ngo bor kakl, Talita kumi kisaol, angal ngon te naom angal heneng kobur, nong kang ngo e, nim nje bor kakl ngao nje teka ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ngub kisaol nong kang ndam penar bu ora teka peyobur harer pibisesa. Ngub bisao o nong kang ngo obu obun amom obu marisao o di karasmas duteb sisao tomb, nong kang ngo obu pe paesao o Njisesom obu ngo wakl mao enjaesao nda ub hondobur, mbinim pakl aondao ora homo burisao po u pismisa. ");
INSERT INTO akh_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ngo tomb Njisesom mbini bor angal buriyab ora kobur kakl, Pangeklem. Nim ngub baonao ko tenaol tangar mondom pangen nao kao kaloklwaebe ora kisesa. Obum mbini bor wakl kakl, Nong kang ngo obu ne kang mendbor nen kalaoklaob kisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ngo tomb Njises obu su ngol haklbir obun su Nasarer bor pisaol, obun man pange baeben di obu taol mi ibismil mbini haru pismisa. ");
INSERT INTO akh_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Mbinim su ngo bor po hasmi tomb Nju semon hor boroklme bao on Njises obum mbinin man pangoklme anda bor hondabur kisaon, obum tenaol hambun bor Nagaoron angal bib ebe nda kao kalisaol, tenaol andubom ora obum mbini bor angal ngo kao kalisao nda pangobur burir biyubur mbini hakl hakl kao kao bubur kakl, Wao. Aol ngo obum angal ngo le o, obu aebom kao kalaonao ub le bo? Obum kone oborob ora kikil bimi ngubi di aeben kone o maonao? Obum asub ora bubur tenaolom ko mend nao hindismi sao ngubi ngo bu hae bo? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mbinim ngub kobur kakl, Aol ngo obu kabnda biyao aol inj ye be? Wao. Obun am di Mariya inj ye sa bo? Obun haeme baeben Njemus Njoses kab di, Njuras hesa Simon kab di, ngo baeben daol obun haeme sanda ka. Obum mbaoli baeben di enjo nao buru hayom ngao, obum asub ko man ko ngub beb kobur kismin, mbinim Njises obu makl aondao ora homo mesao kalismisa. ");
INSERT INTO akh_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ngub kismi o Njisesom mbini bor kakl, Man mini aol mondom Ngaoron man tenaol hambunom pangen kam akol bu haklao tomb su hambun bor obun imbi wi ngaklao o, obun su and te ora bor di, obun sem ora baeben haeme ol di, obun anda ora ol di ngo baeben bor obun imbi nao uklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ngo tomb obun sem ora ngo baebenom obul ngub hul ha nao hasmil, Njises obum tenaolom ko mend nao hindismi sao di su ngo bor tenaolom henden nao bi, obum mbini asub ora bisur bukl inj sisaol bao wabur kisaon, obum tenaol mendbor bombor bombor sen ha wismi baeben, obun kim men mba peb bubur mao enja was bisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ngo tomb mbinim obul ngub hul ha nao haebur obun angal di ngub nao pangismil, obum mbinim asub ko bim ko nen sabokl buwaesesa. Ngo tomb obum su bombor ngon was and te tangar tangar wisao baeben bor akol akol bubur, obum tenaol hambun bor Ngaoron angal bib ebe ngo kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ngub bubur kisaon obum obun man pange aol duteb nda baeben ubuklub kobur, mbinim tenaolon tombao bor sam buruklao hakl di taol dera peb bin ko, mbini bor obun buri taol bu kalisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Ngo tomb Njisesom mbini bor kakl, Inim harer poboklbur mini pubuklmi sao baeben oran kang ora di nao mini puklwaebe ora. Pangeklem. Inim ne noklme sao di inin nu di mone di ngo sao hakl man man bu nao marakl wi paokl ora puklwaebe. Aoh, inim aongao su di bombor was bu mbaklbir inin hakla tom di ta peb bu munubur lemin, siyor di mende nao mari bombor bu haklemi o was bu taokl puklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Njisesom mbini bor wakl kakl, Inim su and te mendel poklemi tomb mondom ini turi homobur ini nao anda bor paolemin ubuklub kaem sin, inim su ngo bor bao haklemi anga tomb and ngon was bao haklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Inim su hambun bor akol akol buklemi tomb tenaol su and te mendbor buruklemi baebenom ini oborob obaeming ubuklub ko, mbinin anda bor ini paolemin ubuklub ko ngub nao bibur mbinim inin angal di nao pangaem sin, inin aongao bor su huni haklao o di mbinim mabor ke aondao ora hondoklemi ub menger, mbinin su and te ngo bor bao win tandoklo tuwaklbir inim su ngo di tuwakl paokl ora puklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ngo tomb aol duteb ndam su ngol haklbir kismin, mbinim su tangar tangar bor buri kobur, tenaol hambun bor inim khorob bimi sao tuwabur inin kone baol monoklwaebe ko kao kalam akol bismisa. ");
INSERT INTO akh_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ngub bubur kismin mbinim tenaol andub oran tombao bor sam birisao baeben di taol dera peb bismisa. Mbinim tenaol andub ora mendbor sen aondao bu ora ha homo wismi baeben di mbinin wesmbaol wel sulabur kismin mao enja peb bismisa. ");
INSERT INTO akh_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","16","Ngo tomb ma ora bor Njisesom hambun sao bu hasao sao tenaol hambunom kam aeben aeben bismil, su hambun bor ora obun arman pib ngaesesa. Ngub bisaol tenaol mendborom Njisesom hambun sao ngo sao baeben bu hayao ko nen nao sabebur kismin, Njon Mbabtas Biyao Aol obum mbes hambun sao bu hasndis ub, ngubi tomb obun maol bor wakl enjaokl pobur obum hambun sao aondao bu buri palo bu hae ko kam aeben aeben bismil, aol wesmbao Heror ndam di pangisesa. Ngub kismi o tenaol mendborom kakl, Aol ngo obu Ngaoron man mini aol mbes hasao o obu Ilanja ye kismi o mendborom kakl, Obu Ngaoron man mini aol mbes hasmi ubi mend pindib panao ye kismisa. Ngo tomb aol wesmbao Heror ndam Njisesom bu hasao sao ngub kam aeben aeben bismil pangobur kakl, Nim mbes Njon Mbabtas Biyao Aol ngo obu pe paen lundis o, ngubi tomb obun maol bor wakl enjaokl pene saol kisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Ngo tomb aol Heror obu su ngon aol wesmbao ora habur kisaon, obum obun haeme Pilibon were Heroriyas heb aondao ora homobur obu akl ba hasesa. Ngub bisaol Njon Mbabtas Biyao aolom aol wesmbao Heror ngo bor kakl, Njem njen haemen were ngo akl ba haril ub ebe inj, njem khorob aondao ora baenda ko kao kal was bisaol, ten Heroriyasom Njon Mbabtas Biyao Aol ko aondao ora homobur, aol Njon ngo mondom pe paen mao laklwao ko nen sabisesa. Ngub nen sabisaol aol wesmbao aondao Heror ngom obun polisman mendbor ubuklub kobur mbini bor kakl, Inim Njon Mbabtas Biyao Aol obu men habur kalabus anda bor hend ha ndi mbakl puklub kisesa. Ngo tomb ten Heroriyas ngom Njon ngub lu tuwaen ko nen sab sab bisao o, aol wesmbao Heror aondao ngo obum Njon Mbabtas Biyao Aol obu kone dund se wi, Ngaorom komb bi hae ora hae ko nen sabobur obum Njon Mbabtas Biyao Aol ngo pe paen libi pakl himisaol, ten Heroriyas ngom Njon Mbabtas Biyao Aol pe paen lukl buwaesesa. Ngo tomb aol wesmbao Heror ngom ngub nen sabobur, obum Njon Mbabtas Biyao Aol kalabus anda bor di oborob was maeb habur kisaon, aol wesmbao Heror ngo obu bor Njonom man mendbor kao kalisao tomb obum pakl homo burir biyubur obun kone bor taol taol bisao o, Njon Mbabtas Biyao Aolom angal ngo kisao sao baeben hem ko wakl was pangisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ngo tomb mabor ten Heroriyasom Njon Mbabtas Biyao Aol pe paen luklao on ib ngub mao paesesa. Ko mend oran aol wesmbao Heror obun amom obu marisao bao o pindib paesaol, obum aol aondao mendbor Heror obu daol haru maomb bo haroklme aol aondaol baeben di, ami sem maomb bo haroklme aol mendbor di, su Kalili aol homa aondao mendbor di, ngo baeben daol haru noklbur ne bombor mend harubur kisaon, ne ngo nemin ubuklub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ngo tomb ten Heroriyason wane is mend birisao ndam mbini ngo ne nao mba hasmi ndal san ponam ibisaol, aol wesmbao Heror aondao ngo obu di, aol aondao ngo obu daol haru ne nao mba hasmi nda baeben di, mbinim nong ngo turi aondao ora homobur heb himismisa. Ngub heb homobur aol wesmbao Heror ngom nong nda bor kakl, Heneng ora njem ni bor turi homo ngo sao ora nji ko kao njuklesi sao njuklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ngo tomb obum nong nda bor wakl mao kobur kakl, Heneng ora njem ni bor bombor sao mend ngo sao ora nji ko kao njuklesi sao bao njuklwao ora ka. Pangal. Njem ni bor su keklaeb mende nan baeben hambun bao tom u nji kae sin di, ngub bao njuklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ngo tomb nong ndam ngub san pono haklbir kisaon, obum am Heroriyas nda birisaol pobur obun am ngo bor kakl, Aol wesmbao Heror ndam ni bor ngub kang, nim obu bor asao ora nji lowaob? kisesa. Ngub kisaol ten Heroriyasom obun wane ngo bor karu mao kikil babur kakl, Njem obu bor Njon Mbabtas Biyao Aolon ma kaol pae ora nji kaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ngo tomb nong ndam aol wesmbao Heror aondao nda birisaol penar bu ora obobur obu bor kakl, Njem penar bu ngubi ora tomb Njon Mbabtas Biyao Aolon wesmbao kao pae oran peler barnao oral ubur nji ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nong ndam ngub kisaol, aol wesmbao Herorom obun kone bor kho so hem aondao ora kisao o, aol aondao ngo ne no birismi nda baebenom di pangen obum mao kobur, njem nji lesi sao bao njuklwao ora kao minisao nda ub nen sabobur, obum nong ngon angal nao peklwao ora ko nen sabisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ngo tomb Herorom ngub nen sabobur kisaon penar bu ora polisman is mend bor kakl, Njem Njonon Wesmbao kaol pae mini ebenin ub ma peyu tukl pu kisesa. Ngub kisaol polisman ndam kalabus anda bor pobur kisaon, Njon Mbabtas Biyao Aolon ma pesesa. ");
INSERT INTO akh_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ngub ma peyubur kisaon Njonon wesmbao kaol pae nda peler barnao mendel u mini obobur nong nda kalisaol, nong ndam obun am mini po kalisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ngo tomb Njon Mbabtas Biyao Aolon man pange aol baebenom Njon ngub ma peyaem ke pangobur, mbinim Njonon toklo tukl pobur maol bismisa. ");
INSERT INTO akh_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ngo tomb aol mendbor Ngaoron angal bib kam akol bukl pismi nda baeben wakl obobur kismin, Njises daol maomunu burubur mbinim tenaol hambun bor angal bib hobao sao ngo kao kalam akol bismi ub di, mbinim bismi sao baeben hambun sao Njisesom pangen arman kao kalismisa. ");
INSERT INTO akh_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ngo tomb tenaol andub ora pukl akl barukl bu dengeb dengeb was kismil, Njises di obun man pange aol ngo baeben di mbinin ne winbur o, ne naeb se ko kang mend nao wisaol mbinim ne nokl buwaesmisa. Ngub nokl buwabur Njisesom obun man pange nda baeben bor kakl, Nao was ware pe ora su tenaol nao biri bor pobur, inim Ngaoron angal bib hobao sao kam akol bu kongon was bu hakl obaemndang, inim mesao dundukl peb bu kang mend hor so bereklemin ub mbi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ngo tomb Njises di obun man pange aol nda baeben di mbini was ware pe ora ib taokaoll on baoraoklbir su tenaol nao biri ora mend sisao o bor poklbur kismin pismisa. ");
INSERT INTO akh_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ngub pismi o tenaol aondao andub ora su and lobokl lobokl hambun bor hakl ibismi baeben hambunom, Njises di obun man pange baeben di ngo pismi nda ub mbini ngo baeben ora ngo beyem o ko hondobur kismin, tenaol andub ora ngo nda baebenom mbini mbes su kang ngo Njises obu pokl bisao nda bor po kiril mba birismisa. ");
INSERT INTO akh_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ngo tomb Njisesom ib marel po pindib pabur hindisaol tenaol andub ora some sib aorao nao hae menger hasmil hondobur, obum mbini hond homo hem aondao ora kobur, obum tenaol aondao ngo bu mba hasmi nda baeben bor Ngaoron angal bib ebe andub ora kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ngo tomb ombonao nar anda hondaesao tomb Njiseson man pange aol nda baebenom Njises birisaol obobur mbinim obu bor kakl, Nar anda hondaeng naom su ngo bor tenaol nao biri bor ora hayom ngao, ");
INSERT INTO akh_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","tenaol aondao ngo hayem baeben mbini dem homoklemi, su and he tenaol biri sisao mbinin ne hakl es bu dob bam buri ken kao kismisa. ");
INSERT INTO akh_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Inim mbini ne taol bu kalaoklaob ora kisesa. Ngub kisaol mbinim obu bor kakl, Wao. Naom tenaol aondao ngo hayem baeben mone so andub ora, supu hakl hakl hor tobon kabom palawe dob bukl pobur nen taol bu kalaomun ko kal be? kismisa. ");
INSERT INTO akh_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ngub kismil Njisesom obun man pange ngo baeben bor kakl, Inin palawe asub baeben ora waemib ko hondokl puklub kisaol, mbinim haondaokl obobur kakl, Naon palawe pao su mend di, ib wen is kab bu ngo ora wiyom kismisa. ");
INSERT INTO akh_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ngub kismil Njisesom obun man pange aol nda baeben bor kakl, Tenaol aondao ngo baeben hambun, homa naom so ebe mend sisaol mbini ti tom tom bu buru lobokl bin laob kisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ngo tomb tenaol hambun sul baoraokl baoraokl pismil ndi minismi tomb ti tom mend lobokl bu birismi baeben supu hakl hakl hor dowa birismisa. Ti tom mende lobokl bu birismi on supu kab kab hor kabol hor tebo nan on tobon kab was birismisa. ");
INSERT INTO akh_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ngub ber mba hasmi tomb Njisesom palawe pao su nda hesa ib wen is kab nda kab mu munu, obum yu heben bor hend ya Ngaor bor tengiyu kao peyobur, obum palawe nda munu konde barabur kisaon, obum obun man pange aol nda baeben bor tenaol hambun taol bu kalaoklaob ko kalisesa. Ngub bubur kisaon ib wen is kab nda di bombor ngub was munu konde barabur tenaol hambun taol bu kalisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ngub taol bu kalisao tomb tenaol hambunom ebe no tombao hasmisa. ");
INSERT INTO akh_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ngub no tombao hasmil palawe nda hesa ib wen nda kabon nokl nao bisao bao win waesmi baeben, mbasker nu tokl duteb oran tumbi haen was mar pa wismisa. ");
INSERT INTO akh_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ngo tomb aol palawe ngo nismi baeben ndi minismi tomb buklhoma iri non bi andub ora 5,000 oran sisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Bombor ngo tomb Njisesom obun man pange aol nda baeben bor, inim penar bu ora ib taokaollon honda baoraoklbir ib mal aondao ngon mende nan su Bersara mbin ub ini mbes pukl baoraoklaob kobur, mbini pismi tomb obu bombor ora bao habur kisaon tenaol aondao ngo ne taol bu kalismi nda baeben di obum inin anda puklub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ngo tomb obum tenaol aondao ngo hasmi nda baeben ngub anda pen kaoklbir kisaon, obu hungum ora yu manda mend sisao bor yin pobur Ngaor bor kao kalokl pisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ngo tomb nar anda bombisaol em hundur u mbaesao tomb ib taokaoll ngo Njises obun man pange aol baeben puklub kisao nda, ib mal aondao ngon tukun ora bor pismi tomb Njises obu yu manda ngol bao hasesa. ");
INSERT INTO akh_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Obum ngub habur hindisaol ib taokaoll ngo obun man pange baeben baoraokl pismi nda hindisao tomb, posabsu aondao ora ibisao ndam ib taokaoll nda baol munukl ke ke bisaol, mbinim ib oborob aebeyokl buwaesmil hindisesa. Ngo tomb wen bao buklbur hoklob kebeyam ibisao o bao ora nao bu hebe kobae em hundur bao u mba haenbur sisaol, Njises obu obun man pange aol nda baeben pukl hasmi ndal ib hu kemol aongao hakl hakl obo, mbini ubukl wismi o baondib pakl pibi hasesa. ");
INSERT INTO akh_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ngo tomb Njiseson man pange aol nda baebenom obu ib hu kem kem ngub aongao hakl hakl pibi hasaol hondobur, mbinim domo aol wesao mend e ko nen sabobur kismin, mbinim karaklae aondao ora ko ki aongao ha peb bu u pismisa. ");
INSERT INTO akh_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Mbini hambunom ngub bisaol hondobur, ora pakl homo burisao kab po u pismil, Njises obu wakl baol maonaokl obo mbini bor penar bu ora angal kao kalobur kakl, Ni Njises ora ebeng, inim pakl nao heme inin kone bor hul ha saor peyo ora baoraoklaob kisesa. ");
INSERT INTO akh_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ngub kobur kisaon obum ib taokaoll ndaon hondabur, obun man pange aol nda baeben daol haru birismi tomb posabsu aondao ngo ibisao nda kur kisesa. Ngo tomb Njiseson man pange aol nda baebenom mbinin kone bor pakl aondao ora homobur burisao po u pismisa. ");
INSERT INTO akh_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Mbinim ngub pakl bu mba haen was birismi o, Njises obum palawe pao su tenaol andubom ngaorukl pelen, nao nao ngaeb se mend tenaol hambunom no makl hemen taol bu kalisao nda ub oborob nen sab hakol bu, obum hambun sao ebe bib se hae ko nen nao sabe kone awis ora birismil, mbinim pakl ngub bao hom hakol bismisa. ");
INSERT INTO akh_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ngo tomb mbinim taokaollon ngub baoraoklbir ib mal aondao ngon mare mende nan su Kenesarer wisaol, su ngon teb so bor ib marel po pindib pabur ib taokaoll nda di ib mare ngol bao u mbaesmisa. ");
INSERT INTO akh_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mbinin taokaoll ngub bao u mbaesmi tomb tenaol hambunom obu Njises ora ebe ko haondaoklbir kismin, ");
INSERT INTO akh_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","mbinim akl was su Kenesarer ngo bor su wisao baeben hambun bor buri kobur, tenaol sen kam mundub mundub ha homo wismi baeben Njises obu abor ora haeb kam kam bubur, obum mbini mao enjaen ko obu hasaol was kab bu bara taokl obo ukl engel bismisa. ");
INSERT INTO akh_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ngo tomb su and te kang baeben hambun bor di, su and lobokl lobokl aondao baeben hambun bor di, ora su hambun Njises obu akol bu hasao baeben bor, tenaol sen kam mundub mundub ha homo wismi baeben hambun mbini taokl obobur homa tukunol was tu ukl engel bismisa. Ngub bubur kismin mbinim Njises bor kao deb deb bubur kakl, Tenaol andub ora e ngao, njem tenaol sen ha berae ngo baebenom mbini wakl enjaokl pen ub njen lab lab kungni bor warakl engel bin waebe kismisa. Ngub kismil tenaol sen ha barae ngo wismi nda baebenom Njiseson lab lab kungni bor warakl engel bismi tomb mbini hambun ebe bao was sisesa. ");
INSERT INTO akh_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Ngo tomb Peresi sem di Nju sem baeben hambun di mbini ngo baeben hambunom mbinin ab sumbom bismi ub mbinin ki wes wes mbes lu, oborob warer bubur was ne no haroklme. Mbinin ab sumbon manom bibi ora ke wisao ub ki wes wes nao li sin, mbinim de bu winbur di ne nao noklme. Mbinim maker hakl anda obobur di, mbinin abon man bu paolismi ub mbinin ki wes wes mbes nao libur sa sin ne ora nao noklme. Mbinin abon man andub mendbor di bismi ub mbinin sosben di kab peler di ngo sao hakl wes wes lu oborob ora warer bubur was no haroklme. Ngub bu haroklme o mbini Peresi sem ngo baebenon mendbor di, Nju semon man buwaloklme aol baebenon mendbor di, Njurusalem bor haklbir Njises obu hasaol obo kiril mbaesmisa. Ngub ibismi tomb Njiseson man pange aol baebenom mbinin ki wes wes lu warer nao bibur ne bao nismil hindismisa. ");
INSERT INTO akh_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ngub hondobur Peresi aol nda baeben hesa Nju semon man buwaloklme aol nda baeben kabom Njises bor ne mubur kakl, Njen man pange aol ngo baebenom asub ko naon ab sumbon man hul habur, mbinin ki wes wes lu warer nao bi ne bao was no haroklmeb? kismisa. ");
INSERT INTO akh_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Ini songolol aol hobao o hakl o, mbes Ngaoron man mini aol Asayam inim heneng ora ngub buklemi ko mbuk waeb ngub bu wisao. Tenaol ngo baebenom mbinin ne komb pae bor Ni bor kaoya lome o ");
INSERT INTO akh_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mbinin kone bor Ngaor nao honda hae Enderael haenbur lome. Mbinim aol henengon man ora ko habur o Naom Ngaoron man ko hayom lome. Mbinim ngub bimil Mbinim ni bor kaoya ko hor bere ko boroklme ub Baehaemen ora boroklme ko mbes man mini aol Asayam mbuk waeb bu wisao ub Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ngo tomb Njisesom wakl kakl, Inim aol henengon man non oborob ora men hakol bimi o, Ngaorom bibi keyao ub nao bibur hul was haroklme ka. ");
INSERT INTO akh_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Inim inin ab sumbom bismi ub turi homo ora bu habur, Ngaoron man wiyao sao nao hende non bubur khorob ora hala mba hayem alem kisesa. ");
INSERT INTO akh_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Njisesom ngub kobur kakl, Ngaorom Moses bor kao kisao ub Mosesom ngub kisao. Inin am ab kab bor ebekone nao pe oborob ora hond homo bisur bibaebe. Ngub inj, mondom obun am ab kab bor khorob bu angal kho ka sin, obu ora pe paen libaebe ke wiyao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Njisesom ngub kobur kakl, Ngub ke wiyao o inim ngub lome. Aol mone di hambun sao maru u haeme baebenom kakl, Nao am ab kab o, nim mone ngo di osisao ngo hakl ibi bisur bu njukl buwao o, nim mbes Ngaor bor kaloklwao ko kao beyawe sal, ");
INSERT INTO akh_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","nim ibi bisur bu nao njuklwao ora lome. Ngub kobur mbinin ingi aorao kab bor bisur bu oborob sao nao bimi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Njisesom ngub kobur kakl, Inim ngub bu hayem ol inin ab sumbom bismi ub was hem ko bam aeben bu hayem ka. Ngub was bu habur inim Ngaoron man bibaebe ke wiyao sao baeben nao hende non bu hala bowes bubur, inim khorob hambun sao ngo kanda ub was bu hayem ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ngo tomb Njisesom tenaol hambun ni hae ol was ubuklub kobur obum mbini bor kakl, Nim ini bor angal ngo lowao o oborob ora pangobur nen sab hakol bibaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ngub kobur kakl, Hambun sao dera nan haklbir tenaolon tombao bor hondaklao saom, tenaol mao kho sakl buwaklao ora. Ngub inj, hambun sao tenaolon kone ndaon bor baoroaklbir deran pubuklao saom ora tenaol kho mao saraoklaong, ");
INSERT INTO akh_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ini angal ngubin te oborob nen saboklme baebenom angal ngo inin hal ora bor pen oborob ora pangoklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ngo tomb tenaol aondao ngo hasmi nda baeben ngol bao haen, Njises obu and obu paolisao on pisesa. Ngub pisaol obun man pange aol nda baebenom obu ne mubur kakl, Njem angal mar ngo kaendan te kao dund bi kismisa. ");
INSERT INTO akh_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Ngub kismil Njisesom mbini bor kakl, Ini di ora kon nao wi hayem ol, inim di angal mar ngon te nen nao sabeyem be? Ne hambun sao dera nan haklbir tenaolon tombao ndaon hondaoklao saom tenaolon kone bor nao poklao ora. Ngub inj, ne ngo dera nan hakl anda hondaraoklao sao baeben i men aoluklaol, mabor i to anda bor hondaraoklaol, ne noklme saom tenaol kho nao mao saraoklao ora kisesa. Ngub kisaol obum angal ngo kisao ub tenaolom ne hambun sao bao noklwaebe kobur kisesa. ");
INSERT INTO akh_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ngo tomb Njisesom ngub kobur kakl, Ngub biyao o tenaolon kone ndaon bor baoraoklbir dera pubuklao sao baebenom ora tenaol kho mao saraoklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Ngub kobur kakl, Tenaolon kone bor baoraoklbir tenaol kho mao saraoklao sao ngo deran pubuklao kanda, ngo sao was deran pubuklao. Tenaolom khorob nen saboklme. Tenaol dobaenom paes pu pu bimi. Tenaol hambunom di paes pu pu bu, khorob ngub was heb homo bam bam bimi. Tenaol pe paen lu tuwaroklme. Osisao paes noklme. Osisao hambun sao heb aondao ora homoklme. Khorob tangar tangar hambun sao buklemi on was nen saboklme. Tenaol mende bor maobowam akol bubur khorob was bimi. El ti ti ko khorob was bukl ke ke bimi. Tenaol mende bor nar wen ebe hende non bubur ko hom ha was haroklme. Tenaol mende dobaekleyo mangal bimi. Ebekone puklmi. Kone awis aondao ora haroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ngub kobur kakl, Khorob bimi sao hambun sao ngo baeben tenaolon kone ndaon bor baoraokl dera pobobur, tenaol kho mao saraoklao bor kanda ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ngo tomb Njises obu su ngol haklbir kisaon su and lobokl lobokl aondao Taya teb so bor pisesa. Ngub pobur obum su ngo bor and mend hasao on hondabur kisaon, obum ni tenaol mondom ngo hae ko nao henden mupango was haklwao ko nen sabisao o, tenaol hambunom obu Njises e ko ora hindismil obu mupangokl buwaesesa. ");
INSERT INTO akh_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ngub mupangokl buwaesaol su ngo bor ten is mend birisao o, ten ngo obun wanen tombao ndaon bor sam birisaol ten ngom Njisesom bu hasao sao pango birisao o, Njises obu su Taya enjo ngo bor obo hae ke pangisesa. Ngub pangobur kisaon ten ngo nongon tombao bor sam biri ndan ingim penar bu ora Njises hasaol obobur Njiseson aongao ma bor tumu karu dombes wisesa. ");
INSERT INTO akh_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ten ngo obu sem tangar Ngirik ten sisao o, obu su Siriyan and lobokl lobokl aondao Pinisiya bor birisao o sisaol, ten ngom Njises bor kao deb deb bubur kakl, Njem nao wanen tombao bor sam bereyaong taol derakanin ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ngo tomb Njisesom ten nda bor kakl, Naom nongnas kang bor mbes ne kalam sin ebe ora soklao ka. Ngub inj, naom nongnas kangon ne u buruklemi mubur buklhoma* haklemi bor pen kam sin ebe nao soklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ngub kisao o ten ndam Njises obun angal ngon ko san lubur kakl, Aorao Aondao o njem heneng ora kal o, buklhoma baebenom nongnas kang baebenom mbinin ne neme on ombo sul tibarayao baeben ebe bao mu noklme kisesa. ");
INSERT INTO akh_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ngub kisaol Njisesom ten nda bor kakl, Njem oborob ora ngo kal ub heneng ora kal ngao, njen wanen tombao bor sam ngo bereyao o ngubi tomb ora njen wanen tombao bor nao biri paokl pang, nje njen anda wakl boke ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ngub kisaol ten ndam obun anda wakl bokeyobur obun wane nda hindisaol, sam ngo nongon tombao bor birisao nda paokl ora pisaol, nong nda obun to bor as ko ora u paolu wisaol hindisesa. ");
INSERT INTO akh_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ngo tomb Njises obu su Taya ngol haklbir kisaon su Siron pibi ha su Dikapolis on kombe kobaklbir, ib mal aondao Kalili teb so bor po pindib paesesa. ");
INSERT INTO akh_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ngo tomb aol hal bowe angal oborob ko kombo nao ke is mend obu hasaol mini ibismisa. Ngub mini obobur mbini aol ngo mini ibismi baebenom, aol hal bowe angal oborob nao ke ngo njen kim obu men mbabur ebe mao sa ko kao deb deb bismisa. ");
INSERT INTO akh_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ngo tomb Njisesom tenaol aondao ngo hasmi nda baeben ngub bao haen, aol hal bowe angal nao ke nda bombor kemibir solo maon nan pobur kisaon, mbibi hungum ora hasbi tomb Njisesom obun ki hondem aol hal bowe angal ngo ke ndan hal dir bor pen kobur kisaon, obun ki hondel was ne maeke tokl beyabur, aol hal bowe angal nao ke ndan hekel obun ke honde ne maeke hapae ndam waraesesa. ");
INSERT INTO akh_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ngub bubur obum yu heben bor hend yabur kisaon, obun kone ora bor aol ngo hond aondao ora homobur hem ko, is kao peyobur obum aol nda bor kakl, Epata kisaol, ngo kisao on te angal heneng kobur, komb pa kisesa. ");
INSERT INTO akh_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ngub kisaol aol hal bowe angal nao ke ngo obun hal wakl komb paesao tomb penar bu ora obun heke di baol baol kisaol, angal oborob ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ngo tomb Njisesom wakl tenaol nda baeben hasmil obobur, obum mbini bor nim aol ngo ebe mao sanao ko tenaol mondom pangen nao lowaebe ora kisesa. Obum mbini bor ngub nao lowaebe ora ko buriyab ora kisao o, mbinim buri palobur tenaol hambunom pangen aondao bu ora kam aeben aeben bismisa. ");
INSERT INTO akh_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ngub bismil tenaol Njisesom ngo bisao sao pangismi baebenom burisao po burir aondao ora biyubur kakl, Obum hambun sao bu hae sao baeben oborob was bu hae ka. Heneng ora obum tenaol hal bowe baeben di wakl hal mao komba peb bu, angal nao ke baeben di obum wakl angal mao ka peb bu hae kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ngo tomb mabor tenaol andub ora Njises hasaol ko mende obo kiril mbaesmisa. Ngub obo kiril mbaesmi o mbinin ne nao wi pond bisaol, Njisesom obun man pange aol nda baeben ubuklub kobur obun mbini bor kakl, ");
INSERT INTO akh_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Tenaol aondao ngo baeben mbini di nao haru bao hor teb oran enjo ngo bor was bao harumnda o, ngubi tomb ne pond bandal mbinin ne nao wil, nim mbini hond aondao ora homakl kisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ngub kobur kakl, Nim mbini dem aondao ora ngub bao homo taoklbir inin anda puklub ka sin tenaol mendbor daol su enderael sao haklbir ibisimndis ol, dem lomaokl hab hab mbini harerol komb hakl po u kimb buklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ngub kisaol Njiseson man pange aol nda baebenom obun angal ngon ko san lubur kakl, Nao su ngo tenaol nao biri bor hayem ngao, naom palawe di ne as bor ora mubur tenaol aondao ngo baeben taol bu kalemin ba? kismisa. ");
INSERT INTO akh_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ngub kismil Njisesom obun man pange aol nda baeben bor kakl, Inin palawe asub baeben ora wiyem? kisaol, pao haoklao ora wiyom kismisa. ");
INSERT INTO akh_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ngub kismil Njisesom tenaol aondao ngo hasmi nda baeben hambun sul baoraokl baoraokl puklub kisaol, sul birismi tomb obum palawe pao haoklao nda mu munubur obum Ngaor bor tengiyu kao peyobur kisaon, obum munu konde barabur obun man pange aol nda baebenom tenaol aondao ngo ber mba hasmi nda baeben taol bu kalen ko kalisaol, obun man pange aol nda baebenom tenaol hambun bor taol bu kalismisa. ");
INSERT INTO akh_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ngo tomb mbinim ib wen kang was is bombor bombor mendbor di marismil, ngo di Njisesom mu munubur Ngao bor tengiyu kao peyobur kisaon, ngo di bombor ngub was obun man pange aol nda baeben bor tenaol hambun taol bu kalaoklaob kisaol taol bu kalismisa. ");
INSERT INTO akh_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ngub taol bu kalismil tenaol hambunom ebe no tombao hasmi tomb nokl nao bisaol bao win waesmi baeben, mbasker nu tokl haoklao oran tumbi haen was mar pa wismisa. ");
INSERT INTO akh_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ngo tomb Njisesom tenaol ngo ne taol bu kalisao baeben, buklhoma iri non bi andub ora 4,000 oran sisesa. Ngo tomb Njisesom tenaol aondao ngo baeben hambun mbinin anda puklub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ngub pismi tomb Njises obu ib taokaoll on baoraoklbir obun man pange aol nda baeben di mbini hambun su Dalmanuta bor pismisa. ");
INSERT INTO akh_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ngo tomb Peresi sem mendbor Njises hasaol obobur mbinim obu bor ab saond bu kalobur kismin, mbinim obu maobowa hondobur kakl, Njem naom nao hendemao sao yu heben pange mend haondaomun ub bi hend dao kismisa. ");
INSERT INTO akh_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ngub kismil Njisesom hibi kho so obun kone bor hem aondao ora kobur kakl, Ini tenaol ngubi tomb su bor hayem baeben hambunom ni bor naom ko mend nao hindismao sao mend haondaomun bi keyem ka. Ngub keyem o nim ini bor heneng ora kao njurukl, tenaol khorob was bu haroklme mendbor ngubi tomb hayem baebenom henden, nim tenaolom ko mend nao hindismi sao oran kang bombor ora di nao muwaloklwao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ngub kobur kisaon obum tenaol aondao ngo baeben ngol bao haen, obum ib taokaoll nda bor wakl honda baoraoklbir ib mal aondao ngo wisao ndan mende nan pisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ngub pismi tomb Njiseson man pange aol nda baebenom hemen habur kismin, mbinin ne noklemi sao mend nao mari pismi o, palawe pao bombor ora mend ib taokaoll ndaon bor win pismisa. ");
INSERT INTO akh_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ngo tomb Njisesom obun man pange aol nda baeben bor ngo sao oborob ora hondoklwaebe kobur kakl, Inim Peresi sem hesa Heror kabon palawe and mao saraoklao sao yis menger wiyao ub inim hondo ora habur, oborob ora hend ha was haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ngub kisaol Njiseson man pange aol nda baebenom mbini hakl hakl kakl, Naom palawe di ne menjao nao mari obamndal, obum nao bor ngub le nde kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ngub kismil Njisesom mbinin kone bor hondabur mbini bor kakl, Inim ini hakl hakl asub ko naom ne palawe di menjao nao mari obamndal le kao kao bim? Inim ne noklemi on ngo kao mba hayem ub, nao buri mend inim hendeklemin muwalaklo nda ub inim nen sab hakol nao bimi be? Inim ora kone tuwa haroklme be? Inin kone bor han hul non bi buri ora ngaorukl pesao be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Njisesom ngub kobur kakl, Nim ngo biyu nda ub inin el abo teyem om nao hendeme be? Inin hal abo hayem om nao pangeme be? Heneng ora nim ngo biyu nda ub inim nen sab hakol nao bi kone tuwaesmi ba? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ngub kobur kakl, Nim ko mend palawe pao su mend tenaol andub ora buklhoma iri non bi 5,000 oram nen munu konde barabur taol bu kalondis tomb, palawe ngon tenaol hambunom nokl nao bisaol bao win waesmi baeben, inim mbasker nu tokl aeker ora mar pa wisim bo? kisaol, mbinim obu bor kakl, Tokl duteb bao mar pa wisumndis kismisa. ");
INSERT INTO akh_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ngub kismil obum wakl kakl, Nim ko mende di tenaol andub ora buklhoma iri non bi 4,000 oram nen palawe pao haoklao mend taol bu kaolaokl obanda tomb di, mbinim nokl nao hae bao win warmi baeben oran mbasker nu tokl aeker ora bao mar pa waem bo? kisaol, mbinim obu bor kakl, Tokl haoklao bao mar pa wamnda kismisa. ");
INSERT INTO akh_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ngub kismil obum mbini bor wakl kakl, Inim ngo hakl nen sab hakol was nao bi hayem be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ngo tomb Njises di obun man pange aol nda baeben di mbinim su Bersara bor po pindib paesmi tomb tenaol mendborom aol el kho mend Njises obu hasaol mini ibismisa. Ngub mini obobur mbinim Njises bor aol el kho ngo njen kim men mba kismisa. ");
INSERT INTO akh_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ngo tomb Njisesom aol el kho ndan kil men pae and te ngon dera nan kemi pobur kisaon, obum aol el kho ngon el bor ne maeke kang mend tokl beyabur, obun kim aol ngon toklol men mbabur obum aol el bokl mini ngo bor ne mubur kakl, Njen elom osisao ebe hendel be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ngub kisaol aol el kho ngom hend peb bubur kakl, Nim hondokl non tenaol mendbor handakl o nim oborob ora nao hende, nim tenaol ngo baeben mbini is isao non bi harer pebeyem ol handakl kisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ngub kisaol Njisesom aol el kho ngon el bor obun kim wakl men mbaesao tomb aol ndam buriyab ora el ti pe hindisaol, obun el nda ebe ora bao sisaol obum hambun sao oborob ora hend heneng bisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ngo tomb Njisesom aol nda bor kakl, Njen el abo Njisesom wakl ebe mao sane ko, tenaol aondao ngo hayem baebenom nao henden ub njem wakl and te isu ngo bor nao pe njen anda paokl ora pebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ngo tomb Njises obu obun man pange aol nda baeben di mbini haru su Sisari Pilibi poklbur wen harerol pismi tomb Njisesom obun man pange nda baeben bor ne mubur kakl, Tenaol hambunom ni aeb ora hae lomeb? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ngub kisaol mbinim obu bor kakl, Tenaol mendborom nje Njon Mbabtas Biyao aol hael lome. Mendborom nje Ilanja hael lome. Tenaol mendborom nje Ngaoron man mini aol mbes hasmi haklon mend hael lome kismisa. ");
INSERT INTO akh_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ngub kismil Njisesom obun man pange aol nda baeben bor ne mubur kakl, Mbinim ngub ngo lome ong inim ni aeb ora lemib? kisesa. Ngub kisaol Pitam obun angal ngon ko san lubur kakl, Nje Ngaorom Eben Ke Aol ora hael kisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ngub kisaol Njisesom obun man pange aol nda baeben bor angal buriyab ora kobur kakl, Inim ni Ngaorom Eben Ke Aol ora hae ko tenaolom pangen lemi hondoklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ngo tomb Njisesom obun man pange aol baebenom pangen angal ngo pibnao tibiya kao kalobur kakl, Ni Aolon Isi Ora hae ol, nim tenda no ke hondoklbur hae ka. Heneng ora mabor Nju semon maomb bo haroklme aol, aol kon wi baeben di, mbinin baolum aol aondao baeben di, mbinin man buwaloklme aol baeben di, ngo baebenom ni makl homo mesao njubur mbinim ni tenda mao nabur pe pan luklemi ora. Ngub buklemi o nim bao hor tebo nanon wakl enjaokl poklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ngo tomb Njisesom angal ngo mbini bor kowes nao bi bao kao pa ora kao kalisaol, angal ngo kisao ub Pitam makl homobur kisaon obum Njises isu solo mend sisao nan kemi pobur kakl, Njem ngo kaenda ub nao buklao ora o nen sobakl o, njem baehaemen kaenda kisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pitam ngub kisaol Njisesom obun mesao nan baol munu, obun man pange aol nda baeben hondobur obum Pita taolu lubur kakl, Seran o nim nje nao hondoklwaong nje pu ora kisesa. Ngub kobur kakl, Njem ngo kal o Ngaorom nen sabeyao ub nen sabobur inj, njem aol henengom nen saboklme nda ub ora nen sabobur kal kisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ngo tomb Njisesom tenaol aondao ngo hasmi nda baeben di, obun man pange aol nda baeben di, hambun ora ni hae ol was ubuklub kobur obum mbini bor kakl, Tenaol mondom ni taol mi oba sin, obum ni imbi ken haklwao ko nen saboklao ub tuwaklbir, obum obu pe pae non bi ora habur obun is pe kowal bi taoklbir ni taol mi ebebe buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Njisesom ngub kobur kakl, Tenaol mondom ni imbi ken ora haklwao ko nen soba sin obum hambun sao baondib munuklaol, obu imbi nao wi kang ora soklao. Ngub inj, tenaol mondom ni hem kobur nao Angal Bib Hobao Sao o ora taol mi oboklaol obu imbi nao wi kang ora harob sin, mabor obu imbi wi aondao ora habur haeben saklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ngub kobur kakl, Tenaol mondom obu imbi wi aondao ora habur sun osisao hambun sao maru u haklao tomb obu haeben sakl buwaeb se harob sin, obun osisao ngo maru u haklao sao baebenom asub bubur obu bisur bu haeben saen laob? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ngub kobur kakl, Obu haeben nao saeb se ora sa sin obum wakl asaom ora haeben saroklme sao sokl buklaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ngub kobur kakl, Sun tenaol ngubi tomb ngo hayem baebenom Ngaor hem nao ke tuwabur khorob was bu hayem kisesa. Wakl kakl, Ngub beyem o mbini tenaol ngo baeben darukl o bor haklao mondom nao angal pango, ni taol mi ebebe on sakl men men ba sin, Aolon Isi Ora obu obun Ab Ngaoron angal mini wesao komb bi baeben di Ngaoron buri aondao bao bi o bor bor oboklemi tomb, Aolon Isi Ora obum di tenaol ngo baeben bor sakl men men buklao ora ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Obum mbini bor ngub kobur kakl, Nim ini bor heneng ora kao njurukl, tenaol ngo hayem baebenon mendbor nao heme bao haen was Ngaorom buri palobur maeb ha maomb bo hayao ub hondoklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ngo tomb mabor bao hor dowa oran pibi hasao tomb Njisesom obun man pange aol Pita di Njon Njemus kab di ngo baeben oran kemibir kisaon, har manda yu ora hond pele mend sisao bor pobur kismin, mbini ngo pismi baeben o was ware pe ora hasmil, mbini is teb ndan el so oral Njiseson songol tangar ubi bao bi hakol bi ora men aolisaol hindismisa. ");
INSERT INTO akh_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ngub hindismi tomb obun lab lab di obun samo hasao sao baeben bao bi hakol bi nar el non bi ora sisaol, sun tenaol hayem baebenon mondom lab lab haekl bi hakol bi ngo hindismi ubi men aolin wes wes nao luklemi ubi ora sisaol hindismisa. ");
INSERT INTO akh_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ngo tomb mbinim oborob ora hend heneng bismil, man mini aol mbes hasbi o Ilanja hesa Moses kab obobur Njises daol haru habur angal kao kao bi hasmil hindismisa. ");
INSERT INTO akh_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Ngo tomb mbini is teb ndam pakl homo burir aondao ora bismi tomb Pitam ngo bisao saon te nen sabokl buwabur, nim angal asub ora kon yeb kobur obum Njises bor kakl, Aol aondao o naom ngo bor bao harum sin ebe ora soklaong, naom and kang ukl teb mend ngol baomun wao. Ukl mend njen ukl mend Moseson ukl mend Ilanjan bu, ngub baeben oran baomun wao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ngub kakl hasaol mulaol kombabe pae ora mondom mbini u tingi mbaesao tomb mulaol darukl ngo bor angal bombor mend obobur kakl, Aol ngo obu nao Isi ora hae ol nim obul ora kone uruklung, inim obun angal was pangoklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ngub kisaol bombor ngo ora tomb man pange aol is teb ndam penar bu ora hend peb bismil, Njises daol aol is kab ngo angal kakl hasbi nda kab di mendel nao hae Njises obu bombor o mbini is teb o daol ub ora hasmil hindismisa. ");
INSERT INTO akh_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ngo tomb mbini yu harbor manda ngo bor haklbir wen harerol inin pukl hasmi tomb Njisesom mbini teb nda bor angal buriyab ora kao kalobur kakl, Inim ngo handaem ndisao oran, mabor Aolon Isi Ora obu obun maol bor wakl enjaokl poklao ub nao bi haenbur oran, inim tenaol mondom pangen nao lowaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ngo tomb Njiseson man pange aol is teb ndam obum mbini bor angal ngo kisao ub oborob ora nen sab hakol bubur, naom ngo le ub bemin ko nen sabobur mbini hakl hakl kao kao bubur kakl, Obun maol bor wakl enjaoklao ke ngon te asao bor le bo? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ngub kobur kismin mbinim Njises bor ne mubur kakl, Nju semon man buwaloklme aol baebenom asub ko Ilanja obu mbes oboklao o Aolon Isi Ora obu mabor oboklao lomeb? kismisa. ");
INSERT INTO akh_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ngub kismil Njisesom mbini bor kakl, E ka. Heneng ora Ilanja obum Aolon Isi Ora eben ko hambun sao mao dund sa peb bu obu mbes oboklao ke wisao ora o, Ngaoron mbuk waeb bor ngub di wiyao. Mbinim Aolon Isi Ora makl homo mesao kalo tenda aondao ora mao naklemi ke wiyaong, angal ngo asub ko ora ngub wiyaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Njisesom ngub kobur kakl, Ngub wiyao o nim ini bor oborob ora kao njun ub pangoklwaebe ka. Heneng ora Ilanja obu mbes ibisao o, Ngaoron mbuk waeb bor di ke wiyao ub tenaol hambunom mbinin mbib nen sabismi ub was bu habur kismin, mbinim Ilanja obu bor khorob tangar tangar andub sao bismi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ngo tomb Njises di obun man pange aol is teb ngo obu haru hasmi baeben di, mbini makl ngo Njises obun man pange aol nda baebenon mendbor ber mba hasmil pismisa. Ngub pobur hindismil tenaol andub ora Njiseson man pange aol nda baeben hasmil obo kirilu ber mba hasmil hindismi tomb, Nju semon man buwaloklme aol baeben di tenaol aondao ngo obo hasmi nda darukl o bor obo habur Njiseson man pange aol baeben hesa per ab saond bi wismil hindismisa. ");
INSERT INTO akh_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ngo tomb tenaol aondao ngo ha mba hasmi nda baebenom Njises ngub ibisaol hondobur mbinim burir aondao ora biyubur kismin, obu ngo ibisao ol akl pobur mbinim obu turi homo heben heben bismisa. ");
INSERT INTO akh_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ngo tomb Njisesom obun man pange aol mendbor Nju semon man buwaloklme aol baeben daol per ab saond bi wismi nda baeben bor ne mubur kakl, Mbini daol ngo kakl harmi sanda, asao was kakl harmib? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ngub kisaol tenaol aondao andub ora ngo dengeb dengeb kao mba hasmi nda baebenon is mondom Njiseson angal ngon ko san lubur kakl, Aol aondao o nao isi ngo obun tombao bor sam mend bereyao om obun pondo dengi munu waoraoklaol, obum angal di nao ke was baoraoklaol, nim obu nje hael ol ngo kemi ubukl o kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Aol ngom wakl kakl, Sam ngo nao isin tombao bor bereyao om ko ko was obu buriyab ora akl mbokl meneyao tomb sul khorob ora komb hakl pub biyao ora. Ngub biyaol obum saongao kengorokl no ne kelom kobur, obun ne bor howar maeke non bi hakl lao hakl pib pib biyao ora. Ngub biyaol obun toklo di ha peyo akl mbokl pe was haraoklao kisesa. Aol ndam ngub kobur kakl, Nao isi ngo ngub was bu haraoklaol, nim obu njen man pange aol ngo baeben bor sam ngo taol deraklaob ko mbini harmil mini obowao o, mbinim taol derakl buwarim kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ngub kisaol Njisesom angal ngo pangobur mbini bor kakl, Ini tenaol ngo hayem baeben o, inim Ngaorol hul nao hae ora haroklme kisesa. Ngub kobur kakl, Ini daol nao maomunu was haemao tomb inim nao hibi kho was mao sa hayem ngao, inim nao kone bor ngub kho mao sa hareklemin ko, ni ini daol hor asub baeben ora bao haklmao balem? kisesa. Ngub kobur kakl, Nas ngo enjo ngo ni hae ol mini ib kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ngub kisaol mbinim nas nda Njises obu birisaol mini ibismi tomb sam ngo nason tombao bor birisao ndam Njises hondobur kisaon, penar bu ora nas nda komb hakl po win kisaol sul khorob ora komb hakl po ubur perel biyakl wisaol, nas ngon ne bor howar maeke non bi hakl lao hakl pib pib bisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ngo tomb Njisesom nas ndan ab bor ne mubur kakl, Nas ngo obun tombao bor sam ngo birise ub pibnao oran atomb tibiya birisaob? kisaol, nas ndan abom kakl, Nas kang ora tomb bisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Aol ndam ngub kobur kakl, Sam ngo nas ngon tombao bor ngo bere om nas ngo obu ora pe paen ko mao dur kabur, is de bor di haoklu haoru ib bor di haoklu tu kobaraoklao o, njem yao hond homobur nas ngo ebe mao saklwao ko pangal sin, njem yao hond homo nas ngo ebe mao sa bisur bi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ngub kisaol Njisesom aol nda bor kakl, E ka. Njem ni bor njem nas ngo ebe mao saklesi sin kal ub inj, mondom nil heneng ora hul ha habur obum ebe buklao ora ko nen saboklao tomb obum ngo bi ko nen saboklao sao baeben hambun sao ebe buklaol, njem di nil hul ha ora habur obum ebe buklao ko pangae sin heneng buklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ngo tomb nas ngo tombao bor sam birisao ndan aoraom angal buriyab ora kobur kakl, Nim njel hul ha haruklu ub oborob ora hul ha nao haeng, nim njel aondao bu ora hul ha han ub njem ni bisur bi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ngo tomb Njisesom tenaol aondao andub ora obu ibisao o hondokl obo kiril mbam mbam bismil hondobur, obum penar bu ora nason tombao bor sam ngo birisao nda taolu lu, angal buriyab ora kobur kakl, Nje sam angal nao ke hal bowe o nim nje bor kakl ngao, nje nas ngon tombao bor nao biri pu ora. Njem obun tombao bor wakl ko mende nao hondaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ngub kisaol sam ngo nason tombao bor birisao ndam aondao bu ora e kobur kisaon, nas nda wakl was aondao bu ora mu tukl hakl po win kaoklbir paokl ora pisaol, nas nda ora pe pae non bi u mba hasaol, tenaol andubom ora nas nda ora pe parob kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ngub kismi o Njisesom nas ndan kil menya mao tekaesaol teka hasesa. ");
INSERT INTO akh_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ngo tomb mabor Njises and obu paoliao on po birisao tomb Njises obun man pange baeben was ware pe burubur mbinim Njises bor ne mubur kakl, Naom nas ndan tombao bor sam ngo birisao o asub ko taol derakl buwame sa bo? kismisa. ");
INSERT INTO akh_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ngub kismil Njisesom mbini bor kakl, Heneng ora inim hor hor was Ngaor bor nen sab ha burubur kao kal ha nao harim sin, inim sam ngubi sem taol derakl buwaklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Ngo tomb mbini su ngol haklbir kismin, su Kalilin tukun ora bor pismisa. Ngub pismi o Njisesom obun man pange baeben bor mabor obu luklemi on di hambun sao mbini bor kao kaloklbur kisaon, obu tenaol mondom ngo bor haril ko nao henden ora sub mupang pang bu was pismisa. Ngub pismi tomb obum obun man pange aol baeben bor kakl, Aol mendborom Aolon Isi Ora obu karu lubur, obu lukl buklemi aol baeben bor men pae puklub ko kaloklemil, mbinim obu pe paen luklemi ora. Ngub ora pe paen luklemi o mabor bao hor tebo nan on obu wakl enjaokl poklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ngub kisao o mbinim obum angal ngo ngub ora puwi pen leb ko nen sabokl buwaesmil, obu bor wakl ne di nao mi pakl homobur bao waesmisa. ");
INSERT INTO akh_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ngo tomb mbini su Kabenam po pindib pabur, and mbini paolukl bismi on honda birismi tomb Njisesom obun man pange baebenon kone bor harerol kismi sao hondobur mbini bor ne mubur kakl, Inim harer obaemi bor angal asao was ko harmib? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ngub kisao o obun man pange aol nda baebenom harer ibismi bor, mbini hakl hakl nao ngo baebenon aol aondao imbi wi oran aeb ora soklaob? kao kao bismi o sisaol, mbinim sakl polobur e beb nao kismisa. ");
INSERT INTO akh_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ngub e beb nao kao kao bismil Njisesom sul ber pabur, obun man pange aol duteb nda baeben ubuklub kobur obum mbini bor kakl, Mondom nje aol imbi wi aondao ora hakl ko pangae sin, njem dimb men aolubur njem tenaol hambunon bisur biyao aol haebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ngo tomb obum nongnas kang mend men mubur mbinin el wilol teka mao hasesa. Ngub bubur kisaon obun nongnas kang ngo hibi mu munu habur obum mbini bor kakl, ");
INSERT INTO akh_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Tenaol mondom ni hem kobur nongnas kang ngubi mend hem ko kone u bisur ba sin, obum ni ora hem ko kone ubur buklao. Obum heneng ora ni bor hem ko kone ubur oborob ba sin ni inj, nao Abom ora ni pu kisaol, obum nao Ab bor ora hem ko kone ubur buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ngo tomb Njonom Njises bor kakl, Aol aondao o, aol mondom njen imbi kobur tenaolon tombao bor sam bereyao o taol dera harekle sal hondomao kisesa. Wakl kakl, Naom ngub hondobur naom aol ngo obu daol nao haru nao haroklmao ndal, naom obu bor njem ngo bili ub nao bibi ora komao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ngub kisaol Njisesom obu bor kakl, Inim obu bor njem ngub nao bibi ko ngo kaemi ub nao lowaebe ora. Pangeklem. Mondom ninao imbi kobur tenaolom ko mend nao hindismi sao ngub bu harob sin, obum penar bu nao mangal bu ni bor maobowa angal ngo buklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Njisesom ngub kobur kakl, Aol mondom nao bor saond nao bu nja sin obu naon sem ora soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Wakl kakl, Tenaol mondom ini buru uklemil hondobur obun kone bor nim Eben Ke Aolon sem ngo bisur buklwao ora ko nen sabobur, obum ini bor ib ora heneng o neklemin humu nja sin di, nim ini bor angal ngo heneng ora kao njurukl obun sokl aondao ngol es nao bi panaem ora uklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ngo tomb Njisesom kakl, Mondom njen mal han aondao ora hond men hend ha tu ndiyabur ib mal aondao oran ndaon bor haoklu tu kobarob sin, nje ib ndaon ngo bor bao pe paklesi ub ke kang bu sao hondoklesi. Ngub buklesi o njem nongnas kang bombor ora mend nil hul ha haenbur saokl mao wari sin nje ke aondao bu ora hondoklesing, njem mende saokl mao waklesi hondo ora haebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ngo tomb Njisesom ngub kobur kakl, Njen kim nje saokl mao waeb so ba sin, njen ki mende pe tuwaebe. Heneng ora njen ki bombor ora haem haeben saroklme bor pae sin ebe ora haeben soklesi. Ngub inj, njen ki kab kobaran bao habaklae haklesil, Ngaorom nje ke hondoklme su isaolao nao hundili dao hakol bi ora bor penin ka sin, nje ke hondo haeben ora soklesi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Wakl kakl, Ke hondoklme su ngo bor aol hemen toklo bor baoraoklao him di nao heme ber aeben ora saraoklao. Is de di nao hundili dao ha u kimb ora biyao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ngub kobur kakl, Mende di njen aongaom nje saokl mao waeb so ba sin, njen aongao mende pe tuwaebe. Njen aongao bombor ora haem haeben saroklme bor pae sin ebe ora haeben soklesi. Ngub inj, njen aongao kab kobaran bao habaklae haklesil Ngaorom nje ke hondoklme su bor ora penin ka sin, nje ke hondo haeben ora soklesi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Wakl kakl, Ke hondoklme su ngo bor aol hemen toklo bor baoraoklao him di nao heme ber aeben ora saraoklao. Is de di nao hundili dao ha u kimb ora biyao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Njisesom ngub kobur kakl, Njen elom nje saokl mao waeb so ba sin, njen el mende toklo tuwaebe. Njen el hond bombor ora tu hari sin, njem Ngaorom maeb ha maomb bo hayao bor ebe ora po haklesi. Ngub inj, njen el kab kobaran bao tu haklesil Ngaorom nje ke hondoklme su bor penin tuwarob sin, nje ke hondo haeben ora soklesi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Wakl kakl, Ke hondoklme su ngo bor aol hemen toklo bor baoraoklao him di nao heme ber aeben saraoklao. Is de di nao hundili dao ha u kimb ora biyao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Heneng ora kunjam ne osisaol tandokl hakl po ha ngaraoklao nda ub isaolaom tenaol hambun bor tandokl hakl po dao ngaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Wakl kakl, Kunja hobao sao ora saoklao o, kunja ngo dend nao bi kho sa sin, inim wakl asub ora bubur mao dend baklemib? kisesa. Ngub kobur kakl, Inin kone ora bor kunja dend bi sao win turi was homo habur lemin, inim tenaol hambun bor turi was homo heben heben bu was haklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ngo tomb Njises obu su ngol haklbir kisaon su Njuriya pobur, obum ib Njoran mende nan di pisesa. Ngub pisao tomb su ngo bor tenaol andub ora obu hasaol wakl was obo kiril mbaesmil, Njises obum bu hasao ub tenaol ngo baebenom pangen Ngaoron angal bib hobao sao ngo kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ngo tomb Peresi aol mendborom Njises hasaol obobur mbinim Njises obu maobowa hondobur kakl, Naon manom asub was ke wiyao? Aol mondom obun were anda pu kokl ko panga sin, ebe anda pu lomao be? kismisa. ");
INSERT INTO akh_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Mosesom man kisao ub inim asao was bibaebe ke wiyaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ngub kisaol mbinim obu bor kakl, Mosesom ngub kisao. Mondom obun were anda pu lowao ko panga sin, aolom ten anda pu lome bobae mend waeb bu ubur inin were ebe anda pu lemi kisao kismisa. ");
INSERT INTO akh_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ngub kismil Njisesom mbini bor kakl, Inim ebekone po awis ora hon mismil Mosesom inim ngub bibaebe ko waeb bu wise o, ");
INSERT INTO akh_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","mbes ora Ngaorom hambun sao warisao tomb obum ten aol kab maomunu warisao ora. ");
INSERT INTO akh_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ngub warisaol aolom obun am ab kab tuwabur obun ten taol buklaol, obun were kab ora maomunu buruklebi tomb ");
INSERT INTO akh_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","mbibin toklo is bombor non bi ora buruklebi. Ngub buruklebil mbes mbibi nongnas tomb mbibin toklo is kab non bi hasbi ub ko mende nao haklebi ora. Ngub inj, mbibin toklo is bombor non bi haklebing, ");
INSERT INTO akh_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","hambun sao Ngaorom tangarob sin tenaolom nao hesbeklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ngo tomb mabor Njises di obun man pange baeben di mbini hambun and mbini paolukl bismi on honda birismi tomb Njiseson man pange ngo baebenom obum angal ngo kisao ndan wakl ne mismisa. ");
INSERT INTO akh_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ngub ne mismil Njisesom mbini bor kakl, Aol mondom obun were o njen anda pu kobur ten tangar mende taol ba sin, obum obun were bor khorob ora bubur ngub buklaol, obum ten mende ngo taol buklao o paes ora kemi poklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Wakl kakl, Ten mondom di obun aoli haen tuwakl pobur obum aol tangar pa sin, obum di aol ngo paes ora poklao kobur kanda kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ngo tomb tenaol mendborom mbinin nongnas kang baeben Njisesom kim men mba peb bin ora ko nen sabobur kismin, obu hasaol was mini obo kiril mbaesmi o, Njiseson man pange aol nda baebenom obun hobao sao bukl bi hakol ngub nao bib kobur makl homo taolu lismisa. ");
INSERT INTO akh_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ngub kismil Njisesom ngo kismi o hondobur obun kone bor hem kobur obum mbini bor kakl, Ngaorom maeb ha maomb bo hayao bor nongnas kang ngubim kone woroklme ub u haroklme baeben was pokleming, nongnas kang ngubi baeben di ni hae ol eben ub ngub nao lowaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Njisesom ngub kobur kakl, Nim ini bor heneng ora kao njurukl, tenaol mendbor nongnas kang ngubi men aolubur mbini Ngaorom maeb ha maomb bo haen nao harim sin, mbinim Ngaorom maeb ha maomb bo hayao bor pokl buwaklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ngub kobur kisaon obum nongnas kang nda baeben turi homo hibi mib bu munubur, obum mbini kim men mba peb bu Ngaor bor nongnas kang ngo baeben bisur bu werek taol bu kalaebe ko kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ngo tomb Njises obu su tangar mende bor poklbur harerol pukl hasaol, aol mondom Njises obu hen mukl akl was obobur obum tumu kar munu dombes ubur Njises bor ne mubur kakl, Aol aondao o nje ebe ora hael ngao, asub ora buklwao tomb ni haeben saklwaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ngub kisaol Njisesom obu bor kakl, Njem asub ko ni bor nje aol ebe ora kal? Pangal. Ngaor obu bombor o ora ebe hayao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ngo tomb Njisesom wakl kakl, Njem man hambun sao wiyao ub ora pangeleng, njem tenaol mende pe paen nao libi. Ten paes nao kemi pebe. Tenaol menden hambun sao di paes nao naebe. Njem tenaol mende bor kakla nao kao beyaebe. Njem tenaol mende maobowa peb bu obun osisao nao mibi. Njen am ab kab lebi sao di hul nao hae oborob ora pangaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Njisesom ngub kisaol aol ndam wakl kakl, Aol aondao o nim mbes nas kang ora hawao tomb di ngubi tomb di njem ni bor man ngo bibi kal baebenon ukl mend nao baondib mini, hambun sao bu haruklu ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ngub kisaol Njisesom aol nas nda elom hondobur hond aondao ora himisesa. Ngub hond homobur obu bor wakl kakl, Njem bombor sao ora mend nao bising, njen osisao hambun sao maru u harili sao baeben tenaol tangar mendborom dob bin mone mibi ora. Ngub mubur lesin njem mone ngo muklesi baeben tenaol mendbor menjao menjao nao wi buruklemi baeben bisur bu taol bu kalaebe ora. Njem ngub buklesi tomb njen osisao hobao sao ora yu heben bor maru u hae non bu haklesing, njem ni taol mi ebebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ngub kisaol aol ndam Njisesom angal ngo kisao o pangobur obun osisao andub ora maru u hasao o sisaol, obun kone bor Njisesom ngo le ub nao buklwao o le ko nen sabobur obum wil homo hena waoklbir paokl ora pisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ngo tomb Njisesom obun man pange aol baeben hondo akol bubur obum mbini bor kakl, Aol homa osisao andub ora maru u haroklme baebenom Ngaorom maeb ha maomb bo hayao bor poklbur es aondao ora bubur, kekeb haong lib se ora yao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ngub kisaol Njiseson man pange aol nda baebenom Njisesom angal ngo kisao nda pangobur mbinim burir bismi o, Njisesom mbini bor wakl oborob ora kao dund bubur kakl, Nao isi hakl o mbini tenaol mendborom Ngaorom maeb ha maomb bo hayao bor poklwao ko nen sobaem sin, mbinim es aondao ora bubur kekeb haong lubur peb se ora yao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ngub kobur kakl, Aol homa baebenom Ngaorom maeb ha maomb bo hayao bor aondao bu ora es buwa kekeb haong lib se ora yao om, some kamelom lab lab taombuloklme sao kem haolon dir bor es buwa kekeb hondakl buwabur puklmi ub di men mbaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ngub kisaol Njiseson man pange aol nda baebenom burir aondao ora biyubur mbini hakl hakl kao kao bubur kakl, Ngub sin mondom haeben nao saeb se ora saol ngao, aebom was haeben saklaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ngub kismil Njisesom mbini oborob ora hend heneng bubur kakl, Tenaol henengom mbinin mbib menjao bukl buwaklemi o, Ngaor obum bombor o hambun sao ebe bib se hayao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ngo tomb Pitam Njises bor angal ukl mend kobur kakl, Pangal. Nao ngo baebenom non naon hambun sao ora tuwaklbir nje was taol mi ibisumndis kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ngo tomb Njisesom mbini bor kakl, Nim ini bor heneng ora kao njurukl, tenaol mondom ni hesa nao Angal Bib Hobao Sao ora kab hem ko taol mi oboklbur obun su and te di, obun aorao haeme di, obun ingi mbaoli di, obun nongnas di, obun em osisao hambun sao di ngo sao baeben tuwarob sin, ");
INSERT INTO akh_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ngaorom obu bor wakl san lubur aorao haeme di, ingi mbaoli di, nongnas di, su em and di obu sul bao haklao tomb wakl was taol bu kalobur, obum ko ko was hor su mao ha oran taol bu kaloklao ora kisesa. Wakl kakl, Aoh, heneng ora obu sul ngub bao haklao tomb aol mendborom obu bor khorob buklemil ke di kang mend hondoklao o, mabor obu haeben ora soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Njisesom ngub kobur kakl, Tenaol andub ora mendbor ngubi tomb aondao hayem baeben mabor kang haklemi. Tenaol andub ora mendbor ngubi tomb kang hayem baeben mabor aondao ora haklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ngo tomb Njises di obun man pange baeben di mbini Njurusalem yin poklbur wen harerol pismi tomb Njises obu mbakla pisaol, Njiseson man pange aol nda baebenom pakl homaokl homaokl kang mend mama sao pismisa. Ngub pismil tenaol mendbor mbini mama taol mi pismi nda baebenom di pakl himismisa. Ngo tomb Njisesom wakl obun man pange aol duteb nda baeben was ware pe sub ubuklub kobur, Njises obu luklbur ngub was buklemi ko kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ngub kao kalobur kakl, Pangeklem. Naom embi ngubi tomb su Njurusalem di mend ngo pukl hayom tomb ora kao njurukl ngao, aol is mondom Aolon Isi Ora karu lubur laong, obum Nju semon baolum aol aondao baeben di, mbinin man buwaloklme aol baeben di, ngo baeben bor men pae puklub ko kaloklao ora. Ngub buklaol mbinim obu bor te mao sarakl engel bu howes kobur pe paen lemin ora ko kao pabur lemin, Aol Sem Tangarom obu pe paen lin ko kaloklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Wakl kakl, Ngub kaloklemil Aol Sem Tangar ngo baebenom obu maobowa angal bu, ne maeke hakl tokl beya peb bu, doroklom di khorob ora lu bowes bubur obu ora pe paen luklemi o, bao hor tebo nan on obu wakl enjaokl poklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ngo tomb Seberin isi kab Njon Njemus kabom Njises hasaol obobur obu bor kakl, Aol aondao o njem menjao bombor sao oran mend benin ko kao njaobun ub, yaom nje bor ngo kao njuklbao sao njem bibi ora kisbisa. ");
INSERT INTO akh_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ngub kisbil Njisesom mbibi bor kakl, Nim ibin asao ora ban ko nen sabobur leb? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ngub kisaol mbibim Njises bor kakl, Mabor nje aol wesmbao aondao bao bi ora haklesi tomb njem yao ngo kab oran bember peyobur, is mende aol njen ki tao nan is mende aol ki kowes nan bu baoraobun kaebe kisbisa. ");
INSERT INTO akh_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ngub kisbi o Njisesom mbibi bor kakl, Ibim ni bor ngo bibi ko kao deb deb bib saon te ibim oborob ora nen nao sabebur leb ngao, ibim nim mabor kab bor ib karae bi ber pae mend noklwao ub ibim di ebe noklbao ko nen sabeyeb be? Ni mbabtas ngo buklwao ub di ibim ebe buklebi be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ngub kisaol mbibim obu bor kakl, Yaom ebe bib se hayob kisbisa. Ngub kisbil Njisesom mbibi bor kakl, Heneng ora nim kab bor ib karae bi ber pae ngo noklwao ub ibim di ebe noklebi. Ni mbabtas buklwao ub ibi di ebe mbabtas buklebi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Njisesom wakl kakl, Ibim ngub buklebi o ibim ni bor mende aol nao ki tao nan, is mende aol nao ki kowes nan bu baoraobun kaebe kaebnda ub non, ninao kongon menjao inj sakl, Ngaor obun mbib was panda ngol aol ngo obum was buruklao ko mbes man man bisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ngo tomb Njisesom man pange aol tobon kab mend aebenol sao hasmi nda baebenom, Njemus Njon kabom angal ngo kisbi nda angobur mbibi makl homo khorob ora taolu lismisa. ");
INSERT INTO akh_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ngub bismi o Njisesom mbini hambun obu hasaol teb so was ubuklub kobur obum mbini bor kakl, Inim di ora hendeyem ub mbini su Tenaol Sem Tangaron aol wesmbao aondao haroklme baebenom tenaol hambun buri palobur ora maomb bo haroklmel, tenaol hambunom mbinin maomb bo haroklme baebenom menjao keme tomb mbinin angal ngo keme ub was pangoklme kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Njisesom ngub kobur kakl, Mbinim ngub bimi o inim kone ngubi nen nao saboklwaebe ora. Ngub inj, ini ngo hayem haklon is mondom obu aol aondao imbi wi ora haklwao ko panga sin, obum inin kongon biyao aol men korobur inin bisur biyao aol ora haebe buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ngub kobur kakl, Ini ngo haklon mondom di inin maomb bo haraoklao aol haklwao ko panga sin, obum di imbi nao wi kang ora men korobur ini hambunon kongon biyao aol men koro haebe buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Njisesom ngub kobur kakl, Menger bombor ngub was Aolon Isi Ora obu tenaol hambunom obu bisur bin ko inj ibisao ka. Ngub inj, obum kongon buri ora bubur tenaol hambun bisur bukl obobur kisaon, obun mbib obu imbi wi haraoklao ub tuwa, obu pe pabur obum tenaol andub ora bu muklbur ibisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ngo tomb mbini su Njeriko pobur kismin, wakl su Njeriko ngol haklbir Njises di obun man pange nda baeben di tenaol aondao andub ora su ngol hasmi baeben di Njises daol haru pismisa. Ngub pismil Batimas obu Timason isi sisao o, obun el kab bokl mini moklom harer solol buru ubur, tenaol harer ngon pibismi baeben bor mone di menjao menjao njib was ko kao deb deb bu birisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ngub bu birisao o obum Nasarer Njises obu kang mend aebenol sao obo hae ke pangobur, obum Njises bor kor bi handam handam bu angal aondao bu ora kobur kakl, Njises nje Debir semon isi o njem ni hond hom ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ngub kisaol tenaol aondao ngo ibismi nda baebenom aol el hukl bi kang nda bor njem angal nao kao kobur taolu lismisa. Ngub bismi o aol el kho ndam angal aondao bu ora ko, kor bi hakol bubur kakl, Debir semon isi o njem ni hond hom ko, aondao bu ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ngo tomb Njises obu teb sol sao obo habur kakl, Inim aol ngo obu bor ib laob kisaol, mbinim aol el bokl mini nda bor kakl, Obum nje bor ib leng, njen kone bor hul ha saor peyaoklbir nje pen tekakl ib ora kismisa. ");
INSERT INTO akh_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ngo tomb aol el kho ndam obun lab lab obun toklo mbukl pa birisao o di u haen tuwaklbir kisaon, penar bu ora teka peyaoklbir Njises hasaol ibisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ngo tomb Njisesom aol el kho nda bor kakl, Nim nje bor asao ora bun ko ni kor baeb? kisesa. Ngub kisaol aol el bokl mini ndam kakl, Aol aondao o njem ni wakl el tun kao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ngub kisaol Njisesom aol nda obu bor kakl, Njem nil hul ha ora harili saom nje wakl ebe saokl ngao, harer pib kisesa. Ngub kisaol bombor ngo ora tomb ebe bao sisaol, obum osisao hend heneng bisesa. Ngo tomb obum Njises pisao harer on obu taol mi pisesa. ");
INSERT INTO akh_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ngo tomb mbinim Njurusalem teb sol sao su kang kab menden imbi Betpasi hesa Betani kab, har Olib manda teb sol sao sisaol ngol pindib paesmisa. Ngo tomb Njisesom obun man pange aol is kab mend ubuklub ko ");
INSERT INTO akh_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","mbibi bor we kobur kakl, Ibim su isu ngo ibim hendeyeb o enderae inj teb sol ora eng, ibim su and te ngo bor hondaklebi tomb ibim penar bu ora some dongi hondbao aondao and so so mend ngol ndi mba haklaol hondoklebing, mbes aol mondom di nao ber hende yaong, ibim kolobur komae ubuklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ngub kobur kakl, Tenaol mondom ibim asub buklbur ngub bib? kaem sin ibim ngub ora lowaebe. Aorao Aondaom some ngo penar bu ora wakl inin eben kaklbur o, obu buruklbur ngo komakl pu kene o lowaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ngo tomb Njiseson man pange aol nda kab pisbisa. Ngub pobur hindisbil some dongi hondbao aondao wen and so so mend, and menden tiriyao kombael hend saoll bu indi mbaesmi o harer tol obo hasaol hondobur kisbin kolisbisa. ");
INSERT INTO akh_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ngo tomb tenaol mendbor some ngo kolakl hasbi ndal teb so habur kakl, Ibim asub buklbur some dongi hondbao aondao ngo kolekleb? kismisa. ");
INSERT INTO akh_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ngub kismil mbibim Njisesom lowaebe kisao nda ub kao kalisbi tomb mbinim some dongi hondbao ngo ebe kemi puklub kismisa. ");
INSERT INTO akh_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ngo tomb mbibim some dongi hondbao nda Njises hasaol kemi ibisbi tomb, mbinim Njises obu birin ko mbinin lab lab baeben some dongi ndan mesaol tuwis mbaesmisa. ");
INSERT INTO akh_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ngo tomb tenaol andubom ora Njises obu some dongin mesaol baoraokl pisao harer ngon ebel pen ko mbinin lab lab baeben tuwis mba kimb bismi tomb, tenaol mendborom di em obal wen ebe mend sisao baebenon is so hae bo sando taokl taokl obobur tuwis mba kimb bismisa. ");
INSERT INTO akh_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ngo tomb tenaol aondao ngo baebenom Njises mao tukun sabur mendbor mbakla pen mendborom mama pobur, mbini hambunom turi homo taom bu taokl po angal aondao bu ora kobur kakl, Ngaorom imbi wi haen kisao aol ngo obu Aorao Aondao hayao bor hakl ebene ngao Obu bor kaoya kem ora ko kaoya kismisa. ");
INSERT INTO akh_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ngub kobur kakl, Mbes naon ab sumb Debirom Maeb ha maomb bo hasao ub Ngubi tomb ngo maomb bo hakl ebe ol Ngaorom tenaol mendbor Obum maomb bo haen haklemi baeben bor Turi homo werek taol bu kaloklao ora. Aorao Aondao ngo obu yubu ora yao ko Kaoya kem kobur turi homo taom bu taokl pismisa. ");
INSERT INTO akh_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ngo tomb Njises obu su Njurusalem and lobokl lobokl aondao ora bor po pindib paesao tomb obum Ngaor Hen Moroklme Anda andaon hondabur hambun sao hondo akol bisao o, mbon sam sam bubur nar anda hondakl ke ke bisesa. Ngub bisaol Njises obu obun man pange aol duteb nda baeben haru su Betani ke kang mend teb sol sao wisaol ngo bor pismisa. ");
INSERT INTO akh_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ngo tomb ekera nan Njises di obun man pange aol nda baeben di mbini hambun su Betani ngo bor haklbir kismin, harer bor ubukl wismi tomb Njises obu dem himisesa. ");
INSERT INTO akh_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ngo tomb obum dem ngub homobur hindisaol dullub isao mend kang mend enderael sao so bu hasaol haondaoklbir kisaon, il di mend seneb ko talo noklbur kisaon dullub ngon te bor hondokl pisesa. Ngub hondokl pisao o ek ngon dullub ma bu il nao saoklao ekon sisaol, il kang hond bombor ora di nao sebur so was bu hasaol hindisesa. ");
INSERT INTO akh_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ngub sisaol hondobur Njisesom dullub isao nda bor kakl, Is njem haom mu il nao so haklesi ora kisaol, angal ngo kisao o Njises obun man pange aol nda baebenom pangismisa. ");
INSERT INTO akh_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ngo tomb mbinim Njurusalem and lobokl lobokl aondao nda bor po pindib paesmi tomb Njises obu Ngaor Hen Moroklme Anda bor hondabur kisaon, tenaol andub ora Ngaor Hen Moroklme Anda ngo bor, mbinin osisao baeben tenaol tangarom dob bin mone murukl wismi nda baeben di, tenaol mendbor osisao ngo hakl dob bukl ibismi nda baeben di, ngo baeben hambun ora lu taol deraesesa. Ngub bubur kisaon tenaol mendborom di mbinin mone woroklme to ngo mone ubur, mone su tangar tangar pange kab kab kowal bi bi bu ngo bi wismi nda, to ngo nda hakl baol munu bo kolo bowes bisesa. Ngub bubur kisaon mendborom di sao ebeyabukl dob bi wismi nda baebenon to, mbini birismi nda baeben di bo nuklu bowes bisesa. ");
INSERT INTO akh_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ngub bubur kakl, Ini tenaol hambunom Ngaor Hen Moroklme Anda ngon andaon menjao menjao nao men pae hondaklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Njisesom ngub kobur tenaol hambunom pangen angal aondao bu ora kobur kakl, Ngaorom mbuk waebom ngub ke wiyao. Tenaol su ngo hambun bor Paoleme baeben hambunom Nao and ngo ni bor kaoya lome anda hae lemi ke wiyao o, inim and ngo paes noklme aolon mupange anda non bi men mao korarmi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ngub kisaol Nju semon baolum aol aondao baeben di, mbinin man buwaloklme aol baeben di, mbinim Njisesom ngo bisao sao pangobur kismin, Njises ko aondao ora homobur mbinim Njises obu ib mao pa luklemi on kar mba hasmisa. Ngub bismi o Njisesom burir biklme sao di ngo bu hasao sao baeben tenaol hambunom ora hondobur, obum hambun sao ngo buri palo bu hae o kobur obum ngo bu hasao ub pakl homo burir bismi o sisaol, mbinim Njises obu pe paen bao libi o pakl himismisa. ");
INSERT INTO akh_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ngo tomb bao bombor ngon ombonao Njises di obun man pange aol nda baeben di mbini hambun and lobokl lobokl Njurusalem ngol haklbir su tangar mende bor pismisa. ");
INSERT INTO akh_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ngo tomb wakl ekera nan hokloben Njisesom dullub isao makl himisao harer ndan wakl bokeyobur, dullub isao ngo kaeb sao mba hasaol hindismi tomb dullub ndan pi di homaokl homaokl pobur so baeben di kaeb so kimb bu mba hasaol hindismisa. ");
INSERT INTO akh_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ngo tomb Pitam Njises obum dullub isao ngo bor ngo kisao nda ub nen sabo bokeyobur obum Njises bor kakl, Aol aondao e njem mbakla dullub isao ngo bor njem il so nao haklesi kaenda, ngo kaeb so wi ong hend kisesa. ");
INSERT INTO akh_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ngo tomb Njisesom Pitan angal ngon ko san lubur kakl, Inim Ngaorol hul ha ora haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Njisesom ngub kobur wakl kakl, Heneng ora mondom Ngaorol hul ha ora habur obum kone taol taol nao bi nim ngo kakl ub buklao ora ko nen sabobur, harbor aondao ngo ase hakl bor kakl, njem kobaol hakl pobur unu ib kunja tukun oral po saor ka sin, heneng ngub buklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ngub kobur kakl, Nim ini bor angal ngo heneng ora kao njurukl ol, inim Ngaor bor kao kaloklemi tomb obul hul ha ora habur nim Ngaor bor ngo kao kalakl ub buklao ora ko nen sobaem sin, nim ini bor heneng ora kao njurukl inim ngo lemi ub buklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Njisesom ngub kobur kakl, Inim teka habur Ngaor bor kao kaloklemi tomb, inin kone bor tenaol mondom ini bor khorob bismi baeben bor saongao bao mar hakol nao bi tuwabur Ngaor bor lowaebe ora. Ngub buklemi tomb inin Ab yu heben hayaom di inin kone bor kho uklao sao saongao nao maribur kunaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Wakl kakl, Heneng ora inim tenaol mendem ini bor khorob buklemi sao saongao mar hakol bubur nao tuwarim sin, inin Ab yu heben hayaom di inim khorob bimi sao saongao mar hakol bubur nao kunaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ngo tomb mbinim wakl Njurusalem po pindib paesmi tomb Njises obu Ngaor Hen Moroklme Anda andaon pisaol, Nju semon baolum aol aondao baeben di, mbinin man buwaloklme aol baeben di, mbinin maomb bo haroklme aol, aol kon wi baeben di ngo baeben hambun ora Njises obu hasaol was obo kiril mbaesmisa. ");
INSERT INTO akh_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ngub obo kiril mbabur mbinim Njises bor kakl, Njen buri ngo asub bi ora mondom ngo sao baeben bu hael? Njem ngo bu harili ub benin ko, buri ngo aebom ora taol bu njisao? Njem ngo sao baeben aem bibi ko kao njisao ub ora bu hael? kismisa. ");
INSERT INTO akh_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ngo tomb Njisesom mbini bor kakl, Nim di ini bor angal kang bombor ora mend ne mun ub inim angal ngo oborob ora ko san laem sin, nim di ini bor aol ngon burim ora ngo sao baeben bu haruklu ko kao njuklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ngub kobur kakl, Njonom mbabtas bu hasao ub Ngaorom bi kisao ub bu hasao be? be? obum baehaemen sul aol henengom bimi ub bu hasao? Inim nao angal ngon ko san lib ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ngub kisaol mbini hakl hakl ab saond bi bi bu, naom asub ora kem yeb kao kao bubur kakl, Naom Ngaorom bi kisao ub bisao lomao tomb obum nao bor inim asub ko Njonom ngo kisao ub oborob pango, man ngol hul ha nao hasmib? lao. ");
INSERT INTO akh_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Aoh, naom Njon obum sul aol henengom bimi ub bisao di kokl buwaklmao ora kismisa. Mbinim ngo kismi ub tenaol hambunom Njon obu Ngaoron man mini aol hasao ko ora hindismil, mbinim pakl homobur kismisa. ");
INSERT INTO akh_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mbinim ngub nen sabokl buwabur Njises obun angal ndan ko san lubur kakl, Nao nao hende kismisa. Ngub kismil Njisesom mbini bor kakl, Nim di inim ngo lem ub was, nim hambun sao ngo bu haruklu e ub aol ngon burim bu haruklu ko ini nao kao njuklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ngo tomb Njisesom mbini bor angal mar mendbor kao kalobur kakl, Aol mondom obun waen il em aondao mend bobur kisaon, obum paeb bu tundabur em ndaon ngo bor waen il ngo baeben hala singbiyukl bi sowaol ongor sao tombo u, ib mal mend win kobur obum em ngo bor waen il em ngo maomb bo hakl bi and mend yu kem bor sao taokl tumu ora bisesa. Ngub bubur kisaon obum em ngo aol mendbor bisnis kongon bimi aol baeben bor maeb hakaklwaebe kaoklbir, em aorao ngo obu su enderae ora mendel pobur ngo bor bao hasesa. ");
INSERT INTO akh_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ngo tomb mabor waen il nda naeb sisao tomb aol em aorao ndam obun kongon biyao aol is mend obun waen il em ngo maeb haroklme aol nda baeben hasmil, obun waen il ngon mendbor waklemi ko nen sabobur makl pu kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ngub pu kisaol pisao tomb waen il em kongon bimi nda baebenom obu men habur doroklom khorob ora lubur kismin, waen il ndan mend em aorao ngon nao wae baehaemen pu kismisa. ");
INSERT INTO akh_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ngub bismil em aorao ndam wakl obun kongon biyao aol is mende obun waen il ngon mendbor makl pu kisaol, mbinim obu khorob ora wesmbao kakl lao peb bu hondo ko bowes bismisa. ");
INSERT INTO akh_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ngub bismi o em aorao ndam obun kongon biyao aol is tebo di mbini hasmil pen kisaol, mbinim obu pe paen lu tuwaesmisa. Ngo tomb wakl waen il em aorao ndam obun kongon bimi aol andub ora mendbor di wakl was nao waen il ngon mend njin makl puklub ko pen kao was bisao o, waen il em maeb haroklme aol nda baebenom waen il aoraon kongon bimi aol ngo baebenon mendbor doroklom lubur, mendbor ora pe paen li was bismisa. ");
INSERT INTO akh_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ngo tomb waen il em aorao nda obun kongon bimi aol pu kisao nda baeben hambun bor ngub was bismil, is bombor ora mend bao ware ha hasaol, is bombor ora ngo obun isi kuwis akl kone waoraoklao o sisao kisesa. Bombor ngo sisao o em aorao ndam kakl, Mbinim nao isi ngon angal non ebe pangoklemi ora kobur kisaon, obum obun isi kone wisao bombor ngo obun waen il em maeb haroklme aol nda baeben hasmil pen kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ngub pen kisao tomb aol waen il em maeb hasmi aol nda baebenom mbini hakl hakl kao kao bubur kakl, Aol ngo obum obun abon wiyao sao baeben hambun sao obum was maeb habur, waen il em ngo naom maeb hayom o di obun ora soklaong, waen il em ngo naon ora sen ub naom obu pe paen lem kismi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ngo tomb Njisesom ngub kobur kakl, Aoraon waen il em maeb haroklme aol nda baebenom ngub kobur kismin, mbinim em aoraon isi ngo di men ha pe paen lubur kismin, waen il em ngon paeb dera nan lu turaesmisa. ");
INSERT INTO akh_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Njisesom ngub kobur kakl, Waen il em aorao ngom waen il em maeb haroklme aol ngo baeben bor asub ora buklao ko pangeyem? kisesa. Ngub kobur kakl, Em aorao ndam obobur laon obun waen il em maeb haroklme aol ngo baeben pe paen lu tuwabur, obum obun waen il em ngo aol tangar mendborom maeb haen lao ko Njisesom angal mar ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ngo tomb Njisesom wakl kakl, Inim Ngaoron mbuk waeb bor ke wiyao ub nao hendeme be? Ngub ke wiyao. And kongon bimi aol baebenom And ndaol tokl mend kho kang e ko nen sabobur Tuwaesmi o wakl ngubi tomb And pinj* tao tao aondao hobao sao ora men aolisao. ");
INSERT INTO akh_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Aorao Aondaom ngub mao haesaol hendemao tomb Oborob ora bise ko nen sabeyom ko mbuk waeb bor ke wisao ub Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ngo tomb Nju semon baolum aol aondao baeben di, mbinin man buwaloklme aol baeben di, mbinin maomb bo haroklme aol, aol kon wi hasmi baeben di, ngo hasmi nda baebenom angal mar ngo obum nao bor ora le ko ora hondobur kismin, mbinim Njises obu bao men haklbur bismi o tenaol andub ora Njisesom angal ngo kisao ub pangokl obo kiril mba birismi baeben pakl homobur nao men hae bao waklbir kismin, Njises obu ngol bao haen mbini paokl ora pismisa. ");
INSERT INTO akh_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ngo tomb mbinim Peresi aol mendbor di, mbinin aol wesmbao Heroron sem mendbor di ngo baeben oran Njises hayaol puklub kobur kakl, Inim Njises obum angal khorob mendbor naom obu te mao saraeb se oran mendbor ken ub, inim sub kakla sowa pabur angal andub ora mundub baol baol bu, obum angal khorob kaeb se haklon ne mibaebe ko karu mao kikil baesmisa. ");
INSERT INTO akh_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ngub karu mao kikil baesmil mbinim Njises hasaol obobur obu bor kakl, Aol aondao o naom di nje ora hendeyom. Njem angal di heneng was kale. Njem mbini aol aondao hayem baeben di mbini aol aondao mend harilim ko sor nao mirili ora. Mend di njem aol aondao imbi wi hayem baeben bor angal tangar ubi kobur, aol mendbor imbi nao wi kang sao hayem baeben o bor kone tangar ub u angal tangar ub kao kao nao bili ora. Ngub inj, njem tenaol hambun bor kone bombor ora u heneng was kobur Ngaorom nen sabeyao ub was kao kalo hariling, njem asub nen sobal? Naom Orom semon aol wesmbao aondao Sisam nao bor mone takis nji lao ub kalam sin ebe be? kho. Naom kalemin be? nao kalemin ko pangal? Naon manom asub ke wiyaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ngo tomb mbinim Njises obu maobowabur ngo kismi ub obum mbinin kone bor ora hondobur obum mbini bor kakl, Inim asub ko ni maobowa hendeklem balem? Pangeklem. Inim mone il hond mend hondon ub mini ubuklub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ngub kisaol mbinim obu ngub mone il hond mend mini obo kalismi tomb obum mbini bor ne mubur kakl, Mone il ngol piksa ngo wi o hesa imbi ngo wi o kab, aeben non bi eb? kisesa. Ngub kisaol mbinim Njises bor kakl, Orom semon aol wesmbao aondao Sisa ndan non bi e kismisa. ");
INSERT INTO akh_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Ebe ka. Sisa obun sa sin obu ora kaloklwaebe. Ngub inj, Ngaoron menjao sa sin Ngaor kaloklwaebe kisesa. Ngub kisaol mbinim angal ngo pangobur burir aondao ora bismisa. ");
INSERT INTO akh_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ngo tomb Sarusi tenaol baebenom tenaol pe paklemi baeben wakl ko mende nao enjoklemi kismi ub kobur, Sarusi sem ngo baebenon mendbor Njises obu hasaol obobur mbinim obu bor ne mubur kakl, ");
INSERT INTO akh_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Aol aondao o Mbes Mosesom nao bor angal ukl mend ngub bibaebe ko waeb bu wisao ka. Aol mend obun ten taol buklao o nongnas is mend and nao senbur bao homa sin, ten weyae ngo obun haemem taol bubur obun haeme ngo homoklao on nongnas maru waklao ora ko waeb bu wisesa ko mbinim Njises kao kalismisa. ");
INSERT INTO akh_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mbinim ngub kobur wakl kakl, Mbes aol mbini haemeyaen is haoklao mend hasmi o, mubao ndam obun ten taol bisao o obum nongnas is mend nao maru wisao tomb obu bao himisaol, ");
INSERT INTO akh_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ten weyae ngo obun haeme kabo nanom taol bisao o kabo nan ngom di nongnas is mend nao maru wisao tomb bao himisesa. Ngub bisaol haeme tebo nan ndam taol bisao o, ngom di is mend nao maru wi tomb bombor ngub was bisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ngo tomb ten ngo obu nongnas is mend and nao se weyae baram aeben was bisaol, ten weyae baram aeben bisao ngo mbini haemeyaen is haoklao hambunom taol bismi o, ngo baeben hambunon nongnas is mend and nao sen was hambun himismil, ma ora bor ten ngo obu di homo kowes bisao kismisa. ");
INSERT INTO akh_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Mbinim ngub kobur kakl, Njem di ora nen sobal ub ten ngo obu mbini aol is haoklao haemeyaen ngo baeben hambunon were ora birisaong, njem kale nda ub mabor tenaol heme baeben enjaokl enjaokl poklemi tomb ten ngo obu aeben were ora buruklaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ngub kismil Njisesom mbini bor kakl, Inim Ngaoron mbuk waeb bor wiyao ub hesa Ngaoron buri kab nao hende sakl, inim angal ngo lem o khorob ora lem kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ngub kobur kakl, Tenaol heme baeben mbinin maol bor wakl enjoklemi tomb mbini Ngaoron angal mini wesao yu heben bor haeme ubi ora haklemil, tenom aol po aolom ten taol bu ngub nao buklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wakl kakl, Ngub buklemi o tenaol heme wakl enjoklemi ub mbes Moses bor Ngaorom is hini sung disao nda darukl o bor kao kalisaol, mbuk waeb bu wisao ub nao hendeme be? Arman ngo Ngaorom Moses bor kao kalisao ub ngub wiyao. Ni Eberehem di Isak di Njekob di ngo himismi baebenon Ngaor ora hae kisao o, ");
INSERT INTO akh_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ngaor obu tenaol pe pabur songol bung biyao saon Ngaor inj, wesao pobur haeben soklme baebenon Ngaor ora hayaol, inim angal ngo lem o khorob ora lem ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ngo tomb Nju semon man buwalaoklao aol mend obobur pangisaol, Njises daol Sarusi aol nda baeben daol engelom kao kao bi wismi tomb Njisesom mbini bor angal oborob ora ngo ko san lisao nda pangobur, obum Njiseson angal ngon ko san lubur kakl, Ngaoron man hambun sao wiyao on hobao sao aondao bombor oran awo wiyaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ngo tomb Njisesom obun angal ngon ko san lubur kakl, Man hobao sao oran ngo ora yaong, ini Isreyel tenaol baebenom angal ngo oborob ora pangoklwaebe. Naon Aorao Aondao Ngaor obu bombor naon Ngaor aondao ora hayao. Aorao mende nao hae kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ngub kobur kakl, Njem njen Aorao Aondao Ngaor bor turi aondao ora homobur lesin, njen hibim di njen konem di njen wesaom di njen burim di njen Aorao Ngaorol turi homo kone wibi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ngub kobur kakl, Man ngon kabo ngub wiyao. Njem njen mbib was nen sabo hem kale ub njem njen tenaol sango mende di hem kobur hond homo kone wibi kisesa. Ngub kobur kakl, Man ukl kab ngo hobao sao aondao ora yaol, Ngaoron man tangar wiyao baeben hambunon bombor mondom man ukl kab ngo nao men mbayao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ngo tomb Nju semon man buwaloklao aol ndam Njises bor kakl, Aol aondao o, e ka. Heneng ora Ngaor obu bombor o aondao ora hayao. Kaoya kaeb se aondao ora mende nao hae, njem heneng ora kal kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Aol ndam ngub kobur kakl, Heneng ora naon hibim di naon konem di naon burim di naon Aorao Ngaorol turi homo kone ubur, man ukl mende di naom naon mbib nen sabo hem lomao nda ub naom tenaol mendel hem kobur hond homo kone u ngub bam sin, man ukl kab ngom Ngaoron man hambun di ora men mbayao kisesa. Ngub kobur kakl, Ngaor bor kalobur mabaorao kao ebe pebe mend haoroklme nda ub di, Ngaor bor mabaorao tangar tangar kaloklme ub di, man ngom ora men mbayao ub ora kal kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ngo tomb aol ndam Njises obun angal oborob ora, aol kone kikil bim lome nda ub ora kobur ko san lisaol pangobur Njisesom aol nda bor kakl, Nje Ngaorom maeb ha maomb bo hayaol teb so ora hael kisesa. Ngo tomb tenaol ngo hasmi baebenom Njises bor angal tangar mendbor wakl ko mende ne di menjao nao mi pakl homobur bao waesmisa. ");
INSERT INTO akh_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ngo tomb Njises obum Ngaor Hen Moroklme Anda ngo bor bao habur, tenaol hambunom pangen Ngaoron Angal Bib Hobao Sao nda kao dund bubur obum mbini bor kakl, Nju semon man buwaloklme aol baebenom, asub ko Ngaorom Eben Lao Aol o obu aol wesmbao Debir semon isi soklao lomeb? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ngub kobur kakl, Mbes Ngaoron Wesaom aol wesmbao aondao Debir ngo obun kone bor hondaesao tomb Debiron ngub kisao. Hambun Saon Aoraom nao Aorao Aondao bor kakl Ngubi tomb njem nao ki tao nan bao berel o Mabor njen saond bi baeben Njen aongao ma bundur nan hala mbanin lowao kisao ko Debirom waeb bu wisao ub Njisesom kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Njisesom mbini bor wakl kakl, Debir obun mbib nao Aorao Aondao kisaong, mbinim asub ko Ngaorom Eben Lao Aol bor Debir semon isi heneng soklao lomeb? kisesa. Ngub kisaol tenaol aondao ngo hasmi baebenom obum angal ngo kisao ub turi homo pangismisa. ");
INSERT INTO akh_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ngo tomb Njisesom mbini bor oborob ora ko mao dund bam bam bubur obum mbini bor kakl, Mbini Nju semon man buwaloklme aol ngo baebenom lab lab ebe saoll saoll on was samobur ebekone po akol akol bukl nda pobo haroklme. Ngub bubur lomen mbinim tenaol hambun obo kiril mba boroklme su o bor ebekone po, mbini bor kaoya ken ko mbinim tenaol hambunon el sol ki siken buklemi on was turi homo haroklmeng, inim oborob hondo ora haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ngub kobur kakl, Mbini ngo baebenom mbinin man pangoklme anda bor tenaol hambunon el so panda tukun ebe ol was turi homo burukl nda pobobur, mbinim ne aondao mend noklbur bereme tomb di mbinim panda tukun was mu pakl ke ke bimi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ngub kobur kakl, Mbinim ten mendbor mbinin aoli heme baebenon and di mbinin osisao baeben di taol pe mu habur lomen, kakla mbinim khorob ngo beme saon pe kowes bubur, tenaolom mbini ebe hae ken ko Ngaor bor ko soklo aondao bu ora ko haroklme. Mbinim ngub bimil Ngaorom tenaol hambun sarbeklao tomb mendborom ke hondoklemi ub men mbabur, mbini ngo baeben ke aondao bu ora hondoklbur hayem ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ngo tomb Njises obu Ngaor Hen Moroklme Andan mone tundaroklme be wisao teb sol burubur, tenaol hambunom Ngaor bor kalo mone tundaroklme be ngo bor tundakl engel bismil hindisao tomb homa tenaol baebenom mone aondao andub ora tundakl engel bismil hindisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ngo tomb ten weyae obun aoli heme kang mondom obun mone kang ora di nao wi birisao o, mone kang hond kab mend tundaesao ub toya bombor menger, mone hundbi kang ndisao kab mend sisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ngo tomb Njisesom obun man pange aol nda baeben ubuklub kobur mbini bor kakl, Nim ini bor heneng ora kao njurukl, ten weyae mango biri obun aoli heme kang ngom mone hundbi kang ngo tundaraokl om, tenaol hambunom mone aondao ngo Ngaor bor kalaemnda baeben hambun men mbaraokl kisesa. ");
INSERT INTO akh_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Njisesom ngub kobur kakl, Tenaol aondao ngo baebenom mbinin mone andub ora maru u habur, naom aondao ngo maru u hayom sao kobur mendbor Ngaor bor kalaemnda o, ten weyae mango biri kang ngo obum non, obum mone nao wi ora burubur o obun kang mend u baoraoklao baeben oran, obun ne dob bu nokl bi di kang mend nao baondib mini hambun ora ngo tundaraokl o kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ngo tomb Njises obu Ngaor Hen Moroklme Anda ngol haklbir pisaol, obun man pange aol is mondom Njises obu bor kakl, Aol aondao o hend, mbinim han aondao aondao was om and ngo baeben oborob ora bismil, and ebe was ngol haen hend dao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ngub kisaol Njisesom obun angal ngon ko san ngub lisao. Njem and ebe aondao ngo hae hakl hendel be? Mbinim han sango menden mandaemol di hond mend baondib munu bao win wa nao buklemi ora. Ngub inj, mbinim and ngo hakl hambun ora bo kobaolu bowes buklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ngo tomb Njises obu har Olib manda bor burubur Njurusalem bor Ngaor Hen Moroklme Anda hasao o hakl hen men sa peb bu birisaol, Pita di Njemus Njon kab haemeyakl di, Andur di mbini ngo baeben ora ware pe Njises birisao ndal obobur mbinim obu bor ne mubur kakl, ");
INSERT INTO akh_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Njem ngo buklao kaendisao baeben atomb ora buklao bor kae bo? Njem nao kao nji kismisa. Ngub kobur kakl, Njem ngo buklao kaendisao baeben buklbur buklao tomb, naom pibnao oran asao mbes buklaol hondobur njem ngo buklao kal sao baeben teb saol ko pangoklmaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ngo tomb Njisesom mbini kao kalobur kakl, Pangeklem. Tenaol mendborom ini maobowabur kakla lemi hondo ora haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ngub kobur kakl, Aol andub ora ini haklemil obobur mbinim ni hae non bubur lemin, ni Ngaorom Eben Ke Aol ora hae kobur mbinim tenaol andub ora maobowam akol bu haklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Njisesom mbini bor wakl kakl, Teb sol sao di enderael sao di saond aondao ora mend daoklu li li buklebil, inim poboklo oboklaol pangoklemi tomb inim pakl homo burir nao biklwaebe ora kisesa. Ngub kobur kakl, Nim ngo kakl sao mbes buklao o, mabor bao bu kowes buklao o nao pindib pae wen soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Wakl kakl, Aol sem tangar mondom sem mende saond bu kaloklao. Ngo tomb kabman semom di sem mende bor saond bu kal kal buklemi kisesa. Ngub buklao tomb su mendbor su dull bere aondao ora oboklao. Su mendbor di de aondao ora oboklao kisesa. Ngub kobur kakl, Tenom nongnas maruklbur beme tomb mabor tenda aondao bu ora buklbur o, pibnao kang bu bam bam biyao nda ub menger, nim ngo kakl sao baeben mbes buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ngub kobur wakl kakl, Ngo sao hakl buklao tomb mbinim ini mbinin kansol baebenon el sol men pae po mao habur howes leming, hondo ora haklwaebe ka. Mbinim ngub bubur lemin ini mbinin man pangoklme anda andaon bor doroklom luklemi kisesa. Ngub kobur kakl, Mbinim ni men mbaklwao ko nen sabobur lemin, mbinim ini aol wesmbao baebenon el sol mini po mao habur, kabmanon maomb bo haroklme aol aondao baebenon el sol di mini po mao haklemi ora. Ngub bukleming inim ninao imbi wib se sao on was kao kalobur Angal Bib Hobao Sao o was mbini hambunom pangen lowaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Njisesom wakl kakl, Hambun sao ngub buklao o pangeklem. Inim su hambun bor nao Angal Bib Hobao Sao mbes tenaol hambunom pangaen kao kaloklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ngub kobur kakl, Mbinim ini men pae pobur howes lemi tomb, inim mbini bor angal asub was ko san luklwaob kobur pakl nao homo wibaebe ora. Pangeklem. Bombor ngo ora tomb mbinim ini bor angal ngo lemi baebenon ko san lereklemin ko, Ngaorom inin kone bor kao njuklao ub was lemil, inim inin mbib was habur inj lemi ka. Ngub inj, inim Ngaoron Wesao oram kao lao ub was lemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Wakl kakl, Ngub buklao tomb mabor aol mendborom mbinin haeme o bor howes ko karu luklemil mbinim pe paen luklemi. Ngo tomb bombor ngub was aol baebenom di mbinin nongnas sisao ngub bi bi buklemi. Ngub buklemi tomb nongnas baebenom di mbinin ingi aorao baeben bor saond bi sao ha ha bubur lemin, mbinin ingi aorao ngo baeben pe paen karu luklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Njisesom wakl kakl, Inim nil hul ha haklemil tenaol hambunom ini hendaebe makl aondao ora homobur nar wen ebe hende non buklemi kisesa. Ngub kobur kakl, Mbinim ngub buklemi o tenaol mendbor nil hul ha saor pe was bao harim sin, Ngaorom mbini bu muklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ngo tomb Njisesom kakl, Inim mabor hondoklemil kho mao sakl buklao sao ngom su enjo ngo bor kho mao saklao o, mbinim kho ngo sao nao haeb se hobao sao o haraoklao ol akl bu mao haklemi kisesa. Pangeklem. Tenaol mendbor mbuk waeb ngo bor wiyao ub hondoklesi baebenom oborob ora hondobur kone kimb bibaebe. Ngo tomb Njisesom wakl kakl, Ngub buklao tomb tenaol mendbor su Njuriya bor buruklemi baeben yu har ne baeben bor pakl paokl puklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ngub kobur kakl, Aol mondom njen and wil dera nan hari sin, njen osisao uklesi o mukl wakl andaon nao hondaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wakl kakl, Mende di aol mondom njen em bor hari sin, njen toklo and turub bi mukl anda nao pe pakl paokl ora pebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ngub kobur kakl, Is ora alem, ngo sao buklao tomb ten mendbor hondbao pango uklemi baeben hesa nongnas aondu ne baeben kab oran hond bu pae delib ebe ora soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ngub kobur kakl, Pibi hon oboklaol hub ingi soklao on oran khorob ngo sao nao eben kaebe ko Ngaor bor kao kaloklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ngo tomb Njisesom wakl kakl, Is ora alem, bao ngo pindib paklao tomb ke aondao ora ngo hondoklemi ka. Mbes Ngaorom su wen warisao tomb di, karasmas hambun ora ngubi tomb di, ke khorob sao aondao ngubi mend nao hindismi ora kisesa. Ngub kobur kakl, Ke aondao ngo hondoklemi ubi mend sul bao haklemi tomb mabor di nao hondoklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ngub kobur kakl, Ngaorom ngo sao buklao o bao hor andub ora nao ndi tibaklwao ko nen nao sabokl bisaon tenaol is mend nao bulaokl pokl beme o, Ngaorom mbes obun tenaol sablo haen ko komb bi ora haen kisao baeben hond homobur, bao hor andub ora ndi nao tibaklwao ko nen sabisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Njisesom ngub kobur kakl, Ngo sao baeben hambun sao buklao tomb aol mendborom ini bor ngub lemi. Ngaorom Eben Ke Aol obu enjo ngo bor ngo hae o haondaoklaob. Aoh, obu isu ngo bor hayaong haondaoklaob leming, mbinim ini bor ngo lemi ub heneng lem ko nen nao saboklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ngub kobur kakl, Mabor mendborom ni Ngaorom Eben Ke Aol ora hae. Mendborom di man tangar mini obobur ni Ngaoron man mini aol hae ko tenaol hambun maobowakl obobur, mbinim tenaolom ko mend nao hindismi sao di burir biklme sao di bam akol bubur, tenaol Ngaorom sablo haen kisao baebenon kone bor di ngil ngaol mao kabur maobowa hondoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Njisesom wakl kakl, Nim ini bor ngo sao baeben hambun sao wen buklao ub ngo kao njurukl ong, inim oborob hondo ora haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ngo tomb Njisesom ngub kobur kakl, Ke aondao ngo baeben hend paklemi tomb penar bu ora nar nao debur em hundur aondao ora uklaol, ek di nao doklao ora. ");
INSERT INTO akh_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Saosolbaem ngo saoharol harekle baeben di sul tol hakl ib ib buklaol, saoharol buri wiyao sao baeben di buri nao pale dur kobur demi ora men koroklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ngub kobur kakl, Ngub buklao tomb mbinim Aolon Isi Ora mulaol darukl oral oboklaol hondoklemil, obu buri paolaoklbir nar el sao bao bi hakol bi ora oboklaol hondoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Njisesom wakl kakl, Ngub oboklao tomb obum obun angal mini wesao baeben su hambun bor pen kobur, yu nan di unu nan di umu nan di ana nan di su uklu lisao hakl hambun bor di Ngaorom tenaol mbes sablo haen kisao baeben hambun ora obo kiril mbaen lao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ngo tomb Njisesom ngub kobur kakl, Inim is dullub ma biyao nda ub oborob ora nen saboklwaebe. Is baoklaol ib ib bubur ma bu kimb beyao tomb inim ngub lome. Is ma wen beneng, ngubi tomb nar eben sene lome kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ngub kobur kakl, Menger bombor ngub was mubur inim nim o kao njandisao baeben hambun sao bam bam buklaol handaem sin, Aolon Isi Ora obu oboklbur teb so ora tiriyao kombael hend dera haril ko nen saboklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Obum ngub kobur kakl, Nim ini bor heneng ora kao njurukl, tenaol ngubi tomb hayem baeben nao heme bao haen was nim ini bor ngo buklao kandisao baeben buklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ngub kobur kakl, Su di saohar di mabor hambun sao bum haklao o, nao angal bombor o nao bum hae wi aeben soklao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ngo tomb Njisesom kakl, Ngo sao hora buklao be? somna buklao, ekera be? ndum buklaob ko mondom nao hende ora hayem kisesa. Ngaoron angal mini wesao yu heben haeme baebenom di nao hende ora haeme. Ab aondaon Isim di nao hende ora hayao o, Ab aondao obum bombor o ora hendeyao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ngub kobur kakl, Inim obu ngo tomb obo pindib paklaob ko nao hende ora hayem ngao, enjmor nao ke oborob hend ha ora haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ngo tomb obum angal mar mend di kobur kakl, Aol aondao mondom obu su tangar mendbor poklbur kisaon, obun kongon bimi aol baeben bor obun hambun sao maeb haklwaebe kobur obum mbini bor kongon di armend sisao taol bu kalisesa. Ngub bubur kisaon obun tiriyao kombael maeb haroklao aol bor di njem oborob ora hondo haebe kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Wakl kakl, Nim mar ngo kakl ub menger mubur, and aorao ndam ombonao oboklao be? somna undum tuku oboklao be? sao kulao angal buklao tomb oboklao be? hokloben oboklao be? atomb ora oboklaob ko ini nao hende hayem ngao, oborob hondo ora haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ngub kobur kakl, Inim obu penar bu ora oboklao ko nen nao sabe, enjmor kobur u paol pe uklemi tomb oboklaong hondoklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Njisesom ngub kobur kakl, Nim ini bor angal ngo kao njurukl ub tenaol hambun bor di kao kalakl. Inim besao kon nao wi oborob hend ha ora haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ngo tomb Nju sem Waran Aeben Bisao hor so hesa mbinin palawe and mao saraoklao sao yis nao haru noklme hor so kab* pindib paklbur, bao hor kab ora bao wisao tomb Nju semon baolum aol aondao baeben di, mbinin man buwaloklme aol baeben di, ngo baebenom kar mba habur kakl, Naom asub ora bubur Njises oran kakla kao beya di men habur pe paen lem yeb ko kar mba hasmisa. ");
INSERT INTO akh_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mbinim ngub kar mba habur kakl, Ngub bemin ora o naom tenaol hambun kiril mba hor so boroklme bao ngon non ngub nao bemin ora. Naom ngo tomb Njises men harum sin tenaol hambunom sob aondao bu ora lemi kismisa. ");
INSERT INTO akh_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ngo tomb Njisesom obu su Betani bor habur aol maollun bi menden imbi Simonon anda bor hasao o, ko mend oran ne noklbur birisao tomb ten mondom han alpastam* wari be ebe teraebi buri ora mend sisao bor, wel sem tangar kao ebe ora pebe mend mbinim mone andub ora deng ko mu hasmi on imbi nar wel* kismil, ten ndam wel ngo sao ber pae mend mini obobur, Njises obu ne noklbur birisaol han be ngo kom munubur kisaon, Njiseson wesmbaol kowe beyaesesa. ");
INSERT INTO akh_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ngub bisao o aol mendborom ten ndam ngo bisao ub mbinin kone bor makl aondao ora homobur mbini hakl hakl kakl, Ten ngom nar wel ebe ngo asub ko kowe bowes bi bo? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mbinim ngub kobur kakl, Ten ngom nar wel ebe ngo kowe bowes bi ub nao bukl baonaon, obum tenaol tangarom wel ngo dob bin mone andub ora pao 300 di menjao mubur, obum tenaol mendbor menjao nao wi burubur dam nao bin bereyem baeben ebe taol bu kalokl baonao kobur kismin, mbinim ten nda makl homo khorob ora taolu lismisa. ");
INSERT INTO akh_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ngub bismi o Njisesom mbini bor kakl, Ten ngom ni bor oborob ora bin ngub bin wa ora. Inim asub ko ten ngo obun kone bor kend mao ba kho mao sareklem? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ngo tomb obum wakl kakl, Inim tenaol mendbor menjao nao wi burubur dam nao bin boroklme baeben hesa non ini daol hor hor was haklemi. Ngub buklemil inim mbini bisur buklmao ko nen sobaem sin ebe bisur buklemi o, ni non ini daol hor hor bao ha kimb was nao buklmao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ngub kobur kakl, Ten ngom ebe bibi wi ub ora beng, ngub bin wa ora. Ten ngom nao toklol nar wel ngo kowe beyaraokl o, mabor mbinim ni pe pan luklemil nao maol bor ni tangaklbur man man buklemi ub ngo bi o kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Njisesom ngub kobur kakl, Nim ini bor heneng ora kao njurukl, nim bu haruklu sao baeben hesa mbinim ni bor buklemi sao baeben kabon arman Angal Bib Hobao Sao ngo tenaol hambunom pangen kam akol buklemi darukl o bor, ten ngom ngo bi ub di haru kam akol buklemil ngo sao di tenaol hambunom nen saboklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ngo tomb Njiseson man pange aol baebenon duteb nan o Iskeriyaor Njuras obum Njises karu luklbur kisaon, Nju semon baolum aol aondao baeben birismil obum Njises men pae puklub lao on karukl pisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ngo tomb Njurasom ngub kisaol pangobur kismin, Nju semon baolum aol nda baebenom turi aondao ora homobur, mbinim Njuras mone mendbor kaloklemi on di naom ngub baeben ora kalemin ko kao paesmisa. Ngub bismil ngo ora tomb Njurasom Njises men pae puklub lao on, bao awon ora men pae puklub lowao saol ko kone kimb bu birisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ngo tomb Nju semon palawe and mao saraoklao sao yis nao haru noklme hor so pindib paesaol, bao ngo pindib payao tomb Waran Aeben Bisao bao on di some sib hondbao lu sa ha was bismi bao on sisaol, Njises obun man pange baebenom Njises bor kakl, Naom Waran Aeben Bisao bao on ne nemin ko njem abor ora man man bukl paomun ko nen sobal? kismisa. ");
INSERT INTO akh_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ngub kismil Njisesom obun man pange aol is kab mend puklub kobur mbibi bor kakl, Ibim su and lobokl lobokl ora bor poklebi tomb aol is mend obun ib be aondao mend taoklbir ibi hen mukl harerol ubukl haklaong, ");
INSERT INTO akh_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ibim aol ngo obun mama was taol mi puklwaebe kisesa. Ngub kobur kakl, Aol ngo obu and menden hondaklao tomb ibim and aorao ngo bor ngub ora lowaebe. Aol aondaom nje bor nao man pange aol baeben daol haru Waran Aeben Bisao hor son ne noklmao o ninao and tubal awon noklmaob? ka lowaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wakl kakl, Ibim ngub lebi tomb obum and tubal yu mandaem nan o bor, panda nao buruklmao on di hambun sao oborob ora man man bu mbae aondao ora mend ibi muwaloklaong, ibim and tubal ngo oran ne nemin ub man man bibaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ngo tomb Njiseson man pange aol is kab ndam pobur kisbin, su and lobokl lobokl nda bor po pindib paesbi tomb Njisesom mbibi bor kao kalisao nda ub hend wabur kisbin, Waran Aeben Bisao bao ngon ne noklemi on man man bu mbaesbisa. ");
INSERT INTO akh_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ngo tomb mabor somna Njises obun man pange aol duteb nda baeben daol haru obobur, ");
INSERT INTO akh_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","tol buru kimb bu ne nao mba hasmi tomb Njisesom obun man pange aol ngo baeben bor kakl, Nim ini bor heneng ora kao njurukl, ini ngo bereyem haklon is mondom ni karu luklaol, aol ngo obu enjo ngo ni hesa bomborol ne no bereyob om ora buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ngub kisaol obun man pange aol ngo baebenom aem ngub buklao bor leb ko nen sabobur kismin, mbinin kone bor kho so hem aondao ora kobur mbinim Njises bor ni bor kal be? ko, armend sisao ne mi mi bismisa. ");
INSERT INTO akh_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ngo tomb Njisesom mbini bor kakl, Ini ngo man pange aol duteb ngo baebenon aol is mend ngo obu ni hesa yao bomborol burubur, obun ndis ngo bor ne ngo mib bu nakl wi om ora buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Njisesom ngub kobur kakl, Heneng ora Aolon Isi Ora obu non Ngaoron mbuk waebom ngub buklao ke wiyao ub mbinim obu heneng ora luklemil obu harer ngon poklao ke wiyao on poklao o, aol ngo obu Aolon Isi Ora karu luklao aol o ke aondao bu ora hondoklaong, obun amom aol ngo obu hel nao marukl bisaon ebe ora sokl bisao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ngo tomb mbini hambun ne ngub nao mba hasmil Njisesom palawe mend mubur kisaon, obum Ngaor bor mbes tengiyu kao pesao tomb obum munu konde barabur obun man pange aol nda baeben taol bu kalobur kakl, Palawe ngo nao toklo njurukl ngao, mib kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ngo tomb Njisesom wakl ib waen ber pae kab mend mubur obum Ngaor bor tengiyu kao peyobur, kab ib waen ber pae ngo obun man pange aol baeben kalisaol mbini hambunom mende no kalam aeben aeben bismisa. ");
INSERT INTO akh_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ngub kalobur kakl, Nim ini ngo njurukl o nao ibao ora njurukl ol, Ngaorom nim tenaol hambun bor heneng ora bisur buklwao kisao ub nao ibao ngom tenaol hambun bu muklbur peben karukl kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ngub kobur kakl, Nim ini bor heneng ora kao njurukl, naom waen il ib ngo naoklaom ub nim ko mende nao ne bao han was, nim Ngaorom maeb ha maomb bo hayao bor pobur ib waen wen pange noklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ngo tomb mbinim we ukl bombor mend kaoya kao peyaoklbir kismin, dera bonge dera peb bibir har Olib manda bor yin pismisa. ");
INSERT INTO akh_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ngo tomb Njisesom obun man pange aol baeben bor kakl, Ngaoron mbuk waebom ngub ke wiyao. Nim some sib maeb haraoklao aol pe paen luklwaol, some sib baeben pakl buri lemi ke wiyao ub heneng ora il so pindib paklaol, ini hambunom nil hul ha haroklme nda ub tuwaklbir pakl buri lemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ngub kobur kakl, Mbinim ni ngub pe pan luklemi o ni wakl mao enjaklaol, ni mbes su Kalili poklwaol ini nao mama oboklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ngo tomb Pitam obu bor kakl, Mbini hambunom njel hul ha haroklme ub tuwakl paem sin, nim bombor o nje nao tuwae njel hul ha, ha kimb was buklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ngub kisaol Njisesom Pita bor kakl, Nim nje bor heneng ora kao njurukl, bao somna ngon sao kulao angal ko kab nao bi haen was njem ko teb oran nim Njises nao hendeyo lesi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ngub kisao o Pitam Njises bor nim ngub nao buklwao ora ko angal buriyab ora kobur kakl, Ni di yao haru homabon ko ora hael, nim nje nao hendeyo nao lowao ora kisesa. Ngo tomb Njiseson man pange aol ngo birismi nda baeben hambunom di ngub was kismisa. ");
INSERT INTO akh_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ngo tomb Njises obu obun man pange aol nda baeben di mbinim su em obal menden imbi Kersemani kismil, ngo bor po pindib paesmi tomb Njisesom obun man pange aol nda baeben bor kakl, Ni kang mend isu ngol sao Ngaor bor kao kalokl pukl ngao, ini ngol bao ber mba haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ngo tomb obum Pita di Njemus Njon kab di, is teb ngo haru pisesa. Ngo tomb Njises obun kone bor ke di kab po kend aondao ora bin birisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ngo tomb Njisesom obun man pange aol is teb nda bor kakl, Nao kone bor ke di kab po kend aondao ora bubur ni pe pae non bi saol ngao, inim ngol ngub habur oborob ora hend ha haklaob kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ngo tomb Njises obu kang mend aeben sao pobur kisaon obum sul dombes ubur Ngaor bor kao kalobur kakl, Njem ni bor ngo buklbur be sao nao bi ebe baondib paen kaeb sa sin, ni bor ngub nao bin kaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ngub kobur kakl, Nao Ab o, njem hambun sao menjao bukl buwa nao biling, njem ebe soklao ko pangal sin njem ni ke hondoklwao ib karae bi ber pae kab ngo mu tuwaebe ora kisesa. Ngub kobur kakl, Aoh, njem nim nen sobakl ub inj bibi ora. Ngub inj, njen mbib nen sabele ub ora bibi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ngo tomb Njises obum obun man pange aol is teb nda birismil pobur hindisaol, mbinim enjmor kobur u paol pesmisa. Ngub bismil Njisesom Pita bor kakl, Simon o inim u paol pe wiyem be? Inim ni daol nao haru kang el bombor ora mend hend peb bu haem nao lemi be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Njisesom ngub kobur obun man pange aol is teb ngo bor wakl kakl, Inin kone bor non nim oborob was buklwao ko nen saboklemi o, songolom bi lao ub ini saokl mao waraoklaong, ini bor khorob mao bakl buklao saom ini khorob nao mao baen ub inim oborob hend ha habur Ngaor bor kao kalaoklaob kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ngo tomb ngub kaoklbir kisaon obum wakl pobur, obum Ngaor bor ngo kao kalisao o pibnao kisao nda ub bombor ngo was wakl ko mende kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ngub kao kal peyaoklbir kisaon, wakl obun man pange aol nda baeben birismil obo hindisaol, mbinin el bor enjmor aondao ora ibisaol u paol pe wismisa. Ngub u paol pe ubur mbinim obu bor angal asao ora kokl inj sisaol, obu bor menjao ko san nao li bao waesmisa. ");
INSERT INTO akh_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ngo tomb Njises obu kang mend mabor sao obun man pange aol nda baeben birismil wakl ko tebo obobur mbini bor kakl, Inim ngo bor hor so burukl obaemil u was bao paol pe wiyem be? Ngon ngubi tomb ngo ora ka. Pangeklem. Mondom Aolon Isi Ora obu karu lubur, khorob bimi aol baeben bor obu men pae puklub ko kaloklao o mbes teb sa kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ngub kobur kakl, Nao paokl mbin ub ini tekaklaob kisesa. Wakl kakl, Aol ni luklbur karaonao aol o mbes isu ngo ebe bor kang haondaoklaob kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ngo tomb Njisesom obun man pange aol baeben bor angal ngub bao kao kalakl haen was, Njuras obu man pange aol duteb nan o obu sisao o, aol aondao ngo ibismi nda darukl o bor obu di haru ibismil hindismi tomb, aol aondao ngo ibismi nda baebenom kuwi kuwinj di kam dorokl hakl taokl taokl bombokl ibismil hindismisa. Ngub ibismi o ngo ibismi baeben Nju semon baolum aol aondao baeben di, mbinin man buwaloklme aol baeben di, mbinin maomb bo haroklme aol, aol kon wi baeben di ngo baebenom Njises men hakl puklub kismil ibismisa. ");
INSERT INTO akh_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ngo tomb aol Njuras ngo Njises karu lisao ndam wen aebenol ibismi tomb, aol aondao ngo Njises men hakl ibismi nda baeben bor kakl, Nim aol mend men habur nunu ka sin aol ngo obu Njises ora soklaong, inim obu men haklwaebe. Ngub bubur obu paokl poklao inim oborob ora hend hakol bubur lemin, inim obu men pae puklwaebe ko karu mao kikil baesaol paongaokl ibismisa. ");
INSERT INTO akh_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ngo tomb Njurasom buklwao kisao nda ub obum Njises birisaol penar bu ora obobur kakl, Aol aondao o kobur kisaon obum Njises nunu kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ngub bisaol hondobur kismin mbinim Njises men hasmisa. ");
INSERT INTO akh_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ngub bismi tomb aol is mend ngol hasao om obun kuwi kuwinj mend hak bor marisao o mubur, obum Nju semon baolum aol wesmbao aondao oran kongon biyao aol mend sisao on hal taokl bo kobaesesa. ");
INSERT INTO akh_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ngo tomb Njisesom aol aondao ngo obu men hakl ibismi nda baeben bor kakl, Inim kuwi kam dorokl mini mini obobur, inim aol menden osisao taol pe mu haraoklao aol mend men haklbur sao ubuklim be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ngub kobur kakl, Nim hor hambunon Ngaor Hen Moroklme Anda bor honda ha was burubur, ni ini daol nao haru boroklmao nda tomb di tenaol hambunom pangen Ngaoron man hambun sao kao dund bu haruklu nda tomb inim ni nao men haroklme nda o, embi non Ngaoron mbuk waeb bor buklao ke wiyao ub heneng ora ngo il so pind bile ol sakl, embin ngo beyem o ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ngub kisao tomb Njiseson man pange aol nda baeben hambun Njises ngub bismil hondaoklbir pakl paokl pismisa. ");
INSERT INTO akh_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ngo tomb ngub pakl buri kismi tomb Njises obu daol haru hasmi ndan nas is mend obun lab lab haek bi tokl bombor ora sam hae mend Njises obu men pae pismi bor mama taol mi ibisaol, aol aondao ngo Njises men pae pismi nda baebenom obu men hasmi o, ");
INSERT INTO akh_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","kundukl munubur obun lab lab haek bi ngo samo taokl ibisao nda kol mismil, lab lab haek bi ngo mao manaklbir toklo bube pakl paokl ora pisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ngo tomb mbinim Njises obu Nju semon baolum aol wesmbao aondao oran anda mini pismil, Nju semon baolum aol aondao baeben di, mbinin maomb bo haroklme aol, aol kon wi baeben di, mbinin man buwaloklme aol baeben di ngo baeben hambun baolum aol wesmbao aondao ngon anda bor was obo kiril mba birismisa. ");
INSERT INTO akh_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ngo tomb Pita obu mbinim Njises mini pismi bor mama taol mi pisao o obu kang mend enderael sao wen pisesa. Ngub pobur kisaon obum baolum aol wesmbao aondao ngon anda saond paeb mbuklu tundae ngo oran hondabur, polisman baeben birismi ol is mend ngol do hasaol, obu di ngol hub sabo birisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ngo tomb Nju semon baolum aol aondao baeben di mbinin kansol baeben di mbini hambunom Njises obum bu hasao sao baebenon obu te mao sara, obu pe paen lib se oran aol aem ora leb ko hondoklbur aol hambun ubuklub ko ne mismi o, obu pe paen lib se obum khorob bisao sao oran mend nao mao bemberaesmisa. ");
INSERT INTO akh_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ngo tomb aol andubom ora Njises obu bor ngo sao ngo sao bisao ko, kakla kao beya pe paen luklbur andub sao te mao sarakl engel bismisa. Ngub bismi o mondom obum khorob ora bisao sao oran mend ngo sao bisao ko mao bemberakl buwabur kismin, mbinim angal bombor ub taokl taokl eben nao ke armend sisao was ko wi wi bismisa. ");
INSERT INTO akh_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ngo tomb aol mendborom teka habur Njises bor kakla kao beyabur kakl, ");
INSERT INTO akh_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Naom aol ngo obum ngub kisaol pangismao ka. Nim Ngaor Hen Moroklme Anda aolon kim bi ngo kundi mbabur lowaon, nim bao hor teb oran bao burubur nim and ngo wakl wen pange mend buklwao o, tenaolom and bimi ub inj buklwao kisaol pangismao kismisa. ");
INSERT INTO akh_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ngub kismi o angal ngo di aol hambunom armend sisao ngo kismi nda ubi was sisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ngo tomb Nju semon baolum aol wesmbao aondao ndam tukunol teka habur Njises bor ne mubur kakl, Njem angal ngo haklon ukl mend ko san nao luklesi be? Mbinim nje bor ngo te mao sarareklem ub asub buklbur bim ko pangal? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ngub kisao o Njisesom obun angal ngo kisao on di ukl mend ko san di nao libur e beb nao kisesa. Ngub e beb nao kisaol baolum aol wesmbao aondao ndam Njises bor wakl kakl, Nje Ngaor aondao yubu ora hayao ko kaoya lome ndan Isi obum Eben Ke Aol ora hael be? inj kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ngub kisaol Njisesom kakl, Ngo ni ora hae. Pangal. Ngubi tomb non Aolon Isi Ora obu hambun sao buri palo bu haraoklao Ngaor aondao oran ki tao nan buruklaol hondoklemi ora. Mabor di obum yu heben mulaol daruklol oboklaol hondoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ngo tomb Njisesom ngub kisaol, baolum aol wesmbao aondao ndam ko aondao ora homobur obun lab lab samisao on kang mend munu kaoll kobabur kakl, Naom di obum khorob was ko haraoklao ub ngo le ol ora haondaoklaom ngao, naom aol tangar mend aol ngo obum khorob bu haraoklao ub njem hendeleb ko, ko mend ne nao mem ora. ");
INSERT INTO akh_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ngub inj, obum Ngaor bor maobowa angal banda ub inim ngubi tomb ngo pangeklem ong, inim asub ora nen sabeyem? kisesa. Ngub kisaol mbini hambunom Njises bor ngub bemin ko kao pabur, baolum aol wesmbao aondao ngo obun angal ngon ko san lubur kakl, Obum angal khorob aondao bu ora ngo le ol pangaoklaom tomb obum homokl san ora ngo be o kismisa. ");
INSERT INTO akh_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ngo tomb mendborom Njises ne maeke tokl beyabur kismin, mbinim obun el bor lab labom tanga tingi mbabur lu bowes bu, obu bor maobowa angal bubur kakl, Nje aebom was leyem? Njem mao bembera handale nda ub hend kobur, khorob ora lu bowes bismisa. Ngo tomb polisman baebenom di Njises men mubur obun el wil bor ki hobaom khorob ora lu bowes bismisa. ");
INSERT INTO akh_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ngo tomb Pita obu Nju semon baolum aol wesmbao aondao ngon anda saond paeb mbuklu tundae ngon unu ibilao bor birisaol, baolum aol wesmbao aondao ngon kongon biyao nong is mend obobur kisaon, ");
INSERT INTO akh_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pita obu is de teb sol hub sabo birisaol hindisesa. Kongon biyao nong ndam ngub oborob ora hend heneng bubur Pita bor kakl, Nje di Nasarer Njises kab haru haroklbe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ngub kisao o Pitam inj ora kobur obum kakl, Ni nao hende ora. Njem ni bor ngo kal on te di asub ko ora kal ko nim nen sabokl buwarukl kaoklbir kisaon, obum penar bu bombor ngo ora tomb saond paeb mbuklu tundae ngon tiriyao kombae nan bonge derarukl haenbur sao kulao angal mend bao bisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ngo tomb kongon biyao nong ndam Pita hondobur obum ko mende tenaol ngo Pita obu hasaol teb so hasmi nda baeben bor kakl, Aol ngo hae o obu di mbini sem bombor on ora hae kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ngub kisao o Pitam wakl ko mende kakl, Inj ora kisesa. Ngo tomb bombor ngo tomb was o kang mend mabor sao tenaol mendbor ngo Pita obu hasaol teb so hasmi nda baebenom wakl Pita bor kakl, Heneng ora nje di mbinin sem nje Kalili aol ora hael kismisa. ");
INSERT INTO akh_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ngub kismil Pitam mao ko angal buriyab ora kobur kakl, Inim ni bor aol ngo lem o nao hendeyo ora. Nim kakla ka sin Ngaorom ni ke mao handaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ngo tomb Pitam ngub kao peyakl birinbur oran sao kulao angal ko mende bao bisaol, Njisesom Pita obu bor njem sao kulao angal ko kab nao bi haenbur ko teb oran njem ni nao hendeyo lesi kisao nda mao takl bisaol, Pita obun kone bor kho sisaol hem ko de aondao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ngo tomb bao bisaol hokloben Nju semon baolum aol aondao baeben di, mbinin maomb bo haroklme aol, aol kon wi baeben di, mbinin man buwaloklme aol baeben di, mbini Nju sem ngo baebenon kansol baeben di hambun ora mbinim Njises obu bor buklemi saon ngub bemin ko kar paesmisa. Ngub kar pabur kismin mbinim Njiseson ki kab yam tanga pa men pae pobur, mbinin kabman maomb bo haraoklao aol aondao Paler kalismisa. ");
INSERT INTO akh_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ngo tomb Palerom Njises bor ne mubur kakl, Nje Nju semon aol wesmbao aondao ora harili be? kisesa. Ngub kisaol Njisesom obun angal ngon ko san lubur kakl, Njem ngo kal o kisesa. ");
INSERT INTO akh_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ngo tomb Nju semon baolum aol aondao nda baebenom Njises obu bor kakla kao beya te mao sarabur, obum ngo sao ngo sao bisaol hindismao ora ko howes andub ora kismisa. ");
INSERT INTO akh_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ngub kismil kabman maomb bo haraoklao aol Palerom Njises bor ko mende ne mubur kakl, Pangal. Mbinim nje bor te mao sara howes andub ora ngo keyem ong, njem angal ngo haklon ukl mend ko san nao luklesi be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ngub kisao tomb di Njisesom obun angal ngo kisao haklon ukl mend ko san nao lisaol, maomb bo haraoklao aol Palerom baehaemen oran inj e kobur burir biyu nimil nimil tu wisesa. ");
INSERT INTO akh_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ngo tomb karasmas hambunon Nju semon Waran Aeben Bisao bao o pindib pa was beyao tomb, Nju sem ngo baebenom mbinin kabman maomb bo haraoklao aol Paler bor njem naon sem kalabus bisi on is mend ngo ora eben kaebe ko, mbinin mbib bember peyo imbi kao hasmi o mbinim ngo kismi ub Palerom is mend anda pen kao was bisao bao on sisesa. ");
INSERT INTO akh_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ngo tomb aol is mend obun imbi Barabas di obu daol haru mbinim kabman kab kab saond mao babur aol mend pe paen lismil, Palerom mbini kalabus mao palaesaol kalabus paolismi tomb sisesa. ");
INSERT INTO akh_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ngo tomb tenaol aondao ngo hasmi nda baebenom maomb bo haraoklao aol Paler hasaol obobur kakl, Embi Waran Aeben Bisao hor so eng, njem embi di nao bor mbes bili nda ub bi kismisa. ");
INSERT INTO akh_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Ngub kismi o tenaol hambunom Njises was turi homo taol mi pismil, Nju semon baolum aol aondao baebenom Njises hendaebe makl aondao ora homobur mbinim obu bor howes kokl ibismi nda ub Paler obum ora hondobur o, obum mbinin kone hondoklbur mbini bor kakl, Nim ini Nju semon aol wesmbao aondao ngo wakl eben kon ko pangeyem be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ngub kisao o Nju semon baolum aol aondao nda baebenom tenaol hambun bor, inim Paler bor njem naon Barabas ora eben kaebe lowaebe ko karu mao kikil baesmi ub, tenaol hambunom Barabas ora eben kaebe kismisa. ");
INSERT INTO akh_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ngub kismil Palerom tenaol hambun bor wakl kakl, Nim Barabas obu inin ngub wakl eben kobur, inim aol ngo obu ini Nju semon aol wesmbao lome ngo obu bor asub buklwaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ngub kisaol tenaol hambunom obu bor angal buriyab ora kobur kakl, Obu is pe kowal bi bor pe paen nil libi ora kismisa. ");
INSERT INTO akh_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ngub kismil kabman maomb bo haraoklao aol aondao Palerom mbini bor kakl, Asub ko ora lem? Obu pe paen lib se obum khorob oran asao ora bisaol lem? kisesa. Ngub kisao o mbinim ne bombor ub kombo angal aondao bu ora kobur kakl, Obu is pe kowal bil pe paen nil libi ora kismisa. ");
INSERT INTO akh_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ngub kismil Palerom obun kone bor tenaol aondao ngo hasmi baebenom mbinin kone bor turi hemen ko nen sabobur kisaon, mbinim kismi nda ub obum Barabas kalabus hesbeyo mbinin wakl anda pen kabur, obum obun ami baeben bor inim Njises doroklom mbes lu mao homabur is pe kowal bil nil li mbakl puklub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ngo tomb Palerom ngub kisaol, ami nda baebenom Njises kabman maomb bo haraoklao aol aondao o baoraoklao anda on paeb mbuklu tundae o bor men pae hondabur kismin, ami baeben hambun ora obo kiril mbaklaob kismisa. ");
INSERT INTO akh_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ami baeben hambun ora obo kiril mbaesmi tomb mbinim Njises obu maobowa yaor mao babur, lab lab ingi bi ebe ora mend mao somaesmisa. Ngub bubur kismin aol wesmbao baebenom teng ebe ora ndibiklme ub menger, mbinim obu maobowa tanda mao na, ya nene hae mend di pab bu pabur Njiseson wesmbaol teng sao ndibiyakaesmisa. ");
INSERT INTO akh_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ngub bubur kismin mbinim obu bor kaoya ke non bu maobowabur kakl, Nju semon aol wesmbao aondao o, nje ebe soklaong as ko haebe kismisa. ");
INSERT INTO akh_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ngub kobur kismin mbinim obun wesmbaol kuwinj saoll mondom lu, mbinim obu bor ne maeke tokl beya peb bubur, kakla obu bor kaoya ke non bu, mbinim tumu kar munu obun aongao ma bor dombes ubur turi homo kaoya lao non bu kaoya kismisa. ");
INSERT INTO akh_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ngo tomb mbinim obu bor maobowa angal bu ngub bu paesmi tomb lab lab ingi bi mend Njises mao somaesmi nda kol mubur kismin, obun lab lab pibnao samisao nda wakl mao somaesmisa. Ngub bubur kismin mbinim obu is pe kowal bil nil li mbaklbur mini pismisa. ");
INSERT INTO akh_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ngub mini pismil aol is mend obun imbi Simon obu Aleksanda hesa Urupus kabon aorao sisaol, obu su irini aol sisao o obu su and lobokl lobokl aondao ngo bor poklbur ubukl hasao o, obu harerol hen mismisa. Ngub hen mubur kismin mbinim aol ngo bor buri palobur njem Njises nil lukl bi is pe kowal bi ngo ti ora ko mao taesmisa. ");
INSERT INTO akh_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ngo tomb su menden imbi Kolkota kismil, su ngon imbi ngo karu wismi on te wesmbao hul kismil, mbinim Njises su ngo bor men pae pismisa. ");
INSERT INTO akh_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ngo tomb mbinim ib waen hesa marsin mend kab maomunu singbi bombobur, Njisesom nen ko nen sabobur kal hindismi o Njises obum nao nisesa. ");
INSERT INTO akh_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Ngo tomb hokloben nar do tanda biyao ndabi tomb mbinim Njises is pe kowal bil nil li mbabur kismin, mbinim Njiseson lab lab kol barae wisao hakl taol bu kaob kaob bu mubur, bombor mend pon pae bao wisao o pone uklao om min ko, mbinim han ngoll pile bimi nda ub menger pile kang mend bismisa. ");
INSERT INTO akh_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ngo tomb is ngo Njises obu nil li mbaesmi ndan yu kungni oral, mbinim obu bor ngub te mao sara howes kismi ko bobae waeb ngub bu wismisa. A OL NGO OBU NJU SEMON AOL WESMBAO AONDAO ORA YAO ko waeb bu wismisa. ");
INSERT INTO akh_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ngo tomb aol is kab mend mbibim tenaol menden osisao taol pe mu hasbil, mbinim is mende aol Njiseson ki tao nan, is mende aol ki kowes nan bu nil li mbaesmisa. ");
INSERT INTO akh_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ngo tomb ngo bisao sao Ngaoron mbuk waeb bor buklao ke wisao ub ora bisaol, ngub ke wisesa. Mbinim khorob bimi aol bor buklemi ub Obu bor di buklemi ke wisao ub ngo ora tomb heneng ora il so pind bisesa. ");
INSERT INTO akh_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ngo tomb tenaol harer ngon en aeben bismi baebenom Njises is pe kowal bil ngub nil li mba hasaol hondobur, mbinim obu maobowa peb bu wil sara sara bubur kakl, Ye e, nje Ngaor Hen Moroklme Anda kundi mbabur bao hor tebon wakl wen pange bukl bi aol ngo ka. ");
INSERT INTO akh_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Njem njen mbib buri palo bongeyaokl po, njem is pe kowal bi ngo tuwaklbir sul hond ha kismisa. ");
INSERT INTO akh_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ngo tomb Nju semon baolum aol aondao baeben hesa mbinin man buwaloklme aol baeben kabom di Njises maobowabur mbini hakl hakl kakl, Obum tenaol mende bor non ebe bisur bu, bu muklao o obum obun mbib non bongeyaokl pokl buwaklao kismisa. ");
INSERT INTO akh_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ngo tomb mbinim obu bor maobowa angal was bubur kakl, Obu Ngaorom Eben Ke Aol su Isreyel tenaolon aol wesmbao aondao ora yao be? Ngon ebe ka. Njem is pe kowal bi ngo tuwaklbir sul hond haklesil handam sin, naom di nje heneng Eben Ke Aol ora sene ko hondoklmao kismisa. Ngo tomb khorob bisbi aol is kab mend is pe kowal bil Njises obu daol haru nil li mbaesmi nda kabom di, bombor ngub maobowa angal was bisbisa. ");
INSERT INTO akh_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ngo tomb aond hora haklu nar wesmbao tukun oral hasao tomb nar el nda tokl mubur kisaon, su hambun bor em hundur aondao ora u mbabur nend kisaol, ngub bao nend kao mba haen was 3 kolok ora pangobur nar nubu ngo ora bor as deyaesao tomb oran wakl bao bisesa. ");
INSERT INTO akh_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ngo ora tomb 3 kolok ngub pangisao tomb Njisesom angal aondao bu ora kobur kakl, Ila Ila lema sabaktani kisesa. Ngub kisao o Njisesom ngo kisao on te angal heneng kobur ngub wiyao. Ab Ngaor o nao Ab Ngaor ka, njem ni asub ko maru tuwaril? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ngo tomb tenaol mendbor Njises nil li mba hasaol teb so hasmi baebenom ngo kisao nda oborob pang heneng nao bibur kakl, Pangeklem. Obum Ilanja kor be kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ngo tomb ngub kismil aol is mondom akl was pobur kisaon, obum is kuwimb menger mendel ib waen karae bi mend dand bu pabur, is hul saoll mendel dukl bu pa mini obo Njises nen ko menyabur mao na hindisesa. Ngub bubur kisaon obum Njises maobowabur kakl, Ilanjam obu bisur bu wakl bu mubur sul hond haen kokl obaokl be? asub bib ko hendemin ub kang mend bao hondo haem dao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ngo tomb Njises obum wakl angal aondao ora ko, e kobur kisaon obu ora pe paesesa. ");
INSERT INTO akh_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ngub pe paesaol bombor ngo ora tomb Ngaor Hen Moroklme Anda bor and tubal komb bi ora ndan lab lab aondao saoll ora mend manga tundaesmi o, tukun ora tomb kab bu kaollu taokl yu nu bu pesesa. ");
INSERT INTO akh_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ngo tomb ami sem maomb bo haraoklao aol aondao mend obum Njises nil li mba hasaol teb so hondo haenbur, Njises obu pe paesao tomb ngo bisao sao hondobur kakl, Heneng ora aol ngo obu Ngaoron Isi ora sene kisesa. ");
INSERT INTO akh_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ngo tomb ten mendbor di mbinim Njises nil li mba hasao oral teb so nao hae kang mend enderael sao habur bao hondo hasmi o, ten ngo hasmi baebenon is mend obun imbi Maktala Mariya kismil obu di, nas Njemus ke mend hesa Njoses kabon ingi Mariya mende di, ten is mend obun imbi Salomi di ngo baeben sisesa. ");
INSERT INTO akh_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ngo baeben sisao o mbes Njises obu su Kalili bor hasao tomb ten is teb ngo di ten andub mendbor mbinim Njises bisur was bubur obu haru akol bu hasmi baeben di mbini ngo baeben hambun Njises obu Njurusalem yin ibisao bor taol bi ibismi o, Njises nil li mba hasaol hem ko ngub bao hondo hasmisa. ");
INSERT INTO akh_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ngo tomb aol mend obun imbi Njoseb kismil, obun su di Nju semon su bor was su Arimatiya sisaol, obu Nju semon kansol hasao o tenaol hambunom obu aol ebe ora hae ko hindismisa. Aol ngo obum Ngaorom maeb ha maomb bo hakl oboklao ub di bao hondo hasao o sisesa. Ngub hasao o bao ngon ekera nan Nju semon hor so boroklme bao* o pindib paklao kobur osisao man man bimi bao on sisaol, mbon sisao tomb aol Njoseb ngom obobur obum pakl nao heme, maomb bo haraoklao aol Paler birisao bor hondabur obun elol teka habur kakl, Nim Njiseson toklo tangakl pukl kisesa. ");
INSERT INTO akh_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ngub kisaol Palerom obu heneng ora bao pe pane ye ko nen sabo burir biyubur kisaon, obum ami semon maomb bo haraoklao aol bor ib ko ne mubur kakl, Njises obu heneng ora penar bu bao pe pane be? kisesa. ");
INSERT INTO akh_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ngo tomb Palerom ami semon maomb bo haraoklao aol ndam heneng ora Njises obu pe parob kisao ub pangobur kisaon, Njoseb bor Njiseson toklo ebe taokl pebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ngo tomb aol Njoseb ngom lab lab haek bi ebe ora mend dob bubur kisaon, Njiseson toklo sul mu pabur lab lab haek bi ndam Njiseson toklo tanga pa taokl pobur, mbes obum han te mend waru u mbaesao o bor maol bisesa. Aol Njoseb ndam ngub bubur kisaon han te aondao ngon dir komb pae o bor han aondao ora mend pere taokl obobur tu manga mbaesesa. ");
INSERT INTO akh_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ngub maol bisao tomb ten Maktala Mariya hesa Njoseson ingi Mariya mende kab, mbibi kab di Njosebom Njises ngo maol bisao hakl oborob ora hondo hasbisa. ");
INSERT INTO akh_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ngo tomb Nju semon hor boroklme bao* on hor ber paesmi tomb Maktala Mariya di, Salomi di, Njemuson ingi Mariya mende di mbinim wel kao ebe ora pebe hakl Njiseson toklol sulakl poklbur man man bu dob bu wismisa. ");
INSERT INTO akh_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ngo tomb Nju semon kongon mubaon hokloben wen nar pol bam ibisao tomb Njiseson maol bor pismisa. ");
INSERT INTO akh_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ngub pobur kismin ten nda baebenom mbini hakl hakl kakl, Naom Njiseson toklol wel ngo sulaomun ko, han aondao ngo Njiseson maol bor tu manga mba harob nda han ngo kang inj aondao ora, mondom pereyaeb nao se ora sandang, aebom ora nao bisur bu pere aeben saklao yeb? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ngub kao peyaoklbir kang mend aeben sao pobur hindismil, Njiseson maol han te ngon dir o bor han aondao ngo tu manga mbaesmi nda, ngub bao nao manga mba hae armend pere hakl po wisaol hindismisa. ");
INSERT INTO akh_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ngo tomb mbinim Njiseson maol han te ngo bor hondabur hindismil, mbinin ki tao nan o bor aol nas lab lab haek bi saoll ora same mend birisaol hondobur mbinim pakl homo burir aondao ora bismisa. ");
INSERT INTO akh_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ngo tomb nas ngo birisao ndam mbini bor kakl, Inim pakl homo burir nao biklaob ka. Inim Nasarer Njises obu is pe kowal bi bor pe paen nil lismi aol nda es bukl ubuklim o, aol ngo obun maol bor bao nao wi obu enjaokl paonaol, mbinim obun toklo waemi bor nao wi ngong haondaoklaob kisesa. ");
INSERT INTO akh_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ngub kobur kakl, Inim penar bu ora wakl bokeyobur Pita di Njiseson man pange baeben hambun di mbini ngo baeben bor ngub lowaebe. Njisesom ini bor obum mbes ngub buklwao ko kao njisao ub Njises obu enjaoklbir obu mbes su Kalili bor po hayaol, inim su Kalili ngo bor obu haklaol hondoklemi ko kao kalokl puklub kisesa. ");
INSERT INTO akh_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ngo tomb ten is teb nda han te ngon andaon haklbir deran pobur kismin, mbinin kone bor burisao po dur kobur pakl aondao ora homaoklbir pakl akl was pismisa. Mbinim pakl homobur kismin mbinim Njiseson maol bor ngo hindismi sao tenaol mondom pangen nao kao kalismisa. ");
INSERT INTO akh_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ngo tomb Njises obu ngo wakl enjaokl pisao o Nju semon kongon mubaon wen bao buklbur hoklob ora kebeyam ibisao tomb enjaokl pobur kisaon, Njisesom pibnao oran ten Maktala Mariya hasaol obo pindib pabur ni wakl ngo enjaokl powe o ko muwalisaol, ten ngo obu mbes obun tombao bor sam is haoklao birisaol Njisesom taol deraesao ten nda sisesa. ");
INSERT INTO akh_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ngo tomb ten Maktala Mariya ngom ngub haondaoklbir kisaon, obum tenaol mendbor Njises obu daol haru akol bu hasmi nda baebenom hem aondao ora kobur hibi kho so de kao mba hasmil, mbinim pangen kao kalokl pisesa. ");
INSERT INTO akh_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ngo tomb Maktala Mariyam ngub pobur mbini bor kakl, Njises obu wakl enjaokl po hanaol nim hondowao ora ko kao kalisao o, tenaol nda baebenom ten ndam ngo kisao ub heneng ora le ko nen nao sabismisa. ");
INSERT INTO akh_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ngo tomb kang mend mabor sao Njiseson man pange aol is kab mend su mendel poklbur harerol pukl hasbil, Njises obu aol tangar mend ebe non bubur, obum ni wakl ngo enjaokl po hae o ko mbibi pukl hasbi ndal po pindib paesesa. ");
INSERT INTO akh_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ngub bisaol mbibim Njiseson man pange nda baeben birismil wakl bokeyaokl obobur, mbibim ngo hindisbi ub mbini hambunom pangen kao kalisbi o, mbibim Njises enjo hanaol nao hendebur baehaemen leb ko nen sabismisa. ");
INSERT INTO akh_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ngo tomb mabor Njiseson man pange aol tobon teb nda baeben mbini ne noklbur ber mba hasmil Njises obu obo pindib paesesa. Ngub obo pindib pabur kisaon, tenaol mendbor Njises obu enjaokl po hasao ub pibnao hondobur naom Njises obu wakl enjaokl po hanaol hondomao ko kao kalismi o, mbinin kone bor buri han hul non bi sisaol mbinim heneng lem ko nen nao sabismi nda ub nen sabobur, obum mbini ngo baeben taolu lisesa. ");
INSERT INTO akh_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ngo tomb Njisesom mbini bor kakl, Inim su hambun bor buri kobur lemin, nao Angal Bib Hobao Sao ngo tenaol hambunom pangaen kao kaloklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ngub kobur kakl, Tenaol mendbor nao Angal Bib Hobao Sao ngol hul ha habur mbabtas buklemi baeben, Ngaorom mbinin kone kho kunabur mbini bu muklaol haeben ora saklemi. Ngub inj, tenaol mendbor nao Angal Bib Hobao Sao ngol hul nao hae haklemi baeben, Ngaorom mbinin kone bor kho uklao o nao kunaklaol mbini ke hondo haeben ora saklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ngub kobur kakl, Ngaorom tenaol mendbor Angal Bib Hobao Sao ngol hul ha haklemi baebenom tenaolom ko mend nao hindismi sao mendbor, tenaolon tombao bor sam buruklao o taol dera peb bin lao ora. Ngub bubur laon obum tenaol ngo nil hul ha haklemi baebenom angal heneng tangar wen pange tenaol mendem pang pang nao bib se di mend ken lao kisesa. ");
INSERT INTO akh_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ngub kobur kakl, Mbinim ngub nil hul ha haklemi tomb non, mbinin kim suklumb men haklemi tomb di mbini nao noklao ora. Mbinim maokl tom menger tenaol pe paroklme ib tangar mendbor naem sin di mbini nao pe paklemi ora. Aoh, mbini ngo baebenom tenaol mendbor sen ha uklemi baeben kim men mbaklemi tomb di, mbinin sen ngo ebe bao soklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Naon Aorao Aondao Njisesom mbini bor angal ngo baeben kao kal paesao tomb Ngaorom obu yu heben bor men misaol, obum Ngaoron ki tao nan po ber paesesa. ");
INSERT INTO akh_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ngo tomb Njiseson man pange nda baeben su ngol haklbir kismin, mbini su hambun bor buri kobur Angal Bib Hobao Sao ngo tenaol hambunom pangen kao kalam pismisa. Ngub kao kalam akol bismi tomb Aorao Aondao obum di mbini haru habur mbini buri mao palabur kisaon, mbinim angal bib ebe ngo kao kalam akol bu hasmi baeben tenaol hambunom heneng ora lem ko nen saben ko, tenaolom ko mend nao hindismi sao andub ora bam akol bu haen kisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Aol aondao Tiyopilas o, su ngo nao hayom o bor hobao sao mend bisaol tenaol mendborom ngo bisao sao mbinin elom hondobur, mbes di ngubi tomb di mbinim hindismi ub angal bib ngo tenaol hambunom pangen kao kalam aeben aeben bubur, naom di pangaomun kao njismi ka. Ngub bismil tenaol mendbor andubom ngo bisao sao arman mbuk waeb buklwao ko nen sabismi ub ");
INSERT INTO akh_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","nim di ngo bisao sao mbes ora te dubi mao bemberawaol, arman ngo bisao sao hambun sao mbuk waeb bor oborob ora uklwao ko nen sabowao ora. ");
INSERT INTO akh_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ngubi tomb ngo bisao sao kang mend pangisi o, njem hambun sao bisao sao te oborob ora pangenin ko nim mbuk ngo waeb bi ka. ");
INSERT INTO akh_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mbes ora kabmanon aol wesmbao Heror ke ndisom su Njuriya maomb bo hasndis tomb Nju semon baolum aol mend obun imbi Sekaraya kismil, aol Abasan sem maomunu baolum aol kongon bimi baebenon is mend obu sisesa. Ngo tomb obun weren imbi Ilisaber kismil, aol Eron obu ten ngo obun ab sumb sisaol, obu di baolum aol semon wane sisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ngub burubur kisbin mbibi tobaklom kone ebe u oborob was bu hasbil, Ngaorom hindisao tomb di Aorao Aondaom bibaebe keyao sao di obun man hambun sao di hul nao haebur khorob sao kang mend nao bisbisa. ");
INSERT INTO akh_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ngub bisbi o ten ngom nongnas nao mari hapele was bao habur, mbibi tobakl hungi sam sam bisbil mbibin nongnas is mend and nao sisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ngo tomb baolum aol baebenom akl akl bismi nda ub aol ngon semom Ngaoron kongon akl akl bu, bu hasmi tomb ");
INSERT INTO akh_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nju semom bismi ub embi kongon aebom was buklaob ko ne mi mi bubur hondo mao bemberaesmil, kao ebe ora peben haoroklme sao embi aol Sekarayam haoruklao ko mao bembera hindismisa. Ngub bismil aol ngom kao pebe sao mend Ngaor bor kalo haoruklbur, Aorao Aondao Hen Moroklme Anda andaon hondaesesa. ");
INSERT INTO akh_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ngub hondaesaol Nju semom kao pebe sao ngub haorismi tomb, mbinim bismi ub tenaol hambunom Ngaor bor kao kaloklbur and ngon dera nan kiril mba ber mba hasmisa. ");
INSERT INTO akh_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ngo tomb and ngon andaon Aorao Aondaon angal mini wesao mend obo pindib pabur, kao pebe sao haoroklme to ndan ki tao nan hasaol aol Sekaraya ngom hindisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ngub hondobur kisaon aol ngom pakl aondao ora homo burisao po wisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ngo tomb angal mini wesao ndam obu bor kakl, Sekaraya o, njem Ngaor bor kao kalale ub obum pango hayao ko kao njukl ubukl ngao, pakl nao hom ka. Njen were Ilisaber ke ndam njen isi mend maru waklaong, obun imbi Njon ko karu wibi. ");
INSERT INTO akh_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nas ngo obu obun amom maruklao tomb njem di werek bubur turi homoklesil, tenaol mendbor hambunom di turi aondao bu ora homoklemi. ");
INSERT INTO akh_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Aorao Aondao obum nen sabeyao ub obu aondao imbi wi ora soklao. Nas ngo obum ib waen di he soklme ib buri ngubi hakl di nao noklao ora. Obu wen mar paklao ora tomb di obun kone bor Wesao Ebe Tangar nda hae ora maru uklao. ");
INSERT INTO akh_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nas ngom su Isreyel tenaol mendbor andub ora mbinin Aorao Aondao Ngaor hayaol wakl kone baol maonaoklbir pen lao. ");
INSERT INTO akh_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Obu Ngaoron man mini aol ora soklaol, Wesao Ebe Tangarom man mini aol Ilanjan kone bor hondabur buri mao palaesao ub buklaol, obu di Ilanjam kone u hasao ubi u haklao. Nas ngom mbini aol baebenom di wakl kone u bokeyobur mbinin nongnasol kone win lao. Obum mbini hul ha kone awis haroklme baeben di wakl kone u bokelen ko, kone dund se wi oborob bimi baebenom kone woroklme ub win lao. Nas ngo obum Aorao Aondao eben ko obun sem hambun man man bu mao baraklao ko angal mini wesaom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ngub kisaol Sekarayam angal mini wesao nda bor kakl, Wao. Yao tobakl hungi ora inj e bo? Nim asub buklaol hondobur njem heneng kal ko ne saboklwaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ngub kisaol angal mini wesao ndam obu bor ko san lubur kakl, Pangal. Ninao imbi Ngeberiyel ora ubukl ol, ni Ngaor hayaol bao haruklu ka. Obum ora angal bib ebe ngo njem pangenin ko kao kalokl pu kaonaol ubukl ol, ");
INSERT INTO akh_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","nim kao njanda ub heneng ora buklao o, njen kone taol taol bu heneng ora buklao ko nen nao sobal ol nje e beb nao ke was haklesi. Ngub was habur mabor nim ngo kao njanda ub buklao tomb oran, njem wakl angal lesi ora ko angal mini wesaom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ngo tomb tenaol dera hasmi nda baebenom Sekaraya ngubi tomb pen dera oboklao ko nen sabismi o, obu Ngaor Hen Moroklme Anda ngon andaon bor bao habur pen dera nao ibisao tomb mbinim burir bismisa. ");
INSERT INTO akh_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ngub bismil mabor obu dera ibisao tomb obun pondo pe minisaol, obum angal kokl buwaesaol hondobur, obum andaon bor obam sao menjao haondaonaol bene ko nen sabismisa. Ngub nen sabismil obun kim was menger mu habur, e beb nao ke was bao hasesa. ");
INSERT INTO akh_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Obum bao hor kab teb ngub was bao bu haklbir kisaon, mabor aol Sekaraya ngom Ngaoron kongon ngo bu paesao tomb obun anda pisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ngo tomb mabor obun were Ilisaberom nongnas sen homobur, obu hungum ek ukl su oran mupango sub was burubur kakl, ");
INSERT INTO akh_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Aorao Aondaom ngubi tomb ni hond aondao ora homobur oborob ora bi ol, nao tenaol bor ni ko mende sakl nao poloklwao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ngo tomb mabor ten Ilisaber nda nongnas sen homo win ek ukl dowa oran pibi hasao tomb, Ngaorom obun angal mini wesao Ngeberiyel ke mend nje and lobokl lobokl Nasarer su Kalili bor pu kisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ngub kisaol nong is mend obun imbi Mariya kismil, su ngo bor birisao o obu nas Njoseb ke mend hasao on sokl kal hae burubur obun anda biri non bi sisaol, nas Njoseb ngo obu di Debir semon isi hasesa. ");
INSERT INTO akh_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ngo tomb angal mini wesao ndam nong Mariya ngo birisaol obobur kakl, Aorao Aondaom nje haru habur bisur aondao ora baonaong, njen kone bor sub tibaen as ko ora biribi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ngub kisaol pangobur nong Mariya ndam burisao po burir aondao ora biyubur, obum angal ngon te asub ko leb ko obun kone taol taol bu nen aondao ora sabisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ngub bisaol angal mini wesao ndam nong nda bor wakl kakl, Mariya o, Ngaorom njel kone u turi aondao ora homeyaong, nje pakl nao homaebe ora. ");
INSERT INTO akh_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Pangal. Nje nongnas sen homobur isi maruklesing, obun imbi Njises ko karu wibi. ");
INSERT INTO akh_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nas ngo obu aol aondao imbi wi ora haklaol, mbinim obu Ngaor Aondao yubu oran isi hae lemi. Obun ab sumb Debirom aol wesmbao aondao ora habur buri palo maeb ha maomb bo hasao ub, naon Aorao Aondao Ngaorom aol ngo obum di ngub buri palo maeb ha maomb bo haen lao. ");
INSERT INTO akh_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ngub buklaol obun ab sumb Njekob sem hambun maeb ha maomb bo habur laon, obum ngub maomb bo ha kimb ora buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ngub kisaol nong Mariyam angal mini wesao nda bor kakl, Wao. Nao aoli nao hae ni nong ora bereng, nim asub bubur maruklwao? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ngub kisaol angal mini wesao ndam obu bor ko san lubur kakl, Ngaoron Wesao Ebe Tangarom njen hibi umu bor hondabur, Ngaor Aondao yubu ora ndan burim nje men mbaklao tomb njem nas ngo maruklesi. Ngub maruklesil Ngaorom nas ngo obu komb bi ora haen kisao o ora yaol, obu Ngaoron Isi ora hae lemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ngub kobur wakl kakl, Pangal. Njen bab hungi Ilisaber ke nda mbinim obu ten habele nongnas nao marib se ora bere lome o, obu nongnas pango win ngubi tomb ek ukl dowa oran pibi harnaol, ten heyao ngo obum di isi maruklao ora. ");
INSERT INTO akh_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ngub buklaol Ngaor obum menjao bukl buwa nao bib se ora hayao ko angal mini wesao ndam ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ngub kisaol nong Mariya ngom obu bor kakl, Pangal. Ni Aorao Aondaon kongon biyu nong ora bereng, njem ngo kao njiril ub ba sin di ebe was kisesa. Ngub kisaol angal mini wesao ndam paokl pisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ngo tomb nong Mariya obun su ngol baoraoklbir Njuriyan su and te mend yu manda bor wisaol, ngo bor penar bu ora pisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ngub pobur kisaon obu aol Sekarayan anda hondabur, aol ngon were obun bab Ilisaber nda bor, nao bab ko turi homo taeki kisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ngub kisaol ten ndam nong Mariyan angal ngo pangisao tomb nongnas ngo obun tombao ndaon bor birisao ndam el bu nuklu taokl en aeben bu pesesa. Ngo tomb Wesao Ebe Tangarom ten Ilisaber ndan kone bor aondao bu ora hondaesaol, ");
INSERT INTO akh_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ten ndam nong Mariya bor angal buriyab ora kobur kakl, Ngaorom nje turi homo njel aondao bu ora kone waoraoklao om mbini ten kone ebe wi aeben o bereyem baeben turi homaoklao ub di men mbayao ora. Njem nas ngo maruklesi o di Ngaorom obul aondao bu ora kone u turi hom ha was haklao. ");
INSERT INTO akh_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ngub buklaong nao Aorao Aondaon am ngom ni non bi ngo asub ko saor mu hondokl obaokl balem? ");
INSERT INTO akh_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Pangal. Njem ni taeki kaenda pangowao tomb nongnas ngo nao tombao ndaon bor beremon werek bu, el bu aondao bu ora nuklu taokl en aeben ba kisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ngub kobur kakl, Aorao Aondaom nje bor kao njaonao ub njem heneng ora buklao ko nen sabobur obul hul ha ora hael ngao, njem werek bu turi aondao bu ora homaebe ko ten Ilisaberom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","49","Ngo tomb nong Mariyam kakl, Ni Ngaoron kongon biyu nong Kang ndi nao mini ora bere o Obum ni non bi ngo turi homo kone wiyaol Nao konem Aorao Aondao bor Aondao bu kaoya kao was lao. Ngaor nao bu maoraoklao aol ndam Ni non bi ngo turi homo kone wiyaol Nim obu di turi homo Nao kone bor werek aondao ora bin beraklo. Ngaor obu buri pon pae aondao ora nda Obun imbi ebe komb bi ora yao. Obum ni bor hobao sao aondao ora ngo be o Tenaol sem hambunom maru wam aeben buklemim Nong ngo obul kone u turi mao homaesao lemi. ");
INSERT INTO akh_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mbes mari baeben di wen maruklemi baeben di Ngo hakl hambunon obu pakl homo haklemi baeben Obum hond homo bu mukalo. ");
INSERT INTO akh_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ebekone puklmi baebenom Naom ngo sao ngo sao buklmao ko nen saboklme o Obun burim ngo baeben Lu taol peyo buri ken kisao. ");
INSERT INTO akh_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Buri palobur maomb bo haroklme baebenom di Ngub nao maomb bo haen Obum men kang mao saesao. Imbi nao wi men kang so boroklme baeben Obum aondao ora mao hasao. ");
INSERT INTO akh_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Obum dem homo boroklme baeben bor Hobao sao ora ngaorukl pelen taol bu kalisao. Andub sao u haroklme baeben bor Obum menjao nao wi ki hobaol birin kobur Menjao nao mini ora pen kisao. ");
INSERT INTO akh_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Naon ab sumb wil baeben bor Buklwao ko kao kalisao ub kone nao tuwae Obun kongon biyao aol Isreyel di Ki taokl kalo bisur bisao. Naon sumb Eberehem di Obum maru wam aeben aeben bisao hakl di Ngo baeben bor nim buklwao ora kisao ub Aokl nao hemen beyabur Hond homo bisur bi aeben saraoklao ko nong Mariyam ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ngo tomb nong Mariya Ilisaber hesa ek ukl teb mend bao baoraoklbir wakl obun anda pisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ngo tomb ten Ilisaber nda nongnas marukl peb se tomb sisaol obum nas marisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ngub marisaol ten ngon sem baeben di obun tenaol sango baeben di, Aorao Aondaom ten Ilisaber nda hond homo bisur aondao ora bisaol hondobur, mbini hambunom turi homo werek bismil, ten ngo obum di turi aondao ora himisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mabor bao hor duklab oran pibi hasao tomb mbinim nas kang ngo soweb bi ha songol pe hakl obobur, obun abon imbi Sekaraya kismi ub nas ngon imbi di Sekaraya lomao ko nen sabismi o, ");
INSERT INTO akh_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","nas ndan amom inj ora kobur kakl, Obun imbi Njon ora lomao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ngub kisaol mbinim ten nda bor kakl, Nje semon aol is mend Njon ke mend nao hasaong, asub ko kal? kismisa. ");
INSERT INTO akh_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ngub kobur kismin mbinim nas kang ngon ab bor ne muklbur imbi aeb lomaob ko, kim was menger mubur kao kalo hasmi nda ub kao kalismisa. ");
INSERT INTO akh_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ngub bismil aol ndam kim menger mu mbini bor bobae mend njib kobur, bobae ngo bor obun imbi Njon ora ko waeb bisaol, mbini hambunom burir aondao ora bismisa. ");
INSERT INTO akh_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ngub bisaol bombor ngo ora tomb wakl obun heke baol baol kisaol, obum angal oborob kobur Ngaor bor kaoya kisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ngo tomb mbibin tenaol sango ngo hasmi nda baeben hambunom pakl homo burisao pobur kismin, ngo bisao saon arman hambun sao su Njuriya ngon yu manda hakl bor di kam aeben aeben bismisa. ");
INSERT INTO akh_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ngub bismil angal ngo pangismi baebenom Aorao Aondaom obun buri nas ngo obu bor taol bu kalenesal ko mao bemberabur kismin, mbinim ngo pangismi saon was nen sab hakol bu burir biyubur kakl, Nas ngo and so haklao tomb obu asub bi mend soklaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ngo tomb Ngaoron Wesao Ebe Tangarom nas kang ngon ab Sekarayan kone bor aondao bu ora hondaesaol, Ngaorom wen ngo sao buklao kobur kakl, ");
INSERT INTO akh_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Isreyel semon Aorao Aondao Ngaorom Obun tenaol bisur bu, bu muklbur ibisaong Naom obu bor kaoya kem ora. ");
INSERT INTO akh_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Obun kongon biyao aol Debirom Maru wam aeben aeben bisao on is mend ngo Naon bu maoraoklao aol buri ora eben karaokl. ");
INSERT INTO akh_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Mbes obun man mini aol komb bi hasmi haklon ne bor Obun angal ngub kao deraesao. ");
INSERT INTO akh_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Inin saond bi baebenom ini nao lin ko Bu muklwao ora kisao. Ini ko homoklme haklom ini nao men mbaen ko Bisur buklwao ora kisao. ");
INSERT INTO akh_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Naon sumb wil baeben bor Ini hond homo ki taokl njuklwao ora kisao. Nim hobao sao ora mend buklwao kisao ub Obum nen sab hakol ora beyao. ");
INSERT INTO akh_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Naon ab sumb Eberehem bor Nim buklwao ora ko mao kobur Njem maru wam aeben aeben buklesi baeben Mbinin saond bi baebenom nao lin Bu muklwao kisao ub nao bor ora kisaol Naom pakl nao heme Obun kongon bi hakol ora baomun ko kisao. ");
INSERT INTO akh_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nao obun sem komb bi hamun kisaol Nao nao heme sul bao haklmao tomb Obum naom oborob dund se ub was bu hamun ko Eberehem bor ngub kisao. ");
INSERT INTO akh_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nao isi o nje Ngaor aondao yubu oran Man mini aol hael lemi. Njem Aorao Aondao poklao hareron Bu ware haklesi tomb obu mama oboklao. ");
INSERT INTO akh_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","78","Njem mbini obun sem baeben bor Inim khorob bismi sao inin kone bor wiyao o Naon Aorao Ngaor obu naol kone u Hond hom ha hayao ndam wakl kunabur Ini bu muklao ora ko mbinim pango birin Kao kaloklesi ora. Obum nao hayom ol bao yu heben bor hakl Bu taokl eben kam kam bubur Nao bu muklao ora. ");
INSERT INTO akh_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nao hambun em hundur wi bor habur Pe paklbur haroklmao o Naom kone bor tibaen puklmi hareron Sub as ko paomun ko Bao ngub eben lao ora ko Sekarayam ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ngo tomb nas kang nda obun toklo ebe ora and sisao ub obun kone bor di oborob ora haru and sao sao bisao o, obum pibnao su Isreyel tenaol bor Ngaoron angal kao kalo hasao nda ub nao bi aeben anga tomb, obu hungum su tenaol nao biri bor bao hasesa. ");
INSERT INTO akh_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ngo tomb mabor Orom semon aol wesmbao aondao ora aol Okastasom tenaol hambun ndi munu bobae lun ko nen sabobur, su hambun bor bobae lukl puklub ko kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ngo tomb mbinim bobae ngub ko mend nao lismi o, aol Sariniyas su Siriyan maomb bo haenbur mbinim pibnao tibiyu bobae lukl pismisa. ");
INSERT INTO akh_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ngub bubur kismin tenaol hambun mbinin su and te sisao bobae lin ko pu pu bismisa. ");
INSERT INTO akh_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ngo tomb nas Njoseb obu aol wesmbao Debirom maru wam aeben aeben bisao on is mend sisaol, aol Debir ngo obun su and lobokl lobokl Berlehem sisesa. Ngub sisaol nas Njoseb obu paolisao su o di su Kalili bor and lobokl lobokl Nasarer bor paolisao o, su ngo bor haklbir su Njuriya and lobokl lobokl Berlehem bor pisesa. ");
INSERT INTO akh_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ngub pisao tomb obun sokl kal hae nong Mariya nda di mbibi haru mbibin ab sumb Debiron su Berlehem ngo bor bobae lukl pisbi o, nong ngo obu nongnas sen homo ubur nongnas marukl tir tomb pisbisa. ");
INSERT INTO akh_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ngub sisaol mbibi su ngo bor hasbi tomb nong Mariya nda nongnas maruklbur kilwakl bu misesa. ");
INSERT INTO akh_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ngo tomb and tenaol harer pebem dob bu paolaokl en aeben bismi anda on hakl nao hasaol, obum obun nas mubao ngo mar paesao tomb obum nas kang ngo lab lab kang mondom hoba pabur, some kawaon ne nen kaloklme panda bor mao waesesa. ");
INSERT INTO akh_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bao somna bombor ngon su ngon teb so bor some sib maeb haroklme aol mendborom somna dera bor mbinin some sib maomb bo hasmisa. ");
INSERT INTO akh_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ngo tomb mbini hasmil Aorao Aondaon angal mini wesao mend pindib paesao tomb Aorao Aondaon bao aondao ora ibisao ndam mbini mao tukun saesaol, burisao po pakl aondao ora himismisa. ");
INSERT INTO akh_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ngub bismil angal mini wesao ndam mbini bor kakl, Pangeklem. Ini bor angal bib hobao sao mend tenaol hambunom turi homo werek aondao ora bin ko kao njukl ubukl ngao, pakl nao homoklwaebe. ");
INSERT INTO akh_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Embi somna ngubi ora tomb aol wesmbao nda Debiron su and lobokl lobokl isu ngo bor, inin Bu Maoraoklao Aol Aorao Aondao Karas maraonao ora. ");
INSERT INTO akh_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nas kang ngo lab labom hoba pabur obu some kawaon ne kaloklme panda bor mao wayao o hondoklemi tomb, o kanda heneng ora ngo sene ko hondoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ngo tomb angal mini wesao ndam ngub kakl haen was penar bu ora, angal mini wesao andub ora ndi nao minib se yu heben haklbir angal mini wesao ngo obu hasao ndal was obo pindi pa hasmisa. Ngub habur mbinim Ngaor bor we aondao bu ora kaoya kobur kakl, ");
INSERT INTO akh_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Ngaor obu yu heben bor Bao bi pon pae aondao ora hayaong Obu imbi wi aondao ora hayao ko Kaoya kem ora. Tenaol obum turi homo Kone waoraoklao baebenon kone bor Su ngo bor di Sub tibaen as ko buruklemi ko angal mini wesao baebenom we ngub kismisa. ");
INSERT INTO akh_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ngo tomb mbini ngol bao haen angal mini wesao ngo baeben yu saohar bor wakl bokesmil, some sib maeb haroklme aol ngo baebenom mbini hakl hakl kakl, Menjao baonao ko Aorao Aondaom naom paongaomun ko kao njanda ub isu Berlehem bor hondokl mbi kismisa. ");
INSERT INTO akh_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ngo tomb mbini penar bu ora hondokl pobur kismin mbinim Mariya Njoseb kab hend wabur, nas kang ngo some kawaon ne nen kaloklme panda bor mao waesao nda hend waesmisa. ");
INSERT INTO akh_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ngub hondobur kismin some sib maeb haroklme aol nda baebenom nas kang ngon arman angal mini wesaom kisaol pangismi ub mbibim pangen kao kalismisa. ");
INSERT INTO akh_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ngo tomb angal ngo kam aeben aeben bismil pangobur, tenaol hambunom burir biyu nen aondao ora sabismisa. ");
INSERT INTO akh_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ngub bismi o nong Mariyam non ngo bisao sao hambun sao obun kone bor win was birisaol, menjao nen nao sabe birisesa. ");
INSERT INTO akh_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ngo tomb some sib maeb haroklme aol nda baebenom hambun sao angal mini wesaom kao kalisaol pangismi ub di, mbinim elom hindismi nda ub di, ngo sao baeben nen sabobur mbinin kone bor turi homo Ngaor bor aondao bu ora we ko kaoya kaoklbir mbinin anda wakl bokesmisa. ");
INSERT INTO akh_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ngo bomb mabor bao hor duklab pibi hasaol, mbini Nju semom bimi ub mbinim nas kang ngon songol pe ha soweb bi hasmisa. Ngo tomb nong Mariyam nas kang ngo sen nao hom hae tomb angal mini wesaom kao kalisao nda ub, mbibim obun imbi Njises ko karu wisbisa. ");
INSERT INTO akh_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Ngo tomb nongnas sobes haen ingi birisao ub ora sisaol, ngub ora sene ko henden ko, Moseson manom bibaebe ke wisao ub Njoseb Mariya kab Njurusalem yin pisbisa. Ngub pobur kisbin Aorao Aondaon manom ke wisao ub nas mubao maruklemi baeben di, kalo haroklme sao baebenon hondbao tu mubao maruklao baeben di, Aorao Aondaom komb bi haen lao ke wisao ub mbibim nas kang nda Ngaorom komb bi hae haen ken ko mari pisbisa. ");
INSERT INTO akh_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ngub pobur kisbin man ngom ke wisao ub sao huk is kab mend sa sin di, sao ebeyabukl hondbao is kab mend sa sin di, ngo sao kab ora kaloklwaebe ke wisaol, mbibim sao is kab lu haorubur Ngaor bor kaoya ko kaloklbur pisbisa. ");
INSERT INTO akh_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ngo tomb aol is mend obun imbi Simiyon kismil, aol ngo obu su Njurusalem ngol obo hasesa. Al ngo obun kone ebe dund se wi ora hasaol, obum Ngaoron man hem aondao ora ko Ngaor bor pakl hom mu sao habur kisaon, mabor Isreyel tenaol bu muklao ko hem ko bao hondo hasesa. Ngub bisaol Wesao Ebe Tangarom obun kone bor honda habur ");
INSERT INTO akh_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Wesao ngom obu bor kakl, Aorao Aondaom mbes ini bu muklbur aol mend eben lowao kisao ub, Eben Lao Aol ngo obu njem njen elom nao hende haninbur nje nao pe paklesi ora ko, obun kone bor ngub kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Aol ngo obu ngubi hasao o Wesao ndam obun kone bor pu kisao ub pobur, obu Ngaor Hen Moroklme Anda bor hondaesesa. Ngo tomb Njoseb tobaklom manom bibaebe ke wisao ub buklbur nas kang Njises mari and ngon hondaesbi o ");
INSERT INTO akh_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","aol Simiyon ndam nas kang ngo hondo kim hibi mu munu habur, Ngaor bor turi homo tengiyu ko kaoya kobur kakl, ");
INSERT INTO akh_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","32","Nao Aorao Aondao o Njem naon Bu Maoraoklao Aolom Tenaol hambun bu min ko man man bubur Tenaol hambunom henden ebe karil ka. Tenaol Sem Tangar baebenom di Njen harer henden ko obum bao eben lao. Obum bao ngub eben kobur Njen tenaol Isreyel sem di Imbi aondao ora win lao. Nao Aorao Aondao o Njem hondoklesi ko kao njisndis ub Ngubi tomb hondon kal ka. Ni njen kongon biyu aol ora hae ol Ngo sao elom hend parukl ngao Ni sisab bi pon waebe. Aol Simiyon ndam Ngaor bor ngub kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ngub kisaol nas ngon ingi aorao kabom mbibin isim ngub buklao kisaol pangobur, mbibim burir aondao ora bisbisa. ");
INSERT INTO akh_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Ngo tomb Ngaorom mbini teb ngon kone bor werek mao ba bisur bin ko aol Simiyon ngom Ngaor bor kao kalobur, nas kang ngon am Mariya bor kakl, Pangal. Ngaorom nas kang ngo Isreyel tenaol andub ora, mendbor ke hondoklemi hesa men muklao kab tuma kobaen ko eben kisao ora. Nas ngo obum hambun sao bu haklao tomb, obu hayao ub menger muwalaoklao saom mbini tenaol andub oran mbinin kone bor wiyao ub di panaem ora henden muwalobur, mbinim obu bor angal kho ko nar wen ebe hende non buklemi. Mbinim ngub buklemil njen kone bor di isaolaom sao dao ha uklao ora, aol Simiyon ndam ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ngo tomb ten hungi is mend obu Ngaoron man mini ten ora birisao o obun imbi Ana sisaol, obun abon imbi di Panuwel kismil obu Asa sem sisesa. Ten ngo obu pibnao aol pisao o, karasmas ukl haoklao ora obun aoli hesa birisbi tomb obun aoli ngo bao himisesa. ");
INSERT INTO akh_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ngo tomb obu ten weyae burubur hungi sam sam bisaol, obu marisao o karasmas supu hakl hakl hor makl hor su nanon ukl makl oran pibi hasesa. Ngo tomb hora di somna di ten ngo obum Ngaor Hen Moroklme Anda nao tuwae Ngaor bor nen sabo kao kal ha was buru ne tuwa paolubur, obum ngub kaoya kao kal ha was birisesa. ");
INSERT INTO akh_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Bombor ngo tomb ten hungi ngo mbini hasmil obobur, obum Ngaor bor tengiyu ko kaoya kobur, Ngaorom mbini Njurusalem tenaol wen bu muklao ub hem ko bao hondo haroklme baebenom pangen nas kang ngon arman kao dund bisesa. ");
INSERT INTO akh_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ngo tomb mbibim Aorao Aondaon manom bibaebe ke wisao ub bu paklbir wakl mbibin anda su Kalilin and lobokl lobokl Nasarer bor pisbisa. ");
INSERT INTO akh_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ngo tomb nas kang Njises buri palo oborob ora and sobur obu kone and wi ora and sisaol, Ngaorom obul kone u turi aondao ora homobur bisur was bu hasesa. ");
INSERT INTO akh_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ngo tomb Njiseson ingi aorao kabom karasmason was Waran Aeben Bisao hor so buruklbur yu Njurusalem bor pu ha was hasbisa. ");
INSERT INTO akh_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ngub bisbi o mabor Njises marisao o karasmas ukl duteb oran pibi hasao tomb mbibim bu hasbi nda ub Njises di haru pismisa. ");
INSERT INTO akh_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Hor so ngo ber paesmi tomb mabor mbibin anda wakl bokesbil, nas Njises obu Njurusalem bor bao hasao o obun ingi aorao kabom nao hendebur ");
INSERT INTO akh_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","nas ngo tenaol tangar mendbor daol haru peme ko nen sabisbisa. Ngo tomb bao hor bombor harerol paolisbi tomb mbibin sem pismi baeben bor di, tenaol sango pismi baeben bor di, ne mu nas ngo es bisbi o ");
INSERT INTO akh_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","es buwabur kisbin, wakl Njurusalem bor es bam bokesbisa. ");
INSERT INTO akh_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ngub bubur kisbin bao hor teb oran pibi hasao tomb nas nda Ngaor Hen Moroklme Anda andaon Nju semon man buwaloklme aol baeben daol maomunu birismil hend waesbisa. Ngub hindisbil obum aol ngo haklon angal pango burubur kisaon, obum mbini bor di menjao menjao ne misaol kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ngub bismil obun angal pangismi baebenom obum oborob ora kone kikil bubur kisao ub hesa obum mbinin angal oborob ora ko san lisao nda ub kab hondobur burir aondao ora bismisa. ");
INSERT INTO akh_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ngo tomb obun ingi aorao kabom obu hen waesbi tomb mbibin kone bor taol taol bu, burir aondao ora biyubur obun amom obu bor kakl, Wao. Nas o, njen ab hesa yaon kone bor hem ko kang sao aondao sao bin ora burubur nje es aondao ora bubaong, njem yao asub ko maobaolari balem? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ngub kisaol Njisesom mbibi bor kakl, Ibim ni asub ko es bu harbi? Nao Aoraon anda bor hayao ko nen nao sobaebi be? kisao o ");
INSERT INTO akh_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","obum angal ngo kisaon te mbibim nen sabokl buwaesbisa. ");
INSERT INTO akh_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ngo tomb obum mbibin angal hul nao haebur mbini haru Nasarer wakl inin pismisa. Ngub pismi tomb obun am Mariyam ngo bisao sao hambun sao obun kone bor win was birisaol, menjao nen nao sabe birisesa. ");
INSERT INTO akh_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ngo tomb nas Njises obun toklo and sisao ub obun kone bor di and sam sam bisaol, Ngaorom di tenaol hambunom di obu turi homo kone u hasmisa. ");
INSERT INTO akh_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ngo tomb Orom semon aol wesmbao aondao ora obun imbi Tabiriyas kismil, obum su aondao ngo hambun bor karasmas maoklaopun teb oran maomb bo hasesa. Ngo tomb su ngo baebenon Njuriyan maomb bo haraoklao aol Pondiyas Paler obu sisaol, aol Heror obu su Kalilin maomb bo haraoklao aol sisesa. Ngo tomb Heroron haeme Pilib sisaol, aol ngo obum di su Ituriya hesa Terekonatis kab maomunu maomb bo hasesa. Ngo tomb aol Laseniyas obu di su Abilinin maomb bo haraoklao aol sisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ngo tomb aol Anas hesa Kayapas kab di Nju semon baolum aol wesmbao aondao ora haenbur sisesa. Ngo tomb mbini aol ngo baebenom ngub maomb bo haenbur aol Sekarayan isi Njon obu su tenaol nao biri bor po hasaol, Ngaorom obun angal aol ngo bor eben kisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ngub bisaol obum su Njoran hambun bor pobur kisaon, obum tenaol hambun bor kone baol munubur mbabtas bibaebe kisesa. Inim ngub buklemi tomb khorob bismi sao inin kone bor wiyao o Ngaorom kunaklao ko kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ngub bisaol angal ngon mbes Ngaoron man mini aol Asayam di mbuk waeb ngub bu wisao. Su tenaol nao biri bor Aol mondom angal aondao bu ora mend kobur kakl Aorao Aondao poklao hareron oborob ora kareyo Mao dund sa man man bibaebe. ");
INSERT INTO akh_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Harer mendbor kuwis ha taol ha bi uklao hakl Taemb soklwaebe. Su aolu muyae kang sao baeben di Inim harbor aondao baeben di Tombo hond ber peb bibaebe. Harer mendbor kul maongul bi baeben di Dund mao sa peb bibaebe. Harer mendbor han biri luklao baeben di Kobo tuwa peb bu ebe mao saklwaebe. ");
INSERT INTO akh_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ngaorom obun sem ngo bu muklbur be ko Tenaol hambunom hondoklemi ko Asayam waeb bu wisao ub Njonom kisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ngo tomb tenaol andub ora Njonom mbini mbabtas bin ko obo kiril mbaesmil Njonom mbini bor kakl, Ini suklumb sem o hakl o, Ngaorom ini ko homo ke mao handaklao ub, aem was ini ke ngo nao hondoklemi ko kao njaonaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Wakl kakl, Ngub inj, njem oborob buklesi ub Ngaorom njen kone baol minisi ko henden, inin kone ora bor em we ebe sao por ken haklwaebe kisesa. Ngo tomb Njonom wakl kakl, Nao Eberehem obu Ngaorol hul ha hasao on isi wane ora hayom ol, ebe soklao ko nen nao saboklwaebe. Ngub inj, nim ini bor heneng ora kao njurukl, Ngaorom Eberehemon isi wane haklemi ub hobao sao ora ko hem kokl beyaon, obum han ngo wi o baeben di Eberehemon isi wane ebe mao ingiyakl beyao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ngo tomb Njonom ngub kobur kakl, Kuwi kakeb is te bor man man bu pa wisao o bao wiyao ora. Is mendbor il oborob nao saoklao baeben obum bobur is de bor haoruklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Njonom ngub kisaol tenaol nda baebenom Njon bor naom kone baol munuklbur asub ora buklmaob ko? ne mismisa. ");
INSERT INTO akh_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ngub kismil Njonom mbinin angal ngon ko san ngub lisesa. Ini ngo hayem haklon mondom njen siyor kab wae sin, mende njen tenaol sango siyor nao wi buruklao o bao kalaebe. Nje aol mondom ne kang mend andub sao wae sin, njem di ngub bibi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ngo tomb mone takis moroklme aol mendbor Njonom mbini mbabtas bin ko obo hasmi baebenom di Njon bor ne mubur kakl, Aol aondao o, naom kone baol munuklbur asub buklmaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ngub kismil Njonom mbini bor kakl, Inim mone takis muklemi tomb kabmanom ngub baeben mibaebe ko kao njuklao ub ora mibaebe. Inim mone mendbor baehaemen habarabur nao mibaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ngo tomb mbini mendbor ami aol obo hasmi baebenom di Njon mbabtas biyao aol bor ne mubur kakl, Naom di kone baol munuklbur asub was buklmaob? kismisa. Ngub kismil obum mbini bor kakl, Inim aol mende lu bowes bu mbini maobowa, baehaemen mbinin mone muklbur howes ko ngub nao bibaebe ora. Inin sokl muklemi o makl homo hem was nao lowaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ngo tomb tenaol ngo hasmi baebenom turi aondao ora homobur, mbinin kone bor aol ngo obu Ngaorom Eben Lao Aol mend oboklao lomao nda ye ko nen sab sab bismisa. ");
INSERT INTO akh_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ngub nen sabismil Njon Mbabtas Biyao Aolom mbini bor kakl, Nim ini ibom ora mbabtas biyu o mabor aol hobao sao mend oboklao. Aol ngo obun burim nao buri men mbae ora yao. Ni di kho ora hae ol nim obun aongao su di nao kolakaeb se ora hae kisesa. Ngub kobur kakl, Obum ini obun Wesao Ebe Tangar di is sung kabom ini mbabtas buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ngub kobur kakl, Obun ki bor ang honde hesa mondolom kab sarbe kobaraoklao is hul mend meneyaom, ang tu honde hesa mondolom kab* sarbe koboklme nda ub obum ang noklme anda bor sarbe maemb kobur, mondolom baeben isaolao nao hindili dao hakol bi bor hi haoruklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ngo tomb Njon Mbabtas Biyao Aolom tenaol ngo hasmi baebenon kone mao komba angal tangar tangar andub ora kao kalobur kisaon, tenaol hambun bor Angal Bib Hobao Sao ngo oborob ora kao dund bisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Ngub bisao o mbinin kabmanon maomb bo haraoklao aol Herorom khorob andub sao was bubur kisaon, obun haemen were ten Heroriyas di obu akl ba habur, aol Heror ngom khorob tangar sao di andub ora bisesa. Ngub bisaol Njon Mbabtas Biyao Aolom aol Heror ngo bor ngub nao bibi ko taolu lisesa. Ngo tomb aol Heror ngom khorob ngub was bu hasao ub khorob aondao bu ora mend di kond ba bubur kisaon, obum Njon Mbabtas Biyao Aol nda di kalabus mao palaesesa. ");
INSERT INTO akh_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Ngo tomb Njonom tenaol hambun mbabtas bisao ub Njises di mbabtas bisesa. Ngub bu peyobur Njisesom Ngaor bor kao kalakl hasaol, yu heben kebe kobabur Ngaoron Wesao obu sao ebeyabukl non bim obobur kisaon, Njises obo men mbaesaol hindismi tomb yu heben bor angal mend obobur kakl, Nje nao Isi ora hael ol, nim njel kone uruklul nao kone bor di turi aondao ora bin hae kisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ngo tomb Njises marisao o karasmas supu hor mend hor kabo nanon tobon kab be? menjao pibi hasao tomb Njisesom obun kongon hobao sao bukl ibisao nda ub tibiya bisesa. Ngub bisao o mbini tenaolon kone bor non Njises obu Njosebon isi ora e ko nen sabismisa. Ngo tomb Njoseb obu Hilaen isi sisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hilae obu Mataton isi sisesa. Matat Libaen isi sisesa. Libae Melkaen isi sisesa. Melkae Njanaen isi sisesa. Njanae Njosebon isi sisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Njoseb Matatayason isi sisesa. Matatayas Emoson isi sisesa. Emos Neyamon isi sisesa. Neyam Eslaen isi sisesa. Eslae Nakaen isi sisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakae Mayaton isi sisesa. Mayat Matatayason isi sisesa. Matatayas Semenon isi sisesa. Semen Njosekon isi sisesa. Njosek Njoran isi sisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Njora Njonanon isi sisesa. Njonan Eresan isi sisesa. Eresa Serababelon isi sisesa. Serababel Salliyelon isi sisesa. Salliyel Neraen isi sisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerae Melkaen isi sisesa. Melkae Eraen isi sisesa. Erae Kosamon isi sisesa. Kosam Elmaramon isi sisesa. Elmaram Eron isi sisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Njosuwan isi sisesa. Njosuwa Eliyesan isi sisesa. Eliyesa Njorimon isi sisesa. Njorim Mataton isi sisesa. Matat Libaen isi sisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Libae Simiyonon isi sisesa. Simiyon Njuran isi sisesa. Njura Njosebon isi sisesa. Njoseb Njonamon isi sisesa. Njonam Elayakimon isi sisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elayakim Meliyan isi sisesa. Meliya Menan isi sisesa. Mena Matatan isi sisesa. Matata Netanon isi sisesa. Netan Debiron isi sisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Debir Njesin isi sisesa. Njesi Oberon isi sisesa. Ober Bowason isi sisesa. Bowas Salmonon isi sisesa. Salmon Nasonon isi sisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason Aminarabon isi sisesa. Aminarab Arminon isi sisesa. Armin Anaen isi sisesa. Anae Hesronon isi sisesa. Hesron Pereson isi sisesa. Peres Njuran isi sisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Njura Njekobon isi sisesa. Njekob Isakon isi sisesa. Isak Eberehemon isi sisesa. Eberehem Teran isi sisesa. Tera Nehoron isi sisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nehor Serukon isi sisesa. Seruk Ereyun isi sisesa. Ereyu Pelekon isi sisesa. Pelek Eberon isi sisesa. Eber Selan isi sisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela Kenanon isi sisesa. Kenan Apaksaron isi sisesa. Apaksar Semon isi sisesa. Sem Nowan isi sisesa. Nowa Lamekon isi sisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek Metuselan isi sisesa. Matusela Inokon isi sisesa. Inok Njereron isi sisesa. Njerer Mahalalelon isi sisesa. Mahalalel Kenanon isi sisesa. ");
INSERT INTO akh_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan Enoson isi sisesa. Enos Seron isi sisesa. Ser Aramon isi sisesa. Aram obu Ngaoron isi sisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ngo tomb Njises obun kone bor Wesao Ebe Komb Bi ndam aondao bu ora honda hasao tomb, ib Njoran mari ngol haklbir obu wakl bokesesa. Ngub po hasao tomb Wesao Ebe Tangar ndam Njises obu su tenaol nao biri mend sisao bor kemi pisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ngub bisaol Njises obu su tenaol nao biri ngo bor bao hor supu kab kab hor kab oran bao hasaol Seranom Njises obu khorob mao baklbur bisesa. Ngo tomb Njises obu bao ngo pibi hasao baeben hambunon obu ne nao ne was hasaol, mabor obu dem aondao ora himisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ngo tomb Seranom Njises obu bor kakl, Nje heneng ora Ngaoron Isi yao sin, han ngo wi hakl wakl palawe men aolin kao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ngub kisaol Njisesom obun angal ngon ko san lubur kakl, Ngaoron mbuk waebom ke wiyao ub tenaolom sul bao haklemi tomb ne noklme saon was nen nao saboklwaebe buklemi ke wiyao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ngo tomb Seranom Njises yu manda mend sisao bor kemi pobur kisaon, bombor ngo ora tomb su hambun bor tangar tangarom maomb bo haroklme ub Njises henden muwalisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ngub bubur kisaon Seran ndam Njises bor kakl, Yaom hambun sao ebe ngo hendeyob sao baeben nje njubur, ninao buri di nje was taol bu nju hambun sao njem was maomb bo hanin lowao kisesa. Ngub kobur kakl, Hambun sao ngo wi baeben nim was maomb bo han njisaol ninao was wi kisesa. Wakl kakl, Nim ngo baeben aol is mend kaloklwao ko nen soba sin, nim ebe kaloklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ngub kobur kakl, Njem tumu kar munu dombes ubur ni bor kaoya kae sin, yaom ngo hendeyob sao baeben hambun sao njen was uklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ngub kisaol Njisesom obun angal ngon ko san lubur kakl, Ngaoron mbuk waebom ngub ke wiyao. Njen Aorao Ngaor bor ora kaoya ko, obun kongon bombor o ora bibi ke wiyao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Ngo tomb Seran ndam Njises su Njurusalem kemi pobur kisaon, obu Ngaor Hen Moroklme Anda and hom kem yu ora bor kemi po haen kobur obum Njises bor kakl, Ngaoron mbuk waebom ke wiyao ub nje hanom aongao lu menjao nao bin ko, Ngaorom obun angal mini wesao baeben kao kaloklaol nje mbinin ki hobaol po tibaninleming, nje heneng ora Ngaoron Isi yao sin ngol habur unu ngo ora bor bonge kisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ngub kisaol Njisesom obun angal ngon ko san lubur kakl, Ngaoron angal ukl mend di ngub ke wiyao. Njen Aorao Ngaor bor menjao menjao nao mao ba hendaebe ke wiyao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ngo tomb Seranom Njises obu bor khorob hambun sao ngub mao baklbur bisao o, mao bakl buwaesao tomb obum mabor ko mende bi hondoklwao ko nen sobaoklbir Njises tuwakl paokl ora pisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ngo tomb Njises obu Ngaoron Wesao Ebe Tangar ndam buri mao palaesao ub obu su Kalili wakl bokesesa. Ngo tomb Njisesom bisao sao arman kam aeben bismil, su ngo hambun bor pangam aeben aeben bismisa. ");
INSERT INTO akh_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ngo tomb Njisesom Nju semon man pangoklme anda hambunon hondabur Ngaoron angal bib ebe kao kalo hasaol, tenaol hambunom obu turi homo kaoya kismisa. ");
INSERT INTO akh_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ngo tomb Njises obu su Nasarer obu nas kang tomb hasao bor pisesa. Ngo bor ngub po hasao tomb Nju semon hor boroklme bao o pindib paesaol, mbinim bismi ub obu di man pangoklme anda ngon hondaesesa. Hondabur kisaon obum mbuk waeb bor hondoklbur teka hasao tomb ");
INSERT INTO akh_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","mbinim Njisesom mbes man mini aol Asayam mbukl waeb bu wisao ub hondobur ken ko mbuk ngo kalismisa. Ngub kalismil Njises obum mbuk nda bor taongaokl bu es bu hindisao tomb ngub wisaol hindisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Aorao Aondaon Wesaom nao kone bor honda hayaol Obum nim tenaol dimb baeben bor Angal bib hobao sao kao kalon ko mao hasao. Seranom men mba waoraoklao baeben Nim wakl kur mi pon ko obum ni obon kisao. El kho baeben di wakl el mao tan lao. Tenaol mendbor men mba ke mao handaroklmel Mbinin kone bor dam nao bin boroklme baeben di Bu mun ko obum ni obon kisao. ");
INSERT INTO akh_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Bao ebe ngon Aorao Aondaom obun tenaol men muklao ko Kao kalon ko ni obon kisao ko Asayam mbuk waeb bu wisao ub Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ngo tomb Njisesom mbuk nda wakl hoba munubur, maomb bo haraoklao aol nda obun wakl kalobur kisaon tol ber paesesa. Ngub bisaol man pangoklme anda ngon tenaol ngo ber mba hasmi baebenom, Njises obum angal ngo mbuk waeb ngo bor wisao on te asao was leb ko sub hondo ber mba hasmisa. ");
INSERT INTO akh_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ngo tomb Njisesom mbini bor angal ngon te kao kalobur kakl, Angal ngo wi ub inim ngubi tomb ngo pangoklem ol, Ngaoron mbuk waebom wen ngo buklao ke wisao ub embi ngubi tomb ora ngo il so pind biyaokl o kisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ngo tomb tenaol ngo birismi baebenom Njisesom angal di oborob was kisao nda ub pangobur, mbinim burir aondao bu ora bismisa. Ngub bubur mbinin kone bor turi aondao ora homobur kakl, Aol ngo obu Njosebon isi ora inj ye sa bo? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ngub kismil Njisesom mbini bor kakl, Ni hende ora inim ni bor angal mar kobur ngub lemi. Dokta o, njem njen mbib mao ebe sa lemi kisesa. Wakl kakl, Inim ni bor ngub di lemi. Njem su Kabenam bor bisi ub naom ora pangismaong, njem njen su enjo ngo bor di ngo bisi ub bi lemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Obum ngub kobur kakl, Nim ini bor heneng ora kao njurukl, Ngaoron man mini aol baebenom mbinin su and te sisao bor man lemi ub mbinin semom makl homobur nao pangoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Wakl kakl, Pangeklem. Mbes man mini aol Ilanja hasao tomb se nao eben ko saohar bor tiriyao bo peyaesaol, karasmas ukl teb di ek ukl dowa mend di ngub baeben oran se nao ibisaol, su ngo baeben hambun bor de aondao ora ibisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ngub bisao tomb su Isreyel bor Nju sem ten weyae andub ora birismi o, Ngaoron Ilanja obu ten ngo baeben birismi on is mend nao bisur bu pen kebur, Tenaol Sem Tangar ten, ten weyae is mend obu su Siron bor and te Sarepar bor birisaol, obu ngo bor ora pu kisao. ");
INSERT INTO akh_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Mende di mbes Ngaoron man mini aol mende Ilasa hasao tomb di su Isreyel bor aol maollun bi andub ora birismi o, aol ngo baebenon is mend ebe nao mao saesao ora. Aoh, obum su Siriya aol obu aol sem tangar Neman, aol maollun bi ngo obu ora ebe mao saesao ora ko Njisesom ngub kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ngub kisaol Nju sem ngo man pangoklme anda ngon birismi baeben hambunom, angal ngo kisao nda pangobur ko aondao ora himismisa. ");
INSERT INTO akh_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ngub ko homobur kismin mbinim Njises and lobokl lobokl dera nan munu lenge taokl and te ngon manda bor men pae yin pobur, bare kho ora mend sisao bor haoklu tu kobaklmao ko nen sabismisa. ");
INSERT INTO akh_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ngub nen sabobur kismin tenaol andub ora pismi o, obu tenaol aondao ngo hasmi darukl o bor sub bongeyaokl paokl ora pisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ngo tomb Njises obu su Kalili and lobokl lobokl Kabenam bor pisesa. Ngub pobur kisaon Nju semon hor boroklme bao o pindib paesao tomb obum tenaol hambun bor Ngaoron angal bib ebe ngo kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ngub kisaol mbinim pangismi tomb obum oborob ora kone kikil bi, bi make lome aolom lome nda ub angal buri ora kisaol pangobur, burir aondao ora bismisa. ");
INSERT INTO akh_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ngo tomb aol is mend obun tombao bor sam kho ora biri mend man pangoklme anda ngo bor birisao om kaong aondao bu ora lubur kakl, ");
INSERT INTO akh_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Wao. Nasarer Njises o, njem nao bor asub ora buklbur obae balem? Nje Ngaoron komb bi aol ora hael ol nim nje ora hendeng, njem nao khorob ora lu bowes bukl obae be? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ngub kisaol Njisesom sam ngo aolon tombao ndaon bor birisao nda bor buriyab ora taolu lubur kakl, Njem aol ngon tombao bor angal ko nao biri dera pib ora kisesa. Ngub kisaol sam ngo aolon tombao bor birisao ndam aol nda mbini ber mba hasmi ngol sul komb hakl po win kaoklbir, aol ngo obu bor menjao nao bi paokl ora pisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ngub pisaol tenaol ngo hasmi baebenom pakl homo burisao pobur kismin mbini hakl hakl kakl, Obum angal ngo asub bi mend ko hae bo? Obum aolon tombao bor sam beraemi baeben bor bi make lao aolom angal buriyab ora lome ub keyao tomb, mbinim obun angal hul nao hae paokl was puklmi kismisa. ");
INSERT INTO akh_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ngo tomb Njisesom ngo bisao saon arman su ngo hambun bor kam aeben aeben bismil, tenaol hambunom pangaesmisa. ");
INSERT INTO akh_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ngo tomb Njises obu man pangoklme anda ngo tuwaklbir kisaon, aol Simon Pitan anda hondaesesa. Ngub hondaesao tomb aol Simon Pitan weren ingi obun toklo pob turub bu sen aondao bu ora ha wisaol, mbinim Njises bor ten ngo bisur bu ebe mao sakl ib ko kao kalismisa. ");
INSERT INTO akh_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ngo tomb Njises obu ten nda u mba hasaol teb so po habur kakl, Sen kho ngo njem ten ngo obu nao mao homaklesi ora kisesa. Ngub kisaol ten nda obu pob turub bu ngo homo wisao ub ebe bao sisaol, ten ndam penar bu teka peyobur kisaon, tenaol ngo birismi baeben ne taol bu kaloklbur man man bisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mabor ombonao nar anda bombisao tomb su ngo bor tenaol andub ora sen kam mundub mundub hae homo wismi baeben, Njises obu hasaol was taokl obo kiril mbaesmisa. Ngub taokl obo kiril mbaesmil obun kim tenaol ngo sen ha wismi baeben men mbaesao tomb mbini hambun ebe sisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ngub bisaol tenaolon tombao bor sam birisao nda baebenom paokl was pobur, e ko karaklae aondao bu ora kobur kakl, Nje Ngaoron Isi ora hael kismisa. Mbinim obu ngub Ngaorom Eben Ke Aol ora hae ko hindismil, obum mbinin angal ngo kismi ub ken wa nao bi, mbini e beb nao ke paokl was pen kisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ekera nan bao bu hebeyam ibisao tomb Njises obu su and te ngol haklbir kisaon, su tenaol nao biri mendbor pisesa. Ngub pisao o tenaol mendborom obu es bu hend wabur obu hasaol ibismisa. Ngub obobur kismin mbinim obu bor kakl, Njem nao tuwaklbir su tangar mende bor nao poklesi ora ko kao deb deb bismisa. ");
INSERT INTO akh_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ngub bismi o Njisesom mbini bor kakl, Ngaorom nim obun kongon hobao sao ora ngo bun ko obon kisaol, nim obun Angal Bib Hobao Sao ora obum maeb ha maomb bo hayaon on, mbini tenaol su and lobokl lobokl aeben o bor bereme baeben hambunom di pangen kao kalam akol poklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ngo tomb obum Nju semon man pangoklme anda hambunon hondabur, angal bib hobao sao ngo kao kal ha was hasesa. ");
INSERT INTO akh_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ngo tomb Njises obu ko mend oran ib mal Kenesareron mare bor hasaol, ngo obu hasao bor tenaol andub ora Ngaoron angal bib ebe ngo hem ko pangoklbur obo dengeb dengeb kao mba hasmisa. ");
INSERT INTO akh_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ngo tomb Njises obum hindisaol, ib mal ngon marel ib taokaoll kang tokl kab mend wisaol hindisesa. Ngub hindisao tomb ib wen moroklme aol baebenom mbinin taokaoll kab ngo ngol bao win kaoklbir, ib wen ongon bu moroklme sao ib dand bukl pismil hindisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ngo tomb Njises obu Simon Pitan ib taokaoll bombor mend wisao bor honda burubur, tenaolom obu hasaol dengeb dengeb lemi ko nen sabobur Pita bor kakl, Njem ib taokaoll ngo kang mend moklo ib wil sao munu soklmen sa kisesa. Ngo tomb Njisesom tenaol aondao ngo dengbe mba hasmi baeben bor Ngaoron angal bib ebe nda kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ngub kao kal pesao tomb mabor Simon Pita bor kakl, Njem wakl ib taokaoll ngo moklo ib tukunol abeyo kang mend men sao pobur, inin wen ongon bu moroklme sao abo unu ib ndaon bor pen kobur inim ib wen mib kisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ngub kisaol Pitam obun angal ngo kisao on ko san lubur kakl, Aol aondao o, naom embi bao somna ngon kongon buri ora bumao o naom wen is mend nao mumaong, njem kal ub non nim wen ongon bu moroklme sao ngo unu ib ndaon bor pen kao hondon wa ye kisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ngo tomb mbinim ngub bismil wen ongon bimi sao nda bor ib wen aondao was andub ora birisaol, wen ongon bimi sao nda kend aondao ora bubur eyo lokl kobaeb se sisaol pe kobaklao ko nen sabismisa. ");
INSERT INTO akh_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ngub bisaol mbinin aol sango mbini wen mu hasmi aol mendbor ib taokaoll menden birismi baeben bor, nao bisur bu wen ngo men menin ubuklub ko ki pun kar mib bismisa. Ngub bismil ibismi tomb wen nda baeben mubur, ib taokaoll tokl kab kobaran bor mari pismil, ib taokaoll nda kab wen aondao ngo marismi o kend tiril ib ndaon bor ponde men pae hondaesesa. ");
INSERT INTO akh_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ngo tomb Simon Pitam ngo bisao sao hondobur kisaon, obum Njiseson aongao ma teb so bor tumu karu dombes ubur Njises bor kakl, Aorao Aondao o ni khorob biyu aol ora hae ngao, njem ni tuwakl pu ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pitam ngub kisao o obu di mbini haru hasmi baebenom di, ib wen andub ora ngo mismi o hindismi tomb burisao po pakl aondao ora himismisa. ");
INSERT INTO akh_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ngo tomb aol Sebirin isi kab Njon hesa Njemus kab di, Simon Pita obu daol mbini haru kongon bombor sao bu hasmi o mbibi kab di burir bisbisa. Ngub bismil Njisesom Pita bor kakl, Njem pakl nao homaebe. Njem ngubi tomb sao ol non tenaol men muklesi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ngo tomb mbinim ib taokaoll ngo moklo ib tukunol sao wisao nda wakl ib marel en obobur, taokaoll ngo ib mare ngol bao u mba, mbinin hambun sao wismi sao hakl di bao u haen tuwaklbir mbinim Njises was taol mi pismisa. ");
INSERT INTO akh_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ngo tomb Njises obu su and lobokl lobokl mendel hasaol, su ngo bor aol maollun bi is mend obun toklo hambun bor derom pe taokl pe mend hasao om Njises hondobur kisaon, Njises hasaol dombes ubur obu bor kakl, Aol aondao o, njem ni ebe mao sakl ko pangal sin, ebe mao saklesi ora ko kao deb deb bisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ngub bisaol obun kim aol ndan toklol men mbabur kakl, Aol o nim nje ebe sen ko pangaklol, njen toklo bor der ngo biye baeben di ngubi tomb ebe saokl kisaol, bombor ngo tomb obun toklo hambun bor der ngo bisao nda ub ebe bao sisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ngo tomb Njisesom aol ngo bor angal buriyab ora kobur kakl, Njem ni Njisesom ebe mao sanao ko mendel nao kao kalaebe. Ngub inj, njem ngubi tomb Nju semon baolum aol bor bombor o nao songol ebe sa ko muwalokl pu. Ngub pobur lesin mbes Mosesom nje non bi semom bibaebe kisao ub, tenaol hambunom njen toklo songol wakl ebe sene ko henden ub Ngaor bor menjao kalo mabaorao haoribi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ngub kisao o Njisesom hambun sao ngo bu hasao sao su hambun bor pangaesmil, tenaol andub ora obu hasaol was dengeb dengeb kobur obum angal ebe ngo kisao nda ub pango, obum mbini sen ha wismi baeben di mao ebe saen ko obo kiril mba was bismisa. ");
INSERT INTO akh_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ngub bismi o obum Ngaor bor kao kaloklbur su tenaol nao biri bor pu was bu hasesa. ");
INSERT INTO akh_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ngo tomb ko mend oran Njisesom tenaol hambun Ngaoron angal bib ebe nda kao dund bi hasaol, Peresi aol mendbor di Nju semon man buwaloklme aol mendbor di, mbinin su Kalili di Njuriya di Njurusalem di ngo hakl bor haklbir obo birismisa. Ngo tomb Aorao Aondaon burim Njises obu men mbaesaol, obum tenaol sen ha wismi baeben di ebe mao sa was bisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ngo tomb aol mendborom aol aongao tibae mend obun to bor bor is ha pa taokl obobur, Njises hasaol tu uklbur bismi o ");
INSERT INTO akh_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","and ngo Njises obu hasao on tiriyao kombae bor tenaol andub ora dengeb dengeb was kismil, aol aongao tibae ngo Njises hasao bor taokl hondakl buwaesmisa. Ngub hondakl buwabur kismin mbinim and ngon hom kemol hond ya and hom munu kebe kobabur, aol aongao tibae nda obun to bor bor unu tenaol ber mba hasmi ndal, Njiseson el dund sol yam hend ha tu kobaesmisa. ");
INSERT INTO akh_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ngo tomb Njisesom aol ngo baebenom obul hul ha ora habur ngo bismi sao hondobur, obum aol aongao tibae nda bor kakl, Aol o nim njem khorob bisi sao njen kone bor wiyao o kunarukl kisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ngub kisaol pangobur Nju semon man buwaloklme aol baeben di Peresi aol mendbor di mbini hakl hakl makl homo sub kao kao bubur kakl, Aol ngo obum Ngaor bor maobowa angal bu, hul ha angal ngo be o ka. Aol tenaolon kone bor kho wiyao o kunaeb se mend nao hae, Ngaor obu bombor ora hayao ko kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ngub kismil Njisesom mbinin kone hondo angal ngo kismi on ko san lubur kakl, Inim inin kone bor asub ko khorob ngub nen sabeklem? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ngub kobur wakl kakl, Inim angal awo was kend bi ko pangeklem? Aoh, nim njen kone bor kho wiyao o kunarukl kanda ub kend bi soklaol bukl buwaklwao be? be? nim nje tekakl pu lowao ub kend bi soklaol bukl buwaklwao ko pangeyem? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ngub kobur kakl, Ni Aolon Isi Ora hae ol, sun tenaol hambunon kone bor kho wiyao sao kuna, tenaol heme di ebe tekakl pu kaeb se hae ko hendeklemin ub kobur, obum aol aongao tibae ngo bor kakl, Nje teka peyo, njen to abo daol mu minibir njen anda pu ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ngub kisaol aol ndam bombor ngo ora tomb tenaol ngo ber mba hasmi baebenon el sol teka peyobur, obun paolaoklao to nda taoklbir Ngaor bor tengiyu ko kaoya kobur obun anda pisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ngo tomb tenaol ngo birismi baebenom ngo bisao sao hondobur burir aondao ora biyu, mbinin kone bor di pakl hom mubur kismin mbinim Ngaor bor turi homo kaoya kismisa. Ngub kobur kakl, Naom ebe ngubi ko mend nao hindismao sao ora bandal handamnda kismisa. ");
INSERT INTO akh_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ngo tomb mabor Njisesom takis maoraoklao aol mend obun imbi Libae obu takis moroklme anda bor birisaol hindisesa. Ngub hondobur Njisesom Libae bor kakl, Njem ni taol mi ib kisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ngub kisaol takis maoraoklao aol ndam obun hambun sao tuwaklbir kisaon, obum Njises taol mi pisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ngo tomb takis maoraoklao aol ndam Njiseson ne aondao ora mend obun anda bor haorakaesaol, takis moroklme aol mendbor di aol tangar mendbor di mbini hambun takis maoraoklao aol Libae hesa Njises kab daol haru ne no birismisa. ");
INSERT INTO akh_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ngub bismil Peresi sem hesa Peresi aol mendbor man buwaloklme baeben kabom, Njiseson man pange aol baeben bor makl homo ne mubur kakl, Inim asub ko mone takis moroklme aol hesa khorob bimi aol baeben kab daol Njises haru ne no bereyem? kismisa. ");
INSERT INTO akh_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ngub kismil pangobur Njisesom mbinin angal ngon ko san lubur kakl, Tenaol sen nao hae baebenom dokta biri nao puklmi ora. Ngub inj, tenaol sen ha homo wimi baebenom was dokta biri puklmi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ngub kobur kakl, Nim tenaol oborob bu haroklme baeben bor kone baol monoklwaebe kokl inj obowao ora. Ngub inj, nim aol khorob bimi baeben bor kone baol munu inim khorob bismi sao tuwaklwaebe kokl obowao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ngo tomb tenaol mendborom Njises bor kakl, Mbes Njon Mbabtas Biyao Aolon man pange baebenom mbinim ko andub ora Ngaor bor nen saboklbur ne di nao ne tuwa paolismi. Mende di Peresi semon man buwaloklme aol baebenom di ngub was bimi o, njen man pange baebenom ne di ib di asub ko bao was noklme? kismisa. ");
INSERT INTO akh_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ngub kismil Njisesom mbini bor kakl, Aol mondom obun ten wen taol bubur, aol ngo obun tenaol sango baeben di mbini haru turi homo buruklemi tomb ne nao ne buruklemi be? kisesa. Ngub inj ka. ");
INSERT INTO akh_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Aol ten wen taol bi ngo obu mabor mondom obu su tangar bor pen lao bao o pindib paklaol, obun tenaol sango baeben daol maomunu nao haklemi tomb mbinim obu hem kobur ebe ne tuwa paoluklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ngo tomb Njisesom mbini bor angal mar mend di kao kalobur kakl, Toklo and turub bi mbes pange piri mend kaollu dir wiyao tomb, dir ngo wiyao o bor manga taombuluklbur mondom toklo and turub bi ebe wen pange mend heya bowes nao bimi ora. Ngub inj, mondom ngub ba sin obum toklo and turub bi ebe wen pange ngon heya pae kang ngom, toklo and mbes pange on dir uklao bor manga mba taombuluklao ub di, toklo and ngo kab bombor ubi inj sakl, kengi nao bi ub baehaemen mu bowes ora buklao. Ngub buklaol toklo and turub bi wen pange ngo di heya bowes ora buklaol, kobaran ora mu bowes buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ngub kobur kakl, Mondom ib waen wen pange di some songol be mbes pange bor nao kowe tu ndaroklme o, mondom ngub ba sin ib waen wen pange ngom some songol be ngo dallmbe kobaen laol, ib waen ngo di ora kowe bowes buklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Aoh, mbinim bimi ub ib waen wen pange sa sin, mbinim some songol be di wen pange bor was birin lome kisesa. ");
INSERT INTO akh_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Njisesom ngub kobur kakl, Aol mendbor ib waen mbes pange neme baebenom ib waen wen pange turi nao hemebur, ib waen mbes pange ebe ora saoklao lome ko Njisesom mbini bor angal mar ngub kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ngo tomb Njises obu Nju semon hor boroklme bao* bombor menden wir il em hinin pibisao tomb, obun man pange aol nda baebenom wir il mendbor talobur, subu dab hakl pen ko mbinin kim peb sokl men peb bubur nismisa. ");
INSERT INTO akh_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ngub bismil Peresi aol mendborom mbini bor kakl, Inim hor boroklme bao on naon manom nao bibaebe ke wiyao sao asub ko bim? kismisa. ");
INSERT INTO akh_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ngub kismil Njisesom mbinin angal ngo kismi on ko san lubur kakl, Inim mbes aol wesmbao aondao Debirom bisao sao arman mbuk waeb bor wiyao ub nao hendeme be? kisesa. Ngub kobur kakl, Nim ngo kakl o mbes Debir obu di obu haru hasmi baeben di mbini hambun dem khorob ora himismi tomb ");
INSERT INTO akh_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Debir obu Ngaor bor kaoya lome anda bor hondabur, and ngon palawe Ngor bor kalismi o wisaol tenaol hambunom nao noklwaebe ora, baolum aol baebenom was noklemi ke wisao o, Debir obum di mu nobur kisaon obu haru hasmi baeben di kalisao ke wiyaong, inim arman ngo mbuk waeb bor wiyao ub nao hendeme be? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Njisesom mbini bor wakl kakl, Pangeklem. Aolon Isi Ora obu hor boroklme bao on Aorao Aondao ora yao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ngo tomb hor boroklme bao o mende pindib paesaol, Njises obu Nju semon man pangoklme anda hondabur tenaol hambun bor Ngaoron angal bib ebe nda kao kalisesa. Ngo tomb obum hindisaol, aol is mend obun ki tao nan o kho tibae ora birisaol hindisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ngo tomb Nju semon man buwaloklme aol mendbor di Peresi aol mendbor di, mbinim Njisesom hor boroklme bao* on obum tenaol sen ha uklemi o ebe mao sarob sin, mbinim obu bor ngol mao bembera howes koklbur sub obum asub was bib ko bao hondo hasmisa. ");
INSERT INTO akh_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ngub bismi o mbinim ngo bu hasmi sao obum ora hende sakl, aol ki tibae nda bor kakl, Nje tekabur tukun oral ha kisaol teka hasesa. ");
INSERT INTO akh_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ngub bubur kisaon Njisesom mbini hambun bor angal mend ne mun kobur kakl, Naom hor boroklme bao on naon kone ebe ora u haklmao ub tenaol mende bisur buklmao be? be? naom mbini bor khorob buklmao? Naom tenaol mende oborob ora haen ko bisur buklmao be? be? naom mbini pe paen lu tuwaklmao? Manom asao was ke wiyaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ngub kobur kisaon obum mbini hambun elom hondo akol bubur aol ki tibae nda bor kakl, Njen ki abo dundukl pe kisaol, aol ki kho ndam ngub bisao tomb obun ki wakl ebe bao sisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ngub bisaol Nju sem nda baebenom ngo hondobur kismin, mbinin kone bor kho so ko aondao bu ora homobur, mbini hakl hakl sub kao kao bubur kakl, Naom Njises obu bor oran asub ora bem balem? kismisa. ");
INSERT INTO akh_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ngo tomb Njisesom yu harbor manda mend sisao bor pobur, Ngaor bor kao kalokl pisesa. Ngub pobur kisaon obum bao somna ngon Ngaor bor was kao kalo baram baram bubur bao bu kobaen kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ngub bubur kisaon nar do hebe peb bisao tomb obun man pange tenaol baeben ubuklub kobur, obum aol duteb oran sabol peb bu mao habur, ini nao angal bib hobao sao kam akol bu haklemi aol hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ngo tomb aol ngo haklon is mend obun imbi Simon sisao o, Njisesom imbi tangar karu ubur Pita kisesa. Ngo tomb Simon Pita ngon haeme Andur di, Njemus Njon kab di, Pilib hesa Batolimu kab di, ");
INSERT INTO akh_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiyu Tomas kab di, Aolpason isi Njemus di, Simon mende obu Selor sem sisaol ngo obu di, ");
INSERT INTO akh_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Njemus menden isi Njuras di, Njuras mende Iskeriyaor Njuras mabor Njises karu lubur Njises lukl bismi baeben munu kalisao aol nda di, Njisesom ngo baeben sablo haen kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ngo tomb Njises obu yu harbor manda bor haklbir aol duteb nda baeben daol haru wakl inin pobur kismin, mbinim unu su hond pae oral po pindib paesmi tomb, ngol obun man pange tenaol andub ora obo ha mba hasmisa. Ngub hasmil tenaol andub ora su Njuriya tenaol di, Njurusalem tenaol di, ib kunja teb so bor paoloklme tenaol mendbor su Taya hesa Siron kab bor paolismi baeben di, ngo baeben hambun ora obo hasmisa. ");
INSERT INTO akh_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mbinim Njisesom angal ebe ngo kisao nda ub pango, mbinin tenaol sen ha wismi baeben di obum wakl ebe mao saen ko ngub obo hasmil, Njises obum tenaol mendboron tombao ndaon sam birisao baeben di taol dera ebe mao sa was bisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ngo tomb Njises obun burim tenaol hambun ngub ebe mao saesaol hondobur, tenaol hambunom di mbinin sisao nim Njiseson toklol waran ko nen sab sab bismisa. ");
INSERT INTO akh_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ngo tomb Njisesom obun man pange tenaol baeben hondo akol bubur kakl, Ini tenaol menjao nao wi burubur dam nao bin boroklme hakl o ini Ngaorom maeb ha maomb bo hayao bor po hakleming Inim turi hom ha was haklwaebe. ");
INSERT INTO akh_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ini ngubi tomb dem homo boroklme hakl o inim mabor ne ebe no tombao ha was hakleming Inim turi homo haklwaebe. Ini ngubi tomb de ko boroklme hakl o inim mabor kir kao ha was hakleming Inim turi homo haklwaebe Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ngub kobur kakl, Inim Aolon Isi Ora obu hem ko taol mi poklemil, mbinim ini bor makl homo nar wen ebe hende non bubur, ini bor angal kho ko ini ngol nao hae puklub ko lu taoluklemi. Mbinim ni maobowa peb bu inin imbi di kho tangar tangar sao hakl menger mu imbi karu ukleming, ");
INSERT INTO akh_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ini mabor haklemi ub nen sabobur lemin turi hom ha was haklwaebe. Heneng ora inin sokl aondao ora yu heben bor wiyaong, turi homo taom bu haklwaebe kisesa. Pangeklem. Mbes di mbini ngo baebenon ab sumb wil baebenom Ngaoron man mini aol mbes hasmi baeben bor di ngub was bismi ko, Njisesom obun man pange nda baeben bor ngub kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ngub kobur kakl, Ini aol aeben o mone aorao o hakl o, inim ngubi tomb mone sokl mubur turi hom ha was ngo hayem ub inin sokl mbes mu pele non bi ora hayem ol, ini mabor menjao nao mi ke hondokleming hondo ora haklwaebe. ");
INSERT INTO akh_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ini mendbor ne andub ora no tombao ha haroklme hakl o, ini di ke aondao ora hondobur mabor ini dem homokleming inim hondo ora haklwaebe kisesa. Ini ngubi tomb kir ko ngallaeb bu haroklme o hakl o, ini ke aondao ora hondobur mabor ini de aondao bu ora leming, hondo ora haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ini aol mendbor tenaol mendem kaoya ken haroklme hakl o, ini ke aondao ora hondokleming inim hondo ora haklwaebe. Mbes inin ab sumb wil baebenom di man kho tangar mini aol baeben bor ngub was kaoya kismi ko Njisesom mbini hambun bor ngub kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ngo tomb Njisesom mbini bor wakl kakl, Ini tenaol ngo ninao angal pango bereyem o hakl o, inin saond bi bor hond homobur kone wibaebe ora. Inim tenaol mendbor ini bor ko homoklme baeben bor di, inim wakl oborob sao was bibaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ngub kobur kakl, Inim tenaol mendbor ini bor hondo ko bowes bu mao kho sa angal buklemi baeben bor di, inim mbini bor turi haen sao was bibaebe. Tenaol mendbor ini bor maobowa peb bu lu bowes buklemi baeben bor di, tenaol ngubi baeben Ngaor bor bisur bibi ko kao kaloklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ngub kobur kakl, Aol mondom njen payo mende nan la sin, njem njen payo mende nan lin ub baol minibi kisesa. Mende di aol mondom njen toklo and turub bi kur ma sin, njen siyor hesa toklo and turub bi kab kobaran mao nao hae bao kalaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Njisesom ngub kobur kakl, Aol mondom nje bor menjao nji ka sin, njem obu bao kalaebe. Aol mondom di njen menjao uklesi o mi pa sin, njem obu bor nao wakl nji ko penj nao bibi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mende di tenaol mendborom njem turi hemenin ko bimi nda ub, inim di tenaol aebenol haklemim turi hemen sao was bibaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Njisesom ngub kobur kakl, Inim tenaol mendbor ini bor turi homo kone uklemi o bor was inim di turi homo kone u harim sin, nim oborob biyu ko nen sobal be? kisesa. Ngub inj, tenaol khorob bimi baebenom di mbini hakl hakl ngub kone wi wi bimi o, mbinim Ngaorom turi hemen inj bimi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Wakl kakl, Inim tenaol ini bor oborob buklemi baeben o bor was oborob bu bisur baem sin, tenaol khorob bimi baebenom di ngub was biming, njem oborob sao oran asao ora buklesil Ngaorom nje bisur buklao? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ngub kobur kakl, Inim tenaol mende osisao kaloklemi tomb inin wakl san lib se baeben was sarbe kalaem sin, mbini tenaol khorob bimi baebenom di mbini poklemi on el tubur ngub was biming, Ngaorom nje asub ko turi homo bisur buklao? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ngub inj, inim inin saond bi hem ko kone ubur, inim mbini bor bisur bu oborob was bibaebe. Inim tenaol mende bor menjao kaloklemi tomb, obum ninao wakl san lin ko nen nao sabebur ora kaloklwaebe. Inim ngub ora buklemi tomb mabor inin sokl di aondao ora mubur, ini Ngaor aondao yubu oran isi wane buruklemi kisesa. Ngub kobur kakl, Ngaorom tenaol obu bor turi homo tengiyu nao lome baeben bor di, tenaol khorob bimi baeben bor di hond was hemeyao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ngub ora biyaong, inin Ab Aondaom tenaol hambun hond hom ha was hayao ub inim di tenaol mende hond homoklwaebe ora ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Njisesom ngub kobur kakl, Njem tenaol mende bor nje kho hael ebe hael ko, te mao sara nao sablo haebe. Njem tenaol mende bor kho ebe ko ngub te mao sara nao sablae sin, mondom nje di te mao sara nao sabloklao kisesa. Mende di njem njen konem tenaol mende makl homobur te nao mao sarari sin, Ngaorom nje di makl homo te nao ma saraklao ora kisesa. Ngub kobur kakl, Inim tenaol mendbor ini bor khorob bimi baeben bor saongao nao maraem sin, Ngaorom inin khorob bismi sao di saongao nao mari kunaklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Inim tenaol mende bor mbinim wa win haklemi sao oborob ora bisur bu kaloklwaebe. Ngub buklemi tomb Ngaorom ini bor di aondao bu kond babur sao tumbi hakl di poboklaol, men ning ning kobur ora mar pa njuklao. Heneng ora inim tenaol mende bor aondao bu haoklu sao kalaem sin di, kang dub bu sao kalaem sin di, Ngaorom ini bor menger bombor ngub was taol bu njuklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ngo tomb Njisesom mbini bor angal mar di bombor mend kao kalobur kakl, Tenaol el kho mondom tenaol el kho sango mende harer nao muwaloklme. Ngub inj, obum ngub ba sin mbibi kobaran el kho kab kab sakl, ib kena bor kundukl halabur saokl uklebi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ngub kobur kakl, Tenaol sukul lome baebenom mbinin tisam buwaloklao ub bao wa, mbinim mbinin tisa men mbabur tangar ub bukl buwaklemi. Ngub inj, mbini mabor sukul kao paklemi tomb mbinim mbinin tisa hesa bombor ubi soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Mende di and kindbarom njen elol as mba hayaol nje el kho ora hael o, njen elol ngo as mba hayao on mbes nen nao sabebur, njen tenaol sangon elol huni kang ora uklao o asub hondobur mu tuwakan lesib? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wakl kakl, Njem njen elol and kindbar aondao ora as mba hayao nao hendebur, njem asub bubur njen tenaol sango bor nao haeme o, njen elol huni kang abo wi o mu tuwakan lesi? Songolol aol hobao o, njen elol and kindbar o mbes mu tuwaebe. Ngub mu tuwari sin, njen tenaol sangon elol huni kang ngo uklao o di ebe hondo maklesi ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ngo tomb Njisesom kakl, Is ebem il kho nao saoklao. Is khom di il ebe nao saoklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ngub kobur kakl, Tenaolom is isao ngo ebe be? kho eb ko ebe hondoklemi kisesa. Wakl kakl, Inim saon hesmbulom timbaol saoklaol nao taloklme. Bundinom di ang saoklaol nao taloklme. ");
INSERT INTO akh_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ngub inj, tenaol kone ebe wi baebenon kone bor hambun sao ebe sao was wiyaol, mbinim buklemi sao di oborob was buklemi. Bombor ngub was tenaol khorob bimi baebenon kone bor khorob bimi sao was wiyaol, mbinim buklemi sao di khorob sao was buklemi. Tenaolon ne bor angal kao deraeme tomb mbinin kone bor wiyao ubi was kao deraroklmel inim ebe hondoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Njisesom wakl kakl, Inim nao angal pango ni taol mi nao ebebur, asub ko ni bor Aorao o Aorao o was lomeb? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Aol mondom nao angal hul nao hae pangobur ni taol mi oboklao tomb, obum ngo buklao ub inim oborob ora nen sabeklemin kao dund bun pangoklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ngub kobur kakl, Aol ngo obu aol and oborob bi mend hasesa ubi soklao. Obum and pinj saoruklao bor sowal unu han wi anga bor pen tombobur, simenom han ngo hesa kimb bu pelen kobur bisaol, mabor ib wae aondao ora disao tomb obum and ngo oborob ngub ora bisaol, kundi taokl nao pisao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ngub kobur kakl, Aol mondom di nao angal pangobur o hul habur ni taol mi nao oba sin, aol mende and su demil bi mend hasesa ubi soklao. Aol ngo obun and bisao tomb obum and pinj saorukl bi bor di simenom oborob han kab kimb nao bu pelen kebur bisaol, ib wae aondao ora disao tomb and ngo penar bu kundi bowes bu khorob ora kundi hakl buri kisao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ngo tomb Njisesom tenaol hambun bor angal ngo kao kal paklbir kisaon, su Kabenam po pindib paesesa. ");
INSERT INTO akh_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ngo tomb su ngo bor Orom semon ami sem maomb bo haraoklao aol mend hasaol, aol ngo obun kongon biyao nas mend obum kone aondao bu ora wisao o sen khorob ora ha ubur kisaon, ora pe pakl ke ke bi birisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ngo tomb ami sem maomb bo haraoklao aol ndam Njises hae ke pangobur kisaon, Nju semon maomb bo haroklme aol, aol kon wi baebenon mendbor Njises biri puklub kobur kakl, Obum nao kongon biyao nas ngo sen ha wi o ebe mao saen ub ib lowaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Ngo tomb mbinim Njises hasaol pobur taeki kobur kakl, Ami sem maomb bo haraoklao aol ngom nao Nju sem baeben hond aondao ora homobur, obun mbib naon and man pangoklme anda di bisaol, obu aol ebe ora yaol njem obu hond homo bisur bib se ora yao ko kao deb deb bismisa. ");
INSERT INTO akh_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Ngo tomb Njises obu di aol ngo Njises obu kaomukl ibismi nda baeben di mbini haru pismisa. Ngub pobur ami semon maomb bo haraoklao aol ndan anda teb sol sao pismi tomb, aol ndam obun aol sango mendbor bor Njises kao kalokl puklub kobur kakl, Aol aondao o, ni aol kho ora nje hael ol nao ebeb se ora hae ol, aol ebe nje non bi di nao anda bor nao ebeb se ora yao ka. Ngub yaong nje enjo ngol baehaemen kem homoklbur nao ebe, njem abo ngol habur njen angal oram nao kongon biyao nas ngo wakl mao enjakao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ngub kobur kakl, Nim ngo kakl o, ni kongon bibi ko mao hasaomon ni bor di ngo sao ngo sao bibi keyao tomb biyu. Nim di nao ami baeben maomb bo haruklu o, nim nao ami ngon is mend bor ngub kaklo. Nje pu kaklo, ngo tomb puklao. Is mende bor ngub kaklo. Nje ib kaklo, ngo tomb ubuklao. Ngo tomb nao kongon biyao aol bor ngub kaklo. Njem kongon ngo bibi kaklo ngo tomb biyaol, njem di angalom menjao lesi tomb buklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ngub kisaol Njisesom aol ndan angal pango burir biyubur kisaon, obun ma nan baol munu hondobur tenaol andub ora ngo obu haru ibismi nda baeben bor kakl, Nim ini bor heneng ora kao njurukl, aol sem tangar ngo obum nil ngo hul ha harekle ub Nju sem tenaol baebenon ngubi is mend nao hondowao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ngo tomb ami aolon angal mini pismi nda baebenom ami aol ngon anda wakl ibismi tomb nas nda ebe sisaol hindismisa. ");
INSERT INTO akh_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ngo tomb kang mend mabor sao Njises obu su and lobokl lobokl Nen pisesa. Ngo tomb obun man pange aol baeben di tenaol andub mendbor di obu haru pismisa. ");
INSERT INTO akh_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ngo tomb su and lobokl lobokl Nen ngon saond paeb te tiriyao komba oral pindib paesmi tomb aol pe pae mend taokl ibismil hindismisa. Ngub hindismi tomb nas ngo pe paesao o obun ingin nongnas is mende di nao biri bombor ngo ora, ten ngo obun aoli di nao hae heme ora sisesa. Nas pe pae nda taoklbir nas ngon ingi di su and lobokl lobokl ngon tenaol baebenon andub ora mendbor di mbini haru ubukl hasmisa. ");
INSERT INTO akh_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ngub ubukl hasmil Aorao Aondaom ten kang nda hondobur hond aondao ora himisesa. Ngub hond homobur kisaon Njisesom ten kang nda bor kakl, Njem de nao kao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ngub kobur kisaon obum nas pe pae ngo is ha taokl ibismi to ndal men hindisao tomb, mbini aol mendbor nas ngo taokl ubukl hasmi nda baebenom di bao nimil tu hasmil Njisesom kakl, Nas o nim nje bor kakl ngao, nje teka kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ngub kisaol nas pe paesao nda teka burubur kisaon, angal hakl ko birisesa. Ngub birisaol hondobur Njisesom nas ndan kil men mubur obun am kang nda kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ngo tomb tenaol hambunom Njisesom ngo bisao sao hondobur, mbinim burir aondao ora biyu burisao pobur Ngaor bor was kaoya kismisa. Ngub kaoya kobur kakl, Man mini aol aondao ora mend enjo nao hayom ol ngo obo pindib paraokl o kismisa. Ngub kobur wakl kakl, Ngaorom obun tenaol ngo bu mukl obaokl o kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ngub bisaol Njisesom aol heme ngo mao enjaesao on arman su Njuriya di su hambun bor kaom aeben aeben bismil tenaol hambunom pangaesmisa. ");
INSERT INTO akh_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ngo tomb Njon Mbabtas Biyao Aolon man pange tenaol baebenom Njisesom ngo bisao saon arman hambun sao Njon Mbabtas Biyao Aolom pangen kao kalismisa. Ngub kismil pangobur Njon Mbabtas Biyao Aol ndam obun man pange aol is kab mend ubuklub kobur, ");
INSERT INTO akh_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Aorao Aondao hasaol angal bombor mend kaom puklub ko kao kalobur kakl, Naom aol mend oboklao ko hondo haroklmao nde, nje ngo obae o be? be? naom aol tangar mend wen oboklao ko bao hondo haklmaob ko, Njises ne mukl puklub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ngo tomb Njon Mbabtas Biyao Aolon man pange aol is kab nda Njises hasaol po pindib pabur kakl, Yao kab Njon Mbabtas Biyao Aolom nje biri puklub kobur obum ngub ka. Naom aol mend oboklao ko hondo haroklmao nde, nje ngo obae o be? be? naom aol tangar mend wen oboklao ko bao hondo haklmaob? ka ko kao kalisbisa. ");
INSERT INTO akh_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ngo tomb bao bombor ngon Njisesom tenaol sen kam mundub mundub hae andub ora mao ebe saesesa. Obum tenaolon tombao bor sam biri di taol deraesesa. Obum el bokl mini baeben di wakl el tin kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Njisesom ngub bubur Njonon man pange aol nda kab bor mbibin angal kisbi ndan ko san lubur kakl, Ibim Njon obu hayaol pobur lebin, nim hambun sao buwao sao ibim handaebnda ub di pangaebi ub di ibim Njon obum pangen kao kaloklwaebe. Tenaol mendbor el kho baeben di wakl el tin ko, tenaol mendbor aongao kho baeben di wakl harer peben ko, tenaol mendbor maollun bi mendboron mbinin toklo bor der bisao hakl di songol heneng eben ko, hal bowe baeben di wakl hal mao komba, tenaol pe pae baeben di wakl mao enjarob lowaebe. Mbini tenaol dimb menjao nao wi boroklme baebenom di Ngaoron Angal Bib Hobao Sao pangaem lowaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ngub kobur kakl, Tenaolom nil hul ha habur kone taol taol nao buklemi baeben, mbinim turi was hom ha haklemi ka ko kao kaloklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ngo tomb aol is kab Njon Mbabtas Biyao Aolon angal mini ibisbi nda kab anda pisbi tomb, Njisesom tenaol andub ora ngo dengeb dengeb kao mba hasmi baebenom pangen Njon Mbabtas Biyao Aolon arman kao kalobur kakl, Inim mbes su tenaol nao biri bor pismisa tomb inim asao was hondokl pismi? Posabsum kaemb isao ukl mend kar paesao hondokl pismi be? ");
INSERT INTO akh_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Inj ka. Inim asao ora hondokl pismi? Aol mondom obun lab lab ebe ora was bu hasaol hondokl pismi be? Ngub di inj ora. Aol lab lab ebe same di hambun sao ebe sao was wi, aol ngubi baeben aol wesmbao aondao baebenon anda bor was haroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ngub biming inim asao was hondokl pismi? Inim man mini aol bombor mend hasaol hondokl pismi be? E ka. Nim ini bor heneng ora kao njurukl, Njon man mini aol ngo obum man mini aol mendbor hambun men mbayao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ngub kobur kakl, Ngaoron mbuk waebom Njonom ngub buklao ke wisao. Pangeklem. Aol bombor ngo nim mabor nao angal mini Obu nje mbes pu lowao. Obum nje poklesi hareron Kare mao dund sarukl burukl poklao ko Ngaoron mbuk waebom ke wisao ub Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ngub kobur kakl, Njon obum tenaol sul hayem baeben hambun men mbayao o, Ngaorom maeb ha maomb bo haen haroklme haklon ndi nao mini kang bombor mondom, aol aondao Njon di ebe men mbaeb se hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Mbini takis moroklme aol mendbor di tenaol mendbor hambun di, mbini hambunom Ngaorom ngo bibaebe kisao ub oborob dund se ora kise ko pangobur, mbinin kone baol munu Ngaor bor turi homo kaoya kobur Njonom mbini mbabtas bin pismisa. ");
INSERT INTO akh_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ngub bismi o mendbor Peresi sem di Nju semon man buwaloklme aol baeben di Ngaorom mbini harer ebe muwalisao o, nao hende non bu mesao kalobur mbini Njonom mbabtas bin nao ibismisa. ");
INSERT INTO akh_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Njisesom ngub kobur kakl, Nim tenaol man nao pange ngubi tomb hayem baeben bor menger asao was muklwao? Mbini asub bi was hayem? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Pangeklem. Mbini ngo baeben nongnas kang kang mendborom mbinin homal ber mba habur, nongnas sango mbini bombor ubi baeben bor ubuklub kobur kakl, Naom ini bor pollpib keyom o, inim non we nao keyem. Naom non hond homo de keyom o, inim non de di nao keyem lome ubi hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ngub kobur kakl, Nim menger bombor ngo murukl ub Njon Mbabtas Biyao Aol ndam di obu ne nao ne paolubur ib waen di nao nisao o, inim Njon obun tombao bor sam biri hae kismi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ngub kobur kakl, Ngubi tomb Aolon Isi Ora obobur, ne di ib waen di neyaol hendeme tomb inim obu bor kakl, Haondaoklaob. Aol ngo obum ne di andub ora was no, ib waen di andub ora nekle lome kisesa. Wakl kakl, inim aol ngo obu aolmendbor mone takis moroklme aol baeben hesa tenaol khorob was bu haroklme kabon tenaol sango ora hae lome. ");
INSERT INTO akh_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ngub lome o Ngaor obun kone u haraoklao ub heneng ora ngo il so pindib paklbur be ol, Ngaor obum oborob sao was bu haraoklao ko tenaol hambunom ebe hondoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ngo tomb Peresi aol mondom Njises nao anda bor ne nokl ib ko hondokl pisaol, Njises obu Peresi aol ngon anda bor ne noklbur obo birisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ngo tomb su and lobokl lobokl ngo bor ten khorob was bu hasao mend birisao ndam, Njises obu Peresi aol menden anda bor ne no bere ke pangisesa. Ngub pangobur kisaon ten ndam han alpastam* wari be ebe teraebi buri ora mend sisao bor wel ber pae mend minibir Njises birisaol ibisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ten ndam ngub mini obobur kisaon Njiseson mesao nan aongao ma teb so bor obo habur de kisaol, ten ngo obun delibom Njiseson aongaol po hasesa. Ngub po hasaol ten ndam obun wesmbao irim Njiseson aongaol obun delib po hasao nda kunaesesa. Ngub bubur kisaon obum Njiseson aongao ma bor nunu aondao ora bubur, obum Njiseson aongao bor wel tangar ebe ora mondom sulaesesa. ");
INSERT INTO akh_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ngo tomb Peresi aol ngo Njises bor ne nokl ib kisao ndam, ten ndam Njiseson aongaol ngo baesao sao hondobur obum ngub nen sabisesa. Ten ngom khorob was bu haraoklao ndal, heneng ora aol ngo obu Ngaoron man mini aol ora sokl baonaon, ten ngo obun aongaol wararaokl om bu haraoklao ub di obun kone bor wiyao sao di ebe mao bembera hondokl baonao ko, Peresi aol ndam ngub nen sabisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ngub nen sabisaol Njisesom Peresi aol ndan kone bor hondobur obu bor kakl, Simon o nim nje bor angal kang mend kao njun ko pangakl kisaol, Simonom kakl, Aol aondao o ebe ka. Njen angal kao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ngo tomb Njisesom mar kobur kakl, Aol is kabom aol is menden san, mende aolom mone supu hakl hakl hor su aondao ora haklao tomb, mende aolom kang tobon kab bu haklebi. ");
INSERT INTO akh_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ngub buklebi o mbibin menjao nao uklebil san lukl buwaeb se haklebi tomb, aol mone aorao ndam obun mone ngo san lib nao ke bao warob sin, aol ngo kabom mone aorao nda san kang bu haklaomon turi homo aondao bu obul kone uklao be? be? mende aol aondao bu munu haklaomon turi homo aondao bu kone uklaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ngub kisaol Simonom angal ngon ko san lubur kakl, Nim nen sobakl tomb, aol mende obu mone san aondao bu ora munu haklaomon mone aorao ngol kone uklao saol ko nen sobakl kisesa. Ngub kisaol Njisesom kakl, Njem oborob ora nen sobal kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ngo tomb Njisesom ten nda birisao nan baol munu hondobur Simon bor kakl, Njem ten ngo hendel be? Nim njen anda andaon hondawao tomb njem nao aongao wes wes lun ko ib nao humu njaenda o, ten ngo obun delibom nao aongao wes wes labur, obum hoboll ken ko obun wesmbao irim kunarobnda kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ngub kobur kakl, Njem ni nunu nao kaenda o, ten ngom ni wen njen and ngo bor hondarunda tomb ora nunu ko harobnda ub, ngubi tomb di nunu was ngo ke o kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mende di njem nao wesmbaol wel nao sularinda o, ten ngo obum wel tangar ebe ora nao aongao bor sularobnda kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Wakl kakl, Nim nje bor ngo kakl o non ngub nen sabobur kakl ka. Ngaorom aol mend obun kone bor kho kang bu sao uklao o kunaklao tomb aol ngo obum Ngaorol kang bu sao kone uklao. Ngub buklao o ten ngo obum non khorob aondao bu ora bu hasao o, obum ngubi tomb nil kone aondao bu ora waoraokl saom ora bi ko, njem di hendenin obun kone bor kho ngo waoraoklao ub kang ora di nao win ora mu tuwa kunarukl kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ngub kobur Njisesom ten nda bor kakl, Nim njem khorob bisi sao kunarunda kisesa. ");
INSERT INTO akh_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ngub kisaol tenaol ngo mbini haru ne nao mba hasmi nda baebenom burir biyubur mbini hakl hakl kakl, Aol ngo obu aebom tenaolom khorob bimi sao kunaklbur leb? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ngo tomb Njisesom ten nda bor kakl, Njem nil hul ha haril saom nje bu maoraokl ngao, njen kone bor sub tibaen as ko ora pebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ngo tomb kang mend mabor sao Njises obu su and lobokl lobokl aondao baeben bor di kang kang baeben bor di akol bu habur kisaon, obum tenaol hambunom pangen Ngaorom ngub maeb ha maomb bo hayao ko, Angal Bib Hobao Sao ngo kao kalam akol bu hasesa. Ngub bu hasao tomb obun man pange aol duteb nda baeben di hambun haru akol was bu hasesa. ");
INSERT INTO akh_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ngo tomb mbini ten mendbor di Njises daol haru pismil, mbini ten ngo baeben mbes Njisesom mbinin toklo ndaon sam birisaol taol deraesao baebenon mendbor di, mendbor sen ha wismil ebe mao saesao nda baebenon mendbor di ngo baeben sisesa. Ten ngo baebenon is mend Maktala Mariya kismil, mbes Njisesom ten ngon tombao bor sam is haoklao oran birisaol taol deraesao o obu di, ");
INSERT INTO akh_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","aol wesmbao Heroron and di osisao maeb haraoklao aol Susan were ten Njowana di, ten Susana di, ten tangar mendbor andub di mbini ngo baeben Njises daol haru akol bu hasmisa. Ngub pobur kismin ten ngo baebenom Njises di obun man pange aol baeben di mbinim wa win hasmi sao hakl bisur bu kal was bismisa. ");
INSERT INTO akh_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ngo tomb tenaol andub ora su and lobokl lobokl tangar tangar wisao baeben hambun bor hakl obobur, Njises hasaol was obo kiril mbaesmisa. Ngub obo kiril mbaesmil Njisesom mbini ngo baeben hambun bor angal mar mend ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Aol mondom obun em bor em we tand kokl pisaol, mendbor harer tol kolokl baraesaol, tenaolom hala bowes bismil saom arer bu nismisa. ");
INSERT INTO akh_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Em we ngon mendbor di han kel kelol kolokl baraesaol, por kisao o su ibao nao biri han kel kelol sisaol kaeb so bung bisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Em we ngon mendbor den nene haen te bor kolokl baraesaol, den nene hae hesa haru and sao sao bubur kisaon, den nene hae ngo haom mu and sobur men mbaesaol il nao sisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Em we ngon mendbor su ebe oral kolokl baraesaol, oborob ora por ko and sobur il andub ora supu hakl hakl hor su was pabklim lisao ko Njisesom ngub kisesa. Njisesom wakl angal aondao bu ora kobur kakl, Ini angal ngubin te oborob nen saboklme baebenom angal ngo inin hal ora bor pen oborob ora pangoklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ngo tomb Njises obun man pange aol baebenom angal mar ngo kisao on te asub wiyaob ko? ne mismisa. ");
INSERT INTO akh_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ngub kismil Njisesom kakl, Ini ngo baeben bor Ngaorom maeb ha maomb bo haraoklao on te mupango wiyao ub inim hendeklemin ko ngo muwale o, mbini tenaol tangar mendborom angal mar was andub ora pangoklemi o mbinim te nen nao saboklemi. Mbinim elom di hondoklemi o hend heneng nao buklemi. Mbinim halom di pangoklemi o pang heneng bu nen sab heneng nao buklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Njisesom ngub kobur kakl, Angal mar ngon te ngub wiyao. Em we ngo Ngaoron angal ora yao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ngub kobur kakl, Em we harerol kolokl baraesao o saom arer bu nismi ub menger, tenaol mendborom Ngaoron angal bib ebe ngo pangoklemi tomb Ngaorol hul ha haklemil, Ngaorom mbini men muklao ko Seranom angal bib ngo mbinin kone bor nao pen lao hokl pelen lao. ");
INSERT INTO akh_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Tenaol mendbor em we han kel kelol por kisao ndabi hayem. Mbinim wen tomb Ngaoron angal bib ngo hem ko oborob ora pangobur turi homoklemi o, angal ngo mbinin kone ndaon ora bor nao hondaen habur, mbinim ke kang ora mend hondoklemi tomb mbinim hul ha, ha kimb nao bi wakl besao kon uklemi. ");
INSERT INTO akh_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Tenaol mendbor em nene hae hesa maomunu and se non bi hayem. Mbinim Ngaorom angal bib ebe ngo pangaoklbir aeben peme tomb, mbinin kone bor hem lome sao bor was men pae buklao saom di, mone momak sem di, mbinin kone bor heb homo turi mao homaraoklao sao sem di, sul woroklme sao ngubi baebenom angal ebe ngo mbinin kone bor por ko and nao sen men mbaraoklao ora. ");
INSERT INTO akh_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ngub buklao o aol mendbor su ebel em il por kisao ndabi hayem. Mbinim angal ebe ngo pangeme tomb angal ngo hul nao hae men hakol ora bimil, mbinin kone bor di ebe dund se ora habur ne sao and sakl haen hayem ko Njisesom angal maron te ngub kao dund bisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Njisesom ngub kobur kakl, Mondom laomb mao dabur, be bor bomb pa u to bundun bor di mupango nao woroklme. Ngub inj, tenaol and ngon oboklemi baebenom di henden ko, laomb ngo to mandaemol tenaol hambunon el isil woroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ngub kobur kakl, Hambun sao mupang mba haklao sao baeben di mabor tenaol hambunom hondoklemi. Mbinim hambun sao kowes bu bimi sao baeben di mabor Ngaorom tenaol hambunom henden muwaloklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ngub kobur kakl, Inim ngo pangeklem ub oborob ora hondo haklwaebe kisesa. Wakl kakl, Tenaol mondom menjao u harob sin, Ngaorom obu andub ora kond ba kaloklao. Ngub inj, tenaol mend obu menjao nao wi harob sin obum obun kone bor kang mend u hae ko nen sabo haklao o di, Ngaorom wakl muklao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ngo tomb Njiseson ingi di obun haeme wil baeben di Njises hasaol ibismisa. Ngub obo hasmi o tenaol andub ora Njises hasao bor dengeb dengeb kismil, mbinim Njises hasaol teb so pokl buwaesmisa. ");
INSERT INTO akh_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ngo tomb tenaol ngo hasmi baebenom Njises bor kakl, Njen am di njen haeme wil baeben di ngo baeben nje hondokl obaemi o, mbini tubu dera nan bao hayem kismisa. ");
INSERT INTO akh_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ngub kismil Njisesom mbini bor kakl, Pangeklem. Tenaol mendbor Ngaorom keyao sao hem ko pangobur men hakol bimi baeben ninao ingi haeme wil ora hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ngo tomb ko mend oran Njises obu ib taokaollon baoraoklbir obun man pange aol baeben di mbini haru pismisa. Ngub pismi tomb Njisesom obun man pange aol nda baeben bor kakl, Nao ngo peyom o ib mende nan mbin ko peyom ngao mbi kisaol pismisa. ");
INSERT INTO akh_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ngo tomb ib taokaoll ndan pismil Njises obu ib taokaoll ngon ndaon u paol pesesa. Ngo tomb posabsu buri ora mend ib mal ngo bor obobur kisaon, ib taokaoll nda bor ib do tundabur mbini hambun ib no pe barakl ke ke bismisa. ");
INSERT INTO akh_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ngub bisaol hondobur kismin mbinim Njises po mao tekabur kakl, Aol aondao o, nao hambun ngubi tomb ib no pe barakl ke ke beyom kismisa. Ngo tomb Njisesom teka peyobur kisaon, posabsu aondao ngo ibisao nda hesa ib aondao ngo lu taongul taongul kisao nda kab bor taolu lisaol, posabsu aondao ngo ibisao nda hesa ib aondao ngo lu dengeno taokl en aeben bisao nda kab, kur kao mbabur sowa paesesa. ");
INSERT INTO akh_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ngo tomb Njisesom mbini bor kakl, Inim Ngaorol hul nao hae haroklme be? kisesa. Ngo tomb mbinim ngub bisaol hondobur, pakl homo burisao po burir biyubur mbini hakl hakl kakl, Wao. Posabsu hesa ib kabom hul nao hae angal pangen ke aol ngo, obu aeb e bo? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ngo tomb mabor mbinim taokaollon ngub pam pam bubur su Ngerasa po pindib paesmisa. Ngub bismi o su Kalili ib ngon mare mende nan wisao o mbini hakl pismi su nda sisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ngo tomb Njises obu ib taokaollon birisao o ib mare su henengol hond hasesa. Ngub bisaol aol is mend obu su and lobokl lobokl ngo bor haklbir Njises obu hasaol ibisesa. Aol ngo obun tombao bor sam andub ora birisaol, obu mbes ora lab lab di nao same was habur and heneng bor di nao paolisesa. Obum aol maol bor was and waru paolu mango hasao o ");
INSERT INTO akh_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Njises ibisaol hondokl ibisesa. Ngo tomb Njisesom aol ngon tombao ndaon bor sam birisao nda bor nje pu ora kisaol, obum kaong aondao bu ora lubur Njiseson aongao ma teb so bor dombes wisesa. Ngub dombes u mba habur angal aondao bu ora kobur kakl, Njises o nje Ngaor aondao yubu oran Isi hael ol, nje tangar aondao ora hael ngao, njem ni bor asub ko ora ke mao handakl ibil balem? kisesa. Ngub kobur wakl kao deb deb bubur kakl, Saongao noklwao ora ni ke nao mao hendaebe kisesa. Ngub bisao o mbinim mbes aol umubaoli ngo hor hor was sen yam di hankabom di ki aongao kab munu tanga pa ubur oborob ora maomb bo hasmi o, sam ngom obu buriyab ora akl mbokl minisao tomb ya ngo hakl lokl pe win paokl was po hasesa. Ngub bubur samom obu su tenaol nao biri bor was men pae po hasao o sisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ngo tomb Njisesom aol nda bor ne mubur kakl, Njen imbi aeb? kisaol, aol ndam obun tombao ndaon bor sam andub ora buklhoma iri non bi birismi o nen sabobur kakl, Ninao imbi Ndi Nao Minib Se kisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ngo tomb aolon tombao bor sam birismi nda baebenom Njises bor buri palobur kakl, Njem nao is de bor nao paomun kaebe ora ko kao deb deb bismisa. ");
INSERT INTO akh_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ngo tomb harbor manda kang mend teb sol sao wisao on some aondo andub ora mend pil nao mba hasmil hondobur, sam ngo aolon tombao bor birismi nda baebenom Njises bor wakl was kao deb deb bubur kakl, Njem nao some aondao ngo pil nao mba hayem baebenon tombao bor haondaomun waebe kismisa. Ngub kismil Njisesom mbini ngub hondaen waesesa. ");
INSERT INTO akh_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ngo tomb sam aondao ngo aolon tombao bor birismi nda baebenom aol ndan tombao bor baoraoklbir kismin, some nda baebenon tombao bor was hondakl engel bismisa. Ngo tomb some nda baebenom hellenj kao mibir kismin, su kho ora bare ib mal wi mend sisao bor akl was pobur, ib mal aondao ngo bor was bongeyokl engel bismil hambun ora ib no pe baraesmisa. ");
INSERT INTO akh_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ngo tomb aol ngo some nda baeben kalo hasmi baebenom ngo bisao sao haondaoklbir pakl khorob ora akl was pobur kismin, mbinin su and lobokl lobokl aondao baeben bor di su and te kang kang baeben bor di mbinim tenaolom pangen kam buri kismil, su ngo hambun bor pangaesmisa. ");
INSERT INTO akh_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ngo tomb tenaol hambunom ngub pangobur kismin, mbinim Njisesom ngo bisao sao hondokl pismisa. Ngub pobur Njises hasaol po hindismil, aol mend mbes obun tombao bor sam birisao nda obun tombao bor sam ngo birisao nda hakl paokl pismil, wakl obun kone anda ibisaol obum oborob lab lab hakl bombo as ko burubur kisaon, obu Njiseson aongao ma teb so bor birisesa. Ngub bisaol hondobur tenaol ngo ibismi baebenom burisao po pakl aondao ora himismisa. ");
INSERT INTO akh_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ngo tomb mbini tenaol ngo aolon tombao bor sam birisao o taol deraesaol hindismi baebenom, tenaol aondao ngo wen ibismi nda baeben pangen ko, mbes aol ngon tombao bor sam birisao o Njisesom taol derabur ngub ebe mao sarob ko arman kao kalismisa. ");
INSERT INTO akh_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ngo tomb tenaol su Ngerasa nan paolismi baeben hambunom mbinim naom nao hendemao sao mend banda kobur, mbinim pakl aondao ora homobur Njises bor kakl, Nje enjo ngo nao hayom ol nao hae, nje paokl pu ora kismisa. ");
INSERT INTO akh_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ngub kismil Njises obu poklbur taokaollon birisao tomb, aol ngo obun tombao bor mbes sam birisao ndam Njises bor ni yao haru poklbao ora ko kao deb deb bisesa. Ngub kisaol Njisesom obu bor kakl, ");
INSERT INTO akh_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Njem njen anda wakl bokeyobur lesin, Ngaorom nje bor bandisao baeben tenaol hambunom pangen kaebe kisesa. Ngub kisaol aol ndam wakl pobur kisaon obun su and lobokl lobokl bor pobur, Njisesom obu bor bisao sao tenaol hambunom pangen kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ngo tomb Njises obu ib mende nan pisaol, tenaol hambunom obu ebeyao ko hondo burubur obu turi aondao ora homo, mbini hambunom nje oborob obaeng ib kismisa. ");
INSERT INTO akh_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ngo tomb aol bombor obun imbi Njaras, obu Nju semon man pangoklme anda maomb bo haraoklao aol hasao o Njises hasaol ibisesa. Ngub obo pindib pabur obum Njiseson aongao ma teb so ora bor obo tumu kar munu dombes ubur obum Njises bor kakl, Nje nao anda mbao ko kao deb deb bisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ngub bisao o aol ngo obun wane is mend birisaol, nong ngo obun amom obu marisao o karasmas duteb sisao tomb obu sen ubur ora pe pakl ke ke bi birisesa. Ngo tomb Njises obu Njarason anda poklbur pisaol, tenaol andub ora obu pisao bor dengeb dengeb kao mi pismisa. ");
INSERT INTO akh_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ngo tomb ten is mend obu bullim anda buru kimb was bisao o, obum bao hor hambunon ngub bao ber ha haen was karasmas duteb oran pibi hasesa. Ngub buru hasao tomb ten ngom dokta baebenom obun sen ngo hasao ub ebe mao saen ko, obun mone wisao baeben di kal was bubur hambun ora pond bu paen kisao o, monom ebe nao mao saesmisa. ");
INSERT INTO akh_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ngub bu hasao o tenaol hambun dengeb dengeb kao mi pismi nda bor ten ngo obu di Njiseson mesao nan sub pukl habur, obun kim Njiseson lab lab kungni bor waraesesa. Ngub bisaol bombor ngo ora tomb penar bu ora ten ndam bullim nda ber kimb bisao nda kur kisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ngo tomb Njisesom kakl, Aebom ni waraeb? kisesa. Ngub kisaol tenaol ngo hasmi baeben hambunom ni nao hende kao kao bismisa. Ngo tomb Pitam kakl, Aol aondao o, tenaol andub ora nje pel o bor ngo dengeb dengeb kao mi peyem o kisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ngub kisao o Njisesom wakl kakl, Is bombor ora mondom ni waranao tomb nao buri kang mend obu bor pilal mao bemberawao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ngub kisaol ten ndam nim mupangokl buwaklwao ko nen sabobur kisaon dur ko pakl homobur, obum Njiseson aongao ma teb so bor obo dombes wisesa. Ngub burubur kisaon tenaol ngo hasmi baebenon el sol obum Njiseson lab labol waraesao on te kao kalobur kakl, Nim obu warawao tomb penar bu ora nao sen ebe bao saonao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ngub kisaol Njisesom ten ngo obu bor kakl, Nao wane ka, njem nil hul ha haril saom ora njen sen ngo ebe bao saokl ngao, njen kone bor sub tibaen as ko ora pebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ngo tomb Njises obu angal ngub bao kakl haen was, aol is mend Nju semon man pangoklme anda maomb bo haraoklao aol Njaras ndan anda hakl obobur obum Njaras bor kakl, Njen wane nda ora pe parob ngao, njem aol aondao ngo obu baehaemen harer haebeb nao kemi pebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ngo tomb aol ndam ngub kisaol Njisesom Njaras bor kakl, Njen wane ngo ebe soklaong, njem burir biyu hem nao ke nil hul ha ora haebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ngo tomb Njises obu maomb bo haraoklao aol Njaras ndan anda pobur kisaon, obum tenaol ngo birismi nda baeben di hambun and ndaon nao haru hondaem nao ke, ini hambun ora deral bao haklaob kaoklbir obum Pita Njon kab di, Njemus di, nong pe pae ngon ingi aorao kab di, mbini ngo baeben ora Njises obu daol haru hondaesmisa. ");
INSERT INTO akh_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ngo tomb tenaol andub ora wi allbob ko de kao mba hasmi o Njisesom mbini bor kakl, Nong ngo obu ora nao pe pae u paolu wing, inim de nao laob kisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ngub kisaol tenaol ngo hombara birismi nda baebenom nong ngo obu ora pe parobnda o le ko pangobur kismin, mbinim Njises obu bor khorob ora kir ko maobowaesmisa. ");
INSERT INTO akh_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ngub kismi o Njisesom nong pe pae ndan kil men mubur kakl, Nao wane o nje teka kisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ngo tomb nong ngo pe pa wisao nda obun wesao wakl anda bomobur tekasesa. Ngub bisaol Njisesom mbini bor kakl, Inim obu ne kang mendbor nen kalaoklaob kisesa. ");
INSERT INTO akh_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ngo tomb nong ngon ingi aorao kabom ngo bisao sao hondobur burisao po pakl aondao ora himisbil, Njisesom mbibi bor angal buriyab ora kao kalobur kakl, Ibim ngo sao tenaol mendem pangen nao lowaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ngo tomb Njisesom obun man pange aol duteb ubuklub kobur mbinim tenaolon tombao bor sam buruklao hakl taol derabur, mendbor sen kam mundub mundub ha, homo uklemi hakl di mao enja peb bin ko obun buri taol bu kalobur, mbini ngo baeben mao ha peb bisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ngub bubur kisaon obum Ngaorom maeb ha maomb bo hayao ub tenaol hambun pangen kao kalam akol bu, tenaol mendbor sen ha uklemi baeben di mao enja peb bukl puklub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ngub kobur obum mbini bor wakl kakl, Inim harer poboklbur mini pubuklmi sao hakl hambun sao, hakla tom di inin nu di mone hesa noklme sao kab di nao maroklwaebe. Inin siyor di kab nao mari puklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ngub kobur kakl, Tenaol mendborom ini oborob obaeming ubuklub kaem sin, inim and bombor ngo pibnao hondaklemi on was bao haklwaebe. ");
INSERT INTO akh_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Inim mabor and te menden poklemi tomb ini mbinin anda bor oborob obaeming paolukl mbin ubuklub nao kaem sin, inim and te ngo tuwaklbir dera nan poklemi tomb, inin aongao bor su huni haklao o di mbinim mabor ke aondao ora hondoklemi ub menger, mbinin su and te ngo bor win tandoklo tuwaklbir, inim su ngo di tuwaklbir paokl ora poklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ngo tomb mbinim su and te hambun bor akol bu, Ngaoron Angal Bib Hobao Sao tenaol hambunom pangen kao kalam akol bubur kismin, su hambun bor sen ha wismi baeben di ebe mao sam akol bismisa. ");
INSERT INTO akh_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ngo tomb aol wesmbao Herorom Njisesom hambun sao ngo bu hasao sao pangisao tomb hesa tenaol mendborom Njon Mbabtas Biyao Aol obu wakl enjaokl pene kismi ub kab pangobur, aol wesmbao Heror ngo obun kone bor kang sao aondao sao bu buraeb kao mba haen ora birisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ngo tomb tenaol mendborom kakl, Ilanja wakl obo hayao ye? kismisa. Mendborom kakl, Aoh, Ngaoron man mini aol mbes hasmi haklon is mend wakl enjaokl obo hayao ye? kismisa. ");
INSERT INTO akh_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ngub kismil Herorom kakl, Nim Njon Mbabtas Biyao Aol obu mao peyundis o ngubi tomb angal ngubi ngo aebom ko hayaob kobur, obum nim aol ngo hondoklwao ko nen sabisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ngo tomb Njises obun angal bib hobao sao kam akol bu haroklme aol nda baeben wakl anda obobur kismin, mbinim bam akol bu hasmi sao baeben hambun sao Njisesom pangen kao kalismisa. Ngo tomb obum mbini tenaol aeben baeben bao birin, obun angal bib hobao sao kam akol bimi aol nda baeben ora ware pe, su and lobokl lobokl menden imbi Bersara bor kemi pisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ngo tomb tenaol hambunom mbinim ngo bismi ub ora hindismil, mbinim Njises obun mama taol mi pismisa. Ngub pobur mbinim obu hasaol pindib paesmi tomb obum menjao nao ke oborob ora ubuklim ko pangobur, obum tenaol ngo baeben hambunom pangen Ngaorom ngub maeb ha maomb bo hayao ko kao dund bubur kisaon, obum tenaol mendbor sen ha wismi baeben di mao enja peb bisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ngo tomb mbon sisaol aol duteb ndam Njises obu birisaol obobur kakl, Naom su ngo bor tenaol nao biri bor hayom ngao, njem tenaol ngo baeben dem homoklemi, mbini and hae tenaol biri sisao ne es bu no paolam buri ken kao kismisa. ");
INSERT INTO akh_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ngub kismi o Njisesom mbini bor kakl, Inim ora mbini ne taol bu kalaoklaob kisesa. Ngub kisaol mbinim Njises bor kakl, Wao. Naon ne andub nao wi, palawe pao su mend di ib wen is kab bu ngo ora wiyom ngao, njem tenaol ngo hayem baeben hambunon ne naom was dob bakl paomun ko pangal be? kismisa. ");
INSERT INTO akh_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ngo tomb aol andub ora 5,000 buklhoma iri non bi ora hasmisa. Ngub hasmil Njisesom obun man pange aol ngo baeben bor kakl, Mbinim tenaol ngo baeben bor supu kab kab hor kabol hor tebo nanon tobon kab was ber ber bin laob kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ngo tomb Njiseson man pange aol nda baebenom ngub bubur kismin, tenaol hambun ngub birin kismisa. ");
INSERT INTO akh_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ngo tomb Njisesom palawe pao su nda hesa ib wen is kab nda kab mu munubur, obum yu heben bor hend ya Ngaor bor tengiyu kao peyobur, obum palawe nda hesa wen kang nda kab konde berabur kisaon, obum obun man pange aol nda baeben bor tenaol aondao ngo baeben taol bu kalaoklaob ko kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ngub bisaol mbinim ngub taol bu kalismi tomb tenaol hambunom ebe no tombao hasmisa. Ngub no tombao habur nokl nao bisaol bao win waesmi baeben, mbinim mbasker nu tokl duteb oran mar pa wismisa. ");
INSERT INTO akh_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ngo tomb ko mend oran Njises obu hungum habur kisaon Ngaor bor kao kalo birisaol, obun man pange aol baeben di obo hasmisa. Ngo tomb Njisesom obun man pange aol ngo baeben bor ne mubur kakl, Tenaol hambunom ni aeb ora hae lomeb? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ngub kisaol mbinim obun angal ngon ko san lubur kakl, Mendborom nje Njon Mbabtas Biyao Aol e lome. Mendborom nje Ilanja hae lome. Mendborom di nje man mini aol mbes hasmi on mend wakl enjobur hae lome kismisa. ");
INSERT INTO akh_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ngub kismil Njisesom obun man pange aol ngo baeben bor kakl, Mbinim ngub ngo lome ong, inim ni aeb ora lemib? kisesa. Ngub kisaol Pitam obun angal ngon ko san lubur kakl, Nje Ngaorom Eben Ke Aol ora hael kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ngo tomb Njisesom mbini bor kakl, Inim ni Ngaorom Eben Ke Aol hae ko tenaol mendem pangen nao lowaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Njisesom ngub kobur kakl, Ni Aolon Isi Ora hae ol, nim tenda no ke hondoklbur hae ka. Heneng ora mabor Nju semon maomb bo haroklme aol, aol kon wi baeben di, mbinin baolum aol aondao baeben di, mbinin man buwaloklme aol baeben di, ngo baebenom ni mesao njubur mbinim ni tenda mao na pe pan luklemi ora. Ngub buklemi o nim bao hor tebo nanon wakl enjaokl poklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ngo tomb Njisesom mbini hambun bor wakl kakl, Mondom ni taol mi obae sin, ni tenaolom imbi ken haklwao ko nen saboklao ub tuwaklbir obum obu pe pae non bi habur, obun is pe kowal bi bao hor hambunon ti hakol bubur ni taol mi ebebe buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tenaol mondom ni imbi ken ora haklwao ko nen soba sin, obun hambun sao baondib munuklaol obu imbi nao wi kang ora soklao. Ngub inj, tenaol mondom ni hem ko taol mi oboklaol obu imbi nao wi kang ora harob sin, mabor obu imbi wi aondao ora habur haeben saklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ngub kobur kakl, tenaol mondom obu imbi wi aondao ora habur sun osisao hambun sao maru u haklao tomb obu haeben sakl buwaeb se harob sin, obun osisao ngo maru u haklao sao baebenom asub bubur obun imbi win ko haeben saen laob? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ngub kobur kakl, Mondom nao angal pango ni taol mi ebebe on sakl men men ba sin, Aolon Isi Ora obu bao bi ora habur obu obun Ab Ngaoron angal mini wesao komb bi baeben di mbini Ngaoron buri aondao bao bi o bor bor oboklemi tomb, Aolon Isi Ora obum di tenaol ngo baeben bor sakl men men buklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ngub kobur wakl kakl, Nim ini bor heneng ora kao njurukl, ini tenaol ngo hayem baebenon mendbor nao heme bao haen was Ngaorom maeb ha maomb bo hayao ub hondoklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Njisesom angal ngo kao paesao tomb mabor bao hor duteb be? menjao pibi hasao tomb Pita Njon kab di Njemus di ngo baeben kemibir kisaon yu manda bor Ngaor bor kao kalokl pisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ngub pobur Ngaor bor kao kalisao tomb obun el wil bor tangar ubi bao bi hakol bi ora men aolisaol, obun lab lab samo hasao o baeben di haek bi ora nar el non bi men aolisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ngo tomb mbinim hindismil, aol is kab mend Njises daol angal kakl hasmil hindismi tomb Moses hesa Ilanja kab sisaol hindismisa. ");
INSERT INTO akh_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ngub hindismil Moses Ilanja kab mbibi Ngaoron bao aondao ora o bor bor obobur kisbin, Njisesom Njurusalem bor buklao saon di, obum pe paklbir su ngo tuwakl poklao on di kao kao bi hasmil hindismisa. ");
INSERT INTO akh_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ngub bismi o Pita di obun aol sango mbini haru hasmi nda kab di kang mend enjmor ko u paol pesmi o, wakl el ti pesmi tomb mbinim Njises di aol is kab ngo obu daol haru hasmi nda kab di, mbini bao bi nar el non bi ora hasmil hindismisa. ");
INSERT INTO akh_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ngo tomb aol o hasbi nda kab Njises ngol bao haen mbibi kab pisbi tomb Pitam ngon te nen sabokl buwabur Njises bor kakl, Aol aondao o nao enjo ngo bor bao harum sin ebe ora soklaong, naom and kang ukl teb mend ngol baomun wao. Ukl mend njen ukl mend Moseson ukl mend Ilanjan bu, ngub baeben oran baomun wao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ngo tomb Pitam angal ngon ngub bao kakl hasaol, mulaol kombaebe pae mend obobur mbini u tingi mbaesesa. Ngub u tingi mbaesaol Njiseson man pange aol is teb ndam pakl aondao ora himismisa. ");
INSERT INTO akh_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ngo tomb mulaol darukl ngo bor angal bombor mend obobur kakl, Aol ngo obu nao Isi ora hael, nim ora obu haen kowaong inim obun angal was pangoklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Angal ngo ngub kao paesao tomb hindismil, Njises obu hungum ora hasaol hindismisa. Ngub bisaol mbinim ngon te nao ke men mbabur, mbinim ngo hindismi sao penar bu tenaol mendem pangen nao kao kalismisa. ");
INSERT INTO akh_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ngo tomb ekera nan yu har ne ngo bor haklbir wakl inin pismil, tenaol andub ora harerol Njises hen mukl ibismisa. ");
INSERT INTO akh_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ngub ibismil tenaol aondao ngo ibismi darukl o bor aol bombor mend obobur Njises bor kao deb deb bubur kakl, Aol aondao o nim nje bor kao njurukl ngao, ninao nas is bombor ngo ora yaong njem nao isi ngo hend kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ngub kobur kakl, Nas ngon tombao bor sam bombor mend bereyao om nas ngo men hakol ora biyaol, obum penar bu kaong aondao bu ora laoraoklao. Ngo tomb nas ngo sul khorob ora dur ko komb hakl po win keyao tomb nas ngo obun ne bor howar maeke hakl lao kobeyaraoklao. Heneng ora nas ngo obu khorob ora tenda mao homaraklaol, sam ngom nas ngo penar bu nao tuwaeb se ora yao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ngub was bu haraoklaol, nim njen man pange aol baeben bor aondao bu ora kao deb deb bubur, sam ngo taol deraklaob kowao o, mbinim taol derakl buwarim kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ngub kisaol Njisesom angal ngon ko san lubur mbini bor kakl, Ini tenaol ngo hayem baeben o, inim Ngaorol hul nao hae haroklmel inin kone bor di kho ora hayem kisesa. Ngub kobur kakl, Ini daol nao maomunu was haemao tomb inim nao hibi kho was mao sa hayem ngao, inim nao kone bor ngub kho mao sa hareklemin ko ni ini daol hor asub baeben ora bao haklmao balem? kisesa. Ngub kobur aol nda bor njen isi abo mini ib kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ngo tomb nas obun tombao bor sam biri nda ubukl birisaol, sam ngo nason tombao bor birisao ndam khorob ora dur mao ka sul komb hakl po win kisesa. Ngub bisao o Njisesom nas ngon tombao bor sam ngo birisao o taolu lu taol dera, nas ngo wakl ebe mao sabur obun ab kaom kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ngub bisaol tenaol ngo hasmi baebenom Ngaoron burim ngo bisao sao hondobur mbinim burir aondao ora bismisa. Ngo tomb mbinim Njisesom hambun sao ngo bisao on was burir biyu nen sab ha bao wismil, Njisesom obun man pange aol baeben bor kakl, ");
INSERT INTO akh_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Nim ini bor angal ngo kao njun ub inin hal ora bor pen pangoklwaebe kisesa. Mabor sao aol mendborom Aolon Isi Ora karu lubur, obu lukl buklemi aol baeben bor men pae puklub ko kaloklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ngub kisao o mbinim angal ngo ngub puwi pen leb ko pangokl buwaesmil, angal ngon te di nen sabokl buwabur njem angal ngon te asub nen sabobur kal ko, obu bor wakl ne di nao mi pakl homobur bao waesmisa. ");
INSERT INTO akh_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ngo tomb Njiseson man pange aol baebenom mbini hakl hakl aol aondao imbi wi nje haklesi ni haklwao kao kao bubur arer bu ab saond bismisa. ");
INSERT INTO akh_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ngo tomb Njisesom mbini hakl hakl ngo kismi sao mbinin kone bor hondobur kisaon, obum nongnas kang mend mini obobur obu hasao teb sol obo mao hasesa. ");
INSERT INTO akh_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ngub mao habur obum mbini bor kakl, Tenaol mondom ni hem kobur nongnas kang ngubil kone u hem ko bisur ba sin, obum ni ora hem ko kone ubur buklao. Obum heneng ora ni bor hem ko kone ubur oborob ba sin, obum ni pu kisao o nao Ab bor ora hem ko kone ubur buklao kisesa. Ngub kobur kakl, Ini ngo hayem haklon is mondom obu imbi nao wi kang ora men koro haraoklao sin, obu imbi wi aondao ora hayao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ngo tomb Njonom Njises bor kakl, Aol aondao o, aol mondom njen imbi kobur tenaolon tombao bor sam bereyao o taol dera harekle sal hondomao kisesa. Wakl kakl, Naom ngub hondobur aol ngo obu daol nao haru nao haroklmao ndal, naom obu bor njem ngo bili ub nao bibi ora komao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ngub kisaol Njisesom obu bor kakl, Inim obu bor njem ngub nao bibi ko ngo kaemi ub nao lowaebe ora kisesa. Mondom ini saond nao bu nja sin inin sem ora soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ngo tomb Ngaorom Njises wakl yu heben bor men muklao o teb sisaol, Njisesom obu su Njurusalem pen pon ko nen sabobur poklbur pisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ngo tomb Njisesom obun man pange aol mendbor ini mbes su Sameriya puklub kobur kakl, Ni daol nao su ngo bor paolukl oboklmaong, inim su ngo bor nao paoluklmao on man man bi urukl puklub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ngub kisaol mbinim ngub bismi o aol su ngol hasmi baebenom Njises obu su Njurusalem poklbur pebe ko ora hindismil, obu makl homobur naon anda bor nao menda u paoluklmao ko nen sabismisa. ");
INSERT INTO akh_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ngo tomb Njiseson man pange aol Njon Njemus kabom mbinim ngo kismi sao pangobur mbibim Njises bor kakl, Aorao Aondao o, naom yu heben bor isaolao eben kobur, tenaol ngo baeben hambun dao pelen kem be? kisbisa. ");
INSERT INTO akh_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ngub kisbi o Njisesom mbibi kab baol munu hondobur taolu lisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ngo tomb mbini hambun and te tangar mende bor paokl pismisa. ");
INSERT INTO akh_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ngo tomb mbini harerol pukl hasmil aol mondom Njises bor kakl, Su nje poklesi baeben hambun bor di nim nje taol hakol was bubur, nje haru akol was buklwao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ngub kisaol Njisesom obu bor kakl, Buklhoma ker baebenom su sowal tomb pae bor paoloklme. Sao baebenom di and bu paoloklme kisesa. Mbinim ngub bimi o Aolon Isi Ora obu haraoklao su mend nao wiyaong, njem heneng ora ni turi homo taol mi akol was buklesi be? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ngub kobur obum aol tangar mende bor kakl, Njem ni taol mi ebebe kisesa. Ngub kisaol aol ndam obu bor kakl, Aol aondao o nim di nje taol mi oboklwao o, nao ab mbes homoklao tomb maol bu mbaklbir oboklwaong, njem menjao nen nao sobaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ngub kisaol Njisesom obu bor kakl, Inj ora. Mbinin kone bor pe pae non bi haroklme baebenom tenaol pe pae ebe maol bukleming, njem Ngaorom maeb ha maomb bo hayao ub tenaol hambunom pangen kao kalokl pu kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ngo tomb aol mendem di Njises bor kakl, Aol aondao o nim di nje taol mi oboklwao o, nao sem baeben bor mbes bao boroklwaebe ko ki siken bukl pon ub njem menjao nen nao sobaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ngub kisaol Njisesom obu bor kakl, Tenaol mondom obum mendel poklbur kone kab maru mesao nan hondo baol baol kao hae pa sin, Ngaorom ngubi baeben turi nao homoklaol obum maeb ha maomb bo hayao bor ubuklub nao lao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ngo tomb mabor Aorao Aondaom aol dowapu hakl hakl hor teb sablo haen kobur, obum mbini mbes pen koklbur is kab was pu pu bib kisesa. Obum ngub bubur kisaon su and lobokl lobokl baeben di, su kang kang baeben bor di, mabor su obu poklao baeben hambun bor puklub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ngub puklub kobur Njisesom mbini bor kakl, Aoraon em bor ne andub ora bo do kimb be o, kongon bimi aol em il ngo baeben talaeb se aol andub ora nao hayem ngao, Em Aoraom aol mendbor obun em il ngo talo maemb kokl eben ken ub inim obu bor kao kal ha was haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ngo tomb ini puklub kobur kakl, Pangeklem. Nim ini some sib hondbao non bi buklhoma aondao deran ker sem hae bor ora puklub kakl ngao, hondo ora haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ngub bing inim inin mone di nu di aongao su di ngo sao hakl nao mari puklwaebe ora kisesa. Inim tenaol harerol hen muklemi baeben bor di angal kowar mib bu nao hae paokl ora puklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Inim and bombor menden hondaklemi tomb inim ngub lowaebe. Ini tenaol and ngon buruklemi baeben Ngaorom inin kone bor sub tibaen as ko bereklemin lao ko kao kaloklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Inim ngub buklemi tomb and ngon aorao obun kone bor sub tibaen haraoklao mondom inim ngo lemi ub turi homa sin, Ngaorom obun kone bor heneng ora sub tibaen as ko birin lao ora. Ngub inj, aol kone ngubi wi mend nao harob sin, inim obu bor ngo lemi ub obun kone bor nao hondaklaol obum ini turi nao homa sin, inim obu bor ngo lemi ub wakl kar maonaoklbir inin kone bor hondaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ngub kobur kakl, Inim ngo buklemi ub sokl mib se kongon bukleming, mbinim ini ne noklme sao di ib di njuklemi ub noklwaebe ora kisesa. Wakl kakl, Inim and ukl bombor ngo haklemi on was bao habur, inim ko mend and menden paol was nao bibaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Njisesom wakl kakl, Inim su and te mendel po pindib paklemi tomb mbinim ini oborob obaeming ubuklub kaem sin, ne di mbini ngo baebenom taol bu njuklemi o was noklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Inim ngub bubur lemin, su ngo bor tenaol sen ha uklemi baeben di mao ebe sabur, inim tenaol hambunom pangen Ngaorom ngubi tomb ini hayem ol di maeb ha maomb bo haraokl ko kao kaloklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ngub bubur inim su and lobokl lobokl mendel hondaklemi tomb mbinim ini oborob obaeming mbin ubuklub ko mbinin anda bor nao u paolaem sin, inim su and te ngon harerol pobobur mbini bor ngub lowaebe. ");
INSERT INTO akh_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Inin su ngo pange naon aongao su bor huni paranao o naom ha taokl nao poklmaol, inim ke hondoklemi ub menger wakl ini hayem ol ngo taondoklo tu men saraoklaom ong, inim Ngaorom nao maeb ha maomb bo haklbur bene o bene ko nen saboklwaebe lowaebe ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ngub kobur kakl, Nim ini bor heneng ora kao njurukl. Mabor Ngaorom tenaol hambun taol buklao bao o pindib paklao tomb su ngo bor ke aondao ora hondoklemi om, su Sorom tenaolom mbes ke aondao ora hindismi ub men mbae ora soklao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Njisesom kakl, Ini su Korasin tenaol o hakl o, ini ke aondao ora hondoklbur hayem. Ini Bersara tenaol baeben o, ini di ke aondao ora hondoklbur hayem alem. Nim inin su bor tenaolom ko mend nao hindismi sao di burir biklme sao di ngo bu haruklu nda ub su Taya hesa Siron kab bor bukl pokl buwaon, su Taya tenaol hesa Siron tenaol baeben kabom mbinim penar bu ora tenaol dimb men aolu lab lab kho samo, mbinim timbaol tel burubur kone baol munukl bismi o, inin kone nao baol meneyem kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ngub kobur kakl, Mabor Ngaorom tenaol hambun taol buklao tomb ini ke aondao ora hondoklemi om, su Taya hesa Siron kab bor ke hondoklemi ub di men mbaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Njisesom ngub kobur kakl, Ini su Kabenam tenaol baeben o, naon mbib yu heben bor poklmao ko nen sabeyem be? Pangeklem. Ini sakl paolaokl paolaokl is de ke hondokl puklmi on ora poklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ngo tomb Njisesom obun man pange aol baeben bor kakl, Tenaol mendborom inin angal hul nao hae pangaem sin, mbinim ninao angal ora pangoklemi. Ngub inj, tenaol mendborom inin angal nao pangebur ini mesao nju besao kon waem sin, mbinim ni bor ora buklemi o ni bor di inj, ni obon kisao o bor ora buklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ngo tomb Njiseson man pange aol dowapu hakl hakl hor teb nda mbinim Njises hasaol wakl obobur, Ngaorom mbini bisur bisao nda ub nen sabobur turi homo werek aondao bu ora bismisa. Ngub turi homobur mbinim Njises bor kakl, Aorao Aondao o, naom njen imbi kobur tenaolon tombao bor sam birisao o taol deraesmao tomb, sam baebenom di naon angal hul nao hae paokl ora paem kismisa. ");
INSERT INTO akh_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ngub kismil Njisesom mbini bor kakl, E ka. Yu saohar bor bubiyab penar bu biyao nda ub Seran obu saokl khorob ora u paokl bisaol, nim hondowao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ngub kobur kakl, Pangeklem. Nim ini nao buri taol bu njundisol, inim suklumb di wangallae di hambun sao Seranom ini bor saond bu njin lao sao baeben inim hala bowes bubur ebe men mbaklemil, ini menjao mondom ke nao mao handaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Njisesom wakl kakl, Heneng ora inim ngub bib se ora hayem o, inim tenaolon tombao bor sam bereyao haklom di naon angal hul nao haraokl ko nen sabobur turi nao homoklwaebe. Ngub inj, Ngaorom ini sablo haen kobur, obum inin imbi yu heben bor waeb bu wiyao ub nen sabobur ora turi homo haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ngo tomb Ngaoron Wesao Komb Bi ora ndam Njiseson kone bor turi aondao bu ora mao homaesaol, Njisesom kakl, Ab Aondao o, nje yu heben hesa su ngo kabon Aorao Aondao ora habur, njem hambun sao ngo bu harili ub kone kikil bi sukul ko hambun sao pange baebenom henden muwalo pangokl di nao pangen kebur, sukul nao ke baebenom was henden muwalelel, nim njen kone wirili ub ngo bel o kobur, Ab o nje bor tengiyu aondao ora ko hae kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Obum wakl kakl, Nao Abom nim hambun sao bu han kisaol, tenaol hambunom Aoraon Isi nao hendeyem o, Aoraom was obun Isi hendeyao. Mende di tenaol hambunom Isin Aorao nao hendeyem o, Isi obum was obun Aorao hondobur, Isim tenaol mendbor obun Aorao henden muwaloklao baebenom was hendeme kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Ngo tomb Njisesom obun man pange aol baeben baol munu hondobur mbini bor wakl kakl, Pangeklem. Mbes Ngaoron man mini aol hasmi baebenom di, aol wesmbao aondao hasmi baebenom di, inim ngubi tomb ngo hendeyem ub haondaomun sa ko nen sabismi o nao hindismi ora. Inim ngubi tomb angal ngo pangeyem ub di naom pangaomun sa ko nen sabismi o mbinim nao pangisming, inim ngo sao baeben hambun sao ora hendeyem ngao, inim turi aondao bu ora homoklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ngo tomb Nju semon man buwaloklao aol mondom Njises hasaol obobur obu maobowaklwao ko nen sabo ne mubur kakl, Aol aondao o, nim haeben ora saklbur asub ora buklwaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ngub kisaol Njisesom aol nda bor kakl, Ngaoron mbuk waeb bor asub was wiyao? Njem asao was hendeleb? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ngub kisaol obum Njiseson angal ngon ko san lubur kakl, Njem njen Aorao Aondao Ngaor turi aondao ora homobur lesin, njen hibim di njen wesaom di njen burim di njen konem di, njen Aorao Ngaorol turi homo kone ubur lesin, njem njen mbib was nen sabo hem kale ub njem njen tenaol sango mende di hem kobur hond homo kone wibi ora ke wiyaol hendeyo kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ngub kisaol Njisesom aol nda bor kakl, Heneng ora njem nao angal ngon san oborob ora liril ngao, njem ngo kal ub bae sin nje haeben soklesi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Njisesom ngub kisao o Nju semon man buwaloklao aol ngom tenaol ngo hasmi baebenom obum oborob le ken ko nen saben ko, obun mbib mu nu sabor sao bubur Njises bor kakl, Njem nao tenaol sango mend ngo hond homaebe kal o aeb? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ngub kisaol Njisesom angal mar ko obun angal ngon ngub ko san lisesa. Aol is mend obu Njurusalem haklbir Njeriko poklbur pisesa. Ngub pisaol aol el kaol kaol ko paes noklme aol mendborom aol ngo obun lab lab di obun osisao marisao hakl kur mubur, khorob ora lu u mbakl pismil peyakl birisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ngo tomb Nju semon baolum aol is mend harer ngon pisaol, aol ngo lu u mbakl pismi nda hindisao o obum nao hende non bibir, el kosaom haondaokl haondaokl harer solo mende nan paokl pisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ngo tomb aol ngo lu u mbakl pismi o obun sem was Libae* sem is mend di harer ngon obobur, aol li pae nda hindisao o obum di nao hende non bibir harer solo mende nan paokl pibi hasesa. ");
INSERT INTO akh_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ngub bisbi o aol li pae ngo obun saond bi su Sameriya aol mend harer ngon pobur, aol lu u mbakl pismi nda hondobur obun kone bor aol li pae ngo hond aondao ora himisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ngub hond homobur kisaon obum aol pe pae ngo u mba hasaol teb so pobur, obum aol ngo lismi on mung wisao nda hakl bor wel hesa ib waen kab kowe beyabur, sub tanga mba peb pisesa. Ngub bubur kisaon obum aol nda obun some dongin mesaol mao wabur, and tenaol harer pebem dob bu paolaokl en aeben bu hasmi mend hasao on mari po u paolisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ngub bubur kisaon ekera nan bao bisao tomb Sameriya aol ndam and dob bu paolaokl en aeben bimi ngon aorao mone pao kab mend kalobur kakl, Njem aol ngo oborob ora maeb ha sen minibi. Njen mone mendbor aol ngol pond ba sin, nim wakl oboklwao tomb njen mone ngon san luklwao kisao ko Njisesom Nju semon man buwaloklao aol nda bor angal mar ngub kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ngub kobur kakl, Njem asub nen sobal? Aol el kaol kaol ke mendborom aol ngo lu u mbakl pismi harer ndan aol is teb ngo ngub pisming, aol is teb ngon is mend, aol li pae ngon aol sango oran awo ora sise saol ko pangal? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ngub kisaol Nju semon man buwaloklao aol ndam kakl, Aol li pae ngo hond homobur bisur bisao o kisesa. Ngub kisaol Njisesom aol nda bor kakl, Njen anda pu, njem di obum ngo bise saol ub bibi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ngo tomb Njises di obun man pange baeben di mbini haru pismil, Njises obu su and te mendel pindib paesao tomb su ngo bor ten is mend obun imbi Mata ke mend birisao om obun anda bor Njises kemi pisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ngo tomb Mata obun haeki is mend obun imbi Mariya birisaol, ten Mariya ngom obobur kisaon obum Aorao Aondao Njiseson aongao ma teb so bor sul obo burubur, obum angal ebe ngo kisao o pango birisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ngub bisao o Mata obum ne noklemi on man man bu obum kongon buri ora bubur, obun kone bor tangar tangar sao bor mi pen was kongon bi ubur kisaon, obum Njises hasaol obobur kakl, Aorao Aondao o, nao haeki ngom ni hungum kongon bi un paokl obonaol, ni hungum kongon buri ora bubur ne man man be o, njem di ngub nen nao sobae be? Njem obu bor ni bisur bu ne kongon bukl pu kao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ngub kisao o Aorao Aondaom obun angal ngon ko san lubur kakl, Mata o, njem njen kone bor dekel dekel andub ora bilil, njem hambun sao nen sabo kang sao aondao sao bin barale kisesa. ");
INSERT INTO akh_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ngub kobur kakl, Njem ngub bili o, hobao sao mend Mariyam ngo me on njem hem nao kale o, obum hobao sao ngo me ub obun kone bor mondom nao kur muklao ora ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ngo tomb Njises obu su mendel Ngaor bor kao kalakl hasao o, kao kal paesao tomb mabor sao obun man pange aol mondom obu bor kakl, Aorao Aondao o, mbes Njon Mbabtas Biyao Aolom obun man pange tenaol baeben bor kao dund bisao ub, njem naom Ngaor bor kao kaloklmao saon di ngub lowaebe ko kao nji kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ngub kisaol obum mbini bor kakl, Inim Ngaor bor lemi tomb ngub lowaebe. Nao Ab o nje nao non bi inj hael ol Njen imbi baehaemen nao lomao ora. Njen mbib tenaol hambun maeb ha Maomb bo hakl ebebe. ");
INSERT INTO akh_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Njem bao hor hambunon naon ne di Taol bu nju haebe. ");
INSERT INTO akh_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tenaol mendborom nao bor khorob bimi sao Saongao nao mari tuwaroklmao nda ub Njem di naom khorob bimao sao Saongao nao mari kunaebe. Naon kone bor khorob bi lao tomb Khorob nao baomun kaebe ko Ngaor bor ngub kao kaloklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Njisesom mbini bor wakl kakl, Ini ngo haklon mondom njen aol sango mend buruklaol somna undum tuku ora pobur, njen aol sango ngo bor kakl, Nao haeme ka, njem ni palawe pao teb mend nji. ");
INSERT INTO akh_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Nao aol sango is mend su enderae bor hakl obaonao o, nim ne kang mend nao wi buruwao tomb obang nji lesi tomb ");
INSERT INTO akh_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","aol ngo andaon buruklao om njen angal ngon ko san lubur, njem ninao u paolukl bi bor ni nao mao teka ora. Pangal. Nao nongnas baeben di nao mbes tiriyao bo u paolumel, nim wakl ko mende teka nje menjao menjao nao njuklwaong, pu lao ko nen sabeyem be? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Wakl kakl, Nim oborob ora kao njun ub pangoklaob. Obum nje nao aol sango inj saol ko pangobur nao nja sin di, njem ora ko ko was kor buklesi tomb obum tekabur laon, njem nji lesi sao njuklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Njisesom wakl kakl, Nim ini bor heneng ora kao njurukl, tenaol mondom Ngaor bor nji ka sin ngo nji lao sao kaloklao. Tenaol mondom di menjao es ba sin hend waklao. Tenaol mondom di tiriyao kombael ni obon ko lu nga nga ko harob sin Ngaorom tiriyao komboklao ora. Inim Ngaor bor nji lemi tomb njuklao ora. Inim es buklemi sao di hend waklemi. Inim tiriyao kombael ni obon ko lu nga nga lemi tomb Ngaorom tiriyao komboklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Njisesom wakl kakl, Ini ngo haklon isi kang mondom ib wen non nji ka sin, obun aoraom suklumb kaloklao be? ");
INSERT INTO akh_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Obun ab bor sao hobao non nji lao tomb obum waongaelae kaloklao be? Ngub nao buklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Wakl kakl, Ini aol kone kho u haroklme haklom o, inin nongnas bor oborob ora kone kimb bu kaloklme ndal, inin Aorao yu heben hayaomon daol non tenaol mendbor obu bor nji ko kao kaloklme baeben o bor bibir ora obun Wesao Ebe Tangar nda taol bu kaloklao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ngo tomb Njisesom aol samom pondo pe mini menden tombao bor sam ngo birisao o taol deraesaol, sam ngo paokl pisao tomb aol ndam as ko angal ko birisesa. Ngub bisaol tenaol hambunom ngo bisao sao hondobur burir aondao ora bismisa. ");
INSERT INTO akh_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mbinim ngub burir biyubur mendborom kakl, Seran semon wesmbao aondao Belsebaolon burim ora, tenaolon tombao bor sam bereyao o taol dera hae kismisa. ");
INSERT INTO akh_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ngo tomb aol mendborom Njises obum heneng bib ko hondoklbur obu maobowabur kakl, Njem naom nao hendemao sao heben pange mend haondaomun bi hend dao ko kao kalismisa. ");
INSERT INTO akh_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mbinim ngub kismi o Njises obum mbinin kone hende sakl, obum mbini bor mar kobur kakl, Aol bomborom maomb bo haraoklao semom tom kab bu taol bu kobabur saond baem sin, mbinim tom bombor mao sa buri palo maomb bo haroklme ub di haongaokl berae su su uklao ora. Ngub buklaol and ukl bombor o bo kundi mbaklemi om, wakl and sango aeben o haklao baeben di lu kundi mbam aeben bubur, ora su tokl nao pe uklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Njisesom ngub kobur kakl, Inim ni bor Seran sem aondao Belsebaolon burim tenaolon tombao bor sam bereyao o taol dera hae kaemnda ub, heneng ora Seran kab kab tom kab bu taol bu kobabur saond baeb sin, mbinin maomb bo haroklme ub asub bubur oborob uklaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ngub kobur kakl, Heneng ora inim ngo keyem ub ni Seranom bisur bukl beyaol, nim tenaolon tombao bor sam bereyao o taol derakl beyon, inin sem mendborom tenaolon tombao bor sam bereyao o taol dera ngo bu haroklme nda ub aem was bisur biyaob? kisesa. Ngub kobur kakl, Inin semom di ngub taol deraroklme ndal, inim angal ngo lem o kakla ora lem ko panaem hendeyom kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Njisesom wakl kakl, Ngub inj, Ngaoron burim ni bisur biyaol nim tenaolon tombao bor sam bereyao o taol deraruklung, ngubi tomb Ngaorom ini maeb ha maomb bo haklao ub ini hayem ol teb so ebene ko pangoklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ngo tomb Njisesom wakl mar mend di kobur kakl, Aol buri ora mondom sub obun aol hul tom hesa obun anda tiriyao kombael oborob ora maeb harob sin, obun anda bor obun osisao uklao di menjao nao bi oborob ora bao uklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Wakl kakl, Ngub buklao o paes naoklao aol buri llekeb ora mend obobur laon, aol ngo obun anda paeb tiriyao kombal maeb haklao nda men mba, obun hul ha haklao sao obun sendaol ne sendaol isao nda kab di hambun kur mi poklao. Ngub bubur laon paes naoklao aol llekeb ndam and aorao obun saond bu kaloklao sao ngo baeben tenaol mende bor taol bu kaloklao ko Njisesom mar ngub kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Njisesom ngub kobur kakl, Tenaol mendbor ni taol mi nao ubuklmi baeben nao saond bi ora hayem. Aol mendbor nao some sib ni hae ol nao obo maembelen lome baebenom, heneng ora nao some sib ngo baeben lu taolu tuwa peb bu hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ngo tomb Njisesom kakl, Tenaolon tombao bor sam buruklao o taol deraklemi tomb obum su tenaol nao biri bor paokl pobur bao haklao o, obum mbes birisao ndabi mend es buwaklao tomb obum ngub lao. Nim nao mbes and waru buruwao bor wakl poklwao saol lao. ");
INSERT INTO akh_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ngub kobur laon obum tenaolon tombao mbes birisao nda bor hondokl poklaol, obu birisao nda bor mbinim oborob ora kunu bu ware haklemil hend u mbaklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ngub hend u mbaklbir laon obum aol ngo men mba khorob aondao bu ora mao baklbur, obum sam kho buri ora is haoklao mend kaomukl poklao kisesa. Ngub kaomukl pobur mbini hambun aol ngon tombao bor hondaklemil, aol ngo obu mbes khorob ora hasao ub di men mbabur, ko mende ngo tomb ora khorob aondao bu ora haklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ngo tomb Njisesom angal ngo kisao tomb tenaol andub ora hasmil, ngo hasmi darukl o bor ten is mend habur kakl, Ten ngom nje marubur nje aondu di njisaol, obum turi aondao ora homoklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ngub kisaol Njisesom kakl, Ngub inj ka. Tenaol mendbor Ngaorom bibaebe keyao sao pangobur hul nao haroklme baebenom was turi homo haklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ngo tomb tenaol andub ora obo kiril mbam mbam bismil Njisesom mbini bor kakl, Tenaol andub ora ngubi tomb sul bao hayem baebenom khorob was bu habur, mbinim ni bor naom tenaolom ko mend nao hindismao sao mend di haondaomun ub bi keyem o, nim mbini bor bombor ora di nao muwaloklwao ora. Pangeklem. Nim tenaolom ko mend nao hindismi sao mbes man mini aol Njona bor bisao sao bombor o mbinim henden muwaloklwao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ngub kobur kakl, Mbes Ngaorom bisao sao Njonam su Niniba tenaolom henden muwalisao ub, Aolon Isi Oram di tenaol ngubi tomb hayem baebenom henden muwaloklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ngub kobur kakl, Mabor Ngaorom tenaol hambun taol buklao tomb, mbes maomb bo haraoklao ten mend obun su enderae ana ora bor haklbir aol wesmbao Solomonom hambun sao oborob ora kone kikil bu hasao ub hondo pangokl ibisaomon teka habur laon, ini tenaol ngubi tomb ngo khorob was bu hayem baeben sakl mao pola, ini ngo was hayem ko bember ha peb buklao ora. Pangeklem. Ten ngom su enderae ora bor haklbir hobao sao ngo kisao ub hem ko pangokl ibisao o, Solomonom hobao sao oborob ora kone kikil bu ko hasao ub di, aol ngubi tomb ngo hae om Solomon men mbayao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ngub kobur kakl, Mabor Ngaorom tenaol hambun taol buklao tomb su Niniba tenaol baebenom di teka habur lemin, ini tenaol ngubi tomb ngo khorob was bu hayem baeben sakl mao pola, ini ngo was hayem ko bember ha peb buklemi ora. Pangeklem. Su Niniba tenaol ngo baebenom Njonam man kisao o pangobur mbinim oborob ora kone baol minismi o, aol ngubi tomb ngo hae om Njona di men mbayao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Njisesom ngub kobur kakl, Mondom laomb mao dabur wakl menjao mondom tingi mba, be bor di nao bomb pa woroklme kisesa. Ngub inj, and ngon tenaol oboklemi baebenom di henden ko mbinim to mandaem el isi oral woroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ngub kobur kakl, Njen el njen toklon laomb ora yao. Njen el ebe ora soklaol oborob ora hendae sin, njen toklo hambun bao bi ora soklao kisesa. Ngub inj, njen el di kho sa sin, njen toklo hambun bor di em hundur wi ora soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ngub kobur kakl, Inim ngub nen sabobur lemin, inin kone bor laomb non bi bao bi ora wiyao ub wakl em hundur nao win hondo ora haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Njisesom ngub kobur kakl, Njen toklo hambun bor bao ha ngabur maon nan em hundur kang mend nao wa sin, laomb henengom bao bu kimb biyao nda ub njen toklo hambun bor bao bu kimb bi ora soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ngo tomb Njiseson angal ngo kao paesao tomb Peresi aol mondom Njises bor nje nao anda bor ne nokl mbao kisesa. Ngub kisaol Njises obu and ngon hondabur ne no birisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ngo tomb mbini Nju semom bimi ub Njisesom ki was was nao li ne bao nisaol, Peresi aol ndam hondobur burir aondao ora bisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ngub bisaol Aorao Aondaom obu bor kakl, Ini Peresi baebenom kab hesa peler kab dera nan oborob ora wes wes loroklme o, inin kone ndaon bor tenaol menden osisao maobala mu khorob bimi sao bao winbur hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ini kon nao wi mbaoli tumu mari non bi o hakl o, Ngaorom menjao menjao dera nan warisao tomb moklo ndaon bor di nao warisao be? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ngub kobur kakl, Inim inin kab peler ndaon bor birin lemi sao baeben tenaol menjao nao wi buruklemi baeben bisur bu kaloklwaebe. Inim ngub buklemi tomb inin kab peler di inin kone ndaon bor di hambun sao dol nao hae ebe kun pele ora uklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Njisesom wakl kakl, Ini Peresi sem o, ini ke aondao ora hondoklbur hayem. Inim eb sembi non bi semon di ne noklme sao nao hobao sao baeben hambunon tobon kab nan o Ngaor bor was kaloklme o, inim tenaol hambun bor di kone bombor ub u oborob was nao bibur lomen, Ngaorol di oborob kone nao wibur bu haroklme. Ngub inj, inim Ngaoron man wiyao ub ne noklme sao hambun sao tobon kab nan o Ngaor bor kaloklwaebe ke wiyaol inim ngub ebe beyem o, nim hobao sao ora ngo kaklo di nao tuwaklwaebe buklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Njisesom wakl kakl, Ini Peresi sem o hakl o, inin man pangoklme anda bor tenaol hambunon el so panda tukun ebe ol was turi homo burukl ndao pubuklmi. Inim ngub bubur tenaol hambun obo kiril mba boroklme su o bor, ebekone po ini bor kaoya ken ko, inim tenaol hambunon el sol turi homo ki siken bukl aondao pubuklmil, ini ngo baeben ke aondao ora hondoklbur hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ini Peresi sem ngo baeben oran unu su ndaon bor aol maol mupango haenbur tenaolom yu mandaemol pobo hae non bi hayem ol, inim ke aondao ora hondoklbur hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ngo tomb Nju semon man buwaloklao aol is mondom Njisesom angal ngo kisao on ko san lubur kakl, Aol aondao o njem ngub kal tomb njem nao man buwaloklmao aol baeben bor di angal kho ngo kal o kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ngub kisaol Njisesom kakl, Ini Nju semon man buwaloklme aol o hakl o, ini di ke aondao ora hondoklbur hayem. Inim inin tenaol baeben kend bi sao aondao ora mao taroklmel, mbinim kongon buri ora bubur toroklme o, inim mbini ki honde hond bomborom di kend bi sao ngo teme o kang mend menya bisur nao bimi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ngub kobur kakl, Mbes inin ab sumb wil baebenom Ngaoron man mini aol baeben di pe paen lismil, inim man mini aol ngo baeben hem keyaol beyom kobur, mbinin maol bor kundiyakl manakl bu wakl was bu hayem o, ini ke aondao ora hondoklbur hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ngub kobur kakl, Mbes inin ab sumb wilom man mini aol ngo baeben di pe paen lu tuwaesmil, inim mbinin maol bor kundiyakl menakl bu wakl was ngo bu hayem saom, inin ab sumb wil baebenom ngo bismi ub inim turi homo, mbinim oborob ora bu hasmi kobur beyem ko panaem ora muwaleyao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Njisesom wakl kakl, Inim di inin ab sumb wil baebenom ngo bimi ub was bimil, Ngaor obu hambun sao oborob ora pange sakl, obum mbes ngub kisao. Nim nao man mini aol baeben hesa nao man pange aol baeben kab bor mbini buruklemil man kam puklub lowaol, mbinim ngo baeben lu taolu bowes bu mendbor di pe paen luklemi kisao ko Njisesom Peresi aol ngo baeben kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ngub kobur kakl, Pangeklem. Ngaorom pibnao tenaol warisao tomb di ngubi tomb di mendborom obun man mini aol baeben lu tuwaesmil, ini ngubi tomb hayem baeben mbinin poklon ndabur ke hondoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Njisesom wakl kakl, Nim ini bor heneng ora kao njurukl, mbes aol Ebel hasao o pe paen lismil, Ngaoron man mini aol ngubi baeben ngub homam obam obam bubur, wakl aol Sekaraya hasao o di obu Ngaoron mabaorao haoroklme to hesa Ngaoron panda komb bi ora kabon tukun bor pe paen lismil, ini ngubi tomb hayem baeben mbini ngo baeben hambunon poklon ndabur ke aondao ora hondoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Njisesom ngub kobur kakl, Ini Nju semon man buwaloklme aol o hakl o, ini ke aondao ora hondoklbur hayem. Inim hobao sao pangokl puklmi hareron tiriyao ki maru haroklme o, inin mbib turi homo tiriyao kombo nao hondaebur lomen, inim mbini tenaol tangar mendbor hondaklbur bimi baeben di nao hondaen ko pela woroklme ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Njisesom ngub kao peyaoklbir kisaon and ngon baoraoklbir dera pisao tomb Nju semon man buwaloklme aol baeben di Peresi sem di mbinim Njises ko aondao bu homobur kismin, mbinim obu bor ab saond bu kalo andub sao ne mismisa. ");
INSERT INTO akh_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ngub bubur kismin mbinim obu bor te mao sara howes kaeb se kang mend khorob sao oran mend leb ko, mbinim obu maomb bo hondo hasmisa. ");
INSERT INTO akh_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ngo tomb su mendel tenaol andub ora buklhoma iri non bi dengeb dengeb kobur, tenaol menden aongao ma bor pe hala hala bismisa. Ngub bismi tomb Njisesom obun man pange aol baeben bor mbes kao kalobur kakl, Peresi semom palawe and mao saraoklao sao yis menger, mbinin kone bor wiyao ub inim di songolol man mini non bu haklemi hondoklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ngub kobur kakl, Hambun sao tenaolom kowes bubur buklemi sao baeben mabor tenaol hambunom hondoklemi ora. Hambun sao sub hala mba uklao sao baeben di mabor perekle pa uklaol, tenaol hambunom ora hondoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ngub buklaol inim angal hambun sao somna sub lome sao baeben di hora tenaol hambunom pangen lemi. Inim angal hambun sao sub ora andaon bor kao towem kobur lome sao baeben di, wakl mbinim and hom kemol habur tenaol hambunom pangen kaoya lemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ngo tomb Njisesom nao tenaol sango hakl o, nim ini bor angal kang mend kao njun kobur kakl, Aol mendbor tenaol sango pe paen lib se haklemi baebenom mabor mbinim menjao bukl buwakleming, inim mbini pakl nao homoklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Wakl kakl, Ngub inj, nim heneng ora inim aol pakl homoklemi o ini muwalon kobur kakl, Ngaor obu tenaol khorob bimi baeben pe paen lib se aol ora habur, mabor obum tenaol mendbor ke mao handaklao is de ora bor pen lao aol o hayao kisesa. Ngub kobur kakl, Nim ini bor ngo kao njurukl ub obu ngubi ora hayaong, inim obu bombor o ora pakl homoklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Njisesom wakl kakl, Inim di ora hendeyem. Tenaolom sao kang is su maomunu mone hundbi kang hond kabom sokl bib se ngubi baeben di Ngaorom aokl nao hemen hae ndi men pae ora yao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ngub kobur kakl, obum inin wesmbao iri baeben di ndi men payaong, sao nao hobao sao kang kang mone hundbim sokl bib se ngubi hakl ndi menekle om ini daol bibir ndi meneyaol, ini di is mend nao baondib munuklaong pakl nao homoklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ngo tomb Njisesom kakl, Nim ini bor heneng ora kao njurukl, aol mondom ni Karas sem hae ko tenaol hambunom pangen kao parob sin, Aolon Isi Ora obum di aol ngo obu nao sem ora hae ko, Ngaoron angal mini wesao baebenon el sol kao paklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Wakl kakl, Ngub inj, aol mondom tenaol hambunon el sol ni nao hende non bu mesao njubur besao kon wa sin, nim aol ngo obu di Ngaoron angal mini wesao baebenon el sol nao hende non bu mesao kaloklwao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Njisesom ngub kobur kakl, Mondom Aolon Isi Ora bor hel hondo maobowa angal ba sin, obun kone bor kho ngo wiyao ub di kunaeb se hayao o, mondom Ngaoron Wesao Ebe Tangar ora bor maobowa angal ba sin, obun kone bor kho ngo uklao o nao kunaklaol wi aeben soklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Njisesom wakl kakl, Ini mbinin man pangoklme anda bor mini pobur mbini ngo baebenom man tangar keyem ko te mao saraklemi tomb di, kabman hesa maomb bo haroklme aol baeben kabon el sol mao haklemi tomb di, nim mbini bor angal asub ora ko san luklwaob ko nen sabo, angal asao ora kon kobur pakl nao homoklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ngub kobur kakl, Bombor ngo ora tomb Wesao Ebe Komb Bi ora ndam inim angal ngon ngub ko san lib ko kao njuklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ngo tomb tenaol andub ora ngo hasmi on is mondom Njises bor kakl, Aol aondao o, njem nao haeme kao kalobur yaon abon osisao baeben taol bu kobabur, tom mende ni njin ub ni kal kao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ngub kisaol Njisesom kakl, Aol o ka, asub ko kal? Ni aebom ibi taol biyao aol mao ha, ibin osisao taol baraoklao aol mao hasaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Obum ngub kobur mbini hambun bor wakl kakl, Inim osisaol was kone u heb homo hae soklaong, inim oborob hondo ora haklwaebe kisesa. Wakl kakl, Aol mondom obun osisao andub ora maru u haroklao tomb obun osisao ngom obu oborob mao haraoklao sao inj yaol, obu haeben nao mao saklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ngo tomb obum mbini bor angal mar bombor mend di kao kalobur kakl, Aol obum osisao andub ora maru u haklao menden em bor ne andub ora and soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ngub kobur kakl, Aol osisao andub ora maru u haklao ngom obun kone bor nen sabobur, is, ngubi tomb nao em bor ne andub ora and seng, nao ne ngo baeben maru wib se nao and aondao mend nao haeng, nim ngubi tomb asub ora bun yeb ko nen sab sab buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Obum ngub nen sabobur ngub lao. Nao and ne u no baraklo mbes pange kang ngo baeben kundi tuwabur lowaon, nim and aondao aondao was bubur, nao ne baeben di nao osisao hambun sao ebe ebe sao baeben and ngo baeben on was uklwao. ");
INSERT INTO akh_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ngub bubur nao umu bor ngub lowao. Umu o aol hobao nje. Njen hambun sao ebe sao was andub ora wi ol, karasmas andub ora pond nao bi ebe soklaong, njem kongon di nao bi, hor so ne di ib di ngo sao hakl nao pa peb bu, turi was homo ber lowao lao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ngo tomb Ngaorom aol ngo bor ngub lao. Nje kon nao wi mbaoli tumu mari non bi hael ngao, embi somna was nje pe paklesi tomb njen osisao ngo man man bu wil baeben aem muklaob? lao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Njisesom angal mar ngon kao kowes bubur kakl, Aol osisao andub ora maru u haroklme baebenon mendbor aol ngom kone ngo wise ubi u haklemi baeben bor, aol ngo obu bor ngo bise ub was buklaol, mbini ngubi baeben Ngaorom hendeyao tomb dimb ora hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ngo tomb Njisesom obun man pange baeben bor kakl, Ngubi tomb nim ini bor kao njanda ub inin mbib haklemi on nen sabobur naom ne asao was noklmao? Naon samoklme sao di asao was samoklmaob ko inin kone bor kang sao aondao sao bin buru kho nao sen boroklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Njisesom ngub kobur kakl, Ngaorom inim ne was neklemin ko nao mao hasao. Obum inim samoklme sao was sameklemin ko inin toklo di nao warisao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Wakl kakl, Inim sao semom bimi ub nen saboklwaebe. Mbinim ne noklme sao is il we nao boklme, mbinim ne noklemi o di nao maru woroklme kisesa. Ngub kobur kakl, Sao ngo baebenom mbinin and ne ukl bi di mbinin osisao ukl bi and di nao bimi o, Ngaorom ora mbini taol bu kalaoklaong, sao nao hobao sao hakl ne taol bu kalekle om, ini tenaol hobao sao ora hayem o daol bibir ora taol bu njuklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Njisesom kakl, Mondom obun kone kimb bubur mendborom penar bu homoklme ub nao heme, ni ngo tomb homoklwao ko ndi tibakl buwaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Wakl kakl, Inim kang kang ngubi sao haklon menjao bukl buwaeb se ora harim sin, inim asub ko tangar saon was nen aondao bu ora sab hakol bu, inin kone bor kang sao aondao sao bin buruklemib? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ngub kobur kakl, Inim is humb il ki kao ko saoklao nda ub nen sabaoklaob. Is ngo baebenom kongon di menjao nao bimi. Mbinim lab lab kongon di nao bimi o nim ini kao njun ub pangoklaob. Mbes Solomon obu aol homa aondao ora habur, obun lab lab di obun osisao hambun sao di buklhoma iri non bi maru u hasao o, is humb il ki kao ko soklao ndam aol Solomon ngon yaor ngo bu hasao ub men mbaraoklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Wakl kakl, Em hinin den kang kang nao hobao sao mend haraoklao ndisao haklon daol Ngaorom oborob sor mubur yaor baraoklao o, ekera nan mondom den ngo bo den haoreyao tomb bao dao peklao ora. Ngub biyao o den nao hobao sao ngo hakl yaor mao barekle om, obum ini daol bibir maeb ha inim samoklemi sao di taol bu njuklaong, inim asub ko obul hul nao hae hayem? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Wakl kakl, Pangeklem. Naom ne asao was noklmao? Ib di asao was noklmaob ko inin kone bor kang sao aondao sao bin buru hem nao lowaebe ora. ");
INSERT INTO akh_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Hambun sao ngo sao hakl mbini sun tenaol baebenom was asub buklmaob ko nen sabo hem kaeb se hayem. Ngub bimi o ini non inin Ab Ngaorom inim asao was wa win hayem ko ora hendeyao. ");
INSERT INTO akh_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ngub beyaong inim tangar tangar sao ngo wa win habur hem lemi sao hakl di obum ebe taol bu njuklaong, inim Ngaor obum maeb ha maomb bo hayao bor ora poklbur hem ko es bu haklwaebe ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ngo tomb Njisesom obun man pange baeben bor kakl, Ini some sib non bi sem kang o hakl o, inin Aoraom obum maeb ha maomb bo haraoklao ub obum ini di nao haru turi homo maomb bo haklmao ora ko man man bu hayaong, inim pakl pakl homo menjao nen nao saboklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ngub kobur kakl, Inin osisao baeben mone mubur lemin, tenaol mendbor mone nao wi burubur dam nao bin buruklemi baeben bisur bu kaloklwaebe kisesa. Wakl kakl, Inim ngub buklemi tomb inin mone bawis ebe wi aeben ora saeb se di, inin osisao hambun sao ebe ngubi baeben yu heben ngo inin menjao menjao nao bum haeb se ol ora maru wi non bu haklemi kisesa. Heben ngo bor paes noklme aol di nao hayao. Aoll horom di nao noklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Njisesom wakl kakl, Inin sul ebe sao was mondom ini hibi lao mib biyao ndisao baebenol was kone u harim sin, inin kone di ngol bao uklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Njisesom ngub kobur kakl, Inim bao ngon ngo sao buklao ko nao hende bereyem ngao, inin lab lab samo hak ya di munu kere mba samobur, inin laomb hakl kena u man man bu ora boroklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ngo tomb obum mar kobur kakl, Kongon bimi aol baebenom mbinin aorao ngo obum su enderae ora bor ne haraklemi o no haklbir oboklao ko hondo haroklme ub, inim di ngub oborob hend ha ora haklwaebe. Mbinin aorao aondao ngom obobur obun kongon bimi aol ngo baeben bor ni obon ko tiriyaol lu nga nga lao tomb mbinim penar bu ora tiriyao komboklemi. ");
INSERT INTO akh_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ngub buklemil aol ngom kongon bimi aol ngo baebenom u nao paol pele ngub man man bu ora haklemil hondoklao tomb, mbini kongon bimi aol ngo baebenom turi aondao ora homoklemi kisesa. Wakl kakl, Nim ini bor heneng ora kao njurukl, aol aondao ngo obum obun lab lab hakl sam mbabur, mbini bor inin ne taol bu njun ub baoraoklaob kobur laon ne taol bu kaloklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Njisesom ngub kobur kakl, Aol aondao ngo obum somna undum tuku oboklao be? be? sao kulao angal mubao biyao nda bi tomb oboklao be? obum ngub obo pindib pabur hondoklao tomb obun kongon bimi aol ngo baebenom u nao paol pe wisim sin, mbinim turi aondao ora homoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ngub kobur kakl, Inim ngo sao oborob ora nen saboklwaebe. Aol and aorao baebenom bao ngon somna ora paes naoklao aolom paes nokl oboklao ko hondokl bemen, paes naoklao aol ngom mbinin anda bor tiriyao kombo paes ngub nokl eben bao wa nao bi hend ha ora hakl beme kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Wakl kakl, Aolon Isi Ora obu di bao ngon oboklao ko inim nen nao sabe ora haklemi tomb oboklao ngao, inim di oborob ora man man bu hend ha ora haklwaebe ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ngo tomb Pitam Njises bor ne mubur kakl, Aorao Aondao o njem angal mar ngo kal o, nao njen man pange aol baeben bor was kal be? be? tenaol hambun bor di nen sabobur kal kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ngub kisaol Aorao Aondaom kakl, Kongon biyao aol mondom obun kone bor oborob ora kimb bubur kongon oborob was ba sin, wakl obun aol aondaom obu bor njem nao kongon bimi aol baeben hambun maeb ha, mbini bor ne di ngo tomb was taol bu kalaebe lao ub taol bu kalo haklao kisesa. Njisesom ngub kobur kakl, Kongon biyao aol ngubi nje hael be? aol tangar kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ngub kobur kakl, Mabor kongon biyao aol ngo obun aol aondao nda obu wakl obobur hondoklao tomb, obun kongon biyao aol ndam obum mbes kao kaolaokl pisao nda ub bu harob sin, kongon biyao aol ngo obum turi aondao ora homoklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Wakl kakl, Nim ini bor heneng ora kao njurukl, aol aondao ngo obum obun hambun sao obun kongon biyao aol ngom was maeb haen lao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ngub buklao o aol aondaon kongon biyao aol ngom obun kone bor nao aol aondao penar bu nao oboklao ko nen sabobur laon, obum obu haru kongon bimi tenaol baeben lu bowes bu obum ne was na ha burubur, he soklme ib no he sakl haklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ngub kobur kakl, Obum ngub buklao tomb kongon biyao aol ngo obun maomb bo haraoklao aol aondao nda mabor ko mend handam oboklao tomb, obun kongon biyao aol ndam nao maomb bo haraoklao aol aondao oboklao ko nao hondo biri awis ora harob sin, obum ngo tomb oboklao ko nao hende haklao o obum sub obo pindib paklao kisesa. Wakl kakl, Aol aondao ndam ngub obobur laon obun kongon biyao aol ngo khorob ora ke mao handabur, tenaol mendbor obul hul nao hae haroklme baeben pen lao bor maomunu pen lao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Njisesom wakl kakl, Aol aondaon kongon bimi baebenom mbini maeb haraoklao aolon kone ora hondoklemi o mbinim mbinin kone bor man man bu, mbini maeb haraoklao aol ngom bibaebe lao ub nao baem sin, obun kongon bimi ngo baeben obum doroklom aondao bu ora luklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ngub inj, aol aondaon kongon bimi ngo baebenon mendborom mbini maeb haraoklao aolon kone nao hendebur mbini maeb haraoklao aol o kang mend ko mao homarim sin, ngon mbini doroklom kang bu sao luklao kisesa. Ngub biyaol Ngaorom aol is mend bor hambun sao andub ora taol bu kala sin, aol ngom obu bor di andub ora njuklao ko nen sabeyao. Ngaorom aol is mende bor di ora aondao bu pone haen kond ba ora taol bu kalaoklao tomb di, aol ngom di obu bor aondao bu kond ba sao buklao ko nen sabeyao. ");
INSERT INTO akh_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ngo tomb Njisesom kakl, Nim su ngo baeben hambun bor isaolao tib paklbur obowaol, isaolao ngo penar bu ngubi tomb ora do pindib pakl baonaon nim turi aondao ora homokl buwao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Wakl kakl, Ni mbabtas buklwao o kang mend wen sao buklwaol, nao bu pae bao hae aeben anga tomb nao kone bor kend aondao ora bin hae kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ngub kobur kakl, Inim nim tenaol hambun bor turi was homo taeki kokl ibisao ko nen sabeyem be? Aoh, nim ini bor oborob ora kao njun ub pangaoklaob. Nim ini tenaol hambun armend sisao was dikla kaob kaob bu bereklemin koklbur obowao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Wakl kakl, Ngubi tomb tuma pa aeben anga ol non tenaol is su mend mbini and bombor on buruklemi baebenom di wakl dikla kobabur, is kab mend is teb aolon saond bi haklebi. Is tebom di is kabon saond bi haklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Njisesom ngub kobur kakl, Mbinim ngub tuma kaob kaob bubur lemin aol baebenom mbinin nas maru wi baeben saond bu kaloklemil, nas baebenom di mbinin ab sisao saond bu kal kal buklemi. Ngo tomb ten baebenom di mbinin wane maru wi sisao saond bu kal kal buklemil, nong baebenom di mbinin am sisao saond bu kaloklemi kisesa. Ngub buklemi tomb aol menden ingim aol ngon were bor saond bu kaloklao. Ten ngo obum di ten obun esao ngo bor saond bu kaloklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ngo tomb Njisesom tenaol hambun bor di kao kalobur kakl, Inim unu nan saohar bor mulaol mend ebeyao o hondobur inim penar bu ora ngub lome. Se oboklbur be lome. Ngub keme tomb heneng ora se bao ubuklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Wakl kakl, Inim posabsu ana naon hakl ebeyao o hondobur inim ngub lome. Nar tanda bi aondao ora doklbur be lomel, heneng ora ngo di ngub biyao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ngub kobur kakl, Ini songolol ma mini non bi o hakl o, inim su ngon menger hesa saohar kabon menger oborob ora hendeyem ngao, inim ngubi tomb Ngaorom tenaol hambun bor bu hae sao asub ko oborob nao hendeyem? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ngo tomb Njisesom mbini bor wakl kakl, Inim inin mbib inin kone bor asub ko ngo sao kho ngo sao ebe e ko nen sabo taol bukl buwaroklmeb? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ngub kobur kakl, Aol mondom nje bor howes kokl mbao ka sin, wen harerol aol ngo nje bor howes kokl mbao lao hesa poklebi tomb njem obu bor oborob ora kao kao bab ko kao kalaebe. Njem ngub bab nao ke bao wabur obum nje howes kokl kemi pen bao wari sin, obum nje howes pangaoklao aol biri mini poklaol, howes pangaoklao aol ndam nje polisman munu kaloklao. Ngo tomb polismanom nje kalabus anda bor mao palaklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Njisesom wakl kakl, Nim ini bor heneng ora kao njurukl, howes pangaoklao aol ndam nje bor nji lao sao hambun sao kang ora di nao kalae sin, njem kalabus anda ngo tuwaklbir anda pokl buwaklesi ora ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ngo tomb tenaol ngo hasmi baebenom Njises bor kakl, Kalili aol mendborom Ngaor bor mabaorao haoru some sibon ibao kalismi tomb mbini ngub bismi ngo baeben Palerom bao bombor ngon pe paen lisao ko kao kalismisa. ");
INSERT INTO akh_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Kalili aol ngo pe paen lismi baeben, Kalili tenaol mendborom khorob ngo bu hayem ub men mbabur mbinim khorob aondao bu ora bu hasmil, Ngaorom ngub pe paen lin waesao ko nen sabeyem be? ");
INSERT INTO akh_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ngub inj ka. Nim ini bor heneng ora kao njurukl, inim di inin kone nao baol menaem sin, ini bor di ngo bise ub was buklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Wakl kakl, Mbes aol supun kab mend su Silaom bor and saoll mend kundi mbabur pe paen lisao baebenom, Njurusalem tenaol mendborom khorob bimi ub men mbabur mbinim khorob aondao bu ora bu hasmil, Ngaorom ngub bin kisao ko nen sabeyem be? ");
INSERT INTO akh_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aoh, nim ini bor heneng ora kao njurukl, inim inin kone nao baol menaem sin ini bor di ngub was buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ngo tomb Njisesom mbini bor angal mar bombor mend kao kalobur kakl, Aol mondom obun emol is pik il* we bobur laon mabor il seneb ko talokl oboklao o, is ndam il di nao se bao haklaol hondoklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ngub buklaol is il ngon aorao ndam obun em kongon biyao aol bor ngub lao. Nim karasmas ukl teb baeben oran nim is il ngon mend seneb ko talokl ib ha was hawao o il nao sokl bi ora seneng, baehaemen ora su ibao nao nao paen ub bo tuwaebe lao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ngub lao o em kongon biyao aol ndam ngub ko san luklao. Aol aondao o, karasmas ukl mend ngo bomboron bao haen ub nim is ngon te bor su hakl tomb bara, some kawaon i hakl aso u hum kal hondon wa. ");
INSERT INTO akh_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Aoh, nim karasmas ukl menden non is ngom il soklao ko pangakl ngao, ora il nao sokl bi sa sin njem isao bo tuwanin ora lao ko Njisesom angal mar ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ngo tomb Njises obu Nju semon hor boroklme bao on man pangoklme anda menden hondabur, tenaol hambunom pangen Ngaoron angal bib ebe ngo kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ngo tomb ten obun tombao bor sam biri is mend birisesa. Ten ngo obun tombao bor sam ngo birisao ndam obun mesao ndobol munubur anda mao beraesaol, obu karasmas supun kab oran ngub bao sen ha u hasesa. Ngub bisaol ten ngo obun mesao hul o ora karokl pae ora sisaol, obum dund so teka hakl buwaesesa. ");
INSERT INTO akh_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ngo tomb Njisesom ten nda hondo ib kobur ten ngo bor kakl, ten o nim njen sen ngo mao ebe sarukl kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ngub kobur kisaon obun kim ten nda men mbaesao tomb, ten nda bombor ngo tomb obum oborob dund so teka habur kisaon, Ngaor obu aondao ora hayao ko tengiyu ko kaoya kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ngub bisao o man pangoklme anda ngon maomb bo haraoklao aol aondao om, Njisesom Nju semon hor boroklme bao* on ten ngo obu sen ha wisao nda ub ebe mao saesaol hondobur, Njises ko aondao ora homobur obum tenaol hambun bor kakl, Inim bao hor dowan was kongon bibaebe. Inin tenaol sen ha uklemi baeben di mao ebe saen ko pangaem sin, inim kongon bimi bao on was ubuklwaebe. Inim naon hor boroklme bao o pindib paklao tomb nao ubuklwaebe ora kisea. ");
INSERT INTO akh_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ngub kisaol Aorao Aondaom obun angal ngon ko san lubur kakl, Ini songolol man mini non bi o hakl o, inin hor boroklme bao o pindib pa was beyao tomb ini hambunom inin some kawaon anda bor pobur, inin some kawao baeben di dongi baeben di ib nen ko kol bara kemi po haroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ngub bimi o ten ngo obu Eberehemon sem ora yao o obu Seranom karasmas supun kab oran men ha wisaol, nim hor boroklme bao on ten ngon toklol toben ya sao ngo kaol mba haraoklao o, ngo hesbe paru nda ub nao bibi bene ko nen sabeyem be? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ngub kisaol pangobur obu bor saond bi sao hasmi baebenom sakl khorob ora polismisa. Ngo tomb tenaol ngo hasmi baeben hambunom Njises obum hambun sao oborob was bu hasao nda ub hondobur turi aondao ora himismisa. ");
INSERT INTO akh_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ngo tomb Njisesom angal mar mend kobur kakl, Ngaorom maeb ha maomb bo hayao ub asao ora non bi yao? Nim menger asub ora muklwaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ngub kobur kakl, Ngaorom maeb ha maomb bo hayao ub is il menden imbi sowar il menger maeb ha maomb bo hayao. Aol mondom sowar il ngo obun emol we boweyao tomb por ko aondao bu ora is sao sem bubur and so hayaol, sao sem hambunom sowar ngon so kumbaem beyao bor and bu burukl engel bimi ko angal mar ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Njisesom angal mar mende kobur kakl, Nim Ngaorom maeb ha maomb bo hayao ub asao ora menger muklwaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ngub kobur kakl, Ngaorom maeb ha maomb bo haraoklao ub palawe and mao saraoklao sao yis menger maomb bo hayao. Ten mondom palawe ki teb mao ha mubur yis ngo hesa maomunu pinjaom bu hereyao tomb, yis ngom palawe nda aondao bu ora and mao saraoklao nda ub menger ora maomb bo hayao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ngo tomb Njises obu su ngol haklbir obum Njurusalem poklbur kisaon, su and te tangar tangar su aondao baeben bor di su kang baeben bor di su hambun bor Ngaoron angal bib ebe nda kao kalaokl kalaokl was pisesa, ");
INSERT INTO akh_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ngo tomb aol mondom Njises bor kakl, Aol aondao o, Ngaorom tenaol bombor bombor was bu muklao be? kisesa. Ngub kisaol Njisesom mbini bor kakl, ");
INSERT INTO akh_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Inim buri pal peyaoklbir and tiriyao dengbele kang oran hondaklwaebe kisesa. Ngub kobur kakl, Tenaol andubom ora and tiriyao kang ngon ora pon ko pangoklemi o, kang dengbele ora yaol hondakl buwaklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Njisesom wakl kakl, Mabor and aoraom teka peyobur and tiriyao ngo wakl bo mbaklao tomb, inim mabor and tiriyao ngon dera nan lu nga nga ko obo habur lemin ngub lemi. Aol aondao o, nao obaomun ub tiriyao komb lemi. Ngub lemi tomb obum inin angal ngon ko san lubur kakl, Ini abor tenaol was hayem? Nim ini nao hendeyo lao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ngub lao tomb inim obu bor ngub lemi. Nao nje daol maomunu burubur ne no ib no birisumndis. Njem naon and te teb so harerol habur, njem nao bor Ngaoron angal ebe nda kao njisndis baeben inj hayom bo? lemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Inim ngub lemi o obum wakl ini bor ngub lao. Ini abor tenaol e nim ini nao hendeyong, ini tenaol khorob bimi sem ora hayem ngao, ini ni hael nao hae puklub ora lao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Wakl kakl, Inim Eberehem di Isak di Njekob di mbini man mini aol hasmi baeben di mbini ngo baeben hambun Ngaorom maeb ha maomb bo hayao bor haklemil hondoklemi o, inim mbini haklemi bor nao pe dera nan was bao habur, inim inin saongao kengorokl no de khorob ora ko haklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Wakl kakl, Ngub buklemi tomb mbini tenaol mendbor yu nan paoloklme baeben di, unu nan paoloklme baeben di, umu nan paoloklme baeben di, ana nan paoloklme baeben di, mbini hambun Ngaorom maeb ha maomb bo haraoklao bor obo maomunu burubur ne no buruklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Njisesom wakl kakl, Heneng ora ngubi tomb tenaol mendbor kang hayem baeben mabor aondao ora haklemi. Tenaol mendbor ngubi tomb mbini aondao hayem baeben mabor kang ora haklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ngo tomb bombor ngo ora tomb Peresi aol mendbor obobur mbinim Njises bor kakl, Aol wesmbao Herorom nje lu tuwaklbur beng, nje su ngol nao hae nje su tangar mendbor pu kismisa. ");
INSERT INTO akh_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ngub kismil Njisesom mbini bor kakl, Inim ngubi tomb pobur buklhoma deran ker* ngo bor ngub lowaebe. Embi hesa ekera kab nim tenaolon tombao bor sam biri baeben taol dera, tenaol mendbor sen ha uklemi baeben mao enja ngub beng, bao hor tebon nan on nao kongon bu kowes buklwao ka ko kao kalokl puklub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ngub kobur kakl, Aoh, mbinim Ngaoron man mini aol mend su tangar bor nao luklemi o Njurusalem bor was luklemil, nim embi ekera ndum pam aeben bubur ebe poklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ngo tomb Njisesom Njurusalem tenaol hem ko hond homobur kakl, Is alem. Njurusalem tenaol o hakl o, inim Ngaoron man mini aol baeben pe paen lu, Ngaor obun man mini aol mendbor ini haemel pu kisao baeben di hanom loroklme tenaol o hakl o, nim mbes ora di hor hor was ini ngo baeben sao kulaom obun hondbao baeben obun bobao bundur bor maembe mbaen kobur men mba paolaoklao nda ub bundis o, inim turi homo nao ebe bao waesimndis kisesa. ");
INSERT INTO akh_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ngub kobur kakl, Pangeklem. Inin Ngaor Hen Moroklme Anda ngo hae o bor Ngaor obu nao haklaol baehaemen and was haklao kisesa. Wakl kakl, Nim ini bor heneng ora kao njurukl, ini ngo baebenom ni ko mende nao hondoklemi o ma ora bor inim ni bor kaoya kem kobur, Ngaorom imbi wi haen kisao aol ngo obu Aorao Aondao hayao bor hakl ebene ngao Obu bor kaoya kem ora lemi tomb inim ngo tomb ora ni ko mende hondoklemi ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ngo tomb Nju semon hor boroklme bao o pindib paesaol, bao ngon Njises obu Peresi semon maomb bo haraoklao aol menden anda bor ne nokl pisesa. Ngo tomb mbini Peresi tenaol mendborom mbinin manom nao bibi ke wiyao ub Njisesom khorob menjao bib ko hondo hasmisa. ");
INSERT INTO akh_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ngub bismi tomb aol sen hae obun toklo bombo tibae mend Njises obu birisao teb sol obo hasaol hindisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ngub obo hasaol Njisesom aol ngo hondobur, obum Nju semon man buwaloklme aol baeben di Peresi aol mendbor ni ngol birismil, Njisesom mbini hambun bor ne mubur kakl, Naon manom nao bibaebe ke wiyao nda o, naom hor boroklme bao* on tenaol sen ha uklemi o ebe mao saklmao be? inj kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ngub kisao o mbinim e beb nao ke nimil was tismil, obum aol sen hae nda kil men mubur ebe mao sabur pu kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ngub bubur Njisesom mbini bor kakl, Ini aol ngo hayem haklon mondom inin nas kang hesa inin some kawao kabon mend hor boroklme bao on har sowal bor kundukl dombabur hondaklao tomb, inim penar bu ora nao men muklemi be? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ngub kisaol mbinim angal ngon ko san lukl buwaesmisa. ");
INSERT INTO akh_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ngo tomb Njises obum hindisaol aol ngo ne nokl ibismi baeben hambunom pand tukunol was mu pa birismisa. Ngub bismil hondobur mbini bor angal mar bombor mend kao kalobur kakl, kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Aol mondom obun wane aol pen ko ne aondao mend haorubur nje bor ne ngo nokl ib kila sin, njem panda tukunol nao mu pa biribi. Njem ngub bae sin ne haoraoklao aol ngom aol aondao ora nje di men mbae mend ne ngo nokl ib laol, obum njen imbi men mbaklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ngub kobur kakl, Ne haoraoklao aol ngom aol imbi wi aondao nda hesa ibi ne nokl ubuklub laol poklebi tomb, nje panda tukun ebe ora ndal buruklesil, ne haoraoklao aol ndam nje bor aol imbi wi aondao ora ngo panda tukun abo ngo nje berel ol birin ub nje isu ngo solo nan hakl bor ber laol, njem sakl aondao ora polobur aol aondao ngon mesao nan buru uklesi ");
INSERT INTO akh_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Wakl kakl, Ngub inj, aol mondom nje ne nokl ib laol poklesi tomb njem pand tukun mbes nao mu pae sub ora pobur, solo hakl bor sao buru wibi kisesa. Njem ngub buklesi tomb ne haoraoklao aol ndam nje buruklesil obobur, nao aol sango ka, nje pand tukun ebe ngol ber lao. Obum ngub buklaol aol ngo ne nokl oboklemi baebenon el sol njen imbi aondao ora win lao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Njisesom ngub kobur kakl, Tenaol mendbor mbinin mbib ni imbi wi ebe ora hae ko kaoya lome baeben, Ngaorom mbini men mbabur imbi nao wi kang mao saklao. Ngub inj, mbini tenaol mendbor ni imbi nao win haklwao ko pangaem sin, Ngaorom mbini ngo baeben imbi wi aondao ora haen lao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ngo tomb Njisesom aol ngo ne haorisao nda bor kakl, Njen anda bor tenaol ko mend ne nokl ubuklub lesi tomb njen tenaol sango baeben di, njen aorao haeme baeben di, njen sem ora baeben di, inin tenaol sango mone andub ora maru u haroklme baeben di, mbini ngo baeben bor ne nokl ubuklub nao kaebe kisesa. Njem ngub bae sin, mabor mbinim di njen ne ngon san wakl naon anda bor ne nokl ebebe lemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Wakl kakl, Aoh, njem ne aondao ngub haoruklesi tomb tenaol dimb menjao nao wi buruklemi baeben di, mbini ki aongao tibae baeben di, tumu kho baeben di, el kho baeben di ngubi baeben bor ora ne nokl ubuklub kaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Wakl kakl, Tenaol ngubi baebenom njen ne ngon san nao lib se haklemi o, Ngaorom tenaol kone dund se u oborob was bimi o homoklemi baeben mao enjaklao bao on, obum ora njen ne ngon san lubur turi mao homaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ngo tomb Njisesom ngub kisaol aol ngo ne no birismi on bombor mondom Njises bor kakl, Tenaol mendbor Ngaorom maeb ha maomb bo hayao bor ne no buruklemi baebenom turi aondao ora homo haklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ngub kisaol Njisesom aol ngo bor mar ngub kisao. Mbes aol mondom ne aondao ora haorubur kisaon obum tenaol andub ora ne nokl ubuklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ne haoraoklao aol ndam obun ne ngo haoruklao bao o ora pindib paesao tomb aol aondao ndam obun kongon biyao aol o bor tenaol hambun ne nokl eben kao mukl pu kobur kakl, Nim mbes tenaol ne nokl ubuklwaebe kowao baeben bor ne hambun sao man man bu u mba haeng, ini hambun ubuklub ko kaomukl pu kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ngub kisaol obun kongon biyao aol ndam hondokl pisao tomb tenaol ngo baebenom inj ko obokl buwaklmao was kobur, aol is mondom obu bor kakl, Nim nao em mend wen tomb uwao o hondokl poklwaol, nim njen ne ngo nokl obokl buwaklwaong njem menjao nen nao sobaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ngo tomb aol is mendem di obu bor kakl, Nim nao some kawao tobon kab mend dob bu mbayol, nao some ngo baebenom sowal tombo nao em kongon ebe buklemi eb ko hondokl poklwaol, aol ebe o nim njen ne ngo nokl obokl buwaklwaong njem menjao nen nao sobaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ngo tomb aol mondom di obu bor kakl, Nim ngubi tomb nao ten wen ora taol buwaol, njen ne ngo nokl obokl buwaklwao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mbinim ngub was kismil kongon biyao aol ndam obun aol aondao ne haoraoklao aol o birisaol wakl obobur, tenaol hambunom ngo kismi ub kao kalisaol, ne haoraoklao aol ndam obun hibi kho so ko aondao ora homobur obun kongon biyao aol nda bor kakl, Njem su and lobokl lobokl ngo bor wakl pobur, harer to aondao baebenon di harer to kang kang baebenon di hambun bor akol bubur lesin, tenaol dimb menjao nao wi boroklme baeben di, ki aongao tibae baeben di, el kho baeben di, tumu kho baeben di hambun nao anda kemi ebebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ngo tomb kongon biyao aol ndam wakl obobur kakl, Aol aondao o, njem kaenda ub nim njen angal taoluwao o, panda mendbor tenaol hambun nao buru ngaorukl pele ngo bao hae o kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ngub kisaol ne haoraoklao aol aondao ndam obun kongon biyao aol bor kakl, Nao and ngon tenaol andub ora tumbi haen ora birin ko pangakl ngao, njem wakl harer to aondao baebenon di em baebenon keberer di akol bubur, tenaol mendbor dera isaobu bor and bu boroklme baeben di hambun oa kemi ebebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ngub kobur kakl, Nim nje bor heneng ora kao njurukl, nim tenaol mendbor mbini mbes ne nokl ubuklub kowao o hul harimnda baeben, nao ne ngon kao heneng ora o di nao tuklemi ora kisao ko Njisesom angal mar ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ngo tomb tenaol andub ora Njises daol haru harer mendel pukl hasmil obum tenaol hambun baol munu hondobur kakl, ");
INSERT INTO akh_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Tenaol mondom ni hae ol oboklao tomb obum obun ingi aorao hesa di, obun were di, obun nongnas di, obun mbaoli di, obun haeme di, obun mbib nen saboklao sao hesa di, obum ngo baeben bor makl homo saond bi non bi nao harob sin, obum ninao man pange tenaol burukl buwaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ngub kobur kakl, Tenaol mondom di obu pe pae non bi ora ha, obun is pe kowaol bi nao taokl ebebur ni taol mi oba sin, obum di nao man pange tenaol hakl buwaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Wakl kakl, Ini ngo hayem haklon mondom obum and saoll aondao ora mend buklwao ko nen soba sin, obum sub kone kimb bu nen mbes sabo burubur, and ngon sokl asub baeben ora soklaob ko oborob ora kone kimb bu buruklao kisesa. Obum ngub nen sabo burubur nim and ngo buklbur andol haraoklao sao dob buklwao ub, nao mone ebe ngaorukl peklao be? nao ngaorukl peklaob ko kone kimb bu buruklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Njisesom ngub kobur kakl, Ngub inj, obum andol haraoklao sao mbes man man bu nao wibur su munu and pinj mbes saor mbarob sin, obun and saoll ngo penar bu nao bu tingi mbaklao tomb tenaol mendborom ngo bu nja haklao o hondobur aol ngo dobaekeklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Mbinim obu bor ngub kir ko maobowabur lemin aol ngom and ngo buklbur bu njaese o, obum penar bu nao bu tingi mbarekle lemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Njisesom wakl kakl, Ami semon aol wesmbao aondao mondom su tangaron ami sem maomb bo haraoklao aol aondao mende kab saond bukl poklwao ko nen sabobur man man buklao tomb, pibnao oran obum oborob ora kone kimb bu buruklao. Ngub buklao tomb obun ami aol buklhoma is bomboron iri non bi soklao tomb, ami sem maomb bo haraoklao aol mende o obun buklhoma is kabon iri non bi haru oba sin, nim obu ebe saond bu kalobur mbini ebe taol pe luklwao be? nao luklwaob ko kone kimb mbes bu buruklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ngub kobur kakl, Obum ngub kone kimb bi hondoklao tomb nim obu men mba lukl buwaklwao ko nen soba sin, obun saond bi ngo enderael so bao haklao tomb obum aol mendbor puklub kobur, saond nao bi bao wabon ka ko kao kalokl puklub lao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Wakl kakl, Menger bombor ngub was mubur, ini ngo hayem haklon mondom inin tangar tangar sao hambun sao nao tuwarim sin, inim nao man pange tenaol hakl buwaklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Njisesom ngub kobur kakl, Kunja hobao sao dend bi ora saoklao o, kunja ngo dend nao bi kho sa sin naom asub ora bubur wakl mao dend baklmaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Wakl kakl, Kunja dend nao bi ngubi, em bor ne osisao and sen ko some kawaon im hum kaloklme nda ub di nao bib se ora yaol, mbinim baehaemen kolo bowes buklemi ora kisesa. Inim angal ngubin te oborob nen saboklme baebenom angal ngo inin hal ora bor pen oborob ora pangoklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ngo tomb mone takis moroklme aol baeben di, khorob bimi tenaol baebenon mendbor di, mbinim Njises hasaol teb so obobur Njisesom Ngaorom angal bib ebe nda kisao ub pango birismisa. ");
INSERT INTO akh_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ngub bismil Peresi aol baeben di Nju semon man buwaloklme aol baeben di mbinim makl aondao ora homobur mbini hakl hakl kakl, Aol Njises ke ngo obu khorob bimi tenaol baeben hesa tenaol sango habur, ne di mbini haru no boroklme kismisa. ");
INSERT INTO akh_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ngub kismil Njisesom mbini bor angal mar kao kalobur kakl, ");
INSERT INTO akh_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Ini ngo hayem haklon mondom obun some sib supu hakl hakl hor su kalo haklao o, some sib ngon bombor mend bum haklao tomb supu hakl hakl hor makl o di hor su nan on supun teb mend di, ngo nao bum hae ne no haklemi baeben ngo haklemi bor bao haen kaoklbir, some sib aorao ndam bombor bum haklao nda es aondao bu ora buklao kisesa. Obum ngub es aondao ora bubur laon, hend wa muklao ub oran es bu tu sowaklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ngub kobur kakl, Obum hend wa muklao tomb obum turi aondao ora homobur pesaol taoklbir ");
INSERT INTO akh_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","anda poklao kisesa. Wakl kakl, Obun anda taokl po pindib paklao tomb obun sem di obun tenaol sango baeben di kor bu obo kiril mbaklaob kobur, obum mbini bor ngub lao. Nao some sib ngo mbes bum hasao o nim es aondao ora bubur wakl hend wa muwaong, naom turi homo werek aondao bu ora bem lao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ngub kobur kakl, Nim ini bor heneng ora kao njurukl, bombor ngub was menger mubur, tenaol hor su kone ebe ora wi haeme baeben non yu heben haeme baebenom kang bu sao turi homoklemi. Aoh, tenaol is mend obu kone nao baol mini haklao o wakl wen kone baol munuklao tomb, yu heben bor haeme baebenom turi aondao bu ora homoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Njisesom angal mar mend di kobur kakl, Ten mondom obun mone il tobon kab oran wisao o bombor mend bum hasaol, obum laomb kena ubur kisaon obun anda bor huni hi derabur es aondao ora bisao. Ngub es bubur kisaon mabor hend wa misao ko Njisesom kisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ngub kobur kakl, Ngub hend wa misao tomb obun sem di obun tenaol sango baeben di kor bu obo kiril mbaklaob kobur, mbini bor kakl, Nao mone il ngo bum hasao o ngubi tomb wakl hend wa mang, naom turi homo werek aondao bu ora bem kisao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ngub kobur kakl, Bombor ngub menger mubur, tenaol khorob was bimi on mondom wakl kone baol munuklao tomb, Ngaoron angal mini wesao baebenom werek bu turi aondao ora homoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ngo tomb Njisesom angal mar mende di kobur kakl, Aol menden isi is kab oran hasbi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ngub hasbil nas naongao nan ndam obun ab bor kakl, Ab o, njen osisao hambun sao yaon taol bakl ko nen sobale sin, njem ngubi tomb taol bu kobakabur ni njukl buklesi baeben pen ngubi tomb nji kisesa. Ngub kisaol aol ndam obun mone di hambun sao obun isi nda kabon taol bu kobakasesa. ");
INSERT INTO akh_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ngo tomb kang mend mabor sao nas naongao nan ndam obun osisao baeben hambun sao mu maembeyo, tenaol mendborom dob bin mone mibir su enderae ora mendel po hasesa. Ngub po habur su ngo obu hasao bor obum khorob was bu habur kisaon, obun mone nda baeben di mu bowes was bisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ngo tomb mabor obun mone hambun ora mu bowes bisaol pond bu paesao o su ngo bor de aondao bu ora ibisaol, obun hambun sao mari pisao nda baebenon di kang menjao nao wisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ngub bisaol nas ndam aol mend su ngol hasao on kongon ban kisaol, aol ngom obun su bor obun some baeben kala hakl pu kisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ngo tomb some ngo baebenom kor subu was no hasmil, somem kor subu ngo nismi o hondobur nas ngo dem aondao ora homobur, obum ne maeke no tu kaob kaob bu birisao o, mondom obu ne di nao kalismisa. ");
INSERT INTO akh_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ngo tomb nas ndam obun kone bor oborob ora mao kombaesaol kakl, Nao abon kongon bimi aol baebenom daol non ne andub ora mu bowes bu no haeme o, ni oran ngo bor dem khorob ora ngo homo wi o alem kisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ngub kobur kakl, Ni hende ora. Nim ngubi tomb wakl nao aorao hayaol pobur nim obu bor ngub lowao. Aorao o, nim Ngaor hesa ibi bor khorob was buwaol, ");
INSERT INTO akh_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","njem ni bor nje nao isi ora hael kaeb nao se kho ora haeng, njem ni njen kongon biyao aol men mao koraebe lowao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ngo tomb nas ndam wakl obun aorao hasaol poklbur pisaol, nas ngo obun aoraom obun isi ngo mbes bum hasao nda kang mend enderael sao ibisaol hondobur kisaon, obun kone bor hond aondao bu ora himisesa. Ngub hond homobur kisaon obum akl was po obun isi nda men ha hibi nunu bisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ngub bisaol nas ndam obun aorao bor kakl, Nim Ngaor hesa ibi bor khorob was buwaol, njem ni bor nje nao isi ora hael nao kaeb se kho ora hae kisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ngub kisao o obun aorao ndam obun kongon bimi aol baeben bor kakl, Inim nao lab lab saoll ebe ora nda mini obo nas ngon somakabur lemin, yaor ebe ora iring mend uwe o di obun ki hondel mao ta, aongao su mend uwe o di inim obu kalaoklaob kisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","24","Ngub kobur kakl, Nao isi ngo obu mbes pe pae non bi sisao o ngubi tomb obu wakl enjaokl pene. Obu ora bum hasao o naom obu wakl ngo haondaoklaom ngao, nao some kawao hondbao hobao hae aondao nda lu sabur, turi homo werek bu ne nemin ub kemi ubuklub kisesa. Ngo tomb mbinim turi aondao bu ora homo werek bubur ngub bismisa. ");
INSERT INTO akh_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ngo tomb aol ngo obun isi mende mubao nda obu obun em bor hasao o anda obobur kang mend anda teb sol sao obo habur pangisaol, mbinim we ko is maol minismil pangisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nas ndam ngub pangobur obun aoraon kongon biyao aol mend ib ko ne mubur kakl, Abo anda bor asao was beyem? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ngub kisaol obun aoraon kongon biyao aol ndam kakl, Njen haeme mend mbes bum hasndis wakl obaonaol, aoraom obun isi ngo mbes bum hasndis o obu ora nao bum hae wakl ebe obaokl kobur, obun some kawao hondbao hobao hae aondao ora nda daol lu sawo ne hararob kisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ngub kisaol nas mubao ndam obun kone bor ko aondao ora homobur, obu mbini ngo ne no turi homo birismi bor nao hondaesesa. Ngub bisaol obun aorao ndam obu hasaol dera pobobur, obu bor angal oborob ora ko mao hebeyabur, nje andaon ib kisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ngub kisao o nas ndam obun aoraon angal ngon ko san lubur kakl, Pangal. Nim karasmas andub ora baehaemen was njen kongon bu habur, njem ni bor kongon hambun sao bibi kisi sao kang ora di hul nao hawao o, njem ni bor asao was njis bo? Njem some meme hondbao kang is bombor ora di mend nao tenaol sango baeben bor turi homo lu sowaomun nao njisndis kisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ngub kobur kakl, Njen nas naongao nan ngom non njen osisao o kalisndis baeben di hambun mi pobur, ten pamuk kalo mu bowes bu hakl obaokl o, njem obu turi homobur some kawao hondbao hobao hae aondao nda ngo lu ne hararil o ka kisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ngo tomb obun aoraom obun isi mubao ngo bor kakl, Nao isi o, nje non bum ha di menjao nao bi yao was bao haroklbao ndal, nao hambun sao wiyu sao baeben njen was wi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ngub kobur kakl, Njen haeme ngo obu non mbes pe pae non bi sisao o ngubi tomb obu wakl enjaokl pene. Obu ora bum hasao o naom obu wakl ngo haondaoklaom ol, naom ngubi tomb werek bu turi aondao bu ora homaeb se hayom ub, ne haoru naon kone bor turi aondao bu ora ngo homoklaom o kisao ko Njisesom angal mar ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ngo tomb Njisesom obun man pange aol baeben bor angal mar kao kalobur kakl, Aol homa menden mone maeb haraoklao aol mend hasesa. Ngub hasaol aol mendborom aol homa aondao nda hasaol obobur mbinim aol homa ngon mone maeb haraoklao aol ndam bisao sao kao kalobur kakl, Njen mone maeb haraoklao aol ndam njen mone osisao baeben mu bowes bu harob kismisa. ");
INSERT INTO akh_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ngub kismil aol homa ndam obun mone maeb haraoklao aol nda ib kobur obu bor kakl, Nim njem bu hari sao mend enjol pangokl on asub ko bu harib balem? Pangal. Njem nao mone maeb ha nao kongon di ko mende nao buklesing, njem ngubi tomb ora pobur lesin ninao hambun sao njem warili sao baeben nim hondon ub mu kiril mbabur, ndi munukl pu kisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ngub kisaol aol homa ndan mone maeb haraoklao aol ndam kone kimb bu burubur kisaon, ninao aol aondaom ni maeb haraoklao aol haruklu nda ub nao hae ngo pu ke o, nim su tombo kam sabor minibi di nao buri mend nao wing, nim tenaol mende bor ne njib was ko no buruklwao tomb di ni sakl ora bu pae soklaong, nim asub ora buklwaob ko? nen sabisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ngub nen sabobur kisaon obun kone ndaon bor ngub nen sab ndaesao. Bombor sao mend nim ora hende. Nao aol aondaom ni bor nao mone ko mende nao maeb haklesing pu lao tomb, tenaol hambunom ni mbinin anda bor kemi po ne hakl njin ko nim ngub ora bun kobur kisaon, ");
INSERT INTO akh_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","tenaol mendbor obun aol homa ndan san haen birismi baeben hambun bombor was ib ib bib kisaol, mbinim obu hasaol ibismisa. Ngo tomb aol is mend pibnao ibisao bor mbes ne mubur kakl, Njem nao aol aondaon san asub baeben ora haleb? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ngub kisaol aol ndam obu bor kakl, Wel ndaram tokl supu hakl hakl hor su oran hayao kisesa. Ngub kisaol aol homa ndan mone maeb haraoklao aol ndam kakl, Njem njen san ngon bobae kang ngo mubur lesin, penar bu nje tol burubur njen san andub hayao kaenda ub kunubur, nao san supu kab kab hor kab hor tebo nan on tobon kab ora hayao ko bobae waeb bu wi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ngo tomb aol mende ibisao bor mone maeb haraoklao aol ndam ne mubur kakl, Njem nao aol aondaon san asub baeben haleb? kisesa. Ngub kisaol aol ndam kakl, Wir il mar pae mbek nu tokl andub ora l,000 oran hayao kisesa. Ngub kisaol aol homa ndan mone maeb haraoklao aol ndam obu bor kakl, Njem njen san ngon bobae kang ngo njurukl om njen san andub hayao kaenda ub kunubur, penar bu nao san baoklmend ora mbek nu tokl 800 ora hayao ko waeb bi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ngo tomb mabor aol aondao mone ndan aorao ndam obun mone maeb haraoklao ngo obu maobalaoraoklao aol ndam, obu mabor haklaon oborob kone kimb bu man man bisaol hondobur, aol homa aondao ngom njem oborob kone kimb bae kobur kaoya kisesa. Ngub kobur kakl, Sul woroklme saol was kone u haroklme baebenom mbini mabor haklemi on oborob ora kone kimb bu man man bimi ub, Ngaoron sem bao bi haroklme baebenom kone kimb bubur man man bimi ub di men mbaroklme kisao ko Njisesom angal mar ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ngo tomb Njisesom ngub kobur kakl, Nim ini bor heneng ora kao njurukl, inim tenaol menjao nao wi boroklme baeben kab tenaol sango habur lemin, mbini bor sul woroklme sao maru u haklemi baeben taol bu kaloklwaebe ora. Inim oborob ngub buklemi tomb mabor inim mone osisao u haklemi o tuwakl poklemi bao mend buklao tomb, mbinim ini haeben saroklme su ebe mendel oborob obaeming ubuklub ko mao beraklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Wakl kakl, Tenaol mondom kang sao mend oborob hondobur ora bu harob sin, obum aondao sao di oborob hondobur ora bu haklao kisesa. Ngub inj, tenaol mondom kongon kang sao o oborob nao ba sin, obum kongon aondao sao o di oborob bukl buwaklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ngub kobur kakl, Inim su ngol woroklme sao, mone kho haeben nao mao saraoklao ngo oborob maeb nao harim sin, hobao sao ora o di ini bor mondom maeb haklaob ko nao kao njuklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ngub kobur kakl, Inim aol menden osisao oborob ora nao maeb harim sin, menjao menjao inin ora o di aebom was bao njuklaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ngub kobur kakl, Kongon biyao aol bomborom maomb bo haroklbe aol kabon kongon bukl buwaklao ora kisesa. Wakl kakl, Aol ngo obum aol mende bor turi homo kone uklao o obum mende bor makl was homoklao. Is mende turi homo taol mi poklao o is mende makl homobur mesao kaloklao kisesa. Ngub kobur kakl, Inim Ngaor hesa mone kab kobaranol kone ukl buwaklemi ora ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ngo tomb Peresi tenaol baebenom mone turi aondao ora himismi o, Njisesom angal hambun sao ngo kisao nda baeben pangobur mbinim Njises bor kir ko maobowaesmisa. ");
INSERT INTO akh_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ngub bismi o Njisesom mbini bor kakl, Tenaolom ini ebe ora hayem ken ko mbinin el sol teka haroklme o, Ngaorom inin kone ndaon bor wiyao sao ora hendeyao. Tenaolom hobao sao e ko kaoya lome sao hakl di Ngaorom hendeyao tomb bung bi kho hendaebe makl bi ora wiyao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Njisesom ngub kobur kakl, Man mini aol mbes hasmi baebenom di Mosesom di man bombor o was kismil, mabor Njon Mbabtas Biyao Aol hasndis tomb di tenaol hambunom man bombor ngo was pangismi ora. Ngub bismi o Njon Mbabtas Biyao Aol ngo obu hasndis ol tuma pabur ngubi tomb non Ngaorom maeb ha maomb bo hayao on Angal Bib Hobao Sao ngo pangeyem o, mbinim naon mbib ebe poklmao kobur tiriyao kang ngon buri palo haong lukl engel beyem kisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mbinim ngub beyem o mabor su hesa saohar kab ora bum haklao ub buklao tomb di, Ngaorom Moses bor man hambun sao kao kalisao o kang el bombor ora di nao bum hae wi aeben ora soklao kisesa. ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ngub kobur kakl, Aol mondom obun were o njen anda pu kobur ten tangar mende taol ba sin, obum ten mende ngo taol buklao o paes ora kemi poklao kisesa. Wal kakl, Aol mondom di ten mend obun aolim mbes tuwaesao o taol ba sin, obum ten ngo di paes kemi buklao ko Njisesom ");
INSERT INTO akh_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ngo tomb Njisesom mbini bor kakl, Aol homa mend obun osisao andub ora maru u habur kisaon, obun siyor di obun lab lab sem hambun sao mone aondao bu pe on was dob bubur, obum hor hambunon ebe oran was bu habur kisaon, obun ne di ebe sao was no hasesa. ");
INSERT INTO akh_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ngub was bu hasao tomb aol ngo obun anda tiriyao kombae oral aol dimb is mend obun imbi Lasaras, obu obun toklo songol hambun bor di der was bi mend u mba hasesa. ");
INSERT INTO akh_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ngo tomb aol dimb kang ndam obun kone bor nim aol homa ngon ne noklao on ombo tuwaklao baeben sablo nokl engel buklwao tomb, ni dem nao pe pae ebe soklao ko nen sabisesa. Ngo tomb buklhoma baebenom di aol dimb ngon der bisao nda baeben mbinin hekem bu waru kunakl engel bismisa. ");
INSERT INTO akh_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ngo tomb mabor aol dimb Lasaras ngo pe paesao tomb Ngaoron angal mini wesao baebenom obu yu heben men pae pobur, Eberehem hesa maomunu haen kismisa. Ngo tomb aol homa aondao nda di himisaol maol bismisa. ");
INSERT INTO akh_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ngo tomb aol homa ngo obu ke hondoklme su bor po, isaolao dao hakol bi bor tenda aondao bu ora no habur obum yu haeben saroklme su bor hend yaesaol, Eberehem enderael sao hasaol hindisesa. Ngub hindisao tomb aol Lasaras obu aol homa ngon ne du sarbeyao no birisao nda di Eberehem hesa haru hasbil hindisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ngub hondobur aol homa ke hindisao ndam kakl, Nao ab Eberehem ka, isaolaom ni tenda aondao ora ngo bil o kang mend kur ken ub, njem ni hond homobur Lasaras bor obun ki hondem ib kang mend nao heke bor tand beyakl pu kao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ngub kisaol Eberhemom obu bor kakl, Nao isi ka, njem ngubi tomb oborob ora nen sab. Nje nao heme sul bao hasi tomb njem hambun sao ebe tol tol was pobo hasndis tomb aol Lasaras kang ngo obu hambun sao ombo was es es bu birisndis ka. Ngub birisndis o ngubi tomb obu su enjo ngol obun kone ora bor ebe sen habur turi aondao ora bin hae tomb nje ke aondao ora ngo hendel o kisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Eberehemom ngub kobur kakl, Mende di enjo ngo nao hayom ol nao hesa ini kab, tomb ib kena aondao abo ngo peben kisaol, tenaol enjo ngo nao hayom nan hayem baebenom abo ini hayem o nan kollmbakl obokl buwaklemi ora. Ini abo nan hayem baebenom di enjo ngo nao hayom ol kollmbakl obokl buwaklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ngo tomb aol homa ngo ke hindisao ndam kakl, Nao ab ka, ngub sin nim nje bor kao njurukl ngao, njem Lasaras oran nao abon anda bor pen kao ko nen sobakl kisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ngub kobur wakl kakl, Nao haeme oran is su ora haemeng, mbini di su kho ngo ni ke aondao ora hende bor was nao eben ub, Lasarasom mbini bor buriyab ora man kokl pen kao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ngo tomb Eberehemom obu bor kakl, Mbinim Mosesom man kisao o di, mbes Ngaoron man mini aol baebenom kismi baeben di, mbinim man ngo baeben ebe pango ora haemeng, mbinim man ngo oborob ora nen sab hakol bibaebe buklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ngub kisaol aol homa ke hindisao ndam kakl, Nao ab Eberehem o, inj ka. Mbinim man ngo pangismi om ebe nao soklao ora. Aol Lasaras obu pe paesndis o wakl enjaokl pobur, obum mbini haemel man kao kalokl poklao tomb mbinim ebe kone baol munuklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ngo tomb Eberehemom obu bor wakl kakl, Mbinim Mosesom man kisao ub hesa mbes man mini aolom kismi ub kab oborob ora men hakol nao baem sin, aol mend homoklao o wakl enjaokl pobur mbini bor man kao kaloklao tomb di, mbinim obum heneng ora le ko nen sabo angal ngol hul ha nao haklemi ora kisao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ngo tomb Njisesom obun man pange baeben bor kakl, Tenaol khorob mao baraoklao saom non heneng ora tenaol saokl mao waklao o, njem tenaol ngub saokl mao wari sin nje ke aondao ora hondoklbur haklesi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wakl kakl, Mondom njen mal han aondao ora hond mend hend ha tu ndiyabur ib mal aondao oran ndaon bor haoklu tu kobarob sin, nje ib ndaon ngo bor ke kang bu sao hondoklesi. Ngub buklesi o njem Karas tenaol kang bombor ora mend saokl mao wari sin, nje ke aondao bu ora hondoklesing, ");
INSERT INTO akh_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","njem mende saokl mao waklesi hondo ora haebe kisesa. Wakl kakl, Njen haeme mondom khorob ba sin, njem obu bor ngub nao bi ko sub taolu libi. Ngub buklesi tomb obum wakl kone baol mana sin, njem obu bor menjao nen nao sabe bao waebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ngub kobur kakl, Obum nje bor bao bomboron ko haoklao oran khorob bubur laon, obum nje haklesil ko haoklao oran obobur nim khorob buwao o kone baol munuwao kam oba sin, njem obu bor saongao maru menjao nen nao sabe bao wa was bibi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ngo tomb Ngaoron angal bib hobao sao kam akol bu haroklme aol nda baebenom Njises bor kakl, Aorao Aondao o, naom Ngaorol hul ha haroklmao kone ebe ngubi aondao bu ora and mao saebe kismisa. ");
INSERT INTO akh_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ngub kismil Aorao Aondaom kakl, Inim Ngaorol hul ha haklemi ub sowar il kang ora moklo ndaon bor baoraoklao nda bi menger hul ha harim sin, inim is ngo hae o bor njem te kob mi pobur ib kunja tukun bor hakl pu lemi tomb, is ngom inin angal hul nao hae ngub buklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ngo tomb Njisesom kakl, Ini ngo haklon is menden sokl nao mi kalabus kongon non bi biyao nas mend hayao o, njen em kongon be? be? njen some sib maeb ha ngub bu haklbir, kongon biyao nas ngo anda ebeyao tomb njem obu bor, nje penar bu ora ne ngo wi o nokl ib kale be? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ngub inj ka. Njem obu bor ngub ora kale. Njen ne mabor sa no hanin ub ni mbes non orang, njem lab lab daol ebe dol nao hae on mend njen toklol mu mbukl mbabur, penar bu ora ne di ib di ninao mbes ngol man man bu sa tae ib ora kale kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ngub kobur kakl, Njen kongon baraoklao nas ndam njen angal hul nao hae njem kale sao e was kobur beyao tomb, njem njen kongon biyao nas ngo bor tengiyu ko kaoya kale be? Aoh, ngub nao bili ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Wakl kakl, Inim ngub nen sabobur lemin, inim Ngaorom kao njuklao sao bu paklemi tomb inim ngub lowaebe. Nao Ngaoron kowan lao sem kho ora hayom ol, naom kongon ngo bu hayom sao hakl di naom bib se hayom ub ora bu hayom lowaebe ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ngo tomb Njises obu su Njurusalem poklbur su Sameriya hesa Kalili kabon tukun ora bor pisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ngub pobur kisaon su and te kang mendel pindib paesaol, aol maollun bi is tobon kab mend Njises obu hen mukl ibismi o kang mend enderael sao hasmil hindisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ngub habur mbinim obu bor kor bubur kakl, Aol aondao Njises o, njem nao hond hom ora kismisa. ");
INSERT INTO akh_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ngo tomb Njisesom mbini hondobur mbinin angal ngon ko san lubur kakl, Inin toklo Nju semon baolum aol baebenom henden muwalokl puklub kisesa. Ngub kisaol harerol pobur hindismi tomb mbinin toklo songol bor wakl ebe sisaol hindismisa. ");
INSERT INTO akh_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ngo tomb mbini aol tobon kab ngo pismi on is mondom obun toklo songol bor hindisao tomb ebe ora sisaol hondobur kisaon, wakl Njises hasaol bokeyobur obum angal aondao bu ora kobur Ngaor bor kaoya kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Obum ngub bubur kisaon Njiseson aongao ma teb so bor dombes ubur, Njises turi aondao bu ora homobur tengiyu ko kaoya kisesa. Ngub bisao o aol ngo obu Nju sem inj, obu Sameriya aol sisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ngo tomb Njisesom aol ndam ngo bisao sao hondobur kakl, Nim aol is tobon kab ora ebe mao sarundang, mbini aol is tobon bombor o abor haemeb? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Njisesom ngub kobur kakl, Aol ngo nda haklon is mend di wakl bokeyobur Ngaor bor kaoya kokl nao oboklemi be? Nim aol sem tangar Sameriya aol is bombor ngo ora mao ebe sawao ye? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Njisesom wakl aol nda bor kakl, Njem Ngaorol hul ha harilim nje ebe mao sarobndang, nje ngubi tomb tekakl pu kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ngo tomb Peresi aol mendborom Njises bor ne mubur kakl, Ngaorom maeb ha maomb bo hayao ub atomb maeb ha maomb bo hakl oboklaob? kismisa. Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Ngaorom maeb ha maomb bo hayao ub tenaolom elom nao handaeb se ora yao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ngub kobur kakl, Ngaorom inin kone ndaon bor ora maeb ha maomb bo haraoklaol, mondom ini bor enjo ngo maeb ha maomb bo hae hend. Aoh, isu ngo bor maeb ha maomb bo hayao di nao lao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ngo tomb Njisesom obun man pange aol baeben bor kakl, Mabor bao mend buklao on inin kone bor Aolon Isi Ora hem aondao ora kobur, naom obu ko mend haondaomun sa ko nen saboklemi o inim ni nao hondoklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ngo tomb tenaol mendborom ini bor ngub lemi. Haondaoklaob. Obu isu ngo bor hayao ye? Aoh haondaoklaob. Obu enjo ngo bor ngo hae leming, mbinim ngo lemi ub inim mbinin angal nao pangoklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ngub kobur kakl, Aolon Isi Ora obu obokl buklao tomb saohar hambun bor bubiyab biyao nda ub bao aondao bu ora bu kimb buklaol, obu bao bi ngubi ora oboklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Njisesom wakl kakl, Ngub buklao o tenaol ngubi tomb ngo hayem baebenom obu mesao kalobur besao kon uklemil, obum pibnao oran tanda no ke andub ora hondoklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Obum ngub kobur kakl, Mbes aol Nowa hasao tomb tenaol hambunom bismi ub, Aolon Isi Ora oboklbur buklao tomb di bombor ngo bismi ub was buklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ngub kobur kakl, Mbes Nowam ib taokaoll warisao tomb tenaol hambunom mbinin ne hesa ib kab nao pa, aolom di ten taol buklemin was kone wi, tenom di aol poklemin was kone wi bismisa. Ngub bubur Nowa obun sem mbini ib taokaollon hondaesmi bao on di mbinim ngub besao kon bao u haen was, ib wae aondao ora obobur mbini tenaol ngo baeben hambun nao pesaol ib no pe beraesmi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Wakl kakl, Mbes aol Lor hasao tomb di tenaol hambunom mbinim ne ib kab was nao pa, osisao was hem ko dob bu, mbinin osisao wismi hakl di tenaol tangarom dob bin sokl mu, mbinin em bo and bu ngub was bu hasmi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ngub kobur kakl, Ngub bismil aol Lor obu su Sorom ngo bor hasao o pakl paokl pisaol, bao bombor ngon su ngo bor dao pind hesa isaolao kab aondao ora yu heben hakl obobur, tenaol hambun do pundi pesao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Wakl kakl, Aolon Isi Ora obu tenaol hambunom henden oboklao bao on di, bombor ngo bise ub was buklao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Njisesom wakl kakl, Ngub oboklao tomb aol mondom njen and wil dera nan hari sin, njen osisao uklesi o mukl wakl andaon nao hondaebe ora kisesa. Mende di aol mondom njen em bor hari sin, njen anda wakl nao bokele pakl paokl ora pebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ngub kobur kakl, Aol Loron were obu ke hindisao ub di oborob ora nen saboklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Njisesom wakl kakl, Tenaol mondom obum obu nao heme sul bao haklao ub was hem ko harob sin, obu haeben nao sae ke hondo bum haklao ora. Ngub buklao o mondom obu nao pe pae bao was haklao ub hem ko nen nao saebe obu pe pae non bi ora harob sin, obu haeben ora soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ngub kobur kakl, Ngo sao hakl buklao tomb aol is kab mend mbinin to bomborol paolu uklebi o, Ngaorom is mende men mubur is mende paolu win waklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wakl kakl, Mende di ten is kab mend mbibim palawe kongon bi uklebi o, Ngaorom is mende men mubur is mende birin waklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ngub kobur kakl, Aol is kab mend em bor haklebi o di, Ngaorom is mende men mubur is mende haen waklao ko Njisesom obun man pange aol baeben bor ngub kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ngo tomb mbinim angal ngo kisao nda pangobur kakl, Aorao Aondao o, njem ngo kal o abor bu pindib paklaob? kismil, Njisesom mbini bor kakl, Su bor baoraoklao sao menjao homo wiyao bor was, sao hur mesim obo kiril mbaroklme ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ngo tomb Njisesom mbini bor angal mar bombor mend, mbinim Ngaor bor makl nao hom mi hor hor kao ha was birin ko kao kalobur kakl, ");
INSERT INTO akh_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Aol howes pangaoklao aol mend su and lobokl lobokl mendel birisesa. Ngub birisao o aol ngom Ngaor bor nen sabo pakl nao hemebur, obum tenaol baeben di hem ko hond nao himisao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ngo tomb ten obun aoli heme weyae mend obu su and lobokl lobokl ngo bor birisaol, ten ngom hor hor howes pangaoklao aol nda birisaol ib ha was burubur kakl, Mondom ni maobowabur nao osisao mi was pe ngao, njem ni bisur bu howes pang kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ngo tomb howes pangaoklao aol ndam ten ngom ngo kisao ub nao pang was bisao o, mabor aol ngo obun kone bor kao ndabur kakl, Nim Ngaor bor di nen sabo pakl nao homaklo ora. Nim tenaol hambun di hem ko hond nao homaklo nda o, ");
INSERT INTO akh_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ten weyae ngom hor hor nao howes pang was kokl engel bubur ni pakla aondao ora mao saklaol, mabor ni makl aondao bu ora homoklwao kobur kisaon, nim obu bisur bu howes pangon kisao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ngub kobur Aorao Aondaom mbini bor wakl kakl, Inim angal howes pangaoklao aol kone kho wi ngom ngo kise saol o pangeklem tomb ");
INSERT INTO akh_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","inim asub nen sabeyem? Tenaol Ngaorom sablo haen kisao baebenom hor hambunon hora di somna di Ngaor obu bor kao kal ha was harim sin, obum daol inin angal heneng ora pangobur ini bisur buklao ko nen nao sabeyem be? kisesa. Wakl kakl, Obum penar bu inin angal pango ini bisur nao bi bao waklao be? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ngub kobur kakl, Nim ini bor heneng ora kao njurukl, Ngaorom ini ngub penar bu ora bisur buklao o, mabor Aolon Isi Ora obum obobur hondoklao tomb tenaol hambunom Ngaorol hul ha nao haebur, mbinim mbinin kone bor obu mabor ngo oboklao ub di obu heneng ora oboklao ko nen nao sabe haklemil hondoklao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ngo tomb aol mendborom mbinin kone bor nao non ebe ora habur oborob was bu hayom o, mbini tenaol tangar mendbor non kho ora hayem ko nen sabismil, Njisesom mbini bor angal mar bombor mend kao kalobur kakl, ");
INSERT INTO akh_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Aol is kab mend is mende Peresi aol, is mende mone takis maoraoklao aol kab, mbinim Ngaor bor kao kaloklbur Ngaor Hen Moroklme Anda on hondaesbisa. ");
INSERT INTO akh_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ngo tomb aol mende Peresi aol ndam kang mend aebenol sao armend po teka habur, obun mbib nen sabobur obum Ngaor bor ngub kao kalisesa. Ngaor o, ni aol tangar mendbor hayem ubi inj hae ol nim nje bor tengiyu ora kakl. Mbinim mone osisao heb homo, menden sao hakl maobala mu, ten paes di kemi po, mbinim ngub was bimi o ni mbini non bi inj hae. Ni aol takis mone maoraoklao aol ngo bere ubi di inj hae ol nje bor tengiyu kakl ko, Peresi aol ndam Ngaor bor ngub kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ngub kobur kakl, Nim saren hambunon di bao hor kab was nje bor hem ko nen saboklbur ne tuwa paolaklo. Nim mone di osisao hambun sao di tobon kab nan o nje was njuruklu ko, Peresi aol ndam Ngaor bor ngub kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ngub kisao o mone takis maoraoklao aol ndam and ngon solo te bor sao habur, obum sakl polo yu heben bor di nao hende su bor hend nabur ni kho ora hae ko nen sabo, obun kongbaol men mbabur kakl, Ngaor o, ni khorob biyu aol ora hae ngao, njem ni hond homo bisur bibi ko takis maoraoklao aol ndam Ngaor bor ngub kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Njisesom ngub kobur kakl, Nim ini bor heneng ora kao njurukl, mone takis maoraoklao aol ngo obu bor, Ngaorom nje aol ebe kone dund se wi oborob bili aol ora hael kisaol obun anda pisao o, aol mende Peresi aol ndam Ngaor bor kao kalisao ub Ngaorom nao pangisao ora kisesa. Wakl kakl, Tenaol mendbor mbinin mbib ni imbi wi ebe ora hae ko kaoya lome baeben, Ngaorom mbini men mbabur imbi nao wi kang mao saklao. Ngub inj, mbini tenaol mendbor ni imbi nao win haklwao ko pangaem sin, Ngaorom mbini ngo baeben imbi wi aondao ora haen lao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ngo tomb tenaol mendborom mbinin nongnas kang kang baeben Njisesom kim men mba peb bin ora ko nen sabobur kismin, obu hasaol was mini obo kiril mbaesmi o, Njiseson man pange aol nda aebenom ngo bismi o hondobur, obun hobao sao bukl bi hakol ngub nao bib kobur makl homo taolu lismisa. ");
INSERT INTO akh_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mbinim ngub bismil hondobur Njisesom nongnas kang kang baeben obu hasaol teb so ubuklub kobur kakl, Ngaorom maeb ha maomb bo hayao bor nongnas kang ngubim kone woroklme ub u haroklme baeben was pokleming, inim nongnas kang ngubi baeben di ni hae ol eben ub ngub nao lowaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ngub kobur kakl, Nim ini bor heneng ora kao njurukl, tenaol mendbor nongnas kang ngubi men aolubur mbini Ngaorom maeb ha maomb bo haen nao harim sin, mbinim Ngaorom maeb ha maomb bo hayao bor pokl buwaklemi ora ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ngo tomb Nju semon maomb bo haraoklao aol mondom Njises bor ne mubur kakl, Aol aondao o nje ebe ora hael ngao, nim asub ora buklwao tomb ni haeben saklwaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ngub kisaol Njisesom obu bor kakl, Njem asub ko ni bor aol ebe ora kal? Ngaor obu bombor o ora ebe hayao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ngo tomb Njisesom wakl kakl, Njem Ngaoron man hambun sao wiyao ub ora pangeleng, njem ten paes nao kemi pebe. Njem tenaol mende pe paen nao libi. Njem paes nao naebe. Njem tenaol mende bor kakla nao kao beyaebe. Njen am ab kabom lebi sao di hul nao hae oborob ora pangaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ngub kisaol aol homa ndam Njises bor kakl, Nim mbes nas kang ora hawao tomb di ngubi tomb di, njem ni bor man ngo bibi kal baebenon ukl mend nao baondib mini hambun sao bu haruklu ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ngo tomb Njisesom aol ndam angal ngo kisao o pangobur obu bor kakl, Njem bombor sao ora mend nao bising, njen osisao hambun sao maru u harili sao baeben tenaol tangar mendborom dob bin mone mibi ora. Ngub bubur lesin njen mone ngo muklesi baeben njem tenaol mendbor menjao menjao nao wi buruklemi baeben bisur bu taol bu kalaebe ora. Njem ngub buklesi tomb njen osisao hobao sao ora yu heben bor maru u hae non bu haklesing, njem ni taol mi ebebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Njisesom ngub kisao o aol nas homa aondao ndam obun osisao andub ora maru u hasao o sisaol, obun kone bor hem aondao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ngub bisaol Njisesom obun kone bor hondobur kakl, Aol homa osisao andub ora maru u haroklme baebenom Ngaorom maeb ha maomb bo hayao bor poklbur es aondao ora bubur, kekeb haong lib se ora yao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ngub kobur kakl, Aol homa baebenom Ngaorom maeb ha maomb bo hayao bor aondao bu ora es buwa kekeb haong lib se yao om, some kamelom lab lab taombuloklme sao kem haolon dir bor es buwa kekeb hondakl buwabur puklmi ub di men mbaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ngub kisaol tenaol mendbor Njiseson angal ngo pangismi baebenom Njises bor kakl, Ngub sin mondom haeben nao saeb se ora saol ngao, aebom was haeben saklaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ngub kismil Njisesom kakl, Tenaolom bukl buwaroklme sao baeben di Ngaorom hambun sao ebe biyao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ngo tomb Pitam Njises bor kakl, Pangal. Nao ngo baebenom non naon su and te di hambun sao tuwaklbir naom nje was ngo taol mi ebeyom o kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ngub kisaol Njisesom mbini bor kakl, Nim ini bor heneng ora kao njurukl, mondom Ngaorom maeb ha maomb bo hayao ub tenaol hambunom henden muwaloklbur, obun su di ten nongnas di ingi aorao di haeme mbaoli di tuwaklbir ni hem ko taol mi oba sin, ");
INSERT INTO akh_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Ngaorom obu bor ngubi tomb obun san andub ora kond bam bam bu lubur, obu yu heben bor di haeben mao saklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ngo tomb Njisesom obun man pange aol duteb nda baeben ubuklub kobur, mbini hungum ware pe ora hasmi tomb obum mbini bor kakl, Pangeklem. Naom embi ngubi tomb su Njurusalem di mend ngo pukl hayom tomb ora kao njurukl ngao, mbes Ngaoron man mini aol hasmi baebenom Aolon Isi Ora bor ngub buklemi ko mbuk waeb bor waeb bu wismi ub, heneng ora il so pind biklaol kang mend wen sao buklemi. ");
INSERT INTO akh_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Mbinim Aolon Isi Ora o men habur Aol Sem Tangar kaloklemil, mbinim obu hondo ko bowes bu maobowa peb bubur, ne maeke tokl beya ngub buklemi ko mbuk waeb bor ngub ke wiyao ora. ");
INSERT INTO akh_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ngub bubur lemin mbinim obu doroklom di khorob ora lu bowes bubur pe paen luklemi o, bao hor teb o nan on obu wakl enjaokl poklao ke wiyao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ngub kisao o obun man pange aol nda baebenon kone bor oborob nao hondaesaol, Njisesom angal ngo kisao on te mupango ora wisaol mbinim nen sabokl buwaesmisa. ");
INSERT INTO akh_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ngo tomb Njises obu su Njeriko teb so po pindib paesaol, aol el kho mend obu harer solol burubur, tenaol harer ngon pibismi baeben bor mone di ne osisao di kang mend njib was ko kao deb deb bu buru wisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ngo tomb aol el kho kang ndam pangisaol, tenaol andub ora angal erer ko ibismil pangobur obum tenaol mendbor ne mubur kakl, Mbinim asao was beyem? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ngub kisaol mbinim obu bor kakl, Nasarer Njises ebe kismisa. ");
INSERT INTO akh_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ngub kismil aol el kho ndam kor bubur kakl, Debir semon isi Njises o, njem ni hond hom kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ngub kisaol tenaol ngo harer ngon mbini mbakla ibismi baebenom aol el kho kang nda bor, njem angal nao kao kobur taolu lismisa. Ngub kismi o aol el kho kang ndam aondao bu ora kor bi hakol bubur kakl, Debir semon isi o, njem ni hond hom ko aondao bu ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ngo tomb Njises obu nimil tu habur tenaol ngo hasmi baeben bor kakl, Aol ngo ni kor bil o obu kemi ubuklub kisesa. Ngub kisaol aol el kho nda teb sol mini ibismi tomb Njisesom aol el kho ngo bor ne mubur kakl, ");
INSERT INTO akh_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Nim nje bor asao ora bun ko ni bor kor baeb? kisaol aol el kho ndam kakl, Aol aondao o, njem ni wakl el tun kao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ngub kisaol Njisesom obu bor kakl, Njem ngubi tomb njen el ti pe ora. Njem nil hul ha ora harili saom nje wakl ebe saokl kisesa. ");
INSERT INTO akh_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Njisesom ngub kisaol bombor ngo ora tomb ebe bao sisaol, obum osisao hend heneng bisesa. Ngo tomb aol ndam Njises taol mi pobur kisaon, obum Ngaor bor tengiyu kaoya kisaol, tenaol hambunom di ngo bisao sao hondobur kismin Ngaor bor was kaoya kismisa. ");
INSERT INTO akh_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ngo tomb Njises obu su Njeriko pindib pabur, su and lobokl lobokl aondao ngo bor pibisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ngub pibisao tomb su ngo bor aol is mend obun imbi Sakiyas hasaol, obu mone takis maoraoklao aol aondao ora habur, obun mone di andub ora maru u hasesa. ");
INSERT INTO akh_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ngo tomb aol Sakiyas ngom Njises ebe kismil pangobur, obu asub bi ora eb ko hondoklbur bisao o, obu aol hi ora sisaol tenaol andub ora dengeb dengeb ko ha manga peb bismi om, obum Njises oborob nao handaeb se sisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ngub sisaol mone takis maoraokao aol ndam Njises obu pobokl bisao hareron obu mbakla akl was pobur, is dullub isao non bi kang mend harer tol hasao o tumubur hondo birisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ngo tomb Njises obu ngol obo pindib pa yu is ma nda bor hend yabur, obum mone takis maoraoklao aol nda bor kakl, Sakiyas o, njem penar bu ora hinj bi. Embi ni njen anda bor bao barabon ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ngub kisaol obum penar bu ora hinj bi mbabur obun kone bor turi aondao bu ora homaokl homaokl, obum obun anda bor Njises mbao ko kemi pisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ngo tomb tenaol ngo hasmi baebenom ngub pisbil hondobur makl aondao ora homobur kakl, Njises ke ngo obu mone takis mu khorob biyao aol menden anda paolukl pe kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ngub bismi o Sakiyasom teka habur Aorao Aondao bor kakl, Aol aondao o pangal. Nao osisao baeben hambun sao tom kab bu taol bu kobabur, tom mende nim tenaol dimb menjao nao wi boroklme baebenon taol baklwao kisesa. Wakl kakl, Mende di nim aol mende bor kakla ko maobowabur mbinim osisao paes non bi muwao sao baeben di, ko makl mao ha oran san luklwao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ngub kisaol Njisesom Sakiyas obu bor kakl, Nje di Eberehemon sem ora hael ol, embi ngubi tomb Ngaorom tenaol njen anda ngon boroklme baeben hambun bu maoraokl kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Njisesom wakl kakl, Heneng ora Aolon Isi Ora obum tenaol mendbor bum haroklme baeben es bubur wakl bu muklbur ora ibisao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ngo tomb Njises obu Njurusalem teb sol sao hasaol, mbini tenaol obun angal ngo pango birismi nda baebenom Ngaorom maeb ha maomb bo hayao ub penar bu tenaol hambunom hondoklmao saol ko nen sabismisa. Ngub nen sabismil mbini bor angal mar bombor mend kao kalobur kakl, ");
INSERT INTO akh_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Aol aondao mend obun su wakl oboklbur o, mbinim obu aol wesmbao aondao ora mao haen ko obu su enderae mendel poklbur kisaon, ");
INSERT INTO akh_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","aol aondao ndam obun kongon bimi aol tobon kab mend ubuklub kobur, obum mbini bor mone so aol is su was ber pae mend, pao mend was kal kal bisao kisesa. Ngub bubur kisaon obum mbini bor kakl, Nim ini mone ngo njaokl pukl o, wakl ni oboklwao tomb inim mone asub baeben ora pone haen bisnis bu maemib ko hondokl oboklwao kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ngo tomb ngub bisao o tenaol su ngo bor paolismi baebenom mbinin aol aondao ngo obu bor nar wen ebe hende non bu ko aondao bu ora homobur, aol mendbor aol aondao ndan mama taol mi puklbur kobur kismin, aol ngo nao makl homeyom ngao, nje naon aol wesmbao nao haklesi ko kao kalokl puklub kismisa. ");
INSERT INTO akh_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ngub kismi o obu aol wesmbao ora hasaol, aol wesmbao ndam wakl obobur obum obun kongon bimi aol ngo obum mone kalisao nda baeben bor kakl, Inim asub baeben ora pone haen maemib ko hondon ubuklub kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ngub kisaol aol is mend obu mbakla ibisaomon kakl, Aol aondao o, njem mone so pao mend aol is su ber pae mend njisndisom bisnis buwao tomb, nim mone so aol is su ber pae was pao tobon kab oran pone haen muwao kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ngo tomb aol wesmbao ndam kakl, Nje nao kongon biyao aol ebe ora seneng, njem kang sao ngo oborob hondo ora maeb hari ub njem su tenaol sem tobon kab oran maomb bo hanin lowao kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ngo tomb obun kongon biyao aol is mende obobur kakl, Aol aondao o, njem mone so pao mend aol is su ber pae mend njisndisom bisnis buwao tomb, nim mone so aol is su ber pae was pao su oran pone haen muwao kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ngub kisaol aol wesmbao aondao ndam kakl, Njem su tenaol sem su oran maomb bo hanin lowao kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ngo tomb kongon bimi aol ndan is mend di obobur kakl, Aol aondao o, nim njen mone so aol is su ber pae pao mend ndis ngo bao uruklu e ol, nim mbes bobaem tanga pabur bao u haruklu kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kongon biyao aol ndam ngub kobur kakl, Nje aol buri ora habur, njem aol tangarom wimi sao hakl nje mirili nda. Tenaol tangarom ne we boweme o di njem bao was talale ndal, nim nje pakl homobur bao u buruwao kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ngo tomb aol wesmbao ndam kongon biyao aol ngo bor kakl, Nje kongon biyao aol kho ora hael. Nim njen angal ngo kalom ora njem khorob bisi ko te mao bembera hondon kal kisesa. Wakl kakl, Njem ni heneng ora aol buri ora habur tenaol menden osisao woroklme hakl mu, nim tenaol menden ne we bombae di talaoklao ko nen sobale sin, ");
INSERT INTO akh_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","nao mone ngo mendbor kond baen pone haen mun asub ko mbeng bor nao wisil, nim wakl obobur nao mone homaokl hae kang ngo was wakl murukl balem? kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ngo tomb aol wesmbao aondao ndam tenaol mendbor kongon biyao aol kho ngo hasaol teb sol hasmi baeben bor kakl, Mone so homaokl bi aol is su ber pae pao mend abo ngo bao u harekle o mubur, aol is mende mone so aol is su was ber pae pao tobon kab wi abo ngo mu kalaoklaob kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ngo tomb tenaol ngo hasmi baebenom aol aondao nda bor kakl, Aol aondao o, aol ngo obun mone so andub ora aol is su was ber pae pao tobon kab ebe wing, asub ko kal? kismi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ngub kismil aol wesmbao ndam kakl, Nim ini bor heneng ora kao njurukl, tenaol mondom menjao u harob sin, nim wakl tangar mendbor di kond ba kaloklwao. Ngub inj, mondom menjao nao wi harob sin, obum kang mend u buruklao o di wakl muklwao ora kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ngub kobur kakl, Nao saond bi hayem baebenom ni mbinin aol wesmbao nao ha ko nen sabeyem ngao, inim mbini ngo baeben nao elol kemi obobur pe paen lib kisao ko Njisesom angal mar ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ngo tomb Njisesom angal ngo kao peyaoklbir obu mbakla pen Njurusalem hareron pismisa. ");
INSERT INTO akh_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ngub pobur kismin mbinim su Betpasi hesa Betani kab teb so bor pobur kismin, harbor menden imbi Olib kismil, ngol pindib paesmi tomb obun man pange aol is kab mend ibi mbes puklub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ngub kobur obun man pange aol nda kab bor we kobur kakl, Ibim su isu ngo hendeyeb o enderae inj teb sol ora eng, ibim su and te ngo bor hondabur hondoklebi tomb ngol some dongi hondbao aondao and so so mend ngol indi mba haklaol hondoklebing, mbes aol mondom di nao ber hende yaong, ibim kolobur komae ubuklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Njisesom mbibi bor wakl kakl, Tenaol mondom ibi bor ne mubur ibim some dongi ngo asub buklbur kolekleb? kaem sin, ibim mbini bor ngub lowaebe. Aorao Aondaom obu buruklbur komakl puklub kaonaol, kaomukl ubuklub lowaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ngo tomb Njisesom obun man pange aol nda kab ngub puklub kisaol aol nda kab pisbisa. Ngub pobur kisbin Njisesom mbibi bor hambun sao we kisao nda ub was ebe hend waesbisa. ");
INSERT INTO akh_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ngo tomb mbibim some dongi hondbao nda kolakl hasbil some dongi ngon aorao baebenom mbibi bor kakl, Ibim asub ko some dongi hondbao ngo kolekleb? kismisa. ");
INSERT INTO akh_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ngub kismil Njiseson man pange aol nda kabom kakl, Aorao Aondaom obu buruklbur komakl puklub ka kisbisa. ");
INSERT INTO akh_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ngo tomb mbibim some dongi hondbao nda Njises hasaol kemi pisbi tomb, mbinim some dongi ngon mesaol mbinin lab lab baeben tuwis habur kismin Njises ngol ber kismisa. ");
INSERT INTO akh_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ngo tomb Njises obu some dongi ndan mesaol baoraoklbir pisaol, tenaol aondao ngo obu daol haru pibismi nda baebenom Njises obu poklao hareron mbinin lab lab baeben tuwis mba kimb bismisa. ");
INSERT INTO akh_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ngo tomb Njises obu Njurusalem poklbur teb sol sao har Olib ne hareron inin pisesa. Ngub pismi tomb obun man pange tenaol aondao ngo pismi nda baebenom turi aondao ora homo taom bu taokl pobur kismin, mbinim ko mend nao hindismi sao Njisesom bu hasao ub hondobur, Ngaor bor aondao bu ora tengiyu ko kaoya kismisa. ");
INSERT INTO akh_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ngo tomb mbinim angal aondao bu ora kobur kakl, Ngaorom imbi wi haen kisao aol ngo obu Naon Aol Wesmbao aondao ora yaol Aol ngo obu Aorao Aondao hayao bor hakl ebeneng Obu bor kaoya kem ora ko kaoya kismisa. Mbinim ngub kobur kakl, Ngaor obu yu heben habur Nao tenaol hambunon kone bor sisab bin laong Naom Ngaor obu aondao yubu ora hayao ko Kaoya kem ko aondao bu ora kaoya kismisa. ");
INSERT INTO akh_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ngo tomb Peresi tenaol mendbor tenaol andub ora ngo pismi nda darukl o bor pismi baebenom Njises bor kakl, Aol aondao o, njem njen man pange tenaol ngo baeben bor ngub nao laob ko, taolu lu hondo kao kismisa. ");
INSERT INTO akh_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Nim ini bor heneng ora kao njurukl, mbinim ngub nao ke men mbarim sin di, han ngo u pe haklom di wakl angal lemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ngo tomb Njises obu Njurusalem teb so po pindib pabur, su Njurusalem and lobokl lobokl aondao ngo bor hend men sabur kisaon obum de kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Obum ngub de kobur kakl, Embi bao ngon inim sub oborob ora hibi tibaen haroklme on harer hondo hakl baemin ebe ora sokl baonao o, embi ngubi tomb ngo be sao mupango sao wiyaol inim awis habur nao hendeyem kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Obum ngub kobur kakl, Mabor bao mend buklao on inin saond bi baebenom su and lobokl lobokl ngo bor ini is bombor ora di bongeyaokl nao poklemin, ha huwimb bu tu nda lukl oboklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Wakl kakl, Mbinim ini khorob ora lu bowes bubur lemin, mbinim inin hanom saond paeb mbuklu tu ndae ngo hakl bo kobaolu taokl hondabur, ini tenaol ngo baeben hambun ora lu bowes bubur, inin su and lobokl lobokl aondao ngo di haoru bowes bu su dokl nao peklemi kisesa. Ngub kobur kakl, Inim Ngaorom ini bu muklbur buklao ub nen nao saboklemil, mbinim inin han and bi ngon mendbor han sango mandaemol klao o di hond mend baondib munu bao win wa nao buklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ngo tomb Njises obu Ngaor Hen Moroklme Anda bor hondabur hindisaol, tenaol andub ora Ngaor Hen Moroklme Anda ngo bor osisao mari obo mone mubur bisnis bi hasmil, Njisesom mbini lu taol deraesesa. ");
INSERT INTO akh_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ngub bubur kisaon Njisesom mbini bor kakl, Ngaoron mbuk waebom ngub ke wiyao. Nao anda ngo ni bor kaoya lome anda hae lemi ke wiyao o, inim and ngo paes noklme aolon mupange anda non bi men mao korarmi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ngo tomb Njisesom Ngaor Hen Moroklme Anda ngo bor hor hambunon Ngaoron angal bib hobao sao ngub wiyao ko, tenaol hambunom pangen kao dund bi ha was hasesa. Ngo tomb Nju semon baolum aol aondao baeben di, mbinin man buwaloklme aol baeben di, mbini Nju semon maomb bo haroklme aol baeben hambun di, mbini ngo baebenom Njises pe paen luklemi on naom asub ora ib mao pa lem ko kar mba hasmisa. ");
INSERT INTO akh_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ngub bismi o Njisesom angal ngo ko hasao ub tenaol hambunom turi aondao bu ora homo pangobur men hakol ora bismil, Nju sem ngo baebenom obu luklemi on te es buwaesmisa. ");
INSERT INTO akh_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ngo tomb bao bombor menden Njisesom Ngaor Hen Moroklme Anda bor hondabur, Ngaoron Angal Bib Hobao Sao ora tenaol hambunom pangen kao kalisesa. Ngub bisaol Nju semon baolum aol aondao baeben di, mbinin man buwaloklme aol baeben di, mbinin maomb bo haroklme aol, aol kone wi baeben di ngo baeben Njises obu hasaol ibismisa. ");
INSERT INTO akh_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ngub obobur mbinim Njises bor kakl, Njen buri ngo asub bi ora mondom ngo sao baeben bu hael? Njem ngo bu harili ub benin ko buri ngo aebom ora taol bu njisao? Aoh, njem ngo sao baeben aem bibi ko kao njisao ub ora bu hael? Njem nao kao nji kismisa. ");
INSERT INTO akh_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ngo tomb Njisesom mbinin angal ngon ko san lubur kakl, Nim di ini bor angal bombor sao mend ne mun ub inim ni kao njibaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ngub kobur kakl, Njonom mbabtas bu hasao ub Ngaorom bi kisao ub bu hasao be? be? obum baehaemen sul aol henengom bimi ub bu hasaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ngub kisaol mbini hakl hakl naom asub ora kem kao kao bubur kakl, Nao Ngaorom bi kisao ub bisao lomao tomb, obum nao bor inim asub ko Njonom ngo kisao ub oborob pango angal ngol hul ha nao hasmib? lao. ");
INSERT INTO akh_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Aoh, naom Njon obum sul aol henengom bimi ub bisao lomao tomb di, tenaol ngo hayem baeben hambunom di Njon obu Ngaoron man mini aol hasao ko ora hendeyem ol, mbinim nao hanom luklemi kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ngo tomb mbinim Njiseson angal ndan ko san lubur kakl, Njonom mbabtas bu hasao ub ngom bibi kisao ko, nao nao hende kismisa. ");
INSERT INTO akh_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ngub kismil Njisesom mbini bor kakl, Nim di inim ngo lem ub was, nim hambun sao ngo bu haruklu e ub aol ngon burim bu haruklu ko inin nao kao njuklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ngo tomb Njisesom tenaol hambun bor angal mar bombor mend kao kalobur kakl, Aol mondom obun waen il em bombor mend bowisesa. Ngub bobur kisaon obun waen il em ngo aol mendbor bisnis kongon bimi baeben bor maeb hakaklwaebe kaoklbir kisaon, em aorao ngo obu su enderae ora mendel pobur ngo bor bao hasesa. ");
INSERT INTO akh_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ngo tomb mabor waen il nda naeb sisao tomb aol em aorao ndam obun kongon biyao aol is mend, obun waen il em ngo maeb haroklme aol nda baeben hasmil, obun waen il ngon mendbor waklemi ko nen sabobur kisaon, makl pu kisesa. Ngub kisao o waen il em kongon bimi aol nda baebenom em aoraon kongon biyao aol nda khorob ora lubur kismin, waen il ndan mend em aorao ngon nao waebur baehaemen pu kismisa. ");
INSERT INTO akh_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ngo tomb wakl waen il em aorao ndam obun kongon biyao aol is mende mbini hasmil pu kisao o, mbinim ngo di khorob ora lubur kismin, obu di em aoraon waen il mend nao wae baehaemen pen kismisa. ");
INSERT INTO akh_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ngub was bismil waen il em ngon aorao ndam wakl obun kongon biyao aol is tebo di, waen il em kongon bimi aol nda baeben hasmil pen kisesa. Ngub bisao o mbinim obu di em paeb dera nan lu turaesmisa. ");
INSERT INTO akh_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ngo tomb ngub was bismil em aorao ndam nim asub ora bun kobur kakl, Ni hende ora. Nao isi kuwis akl bombor ora nim kone uruklu o obu pen lowao tomb mbinim obun angal non ebe pangoklemi ko pangakl kisesa. ");
INSERT INTO akh_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ngo tomb aol waen il em maeb hasmi nda baebenom em ngon aoraon isi ora o ibisaol hindismi tomb mbini hakl hakl kakl, Aol ngo obum obun abon wiyao sao baeben hambun sao obum was maeb habur, waen il em ngo naom maeb hayom o di obun ora soklaong, waen il em ngo di naon ora sen ub obu penar bu pe paen lem kismi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ngo tomb mbinim obu di lubur kismin waen il em ngon paeb dera nan lu turaesming, aol em aorao ndam obun waen il em maeb haroklme aol ngo baeben bor asub buklao ko nen sabeyem ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Njisesom ngub kobur kakl, Em aorao ndam obobur laon obun waen il em maeb haroklme aol ngo baeben pe paen lu tuwabur, obum obun waen il em ngo aol tangar mendborom maeb haen lao ko Njisesom angal mar ngub kao kalisesa. Ngo tomb Njisesom angal ngo kisaol pangismi nda baebenom kakl, Isalem. Ngub nao bin ko nen sabeyom kismisa. ");
INSERT INTO akh_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ngub kismi o Njisesom mbini elom hondobur kakl, Ngaoron mbuk waeb bor ngub ke wiyao. And kongon bimi aol baebenom And ndaol dokl mend kang kho e ko nen sabobur Tuwaesmi o wakl ngubi tomb And pinj* tao tao aondao hobao sao ora men aolisao ke wiyaong, angal ngon te asub wiyao ko nen sabeyem? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ngub kobur wakl kakl, Aol mondom and pinj ngo bo kaolu bowes buklwao ko nen soba sin, aol ngub nen saboklao ngo obun toklo baklu bowes buklao kisesa. Mende di and pinj ngom aol is menden toklol kar hakl po tibarob sin, ngo di obun toklo lu hesu bowes ora buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ngo tomb Nju semon man buwaloklme aol baeben di mbinin baolum aol aondao baeben di mbinim ora hindismil, Njisesom mbini bor ora angal mar ngo kisaol, mbinim obu ngo ora tomb bao men haklbur bismi o tenaol obun angal ngo hem ko pangismi baeben andub ora hasmil, pakl homobur mbinin kone bor saor peyo bao waesmisa. ");
INSERT INTO akh_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ngo tomb Njises obum oran khorob kang ora di asao was bib ko hondo habur kismin, mbinim aol mendbor Njises hasaol obu hondo mao bemberakl puklub kismisa. Ngub kismil mbinim sub bibir aol non bi ora pobur, mbinim Njisesom angal kang mend khorob sao dim ka sin, mbinim obu men habur mbinin maomb bo haraoklao aol aondao birisaol men pae po, obun el sol teka haen ko howes koklbur ibismisa. ");
INSERT INTO akh_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mbinim ngub obobur Njises ne mubur kakl, Aol aondao o naom di nje ora hendeyom, njem angal di oborob was kale. Njem tenaol hambun bor di Ngaoron man oborob was kao dund bu harili. Njem aol aondao imbi wi haroklme baeben di pakl nao hemebur, Ngaorom nen sabeyao ub njem heneng ora tenaol hambunom pangen kale nda kismisa. ");
INSERT INTO akh_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ngub kobur mbinim Njises bor kakl, Njem asub ora nen sobal? Naom Orom semon aol wesmbao aondao Sisan mone takis moroklme aol baeben bor takis kalemin be? njem nao kalemin ko pangal? Naon manom asub ke wiyaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ngub kismi o Njisesom mbinim obu maobowabur ngo kismi ub ora hindisaol obum mbini bor kakl, ");
INSERT INTO akh_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Inim ni mone il bombor mend hondon ub muwaloklaob kobur kakl, Mone il ngon piksa ngo wi o hesa imbi ngo wi o kab aeben non bi eb? kisesa. Ngub kisaol mbinim obu bor kakl, Orom semon aol wesmbao aondao Sisa ndan non bi e kismisa. ");
INSERT INTO akh_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ngub kismil Njisesom mbini bor kakl, Ebe ka. Sisa obun sa sin obu ora kaloklwaebe. Ngub inj, Ngaoron menjao sa sin Ngaor kaloklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ngo tomb mbini aol ngo Njises obun angal men mba obum khorob sao menjao ka sin te mao saraklbur ibismi nda baebenom, Njises obum tenaol hambunon el sol angal ngo kisao nda pangismi tomb burir aondao ora biyubur kismin, e beb nao ke ne taombukl mbaesmisa. ");
INSERT INTO akh_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ngo tomb Sarusi tenaol baebenom tenaol pe paklemi baeben wakl ko mende nao enjoklemi kismi ub kobur, Sarusi sem ngo baebenon mendbor Njises obu hasaol obobur mbinim obu bor ne mubur kakl, ");
INSERT INTO akh_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Aol aondao o, mbes Mosesom nao bor angal ukl mend ngub bibaebe ko waeb bu wisao ka. Aol mend obu ten taol buklao o nongnas is mend and nao senbur bao homa sin, ten weyae ngo obun haemem taol bubur, obun haeme ngo homoklao on nongnas maru waklao ora ko waeb bu wisesa ko mbinim Njises bor ngub kao kalismisa. ");
INSERT INTO akh_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Mbinim ngub kobur wakl kakl, Aol mbini haemeyaen is haoklao mend hasmil, mubao om obun ten taol bisao o obum nongnas is mend nao maru wisao tomb bao himisao kismisa. ");
INSERT INTO akh_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ngo tomb ngub bisaol ten weyae ngo obun haeme kabo nanom taol bisao o, ngo di nongnas is mend and nao se tomb bao himisesa. ");
INSERT INTO akh_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ngo tomb haeme is tebo nanom ten weyae nda taol bisao o, ngom di nongnas is mend nao maru wisao tomb ngub was himisaol, ten weyae baram aeben bisao ngo mbini haemeyaen is haoklao ngo baeben hambunon were sisao o, nongnas is mend and nao sen was hambun himismi kismisa. ");
INSERT INTO akh_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ngo tomb mabor ten ngo obu di himisao kismisa. ");
INSERT INTO akh_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mbinim ngub kobur Njises bor wakl kakl, Njem tenaol heme baeben wakl enjoklemi kale nda ub enjoklemi tomb, ten weyae baram aeben bisao ngo mbini aol is haoklao haemeyaen ngo baeben hambunom taol bisming obu aeben were ora soklaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ngub kismil Njisesom mbini bor kakl, Tenaolom ngubi tomb ngo bao hayem aeben anga tomb non, tenom di aol po aolom di ten taol bu ngub ngo bu hayem o kisesa. ");
INSERT INTO akh_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Wakl kakl, Ngub beyem o Ngaorom tenaol ngo wakl ebe enjoklemi keyao ub, mabor mao enjaklaol haeben saklemi baebenom aolom ten taol bu tenom di aol po ngub nao buklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Njisesom wakl kakl, Mbini Ngaoron angal mini wesao non bi ora habur mbini ko mende nao homoklemi. Heneng ora tenaol homokelmil maol buklemi o Ngaorom wakl mao enjaklao baeben obun isi wane ora haklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ngub kobur kakl, Ngaorom tenaol pe pae wakl mao enjaraoklaon arman, inim Mosesom ngub hendeklemin kao dund bu muwalisao. Moses obum is hini bor sung disao nda bor Ngaorom kisao ub arman waeb bubur kakl, Aorao Aondao obu Eberehem di Isak di Njekob di ngo himismi baebenon Ngaor ora yao kisaol, angal ngo mbes Mosesom waeb bu wisao ub Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Wakl kakl, Ngub kisao o Ngaorom nen sabaoklao ub tenaol himismi baeben hambun nao heme enjo haemel, obu tenaol pe pabur songol bung biyao sao baebenon Ngaor inj, wesao pobur haeben soklme baebenon Ngaor ora hayao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ngo tomb Njisesom mbini bor angal ngo kao paesao tomb Nju semon man buwaloklme aol mendborom obun angal ngo kisao ndan ko san lubur kakl, Aol aondao o, njem angal ebe ora kal kismisa. ");
INSERT INTO akh_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ngo tomb mbinim wakl ko mende menjao ne di nao mi pakl homobur bao waesmisa. ");
INSERT INTO akh_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ngo tomb Njisesom mbini bor kakl, Mbini mendborom asub ko Ngaorom Eben Lao Aol o obu Debir semon isi soklao lomeb? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ngub kobur kakl, Kaoya We Lome mbuk bor Debir obun mbib ngub waeb bu wisao. Hambun Saon Aoraom nao Aorao Aondao bor kakl Ngubi tomb njem nao ki tao nan bao berel o ");
INSERT INTO akh_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Mabor njen saond bi baeben Njen aongao ma bundur nan Hala mbanin lowao tomb Mbini njen aongao mao aolarili to Non bi soklao kisao ko Debirom waeb bu wisao ub Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ngub kobur kakl, Debir obun mbib nao Aorao Aondao kisaong, mbinim asub ko Ngaorom Eben Lao Aol bor Debir semon isi heneng soklao lomeb ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ngo tomb tenaol hambunom ngol bao was habur kismin, Njisesom angal ngo kisao o pango hasmi tomb mbini hambun ngub bao haenbur obum obun man pange baeben bor kakl, ");
INSERT INTO akh_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Nju semon man buwaloklme aol ngo baebenom lab lab ebe saoll saoll on was samobur, ebekone po akol akol bukl ndao pobo haroklme. Ngub bubur lomen mbinim tenaol hambun obo kiril mba boroklme su o bor ebekone po, mbini bor kaoya ken ko mbinim tenaol hambunon el sol ki seken buklemi on was turi homo haroklmeng, inim oborob hondo ora haklwaebe kisesa. Ngub kobur kakl, Mbini ngo baebenom mbinin man pangoklme anda bor tenaol hambunon el so panda tukun ebe ol was turi homo burukl ndao was pobobur, mbinim ne aondao mend noklbur bereme tomb di mbinim pand tukun was mu pakl ke ke bimi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Wakl kakl, Mbinim ten mendbor mbinin aoli heme baebenon and di mbinin osisao baeben di taol pe mu habur lomen, kakla mbinim khorob ngo beme saon pe kowes bubur, tenaolom mbini ebe hae ken ko Ngaor bor ko soklo aondao bu ora ko haroklme. Mbinim ngub bimil Ngaorom tenaol hambun sarbeklao tomb mendborom ke hondoklemi ub men mbabur, mbini ngo baeben ke aondao bu ora hondoklbur hayem ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ngo tomb Njises obu Ngaor Hen Moroklme Anda bor burubur, obum Ngaor bor kalo mone tu ndaroklme be wisao bor hindisaol, homa tenaol mone andub maru u hasmi baebenom mone aondao bu ora tundakl engel bismil hindisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ngo tomb obum ngub hondo birisaol, ten weyae obun aoli heme kang mondom obu mone kang ora di nao wi birisao o, obum hondo birisao bi mone hundbi kang hond kab mend tu ndaesaol hindisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ngub hondobur kakl, Nim ini bor heneng ora kao njurukl, ten weyae mango biri obun aoli heme kang ngom mone hundbi kang ngo tu ndaraokl om, tenaol hambunom mone aondao ngo Ngaor bor kalaemnda baeben hambun ora men mbaraokl kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ngub kobur kakl, Tenaol aondao ngo baebenom mbinin mone andub ora maru u habur, naom aondao ngo maru u hayom sao kobur mendbor Ngaor bor kalaemnda o, ten weyae mango biri kang ngo obum non obun mone nao wi ora burubur o, obum kang mend u baoraoklao baeben oran obun ne dob bu nokl bi di kang mend nao baondib mini, hambun ora ngo tundaraokl o kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ngo tomb tenaol mendborom Ngaor Hen Moroklme Anda ngo nen sabobur kakl, Ngaor Hen Moroklme Anda ngon mbinim han aondao haklom oborob hendaebe turi bi ub ora bubur, mbinim Ngaor bor di osisao hakl oborob ora kaloklme kao kao bismisa. Ngub kismil Njisesom angal ngo pangobur kakl, ");
INSERT INTO akh_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Inim ngubi tomb ngo hendeyem sao baeben mabor bao mend buklao on mbinim han sango menden mandaemol di hond men baondib munu bao win wa nao buklemi ora. Ngub inj, mbinim and ngo hakl hambun ora bo kobaolu bowes buklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ngo tomb mbinim Njises bor ne mubur kakl, Aol aondao o, njem ngo buklao kal o sao hakl atomb ora buklao? Njem ngo buklao kal sao baeben buklbur buklao tomb, naom pibnao oran asao ora buklaol hondobur njem ngo buklaol kaendisao baeben teb saol ko pangoklmaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ngub kismil Njisesom kakl, Mendborom ini maobowabur kakla lemi hondo ora haklwaebe kisesa. Wakl kakl, Aol andub ora ini haklemil obobur, mbinim ni hae non bubur lemin ni Ngaorom Eben Ke Aol ora hae lemi kisesa. Mbinim ngub kobur lemin hambun sao buklao on mbes teb sa lemi kisesa. Mbinim ini bor ngub lemi o heneng lem ko nen sabobur, inim mbini nao taol mi puklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Njisesom wakl kakl, Inim mabor saond aondao ora bubur daoklu lili beyeb ke pangokleming, inim pakl homo burisao pen nao boroklwaebe kisesa. Ngub kobur kakl, Nim ngo kakl sao mbes buklao o, mabor bao bu kowes buklao o nao pindib pae wen soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ngo tomb Njisesom wakl kakl, Aol sem tangar mondom sem mende saond bu kaloklao. Ngo tomb kabman semom di sem mende bor saond bu kal kal buklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ngo tomb su dull bere aondao ora oboklao kisesa. Ngo tomb su mendbor di de aondao ora oboklao. Tenaol mendbor di sen tangar tangar habur pe paraklemi. Ngub buklao tomb tenaol burisao po paklmao homaraoklao sao di andub ora buklaol hondoklemi tomb, yu saoharol menger tangar tangar ubi di aondao bu ora mao baklaol hondoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Njisesom ngub kobur kakl, Nim ngo buklao kakl sao baeben mbes nao bi haenbur, mbinim ini bor howes ko lu bowes buklbur ini men haklemi. Ngub bubur lemin mbinim ini mbinin man pangoklme anda bor men pae po howes kobur kalabus mao palaklemi kisesa. Wakl kakl, Mbinim ni ora men mbaklwao ko nen sabobur lemin mbinim ini aol wesmbao baebenon el sol mini po mao habur, kabmanon maomb bo haroklme aol aondao baebenon el sol di mini po mao haklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Njiseson ngub kobur kakl, Mbinim ini bor ngo buklemi ub inim mbini bor nao Angal Bib Hobao Sao nda kao kaleklemin ko ora buklaong, inim angal ngo mbini hambunom pangen kao kaloklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Njisesom ngub kobur kakl, Inim mbinin angal asub was ko san luklmaob ko, inin kone bor es es bu nen nen nao saboklwaebe ora. ");
INSERT INTO akh_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Aoh, bombor ngo ora tomb ninao mbib inim angal oborob ora lemin kobur lowaon, inin kone bor di oborob ora kikil mao baklwao kisesa. Wakl kakl, Nim ngub buklwao tomb inim aol ngo ini ko homo howes lemi baeben bor, nim ini bor angal ngo kao njuklwao ub lemi tomb mbinim inin angal ngo men mbabur ko san lukl buwaklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Njisesom ngub kobur kakl, Inin ingi aorao baeben di, inin aorao haeme baeben di, inin sem baeben di, inin tenaol sango baeben di, mbini ngo baeben hambunom ini karu luklemil, mbinim ini ngo haklon mendbor pe paen luklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ngo tomb Njisesom wakl kakl, Inim nil hul ha haklemil tenaol hambunom ini hendaebe makl aondao ora homobur, nar wen ebe hende non buklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ngub kobur kakl, Ngub buklemi o inin wesmbao iri kang ukl bombor ora o di nao pundi hakl poklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Wakl kakl, Heneng ora ini haeben ora sokleming, inim hul ha saor pe haklwaebe ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ngo tomb Njisesom kakl, Inim mabor hondoklemil su Njurusalem ngo bor ami semom obo ha akol baem sin, su Njurusalem and lobokl lobokl aondao ngo haoru bowes bu lu taoluklemi o pen ngo teb saol ko nen saboklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ngub kobur kakl, Ngub buklao tomb tenaol mendbor su Njuriya bor buruklemi baeben yu har ne baeben bor pakl paokl puklwaebe. Ini tenaol Njurusalem bor buruklemi baeben di su and lobokl lobokl ngo tuwaklbir lemin, su tangar tangar bor pakl buri lowaebe ora. Ini tenaol mendbor su and lobokl lobokl ngon dera dera haklemi baeben di, su Njurusalem ngo bor wakl nao ubuklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Wakl kakl, Ngo ora tomb ngo buklao sao Ngaorom obu bor khorob bimi on san luklaol, Ngaoron mbuk waebom ngub buklao ke wiyao ub heneng ora il so pind biklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ngub kobur kakl, Is ora alem. Ngo sao buklao tomb ten mendbor hondbao pango uklemi baeben hesa nongnas aondu ne baeben kab oran hond bu pae delib ebe ora soklao kisesa. Wakl kakl, Su ngo bor ke aondao bu ora ngo henden lao ub mbinim obu bor khorob was bimil ko homo haraoklao ub ora buklaol, Ngaorom tenaol ngo baeben bor ngo ora tomb ke aondao ora ngo ngub henden lao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ngub kobur kakl, Mbinim tenaol mendbor kuwim was bo komb barabur lemin, mendbor su hambun bor kalabus mao palaklbur men pae buri lemi. Ngub buklemil Ngaorom Tenaol Sem Tangar baeben su ngo bor ngub baeben ora haklemi ko nen sabeyao ub ora nao se aeben anga tomb, mbinim su Njurusalem ngo aongaom bao hala haklemi ora ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ngo tomb Njisesom kakl, Mabor nar bor di, ek bor di, saosolbaem bor di, ngo sao hakl bor tenaolom burir biklme sao tangar tangar andub sao buklao kisesa. Ngub buklao tomb sun tenaol sem tangar tangar ngo su hambun bor paoleyem baeben hambunom, ib kunjam aondao bu ora lu dengno taokl en aeben bubur u aondao bu ora laol hondobur, mbinim burir aondao bu ora biyu mbinin kone bor kho so burisao po u poklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Wakl kakl, Tenaol hambunom saoharol buri wiyao sao baeben di buri nao pale dur kobur demi ora men koroklaol hondoklemi. Ngub hondoklemi tomb mbinim su hambun bor wen ngo buklbur buklao sao hondo habur, mbinin kone bor burisao po pakl aondao ora homobur pe pae non bi haklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Njisesom ngub kobur kakl, Ngo sao baeben buklao tomb Aolon Isi Ora obu mulaol darukl oral oboklaol hondoklemil, obu buri paolaoklbir nar el sao bao bi hakol bi ora oboklaol hondoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ngub kobur kakl, Ngo sao baeben hambun sao wen buklbur buklao tomb Ngaorom ini men muklao o teb soklaong, inim turi homo as ko hul ha saor pe haklwaebe ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ngo tomb Njisesom mbini bor angal mar bombor mend kao kalobur kakl, Inim is dullub di, is tangar sao hakl di ma biyao nda ub menger ngo nen saboklwaebe. ");
INSERT INTO akh_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Inim is ngo baeben hendeme tomb inim ngub lome. Is ma wen bu kimb beneng, ngubi tomb nar eben sene lome kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ngub kobur kakl, Menger bombor ngub mubur inim nim o kao njandisao baeben buklaol handaem sin, Ngaorom maeb ha maomb bo haklao ub teb se ko nen saboklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Njisesom ngub kobur kakl, Nim ini bor heneng ora kao njurukl, tenaol ngubi tomb hayem baeben nao heme bao haen was, nim ini bor ngo buklao kandisao baeben buklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ngub kobur kakl, Su di saohar di mabor hambun sao bum haklao o, nao angal bombor o nao bum hae wi aeben soklao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ngo tomb Njisesom mbini bor wakl kakl, Inim ne noklemi on was kone u, he soklme ib nobur he so, inim sun woroklme saon was hem kao hakol bu, inin kone peyao bor pen haklemi tomb Aolon Isi Ora obu obokl buklao bao on teb soklaol, penar bu ora obo pindib pae soklaong inim oborob hondo ora haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ngub kobur kakl, Bao ngon oboklao tomb henes maklme saom henesom nao hendenbur penar bu ora laoraoklao nda ub, su hambun bor tenaol hambunom nao hende haklemi tomb penar bu ora pindib paklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Wakl kakl, Inim hor hambunon oborob hondo ora habur lemin, Ngaorom ini bisur bu buri mao paolaen ub obu bor kao kal ha was haklwaebe kisesa. Inim ngub buklemi tomb hambun sao mabor ngo buklao sao baebenom ini ke nao mao hendae bongeyaokl po as ko ora haklemil, inim Aolon Isi Oran elol turi homo teka haklemi ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ngo tomb Njisesom bao hor hambunon Ngaor Hen Moroklme Anda on honda was bubur tenaol hambunom pangen Ngaoron angal bib hobao sao kao dund bi was bu habur kisaon, somna nend kisao tomb harbor menden imbi Olib ne bor was paolukl pu was bu hasesa. ");
INSERT INTO akh_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Njisesom ngub was bu hasaol tenaol hambunom Ngaor Hen Moroklme Anda ngo bor hokloben was obo kiril mbabur kismin, Njisesom angal bib hobao sao ngo kisao ub pango ber was bismisa. lo nda sul mu pabur obum lab lab haek bi ebe ora mondom tanga pabur kisaon, mbes obum han te bombor mend waru u mbaesaol, han te ngo bor mbes di aol is mend nao maol bismi o sisaol, ngo bor maol bisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ngo tomb bao menden imbi Nju semon palawe and mao saraoklao sao yis nao haru noklme hor so kismil, imbi mende Waran Aeben Bisao hor so kismi o bao ngo teb sisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ngo tomb Nju semon baolum aol aondao baeben di, mbinin man buwalokme aol baeben di, mbini tenaol Njisesom angal ko hasao ub hem ko pangismi nda baeben pakl homobur, mbini hakl hakl sub kar mba habur kakl, Naom Njises ora hel asub ora bubur lu tuwaem ko sub kao kao pismisa. ");
INSERT INTO akh_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ngo tomb Njises man pange aol is mend obun imbi Njuras obun imbi mende Iskeriyaor kismil, obu Njiseson man pange aol duteb nan o sisao o, Seranom obun kone bor hondaesesa. ");
INSERT INTO akh_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ngo tomb aol Njuras ngom Nju semon baolum aol aondao baeben di, Ngaor Hen Moroklme Anda maomb bo haroklme aol baeben di, ngo baeben bor obum Njises men pae puklub lao on sub kar kobaesmisa. ");
INSERT INTO akh_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ngo tomb Njurasom ngub bisaol Nju sen Njises lukl bu hasmi nda baebenom turi aondao ora homobur kismin, mbinim Njuras mone kaloklemi on di, naom ngub baeben ora kalemin ko kao paesmisa. ");
INSERT INTO akh_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ngo tomb mbinim Njuras bor naom mone ngub njuklmao kismil, mbinim ngo kismi ub pango e kobur kisaon, obum mbini bor Njises men pae puklub lao on asub ora man man bun ko nen sabobur kisaon, Njisesom tenaol hambun nao haru, obu hungum oran atomb ora pon paraokl ko hondo hasesa. ");
INSERT INTO akh_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ngo tomb palawe and mao saraoklao sao yis nao haru noklme bao o pindib paesaol, mbinim Waran Aeben Bisao bao ngo pindib pa was bisao tomb some sib hondbao is mend lu sa was bismi bao on sisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ngo tomb Njisesom Pita hesa Njon kab puklub kobur mbibi bor kakl, Naom Waran Aeben Bisao hor son ne nemin ub man man bukl puklub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ngub kisaol mbibim Njises bor kakl, Njem ngo kal ub yaom abor ora man man baobun ko nen sobal? kisbisa. ");
INSERT INTO akh_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ngub kisbil Njisesom mbibi bor kakl, Pangekleb. Ibim su and lobokl lobokl ora bor poklebi tomb aol is mend obun ib be aondao mend taoklbir ibi hen mukl harerol ubukl haklaong, ibim aol ngo obu poklao ub was taol mi pobur lebin, and ngo aol ngo obu hondaklao on haru haru hondaklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ngub kobur kakl, Ibim and aorao ngo bor ngub lowaebe. Aol aondaom nje bor nao man pange aol baeben daol haru Waran Aeben Bisao hor son ne noklmao o, ninao and tubal awon ne nklmaob? ka lowaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wakl kakl, Ibim ngub lebi tomb obum and tubal yu mandaem nan o bor, panda nao buruklmao on di hambun sao oborob ora man man bu mbae aondao ora mend ibi muwaloklaong, ibim and tubal ngo oran ne nemin ub man man bibaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ngo tomb Pita Njon kab pisbil Njisesom kisao nda ub hend wabur kisbin, obum kisao nda ub Waran Aeben Bisao bao ngon ne noklemi on man man bu mbaesbisa. ");
INSERT INTO akh_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ngo tomb mbinim ne ngubi ora tomb nemin ko kao paesmi ub, Njises obu obun angal bib hobao sao kam akol bimi aol nda baeben daol ne noklbur birismisa. ");
INSERT INTO akh_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ngub birismil Njisesom mbini bor kakl, Nim mabor ke hondo tanda aondao ora noklwao ub nao bi tomb, naom Waran Aeben Bisao bao ngon ne ngo naoklao ub oran ko mend nemin ko nen sabobur, hem aondao ora kaklo kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ngo tomb Njisesom mbini bor kakl, Nim ini bor heneng ora kao njurukl, naom Waram Aeben Bisao hor son ne ngo naoklaom ub, nim ko mende nao ne han was Ngaorom maeb ha maomb bo hayao bor inim naom ne ngo naoklaom on te hondo perekle beklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","20","Ngo tomb mbinim ne ngo nao paesmi tomb Njisesom ib waen ber pae kab tokl mend mubur, obum Ngaor bor tengiyu ko kaoya kao peyobur, inim ib waen ngo mubur no kalam aeben aeben bib ko kalobur kakl, Ib waen ber pae kab ngo nao ibao ora yaol, Ngaorom tenaol hambun bor nim heneng ora buklwao kisao sao wen pange, nao ibao ngom ini hambun bisur bubur peben karukl kisesa. Ngub kobur kakl, Nim ini bor heneng ora kao njurukl, naom waen il ibao ib ngo naoklaom on nim ko mende nao ne bao han was, Ngaorom maeb ha maomb bo haklao tomb ora noklwao kisesa. Ngo tomb Njisesom palawe pao mend mubur kisaon bombor ngo bisao ub was, obum Ngaor bor tengiyu ko kaoya kao peyobur obum munu konde barabur, obun man pange nda baeben taol bu kalobur kakl, Palawe ngo nao toklo njurukl ol ngom ini bisur bin ko njurukl ngao, inim ni aokl nao hemen hareklemin ub inim nao toklo ngub nao ha was haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ngo tomb Njisesom wakl kakl, Haondaoklaob. Aol ngo ni hesa yao haru ne nakl wiyaob o obun ni karu lubur, mbinim ni lin ko ni lukl buklemi aol baeben munu kaloklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Wakl kakl, Heneng ora Aolon Isi Ora obu non mbinim ngub luklemil, Ngaorom obu harer ngon poklao ko nen sabeyao on ora poklao o, aol ngo obu Aolon Isi Ora karu luklao aol o ke aondao bu ora hondoklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ngo tomb Njisesom ngub kisaol obun man pange nda baebenom burir bi munubur mbini hakl hakl ne mi mi bubur kakl, Ngub aebom buklaob? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ngo tomb Njiseson man pange aol nda baebenom mbini hakl hakl ab saond bi bi bubur kakl, Naon maeb haraoklao aol aondao oran aeb haklaob? ");
INSERT INTO akh_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ngub bismil Njisesom mbini bor kakl, Mbini su sem tangaron aol wesmbao haeme baebenom tenaol hambun buri palo oborob ora maomb bo haroklmel, tenaol hambunom mbini ngo baeben aol ebe ora imbi wi mend haroklme ndabi hayem ko kaoya ko haroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Wakl kakl, Ngub bimi o inim ngub nao bibaebe ora. Ini ngo hayem haklon is mend nje aol aondao imbi wi ora hael sin, nje imbi nao wi kang ora men koro baebe. Ini ngo haklon is mend nje maomb bo haraoklao aol hael sin, njem tenaol mende bisur biyao aol men koro haebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ngo tomb Njisesom kakl, Imbi wi aondao ora aeb hae? Aol ngo ne no bere o obu e be? be? ne kongon biyao aol ngo ne menae obaok o obu e bo? kisesa. Wakl kakl, Aoh, aol ngo ne no bere o obu ora imbi wi hae ka. Heneng ngub imbi wi ora hae o ni imbi wi hae ub men mbabur, nim inin kongon biyao aol men aolubur ini ne taol bu nju haruklu nda kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Njisesom mbini bor wakl kakl, Mbes ni bor menjao menjao buklbur bisao saom ni ngub ke mao handaklbur bisao tomb di, ini ngo baebenom oran ni haru was habur ni nao tuwaroklme nda kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Njisesom ngub kobur kakl, Nao Abom nim maeb ha maomb bo han lao ub nim inim di bombor ngub was maeb hareklemin lowao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ngub kobur kakl, Nim tenaol hambun maeb ha maomb bo haklwao tomb mabor ini di nao haru ne no ib no buruklmao ora kisesa. Wakl kakl, Inim ngo tomb aol wesmbaon maomb bo haroklme on seyal burubur lemin, inim Isreyel tenaol sem duteb o te mao bembera sarbeklemi ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ngo tomb Njisesom Simon Pita bor kakl, Simon o pangal. Seranom ini obun hareron kemi poklbur ora hayao ub Ngaorom di ngub bin waklaong, obum ini is il sao sarbe mib bu mu noklao hondo ora haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Njisesom ngub kobur kakl, Ngaorom njen kone bor buri mao pala, njem hul ha saor peyo was hanin ken ko nim obu bor kao kalowao ora. Ngub buwaol njem wakl kone u bokeyobur obul hul ha haklesi tomb, njem njen Karas haeme baeben hambunon kone bor di hul ha saor peyo was haen kaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ngub kisaol Pitam obu bor kakl, Aorao Aondao o, mbinim nje kalabus men pae poklemi bor yao haru men pae pen ko ora hae ol, mbinim nje laem sin di yao haru ora homabon ko ora hae kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ngub kisaol Njisesom kakl, Pita o nim nje bor heneng ora kao njurukl, bao somna ngon sao kulao angal nao bi haen was, njem ko teb oran nim Njises nao hendeyo lesi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ngo tomb Njisesom mbini bor kakl, Mbes nim ini bor angal bib hobao sao kam akol bukl puklub kobur, inin mone bawis di nu di aongao su di hambun sao nao mini ora puklub kondis tomb, inim ngo nao mari puklwaebe kondis haklon bombor sao mend nao wisaol menjao wa win hasmi be? kisesa. Ngub kisaol mbinim obu bor kakl, Inj, menjao wa nao wisao kismisa. ");
INSERT INTO akh_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ngub kismil Njisesom mbini bor kakl, Ngubi tomb mondom obun mone bawis maru harob sin, obum ngub bao maruklao ora. Mondom di obun nu maru harob sin, ngo di ngub bao maruklao ora kisesa. Wakl kakl, Aol mondom kuwi nao mini harob sin, obun toklo and turub bi om mone mubur mone ngom wakl kuwi tokl mend dob buklao om kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ngub kobur kakl, Nim ini bor heneng ora kao njurukl, Ngaoron mbuk waebom ke wiyao ub mbinim ni aol el kaol kaol ko khorob bimi baeben hesa maominin lemi ke wiyaol, angal ngo wiyao ub ngubi tomb ni bor heneng buklao ora. Ngub buklaol heneng ora Ngaoron mbukl waeb baeben hambun bor ni bor ngo buklao ke wiyao ub ngubi tomb oran ngo il so pind bile o kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ngub kisaol mbinim obu bor kakl, Aorao Aondao o hend. Kuwi kuwinj tokl kab ngo meneyom o kismisa. Ngub kismil Njisesom mbini bor kakl, Ngon ebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ngo tomb Njises obu dera pobur kisaon obum bu hasao nda ub har Olib manda bor pisesa. Ngub pisaol obun man pange aol baeben di mbini haru pismisa. ");
INSERT INTO akh_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ngo tomb yu ngo obu pokl bisao ndal po pindib paesao tomb obun man pange aol nda baeben bor kakl, Ini bor khorob mao bakl buklao saom ini khorob nao mao baen ub inim Ngaor bor kao kaloklaob ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ngub kaoklbir kisaon Njises obu kang mend aeben sao pobur, obum tumu kar munu dombes ubur Ngaor bor kao kalobur kakl, ");
INSERT INTO akh_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ab o njem ebe soklao ko pangal sin, njem ni ke hondoklwao ib karae bi ber pae kab ngo mu tuwaebe kisesa. Wakl kakl, Njem ngub mu tuwaebe o njem nim nen sobakl ub inj bibi ora. Ngub inj, njen mbib nen sabele ub ora bibi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ngo tomb Ngaoron angal mini wesao bombor mend yu heben hakl obobur, Njises obu hul ha saor peyo haen ko buri mao palaesesa. ");
INSERT INTO akh_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ngo tomb Njises obun kone bor burisao po kend aondao ora bisaol obum Ngaor bor buriyab ora kao kalisesa. Ngo tomb obu ke di kab po pob turub bu aoklaol aondao ora bubur, ibao sao pobo sul ndim ndaom kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ngo tomb obum Ngaor bor kao kal peyo teka peyaoklbir obun man pange aol nda baeben hasmil kang mend aeben sao pobur hindisaol, mbini hambun mbinin kone bor kho so kend aondao ora bin burubur enjmor ibisaol u paol pesmisa. ");
INSERT INTO akh_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ngub bismil hondobur Njisesom mbini bor kakl, Inim asub ko u paol pe hayem? Ngubi tomb ini bor khorob mao bakl buklao saom ini khorob nao mao baen ub inim pen tekabur lemin, Ngaor bor kao kaloklaob kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ngo tomb Njisesom obun man pange baeben bor angal ngub bao kakl haen was aol andub ora bombokl ibismisa. Ngo tomb aol Njuras obu man pange aol duteb nan o obu sisaol, aol aondao ngo ibismi bor obu mbakla ora obobur, Njises bor nunu ke non bu nunu koklbur ibisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ngub bisao o Njisesom obu bor kakl, Njuras o njem Aolon Isi Ora nunu bukl ebe non bubur karu liril be? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ngo tomb Njiseson man pange aol mendbor obu haru hasmi nda baebenom ngo buklbur bismi sao hondobur mbinim Njises bor kakl, Aorao Aondao o, naom aol ngo baeben kuwi kuwinjom was bo dengeno laomun wa kismisa. ");
INSERT INTO akh_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ngub kismi tomb man pange aol ngo haklon mondom Nju semon baolum aol wesmbao aondao oran kongon biyao aol is mend ngol hasao on hal ki tao nan o taokl bo kobaesesa. ");
INSERT INTO akh_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ngub bisao o Njisesom baolum aolon kongon biyao aol ngo lisao aol o bor kakl, Njem ngub nao bi bao wa ora kisesa. Njisesom ngub kobur kisaon aol ngo hal taokl bo kobaesao ndan halol ki tibaesao tomb, hal ngo taokl hakl pobo wisao nda wakl ebe sisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ngo tomb aol ngo Njises obu men hakl ibismi baeben, mbini Nju semon baolum aol aondao baeben di, mbinin Ngaor Hen Moroklme Anda maomb bo haroklme aol baeben di, mbinin maomb bo haroklme aol, aol kon wi baeben di, Njisesom mbini ngo baeben bor kakl, Inim kuwi kam dorokl mini mini obobur, inim aol menden osisao taol pe mu haraoklao aol mend men haklbur sao ubuklim be? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ngub kobur kakl, Nim hor hambunon Ngaor Hen Moroklme Anda bor honda ha was burubur, nim ini daol haru beremao tomb di inim ni nao men haroklme nda o, ngubi tomb non em hundur mao waraoklao saon burim ini aondao bu ora buri mao palaraokl ol, embin inin bao o ora pindib pael buklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ngo tomb Njisesom angal ngo kao paesao tomb mbinim obu men habur mini pismisa. Mbinim ngub men pae pobur kismin, Nju semon baolum aol wesmbao aondao oran anda bor mini pismisa. Ngo tomb Pita obu mbinim Jises mini pismi bor mama taol mi pisao o, obu kang mend enderael sao pisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ngo tomb tenaol mendbor baolum aol wesmbao aondao ndan anda ngon paeb bu tundae ngo bor is haoru birismil, Pita obu di ngo bor haru birismisa. ");
INSERT INTO akh_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ngo tomb kongon biyao nong is mondom Pita obu di is haoru birismi ndal birisaol hindisesa. Ngo tomb kongon biyao nong ndam Pita ngub hend heneng bubur kakl, Aol ngo bere o obu di Njises kab haru haroklbe nde e kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ngo tomb Pitam kakl, Inj ka. Nong ngo e, nim aol ngo obu nao hendeyo ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ngo tomb kang mend mabor sao aol mondom di Pita birisaol hondobur kakl, Nje di Njises obun sem ora e kisesa. Ngub kisao o Pitam kakl, Wao aol abo hakl, ni nao hende ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ngo tomb kang mend mabor baoklmend ora birismi tomb aol mondom di angal buriyab ora kobur kakl, Heneng ora aol ngo obu di Kalili aol ora hael, obu Njises hesa haru haroklbe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ngub kisao o Pitam kakl, Hi aol abo hakl, njem ngo kal o ni nao hende ora kisesa. Ngo tomb Pitam ngub kao pe peyakl birinbur oran, sao kulao angal bao bisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ngo tomb Aorao Aondaom baol munubur kisaon Pita el burim ora hindisaol, Pitam obun kone bor Aorao Aondaom kobur, njem bao somna ngon sao kulao angal nao bi haenbur ko teb oran njem ni nao hendeyo lesi kisao nda mao takl bisaol, ");
INSERT INTO akh_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pita obum dera pobur kisaon hibi kho so de aondao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ngo tomb aol mendbor Njises men ha kemi pismi nda baebenom obu maobowa peb bubur kismin lu bowes bismisa. ");
INSERT INTO akh_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ngo tomb mbinim Njiseson el bor lab labom tanga tingi mbabur kismin mbinim obu bor maobowa angal bubur kakl, Nje aebom was leyem? Njem mao bembera handale nda ub hend kobur khorob ora lu bowes bismisa. ");
INSERT INTO akh_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ngo tomb mbinim ngub kobur kismin Njises bor maobowa peb bu angal kho di andub sao kismisa. ");
INSERT INTO akh_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ngo tomb mabor hokloben nar disao tomb Nju semon maomb bo haraoklao aol, aol kon wi baeben di, mbini baolum aol aondao baeben di, mbinin man buwaloklme aol baeben di, mbinim Njises mbini kansol baeben birismil mini pobur kakl, ");
INSERT INTO akh_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nje Ngaorom Eben Ke Aol hael be? Inj, njem nao kao nji kismisa. Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Nim ini bor ngub kao njuklwao tomb inim nao angal ngo heneng ora le ko nen nao saboklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ngub kobur kakl, Nim ibi bor angal mendbor ne muklwao tomb di, inim nao angal ngon ko san nao luklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ngub kobur kakl, Ini ngubi ora hayem o Aolon Isi Ora obu ngubi tomb di ma ora bor di hambun sao buri palo bu haraoklao Ngaor aondao oran ki tao nan bao ber aeben saklao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ngub kisaol mbinim Njises bor kakl, Njem ngo kal ub nje Ngaoron Isi yao be? Kismisa. Ngub kismil obum mbini bor kakl, Inin mbib ngo lem o, ni ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ngub kisaol pangobur mbinim buri palobur kakl, Naom wakl angal asub bi mend lemil pangoklmao? Obun mbib angal khorob ngo le ol pangaoklaom o kismisa. ");
INSERT INTO akh_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ngo tomb Nju semon kansol ngo baebenom Njises mbinin kabman maomb bo haraoklao aol aondao Paler birisaol mini pismisa. ");
INSERT INTO akh_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ngub mini pobur kismin mbinim Paler birisaol howes kobur kakl, Aol ngom naon tenaol hambun maobowa mbinin kone bor mao ngil ngaol kabur, mone takis moroklme aol baebenom Orom semon aol wesmbao aondao Sisan takis mukl oboklemi tomb inim nao kaloklwaebe ora kaonaol hondomao kismisa. Mbinim wakl kakl, Aol ngo obum ni Ngaorom Eben Ke Aol ora hae ol, ni aol wesmbao aondao ora hae was lao kismisa. ");
INSERT INTO akh_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ngub kismil aol Palerom Njises ne mubur kakl, Nje Nju semon aol wesmbao aondao ora yao be? kisesa. Ngub kisaol Njisesom obun angal ngon ko san lubur kakl, Njen mbib ngo kao paril o kisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ngo tomb Palerom Nju semon baolum aol aondao baeben di, tenaol andub ora ngo hasmi baeben hambun bor kakl, Nim aol ngo obu bor te mao saraeb se obum khorob bisao sao menjao nao mao bemberarukl kisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ngub kisao o mbinim angal buriyab ora kobur kakl, Aol ngo obum pibnao su Kalili bor mbes tibiya tenaol hambun bor man kao kalo sob aondao ora mao kabur, mabor su Njuriya hambun bor di bu hasao ub ngubi tomb enjo ngo bor di ngub was bu haraoklao kismisa. ");
INSERT INTO akh_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ngo tomb ngub kismil Palerom angal ngo pangobur mbini bor ne mubur kakl, Aol ngo obu Kalili aol e be? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ngo tomb mbinim Paler obu bor kao kalismil pangisao tomb, Njises obu su Kalili ngo aol wesmbao Herorom maomb bo hasao bor aol yao ke pangisesa. Ngo tomb aol wesmbao Heror ngo obu di su Njurusalem ngo bor hasao o sisaol, Palerom Njises obu Heror birisaol obum ora howes ngon pangen ko pen kisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ngo tomb Herorom mbes ora Njisesom bu hasao sao pangobur obum Njises ko mend hondoklwao ko nen sabisao o, obu birisaol ibisaol hindisao tomb obum turi aondao ora homobur, Njisesom hambun sao bu hae ke pangisao ub obum tenaolom ko mend nao hindismi sao oran bombor mend buklao hondoklwao ko nen sabisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herorom ngub nen sabobur kisaon obum Njises bor andub sao ne misao o, obum angal ngo ne misao nda haklon ukl mend ko san nao lisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ngo tomb ngub bisaol hondobur Nju semon baolum aol aondao baeben di, mbinin man buwaloklme aol baeben di, ngo baebenom Heror birisaol teb sol obo habur, mbinim Njises obu bor buriyab ora te mao sara howes kismisa. ");
INSERT INTO akh_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ngo tomb Heror obu di obun ami baeben di mbinim Njises obu dobaekeyo maobowa angal bismisa. Ngo tomb mbinim obu maobowabur kismin obu lab lab saoll ebe teraebi ora mend mao somabur, mbinim obu wakl Paler birisaol pen kismisa. ");
INSERT INTO akh_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ngo tomb mbes Paler hesa Heror kab mbibi saond bi sao ha ha bisbi o, bao ngo mbibim Njises en aeben bin kisbi ngon mbibi wakl hen mu aol sango hasbisa. ");
INSERT INTO akh_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ngo tomb Palerom Nju semon baolum aol aondao baeben di, mbinin maomb bo haroklme aol baeben di, tenaol aondao ngo hasmi baeben di mbini hambun ora ubuklub kisaol, hambun ora obo kiril mba birismisa. ");
INSERT INTO akh_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ngo tomb Palerom mbini bor kakl, Inim aol Njises ke ngo obu ni bere ol kemi obaemndal, inim aol ngo obum tenaol hambun maobowa haraoklao kaemndan, nim ini hambunon el so oral ko ko was ne manda kisesa. Ngub kobur kakl, Pangeklem. Inim aol ngo obu bor ngo te mao sarabur howes ngo keyem on, nim obu bor te mao bemberaeb se obum khorob bisao saon te mend nao wiril ol, ora es buwarukl kisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Wakl kakl, Aol wesmbao Heror obum di te ngub was es buwabur, obum wakl enjo ngo bor ngo eben kene o ka. Pangeklem. Aol ngo obu pe paen lib se sao menjao nao bise ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ngub kobur kakl, Ngub sene ol nim aol ngo doroklom ora lubur anda pu lowao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ngub kisao o mbini semon aol mendbor khorob bismil kalabus mao palaesao baebenon, mbinin hor so boroklme bao o pindi pa was pisao tomb Palerom mbinim turi homen ko is mend anda pu kao was bisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ngub bisao o sisaol tenaol hambunom angal aondao bu ora kobur kakl, Njem aol Njises obu pe paen lubur naon aol Barabas anda eben kao kismisa. ");
INSERT INTO akh_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ngub kismi o mbes aol Barabas ngo obum su and lobokl lobokl aondao Njurusalem bor kabman kab kab saond mao babur aol mend pe paen lisaol, Palerom kalabus mao palaesao o aol ngo bor kismisa. ");
INSERT INTO akh_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ngo tomb Palerom tenaol hambun bor wakl Njises obu anda pen kon wa ora ko kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ngo tomb tenaol hambunom ne bombor ub kombo angal aondao bu ora kobur kakl, Njises is pe kowal bi bor nil libi. Obu is pe kowal bi bor nil libi ko aondao bu ora kismisa. ");
INSERT INTO akh_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ngo tomb Palerom mbini bor ko tebo kao kalobur kakl, Inim asub ko ora lem? Aol ngo obum khorob oran asao ora bisao? Nim aol ngo obu pe paen lib se khorob sao di kang mend nao bisel nim hondokl buwarukl ol, obu doroklom lubur obu anda pu lowao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ngub kisaol mbinim Paler obum Njises is pe kowal bil nil lin ko angal aondao bu ora buri palo kao hakol was bismisa. Ngub kobur Paleron angal ngo kakl birisao hakl mbinin angalom ora men mbaen kismisa. ");
INSERT INTO akh_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ngub bismil Palerom mbinim ngo kismi ub e ko, inin angal taolun wa kisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ngo tomb aol Barabas ke ngo kabman kab kab saond mao babur aol mend pe paen lisaol kalabus bismi nda, tenaol hambunom naon wakl anda eben ka kismi nda ub mbinin angal taolubur Palerom ngub anda pu kisesa. Ngub bubur kisaon mbinim kismi nda ub obum obun ami baeben bor Njises pe paen lukl mini puklub ko kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ngo tomb mbinim Njises mini pukl hasmil, aol is mend obun imbi Simon kismil obun su Sirini haklbir su and lobokl lobokl ngo bur ubukl hasaol hen mubur men hasmisa. Ngub men habur kismin mbinim is pe kowal bi Njises nil li mbakl bi mend sisao o, aol ngo obun pesaol mao tabur kismin, mbinim obu di Njiseson mama pen kismisa. ");
INSERT INTO akh_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ngo tomb tenaol andub ora Njises mini pismi bor taol mi pismi tomb, ten andub ora mendborom Njises hond homobur de ko sarbeyam pismisa. ");
INSERT INTO akh_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ngo tomb Njisesom mbini baol munu hondobur ten ngo baeben bor kakl, Ini Njurusalem ten o hakl o, inim ni bor hond homo de nao ke, inim inin mbib di inin nongnas baeben daol hond homo de lowaebe o beyem kisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Njisesom ngub kobur kakl, Pangeklem. Mabor bao mend buklao tomb mbinim ngub lemi. Ten mendbor habele nongnas marukl buwaeb se baeben di, ten mendbor nongnas nao mari baeben di, ten mendbor nongnas aondu nao kale baeben di, ten ngubi baebenom mbinin kone bor turi aondao ora bin buruklemi lemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Wakl kakl, Bao ngon was mbinim harbor aondao baeben bor di harbor kang baeben bor di, inim nao kombo tingi mbaklao lemi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ngub kobur kakl, Mbinim ngubi tomb ni is ka hakle ora menger hae bor daol ngub ngo beyem ngao, ini is kaebi wesu harib se menger hayem baeben bor daol, mabor bibir buklemi ko ne nao sabeyem be? Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ngo tomb aol is kab mend mbibim khorob bisbil, mbibi di Njises daol haru pe paen luklbur mini pismisa. ");
INSERT INTO akh_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ngub pobur mbinim su menden imbi Wesmbao Hul kismil, yu manda ngol po pindib paesmi tomb mbinim Njises is pe kowal bil nil li mbabur kismin, mbinim khorob bisbi aol nda kab di, mende aol Njiseson ki tao nan mende aol ki kowes nan bu nil li mbaesmisa. ");
INSERT INTO akh_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ngub bismi tomb Njisesom Ngaor bor kao kalobur kakl, Abo o mbinim khorob ngo beyem ub oborob nao hendebur beyem ngao, khorob ngo beyem on saongao nao mari kunaebe ora kisesa. Ngo tomb mbinim Njiseson lab lab kol baerae wisao hakl taol bu kaob bu mubur kismin, bombor mend pon pae bao wisao o pone uklao om min ko, han ngoll pile bimi ub menger pile kang mend bismisa. ");
INSERT INTO akh_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ngo tomb tenaol andub ora hondo hasmil Nju semon maomb bo haroklme aol baebenom Njises bor aondao bu ora maobowa angal bubur kakl, Obu Eben Ke Aol Ngaorom bember ha haen ke ora harob sin, obum tenaol mende bu muklao ub obum obun mbib ebe bongeyaokl buklao ora kismisa. ");
INSERT INTO akh_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ngub kismi tomb ami baebenon obu nil li mba hasaol teb so obo ib waen kang mend mao nakl obobur kismin, mbinim di obu maobowa peb bubur kakl, ");
INSERT INTO akh_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nje Nju semon aol wesmbao aondao ora yao sin, njem njen mbib bisur bu, bu mi kismisa. ");
INSERT INTO akh_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ngo tomb mbinim Njises nil li mbaesmi is pe kowal bi ngon yu kungni oral bobae waeb ngub bu wismisa. AOL NGO OBU NJU SEMON AOL WESMBAO AONDAO ORA YAO ko waeb bu wismisa. ");
INSERT INTO akh_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ngo tomb khorob bisbi aol is kab mend Njises haru nil li mbaesmi ndan mendem Njises maobowabur kakl, Nje Ngaorom Eben Ke Aol yao be? Heneng nje Ngaorom Eben Ke Aol yao sin njem njen mbib bisur bubur lesin, njem yao ngo kab di bisur bu, bu mi kisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ngub kisao o khorob bisao aol mende ndam Njises bor maobowa angal bisao nda bor taolu lubur kakl, Wao. Obun khorob menjao nao bisao o baehaemen ora ngo ke hende ub nje hesa bombor ubi yaol, njem Ngaor pakl nao bil ol kal be? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ngub kobur kakl, Yao ngo kab non mbinim ngub bib se ub baemnda ka. Heneng ora yaom khorob andub ora bisbaol yao lereklem o, aol ngo obum non khorob menjao nao bisao o ke haondaokl kisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ngo tomb aol ndam ngub kobur kakl, Njises o, mabor nje aol wesmbao aondao ora habur maomb bo haklesi tomb njem ni aokl nao hemen haebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ngub kisaol Njisesom obu bor kakl, Nim nje bor heneng ora kao njurukl, embi ngubi tomb nje hesa yao su ebe kone sisab bin haroklme mendel hen mabon ora kisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ngo tomb aond hora haklu nar wesmbao tukun oral hasao tomb nar el nda tokl mubur kisaon, su hambun bor em hundur aondao ora u mbabur nend kisaol, ngub bao nend kao mba haen was 3 kolok ora pangobur, nar nubu ngo ora bor as deyaesao tomb oran wakl bao bisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ngub bisao tomb Ngaor Hen Moroklme Anda bor and tubal komb bi ora ndan lab lab aondao saoll ora mend manga tundaesmi nda tukun ora tom kab bu kaoll kobaesesa. ");
INSERT INTO akh_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ngo tomb Njisesom angal aondao bu ora kobur kakl, Abo o, nim nao wesao njem men menin kakl kobur kisaon pe paesesa. ");
INSERT INTO akh_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ngub bisaol ami sem maomb bo haraoklao aol mend ngol hasao om ngo bisao sao baeben hondobur kisaon, obum Ngaor bor kaoya kobur kakl, Heneng ora aol ngo obum khorob menjao nao bi, obu aol ebe ora harekle kisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ngo tomb tenaol aondao ngo obo kiril mbabur hondo hasmi nda baebenom hambun sao ngo bisao nda baeben hondobur kismin, mbinin kone bor kho aondao ora sisaol hibi umu men mbakl mbakl pobur kismin, mbinin anda sisao paokl buri kismisa. ");
INSERT INTO akh_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ngub bismi tomb tenaol mendbor Njiseson tenaol sango baeben di, ten mendbor Kalili haklbir obu taol mi ibismi baeben di, mbinim Njises obu is pe kowal bil nil li mba hasao ndal kang mend aebenol sao habur hambun sao ngo bisao sao bao hondo hasmisa. ");
INSERT INTO akh_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ngo tomb aol is mend obun imbi Njoseb hasaol, obun su Nju semon su bor and lobokl lobokl Arimatiya sisesa. Aol obu kone dund se wi oborob biyao aol ora sisao o, obu Nju semon kansol hasesa. ");
INSERT INTO akh_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Aol ngo obu ngub kansol hasao o obum Ngaorom maeb ha maomb bo hakl oboklao ub di bao hondo hasaol, kansol baebenom khorob ngo bismi ub obum nao haru bem nao ke makl himisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ngo tomb aol ngom maomb bo haraoklao aol Paler birisaol pobur, Njiseson toklo tangakl pon ko kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ngub kobur kisaon obum Njiseson toklo nda sul mu pabur obum lab lab haek bi ebe ora mondom tanga pabur kisaon, mbes obum han te bombor mend waru u mbaesaol, han te ngo bor mbes di aol is mend nao maol bismi o sisaol, ngo bor maol bisesa. ");
INSERT INTO akh_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ngo tomb bao ngo Njises tangaesmi o kongon wes weson sisaol, Nju semon hor boroklme bao* o kang mend wen pindib paklao kobur birismisa. ");
INSERT INTO akh_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ngo tomb ten mendbor Kalili haklbir Njises taol mi pobo hasmi nda baeben Njoseb pisao bor pobur kismin, obum Njiseson toklo di asub was tangaraokl ko hondokl pismisa. ");
INSERT INTO akh_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ngo tomb ten nda baebenom Njises ngub maol bisaol haondaoklbir kismin wakl mbinin anda pismisa. Ngub pobur kismin mbinim aol maol bu mbaen toklol sularoklme sao, wel sem kao ebe ora pebe hakl Njiseson toklo sulakl poklbur man man bu wismisa. Ngub bubur kismin Nju semon hor boroklme bao o pindib paesao tomb Moseson manom ke wisao ub hor so birismisa. ");
INSERT INTO akh_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ngo tomb Nju semon kongon mubaon hokloben wen nar pol bam ibisao tomb, ten nda baebenom Njiseson maol bor mbinim wel kao ebe ora pebe ngo mbakla ub man man bu wismi nda hakl mari pismisa. ");
INSERT INTO akh_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ten nda baebenom ngub pobur hindismil, Njises maol bismi tomb han aondao ngon dir o bor mangaesmi nda nao manga mba hae, pere hakl po wisaol hindismisa. ");
INSERT INTO akh_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ngo tomb mbinim han te nda bor oborob ora hondabur hindismil, Aorao Aondao Njiseson toklo han te ngo bor ora nao wisaol hindismisa. ");
INSERT INTO akh_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ngub bisaol ten nda baebenom mbinin kone bor asub ora baonaob ko nen sabobur kismin, mbinim ngon te ora nen sabokl buwaesmisa. Ngo tomb aol is kab mend han te Njises maol bismi ndan teb sol hasbil hindismi tomb, mbibin lab lab di bao bi hakol bi ora bu hasbil hindismisa. ");
INSERT INTO akh_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ngub hondobur ten nda baebenom burisao po pakl aondao ora homobur kismin, mbinim unu su bor was hena wismisa. Ngub hena wismil aol ngo hasbi nda kabom mbini bor kakl, Inim asub ko aol pe pae wakl enjaokl pe ngon maol bor es bi wiyem? Obun maol ngo bor bao nao wi wakl enjaokl pa kisbisa. ");
INSERT INTO akh_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ngub kobur kakl, Obu su Kalili bor bao hasao tomb ini kao njisao ub nen nao sabeyem be? kisbisa. ");
INSERT INTO akh_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Mbibim ngub kobur kakl, Obum ini bor ngub kao njisao. Mbinim Aolon Isi Ora khorob bimi aol baeben munu kaloklemil, mbinim obu is pe kowal bil nil luklemi o obum bao hor tebo nan on wakl enjaokl poklao ko ini kao njisao ora kisbisa. ");
INSERT INTO akh_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ngub kisbil, ten nda baebenom mbes Njisesom angal ngo kisao o nen sab heneng bibir kismin, ");
INSERT INTO akh_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","mbinim Njiseson maol ngo bor haklbir anda pismisa. Ngub pobur kismin mbini Njiseson man pange aol tobon teb nda di man pange tenaol hambun di mbinim pangen, Njiseson maol bor hambun sao ngo haondaokl ibismi ub kao kalismisa. ");
INSERT INTO akh_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ngub bismil ten ngo Njiseson maol bor bisao sao haondaokl ibismi baeben, Maktala Mariya di Njowana di Njemuson am Mariya mende di, mbini ten ngo baeben daol ten tangar mendbor di mbini ngo baebenom haondaokl obobur, Ngaoron angal bib hobao sao kam akol bu hasmi aol baebenom pangen kao kalismisa. ");
INSERT INTO akh_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ngub kismi o angal bib hobao sao kam akol bimi aol nda baebenom ten ngo baebenom baehaemen ora lem ko nen sabobur, mbinim heneng ora lem ko nen nao sabismisa. ");
INSERT INTO akh_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ngo tomb Pita obu akl was Njiseson maol han te nda bor hondokl pobur kisaon, obum Njiseson toklo wismi nda bor sul ber munubur hendaesaol, lab lab ngo obun toklo tanga pa maol bismi nda was wisaol hindisesa. Ngub haondaoklbir kisaon obun anda wakl bokeyobur, obum burir biyu ngo bisao saon was nen sab ha wisesa. ");
INSERT INTO akh_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ngo tomb bao bombor ngon was aol is kab mend su kang menden imbi Emeyas poklbur pisbil, Njurusalem hesa su Emeyas kang ngo kab teb so sao kilometa el tobon teb sisesa. ");
INSERT INTO akh_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ngo tomb mbibi ngub pobur kisbin hambun sao Njises bor ngo bisao saon arman kaokl kaokl pukl hasbisa. ");
INSERT INTO akh_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mbibim ngub mende ne mi mi bu angal kaokl kaokl pukl hasbil, Njises obu ngol obo pindib pabur aol nda kab daol mbini haru pismisa. ");
INSERT INTO akh_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ngub pismi o mbibin el bor menjao mondom maong maong bisaol, mbibim aol ngo obu Njises haru peyom ko oborob hend heneng nao bisbisa. ");
INSERT INTO akh_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ngo tomb Njisesom mbibi bor ne mubur kakl, Ibim ngo kaokl kaokl pukl hayeb o asao was leb? kisesa. Ngub kisaol aol nda kab nimil ti munubur kisbin, mbibin el wil bor nao hebele kumi naesbisa. ");
INSERT INTO akh_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ngo tomb aol ngo kabon mende aolon imbi Kilopasom, obun angal ngo kisao ndan ko san lubur kakl, Njem Njurusalem bor ngubi tomb ngo bandisao nao pange, nje bombor o ngubi tomb obone ibil be? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ngub kisaol Njisesom mbibi bor ne mubur kakl, Ibim asao baonao bor leb? kisesa. Ngub kisaol mbibim obu kao kalobur kakl, Yaom ngo laob o non Nasarer Njises obu Ngaoron man mini aol habur, Ngaoron kongon buri ora bubur obun man di buriyab ora ko haraoklaol, Ngaorom di tenaol hambunom di obum ngo biyao ub ora hendeme o, aol ngo obu bor baonao saon bor laob kisbisa. ");
INSERT INTO akh_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ngub kobur kakl, Mbini nao Nju semon baolum aol aondao baeben di, naon maomb bo haroklme aol baeben di, mbini ngo baebenom aol Njises ke ngo kabmanom obu pe paen lin ko men ha kalismil, mbinim obu is pe kowal bi bor pe paen nil lismi kisbisa. ");
INSERT INTO akh_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Mbibim ngub kobur kakl, Ngub baonao o naom mbes aol ngom Isreyel tenaol baeben wakl bu muklao ko pangismao o, pe paesao ora. Mende di obu pe paesao o, bao hor tebo nan o embi ngo ko kao kalisbisa. ");
INSERT INTO akh_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mbibim wakl kakl, Embi hokloben ora ten nao semon mendbor Njiseson maol bor haondaokl obaemi baebenom nao burir mao biyarmi ora. ");
INSERT INTO akh_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Mbinim Njiseson toklo nao waonaol haondaokl wakl obobur kaemin, nao bor ngub kao njaemi. Naom Ngaoron angal mini wesao mendbor harmil hondomao tomb mbinim nao bor kakl, Njises obu wakl enjaokl pa ko nao kao njaemil pangaokl ubuklum ko, ten ngo baebenom wakl nao kao njaemil pangomao kisbisa. ");
INSERT INTO akh_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mbibim ngub kobur kakl, Aol nao sem mendborom di Njiseson maol bor pobur hendaemi tomb heneng ora ten ngo baebenom kaemi ub was haondaokl obaem o, Njises obu enjaokl po hanao o non mbinim nao hendaemisa ko kao kalisbisa. ");
INSERT INTO akh_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ngub kisbil Njisesom mbibi bor kakl, Wao. Ibi kon nao wi ora hayeb. Mbes Ngaoron man mini aol baebenom buklao ora kismi ub ibim heneng ora buklao ko nen sabo, angal ngol hul nao hae ora haroklbe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Njisesom wakl kakl, Ibim asub nen sabekleb? Ngaorom Eben Ke Aol obu pibnao oran tanda no ke hondoklao o mabor Ngaorom obu imbi wi aondao bao bi ora haen lao ke wiyao ub ibim nao pangaebe be? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ngub kobur kisaon obum mbibi bor, Moses di mbes man mini aol hasmi baeben hambunom Ngaoron mbuk waeb bu wismi baeben ngub wiyao ko kao kalobur, hambun sao Eben Ke Aol bor buklao ke wisao sao baeben mbibim pangen te hambun sao kao dund bisesa. ");
INSERT INTO akh_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ngub bisao tomb mbini teb pismil, su ngo aol nda kab mbibi poklbur pisbi on teb sol sao pismi tomb Njises obu paokl poklbur sao bi hindisesa. ");
INSERT INTO akh_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ngub bisaol aol nda kabom obu bor nje nao pu kobur kakl, Nar ngo anda bombe ol penar bu ora nend laong, nje nao pe nao bao berem ora kisbisa. Ngub kisbil obu di mbibi birisbil hondabur mbini haru bao birismisa. ");
INSERT INTO akh_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ngo tomb mabor Njises di mbini haru ne noklbur birismisa. Ngub birismi tomb Njisesom palawe mend mubur, obum Ngaor bor tengiyu ko kaoya kao peyobur munu konde barabur kisaon, obum mbibi kab nen kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Njisesom ngub bisao tomb wakl mbibin kone kombisaol, mbibin el bor maong maong bi non bi birisbi nda ub di wakl el nga kao pesaol, obu Njises ora e ko hend heneng bisbi o obu bao ora bum hasaol mbibim obu ko mende nao hindisbisa. ");
INSERT INTO akh_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ngo tomb mbibim kao kao bubur kakl, Yaom harer bor obabnda tomb obum yao bor angal kao nju, Ngaoron mbuk waeb bor wiyao on te di oborob ora kao dund banda tomb, yaon kone ora bor perel aondao ora inj bila bo? kao kao bisbisa. ");
INSERT INTO akh_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ngo tomb mbibim ngub kao peyaoklbir kisbin, bombor ngo tomb was mbibi wakl Njurusalem bokesbisa. Ngub pobur kisbin Njiseson man pange aol tobon teb nda di, mbinin Karas tenaol sango mendbor di, mbini hambun kiril mba ber mba hasmil pindib paesbisa. ");
INSERT INTO akh_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ngub pindib paesbil mbinim aol nda kab bor kakl, Heneng ora Aorao Aondao obu wakl enjaokl po hanaol, Simon Pitam hendene kismisa. ");
INSERT INTO akh_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ngo tomb aol nda kabon di mbibim harerol hindisbi nda ub mbinim pangen arman kao kalobur, Aorao Aondaon mbibi bor palawe mend nen konde bara kalisao tomb, mbibim obu Aorao Aondao ora e ko hend heneng bisbi nda ub di mbinim pangen kao kalisbisa. ");
INSERT INTO akh_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ngo tomb mbinim angal ngon ngub bao kakl win was, Aorao Aondao obu mbini ber mba hasmi nda daruklol obo pindib pa habur kakl, Inin kone bor sub tibaen as ko boroklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mbinim ngub kisaol pangobur, burisao po pakl aondao ora homobur aol wesao mend hae ko pangismisa. ");
INSERT INTO akh_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ngub bismi o Njisesom mbini bor wakl kakl, Inim asub ko burisao po pakl homo inin kone bor taol taol bim? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Njisesom ngub kobur kakl, Ni Njises ora haeng, mbinim nao ki aongao kab bor nil lismi hakl di inim kim oborob ora warabur haondaoklaob. Inim nao toklo songol hesa hul kab ngo hendeyem ub di, aol wesaon non bi inj ong haondaoklaob kobur, ");
INSERT INTO akh_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","obun ki aongao bor nil lismi nda hakl mbinim oborob ora henden muwalisesa. ");
INSERT INTO akh_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ngo tomb mbinim turi aondao ora himisimi o, ngo be sao heneng ora be? be? baehaemen beb ko mbinin kone bor kang sao aondao sao bin birismisa. Ngub bismil Njisesom mbini bor kakl, Inim ne kang mend wiyem be? kisesa. ");
INSERT INTO akh_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ngub kisaol mbinim obu ib wen mend haorubur wismi o kalismisa. ");
INSERT INTO akh_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ngo tomb Njisesom wen nda mubur nisaol mbini hambunom hindismisa. ");
INSERT INTO akh_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ngo tomb Njisesom mbini bor kakl, Nim ini daol nao haru bao hasumndis tomb ini bor mbes kao njundis ka. Ni bor ngo be ub nim heneng ora ngub buklao ko mbes Mosesom waeb bu wisao ub di, mbini Ngaoron man mini aol hasmi baebenom waeb bu wismil Ngaoron mbuk waeb bor wiyao ub di, Kaoya We Lome mbuk bor wiyao ub di, angal ngo wiyao baeben heneng ora ngo il so pind biyaokl o kisesa. ");
INSERT INTO akh_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Njisesom obun man pange baebenon kone bor ngub mao kombaesao tomb, mbinim Ngaoron mbuk waebon buklao ke wisao ub oborob ora nen sab heneng bismisa. ");
INSERT INTO akh_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ngub bismi tomb Njisesom mbini bor kakl, Ngaoron mbuk waebom ngub ke wiyao. Ngaorom Eben Lao Aol obu tanda aondao ora nobur pe paklao o, bao hor tebo nan on obun maol bor bao nao wi wakl enjaokl poklao ke wiyao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Njisesom ngub kobur kakl, mbini obul hul ha haklemi baebenom obun imbi bor angal bib hobao sao ngo Njurusalem bor mbes tibiya kao kalobur lemin, mabor su hambun bor tenaol hambunom pangam aeben aeben bin lemi. Mbinim tenaol hambun bor Ngaorom inin kone bor kho wiyao o kunaklaong, inin kone baol monoklwaebe ke wiyao kisesa. ");
INSERT INTO akh_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ngub ke wiyaong nim ini ngo bereyem baebenom hambun sao ngubi tomb ngo hendeklemin muwalakl sao, tenaol hambunom pangen oborob ora kao kalokwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Njisesom wakl kakl, Pangeklem. Mbes nao Abom nim ini bor heneng buklwao ora kisao ub obum hobao sao ngo ini bor njuklaol, obum ngo kisao sao nim ora ini njuklwao. Ngub buklwaong nim ini hakelmil buri aondao ora ini buri mao palakl bi mend yu heben haklbir eben lowaong, buri ngo ini haklemil ngub nao ebe haenbur, inim maon nan nao hond lae su Njurusalem ngo bor bao hondo haklwaebe ora ko Njisesom obun man pange baeben bor ngub kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ngo tomb su Betani Njurusalem teb sol sao sisaol, Njisesom obun man pange baeben su ngo bor kemi pobur kisaon, obun ki yu heben bor menyabur obum mbini ngo baebenon kone bor sisab mao ba as ko ora birin kaebe ko kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Obum ngub bao kakl haen was, mbini obun man pange aol baeben ngol bao ham mba haen Njises yu heben bor men misesa. ");
INSERT INTO akh_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ngub bisaol mbinim Njises obu bor kaoya ko turi aondao bu ora homaoklbir wakl Njurusalem bokesmisa. ");
INSERT INTO akh_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ngub bubur kismin mbinim bao hor hambunon Ngaor Hen Moroklme Anda bor was po buru habur, mbinim Ngaor bor tengiyu ko kaoya kao ha was hasmisa. ");
INSERT INTO akh_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Pibnao ora Ngaorom su hesa saohar kab nao warisao tomb Haeben Saroklme Angal obu hasesa. Ngub hasaol obu Ngaor hesa bao hasbi o obu di Ngaor ora hasesa. ");
INSERT INTO akh_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mbes ora ngub hasao o obu Ngaor kab bao hasbisa. ");
INSERT INTO akh_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ngub bao habur kisbin Ngaor obum Haeben Saroklme Angal ndam was hambun sao warin kisaol, tangar mondom hambun sao kang ora di nao warisao ora. ");
INSERT INTO akh_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ngub inj, obu bombor o haeben saroklmen te ora habur, haeben mao saraoklao aol ngom tenaol hambun bao mao baklbur hayao. ");
INSERT INTO akh_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ngub hayao o bao ngom em hundur wiyao o bor em hundur nao win ko bao mao baklbur hayaol, em hundur ngom bao ngo haklao ub ora nao men mbaklao ora. ");
INSERT INTO akh_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Aol is mend obun imbi Njon hasaol, Ngaorom aol ngo obu bember pe haen kobur eben kisao. ");
INSERT INTO akh_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ngub bisaol aol Njon obum ngub obobur, obum Bao Mao Baraoklao Aol ngon te tenaolom pangen kao kaloklao tomb, tenaol hambunom Haeben Saroklme Angal ngol hul ha haen ko kao kalokl ibisao. ");
INSERT INTO akh_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Aol Njon ngo ngub ibisao o obu Bao Mao Baraoklao Aol inj ibisao. Ngub inj, obum bao ngo wen oboklao ko tenaol hambunom pangen kao kalokl ibisao. ");
INSERT INTO akh_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ngub ibisaol bombor ngo tomb was, Bao Mao Baraoklao Aol hobao sao ora ngo obum tenaol hambun bao mao baklbur ibisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Bao Mao Baraoklao ngo obum su ngo bor di habur, obum su ngo di warisao o obum su ngo warise ko tenaol hambunom nao hindismi. ");
INSERT INTO akh_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Obu su ngon aorao ora habur obun su and te nda oral ubukl ko ibisao o, tenaol obun sem ngo baebenom nje oborob obaeng ib nao kismi. ");
INSERT INTO akh_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ngub bismi o tenaol mendbor obu bor oborob obaeng ib kismi baebenom obul hul ha hasmil, obun burim mbini ngo baeben Ngaoron isi wane haen kisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Mbini tenaol ngo Ngaoron isi wane mao hasao baeben, tenaolom mbinin kone bor mbinin mbib turi homo nongnas maru woroklme ub inj mbini Ngaoron isi wane mao hasao ka. Ngub inj, Ngaor obun mbib ora obun isi wane mao hasao ora. ");
INSERT INTO akh_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Heneng ora Haeben Saroklme Angal ngom aol men aolaoklbir nao hesa haru haklbur ibisao. Obu obun Abon Isi kuwis akl bombor ora hasaol, obun Abom obu bao bi ora mao hasao o ibisaol, naom di obu bao bi ora ngo hasao ub hindismao. Obu nao haru haklbur ibisaol, obu kone dund se ukl bombor ora u habur, tenaol hond homo bisur aondao ora bu hasao ub di naom hindismao ora. ");
INSERT INTO akh_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Njon Mbabtas Biyao Aolom di aol ngon te kao dund bu habur, angal aondao bu ora ngub ko hasao. Aol ngo obu nim ini bor mbes kao njundis ub aol mend nao ma ora bor oboklao o, ni di nao mari tomb obu mbes pind bili ora hasaol, hobao sao aondao ora obu yao ko kao njundis kisao. ");
INSERT INTO akh_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Haeben Saroklme Angal ngo aol men aolaokl ibisao nda obun kone bor nao hambun hond aondao ora homo haraoklao ub, obum nao hond homo bisur bi hakol biyao ora. ");
INSERT INTO akh_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mbes Ngaorom Moses bor man kao kalisao o was pangisumndis o, ngubi tomb Njises Karas obu tenaol mende bor hond homo kone woroklme ub di, kone dund se ukl bombor woroklme ub di, obu ngo baebenon te ora yaol hambun sao ngubi baeben obu bor was hakl ibisao. ");
INSERT INTO akh_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Aol is bombor ora mondom di Ngaor obu kang ora di nao hindismi ora. Ngub inj, Ngaoron Isi is bombor ora ngo obum obun Ab hesa mbibi bombor o oral haroklbe o obobur, obum nao bor Ngaoron te hobao sao ora ngo kao dund be ong, oborob ora pangemin ka. ");
INSERT INTO akh_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ngo tomb Nju semom mbinin baolum aol mendbor di, Libae sem mendbor di, ngo baeben bor Njon Mbabtas Biyao Aol obu bor nje Ngaorom Eben Ke Aol Karas be? aeb ora hael ko ne mukl puklub kismisa. Ngub kismil mbinim Njurusalem hakl obobur, Njon Mbabtas Biyao Aol nda hasaol obo ne mubur kakl, Nje aeb ora hael? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ngub kismil Njon Mbabtas Biyao Aolom kowes nao bi, ni aol ngo ora hae ko bao kao pabur kakl, Ni Eben Ke Aol inj hae kisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ngub kisaol mbinim obu bor wakl kakl, Ngub sin nje aeb ora hael? Nje Ilanja be? kimisa. Ngub kismil Njonom kakl, Inj ora kisesa. Ngo tomb mbinim wakl ne mubur kakl, Ngub sin nje naom man mini aol mend wen oboklao ko hondo haroklmao nde, nje ngo obae o sene ye? kismisa. Ngub kismil Njonom mbinin angal ngon ko san lubur kakl, Aoh, ni aol ngo inj kisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ngo tomb obum ngub inj was kisaol, mbinim obu bor wakl kakl, Nje aeb ora hael balem? Naom aol ngo nje aeb ora haeb ko hondokl pu kaemi baeben bor, obu aol ngo ora sene sa ko kao kalam paomun ub, njem ni aol ngo ora hae ko njen mbib lesi ub mend kao ora kismisa. ");
INSERT INTO akh_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ngub kismil Njon Mbabtas Biyao Aolom kakl, Mbes Ngaoron man mini aol Asayam ngub buklao ko mbuk waeb bu wisao ub su tenaol nao biri bor aol mondom angal aondao bu ora mend kobur kakl, Njem Aorao Aondao poklao hareron man man bu kare mao dund sarukl burukl pu lao ke wisaol, ni aol ngo ora hae kisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ngo tomb aol ngo baeben mbini Peresi semom ne mukl puklub kismil, ");
INSERT INTO akh_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","mbinim Njon Mbabtas Biyao Aol bor ne mubur kakl, Wao. Nje Eben Ke Aol di inj, nje Ilanja di inj, nje man mini aol mend wen oboklao ko hondo haroklmao nde di inj seneng, njem baehaemen oran asub ko tenaol hambun mbabtas bu harilib? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ngo tomb mbinim ngub kismil, Njon Mbabtas Biyao Aolom mbinin angal ngon ko san lubur kakl, Nim tenaol hambun ibom ora mbabtas bu hae o, ini hayem ol aol bombor mend haenbur o, inim obu nao hende ora haroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ngub kobur kakl, aol aondao hobao sao ora ngo obu ninao ma bor oboklao o, ni kho ora hae ol nim aol ngo oboklao o obun aongao su di nao kolaklaeb se ora yao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Angal ngo kisao o su Betani ib Njoran mende nan bor Njon Mbabtas Biyao Aolom tenaol mbabtas bu hasao bor hambun sao ko hasesa. ");
INSERT INTO akh_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ngo tomb ekera nan Njon Mbabtas Biyao Aolom hindisaol, Njises obu harer bor wen obu hasaol oboklbur ibisaol, Njon Mbabtas Biyao Aolom kakl, Haondaoklaob. Isu ngo ebe o obu Ngaoron Some Sib Hondbao ebel, obum sun tenaol hambunom khorob bismi sao kunakaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ngo tomb Njon Mbabtas Biyao Aol ndam wakl kakl, Aol aondao hobao sao ora obu nim mbes nao ma bor oboklao kaklo nda ngo ebe o ka. Ni nao mari tomb di obu mbes pind bili ora hasaol, ni kang ora hae o obu hobao sao aondao ora hae kisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ngub kobur kakl, Nim di aol ngo obu mbes ngo hasao ub nao hendebur o, nim tenaol hambun ibom ngo mbabtas bu haruklu ub, su Isreyel tenaol hambunom aol ngo wen oboklao ko henden ko bu haruklu nda kisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ngo tomb Njon Mbabtas Biyao Aol ndam aol ngon te kao dund bubur kakl, Nim Wesao Ebe Tangar sao ebeyabukl non bi oram yu heben hakl obobur, aol ngo obu men mbanaol hondowao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ngub kobur kakl, Wesao Ebe Tangarom ngo men mbaesao tomb di aol ngo obu aeb eb ko nim nao hende hawao o, Ngaor obun mbib ora ni bember habur, tenaol hambun ibom mbabtas bukl pu kobur obum ni bor kakl, Njem hondoklesi tomb aol is mend bor Wesao Ebe Tangarom yu heben hakl obobur men mbaklaol handae sin, aol ngo obum tenaol hambun wakl Wesao Ebe Tangarom mbabtas buklao ko ni kao njisaol pangowao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ngub kobur kakl, Nim ngo hondowao sao nim ini bor mbes kao njanda ub, aol ngo obu Wesao Ebe Tangarom men mbaesao kanda obu Ngaoron Isi bor kanda ko Njon Mbabtas Biyao aolom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ngo tomb ekera nan Njon Mbabtas Biyao Aol di obun man pange aol is kab mend di wakl mbini haru hasmi tomb ");
INSERT INTO akh_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Njonom hindisaol Njises obu harerol pisaol hindisesa. Ngub hondobur Njonom obun man pange aol nda kab bor kakl, Haondaoklaob. Isu ngo pe o Ngaoron Some Sib Hondbao pe kisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ngo tomb Njonon man pange aol nda kabom obum ngo kisao o pangaoklbir Njiseson mama taol mi pisbisa. ");
INSERT INTO akh_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ngo tomb Njisesom obun ma bor baol munu aol nda kabom obu taol mi ibisbil hondobur, obum mbibi bor kakl, Ibim asao es bib? kisesa. Ngub kisaol mbibim obu bor kakl, Rabae o, nje and awon harilib? kisbisa. Ngub kisbil Rabae ko imbi ngo kisbi on te, aol aondao o kisbisa. ");
INSERT INTO akh_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ngo tomb Njisesom mbibi bor kakl, Ibim ni paolaklo panda o hondokl ubuklub kisaol, mbibim and obu haraoklao o hondokl pisbisa. Ngo tomb mbon sam sam bubur 4 kolok pangisaol, mbibi kab Njises daol bao hasmisa. ");
INSERT INTO akh_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ngo tomb aol is kab ngo Njon Mbabtas Biyao Aolom kisao nda pangaoklbir Njises taol mi pisbi ndan is mende Simon Pitan haeme Andur sisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ngo tomb aol Andur ke ngom obun haeme Simon Pita mbes es bu mi po kao kalobur kakl, Naom Karas hend wamao kisesa. Ngub kisao o obum Karas ko imbi ngo kisao on te, Ngaorom Eben Ke Aol kisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ngo tomb Andurom obun haeme Simon Pita nda Njises hasaol kemi ibisaol, Njisesom Simon Pita bor kakl, Njonon isi Simon o, mabor njen imbi Sipas lemi kisao o, Ngirik angal kobur Pita sisesa. Ngub kisao o imbi ngon te, Pita obu han ib nao peb se non bi soklao ko imbi karu wisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ngo tomb Njises obu ekera nan su Kalili bor poklbur kisaon, obum Pilib hasaol hondobur Pilib bor kakl, Njem ni taol mi ib kisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ngo tomb aol Pilib obun su di Andur hesa Pita kabon su bor was sisaol, mbinin su bombor o Bersara sisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ngo tomb Pilibom Nataniyel es bu hondokl pobur Nataniyel bor kakl, Mbes Moseson manom ke wisao ub di, Ngaoron man mini aol baeben di mbinim aol mend oboklao ko mbuk waeb bu wismisa nda, naom aol ngo obu hondomao ora kisesa. Ngub kobur kakl, Obun imbi Njises, obu Nasarer Njosebon isi hae kisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ngo tomb Nataniyelom Pilib bor kakl, Wao. Njem hobao sao ora mend Nasarer bor pindib paraoklaol hendele be? kisesa. Ngub kisaol Pilibom obu bor kakl, Be? njem obu hendenin ub mban ib kisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ngo tomb Njises obu hasaol Nataniyel ibisaol hondobur obu bor ngub kisao, Aol ngo obu Isreyel aol ora yaol, obun kone bor kakla lome sao kang mend nao wiyao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ngub kisaol Nataniyelom burir biyubur obu bor kakl, Njem asub bubur ni njem ngo kal ubi haruklul hendeleb? kisesa. Ngub kisaol Njisesom obun angal ngon ko san lubur kakl, Nje Pilibom ib ko nao hondokl ebe tomb ora, nje is dullub isaon te bor harinda tomb ora hondowao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ngo tomb Nataniyelom wakl Njiseson angal ngon ko san lubur kakl, Aol aondao o, heneng ora nje Ngaoron Isi ora hael ol, nje Isreyel tenaol hambunon aol wesmbao aondao ora hael kisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ngub kisaol Njisesom obun angal ngon ko san lubur kakl, Nim nje is dullub isaon te bor haril hondowao ko kao njandal, njem ni hae ub heneng ora mao bembera handal be? kisesa. Ngub kobur kakl, Njem mabor aondao hobao sao ora mend hondoklesi om, njem ngubi tomb ngo handal ub men mbae ora hondoklesi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Njisesom obu bor ngub kobur kakl, Nim ini bor heneng ora kao njurukl, mabor yu heben kebe kobaklaol hondoklemi tomb Ngaoron angal mini wesao baebenom Aolon Isi Ora obu haklaol yin inin bi hakol hondoklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ngo tomb bao hor kab mend bao burubur hor tebo nan on, Kalilin su and te Kena bor aol mondom ten mend taol bisaol, Njiseson am Mariya obu di and ngo ten taol bismi on birisesa. ");
INSERT INTO akh_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ngub birisaol mbinim Njises di obun man pange aol baeben di ten ngo taol bismi o hondokl ubuklub kismil, mbini hambun hondo ne nokl ibismisa. ");
INSERT INTO akh_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ngub ibismi o ib waen pond bisaol Njiseson amom obu bor kakl, Mbinin ib waen nao biri ora pond bene kisesa. ");
INSERT INTO akh_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ngub kisaol Njisesom obun am Mariya bor kakl, Ten o, ngo sao njen menjao mend inj nao mbib ora buklwao o, nim ngo buklwao ub teb nao se kang mend wen kisesa. ");
INSERT INTO akh_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ngub kisao tomb Njiseson amom and ngon kongon bimi aol baeben bor kakl, Njisesom ini bor angal kang mend ngub bibaebe ko kao nja sin, obum ngo lao ub hul nao hae oborob ora bibaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ngo tomb ib be hibaeb non bi tokl dowa aondao nokl nokl was mend, ib be ngo hanom warismil tokl bombor o bor ib andub ora ndaram aondao bor sao birin humubur, mbini Nju semon manom ke wisao ub wes wes lu hasmi sao be ngo baeben ngol wisesa. obae kisesa. ");
INSERT INTO akh_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ngub wisaol Njisesom mbini bor kakl, Ib be ngo wi baeben bor ib humukl puklub kisaol, mbinim ib be ngo baeben bor tumbi haen ora humismisa. ");
INSERT INTO akh_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ngub bismi tomb Njisesom mbini bor kakl, Ib ngon kang mend howar bu mubur lemin, inim ib ngo ne maeb haraoklao aolom nen kalokl puklub kisaol, obum ngo kisao ub mbinim mini po kalokl pismisa. ");
INSERT INTO akh_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ngub bismil ne maeb haraoklao aol ndam Njisesom ib heneng ngo wakl ib waen men aolin kisao nda no hindisesa. Ngub bisao o ne maeb haraoklao aol ngo obum mbinim ib waen ngo abor mini ubuklim ko nao hindisao o, mbini aol ngo ib heneng humu taokl ibismi baebenom Njisesom ora ib heneng nda ib waen men aolin kanda ko hindismisa. Ngo tomb ne maeb haraoklao aol ndam aol ten taol bisao nda bor ib kobur ");
INSERT INTO akh_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","obu bor kakl, Aol hambunom ib waen ebe on mbes tenaol hambunom nen taol bu kalobur, tenaol hambunom ib waen ngo andub ora no bereme tomb, mabor wakl ib waen mende kang mend kho sao on taol bu kaloklme o njem ngub inj, mbinim kang mend kho non bi sa o mbes naemnda tomb, njem mabor ib waen ebe ora on humu taokl ");
INSERT INTO akh_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ngub bisaol Kalilin su and lobokl lobokl Kena ngo bor tenaol hambunom henden, Njisesom tenaolom ko mend nao hindismi sao pibnao ora bombor ngo obu buri tangar ubi ora haraoklao ub muwalisao tomb Njises obun man pange baebenom obul hul ha hasmisa. ");
INSERT INTO akh_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ngo tomb Njisesom ngub bu haklbir kisaon obun am Mariya di, obun haeme wil baeben di, obun man pange aol baeben di, mbini hambun su and lobokl lobokl Kabenam bor pobur, ngo bor bao hor kab teb baoklmend bao buru hasmisa. ");
INSERT INTO akh_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ngo tomb Nju semon Waran Aeben Bisao bao o pindib paklbur bisaol Njises obu Njurusalem yin pisesa. ");
INSERT INTO akh_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Njisesom ngub pobur hindisaol Ngaor Hen Moroklme Anda bor tenaol andub ora habur, mendborom some kawao bisnis bu, mendborom di some sib bisnis bu mone mu, mendborom sao ebeyabuklon bisnis bu ngub bismil, tenaol mendborom di mone su tangar tangar pange kab kab kowal bibi bu kaob kaob bu, ngub bi wismil hindisesa. ");
INSERT INTO akh_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ngub bismil hondobur obum ya toklo kang mend mubur kisaon, tenaol aondao ngo Ngaor Hen Moroklme Anda bor bisnis bi wismi nda baeben di, some sib hesa kawao aondao ngo sokl muklbur kaom tu hasmi nda baeben di, hambun lu taol deraesesa. Ngub bubur kisaon obum tenaol mendbor mbinin mone su tangar tangar pange kab kab kowal bi bi, bi wismi mone nda hakl di, to tebol ngo mone ubur kowal kowal bi wismi nda hakl bor bor, bo kobaolu bowes bisesa. ");
INSERT INTO akh_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ngub bubur kisaon Njisesom mbini tenaol ngo sao ebeyabukl mari obo bisnis bu mba hasmi nda baeben bor kakl, Inim nao Abon anda ngo bor sitowa anda nao men mao korae, inin ngo sao baeben mari puklub ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ngo tomb Njiseson man pange aol baebenom mbinin kone bor Ngaoron mbuk waeb bor mend wisao ub nen sabismil ngub ke wisesa. Nao Ngaor o Nim njen and ngo hem aondao ora kaklol Nao hibi bor kho sen haklwao ora ke wisao ub nen sabismisa. ");
INSERT INTO akh_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ngo tomb Nju sem ngo hasmi baebenom Njisesom ngo bisao sao hondobur mbinim Njises bor kakl, Njem hul ha ngo bil ub tenaolom ko mend nao hindismi sao oran asao ora naom haondaomun muwaloklesi? Njen buri nao ngub muwalaeb se mend wili be? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Inim Ngaor Hen Moroklme Anda ngo kundi mbarim sin di, nim wakl bao hor teb oran bu tingi mbaklwao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ngub kisaol Nju semom obun angal ngon ko san lubur kakl, Ngaor Hen Moroklme Anda ngo mbinim karasmas andub ora dowapun teb kab kab hor kab oran bismi nde o, njem bao hor teb oran ebe buklesi be? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ngub kismi o Njisesom Ngaor Hen Moroklme Anda menger ngo misao o obun toklo bor kisesa. ");
INSERT INTO akh_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ngub kisaol mabor Ngaorom obun maol bor wakl mao enjaesao tomb, Njises obun man pange aol baebenom obum angal ngo mbes kisao nda ub ngo be ko pangobur, mbuk waeb bor mbes ngub buklao ke wisao ub hesa obun angal ngo kisao ub kab, heneng ora ngo il so pind bile o ko nen sabismisa. ");
INSERT INTO akh_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ngo tomb Waran Aeben Bisao bao on Njises obu Njurusalem bao habur, obum tenaolom ko mend nao hindismi sao di burir biklme sao di andub ora bu hasaol, tenaol andubom ora hondobur mbinim obul hul ha hasmisa. ");
INSERT INTO akh_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mbinim ngub bismi o Njises obum mbinim nil heneng ora hul ha nao hayem ko ora hondobur kisaon, obum obun mbib mbini nao libakla paesesa. ");
INSERT INTO akh_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ngub bisao o Njises obum tenaol hambunon kone bor wiyao ub ora hondo habur, obum menjao nen sabokl buwa dim nao biyaol, mondom obu bor man man ko tenaolon kone bor ngub was wiyao ko nao kao kaloklme. Ngub inj, obum obun mbib tenaol hambunon kone bor wiyao ub ora hendeyao. ");
INSERT INTO akh_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ngo tomb aol is mend obun imbi Nikorimas obu Peresi sem sisao o, obu Nju semon maomb bo haraoklao aol ora hasesa. ");
INSERT INTO akh_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ngub hasao o aol aondao ngom sub somna ora Njises hasaol obobur obum Njises bor kakl, Aol aondao o, nje Ngaorom aol aondao ora hanin kobur pu kise ko naom nje ora hendeyom ka. Heneng ora Ngaorom aol is mend hesa haru nao harob sin, njem tenaolom ko mend nao hindismi sao ngo bu hael ub mondom bukl buwaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ngo tomb Njisesom obun angal ngon ko san lubur kakl, Nim nje bor heneng ora kao njurukl, tenaol mendbor ko mende nao marin harim sin, mbinim Ngaorom maeb ha maomb bo hayao ub nao hondoklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ngub kisaol Nikorimasom obu bor wakl kakl, Aol aondao and so pe pele harim sin, mbinim wakl asub bubur ko mende marin haklemi? Mbinin amon tombao bor wakl ko mende hondaklemil, mbinin amom ko mende maruklao be? kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ngub kisaol Njisesom obun angal ngon ko san lubur kakl, Nim nje bor heneng ora kao njurukl, tenaol mendbor ib hesa Wesao kabom nao marin harim sin, mbinim Ngaorom maeb ha maomb bo hayao bor pokl buwaklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ngo tomb ngub kobur kakl, Tenaol toklo henengom maru wi sa sin tenaol heneng ora soklao. Ngub inj, Wesaom maru win harim sin wesao soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ngub kobur kakl, Nje ko mende marin haebe kanda ub burir nao biyaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Njisesom ngub kobur kakl, Posabsum obun konem beyao ub tangar tangar maon nan mend hakl ib was beyao tomb kaoll bor buklao ub njen halom pangoklesi o, njem obu abor hakl obokl ko hesa ngo bor paokl ko kab hondokl buwaroklme nda ub, tenaol mendbor Wesaom ko mende marin haklemi baeben elom nao handaeb se menger ngubi soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ngo tomb Nikorimasom obun angal ngon ko san lubur kakl, Njem ngo buklao kal ub asub ora bubur heneng ora buklaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ngub kisaol Njisesom obun angal ngon ko san lubur kakl, Wao. Nje Nju semon man buwaloklao aol aondao ora hael o, ngo sao ora nen sabokl buwaril be? kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ngub kobur kakl, Nim nje bor heneng ora kao njurukl, naom ora pangemao sao baeben ini bor kao njubur, naom ora hendemao sao baeben di ini bor kao njeyom. Naom ini bor angal ngo pangeklemin kao njemao sao ini ngo baebenon is bombor ora mondom di angal ngo heneng lem ko nen nao saboklme kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Njisesom ngub kobur kakl, Nim ini bor su ngo bor bimi saon te kao nju hae tomb inim heneng ora le ko nen nao sabeyem ngao, nim yu heben bor biyao saon te kao nja sin, inim asub ora bubur heneng ora le ko nen saboklemib? kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wakl kakl, Aol tangar is mende mend yu heben hondokl nao pisao ora. Ngub inj, Aolon Isi Ora obum yu heben haklbir ibisaol, obu bombor o ora yu heben hakl ibisao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Njisesom ngub kobur kakl, Mbes Mosesom su tenaol nao biri bor suklumb menger mend menyaesesa nda ub mabor Aolon Isi Ora obu di ngub menyaklemil, ");
INSERT INTO akh_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tenaol mendbor obul hul ha haklemi baeben mbini haeben ora soklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ngo tomb Njisesom obu bor wakl kakl, Heneng ora Ngaor obun Isi kuwis akl is bombor ora hasao o, obum sul tenaol hambunol aondao bu ora kone u hond homobur obun Isi is bombor ora ngo tenaol hambunon eben kaesaol, tenaol mendbor obul hul ha haklemi baeben ke nao hondoklemi ora. Ngub inj, mbini nao heme haeben soklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ngub kobur kakl, Ngaor obum obun Isi bombor ngo eben kisao o, obum howes pangoklme aolom bimi nda ub tenaol hambun te mao sara taol bin ko inj eben kisao. Ngub inj, obum tenaol hambun ke nao henden ko bu mukl pu kisao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Njisesom ngub kobur kakl, Tenaol mendbor obun Isil hul ha haklemi baeben, Ngaorom mbini bor menjao te mao bembera howes nao lao ora. Ngub inj, tenaol mendbor Ngaoron Isi bombor ngo oral hul ha nao haklemi baeben, Ngaorom mbes ora mbinim ngo sao was bu hayem ko te mao bemberaesaol, mbini ke hondoklbur ora hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Obum wakl kakl, Ngaorom mbini bor ngo te mao bemberaesao on te ngub ora wiyao. Su ngo bor bao mbes ibisao o, tenaolom bao ngo turi nao hemebur mbinin kone bor khorob bimi sao was wiyaol, mbinim em hundur was turi homoklme ora. Ngub bimil Ngaorom mbini ngo baeben mbes te mao bemberaesao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ngub kobur kakl, Tenaol khorob bu hayem baeben hambun bao mao baraoklao saon saond bi ora hayem ol, mbinin kone bor wiyao ub mondom nao henden ko nen sabobur, mbinim bao bi ngo bor makl aondao bu ora homobur nao ubuklmi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ngub kobur kakl, Tenaol mendbor kone ukl bombor u oborob ora bu haroklme baebenom bao bi ora bor ubuklmil, tenaol hambunom hondoklemi tomb obum kongon hambun sao bu haklao ub obum Ngaor haru habur obun burim ora bu hae ko, mbinim oborob ora hondoklemi ko Njisesom Nikorimas bor ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Angal ngo ngub kao kal peyaoklbir kisaon, mabor Njises obu obun man pange aol baeben di mbini hambun su Njuriya bor pismisa. Ngub pobur kismin mbini ngo bor bao hasmil, Njisesom tenaol mendbor mbabtas bisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ngo tomb Njon Mbabtas Biyao Aolom di su Inon ke mend, su mende Selim teb so bor wisao o ngo bor ib mal andub ora wisaol, tenaol andub ora Njonom mbini mbabtas bin ko obo kiril mba was bu hasmisa. ");
INSERT INTO akh_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ngub bismil Njonom tenaol ngo mbabtas bu hasao o, aol wesmbao Herorom obu kalabus mao pala pe paen lisao ub nao li tomb obum tenaol mbabtas bu hasesa. ");
INSERT INTO akh_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ngo tomb Njon Mbabtas Biyao Aolon man pange aol baeben hesa Nju sem aol is mend kab daol, mbinim mbinin manom ke wisao ub wes wes lu mbabtas bimi on engelom kao kao bu ab saond bismisa. ");
INSERT INTO akh_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ngub bubur kismin Njonon man pange aol baebenom Njon birisaol pobur obu bor kakl, Aol aondao o, njem mbes aol mend hesa ib Njoran mende nan ibi haru habur, njem obun arman tenaol hambunom pangen kao kalo hasndis o, ngubi tomb aol ngo obum di tenaol hambun mbabtas bu hayaol, obum mbini mbabtas bin ko tenaol hambun ora obu hayao bor was po kiril mba hayem kismisa. ");
INSERT INTO akh_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ngub kismil Njon Mbabtas Biyao Aolom mbinin angal ngon ko san lubur kakl, Ngaor yu heben hayaomon aol mend obu bor menjao nao kala sin, aol ngo obun burim was menjao bukl buwaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ngub kobur kakl, Nim ini bor angal ngo, ni Ngaorom Eben Ke Aol inj hae ko kao njundis ol inim ora pangisimndis ka. Ni obu inj o, Ngaorom ni bember peyo mao habur pu kisaol, obu hobao sao ora nao mama eben ko ni mbes obondis kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ngo tomb Njon Mbabtas Biyao Aolom mar mend kobur kakl, Aol mondom ten taol ba sin ten ngo obun ora soklao kisesa. Ngub kobur kakl, Aol ngo obu ten taol buklao o obun aol sango mend hesa buruklebi tomb aol ten taol buklao ngom angal lao o was pangobur, obun aol sango ndam angal ngo lao ub pangaebe turi aondao ora homoklao kisesa. Ngub kobur kakl, Nim ngo kakl ub menger mubur, Njises obum ngo bu haril sao pangakl tomb nao kone bor turi aondao bu ora bu haril kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Wakl kakl, Nim ngo kakl o ninao imbi men mbam mbam buklao tomb obun imbi aondao bu wam wam buklaol kakl ko, Njon Mbabtas Biyao Aolom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Aol mend obu yu heben bor hakl ebe sa sin, obum hambun sao men mbaeb se ora soklaol obu aondao yubu ora soklao. Ngub inj, aol mend obu su ngo bor maru uklemil obu sul ha and sa sin, obu sun aol ora soklaol obum menjao menjao lao tomb di su bor buklaol hondoklao saon was lao. Ngub buklao o aol mend obu heben hakl ebe sa sin, obu aondao yubu ora soklao. ");
INSERT INTO akh_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ngub soklaol obum ngo ko haril sao baeben obun elom di ora hondo, halom di ora pangobur obum tenaol hambun bor ngo kao kalo hae o, mondom obu ngo ko hae ub heneng ora le ko nen sabo angal ngo men hakol nao beyem ka. ");
INSERT INTO akh_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tenaol mendbor obum angal ebe ngo lao ub pangobur men hakol buklemi baebenom angal ngo heneng ora e ko pangobur, Ngaorom heneng heneng was ko haraoklao ub tenaol hambunom henden muwaloklemi. ");
INSERT INTO akh_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Aol ngo obu Ngaorom eben kobur obun Wesao Ebe Tangar aondao bu ora taol bu kalisaol, obum Ngaoron angal ora ko haraoklao. ");
INSERT INTO akh_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Obun Abom obun Isi ngol ora kone u obun buri taol bu kalobur, hambun sao obun Isi ngom was bu haen kisao. ");
INSERT INTO akh_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tenaol mendbor Ngaoron Isi ngol hul ha haklemi baeben mbini haeben ora soklemi. Ngub inj, tenaol mendbor Ab aondaon Isil hul nao hae haklemi baeben, haeben nao sae Ngaorom ngo baeben ko homoklaol mbini ke hondo haeben ora soklemi. ");
INSERT INTO akh_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ngo tomb Peresi tenaol baebenom pangismil, Njon Mbabtas Biyao Aolom mbabtas bu hasao ub men mbabur, Njises obum tenaol andub ora obun man pange tenaol birin kobur mbabtas bu hae ke pangismisa. ");
INSERT INTO akh_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Mbinim ngub kismil pangismi o tenaol ngo mbabtas bu hae ke pangismi baeben Njises obun mbib inj, obun man pange aol baeben bor bib kisaol, obun man pange aol ngo baebenom was tenaol mbabtas bu hasmi bor kismisa. ");
INSERT INTO akh_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ngo tomb Njises obum ngo bu hasao sao mbini Peresi semom pangismi ub haondaoklbir kisaon, obum su Njuriya ngo tuwaklbir su mende Kalili bor wakl bokesesa. ");
INSERT INTO akh_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ngub pisaol harer ngo obu pisao on su Sameriya harer tol wisaol, obu su ngon tukun ora bor pisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ngub pobur kisaon Sameriya ngo bor su and lobokl lobokl menden imbi Saka ke mend wisao o bor pindib paesesa. Ngub pobur kisaon su ngon teb so bor mbes Njekobom obun isi Njoseb kalisao ke su mend wisao bor po pindib paesesa. ");
INSERT INTO akh_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ngub po pindib pabur hindisaol su ngo obu ora pindib paesao ol, mbes Njekobom ib su ndaon bor ebe mend waru wisao o su ngo oral sisesa. Ngo tomb Njises obu harer isom lubur obun toklo bor kang mend kend kend sao bisaol, ngo ib ibisao nda teb sol sao sul ber paesesa. Ngub ber paesao o aond hora haklu ora tomb sisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Obu ngub birisaol Sameriya ten is mend ib ngo humuklbur ibisaol, Njisesom ten ngo bor kakl, Ni ib nokl bil ngao, non humu nji kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ngub kisao o Njises obun man pange aol obu haru pibismi nda baeben, mbini hambun and lobokl lobokl o bor pobur ne dob bukl pismi tomb sisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ngo tomb mbini Nju sem hesa Sameriya tenaol kab saond bi sao ha ha bubur, mbinim ib be bombor o bor no kowal nao bismi o sisaol, Sameriya ten ndam burir biyubur Njises bor kakl, Nje Nju sem aol ora hael. Ni di Sameriya ten ora bere ngao, njem ni bor asub ko ib non nji kal? kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ngub kisaol Njisesom ten ndan angal ngon ko san lubur kakl, Njem Ngaorom tenaol bor pone bao kalaoklao ub hesa, aol ngo nje bor ib non humu nji le o kab oborob ora hondokl bele sin, njem ni bor haeben saroklme ib ngo, non humu nji kokl bael njukl buwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ngub kisaol ten ndam obu bor kakl, Aol aondao o, ib ngo di unu ora bor ebeng, njem mbaker be di ya di mend nao menel ngao, njem haeben saroklme ib ngo kal o abor humuklesib? kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ngub kisao tomb ten ndam wakl kakl, Mbes naon ab sumb Njekobom ib ngo warubur, obum obun mbib di ib ngo no habur kisaon, obun nongnas baebenom di obun some kawao sib baebenom di no hasmil, obum ib ngo nao ora njisao o, njem Njekob obu men mbae ora hael be? kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ngub kisaol Njisesom obun angal ngon ko san lubur kakl, Tenaol hambun ib ngo ebe o noklemi baebenom mbinim wakl ib ko mende nokl homoklemi o, ");
INSERT INTO akh_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ib ngo nim humu kaloklwao kandan, tenaol mendbor ib ngo noklemi baeben mbinim ib ko mende nao nokl homoklemi ora. Ngub inj, nim ib ngo nen humu kaloklwao o ib kend mend ib ha wi wi biyao nda ub menger, obun kone ndaon bor bao ib ha wi wi buklao. Ngub buklaol obum ib ko mende nokl nao heme, obun kone bor haeben saroklme ib ngom kombakl haen habur haeben ora saklao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ngub kisaol ten ndam Njises obun angal ngon ko san lubur kakl, Aol aondao o, nim ko mende ib nokl homo enjo ngo bor ngo humukl engel biyu e ub nao bun ub, njem ni ib ko mende nokl nao heme ngo kal o, non humu nji kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ngub kisao tomb Njisesom ten nda bor kakl, Nje wakl ebenin ub ngubi tomb njen aoli mbes kor bu kaomukl pu kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ngo tomb ten ndam Njises obun angal ngon ko san lubur kakl, Nao aoli mend nao hae kisesa. Njisesom ten nda bor wakl kakl, Njem nao aoli nao hae kal o, njem heneng ora kal kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Njisesom ngub kobur kakl, Njem ngo kal o mbes njen aoli is su oran hasimndis ol, aol mend ngubi tomb ibi buru hayeb o obu njen aoli inj yaong, njem nao aoli mend nao hae ngo kal o heneng ora kal kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ngo tomb ten ndam burir aondao ora biyubur Njises bor kakl, Aol aondao o, nim ngubi tomb oran nje Ngaoron man mini aol ora e ko mao bemberarukl kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ten ndam ngub kobur kakl, Nao Sameriya semon ab sumb wil baebenom naon harbor manda ngo bor was po kiril mbabur Ngaor bor kaoya ko hasmi o, ini Nju semom lome ub tenaol hambunom Njurusalem bor was kiril mba hor boroklwaebe lome kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ngub kisaol Njisesom ten nda bor kakl, Ten o e, njem nim angal ngo kakl o pang. Mabor bao mend buklao tomb inim harbor ngo bor naon Ab Ngaor bor ngo kaoya lome ub di, Njurusalem bor Ngaor bor kaoya lome ub di, ngub was bao kaoya hakol nao buklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Njisesom ngub kobur kakl, Ini Sameriya semom Ngaor bor kaoya ko haroklme ub te nao hendebur ko haroklme o, nao Nju semom Ngaor bor kaoya ko haroklmao ub, Ngaorom tenaol hambun bu muklao ub nao Nju sem bor ora pindib paen laol ko haroklmao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ngub kobur kakl, Nim bao wen mend pindib paklao kanda ngubi tomb pindib parob ol, tenaol mendborom naon Ab Ngaor bor heneng ora kaoya kaem sin, mbinin kone ndaon bor Ngaor haen ora habur, mbinim kone ukl bombor ora u Ngaorom keyao sao ora hem ko men hakol bu habur kaoya lemi kisesa. Ngub kobur kakl, Nao Ab Ngaor obum tenaol mendborom kone ngubi ora ubur, obu bor kaoya ken ko hem ko es bu hayao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Njisesom ngub kobur kakl, Ngaor obu Wesao ora yaol, tenaol mendborom obu bor kaoya kaem sin, mbinin kone ndaon bor Wesao Ebe ngo haen ora habur, mbinin kone ukl bombor u Ngaorom keyao sao ora hem ko men hakol bubur obu bor kaoya lemi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ngub kisaol ten ndam Njiseson angal ngon ko san lubur kakl, Ngaorom Eben Lao Aol Karas mend oboklao lome nda oboklao tomb, obum nao bor hambun so kao njuklao ko ni hende ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ngub kisaol Njisesom Sameriya ten nda obu bor kakl, Njem ngo kal o ni ora yaol, ni nje hesa yao ngo angal kao kao bi hayob o kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ngo tomb Njisesom ngub kakl hasaol, obun man pange aol ne dob bukl pismi nda baeben obobur, mbinin manom ke wisao ub aol baebenom ten hesa hungum angal nao lowaebe ke wisao o, Njises obu hesa angal kao kao bi harbi ko nen sabobur, mbinim burir biyu nen nen andub ora sabismisa. Mbinim ngub bismi o is mondom obu bor ne mu njem asao was miril? ko di, njem asub ko ten ngo hesa angal kakl harbib? ko di, obu bor menjao ne nao mismisa. ");
INSERT INTO akh_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ngo tomb ten ndam Njisesom angal ngo kisao nda baeben pangaoklbir, obun mbaker be ib hum pae nda u haen kaoklbir su and lobokl lobokl bor wakl pisesa. Ngub pobur kisaon obum tenaol hambun kao kalobur kakl, ");
INSERT INTO akh_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Inim aol mend hae o hondokl ubuklub. Aol ngo obum nim mbes bu hawao sao baeben hambun sao kao njang, aol ngo obu Ngaorom Eben Lao Aol ora ye? kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ngub kisaol tenaol and lobokl lobokl ngo bor birismi baebenom su and te ngo tuwaklbir Njises hasaol was obu hondokl ibismisa. ");
INSERT INTO akh_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ngub ibismi o mbinim wen harer bor ibismi tomb Njiseson man pange aol nda baebenom obu bor kakl, Aol aondao o, nje ne nao nale be? Njem ne nao ora kismisa. ");
INSERT INTO akh_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ngub kismi o Njisesom mbini bor kakl, Nim ninao ne tangar sao inim nao hende ora mend wiyu ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Njisesom ngub kisaol obun man pange aol nda baebenom mbini hakl hakl kakl, Obum ne ngo nao naokl o, obu tenaol tangar mondom ne kalaemil nene ye? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ngub kismil Njisesom obun man pange aol ngo baeben bor kakl, Ninao ne tangar sao ngo kanda, ngub menger bor kanda ka. Nim ni obon kisao o obum nen sabeyao ub ora was biyul, nim obun kongon mbes ora sen lowaol, obun angalom tombao haen haruklu kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Njisesom wakl kakl, Inim ngub lome. Ek ukl makl oran pibi haklao tomb em bor ne taloklme bao o pindib paklao lome. Ngub lome o nim ini kao njun ub pangaoklaob. Inim hondo akol bubur em baeben hambun bor hondo akol bib. Ne ngo baeben ebe naeb senel talaeb se e kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Wakl kakl, Aol mendbor em il taloklemi baeben sokl di muklemil, mbinim haeben saroklme ne ngo di talo maemb ko u haklemi tomb, aol em il ngo we bowisao aol o hesa em il ngo talo maemb ko buklemi aol o baeben kab, mbini haru turi aondao bu ora homoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Njisesom ngub kobur kakl, Mbinim ngub buklemil aol mend obum em we boklao o, aol tangar mendem em il ngo taloklao lome ub heneng ora lome kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Njisesom ngub kobur kakl, Mbes em we ngo inim nao bowe, aol tangar mendborom kongon buri ora bubur em we ngo bowismi o, nim ini bor em ngon ndaon hondabur em il ngo wiyao baeben talokl puklub kaklo nda kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ngo tomb ten ngo Njises hen misao ndam su Sameriya and lobokl lobokl ngo bor tenaol birismi baeben bor, Njises obum nim mbes bu hawao sao baeben kao nja ko kao kalisesa. Ngub bisaol su Sameriya ngon tenaol andub ora Njisesol hul ha habur ismin ");
INSERT INTO akh_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Njises obu hasaol obobur, njem nao tuwakl nao pe baoklmend nao haru bao beremin ko kao deb deb bismil, obu su ngo bor bao hor kab oran bao birisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ngub bao birisao tomb tenaol andubom ora obum angal bib ebe ngo kisao o pangobur, Njises obul hul ha hasmisa. ");
INSERT INTO akh_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ngo tomb Sameriya tenaol nda baebenom ten ngo Njises hen misao nda bor kakl, Naom ngubi tomb njem angal kaenda was pangobur inj, aol ngo obul hul ha haraoklaom ka. Ngub inj, naom naon mbib di obun angal pangaoklaom tomb aol ngo obu sun tenaol baeben hambun Bu Maoraoklao Aol e ko ora haondaoklaom kismisa. ");
INSERT INTO akh_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ngo tomb Njises obu bao hor kab ngo su ngo bor baoraoklbir kisaon, obum su ngol haklbir su Kalili pisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ngub pobur kisaon Njises obun mbib bor te kao pabur kakl, Man mini aol mondom Ngaoron man tenaol hambunom pangen kam akol bu haklao tomb su hambun bor obun imbi wi ngaklao o, obun su ora bor obun imbi nao uklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ngub kao peyaoklbir kisaon Njises obu su Kalili pisaol, Kalili tenaol baebenom Njises ngub ibisaol hindismi tomb, Njises obum Njurusalem bor hor so boroklme bao on hambun sao bisaol mbinim di haondaokl ibismi on nen sabobur kismin, turi aondao ora homobur oborob obaokl ko nen sabismisa. ");
INSERT INTO akh_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ngo tomb Njises obum mbes ib henengom wakl ib waen men aolin kisao su ndan imbi Kalilin su Kena bor wakl pisesa. Ngub pobur kisaon su Kabenam bor kabmanon maomb bo haraoklao aol mend hasao on isi sen ha wisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ngub bisao tomb aol ngo obun nongnas homo wisao ndam pangisaol, Njises obu su Njuriya haklbir Kalili bor obo hae kismil pangobur obun isi ora pe pakl ko bi birisaol, aol ngom Njises hasaol pobur nao isi homo wiyaong mao enjanin ub su Kabenam inin mbao ko kao deb deb bisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ngub kisaol Njisesom aol ngo obu bor kakl, Inim tenaolom ko mend nao hindismi sao di burir biklme sao di tangar ubi sao menjao nao hendeme tomb inim Ngaorol hul ha nao haroklme ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ngub kisaol maomb bo haraoklao aol ndam Njises bor kakl, Aol aondao o, nao isi ngo pe paklao, nje penar bu ora inin mbao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ngub kisaol Njisesom obu bor kakl, Njen isi ngo ngubi tomb enjo bereyaong njen anda pu kisaol, aol ndam Njisesom ngo le ub heneng buklao ora ko nen sobaoklbir pisesa. ");
INSERT INTO akh_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ngo tomb aol nda obu obun anda poklbur wen harerol pukl hasaol, aol ngo obun kongon bimi aol mendbor harerol obu hen mukl obobur kakl, Njen isi nda ebe enjo bere kismisa. ");
INSERT INTO akh_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ngub kismil aol ndam obun kongon bimi aol nda baeben bor ne mubur kakl, Nas ngo obu hokloben sao be? mbonao sao be? atomb ora obu kang mend ebe sam sam bab? kisesa. Ngub kisaol mbinim obu bor kakl, Mbakla nar kang mend as deyarnaol 1 kolok tomb nas ngo obun pob turub aondao ngo kur ka kismisa. ");
INSERT INTO akh_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ngub kismil nas ngon ab ndam nen sab heneng bisaol, mbakla nas ngo enjaokl paonao kismi ora tomb Njisesom obu bor njen isi ngo enjo bereyao kisao nda nen sabisesa. Ngo tomb aol nas ngon ab ndam Njisesol hul ha hasaol, aol ngo obun sem baebenom di Njisesol was hul ha hasmisa. ");
INSERT INTO akh_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ngo tomb Njises obu su Njuriya tuwaklbir Kalili ngo pisao tomb obum tenaolom ko mend nao hindismi sao ko mende su Kalili ngo bor ngo bisao o, obum su ngo bor was ko kabo mao ha, nas ngo mao enjaesao o sisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ngo tomb mabor Nju semon hor boroklme bao mend pindib paesaol, bao ngon Njises obu Njurusalem yin pisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ngo tomb su and lobokl lobokl Njurusalem aondao ngon paeb mbuklu tundae ngon tiriyao kombae mend wisaon imbi Some Sibon Tiriyao kismil, tiriyao kombae ngon teb so oral ib mal kang mend wisesa. Ngub wisaol Hiburu angal kobur ib mal ngon imbi Betesta kismil, ib mal ngon marel and kang kang ukl su mend hasesa. ");
INSERT INTO akh_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ngub hasaol and kang kang ngo hasao baeben bor tenaol sen hae andub ora wismil, tenaol mendbor el kho di aongao kho di mendbor ki aongao tibarae di, mbini hambunom angal mini wesao mondom ib mal ngo mao el el bakl eben ko bao hondo buru hasmisa. ");
INSERT INTO akh_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ngub hondo buru hasmi tomb ko mend ko mend Aorao Aondaon angal mini wesao is mend ib mal ngo wisao o bor hond ha obo ber was bisao tomb, ib mal ngo el el bu kimb bi was bisesa. Ngub bisaol tenaol ngo sen u hasmi haklon is mondom akl obu mbes pobur ib mal ngo bor hondaesao tomb, is bombor ngo pibnao ora po hondaesao o, obun sen ebe sao was bisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ngo tomb Njisesom hindisaol aol is mend obu sen ha u hasao o, obu karasmas supu hor mend ingi mbabur hor menden supun kab oran u hasao o, and kang kang ngo hasao ndaon obo u mba hasaol hindisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ngo tomb Njisesom aol nda u paolu wisaol hindisao tomb, aol ngo obu sen mbes ora u hae sisaol hondobur aol nda obu bor kakl, Njem njen sen ebe sen sa ko pangal be? kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ngub kisaol aol ngo sen ha wisao ndam obun angal ngon ko san lubur kakl, Aol aondao o, ib mal ngo bor el el beyao tomb aol mondom ni bisur bu ib mal ngo bor hondan ko nao mini puklao ora. Nao mbib non pokl ko bi baraklo o, tenaol mendborom ni men mbaklbir mbini mbakla was po haroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ngub kisaol Njisesom aol nda bor kakl, Nje teka peyobur njen to abo mu minibir njen anda pu kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ngub kisaol penar bu ora bombor ngo tomb aol ngo obun sen ebe ora bao sisaol, obun to nda mu minibir obun anda pisesa. Ngub bisao o bao ngon Nju semon hor boroklme bao on sisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ngub sisaol Nju sem mendborom aol ngo obun sen wakl ebe sisao nda bor kakl, Embi bao ngo nao Nju semon hor boroklme bao* on sandal, njem njen to ngo naon hor boroklme bao on kongon bi non bi soklao ko, naon manom ke wiyao ub nao mini poklesi ora kismisa. ");
INSERT INTO akh_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ngub kismi o aol ngom mbinin angal ngon ko san lubur kakl, Aol ngo ninao sen ebe mao saraokl om ni bor ngub kaonao ka. Njen to abo ngo mu minibir, njen anda pu kaonao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ngub kisaol mbinim wakl obu bor ne mubur kakl, Aol ngo obu aebom ora nje njen to ngo mu mini pu kaonaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ngub kismi o bao ngon su ngo bor tenaol andub ora hasmi tomb sisaol, aol ngo obu sen ha wisao o wakl ebe sisao ndam, Njises obu bao bum hasaol hondokl buwabur es buwaesesa. ");
INSERT INTO akh_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ngo tomb kang mend mabor sao Njises obum aol ngo sen ha wisao o mao ebe saesao nda Ngaor Hen Moroklme Anda bor birisaol hondobur kakl, Pangal. Ngubi tomb njen sen ebe sandang, mabor nje ke mao handaraoklao sao aondao bu ora kond bam bam bi soklaong, ngub nao bin ub njem khorob ko mende nao bibi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ngub kisaol aol ngo obun sen wakl ebe sisao ndam Nju sem birismil wakl pobur kakl, Aol ngo ni ebe mao sanesa nda obu Njises senesa ko kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ngo tomb Njisesom mbini Nju semon hor boroklme bao on ngub bisaol, mbinim Njises obu hondo ko bowes bu taolu lismisa. ");
INSERT INTO akh_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ngub bismil Njisesom mbinin angal ngon ko san lubur kakl, Nao Ab obum bao hor hambunon kongon bu kimb was biyaol, nim di ngub was bu haruklu kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ngub kisaol Nju sem nda baebenom obun angal ngo pangismi tomb Njises obum naon hor boroklme bao on nao bibi ke wiyao sao di banda o, obum ngo sao was inj, obum Ngaor di nao Ab ora yao le ka. Obum angal ngo le ub obu Ngaor hesa yao bombor ubi ora hayob ko menger maraokl kobur kismin, mbinim Njises ko aondao ora homobur obu pe paen lemin ora kismisa. ");
INSERT INTO akh_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ngo tomb ngub kismil hondobur Njisesom mbini bor kakl, Nim ini bor heneng ora kao njurukl, Ngaoron Isi obum obun mbib nen sabobur menjao menjao bukl buwaklao ora. Ngub inj, obum obun Abom bu haraoklao ub hondobur, obun Abom hambun sao bombor ngo bu haraoklao ub was Isim di bu haraoklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Njisesom ngub kobur kakl, Obun Abom obun Isil ora turi homo kone ubur, hambun sao obum bu haraoklao ub obun Isim di bu haen ko muwalo haraoklaol, obun Abom mabor kongon mendbor aondao bu ora bu haen laol, obum ngubi tomb ngo bu hae ub men mbae ora buklaol hondobur, inim burir aondao ora biklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ngub kobur kakl, Obun Abom tenaol hememe o wakl mao enja haraoklao ub, obun Isim di bombor ngub was obun konem beyao ub tenaol heme baeben wakl mao enja haraoklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Njisesom wakl kakl, Obun Abom tenaol is bombor ora di mend te mao bembera nao sarbeklao ora. Ngub inj, tenaol hambun te mao bembera sarbeklao ub obun Isim was kongon ngo bin kalisao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ngub kobur kakl, Obum ngub bu haklaol tenaol hambunom obun Ab bor kaoya ko haroklme ub mbinim Isi bor di bombor ngub was kaoya lemi ora. Tenaol mendbor Isi bor kaoya nao lemi baebenom obu eben kisao o, obun Ab ngo bor ora nao kaoya lemi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Njisesom wakl kakl, Nim ini bor heneng ora kao njurukl, tenaol mendborom nim lowao ub hul nao hae pangobur ni pu kisao ol hul ha harim sin, mbini haeben soklemi ora. Ngub buklemil Isi obum mbini bor menjao te mao bembera howes nao lao ora. Ngub inj, mbini ngo baeben tenaol homoklme ub ora tuwaesmil, ngubi tomb mbini haeben ora sarukl haeme kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Njisesom ngub kobur kakl, Nim ini bor heneng ora kao njurukl, bao mend buklao ke wisao o ngubi tomb mbes bu pindib parobndal, tenaol heme baebenom di Ngaoron Isin angal pangoklemil, mbini ngub pangoklemi baeben haeben saklbur wakl enjoklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Njisesom wakl kakl, Ab obu haeben saroklmen te ora habur obum obun Isi bor buri aondao ora taol bu kalisaol, Isi obu di bombor ngub was haeben saroklmen te ora hayao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ngub kobur kakl, Obu Aolon Isi Ora yaol, obum tenaol hambun te mao bembera taol bin ko obun Abom buri taol bu kalisao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Obum ngub kobur kakl, Mabor bao mend buklao tomb tenaol himismil tangaesmi baebenom Aolon Isi Ora obun angal pangokleming, nim ngo bu haklwao kandisao baeben pangobur burir nao biklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Njisesom ngub kobur kakl, Tenaol himismil tangaesmi baeben mbinin maol bor wakl enjaoklbir dera oboklemil, tenaol mendbor oborob bu hasmi o himismi baeben wakl enjoklemi tomb mbini haeben ora soklemi o, tenaol mendbor khorob bu hasmi o wakl enjoklemi baeben mbini bor te mao bembera ke mao handaklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ngo tomb Njisesom ngub kobur kakl, Nim nao mbib was habur bombor sao mend bukl buwaklwao ora. Ngub inj, nim hambun sao nao Abom ko haraoklao ub nim di men hakol ora bubur, nim angal ngom was tenaol hambun te mao bembera taol buklwao o nim nao mbib nen sobaklo ub inj, nim ni obon kisao om nen sabeyao ub ora tenaol hambun te mao bembera taol buklwaol, nim ngo buklwao ub oborob ora buklwao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Njisesom wakl kakl, Nim nao mbib ni hae on te ngo kao dund bu haruklu e ub ni bomborom was habur ko haru sin, nim ngo ko haruklu ub heneng ora inj sokl beyao ka. ");
INSERT INTO akh_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ngub inj, nim di ora hende ub aol mende mend haklao om di, ni ngo hae on te tenaol mendem pangen kao dund buklao tomb obum ngo lao ub heneng ora lao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Njisesom ngub kobur kakl, Mbes inim Njon Mbabtas Biyao Aol hasaol aol mendborom ne mukl pen kismi tomb obum heneng ora kao pabur kao njisao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Wakl kakl, Ngub bisao o Njonom ngo kisao ub tenaolom ni hae on te was ken ko hem ko nen nao sobaklo. Ngub inj, nim Ngaorom ini hambun men min ko ora nen sobaklol, nim ini bor angal ngo kao njurukl kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Njisesom wakl kakl, Njon Mbabtas Biyao Aol obu laomb non bi habur tenaol hambun bor bao ha ngaen kisaol, inim obu bao ngo bin kisao ub wen hindismi tomb inin kone bor kang baoklmend turi himismi o, mabor makl himismi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Njisesom ngub kobur kakl, Mbes Njonom ni hae on te oborob ora kao dund bisao o, nim bu haruklu saom Njonom te ngo kisao ub di men mbabur oborob ora kao dund biyao. Nao Abom nim kongon hobao sao ora bun kisaol, nim kongon ngo buri palo bu haruklu nda ub ini hambun ora hendeyem ngao, nao Abom ni pu kise ko nen saboklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Njisesom wakl kakl, Ninao Abom ni obon kisaol obun mbib ora ni hae on te muwalo haraoklao o, inim obun angal kang ora di nao pangebur inim obun el wil di ko mend nao hindismi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Obum ngub kobur kakl, Inim aol ngo obu obun Abom eben kisao ol hul ha nao hayem ol, obun angal ngo ini bor keyao o di inin kone bor kang ora di nao wiyao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Njisesom ngub kobur kakl, Inim Ngaoron mbuk waeb wiyao ub was hondoklmao tomb nao nao heme ebe haeben soklmao ko pangobur, inim Ngaoron mbuk waeb ngo bor hambun sao wiyao ub aondao bu ora es es bimi. Ngub bimi o pangeklem. Mbuk waeb ngom ni ngo hae on te ora mu waloklbur wiyao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Wakl kakl, Ngub ora wiyao o inim ni taol mi obobur haeben sakl ebebe on makl aondao ora homoklme kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Njisesom ngub kobur kakl, Tenaol hambunom ninao imbi aondao bu ora mao waen ko nen nao sobaklo o ");
INSERT INTO akh_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","nim ini ora hende ol, inim inin kone bor Ngaor hem ko kone nao wi ora hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Njisesom mbini bor wakl kakl, Nao Abom ora obun buri taol bu njubur ni ngub obon kisaol, ni non nao Ab hayao bor haklbir obowao o inim nao angal ngo nao pangeyem ka. Ngub beyem o inim inin aol mend obun mbib was habur imbi wi aondao ora hayao om angal menjao menjao keyao tomb oborob ora pangoklme kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ngub kobur kakl, Ini bor inin aorao haemem nje imbi wi ora hael keme tomb inim turi aondao ora homoklme o, Ngaorom ini imbi wi aondao ora haen ken ko nen nao sabeyem ol, ini non bi baebenom Ngaorol hul ha hakl buwaklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Njisesom wakl kakl, Pangklem. Inim inin kone bor ini ngo baeben nim ora nao Abon elol te mao bembera sarbeklao ko nen nao saboklwaebe ora. Ngub inj, inin ab sumb Moses obu Ngaoron man mini aol hobao sao ora hasaol, obum nao bisur buklao ko nen sabeyem o, obum ora ini te mao bembera sarbeklao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ngub kobur kakl, Moses obum ni ngubi tomb ngo hae ub haklwao on angal ora waeb bu wisaol, Mosesom man kisao ol heneng ora hul ha hakl bemen, inim nil di ebe hul ha hakl beme kisesa. ");
INSERT INTO akh_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ngub kobur wakl kakl, Inim Mosesom man ngo waeb bu wisao ol hul ha nao harim sin, inim asub ora bubur nim angal ngo ko hae ol hul ha haklemib ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ngo tomb mabor Njises ib Kalili mal ngon imbi mende Tabiriyas kismil, ib ngon mende nan pisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ngub pisao o tenaol aondao andub oram Njises obum tenaolom mbes ko mend nao hindismi sao tenaol sen hae andub mao enjaesao ub hindismil, mbinim Njises obu pisao bor wen mama taol mi ubukl wismisa. ");
INSERT INTO akh_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ngo tomb Njises obu yu manda mend sisao bor pobur, obun man pange aol baeben daol yu ngo bor bao birismisa. ");
INSERT INTO akh_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ngub birismi o Nju semon Waran Aeben Bisao bao o pindib paklbur teb sam sab bisao tomb sisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ngo tomb Njisesom hend peb bisaol obum tenaol aondao khorob ora obun mama ibismi nda baebenom obu biri ibismil hondobur, obun man pange aol Pilib bor kakl, Naom tenaol aondao ngub baebenom naeb se ne abor dob buklmaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Njisesom ngub ngo kisao o obum obun mbib ngo sao ngub buklwao ko ora hondobur o, obun man pange aol ngom asub leb ko hondoklbur kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ngub kisaol Pilibom obun angal ngon ko san lubur kakl, Naom mone so andub ora supu hakl hakl hor tobon kabom ne dob bam sin di, tenaol aondao ngo hayem baebenom ngaorukl pelen nao noklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ngub kisaol Njises obun man pange aol is mend obu Pitan haeme Andurom Njises bor kakl, ");
INSERT INTO akh_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Nas kang ngo hae om palawe sem menden imbi bali palawe pao su mend di, ib wen is kab mend di ngo ora wi o, tenaol aondao ngo bereyem baebenom ngaorukl pelen nao naeb se ora e kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ngub kisaol Njisesom obun man pange aol baeben bor kakl, Tenaol hambun sul baoraoklaob laob kisaol, homa ngol haom naom ebe andub ora wisaol, tenaol aondao ngo hasmi baeben homa naom so ngol sul birismi tomb aol baeben was ware pe ndi minismil 5,000 bukhoma iri non bi andub ora sisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ngub birismil Njisesom palawe pao su nda mu munubur Ngaor bor tengiyu kao peyobur kisaon, palawe nda tenaol aondao ngo birismi nda baeben taol bu kalobur kisaon, ib wen nda di ngub was taol bu kalobur obum tenaol hambun bor mbinim turi homo nji ko nen sabismi ub was kal kal bisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ngo tomb tenaol hambunom ebe no tombao hasmil, Njisesom obun man pange aol nda baeben bor kakl, Tenaol mendbor dem homo woroklmeng, inim ne nokl nao hae abo ngo bao wi baeben bomborol was mu maemb laob kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ngub kisaol tenaol hambunom bali palawe pao su nda ebe no tombao habur nokl nao bisaol bao win waesmi nda baeben, mbasker nu tokl duteb oran mar pa wismisa. ");
INSERT INTO akh_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ngo tomb Njisesom tenaolom ko mend nao hindismi sao ngo bisao o tenaol ngo hasmi baebenom hondobur kakl, Aol ngo obu Ngaoron man mini aol mend oboklao lomao nda sene kismisa. ");
INSERT INTO akh_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ngub kismi tomb Njisesom mbinin kone bor ora hindisaol, mbinim obu men habur mbinin aol wesmbao aondao ora haen koklbur bismil haondaoklbir kisaon, sub ora obu hungum yu har ne nda bor wakl pisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ngo tomb mbon so nend kisaol Njises obun man pange aol nda baeben unu ib mal wisao ndan mare bor pobur, ");
INSERT INTO akh_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ib taokaoll on baoraoklbir mbinim su Kabenam poklbur, ib mal aondao ngo wisao on kombe kobaesmisa. Ngub bismi o Njises obu nao ebe haen was nend kao mbaesesa. ");
INSERT INTO akh_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ngo tomb ib mal ngo bor posabsu aondao ora obobur ib khorob ora lu taongulu taokl en aeben bisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ngub bisaol mbinim ib taokaoll ngon baoklmend oran kilometa el su dowa be? menjao aebe taokl pismi tomb, Njises obu ib hu kemol aongao hakl hakl ib taokaoll ngo mbini pukl hasmi nda teb sol ibisaol, obun man pange aol nda baebenom hondobur burisao po pakl aondao ora himismisa. ");
INSERT INTO akh_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ngub pakl himismi o Njisesom mbini bor kakl, Ni Njises ora ebeng, inim pakl nao homoklwaebe ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ngub kisaol mbinim Njises obu turi homo ib taokaoll ndaon bor ib kismil honda ber men ora bisao tomb, penar bu ora su ngo mbini poklbur pismi nda oral bao ora pindib paesmisa. ");
INSERT INTO akh_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ekera nan bao bisao tomb tenaol aondao ngo Njisesom ne taol bu kalisao nda baebenom ib mare mende nan bao ha mba habur nen sab heneng bismil, mbakla non ib taokaoll tangar mende Njises obu poklao mend nao wi ora sanda ka. Aoh, tokl bombor ora wanda o, mbini Njises obun man pange aol baeben was paemnda tomb obu nao haru ora paemnda ko nen sabismisa. ");
INSERT INTO akh_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ngo tomb ib taokaoll mendbor su Tabiriyas haklbir su ngo Njisesom palawe mend mu munubur Ngaor bor tengiyu kao peyobur, tenaol hambun taol bu kalisao nda teb sol ibismisa. ");
INSERT INTO akh_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ngub ibismil tenaol ngo hasmi nda baebenom mbakla Njises obu obun man pange aol baeben daol haru ib taokaollon nao paemnda ko es buwaklbir kismin, mbinim ib taokaoll mendbor su Kabenam ngo Njiseson man pange aol nda baeben pismi o bor poklbur pibismil, mbinim ib taokaoll ngo hakl bor honda baoraoklbir Njises es bukl pismisa. ");
INSERT INTO akh_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ngo tomb tenaol nda baebenom Njises obu ib ngon mende nan birisaol hend wabur mbinim obu bor kakl, Aol aondao o, nje enjo ngo bor atomb obaeb? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Nim ini bor heneng ora kao njurukl, nim tenaolom ko mend nao hindismi sao mend mbakla buwaol inim handaemnda ub hem kobur inj, inim ni es bukl obaemi ka. Ngub inj, nim ini mbakla ne andub ora mend taol bu njuwaol naemnda ub hem ko, ko mende noklbur ni es bukl obaemi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Njisesom ngub kobur kakl, Inim ne kho so bowes bu, bung bu ngub biyao sao ngo hakl was nao es bu noklwaebe. Ngub inj, inim haeben saroklme ne bao wi aeben soklao ngo ora no haklwaebe ka. Ab Ngaoron Isim hambun sao bu haen ko haen kisaol, haeben saroklme ne ngubi Aolon Isi Ora obum ini taol bu njuklao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ngub kisaol mbinim obu bor kakl, Naom asub ora bubur Ngaoron kongon buklmaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Pangeklem. Inim Ngaoron kongon buklbur Ngaorom eben ke aol ngo obul hul ha ora haklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ngub kisaol mbinim Njises bor kakl, Naom njem tenaolom ko mend nao hindismi sao oran asao ora buklesil hondoklmao tomb, njem angal ngo heneng ora kal ko nen sabo njel hul ha habur, njem kongon di ngub ngo bu hael ko hondoklmaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mbinim ngub kobur kakl, Mbuk waebom ke wiyao ub obum ne yu heben pange mbinim nen ko eben kisao ke wiyaong, mbes naon ab sumb wil baebenom su tenaol nao biri bor hasmi tomb ne yu heben hakl ibisaol no hasming, njem di ngub buklesi be? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ngub kismil Njisesom mbini bor kakl, Nim ini bor heneng ora kao njurukl, Mosesom inin tenaol bor ne ngo taol bu kalisao ub yu heben pange ora inj taol bu kalisao ka. Ngub inj, nao Abom ini bor ngo taol bu njerekle ub ora, yu heben pange taol bu njaoraoklao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ngub kobur kakl, Yu heben haklbir su ngo bor tenaol haeben mao saklbur ibisao aol nda obu Ngaoron palawe non bi ora yaol, Ngaorom obu ora ini bor ne non bi ngo njaoraoklao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Njisesom ngub kisaol mbinim obu bor kakl, Aol aondao o, njem nao ne yu heben pange ngo kal o, hor hor was naomun taol bu nji ha haebe kismisa. ");
INSERT INTO akh_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ngub kismil Njisesom mbini bor kakl, Haeben saroklme ne ngo ni ora hael, tenaol mendbor ni hae ol oboklemi baeben mbinim dem ko mend nao homoklemi ora. Tenaol mendborom di nil hul ha harim sin, mbinim ib di nokl nao homoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Njisesom wakl kakl, Ngub buklemi o nim ini bor mbes kao njanda ub inim nim biyu sao di ora hendeyem o nil hul ha nao hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ngub kobur kakl, Nao Abom tenaol mendbor ni hae ol eben kokl buklao baeben obun mbib ora ni hae ol eben lao. Ngub buklaol mbinim ni haklwaol oboklemil, nim ngo oboklemi baebenon is bombor ora di mend nje pu nao lowao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Njisesom ngub kobur kakl, Nim heben tuwaklbir su enjo ngo bor nao konem buklao ub was bu haklbur inj obowao ka. Ngub inj, nim su ngo bor ngo obondis ub, aol ngo ni pu kisao o obum nen sabeyao ub ora bu haklbur ora obowao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Obum wakl kakl, Aol ngo ni pu kise o obun kone ngub waoraoklao ka. Obum tenaol mendbor ni hae ol eben lao o baeben, nim is bombor ora di nao baondib munun ko nen sabeyao ora. Ngub inj, tenaol ngo ni hae ol oboklemi baeben mabor bao bu kowes ora buklao tomb mbini hambun mao enja haeben mao san ko nen sabeyao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Njisesom ngub kobur kakl, Nao Abom ngub turi homaoklao ka. Tenaol hambunom obun Isi hondobur Isi ngol hul ha haroklme baeben, mbini ko mende nao heme haeben ora saen ko nen sabaoklaol, mabor bao bu kowes ora buklao tomb nim mbini ngo baeben men mubur mao enjaklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ngo tomb Njisesom ngub ne yu heben hakl ebe ngo ni ora hae kisaol, Nju sem ngo hasmi nda baebenom angal ngo pangobur, mbinim Njises bor makl homobur angal andub ora kismisa. ");
INSERT INTO akh_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ngub bubur mbinim mbini hakl hakl kakl, Inim asub nen sabeyem? Aol Njises ke ngo obu Njosebon isi ora sandal, naom obun am ab kab di ora hendeyom o, obum asub ko nim heben bor hakl obowao le bo? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Inim ini hakl hakl makl homo angal andub ora nao laob kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ngub kobur kakl, Tenaol mondom ni baehaemen ora nao taol mi oboklao ora. Ngub inj, nao Abom ora ni pu kisaol, obum obun mbib tenaol mendbor ni hae ol eben lao ub mbinim ni taol mi oboklemil, nim mabor bao bu kowes buklao tomb mbini mao enjabur haeben mao saklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Njisesom wakl kakl, Mbes man mini aol hasmi baebenom mbuk waeb bu wismi ub, Ngaor obun mbib ora tenaolon kone bor kao dund buklao ko waeb bu wismisa. Ngub bismil tenaol mendbor Ngaoron angal ngo pangobur oborob ora nen saboklme baebenom ni hae ol ubuklmi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Njisesom ngub kobur kakl, Nim ngo kakl ub non, tenaol mondom Ngaor obu elom hindisao kobur inj kanda ka. Ngub inj, aol is bombor ora ngo obu Ngaor hesa haroklbe o ibisndisom bombor o obun Ab hendeyao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Njisesom ngub kobur kakl, Nim ini bor heneng ora kao njurukl, tenaol mendbor nil hul ha haklemi baeben ko mende nao heme haeben ora soklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Wakl kakl, Ni tenaol haeben mao saraoklao ne ora yao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Obum ngub kobur kakl, Mbes inin ab sumb wil baebenom su tenaol nao biri bor hasmi tomb ne mend Ngaorom yu heben hakl eben kisaol nismi o, ne heneng ora sisaol mbini tenaol ne ngo nismi baeben himismi ora. ");
INSERT INTO akh_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ngub bismi o nim ne tangar yu heben hakl ebe mend kandan tenaol mondom na sin, obu ko mende nao homoklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Njisesom ngub kobur kakl, Ni tenaol haeben mao saraoklao ne yu heben hakl ebe ngo kanda ora hael, tenaol mondom ne ngo na sin obu haeben soklao ora. Nim ne ngo kaloklwao kanda nim nao toklo nen kaloklwao bor kandal, sun tenaol baeben haeben saen ko nen kaloklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ngo tomb Njisesom ngub kisaol Nju sem ngo hasmi nda baebenom mbini hakl hakl ab saond bi bi bubur kakl, Inim asub nen sabeyem? Aol ngom obun toklo naom naomun njuklaol, naom ebe noklmao be? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ngub kismil Njisesom mbini bor kakl, Nim ini bor heneng ora kao njurukl, inim Aolon Isi Oran toklo hesa ibao kab nao naem sin, ini bor haeben saroklme sao tangar mend nao wiyao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ngub kobur kakl, Tenaol mendbor nao toklo hesa ibao kab noklme baeben mbini haeben ora saklbur haemel, nim mabor bao bu kowes ora buklao tomb mbini ngo baeben mao enjabur men muklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Njisesom ngub kobur kakl, Nao toklo ne heneng noklme sao non bi ora yao ka. Nao ibao di ib heneng noklme sao ora non bi yaol kanda kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Obum wakl kakl, Tenaol mendbor nao toklo hesa nao ibao kab noklemi baeben mbinim ni haru ora haklemil, nim di mbini nao tuwae haru was haklwao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Njisesom ngub kobur kakl, Nao Ab haeben saraoklaom ora ni pu kisaol, ni di nao Abon buri oram haeben saklbur hae ka. Menger bombor ngub was mubur, tenaol mendbor ninao toklo noklemi baeben di mbini ninao buri oram haeben soklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Wakl kakl, Nim ne yu heben hakl ebe ngo kanda, mbes inin ab sumb wil baebenom su tenaol nao biri bor ne heneng mend yu heben hakl ibisao nismi o, mbini himismi sanda hesa bombor ubi inj ka. Ngub inj, nim ngubi tomb ne ngo kanda noklemi baeben ko mend nao heme haeben ora soklemi ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Njisesom angal ngo kisao baeben su Kabenam Nju semon man pangoklme anda andaon bor burubur, tenaol hambunom pangen kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ngo tomb Njises obun man pange tenaol baeben andubom ora obum mbini bor angal ngo kao kalisao nda baeben pangobur mbini hakl hakl kakl, Angal ngo le baeben naom pangokl buwaeb se kend bi aondao ora leng, nje aebom ora pangoklesib? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Mbinim ngub kismi o Njises obun man pange tenaol baebenom obum mbini bor angal ngo kao kalisao ndan angal andub ora ngo kismi ub hondobur, mbinin kone bor ora hindisaol obum mbini bor kakl, Nim ini bor angal ngo kao njandam inin kone bor kho mao saklao ko pangeyem be? kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Njisesom mbini bor ngub kobur kakl, Aolon Isi Ora obu mbes hasao bor wakl yin poklao tomb inim asub buklemib? kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ngub kobur kakl, Pangeklem. Ngaoron Wesaom ora tenaol haeben mao saraoklaol, inin toklo songolom nen sabobur bimi saom ini kang ora di bisur bukl buwaklao ora. Aoh, nim angal ngo Wesao ndan angal ora kao njurukl ngao, nim angal ngo kakl sao baebenom ora tenaol haeben mao saklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Njisesom mbini bor wakl kakl, Nim ngo kakl ub bor kanda o, ini ngo hayem haklon mendborom nil hul ha nao hayem kisesa. Ngub kisao o Njises obum tenaol mendbor obul hul ha nao hasmi baeben mbes ora di hondo was habur kisaon, aol Njuras obu mabor Njises obu karu lisao aol ndan kone bor di ngub buklao ko hondo ora habur o kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ngo tomb Njisesom kakl, Nim tenaol mendborom nil hul ha nao hayem ko ngo kakl on te ngub wiyao. Nim ini bor pibnao kao njanda ub nao Abom tenaol mendbor ni hae ol nao eben ka sin, mbinin mbib ni hae ol obokl buwaklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ngo tomb Njisesom mbini bor angal ngo baeben kao paesao tomb obun man pange tenaol aondao ngo hasmi nda baebenon mendborom obu tuwakl paokl ora pobur kismin, mbinim obu haru ko mend akol bem ko di nao ebe paokl ora pismisa. ");
INSERT INTO akh_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ngub bismil hondobur Njisesom obun man pange aol duteb nda bor kakl, Inim di ni tuwakl pokl ko nen sabeklem be? kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ngub kisaol Simon Pitam obun angal ngon ko san lubur kakl, Aorao Aondao o, nje bombor o haeben saroklme angal mini aol ora hael ngao, naom nje tuwaklbir aeb ora taol mi poklmaob? kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Pitam ngub kobur kakl, Naom nje Ngaorom komb bi ora haen kisao ko ora hondobur, naom njel hul ha ora hayom kisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ngub kisaol Njisesom Pitan angal ngon ko san lubur mbini bor kakl, Inim asub nen sabeyem? Nim ini is duteb oran sablo mao handis o, ini ngo haklon is mend kone kho wi Seran ung bu khorob bukl bi mend haru hayem ko Njisesom ngubkisesa. ");
INSERT INTO akh_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Njisesom ngo kisao o Iskeriyaor Simonon isi Njuras obu man pange aol ngo haklon duteb nan o obu sisaol, mabor Njises karu lisao aol ngo bor kisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ngo tomb ngon mabor sao Nju sem mendborom Njises obu pe paen luklbur birismil, obum su Njuriya bor nao pe su Kalili bor was bao akol akol bu hasesa. ");
INSERT INTO akh_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ngo tomb Nju semon hor so boroklme bao menden imbi and paek nda bor ne noklme hor so kismil, hor so boroklme bao ngo teb sisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ngub bisaol Njiseson haeme wil nda baebenom obu bor maobowabur kakl, Njem su ngo tuwakl pobur lesin, njen man pange tenaol baebenom njem kongon buklesi sao baeben henden ub su Njuriya pu kismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mbinim ngub kobur kakl, Aol mondom obu tenaol hambunom ni imbi wi ora hae ko henden haklwao ko nen soba sin, obum hambun sao bu haklao sao baeben mupango nao bu haklao ora kismisa. Mbinim Njises bor wakl kakl, Njem hambun sao ngo bu hael sao baeben tenaol hambunom henden bukl pae sin, ebe ora soklao kismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Njises obun haeme wil baebenom ngub kismi o mbinim di Njises obul hul ha nao haebur o, obu maobowabur baehaemen kismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ngub kismil Njisesom mbini bor kakl, Inim nen sabo bu haroklme ub bao hor hambunon ebe was ko nen saboklme o, nim tenaol hambunom henden kongon buklwao bao o nao pindi pae wen kisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ngub kobur kakl, Sun tenaol baeben hambunom ini bor non ko homo nar wen ebe hende non nao buklemi ora. Aoh, nim non mbinim khorob bimi sao baeben, inim ngo sao khorob bu hayem ko tenaol hambunom pangen kao paruklul, mbinim ni bor oran ko homo nar wen ebe hende non bu nao saond bi sao haroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Njisesom wakl kakl, Inim and paek nda bor ne noklme hor so ngon ne no ini hondokl puklub ora. Ni non tenaol hambunom henden kongon buklwao bao o teb nao se wen yaol, nao poklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Njisesom ngub kobur kisaon obu Kalili bor bao hasesa. ");
INSERT INTO akh_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ngo tomb Njiseson haeme wil nda baeben and paek nda hor so boroklme bao on ne nokl pismil, Njises obu di mabor bao hor kab teb mend bao haklbir mabor yin pisao o, obu tenaolom henden nao pe mupang pang bu sao pisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ngub pisao o Njises obu nao pe Kalili bor bao hasao tomb, Nju sem mendborom and paek nda bor ne noklme hor so ngo tomb Njises obu obo haeb ko es bubur kakl, Aol ngo obu abor hayaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ngo tomb tenaol aondao ngo hasmi baebenom Njiseson te kao kao bu sub ora per ab saond bi bi bubur mendborom kakl, Njises obu aol ebe ora yao kismi o, mendborom kakl inj ora, obum tenaol hambun maobowam akol was bu hae kismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ngub kismi o mbinim Nju sem aeben baeben pakl homobur kismin, mbinim aondao bu sao nao ke men mba bao waesmisa. ");
INSERT INTO akh_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ngo tomb and paek nda bor ne noklme hor so ngub birismi bao o pibi hasaol, bao hor kab teb mend pibi hasao tomb Njises obum Ngaor Hen Moroklme Anda bor yin po hondabur, tenaol hambunom pangen Ngaoron angal bib ebe kao kalisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ngub bisaol Nju sem tenaol birismi nda baebenom burir aondao ora biyubur kakl, Aol ngo obu sukul di nao kise o obum angal waeb hae oborob ora ko hae dao kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Nim ini bor angal ebe ngo kao njurukl o ninao angal inj kao njurukl ka. Ngub inj, Ngaor ngo obu ni pu kise on angal hobao sao ora kao njurukl kisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Njisesom ngub kobur kakl, Tenaol mondom Ngaorom keyao sao hem ko men hakol ora bu harob sin, nim angal ngo ko haruklu e on te obum oborob ora nen sabobur laon, angal ngo nim Ngaorom keyao sao ora ko haruklu e be? be? baehaemen nim nen sobaklo ub ko haruklu eb ko obum ebe hondoklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Obum wakl kakl, Aol mendbor mbinin mbib nen saboklme ub ko haroklme baeben, mbini aol imbi wi aondao ora hakl ko pangobur ko haroklme ka. Ngub bimi o mondom aol ngo ni pu kise o obun imbi was win lowao ko nen soba sin, obum baehaemen kone kab marubur inj, obum kone ukl bombor ora ubur buklao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ngo tomb Njisesom mbini bor ngub kobur kakl, Mbes Mosesom ini bor man kao njisao ub ini ngo hayem haklon is bombor ora mondom man ngo wiyao baeben hambun ora men hakol nao biming, inim ni asub ko pe pan luklbur beyem? kisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ngub kisaol tenaol ngo hasmi nda baebenom Njises obun angal ngon ko san lubur kakl, Nje aebom ora pe panin luklbur bel kal? Panaem njen tombao bor sam mend honda bereyaol, sam ngo ung bubur ora kal kismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Nim hor boroklme bao on tenaol sen hae is mend mao enjandis tomb inim hor boroklme bao on kongon be kobur, burir aondao ora biyu makl himismi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ngub kobur kakl, Mosesom ini bor nas kang maruklemi baebenon songol pe haklwaebe kisao ub Moses obum ingiyabur inj, inim ngub bibaebe ko kao njisao ka. Ngub inj, inin ab sumb wil baebenon man mbes ngub bibaebe ke wisao ub bu haroklme o, inim hor boroklme bao* on di nas mareme baebenon songol pe haroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ngub kobur kakl, Inim naom Mosesom kisao ub bu hayom ko nen sabobur, inim di inin hor boroklme bao on nas kang baeben soweb bi habur songol pe haroklme o, nim hor boroklme bao on tenaol sen hae is mend ngo obu bisur bu ebe mao sandis on, inim asub ko ni ko aondao ora hemeyem? kisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Njisesom mbini bor wakl kakl, Inim hambun sao te oborob ora nao hendebur ngub saol kobur baehaemen te nao mao sarae, inim inin kone ora bor oborob nen sabo te hondobur ora hambun sao te mao saraklwaebe kisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ngo tomb Njurusalem tenaol ngo hasmi baebenon mendborom kakl, Inim asub nen sabeyem? Mbinim aol mend pe paen luklbur beyem lome nda, aol ngo hae o obu be? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mbinim ngub kobur kakl, Haondaoklaob. Obum nao mupange tenaol hambunon el sol angal ngo ko hae tomb mbinim obu bor angal ukl bombor ora di ngo nao lem aong, nao Nju semon maomb bo haroklme aol baebenom di obu Ngaorom Eben Ke Aol ora hae ko hendeme be? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ngub kismil mendborom kakl, Inj ora. Naom aol ngo obun su and te di ora hendeyom o, Ngaorom Eben Lao Aol ngo oboklao o obun su and te tenaol mondom nao hondoklemi ora kismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ngo tomb Njisesom Ngaor Hen Moroklme Anda ngo bor tenaol hambunom pangen Ngaoron angal ebe ngo kao kalo, obum angal aondao bu ora kobur kakl, Inim ni di nao su and te di ora hendeyom ko pangeyem be? Pangeklem. Nim su ngo bor nao mbib obon saol ko nen sabobur inj obowao ora. Ngub inj, nao Abom ora ni pu kisaol, obu heneng ora hayao o inim obu kang ora di nao hendeyem kisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Wakl kakl, Nim non obu ora hendeyo ka. Ni obu hesa haru ora haroklbaol obum ni pu kisao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ngub kisaol mbinim ngo ora tomb obu bao men haklbur bismi o, Njises obum su ngo tuwakl poklao bao o teb nao se wen sisaol, mbini ngo haklon is bombor ora mondom di obu men ha menjao nao bismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ngo tomb tenaol aondao ngo hasmi baebenon andub mendborom Njisesol hul ha habur mbini hakl hakl kakl, Ngaorom Eben Lao Aol obu oboklao tomb obum tenaolom ko mend nao hindismi sao di burir biklme sao di andub ora Njises obum bu hae ub men mbaeb se oboklao be? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ngo tomb Peresi semom pangismil tenaol mendborom Njisesom ngo bu hasao sao baeben hondobur, angal andub ora kao kao bu hayem ke pangobur, Nju semon baolum aol aondao baeben hesa Peresi aol baeben kabom polisman mendbor bor Njises men hakl puklub kismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ngub kismi o Njisesom kakl, Ni kang baoklmend oran ini hesa haru bao haklmao o, mabor sao aol ngo ni pu kise o obu hayao bor wakl poklwao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ngub kobur kakl, Inim mabor ni es buklemi o nao hend waklemi. Inim su ngo ni haklwao ol di obokl buwaklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ngub kisaol mbini Nju sem ngo hasmi nda baebenom mbini hakl hakl kakl, Obum al poklaol naom obu es buwaklmao bor le bo? Aoh, naon sem mendborom Ngirik tenaolon su bor pismi sanda ub pobur, obum di ngo bor Ngirik semom pangen obun angal ngo kao hae ub buwalokl poklbur le be? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mbinim ngub kobur kakl, Obum nao bor inim ni es buklemi o inim ni nao hondoklemi ora kanda ka. Mende di obum ngub kanda. Inim su ngo ni poklwao o bor obokl buwaklemi ora kandang, obum nao bor angal ngon puwi asub ora pen ka bo? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ngo tomb and paek nda bor ne noklme hor so ngo birismi on ber kowes ora bukl bismi bao on, hambun sao bu hesbesmi bao hobao sao ora win kismil, bao ngon Njisesom teka habur angal aondao bu ora kobur kakl, Tenaol mondom ib nokl homae sin, njem ni hae ol obobur haeben saroklme ib ngo nokl ebebe kisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Wakl kakl, Ngaoron mbuk waebom ngub ke wiyao. Tenaol mendbor nil hul ha haklemi baebenon kone bor haeben saroklme ib aondao bu ora kombakl haen hayem ke wiyao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Njisesom ngub kisaol angal ngo kisao o Ngaoron Wesaom tenaol mendbor obul hul ha haklemi baebenon kone bor hondaklao ub bor kisao o, obum mabor buri palobur enjaokl ibisao ub nao ebe tomb kisaol, Ngaoron Wesaom tenaolon kone bor nao hondae hae wen tomb angal ngo kisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ngo tomb tenaol aondao ngo hasmi nda baebenon mendborom Njisesom angal ngo kisao nda pangobur kakl, Heneng ora aol ngo obu Ngaoron man mini aol mend oboklao ko hondo haroklmao nda e kismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ngub kismil tenaol mendborom di wakl kakl, Obu Ngaorom Eben Ke Aol ora e kismi o, tenaol ngo hasmi baebenon mendborom kakl, Wao. Ngaorom Eben Lao Aol obu Kalili bor pindib paklao be? Ngub inj ka. ");
INSERT INTO akh_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ngaoron mbuk waeb bor ke wiyao ub Ngaorom Eben Lao Aol obu aol wesmbao aondao Debir sem ora soklao ke wiyao ora. Ngub wiyaol Eben Lao Aol ngo obu mbes Debir obu hasao o bor, su Berlehem bor ora pindib paklao kismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ngub kobur kismin tenaol ngo hasmi baebenon mendbor Njises obu Ngaorom Eben Ke Aol ora hae kobur obu taol mi pismi hesa, mbini mendbor obu wen oboklao kismi kab per ab saond bi bi bubur tom kab bu taol bu kobaesmisa. ");
INSERT INTO akh_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mbinim ngub bubur kismin mendborom Njises obu men haklbur bismi o, mbini ngo haklon mondom obu men ha di menjao nao bismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ngo tomb polisman mendbor Njises men hakl puklub kismi nda baebenom Njisesom ngo kisao sao hakl pangaoklbir Nju semon baolum aol aondao baeben hesa Peresi aol nda baeben kab birismi bor wakl bokesmil, mbinim polisman nda baeben bor ne mubur kakl, Inim asub ko obu nao mini ubuklim? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ngub kismil polisman nda baebenom mbinin angal ngon ko san lubur kakl, Aol ngo obum angal waeb hae oborob ora mend ka ubi naom mbes mondom kisaol nao pangismao ora kismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ngub kismil Peresi aol nda baebenom makl aondao ora homobur polisman nda baebenon angal ngon ko san lubur kakl, Obum ini di maobowarob be? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mbinim ngub kobur kakl, Inim nao Peresi aol hesa nao Nju semon maomb bo haroklme aol baeben kabon is mondom aol ngo obul hul ha haroklaol hendeme be? Inj ka. Naom obun angal pango obul hul ha nao haroklmao ora kismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Wakl kakl, Naom ngub bimao o mbini tenaol aondao ngo obun man pango hayem baebenom, naom Moseson man oborob ora men hakol bu hayom ub nao pangebur beyem ol, mbini Ngaorom hendeyao tomb kho ora hayem ol ke aondao ora mao handaklao kismisa. ");
INSERT INTO akh_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ngo tomb aol Nikorimas obu mbes somna tomb sub Njises hondokl pisao aol nda, obu di maomb bo haroklme aol ngo haklon is mend sisaol, obum mbini bor kakl, ");
INSERT INTO akh_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Naon manom tenaol mende bor baehaemen te oborob nao hendebur howes bao kaebe ke wiyao be? Ngub inj ka. Naom obun angal mbes pangokl pobur, obum ngo lao sao baebenon te mbes pangam sin ebe ora soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Ngub kisaol mbinim obun angal ngon ko san lubur kakl, Nje di Kalili aol hael be? Njem Ngaoron mbuk waeb bor wiyao ub oborob ora hend. Kalili bor man mini aol mend oboklao ke nao wiyao ora kismisa. ");
INSERT INTO akh_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ngo tomb tenaol aondao ngo hasmi baeben mbinin anda sisao buri kismi tomb Njises obu yu har Olib ne bor pisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ngub pisao o obum ekera nan hokloben wakl Ngaor Hen Moroklme Anda bor pisaol tenaol andub ora obo kiril mbaesmisa. Ngub bismil Njisesom sul burubur tenaol hambunom pangen Ngaoron angal bib hobao sao ngo kao dund bisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ngub bisao tomb Nju semon man buwaloklme aol baeben hesa Peresi sem kabom ten is mend aol paes pisaol hondobur Njises birisaol men pae obo, ten ngo tukun ora bor mao haesmisa. ");
INSERT INTO akh_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Mbinim ngub mao habur Njises bor kakl, Aol aondao o ten ngom aol paes paonaol handaemi sal, naom ten ngo mini ubuklum kismisa. ");
INSERT INTO akh_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mbinim wakl kakl, Mbes Mosesom man kisao ub ten ngubi hanom pe paen libaebe ora ke wiyaong njem asub lesib? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Mbinim Njises bor ngo kismi o obu luklbur obum angal khorob menjao ken ko te mao saraklbur kismi o, obum sul ber pabur obun ki hondem su kindib kindib bu angal waeb bisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ngo tomb mbinim Njises obu bor angal andub ora ne mismil obum teka peyobur mbini bor kakl, Ini ngo hayem haklon is mend khorob nao bisi ora mondom njem mbes tibiya ten ngo hanom li kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Njisesom ngub kobur kisaon obum sul ber pabur, obun ki hondem wakl su kindib kindib bu angal waeb bisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ngub kisaol pangaoklbir mbinim sub is bombor pu pu bu dera pobur paokl buri kismi o, mbini Nju semon aol kon wi baeben mbes pismi tomb mbini tenaol mendbor aeben o hasmi nda baeben di hambun Njises ngol bao haen tuwaklbir mama pismisa. Ngub bismi tomb Njises obu hungum bao hasaol, ten nda obu di Njiseson elol ngub bao teka ha wisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ngub bisaol Njisesom teka peyobur ten nda bor kakl, Ten o aol aondao ngo harimnda baeben abor hayem? Nje mondom te mao sara nao luklemi ye? kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ngub kisaol ten ndam kakl, Aol aondao o is bombor ora di mend nao hae kisaol, Njisesom ten nda bor wakl kakl, Nim di nje bor te nao mao saraklwaong, njen anda pu njem khorob oran ko mende nao bibi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ngo tomb mabor ko mend oran Njisesom wakl tenaol hambun bor kakl, Ni su hambunon bao mao baraoklao aol ora hael, tenaol mendbor ni hem ko taol mi oboklemi baeben mbinim em hundur wi bor nao haklemi ora. Ngub inj, mbinim haeben mao saraoklao bao bi hakol bi bor was haklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ngub kisaol Peresi semom obu bor kakl, Njem angal ngo kal o ni ngubi hae ko njen mbib ora kal ol, njem angal ngo kal ub heneng ora inj kal kismisa. ");
INSERT INTO akh_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Heneng ora nao mbib ni hae on te ko hae o, su ngo ni hakl obowao o di nao mbib ora hendeyo ka. Nim su ngo tuwaklbir wakl yin poklwao ub di nim ora hendeyol, nim angal ngo ko hae baeben di heneng ora ko hae kisesa. Ngub kobur kakl, Inim su ngo ni hakl obowao o di nao hende ora hayem ol, inim ni wakl poklwao tomb di su abor paokl ko nao hondoklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Njisesom ngub kobur kakl, Inim sun tenaolom nen saboklme ub tenaol mende bor nje kho hael ebe hael ko te mao sara sablo haroklme o, nim tenaol kang is bombor ora di te mao bemberanao sablaklo ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Wakl kakl, Aoh, nim tenaol ke hondokl bi mend te mao bembera sabla sin, nim hungum habur inj sabloklwao ka. Ngub inj, nao Abom ora ni pu kisaol, nim tenaol ngo te mao bembera sabloklwao tomb obum ni haru haenbur was sabloklwaol, nim oborob ora taol bu koba sabloklwao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Obum wakl kakl, Inin man wiyao ub ngo sao ngo sao baonao ko aol is kabom kebe tomb, mbibim ngo leb ub heneng ora leb lome kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Njisesom ngub kobur kakl, Inim ngo lome ub nim ninao mbib was ngo te ko hae o, nao Abom ora ni pu kisaol obum di ni hae on te kao dund bu haraoklaol, inim ngo bimi ub yao is kabom ko hayob kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ngub kisaol mbinim Njises bor kakl, Njen Ab ngo kal o obu abor hayaob? kismisa. Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Inim ni hae on te nao hende hayem ol, nao Ab obu di nao hendeyem ka. Inim ni aol ngo ora hae ko hondokl bemen, inim nao Ab obu di ebe hondokl beme kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Njises obum angal ngo kisao o Ngaor Hen Moroklme Anda ngon mone woroklme panda tubal o bor habur kisaol, obum angal ngo ngub ko hasao tomb obum su ngo tuwaklao o teb nao sisaol, mondom obu men ha di menjao nao bismisa. ");
INSERT INTO akh_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ngo tomb Njisesom mbini bor wakl kakl, Ngubi tomb ni paokl pukl ol inim ni es es buklemi o ni nao hondoklemil, ini pe paklemi tomb di inim khorob bimi sao inin kone bor bao wi aeben ora soklaol, inim su ngo ni poklwao o bor di obokl buwaklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ngub kisaol Nju sem ngo hasmi nda baebenom mbini hakl hakl kakl, Inim asub nen sabeyem? Inim su ni poklwao o bor obokl buwaklemi le on, obum obun mbib aomu pe asobur pe paklao ye? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ngub kismil Njisesom mbini bor kakl, Ini unu bor paoloklme o ni yu bor paolaklo ka. Ini sun aol ora hayem o ni sun aol inj hae kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Obum mbini bor ngub kobur kakl, Nim ngub nen sabobur ini bor mbes kao njanda ka. Ini pe paklemi tomb di inim khorob bimi sao inin kone bor wiyao o mondom nao kunaklaol, bao wi aeben soklao kanda ub heneng ora kanda kisesa. Wakl kakl, Heneng ora inim ni aol ngo hae o oral hul ha nao harim sin, ini pe paklemi tomb di inin kone bor kho wiyao o wi aeben ora soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ngub kisaol mbinim Njises bor kakl, Nje aeb ora hael? kismisa. Ngub kismil Njisesom mbini bor kakl, Nim ini bor mbes kao njanda ub ni aol ngo ora hae kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Njisesom wakl kakl, Nim inim bu haroklme on angal andub ora kobur, inim ngo bu haroklme ndisao baeben ngo sao khorob bimi ngo sao oborob bimi ko, nim ebe taol bu koba te mao bemberaeb se ora hae kisesa. Wakl kakl, Ni ngubi ora hae ol ni pu kisao o obum nen sabeyao ub ora buklwaol, obum nen sabaoklao ub ebe dund se ora yao ka. Obum angal hambun sao ko haraoklao ub nim pangobur, angal ngo nim ini sun tenaol hambunom pangeklemin ko, ko haruklu kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ngo tomb Njisesom nao Ab hayao kisao o obun Ab aeb bor leb ko nen sabokl buwaesmil, ");
INSERT INTO akh_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Njisesom mbini bor wakl kakl, Inim Aolon Isi Ora obu is pe kowal bil menyaklemi tomb inim ni aol ngo ora sene ko ora hondobur, nim ngo bu hae sao baeben di obun mbib nen sabobur inj, obum obun Abom hambun sao kao kalisao ub was ko hase ko ora hondoklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Njisesom wakl kakl, Nao Abom ora ni pu kisaol nim hor hor was hambun sao ngo bu haruklu e sao baeben, obum turi homo bi keyao sao was bu haruklu. Ngub biyul obum ni nao tuwae haru akol was bu haraoklaol, ni hungum ora inj hae ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ngub kisaol obum angal ngo kisao nda baeben pangobur, tenaol andub ora obul hul ha hasmisa. ");
INSERT INTO akh_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ngo tomb Njisesom Nju sem mendbor obul hul ha hasmi baeben bor kakl, Inim nil hul ha hareklem o nao angal oborob ora men hakol bu harim sin, ini nao man pange tenaol heneng ora haklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Wakl kakl, Inim ngub haklemi tomb inim Heneng Was Lao Angal nda di ora hondoklemil, ini kalabus non bi ora hayem o, Heneng Lao Angal ngom ini wakl kur mi poklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ngub kisaol mbinim Njises obun angal ngon ko san lubur kakl, Nao Eberehemon sem ora hayom ol, naom ko bombor ora di aol menden kalabus kongon non bi mend nao bismao orang, njem nao bor asub ko ini kalabus kongon non bi bu haroklme o, Heneng Lao Angalom ini wakl kur mi poklao kal? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Nim ini bor heneng ora kao njurukl, tenaol khorob bu haroklme baeben hambun, mbinim khorob ngo bimi saon kalabus non bi bereyem kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ngub kobur kakl, Kalabus kongon non bi bimi baeben non, mbinin aol aondaon sem ora men koro nao haroklme ora. Ngub inj, isi obum non obun abon isi ora habur, obun abon andal bao was haraoklao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Njisesom ngub kobur kakl, Ini Seranon kalabus non bi ngo hayem o Ngaoron Isim ini wakl kur mi pobur bu ma sin, obum ini ora bu mi poklao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Obum wakl kakl, Ni hende ora, ini Eberehemon sem ora hayem o nim angal ebe ngo ko hae baeben inin kone bor nao win ora habur, inim ni pe pan luklbur bu hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Njisesom mbini bor wakl kakl, Nim angal bib hobao sao hambun sao ngo ko haruklu e baeben, nao Abom bu haraoklaol hendeyo ub ora ko haruklu o, inim bu haroklme sao baeben di inin abon man kismi ub ora men hakol bu, bu haroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ngo tomb mbinim Njiseson angal ngon ko san lubur kakl, Naon ab Eberehem ora yao kismisa. Ngub kismil Njisesom mbini bor kakl, Ini heneng ora Eberehemon isi wane sokl beyaon, inim di obum bu hasao ub ora bukl beme kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ngub kobur kakl, Nim angal hambun sao ngo ini bor kao nju hae baeben non, nim Ngaoron angal heneng was lao nda pangowao ub ora kao nju hae o, inim ni pe pan luklbur ngo bu hayem ub Eberehemom ngub nao bisao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Njisesom ngub kobur kakl, Aoh, inim ngo bu hayem ub non inin abom bu haraoklao ub ora beyem kisesa. Ngub kisaol mbinim obu bor kakl, Naon amom nao aol paes pobur kowes inj marismi ka. Ngub inj, naon ab is bombor ora yaol, naon ab ngo obu Ngaor ora yao kismisa. ");
INSERT INTO akh_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ngub kismil Njisesom mbini bor kakl, Heneng ora Ngaor inin ab ora sokl beyaon, ni Ngaor kab haroklbao o obowaol inim nil di kone u hakl beme ka. Ni ngo obowe o nao konem ni obon saol ko nen sobaoklbir inj obowao ora. Ngub inj, ni Ngaorom ora pu kisaol obowao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Njisesom mbini bor ngub kobur kakl, Inim nim angal ebe ngo ko haruklu e on te, oborob nen nao sabeyem on te ngub wiyao. Nim angal ngo ko hae baeben inim makl homo nao pangeyem ol, inim nen sabokl buwayem kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Obum wakl kakl, Inin ab Seran ora yaol, ini Seranon isi wane ora hayem alem. Inim inin ab ngo obum bu haraoklao ub was turi homobur obun man buri palobur ora men hakol beyem ka. Mbes ora di obun kone bor kone ukl bombor u oborob bimi ubi nao wisaol obum tenaol pe paen lu haraoklao aol ora habur, obum kone oborob ukl bombor woroklme ub nao wiyao ora. Ngub inj, tenaol maobowabur kakla lome ub obun ora yaol, obu tenaol maobowaraoklao aol ora habur obu kakla ko tenaol maobowam akol bimi on aorao ora hayao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Njisesom mbini bor ngub kobur kakl, Seranom ini maobowabur menjao menjao lao tomb inim heneng le ko nen saboklme o, nim heneng heneng was lao angal nda ko haruklul, obum heneng ora le ko nen sabo angal ngol hul ha nao haroklme kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ngub kobur kakl, Ini ngo hayem haklon mondom aebom ora nim khorob sao kang mend biyul hondobur, njem khorob ngo sao bili ko kao paklao? Aoh, mondom ngub nao lao o, inim asub ko nim heneng heneng was lao angal nda kao nju haruklu ub obum heneng ora le ko nen nao saboklmeb? kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Njisesom wakl kakl, Pangeklem. Ngaoron isi wane baebenom Ngaorom keyao sao hambun sao oborob ora hem ko pangoklme o, ini Ngaoron isi wane inj hayem ol, inim obun angal nao pangeyem kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ngo tomb Nju sem nda baebenom Njises obun angal ngon ko san lubur kakl, Nje Sameriya aol ora yaol njen tombao bor sam mend bere lomao nde, naom heneng ora ko haroklmao sene kismisa. ");
INSERT INTO akh_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Ninao tombao bor sam biri inj hae ka. Ngub inj, nim nao Ab aondao ora hayao on imbi aondao bu win ko kaoya ko hae ol, inim ninao imbi nao win ko men mba ke ke bu hayem kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Obum ngub kobur kakl, Nim naon mbib ni aondao yubu ora hae ko kaoya nao ko haruklu ka. Ngub inj, aol is bombor ora mondom ninao imbi aondao bu ora win ko hayaol, naom angal ngo kao kao bu hayom sao baeben di, khorob lome oborob lome ko obum ora te mao bembera sarbeklao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Njisesom ngub kobur kakl, Nim ini bor heneng ora kao njurukl, tenaol mondom nao angal hul nao hae oborob ora pangobur men hakol bu harob sin, obu ko mende nao homoklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ngo tomb Nju sem nda baebenom Njises bor kakl, Wao. Eberehem di man mini aol mbes hasmi baeben di hambun himismi o, njem tenaol mondom nao angal oborob ora pangobur angal ngol hul ha harob sin obu ko mende nao homoklao kal ol, nje njen kone bor sam biri ora hael ko naom ora haondaoklaom kismisa. ");
INSERT INTO akh_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mbinim ngub kobur kakl, Njem naon ab sumb Eberehem men mbae ora hael be? Eberehem obu di himisaol Ngaoron man mini aol hasmi baeben di hambun himisming, njem aebom bisao ub buklesib? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Nim ninao mbib ni aondao yubu ora hae ko kaoya ko hakl beyon, nim baehaemen ora ko hakl beyo ka. Ngub sokl beyo o nao Ab Ngaor ngo obu inim naon Ngaor ora hayao ko hayem o, obum ora ninao imbi aondao bu ora win ko haraoklao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Wakl kakl, Inim Ngaor obu nao hende ora habur baehaemen ngub ko haroklme o, nim obu ora hendeyol obu nao hendeyo ka sin, ni di kakla lao aol ini non bi sokl beyao ka. Ngub sokl beyao o nim obu ora hendeyol, obun angal hul nao hae oborob ora men hakol bu haruklu kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Njisesom wakl kakl, Inin ab sumb Eberehem obum nim enjo ngo bor hambun sao ngo bu hae ub bukl obowao ub hondobur, turi homo werek aondao bu ora bisao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Njisesom ngub kisaol Nju sem ngo hasmi nda baebenom obu bor kakl, Eberehem obu mbes ora himisao o nje nas ora hael ngao, njen amom nje marisao o di karasmas supu hakl hakl hor teb di menjao nao pibi hasndis ngao, njem Eberehem obu atomb hindisib? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ngub kismil Njisesom mbini bor kakl, Nim ini bor heneng ora kao njurukl, ni pind bili ora yaol mbes Eberehem nao mari tomb di bao was hawao ko Njisesom ngub kisesa. ");
INSERT INTO akh_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ngub kisaol mbinim Njises obu ko aondao ora homobur kismin hanom luklbur han sarbe mismi o, Njises obu sub mupangobur Ngaor Hen Moroklme Anda ngo tuwaklbir dera paokl pisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ngo tomb Njises obu su mendel pukl habur hindisaol, aol el bokl mini mend obun amom bu baklae marisao o birisaol hindisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ngo tomb Njiseson man pange aol nda baebenom obu bor ne mubur kakl, Aol aondao o, aol ngo obu obun amom el hukl bu baklae marise on, aol ngo obun mbib khorob bisaol obun el kho sao baklae marise be? obun am ab kabom khorob bisbil bise bo? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ngub kismil Njisesom mbinin angal ngon ko san lubur kakl, Inim ngo lem ub aol ngo obum khorob menjao bisaol inj bisao. Aoh, obun am ab kabom khorob menjao bisbil di mend inj, aol ngo obun el ngo kho sisao ka. Ngub inj, Ngaor obun buri tenaol hambunom henden ko aol ngo obun el kho sisao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ngub kobur kakl, Nar anda nao bombe ngo bao hae tomb naom Ngaor ngo obu ni pu kisao on kongon was bu haemin ora. Nar anda bomboklaol em hundur uklao tomb tenaol hambunom kongon bukl buwaklemi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Njisesom ngub kobur kakl, Pangeklem. Ni su ngo bor ngo bao hae tomb ni su hambunon bao mao baraoklao aol ora hae kisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ngo tomb Njisesom ngub kao peyobur kisaon obum sul ne maeke tokl beyabur, ne maeke hesa su maondao ngo kab maomunubur, obum aol el hukl bi ndan el bor munu para mbaesesa. ");
INSERT INTO akh_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ngub bubur kisaon obum aol el kho nda bor kakl, Njem njen el wil ngo bor ib Silaom mal bor wes wes lukl pu kisesa. Ngub kisao o ib Silaomon embi ngon te angal heneng kobur kemi ebe ib kismil, aol el kho ndam pobur kisaon, obun el wil bor wes wes li peyaoklbir wakl ibisao tomb obun el nda ebe bao sisaol osisao hend heneng bisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ngo tomb aol el kho ngo ebe sisao nda obu daol mbini su bombor o bor hasmi tenaol baeben hesa, mbes aol ngo obum tenaol hambun bor mone kang mend njib ko kao deb deb bu birisaol hindismi nda baeben kabom kakl, Aol ngo obu mbes tenaol hambun bor mone kang mend njib ko kao deb deb bu baoraoklao nda inj e bo? kao kao bismisa. ");
INSERT INTO akh_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ngub bismil tenaol mendborom kakl, Heneng ora obu aol ngo nda ora e kismi o, tenaol mendborom kakl, Inj ora. Obu aol ngo nda non bi mend e o obu tangar mend e kismil, aol el kho ngo wakl ebe sisao ndam kakl, Ni ini bor aol el kho ngo mone njib ko baraklo nda ora hae kisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ngub kisaol mbinim obu bor kakl, Njen el abo asub ora bael wakl ebe saonaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ngub kismil obum mbinin angal ngon ko san lubur kakl, Aol mend obun imbi Njises lome ndam ib hesa su kabom nao el bor munu para mbabur, obum ni bor njem ib Silaom mal bor wes wes lukl pu kaonaol pobur, wes wes luwao tomb nao el ebe bao saonaol nim osisao hend heneng buwao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ngub kisaol mbinim obu bor wakl kakl, Aol ngo njen el ebe mao sanao o obu abor hayaob? kismil, obum mbini bor kakl, Obu ngo bor hayaob ko ni nao hende kisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ngo tomb tenaol ngo hasmi nda baebenom aol ngo obu mbes el kho ora hasao o wakl ebe sisao ngo, Peresi sem birismil mini pismisa. ");
INSERT INTO akh_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ngub bismi o bao ngo Njisesom su maondaol ne maeke tokl beyabur aol el kho nda ebe mao saesao on, Nju semon hor boroklme bao* on sisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ngub sisaol Peresi sem ngo birismi nda baebenom di makl aondao ora homobur, aol nda bor wakl ko mende ne mubur kakl, Njen el asub ora bubur ebe saonao kae bo? kismil, obum mbini bor wakl kakl, Obum su maondaom nao el bor para mbaen kaonaol, nao el wil bor wes wes luwao tomb nao el bor bao baonao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ngub kisaol Peresi sem mendborom kakl, Aol ngo obum naon hor boroklme bao on nao bibi ke wiyao ub hul habur bao was bu haeng, obu Ngaorom inj pu kise kismi o mendborom kakl, Inim asub nen sabeyem? Aol mendbor khorob bimi baebenom, tenaolom ko mend nao hindismi sao ngubi ebe buklemi be? kismi hesa mbini ngub tom kab bu taol bu kobaesmisa. ");
INSERT INTO akh_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ngo tomb mbinim aol el kho wakl ebe sisao nda bor wakl kakl, Njem aol ngo njen el ebe mao sanao kaenda obu asub bi ora mend yao ko pangal? kismisa. Ngub kismil obum mbini bor kakl, Obu man mini aol ora mend sa kisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ngub kisao o aol ngo obu mbes el kho ora sisaol wakl ebe mao saesao nda, mbini Nju sem ngo hasmi baebenom aol ngo obun amom el kho sao baklae mari inj o obum kakla le ko nen sabobur, mbinim aol ngon ingi aorao kab ubuklub kismisa. ");
INSERT INTO akh_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ngub ubuklub kobur mbinim aol ndan ingi aorao kab ne mubur kakl, Aol ngo obu ibin isi be? Aol ngo obun amom wen marisao tomb di el kho sao baklae mariseng, ibim di heneng el kho sao baklae ora marisbao lebi be? Ngon ngubi tomb asub baonaol obun el wakl ebe saonaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ngub kismil aol el kho ngo wakl ebe sisao ndan ingi aorao kabom mbinin angal ngon ko san lubur kakl, Aol ngo obu yaon isi ora yaol, wen marisao tomb di obun el hukl bu baklae marisao ub yaon mbib ora hendeyob o ");
INSERT INTO akh_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ngubi tom obun el wakl ebe saonao on te di, obun el ngo aebom ebe mao sanaob ko kab non yaom nao hendeyob ngao, aol ngo obu nongnas kang inj haeng inim obu bor oborob ora ne mib ka. Obun mbib ini bor oborob ora te kao njuklao kisbisa. ");
INSERT INTO akh_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ngub kisbil mbibi aol el kho wakl ebe sisao ndan ingi aorao ngo kabom obum asub baonaol obun el wakl ebe saonaob ko nao hende ko ngo kisbi o, Nju sem ngo baebenom tenaol mondom Njises obu Ngaorom Eben Ke Aol ora hae ko kao parob sin, mbini Nju semon man pangoklme anda bor nao birin lu taolemin kismisa. Ngub kismil mbibim Nju sem ngo baeben pakl homobur, Njisesom yaon isi ngon el ebe mao sanesa nao ke tenin kaonaob? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","obu nongnas kang inj obu aol ora haeng, obun mbib ini kao njin ub ne mib ko ngub kisbisa. ");
INSERT INTO akh_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ngo tomb Peresi sem nda baebenom aol el kho ngo wakl ebe sisao nda ko mende wakl kor bu ib kobur mbinim obu bor kakl, Ngaorom ora nje ebe mao saneng, obum njem ngo kal ub ora hendeyaong njem ko mende kakla nao kaebe ka. Njem aol ngo ni ebe mao sanao kal o obu naom ora hendeyom ol, obum khorob was bu haraoklao kismisa. ");
INSERT INTO akh_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ngub kismil aol ngo obun el wakl ebe sisao ndam mbinin angal ngon ko san lubur kakl, Aol ngo obum khorob biyao be? ni nao hende o bombor sao mend nim ora hende ka. Mbes ni el kho ora hawao o ngubi tomb nao el ebe saonaol wakl bao ba kisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ngub kisaol mbinim obu bor kakl, Obum nje bor asub ora ba? Njen el ngo asub ora bubur wakl ");
INSERT INTO akh_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ngub kismil obum mbinin angal ngon ko san lubur kakl, Nim ini bor mbes kao njanda o inim obum ni ngo ebe mao sanao saon angal ngo pangaebe makl hemeyem ngao, inim asub ko wakl was pangoklemi? Ini di obun man pange aol ora hakl ko pangeklem be? kisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ngub kisaol mbinin kone bor kho aondao ora sisaol, obu bor angal kho ko taolu lubur kakl, Nje non aol ngo obun man pange aol ora hael o, nao Moseson man pange aol ora hayom kismisa. ");
INSERT INTO akh_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mbinim ngub kobur kakl, Naon Moses obu bor non Ngaorom ora obu bor man kao kalisaol obu Ngaoron man mini aol ora hasao ko ora hendeyom o, njem aol ngo njen el ebe mao sanao kal o, obum aeben man munubur baonaob ko naom ora nao hendeyom kismisa. ");
INSERT INTO akh_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ngub kismil aol ndam mbinin angal ngon ko san lubur kakl, Wao. Aol ngo obum naom nao hindismao sao tangar ubi ngo bubur nao el tun kobur bao mao banao o, inim obum aeben man munubur baonaob ko nao hendeme ye? kisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ngo tomb aol ngo obun el ebe sisao ndam wakl kakl, Naom di ora hendeyom ol Ngaorom tenaol khorob bu haroklme baebenon angal nao pangaoklao ora. Ngub inj, mondom Ngaor bor kaoya kao ha was habur obum Ngaorom nen sabeyao ub was bu harob sin, Ngaorom obun angal pangoklao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Wakl kakl, Mbes ora di aol mend obun amom ngub el hukl bu baklae marisaol, mabor wakl aol is mondom ebe mao saesao ke arman di mend nao wiyao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Obum ngub kobur kakl, Aol ngo obu Ngaorom inj pu kokl bisaon, obun mbib was habur menjao menjao bukl buwakl beyao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ngub kisaol mbinim obun angal ngon ko san lubur kakl, Nje njen amom khorob was bu habur marisaol nje khorob bili aol ora hael ngao, naom Ngaoron man ora pangeyom o nje non bi ngo oram nao bor man mendbor ko mao dund baklbur kal be? kismisa. Ngub kobur kismin mbinim nje naon man pangoklme anda bor di ko mend nao ebebe ora ko lukl taolismisa. ");
INSERT INTO akh_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ngo tomb Njisesom pangisaol aol el hukl bi ngo wakl ebe mao saesao nda Nju semom lukl taolaem kismil, aol ngo es bu hend wabur obu bor kakl, Njem Aolon Isi Oral hul ha hael be? kisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ngub kisaol aol ngo obun el wakl ebe sisao ndam obun angal ngon ko san lubur kakl, Aol aondao o, njem Aolon Isi Ora ngo kal o obu aeb? Nim obul hul ha han ub kao nji kisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ngub kisaol Njisesom obu bor kakl, Njem obu mbes handae nda ka. Aol ngo obu ngubi tomb nje hesa ngo angal kao kao bi hayeb o kisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ngub kisaol aol ndam obu bor kakl, Aorao Aondao o, nim njel hul ha ora harukl kobur kisaon, obum tumu karu dombes ubur Njises bor kaoya kisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ngo tomb Njisesom kakl, Nim su ngo bor tenaol hambun tom kab bu tuma kobabur tenaol khorob bimi baeben ke henden ko te mao bemberaklbur obowaol, tenaol mendbor mbinin kone bor el hukl bi non bi haroklme baebenon kone bor wakl el tubur hambun sao hend heneng buklemi. Ngub inj, mbini tenaol mendbor Ngaoron man mini non bubur mbinin kone bor di ebe el ti non bi haroklme baeben, wakl el hukl bi non bi ora haklemi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ngub kisaol Peresi sem mendbor obu hasaol teb so hasmi nda babenom, Njisesom ngo kisao nda ub pangobur mbinim obu bor kakl, Nao di naon kone bor el hukl bi ora hayem ko nen sobal be? kismisa. ");
INSERT INTO akh_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ngub kismil Njisesom mbini bor kakl, Inim inin kone bor el hukl bi non bi ora hakl bemen, Ngaorom ini te nao mao sarakl beyao ora. Ngub sokl beyao o inim naon kone bor di el hukl nao bi bao bi ora hayom ko haroklmel, inin kone bor kho hambun sao bao wiyao ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ngo tomb Njisesom ngub kobur kakl, Nim ini bor heneng ora kao njurukl, aol mondom some sib baeben hondaroklme paeb tiriyao on nao hondaebur obum tangar menden paeb ngo kollmbabur hondarob sin, obum tenaol menden osisao paes mu paes naoklao aol ora soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Obum wakl kakl, Ngub buklao o aol is mende obu some sib on paeb bu tundae on paeb tiriyao oran hondarob sin, obu some sib maeb haraoklao aol soklao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ngub kobur kakl, Aol ngo obu tiriyao ngon hondaen ko tiriyao kombael maeb haraoklao aolom tiriyao komboklao ora. Some sib ngo baebenom aol some sib kalo haraoklao ngo obun angal oborob ora pangoklmel, obum obun some sib ngo baebenon imbi kao mib bubur kemi dera pubuklao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Njisesom ngub kobur kakl, Some sib aorao ndam obun some sib ngo baeben hambun kemi dera pobobur obu mbakla peyao tomb, some sib baebenom mbinin aoraon angal pange sakl, mbinim obu taol mi puklmi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ngub kobur kakl, Some sib ngo baebenom tenaol tangar nao taol mi puklmi ora. Ngub inj, mbinim aol tangaron angal nao pange sakl, mbinim aol tangaron angal pangaoklbir pakl paokl buri lemi kisesa. ");
INSERT INTO akh_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Njisesom mbini bor angal mar ngub kao kalisao o mbinim angal mar ngon te nen nao sabismisa. ");
INSERT INTO akh_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ngo tomb mbinim te ngub nen nao sabismil Njisesom mbini bor wakl kakl, Nim ini bor heneng ora kao njurukl, ni ninao some sib on tiriyao kombae menger ora hae kisesa. ");
INSERT INTO akh_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Obum wakl kakl, Aol mendbor mbinim some sib maeb haraoklao aol ebe non bubur mbes ibismi baeben, tenaol menden osisao paes mu paes noklme aol ora ibismi o, nao some sib non bi baebenom mbinin angal nao pangismi ora kisesa. ");
INSERT INTO akh_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ngub kobur kakl, Ni bombor o tiriyao kombae ngo ora hael, tenaol mondom ni hae ol obobur paeb ndaon hondarob sin, Ngaorom obu bu muklaol obum anda dera bubur en aeben bu ne no haklao kisesa. ");
INSERT INTO akh_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Njisesom ngub kobur kakl, Paes noklme aol baebenom mbinim tangar sao menjao buklbur inj ubuklmi ka. Ngub inj, mbinim some sib ngo baeben lu taolu bowes bu paes noklbur ora ubuklmi. Ngub bimi o ni non mbini haeben ora saen ko obowaol, mbini nao some sib non bi ngo baebenon kone bor turi hom ha was habur, haeben saroklme sao was win hayem kisesa. 