﻿USE sofia;
DROP TABLE IF EXISTS sofia.akeNT_vpl;
CREATE TABLE akeNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES akeNT_vpl WRITE;
INSERT INTO akeNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Serɨ serɨ Sises tamokori ton ese' asi', kin pe te'sen Tepi' pa pe iyesi'pʉ, Epʉra'an pa pe nɨrɨ kanan iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Epʉra'an esi'pʉ Aisi' kʉipʉnʉ pe, Aisi' esi'pʉ Seko' kʉipʉnʉ pe, Seko' esi'pʉ Isuta mɨrɨ awonsi'kɨ iyakon non kʉipʉnʉ pe, ");
INSERT INTO akeNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Isuta esi'pʉ Peres mɨrɨ awonsi'kɨ Sera pokon kʉipʉnʉ pe, Temarʉ esi'pʉ na'ne' to' san pe. Peres esi'pʉ Esuran kʉipʉnʉ pe, Esuran esi'pʉ Ran kʉipʉnʉ pe, ");
INSERT INTO akeNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ran esi'pʉ Aminatapu kʉipʉnʉ pe, Aminatapu esi'pʉ Naisan kʉipʉnʉ pe, Naisan esi'pʉ Sarʉman kʉipʉnʉ pe, ");
INSERT INTO akeNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sarʉman esi'pʉ Powas kʉipʉnʉ pe, Reyapu esi'pʉ na'ne' isan pe, Powas esi'pʉ Ope' kʉipʉnʉ pe, Ru' esi'pʉ na'ne' isan pe, Ope' esi'pʉ Ise'si kʉipʉnʉ pe, ");
INSERT INTO akeNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ise'si nin si esi'pʉ mɨrɨ Tepi' kin pe te'sen kʉipʉnʉ pe. Tepi' esi'pʉ Saraman kʉipʉnʉ pe, Iuraya no'pʉ rʉ'pʉ esi'pʉ na'ne' isan pe, ");
INSERT INTO akeNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Saraman esi'pʉ Reyopowan kʉipʉnʉ pe, Reyopowan esi'pʉ Apaya kʉipʉnʉ pe, Apaya esi'pʉ Esa kʉipʉnʉ pe, ");
INSERT INTO akeNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esa esi'pʉ Iseyosapa' kʉipʉnʉ pe, Iseyosapa' esi'pʉ Iseyoran kʉipʉnʉ pe, Iseyoran esi'pʉ Usaya kʉipʉnʉ pe, ");
INSERT INTO akeNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaya esi'pʉ Iso'tan kʉipʉnʉ pe, Iso'tan esi'pʉ Eyas kʉipʉnʉ pe, Eyas esi'pʉ Esi'kaya kʉipʉnʉ pe, ");
INSERT INTO akeNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esi'kaya esi'pʉ Mana'sa kʉipʉnʉ pe, Mana'sa esi'pʉ Eman kʉipʉnʉ pe, Eman esi'pʉ Iso'saya kʉipʉnʉ pe, ");
INSERT INTO akeNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Iso'saya esi'pʉ Ise'konaya mɨrɨ awonsi'kɨ iyakon non kʉipʉnʉ pe. To' eyaton non uya Esuwerʉ amʉ' a'sisa' arɨ a'tai'ne Paperan pona. ");
INSERT INTO akeNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Paperan pona Esuwerʉ amʉ' a'sisa' asa' to' eyaton non uya a'tai: Ise'konaya esi'pʉ Siya'tiyerʉ kʉipʉnʉ pe, Siya'tiyerʉ esi'pʉ Userupaperʉ kʉipʉnʉ pe, ");
INSERT INTO akeNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Userupaperʉ esi'pʉ Apaiyutʉ kʉipʉnʉ pe, Apaiyutʉ esi'pʉ Iraiya'kin kʉipʉnʉ pe, Iraiya'kin esi'pʉ Esorʉ kʉipʉnʉ pe, ");
INSERT INTO akeNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Esorʉ esi'pʉ Isato' kʉipʉnʉ pe, Isato' esi'pʉ A'kin kʉipʉnʉ pe, A'kin esi'pʉ Iraiyutʉ kʉipʉnʉ pe, ");
INSERT INTO akeNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Iraiyutʉ esi'pʉ Eriyesarʉ kʉipʉnʉ pe, Eriyesarʉ esi'pʉ Ma'tan kʉipʉnʉ pe, Ma'tan esi'pʉ Seko' kʉipʉnʉ pe, ");
INSERT INTO akeNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Seko' esi'pʉ Isose' kʉipʉnʉ pe, Meri taan'pʉ si. Meri esi'pʉ Sises san pe, Kʉrai tato' san pe si. ");
INSERT INTO akeNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Epʉra'an awonsi'kɨ Tepi', kin pe te'sen pʉ'kʉ pona, 14 kaisa rɨ itamokori ton u'tɨsa' esi'pʉ mɨrɨ. Tepi', kin pe te'sen awonsi'kɨ, to' eyaton non uya Esuwerʉ amʉ' a'sisa' arɨ Paperan pona pʉ'kʉ pona, 14 kaisa rɨ itamokori ton u'tɨsa' esi'pʉ mɨrɨ. To' eyaton non uya Esuwerʉ amʉ' a'sisa' arɨ'pʉ Paperan pona awonsi'kɨ, Kʉrai entu pʉ'kʉ pona, 14 kaisa rɨ itamokori ton u'tɨsa' esi'pʉ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Serɨ serɨ, Sises Kʉrai entu'pʉ pantomʉ: Isanon pe te'ton kon, Meri, mɨrɨ awonsi'kɨ Isose' pokon usauro'sa' esi'pʉ temari'mato' kon pe, e'tane to' uta'pɨtʉ rawɨrɨ rɨ, tʉumono'tasa' i'tu'pʉ Meri uya, Wakʉ A'kwarʉ winɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Isose' esi'pʉ ipokena' pe te'sen, mɨrɨpan ekoneka'pʉ ama'ai imari'mato' tʉuya ereutanʉ'to' pe tʉuya. ");
INSERT INTO akeNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mɨrɨ pɨ' isenuminka'pʉ tʉpo, Papa inserʉʉi uyee'pʉ ipiya' iye'ne'pɨtʉ yau, mɨrɨpan uya ta'pʉ ipɨ', “Isose', Tepi' pa rʉ'pʉ, tenari'nʉnse pʉra Meri anʉnkɨ ɨno'pʉ pe, apʉne pʉra Wakʉ A'kwarʉ winɨ imono'tasa' mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Warawo' pe entunʉ'to' iya oton, imʉre mese'tɨi' Sises tukai', apʉne pʉra tʉtonpa ton pika'tɨto' iya oton pe iyesi pɨ' to' makooi apai,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Serɨ e'kupʉ'pʉ pena Papa usaurokʉ'pʉ pu'kena' Aisaya awɨrɨ a'ku'tɨnin pe: ");
INSERT INTO akeNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“A'pɨ'pʉn uri'san umono'tato' oton, mɨrɨpan entuto' oton warawo' pe, mɨrɨpan esa'to' oton to' uya Maniwerʉ tukai' tawon,” ta'pʉ iya, “Papa esi upiyau'nokon” ta e'kwa pe. ");
INSERT INTO akeNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Isose' upakasa' uya nin si, Meri mari'ma'pʉ mɨrɨ, Itepuru inserʉʉi uya tauro'ka'pʉ awɨrɨ, mɨrɨpan uya arɨ'pʉ tiwʉ' ta', ");
INSERT INTO akeNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","e'tane iyentu rawɨrɨ a'pɨ'pɨtʉ'pʉ iya pen. Mɨrɨpan mʉre entusa' ese'tɨ'pʉ iya “Sises” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Sises entu'pʉ tʉpo Pe'teri'en po Isutiya yau, kin pe Era' esi a'tai, pu'kena' amʉ' uyee'pʉ wʉi enu uyepʉ winɨpai Surusiran pona, ");
INSERT INTO akeNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","mɨrɨpan kon uya, “Nai airɨ mʉre, Esuwerʉ amʉ' kin pe te'ton entusa' nai? Kaiyono' epa'kasa' ene'pʉ ina uya iyentusa' ekamanin. Mɨrɨ pɨ' apurɨpɨ'se'na ina uye'sa',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Serɨ tawon etasa' kin pe te'sen Era' uya a'tai, isewankama'pʉ, mɨrɨpan kaisa rɨ Surusiran pon kon usewankama'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tanporo Papa ena' use'man nɨto' tʉrawasomanin nan epuru ton mɨrɨ awonsi'kɨ Main pɨ' enupanin nan amʉranʉ'sa' tʉuya a'tai, to' ekama'po'pʉ iya, “Nai yau Kʉrai entuto' oton tasa' pu'kena' amʉ' uya nai?” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","“Pe'teri'en po, Isutiya yau,” tukai' to' uya eikʉ'pʉ. “Serɨ tukai' pu'kena' uya imenuka'pʉ esi pena rɨ: ");
INSERT INTO akeNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Ɨmɨrɨ'nokon, Isutiya yawon, Pe'teri'en pata pon kon, Isutiya yawo'nan pata ton tentakai' apata kon yau eke esa' wannɨ e'sepoto' oton, karimeru esa' esi to' esa' pe kasa umunkɨ, Esuwerʉ amʉ' esa' pe te'ton,’ tawon,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Serɨ etasa' Era' uya a'tai, tʉmaimu ennoko'pʉ iya pu'kena' amʉ' piya' to' pokon pe ama'ai te'sepoto' kon pe, mɨrɨpan kon winɨ eta'pʉ iya, mɨrɨ a'tai kaiyono' epa'ka'pʉ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Mɨrɨpan kon ennoko'pʉ iya Pe'teri'en pona, “Wakʉ pe mʉre mʉwarinpatʉi'. Eposa' auya'nokon a'tai, upana'tɨi' mɨsi'tʉi', urɨ rɨ nɨrɨ utɨto' pe apurɨpɨ'se'na,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Kin maimu eta tʉuya'nokon tʉpo, to' utɨ'pʉ, mɨrɨpan kon uya kaiyono' kanan enkaa'pʉ, tʉnene'pʉ kon nʉ'pʉ wʉi enu uyepʉ winɨ, mɨrɨpan pɨ' to' epori'ma'pʉ. Mɨrɨpan kon rawɨrɨ kaiyono' utɨ'pʉ, mɨrɨpan ereuta'pʉ mʉre pata epoi. ");
INSERT INTO akeNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mɨrɨ a'tai, pu'kena' amʉ' ewomʉ'pʉ ɨutɨ ta'. Mʉre si ensa' tʉuya'nokon a'tai, isan, Meri pokon pe, to' e'sekunka'pʉ apurɨpɨtʉ pe. Mɨrɨ a'tai, timamin kon yen a'koka'pʉ to' uya, mɨrɨpan kon uya irepapɨtʉ'pʉ epe'kena' ton ke: korʉ ke, a'po'nan ikɨtun, pʉrankensens tato' ke mɨrɨ awonsi'kɨ karapa, mɨrʉ tato' ke. ");
INSERT INTO akeNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Papa uya to' pana'tɨ'pʉ to' e'ne'pɨtʉ yau, to' enna'po namai' kin pe te'sen Era' piya', mɨrɨpan kon enna'po'pʉ tʉpata kon ya' tʉron nɨ awɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","To' utɨ'pʉ tʉpo, Itepuru inserʉʉi usenpoika'pʉ Isose' piya' iye'ne'pɨtʉ yau, “Isose', e'mʉ'sa'ka', mʉre mɨrɨ awonsi'kɨ isan tanʉnse ainʉnkɨ Isi' pona. Kin Era' man iwarinpa pɨ' iwɨto' pe tʉuya,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mɨrɨpan e'mʉ'sa'kasa' uya mʉre mɨrɨ awonsi'kɨ isan arɨ'pʉ ewarupɨ nau Isi' pona, ");
INSERT INTO akeNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","mɨrɨpan kon uko'mamʉ'pʉ Era' uma'ta pona rɨ. Pena pu'kena' amʉ' nekama'pʉ uta'ku'tɨ'pʉ, “Umu kɨ'ma uya Isi' apai,” tawon. ");
INSERT INTO akeNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Era' uya i'tusa' a'tai pu'kena' amʉ' uya tennakasa', ipan pe isakorota'pʉ, mɨrɨpan uya, “Warawo' munkɨ amʉ' Pe'teri'en pon kon itʉ'katɨ' asa'ron wʉipiya airon kon mɨrɨ awonsi'kɨ mɨrɨ o'koi'no kon nɨ,” ta'pʉ iya, pu'kena' amʉ' uya ekama'pʉ rʉ'pʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mɨrɨ a'tai, pu'kena' Iseremaya nekama'pʉ uta'ku'tɨ'pʉ: ");
INSERT INTO akeNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Main useta Rama pata po, tʉuta'kwarʉkai' ukaran nɨ esi eke pe rɨ, Rʉi'serʉ esi ukaran nɨ pɨ' tʉmunkɨ amʉ' wenai, tʉpori'ma i'se pʉra iyesi, to' pʉra iyesi pɨ',” tawon. ");
INSERT INTO akeNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Era' uma'ta'pʉ tʉpo, inserʉ usenpoika'pʉ iye'ne'pɨtʉ yau Isose' piya', Isi' po, ");
INSERT INTO akeNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“E'mʉ'sa'ka', mʉre mɨrɨ awonsi'kɨ isan akɨ Esuwerʉ pata pona. Kamoro mʉre wɨnɨ i'se te'san uma'ta'pʉ man,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Mɨrɨpan e'mʉ'sa'ka'pʉ, mʉre mɨrɨ awonsi'kɨ isan arɨ'pʉ iya, mɨrɨpan kon utɨ'pʉ Esuwerʉ pata pona. ");
INSERT INTO akeNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","E'tane A'keras enasa' tʉkʉipʉnʉ Era' pata'pʉ ya' kin pe Isutiya po eta'pʉ iya. Enari'ke' pe iyesi'pʉ, mɨrɨ ya' ɨtɨpai pʉra. Ipanamasa' esi'pʉ iye'ne'pɨtʉ yau, mɨrɨpan utɨ'pʉ Kiyarari nono pona. ");
INSERT INTO akeNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Mɨrɨpan utɨ'pʉ ɨko'manse'na Nasare' pona. Pu'kena' ton nekama'pʉ uta'ku'tɨ'pʉ mɨrɨ, “Nasarin tukai' esa'to' oton,” tawon. ");
INSERT INTO akeNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mɨrɨ a'tai, Isaan Pa'tes uyee'pʉ. Itekare ekama'pʉ iya Isutiya rɨmono'taai awɨrɨ, ");
INSERT INTO akeNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Amakooi kon apai era'tɨtɨ', apʉne pʉra Papa e'to' esa' wannɨ pe a'ko pe man,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Isaan pʉse rɨ pu'kena' Aisaya usaurokʉ'pʉ rʉ'pʉ ipɨ': “Rɨmono' tau ka'pon ukɨ'pɨ'nʉnpɨtʉ, ‘Itepuru e'ma ikonekatɨ', to'sa rɨ ite'ma ikonekatɨ',’ tawon,” ta'pʉ rʉ'pʉ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Isaan pon esi'pʉ kiyamerʉ i'po' konekasa', o' pi'pɨ konekasa' esi'pʉ ipokʉrʉʉi pe iworo'pai pɨ'. Iti'kiyari esi'pʉ kairau amʉ' mɨrɨ awonsi'kɨ teusan e'ku. ");
INSERT INTO akeNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ka'pon amʉ' utɨ'pʉ ipiya' Surusiran mɨrɨ awonsi'kɨ Isutiya apai, tanporo Isotan nono piyawo' nan pata apai'ne. ");
INSERT INTO akeNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tʉmakooi kon ekama pɨ', mɨrɨpan kon pa'taisima'pʉ iya Isotan tuna tʉu'tɨsen kau. ");
INSERT INTO akeNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","E'tane tu'ke Pari'si amʉ' mɨrɨ awonsi'kɨ Satu'si amʉ' uyepʉ ene tʉuya a'tai epa'taisiman ku'to' iya airɨ, ta'pʉ iya to' pɨ', “Ɨmɨrɨ'nokon ɨsɨ ton ɨkʉi munkɨ ton! Ɨnʉ' uya apana'tɨsa' kon ayainʉmʉ kon pa nʉye'ai'ne' ekota'man nɨto' piyapai? ");
INSERT INTO akeNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Epetatɨ' ɨyera'tɨsa' kon amakooi kon apai ekamanin ke. ");
INSERT INTO akeNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mɨrɨ awonsi'kɨ ɨmɨrɨ'nokon pe rɨ kɨsenuminkatʉu, ‘Epʉra'an esi ina kʉipʉnʉ pe,’ tukai'. Apana'tɨ uya 'nokon serɨ, serɨ ton tɨ' apai Papa uya Epʉra'an munkɨ oton kon koneka mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Wa'ka e'kamasa' man yʉi amʉ' mi' airɨ, mɨrɨ awonsi'kɨ tanporon yʉi amʉ' tepetasen pen a'tɨto' oton nɨ mɨrɨ, mɨrɨpan eno'ma apo' ya'. ");
INSERT INTO akeNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Apa'taisima uya 'nokon tuna ke, amakooi kon apai ɨyera'tɨ kon pa. E'tane uye'ma'pʉ pe meruntɨ kuru uyepʉ mɨrɨ uyentaino, isapatooi arɨ uya poken pʉra e'ai'ne'. Apa'taisima iya 'nokon mɨrɨ Wakʉ A'kwarʉ ke mɨrɨ awonsi'kɨ apo' ke. ");
INSERT INTO akeNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Sara'sara'pan ti'kiyari pi'pɨ menkato' iya ike esi itemiyatʉ yau, mɨrɨpan uya i'kwato' tʉuya apon akoroka, ta'nasi, wi' amʉranʉkʉ iya itiwʉ' ta', ipi'pɨ rʉ'pʉ po'tɨ iya tʉusenkʉ'sen pen apo' ke,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mɨrɨ a'tai, Sises uyee'pʉ Kiyarari winɨ Isaan piya' Isotan tuna airɨ tʉpa'taisimato' pe iya, ");
INSERT INTO akeNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Isaan esi'pʉ ɨnereutanʉ'pai, mɨrɨpan uya ta'pʉ ipɨ', “Upa'taisima auya ru'ku i'se e'ai', mɨrɨ pe' e'tane upiya' ɨuye'sa'?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Sises uya eikʉ'pʉ, “Tɨwɨ mɨrɨ kasa rɨ iku'kɨ, serɨ pe rɨken iye'to' pe. Serɨ winɨ tanporo Papa e'to' i'se rɨ kupʉ mɨrɨ,” ta'pʉ iya. Mɨrɨ a'tai, Isaan uya ikupʉ'pʉ imaimu awɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Inke pʉra tepa'taisima'pʉ rʉ'pʉ pe, Sises ekanwaka'pʉ tuna kapai. Mɨrɨ a'tai kuru rɨ, ka' uta'koka'pʉ, mɨrɨpan uya Papa A'kwarʉ u'tɨ ene'pʉ wako'wa kasa, mɨrɨpan uta'si'pʉ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Main, Epʉn winon uya ta'pʉ, “Umu pʉse rɨ, uni'nʉnkanʉ; ipɨ' epori'mayai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Mɨrɨ a'tai, Iya'kwarʉ uya Sises arɨ'pʉ rɨmono' ta' Makoi uya i'tupɨ'to' pe. ");
INSERT INTO akeNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tʉuseruma tʉpo tenta'nai' pʉra 40 kaisa rɨ wʉi mɨrɨ awonsi'kɨ ewarupɨ, mɨrɨpan esi'pʉ ipan pe kuru iwan pe. ");
INSERT INTO akeNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","I'tupɨ'nin uyee'pʉ ipiya', mɨrɨpan uya ta'pʉ ipɨ', “Papa Mumu pe ɨwesi yau, se ton tɨ' amʉ' pɨ' pʉreti pe enakɨ ka'kɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Sises uya eikʉ'pʉ, “Iye'menukasa', ‘Ka'pon esi tʉuko'mansen pʉreti pɨ' rɨken pen, e'tane tanporon nɨ main pɨ' Papa mʉta yapai tʉuye'sen,’ tawon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mɨrɨ a'tai, Makoi uya Sises arɨ'pʉ wakʉ eke pata pona, mɨrɨpan uya Papa ena' Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' ka'tawon inakapu putu po iye'mʉ'sa'kato' pe ikupʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Papa Mumu pe ɨwesi yau, ata'mo'kakɨ, apʉne pʉra iye'menukasa': “‘Tinserʉʉi ton apiyo'ma iya ɨpɨ', mɨrɨpan kon uya temiyatʉ kon yau ayanʉmʉ tɨ' pona a'ta wɨnɨ auya namai',’ tawon,” ta'pʉ Makoi uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Sises uya eikʉ'pʉ, “Iye'menukasa' rɨ nɨrɨ, ‘Itepuru, Papa, itese' pɨ' ɨwe'to' kʉsi'tupɨtʉi,’ tasa',” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Makoi uya kanan arɨ'pʉ ka'tawon wʉ' pona, mɨrɨpan uya tanporo eke ton pata enpoika'pʉ itenu ya', mɨrɨ awonsi'kɨ wakʉ pe rɨ iye'to'. ");
INSERT INTO akeNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Tanporo serɨ ton ke ɨrepa uya, urɨ pɨ' te'sekunkai' ɨwɨpʉrema yau,” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Sises uya ta'pʉ ipɨ', “Upiyapai enta, Se'tan! Apʉne pʉra iye'menukasa', ‘Itepuru, Papa, itese' pɨ' ɨwe'to' pɨ' rɨken ɨpʉrema'; Kʉrɨ rɨ rɨken poitorʉ pe e'kɨ,’ tawon,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mɨrɨpan piyapai Makoi utɨ'pʉ. Inserʉ amʉ' uyee'pʉ ipika'tɨi'. ");
INSERT INTO akeNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Sises uya Isaan esi pariki'si tau tawon etasa' a'tai, iyenna'po'pʉ Kiyarari pona. ");
INSERT INTO akeNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ɨko'manse'na itɨ'pʉ Ka'paneyan pona, Nasare' tʉnɨnse. Mɨrɨ pata esi'pʉ mɨrɨ parau ku'pɨri piyau Sepuran mɨrɨ awonsi'kɨ Na'tari nono airɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Pu'kena' Aisaya uya ta'pʉ rʉ'pʉ a'ku'tɨ pe: ");
INSERT INTO akeNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sepuran mɨrɨ awonsi'kɨ Na'tari nono pon kon, ka'pon amʉ' Kiyarari e'ma awɨron kon mɨrɨ awonsi'kɨ tuna Isotan ratoi pon kon, Kiyarari, Esuwerʉ amʉ' pen nono yau te'san. ");
INSERT INTO akeNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Pʉsamoro ka'pon amʉ' ewarupɨ yau tʉuko'mansan uya eke rɨ iweyu ensa' man; uma'tan nɨto' nono yau te'san pona iweyu e'wei'tɨsa' man.” ");
INSERT INTO akeNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mɨrɨ si'kɨrɨ rɨ Sises epiya'tɨ'pʉ itekare ekama pɨ', “Era'tɨtɨ' amakooi kon apai, apʉne pʉra Papa e'to' esa' wannɨ pe man a'ko pe!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sises usarɨ koro'tau parau ku'pɨri Kiyarari piyawɨrɨ, ka'pon ene'pʉ iya, takon ya' te'san, Saiman itese', Pi'ta tato' ipɨ', mɨrɨ awonsi'kɨ Anturu si itakon. Tʉpunwerʉ kon tʉrʉ pɨ' to' esi'pʉ parau ku'pɨri kau, apʉne pʉra moro' amʉ' a'sinin nan pe tesi kon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Sises uya ta'pʉ to' pɨ', “Upɨkɨrɨ ɨsi'tɨ', ɨkonekato' kon pe uya ka'pon amʉ' a'sinin nan pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Mɨrɨ pe rɨ, tʉpunwerʉ kon tʉnɨnse to' utɨ'pʉ ipɨkɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mɨrɨ apai tʉutɨi', tʉron kon asa'ron kon ɨsirunan ene'pʉ iya, Isens mɨrɨ awonsi'kɨ Isaan, Sepiti munkɨ amʉ'. Kanau yau to' esi'pʉ, tʉkʉipʉnʉ kon Sepiti pokon pe tʉpunwerʉ kon konepɨtʉ pɨ'. Sises uya to' kɨ'ma'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Inke pʉra, tʉkanwa kon mɨrɨ awonsi'kɨ tʉkʉipʉnʉ kon tʉnɨnse to' utɨ'pʉ ipɨkɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Sises utɨ'pʉ siya rɨ Kiyarari awɨrɨ ka'pon amʉ' enupa pɨ' Esuwerʉ amʉ' usenupato' iwʉ' tau'ne. Wakʉ itekare ekama pɨ' iyesi'pʉ, Papa e'to' esa' wannɨ pe pɨ'. Paran pokon kon mɨrɨ awonsi'kɨ takuru'kena' nan ka'pon amʉ' epi'tɨ pɨ' iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Itekareei utɨ'pʉ siya rɨ Siriya poron pata awɨrɨ'ne rɨ, mɨrɨpan ka'pon amʉ' uya tanporo e'ne' pe te'san nee'pʉ ipiya', ti'tui' pʉra rɨ teparan ke te'san. Tʉron kon eparan esi'pʉ ipan pe kuru te'kʉnkʉnmasen, tʉron kon yau makoi a'kwarʉ esi'pʉ, tʉron kon eparan esi'pʉ yai to' enno'pɨ'nin, tʉron kon ipu'tɨka'pɨ'sa' kon Sises uya tanporo pʉsamoro epi'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Eke pe rɨ anpisin Kiyarari awɨron kon, Te'ka'pores, Surusiran, Isutiya pon kon, mɨrɨ awonsi'kɨ Isotan nono ratoi pon kon utɨ'pʉ ipɨkɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Sises uya anpisin pe ka'pon amʉ' ensa' a'tai, iyekainʉmʉ'pʉ i'kʉrʉ pona, mɨrɨpan ereuta'pʉ. Ipoitorʉ ton amʉra'pʉ ipiya', ");
INSERT INTO akeNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","mɨrɨpan kon enupa pɨ' iye'sara'tɨ'pʉ: ");
INSERT INTO akeNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Pori' pe entu'ma' na'ne' nan ta'kwarʉ kon yau esi, apʉne pʉra to' iwano' pe Papa e'to' esa' wannɨ pe esi. ");
INSERT INTO akeNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Pori' pe te'ton kon kamoro tʉuta'kwarʉkai' ukaran nɨ pɨ' na'ne' nan serɨ pe, apʉne pʉra Papa uya pori' pe to' ku'to' oton. ");
INSERT INTO akeNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Pori' pe te'ton kon kamoro mɨ pe te'ku'san pen, apʉne pʉra tanporo rɨ non tʉrʉ Papa uya to' ena'. ");
INSERT INTO akeNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Pori' pe te'ton kon kamoro iwan pe, mɨrɨ awonsi'kɨ tuna'kiri' ke na'ne' nan ipokena' i'se, apʉne pʉra to' rɨ a'wetato' oton. ");
INSERT INTO akeNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Pori' pe te'ton kon kamoro ɨsentu'kena' ton, apʉne pʉra Papa usentu'mato' oton to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Pori' pe te'ton kon kamoro wakʉ pe tewan kon yau nekonekayai'ne' nan, apʉne pʉra to' uya Papa ento' oton. ");
INSERT INTO akeNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Pori' pe te'ton kon kamoro ɨsɨ pe te'san i'nɨ'pankanin nan, apʉne pʉra Papa munkɨ amʉ' pe to' e'to' oton. ");
INSERT INTO akeNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Pori' pe te'ton kon kamoro ɨsɨ pe rɨ, ipan pe rɨ tʉkota'masan wakʉ kupʉ to' uya wenai, to' iwano' pe Papa e'to' esa' wannɨ pe esi. ");
INSERT INTO akeNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Pori' pe ɨwesi kon mɨrɨ ka'pon amʉ' uya asapema kon a'tai, iwenai pʉra ɨkota'ma'nokon a'tai mɨrɨ awonsi'kɨ to' usaurokʉ ɨri pe rɨ ɨpɨ'nokon a'tai urɨ uriya'. ");
INSERT INTO akeNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mɨrɨ pe iyesi pɨ' ipan pe pori' pe kuru e'tɨ', apʉne pʉra eke rɨ ɨyepe'pʉ kon esi pɨ' Epʉn po, apʉne pʉra mɨrɨ kasa rɨ arawɨron kon pu'kena' amʉ' kota'mapɨtʉ'pʉ to' uya mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Non waiyori pe rɨ ɨwesi kon, e'tane ine'ne' pe pʉra waiyo enasa' yau, nai kasa ine'ne' pe kanan iye'to' pe ikupʉ? Wakʉ pe pʉra rɨ iyesi mɨrɨ, eno'mato' pe rɨ iyesi ka'pon amʉ' uya iwasa'pɨ'to' pe tʉusarɨ kon a'tai. ");
INSERT INTO akeNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Serɨ non weyu pe rɨ ɨwesi kon. Wʉ' pon pata e'so'namʉ pʉra iyesi mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mɨrɨ pe pʉra ka'pon amʉ' uya raan'pu po'tɨsa' nonka pʉra iyesi mɨrɨ pʉsau o'koi'. E'tane ru'ku, to' uya inonka iyapon pona, mɨrɨpan uya tanporon kon nɨ wei'tɨ ɨutɨ tau. ");
INSERT INTO akeNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mɨrɨ kasa, tɨwɨ ɨweyu pe na'ne' ne'wei'tɨi ka'pon amʉ' uya ento' pe. Mɨrɨ a'tai, wakʉ ɨnkupʉnʉ ento' pe to' uya, mɨrɨ awonsi'kɨ Papa, ɨkʉipʉnʉ, Epʉn pon apurɨpɨ'to' pe to' uya nɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Pu'kena' amʉ' mɨrɨ awonsi'kɨ Mosi' nekama'pʉ Main eno'mai' uye'sa' tukai' kʉsi'tutʉu. Eno'mase'na uye'sa' pen e'tane a'ku'tɨi' ru'ku uye'sa'. ");
INSERT INTO akeNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","I'napairon ekama uya ɨpɨ'nokon; Epʉn mɨrɨ awonsi'kɨ non e'weuka pʉ'kʉ pona, ɨ'rɨ rɨ mo'ka pʉra iyesi Papa Maimu yapai. Aiko pe rɨ na'ne' pen nʉwarai'ka'pʉ esi moro rɨ Main pe tanporon nɨ uta'ku'tɨ pʉ'kʉ pona. ");
INSERT INTO akeNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ɨnʉ' rɨ aiko pe rʉ'kwɨ na'ne' Main tonpa i'kwɨ'nin mɨrɨ awonsi'kɨ tʉron kon enupanin mɨrɨ rɨ marɨ ku'to' pe to' uya e'to' oton aiko pe Papa e'to' esa' wannɨ pe yau; e'tane ɨnʉ' rɨ Main kupʉ pɨ' na'ne' mɨrɨ awonsi'kɨ ipɨ' enupanin pe na'ne' e'to' oton eke pe kuru Papa e'to' esa' wannɨ pe yau. ");
INSERT INTO akeNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ta uya ɨpɨ'nokon, wakʉ rɨken ku'to' auya'nokon pe iyesi Pari'si amʉ' mɨrɨ awonsi'kɨ Main pɨ' enupanin nan entai; mɨrɨ kupʉ auya pʉra iyesi a'tai, Papa e'to' esa' wannɨ pe ya' ɨyepa'kato' oton kon parɨ pen nɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Miyarɨ rɨ usenupan nɨto' ekama'pʉ Sises uya; “Eta'pʉ auya'nokon pena rɨ ka'pon amʉ' pɨ' ta'pʉ, ‘Ɨtonpa kʉ'wɨnɨi,’ tawon, mɨrɨ awonsi'kɨ, ‘Ɨnʉ' rɨ tʉtonpa wɨnin nʉ'pʉ kota'mato' oton,’ tawon, ");
INSERT INTO akeNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","e'tane ta uya ɨpɨ'nokon, ɨnʉ' rɨ sakoro' pe na'ne' tʉtonpa pɨ' kota'mato' oton Papa uya. Takapʉ uya kanan, ɨnʉ' rɨ tʉtonpa esa'nin ‘Ra'ka,’ tukai' esi Esuwerʉ amʉ' Konsʉrʉʉi ton nʉkota'ma ton pe, e'tane ɨnʉ' uya, ‘Ɨmɨrɨ, iya'kwarʉ pʉn!’ tasa' a'tai tʉtonpa pɨ', ɨsɨ rɨ apo' e'ma tau iyesi mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Mɨrɨ pe iyesi pɨ', ɨuse'mato' Papa ena' esi a'tai, moro ɨyenu yau ɨri pe ɨtonpa e'ku'to' ɨpɨ' tʉku'se itɨkɨ ɨtonpa e'ku'to' ɨri pe ɨpɨ' konekai'. ");
INSERT INTO akeNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Papa ena' use'man nɨto' apon piyau ɨntʉrʉnʉ tʉnonkai', wapiya ɨtonpa a'kɨrɨ ekoneka ta, ɨyenna'po pa ɨntʉrʉnʉ tʉse'na. ");
INSERT INTO akeNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Oko pe pʉra ɨyeyaton ko'tʉ ta' ayayai'ne' a'kɨrɨ ekonekaka'kɨ ipokon pe rɨ marɨ ɨwesi koro'tau, ɨkota'mato' ya' ɨtʉrʉ iya wapiya, eseru aimenkanin uya ɨtʉrʉ pʉresiman ena', mɨrɨ awonsi'kɨ ɨyeno'ma to' uya pariki'si ta'. ");
INSERT INTO akeNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","I'napairon nɨ ekama uya ɨpɨ'nokon; ɨyepa'kato' oton pen nɨ tanporo ɨne'manʉ kon i'ma'ka auya'nokon pʉ'kʉ pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Eta'pʉ auya'nokon; ‘Tʉtaan'pʉ kenan kʉsekumankai,’ tawon. ");
INSERT INTO akeNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","E'tane ekama uya ɨpɨ'nokon; ɨnʉ' uya rɨ uri'san ensa' a'tai ekumai' pe, iyekumaka'sa' rɨ mɨrɨ uri'san a'kɨrɨ tewan yau. ");
INSERT INTO akeNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Enwo'ne' winon ɨyenu uya ɨye'makoima emapu'tɨ pe iyesi yau, imo'kakɨ eno'ma pa; wakʉ iwa pe rɨ iyesi tikin nɨ ɨpun tonpa'kasa' auya a'tai, tanporo ɨpun eno'ma ekota'man nɨto' ya' entai. ");
INSERT INTO akeNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Enwo'ne' winon ɨyemiyatʉ uya ɨye'makoima emapu'tɨ pe iyesi yau, a'tɨkɨ eno'ma pa; wakʉ iwa pe iyesi mɨrɨ tikin nɨ ɨpun tonpa'kasa' auya a'tai, tanporo ɨpun eno'ma ekota'man nɨto' ya' entai,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Tasa' iya kanan, ‘Ɨnʉ' uya rɨ tʉno'pʉ nonka a'tai, tɨwɨ nʉkaretai'tɨi kuru rɨ iye'nonka karetaai ke,’ ");
INSERT INTO akeNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","e'tane ekama uya ɨpɨ'nokon; ɨnʉ' rɨ tʉno'pʉ nonkayai'ne', iyekumasa' pen nɨ e'tane uya tekumasen pe iyesi emapu'tɨ mɨrɨ, mɨrɨ awonsi'kɨ ɨnʉ' rɨ inonkasa' rʉ'pʉ mari'mayai'ne', ekuma pe iyesi mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Eta'pʉ auya'nokon pena rɨ kanan ka'pon amʉ' pɨ' ta'pʉ, ‘Ausauro'sa' rʉ'pʉ ipɨ', iku'to' pe auya kʉ'pʉremekʉi, e'tane Papa ya' ausauro'sa' rʉ'pʉ awɨrɨ rɨ e'kɨ.’ ");
INSERT INTO akeNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","E'tane ekama uya ɨpɨ'; ɨ'rɨ rɨ kʉkai ɨnku'ton pen nɨ pɨ', Epʉn nɨ kʉsesakʉi—Papa apon mɨrɨ, ");
INSERT INTO akeNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","non nɨ kʉsesakʉi—Papa pʉta apon mɨrɨ; Surusiran nɨ kʉsesakʉi—eke kin pata'se' mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mɨrɨ awonsi'kɨ a'pai rɨ kʉsesakʉi, apʉne pʉra tikin nɨ rɨ a'pai i'po' aimu'naka auya pʉra iyesi mɨrɨ awonsi'kɨ i'kʉrʉntanʉkʉ auya pʉra rɨ iyesi. ");
INSERT INTO akeNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ewai' ta auya a'tai, ewai' ka'kɨ; kane ta auya a'tai, kane ka'kɨ rɨ nɨrɨ. Tʉron nɨ pe ausaurokʉ a'tai mɨrɨ esi Makoi winon pe. ");
INSERT INTO akeNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Eta'pʉ auya'nokon nɨ, ‘En epe'pʉ pe en nɨ esi; ɨ epe'pʉ pe ɨ rɨ esi,’ tawon. ");
INSERT INTO akeNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","E'tane ekama uya ɨpɨ'nokon; ɨri pe ɨku'nin nʉ'pʉ pɨ' kɨse'mai. Ɨnʉ' uya rɨ ɨwɨnɨ yau enwo'ne' winon ɨye'peta pɨ', iratoi rʉ'pʉ rɨ marɨ ira'tɨkɨ iwinɨkʉi'. ");
INSERT INTO akeNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mɨrɨ awonsi'kɨ ɨnʉ' uya rɨ ayarɨ pe iyesi yau ko'tʉ ta' ɨ'rɨ wenai rɨ, mɨrɨpan uya ɨpon mo'ka pe iyesi yau itepe'pʉ pe, tɨwɨ ipʉro'pon pokon pe ɨpon mo'kai. ");
INSERT INTO akeNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ɨnʉ' uya rɨ ta'kwarʉkai' ayarɨ ta'kɨrɨ a'tai 1 mayirʉ, enta 2 mayirʉ e'to' airɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ɨyekama'poyai'ne'nokon irepatɨ', mɨrɨ awonsi'kɨ kera'tɨi ɨnʉ' rɨ ɨyekama'ponin ɨiwano' pɨ' piyapai. ");
INSERT INTO akeNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Eta'pʉ auya'nokon; ‘Ɨtonpa i'nʉnkakɨ, ɨyeyaton ewaruma'tɨi'ma.’ ");
INSERT INTO akeNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","E'tane ekama uya ɨpɨ'nokon; ɨyeyaton kon nɨ i'nʉnkatɨ', mɨrɨ awonsi'kɨ ɨpʉrematɨ' ɨkota'manin kon pona, ");
INSERT INTO akeNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Epʉn pon ɨkʉipʉnʉ kon munkɨ amʉ' pe ɨwesi kon pa. Ɨri ton nɨ mɨrɨ awonsi'kɨ wakʉ ton nɨ weyu pe wʉi enu enuku emapu'tɨnin. Ipokena' ton mɨrɨ awonsi'kɨ ipokena' ton pen nɨ pona tuna ennoko iya. ");
INSERT INTO akeNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ɨi'nʉnkanin kon nɨken i'nʉnka auya'nokon yau, ɨ'rɨ ken si ɨyepe'pʉ kon eporo auya'nokon mɨrɨ? Mɨrɨ pe' kupʉ pʉrata amʉranʉ'nin nan uya pʉra nai? ");
INSERT INTO akeNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mɨrɨ awonsi'kɨ ɨtonpa ton nɨken nɨ pɨ' miyarɨ ta auya'nokon yau, ɨ'rɨ ken si kupʉ auya'nokon tʉron kon entai? Mɨrɨ pe' kupʉ Papa apurɨnin nan pen uya pʉra nai? ");
INSERT INTO akeNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mɨrɨ pe iyesi pɨ', wakʉ pe e'tɨ', ɨkʉipʉnʉ kon, Epʉn pon esi wakʉ pe kasa.” ");
INSERT INTO akeNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Sises e'sara'tɨkaa'pʉ kanan tʉpoitorʉ ton enupa pɨ'. Ta'pʉ iya, “Ti'tui' e'tɨ', wakʉ ɨnkupʉnʉ kon yau, wakʉ pe e'nɨto' pɨ' ka'pon amʉ' uya ɨyento' pe tukai'. Mɨrɨ ku'sa' auya a'tai, ɨyepe'pʉ eporo auya pʉra rɨ iyesi mɨrɨ ɨkʉipʉnʉ, Epʉn pon winɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Mɨrɨ pɨ' entu'manin nan repa auya'nokon a'tai, eke pe kʉsekamai, wakʉ pe te'ku'san uya ikupʉ kasa Esuwerʉ amʉ' usenupato' iwʉ' tau, mɨrɨ awonsi'kɨ asanta tawɨrɨ rɨ, tapurɨto' kon pe ka'pon amʉ' uya tukai'. I'napairon nɨ ekama uya serɨ ɨpɨ'nokon, to' uya tepe'pʉ kon epoka'sa' rɨ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","E'tane entu'manin nan repa auya a'tai, tɨwɨ akamisi winon ɨyemiyatʉ kʉsi'tunin ɨyenwo'netʉ winon ɨyemiyatʉ nʉkupʉnʉ, ");
INSERT INTO akeNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","mɨrɨ pɨ' ɨnkupʉnʉ e'to' pe nesii ama'ai, ɨkʉipʉnʉ, ama'ai ɨnkupʉnʉ ennin nʉ'pʉ uya ɨye'mato' pe. ");
INSERT INTO akeNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Mɨrɨ awonsi'kɨ ɨwɨpʉrema kon a'tai, wakʉ pe te'ku'san kasa ke'tʉu. Ɨpʉremapaino kon te'mʉ'sa'kai' Esuwerʉ amʉ' usenupato' iwʉ' tau mɨrɨ awonsi'kɨ asanta ka'taporo rɨ, tento' kon pe ka'pon amʉ' uya. I'napairon nɨ ekama uya serɨ ɨpɨ'nokon, to' uya tepe'pʉ kon epoka'sa' rɨ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","E'tane ɨwɨpʉrema a'tai, ɨiwʉ' pʉ'kʉ ta' ewonkɨ, ɨmʉra'taai a'kokɨ mɨrɨ awonsi'kɨ ɨwɨpʉrema pa tʉusensen pen nɨ ɨkʉipʉnʉ pɨ'. Mɨrɨ a'tai, ɨkʉipʉnʉ, ama'ai ɨnkupʉnʉ ennin uya ɨye'mato' pe. ");
INSERT INTO akeNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Mɨrɨ awonsi'kɨ amaimu rɨ marɨ tʉna'popɨ'se kɨpʉremai, Papa i'tunin nan pen kasa tʉmaimu kon useta pe tekamai', apʉne pʉra tu'kan nɨ esakʉ tʉuya'nokon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","To' kasa ke'tʉu, ɨkʉipʉnʉ uya rɨ i'tuka'sa' i'se ɨwe'to' tekama'po auya wapiya rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Se kasa nin si ɨwɨpʉremato' kon esi mɨrɨ: “‘Ina Kʉipʉnʉ Epʉn pon, tʉnamasen pe ɨyese' nesii. ");
INSERT INTO akeNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ina esa' pe ɨwe'to' nʉyepʉi, serɨ non po ɨyeseru ne'kupʉi Epʉn po iyesi na'ne' kasa. ");
INSERT INTO akeNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ina irepakɨ serɨ pe wʉi kaisa rɨ te'sen ina i'kiyari ke. ");
INSERT INTO akeNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ina nʉko'manʉkʉnʉ ɨri pɨ' ɨsentu'makɨ, ina usentu'masa' ɨri ko'manʉ'nin nan pɨ' na'ne' kasa. ");
INSERT INTO akeNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mɨrɨ awonsi'kɨ ina kʉsarɨi i'tupɨ'nɨto' ya', e'tane ɨri pe te'sen piyapai ina imo'kakɨ.’ ");
INSERT INTO akeNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Apʉne pʉra ka'pon amʉ' uya ɨri pe ɨku'sa' a'tai, to' pɨ' ɨusentu'ma yau, ɨkʉipʉnʉ, Epʉn pon nɨ nɨrɨ usentu'ma mɨrɨ ɨpɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","E'tane ɨri pe ɨku'nin nan nʉ'pʉ kon pɨ' ɨusentu'ma kon pʉra iyesi yau, ɨkʉipʉnʉ rɨ nɨrɨ usentu'ma pʉra iyesi ɨpɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ɨuseruma a'tai tenta'nai' pʉra, pokoi pe ɨyemʉ' kʉ'kupʉi wakʉ pe te'ku'san e'to' kasa, temʉ' rɨ to' ena ka'pon amʉ' uya rɨ nin tento' kon pe, ka'pon amʉ' uya rɨ nin tapurɨto' kon pe. I'napairon nɨ ekama uya ɨpɨ', to' uya tepe'pʉ kon epoka'sa' rɨ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","E'tane ɨuseruma a'tai tenta'nai' pʉra, ɨsenpatauka', mɨrɨ awonsi'kɨ ekarapaima'. ");
INSERT INTO akeNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Mɨrɨ a'tai, ka'pon uya ɨto'ka'nʉkʉ pʉra iyesi mɨrɨ ɨuseruma tenta'nai' pʉra tukai', e'tane ɨkʉipʉnʉ, tʉusensen pen nɨ uya i'tu, mɨrɨ awonsi'kɨ ɨkʉipʉnʉ, ama'ai te'ku'sen ennin nʉ'pʉ uya rɨ ɨye'mato' pe. ");
INSERT INTO akeNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ɨimamin kʉsamʉranʉkʉi serɨ non po, ene amʉ' uya ima'tanʉ'to' yau rɨ, ikaranto' yau rɨ, ama' amʉ' e'to' ama' pe yau rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","E'tane Epʉn po ɨimamin kon amʉranʉ'tɨ', ene amʉ' uya ima'tanʉ'to' pen pata'se' yau, ikaranto' pen yau, ama' amʉ' e'to' ama' pe pata pen nɨ yau. ");
INSERT INTO akeNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Apʉne pʉra ɨimamin kon e'to' airɨ, mɨrɨ yau ɨyewan kon nɨ nɨrɨ esi. ");
INSERT INTO akeNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“En esi pun raan'puui pe rɨ. Wakʉ pe ɨyenu esi yau, tanporo ɨpun esi a'kwa pe. ");
INSERT INTO akeNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","E'tane, wakʉ pe pʉra ɨyenu esi a'tai, ewarupɨ pe rɨ ɨpun esi. Iweyu pʉra ɨpun esi yau, ipan pe rɨ ewarupɨ pe iyesi mɨrɨ! ");
INSERT INTO akeNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ɨnʉ' rɨ e'tʉrawasoma pʉra iyesi asa'ron kon tepuru ton apiyo' pe. Tikin nan ewaruma'tɨ iya, isakon i'nʉnka iya; tikin nan pɨ' ita'si, isakon sanoma iya pʉra. Asa'rɨ rɨ marɨ Papa mɨrɨ awonsi'kɨ pʉrata apiyo' pe ɨwesi pʉra iyesi. ");
INSERT INTO akeNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Mɨrɨ pe iyesi pɨ', ekama uya serɨ ɨpɨ'nokon, ɨuko'manto' kon pɨ' rɨ kɨsewankamatʉu, ɨi'kiyari kon pɨ' rɨ mɨrɨ pe pʉra ɨuku kon pɨ' rɨ, mɨrɨ pe pʉra ɨpun kon pɨ' rɨ, ɨ'rɨ esi upon pe tukai'. Ɨuko'manto' pe' esi pen mɨrɨ kiyari entai? Mɨrɨ awonsi'kɨ ɨpun kon pe' esi pen pon entai? ");
INSERT INTO akeNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Apʉne toron amʉ' entɨ' ka'tawon kon. Ti'kiyari kon pɨnnin nan pen nɨ, anʉnnin nan pen nɨ, mɨrɨ pe pʉra amʉranʉ'nin nan pen nɨ, e'tane rɨ ɨkʉipʉnʉ kon, Epʉn pon uya to' ewekʉ. Ɨmɨrɨ'nokon ken pe' si esi pen i'nʉnkena' pe to' entai? ");
INSERT INTO akeNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ɨnʉ' uya rɨ tʉuko'manto' ɨnka miyarɨ parɨ ipɨ' tʉusewankamai'? ");
INSERT INTO akeNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ɨ'rɨ pɨ' pon pɨ' ɨusewankama kon? Apʉne entɨ' pata ipʉrʉ esi wakʉ pe rɨ iya'ta tʉpata'se' yau, te'tʉrawasomasen pen mɨrɨ pe pʉra ɨ'pɨ'nin pen. ");
INSERT INTO akeNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mɨrɨ rɨ e'tane ekama uya serɨ ɨpɨ'nokon; Saraman, imaminkena' epontɨsa' pʉra iyesi'pʉ mɨrɨ ton kasa. ");
INSERT INTO akeNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mɨrɨ kasa si Papa uya wana' rɨ pontɨ pe iyesi yau wana' serɨ pe na'ne' mɨrɨ awonsi'kɨ awanapairɨ eno'ma apo' ya', mɨrɨ na'ne' entai pe' ɨpontɨ iya 'nokon pen mɨ? Aiko sɨ, aiko pe rʉ'kwɨ rɨ apurɨto' auya'nokon esi! ");
INSERT INTO akeNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Mɨrɨ pɨ' kɨsewankamatʉu, ‘Ɨ'rɨ kuru ɨ'to' pe?’ mɨrɨ pe pʉra, ‘Ɨ'rɨ kuru ensito' pe?’ mɨrɨ pe pʉra, ‘Ɨ'rɨ kuru e'to' pe upon kon pe?’ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Apʉne pʉra Papa i'tunin nan pen e'to' ipɨkɨrɨ ton serɨ, mɨrɨpan ɨkʉipʉnʉ kon, Epʉn pon uya i'tu serɨ ton i'se ɨwesi kon. ");
INSERT INTO akeNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","E'tane ru'ku, wapiya kuru esa' wannɨ pe iye'to' iwarinpatɨ' mɨrɨ awonsi'kɨ ipokena' pe iye'to', mɨrɨ awonsi'kɨ tanporo serɨ ton nɨ nin si e'tʉrʉ mɨrɨ ɨyena'nokon nɨ nɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Awanapairo' pɨ' kɨsewankamai, tʉponaron nɨ mɨrɨ awanapairo' pɨ' usewankaman; wʉi kaisa rɨ iponaro' rɨ usewankaman nɨto' esi,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ka'pon amʉ' eseru kʉsaimenkatʉu, ɨyeseru kon nɨ nɨrɨ aimenka kʉse'nin. ");
INSERT INTO akeNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Apʉne pʉra ka'pon amʉ' eseru maimenkayatʉi'ne' kasa rɨ marɨ ɨyeseru kon aimenka mɨrɨ. I'tuto' auya'nokon yai pe rɨ ɨnkupʉ'pʉ yai rɨ ɨyena'nokon i'tu mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ɨ'rɨ pe iyesi pɨ' aiko rʉ'kwɨ rɨ paranka punu'pɨ ɨnenpai ɨwesi ɨtonpa enu yawon, eke rɨ paranka e'tane ɨyenu yau? ");
INSERT INTO akeNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nai kasa ɨtonpa pɨ', ‘Apʉne amuru simo'kai' ɨyenu apai,’ ta auya inke rɨ moro paranka e'tane ɨyenu yau? ");
INSERT INTO akeNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ɨmɨrɨ'nokon wakʉ pe te'ku'san, wapiya kuru ɨyenu apai paranka imo'kaka'kɨ, mɨrɨ a'tai wakʉ pe ene auya ɨtonpa enu apai amuru mo'ka pa,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Wakʉ pe te'sen kʉ'tʉtʉu pero amʉ' ena'; mokon pun ton ɨiwano' kon kʉseno'matʉu peiruku amʉ' ena', to' uya iwasa'kapɨtʉ esi mɨrɨ awonsi'kɨ to' era'tɨ esi akarapɨ'se'na. ");
INSERT INTO akeNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ekama'potɨ'; mɨrɨ a'tai, ɨyena'nokon nɨ iye'tʉrʉ. Iwarinpatɨ'; mɨrɨ a'tai, eporo auya'nokon. Mʉra'ta iwɨpɨ'tɨ', mɨrɨpan uta'kokato' pe ɨyena'nokon. ");
INSERT INTO akeNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Apʉne pʉra tanporon kon ekama'po pɨ' na'ne' nan uya eporo; kʉrɨ rɨ iwarinpa pɨ' na'ne' uya rɨ eporo, mɨrɨ awonsi'kɨ kʉrɨ rɨ iwɨpɨtʉ pɨ' na'ne' ena' rɨ mʉra'ta uta'koka. ");
INSERT INTO akeNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nai kʉrɨ warai uya tʉmu uya pʉreti ekama'po yau irepa tɨ' ke? ");
INSERT INTO akeNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Mɨrɨ pe pʉra, moro' ekama'po iya yau, irepa ɨkʉi ke? ");
INSERT INTO akeNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ɨmɨrɨ'nokon nin si ɨri ton uya i'tu yau wakʉ ton e'repan nɨto' ke ɨmunkɨ kon amʉ' repa auya'nokon, mɨrɨ entai kuru ɨkʉipʉnʉ kon, Epʉn pon uya wakʉ ton e'repan nɨto' tʉrʉ kamoro ekama'ponin nan ena'. ");
INSERT INTO akeNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Mɨrɨ pɨ', tanporon yau rɨ iku'tɨ' tʉron kon pɨ', ikupʉ to' uya i'se me'ai'ne' ɨpɨ'nokon. Serɨ uya Main mɨrɨ awonsi'kɨ Pu'kena' amʉ' rɨ nʉmenuka'pʉ amʉranʉkʉ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ewontɨ' aiko rʉ'kwɨ mʉra'ta awɨrɨ, apʉne pʉra eke mʉra'ta mɨrɨ awonsi'kɨ eke asanta esi uma'tan nɨto' ya' utɨn e'ma pe, mɨrɨpan tu'kan kon nɨ ka'pon amʉ' ewomʉ iyawɨrɨ, ");
INSERT INTO akeNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","e'tane aiko rʉ'kwɨ mʉra'ta mɨrɨ awonsi'kɨ aiko rʉ'kwɨ asanta esi wakʉ uko'man nɨto' ya' utɨn e'ma pe, e'tane tu'kan kon pen nɨ utɨto' iyawɨrɨ,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Miyarɨ rɨ Sises esi'pʉ to' enupa pɨ', mɨrɨpan uya ta'pʉ, “Akono amʉ' pe te'san entɨ'; to' uyepʉ karimeru kasa, e'tane ɨsɨ ton, ene amʉ' kasa to' esi. ");
INSERT INTO akeNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","To' i'tu auya'nokon mɨrɨ to' eperu winɨ. Tikʉ kenan apai pe' kʉre' pʉipɨ'nin nan ka'pon amʉ', mɨrɨ pe pʉra pi' rɨ ɨmɨ'nɨ'ta apai? (Kane.) ");
INSERT INTO akeNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mɨrɨ kasa rɨ marɨ, wakʉ yʉi epeta wakʉ pe rɨ, ɨri yʉi epeta ɨri pe rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Wakʉ yʉi epeta pʉra iyesi ɨri pe, mɨrɨ awonsi'kɨ ɨri yʉi epeta pʉra iyesi mɨrɨ wakʉ pe. ");
INSERT INTO akeNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ka'pon amʉ' uya tʉusepetasen pen yʉi a'tɨ eno'mato' pe tʉuya'nokon apo' ya'. ");
INSERT INTO akeNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mɨrɨ kasa to' eperu winɨ to' i'tu auya'nokon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Sises uya ta'pʉ, “Tanporon kon ka'pon amʉ', ‘Uyepuru, uyepuru!’ tawon nan upɨ' epa'kato' oton pen nɨ Papa e'to' esa' wannɨ pe pata'se' ya', e'tane kʉrɨ rɨken ukʉipʉnʉ, Epʉn pon e'to' i'se ku'nin. ");
INSERT INTO akeNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Iweyu e'seposa' a'tai, tu'kan kon nɨ ka'pon amʉ' uya tato' oton upɨ', ‘Uyepuru, uyepuru, pu'kena' pe pe' ina usaurokʉ pʉn ɨyese' yau, mɨrɨ awonsi'kɨ ɨyese' yau pe' ɨri a'kwarʉ ton enpa'kapɨtʉ'pʉ ina uya pʉn, mɨrɨ awonsi'kɨ eke Papa tʉrawasooi ku'pɨtʉ pʉn pe' ina uya?’ ");
INSERT INTO akeNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mɨrɨ a'tai, tʉwapu'tɨi' pʉra to' pɨ' ekamato' uya oton, ‘Ɨi'tusa' uya 'nokon pʉra man. Entantɨ' upiyapai, ɨmɨrɨ'nokon ɨri ku'nin nan!’” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Mɨrɨ pe iyesi pɨ', tanporon kon serɨ ton umaimu ton eta pɨ' na'ne' nan mɨrɨpan kupʉ pɨ' na'ne' nan esi mɨrɨ ta'kwarʉ kenan ka'pon kasa tɨ' po tiwʉ' amɨnin. ");
INSERT INTO akeNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tuna uyee'pʉ, tuna apɨrʉ ton u'ma'pʉ, mɨrɨ awonsi'kɨ a'setun uyee'pʉ e'se'ne' pe ɨutɨ tʉwɨse, e'tane ita'mo'ka'pʉ pen nɨ, apʉne pʉra tɨ' po iyapon esi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","E'tane tanporon kon serɨ ton umaimu ton eta pɨ' na'ne' nan mɨrɨpan kupʉ to' uya pʉra na'ne' nan esi mɨrɨ iya'kwarʉ pʉn ka'pon kasa tiwʉ' amɨnin wɨ'sɨ' po. ");
INSERT INTO akeNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tuna uyee'pʉ, tuna apɨrʉ ton u'ma'pʉ, mɨrɨ awonsi'kɨ a'setun uyee'pʉ e'se'ne' pe ɨutɨ tʉwɨse, mɨrɨpan uta'mo'ka uya eke pe pata a'merunpa'pʉ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Serɨ ton pɨ' Sises usaurokʉ e'nonkasa' a'tai, anpisin ton nɨ ka'pon amʉ' usewansiuka'pʉ enupan nɨto' iya pɨ', ");
INSERT INTO akeNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","apʉne pʉra enupan iya pɨ' tʉmeruntɨrʉ kenan pe kuru rɨ, Main pɨ' enupanin nan kasa pʉra. ");
INSERT INTO akeNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Wʉ' ponsi'kɨ Sises u'tɨsa' a'tai, anpisin ton nɨ ka'pon amʉ' uya e'ma'pʉka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Erekʉ'pan ka'pon uyee'pʉ ipiya', mɨrɨpan e'sekunka'pʉ irau. Mɨrɨpan uya, “Uyepuru, ɨnku'pai ɨwesi yau, wakʉ pe rɨ ukupʉ auya,” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Temiyatʉ ɨnka'pʉ Sises uya, mɨrɨpan uya a'pɨtʉ'pʉ, “Ɨnku'pai rɨ e'ai', wakʉ pe e'kɨ!” ta'pʉ iya ipɨ'. Inke pʉra rɨ, tʉwereei apai iyekoneka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mɨrɨ a'tai, Sises uya, “Ɨnʉ' pɨ' rɨ kʉsekamai,” ta'pʉ, “e'tane enta ɨsenpoikata use'man nɨto' tʉrawasomanin ena', mɨrɨ awonsi'kɨ ɨntʉrʉnʉ pe te'sen Mosi' uya tasa' na'ne' awɨrɨ mʉtʉrʉi'. Mɨrɨ uya rɨ nin si ɨusepi'tɨsa' ekama mɨrɨ to' pɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Sises epa'kasa' a'tai, Ka'paneyan pona, soisa amʉ' epuru uyee'pʉ ipiya' tʉpika'tɨto' pe iya ekama'pose'na. ");
INSERT INTO akeNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Uyepuru, upoitorʉ man ipan pe e'ne' pe iyesi, ipu'tɨka'sa' te'kwe' tau rɨ iyesi, pata po,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","“Miyarɨ rɨ utɨ mɨrɨ epi'tɨi',” ta'pʉ Sises uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Soisa amʉ' epuru uya eikʉ'pʉ, “Uyepuru, uiwʉ' ta' ɨuyepʉ pokena' pen nɨ urɨ. Amaimu rɨken itʉkɨ; mɨrɨ a'tai, upoitorʉ usepi'tɨto' pe. ");
INSERT INTO akeNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Apʉne pʉra urɨ kʉrɨ rɨ tepuru kenan, soisa amʉ' esa' uwo'noro te'san. Pʉse pɨ', ‘Enta,’ ta uya a'tai, itɨ, mɨrɨ awonsi'kɨ kʉrɨ pɨ', ‘Ɨsi'kɨ,’ ta uya a'tai, iyepʉ. Upoitorʉ pɨ', ‘Se iku'kɨ,’ ta uya a'tai, ikupʉ iya,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Sises uya serɨ etasa' a'tai, isewansiuka'pʉ, mɨrɨpan uya ta'pʉ tʉpɨkɨrɨ te'san ka'pon amʉ' pɨ', “I'napairon ekama uya serɨ ɨpɨ'nokon, ɨnʉ' rɨ eposa' uya pʉra rɨ man Esuwerʉ po eke rɨ serɨ waraino apurɨto' esa'. ");
INSERT INTO akeNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ta uya ɨpɨ'nokon, tu'kan kon nɨ ka'pon amʉ' uye'to' oton pata wʉi enu uyepʉ, wʉi enu utɨ winɨ'ne, mɨrɨpan kon ereutato' oton enta'nan pɨ' Epʉra'an, Aisi' mɨrɨ awonsi'kɨ Seko' pokon pe Papa e'to' esa' wannɨ pe yau. ");
INSERT INTO akeNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","E'tane esa' wannɨ pe e'nɨto' yau te'ton kon tasa' kon nʉ'san eno'mato' iya oton ewarupɨ ya', ukaran nɨto' oton, ɨ e'kɨtɨtɨi'mato' oton ya',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Mɨrɨpan soisa amʉ' epuru pɨ' Sises uya ta'pʉ, “Enna'po', anapurɨnʉ awɨrɨ rɨ ɨpoitorʉ usepi'tɨ mɨrɨ,” ta'pʉ iya. Mɨrɨ a'tai rɨ, ipoitorʉ usepi'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sises utɨ'pʉ Pi'ta iwʉ' ta'. Mɨrɨ yau, Pi'ta ewo'pʉ ene'pʉ iya te'kwe' tau e'kɨɨi'man pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Mɨrɨpan uya itemiyatʉ pɨ' a'pɨtʉ'pʉ. Mɨrɨ a'tai rɨ, iye'kɨɨi'mato' ereuta'pʉ, mɨrɨpan e'mʉ'sa'ka'pʉ to' mʉta'napase'na. ");
INSERT INTO akeNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pata uko'mansa' a'tai, ka'pon amʉ' uya tu'kan kon nɨ ka'pon amʉ' makoi a'kwarʉ yen ton pe te'san nee'pʉ Sises piya'. Se kasa rɨ tʉusauro'se makoi a'kwarʉ ton ennoko'pʉ iya, tanporo rɨ takuru'kena' nan epi'tɨ'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Serɨ ton kupʉ'pʉ iya pena pu'kena' Aisaya nekama'pʉ rʉ'pʉ a'ku'tɨ pe: “Ɨ'sɨ'mʉra e'nɨto' mo'ka'pʉ iya, mɨrɨpan uya uyeparan kon arɨ'pʉ,” tawon. ");
INSERT INTO akeNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sises uya anpisin ensa' a'tai tʉwoi, tʉpoitorʉ ton pɨ', “Parau ku'pɨri ratoi pona e'kwɨrɨ'nɨpai'nokon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mɨrɨpan Main pɨ' enupanin uyee'pʉ ipiya', “Uyepuru, siya rɨ mʉtɨyai'ne' ya' rɨ aya'kɨrɨ utɨ serɨ,” tase'na ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Sises uya eikʉ'pʉ, “Maikan amʉ' kamoro tenkena' nan, mɨrɨ awonsi'kɨ toron amʉ' kanan esi tʉpon ke, e'tane Ka'pon, Papa winon esi mɨrɨ ti'pai nonkato' iya yau pʉn nɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tʉron nɨ kanan ka'pon Sises poitorʉ pe e'paino uya, “Uyepuru, apʉne ken si, wapiya ukʉipʉnʉ siu'na'tɨka'tai',” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","E'tane Sises uya ta'pʉ ipɨ', “Tɨwɨ tʉ'koro'tau'nokon te'sen eri'sa' u'na'tɨi to'; uya'kɨrɨ ru'ku utɨnpai,” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Sises ekanwa'tɨ'pʉ kanau ya', mɨrɨpan a'kɨrɨ ipoitorʉ ton utɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mɨrɨ koro'tau, ite'kwanau pʉra rɨ pana' pe, ɨsɨ pe rɨ a'setun uyee'pʉ parau ku'pɨri ka', mɨrɨpan uya eke pe rɨ sipa'sipa kupʉ'pʉ tuna pʉro'po. Eke pe sipa'sipa esi uya to' kanwa paru'tɨ esi'pʉ, e'tane rɨ Sises esi'pʉ e'nʉn nɨ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ipoitorʉ ton utɨ'pʉ ipiya' enpakase'na, ta'pʉ to' uya ipɨ', “Ina epuru! Ina ipika'tɨkɨ! Ina aputan pɨ' man!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Sises uya ta'pʉ to' pɨ', “Ɨmɨrɨ'nokon, aiko rʉ'kwɨ apurɨto' iya to' ton, ɨ'rɨ pɨ' ɨyetʉipɨtʉ kon?” ta'pʉ iya. Iye'mʉ'sa'ka'pʉ, mɨrɨpan uya a'setun mɨrɨ awonsi'kɨ sipa'sipa eseremekʉ'pʉ, mɨrɨpan e'nɨ'pamʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kamoro si ka'pon amʉ' usewansiuka'pʉ mɨrɨ, mɨrɨpan kon usekama'popɨtʉ'pʉ, “Ɨ'rɨ pan si pʉse rɨ ka'pon? A'setun mɨrɨ awonsi'kɨ sipa'sipa rɨ e'to' imaimu awɨrɨ!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Sises mɨrɨ awonsi'kɨ ipoitorʉ ton uya si parau ku'pɨri Kiyarari nʉ'kwɨrɨ'nʉ'sa' a'tai, ka'pon amʉ' Katara nono po tʉuko'mansan, asa'ron kon makoi a'kwarʉ yen ton pe te'san uyee'pʉ uruwai' apai to' winɨkʉi'. Ɨsɨ ton nɨ, ɨnʉ' utɨ pokena' pen nɨ mɨrɨ awɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mɨrɨpan kon ukɨ'pɨ'nʉmʉ'pʉ, “Ɨ'rɨ pe ina ku'se'na ɨuye'sa', Papa Mumu? Iweyu rawɨrɨ rɨ pe' ina kota'mai' ɨuye'sa'?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ɨnnɨ kuru pʉra rɨ to' piyapai tu'kan kon nɨ peiruku amʉ' esi'pʉ enta'nan pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Makoi a'kwarʉ yen ton uya Sises ekama'po'pʉ ipan pe, “Ina ken si ennoko auya a'tai pʉsamo ka'pon amʉ' apai, apʉne ken si ina enno'kɨ kamo tu'kan kon peiruku amʉ' ya',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Entantɨ' si,” ta'pʉ Sises uya to' pɨ'. To' epa'ka'pʉ, mɨrɨpan kon utɨ'pʉ peiruku amʉ' ya' ewonse'na. Tanporo rɨ si kamoro peiruku amʉ' eka'tumʉ'pʉ mɨrɨ parau ku'pɨri ka' tepitoren awɨrɨ rɨ, mɨrɨpan kon aputapɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mɨrɨ yau, to' mainanpa pɨ' te'san eka'tumʉ'pʉ pata pona, mɨrɨpan kon uya tanporo iye'ku'sa' rʉ'pʉ ekama'pʉ ka'pon amʉ' pɨ'. To' uya rɨ nɨrɨ kamo makoi a'kwarʉ yen ton pe te'san ka'pon amʉ' pɨ' iye'ku'sa' rʉ'pʉ ekama'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mɨrɨpan tanporo rɨ mɨrɨ pata yau te'san ka'pon amʉ' utɨ'pʉ Sises ense'na. To' uya Sises ensa' a'tai, tʉnono kon apai iyenna'poto' pe ipan pe to' uya auro'ka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Sises mɨrɨ awonsi'kɨ ipoitorʉ ton ekanwa'tɨ'pʉ, mɨrɨpan kon ɨ'kwɨrɨtʉ'pʉ. To' uyee'pʉ tʉpata'se' kon ya'. ");
INSERT INTO akeNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tʉron kon ka'pon amʉ' uya ipu'tɨka'sa' nee'pʉ Sises piya'. Sises uya pʉsamoro ka'pon amʉ' napurɨnʉ ene'pʉ, mɨrɨpan uya ipu'tɨka'sa' pɨ', “Utonpa, kenari'nʉmʉi, amakooi pɨ' usentu'masa' man,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Serɨ etasa' Main pɨ' enupanin nan tonpa ton uya a'tai, “Pʉse rɨ ka'pon usaurokʉ Papa sapema pe rɨ,” ta'pʉ to' uya tewan kon yau. ");
INSERT INTO akeNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Sises uya to' usenuminkato' i'tu'pʉ, mɨrɨpan uya ta'pʉ, “Ɨ'rɨto' pe ɨri pe rɨ ɨusenuminka kon ɨyewan kon yau? ");
INSERT INTO akeNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nai esi sa'man pe pʉra: ‘Amakooi pɨ' usentu'ma,’ ta; mɨrɨ pe pʉra, ‘E'mʉ'sa'ka', asakɨ,’ ta katɨ ipu'tɨka'sa' pɨ'? ");
INSERT INTO akeNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","I'tu kon pa, Ka'pon, Papa winon piyau meruntɨ esi serɨ non po makoi pɨ' usentu'man nɨto',” ta'pʉ iya. Sises uya ta'pʉ ipu'tɨka'sa' ka'pon pɨ', “E'mʉ'sa'kakɨ, ayapon anʉnkɨ, enna'pokɨ si apata'se' ya',” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Pʉse rɨ ka'pon ena'pʉ wakʉ pe, mɨrɨpan e'mʉ'sa'kasa', enna'po'pʉ tʉpata'se' ya'. ");
INSERT INTO akeNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Serɨ ensa' tʉuya'nokon a'tai, ipan pe rɨ ka'pon amʉ' enari'nʉmʉ'pʉ. To' uya si Papa apurɨpɨtʉ'pʉ eke rɨ serɨ meruntɨ tʉsa' iya pɨ' ka'pon amʉ' ena'. ");
INSERT INTO akeNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Sises uya si mɨrɨ pata nɨmɨ a'tai, ka'pon ereutasa' ene'pʉ iya pʉrata amʉranʉ'nin pe e'nɨ iwʉ' tau, Ma'siu itese'. Sises uya ta'pʉ ipɨ', “Ɨsi'kɨ upoitorʉ pe, Ma'siu,” ta'pʉ iya. Mɨrɨpan e'mʉ'sa'ka'pʉ, iya'kɨrɨ itɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Sises enta'na koro'tau Ma'siu iwʉ' tau, tu'kan kon nɨ pʉrata amʉranʉ'nin nan mɨrɨ awonsi'kɨ tʉmakooikena' nan uyee'pʉ ipokon pe enta'nase'na, mɨrɨ awonsi'kɨ ipoitorʉ ton pokon pe rɨ nɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mɨrɨ a'tai si, Pari'si amʉ' uya serɨ ensa' a'tai, ta'pʉ to' uya Sises poitorʉ ton pɨ', “Ɨ'rɨto' pe ɨti'saai kon enta'na pʉrata amʉranʉ'nin nan mɨrɨ awonsi'kɨ tʉmakooikena' nan pokon pe rɨ?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Sises uya to' eta'pʉ, mɨrɨpan kon pɨ' ta'pʉ iya, “Atu' ka'pon esi pen mɨrɨ ta'ta i'se e'tane, takuru'kenan esi i'se. ");
INSERT INTO akeNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ɨsenupatantɨ', ɨ'rɨ ta iya e'kwa pe serɨ esi tukai': ‘Ka'pon amʉ' i'se esi ɨsentu'kena' pe, o' ke tʉuse'masan i'se esi pen,’ tawon. Uye'sa' serɨ ipokena' ton ka'pon amʉ' kɨ'mai' pen, e'tane uye'sa' serɨ tʉmakooikena' nan kɨ'mase'na,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mɨrɨ tʉpo, Isaan poitorʉ ton uyee'pʉ Sises piya'. To' uya ta'pʉ ipɨ', “Ɨ'rɨ pe iyesi pɨ' ina mɨrɨ awonsi'kɨ Pari'si amʉ' useruma tenta'nai' pʉra, e'tane ɨpoitorʉ ton useruma pʉra iyesi?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Sises uya to' eikʉ'pʉ, “Nai kasa warawo' temari'masen nʉkɨ'ma'san esi tʉuta'kwarʉkai' ukaran nɨ pɨ' tʉpiyau'nokon nɨ iye'tane? Iweyu rɨ e'seporo mɨrɨ temari'masen utanʉnto' oton to' piyapai, mɨrɨ a'tai nin si to' useruma mɨrɨ tenta'nai' pʉra,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Sises uya rɨ ta'pʉ, “Ɨnʉ' uya rɨ pon pooi'pɨ pona pon atʉ punu'pɨ a'si'tɨ pʉra rɨ iyesi mɨrɨ; emenna' pon punu'pɨ uya ipooi'pɨ pon karaka mɨrɨ, mɨrɨpan uya eke pe iteuta kupʉ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Mɨrɨ kasa rɨ marɨ, ka'pon amʉ' uya emenna' waain entɨ pʉra iyesi mɨrɨ ipooi'pɨ iten ya'. Mɨrɨ ku'sa' to' uya a'tai, emenna' waain uya penaro' rʉ'pʉ iten toi'kwa rɨ mɨrɨ; mɨrɨ tʉpo, asa'rɨ rɨ marɨ waain mɨrɨ awonsi'kɨ iten uma'tasa' rɨ mɨrɨ. Ka'pon amʉ' uya emenna' waain entɨto' pe iyesi emenna' iten ya'. Mɨrɨ a'tai, asa'rɨ rɨ marɨ wakʉ pe iyesi mɨrɨ,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Serɨ rɨ ta Sises uya koro'tau, Esuwerʉ amʉ' epuru uyee'pʉ ipiya'. Iye'sekunka'pʉ Sises rakʉi', mɨrɨpan uya ta'pʉ ipɨ', “Uyensi uma'tasa' man serɨ pe rɨ, e'tane uya'kɨrɨ ɨsi'kɨ uiwʉ' ta' mɨrɨ awonsi'kɨ a'pɨ'tanʉ'kɨ ito'panto' pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Sises e'mʉ'sa'ka'pʉ, mɨrɨpan utɨ'pʉ iya'kɨrɨ. Ipoitorʉ ton nɨ nɨrɨ utɨ'pʉ iya'kɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mɨrɨ a'tai rɨ, uri'san, mʉn ennoko pɨ' te'sen uyee'pʉ ipɨkɨrɨ, ipon e'pi a'pɨ'se'na. Mɨrɨ pɨ' iko'mansa' esi'pʉ 12 kaisa rɨ wʉipiya. ");
INSERT INTO akeNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tewan yau rʉ'kwɨ rɨ, “Sises pon nɨ a'pɨ'sa' uya yau, usepi'tɨ rɨ mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Sises era'tɨ'pʉ, mɨrɨpan uya ene'pʉ. Ta'pʉ iya ipɨ', “Kɨsewankamai, ma'non. Papa uya ɨyepi'tɨsa' mɨrɨ, apʉne pʉra apurɨ auya ke,” ta'pʉ Sises uya ipɨ'. Mɨrɨ a'tai rɨ, uri'san usepi'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Mɨrɨ a'tai, Sises ewomʉ'pʉ Esuwerʉ amʉ' epuru iwʉ' ta'. Mɨrɨ yau, ka'pon amʉ', sarakuwa turunpa pɨ' te'san mɨrɨ awonsi'kɨ tʉron kon ukaran nɨ pɨ' te'san ene tʉuya a'tai, ");
INSERT INTO akeNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ta'pʉ iya to' pɨ', “Entantɨ', iyeri'sa' pen mɨrɨ; iye'nʉnsa' rɨ nin mɨrɨ,” ta'pʉ iya. E'tane to' uta'kɨrɨ'pʉ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pʉroroi pona to' enpa'ka tʉpo, ɨutɨ ta' iyewomʉ'pʉ, mɨrɨpan uya uri'san anʉmʉ'pʉ itemiyatʉ pɨ', mɨrɨpan uto'pamʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mɨrɨpan ekareei utɨ'pʉ siya rɨ mɨrɨ nono kaisarɨ rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Sises uya si mɨrɨ pata nɨmɨ koro'tau, asa'ron kon tenku'na' nan uya e'ma'pʉka'pʉ. To' ukɨ'pɨ'nʉnpɨtʉ'pʉ ipɨ', “Ɨmɨrɨ, Tepi' pa rʉ'pʉ, ina pɨ' ɨsentu'ma'!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Mɨrɨ a'tai si ɨutɨ ta' Sises ewonka'sa' koro'tau, to' uyee'pʉ ipiya'. To' ekama'po'pʉ iya, “Mapurɨyatʉu pe' ɨyepi'tɨ uya 'nokon tukai'?” ta'pʉ iya. Mɨrɨpan kon uya si ta'pʉ, “Ewai', Uyepuru, ina uya rɨ ayapurɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Mɨrɨ tʉpo, Sises uya to' enu a'pɨtʉ'pʉ, mɨrɨpan uya ta'pʉ, “Ɨsepi'tɨtɨ' si, apurɨ auya'nokon ke,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mɨrɨ awonsi'kɨ ennin nan pe si to' ena'pʉ. Mɨrɨ tʉpo, Sises uya ta'pʉ ipan pe to' pɨ', “Ɨnʉ' rɨ kʉ'pana'tɨtʉu serɨ pɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","E'tane rɨ to' utɨ'pʉ, mɨrɨpan kon uya serɨ si itekareei ekama'pʉ siya rɨ mɨrɨ nono kaisarɨ rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","To' utɨka'tane rɨ, ka'pon amʉ' uya makoi yen, tʉusauro'sen pen ka'pon nee'pʉ Sises piya'. ");
INSERT INTO akeNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mɨrɨpan enpa'kasa' iya a'tai, isaurokʉ'pʉ. Ipan pe rɨ ka'pon amʉ' usewansiuka'pʉ, mɨrɨpan kon uya ta'pʉ, “Serɨ waraino e'kupʉ ensa' pʉra rɨ iyesi wapiya Esuwerʉ po!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","E'tane Pari'si amʉ' uya ta'pʉ, “Makoi amʉ' epuru winɨ makoi amʉ' enpa'kapɨtʉ iya,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Sises utɨpɨtʉ'pʉ tanporon eke iwa ton pata yau'ne, mɨrɨpan uya ka'pon amʉ' enupa'pʉ Esuwerʉ amʉ' usenupato' iwʉ' tau'ne. Papa e'to' esa' wannɨ pe ekareei ekama'pʉ iya, mɨrɨpan uya tanporo ka'pon amʉ' epi'tɨpɨtʉ'pʉ ti'tui' pʉra paran pɨ' takuru'ke te'san. ");
INSERT INTO akeNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tu'kan kon ka'pon amʉ' ensa' tʉuya a'tai, to' pɨ' isentu'ma'pʉ, apʉne pʉra ipan pe rɨ usewankaman pɨ' mɨrɨ awonsi'kɨ tiwano' kon pe to' epika'tɨ poken pʉra rɨ to' esi pɨ'. To' esi'pʉ karimeru amʉ' ipa'simanin pʉnon kon kasa. ");
INSERT INTO akeNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mɨrɨpan uya ta'pʉ tʉpoitorʉ ton pɨ', “Eke pe rɨ umɨ yau kiyari akʉ'pʉsa' tanʉnsen man e'tane, tu'ke pʉra tʉrawaso amʉ' amʉranʉ'nin nan esi. ");
INSERT INTO akeNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Umɨ esa' ekama'potɨ', ka'pon amʉ' enno'to' pe iya kiyari akʉ'pʉsa' anʉmʉ amʉranʉ'nin nan pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","12 kaisaron kon tʉpoitorʉ ton kɨ'ma'pʉ iya tʉpiya', mɨrɨpan kon repa'pʉ iya ɨri a'kwarʉ pa'kato' meruntɨrʉ ke, ti'tui' pʉra rɨ paran ton pɨ' takuru'ke'ne te'san nɨrɨ epi'tɨpɨ'nin nan pe. ");
INSERT INTO akeNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Pʉsamoro na'ne' 12 kaisaron kon enno'sa' kon ese' ton: wapiya Saiman (Pi'ta tukai' tesa'sen), iyakon Anturu; Isens, Sepiti mu, mɨrɨ awonsi'kɨ iyakon Isaan; ");
INSERT INTO akeNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Piri', mɨrɨ awonsi'kɨ Pa'taramiu; Tamas, mɨrɨ awonsi'kɨ Ma'siu, Roman kopʉnaai ena' use'man nɨto' amʉranʉ'nin; Isens (Arʉ'piyas mu), mɨrɨ awonsi'kɨ Tatiyas; ");
INSERT INTO akeNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saiman, Usera' tukai' tesa'sen; mɨrɨ awonsi'kɨ Isutas Eskariya', eparankanin pe iyesi'pʉ na'ne'. ");
INSERT INTO akeNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Pʉsamoro 12 kaisaron kon tʉpoitorʉ ton ennoko'pʉ iya to' tauro'kai' se kasa: “Esuwerʉ amʉ' ton pen nɨ ka'pon amʉ' piya' kʉtɨtʉu, mɨrɨ pe pʉra kepa'katʉu Sameriya pata ton ya' rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","E'tane Esuwerʉ amʉ' piya' entantɨ', karimeru utano'masa' waraino kon piya'. ");
INSERT INTO akeNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ɨutɨ kon pe rɨ, serɨ itekare mekamatʉi': ‘A'ko pe Papa e'to' esa' wannɨ pe man,’ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Takuru'kenan kon ka'pon amʉ' mepi'tɨtʉi', iyeri'sa' kon nɨrɨ ka'pon amʉ' mi'mʉ'sa'kapɨ'tʉi'. Ere' pɨ' te'san mepi'tɨtʉi', mɨrɨ awonsi'kɨ ɨri a'kwarʉ ton menpa'kapɨ'tʉi'. Te'mai' pʉra eposa' auya'nokon kasa rɨ, te'mai' pʉra mʉtʉtʉi'. ");
INSERT INTO akeNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Korʉ, sirʉpa, ka'pa rɨ kʉsatʉu ɨpokʉrʉʉi kon yau; ");
INSERT INTO akeNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","paiki, sapato, teke'sen, mɨrɨ awonsi'kɨ tu'ke ipona ɨpon kon kʉsatʉu aya'kɨrɨ'nokon, apʉne pʉra tʉrawaso amʉ' pe ɨwesi kon, mɨrɨ epe'pʉ rɨ eporo auya'nokon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Sises uya ta'pʉ, “Eke iwa pata ya' ɨutɨ kon a'tai, wakʉ pe tiwʉ' kon ta' ɨyereutanʉ'nin kon mɨnentʉi'. Itiwʉ' tau me'tʉi' inɨmɨ auya'nokon pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","To' iwʉ' ta' ɨyewomʉ kon a'tai, ‘Miyarɨ,’ mʉkatʉi'. ");
INSERT INTO akeNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","To' uya ɨyereutanʉkʉ kon a'tai, tɨwɨ ‘Miyarɨ,’ ta'pʉ auya'nokon nɨ ne'nonkai to' pona. Mɨrɨ kupʉ to' uya pʉra iyesi a'tai ɨpɨ'nokon, mʉna'potʉi' to' piyapai. ");
INSERT INTO akeNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ɨnʉ' uya rɨ wakʉ pe ɨyereutanʉkʉ kon pʉra iyesi yau, mɨrɨ pe pʉra amaimu kon eta to' uya pʉra iyesi yau, a'ta kon mʉtɨutɨpɨ'tʉi' mɨrɨ pata nɨmɨ auya'nokon a'tai. ");
INSERT INTO akeNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","I'napairon ekama uya ɨpɨ'nokon, Satan mɨrɨ awonsi'kɨ Komora uya imoronka poken parɨ iye'to' oton eseru aimenka weyu a'tai mɨrɨ pata uya imoronka entai iye'tane,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Sises esi'pʉ miyarɨ rɨ 12 kaisaron kon tʉpoitorʉ ton auro'ka pɨ'. Ta'pʉ iya to' pɨ', “Ɨyennoko uya 'nokon serɨ ɨri ton ka'pon amʉ' koro'ta', karimeru ennoko kasa ɨsɨ ton, ene amʉ' koro'tau. Mɨrɨ pe iyesi pɨ', emepoke' pe me'tʉi' ɨkʉi kasa, mɨrɨ awonsi'kɨ ɨsɨ pe pʉra wako'wa kasa me'tʉi'. ");
INSERT INTO akeNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tenu ke nɨrɨ me'tʉi' ka'pon amʉ' pɨ'; to' uya ɨtʉto' oton kon mɨrɨ pata epuru ton ena'. To' uya nɨrɨ ayari'po'pɨ'to' oton kon mɨrɨ tʉusenupato' kon iwʉ' tau'ne. ");
INSERT INTO akeNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","To' uya ayato' oton kon mɨrɨ kopʉna mɨrɨ awonsi'kɨ kin amʉ' piya' urɨ wenai, urɨ ekama kon pa Esuwerʉ amʉ' mɨrɨ awonsi'kɨ Esuwerʉ amʉ' pen pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","E'tane kɨsewankamatʉu to' uya aya'sisa' kon a'tai, ɨ'rɨ ta uya, nai kasa ta uya tukai'. Mɨrɨ a'tai, amaimu'tɨ uya 'nokon mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ɨmɨrɨ'nokon pe ausaurokʉ kon pen mɨrɨ, e'tane ɨkʉipʉnʉ kon A'kwarʉ usauro'to' oton mɨrɨ ayawɨrɨ'nokon. ");
INSERT INTO akeNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Eri'nɨto' ya' tʉrui eparankato' oton iyakon uya, ikʉipʉnʉ uya nɨrɨ tʉmʉre; mɨrɨ kasa rɨ marɨ, mʉre amʉ' enato' oton tʉsan kon amʉ' ewa'noma pɨ' to' eri'to' ya' to' tʉrʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Urɨ wenai tu'kan kon ka'pon amʉ' uya ɨyewaruma'tɨto' oton kon, e'tane kʉrɨ rɨ pana' pe ne'mʉ'sa'kayai'ne' iu'matʉ pona rɨ epika'tɨto' oton mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","To' uya pata yau ɨkota'ma kon a'tai, tʉron nɨ pata ya' mapʉrʉntʉi'. I'napairon ekama uya ɨpɨ'nokon, Esuwerʉ amʉ' pata ton awɨrɨ ɨutɨto' kon i'ma'kasa' auya'nokon pʉra iye'tane Ka'pon, Papa winon uye'to' oton,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Sises uya rɨ ta'pʉ, “Tʉusenupasen esi pʉra iyesi tʉti'saai entai, mɨrɨ pe pʉra ipoitorʉ pe te'sen tesa' entai. ");
INSERT INTO akeNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tʉusenupasen e'to' pe iyesi tʉti'saai kasa, mɨrɨ awonsi'kɨ ipoitorʉ kanan tesa' kasa rɨ. Ɨutɨ esa' pe te'sen esakʉ pe iyesi yau Pirɨsipupʉ tukai', mɨrɨ entai kuru rɨ si to' uya itiwʉ' tawon kon esakʉ! ");
INSERT INTO akeNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Mɨrɨ pɨ', to' pɨ' kenari'nʉntʉu. Ɨ'rɨ pʉra rɨ iyesi mɨrɨ iwapu'tɨsa' te'nɨponkasen pen, mɨrɨ pe pʉra onansa' i'tu pʉra te'sen. ");
INSERT INTO akeNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ewarupɨ yau kanpana'tɨyatʉi'ne' ekamatɨ' wʉi nai; apana kon ya' ɨyetarerumʉ'pʉ kon ekamatɨ' ɨutɨ nakapu ponsi'kɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ɨpun kon wɨnin nan pɨ' kenari'nʉntʉu, aya'kwarʉ kon wɨnin nan pen nɨ pɨ'. E'tane ru'ku, kʉrɨ pɨ' enari'nʉntɨ', asa'rɨ rɨ marɨ ɨpun mɨrɨ awonsi'kɨ aya'kwarʉ wɨnin pɨ' ekota'man nɨto' yau. ");
INSERT INTO akeNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Asa'ron kon pe' toron amʉ' tekʉrʉpo'pomasan pen tikin nan pʉrata punu'pɨ kaisa rɨ? E'tane tikin nan nɨ to' tonpa uta'mo'ka pen mɨrɨ non pona ɨkʉipʉnʉ wanmʉra. ");
INSERT INTO akeNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","A'pai i'po' tu'kanoro esi tanporo i'tusa' pe. ");
INSERT INTO akeNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mɨrɨ wenai, kenari'nʉntʉu, i'nʉnkena' ton ɨmɨrɨ'nokon, tu'kan kon toron amʉ' entaino kon. ");
INSERT INTO akeNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ɨnʉ' rɨ uyekamayai'ne', ‘I'nai rɨ iyesi tukai',’ ka'pon amʉ' rau, urɨ uya rɨ nɨrɨ ekama, ‘I'nai rɨ iyesi tukai',’ ukʉipʉnʉ, Epʉn pon rau. ");
INSERT INTO akeNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","E'tane ɨnʉ' rɨ, unonkayai'ne' ka'pon amʉ' rau, urɨ uya rɨ nɨrɨ inonka mɨrɨ ukʉipʉnʉ, Epʉn pon rau. ");
INSERT INTO akeNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Serɨ non pona tʉusewankamai' pʉra e'nɨto' ne'sa' uya tukai' ke'tʉu,” ta'pʉ Sises uya. “Tʉusewankamai' pʉra e'nɨto' ne'se'na uye'sa' pen, e'tane supara ne'sa' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Apʉne pʉra uye'sa' rɨ tasa': “‘warawo' era'tɨto' pe tʉkʉipʉnʉ ewa'noma pɨ', uri'san tʉsan ewa'noma pɨ', ipa'se tewo'pʉ ewa'noma pɨ'— ka'pon eyaton pe itiwʉ' tawon kon nɨ enato' oton,’” tawon. ");
INSERT INTO akeNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Sises uya ta'pʉ, “Ɨnʉ' rɨ kʉrɨ rɨ tʉkʉipʉnʉ, tʉsan i'nʉnkanin urɨ i'nʉnka tʉuya entai esi mɨrɨ upoitorʉ ye' pe pʉra rɨ. Ɨnʉ' rɨ kʉrɨ tʉmu, mɨrɨ pe pʉra tensi i'nʉnkanin urɨ i'nʉnka tʉuya entai esi mɨrɨ upoitorʉ ye' pe pʉra rɨ, ");
INSERT INTO akeNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","mɨrɨ awonsi'kɨ ɨnʉ' rɨ tʉkurusukuui tanʉnse upɨkɨrɨ ɨtɨpai pʉra na'ne' esi uiwano' pe pʉra. ");
INSERT INTO akeNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ɨnʉ' rɨ kʉrɨ tʉuko'manto' eporo pɨ' na'ne' uya tʉuko'manto' nonka rɨ mɨrɨ. Ɨnʉ' rɨ kʉrɨ tʉuko'manto' nonkanin nʉ'pʉ uwenai uya tʉuko'manto' epoto' oton mɨrɨ,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Sises uya ta'pʉ miyarɨ rɨ, “Kʉrɨ ayanʉnyai'ne' uya uyanʉmʉ rɨ, mɨrɨ awonsi'kɨ kʉrɨ uyanʉnyai'ne' uya kʉrɨ uyenno'nin nʉ'pʉ anʉmʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ɨnʉ' uya Papa Maimu anin ereutanʉ'sa' a'tai, Papa Maimu anin pe iyesi pɨ' uya itepe'pʉ tonpa eporo mɨrɨ tepe'pʉ eporo iya a'tai. Ɨnʉ' uya rɨ ipokena' ka'pon ereutanʉ'sa' a'tai, ipokena' pe iyesi pɨ', kʉrɨ rɨ uya rɨ ipokena' ka'pon epe'pʉ tonpa eporo mɨrɨ tepe'pʉ eporo iya a'tai. ");
INSERT INTO akeNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mɨrɨ awonsi'kɨ ɨnʉ' uya pʉsamoro sepa' nan nʉ'kwɨ rɨ o'pa yau komi' tuna ke rʉ'kwɨ rɨ, apʉne pʉra upoitorʉ pe to' esi pɨ', i'napairon ekama uya ɨpɨ'nokon, tepe'pʉ nonka iya pen kuru rɨ mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","12 kaisaron kon tʉpoitorʉ ton auro'ka tʉpo, Sises utɨ'pʉ mɨrɨ pata apai itekare ekamai' mɨrɨ awonsi'kɨ ka'pon amʉ' enupai' Kiyarari po'nan pata ton yau. ");
INSERT INTO akeNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Isaan Pa'tes uya etasa' a'tai pariki'si tawonsi'kɨ Kʉrai nʉkupʉnʉ, tʉpoitorʉ ton ennoko'pʉ iya ");
INSERT INTO akeNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ekama'popɨ'se'na, “Ɨmɨrɨ pe' kʉrɨ rɨ tʉuye'ton ta'pʉ rʉ'pʉ ipɨ', tʉron nɨ rɨ katɨ uyepʉ enupɨkɨrɨ ina e'to' nai?” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Sises uya to' eikʉ'pʉ, “Enna'potɨ', ɨneta'pʉ kon mɨrɨ awonsi'kɨ ɨnene'pʉ kon ekamatantɨ' Isaan pɨ'; ");
INSERT INTO akeNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","tenku'na' nan enasa' man ennin nan pe; ise'mesa' kon enasa' man tʉusasan pe; erekʉ'pa' nan usepi'tɨsa' man; etanin nan pen enasa' man etanin pe; eke' amʉ' e'mʉ'sa'kasa' man, mɨrɨ awonsi'kɨ wakʉ itekare usekamasa' man entu'manin nan pana ya'. ");
INSERT INTO akeNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Pori' pe ka'pon esi mɨrɨ tʉuta'mo'kasen pen unkupʉnʉ uriya',” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Isaan poitorʉ ton enna'po koro'tau, Sises epiya'tɨ'pʉ anpisin auro'ka pɨ' Isaan pɨ', “Ɨ'rɨ ense'na ɨutɨ'pʉ kon rɨmono' ta'? Wana' rɨ ari'ma a'setun uya ense'na? ");
INSERT INTO akeNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mɨrɨ pe pʉra iyesi yau, ɨ'rɨ ken ense'na ɨutɨ'pʉ kon? Wakʉ pe katɨ ka'pon epontɨpɨ'sa' ense'na? Kane. Kamoro rupɨ ton nin esi mɨrɨ epe'kena' ton ipon ton esi kin iwʉ' tawon kon. ");
INSERT INTO akeNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ɨ'rɨ kuru ken ense'na ɨutɨ'pʉ kon? Pu'kena' katɨ? Ewai' apana'tɨ uya 'nokon, pu'kena' entaino rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Pʉse rɨ sa'ne si kʉrɨ rɨ ko iye'menukasa' itekare usauro'sa' rʉ'pʉ ipɨ': “‘Umaimu ekamanin ennoko uya mɨrɨ arawɨrɨ, ɨye'ma konekanin pe awapiya,’ ta'pʉ rʉ'pʉ ipɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“I'napairon ekama uya ɨpɨ'nokon, kamo uri'sami'si amʉ' nentunʉkʉ'san koro'tau pʉra iyesi mɨrɨ eke Isaan Pa'tes entaino; mɨrɨ e'tane, kʉrɨ aiko pe te'sen Epʉn po esa' wannɨ pe e'nɨto' yawon esi eke pe Isaan entai. ");
INSERT INTO akeNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Isaan Pa'tes weyu rʉ'pʉ si'kɨrɨ serɨ pʉ'kʉ pona, Epʉn po esa' wannɨ pe e'nɨto' uta'tu'man pɨ' man meruntɨ pe, mɨrɨpan a'si pɨ' meruntɨ ton ka'pon amʉ' man. ");
INSERT INTO akeNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tanporon kon nɨ pu'kena' amʉ' mɨrɨ awonsi'kɨ Main usenupan nɨto' ipɨ' uya Papa Maimu ekama'pʉ, Isaan Pa'tes uyepʉ pʉ'kʉ pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Serɨ si to' maimu anapurɨpai ɨwesi kon yau, Isaan nɨ si kʉrɨ rɨ Iraisa uyepʉ tasa' rʉ'pʉ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kʉrɨ rɨ tʉpana ke na'ne' tɨwɨ netai,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Sises uya kanan takaa'pʉ, “Ɨnʉ' yan kasa to' esi tukai' serɨ a'taino kon ekama uya? Mʉre amʉ' ereutapɨ'sa' kʉrʉpo'po pata'se' yau na'ne' tʉukɨ'pɨ'nʉnpɨ'san tʉron kon pɨ' kasa to' esi: ");
INSERT INTO akeNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“‘Sarakuwa turunpa'pʉ ina uya, e'tane aumanʉnsa' kon pʉra iyesi. Eke' eremu pɨ' ina userenka'pʉ, e'tane tʉuta'kwarʉkai' aukaransa' kon pʉra iyesi,’ tawon nan kasa. ");
INSERT INTO akeNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Apʉne pʉra Isaan uyee'pʉ iyenta'na mɨrɨ awonsi'kɨ ɨ'rɨ ensi iya pʉra, mɨrɨpan pɨ', ‘Makoi esi iyau,’ ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ka'pon, Papa winon uyee'pʉ tenta'nasen nɨ waain ensinin nɨ, mɨrɨpan pɨ', ‘Eke pe tenta'nasen, te'taripasen,’ ta'pʉ ipɨ'. ‘Pʉrata amʉranʉ'nin nan mɨrɨ awonsi'kɨ tʉmakooikena' nan nɨ tonpa pe iyesi,’ ta'pʉ to' uya. E'tane Papa pu'ketʉ usi'tu mɨrɨ i'napai rɨ inkupʉnʉ pɨkɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mɨrɨ a'tai, Sises usaurokʉ'pʉ ka'pon amʉ' pata yau to' eno'ma pe, eke Papa tʉrawasooi kupʉ'pʉ tʉuya yau'ne, apʉne pʉra tʉmakooi kon apai to' era'tɨ kasa pʉra. ");
INSERT INTO akeNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ɨsɨ sɨ, Korasin pon kon! Ɨsɨ sɨ, Pe'saita pon kon! Ɨ'koro'tau'nokon ne'ku'ai'ne' eke Papa tʉrawasooi e'ku'sa' pe iyesi yau Taya mɨrɨ awonsi'kɨ Saitan pon kon koro'tau, pena rɨ to' era'tɨ'pʉ nesii'no tʉmakooi kon apai. To' epontɨpɨ'sa' esi'pʉ nesii'no isa'ka'si ya', urumɨrʉ'pʉ yau to' nesii'no. ");
INSERT INTO akeNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","E'tane apana'tɨ uya 'nokon Taya mɨrɨ awonsi'kɨ Saitan pon kon uya parɨ imoronkato' oton eseru aimenka weyu e'seposa' a'tai ɨmɨrɨ'nokon entai. ");
INSERT INTO akeNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ɨmɨrɨ'nokon, Ka'paneyan pon kon, autanʉnto' oton kon pe' ka'takʉi'? Kane! I'na' auta'mo'kato' oton kon mɨrɨ ta'mu kenan pen nɨ ya'. Ɨ'koro'tau'nokon ne'ku'ai'ne' eke Papa tʉrawasooi e'ku'sa' pe iyesi yau Satan po, moro rɨ mɨrɨ pata nesii'no serɨ pʉ'kʉ pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","E'tane pʉra rɨ ekama uya ɨpɨ'nokon, Satan pon kon uya parɨ imoronkato' oton eseru aimenka weyu e'seposa' a'tai ɨmɨrɨ'nokon entai,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mɨrɨ a'tai, Sises uya ta'pʉ, “Kanyapurɨpɨ'ai', Papai, Epʉn mɨrɨ awonsi'kɨ non Epuru, apʉne pʉra serɨ ton onansa' auya pɨ' pu'kena' ton mɨrɨ awonsi'kɨ isenupasa' kon piyapai, mɨrɨpan enpoikasa' auya pɨ' aiko ton mʉre amʉ' ena'. ");
INSERT INTO akeNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ewai' Papai, serɨ ku'sa' auya i'se ɨwe'to' awɨrɨ pori' pe ɨku'nin pe iyesi pɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tʉwɨpʉrema tʉpo, ka'pon amʉ' auro'ka pɨ' iye'sara'tɨ'pʉ. “Tanporon nɨ esi ukʉipʉnʉ nʉnonka'pʉ pe uyena'. Ɨnʉ' uya rɨ imu i'tu pʉra iyesi, e'tane ikʉipʉnʉ uya rɨken i'tu. Ɨnʉ' uya rɨ ikʉipʉnʉ i'tu pʉra iyesi, e'tane imu uya rɨken i'tu mɨrɨ awonsi'kɨ kamo nɨrɨ imu na'ne' e'to' ɨnenpoikapai itena' ton,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ɨsi'tɨ' ɨmɨrɨ'nokon iseta'kasa' kon, e'tape'ne' esa' pe te'san, ɨumoronkapʉ kon pa ɨku'to' kon pe uya. ");
INSERT INTO akeNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Uwari'sarʉ apon anʉntɨ' ɨpona'nokon, ɨusenupa kon pa upɨ', ɨsɨ pen nɨ urɨ, mɨ pe te'ku'sen pen nɨ uyewan yau, aya'kwarʉ kon umoronka'to' eporo kon pa. ");
INSERT INTO akeNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Wakʉ rɨ mɨrɨ uwari'sarʉ apon, mɨrɨ awonsi'kɨ uwari'sarʉ esi asi'ono pe,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mɨrɨ a'tai, Sises utɨ'pʉ a'nai' e'kwa nawɨrɨ Sapa' a'tai. Ipoitorʉ ton esi'pʉ iwan pe, mɨrɨpan kon e'sara'tɨ'pʉ a'nai' e'suruupɨ'sa' i'kwɨ'pɨtʉ pɨ', mɨrɨpan kon uya ɨku'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pari'si amʉ' uya serɨ e'kupʉ ensa' a'tai, Sises pɨ' ta'pʉ to' uya, “Apʉne enkɨ, ɨpoitorʉ ton uya Main uya tʉku'sen pen Sapa' a'tai tasa' rʉ'pʉ kupʉ,” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Sises uya to' eikʉ'pʉ, “Kin Tepi' nʉkupʉ'pʉ pe' etasa' auya'nokon pʉra nai, tʉpoitorʉ ton pokon pe iwan pe tesi kon a'tai? ");
INSERT INTO akeNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Iyewomʉ'pʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' ta' tʉtonpa ton pokon pe mɨrɨpan kon uya ipʉremasa' pʉreti ɨku'pʉ, to' nʉkupʉnʉ tasa' pen nɨ Main uya e'tane. Papa ena' use'man nɨto' tʉrawasomanin nan yu pe rɨken te'sen ɨku'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mɨrɨ rɨken pe pʉra, ene auya'nokon pʉra pe' iyesi Main yau Papa ena' use'man nɨto' tʉrawasomanin nan uya Papa iwʉ' tau Sapa' a'tai Main i'kwɨtʉ'pʉ te'tʉrawasoma kon winɨ, e'tane wakʉ pe rɨ to' esi? ");
INSERT INTO akeNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","“Ɨpɨ'nokon ekama uya serɨ; moro rɨ iyesi serɨ yau eke pe te'sen Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' entaino. ");
INSERT INTO akeNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","I'tusa' auya'nokon pe iyesi yau ɨ'rɨ ta e'kwa pe serɨ main esi tukai', ‘Ɨsentu'kena' pe ɨwesi kon i'se esi, o' ke ɨuse'ma kon i'se esi pen,’ tawon, wakʉ ton nɨ eno'masa' auya'nokon nesii'no pen. ");
INSERT INTO akeNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Apʉne pʉra Ka'pon, Papa winon esi Sapa' Epuru pe rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Mɨrɨ apai tʉutɨi', itɨ'pʉ Esuwerʉ amʉ' usenupato' iwʉ' ta'. ");
INSERT INTO akeNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mɨrɨ yau, itemiyatʉ aipʉtasa' amʉrasa' ka'pon esi'pʉ. Sises eseru'tɨto' pe tʉuya'nokon, mɨrɨ yawon kon ka'pon amʉ' uya ekama'po'pʉ, “Main awɨrɨ pe' e'nɨ pe iyesi mɨrɨ, Sapa' a'tai ka'pon epi'tɨsa' a'tai?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ta'pʉ iya to' pɨ', “Karimeru esa' pe ɨwesi kon yau mɨrɨpan uta'mo'ka yau akasa' ya' Sapa' a'tai, ta'sii' pe' anʉmʉ auya'nokon pen? ");
INSERT INTO akeNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ka'pon esi i'nʉnkena' pe karimeru entai. Mɨrɨ pe iyesi pɨ', Sapa' a'tai ka'pon pika'tɨsa' esi Main awɨrɨ e'nɨ pe rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Mɨrɨpan a'tai, “Ɨyemiyatʉ ɨnka',” ta'pʉ Sises uya ka'pon pɨ', mɨrɨpan uya temiyatʉ ɨnka'pʉ, mɨrɨpan enna'po'pʉ tesi'pʉ ya', itemiyatʉ ratoi kasa rɨ marɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","E'tane si Pari'si amʉ' epa'kasa' utɨ'pʉ, mɨrɨpan kon ekoneka'pʉ iwɨto' tʉuya'nokon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Sises uya Pari'si amʉ' ekonekasa' i'tusa' a'tai, itɨ'pʉ mɨrɨ pata apai. Tu'kan kon ka'pon amʉ' utɨ'pʉ ipɨkɨrɨ, mɨrɨ yau to' koro'tau takuru'kena' nan esi'pʉ, mɨrɨpan kon epi'tɨpɨtʉ'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","To' panama'pʉ iya tʉron kon pɨ' kʉrɨ rɨ kʉrɨ rɨ ta to' uya namai' tʉpɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Serɨ kupʉ'pʉ iya pu'kena' Aisaya yai Papa usaurokʉ'pʉ uta'ku'tɨto' pe: ");
INSERT INTO akeNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Upoitorʉ pe, unanʉmʉ'pʉ pʉse rɨ. Ipan pe uni'nʉnkanʉ, mɨrɨpan pɨ' epori'ma. Uya'kwarʉ ennoko uya mɨrɨ ipona, mɨrɨpan uya wakʉ pe e'nɨ eseru ekamato' oton tanporon kon ka'pon amʉ' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mɨrɨpan usauro'to' oton ama'ai; eke pe asanta tau isauro'to' oton pen. ");
INSERT INTO akeNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Iye'sekeukasa' wana' i'kwɨtʉ iya pen, mɨrɨ awonsi'kɨ usenkʉ'nɨ poken te'sen apo' enkʉ'nʉkʉ iya pen, wakʉ ena itentai pʉ'kʉ pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Itese' yau tanporon kon ka'pon amʉ' uya te'ku'to' kon tʉto' oton,” tawon. ");
INSERT INTO akeNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mɨrɨ yau, tʉron kon ka'pon amʉ' uya makoi yen ka'pon nee'pʉ Sises piya'. Kʉrɨ rɨ ka'pon esi'pʉ tenku'nan mɨrɨ awonsi'kɨ tʉusauro'sen pen. Mɨrɨpan epi'tɨ'pʉ Sises uya makoi a'kwarʉ tenpa'kai', mɨrɨpan enasa' esi'pʉ tʉusauro'sen pe, mɨrɨ awonsi'kɨ ennin pe. ");
INSERT INTO akeNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mɨrɨ a'tai, ka'pon amʉ' usewansiuka'pʉ, mɨrɨpan kon uya, “Tepi' pa rʉ'pʉ pe pe' iyesi serɨ, itenupɨkɨrɨ e'nɨto' Me'saya?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","E'tane Pari'si amʉ' uya serɨ etasa' tʉuya'nokon a'tai, “Pirɨsipupʉ, makoi amʉ' epuru uya tʉpika'tɨi' makoi amʉ' enpa'kapɨtʉ pʉse rɨ uya mɨrɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Sises uya to' usenuminkato' i'tusa' esi'pʉ, mɨrɨpan uya ta'pʉ to' pɨ', “Tanporo esa' wannɨ pe te'san epantakapɨ'sa' a'tai ɨsewa'nomai' tiwano' kon pe rɨ, to' uma'ta mɨrɨ; pata mɨrɨ pe pʉra ɨsiwʉ' tawon kon ka'pon amʉ' epantakapɨ'sa' a'tai ɨsewa'nomai' tiwano' kon pe rɨ uko'mamʉ pen nɨ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mɨrɨ kasa si iyesi Se'tan uya Se'tan nɨrɨ enpa'kasa' a'tai, tiwano' pe rɨ iyepantakasa' pe iyesi ɨsewa'nomai'; mɨrɨ kasa iyesi a'tai, nai kasa ken Se'tan e'to' itesa' pe uko'mamʉ? ");
INSERT INTO akeNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mɨrɨ awonsi'kɨ makoi amʉ' enpa'ka uya pe iyesi yau Pirɨsipupʉ ke, ɨnʉ' ke ken ɨpoitorʉ kon to' enpa'kanin nan? To' nin si esi mɨrɨ ɨyeseru kon aimenkanin nan pe. ");
INSERT INTO akeNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","E'tane makoi amʉ' enpa'ka uya pe iyesi yau Papa A'kwarʉ ke, Papa e'to' esa' wannɨ pe nin si uye'sa' mɨrɨ ɨpona'nokon. ");
INSERT INTO akeNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Mɨrɨ pe pʉra kanan, nai kasa ɨnʉ' rɨ ewomʉ pana'pan iwʉ' ta' itapuruui ton ase'na? Wapiya auronpɨ'sa' a'tai rɨ nin iye'kupʉ. Mɨrɨ a'tai nin itimamin arɨ iya itiwʉ' tapai. ");
INSERT INTO akeNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Kʉrɨ rɨ ka'pon utonpa pe pʉra na'ne' esi mɨrɨ uyeyaton pe; kʉrɨ rɨ amʉranʉkʉ iya pʉra na'ne' uya'kɨrɨ uya, ita'nʉkʉ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ekama uya ɨpɨ'nokon, tanporon nɨ makoi mɨrɨ awonsi'kɨ Papa sapema pe isauro'sa' kon ka'pon amʉ' pɨ' rɨ usentu'man, e'tane Iya'kwarʉ sapema pe isauro'sa' kon pɨ' usentu'man pen nɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ɨnʉ' rɨ Ka'pon, Papa winon pɨ' ewa'noma pe isauro'sa' rʉ'pʉ pɨ' usentu'man, e'tane ewa'noma pe Wakʉ A'kwarʉ pɨ' isauro'sa' rʉ'pʉ pɨ' usentu'man pen nɨ, serɨ a'tai'ne mɨrɨ pe pʉra serɨ entawon a'tai'ne rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Wakʉ pe yʉi iku'kɨ; mɨrɨ a'tai, wakʉ pe iteperu esi mɨrɨ. Mɨrɨ pe pʉra, ɨri pe yʉi iku'kɨ; mɨrɨ a'tai, ɨri pe rɨ iteperu esi mɨrɨ, apʉne pʉra yʉi usi'tu mɨrɨ iteperu winɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ɨmɨrɨ'nokon ɨkʉi munkɨ ton! Nai kasa ɨmɨrɨ'nokon ɨri pe te'san usaurokʉ wakʉ pe? Apʉne pʉra ɨyewan kon epe'tɨsa' apaino kuru enpa'ka auya'nokon mɨrɨ anta kon yai. ");
INSERT INTO akeNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Wakʉ ka'pon uya wakʉ ton enpa'ka mɨrɨ wakʉ usentɨsa' tʉyau, mɨrɨ awonsi'kɨ ɨri ka'pon uya ɨri enpa'ka mɨrɨ ɨri usentɨsa' tʉyau. ");
INSERT INTO akeNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Serɨ ekama uya ɨpɨ'nokon, Papa uya ka'pon amʉ' aimenkato' oton tanporon nɨ tʉusenuminkai' pʉra rɨ to' usauro'sa' rʉ'pʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Wakʉ amaimu kon winɨ ayanʉnto' oton kon, ɨri amaimu kon winɨ ɨyeno'mato' oton kon,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mɨrɨ a'tai, Pari'si amʉ' mɨrɨ awonsi'kɨ Main pɨ' enupanin nan uya ta'pʉ Sises pɨ', “Ti'sa, eke Papa tʉrawasooi ɨi'tuto' ipɨkɨrɨ kupʉ auya ɨnenpai ina man,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","To' maimu eikʉ'pʉ iya, “Ɨri ton mɨrɨ awonsi'kɨ iyemari'masa' ekumankanin nan ka'pon amʉ' uya eke Papa tʉrawasooi i'tuto' tʉuya'nokon ipɨkɨrɨ ekama'po. Ikupʉ uya pen e'tane Isona, pu'kena' pɨ' i'tuto' ipɨ' rʉ'pʉ rɨken kupʉ uya. ");
INSERT INTO akeNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Apʉne pʉra Isona esi'pʉ osorʉwau wʉi mɨrɨ awonsi'kɨ osorʉwau ewarupɨ nɨrɨ eke moro' ewan yau. Mɨrɨ na'ne' kasa, Ka'pon, Papa winon uko'manto' oton osorʉwau wʉi mɨrɨ awonsi'kɨ osorʉwau ewarupɨ non ewan yau. ");
INSERT INTO akeNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ka'pon amʉ' Ninipa pon kon e'mʉ'sa'kato' oton eseru aimenka weyu a'tai serɨ a'taino kon pokon pe to' eno'ma pe; apʉne pʉra to' era'tɨ'pʉ tʉmakooi kon apai Isona uya itekare ekama pɨ'. Serɨ pe eke Isona entaino man serɨ yau. ");
INSERT INTO akeNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kwin, wʉi enu uye'to' kamisi winon e'mʉ'sa'kato' oton eseru aimenka weyu a'tai serɨ a'taino kon pokon pe to' eno'ma pe; apʉne pʉra iye'sa' wenai non u'matʉ apai Saraman pu'ketʉ etase'na. Serɨ pe eke Saraman entaino man serɨ yau,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Makoi a'kwarʉ epa'kasa' a'tai ka'pon apai, itɨ mɨrɨ tʉ'kenan pata ya'. Tereutato' yau warinpa pɨ', mɨrɨpan eporo iya pʉra iyesi. ");
INSERT INTO akeNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Mɨrɨ a'tai, ‘Enna'po serɨ ɨutɨ unnɨmɨ'pʉ ta',’ ta iya. Iye'sa' a'tai, eporo iya itawon pʉra, wakʉ pe akorokasa' pe mɨrɨ awonsi'kɨ ikonekasa' pe. ");
INSERT INTO akeNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Mɨrɨ a'tai, itɨ 7 kaisaron kon a'kwarʉ ton ɨri ton kuru tentaino kon nepʉ iya ta'kɨrɨ, mɨrɨpan kon ewomʉ, to' uko'mamʉ mɨrɨ yau. Mɨrɨ a'tai, pʉse rɨ ka'pon esi mɨrɨ ɨri pe kuru wapiya tesi'pʉ entai. Mɨrɨ na'ne' kasa, ɨmɨrɨ'nokon ɨri pe nʉko'manyai'ne' nan serɨ a'taino kon e'to' oton,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Anpisin auro'ka pɨ' Sises esi koro'tau rɨ marɨ, isan mɨrɨ awonsi'kɨ iyakon non e'soto'pɨ'sa' esi'pʉ pʉroroi po. Iya'kɨrɨ asauro'pai to' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ka'pon uya ipana'tɨ'pʉ, “Asan mɨrɨ awonsi'kɨ ayakon non e'soto'pɨ'sa' man pʉroroi po. Ayauro'kapai to' esi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Eikʉ'pʉ iya, “Ɨnʉ' si usan? Ɨnʉ' yan si uyakon non?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tʉpoitorʉ ton enusimai'ma ta'pʉ iya, “Pʉsamo nin usanon mɨrɨ awonsi'kɨ uyakon non. ");
INSERT INTO akeNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Apʉne pʉra ɨnʉ' rɨ ukʉipʉnʉ, Epʉn pon e'to' i'se ku'nin esi mɨrɨ, uyakon pe, uparusi pe, mɨrɨ awonsi'kɨ usan pe,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mɨrɨ wʉi a'tai si, Sises epa'ka'pʉ ɨutɨ tapai, mɨrɨpan utɨsa' ereuta'pʉ parau ku'pɨri e'pi po. ");
INSERT INTO akeNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tu'ke kuru rɨ anpisin pe ka'pon amʉ' esi pɨ' tʉwoi, kanau ya' tekanwa'tɨi' iyereuta'pʉ ka'pon amʉ' e'tane a'mun po. ");
INSERT INTO akeNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mɨrɨ a'tai, tu'kan pɨ' rɨ to' auro'ka'pʉ iya panton yai. “Umɨ pɨ' te'sen utɨ'pʉ kiyari ye' pɨnse'na tʉpa'karakai'. ");
INSERT INTO akeNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ipa'karaka iya koro'tau, tʉron nɨ ton uta'pokʉ'pʉ asanta ta'. Toron amʉ' uyee'pʉ, mɨrɨpan kon uya ɨku'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tʉron nɨ uta'pokʉ'pʉ tɨ' pe te'sen ya' eke pe pʉra te'sen non ya'. Iya'ta'pʉ inke pʉra, apʉne pʉra i'nau pʉra non esi ke. ");
INSERT INTO akeNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","E'tane wʉi enu enu'sa' a'tai, a'ne' pe ipuru'pʉ iya, mɨrɨpan aipʉta'pʉ apʉne pʉra imi' utɨpɨ'sa' pʉra iyesi wenai. ");
INSERT INTO akeNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tʉron nɨ ton uta'pokʉ'pʉ tikʉkenan nʉ'ta', mɨrɨpan ɨmɨ'nɨ'ta a'ta uya ɨwɨtanʉkʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mɨrɨ e'tane rɨ, tʉron nɨ ton uta'pokʉ'pʉ wakʉ non ya', mɨrɨpan epeta'pʉ 100 kaisarɨ rɨ, 60 mɨrɨ pe pʉra 30 kaisarɨ rɨ ite'kwa ipɨmɨ'pʉ entai rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kʉrɨ rɨ tʉpana ke na'ne' tɨwɨ netai,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ipoitorʉ ton uyee'pʉ ipiya' ekama'pose'na, “Ɨ'rɨ pe iyesi pɨ' ka'pon amʉ' auro'ka auya panton yai?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","To' eikʉ'pʉ iya, “Ɨnʉ' ni'tunʉ pen nɨ ama'aino Papa e'to' esa' wannɨ pe i'tu kon pa ɨyena'nokon itʉsa', e'tane to' ena' itʉsa' pʉra iyesi. ");
INSERT INTO akeNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ɨnʉ' rɨ itesa' pe te'sen repa mɨrɨ miyarɨ rɨ, mɨrɨpan e'to' pe eke pe itesa' pe. Ɨnʉ' rɨ ɨ'rɨ esa' pen nɨ enapai imo'ka mɨrɨ itenawon nʉ'kwɨ rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Mɨrɨ pɨ' to' auro'ka uya mɨrɨ panton yai: “Ennin pe rɨ to' e'tane, to' uya ene pʉra iyesi pɨ'; etanin pe rɨ to' e'tane, to' uya eta mɨrɨ pe pʉra ito'ka'nʉkʉ pʉra iyesi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Pu'kena' Aisaya nekama'pʉ uta'ku'tɨsa' to' pɨ': “‘Eta pɨ' rɨ ɨwe'to' oton e'tane, ito'ka'nʉkʉ auya pʉra iye'to' oton; ene pɨ' rɨ miyarɨ rɨ ɨwe'to' oton e'tane, ento' auya oton pen. ");
INSERT INTO akeNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Pʉsamoro ka'pon amʉ' ewan enasa' sa'man pe; to' uya eta pʉra rɨ iyesi tʉpana kon ke, tenu kon a'kopɨ'sa' to' uya, tenu kon ke to' uya ene nesii'no, mɨrɨ awonsi'kɨ tʉpana kon ke to' netai'no, tewan kon ke to' nʉto'ka'nʉkʉi'no, to' nera'tɨi'no, mɨrɨpan kon sepi'tɨi'no,’ tawon. ");
INSERT INTO akeNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","E'tane wakʉ pe ɨyenu kon esi mɨrɨ, apʉne pʉra ene iya pɨ', mɨrɨ awonsi'kɨ apana kon eta iya pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","I'napairon ekama uya ɨpɨ'nokon, tu'kan kon nɨ pu'kena' amʉ' mɨrɨ awonsi'kɨ ipokena' ton ka'pon amʉ' esi'pʉ menyatʉi'ne' ɨnenpai e'tane, to' uya ene'pʉ pen; mɨrɨ awonsi'kɨ metayatʉi'ne' ɨnetapai e'tane, to' uya eta'pʉ pen,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Etatɨ' ɨ'rɨ ta e'kwa pe tʉpa'karakai' te'pɨnsen pantomʉ esi tukai': ");
INSERT INTO akeNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ɨnʉ' uya rɨ itekare eta a'tai Papa e'to' esa' wannɨ pe pɨ', e'tane ito'ka'nʉkʉ iya pʉra iyesi, Makoi uyepʉ itewan ya' ipa'karakasa' mo'kase'na. Serɨ esi ite' ipa'karakasa' asanta ta'. ");
INSERT INTO akeNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kʉrɨ rɨ ite' uta'po'sa' na'ne' tɨ' pona kasa esi ka'pon Main etanin nʉ'pʉ, mɨrɨpan uya inke pʉra anʉmʉ'pʉ pori' pe esii'ma. ");
INSERT INTO akeNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","E'tane imi' pʉra iyesi wenai, inke pʉra kuru itano'ma. Manenpanin mɨrɨ pe pʉra kota'manin uye'sa' a'tai Main wenai, inke pʉra kuru ita'mo'ka. ");
INSERT INTO akeNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kʉrɨ rɨ ite' ita'po'sa' rʉ'pʉ tikʉkenan nʉ'ta' esi mɨrɨ ka'pon Main etanin nʉ'pʉ, e'tane tʉusewankamasen wakʉ pe ɨko'manpai tesi pɨ', mɨrɨ awonsi'kɨ imaminke' pe te'to' pɨ' tʉusenku'tɨsen. Mɨrɨ uya ɨwɨtanʉkʉ, tepetasen pe pʉra ikupʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","E'tane kʉrɨ rɨ ite' ita'po'sa' rʉ'pʉ wakʉ non ya' esi ka'pon Main etanin mɨrɨ awonsi'kɨ ito'ka'nʉ'nin nɨrɨ, mɨrɨpan epeta 100 kaisa rɨ'ne rɨ, 60 kaisa rɨ'ne rɨ, mɨrɨ pe pʉra 30 kaisa rɨ'ne rɨ ite'kwa ipa'karakasa' rʉ'pʉ entai,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Sises uya tʉron nɨ panton ekama'pʉ ka'pon amʉ' pɨ', “Papa e'to' esa' wannɨ pe esi ka'pon tʉpa'karakai' wakʉ kiyari ye' pɨnnin nʉ'pʉ tʉmainarʉ yau kasa. ");
INSERT INTO akeNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ewarupɨ nau, kʉrɨ rɨ mɨrɨ awonsi'kɨ ipoitorʉ ton e'nʉnsa' e'tane, iteyaton uyee'pʉ, mɨrɨpan uya wana' e' pɨmɨ'pʉ mɨrɨ rɨ umɨ yau, mɨrɨpan utɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Emennʉ'pʉ rɨ, kiyari ye' a'ta'pʉ epetan pɨ' iye'sara'tɨ'pʉ e'tane, ipoitorʉ ton uya wana' e' a'tasa' ene'pʉ kiyari ye' koro'tau. ");
INSERT INTO akeNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ipoitorʉ ton utɨ'pʉ tepuru kon piya', mɨrɨpan kon uya, ‘Ina epuru, wakʉ sa'ne kiyari ye' pɨntai ina ko, ina apiyontɨ'pʉ auya awɨrɨ rɨ, e'tane nai awon wana' e' a'tasa'?’ ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“To' epuru uya nin si, ‘Uyeyaton uya rɨ ipɨnsa' pe iyesi mɨrɨ,’ ta'pʉ to' pɨ'. “‘Wana' ken pe' nai' ina utɨ i'se me'an?’ ta'pʉ ipoitorʉ ton uya. ");
INSERT INTO akeNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“E'tane, ‘Kane, wana' na auya'nokon koro'tau, iya'tai pʉra kiyari ye' kanan na auya'nokon esi,’ ta'pʉ to' epuru uya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","‘Tɨwɨ asa'rɨ rɨ nʉsemo'kai iteperu akʉ'pʉsa' anʉmʉ weyu e'seporo pona rɨ. Mɨrɨ a'tai, anʉnnin nan apiyontɨto' pe uya, wapiya kuru wana' nato' pe to' uya, mɨrɨ awonsi'kɨ to' uya auronpɨ'to' pe iyepo'tɨpɨ'to' pe, mɨrɨ tʉpo nin si to' uya a'nai' i'kwɨ'pɨ'to' pe, mɨrɨpan amʉranʉ'to' pe to' uya ui'kiyari iwʉ' ta',’ ta'pʉ itepuru uya tʉpoitorʉ ton pɨ',” ta'pʉ Sises uya anpisin ka'pon amʉ' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tʉron nɨ panton ekama'pʉ Sises uya ka'pon amʉ' pɨ', “Papa e'to' esa' wannɨ pe esi kiyari ye' mosta' itese' ena'pɨ, ka'pon nʉpɨmɨnʉ tʉmainarʉ yau kasa. ");
INSERT INTO akeNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mɨrɨ ena'pɨ esi aiko ton kuru tʉron nɨ ena'pɨ pokon pe i'tu a'tai, e'tane eke pe isemo'ka tʉron kon umɨ yau te'sen kiyari ye' entai, mɨrɨpan usemo'ka eke yʉi pe, toron amʉ' rɨ esi ipanta po'ne,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Mɨrɨ awonsi'kɨ tʉron nɨ kanan panton ekama'pʉ Sises uya, “Papa e'to' esa' wannɨ pe esi pʉrowa a'sarutanʉ'nin kasa, uri'san nanʉmʉnʉ, mɨrɨpan uya pʉrowa pokon pe eke pe iki'ma, tanporo ipun yau iyena pʉ'kʉ pona,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Sises uya tanporo serɨ ton ekama'pʉ ka'pon amʉ' anpisin ton pɨ' panton yai; ɨ'rɨ ke rɨ panton yai pʉra to' auro'ka iya pʉra iye'pɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Serɨ kupʉ'pʉ iya, pena rɨ Papa nekama'pʉ pu'kena' yai uta'ku'tɨto' pe: “Panton yai ka'pon amʉ' auro'kato' uya oton, non ekoneka a'tai rɨ iye'so'nansa' rʉ'pʉ ekamato' uya oton,” tawon. ");
INSERT INTO akeNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mɨrɨpan uya anpisin ka'pon amʉ' nɨmɨ'pʉ, mɨrɨpan utɨ'pʉ itau te'to' ɨutɨ ta'. Ipoitorʉ ton utɨ'pʉ iya'kɨrɨ, mɨrɨpan kon uya, “Apʉne, ɨ'rɨ ta e'kwa pe wana' umɨ yawon esi tukai' ekama',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Sises uya to' eikʉ'pʉ, “Kʉrɨ wakʉ itena'pɨ pɨnnin nʉ'pʉ tʉpa'karakai' esi Ka'pon, Papa winon. ");
INSERT INTO akeNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Umɨ esi ka'pon amʉ' serɨ non po te'san, mɨrɨ awonsi'kɨ wakʉ kiyari ye' esi esa' wannɨ pe e'nɨ munkɨ amʉ'; wana' esi Makoi munkɨ amʉ' ekamanin pe, ");
INSERT INTO akeNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","mɨrɨ awonsi'kɨ eyaton, wana' pɨnnin nʉ'pʉ esi Makoi. Kiyari akʉ'pʉsa' anʉmʉ esi non weyu u'ma'sa' a'taino, kiyari anʉnnin nan esi inserʉ amʉ'. ");
INSERT INTO akeNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Wana' na mɨrɨ awonsi'kɨ ipo'tɨ kasa, mɨrɨ kasa si iye'to' oton pata weyu u'ma'sa' a'tai. ");
INSERT INTO akeNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ka'pon, Papa winon uya tinserʉʉi ton enno'to' oton serɨ non pona, mɨrɨpan kon uya ɨri ku'nin nʉ'san mɨrɨ awonsi'kɨ tʉtonpa kon e'makoima emapu'tɨnin nʉ'san amʉranʉ'to' oton Papa pata'se' yapai, ");
INSERT INTO akeNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","mɨrɨpan kon eno'mato' to' uya oton apo' ya'. Mɨrɨ yau, to' ukaranto' oton, mɨrɨ awonsi'kɨ tʉyɨ kon kɨtɨtɨi'mato' oton to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","E'tane ipokena' ton e'wei'tɨto' oton wʉi enu kasa tʉkʉipʉnʉ kon e'to' esa' wannɨ pe yau. Kʉrɨ rɨ tʉpana ke na'ne' tɨwɨ netai,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Miyarɨ rɨ ka'pon amʉ' enupa'pʉ Sises uya, “Papa e'to' esa' wannɨ pe esi i'nʉnkena' mamin umɨ yau onansa' te'sen kasa. Mɨrɨpan eposa' ka'pon uya a'tai, iu'na'tɨkapʉ iya kanan, mɨrɨpan esi pori' pe, mɨrɨpan uya tanporo timamin kʉrʉpo'poma, mɨrɨpan epe'pʉ ke mɨrɨ non e'ma iya. ");
INSERT INTO akeNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Papa e'to' esa' wannɨ pe esi epe'kena' mokon pun tʉne'manʉ ton warinpa kʉrʉpo'po pokon uya na'ne' kasa. ");
INSERT INTO akeNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Mɨrɨpan eposa' tʉuya a'tai, itɨ tanporo timamin kʉrʉpo'pomai', mɨrɨpan epe'pʉ pʉrata ke mɨrɨ mokon pun e'mato' pe tʉuya. ");
INSERT INTO akeNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Se kasa kanan Papa e'to' esa' wannɨ pe esi punwe esi na'ne' kasa ka'pon amʉ' nʉtʉrʉnʉ parau ku'pɨri ka', mɨrɨpan kon uya ɨ'si'tau rɨ moro' amʉ' a'si. ");
INSERT INTO akeNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Punwe epe'tɨsa' a'tai, to' uya ipi'sikʉ makʉi'. Tereutai', tansan pe te'san menkato' pe tʉuya'nokon pa'siki'ti ya', mɨrɨ awonsi'kɨ tansan pen ma'kɨrɨi'ma. ");
INSERT INTO akeNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Serɨ kasa si iye'to' oton pata weyu u'ma'sa' a'tai. Inserʉ amʉ' uye'to' oton, mɨrɨpan kon uya ɨri ton ka'pon amʉ' menkato' oton ipokena' ton piyapai, ");
INSERT INTO akeNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","mɨrɨpan kon uya ɨri ton ka'pon amʉ' eno'mato' oton apo' ya'. To' ukaranto' oton, mɨrɨ awonsi'kɨ tʉyɨ kon kɨtɨtɨi'mato' oton to' uya mɨrɨ yau,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Usaurokʉine' ipɨ' pe' mʉto'ka'nʉ'tʉu?” ta'pʉ Sises uya tʉpoitorʉ ton pɨ'. Mɨrɨ pɨ', “Ewai', ina uya ito'ka'nʉ'sa' man,” ta'pʉ ipoitorʉ ton uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Mɨrɨ pɨ' ta'pʉ iya, “Tanporon kon Main pɨ' enupanin usenupasa' Papa e'to' esa' wannɨ pe pɨ' esi mɨrɨ, ka'pon tiwʉ' tawon emenna' ton mɨrɨ awonsi'kɨ penaro' ton timamin enpa'kapɨ'nin kasa,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Panton amʉ' i'ma'kasa' tʉuya a'tai, Sises utama'pʉ mɨrɨ apai. ");
INSERT INTO akeNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Mɨrɨpan utɨ'pʉ tʉpata'se' ya'. Ka'pon amʉ' enupa pɨ' iye'sara'tɨ'pʉ to' usenupato' iwʉ' tau. Mɨrɨpan kon usewansiuka'pʉ. “Nai yau si tʉpu'ketʉ eporo'pʉ iya tʉusauro'to' pe mɨrɨ awonsi'kɨ tʉpana'pano eke Papa tʉrawasooi ku'nin pe te'to' pe?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“Kiya'pinta mu pen pe' pʉse rɨ? Meri pen pe' isan ese', mɨrɨ awonsi'kɨ Isens, Isose', Saiman, mɨrɨ awonsi'kɨ Isutas pokon pe' yakon non pen? ");
INSERT INTO akeNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mɨrɨ awonsi'kɨ tanporo pʉra pe' iparusi ton nai upiyau'nokon? Nai yau ken si serɨ ton epopɨtʉ'pʉ iya?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Mɨrɨpan kon ɨkɨnʉmʉ'pʉ ipɨ', e'tane Sises uya to' maimu eikʉ'pʉ, “Ipata'se' yau rɨken mɨrɨ awonsi'kɨ itonpa ton uya pu'kena' nama pʉra iyesi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tu'ke eke Papa tʉrawasooi kupʉ Sises uya pʉra iyesi'pʉ mɨrɨ yau, apʉne pʉra apurɨto' to' uya pʉra iyesi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mɨrɨ a'tai, kopʉna Era' uya ka'pon amʉ' nekamanʉ eta'pʉ mɨrɨ kupʉ Sises uya tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Mɨrɨpan uya ta'pʉ ka'pon amʉ' tʉpiyawon kon pɨ', “Isaan Pa'tes kʉrɨ rɨ. Iye'mʉ'sa'kasa' terikʉ'pʉ apai; mɨrɨ wenai, eke Papa tʉrawasooi kupʉ iya mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Era' uya Isaan a'sisa' mɨrɨpan auronpɨ'sa' tʉsa' pariki'si ta' esi'pʉ, Eratiyas, Piri' takon no'pʉ wenai, ");
INSERT INTO akeNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","apʉne pʉra Isaan uya ta esi'pʉ ipɨ': “Main awɨrɨ ɨwesi pe pʉra iyesi kʉrɨ rɨ anʉnsa' auya na'ne',” ta. ");
INSERT INTO akeNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Era' esi'pʉ Isaan ɨnwɨpai, e'tane iyenari'nʉmʉ'pʉ ka'pon amʉ' pɨ', apʉne pʉra Isaan i'tu to' uya pɨ' pu'kena' pe. ");
INSERT INTO akeNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Era' uya tentu'pʉ weyu rʉ'pʉ kupʉ esi'pʉ iyenta'nato' mɨrɨ awonsi'kɨ Eratiyas mʉre umanumʉ'pʉ to' iwano' pe. Serɨ uya Era' kupʉ'pʉ ipan pe rɨ pori' pe, ");
INSERT INTO akeNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","mɨrɨ awonsi'kɨ, “Ɨ'rɨ rɨ ekama'po auya a'tai, ɨrepa uya kuru rɨ mɨrɨ,” tukai' isaurokʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Isan uya imaimu'tɨ'pʉ mɨrɨ ekama'pokɨ tukai', mɨrɨpan uya, “Isaan Pa'tes i'pai rʉ'pʉ ke urepakɨ serɨ yau parapi po,” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kin upokoita'pʉ tʉusaurokʉ'pʉ pɨ' ipan pe, e'tane ikupʉ uya kuru mɨrɨ tasa' tʉuya rʉ'pʉ pɨ' enta'nai' tʉnkɨ'ma'san pana yai rɨ ikupʉ iya rɨ esi'pʉ, mɨrɨpan uya tʉsoisaai amʉ' apiyo'ma'pʉ inesakʉ'pʉ ku'to' pe to' uya, ");
INSERT INTO akeNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","mɨrɨpan kon uya Isaan i'pairʉka'pʉ pariki'si tau. ");
INSERT INTO akeNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","I'pai rʉ'pʉ nee'pʉ to' uya parapi po, mɨrɨpan kon uya itʉrʉ'pʉ uri'san ena', mɨrɨpan arɨ'pʉ iya tʉsan ena'. ");
INSERT INTO akeNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Isaan poitorʉ rʉ'san uyee'pʉ, mɨrɨpan kon uya itekepu arɨ'pʉ iu'na'tɨto' pe tʉuya'nokon, mɨrɨpan kon utɨ'pʉ Sises pana'tɨi'. ");
INSERT INTO akeNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iye'ku'sa' rʉ'pʉ etasa' tʉuya a'tai, Sises ekanwa'tɨ'pʉ kanau ya', mɨrɨpan kon utɨ'pʉ tʉpoitorʉ ton pokon pe tʉ'kena'pɨ ya'. Tu'kan kon nɨ ka'pon amʉ' uya serɨ eta'pʉ, mɨrɨpan kon utɨ'pʉ tʉ'ta kon po Sises pɨkɨrɨ pata ton apai'ne. ");
INSERT INTO akeNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sises ekanwakasa' uya tu'ke anpisin pe ka'pon amʉ' ensa' a'tai, ipan pe rɨ to' pɨ' isentu'ma'pʉ, mɨrɨpan uya rɨ to' koro'tau takuru'ke'ne te'san epi'tɨpɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ko'mamʉ pe rɨ iyenaka'tane, ipoitorʉ ton uyee'pʉ ipiya', mɨrɨpan kon uya ta'pʉ ipɨ', “Ɨnnon sa'ne serɨ pata ko, mɨrɨ awonsi'kɨ pata kanan uko'manka'sa'. Ka'pon amʉ' ipana'tɨ' tiwano' kon pe ti'kiyari kon epose'na to' utɨto' pe eke iwa ton pata pona'ne,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Sises uya ta'pʉ to' pɨ', “To' kʉsenno'tʉu. To' a're'tɨtɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“Ina piyau 5 kaisaron nɨken itekiino pʉreti mɨrɨ awonsi'kɨ asa'ron kon nʉ'kwɨ moro' amʉ' esi,” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Sises uya ta'pʉ to' pɨ', “Pʉreti mɨrɨ awonsi'kɨ moro' amʉ' ine'tɨ' uyena',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ka'pon amʉ' pɨ', “Ereutapɨ'tɨ' wana' pona'ne,” ta'pʉ iya. Mɨrɨ tʉpo, 5 kaisaron itekiino pʉreti mɨrɨ awonsi'kɨ moro' amʉ' anʉmʉ'pʉ iya, mɨrɨpan uya tenu anʉmʉ'pʉ ka' winɨkʉi', mɨrɨpan uya pʉreti, moro' amʉ' i'kwɨ'pɨtʉi'ma tenki ta'pʉ Papa pɨ'. Mɨrɨ tʉpo, itʉrʉ'pʉ iya tʉpoitorʉ ton ena', mɨrɨpan ekamʉ'pʉ to' uya ka'pon amʉ' ena'. ");
INSERT INTO akeNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tanporon kon nɨ ka'pon amʉ' enta'na'pʉ ta'wetapɨ'se, mɨrɨ awonsi'kɨ ipoitorʉ ton uya kiyari punu'pɨ e'nonkasa' ke 12 kaisaron pa'siki'ti arʉ'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mɨrɨ yau si 5,000 e'to' airɨ warawoti'si amʉ' tu'kanoro esi'pʉ. Uri'sami'si amʉ', mʉre amʉ' nɨrɨ esi'pʉ mɨrɨ yau to' pokon pe pʉra to' i'tusa'. ");
INSERT INTO akeNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Inke pʉra tʉpoitorʉ ton ekanwa'tɨto' pe kanau ya' ikuu'pʉ Sises uya, to' utɨto' pe tʉrawɨrɨ iratoi pona, anpisin enno'tane tʉuya. ");
INSERT INTO akeNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","To' ennoko tʉpo, Sises utɨ'pʉ wʉ' pona tikin sarɨ ɨpʉremase'na Papa pɨ'. Pata uko'mansa' a'tai, tikin sarɨ rɨ mɨrɨ yau iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","E'tane ipoitorʉ ton e'to' yau kanau esi'pʉ ɨnnɨ rɨ ite'pi piyapai. Eke pe rɨ sipa'sipa esi'pʉ kanau rɨ tʉwɨpɨ'se, apʉne pʉra a'setun uyee'pʉ ɨsɨ pe to' winɨkʉi'. ");
INSERT INTO akeNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Awanakʉi' kuru, pata emakʉ wapiya, Sises epa'ka'pʉ tʉpoitorʉ ton piya'. Parau ku'pɨri po itɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Parau ku'pɨri po iyepʉ ene tʉuya'nokon a'tai, ipan pe rɨ to' etʉipɨtʉ'pʉ. “A'kwarʉ'pʉ rɨ kʉrɨ rɨ!” tukai' to' ukɨ'pɨ'nʉmʉ'pʉ tetʉipɨtʉ kon pe. ");
INSERT INTO akeNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Sises uya inke pʉra rɨ to' pɨ' ta'pʉ, “Meruntɨ pe e'tɨ'! Urɨ rɨ kʉrɨ rɨ! Ketʉipɨ'tʉu!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pi'ta uya ta'pʉ, “Uyepuru, ɨmɨrɨ pe iyesi yau, ukɨ'makɨ ɨpiya' utɨto' pe tuna pʉro'po!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Sises uya, “Ɨsi'kɨ si upiya'!” ta'pʉ ipɨ'. Mɨrɨ pɨ' Pi'ta ekanwaka'pʉ, mɨrɨpan utɨ'pʉ tuna pʉro'po Sises piya'. ");
INSERT INTO akeNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","E'tane mɨrɨ a'tai, Pi'ta uya eke rɨ sipa'sipa, a'setun nɨrɨ ene'pʉ. Mɨrɨ pɨ' iyenari'nʉmʉ'pʉ, mɨrɨpan e'sara'tɨ'pʉ e'sʉnkan pɨ' tuna ka', mɨrɨpan ukɨ'pɨ'nʉmʉ'pʉ, “Uyepuru, upika'tɨ'!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Mɨrɨ a'tai, inke pʉra rɨ Sises uya temiyatʉ ɨnka'pʉ a'sise'na, mɨrɨpan uya ta'pʉ Pi'ta pɨ', “Aiko pe kuru anapurɨnʉ man! Ɨ'rɨ pe iyesi pɨ' ikasima'pʉ auya?” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kanau ya' to' ekanwa'tɨsa' a'tai rɨ, a'setun ereuta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kamoro nin si kanau yawon kon uya apurɨpɨtʉ'pʉ mɨrɨ, “I'napairɨ rɨ Papa Mumu pe ɨwesi,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","To' ɨ'kwɨrɨ'sa' a'tai, to' e'te'ka'pʉ Kenesare' airɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ka'pon amʉ' mɨrɨ yau te'san uya Sises to'ka'nʉ'sa' a'tai, to' uya si tʉmaimu kon enno'pɨtʉ'pʉ a'ko pa'nan ka'pon amʉ' ena', mɨrɨpan kon uya si tanporo takuru'kena' nan nee'pʉ Sises piya'. ");
INSERT INTO akeNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ipan pe Sises pawana'tɨ'pʉ to' uya, “Tɨwɨ takuru'kena' nan ka'pon amʉ' ɨpon e'pi a'pɨ'pɨtʉi,” ta'pʉ to' uya, mɨrɨpan tanporo kon a'pɨ'pɨ'nin nʉ'san usepi'tɨpɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mɨrɨ a'tai, Pari'si amʉ' mɨrɨ awonsi'kɨ Main pɨ' enupanin nan tonpa ton utɨ'pʉ Sises piya' Surusiran poi, mɨrɨpan kon uya, ");
INSERT INTO akeNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ɨ'rɨ pe iyesi pɨ' ɨpoitorʉ ton uya ina epuru ton eseru rʉ'pʉ i'kwɨtʉ? Temiyatʉ kon korʉka to' uya pʉra iyesi tenta'na kon rawɨrɨ,” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Sises uya to' maimu eikʉ'pʉ, “Ɨ'rɨ pe ken iyesi pɨ' Papa Maimu i'kwɨtʉ auya'nokon, ɨyeseru kon awɨrɨ ɨwesii'ma'nokon? ");
INSERT INTO akeNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Apʉne pʉra Papa uya, ‘Asanon kon inamatɨ',’ tasa', mɨrɨ awonsi'kɨ, ‘Ɨnʉ' rɨ tʉsanon pa'nʉ'nin wɨto' pe kuru rɨ iyesi,’ tasa'. ");
INSERT INTO akeNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","E'tane ta auya'nokon, ka'pon uya rɨ tʉkʉipʉnʉ pɨ' mɨrɨ pe pʉra tʉsan pɨ', ‘Ɨpika'tɨto' pe ɨneporonʉ uwinɨ tʉsa' man Papa ena',’ ta yau, ");
INSERT INTO akeNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","mɨrɨ ke tʉkʉipʉnʉ namato' iya pʉra iyesi. Mɨrɨ kasa si ipʉra Papa maimu kupʉ auya'nokon ɨyeseru kon pɨkɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ɨmɨrɨ'nokon wakʉ pe te'ku'san! I'napai rɨ kuru rɨ Aisaya usaurokʉ'pʉ man ɨpɨ'nokon: ");
INSERT INTO akeNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Pʉsamoro uya unama tʉnta kon ke rɨ, e'tane ɨnnɨ rɨ to' ewan esi upiyapai. ");
INSERT INTO akeNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","To' ɨpʉrema upɨ', ɨ'rɨ epoton kon kasa rɨ, to' usenupato' esi ka'pon amʉ' uya rɨken to' enupa'pʉ ipɨ' to' e'to' yawɨrɨ pe,’ tawon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Anpisin ton kɨ'ma'pʉ Sises uya tʉpiya', mɨrɨpan uya, “Umaimu etatɨ' mɨrɨ awonsi'kɨ ito'ka'nʉ'tɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ɨ'rɨ rɨ ka'pon mʉta ya' nʉtɨyai'ne' uya wakʉ pe pʉra ka'pon kupʉ pen; e'tane ka'pon mʉta yai nepa'kayai'ne' uya kuru wakʉ pe pʉra ka'pon kupʉ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Sises poitorʉ ton uyee'pʉ ipiya', mɨrɨpan kon uya, “Mi'tuyan pe' serɨ pe kuru masaurokʉine' uya Pari'si amʉ' ɨkɨnʉnpa'pʉ?” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","To' eikʉ'pʉ iya, “Tanporon nɨ ite' tʉnpɨmɨ'pʉ pen kuru'kato' oton ukʉipʉnʉ Epʉn po na'ne' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tɨwɨ kamoro itepuru ton nesii, itenu pʉra to' esi mɨrɨ. Tenku'nan uya tenku'nan arɨ a'tai, asa'rɨ rɨ to' uta'mo'ka mɨrɨ akasa' ya',” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pi'ta uya Sises ekama'po'pʉ, “Ɨ'rɨ ta e'kwa pe serɨ panton esi?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Sises uya, “Ito'ka'nʉ'nin nan pe pʉra rɨ marɨ pe' ɨwesi kon mɨrɨ?” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","“Ene auya'nokon pʉra pe' iyesi ɨ'rɨ rɨ mʉta ya' newonyai'ne' utɨ ewan ya', mɨrɨpan epa'ka pun apai? ");
INSERT INTO akeNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","E'tane ɨri main ka'pon mʉta yai nepa'kayai'ne' uyepʉ itewan yapai. Serɨ ton uya ka'pon kupʉ mɨrɨ ɨri pe. ");
INSERT INTO akeNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Apʉne pʉra ka'pon ewan yapai ɨri pɨ' isenuminkato' uyepʉ; e'wɨn, tʉron kon no'pʉ a'kɨrɨ te'sen pe, tʉnmari'ma'pʉ pen nɨ a'kɨrɨ tekumasen pe, ama' e' pe rɨ, kasi ye' pe rɨ, mɨrɨ awonsi'kɨ ɨri pe tʉron kon pɨ' tʉusauro'sen pe. ");
INSERT INTO akeNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Serɨ ton uya ka'pon kupʉ mɨrɨ ɨri pe, temiyatʉ tʉkorʉkai' pʉra iyenta'na uya pen,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Mɨrɨ pata tʉnɨnse, Sises utɨ'pʉ Kiyarari ponsi'kɨ Taya mɨrɨ awonsi'kɨ Saitan itese' ton nono ya'ne. ");
INSERT INTO akeNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mɨrɨ yawon, uri'san, Esuwerʉ pe pʉra te'sen uyee'pʉ ɨkɨ'pɨ'nʉnpɨtʉi'ma Sises piya', “Uyepuru, kin Tepi' pa rʉ'pʉ, upɨ' ɨsentu'ma'! Makoi a'kwarʉ yen pe umʉre esi ekota'man pɨ' man ipan pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","E'tane Sises uya imaimu eikʉ pʉra iyesi pɨ', ipoitorʉ ton uyee'pʉ ipiya' mɨrɨpan kon uya ta'pʉ ipɨ', “Enno'kɨ, apʉne pʉra ɨkɨ'pɨ'nʉnpɨtʉi'ma uye'ma'pʉkapɨtʉ kon pɨ' man,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Sises uya nin si eikʉ'pʉ mɨrɨ, “Papa uya uyenno'sa' serɨ Esuwerʉ amʉ' piya' rɨken, itano'masa' kon karimeru amʉ' kasa te'san piya',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Uri'san uyee'pʉ Sises piya', mɨrɨpan e'sekunka'pʉ ipiyau, mɨrɨpan uya, “Uyepuru, upika'tɨ'!” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Eikʉ'pʉ iya, “Ipoken pʉra iyesi mʉre amʉ' yu pʉreti eno'ma to' ikʉn non pero amʉ' ena',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Ewai', Epuru, e'tane tesa' i'kiyari punu'pɨ uta'po'sa' tepʉrʉ poi pɨ' rɨ tʉuta're'tɨsan kamoro pero amʉ',” ta'pʉ uri'san uya. ");
INSERT INTO akeNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mɨrɨpan pɨ', “Eke pe kuru apurɨto' auya man! Tɨwɨ si ɨnekama'po'pʉ ne'kupʉi,” ta'pʉ Sises uya ipɨ', mɨrɨpan mʉre ena'pʉ wakʉ pe mɨrɨ a'tai rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Mɨrɨ tʉpo, Sises uya mɨrɨ pata nɨmɨ'pʉ; parau ku'pɨri Kiyarari e'pi poro itɨ'pʉ. Wʉ' pona iyenuku'pʉ, mɨrɨpan ereuta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mɨrɨ yau, anpisin pe ka'pon amʉ' uyee'pʉ ipiya', mɨrɨpan kon uya tʉusasan pen mɨrɨ awonsi'kɨ tenku'na' nan nee'pʉ ta'kɨrɨ'nokon; tʉron kon nee'pʉ to' uya ise'mepɨ'sa' kon mɨrɨ awonsi'kɨ tʉusauro'san pen, mɨrɨ awonsi'kɨ tʉron kon nɨ e'ne' pe te'san, mɨrɨpan kon nonkapɨtʉ'pʉ to' uya Sises piya', mɨrɨpan uya tanporo rɨ to' epi'tɨpɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ka'pon amʉ' usewansiuka'pʉ, tʉusauro'san pen ka'pon amʉ' usaurokʉ tetase, tʉron kon ipu'tɨka'sa' kon usepi'tɨsa' tense, tʉusasan pen usarɨ, mɨrɨ awonsi'kɨ tenku'na' nan enasa' ennin pe tense. Mɨrɨ tense Papa apurɨpɨtʉ'pʉ to' uya Esuwerʉ amʉ' ɨpʉremato' ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sises uya tʉpoitorʉ ton kɨ'ma'pʉ tʉpiya', mɨrɨpan uya ta'pʉ, “Pʉsamoro ka'pon amʉ' pɨ' usentu'mayai', apʉne pʉra osorʉwau wʉi upiyau'nokon to' uko'mansa', mɨrɨpan kon enta'nato' ipɨ' pʉra iyesi to' ɨnenno'pai pʉra esi iwan pe, yai to' utɨ esi tʉutɨ kon koro'tau,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Mɨrɨ pɨ' ipoitorʉ ton uya, “Nai yau rɨ eke pe pʉreti eporo ina uya pʉsamoro ka'pon amʉ' a're'tɨto' ike serɨ ɨnnon nɨ pata yau?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Sises uya to' ekama'po'pʉ, “Ɨ'rɨ kaisa rɨ pʉreti nai ɨpiyau'nokon?” tukai'. Mɨrɨ pɨ', “7 pe rɨken mɨrɨ awonsi'kɨ tu'kan kon pen aiko ton moro' amʉ',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Anpisin auro'ka'pʉ iya to' ereutato' pe non pona. ");
INSERT INTO akeNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mɨrɨpan uya 7 kaisaron pʉreti mɨrɨ awonsi'kɨ tu'kan kon pen moro' amʉ' anʉmʉ'pʉ, mɨrɨpan uya tenki ta'pʉ tʉuya rʉ'pʉ pe i'kwɨ'pɨtʉ'pʉ. Tʉpoitorʉ ton ena' itʉpɨtʉ'pʉ iya, mɨrɨpan kon uya ka'pon amʉ' ena' ekamʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tanporo to' enta'na'pʉ ta'wetapɨ'se. Mɨrɨ tʉpo, ipʉ'kʉ rʉ'san e'nonkasa' amʉranʉkʉ'pʉ ipoitorʉ ton uya, 7 kaisaron pa'siki'ti tʉpe'ke'ne. ");
INSERT INTO akeNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kamoro iyenta'nasa' kon tu'kanoro esi'pʉ 4,000 kaisa rɨ, uri'sami'si amʉ' mɨrɨ awonsi'kɨ mʉre amʉ' pokon ti'tui' pʉra. ");
INSERT INTO akeNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Anpisin ka'pon amʉ' ennoko tʉpo, Sises ekanwa'tɨ'pʉ kanau ya' tʉpoitorʉ ton pokon pe, mɨrɨpan kon utɨ'pʉ Makatan itese' pʉ'kʉ pona. ");
INSERT INTO akeNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Pari'si amʉ' mɨrɨ awonsi'kɨ Satu'si amʉ' uyee'pʉ Sises piya' i'tupɨ'se'na ti'tuto' ipɨkɨrɨ Epʉn poino ku'to' pe iya. ");
INSERT INTO akeNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Entakanoma'pʉ iya, “Ko'mamʉ pe kuru pata enasa' a'tai, ‘Tuna uyepʉ pen mɨrɨ, apʉne pʉra isuweyu pe ka' man,’ ta auya'nokon, ");
INSERT INTO akeNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","mɨrɨ awonsi'kɨ awanakʉi', ‘Serɨ pe tuna pokon pe a'setun pe pata esi mɨrɨ, apʉne pʉra isuweyu pe ka' esi mɨrɨ awonsi'kɨ ewarupɨ pe,’ ta auya'nokon. Ka' winɨ rɨ ɨ'rɨ rɨ enpoikanin pe ɨwesi kon, e'tane si pata weyu i'tuto' ipɨ' enpoika auya'nokon pʉra iyesi. ");
INSERT INTO akeNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ɨri ton mɨrɨ awonsi'kɨ iyemari'masa' ekumankanin nan ka'pon amʉ' esi eke Papa tʉrawasooi i'tuto' tʉuya'nokon ipɨkɨrɨ kupʉ uya i'se. Ikupʉ uya pen, e'tane Isona pɨ' i'tuto' ipɨ' rʉ'pʉ na'ne' rɨken kupʉ uya,” ta'pʉ iya. Mɨrɨpan kon tʉnɨnse Sises utɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Parau ku'pɨri ratoi pona to' ɨ'kwɨrɨ'sa' a'tai, pʉreti arɨ to' uya pʉra ipoitorʉ ton upu'tɨkaa'pʉ esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","“Ti'tui' e'tɨ',” ta'pʉ Sises uya to' pɨ', “te'mainanpai' e'tɨ' Pari'si amʉ' mɨrɨ awonsi'kɨ Satu'si amʉ' uya pʉrowa a'sarutanʉ'to' ike namai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","To' usaurokʉ'pʉ tiwano' kon pe, “Apʉne pʉra pʉreti ne'sa' kasa pʉra isaurokʉ mɨrɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","To' usauro'to' i'tu tʉuya pɨ', Sises uya to' ekama'po'pʉ, “Ɨmɨrɨ'nokon aiko rʉ'kwɨ apurɨto' iya ton! Ɨ'rɨ pɨ' ausaurokʉ kon pʉreti pʉra ɨwesi kon pɨ'? ");
INSERT INTO akeNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ito'ka'nʉkʉ auya'nokon pʉra rɨ marɨ pe' iyesi? Ɨyenu kon yau pe' ikupʉ auya'nokon pʉra iyesi 5 kaisaron pʉreti 5,000 kaisaron kon iwano' rʉ'pʉ, mɨrɨ awonsi'kɨ pa'siki'ti ton pe'tɨpɨtʉ'pʉ auya'nokon? ");
INSERT INTO akeNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Mɨrɨ pe pʉra, 7 kaisaron pʉreti 4,000 kaisaron kon iwano', ɨ'rɨ kaisa rɨ pa'siki'ti mamʉranʉ'ta'tʉi? ");
INSERT INTO akeNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nai pe ito'ka'nʉkʉ auya'nokon pʉra iyesi pʉreti pɨ' ayauro'ka uya 'nokon pen tukai'? E'tane Pari'si amʉ' mɨrɨ awonsi'kɨ Satu'si amʉ' uya pʉreti a'sarutanʉ'to' namai' ɨye'mainanpa kon pa,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Mɨrɨ a'tai, to' uya ito'ka'nʉkʉ'pʉ pʉrowa a'sarutanʉ'nin itisu pen nɨ pɨ' kenʉ' Sises usaurokʉ'pʉ tukai', e'tane Pari'si amʉ' mɨrɨ awonsi'kɨ Satu'si amʉ' uya enupan nɨto' pɨ' kenʉ' tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Sises mɨrɨ awonsi'kɨ ipoitorʉ ton uya Sisariya Piri'pai nono eposa' a'tai, tʉpoitorʉ ton ekama'po'pʉ iya, “Ɨnʉ' pe Ka'pon, Papa winon esi tukai' ka'pon amʉ' nʉsauro'an?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","To' uya entakanoma'pʉ, “Tʉron kon uya Isaan Pa'tes ta ɨpɨ'; tʉron kon uya kanan pu'kena' Iraisa ta; tʉron kon uya rɨ marɨ Iseremaya mɨrɨ pe pʉra tʉron kon pu'kena' amʉ' tonpa ton ta ɨpɨ',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“E'tane si, ɨmɨrɨ'nokon, ɨnʉ' pe ken si esi mʉkayatʉu?” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saiman Pi'ta uya eikʉ'pʉ, “Ɨmɨrɨ kʉrɨ rɨ Kʉrai, nurɨne te'sen Papa Mumu,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Sises uya eikʉ'pʉ, “Pori' rɨ ɨmɨrɨ, Saiman, Isona mu, i'napairon serɨ uye'sa' ka'pon amʉ' winɨ pen e'tane tʉmɨrɨ pe Papa uya ekamasa' ɨpɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ekama uya serɨ, Pi'ta pe ɨyese' esi, Tɨ' ta e'kwa pe. Uso'sii nin si amɨ uya, ɨmɨrɨ tɨ' po, iyeri'sa' kon utɨto' ya' pata mʉra'taai enato' oton pen itentai. ");
INSERT INTO akeNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Papa e'to' esa' wannɨ pe yau kii ke ɨrepa uya; serɨ non po ɨ'rɨ rɨ auronsa' auya a'tai, Papa uya kanan auromʉ mɨrɨ Epʉn po; mɨrɨ awonsi'kɨ serɨ non po ɨ'rɨ rɨ eukasa' auya iyesi a'tai, Papa uya kanan euka mɨrɨ Epʉn po,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mɨrɨpan uya tʉpoitorʉ ton panama'pʉ ɨnʉ' rɨ pana'tɨ to' uya namai' Kʉrai pe iyesi, tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mɨrɨ si'kɨrɨ, Sises uya tʉpoitorʉ ton pɨ' ekama'pʉ Surusiran pona tʉutɨto' oton nɨ, mɨrɨ yau tu'kan yau rɨ itepuru ton uya, Papa ena' use'man nɨto' tʉrawasomanin nan epuru ton mɨrɨ awonsi'kɨ Main pɨ' enupanin nan uya rɨ tʉkota'mato' oton, mɨrɨpan kon uya tʉwɨto' oton, mɨrɨpan te'mʉ'sa'kato' oton itosorʉwano wʉi a'tai tʉuko'manton pe ekama'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pi'ta uya Sises arɨ'pʉ, ɨnnɨ kuru pʉra rɨ tʉron kon ipoitorʉ ton piyapai esereme'se'na. “Mɨrɨ kasa kasaurokʉi! Serɨ kʉse'ku'nin ɨpɨ', uyepuru!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Sises era'tɨ'pʉ Pi'ta winɨkʉi', mɨrɨpan uya, “Atamakɨ, Se'tan!” ta'pʉ. “Uye'ma tau uwa'kʉ'pɨ'nin tɨ' pe me'ai'; ka'pon usenuminkato' kasa ɨusenuminka, Papa usenuminkato' kasa pʉra,” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sises uya tʉpoitorʉ ton pɨ' ta'pʉ, “Ɨnʉ' rɨ upoitorʉ pe e'pai na'ne', tɨwɨ teseru nonkai mɨrɨ awonsi'kɨ tekota'mato' kurusu' anʉmʉi, mɨrɨ awonsi'kɨ upɨkɨrɨ tʉuye'to' pe. ");
INSERT INTO akeNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Apʉne pʉra ɨnʉ' rɨ serɨ yau tʉuko'manto' ɨnnonkapai pʉra na'ne' uya epoto' oton pen nɨ, e'tane ɨnʉ' rɨ serɨ yau tʉuko'manto' nonkanin uya, urɨ wenai, epoto' oton. ");
INSERT INTO akeNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ɨ'rɨ wakʉ esi ka'pon pɨ' serɨ po tanporon nɨ eposa' iya yau ta'kwarʉ nonkai'ma? Mɨrɨ pe pʉra, ɨ'rɨ tʉrʉ iya ta'kwarʉ entakano' pe? ");
INSERT INTO akeNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Apana'tɨ uya 'nokon serɨ; Ka'pon, Papa winon uye'to' oton tʉkʉipʉnʉ meruntɨrʉ mɨrɨ awonsi'kɨ itinserʉʉi ton pokon pe. Mɨrɨ a'tai, to' epe'pʉ ke ka'pon amʉ' e'mato' iya oton to' nʉkupʉ'pʉ pɨkɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","I'napairon kuru ekama uya ɨpɨ'nokon, serɨ yau iye'soto'pɨ'sa' na'ne' nan tonpa ton eri'to' oton pen Ka'pon, Papa winon uyepʉ esa' wannɨ pe te'to' yau ene tʉuya'nokon rawɨrɨ,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","6 kaisa rɨ wʉi tʉpo, Sises uya Pi'ta, Isens, mɨrɨ awonsi'kɨ iyakon Isaan pokon nɨken arɨ'pʉ ta'kɨrɨ wʉ' nakapu pona. ");
INSERT INTO akeNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mɨrɨ yau, tʉron nɨ pe iyena'pʉ, itemʉ' e'wei'tɨ'pʉ wʉi enu kasa, mɨrɨ awonsi'kɨ ipon ena'pʉ aimu'ne, enkena' pe. ");
INSERT INTO akeNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mɨrɨ a'tai kuru si mɨrɨ yau, Mosi' mɨrɨ awonsi'kɨ Iraisa usenpoika'pʉ, mɨrɨpan kon uya Sises auro'ka esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pi'ta uya ta'pʉ Sises pɨ', “Uyepuru! Wakʉ rɨ pan pe serɨ yau ina man! I'se ɨwesi yau, osorʉwau ɨiwʉ' kon amɨ uya mɨrɨ; tikin nɨ ɨiwano' pe, Mosi' iwano' pe, mɨrɨ awonsi'kɨ Iraisa iwano' pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pi'ta usaurokʉ koro'tau, enkena' kapuru' uya to' nɨpontɨ'pʉ. Main kapuru' yawon uya ta'pʉ, “Umu pʉse rɨ, Uni'nʉnkanʉ, ipɨ' pori' pe e'ai' ipan pe; imaimu etatɨ'!” tawon. ");
INSERT INTO akeNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ipoitorʉ ton uya serɨ main etasa' a'tai, to' etʉipɨtʉ'pʉ, mɨrɨpan kon uta'mo'ka'pʉ non pona itemʉ'. ");
INSERT INTO akeNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","E'tane Sises uyee'pʉ to' a'pɨ'se'na, “E'mʉ'sa'katɨ',” ta'pʉ iya, “Ketʉipɨ'tʉu,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tenu kon anʉnsa' to' uya a'tai, ɨnʉ' ene'pʉ to' uya pen nɨ, Sises rɨken ene'pʉ to' uya tikin sarɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Wʉ' ponsi'kɨ ɨu'tɨi'ma rɨ, Sises uya to' panama'pʉ, “Ɨnʉ' pɨ' rɨ ɨnene'pʉ kon kʉsekamatʉu, Ka'pon, Papa winon eri'sa' e'mʉ'sa'kasa' pʉ'kʉ pona rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ipoitorʉ ton uya ekama'po'pʉ, “Ɨ'rɨ pe ken si iyesi pɨ' Main pɨ' enupanin nan uya Iraisa kuru uye'to' oton wapiya ta?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Sises uya to' entakanoma'pʉ, “I'napairɨ rɨ Iraisa uye'to' oton ta to' uya, tanporon nɨ konekai' iyesi'pʉ ya'. ");
INSERT INTO akeNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","E'tane nin si ekama uya ɨpɨ'nokon, Iraisa uye'kaa'pʉ, mɨrɨpan i'tu to' uya pʉra rɨ iyesi'pʉ, e'tane i'se te'to' kon awɨrɨ ɨri eseru kupʉ'pʉ to' uya ipɨ'. Mɨrɨ kasa rɨ marɨ Ka'pon, Papa winon ekota'mato' oton to' enau,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Iraisa pɨ' Sises usaurokʉ a'tai, Isaan Pa'tes pɨ' isaurokʉ tukai' ipoitorʉ ton uya i'tu'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Anpisin ton koro'ta' to' uye'sa' a'tai, ka'pon uyee'pʉ Sises piya', mɨrɨpan e'sekunka'pʉ ipiyau. ");
INSERT INTO akeNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ta'pʉ iya Sises pɨ', “Uyepuru, umu pɨ' ɨsentu'makɨ. Yai itɨpɨtʉ, ipan pe iyekota'ma. Apo' ya', tuna ka' rɨ ita'mo'kapɨ'pɨtʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ɨpoitorʉ ton piya' inee'pʉ uya, e'tane to' uya epi'tɨ poken pʉra iyesi'pʉ,” ta'pʉ iya Sises pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","“Ɨri sɨ! Ɨri ton nɨ, apurɨnin nan pen nɨ serɨ a'taino kon! Ɨ'rɨ pʉ'kʉ pona useta'ka pʉra uko'mamʉ ɨpiyau'nokon? Ɨ'rɨ pʉ'kʉ pona aya'kɨrɨ'nokon esi? Ine'tɨ' upiya'!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Sises uya makoi a'kwarʉ eseremekʉ'pʉ, mɨrɨpan epa'ka'pʉ warawo' mʉre apai. Mɨrɨ a'tai rɨ, isepi'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mɨrɨ a'tai, Sises piya' ipoitorʉ ton uyee'pʉ ama'ai, mɨrɨpan kon uya ekama'po'pʉ, “Ɨ'rɨ pe iyesi pɨ' ina uya enpa'ka pʉra iyesi?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Sises uya to' eikʉ'pʉ, “Apʉne pʉra aiko pe rʉ'kwɨ apurɨto' auya'nokon esi. I'napairon ekama uya ɨpɨ'nokon; aiko rʉ'kwɨ mosta' ena'pɨ kasa apurɨto' auya'nokon esi yau, wʉ' pɨ', ‘Atamakɨ mairɨ!’ tasa' auya'nokon a'tai, itama rɨ. Ɨ'rɨ rɨ kupʉ auya'nokon a'tai, sa'man pe pʉra rɨ iyesi ɨpona'nokon. ");
INSERT INTO akeNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","E'tane serɨ rupɨ epa'ka pʉra iyesi ɨpʉreman mɨrɨ awonsi'kɨ useruman tʉuta're'tɨi' pʉra uya rɨken enpa'ka,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tanporo to' amʉrasa' a'tai Kiyarari pona, Sises uya ta'pʉ to' pɨ', “Ka'pon, Papa winon eparankato' oton ka'pon amʉ' ena'. ");
INSERT INTO akeNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","To' uya iwɨto' oton, mɨrɨ awonsi'kɨ itosorʉwano wʉi a'tai iye'mʉ'sa'kato' oton tʉuko'manto' ya',” ta'pʉ iya, mɨrɨpan poitorʉ ton upokoita'pʉ ipan pe. ");
INSERT INTO akeNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Sises mɨrɨ awonsi'kɨ ipoitorʉ ton uya Ka'paneyan pata eposa' a'tai, Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' ta' te'masen amʉranʉ'nin nan uyee'pʉ Pi'ta piya', mɨrɨpan kon uya ekama'po'pʉ, “Ɨti'saai kon pe' Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' ta' tʉuse'masen?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pi'ta uya to' eikʉ'pʉ, “Ewai', e'manin kʉrɨ rɨ,” ta'pʉ iya. Mɨrɨpan Pi'ta utɨ'pʉ ɨutɨ ta'. Sises usaurokʉ'pʉ wapiya kuru, mɨrɨpan uya Pi'ta ekama'po'pʉ, “Ɨ'rɨ tukai' mɨsenuminkayan Saiman? Ɨnʉ' yan rupɨ winɨpai kin amʉ' uya pʉrata amʉranʉ'to' pe iyesi? Patawon amʉ' mɨrɨ pe pʉra ka'kʉran amʉ' winɨpai katɨ?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pi'ta uya eikʉ'pʉ, “Ka'kʉran amʉ' winɨ,” ta'pʉ iya. “Patawon amʉ' use'mato' pe pʉra iyesi,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","“E'tane pʉsamoro ka'pon amʉ' ɨnɨkɨntanʉ'pai pʉra e'nɨ. Mɨrɨ pɨ', konoi' pɨ' enta parau ku'pɨri ka', mɨrɨpan wapiya kuru anma'pʉ moro' inta nau pʉrata pun eporo auya mɨrɨ, asakɨrɨ'ne wʉi e'tʉrawasoman nɨsa' epe'pʉ airon nɨ, mɨrɨpan ke e'mase'na mɨtɨi' uiwano' pe, mɨrɨ awonsi'kɨ ɨiwano' pe nɨrɨ,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mɨrɨ a'tai, Sises poitorʉ ton uyee'pʉ ekama'poi', “Ɨnʉ' kuru si e'to' oton eke pe Papa e'to' esa' wannɨ pe yau?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Sises uya mʉre rʉ'kwɨ kɨ'ma'pʉ, mɨrɨpan soto'ka'pʉ iya to' koro'tau, ");
INSERT INTO akeNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","mɨrɨpan uya ta'pʉ, “I'napairon ekama uya ɨpɨ'nokon; ɨusensima kon a'tai rɨken mʉre amʉ' pe tenai', ɨyepa'ka kon Papa e'to' esa' wannɨ pe ya'. ");
INSERT INTO akeNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ɨnʉ' rɨ esi mɨ pe te'ku'sen pe pʉra mʉre na'ne' kasa esi mɨrɨ eke pe Papa pona. ");
INSERT INTO akeNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mɨrɨ awonsi'kɨ, ɨnʉ' uya rɨ aiko rʉ'kwɨ mʉre pʉse rɨ warai ereutanʉkʉ a'tai, uyese' yau, uyereutanʉkʉ iya pe rɨ iyesi. ");
INSERT INTO akeNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“E'tane ɨnʉ' uya rɨ pʉsamoro uyapurɨnin nan aiko ton nʉ'kwɨ tonpa e'makoima emapu'tɨsa' yau, wakʉ iwa pe rɨ iyesi kʉrɨ rɨ ka'pon i'mʉ pɨ' eke a'nai' e'pato' ike tɨ' ewa'tɨsa' a'tai, mɨrɨpan eno'mato' pe parau ka' iyaputato' pe. ");
INSERT INTO akeNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ɨsɨ sɨ, ka'pon amʉ' non pon kon, apʉne pʉra ka'pon amʉ' umakoita emapu'tɨ to' uya pɨ'. Mɨrɨ warai ton nɨ e'ku'to' pe iyesi e'tane, ɨsɨ yau kʉrɨ man iye'kupʉ emapu'tɨnin. ");
INSERT INTO akeNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ɨyemiyatʉ mɨrɨ pe pʉra a'ta uya ɨye'makoima emapu'tɨ pe iyesi yau, a'tɨkɨ eno'ma pa; wakʉ iwa pe iyesi itemiyatʉ pʉra mɨrɨ awonsi'kɨ i'ta pʉra esii'ma tɨwɨrɨ rɨ ɨuko'manto' ya' ɨyepa'ka a'tai, tanporo ɨpun eno'ma apo', tɨwɨro' rɨ ya' entai. ");
INSERT INTO akeNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mɨrɨ awonsi'kɨ ɨyenu uya ɨye'makoima emapu'tɨ pe iyesi yau, imo'ka' eno'ma pa; wakʉ iwa pe iyesi tikin nɨ itenu esii'ma tɨwɨrɨ rɨ ɨuko'manto' ya' ɨyepa'ka a'tai, asa'rɨ itenu apo', iya'mu pʉn ya' ɨyeno'ma entai,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Miyarɨ rɨ Sises esi'pʉ usauro'nɨ pɨ', “Pʉsamoro aiko ton nʉ'kwɨ kʉsenpɨ'tʉu. Ekama uya ɨpɨ'nokon, to' inserʉʉi ton esi ukʉipʉnʉ emʉ' ennin nan pe tɨwɨrɨ rɨ Epʉn po. ");
INSERT INTO akeNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Serɨ ta uya ɨpɨ'nokon apʉne pʉra Ka'pon, Papa winon uye'sa' itano'masa' kon pika'tɨi'. ");
INSERT INTO akeNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ɨ'rɨ tukai' mɨsenuminkayan? Ka'pon esi yau 100 kaisaron kon karimeru amʉ' esa' pe, mɨrɨpan kon tonpa utano'masa' yau, 99 pan kon pe' karimeru amʉ' nɨmɨ iya pen wʉ' po itano'masa' rʉ'pʉ warinpase'na tʉutɨto' pe? ");
INSERT INTO akeNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mɨrɨpan eposa' tʉuya yau, i'napairon ekama uya ɨpɨ'nokon; pori' pe kuru iyesi tikin nan itano'masa' rʉ'pʉ karimeru pɨ' 99 pan kon itano'masa' kon pen karimeru amʉ' pɨ' pori' pe tesi entai. ");
INSERT INTO akeNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mɨrɨ na'ne' kasa, ɨkʉipʉnʉ, Epʉn pon esi pʉsamoro aiko ton nʉ'kwɨ uyapurɨnin nan utano'ma i'se pʉra,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Miyarɨ rɨ Sises esi'pʉ tʉpoitorʉ ton auro'ka pɨ', mɨrɨpan uya ta'pʉ, “Ɨri pe ɨtonpa uya ɨku'sa' yau, ɨri inkupʉ'pʉ ekama ta ipɨ', asa'ken esii'ma. Amaimu etasa' iya yau, mɨrɨ nin si ɨtonpa pe ina'posa' auya. ");
INSERT INTO akeNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","E'tane amaimu eta iya pʉra iyesi yau, tikin nɨ mɨrɨ pe pʉra asa'rɨ rɨ ka'pon amʉ' akɨ aya'kɨrɨ auro'kaka'se'na. Pʉsamoro asa'ron kon ka'pon amʉ' esi, ‘auro'ka pɨ' ɨpika'tɨnin nan mɨrɨ awonsi'kɨ ɨri pe ɨwe'sa' esi i'napai rɨ tawon nan pe ipɨ'.’ ");
INSERT INTO akeNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","E'tane to' ɨnetapai pʉra kanan iyesi yau, ekamatɨ' so'si tawon kon pɨ', e'tane ɨnetapai pʉra kanan iyesi yau, inonkatɨ' Papa apurɨnin pen mɨrɨ awonsi'kɨ pʉrata amʉranʉ'nin kasa iye'to' pe. ");
INSERT INTO akeNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“I'napairon ekama uya ɨpɨ'nokon; serɨ non po ɨ'rɨ rɨ auronsa' auya'nokon a'tai, Epʉn po kanan Papa uya auromʉ, mɨrɨ awonsi'kɨ serɨ non po ɨ'rɨ rɨ eukasa' auya'nokon a'tai, Papa uya kanan euka Epʉn po. ");
INSERT INTO akeNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Se kanan ekama uya etatɨ': Asa'rɨ tekonekai' serɨ non po ɨ'rɨ rɨ ɨnekama'ponʉ kon pɨ', ukʉipʉnʉ, Epʉn pon uya rɨ amaimu kon eikʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Asa'ron kon, osorʉwawon kon nʉ'kwɨ rɨ amʉrasa' a'tai, uyese' yau, to' piyau rɨ esi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mɨrɨ a'tai, Pi'ta uyee'pʉ Sises piya' ekama'pose'na, “Uyepuru, ɨ'rɨ kaisa rɨ ite'kwa utonpa e'makoimasa' upɨ' pɨ' usentu'ma? 7 kaisa rɨ ite'kwa pe'?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Sises uya Pi'ta eikʉ'pʉ, “7 kaisa rɨ ite'kwa pen e'tane, 70 kaisa rɨ 7 ite'kwa kuru,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Mɨrɨ a'tai, Sises uya panton ekama'pʉ Papa e'to' esa' wannɨ pe eseru pɨ'. “Se na'ne' kasa Papa e'to' esa' wannɨ pe eseru esi: Kin esi'pʉ ka'pon amʉ' tʉpʉrataai ko'manʉ'pɨ'nin nan winɨ tʉpʉrataai amʉranʉkʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Iyepiya'tɨ koro'tau, ipoitorʉ uya eke kuru rɨ ipʉrataai ko'manʉ'pɨ'nin nʉ'pʉ nee'pʉ ipiya'. ");
INSERT INTO akeNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ipʉrataai pʉra iyesi'pʉ tepuru e'mato' iya ike. Kin uya ta'pʉ, ‘Ikʉrʉpo'pomatɨ', ino'pʉ, imunkɨ amʉ' pokon pe, mɨrɨ awonsi'kɨ itimamin ton nɨ, mɨrɨpan epe'pʉ uya inko'manʉ'pɨtʉ'pʉ e'mato' pe,’ ta'pʉ kin uya. ");
INSERT INTO akeNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Mɨrɨpan poitorʉ uta'mo'ka'pʉ irau tese'mu po tenai', ‘Apʉne parɨ, ɨye'ma uya rɨ mɨrɨ tanporo,’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mɨrɨ wenai, kin usentu'ma'pʉ ipɨ', iye'womasa' rʉ'pʉ rɨ nin si tʉkukai', ennoko'pʉ iya mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“E'tane pʉse rɨ utɨ'pʉ aiko rʉ'kwɨ rɨ nin tʉpʉrataai ko'manʉ'pɨ'nin piya', mɨrɨpan uya ta'sii' i'mʉ pɨ', i'mʉ kʉtʉtʉ'ka'pʉ. ‘Inke pʉra upʉrataai itʉkɨ!’ tai'ma. ");
INSERT INTO akeNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mɨrɨpan nʉ'kwɨ sa'ne uta'mo'ka'pʉ irau temʉ' po, ‘Apʉne sa'ne, ɨye'ma uya rɨ mɨrɨ,’ tai'ma. ");
INSERT INTO akeNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","E'tane, ewai' ta iya pʉra iyesi'pʉ, a'si'pʉ iya pariki'si ta' tʉnko'manʉkʉ'pʉ e'ma iya pʉ'kʉ pona. ");
INSERT INTO akeNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tʉron kon ipoitorʉ ton uya ensa' a'tai, inkupʉnʉ tense ipan pe to' upokoita'pʉ. Mɨrɨ a'tai, to' utɨ'pʉ tepuru kon pɨ' ekamase'na tanporo inkupʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mɨrɨpan epuru uya ikɨ'ma'pʉ, ‘Ɨmɨrɨ ɨri rɨ,’ ta'pʉ iya ipɨ'. ‘Tɨwɨ rɨ si nesii, ta'pʉ uya ɨpɨ', apʉne pʉra ipan pe rɨ auta'kwarʉka pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ɨsentu'mapai pʉra pe' ɨwesi mɨ ɨtonpa pɨ', usentu'mataine' kasa ɨpɨ'?’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tʉusakorotai' itepuru uya itʉrʉ'pʉ pʉresiman amʉ' ena' to' uya a'sito' pe, mɨrɨ awonsi'kɨ ipanta'mapɨ'to' pe to' uya, tanporo tʉpʉrataai na'po iya pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Mɨrɨ na'ne' kasa kuru Epʉn pon, ukʉipʉnʉ uya ɨmɨrɨ'nokon, ɨtonpa kon pɨ' ɨyewan kon yau tʉusentu'masan pen, ku'to' oton,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Serɨ ton ta tʉuya e'nonkasa' a'tai, Sises uya Kiyarari nɨmɨ'pʉ, mɨrɨpan utɨ'pʉ Isutiya nono, Isotan tuna ratoi pona. ");
INSERT INTO akeNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tu'kan kon anpisin utɨ'pʉ ipɨkɨrɨ, mɨrɨpan kon epi'tɨ'pʉ iya mɨrɨ yau. ");
INSERT INTO akeNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pari'si amʉ' tonpa ton uyee'pʉ i'tupɨ'se'na. To' uya ekama'po'pʉ, “Main awɨrɨ rɨ e'nɨ pe rɨ pe' iyesi ka'pon uya tʉno'pʉ nonkato' ɨ'rɨ rɨ wenai?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","“Ene auya'nokon pʉra pe' ne'pɨ'an kareta yau?” ta'pʉ iya to' pɨ'. “Pena iyepiya'tɨ a'tai, ‘Ka'nin uya warawo' mɨrɨ awonsi'kɨ uri'san nɨrɨ koneka'pʉ.’ ");
INSERT INTO akeNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ta'pʉ iya, ‘Mɨrɨ wenai, warawo' uya tʉkʉipʉnʉ, tʉsan nɨrɨ nɨnto' pe iyesi, mɨrɨpan uta'sikʉ tʉno'pʉ ya', mɨrɨpan asa'ron kon ena tikin nɨ ipun.’ ");
INSERT INTO akeNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mɨrɨ kasa, asa'rɨ to' esi pen, e'tane tikin nɨ. Mɨrɨ pe iyesi pɨ', Papa na'sikʉ'san ɨsipona, mo'ka ka'pon uya kʉse'nin,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","To' uya ekama'po'pʉ, “Ɨ'rɨ pe ken si iyesi pɨ' e'nonkan nɨto' karetaai tʉmenukai' ɨno'pʉ inonkakɨ tasa' Mosi' uya?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Sises uya to' eikʉ'pʉ, “Mosi' uya ɨno'pʉ kon amʉ' inonkatɨ' tasa', sa'man pe rɨ ɨyewan kon esi wenai, mɨrɨpan pen nin pena iyepiya'tɨ'pʉ si'kɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ekama uya ɨpɨ'nokon; ɨnʉ' rɨ tʉno'pʉ nonkayai'ne', iyekumasa' pen nɨ e'tane, mɨrɨpan uya tʉron nɨ uri'san mari'ma, iyekuma pe iyesi mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ipoitorʉ ton uya ta'pʉ, “Mɨrɨ na'ne' kasa iyesi yau, tɨwɨ uri'san mɨrɨ awonsi'kɨ warawo' emari'ma e'pai pʉra rɨ nin si man,” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Sises uya to' eikʉ'pʉ, “Tanporon kon pɨ' ta pen nɨ mɨrɨ, e'tane kamo rɨken anʉnnin nʉ'san nɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tʉron kon entusa' temari'masen ye' pe pʉra rɨ, tʉron kon konekasa' ka'pon amʉ' uya temari'masen ye' pe pʉra rɨ, tʉron kon nɨrɨ e'ku'sa' tiwano' kon pe temari'masen ye' pe pʉra te'to' kon pe, Papa e'to' esa' wannɨ pe uriya'. Ɨnʉ' rɨ kʉrɨ tikin sarɨ e'paino e'to' pe rɨ iyesi,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mɨrɨ a'tai, mʉre amʉ' nee'pʉ to' uya Sises piya' temiyatʉ tʉto' pe iya to' pona mɨrɨ awonsi'kɨ iyɨpʉremato' pe to' pona, e'tane ipoitorʉ ton uya kamoro to' ne'nin nʉ'san eseremekʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Sises uya ta'pʉ, “Tɨwɨ mʉre amʉ' nʉyepʉi upiya'; to' kʉsereutanʉ'tʉu, apʉne pʉra pʉsamoro waraino kon kuru iwano' mɨrɨ Papa e'to' esa' wannɨ pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Temiyatʉ tʉrʉ tʉpo to' pona, itɨ'pʉ mɨrɨ apai. ");
INSERT INTO akeNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mɨrɨpan a'tai, ka'pon uyee'pʉ Sises piya' ekama'pose'na, “Ti'sa, ɨ'rɨ wakʉ ku'to' uya pe iyesi tɨwɨrɨ rɨ uko'manto' epoto' pe uya?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Sises uya ta'pʉ ipɨ', “Ɨ'rɨ pe iyesi pɨ' wakʉ pɨ' uyekama'po auya? Mɨrɨ yau iyesi mɨrɨ tikin nan nɨ wakʉ. Uko'man nɨto' ya' epa'kapai ɨwesi yau, Mosi' nʉmenuka'pʉ ton awɨrɨ e'kɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mɨrɨpan uya ekama'po'pʉ, “Nai ton?” tukai'. Sises uya eikʉ'pʉ, “Ɨnʉ' rɨ kʉ'wɨnɨi, iyemari'masa' uri'san kʉsekumankai, ama' pe kesii, kasi pe ka'pon pɨ' kasaurokʉi, ");
INSERT INTO akeNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ɨkʉipʉnʉ mɨrɨ awonsi'kɨ asan nɨrɨ inamakɨ, ɨtonpa ti'nʉnkai' e'kɨ, mɨsi'nʉnkayai'ne' kasa,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","“Tanporo mɨrɨ ton ku'sa' uya man. Ɨ'rɨ kuru ken e'ku'sa' nai?” ta'pʉ moineri'pɨ uya. ");
INSERT INTO akeNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Sises uya eikʉ'pʉ, “Wakʉ pe e'pai ɨwesi yau, itɨkɨ ɨimamin kʉrʉpo'pomase'na, mɨrɨ tʉpo entu'manin nan mʉrepai' itepe'pʉ pʉrata ke. Mɨrɨ a'tai, Epʉn po imaminke' pe ɨwesi mɨrɨ. Mɨrɨ ku'sa' auya tʉpo, upɨkɨrɨ si ɨsi'kɨ,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Moineri'pɨ uya serɨ etasa' a'tai, pokoi pe rɨ esii'ma itɨ'pʉ, apʉne pʉra eke pe kuru itimamin esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Mɨrɨ a'tai, Sises uya ta'pʉ tʉpoitorʉ ton pɨ', “I'napairon ekama uya ɨpɨ'nokon; sa'man pe kuru iyesi imaminke' epa'ka poken pʉra Papa e'to' esa' wannɨ pe ya'. ");
INSERT INTO akeNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ekamakapʉ uya kanan; sa'man pe pʉra rɨ kiyamerʉ epa'ka akusa enu euta awɨrɨ, imaminke' epa'ka Papa e'to' esa' wannɨ pe ya' entai.” ");
INSERT INTO akeNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ipoitorʉ ton uya serɨ etasa' a'tai, to' usewansiuka'pʉ ipan pe. To' uya ekama'po'pʉ, “Ɨnʉ' kuru ken si epika'tɨ?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","To' enei'ma, Sises uya ta'pʉ to' pɨ', “Ka'pon pona sa'man pe iyesi, e'tane Papa pona tanporo sa'man pe pʉra iyesi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pi'ta uya eikʉ'pʉ, “Tanporon nɨ nɨnsa' ina uya man ɨpɨkɨrɨ tʉutɨto' kon pe. Ɨ'rɨ ken si e'to' oton ina iwano' pe?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Sises uya ta'pʉ to' pɨ', “I'napairon ekama uya ɨpɨ'nokon; Papa uya emenna' pe tanporon nɨ koneka a'tai, Ka'pon, Papa winon ereuta a'tai a'kwa tapon po, ɨmɨrɨ'nokon upɨkɨrɨ iye'sa' kon nɨrɨ ereutato' oton 12 kaisaron apono' po 12 kaisaron kon Esuwerʉ pon kon eseru aimenka pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mɨrɨ awonsi'kɨ tanporon kon kamoro tiwʉ' kon, takon kon nɨ, tʉparusi kon nɨ, tʉkʉipʉnʉ kon nɨ, tʉsan kon nɨ, tʉmunkɨ kon nɨ, tʉmainarʉ kon nɨ nɨnnin nʉ'san urɨ wenai uya 100 kaisa rɨ'ne ite'kwa epoto' oton, mɨrɨpan kon uya tɨwɨrɨ rɨ uko'man nɨto' epoto' oton. ");
INSERT INTO akeNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","E'tane tu'kan kon wapiyaro' kon nʉ'san e'to' oton ite'ma'pʉ pe, mɨrɨ awonsi'kɨ tu'kan kon iu'matʉ pe iye'sa' kon e'to' oton wapiyaro' pe,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Papa e'to' esa' wannɨ pe esi non esa' kasa. Awanakʉi' itɨ'pʉ ka'pon amʉ' anʉnse'na tʉmainarʉ yau te'tʉrawasoma ton kon. ");
INSERT INTO akeNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mɨrɨ a'tai, to' pokon pe iyekoneka'pʉ to' e'mato' pe tʉuya tikin nɨ wʉi e'tʉrawasoman epe' pʉrata pun ke, mɨrɨpan kon ennoko'pʉ iya tʉmainarʉ ya'. ");
INSERT INTO akeNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Awanakʉi', 9 a'kʉra' a'tai, itɨ'pʉ kʉrʉpo'po pɨ' e'nɨto' pata'se' ya'. Mɨrɨ yau, ka'pon amʉ' e'soto'pɨ'sa' ene'pʉ iya, ɨ'rɨ kupʉ pɨ' pʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Mɨrɨ a'tai, to' auro'ka'pʉ iya, ‘Ɨmɨrɨ'nokon nɨ marɨ, itɨtɨ' umainarʉ ya' e'tʉrawasomai'. Ɨye'ma uya 'nokon mɨrɨ iye'to' awɨrɨ rɨ,’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Mɨrɨpan kon utɨ'pʉ umɨ ya' e'tʉrawasomase'na. “Non esa' kanan utɨkaa'pʉ kʉrʉpo'po pɨ' e'nɨto' pata'se' ya' 12 a'kʉra' a'tai, mɨrɨ awonsi'kɨ 3 a'kʉra' kanan ka'pon amʉ' anʉnse'na to' e'tʉrawasomato' pe tʉmainarʉ yau. ");
INSERT INTO akeNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mɨrɨ tʉpo, non esa' utɨ'pʉ kʉrʉpo'po pɨ' e'nɨto' pata'se' ya' ko'mamʉ pe 5 a'kʉra' a'tai. Mɨrɨ yau, ka'pon amʉ' e'soto'pɨ'sa' ene'pʉ iya. To' ekama'po'pʉ iya, ‘Ɨ'rɨ pe iyesi pɨ' ɨye'soto'pɨ'sa' kon te'tʉrawasomai' pʉra rɨ?’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“‘Ɨnʉ' uya rɨ ina anʉnsa' pʉra iyesi,’ ta'pʉ to' uya. “Ta'pʉ iya to' pɨ', ‘Itɨtɨ' e'tʉrawasomatantɨ' umainarʉ ya',’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ko'mamʉ pe, umɨ esa' uya ta'pʉ to' epuru pɨ', ‘Tʉrawaso amʉ' ikɨ'makɨ to' e'ma pa to' epe'pʉ ke,’ ta'pʉ iya. ‘Iu'matʉ pe anʉnsa' kon tʉrawaso pe me'mai' wapiya, iyepiya'tɨ pe anʉnsa' kon e'ma pa iu'matʉ pe,’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Tʉrawaso amʉ' iye'sara'tɨsa' kon e'tʉrawasoman pɨ' 5 a'kʉra' a'tai uyee'pʉ tʉpʉrataai kon ipun si epose'na. ");
INSERT INTO akeNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ka'pon amʉ' wapiya iye'sara'tɨsa' kon tʉrawaso pe uyee'pʉ tepe'pʉ kon epose'na. To' e'kupʉ'pʉ eke pe parɨ pʉrata eporo tʉuya'nokon tukai', e'tane to' uya tikin nɨ rɨ marɨ pʉrata pun eporo'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pʉrata eporo tʉuya'nokon a'tai, to' entarumʉ'pʉ non esa' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Pʉsamoro ka'pon amʉ' iye'tʉrawasomasa' kon aka'ne' pe rɨ e'masa' auya'nokon, ina kaisarɨ rɨ marɨ, sa'man pe rɨ ina e'tʉrawasomasa' e'tane a'ne' rɨ wʉi yau,’ ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“E'tane tikin nan to' tonpa eikʉ'pʉ iya, ‘Utonpa, wakʉ pe rɨ iyesi serɨ pɨ' e'tʉrawasoma rɨ, tikin nan nɨ pʉrata pun pɨ', ta'pʉ auya. ");
INSERT INTO akeNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ɨyepe'pʉ anʉnkɨ, itɨkɨ. E'kupʉ'pʉ ka'pon amʉ' e'mato' pe uya iu'matʉ pe unanʉmʉ'san kɨnye'mayai'ne' kasa rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Upʉrataai ke pe' i'se e'to' rɨ kupʉ uya pen? Upɨ' rɨ katɨ ɨyɨkɨnta amʉre'mʉra esi pɨ'?’ ta'pʉ iya,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Sises uya tʉpantomʉ i'ma'ka'pʉ se kasa: “Mɨrɨ kasa iu'matʉ pe iye'sa' kon e'to' oton iyepiya'tɨ pe; kamoro iyepiya'tɨ pe iye'sa' kon e'to' oton iu'matʉ pe,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Sises utɨ koro'tau Surusiran pona, 12 kaisaron kon tʉpoitorʉ ton pantaka'pʉ iya mɨ airɨ. Ta'pʉ iya to' pɨ', ");
INSERT INTO akeNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Surusiran pona utɨ'nokon serɨ, Ka'pon, Papa winon eparankato' oton use'man nɨto' tʉrawasomanin nan epuru ton mɨrɨ awonsi'kɨ Main pɨ' enupanin nan ena', to' uya eno'mato' oton ima'tato' ya', ");
INSERT INTO akeNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","mɨrɨpan tʉto' oton to' uya Esuwerʉ amʉ' pen ena' to' uya isapemato' pe, ari'po'pɨ'to' pe, ipokapɨ'to' pe kurusu' pona. Itosorʉwano wʉi a'tai, iye'mʉ'sa'kato' oton uko'man nɨto' ya',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Mɨrɨ a'tai, Sepiti munkɨ amʉ' san uyee'pʉ Sises piya' tʉmunkɨ amʉ' pokon pe, mɨrɨpan e'sekunkasa' uya ekama'po'pʉ, wakʉ ku'to' pe iya tiwano' pe. ");
INSERT INTO akeNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Sises uya ekama'po'pʉ, “Ɨ'rɨ i'se me'an?” ta'pʉ iya. Mɨrɨpan eikʉ'pʉ iya, “Pʉsamoro asa'ron kon umunkɨ amʉ' iku'kɨ to' ereutato' pe ɨyenwo'netʉ winɨ, tʉron nɨ akamisi winɨ esa' wannɨ pe ɨwe'to' yau,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","“I'tu auya'nokon pʉra iyesi mekama'poyatʉi'ne',” ta'pʉ Sises uya to' pɨ'. “Ɨyekota'ma kon poken ken pe' nai ekota'mato' oton na'ne' kasa?” ta'pʉ Sises uya to' pɨ'. “Ewai',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","“I'napairɨ rɨ ɨyekota'ma kon urɨ ekota'mato' oton kasa rɨ, e'tane umeruntɨrʉ pʉra man iku'to' pe uya, ɨnʉ' ereutato' pe uyenwo'netʉ winɨ mɨrɨ awonsi'kɨ ukamisi winɨ nɨrɨ. Serɨ pata ton esi mɨrɨ kamoro ukʉipʉnʉ uya to' pata pe ikonekasa' na'ne' iwano' pe iyesi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","10 kaisaron kon uya asa'ron kon tʉtonpa kon maimu etasa' a'tai, to' usakorota'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Sises uya tanporo to' tʉkɨ'mai' to' amʉranʉkʉ'pʉ. Ta'pʉ iya to' pɨ', “I'tu auya'nokon Esuwerʉ amʉ' pen epuru ton esi to' esa' pe, mɨrɨpan eke ton uya tʉmeruntɨrʉ kon apurɨ to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mɨrɨ kasa ɨwesi kon pen. E'tane ru'ku, ɨnʉ' rɨ esi yau eke pe enapai ɨ'koro'tau'nokon e'to' pe iyesi ɨpoitorʉ kon pe, ");
INSERT INTO akeNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","mɨrɨ awonsi'kɨ ɨnʉ' rɨ esi yau wapiyaro' e' pe e'pai, tɨwɨ nesii ɨpoitorʉ kon pe. ");
INSERT INTO akeNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ka'pon, Papa winon uye'sa' na'ne' kasa rɨ tapiyo' pe e'nɨto' pe pen, e'tane iyapiyo' pe e'se, mɨrɨ awonsi'kɨ tʉuko'manto' tʉse'na, tu'kan kon ka'pon amʉ' epe' pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Sises mɨrɨ awonsi'kɨ ipoitorʉ ton uya Iseri'ko nɨmɨ koro'tau, anpisin ka'pon amʉ' utɨ'pʉ ipɨkɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Asa'ron kon tenku'na' nan ka'pon amʉ' ereutasa' esi'pʉ asanta ka'ta po. Sises utɨ etasa' tʉuya'nokon a'tai, to' ukɨ'pɨ'nʉnpɨtʉ'pʉ, “Ina epuru, Tepi' pa rʉ'pʉ, ina pɨ' ɨsentu'makɨ!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tu'kan kon ka'pon amʉ' uya to' eseremekʉ'pʉ, “E'pana e'tɨ'!” ta'pʉ to' uya, e'tane rɨ eke pe parɨ to' ukɨ'pɨ'nʉnpɨtʉ'pʉ, “Ina epuru, Tepi' pa rʉ'pʉ, ina pɨ' ɨsentu'makɨ!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Sises uya to' etasa' a'tai, te'takʉ'kai' to' kɨ'ma'pʉ iya. To' ekama'po'pʉ iya, “Ɨ'rɨ kupʉ uya i'se me'atʉu ɨiwano' kon pe?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","To' uya eikʉ'pʉ, “Ina epuru, ennin pe e'pai ina esi,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Sises usentu'ma'pʉ to' pɨ'. To' enu a'pɨtʉ'pʉ iya. Inke pʉra rɨ, ennin pe to' ena'pʉ, mɨrɨpan kon e'sara'tɨ'pʉ ipɨkɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","To' uya Surusiran eporo koro'tau, Pe'pake ya' si to' uye'kaa'pʉ Are' Wʉpʉ pon. Sises uya asa'ron kon tʉpoitorʉ ton ennoko'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","tai'ma to' pɨ', “Entantɨ' ɨyentau'nokon na'ne' eke iwa pata ya'. Mɨrɨ yau, inke pʉra rɨ isa'ka'si ewa'tɨsa' eporo auya'nokon mɨrɨ, imʉre ipiyau, mɨrɨpan kon teukai', to' mʉne'tʉi' upiya'. ");
INSERT INTO akeNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ɨnʉ' uya rɨ ɨ'rɨ rɨ ta yau ɨpɨ'nokon, ‘Itepuru esi to' i'se,’ mʉkatʉi'. Mɨrɨ a'tai nin si, to' uya to' ennoko mɨrɨ inke pʉra rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Serɨ si pu'kena' amʉ' awɨrɨ isetasa' rʉ'pʉ uta'ku'tɨ: ");
INSERT INTO akeNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Surusiran pon kon ka'pon amʉ' pɨ' ekamatɨ', ‘Kin, ɨiwano' kon uye'nɨ pɨ' man, mɨ pe te'ku'se rɨ iyepʉ pen, iyepʉ isa'ka'si mʉre po,’” tawon. ");
INSERT INTO akeNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mɨrɨ a'tai, ipoitorʉ ton utɨ'pʉ Sises uya ta'pʉ awɨrɨ rɨ iku'se'na. ");
INSERT INTO akeNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","To' uya isa'ka'si mɨrɨ awonsi'kɨ imʉre ne'kaa'pʉ. To' uya tʉpon kon tʉpɨtʉ'pʉ to' pona, mɨrɨpan po Sises ereuta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Anpisin ton kuru ka'pon amʉ' uya tʉpon kon ta'nʉkʉ'pʉ asanta tawɨrɨ Sises utɨto' pe ipo. Tʉron kon uya yʉi panta ton a'tɨpɨtʉ'pʉ, mɨrɨpan ta'nʉkʉ'pʉ to' uya asanta tawɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Anpisin ton ka'pon amʉ' irawɨrɨ tʉutɨsan mɨrɨ awonsi'kɨ ipɨkɨrɨ te'san ukɨ'pɨ'nʉnpɨtʉ'pʉ, “Usana! Kin Tepi' pa rʉ'pʉ apurɨpɨtʉ serɨ!” “Pori' pe kʉrɨ esi mɨrɨ Itepuru ese' yau nʉye'ai'ne'!” “Usana ka' entawon yau!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Surusiran pona Sises epa'kasa' a'tai, ka'pon amʉ' eke pata pon kon e'tʉrʉnka'pʉ, mɨrɨpan kon uya, “Ɨnʉ' pʉse rɨ?” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Anpisin ton uya to' maimu eikʉ'pʉ, “Sises pʉse rɨ, pu'kena' Nasare' winon, Kiyarari pon!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Sises ewomʉ'pʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' pʉ'kʉ ta', mɨrɨ yau te'san ka'pon amʉ' usennan pɨ', kʉrʉpo'po pɨ' te'san enpa'ka'pʉ iya. Pʉrata ensimanin nan tepʉrʉʉi mɨrɨ awonsi'kɨ wako'wa amʉ' kʉrʉpo'pomanin nan apon ton nɨ rawoipɨtʉ'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ta'pʉ iya to' pɨ', “Iye'menukasa', ‘Uiwʉ' e'to' oton ɨpʉreman iwʉ',’ tukai' e'tane ‘ama' amʉ' en pe rɨ’ mʉku'atʉi'!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tenku'na' nan mɨrɨ awonsi'kɨ ise'mesa' kon uyee'pʉ ipiya' Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' ta', mɨrɨpan kon epi'tɨpɨtʉ'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Use'man nɨto' tʉrawasomanin nan epuru ton, Main pɨ' enupanin nan uya wakʉ kupʉ iya ensa' a'tai, mɨrɨ awonsi'kɨ mʉre amʉ' ukɨ'pɨ'nʉnpɨtʉ, “Usana! Kin Tepi' pa rʉ'pʉ apurɨpɨtʉ serɨ!” tawon etasa' a'tai, Esuwerʉ amʉ' epuru ton usakorota'pʉ ipan pe mɨrɨ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","“To' maimu pe' metayan?” ta'pʉ to' uya Sises pɨ'. “Ewai',” ta'pʉ Sises uya. “Iye'menukasa' pe' ene auya'nokon pʉra nai: “‘Apurɨpɨ'nin pe eke ton nʉ'kwɨ mʉre amʉ' mɨrɨ awonsi'kɨ mana' pokon kon mʉre amʉ' ku'sa',’ tawon?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Mɨrɨ tʉpo si, Sises uya to' nɨmɨ'pʉ, mɨrɨpan utɨ'pʉ Pe'tani pona. Mɨrɨ yau, pata tʉrʉ'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Awanakʉi' kuru, iyenna'po koro'tau eke pata pona, iwan pe iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Asanta piyau tʉna'sen ye', pi' tukai' tesa'sen ene tʉuya pɨ', itekare pɨ' itɨ'pʉ, e'tane ɨ'rɨ eporo'pʉ iya pen nɨ ipo, iyare ton nɨken, mɨrɨpan uya ta'pʉ ipɨ', “Tɨwɨ si tepetasen pe pʉra e'kɨ!” ta'pʉ iya. Inke pʉra rɨ yʉi useketa'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ipoitorʉ ton uya serɨ ensa' a'tai, to' usewansiuka'pʉ, to' uya ekama'po'pʉ, “Nai kasa si pi' e' useketa inke pʉra rɨ?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","“I'napairon ekama uya serɨ ɨpɨ'nokon,” ta'pʉ Sises uya. “Apurɨto' auya'nokon esi a'tai, tʉkasimai' pʉra, mɨrɨ pi' e' pɨ' iku'sa' na'ne' rɨken kupʉ auya'nokon pen e'tane, ‘Ata'mo'kakɨ tuna ka',’ ta auya'nokon a'tai wʉ' pɨ', mɨrɨpan nɨ e'kupʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Apurɨ auya pe iyesi yau, eporo auya rɨ ɨnekama'po'pʉ ɨwɨpʉremato' yau,” ta'pʉ Sises uya tʉpoitorʉ ton pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Sises ewomʉ'pʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' pʉ'kʉ ta'. Mɨrɨ yau, to' enupa pɨ' iyesi koro'tau, Papa ena' use'man nɨto' tʉrawasomanin nan epuru ton mɨrɨ awonsi'kɨ ka'pon amʉ' epuru ton pokon uyee'pʉ ipiya'. “Ɨ'rɨ meruntɨrʉ winɨ serɨ ton kupʉ auya? Ɨnʉ' uya serɨ meruntɨ ke ɨrepa'pʉ?” tukai' to' uya ekama'po'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Sises uya entakanoma'pʉ, “Tikin nan pɨ' rɨ marɨ ɨyekama'po uya 'nokon nɨ nɨrɨ mɨrɨ. Umaimu ei'sa' auya'nokon a'tai, ekama uya rɨ nɨrɨ mɨrɨ ɨpɨ'nokon, ɨnʉ' uya umeruntɨrʉ'tɨsa' serɨ ton ku'to' pe uya tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Isaan uya pa'taisiman nɨto'—nai winɨ iye'sa'? Epʉn winɨ pe', mɨrɨ pe pʉra ka'pon amʉ' winɨ katɨ?” ta'pʉ iya. Mɨrɨpan kon usaurokʉ'pʉ tiwano' kon pe, “‘Epʉn winɨ’ ta pe iyesi yau, uyekama'po iya 'nokon, ‘Ɨ'rɨ pe ken iyesi pɨ' Isaan apurɨ auya'nokon pʉra iyesi'pʉ?’ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","E'tane ‘ka'pon amʉ' winɨ’ ta yau, ka'pon amʉ' uya enari'pan, apʉne pʉra Isaan esi pu'kena' tukai' to' uya apurɨ'pʉ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Sises nin si eikʉ'pʉ to' uya mɨrɨ, “Ina uya i'tu pʉra man,” ta'pʉ to' uya. Mɨrɨ a'tai, ta'pʉ iya, “Ekamasa' auya'nokon pʉra iyesi ke, ekama uya nɨrɨ pen nɨ serɨ mɨrɨ meruntɨrʉ winɨ serɨ ton kupʉ uya tukai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Mɨrɨ a'tai, Sises uya ta'pʉ, “Ɨ'rɨ tukai' se pɨ' mɨsenuminkayatʉu? Ka'pon esi'pʉ asa'ron kon imunkɨ amʉ'. Wapiyaro' tʉmu piya' itɨ'pʉ, mɨrɨpan uya, ‘Mooi, e'tʉrawasomai' enta kʉre' itese' kiyari e'kwa na',’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“E'tane imu uya, ‘Kane,’ tukai' imaimu eikʉ'pʉ. Mɨrɨ ta tʉpo, teseru ensima'pʉ iya, mɨrɨpan utɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Mɨrɨ rɨ marɨ tase'na ikʉipʉnʉ utɨ'pʉ tʉmu, isakon pɨ'. ‘Mooi, serɨ pe e'tʉrawasomata kʉre' kiyari e'kwa na',’ ta'pʉ iya. ‘Ewai', utɨ rɨ,’ ta'pʉ iya, e'tane itɨ'pʉ pen. ");
INSERT INTO akeNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Nai kʉrɨ rupɨ uya tʉkʉipʉnʉ e'to' i'se kupʉ'pʉ tukai', mi'tuyatʉu?” ta'pʉ iya. “Wapiyaro' uya kuru,” tukai' to' uya imaimu eikʉ'pʉ. Mɨrɨ a'tai, Sises uya ta'pʉ, “I'napairon ekama uya serɨ ɨpɨ'nokon; pʉsamoro pʉrata amʉranʉ'nin nan mɨrɨ awonsi'kɨ uri'sami'si amʉ' ɨri pe iteseru iko'mansa' rʉ'san uya Papa e'to' esa' wannɨ pe epoto' oton arawɨrɨ'nokon. ");
INSERT INTO akeNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Wakʉ pe e'nɨ eseru enpoikase'na Isaan uyee'pʉ ɨpiya'nokon e'tane, apurɨ auya'nokon pʉra iyesi'pʉ, pʉrata amʉranʉ'nin nan mɨrɨ awonsi'kɨ uri'sami'si amʉ' ɨri pe iteseru iko'mansa' kon nʉ'pʉ uya rɨken apurɨ'pʉ. Mɨrɨ rɨ si ene tʉpo amakooi kon apai ɨyera'tɨ kon pʉra rɨ iyesi, mɨrɨ awonsi'kɨ apurɨ auya'nokon pʉra iyesi,” ta'pʉ Sises uya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Tʉron nɨ kanan panton etatɨ': Moro non esa' ka'pon esi'pʉ kiyari ye' si'na' pe te'sen patama'pʉ iya. Iwoi iwa'kʉtʉi pe iwekupiri'tɨ'pʉ iya. Non aka'pʉ iya tʉmainarʉ yau ikasu'kato' yai, mɨrɨ awonsi'kɨ ipa'simato' ponsi'kɨ ka'tawon soto'pan ɨutɨ amɨ'pʉ iya. Mɨrɨpan uya umɨ pɨ' te'san ena' tʉmainarʉ tʉrʉ'pʉ, mɨrɨpan utɨ'pʉ ɨnnon pata ya'. ");
INSERT INTO akeNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Kiyari akʉ'pʉsa' weyu e'seposa' a'tai, tʉpoitorʉ ton ennoko'pʉ iya umɨ tʉrʉ'pʉ tʉuya itena' ton piya' tiwano' oton epose'na. ");
INSERT INTO akeNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Umɨ esanon uya ipoitorʉ ton a'si'pʉ. Tikin nan panta'ma'pʉ to' uya, tʉron nɨ wɨnɨ'pʉ to' uya, to' osorʉwano wɨpɨtʉ'pʉ to' uya tɨ' ke. ");
INSERT INTO akeNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mɨrɨ a'tai tʉron kon nʉ'san tʉpoitorʉ ton ennoko'pʉ iya wapiyaro' ennoko'pʉ tʉuya entai, umɨ esanon uya mɨrɨ kasa rɨ marɨ to' kupʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tanporon kon u'matʉ pe, tʉmu nin si ennoko'pʉ iya to' piya'. ‘To' uya kuru umu nama mɨrɨ,’ ta'pʉ iya, ");
INSERT INTO akeNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","e'tane imu ensa' tʉuya'nokon a'tai, ta'pʉ to' uya tʉtonpa kon pɨ', ‘Pʉse rɨ kuru pʉse rɨ kiyari pata'se' anʉnton. Apʉne, iwɨpai'nokon, inanʉmʉnʉ anʉnto' kon pe,’ ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mɨrɨpan tanʉnse to' uya eno'ma'pʉ kiyari e'kwa yapai, mɨrɨpan wɨnɨ'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Mɨrɨ pe iyesi pɨ', kiyari e'kwa esa' uye'sa' a'tai, ɨ'rɨ ken si kupʉ iya itena' tʉnonka'san pɨ'?” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","“To' ma'tanʉkʉ'pʉ iya, kamoro ɨri ton, mɨrɨ awonsi'kɨ tʉron kon nʉ'san ena' nin si kiyari e'kwa tʉrʉ iya tʉrepanin nan nin si ena', umɨ winɨ tʉneporonʉ kon yapai,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Sises uya ta'pʉ to' pɨ', “Iye'menukasa' itekare yau ennin nan pen pe' ɨmɨrɨ'nokon: “‘Tɨ', ɨutɨ amɨnin nan neno'ma'pʉ enasa' itekun airon tɨ' pe; serɨ ku'sa' Itepuru uya, mɨrɨpan esi wakʉ pe kuru uyenu kon yau,’ tawon? ");
INSERT INTO akeNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Mɨrɨ pɨ' Papa e'to' esa' wannɨ pe emo'kato' oton ɨpiyapai'nokon, mɨrɨ awonsi'kɨ wakʉ pe epetanʉ'nin nan ena' iye'tʉto' oton. ");
INSERT INTO akeNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kʉrɨ serɨ tɨ' pona nʉta'mo'kayai'ne' utakiti'kwa mɨrɨ, e'tane kʉrɨ tɨ' nʉta'mo'kayai'ne' ipona uta'si'kɨrɨ mɨrɨ ipʉra rɨ nin,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Papa ena' use'man nɨto' tʉrawasomanin nan epuru ton mɨrɨ awonsi'kɨ Pari'si amʉ' uya Sises pantomʉ to'ka'nʉ'sa' a'tai tʉpɨ'nokon isaurokʉ tukai', ");
INSERT INTO akeNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","a'sito' ipɨkɨrɨ warinpa pɨ' to' esi'pʉ, e'tane anpisin ka'pon amʉ' pɨ' to' enari'nʉmʉ'pʉ, apʉne pʉra ka'pon amʉ' uya apurɨ pɨ' pu'kena' pe iyesi tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Sises uya kanan to' auro'kakaa'pʉ panton yai. Ta'pʉ iya: ");
INSERT INTO akeNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Papa e'to' esa' wannɨ pe esi kin, tʉmu emari'ma i'kiyari konekanin nʉ'pʉ kasa, ");
INSERT INTO akeNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","mɨrɨpan uya tʉpoitorʉ ton ennoko'pʉ tʉnkɨ'ma'san pana'tɨse'na to' uye'to' pe, e'tane ɨsi'pai pʉra to' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Serɨ rɨken pe tʉpoitorʉ ton ennoko'pʉ iya, ‘Apʉne enkɨ! Tanporon nɨ ekonekaka'sa' man. Paka amʉ' mɨrɨ awonsi'kɨ eka'nʉ'sa' ton paka munkɨ amʉ' wɨka'sa' ekonekasa' man. Ɨsi'tɨ' si emari'man i'kiyari pɨ' enta'nai'!’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","E'tane tetai' pʉra to' utɨpɨtʉ'pʉ, mɨrɨpan tikin nan utɨ'pʉ tʉmainarʉ ya', tʉron nɨ tʉnkupʉnʉ rɨ ku'se'na. ");
INSERT INTO akeNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tʉron kon uya ipoitorʉ ton a'si'pʉ, ipan pe rɨ to' kota'ma'pʉ to' uya, mɨrɨ awonsi'kɨ to' wɨnɨ'pʉ rɨ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kin usakorota'pʉ, mɨrɨpan uya tʉsoisaai amʉ' ennoko'pʉ kamoro to' wɨnin nʉ'san ma'tanʉ'se'na, to' pata'se' rɨ po'tɨpɨ'se'na. ");
INSERT INTO akeNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Mɨrɨpan uya ta'pʉ tʉpoitorʉ ton pɨ', ‘Emari'man i'kiyari rɨ e'nonkasa' man e'tane, kamoro unkɨ'ma'san uye'to' pe pʉra rɨ kenʉ' iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Entantɨ' asanta ka'ta pona rɨ, ɨneporo'pʉ kon nɨ mʉkɨ'matʉi',’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Mɨrɨ pɨ' ipoitorʉ ton utɨ'pʉ asanta ka'ta pona ka'pon amʉ' tʉneporonʉ kon nɨ amʉranʉ'se'na, asa'rɨ rɨ, wakʉ ton, ɨri ton nɨ, mɨrɨpan emari'man nɨto' itau ɨutɨ epe'tɨ'pʉ ka'pon amʉ' ke. ");
INSERT INTO akeNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“E'tane kin uye'sa' a'tai to' ense'na, ene'pʉ iya moro ka'pon emari'man pon pe pʉra ipon. ");
INSERT INTO akeNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Utonpa, nai kasa ɨuye'sa' emari'man pon yau pʉra rɨ?’ tukai' ekama'po'pʉ iya. Isauro'to' pʉra iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Mɨrɨ a'tai, kin uya ta'pʉ tʉpoitorʉ ton pɨ', ‘Auronpɨ'tɨ', itemiyatʉ pɨ' mɨrɨ awonsi'kɨ i'ta pɨ' eno'ma kon pa pʉroroi pona ewarupɨ ya'. Mɨrɨ yau ikaranto' pe, tʉyɨ kɨtɨtɨi'mato' pe iya,’ ta'pʉ kin uya. ");
INSERT INTO akeNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Tu'kan kon nɨ kɨ'ma e'tane, tu'ke pʉra to' anʉmʉ,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mɨrɨ pɨ' Pari'si amʉ' utɨ'pʉ nai kasa ipoken pʉra isauro'to' pe ikupʉ'nokon ka'se'na. ");
INSERT INTO akeNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","To' uya tʉpoitorʉ kon ennoko'pʉ Sises piya'. Kin pe te'sen, Era' pɨkɨron kon pokon pe rɨ, mɨrɨpan kon uya ta'pʉ Sises pɨ', “Ti'sa, ina i'tupɨ' man i'napairon ye' pe ɨwesi tukai', mɨrɨ awonsi'kɨ Papa eseru pɨ' enupan auya i'napairon awɨrɨ. Ka'pon amʉ' rɨ nensimanʉ pe pʉra ɨyeseru esi, apʉne pʉra ɨnʉ' pe rɨ to' esi pɨ' te'namasen pe pʉra ɨwesi. ");
INSERT INTO akeNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ina pɨ' ekamakɨ; ɨ'rɨ ta auya se pɨ'; ipoken pe' iyesi Sisa ena' pʉrata tʉtʉsen e'ma a'tai, kane katɨ?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","E'tane, ɨri kupʉ pɨ' to' e'ku'to' i'tu tʉuya ke Sises uya ta'pʉ. “Ɨmɨrɨ'nokon wakʉ pe te'ku'san, ɨ'rɨ pe iyesi pɨ' usa'mapai ɨwesi kon? ");
INSERT INTO akeNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Apʉne, use'man nɨto' ike enpoikatɨ' uyena',” ta'pʉ iya. Mɨrɨpan kon uya pata esa' apon pʉrata pun nee'pʉ itena'. ");
INSERT INTO akeNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mɨrɨpan uya to' ekama'po'pʉ, “Ɨnʉ' nai ipɨ', ɨnʉ' ese' nai ipɨ'?” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Sisa,” tukai' to' uya imaimu eikʉ'pʉ. Mɨrɨ a'tai, ta'pʉ iya to' pɨ', “Sisa iwano' itʉtɨ' itena' rɨ, mɨrɨ awonsi'kɨ Papa iwano' rɨ itʉtɨ' Papa ena' rɨ,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Serɨ tawon eta tʉuya'nokon a'tai, to' usewansiuka'pʉ, mɨrɨpan kon utɨ'pʉ ipiyapai. ");
INSERT INTO akeNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mɨrɨ wʉi yau rɨ, Satu'si amʉ', eri'nɨ tʉpo e'mʉ'sa'kan pʉra iyesi tawon nan uyee'pʉ Sises piya' ekama'pose'na. ");
INSERT INTO akeNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ta'pʉ to' uya, “Ti'sa, Mosi' uya tasa' upɨ'nokon, tʉumu'tai' pʉra ka'pon eri'sa' yau, iyakon nʉ'pʉ uya ino'pʉ rʉ'pʉ mari'mato' pe iyesi imu'tanʉ'to' pe tʉuya itiwano' pe. ");
INSERT INTO akeNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Moro 7 kaisaron kon ɨsirunan esi'pʉ ina koro'tau. Wapiyaro' emari'ma'pʉ, mɨrɨpan erikʉ'pʉ, tʉmunkɨ ke pʉra tʉno'pʉ tʉnonkai', mɨrɨpan no'pʉ rʉ'pʉ e'nonka'pʉ iyakon ena'. ");
INSERT INTO akeNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mɨrɨ kasa rɨ marɨ, iyakon nʉ'pʉ erikʉ'pʉ imʉre pʉra rɨ. To' osorʉwano esi'pʉ mɨrɨ kasa rɨ. Tanporo 7 pe te'to' kon kaisa rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kamoro eri'pɨtʉ'pʉ pata'pʉ pe, to' no'pʉ rʉ'pʉ erikʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Eri'nɨ tʉpo, e'mʉ'sa'kan a'tai, ɨnʉ' kuru no'pʉ pe ken si iyesi, 7 kaisaron kon koro'tapai, apʉne pʉra 7 kaisaron kon uya imari'masa' pɨ'?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Sises uya to' maimu eikʉ'pʉ, “Ɨmɨrɨ'nokon esi ipoken pʉra, apʉne pʉra iye'menukasa' itekare mɨrɨ pe pʉra Papa meruntɨrʉ i'tu auya'nokon pʉra iyesi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Eri'nɨ tʉpo e'mʉ'sa'kan a'tai, ka'pon amʉ' emari'mato' oton pen nɨ, mɨrɨ pe pʉra to' e'tʉrʉ pen nɨ emari'man nɨto' yau; inserʉ amʉ', Epʉn pon kon kasa rɨ to' e'to' oton. ");
INSERT INTO akeNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","E'tane eri'nɨ tʉpo e'mʉ'sa'kan nɨto' ensa' auya'nokon pʉra pe' nai Papa uya ayauro'ka'pʉ kon ipɨ'? ");
INSERT INTO akeNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Papa urɨ, Epʉra'an, Aisi', Seko' e'to' itese' ipɨ',’ tawon. Papa, iyeri'sa' kon e'to' itese' pɨ' pen e'tane nurɨnan kon,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Serɨ tawon eta tʉuya'nokon a'tai, to' usewansiuka'pʉ tenupato' iya 'nokon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sises uya Satu'si amʉ' maimu'kasa' tense, Pari'si amʉ' amʉra'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","To' tonpa, ipan pe Main i'tunin uya Sises ekama'po'pʉ i'tupɨtʉ pe, ");
INSERT INTO akeNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ti'sa, nai kuru esi eke pe iyawɨrɨ e'nɨto' pe Main, Mosi' winon yau?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Sises uya eikʉ'pʉ, “‘Papa i'nʉnkakɨ tanporo ɨyewan pokon pe, aya'kwarʉ pokon pe, mɨrɨ awonsi'kɨ ɨusenuminkato' pokon pe.’ ");
INSERT INTO akeNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Serɨ serɨ wapiyaro', eke kuru iyawɨrɨ e'nɨto'. ");
INSERT INTO akeNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mɨrɨ awonsi'kɨ ipɨkɨron esi iwaraino rɨ marɨ: ‘Ɨtonpa i'nʉnkakɨ mɨsi'nʉnkayai'ne' kasa,’ tawon. ");
INSERT INTO akeNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Serɨ si asa'ron iyawɨrɨ e'nɨto' po, tanporo Main mɨrɨ awonsi'kɨ Pu'kena' amʉ' esi mɨrɨ,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pari'si amʉ' amʉrasa' koro'tau, Sises uya to' ekama'popɨtʉ'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ɨnʉ' pe rɨ Kʉrai esi tukai' mi'tuyatʉu? Ɨnʉ' pa rʉ'pʉ pe iyesi?” ta'pʉ iya. “Tepi' pa rʉ'pʉ tukai',” to' uya eikʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ta'pʉ iya to' pɨ', “Ɨ'rɨ pe ken iyesi pɨ' Tepi' usaurokʉ Iya'kwarʉ yau uya esakʉ, ‘Uyepuru,’ tukai'? Apʉne pʉra ta iya, ");
INSERT INTO akeNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘Itepuru uya ta'pʉ uyepuru pɨ': “Uyenwo'netʉ winɨ ereutakɨ, ɨyeyaton non tʉrʉ uya pʉkʉ pona a'ta o'koi',”’ tasa'. ");
INSERT INTO akeNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tepi' uya, ‘Uyepuru,’ tukai' esakʉ pe iyesi yau, nai kasa nɨrɨ ipa rʉ'pʉ pe nesii'no?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ɨnʉ' uya rɨ imaimu entakanoma poken pʉra iyesi'pʉ, mɨrɨ wʉi awonsi'kɨ ɨnʉ' rɨ esi'pʉ mɨrɨ enta' ɨnekama'popɨ'pai pʉra. ");
INSERT INTO akeNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mɨrɨ a'tai, Sises uya ta'pʉ iyamʉrasa' kon pɨ' mɨrɨ awonsi'kɨ tʉpoitorʉ ton pɨ': ");
INSERT INTO akeNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Main pɨ' enupanin nan mɨrɨ awonsi'kɨ Pari'si amʉ' esi mɨrɨ Mosi' pata'pʉ akan pe. ");
INSERT INTO akeNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","To' maimu awɨrɨ me'tʉi', ɨ'rɨ rɨ tasa' to' uya na'ne' ɨpɨ'nokon mʉku'tʉi', e'tane to' nʉkupʉnʉ kʉ'ku'tʉu, apʉne pʉra tʉusauro'to' kon ku'nin nan pen kamoro. ");
INSERT INTO akeNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ka'pon amʉ' ekama'po to' uya itekare ku'to' pe to' uya sa'man pe rɨ te'sen, e'tane ɨ'rɨ rɨ kupʉ to' uya pʉra rɨ iyesi tʉnauro'kapʉ kon pika'tɨnin pe. ");
INSERT INTO akeNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Tanporon nɨ to' nʉkupʉ'pʉ pe na'ne' esi mɨrɨ ka'pon amʉ' uya tento' kon ipɨ' pe: tʉwɨpʉremato' kon yen konepɨtʉ to' uya eke ton pe ika'ta, mɨrɨ awonsi'kɨ tʉpon kon sousowʉ pe te'sen kanan ɨnkapɨtʉ to' uya kusan ton pe. ");
INSERT INTO akeNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Eke ton ereutato' pata'se' yau kuru ereutapaino kon enta'nan a'tai'ne mɨrɨ awonsi'kɨ Esuwerʉ amʉ' usenupato' iwʉ' tau. ");
INSERT INTO akeNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Anpisin ka'pon amʉ' kʉrʉpo'po pata'se' iyawon kon uya, ‘Miyarɨ,’ ta i'se te'san tʉnama kon pe, ka'pon amʉ' uya, ‘Rapai,’ ta i'se kuru to' esi tʉpɨ'nokon. ");
INSERT INTO akeNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“E'tane ɨusesa'to' kon pʉra iyesi ‘Ti'sa’ tukai', apʉne pʉra tikin nan nɨ esi ɨyepuru kon pe, mɨrɨ awonsi'kɨ ɨsitonpa pe rɨ nin ɨwesi kon. ");
INSERT INTO akeNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mɨrɨpan ɨnʉ' rɨ kʉsesa'tʉu, ‘Ukʉipʉnʉ,’ tukai' serɨ non po, apʉne pʉra tikin nan nɨ ɨkʉipʉnʉ kon esi, Epʉn pon. ");
INSERT INTO akeNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ɨnʉ' rɨ esa'to' pʉra rɨ iyesi, ‘Ti'sa,’ tukai', apʉne pʉra tikin nan nɨ kʉrɨ rɨ Ti'sa; Kʉrai. ");
INSERT INTO akeNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Eke pe na'ne' ɨ'koro'tau'nokon esi mɨrɨ ayapiyo' kon pe rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ɨnʉ' rɨ eke pe te'ku'sen ena mɨrɨ se pe rɨ; mɨrɨ awonsi'kɨ se pe rɨ te'ku'sen ena mɨrɨ eke pe,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ɨsɨ sɨ, Main pɨ' enupanin nan mɨrɨ awonsi'kɨ Pari'si amʉ', ɨmɨrɨ'nokon wakʉ pe te'ku'san! Papa e'to' esa' wannɨ ya' rɨ ɨtɨpaino kon wa'kʉ'sa' auya'nokon man. Ɨmɨrɨ'nokon pe rɨ epa'kapai pʉra ɨwesi kon, mɨrɨ pe pʉra epa'kapai na'ne' nan epa'kato' pe ikupʉ auya'nokon pʉra iyesi. ");
INSERT INTO akeNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Ɨsɨ sɨ, Main pɨ' enupanin nan mɨrɨ awonsi'kɨ Pari'si amʉ', ɨmɨrɨ'nokon wakʉ pe te'ku'san! Itaan'pʉ iyeri'sa' kon nʉ'san iwʉ' ma'tanʉkʉ auya'nokon, mɨrɨ awonsi'kɨ ɨwɨpʉrema kon kusan pe, ‘Wakʉ ton,’ tato' pe ɨpɨ'nokon. Mɨrɨ wenai, ipan pe rɨ Papa uya ɨkota'mato' oton kon. ");
INSERT INTO akeNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ɨsɨ sɨ, Main pɨ' enupanin nan mɨrɨ awonsi'kɨ Pari'si amʉ', ɨmɨrɨ'nokon wakʉ pe te'ku'san! Siya rɨ tʉutɨsan ɨmɨrɨ'nokon non poro, parau kau rɨ, tikin nan nɨ konekai'. Ɨtonpa pe ikonekasa' auya'nokon a'tai, ikupʉ auya'nokon asa' ite'kwa iye'to' airɨ akasa'nokon, iyeri'sa' kon utɨto' ya' ekota'mai' itɨto' pe. ");
INSERT INTO akeNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ɨsɨ sɨ, tenku'ne esii'ma ka'pon esanon! Ta auya'nokon, ‘Ɨnʉ' rɨ usauro'sa' yau, iku'to' pe uya tukai' Papa ena' use'man nɨto', ɨpʉreman nɨto' iwʉ' tesa'pɨ'se uya iku'to' kuru pe pʉra rɨ iyesi, e'tane ɨnʉ' rɨ usauro'sa' pe iyesi yau, iku'to' pe tʉuya tukai', korʉ tesa'pɨ'se Papa ena' use'man nɨto', ɨpʉreman nɨto' iwʉ' tawon uya kuru nin si iku'to' pe iyesi,’ ta auya'nokon. ");
INSERT INTO akeNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tenu a'kwarʉkena' nan pen! Nai esi eke pe kuru: korʉ, Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' katɨ—korʉ ku'nin wakʉ pe? ");
INSERT INTO akeNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ta auya'nokon kanan, ‘Ɨnʉ' rɨ usauro'sa' yau, iku'to' pe uya tukai' Papa ena' use'man nɨto' apon tesa'pɨ'se uya iku'to' pe kuru pʉra rɨ iyesi, e'tane ɨnʉ' rɨ usauro'sa' pe iyesi yau, iku'to' pe tʉuya tukai' tʉntʉrʉnʉ Papa ena' use'man nɨto' apon tesa'pɨ'se ikupʉ uya tukai', tʉusaurokʉ'pʉ ku'to' iya pe kuru rɨ iyesi,’ ta auya'nokon. ");
INSERT INTO akeNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Itenu pʉnon! Nai esi eke pe kuru: tʉtʉsen, use'man nɨto' apon katɨ—tʉtʉsen ku'nin wakʉ pe? ");
INSERT INTO akeNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mɨrɨ wenai, tʉusauro'sa' rʉ'pʉ kupʉ iya pe iyesi Papa ena' use'man nɨto' apon tesa'pɨ'se, mɨrɨ kasa rɨ marɨ iyesi ta tʉuya pe iyesi yau, tʉusauro'sa' iku'to' pe uya ta tʉuya a'tai, tanporon nɨ Papa ena' use'man nɨto' apon tesa'pɨ'se. ");
INSERT INTO akeNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kʉrɨ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' tesa'pɨ'se ikupʉ uya tukai', Papa, itau na'ne' ese' yau isauro'sa' na'ne', Papa uya wakʉ nonkato' tʉmunkɨ amʉ' pona iwʉ', mɨrɨ kasa rɨ marɨ iyesi tʉusauro'sa' kupʉ iya pe iyesi yau, Papa ese' tesa'pɨ'se Papa ena' use'man nɨto', ɨpʉreman nɨto' iwʉ' tawon. ");
INSERT INTO akeNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kʉrɨ Epʉn tesa'pɨ'se iku'to' pe uya tukai' tʉusauro'sen, usaurokʉ mɨrɨ Papa apon tesa'pɨ'se mɨrɨ awonsi'kɨ ipo te'sen. ");
INSERT INTO akeNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ɨsɨ sɨ, Main pɨ' enupanin nan mɨrɨ awonsi'kɨ Pari'si amʉ', ɨmɨrɨ'nokon wakʉ pe te'ku'san! 1/10 e'to' airɨ kiyari kɨ'nʉnpanin—min, tirʉ mɨrɨ awonsi'kɨ kumin tato' tʉnin. E'tane eke ton pe kuru te'sen Main yau—ɨsi'kaisa rɨ ka'pon ku'to', ɨsentu'ke' pe e'nɨto' mɨrɨ awonsi'kɨ usauro'nɨ'pʉ awɨrɨ e'nɨto'. Emen iwa pe na'ne' kupʉ pɨ' ɨwesi'pʉ kon nesii'no, iwapiyaro' teno'mai' pʉra. ");
INSERT INTO akeNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Tenku'ne esii'ma ka'pon esanon! Ɨmɨrɨ'nokon esi weruwe eisikai'ma ɨuku kon apai, ɨikʉn kon eke rɨ kiyamerʉ tato' enko'mai'ma. ");
INSERT INTO akeNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ɨsɨ sɨ, Main pɨ' enupanin nan mɨrɨ awonsi'kɨ Pari'si amʉ', ɨmɨrɨ'nokon wakʉ pe te'ku'san! Iya'poi pɨ' a'sawʉ kon, aparapii kon korʉka auya'nokon, e'tane eke pe rɨ iyau mentai e'nɨto' mɨrɨ awonsi'kɨ amʉre' pe e'nɨto' esi. ");
INSERT INTO akeNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ɨmɨrɨ'nokon tenku'na' nan, Pari'si amʉ'! Wapiya kuru iyau a'sawʉ kon, aparapii kon ikorʉkaka'tɨ'. Mɨrɨ a'tai, iya'poi esi mɨrɨ wakʉ pe rɨ nɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ɨsɨ sɨ, Main pɨ' enupanin nan mɨrɨ awonsi'kɨ Pari'si amʉ', ɨmɨrɨ'nokon wakʉ pe te'ku'san! Ɨmɨrɨ'nokon esi aimu'ne ikorʉkasa' tɨ' akasa' uruwai' pe kasa, wakʉ pe tʉusensen kɨpo'po, e'tane eke pe rɨ iyeri'pɨ'sa' kon ɨ'pʉ rʉ'san esi iyau, mɨrɨ awonsi'kɨ ɨri ton nɨ esi. ");
INSERT INTO akeNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mɨrɨ kasa rɨ, ɨusene kon ipokena' pe tʉron kon pona, e'tane ɨyewan kon yau makoi pe ɨwesi kon wakʉ pe ɨye'kupʉ kon. ");
INSERT INTO akeNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ɨsɨ sɨ, Main pɨ' enupanin nan mɨrɨ awonsi'kɨ Pari'si amʉ', ɨmɨrɨ'nokon wakʉ pe te'ku'san! Pu'kena' amʉ' uruwasii oton tɨ' akapɨtʉ'pʉ auya'nokon mɨrɨ awonsi'kɨ ipokena' ton uruwasii ipʉrʉ'tɨpɨtʉ auya'nokon. ");
INSERT INTO akeNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","‘Pena ina tamokori ton a'tai, ina uko'mamʉ pe iyesi yau, to' pika'tɨ'pʉ nesii'no pen nɨ pu'kena' amʉ' tʉ'ka pɨ',’ ta auya'nokon. ");
INSERT INTO akeNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","E'tane ɨiwano' kon pe ɨusekama kon kamoro pu'kena' amʉ' tʉ'kanin nʉ'san payan nʉ'san pe. ");
INSERT INTO akeNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Iku'tɨ' rɨ si atamokori kon amʉ' nʉsara'tɨ'pʉ, Papa uya ɨkota'mato' kon pe iwenai!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Sises uya kanan ta'pʉ, “Ɨmɨrɨ'nokon, ɨkʉi amʉ' kasa te'san, ayainʉmʉ kon pe' Papa uya ɨkota'mato' kon ta'mu kenan pen nɨ ekota'man nɨto' yapai? ");
INSERT INTO akeNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mɨrɨ pe iyesi pɨ', ɨ'koro'ta'nokon pu'kena' amʉ', ta'kwarʉkena' nan mɨrɨ awonsi'kɨ ti'sa amʉ' ennoko uya to' tonpa ton tʉ'kato' auya'nokon oton mɨrɨ awonsi'kɨ tʉron kon pokapɨ'to' auya'nokon kurusu' pona mɨrɨ awonsi'kɨ tʉron kon nɨ ari'po'pɨ'to' auya'nokon oton ɨusenupato' kon iwʉ' tau, mɨrɨpan kon nɨ e'ma'pʉkapɨ'to' auya'nokon oton tʉron nɨ pata yapai'ne tʉron nɨ pata ya'ne. ");
INSERT INTO akeNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ɨmɨrɨ'nokon pona serɨ e'moronkato' oton ipokena' ton mʉnʉ enno'sa' auya'nokon wenai serɨ non po, ipokena' Eperʉ mʉnʉ awonsi'kɨ, Sakaraya, Pere'kaya mu pe te'sen mʉnʉ pʉ'kʉ pona rɨ, ɨnwɨnɨ'pʉ kon ɨpʉreman nɨto' iwʉ' mɨrɨ awonsi'kɨ use'man nɨto' apon ka'sanau. ");
INSERT INTO akeNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","I'napairon ekama uya ɨpɨ'nokon; tanporo serɨ e'moronka mɨrɨ serɨ a'taino kon pona,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Aiko sɨ! Surusiran pon kon, Surusiran pon kon! Ɨmɨrɨ'nokon pu'kena' amʉ' tʉ'kanin nʉ'san, tɨ' ke ɨpiya'nokon enno'sa' kon wɨpɨ'nin nʉ'san. Inke rɨ ɨmunkɨ amʉ' amʉranʉkʉ i'se esi'pʉ, kɨrɨtɨkɨ uya tʉmunkɨ amʉ' amʉranʉkʉ kasa tapiri o'koi', e'tane mɨrɨ kupʉ uya i'se pʉra ɨwesi'pʉ kon. ");
INSERT INTO akeNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Entɨ' si! Ɨiwʉ' kon e'nonkasa' ɨyena'nokon iyarʉ pʉra! ");
INSERT INTO akeNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Apʉne pʉra ekama uya ɨpɨ'nokon; uyento' auya'nokon oton pen nɨ kanan serɨ enta', ‘Pori' pe rɨ kʉrɨ rɨ nʉye'ai'ne' Itepuru ese' yau esi,’ ta auya'nokon pʉ'kʉ pona,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Sises utɨ esi'pʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' tawonsi'kɨ, ipoitorʉ ton iya'kɨron kon uya ta'pʉ ipɨ', “Apʉne enkɨ, wakʉ pe rɨ amɨsa' ɨutɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","“Tanporo rɨ pe' serɨ ton menyatʉu? I'napairon ekama uya ɨpɨ'nokon, tikin nɨ rɨ tɨ' e'nonkato' oton pen nɨ mɨrɨ ɨsipʉro'po; tanporon nɨ uta'po'to' oton,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Sises ereutasa' koro'tau Are' Wʉpʉ po, ipoitorʉ ton uyee'pʉ ipiya' ama'ai ekama'pose'na, “Ina pɨ' ekama' ɨ'rɨ a'tai serɨ e'ku'to' oton, ɨ'rɨ e'to' oton ɨuyepʉ ento' ipɨ' pe, pata weyu u'matʉ ekamanin pe?” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Sises uya ta'pʉ to' pɨ', “Tenu ke e'tɨ' ɨnʉ' uya rɨ ɨyenku'tɨ kon namai'. ");
INSERT INTO akeNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Apʉne pʉra tu'kan kon nɨ uye'to' oton uyese' yau, ‘Kʉrai urɨ,’ tukai', mɨrɨpan kon uya tu'kan kon nɨ enku'tɨto' oton. ");
INSERT INTO akeNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ɨmɨrɨ'nokon uya etato' oton tʉusewa'nomasan, usewa'noman man tawon nɨ, e'tane serɨ ton pɨ' rɨ ketʉipɨ'tʉu. Serɨ warai'nan nɨ e'ku'to' pe iyesi, e'tane apʉne rɨ pata weyu u'ma'to' uye'tane rɨ iyesi. ");
INSERT INTO akeNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tʉpataron kon uya tʉpataron kon nɨ nɨrɨ ewa'nomato' oton, mɨrɨ awonsi'kɨ esa' wannɨ pe te'san esa' wannɨ pe te'san nɨ nɨrɨ ewa'nomato' oton. Iwankan mɨrɨ awonsi'kɨ tʉrʉ'pʉnʉ e'to' oton pata ton yau'ne. ");
INSERT INTO akeNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tanporo serɨ ton esi mɨrɨ e'tinkan entun nɨto' pe kasa. ");
INSERT INTO akeNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Mɨrɨ a'tai ɨtʉto' oton kon ɨkota'mato' kon pe mɨrɨ awonsi'kɨ uma'tan nɨto' ya'. Tanporo tʉpataron kon uya ɨyewaruma'tɨto' oton kon urɨ uriya'. ");
INSERT INTO akeNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mɨrɨ a'tai si, tu'kan kon nɨ ka'pon amʉ' uyapurɨ pɨ' te'san e'nonkato' oton, tu'kan kon nɨ ka'pon amʉ' uya tʉtonpa kon eparankato' oton, mɨrɨ awonsi'kɨ to' ewaruma'tɨto' oton. ");
INSERT INTO akeNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mɨrɨ yau si, tu'ke rɨ enku'tɨnin nan pu'kena' amʉ' usenpoikato' oton, mɨrɨpan kon uya tu'kan kon nɨ enku'tɨto' oton. ");
INSERT INTO akeNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Apʉne pʉra eke pe rɨ ɨri epamʉ uriya', tu'kan kon nɨ usi'nʉnkato' e'nɨ'panto' oton. ");
INSERT INTO akeNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","E'tane kʉrɨ rɨ pana' pe te'sen tʉnapurɨnʉ yau iu'matʉ pʉ'kʉ pona, kʉrɨ rɨ si epika'tɨto' oton. ");
INSERT INTO akeNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Serɨ Papa e'to' esa' wannɨ pe ekareei usekamato' oton pata emʉ' kaisa rɨ, ennin nʉ'san uya ekama tanporo ka'pon amʉ' pɨ', mɨrɨ a'tai kuru nin si, iu'matʉ e'seporo mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“‘Ɨri Kuru Nuirapanin Uma'tan Emapu'tɨnin’ e'soto'kasa' wakʉ pata yau ene auya'nokon a'tai si, pu'kena' Taniyerʉ nekama'pʉ rʉ'pʉ — tɨwɨ serɨ ennin nʉto'ka'nʉkʉi — ");
INSERT INTO akeNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","tɨwɨ si kamoro Isutiya pon kon nainʉmʉi wʉ' ton pona'ne. ");
INSERT INTO akeNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ɨnʉ' rɨ tiwʉ' nakapu po te'sen kʉu'tɨnin ɨ'rɨ rɨ anʉnse'na tiwʉ' tapai. ");
INSERT INTO akeNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ɨnʉ' rɨ tʉmainarʉ yau te'sen kʉ'tɨnin tiwʉ' ta' tʉpon epose'na. ");
INSERT INTO akeNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mɨrɨ wʉi a'tai'ne, ɨsɨ pe kuru rɨ uri'sami'si amʉ', mono' pe te'san pona iye'to' oton mɨrɨ awonsi'kɨ mana' pokon kon imunkɨ pona! ");
INSERT INTO akeNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ɨpʉrematɨ' ɨutɨto' kon esi namai' komi' pata weyu a'tai, mɨrɨ pe pʉra Sapa' a'tai. ");
INSERT INTO akeNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Apʉne pʉra mɨrɨ a'tai eke rɨ usewankaman e'to' oton pena pata epiya'tɨ'pʉ si'kɨrɨ iye'ku'sa' rʉ'pʉ kasa pʉra rɨ serɨ pʉ'kʉ pona, mɨrɨ awonsi'kɨ mɨrɨ kasa iye'to' oton pen nɨ kanan serɨ enta'. ");
INSERT INTO akeNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mɨrɨ weyu u'tɨsa' pʉra iyesi yau inke pʉra, ɨnʉ' ne'nonkai'no pen nɨ moro, e'tane kamoro, Papa nanʉmʉ'san pɨkɨrɨ iweyu to'kena'mato' iya oton. ");
INSERT INTO akeNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Mɨrɨ a'tai ɨnʉ' uya rɨ ta pe iyesi yau ɨpɨ'nokon, ‘Kʉrai man serɨ yau,’ mɨrɨ pe pʉra, ‘Mɨrɨ yau man,’ ta a'tai ɨpɨ'nokon, kʉsapurɨtʉu. ");
INSERT INTO akeNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Apʉne pʉra enku'tɨnin nan kʉrai amʉ' mɨrɨ awonsi'kɨ enku'tɨnin nan pu'kena' amʉ' usenpoikato' oton, eke ton nɨ i'tuto' ipɨ' ton mɨrɨ awonsi'kɨ eke Papa tʉrawasooi ton ku'to' oton to' uya, Papa nanʉmʉ'san enku'tɨnin pe—ikupʉ tʉuya'nokon pe iyesi yau. ");
INSERT INTO akeNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Entɨ' ayauro'ka uya 'nokon serɨ ton pɨ' iweyu wapiya. ");
INSERT INTO akeNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ɨnʉ' uya rɨ ta pe iyesi yau, ‘Mɨrɨ yau man, rɨmono' tau,’ ta a'tai, kʉtɨtʉu; mɨrɨ pe pʉra, ‘Serɨ yau man, ɨutɨ a'mu yau,’ ta a'tai, kʉsapurɨtʉu. ");
INSERT INTO akeNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Apʉne pʉra kamiri' nʉye'ai'ne' wʉi enu uyepʉ winɨ nʉsenyai'ne' wʉi enu utɨto' pona rɨ kasa, mɨrɨ kasa kuru Ka'pon, Papa winon uyepʉ e'to' oton mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Eke' airɨ rɨ anwana amʉ' amʉrato' oton,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Inke pʉra rɨ, usewankaman pata'pʉ pe, “‘Wʉi enu ewarumanto' oton, mɨrɨ awonsi'kɨ kapʉi e'wei'tɨto' oton pen; Sirikɨ amʉ' uta'po'to' oton ka' apai, mɨrɨ awonsi'kɨ ka' po te'sen ton nɨ e'tʉkʉukato' oton.’ ");
INSERT INTO akeNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Mɨrɨ a'tai, Ka'pon, Papa winon uyepʉ i'tuto' ipɨ' usenpoikato' oton ka' yau, mɨrɨpan tanporon kon non pon kon ukaranto' oton tʉuta'kwarʉkai'. To' uya Ka'pon, Papa winon uyepʉ kapuru' po, ka' yau ento' oton, tʉmeruntɨrʉ ke mɨrɨ awonsi'kɨ eke a'kwa yau. ");
INSERT INTO akeNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mɨrɨpan uya tinserʉʉi ton enno'to' oton eke wai tʉronpi' turunpa pe, mɨrɨpan kon uya mɨ a'setun uye'to' yawɨron kon nɨ inanʉmʉ'san amʉranʉ'to' oton, ka' pʉ'kʉ awɨron kon nɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ɨsenupatɨ' serɨ pi' e' pɨ': Emenna' pe ipanta ton mɨrɨ awonsi'kɨ iyare a'ta a'tai, i'tu auya'nokon wʉi uye'kapʉ a'ko pe tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mɨrɨ kasa rɨ marɨ tanporo serɨ ton e'kupʉ ene auya'nokon a'tai, i'tu auya'nokon a'ko pe iyesi, mʉra'ta nau rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","I'napairon ekama uya ɨpɨ'nokon, serɨ a'taino kon kuru rɨ pʉra iyenato' oton pen nɨ tanporo serɨ ton e'kupʉ pʉ'kʉ pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Epʉn mɨrɨ awonsi'kɨ non pʉra iyenato' oton, e'tane umaimu mɨrɨ tereuta ton pen nɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ɨnʉ' uya mɨrɨ wʉi mɨrɨ pe pʉra iwekusi i'tu pʉra rɨ iyesi; inserʉ amʉ' Epʉn pon kon uya rɨ, mɨrɨ pe pʉra imu uya rɨ e'tane ikʉipʉnʉ uya rɨken serɨ i'tu. ");
INSERT INTO akeNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nowa a'tai iyesi'pʉ na'ne' kasa, mɨrɨ kasa iye'to' oton Ka'pon, Papa winon uyepʉ a'tai. ");
INSERT INTO akeNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Apʉne pʉra wʉi ton i'mʉnpʉ rawɨron yau, ka'pon amʉ' esi'pʉ uta're'tɨn pɨ', emari'man pɨ' mɨrɨ awonsi'kɨ e'tʉrʉn pɨ' emari'man nɨto' yau, Nowa ewomʉ a' ya' weyu pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ɨ'rɨ rɨ te'ku'ton i'tu to' uya pʉra rɨ iyesi'pʉ i'mʉnpʉ uyepʉ pʉ'kʉ pona rɨ, mɨrɨpan kon arɨ'pʉ iya tanporo rɨ. Mɨrɨ kasa rɨ marɨ iye'to' oton, Ka'pon, Papa winon uyepʉ a'tai. ");
INSERT INTO akeNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Asa'ron kon ka'pon amʉ' e'to' oton umɨ yau; tikin nɨ itanʉnto' oton, isakon e'nɨnto' oton. ");
INSERT INTO akeNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Asa'ron kon uri'sami'si amʉ' e'to' oton a'nai' e'pa pɨ'; tikin nɨ itanʉnto' oton, isakon e'nɨnto' oton. ");
INSERT INTO akeNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Mɨrɨ pe iyesi pɨ', enei'ma e'tɨ', apʉne pʉra i'tu auya'nokon kasa pʉra ɨ'rɨ a'tai ɨyepuru kon uyepʉ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","E'tane se ito'ka'nʉ'tɨ': Ɨutɨ esa' uya mɨrɨ a'tai kuru ewarupɨ nau ama' uyepʉ tukai' i'tusa' yau, tenu ke iyesi'pʉ nesii'no, mɨrɨpan tiwʉ' ta' ewon nɨ kuu'pʉ iya nesii'no pen. ");
INSERT INTO akeNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mɨrɨ pe iyesi pɨ', ɨmɨrɨ'nokon kanan tekonekai' me'tʉi', apʉne pʉra Ka'pon, Papa winon uye'to' oton itenupɨkɨrɨ pʉra rɨ ɨwe'tane'nokon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ɨnʉ' ken usauro'nɨ'pʉ awɨron mɨrɨ awonsi'kɨ emiya'pokena' ipoitorʉ pe nai itesa' nʉnonka'pʉ tiwʉ' tawon kon tʉpoitorʉ ton esa' pe to' i'kiyari ke to' repanin pe itʉto' weyu a'tai? ");
INSERT INTO akeNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Wakʉ pe rɨ kʉrɨ rɨ ipoitorʉ e'to' oton itepuru neporonʉ ikupʉ pɨ' tenna'posa' a'tai. ");
INSERT INTO akeNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","I'napairon ekama uya ɨpɨ'nokon; itepuru uya tanporon nɨ tapuruui esa' pe iku'to' oton. ");
INSERT INTO akeNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","E'tane si, a'tai pʉra kʉrɨ rɨ ipoitorʉ esi ɨri pe, mɨrɨpan uya, ‘Uyepuru uko'mamʉ serɨ sunwa inke rɨ,’ ta, ");
INSERT INTO akeNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","mɨrɨpan e'sara'tɨ tʉron kon ipoitorʉ ton panta'ma pɨ' mɨrɨ awonsi'kɨ enta'nan pɨ' mɨrɨ awonsi'kɨ e'taripan pɨ' te'taripasan pokon pe. ");
INSERT INTO akeNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kʉrɨ rɨ ipoitorʉ epuru uye'to' oton wʉi a'tai itenupɨkɨrɨ iye'tane pʉra, mɨrɨ a'kʉra' iyepʉ ta tane iya pʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mɨrɨpan uya ipɨrʉkato' oton, mɨrɨ awonsi'kɨ inonkato' iya oton wakʉ pe te'ku'san pata'se' ya'. Mɨrɨ yau nin si, ipan pe ukaran nɨ pɨ' mɨrɨ awonsi'kɨ tʉyɨ ton kɨtɨtɨi'ma pɨ' iye'to' oton,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Miyarɨ rɨ Sises uya tʉpoitorʉ ton auro'ka'pʉ. “Mɨrɨ a'tai si, Papa e'to' esa' wannɨ pe e'to' oton mɨrɨ se kasa; moine warawo' emari'ma ense'na 10 kaisaron kon uri'sami'si amʉ' utɨ'pʉ tʉraan'puui ke'ne. ");
INSERT INTO akeNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","5 kaisaron kon uri'sami'si amʉ' esi'pʉ ita'kwarʉ pʉra, mɨrɨ awonsi'kɨ 5 kaisaron kon kanan esi'pʉ ta'kwarʉ ke. ");
INSERT INTO akeNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ita'kwarʉ pʉ' nan uya tʉraan'puui kon arɨ'pʉ, e'tane iparu u'ma'sa' a'taino arɨ'pʉ to' uya pen nɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","E'tane ta'kwarʉkena' nan uya tʉraan'puui kon arɨ'pʉ iparu u'ma'sa' a'taino a'kɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Inke rɨ to' enurikʉ'pʉ kʉrɨ rɨ temari'masen uyepʉ i'se, mɨrɨpan kon ena'pʉ e'moronʉ' pe, mɨrɨpan kon nin si e'nʉmʉ'pʉ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Anomʉra' a'tai nin si, ka'pon uya eke pe ekama'pʉ mɨrɨ, ‘Temari'masen si uye'nɨ pɨ' man! Entanʉ'tɨ' si!’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Kamoro si uri'sami'si amʉ' usenpaka'pʉ mɨrɨ, mɨrɨpan kon e'mʉ'sa'ka'pʉ tʉraan'puui kon po'tɨse'na. ");
INSERT INTO akeNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Iya'kwarʉ pʉ' nan uya ta'kwarʉkena' nan pɨ', ‘Ina raan'puui paru oton ke ina irepatɨ', ina raan'puui usenkʉ'nʉ' nɨ pɨ' man,’ ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“E'tane kamoro uya, ‘Kane, eke pe pʉra rʉ'kwɨ iparu man; ukaisarɨ'nokon pʉra man,’ ta'pʉ to' uya. ‘E'tane ru'ku, siya'pu ta' araan'puui kon paru ɨne'matantɨ' ɨiwano' kon pe,’ ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Utɨn pɨ' rɨ nin si to' e'tane tʉraan'puui kon paru ennai', temari'masen uye'kaa'pʉ mɨrɨ. Kamoro nin si iyekonekasa' kon uri'sami'si amʉ' ewomʉ'pʉ mɨrɨ temari'masen a'kɨrɨ ata're'tɨse'na. Mʉra'ta nin si uta'koro'pʉ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Emennʉ'pʉ rɨ kamoro nin si uyee'pʉ mɨrɨ, mɨrɨpan kon uya ta'pʉ, ‘Ina epuru, mʉra'ta a'kokakɨ ina iwano' pe!’ ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“E'tane to' eikʉ'pʉ iya, ‘I'napairon ekama uya ɨpɨ'nokon, ɨi'tu uya 'nokon pʉra man,’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Mɨrɨ pe iyesi pɨ', enei'ma e'tɨ'; apʉne pʉra iweyu mɨrɨ pe pʉra iwekusi i'tu auya'nokon pʉra iyesi pɨ',” ta'pʉ Sises uya tʉpoitorʉ ton pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Mɨrɨ awonsi'kɨ kanan, ka'pon tʉutɨsen kasa iye'to' oton, tʉpoitorʉ ton kɨ'manin mɨrɨpan kon ena' timamin tʉnin. ");
INSERT INTO akeNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tikin nan ena' 5 kaisa rɨ ipaikii pʉrata tʉrʉ'pʉ iya, tʉron nɨ ena' asa'rɨ ipaikii tʉrʉ'pʉ iya, mɨrɨpan kon tonpa ena' tikin nɨ ipaikii pʉrata tʉrʉ'pʉ iya. To' repa'pʉ iya mɨrɨ to' uya ikupʉ poken iyesi ti'tui', mɨrɨpan nin si utɨ'pʉ tʉutɨto' ya'. ");
INSERT INTO akeNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kʉrɨ rɨ si 5 kaisaron paiki pʉrata eponin nʉ'pʉ utɨ'pʉ inke pʉra rɨ mɨrɨ pʉrata e'tonpa'tɨto' pe itʉrawasomase'na, emennʉ'pʉ tʉpoi'ne rɨ nin si, 5 kaisarɨ rɨ marɨ iye'tonpa'tɨsa' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mɨrɨ kasa rɨ marɨ, asa'rɨ ipaikii eponin nʉ'pʉ utɨ'pʉ inke pʉra rɨ mɨrɨ pʉrata e'tonpa'tɨto' pe itʉrawasomase'na, mɨrɨpan uya asa'rɨ rɨ marɨ paikii tonpa'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","E'tane nin si, kʉrɨ tikin nɨ paiki eponin nʉ'pʉ utɨ'pʉ, non aka'pʉ iya, mɨrɨpan uya tepuru pʉrataai onamʉ'pʉ iya'. ");
INSERT INTO akeNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Inke rɨ tʉuko'mamʉ tʉpo, to' epuru enna'po'pʉ to' piya', mɨrɨpan uya to' pokon pe tʉpʉrataai eseru koneka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","5 kaisa rɨ eponin nʉ'pʉ uya 5 kaisarɨ rɨ marɨ ipona tʉneporo'pʉ tʉrʉ'pʉ itena'. ‘Uyepuru, 5 kaisa rɨ ipaikii urepa'pʉ auya, mɨrɨpan tonpa'tɨsa' uya man mɨrɨ rɨ tʉtʉrawasomai', 5 kaisarɨ rɨ marɨ ipona,’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“‘Wakʉ kuru rɨ ku'sa' auya man, upoitorʉ, wakʉ mɨrɨ awonsi'kɨ usauro'nɨsa' awɨron! Tu'kan pen nʉ'kwɨ rɨ pɨ' yawɨrɨ ɨwe'sa' man. Mɨrɨ pe iyesi pɨ', tu'kan nɨ esa' pe ɨnonka uya. Ɨsi'kɨ upiya' pori' pe e'tanʉ'kɨ ɨyepuru pokon pe!’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Asa'rɨ ipaikii pʉrata eponin nʉ'pʉ uyee'pʉ tepuru piya', ‘Uyepuru, asa'rɨ ipaikii pʉrata urepataine' tonpa'tɨsa' uya man mɨrɨ rɨ tʉtʉrawasomai', asa'rɨ rɨ marɨ ipaikii ipona,’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Itepuru uya ta'pʉ ipɨ', ‘Wakʉ kuru rɨ ku'sa' auya man, upoitorʉ, wakʉ mɨrɨ awonsi'kɨ usauro'nɨsa' awɨron! Tu'kan pen nʉ'kwɨ rɨ pɨ' yawɨrɨ ɨwe'sa' man. Mɨrɨ pe iyesi pɨ', tu'kan nɨ esa' pe ɨnonka uya. Ɨsi'kɨ, pori' pe ɨyepuru esi pokon pe e'tanʉ'kɨ,’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Kʉrɨ rɨ si tikin nɨ pʉrata paikii eponin nʉ'pʉ uyee'pʉ, mɨrɨpan uya ta'pʉ tepuru pɨ', ‘Uyepuru, ɨi'tu uya, sa'man pe rɨ te'sen pe ɨwesi. Ɨnpɨmɨ'pʉ pen nɨ anʉnnin pe ɨwesi, ite' ɨntʉrʉ'pɨtʉ'pʉ pen nɨ amʉranʉ'nin pe ɨwesi. ");
INSERT INTO akeNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mɨrɨ pɨ', enari'nʉmʉ'pʉ, mɨrɨpan pɨ' ɨpʉrataai onanse'na utɨ'pʉ non ya'. Se si ɨiwano' pe te'sen,’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Mɨrɨpan pɨ' ta'pʉ itepuru uya, ‘Ɨmɨrɨ, emiya'ne' rɨ ipoitorʉ! I'tu auya si unpɨmɨ'pʉ pen nɨ anʉnnin pe esi, ite' untʉrʉ'pɨtʉ'pʉ pen nɨ amʉranʉ'nin pe esi? ");
INSERT INTO akeNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Upʉrataai rɨ sa'ne mʉtʉrʉi'no pʉrata e'tonpa'tɨto' iwʉ' ta'; enna'posa' a'tai, iye'tonpa'tɨsa' simo'kai'no,’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“‘Mɨrɨ pʉrata paikii imo'katɨ' itenapai, mɨrɨpan itʉtɨ' kʉrɨ 10 kaisaron pʉrata paikii esa' ena'. ");
INSERT INTO akeNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Apʉne pʉra tanporon kon itesa' pe na'ne' nan nɨ repa, miyarɨ ipona rɨ, mɨrɨpan esa' pe iye'to' oton eke pe rɨ. Ɨnʉ' rɨ kʉrɨ itesa' pe pʉra na'ne' enapai, itenau rʉ'kwɨ rɨ na'ne' emo'ka mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mɨrɨpan ɨri rɨ poitorʉ eno'ma pʉroroi pona, ewarupɨ ya'. Mɨrɨ yau, ukaran nɨ pɨ' mɨrɨ awonsi'kɨ tʉyɨ kɨtɨtɨi'ka pɨ' iye'to' pe,’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ka'pon, Papa winon uyepʉ a'tai tʉmeruntɨrʉ yau, mɨrɨ awonsi'kɨ tinserʉʉi amʉ' pokon pe, iyereutato' oton tapon po. ");
INSERT INTO akeNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tanporo rɨ tʉpataron kon amʉrato' oton irau, mɨrɨpan uya ka'pon amʉ' menka, karimeru amʉ' pa'simanin uya karimeru amʉ' menka kasa kapirita amʉ' piyapai. ");
INSERT INTO akeNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Karimeru amʉ' tʉrʉ iya mɨrɨ tenwo'netʉ winɨkʉi', mɨrɨ awonsi'kɨ kapirita amʉ' tʉkamisi winɨkʉi'. ");
INSERT INTO akeNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Mɨrɨ a'tai si, ta iya mɨrɨ tenwo'netʉ winɨ te'san pɨ', ‘Ɨsi'tɨ' ɨmɨrɨ'nokon ukʉipʉnʉ nʉpʉrema'san. Ananʉmʉnʉ kon anʉntɨ', serɨ si ɨyesa' kon pe e'nɨto' yau iyekonekasa' rʉ'pʉ pata e'kaa'pʉ si'kɨrɨ rɨ, ");
INSERT INTO akeNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","apʉne pʉra iwan pe esi a'tai, urepa'pʉ auya'nokon ui'kiyari ke; tuna'kiri' ke esi a'tai, uwo'pa'pʉ auya'nokon; ka'kʉran pe rɨ e'tane, ukɨ'ma'pʉ auya'nokon ɨiwʉ' kon ta'. ");
INSERT INTO akeNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ipon pʉra esi a'tai, urepa'pʉ auya'nokon upon ke; takuru'ke esi a'tai, umainanpa pɨ' ɨwesi'pʉ kon; pariki'si tau esi a'tai, uka'kʉranpase'na ɨutɨ'pʉ kon,’ tato' iya oton. ");
INSERT INTO akeNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Mɨrɨ a'tai si, ipokena' ton uya ta mɨrɨ ipɨ', ‘Uyepuru, ɨ'rɨ a'tai si iwan pe ina uya ɨyene'pʉ, mɨrɨpan ina uya ɨyewekʉ'pʉ; mɨrɨ awonsi'kɨ tuna'kiri' ke, mɨrɨpan o'pa'pʉ ina uya? ");
INSERT INTO akeNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ɨ'rɨ a'tai ka'kʉran pe ina uya ɨyene'pʉ, mɨrɨpan ɨkɨ'ma'pʉ ina uya tiwʉ' kon ta'? Ɨ'rɨ a'tai ipon pʉra ina uya ɨyene'pʉ, mɨrɨpan ɨpontɨ'pʉ ina uya? ");
INSERT INTO akeNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ɨ'rɨ a'tai rɨ takuru'ke mɨrɨ pe pʉra pariki'si tau ɨwe'tane, ina utɨ'pʉ aka'kʉranpai'?’ tato' oton to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Mɨrɨ a'tai nin si, kin uya ta mɨrɨ to' pɨ', ‘I'napairon ekama uya ɨpɨ'nokon, ɨ'rɨ rɨ ku'sa' auya'nokon na'ne' pʉsamoro sepa' nan nʉ'kwɨ kuru utonpa ton pe te'san pɨ', urɨ pɨ' iku'sa' auya'nokon pe iyesi,’ tato' iya oton. ");
INSERT INTO akeNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Mɨrɨ a'tai ta iya mɨrɨ, tʉkamisi winon kon pɨ', ‘Atamatɨ' upiyapai, ɨmɨrɨ'nokon Papa nʉpa'nʉkʉ'san! Entantɨ' apo' ya', Papa nʉkoneka'pʉ makoi mɨrɨ awonsi'kɨ itinserʉʉi ton iwano' pe! ");
INSERT INTO akeNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Apʉne pʉra iwan pe e'tane, urepasa' auya'nokon pʉra iyesi ui'kiyari ke; tuna'kiri' ke e'tane, uwo'pa'pʉ auya'nokon pʉra iyesi; ");
INSERT INTO akeNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ka'kʉran pe e'tane, ɨiwʉ' kon ta' ukɨ'masa' auya'nokon pʉra iyesi; upon i'se e'tane, upon ke urepasa' auya'nokon pʉra iyesi; takuru'ke e'tane, umainanpasa' auya'nokon pʉra iyesi; pariki'si tau e'tane, uka'kʉranpai' ɨutɨsa' kon pʉra iyesi,’ tato' iya oton to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Mɨrɨ a'tai, to' uya rɨ marɨ ei'to' oton, ‘Ina epuru, ɨ'rɨ a'tai rɨ si ina uya ɨyene'pʉ iwan pe, tuna'kiri' ke, mɨrɨ pe pʉra ka'kʉran pe, mɨrɨpan ina uya asanomasa' pʉra iyesi? Ɨ'rɨ a'tai rɨ si ɨpon i'se, takuru'ke mɨrɨ pe pʉra pariki'si tau ɨwe'tane, ina uya ɨpika'tɨsa' pʉra iyesi?’ tato' oton. ");
INSERT INTO akeNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Mɨrɨ a'tai si, to' eikʉ iya mɨrɨ, ‘I'napairon ekama uya ɨpɨ'nokon, ɨ'rɨ rɨ ku'sa' auya'nokon pʉra na'ne', pʉsamoro sepa' nan nʉ'kwɨ kuru utonpa ton pe te'san pɨ', urɨ pɨ' iku'sa' auya'nokon pe pʉra rɨ iyesi.’ ");
INSERT INTO akeNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Mɨrɨpan kon utɨto' oton tɨwɨrɨ rɨ ekota'man nɨto' ya', e'tane ipokena' ton pe iye'sa' kon utɨto' oton tɨwɨrɨ rɨ uko'man nɨto' ya',” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tanporo si serɨ ton ekama tʉuya tʉpo, Sises uya ta'pʉ tʉpoitorʉ ton pɨ', ");
INSERT INTO akeNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mi'tuyatʉi'ne' kasa rɨ To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ esi awanapai rɨ ema'sa' yau. Ka'pon, Papa winon tʉto' oton ipokapɨ'to' pe kurusu' pona,” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mɨrɨ tʉpo si, use'man nɨto' tʉrawasomanin nan epuru ton mɨrɨ awonsi'kɨ Esuwerʉ amʉ' epuru ton amʉra'pʉ. To' e'seporo'pʉ Kaya'pas pata'se' yau, use'man nɨto' tʉrawasomanin nan epuru eke pe kuru te'sen. ");
INSERT INTO akeNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","To' e'kama'pʉ ama'ai Sises a'si pɨ' iwɨto' pe tʉuya'nokon. ");
INSERT INTO akeNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“E'tane iweyu rʉ'pʉ a'tai pen. Mɨrɨ ku'sa' pe iyesi yau, ka'pon amʉ' uya nin urɨ'nokon ewa'noma mɨrɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Sises esi koro'tau Pe'tani po, Saiman, erekʉ'pan tukai' ti'tusen iwʉ' tau, ");
INSERT INTO akeNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","uri'san uyee'pʉ po'toro arapasta yawon po'piyun epe'kena' kuru rɨ esa' pe, mɨrɨpan uya a'koka'pʉ Sises i'pai pona ima'pʉ iya, tʉteire' po tenai' tepʉrʉ piyau iyesi koro'tau. ");
INSERT INTO akeNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ipoitorʉ ton uya serɨ ensa' a'tai, to' usakorota'pʉ, mɨrɨpan kon uya, “Ɨ'rɨto' pe ima'tanʉkʉ iya?” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Serɨ po'piyun kʉrʉpo'pomai'no sa'ne epe'kena' pe, mɨrɨpan epe'pʉ tʉrʉi'no entu'manin nan ena'!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Sises uya to' i'tusa' esi'pʉ, mɨrɨpan uya ta'pʉ to' pɨ', “Ɨ'rɨ to' pe pʉse rɨ uri'san a'pɨ'pɨtʉ auya'nokon? Wakʉ rɨ ku'sa' iya mɨrɨ upɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tɨwɨrɨ rɨ entu'manin nan esi ɨpiyau'nokon, e'tane tɨwɨrɨ rɨ urɨ esi pʉra iyesi ɨpiyau'nokon. ");
INSERT INTO akeNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Serɨ po'piyun masa' iya upona iku'sa' iya mɨrɨ upun koneka pe uwu'na'tɨ e'ma ta'. ");
INSERT INTO akeNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","I'napairon ekama uya ɨpɨ'nokon, itekare nʉsekamayai'ne' airɨ rɨ pata emʉ' kaisa rɨ inkupʉ'pʉ rʉ'pʉ rɨ marɨ usekama mɨrɨ, en yau ikupʉ pe rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","12 kaisaron kon ipoitorʉ ton tonpa, Isutas Eskariya' tato' ipɨ', utɨ'pʉ use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru piya'. ");
INSERT INTO akeNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Ɨ'rɨ ke uye'ma auya'nokon ɨyena'nokon itʉsa' uya yau?” ta'pʉ iya to' pɨ', mɨrɨpan kon uya 30 kaisa rɨ sirʉpa pʉrata pun i'tu'pʉ itiwano' pe. ");
INSERT INTO akeNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mɨrɨ si'kɨrɨ Isutas esi'pʉ itʉto' tʉuya weyu eporo i'se. ");
INSERT INTO akeNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","A'sarutanʉ'sa' Pen Pʉreti Pɨ' Enta'nan Weyu e'sara'tɨ a'tai, Sises poitorʉ ton uyee'pʉ ipiya' ekama'pose'na, “Nai yau kuru ina uya To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ pɨ' ɨyenta'nato' koneka ina uya i'se me'an?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","To' eikʉ'pʉ iya, “Entantɨ' eke pata Surusiran pona ka'pon piya', mɨrɨpan pɨ', ‘Ti'sa uya tasa' man, “Papa nʉkoneka'pʉ uweyu e'seposa' man, a'ko pe. Mɨrɨ pe iyesi pɨ', urɨ mɨrɨ awonsi'kɨ upoitorʉ ton pokon pe To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ kupʉ uya ɨiwʉ' tau,” tukai',’ mekamatʉi' ipɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ipoitorʉ ton uya mɨrɨ kasa rɨ nin si To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ pɨ' te'to' kon koneka'pʉ, ta'pʉ iya na'ne' awɨrɨ rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pata uko'mansa' a'tai, Sises esi'pʉ tʉteire' po tenai' 12 kaisaron kon pokon pe tepʉrʉ piyau. ");
INSERT INTO akeNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","To' enta'na koro'tau, ta'pʉ iya to' pɨ', “I'napairon ekama uya ɨpɨ'nokon; ɨtonpa kon uya uyeparankato' oton,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mɨrɨpan kon upokoita'pʉ, to' uya tʉkaisarɨ'nokon, “I'napai rɨ, uyepuru, urɨ pen kuru rɨ nin!” ta'pʉ Sises pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Sises uya ta'pʉ, “Kʉrɨ tʉyu ki'ai'ne' pʉsau ya' upokon pe uya uyeparankato' oton. ");
INSERT INTO akeNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ka'pon, Papa winon utɨto' oton tʉpɨ' imenukasa' na'ne' kasa rɨ, e'tane ɨsɨ yau rɨ kʉrɨ rɨ ka'pon esi Ka'pon, Papa winon eparankanin. Wakʉ pe nesii'no iyentusa' pʉra iyesi yau,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mɨrɨpan Isutas, eparankanin oton uya nin si ta'pʉ, “Rapai, i'napai rɨ, urɨ pen kuru rɨ nin,” ta'pʉ iya. “Ewai', ɨmɨrɨ rɨ,” tukai' Sises uya eikʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","To' enta'na koro'tau rɨ, Sises uya pʉreti anʉmʉ'pʉ, mɨrɨpan uya tenki ta'pʉ Papa pɨ'. I'kwɨ'pɨtʉ'pʉ iya, mɨrɨpan ekamʉ'pʉ iya tʉpoitorʉ ton ena', tai'ma to' pɨ', “Anʉntɨ', mɨrɨpan ɨ'tɨ'. Serɨ serɨ upun,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Mɨrɨpan uya ko', waain yen anʉmʉ'pʉ, mɨrɨpan uya tenki ta'pʉ Papa pɨ'. To' ena' itʉrʉ'pʉ iya, tai'ma to' pɨ', “Se yawon ensitɨ', ɨmɨrɨ'nokon. ");
INSERT INTO akeNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Serɨ serɨ emenna' ekonekan nɨto' iwano' umʉnʉ, tu'kan kon iwano' pe rɨ iye'kwansa' makoi ton pɨ' usentu'man nɨto' pe. ");
INSERT INTO akeNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ekama uya serɨ enta' iteperu euku ensito' uya oton pen ɨpokon pe 'nokon ukʉipʉnʉ e'to' esa' wannɨ pe yau emenna' pe ensi uya pʉ'kʉ pona,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Eren pɨ' tʉuserenka kon tʉpo, to' utɨ'pʉ Are' Wʉpʉ pona. ");
INSERT INTO akeNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mɨrɨ a'tai, Sises uya to' pana'tɨ'pʉ, “Serɨ ewarupɨɨi tau kuru, tanporo rɨ unɨmɨ auya'nokon mɨrɨ, te'ku'sen upɨ' wenai, apʉne pʉra iye'menukasa', “‘Karimeru amʉ' pa'simanin wɨnɨ uya mɨrɨ, mɨrɨpan karimeru amʉ' e'ta'nʉ'to' oton tamʉ' ke te'to' kon apai,’ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","E'tane e'mʉ'sa'kasa' tʉpo, utɨ mɨrɨ arawɨrɨ'nokon Kiyarari pona,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Mɨrɨ a'tai, Pi'ta uya, “Tanporon kon uya ɨnɨntane te'ku'sen ɨpɨ' wenai, urɨ uya nin ɨnonka pen mɨrɨ,” ta'pʉ Sises pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Sises uya imaimu eikʉ'pʉ, “I'napairon ekama uya ɨpɨ', serɨ ewarupɨɨi tau kuru, kɨrɨtɨkɨ uturumʉ rawɨrɨ, osorʉwau ite'kwa unonkato' auya oton,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","E'tane rɨ Pi'ta uya, “Uma'tato' pe rɨ aya'kɨrɨ, ɨnonka uya pen nɨ mɨrɨ,” ta'pʉ. Mɨrɨ kasa rɨ marɨ itonpa ton uya ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mɨrɨ a'tai, Sises utɨ'pʉ tʉpoitorʉ ton pokon pe Ke'semani tukai' tesa'sen pata ya', mɨrɨpan uya ta'pʉ to' pɨ', “Se airɨ ereutatɨ', mɨ airɨ ɨpʉremai' utɨ tane,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ta'kɨrɨ Pi'ta mɨrɨ awonsi'kɨ asa'rɨ Sepiti munkɨ amʉ' arɨ'pʉ iya, mɨrɨpan ena'pʉ pokoi pe mɨrɨ awonsi'kɨ ika'nɨ' pʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","“Uyewan man ika'nɨ' pʉra rɨ, e'tape'ne' pe rɨ iyesi uma'tanʉkʉ iya rɨ. Serɨ yau e'tɨ', uya'kɨrɨ tenu ke e'tɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Itɨ'pʉ miyarɨ parɨ ɨnnɨ iwa to' piyapai, mɨrɨpan uta'mo'ka'pʉ non pona temʉ' po, mɨrɨpan ɨpʉrema'pʉ, “Ukʉipʉnʉ, iye'kupʉ pe iyesi yau tɨwɨ upiyapai ko' nʉtamai, e'tane uyeseru awɨrɨ pen, e'tane ɨyeseru awɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mɨrɨpan enna'po'pʉ tʉpoitorʉ ton piya', mɨrɨpan uya to' e'nʉmʉ eporo'pʉ. Pi'ta ekama'po'pʉ iya, “Uya'kɨrɨ pe' ɨmɨrɨ'nokon warawoti'si amʉ' esi poken pʉra iyesi tenu ke mara rʉ'kwɨ rɨ?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","“Tenu ke esii'ma ɨpʉrematɨ', i'tupɨ'nɨto' ya' auta'mo'ka kon namai'. Iya'kwarʉ esi ɨnku'pai, e'tane ipun esi ɨ'sɨ'mʉra,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Sises enna'pokaa'pʉ iyakon ite'kwa pe ɨpʉremase'na. “Ukʉipʉnʉ, iye'kupʉ poken pʉra rɨ iyesi yau, serɨ ko' utama poken pʉra upiyapai ensi uya a'tai rɨken, tɨwɨ ɨyeseru ne'kupʉi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Iyenna'posa' a'tai kanan, to' rɨ marɨ e'nʉnpɨ'sa' eporo'pʉ iya, apʉne pʉra e'tape'ne' pe'ne to' enu pi'pɨ ton esi ke, ");
INSERT INTO akeNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","mɨrɨpan kon piyapai ɨpʉremaka'se'na kanan itɨ'pʉ itosorʉwano ite'kwa pe, wapiya tʉwɨpʉrema'pʉ kasa rɨ marɨ iyepʉrema'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Mɨrɨpan enna'po'pʉ tʉpoitorʉ ton piya', mɨrɨpan uya ta'pʉ to' pɨ', “Mɨrɨ si e'nʉn nɨ pɨ' rɨ mɨrɨ awonsi'kɨ umoronka'nɨ pɨ' rɨ ɨwesi kon? Apʉne entɨ'! Iweyu e'seposa' man! Ka'pon, Papa winon eparankasa' man tʉmakooikena' nan ena'! ");
INSERT INTO akeNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","E'mʉ'sa'katɨ'! Utɨnpai'nokon! Uyeparankanin si uye'ka'nɨ pɨ' man!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Usauro'nɨ pɨ' rɨ marɨ iyesi koro'tau, Isutas, 12 kaisaron kon tonpa pe te'sen uyee'pʉ. Ipokon pe anpisin kuru rɨ usepai'tɨpɨ'sa' supara ke mɨrɨ awonsi'kɨ wa'tana ke esi'pʉ, use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru mɨrɨ awonsi'kɨ ka'pon amʉ' epuru ton nennoko'san. ");
INSERT INTO akeNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Eparankanin uya tʉnku'ton ekamasa' esi'pʉ to' pɨ': “Kʉrɨ sa'su'kayai'ne' si kʉrɨ rɨ; ma'sitʉi',” tasa' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Isutas utɨ'pʉ Sises piya' to'sarɨ rɨ, mɨrɨpan uya ta'pʉ ipɨ', “Miyarɨ, Rapai!” mɨrɨpan a'su'ka'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Sises uya ta'pʉ ipɨ', “Utonpa, iku'se ɨuye'sa' na'ne' rɨ iku'kɨ,” ta'pʉ iya. Mɨrɨ a'tai, ka'pon amʉ' utɨ'pʉ Sises winɨkʉi' mɨrɨpan kon uya a'si'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mɨrɨ pɨ' tikin nan nɨ Sises tonpa ton tonpa uya tʉsuparaai mo'ka'pʉ, mɨrɨpan uya use'man nɨto' tʉrawasomanin nan epuru poitorʉ pana a'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Sises uya nin si ta'pʉ ipɨ', “Ɨsuparaai ina'poka'kɨ si ipata'pʉ ya'! Kamoro supara apurɨnin nʉ'san nɨ eri'to' oton esi mɨrɨ supara ke rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","I'tu auya'nokon pʉra rɨ iyesi mɨrɨ, ukʉipʉnʉ pɨ' ɨpʉremato', mɨrɨ a'tai upiya' 12 kaisa rɨ ite'kwa anpisin ton kuru rɨ inserʉ amʉ' enno'to' iya upika'tɨnin nan pe. ");
INSERT INTO akeNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","E'tane mɨrɨ ku'sa' uya pe iyesi yau, itekare uya ekamasa' na'ne' uta'ku'tɨ pʉra rɨ iyesi, mɨrɨ e'ku'to' oton tasa' iya na'ne',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mɨrɨ a'tai, Sises uya ta'pʉ anpisin pɨ', “Main awɨron kon pen pe' esa' pe esi serɨ, ɨuye'sa' kon na'ne' supara amʉ' mɨrɨ awonsi'kɨ wa'tana amʉ' esa' pe uya'sise'na? Wʉi kaisarɨ rɨ e'tai ko use'man nɨto', ɨpʉreman nɨto' iwʉ' pʉ'kʉ tau tereutai' ka'pon amʉ' enupa pɨ', uya'si auya'nokon pʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","E'tane tanporo rɨ serɨ e'ku'sa' pu'kena' amʉ' nʉmenuka'pʉ uta'ku'tɨto' pe,” ta'pʉ iya. Mɨrɨ a'tai si, tanporo ipoitorʉ ton uya inonka'pʉ, mɨrɨpan kon ainʉmʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kamoro, Sises a'sinin nʉ'san uya arɨ'pʉ Kaya'pas, use'man nɨto' tʉrawasomanin nan epuru piya', Main pɨ' enupanin nan mɨrɨ awonsi'kɨ Esuwerʉ amʉ' epuru ton amʉrasa' airɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","E'tane Pi'ta uya e'ma'pʉka'pʉ ɨnnonsi'kɨ rɨ, use'man nɨto' tʉrawasomanin nan epuru iwʉ' pʉrorooi pona, mɨrɨpan ewomʉ'pʉ, iyereuta'pʉ erasu ton piya' te'ku'sen ense'na. ");
INSERT INTO akeNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru mɨrɨ awonsi'kɨ tanporon kon nɨ Esuwerʉ amʉ' Konsʉrʉʉi ton esi'pʉ kasi pe rɨ Sises eseru'tɨto' warinpa pɨ', iyeri'to' ya' itʉto' pe tʉuya'nokon. ");
INSERT INTO akeNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","E'tane to' uya ɨ'rɨ rɨ iteseru eporo'pʉ pen nɨ mɨrɨ rɨ e'tane tu'ke rɨ kasi ye' pe tʉusauro'san esi'pʉ. Emennʉ'pʉ tʉpo rɨ, asa'ron kon ka'pon amʉ' uyee'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","mɨrɨpan kon uya si ekama'pʉ, “Pʉse rɨ uya ta'pʉ, ‘Papa iwano' use'man nɨto', ɨpʉreman nɨto' iwʉ' ma'tanʉkʉ uya mɨrɨ, mɨrɨpan konekato' pe uya kanan osorʉwau wʉi yau,’ ta'pʉ iya,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mɨrɨ a'tai si, use'man nɨto' tʉrawasomanin nan epuru e'soto'ka'pʉ Sises pɨ' tase'na, “Eikʉ auya pen nɨ pe' mɨrɨ? Ɨ'rɨ tukai' pʉsamoro ka'pon amʉ' usaurokʉ ɨpɨ'?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","E'tane Sises enkurumʉ'pʉ e'pana rɨ. Use'man nɨto' tʉrawasomanin nan epuru uya ta'pʉ ipɨ', “Ayapiyo'ma uya serɨ Papa tʉuko'mansen uya eta tane i'napairon pe ɨusekama pa ina pɨ'; Kʉrai pe pe' ɨwesi, Papa Mumu pe?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Sises uya imaimu eikʉ'pʉ, “Ewai', ta auya na'ne' kasa rɨ, e'tane tanporo ɨpɨ'nokon ta uya; Serɨ enta', Ka'pon, Papa winon ento' auya'nokon oton iyereutasa' Meruntɨ pe Te'sen enwo'netʉ winɨ, mɨrɨ awonsi'kɨ iyepʉ Epʉn poi kapuru' yau,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mɨrɨ a'tai, use'man nɨto' tʉrawasomanin nan epuru uya tʉpon karaka'pʉ, mɨrɨpan uya ta'pʉ, “Papa sapema pe isaurokʉ! Ɨ'rɨto' pe miyarɨ rɨ ekamanin nan i'se e'nɨ? Entɨ', Papa sapema pe isaurokʉ etasa' auya'nokon. ");
INSERT INTO akeNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ɨ'rɨ ken tukai' mɨsenuminkayatʉu?” ta'pʉ iya to' pɨ'. “Ima'tato' pe rɨ iyesi!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mɨrɨpan kon eta'tapɨtʉ'pʉ itemʉ' pona, mɨrɨ awonsi'kɨ to' uya tʉmokorooi kon ke iwɨnɨ'pʉ. Tʉron kon uya rɨ inta'mopɨtʉ'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","tai'ma, “Kʉrai, pu'kena' pe ekamakɨ ina pɨ'. Ɨnʉ' ɨwɨnɨi?” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pi'ta ereutasa' esi'pʉ Papa ena' use'man nɨto' tʉrawasomanin nan epuru iwʉ' pʉrorooi po, mɨrɨpan piya' to' poitorʉ, uri'san uyee'pʉ. “Ɨmɨrɨ sa'ne kʉrɨ rɨ ko Sises, Kiyarari pon a'kɨron nʉ'pʉ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","E'tane i'tunin pe pʉra iye'kuu'pʉ tanporo mɨrɨ yawon kon rau esii'ma. “I'tu uya pʉra rɨ man ɨ'rɨ pɨ' ausaurokʉ tukai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Mɨrɨpan utɨ'pʉ pʉroroi mʉra'taai pona. Mɨrɨ yau, tʉron nɨ uri'san uya kanan ene'pʉ, mɨrɨpan uya ka'pon amʉ' mɨrɨ yau te'san pɨ', “Pʉse rɨ kʉrɨ rɨ Sises, Nasare' pon a'kɨron nʉ'pʉ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","I'tunin pe pʉra kanan iye'ku'kaa'pʉ, Papa kuru tesa'pɨ'se: “Kʉrɨ rɨ i'tu uya pʉra man!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mara rɨ iyesi'pʉ tʉpo kamoro mɨrɨ yau te'soto'pɨ'se te'san utɨ'pʉ Pi'ta piya', tase'na ipɨ', “I'napai rɨ kuru rɨ ɨmɨrɨ kʉrɨ rɨ to' tonpa, ausaurokʉ eseru uya ɨyekama,” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mɨrɨ a'tai si, Pi'ta e'pa'nʉkʉ'pʉ tiwano' pe rɨ, mɨrɨpan uya, “Tɨwɨ Papa ukota'mai kasi pe usaurokʉ pɨ'. Kʉrɨ rɨ i'tu uya pʉra man!” ta'pʉ. Mɨrɨ ta iya a'tai rɨ, kɨrɨtɨkɨ uturumʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Mɨrɨ a'tai si, Pi'ta uya Sises maimu rʉ'pʉ nee'pʉ tenu ya', “Osorʉwau ite'kwa, ‘I'tu uya pʉra man,’ tato' auya oton, kɨrɨtɨkɨ uturumʉ rawɨrɨ!” tawon. Mɨrɨpan epa'ka'pʉ, mɨrɨpan ukaramʉ'pʉ ipan pe rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Awanakʉi' kuru, tanporo use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru mɨrɨ awonsi'kɨ Esuwerʉ amʉ' epuru ton ekoneka'pʉ Sises uma'tato' pe iku'to' tʉuya'nokon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","To' uya auronpɨtʉ'pʉ, mɨrɨpan arɨ'pʉ to' uya Paire', kopʉna ena'. ");
INSERT INTO akeNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Sises eparankanin nʉ'pʉ, Isutas uya si ensa' esi'pʉ mɨrɨ, to' uya ikonekasa' Sises uma'tato' pe, ipan pe rɨ ipokoita'pʉ Sises eparankasa' tʉuya pɨ', mɨrɨpan uya 30 kaisaron sirʉpa pun na'po'pʉ use'man nɨto' tʉrawasomanin nan epuru ton mɨrɨ awonsi'kɨ Esuwerʉ amʉ' epuru ton ena'. ");
INSERT INTO akeNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Umakoitasa' man, imakooi pʉn nɨ mʉnʉ teparankai',” ta'pʉ iya. “Ɨ'rɨ pe ken si mɨrɨ uya ina kupʉ? Ɨiwano' sa'ne mɨrɨ ko!” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Mɨrɨ wenai, Isutas uya pʉrata pun eno'ma'pʉ use'man nɨto', ɨpʉreman nɨto' iwʉ' pʉ'kʉ ta', mɨrɨpan enna'po'pʉ tiwano' pe rɨ e'sa'mase'na. ");
INSERT INTO akeNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Use'man nɨto' tʉrawasomanin nan epuru ton uya pʉrata pun amuku'pʉ, mɨrɨpan kon uya ta'pʉ, “Main, Mosi' winon nɨ pʉremekʉ pe iyesi mɨrɨ inonkasa' a'tai pʉrata yen ya', apʉne pʉra mʉn epe'pʉ pe iyesi ke,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Mɨrɨpan kon ekoneka'pʉ mɨrɨ pʉrata ke ɨinɨ ka'nin pata'se' e'mato' pe tukai'. Mɨrɨ si kupʉ'pʉ to' uya ka'kʉran amʉ' pe te'san eri'sa' u'na'tɨto' yau pe. ");
INSERT INTO akeNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mɨrɨ wenai, ka'pon amʉ' uya mɨrɨ pata esakʉ Mʉn Pata'se' tukai' serɨ pʉ'kʉ pona. ");
INSERT INTO akeNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Mɨrɨ si pu'kena' Iseremaya nekama'pʉ rʉ'pʉ pena rɨ uta'ku'tɨ'pʉ se tawon: “To' uya si 30 kaisa rɨ sirʉpa pun anʉmʉ'pʉ, Esuwerʉ amʉ' nʉkupʉ'pʉ itepe' pe, ");
INSERT INTO akeNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","mɨrɨpan kon uya mɨrɨ pʉrata ke ɨinɨ ka'nin nan pata'se' e'ma'pʉ, uyepuru uya uyapiyo'ma'pʉ awɨrɨ rɨ,” tawon. ");
INSERT INTO akeNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Mɨrɨ koro'tau rɨ Sises e'soto'kasa' esi'pʉ kopʉna Paire' piya', mɨrɨpan ekama'po'pʉ Paire' uya, “Esuwerʉ amʉ' kin pe' ɨmɨrɨ?” ta'pʉ iya. Sises uya imaimu eikʉ'pʉ, “Ewai', mʉkayai'ne' kasa rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru mɨrɨ awonsi'kɨ Esuwerʉ amʉ' epuru ton uya ɨri pe, kasi pe rɨ teseru'tɨ a'tai eikʉ'pʉ iya pen. ");
INSERT INTO akeNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mɨrɨ a'tai, Paire' uya ekama'po'pʉ, “Eta auya pʉra pe' iyesi ɨri pe to' usaurokʉ ɨpɨ'?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","E'tane Sises uya tikin nan pɨ' rɨ to' eikʉ'pʉ pen nɨ, ɨri pe to' uya tʉku'to' pɨ', kopʉna tewansiukai'. ");
INSERT INTO akeNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kopʉna eseru esi'pʉ ka'pon nonkato' pariki'si tapai to' enta'nato' weyu a'tai anpisin ton nanʉmʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mɨrɨ a'tai, tese ke te'sen a'sisa' pariki'si ta' esi'pʉ, Parapas tukai' tesa'sen. ");
INSERT INTO akeNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tu'kan kon amʉrasa' a'tai, Paire' uya to' ekama'po'pʉ, “Nai kʉrɨ rupɨ enpa'ka uya i'se me'atʉu ɨiwano' kon pe? Parapas, mɨrɨ pe pʉra Sises, Kʉrai tato' katɨ?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Apʉne pʉra tɨkɨnta kon pɨ' to' uya itʉsa' tena' tukai' i'tu tʉuya pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Eseru aimenkato' apon po Paire' ereutasa' koro'tau rɨ, ino'pʉ uya se main enno'sa' esi'pʉ ipiya': “Ɨ'rɨ pe kʉrɨ rɨ, ɨ'rɨ ku'nin nʉ'pʉ pen nɨ ka'pon kʉ'kupʉi. Ɨri pe serɨ pe tekota'mapɨ'se e'ne'pɨ'sa' man kʉrɨ rɨ uriya',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","E'tane use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru mɨrɨ awonsi'kɨ Esuwerʉ amʉ' epuru ton uya ka'pon amʉ' pori'ma'pʉ to' uya Parapas ekama'poto' pe inonkato' pe iya, Sises ma'tanʉkʉi'ma. ");
INSERT INTO akeNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kopʉna uya to' ekama'po'pʉ, “Nai kʉrɨ kuru nonka uya i'se me'atʉu ɨyena'nokon?” ta'pʉ iya. “Parapas,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Ɨ'rɨ pe ken si Sises, Kʉrai tato' ipɨ' kupʉ uya?” tukai' Paire' uya to' ekama'po'pʉ. Tanporon kon uya imaimu eikʉ'pʉ, “Kurusu' pona ipokapɨ'kɨ!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","“Ɨ'rɨto' pe? Ɨ'rɨ ɨri ku'sa' iya?” ta'pʉ Paire' uya. E'tane eke pe kuru to' ukɨ'pɨ'nʉnpɨtʉ'pʉ, “Kurusu' pona ipokapɨ'kɨ!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Paire' uya ene'pʉ ɨ'rɨ pe iku'to' iya awɨrɨ pʉra rɨ, e'tane ɨsɨ pe rɨ to' ena esi'pʉ. Tuna anʉmʉ'pʉ iya, mɨrɨpan isemiyakʉ'pʉ tu'kan kon rau esii'ma. “Tʉmakooi ke pʉra esi serɨ pʉse rɨ ka'pon mʉnʉ pɨ'. Ɨyenau'nokon nɨ iyesi mɨrɨ!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tanporon kon uya imaimu eikʉ'pʉ, “Tɨwɨ ina mɨrɨ awonsi'kɨ ina munkɨ amʉ' iwano' pe imʉnʉ nesii!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mɨrɨpan uya Parapas nonka'pʉ to' ena', e'tane ari'po'pɨ'to' pe Sises kupʉ'pʉ iya, mɨrɨ awonsi'kɨ itʉrʉ'pʉ iya kurusu' pona to' uya ipokapɨ'to' pe. ");
INSERT INTO akeNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kopʉna soisaai amʉ' uya si Sises arɨ'pʉ kopʉna pe e'nɨ iwʉ' ta', mɨrɨpan kon uya tu'kan kon nɨ soisa amʉ' amʉranʉkʉ'pʉ Sises woi. ");
INSERT INTO akeNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","To' uya iponka'pʉ, mɨrɨpan tʉtariren pon ke to' uya ipontɨ'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","mɨrɨpan kon uya tikʉ ke te'sen e'mepɨtʉ'pʉ aro', kʉron pe, mɨrɨpan ke to' uya arʉko'tɨ'pʉ. To' uya iyɨɨi'tɨ'pʉ itenwo'netʉ winon itemiyatʉ ya', mɨrɨpan kon e'sekunkapɨtʉ'pʉ irau, mɨrɨ awonsi'kɨ to' uya isapema'pʉ. “Miyarɨ, Esuwerʉ amʉ' kin!” ta'pʉ to' uya Sises pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","To' eta'tapɨtʉ'pʉ ipona; itɨɨi mo'ka'pʉ to' uya, mɨrɨ ke to' uya i'pai wɨpɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Isapema tʉpo, to' uya iponka'pʉ, mɨrɨpan pontɨ'pʉ to' uya ipon ya', mɨrɨpan arɨ'pʉ to' uya kurusu' pona ipokapɨ'se'na. ");
INSERT INTO akeNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","To' utɨ koro'tau, ka'pon Sairini winon, Saiman itese' eporo'pʉ to' uya, mɨrɨpan a'kwarʉka'pʉ to' uya kurusu' ato' pe iya. ");
INSERT INTO akeNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","To' uyee'pʉ pata Korʉko'ta tato' ya' (Pu'pɨ Ɨ'pʉ Rʉ'pʉ Pata ta e'kwa pe). ");
INSERT INTO akeNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Mɨrɨ yau, to' uya Sises o'pa'pʉ i'ne' ke waain tisumai'. Onpasa' tʉuya a'tai, ɨnensipai pʉra iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kurusu' pona ipokapɨ'sa' tʉuya'nokon a'tai, ipon nʉ'pʉ ta'nʉkʉ'pʉ to' uya te'wapiya'kapɨ'se, ");
INSERT INTO akeNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","mɨrɨpan kon ereuta'pʉ enpɨ'se'na. ");
INSERT INTO akeNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Iwɨto' iwenai menukasa' poka'pʉ to' uya i'pai epoi; sises pʉse rɨ, esuwerʉ amʉ' kin, tawon. ");
INSERT INTO akeNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Asa'ron kon ama' rʉ'san pokapɨtʉ'pʉ to' uya ipokon pe; tikin nɨ itenwo'netʉ winɨ mɨrɨ awonsi'kɨ ikamisi winɨ tikin nɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kamoro ipiyawɨrɨ tʉutɨsan uya ɨri pe isapema'pʉ, ti'pai kon sʉkʉsʉkʉma'pʉ to' uya, ");
INSERT INTO akeNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","mɨrɨ awonsi'kɨ ta'pʉ to' uya, “Ɨmɨrɨ, use'man nɨto', ɨpʉreman nɨto' iwʉ' a'morʉkanin, mɨrɨpan amɨ auya osorʉwawon wʉi yau, epika'tɨ'! Ɨu'tɨkɨ kurusu' poi, Papa Mumu pe ɨwesi yau!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mɨrɨ kasa rɨ use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru mɨrɨ awonsi'kɨ Main pɨ' enupanin nan mɨrɨ awonsi'kɨ Esuwerʉ amʉ' epuru ton uya rɨ isapema'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Tʉron kon pika'tɨ'pʉ iya, e'tane tiwa rɨ iyepika'tɨ pʉra iyesi! Esuwerʉ amʉ' kin sa'ne si! Tɨwɨ si nʉu'tɨi kurusu' poi, mɨrɨ awonsi'kɨ urɨ'nokon uya apurɨto' pe. ");
INSERT INTO akeNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Papa apurɨnin kʉrɨ rɨ. Tɨwɨ Papa nʉpika'tɨi i'se tesi yau, ‘Papa Mumu urɨ,’ tasa' iya pɨ',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mɨrɨ kasa rɨ iya'kɨrɨ kurusu' pona ipokapɨ'sa' kon uya isapema'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","12 a'kʉra' awonsi'kɨ 3 a'kʉra' pʉ'kʉ pona rɨ, tanporo rɨ pata ewarumamʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","3 a'kʉra' a'tai'ne rɨ, Sises ukɨ'pɨ'nʉmʉ'pʉ, “Iroi, Iroi, rama sapa'tani?” ta'pʉ iya, “Papa, Papa, ɨ'rɨto' pe unonkasa' auya?” ta e'kwa pe. ");
INSERT INTO akeNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mɨrɨ yau si te'soto'pɨ'se te'san uya serɨ etasa' a'tai, “Iraisa kɨ'ma pɨ' man!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Inke pʉra, tikin nɨ to' tonpa pe te'sen si eka'tumʉ'pʉ mɨrɨ su'pa epose, waain maku'pɨ peneka ka' ikii'pʉ iya, yʉi pɨ' tepu'tɨi' Sises uya ensito' pe ikupʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","E'tane tʉron kon ka'pon amʉ' uya, “Tɨwɨ nesii. Apʉne, Iraisa uyepʉ enpai'nokon ipika'tɨi',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Sises kanan ukɨ'pɨ'nʉnkaa'pʉ, mɨrɨpan uya ta'kwarʉ tʉrʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mɨrɨ a'tai rɨ si, Esuwerʉ amʉ' use'mato', ɨpʉremato' itau wapu pe te'sen ekaraka'pʉ inakapu ponsi'kɨ non pona a'sa'mʉyai. Tʉrʉ'pʉnʉ amʉ' esi'pʉ, mɨrɨ awonsi'kɨ tɨ' amʉ' uta'morʉpɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Uruwai' amʉ' uta'kokapɨtʉ'pʉ, mɨrɨpan wakʉ ton ka'pon amʉ' iyeri'sa' kon e'mʉ'sa'ka'pʉ kanan. ");
INSERT INTO akeNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","To' nin si epa'ka'pʉ mɨrɨ uruwai' yapai. Emennʉ'pʉ po, Sises e'mʉ'sa'kasa' a'tai nin si, to' utɨ'pʉ mɨrɨ Surusiran pona. Mɨrɨ yau, tu'kan kon nɨ ka'pon amʉ' uya to' ene'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Roman amʉ' soisaai ton epuru mɨrɨ awonsi'kɨ ita'kɨrɨ te'san itonpa ton Sises erasuntɨ pɨ' te'san uya tʉrʉ'pʉnʉ amʉ' utɨ i'tu'pʉ, mɨrɨ awonsi'kɨ tanporon nɨ te'ku'sen ene'pʉ, ipan pe rɨ to' etʉipɨtʉ'pʉ, mɨrɨpan kon uya, “I'napai rɨ kuru rɨ ka'si, pʉse rɨ esi'pʉ mɨrɨ wa Papa Mumu pe!” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tu'kan kon nɨ uri'sami'si amʉ' esi'pʉ enpɨtʉ pɨ' ɨnnonsi'kɨ. Sises e'ma'pʉkasa' to' uya esi'pʉ Kiyarari poi, ipika'tɨ pɨ' to' esi'pʉ i'se iye'to' ke. ");
INSERT INTO akeNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","To' koro'tau Meri Mataren; Meri, Isens mɨrɨ awonsi'kɨ Isose' san; mɨrɨ awonsi'kɨ Sepiti munkɨ amʉ' san. ");
INSERT INTO akeNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pata uko'mankapʉ koro'tau, imaminke' ka'pon, Arama'tiya winon uyee'pʉ. Itese' esi'pʉ Isose', Sises poitorʉ pe iyenasa' rʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Paire' piya' itɨ'pʉ Sises ekepu ekama'pose, ato' pe tʉuya. Paire' uya tʉsoisaai ton apiyo'ma'pʉ Sises ekepu tʉto' pe to' uya itena'. ");
INSERT INTO akeNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Isose' uya nin si itekepu arɨ'pʉ mɨrɨ. Iwontɨ'pʉ iya epe'kena' pon renen tato' atʉ ke, ");
INSERT INTO akeNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","mɨrɨpan uya Sises ekepu nonka'pʉ tiwano' pe emenna' pe tɨ' akasa' uruwai' pe ya'. Eke rɨ tɨ' tʉtɨrinkai' imʉra'taai a'koro'pʉ iya, mɨrɨpan nin si utɨ'pʉ mɨrɨ, mɨrɨ yapai. ");
INSERT INTO akeNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meri Mataren mɨrɨ awonsi'kɨ tʉron nɨ Meri ereutasa' esi'pʉ tɨ' akasa' uruwai' pe ratoi pe. ");
INSERT INTO akeNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mɨrɨ ema'sa' yau, Sapa' a'tai, Papa ena' use'man nɨto' tʉrawasomanin nan epuru ton, Pari'si amʉ' utɨ'pʉ Paire' piya'. ");
INSERT INTO akeNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Ina epuru, kʉrɨ Sises kasi ye' esi a'tai serɨ yau nurɨne isaurokʉ'pʉ esi ina enu yau, ‘Osorʉwau wʉi pata'pʉ pe e'mʉ'sa'kato' oton,’ tawon. ");
INSERT INTO akeNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mɨrɨ pe iyesi pɨ', ɨsoisaai ton apiyo'ma' iuruwasii erasuntɨto' pe to' uya serɨ awonsi'kɨ osorʉwau wʉi pʉ'kʉ pona rɨ ima'ta'pʉ awonsi'kɨ. Mɨrɨ pʉra nin iyesi yau, ipoitorʉ ton uyepʉ mɨrɨ itekepu onanse'na, mɨrɨpan a'tai nin si ka'pon amʉ' pɨ', ‘Sises e'mʉ'sa'kakaa'pʉ man,’ ta to' uya mɨrɨ. Serɨ nin si e'ku'sa' a'tai, wapiya iyesi'pʉ entai rɨ nin si ennakan nɨto' e'to' oton mɨrɨ ipan pe rɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","“Aya'kɨrɨ'nokon si usoisaai ton atɨ',” ta'pʉ Paire' uya. “Entantɨ', wakʉ pe uruwai' erasuntɨtantɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Mɨrɨpan kon nin si utɨ'pʉ mɨrɨ uruwai' piya' erasuntɨse'na. To' uya a'si'pɨtʉ'pʉ wakʉ pe tɨ' pɨ'. Mɨrɨ tʉpo nin si, soisa amʉ' uya erasuntɨto' pe to' uya ikupʉ'pʉ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Awanakʉi' kuru rɨ nin si, suntaaka epiya'tɨ pe, Sapa' ema'sa' yau, Meri Mataren mɨrɨ awonsi'kɨ tʉron nɨ Meri utɨ'pʉ Sises uruwasii tɨ' akasa' ense'na. ");
INSERT INTO akeNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mɨrɨ a'tai, ɨsɨ pe tʉrʉ'pʉnʉ esi'pʉ, apʉne pʉra Itepuru inserʉʉi u'tɨ esi'pʉ Epʉn poi. Tɨ' akasa' uruwai' piya' itɨ'pʉ, mɨrɨpan uya tɨ' ama'pʉ imʉra'taai apai, mɨrɨpan po iyereuta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Sirɨn pe iyesi'pʉ kamiri' kasa. Ipon esi'pʉ ipan pe rɨ aimu'ne, sino kasa. ");
INSERT INTO akeNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Erasuntɨ pɨ' si te'san soisa amʉ' etʉipɨtʉ'pʉ ipɨ' ipan pe, mɨrɨpan kon e'tɨtɨtɨ'ka'pʉ to' uta'mo'ka'pʉ iyeri'sa' kon kasa. ");
INSERT INTO akeNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Uri'sami'si amʉ' pɨ' inserʉ uya, “Kenari'nʉntʉu! Sises, to' nʉpokapɨtʉ'pʉ kurusu' pona warinpa auya'nokon tukai' si'tuyai'. ");
INSERT INTO akeNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","E'tane ipʉra man serɨ yau. Iye'mʉ'sa'ka'pʉ ta'pʉ tʉuya kasa rɨ. Apʉne, ipata'pʉ entanʉ'tɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Inke pʉra ipoitorʉ ton ipana'tɨtantɨ': ‘Iye'mʉ'sa'kasa' man terikʉ'pʉ apai, mɨrɨpan utɨn pɨ' man arawɨrɨ'nokon Kiyarari pona. Mɨrɨ yau ene auya'nokon mɨrɨ.’ Apana'tɨsa' uya 'nokon si mɨrɨ,” ta'pʉ inserʉ uya. ");
INSERT INTO akeNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kamoro si uri'sami'si amʉ' enna'po'pʉ mɨrɨ uruwai' piyapai to' etʉipɨ'sa' esi'pʉ e'tane ipan pe rɨ kanan to' esi'pʉ pori' pe, mɨrɨpan kon utɨ'pʉ teka'tunse ipoitorʉ ton pana'tɨse'na. ");
INSERT INTO akeNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ite'kwanau pʉra rɨ, Sises uya to' eporo'pʉ, mɨrɨpan uya, “Miyarɨ'nokon!” ta'pʉ to' pɨ'. To' utɨ'pʉ ipiya' i'ta pɨ' tʉuta'sii', to' uya apurɨpɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","“Kenari'nʉntʉu!” ta'pʉ Sises uya to' pɨ'. “Utonpa ton pɨ' Kiyarari pona entantɨ' ka'tantɨ'; mɨrɨ yau nin si to' uya uyene mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Utɨn pɨ' rɨ uri'sami'si amʉ' e'tane, Sises uruwasii erasuntɨnin nan soisa amʉ' utɨ'pʉ Surusiran pona, mɨrɨpan kon uya tanporo rɨ iye'ku'sa' rʉ'pʉ ekama'pʉ Papa ena' use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kamoro si Papa ena' use'ma nɨto' tʉrawasomanin nan epuru ton eke ton kuru e'seposa' a'tai Esuwerʉ amʉ' epuru ton pokon pe, to' ekoneka'pʉ mɨrɨ ku'to' kon pe tukai'. Soisa amʉ' ena' eke pe rɨ pʉrata tʉrʉ'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Se mɨkatʉi', ‘Ina e'nʉntane, ewarupɨ nau, Sises poitorʉ ton uya itekepu arɨ'pʉ,’ mɨkatʉi'. ");
INSERT INTO akeNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Serɨ etasa' kopʉna uya yau, ɨkota'ma iya 'nokon namai' ina uya auro'ka mɨrɨ,” ta'pʉ to' uya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Soisa amʉ' uya nin si pʉrata a'si'pʉ mɨrɨ; kamoro uya mɨrɨ kasa me'tʉi' tasa' awɨrɨ rɨ to' uya ikupʉ'pʉ. Mɨrɨ uriya', siya rɨ serɨ panton utɨsa' mɨrɨ Esuwerʉ amʉ' koro'tau rɨ serɨ pʉ'kʉ pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Mɨrɨ pata'pʉ pe, 11 kaisaron kon ipoitorʉ ton utɨ'pʉ Kiyarari pona, wʉ' pona, Sises uya, “Mɨrɨ ya' entantɨ',” ta'pʉ rʉ'pʉ pona. ");
INSERT INTO akeNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","To' uya ensa' a'tai, to' uya apurɨpɨtʉ'pʉ, e'tane tʉron kon uya ikasima'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Sises uyee'pʉ to' piya', mɨrɨpan uya ta'pʉ to' pɨ', “Umeruntɨrʉ ke urepasa' man tanporon nɨ Epʉn mɨrɨ awonsi'kɨ non poron kon nɨ esa' pe e'to' pe. ");
INSERT INTO akeNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mɨrɨ pe iyesi pɨ', siya rɨ entantɨ' tanporon kon ka'pon amʉ' ikonekatantɨ' upoitorʉ pe to' e'to' pe. To' ipa'taisimatantɨ' ikʉipʉnʉ, imu, mɨrɨ awonsi'kɨ Wakʉ A'kwarʉ ese' yau. ");
INSERT INTO akeNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","To' menupatʉi' tanporon nɨ ayauro'ka'pʉ uya 'nokon awɨron pe to' e'to' pe. I'napai rɨ kuru rɨ ɨpiyau'nokon esi iweyu u'matʉ pʉ'kʉ pona rɨ,” ta'pʉ iya to' pɨ'.");
INSERT INTO akeNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Serɨ, serɨ wakʉ itekare epiya'tɨ Papa Mumu, Sises Kʉrai pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Pu'kena' Aisaya karetaai yau iye'menukasa' na'ne': “Umaimu ekamanin ennoko uya mɨrɨ arawɨrɨ, ɨye'ma konekanin pe,” tawon. ");
INSERT INTO akeNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Rɨmono' tau ka'pon ukɨ'pɨ'nʉnpɨtʉ, ‘Itepuru e'ma ikonekatɨ'; to'sa rɨ ite'ma ikonekatɨ',’” tawon. ");
INSERT INTO akeNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Mɨrɨ kasa si Isaan uyee'pʉ, pa'taisiman pɨ' rɨmono'ta nono yau mɨrɨ awonsi'kɨ makoi apai era'tɨn epa'taisimato' makoi pɨ' usentu'man ekareei ekama pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tanporon kon nɨ Isutiya mɨrɨ awonsi'kɨ eke pata Surusiran winon kon nɨ utɨ'pʉ ipiya'. Tʉmakooi kon ekama pɨ', mɨrɨpan kon pa'taisima'pʉ iya Isotan tuna tʉu'tɨsen kau. ");
INSERT INTO akeNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Isaan pon esi'pʉ kiyamerʉ i'po' konekasa', o' pi'pɨ konekasa' esi'pʉ ipokʉrʉʉi pe iworo'pai pɨ'. Kairau amʉ' mɨrɨ awonsi'kɨ teusan e'ku pɨ' tenta'nasen pe iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mɨrɨ awonsi'kɨ se si esi'pʉ mɨrɨ itekareei pe: “Uye'ma'pʉ pe iyepʉ mɨrɨ ka'pon meruntɨ kuru uyentaino, tʉu'tɨi' isapatooi euka uya pokena' pen nɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Apa'taisima uya 'nokon serɨ tuna ke, e'tane kʉrɨ rɨ uya nin si apa'taisima kon mɨrɨ Wakʉ A'kwarʉ ke,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mɨrɨ a'tai, Sises uyee'pʉ Nasare', Kiyarari yawon winɨ, mɨrɨpan pa'taisima'pʉ Isaan uya Isotan kau. ");
INSERT INTO akeNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Sises ekanwaka koro'tau tuna kapai, ka' uta'koka e'se'ne' pe ene'pʉ iya, mɨrɨpan uya Ita'kwarʉ u'tɨ wako'wa kasa ene'pʉ tʉpona. ");
INSERT INTO akeNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Mɨrɨ awonsi'kɨ main uyee'pʉ Epʉn awonsi'kɨ, “Umu ɨmɨrɨ, uni'nʉnkanʉ; ɨpɨ' pori' pe e'ai' ipan pe,” tawon. ");
INSERT INTO akeNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Inke pʉra rɨ, Ita'kwarʉ uya ennoko'pʉ rɨmono' ta'. ");
INSERT INTO akeNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Rɨmono' tau iyesi'pʉ 40 kaisa rɨ wʉi, Se'tan esi'pʉ i'tupɨtʉ pɨ'. Mɨrɨ yau rɨ kanan ene amʉ' pokon pe iyesi'pʉ, mɨrɨpan ene pɨ' inserʉ amʉ' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Isaan a'sisa' to' uya tʉpo pariki'si ta', Kiyarari pona Sises utɨ'pʉ, wakʉ Papa ekareei ekama pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Iweyu e'seposa' man, Papa e'to' esa' wannɨ pe man a'ko pe! Amakooi kon apai era'tɨtɨ', mɨrɨ awonsi'kɨ itekare apurɨtɨ'!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sises usarɨ koro'tau parau ku'pɨri Kiyarari piyawɨrɨ, asa'ron kon moro' a'sinin nan ka'pon amʉ' ene'pʉ iya, Saiman, mɨrɨ awonsi'kɨ iyakon Anturu pokon, tʉpunwerʉ kon yai moro' amʉ' a'si to' uya esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Sises uya ta'pʉ to' pɨ', “Upɨkɨrɨ ɨsi'tɨ'. Ɨkonekato' kon pe uya ka'pon amʉ' a'sinin nan pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mɨrɨ pe rɨ, tʉpunwerʉ kon tʉnɨnse to' utɨ'pʉ ipɨkɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ɨnnɨ iwa rʉ'kwɨ itɨsa' a'tai, Isens ene'pʉ iya, Sepiti mu mɨrɨ awonsi'kɨ Isaan, iyakon kanau yau, tʉpunwerʉ kon konepɨtʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Oko pe pʉra rɨ, to' kɨ'ma'pʉ iya, mɨrɨpan kon uya tʉkʉipʉnʉ kon mɨrɨ awonsi'kɨ aka'ne' pe anʉnsa' kon ipoitorʉ ton pokon pe tʉnɨnse kanau yau, to' utɨ'pʉ ipɨkɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","To' utɨ'pʉ Ka'paneyan pona; Sapa' uye'sa' a'tai, Sises utɨ'pʉ Esuwerʉ amʉ' usenupato' iwʉ' ta'. Mɨrɨ yau, to' enupa pɨ' iyepiya'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ka'pon amʉ' usewansiuka'pʉ enupan nɨto' iya pɨ', apʉne pʉra tenupa iya 'nokon pɨ' tʉmeruntɨrʉkenan pe kuru rɨ, Main pɨ' enupanin nan kasa pʉra. ");
INSERT INTO akeNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mɨrɨ koro'tau, ka'pon, makoi a'kwarʉ yen pe te'sen mɨrɨ yau Esuwerʉ amʉ' usenupato' iwʉ' tau, ukɨ'pɨ'nʉmʉ'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Sises, Nasare' pon, ɨ'rɨ pe ina ku'se'na ɨuye'sa'? Ina pe' ma'tanʉ'se'na ɨuye'sa'? Kɨnyi'tuyai' ɨmɨrɨ kʉrɨ rɨ—Wakʉ Ye' Papa Iwano'!” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","“E'pana e'kɨ! Epa'kakɨ iyapai!” ta'pʉ Sises uya e'se'ne' pe. ");
INSERT INTO akeNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Makoi a'kwarʉ uya e'se'ne' pe ka'pon i'ki'ma'pʉ, mɨrɨpan epa'ka'pʉ iyapai tʉupirorʉnse. ");
INSERT INTO akeNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ka'pon amʉ' usewansiuka'pʉ, mɨrɨpan kon usekama'popɨtʉ'pʉ tiwano' kon pe, “Ɨ'rɨ si serɨ? Emenna' usenupan nɨto'—meruntɨ a'kɨron! Makoi a'kwarʉ ton nɨ apiyo'manin, mɨrɨpan kon esi imaimu awɨrɨ!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Itekareei utɨ'pʉ inke pʉra kuru rɨ siya rɨ Kiyarari nono poro. ");
INSERT INTO akeNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tepa'kasa' kon a'tai Esuwerʉ amʉ' usenupato' iwʉ' tapai, to' utɨ'pʉ Saiman mɨrɨ awonsi'kɨ Anturu pata'se' ya'. Isens mɨrɨ awonsi'kɨ Isaan pokon utɨ'pʉ to' a'kɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saiman ewo'pʉ esi'pʉ e'kɨɨi'man pɨ', te'kwe' tau. Inke pʉra rɨ Sises uye'sa' a'tai, to' uya ekama'pʉ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Sises utɨ'pʉ ipiya', itemiyatʉ pɨ' ta'sii' i'mʉ'sa'ka'pʉ iya. Iye'kɨɨi'mato' ereuta'pʉ, mɨrɨpan uya to' mʉta'napa'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pata uko'mansa' a'tai, wʉi enu pata'pʉ pe, ka'pon amʉ' uya tanporo rɨ takuru'kena' nan mɨrɨ awonsi'kɨ makoi a'kwarʉ yen ton nee'pʉ Sises piya'. ");
INSERT INTO akeNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tanporo rɨ mɨrɨ pata yau te'san ka'pon amʉ' amʉra'pʉ mʉra'ta na'. ");
INSERT INTO akeNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Sises uya tu'kan kon nɨ takuru'kena' nan epi'tɨpɨtʉ'pʉ to' eparan apai'ne, mɨrɨ awonsi'kɨ makoi a'kwarʉ ton nɨ enno'pɨtʉ'pʉ iya. Makoi a'kwarʉ ton usaurokʉ i'se pʉra rɨ iyesi'pʉ, apʉne pʉra to' uya ti'tu wenai. ");
INSERT INTO akeNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Awanakʉi' kuru, ewarupɨ pe rɨ marɨ pata e'tane, Sises e'mʉ'sa'ka'pʉ, mɨrɨpan utɨ'pʉ ɨutɨ tapai tʉ'kenan pata ya' ɨpʉremase'na. ");
INSERT INTO akeNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","E'tane Saiman mɨrɨ awonsi'kɨ itonpa ton utɨ'pʉ iwarinpase'na. ");
INSERT INTO akeNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","To' uya eposa' a'tai, “Tanporon kon man awarinpa pɨ'!” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Sises uya to' eikʉ'pʉ, “Tʉron nɨ airɨ eke iwa ton a'ko pa'nan pata ton ya' utɨnpai'nokon. Mɨrɨ yau'ne kanan itekare ekamato' pe uya. Mɨrɨto' pe uye'sa' serɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mɨrɨpan utɨ'pʉ siya rɨ Kiyarari poro itekare ekama pɨ' Esuwerʉ amʉ' usenupato' iwʉ' ton tau, mɨrɨ awonsi'kɨ makoi a'kwarʉ ton nɨ enno'pɨtʉ'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Erekʉ'pan ka'pon uyee'pʉ Sises piya'. Tese'mu po esii'ma iyeta'kwanʉmʉ'pʉ ipɨ', “Ɨnku'pai ɨwesi yau, wakʉ pe ukupʉ auya,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Sises usentu'ma'pʉ ipɨ'. Temiyatʉ ɨnka'pʉ iya, mɨrɨpan uya a'pɨtʉ'pʉ. “Ɨnku'pai rɨ e'ai'. Wakʉ pe e'kɨ!” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mɨrɨ a'tai rɨ, ka'pon erekʉ usepi'tɨ'pʉ, mɨrɨpan ena'pʉ wakʉ pe rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Sises uya inke pʉra ennoko'pʉ ipanama tʉpo se tukai', ");
INSERT INTO akeNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ɨnʉ' pɨ' rɨ serɨ kʉsekamai, e'tane enta ɨsenpoikata Papa ena' use'man nɨto' tʉrawasomanin ena', mɨrɨ awonsi'kɨ ɨuse'mato' pe te'sen, Mosi' uya tasa' na'ne' awɨrɨ mʉtʉrʉi', ɨyekorʉkasa' ekamanin pe to' pɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","E'tane kʉrɨ rɨ ka'pon utɨ'pʉ siya rɨ itekareei ekamase. Mɨrɨ moron nʉ'pʉ pe Sises epa'ka poken pʉra rɨ iyesi'pʉ eke iwa pata ton ya'ne, e'tane rɨ ka'pon amʉ' uye'pɨtʉ'pʉ mɨ'tapai'ne rɨ ipiya'. ");
INSERT INTO akeNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Emennʉ'pʉ po iwa rɨ, Sises enna'po'pʉ Ka'paneyan pona. Mɨrɨ a'tai, tʉpata'se' ya' iyenna'posa' man tawon useta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Tu'ke rɨ ka'pon amʉ' amʉra'pʉ, pata oton pʉra rɨ pata tʉku'se mʉra'ta airɨ'ne rɨ. Sises esi'pʉ itekare ekama pɨ' to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mɨrɨ a'tai, asakɨrɨ'nan kon ka'pon amʉ' uya ipu'tɨka'sa' ka'pon nee'pʉ ipiya'. ");
INSERT INTO akeNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Apʉne pʉra anpisin pe ka'pon amʉ' esi pɨ' itʉrʉ tʉuya'nokon poken pʉra Sises piya', iteuta koneka'pʉ to' uya ɨutɨ nakapu yai Sises epoi, mɨrɨ awonsi'kɨ aka tʉkon po, ka'pon ipu'tɨka'sa' nu'tɨ'pʉ to' uya iyapon po rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Sises uya to' uya apurɨto' ene'pʉ, mɨrɨpan uya ipu'tɨka'sa' ka'pon pɨ' ta'pʉ, “Mooi, amakooi pɨ' usentu'masa' man,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mɨrɨ yau tereutai' te'san, Main pɨ' enupanin nan usenuminka'pʉ tiwano' kon pe, ");
INSERT INTO akeNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ɨ'rɨ pe iyesi pɨ' mɨrɨ kasa Papa sapema pe rɨ isaurokʉ? Ɨnʉ' rɨ sa'ne makoi pɨ' tʉusentu'masen pʉra rɨ iyesi mɨrɨ ko, Papa rɨken!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mɨrɨ a'tai rɨ, Sises uya ta'kwarʉ yau i'tu'pʉ to' usenuminka tewan kon yau, mɨrɨpan uya ta'pʉ to' pɨ', “Ɨ'rɨ pe iyesi pɨ' mɨrɨ kasa ɨusenuminka kon? ");
INSERT INTO akeNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nai esi sa'man pe pʉra iwa pʉse rɨ ipu'tɨka'sa' pɨ' tato'; ‘Amakooi pɨ' usentu'masa' man,’ ta, mɨrɨ pe pʉra, ‘Te'mʉ'sa'kai' ayapon tanʉnse enta,’ ta? ");
INSERT INTO akeNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Serɨ pe enpoika uya si serɨ non po, Ka'pon, Papa winon piyau meruntɨ esi makoi pɨ' usentu'man nɨto',” ta'pʉ iya, mɨrɨpan uya ipu'tɨka'sa' ka'pon pɨ' ta'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ta uya ɨpɨ', e'mʉ'sa'ka', ayapon anʉnkɨ, enna'po' apata'se' ya'!” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","To' uya rɨ enpɨ'tane ka'pon e'mʉ'sa'ka'pʉ, tapon anʉmʉ'pʉ iya, mɨrɨpan utɨ'pʉ. Ipan pe rɨ to' usewansiuka'pʉ, mɨrɨpan kon uya Papa apurɨpɨtʉ'pʉ, “Serɨ waraino ensa' uya'nokon pʉra rɨ man!” tai'ma. ");
INSERT INTO akeNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Sises enna'pokaa'pʉ kanan parau ku'pɨri e'pi pona. Anpisin pe ka'pon amʉ' uyee'pʉ ipiya', mɨrɨpan kon enupa pɨ' iye'sara'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Isarɨ koro'tau, pʉrata amʉranʉ'nin, Ripai, Arʉ'piyas mu ene'pʉ iya, iyereutasa' pʉrata amʉranʉ'to' iwʉ' tau. Sises uya ta'pʉ ipɨ', “Uya'kɨrɨ ɨsi'kɨ,” mɨrɨpan Ripai e'mʉ'sa'ka'pʉ, itɨ'pʉ iya'kɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Sises esi koro'tau enta'nan pɨ' Ripai iwʉ' tau tu'kan kon nɨ pʉrata amʉranʉ'nin nan mɨrɨ awonsi'kɨ tʉmakooikena' nan esi'pʉ enta'nan pɨ' ipokon pe, mɨrɨ awonsi'kɨ ipoitorʉ ton pokon pe rɨ, apʉne pʉra tu'ke rɨ ipɨkɨrɨ to' esi ke. ");
INSERT INTO akeNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Main pɨ' enupanin nan tonpa ton, Pari'si amʉ' pe te'san uya Sises enta'na ene'pʉ pʉrata amʉranʉ'nin nan mɨrɨ awonsi'kɨ tʉmakooikena' nan pokon pe, mɨrɨpan kon uya ipoitorʉ ton ekama'po'pʉ, “Ɨ'rɨ pe iyesi pɨ' kamoro rupɨ pokon pe iyenta'na?” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Sises uya to' eta'pʉ, mɨrɨpan kon eikʉ'pʉ iya, “Atu' pe te'san ka'pon amʉ' esi mɨrɨ ta'ta i'se pʉra rɨ, e'tane kamoro takuru'ke te'san nɨken esi i'se. Uye'sa' serɨ ipokena' ton nɨ ka'pon amʉ' kɨ'mase'na pen, e'tane tʉmakooikena' nan nɨken,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Isaan Pa'tes mɨrɨ awonsi'kɨ Pari'si amʉ' poitorʉ ton useruma esi'pʉ tenta'nai' pʉra. Tʉron kon ka'pon amʉ' uyee'pʉ Sises piya' ekama'pose'na, “Ɨ'rɨ pe iyesi pɨ' Isaan Pa'tes poitorʉ ton mɨrɨ awonsi'kɨ Pari'si amʉ' poitorʉ ton useruma tenta'nai' pʉra, e'tane ɨpoitorʉ ton useruma pʉra rɨ iyesi?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Sises uya to' eikʉ'pʉ, “Nai kasa warawo' temari'masen nʉkɨ'ma'san useruma tenta'nai' pʉra tʉpiyau'nokon nɨ iye'tane? To' useruma pʉra iyesi tʉpiyau'nokon iye'tane. ");
INSERT INTO akeNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","E'tane iweyu e'sepoto' oton warawo' temari'masen emo'kato' oton to' piyapai; mɨrɨ wʉi a'tai nin si, to' useruma mɨrɨ tenta'nai' pʉra. ");
INSERT INTO akeNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ɨnʉ' uya rɨ emenna' pon ke ipooi'pɨ pon a'si'tɨ pʉra rɨ iyesi mɨrɨ. Mɨrɨ kasa iyesi yau, emenna' pon uya ipooi'pɨ pon karaka eke pe rɨ iteuta tʉku'se. ");
INSERT INTO akeNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ɨnʉ' uya rɨ emenna' waain entɨ pʉra rɨ iyesi mɨrɨ ipooi'pɨ iten ya'. Mɨrɨ kasa iyesi yau, asa'rɨ rɨ nin si ima'ta mɨrɨ. Emenna' iten esi emenna' waain yen pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tʉron nɨ Sapa' a'tai, Sises utɨ esi'pʉ a'nai' e'kwa nawɨrɨ. Tʉutɨi'ma'nokon ipoitorʉ ton uya a'nai' e'suruupɨ'sa' i'kwɨ'pɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pari'si amʉ' uya ta'pʉ ipɨ', “Apʉne enkɨ, ɨ'rɨ pe iyesi pɨ' Main uya tʉku'sen pen Sapa' a'tai tasa' rʉ'pʉ kupʉ to' uya?” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Sises uya to' eikʉ'pʉ, “Etanin nan pen pe' ɨmɨrɨ'nokon Tepi' nʉkupʉ'pʉ tʉpoitorʉ ton pokon pe, iwan pe tesi kon pɨ' tenta'nato' kon i'se tesi kon a'tai? ");
INSERT INTO akeNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mɨrɨpan utɨ'pʉ Papa iwʉ' ta', mɨrɨpan enta'na'pʉ ipʉremasa' pʉreti pɨ'. Serɨ e'kupʉ'pʉ Apiya'ta, Papa ena' use'man nɨto' tʉrawasomanin nan epuru a'tai. Use'man nɨto' tʉrawasomanin nan nɨken nɨkunʉ Main uya tasa' awɨrɨ. E'tane Tepi' enta'na'pʉ ipɨ', mɨrɨ awonsi'kɨ tʉtonpa ton nɨ nɨrɨ repapɨtʉ'pʉ iya,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Mɨrɨpan Sises uya ta'pʉ, “Sapa' ekonekasa' ka'pon iwano' pe, ka'pon ekonekasa' pen Sapa' iwano' pe. ");
INSERT INTO akeNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mɨrɨ uriya', Ka'pon, Papa winon esi Sapa' Epuru pe rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tʉron nɨ a'tai Sises utɨ'pʉ Esuwerʉ amʉ' usenupato' iwʉ' ta'. Mɨrɨ yau, ka'pon iyaipʉtasa' amʉrasa' itemiyatʉ esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tʉron kon esi'pʉ Sises eseru'tɨto' tʉuya'nokon iwenai kupʉ iya ene i'se, mɨrɨpan kon uya a'ko pe esii'ma enpɨtʉ'pʉ, Sapa' a'tai pe' epi'tɨ iya tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sises uya ta'pʉ ka'pon iyaipʉtasa' amʉrasa' itemiyatʉ pɨ', “E'mʉ'sa'ka' tanporon kon rau,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mɨrɨpan uya ka'pon amʉ' ekama'po'pʉ, “Nai esi Main, Mosi' winon awɨrɨ Sapa' a'tai tʉku'sen pe: wakʉ kupʉ, mɨrɨ pe pʉra ɨri kupʉ katɨ? Ka'pon pika'tɨ ima'ta namai', mɨrɨ pe pʉra iwɨnɨ katɨ?” ta'pʉ iya. E'tane e'pana to' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Sises usakorota uya to' enpɨtʉ'pʉ, ipan pe rɨ ɨpokoitai'ma rɨ marɨ, apʉne pʉra sa'man pe rɨ to' ewan esi pɨ', mɨrɨpan uya ta'pʉ ka'pon pɨ', “Ɨyemiyatʉ ɨnka'!” Ɨnka'pʉ iya, mɨrɨpan emiyatʉ enna'po'pʉ tesi'pʉ ya'. ");
INSERT INTO akeNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mɨrɨ a'tai, Pari'si amʉ' uya tʉusenupato' kon iwʉ' nɨmɨ'pʉ, mɨrɨpan kon e'seporo'pʉ kin pe te'sen, Era' tonpa ton pokon pe, mɨrɨpan kon ekoneka'pʉ Sises wɨto' pe tʉuya'nokon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Sises mɨrɨ awonsi'kɨ ipoitorʉ ton utɨ'pʉ parau ku'pɨri ka'. Tu'ke rɨ anpisin Kiyarari winon kon utɨ'pʉ ipɨkɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Pʉsamoro uyee'pʉ Isutiya winɨ, Surusiran winɨ, Itumiya winɨ, Isotan ratoi nono winɨ, mɨrɨ awonsi'kɨ Taya mɨrɨ awonsi'kɨ Saitan nono winɨ'ne. Anpisin ton nɨ uyee'pʉ Sises piya', apʉne pʉra inkupʉnʉ etasa' tʉuya'nokon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Apʉne pʉra anpisin pe rɨ to' esi pɨ', Sises uya tʉpoitorʉ ton auro'ka'pʉ kanau epoto' pe to' uya tekanwa'tɨto' ya' ka'pon amʉ' uya tu'ke rɨ tʉu'na'tɨ namai'. ");
INSERT INTO akeNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tu'kan kon nɨ epi'tɨsa' iya pɨ', tanporon kon nɨ takuru'kena' nan uyee'pʉ tʉuta'tu'mapɨ'se rɨ a'pɨ'se'na. ");
INSERT INTO akeNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Makoi a'kwarʉ yen ton uya ensa' a'tai, to' uta'mo'kapɨtʉ'pʉ irakʉi', mɨrɨpan kon upirorʉnpɨtʉ'pʉ, “Ɨmɨrɨ rɨ kʉrɨ Papa Mumu!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Sises uya e'se'ne' pe makoi a'kwarʉ yen ton panama'pʉ, kʉrɨ rɨ kʉrɨ rɨ ta to' uya namai' tʉpɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Sises utɨ'pʉ wʉ' pona rɨ, mɨrɨpan uya kamo i'se te'to' ton kɨ'ma'pʉ, mɨrɨpan kon uyee'pʉ ipiya', ");
INSERT INTO akeNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","mɨrɨpan kon anʉmʉ'pʉ iya 12 kaisa rɨ. To' koneka'pʉ iya itekare ekamai' enno'sa' kon pe, tʉpiyau to' e'to' pe mɨrɨ awonsi'kɨ to' enno'to' pe tʉuya itekare ekamase'na, ");
INSERT INTO akeNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","tʉmeruntɨrʉ ke to' e'to' pe makoi a'kwarʉ enpa'kapɨ'nin nan pe. ");
INSERT INTO akeNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Pʉsamoro si inanʉmʉ'san 12 kaisaron kon: Saiman (Pi'ta tukai' inese'tɨ'pʉ); ");
INSERT INTO akeNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Isens mɨrɨ awonsi'kɨ Isaan, Sepiti munkɨ amʉ' (Powanoses tukai' to' ese'tɨ'pʉ iya, Korʉme Munkɨ ta e'kwa pe); ");
INSERT INTO akeNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anturu, Piri', Pa'taramiu, Ma'siu, Tamas, Isens Arʉ'piyas mu, Tatiyas, Saiman Usera' tukai' tesa'sen, ");
INSERT INTO akeNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Isutas Eskariya', eparankanin pe iyesi'pʉ na'ne'. ");
INSERT INTO akeNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Sises ewomʉ'pʉ ɨutɨ ta'. Anpisin nɨ kanan amʉrakaa'pʉ Sises mɨrɨ awonsi'kɨ ipoitorʉ ton enta'nato' a'tai pʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Serɨ etasa' itonpa ton uya a'tai, ikan to' utɨ'pʉ, apʉne pʉra ka'pon amʉ' uya, “Itano'masa',” ta pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tʉron kon Main pɨ' enupanin nan Surusiran winɨ iye'sa' kon uya ta'pʉ, “Pirɨsipupʉ esi mɨrɨ iyau. Makoi amʉ' epuru winɨ makoi a'kwarʉ ton enpa'kapɨtʉ iya mɨrɨ,” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Mɨrɨ uriya', Sises uya ka'pon amʉ' kɨ'ma'pʉ tʉpiya'. Mɨrɨ yau, panton ekama'pʉ iya to' pɨ': “Nai kasa Se'tan nɨrɨ enpa'ka Se'tan uya tukai'? ");
INSERT INTO akeNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Esa' wannɨ ton epantakapɨ'sa' yau, tiwano' pe rɨ ɨsewa'nomai' to' uko'mamʉ pen nɨ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ɨsiwʉ' tau te'san epantakapɨ'sa' pe iyesi yau, tiwano' kon pe ɨsewa'nomai' kamoro uko'mamʉ pen nɨ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Mɨrɨ awonsi'kɨ tiwano' pe rɨ Se'tan usewa'noma yau mɨrɨpan epantakapɨ'sa', moro iko'mamʉ pen nɨ mɨrɨ; iu'ma'to' rɨ e'seposa'. ");
INSERT INTO akeNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ɨnʉ' rɨ ewomʉ pʉra iyesi mɨrɨ pana'pan ka'pon iwʉ' ta' tanporo itapuruui e'ma'tɨse'na, wapiya auronpɨ'sa' iya a'tai rɨken; mɨrɨ a'tai nin si, itimamin arɨ iya itiwʉ' tapai. ");
INSERT INTO akeNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“I'napairon ekama uya ɨpɨ'nokon, tanporon nɨ ka'pon amʉ' makooi, isapema pe rɨ to' usauro'sa' rʉ'pʉ pɨ' usentu'man. ");
INSERT INTO akeNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","E'tane ɨnʉ' rɨ kʉrɨ isapema pe Wakʉ A'kwarʉ pɨ' isauro'sa' pɨ' usentu'man pʉra rɨ iyesi mɨrɨ, apʉne pʉra siyaro' pe rɨ iye'makoimasa' mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Sises uya serɨ ta'pʉ, tʉron kon uya, “Makoi a'kwarʉ esi iyau,” tasa' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mɨrɨ a'tai, Sises san mɨrɨ awonsi'kɨ iyakon non uyee'pʉ. Te'soto'pɨ'se pʉroroi po ikɨ'manin ennoko'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Anpisin ton nɨ ereutapɨ'sa' esi'pʉ Sises woi, mɨrɨpan kon uya ipana'tɨ'pʉ, “Asan mɨrɨ awonsi'kɨ ayakon non esi pʉroroi po awarinpa pɨ',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Sises uya to' ekama'po'pʉ, “Ɨnʉ' si usan? Ɨnʉ' yan si uyakon non?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","To' si ene'pʉ iya, ka'pon amʉ' ereutapɨ'sa' tʉwoi, mɨrɨpan uya ta'pʉ, “Pʉsamoro usanon mɨrɨ awonsi'kɨ uyakon non. ");
INSERT INTO akeNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ɨnʉ' rɨ Papa e'to' i'se ku'nin esi mɨrɨ uyakon pe mɨrɨ awonsi'kɨ uparusi pe mɨrɨ awonsi'kɨ usan pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sises kanan e'sara'tɨkaa'pʉ to' enupa pɨ' parau ku'pɨri piyau. Anpisin ton ka'pon amʉ' iwoi iyamʉrasa' kon esi'pʉ tu'ke rɨ. Mɨrɨ pɨ', iyekanwa'tɨ'pʉ kanau ya' ereutai' parau ku'pɨri kau, tanporo ka'pon amʉ' e'tane a'mun po, tuna e'pi po. ");
INSERT INTO akeNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tu'kan pɨ' rɨ to' enupa'pʉ iya panton yai. To' enupa tʉuya yau, ta'pʉ iya to' pɨ': ");
INSERT INTO akeNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Apʉne etatɨ'! Umɨ pɨ' te'sen utɨ'pʉ kiyari ye' pɨnse'na tʉpa'karakai'. ");
INSERT INTO akeNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ipa'karaka iya koro'tau, tʉron nɨ ton uta'pokʉ'pʉ asanta ta'. Toron amʉ' uyee'pʉ mɨrɨpan kon uya ɨku'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tʉron nɨ ton uta'pokʉ'pʉ tɨ' pe te'sen ya', eke pe pʉra te'sen non ya'. Inke pʉra iya'ta'pʉ, apʉne pʉra i'nau pʉra non esi ke. ");
INSERT INTO akeNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","E'tane wʉi enu enu'sa' a'tai, a'ne' pe ipuru'pʉ iya mɨrɨpan aipʉta'pʉ, apʉne pʉra imi' ton utɨpɨ'sa' pʉra iyesi wenai. ");
INSERT INTO akeNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tʉron nɨ ton ite' ton uta'pokʉ'pʉ tikʉkenan nʉ'ta'. Iya'ta'pʉ, mɨrɨpan e'tane ɨwɨtanʉkʉ'pʉ iya, mɨrɨpan epeta'pʉ pen nɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mɨrɨ e'tane rɨ, tʉron nɨ ton uta'pokʉ'pʉ wakʉ non ya', mɨrɨpan uwa'ta'pʉ, mɨrɨpan epeta'pʉ tʉron nɨ ton esi'pʉ 30 kaisa rɨ ite'kwa iteperu, tʉron nɨ 60, mɨrɨ awonsi'kɨ 100 kaisarɨ rɨ ite'kwa e'to' airɨ inpɨmɨ'pʉ entai rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Mɨrɨ a'tai Sises uya ta'pʉ, “Kʉrɨ tʉpana ke na'ne' etato' ike, tɨwɨ netai,” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Sises esi koro'tau tikin sarɨ, isaurokʉ etanin nʉ'san uyee'pʉ ipoitorʉ ton pokon pe ekama'pose'na, ɨ'rɨ ta iya e'kwa pe iyesi tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","To' pɨ' ta'pʉ iya, “Ama' aino Papa e'to' esa' wannɨ pe e'tʉsa' ɨyena'nokon. E'tane kamoro mɨ airon kon pɨ' tanporon nɨ usekama panton yai, ");
INSERT INTO akeNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","“‘to' uya rɨ enpɨtʉ mɨrɨ e'tane wakʉ pe to' uya ene pen nɨ, to' uya rɨ eta mɨrɨ ito'ka'nʉkʉi'ma pʉra rɨ. Mɨrɨ kupʉ to' uya pe iyesi yau, to' era'tɨ nesii'no Papa winɨkʉi', mɨrɨpan kon pɨ' nin nʉsentu'mai'no.’ tasa' iya.” ");
INSERT INTO akeNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mɨrɨ a'tai, Sises uya ta'pʉ to' pɨ', “Serɨ pe' panton to'ka'nʉkʉ auya'nokon pʉra rɨ iyesi? Ɨ'rɨ kasa ken si tʉron nɨ panton to'ka'nʉkʉ kon pa? ");
INSERT INTO akeNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Umɨ pɨ' te'sen uya Papa Maimu pa'karaka. ");
INSERT INTO akeNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tʉron kon ka'pon amʉ' esi ite' ipa'karakasa' uta'po'sa' asanta ta' kasa. Eta to' uya pe rɨ, Se'tan uyepʉ Main mo'kase'na to' ya' ipa'karakasa'. ");
INSERT INTO akeNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tʉron kon ka'pon amʉ' esi ite' ton tɨ' pona ita'po'sa' kasa. Main eta tʉuya'nokon a'tai, inke pʉra rɨ to' uya anʉmʉ tepori'ma kon pe. ");
INSERT INTO akeNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","E'tane to' mi' pʉra to' esi, inke to' uko'mamʉ pʉra iyesi. Ɨ'rɨ rɨ anpokʉmanin mɨrɨ pe pʉra kota'manin uye'sa' a'tai main uriya', inke pʉra to' e'nonka ipiyapai. ");
INSERT INTO akeNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mɨrɨ e'tane rɨ, tʉron kon ka'pon amʉ' esi mɨrɨ ite' tikʉkenan nʉ'ta' ipa'karakasa' kasa, main etanin nan, ");
INSERT INTO akeNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","e'tane tʉuko'manto' kon pɨ' tʉusewankamasan, ipʉrataaike' pe e'nɨto' nenku'tɨnʉ ton, mɨrɨ awonsi'kɨ tʉron nɨ ton nɨ i'se to' e'to' uya main ɨwɨtanʉkʉ. Mɨrɨ uya nin si iyepeta pʉra ikupʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tʉron kon nin si esi mɨrɨ ite' wakʉ non ya' ipa'karakasa' kasa. To' uya main eta, mɨrɨ awonsi'kɨ to' uya rɨ anʉmʉ, mɨrɨpan kon epeta 30, 60, mɨrɨ awonsi'kɨ 100 kaisarɨ rɨ ite'kwa ipa'karakasa' rʉ'pʉ entai rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ta'pʉ iya to' pɨ', “Ɨnʉ' rɨ pe' raan'pu ewonnʉ'nin pʉsau o'koi' itʉto' pe tʉuya, mɨrɨ pe pʉra e'nʉn nɨto' apon o'koi' rɨ? E'tane ru'ku, itapon pona pe' itʉnin pen ɨmɨrɨ? ");
INSERT INTO akeNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Apʉne pʉra onansa' pe te'sen e'nɨponkato' pe rɨ iyesi; iwapu'tɨsa' pe te'sen epa'ka kɨpo'pona. ");
INSERT INTO akeNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kʉrɨ tʉpana ke na'ne' etato' ike, tɨwɨ netai!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ta'pʉ iya kanan to' pɨ', “Ɨnetanʉ kon pɨ' wakʉ pe ɨsenuminkatɨ'. I'tuto' auya yai pe rɨ ɨnkupʉ'pʉ yai ɨyena' i'tu mɨrɨ—mɨrɨ entai rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ɨnʉ' rɨ itesa' pe te'sen repa mɨrɨ miyarɨ rɨ. Ɨnʉ' rɨ ɨ'rɨ esa' pen nɨ enapai imo'ka mɨrɨ, itenawon nʉ'kwɨ rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sises uya kanan takaa'pʉ, “Papa e'to' esa' wannɨ pe esi mɨrɨ ka'pon kiyari ye' pɨnnin tʉpa'karakai' tʉmainarʉ yau kasa. ");
INSERT INTO akeNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Iye'nʉntane rɨ ewarupɨ nau, ipakasa' rɨ e'tane wʉi nai, kiyari ye' rɨ a'ta mɨrɨ, ɨ'rɨ kasa iye'sa' tukai' i'tu iya pʉra rɨ iyesi. ");
INSERT INTO akeNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Non uya rɨ iya'tato' pe ikupʉ, mɨrɨ awonsi'kɨ iyepetato' pe rɨ nɨrɨ ikupʉ iya: wapiya ite' pe te'ton epa'ka; mɨrɨ tʉpo, i'pai, mɨrɨ awonsi'kɨ nin si iyɨ ton utaka. ");
INSERT INTO akeNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Iyakʉ'pʉsa' a'tai nin si, iye'sara'tɨ mɨrɨ e'tʉrawasoman pɨ' a'tɨto' tʉuya tʉmariyarʉ, si'kʉrʉ tato' ke, apʉne pʉra anʉnto' weyu e'seposa' pɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Takaa'pʉ iya kanan, “Ɨ'rɨ kasa Papa e'to' esa' wannɨ pe esi ta? Ɨ'rɨ rupɨ panton ekama, ekamanin pe? ");
INSERT INTO akeNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mosta' ena'pɨ, aiko rʉ'kwɨ kuru kasa iyesi, ɨnpɨmɨnʉ non ya'. ");
INSERT INTO akeNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","E'tane ipɨnsa' a'tai, iya'ta mɨrɨ eke pe rɨ tʉron nɨ ye' ton umɨ yawon entai rɨ. Eke ton pe rɨ ipanta ton esi toron amʉ' rɨ esi iti'nʉ'kenanʉ yau,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Sises uya tekareei ekama'pʉ ka'pon amʉ' pɨ' tu'kan nɨ serɨ warai'nan panton yai'ne, to' uya ito'ka'nʉkʉ poken. ");
INSERT INTO akeNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Panton tapurɨi' pʉra to' auro'ka iya poken pʉra rɨ iyesi'pʉ. E'tane tʉpoitorʉ ton pokon pe tesi a'tai tikin sarɨ, mɨrɨ ta iya e'kwa pe iyesi tukai' ekama'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mɨrɨ ko'mamiri pe rɨ, Sises uya, “Iratoi pona utɨnpai'nokon,” ta'pʉ tʉpoitorʉ ton pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Anpisin ton ka'pon amʉ' nɨmɨ'pʉ to' uya. Sises e'to' iyau kanau ya' ipoitorʉ ton ekanwa'tɨ'pʉ, mɨrɨpan kon uya arɨ'pʉ. Tʉron nɨ ton nɨ kanau amʉ' esi'pʉ moro. ");
INSERT INTO akeNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pana' pe rɨ a'setun uyee'pʉ, sipa'sipa uya eke pe tuna anuku'pʉ kanau yau, isemʉ'nʉkʉ poken nɨ tʉku'se. ");
INSERT INTO akeNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Sises esi'pʉ e'nʉn nɨ pɨ' iyaure yau, eke'nan tapon po. Ipoitorʉ ton uya enpaka'pʉ, mɨrɨpan pɨ', “Ti'sa, ina pe' aputa pɨ' ɨusewankama pʉra rɨ iyesi mɨrɨ?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Sises e'mʉ'sa'kasa' uya a'setun eseremekʉ'pʉ, “E'paka'kɨ!” mɨrɨ awonsi'kɨ sipa'sipa pɨ', “E'tʉtʉika'!” ta'pʉ iya. Mɨrɨ a'tai rɨ, a'setun ereuta'pʉ, mɨrɨ awonsi'kɨ wakʉ pe rɨ pata ena'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tʉpoitorʉ ton pɨ' Sises uya ta'pʉ, “Ɨ'rɨ pɨ' ɨyenari'nʉmʉ kon? Anapurɨnʉ kon pʉra rɨ marɨ pe' iyesi mɨrɨ?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","E'tane to' etʉipɨ'sa' esi'pʉ, “Ɨnʉ' rɨ si pʉse rɨ ka'pon?” tukai' to' usekama'popɨtʉ'pʉ. “A'setun mɨrɨ awonsi'kɨ sipa'sipa rɨ e'to' imaimu awɨrɨ!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kerasin amʉ' nono pona to' utɨ'pʉ, parau ku'pɨri ratoi pon kon. ");
INSERT INTO akeNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Sises ekanwakasa' koro'tau, ka'pon uruwai' apai iyepa'kasa' uya eporo'pʉ. Pʉse rɨ ka'pon yau makoi a'kwarʉ esi'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","mɨrɨpan uko'mansa' esi'pʉ uruwai' koro'tau, ɨnʉ' uya rɨ tauronpɨ'se enkurunpa poken pʉra rɨ iyenaka'sa' esi'pʉ, i'sen ke rɨ auronpɨtʉ poken pʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Inke rɨ i'ta ton mɨrɨ awonsi'kɨ itemiyatʉ ton auronpɨtʉ'pʉ to' uya esi'pʉ i'sen amʉ' ke, e'tane rɨ mɨrɨ ton nɨ i'kɨrɨpɨtʉ'pʉ iya, mɨrɨ awonsi'kɨ wa'ka pun nɨ ti'ta pɨ' te'sen a'morʉpɨtʉ'pʉ iya. Ɨnʉ' uya ereutanʉkʉ poken pʉra rɨ, ipan pe rɨ pana' pe iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ewarupɨ' tau mɨrɨ awonsi'kɨ wʉi nai rɨ usarɨn pɨ' iyesi'pʉ uruwai' mɨrɨ awonsi'kɨ wʉ' poro'ne rɨ, ukɨ'pɨ'nʉnpɨ' nɨ pɨ' rɨ, tiwano' pe rɨ uta'tɨpɨ' nɨ pɨ' tɨ' ke. ");
INSERT INTO akeNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ɨnnonsi'kɨ Sises ensa' tʉuya a'tai, iyeka'tumʉ'pʉ, mɨrɨpan e'sekunka'pʉ irau. ");
INSERT INTO akeNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Mɨrɨpan ukɨ'pɨ'nʉmʉ'pʉ eke pe rɨ, “Sises, eke Papa Mumu, ɨ'rɨ pe ukupʉ i'se me'an? Papa pɨ', ‘Ikota'ma uya pen,’ ka'kɨ!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Serɨ ta'pʉ iya, apʉne pʉra Sises uya makoi a'kwarʉ pɨ', “Pʉse ka'pon yapai epa'kakɨ!” tasa' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","“Ɨnʉ' ɨyese'?” ta'pʉ Sises uya ipɨ'. “Anpisin ton kuwayau amʉ' uyese',” tukai' eikʉ'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ipan pe rɨ Sises pawana'tɨ pɨ' iyesi'pʉ mɨrɨ pata yapai ɨri a'kwarʉ ton ennoko iya namai'. ");
INSERT INTO akeNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","A'ko pe rɨ tu'kan kon nɨ peiruku amʉ' esi'pʉ enta'nan pɨ' i'kʉrʉ po. ");
INSERT INTO akeNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Sises pawana'tɨ'pʉ ɨri a'kwarʉ ton uya peiruku amʉ' ya' tenno'to' kon pe iya. ");
INSERT INTO akeNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","To' nin si utɨto' pe ikupʉ'pʉ iya mɨrɨ. Ɨri a'kwarʉ ton nin si utɨ'pʉ mɨrɨ ka'pon yapai peiruku amʉ' ya'. Tanporo rɨ nin si, 2,000 e'to' airon kon peiruku amʉ' e'tʉrʉ'kwa'pʉ, mɨrɨpan kon aputa'pʉ parau ku'pɨri ka'. ");
INSERT INTO akeNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","To' pa'sima pɨ' te'san ka'pon amʉ' eka'tumʉ'pʉ pata pona itekareei ekamase'na, umɨ yau'ne rɨ te'san pana'tɨ'pʉ to' uya. Iye'ku'sa' rʉ'pʉ ense'na ka'pon amʉ' utɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","To' uyee'pʉ Sises piya', mɨrɨpan kon uya kʉrɨ rɨ anpisin kuwayau makoi a'kwarʉ yen pe te'sen ka'pon ene'pʉ iyepontɨsa', iyereutasa' esi'pʉ, wakʉ pe iya'kwarʉ. Tanporo enari'ke' pe to' ena'pʉ mɨrɨ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kamoro ennin nʉ'san uya ka'pon amʉ' pana'tɨ'pʉ iye'ku'sa' makoi a'kwarʉ yen ka'pon pɨ' mɨrɨ awonsi'kɨ peiruku amʉ' pɨ' rɨ nɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mɨrɨpan kon uya Sises ekama'po'pʉ itɨto' pe tʉnono kon apai. ");
INSERT INTO akeNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Sises ekanwa'tɨ koro'tau kanau ya', makoi a'kwarʉ yen nʉ'pʉ ka'pon uya ekama'po'pʉ, “Aya'kɨrɨ utɨi'ya,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","E'tane Sises esi'pʉ itɨ i'se pʉra, e'tane, “Enna'pokɨ apata ya', ɨtonpa ton koro'ta'. Eke pe rɨ Itepuru nʉkupʉ'pʉ ɨpɨ' isentu'masa' ekamata,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mɨrɨpan utɨ'pʉ tanporo Te'ka'pores poro, Sises nʉkupʉ'pʉ tʉpɨ' ekama pɨ', mɨrɨ pɨ' tanporon kon usewansiuka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sises enna'po'pʉ iye'kwɨrɨtʉ'pʉ parau ku'pɨri ratoi pona. Mɨrɨ yau parau ku'pɨri ka'ta po, anpisin pe rɨ to' amʉra'pʉ iwoi. ");
INSERT INTO akeNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Isairas, Esuwerʉ amʉ' usenupato' iwʉ' epuru uyee'pʉ, mɨrɨpan Sises ensa' tʉuya a'tai ita'mo'ka'pʉ i'ta piya'. ");
INSERT INTO akeNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Mɨrɨpan ipan pe rɨ ipawana'tɨ'pʉ iya, “Aiko rʉ'kwɨ uyensi man takuru'ke, iyeri'kapʉ rɨ. Apʉne ɨsi'kɨ, ɨyemiyatʉ inonkatanʉ'kɨ ipona, mɨrɨpan usepi'tɨto' pe iyerikʉ namai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Mɨrɨpan Sises e'sara'tɨ'pʉ iya'kɨrɨ. Mɨrɨ a'tai, tu'kan kon nɨ ka'pon amʉ' utɨ'pʉ iya'kɨrɨ, to' uya iwontɨ'pʉ sen winɨ'ne rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mɨrɨ yau, uri'san esi'pʉ 12 kaisa rɨ wʉipiya mʉn ennoko pɨ' iko'mansa'. ");
INSERT INTO akeNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tu'kan kon nɨ ta'ta amʉ' uya epi'tɨ tane, tʉpʉrataai rɨ enno'tane iya to' e'ma pɨ', e'tane tʉusepi'tɨ pe ekama tane iya, miyarɨ rɨ ipan pe rɨ iyena'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mɨrɨpan uya rʉ'kwɨ Sises eta'pʉ, iyee'pʉ anpisin ton koro'tau ite'ma'pʉ pe. ");
INSERT INTO akeNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Ipon nʉ'kwɨ rɨ a'pɨ'sa' uya yau, usepi'tɨ rɨ mɨrɨ,” ta'pʉ iya ti'nau rʉ'kwɨ rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ipon a'pɨtʉ'pʉ iya, mɨrɨpan mʉn tʉutɨsen ereuta'pʉ mɨrɨ a'tai rɨ. E'ne' pe iye'to' anpokʉmanin usepi'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mɨrɨ a'tai rɨ, Sises uya tʉmeruntɨrʉ epa'ka'pʉ i'tu'pʉ, mɨrɨpan era'tɨpɨtʉ'pʉ anpisin koro'tau, mɨrɨpan uya ta'pʉ, “Ɨnʉ' upon a'pɨtʉi?” tai'ma. ");
INSERT INTO akeNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ipoitorʉ ton uya eikʉ'pʉ, “Ene auya pʉra pe' nai ka'pon amʉ' uya ɨwontɨsa'? Ɨ'rɨ pe iyesi pɨ', ‘Ɨnʉ' uya'pɨtʉi?’ ta auya?” ");
INSERT INTO akeNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","E'tane rɨ Sises uya tenu tʉpɨtʉ'pʉ, ɨnʉ' uya iku'sa' tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mɨrɨpan uri'san uya i'tu'pʉ tʉpɨ' iye'ku'sa', mɨrɨpan uyee'pʉ e'tɨtɨtɨ'kai'ma rɨ tenari'nʉmʉ ke. Ita'mo'ka'pʉ i'ta piya', mɨrɨpan uya tanporo rɨ i'napairon ekama'pʉ ipɨ', tʉpɨ' iye'ku'sa' rʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Sises uya ta'pʉ ipɨ', “Ma'non, anapurɨnʉ uya rɨ ɨkonekasa' mɨrɨ wakʉ pe. Enta si tʉusewankamai' pʉra, ɨusepi'tɨsa' si mɨrɨ ɨyewankamanin apai,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mɨrɨ koro'tau, Isairas pana'tɨnin nan uyee'pʉ itiwʉ' tawonsi'kɨ, mɨrɨpan kon uya ta'pʉ, “Ɨyensi eri'ka'sa' man. Ti'sa rɨ kʉsanpokʉmai,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Sises esi'pʉ to' maimu ɨnetapai pʉra rɨ, e'tane ta'pʉ iya ipɨ', “Kenari'nʉmʉi, e'tane apurɨkɨ rɨken,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mɨrɨpan ɨnʉ' rɨ utɨ i'se pʉra iyesi'pʉ ta'kɨrɨ, Pi'ta, Isens mɨrɨ awonsi'kɨ iyakon Isaan nɨken. ");
INSERT INTO akeNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","To' uyee'pʉ itepuru iwʉ' ta', mɨrɨ yau Sises uya tʉutano'masan eke pe rɨ ene'pʉ, pokoi pe rɨ tʉukɨ'pɨ'nʉnpɨ'se rɨ tʉukaransan eta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Mɨrɨpan ewomʉ'pʉ, ta'pʉ iya to' pɨ', “Ɨ'rɨ pe iyesi pɨ' tanporo rɨ autano'ma kon serɨ? Ɨ'rɨ pɨ' aukaramʉ kon? Mʉre eri'sa' pen, iye'nʉmʉ rɨken,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mɨrɨpan kon e'sara'tɨ'pʉ uta'kɨrɨn pɨ' ipɨ'. Tanporo to' enpa'ka'pʉ iya, mʉre kʉipʉnʉ mɨrɨ awonsi'kɨ isan mɨrɨ awonsi'kɨ osorʉwawon kon nɨken tʉpoitorʉ ton pokon pe iyewomʉ'pʉ mʉre eri'sa' pata'se' airɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Mɨrɨpan uya i'mʉ'sa'ka'pʉ itemiyatʉ pɨ' ta'sii', “Tari'ta kun!” ta'pʉ iya (“Uri'san mʉre, e'mʉ'sa'ka', ta uya ɨpɨ',” ta tʉuya e'kwa pe). ");
INSERT INTO akeNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mɨrɨ a'tai rɨ, iye'mʉ'sa'ka'pʉ, mɨrɨpan e'sara'tɨ'pʉ usarɨn pɨ' (12 kaisaron iwʉipiyaai pe iyesi'pʉ). Serɨ e'ku'sa' pɨ' ipan pe to' usewansiuka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Sises uya ipan pe to' pɨ' ta'pʉ, “Kʉsekamatʉu ɨnʉ' yan pɨ' rɨ. Irepatɨ' ɨ'rɨ rʉ'kwɨ rɨ iyenta'nato' ipɨ' ke,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Sises uya mɨrɨ pata nɨmɨ'pʉ, iyenna'po'pʉ tʉpata'se' ya', ipoitorʉ ton nɨ itonpa pe. ");
INSERT INTO akeNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sapa' e'seposa' a'tai, to' enupa pɨ' iye'sara'tɨ'pʉ Esuwerʉ amʉ' usenupato' iwʉ' tau. Tu'ke rɨ ka'pon amʉ' esi'pʉ mɨrɨ yau, mɨrɨpan eta tʉuya'nokon a'tai, tanporon kon nɨ usewansiuka'pʉ. “Nai yau serɨ ton eporo'pʉ pʉse rɨ ka'pon uya?” tukai' to' usekama'popɨtʉ'pʉ. “Ɨ'rɨ rɨ pu'ketʉ ke irepasa' pe iyesi? Ɨ'rɨ kasa rɨ eke rɨ Papa tʉrawasooi kupʉ iya? ");
INSERT INTO akeNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kiya'pinta pen pe' pʉse rɨ? Meri mʉre; Isens, Isoses, Isutas mɨrɨ awonsi'kɨ Saiman pokon rui? Serɨ yau pe' upiyau'nokon iparusi ton pʉra nai?” ta'pʉ to' uya. Mɨrɨpan kon ɨkɨnʉmʉ'pʉ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Sises uya ta'pʉ to' pɨ', “Ipata'se' yau rɨken, itonpa ton koro'tau mɨrɨ awonsi'kɨ itiwʉ' rɨ tau pu'kena' nama pʉra iyesi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Eke Papa tʉrawasooi kupʉ iya poken pʉra rɨ iyesi'pʉ mɨrɨ yau, e'tane rɨ temiyatʉ rɨken nonkapɨtʉ'pʉ iya tu'kan kon pen ka'pon amʉ' takuru'kena' nan pona, mɨrɨpan kon epi'tɨpɨtʉ'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ipan pe rɨ to' pɨ' isewansiukapɨtʉ'pʉ, apʉne pʉra apurɨto' to' uya pʉra iyesi pɨ'. Mɨrɨpan Sises utɨpɨtʉ'pʉ eke iwa ton pata ton kaisa rɨ'ne, ka'pon amʉ' enupapɨtʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tʉpoitorʉ ton, 12 kaisaron kon tʉkɨ'mai' tʉpiya', to' enno'pɨtʉ'pʉ iya asa'rɨ'ne, mɨrɨpan kon repa'pʉ iya to' meruntɨrʉ ke, makoi a'kwarʉ entai to' e'to' pe. ");
INSERT INTO akeNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Serɨ ton ke to' auro'ka'pʉ iya, “Ɨ'rɨ rɨ kʉsatʉu aya'kɨrɨ'nokon ɨutɨ kon koro'tau, teke'sen nɨken—tʉwenantu ke pʉra rɨ, tʉpaikii ke pʉra rɨ, pʉrata pʉra rɨ ɨpokʉrʉʉi kon yau mʉtɨtʉi'. ");
INSERT INTO akeNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Sapato yau rɨ e'tɨ'; tu'ke ipona ɨpon kon pʉro'pon yau ke'tʉu,” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","To' auro'ka'pʉ iya kanan, “To' uya ɨyereutanʉ'sa' kon na'ne' airɨ rɨ, mɨrɨ rɨ ɨutɨ tau me'tʉi' pata nɨmɨ auya'nokon pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mɨrɨ awonsi'kɨ pata uya ɨyereutanʉ'sa' kon pʉra iyesi yau, mɨrɨ pe pʉra ɨyetapai'nokon pʉra rɨ iyesi yau, to' nɨmɨ auya'nokon a'tai a'ta kon mʉtɨutɨpɨ'tʉi'. Serɨ uya rɨ to' pana'tɨ mɨrɨ Papa uya to' kota'mato' oton ekamanin pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Mɨrɨpan kon utɨ'pʉ ka'pon amʉ' pɨ' itekare ekamase'na, to' era'tɨto' pe tʉmakooi kon apai. ");
INSERT INTO akeNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mɨrɨpan tu'ke rɨ makoi a'kwarʉ enpa'kapɨtʉ'pʉ to' uya, mɨrɨpan kon uya tu'kan kon nɨ takuru'kena' nan karapaimapɨtʉ'pʉ to' epi'tɨpɨtʉ'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kin Era' uya serɨ eta'pʉ, apʉne pʉra Sises ese' enasa' esi'pʉ wakʉ pe kuru ti'tusen pe. Tʉron kon uya, “Isaan Pa'tes rɨ e'mʉ'sa'kasa' mɨrɨ terikʉ'pʉ apai; mɨrɨ wenai, eke Papa tʉrawasooi kupʉ iya mɨrɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tʉron kon uya, “Iraisa kʉrɨ rɨ,” ta'pʉ. Tʉron kon uya rɨ kanan, “Pu'kena' kʉrɨ rɨ, penaro' kon pu'kena' amʉ' esi'pʉ waraino,” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Era' uya etasa' a'tai, “Isaan Pa'tes sa'ne kʉrɨ rɨ ko! I'pai unakʉtʉ'pʉ, e'tane ito'pansa' terikʉ'pʉ apai!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Apʉne pʉra Era' uya rɨ Isaan a'sito' pe ikupʉ'pʉ. Auronpɨ'to' pe to' uya ikupʉ'pʉ iya, mɨrɨpan tʉto' pe pariki'si ta'. Era' uya serɨ kupʉ'pʉ Eratiyas wenai, tʉnmari'ma'pʉ takon Piri' no'pʉ pe rɨ iye'tane. ");
INSERT INTO akeNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Isaan Pa'tes e'pɨtʉ'pʉ Era' auro'ka pɨ', “Main awɨrɨ ɨwesi pe pʉra iyesi mɨrɨ ayakon no'pʉ anʉnsa' auya na'ne',” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mɨrɨ uya Eratiyas ɨkɨnʉnpasa' esi'pʉ Isaan nɨ ɨnwɨpai, e'tane ikupʉ iya poken pʉra iyesi'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","apʉne pʉra Era' esi'pʉ Isaan namanin pe, iwapu pe iyesi'pʉ i'tu tʉuya ke, ipokena' pe, mɨrɨ awonsi'kɨ wakʉ pe. Isaurokʉ eta tʉuya a'tai, ekamʉra rɨ iyenapɨ'pɨtʉ'pʉ mɨrɨ rɨ e'tane imaimu ɨnetapai iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mɨrɨ yau nin si, iweyu e'sepokaa'pʉ mɨrɨ. Tentu'pʉ weyu rʉ'pʉ a'tai, Era' uya enta'nan kupʉ'pʉ eke ton itepuru ton, soisa amʉ' epuru ton, mɨrɨ awonsi'kɨ eke ton Kiyarari pata yawon kon ewe'to' iya. ");
INSERT INTO akeNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Eratiyas mʉre uye'sa' a'tai amanʉnse'na, imanʉmʉ uya wakʉ pe rɨ Era' kupʉ'pʉ mɨrɨ awonsi'kɨ inkɨ'ma'san nɨrɨ. Mɨrɨ pɨ', kin uya ta'pʉ uri'san pɨ', “I'se ɨwe'to' pɨ' rɨ uyekama'pokɨ ɨrepa uya mɨrɨ ike,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Eke pe rɨ auro'ka'pʉ iya tʉnku'ton pɨ', “Ɨnekama'po'pʉ ke rɨ ɨrepa uya, a'sa'mʉyai itesa' pe e'to' pata ke rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mɨrɨ pɨ' uri'san epa'ka'pʉ tʉsan ekama'pose'na. “Ɨ'rɨ kuru rɨ ekama'po uya serɨ?” ta'pʉ iya. “Isaan Pa'tes i'pai rʉ'pʉ ekama'po',” tukai' eikʉ'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mɨrɨ a'tai rɨ, tʉusenutɨi' uri'san enna'po'pʉ kin piya', “Urepa auya i'se e'ai' serɨ pe Isaan Pa'tes i'pai rʉ'pʉ ke parapi po!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kin upokoita'pʉ tʉusaurokʉ'pʉ pɨ' ipan pe, e'tane, apʉne pʉra ikupʉ uya kuru tasa' tʉuya rʉ'pʉ pɨ' tʉnkɨ'ma'san pana airɨ, inurunpa iya poken pʉra iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mɨrɨpan uya inke pʉra i'pairʉkanin ennoko'pʉ, Isaan i'pai rʉ'pʉ ne'to' pe iya. Itɨ'pʉ pariki'si ta', mɨrɨpan uya Isaan i'pairʉka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mɨrɨpan uya inee'pʉ parapi po, mɨrɨpan uya itʉrʉ'pʉ uri'san ena', mɨrɨpan uya itʉrʉ'pʉ tʉsan ena'. ");
INSERT INTO akeNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mɨrɨ tetai', Isaan poitorʉ rʉ'san uyee'pʉ, mɨrɨpan kon uya itekepu arɨ'pʉ, iu'na'tɨto' pe tʉuya'nokon tɨ' akasa' uruwai' pe ya'. ");
INSERT INTO akeNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Enno'sa' kon enna'posa' amʉra'pʉ Sises woi, mɨrɨpan kon uya tanporo tʉnkupʉ'pʉ kon mɨrɨ awonsi'kɨ to' enupa'pʉ tʉuya'nokon nɨ ekama'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mɨrɨ yau, tu'ke rɨ ka'pon amʉ' uye'pɨtʉ mɨrɨ awonsi'kɨ to' utɨpɨtʉ esi'pʉ, Sises mɨrɨ awonsi'kɨ ipoitorʉ ton enta'nato' a'tai pʉra rɨ iyesi'pʉ. Mɨrɨ uriya', to' pɨ' ta'pʉ iya, “Utɨnpai'nokon mɨ airɨ rɨ tʉ'kena'pɨ yau e'nɨ poken mɨrɨ koro'tau ɨumoronkapʉ kon pa,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mɨrɨpan kon e'sara'tɨ'pʉ utɨn pɨ' kanau yau tʉ'kena'pɨ pata ya'. ");
INSERT INTO akeNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tu'kan kon nɨ ka'pon amʉ' uya to' ene'pʉ, to' i'tu'pʉ to' uya kamoro pe. Mɨrɨpan kon eka'tumʉ'pʉ tanporo pata ton apai'ne irawɨrɨ a'mun poro, mɨrɨpan kon uya pata eporo'pʉ to' rawɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Sises ekanwakasa' uya tu'ke anpisin pe ka'pon amʉ' ensa' a'tai, ipan pe rɨ to' pɨ' isentu'ma'pʉ, apʉne pʉra to' esi'pʉ karimeru amʉ' esi tʉpa'simanin ke pʉra kasa. Mɨrɨpan kon enupa pɨ' iye'sara'tɨ'pʉ tu'kan pɨ' rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pata uko'mansa' a'tai, ipoitorʉ ton uyee'pʉ ipiya', mɨrɨpan kon uya, “Pata uko'manka'sa' kuru rɨ man, ɨnnon sa'ne serɨ pata ko,” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","“Ka'pon amʉ' enno'kɨ a'ko pan parɨ umɨ ton mɨrɨ awonsi'kɨ eke iwa ton pata amʉ' ya'ne, tiwano' kon pe tenta'nato' kon ipɨ' e'mato' pe to' uya,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","E'tane to' eikʉ'pʉ iya, “Ɨmɨrɨ'nokon pe rʉ'kwɨ rɨ to' irepatɨ' to' enta'nato' ike ke,” ta'pʉ iya. Ta'pʉ to' uya ipɨ', “Mɨrɨ uya 8 kaisa rɨ kapʉi ka'pon e'tʉrawasomasa' epe'pʉ mo'ka mɨrɨ! Mɨrɨ kaisa rɨ ken pe' ennoko pʉreti pɨ' to' ewe'to' pe?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Sises uya to' ekama'po'pʉ, “Ɨ'rɨ kaisa rɨ rʉ'kwɨ pʉreti nai ɨpiyau'nokon? Apʉne entantɨ',” ta'pʉ iya. To' uya ensa' a'tai, “5 kaisaron nʉ'kwɨ pʉreti mɨrɨ awonsi'kɨ asa'ron kon nʉ'kwɨ moro' amʉ' man,” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Sises uya ta'pʉ tʉpoitorʉ ton pɨ', “Ka'pon amʉ' amʉranʉ'pɨ'tɨ' tamu'kuru' ke'ne mɨrɨpan kon ereutapɨ'to' pe wana' pona,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ka'pon amʉ' ereutapɨtʉ'pʉ tamu'kuru' ke'ne 100 kaisa rɨ'ne mɨrɨ awonsi'kɨ 50 kaisa rɨ'ne. ");
INSERT INTO akeNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mɨrɨpan Sises uya 5 kaisaron itekiino pʉreti mɨrɨ awonsi'kɨ asa'ron kon nʉ'kwɨ moro' amʉ' anʉmʉ'pʉ. Ka'ta' tenu tʉtʉse tenki ta'pʉ iya Papa pɨ', i'kwɨ'pɨtʉ'pʉ iya. Itʉrʉ'pʉ iya tʉpoitorʉ ton uya ekanto' pe ka'pon amʉ' ena'. Mɨrɨ kasa rɨ marɨ asa'ron kon nʉ'kwɨ moro' amʉ' kupʉ'pʉ iya to' kaisa rɨ to' e'to' pe. ");
INSERT INTO akeNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tanporon kon nɨ enta'na'pʉ ta'wetapɨ'se, ");
INSERT INTO akeNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","mɨrɨpan ipoitorʉ ton uya 12 kaisa rɨ pa'siki'ti pʉreti mɨrɨ awonsi'kɨ moro' amʉ' tonpa'pʉ e'nonkasa' anuku'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Warawoti'si amʉ' pʉreti pɨ' iyenta'nasa' kon tu'kanoro esi'pʉ 5,000 kaisa rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Inke pʉra tʉpoitorʉ ton ekanwa'tɨto' pe kanau ya' ikuu'pʉ iya, to' utɨto' pe tʉrawɨrɨ Pe'saita pona, anpisin enno'tane tʉuya. ");
INSERT INTO akeNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","To' nɨmɨ tʉpo, wʉ' pona itɨ'pʉ ɨpʉremai'. ");
INSERT INTO akeNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mɨrɨ a'tai ko'mamʉ pe pata enaka'tane, kanau esi'pʉ parau ku'pɨri aporo' po. Mɨrɨ koro'tau, Sises esi'pʉ tikin sarɨ a'mun po. ");
INSERT INTO akeNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tʉpoitorʉ ton utanpokʉma ene'pʉ iya, tʉkanwa kon i'kura i'se, apʉne pʉra a'setun uya to' kota'ma esi'pʉ to' winɨkʉi' tʉuyepʉ ke. Awanakʉi', 3 a'kʉra' mɨrɨ pe pʉra 6 a'kʉra' rɨ to' piya' iyee'pʉ parau ku'pɨri pʉro'po. To' rɨ entaka iya esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","E'tane parau ku'pɨri pʉro'po isarɨ ene tʉuya'nokon a'tai, a'kwarʉ'pʉ pe to' uya ekama'pʉ, mɨrɨpan kon upirorʉnpɨtʉ'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","apʉne pʉra tanporo ensa' tʉuya'nokon pɨ', mɨrɨpan kon etʉipɨtʉ'pʉ ipan pe. Inke pʉra Sises uya ta'pʉ to' pɨ', “Meruntɨ pe e'tɨ'! Urɨ rɨ. Ketʉipɨ'tʉu,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Mɨrɨ a'tai rɨ, iyekanwa'tɨ'pʉ kanau ya' to' piya'. Mɨrɨ a'tai rɨ, a'setun ereuta'pʉ, mɨrɨpan poitorʉ ton usewansiuka'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","apʉne pʉra to' uya ito'ka'nʉ'sa' pʉra iyesi'pʉ ɨ'rɨ kuru ta e'kwa pe pʉreti esi tukai'; to' ewan nɨ usa'mantasa' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","To' ɨ'kwɨrɨ'sa' a'tai, to' e'te'ka'pʉ Kenesare' airɨ, mɨrɨpan kon uya tʉkanwa kon ewa'tɨ'pʉ mɨrɨ yau. ");
INSERT INTO akeNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","To' ekanwaka pe rɨ, ka'pon amʉ' uya Sises i'tusa' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mɨrɨpan kon eka'tunpɨtʉ'pʉ, tanporo mɨrɨ pata nono yau'ne, mɨrɨpan kon uya takuru'kena' nan epɨrinpɨ'sa' te'kwe' kon po nee'pʉ ipiya', mɨrɨ airɨ iyesi tukai' etasa' tʉuya'nokon airɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mɨrɨ awonsi'kɨ Sises utɨpɨ'to' airɨ'ne—eke iwa ton pata amʉ', umɨ amʉ' awɨrɨ'ne rɨ—mɨrɨpan ka'pon amʉ' uya takuru'kena' nan apɨtʉ'pʉ kʉrʉpo'po pɨ' e'nɨto' pata'se' ya', mɨrɨpan kon uya ipan pe ipawana'tɨ'pʉ takuru'kena' nan uya ipon e'pi a'pɨ'to' pe, mɨrɨpan tanporon kon a'pɨ'nin nʉ'san usepi'tɨpɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pari'si amʉ' mɨrɨ awonsi'kɨ Main pɨ' enupanin nan iye'sa' kon Surusiran winɨ amʉrasa' esi'pʉ Sises woi, ");
INSERT INTO akeNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","mɨrɨpan kon uya tʉron kon ipoitorʉ ton enta'na ene'pʉ ɨri, ikorʉkasa' pen temiyatʉ kon ke. ");
INSERT INTO akeNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Pari'si amʉ' mɨrɨ awonsi'kɨ Esuwerʉ amʉ' kamoro tenta'nasan pen temiyatʉ kon korʉkasa' tʉuya'nokon pʉra iye'tane tepuru kon eseru awɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ɨ'rɨ rɨ kʉrʉpo'po iwʉ' tapai ine'sa' pɨ', to' enta'na pen wapiya kuru ikorʉkasa' tʉuya'nokon a'tai rɨken to' enta'na, mɨrɨpan kon uya tenupa'pʉ kon nɨ kupʉ iye'to' awɨrɨ Papa enu yau, tʉkokʉ kon, terin kon, ka'pa konekasa' tʉ'sawʉ kon, mɨrɨ awonsi'kɨ te'kwe' kon amʉ' rɨ korʉka.) ");
INSERT INTO akeNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mɨrɨ pɨ' Pari'si amʉ' mɨrɨ awonsi'kɨ Main pɨ' enupanin nan uya Sises ekama'po'pʉ, “Ɨ'rɨ pe iyesi pɨ' ɨpoitorʉ ton esi pʉra iyesi uyepuru kon eseru rʉ'pʉ awɨrɨ, e'tane ɨri rɨ temiyatʉ kon ke to' enta'na?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Sises uya to' eikʉ'pʉ, “Ipoken nɨ Aisaya usaurokʉ'pʉ ɨpɨ'nokon, wakʉ pe te'ku'san pɨ'; iye'menukasa' na'ne': “‘Pʉsamoro uya tʉnta kon ke rɨken unama; e'tane ɨnnɨ rɨ to' ewan esi upiyapai. ");
INSERT INTO akeNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","To' ɨpʉrema upɨ' ɨ'rɨ epoton kon kasa rɨ; to' usenupato' esi ka'pon amʉ' uya to' enupa'pʉ iyawɨrɨ to' e'to'.’ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ɨmɨrɨ'nokon uya Papa uya ayapiyontɨto' kon apurɨ pʉra iyesi, e'tane ka'pon uya ɨyenupato' kon apurɨ auya'nokon nɨken,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mɨrɨpan uya ta'pʉ to' pɨ', “Teseru ke kuru ɨwesi kon Papa Maimu nonka kon pa, ɨyeseru kon awɨrɨ ɨwesi kon pa! ");
INSERT INTO akeNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosi' uya tasa', ‘Ɨkʉipʉnʉ mɨrɨ awonsi'kɨ asan inamakɨ,’ mɨrɨ awonsi'kɨ, ‘Ɨnʉ' rɨ tʉkʉipʉnʉ mɨrɨ awonsi'kɨ tʉsan nɨ pa'nʉ'nin wɨto' pe iyesi.’ ");
INSERT INTO akeNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","E'tane ta auya'nokon, ka'pon uya tʉkʉipʉnʉ mɨrɨ pe pʉra tʉsan pɨ' ta pe iyesi yau, ‘Ɨ'rɨ rɨ ɨpika'tɨnin pe uwinɨ ɨneporonʉ pan e'tane Kapan pe man’ (Papa ena' iye'tʉka'sa' man ta e'kwa pe), ");
INSERT INTO akeNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","mɨrɨ si ɨ'rɨ rɨ kupʉ iya poken pʉra tʉkʉipʉnʉ mɨrɨ pe pʉra tʉsan iwano' pe ikupʉ auya'nokon. ");
INSERT INTO akeNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mɨrɨ kasa si ipʉra Papa Maimu kupʉ auya'nokon ɨyeseru kon mɨn winɨ rɨ iyɨ'kwɨrɨ'pɨ'sa' ke. Mɨrɨ awonsi'kɨ tu'ke rɨ ɨnkupʉnʉ kon man serɨ warai'nan,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sises uya anpisin ton nɨ kɨ'makaa'pʉ kanan tʉpiya', mɨrɨpan uya ta'pʉ to' pɨ', “Apʉne uyetatɨ', tanporo ɨmɨrɨ'nokon, mɨrɨ awonsi'kɨ se ito'ka'nʉ'tɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mɨrɨ yau ɨ'rɨ rɨ tewonsen pʉra iyesi mɨrɨ ka'pon ya' kɨpo'ponsi'kɨ ɨri pe iku'se'na, e'tane ka'pon apai iyepa'kasa' uya ɨri pe ikupʉ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mɨrɨpan uya anpisin ton nɨ nɨmɨ'pʉ, itɨ'pʉ ɨutɨ ta', mɨrɨpan ipoitorʉ ton uya ekama'po'pʉ serɨ panton pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","“Ito'ka'nʉ'nin nan pe pʉra rɨ pe' ɨwesi kon? Ene auya'nokon pʉra pe' iyesi, ɨ'rɨ rɨ kɨpo'ponsi'kɨ tewonsen ka'pon ya' uya, ɨri pe ikupʉ pʉra iyesi? ");
INSERT INTO akeNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Apʉne pʉra itɨ pen mɨrɨ itewan ya' e'tane itɨ mɨrɨ iwenu'pɨ ya', mɨrɨpan epa'ka ipun apai,” ta'pʉ iya. (Sises uya serɨ ta'pʉ, tanporo rɨ sa'ne kiyari esi mɨrɨ ko enta'nan nɨto' ipɨ' pe, ta tʉuya e'kwa pe.) ");
INSERT INTO akeNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Mɨrɨpan uya rɨ ta'pʉ, “Nepa'kayai'ne' ka'pon yapai uya nin ikupʉ mɨrɨ ɨri pe. ");
INSERT INTO akeNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Apʉne pʉra ka'pon amʉ' ewan yapai ɨri isenuminkato' epa'ka, tekumasen pe, ama' e' pe, te'wɨsen pe, ");
INSERT INTO akeNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","iyemari'masa' ekumankanin pe, mentaino pe, e'wɨpaino, enku'tɨnin ye' pe, ɨri ku'nin pe rɨ, tɨkɨntai', teseru'tɨi' ka'pon pɨ' tʉusauro'sen pe, mɨ pe rɨ te'ku'sen pe, mɨrɨ awonsi'kɨ ita'kwarʉ pʉra te'sen pe. ");
INSERT INTO akeNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tanporo serɨ ton makoi eseru ton epa'kasa' ka'pon apai uya ɨri pe rɨ ikupʉ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sises uya mɨrɨ pata nɨmɨ'pʉ pata Taya itese' pʉ'kʉ pona, mɨrɨpan ewomʉ'pʉ ɨutɨ ta', ɨnʉ' uya rɨ ti'tu i'se pʉra rɨ iyesi'pʉ, mɨrɨ yau iyesi tukai', e'tane iye'so'namʉ poken pʉra rɨ iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Inke pʉra rɨ etasa' tʉuya a'tai, aiko rʉ'kwɨ makoi a'kwarʉ yen imʉre uri'san uyee'pʉ i'ta piya' ata'mo'kai'. ");
INSERT INTO akeNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Pʉse rɨ uri'san esi'pʉ ka'kʉran pe, tʉron nɨ pata winon, iyentusa' Poni'siya, Siriya yawon yau, mɨrɨpan uya Sises pawana'tɨ'pʉ ɨri a'kwarʉ enpa'kato' pe iya tʉmʉre yapai. ");
INSERT INTO akeNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","“Wapiya mʉre amʉ' nenta'nakapʉi tanporo i'se te'to' kon pe, apʉne pʉra ipoken pʉra iyesi mʉre amʉ' yu pʉreti eno'ma to' ikʉn non pero amʉ' ena',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","“Ewai', Epuru, e'tane pero amʉ' tepʉrʉ o'non kon nɨ mʉre amʉ' i'kiyari punu'pɨ pɨ' tenta'nasan ko,” ta'pʉ uri'san uya. ");
INSERT INTO akeNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Sises uya ta'pʉ ipɨ', “Mɨrɨ kasa uyei'sa' auya pɨ', enna'pokɨ pata pona; ɨri a'kwarʉ utɨkaa'pʉ man ɨmʉre yapai,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mɨrɨpan si enna'pokaa'pʉ pata pona, mɨrɨpan uya tʉmʉre e'pɨrinkasa' te'kwe' po eporo'pʉ, ɨri a'kwarʉ rɨ si epa'kakaa'pʉ esi'pʉ iyapai. ");
INSERT INTO akeNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Sises utɨ'pʉ pata Taya pʉ'kʉ poi, mɨrɨpan utɨ'pʉ Saitan poro parau ku'pɨri Kiyarari poro, itɨ esi'pʉ Te'ka'pores nono awɨrɨ'ne rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tʉron kon ka'pon amʉ' uya ipana pʉn, tʉusauro'sen pen ka'pon nee'pʉ, mɨrɨpan kon uya Sises ekama'po'pʉ temiyatʉ tʉto' pe iya ipona. ");
INSERT INTO akeNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mɨrɨpan arɨ'pʉ iya anpisin ton piyapai tikin sarɨ, temiyatʉ muku'pɨ tʉrʉ'pʉ iya ipana ya', mɨrɨ awonsi'kɨ iyeta'ta'pʉ, mɨrɨpan uya iyani a'pɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Mɨrɨpan Sises uya tenu tʉrʉ'pʉ ka' winɨkʉi', mɨrɨpan uya e'se'ne' pe teruparu enpa'ka pe ta'pʉ iya ka'pon pɨ', “E'pa'ta!” (“Ata'koka'!” ta e'kwa pe). ");
INSERT INTO akeNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mɨrɨ a'tai rɨ, ipana uta'koka'pʉ, iyani ekoneka'pʉ, mɨrɨpan usaurokʉ'pʉ ɨ'rɨ anpokʉmanin pʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Mɨrɨpan kon nɨ panama'pʉ iya, ipɨ' to' usauro'pɨtʉ namai' ɨnʉ' yan pokon pe rɨ, e'tane miyarɨ rɨ to' apiyo'ma tane iya, miyarɨ rɨ to' uya ekama'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mɨrɨpan tanporon kon nɨ etanin nʉ'san usewansiuka'pʉ ipan pe rɨ: “Ɨ'rɨ kasa wakʉ pe rɨ tanporon nɨ kupʉ iya. Ipana pʉn koneka iya etanin pe; imaimu pʉn koneka iya tʉusauro'sen pe!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Inke kuru pʉra rɨ mɨrɨ tʉpo, tʉron kon kanan anpisin ton amʉrakaa'pʉ. To' enta'nato' ipɨ' pʉra iyesi pɨ', Sises uya tʉpoitorʉ ton kɨ'ma'pʉ tʉpiya', mɨrɨpan uya ta'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Usentu'mayai' pʉsamoro ka'pon amʉ' pɨ', apʉne pʉra uya'kɨrɨ to' e'sa' pɨ' osorʉwau wʉi, mɨrɨpan kon enta'nato' ipɨ' pʉra rɨ si iyesi. ");
INSERT INTO akeNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","To' enno'sa' uya a'tai to' tewe'se pʉra pata pona to' nin utɨpɨtʉ mɨrɨ yai tʉutɨ kon koro'tau apʉne pʉra tʉron kon uye'sa' ɨnnɨ rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ipoitorʉ ton uya ekama'po'pʉ, “Nai yau rɨ tʉ'kenan yau pʉsamoro ka'pon amʉ' ewe'to' ike eporo serɨ?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“Ɨ'rɨ kaisa rɨ pʉreti nai ɨpiyau'nokon?” ta'pʉ Sises uya. To' uya eikʉ'pʉ, “7 kaisa rɨ rɨken,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Anpisin ton apiyo'ma'pʉ iya to' ereutapɨ'to' pe non pona, mɨrɨpan 7 kaisaron nʉ'kwɨ rɨken itekiino pʉreti anʉmʉ'pʉ iya, tenki ta'pʉ iya Papa pɨ', mɨrɨpan i'kwɨ'pɨtʉ'pʉ iya. Itʉrʉ'pʉ iya tʉpoitorʉ ton ena', to' uya ekanto' pe anpisin ton ena', mɨrɨpan nɨ kupʉ'pʉ ipoitorʉ ton uya. ");
INSERT INTO akeNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","To' piyau kanan aiko ton nʉ'kwɨ tu'kan kon pen moro' amʉ' esi'pʉ. Mɨrɨ pɨ' tenki ta'pʉ Sises uya, mɨrɨpan kon ekanto' pe tʉpoitorʉ ton uya kanan ikupʉ'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Tanporon kon enta'na'pʉ ta'wetapɨ'se, mɨrɨ yau 4,000 kaisa rɨ ka'pon amʉ' esi'pʉ, mɨrɨpan ipoitorʉ ton uya ipʉ'kʉ rʉ'san iye'nonkasa' rʉ'pʉ entɨ'pʉ 7 kaisaron pa'siki'ti tʉpe'ke'ne. Sises uya nin si ka'pon amʉ' ennoko'pʉ mɨrɨ, ");
INSERT INTO akeNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","mɨrɨpan ekanwa'tɨ'pʉ kanau ya' mɨrɨ a'tai rɨ tʉpoitorʉ ton pokon pe, mɨrɨpan kon utɨ'pʉ Tarʉmanu'ta nono pʉ'kʉ pona. ");
INSERT INTO akeNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pari'si amʉ' uyee'pʉ mɨrɨpan kon e'sara'tɨ'pʉ Sises ekama'popɨtʉ pɨ'. I'tupɨtʉ pe to' uya ekama'po'pʉ i'tuto' ipɨkɨrɨ Epʉn winon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sises uya e'se'ne' pe teruparu enpa'ka'pʉ, mɨrɨpan uya ta'pʉ, “Ɨ'rɨ pe iyesi pɨ' serɨ a'taino kon uya eke Papa tʉrawasooi, ui'tuto' tʉuya'nokon ipɨkɨrɨ ekama'po? I'napairon ekama uya ɨpɨ'nokon; mɨrɨ waraino i'tuto' ipɨkɨrɨ tʉrʉ pen nɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Mɨrɨpan kon tʉnɨnse iyenna'po'pʉ kanau ya', mɨrɨpan e'kwɨrɨtʉ'pʉ iratoi pona. ");
INSERT INTO akeNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ipoitorʉ ton upu'tɨkaa'pʉ esi'pʉ tu'ke pʉreti arɨ to' uya pʉra, tikin nɨ rɨken to' piyau iyesi'pʉ kanau yau. ");
INSERT INTO akeNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","“Ti'tui' e'tɨ'; tense e'tɨ' Pari'si amʉ' mɨrɨ awonsi'kɨ Era' uya pʉrowa a'sarutanʉ'to' ike pɨ',” tukai' to' panama'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","To' e'sara'tɨ'pʉ usauro'nɨ pɨ' tiwano' kon pe. “Apʉne pʉra pʉreti pʉra iyesi pɨ' isaurokʉ mɨrɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","To' usauro'to' i'tu tʉuya pɨ' to' ekama'po'pʉ iya, “Ɨ'rɨ pɨ' ausaurokʉ kon pʉreti pʉra ɨwesi kon pɨ'? Ene auya'nokon pʉra rɨ pe', mɨrɨ pe pʉra ito'ka'nʉkʉ auya'nokon pʉra rɨ pe' iyesi? Ɨyewan kon nɨ usa'manta? ");
INSERT INTO akeNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tenu ke rɨ pe' ɨwe'tane'nokon ene auya'nokon pʉra iyesi? Tʉpana ke rɨ, e'tane eta auya'nokon pʉra rɨ? Ɨyenu kon yau pʉra nai? ");
INSERT INTO akeNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","5 kaisaron pʉreti si'kwɨ'pɨ'taine' a'tai 5,000 kaisaron kon ka'pon amʉ' iwano' pe, ɨ'rɨ kaisa rɨ pa'siki'ti amʉ' tʉpe'tɨpɨ'se ipʉ'kʉ rʉ'san mentɨta'tʉi?” ta'pʉ iya to' pɨ'. “12 kaisa rɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Mɨrɨ awonsi'kɨ 7 kaisaron pʉreti si'kwɨ'pɨ'taine' a'tai 4,000 kaisaron kon ka'pon amʉ' iwano' pe, ɨ'rɨ kaisa rɨ pa'siki'ti amʉ' tʉpe'tɨpɨ'se ipʉ'kʉ rʉ'san e'nonkasa' mentɨta'tʉi?” ta'pʉ iya. “7 kaisa rɨ,” tukai' to' uya eikʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ta'pʉ iya to' pɨ', “Ito'ka'nʉkʉ auya'nokon pʉra rɨ marɨ pe' iyesi?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","To' uyee'pʉ Pe'saita pona, mɨrɨ yau ka'pon amʉ' uya tenku'nan ka'pon nee'pʉ Sises piya', mɨrɨpan kon uya ipawana'tɨ'pʉ a'pɨ'to' pe iya. ");
INSERT INTO akeNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Sises uya tenku'nan arɨ'pʉ itemiyatʉ pɨ' ta'sii' eke iwa pata yapai, mɨrɨpan enu ya' teta'tapɨtʉ tʉpo, temiyatʉ tʉrʉ'pʉ iya ipona, mɨrɨpan uya ekama'po'pʉ, “Ɨ'rɨ rɨ pe' menyan?” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mɨrɨpan uya tenu tʉrʉ'pʉ ka'ta', mɨrɨpan uya ta'pʉ, “Ewai', ka'pon amʉ' senyai', e'tane to' usene yʉi amʉ' usarɨ kasa rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Sises uya kanan temiyatʉ tʉkaa'pʉ itenu pona. Serɨ a'tai kuru si, wakʉ pe itenu ena'pʉ mɨrɨ, mɨrɨpan uya tanporon nɨ ene'pʉ wakʉ pe. ");
INSERT INTO akeNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Sises uya ennoko'pʉ ipata'se' ya', “Kenna'poi eke iwa pata pona,” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Mɨrɨpan Sises mɨrɨ awonsi'kɨ ipoitorʉ ton utɨ'pʉ eke iwa ton pata Sisariya Piri'pai oino' nan pona. Asanta tau to' ekama'po'pʉ iya, “Ɨnʉ' pe esi tukai' ka'pon amʉ' nʉsauro'an?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","To' uya entakanoma'pʉ, “Tʉron kon uya Isaan Pa'tes pe ɨwesi ta; tʉron kon uya Iraisa pe ɨwesi ta; tʉron kon uya kuru rɨ kanan pu'kena' amʉ' tonpa ta,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“E'tane si ɨmɨrɨ'nokon, ɨnʉ' pe ken si esi mʉkayatʉu?” ta'pʉ iya to' pɨ'. Pi'ta uya eikʉ'pʉ, “Ɨmɨrɨ kʉrɨ rɨ Kʉrai!” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Sises uya to' panama'pʉ ɨnʉ' pɨ' rɨ to' uya tekama namai'. ");
INSERT INTO akeNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","To' enupa pɨ' iye'sara'tɨ'pʉ, Ka'pon, Papa winon uya e'ne' moronkato' oton eke pe rɨ, mɨrɨpan ewaruma'tɨto' oton Esuwerʉ amʉ' epuru ton uya rɨ, use'man nɨto' tʉrawasomanin nan epuru ton amʉ' uya rɨ, mɨrɨ awonsi'kɨ Main pɨ' enupanin nan uya rɨ nɨrɨ, mɨrɨpan wɨto' oton, mɨrɨ awonsi'kɨ iye'mʉ'sa'kato' oton osorʉwau wʉi tʉpo tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Serɨ ekama'pʉ iya wakʉ pe kuru rɨ to' pɨ', mɨrɨpan arɨ'pʉ Pi'ta uya esereme'se'na. ");
INSERT INTO akeNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","E'tane Sises era'tɨsa' a'tai tʉpoitorʉ ton ense'na, mɨrɨpan uya Pi'ta eseremekʉ'pʉ, “Upiyapai enta, Se'tan!” ta'pʉ iya. “Ɨusenuminkato' esi ka'pon usenuminkato' pe, Papa usenuminkato' kasa pʉra rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mɨrɨpan uya anpisin ton kɨ'ma'pʉ tʉpoitorʉ ton pokon pe tʉpiya', “Ɨnʉ' rɨ uyepʉ pe iyesi yau uye'ma'pʉ pe, tɨwɨ tʉpɨ' rɨ tʉupu'tɨka'se, tʉkurusukuui tanʉnse nʉyepʉi upɨkɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Apʉne pʉra ɨnʉ' rɨ kʉrɨ tʉuko'manto' ɨnnonkapai pʉra na'ne' uya tʉuko'manto' rɨ nonka mɨrɨ, e'tane ɨnʉ' rɨ tʉuko'manto' nonka pɨ' na'ne' upɨkɨrɨ mɨrɨ awonsi'kɨ wakʉ itekare pɨkɨrɨ uya inonka pen mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Wakʉ pe pe' ka'pon esi tanporo non pon eponin ta'kwarʉ nonkai'ma? Kane ku! ");
INSERT INTO akeNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mɨrɨ pe pʉra, ɨ'rɨ tʉrʉ iya ta'kwarʉ entakano' pe? ");
INSERT INTO akeNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ɨnʉ' rɨ ɨpiyɨtʉ yau upɨ' mɨrɨ awonsi'kɨ umaimu ton pɨ', serɨ iyemari'masa' ekumankanin nan mɨrɨ awonsi'kɨ ɨri ton serɨ a'taino kon weyu a'tai'ne, Ka'pon, Papa winon nɨrɨ ɨpiyɨtʉ mɨrɨ ipɨ', tʉuyepʉ a'tai tʉkʉipʉnʉ meruntɨrʉ yau mɨrɨ awonsi'kɨ wakʉ ton nɨ inserʉ amʉ' pokon pe,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mɨrɨpan uya ta'pʉ to' pɨ', “I'napairon ekama uya ɨpɨ'nokon, serɨ yau iye'soto'pɨ'sa' na'ne' nan tonpa ton eri'to' oton pen nɨ Papa e'to' esa' wannɨ pe uyepʉ meruntɨ pe ene tʉuya'nokon rawɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","6 kaisa rɨ wʉi tʉpo, Sises uya Pi'ta, Isens mɨrɨ awonsi'kɨ Isaan pokon arɨ'pʉ ta'kɨrɨ. To' arɨ'pʉ iya ka'tawon nɨ wʉ' pona tʉ'kenan yau to' e'to' pe. Mɨrɨ yau to' esi koro'tau, isensima'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ipon ena'pʉ sirɨn pe aimu'ne, ipan pe rɨ aimu'ne ɨnʉ' rɨ serɨ non pon uya ikorʉkasa' uya aimu'nakasa' entai rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mɨrɨpan mɨrɨ yau Iraisa mɨrɨ awonsi'kɨ Mosi' pokon usenpoika'pʉ to' rakʉi', Sises auro'ka pɨ' to' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pi'ta uya ta'pʉ Sises pɨ', “Rapai, wakʉ rɨ pan pe rɨ serɨ yau ina man. Tɨwɨ osorʉwau ɨiwʉ' kon oton amɨi ina — tikin nɨ ɨiwʉ' pe, Mosi' iwʉ' pe mɨrɨ awonsi'kɨ Iraisa iwʉ' pe.” ");
INSERT INTO akeNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Mɨrɨ ta tʉuya tukai' i'tu iya pʉra rɨ iyesi'pʉ, apʉne pʉra kʉrɨ rɨ mɨrɨ awonsi'kɨ tʉron kon etʉipɨ'sa' esi'pʉ mɨrɨ pɨ'.) ");
INSERT INTO akeNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mɨrɨ a'tai, kapuru' usenpoika'pʉ, mɨrɨpan uya to' nɨpontɨ'pʉ. Main uyee'pʉ kapuru' apai, “Umu pʉse rɨ, Uni'nʉnkanʉ. Imaimu etatɨ'!” tawon. ");
INSERT INTO akeNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mɨ awɨrɨ tenu kon tʉpɨ'tane to' uya, ɨnʉ' pʉra rɨ iyesi'pʉ. Sises rɨken esi'pʉ to' piyau. ");
INSERT INTO akeNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Wʉ' ponsi'kɨ tʉu'tɨ kon koro'tau, Sises uya ta'pʉ to' pɨ', “Ɨnʉ' pɨ' rɨ ɨnene'pʉ kon kʉsekamatʉu, Ka'pon, Papa winon eri'sa' e'mʉ'sa'ka pʉ'kʉ pona rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Imaimu awɨrɨ to' esi'pʉ, e'tane tiwano' kon pe to' usekama'popɨtʉ'pʉ mɨrɨ pɨ', ɨ'rɨ ta e'kwa pe, “eri'nɨsa' e'mʉ'sa'ka pʉ'kʉ pona rɨ,” ta esi tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mɨrɨpan kon uya ekama'po'pʉ, “Ɨ'rɨ pe ken iyesi pɨ' Main pɨ' enupanin nan uya Iraisa kuru uye'to' oton wapiya ta?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","To' entakanoma'pʉ iya, “I'napairɨ rɨ Iraisa uyepʉ wapiya tanporon nɨ konekai' iyesi'pʉ ya'. Ɨ'rɨto' pe iye'menukasa' Ka'pon, Papa winon ekota'mato' oton ipan pe mɨrɨ awonsi'kɨ ewaruma'tɨto' oton ta? ");
INSERT INTO akeNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","E'tane nin si ekama uya ɨpɨ'nokon, Iraisa uye'ka'sa', mɨrɨpan pɨ' i'se te'to' kon ku'sa' to' uya ipɨ' iye'menukasa' na'ne' kasa rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ipoitorʉ ton tonpa ton piya' to' uye'sa' a'tai, anpisin ton nɨ ka'pon amʉ' ene'pʉ to' uya to' oi. Main pɨ' enupanin nan e'sei'pɨtʉ esi'pʉ to' pokon pe. ");
INSERT INTO akeNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sises ensa' tanporon kon ka'pon amʉ' uya a'tai, ipan pe rɨ to' usewansiuka'pʉ, mɨrɨpan kon eka'tumʉ'pʉ ipiya', “Miyarɨ” ka'se'na ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tʉpoitorʉ ton ekama'po'pʉ Sises uya, “Ɨ'rɨ pɨ' to' pokon pe ɨye'sei'pɨtʉ kon?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Anpisin ton koro'tawon ka'pon uya eikʉ'pʉ, “Ti'sa, umu ne'sa' uya ɨpiya', apʉne pʉra ɨri a'kwarʉ esi iyau, mɨrɨpan uya imaimu'kasa'. ");
INSERT INTO akeNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mɨrɨ ɨri a'kwarʉ e'sara'tɨ a'tai, eno'ma iya non pona. Inta a'koronta, tʉyɨ kɨtɨtɨi'ma iya, mɨrɨpan e'sitɨnka. Ɨpoitorʉ ton ekama'po'pʉ uya to' uya enpa'kato' pe, e'tane to' uya ikupʉ poken pʉra iyesi'pʉ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","“Ɨri sɨ, apurɨnin nan pen nɨ serɨ a'taino kon! Ɨ'rɨ pʉ'kʉ pona rɨ ɨpiyau'nokon esi? Ɨ'rɨ pʉ'kʉ pona aya'kɨrɨ'nokon esi? Ine'tɨ' upiya',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","To' uya inee'pʉ ipiya'. Ɨri a'kwarʉ uya Sises ensa' a'tai, inke pʉra warawo' mʉre ennoko'pʉ iya yai. Ita'mo'ka'pʉ non pona, mɨrɨpan e'rakairakaima'pʉ, inta a'koronta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","“Ɨ'rɨ a'tai serɨ kasa iyesi e'sara'tɨ'pʉ?” ta'pʉ Sises uya ikʉipʉnʉ pɨ'. “Mʉre pe iyesi'pʉ si'kɨrɨ rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Inke rɨ iwɨnɨ i'se iye'pɨ'sa' mɨrɨ teno'mapɨ'se apo' ya' mɨrɨ awonsi'kɨ tuna ka'. Ina pɨ' ɨsentu'ma', ina ipika'tɨ', ikupʉ auya poken iyesi yau,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“Ɨ'rɨ ta auya e'kwa pe iyesi, ‘Ikupʉ auya poken iyesi yau,’ mʉkayai'ne'? Tanporon nɨ e'kupʉ apurɨnin nan pɨ',” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Inke pʉra warawo' mʉre kʉipʉnʉ uya tʉukɨ'pɨ'nʉmʉ pe, “Apurɨ uya rɨ; upika'tɨkɨ apurɨnin pe pʉra e'to' entai enato' pe!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Sises uya anpisin uyepʉ a'ko pe tʉpiya' ene a'tai, ɨri a'kwarʉ eseremekʉ'pʉ iya, “Ipana pʉn mɨrɨ awonsi'kɨ imaimu pʉn a'kwarʉ, kʉrɨ rɨ warawo' mʉre apai epa'kakɨ. Mɨrɨ tʉpo, iya' kanan kewomʉi,” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ɨri a'kwarʉ upirorʉmʉ'pʉ, mɨrɨpan uya warawo' mʉre ennoko'pʉ yai ipan pe, mɨrɨpan epa'ka'pʉ. Warawo' mʉre esi'pʉ eke' kasa, mɨrɨpan tu'kan kon uya, “Iyeri'sa',” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","E'tane Sises uya warawo' mʉre anʉmʉ'pʉ itemiyatʉ pɨ', mɨrɨpan e'mʉ'sa'ka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Sises ewomʉ'pʉ tʉpo, ipoitorʉ ton uya ekama'po'pʉ ama'ai, “Ɨ'rɨ pe ken si iyesi pɨ' ina uya enpa'ka pʉra iyesi?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","“Ɨ'rɨ pen nɨ, ɨpʉreman uya rɨken serɨ rupɨ enpa'ka,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Mɨrɨ pata nɨmɨ'pʉ to' uya, mɨrɨpan kon utɨ'pʉ Kiyarari poro. Sises esi'pʉ mɨrɨ yau tesi tukai' ɨnʉ' uya rɨ ti'tu i'se pʉra, ");
INSERT INTO akeNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","apʉne pʉra tʉpoitorʉ ton enupa tʉuya pɨ'. Ta'pʉ iya to' pɨ', “Ka'pon, Papa winon eparankato' oton ka'pon amʉ' ena'. To' uya iwɨto' oton, e'tane itosorʉwano wʉi pata'pʉ pe iye'mʉ'sa'kato' oton,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","E'tane to' uya ito'ka'nʉkʉ pʉra rɨ iyesi'pʉ, ɨ'rɨ ta iya e'kwa pe iyesi tukai', mɨrɨpan kon enari'nʉmʉ'pʉ mɨrɨ pɨ' ɨnekama'popai pʉra. ");
INSERT INTO akeNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","To' utɨ'pʉ Ka'paneyan pona. Tewomʉ tʉpo, Sises uya tʉpoitorʉ ton ekama'po'pʉ, “Ɨ'rɨ pɨ' me'sei'pɨ'tʉune' asanta tau?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","E'tane to' uya eikʉ pʉra iyesi'pʉ, apʉne pʉra asanta tau ɨnʉ' esi eke pe kuru tukai' to' e'sei'pɨtʉ esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sises ereuta'pʉ, mɨrɨpan uya 12 kaisaron kon tʉpoitorʉ ton kɨ'ma'pʉ, “Wapiya e'pai na'ne' e'to' pe iyesi, iu'matʉ yau mɨrɨ awonsi'kɨ tanporon kon poitorʉ pe iye'to' pe iyesi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Temekon tʉtʉse iwoi mʉre ta'sii' isoto'ka'pʉ iya to' koro'tau, mɨrɨpan uya ta'pʉ to' pɨ', ");
INSERT INTO akeNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ɨnʉ' uya rɨ pʉsamoro mʉre amʉ' tonpa ereutanʉkʉ pe iyesi yau uyese' yau, urɨ rɨ ereutanʉkʉ iya pe iyesi; mɨrɨ awonsi'kɨ ɨnʉ' uya rɨ urɨ ereutanʉkʉ pe iyesi yau, urɨ rɨken ereutanʉkʉ iya pen mɨrɨ, kʉrɨ uyenno'nin nʉ'pʉ kanan ereutanʉkʉ iya pe iyesi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","“Ti'sa,” ta'pʉ Isaan uya, “Ka'pon ene'pʉ ina uya ɨyese' yau makoi a'kwarʉ ton enpa'kapɨ'nin. Iyereutato' pe ina uya ikupʉ'pʉ, apʉne pʉra urɨ'nokon tonpa pe pʉra iyesi pɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Sises uya ta'pʉ to' pɨ', “Kʉsereutanʉ'tʉu, apʉne pʉra ɨnʉ' rɨ eke Papa tʉrawasooi ku'nin nʉ'pʉ uyese' yau usaurokʉ poken pʉra iyesi mɨrɨ tʉpo ɨri pe upɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Uyewa'noma iya 'nokon pʉra na'ne' esi mɨrɨ uwenaino' kon pe rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","I'napairon ekama uya ɨpɨ'nokon, ɨnʉ' rɨ tuna ke ɨwo'payai'ne'nokon uyese' yau apʉne pʉra Kʉrai iwano' pe ɨwesi kon pɨ', tepe'pʉ nonka iya pen kuru rɨ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Mɨrɨ awonsi'kɨ ɨnʉ' uya rɨ pʉsamoro uyapurɨnin nan aiko ton nʉ'kwɨ tonpa e'makoima emapu'tɨsa' yau, wakʉ iwa pe rɨ iyesi parau ka' eno'ma eke rɨ a'nai' e'pato' ike ewa'tɨsa' i'mʉ pɨ' esa' pe. ");
INSERT INTO akeNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ɨyemiyatʉ uya ɨye'makoima emapu'tɨ pe iyesi yau, a'tɨkɨ. Wakʉ iwa pe rɨ iyesi itemiyatʉ pʉra esii'ma tɨwɨrɨ rɨ uko'man nɨto' ya' ɨyepa'ka a'tai, tanporo temiyatʉ ke ekota'man nɨto' ya' ɨutɨ entai, apo' usenkʉ'to' pen nɨ ya'. ");
INSERT INTO akeNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mɨrɨ awonsi'kɨ a'ta uya ɨye'makoima emapu'tɨ pe iyesi yau, a'tɨkɨ. Wakʉ iwa pe rɨ iyesi i'ta pʉra esii'ma tɨwɨrɨ rɨ uko'man nɨto' ya' ɨyepa'ka a'tai, ti'ta ke ɨyeno'ma entai ya'mu pʉn ekota'man nɨto' ya'. ");
INSERT INTO akeNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ɨyenu uya ɨye'makoima emapu'tɨ pe iyesi yau, imo'kakɨ. Wakʉ iwa pe rɨ iyesi mɨrɨ tikin nɨ itenu tɨwɨrɨ rɨ uko'man nɨto' ya' ɨyepa'ka a'tai, asa'rɨ itenu ɨyeno'ma entai ya'mu pʉn ekota'man nɨto' ya'. ");
INSERT INTO akeNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mɨrɨ yau, “‘to' weruweei erikʉ pen nɨ, mɨrɨ awonsi'kɨ apo' usenkʉ'nʉkʉ pen nɨ.’ ");
INSERT INTO akeNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tanporon kon nɨ e'ne'ne'ma mɨrɨ apo' ke. ");
INSERT INTO akeNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Waiyo esi wakʉ, e'tane ine'ne' pe pʉra iyenasa' yau, nai kasa ken si ine'ne' pe kanan iye'to' pe iku'kapʉ auya? Waiyo iku'tɨ' ayau'nokon, tʉusewankamai' pʉra ɨko'mantɨ' ɨtonpa kon amʉ' pokon pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Mɨrɨ a'tai, Sises uya mɨrɨ pata nɨmɨ'pʉ, mɨrɨpan utɨ'pʉ Isutiya nono pe te'sen ya' tuna Isotan ratoi pon anpisin pe rɨ kanan ka'pon amʉ' uye'kaa'pʉ ipiya', mɨrɨpan kon enupa'pʉ iya, teseru yau rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pari'si amʉ' tonpa ton uyee'pʉ ipiya', mɨrɨpan kon uya i'tupɨtʉ'pʉ ekama'popɨtʉ tʉuya'nokon winɨ, “Main awɨrɨ rɨ e'nɨ pe rɨ pe' iyesi ka'pon uya tʉno'pʉ nonka a'tai?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Sises uya to' eikʉ'pʉ to' ekama'po pe, “Ɨ'rɨ tawon ken Main tʉrʉ'pʉ Mosi' uya ɨyena'nokon?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","To' uya eikʉ'pʉ, “Mosi' uya itʉsa' ka'pon uya e'nonkan nɨto' karetaai tʉmenukai' tʉno'pʉ enno'to' pe tasa' iya,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Sises uya ta'pʉ to' pɨ', “Mosi' uya serɨ main menuka'pʉ, apʉne pʉra sa'man pe rɨ ɨyewan kon esi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","E'tane iye'kapʉ epiya'tɨ yau, ‘Papa uya warawo' mɨrɨ awonsi'kɨ uri'san kaa'pʉ,’ tasa' iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Mɨrɨ wenai, warawo' uya tʉkʉipʉnʉ mɨrɨ awonsi'kɨ tʉsan nɨnto' esi, mɨrɨpan uta'sikʉ tʉno'pʉ ya', ");
INSERT INTO akeNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","mɨrɨpan asa'ron kon ena tikin nɨ ipun,’ tasa' iya. Asa'rɨ to' esi pen, e'tane tikin nɨ to' esi. ");
INSERT INTO akeNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mɨrɨ pe iyesi pɨ', Papa na'sikʉ'san ɨsipona mo'ka ka'pon uya kʉse'nin,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","To' enna'posa' a'tai ɨutɨ ta', ipoitorʉ ton uya serɨ pɨ' ekama'po'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Eikʉ'pʉ iya, “Ɨnʉ' rɨ tʉno'pʉ nonkayai'ne' mɨrɨpan uya tʉron nɨ uri'san mari'ma ekuma pe iyesi tʉno'pʉ piyapai. ");
INSERT INTO akeNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mɨrɨpan tʉtaan'pʉ nonka iya pe iyesi yau mɨrɨpan uya tʉron nɨ warawo' mari'ma yau, iyekuma pe rɨ iyesi mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ka'pon amʉ' uya mʉre amʉ' nee'pʉ Sises piya' to' a'pɨ'to' pe iya, e'tane ipoitorʉ ton uya to' eseremekʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Sises uya ensa' a'tai, isakorota'pʉ, mɨrɨpan uya ta'pʉ tʉpoitorʉ ton pɨ', “Tɨwɨ mʉre amʉ' nʉyepʉi upiya'. To' kʉsereutanʉ'tʉu, apʉne pʉra Papa e'to' esa' wannɨ pe esi pʉsamoro waraino kon iwano' pe. ");
INSERT INTO akeNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","I'napairon ekama uya ɨpɨ'nokon, ɨnʉ' rɨ kʉrɨ Papa e'to' esa' wannɨ pe eporo iya pʉra na'ne' mʉre kasa te'se ewonto' oton pen nɨ ya',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Mʉre amʉ' anʉmʉ'pʉ iya temekon pona, mɨrɨpan kon pona temiyatʉ tʉtʉse to' pʉrema'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Utɨn pɨ' Sises e'sara'tɨ koro'tau, ka'pon eka'tunsa' uyee'pʉ, mɨrɨpan e'sekunka'pʉ irau, mɨrɨpan uya ekama'po'pʉ, “Wakʉ, Ti'sa, ɨ'rɨ kuru ku'to' uya esi tɨwɨrɨ uko'man nɨto' epoto' pe uya?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","“Ɨ'rɨ pe iyesi pɨ' Wakʉ tukai' uyesakʉ auya?” tukai' Sises uya eikʉ'pʉ. “Ɨnʉ' wakʉ pʉra rɨ iyesi, e'tane Papa rɨken. ");
INSERT INTO akeNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mosi' nʉmenuka'pʉ i'tu auya: ‘Ɨnʉ' rɨ kʉ'wɨnɨi, iyemari'masa' uri'san kʉsekumankai, ama' pe kesii, kasi pe ka'pon pɨ' kasaurokʉi, enku'tɨnin pe kesii, ɨkʉipʉnʉ mɨrɨ awonsi'kɨ asan inamakɨ,’ tawon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","“Ti'sa, tanporo rɨ serɨ ton awɨrɨ e'sa' man mʉre' esi'pʉ si'kɨrɨ rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Sises uya ene'pʉ i'nʉnka pe, “Tikin nan nɨken e'nonkasa' man. Tanporo ɨpiyau na'ne' ikʉrʉpo'pomata, mɨrɨpan epe'pʉ tʉrʉ pa entu'manin nan ena'. Mɨrɨ a'tai nin si, imaminke' pe ɨwesi mɨrɨ Epʉn po. Mɨrɨ ku'sa' auya tʉpo, upɨkɨrɨ ɨuyepʉ pa,” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mɨrɨ eta iya a'tai, ika'nɨ' pʉra rɨ itemʉ' ena'pʉ. Pokoi pe itɨ'pʉ, apʉne pʉra eke pe kuru itimamin esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sises uya tenu tʉpɨtʉ'pʉ, mɨrɨpan uya ta'pʉ tʉpoitorʉ ton pɨ', “Sa'man pe kuru rɨ iyesi, imaminke' ton epa'ka poken pʉra Papa e'to' esa' wannɨ pe ya'!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ipoitorʉ ton usewansiuka'pʉ imaimu pɨ'. E'tane Sises uya takaa'pʉ kanan, “Mʉre amʉ', sa'man pe kuru rɨ iyesi Papa e'to' esa' wannɨ pe ya' epa'kan poken pʉra. ");
INSERT INTO akeNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Sa'man pe pʉra rɨ kiyamerʉ epa'ka akusa enu euta awɨrɨ, imaminke' epa'ka Papa e'to' esa' wannɨ pe ya' entai,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ipan pe miyarɨ rɨ mɨrɨ pɨ' ipoitorʉ ton usewansiuka'pʉ, mɨrɨpan kon usekama'popɨtʉ'pʉ, “Ɨnʉ' kuru ken si epika'tɨ?” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","To' enei'ma Sises uya ta'pʉ to' pɨ', “Ka'pon pona sa'man pe iyesi, e'tane Papa pona tanporo sa'man pe pʉra iyesi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pi'ta uya ta'pʉ ipɨ', “Tanporon nɨ sa'ne nɨnsa' ina uya ɨpɨkɨrɨ tʉutɨto' kon pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","“I'napairon ekama uya ɨpɨ'nokon,” ta'pʉ Sises uya, “ɨnʉ' rɨ kʉrɨ tʉpata'se', takon non, tʉparusi ton, tʉsan, tʉkʉipʉnʉ, tʉmunkɨ amʉ' mɨrɨ pe pʉra tʉmainarʉ nɨnsa' iya na'ne', urɨ pɨkɨrɨ mɨrɨ awonsi'kɨ wakʉ itekare pɨkɨrɨ, uya ");
INSERT INTO akeNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","eke pe rɨ tepe'pʉ eporo mɨrɨ, serɨ pe na'ne' entai rɨ — tʉpata'se', takon non, tʉparusi ton, tʉsanon, tʉmunkɨ amʉ' mɨrɨ awonsi'kɨ tʉmainarʉ rɨ mɨrɨ awonsi'kɨ ewa'noman nɨ nɨrɨ — mɨrɨ awonsi'kɨ serɨ enta', tɨwɨ rɨ uko'man nɨto' eporo iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tu'kan kon nɨ wapiya na'ne' nan e'to' oton iu'matʉ pe, mɨrɨ awonsi'kɨ iu'matʉ pe iye'sa' kon nin si e'to' oton wapiya te'ton kon pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","To' utɨ koro'tau Surusiran pona, Sises to' rawɨrɨ, ipoitorʉ ton usewansiukasa' esi'pʉ, to' pɨkɨrɨ te'san enari'nʉntane. Sises uya kanan tʉpoitorʉ ton pantaka'pʉ, mɨrɨpan uya tʉpɨ' te'ku'ton ekama'pʉ to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Utɨ'nokon serɨ Surusiran pona. Mɨrɨ yau Ka'pon, Papa winon eparankato' oton use'man nɨto' tʉrawasomanin nan epuru ton mɨrɨ awonsi'kɨ Main pɨ' enupanin nan ena', to' uya eno'mato' oton ima'tato' ya', mɨrɨpan tʉto' oton to' uya Esuwerʉ amʉ' pen ena'. ");
INSERT INTO akeNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kamoro uya nin si isapema mɨrɨ, to' eta'tapɨtʉ ipona, to' uya ari'po'pɨtʉ; mɨrɨ awonsi'kɨ to' uya iwɨnɨ. Osorʉwau wʉi pata'pʉ pe, iye'mʉ'sa'kato' oton,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Mɨrɨ a'tai, Isens mɨrɨ awonsi'kɨ Isaan, Sepiti munkɨ amʉ' uyee'pʉ ipiya', “Ti'sa, ɨ'rɨ rɨ ina nekama'poyai'ne' ɨpɨ' kupʉ auya i'se ina man ina iwano' pe,” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Ɨ'rɨ ken kupʉ uya i'se me'atʉu ɨiwano' kon pe?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","“Tɨwɨ tikin nɨ ɨyenwo'netʉ winɨ mɨrɨ awonsi'kɨ akamisi winɨ ina nereutai ayapon po ɨyereutasa' a'tai kʉrore po,” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","“Ɨ'rɨ pɨ' uyekama'po auya'nokon tukai' i'tu auya'nokon pʉra rɨ iyesi,” ta'pʉ Sises uya. “Sensiyai'ne' ken pe' ensi auya'nokon, mɨrɨ pe pʉra ɨyepa'taisima kon ken pe' epa'taisimayai'ne' ike ke?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Ina uya rɨ ikupʉ,” ta'pʉ to' uya. Sises uya ta'pʉ to' pɨ', “I'napairɨ rɨ unensinʉ rɨ ensi auya'nokon, ɨyepa'taisima kon nɨ epa'taisimayai'ne' ke. ");
INSERT INTO akeNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","E'tane ereutapai me'atʉi'ne' uyenwo'netʉ mɨrɨ awonsi'kɨ ukamisi winɨ kupʉ uya poken pʉra iyesi. Serɨ esi mɨrɨ kamo to' ku'sa' na'ne' nan Papa uya rɨ pata'se' pe iyesi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kamo 10 kaisaron kon uya serɨ etasa' a'tai, Isens mɨrɨ awonsi'kɨ Isaan pokon pɨ' to' usakorota'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Sises uya tanporo to' amʉranʉkʉ'pʉ, mɨrɨpan uya ta'pʉ to' pɨ', “I'tu auya'nokon nɨ kamo itepuru pe na'ne' nan nɨ esi mɨrɨ Esuwerʉ amʉ' pen epuru pe, mɨrɨpan eke ton uya tʉmerunitɨrʉ kon apurɨ to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","E'tane mɨrɨ kasa ɨwesi kon pen. E'tane ru'ku, ɨnʉ' rɨ esi yau eke pe enapai ɨ'koro'tau'nokon e'to' pe iyesi ɨpoitorʉ kon pe, ");
INSERT INTO akeNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","mɨrɨ awonsi'kɨ ɨnʉ' rɨ esi yau wapiyaro' e' pe e'pai, tɨwɨ nesii tanporon kon apiyo' pe. ");
INSERT INTO akeNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Apʉne pʉra Ka'pon, Papa winon uye'sa' mɨrɨ tapiyo' pe e'nɨto' pe pen, e'tane apiyo' pe e'se'na, mɨrɨ awonsi'kɨ tʉuko'manto' tʉse'na tu'kan kon ka'pon amʉ' epe' pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Iseri'ko pona to' uyee'pʉ. Sises mɨrɨ awonsi'kɨ ipoitorʉ ton mɨrɨ tʉpo anpisin ton ka'pon amʉ' uya mɨrɨ eke pata nɨmɨ koro'tau, tenku'nan ka'pon, Pa'timeyas itese' ereutasa' esi'pʉ asanta ka'ta po eta'kwanʉn nɨ pɨ' (Timeyas mumu pe te'sen). ");
INSERT INTO akeNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Sises kʉrɨ rɨ Nasare' pon tawon etasa' tʉuya a'tai, ukɨ'pɨ'nʉnpɨ' nɨ pɨ' iye'sara'tɨ'pʉ, “Sises, Tepi' pa rʉ'pʉ, upɨ' ɨsentu'makɨ!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tu'kan kon uya rɨ eseremekʉ'pʉ e'pana iye'to' pe, e'tane rɨ miyarɨ rɨ ikɨ'pɨ'nʉnpɨtʉ'pʉ, “Tepi' pa rʉ'pʉ, upɨ' ɨsentu'makɨ!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Sises e'takʉ'ka'pʉ, mɨrɨpan uya, “Ikɨ'matɨ',” ta'pʉ. Mɨrɨpan kon uya nin si ikɨ'ma'pʉ, “Epori'ma'! E'mʉ'sa'ka'! Ɨkɨ'ma iya,” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tʉpon pʉro'pon nin si eno'ma'pʉ iya mɨrɨ, te'sanʉmʉ pe iye'mʉ'sa'ka'pʉ, mɨrɨpan uyee'pʉ Sises piya'. ");
INSERT INTO akeNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","“Ɨ'rɨ kupʉ uya i'se me'an ɨiwano' pe?” ta'pʉ Sises uya ipɨ'. Tenku'nan ka'pon uya, “Rapai, ennin pe kanan e'pai e'ai',” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“Enta, anapurɨnʉ uya ɨyepi'tɨsa' man,” ta'pʉ Sises uya ipɨ'. Inke pʉra rɨ, ennin pe iyena'pʉ, mɨrɨpan nin si utɨ'pʉ mɨrɨ asanta tawɨrɨ Sises pɨkɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Surusiran eporo to' uya koro'tau, Pe'pake mɨrɨ awonsi'kɨ Pe'tani ya' si to' uye'ka'sa' Are' Wʉpʉ pon, Sises uya asa'ron kon tʉpoitorʉ ton ennoko'pʉ ");
INSERT INTO akeNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","tai'ma to' pɨ', “Entantɨ' ɨyentau'nokon na'ne' eke iwa pata ya', iya' ɨyepa'ka kon pe rɨ, mɨrɨ yau eporo auya'nokon mɨrɨ isa'ka'si mʉre ewa'tɨsa', ɨnʉ' utɨ'pʉ ipo pen nɨ. Teukai' mʉne'tʉi' serɨ ya'. ");
INSERT INTO akeNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ɨnʉ' uya rɨ ɨyekama'po kon yau, ‘Ɨ'rɨto' pe mɨrɨ kupʉ auya'nokon?’ tukai', ‘Itepuru esi i'se inke pʉra inna'poto' pe tʉuya rɨ,’ mʉkatʉi' ipɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mɨrɨpan kon utɨsa' uya isa'ka'si mʉre eporo'pʉ pʉroroi po asanta tau ewa'tɨsa' mʉra'ta piyau. Euka pɨ' to' esi koro'tau, ");
INSERT INTO akeNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","mɨrɨ yau iye'soto'pɨ'sa' kon ka'pon amʉ' uya, “Ɨ'rɨ kupʉ auya'nokon, kʉrɨ rɨ isa'ka'si mʉre meukayatʉi'ne'?” ta'pʉ to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","To' eikʉ'pʉ to' uya, Sises uya ta'pʉ kasa rɨ, mɨrɨpan kon uya to' uya ato' pe ikupʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Isa'ka'si mʉre ne'sa' to' uya a'tai Sises piya', tʉpon kon tʉpɨtʉ'pʉ to' uya ipʉro'pona, mɨrɨpan po iyereuta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tu'kan kon ka'pon amʉ' uya tʉpon kon ta'nʉkʉ'pʉ asanta tawɨrɨ, tʉron kon uya mɨrɨ'tawon yʉi pantarʉ'pɨ'sa' ta'nʉ'tane asanta tawɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kamoro to' rawɨrɨ tʉutɨsan mɨrɨ awonsi'kɨ kamoro to' e'ma'pʉ pe tʉutɨsan ukɨ'pɨ'nʉnpɨtʉ'pʉ, “Usana!” “Pori' rɨ kʉrɨ esi Itepuru ese' yau nʉye'ai'ne'!” ");
INSERT INTO akeNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Pori' pe rɨ e'nɨ ukʉipʉnʉ kon Tepi' e'to' esa' wannɨ pe uyepʉ pɨ'!” “Usana ka' entawon yau!” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Sises epa'ka'pʉ Surusiran pona, mɨrɨpan utɨ'pʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' ta', mɨrɨpan uya tanporon nɨ enpɨtʉ'pʉ. Pata uko'manka'sa' pɨ' nin si, iyenna'po'pʉ mɨrɨ Pe'tani pona 12 kaisaron kon tʉpoitorʉ ton pokon pe. ");
INSERT INTO akeNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mɨrɨ ema'sa' yau, Pe'tani poi to' enna'po koro'tau, Sises esi'pʉ iwan pe. ");
INSERT INTO akeNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ɨnnɨ tare kenan, pi' e' ene tʉuya pɨ', itɨ'pʉ teperu ke pe' iyesi tukai' ense'na. Eposa' iya a'tai, ɨ'rɨ eporo'pʉ iya pen nɨ, iyare ton nɨken, apʉne pʉra pi' weyu pe pʉra pata esi'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","mɨrɨpan uya ta'pʉ pi' e' pɨ', “Tɨwɨ si ɨnʉ' rɨ ɨyeperu na'nin kanan serɨ enta',” ta'pʉ iya. Ipoitorʉ ton uya mɨrɨ ta iya eta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Surusiran eporo pe, Sises ewomʉ'pʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' pʉ'kʉ ta', mɨrɨpan e'sara'tɨ'pʉ usennapɨ' nɨ pɨ', kʉrʉpo'po pɨ' mɨrɨ yau te'san enpa'kapɨtʉ pɨ'. Pʉrata ensimapɨ'nin nan tepʉrʉʉi rawoipɨtʉ'pʉ iya mɨrɨ awonsi'kɨ wako'wa amʉ' kʉrʉpo'pomanin nan apon ton nɨ, ");
INSERT INTO akeNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ɨnʉ' uya rɨ tʉkʉrʉpo'pooi arɨ i'se pʉra rɨ iyesi'pʉ mɨrɨ awɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","To' enupa tʉuya koro'tau nin si, “Iye'menukasa' pʉra pe' nai: “‘Uiwʉ' esa'to' oton tanporon kon tʉpataron kon ɨpʉremato' iwʉ',’ tukai'? E'tane ‘ama' amʉ' en pe rɨ’ iku'sa' auya'nokon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Papa ena' use'man nɨto' tʉrawasomanin nan epuru ton mɨrɨ awonsi'kɨ Main pɨ' enupanin nan uya mɨrɨ eta'pʉ, mɨrɨpan kon e'sara'tɨ'pʉ iwɨto' tʉuya'nokon eseru warinpa pɨ', ipɨ' tenari'nʉmʉ kon pɨ', apʉne pʉra anpisin nɨ usewansiukasa' pɨ' to' enupato' iya pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pata uko'mansa' a'tai, Sises mɨrɨ awonsi'kɨ ipoitorʉ ton utɨ'pʉ pata yapai. ");
INSERT INTO akeNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Awanakʉi' mɨrɨ ema'sa' yau, to' utɨ koro'tau asanta tawɨrɨ, to' uya pi' e' ene'pʉ. Iyeri'sa' esi'pʉ siya rɨ imi' pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pi'ta enu ya' iyee'pʉ, mɨrɨpan uya ta'pʉ Sises pɨ', “Rapai, apʉne enkɨ. Pi' e' anpa'nʉkʉ'pʉ useketasa'!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Sises uya eikʉ'pʉ, “Papa apurɨto' esa' pe e'tɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","I'napairon ekama uya ɨpɨ'nokon; ɨnʉ' uya rɨ se wʉ' pɨ' ta pe iyesi yau, ‘Parau ka' ɨsennasikata,’ ikasimai'ma pʉra tewan yau, e'tane apurɨi'ma tʉmaimu awɨrɨ iye'kupʉ tukai', iye'kupʉ rɨ itiwano' pe. ");
INSERT INTO akeNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mɨrɨ pɨ' ekama uya ɨpɨ'nokon, ɨ'rɨ rɨ ekama'po auya'nokon a'tai ɨwɨpʉremato' kon yau, apurɨtɨ' eposa' auya'nokon tukai', mɨrɨ a'tai ɨiwano' kon pe rɨ iyesi. ");
INSERT INTO akeNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ɨpʉreman pɨ' ɨye'mʉ'sa'kasa' kon a'tai, mɨrɨ koro'tau ekamʉra rɨ ɨnʉ' pɨ' rɨ ɨwesi kon yau, ipɨ' ɨsentu'matɨ', ɨkʉipʉnʉ kon, Epʉn pon usentu'mato' pe amakooi kon pɨ',” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Surusiran pona kanan to' enna'pokaa'pʉ. Sises usarɨ koro'tau Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' pʉ'kʉ tau, Papa ena' use'man nɨto' tʉrawasomanin nan epuru ton, Main pɨ' enupanin nan mɨrɨ awonsi'kɨ Esuwerʉ amʉ' epuru ton uyee'pʉ ipiya', ");
INSERT INTO akeNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","mɨrɨpan kon uya ekama'po'pʉ, “Ɨ'rɨ meruntɨrʉ winɨ serɨ ton kupʉ auya? Ɨnʉ' uya serɨ meruntɨ ke ɨrepasa' serɨ kupʉ pa?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Sises uya entakanoma'pʉ, “Tikin nan pɨ' rɨ ɨyekama'po uya 'nokon. Uyei'tɨ'; mɨrɨ a'tai nin si ekama uya mɨrɨ, mɨrɨ winɨ umeruntɨrʉ tepose, serɨ ton kupʉ uya tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Isaan uya pa'taisiman nɨto'—Epʉn winon pe', mɨrɨ pe pʉra ka'pon amʉ' winon katɨ? Ekamatɨ'!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tiwano' kon pe to' usaurokʉ'pʉ, “‘Epʉn winon,’ ta pe iyesi yau, ‘Ɨ'rɨ pe ken si iyesi pɨ' apurɨ auya'nokon pʉra iyesi'pʉ?’ ta iya esi. ");
INSERT INTO akeNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","E'tane, ‘Ka'pon amʉ' winon,’ ta pe iyesi yau,… .” (To' enari'nʉmʉ ka'pon amʉ' pɨ', apʉne pʉra tanporon kon uya rɨ Isaan esi pu'kena' pe ta pɨ'.) ");
INSERT INTO akeNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mɨrɨpan kon uya Sises eikʉ'pʉ, “Ina uya i'tu pʉra man,” ta'pʉ to' uya. Sises uya ta'pʉ to' pɨ', “Apana'tɨ uya 'nokon pʉra rɨ nɨrɨ iyesi mɨrɨ, mɨrɨ meruntɨrʉ winɨ serɨ ton kupʉ uya tukai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Panton yai to' auro'ka pɨ' Sises e'sara'tɨ'pʉ: “Ka'pon uya umɨ pɨmɨ'pʉ kʉre' itese', si'na' pe te'sen kiyari ye' ke. Iwoi iwekupiri'tɨ'pʉ iya, ikasu'kato' iyai aka'pʉ iya, mɨrɨ awonsi'kɨ ipa'simato' awonsi'kɨ ka'tawon soto'pan ɨutɨ amɨ'pʉ iya. Mɨrɨpan nin si tʉrʉ'pʉ iya mɨrɨ umɨ pɨ' te'san ena', mɨrɨpan utɨ'pʉ siya rɨ tʉpata'se' yapai. ");
INSERT INTO akeNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Iyakʉ'pʉsa' anʉmʉ weyu si e'seposa' a'tai, tʉpoitorʉ si ennoko'pʉ iya umɨ tʉrʉ'pʉ tʉuya itena' ton piya' ti'kiyari epose'na. ");
INSERT INTO akeNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","E'tane kʉrɨ rɨ a'si'pʉ to' uya, ipanta'ma'pʉ to' uya, mɨrɨpan nin si ennoko'pʉ to' uya mɨrɨ itemiyatʉ arʉ pʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mɨrɨ a'tai, tʉron nɨ kanan tʉpoitorʉ ennoko'pʉ iya to' piya'; i'pai pɨ' nin si pʉse rɨ wɨpɨtʉ'pʉ to' uya mɨrɨ, mɨrɨpan ɨri pe rɨ to' uya ikupʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","E'tane rɨ kanan tʉron nɨ ennoko'pʉ iya. Kʉrɨ rɨ nin si wɨnɨ'pʉ to' uya mɨrɨ. Tu'ke rɨ tʉron kon enno'pɨtʉ'pʉ iya; tʉron kon nɨ panta'mapɨtʉ'pʉ to' uya, tʉron kon nɨ wɨnɨi'ma. ");
INSERT INTO akeNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Tikin nɨ nin si inennokonʉ e'nonkasa' esi'pʉ, imu rɨ nin si, ini'nʉnkanʉ. ‘Pʉse rɨ, umu nin si nama to' uya mɨrɨ,’ tai'ma nin si tanporon kon u'matʉ pe ennoko'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“E'tane nin si to' uya ta'pʉ mɨrɨ, tiwano' kon pe, ‘Pʉse rɨ kuru pʉse rɨ kiyari pata'se' anʉnton. Iwɨto' kon pe ɨsi'tɨ', inanʉmʉnʉ e'to' pe uiwano' kon pe,’ ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","To' uya si a'si'pʉ, mɨrɨpan wɨnɨ'pʉ to' uya, mɨrɨpan eno'ma'pʉ to' uya kiyari e'kwa apai. ");
INSERT INTO akeNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ɨ'rɨ ken si kupʉ kʉrɨ rɨ kiyari e'kwa esa' uya? Iyepʉ kamoro itesa' pe tʉnnonka'san wɨse'na, mɨrɨpan uya nin si mɨrɨ kiyari e'kwa tʉrʉ mɨrɨ tʉron kon ena'. ");
INSERT INTO akeNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Itekare pe' iye'menukasa' ennin nan pen ɨmɨrɨ'nokon: “‘Tɨ' ɨutɨ amɨnin nan neno'ma'pʉ enasa' itekun airon tɨ' pe; ");
INSERT INTO akeNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Itepuru uya rɨ serɨ ku'sa', mɨrɨpan esi wakʉ pe kuru uyenu kon yau,’ tukai'?” ");
INSERT INTO akeNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","A'sito' tʉuya'nokon ipɨkɨrɨ warinpa'pʉ to' uya, apʉne pʉra tʉpɨ'nokon ta iya e'kwa pe mɨrɨ panton ekamasa' iya tukai' to' uya i'tu'pʉ. E'tane anpisin ton ka'pon amʉ' pɨ' to' enari'nʉmʉ'pʉ; mɨrɨpan kon uya nin si inɨmɨ'pʉ mɨrɨ, to' utɨ'pʉ ipiyapai. ");
INSERT INTO akeNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Emennʉ'pʉ po iwa rɨ, Pari'si amʉ' mɨrɨ awonsi'kɨ Era' pɨkɨron kon ennoko'pʉ to' uya Sises eparantɨi' imaimu winɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","To' uyee'pʉ ipiya', mɨrɨpan kon uya ta'pʉ ipɨ', “Ti'sa, ina i'tu pɨ' man i'napairon ye' pe ɨwesi tukai'. Ka'pon amʉ' rɨ nensimanʉ pe pʉra ɨyeseru esi, apʉne pʉra ɨnʉ' pe rɨ to' esi pɨ' te'namasen pe pʉra ɨwesi; e'tane Papa eseru pɨ' enupan auya i'napairon awɨrɨ. Ipoken pe' iyesi Sisa ena' pʉrata tʉtʉsen e'ma a'tai, kane katɨ? ");
INSERT INTO akeNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ina uya pe' e'ma, mɨrɨ pe pʉra ina uya e'ma pen nɨ katɨ?” ta'pʉ to' uya. E'tane wakʉ pe to' e'ku'to' eseru i'tusa' Sises uya esi'pʉ, “Ɨ'rɨ pe iyesi pɨ' usa'mapai ɨwesi kon? Apʉne pʉrata pun ine'tɨ' ento' pe uya,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","To' uya pʉrata pun nee'pʉ, mɨrɨpan kon ekama'po'pʉ iya, “Ɨnʉ' nai ipɨ'? Mɨrɨ awonsi'kɨ ɨnʉ' ese' nai ipɨ'?” ta'pʉ iya. “Sisa,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mɨrɨ a'tai, Sises uya ta'pʉ to' pɨ', “Sisa iwano' rɨ itʉtɨ' Sisa ena', mɨrɨ awonsi'kɨ Papa iwano' rɨ kanan tʉrʉ auya'nokon Papa ena',” ta'pʉ iya. Mɨrɨpan kon nin si usewansiuka'pʉ mɨrɨ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mɨrɨ a'tai, Satu'si amʉ', eri'nɨ tʉpo e'mʉ'sa'kan pʉra rɨ iyesi tawon nan uyee'pʉ Sises ekama'pose'na. ");
INSERT INTO akeNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ti'sa, Mosi' uya imenukasa' uiwano' kon pe, ka'pon rui eri'sa' yau, tʉno'pʉ tʉnonkai' imunkɨ pʉra, iyakon nʉ'pʉ uya ino'pʉ rʉ'pʉ mari'mato' pe iyesi, mɨrɨpan kon umu'tato' pe tʉrui iwano' pe. ");
INSERT INTO akeNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Moro 7 kaisaron kon ɨsirunan esi'pʉ. Wapiyaro' emari'ma'pʉ, mɨrɨpan erikʉ'pʉ innonkaton kon imunkɨ amʉ' pʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ipɨkɨron nʉ'pʉ uya nin si ino'pʉ rʉ'pʉ mari'ma'pʉ mɨrɨ, e'tane iyerikʉ'pʉ tʉumu'tai' pʉra rɨ kanan. Mɨrɨ kasa rɨ to' osorʉwano pe te'sen esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mɨrɨ kasa rɨ tanporo 7 kaisa rɨ to' esi'pʉ imunkɨ amʉ' pʉra rɨ to' eri'pɨtʉ'pʉ. Kʉrɨ rɨ nin si uri'san erikʉ'pʉ mɨrɨ to' e'ma'pʉ pe rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Eri'nɨ tʉpo e'mʉ'sa'kan nɨsa' a'tai, ɨnʉ' no'pʉ pe ken si iyesi mɨrɨ, apʉne pʉra sa'ne 7 kaisaron kon uya imari'mapɨ'sa'?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Sises uya ta'pʉ to' pɨ', “Ipoken pʉra pe' ɨwesi kon pen mɨrɨ iye'menukasa' itekare mɨrɨ pe pʉra Papa meruntɨrʉ i'tu auya'nokon pʉra iyesi pɨ'? ");
INSERT INTO akeNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Iyeri'sa' kon e'mʉ'sa'kasa' a'tai, to' emari'ma pʉra rɨ iyesi, mɨrɨ pe pʉra to' e'tʉrʉ pen nɨ emari'man nɨto' yau; Epʉn pon kon, inserʉ amʉ' kasa to' e'to' oton. ");
INSERT INTO akeNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Iyeri'sa' kon e'mʉ'sa'ka tawon pɨ', Mosi' karetaai yawon pe' ensa' auya'nokon pʉra rɨ iyesi, yu' epo'tɨ'pʉ tawon? Mɨrɨ yau, Papa uya ta'pʉ ipɨ', ‘Urɨ kʉrɨ rɨ Epʉra'an, Aisi' mɨrɨ awonsi'kɨ Seko' pokon e'to' itese' pɨ'.’ ");
INSERT INTO akeNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Papa, iyeri'sa' kon e'to' itese' pɨ' pe iyesi pen, e'tane nurɨnan kon nɨken. Ipoken pʉra kuru ɨwesi kon mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Main pɨ' enupanin nan tonpa uye'sa' uya to' usaurokʉ etapɨtʉ'pʉ. Wakʉ pe to' maimu ei'sa' Sises uya pɨ', ekama'po'pʉ iya, “Tanporon iyawɨrɨ e'nɨto' pe inonkasa' Main ton koro'tapai, nai esi eke pe kuru?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Sises uya ta'pʉ ipɨ', “Se kuru serɨ eke, ‘Etatɨ' Esuwerʉ amʉ' rʉ'kwɨ; Itepuru itese' pɨ' e'nɨto' esi, tikin nan nɨ Itepuru; ");
INSERT INTO akeNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Itepuru, itese' pɨ' ɨwe'to' i'nʉnkakɨ tanporo ɨyewan pokon pe, aya'kwarʉ pokon pe, ɨusenuminkato' pokon pe mɨrɨ awonsi'kɨ tanporo ɨmeruntɨrʉ pokon pe,’ tawon. ");
INSERT INTO akeNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ipɨkɨron esi se: ‘Ɨtonpa i'nʉnkakɨ mɨsi'nʉnkayai'ne' kasa,’ tawon. Serɨ ton iyawɨrɨ e'nɨto' entaino eke pʉra rɨ iyesi mɨrɨ,” ta'pʉ Sises uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","“Ti'sa, wakʉ pe kuru ei'sa' auya man, ipoken nɨ mʉkayai'ne' esi, Papa esi tikin nan nɨ, ɨnʉ' pʉra rɨ iyesi e'tane kʉrɨ rɨ rɨken. ");
INSERT INTO akeNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","I'nʉnkato' tanporo ewan wannɨ pokon pe, ito'ka'nʉ'to' pokon pe mɨrɨ awonsi'kɨ meruntɨrʉ wannɨ pokon pe, mɨrɨ awonsi'kɨ tonpa i'nʉnka usi'nʉnkan kasa rɨ esi eke pe kuru tʉpo'tɨse tʉtʉsen mɨrɨ awonsi'kɨ tʉron nɨ ton nɨ use'man nɨto' entai,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Wakʉ pe teikʉ iya etasa' Sises uya a'tai, “Ɨnnɨ pʉra rɨ me'ai' Papa e'to' esa' wannɨ pe piyapai,” ta'pʉ iya ipɨ'. Mɨrɨ awonsi'kɨ nin si mɨrɨ enta', ɨnʉ' rɨ esi'pʉ ɨnekama'popɨ'pai pʉra. ");
INSERT INTO akeNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Sises esi koro'tau enupan pɨ' Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' pʉ'kʉ tau, to' ekama'po'pʉ iya, “Ɨ'rɨ pe iyesi pɨ' Main pɨ' enupanin nan uya Kʉrai esi Tepi' pa rʉ'pʉ pe ta? ");
INSERT INTO akeNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tepi' rɨ usaurokʉ'pʉ Wakʉ A'kwarʉ uya tʉmaimu'tɨi', “‘Itepuru uya ta'pʉ uyepuru pɨ': “Ereuta' enwo'ne' uyemiyatʉ winɨ, ɨyeyaton non tʉrʉ uya a'ta o'koi' pʉ'kʉ pona,” ta'pʉ iya.’ ");
INSERT INTO akeNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tepi' uya tʉmɨrɨ pe rɨ ‘uyepuru’ tukai' esakʉ, nai kasa ken ipa rʉ'pʉ pe iyesi nesii'no?” ta'pʉ iya. Anpisin ton Sises etanin nan esi'pʉ pori' pe. ");
INSERT INTO akeNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","To' enupa tʉuya koro'tau, Sises uya ta'pʉ to' pɨ', “Tenu ke e'tɨ' Main pɨ' enupanin nan pɨ', ɨpininpaino kon kusan tʉpon kon yau, ‘Miyarɨ,’ ta i'sero' kon tʉpɨ'nokon kʉrʉpo'po pɨ' e'nɨ pata'se' yau rɨ, ");
INSERT INTO akeNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","eke ton apon po kuru te'san Esuwerʉ amʉ' usenupato' iwʉ' tau, mɨrɨ awonsi'kɨ tʉnamasan pata'se' yau kuru te'san enta'nan a'tai'ne. ");
INSERT INTO akeNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Itaan'pʉ ima'tasa' rʉ'san iwʉ' mo'kanin nan to' enapai, mɨrɨpan kon ɨpʉrema kusan pe, mɨ pe te'kupʉ kon pe. Pʉsamoro waraino kon kota'ma mɨrɨ ɨsɨ pe kuru rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sises ereuta'pʉ tʉtʉsen nonkato' to' uya pata'se' ratoi pe, anpisin ton ka'pon amʉ' uya tʉpʉrataai kon tʉpɨtʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' pʉrataai yen ya' enpɨtʉ pɨ'. Tu'kan kon nɨ ipʉrataaike' ton uya eke pe rɨ itʉpɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","E'tane rʉ'kwɨ nin si entu'manin itaan'pʉ ima'tasa' rʉ'pʉ uyee'pʉ, mɨrɨpan uya rʉ'kwɨ asa'ron pʉrata ka'pa muku'pɨ tʉrʉ'pʉ, peni punu'pɨ rʉ'kwɨ rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tʉpoitorʉ ton tʉkɨ'mai' tʉpiya', ta'pʉ to' pɨ', “I'napairon ekama uya ɨpɨ'nokon, pʉse rɨ entu'manin itaan'pʉ ima'tasa' rʉ'pʉ uya eke pe kuru itʉsa' mɨrɨ pʉrata yen ya', tanporo tʉron kon entai kuru. ");
INSERT INTO akeNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tʉpʉrataai kon tonpa rɨ nin tʉsa' to' uya, e'tane kʉrɨ rɨ, tekota'mato' apai rʉ'kwɨ rɨ tanporo rɨ tʉpiyawon tʉrʉ'pʉ tʉuko'manto' ipɨ' rʉ'kwɨ rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' nɨmɨ iya koro'tau, ipoitorʉ ton tonpa uya ta'pʉ ipɨ', “Ti'sa, apʉne enkɨ; ɨ'rɨ eke ton nɨ tɨ' amʉ'! Ɨ'rɨ wakʉ pe rɨ amɨsa' ɨutɨ ton!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","“Tanporo rɨ pe' serɨ ton eke ton ɨutɨ amɨpɨ'sa' menyan?” ta'pʉ Sises uya. “Tikin nɨ rɨ tɨ' e'nonkato' oton pen mɨrɨ ɨsipʉro'po; tanporon nɨ uta'po'to' oton mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Sises ereutasa' koro'tau Are' Wʉpʉ po, Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' ratoi pe, Pi'ta, Isens, Isaan, mɨrɨ awonsi'kɨ Anturu pokon uya ekama'po'pʉ ama'ai, ");
INSERT INTO akeNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ina pɨ' ekamakɨ, ɨ'rɨ a'tai kuru ken si serɨ ton e'ku'to' oton? Ɨ'rɨ kuru ken si esi mɨrɨ ento' ipɨ' pe tanporo serɨ ton uta'ku'tɨ ekamanin pe?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Sises uya ta'pʉ to' pɨ', “Tenu ke e'tɨ', ɨnʉ' uya rɨ ɨyenku'tɨ kon namai'. ");
INSERT INTO akeNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tu'kan kon nɨ uye'to' oton uyese' yau, ‘Urɨ rɨ kʉrɨ rɨ,’ ka'se'na, mɨrɨpan kon uya tu'kan kon nɨ enku'tɨto' oton. ");
INSERT INTO akeNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Tʉusewa'nomasan mɨrɨ awonsi'kɨ usewa'noman man tawon eta auya'nokon a'tai, ketʉipɨ'tʉu mɨrɨ pɨ'. Serɨ warai'nan nɨ e'ku'to' pe iyesi e'tane apʉne rɨ non weyu u'ma'to' uye'tane rɨ iyesi. ");
INSERT INTO akeNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tʉpataron kon uya tʉpataron kon nɨ nɨrɨ ewa'nomato' oton, mɨrɨ awonsi'kɨ esa' wannɨ pe rɨ te'san uya esa' wannɨ pe te'san nɨ nɨrɨ ewa'noma. Mɨrɨ a'tai, tʉrʉ'pʉnʉ amʉ' mɨrɨ awonsi'kɨ iwankan e'to' oton mɨrɨ pata kaisa rɨ. Serɨ ton si esi mɨrɨ e'tinkan e'sara'tɨ pe. ");
INSERT INTO akeNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ɨserasu pe rɨ me'tʉi'. Ɨtʉto' oton kon mɨrɨ pata konsʉrʉʉi amʉ' ena', mɨrɨ awonsi'kɨ Esuwerʉ amʉ' usenupato' iwʉ' tau ayari'po'pɨ'to' oton kon. Urɨ pɨkɨrɨ ɨye'soto'kato' oton kon kopʉna amʉ', mɨrɨ awonsi'kɨ kin amʉ' rau rɨ to' pana ya' urɨ ekama pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mɨrɨpan wapiya kuru wakʉ itekare usekamato' pe iyesi tanporon kon mɨ yawɨron kon pana ya'. ");
INSERT INTO akeNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","To' uya aya'sisa' kon arɨ a'tai ko'tʉ ta', pena rɨ kɨsewankamatʉu, ‘Ɨ'rɨ kuru ta uya?’ tukai', amaimu'tɨsa' kon na'ne' ke rɨ ausaurokʉ kon mɨrɨ, ɨiwano' kon pe ausaurokʉ kon pen e'tane Wakʉ A'kwarʉ usaurokʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Eri'nɨto' ya' tʉrui eparankato' oton iyakon uya, ikʉipʉnʉ uya nɨrɨ tʉmʉre. Mɨrɨ kasa rɨ marɨ, mʉre amʉ' enato' oton tʉsan kon amʉ' ewa'noma pɨ' to' eri'to' ya' to' tʉrʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Urɨ uriya' tu'kan kon ka'pon amʉ' uya ɨyewaruma'tɨto' oton kon, e'tane kʉrɨ rɨ pana' pe ne'mʉ'sa'kayai'ne' iu'matʉ pona rɨ epika'tɨto' oton mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“‘Ɨri Kuru Nuirapanin Uma'tan Emapu'tɨnin’ e'soto'kasa' ene auya'nokon a'tai, tʉpata'se' pen nɨ yau—tɨwɨ serɨ ennin nʉto'ka'nʉkʉi—tɨwɨ kamoro Isutiya po na'ne' nan nainʉmʉi wʉ' ton pona'ne. ");
INSERT INTO akeNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tɨwɨ tiwʉ' nakapu po te'sen kʉu'tɨnin mɨrɨ pe pʉra kʉsewonnin nɨ ɨutɨ ta' ɨ'rɨ rɨ mo'kai'. ");
INSERT INTO akeNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tɨwɨ ɨnʉ' rɨ umɨ yau na'ne' kʉsenna'ponin tʉpon epose'na. ");
INSERT INTO akeNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mɨrɨ wʉi a'tai'ne ɨsɨ pe kuru rɨ uri'sami'si amʉ' mono' pe te'san pona iye'to' oton mɨrɨ, mɨrɨ awonsi'kɨ mana' pokon kon imunkɨ pona. ");
INSERT INTO akeNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ɨpʉrematɨ' serɨ e'kupʉ namai' komi' pe pata e'to' weyu a'tai, ");
INSERT INTO akeNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","apʉne pʉra mɨrɨ waraino ewankamanin e'ku'sa' pʉra rɨ iyesi iyepiya'tɨ'pʉ si'kɨrɨ, Papa uya non kaa'pʉ si'kɨrɨ serɨ pʉ'kʉ pona, mɨrɨ waraino kanan e'ku'to' oton pen nɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","“Itepuru uya serɨ iweyu ton nu'tɨsa' pʉra iyesi yau, ɨnʉ' ne'nonkai'no pen nɨ. E'tane anʉnsa' kon, tʉnanʉmʉ'san pɨkɨrɨ nin ito'kena'masa' iya mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mɨrɨ a'tai, ɨnʉ' uya rɨ ta pe iyesi yau ɨpɨ'nokon, ‘Apʉne entɨ', serɨ airɨ Kʉrai man!’ mɨrɨ pe pʉra, ‘Apʉne entɨ'! Mɨ airɨ man!’ ta pe iyesi yau, kʉsapurɨtʉu. ");
INSERT INTO akeNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Apʉne pʉra enku'tɨnin nan kʉrai amʉ', enku'tɨnin nan pu'kena' amʉ' usenpoikato' oton, mɨrɨpan kon uya i'tuto' ipɨ' ton mɨrɨ awonsi'kɨ eke Papa tʉrawasooi ton ku'to' oton anʉnsa' kon enku'tɨ pe, ikupʉ tʉuya'nokon poken iyesi yau. ");
INSERT INTO akeNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mɨrɨ pɨ' ɨiwano' kon pe rɨ ɨserasu kon pe e'tɨ'; tanporon nɨ ekamasa' uya mɨrɨ ɨpɨ'nokon iweyu wapiya. ");
INSERT INTO akeNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“E'tane mɨrɨ a'tai'ne, usewankaman pata'pʉ pe, “‘Wʉi enu ewarumanto' oton, kapʉi e'wei'tɨto' oton pen; ");
INSERT INTO akeNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","sirikɨ amʉ' uta'po'to' oton ka' apai, mɨrɨ awonsi'kɨ ka' yau rɨ te'san usi'ki'mato' oton.’ ");
INSERT INTO akeNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Mɨrɨ a'tai si, ka'pon amʉ' uya Ka'pon, Papa winon uyepʉ ento' oton mɨrɨ kapuru' yau eke tʉmeruntɨrʉ ke mɨrɨ awonsi'kɨ a'kwa yau, ");
INSERT INTO akeNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","mɨrɨpan uya tinserʉʉi ton ennoko tʉnanʉmʉ'san amʉranʉ'se asakɨrɨ'nan a'setun uye'to' yawɨron kon nɨ, non pʉ'kʉ u'matʉ apai'ne, ka' u'matʉ pʉ'kʉ ponsi'kɨ'ne. ");
INSERT INTO akeNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ɨsenupatɨ' se pi' e' pɨ': Iyepanta'tɨ are ton atu'ta a'tai, a'ko pe wʉi a'ne' pe pata e'to' weyu e'seporo tukai' i'tu auya'nokon. ");
INSERT INTO akeNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mɨrɨ kasa rɨ, serɨ ton e'kupʉ ene auya'nokon a'tai, a'ko pe iyesi mʉra'ta nau rɨ tukai' i'tu auya'nokon. ");
INSERT INTO akeNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","I'napairon ekama uya ɨpɨ'nokon; serɨ a'taino kon kuru rɨ pʉra iyenato' oton pen nɨ serɨ ton e'kupʉ pʉ'kʉ pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Epʉn mɨrɨ awonsi'kɨ non pʉra iyenato' oton, e'tane umaimu mɨrɨ tereutaton pen nɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ɨnʉ' uya mɨrɨ wʉi mɨrɨ pe pʉra iwekusi i'tu pʉra rɨ iyesi, inserʉ amʉ' Epʉn pon kon uya rɨ mɨrɨ pe pʉra imu uya rɨ, e'tane ikʉipʉnʉ uya rɨken i'tu. ");
INSERT INTO akeNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ɨiwano' kon pe rɨ ɨserasu kon pe e'tɨ'! Tenu ke e'tɨ'! I'tu auya'nokon pʉra iyesi ɨ'rɨ a'tai mɨrɨ weyu e'seporo tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ɨnnɨ ka'pon utɨ kasa iyesi: Tʉpoitorʉ ton enau tiwʉ' nɨmɨ iya, to' tʉrawasooi ke to' tʉrepapɨ'se, mɨrɨ awonsi'kɨ mʉra'tanawon pɨ' tenu ke e'kɨ tai'ma. ");
INSERT INTO akeNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Mɨrɨ pe iyesi pɨ', enei'ma e'tɨ', apʉne pʉra i'tu auya'nokon kasa pʉra ɨ'rɨ a'tai ɨutɨ esa' enna'poto' oton tukai'—ko'mamʉ pe rɨ, mɨrɨ pe pʉra anomʉra' rɨ, mɨrɨ pe pʉra rɨ kɨrɨtɨkɨ uturumʉ a'tai rɨ, mɨrɨ pe pʉra pata emakʉ a'tai. ");
INSERT INTO akeNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ite'kwanau pʉra rɨ iyepʉ ɨyepotɨ'nin, ɨye'nʉmʉ kon eponin. ");
INSERT INTO akeNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ukayai'ne' rɨ ɨpɨ'nokon nɨ marɨ ta uya tanporon kon pɨ': ‘Tenu ke e'tɨ'!’” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Asa'rɨ rɨken wʉi e'ku'ka'sa' esi'pʉ To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ mɨrɨ awonsi'kɨ A'sarutanʉ'sa' Pen Pʉreti Pɨ' Enta'nan Weyu e'seporo rawɨrɨ, mɨrɨ pɨ' Papa ena' use'man nɨto' tʉrawasomanin nan epuru ton mɨrɨ awonsi'kɨ Main pɨ' enupanin nan esi'pʉ ama'ai Sises a'sito' tʉuya'nokon ipɨkɨrɨ warinpa pɨ' mɨrɨ awonsi'kɨ iwɨto' pe tʉuya'nokon. ");
INSERT INTO akeNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“E'tane Iweyu Rʉ'pʉ a'tai pen, ka'pon amʉ' nin e'sara'tɨ esi usewa'noman pɨ',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Pe'tani po iyesi koro'tau, tʉteire' po tenai' tepʉrʉ piyau, ka'pon, Saiman, erekʉ'pan tukai' ti'tusen iwʉ' tau, uri'san uyee'pʉ po'toro arapasta yawon, epe'kena' po'piyun esukenan natʉ konekasa' esa' pe. Tʉputurʉkai' i'pai pona po'piyun ma'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mɨrɨ yau te'san tonpa ton usakorota usaurokʉ'pʉ tiwano' kon pe, “Ɨ'rɨto' pe rɨ si po'piyun ma'tanʉkʉ ko? ");
INSERT INTO akeNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ikʉrʉpo'pomapaino rɨ tikin nɨ wʉipiya iye'tʉrawasomasa' e'mato' epe' entai rɨ, itepe'pʉ tʉto' pe entu'manin nan ena'!” ta'pʉ to' uya. Ɨsɨ pe rɨ to' uya eseremekʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","“Tɨwɨ nesii, ɨ'rɨ pe ikupʉ i'se ɨwesi kon? Wakʉ rɨ ku'sa' iya mɨrɨ upɨ',” ta'pʉ Sises uya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","“Entu'manin nan kamoro ɨpiyawon kon nɨ i'se ɨwe'to' kon a'tai rɨ ɨnpika'tɨnʉ kon, e'tane inke urɨ pʉra iyesi ɨpiyau'nokon. ");
INSERT INTO akeNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tʉnkupʉnʉ pokena' rɨ ku'sa' iya mɨrɨ, po'piyun masa' iya upona ukoneka pe uruwai' ya' utʉrʉ e'ma ta'. ");
INSERT INTO akeNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","I'napairon ekama uya ɨpɨ'nokon, mɨ awɨrɨ rɨ itekare nʉsekamayai'ne' non emʉ' kaisa rɨ, inkupʉ'pʉ rʉ'pʉ rɨ marɨ usekama mɨrɨ en yau ikupʉ pe rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Isutas Eskariya', 12 kaisaron kon ipoitorʉ ton tonpa utɨ'pʉ use'man nɨto' tʉrawasomanin nan epuru ton piya', Sises eparankase'na to' ena'. ");
INSERT INTO akeNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","To' epori'ma'pʉ mɨrɨ tetai', mɨrɨpan kon usaurokʉ'pʉ pʉrata ke irepato' tʉuya'nokon pɨ', mɨrɨpan esi'pʉ itʉto' tʉuya weyu eporo i'se. ");
INSERT INTO akeNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","A'sarutanʉ'sa' Pen Pʉreti Pɨ' Enta'nan Weyu e'sara'tɨ a'tai, iteseru pe To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ pɨ' karimeru mʉre wɨto' a'tai, Sises poitorʉ ton uya ekama'po'pʉ, “Nai ya' ina utɨ i'se me'an To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ pɨ' ɨyenta'nato' konekase'na?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Mɨrɨpan uya asa'rɨ tʉpoitorʉ ton ennoko'pʉ. To' pɨ' ta'pʉ iya, “Entantɨ' eke pata pona, mɨrɨpan yau, tuna anin ka'pon uya ɨyeporo kon mɨrɨ. Ipɨkɨrɨ mʉtɨtʉi'. ");
INSERT INTO akeNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Iyewonsa' na'ne' ita' ɨutɨ esa' mekama'potʉi', ‘Ti'sa man: Nai airɨ uiwʉ' oton nai To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ pɨ' upoitorʉ ton pokon pe enta'nato' itau? ta pɨ',’ mʉkatʉi'. ");
INSERT INTO akeNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ekama iya rɨ mɨrɨ ɨpɨ'nokon eke rɨ ka'tawon ɨutɨ tapurui'tɨse ikonekasa'. Mɨrɨ yau si enta'nan nɨto' mʉkonekatʉi',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ipoitorʉ ton si utɨ'pʉ eke pata pona, mɨrɨpan kon uya si eporo'pʉ Sises uya tauro'ka'pʉ kon kasa rɨ, mɨrɨpan kon uya si To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ pɨ' te'to' kon koneka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pata uko'mansa' a'tai, Sises uyee'pʉ 12 kaisaron kon pokon pe. ");
INSERT INTO akeNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tepʉrʉ piyau tʉteire' kon po tenai' enta'nan pɨ' to' esi koro'tau, ta'pʉ iya, “I'napairon ekama uya ɨpɨ'nokon, ɨtonpa kon uya uyeparankato' oton—kʉrɨ upokon pe enta'nan pɨ' na'ne' rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","To' si upokoita'pʉ, mɨrɨpan tikin pa'ne ta'pʉ to' uya ipɨ', “I'napai rɨ urɨ pen kuru rɨ?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","“Ɨmɨrɨ'nokon 12 kaisaron kon tonpa, tʉyu kipʉ pɨ' na'ne' pʉsau ya' upokon pe. ");
INSERT INTO akeNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ka'pon, Papa winon utɨto' oton iye'menukasa' tʉpɨ' na'ne' kasa rɨ, e'tane ɨsɨ yau rɨ kʉrɨ rɨ ka'pon esi Ka'pon, Papa winon eparankanin! Wakʉ pe rɨ nesii'no iyentusa' pʉra iyesi yau,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","To' enta'na koro'tau, Sises uya pʉreti anʉmʉ'pʉ, tenki ta'pʉ iya Papa pɨ', mɨrɨpan uya i'kwɨ'pɨtʉ'pʉ, mɨrɨpan ekamʉ'pʉ iya tʉpoitorʉ ton ena', “Anʉntɨ', serɨ serɨ upun,” tai'ma. ");
INSERT INTO akeNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mɨrɨ a'tai, ko' anʉmʉ'pʉ iya, tenki ta'pʉ iya Papa pɨ', mɨrɨpan uya to' o'pa'pʉ, tanporon kon uya iyawon ensi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","“Serɨ serɨ umʉnʉ, emenna' ekonekan nɨto' iwano', tu'kan kon iwano' pe iye'kwansa',” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","“I'napairon ekama uya ɨpɨ'nokon, iteperu euku ensito' uya oton pen ɨpokon pe 'nokon Papa e'to' esa' wannɨ pe yau emenna' pe ensi uya pʉ'kʉ pona,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Eren pɨ' tʉuserenkasa' kon tʉpo, to' utɨ'pʉ Are' Wʉpʉ pona. ");
INSERT INTO akeNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","“Tanporo rɨ unɨmɨ auya'nokon mɨrɨ,” tukai' Sises uya to' pana'tɨ'pʉ, “apʉne pʉra iye'menukasa': “‘Karimeru amʉ' pa'simanin wɨnɨ uya, mɨrɨpan karimeru amʉ' si e'ta'nʉ'to' oton,’ tawon. ");
INSERT INTO akeNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","E'tane erikʉ tʉpo, e'mʉ'sa'kasa' a'tai, utɨ mɨrɨ arawɨrɨ'nokon Kiyarari pona,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pi'ta uya ta'pʉ, “Tanporon kon uya ɨnɨntane, ɨnɨmɨ uya pen nɨ nin mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","“I'napairon ekama uya ɨpɨ', serɨ pe—i'nai rɨ sa'ne, serɨ ewarupɨɨi tau—kɨrɨtɨkɨ uturumʉ asa' ite'kwa rawɨrɨ, unonkato' auya oton osorʉwau ite'kwa,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","E'tane miyarɨ parɨ e'se'ne' pe parɨ Pi'ta uya ta'pʉ, “Ɨ'rɨ pe pʉra rɨ aya'kɨrɨ uma'ta pe iyesi yau, ɨnonka uya pen nɨ,” ta'pʉ iya. Mɨrɨ awonsi'kɨ tanporon kon uya rɨ mɨrɨ rɨ marɨ ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","To' utɨ'pʉ Ke'semani tukai' tesa'sen pata ya'. Mɨrɨ yau, Sises uya ta'pʉ tʉpoitorʉ ton pɨ', “Ereutapɨ'tɨ' se airɨ ɨpʉrema tane,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Mɨrɨpan uya Pi'ta, Isens mɨrɨ awonsi'kɨ Isaan arɨ'pʉ ta'kɨrɨ, mɨrɨpan usewankama ena'pʉ ika'nɨ' pʉra ipan pe rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","“Uya'kwarʉ man pokoi pe, uma'tan poken nɨ,” ta'pʉ iya to' pɨ'. “Serɨ yau e'tɨ' tenu ke,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Itɨ'pʉ miyarɨ parɨ ɨnnɨ iwa ita'mo'ka'pʉ non pona ɨpʉremase'na tʉpɨ' te'ku'sen si usentakato' pe. ");
INSERT INTO akeNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Apa, Papai, tanporon nɨ e'ku'to' pe iku'nin pe ɨwesi, serɨ ko' imo'kakɨ uyenapai. E'tane i'se ɨwe'to' rɨken e'ku'to', i'se e'to' pen,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mɨrɨpan enna'po'pʉ tʉpoitorʉ ton piya', mɨrɨpan uya to' e'nʉmʉ eporo'pʉ. “Saiman,” ta'pʉ iya Pi'ta pɨ', “ɨye'nʉnsa' si mɨrɨ? Tenu ke pe' ɨwesi poken pʉra iyesi mara rʉ'kwɨ rɨ? ");
INSERT INTO akeNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tenu ke esii'ma ɨpʉrematɨ', i'tupɨ'nɨto' ya' auta'mo'ka kon namai'. Iya'kwarʉ esi ɨnku'pai, e'tane ipun esi ɨ'sɨ'mʉra,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Itɨkaa'pʉ ɨpʉremase'na mɨrɨ kasa rɨ marɨ kanan. ");
INSERT INTO akeNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Iyenna'posa' a'tai kanan, to' rɨ marɨ e'nʉnsa' eporo'pʉ iya, apʉne pʉra e'tape'ne' pe'ne to' enu pi'pɨ ton esi ke. Ɨ'rɨ rɨ ta tʉuya'nokon ipɨ' tukai' to' uya i'tu pʉra rɨ iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Itosorʉwano ite'kwa tenna'poi', ta'pʉ iya to' pɨ', “Mɨrɨ si e'nʉn nɨ pɨ' rɨ mɨrɨ awonsi'kɨ umoronka' nɨ pɨ' rɨ ɨwesi kon? Eke pe man! Iweyu si e'seposa' man. Ka'pon, Papa winon eparankasa' man tʉmakooikena' nan ena'. ");
INSERT INTO akeNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","E'mʉ'sa'katɨ'. Utɨnpai'nokon! Uyeparankanin si uye'ka'nɨ pɨ' man!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Usauro'nɨ pɨ' kuru rɨ iyesi koro'tau, Isutas, 12 kaisaron kon tonpa pe te'sen usenpoika'pʉ. Ipokon pe anpisin usepai'tɨpɨ'sa' supara ke mɨrɨ awonsi'kɨ wa'tana ke esi'pʉ use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru, Main pɨ' enupanin nan mɨrɨ awonsi'kɨ Esuwerʉ amʉ' epuru ton nennoko'san. ");
INSERT INTO akeNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Eparankanin uya tʉnku'ton ekamasa' esi'pʉ to' pɨ', “Kʉrɨ sa'su'kayai'ne' si kʉrɨ rɨ, ma'sitʉi', matʉi' terasu ke,” tasa' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Isutas utɨ'pʉ Sises piya' to'sarɨ rɨ, mɨrɨpan uya, “Rapai,” ta'pʉ ipɨ', mɨrɨpan a'su'ka'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mɨrɨpan kon uya Sises a'si'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mɨrɨ yau, a'ko pe iye'soto'pɨ'sa' kon tonpa uya tʉsuparaai mo'ka'pʉ, mɨrɨpan uya use'man nɨto' tʉrawasomanin nan epuru poitorʉ pana a'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sises uya, “Main awɨron kon pen pe' esa' pe esi serɨ, ɨuye'sa' kon na'ne' supara amʉ' mɨrɨ awonsi'kɨ wa'tana amʉ' esa' pe uya'sise'na? ");
INSERT INTO akeNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Wʉi kaisarɨ rɨ ɨpiyau'nokon esi'pʉ, enupan pɨ' Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' pʉ'kʉ tau, uya'si auya'nokon pʉra rɨ. E'tane imenukasa' itekare uta'ku'tɨto' pe rɨ iyesi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Mɨrɨ a'tai, tanporon kon ipoitorʉ ton uya inonka'pʉ, mɨrɨpan kon ainʉmʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Moine e'wontɨsa' epe'kena' pon renen tato' atʉ ke tʉpon ke pʉra esii'ma utɨ esi'pʉ Sises pɨkɨrɨ. Mɨrɨpan a'si i'se to' e'tane, ");
INSERT INTO akeNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","to' enapai temo'kai' iyeka'tumʉ'pʉ iwon pʉra. ");
INSERT INTO akeNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","To' uya si Sises arɨ'pʉ use'man nɨto' tʉrawasomanin nan epuru piya', mɨrɨpan tanporo use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru, Esuwerʉ amʉ' epuru ton nɨ, mɨrɨ awonsi'kɨ Main pɨ' enupanin nan nɨ amʉra'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pi'ta uya e'ma'pʉka'pʉ ɨnnonsi'kɨ rɨ, use'man nɨto' tʉrawasomanin nan epuru iwʉ' pʉrorooi pona. Mɨrɨ yau iyereutasa' esi'pʉ erasu amʉ' pokon pe a'non pɨ' apo' piyau. ");
INSERT INTO akeNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru mɨrɨ awonsi'kɨ tanporon kon nɨ Esuwerʉ amʉ' Konsʉrʉʉi ton esi'pʉ Sises ewa'nomato' tʉuya'nokon ipɨkɨrɨ eporo i'se itʉto' pe tʉuya'nokon ima'tato' ya', e'tane to' uya ɨ'rɨ rɨ eporo'pʉ pen nɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tu'kan kon nɨ usaurokʉ'pʉ ipɨ' kasi ye' pe rɨ, e'tane ɨsi'kaisa rɨ pʉra to' maimu esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mɨrɨ a'tai, tʉron kon e'soto'pɨ'sa' usaurokʉ'pʉ kasi ye' pe rɨ ipɨ' se tukai': ");
INSERT INTO akeNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ina uya eta'pʉ, ‘Serɨ ka'pon nʉkoneka'pʉ use'man nɨto', ɨpʉreman nɨto' iwʉ' ma'tanʉkʉ uya mɨrɨ, mɨrɨ awonsi'kɨ osorʉwau wʉi yau, tʉron nɨ kanan amɨ uya, ka'pon nʉkoneka'pʉ pe pʉra nin si,’ ta iya,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mɨrɨ rɨ e'tane, ɨsi'kaisa rɨ pʉra to' maimu esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mɨrɨ a'tai, use'man nɨto' tʉrawasomanin nan epuru e'soto'ka'pʉ to' rau, mɨrɨpan uya Sises ekama'popɨtʉ'pʉ, “Eikʉ auya pen nɨ pe' mɨrɨ? Ɨ'rɨ tukai' pʉsamoro ka'pon amʉ' usaurokʉ ɨpɨ'?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","E'tane Sises esi'pʉ e'pana rɨ to' eikʉ iya pʉra rɨ. Use'man nɨto' tʉrawasomanin nan epuru uya ekama'pokaa'pʉ kanan, “Ɨmɨrɨ pe' kʉrɨ rɨ Kʉrai, Iyɨpʉremasa' pe Te'sen Mu?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Mɨrɨpan pɨ', “Urɨ rɨ,” ta'pʉ Sises uya. “Ka'pon, Papa winon ereutasa' Meruntɨ pe te'sen emiya enwo'netʉ winɨ ento' auya'nokon oton, mɨrɨ awonsi'kɨ iyepʉ kapuru' yau Epʉn poi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Use'man nɨto' tʉrawasomanin nan epuru uya tʉpon karaka'pʉ. “Ɨ'rɨto' pe miyarɨ rɨ ekamanin nan i'se e'nɨ? ");
INSERT INTO akeNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Metatʉu rɨ sa'ne ko isaurokʉ Papa sapema pe. Ɨ'rɨ tukai' ken mɨsenuminkayatʉu?” ta'pʉ iya. Tanporon kon uya rɨ eno'ma'pʉ ima'tato' pe. ");
INSERT INTO akeNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mɨrɨpan tʉron kon nɨ eta'tapɨtʉ'pʉ ipona; to' uya itenu auromʉ'pʉ, tʉmokorooi kon ke to' uya iwɨnɨ'pʉ, mɨrɨpan, “Pu'kena' pe ekamakɨ!” ta'pʉ to' uya ipɨ', mɨrɨpan mo'ka'pʉ erasu ton uya, mɨrɨpan wɨpɨtʉ'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pi'ta esi koro'tau non po, ɨutɨ pʉrorooi po, uri'san, use'man nɨto' tʉrawasomanin poitorʉ uyee'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pi'ta a'no ensa' tʉuya a'tai, enpɨtʉ'pʉ iya a'ko pe esii'ma, “Ɨmɨrɨ rɨ nɨrɨ Nasare' pon Sises a'kɨron nʉ'pʉ,” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","E'tane i'tunin pe pʉra iye'kuu'pʉ, “I'tu uya pʉra man; ito'ka'nʉkʉ uya pʉra man ɨ'rɨ pɨ' ausaurokʉ tukai',” ta'pʉ iya, mɨrɨpan utɨ'pʉ utɨn nɨto' e'ma ta', mɨrɨ a'tai kɨrɨtɨkɨ uturumʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","To' poitorʉ uri'san uya ensa' a'tai mɨrɨ yau, takaa'pʉ iya kanan te'soto'pɨ'se iwoi te'san pɨ', “Pʉse rɨ kʉrɨ rɨ to' tonpa,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","I'tunin pe pʉra kanan iye'ku'kaa'pʉ. Mara rɨ iyesi tʉpo, kamoro a'ko pe iye'soto'pɨ'sa' kon uya ta'pʉ Pi'ta pɨ', “I'napai rɨ kuru rɨ ɨmɨrɨ kʉrɨ rɨ to' tonpa, apʉne pʉra Kiyarari pon pe ɨwesi,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tiwano' pe rɨ iye'pa'nʉkʉ'pʉ, mɨrɨpan uya ta'pʉ to' pɨ', “Pʉse rɨ ka'pon ipɨ' masauro'atʉi'ne' i'tu uya pʉra man!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Inke pʉra rɨ, iyakon ite'kwa pe kɨrɨtɨkɨ uturumʉ'pʉ. Mɨrɨ a'tai, Pi'ta uya Sises maimu rʉ'pʉ nee'pʉ tenu ya' tʉpɨ' isauro'sa' rʉ'pʉ, “Kɨrɨtɨkɨ uturumʉ rawɨrɨ iyakon ite'kwa pe, ‘I'tu uya pʉra man,’ tato' auya oton osorʉwau ite'kwa,” ta'pʉ iya rʉ'pʉ, mɨrɨpan ukaramʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ipan pe awanakʉi' kuru, use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru, Esuwerʉ amʉ' epuru ton pokon pe, Main pɨ' enupanin nan mɨrɨ awonsi'kɨ tanporo Konsʉrʉ amʉ' ekoneka'pʉ. To' uya Sises auronpɨtʉ'pʉ, mɨrɨpan arɨ'pʉ to' uya Paire' ena'. ");
INSERT INTO akeNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","“Esuwerʉ amʉ' kin pe' ɨmɨrɨ?” tukai' Paire' uya ekama'po'pʉ. “Ewai', mʉkayai'ne' kasa rɨ,” tukai' Sises uya eikʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tu'kan ke rɨ use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru uya eseru'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Mɨrɨ pɨ' Paire' uya kanan ekama'pokaa'pʉ, “Eikʉ auya pen nɨ pe' mɨrɨ? Menyan pe' tu'kan pɨ' rɨ to' uya ɨyeseru'tɨ?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","E'tane Sises uya entakanoma'pʉ pen nɨ; mɨrɨ uya Paire' ewansiuka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Iteseru si esi'pʉ mɨrɨ, to' enta'nato' weyu a'tai a'sisa' nonkato' ka'pon amʉ' nekama'po'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ka'pon, Parapas tukai' tesa'sen esi'pʉ pariki'si tau, pata esanon pokon pe ɨsewa'nomapai te'san koro'tau, ka'pon wɨnin nʉ'pʉ mɨrɨ a'tai. ");
INSERT INTO akeNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Anpisin uyee'pʉ Paire' piya' tʉnku'se' e' ku'se'na iye'to' pe tiwano' kon pe. ");
INSERT INTO akeNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","“Esuwerʉ amʉ' kin pe' nonka uya i'se me'atʉu ɨiwano' kon pe?” ta'pʉ Paire' uya to' pɨ', ");
INSERT INTO akeNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","tɨkɨnta kon wenai rɨ use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru uya Sises tʉsa' tena' i'tui'ma rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","E'tane use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru uya ka'pon amʉ' tʉrʉnka'pʉ Paire' uya Parapas ru'ku nonkato' pe tiwano' kon pe tawon nan pe. ");
INSERT INTO akeNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","“Ɨ'rɨ pe ken si Esuwerʉ amʉ' kin tato' kupʉ uya?” ta'pʉ Paire' uya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","“Kurusu' pona ipokapɨ'kɨ!” tukai' to' ukɨ'pɨ'nʉnpɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Ɨ'rɨto' pe? Ɨ'rɨ ɨri ku'sa' iya?” tukai' Paire' uya to' ekama'po'pʉ. E'tane miyarɨ rɨ eke pe to' ukɨ'pɨ'nʉnpɨtʉ'pʉ, “Kurusu' pona ipokapɨ'kɨ!” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pori' pe anpisin ɨnku'pai tesi pɨ', Paire' uya Parapas nonka'pʉ to' iwano' pe. Sises ari'po'pɨ'to' pe to' uya ikupʉ'pʉ iya, mɨrɨpan nonka'pʉ iya to' ena' kurusu' pona to' uya ipokapɨ'to' pe. ");
INSERT INTO akeNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sises ewonnʉkʉ'pʉ soisa amʉ' uya kopʉna iwʉ' ta' (kopʉna pe e'nɨ iwʉ', Pʉre'toriun itese'), mɨrɨpan kon uya tanporo tʉtonpa kon soisa amʉ' kɨ'ma'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","To' uya tʉtariren pon ya' ipontɨ'pʉ, mɨrɨpan kon uya tikʉ ke te'sen e'mepɨtʉ'pʉ aro', kʉron pe, mɨrɨpan ke to' uya arʉko'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mɨrɨpan kon uya esa'pɨtʉ'pʉ, “Miyarɨ, Esuwerʉ amʉ' kin!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mɨrɨpan kon uya kanan iwɨpɨtʉ'pʉ i'pai pɨ' yʉi ke, mɨrɨpan kon eta'tapɨtʉ'pʉ ipona. To' uta'mo'kapɨtʉ'pʉ tese'mu kon pona'ne inama pe itese'. ");
INSERT INTO akeNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Isapema'pʉ tʉuya'nokon nonka tʉpo, to' uya tʉtariren pon mo'ka'pʉ, mɨrɨpan kon uya ipontɨ'pʉ ipon nɨ nin si ya'. Mɨrɨpan arɨ'pʉ to' uya kurusu' pona ipokapɨ'se'na. ");
INSERT INTO akeNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ka'pon Sairini winon, Saiman itese', Arisanta mɨrɨ awonsi'kɨ Ru'pos kʉipʉnʉ uyepʉ esi'pʉ eke pata ya' sunwapai, mɨrɨpan a'kwarʉka'pʉ to' uya kurusu' ato' pe iya. ");
INSERT INTO akeNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Sises nee'pʉ to' uya pata Korʉko'ta tato' ya', pu'pɨ ɨ'pʉ rʉ'pʉ pata ta e'kwa pe. ");
INSERT INTO akeNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mɨrɨpan o'pa'pʉ to' uya waain sumasa' i'ne' mɨrʉ itese' ke, e'tane ensi iya pʉra iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mɨrɨpan pokapɨtʉ'pʉ to' uya kurusu' pona. Ipon nʉ'pʉ ta'nʉkʉ'pʉ to' uya, i'tuto' ipɨ' ke te'wapiya'kapɨ'se, epopɨtʉ'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","To' uya kurusu' pona ipokapɨtʉ'pʉ 9 a'kʉra'. ");
INSERT INTO akeNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Iwɨto' iwenai ento' ipɨ' menukasa' uya, ta esi'pʉ: esuwerʉ amʉ' kin, tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","To' uya ipokon pe asa'ron kon ama' amʉ' pokapɨ'sa' kurusu' pona esi'pʉ, tikin nɨ itenwo'netʉ winɨ mɨrɨ awonsi'kɨ tikin nɨ ikamisi winɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Serɨ kasa kuru si iye'menukasa' itekare uta'ku'tɨ'pʉ, “Ɨri ku'nin nʉ'san pokon pe iyesi'pʉ,” tawon. ");
INSERT INTO akeNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kamoro ipiyawɨrɨ tʉutɨsan uya ɨri pe rɨ isapema'pʉ. Ti'pai kon sʉkʉsʉkʉma'pʉ to' uya, “Ɨmɨrɨ si, ‘use'man nɨto', ɨpʉreman nɨto' iwʉ' ma'tanʉkʉ uya, mɨrɨpan kanan amɨkapʉ uya osorʉwau wʉi yau,’ tawon nʉ'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ɨu'tɨkɨ si kurusu' poi, epika'tɨkɨ ɨiwano' pe!” tai'ma. ");
INSERT INTO akeNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mɨrɨ kasa rɨ marɨ use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru mɨrɨ awonsi'kɨ Main pɨ' enupanin nan uya isapema'pʉ tʉmɨrɨ'nokon pe. “Tʉron kon pika'tɨ'pʉ iya, e'tane tiwano' pe iyepika'tɨ pʉra iyesi! ");
INSERT INTO akeNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tɨwɨ pʉse rɨ Kʉrai, Esuwerʉ amʉ' kin nʉu'tɨi serɨ pe kurusu' poi ento' pe, mɨrɨpan apurɨto' pe,” ta'pʉ to' uya. Kamoro iya'kɨrɨ kurusu' pona ipokapɨ'sa' kon uya rɨ nɨrɨ isapema'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","12 a'kʉra' a'tai, pata ewarumamʉ'pʉ 3 a'kʉra' pʉ'kʉ pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","3 a'kʉra' iye'tane Sises ukɨ'pɨ'nʉnpɨtʉ'pʉ eke pe rɨ, “Iroi, Iroi, rama sapa'tani?” ta'pʉ iya, “Papa, Papa, ɨ'rɨto' pe unonkasa' auya?” ta e'kwa pe. ");
INSERT INTO akeNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kamoro a'ko pe iye'soto'pɨ'sa' kon uya serɨ etasa' a'tai, “Apʉne etatɨ', Iraisa kɨ'ma pɨ' man,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tikin nan ka'pon eka'tumʉ'pʉ su'pa ki'se'na waain peneka ka', yʉi pɨ' tepu'tɨi' Sises uya ensito' pe itʉrʉ'pʉ iya. “Tɨwɨ nesii; apʉne Iraisa uyepʉ imo'kase'na enpai'nokon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Sises ukɨ'pɨ'nʉmʉ'pʉ eke pe rɨ, mɨrɨpan erikʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Esuwerʉ amʉ' use'mato', ɨpʉremato' itau wapu ekaraka'pʉ a'sa'mʉyai inakapu awonsi'kɨ non pona. ");
INSERT INTO akeNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Eke soisa amʉ' epuru pe te'sen iye'soto'kasa' rʉ'pʉ Sises rau uya Sises ukɨ'pɨ'nʉmʉ eta'pʉ, iyerikʉ rɨ ene'pʉ, mɨrɨpan uya, “I'napai rɨ kuru rɨ ka'si, pʉse rɨ esi'pʉ mɨrɨ wa Papa Mumu pe!” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tʉron kon uri'sami'si amʉ' uya enpɨtʉ'pʉ ɨnnonsi'kɨ, mɨrɨpan kon koro'tau Meri Mataren, Meri kanan aiko Isens mɨrɨ awonsi'kɨ Isoses san, mɨrɨ awonsi'kɨ Saromi esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kiyarari ponsi'kɨ pʉsamoro uri'sami'si amʉ' uyee'pʉ iya'kɨrɨ, i'se iye'to' ke to' uya imainanpa'pʉ. Tu'kan kon tʉron kon uri'sami'si amʉ' iya'kɨrɨ iye'sa' kon nʉ'san Surusiran pona rɨ nɨrɨ esi'pʉ mɨrɨ yau. ");
INSERT INTO akeNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ekonekan Weyu pe iyesi'pʉ, Sapa' e'ma ta'. Pata uko'mamʉ koro'tau, ");
INSERT INTO akeNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Isose', Arama'tiya pon to' nʉnamanʉ pe kuru te'sen Konsʉrʉ amʉ' tonpa, Papa e'to' esa' wannɨ pe uyepʉ enupɨkɨrɨ nɨrɨ te'sen utɨ'pʉ enari'mʉra rɨ Paire' piya', Sises ekepu ekama'pose'na. ");
INSERT INTO akeNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Paire' usewansiuka'pʉ iyeri'ka'sa' ta tetai'. Soisa amʉ' epuru tʉkɨ'mai', ekama'po'pʉ iya, “Sises pe' eri'ka'sa'?” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Soisa amʉ' epuru uya nin si tʉpana'tɨsa' a'tai, “Iyeri'ka'sa' rɨ,” tukai', itekepu nin si nonka'pʉ iya mɨrɨ Isose' ena'. ");
INSERT INTO akeNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Isose' uya nin si epe'kena' pon renen tato' atʉ enna'pʉ mɨrɨ, mɨrɨpan uya Sises ekepu mo'ka'pʉ kurusu' poi, iwontɨ'pʉ iya pon atʉ ke, mɨrɨpan emaika'pʉ iya uruwai' pe tɨ' akasa' ya'. Mɨrɨpan mʉra'taai pona tɨ' tɨrinka'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meri Mataren mɨrɨ awonsi'kɨ Meri, Isoses san uya mɨrɨ airɨ itʉrʉ ene'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sapa' pata'pʉ pe, Meri Mataren, Meri, Isens san, mɨrɨ awonsi'kɨ Saromi uya a'po'nan enna'pʉ Sises ekepu karapaimai' tʉutɨto' kon pe. ");
INSERT INTO akeNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Awanakʉi' kuru suntaaka epiya'tɨ pe wʉi enu enu'tane, to' utɨ esi'pʉ tɨ' akasa' uruwai' pona, ");
INSERT INTO akeNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","“Ɨnʉ' uya tɨ' uruwai' mʉra'ta pon tɨrinkato' pe uiwano' kon pe?” tukai' to' usekama'po'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","E'tane, tenu kon tʉsa' to' uya a'tai, to' uya eke kuru rɨ tɨ' e'tɨrinkasa' ene'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tɨ' akasa' uruwai' pe ya' to' ewomʉ koro'tau, moine, aimu'nan ipon ereutasa' enwo'ne' winɨ ene'pʉ to' uya, mɨrɨpan pɨ' to' etʉipɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","“Ketʉipɨ'tʉu,” ta'pʉ iya. “Si'tuyai' Sises, Nasare' pon warinpa auya'nokon kurusu' pona ipokapɨ'sa' rʉ'pʉ. Serɨ yau pʉra man, iye'mʉ'sa'kakaa'pʉ man! Apʉne entɨ', to' uya itʉrʉ'pʉ pata'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","E'tane entantɨ' ipoitorʉ ton nʉ'san ipana'tɨtantɨ' mɨrɨ awonsi'kɨ Pi'ta rɨ, ‘Itɨ mɨrɨ Kiyarari pona arawɨrɨ'nokon. Mɨrɨ yau ene auya'nokon, ta'pʉ tʉuya kasa rɨ,’” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Mɨrɨpan kon epa'ka'pʉ to' eka'tumʉ'pʉ uruwai' piyapai e'tɨtɨtɨ'kai'ma, apʉne pʉra ipan pe rɨ to' etʉipɨ'sa' esi'pʉ. Ɨ'rɨ ta'pʉ to' uya pen nɨ ɨnʉ' pɨ' rɨ, apʉne pʉra enari'ke' pe tesi kon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sises e'mʉ'sa'ka'pʉ terikʉ'pʉ tʉpo, awanakʉi' kuru Sonte a'tai, isenpoika'pʉ wapiya kuru Meri Mataren enu ya', 7 kaisaron kon makooi a'kwarʉ enpa'ka'pʉ iya rʉ'pʉ iyapai piya'. ");
INSERT INTO akeNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Itɨ'pʉ itonpa rʉ'san pana'tɨse'na, pokoi pe tesi kon pɨ' tʉukaransan. ");
INSERT INTO akeNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mɨrɨpan uya, “Sises man nurɨne. Ene'pʉ uya,” ta tane iya, to' uya apurɨ pʉra rɨ iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mɨrɨ tʉpo, Sises usenpoika'pʉ tʉron nɨ pe tenai' asa'ron kon utɨ koro'tau pata ya'. ");
INSERT INTO akeNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pʉsamoro si enna'po'pʉ tʉron kon pɨ' ekamase'na, e'tane to' apurɨ to' uya pʉra rɨ iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Emennʉ'pʉ rɨ, Sises usenpoika'pʉ 11 kaisaron kon piya' to' enta'na tane. To' eseremekʉ'pʉ iya to' napurɨnʉ pʉra iyesi pɨ', sa'man pe rɨ iye'mʉ'sa'kasa' ennin nʉ'san anapurɨpai pʉra to' esi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ta'pʉ iya si to' pɨ', “Entantɨ' tanporo rɨ non poro pata awɨrɨ wakʉ itekare ekamatantɨ' Papa nʉkapʉ'san pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ɨnʉ' rɨ apurɨnin nɨ epa'taisimasa' rɨ epika'tɨ, e'tane ɨnʉ' rɨ kʉrɨ apurɨnin pen nɨ eno'ma rɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Pʉsamoro uyese' apurɨnin nan uya si i'tuto' ipɨkɨrɨ meruntɨ eporo mɨrɨ makoi amʉ' enpa'kapɨtʉ mɨrɨ uyese' yau to' si usaurokʉ mɨrɨ emenna' main, siran yau. ");
INSERT INTO akeNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","To' uya ɨkʉi anʉmʉ mɨrɨ temiyatʉ kon ke, mɨrɨpan kon uya ɨsɨ rɨ paisin ensi, e'tane e'ne' pe to' kupʉ iya pen nɨ, mɨrɨpan kon uya temiyatʉ kon nonka takuru'kena' nan ka'pon amʉ' pona'ne, mɨrɨpan kon usepi'tɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Itepuru Sises usaurokʉ'pʉ tʉpo to' pokon pe, itanʉmʉ'pʉ Epʉn pona, mɨrɨpan ereuta'pʉ enwo'ne' Papa emiyatʉ winɨ. ");
INSERT INTO akeNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Mɨrɨpan ipoitorʉ ton utɨ'pʉ itekare ekamase'na mɨ awɨrɨ rɨ, mɨrɨpan Itepuru e'tʉrawasoma'pʉ to' a'kɨrɨ, mɨrɨpan i'napai rɨ tʉmaimu to' nekamanʉ esi ekamanin pe i'tuto' ipɨkɨrɨ eke ton tʉrawaso kupʉ'pʉ iya. 9 Uri'sami'si amʉ' utɨ'pʉ Pi'ta mɨrɨ awonsi'kɨ itonpa ton piya' to'ken nɨ tʉpana'tɨ'pʉ kon ekamase'na to' pɨ'. 10 Mɨrɨ tʉpo, tʉpoitorʉ ton poro, Sises uya tʉmɨrɨ pe, wʉi enu uye'to' winɨpai, wʉi enu utɨto' pʉ'kʉ pona wakʉ, to'panʉ'nin tɨwɨro' epika'tɨn nɨto' ekareei ennoko'pʉ. Amen.");
INSERT INTO akeNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Imenuka uya ɨyena', eke Tiyo'peras, tu'kan kon nɨ uya imenukasa' iye'ku'sa' rʉ'pʉ Sises pɨ' ina koro'tau. ");
INSERT INTO akeNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ina pɨ' tʉron kon nekama'pʉ menuka'pʉ to' uya. Kamo ina pana'tɨsa' iya na'ne' nan uya tanporo iye'sara'tɨ'pʉ si'kɨrɨ ene'pʉ. Kamoro si kamoro Papa apiyo' pe te'san tʉron kon enupa tʉuya'nokon winɨ imaimu pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Mɨrɨ wenai, urɨ uya rɨ nɨrɨ si a'tomasa' pɨ' tanporon nɨ, iye'sara'tɨ'pʉ si'kɨrɨ, urɨ pona nɨrɨ kanan si wakʉ pe iyesi ɨiwano' pe imenukato' pe uya, ɨmɨrɨ, eke tʉnamasen Tiyo'peras, ");
INSERT INTO akeNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","i'tu pa i'napairon ɨyenupasa' na'ne' ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kin pe Era' esi a'tai Isutiya po, moro Papa ena' use'man nɨto' tʉrawasomanin esi'pʉ Sakaraya itese', Apisa o'noron kon tonpa. Ino'pʉ, Resipe' itese' esi'pʉ kanan, Eran pa rʉ'pʉ pe. ");
INSERT INTO akeNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Asa'rɨ rɨ marɨ Papa Maimu awɨron kon pe to' esi'pʉ, tanporon nɨ Papa Maimu awɨrɨ te'san pe to' esi'pʉ tʉpʉreme'se pʉra. ");
INSERT INTO akeNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","E'tane to' munkɨ pʉra iyesi'pʉ, apʉne pʉra Resipe' esi'pʉ tʉumu'tasen pe pʉra. Asa'rɨ rɨ marɨ to' ukɨɨi'pansa' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tʉron nɨ a'tai nin si, tʉweyu kon e'seposa' a'tai, tamʉtʉ ton pokon pe Sakaraya e'tʉrawasoma esi'pʉ, use'man nɨto' Papa ena' tʉrawasoma pɨ' Surusiran po, Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' tau. ");
INSERT INTO akeNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Itonpa ton uya anʉnsa' esi'pʉ tʉutanʉnto' kon eseru yau iyewonto' pe Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' ta' a'po'nan kɨrɨi'nʉnpase'na. ");
INSERT INTO akeNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sakaraya ewonsa' a'tai Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' ta' a'po'nan kɨrɨi'nʉnpase'na, pʉroroi po tanporo iyamʉrasa' kon ɨpʉremase'na esi'pʉ ɨpʉreman pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mɨrɨ koro'tau, Papa inserʉʉi usenpoika'pʉ itenu ya'. Mɨrɨpan e'soto'kasa' esi'pʉ a'po'nan kɨrɨi'nʉnpato' apon enwo'netʉ winɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakaraya uya ensa' a'tai, iyetʉipɨtʉ'pʉ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","E'tane, “Ketʉipɨtʉi!” ta'pʉ inserʉ uya ipɨ'. “Ɨwɨpʉremato' etasa' Papa uya man. Ɨno'pʉ, Resipe' uya ɨmʉre epoto' oton, mɨrɨpan mese'tɨi' Isaan tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Pori' pe kuru ɨku'to' iya oton mɨrɨ. Mɨrɨ awonsi'kɨ tu'kan kon nɨ epori'mato' oton iyentusa' a'tai, ");
INSERT INTO akeNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","apʉne pʉra Papa enu yau eke pe kuru iye'to' oton. Ɨ'rɨ rɨ kata'pan ensinin pe kʉse'nin, Papa A'kwarʉ yen pe iye'to' oton iyentu'pʉ si'kɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Tu'kan kon nɨ Esuwerʉ amʉ' na'poto' iya oton Papa winɨkʉi', ");
INSERT INTO akeNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","mɨrɨpan utɨto' oton Itepuru rawɨrɨ meruntɨ pe, Iraisa esi'pʉ kasa, tʉmunkɨ kon i'nʉnkanin nan pe ikʉipʉnʉ ton e'to' pe to' ewan ensimato' iya oton, main awɨron kon pen nɨrɨ ipokena' pu'ketʉ yau te'ton kon pe. Ka'pon amʉ' konekanin pe itepuru e'ma ta',” ta'pʉ inserʉ uya. ");
INSERT INTO akeNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakaraya uya inserʉ ekama'po'pʉ, “Nai kasa i'tu uya i'napai rɨ serɨ esi tukai'? Intomi'si pe esi, uno'pʉ nɨrɨ esi no'sami'si pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Inserʉ uya eikʉ'pʉ, “Kepʉrerʉ urɨ, Papa piyawon urɨ, enno'sa' urɨ ayauro'kase'na, mɨrɨ awonsi'kɨ wakʉ itekare ekamase'na ɨpɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Umaimu apurɨ auya pʉra iyesi pɨ', ɨye'maimu'ka nin mɨrɨ, ausauro'to' oton pen unekama'pʉ e'kupʉ pʉ'kʉ pona rɨ,” ta'pʉ inserʉ uya. ");
INSERT INTO akeNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mɨrɨ koro'tau, ka'pon amʉ' enurikʉ'pʉ Sakaraya enupɨkɨrɨ, usenuminkan pɨ' to' esi'pʉ, “Ɨ'rɨ pɨ' inke kuru rɨ iko'mamʉ tepa'kai' pʉra?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mɨrɨpan epa'kasa' a'tai, isaurokʉ pʉra iyesi'pʉ. To' uya i'tu'pʉ Papa uya itenu a'kwakasa' uya ɨ'rɨ rɨ ensa' tukai', apʉne pʉra temiyatʉ ke tauro'ka iya 'nokon pɨ', asaurokʉi'ma pʉra. ");
INSERT INTO akeNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Te'tʉrawasomato' weyu u'ma'sa' a'tai, itunta'pʉ tiwʉ' ta'. ");
INSERT INTO akeNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Serɨ pata'pʉ pe, ino'pʉ Resipe' umono'ta'pʉ. Mɨrɨpan uko'mamʉ'pʉ tepa'kai' pʉra 5 kaisa rɨ kapʉi tiwʉ' tau. ");
INSERT INTO akeNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Papa uya kuru serɨ ku'sa' serɨ uiwano' pe,” ta'pʉ iya. “Serɨ a'tai kuru si piyɨ'nʉ' imʉre pʉra ka'pon amʉ' koro'tau e'to' mo'kasa' iya man upiyapai,” ta'pʉ Resipe' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","6 kaisa rɨ kapʉi Resipe' esi koro'tau mono' pe, inserʉ Kepʉrerʉ ennoko'pʉ Papa uya Kiyarari awon pata Nasare' itese' pona. ");
INSERT INTO akeNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","A'pɨ'pʉn uri'san, Meri itese', auro'kato' iya ike esi'pʉ, Isose', Tepi' pa rʉ'pʉ, no'pʉ oton pe te'ton. ");
INSERT INTO akeNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Inserʉ uyee'pʉ ipiya'. Mɨrɨpan a'tai, “Miyarɨ, Papa Nanʉmʉ'pʉ! Itepuru man ɨpiyau,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Inserʉ maimu pɨ', ipan pe kuru Meri usenuminka'pʉ, mɨrɨpan, “Ɨ'rɨ rɨ si ta iya ko?” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","“Kɨsi'nʉkʉi, Meri. Wakʉ pe Papa enu yau ɨwesi. ");
INSERT INTO akeNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ɨumono'tato' oton, mɨrɨpan entuto' oton warawo' pe, mɨrɨpan mese'tɨi' Sises tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Eke pe kuru iye'to' oton. Mɨrɨ awonsi'kɨ eke kuru Papa Mumu Kʉrɨ rɨ tukai', esa'to' oton. Itepuru Papa uya Kin pe iku'to' oton itamokori Tepi' esi'pʉ kasa, ");
INSERT INTO akeNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","mɨrɨ awonsi'kɨ Seko' payan nʉ'san epuru pe iye'to' oton inke rɨ. Kin pe iye'to' e'nonkato' oton pen,” ta'pʉ inserʉ uya. ");
INSERT INTO akeNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","“Ɨ'rɨ kasa si serɨ e'kupʉ, a'pɨ'pʉn urɨ?” ta'pʉ Meri uya inserʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","“Iye'kupʉ rɨ Papa A'kwarʉ rɨ uyepʉ ɨpona, mɨrɨ awonsi'kɨ Papa meruntɨrʉ ereuta ɨpiyau. Mɨrɨ pɨ' wakʉ mʉre esa'to' oton Papa Mumu, tukai',” ta'pʉ inserʉ uya. ");
INSERT INTO akeNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Ɨtonpa pe' Resipe' mi'tuyan tʉumu'tasen pen nɨ tato' ipɨ' e'tane, 6 kaisa rɨ kapʉi mono' pe iyesi mɨrɨ, no'sami'si pe kuru iye'tane, ");
INSERT INTO akeNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","apʉne pʉra tanporon nɨ ku'nin pe Papa esi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","“Itepuru apiyo' rɨ urɨ. Tɨwɨ si serɨ ne'kupʉi upɨ' mekamayai'ne' awɨrɨ,” ta'pʉ Meri uya. Mɨrɨ ta iya tʉpo, inserʉ uya inɨmɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mɨrɨ pata'pʉ pe, inke pʉra Meri ekoneka'pʉ tʉutɨto' pe i'kʉrʉ po te'sen pata Isutiya pon ya'. ");
INSERT INTO akeNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pata eposa' tʉuya a'tai, Sakaraya iwʉ' ta' iyewomʉ'pʉ. Mɨrɨpan uya, “Miyarɨ,” ta'pʉ Resipe' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Resipe' uya Meri maimu etasa' a'tai, imʉre utama'pʉ itewan yau. Resipe' nin si uta'kwarʉ'tɨ'pʉ, Papa A'kwarʉ ke, ");
INSERT INTO akeNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","mɨrɨpan usaurokʉ'pʉ eke pe, “Ɨmɨrɨ kuru rɨ si kʉrɨ rɨ wakʉ rɨ uri'san Papa uya wakʉ ku'sa' man ɨpɨ' tu'kan kon koro'tapai ayanʉnsa' iya, mɨrɨ awonsi'kɨ ɨmʉre nɨrɨ kanan iten pe me'ai'ne'. ");
INSERT INTO akeNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ɨ'rɨ wenai kuru rɨ uyepuru san uya uka'kʉranpasa' ko? ");
INSERT INTO akeNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Amaimu etasa' uya a'tai, uyau umʉre e'sanʉmʉ'pʉ tepori'ma ke. ");
INSERT INTO akeNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Wakʉ pe kuru ɨwesi mɨrɨ apurɨ auya pɨ' Papa Maimu ɨpiya' iye'sa' rʉ'pʉ uta'ku'tɨ a'tai,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mɨrɨ a'tai, Meri uya se kasa ta'pʉ: “Uyewan uya kuru Papa apurɨpɨtʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Uya'kwarʉ esi pori' pe kuru tʉpika'tɨnin Papa pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Sepan nɨ tapiyo' ku'sa' iya pɨ' tenu yau. Mɨrɨ pe iyesi pɨ', serɨ si'kɨrɨ, tanporon kon serɨ entakanon kon uya uyapurɨpɨ'to' oton Papa uya pori' pe uku'sa' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Apʉne pʉra eke rɨ, wakʉ eseru ku'sa' Papa uya pɨ', upɨ'; wakʉ rɨ itese'. ");
INSERT INTO akeNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tʉnamanin nan pɨ', tʉusentu'masen Kʉrɨ rɨ, to' epamʉ kaisarɨ rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Meruntɨ pe tesi ke, wakʉ ton, eke ton ku'sa' iya; mɨ pe te'ku'san aimʉrʉnpasa' iya to' eseru pokon pe. ");
INSERT INTO akeNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Eke ton pe te'san, itepuru ton nu'tɨsa' iya to' apon poi, sepan kon nʉ'kwɨ rɨ anʉmʉi'ma. ");
INSERT INTO akeNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Iwan pe te'san a're'tɨsa' iya wakʉ ke, imaminkena' ton ennokoi'ma itemiyatʉ arʉ pʉra. ");
INSERT INTO akeNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Epʉra'an, utamokori kon mɨrɨ tʉpo ipayan amʉ' auro'ka'pʉ tʉuya kasa, ɨsentu'kena' pe tesi wenai, tapiyo' Esuwerʉ pika'tɨsa' iya, mɨrɨ awonsi'kɨ imunkɨ amʉ' miyarɨ rɨ,” ta'pʉ Meri uya. ");
INSERT INTO akeNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mɨrɨpan uko'mamʉ'pʉ Resipe' piyau osorʉwau kapʉi, mɨrɨ awonsi'kɨ iyenna'po'pʉ tʉpata ya'. ");
INSERT INTO akeNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Resipe' entuto' weyu e'seposa' a'tai, iyentu'pʉ warawo' pe. ");
INSERT INTO akeNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Itonpa ton akontawon kon mɨrɨ awonsi'kɨ itonpa ton kuru uya etasa' esi'pʉ, eke pe kuru Papa usentu'masa' ipɨ' tawon. Mɨrɨpan kon esi'pʉ pori' pe ipokon pe. ");
INSERT INTO akeNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tikin nɨ suntaaka iyenasa' a'tai, itun pi'pɨ puturʉkato' e'seporo'pʉ. Mɨrɨpan ese'tɨ to' uya esi'pʉ Sakaraya tukai', ikʉipʉnʉ ese' yau. ");
INSERT INTO akeNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","E'tane isan uya, “Kane, Isaan itese' kʉrɨ rɨ,” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mɨrɨpan pɨ' ta'pʉ to' uya, “E'tane sa'ne mɨrɨ tukai' ɨnʉ' rɨ ɨtonpa ese' pʉra iyesi,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mɨrɨ a'tai, ikʉipʉnʉ auro'ka'pʉ to' uya temiyatʉ kon ke ɨnʉ' tukai' ese'tɨ iya tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Mɨrɨ a'tai, imenukato' tʉuya ipɨ' ekama'po'pʉ iya. Ka'pon amʉ' tewansiukai' nin si imenuka'pʉ iya mɨrɨ, “Itese' mɨrɨ Isaan,” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mɨrɨ a'tai rɨ, imaimu epa'ka'pʉ, mɨrɨpan nin si usaurokʉ'pʉ mɨrɨ Papa apurɨpɨtʉ'pʉ iya nin si. ");
INSERT INTO akeNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mɨrɨpan pɨ' rɨ itonpa ton akontawon kon usewansiuka'pʉ, mɨrɨ ton pɨ' usauro'nɨ pɨ' to' esi'pʉ siya rɨ Isutiya i'kʉrʉ poro'ne rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tanporon kon etanin nʉ'san usenuminka'pʉ serɨ pɨ', mɨrɨpan kon usekama'popɨtʉ'pʉ, “Ɨnʉ' pe rɨ si pʉse rɨ mʉre e'to' oton?” ta'pʉ to' uya, apʉne pʉra Papa meruntɨrʉ yau iyesi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ikʉipʉnʉ Sakaraya uta'kwarʉ'tɨ'pʉ Papa A'kwarʉ ke. Mɨrɨpan usaurokʉ'pʉ, Papa uya tauro'ka'pʉ ike pɨ': ");
INSERT INTO akeNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Papa apurɨpɨ'pai'nokon, Esuwerʉ amʉ' e'to' itese' pɨ', apʉne pʉra iye'sa' pɨ' tʉpoitorʉ ton mo'kase'na. ");
INSERT INTO akeNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Meruntɨ rɨ, pika'tɨnin wannɨ ke urepasa' iya 'nokon pɨ', tʉpoitorʉ pe te'sen, Tepi' pa rʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ta'pʉ tʉuya awɨrɨ rɨ pena pu'kena' amʉ' poro rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Pika'tɨnin wannɨ uyeyaton kon piyapai uyewaruma'tɨnin kon enapai. ");
INSERT INTO akeNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Utamokori kon pɨ' isentu'mato' pokon pe, wakʉ tʉusaurokʉ'pʉ kupʉ iya tenu yau. ");
INSERT INTO akeNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Utamokori kon Epʉra'an pɨ', ‘ikupʉ uya kuru,’ ta'pʉ tʉuya ku'sa' iya tenu yau. ");
INSERT INTO akeNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Papa uya ta'pʉ uyeyaton kon enapai umo'ka kon tʉuya pɨ', tʉmaimu awɨrɨ e'nɨto' pe tenari'nʉnse pʉra. ");
INSERT INTO akeNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Wakʉ pe, ipoken e'nɨto' pe itenu awɨrɨ uko'man nɨ kaisa rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Mɨrɨpan uya ta'pʉ tʉmu pɨ', “Ɨmɨrɨ, umʉre usesa'to' oton pu'kena' Papa iwano' tukai', apʉne pʉra ɨutɨto' oton uyepuru kon rawɨrɨ ite'ma ta' ka'pon amʉ' koneka pe, ");
INSERT INTO akeNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","imunkɨ amʉ' enupa pɨ' ɨwe'to' oton epika'tɨn nɨto' pɨ', to' pɨ' Papa usentu'ma winɨ, ");
INSERT INTO akeNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","apʉne pʉra Papa esi pɨ' ɨsentu'kena' pe upɨ'nokon wʉi enu enuku uya Epʉn poi, uwei'tɨ kon na'ne' kasa, Papa uya Kʉrai tʉnanʉmʉ'pʉ enno'to' oton upiya'nokon, ");
INSERT INTO akeNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","to' wei'tɨnin pe kamo ewarupɨ yau tʉuko'mansan uma'tan nɨto' pɨ' tenari'nʉnsan. Uyanin kon pe usewankaman nɨto' pen e'ma tawɨrɨ,” ta'pʉ Sakaraya uya tʉmu pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mɨrɨpan si'kɨrɨ rɨ, mʉre usemo'ka'pʉ pana' pe ta'kwarʉ ke. Mɨrɨpan uko'mamʉ'pʉ rɨmono' tau. Mɨrɨ tʉpo, iyepa'ka'pʉ Esuwerʉ amʉ' enupai' Papa eseru pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mɨrɨ a'tai itepuru Akosʉ'tas uya main ennoko'pʉ tanporon kon pata yawon kon ka'pon amʉ' uya tese' kon menukato', ti'tuto' kon pe. ");
INSERT INTO akeNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Wapiyaro' ka'pon amʉ' i'tuto' pe serɨ esi'pʉ mɨrɨ Kiriniyas esi Siriya esa' pe a'tai. ");
INSERT INTO akeNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tanporon kon si utɨ'pʉ mɨrɨ tese' kon menukai' tʉtɨpiya kon pata'pʉ ya'. ");
INSERT INTO akeNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Isose' nɨrɨ si utɨ'pʉ mɨrɨ Nasare', Kiyarari pon ponsi'kɨ, Isutiya pona Tepi' pata'se' Pe'teri'en itese' pona, apʉne pʉra Tepi' pa rʉ'pʉ pe tesi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Meri, tʉno'pʉ oton pokon pe rɨ to' utɨ'pʉ tese' kon menukai'. Mono' pe iyesi'pʉ (Papa A'kwarʉ mʉre yen pe). ");
INSERT INTO akeNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pe'teri'en po si to' esi koro'tau, iyentuto' weyu e'seporo'pʉ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Warawo' pe iyɨmʉrewato' entu'pʉ. Mɨrɨpan ontɨ'pʉ iya kareku saai'pɨ'sa' ke, mɨrɨ awonsi'kɨ inonka'pʉ iya paka amʉ' yu yen ya', ɨutɨ ton tau to' pata'se' pʉra iyesi ke. ");
INSERT INTO akeNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Karimeru amʉ' pa'simanin nan esi'pʉ ewarupɨ nau itʉi po tikʉn kon pa'sima pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mɨrɨ ya', Itepuru inserʉʉi uyee'pʉ to' piya', mɨrɨ awonsi'kɨ Papa winɨpaino a'kwa uya to' wei'tɨ'pʉ. Ipan pe rɨ to' usi'nʉkʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","E'tane inserʉ uya ta'pʉ to' pɨ', “Kɨsi'nʉ'tʉu! Wakʉ itekare ne'sa' uya serɨ ɨiwano' kon pe, tanporon kon nɨ ka'pon amʉ' pori'ma pɨ' te'ton. ");
INSERT INTO akeNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Serɨ ewarupɨɨi tau Tepi' pata'se' yau ɨpika'tɨnin kon entusa' man, Kʉrai, Itepuru. ");
INSERT INTO akeNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Se esi mɨrɨ ento' auya'nokon ipɨ' pe. Se kasa eporo auya'nokon mɨrɨ. Iwontɨsa' pe mʉre esi kareku saai'pɨ'sa' ke, mɨrɨ awonsi'kɨ paka amʉ' yu yen yau iyesi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","14","Mɨrɨ koro'tau, kʉrɨ rɨ inserʉ piyau tu'kan kon inserʉ amʉ' esi'pʉ userenkan pɨ', “Eke kuru Papa esi ka'tawon, mɨrɨ awonsi'kɨ non po nɨrɨ tʉusewankamai' pʉra ka'pon amʉ' e'to' pe ikupʉ iya, kamo wakʉ tato' tʉuya ton nɨ pɨ',” tukai' to' userenka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pʉsamoro si inserʉ amʉ' enna'po'pʉ Epʉn pona a'tai, kamoro karimeru pa'simanin nan usaurokʉ'pʉ, “Pe'teri'en pona utɨnpai'nokon man, serɨ Itepuru nekama'pʉ upɨ'nokon ense'na,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tʉusenutɨi' to' utɨ'pʉ. Mɨrɨ a'tai Meri mɨrɨ awonsi'kɨ Isose' eporo'pʉ to' uya, mɨrɨ awonsi'kɨ mʉre esi'pʉ paka amʉ' yu yen yau. ");
INSERT INTO akeNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ene tʉpo, inserʉ nekama'pʉ ekama'pʉ to' uya tu'kan kon ka'pon amʉ' pɨ' pʉse rɨ mʉre pɨ' isaurokʉ'pʉ rʉ'pʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tanporon kon etanin nʉ'san usewansiuka'pʉ karimeru pa'simanin nan nekama'pʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Meri uya tanporo serɨ pu'tɨka'nʉkʉ pʉra iyesi'pʉ, mɨrɨ awonsi'kɨ isenuminka'pʉ ipan pe ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Karimeru pa'simanin nan enna'po'pʉ tʉuserenka kon pe eke pe Papa esi pɨ'. Tanporo tʉneta'pʉ kon pɨ', mɨrɨ awonsi'kɨ tʉnene'pʉ kon pɨ' nɨrɨ, inserʉ uya ekama'pʉ kasa. ");
INSERT INTO akeNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tikin nɨ suntaaka pata'pʉ pe, mʉre yun pi'pɨ puturʉkato' e'seposa' a'tai, to' uya ese'tɨ'pʉ Sises tukai', inserʉ nekama'pʉ ke isan umono'ta rawɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Isose' mɨrɨ awonsi'kɨ Meri uya Main, Mosi' winon awɨrɨ ekorʉkan eseru entun nɨ tʉpo tʉku'sen kupʉ'pʉ. Mɨrɨ tʉpo, tʉmʉre kon arɨ'pʉ to' uya Surusiran pona itʉse'na Itepuru ena'. ");
INSERT INTO akeNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Iye'menukasa' na'ne' kasa Itepuru winon Maimu awɨrɨ, “Tanporon kon wapiya iyentusa' warawo' pe te'san tʉto' pe Papa ena',” tawon. ");
INSERT INTO akeNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ɨse'mai' to' utɨ'pʉ: “asa'rɨ toron amʉ', wako'wa waraino kon ke,” Itepuru winon Main uya tasa' awɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mɨrɨ yau si, ka'pon esi'pʉ mɨrɨ tɨ Surusiran po Simiyan itese'. Ipokena' pe te'sen mɨrɨ awonsi'kɨ iye'tʉsa' pe itekare ya' te'sen, tenuri'sen Esuwerʉ amʉ' epika'tɨ enupɨkɨrɨ, Wakʉ A'kwarʉ esi'pʉ ipiyau. ");
INSERT INTO akeNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Wakʉ A'kwarʉ uya tasa' esi'pʉ ipɨ', “Ɨyerikʉ pen unekama'pʉ Kʉrai entu rawɨrɨ,” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Iya'kwarʉ uya Simiyan arɨ'pʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' ta'. Isanon uya asa' a'tai pʉse rɨ si mʉre Sises, Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' ta' si Main, Mosi' winon awɨrɨ, ");
INSERT INTO akeNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyan uya anʉmʉ'pʉ tena', mɨrɨpan uya Papa apurɨpɨtʉ'pʉ se tukai': ");
INSERT INTO akeNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Papa, ausaurokʉ'pʉ ku'sa' auya si man, tɨwɨ si urɨ, ɨpoitorʉ eri'to' pe iku'kɨ ewankamanin pʉra. ");
INSERT INTO akeNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ensa' uya si man pʉse ina pika'tɨnin pe ɨnennoko'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Enno'sa' auya si, tu'kan kon nenton pe. ");
INSERT INTO akeNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Esuwerʉ amʉ' pen weyu pe te'ton to' ena' ɨyeseru enpoikanin pe, Esuwerʉ amʉ' apurɨto' ipɨkɨrɨ pe kanan,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Mʉre sanon nin si usewansiuka'pʉ mɨrɨ Simiyan usaurokʉ pɨ', ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiyan uya to' pʉrema'pʉ, mɨrɨpan uya ta'pʉ Meri, isan pɨ', “Pʉse rɨ mʉre esi Papa Nanʉmʉ'pʉ, tʉron kon ma'tanʉ'nin pe, tʉron kon nɨrɨ pika'tɨnin pe, tu'kan kon nɨ Esuwerʉ amʉ' pata awon kon. Tensen pe iyesi Papa winɨpaino tu'kan kon nɨ newa'nomanʉ ton tʉmaimu kon ke. ");
INSERT INTO akeNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Mɨrɨpan tu'kan kon nɨ usenuminkato' usenpoikato' oton. Mɨrɨpan pɨrɨu kasa kuru pokoi uya ɨyewan pokato' oton,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Moro kanan si uri'san pu'kena' esi'pʉ mɨrɨ, Ana itese', Panuwerʉ ensi, Aisarʉ ko' tonpa. No'sami'si pe iyesi'pʉ. 7 kaisa rɨ rɨken wʉipiya iko'mansa' rʉ'pʉ temari'mai'. ");
INSERT INTO akeNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Mɨrɨpan nin si uko'mansa' 84 kaisa rɨ wʉipiya tʉtaan'pʉ uma'ta'pʉ pata'pʉ yau. Tʉutɨsen pen nɨ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' tapai, wʉi kaisa rɨ tʉwɨpʉremasen Papa pɨ', useruman pɨ' tenta'nai' pʉra te'sen. ");
INSERT INTO akeNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mɨrɨ a'tai kuru si iyee'pʉ mɨrɨ to' poi rɨ, mɨrɨpan uya tenki ta'pʉ Papa pɨ', mɨrɨpan usaurokʉ'pʉ pʉse rɨ mʉre pɨ' tu'kan kon pana ya' tenuri'san Papa uya Surusiran pon kon pika'tɨ ton ennoko i'se te'san. ");
INSERT INTO akeNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Isose' mɨrɨ awonsi'kɨ Meri uya tanporon nɨ Itepuru winon Main enuka'nʉ'sa' a'tai, to' enna'po'pʉ tʉpata'se' kon ya' Nasare' pona, Kiyarari yau te'sen. ");
INSERT INTO akeNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mɨrɨpan mʉre usemo'ka'pʉ pana' pe mɨrɨ awonsi'kɨ emiya'pokena' pe, Papa uya wakʉ nonkasa' esi'pʉ ipona. ");
INSERT INTO akeNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Wʉipiya kaisa rɨ Sises sanon utɨpɨtʉ'pʉ Surusiran pona To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","12 kaisa rɨ wʉipiya Sises enasa' a'tai, to' utɨ'pʉ iweyu rʉ'pʉ pɨ', tʉutɨpɨ'to' kon kasa rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mɨrɨ pata'pʉ pe, tʉsanon enna'po koro'tau, iye'nɨmɨ'pʉ Surusiran po to' wanmʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tʉtonpa ton pokon pe na'kɨ iyesi tukai' to' utɨ'pʉ tikin nɨ wʉi rɨ. Mɨrɨ a'tai, iwarinpa pɨ' to' e'sara'tɨ'pʉ tʉtonpa kon amʉ' koro'tau. ");
INSERT INTO akeNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Eporo tʉuya'nokon kasa pʉra, to' enna'po'pʉ Surusiran pona iwarinpase'na. ");
INSERT INTO akeNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Osorʉwau wʉi pata'pʉ pe, to' uya eporo'pʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' pʉ'kʉ tau. Iyereutasa' esi'pʉ Main pɨ' enupanin nan koro'tau to' eta pɨ' mɨrɨ awonsi'kɨ to' nɨrɨ ekama'popɨtʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tanporo eta pɨ' te'san usewansiuka'pʉ tanporon nɨ i'tu iya pɨ' mɨrɨ awonsi'kɨ ei'pɨtʉ iya pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Isanon uya ensa' a'tai, to' kanan usewansiuka'pʉ. Mɨrɨpan isanon uya ta'pʉ ipɨ', “Mooi, ɨ'rɨto' pe serɨ kasa ina ku'sa' auya? Ipan pe ina ewankamasa' auya serɨ, mɨrɨpan pɨ' ina uya awarinpa,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","“Ɨ'rɨto' pe uwarinpa auya'nokon? Ukʉipʉnʉ iwʉ' tau pe' esi tukai' i'tu auya'nokon pʉra iyesi'pʉ?” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","E'tane mɨrɨ ta iya to'ka'nʉkʉ to' uya pʉra rɨ iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Mɨrɨpan enna'po'pʉ to' a'kɨrɨ Nasare' pona mɨrɨ yau si to' maimu awɨrɨ iyesi'pʉ. Isan usenuminkapɨtʉ'pʉ serɨ ton pɨ' tewan yau. ");
INSERT INTO akeNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Sises usemo'ka'pʉ emiya'pokena' pe. Papa mɨrɨ awonsi'kɨ ka'pon amʉ' enu yau kuru rɨ iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","15 kaisa rɨ wʉipiya pata'pʉ pe Taipiriyas ena'pʉ pata Ron epuru pe, Ponsiyas Paire' esi'pʉ Isutiya kopʉnaai pe, Era' esi'pʉ Kiyarari esa' pe, itakon Piri' esi'pʉ Itureya mɨrɨ awonsi'kɨ Tʉra'konai'tes esa' pe, mɨrɨ awonsi'kɨ Raiseniyas esi'pʉ Apirini esa' pe. ");
INSERT INTO akeNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Mɨrɨ a'tai, Anas mɨrɨ awonsi'kɨ Kaya'pas esi'pʉ use'man nɨto' tʉrawasomanin nan epuru pe. Mɨrɨ a'tai, Main uyee'pʉ Papa winon, Sakaraya mumu, Isaan itese' piya', rɨmono' tau iyesi koro'tau. ");
INSERT INTO akeNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Itɨ'pʉ Isotan tuna piyawɨron pata ya'ne, makoi apai era'tɨn pe epa'taisiman nɨto' makoi pɨ' usentu'man nɨto' pe ekareei ekama pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Iye'menukasa' na'ne' kasa pu'kena' Aisaya maimu karetaai yau, “Rɨmono' tau ukɨ'pɨ'nʉnpɨ' nɨ, ‘Itepuru e'ma ikonekatɨ'; to'sa rɨ ite'ma ikonekatɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Yaranta amʉ' ipe'tɨpɨ'tɨ', wʉ' amʉ', i'kʉrʉ amʉ' inu'tɨpɨ'tɨ'. Oipa' nan asanta ton ikonepɨ'tɨ' to'sa rɨ. Tarantaranpa' nan asanta ton ikonepɨ'tɨ' ekayu pe'ne. ");
INSERT INTO akeNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tanporon kon uya, Papa uya tʉpika'tɨsa' kon, ento' oton mɨrɨ,’” tawon. ");
INSERT INTO akeNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Isaan uya ta'pʉ anpisin ton ka'pon amʉ' pɨ' tʉpa'taisimato' kon pe iya tʉpiya' tʉuye'san pɨ', “Ɨmɨrɨ'nokon ɨsɨ ton ɨkʉi munkɨ ton! Ɨnʉ' uya apana'tɨsa' kon ayainʉmʉ kon pa nʉye'ai'ne' kota'man nɨto' piyapai? ");
INSERT INTO akeNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Epetatɨ' ɨyera'tɨsa' kon amakooi kon apai ekamanin ke. Ɨmɨrɨ'nokon pe rɨ, ‘Epʉra'an esi ina kʉipʉnʉ pe,’ ta pɨ' kepiya'tɨtʉu. Apʉne pʉra apana'tɨ uya 'nokon serɨ, serɨ ton tɨ' apai Papa uya Epʉra'an munkɨ oton kon koneka mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Wa'ka man yʉi amʉ' mi' airɨ, mɨrɨ awonsi'kɨ tanporon yʉi amʉ' tepetasen pen a'tɨto' oton nɨ mɨrɨ, mɨrɨpan eno'ma apo' ya',” ta'pʉ Isaan uya. ");
INSERT INTO akeNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","“Ɨ'rɨ ken si kupʉ ina uya, Papa uya tʉkota'ma kon namai'?” tukai' anpisin ka'pon amʉ' uya ekama'po'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Isaan uya to' eikʉ'pʉ, “Ɨnʉ' rɨ kʉrɨ asa'rɨ na'ne' ipon uya, isakon tʉto' pe iyesi ipon pʉn ena', kʉrɨ kanan ti'kiyari ke na'ne' uya mɨrɨ rɨ marɨ ku'to' pe iyesi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Pʉrata amʉranʉ'nin nan nɨ kanan utɨ'pʉ Isaan uya tʉpa'taisimato' kon pe. To' uya ekama'po'pʉ, “Ti'sa, ɨ'rɨ ken si kupʉ ina uya?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","“Mɨrɨ airɨ imo'katɨ' tasa' na'ne' awɨrɨ rɨ, mʉmo'katʉi' itentai pen,” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mɨrɨ awonsi'kɨ soisa amʉ' uya ekama'po'pʉ, “Ɨ'rɨ kanan ken si kupʉ ina uya?” ta'pʉ to' uya. To' eikʉ'pʉ iya, “Ka'pon amʉ' kʉsa'kwarʉkatʉu to' pʉrataai pɨ', mɨrɨ awonsi'kɨ kasi pe rɨ to' kʉseseru'tɨtʉu. Mɨrɨ rɨ ɨpʉrataai kon mepoyatʉi'ne' pɨ' rɨ pori' pe e'tɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Isaan uya i'tu'pʉ ka'pon amʉ' enurikʉ Kʉrai enupɨkɨrɨ serɨ pe rɨ iyepʉ tukai'. Ka'pon amʉ' usenuminka'pʉ, “Isaan pe' esi Kʉrai pe?” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Isaan uya tanporo to' eikʉ'pʉ, “Apa'taisima uya 'nokon serɨ tuna ke, e'tane ka'pon meruntɨ kuru uye'to' oton, isapatooi euka uya pokena' pen nɨ. Apa'taisima iya 'nokon mɨrɨ Wakʉ A'kwarʉ ke mɨrɨ awonsi'kɨ apo' ke. ");
INSERT INTO akeNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Sara'sara'pan ti'kiyari pi'pɨ menkato' iya ike esi itemiyatʉ yau i'kwato' tʉuya apon akorokato' pe tʉuya mɨrɨ awonsi'kɨ ta'nasi, wi' amʉranʉkʉ iya tiwʉ' ta', e'tane ipi'pɨ rʉ'pʉ po'tɨ iya tʉusenkʉ'sen pen apo' ke,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Tu'kan winɨ rɨ Isaan usi'tu'pʉ, wakʉ ekareei ekama pɨ' to' uya apurɨto' pe. ");
INSERT INTO akeNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","E'tane Isaan uya kopʉna Era' esereme'sa' a'tai, iyakon no'pʉ Eratiyas wenai mɨrɨ awonsi'kɨ tanporon nɨ ɨri ton inkuu'pʉ pɨ', ");
INSERT INTO akeNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","tanporo serɨ ton pirikʉ'pʉ Era' uya: pariki'si ta' Isaan a'kopɨtʉ'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Tanporo ka'pon amʉ' epa'taisimaka'sa' a'tai, Sises rɨ nɨrɨ epa'taisima'pʉ. Iyɨpʉrema koro'tau, ka' uta'koka'pʉ ");
INSERT INTO akeNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Wakʉ A'kwarʉ u'tɨ'pʉ tʉpun ke ipona wako'wa kasa. Main uyee'pʉ Epʉn awonsi'kɨ, “Umu ɨmɨrɨ, uni'nʉnkanʉ; ɨpɨ' pori' pe e'ai' ipan pe,” tawon. ");
INSERT INTO akeNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Sises e'sara'tɨ'pʉ Papa uya tʉtʉrawasooi'tɨ'pʉ kupʉ pɨ', 30 e'to' airɨ rɨ iwʉipiyaai esii'ma. Isose' mumu tato' ipɨ'. Isose' esi'pʉ Irai mu pe. ");
INSERT INTO akeNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Irai esi'pʉ Ma'ta' mu pe. Ma'ta' esi'pʉ Ripai mu pe. Ripai esi'pʉ Merʉkai mu pe. Merʉkai esi'pʉ Isana mu pe. Isana esi'pʉ Isose' mu pe. ");
INSERT INTO akeNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Isose' esi'pʉ Ma'ta'tayas mu pe. Ma'ta'tayas esi'pʉ Emos mu pe. Emos esi'pʉ Ne'an mu pe. Ne'an esi'pʉ E'sʉrai mu pe. E'sʉrai esi'pʉ Nakei mu pe. ");
INSERT INTO akeNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakei esi'pʉ Meya' mu pe. Meya' esi'pʉ Ma'ta'tayas mu pe. Ma'ta'tayas esi'pʉ Semeyai mu pe. Semeyai esi'pʉ Isose' mu pe. Isose' esi'pʉ Isuta mu pe. ");
INSERT INTO akeNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Isuta esi'pʉ Isowanan mu pe. Isowanan esi'pʉ Iri'sa mu pe. Iri'sa esi'pʉ Userupaperʉ mu pe. Userupaperʉ esi'pʉ Siya'tiyerʉ mu pe. Siya'tiyerʉ esi'pʉ Nirai mu pe. ");
INSERT INTO akeNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nirai esi'pʉ Merʉkai mu pe. Merʉkai esi'pʉ Atai mu pe. Atai esi'pʉ Kosan mu pe. Kosan esi'pʉ Erʉmatan mu pe. Erʉmatan esi'pʉ Ɨrʉ mu pe. ");
INSERT INTO akeNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ɨrʉ esi'pʉ Isa'suwa mu pe. Isa'suwa esi'pʉ Eriyesa mu pe. Eriyesa esi'pʉ Isorin mu pe. Isorin esi'pʉ Ma'ta' mu pe. Ma'ta' esi'pʉ Ripai mu pe. ");
INSERT INTO akeNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ripai esi'pʉ Simiyan mu pe. Simiyan esi'pʉ Isuta mu pe. Isuta esi'pʉ Isose' mu pe. Isose' esi'pʉ Isonan mu pe. Isonan esi'pʉ Eraiya'kin mu pe. ");
INSERT INTO akeNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eraiya'kin esi'pʉ Mireya mu pe. Mireya esi'pʉ Mina mu pe. Mina esi'pʉ Ma'ta'ta mu pe. Ma'ta'ta esi'pʉ Ne'tan mu pe. Ne'tan esi'pʉ Tepi' mu pe. ");
INSERT INTO akeNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tepi' esi'pʉ Ise'si mu pe. Ise'si esi'pʉ Ope' mu pe. Ope' esi'pʉ Powas mu pe. Powas esi'pʉ Sarʉman mu pe. Sarʉman esi'pʉ Neyasan mu pe. ");
INSERT INTO akeNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Neyasan esi'pʉ Aminatapu mu pe. Aminatapu esi'pʉ A'min mu pe. A'min esi'pʉ Arʉni mu pe. Arʉni esi'pʉ Esuran mu pe. Esuran esi'pʉ Peres mu pe. Peres esi'pʉ Isuta mu pe. ");
INSERT INTO akeNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Isuta esi'pʉ Seko' mu pe. Seko' esi'pʉ Aisi' mu pe. Aisi' esi'pʉ Epʉra'an mu pe. Epʉra'an esi'pʉ Tera mu pe. Tera esi'pʉ Ne'orʉ mu pe. ");
INSERT INTO akeNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ne'orʉ esi'pʉ Seru' mu pe. Seru' esi'pʉ Reeu mu pe. Reeu esi'pʉ Perekʉ mu pe. Perekʉ esi'pʉ Ipɨrʉ mu pe. Ipɨrʉ esi'pʉ Sera mu pe. ");
INSERT INTO akeNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sera esi'pʉ Kenan mu pe. Kenan esi'pʉ Arʉpa'satʉ mu pe. Arʉpa'satʉ esi'pʉ Isen mu pe. Isen esi'pʉ Nowa mu pe. Nowa esi'pʉ Rame' mu pe. ");
INSERT INTO akeNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Rame' esi'pʉ Me'tusera mu pe. Me'tusera esi'pʉ Iino' mu pe. Iino' esi'pʉ Isaretʉ mu pe. Isaretʉ esi'pʉ Mararerʉ mu pe. Mararerʉ esi'pʉ Kenan mu pe. ");
INSERT INTO akeNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan esi'pʉ Inos mu pe. Inos esi'pʉ Se' mu pe. Se' esi'pʉ Atan mu pe. Atan esi'pʉ Papa mu pe. ");
INSERT INTO akeNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Wakʉ A'kwarʉ ke tʉutarʉ'tɨi', Sises enna'po'pʉ Isotan apai, mɨrɨpan arɨ'pʉ Iya'kwarʉ uya rɨmono' ta'. ");
INSERT INTO akeNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","40 kaisa rɨ wʉi Makoi uya i'tupɨ'to' yau pe iyesi'pʉ na'ne'. Iyenta'na'pʉ pen mɨrɨ ton wʉi a'tai, mɨrɨpan iu'matʉ a'tai, iwan pe iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Makoi uya ta'pʉ Sises pɨ', “Papa Mumu pe ɨwesi yau, se tɨ' pɨ' pʉreti pe enakɨ ka'kɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Sises uya eikʉ'pʉ, “Iye'menukasa': ‘Ka'pon esi tʉuko'mansen pʉreti pɨ' rɨken pen,’ tawon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Makoi uya arɨ'pʉ ka'tawon wʉ' pona. Mɨrɨpan uya inke pʉra tanporo eke ton pata enpoika'pʉ itenu ya'. ");
INSERT INTO akeNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Mɨrɨpan uya ta'pʉ ipɨ', “Ɨrepa uya mɨrɨ tanporo to' meruntɨrʉ mɨrɨ awonsi'kɨ wakʉ pe to' e'to' ke, apʉne pʉra urepa'pʉ ike pe iyesi pɨ'; mɨrɨ pe iyesi pɨ', ɨnrepapai e'to' rɨ repa uya ike. ");
INSERT INTO akeNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mɨrɨ pɨ' si, upɨ' ɨwɨpʉremasa' yau, tanporon nɨ esi ɨiwano' pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Sises uya eikʉ'pʉ, “Iye'menukasa': ‘Itepuru, Papa, itese' pɨ' ɨwe'to' pɨ' rɨken ɨpʉrema', mɨrɨ awonsi'kɨ kʉrɨ rɨ rɨken poitorʉ pe e'kɨ,’ tawon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Makoi uya arɨ'pʉ Surusiran pona mɨrɨpan uya Papa ena' Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' ka'tawon inakapu putu po iye'mʉ'sa'kato' pe ikupʉ'pʉ. “Papa Mumu pe ɨwesi yau, ata'mo'kakɨ serɨ awonsi'kɨ,” ta'pʉ iya ipɨ', ");
INSERT INTO akeNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","“apʉne pʉra iye'menukasa': “‘Tinserʉʉi apiyo'ma iya ɨpɨ' wakʉ pe to' e'to' pe ɨyerasu pe. ");
INSERT INTO akeNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Temiyatʉ kon yau to' uya ayanʉmʉ, tɨ' pona a'ta wɨnɨ auya namai',’ tukai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Sises uya eikʉ'pʉ, “Tasa' iya: ‘Itepuru, Papa, itese' pɨ' ɨwe'to' kʉsi'tupɨtʉi,’ tawon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tanporo si i'tupɨtʉ u'ma'sa' a'tai, Makoi uya inɨmɨ'pʉ tʉron nɨ a'taino pe. ");
INSERT INTO akeNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Sises enna'po'pʉ Kiyarari pona Iya'kwarʉ meruntɨrʉ yau, mɨrɨpan ekareei utɨ'pʉ mɨ awɨrɨ rɨ tanporo pata poro. ");
INSERT INTO akeNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","To' enupa'pʉ iya Esuwerʉ amʉ' usenupato' iwʉ' ton tau. Tanporon kon uya apurɨpɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Itɨ'pʉ Nasare' pata pona, tʉusemo'ka'pʉ ya'. Mɨrɨpan utɨ'pʉ Esuwerʉ amʉ' usenupato' iwʉ' ta', te'pɨ'to' kasa rɨ Sapa' a'tai. Mɨrɨpan e'mʉ'sa'ka'pʉ Papa Maimu ekamai'. ");
INSERT INTO akeNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Pu'kena' Aisaya nʉmenuka'pʉ kareta amon tʉrʉ'pʉ itena'. Ara'ka'pʉ iya se tawon e'menukasa' airɨ: ");
INSERT INTO akeNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Papa A'kwarʉ man uyau. Papa uya uyanʉnsa' wakʉ ekareei ekamato' pe uya entu'manin nan ka'pon amʉ' pɨ'. Uyenno'sa' iya serɨ ekamase'na a'sisa' kon ponaro' pe. Mɨrɨ awonsi'kɨ tenku'na' nan e'to' pe ennin pe. Mɨrɨ tʉpo, kamoro ɨri pe to' nʉkupʉnʉ ton pika'tɨnin pe. ");
INSERT INTO akeNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Uyenno'sa' iya ka'pon amʉ' pika'tɨto' tʉuya weyu ekamase'na,” tawon. ");
INSERT INTO akeNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Te'nonkasa' a'tai, tʉkaretaai e'mepɨtʉ'pʉ iya. Mɨrɨpan na'po'pʉ iya itʉrawasomanin ena'. Mɨrɨ tʉpo iyereuta'pʉ to' enupase'na. Tanporon kon esi'pʉ enpɨtʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Sises uya ta'pʉ to' pɨ', “Serɨ pe metatʉune' uta'ku'tɨsa' si man,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tanporo etanin nʉ'san usaurokʉ'pʉ wakʉ pe ipɨ'. Mɨrɨpan to' usewansiuka'pʉ wakʉ imaimu pɨ'. “Isose' mu pen pe' pʉse rɨ?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Sises uya ta'pʉ to' pɨ', “Serɨ pu'kena' ton maimu enpoika auya'nokon upɨ' tukai' si'tui, ‘Ta'ta, ɨiwano' pe ɨsepi'tɨ'.’ Mɨrɨ a'tai si, ta auya'nokon upɨ', ‘Apʉne ken si, ina neta'pʉ Ka'paneyan po ɨnkuu'pʉ, iku'kɨ serɨ apata yau,’ ta auya'nokon, si'tui.” ");
INSERT INTO akeNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Sises uya ta'pʉ, “I'napairon ekama uya ɨpɨ'nokon, ipata'se' yau, pu'kena' nama pʉra iyesi. ");
INSERT INTO akeNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Pu'kena' Iraisa esi a'tai, tu'kan kon itaan'pʉ ima'tasa' rʉ'san esi'pʉ Esuwerʉ po. Mɨrɨ a'tai si, ipʉra non aipʉta'pʉ osorʉwau wʉipiya entai rɨ. Iwankan pe pata tʉku'se iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Papa uya Iraisa ennoko pʉra iyesi'pʉ Esuwerʉ amʉ' piya', e'tane ennoko'pʉ iya Sera'pa' pon itaan'pʉ ima'tasa' rʉ'pʉ piya', Saitan nono pona. ");
INSERT INTO akeNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Pu'kena' Irai'sa esi a'tai, Esuwerʉ po tu'ke rɨ erekʉ'pa' nan esi'pʉ. E'tane rɨ, tikin nan nɨ epi'tɨsa' iya pʉra iyesi. Neman nɨken epi'tɨ'pʉ iya, Siriya pon, Esuwerʉ pon pen,” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","To' uya imaimu etasa' a'tai, tanporo Esuwerʉ amʉ' usenupato' iwʉ' tau te'san usakorota'pʉ ipan pe. ");
INSERT INTO akeNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","To' e'mʉ'sa'ka'pʉ, mɨrɨpan enpa'ka'pʉ to' uya pata apai. To' uya arɨ'pʉ wʉ' e'pi pona, Nasare' apon pona eno'mase'na soronpan yawɨrɨ, ");
INSERT INTO akeNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","e'tane iyera'tɨ'pʉ to' piyapai, mɨrɨpan utɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Mɨrɨ a'tai iu'tɨ'pʉ Ka'paneyan pona, Kiyarari yau te'sen pata pona. Mɨrɨpan Sapa' a'tai ka'pon amʉ' enupa pɨ' iyepiya'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","To' usewansiuka'pʉ enupan nɨto' iya pɨ', apʉne pʉra meruntɨ pe inekamanʉ esi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Moro warawo' esi'pʉ Esuwerʉ amʉ' usenupato' iwʉ' tau, makoi a'kwarʉ yen. Eke pe ikɨ'pɨ'nʉmʉ'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ɨɨɨɨ! Sises, Nasare' pon, ɨ'rɨ pe ina ku'se'na ɨuye'sa'? Ina ma'tanʉ'se'na pe' ɨuye'sa'? Kɨnyi'tuyai' ɨmɨrɨ kʉrɨ rɨ—Wakʉ Ye' Papa iwano'!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","“E'pana e'kɨ! Epa'kakɨ iyapai!” ta'pʉ Sises uya e'se'ne' pe ipɨ'. Mɨrɨ a'tai, makoi a'kwarʉ uya warawo' eno'ma'pʉ tu'kan kon koro'tau. Iyepa'ka'pʉ iyapai e'ne' pe pʉra rɨ tʉku'se. ");
INSERT INTO akeNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tanporo ka'pon amʉ' usewansiuka'pʉ, mɨrɨpan kon usekama'popɨtʉ'pʉ, “Ɨ'rɨ si serɨ usenupan nɨto'? Pana'pan, meruntɨ ke makoi a'kwarʉ apiyo'ma iya, mɨrɨpan kon epa'ka!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mɨrɨpan ekareei utɨ'pʉ siya rɨ mɨrɨ awɨro'nan awɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Sises utɨ'pʉ Esuwerʉ amʉ' usenupato' iwʉ' apai Saiman pata'se' ya'. Saiman ewo'pʉ esi'pʉ ipan pe e'kɨɨi'man pɨ'. Mɨrɨpan Sises ekama'po'pʉ to' uya epi'tɨto' pe iya. ");
INSERT INTO akeNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Mɨrɨ a'tai, Sises e'mʉ'sa'ka'pʉ ite'kwe' piyau. Mɨrɨpan uya pana' pe ikɨɨi'manin pɨ', “Ereuta'!” ta'pʉ. Mɨrɨ a'tai rɨ, iyereuta'pʉ. Inke pʉra rɨ iye'mʉ'sa'ka'pʉ to' mʉta'napai'. ");
INSERT INTO akeNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pata uko'mansa' a'tai, ka'pon amʉ' uya takuru'kena' nan nee'pʉ Sises piya'. Mɨrɨpan uya temiyatʉ ke to' a'pɨ'pɨtʉ'pʉ to' kaisa rɨ'ne, to' epi'tɨ'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mɨrɨ enta' rɨ, makoi a'kwarʉ ton epa'kapɨtʉ'pʉ ka'pon amʉ' apai. Makoi a'kwarʉ yen ton ukɨ'pɨ'nʉnpɨtʉ'pʉ, “Papa Mumu Ɨmɨrɨ!” ta'pʉ to' uya. E'se'ne' pe to' eseremekʉ'pʉ iya, to' usaurokʉ namai'. To' e'paka'nʉkʉ'pʉ iya, apʉne pʉra Kʉrai pe ti'tu to' uya wenai. ");
INSERT INTO akeNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pata ema'tane, Sises utɨ'pʉ tʉ'kenan pata ya'. Ka'pon amʉ' esi'pʉ iwarinpa pɨ'. Mɨrɨpan eposa' tʉuya'nokon a'tai, ereutanʉkʉ i'se to' esi'pʉ, itɨ namai'. ");
INSERT INTO akeNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","E'tane, “Wakʉ Papa e'to' esa' wannɨ ekareei ekamato' uya esi tʉron nɨ ton pata yau'ne rɨ marɨ, apʉne pʉra mɨrɨto' pe uyenno'sa' pe iyesi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Mɨrɨpan esi'pʉ Esuwerʉ amʉ' usenupato' iwʉ' ton Isutiya pon tau'ne itekare ekama pɨ' iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tʉron nɨ a'tai, Sises e'mʉ'sa'kasa' esi'pʉ parau ku'pɨri Isenesere' e'pi po. Ka'pon amʉ' amʉrasa' esi'pʉ a'ko pe iwoi, Papa Maimu ekama iya etase'na. ");
INSERT INTO akeNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Parau ku'pɨri e'pi po, asa'rɨ kanau ene'pʉ iya, moro' a'sinin nan kanwa'pʉ. Moro' a'sinin nʉ'san uya tʉpunwerʉ kon korʉkapɨtʉ esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sises ekanwa'tɨ'pʉ Saiman kanwa ya'. Mɨrɨpan uya ta'pʉ Saiman pɨ', “Akanwa a'tu'makɨ parau ku'pɨri e'pi apai,” ta'pʉ iya. Mɨrɨ apai, a'mun po te'san enupa'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Sises e'nonkasa' a'tai ka'pon amʉ' enupa tʉpo, ta'pʉ iya Saiman pɨ', “Miyarɨ parɨ kanau akɨ i'nawon ya' parɨ. Mɨrɨpan ɨpunwerʉ kon eno'ma kon pa tuna ka' moro' amʉ' a'si kon pa,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Mɨrɨpan e'tane, Saiman uya ta'pʉ Sises pɨ', “Uyepuru, ewarupɨ nau ina rɨ nʉsi'tui to' a'si i'se ipan pe, e'tane ina uya to' a'si pʉn nɨ. E'tane pʉra, tʉpunwerʉ kon tʉrʉ ina uya, amaimu awɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","To' uya si itʉrʉ'pʉ, mɨrɨpan kon uya tu'ke rɨ moro' amʉ' a'si'pʉ to' punwerʉ ekaraka poken nɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mɨrɨpan kon uya tʉtonpa kon amʉ' tʉron nɨ kanau yawon kon kɨ'ma'pʉ tʉpika'tɨnin kon pe. Mɨrɨpan kon uyee'pʉ, to' uya si asa'rɨ rɨ marɨ tʉkanwa kon pe'tɨ'pʉ. Mɨrɨpan kon kanwa e'sʉnkaiwa'pʉ rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saiman Pi'ta uya se e'kupʉ to'ka'nʉ'sa' a'tai, iye'sekunka'pʉ Sises enupɨkɨrɨ. “Enta upiyapai. Ɨpiyau esi poken pʉra man, apʉne pʉra tʉmakooi ke esi pɨ',” ta'pʉ Saiman uya ipɨ', ");
INSERT INTO akeNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","apʉne pʉra tʉtonpa ton amʉ' pokon pe tʉusewansiukasa' kon pɨ' tʉna'si'san kon moro' amʉ' tense. ");
INSERT INTO akeNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sepiti munkɨ amʉ', Isens, mɨrɨ awonsi'kɨ Isaan, usewansiuka'pʉ nɨrɨ, Saiman tonpa pe te'san. Sises uya ta'pʉ Saiman pɨ', “Kenari'nʉmʉi, serɨ si'kɨrɨpai ka'pon amʉ' nin si a'sinin pe ɨwesi mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Mɨrɨpan kon uya tʉkanwa kon amʉ' pi'si'pɨtʉ'pʉ parau ku'pɨri e'pi pona. Tanporon nɨ tʉnɨnse to' utɨ'pʉ ipɨkɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Pata ton tonpa yau, Sises esi koro'tau, erekʉ'pan ka'pon uyee'pʉ ipiya'. Sises ensa' tʉuya a'tai, ita'mo'ka'pʉ non pona itemʉ' eta'kwanʉnse ipɨ', “Uyepuru, ɨnku'pai ɨwesi yau, wakʉ pe ukupʉ auya,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Sises uya temiyatʉ ɨnka'pʉ, mɨrɨpan uya a'pɨtʉ'pʉ, “Ɨnku'pai rɨ e'ai'. Wakʉ pe e'kɨ,” ta'pʉ iya. Inke pʉra rɨ, iterekʉ usepi'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Sises uya ta'pʉ, “Ɨnʉ' rɨ kʉ'pana'tɨi, e'tane enta ɨsenpoikata Papa ena' use'man nɨto' tʉrawasomanin ena' mɨrɨ awonsi'kɨ ɨuse'mato' pe te'sen, Mosi' uya tasa' na'ne' awɨrɨ mʉtʉrʉi', ɨyekorʉkasa' pɨ', ekamanin pe to' pɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mɨrɨpan e'tane, itekareei useta'pʉ. Mɨrɨ wenai, tu'kan kon ka'pon amʉ' uyee'pʉ etase'na mɨrɨ awonsi'kɨ ɨsepi'tɨpɨ'se'na teparan kon apai. ");
INSERT INTO akeNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","E'tane Sises utɨpɨtʉ'pʉ ɨpʉremase'na tʉ'kenan ya'. ");
INSERT INTO akeNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tʉron nɨ a'tai, ka'pon amʉ' enupa pɨ' iyesi'pʉ. Pari'si amʉ' mɨrɨ awonsi'kɨ Main pɨ' enupanin nan iye'pɨ'sa' kon tanporon nɨ eke iwa pata ton Kiyarari po'nan apai, Isutiya, Surusiran winɨ'ne rɨ ereutasa' esi'pʉ. Papa uya imeruntɨrʉ ke irepasa' esi'pʉ e'ne' ton epi'tɨnin pe. ");
INSERT INTO akeNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ka'pon amʉ' uyee'pʉ, ite'kwe' po ipu'tɨka'sa' ka'pon nee'pʉ to' uya. To' usi'tu'pʉ inepʉ i'se Sises piya', epi'tɨto' pe iya. ");
INSERT INTO akeNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Apʉne pʉra anpisin pe ka'pon amʉ' esi pɨ' ikupʉ tʉuya'nokon pʉra iyesi i'tusa' tʉuya'nokon a'tai, to' ekainʉmʉ'pʉ ɨutɨ nakapu pona. Mɨrɨpan kon uya inɨpon mo'ka'pʉ, mɨrɨ awonsi'kɨ to' uya inu'tɨ'pʉ iteuta yai, anpisin ton aporo'pona, Sises poi rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Sises uya tʉtonpa kon epi'tɨ tʉuya tukai' apurɨto' to' uya ensa' a'tai, “Utonpa, amakooi pɨ' usentu'mayai',” ta'pʉ iya ipu'tɨka'sa' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pari'si amʉ', Main pɨ' enupanin nan nɨrɨ, usenuminka'pʉ tiwano' kon pe, “Ɨnʉ' pʉse rɨ ka'pon Papa sapema pe rɨ tʉusauro'sen? Papa rɨken Kʉrɨ rɨ makoi pɨ' tʉusentu'masen!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Sises uya to' usenuminkato' i'tu'pʉ. Mɨrɨpan uya, “Ɨ'rɨ pe iyesi pɨ' se ton pɨ' ɨusenuminka kon? Serɨ kasa ɨusenuminka kon poken pʉra man. ");
INSERT INTO akeNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nai esi sa'man pe pʉra iwa: ‘Amakooi pɨ' usentu'ma,’ ta; mɨrɨ pe pʉra, ‘E'mʉ'sa'ka', asakɨ,’ ta katɨ ipu'tɨka'sa' pɨ'? ");
INSERT INTO akeNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ka'pon, Papa winon uya enpoikato' pe iyesi ipiyau meruntɨ esi serɨ non po makoi ton pɨ' tʉusentu'masen pe,” ta'pʉ iya, Pari'si amʉ' mɨrɨ awonsi'kɨ Main pɨ' enupanin nan pɨ' nɨrɨ. Mɨrɨ tʉpo, ta'pʉ iya ipu'tɨka'sa' pɨ', “E'mʉ'sa'ka', ɨye'kwe' anʉnkɨ, enna'po' apata'se' ya',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mɨrɨ a'tai rɨ, iye'mʉ'sa'ka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tanporon kon ka'pon amʉ' usewansiuka'pʉ. Mɨrɨpan kon uya Papa apurɨpɨtʉ'pʉ. To' enari'nʉmʉ'pʉ, mɨrɨ awonsi'kɨ, “Serɨ pe, eke Papa tʉrawasooi e'kupʉ ensa' man,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mɨrɨ tʉpo, Sises utɨ'pʉ, mɨrɨpan uya pʉrata amʉranʉ'nin kopʉna iwano' pe ene'pʉ, Ripai itese'. Iyereutasa' esi'pʉ pʉrata amʉranʉ'to' iwʉ' tau. “Uya'kɨrɨ utɨnpai,” ta'pʉ Sises uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ripai e'mʉ'sa'ka'pʉ, tanporon nɨ nɨmɨ'pʉ iya, iya'kɨrɨ itɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mɨrɨ tʉpo, Ripai uya eke enta'nan kupʉ'pʉ Sises iwano' pe tiwʉ' tau. Anpisin pe pʉrata amʉranʉ'nin nan, tʉron kon nɨ nɨrɨ esi'pʉ enta'nan pɨ' to' pokon pe. ");
INSERT INTO akeNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","E'tane Pari'si amʉ' mɨrɨ awonsi'kɨ Main pɨ' enupanin nan uya ta'pʉ Sises poitorʉ ton pɨ', “Ɨ'rɨ pe iyesi pɨ' ɨyenta'na kon pʉrata amʉranʉ'nin nan kopʉna iwano' pe pokon pe mɨrɨ awonsi'kɨ tʉmakooikena' nan pokon pe?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Sises uya to' eikʉ'pʉ, “Atu' pe te'san esi ta'ta i'se pʉra. Takuru'kena' nan nɨken esi tepi'tɨnin kon i'se. ");
INSERT INTO akeNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ipokena' ton kɨ'mai' uye'sa' pen, e'tane tʉmakooikena' nan era'tɨto' pe tʉmakooi kon apai,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ta'pʉ to' uya ipɨ', “Isaan poitorʉ ton useruma tenta'nai' pʉra, to' ɨpʉrema nɨrɨ ɨsipɨkɨrɨ, mɨrɨ kasa rɨ Pari'si amʉ' poitorʉ ton. E'tane, ɨpoitorʉ ton enta'na,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Sises uya to' eikʉ'pʉ, “Ka'pon emari'ma piyau te'san, useruma pʉra iyesi tenta'nai' pʉra, to' piyau iyesi koro'tau. ");
INSERT INTO akeNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","E'tane iweyu uye'to' oton temari'masen kasa te'sen anʉnto' oton ipoitorʉ ton piyapai; mɨrɨ a'tai to' userumato' oton tenta'nai' pʉra,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tʉron nɨ panton ekama'pʉ iya to' enupa pe, penaro' pokon pe emenna' pe to' enupato' tʉuya utoi'ma namai', “Ɨnʉ' uya rɨ emenna' pe te'sen pon apai takʉ'se pon pooi'pɨ a'si'tɨ pʉra iyesi. Ikupʉ iya pe iyesi yau, emenna' pon a'si'sa' usene ɨri pe ipooi'pɨ pɨ', mɨrɨ awonsi'kɨ emenna' pon ma'tanʉ'sa' iya pe iyesi. ");
INSERT INTO akeNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ɨnʉ' uya rɨ emenna' waain amuku pʉra iyesi penaro' itenpʉ'pʉ ya'. Ikupʉ iya yau, ten i'moi iya. Iye'kwamʉ, iten nɨ si uma'ta. ");
INSERT INTO akeNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Emenna' waain amu'to' pe iyesi emenna' iten ya'. ");
INSERT INTO akeNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ɨnʉ' uya rɨ penaro' ensi tʉpo emenna' waain ensi pʉra iyesi, ‘Penaro' esi wakʉ pe kuru upona,’ ta iya,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tʉron nɨ Sapa' a'tai, Sises utɨ'pʉ a'nai' e'kwa nawɨrɨ. Ipoitorʉ ton e'sara'tɨ'pʉ iye'suruupɨ'sa' i'kwɨ'pɨtʉ pɨ'. To' uya isoko'soko'ma'pʉ temiya kon yau, mɨrɨpan kon uya ɨku'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Serɨ ensa' tʉuya'nokon a'tai, Pari'si amʉ' uya Sises ekama'po'pʉ, “Ɨ'rɨ pe iyesi pɨ' Main uya tʉku'sen pen nɨ Sapa' a'tai tasa' rʉ'pʉ kupʉ auya'nokon Sapa' a'tai?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Sises uya to' eikʉ'pʉ, “Kin Tepi' nʉkupʉ'pʉ pe' etasa' auya'nokon pʉra nai? Tʉpoitorʉ ton pokon pe iwan pe tesi kon a'tai, ");
INSERT INTO akeNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' ta' iyewomʉ'pʉ, ipʉremasa' pʉreti tʉyu oton tepose iyenta'na'pʉ, Main uya Papa ena' use'man nɨto' tʉrawasomanin nan yu pe rɨken te'sen tasa' ɨku'pʉ iya, e'tane rɨ mɨrɨ uya imakoima'pʉ pen. Tʉtonpa ton nɨrɨ repa'pʉ iya,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Mɨrɨ a'tai, Sises uya ta'pʉ to' pɨ', “Ka'pon, Papa winon esi Sapa' Epuru pe rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tʉron nɨ kanan Sapa' a'tai, itɨ'pʉ Esuwerʉ amʉ' usenupato' iwʉ' ta' to' enupase'na. Mɨrɨ yau, ka'pon esi'pʉ enwo'ne' itemiyatʉ yaipʉtasa' amʉrasa'. ");
INSERT INTO akeNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Pari'si amʉ' mɨrɨ awonsi'kɨ Main pɨ' enupanin nan esi'pʉ Sises enpɨtʉ pɨ' eseru'tɨto' pe tʉuya'nokon. A'ko pe enpɨtʉ pɨ' to' esi'pʉ Sapa' a'tai ka'pon epi'tɨ iya ene i'se. ");
INSERT INTO akeNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","E'tane Sises uya to' usenuminkato' i'tu'pʉ, mɨrɨpan uya ta'pʉ itemiyatʉ yaipʉtasa' amʉrasa' pɨ', “E'mʉ'sa'ka' tanporon kon rau,” ta'pʉ. Mɨrɨpan e'mʉ'sa'kasa' e'soto'ka'pʉ to' rau. ");
INSERT INTO akeNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mɨrɨpan a'tai Sises uya ta'pʉ to' pɨ', “Ɨyekama'po uya 'nokon. Nai esi Main awɨrɨ Sapa' a'tai tʉku'sen pe: Wakʉ kupʉ mɨrɨ pe pʉra ɨri kupʉ katɨ? Ka'pon pika'tɨ, ima'tanʉkʉ katɨ?” ");
INSERT INTO akeNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tanporo to' ene'pʉ iya, mɨrɨpan uya ta'pʉ warawo' pɨ', “Ɨyemiyatʉ ɨnka'!” Ikupʉ'pʉ iya, mɨrɨpan emiyatʉ enna'po'pʉ tesi'pʉ ya'. ");
INSERT INTO akeNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","E'tane, ipan pe Pari'si amʉ' mɨrɨ awonsi'kɨ Main pɨ' enupanin nan usakorota'pʉ. “Ɨ'rɨ pe iku'pai nai?” tukai' to' usaurokʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mɨrɨ a'tai'ne, Sises utɨ'pʉ wʉ' poi rɨ ɨpʉremai', ewarupɨ nau ɨpʉreman pɨ' iyesi'pʉ Papa pɨ' pata tema'kwai'. ");
INSERT INTO akeNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pata ema'sa' a'tai, tʉpoitorʉ ton kɨ'ma'pʉ iya. 12 kaisa rɨ to' anʉmʉ'pʉ iya, itekare ekamai' enno'sa' kon pe to' koneka'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","To' ese' esi'pʉ: Saiman (Pi'ta tukai' inese'tɨ'pʉ), iyakon Anturu, Isens, Isaan, Piri', Pa'taramiu, ");
INSERT INTO akeNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Ma'siu, Tamas, Isens (Arʉ'piyas mumu), Saiman (Usera' tukai' tesa'sen), ");
INSERT INTO akeNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Isutas (Isens mu), mɨrɨ awonsi'kɨ Isutas Eskariya', eparankanin pe iyena'pʉ na'ne'. ");
INSERT INTO akeNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","To' a'kɨrɨ iu'tɨ'pʉ, mɨrɨpan e'soto'ka'pʉ rɨmon po. Tu'ke rɨ anpisin pe ipoitorʉ ton esi'pʉ mɨrɨ yau mɨrɨ awonsi'kɨ tu'ke rɨ ka'pon amʉ' Isutiya, mɨrɨ awonsi'kɨ Surusiran winon kon uye'sa' esi'pʉ. Tʉron kon ka'pon amʉ' uyee'pʉ parau e'pi Taya, Saitan winon kon. ");
INSERT INTO akeNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","To' uyee'pʉ etase'na, ɨsepi'tɨse'na teparan kon apai'ne. Makoi a'kwarʉ yen pe te'san usepi'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tanporon kon ka'pon amʉ' usi'tu'pʉ a'pɨtʉ i'se, apʉne pʉra meruntɨ epa'ka pɨ' piyapai, mɨrɨpan uya tanporo to' epi'tɨpɨtʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tʉpoitorʉ ton enei'ma ta'pʉ iya, “Pori' pe ɨwesi kon, ɨmɨrɨ'nokon entu'ma' na'ne' nan, apʉne pʉra Papa e'to' esa' wannɨ pe esi pɨ' ɨiwano' kon pe. ");
INSERT INTO akeNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Pori' pe ɨwesi kon, ɨmɨrɨ'nokon serɨ pe iwan pe na'ne' nan, apʉne pʉra aya'wetato' oton kon. Pori' pe ɨwesi kon, ɨmɨrɨ'nokon serɨ pe nʉkaranyai'ne' nan, apʉne pʉra auta'kɨrɨto' oton kon. ");
INSERT INTO akeNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Pori' pe ɨwesi kon, ɨmɨrɨ'nokon ka'pon amʉ' newaruma'tɨnʉ ton, tʉpokon pe ɨwesi kon i'se pʉra to' esi a'tai, asapema kon a'tai, ɨyese' kon eno'ma a'tai ɨri tukai', Ka'pon, Papa winon uriya'. ");
INSERT INTO akeNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ipan pe mepori'matʉi', pori' pe ɨwesi kon pɨ' me'sanʉnpɨ'tʉi' mɨrɨ wʉi a'tai, apʉne pʉra eke rɨ ɨyepe'pʉ kon esi pɨ' Epʉn po. Apʉne pʉra mɨrɨ kasa rɨ to' kʉipʉnʉ ton uya pu'kena' ton ku'pɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“E'tane ɨsɨ yau me'atʉi' ɨmɨrɨ'nokon ipʉrataaikena' ton, apʉne pʉra wakʉ epoka'sa' auya'nokon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ɨsɨ yau me'atʉi', ɨmɨrɨ'nokon tʉuta're'tɨsan, apʉne pʉra iwan pe ɨwe'to' oton kon. Ɨsɨ yau me'atʉi', ɨmɨrɨ'nokon tʉuta'kɨrɨsan, apʉne pʉra tʉuta'kwarʉkai' aukaranto' oton kon. ");
INSERT INTO akeNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Ɨsɨ yau me'atʉi', ɨmɨrɨ'nokon wakʉ pe ka'pon amʉ' usaurokʉ a'tai ɨpɨ'nokon, mɨrɨ na'ne' kasa to' tɨpiya ton uya ennakanin nan pu'kena' amʉ' ku'pɨtʉ'pʉ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“E'tane ekama uya ɨpɨ'nokon uyetayatʉi'ne' nan: ɨyeyaton kon i'nʉnkatɨ', ɨyewaruma'tɨnin kon pɨ' wakʉ iku'tɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kamo apa'nʉ'nin nan kon pona ɨpʉrematɨ', ɨri pe ɨku'nin nan kon pona ɨpʉrematɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ɨnʉ' uya rɨ ɨwɨnɨ yau ɨye'peta pɨ', iratoi rʉ'pʉ rɨ marɨ ira'tɨkɨ iwinɨkʉi'. Ɨnʉ' uya rɨ ɨpon kon pʉro'pon anʉmʉ pe iyesi yau, kʉsereutanʉ'tʉu iyo'non ɨpon anʉntane iya. ");
INSERT INTO akeNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tanporon kon ɨyekama'poyai'ne'nokon irepatɨ', ɨnʉ' uya rɨ ɨiwano' kon anʉmʉ yau, inna'pokɨ kʉkatʉu. ");
INSERT INTO akeNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Iku'tɨ' tʉron kon pɨ', ikupʉ to' uya i'se me'atʉi'ne' kasa ɨpɨ'nokon. ");
INSERT INTO akeNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ɨi'nʉnkanin kon nɨken i'nʉnka auya'nokon yau, ɨ'rɨ wakʉ eporo auya'nokon? Tʉmakooikena' nan uya rɨ ti'nʉnkanin kon i'nʉnka. ");
INSERT INTO akeNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mɨrɨ awonsi'kɨ wakʉ kupʉ auya'nokon yau wakʉ pe ɨku'nin kon pɨ', ɨ'rɨ wakʉ eporo auya'nokon? Tʉmakooikena' nan uya rɨ mɨrɨ rɨ kupʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Itʉrʉ auya'nokon pe iyesi yau, kamoro inna'ponin nan pe te'san ena', ɨ'rɨ wakʉ eporo auya'nokon? Tʉmakooikena' nan uya itʉrʉ tʉmakooikena' nan ena' inna'po to' uya mɨ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","E'tane, ɨyeyaton kon i'nʉnkatɨ', wakʉ iku'tɨ' to' pɨ'. To' irepatɨ', to' uya inna'po enupɨkɨrɨ ɨwesi kon pa pʉra. Mɨrɨ a'tai, ɨyepe'pʉ kon e'to' oton eke pe, mɨrɨ awonsi'kɨ Eke Kuru munkɨ pe ɨwe'to' oton kon, apʉne pʉra mannʉ' pe iyesi tenki tawon nan pen pɨ' mɨrɨ awonsi'kɨ ɨri ton pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tʉusentu'masan pe e'tɨ', ɨkʉipʉnʉ kon esi tʉusentu'masen pe kasa. ");
INSERT INTO akeNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ɨnʉ' rɨ ka'pon eseru kʉsaimenkatʉu, mɨrɨ a'tai ɨyeseru kon nɨ nɨrɨ aimenka pen. Ka'pon kʉseno'matʉu, mɨrɨ a'tai ɨmɨrɨ'nokon nɨ nɨrɨ eno'ma pen. Ɨsentu'matɨ', mɨrɨ a'tai ɨmɨrɨ'nokon pɨ' rɨ usentu'man. ");
INSERT INTO akeNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Itʉkɨ, mɨrɨ awonsi'kɨ ɨyena' iye'tʉto' pe. Wakʉ i'tuto' yai, eremuru'sa', itʉntʉnmasa', mɨrɨpan anʉ'sa' e'tʉrʉ'kwa, tʉrʉ mɨrɨ ɨye'mata pona. Apʉne pʉra i'tuto' auya yai, yai ɨyenakan i'tu mɨrɨ,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Sises uya panton ekama'pʉ to' pɨ', “Tenku'nan uya pe' tenku'nan kanan arɨ? Asa'rɨ rɨ marɨ pe' akasa' ya' to' uta'mo'ka pen? ");
INSERT INTO akeNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tʉusenupasen esi pʉra iyesi mɨrɨ tʉti'saai entai. E'tane tanporon kon ipan pe isenupasa' kon e'to' oton tʉti'saai kon kasa rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ɨ'rɨ pe iyesi pɨ' aiko rʉ'kwɨ rɨ paranka punu'pɨ ɨnenpai ɨwesi ɨtonpa enu yawon, eke rɨ paranka e'tane ɨyenu yau? ");
INSERT INTO akeNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nai kasa ɨtonpa pɨ', ‘Utonpa, apʉne amuru simo'kai' ɨyenu apai,’ ta auya, ɨyenu awon nɨ paranka ene auya pen nɨ e'tane? Ɨmɨrɨ'nokon wakʉ pe te'ku'san, wapiya ɨyenu apai paranka imo'kaka'kɨ, mɨrɨ a'tai wakʉ pe ene auya ɨtonpa enu apai amuru mo'ka pa,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","To' enupa pɨ' rɨ Sises esi'pʉ, ta'pʉ iya, “Wakʉ yʉi epeta pʉra iyesi mɨrɨ ɨri pe, mɨrɨ pe pʉra ɨri yʉi epeta pʉra iyesi mɨrɨ wakʉ pe. ");
INSERT INTO akeNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ikaisa rɨ iteperu pɨkɨrɨ yʉi usi'tu mɨrɨ. Ka'pon amʉ' uya pi' pʉipɨtʉ pʉra rɨ iyesi mɨrɨ tikʉ kenan e'kwa apai, mɨrɨ pe pʉra kʉre' ɨmɨ'nɨ ton ye' apai. ");
INSERT INTO akeNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Wakʉ ka'pon uya wakʉ usentɨsa' tewan yawon enpa'ka mɨrɨ, mɨrɨ awonsi'kɨ ɨri ka'pon uya ɨri usentɨsa' tewan yawon enpa'ka mɨrɨ. Apʉne pʉra itewan yau te'sen epe'tɨsa' ke inta usaurokʉ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ɨ'rɨ pɨ', ‘Uyepuru, uyepuru,’ tukai' uyesa'pɨtʉ auya'nokon, ukayai'ne' kupʉi'ma pʉra rɨ? ");
INSERT INTO akeNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ɨnʉ' kasa iyesi tukai' enpoika uya kʉrɨ upiya' nʉye'ai'ne' mɨrɨ awonsi'kɨ umaimu etayai'ne' mɨrɨpan kupʉ pɨ' na'ne'. ");
INSERT INTO akeNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ka'pon uya ɨutɨ amɨ kasa iyesi, i'na' akanin nʉ'pʉ mɨrɨpan uya iyapon nonkasa' tɨ' pona. I'mʉnpʉ uye'sa' a'tai, itapʉ'netʉ uya mɨrɨ ɨutɨ wɨnɨ'pʉ e'tane iwokouka iya poken pʉra iyesi'pʉ, apʉne pʉra wakʉ pe amɨsa' pe iyesi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","E'tane kʉrɨ umaimu eta pɨ' na'ne' mɨrɨpan kupʉ iya pʉra na'ne' esi ɨutɨ amɨnin ka'pon non po iyapon pʉra kasa. I'mʉnpʉ apʉ'netʉ uya mɨrɨ ɨutɨ wɨnɨ'pʉ, mɨrɨpan uta'mo'ka'pʉ, ipʉra rɨ tʉuma'tai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ka'pon amʉ' uya eta tane tanporo serɨ ta nonkasa' tʉuya a'tai, Sises epa'ka'pʉ Ka'paneyan pona. ");
INSERT INTO akeNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mɨrɨ yau, soisa amʉ' epuru poitorʉ esi'pʉ, ipan pe ini'nʉnkanʉ takuru'ke kuru, eri'ka'nɨ pɨ' rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Soisa amʉ' epuru uya Sises ekareei eta'pʉ, mɨrɨpan uya Esuwerʉ amʉ' epuru ton ennoko'pʉ ikɨ'mai' tʉpoitorʉ epi'tɨi' iye'to' pe. ");
INSERT INTO akeNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Sises piya' tʉuye'sa' kon a'tai, tʉuta'kwarʉpɨ'se kuru, “Tʉpika'tɨsen ye' pe kuru pʉse rɨ ka'pon esi. Ipika'tɨkɨ kuru, ");
INSERT INTO akeNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","apʉne pʉra ina i'nʉnka iya, ina Esuwerʉ amʉ' usenupato' iwʉ' konekasa' iya nɨrɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Mɨrɨpan kon a'kɨrɨ Sises utɨ'pʉ. Ɨnnɨ pʉra rɨ ɨutɨ piyapai iye'tane, soisa amʉ' epuru uya tʉtonpa ton ennoko'pʉ ipana'tɨse'na, “Uyepuru, katanpokʉmai, apʉne pʉra uiwʉ' ta' ɨuyepʉ pokena' pen nɨ urɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Mɨrɨ pe iyesi pɨ', ɨpiya' kuru rɨ utɨ ta uya pʉn, e'tane amaimu itʉkɨ, mɨrɨ a'tai upoitorʉ usepi'tɨto' pe. ");
INSERT INTO akeNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Apʉne pʉra urɨ rɨ kʉrɨ rɨ tepuru kenan, soisa amʉ' esa' uwo'noro te'san. Pʉse pɨ', ‘Enta,’ ta uya a'tai, itɨ; kʉrɨ pɨ', ‘Ɨsi'kɨ,’ ta a'tai, iyepʉ rɨ; upoitorʉ pɨ', ‘Se iku'kɨ,’ ta uya a'tai, ikupʉ iya,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Sises uya serɨ etasa' a'tai, isewansiuka'pʉ ipɨ' era'tɨi'ma anpisin ka'pon amʉ' tʉpɨkɨrɨ te'san winɨkʉi' ta'pʉ, “Ta uya serɨ ɨpɨ'nokon, ɨnʉ' rɨ eposa' uya pʉra rɨ man Esuwerʉ amʉ' koro'tau eke rɨ serɨ waraino apurɨto',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Enno'sa' kon nin si, warawo' amʉ' enna'po'pʉ ɨutɨ ta' takuru'kenan usepi'tɨsa' tepose. ");
INSERT INTO akeNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Inke pʉra rɨ mɨrɨ pata'pʉ pe, Sises utɨ'pʉ Nen itese' pata pona. Ipoitorʉ ton mɨrɨ awonsi'kɨ anpisin ton ka'pon amʉ' utɨ'pʉ iya'kɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pata mʉra'ta eporo iya koro'tau, eke' u'na'tɨi' tʉutɨsan epa'ka eporo'pʉ iya. Tikin nan nɨ itaan'pʉ ima'tasa' rʉ'pʉ mʉre warawo' uma'tasa' esi'pʉ. Anpisin ka'pon amʉ' utɨ esi'pʉ iya'kɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Sises uya ensa' a'tai, isentu'ma'pʉ ipɨ', mɨrɨpan uya, “Kakaramʉi,” ta'pʉ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Mɨrɨpan utɨ'pʉ iten a'pɨ'se'na, mɨrɨpan anin nan e'takʉ'ka'pʉ. Mɨrɨpan pɨ', “Moineri'pɨ, e'mʉ'sa'ka'!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mɨrɨ a'tai eke' e'mʉ'sa'ka'pʉ, mɨrɨpan usaurokʉ'pʉ. Mɨrɨpan tʉrʉ'pʉ iya isan ena'. ");
INSERT INTO akeNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mɨrɨpan kon enari'nʉmʉ'pʉ ipan pe, mɨrɨpan kon uya si Papa apurɨpɨtʉ'pʉ. “Eke pu'kena' uye'sa' man u'koro'ta'nokon! Papa uye'sa' man tʉmunkɨ ton pika'tɨse'na!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Sises ekareei ekama'pʉ ka'pon amʉ' uya mɨ awɨrɨ rɨ Isutiya poro, mɨrɨ awonsi'kɨ iwoino' nan pata awɨrɨ'ne. ");
INSERT INTO akeNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Isaan poitorʉ ton uya si tanporo serɨ ton ekama'pʉ mɨrɨ ipɨ'. Isaan uya asa'ron kon tʉpoitorʉ ton kɨ'ma'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","mɨrɨpan kon ennoko'pʉ iya Itepuru piya' ekama'pose'na, “Ɨmɨrɨ rɨ pe' kʉrɨ rɨ tʉuye'ton ta'pʉ rʉ'pʉ ipɨ', tʉron nɨ rɨ katɨ uyepʉ enupɨkɨrɨ ina e'to' nai?” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Sises piya' tʉuye'sa' kon a'tai, “Isaan Pa'tes uya ina enno'sa' ɨpiya' ɨyekama'pose'na, ‘Ɨmɨrɨ rɨ pe' kʉrɨ rɨ tʉuye'ton ta'pʉ rʉ'pʉ ipɨ', tʉron nɨ rɨ katɨ uyepʉ enupɨkɨrɨ ina e'to' nai?’” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mɨrɨ koro'tau, Sises uya ka'pon amʉ' epi'tɨpɨtʉ'pʉ, paran pokon kon, mɨrɨ awonsi'kɨ amariwakʉ'pa' nan nɨ. Tu'kan kon nɨ tenku'na' nan kupʉ'pʉ iya ennin pe. ");
INSERT INTO akeNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Mɨrɨ kasa main anin nʉ'san eikʉ'pʉ iya, “Enna'potɨ' Isaan pɨ' ekamatantɨ' ɨnene'pʉ kon, ɨneta'pʉ kon: tenku'na' nan enasa' ennin nan pe; ise'mesa' kon enasa' tʉusasan pe; wereei'pa' nan usepi'tɨsa'; etanin nan pen enasa' etanin nan pe; eke' e'mʉ'sa'kasa'; wakʉ itekare usekamasa' man entu'manin nan pana ya'. ");
INSERT INTO akeNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Pori' pe ka'pon esi mɨrɨ tʉuta'mo'kasen pen unkupʉnʉ uriya',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Isaan maimu anin nʉ'san enna'po'pʉ pata'pʉ yau, Sises e'sara'tɨ'pʉ anpisin auro'ka pɨ' Isaan pɨ', “Ɨ'rɨ ense'na ɨutɨ'pʉ kon rɨmono' ta'? Wana' rɨ ari'ma a'setun uya ense'na? ");
INSERT INTO akeNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mɨrɨ pe pʉra iyesi yau, ɨ'rɨ ken ense'na ɨutɨ'pʉ kon? Wakʉ pe katɨ ka'pon epontɨpɨ'sa' ense'na? Kane. Kamoro epe'kena' ton pon yau te'san esi use'wanpan pɨ' te'sen pata esanon iwʉ' tawon kon. ");
INSERT INTO akeNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","E'tane ɨ'rɨ kuru ken ense'na ɨutɨ'pʉ kon? Pu'kena' katɨ? Ewai' apana'tɨ uya 'nokon, pu'kena' entaino rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Pʉse rɨ sa'ne si kʉrɨ rɨ ko iye'menukasa' itekare usauro'sa' rʉ'pʉ ipɨ', “‘Umaimu ekamanin ennoko uya mɨrɨ arawɨrɨ, ɨye'ma konekanin pe awapiya,’ ta'pʉ rʉ'pʉ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Apana'tɨ uya 'nokon, kamo uri'sami'si amʉ' nentunʉkʉ'san koro'tau, ɨnʉ' rɨ iyentusa' rʉ'pʉ pʉra rɨ iyesi mɨrɨ eke Isaan entaino, mɨrɨ e'tane kʉrɨ aiko pe te'sen Papa e'to' esa' wannɨ pe yawon esi eke pe Isaan entai,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tanporon kon ka'pon amʉ' pʉrata amʉranʉ'nin nan nɨ uya Sises maimu etasa' tʉuya'nokon a'tai, i'tu'pʉ Papa eseru esi i'napairon pe, apʉne pʉra Isaan nʉpa'taisima'san pe tesi kon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","E'tane si, Pari'si amʉ' mɨrɨ awonsi'kɨ Main pɨ' enupanin nan uya Papa nʉkupʉ'pʉ tiwano' kon pe ewaruma'tɨ'pʉ, apʉne pʉra to' esi'pʉ Isaan uya tʉpa'taisima kon i'se pʉra. ");
INSERT INTO akeNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Ɨnʉ' yan kasa ken ka'pon amʉ' serɨ a'taino kon ekama uya? Ɨnʉ' yan kasa to' esi? ");
INSERT INTO akeNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mʉre amʉ' ereutapɨ'sa' kʉrʉpo'po pata'se' yau na'ne' tʉukɨ'pɨ'nʉnpɨ'san tʉtonpa kon amʉ' pɨ' kasa: “‘Sarakuwa turunpa'pʉ ina uya ɨiwano' kon pe e'tane, aumanʉnsa' kon pʉra iyesi; eke' eremu pɨ' ina userenka'pʉ e'tane, aukaransa' kon pʉra iyesi,’ tawon nan kasa rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Apʉne pʉra Isaan Pa'tes uyee'pʉ pʉreti ɨku iya pʉra mɨrɨ pe pʉra waain ensi iya pʉra, mɨrɨpan pɨ', ‘Makoi esi iyau,’ ta'pʉ auya'nokon. ");
INSERT INTO akeNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ka'pon, Papa winon, uyee'pʉ tenta'nasen mɨrɨ awonsi'kɨ ensinin, mɨrɨpan pɨ', ‘Pʉse eke pe tenta'nasen mɨrɨ awonsi'kɨ te'taripasen, pʉrata amʉranʉ'nin nan, tʉmakooikena' nan nɨrɨ tonpa pe iyesi,’ ta'pʉ auya'nokon. ");
INSERT INTO akeNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","E'tane Papa pu'ketʉ usi'tu mɨrɨ i'napai rɨ, tanporo imunkɨ amʉ' winɨ,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pari'si amʉ' tonpa uya Sises kɨ'ma'pʉ tʉpiya' entai'kwase'na. Mɨrɨpan utɨ'pʉ itiwʉ' ta' tʉteire' po iyena'pʉ tepʉrʉ piyau. ");
INSERT INTO akeNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mɨrɨ pata yau rɨ, tʉuko'mansen uri'san, ɨri pe iteseru iko'mansa', uya Sises enta'na Pari'si iwʉ' tau etasa' a'tai, po'toro arapasta po'piyun yen nee'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mɨrɨpan e'soto'ka'pʉ Sises a'poi winɨ akaramʉi'ma. Mɨrɨpan e'torupa'tɨ'pʉ, Sises pʉta amanka'pʉ iya tenu paru ke, mɨrɨ awonsi'kɨ a'munaka'pʉ iya tʉnse' ke, i'ta a'su'ka'pʉ iya, mɨrɨpan pona po'piyun ma'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mɨrɨ ensa' tʉuya a'tai, Pari'si ikɨ'manin nʉ'pʉ uya ti'nau, “Pu'kena' pe pʉse rɨ ka'pon esi yau, ta'pɨ'nin uri'san eseru i'tui'no! Ɨri pe iyesi tukai',” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sises uya eikʉ'pʉ, “Saiman, ayauro'kato' uya ike moro man,” ta'pʉ iya. “Ekamakɨ, Ti'sa,” ta'pʉ iya nin si mɨrɨ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Asa'ron kon ka'pon amʉ' uya pʉrata tʉnin ye' ko'manʉ'pɨtʉ esi'pʉ te'mai' pʉra. Tikin nan uya 500 kaisa rɨ pʉrata pun ko'manʉ'pɨtʉ esi'pʉ, isakon uya 50 kaisa rɨ kanan pʉrata pun. ");
INSERT INTO akeNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","To' uya inna'poto' ike pʉra rɨ iyesi'pʉ. Asa'rɨ rɨ marɨ to' pɨ', ‘Tɨwɨ si nesii,’ ta'pʉ iya. Nai kʉrɨ uya kuru i'nʉnka ipan pe?” ta'pʉ iya nin si mɨrɨ Saiman pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Mɨrɨpan eikʉ'pʉ Saiman uya, “Eke kuru ipʉrataai ko'manʉ'nin nʉ'pʉ na'kɨ,” ta'pʉ iya. “Ipoken kuru i'tusa' auya mɨrɨ,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Mɨrɨ a'tai, iyera'tɨ'pʉ uri'san winɨkʉi', tai'ma Saiman pɨ', “Pʉse uri'san menyan? Ɨiwʉ' ta' uyepʉi, e'tane u'tuna'kwaai'tɨ auya pʉn u'ta kumi'to' uya ike ke. Mɨrɨ e'tane tenu paru ke u'ta amankasa' iya, tʉnse' ke a'munakasa' iya nɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Uya'su'kasa' auya pʉra iyesi, uyetupa pe, e'tane pʉse rɨ uri'san uya ewomʉ'pʉ si'kɨrɨ rɨ, u'ta a'su'ka nonkasa' pʉra rɨ iyesi. ");
INSERT INTO akeNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","U'pai karapaimasa' auya pʉra rɨ iyesi uyeseru kon yau, e'tane u'ta pona po'piyun masa' iya. ");
INSERT INTO akeNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Mɨrɨ pɨ' ta uya ɨpɨ', eke rɨ imakooi pɨ' usentu'masa' wenai, eke pe isi'nʉnkato' esi. E'tane si, kʉrɨ mararon imakooi pɨ' usentu'masa' na'ne' uya nin si, mara rɨ i'nʉnkan,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mɨrɨ a'tai nin si, ta'pʉ iya mɨrɨ uri'san pɨ', “Amakooi ton pɨ' usentu'masa' man,” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tʉron kon inkɨ'ma'san uya nin si ti'nau'nokon, “Ɨnʉ' si pʉse makoi pɨ' tʉusentu'masen?” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","“Apʉne pʉra uyapurɨsa' auya pɨ', Papa uya ɨpika'tɨsa' man auma'tato' apai. Enta si tʉusewankamai' pʉra,” ta'pʉ Sises uya uri'san pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tʉron nɨ a'tai, Sises utɨpɨtʉ'pʉ tʉron nɨ eke iwa ton pata kaisa rɨ'ne wakʉ Papa e'to' esa' wannɨ pe ekareei ekama pɨ' iyesi'pʉ. 12 kaisaron kon ipoitorʉ ton esi'pʉ iya'kɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","To' tonpa pe kanan upinin nɨ pɨ' uri'sami'si amʉ' makoi a'kwarʉ yen ton nʉ'san mɨrɨ awonsi'kɨ e'ne' ton nʉ'san Sises nepi'tɨ'san esi'pʉ: Meri, Matara pon, 7 kaisaron kon makoi a'kwarʉ epa'kasa' iyapai rʉ'pʉ; ");
INSERT INTO akeNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","mɨrɨ awonsi'kɨ Isowana, Kusa no'pʉ (Kusa esi'pʉ Era' esen o'non pe), mɨrɨ tʉpo Susana; mɨrɨ awonsi'kɨ tu'ke rɨ tʉron kon esi'pʉ. Pʉsamoro uri'sami'si amʉ' esi'pʉ mɨrɨ Sises pokon pika'tɨ pɨ' to' e'to' i'se ke rɨ tiwano' kon pe te'sen apai. ");
INSERT INTO akeNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tu'ke kuru rɨ anpisin pe rɨ ka'pon amʉ' amʉra koro'tau mɨrɨ awonsi'kɨ ka'pon amʉ' uyee'pʉ Sises piya' ɨse'ma'pʉ pe'ne rɨ eke iwa ton pata ton apai'ne, serɨ panton ekama'pʉ iya: ");
INSERT INTO akeNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Umɨ pɨ' te'sen utɨ'pʉ kiyari ye' pɨnse'na tʉpa'karakai'. Ipa'karaka iya koro'tau, tʉron nɨ ton uta'pokʉ'pʉ asanta ta'. Mɨrɨpan ka'pon amʉ' usarɨ uya iwasa'kapɨtʉ'pʉ, mɨrɨpan ɨku'pʉ toron amʉ' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tʉron nɨ ton uta'pokʉ'pʉ tɨ' pona. Iya'ta koro'tau, iyaipʉtapɨtʉ'pʉ, apʉne pʉra tuna eporo iya pʉra iyesi wenai. ");
INSERT INTO akeNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tʉron nɨ ton uta'pokʉ'pʉ tikʉkenan nʉ'ta', mɨrɨpan a'ta'pʉ ipokon pe, mɨrɨpan uya ɨwɨtanʉkʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mɨrɨ e'tane rɨ, tʉron nɨ ton uta'pokʉ'pʉ wakʉ non ya'. Mɨrɨpan a'ta'pʉ, iyepeta'pʉ. Iyepeta'pʉ eke pe rɨ, 100 kaisa rɨ ite'kwa e'to' airɨ inpɨmɨ'pʉ entai rɨ,” ta'pʉ iya. Serɨ ta'pʉ iya a'tai, ikɨ'pɨ'nʉmʉ'pʉ, “Kʉrɨ tʉpana ke na'ne' etato' ike, tɨwɨ netai!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ipoitorʉ ton uya ekama'po'pʉ ɨ'rɨ ta e'kwa pe serɨ panton esi tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ta'pʉ iya to' pɨ', “Ɨnʉ' ni'tunʉ pen nɨ ama'aino Papa e'to' esa' wannɨ pe i'tu kon pa ɨyena'nokon itʉsa', e'tane tʉron kon pana ya' panton yai usaurokʉ, ‘Enei'ma rɨ to' uya ene pʉra iye'to' pe; etai'ma rɨ to' uya ito'ka'nʉkʉ pʉra iye'to' pe.’ ");
INSERT INTO akeNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Se nin si ta iya e'kwa pe, panton esi mɨrɨ, ite' pe na'ne' mɨrɨ, Papa Maimu. ");
INSERT INTO akeNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kamoro asanta tau na'ne' nan esi Papa Maimu etanin nan. Mɨrɨpan nin si, makoi uyepʉ to' ewan yawon main mo'kai', to' uya apurɨ namai', mɨrɨpan kon epika'tɨ namai'. ");
INSERT INTO akeNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kamo tɨ' pon kon kamoro main anʉnnin nan pori' pe eta tʉuya'nokon a'tai, e'tane to' mi' pʉra rɨ to' esi. Aka'ne' pe rɨ to' uya apurɨ, e'tane ekamʉn uya teposa' kon a'tai, to' uya inonka. ");
INSERT INTO akeNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ite' tikʉkenan nʉ'ta' ita'po'sa' na'ne' mɨrɨ kamoro etanin nan, e'tane to' uko'mamʉ koro'tau, non eseru uya to' anpokʉma tʉuko'mamʉ kon yau tu'kan pɨ' rɨ to' usenuminka, imaminke' pe te'to' kon pɨ' rɨ, wakʉ pe tʉuko'manto' kon pɨ' rɨ. Mɨrɨpan kon akʉ'pʉ pʉra iyesi. ");
INSERT INTO akeNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","E'tane si wakʉ non po na'ne' ite' kamoro wakʉ pe te'san, wakʉ itewan ton. Main etanin nan, anʉnnin nan, mɨrɨpan ko'manʉkʉ to' uya epeta. ");
INSERT INTO akeNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ɨnʉ' uya rɨ raan'pu po'tɨ pʉra iyesi onanto' pe tʉuya wai ya' mɨrɨ pe pʉra te'nʉnto' apon o'koi' rɨ itʉrʉ iya. E'tane ru'ku, itapon pona itʉrʉ iya kamo tewonsan uya iweyu ento' pe. ");
INSERT INTO akeNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Mɨrɨ a'tai nin si tɨ, tanporon nɨ usene; ama'ai na'ne' serɨ pe usenpoikato' oton kɨpo'pona. ");
INSERT INTO akeNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Mɨrɨ pe iyesi pɨ', wakʉ pe tʉusenuminkai' e'tɨ' etato' auya'nokon pɨ'. Ɨnʉ' rɨ itesa' pe te'sen repa mɨrɨ miyarɨ rɨ; ɨnʉ' rɨ ɨ'rɨ esa' pen nɨ enapai imo'ka mɨrɨ itesa' pe tesi tukai' rɨ iye'ku'to',” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mɨrɨ a'tai Sises san mɨrɨ awonsi'kɨ iyakon non uyee'pʉ ense'na, e'tane a'ko pe ipiya' to' utɨ poken pʉra rɨ iyesi'pʉ, apʉne pʉra anpisin esi wenai. ");
INSERT INTO akeNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ka'pon uya ipana'tɨ'pʉ, “Asan mɨrɨ awonsi'kɨ ayakon non e'soto'pɨ'sa' man pʉroroi po, ɨyenpai to' esi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Eikʉ'pʉ iya, “Usan mɨrɨ awonsi'kɨ uyakon non kamoro Papa Maimu eta pɨ' te'san, mɨrɨ awonsi'kɨ ikupʉ pɨ' te'san,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tʉron nɨ a'tai, Sises uya tʉpoitorʉ ton pɨ', “Parau ku'pɨri ratoi pona e'kwɨrɨ'nɨpai'nokon,” ta'pʉ. Mɨrɨpan kon ekanwa'tɨsa' utɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","To' e'kwɨrɨtʉ koro'tau, Sises e'nʉmʉ'pʉ. Mɨrɨ a'tai, ɨsɨ pe a'setun uyepʉ parau ku'pɨri ka' uya, to' kanwa rawoirawoima'pʉ to' kuruuka poken. ");
INSERT INTO akeNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ipoitorʉ ton uya enpaka'pʉ, “Uyepuru, uyepuru! Aputan pe man!” tai'ma. Mɨrɨpan upakasa' uya e'se'ne' pe a'setun pɨ', mɨrɨ awonsi'kɨ sipa'sipa pɨ', “E'tʉ'nɨkɨ!” ta'pʉ. Mɨrɨpan ton si e'tʉ'nɨ'pʉ, imaimu awɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","“Nai apurɨto' auya'nokon ike?” ta'pʉ iya tʉpoitorʉ ton pɨ'. Tetʉipɨtʉ kon pe rɨ, tʉusewansiuka kon pe rɨ to' usekama'po'pʉ, “Ɨnʉ' si pʉse? A'setun mɨrɨ awonsi'kɨ tuna esereme'nin, mɨrɨpan ton esi imaimu awɨrɨ!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Mɨrɨpan kon si utɨ'pʉ Kerasa nono pona serɨ si parau ku'pɨri Kiyarari ratoi pona. ");
INSERT INTO akeNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Sises ekanwaka koro'tau, ka'pon, makoi a'kwarʉ yen uya eporo'pʉ pata winɨpai. Inke pʉse rɨ uko'mamʉ'pʉ tʉpon ke pʉra, ɨutɨ tau pʉra rɨ, e'tane uruwai' yau'ne rɨken. ");
INSERT INTO akeNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Sises ensa' tʉuya a'tai, ipirorʉmʉ'pʉ eke pe, mɨrɨpan useremuruku'pʉ Sises rau. Mɨrɨpan ukɨ'pɨ'nʉmʉ'pʉ eke pe, “Ɨ'rɨ pe ukupʉ i'se ɨwesi, Sises, Papa Mumu? Apʉne, ukota'makapʉi!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Serɨ ta'pʉ iya, apʉne pʉra Sises uya epa'kakɨ iyapai taka'sa' pɨ' tʉpɨ'. Sises uya eporo rawɨrɨ, inke rɨ sa'ne makoi a'kwarʉ uya a'sisa' ko'manʉ'sa' esi'pʉ. To' uya rɨ temiyatʉ, ti'ta rɨ auronpɨ'sa' e'tane i'sen ke, tʉpa'simanin ke rɨ te'tane, i'kɨrɨpɨtʉ'pʉ iya rɨ, mɨrɨpan apɨtʉ'pʉ makoi a'kwarʉ ton uya tʉ'kena'pɨ ya'. ");
INSERT INTO akeNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Sises uya si ekama'po'pʉ, “Ɨnʉ' ɨyese'?” ta'pʉ iya. “Anpisin,” ta'pʉ iya ipɨ', apʉne pʉra anpisin yen pe rɨ tesi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mɨrɨpan a'tai, ipan pe rɨ Sises pawana'tɨ'pʉ to' uya, “Ina kʉsennokoi ta'mu kenan pen nɨ ya'!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tu'kan kon peiruku amʉ' esi'pʉ enta'nan pɨ' i'kʉrʉ po a'ko pe rɨ. Makoi a'kwarʉ ton uya Sises pawana'tɨ'pʉ tenno'to' kon pe iya peiruku amʉ' ya'. “Ewai',” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mɨrɨpan kon utɨ'pʉ si peiruku amʉ' ya' ɨsentɨi'. Mɨrɨpan kon si e'tʉrʉ'kwa'pʉ parau ku'pɨri ka', mɨrɨpan kon aputa'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","To' esanon uya serɨ ensa' a'tai, to' utɨ'pʉ pata pona ekare'tɨse'na siya rɨ pata kaisarɨ rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ka'pon amʉ' uyee'pʉ iye'ku'sa' rʉ'pʉ ense'na. To' uye'sa' a'tai Sises piya', to' uya kʉrɨ rɨ ka'pon eporo'pʉ, makoi a'kwarʉ enpʉ'pʉ. Sises piyau iyereutasa' esi'pʉ iyepontɨsa', wakʉ pe nin si iya'kwarʉ, mɨrɨpan pɨ' to' enari'nʉmʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kamoro ennin nʉ'san uya ekama'pʉ ka'pon amʉ' pɨ', “Makoi a'kwarʉ yen pe te'sen epi'tɨ'pʉ Sises uya,” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Mɨrɨ a'tai, tanporo Kerasa nono pon kon uya Sises ennoko'pʉ tʉpiyapai'nokon, apʉne pʉra enari'ke' pe tenasa' kon pɨ'. Mɨrɨpan ekanwa'tɨsa' utɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Itɨ koro'tau, kʉrɨ rɨ ka'pon uya Sises pawana'tɨ'pʉ iya'kɨrɨ tʉutɨto' pe, e'tane Sises uya ta'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ɨtunta' apata'se' ya' Papa nʉkupʉ'pʉ ɨpɨ' ekamata ɨtonpa ton pana ya',” ta'pʉ iya. Mɨrɨpan si utɨ'pʉ mɨrɨ, Sises nʉkupʉ'pʉ tʉpɨ' ekamase'na mɨ awɨrɨ rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sises enna'posa' a'tai, anpisin ka'pon amʉ' epori'ma'pʉ ipɨ'. Iyenna'po enupɨkɨrɨ te'sa' kon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mɨrɨ a'tai si, ka'pon Isairas itese', Esuwerʉ amʉ' usenupato' iwʉ' epuru pe te'sen uyee'pʉ Sises piya'. Mɨrɨpan useremuruku'pʉ Sises pʉta piyau inama tʉuya ekamanin pe, ipawana'tɨ'pʉ iya tiwʉ' ta' iye'to' pe, ");
INSERT INTO akeNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","apʉne pʉra tikin nan nʉ'kwɨ tensi 12 kaisaron iwʉipiyaai erikʉ pɨ'. Sises utɨ koro'tau Isairas iwʉ' winɨkʉi', anpisin ka'pon amʉ' uya iwontɨ'pʉ, i'ta pata'se' pʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mɨrɨpan kon koro'tau, uri'san esi'pʉ mʉn pɨ' tʉutɨsen, iko'mansa' 12 kaisa rɨ wʉipiya mɨrɨ pɨ', e'tane ɨnʉ' uya epi'tɨ pʉra rɨ iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mɨrɨpan uyee'pʉ Sises a'poi winɨ ipon e'pi pɨ' a'pɨ'se'na. Mɨrɨ a'tai rɨ, imʉnʉ utɨ ereuta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","“Ɨnʉ' uya'pɨtʉi?” ta'pʉ Sises uya. Ka'pon amʉ' e'wapu'tɨ pɨ', Pi'ta uya ta'pʉ, “Uyepuru, anpisin nɨ ne' ka'pon amʉ' aya'pɨ'pɨtʉ pɨ' ko,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","E'tane Sises uya ta'pʉ, “Ka'pon uya kuru sa'ne uya'pɨ'sa' i'tu uya, meruntɨ epa'kasa' pɨ' upiyapai,” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kʉrɨ rɨ si uri'san uya ti'tusa' iya i'tusa' a'tai, iyee'pʉ ɨsi'nʉkʉi'ma rɨ, mɨrɨpan tetʉipɨtʉ pe rɨ iseremuruku'pʉ Sises pʉta piyau. Tu'kan kon koro'tau, isekama'pʉ, mɨrɨ wenai, “Aya'pɨ'sa' uya tukai', mɨrɨpan usepi'tɨsa',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Mɨrɨpan pɨ' Sises uya ta'pʉ, “Ma'non, Papa apurɨ auya uya rɨ ɨyepi'tɨsa' man. Enta tʉusewankamai' pʉra,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Sises usaurokʉ koro'tau, ka'pon uyee'pʉ, Isairas iwʉ' tapai, mɨrɨpan uya ta'pʉ ipɨ', “Ɨyensi eri'ka'sa' man. Tɨwɨ nesii ti'sa kʉsanpokʉmai,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Serɨ eta tʉuya a'tai, Sises uya ta'pʉ Isairas pɨ', “Kɨsewankamai. Uyapurɨkɨ rɨken, mɨrɨ a'tai Papa uya ito'panʉkʉ rɨ mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Isairas iwʉ' ta' tʉuye'sa' a'tai, ɨnʉ' rɨ ewomʉ i'se pʉra iyesi'pʉ ta'kɨrɨ, Pi'ta, Isens, mɨrɨ awonsi'kɨ Isaan nɨken mɨrɨ awonsi'kɨ kʉrɨ rɨ si mʉre sanon. ");
INSERT INTO akeNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mɨrɨ koro'tau, tanporo ka'pon amʉ' ukaramʉ esi'pʉ tʉuta'kwarʉkai' iwenai. “E'pana e'tɨ'. Iyeri'sa' pen mɨrɨ, e'tane iye'nʉmʉ rɨ nin,” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","To' uta'kɨrɨ'pʉ ipɨ', iyeri'sa' tukai' i'tu tʉuya'nokon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mɨrɨpan iwʉ' ta' iyewomʉ'pʉ, itemiyatʉ pɨ' nin si ta'sii', “Uri'san mʉre, e'mʉ'sa'ka'!” ta'pʉ iya mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ita'kwarʉ si uyee'pʉ mɨrɨ, mɨrɨpan e'mʉ'sa'ka'pʉ mɨrɨ a'tai rɨ. Mɨrɨpan Sises uya to' pɨ' ta'pʉ, “Ewe'tɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Mɨrɨpan pɨ' isanon usewansiuka'pʉ, e'tane si tɨ, “Kʉsekamatʉu ɨnʉ' pana ya' rɨ,” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Sises uya 12 kaisaron kon tʉpoitorʉ ton amʉranʉ'sa' a'tai, to' repa'pʉ iya to' meruntɨrʉ ke, to' pana'pano ke tanporo ɨri a'kwarʉ a'tu'manin pe to' e'to' pe, mɨrɨ awonsi'kɨ paran epi'tɨnin pe to' e'to' pe. ");
INSERT INTO akeNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","To' ennoko'pʉ iya, Papa e'to' esa' wannɨ pe ekareei ekamai', e'ne' ton nɨ nɨrɨ epi'tɨi'. ");
INSERT INTO akeNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","“Ɨ'rɨ rɨ kʉsatʉu,” ta'pʉ iya to' pɨ'. “Teke'sen, paiki, wenamʉ', pʉrata, asa'rɨ ɨpon kon kʉsatʉu. ");
INSERT INTO akeNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ɨyereutanʉ'nin kon nʉ'pʉ piyau me'tʉi', tʉron nɨ pata nɨmɨ auya'nokon pona rɨ, ");
INSERT INTO akeNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ka'pon amʉ' uya ɨyereutanʉkʉ kon pʉra iyesi yau, a'ta kon mʉtɨutɨpɨ'tʉi' to' pata nɨmɨ auya'nokon a'tai, Papa uya to' kota'mato' oton ekamanin pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mɨrɨpan kon utɨ'pʉ eke iwa ton pata kaisa rɨ'ne, wakʉ itekare ekama pɨ', e'ne' ton nɨ nɨrɨ epi'tɨ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kopʉna Era' uya etasa' a'tai tanporo te'ku'sen, i'pai utaka'ma'pʉ, apʉne pʉra tʉron kon uya Sises esi Isaan e'mʉ'sa'kasa' pe terikʉ'pʉ apai ta pɨ', ");
INSERT INTO akeNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","tʉron kon uya kanan pu'kena' Iraisa usenpoikasa' ta wenai, tʉron kon uya rɨ marɨ penaro' kon eke ton pu'kena' amʉ' tonpa e'mʉ'sa'kasa' ta pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","E'tane si Era' uya ta'pʉ, “Isaan ne si'pairʉkatai ko. Ɨnʉ' nɨrɨ ken si ekareei eta uya serɨ?” ta'pʉ iya. Mɨrɨpan esi'pʉ Sises ɨnenpai. ");
INSERT INTO akeNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sises nennoko'san enna'posa' a'tai, tʉnkupʉ'pʉ kon ekama'pʉ to' uya Sises pɨ'. Mɨrɨ a'tai, Sises uya to' arɨ'pʉ anpisin a'kɨrɨ pʉra Pe'saita pata pona. ");
INSERT INTO akeNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tu'kan kon uya eta'pʉ, mɨrɨpan kon utɨ'pʉ Sises pɨkɨrɨ. To' ereutanʉkʉ'pʉ iya, mɨrɨpan kon auro'ka'pʉ iya, Papa e'to' esa' wannɨ pe ekareei pɨ'. Ɨsepi'tɨpaino kon, e'ne' ton epi'tɨ'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pata uko'mansa' a'tai, 12 kaisaron kon ipoitorʉ ton uyee'pʉ ipiya', “To' enno'kɨ eke iwa ton pata pona'ne mɨrɨ awonsi'kɨ umɨ awɨrɨ'ne ti'kiyari kon epoto' pe to' uya, pata tʉto' tʉuya'nokon nɨ epoto' pe to' uya. Ɨnnon pata yau e'nɨ pɨ',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Sises uya ta'pʉ to' pɨ', “To' ewe'tɨ',” ta'pʉ iya. Mɨrɨpan pɨ' ta'pʉ to' uya, “5 kaisa rɨ rʉ'kwɨ itekiino pʉreti esi, mɨrɨ awonsi'kɨ asa'ron kon nʉ'kwɨ moro' amʉ'. Kiyari rɨ nin ennase utɨn nɨsa' a'tai, to' ewe'to'pan,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(5,000 kaisa rɨ iwa rɨ ka'pon amʉ' esi'pʉ mɨrɨ yau.) E'tane rɨ tʉpoitorʉ ton pɨ' ta'pʉ iya, “To' ereutanʉ'pɨ'tɨ' tamu'kuru' ke'ne 50 kaisa rɨ'ne,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Mɨrɨpan kuu'pʉ ipoitorʉ ton uya, tanporon kon ereutapɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","5 kaisaron itekiino pʉreti anʉmʉ'pʉ iya, asa'ron kon moro' amʉ' rʉ'kwɨ nɨrɨ mɨrɨ esa' pe esii'ma, tenu tʉrʉ'pʉ iya ka'takʉi'. Tenki ta pe rɨ Papa pɨ' i'kwɨ'pɨtʉ'pʉ iya si. Mɨrɨpan uya itʉrʉ'pʉ tʉpoitorʉ ton ena' to' uya ekanto' pe. ");
INSERT INTO akeNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","To' enta'na'pʉ ta'weta kon pona rɨ. Mɨrɨpan tonpa'pʉ amʉranʉkʉ'pʉ ipoitorʉ ton uya, 12 kaisa rɨ pa'siki'ti. ");
INSERT INTO akeNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tʉron nɨ a'tai, Sises ɨpʉrema koro'tau, tʉpoitorʉ ton pokon pe rɨken, to' ekama'po'pʉ iya, “Ɨnʉ' pe rɨ esi tukai' anpisin ka'pon amʉ' nʉsauro'an?” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","To' uya entakanoma'pʉ, “Tʉron kon uya Isaan Pa'tes ta; tʉron kon uya kanan pu'kena' Iraisa ta; tʉron kon uya rɨ marɨ penaro' kon eke ton pu'kena' amʉ' tonpa e'mʉ'sa'kasa' ta ɨpɨ',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“E'tane si ɨmɨrɨ'nokon, ɨnʉ' pe ken si esi tukai' mʉkayatʉu?” ta'pʉ iya. Pi'ta uya eikʉ'pʉ, “Ɨmɨrɨ kʉrɨ rɨ Kʉrai, Papa iwano',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Sises uya ipan pe to' panama'pʉ ɨnʉ' pɨ' rɨ to' uya serɨ ekama namai'. ");
INSERT INTO akeNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Mɨrɨpan uya ta'pʉ, “Ka'pon, Papa winon uya e'ne' moronkato' oton eke pe rɨ, mɨrɨpan ewaruma'tɨto' oton Esuwerʉ amʉ' epuru ton uya, use'man nɨto' tʉrawasomanin nan epuru ton uya, mɨrɨ awonsi'kɨ main pɨ' enupanin nan uya, mɨrɨpan wɨto' oton mɨrɨ awonsi'kɨ iye'mʉ'sa'kato' oton itosorʉwano wʉi a'tai uko'man nɨto' ya',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mɨrɨpan uya ta'pʉ tanporo to' pɨ', “Ɨnʉ' rɨ uyepʉ pe iyesi yau uye'ma'pʉ pe, tʉpɨ' rɨ tʉupu'tɨka'se tʉkurusukuui tanʉnse wʉi kaisa rɨ nʉyepʉi upɨkɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Apʉne pʉra ɨnʉ' rɨ kʉrɨ tʉuko'manto' ɨnnonkapai pʉra na'ne' uya tʉuko'manto' rɨ nonka mɨrɨ. E'tane ɨnʉ' rɨ kʉrɨ tʉuko'manto' nonkanin upɨkɨrɨ uya innonka pen nɨ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Wakʉ pe pe' ka'pon esi tanporo non pon eponin tʉmɨrɨ rɨ nonkai'ma, mɨrɨ pe pʉra eno'mai'ma te'sen? ");
INSERT INTO akeNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ɨnʉ' rɨ ɨpiyɨtʉ yau upɨ' mɨrɨ awonsi'kɨ umaimu ton pɨ', Ka'pon, Papa winon nɨ nɨrɨ ɨpiyɨtʉ mɨrɨ ipɨ' tʉmeruntɨrʉ yau tʉuyepʉ a'tai mɨrɨ awonsi'kɨ ikʉipʉnʉ meruntɨrʉ yau, mɨrɨ awonsi'kɨ inserʉ amʉ' meruntɨrʉ yau. ");
INSERT INTO akeNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","I'napairon ekama uya ɨpɨ'nokon, serɨ yau iye'soto'pɨ'sa' na'ne' nan tonpa ton eri'to' oton pen Papa e'to' esa' wannɨ pe ene tʉuya'nokon rawɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","8 pe wʉi pata'pʉ pe iwa rɨ serɨ ta iya tʉpo, Pi'ta, Isaan, mɨrɨ awonsi'kɨ Isens arɨ'pʉ iya ta'kɨrɨ, mɨrɨ awonsi'kɨ wʉ' pona to' enuku'pʉ ɨpʉremai'. ");
INSERT INTO akeNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Iyɨpʉrema koro'tau, tʉron nɨ pe itemʉ' ena'pʉ, mɨrɨpan pon ena'pʉ aimu'ne sirɨn pe kamiri' e'wei'tɨ kasa. ");
INSERT INTO akeNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Asa'ron kon ka'pon amʉ' usenpoika'pʉ a'kwa pe kuru, Mosi', mɨrɨ awonsi'kɨ Iraisa, ");
INSERT INTO akeNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","mɨrɨpan kon uya Sises auro'ka'pʉ. To' usaurokʉ'pʉ itɨto' pɨ', iye'ku'to' pe ta'pʉ rʉ'pʉ Papa uya uta'ku'tɨto' pe iyerikʉ winɨ Surusiran po. ");
INSERT INTO akeNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ipan pe e'moronʉ' pe Pi'ta mɨrɨ awonsi'kɨ itonpa ton ena'pʉ e'tane, to' upakasa' a'tai, to' uya ene'pʉ ita'kwarii mɨrɨ awonsi'kɨ asa'ron kon ka'pon amʉ' e'soto'pɨ'sa' esi'pʉ ipiyau. ");
INSERT INTO akeNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ka'pon amʉ' uya Sises nɨmɨ koro'tau, Pi'ta uya ta'pʉ ipɨ', “Wakʉ rɨ pan pe serɨ yau ina man, uyepuru. Tɨwɨ ina osorʉwau ɨiwʉ' kon amɨi; tikin nɨ ɨiwʉ' pe, tikin nɨ Mosi' iwʉ' pe, Iraisa iwʉ' pe nɨrɨ,” ta'pʉ iya. (Mɨrɨ ta tʉuya tukai' i'tu iya pʉra iyesi'pʉ.) ");
INSERT INTO akeNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Isaurokʉ koro'tau, kapuru' usenpoika'pʉ, mɨrɨpan uya to' nɨpontɨ'pʉ, mɨrɨpan kon usi'nʉkʉ'pʉ kapuru' ya' ewomʉi'ma. ");
INSERT INTO akeNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Main uyee'pʉ kapuru' apai, “Umu pʉse rɨ, Unanʉmʉ'pʉ. Imaimu etatɨ',” tawon. ");
INSERT INTO akeNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Main useta tʉpo, to' uya Sises ene'pʉ tikin sarɨ. Ipoitorʉ ton uya serɨ enkurunpa'pʉ tʉpiyau'nokon, mɨrɨ a'tai ɨnʉ' pɨ' rɨ to' uya tʉnene'pʉ kon ekama'pʉ pen nɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mɨrɨ ema'sa' yau wʉ' poi to' u'tɨsa' a'tai, anpisin nɨ ka'pon amʉ' uya to' eporo'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Warawo' to' koro'tawon ukɨ'pɨ'nʉmʉ'pʉ, “Ti'sa!” ta'pʉ iya. “Ɨyekama'po uya umu ene pa, tikin nan nʉ'kwɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ɨri a'kwarʉ uya a'sipɨ'pɨtʉ, mɨrɨ uya ipirorʉnpapɨtʉ, iyai enno'pɨtʉ iya, mɨrɨpan mʉta a'koronta. Inonka iya pʉra iyesi, ima'tanʉkʉ iya rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ɨpoitorʉ ton pɨ', ‘Enpa'katɨ',’ ta'pʉ uya e'tane, to' uya ikupʉ poken pʉra iyesi'pʉ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Mɨrɨ a'tai, Sises uya ta'pʉ to' pɨ', “Ɨri sɨ! Ɨri ton nɨ, apurɨnin nan pen nɨ serɨ a'taino kon! Ɨ'rɨ pʉ'kʉ pona ɨpiyau'nokon uko'mamʉ? Ɨ'rɨ pʉ'kʉ pona aya'kɨrɨ'nokon esi? Ɨmu ine'kɨ se ya',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Warawo' mʉre uyepʉ koro'tau rɨ, makoi a'kwarʉ uya eno'ma'pʉ non pona iyai ennoko pe. E'tane Sises uya e'se'ne' pe ɨri a'kwarʉ eseremekʉ'pʉ. Mɨrɨ a'tai, Sises uya warawo' mʉre epi'tɨ'pʉ, mɨrɨpan tʉrʉ'pʉ iya ikʉipʉnʉ ena'. ");
INSERT INTO akeNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mɨrɨpan kon usewansiuka'pʉ Papa meruntɨrʉ ke Sises e'tʉrawasoma pɨ'. Tʉusewansiuka'pʉ kon si'kɨrɨ rɨ ka'pon amʉ' esi koro'tau Sises nʉkupʉ'pʉ pɨ', ta'pʉ iya tʉpoitorʉ ton pɨ', ");
INSERT INTO akeNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Wakʉ pe etatɨ' kanyauro'kayatʉi'ne', Ka'pon, Papa winon eparankato' oton ka'pon amʉ' ena',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","E'tane to' uya ito'ka'nʉkʉ pʉra iyesi'pʉ ɨ'rɨ ta e'kwa pe serɨ esi tukai'. To' piyapai iye'so'nansa' esi'pʉ to' uya a'si poken pʉra, mɨrɨpan kon enari'nʉmʉ'pʉ mɨrɨ pɨ' ɨnekama'popai pʉra. ");
INSERT INTO akeNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","E'sei'pɨ' nɨ pɨ' ipoitorʉ ton e'sara'tɨ'pʉ, ɨnʉ' kuru e'to' oton eke pe tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Sises uya nin si to' usenuminkato' i'tu tʉuya pɨ', mʉre rʉ'kwɨ nee'pʉ mɨrɨ, mɨrɨpan soto'ka'pʉ iya tʉpiyau. ");
INSERT INTO akeNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Mɨrɨ a'tai, ta'pʉ iya to' pɨ', “Ɨnʉ' uya rɨ pʉse rɨ mʉre ereutanʉkʉ a'tai uyese' yau, uyereutanʉkʉ iya pe rɨ iyesi. Ɨnʉ' uya rɨ uyereutanʉkʉ a'tai, uyenno'nin nʉ'pʉ rɨ ereutanʉkʉ iya pe iyesi. Apʉne pʉra kʉrɨ rɨ aiko pe rʉ'kwɨ na'ne' ɨ'koro'tau'nokon, kʉrɨ rɨ kuru esi eke pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","“Uyepuru,” ta'pʉ Isaan uya, “ka'pon ene'pʉ ina uya ɨyese' yau ɨri a'kwarʉ ton enpa'kapɨ'nin. Mɨrɨpan ereutanʉkʉ i'se ina esi'pʉ, apʉne pʉra utonpa kon pe pʉra iyesi pɨ',” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","“Kʉsereutanʉ'tʉu,” ta'pʉ Sises uya, “apʉne pʉra ɨnʉ' rɨ ɨyewa'nomanin pen esi ɨwenaino' pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Epʉn pona tʉutɨto' weyu e'seporo koro'tau, Sises e'kama'pʉ utɨn pɨ' Surusiran pona ");
INSERT INTO akeNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","tʉmaimu anin nan ennoko'pʉ iya tʉrawɨrɨ. Mɨrɨpan kon utɨ'pʉ eke iwa Sameriya pon pata pona ite'ma ta' ekonekase'na, ");
INSERT INTO akeNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","e'tane mɨrɨ yawon kon uya ereutanʉkʉ'pʉ pen, apʉne pʉra Surusiran pona itɨ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Serɨ ensa' ipoitorʉ ton, Isens mɨrɨ awonsi'kɨ Isaan uya a'tai, to' uya ekama'po'pʉ, “Uyepuru, apo' pe' nu'tɨ uya'nokon i'se me'an Epʉn poi to' ma'tanʉ'nin pe?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","E'tane, Sises era'tɨ'pʉ to' esereme'se'na, ");
INSERT INTO akeNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","mɨrɨpan kon utɨ'pʉ tʉron nɨ eke iwa pata ya'. ");
INSERT INTO akeNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Utɨn pɨ' rɨ to' esi koro'tau asanta tawɨrɨ, ka'pon uya ta'pʉ ipɨ', “Aya'kɨrɨ utɨ serɨ mʉtɨyai'ne' ya' rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Sises uya eikʉ'pʉ, “Maikan amʉ' kamoro tenkena' nan, toron amʉ' nɨrɨ tʉponkena' nan, e'tane Ka'pon, Papa winon e'sapontɨto' yau pʉn nɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tʉron nɨ pɨ' nin si ta'pʉ iya mɨrɨ, “Ɨisirɨ uya'kɨrɨ,” ta'pʉ iya. E'tane eikʉ'pʉ iya, “Uyepuru, apʉne wapiya ukʉipʉnʉ siu'na'tɨka'tai'ya,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mɨrɨpan pɨ' ta'pʉ iya, “Tɨwɨ kamoro Papa ese' pokon kon pen tekepu kon u'na'tɨi, e'tane enta Papa e'to' esa' wannɨ pe ekareei ekamai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mɨrɨ rɨ e'tane, tʉron nɨ uya kanan, “Uyepuru, aya'kɨrɨ utɨ, e'tane wapiya kuru utonpa ton piya' utɨi'ya, ‘Ɨisirɨ utɨyai',’ ka'se'na,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Sises uya eikʉ'pʉ, “Ɨnʉ' rɨ upɨkɨrɨ te'sara'tɨ tʉpo tenu tʉpɨ'nin te'ma'pʉ ta' esi mɨrɨ Papa e'to' esa' wannɨ pe tʉrawasomanin ye' pe pʉra rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Serɨ pata'pʉ pe, Sises uya tʉron kon 72 kaisaron kon tʉnanʉmʉ'san ennoko'pʉ asa'rɨ'ne tʉrawɨrɨ to' utɨto' pe pata kaisa rɨ'ne tʉutɨto' ya'ne to' enupai' tʉpɨ', mɨrɨ awonsi'kɨ to' enna'poto' pe. ");
INSERT INTO akeNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","To' ennoko tʉuya rawɨrɨ, ta'pʉ iya to' pɨ', “Eke pe kiyari akʉ'pʉka'sa' tanʉnsen man, e'tane tu'ke pʉra tʉrawaso amʉ' esi. Mɨrɨ pe iyesi pɨ', kiyari akʉ'pʉsa' anʉmʉ Epuru ekama'potɨ', tʉrawaso amʉ' enno'to' pe iya kiyari akʉ'pʉsa' anʉmʉ e'kwa na'. ");
INSERT INTO akeNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Entantɨ'! Ɨyennoko uya 'nokon serɨ karimeru munkɨ kasa ɨsɨ ton ene amʉ' koro'tau. ");
INSERT INTO akeNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ɨ'rɨ rɨ kʉsatʉu; ɨpʉrataai kon yen nɨ, apaikii kon nɨ, asapatooi kon nɨ, mɨrɨ awonsi'kɨ asanta tawon kon pɨ', ‘Miyarɨ,’ ta'pʉ auya'nokon si'kɨrɨ rɨ kereutatʉu. ");
INSERT INTO akeNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ɨutɨ ta' ɨyewomʉ kon rawɨrɨ, ‘Tɨwɨ tʉusewankamai' pʉra e'nɨto' nesii serɨ ɨutɨ tau,’ mʉkatʉi'. ");
INSERT INTO akeNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tʉusewankamai' pʉra e'nɨ ku'nin ka'pon esi yau mɨrɨ yau, tɨwɨ tʉusewankamai' pʉra e'nɨto' nesii ipiyau. Mɨrɨ pe pʉra iyesi yau, tɨwɨ ɨpona'nokon nenna'poi. ");
INSERT INTO akeNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mɨrɨ si ɨutɨ tau me'tʉi', uta're'tɨn pɨ' to' uya ɨrepato' kon ike pɨ', apʉne pʉra tʉrawaso kʉrɨ rɨ tepe'pʉ warinpanin. Ɨutɨ kaisa rɨ ke'kwɨrɨ'pɨ'tʉu. ");
INSERT INTO akeNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Pata ya' ɨyewonsa' kon ereutanʉ'sa' a'tai, anta'napasa' kon pɨ' menta'natʉi'. ");
INSERT INTO akeNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mɨrɨ yawon kon e'ne' ton mepi'tɨtʉi', ‘Papa e'to' esa' wannɨ pe man a'ko pe ɨpiyau'nokon,’ mʉkatʉi' to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","E'tane pata ya' ɨyewonsa' kon ereutanʉ'sa' to' uya pʉra iyesi a'tai, asanta ta' mʉtɨtʉi', ");
INSERT INTO akeNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Non nɨ apata kon yawon uta'si'sa' ina pʉta pɨ' tɨutɨ ina uya apa'nʉkʉ kon pe. E'tane se kuru i'tutɨ': Papa e'to' esa' wannɨ pe man a'ko pe,’ mʉkatʉi' to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Apana'tɨ uya 'nokon, Satan uya imoronka poken pa rɨ iye'to' oton mɨrɨ wʉi a'tai, mɨrɨ pata uya imoronka entai iye'tane,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Sises uya ta'pʉ, “Ɨsɨ sɨ, Korasin pon kon! Ɨsɨ sɨ, Pe'saita pon kon! Apʉne pʉra eke Papa tʉrawasooi e'ku'sa' na'ne' apata'se' kon yau, e'ku'sa' yau, Taya mɨrɨ awonsi'kɨ Saitan pon kon koro'tau, pena rɨ to' era'tɨ'pʉ nesii'no tʉmakooi kon apai isa'ka'si ya' tepontɨi' to' ereutasa' nesii'no urumɨrʉ'pʉ yau. ");
INSERT INTO akeNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","E'tane Taya mɨrɨ awonsi'kɨ Saitan pon kon uya pa rɨ imoronkato' oton eseru aimenka weyu e'seposa' a'tai ɨmɨrɨ'nokon entai. ");
INSERT INTO akeNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ɨmɨrɨ'nokon, Ka'paneyan pon kon, autanʉnto' oton kon pe' ka'takʉi'? Kane, auta'mo'kato' oton kon mɨrɨ ta'mu kenan pen nɨ ya',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","(Tʉpoitorʉ ton pɨ' ta'pʉ iya,) “Kʉrɨ amaimu kon etayai'ne' uya umaimu rɨ etakapʉ mɨrɨ; kʉrɨ ɨyewaruma'tɨyai'ne'nokon uya rɨ kanan uyewaruma'tɨ mɨrɨ; kʉrɨ uyewaruma'tɨyai'ne' uya rɨ nɨrɨ kʉrɨ uyenno'nin nʉ'pʉ ewaruma'tɨ mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","72 kaisaron kon inennoko'san nʉ'pʉ enna'po'pʉ pori' pe, mɨrɨpan kon uya ta'pʉ, “Uyepuru, ɨri ton a'kwarʉ rɨ esi'pʉ ina maimu awɨrɨ, ɨyese' yau ina uya tenpa'ka kon a'tai ka'pon amʉ' apai,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Eikʉ'pʉ iya, “Se'tan uta'mo'ka senei kamiri' kasa ka' apai. ");
INSERT INTO akeNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ɨmeruntɨrʉ kon ke ɨrepasa' uya 'nokon ɨkʉi amʉ' mɨrɨ awonsi'kɨ mɨnɨ' amʉ' wasa'pɨ'nin pe, tanporo ɨyeyaton kon Makoi meruntɨrʉ entai ɨwesi kon pa, ɨ'rɨ uya rɨ ama'tanʉkʉ kon pen. ");
INSERT INTO akeNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","E'tane pʉra, ɨri a'kwarʉ amʉ' e'sa' pɨ' amaimu kon awɨrɨ kepori'matʉu, e'tane epori'matɨ' ɨyese' kon e'menukasa' pɨ' Epʉn po,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mɨrɨ a'tai, Sises uta'kwarʉ'tɨsa' Wakʉ A'kwarʉ ke esi pori' pe uya ta'pʉ, “Ayapurɨpɨtʉ uya, Papai, Epʉn mɨrɨ awonsi'kɨ non Epuru, apʉne pʉra serɨ ton onansa' auya pɨ' pu'kena' ton mɨrɨ awonsi'kɨ isenupasa' kon piyapai, mɨrɨpan enpoikasa' auya pɨ' aiko ton mʉre amʉ' ena'. Ewai', Papai, serɨ ku'sa' auya i'se ɨwe'to' awɨrɨ pori' pe ɨku'nin pe iyesi pɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","(Mɨrɨ ta tʉpo Papa pɨ', ka'pon amʉ' kanan auro'kakapʉ pɨ' iye'sara'tɨ'pʉ,) “Tanporon nɨ esi ukʉipʉnʉ nʉnonka'pʉ pe uyena'. Ɨnʉ' uya rɨ, imu i'tu pʉra iyesi, e'tane ikʉipʉnʉ uya rɨken i'tu. Ɨnʉ' uya rɨ ikʉipʉnʉ i'tu pʉra iyesi, e'tane imu uya rɨken i'tu, mɨrɨ awonsi'kɨ kamo, imu na'ne' e'to' ɨnenpoikapai itena' ton,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Mɨrɨpan era'tɨ'pʉ tʉpoitorʉ ton winɨkʉi', mɨrɨpan uya ta'pʉ to' pɨ' ama'ai, “Pori' pe en ton esi, menyatʉi'ne' ene pɨ' na'ne'. ");
INSERT INTO akeNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ekama uya ɨpɨ'nokon, tu'kan kon nɨ pu'kena' amʉ', kin amʉ' esi'pʉ menyatʉi'ne' ɨnenpai, e'tane to' uya ene'pʉ pen, mɨrɨ awonsi'kɨ metayatʉi'ne' ɨnetapai, e'tane to' uya eta'pʉ pen,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ipan pe Main i'tunin e'mʉ'sa'ka'pʉ Sises i'tupɨ'se. “Ti'sa, ɨ'rɨ kupʉ uya tɨwɨrɨ rɨ uko'manto' epoto' pe uya?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","“Ɨ'rɨ tukai' ken iye'menukasa' mɨrɨ pɨ' Main yau ekamanin ɨmɨrɨ? Nai kasa ken menyan?” tukai' Sises uya eikʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Sises eikʉ'pʉ iya, “‘Papa i'nʉnkakɨ tanporo ɨyewan pokon pe, aya'kwarʉ pokon pe, ɨmeruntɨrʉ pokon pe, ɨusenuminkato' pokon pe,’ mɨrɨ awonsi'kɨ, ‘Ɨtonpa nɨrɨ, mɨsi'nʉnkayai'ne' kasa,’ tasa' iya,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Iye'to' pe kuru ei'sa' auya man,” tukai' Sises uya eikʉ'pʉ. “Serɨ si iku'kɨ, mɨrɨ a'tai ɨuko'mamʉ rɨ tɨwɨrɨ rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","E'tane, wakʉ pe e'ku'pai tesi pɨ', Sises ekama'po'pʉ iya, “Ɨnʉ' ken si esi utonpa pe?” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Eikʉ pe, Sises uya ta'pʉ: “Ka'pon utɨ'pʉ Surusiran poi Iseri'ko pona, mɨrɨpan uya ama' amʉ' eporo'pʉ. Mɨrɨpan kon uya a'si'pʉ, mɨrɨpan kon uya iponkapɨtʉ'pʉ, to' uya iwɨpɨtʉ'pʉ, mɨrɨpan akamasa' nɨmɨ'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mɨrɨ tʉpo, use'man nɨto' tʉrawasomanin utɨ'pʉ mɨrɨ asanta tawɨrɨ. Ensa' tʉuya a'tai, entaka'pʉ iya iratoi poro. ");
INSERT INTO akeNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Mɨrɨ kasa rɨ marɨ, ite'ma'pʉ pe te'sen, itesen o'non esi'pʉ ensa' tʉuya a'tai, iratoi poro rɨ marɨ itɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","E'tane, Sameriya pon ka'pon uyee'pʉ iporo. Ensa' tʉuya a'tai, ipɨ' isentu'ma'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ipiya' itɨ'pʉ, mɨrɨpan uya iwɨpɨ'sa' rʉ'pʉ aku'nɨ'pʉ waain ke, mɨrɨ awonsi'kɨ karapa ke, mɨrɨpan ontɨ'pʉ iya. Mɨrɨpan anʉmʉ'pʉ iya tikʉn isa'ka'si pona, arɨ'pʉ iya patatʉse' ya', ipa'simato' pe tʉuya. ");
INSERT INTO akeNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mɨrɨ ema'sa' yau, asa'rɨ pʉrata pun tʉrʉ'pʉ iya patatʉse' esa' ena'. ‘Pʉse rɨ mʉpa'simai' se pʉrata ke. Enna'posa' a'tai, ipɨ' ɨnennoko'pʉ ɨpʉrataai na'po uya mɨrɨ,’ ta'pʉ iya,” ta'pʉ Sises uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Mɨrɨ ekama tʉpo, Sises uya ekama'po'pʉ, “Nai kʉrɨ ken si esi osorʉwawon kon apai ama' amʉ' eponin nʉ'pʉ tonpa pe tukai' mi'tuyan?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mɨrɨpan eikʉ'pʉ Main pɨ' enupanin uya, “Kʉrɨ ipɨ' isentu'masa' rʉ'pʉ,” ta'pʉ iya. Sises uya ta'pʉ ipɨ', “Iku'ta si kʉrɨ rɨ kasa,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Sises mɨrɨ awonsi'kɨ ipoitorʉ ton utɨ koro'tau, to' uyee'pʉ eke iwa pata ya'. Mɨrɨ pata yau, uri'san, Mata itese' uya Sises kɨ'ma'pʉ tiwʉ' ta'. ");
INSERT INTO akeNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Iyakon ese' esi'pʉ Meri. Mɨrɨpan ereutasa' esi'pʉ Sises piyau, tauro'kato' eta pɨ' iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","E'tane Mata usewankamato' esi'pʉ tanporon tʉnkupʉnʉ pɨ'. Iyee'pʉ Sises piya' ekama'pose, “Uyepuru, upɨ' pe' ɨusentu'ma pʉra rɨ iyesi, uyakon uya unɨnsa' pɨ' tikin sarɨ e'tʉrawasomato' pe? ‘Ipika'tɨta!’ ka'kɨ ipɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Sises uya eikʉ'pʉ, “Mata, tu'kan pɨ' rɨ sa'ne ɨusewankama, ");
INSERT INTO akeNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","e'tane tikin nan nɨ esi i'se e'nɨto'. Meri uya nin wakʉ kuru anʉnsa' mɨrɨ, mɨrɨpan emo'kato' oton pen ipiyapai,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sises esi'pʉ ɨpʉreman pɨ'. Mɨrɨpan e'nonkasa' a'tai, tikin nan ipoitorʉ uya ta'pʉ ipɨ', “Ina Epuru, ɨpʉreman eseru pɨ' ina enupakɨ, Isaan uya tʉpoitorʉ ton enupa'pʉ kasa,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ta'pʉ iya to' pɨ', “Ɨwɨpʉrema kon a'tai, se kasa mʉkatʉi': “‘Papai, tʉnamasen pe ɨyese' nesii. Ina esa' pe ɨwe'to' nʉyepʉi. ");
INSERT INTO akeNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Wʉi kaisa rɨ ina irepakɨ wʉi kaisa rɨ te'sen ina i'kiyari ke. ");
INSERT INTO akeNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ina makooi pɨ' ɨsentu'makɨ, apʉne pʉra ina nɨrɨ usentu'ma pɨ' ina pɨ' imakoitasa' kon pɨ'. Mɨrɨ awonsi'kɨ ina kʉsarɨi i'tupɨ'nɨto' ya'.’” ");
INSERT INTO akeNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Mɨrɨ tʉpo, ta'pʉ iya to' pɨ', “Iya'tai pʉra tʉtonpa ke ɨwesi a'tai, anomʉra' a'tai ɨutɨ itiwʉ' ta'. Ta auya ipɨ', ‘Osorʉwau pʉreti ke urepa', ");
INSERT INTO akeNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","apʉne pʉra utonpa pe te'sen uye'sa', e'tane inta'napato' uya ike pʉra iyesi.’ ");
INSERT INTO akeNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ɨutɨ tawon uya si amaimu eikʉ, ‘Uyanpokʉmai, mʉra'ta uta'kopɨ'ka'sa', mɨrɨ awonsi'kɨ umunkɨ amʉ' e'nʉnsa' nɨrɨ. Ɨrepase'na e'mʉ'sa'ka poken pʉra man,’ ta iya yau. ");
INSERT INTO akeNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ekama uya etatɨ', tʉtonpa pe ɨwesi pɨ' ɨrepase'na iye'mʉ'sa'ka pen e'tane, ɨyepiyɨtʉ pʉra ekama'popɨtʉ auya pɨ' ɨrepase'na iye'mʉ'sa'ka i'se ɨwe'to' ke. ");
INSERT INTO akeNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Mɨrɨ pɨ' ta uya ɨpɨ'nokon: Ekama'potɨ', mɨrɨ a'tai ɨyena'nokon nɨ iye'tʉrʉ; iwarinpatɨ', mɨrɨ a'tai eporo auya'nokon; mʉra'ta iwɨpɨ'tɨ', mɨrɨpan uta'kokato' pe ɨyena'nokon. ");
INSERT INTO akeNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Apʉne pʉra tanporon kon ekama'po pɨ' na'ne' nan uya eporo; kʉrɨ iwarinpa pɨ' na'ne' uya rɨ eporo; mɨrɨ awonsi'kɨ kʉrɨ iwɨpɨtʉ pɨ' na'ne' ena' rɨ mʉra'ta uta'koka. ");
INSERT INTO akeNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nai kʉrɨ warai ikʉipʉnʉ ton uya ɨmu uya moro' pɨ' ɨyekama'po yau, e'tane irepa ɨkʉi ke? ");
INSERT INTO akeNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Mɨrɨ pe pʉra, mɨnɨ' ke rɨ katɨ irepa iya kɨrɨtɨkɨ pʉmooi ekama'po tane iya? ");
INSERT INTO akeNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ɨmɨrɨ'nokon nin si ɨri ton uya i'tu yau wakʉ ton e'repan nɨto' ike ke ɨmunkɨ kon repa auya'nokon, mɨrɨ entai kuru ɨkʉipʉnʉ kon, Epʉn pon uya Wakʉ A'kwarʉ tʉrʉ kamoro ekama'ponin nan ena',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sises esi'pʉ ɨri a'kwarʉ enpa'ka pɨ' tʉusauro'sen pen ka'pon apai. Ɨri a'kwarʉ epa'ka'pʉ a'tai, tʉusauro'sen pe iyena'pʉ. Mɨrɨ pɨ' ka'pon amʉ' usewansiuka'pʉ ");
INSERT INTO akeNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","e'tane, tʉron kon uya ta'pʉ, “Pirɨsipupʉ, makoi amʉ' epuru winɨ makoi amʉ' enpa'kapɨtʉ iya mɨrɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Tʉron kon uya i'tupɨtʉ'pʉ tekama'popɨ'se i'tuto' Epʉn winon ku'to' pe iya. ");
INSERT INTO akeNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Sises uya to' usenuminkato' i'tusa' esi'pʉ, mɨrɨpan uya ta'pʉ to' pɨ', “Ti'tui' pʉra rɨ esa' wannɨ pe te'san epantakapɨ'sa' ɨsewa'nomai' uma'ta rɨ mɨrɨ, mɨrɨ awonsi'kɨ tiwʉ' tawon kon epantakapɨ'sa' ɨsewa'nomai' rɨ uta'mo'ka mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Se'tan epantakapɨtʉ pe iyesi yau tʉpokon pe rɨ ɨsewa'nomai', nai kasa esa' wannɨ pe iye'to' esi moro? Serɨ ta uya apʉne pʉra makoi a'kwarʉ ton enpa'kapɨtʉ uya Pirɨsipupʉ winɨ tukai' ɨye'kupʉ kon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Serɨ si makoi amʉ' enpa'ka uya pe iyesi yau Pirɨsipupʉ winɨ, ɨnʉ' winɨ ken si ɨpɨkɨron kon uya to' enpa'ka? Mɨrɨ wenai si ɨyeseru kon aimenkanin pe to' esi mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","E'tane, makoi amʉ' enpa'ka uya pe iyesi yau Papa meruntɨrʉ ke, mɨrɨ nin si Papa e'to' esa' wannɨ pe uye'sa' ɨpiya'nokon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Miyarɨ rɨ nin si Sises esi'pʉ to' enupa pɨ', “Pana'pan ka'pon esi a'tai tepaai ton ke esii'ma tiwʉ' erasu pe, itapuruui ton esi mɨrɨ wakʉ pe rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","E'tane, itentaino pana'pan ka'pon uye'sa' a'tai, itentai iyena mɨrɨ. Mɨrɨpan uya itamataai ton inapurɨnʉ pe te'sen mo'ka, mɨrɨpan uya itapuruui ton tʉneporo'pʉ pantakapɨtʉ tʉtonpa ton ena'. ");
INSERT INTO akeNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Kʉrɨ uya'kɨrɨ pʉra na'ne' esi uyewa'noma pɨ', kʉrɨ rɨ upokon pe amʉranʉkʉ iya pʉra na'ne' uya ai'pika. ");
INSERT INTO akeNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ɨri a'kwarʉ epa'kasa' a'tai ka'pon apai, itɨ siya rɨ a'mun pata yau tereutato' yau warinpa pɨ'. Mɨrɨpan eporo iya pʉra iyesi, mɨrɨ a'tai, ‘Enna'po serɨ ɨutɨ unnɨmɨ'pʉ ta',’ ta iya. ");
INSERT INTO akeNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Iye'sa' a'tai, ɨutɨ eporo iya wakʉ pe akorokasa' pe mɨrɨ awonsi'kɨ ikonekasa' pe. ");
INSERT INTO akeNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Mɨrɨ a'tai, itɨ 7 kaisaron kon ɨri ton kuru tentaino kon nepʉ iya. To' ewomʉ mɨrɨ yau ɨko'manse'na. Mɨrɨ a'tai, ipan pe, ɨri pe ka'pon esi wapiya tesi'pʉ entai,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Sises usaurokʉ koro'tau, uri'san uya ta'pʉ anpisin koro'tapai, “Pori' pe kuru asan man ɨpɨ'!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sises uya eikʉ'pʉ, “Mɨrɨ entai kuru kamoro Papa Maimu etanin nan, mɨrɨ awonsi'kɨ apurɨnin nan esi mɨrɨ pori' pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Anpisin pe ka'pon amʉ' epirikʉ koro'tau, Sises uya ta'pʉ, “Ɨri ton nɨ serɨ a'taino kon! Eke Papa tʉrawasooi i'tuto' ipɨkɨrɨ ekama'ponin nan e'tane, ikupʉ uya pen. Isona pɨ', i'tuto' ipɨkɨrɨ rʉ'pʉ rɨken kupʉ uya. ");
INSERT INTO akeNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Apʉne pʉra Isona esi'pʉ i'tuto' ipɨkɨrɨ pe Ninipa pon kon pona, mɨrɨ kasa rɨ marɨ Ka'pon, Papa winon esi mɨrɨ serɨ a'taino kon pona. ");
INSERT INTO akeNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kwin, wʉi enu uye'to' kamisi winon e'mʉ'sa'kato' oton eseru aimenka weyu a'tai serɨ a'taino kon pokon pe to' eno'ma pe; apʉne pʉra iye'sa' wenai non u'matʉ apai Saraman pu'ketʉ etase'na. Serɨ pe eke Saraman entaino man serɨ yau. ");
INSERT INTO akeNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ka'pon amʉ' Ninipa pon kon e'mʉ'sa'kato' oton eseru aimenka weyu a'tai serɨ a'taino kon pokon pe to' eno'ma pe; apʉne pʉra to' era'tɨ'pʉ tʉmakooi kon apai Isona uya itekare ekama pɨ'. Serɨ pe eke Isona entaino man serɨ yau. ");
INSERT INTO akeNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ɨnʉ' uya rɨ raan'pu po'tɨ pʉra iyesi onansa' pe iye'to' ya' itʉto' pe tʉuya, mɨrɨ pe pʉra pʉsau o'koi'. E'tane ru'ku, itapon pona itʉrʉ iya kamo tewonsan uya iweyu ene poken. ");
INSERT INTO akeNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ɨyenu kon esi ɨpun kon raan'puui pe. Wakʉ pe ɨyenu kon esi a'tai, tanporo ɨpun kon esi a'kwa pe. E'tane ɨri pe iyesi a'tai, ɨpun kon nɨ nɨrɨ esi ewarupɨ pe. ");
INSERT INTO akeNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Mɨrɨ pɨ' tense, ka'pon e'to'ka'nʉ'to' pe iyesi wakʉ pe pe' tesi tukai', ɨri pe katɨ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Wakʉ pe te'sen to'ka'nʉ'sa' ka'pon uya a'tai, ɨri kupʉ iya pen. Mɨrɨ na'ne' kasa nin si, wakʉ pe ɨnkupʉnʉ kon, weyu uya ɨwei'tɨ kon kasa rɨ,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Sises usaurokʉ e'nonka tʉpo, tikin nan Pari'si uya ikɨ'ma'pʉ ata're'tɨi'. Mɨrɨpan ewomʉ'pʉ, mɨrɨpan ena'pʉ tʉteire' po tepʉrʉ piyau. ");
INSERT INTO akeNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","E'tane Pari'si usewansiuka'pʉ, apʉne pʉra temiyatʉ korʉkasa' Sises uya pʉra iyesi pɨ' tʉuta're'tɨ wapiya, teseru kon yau. ");
INSERT INTO akeNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mɨrɨ a'tai, Itepuru uya ta'pʉ ipɨ', “Ɨmɨrɨ'nokon Pari'si amʉ' uya a'sawʉ kon mɨrɨ awonsi'kɨ aparapii kon korʉka iya'poi pɨ' rɨken, e'tane iyau eke pe rɨ mentai e'nɨto' ɨri pe e'nɨto' esi ayau'nokon. ");
INSERT INTO akeNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ɨmɨrɨ'nokon iya'kwarʉ pʉnon ka'pon amʉ'! Kʉrɨ pe' iya'poi pɨ' ika'nin nʉ'pʉ uya rɨ marɨ pe' iyawon kapʉ pen? ");
INSERT INTO akeNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","E'tane nin aparapii kon yawon itʉtɨ' entu'manin nan ena', mɨrɨpan tanporon nɨ nin si esi mɨrɨ wakʉ pe ɨiwano' kon pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ɨsɨ sɨ, Pari'si amʉ', apʉne pʉra Papa ena' 1/10 kaisa rɨ min, ru mɨrɨ awonsi'kɨ ti'tui' pʉra rɨ amainarʉ kon yawon ɨi'kiyari kon isu tʉrʉ auya'nokon, e'tane ɨsi'kaisa rɨ ka'pon ku'to' mɨrɨ awonsi'kɨ Papa uya i'nʉnkan nɨto' eno'ma auya'nokon. Emen iwa pe na'ne' kupʉ pɨ' ɨwesi'pʉ kon nesii'no iwapiyaro' tʉnonkai' pʉra ikupʉ pʉra. ");
INSERT INTO akeNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Papa uya ɨkota'ma kon mɨrɨ ipan pe rɨ, Pari'si amʉ', apʉne pʉra eke ton apon po ɨyereutapɨ'pɨtʉ kon i'nʉnka auya'nokon pɨ' Esuwerʉ amʉ' usenupato' iwʉ' tau, mɨrɨ awonsi'kɨ ka'pon amʉ' uya, ‘Miyarɨ,’ ta i'se ɨwesi kon ɨpɨ'nokon kʉrʉpo'po pɨ' e'nɨ pata'se' yau. ");
INSERT INTO akeNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Ɨsɨ sɨ, apʉne pʉra ima'kʉmasa' pen uruwai' kasa ɨwesi kon, ka'pon amʉ' usato' ipʉro'poro i'tui'ma pʉra,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Main pɨ' enupanin nan tonpa uya eikʉ'pʉ, “Ti'sa, serɨ tasa' auya a'tai, ina piyɨ'nʉ'pɨ'pɨtʉ auya,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Sises uya eikʉ'pʉ, “Ɨmɨrɨ'nokon, Main pɨ' enupanin nan, Papa uya ɨkota'ma kon mɨrɨ ipan pe, apʉne pʉra ka'pon amʉ' apiyo'masa' auya'nokon sa'man nɨ ku'to' pe to' uya Papa Maimu serɨ tukai', mɨrɨpan kon pika'tɨ auya'nokon pʉra iyesi ikupʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Ɨsɨ sɨ, apʉne pʉra pu'kena' amʉ' uruwasii oton tɨ' akapɨtʉ'pʉ auya'nokon, mɨrɨpan atamokori kon amʉ' uya to' tʉ'ka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ɨusekama kon atamokori kon nʉkupʉ'pʉ pɨ' i'napairon ta auya'nokon; pu'kena' amʉ' tʉ'ka'pʉ to' uya, mɨrɨpan to' uruwasii oton tɨ' akapɨtʉ'pʉ auya'nokon. ");
INSERT INTO akeNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Mɨrɨ wenai, pena rɨ Papa uya tʉpu'ketʉ yau ta'pʉ, ‘Pu'kena' amʉ' mɨrɨ awonsi'kɨ itekare ekamanin nan ennoko uya mɨrɨ. Tʉron kon tʉ'kato' oton to' uya, mɨrɨ awonsi'kɨ tʉron kon kota'mato' oton to' uya.’ ");
INSERT INTO akeNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Mɨrɨ pe iyesi pɨ', serɨ a'taino kon e'to' oton pu'kena' amʉ' mʉnʉ esa' pe itɨsa' rʉ'pʉ orʉ epiya'tɨ'pʉ si'kɨrɨ, ");
INSERT INTO akeNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Eperʉ mʉnʉ awonsi'kɨ Sakaraya mʉnʉ pʉ'kʉ pona iwɨsa' rʉ'pʉ Papa ena' use'man nɨto' apon mɨrɨ awonsi'kɨ ɨpʉreman nɨto' iwʉ' ka'sanau. Ewai', ekama uya, serɨ a'taino kon e'to' oton tanporo serɨ esa' pe. ");
INSERT INTO akeNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ɨsɨ sɨ, ipan pe main i'tunin nan, apʉne pʉra i'tunin pe e'nɨto' kii mo'kasa' auya'nokon pɨ'. Ɨmɨrɨ'nokon nɨ epa'kasa' pʉra iyesi, mɨrɨ awonsi'kɨ tepa'kasan wa'kʉ'pɨtʉ auya'nokon,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Mɨrɨ tʉpo, Pari'si pata'se' apai Sises enna'po'pʉ. Mɨrɨ si'kɨrɨ rɨ, Pari'si amʉ' mɨrɨ awonsi'kɨ Main pɨ' enupanin nan ena'pʉ iteyaton pe. Mɨrɨpan ekama'popɨtʉ'pʉ to' uya sa'man ton pɨ' rɨ, ");
INSERT INTO akeNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","a'sito' tʉuya'nokon ipɨkɨrɨ oton nɨ imaimu eta i'se to' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mɨrɨ koro'tau, anpisin pe ka'pon amʉ' amʉra'pʉ. Tu'ke ka'pon amʉ' esi'pʉ, tʉtonpa kon nɨ tʉwasa'pɨ'se. Wapiya tʉpoitorʉ ton auro'kapɨ' Sises e'sara'tɨ'pʉ: “Te'mainanpai' e'tɨ', Pari'si amʉ' uya pʉrowa a'sarutanʉ'to' ike namai', wakʉ pe to' e'ku'to'. ");
INSERT INTO akeNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ɨ'rɨ pʉra rɨ iyesi mɨrɨ iwapu'tɨsa' te'nɨponkasen pen, mɨrɨ pe pʉra onansa' i'tu pʉra te'sen. ");
INSERT INTO akeNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ewarupɨ yau ausaurokʉ'pʉ usetato' oton wʉi nai, mɨrɨ awonsi'kɨ pana ya' ɨyetarerumʉ'pʉ i'nau ɨiwʉ' tau usekamato' oton ɨutɨ nakapu ponsi'kɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Apana'tɨ uya 'nokon, utonpa ton, ɨpun kon wɨnin nan pɨ' kenari'nʉntʉu, mɨrɨ tʉpo ɨ'rɨ kupʉ to' uya pʉra iyesi. ");
INSERT INTO akeNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","E'tane ekama uya ɨpɨ'nokon kʉrɨ rɨ ɨyenari'nʉnto' kon ipɨ'. Kʉrɨ rɨ pɨ' rɨken enari'nʉntɨ', ama'tanʉkʉ tʉpo, a'kwarʉ wannɨ kuru rɨ eno'manin kʉrɨ rɨ, ekota'man nɨto' ya'. Ewai', apana'tɨ uya 'nokon, kʉrɨ rɨ rɨken pɨ' enari'nʉntɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“5 kaisaron kon pe' toron amʉ' tʉkʉrʉpo'pomasan pen asa'ron pʉrata pun kaisa rɨ? E'tane tikin nan nɨ to' tonpa pu'tɨka'nʉkʉ Papa uya pʉra iyesi. ");
INSERT INTO akeNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","I'napai rɨ, a'pai kon i'po' rɨ esi tanporo i'tusa' pe. Kenari'nʉntʉu, i'nʉnkena' ton ɨmɨrɨ'nokon tu'kan kon toron amʉ' entaino kon,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Apana'tɨ uya 'nokon, ɨnʉ' uya rɨ uyekama a'tai, i'nai rɨ iyesi tukai' ka'pon amʉ' pɨ', Ka'pon, Papa winon uya ekamato' oton i'nai rɨ iyesi tukai' Papa inserʉʉi ton pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","E'tane ɨnʉ' rɨ unurunpayai'ne' ka'pon amʉ' rau nurunpato' oton Papa inserʉʉi ton rau. ");
INSERT INTO akeNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Tanporon kon tʉusauro'san isapema pe Ka'pon, Papa winon pɨ' rɨ usentu'man, e'tane ɨnʉ' rɨ tʉusauro'sen esi a'tai, Wakʉ A'kwarʉ sapema pe pɨ', Papa usentu'man pen nɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Usenupan nɨto' iwʉ', esa' wannɨ ton mɨrɨ awonsi'kɨ eke ton rakʉi' to' uya ɨne'sa' kon a'tai, kɨsewankamatʉu, nai kasa e'wapu'tɨ mɨrɨ pe pʉra ɨ'rɨ ta uya, tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Papa A'kwarʉ uya amaimu ke ɨrepa mɨrɨ, mɨrɨ a'tai,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tu'kan kon ka'pon amʉ' koro'tawon uya ta'pʉ Sises pɨ', “Ti'sa, urui pɨ' ekamakɨ urepato' pe iya a'sa'mʉyai ina kʉipʉnʉ apuruui rʉ'pʉ ke,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Sises uya eikʉ'pʉ, “Utʉrawasooi pen nɨ mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mɨrɨpan a'tai, ta'pʉ iya tu'kan kon pɨ', “Ti'tui' e'tɨ'! Mentai pʉra e'tɨ'! Ka'pon uko'mamʉ pʉra rɨ iyesi serɨ non po inke pori' pe tanporon esa' pe tesi pɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Sises uya panton ke to' auro'ka'pʉ to' enupanin pe, “Tapiyara ka'pon esi'pʉ, eke imainarʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mɨrɨpan usenuminka'pʉ, ‘Ɨ'rɨ kupʉ uya serɨ?’ tukai'. ‘Ui'kiyari amʉranʉ'to' uya ya' pʉra iyesi.’ ");
INSERT INTO akeNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mɨrɨ a'tai ta'pʉ iya, ‘Serɨ kupʉ uya; uyapuruui iwʉ' tʉrʉ'kwa uya serɨ. Eke pe parɨ amɨto' pe uya. Mɨrɨ yau si ui'kiyari mɨrɨ tʉpo uyapuruui amʉranʉ'to' pe uya. ");
INSERT INTO akeNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mɨrɨ a'tai si ta uya mɨrɨ, Tu'kan nɨ amʉranʉ'sa' uya mɨrɨ uko'manʉ'nin pe. E'tʉrawasoma pen nin si serɨ tʉpo. Enta'na, ensi uya, pori' pe uko'mamʉ!’ ");
INSERT INTO akeNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“E'tane, Papa uya ta'pʉ ipɨ', ‘Pu' pʉn! Serɨ ewarupɨ nau auma'tato' oton. E'tane si tiwano' pe, ɨiwano' pe ɨnkupʉ'pʉ epoto' oton tʉron nɨ uya,’ ta'pʉ Papa uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Serɨ na'ne' kasa si te'ton kon ka'pon amʉ' mentaino kon pe to' esi a'tai, apʉne pʉra Papa e'to' i'se kupʉ to' uya pʉra iyesi pɨ',” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Mɨrɨ a'tai Sises uya ta'pʉ tʉpoitorʉ ton pɨ', “Mɨrɨ pe iyesi pɨ' ekama uya serɨ ɨpɨ'nokon, ɨuko'manto' kon pɨ' rɨ kɨsewankamatʉu, ɨ'rɨ pɨ' enta'nato' pe, mɨrɨ pe pʉra ɨpun kon pɨ' rɨ, ɨ'rɨ esi upon pe, tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Uko'man nɨto' esi kiyari entai, mɨrɨ awonsi'kɨ pun wannɨ, pon entai. ");
INSERT INTO akeNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Toron amʉ' pɨ' ɨsenupatɨ': Te'pɨnsan pen, kiyari akʉ'pʉsa' amʉranʉ'nin nan pen, to' i'kiyari pata'se' pʉnon kon nɨ; e'tane Papa uya to' ewekʉ. Mɨrɨ entai i'nʉnkena' pe ɨwesi kon mɨrɨ toron amʉ' entai! ");
INSERT INTO akeNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ɨnʉ' uya rɨ tʉuko'manto' ɨnka miyarɨ parɨ, ipɨ' tʉusewankamai'? ");
INSERT INTO akeNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Sepa' nan kupʉ auya'nokon poken pʉra iye'tane, ɨ'rɨ pɨ' ken si tʉron nɨ ton pɨ' ɨusewankama kon? ");
INSERT INTO akeNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Pata ipʉrʉ ton a'ta pɨ' ɨsenupatɨ': Te'tʉrawasomasan pen, mɨrɨ pe pʉra ɨ'pɨ'nin nan pen. Mɨrɨ rɨ e'tane, ekama uya serɨ ɨpɨ'nokon, Saraman imaminkena' epontɨsa' pʉra iyesi'pʉ mɨrɨ ton kasa. ");
INSERT INTO akeNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Mɨrɨ kasa Papa uya wana' rɨ pontɨ pe iyesi yau, wana' serɨ pe na'ne' mɨrɨ awonsi'kɨ awanapairɨ eno'ma apo' ya', mɨrɨ entai rɨ ɨpontɨ iya 'nokon. Aiko sɨ, aiko pe rʉ'kwɨ apurɨto' auya'nokon esi! ");
INSERT INTO akeNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Mɨrɨ awonsi'kɨ ɨyewan kon tʉnonkai' pʉra e'tɨ' ɨnɨkunʉ mɨrɨ awonsi'kɨ ɨnensinʉ kon pɨ'; ipɨ' kɨsewankamatʉu. ");
INSERT INTO akeNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Apʉne pʉra Papa i'tunin nan pen e'to' ipɨkɨrɨ pe tanporo serɨ warai'nan esi, mɨrɨpan ɨkʉipʉnʉ kon uya i'tu serɨ ton i'se ɨwesi kon. ");
INSERT INTO akeNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","E'tane, esa' wannɨ pe iye'to' iwarinpatɨ', mɨrɨ awonsi'kɨ serɨ ton nɨ nin si e'tʉrʉ mɨrɨ ɨyena'nokon nɨ nɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Tu'ke pʉra rɨ esii'ma, enari'ke' pe pʉra e'tɨ', apʉne pʉra ɨkʉipʉnʉ kon man pori' pe itesa' pe rɨ marɨ ɨwesi kon pa ɨrepa kon tʉuya pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ayapuruui kon ikʉrʉpo'pomatɨ', entu'manin nan repa kon pa. Ɨpʉrataai kon yen ɨnepotɨ' ipooi'pɨ pe tenasen pen, mamin, Epʉn po na'ne' tʉu'ma'sen pen. Mɨrɨ yau ama' uyepʉ pʉra iyesi a'ko pe, mɨrɨ awonsi'kɨ ɨrʉkanin uya ima'tanʉkʉ pʉra rɨ iyesi. ");
INSERT INTO akeNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Apʉne pʉra, ɨimamin kon e'to' airɨ, mɨrɨ yau ɨyewan kon nɨ nɨrɨ e'to' oton,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Miyarɨ rɨ to' enupa'pʉ iya se kasa, “Iyekonekasa' pe e'tɨ', Papa tʉrawasooi ku'nin pe inke rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Iyapiyo' ton esi tepuru kon enupɨkɨrɨ kasa e'tɨ'. Iye'sa' a'tai, mʉra'ta wɨpɨtʉ iya a'tai, inke pʉra to' uya a'koka iyewonto' pe. ");
INSERT INTO akeNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pori' pe to' esi mɨrɨ itenupɨkɨrɨ te'san. I'napairon ekama uya ɨpɨ'nokon, iyepontɨ mɨrɨ to' mʉta'napato' pe tʉuya, tepʉrʉ piyau tʉteire' kon po to' enato' pe to' kupʉ iya, mɨrɨpan kon enta'na enupɨkɨrɨ iyesi. ");
INSERT INTO akeNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Wakʉ pe kuru iyesi mɨrɨ kamoro iyapiyo' ton itenupɨkɨrɨ te'san, ɨ'rɨ pe pʉra rɨ ewarupɨ nau rɨ iye'tane. ");
INSERT INTO akeNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","E'tane, se ito'ka'nʉ'tɨ': Ɨutɨ esa' uya ama' uyepʉ i'tusa' yau, tiwʉ' ta' ewon nɨ kuu'pʉ iya nesii'no pen. ");
INSERT INTO akeNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ɨmɨrɨ'nokon nɨrɨ, tekonekai' me'tʉi', apʉne pʉra Ka'pon, Papa winon uye'to' oton itenupɨkɨrɨ pʉra rɨ ɨwe'tane'nokon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pi'ta uya Sises ekama'po'pʉ, “Uyepuru, ina rɨken pe' pana ya' serɨ panton ekama auya, mɨrɨ pe pʉra tanporon kon pɨ' rɨ katɨ?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Itepuru uya eikʉ'pʉ, “Ɨnʉ' ken usauro'nɨ'pʉ awɨron mɨrɨ awonsi'kɨ emiya'pokena' tʉtonpa esa' e' pe nai? Itesa' nʉnonkanʉ tʉpoitorʉ ton esa' pe to' i'kiyari epe' ke to' repanin pe itʉto' weyu a'tai? ");
INSERT INTO akeNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Wakʉ pe rɨ kʉrɨ rɨ ipoitorʉ e'to' oton itepuru neporonʉ mɨrɨ kupʉ pɨ' tenna'po a'tai. ");
INSERT INTO akeNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","I'napairon ekama uya ɨpɨ'nokon, itepuru uya tanporon tapuruui esa' pe iku'to' oton. ");
INSERT INTO akeNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","E'tane si iya'tai pʉra kʉrɨ rɨ ipoitorʉ uya ta pe iyesi yau, ‘Uyepuru nʉko'manyan inke rɨ, iyepʉ pʉra,’ ta iya yau, mɨrɨpan e'sara'tɨ warawo' amʉ', uri'sami'si amʉ' ipoitorʉ ton panta'ma pɨ' mɨrɨ awonsi'kɨ enta'nan pɨ', ensi pɨ', mɨrɨ awonsi'kɨ e'taripan pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kʉrɨ rɨ ipoitorʉ epuru uye'to' oton wʉi a'tai itenupɨkɨrɨ iye'tane pʉra, mɨrɨ a'kʉra' iyepʉ ta tane iya pʉra rɨ, mɨrɨpan uya ipɨrʉkato' oton mɨrɨ awonsi'kɨ inonkato' iya oton apurɨnin nan pen pata'se' ya'. ");
INSERT INTO akeNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Kʉrɨ rɨ ipoitorʉ epuru e'to' i'se i'tunin e'tane tekonekasen pen, tepuru tʉrawasooi ku'nin pen nɨrɨ, mɨrɨpan kota'mato' oton itepuru uya ipan pe kuru. ");
INSERT INTO akeNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","E'tane kʉrɨ rɨ i'tunin pen tepuru e'to' i'se, mɨrɨpan uya ɨri kupʉ, mara rʉ'kwɨ itepuru uya ikota'mato' oton. Kʉrɨ rɨ eke pe Papa uya irepasa' na'ne' winɨ eke pe iwarinpa iya. Kʉrɨ rɨ nɨrɨ Papa uya irepasa' na'ne' itemiya'porʉ ke, eke pe kuru tʉrawaso ku'to' iya ike ke winɨ, ekama'poto' oton eke pe kuru itʉrawasooi rʉ'pʉ pɨ',” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Miyarɨ rɨ marɨ Sises esi'pʉ to' enupa pɨ' se kasa: “Apo' ne'sa' uya serɨ non pona, epo'tɨn pɨ' iye'sara'tɨka'sa' i'se e'ai'. ");
INSERT INTO akeNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Uma'tanʉ'to' ya' utɨ pe man, e'tane e'ne' pe kuru ukupʉ iya serɨ iu'matʉ pʉ'kʉ pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Tʉusewankamai' pʉra pe' e'nɨto' ne'sa' uya pe ekama auya'nokon serɨ non pona? Tʉusewankamai' pʉra e'nɨto' ne'sa' uya pen, e'tane epantakapɨ'nɨto' nin. ");
INSERT INTO akeNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Serɨ awonsi'kɨ, 5 kaisaron kon ka'pon amʉ' e'to' oton ɨsitonpa pe usewa'noman pɨ'; osorʉwawon kon asa'ron kon ewa'noma pɨ', asa'ron kon osorʉwawon kon ewa'noma pɨ' nɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","To' epantakapɨ'sa' e'to' oton; ikʉipʉnʉ tʉmu ewa'noma pɨ', imu tʉkʉipʉnʉ ewa'noma pɨ', isan uri'san tʉmʉre ewa'noma pɨ', imʉre uri'san tʉsan ewa'noma pɨ', itewo'pʉ tʉpa'se ewa'noma pɨ', mɨrɨ awonsi'kɨ ipa'se tewo'pʉ ewa'noma pɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Anpisin pɨ' ta'pʉ iya, “Kapuru' enuku ene auya'nokon a'tai, wʉi enu utɨ winɨ, inke pʉra, tuna uyepʉ tukai' i'tu auya'nokon, mɨrɨ koro'tau iye'kapʉ rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Wʉi enu enuku kamisi winɨ pese'tɨ uyepʉ a'tai, i'tu auya'nokon, a'ne' pe wʉi uyepʉ tukai', mɨrɨpan esi a'ne' pe rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Wakʉ pe te'ku'san! I'tu auya'nokon non mɨrɨ awonsi'kɨ ka' winɨ rɨ ɨ'rɨ rɨ enpoikanin pe ɨwesi kon. Ɨ'rɨ pe ken si iyesi pɨ' serɨ pe iweyu na'ne' enpoika i'tu auya'nokon pʉra iyesi? ");
INSERT INTO akeNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ɨ'rɨ pe iyesi pɨ' wakʉ eseru ɨnto'ka'nʉ'pai pʉra ɨwesi kon ɨiwano' kon pe? ");
INSERT INTO akeNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ɨutɨ kon koro'tau ɨyeyaton a'kɨrɨ a'sinin itepuru piya', ipan pe ɨsi'tukɨ ekoneka i'se ipokon pe, aya'kwarʉka iya rawɨrɨ a'sinin itepuru ena', ɨtʉrʉ iya mɨrɨ pʉresiman ena', mɨrɨpan uya ɨyeno'ma pariki'si ta'. ");
INSERT INTO akeNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ekama uya, ɨyepa'kato' oton kon pen nɨ tanporo ɨne'manʉ kon i'ma'ka auya'nokon pʉ'kʉ pona rɨ,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Moron kon uya Sises pana'tɨ'pʉ Kiyarari pon kon pɨ' Paire' nʉsuma'san imʉnʉ pɨ' to' use'mato' pokon pe. ");
INSERT INTO akeNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mɨrɨ a'tai, Sises uya ta'pʉ, “Serɨ kasa to' uma'tasa' pɨ' ɨri ton pe kuru to' esi'pʉ pe kʉsekamatʉu. ");
INSERT INTO akeNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kane, ta uya, ɨyera'tɨ kon pʉra iyesi yau amakooi kon apai, ɨmɨrɨ'nokon nɨ nɨrɨ uma'ta mɨrɨ to' kasa rɨ marɨ ɨwesi kon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Mɨrɨ pe pʉra 18 kaisaron kon iyeri'sa' kon Sairon pon ka'ta' amɨsa' ɨutɨ uta'mo'kasa' a'tai tʉpona'nokon. Surusiran pon kon entai kuru pe' ɨri pe to' esi'pʉ pe ekama auya'nokon, mɨrɨ wenai to' e'wɨnɨ'pʉ na'ne'? ");
INSERT INTO akeNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kane, ta uya, ɨyera'tɨ kon pʉra iyesi yau amakooi kon apai, ɨmɨrɨ'nokon nɨ nɨrɨ uma'ta mɨrɨ to' kasa rɨ marɨ ɨwesi kon pɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mɨrɨpan uya se panton ekama'pʉ, “Ka'pon esi'pʉ pi' e' esa'. Mɨrɨpan utɨpɨtʉ'pʉ iteperu ense e'tane, eporo iya pʉra iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mɨrɨ a'tai, ta'pʉ iya tʉmainarʉ esa' pɨ', ‘Osorʉwau wʉipiya e'to' airɨ utɨpɨ'sa' man ui'kiyari epetasa' ene i'se e'tane, eporo uya pʉra rɨ iye'sa'. A'tɨkɨ! Ɨ'rɨto' pe non iwanʉ'ka iya nesii'no?’ ");
INSERT INTO akeNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mɨrɨpan eikʉ'pʉ imainarʉ esa' uya, ‘Tɨwɨ tikin nɨ rɨken wʉipiya isi'tuka'to' pe nesii. Iwoi aka uya, mɨrɨpan epetanʉ'nin ke iu'na'tɨto' pe uya. ");
INSERT INTO akeNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Iyepetasa' pe iyesi yau, wakʉ pe nin si iyesi mɨrɨ; mɨrɨ pʉra iyesi yau, a'tɨto' pe rɨ nin si,’ ta'pʉ iya,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sapa' a'tai, Sises esi'pʉ ka'pon amʉ' enupa pɨ' Esuwerʉ amʉ' usenupato' iwʉ' tau. ");
INSERT INTO akeNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mɨrɨpan yau uri'san esi'pʉ tɨmuipan, ɨri a'kwarʉ nʉtɨmuika'pʉ 18 kaisa rɨ wʉipiya iko'mansa'. Ipan pe iye'tɨmuikasa' to'sa rɨ iyena pʉra. ");
INSERT INTO akeNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Sises uya ensa' a'tai, ikɨ'ma'pʉ iya tʉpiya'. Mɨrɨpan uya ta'pʉ ipɨ', “Ma'non, ɨyeparan apai ɨmo'ka uya serɨ.” ");
INSERT INTO akeNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Mɨrɨ a'tai, temiyatʉ tʉrʉ'pʉ iya ipona, mɨrɨ a'tai rɨ nin si, to'sa rɨ iyena'pʉ mɨrɨ. Mɨrɨpan uya Papa apurɨpɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sises uya ka'pon epi'tɨsa' pɨ' Sapa' a'tai, tʉusakorota pe Esuwerʉ amʉ' usenupato' iwʉ' epuru uya ta'pʉ ka'pon amʉ' pɨ', “6 kaisa rɨ moro wʉi esi mɨrɨ e'tʉrawasoman weyu. Mɨrɨ ton weyu a'tai, ɨsepi'tɨi' ɨsi'tɨ', Sapa' a'tai pen,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Sises uya eikʉ'pʉ, “Ɨmɨrɨ'nokon wakʉ pe te'ku'san! Sapa' a'tai pe' ɨikʉn kon paka, isa'ka'si rɨ eukanin nan pen ɨmɨrɨ'nokon iten apai tuna ensise'na arɨ kon pa? ");
INSERT INTO akeNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pʉse rɨ ken pe' si uri'san Epʉra'an pa rʉ'pʉ, Se'tan newa'tɨ'pʉ 18 kaisa rɨ wʉipiya euka pen ken pe' si Sapa' a'tai?” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Serɨ ta iya a'tai, tanporo iteyaton non ɨpiyɨtʉ'pʉ, e'tane ka'pon amʉ' epori'ma'pʉ tanporon wakʉ ton inkupʉnʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Mɨrɨ a'tai, Sises uya ekama'po'pʉ, “Ɨ'rɨ kasa Papa e'to' esa' wannɨ pe esi? Ɨ'rɨ pɨ' mɨrɨ kasa iyesi tukai' ekama uya? ");
INSERT INTO akeNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mosta' ena'pɨ kasa iyesi, ka'pon nʉpɨmɨnʉ tʉmainarʉ yau. Iya'ta, mɨrɨpan ena eke pe, mɨrɨpan panta po toron amʉ' esi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ekama'pokaa'pʉ iya kanan, “Ɨ'rɨ pɨ' mɨrɨ kasa Papa e'to' esa' wannɨ pe esi ta uya? ");
INSERT INTO akeNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pʉrowa a'sarutanʉ'nin kasa iyesi, uri'san nanʉmʉnʉ, mɨrɨpan uya pʉrowa pokon pe eke pe iki'ma tanporo ipun yau iyena pʉ'kʉ pona,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Mɨrɨ a'tai, Sises utɨ esi'pʉ eke iwa ton pata awɨrɨ'ne rɨ, Surusiran pona tʉutɨi'ma rɨ, ka'pon amʉ' enupa pɨ' iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ka'pon uya ekama'po'pʉ, “Uyepuru, tu'kan kon pen nɨ si ka'pon amʉ' pika'tɨto' oton Papa uya to' ato' pe tʉuya Epʉn pona?” ta'pʉ iya. Sises uya ta'pʉ to' pɨ', ");
INSERT INTO akeNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ɨsi'tutɨ' kuru rɨ aiko rʉ'kwɨ mʉra'ta awɨrɨ ewon nɨ pɨ', ekama uya ɨpɨ'nokon, apʉne pʉra tu'kan kon usi'tuto' oton ewomʉ i'se, e'tane to' ewonto' oton pen. ");
INSERT INTO akeNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mɨrɨ a'tai si, ɨutɨ esa' e'mʉ'sa'ka, mɨrɨpan uya mʉra'ta a'koro, pʉroroi po ɨye'soto'kasa' esii'ma mʉra'ta wɨpɨtʉ auya'nokon ipan pe ekama'po pe, ‘Ina epuru, mʉra'ta a'kokakɨ ina iwano' pe,’ mɨrɨ e'tane, ɨyeikʉ iya 'nokon, ‘Ɨi'tu uya 'nokon pʉra man, mɨrɨ pe pʉra mɨrɨ winɨ ɨuye'sa' kon ta uya pʉra rɨ iyesi,’ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mɨrɨ a'tai nin si, ‘Ɨpokon pe sa'ne ina nʉta're'tɨtai ko, mɨrɨ awonsi'kɨ ka'pon amʉ' menupatai ko ina e'ma tau'ne.’ ");
INSERT INTO akeNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mɨrɨpan e'tane, ɨyeikʉ iya 'nokon, ‘Ɨi'tu uya 'nokon pʉra man, mɨrɨ pe pʉra mɨrɨ winon kon uye'sa' ta uya pʉra rɨ iyesi. Entantɨ' upiyapai, tanporo ɨmɨrɨ'nokon ɨri ku'nin nan!’ tato' iya oton. ");
INSERT INTO akeNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Mɨrɨ yau, ukaran nɨto' oton mɨrɨ awonsi'kɨ ɨ e'kɨtɨtɨi'mato' oton, Epʉra'an, Aisi', Seko' mɨrɨ awonsi'kɨ pu'kena' amʉ' ene auya'nokon a'tai, Papa e'to' esa' wannɨ pe yau, ɨyeno'masa' kon e'tane. ");
INSERT INTO akeNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ka'pon amʉ' uye'to' oton wʉi enu uyepʉ winɨ, wʉi enu utɨ winɨ, wʉi enu enwo'netʉ winɨ, wʉi enu kamisi winɨ, mɨrɨpan kon ereutato' oton enta'nan pɨ' Papa e'to' esa' wannɨ pe yau. ");
INSERT INTO akeNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","I'napai rɨ, kamoro iu'matʉ pe na'ne' nan wapiya te'ton kon, mɨrɨ awonsi'kɨ wapiya na'ne' nan iu'matʉ pe te'ton kon,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mɨrɨ a'tai, Pari'si amʉ' uyee'pʉ Sises piya', mɨrɨpan kon uya ta'pʉ ipɨ', “Serɨ apai tʉron nɨ airɨ enta, Era' e'kaman pɨ' man ɨwɨnɨ pɨ',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Mɨrɨpan kon eikʉ'pʉ iya, “Kʉrɨ rɨ pata ennakanin ipana'tɨtantɨ' unkupʉnʉ pɨ': ‘Ɨri a'kwarʉ ton enpa'ka pɨ' esi, mɨrɨ awonsi'kɨ ka'pon amʉ' epi'tɨ pɨ' esi, serɨ pe, awanapai rɨ nɨrɨ, mɨrɨ ema'sa' yau'ne rɨ nin si utʉrawasooi u'ma'sa' pe iyesi mɨrɨ.’ ");
INSERT INTO akeNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Mɨrɨ koro'tau rɨ nin si, utɨ rɨ, serɨ pe, awanapai rɨ, mɨrɨ ema'sa' yau, Surusiran pona. I'napai rɨ iyesi, ɨnʉ' rɨ pu'kena' wɨto' pʉra iyesi mɨrɨ mɨ airɨ rɨ e'tane Surusiran po rɨken. ");
INSERT INTO akeNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Aiko sɨ, Surusiran pon kon, Surusiran pon kon! Ɨmɨrɨ'nokon, pu'kena' amʉ' tʉ'kanin nʉ'san, ɨpiya'nokon Papa nennoko'san wɨpɨ'nin nʉ'san tɨ' ke. Inke rɨ sa'ne ɨmunkɨ amʉ' amʉranʉkʉ i'se esi'pʉ, kɨrɨtɨkɨ uya tʉmunkɨ amʉranʉkʉ kasa tapiri o'koi', e'tane ikupʉ uya i'se pʉra ɨwesi'pʉ kon. ");
INSERT INTO akeNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Apʉne si entɨ', ɨiwʉ' kon e'nonkasa' ɨyena'nokon yawon pʉra. Ekama uya ɨpɨ'nokon, uyento' auya'nokon oton pen nɨ kanan serɨ enta', ‘Pori' pe rɨ kʉrɨ rɨ nʉye'ai'ne' Itepuru ese' yau esi,’ ta auya'nokon pʉ'kʉ pona,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sapa' a'tai, Sises utɨ'pʉ Pari'si amʉ' epuru iwʉ' ta' enta'nai'. Ipan pe rɨ to' esi'pʉ enpɨtʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mɨrɨ yau si, takuru'kenan esi'pʉ mɨrɨ itemekon ton mɨrɨ awonsi'kɨ i'si ton a'sarutapɨ'sa'. ");
INSERT INTO akeNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Sises uya Pari'si amʉ' mɨrɨ awonsi'kɨ Main pɨ' enupanin nan ekama'po'pʉ, “Main awɨrɨ pe' e'nɨ pe iyesi Sapa' a'tai takuru'kenan ka'pon epi'tɨ yau, mɨrɨ pe pʉra kane katɨ?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","E'tane to' uya rɨ etapɨtʉ'pʉ. Mɨrɨpan uya temiyatʉ tʉrʉ'pʉ takuru'kenan pona, epi'tɨ'pʉ iya, mɨrɨpan ennoko'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mɨrɨpan a'tai, to' ekama'po'pʉ iya, “Ɨ'rɨ ken kupʉ auya ɨmʉre, mɨrɨ pe pʉra ɨikʉn paka uta'mo'kasa' pe iyesi yau non akasa' ya' Sapa' a'tai? Imo'ka auya pen pe' inke pʉra?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ɨ'rɨ nin si tato' to' uya pʉra rɨ iyesi'pʉ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tʉron nɨ a'tai, Sises uya ikɨ'masa' kon ereutasa' ene'pʉ eke ton pe te'san apon po. Mɨrɨpan kon pana ya' se panton ekama'pʉ iya: ");
INSERT INTO akeNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ɨnʉ' uya rɨ ɨkɨ'masa' pe iyesi yau, temari'masan uta're'tɨ koro'ta', eke ton pata'se' airɨ kereutai. Iya'tai pʉra, eke ɨyentaino kɨ'masa' iya esi. ");
INSERT INTO akeNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mɨrɨ pe iyesi yau, apatawono ɨkɨ'manin nʉ'pʉ uya ta ɨpɨ', ‘Pʉse irepakɨ ayapon ke.’ Mɨrɨ a'tai nin si, ɨyepiyɨ'sa' ereuta mɨrɨ sepan pona rʉ'kwɨ nin si. ");
INSERT INTO akeNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","E'tane ɨkɨ'masa' a'tai, sepan airɨ rʉ'kwɨ mereutai'. Apatawono uye'sa' a'tai, ‘Se ya' parɨ wakʉ ya' atamakɨ,’ tato' pe iya ɨpɨ'. Mɨrɨ a'tai, eke pe ɨkupʉ iya ɨpokon pe ikɨ'masa' kon enu airɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Apʉne pʉra, eke pe te'ku'san tiwano' kon pe ena mɨrɨ se pe rɨ, mɨrɨ awonsi'kɨ se pe te'ku'san ena mɨrɨ eke pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Mɨrɨ a'tai, Sises uya ta'pʉ tʉpatawono pɨ', “Ɨye'kɨ'ma a'tai, ɨtonpa ton nɨken kʉ'kɨ'mai, tapiyara ton kʉ'kɨ'mai, apʉne pʉra to' use'ma esi ɨmɨrɨ tʉkɨ'mai'. ");
INSERT INTO akeNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","E'tane enta'nai' ka'pon amʉ' kɨ'ma auya pe iyesi yau, entu'manin nan, ipu'tɨka'sa' ton, wasesenpa' nan, tenku'na' nan nɨken mʉkɨ'mai'. ");
INSERT INTO akeNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Pori' pe ɨwesi mɨrɨ, to' uya ɨye'ma tane pʉra rɨ. Ɨyepe'pʉ eporo auya, ipokena' ton eri'sa' e'mʉ'sa'ka a'tai,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Serɨ etasa' mɨrɨ yau te'san tonpa uya a'tai, ta'pʉ iya Sises pɨ', “Pori' pe kuru kamoro esi mɨrɨ enta'nan pɨ' te'ton kon Papa e'to' esa' wannɨ pe yau,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Sises uya eikʉ'pʉ panton ekama pe, “Ka'pon uya eke kuru enta'nan nɨto' koneka esi'pʉ. Mɨrɨpan uya tu'kan kon nɨ ka'pon amʉ' kɨ'ma'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tenta'nakapʉ a'tai nin si, tʉpoitorʉ ennoko'pʉ iya tʉnkɨ'ma'san pana'tɨse'na, ‘Ɨsi'tɨ' si, tanporon nɨ si ekonekasa' man,’ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","E'tane, tanporo tʉwapu kon eporo'pʉ to' uya. Wapiyaro' uya ta'pʉ, ‘Serɨ pe kuru umɨ ennasa' uya man, mɨrɨpan ense'na utɨ. Ɨri pe mɨrɨ pɨ' ke'kupʉi.’ ");
INSERT INTO akeNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Tʉron nɨ uya ta'pʉ, ‘Serɨ pe kuru 5 kaisa rɨ asa'rɨ'ne i'mʉkansa' kon paka amʉ' waraino kon ennasa' uya man, mɨrɨpan kon i'tuse'na utɨ serɨ. Ɨri pe mɨrɨ pɨ' ke'kupʉi.’ ");
INSERT INTO akeNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Tʉron nɨ uya rɨ marɨ kanan ta'pʉ, ‘Serɨ pe kuru emari'masa' man. Mɨrɨ wenai, utɨ poken pʉra man,’ tukai' to' usekama'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Serɨ si ekamase'na ipoitorʉ enna'po'pʉ mɨrɨ tepuru pɨ'. Mɨrɨ pɨ' itepuru usakorota'pʉ ipan pe, mɨrɨpan uya tʉpoitorʉ apiyo'ma'pʉ, ‘Inke pʉra enta pata ya'ne, eke ton asanta tawɨrɨ'ne, aiko ton tawɨrɨ'ne entu'manin nan ine'ta, ipu'tɨka'sa' kon, tenku'na' nan mɨrɨ awonsi'kɨ wasesenpa' nan,’ ta'pʉ itepuru uya. ");
INSERT INTO akeNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Mɨrɨpan poitorʉ uye'sa' uya ta'pʉ ipɨ', ‘Uyapiyo'ma'pʉ auya siku'kapʉi, e'tane moro rɨ marɨ ɨutɨ man, iyarʉ pʉra,’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Mɨrɨ a'tai, itepuru uya kanan takaa'pʉ tʉpoitorʉ pɨ', ‘Enta asanta ta'ne ɨnnɨ' nan pata ya'ne mɨrɨ yawon kon pɨ' ɨsi'tɨ' kuru mʉkai', uiwʉ' utarʉ'tɨka'to' pe. ");
INSERT INTO akeNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ta uya ɨpɨ', kamoro unkɨ'ma'san wapiya uya ui'kiyari onpato' oton pen,’ ta'pʉ itepuru uya tapiyo' pɨ',” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Anpisin nɨ utɨ esi'pʉ Sises a'kɨrɨ. To' winɨkʉi' tera'tɨi' ta'pʉ iya, ");
INSERT INTO akeNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ɨnʉ' rɨ esi pʉra iyesi upoitorʉ pe tʉkʉipʉnʉ, tʉsan i'nʉnkai'ma, tʉno'pʉ, mɨrɨ awonsi'kɨ tʉmunkɨ amʉ', takon non mɨrɨ awonsi'kɨ tʉparusi ton, tʉuko'mamʉ eseru rɨ nɨrɨ i'nʉnkai'ma rɨ urɨ i'nʉnkato' tʉuya entai. ");
INSERT INTO akeNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mɨrɨ awonsi'kɨ ɨnʉ' rɨ tʉkurusukuui anapai pʉra na'ne' mɨrɨ awonsi'kɨ upɨkɨrɨ ɨtɨpai pʉra na'ne' esi upoitorʉ poken pʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ka'tawon ɨutɨ anamɨpai ɨtonpa kon esi yau, iyereuta pen pe' wapiya eke pe pe' tʉpʉrataai esi amɨ poken nɨ tukai' ense'na? ");
INSERT INTO akeNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Isara'tɨsa' iya e'tane, i'ma'ka iya pʉra iyesi yau, tanporon kon ennin nan uta'kɨrɨ mɨrɨ ipɨ', ");
INSERT INTO akeNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Pʉse rɨ rʉ'kwɨ e'sara'tɨ'pʉ amɨ pɨ' e'tane, i'ma'ka iya pʉra iye'sa',’ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Iya'tai pʉra si, kin ekoneka serɨ ko tʉutɨto' pe tʉron nɨ kin ewa'nomai', mɨrɨ awonsi'kɨ itentai enai'. Iyereuta pen pe' ɨsenuminkase'na 10,000 kaisaron kon tʉsoisaai amʉ' pe' esi pana' pe tukai' teyaton non uyepʉ pe iyesi yau 20,000 kaisa rɨ tewa'nomai'? ");
INSERT INTO akeNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ikupʉ tʉuya poken pʉra iyesi pɨ', tʉpoitorʉ ton ennoko iya kin piya' ɨnnɨ rɨ marɨ esii'ma ekama'pose'na tʉuko'manto' kon pe tʉusewa'nomai' pʉra. ");
INSERT INTO akeNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mɨrɨ pe iyesi pɨ', upoitorʉ pe e'pai ɨwesi yau, tanporon nɨ tʉnonkai' ɨwe'to' pe iyesi. ");
INSERT INTO akeNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Waiyo esi wakʉ, e'tane ine'ne' pe pʉra iyenasa' yau, nai kasa ine'ne' pe kanan ikupʉ? ");
INSERT INTO akeNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Wakʉ pe pʉra rɨ iyesi non iwano' pe mɨrɨ pe pʉra non isu pe; eno'masa' pe iyesi. “Kʉrɨ tʉpana ke na'ne' etanin pe, tɨwɨ netai,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tʉron nɨ a'tai, pʉrata amʉranʉ'nin nan mɨrɨ awonsi'kɨ tʉmakooikena' nan amʉra esi'pʉ Sises woi imaimu etase'na. ");
INSERT INTO akeNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","E'tane Pari'si amʉ' mɨrɨ awonsi'kɨ Main pɨ' enupanin nan etarerumʉ'pʉ, “Pʉse rɨ ka'pon uya tʉmakooikena' nan kupʉ tʉtonpa pe, to' pokon pe rɨ iyenta'na!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mɨrɨ a'tai nin si, Sises uya serɨ ton panton amʉ' ekama'pʉ mɨrɨ to' pɨ', ");
INSERT INTO akeNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Iya'tai pʉra, 100 kaisa rɨ karimeru amʉ' itikʉn ton ɨtonpa kon esi yau, mɨrɨpan kon tonpa utano'masa' pe iyesi yau, 99 pan kon pe' nɨnnin pen ayupon pata yau itano'masa' e'ma'pʉ tau tʉutɨto' pe eporo tʉuya pʉ'kʉ pona rɨ? ");
INSERT INTO akeNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Eposa' tʉuya a'tai, pori' pe esii'ma ti'mʉye'pɨ pona anʉmʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Mɨrɨ a'tai, tʉtonpa ton kɨ'ma iya, mɨrɨpan uya ta to' pɨ', ‘Epori'manpai'nokon. Uikʉn karimeru itano'masa' rʉ'pʉ eposa' uya man!’ ");
INSERT INTO akeNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mɨrɨ ekama uya ɨpɨ'nokon, mɨrɨ kasa kuru si iyesi epori'man esi eke pe Epʉn po tikin nan tʉmakooikenan era'tɨsa' a'tai, kamo 99 kaisaron kon ipokena' ton ka'pon amʉ' pɨ' pori' pe e'nɨ entai. ");
INSERT INTO akeNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Mɨrɨ pe pʉra, uri'san uya 10 kaisaron pʉrata pun tonpa ano'ma'pʉ pe iyesi yau tikin nɨ, ɨ'rɨ ken si kupʉ iya? Tʉraan'puui po'tɨ iya, tiwʉ' akorokato' pe tʉuya, iwarinpa iya, eporo tʉuya pʉ'kʉ pona. ");
INSERT INTO akeNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Eposa' tʉuya a'tai, tʉtonpa ton kɨ'ma iya, mɨrɨpan uya ta to' pɨ', ‘Epori'manpai'nokon, itano'masa' rʉ'pʉ upʉrataai eposa' uya man!’ ");
INSERT INTO akeNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mɨrɨ kasa rɨ marɨ iyesi ta uya ɨpɨ'nokon, Papa inserʉʉi amʉ' epori'ma tikin nan nɨ tʉmakooikenan era'tɨsa' a'tai,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Miyarɨ rɨ Sises usaurokʉ'pʉ, “Moro ka'pon esi'pʉ asa'ron kon imunkɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Iyakon uya ta'pʉ tʉkʉipʉnʉ pɨ', ‘Papai, uyena' ɨntʉrʉnʉ pe te'sen ɨimamin itʉka'kɨ,’ ta'pʉ iya ipɨ'. Mɨrɨpan uya timamin ratoika'pʉ to' kaisa rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Inke kuru pʉra rɨ mɨrɨ pata'pʉ pe, imu akon si uya tanporo tiwano' pe iye'nonkasa' amʉranʉkʉ'pʉ. Mɨrɨpan utɨ'pʉ ɨnnon pata ya'. Mɨrɨ yau nin si tʉpʉrataai ma'tanʉkʉ'pʉ iya mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tanporon nɨ nin si ma'tanʉkʉ'pʉ iya pata'pʉ pe, iwankan uta'mo'ka'pʉ mɨrɨ, mɨrɨ pata yau, mɨrɨpan ekota'ma'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Mɨrɨ tʉpo, itɨ'pʉ patawon piya' tʉtʉrawasooi epose. Mɨrɨpan uya tikʉn non peiruku amʉ' ewe'se'na ennoko'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mɨrɨpan nʉ'kwɨ esi'pʉ peiruku amʉ' i'kiyari pɨ' enta'napai. E'tane ɨnʉ' uya rɨ irepa'pʉ pen iti'kiyari ke. ");
INSERT INTO akeNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Isenuminkato' uya nin si eporo'pʉ mɨrɨ. Mɨrɨpan uya, ‘Ukʉipʉnʉ apiyo' ton i'kiyari esi serɨ eke pe rɨ to' entai rɨ,’ ta'pʉ iya. ‘E'tane si, serɨ yau apʉ'ka'nɨ pɨ' esi. ");
INSERT INTO akeNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Enna'po serɨ, tase'na ukʉipʉnʉ pɨ'; Papai, e'makoimasa' man Papa winɨkʉi' mɨrɨ awonsi'kɨ ɨwinɨkʉi' nɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ɨmu tukai' uyesakʉi, e'tane pʉra ayapiyo' ton tonpa pe uku'kɨ.’ ");
INSERT INTO akeNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Mɨrɨpan enna'po'pʉ tʉkʉipʉnʉ piya'. “Ɨnnɨ rɨ marɨ iye'tane, ikʉipʉnʉ uya ensa' esi'pʉ. Mɨrɨpan tense isentu'ma'pʉ, mɨrɨpan eka'tumʉ'pʉ a'sise'na. Mɨrɨ tʉpo, ereutanʉkʉ'pʉ iya, a'su'kapɨtʉ'pʉ iya etupa pe. ");
INSERT INTO akeNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Imu uya ta'pʉ ipɨ', ‘Papai, e'makoimasa' man Papa winɨkʉi' mɨrɨ awonsi'kɨ ɨwinɨkʉi' nɨrɨ. Ɨmu tukai' uyesakʉi.’ ");
INSERT INTO akeNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mɨrɨpan e'tane ikʉipʉnʉ uya ta'pʉ tapiyo' ton pɨ', ‘Inke pʉra wakʉ ipon ine'tɨ' ipontɨ kon pa, irimuui ɨntʉtɨ' itemiyatʉ pɨ'. Wakʉ ke kuru isapatooi'tɨtɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Eka'nʉ'sa' paka ine'tɨ' iwɨnɨ kon pa. Enta'nanpai'nokon umu uye'sa' pɨ'! ");
INSERT INTO akeNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Pʉse rɨ si umʉre ima'tasa' kasa, iye'sa' rʉ'pʉ e'mʉ'sa'kasa' pe rɨ upona iyesi pɨ'. Itano'masa' rʉ'pʉ e'seposa',’ ta'pʉ iya to' pɨ'. Mɨrɨpan kon e'sara'tɨ'pʉ enta'nan pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Mɨrɨ koro'tau si, eke imu esi'pʉ mɨrɨ umɨ yau. Ɨutɨ piya' a'ko pe iye'sa' a'tai, wai uturumʉ mɨrɨ awonsi'kɨ tʉumanunsan eta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Mɨrɨpan uya tapiyo' ton tonpa kɨ'ma'pʉ, mɨrɨpan ekama'po'pʉ iya, ‘Ɨ'rɨ ne'ku'an?’ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mɨrɨpan eikʉ'pʉ iya, ‘Ayakon enna'posa'. Mɨrɨ pɨ' eka'nʉ'sa' paka wɨsa' ɨkʉipʉnʉ uya, atu' pe rɨ iyenna'posa' pɨ',’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ewonpai pʉra irui usakorotasa' esi'pʉ. “‘Ewonkɨ,’ ka'se'na ikʉipʉnʉ epa'ka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","“Mɨrɨpan uya tʉkʉipʉnʉ eikʉ'pʉ, ‘Apʉne uyeta', amaimu pʉreme'nin pen sa'ne urɨ ko; ayapiyo' pe tʉuko'mansen inke rɨ wʉipiya ton kaisarɨ rɨ, e'tane utonpa ton pokon pe epori'mato' pe urepanin pen nɨ ɨmɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","E'tane si pʉse rɨ ɨmu ayapuruui, ɨpʉrataai ma'tanʉ'nin nʉ'pʉ ekuman pɨ', mɨrɨpan enna'posa' yo' pe, eka'nʉ'sa' paka mʉre wɨsa' auya,’ ta'pʉ iya. “Mɨrɨpan eikʉ'pʉ ikʉipʉnʉ uya, ");
INSERT INTO akeNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","‘Upiyau te'sen ɨmɨrɨ tɨwɨrɨ rɨ, mɨrɨ awonsi'kɨ tanporon nɨ upiyau na'ne' mɨrɨ ɨiwano',’ ta'pʉ ikʉipʉnʉ uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","‘E'tane pʉse rɨ ayakon enna'posa' pɨ', itano'masa' rʉ'pʉ pe iyesi pɨ', ima'tasa' kasa rɨ iko'mansa' pɨ' epori'man,’ ta'pʉ ikʉipʉnʉ uya ipɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Panton ekama'pʉ Sises uya tʉpoitorʉ ton pana ya', se tawon: “Mɨrɨ yau ka'pon esi'pʉ ipʉrataaike', mɨrɨpan esi'pʉ timamin esa' ke. Tʉron nɨ a'tai, itepuru piya' ka'pon utɨ'pʉ tepuru pʉrataai mɨrɨ awonsi'kɨ itimamin ma'tanʉkʉ iya ekamai'. ");
INSERT INTO akeNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mɨrɨ a'tai, ikɨ'ma'pʉ iya ekama'poto' pe tʉuya, ‘Ka'pon amʉ' uya upana'tɨsa' man ɨyeseru ke, mɨrɨpan apurɨsa' uya man. Ɨyenau iye'sa' rʉ'pʉ pʉrata mɨrɨ awonsi'kɨ uimamin apon nʉ'pʉ kareta ikonekaka'kɨ. Mɨrɨ enta' uimamin esa' pe ɨwe'to' oton pen mɨrɨ,’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Mɨrɨpan apiyo' usenuminka'pʉ, ‘Uyepuru uya, “Mɨrɨ enta' uimamin esa' pe ɨwe'to' oton pen mɨrɨ,” tasa' upɨ'. Ɨ'rɨ rɨ ku'to' pe uya ko? Pana' pe pʉra e'ai' sa'man tʉrawaso kupʉ uya poken pʉra, ɨpiyɨtʉ rɨ enkuui pe enasa' yau. ");
INSERT INTO akeNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Si'tuyai', uyepuru imamin anʉnnin nʉ'san pika'tɨ uya mɨrɨ, to' uya nɨrɨ upika'tɨto' pe, tiwʉ' kon ta' to' uya uyereutanʉ'to' pe rɨ,’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Mɨrɨpan uya te'mai' pʉra tepuru imamin e'ma'tɨnin nʉ'san kɨ'ma'pʉ, mɨrɨpan kon uyee'pʉ tikin pa'ne. Wapiya iye'sa' ekama'po'pʉ iya, ‘Ɨ'rɨ kaisa rɨ te'mai' pʉra uyepuru imamin arɨ'pʉ auya nai?’ ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘800 kiyaran e'to' airɨ are' kasi',’ ta'pʉ iya nin si mɨrɨ. “Mɨrɨpan pɨ' ta'pʉ iya, ‘Se si imenuka' 400 kaisaron iten karapa, are' kasi' tukai',’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Mɨrɨ tʉpo, ite'ma'pʉ pe iye'sa' ekama'po'pʉ iya, ‘Ɨ'rɨ kaisa rɨ te'mai' pʉra uyepuru imamin arɨ'pʉ auya nai?’ ta'pʉ iya ipɨ'. “‘1,000 kaisa rɨ pʉrowa paikii,’ ta'pʉ iya. “Mɨrɨpan pɨ' ta'pʉ iya, ‘Se si imenuka' 80 kaisa rɨ pʉrowa paikii tukai',’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Mɨrɨpan etasa' itepuru uya a'tai, apurɨpɨtʉ'pʉ iya, ɨri ku'sa' iya rɨ e'tane, tʉuko'manto' e'ma konekasa' iya pɨ'. Serɨ ta uya apʉne pʉra serɨ non pon kon esi emiya'poke' ton non eseru wenai uta'kwarʉkan pɨ' te'san, Papa munkɨ uta'kwarʉka non eseru pɨ' pʉra rɨ nin iyesi mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Ta uya ɨpɨ'nokon, ɨpʉrataai kon mɨrɨ awonsi'kɨ ɨimamin kon ke entu'manin nan ipika'tɨtɨ' tʉtonpa ke ɨwesi kon pa, mɨrɨpan ɨpʉrataai kon u'ma'sa' a'tai, Papa uya ɨrepato' kon pe apata kon ke Epʉn po. ");
INSERT INTO akeNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ɨnʉ' rɨ aiko pe irepasa' uya wakʉ pe ikupʉ yau, eke ke irepa rɨ mɨrɨ wakʉ pe ikupʉ iya pɨ', e'tane ɨnʉ' rɨ kʉrɨ tʉrepasa' ma'tanʉ'nin nʉ'pʉ repa pʉra rɨ iyesi mɨrɨ eke ke. ");
INSERT INTO akeNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mɨrɨ kasa si serɨ non pon pʉrata mɨrɨ awonsi'kɨ mamin ma'tanʉ'nin pe ɨwesi yau, Papa uya wakʉ nin si ɨimamin ke Epʉn pon ke ɨrepa pʉra rɨ iyesi mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ka'pon imamin ma'tanʉ'sa' auya yau, ɨnʉ' uya rɨ ɨrepa ɨimamin ke kupʉ auya? ");
INSERT INTO akeNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ɨnʉ' rɨ iyapiyo' pe te'sen esi pʉra iyesi asa'ron kon tepuru ton apiyo' pe. Tikin nan ewaruma'tɨ iya, isakon i'nʉnka iya; tikin nan pɨ' ita'si, isakon sanoma iya pʉra. Asa'rɨ rɨ marɨ Papa mɨrɨ awonsi'kɨ pʉrata apiyo' pe ɨwesi kon pʉra iyesi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Serɨ ta Sises uya etasa' tʉuya'nokon a'tai, Pari'si amʉ' uya isapema'pʉ, apʉne pʉra pʉrata i'nʉnkanin nan pe tesi kon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mɨrɨ a'tai, ta'pʉ iya to' pɨ', “Ɨmɨrɨ'nokon kuru sa'ne si kamoro ko wakʉ pe te'ku'san ka'pon amʉ' enu airɨ, e'tane Papa uya ɨi'tu kon pʉrata i'nʉnka auya'nokon ti'nʉnka auya'nokon entai, tukai'. Ka'pon uya wakʉ tato' ipɨ' pɨ', Papa uya ɨri ta. ");
INSERT INTO akeNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Main Mosi' winon mɨrɨ awonsi'kɨ pu'kena' amʉ' Maimu esi'pʉ meruntɨ pe, Isaan Pa'tes uyepʉ pʉ'kʉ pona; mɨrɨ si'kɨrɨ Papa e'to' esa' wannɨ pe ekareei usekamasa' serɨ, mɨrɨpan pɨkɨrɨ e'pai tu'kan kon nɨ uta'kwarʉkan pɨ' man. ");
INSERT INTO akeNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Sa'man pe pʉra rɨ iyesi Epʉn mɨrɨ awonsi'kɨ non pʉra iyena aiko pe rɨ na'ne' pen nʉwarai'ka'pʉ uta'mo'ka pen Main apai. ");
INSERT INTO akeNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ɨnʉ' rɨ tʉno'pʉ nonkayai'ne' mɨrɨpan uya tʉron nɨ uri'san mari'ma, ekuma pe iyesi, mɨrɨ awonsi'kɨ ka'pon inonkasa' rʉ'pʉ mari'mayai'ne', ekuma pe iyesi,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Sises uya ta'pʉ, “Ka'pon esi'pʉ moro imaminke', tʉtariren mɨrɨ awonsi'kɨ wakʉ rɨ ipon renen tato', epe'kena' ton nɨ. Eke pe rɨ iti'kiyari esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Moro kanan si entu'manin esi'pʉ mɨrɨ, ipon pʉn, itimamin pʉn, iti'kiyari pʉn, erekʉ'pan, Ʉrasaras itese'. Mɨrɨpan nin si tase to' uya inɨnpɨtʉ'pʉ mɨrɨ, imaminkena' mʉra'ta nau. ");
INSERT INTO akeNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Enta'napai iyesi'pʉ ipʉrataaikena' ka'pon i'kiyari punu'pɨ pɨ'. Pero amʉ' uye'pɨtʉ'pʉ iterekʉʉi ami'kai'. ");
INSERT INTO akeNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mɨrɨ koro'tau, iyeri'kaa'pʉ. Mɨrɨpan nin si arɨ'pʉ inserʉ amʉ' uya, Papa apurɨnin nan eri'sa' utɨse' ya'. Mɨrɨ yau nin si, Ʉrasaras uya Epʉra'an tʉtɨpiya eporo'pʉ mɨrɨ pena ima'tasa' rʉ'pʉ. Imaminkena' rɨ nɨrɨ eri'kaa'pʉ, mɨrɨpan ekepu u'na'tɨ'pʉ to' uya, ");
INSERT INTO akeNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","mɨrɨpan utɨ'pʉ apo' ya', ɨsɨ pata ya'. Mɨrɨ awonsi'kɨ si tenu tʉrʉ'pʉ iya mɨrɨ. Mɨrɨpan uya Epʉra'an piyau Ʉrasaras ene'pʉ ɨnnɨ kuru tʉpiyapai. ");
INSERT INTO akeNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","‘Papai, Epʉra'an, upɨ' ɨsentu'makɨ! Ʉrasaras enno'kɨ tuna ka' temiyatʉ tʉki'se uyesen amankai' iye'to' pe. Ɨsɨ yau e'ai' a'ne' yau,’ ta'pʉ iya nin si mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“‘Mooi, mi'tuyan pe' nurɨne ɨwesi a'tai, pori' pe rɨ ɨuko'mamʉ'pʉ, Ʉrasaras kanan ɨri rɨ moronka pɨ'. Mɨrɨpan e'tane nin si, serɨ yau wakʉ pe rɨ iyesi mɨrɨ, ɨmɨrɨ kanan si ɨsɨ yau. ");
INSERT INTO akeNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mɨrɨ pona ɨpiya' utɨn poken pʉra e'nɨ serɨ awonsi'kɨ, yaranta uya uwa'kʉ'sa' kon, uya'sanau'nokon iyesi. Ɨnʉ' rɨ utɨ poken pʉra miyarɨ. Mɨrɨ apai nɨrɨ serɨ ya' ɨnʉ' rɨ uyepʉ poken pʉra,’ ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Mɨrɨ pɨ' ita'kwarʉka'pʉ ipan pe, ‘Warai yau ken si, Ʉrasaras enno'kɨ ukʉipʉnʉ iwʉ' ta' ");
INSERT INTO akeNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","5 kaisaron kon uyakon non panamase'na, serɨ ya' to' uyepʉ namai'. Wakʉ pe to' uko'manto' pe, Papa Maimu awɨrɨ,’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Mɨrɨpan pɨ' Epʉra'an uya ta'pʉ, ‘Moro rɨ Mosi' maimu rʉ'pʉ esi mɨrɨ, mɨrɨ awonsi'kɨ pu'kena' amʉ' maimu rʉ'pʉ esi mɨrɨ, tɨwɨ to' netai, iyawɨrɨ te'to' kon pe,’ ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“‘Kane, Papai Epʉra'an, mɨrɨ apurɨ to' uya pʉra rɨ iyesi, serɨ awon kuru nin tɨ, ima'tasa' rʉ'pʉ e'mʉ'sa'kasa' uya tauro'ka kon a'tai, to' uya kuru rɨ nin apurɨ mɨrɨ tʉmakooi kon apai rɨ nin si to' era'tɨ,’ ta'pʉ iya nin si mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Mɨrɨpan pɨ' Epʉra'an uya ta'pʉ, ‘Mosi' mɨrɨ awonsi'kɨ pu'kena' amʉ' auro'ka'pʉ Papa uya, to' uya imenukato' pe, mɨrɨ awɨrɨ pʉra to' esi a'tai, uruwai' awon nɨ e'mʉ'sa'kasa' e'tane to' uya nɨrɨ imaimu etato' oton pen nɨ,’ ta'pʉ iya nin si mɨrɨ ipɨ',” ta'pʉ Sises uya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Sises uya ta'pʉ tʉpoitorʉ ton pɨ', “Makoi ya' ka'pon uta'mo'kato' rɨ e'ku'to' pe iyesi, e'tane nin si ɨsɨ yau kʉrɨ man tɨ iye'kupʉ emapu'tɨnin nʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wakʉ iwa pe rɨ iyesi eno'ma a'tai parau ka' tɨ' a'nai' e'pato' yai tewa'tɨi' i'mʉ pɨ' pʉsamoro aiko ton nʉ'kwɨ tonpa e'makoima emapu'tɨ iya entai. ");
INSERT INTO akeNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mɨrɨ wenai, ti'tui' e'tɨ'. “Ɨtonpa e'makoimasa' a'tai, auro'kakɨ mɨrɨ enta' ikupʉ iya namai'; tʉmakooi apai iyera'tɨsa' a'tai, ipɨ' ɨsentu'makɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tikin nan wʉi yau inke rɨ ɨpɨ' iye'makoimapɨtʉ a'tai, mɨrɨpan enna'popɨtʉ ɨpiya' a'tai, ‘Umakooi apai era'tɨsa' man,’ tase'na ipɨ' ɨsentu'makɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Itekare ekamanin nan pe enno'sa' kon uya ta'pʉ, “Ina Epuru, ina uya apurɨto' iku'kɨ eke pe,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","To' eikʉ'pʉ iya, “Apurɨto' auya'nokon esi yau, aiko rʉ'kwɨ mosta' ena'pɨ kasa, ta auya'nokon nɨ mɨrɨ yʉi, morʉperi tato' ye' pɨ', ‘Ekuru'ka', parau ka' ɨye'pɨmɨ pa,’ ta auya a'tai, amaimu awɨrɨ rɨ iyesi. ");
INSERT INTO akeNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Iya'tai pʉra, tʉpoitorʉ ke ɨtonpa e'sa' yau non anɨnin mɨrɨ pe pʉra karimeru amʉ' pa'simanin. Iyenna'posa' a'tai umɨ apai, ‘Ɨsi'kɨ ereutakɨ enta'nai',’ tawon pe' ɨmɨrɨ? Kane. ");
INSERT INTO akeNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ta auya ipɨ', ‘Ui'kiyari ikoneka' unta'napa pa, mɨrɨ tʉpo rɨ nin si, ɨyenta'na parɨ,’ tawon ɨmɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tenki tato' auya pʉra rɨ iyesi ɨpoitorʉ pɨ' amaimu awɨrɨ iye'sa' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ɨmɨrɨ'nokon kanan mɨrɨ kasa rɨ ɨwe'to' oton kon mɨrɨ Papa uya ɨnkupʉnʉ kon ke ɨrepasa' kon i'ma'kasa' auya'nokon yau, ta auya'nokon nin si mɨrɨ, ‘Sepa' nan nʉ'kwɨ rɨ nin sa'ne ina, ina uya tʉtʉrawasooi kon i'ma'kasa' man,’ ta auya'nokon,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sises utɨ koro'tau Surusiran pona, Sameriya mɨrɨ awonsi'kɨ Kiyarari a'sanawɨrɨ, ");
INSERT INTO akeNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","eke iwa pata eporo iya koro'tau, 10 kaisaron kon erekʉ'pa' nan uya eporo'pʉ. Ɨnnɨ Sises piyapai to' e'soto'ka'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","mɨrɨpan kon ukɨ'pɨ'nʉmʉ'pʉ, “Sises, ina epuru, ina pɨ' ɨsentu'ma'!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","To' ensa' iya a'tai, ta'pʉ iya, “Entantɨ', ɨsekamatantɨ' use'man nɨto' tʉrawasomanin nan piya' ɨusepi'tɨsa' kon nɨ man tato' pe to' uya,” ta'pʉ iya. To' utɨ koro'tau, to' usepi'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tikin nan nin si enna'po'pʉ Sises piya' tʉusepi'tɨsa' tense, ipan pe kuru rɨ Papa apurɨpɨtʉ'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Sises pʉta piya' ita'mo'ka'pʉ tenki ta tʉuya ekamanin pe, pʉse rɨ esi'pʉ mɨrɨ Sameriya pon pe. ");
INSERT INTO akeNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Sises uya ekama'po'pʉ, “10 kaisaron kon pen pe' ɨmɨrɨ'nokon nʉsepi'tɨi? Nai kamo ken si ɨtonpa ton? ");
INSERT INTO akeNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ɨ'rɨ pe iyesi pɨ' Esuwerʉ amʉ' enna'po tane pʉra rɨ ɨmɨrɨ rɨken Esuwerʉ pen nɨ nin enna'posa' Papa apurɨpɨ'se'na?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Mɨrɨ a'tai, ta'pʉ iya ipɨ', “E'mʉ'sa'ka', enta. Papa apurɨ auya uya rɨ ɨyepi'tɨsa' man,” ta'pʉ Sises uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tʉron nɨ a'tai kanan, Pari'si amʉ' uya Sises ekama'po'pʉ, “Ɨ'rɨ a'tai Papa e'to' esa' wannɨ pe uyepʉ?” tukai'. Sises uya to' eikʉ'pʉ, “Enton pʉra rɨ iyesi mɨrɨ Papa ena a'tai esa' wannɨ pe, ");
INSERT INTO akeNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ɨnʉ' uya rɨ, ‘Serɨ ne' ko,’ mɨrɨ pe pʉra, ‘Mɨrɨ ne' ko,’ ta pʉra rɨ iyesi, apʉne pʉra, Papa e'to' esa' wannɨ pe esi ɨyewan kon yau rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mɨrɨpan uya ta'pʉ tʉpoitorʉ ton pɨ', “Iweyu uye'nɨ pɨ' man Ka'pon, Papa winon ɨnenpai ɨwe'to' oton kon, e'tane ento' auya'nokon oton pen nɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ka'pon amʉ' uya tato' oton, ‘Mɨ airɨ man,’ mɨrɨ pe pʉra, ‘Se airɨ man,’ e'tane ta to' uya pɨkɨrɨ rɨ kɨtɨpɨ'tʉu. ");
INSERT INTO akeNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ka'pon, Papa winon weyu e'seposa' a'tai, kamiri' e'wei'tɨ uya ka' a'kwaka ipʉ'kʉ pona'ne kasa kuru iyesi mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","E'tane wapiya tanporon nɨ e'ne' moronkato' iya esi, mɨrɨ awonsi'kɨ serɨ a'taino kon uya ewaruma'tɨto' pe rɨ iyesi. ");
INSERT INTO akeNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Nowa a'tai iyesi'pʉ na'ne' kasa kuru, mɨrɨ kasa rɨ marɨ iye'to' oton Ka'pon, Papa winon weyu a'tai. ");
INSERT INTO akeNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ka'pon amʉ' esi'pʉ uta're'tɨn pɨ' mɨrɨ awonsi'kɨ emari'man pɨ' mɨrɨ awonsi'kɨ e'tʉrʉn pɨ' emari'man nɨto' yau Nowa ewomʉ a' ya' weyu pona rɨ. Mɨrɨ a'tai, eke pe i'mʉnpʉ uyee'pʉ, mɨrɨpan uya tanporo to' ma'tanʉkʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Iyepʉ rawɨrɨ Ra' a'tai iyesi'pʉ kasa rɨ marɨ iye'to' oton. Ka'pon amʉ' esi'pʉ uta're'tɨn pɨ' mɨrɨ awonsi'kɨ kʉrʉpo'po pɨ', e'pɨn nɨ pɨ' mɨrɨ awonsi'kɨ ɨutɨ amɨpɨtʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","E'tane Ra' uya Satan nɨmɨ'pʉ tʉpo, apo' mɨrɨ awonsi'kɨ sorʉ'pa uyee'pʉ Epʉn poi mɨrɨ to' ma'tanʉ'se'na. ");
INSERT INTO akeNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Mɨrɨ kasa kuru iye'to' oton Ka'pon, Papa winon usenpoika weyu a'tai. ");
INSERT INTO akeNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mɨrɨ wʉi a'tai, ɨnʉ' rɨ tiwʉ' nakapu po na'ne' kʉu'tɨnin tiwʉ' tawon timamin kan. Mɨrɨ kasa rɨ kanan, ɨnʉ' rɨ tʉmainarʉ yau na'ne' nɨrɨ kʉsenna'ponin pata pona ɨ'rɨ kan nɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ra' no'pʉ esi'pʉ na'ne' kuru nesii ɨyenu kon yau, timamin pɨ' iyera'tɨpɨ'sa' rʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ɨnʉ' rɨ tʉuko'manto' ɨnko'manʉ'paino uya inonkato' oton, mɨrɨ awonsi'kɨ ɨnʉ' rɨ tʉuko'manto' nonkanin uya ikoneka mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ekama uya ɨpɨ'nokon: Mɨrɨ ewarupɨɨi tau, asa'ron kon ka'pon amʉ' e'to' oton te'nʉnto' kon apon po; tikin nɨ anʉnto' oton, isakon e'nɨnto' oton. ");
INSERT INTO akeNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Asa'ron kon uri'sami'si amʉ' e'to' oton a'nai' e'pa pɨ'; tikin nɨ anʉnto' oton, isakon e'nɨnto' oton. ");
INSERT INTO akeNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(Asa'ron kon kanan ka'pon amʉ' e'to' oton tʉmainarʉ kon yau. Tikin nɨ anʉnto' oton, isakon e'nɨnto' oton,” ta'pʉ Sises uya.) ");
INSERT INTO akeNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","“Nai airɨ, Itepuru?” ta'pʉ to' uya. To' eikʉ'pʉ iya, “Eke' airɨ rɨ anwana amʉ' amʉrato' oton,” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Sises uya nin si panton ekama'pʉ tʉpoitorʉ ton enupanin pe tɨwɨrɨ rɨ tʉwɨpʉremasan pe to' e'to' pe tʉuseta'kai' pʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Sises uya ta'pʉ, “Moro eseru aimenkanin esi'pʉ pata yau, Papa Maimu apurɨnin pen nɨ mɨrɨ awonsi'kɨ ka'pon amʉ' pɨ' tʉusentu'masen pen nɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mɨrɨ yau, itaan'pʉ ima'tasa' rʉ'pʉ esi'pʉ tɨwɨrɨ rɨ ata'kwarʉkai' tʉuye'pɨ'sen ipiya', ‘Upika'tɨkɨ uma'tanʉkʉ i'se na'ne' uyeyaton enapai,’ tapɨ'se'na. ");
INSERT INTO akeNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","“Inke rɨ ipika'tɨ iya pʉra iyesi'pʉ, e'tane nin si isenuminka'pʉ mɨrɨ, ‘Apʉne pʉra tɨwɨrɨ rɨ itaan'pʉ ima'tasa' rʉ'pʉ uye'pɨtʉ pɨ' uyewana'tɨse'na, mɨrɨ enta' nin si uyewana'tɨ iya pen mɨrɨ. Mɨrɨ pe iyesi pɨ', ipika'tɨkapʉ uya serɨ i'se iye'to' ke, Papa namanin pe pʉra rɨ e'tane, mɨrɨ awonsi'kɨ ka'pon amʉ' pɨ' tʉusentu'masen pe pʉra rɨ e'tane,’ ta'pʉ iya,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mɨrɨpan pɨ' Sises uya ta'pʉ, “Ɨsenupatɨ' ɨri, eseru aimenkanin pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Mɨrɨ ku'sa' iya pɨ' itaan'pʉ ima'tasa' rʉ'pʉ pɨ', Papa nin si wakʉ eseru aimenkanin kamo ka'pon amʉ' tʉnanʉmʉ'san iwano' pe, tɨwɨrɨ rɨ tʉpika'tɨto' kon ekama'ponin nan. Tɨnɨn pɨ' iyesi pen nin kʉrɨ eseru aimenkanin kasa. ");
INSERT INTO akeNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ekama uya ɨpɨ'nokon, Papa uya inke pʉra rɨ nin wakʉ kupʉ to' iwano' pe. E'tane, Ka'pon, Papa winon uyepʉ a'tai ken pe' si, ka'pon amʉ' rɨ pe' eporo iya tapurɨ pɨ', ɨpʉreman pɨ' serɨ non po?” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Sises uya panton ekama'pʉ wakʉ pe Papa enu yau tesi kon pe ekamanin nan pɨ', tʉron kon eno'mai'ma ɨri pe, se tawon, ");
INSERT INTO akeNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ɨpʉremai' asa'ron kon ka'pon amʉ' utɨ'pʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' ta', tikin nan esi'pʉ Pari'si pe, mɨrɨ awonsi'kɨ isakon esi'pʉ pʉrata amʉranʉ'nin pe. ");
INSERT INTO akeNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pari'si e'soto'ka'pʉ tʉpɨ' rɨ asauro'se tʉwɨpʉrema itese', ‘Papa, tenki ta uya serɨ ɨpɨ' tanporon kon entai rɨ wakʉ pe esi pɨ'. Tʉron kon man ɨri ton nɨ, makoi ku'nin nan nɨ, e'tane urɨ esi mentaino pe pʉra, kasi ye' pe pʉra, tekumasen pe pʉra, kʉrɨ rɨ pʉrata amʉranʉ'nin kasa pʉra rɨ esi. ");
INSERT INTO akeNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Tʉuserumasen urɨ tenta'nai' pʉra asa'rɨ wʉi suntaaka a'sanau'ne, mɨrɨpan ɨrepato' tʉnin urɨ tasa' auya awɨrɨ uneporo'pʉ apai,’ tukai' iyɨpʉrema'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“E'tane pʉrata amʉranʉ'nin e'soto'kasa' esi'pʉ ɨnnɨ rɨ Pari'si piyapai, Epʉn winɨkʉi' tenu tʉrʉ'pʉ iya pen nɨ, e'tane tʉpʉropo wɨpɨtʉ'pʉ iya tʉupokoita tʉmakooi ke tesi pɨ' ekamanin pe, ‘Papa, upɨ' ɨsentu'makɨ, urɨ sa'ne tʉmakooikenan,’ ta'pʉ iya.” ");
INSERT INTO akeNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Sises uya ta'pʉ, “Ekama uya ɨpɨ'nokon, pʉse rɨ, isakon pen, ekonekasa' Papa pokon pe enna'po'pʉ, apʉne pʉra mɨ pe te'ku'sen ena mɨrɨ se pe rɨ, mɨrɨ awonsi'kɨ se pe rɨ te'ku'sen ena mɨrɨ eke pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ka'pon amʉ' uya tʉmunkɨ kon nee'pʉ Sises uya to' a'pɨ'to' pe. Ipoitorʉ ton uya serɨ ensa' a'tai, to' sanon ton eseremekʉ'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","E'tane rɨ, Sises uya mʉre amʉ' kɨ'ma'pʉ tʉpiya', “Tɨwɨ mʉre amʉ' nʉyepʉi upiya'; to' kʉsereutanʉ'tʉu, apʉne pʉra Papa e'to' esa' wannɨ pe kuru esi pʉsamoro waraino' nan iwano' pe. ");
INSERT INTO akeNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","I'napairon ekama uya ɨpɨ'nokon, ɨnʉ' rɨ Papa e'to' esa' wannɨ pe eporo iya pʉra na'ne' mʉre kasa te'se, epa'kato' oton pen nɨ ya',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tikin nan itepuru uya Sises ekama'po'pʉ, “Wakʉ ti'sa, ɨ'rɨ kuru ku'to' uya esi wakʉ uko'man nɨto' tɨwɨrɨ rɨ, epoto' pe uya?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","“Ɨ'rɨ pe iyesi pɨ' wakʉ tukai' uyesakʉ auya?” tukai' Sises uya eikʉ'pʉ. “Ɨnʉ' pʉra rɨ iyesi wakʉ e'tane Papa rɨken. ");
INSERT INTO akeNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mosi' nʉmenuka'pʉ i'tu auya: ‘Iyemari'masa' uri'san kʉsekumankai, ɨnʉ' rɨ kʉ'wɨnɨi, ama' pe kesii, kasi pe ka'pon pɨ' kasaurokʉi, ɨkʉipʉnʉ mɨrɨ awonsi'kɨ asan nɨrɨ inamakɨ,’ tawon,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","“Mʉre' esi'pʉ si'kɨrɨ rɨ tanporo serɨ ton awɨrɨ rɨ uko'mansa' man,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Serɨ etasa' Sises uya a'tai, ta'pʉ iya ipɨ', “Tikin nan nɨken iyawɨrɨ ɨwe'to' e'ku'sa' man; tanporo ɨimamin pe na'ne' ikʉrʉpo'pomakɨ, mɨrɨpan itepe'pʉ tʉrʉ pa entu'manin nan ena', mɨrɨpan epe'pʉ pe wakʉ eporo pa Epʉn po. Mɨrɨ ku'sa' auya tʉpo, upɨkɨrɨ si ɨsi'kɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Serɨ etasa' iya a'tai, ipan pe ika'nɨ' pʉra iyena'pʉ, apʉne pʉra imaminke' pe kuru iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Sises uya ene'pʉ, mɨrɨpan uya ta'pʉ, “Sa'man pe kuru rɨ iyesi imaminke' ton epa'ka poken pʉra Papa e'to' esa' wannɨ pe ya'! ");
INSERT INTO akeNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","I'nai rɨ iyesi, sa'man pe pʉra rɨ kiyamerʉ epa'ka akusa enu euta awɨrɨ imaminke' epa'ka Papa e'to' esa' wannɨ pe ya' entai,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Serɨ etanin nʉ'san uya nin si ekama'po'pʉ mɨrɨ, “Ɨnʉ' kuru ken si epika'tɨ?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Sises uya to' eikʉ'pʉ, “Ka'pon pona sa'man pe na'ne' esi sa'man pe pʉra Papa pona,” ta'pʉ Sises uya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pi'ta uya ta'pʉ ipɨ', “Tanporon nɨ sa'ne nɨnsa' ina uya ɨpɨkɨrɨ tʉutɨto' kon pe!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“I'napairon ekama uya ɨpɨ'nokon, ɨnʉ' rɨ tʉpata'se' mɨrɨ pe pʉra tʉno'pʉ mɨrɨ pe pʉra takon non mɨrɨ pe pʉra tʉsanon mɨrɨ pe pʉra tʉmunkɨ ton nɨnnin nʉ'pʉ Papa e'to' esa' wannɨ pe wenai, ");
INSERT INTO akeNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","uya tu'ke ite'kwa rɨ serɨ a'tai teposen mɨrɨ awonsi'kɨ serɨ enta' te'ton a'tai teposen tɨwɨrɨ uko'man nɨto' eporo pʉra iyesi ta pen nɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Sises uya 12 kaisaron kon tʉpoitorʉ ton tʉpantakai' ta'pʉ to' pɨ', “Utɨ'nokon serɨ Surusiran pona. Mɨrɨpan tanporon nɨ pu'kena' amʉ' nʉmenuka'pʉ Ka'pon, Papa winon pɨ' uta'ku'tɨto' oton mɨrɨ yau. ");
INSERT INTO akeNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","To' uya itʉto' oton Esuwerʉ amʉ' pen ena', isapemato' oton to' uya, to' eta'tapɨ'to' oton ipona, to' uya ari'po'pɨ'to' oton, mɨrɨ awonsi'kɨ to' uya rɨ iwɨto' oton. ");
INSERT INTO akeNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Itosorʉwano wʉi a'tai, iye'mʉ'sa'kato' oton kanan,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","E'tane ipoitorʉ ton uya serɨ to'ka'nʉkʉ pʉra rɨ iyesi'pʉ. Ɨ'rɨ kuru ta iya e'kwa pe mɨrɨ pɨ' isaurokʉ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Sises uya Iseri'ko eporo koro'tau, tenku'nan esi'pʉ asanta ka'ta po eta'kwanʉn nɨ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ka'pon amʉ' utɨ eta tʉuya a'tai, “Ɨ'rɨ ne'ku'an?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Mɨrɨpan pɨ', “Sises Nasare' pon utɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mɨrɨpan ukɨ'pɨ'nʉmʉ'pʉ, “Sises, Tepi' pa rʉ'pʉ, upɨ' ɨsentu'ma'!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sises rawɨrɨ tʉutɨsan uya, “E'pana e'kɨ! Ɨ'rɨ pɨ' ɨukɨ'pɨ'nʉnpɨtʉ?” ta'pʉ to' uya ipɨ'. Mɨrɨ rɨ e'tane ikɨ'pɨ'nʉnpɨtʉ'pʉ, “Upɨ' ɨsentu'makɨ ta uya, Kin Tepi' pa rʉ'pʉ!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Sises e'takʉ'ka'pʉ, mɨrɨpan uya, “Kʉrɨ rɨ ka'pon ine'tɨ' upiya',” ta'pʉ. Iye'sa' a'tai, Sises uya ekama'po'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ɨ'rɨ kupʉ uya i'se me'an ɨiwano' pe?” ta'pʉ iya. “Uyepuru, ennin pe e'pai e'ai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Mɨrɨpan pɨ', “Enkɨ si, Papa apurɨ auya uya rɨ ɨyepi'tɨsa' man,” ta'pʉ Sises uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mɨrɨ ta iya a'tai rɨ, ennin pe iyena'pʉ. Sises a'kɨrɨ itɨ'pʉ Papa apurɨpɨtʉi'ma. Kamo ka'pon amʉ' mɨrɨ ennin nʉ'san uya Papa kanan apurɨpɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Sises si epa'kakaa'pʉ Iseri'ko pona, mɨrɨpan utɨ esi'pʉ iyawɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mɨrɨ yau, ka'pon esi'pʉ, Sa'kiyas itese'. Kʉrɨ rɨ esi'pʉ mɨrɨ pʉrata amʉranʉ'nin nan epuru pe, mɨrɨpan esi'pʉ ipʉrataaikena' pe. ");
INSERT INTO akeNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Sises ɨnenpai iyesi'pʉ, e'tane to'ken nʉ'kwɨ iyesi'pʉ tu'kan kon ka'pon amʉ' koro'tau. To'ken nʉ'kwɨ iyesi wenai, ene iya poken pʉra iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mɨrɨpan nin si eka'tumʉ'pʉ mɨrɨ to' rawɨrɨ eke yʉi, si'kamorʉ itese' poi ekainʉnse'na mɨrɨ ponsi'kɨ ense'na. Mɨrɨ awɨrɨ rɨ Sises utɨ tukai' i'tu tʉuya ke. ");
INSERT INTO akeNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Sises uya mɨrɨ eposa' a'tai, tenu tʉrʉ'pʉ iya ka'takʉi', mɨrɨpan uya ta'pʉ ipɨ', “Sa'kiyas, inke pʉra ɨu'tɨkɨ. Serɨ pe ɨiwʉ' ta' utɨ serɨ aka'kʉranpai',” ta'pʉ Sises uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Mɨrɨpan u'tɨ'pʉ imaimu awɨrɨ, mɨrɨpan uya pori' pe esii'ma tiwʉ' ta' ereutanʉkʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tanporo ka'pon amʉ' serɨ ennin nʉ'san etarerumʉ'pʉ, “Sises utɨsa' tʉmakooikenan iwʉ' ta' ika'kʉranpase'na,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sises uya si tiwʉ' epoka'sa' a'tai, Sa'kiyas e'soto'ka'pʉ tase'na ipɨ', “Apʉne enkɨ, Uyepuru, serɨ awonsi'kɨ a'sa'mʉyai uimamin tʉku'se entu'manin nan repa uya mɨrɨ, mɨrɨ awonsi'kɨ ɨnʉ' rɨ rapumasa' uya pe iyesi yau, inna'po uya mɨrɨ asakɨrɨ'ne ite'kwa,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Sises uya nin si ta'pʉ mɨrɨ ipɨ', “Serɨ ɨutɨ tawon pika'tɨsa' Papa uya man serɨ pe, apʉne pʉra apurɨnin pe ɨwesi pɨ' Epʉra'an esi'pʉ kasa. ");
INSERT INTO akeNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ka'pon, Papa winon, uye'sa' tʉmakooikenan kon warinpase'na mɨrɨ awonsi'kɨ to' pika'tɨse'na,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tʉusaurokʉ etanin nʉ'san esi koro'tau, panton ekama pɨ' rɨ Sises esi'pʉ, a'ko pe Surusiran epokapʉ to' uya rɨ esi'pʉ, mɨrɨpan ka'pon amʉ' usenuminka'pʉ Papa e'to' esa' wannɨ pe rɨ na'kɨ e'sara'tɨkapʉ serɨ pe rɨ ko tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Mɨrɨpan pɨ' panton ekama'pʉ iya se tawon: “Ka'pon eke ton mʉre pe iyentusa' rʉ'pʉ utɨ'pʉ ɨnnon nɨ pata ya' kin pe tanʉnto' pe mɨrɨ awonsi'kɨ tenna'poto' pe. ");
INSERT INTO akeNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Mɨrɨpan uya 10 kaisa rɨ tʉpoitorʉ ton kɨ'ma'pʉ mɨrɨpan kon repa'pʉ iya 10 kaisa rɨ maina. ‘Serɨ pʉrata itʉrawasomatɨ' enna'po pʉ'kʉ pona,’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","E'tane moro i'sero' kon pen esi'pʉ, mɨrɨpan kon uya tʉtonpa kon amʉ' ennoko'pʉ ite'ma'pʉ tau. ‘Pʉse rɨ ka'pon i'se pʉra ina man kin, tepuru kon pe,’ ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Kin pe iyenaka'sa' enna'po'pʉ tʉpata ya'. Mɨrɨpan uya tʉpoitorʉ ton tʉnrepa'san pʉrata ke kɨ'ma'pʉ, ɨ'rɨ kaisa rɨ to' uya ipiri'sa' tukai' ɨni'tupai iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Wapiyaro' uye'sa' uya, ‘Uyepuru, tikin nɨ urepa'pʉ auya ike piri'sa' uya man, 10 kaisa rɨ nin si maina esi,’ ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“‘Wakʉ kuru rɨ ku'sa' auya man, wakʉ upoitorʉ,’ ta'pʉ itepuru uya, ‘apʉne pʉra aiko rʉ'kwɨ ɨrepa'pʉ uya piri'sa' auya pɨ', 10 kaisaron pata esa' pe e'kɨ,’ ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Tʉron nɨ kanan ipoitorʉ uyee'pʉ tase'na ipɨ', ‘Uyepuru, tikin nɨ urepa'pʉ auya ike piri'sa' uya man, 5 kaisa rɨ ipona,’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Itepuru uya ipɨ', ‘Mɨrɨ pe iyesi pɨ', 5 kaisaron pata esa' pe e'kɨ,’ ta'pʉ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Tʉron nɨ rʉ'pʉ kanan ipoitorʉ uye'kaa'pʉ tase'na ipɨ', ‘Uyepuru, serɨ si ɨiwano' maina; iko'manʉ'sa' uya tonanse, pon piya'pɨ po. ");
INSERT INTO akeNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ɨpɨ' enari'nʉmʉ'pʉ, apʉne pʉra sa'man pe rɨ ɨwesi pɨ'. Anpata'tɨ'pʉ pen nɨ mo'kanin mɨrɨ awonsi'kɨ ɨnpɨmɨ'pʉ pen nɨ anʉnnin,’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Mɨrɨpan pɨ' itepuru uya ta'pʉ, ‘Amaimu ke rɨ ɨyeseru aimenka uya mɨrɨ, ɨmɨrɨ ɨri rɨ ipoitorʉ! I'tu auya si sa'man pe esi, unpata'tɨ'pʉ pen nɨ mo'kanin pe, mɨrɨ awonsi'kɨ unpɨmɨ'pʉ pen nɨ anʉnnin pe? ");
INSERT INTO akeNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ɨ'rɨ pe ken iyesi pɨ' upʉrataai tʉtʉse tʉnonkai' pʉra ɨwesi'pʉ pʉrata epiri'to' iwʉ' ta', uye'sa' a'tai nin si iyepiri'sa' simo'kai'no?’ ta'pʉ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Mɨrɨpan uya nin si mɨrɨ yau iye'soto'kasa' kon pɨ' ta'pʉ, ‘Mɨrɨ itenau na'ne' maina imo'katɨ' itʉrʉ kon pa kʉrɨ 10 kaisaron maina esa' pe na'ne' ena',’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“‘Ina epuru, eke pe sa'ne epoka'sa' iya man ko,’ ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“To' eikʉ'pʉ iya, ‘Ekama uya ɨpɨ'nokon, tanporon kon itesa' pe te'san repa mɨrɨ miyarɨ rɨ ipona, e'tane kʉrɨ ɨ'rɨ esa' pen nɨ enapai imo'ka mɨrɨ itenawon nʉ'kwɨ rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mɨrɨpan kamoro ui'se pʉra iye'sa' kon nʉ'san kin pe, uyeyaton non, kota'ma uya mɨrɨ. To' ine'tɨ', mɨrɨpan kon tʉ'ka kon pa uyenu airɨ,’ ta'pʉ iya,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Mɨrɨ panton ekama iya tʉpo, to' pokon pe Sises utɨ'pʉ Surusiran pona. ");
INSERT INTO akeNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Pe'pake mɨrɨ awonsi'kɨ Pe'tani eporo iya koro'tau i'kʉrʉ Are' Wʉpʉ tato' airɨ, asa'rɨ tʉpoitorʉ ton ennoko'pʉ iya, tai'ma to' pɨ', ");
INSERT INTO akeNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Entantɨ' ɨyentau'nokon na'ne' eke iwa pata ya'. Mɨrɨ yau ɨyepa'ka kon pe rɨ isa'ka'si mʉre ewa'tɨsa' eporo auya'nokon mɨrɨ, ɨnʉ' rɨ utɨ'pʉ rʉ'pʉ pen ipo. Teukai' mʉne'tʉi' serɨ ya'. ");
INSERT INTO akeNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ɨnʉ' uya rɨ ɨyekama'po kon yau, ‘Ɨ'rɨto' pe euka auya'nokon?’ tukai', ‘Itepuru esi i'se,’ mʉkatʉi',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kamoro si enno'sa' kon uya eporo'pʉ mɨrɨ tasa' iya rʉ'pʉ awɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","To' uya euka tane, itesanon uya to' ene'pʉ, mɨrɨpan kon uya, “Ɨ'rɨto' pe euka auya'nokon?” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","“Itepuru esi i'se,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","To' uya ine'kaa'pʉ Sises piya', tʉpon kon tʉpɨtʉ'pʉ to' uya isa'ka'si a'poi pona, mɨrɨpan pona Sises tʉrʉ'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Itɨ koro'tau, ka'pon amʉ' uya tʉpon kon ta'nʉkʉ'pʉ asanta tawɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","A'ko pe si Are' Wʉpʉ piyapai, tʉutɨsen asanta epokapʉ iya a'tai, anpisin pe te'san ipoitorʉ ton e'sara'tɨ'pʉ Papa apurɨpɨtʉ pɨ', tʉukɨ'pɨ'nʉnpɨ'se eke pe, pori' pe tesi kon pɨ', apʉne pʉra tanporon nɨ eke Papa tʉrawasooi rɨ ku'pɨ'sa' Sises uya ensa' tʉuya'nokon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Pori' pe kin esi Itepuru ese' yau nʉye'ai'ne'!” “Tʉusewankamai' pʉra Epʉn yau nesii, mɨrɨ awonsi'kɨ eke pe iku'to' nesii ka'tau!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tʉron kon si Pari'si amʉ' anpisin koro'tau te'san uya ta'pʉ Sises pɨ', “Ti'sa, ɨpoitorʉ ton e'paka'to' pe to' esereme'kɨ!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","E'tane Sises uya ta'pʉ to' pɨ', “To' e'paka'sa' a'tai, tɨ' amʉ' rɨ nɨrɨ e'sara'tɨ mɨrɨ ukɨ'pɨ'nʉnpɨ' nɨ pɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Sises uya si Surusiran enkapʉ esi'pʉ, Are' Wʉpʉ ponsi'kɨ, mɨrɨ pata awonsi'kɨ ka'pon amʉ' wenai ikaramʉ e'sara'tɨ'pʉ, mɨrɨpan uya ta'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Serɨ pe rɨ ito'ka'nʉ'sa' auya'nokon a'tai, ɨ'rɨ uya usewankaman pʉra na'ne' kupʉ tukai', Papa uya rɨ ɨusewankama kon pʉra rɨ ikupʉ, e'tane serɨ pe Papa uya ito'ka'nʉkʉ auya'nokon namai' onansa' man. ");
INSERT INTO akeNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Iweyu uye'nɨ pɨ' man ɨsɨ rɨ e'ku'to' oton ɨpɨ'nokon, ɨyeyaton kon amʉ' uya tɨ' amʉ' ka'to' oton apata'se' kon woi tekainʉnto' kon ipoi pe ɨwɨse'na'nokon. Sen winɨ'ne rɨ to' uya awa'kʉ'pɨ'to' oton kon ayainʉmʉ kon poken pʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","To' uya ama'tanʉkʉ kon apata'se' kon pokon pe rɨ, ipʉra rɨ to' uya ima'tanʉ'to' oton enpɨ'ton pʉra rɨ, apʉne pʉra Papa uye'to' ɨpika'tɨi'nokon to'ka'nʉ'sa' auya'nokon pʉra iyesi pɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Mɨrɨpan ewomʉ'pʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' pʉ'kʉ ta', mɨrɨpan e'sara'tɨ'pʉ kʉrʉpo'po pɨ' te'san enpa'kapɨtʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“Iye'menukasa', ‘Uiwʉ' e'to' esi ɨpʉreman nɨto' iwʉ' pe,’ tawon; e'tane ‘ama' amʉ' en pe rɨ’ iku'sa' auya'nokon man!” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Wʉi kaisarɨ rɨ, enupan pɨ' iyesi'pʉ use'man nɨto', ɨpʉreman nɨto' iwʉ' tau. E'tane Papa ena' use'man nɨto' tʉrawasomanin nan epuru ton, Main pɨ' enupanin nan, mɨrɨ awonsi'kɨ ka'pon amʉ' koro'tau te'san itepuru ton esi'pʉ ɨnwɨpai, ");
INSERT INTO akeNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","mɨrɨpan e'tane ama'ai iwɨto' tʉuya'nokon eporo i'se to' e'tane, to' uya eporo pʉra iyesi'pʉ, apʉne pʉra ka'pon amʉ' esi'pʉ ipan pe rɨ imaimu eta pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tʉron nɨ wʉi a'tai kanan, ka'pon amʉ' enupa pɨ' mɨrɨ awonsi'kɨ wakʉ itekare ekama pɨ' Sises esi koro'tau use'man nɨto', ɨpʉreman nɨto' iwʉ' pʉ'kʉ tau. Papa ena' use'man nɨto' tʉrawasomanin nan epuru ton, Main pɨ' enupanin nan mɨrɨ awonsi'kɨ Esuwerʉ amʉ' epuru ton uyee'pʉ ipiya', ");
INSERT INTO akeNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","mɨrɨpan kon uya ekama'po'pʉ, “Ɨ'rɨ meruntɨrʉ winɨ serɨ ton kupʉ auya; ɨnʉ' uya serɨ meruntɨ ke ɨrepa'pʉ?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Entakanoma'pʉ iya, “Ɨyekama'po uya 'nokon nɨ marɨ. Ekamatɨ' upɨ', ");
INSERT INTO akeNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Isaan uya pa'taisiman nɨto'—Epʉn winon pe pe' iyesi'pʉ, ka'pon winon pe katɨ iyesi'pʉ?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Mɨrɨpan kon usaurokʉ'pʉ tiwano' kon pe, “‘Epʉn winon’ ta pe iyesi yau, ekama'pon nɨ iya, ‘Ɨ'rɨ pe ken iyesi pɨ' apurɨ auya'nokon pʉra iyesi'pʉ?’ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","E'tane, ‘Ka'pon amʉ' winɨ’ ta pe iyesi yau, ka'pon amʉ' uya nin si uwɨnɨ'nokon mɨrɨ tɨ' ke, apʉne pʉra Isaan apurɨ to' uya pu'kena' Papa winon tukai',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mɨrɨpan kon uya nin si Sises maimu eikʉ'pʉ mɨrɨ, “Ewai' nawon, ina uya i'tu pʉra rɨ man nai winon pe iyesi'pʉ tukai',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mɨrɨpan Sises uya ta'pʉ to' pɨ', “Ekamasa' auya'nokon pʉra iyesi ke, ekama uya pʉra rɨ kanan iyesi ɨpɨ'nokon ɨ'rɨ meruntɨrʉ winɨ serɨ ton kupʉ uya tukai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Mɨrɨpan kon pɨ' panton ekama'pʉ iya, “Ka'pon uya kʉre' itese' si'na' pe te'sen kiyari ye' patama'pʉ tʉmainarʉ yau, mɨrɨpan tʉrʉ'pʉ iya umɨ pɨ' te'san ena'. Mɨrɨpan utɨ'pʉ tʉron nɨ pata ya' ɨko'manse'na inke rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Iyakʉ'pʉsa' anʉmʉ weyu e'seposa' a'tai nin si, tʉpoitorʉ enno'kaa'pʉ iya umɨ tʉrʉ'pʉ tʉuya itena' ton piya' tʉrepato' pe to' uya tʉmainarʉ yawon ke, e'tane si kamoro uya ipanta'ma'pʉ, mɨrɨpan ennoko'pʉ to' uya itemiyatʉ arʉ pʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mɨrɨ awonsi'kɨ kanan tʉron nɨ tʉpoitorʉ enno'kaa'pʉ iya, mɨrɨpan kanan panta'ma'pʉ to' uya, mɨrɨ awonsi'kɨ ɨri pe rɨ to' uya ikupʉ'pʉ, mɨrɨpan enna'po'pʉ itemiyatʉ arʉ pʉra rɨ marɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mɨrɨ rɨ e'tane, to' osorʉwano pe tʉron nɨ kanan tʉpoitorʉ enno'kaa'pʉ iya, mɨrɨpan nɨ marɨ panta'makaa'pʉ to' uya ɨsɨ pe kuru rɨ, mɨrɨpan enpa'ka'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Mɨrɨ a'tai kiyari e'kwa esa' uya ta'pʉ, ‘Ɨ'rɨ ken si kupʉ uya serɨ? Uni'nʉnkanʉ rɨ nin si umu ennoko uya serɨ; to' uya nin si inama mɨrɨ,’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","E'tane si to' uya ensa' a'tai, ipɨ' to' usaurokʉ'pʉ. ‘Pʉse rɨ kuru pʉse rɨ inonka'pʉ anʉnton. Iwɨpai'nokon, inanʉmʉnʉ kiyari pata'se' anʉnto' kon pe uiwano' kon pe,’ ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Mɨrɨpan nin si eno'ma'pʉ to' uya kiyari e'kwa yapai, mɨrɨpan wɨnɨ'pʉ to' uya. “Ɨ'rɨ ken si kupʉ kiyari e'kwa esa' uya mɨrɨ to' pɨ': ");
INSERT INTO akeNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Iye'to' oton si, kamoro itesa' pe tʉnnonka'san tʉ'kase'na, mɨrɨpan uya tʉron kon ena' kiyari e'kwa nonkato' oton,” ta'pʉ Sises uya. Ka'pon amʉ' uya serɨ etasa' a'tai, “Serɨ e'pai pʉra rɨ man!” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Sises uya to' ene'pʉ, mɨrɨpan kon ekama'po'pʉ iya, “Ɨ'rɨ ken si ta e'kwa pe iye'menukasa' esi: “‘Ɨutɨ amɨnin nan neno'ma'pʉ rʉ'pʉ tɨ' enasa' itekun airɨ te'sen tɨ' pe,’ tawon? ");
INSERT INTO akeNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Tanporon kon mɨrɨ tɨ' pona nʉta'mo'kayai'ne' nan utakiti'kwa mɨrɨ, e'tane ipona tɨ' nʉta'mo'kayai'ne' uta'si'kɨrɨ mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Main pɨ' enupanin nan mɨrɨ awonsi'kɨ use'man nɨto' tʉrawasomanin nan epuru ton esi'pʉ inke pʉra a'sito' tʉuya'nokon ipɨkɨrɨ warinpa pɨ', apʉne pʉra serɨ panton ekamasa' iya tʉpɨ'nokon ta iya e'kwa pe tukai', e'tane to' enari'nʉmʉ'pʉ ka'pon amʉ' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","A'ko pe ipa'sima pɨ' to' esi'pʉ, mɨrɨpan kon uya wakʉ ton pe itese' ka'pon amʉ' ennoko'pʉ ama'ai Sises maimu etase. Mɨrɨ wenai eparankato' pe tʉuya'nokon Roman amʉ' kopʉnaai ena' a'sito' pe iya. ");
INSERT INTO akeNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mɨrɨpan kon uya Sises ekama'po'pʉ, “Ti'sa, ina uya i'tu ausaurokʉ mɨrɨ awonsi'kɨ enupan auya ipokenan pɨ' mɨrɨ awonsi'kɨ ka'pon amʉ' menkanin pen ɨmɨrɨ, e'tane Papa eseru pɨ' enupan auya i'napairon awɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ipoken pe' iyesi Sisa ena' pʉrata tʉtʉsen e'ma ina uya a'tai, kane katɨ?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tenku'tɨpai to' esi poro tense to' pɨ' ta'pʉ iya, ");
INSERT INTO akeNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Apʉne, pʉrata pun enpoikatɨ' uyena'. Ɨnʉ' nai, ɨnʉ' ese' nai ipɨ'?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Mɨrɨpan kon uya eikʉ'pʉ, “Sisa,” tukai'. Mɨrɨpan uya ta'pʉ to' pɨ', “Mɨrɨ wenai, itʉtɨ' ken si Sisa ena' itiwano' pe rɨ te'sen, Papa ena' kanan itiwano' pe rɨ nɨrɨ te'sen tʉrʉi'ma,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mɨrɨ yau, annau isauro'to' winɨ to' uya isa'mato' pʉra rɨ iyesi'pʉ. Mɨrɨpan kon usewansiuka'pʉ ei'pɨtʉ iya pɨ', mɨrɨpan kon e'pakaa'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Satu'si amʉ' tonpa ton eri'nɨ tʉpo e'mʉ'sa'kan pʉra iyesi tawon nan uyee'pʉ Sises piya' ekama'pose'na. ");
INSERT INTO akeNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Mɨrɨpan kon uya ta'pʉ ipɨ', “Ti'sa, Mosi' uya imenukasa' uiwano' kon pe, ka'pon rui eri'sa' yau, tʉno'pʉ tʉnonkai' imunkɨ pʉra, iyakon nʉ'pʉ uya tʉrui no'pʉ rʉ'pʉ mari'mato' pe iyesi imu'tanʉ'to' pe tʉuya tʉrui iwano' pe. ");
INSERT INTO akeNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Moro si 7 kaisaron kon ɨsirunan esi'pʉ. Wapiyaro' emari'ma'pʉ, mɨrɨpan erikʉ'pʉ imʉre pʉra. ");
INSERT INTO akeNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mɨrɨpan akon nʉ'pʉ uya ino'pʉ rʉ'pʉ mari'ma'pʉ, mɨrɨpan kanan erikʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","To' osorʉwano rʉ'pʉ uya kanan imari'ma'pʉ, mɨrɨpan kanan erikʉ'pʉ. Mɨrɨ kasa tanporo 7 pan kon uya imari'mapɨtʉ'pʉ, mɨrɨpan 7 pe rɨ to' erikʉ'pʉ tʉmunkɨ ke pʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mɨrɨpan kon e'ma'pʉ pe, to' no'pʉ rʉ'pʉ rɨ marɨ eri'kaa'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Eri'nɨ tʉpo e'mʉ'sa'kan nɨsa' a'tai, ɨnʉ' kuru no'pʉ pe ken si iyesi, tanporo 7 kaisaron kon uya imari'masa' pɨ'?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Sises uya to' entakanoma'pʉ, “Serɨ a'taino kon emari'ma, mɨrɨpan kon e'tʉrʉ emari'man nɨto' yau. ");
INSERT INTO akeNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","E'tane nin si tɨ, kamo emenna' pe uko'man nɨto' yau te'san, wakʉ tato' kon Papa uya ipɨ', terikʉ kon tʉpo iye'mʉ'sa'kasa' kon emari'ma pen nɨ nin, mɨrɨ pe pʉra to' e'tʉrʉ pen nɨ nin emari'man nɨto' yau, ");
INSERT INTO akeNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","apʉne pʉra mɨrɨ enta' to' erikʉ pen, inserʉ amʉ' kasa rɨ nin si to' esi. Papa munkɨ pe to' esi, eri'nɨ tʉpo e'mʉ'sa'kan nɨsa' munkɨ pe to' esi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","E'tane yu' epo'tɨ ekareei yau, Mosi' uya rɨ enpoikasa' iyeri'sa' kon e'mʉ'sa'ka, apʉne pʉra Itepuru esakʉ iya, ‘Papa, Epʉra'an e'to' itese' pɨ', Aisi' e'to' itese' pɨ' mɨrɨ awonsi'kɨ Seko' e'to' itese' pɨ' tukai',’ ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Papa, iyeri'sa' kon e'to' itese' pɨ' pen, e'tane nurɨnan kon, apʉne pʉra tanporo ipona nurɨne to' esi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tʉron kon Main pɨ' enupanin nan uya ta'pʉ Sises pɨ', “Ti'sa, wakʉ pe kuru ei'sa' auya man,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mɨrɨ awonsi'kɨ ɨnʉ' rɨ esi'pʉ mɨrɨ enta' ɨnekama'popɨ'pai pʉra. ");
INSERT INTO akeNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mɨrɨ a'tai, Sises uya ta'pʉ to' pɨ', “Ɨ'rɨ pe iyesi pɨ' to' uya Kʉrai esi Tepi' pa rʉ'pʉ pe ta? ");
INSERT INTO akeNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tepi' uya rɨ ekamasa' Eren apon yau: “‘Itepuru uya ta'pʉ uyepuru pɨ': “Ereutakɨ uyenwo'netʉ winɨ, ");
INSERT INTO akeNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ɨyeyaton non ku'tane uya a'ta apon pe,”’ tasa'. ");
INSERT INTO akeNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tepi' uya esakʉ ‘uyepuru’ tukai'; nai kasa ken si Tepi' pa rʉ'pʉ pe iyesi?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mɨrɨ a'tai, Sises uya ta'pʉ tʉpoitorʉ ton pɨ' tanporon kon uya rɨ eta tane, ");
INSERT INTO akeNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ti'tui' e'tɨ' Main pɨ' enupanin nan pɨ'. Ɨpininpaino kon kusan tʉpon kon yau mɨrɨ awonsi'kɨ, ‘Miyarɨ,’ ta i'sero' kon tʉpɨ'nokon kʉrʉpo'po pɨ' e'nɨ pata'se' yau, eke ton apon po te'san Esuwerʉ amʉ' usenupato' iwʉ' tau mɨrɨ awonsi'kɨ tʉnamasan pata'se' yau kuru te'san enta'nan a'tai'ne. ");
INSERT INTO akeNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Itaan'pʉ ima'tasa' kon nʉ'san iwʉ' ma'tanʉkʉ to' uya, mɨrɨpan kon ɨpʉrema kusan pe rɨ wakʉ ton tato' pe tʉpɨ'nokon. Ipan pe rɨ mɨrɨ waraino kon ekota'mato' oton,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Sises uya tenu tʉsa' koro'tau, ipʉrataaike' ton uya pʉrata tʉrʉ ene'pʉ iya Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' pʉrataai yen ya'. ");
INSERT INTO akeNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Entu'manin nʉ'kwɨ kanan itaan'pʉ ima'tasa' rʉ'pʉ uya asa'ron nʉ'kwɨ aiko ton pʉrata, ka'pa pun tʉrʉ ene'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","“I'napairon ekama uya ɨpɨ'nokon; pʉse rɨ entu'manin nʉ'kwɨ itaan'pʉ ima'tasa' rʉ'pʉ uya itʉsa' eke pe tanporon kon nʉtʉrʉ'pʉ entai rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tanporo pʉsamoro uya itʉsa' eke rɨ nin tʉpʉrataai kon tonpa; e'tane kʉrɨ rɨ tekota'mato' apai rʉ'kwɨ rɨ tanporo rɨ tʉpiyawon tʉrʉ'pʉ tʉuko'manto' ipɨ' rʉ'kwɨ rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sises poitorʉ tonpa ton usaurokʉ'pʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' pɨ' wakʉ pe rɨ isene pɨ' tɨ' ke itamɨsa', Papa ena' use'man nɨsa' rʉ'pʉ ike ton nɨ usene wakʉ pe. E'tane Sises uya ta'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Serɨ yau menyatʉi'ne' pɨ' nin si ta uya, iweyu e'seporo mɨrɨ mɨ pe rɨ tikin nɨ tɨ' e'nonkato' oton pen nɨ ɨsipʉro'po, tanporon nɨ uta'po'to' oton,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mɨrɨ a'tai, to' uya ekama'po'pʉ, “Ti'sa, ɨ'rɨ a'tai serɨ ton e'ku'to' oton? Ɨ'rɨ kuru ken si esi ento' ipɨ' pe e'ku'ka'nɨ pɨ' iyesi ekamanin pe?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","To' eikʉ'pʉ iya: “Tenu ke e'tɨ' ɨyenku'tɨ kon namai'. Apʉne pʉra tu'kan kon nɨ uye'to' oton uyese' yau, ‘Urɨ rɨ kʉrɨ rɨ,’ ka'se'na, mɨrɨpan, ‘Iweyu man a'ko pe,’ ta to' uya. To' pɨkɨrɨ ke'tʉu. ");
INSERT INTO akeNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Usewa'noman mɨrɨ awonsi'kɨ tepuru kon ɨneno'mapaino kon eta auya'nokon a'tai, kenari'nʉntʉu. Serɨ ton nɨ e'kupʉ mɨrɨ wapiya, e'tane inke pʉra pata weyu u'matʉ uyepʉ pen nɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Mɨrɨ a'tai, ta'pʉ iya to' pɨ', “Tʉpataron kon uya tʉpataron kon nɨ nɨrɨ ewa'nomato' oton, mɨrɨ awonsi'kɨ esa' wannɨ pe te'san uya esa' wannɨ pe te'san nɨ nɨrɨ ewa'nomato' oton. ");
INSERT INTO akeNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Eke pe kuru rɨ tʉrʉ'pʉnʉ amʉ' iwankan mɨrɨ awonsi'kɨ paran amʉ' e'to' oton pata ton yau'ne' mɨrɨ awonsi'kɨ nari'panin nɨ e'ku'to' oton mɨrɨ awonsi'kɨ eke rɨ ento' ipɨ' ton Epʉn apai e'to' oton. ");
INSERT INTO akeNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“E'tane serɨ rawɨrɨ, to' uya aya'sito' oton kon, ɨkota'mato' oton kon to' uya. Usenupan nɨto' iwʉ' ta' mɨrɨ awonsi'kɨ pariki'si ta', kin amʉ', kopʉna amʉ' rakʉi' nɨrɨ to' uya ɨtʉto' oton kon, tanporo serɨ esi uyese' uriya'. ");
INSERT INTO akeNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Uyekareei ekamato' auya'nokon oton to' pɨ' serɨ moron nʉ'pʉ pe. ");
INSERT INTO akeNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","E'tane ekonekatɨ' rɨken pena rɨ ɨusewankama kon namai', nai kasa kuru si e'wapu'tɨ ta auya'nokon namai'. ");
INSERT INTO akeNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Apʉne pʉra amaimu'tɨto' uya 'nokon oton mɨrɨ awonsi'kɨ ɨyemeporʉ'tɨ uya 'nokon ausauro'to' kon ike ke ɨyeyaton kon uya, ‘Kasi pe ɨwesi,’ ta namai' ɨpɨ'nokon. ");
INSERT INTO akeNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ɨmɨrɨ'nokon nɨ eparankato' oton asanon kon uya rɨ, ɨtonpa kon amʉ' uya rɨ. To' uya ɨtonpa kon tʉto' oton eri'nɨto' ya'. ");
INSERT INTO akeNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tanporon kon ka'pon amʉ' uya rɨ ɨyewaruma'tɨto' oton kon urɨ uriya'. ");
INSERT INTO akeNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","To' uya rɨ ɨwɨsa' kon e'tane, aya'kwarʉ kon nɨ mainanpa uya. ");
INSERT INTO akeNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Pana' pe ɨye'mʉ'sa'ka kon winɨ ɨuko'manto' kon eporo auya'nokon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Sises uya ta'pʉ, “Soisa amʉ' amʉrasa' ene auya'nokon a'tai Surusiran woi, i'tu auya'nokon mɨrɨ to' uya ima'tanʉkʉ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tɨwɨ kamoro Isutiya po na'ne' nan nainʉmʉi wʉ' ton pona'ne; tɨwɨ kamoro eke pata yawon kon nepa'kai, mɨrɨ awonsi'kɨ kamoro pata yau na'ne' nan kʉsepa'kanin eke pata pona. ");
INSERT INTO akeNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Serɨ ta uya, apʉne pʉra mɨrɨ si e'to' oton, Papa uya Surusiran yawon kon kota'ma weyu pe, serɨ e'kupʉ mɨrɨ pu'kena' amʉ' nʉmenuka'pʉ a'ku'tɨ pe. ");
INSERT INTO akeNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mɨrɨ a'tai'ne ɨsɨ pe kuru rɨ uri'sami'si amʉ' mono' pe te'san pona iye'to' oton mɨrɨ awonsi'kɨ mana' pokon kon imunkɨ pona. Ipan pe rɨ usewankaman e'to' oton non po, mɨrɨ awonsi'kɨ ekota'man nɨto' e'to' oton pʉsamoro ka'pon amʉ' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Soisa amʉ' uya tu'kan kon nɨ Esuwerʉ amʉ' tʉ'kato' oton, mɨrɨpan tʉron kon a'sisa' kon Esuwerʉ amʉ' ato' oton to' uya pata amʉ' kaisarɨ rɨ. Ka'pon amʉ', Esuwerʉ amʉ' pen uya Surusiran ma'tanʉ'to' oton ipan pe rɨ. To' uya ikupʉ weyu pe Papa nʉkupʉ'pʉ u'matʉ pʉ'kʉ pona,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“I'tuto' ipɨ' ton e'ku'to' oton wʉi enu yau, kapʉi yau mɨrɨ awonsi'kɨ sirikɨ amʉ' yau. Non po tʉpataron kon e'to' oton ɨsɨ rɨ i'tu pɨ', etʉipɨ' nɨ pɨ' parau a'merumʉ mɨrɨ awonsi'kɨ iyenu'pɨtʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ka'pon amʉ' enato' oton ɨ'sɨ'mʉra tetʉipɨtʉ kon ke, tʉuye'sen non pona i'tu tʉuya'nokon pɨ', apʉne pʉra ka' yawon kon nɨ usi'ki'mato' oton pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mɨrɨ a'tai si, to' uya Ka'pon, Papa winon ento' oton uyepʉ kapuru' yau tʉmeruntɨrʉ ke, mɨrɨ awonsi'kɨ eke rɨ a'kwarʉ pokon pe. ");
INSERT INTO akeNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Serɨ e'kupʉ e'sara'tɨ ene ɨmɨrɨ'nokon upoitorʉ ton uya a'tai, mepori'matʉi' si, itenupɨkɨrɨ esii'ma, apʉne pʉra serɨ esi a'ko pe rɨ Papa uya ɨpika'tɨto' kon esi ekamanin pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mɨrɨ a'tai, tʉpoitorʉ ton pɨ' panton ekama'pʉ iya, “Apʉne kiyari ye' ito'ka'nʉ'tɨ'; tanporon nɨ sa'ne yʉi amʉ'. ");
INSERT INTO akeNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Itare'kasa' rʉ'pʉ atu'ta a'tai, tanporon kon uya i'tu iyepetato' oton tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mɨrɨ kasa rɨ marɨ si tɨ, serɨ ɨsɨ ton e'kupʉ ene auya'nokon a'tai, i'tu auya'nokon kuru rɨ a'ko pe rɨ Papa e'to' esa' wannɨ pe weyu e'seporo. ");
INSERT INTO akeNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“I'napairon ekama uya ɨpɨ'nokon, serɨ a'taino kon kuru rɨ pʉra iyenato' oton pen nɨ serɨ ton e'kupʉ pʉ'kʉ pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tanporon nɨ ka' po na'ne', non po na'ne', mɨrɨ awonsi'kɨ non nɨ nɨrɨ pʉra iyenato' oton, e'tane umaimu mɨrɨ tereutaton pen nɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Sises uya ta'pʉ tʉpoitorʉ ton pɨ', “Ti'tui' e'tɨ', wakʉ pɨ' ɨusenuminkato' kon piyapai ayano'manin kon pɨ'. Ke'taripatʉu, e'tari ton nʉkupʉnʉ kʉ'ku'tʉu, serɨ non pon pɨ' rɨ aya'kwarʉ kon kʉsainʉnpatʉu. Mɨrɨ ku'sa' auya'nokon yau, iyekonekasa' pe pʉra rɨ ɨwesi kon koro'tau ɨyeporo uya 'nokon mɨrɨ ite'kwanau pʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ɨpɨ'nokon iye'kupʉ pe pʉra kʉsekamatʉu, apʉne pʉra tanporon kon, mɨ yawɨron kon pɨ' rɨ iye'ku'to' oton mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mɨrɨ wenai, ti'tui' rɨ tenu ke rɨ e'tɨ', ɨpʉrematɨ' Papa uya ɨpika'tɨto' kon pe ɨsɨ ton te'ku'sen awɨrɨ wakʉ pe ɨyepa'ka kon pa. Ɨpʉrematɨ' rɨ kanan wakʉ pe te'mʉ'sa'kasen pe ɨwesi kon pa Ka'pon, Papa winon rau,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Wʉi kaisarɨ rɨ, ka'pon amʉ' enupa pɨ' Sises esi'pʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' pʉ'kʉ tau. Ko'mamʉ pe'ne nin si tɨ, itɨpɨtʉ'pʉ Are' Wʉpʉ pona e'nʉnse'na. ");
INSERT INTO akeNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Awanakʉi' kuru rɨ kanan, tanporon kon tenupa iya 'nokon etanin nʉ'san uye'pɨtʉ'pʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' pʉ'kʉ ta' tenupato' kon iya etase'na. ");
INSERT INTO akeNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","A'ko pe si A'sarutanʉ'sa' Pen Pʉreti Pɨ' Enta'nan Weyu, To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ tato' pɨ' enta'nan weyu e'seporo esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru mɨrɨ awonsi'kɨ Main pɨ' enupanin nan esi'pʉ Sises ma'tanʉ'to' tʉuya'nokon winɨ eporo i'se, ama'ai, apʉne pʉra ka'pon amʉ' pɨ' tenari'nʉmʉ kon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mɨrɨpan a'tai, Se'tan ewomʉ'pʉ Isutas, Eskariya' tato' ipɨ' ya', 12 kaisaron kon ipoitorʉ ton tonpa pe te'sen. ");
INSERT INTO akeNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Mɨrɨ a'tai si, Isutas utɨ'pʉ use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru mɨrɨ awonsi'kɨ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' pa'simanin nan piya'. Mɨrɨpan kon a'kɨrɨ usauro'nɨ pɨ' iyesi'pʉ Sises eparankato' tʉuya pɨ' to' uya a'sito' pe. ");
INSERT INTO akeNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","To' epori'ma'pʉ, mɨrɨpan pʉrata ke irepa pɨ' to' e'kama'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Mɨrɨpan uya, “Ewai',” ta'pʉ, mɨrɨpan esi'pʉ Sises tʉto' tʉuya weyu eporo i'se, anpisin pe ka'pon amʉ' esi a'tai pʉra. ");
INSERT INTO akeNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mɨrɨ a'tai A'sarutanʉ'sa' Pen Pʉreti Pɨ' Enta'nan Weyu e'seporo'pʉ karimeru mʉre wɨto' Itepoi Itɨ'pʉ Weyu Rʉ'pʉ iwano' pe. ");
INSERT INTO akeNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Sises uya Pi'ta mɨrɨ awonsi'kɨ Isaan ennoko'pʉ, tai'ma to' pɨ', “Entantɨ' enta'nan nɨto' To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ pɨ' ikonekatantɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“Nai yau ken si ina uya ikoneka i'se ɨwesi ite'ma ta'?” tukai' to' uya ekama'po'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","To' eikʉ'pʉ iya, “Eke pata pona ɨyepa'kasa' kon a'tai, ka'pon tuna yen anin uya ɨyeporo kon mɨrɨ. Mɨrɨpan pɨkɨrɨ ɨutɨ newonyai'ne' ta' mʉtɨtʉi'. ");
INSERT INTO akeNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mɨrɨpan ɨutɨ esa' pɨ' mɨkatʉi', ‘Ti'sa man, nai yau tʉpoitorʉ ton pokon pe To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ pɨ' tenta'na kon tukai' ɨni'tupai.’ ");
INSERT INTO akeNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kʉrɨ rɨ ka'pon uya ka'tawon eke ɨutɨ ekama mɨrɨ tanporon nɨ e'to' itau. Mɨrɨ yau si tanporon nɨ mʉkonekatʉi',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mɨrɨpan kon utɨ'pʉ nin si mɨrɨ, to' uya eporo'pʉ Sises uya ekama'pʉ poro rɨ. Mɨrɨpan kon uya si To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ pɨ' te'to' kon koneka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Iweyu e'sepoka'sa' a'tai, Sises mɨrɨ awonsi'kɨ ipoitorʉ ton enapɨtʉ'pʉ tʉteire' kon po tepʉrʉ piyau. ");
INSERT INTO akeNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mɨrɨpan uya ta'pʉ to' pɨ', “Aya'kɨrɨ'nokon kuru rɨ enta'napai e'sa' serɨ To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ i'kiyari pɨ', ukota'ma to' uya rawɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ekama uya ɨpɨ'nokon, enta'nato' oton pen ipɨ' kanan, Papa na'ne' esa' wannɨ pe yau e'seposa' a'tai rɨken kanan enta'nan,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Sises uya ko', waain yen anʉmʉ'pʉ temiyatʉ ya', mɨrɨpan uya tenki ta'pʉ Papa pɨ', mɨrɨpan tʉpo tʉpoitorʉ ton pɨ' ta'pʉ, “Akaisarɨ'ne'nokon se waain, ko' yawon ensitɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Apʉne pʉra ekama uya ɨpɨ'nokon, iteperu euku ensito' uya oton pen, Papa e'to' esa' wannɨ pe uyepʉ pʉ'kʉ pona,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Mɨrɨpan uya pʉreti anʉmʉ'pʉ, tenki ta'pʉ iya Papa pɨ', mɨrɨpan i'kwɨ'pɨtʉ'pʉ iya, mɨrɨpan ekamʉ'pʉ iya to' ena', tai'ma to' pɨ', “Serɨ serɨ upun iye'tʉsa' ɨiwano' kon pe; serɨ iku'tɨ' ɨyenu kon yau ukupʉ auya'nokon ekamanin pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mɨrɨ kasa rɨ marɨ tenta'na tʉpo, ko' anʉmʉ'pʉ iya. To' pɨ' ta'pʉ iya, “Serɨ ko' esi emenna' pe ekonekan nɨto' umʉnʉ yau, ɨiwano' kon pe iye'kwansa'. ");
INSERT INTO akeNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","E'tane kʉrɨ rɨ uyeparanka ton emiya esi uyemiya pokon pe rɨ tepʉrʉ po. ");
INSERT INTO akeNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ka'pon, Papa winon utɨto' oton tʉpɨ' isekamasa' na'ne' kasa rɨ, e'tane ɨsɨ yau rɨ kʉrɨ rɨ ka'pon esi eparankanin,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mɨrɨpan ipoitorʉ ton usekama'popɨtʉ'pʉ, “Ɨnʉ' kuru rɨ si u'koro'tawon kon uya serɨ ku'to' oton?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mɨrɨpan kon si e'sara'tɨ'pʉ tiwano' kon pe rɨ e'sei'pɨ' nɨ pɨ' ɨnʉ' kuru e'to' oton eke pe tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Sises uya ta'pʉ to' pɨ', “Kin amʉ' Esuwerʉ amʉ' pen esanon esi to' esa' pe, mɨrɨ awonsi'kɨ kamo tʉmeruntɨrʉ kon apurɨnin nan to' pɨ' e'sesakʉ ‘ka'pon amʉ' pika'tɨnin nan’ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","E'tane mɨrɨ kasa ɨwe'to' kon pe pʉra iyesi. E'tane ru'ku, eke pe na'ne' ɨ'koro'tau'nokon e'to' pe iyesi a'mi'pɨ wannɨ kasa, mɨrɨ awonsi'kɨ esa' wannɨ, apiyo' wannɨ kasa. ");
INSERT INTO akeNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ɨnʉ' rupɨ esi eke pe, iyereutasa' na'ne' enta'nan pɨ', mɨrɨ pe pʉra apiyo' wannɨ katɨ? Enta'nan pɨ' iyereutasa' na'ne' esi eke pe ɨpona, tʉusekansen entai, e'tane urɨ esi ɨpiyau'nokon tʉusekansen kasa. ");
INSERT INTO akeNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ɨmɨrɨ'nokon kamoro uya'kɨrɨ iye'sa' kon ui'tupɨ'to' yau'ne rɨ, ");
INSERT INTO akeNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","mɨrɨpan uya rɨ ɨkupʉ kon kin pe ɨwesi kon pa ukʉipʉnʉ uya rɨ uku'sa' na'ne' kasa itesa' pe e'to' pe, ");
INSERT INTO akeNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ɨyenta'na kon pa mɨrɨ awonsi'kɨ ensi kon pa utepʉrʉʉi po esa' wannɨ pe e'to' yau mɨrɨ awonsi'kɨ ɨyereuta kon pa apono' po 12 kaisaron kon Esuwerʉ pon kon eseru aimenka pɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Mɨrɨ a'tai si, Sises uya Pi'ta pɨ', “Saiman, Saiman,” ta'pʉ, “apʉne uyetakɨ. Se'tan uya Papa ekama'posa' man ɨi'tupɨ'to' kon pe tʉuya, ka'pon uya ta'nasi eisika kasa, ");
INSERT INTO akeNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","e'tane ɨpʉremasa' man ɨpona, Saiman, anapurɨnʉ apai ɨyemo'ka namai'. Ɨyenna'posa' pe iyesi a'tai, ɨtonpa ton mʉmeruntɨtanʉkʉi' to' tauro'kai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","E'tane Pi'ta uya ta'pʉ, “Uyepuru, e'kamasa' rɨ serɨ aya'kɨrɨ rɨ pariki'si ta' utɨto' pe mɨrɨ awonsi'kɨ uma'tato' pe rɨ aya'kɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Sises uya eikʉ'pʉ, “Ekama uya serɨ ɨpɨ', Pi'ta, kɨrɨtɨkɨ uturumʉ rawɨrɨ serɨ pe, osorʉwau ite'kwa ui'tunin pe pʉra ɨye'ku'to' oton,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Sises uya to' ekama'po'pʉ, “Ɨyenno'sa' uya 'nokon a'tai, itekare ekamai', ɨpʉrataai kon pʉra, apaikii kon pʉra mɨrɨ awonsi'kɨ asapatooi kon pʉra, ɨ'rɨ rɨ na'kɨ i'se ɨwe'to' kon mʉwarinpata'tʉi'nokon?” ta'pʉ iya. “Kane,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Mɨrɨpan kon pɨ' nin si ta'pʉ iya, “Serɨ pe nin si tʉpʉrataai ke ɨwesi kon a'tai, atɨ' rɨ si aya'kɨrɨ'nokon, mɨrɨ awonsi'kɨ apaikii kon nɨ kanan. Ɨsuparaai kon pʉra iyesi yau, ɨpon kon tʉkʉrʉpo'pomai' ɨsuparaai kon me'matʉi'. ");
INSERT INTO akeNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ekama uya, iye'menukasa' na'ne' upɨ' uta'ku'tɨto' pe rɨ iyesi, ‘Ka'pon amʉ' uya ɨri ton main awɨron kon pen tonpa pe iyesi'pʉ tato' oton,’ tawon. Serɨ iye'menukasa' rʉ'pʉ urɨ pɨ' rɨ uta'ku'tɨ mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ipoitorʉ ton uya ta'pʉ ipɨ', “Apʉne enkɨ, asa'rɨ rɨ supara man ina piyau,” ta'pʉ to' uya. “Mɨrɨ kasa rɨ si e'paka'tɨ', tʉron nɨ enna pɨ' kasauro'tʉu,” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Sises utɨ'pʉ Are' Wʉpʉ airɨ'ne te'pɨ'to' kasa rɨ ipoitorʉ ton uya e'ma'pʉka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pata eposa' tʉuya'nokon a'tai, ta'pʉ iya to' pɨ', “Ɨpʉrematɨ', i'tupɨ'nɨto' ya' auta'mo'ka kon namai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tɨ' eno'mato' enta' rɨ itɨ'pʉ, iye'sekunka'pʉ ɨpʉremase'na. ");
INSERT INTO akeNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Papai, ɨnku'pai ɨwesi yau, serɨ ko' imo'kakɨ uyenapai, e'tane i'se ɨwe'to' awɨrɨ iku'kɨ, i'se e'to' awɨrɨ pen,” ta'pʉ iya.  ");
INSERT INTO akeNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Mɨrɨ ta iya koro'tau, Papa inserʉʉi uyee'pʉ ipiya' imeruntɨrʉ'tɨi'. ");
INSERT INTO akeNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Mɨrɨpan Sises ɨpʉrema'pʉ ipan pe, tʉuta'kwarʉkai', apʉne pʉra pokoi pe tesi pɨ', mɨrɨpan eramu'ta usee'kwa esi'pʉ non pona mʉn kasa. ");
INSERT INTO akeNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tʉwɨpʉrema tʉpo, iye'mʉ'sa'kasa' utɨ'pʉ tʉpoitorʉ ton piya'. To' e'nʉnpɨ'sa' eporo'pʉ iya, pokoi uya to' eketu'kasa'. ");
INSERT INTO akeNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","“Ɨ'rɨto' pe ɨye'nʉmʉ kon? Te'mʉ'sa'kai' ɨpʉrematɨ', i'tupɨ'nɨto' ya' auta'mo'ka kon namai',” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Usauro'nɨ pɨ' rɨ marɨ iyesi koro'tau, anpisin uyee'pʉ to' piya', ka'pon, Isutas tukai' tesa'sen, 12 kaisaron kon tonpa pe te'sen esi'pʉ to' esa' pe. Sises piya' a'ko pe iyee'pʉ a'su'kase. ");
INSERT INTO akeNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","E'tane Sises uya ekama'po'pʉ, “Isutas, Ka'pon, Papa winon pe' eparanka auya mɨrɨ uta'su'kan ke?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ipoitorʉ ton uya te'ku'sen ensa' a'tai, Sises pɨ' ta'pʉ to' uya, “Ina epuru, ina uya pe' si to' panta'ma serɨ tʉsuparaai kon amʉ' ke?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","To' tonpa uya use'man nɨto' tʉrawasomanin nan epuru poitorʉ pana enwo'ne' winon a'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","E'tane Sises uya ta'pʉ tʉpoitorʉ ton pɨ', “Tɨwɨ nesii!” ta'pʉ iya. Mɨrɨpan uya a'pɨtʉ ke rɨ ipana epi'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mɨrɨ a'tai, Sises uya use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru pɨ', use'man nɨto', ɨpʉreman nɨto' iwʉ' pa'simanin nan mɨrɨ awonsi'kɨ itepuru ton tʉkan iye'sa' kon pɨ' ta'pʉ iya, “Main awɨron kon pen pe' esa' pe esi serɨ, ɨuye'sa' kon na'ne' supara amʉ' mɨrɨ awonsi'kɨ wa'tana amʉ' esa' pe? ");
INSERT INTO akeNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Wʉi kaisarɨ rɨ ɨpiyau'nokon esi'pʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' pʉ'kʉ tau. Upɨ' ɨyemiyatʉ kon tʉsa' auya'nokon pʉra iyesi. E'tane serɨ pe ɨweyu kon pe iyesi—ewarupɨ esi pana' pe ɨyesa' kon pe koro'tau,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Mɨrɨ a'tai, ta'sise to' uya arɨ'pʉ use'man nɨto' tʉrawasomanin nan epuru iwʉ' ta'. Pi'ta uya e'ma'pʉka'pʉ ɨnnonsi'kɨ rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","E'tane apo' po'tɨsa' to' uya a'tai pʉroroi aporo' po, mɨrɨpan kon ereutasa' esi'pʉ a'samʉtʉ yau, Pi'ta ereuta'pʉ to' piyau. ");
INSERT INTO akeNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","To' poitorʉ uri'san uya iyereutasa' ene'pʉ apo' weyu ya'. Enpɨtʉ'pʉ iya a'ko pe esii'ma, mɨrɨpan uya ta'pʉ, “Pʉse rɨ ka'pon ne'tai Sises a'kɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","E'tane i'tunin pe pʉra iye'kuu'pʉ. “Ma'non, kʉrɨ rɨ i'tunin pen urɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Emennʉ'pʉ iwa rɨ, tʉron nɨ uya kanan ensa' esi'pʉ, mɨrɨpan uya ta'pʉ ipɨ', “Ɨmɨrɨ sa'ne kʉrɨ rɨ ko to' tonpa,” ta'pʉ iya. “Mooi, kʉrɨ rɨ pen nɨ urɨ!” ta'pʉ Pi'ta uya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tikin ite'kwa kʉra' emiya era'tɨ'pʉ tʉpo'ne rɨ, tʉron nɨ ka'pon uya e'se'ne' pe ipɨ', “I'napai rɨ sa'ne pʉse rɨ esi'pʉ iya'kɨrɨ; apʉne pʉra Kiyarari pon pe iyesi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pi'ta uya eikʉ'pʉ, “Mooi, ipɨ' masauro'atʉi'ne' i'tu uya pʉra rɨ man!” ta'pʉ iya. Usauro'nɨ pɨ' iyesi koro'tau, kɨrɨtɨkɨ uturumʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Itepuru era'tɨ'pʉ to'sa rɨ Pi'ta ense'na. Mɨrɨ a'tai si, Pi'ta uya Itepuru uya tauro'ka'pʉ rʉ'pʉ nee'pʉ tenu ya', “Kɨrɨtɨkɨ uturumʉ rawɨrɨ serɨ pe, osorʉwau ite'kwa unonkato' auya oton,” tawon. ");
INSERT INTO akeNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Mɨrɨpan epa'ka'pʉ, mɨrɨpan ukaramʉ'pʉ ipan pe. ");
INSERT INTO akeNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Sises erasu pe te'san e'sara'tɨ'pʉ isapema pɨ' mɨrɨ awonsi'kɨ iwɨpɨtʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","To' uya itenu auromʉ'pʉ, mɨrɨpan kon uya ekama'po'pʉ, “Pu'kena' pe ekamakɨ! Ɨnʉ' ɨwɨnɨi?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Mɨrɨpan kon usaurokʉ'pʉ eke pe rɨ ɨri pe rɨ tʉsapemai'. ");
INSERT INTO akeNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pata ema'sa' a'tai, ka'pon amʉ' epuru ton—asa'rɨ rɨ use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru mɨrɨ awonsi'kɨ Main pɨ' enupanin nan amʉra'pʉ, mɨrɨpan kon rakʉi' Sises arɨ'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ina pɨ' ɨsekamakɨ, Kʉrai pe ɨwesi yau,” ta'pʉ to' uya. Sises uya to' eikʉ'pʉ, “Usekamasa' yau, uyapurɨ auya'nokon pʉra iyesi; ");
INSERT INTO akeNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ɨyekama'posa' uya 'nokon yau, uyeikʉ auya'nokon pʉra iyesi. ");
INSERT INTO akeNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","E'tane serɨ awonsi'kɨ Ka'pon, Papa winon ereutato' oton meruntɨ pe te'sen Papa enwo'netʉ winɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tanporo esii'ma to' uya ekama'po'pʉ, “Papa Mumu pe ken pe' si ɨwesi?” ta'pʉ to' uya. To' eikʉ'pʉ iya, “Ipoken me'atʉi' kʉrɨ rɨ pe esi mʉkayatʉi'ne',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mɨrɨ a'tai, ta'pʉ to' uya, “Ɨ'rɨto' pe miyarɨ ekamanin i'se e'nɨ? Etaka'sa' sa'ne mɨrɨ ko inta apai,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kamoro si asauro'se iyamʉrasa' kon nʉ'san uya Sises arɨ'pʉ Paire' Isutiya kopʉnaai piya'. ");
INSERT INTO akeNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Mɨrɨ yau, eseru'tɨ pɨ' to' esi'pʉ, “Pʉse rɨ uya ka'pon amʉ' ano'ma, ‘Pʉrata kʉ'nonkatʉu pata esa' ena', urɨ kʉrɨ rɨ Kʉrai pata esa',’ ta iya,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Sises ekama'po'pʉ Paire' uya, “Esuwerʉ amʉ' kin pe' ɨmɨrɨ?” tukai'. Mɨrɨpan eikʉ'pʉ Sises uya, “Ewai', mʉkayai'ne' kasa rɨ,” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Mɨrɨ a'tai, Paire' uya ta'pʉ use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru pɨ' mɨrɨ awonsi'kɨ ka'pon amʉ' pɨ', “Ɨ'rɨ rɨ pʉse rɨ wɨto' ipɨkɨrɨ eposa' uya pʉra man,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","E'tane Sises pɨ' rɨ usauro'nɨ pɨ' to' esi'pʉ, “Eke pe rɨ usewa'noman emapu'tɨ iya pata Isutiya poro rɨ to' enupa ke. Pata Kiyarari po iye'sara'tɨ'pʉ, mɨrɨpan uye'ka'sa' serɨ ya', mɨrɨ pɨ' rɨ to' enupa pɨ' iyesi,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","To' ekama'po'pʉ iya, “Sises pe' esi Kiyarari ko' pe?” tukai', ");
INSERT INTO akeNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Ewai',” tasa' to' uya pɨ'. Sises ennoko'pʉ iya kin Era' piya', apʉne pʉra itesa' pe iye'to' winon pe iyesi pɨ', mɨrɨ koro'tau si Surusiran po Era' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Mɨrɨpan epori'ma'pʉ ipan pe Sises tense, apʉne pʉra inke rɨ Sises ɨnenpai te'sen pe iye'pɨtʉ'pʉ, apʉne pʉra eke Papa tʉrawasooi kupʉ iya tawon etasa' tʉuya pɨ'. Mɨrɨpan nin si kupʉ iya ɨnenpai iyesi'pʉ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tu'kan pɨ' rɨ Sises ekama'popɨtʉ'pʉ iya, e'tane eikʉ'pʉ iya pen. ");
INSERT INTO akeNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru mɨrɨ awonsi'kɨ Main pɨ' enupanin nan e'soto'pɨ'sa' esi'pʉ mɨrɨ yau Sises eseru'tɨ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mɨrɨ a'tai, Era' mɨrɨ awonsi'kɨ isoisaai amʉ' uya Sises sapema'pʉ. E'neimapɨtʉ pe to' usennaka'pʉ ipɨ', mɨrɨpan pontɨ'pʉ to' uya epe'kena' kuru pon ya', mɨrɨpan na'po'pʉ to' uya Paire' piya'. ");
INSERT INTO akeNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Mɨrɨ wapiya Era' mɨrɨ awonsi'kɨ Paire' pokon esi'pʉ ɨ'seyaton pe, mɨrɨpan kon ena'pʉ ɨsitonpa pe mɨrɨ wʉi a'tai rɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Paire' uya use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru, ka'pon amʉ' epuru ton mɨrɨ awonsi'kɨ ka'pon amʉ' rɨ nɨrɨ amʉranʉkʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","To' uye'sa' a'tai, ta'pʉ iya to' pɨ', “Pʉse rɨ ka'pon ne'sa' auya'nokon upiya', kopʉna ewa'nomanin pe ka'pon amʉ' kupʉ iya ta auya'nokon. Ekama'popɨ'sa' uya man apana airɨ'nokon, mɨrɨ awonsi'kɨ ɨ'rɨ rɨ eposa' uya pʉra man meseru'tɨyatʉi'ne' ipɨ', pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Era' uya rɨ nɨrɨ ɨri pe man tasa' pʉra man, apʉne pʉra inna'posa' iya man upiya'nokon. Menyatʉi'ne' rɨ, ɨ'rɨ rɨ ku'sa' iya pʉra iyesi tʉwɨto' ipɨkɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Mɨrɨ pɨ', usoisaai amʉ' uya rɨ nin ari'po'pɨ'to' pe ta uya, mɨrɨ awonsi'kɨ inonkato' pe uya rɨ nin,” ta'pʉ Paire' uya.  ");
INSERT INTO akeNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ a'tai, iteseru esi'pʉ Paire' uya tikin nɨ a'sisa' pe te'sen nonkato' pe iyesi Esuwerʉ amʉ' iwano' pe. ");
INSERT INTO akeNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tikin nɨ imaimu esii'ma to' ukɨ'pɨ'nʉmʉ'pʉ, “Pʉse rɨ ka'pon atɨ' iwɨnɨ kon pa! Parapas nonkai'ma ina iwano' pe,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Parapas esi'pʉ a'sisa' pe, apʉne pʉra usewa'noman emapu'tɨsa' iya pɨ' Surusiran po mɨrɨ awonsi'kɨ ka'pon nɨrɨ wɨsa' iya pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Sises ɨnnonkapai tesi pɨ', Paire' uya kanan to' ekama'pokaa'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","E'tane to' ukɨ'pɨ'nʉnpɨtʉ'pʉ, “Kurusu' pona ipokapɨ'kɨ! Kurusu' pona ipokapɨ'kɨ!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Itosorʉwano ite'kwa pe to' auro'ka'pʉ iya, “Ɨ'rɨto' pe? Ɨ'rɨ ɨri ku'sa' pʉse rɨ ka'pon uya? Ɨ'rɨ rɨ ima'tato' ipɨkɨrɨ eposa' uya pʉra man. Mɨrɨ pe iyesi pɨ', ikota'mato' pe ikupʉ uya, mɨrɨ awonsi'kɨ inonkato' pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","E'tane eke pe to' ukɨ'pɨ'nʉnpɨtʉ'pʉ, tɨwɨ kurusu' pona ipokapɨtʉ nesii, tukai', mɨrɨpan kon nin si ena'pʉ imaimu entai. ");
INSERT INTO akeNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Paire' nin si ekoneka'pʉ mɨrɨ to' nesakʉ'pʉ ke to' repa pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ka'pon nonka'pʉ iya usewa'noman ku'sa' iya pɨ' mɨrɨ awonsi'kɨ ka'pon nɨrɨ wɨsa' iya pɨ' a'sisa' rʉ'pʉ, to' nekama'po'pʉ, Sises nonkai'ma i'se to' e'to' ya'. ");
INSERT INTO akeNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","To' uya arɨ koro'tau, ka'pon, Sairini pon Saiman itese', a'si'pʉ to' uya, Surusiran pona tʉutɨsen tʉmainarʉ awonsi'kɨ. Mɨrɨpan ena' kurusu' nonka'pʉ to' uya ato' pe iya Sises e'ma'pʉ pe. ");
INSERT INTO akeNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tu'kan kon nɨ utɨ'pʉ Sises pɨkɨrɨ kurusu' pona soisa amʉ' uya ipokapɨ'to' ya'. Uri'sami'si amʉ' rɨ tʉuta'kwarʉkai' tʉukaransan iwenai. ");
INSERT INTO akeNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Mɨrɨpan kon winɨkʉi' Sises era'tɨ'pʉ, “Surusiran pon kon uri'sami'si amʉ', uwenai kakarantʉu; ɨwenai'nokon nɨ, ɨmunkɨ kon wenai rɨ akarantɨ', apʉne pʉra ɨsɨ rɨ e'ku'to' oton pɨ' ɨpɨ'nokon. ");
INSERT INTO akeNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Apʉne pʉra tato' oton to' uya iweyu e'seposa' a'tai, ‘Wakʉ ton kuru rɨ kamoro uri'sami'si amʉ' mʉre a'sinin nan pen, mʉre yen pe itewan e'sa' kon pen, mʉre na'su'ka'pʉ pen imanatʉ ton.’ ");
INSERT INTO akeNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mɨrɨpan tʉron kon uya tato' oton wʉ' ton pɨ', ‘Ina iwasa'kakɨ,’ i'kʉrʉ ton pɨ', ‘Ina iu'na'tɨkɨ,’ tato' oton to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Serɨ kupʉ ka'pon amʉ' uya pe iyesi yau isenan pe yʉi esi koro'tau, ɨ'rɨ pe ken si iyesi mɨrɨ iyaipʉtasa' pe iyesi a'tai?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Asa'rɨ rɨ marɨ ɨri ku'nin nʉ'san ka'pon amʉ' enpa'ka'pʉ soisa amʉ' uya pata apai Sises pokon pe kurusu' pona to' pokapɨ'to' pe. ");
INSERT INTO akeNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pata, Pu'pɨ Ɨ'pʉ rʉ'pʉ tato' eposa' to' uya a'tai, to' uya si kurusu' pona ipokapɨtʉ'pʉ ɨri ton pokon pe, tikin nɨ itenwo'netʉ winɨ, isakon ikamisi winɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Sises uya ta'pʉ, “Papai, to' pɨ' ɨsentu'makɨ, apʉne pʉra to' uya i'tu pʉra rɨ iyesi ɨri kupʉ tʉuya'nokon tukai',” ta'pʉ iya. Ipon nʉ'pʉ ta'nʉkʉ'pʉ to' uya te'wapiya'kapɨ'se. ");
INSERT INTO akeNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ka'pon amʉ' e'soto'pɨ'sa' esi'pʉ enpɨtʉ pɨ', Esuwerʉ amʉ' epuru ton uya Sises sapema'pʉ, “Tʉron kon sa'ne si pika'tɨ'pʉ iya, tɨwɨ si nepika'tɨi tiwano' pe, i'napai rɨ Kʉrai pe tesi yau, Papa Nanʉmʉ'pʉ pe,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Te'neimapɨ'se soisa amʉ' usennaka'pʉ ipɨ', mɨrɨpan kon uya waain peneka ke iwo'pa'pʉ ");
INSERT INTO akeNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","tai'ma, “Apʉne si Esuwerʉ amʉ' iwano' kin pe ɨwesi yau, ɨu'tɨkɨ kurusu' poi epika'tɨkɨ,” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mɨrɨpan i'pai epoi tʉnmenuka'pʉ kon tʉsa' to' uya esi'pʉ: Pʉse rɨ si pʉse rɨ Esuwerʉ amʉ' iwano' kin, tawon. ");
INSERT INTO akeNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ɨri ka'pon, ipokapɨ'sa' ipiyau uya rɨ isapema'pʉ, “Kʉrai pen nɨ pe' ɨmɨrɨ, epika'tɨkɨ, ina nɨrɨ ipika'tɨkɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","E'tane isakon uya e'se'ne' pe eseremekʉ'pʉ, “Sises kasa rɨ pe' ama'tai'ma Papa nama auya pʉra iyesi? ");
INSERT INTO akeNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Iye'to' pe rɨ nin kurusu' pona to' uya upokapɨ'sa' kon serɨ ɨri ku'sa' wenai rɨ nin, e'tane pʉse rɨ uya ɨri ku'sa' pʉra rɨ iyesi, iwenai pʉra rɨ nin kurusu' pona to' uya ipokapɨ'sa' na'ne',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mɨrɨpan uya ta'pʉ Sises pɨ', “Sises, ɨyenu yau rʉ'kwɨ ukupʉi' kin pe ɨyenasa' a'tai,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Sises uya eikʉ'pʉ, “Ɨpɨ' ta uya serɨ, serɨ pe upiyau ɨwesi mɨrɨ wakʉ upata yau,” ta'pʉ Sises uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","12 a'kʉra' e'to' airɨ'ne rɨ, pata si ewarumamʉ'pʉ 3 a'kʉra' pʉ'kʉ pona rɨ, ");
INSERT INTO akeNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","wʉi enu uya pata wei'tɨ pʉra iyesi'pʉ to' e'to' airɨ. Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' wapu ekaraka'pʉ a'sa'mʉyai. ");
INSERT INTO akeNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Mɨrɨpan Sises ukɨ'pɨ'nʉmʉ'pʉ, “Papai, ɨyena' si uya'kwarʉ sitʉyai'!” ta'pʉ iya. Serɨ ta tʉpo si, iyerikʉ'pʉ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Roman amʉ' soisaai ton epuru uya ensa' a'tai, Papa apurɨpɨtʉ'pʉ iya, “I'napai rɨ kuru rɨ ka'si, pʉse rɨ esi'pʉ mɨrɨ wa ipokena' e' pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ka'pon amʉ' iyamʉrasa' kon uya tanporo serɨ e'kupʉ ene'pʉ mɨrɨ, mɨrɨpan kon utɨ'pʉ ipan pe pokoi pe esii'ma. ");
INSERT INTO akeNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tanporo kamoro Sises i'tunin nan e'soto'pɨ'sa' esi'pʉ mɨrɨ te'ku'sen enpɨtʉ pɨ' ɨnnonsi'kɨ, uri'sami'si amʉ' rɨ esi'pʉ, iya'kɨrɨ iye'sa' kon nʉ'san Kiyarari poi. ");
INSERT INTO akeNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Moro ka'pon esi'pʉ Isose' itese', Konsʉrʉ pe te'sen, wakʉ mɨrɨ awonsi'kɨ ipoken te'sen awɨron, ");
INSERT INTO akeNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Papa e'to' esa' wannɨ pe e'seporo enupɨkɨrɨ te'sen. Kʉrɨ rɨ esi'pʉ asauro'se'na iyamʉrasa' kon tonpa pe rɨ, e'tane to' eseru pɨ', “Ewai',” tasa' iya pʉra iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Itɨ'pʉ Roman amʉ' kopʉnaai, Paire' piya' Sises ekepu ekama'pose'na iu'na'tɨto' pe tʉuya. Mɨrɨpan pɨ', “Ewai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mɨrɨpan mo'ka'pʉ iya, iwontɨ'pʉ iya epe'kena' pon renen tato' atʉ ke. Mɨrɨpan tʉrʉ'pʉ iya emenna' pe tɨ' akasa' uruwai' pe ya'. ");
INSERT INTO akeNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ekonekan weyu pe iyesi'pʉ, Sapa' nin si epiya'tɨkapʉ esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Uri'sami'si amʉ' Sises a'kɨrɨ iye'sa' kon nʉ'san Kiyarari poi utɨ'pʉ Isose' a'kɨrɨ. Mɨrɨpan kon uya Sises ekepu emaika ene'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","To' enna'po'pʉ patatʉse' tʉuya'nokon ya'. Mɨrɨpan kon uya a'po'na' nan karapa konepɨtʉ'pʉ Sises ekepu karapaimato' tʉuya'nokon ike pe. To' nin si ereuta'pʉ mɨrɨ Sapa' weyu a'tai, Main uya tasa' na'ne' awɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Awanakʉi' kuru nin si suntaaka epiya'tɨ pe uri'sami'si amʉ' uya tʉnkoneka'pʉ kon a'po'na' nan arɨ esi'pʉ tɨ' akasa' uruwai' pe pona. ");
INSERT INTO akeNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","To' uya tɨ' e'tɨrinkasa', tɨ' akasa' uruwai' pe apai eporo'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","e'tane to' ewonsa' a'tai Sises ekepu pʉra iyesi'pʉ mɨrɨ yau. ");
INSERT INTO akeNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mɨrɨpan pɨ' to' usenuminka koro'tau, ite'kwanau pʉra rɨ, asa'ron kon ka'pon amʉ' e'soto'ka'pʉ to' piyau, to' pon ton e'wei'tɨpɨtʉ'pʉ a'kwa pe, kamiri' kasa. ");
INSERT INTO akeNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tetʉipɨtʉ kon pɨ' uri'sami'si amʉ' epeima'pʉ non pona, e'tane to' pɨ' ta'pʉ to' uya, “Ɨ'rɨto' pe eke' amʉ' koro'tau nurɨnan warinpa auya'nokon? ");
INSERT INTO akeNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ipʉra man serɨ yau, iye'mʉ'sa'ka'pʉ man. Ɨyenu kon yau iku'tɨ' inekama'pʉ ɨpiyau'nokon tesi koro'tau Kiyarari po, ");
INSERT INTO akeNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Ka'pon, Papa winon tʉto' oton ka'pon amʉ' uya tʉmakooikenan kon ena' to' uya ipokapɨ'to' pe kurusu' pona, e'tane iye'mʉ'sa'kato' oton itosorʉwano wʉi a'tai,’ tawon,” ta'pʉ to' iya. ");
INSERT INTO akeNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mɨrɨ eta tʉuya'nokon a'tai, to' enu ya' si iyena'pʉ Sises maimu rʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tenna'posa' kon a'tai, tɨ' akasa' uruwai' apai, 11 pan kon ipoitorʉ ton mɨrɨ awonsi'kɨ tʉron kon ipoitorʉ ton pana'tɨ'pʉ to' uya tanporon nɨ iye'ku'sa' rʉ'pʉ ke. ");
INSERT INTO akeNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Pʉsamoro uri'sami'si amʉ' esi'pʉ mɨrɨ, Meri Mataren, Isowana, mɨrɨ awonsi'kɨ Isens san, Meri rɨ marɨ itese', mɨrɨ awonsi'kɨ tʉron kon uri'sami'si amʉ' esi'pʉ to' a'kɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","E'tane uri'sami'si amʉ' uya tʉpana'tɨto' kon, apurɨ to' uya pʉra iyesi'pʉ, apʉne pʉra kasi poken iseta pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mɨrɨ rɨ e'tane, Pi'ta e'mʉ'sa'kasa' nin si eka'tumʉ'pʉ tɨ' akasa' uruwai' pona. Te'tɨmuikai' Sises ekepu ontɨto' ike pe isaai'pɨ'sa' rʉ'pʉ renen tato' atʉ ene'pʉ iya tʉpona rɨ. Mɨrɨpan utɨ'pʉ, “Ɨ'rɨ pe rɨ si iyesi'pʉ ko?” tai'ma. ");
INSERT INTO akeNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mɨrɨ rɨ suntaaka e'sara'tɨ a'tai, asa'ron kon Sises poitorʉ ton utɨ esi'pʉ, eke iwa pata Emeyas tato' ka'pon amʉ' uya ya'. Serɨ pata esi'pʉ 7 mayirʉ e'to' airɨ rɨ Surusiran poi. ");
INSERT INTO akeNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Asaurokʉi'ma to' utɨ esi'pʉ tanporo iye'ku'sa' rʉ'pʉ pɨ' Surusiran po. ");
INSERT INTO akeNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mɨrɨ ton pɨ' usauro'nɨ pɨ' to' esi koro'tau, Sises uyee'pʉ a'ko pe to' piya', mɨrɨpan utɨ'pʉ to' a'kɨrɨ, ");
INSERT INTO akeNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","e'tane Papa uya to' uya ito'ka'nʉkʉ namai' Sises ku'sa' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Mɨrɨpan kon ekama'po'pʉ Sises uya, “Ɨ'rɨ pɨ' asaurokʉi'ma ɨutɨ kon?” ta'pʉ iya to' pɨ'. Mɨrɨpan kon e'takʉ'kasa' umaintapɨtʉ'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","mɨrɨpan isakon Kiriyo'pas itese' uya ta'pʉ Sises pɨ', “Ɨmɨrɨ rɨken na'kɨ si nai serɨ ton, Surusiran po iye'ku'sa' rʉ'pʉ i'tunin pe pʉra,” ta'pʉ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Ɨ'rɨ ton si e'kupʉ'pʉ?” ta'pʉ nin si Sises uya mɨrɨ ipɨ'. “Mɨ ton sa'ne, Sises, Nasare' pon pɨ' iye'ku'sa' rʉ'pʉ. Pu'kena' pe sa'ne iyesi tukai', Papa ni'tunʉ, ka'pon amʉ' rɨ nɨrɨ ni'tunʉ, meruntɨ pe tʉusauro'sen, mɨrɨ awonsi'kɨ ɨ'rɨ rɨ ku'nin meruntɨ pe. ");
INSERT INTO akeNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru, mɨrɨ awonsi'kɨ uyepuru kon amʉ' uya itʉrʉ'pʉ Roman amʉ' kopʉnaai ena' to' uya iwɨto' pe iku'to' pe iya. Mɨrɨpan pokapɨ'sa' to' uya kurusu' pona erikʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ina sa'ne si Esuwerʉ amʉ' mo'ka iya ina eyaton non enapai tukai' ina e'ku'sa' e'tane. Mɨrɨ rɨken pe ekama tane, serɨ si osorʉwau wʉi iko'mankapʉ to' uya iwɨnɨ'pʉ si'kɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Mɨrɨ pona ina koro'tau te'san uri'sami'si amʉ' uya ina ewansiukapɨ'an ko. Awanakʉi' kuru to' utɨ'pʉ tɨ' akasa' uruwai' pe pona, e'tane itekepu pʉra iyesi'pʉ mɨrɨ yau. Mɨrɨpan kon uye'sa' uya ina pana'tɨ'pʉ inserʉ amʉ' ene'pʉ tʉuya'nokon tukai'. Mɨrɨpan kon uya, ‘Sises e'mʉ'sa'ka'pʉ man,’ ta'pʉ to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mɨrɨpan ina tonpa ton kanan utɨkaa'pʉ tɨ' akasa' uruwai' pe pona, mɨrɨpan kon uya si eporo'pʉ uri'sami'si amʉ' uya ekama'pʉ kasa rɨ, Sises ene'pʉ to' uya pen nɨ kanan,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Mɨrɨpan a'tai, Sises uya ta'pʉ to' pɨ', “Nai pan kon ɨmɨrɨ'nokon iya'kwarʉ pʉnon kon nɨ, apurɨ auya'nokon pʉra kuru rɨ iyesi pu'kena' amʉ' nekama'pʉ te'ku'ton tukai'. ");
INSERT INTO akeNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Papa uya rɨ sa'ne iku'sa' esi'pʉ mɨrɨ ko pʉse rɨ tʉnanʉmʉ'pʉ ekota'mato' pe rɨ. Mɨrɨpan i'mʉ'sa'kasa' tʉuya e'to' pe tapurɨpɨ'sen pe Epʉn po,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Mɨrɨpan uya to' pɨ' ekama'pʉ tʉpɨ' itekare usauro'sa' Mosi' nʉmenuka'pʉ si'kɨrɨ te'sara'tɨi', siya rɨ pu'kena' amʉ' nʉmenuka'pʉ rɨ tʉpɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","To' uya si a'ko pe eke iwa pata epokapʉ esi'pʉ mɨrɨ tʉutɨto' kon ya', e'tane Sises e'kupʉ'pʉ to' entawon ya' parɨ tʉutɨ pe itese'. ");
INSERT INTO akeNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mɨrɨpan pɨ' ta'pʉ to' uya, “Pata itʉkɨ ina piyau, apʉne pʉra pata newarumanka'an,” ta'pʉ to' uya. Mɨrɨpan kon piya' iyewomʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","31","Iyereuta'pʉ to' pokon pe enta'nase'na, mɨrɨpan uya tenki ta pe Papa pɨ' pʉreti anʉmʉ'pʉ, i'kwɨtʉ'pʉ iya, mɨrɨpan tʉrʉ'pʉ iya to' ena'. Mɨrɨ a'tai, Papa uya to' enu a'koka'pʉ, mɨrɨpan to'ka'nʉkʉ'pʉ to' uya, mɨrɨpan kon enu apai'ka'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Mɨrɨpan kon uya ta'pʉ, “Uyewan kon sa'ne a'pɨ'pɨtʉi ko asanta tau uyauro'ka iya 'nokon koro'tau pu'kena' amʉ' nekama'pʉ iye'menukasa' itekare pɨ',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mɨrɨpan kon e'mʉ'sa'kasa' utɨ'pʉ oko pe pʉra rɨ, Surusiran pona. Mɨrɨ yau, 11 pan kon Sises poitorʉ ton amʉrasa' eporo'pʉ to' uya tʉron kon ipoitorʉ ton pokon pe. ");
INSERT INTO akeNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Mɨrɨpan kon uya pʉsamoro asa'ron kon pɨ' ta'pʉ, “I'napairɨ rɨ kenʉ' Sises e'mʉ'sa'kasa' man! Mɨrɨpan ene'pʉ Pi'ta uya!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mɨrɨpan pʉsamoro asa'ron kon uya Emeas e'ma tau iye'ku'sa' rʉ'pʉ ekama'pʉ kanan to' pɨ', ito'ka'nʉkʉ'pʉ tʉuya'nokon pʉreti i'kwɨtʉ iya a'tai. ");
INSERT INTO akeNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pʉsamoro rɨ si usaurokʉ koro'tau mɨrɨ pɨ', Sises e'soto'ka'pʉ to' koro'ta'. Mɨrɨpan uya ta'pʉ to' pɨ', “Miyarɨ'nokon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ipan pe to' etʉipɨtʉ'pʉ, a'kwarʉ'pʉ ensa' tʉuya'nokon pe tekamai'. ");
INSERT INTO akeNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mɨrɨpan kon pɨ' ta'pʉ iya, “Tetʉipɨ'se pʉra e'tɨ', tʉkasimai' pʉra, e'mʉ'sa'kasa' apurɨtɨ', ");
INSERT INTO akeNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","apʉne upokapɨtʉ'pʉ iyɨ rʉ'pʉ entɨ', uyemiyatʉ pɨ' mɨrɨ awonsi'kɨ u'ta pɨ'. Urɨ rɨ kʉrɨ rɨ, uya'kwarʉ'pʉ ensa' auya'nokon pen, uya'pɨ'tɨ', urɨ rɨ kʉrɨ rɨ. Urɨ kasa pe' tʉpun ke a'kwarʉ'pʉ esi pe ekama auya'nokon,” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Serɨ ta tʉuya a'tai, tʉpokapɨtʉ'pʉ ɨ rʉ'pʉ enpoika'pʉ iya mɨrɨ to' ena'. ");
INSERT INTO akeNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pori' pe kuru tesi kon ke, “I'napai rɨ se esi pen nɨ serɨ?” ta'pʉ to' uya. Mɨrɨpan kon pɨ' ta'pʉ iya, “Kiyari pe' moro nai enta'nan nɨto' ipɨ'?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Mɨrɨpan kon uya irepa'pʉ akuse pe ikanpʉ'tɨsa' moro' ke. ");
INSERT INTO akeNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Mɨrɨpan pɨ' iyenta'na'pʉ to' enu airɨ. ");
INSERT INTO akeNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Mɨrɨpan kon pɨ' ta'pʉ Sises uya, “Ɨ'koro'tau'nokon sa'ne esi a'tai, erikʉ rawɨrɨ, sekamatai ɨpɨ'nokon ko tanporon nɨ Mosi' Maimu, pu'kena' amʉ' Maimu rɨ, Eren yau'ne isauro'sa' na'ne' upɨ' uta'ku'tɨto' pe iyesi ukatai ko,” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mɨrɨpan kon uya tʉpɨ' iye'menukasa' itekare to'ka'nʉ'to' pe to' uya ikupʉ'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","To' pɨ' ekama'pʉ iya, “Serɨ serɨ iye'menukasa' rʉ'pʉ: Kʉrai uya e'ne' moronkato' oton, mɨrɨpan eri'to' oton, te'mʉ'sa'ka ton pe itosorʉwano wʉi a'tai. ");
INSERT INTO akeNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Mɨrɨ awonsi'kɨ tanporon kon tʉpataron kon pɨ' itekare usekamato' oton itese' yau, makoi apai era'tɨn nɨto' pɨ' mɨrɨ awonsi'kɨ makoi pɨ' usentu'man nɨto' pɨ', Surusiran po te'sara'tɨi'. ");
INSERT INTO akeNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mɨrɨ pe iyesi pɨ', entantɨ' tʉron kon kanan ipana'tɨtantɨ' ɨnene'pʉ kon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Serɨ pe iwa rɨ, ukʉipʉnʉ usaurokʉ'pʉ ennoko uya ta'pʉ rʉ'pʉ iya'kwarʉ ennoko uya mɨrɨ ɨpiya'nokon. Mɨrɨ pe iyesi pɨ', serɨ yau Surusiran po e'tɨ' Papa winon ɨmeruntɨrʉ kon eporo auya'nokon pʉ'kʉ pona,” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Mɨrɨ a'tai, Sises uya to' arɨ'pʉ Surusiran poi a'ko pe rɨ pata Pe'tani piya'. To' uya eposa' a'tai, temiyatʉ tanʉnse to' pʉrema'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","To' pʉrema pɨ' iyesi koro'tau, to' nɨmɨ'pʉ iya, itanʉmʉ'pʉ Epʉn pona. ");
INSERT INTO akeNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ipoitorʉ ton e'sekunka'pʉ apurɨpɨ'se'na. Mɨrɨpan kon enna'po'pʉ ipan pe rɨ pori' pe esii'ma Surusiran pona. ");
INSERT INTO akeNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Mɨrɨpan kon esi'pʉ Papa apurɨpɨtʉ pɨ', inke rɨ wʉi kaisa rɨ use'man nɨto', ɨpʉreman nɨto' iwʉ' pʉ'kʉ tau. ");
INSERT INTO akeNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Iyepiya'tɨ yau Main esi'pʉ, Papa piyau Main esi'pʉ, Papa pe rɨ Main esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mɨrɨ rɨ esi'pʉ iyepiya'tɨ pe Papa piyau. ");
INSERT INTO akeNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tanporon nɨ ekoneka'pʉ iporo; ɨ'rɨ rɨ ekonekasa' pʉra iyesi ipʉra iye'tane. ");
INSERT INTO akeNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Uko'man nɨto' esi iyau, uko'man nɨto' esi ka'pon amʉ' weyu pe. ");
INSERT INTO akeNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mɨrɨ iweyu e'wei'tɨ'pʉ ewarupɨ yau, e'tane ewarupɨ uya ito'ka'nʉkʉ'pʉ pen. ");
INSERT INTO akeNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Moro ka'pon esi'pʉ Papa nennoko'pʉ, Isaan itese'. ");
INSERT INTO akeNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Kʉrɨ rɨ uyee'pʉ iweyu enpoikai' tanporon kon uya apurɨto' pe tʉporo. ");
INSERT INTO akeNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Iweyu pe iyesi'pʉ pen, e'tane iweyu ekamanin pe enno'sa' pe iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mɨrɨ esi'pʉ i'napairon iweyu, tanporon kon ka'pon amʉ' non pon kon wei'tɨnin pe iyepʉ esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Non po iyesi'pʉ, non nɨ ekonekasa' e'tane iporo, e'tane non pon kon uya i'tu pʉra iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tʉtonpa ton piya' iyee'pʉ, e'tane itonpa ton uya isanoma'pʉ pen. ");
INSERT INTO akeNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","E'tane kamoro tʉsanomanin nʉ'san, tapurɨnin nʉ'san repasa' iya meruntɨ ke, Papa munkɨ pe to' enato' pe. ");
INSERT INTO akeNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Mʉre amʉ', entu eseru yau iyentusa' kon pen, ipun eseru awɨrɨ pen, warawo' eseru awɨrɨ pen nɨ nɨrɨ, e'tane Papa iwano' pe kuru. ");
INSERT INTO akeNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mɨrɨ Main enasa' esi'pʉ ka'pon pe, mɨrɨpan uko'mamʉ'pʉ ina piyau. Ina uya a'kwa ene'pʉ, tikin nan nʉ'kwɨ kuru rɨ imu a'kwarii, Ikʉipʉnʉ winɨ iye'sa', eke pe rɨ wakʉ nonkasa' mɨrɨ awonsi'kɨ i'napairon esa' pe. ");
INSERT INTO akeNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Isaan uya ekama'pʉ eke pe tʉukɨ'pɨ'nʉnse, “Pʉse rɨ si kʉrɨ rɨ unekama'pʉ, ‘Kʉrɨ rɨ si uye'ma'pʉ tau tʉuye'ton esi mɨrɨ eke uyentaino, penaro' uwapiyaro' rʉ'pʉ rɨ,’” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Eke pe wakʉ nonkasa' esa' pe e'nɨ winɨ wakʉ ke upʉremasa' iya 'nokon eporo ɨse'ma'pʉ tau'ne rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Main e'tʉrʉ'pʉ Mosi' poro, e'tane wakʉ nonkasa' mɨrɨ awonsi'kɨ i'napairon uyee'pʉ Sises Kʉrai poro. ");
INSERT INTO akeNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ɨnʉ' uya Papa ensa' pʉra iyesi; tikin nan kuru rɨ Papa Mumu, tʉkʉipʉnʉ enau te'sen kʉrɨ rɨ uya rɨken enpoikasa' i'tuto' pe. ");
INSERT INTO akeNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Serɨ esi Isaan maimu rʉ'pʉ, Esuwerʉ amʉ' epuru ton Surusiran pon kon uya Esuwerʉ amʉ' use'mato' tʉrawasomanin nan mɨrɨ awonsi'kɨ Ripai amʉ' enno'sa' Isaan ekama'pose'na a'taino, ɨnʉ' pe ɨwesi tukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Iye'wapu'tɨ'pʉ pen, e'tane isekama'pʉ, “Kʉrai pen urɨ,” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","To' uya ekama'po'pʉ, “Ɨnʉ' pe ken ɨwesi? Iraisa pe'?” ta'pʉ to' uya. “Kane,” ta'pʉ iya. “Pu'kena' katɨ?” ta'pʉ to' uya. “Kane,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Mɨrɨpan kon uya ta'pʉ ipɨ', “Ɨnʉ' pe ken ɨwesi, ina enno'nin nʉ'san pɨ' ina uya ekamato' pe. Ɨnʉ' pe ɨwesi ta auya ken?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Isaan uya eikʉ'pʉ pu'kena' Aisaya maimu yai, “Urɨ kʉrɨ rɨ rɨmono' tau ka'pon ukɨ'pɨ'nʉnpɨtʉ, ‘To'sa rɨ Itepuru e'ma ikonekatɨ',’ tawon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Kamoro esi'pʉ tʉtonpa kon enno'sa' Pari'si amʉ' uya pe. ");
INSERT INTO akeNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","To' uya ekama'po'pʉ, “Ɨ'rɨ pe ken iyesi pɨ' ɨmɨrɨ uya to' pa'taisima, Kʉrai pe pʉra rɨ, Iraisa pe pʉra rɨ, pu'kena' pe pʉra rɨ ɨwe'tane?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Isaan uya to' eikʉ'pʉ, “Urɨ uya to' pa'taisima tuna ke. E'tane moro man ɨ'koro'tau'nokon, ɨni'tunʉ kon pen. ");
INSERT INTO akeNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Kʉrɨ rɨ esi tʉuye'sen uye'ma'pʉ pe, isapatooi euka uya pokena' pen nɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Serɨ ton e'kupʉ'pʉ Pe'tani pata yau, Isotan tuna ratoi po, Isaan uya ka'pon amʉ' pa'taisimato' airɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mɨrɨ ema'sa' yau, Isaan uya Sises uyepʉ tekare pɨ' ene'pʉ, mɨrɨpan uya ta'pʉ, “Pʉse rɨ si Papa iwano' karimeru mʉre, non makooi mo'kanin! ");
INSERT INTO akeNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Pʉse rɨ si kʉrɨ rɨ unekama'pʉ, ‘Uye'ma'pʉ tau ka'pon uyepʉ eke kuru uyentaino, penaro' uwapiyaro' rʉ'pʉ rɨ,’ ukataine'. ");
INSERT INTO akeNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Urɨ uya rɨ kʉrɨ rɨ i'tusa' pʉra iyesi, ɨnʉ' pe iyesi tukai', e'tane uye'sa' na'ne' esi pa'taisiman nɨse'na tuna ke Esuwerʉ amʉ' ena' enpoika pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Mɨrɨ a'tai Isaan uya se ekama'pʉ: “Iya'kwarʉ u'tɨ ene'pʉ uya Epʉn poi wako'wa kasa, mɨrɨpan uta'si'pʉ ipona. ");
INSERT INTO akeNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","I'tu uya pʉra rɨ marɨ iyesi'pʉ. E'tane uyenno'nin nʉ'pʉ pa'taisimanin pe tuna ke uya uyauro'kasa' esi'pʉ, ‘Ɨnʉ' rɨ pona Iya'kwarʉ uyepʉ ene auya a'tai, uta'si rɨ nɨrɨ ipo te'ton pe, kʉrɨ rɨ si kʉrɨ rɨ Wakʉ A'kwarʉ ke pa'taisimanin,’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Unene'pʉ si ekama uya, pʉse rɨ si esi Papa Mumu pe,” ta'pʉ Isaan uya. ");
INSERT INTO akeNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mɨrɨ ema'sa' yau, mɨrɨ yau rɨ marɨ Isaan esi'pʉ, asa'ron kon tʉpoitorʉ ton pokon pe. ");
INSERT INTO akeNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Sises usarɨ uya tentaka kon ensa' tʉuya a'tai, “Pʉse rɨ si Papa iwano' karimeru mʉre!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Asa'ron kon ipoitorʉ ton uya isaurokʉ etasa' a'tai, to' uya Sises e'ma'pʉka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Mɨrɨ a'tai, Sises era'tɨsa' uya te'ma'pʉka to' uya ene'pʉ. “Ɨ'rɨ warinpa auya'nokon?” ta'pʉ iya to' pɨ'. “Rapai (Ti'sa ta e'kwa pe), nai airɨ apata'se' esi?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Entanʉ'tɨ',” ta'pʉ iya to' pɨ'. To' utɨ'pʉ ipata'se' ense'na. Ipiyau to' uko'mamʉ'pʉ mɨrɨ wʉi a'tai, apʉne pʉra pata uko'mansa' esi'pʉ (4 a'kʉra' e'to' airɨ pata esi'pʉ). ");
INSERT INTO akeNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Isakon, Isaan usaurokʉ etanin nʉ'pʉ, Sises e'ma'pʉkanin nʉ'pʉ esi'pʉ Anturu, Saiman Pi'ta akon. ");
INSERT INTO akeNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Wapiya kuru tʉrui Saiman warinpai' itɨ'pʉ, mɨrɨpan uya ta'pʉ ipɨ', “Ina uya Me'saya eposa' man, Kʉrai tato' ipɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Mɨrɨpan uya Sises piya' inee'pʉ. Sises uya ene'pʉ, mɨrɨpan uya ta'pʉ ipɨ', “Ɨmɨrɨ kʉrɨ rɨ Saiman, Isaan mu, Ke'pas pe ɨyesa'to' oton (Tɨ' ta e'kwa pe),” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mɨrɨ ema'sa' yau, Sises ekoneka'pʉ Kiyarari pona tʉutɨto' pe. Piri' eporo'pʉ iya, ta'pʉ iya ipɨ', “Upɨkɨrɨ ɨsi'kɨ.” ");
INSERT INTO akeNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Piri' esi'pʉ Pe'saita winon, Anturu mɨrɨ awonsi'kɨ Pi'ta pata'se' winon pe. ");
INSERT INTO akeNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Piri' uya Na'taniyerʉ eporo'pʉ, ta'pʉ iya ipɨ', “Mosi' nʉmenuka'pʉ Main yau, pu'kena' ton nɨ nɨrɨ nʉmenuka'pʉ ipɨ', Sises, Nasare' winon, Isose' mumu eposa' ina uya man,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Na'taniyerʉ uya ta'pʉ ipɨ', “Wakʉ pe' epa'ka mɨ Nasare' poi?” ta'pʉ iya. “Apʉne entanʉ'kɨ,” ta'pʉ Piri' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Sises uya Na'taniyerʉ uyepʉ tekare pɨ' ensa' a'tai, ta'pʉ iya ipɨ', “Apʉne enkɨ, Esuwerʉ kuru rɨ, enku'tɨnin pen nɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Na'taniyerʉ uya ta'pʉ ipɨ', “Ɨ'rɨ kasa ui'tu auya?” ta'pʉ iya. Sises uya imaimu eikʉ'pʉ, “Piri' uya ɨkɨ'ma wapiya, pi' e' o'no ɨwesi a'tai, ɨyene'pʉ uya,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Na'taniyerʉ uya ta'pʉ ipɨ', “Rapai, ɨmɨrɨ esi Papa Mumu pe, ɨmɨrɨ esi Esuwerʉ amʉ' Kin pe!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Sises uya imaimu eikʉ'pʉ, “Pi' e' o'no ɨyene'pʉ uya tasa' uya ɨpɨ' pɨ' rɨ pe' uyapurɨ auya? Mɨrɨ entaino kuru ento' auya oton mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","I'napairon ekama uya ɨpɨ'nokon, serɨ tʉpo Epʉn uta'koka ento' auya'nokon oton, Papa inserʉʉi ton u'tɨpɨtʉ mɨrɨ awonsi'kɨ enu'pɨtʉ Ka'pon, Papa winon pona,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Asa'rɨ wʉi tʉpo moro temari'masan esi'pʉ Kena po, Kiyarari airɨ. Mɨrɨ yau, Sises san esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Sises mɨrɨ awonsi'kɨ ipoitorʉ ton kɨ'masa' to' uya esi'pʉ mɨrɨ pona. ");
INSERT INTO akeNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","To' yuku, waain u'ma'sa' a'tai, isan uya, “To' yuku, waain u'matʉ'pʉ man,” ta'pʉ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Sises uya eikʉ'pʉ, “Mɨrɨ iku'kɨ kʉkai upɨ', ma'non. Uweyu e'seposa' pʉra rɨ marɨ man,” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Isan uya nin si ta'pʉ mɨrɨ to' poitorʉ ton pɨ', “Mɨrɨ iku'tɨ' ta iya mʉku'tʉi',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Esuwerʉ amʉ' eseru esi'pʉ ekorʉkan tawon, mɨrɨ to' nin si 6 kaisaron tuna yen ton tɨ' ka'pɨ'sa' wai amʉ' esi'pʉ mɨrɨ, eke ton kuru rɨ, 20, 30 kiyaran e'to' airɨ tuna a'sinin. ");
INSERT INTO akeNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Sises uya nin si, “Se ton wai amʉ' ipe'tɨpɨ'tɨ' tuna ke,” ta'pʉ mɨrɨ to' poitorʉ ton pɨ', mɨrɨpan pe'tɨpɨtʉ'pʉ to' uya ite'pi ton tepopɨ'se. ");
INSERT INTO akeNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Mɨrɨ awonsi'kɨ nin si, “Imatɨ' si, arɨ kon pa uta're'tɨn epuru piya',” ta'pʉ iya to' pɨ', mɨrɨpan kon uya arɨ'pʉ itena'. ");
INSERT INTO akeNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mɨrɨpan uya onpa'pʉ, tuna si enasa' waain pe. I'tu iya pʉra iyesi'pʉ nai winɨ iye'seposa' tukai' (e'tane to' poitorʉ ton uya rɨken i'tu'pʉ). Mɨrɨpan uya warawo', temari'masen kɨ'ma'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","mɨrɨpan uya, “Tanporon kon nɨ sa'ne wapiya wakʉ kuru waain ekannin nan ko, tanporo ikɨ'masa' kon uya nin si; ensika'sa' a'tai te'sen nʉ'kwɨ rɨ nin si ekamʉ to' uya mɨrɨ. E'tane wakʉ kuru rɨ enkurunpasa' auya man ko serɨ pʉ'kʉ pona!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Serɨ si mɨrɨ ti'tuto' ipɨkɨrɨ ku'pɨtʉ tʉuya sara'tɨ'pʉ Sises uya Kena po, Kiyarari airɨ. Mɨrɨ si tʉmeruntɨrʉ enpoika'pʉ iya, mɨrɨpan apurɨ'pʉ ipoitorʉ ton uya. ");
INSERT INTO akeNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Serɨ pata'pʉ pe, iu'tɨ'pʉ Ka'paneyan pona, tʉsan, takon non mɨrɨ awonsi'kɨ tʉpoitorʉ ton pokon pe. Mɨrɨ yau to' uko'mamʉ'pʉ aka'ne' pe rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Esuwerʉ amʉ' uya Itepoi Itɨ'pʉ Weyu Rʉ'pʉ ku'to' weyu e'seporo esi'pʉ, mɨrɨ pɨ' Sises utɨ'pʉ Surusiran pona. ");
INSERT INTO akeNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mɨrɨpan uya, Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' pʉ'kʉ tau, ka'pon amʉ' uya paka amʉ', karimeru amʉ', wako'wa amʉ' kʉrʉpo'poma eporo'pʉ, pʉrata ensimapɨ'nin nan nɨ ereutapɨ'sa' esi'pʉ tʉtepʉrʉʉi kon piyau'ne. ");
INSERT INTO akeNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Si'na' amʉ' tʉkonekai' to' ari'po'pɨ'to' tʉuya ike pe, paka amʉ', karimeru amʉ' enpa'kanʉkʉ'pʉ iya; pʉrata ensimanin nan tepʉrʉʉi rawoipɨtʉ'pʉ iya, to' pʉrataai tʉrʉ'pɨtʉ'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Mɨrɨ awonsi'kɨ ka'pon amʉ' wako'wa amʉ' kʉrʉpo'pomanin nan pɨ', “To' akanʉ'tɨ' serɨ tapai, ukʉipʉnʉ iwʉ' kʉ'ku'tʉu kʉrʉpo'po pɨ' e'nɨ iwʉ' pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ipoitorʉ ton enu ya' iyee'pʉ iye'menukasa' itekare, “Papa, ɨiwʉ' kuru wenai uta'kwarʉka ukɨrɨ'nʉkʉ pɨ' man,” tawon. ");
INSERT INTO akeNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Esuwerʉ amʉ' epuru ton uyee'pʉ ekama'poi', “Ɨ'rɨ ɨi'tuto' ipɨkɨrɨ kupʉ auya, serɨ ku'to' auya ekamanin pe?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Sises uya to' eikʉ'pʉ, “Se Papa ena' use'man nɨto', ɨpʉreman nɨto' iwʉ' a'morʉkatɨ', amɨto' pe uya osorʉwau wʉi yau,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","“Osorʉwau wʉi yau si serɨ amɨ auya kanan?” tukai' to' uya ekama'po'pʉ. “46 kaisa rɨ sa'ne wʉipiya amɨsa' rʉ'pʉ serɨ ko,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","E'tane use'man nɨto', ɨpʉreman nɨto' iwʉ' Sises nʉsauro'ai'ne' ipɨ' esi'pʉ mɨrɨ tʉmɨrɨ pun pɨ' rɨ nin. ");
INSERT INTO akeNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Mɨrɨpan nin si e'mʉ'sa'kasa' a'tai terikʉ tʉpo, ipoitorʉ ton enu ya' iyee'pʉ mɨrɨ, serɨ ta'pʉ iya rʉ'pʉ, mɨrɨpan kon uya pena iye'menukasa' rʉ'pʉ itekare apurɨ'pʉ, mɨrɨ awonsi'kɨ Sises maimu rʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Sises esi koro'tau Surusiran po, To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ kupʉ to' uya a'tai, tu'kan kon uya rɨ apurɨ'pʉ, eke Papa tʉrawasooi ti'tuto' ipɨkɨrɨ kupʉ iya ene tʉuya'nokon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","E'tane Sises uya to' apurɨ'pʉ pen, apʉne pʉra mɨrɨ waraino kon tukai' to' i'tu tʉuya wenai. ");
INSERT INTO akeNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ɨnʉ' uya rɨ ipana'tɨto' pʉra iyesi ka'pon amʉ' pɨ', apʉne pʉra to' ewan nɨ i'tu iya wenai. ");
INSERT INTO akeNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Moro ka'pon esi'pʉ Nekutimas itese', Esuwerʉ amʉ' epuru, Pari'si amʉ' tonpa pe te'sen. ");
INSERT INTO akeNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Itɨ'pʉ ewarupɨ nau Sises piya', mɨrɨpan uya ta'pʉ ipɨ', “Ina uya ɨi'tu, Rapai, Papa nennoko'pʉ pe. Ɨnʉ' uya rɨ i'tuto' ipɨkɨrɨ kupʉ pʉra rɨ iyesi mɨrɨ mʉku'ai'ne', Papa pʉra iye'tane tʉpiyau,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Entakanoma pe Sises uya ekama'pʉ, “I'napairon ekama uya ɨpɨ', ɨnʉ' uya rɨ Papa e'to' esa' wannɨ pe ene pʉra rɨ iyesi iyakon ite'kwa pe iyentuka'sa' pʉra te'tane,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","“Nai kasa si isemo'kaka'sa' rɨ ka'pon entukapʉ kanan iyakon ite'kwa pe?” tukai' Sises ekama'po'pʉ iya. “Iyewonkapʉ poken pʉra rɨ sa'ne iyesi tʉsan ewan ya' tentuka'to' pe iyakon ite'kwa pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Sises uya eikʉ'pʉ, “I'napairon ekama uya ɨpɨ', ɨnʉ' rɨ epa'ka Papa e'to' esa' wannɨ pe ya' pʉra iyesi mɨrɨ tentusa' a'tai rɨken, tuna mɨrɨ awonsi'kɨ iya'kwarʉ ke iyepa'ka. ");
INSERT INTO akeNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ka'pon entusa' mɨrɨ tʉpun ke tʉsanon winɨ, e'tane iyentuka'sa' kanan iya'kwarʉ yau esi mɨrɨ iya'kwarʉ winon pe rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kɨsewansiukai, ‘Tanporo ɨyentukapʉ kon kanan mɨrɨ,’ ta uya pɨ' ɨpɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","A'setun utɨ mɨrɨ i'se te'to' awɨrɨ rɨ. Imaimu eta auya, e'tane mɨrɨ winɨ iyepʉ, miyarɨ itɨ tukai' i'tu auya pʉra rɨ iyesi. Mɨrɨ kasa tanporon kon esi mɨrɨ iyentusa' kon iya'kwarʉ winɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“Nai kasa si serɨ esi?” ta'pʉ Nekutimas uya mɨrɨ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Sises uya eikʉ'pʉ, “Eke sa'ne Esuwerʉ amʉ' ti'saai ɨmɨrɨ ko, mɨrɨ pe' e'tane serɨ i'tu auya pʉra iyesi? ");
INSERT INTO akeNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","I'napairon ekama uya ɨpɨ', ina usaurokʉ serɨ ina ni'tunʉ pɨ', tʉnene'pʉ kon ekama ina uya, e'tane ina maimu ananʉnpai pʉra ɨnʉ' rɨ esi. ");
INSERT INTO akeNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Uyapurɨ auya pʉra iyesi serɨ non pon pɨ' ayauro'ka tane uya, nai kasa ken si uyapurɨ auya Epʉn pon pɨ' ayauro'ka uya yau? ");
INSERT INTO akeNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Mɨrɨpan, ɨnʉ' rɨ kanan enu'sa' pʉra iyesi Epʉn pona, Ka'pon, Papa winon nɨken Epʉn winon. ");
INSERT INTO akeNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mosi' uya karukuri ka'sa' ɨkʉi pe i'mʉ'sa'ka'pʉ yʉi pɨ' rɨmono' tau kasa rɨ marɨ, Ka'pon, Papa winon i'mʉ'sa'kato' pe iyesi, ");
INSERT INTO akeNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tanporon kon si apurɨnin nan uya tɨwɨrɨ rɨ uko'man nɨto' epoto' pe. ");
INSERT INTO akeNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Ipan pe serɨ non pon kon i'nʉnka tʉuya wenai, Papa uya tikin nan kuru tʉmu tʉrʉ'pʉ tanporo apurɨnin nan pe te'san uma'ta namai', e'tane tɨwɨrɨ rɨ uko'man nɨto' epoto' pe to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Papa uya tʉmu enno'sa' pʉra iyesi serɨ non pon kon eseru aimenkanin pe, e'tane to' epika'tɨto' pe iporo. ");
INSERT INTO akeNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ɨnʉ' rɨ imu apurɨnin eseru aimenka pen, apurɨnin pen eseru aimenkaka'sa' rɨ nin mɨrɨ, apʉne pʉra tikin nan kuru rɨ Papa Mumu apurɨsa' iya kasa pʉra. ");
INSERT INTO akeNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Serɨ kasa si Papa uya eseru aimenka mɨrɨ: Iweyu uye'sa' non pona, e'tane ka'pon amʉ' uya ewarupɨ i'nʉnka iweyu entai, ɨri pe teseru kon esi ke. ");
INSERT INTO akeNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tanporon kon ɨri kupʉ pɨ' te'san uya iweyu ewaruma'tɨ. Iweyu winɨkʉi' to' uyepʉ pʉra iyesi, teseru kon usenpoika namai'. ");
INSERT INTO akeNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","E'tane kʉrɨ rɨ i'napairon ku'nin uyepʉ iweyu ya', wakʉ teseru usento' pe Papa eseru awɨrɨ,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Serɨ ton tʉpo, tʉpoitorʉ ton pokon pe Sises utɨ'pʉ Isutiya pona. Mɨrɨ yau iko'mamʉ'pʉ epa'taisiman nɨto' kupʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Isaan nɨrɨ esi'pʉ pa'taisiman pɨ' Inon yau, Sarin piyau, apʉne pʉra eke pe tuna esi pɨ' mɨrɨ yau. Ka'pon amʉ' utɨpɨtʉ'pʉ ipiya' inke rɨ epa'taisimai'. ");
INSERT INTO akeNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Serɨ esi'pʉ mɨrɨ Isaan tʉrʉ rawɨrɨ pariki'si ta'.) ");
INSERT INTO akeNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Mɨrɨ a'tai, e'sei'pɨ'nɨto' esi'pʉ Isaan poitorʉ ton mɨrɨ awonsi'kɨ Esuwerʉ pokon pe ekorʉkan nɨto' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","To' uyee'pʉ Isaan piya', ta'pʉ to' uya ipɨ', “Rapai, kʉrɨ rɨ ɨpiyau ne'taine' Isotan ratoi po mekamataine', kʉrɨ rɨ si man epa'taisiman nɨto' kupʉ pɨ', tanporon kon ka'pon amʉ' uyepʉ ipiya',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Isaan uya to' maimu eikʉ'pʉ, “Ɨ'rɨ rɨ eporo ka'pon uya pʉra iyesi, Epʉn winɨ rɨken tʉrepasa' a'tai eporo iya pe iyesi. ");
INSERT INTO akeNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ɨmɨrɨ'nokon uya eta'pʉ, ‘Kʉrai pen urɨ; iwapiya enno'sa' pe esi,’ ta'pʉ uya. ");
INSERT INTO akeNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","“Temari'masen uri'san esi mɨrɨ temari'masen warawo' iwano' pe rɨ. E'tane si tɨ, temari'masen warawo' tonpa esi ipiyau imaimu eta pɨ', mɨrɨpan esi pori' pe imaimu eta tʉuya a'tai. Mɨrɨ kasa si pori' pe e'to' e'seposa' serɨ, mararon pe pʉra. ");
INSERT INTO akeNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Eke pe iyena, aiko pe ena tane. ");
INSERT INTO akeNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Kʉrɨ rɨ ka'tapai tʉuye'sen esi mɨrɨ tanporon kon entai rɨ; kʉrɨ rɨ non winon esi mɨrɨ non pon pe rɨ, mɨrɨ awonsi'kɨ non pɨ' nɨrɨ isaurokʉ. Kʉrɨ rɨ ka'tapai tʉuye'sen esi tanporon kon entai. ");
INSERT INTO akeNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Tʉnene'pʉ, mɨrɨ awonsi'kɨ tʉneta'pʉ ekama iya, e'tane ɨnʉ' uya rɨ imaimu apurɨ pʉra iyesi. ");
INSERT INTO akeNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ɨnʉ' rɨ i'napai rɨ imaimu anʉmʉ pɨ' na'ne', i'napai rɨ Papa esi tukai' ekama iya mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kʉrɨ rɨ Papa nennoko'pʉ usaurokʉ Papa maimu pɨ', Papa uya eke pe ta'kwarʉ tʉrʉ ipona tʉpʉ'kʉ ke pʉra. ");
INSERT INTO akeNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ikʉipʉnʉ uya tʉmu i'nʉnka, tanporon nɨ nɨrɨ tʉsa' iya itena'. ");
INSERT INTO akeNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kʉrɨ imu apurɨto' esa' pe na'ne' uya tɨwɨrɨ rɨ uko'man nɨto' eporo, e'tane imu apurɨnin pen uya uko'man nɨto' ento' oton pen, apʉne pʉra Papa uya kota'man nɨto' uko'mamʉ ipo,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Pari'si amʉ' uya eta'pʉ Sises uya tu'ke kuru tʉpoitorʉ ton eporo mɨrɨ awonsi'kɨ to' pa'taisimapɨtʉ iya Isaan entai kuru tawon. ");
INSERT INTO akeNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Sises uya kuru ɨnʉ' rɨ pa'taisimasa' pʉra rɨ iye'tane, ipoitorʉ ton uya rɨken nɨ nin tɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Sises uya mɨrɨ tawon etasa' a'tai, iyenna'po'pʉ Isutiya poi Kiyarari pona. ");
INSERT INTO akeNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Sameriya poro itɨto' e'ma esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Iyee'pʉ pata pona Sameriya pon Si'karʉ itese', ɨnnon kuru pen nɨ non Seko' nʉtʉrʉ'pʉ tʉmu Isose' ena' piyapai. ");
INSERT INTO akeNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Mɨrɨ yau, Seko' tuna'kwaai yen esi'pʉ, Sises nin si useta'kasa' tʉutɨ ke rɨ, ereuta'pʉ mɨrɨ tuna yen piyau. 12 a'kʉra' pata esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Sameriya pon uri'san uyee'pʉ tuna kan, mɨrɨpan pɨ', “Uyuku tuna ɨntʉkɨ,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Ipoitorʉ ton utɨ'pʉ esi'pʉ pata pona kiyari ennai'.) ");
INSERT INTO akeNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mɨrɨpan eikʉ'pʉ iya, “Esuwerʉ pon sa'ne ɨmɨrɨ ko; urɨ esi Sameriya pon pe. Nai kasa mairɨ uyekama'po auya ɨuku pɨ'?” ta'pʉ iya ipɨ'. (Esuwerʉ amʉ' esi'pʉ ɨsipʉsawʉ pokon kon pe pʉra.) ");
INSERT INTO akeNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Sises uya eikʉ'pʉ, “I'tunin pe ɨwesi yau Papa e'repato' ike mɨrɨ awonsi'kɨ ɨnʉ' uya ɨyekama'po tukai', mekama'poi'no, mɨrɨpan uya ɨwo'pa'pʉ nesii'no to'panʉ'nin tuna ke,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","“Itepuru, ɨpo'ki'tii pʉra iyesi; i'nau ya'mu tuna yen esi. Nai yawon to'panʉ'nin tuna eporo auya? ");
INSERT INTO akeNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Utamokori kon Seko' uya repan nʉ'pʉ ike serɨ tuna yen, kʉrɨ rɨ, imunkɨ amʉ' mɨrɨ awonsi'kɨ itikʉn non nɨ uya tuna ensipɨtʉ'pʉ iyapai. Kʉrɨ rɨ entai kuru rɨ katɨ eke pe ɨwesi?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Sises uya eikʉ'pʉ, “Ɨnʉ' rɨ serɨ tuna ensinin nʉ'pʉ e'tuna'kiripakapʉ kanan mɨrɨ, ");
INSERT INTO akeNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","e'tane ɨnʉ' rɨ tʉwo'pa'pʉ uya ensinin nʉ'pʉ e'tuna'kiripa pen nɨ nin mɨrɨ. Tuna iwo'pa'pʉ uya ike ena i'napaino rɨ i'tuna'kwaai pe rɨ, mɨrɨpan uya to'panʉ'nin tuna ke irepa, iko'manto' ike ke tɨwɨrɨ rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","“Itepuru, uwo'paka'kɨ ken si mɨrɨ tuna ke, tuna'kiri' ke esi namai', mɨrɨ enta' tuna kan nɨ uyepʉ namai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","“Ataan'pʉ ikɨ'mata ɨuye'kapʉ pa kanan serɨ ya',” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Tʉtaan'pʉ kenan pen urɨ,” ta'pʉ uri'san uya ipɨ'. Sises uya eikʉ'pʉ, “Ipoken nɨ ausaurokʉ, ‘Tʉtaan'pʉ kenan pen urɨ,’ ta auya a'tai. ");
INSERT INTO akeNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","5 kaisaron kon ya' ɨyemari'mapɨ'sa' man, kʉrɨ rɨ kanan si ipiyau me'ai'ne' ataan'pʉ kuru pen nɨ kanan. I'napairɨ rɨ ɨusekamasa' mɨrɨ,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","“Itepuru, pu'kena' pe kɨnyi'tuyai'. ");
INSERT INTO akeNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Utamokori kon ɨpʉremapɨtʉ'pʉ serɨ wʉ' po, e'tane si serɨ pe ɨmɨrɨ'nokon Esuwerʉ amʉ' uya Surusiran kuru mɨrɨ Papa pɨ' ɨpʉreman pata ta auya'nokon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Sises uya ta'pʉ ipɨ', “Uyapurɨkɨ uri'san, iweyu uye'nɨ pɨ' man ikʉipʉnʉ pɨ' ka'pon amʉ' ɨpʉremato' oton pen serɨ wʉ' po mɨrɨ pe pʉra Surusiran po rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ɨmɨrɨ'nokon Sameriya pon kon uya i'tu pʉra rɨ iyesi ɨwɨpʉremato' kon ipɨ'; e'tane ina ɨpʉrema tʉni'tunʉ kon pɨ', apʉne pʉra epika'tɨn nɨto' uyepʉ Esuwerʉ amʉ' winɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","E'tane iweyu uyepʉ, iye'ka'sa' rɨ, i'napai rɨ tʉwɨpʉremasan ɨpʉremato' oton ikʉipʉnʉ pɨ', a'kwarʉ yau mɨrɨ awonsi'kɨ i'napairon yau. Pʉsamoro waraino kon tʉpɨ' tʉwɨpʉremasan warinpa ikʉipʉnʉ uya mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Papa esi a'kwarʉ pe; kamoro ipɨ' tʉwɨpʉremasan ɨpʉremato' pe iyesi a'kwarʉ yau mɨrɨ awonsi'kɨ i'napairon yau,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Uri'san uya ta'pʉ ipɨ', “Si'tuyai', Me'saya” (Kʉrai tato') “uye'to' oton. Iye'sa' a'tai, tanporon nɨ ekamato' iya oton mɨrɨ upɨ'nokon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Sises uya eikʉ'pʉ, “Kʉrɨ rɨ rɨ urɨ, kʉrɨ rɨ rɨ usauro'nɨ pɨ' na'ne' ɨpokon pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mɨrɨ a'tai rɨ, Sises poitorʉ ton enna'posa' uyee'pʉ, mɨrɨpan kon usewansiuka'pʉ ipan pe rɨ, uri'san pokon pe isaurokʉ tepose. E'tane ɨnʉ' uya rɨ, “Ɨ'rɨ i'se ɨwesi pɨ' auro'ka auya?” ta'pʉ pen nɨ ipɨ', mɨrɨ pe pʉra, “Ɨ'rɨto' pe ipokon pe ausaurokʉ?” ta'pʉ to' uya pen nɨ Sises pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mɨrɨpan uri'san uya tʉ'tuna'kwaai yen nɨmɨ'pʉ, iyenna'po'pʉ pata pona, mɨrɨpan uya ka'pon amʉ' pɨ' ta'pʉ mɨrɨ yau, ");
INSERT INTO akeNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ka'pon entanʉ'tɨ' tanporon nɨ unku'pɨtʉ'pʉ ekamasa' iya upɨ'. Kʉrai pe pe' si pʉse rɨ esi serɨ?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mɨrɨpan kon utɨ'pʉ pata apai Sises piya'. ");
INSERT INTO akeNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mɨrɨ koro'tau, ipoitorʉ ton uya Sises pɨ', “Rapai, enta'nakɨ,” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","E'tane to' eikʉ'pʉ iya, “Ui'kiyari esi mɨrɨ moro ɨni'tunʉ kon pen nɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Mɨrɨpan pɨ' ipoitorʉ ton usekama'popɨtʉ'pʉ, “Ɨnʉ' uya rɨ pe' iti'kiyari nee'pʉ pe iyesi?” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","“Ui'kiyari esi, uyenno'nin nʉ'pʉ maimu awɨrɨ e'to' pe iyesi, mɨrɨ awonsi'kɨ itʉrawasooi i'ma'kato' uya pe iyesi intʉrʉ'pʉ iku'to' pe uya. ");
INSERT INTO akeNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Tato' sa'ne ko, ‘Asakɨrɨ'ne rɨken kapʉi e'ku'ka'sa' kiyari akʉ'pʉ rawɨrɨ.’ Ta uya ɨpɨ'nokon, apʉne wakʉ pe umɨ amʉ' enpɨ'tɨ'. Kiyari akʉ'pʉka'sa', tanʉnsen pe iyenaka'sa'. ");
INSERT INTO akeNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ka'pon, anʉmʉ pɨ' te'sen e'ma mɨrɨ, mɨrɨpan uya kiyari amʉranʉkʉ tɨwɨrɨ rɨ uko'man nɨto' ya'. Mɨrɨpan nin si, kʉrɨ rɨ ipɨnnin nʉ'pʉ mɨrɨ awonsi'kɨ anʉnnin nʉ'pʉ epori'mato' pe ɨsi'kaisa rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","I'napairɨ rɨ main esi mɨrɨ, ‘Tikin nan uya ipɨmɨ; tʉron nɨ uya anʉmʉ,’ tawon. ");
INSERT INTO akeNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ɨyenno'sa' uya 'nokon kiyari akʉ'pʉsa' anʉnse'na, umɨ ɨye'tʉrawasoma'pʉ kon pen nɨ yawon ya'. Tʉron kon e'tʉrawasoma'pʉ mɨrɨ yau, mɨrɨpan kon tʉrawasooi otori'pɨ nin si eporo auya'nokon,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tu'kan kon nɨ Sameriya pon kon mɨrɨ pata yawon kon uya Sises apurɨ'pʉ, apʉne pʉra uri'san uya, “Tanporon nɨ unku'pɨtʉ'pʉ ekamasa' iya upɨ',” tasa' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Mɨrɨpan nin si, Sameriya pon kon uye'sa' a'tai nin si ipiya', to' uya ekama'po'pʉ ipan pe tʉpiyau'nokon iko'manto' pe; mɨrɨ yau, Sises uko'mamʉ'pʉ asa'rɨ wʉi to' piyau. ");
INSERT INTO akeNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tu'kan kon uya rɨ nin si apurɨ'pʉ mɨrɨ imaimu etasa' tʉuya'nokon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mɨrɨpan kon uya ta'pʉ uri'san pɨ', “Ina si napurɨyan, tasa' auya pɨ' rɨken pen, e'tane tiwano' kon pe rɨ etasa' tʉuya'nokon pɨ', ina uya si i'tu i'napai rɨ kuru rɨ pata pika'tɨnin pe iyesi,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Asa'rɨ wʉi ennoko tʉpo mɨrɨ yau, mɨrɨ tʉnɨnse Sises utɨ'pʉ Kiyarari pona. ");
INSERT INTO akeNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Sises uya rɨ, “Pu'kena' namanin pʉn nɨ ipata'se' yau,” tasa' esi'pʉ.) ");
INSERT INTO akeNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kiyarari pona itɨsa' a'tai, mɨrɨ yawon kon ka'pon amʉ' uya wakʉ pe kuru ereutanʉkʉ'pʉ, apʉne pʉra itɨsa' kon nʉ'san pe to' esi'pʉ To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ pɨ' Surusiran pona, mɨrɨpan kon uya tanporon nɨ inkupʉnʉ ensa' esi'pʉ mɨrɨ a'tai. ");
INSERT INTO akeNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Serɨ rɨken pe Sises uya Kena, Kiyarari airon ka'kʉranpa'pʉ, tuna koneka'pʉ tʉuya yau waain pe. Mɨrɨ yau, ka'pon, kin poitorʉ pe te'sen esi'pʉ, takuru'kenan imu Ka'paneyan po. ");
INSERT INTO akeNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pʉse rɨ ka'pon uya Sises uye'sa' Isutiya poi Kiyarari pona ta etasa' a'tai, itɨ'pʉ ipiya' ekama'poi' itɨto' pe Ka'paneyan pona tʉmu epi'tɨi', teri'ka'sen nɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Sises uya, “Ɨnʉ' uya apurɨ pʉra rɨ iyesi eke Papa tʉrawasooi i'tuto' ipɨkɨrɨ mɨrɨ awonsi'kɨ a'kwarʉpɨ'nin nɨken e'kupʉ a'tai apurɨ auya'nokon,” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kin poitorʉ uya, “Itepuru, uya'kɨrɨ utɨnpai umʉre erikʉ rawɨrɨ,” ta'pʉ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Sises uya, “Enta, ɨmu rɨ uto'pamʉ mɨrɨ,” ta'pʉ ipɨ'. Sises maimu tapurɨi' itɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ite'matai tʉuye'se, itekare ke ipoitorʉ ton uya eporo'pʉ. “Ɨmu uto'pan nɨ pɨ' rɨ man!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","To' ekama'po'pʉ iya, ɨ'rɨ a'kʉra' kuru tʉmu uto'pamʉ'pʉ tukai', mɨrɨpan kon uya, “Ko'mamiyau, 1 a'kʉra' ko'mamʉ pe iye'kɨɨi'mato' ereuta'pʉ,” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ikʉipʉnʉ uya i'tu'pʉ mɨrɨ a'kʉra' kuru rɨ Sises uya, “Ɨmu rɨ uto'pamʉ mɨrɨ,” ta'pʉ rʉ'pʉ. Mɨrɨ pɨ' kʉrɨ rɨ mɨrɨ awonsi'kɨ tanporo itonpa ton ena'pʉ apurɨnin nan pe. ");
INSERT INTO akeNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Serɨ serɨ iyakon ite'kwa pe eke Papa tʉrawasooi ti'tuto' ipɨkɨrɨ kupʉ'pʉ Sises uya tʉuyepʉ tʉpo Isutiya poi Kiyarari pona. ");
INSERT INTO akeNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mɨrɨ tʉpo, Esuwerʉ amʉ' enta'nato' weyu pɨ' Sises utɨ'pʉ Surusiran pona. ");
INSERT INTO akeNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Moro iyesi Surusiran po karimeru mʉra'ta airɨ, iku'pɨ mʉre'pʉ 5 kaisaron enkurun nɨto' itau ton esa'; Ipuru amʉ' maimu yau Pe'sata tato' ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Anpisin ton kuru rɨ takuru'kena' nan ɨpɨrinpɨ'sa' esi'pʉ mɨrɨ tau'ne, tenku'na' nan, sekentei'pa' nan ipu'tɨka'sa' kon nɨ. (Tuna e'tʉkʉi'tʉkʉi'ma enupɨkɨrɨ to' enurikʉ, ");
INSERT INTO akeNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","apʉne pʉra ɨsipɨkɨrɨ Papa inserʉʉi u'tɨ iku'pɨ mʉre'pʉ ka', mɨrɨpan uya tuna sokousokouma. Takuru'kenan si wapiya tʉutɨsen iku'pɨ mʉre'pʉ ka' iyesokousokouma'pʉ tʉpo usepi'tɨpɨtʉ'pʉ ti'tui' pʉra rɨ teparan kon pe te'sen apai.) ");
INSERT INTO akeNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mɨrɨ yau si ka'pon esi'pʉ mɨrɨ takuru'ke iko'mansa' 38 kaisa rɨ wʉipiya. ");
INSERT INTO akeNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Sises uya iyɨpɨrinkasa' ene'pʉ mɨrɨ yau, i'tu'pʉ iya inke rɨ takuru'ke iko'mansa', mɨrɨpan uya, “Ɨsepi'tɨpai pe' me'an?” ta'pʉ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Takuru'kenan uya eikʉ'pʉ, “Itepuru, ɨnʉ' pʉra rɨ iyesi serɨ yau utʉnin iku'pɨ ka' tuna e'sokousokouma a'tai, ɨtɨ i'se rʉ'kwɨ e'tane ika', tʉron nɨ utɨkapʉ uwapiya,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Sises uya, “E'mʉ'sa'ka', ayapon tanʉnse enta!” ta'pʉ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mɨrɨ a'tai rɨ isepi'tɨ'pʉ; tapon tanʉnse itɨ'pʉ. Serɨ e'kupʉ'pʉ mɨrɨ Sapa' a'tai. ");
INSERT INTO akeNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mɨrɨ pɨ' Esuwerʉ amʉ' epuru ton uya, “Sapa' serɨ; wakʉ pe pʉra iyesi Main, Mosi' winon pona ayapon arɨ pɨ' me'ai'ne',” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","To' eikʉ'pʉ iya, “Kʉrɨ uyepi'tɨnin nʉ'pʉ uya, ‘Ayapon tanʉnse enta,’ tasa' upɨ',” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","To' uya ekama'po'pʉ, “Ɨnʉ' pe si kʉrɨ rɨ esi, ‘Ayapon tanʉnse enta,’ tawon ɨpɨ'?” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","E'tane kʉrɨ rɨ isepi'tɨsa' rʉ'pʉ uya i'tu pʉra iyesi'pʉ ɨnʉ' pe iyesi tukai', apʉne pʉra anpisin pe mɨrɨ yau to' esi'pʉ, mɨrɨpan kon koro'tawɨrɨ Sises utɨ'pʉ esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mɨrɨ pata'pʉ pe, Sises uya eporo'pʉ use'man nɨto', ɨpʉreman nɨto' iwʉ' tau, mɨrɨpan uya ta'pʉ ipɨ', “Apʉne enkɨ, wakʉ pe si ɨyenasa' mɨrɨ. Amakooi inonkakɨ, ɨsɨ kuru rɨ e'kupʉ namai' ɨpɨ' inonka auya pʉra iyesi yau,” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mɨrɨpan utɨ'pʉ Esuwerʉ amʉ' epuru ton pana'tɨi' Sises uya kenʉ' tepi'tɨsa' ka'se'na. ");
INSERT INTO akeNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Serɨ wenai, Sises ewa'noma pɨ' to' e'sara'tɨ'pʉ, apʉne pʉra usepi'tɨn ku'sa' iya pɨ' Sapa' a'tai. ");
INSERT INTO akeNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Sises uya to' eikʉ'pʉ, “Ukʉipʉnʉ esi te'tʉrawasomasen inke rɨ; urɨ nɨrɨ e'tʉrawasomato' pe iyesi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Serɨ tawon uya rɨ Esuwerʉ amʉ' epuru ton kupʉ'pʉ miyarɨ rɨ ɨnwɨpai; Main nɨken Sapa' pɨ' enupanin i'kwɨ'sa' iya pen, e'tane Papa esi tʉkʉipʉnʉ pe kuru tasa' iya pɨ', serɨ winɨ si Papa kaisarɨ rɨ iye'ku'sa' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Mɨrɨ pɨ' Sises uya to' eikʉ'pʉ, “I'napairon ekama uya ɨpɨ'nokon: tiwano' pe ɨ'rɨ rɨ kupʉ imu uya pen, tʉkʉipʉnʉ nʉkupʉnʉ rɨken ensa' tʉuya kupʉ iya, apʉne pʉra ɨ'rɨ rɨ kupʉ ikʉipʉnʉ uya a'tai, imu uya rɨ nɨrɨ ikupʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ikʉipʉnʉ uya imu i'nʉnka, mɨrɨpan uya tanporon nɨ tʉnkupʉnʉ enpoika itena'. Serɨ entaino kuru rɨ enpoika iya mɨrɨ iku'to' pe iya, mɨrɨ uya ɨyewansiukato' oton kon. ");
INSERT INTO akeNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ikʉipʉnʉ iyeri'sa' kon i'mʉ'sa'kayai'ne' nurɨne to' ku'ai'ne' kasa rɨ marɨ, imu uya nurɨne rɨ to' e'to' pe to' kupʉ, i'se te'to' ton nɨ kupʉ iya nurɨne. ");
INSERT INTO akeNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mɨrɨ rɨken pe pʉra, ɨnʉ' rɨ eseru aimenka ikʉipʉnʉ uya pen. Tʉmu ena' eseru aimenkato' ike nonkasa' iya, ");
INSERT INTO akeNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","tanporon kon uya tʉmu namato' pe ikʉipʉnʉ nama tʉuya'nokon kasa rɨ marɨ. Ɨnʉ' uya rɨ imu nama pʉra iyesi yau, ikʉipʉnʉ nama iya pʉra rɨ marɨ iyesi mɨrɨ enno'nin nʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“I'napairon ekama uya ɨpɨ'nokon: Ɨnʉ' uya rɨ umaimu eta a'tai, mɨrɨ awonsi'kɨ uyenno'nin nʉ'pʉ apurɨ a'tai, kʉrɨ rɨ uya tɨwɨrɨ uko'man nɨto' eposa' mɨrɨ. Iteseru aimenkato' oton pen nɨ, iye'kwɨrɨ'ka'sa' pe rɨ iyesi uma'tan nɨto' apai uko'man nɨto' ya'. ");
INSERT INTO akeNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“I'napairon ekama uya ɨpɨ'nokon: Iweyu uye'nɨ pɨ' man, iye'ka'sa' rɨ, iyeri'sa' kon uya Papa Mumu maimu eta weyu, kamoro nin si etanin nan uko'manto' oton. ");
INSERT INTO akeNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ikʉipʉnʉ esi na'ne' kasa uko'man nɨto' esa' pe, mɨrɨ kasa rɨ marɨ tʉmu konekasa' iya uko'man nɨto' esa' pe. ");
INSERT INTO akeNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Mɨrɨ awonsi'kɨ tʉmu repasa' iya eseru aimenka meruntɨrʉ ke, apʉne pʉra Ka'pon, Papa winon pe iyesi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Serɨ pɨ' kɨsewansiukatʉu; iweyu uye'nɨ pɨ' man tanporon kon iyeri'sa' kon uruwai' yawon kon uya imaimu eta weyu, ");
INSERT INTO akeNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","mɨrɨpan kon epa'kato' oton tʉuruwasii kon apai: kamoro wakʉ ku'nin nʉ'san e'mʉ'sa'kato' oton tʉuko'manto' kon pe, mɨrɨ awonsi'kɨ kamoro ɨri ku'nin nʉ'san e'mʉ'sa'kato' oton teno'mato' kon ya'. ");
INSERT INTO akeNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Uiwano' pe ɨ'rɨ rɨ kupʉ uya pʉra iyesi. Ka'pon eseru aimenka uya Papa uya uyauro'kasa' awɨrɨ. Mɨrɨ wenai iye'to' awɨrɨ ka'pon eseru aimenka uya, apʉne pʉra i'se e'to' kupʉ uya kasa pʉra, e'tane kʉrɨ uyenno'nin nʉ'pʉ e'to' i'se rɨken. ");
INSERT INTO akeNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Urɨ pe rɨ uyeseru ekama uya a'tai, unekamanʉ esi tapurɨsen pe pʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mɨrɨ yau, tʉron nɨ esi uyekamanin i'napai rɨ uyekama iya tukai' i'tu uya. ");
INSERT INTO akeNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Isaan piya' amaimu kon esanon ennoko'pʉ auya'nokon, mɨrɨpan uya i'napairon enpoika'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ka'pon uya uyekama i'se e'tane pʉra rɨ, e'tane serɨ ta uya ɨpɨ'nokon iyepika'tɨsa' pe ɨwesi kon pa. ");
INSERT INTO akeNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Isaan esi'pʉ raan'pu tepo'tɨsen pata weyu pe kasa, mɨrɨpan weyu yau e'pai ɨwesi'pʉ kon aka'ne' pe rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“E'tane upiyau uiwano' pe rɨ usekamato' esi Isaan uya ekama'pʉ na'ne' entaino. Tʉrawaso unkupʉnʉ i'ma'kato' pe uya ukʉipʉnʉ nʉtʉrʉ'pʉ, mɨrɨ ton uya rɨ ekama ikʉipʉnʉ uya uyenno'sa' tukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ikʉipʉnʉ uyenno'nin nʉ'pʉ usauro'sa' upɨ', imaimu etasa' auya'nokon pʉra iyesi, itemʉ' nɨrɨ ensa' auya'nokon pʉra rɨ nɨrɨ iyesi. ");
INSERT INTO akeNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Imaimu ko'manʉkʉ auya'nokon pʉra nɨrɨ iyesi ɨyewan kon yau, apʉne pʉra inennoko'pʉ apurɨ auya'nokon pʉra iyesi ke. ");
INSERT INTO akeNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Iye'menukasa' itekare pɨ' ɨusenupa kon; tɨwɨrɨ uko'man nɨto' esi iyau tukai' ɨusenuminka kon pɨ', upɨ' rɨ si tʉusauro'sen. ");
INSERT INTO akeNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","E'tane rɨ, upiya' ɨsi'pai pʉra ɨwesi kon ɨuko'manto' kon epose'na. ");
INSERT INTO akeNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ka'pon amʉ' uya rɨ uyapurɨpɨ'to' i'se esi pen. ");
INSERT INTO akeNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","E'tane ɨi'tu uya 'nokon Papa i'nʉnkato' auya'nokon pʉra iyesi ɨyewan kon yau. ");
INSERT INTO akeNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","“Ukʉipʉnʉ ese' yau uye'sa' e'tane uyereutanʉ'sa' auya'nokon pʉra iyesi. E'tane tʉron nɨ uye'sa' a'tai tese' yau, kʉrɨ rɨ ereutanʉkʉ auya'nokon mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ɨ'rɨ tukai' apurɨ auya'nokon ɨtonpa kon winɨ ayapurɨpɨ'to' kon eponin nan pe esii'ma, e'tane ɨ'rɨ rɨ kupʉ auya'nokon pʉra iyesi ayapurɨpɨ'to' kon eporo kon pa tikin nan nɨ Papa winɨ tʉuye'sen? ");
INSERT INTO akeNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Kɨsenuminkatʉu urɨ uya ikʉipʉnʉ ena' ɨyeseru'tɨ kon tukai', Mosi' rɨken kʉrɨ rɨ ɨyeseru'tɨnin kon, kʉrɨ rɨ anapurɨ'pʉ kon. ");
INSERT INTO akeNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosi' apurɨsa' auya'nokon pe iyesi yau, uyapurɨsa' auya'nokon nɨrɨ nesii'no, apʉne pʉra urɨ pɨ' imenukasa' iya. ");
INSERT INTO akeNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","E'tane inmenuka'pʉ apurɨ auya'nokon pʉra iyesi pɨ', ɨ'rɨ tukai' umaimu apurɨ auya'nokon?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Serɨ pata'pʉ pe, Sises enna'po'pʉ parau ku'pɨri Kiyarari (parau ku'pɨri Taipiriyas tato' rɨ marɨ) ratoi pona. ");
INSERT INTO akeNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Anpisin uya kuru rɨ e'ma'pʉka'pʉ, apʉne pʉra ti'tuto' ipɨkɨrɨ ku'sa' iya pɨ' takuru'kena' nan pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Sises enuku'pʉ i'kʉrʉ pona, mɨrɨpan ereuta'pʉ tʉpoitorʉ ton pokon pe. ");
INSERT INTO akeNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ, Esuwerʉ amʉ' nʉkupʉnʉ e'seporo esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Sises uya tenu tʉsa' a'tai, anpisin pe kuru rɨ ka'pon amʉ' uyepʉ ene'pʉ iya tekare pɨ', ta'pʉ iya Piri' pɨ', “Nai yau pʉreti enna pʉsamoro ka'pon amʉ' nɨ'ton?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Serɨ ta'pʉ iya Piri' i'tupɨtʉ pe rɨ; tʉnkupʉnʉ pe te'sen i'tukapʉi'ma rɨ.) ");
INSERT INTO akeNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Piri' uya eikʉ'pʉ, “8 kaisaron kapʉi yau e'tʉrawasoman nɨsa' epe'pʉ uya eke pe kiyari enna pʉra rɨ iyesi mɨrɨ to' nonpa ton nʉ'kwɨ rɨ mara rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ipoitorʉ ton tonpa pe te'sen, Anturu, Saiman Pi'ta akon uya ta'pʉ ipɨ', ");
INSERT INTO akeNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Mɨrɨ yau warawo' mʉre man, 5 kaisa rɨ pʉreti mɨrɨ awonsi'kɨ asa'ron kon aiko ton moro' amʉ' esi ipiyau. Mɨrɨ e'tane ɨ'rɨ pʉ'kʉ pona itɨ tu'kan kon ewekʉ pɨ'?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","“Ka'pon amʉ' ereutato' pe iku'tɨ',” ta'pʉ Sises uya. (Mɨrɨ yau, wana' e'kwa pe pata esi'pʉ.) 5,000 kaisaron kon ka'pon amʉ' ereutapɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Sises uya pʉreti anʉmʉ'pʉ, mɨrɨ awonsi'kɨ tenki ta'pʉ iya, mɨrɨ awonsi'kɨ itʉpɨtʉ'pʉ iya iyereutasa' kon ka'pon amʉ' ena'. Mɨrɨ kasa rɨ marɨ moro' amʉ' kupʉ'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","To' a'wetapɨ'sa' a'tai, Sises uya ta'pʉ tʉpoitorʉ ton pɨ', “Ipʉ'kʉ rʉ'pʉ ton amʉranʉ'tɨ', itonpa'pʉ uma'ta namai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Mɨrɨ, to' uta're'tɨ'pʉ tonpa'pʉ amʉranʉkʉ'pʉ to' uya 12 kaisa rɨ pa'siki'ti amʉ' tʉpe' ke'ne. ");
INSERT INTO akeNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mɨrɨ a'tai, ka'pon amʉ' serɨ eke Papa tʉrawasooi i'tuto' ipɨkɨrɨ e'kupʉ ennin nʉ'san uya ta'pʉ, “I'napai rɨ kuru rɨ pʉse rɨ esi Pu'kena' tʉuye'ton ta'pʉ ipɨ' pe,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Sises uya to' uya tanʉmʉ tʉmɨrɨ ta'kwarʉkai' kin pe, tukai' i'tusa' a'tai, itɨ'pʉ tikin sarɨ i'kʉrʉ pona. ");
INSERT INTO akeNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pata uko'mansa' a'tai, ipoitorʉ ton utɨ'pʉ parau ku'pɨri ka', ");
INSERT INTO akeNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","mɨrɨpan kon ekanwa'tɨsa' utɨ'pʉ parau ku'pɨri ratoi pona Ka'paneyan winɨkʉi'. Pata ewarumankaa'pʉ, Sises uye'sa' pʉra rɨ marɨ iye'tane to' piya'. ");
INSERT INTO akeNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Pana' pe a'setun uyee'pʉ ɨsɨ pe sipa'sipa pe tuna tʉku'se. ");
INSERT INTO akeNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ipoitorʉ ton utɨka'sa' esi'pʉ kanau yau 3 mayirʉ, 4 mayirʉ e'to' airɨ rɨ, mɨrɨ a'tai Sises uyepʉ ene'pʉ to' uya tuna pʉro'po. A'ko pe kanau piya' iyepʉ a'tai, to' etʉipɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","E'tane, “Ketʉipɨ'tʉu; urɨ rɨ,” ta'pʉ Sises uya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Mɨrɨ a'tai, to' uya ikanwa'tɨ'pʉ kanau ya', mɨrɨpan kon uya pata tʉutɨto' kon ya' eporo'pʉ inke pʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mɨrɨ ema'sa' yau, anpisin ton parau ku'pɨri ratoi po iye'nɨnsa' kon uya tikin nan nɨken kanau utɨ'pʉ i'tu'pʉ. To' uya i'tu'pʉ Sises utɨ pʉra iyesi'pʉ kanau yau tʉpoitorʉ ton a'kɨrɨ, ipokon pe pʉra to' utɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tʉron nɨ ton kanau amʉ' uyee'pʉ Taipiriyas winɨpai'ne, mɨrɨpan e'te'kapɨtʉ'pʉ a'ko pe ka'pon amʉ' anpisin ton uya pʉreti ɨku'pʉ airɨ, Sises uya tenki ta tʉpo. ");
INSERT INTO akeNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Sises mɨrɨ pe pʉra ipoitorʉ ton ene tʉuya'nokon kasa pʉra, ka'pon amʉ' anpisin ton ekanwa'tɨpɨ'sa' kanau ton ya' utɨ'pʉ Ka'paneyan pona, iwarinpa pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ka'pon amʉ' uya Sises eposa' a'tai parau ku'pɨri ratoi po, ta'pʉ to' uya ipɨ', “Rapai, ɨ'rɨ a'tai serɨ ya' ɨuyee'pʉ?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Sises uya to' eikʉ'pʉ, “I'napairon ekama uya ɨpɨ'nokon; uwarinpa auya'nokon, apʉne pʉra eke pe rɨ pʉreti ɨ'sa' auya'nokon pɨ' i'se ɨwe'to' kon awɨrɨ rɨ, ui'tuto' ipɨkɨrɨ ku'sa' uya to'ka'nʉ'sa' auya'nokon pɨ' pen nɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Aka'nero' rɨ kiyari pɨ' ke'tʉrawasomatʉu; e'tʉrawasomatɨ' tɨwɨrɨ rɨ ɨuko'manto' kon pe ɨku'nin kon kiyari pɨ'. Serɨ kiyari ke Ka'pon, Papa winon uya ɨrepa kon mɨrɨ. Papa, ikʉipʉnʉ uya enpoikasa' ɨyena'nokon urɨ piyau meruntɨ esi,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mɨrɨpan kon uya ekama'po'pʉ, “Ɨ'rɨ kuru ken kupʉ ina uya, Papa tʉrawasooi kupʉ pe ta auya?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Sises uya to' eikʉ'pʉ, “Se serɨ Papa tʉrawasooi ikupʉ auya'nokon i'se iye'to'; inennoko'pʉ apurɨtɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","To' uya eikʉ'pʉ, “Ɨ'rɨ eke Papa tʉrawasooi ɨi'tuto' ipɨkɨrɨ kupʉ auya ina nenton, ina uya ayapurɨto' pe? Ɨ'rɨ kupʉ auya? ");
INSERT INTO akeNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Utamokori kon uya mana tato' ɨ'pɨtʉ'pʉ rɨmono' tau, itekare iye'menukasa' nekamayai'ne', ‘To' nɨ'ton pʉreti ke to' repapɨtʉ'pʉ iya Epʉn poi,’ tukai',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","“I'napairon ekama uya ɨpɨ'nokon; Mosi' uya ɨrepa'pʉ kon na'ne' ike esi'pʉ Epʉn poino pen nɨ; ukʉipʉnʉ nin kʉrɨ rɨ i'napairon Epʉn poino pʉreti ke ɨrepanin kon. ");
INSERT INTO akeNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Pʉreti, Papa nʉtʉrʉnʉ nin kʉrɨ rɨ Epʉn poi iu'tɨsa' pata repanin uko'man nɨto' ke,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","“Itepuru, tɨwɨrɨ rɨ ken si serɨ pʉreti ke ina irepapɨ'kɨ,” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","“Urɨ rɨ esi uko'man nɨto' a're' pe; kʉrɨ upiya' nʉye'ai'ne' e'to' oton pen nɨ iwan pe; kʉrɨ uyapurɨ pɨ' na'ne' e'to' oton pen nɨ tuna'kiri' ke. ");
INSERT INTO akeNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Sekamai ko ɨpɨ'nokon; uyenka'sa' auya'nokon e'tane uyapurɨ auya'nokon pen nɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tanporon kon ukʉipʉnʉ urepayai'ne' ike ton uyepʉ mɨrɨ upiya'; ɨnʉ' rɨ upiya' tʉuye'sen nurunpa uya pʉra rɨ iyesi, ");
INSERT INTO akeNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","apʉne pʉra uye'sa' serɨ Epʉn poi uyenno'nin nʉ'pʉ eseru ku'se'na, uyeseru ku'se'na pen. ");
INSERT INTO akeNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Kʉrɨ uyenno'nin nʉ'pʉ esi se kupʉ uya i'se; kamo urepa'pʉ iya ike ton nonka uya i'se pʉra iyesi, e'tane tanporo to' i'mʉ'sa'kato' pe uya pata weyu u'ma'sa' a'tai. ");
INSERT INTO akeNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ukʉipʉnʉ eseru esi tanporon kon imu ennin nʉ'san mɨrɨ awonsi'kɨ apurɨnin nʉ'san uya tɨwɨrɨ rɨ uko'man nɨto' epoto' pe; to' i'mʉ'sa'kato' pe uya pata weyu u'ma'sa' a'tai,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Esuwerʉ amʉ' e'sara'tɨ'pʉ ipɨ' entarun nɨ pɨ', apʉne pʉra, “Urɨ kʉrɨ rɨ pʉreti Epʉn poi iu'tɨsa',” ta iya pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Mɨrɨpan kon uya, “Sises sa'ne pʉse rɨ ko, Isose' mu, pen pe'? Ikʉipʉnʉ mɨrɨ awonsi'kɨ isan uni'tunʉ kon. Nai kasa, ‘Epʉn poi u'tɨsa',’ ta iya nin si?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Sises uya to' eikʉ'pʉ, “Ɨyentarunto' kon e'paka'nʉ'tɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ɨnʉ' rɨ uyepʉ pʉra iyesi mɨrɨ upiya' ikʉipʉnʉ, uyenno'nin nʉ'pʉ uya rɨken ikɨ'ma a'tai upiya' iyepʉ rɨ; mɨrɨpan i'mʉ'sa'kato' uya oton pata weyu u'ma'sa' a'tai. ");
INSERT INTO akeNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Pu'kena' amʉ' uya imenukasa', ‘Tanporon kon nɨ ka'pon amʉ' enupato' oton Papa uya,’ tawon. Mɨrɨ pɨ', tanporon kon ikʉipʉnʉ maimu etanin nan mɨrɨ awonsi'kɨ iwinɨ tʉusenupasan uyepʉ upiya'. ");
INSERT INTO akeNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Serɨ uya, ɨnʉ' uya rɨ ikʉipʉnʉ ene'pʉ ta pen; kʉrɨ Papa winon uya rɨken ikʉipʉnʉ ene'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","I'napairon ekama uya ɨpɨ'nokon; kʉrɨ apurɨpɨ' na'ne' uya tɨwɨrɨ rɨ uko'man nɨto' eposa'. ");
INSERT INTO akeNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Uko'man nɨto' a're' pʉreti pe esi. ");
INSERT INTO akeNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Atamokori kon amʉ' uya mana tato' ɨ'pɨtʉ'pʉ rɨmono' tau, e'tane to' eri'pɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","E'tane serɨ nin si pʉreti Epʉn poi iu'tɨsa'; ɨnʉ' rɨ ɨ'nin nʉ'pʉ erikʉ pen nɨ nin. ");
INSERT INTO akeNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","To'panʉ'nin pʉreti pe esi, Epʉn poi iu'tɨsa'. Ɨnʉ' uya rɨ serɨ pʉreti ɨ'sa' yau, iko'manto' oton nɨ tɨwɨrɨ rɨ. Pʉreti serɨ upun, untʉton pata uya uko'man nɨto' epoto' pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Serɨ uya ɨsɨ pe Esuwerʉ amʉ' e'sei'pɨtʉ tiwano' kon pe sara'tɨ'pʉ. “Nai kasa tʉpun ke uya're'tɨ iya 'nokon?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Sises uya to' eikʉ'pʉ, “I'napairon ekama uya ɨpɨ'nokon; Ka'pon, Papa winon pun pɨ' auta're'tɨsa' kon pʉra iyesi yau, imʉnʉ rɨ ensisa' auya'nokon pʉra iyesi yau, uko'man nɨto' pʉra rɨ iyesi mɨrɨ ayau'nokon. ");
INSERT INTO akeNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ɨnʉ' rɨ upun pɨ' tʉuta're'tɨsen, umʉnʉ ensinin uya tɨwɨrɨ rɨ uko'man nɨto' eposa' mɨrɨ, mɨrɨpan i'mʉ'sa'kato' uya oton pata weyu u'ma'sa' a'tai. ");
INSERT INTO akeNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Upun esi pɨ' i'napairon kuru kiyari pe, umʉnʉ nɨrɨ i'napairon tensisen pe. ");
INSERT INTO akeNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Upun pɨ' tʉuta're'tɨsen nɨ, umʉnʉ ensinin nɨ uko'mamʉ mɨrɨ uyau, iyau nɨrɨ uko'mamʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tʉuko'mansen ikʉipʉnʉ uya uyenno'sa', kʉrɨ rɨ uriya' uko'mamʉ rɨ marɨ. Mɨrɨ kasa rɨ, upɨ' tʉuta're'tɨsen uko'mamʉ mɨrɨ urɨ uriya'. ");
INSERT INTO akeNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Se si esi pʉreti Epʉn poi iu'tɨsa'. Ɨku tʉpo atamokori kon amʉ' erikʉ'pʉ na'ne' waraino pen. Kʉrɨ serɨ ɨ'nin uko'manto' oton tɨwɨrɨ rɨ,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Sises uya serɨ ta'pʉ Esuwerʉ amʉ' usenupato' iwʉ' tau to' enupa tʉuya a'tai Ka'paneyan po. ");
INSERT INTO akeNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Serɨ etasa' tʉuya'nokon a'tai, tu'kan kon ipoitorʉ ton uya, “Sa'man pe kuru se usenupan nɨto' man. Ɨnʉ' uya rɨ serɨ anʉmʉ?” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ɨnʉ' uya tʉpana'tɨi' pʉra rɨ, Sises uya tʉpoitorʉ ton entarumʉ serɨ pɨ' i'tusa' esi'pʉ, mɨrɨpan uya ta'pʉ to' pɨ', “E'nonkapai na'kɨ serɨ ɨku'atʉu? ");
INSERT INTO akeNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ɨ'rɨ pe iyesi Ka'pon, Papa winon enuku ene auya'nokon a'tai wapiya tesi'pʉ ya'? ");
INSERT INTO akeNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Papa A'kwarʉ uya uko'man nɨto' tʉrʉ; se pe rɨ nin ka'pon meruntɨrʉ esi mɨrɨ. Main ton ayauro'kasa' uya 'nokon na'ne' ike esi, a'kwarʉ wannɨ mɨrɨ awonsi'kɨ uko'man nɨto' ku'nin. ");
INSERT INTO akeNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mɨrɨ e'tane moro man ɨtonpa kon amʉ' apurɨnin nan pen,” ta'pʉ iya. Sises uya i'tusa' esi'pʉ iyepiya'tɨ'pʉ si'kɨrɨ, apurɨnin nan pen mɨrɨ awonsi'kɨ teparanka ton. ");
INSERT INTO akeNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Mɨrɨpan uya ta'pʉ, “Serɨ pɨ' sa'ne si kanyauro'kata'tʉi ko: ɨnʉ' rɨ uyepʉ pʉra iyesi upiya' ikʉipʉnʉ uya rɨken iye'ku'to' pe iku'sa' a'tai iyepʉ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Mɨrɨ wʉi awonsi'kɨ, tu'kan kon nɨ ipɨkɨrɨ tʉutɨsan enna'po'pʉ, iya'kɨrɨ to' utɨ pʉra. ");
INSERT INTO akeNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mɨrɨpan pɨ' Sises uya ta'pʉ 12 kaisaron kon tʉpoitorʉ ton pɨ', “Ɨmɨrɨ'nokon si, e'nonkapai rɨ marɨ na'kɨ me'atʉu?” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saiman Pi'ta uya eikʉ'pʉ, “Uyepuru, ɨnʉ' piya' nɨrɨ ina utɨ? Ɨpiyau sa'ne Main esi mɨrɨ ko, tɨwɨrɨ rɨ uko'man nɨto' pe ku'nin. ");
INSERT INTO akeNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ina uya i'tu mɨrɨ awonsi'kɨ ina uya apurɨ ɨmɨrɨ esi Wakʉ, Papa iwano',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Sises uya eikʉ'pʉ, “12 kaisaron kon pe' ɨmɨrɨ'nokon anʉnnin nʉ'pʉ pen urɨ? Mɨrɨ e'tane, ɨtonpa kon esi makoi pe!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Isutas pɨ' isaurokʉ'pʉ, Saiman Eskariya' mu pɨ'. 12 kaisaron kon tonpa pe rɨ esii'ma, Isutas uya teparankato' oton pɨ'.) ");
INSERT INTO akeNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mɨrɨ tʉpo, Sises esi'pʉ upinin nɨ pɨ' Kiyarari awɨrɨ. Isutiya pona ɨtɨpai pʉra iyesi'pʉ, apʉne pʉra Esuwerʉ amʉ' epuru ton esi pɨ' tʉwɨnɨ i'se mɨrɨ yau. ");
INSERT INTO akeNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tʉusiwʉtʉntɨpɨ'se Esuwerʉ amʉ' nʉkupʉnʉ weyu e'seporo esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Mɨrɨ pɨ' si, iyakon non uya ta'pʉ Sises pɨ', “Serɨ tʉnɨnse, Isutiya pona enta, ɨpoitorʉ ton uya eke Papa tʉrawasooi kupʉ auya ento' pe. ");
INSERT INTO akeNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ɨnʉ' uya rɨ tʉnkupʉnʉ tʉtʉrawasooi onamʉ pʉra rɨ iyesi mɨrɨ ti'tu i'se e'nɨ yau. Serɨ ton amʉ' kupʉ auya pɨ', tɨwɨ tanporon pata ɨi'tui',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Iyakon non uya rɨ nɨrɨ apurɨ pʉra iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Sises uya ta'pʉ to' pɨ', “Uweyu pe kuru te'sen e'seposa' pʉra iyesi. Ɨweyu kon nin esi mɨrɨ ti'tui' pʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Pata uya ɨyewaruma'tɨ kon pʉra iyesi, e'tane uyewaruma'tɨ iya, apʉne pʉra ɨri pe ɨyeseru man ta uya pɨ' tʉpɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Entantɨ' tʉku'sen ya'. Mɨrɨ ya' nin utɨ pʉra man, apʉne pʉra uweyu pe kuru te'sen e'seposa' pʉra iyesi pɨ',” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Serɨ ta tʉpo, Kiyarari po iye'nɨmɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Takon non utɨ'pʉ tʉku'sen ya' tʉpo, Sises rɨ nɨrɨ si utɨkaa'pʉ, e'tane ama'ai rɨ nin itɨ'pʉ, eke pe ti'tui' pen. ");
INSERT INTO akeNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Esuwerʉ amʉ' epuru ton uya iwarinpa esi'pʉ tʉku'sen yau. “Nai kʉrɨ si?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mɨ awɨrɨ rɨ anpisin koro'tawɨrɨ etarerun nɨ pɨ' to' esi'pʉ ipɨ'. “Wakʉ kuru sa'ne,” ta'pʉ tʉron kon ka'pon amʉ' uya. “Kane,” ta'pʉ tʉron kon uya, “Ka'pon amʉ' rɨ enku'tɨ iya,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","E'tane eke pe annau to' usaurokʉ'pʉ pen ipɨ', apʉne pʉra Esuwerʉ amʉ' epuru ton pɨ' tenari'nʉmʉ kon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","To' nʉkupʉnʉ e'nonkakapʉ iwa koro'tau rɨ, Sises ewomʉ'pʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' ta', mɨrɨpan e'sara'tɨ'pʉ to' enupa pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Esuwerʉ amʉ' epuru ton usewansiuka'pʉ ipan pe rɨ, mɨrɨpan kon uya ta'pʉ, “Nai kasa pʉse rɨ uya eke pe rɨ i'tu, urɨ'nokon kasa enupasa' kasa rɨ?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Sises uya to' eikʉ'pʉ, “Ɨyenupato' kon uya ike esi uwinon pen nɨ, e'tane Papa, uyenno'nin nʉ'pʉ winɨ iyepʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ɨnʉ' rɨ Papa e'to' i'se ɨnku'pai na'ne' uya i'tuto' oton kɨnyenupayatʉi'ne' esi Papa winon pe mɨrɨ pe pʉra uiwano' pe rɨ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ka'pon tiwano' pe rɨ nʉsauro'ai'ne' esi tapurɨto' ipɨkɨrɨ rɨ i'se, kʉrɨ tenno'nin nʉ'pʉ apurɨto' ipɨkɨrɨ i'se te'sen esi mɨrɨ, usenku'tɨn ipɨ' pen nɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosi' uya Main ke ɨrepa'pʉ kon, pen nɨ katɨ? E'tane tikin nan nɨ iyawɨron pʉra rɨ iyesi. Ɨ'rɨ wenai uwɨpai ɨwesi kon?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ka'pon amʉ' anpisin ton uya eikʉ'pʉ, “Ene rɨ esi mɨrɨ ayau! Ɨnʉ' nai ɨwɨnɨ i'se?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Sises uya to' eikʉ'pʉ, “Tikin nɨ eke Papa tʉrawasooi kupʉ'pʉ uya, mɨrɨpan pɨ' ɨusewansiuka'pʉ kon. ");
INSERT INTO akeNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosi' uya ayapiyontɨ'pʉ kon ɨmunkɨ kon yun pi'pɨ puturʉkapɨtʉ kon pa (Mosi' pen nɨ e'tane atamokori kon amʉ' uya isara'tɨ'pʉ), Sapa' a'tai si warawo' mʉre yun pi'pɨ puturʉka auya'nokon. ");
INSERT INTO akeNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Warawo' mʉre yun pi'pɨ si puturʉka yau Sapa' a'tai, Mosi' maimu si e'kwɨtʉ namai', ɨ'rɨ pɨ' ken si upɨ' ausakorota kon ka'pon epi'tɨsa' uya pɨ' Sapa' a'tai? ");
INSERT INTO akeNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kɨpo'po rɨ ka'pon eseru aimenkato' auya'nokon ereutanʉ'tɨ', i'napairon yai eseru aimenkato' iku'tɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Mɨrɨ a'tai, tʉron kon ka'pon amʉ' Surusiran pon kon usekama'po'pʉ, “Pʉse rɨ pen pe' iwɨnɨ i'se to' na'ne'? ");
INSERT INTO akeNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Apʉne entɨ', iye'nama pʉra rɨ annau isaurokʉ, ɨnʉ' uya ɨ'rɨ ta pʉra rɨ ipɨ'. Pata epuru ton uya pe', Kʉrai rɨ ta pe iyesi ipɨ'? ");
INSERT INTO akeNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","E'tane sa'ne, Kʉrai uye'sa' a'tai, ɨnʉ' uya rɨ mɨrɨ winon tukai' i'tuto' pʉra rɨ nin iyesi. E'tane i'tu'nokon mɨrɨ winon pe tukai',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' tau ka'pon amʉ' enupai'ma eke pe tʉmaimu tʉku'se Sises uya, “Ui'tu auya'nokon kuru rɨ si, mɨrɨ winon tukai' kuru rɨ nɨrɨ. E'tane sa'ne uiwano' pe uye'sa' pen, e'tane rɨ uyenno'nin nʉ'pʉ esi ikasima auya'nokon pokena' pen nɨ. Ɨni'tunʉ kon pen nɨ, ");
INSERT INTO akeNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","e'tane uni'tunʉ, apʉne pʉra iwinon pe esi, mɨrɨ awonsi'kɨ inennoko'pʉ pe esi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Mɨrɨpan a'si i'se to' esi'pʉ, mɨrɨ e'tane ɨnʉ' uya rɨ a'pɨ'pɨtʉ'pʉ pen nɨ, apʉne pʉra iweyu e'seposa' pʉra rɨ marɨ iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","E'tane tu'kan kon anpisin tonpa ton uya rɨ apurɨ'pʉ, mɨrɨpan kon uya, “Kʉrai uye'sa' a'tai, pʉse rɨ nʉku'ai'ne' entai kuru nɨrɨ ken pe' eke Papa tʉrawasooi ti'tuto' ipɨkɨrɨ ku'to' iya oton?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pari'si amʉ' uya serɨ ton pɨ' ka'pon amʉ' etarerumʉ eta'pʉ, mɨrɨpan kon uya use'man nɨto' tʉrawasomanin nan epuru ton mɨrɨ awonsi'kɨ Pari'si amʉ' uya use'man nɨto', ɨpʉreman nɨto' iwʉ' erasu ton ennoko'pʉ Sises a'sise'na. ");
INSERT INTO akeNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Sises uya ta'pʉ, “Ɨpiyau'nokon esi serɨ mara rʉ'kwɨ parɨ, mɨrɨ awonsi'kɨ nin si utɨ mɨrɨ uyenno'nin nʉ'pʉ piya'. ");
INSERT INTO akeNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Uwarinpato' auya'nokon oton e'tane uyepoto' auya'nokon oton pen, apʉne pʉra iyau e'ai'ne' ya' ɨutɨ kon pʉra iyesi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Esuwerʉ amʉ' epuru ton usekama'po'pʉ tʉtonpa kon amʉ' pokon pe esii'ma, “Nai ya' mairɨ itɨ eporo poken pʉra? Kiri' amʉ' pata'se' airɨ katɨ itɨ Esuwerʉ amʉ' na'ne' airɨ, Kiri' amʉ' enupai'? ");
INSERT INTO akeNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‘Uwarinpato' auya'nokon oton e'tane uyepoto' auya'nokon oton pen,’ mɨrɨ awonsi'kɨ, ‘Iyau e'ai'ne' ya' ɨutɨ kon pʉra iyesi,’ ta iya pɨ' sa'ne. Ɨ'rɨ ta iya e'kwa pe iyesi?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Tʉku'sen weyu u'matʉ esi'pʉ ipan pe, eke pe kuru te'sen pe. Mɨrɨ wʉi a'tai, Sises e'soto'kasa' uya ta'pʉ eke pe tʉmaimu tʉku'se, “Ɨnʉ' rɨ tuna'kiri' ke te'sen nʉyepʉi upiya' tʉyuku epose. ");
INSERT INTO akeNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ɨnʉ' uya rɨ uyapurɨ pe iyesi a'tai, iye'menukasa' itekare nɨkayai'ne' kasa rɨ, ‘I'napaino rɨ to'panʉ'nin tuna epa'ka mɨrɨ iyapai,’” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Serɨ ta'pʉ Sises uya mɨrɨ, A'kwarʉ pɨ' kamoro tapurɨnin nan pe te'san nepoton pɨ'. Mɨrɨ a'tai, A'kwarʉ e'tʉsa' pʉra rɨ marɨ iyesi'pʉ, apʉne pʉra Sises enasa' pʉra iyesi'pʉ tapurɨpɨ'to' ya'. ");
INSERT INTO akeNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tu'kan kon ka'pon amʉ' anpisin koro'tawon kon uya serɨ ta iya eta'pʉ, mɨrɨpan kon uya, “Pʉserɨ rɨ esi serɨ Pu'kena' pe,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tʉron kon uya, “Kʉrai pʉse rɨ,” ta'pʉ. Mɨrɨ e'tane tʉron kon uya, “Kʉrai uye'to' pʉra rɨ iyesi Kiyarari winɨpai. ");
INSERT INTO akeNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Iye'menukasa' itekare uya ta, Kʉrai e'to' pe iyesi kin Tepi' pa rʉ'pʉ pe, Pe'teri'en po iyentu, Tepi' uko'mamʉ'pʉ rʉ'pʉ yau,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mɨrɨ pɨ' si ka'pon amʉ' epantakapɨtʉ'pʉ kʉrɨ rɨ uriya'. ");
INSERT INTO akeNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tʉron kon esi'pʉ a'si i'se, e'tane ɨnʉ' uya rɨ temiyatʉ tʉrʉ'pʉ pen ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Erasu ton enna'po'pʉ use'man nɨto' tʉrawasomanin nan epuru ton mɨrɨ awonsi'kɨ Pari'si amʉ' piya', mɨrɨpan kon uya ta'pʉ to' pɨ', “Ɨ'rɨ pɨ' tʉne'se pʉra ɨwesi'pʉ kon?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Mɨrɨ pɨ' erasu ton uya, “Ɨnʉ' rɨ usaurokʉ pʉra iyesi pʉse rɨ kasa,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","“Ɨyenku'tɨsa' iya 'nokon kanan na'kɨ?” ta'pʉ Pari'si amʉ' uya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“Itepuru tonpa ton nɨ mɨrɨ pe pʉra Pari'si amʉ' tonpa ton nɨ uya pe' apurɨ tukai' mi'tuyatʉu? ");
INSERT INTO akeNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pʉsamoro uya main, Mosi' winon i'tu pʉra iyesi mɨrɨ; mɨrɨ wenai, Papa nʉpa'nʉkʉ'san pe to' esi mɨrɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nekutimas esi'pʉ to' tonpa pe, wapiya ewarupɨ nau itɨsa' rʉ'pʉ Sises piya', ");
INSERT INTO akeNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","mɨrɨpan uya, “Main uya, ‘Ka'pon pɨ' ɨri ta pʉra iyesi eta tʉpo pʉra rɨ mɨrɨ awonsi'kɨ inkupʉ'pʉ eposa' pen nɨ e'tane,’ tasa',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","“Kiyarari pon nɨ marɨ pe' ɨmɨrɨ? Iye'menukasa' itekare pɨ' ɨsenupa'; mɨrɨ a'tai, i'tu auya mɨrɨ Pu'kena' uye'to' pʉra rɨ iyesi Kiyarari winɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mɨrɨ a'tai, tanporon kon utunta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","E'tane Sises utɨ'pʉ Are' Wʉpʉ pona. ");
INSERT INTO akeNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mɨrɨ ema'sa' yau awanakʉi' iyenna'po'pʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' pʉ'kʉ ta'. Anpisin pe ka'pon amʉ' amʉra'pʉ iwoi, mɨrɨpan ereuta'pʉ to' enupase'na. ");
INSERT INTO akeNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Main pɨ' enupanin nan mɨrɨ awonsi'kɨ Pari'si amʉ' uya uri'san nee'pʉ, iyekuma koro'tau tʉneporo'pʉ kon, mɨrɨpan soto'ka'pʉ to' uya tu'kan kon annau, ");
INSERT INTO akeNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","mɨrɨpan kon uya ta'pʉ Sises pɨ', “Ti'sa, pʉse rɨ uri'san eposa' ina uya ekuman pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Main yau Mosi' uya ina pɨ' tasa' kamoro waraino kon uri'sami'si amʉ' tʉwɨsan tɨ' ke, tasa' iya. Ɨ'rɨ ken mʉkayan?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Serɨ tukai' to' uya ekama'po'pʉ tʉmusunu kon pe eseru'tɨto' tʉuya'nokon ipɨkɨrɨ pe. E'tane Sises e'tɨmuika'pʉ, mɨrɨpan e'sara'tɨ'pʉ non menuka pɨ' temiyatʉ ke. ");
INSERT INTO akeNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Tekama'popɨtʉ pɨ' rɨ to' e'tane, iye'mʉ'sa'kasa' uya ta'pʉ to' pɨ', “Ɨnʉ' rɨ ɨ'koro'tawon kon esi yau imakooi pʉra, tɨwɨ si asara'tɨi'nokon tɨ' ke iwɨnɨ pɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mɨrɨpan e'tɨmuikakaa'pʉ kanan non menukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mɨrɨ pɨ', kamoro etanin nʉ'san e'sara'tɨ'pʉ utɨpɨ' nɨ pɨ' tikin pa'ne, kɨɨyi' amʉ' wapiya, Sises rɨken tʉnonkai', uri'san nɨken si e'soto'kasa' mɨrɨ yau pokon pe. ");
INSERT INTO akeNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Sises e'mʉ'sa'ka'pʉ, mɨrɨpan uya ekama'po'pʉ, “Ma'non, nai kamo si? Ɨnʉ' uya ɨri ta uya uya ɨyeno'masa' pʉra rɨ?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Itepuru, ɨnʉ' pʉra rɨ man,” ta'pʉ iya. “Urɨ uya rɨ nɨrɨ si ɨri ta pe ɨyeno'mato' pʉra man. Enta si, makoi yau ɨuko'manto' tʉnonkai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ka'pon amʉ' auro'kakapʉ tʉuya a'tai kanan, Sises uya ta'pʉ, “Pata weyu pe esi. Ɨnʉ' rɨ upɨkɨrɨ tʉuye'sen uya, uko'man nɨto' weyu eporo mɨrɨ, mɨrɨ awonsi'kɨ ewarupɨ yau isato' oton pen nɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pari'si amʉ' uya ta'pʉ ipɨ', “Mɨrɨ si ɨiwano' pe ɨusekama, mʉkayai'ne' esi mɨrɨ i'napai rɨ pʉra rɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Sises uya to' eikʉ'pʉ, “Uiwano' pe rɨ si usekama pe iyesi yau, ukayai'ne' nin si esi i'napairɨ rɨ, apʉne pʉra iwinɨ uye'sa' rʉ'pʉ mɨrɨ awonsi'kɨ utɨto' ya' i'tu uya. E'tane nai winɨ uye'sa', nai ya' utɨ tukai' i'tu auya'nokon pʉra iyesi. ");
INSERT INTO akeNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ka'pon pe kuru rɨ eseru aimenka auya'nokon; ɨnʉ' eseru aimenka uya pʉra nin man. ");
INSERT INTO akeNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","E'tane ɨnʉ' rɨ eseru aimenka uya pe iyesi yau, iyawɨrɨ kuru iku'sa' uya mɨrɨ, apʉne pʉra tikin sarɨ esi kasa pʉra, ikʉipʉnʉ, uyenno'nin nʉ'pʉ pokon pe esi. ");
INSERT INTO akeNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ɨiwano' kon nɨ Main, Mosi' winon yau iye'menukasa', asa'ron kon ka'pon amʉ' uya ekama a'tai i'napai rɨ iyesi tasa'. ");
INSERT INTO akeNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Uiwano' pe rɨ si usekama, tʉron nɨ uyekamanin kanan esi ikʉipʉnʉ, uyenno'nin nʉ'pʉ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Mɨrɨ a'tai, to' uya ekama'po'pʉ, “Nai kʉrɨ ken si ɨkʉipʉnʉ?” ta'pʉ to' uya. “Ui'tu auya'nokon pʉra iyesi, ukʉipʉnʉ rɨ nɨrɨ i'tu auya'nokon pʉra iyesi. Ui'tu auya'nokon yau, ukʉipʉnʉ rɨ nɨrɨ mi'tutʉi'no,” tukai' to' eikʉ'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Serɨ ta pɨ' Sises esi'pʉ to' enupai'ma Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' pʉ'kʉ tau, to' use'mato' en ton pata piyau iwa esii'ma. E'tane ɨnʉ' uya a'si'pʉ pen nɨ, apʉne pʉra iweyu e'seposa' pʉra iyesi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Sises uya kanan takaa'pʉ to' pɨ', “Utɨto' oton mɨrɨ. Uwarinpato' auya'nokon oton, e'tane amakooi kon yau rɨ auma'tato' oton kon. Ɨutɨ kon pʉra iyesi utɨyai'ne' ya',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Serɨ uya Esuwerʉ amʉ' usekama'po emapu'tɨ'pʉ, “Tiwano' pe pe' iye'wɨnɨ? Mɨrɨ pɨ' pe', ‘Ɨutɨ kon pʉra iyesi utɨyai'ne' ya',’ ta iya?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","E'tane miyarɨ rɨ ta'pʉ iya, “Iyo'non winon pe ɨwesi kon, itepoino winon pe e'tane. Serɨ non pon kon pe ɨwesi kon, serɨ non pon pe pʉra e'tane. ");
INSERT INTO akeNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Auma'tato' oton kon amakooi kon yau ta'pʉ uya, kʉrɨ rɨ urɨ, ukayai'ne' apurɨ auya'nokon pʉra iyesi yau, auma'ta kon kuru rɨ amakooi kon yau,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","“Ɨnʉ' pe ken ɨwesi?” ta'pʉ to' uya ipɨ'. “Mɨsi'kɨrɨ rɨ sa'ne kʉrɨ rɨ ukayai'ne' rɨ,” tukai' Sises uya to' eikʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","“Eke pe rɨ tato' uya man ɨyeseru kon aimenka pe. E'tane uyenno'nin nʉ'pʉ kuru esi i'napairon pe; kʉrɨ rɨ winɨ uneta'pʉ nin ekama uya non pon kon pɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","To' uya ito'ka'nʉkʉ pʉra iyesi'pʉ tʉkʉipʉnʉ pɨ' tauro'ka tane iya 'nokon. ");
INSERT INTO akeNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mɨrɨpan pɨ' Sises uya ta'pʉ, “Ka'pon, Papa winon, anʉnsa' auya'nokon a'tai ka'takʉi', mɨrɨ a'tai ui'tuto' auya'nokon oton ɨnʉ' pe esi tukai', mɨrɨ awonsi'kɨ ɨ'rɨ rɨ kupʉ uya pʉra iyesi uiwano' pe, e'tane ikʉipʉnʉ uya rɨken uyenupa'pʉ pɨ' usaurokʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Uyenno'nin nʉ'pʉ rɨ pokon pe esi; tikin sarɨ unonkasa' iya pen, apʉne pʉra ipori'manin ku'nin pe esi ke,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Isauro'tane rɨ marɨ, tu'kan kon uya rɨ apurɨto' tʉuya'nokon tʉrʉ'pʉ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Esuwerʉ amʉ' tapurɨnin nan pɨ' ta'pʉ Sises uya, “Ɨyenupato' kon uya pɨ' auta'sisa' kon yau, upoitorʉ ton pe kuru rɨ ɨwesi kon mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mɨrɨ a'tai i'napairon i'tuto' auya'nokon oton, mɨrɨpan uya imo'kasa' pe ɨkupʉ kon mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","To' uya eikʉ'pʉ, “Ina kamoro Epʉra'an payan ton; ɨnʉ' rɨ enawon kon ye' pen nɨ. Nai kasa imo'kasa' pe ɨwe'to' oton kon ta auya?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Sises uya to' eikʉ'pʉ, “I'napairon ekama uya ɨpɨ'nokon; tanporon kon nʉmakoitayai'ne' nan esi makoi poitorʉ ton pe. ");
INSERT INTO akeNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ipoitorʉ pe te'sen esi mɨrɨ tʉtonpa ton koro'tawon pen nɨ, e'tane imu rɨken esi mɨrɨ, mɨrɨ yawon tɨwɨro' e' pe rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Imu uya ɨmo'kasa' kon pe iyesi yau, imo'kasa' pe kuru rɨ ɨwesi kon mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Epʉra'an payan pe ɨwesi kon tukai' si'tuyai', mɨrɨ rɨ e'tane uwɨnɨ pɨ' ɨye'kamasa' kon, apʉne pʉra umaimu pata pʉra rɨ ɨwesi kon wenai ayau'nokon. ");
INSERT INTO akeNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","I'napairon ekama uya ɨpɨ'nokon; unene'pʉ ikʉipʉnʉ piyau; ɨkʉipʉnʉ kon winɨ ɨneta'pʉ kon kupʉ auya'nokon nɨ nɨrɨ mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","“Epʉra'an kʉrɨ rɨ ina kʉipʉnʉ,” tukai' to' uya eikʉ'pʉ. “Epʉra'an munkɨ pe rɨ rʉ'san pe ɨwesi kon yau, inkupʉ'pʉ mʉku'tʉi'no. ");
INSERT INTO akeNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Na'ne' rɨ si, uwɨnɨ pɨ' ɨye'kupʉ kon, ka'pon sa'ne i'napairon ekamanin nɨ ɨpɨ'nokon tʉneta'pʉ Papa winon. Epʉra'an uya mʉku'atʉi'ne' waraino ku'sa' pʉra rɨ iyesi. ");
INSERT INTO akeNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ɨkʉipʉnʉ kon nʉkupʉnʉ rɨ nin kupʉ auya'nokon mɨrɨ,” ta'pʉ iya. “Pʉrau amʉ' ton pen nɨ ina, Papa rɨken kʉrɨ rɨ ina kʉipʉnʉ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Sises uya ta'pʉ to' pɨ', “Papa esi yau ɨkʉipʉnʉ kon pe, ui'nʉnkatʉi'no, Papa winɨpai uye'sa' pɨ' serɨ ya'. Uiwano' pe uye'sa' pen, e'tane uyenno'sa' iya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ɨ'rɨ pe iyesi pɨ' sa'man pe rɨ umaimu esi ɨpona'nokon? Umaimu ɨnetapai pʉra ɨwesi kon pɨ' iyesi. ");
INSERT INTO akeNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ɨkʉipʉnʉ kon, Makoi munkɨ pe ɨwesi kon, ɨkʉipʉnʉ kon maimu awɨrɨ e'pai ɨwesi kon. Te'wɨsen ye' kʉrɨ rɨ iyepiya'tɨ'pʉ si'kɨrɨ rɨ, tʉuta'sisen pen nɨ i'napairon pɨ', i'napairon ye' pe pʉra tesi pɨ'. Kasi pe iyesi a'tai, teseru pe rɨ te'sen kupʉ iya mɨrɨ, kasi ye' pe tesi pɨ' mɨrɨ awonsi'kɨ kasi ye' ton kʉipʉnʉ pe tesi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","I'napairon ekama tane uya, uyapurɨ auya'nokon pʉra iyesi. ");
INSERT INTO akeNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ɨnʉ' rɨ uya tʉmakooi ke ui'tu? I'napai rɨ usaurokʉ pe iyesi yau, ɨ'rɨ pe iyesi pɨ' uyapurɨpai pʉra ɨwesi kon? ");
INSERT INTO akeNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Papa iwano' uya rɨ, Papa maimu eta mɨrɨ. Eta auya'nokon pʉra iyesi, apʉne pʉra Papa iwano' pe pʉra ɨwesi kon pɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Esuwerʉ amʉ' uya eikʉ'pʉ, “Ina uya pe' ta pʉn Sameriya pon pe ɨwesi, ɨri a'kwarʉ yen pe?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","“Ɨri a'kwarʉ yen pen nɨ urɨ,” ta'pʉ Sises uya, “ukʉipʉnʉ nama uya, e'tane unama auya'nokon pʉra iyesi. ");
INSERT INTO akeNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Uyapurɨpɨ'to' warinpa uya pen, e'tane moro iyesi mɨrɨ iwarinpanin; kʉrɨ rɨ kʉrɨ rɨ eseru aimenkanin. ");
INSERT INTO akeNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","I'napairon ekama uya ɨpɨ'nokon; umaimu awɨron esi yau, iyeri'to' oton pen nɨ,” ta'pʉ Sises uya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Mɨrɨ pɨ' Esuwerʉ amʉ' uya, “Serɨ si ina uya i'tu ɨri a'kwarʉ yen pe ɨwesi tukai'! Epʉra'an erikʉ'pʉ, mɨrɨ awonsi'kɨ pu'kena' amʉ' rɨ nɨrɨ erikʉ'pʉ, mɨrɨ e'tane si ɨnʉ' rɨ esi yau umaimu awɨrɨ iyeri'to' oton pen nɨ ta auya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Eke pe kuru pe' ina kʉipʉnʉ Epʉra'an entai ɨwesi? Iyerikʉ'pʉ, mɨrɨ awonsi'kɨ pu'kena' amʉ' rɨ nɨrɨ erikʉ'pʉ. Ɨnʉ' pe kuru ɨye'kupʉ?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Sises uya to' eikʉ'pʉ, “Uiwano' pe utapurɨpɨtʉ yau, utapurɨ pe pʉra rɨ iyesi. Ukʉipʉnʉ, ina e'to' itese' pɨ' mʉkayatʉi'ne' uya nin uyapurɨpɨtʉ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","I'tu tane auya'nokon pʉra rɨ, i'tu uya nin. I'tunin pen urɨ ta uya yau, kasi pe esi, akasa'nokon, e'tane i'tu uya, imaimu awɨrɨ nɨrɨ esi. ");
INSERT INTO akeNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ɨkʉipʉnʉ kon, Epʉra'an esi'pʉ pori' pe uweyu ento' oton tʉuya pɨ'; mɨrɨpan uya ensa' epori'ma'pʉ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","“50 kaisa rɨ pʉra rɨ ɨwʉipiyaai man, mɨrɨ pe' e'tane Epʉra'an ene'pʉ auya?” ta'pʉ Esuwerʉ amʉ' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","“I'napairon ekama uya ɨpɨ'nokon; Epʉra'an entu rawɨrɨ rɨ, urɨ esi!” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Mɨrɨ pɨ', tɨ' amuku'pʉ to' uya ipona eno'mapɨ'to' pe tʉuya'nokon, e'tane Sises e'so'namʉ'pʉ, itɨ'pʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' nono apai. ");
INSERT INTO akeNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Sises usarɨ koro'tau, tentu'pʉ si'kɨrɨ tenku'ne te'sen ka'pon ene'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ipoitorʉ ton uya ekama'po'pʉ, “Rapai, ɨnʉ' uya makoi kupʉ'pʉ—pʉse rɨ ka'pon uya pe', isanon uya katɨ, tenku'ne iyentu temapu'tɨi'?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Sises uya to' maimu eikʉ'pʉ, “Pʉse rɨ ka'pon e'makoimasa' pʉra iyesi, isanon nɨrɨ, e'tane Papa tʉrawasooi usenpoikato' pe iyawɨrɨ iye'ku'sa' pe iyesi. ");
INSERT INTO akeNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Wʉi nai pata esi koro'tau, uyenno'nin nʉ'pʉ tʉrawasooi ku'pai'nokon. Ewarupɨ nʉye'an, ɨnʉ' rɨ e'tʉrawasoma weyu pen. ");
INSERT INTO akeNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Serɨ non po esi koro'tau, urɨ esi non weyu pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Serɨ kasa tʉusaurokʉ'pʉ tʉpo, non pona iyeta'ta'pʉ. Tawa koneka'pʉ iya eta' namanka'pʉ ke, mɨrɨpan tʉrʉ'pʉ iya ka'pon enu pona. ");
INSERT INTO akeNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ta'pʉ iya ipɨ', “Ekumi'ta, Sairon ku'pɨri ka',” ta'pʉ iya. (Sairon tawon main esi mɨrɨ Enno'sa' ta e'kwa pe.) Mɨrɨ a'tai, itɨ'pʉ, iyekumisi'pʉ, iyee'pʉ ennin pe tenai'. ");
INSERT INTO akeNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mɨrɨ a'tai, itonpa ton mɨrɨ awonsi'kɨ wapiya tenku'ne ennin nʉ'san uya ta'pʉ, “Pʉse rɨ pen pe' tereutai' eta'kwanʉn nɨ pɨ' nʉko'manpɨ'taine' pen?” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tʉron kon uya, “Pʉse rɨ kʉrɨ rɨ,” ta'pʉ. Tʉron kon uya, “Kʉrɨ rɨ kasa rɨ marɨ isene,” ta'pʉ. E'tane, “Urɨ rɨ kʉrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Mɨrɨ a'tai, “Ɨ'rɨ tukai' ɨyenu uta'kokasa'?” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","To' maimu eikʉ'pʉ iya, “Sises tukai' tesa'sen uya tawa koneka'pʉ. Mɨrɨ tʉpo, uyenu pona itʉrʉ'pʉ iya. Ta'pʉ iya upɨ', ‘Ekumi'ta Sairon ku'pɨri ka'.’ Utɨ'pʉ ekumi'se'na, mɨrɨ tʉpo ene'pʉ uya,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Mɨrɨ tʉpo ta'pʉ to' uya ipɨ', “Nai kʉrɨ ken si?” “I'tu uya pʉra iyesi,” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tenku'ne iko'mansa' rʉ'pʉ nepʉ'pʉ to' uya Pari'si amʉ' piya'. ");
INSERT INTO akeNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Sapa' a'tai Sises uya tawa koneka'pʉ, itenu nɨrɨ a'koka'pʉ iya esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mɨrɨ a'tai, Pari'si amʉ' uya kanan ekama'po'pʉ nai kasa ennin pe iyenasa' tukai'. Ta'pʉ iya to' pɨ', “Tawa nonka'pʉ iya uyenu pona, ikumisi'pʉ uya, ennin pe nin si esi serɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mɨrɨ a'tai, tʉron kon Pari'si amʉ' uya ta'pʉ, “Papa winon pe pʉra pʉse rɨ ka'pon esi, apʉne pʉra Sapa' apurɨ iya pʉra iyesi,” ta'pʉ to' uya. “Ɨ'rɨ tukai' i'tuto' ipɨkɨrɨ kupʉ tʉmakooikenan nɨ ka'pon uya?” ta'pʉ tʉron kon ka'pon amʉ' uya, mɨrɨpan kon epantakapɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tenku'nan pɨ' kanan tera'tɨi', “Ɨ'rɨ ta auya kʉrɨ ɨyenu a'kokanin nʉ'pʉ pɨ'?” ta'pʉ to' uya. “Pu'kena' pe iyesi!” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","E'tane Pari'si amʉ' uya apurɨ'pʉ pen tenku'ne iyesi'pʉ tukai', mɨrɨpan enasa' ennin pe tukai', tenku'nan sanon kɨ'ma tʉuya'nokon pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","To' uya to' ekama'po'pʉ, “Pʉse rɨ pe' esi ɨmʉre kon pe? Tenku'ne iyentusa' rʉ'pʉ tato' auya'nokon ipɨ'? Nai kasa ken si ennin pe iyenasa'?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Isanon uya to' maimu eikʉ'pʉ, “Ina uya i'tu pʉse rɨ esi ina mʉre pe, iyentusa' rʉ'pʉ tenku'ne. ");
INSERT INTO akeNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","E'tane ɨ'rɨ tukai' ennin pe iyenasa' tukai' ina uya i'tu pʉra iyesi. Ɨnʉ' uya itenu a'kokasa' tukai' nɨrɨ ina uya i'tu pʉra iyesi. Ekama'potɨ'. Eke pe iyesi; tiwano' pe tʉusauro'sen pe iyesi,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Serɨ ta'pʉ isanon uya, apʉne pʉra enari'ke' to' esi'pʉ Esuwerʉ amʉ' pɨ', apʉne pʉra Esuwerʉ amʉ' e'ku'sa' esi'pʉ ɨnʉ' uya rɨ Kʉrai pe Sises esi tukai' ekamasa' a'tai, ipa'kato' pe iyesi usenupan nɨto' iwʉ' tapai tukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Mɨrɨ wenai, “Eke pe iyesi; tiwano' pe tʉusauro'sen pe,” ta'pʉ isanon uya. ");
INSERT INTO akeNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Iyakon ite'kwa pe tenku'nan nʉ'pʉ ka'pon kɨ'makaa'pʉ to' uya kanan. Ta'pʉ to' uya ipɨ', “Papa apurɨpɨ'kɨ; pʉse rɨ nin i'tu pɨ' ina man tʉmakooikenan pe,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","To' maimu eikʉ'pʉ iya tai'ma, “Tʉmakooi ke iyesi, mɨrɨ pe pʉra imakooi pʉra iyesi, i'tu uya pʉra iyesi, e'tane tikin nan nɨ i'tu uya; tenku'ne esi'pʉ, e'tane serɨ pe ene uya!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Mɨrɨ tʉpo kanan to' uya ekama'po'pʉ, “Ɨ'rɨ kupʉ'pʉ iya ɨpɨ'? Ɨ'rɨ tukai' ɨyenu a'koka'pʉ iya?” ");
INSERT INTO akeNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","To' maimu eikʉ'pʉ iya, “Ayauro'kakaa'pʉ uya 'nokon, etasa' auya'nokon pʉra iyesi. Ɨ'rɨ pe iyesi pɨ' ɨnetapai kanan ɨwesi kon? Ipoitorʉ ton pe nɨrɨ pe' e'pai ɨwesi kon?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Mɨrɨ tʉpo to' uya ipa'nʉkʉ'pʉ, “Ɨmɨrɨ esi mɨrɨ ipoitorʉ pe! Ina nin Mosi' poitorʉ ton,” tai'ma. ");
INSERT INTO akeNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","“Papa uya Mosi' auro'ka'pʉ tukai' ina uya i'tu, e'tane nai winɨ kʉrɨ rɨ uye'sa' tukai' ina uya i'tu pʉra iyesi,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ka'pon uya to' maimu eikʉ'pʉ, “Ɨ'rɨ pan si ti'tupɨ'sen pen nɨ! Nai winɨ iye'sa' tukai' i'tu auya'nokon pʉra iyesi, e'tane uyenu ton a'koka'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Papa uya tʉmakooikena' nan eta pʉra iyesi, tukai' i'tu'nokon, e'tane Papa uya tasa' kasa te'sen, iteseru nɨrɨ kupʉi'ma eta iya. ");
INSERT INTO akeNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Non e'sara'tɨ'pʉ si'kɨrɨ, isetasa' pʉra iyesi ɨnʉ' uya rɨ tenku'ne iyentusa' rʉ'pʉ enu a'kokasa' tawon. ");
INSERT INTO akeNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Papa winon pe pʉra pʉse rɨ ka'pon uye'sa' a'tai, ɨ'rɨ kupʉ iya pen,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","To' uya imaimu eikʉ'pʉ tai'ma ipɨ', “Makoi yau ɨyentu'pʉ! Nai kasa rʉ'kwɨ ina enupa i'se ɨwesi!” ta'pʉ to' uya. Mɨrɨ tʉpo, to' uya enpa'ka'pʉ usenupan nɨto' iwʉ' tapai. ");
INSERT INTO akeNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Sises uya to' uya enpa'ka'pʉ eta'pʉ. Eposa' tʉuya a'tai, ta'pʉ iya ipɨ', “Ka'pon, Papa winon pe' mapurɨyan?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Imaimu eikʉ'pʉ iya, “Itepuru, ɨnʉ' pe iyesi?” tukai', ekama'po'pʉ iya. “Ekamakɨ, apurɨnin pe e'to' pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Sises uya, “Ensa' auya mɨrɨ; kʉrɨ rɨ ipokon pe masauro'ai'ne',” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ta'pʉ iya, “Uyepuru, ayapurɨ uya,” tai'ma iyepʉrema'pʉ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Sises uya ta'pʉ, “Eseru aimenkato' wenai serɨ non pona uye'sa' kamoro tenku'ne te'san uya ento' pe, mɨrɨ awonsi'kɨ kamoro ennin nan enato' pe tenku'ne,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Pari'si amʉ' iya'kɨrɨ te'san kon uya serɨ ta iya eta'pʉ. Ta'pʉ to' uya ipɨ', “Ɨ'rɨ? Tenku'ne nɨrɨ ina esi?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Sises uya ta'pʉ to' pɨ', “Tenku'ne ɨwesi kon yau, imakooi pʉra ɨwesi kon, e'tane ennin pe ɨye'kupʉ kon pɨ', amakooi kon yau rɨ ɨwesi kon. ");
INSERT INTO akeNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“I'napai rɨ ta uya ɨpɨ'nokon; kʉrɨ rɨ mʉra'ta awɨrɨ pʉra tewonsen karimeru amʉ' iwʉ' ta' e'tane tʉron nɨ winɨ tewonsen esi mɨrɨ ama' e', rapumanin nɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","E'tane kʉrɨ rɨ mʉra'ta awɨrɨ tewonsen esi mɨrɨ karimeru amʉ' esa' pe. ");
INSERT INTO akeNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Itena' mʉra'ta tʉrawasomanin uya mʉra'ta a'koka, karimeru amʉ' uya imaimu eta. To' ese' ton yai karimeru amʉ' kɨ'ma iya, mɨrɨpan kon pa'ka iya. ");
INSERT INTO akeNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tikʉn non karimeru amʉ' pa'kasa' iya a'tai, to' wapiya itɨ, karimeru amʉ' uya nɨrɨ e'ma'pʉka, imaimu i'tu to' uya wenai. ");
INSERT INTO akeNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ka'kʉran e'ma'pʉka to' uya pʉra iyesi, e'tane to' apʉrʉmʉ ipiyapai, apʉne pʉra ka'kʉran maimu i'tu to' uya pʉra iyesi.” ");
INSERT INTO akeNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Sises uya serɨ panton ekama'pʉ, e'tane to' uya ito'ka'nʉkʉ pʉra iyesi'pʉ ɨ'rɨ ton pɨ' isaurokʉ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Mɨrɨ tʉpo, Sises uya kanan ta'pʉ to' pɨ', “I'napairon ekama uya ɨpɨ'nokon; urɨ esi karimeru amʉ' mʉra'taai pe. ");
INSERT INTO akeNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tanporo kamoro wapiya iye'sa' kon esi ama' e' ton, rapumanin nan pe nɨrɨ, e'tane karimeru amʉ' uya to' maimu eta pʉra iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Urɨ esi mʉra'ta pe, urɨ poro ɨnʉ' rɨ ewomʉ a'tai, iyepika'tɨ. Iyewomʉ, mɨrɨ awonsi'kɨ iyepa'ka nɨrɨ ti'kiyari pata'se' epose'na. ");
INSERT INTO akeNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ama' e' uyepʉ ama'mase'na rɨken, mɨrɨ awonsi'kɨ iwɨse'na, mɨrɨ awonsi'kɨ ima'tanʉ'se'na. Urɨ uye'sa' uko'man nɨto' epoto' pe to' uya, eke pe kuru nɨrɨ to' uya epoto' pe. ");
INSERT INTO akeNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Urɨ esi wakʉ karimeru amʉ' pa'simanin. Wakʉ karimeru pa'simanin pe te'sen uya tʉuko'manto' nonka karimeru amʉ' iwano' pe. ");
INSERT INTO akeNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","E'tane kʉrɨ rɨ te'masen pe iye'to' pe ekama'posa', karimeru amʉ' esa' pen, karimeru amʉ' esi itikʉn non pe pʉra. Ene kaikusi uyepʉ ene iya a'tai, karimeru amʉ' nɨmɨ iya. Iyainʉmʉ, ene kaikusi uya to' a'si, karimeru amʉ' nɨrɨ e'tʉrʉ'kwa. ");
INSERT INTO akeNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ka'pon ainʉmʉ, apʉne pʉra te'masen pe iye'to' pe ekama'posa' pe tesi ke, aiko tawon pe pʉra iyesi karimeru amʉ' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Urɨ esi wakʉ karimeru amʉ' pa'simanin. Uikʉn non karimeru amʉ' i'tu uya; to' uya nɨrɨ ui'tu— ");
INSERT INTO akeNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ukʉipʉnʉ uya ui'tu na'ne' kasa, mɨrɨ kasa ukʉipʉnʉ i'tu uya—mɨrɨ awonsi'kɨ uko'manto' nonka uya karimeru amʉ' iwano' pe. ");
INSERT INTO akeNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Moro tʉron kon karimeru amʉ' esi mɨrɨ, serɨ yau pʉra rɨ marɨ. Kamoro nɨrɨ nepʉ uya. To' uya nɨrɨ umaimu eta, mɨrɨ awonsi'kɨ tikin nɨ iten to' esi, tikin nɨ nɨrɨ to' pa'simanin esi. ");
INSERT INTO akeNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ukʉipʉnʉ uya ui'nʉnka, apʉne pʉra uko'manto' nonkasa' uya pɨ', anʉnka'to' pe uya kanan. ");
INSERT INTO akeNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ɨnʉ' rɨ uya imo'ka pʉra iyesi upiyapai, e'tane urɨ pe rɨ inonkasa' uya. Inonkato' meruntɨ esi upiyau, anʉnka'to' uya rɨ kanan. Serɨ uyapiyo'mato' eposa' uya ukʉipʉnʉ winɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Serɨ ton main pɨkɨrɨ, Esuwerʉ amʉ' kanan epantakapɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tu'kan kon uya, “Makoi esi ipiyau, iya'kwarʉ pʉra iyesi. Ɨ'rɨ pe iyesi pɨ' imaimu eta auya'nokon?” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Tʉron kon uya ta'pʉ, “Makoi esa' maimu ton pen nɨ serɨ. Makoi uya pe' tenku'nan enu a'koka poken nai?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' uta'koka'pʉ Weyu Rʉ'pʉ e'seporo'pʉ Surusiran po. Ikomi' pe pata esi weyu pe iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Sises usarɨ koro'tau Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' pʉ'kʉ tau, Saraman Epa'kato' Iya' tawɨrɨ, ");
INSERT INTO akeNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","mɨrɨ a'tai, Esuwerʉ amʉ' uyee'pʉ iwoi. Ta'pʉ to' uya ipɨ', “Ɨ'rɨ pʉ'kʉ pona ina ko'manʉkʉ auya usenuminkan pɨ'? Kʉrai pe ɨwesi a'tai, wakʉ pe ina pɨ' ɨsekamakɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Sises uya to' maimu eikʉ'pʉ, “Ayauro'kakaa'pʉ uya 'nokon, e'tane apurɨ auya'nokon pʉra iyesi. Serɨ eke tʉrawaso siku'ai'ne' ukʉipʉnʉ ese' yau usaurokʉ uiwano' pe. ");
INSERT INTO akeNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","E'tane apurɨ auya'nokon pʉra iyesi, apʉne pʉra uikʉn non karimeru amʉ' tonpa pe pʉra ɨwesi kon. ");
INSERT INTO akeNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Uikʉn non karimeru amʉ' uya umaimu eta; to' i'tu uya, to' uya nɨrɨ uye'ma'pʉka. ");
INSERT INTO akeNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Tɨwɨrɨ rɨ uko'man nɨto' ike ke to' repa uya, to' uma'tato' oton pen nɨ; ɨnʉ' uya to' mo'kato' oton pen uyemiyatʉ apai. ");
INSERT INTO akeNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ukʉipʉnʉ urepanin nʉ'pʉ kamoro ke esi eke pe tanporon kon entai rɨ. Ɨnʉ' uya rɨ to' mo'ka pʉra iyesi ukʉipʉnʉ piyapai. ");
INSERT INTO akeNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ikʉipʉnʉ ya' tikin nɨ ina esi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Mɨrɨ tʉpo, Esuwerʉ amʉ' uya tɨ' ton amuku'pʉ iwɨto' pe tʉuya'nokon, ");
INSERT INTO akeNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","e'tane Sises uya ta'pʉ to' pɨ', “Ikʉipʉnʉ winon tu'kan nɨ eke tʉrawaso enpoika'pʉ uya ɨyena'nokon. Nai wenai kuru tɨ' ke uwɨnɨ i'se ɨwesi kon?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Esuwerʉ amʉ' uya imaimu eikʉ'pʉ, “Serɨ ton wenai tɨ' ke ɨwɨnɨ i'se ina esi pen, e'tane isapema auya wenai. Ka'pon pe rɨ esii'ma Papa pe ɨye'kupʉ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Sises uya to' maimu eikʉ'pʉ, “Iye'menukasa' pʉra pe' nai Main yau, ‘Ta uya ɨpɨ'nokon papa pe'ne ɨwesi kon,’ tawon? ");
INSERT INTO akeNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Papa pe'ne to' esa'sa' iya yau, Papa maimu uyee'pʉ na'ne' ipiya' ton, Papa Maimu i'kwɨtʉ poken pʉra nɨrɨ iyesi. ");
INSERT INTO akeNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ɨ'rɨ pe ken si kʉrɨ nai, ikʉipʉnʉ nanʉmʉ'pʉ tiwano' pe kuru, mɨrɨpan enno'sa' iya orʉ pona? Ɨ'rɨto' pe ken ɨri pe isapema pe tʉusauro'sen ta auya'nokon, ‘Papa Mumu urɨ,’ ta uya pɨ'? ");
INSERT INTO akeNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Urɨ kʉsapurɨtʉu, ukʉipʉnʉ tʉrawasooi ku'tane uya pʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","E'tane ikupʉ uya a'tai, uyapurɨ auya'nokon pʉra iye'tane, eke tʉrawaso amʉ' kupʉ uya apurɨtɨ', i'tu kon pa apurɨ kon pa nɨrɨ ukʉipʉnʉ esi uyau, urɨ nɨrɨ esi iyau tukai'.” ");
INSERT INTO akeNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mɨrɨ wenai kanan a'si i'se to' esi'pʉ, e'tane to' enapai iyemo'ka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Itɨ'pʉ Isotan ratoi pona, Isaan uya epa'taisiman kupʉ'pʉ pena iwa'ne pata piya'. Mɨrɨ yau, iko'mamʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Tu'kan kon ka'pon amʉ' uyee'pʉ ipiya'. Ta'pʉ to' uya, “Isaan uya i'tuto' ipɨkɨrɨ kupʉ'pʉ pen, e'tane tanporon Isaan usaurokʉ'pʉ pʉse pɨ' esi i'napai rɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tu'kan kon uya Sises maimu apurɨ'pʉ mɨrɨ yau. ");
INSERT INTO akeNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Moro takuru'kenan ka'pon esi'pʉ Ʉrasaras itese', Pe'tani eke iwa pata pon, Meri mɨrɨ awonsi'kɨ Mata pata'se'. ");
INSERT INTO akeNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Pʉse rɨ Meri, ipi na'ne' esi'pʉ takuru'ke, kʉrɨ rɨ esi'pʉ Sises karapaimanin nʉ'pʉ, i'ta nɨrɨ a'munakanin nʉ'pʉ tʉnse' ke. ");
INSERT INTO akeNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mɨrɨ a'tai, ipasi ton uya ikɨ'mai' tʉmaimu kon ennoko'pʉ, “Itepuru, ipan pe ɨni'nʉnkanʉ man takuru'ke,” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Sises uya mɨrɨ etasa' a'tai, ta'pʉ iya, “Serɨ paran uya eri'nʉ'ka pen nɨ, e'tane Papa meruntɨrʉ usenpoikato' pe, Papa Mumu apurɨto' pe ipɨkɨrɨ iyesi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Sises uya Mata, itakon, mɨrɨ awonsi'kɨ Ʉrasaras i'nʉnka esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Takuru'ke iyesi tukai' etasa' tʉuya a'tai, asa'rɨ wʉi iko'mamʉ'pʉ tesi'pʉ yau rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mɨrɨ tʉpo, tʉpoitorʉ ton pɨ', “Isutiya pona kanan utɨnpai'nokon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ipoitorʉ ton uya ta'pʉ ipɨ', “Rapai, pena kuru pʉra rɨ Esuwerʉ amʉ' esi'pʉ ɨwɨnɨ i'se tɨ' ke. Mɨrɨ pe' e'tane mɨrɨ ya' ɨutɨkapʉ kanan?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Sises uya to' maimu eikʉ'pʉ, “12 kaisa rɨ wʉi yau pata weyu pʉra pe' nai? Ɨnʉ' usarɨ a'tai wʉi nai ita'mo'ka pen, apʉne pʉra a'kwa pe non esi wenai. ");
INSERT INTO akeNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","E'tane ewarupɨ yau ka'pon usarɨ a'tai, ita'mo'ka, apʉne pʉra a'kwa pe pʉra iyesi ke,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Serɨ ton ta tʉpo, ta'pʉ iya to' pɨ', “Utonpa kon Ʉrasaras e'nʉmʉ, e'tane utɨ enpakase'na iye'nʉnto' apai,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Mɨrɨ tʉpo ipoitorʉ ton uya ta'pʉ, “Itepuru, iye'nʉnsa' pe iyesi yau, ito'pamʉ rɨ mɨrɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Sises usaurokʉ esi'pʉ iyeri'sa' pɨ', e'tane iye'nʉmʉ pɨ' isaurokʉ pe to' uya ekama'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Mɨrɨ a'tai nin si to' pana'tɨkaa'pʉ iya mɨrɨ wakʉ pe, “Ʉrasaras eri'sa' kuru rɨ mɨrɨ, tukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Pori' pe e'ai', ɨmɨrɨ'nokon pɨ', mɨrɨ yau e'sa' pʉra iyesi pɨ', apurɨ kon pa. E'tane pʉra utɨnpai'nokon ipiya',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mɨrɨ tʉpo, Tamas (Titimas tukai' tesa'sen) uya ta'pʉ tʉtonpa ton, ipoitorʉ ton pɨ', “Utɨnpai'nokon nɨ nɨrɨ uma'tan nɨto' pe ipokon pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Sises uye'sa' a'tai, asakɨrɨ'ne wʉi uruwai' yau iko'manka'sa' eporo'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Pe'tani esi'pʉ ɨnnɨ pʉra Surusiran piyapai, 2 mayirʉ e'to' airɨ rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Mɨrɨ a'tai, tu'kan kon Esuwerʉ amʉ' uyee'pʉ Meri mɨrɨ awonsi'kɨ Mata pokon a'kwarʉ ne'pɨ'se'na to' pi pata'pʉ yau. ");
INSERT INTO akeNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mata uya Sises uyepʉ eta pe rɨ, itɨ'pʉ ite'matai, e'tane Meri esi'pʉ ɨutɨ tau moro rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mɨrɨ a'tai, Mata uya ta'pʉ Sises pɨ', “Itepuru, serɨ yau ɨwesi yau, upi nʉma'tai'no pen. ");
INSERT INTO akeNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","E'tane i'tu uya ɨ'rɨ rɨ ekama'po auya a'tai Papa pɨ', Papa uya ɨrepa,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Sises uya ta'pʉ ipɨ', “Ɨpi kanan e'mʉ'sa'kato' oton,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mata uya imaimu eikʉ'pʉ, “Si'tuyai' iye'mʉ'sa'kato' oton kanan e'mʉ'sa'kan weyu a'tai, pata weyu u'ma'sa' a'tai,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Sises uya ta'pʉ ipɨ', “Urɨ esi i'mʉ'sa'kanin pe, uko'man nɨto' ku'nin pe rɨ nɨrɨ esi. Urɨ yau apurɨnin esi a'tai, iyeri'sa' pe rɨ iye'tane, iko'manto' oton nɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ɨnʉ' rɨ tʉuko'mansen uyapurɨ pɨ' uma'tato' oton pen. Serɨ pe' mapurɨyan?” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Ewai', uyepuru, sapurɨyai' Kʉrai pe ɨwesi, Papa Mumu pe tʉuye'ton serɨ non pona, tasa' rʉ'pʉ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Serɨ ta tʉuya tʉpo, itɨ'pʉ ama'ai takon kɨ'mase'na. “Ti'sa uye'sa' man, ɨkɨ'ma iya,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mɨrɨ eta tʉuya pe rɨ, iye'mʉ'sa'ka'pʉ, iyee'pʉ inke pʉra ipiya'. ");
INSERT INTO akeNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Sises uye'sa' pʉra rɨ marɨ iyesi'pʉ eke iwa pata pona, e'tane Mata uya teporo'pʉ yau rɨ marɨ iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Esuwerʉ amʉ' Meri piyau iye'sa' kon ɨutɨ tau iya'kwarʉ nepʉ pɨ' uya iye'mʉ'sa'ka ensa' inke pʉra, mɨrɨpan epa'ka a'tai, to' uya e'ma'pʉka'pʉ, tʉuta'kwarʉkai' akaranse tɨ' akasa' uruwai' pe ya' itɨ pe tekamai'. ");
INSERT INTO akeNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Meri uya Sises pata eposa' a'tai, ensa' tʉuya a'tai, i'ta piyau ita'mo'ka'pʉ, “Itepuru, serɨ yau ɨwe'sa' yau, upi nʉma'tai'no pen nɨ,” tai'ma. ");
INSERT INTO akeNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ikaramʉ ensa' tʉuya a'tai, mɨrɨ awonsi'kɨ Esuwerʉ amʉ' nɨrɨ iya'kɨrɨ iye'sa' kon ukaramʉ, ipan pe ipokoita'pʉ tewan temo'kai'. ");
INSERT INTO akeNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Nai yau inonkasa' auya'nokon?” ta'pʉ iya to' pɨ'. “Itepuru, entanʉ'kɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Sises ukaramʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Esuwerʉ amʉ' uya, “Ipan pe i'nʉnka iya!” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","E'tane tʉron kon uya, “Tenku'nan enu a'kokanin nʉ'pʉ uya rɨ pe' pʉse rɨ ka'pon erikʉ namai' ikupʉ pʉra iyesi'pʉ?” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Pokoi pe kuru rɨ marɨ esii'ma, Sises utɨ'pʉ uruwai' piya'. Tɨ' euta pe iyesi'pʉ eke tɨ' tʉsa' imʉra'taai po. ");
INSERT INTO akeNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","“Tɨ' amatɨ',” ta'pʉ iya. E'tane Mata, eke' pasi uya, “Uyepuru, ikɨ pe ikɨtaka'sa' serɨ, asakɨrɨ'ne wʉi iko'manka'sa' mɨrɨ yau,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Mɨrɨ a'tai, Sises uya, “Apurɨ auya yau, Papa meruntɨrʉ ene auya tukai' pe' apana'tɨ uya pʉn?” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mɨrɨpan kon uya tɨ' ama'pʉ. Mɨrɨ a'tai, kakʉi' tenu tʉtʉse Sises uya ta'pʉ, “Papai, tenki ukayai' umaimu etasa' auya pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","I'tu uya umaimu etanin pe rɨ ɨwesi tɨwɨrɨ rɨ, e'tane ta uya rɨ nin pʉsamoro iye'soto'pɨ'sa' kon na'ne' uya rɨ nin apurɨto' pe uyenno'sa' auya tukai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Serɨ ta tʉpo, eke pe ikɨ'pɨ'nʉmʉ'pʉ, “Ʉrasaras, epa'ka'!” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Iyeri'sa' rʉ'pʉ epa'ka'pʉ, auronpɨ'sa' pe itemiyatʉ ton i'ta ton, pon saai'pɨ'sa' kusan ton pe epe'kena' pon renen tato' atʉ ke, mɨrɨ awonsi'kɨ pon atʉ itemʉ' woi. Sises uya, “Iponkatɨ' uruwai' pon apai, tɨwɨ itɨto' pe,” ta'pʉ to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mɨrɨ pɨ' si tu'kan kon ka'pon amʉ' Meri piya' iye'sa' kon, Sises nʉkupʉnʉ ennin nʉ'san uya apurɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","E'tane tʉron kon utɨ'pʉ Pari'si amʉ' piya' Sises nʉkupʉ'pʉ ekamai' to' pana ya'. ");
INSERT INTO akeNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mɨrɨ a'tai, use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru mɨrɨ awonsi'kɨ Pari'si amʉ' uya tʉkonsʉrʉʉi kon mitimu kupʉ'pʉ. “Ɨ'rɨ kupʉ'nokon nai?” ta'pʉ to' uya. “Pʉse rɨ ka'pon uya tu'ke rɨ eke Papa tʉrawasooi i'tuto' ipɨkɨrɨ kupʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Serɨ ku'tane iya enpɨ'sa' yau, tanporon kon uya rɨ apurɨ, mɨrɨ awonsi'kɨ Roman amʉ' uya use'man nɨto', ɨpʉreman nɨto' iwʉ' mɨrɨ awonsi'kɨ upata kon mo'ka mɨrɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mɨrɨ a'tai, to' tonpa, Kaya'pas itese', use'man nɨto' tʉrawasomanin nan epuru pe te'sen mɨrɨ wʉipiya yau, usaurokʉ'pʉ, “Ɨni'tunʉ kon pʉra rɨ iyesi mɨrɨ! ");
INSERT INTO akeNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ito'ka'nʉkʉ auya'nokon pʉra iyesi wakʉ iwa pe iyesi ɨpona'nokon tikin nɨ ka'pon eri'to' pe ka'pon amʉ' iwano' pe, tanporon kon ka'pon amʉ' ekota'ma entai,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tʉmɨrɨ pe serɨ ta'pʉ iya pen nɨ, e'tane use'man nɨto' tʉrawasomanin nan epuru pe rɨ nin tesi pɨ' mɨrɨ wʉipiya yau, Sises eri'to' oton nɨ nin ekama'pʉ iya ka'pon amʉ' iwano' pe. ");
INSERT INTO akeNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kamoro iwano' pe rɨken pen e'tane iye'ta'nʉ'sa' kon Papa munkɨ amʉ' iwano' pe rɨ nɨrɨ, to' amʉranʉ'nin pe tikin nɨ to' tʉkonekai'. ");
INSERT INTO akeNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Mɨrɨ pɨ' nin si, iwɨnɨ pɨ' to' e'kama'pʉ mɨrɨ, mɨrɨ wʉi awonsi'kɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Mɨrɨ wenai, Sises si usarɨ pʉra iyesi'pʉ mɨrɨ Esuwerʉ amʉ' annawɨrɨ. E'tane ru'ku iyemo'ka'pʉ rɨmono'ta nono winɨkʉi', eke iwa pata E'pʉren tato' ya', mɨrɨ yau iyesi'pʉ tʉpoitorʉ ton pokon pe. ");
INSERT INTO akeNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Esuwerʉ Amʉ' Epoi Itɨ'pʉ Weyu Rʉ'pʉ e'sepokapʉ rɨ a'tai, tu'kan kon nɨ utɨ'pʉ mɨrɨ pata yapai Surusiran pona, ekorʉkase'na mɨrɨ Weyu wapiya. ");
INSERT INTO akeNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Sises ene i'se to' esi'pʉ, use'man nɨto', ɨpʉreman nɨto' iwʉ' airɨ te'soto'pɨ'se' to' usekama'popɨtʉ'pʉ, “Ɨ'rɨ tukai' mi'tuyatʉu? Iyepʉ pen nɨ pe' serɨ Weyu Rʉ'pʉ pɨ'?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Use'man nɨto' tʉrawasomanin nan epuru ton mɨrɨ awonsi'kɨ Pari'si amʉ' uya tasa' esi'pʉ, ɨnʉ' uya rɨ Sises esi mɨrɨ yau tukai' i'tusa' yau, ekamato' pe iya, a'sito' pe tʉuya'nokon. ");
INSERT INTO akeNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","6 kaisa rɨ wʉi To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ rawɨrɨ, Sises utɨ'pʉ Pe'tani pona, Ʉrasaras, Sises nʉ'mʉ'sa'ka'pʉ iyerikʉ'pʉ apai pata'se' ya'. ");
INSERT INTO akeNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Iyenta'nato' koneka'pʉ to' uya mɨrɨ yau, Mata esi'pʉ ekamʉ pɨ', Ʉrasaras e'tane Sises piyawon kon tʉteire' kon po tepʉrʉ piyau te'san koro'tau. ");
INSERT INTO akeNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mɨrɨ a'tai, Meri uya ten yau rɨ esukenan natʉ, epe'kena' po'piyun nee'pʉ, mɨrɨpan ma'pʉ iya Sises pʉta pona, ikuka'pʉ iya tʉnse' ke, mɨrɨpan po'piyun kɨtun uya a'po'ne ɨutɨ kɨ'nʉnpasa' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","E'tane Sises poitorʉ ton tonpa, Isutas Eskariya', eparanka ton si pona ipoken pʉra iyesi'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","mɨrɨpan uya, “Ɨ'rɨ pe iyesi pɨ' serɨ po'piyun kʉrʉpo'pomasa' pʉra rɨ iyesi, itepe'pʉ ke entu'manin nan repato' pe? Tikin nɨ wʉipiya yau e'tʉrawasoman nɨsa' epe'pʉ e'to' airɨ rɨ iyesi mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Aiko tawon pe tesi pɨ' entu'manin nan pɨ' serɨ ta'pʉ iya pen nɨ, e'tane ama' e' pe tesi pɨ'. Pʉrata paikii esa' pe tesi koro'tau, iyawon enno'nin pe iye'pɨtʉ'pʉ i'se te'to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","“Tɨwɨ nesii,” ta'pʉ Sises uya. “Inenkurunpa'pʉ mɨrɨ po'piyun uwu'na'tɨ weyu iwano' pe, tasa' iya rʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Inke rɨ ɨ'koro'tau'nokon te'san kamoro entu'manin nan, e'tane inke ɨpiyau'nokon esi pen nin,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mɨrɨ koro'tau anpisin ton kuru rɨ Esuwerʉ amʉ' uya etasa' esi'pʉ mɨrɨ yau Sises esi tukai', mɨrɨpan kon uyee'pʉ, kʉrɨ rɨ pɨkɨrɨ rɨken pen e'tane Ʉrasaras rɨ nɨrɨ ense'na, ini'mʉ'sa'ka'pʉ iyerikʉ'pʉ yapai. ");
INSERT INTO akeNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Mɨrɨ pɨ' nin si use'man nɨto' tʉrawasomanin nan epuru ton e'kama'pʉ Ʉrasaras rɨ nɨrɨ wɨnɨ pɨ', ");
INSERT INTO akeNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kʉrɨ rɨ uriya' tu'kan kon nɨ Esuwerʉ amʉ' uya tʉnonka kon pɨ' Sises piya' tʉutɨto' kon pe mɨrɨ awonsi'kɨ to' uya rɨ apurɨ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mɨrɨ ema'sa' yau, anpisin ton kuru rɨ iye'sa' kon nʉ'san Iweyu Rʉ'pʉ pɨ' uya Surusiran pona Sises utɨ etasa' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mɨrɨpan kon utɨ'pʉ ite'matai patawa ye' apɨmu ton itenau'ne, ɨkɨ'pɨ'nʉnpɨtʉi'ma, “Usana!” “Pori' pe kʉrɨ esi mɨrɨ Itepuru ese' yau nʉye'ai'ne'!” “Pori' kʉrɨ rɨ kin Esuwerʉ amʉ' epuru!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Sises uya isa'ka'si mʉre eporo'pʉ, mɨrɨpan ereuta'pʉ ipo, iye'menukasa' itekare uya ta awɨrɨ rɨ, ");
INSERT INTO akeNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kenari'nʉmʉi, Sayan ensi rʉ'kwɨ; enkɨ, ɨyepuru, kin uye'nɨ pɨ' man, iyereutasa' isa'ka'si mʉre po,” tawon. ");
INSERT INTO akeNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Mɨrɨ a'tai, ipoitorʉ ton uya tanporo serɨ ton to'ka'nʉkʉ'pʉ pen. Sises rɨ nin enasa' tapurɨpɨ'to' ya' tʉpo—iyeri'sa' rʉ'pʉ, e'mʉ'sa'kasa' tʉpo rɨ nin—to' uya i'tu'pʉ serɨ ton e'menukasa' esi'pʉ ipɨ', serɨ ton nɨ kenʉ' si ku'sa' to' uya esi'pʉ itiwano' pe. ");
INSERT INTO akeNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Anpisin ton si iya'kɨrɨ iye'sa' kon nʉ'san nɨ esi'pʉ ekama pɨ' Ʉrasaras kɨ'ma'pʉ iya uruwai' apai, iyeri'sa' apai i'mʉ'sa'ka'pʉ iya rɨ ekama pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tu'kan kon nɨ utɨ'pʉ serɨ eke Papa tʉrawasooi i'tuto' ipɨkɨrɨ e'ku'sa' tetai' ite'matai. ");
INSERT INTO akeNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mɨrɨ pɨ' si Pari'si amʉ' uya ta'pʉ mɨrɨ tʉtonpa kon pɨ', “Menyatʉu, ɨ'rɨ kupʉ poken pʉra rɨ iyesi. Entɨ', tanporo pata yawon kon utɨ ipɨkɨrɨ!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Moro Kiri' amʉ' tonpa ton esi'pʉ to' koro'tau ɨpʉremai' itɨsa' kon nʉ'san Iweyu Rʉ'pʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","To' uyee'pʉ Piri', Pe'saita, Kiyarari airon winon piya', i'se te'to' kon ekama'poi' ipɨ', “Itepuru, Sises ɨnenpai ina man,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Piri' utɨ'pʉ Anturu pana'tɨi'; Anturu mɨrɨ awonsi'kɨ Piri' uya nin si Sises pana'tɨ'pʉ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Sises uya to' eikʉ'pʉ, “Iweyu si e'seposa' man Ka'pon, Papa winon apurɨpɨ'to' weyu. ");
INSERT INTO akeNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","I'napairon ekama uya ɨpɨ'nokon, a'nai' ena'pɨ uta'mo'kasa' non pona eri'sa' pʉra iyesi yau, tikin nɨ rɨ iko'mamʉ mɨrɨ, e'tane iyeri'sa' yau, tu'ke rɨ nin itena'pɨ epamʉ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ka'pon tʉuko'manto' i'nʉnkanin uya inonka mɨrɨ, kʉrɨ tʉuko'manto' ewaruma'tɨnin serɨ non po uya rɨ nin iko'manʉkʉ mɨrɨ tɨwɨrɨ uko'man nɨto' iwano' pe. ");
INSERT INTO akeNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ɨnʉ' rɨ uyapiyo' pe na'ne' uya uye'ma'pʉkato' pe iyesi; e'ai'ne' yau rɨ upoitorʉ rɨ kanan e'to' pe iyesi. Ukʉipʉnʉ uya rɨ uyapiyo' pe na'ne' nama mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ekamʉra uyewan enasa' man, ɨ'rɨ ken si ta uya? ‘Papai, upika'tɨkɨ serɨ iweyu apai,’ ta uya? Kane, serɨ pɨkɨrɨ sa'ne serɨ iweyu pʉ'kʉ pona uye'sa' serɨ ko. ");
INSERT INTO akeNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Papai, eke pe ɨyese' e'to' enpoikakɨ,” ta'pʉ iya. Mɨrɨ a'tai main uyee'pʉ Epʉn poi, “Enpoikaka'sa' uya rɨ man, mɨrɨ awonsi'kɨ enpoikakapʉ uya rɨ kanan mɨrɨ,” tawon. ");
INSERT INTO akeNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Anpisin mɨrɨ yau te'san uya etasa' uya, “Korʉme e'tʉrʉnka,” ta'pʉ; tʉron kon uya, “Inserʉ uya auro'ka,” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Sises uya, “Ɨiwano' kon pe serɨ main esi'pʉ mɨrɨ, urɨ iwano' pe pen,” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","“Serɨ si iweyu orʉ eseru aimenkato' yai. Serɨ orʉ epuru pe si te'sen ainʉnpato'. ");
INSERT INTO akeNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","E'tane, urɨ utanʉnsa' a'tai non apai, tanporon kon nɨ kɨ'mato' uya oton upiya',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Serɨ ta'pʉ iya, se kasa uma'tato' oton ta tʉuya ekama pe rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Anpisin uya ta'pʉ, “Ina uya etasa' man Main, Mosi' winon winɨ, Kʉrai uko'manto' oton tɨwɨrɨ rɨ, mɨrɨ ken pe' e'tane, ‘Ka'pon, Papa winon utanʉnto' oton,’ ta auya? Ɨnʉ' pʉse rɨ Ka'pon, Papa winon?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Mɨrɨ a'tai, Sises uya ta'pʉ, “Iweyu e'to' oton mɨrɨ ɨpiyau'nokon inke rʉ'kwɨ rɨ mara rɨ. Ɨpinintɨ' iweyu esi koro'tau, ewarupɨ uya ɨyeporo kon rawɨrɨ. Ka'pon ewarupɨ yau tʉutɨsen uya tʉutɨto' ya' i'tu pʉra rɨ iyesi mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Iweyu apurɨtɨ' moro ɨpiyau'nokon iyesi koro'tau, iweyu munkɨ amʉ' pe ɨyena kon pa,” ta'pʉ iya. Tʉusauro'to' nonkasa' tʉuya a'tai, Sises utɨ'pʉ, mɨrɨpan e'so'namʉ'pʉ to' piyapai. ");
INSERT INTO akeNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Serɨ ton eke ton Papa tʉrawasooi ti'tuto' ipɨkɨrɨ ku'sa' Sises uya e'tane tʉ'koro'tau'nokon, to' uya apurɨ pʉra rɨ marɨ iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Serɨ esi'pʉ pu'kena' Aisaya maimu a'ku'tɨnin pe: “Itepuru, ɨnʉ' uya ina nekamanʉ etasa'; ɨnʉ' ena' Itepuru meruntɨrʉ usenpoikasa'?” tawon. ");
INSERT INTO akeNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Mɨrɨ wenai, to' uya apurɨ pʉra rɨ iyesi, Aisaya uya tasa' na'ne' awɨrɨ rɨ: ");
INSERT INTO akeNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“To' enu rɨ a'kopɨ'sa' iya mɨrɨ awonsi'kɨ to' ewan nɨ sa'mantanʉ'pɨ'sa' iya, to' uya ene namai' tenu kon ke, to' uya ito'ka'nʉkʉ namai' tewan kon ke, to' era'tɨ namai' to' epi'tɨto' pe uya,” tawon. ");
INSERT INTO akeNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaya uya serɨ tasa' apʉne pʉra Sises apurɨpɨ'to' ipɨkɨrɨ ensa' tʉuya pɨ', ipɨ' isaurokʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mɨrɨ rɨ e'tane mɨrɨ koro'tau rɨ tu'kan kon nɨ itepuru ton uya apurɨ'pʉ rɨ. E'tane Pari'si amʉ' esi pɨ', tʉnapurɨnʉ kon ɨnekamapai pʉra to' esi'pʉ. To' uya tenpa'ka kon tʉusenupato' kon iwʉ' tapai tukai' to' enari'nʉmʉ'pʉ; ");
INSERT INTO akeNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ka'pon amʉ' uya tapurɨpɨtʉ kon i'se te'san pe tesi kon pɨ' Papa uya tapurɨpɨtʉ kon i'se tesi kon entai. ");
INSERT INTO akeNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Mɨrɨ a'tai, Sises usaurokʉ'pʉ eke pe, “Ka'pon uya uyapurɨ a'tai, urɨ rɨken apurɨ iya pe iyesi pen, e'tane kʉrɨ uyenno'nin nʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Uyene iya a'tai, uyenno'nin nʉ'pʉ ene iya mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Uye'sa' serɨ pata weyu pe, ɨnʉ' rɨ uyapurɨnin pe na'ne' enkurumʉ namai' moro ewarupɨ yau. ");
INSERT INTO akeNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Kʉrɨ nin ka'pon umaimu eta pɨ' na'ne' e'tane, ikupʉ iya pʉra na'ne', iteseru aimenka uya pen nɨ, apʉne pʉra pata eseru aimenkai' uye'sa' pen, e'tane ipika'tɨi'. ");
INSERT INTO akeNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Moro unurunpanin mɨrɨ awonsi'kɨ umaimu ananʉnpaino pen eseru aimenkanin esi mɨrɨ, mɨrɨ rɨ main usauro'ai'ne' uya eno'mato' oton pata weyu u'ma'sa' a'tai. ");
INSERT INTO akeNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Uiwano' pe usauro'sa' kasa pʉra, e'tane ikʉipʉnʉ uyenno'nin nʉ'pʉ uya uyapiyo'masa' usauro'to' pe umaimu'tɨsa' iya rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","I'tu uya, serɨ uya arɨn tɨwɨrɨ rɨ uko'man nɨto' ya'. Mɨrɨ pɨ' si usauro'ai'ne' ikʉipʉnʉ uya upana'tɨ'pʉ rʉ'pʉ ekama uya,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ pɨ' e'nɨto' rawɨrɨ kuru rɨ, Sises uya i'tusa' esi'pʉ serɨ non nɨnto' tʉuya weyu e'seposa', ikʉipʉnʉ piya' si tʉutɨto'. Tiwano' ton pe te'san i'nʉnkakapʉ tʉpo, non po te'san, mɨrɨpan kon ena' nin si ipan pe to' i'nʉnkato' tʉuya enpoikakaa'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ko'maan pe enta'nan nɨto' utanʉnkaa'pʉ, Makoi uya Isutas Eskariya', Saiman mu ku'sa' esi'pʉ isenuminkato' pe Sises eparanka pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Sises uya tanporon nɨ nonkasa' ikʉipʉnʉ uya tena' tukai' i'tu'pʉ; tʉuye'sa' Papa winɨ, mɨrɨpan enna'po Papa piya' tukai' rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mɨrɨpan e'mʉ'sa'ka'pʉ tepʉrʉ piyapai, tʉpon pʉro'pon mo'ka'pʉ iya, mɨrɨpan uya towerʉ e'me'pʉ tʉworo'pai pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Mɨrɨ tʉpo, tuna ma'pʉ iya pesʉn ya', mɨrɨpan uya tʉpoitorʉ ton pʉta korʉkapɨtʉ'pʉ a'munakapɨtʉi'ma tʉworo'pai pokon towerʉ ke. ");
INSERT INTO akeNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Mɨrɨpan uye'kaa'pʉ Saiman Pi'ta poi rɨ, tekama'po ton, “Uyepuru, u'ta si korʉka auya?” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Sises uya eikʉ'pʉ, “Ito'ka'nʉkʉ auya pʉra iyesi mɨrɨ siku'ai'ne', e'tane emennʉ'pʉ ito'ka'nʉ'to' auya oton,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","“Kane, u'ta korʉkato' auya pʉra rɨ iyesi mɨrɨ,” ta'pʉ Pi'ta uya ipɨ'. Sises uya eikʉ'pʉ, “Ɨkorʉkasa' uya pʉra iyesi a'tai, upʉ'kʉ pe ɨwesi pen,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Mɨrɨ a'tai, Saiman Pi'ta uya eikʉ'pʉ, “Uyepuru, u'ta rɨken pen ken si e'tane, uyemiyatʉ ton mɨrɨ awonsi'kɨ u'pai rɨ nɨrɨ ken!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Sises uya eikʉ'pʉ, “Ka'pon iyeku'pɨsa' esi ti'ta rɨken korʉkato' iya pe; tanporon nin ipun esi mɨrɨ wakʉ pe. Wakʉ pe nin ɨwesi kon mɨrɨ, tanporo kuru ɨwe'tane'nokon pʉra rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","I'tu tʉuya wenai teparanka ton; mɨrɨ pɨ' nin si, tanporo wakʉ pe ɨwesi kon pen, ta'pʉ iya na'ne'. ");
INSERT INTO akeNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","To' pʉta korʉka nonka tʉuya tʉpo, iyepontɨkaa'pʉ kanan, mɨrɨpan enna'po'pʉ tʉpata'pʉ ya'. Mɨrɨpan uya, “Mʉto'ka'nʉ'atʉu pe' ɨpɨ'nokon siku'ai'ne'?” ta'pʉ to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“‘Ti'sa,’ ‘Uyepuru,’ tukai' uyesakʉ auya'nokon, mɨrɨ esi ipoken nɨ, kʉrɨ rɨ rɨ urɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mɨrɨ si urɨ, ɨyepuru kon, ɨti'saai kon uya a'ta kon korʉkasa', ɨtonpa kon pʉta si tʉkorʉkase e'tɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ene kon pa iku'sa' uya mɨrɨ, ikupʉ kon pa ɨpɨ'nokon iku'sa' uya na'ne'. ");
INSERT INTO akeNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","I'napairon ekama uya ɨpɨ'nokon, ipoitorʉ esi pʉra rɨ iyesi eke pe tesa' entai, mɨrɨ pe pʉra main anin nɨ esi pʉra iyesi eke pe tenno'nin nʉ'pʉ entai. ");
INSERT INTO akeNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Serɨ ton i'tu auya'nokon pe iyesi pɨ', ɨpʉrema'nokon mɨrɨ, mɨrɨ ton kupʉ auya'nokon yau. ");
INSERT INTO akeNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Tanporon kon ɨmɨrɨ'nokon pɨ' ta uya pen nɨ; i'tu uya kamo unanʉmʉ'san, e'tane serɨ esi iye'menukasa' itekare a'ku'tɨnin pe: ‘Upokon pe rɨ iyenta'nasa' rʉ'pʉ enasa' uyewa'nomanin pe,’ tawon. ");
INSERT INTO akeNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ekama uya serɨ ɨpɨ'nokon iye'kupʉ wapiya, iye'kupʉ a'tai apurɨ kon pa kʉrɨ rɨ pe esi tukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","I'napairon ekama uya ɨpɨ'nokon, ɨnʉ' uya rɨ ɨnʉ' rɨ unennokonʉ anʉmʉ uya uyanʉmʉ rɨ, mɨrɨ awonsi'kɨ ɨnʉ' uya rɨ uyanʉmʉ uya kʉrɨ uyenno'nin nʉ'pʉ anʉmʉ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Serɨ ta'pʉ iya tʉpo, ipan pe ipokoita'pʉ ta'kwarʉ yau, mɨrɨpan uya ekama'pʉ, “I'napairon ekama uya ɨpɨ'nokon, ɨtonpa kon uya uyeparankato' oton,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Mɨrɨpan poitorʉ ton usenpɨtʉ'pʉ, ɨnʉ' pɨ' ta iya ta pe. ");
INSERT INTO akeNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","To' tonpa Sises ni'nʉnkanʉ ipoitorʉ esi'pʉ ipiyau tʉteire' po. ");
INSERT INTO akeNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saiman Pi'ta uya kʉrɨ rɨ wʉi'ka'pʉ ekama'poto' pe iya, “Ekama'po' ɨnʉ' pɨ' ta iya tukai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Sises pona nin si te'tʉnkai' ekama'po'pʉ iya mɨrɨ, “Uyepuru, ɨnʉ' si?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Sises uya eikʉ'pʉ, “Kʉrɨ sa'ne pʉreti piya'pɨ tʉki'se itena' sitʉyai'ne',” ta'pʉ iya. Mɨrɨpan uya pʉreti piya'pɨ kii'pʉ, mɨrɨpan tʉrʉ'pʉ iya Isutas Eskariya', Saiman mu ena'. ");
INSERT INTO akeNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pʉreti a'si iya pe rɨ, Se'tan ewomʉ'pʉ iya'. “Ɨnkupʉnʉ pe te'sen iku'kɨ inke pʉra,” ta'pʉ Sises uya ipɨ', ");
INSERT INTO akeNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","e'tane ɨnʉ' rɨ enta'nan pɨ' te'sen uya ito'ka'nʉkʉ'pʉ pen ɨ'rɨ pe iyesi pɨ' serɨ ta Sises uya ipɨ' tukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Apʉne pʉra Isutas esi'pʉ pʉrata esa' pe, tʉron kon nɨ nin si usenuminka'pʉ mɨrɨ, i'se te'to' kon Iweyu Rʉ'pʉ pɨ' e'nɨ iwano' pe rɨ na'kɨ ennato' pe iya, mɨrɨ pe pʉra entu'manin nan irepakɨ ta iya rɨ na'kɨ ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Isutas uya pʉreti a'si pe rɨ, iyepa'ka'pʉ nin si. Ewarupɨ nau serɨ esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Iyepa'ka'pʉ pata'pʉ yau, Sises uya ta'pʉ, “Serɨ si Ka'pon, Papa winon apurɨpɨ'to' ipɨ', mɨrɨ awonsi'kɨ Papa apurɨpɨ'to' si rɨ man iyau. ");
INSERT INTO akeNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Papa apurɨpɨ'to' esi yau, iyau, Papa uya rɨ nɨrɨ tʉmu apurɨpɨtʉ mɨrɨ tʉyau, inke pʉra apurɨpɨtʉ iya mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Umunkɨ amʉ', mara rʉ'kwɨ kuru inke rʉ'kwɨ esi serɨ ɨpiyau'nokon, uwarinpato' auya'nokon oton, Esuwerʉ amʉ' pɨ' ukataine' kasa rɨ ta uya ɨpɨ'nokon: Utɨyai'ne' ya' ɨuyepʉ kon poken pʉra iyesi. ");
INSERT INTO akeNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Emenna' main ke ɨrepa uya 'nokon: Ɨtonpa kon i'nʉnkatɨ'. Ɨi'nʉnkasa' uya 'nokon na'ne' kasa, mɨrɨ kasa ɨtonpa kon i'nʉnkatɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tanporo ka'pon amʉ' uya i'tu mɨrɨ upoitorʉ ton pe ɨwesi kon tukai' ɨtonpa kon i'nʉnka auya'nokon yau,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saiman Pi'ta uya ekama'po'pʉ, “Uyepuru, nai ya' ɨutɨ?” ta'pʉ iya. Sises uya eikʉ'pʉ, “Utɨyai'ne' ya' upɨkɨrɨ ɨuyepʉ pʉra iyesi, e'tane emennʉ'pʉ rɨ upɨkɨrɨ ɨuye'to' oton,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pi'ta uya ekama'po'pʉ, “Uyepuru, ɨ'rɨ pe iyesi pɨ' serɨ pe utɨ pʉra iyesi ɨpɨkɨrɨ? Ɨwenai rɨ uma'ta mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Mɨrɨ a'tai, Sises uya eikʉ'pʉ, “Uwenai kuru pe' auma'ta? I'napairon ekama uya serɨ ɨpɨ', kɨrɨtɨkɨ uturumʉ rawɨrɨ, osorʉwau ite'kwa kuru ui'tunin pe pʉra ɨye'ku'to' oton!” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Sises uya ta'pʉ, “Kɨsewankamatʉu! Papa apurɨtɨ'; urɨ rɨ nɨrɨ apurɨtɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tu'ke rɨ pata wannɨ man ukʉipʉnʉ iwʉ' tau; sekamai'no mɨrɨ pe pʉra iyesi yau. Mɨrɨ ya' utɨ serɨ apata'se' kon oton konekai'. ");
INSERT INTO akeNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Utɨsa' pe iyesi yau apata'se' kon konekai', uye'kapʉ kanan ayase'na'nokon upiyau ɨwesi kon pa, e'ai'ne' yau ɨwesi kon pa. ");
INSERT INTO akeNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ite'ma i'tu auya'nokon mɨrɨ utɨn nɨto' ya' utɨyai'ne' ya',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tamas uya ta'pʉ ipɨ', “Uyepuru, ina uya sa'ne i'tu pʉra iyesi nai ya' ɨutɨ tukai'; nai kasa ken ina uya ite'ma i'tu?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Sises uya eikʉ'pʉ, “Urɨ rɨ esi ite'ma pe, mɨrɨ awonsi'kɨ i'napairon nɨ, mɨrɨ awonsi'kɨ uko'man nɨto' rɨ. Ɨnʉ' rɨ utɨ pʉra iyesi ukʉipʉnʉ piya' urɨ poro rɨken itɨto' esi. ");
INSERT INTO akeNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","I'napai rɨ kuru ui'tu auya'nokon pe iyesi yau, ukʉipʉnʉ rɨ nɨrɨ i'tu auya'nokon mɨrɨ. Serɨ awonsi'kɨ i'tu auya'nokon, mɨrɨ awonsi'kɨ ensa' auya'nokon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Piri' uya ta'pʉ, “Uyepuru, ikʉipʉnʉ enpoikaka'kɨ ina ena'; mɨrɨ rɨken i'se ina esi mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Sises uya eikʉ'pʉ, “Ui'tu auya pʉra pe' iyesi, Piri', ɨpiyau'nokon nɨ inke rɨ uko'manka'sa' e'tane? Ɨnʉ' rɨ kʉrɨ uyennin pe na'ne' uya rɨ ukʉipʉnʉ ensa' pe iyesi. Nai pe mairɨ, ‘Ikʉipʉnʉ enpoikakɨ ina ena',’ ta auya? ");
INSERT INTO akeNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Apurɨ auya pʉra pe' iyesi urɨ esi ikʉipʉnʉ yau, ikʉipʉnʉ nɨrɨ esi uyau? Main sekamayai'ne' ɨpɨ'nokon esi uiwano' pen e'tane ikʉipʉnʉ, uyau nʉko'manyai'ne' uya tʉtʉrawasooi kupʉ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Uyapurɨtɨ', urɨ esi ikʉipʉnʉ yau, ikʉipʉnʉ esi uyau ta uya a'tai; mɨrɨ pe pʉra, eke Papa tʉrawasooi amʉ' kupʉ uya rɨ apurɨtɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","I'napairon ekama uya ɨpɨ'nokon, ɨnʉ' rɨ uyapurɨnin esi pe iyesi yau, kʉrɨ rɨ uya iku'to' oton mɨrɨ siku'ai'ne' rɨ. Mɨrɨ entaino kuru rɨ ku'to' iya oton siku'ai'ne' entai kuru rɨ, apʉne pʉra utɨ wenai ikʉipʉnʉ piya'. ");
INSERT INTO akeNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ikupʉ uya rɨ ɨnekama'ponʉ kon uyese' yau, imu uya ikʉipʉnʉ apurɨpɨ'to' ipɨkɨrɨ enpoikato' pe. ");
INSERT INTO akeNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Uyekama'po auya'nokon nɨ mɨrɨ ɨ'rɨ pɨ' rɨ uyese' yau, ikupʉ uya rɨ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ui'nʉnka auya'nokon pe iyesi yau, umaimu awɨrɨ rɨ ɨwesi kon mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ikʉipʉnʉ ekama'po uya mɨrɨ, mɨrɨpan uya Ɨpika'tɨnin kon tʉron nɨ enno'to' pe, ɨpiyau'nokon te'ton tɨwɨrɨ rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Pʉse rɨ I'napairon A'kwarʉ, serɨ non pon kon nanʉmʉnʉ pen nɨ, apʉne pʉra ene to' uya pʉra iyesi, mɨrɨ awonsi'kɨ i'tu to' uya pʉra rɨ iyesi, e'tane i'tu auya'nokon apʉne pʉra ɨpiyau'nokon iyesi, ayau'nokon nɨ nɨrɨ iye'to' oton. ");
INSERT INTO akeNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Piyapaino pe ɨnɨmɨ uya 'nokon pen; ɨpiyau'nokon uyepʉ rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Serɨ pe rɨ, serɨ non pon kon uya uyene pʉra iyena, mɨrɨ e'tane uyento' auya'nokon oton. Apʉne pʉra uko'mamʉ pɨ', ɨmɨrɨ'nokon nɨ marɨ uko'manto' oton. ");
INSERT INTO akeNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Uto'ka'nʉ'atʉi'ne' a'tai i'tuto' auya'nokon oton ukʉipʉnʉ yau esi, ɨmɨrɨ'nokon esi uyau, mɨrɨ awonsi'kɨ urɨ esi ayau'nokon. ");
INSERT INTO akeNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ɨnʉ' rɨ umaimu esa' pe na'ne' esi mɨrɨ iyawɨrɨ rɨ, kʉrɨ rɨ kʉrɨ rɨ ui'nʉnkanin ye' rɨ. Kʉrɨ rɨ ui'nʉnkanin i'nʉnka ukʉipʉnʉ uya mɨrɨ, urɨ uya rɨ nɨrɨ i'nʉnka kanan mɨrɨ awonsi'kɨ usenpoika rɨ itena',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mɨrɨ a'tai, Isutas (Isutas Eskariya' pen) uya ta'pʉ, “E'tane sa'ne Uyepuru, ɨ'rɨ pe iyesi pɨ' ina enu ya' ɨusenpoika, serɨ non pon kon enu ya' pʉra rɨ?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Sises uya eikʉ'pʉ, “Ɨnʉ' uya rɨ ui'nʉnka pe iyesi yau, tenupato' uya awɨrɨ rɨ iyesi mɨrɨ. Ukʉipʉnʉ uya i'nʉnkato' oton, mɨrɨpan piya' ina uye'to' oton, iyau tʉpata kon koneka ina uya. ");
INSERT INTO akeNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kʉrɨ rɨ ui'nʉnka iya pʉra na'ne' esi mɨrɨ tenupato' uya awɨrɨ pʉra rɨ. Serɨ ton main amʉ' metayatʉi'ne' esi uiwano' pen; uyenno'nin nʉ'pʉ ikʉipʉnʉ iwano' pe iyesi. ");
INSERT INTO akeNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Serɨ ton pɨ' usaurokʉ mɨrɨ ɨpiyau'nokon esi koro'tau. ");
INSERT INTO akeNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","E'tane kʉrɨ Ɨpika'tɨnin kon, Wakʉ A'kwarʉ, ikʉipʉnʉ, uyese' yau nenno'ai'ne' uya ɨyenupato' oton kon tanporon pɨ' rɨ, ɨyemiya'pontɨ iya 'nokon nɨ kanyauro'kapɨ'ta'tʉine' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Tʉusewankamai' pʉra ɨwe'to' kon nɨmɨ uya serɨ ɨpiyau'nokon; uiwano' pe te'sen tʉrʉ uya ɨyena'nokon. Serɨ non nʉtʉyai'ne' kasa itʉrʉ uya pen. Kɨsewankamatʉu, kenari'nʉntʉu. ");
INSERT INTO akeNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Ta uya etasa' auya'nokon, ‘Utɨ serɨ, uye'kapʉ rɨ marɨ ɨpiya'nokon.’ Ui'nʉnka auya'nokon yau, pori' pe rɨ ɨwesi kon mɨrɨ utɨ pɨ' ikʉipʉnʉ piya', apʉne pʉra ikʉipʉnʉ esi eke pe uyentai. ");
INSERT INTO akeNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Serɨ ekamasa' uya serɨ ɨpɨ'nokon iye'kupʉ rawɨrɨ, iye'kupʉ a'tai si tɨ apurɨ kon pa. ");
INSERT INTO akeNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Inke kuru ayauro'ka uya 'nokon pen, apʉne pʉra serɨ pata epuru uye'nɨ pɨ' man. Ɨ'rɨ pe uku'nin pen nɨ, ");
INSERT INTO akeNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","e'tane serɨ non pon kon uya i'tuto' pe iyesi ikʉipʉnʉ i'nʉnka uya, mɨrɨpan uyapiyo'ma'pʉ iya rʉ'pʉ kupʉ uya iyawɨrɨ kuru. “Ɨsi'tɨ', utɨnpai'nokon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Urɨ esi i'napairon ite' pe; ukʉipʉnʉ nin si esi mɨrɨ imainanpanin pe. ");
INSERT INTO akeNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Upanta tepetasen pen a'tɨpɨtʉ iya, tepetasen pu'kuima iya ikaima pe, miyarɨ rɨ iyepetato' pe. ");
INSERT INTO akeNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ikaimaka'sa' pe ɨwesi kon mɨrɨ main kanyauro'kayatʉi'ne' ike uriya'. ");
INSERT INTO akeNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Moro uyau ɨko'mantɨ', moro ayau'nokon nɨrɨ uko'manto' pe. Ipanta epeta pʉra iyesi tiwa rɨ; moro tʉye' pɨ' iko'manto' pe iyesi. Ɨmɨrɨ'nokon nɨ nɨrɨ epeta pʉra iyesi mɨrɨ moro uyau ɨuko'mamʉ kon pʉra iye'tane. ");
INSERT INTO akeNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ite' pe esi; ɨmɨrɨ'nokon esi ipanta ton pe. Moro ka'pon esi yau uyau mɨrɨ awonsi'kɨ urɨ nɨrɨ iyau, tu'ke rɨ iyepeta mɨrɨ; urɨ pʉra iye'tane ɨ'rɨ kupʉ auya'nokon pʉra rɨ iyesi. ");
INSERT INTO akeNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ɨnʉ' rɨ esi pʉra iyesi yau moro uyau, iyesi mɨrɨ eno'masa', useketasa' ipanta kasa; mɨrɨ waraino ipanta ton amuku mɨrɨ eno'mato' pe apo' ya', iyepo'tɨto' pe. ");
INSERT INTO akeNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Moro uyau ɨwesi kon pe iyesi yau, umaimu rɨ nɨrɨ esi moro ayau'nokon, i'se ɨwe'to' kon ekama'potɨ', ɨrepa kon nɨ mɨrɨ ike. ");
INSERT INTO akeNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Se uya ukʉipʉnʉ apurɨpɨ'to' enpoika, tu'ke ɨyepeta kon, upoitorʉ ton pe ɨwesi kon ekamanin pe. ");
INSERT INTO akeNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Ikʉipʉnʉ uya ui'nʉnkasa' na'ne' kasa, mɨrɨ kasa ɨi'nʉnkasa' uya 'nokon. Moro si usi'nʉnkato' yau e'tɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Umaimu awɨrɨ ɨwesi kon yau, usi'nʉnkato' yau moro ɨwesi kon mɨrɨ, ukʉipʉnʉ maimu awɨrɨ e'sa' na'ne' kasa kuru mɨrɨ awonsi'kɨ moro isi'nʉnkato' yau e'ai'ne' kasa. ");
INSERT INTO akeNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Serɨ ke apana'tɨsa' uya 'nokon mɨrɨ pori' pe e'to' pe ɨpɨ'nokon mɨrɨ awonsi'kɨ pori' pe ɨwe'to' kon e'to' pe mararon pe pʉra. ");
INSERT INTO akeNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Se serɨ apiyontɨn nɨto' uya: Ɨtonpa kon i'nʉnkatɨ', ɨi'nʉnkasa' uya 'nokon na'ne' kasa. ");
INSERT INTO akeNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ɨnʉ' rɨ usi'nʉnkato' pʉra rɨ iyesi mɨrɨ eke pe, kʉrɨ tʉtonpa ton iwano' pe tʉuko'manto' tʉnin entai. ");
INSERT INTO akeNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Utonpa ton pe ɨwesi kon mɨrɨ ayapiyo'ma'pʉ uya 'nokon kupʉ auya'nokon yau. ");
INSERT INTO akeNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Upoitorʉ tukai' si ɨyesakʉ uya 'nokon pen serɨ enta', apʉne pʉra ipoitorʉ kʉrɨ rɨ tepuru tʉrawasooi i'tunin pen. E'tane ru'ku, ɨyesakʉ uya 'nokon utonpa ton tukai', apʉne pʉra tanporon nɨ usenupa'pʉ ipɨ' ukʉipʉnʉ winɨ i'tu kon pa iku'sa' uya pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Uyanʉnsa' auya'nokon pen, e'tane ayanʉnsa' uya 'nokon ɨutɨ kon pa epetai', iteperu moro tʉuko'mansen ye' pe. Mɨrɨ a'tai, ikʉipʉnʉ uya ɨrepa kon ɨ'rɨ rɨ uyese' yau ɨnekama'ponʉ kon ke. ");
INSERT INTO akeNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Serɨ serɨ apiyontɨn nɨto' uya: Ɨtonpa kon i'nʉnkatɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Orʉ uya ɨyewaruma'tɨ kon yau, ɨyenu kon yau mʉku'tʉi' wapiya urɨ ewaruma'tɨ'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Orʉ iwano' pe ɨwesi kon yau, ɨi'nʉnka iya 'nokon mɨrɨ tiwano' pe ɨwesi kon pɨ'. Na'ne' rɨ nin si, orʉ iwano' pe ɨwesi kon pen, e'tane ayanʉnsa' uya 'nokon orʉ apai. Mɨrɨ wenai, orʉ uya ɨyewaruma'tɨ kon. ");
INSERT INTO akeNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ɨyenu kon yau main usaurokʉ'pʉ rʉ'pʉ mʉku'tʉi': ‘Ɨnʉ' rɨ ipoitorʉ esi pʉra iyesi eke pe tesa' entai,’ tawon. To' uya ukota'masa' yau, to' uya rɨ marɨ ɨkota'ma kon mɨrɨ. Urɨ uya tenupato' kon awɨrɨ to' esi yau, to' rɨ esi mɨrɨ ɨmɨrɨ'nokon uya to' enupa'pʉ awɨrɨ rɨ marɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Serɨ kasa to' uya ɨkupʉ kon mɨrɨ uyese' pɨ' ɨwesi kon pɨ', apʉne pʉra to' uya i'tu pʉra iyesi kʉrɨ uyenno'nin nʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Uye'sa' pʉra iyesi yau to' auro'kase'na, tʉmakooi ke to' esi pɨ' ɨri pe to' nesii'no pen nɨ. E'tane nin si, mɨrɨ pɨ', tʉmakooi kon wapu'tɨto' uya poken pʉra iyesi. ");
INSERT INTO akeNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kʉrɨ uyewaruma'tɨnin uya ukʉipʉnʉ rɨ marɨ ewaruma'tɨ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ɨnʉ' nʉkupʉ'pʉ pen nɨ ku'sa' uya pʉra iyesi yau to' koro'tau, tʉmakooi ke tesi kon pɨ' ɨri pe to' nesii'no pen nɨ. E'tane si serɨ eke tʉrawaso amʉ' kupʉ uya ensa' to' uya, e'tane si asa'rɨ rɨ marɨ urɨ, mɨrɨ awonsi'kɨ ukʉipʉnʉ ewaruma'tɨsa' to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","E'tane serɨ iye'menukasa' Main uta'ku'tɨto' pe iyesi: ‘Iwenai pʉra rɨ to' uya uyewaruma'tɨ'pʉ,’ tawon. ");
INSERT INTO akeNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ɨpika'tɨnin kon uye'sa' a'tai, unennoko'pʉ ikʉipʉnʉ winɨpaino, i'napairon A'kwarʉ, ikʉipʉnʉ yapai tepa'kasen uya uyekamato' oton ɨpɨ'nokon. ");
INSERT INTO akeNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mekamatʉi' rɨ nɨrɨ ɨmɨrɨ'nokon upiyau ɨwe'sa' kon mɨrɨ iyepiya'tɨ'pʉ si'kɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Tanporo serɨ ke apana'tɨsa' uya 'nokon serɨ autano'ma kon namai'. ");
INSERT INTO akeNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","To' uya ɨyenpa'kato' oton kon usenupan nɨto' iwʉ' tapai; i'napai rɨ iweyu uye'kapʉ, ɨwɨnin e'ku'to' oton wakʉ kupʉ tʉuya pe tekamai' Papa iwano' pe. ");
INSERT INTO akeNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Serɨ rupɨ ton kupʉ to' uya mɨrɨ, apʉne pʉra to' uya ikʉipʉnʉ mɨrɨ pe pʉra urɨ i'tu pʉra iyesi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Serɨ ke apana'tɨsa' uya 'nokon, iweyu uye'sa' a'tai, apana'tɨ'pʉ uya 'nokon e'to' pe ɨyenu kon yau. Serɨ ke apana'tɨ uya 'nokon pʉn wapiya, apʉne pʉra ɨpiyau'nokon esi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Utɨyai' si uyenno'nin nʉ'pʉ piya', e'tane ɨnʉ' uya uyekama'po pʉra man, ‘Nai ya' ɨutɨ?’ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Apʉne pʉra si serɨ ton ekamasa' uya pɨ' ɨupokoitasa' kon nin si. ");
INSERT INTO akeNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","E'tane i'napairon ekama uya ɨpɨ'nokon: Wakʉ pe ɨwesi kon pa utɨ serɨ. Utɨsa' pʉra iyesi yau, Ɨpika'tɨnin kon uyepʉ pʉra iyesi ɨpiya'nokon; e'tane utɨsa' yau, ennoko uya mɨrɨ ɨpiya'nokon. ");
INSERT INTO akeNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Iye'sa' a'tai, orʉ pɨ' enpoika iya mɨrɨ ipoken pʉra makoi pɨ' iyesi pɨ', iyawɨron pɨ', mɨrɨ awonsi'kɨ eseru aimenkato' pɨ': ");
INSERT INTO akeNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","makoi pɨ', apʉne pʉra ka'pon amʉ' uya uyapurɨ pʉra iyesi pɨ'; ");
INSERT INTO akeNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","iyawɨron pɨ', apʉne pʉra ikʉipʉnʉ piya' utɨ pɨ', mɨrɨ enta' uyene auya'nokon pʉra iye'to' ya'; ");
INSERT INTO akeNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","mɨrɨ awonsi'kɨ eseru aimenkato' pɨ', apʉne pʉra serɨ orʉ epuru si esi pɨ' eno'masa' pe. ");
INSERT INTO akeNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Eke pe rɨ tato' uya man ɨpɨ'nokon, e'tane a'si auya'nokon poken pʉra iyesi. ");
INSERT INTO akeNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","E'tane kʉrɨ, i'napairon A'kwarʉ uye'sa' a'tai, ayarɨ iya 'nokon mɨrɨ i'napairon ya'. Tiwano' pe isauro'to' oton pen, tʉneta'pʉ pɨ' rɨken isauro'to' oton, mɨrɨ awonsi'kɨ ekamato' iya oton miyarɨ rɨ tʉuye'sen. ");
INSERT INTO akeNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Uyapurɨpɨ'to' ipɨ' nepʉ iya mɨrɨ uiwano' mo'ka tʉuya winɨ i'tunin pe ɨwesi kon pa ikupʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tanporo ikʉipʉnʉ iwano' pe na'ne' esi mɨrɨ uiwano' rɨ. Mɨrɨ pe iyesi pɨ' ukayai'ne', Iya'kwarʉ uya uiwano' mo'ka i'tunin pe ɨwesi kon pa ikupʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Serɨ pe iwa rɨ mɨrɨ enta' uyene auya'nokon pʉra iyena mɨrɨ, mɨrɨ awonsi'kɨ mɨrɨ tʉpo uyento' auya'nokon oton mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ipoitorʉ ton tonpa ton uya ta'pʉ tʉtonpa kon pɨ', “Ɨ'rɨ ta iya e'kwa pe iyesi, ‘Serɨ pe iwa rɨ mɨrɨ enta' uyene auya'nokon pʉra iyena mɨrɨ, mɨrɨ awonsi'kɨ mɨrɨ tʉpo uyento' auya'nokon oton mɨrɨ,’ mɨrɨ awonsi'kɨ, ‘Apʉne pʉra ikʉipʉnʉ piya' utɨ pɨ',’ nɨkayai'ne'?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","To' esi'pʉ usekama'popɨ' nɨ pɨ', “Ɨ'rɨ ta iya e'kwa pe iyesi, ‘serɨ pe iwa rɨ’ nɨkayai'ne'? Ito'ka'nʉkʉ'nokon pʉra man,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Sises uya ene'pʉ tekama'popai'nokon to' esi serɨ pɨ', mɨrɨpan uya ta'pʉ to' pɨ', “Ɨusekama'popɨtʉ kon ɨ'rɨ ta uya e'kwa pe iyesi, ‘Serɨ pe iwa rɨ mɨrɨ enta' uyento' auya'nokon oton pen, mɨrɨ awonsi'kɨ mɨrɨ tʉpo uyento' auya'nokon oton nɨ mɨrɨ’? ");
INSERT INTO akeNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","I'napairon ekama uya ɨpɨ'nokon, ɨupokoitato' oton kon, tʉuta'kwarʉkai' aukaranto' oton kon pata epori'ma tane. Ɨupokoitato' oton kon, e'tane ɨpokooi kon era'tɨto' oton epori'man pe. ");
INSERT INTO akeNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Tentusen uri'san utaimerunpa mɨrɨ e'ne' pe tesi pɨ', apʉne pʉra tʉweyu e'seposa' pɨ'; e'tane nin si tʉmʉre entusa' a'tai, e'ne' pe tesi'pʉ pu'tɨka'nʉkʉ iya mɨrɨ, apʉne pʉra pori' pe tesi pɨ' mʉre entunʉ'sa' tʉuya pɨ' orʉ pona. ");
INSERT INTO akeNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mɨrɨ kasa ɨwesi kon mɨrɨ: Ɨupokoita kon weyu si serɨ, e'tane ɨyento' uya 'nokon oton; mɨrɨ a'tai, ɨyepori'ma kon mɨrɨ, ɨnʉ' uya rɨ pori' pe ɨwe'to' kon mo'kato' oton pen. ");
INSERT INTO akeNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Mɨrɨ wʉi a'tai, ɨ'rɨ pɨ' rɨ uyekama'po auya'nokon pen nɨ mɨrɨ. I'napairon ekama uya serɨ ɨpɨ'nokon; ukʉipʉnʉ uya rɨ ɨrepa kon uyese' yau ɨnekama'po'pʉ kon ke. ");
INSERT INTO akeNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Serɨ pʉ'kʉ pona rɨ ɨ'rɨ rɨ ekama'posa' auya'nokon pʉra man uyese' yau. Ekama'potɨ'; mɨrɨ a'tai, eporo auya'nokon nɨ mɨrɨ, mararon pe pʉra pori' pe ɨwe'to' kon esi mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Panton yai ayauro'kapɨ'sa' uya 'nokon, e'tane iweyu nʉye'an serɨ rupɨ main yai ayauro'kato' uya 'nokon weyu pen nɨ, e'tane sa'man yai pʉra rɨ ukʉipʉnʉ ekamato' uya oton ɨpɨ'nokon. ");
INSERT INTO akeNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mɨrɨ wʉi a'tai, uyese' yau ekama'poto' auya'nokon oton. Amaimu kon pe ikʉipʉnʉ ekama'poto' uya oton ta uya pen. ");
INSERT INTO akeNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kane, ikʉipʉnʉ uya rɨ tʉmɨrɨ pe ɨi'nʉnka kon, apʉne pʉra ui'nʉnkasa' auya'nokon pɨ' mɨrɨ awonsi'kɨ Papa winɨ uye'sa' pɨ' apurɨsa' auya'nokon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Uyee'pʉ ikʉipʉnʉ winɨpai serɨ orʉ pona; serɨ nin si orʉ nɨmɨ uya, ikʉipʉnʉ piya' enna'po,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Mɨrɨ a'tai, ipoitorʉ ton uya ta'pʉ, “Mɨrɨ si ausaurokʉ ito'ka'nʉkʉ poken, panton yai pʉra. ");
INSERT INTO akeNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Serɨ si ina uya i'tu tanporon nɨ i'tunin pe ɨwesi mɨrɨ awonsi'kɨ ɨnʉ' uya rɨ ɨyekama'poto' i'se pʉra rɨ ɨwesi. Serɨ uya ina kupʉ Papa winon pe ayapurɨnin pe,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","“Mɨrɨ si apurɨsa' auya'nokon iu'matʉ ya' rɨ!” tukai' Sises uya to' eikʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","“E'tane iweyu nʉye'an, iye'ka'sa' rɨ, ɨye'ta'nʉ'to' oton kon apata'se' kon ya'ne. Tikin sarɨ unonkato' auya'nokon oton. E'tane rɨ tikin sarɨ esi pen, apʉne pʉra ukʉipʉnʉ esi ke upiyau. ");
INSERT INTO akeNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Serɨ ton ekamasa' uya ɨpɨ'nokon, uyau ɨwesi kon pa ewankamanin pʉra. Serɨ orʉ po eke rɨ ɨyewankamanin kon esi, e'tane ɨyewan kon imeruntɨtanʉ'tɨ': Orʉ wapiya'kasa' uya man,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Serɨ ton ta'pʉ Sises uya tʉpo, tenu tʉrʉ'pʉ iya Epʉn winɨkʉi', mɨrɨpan uya ta'pʉ, “Papai, iweyu uye'sa' man. Ɨmu apurɨpɨ'kɨ, ɨmu uya nɨrɨ ayapurɨpɨ'to' pe. ");
INSERT INTO akeNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tanporon kon esa' pe iye'to' pe meruntɨ ke irepasa' auya na'ne' kasa, tɨwɨrɨ rɨ uko'man nɨto' tʉto' pe iya, irepa'pʉ auya na'ne' nan ena'. ");
INSERT INTO akeNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Serɨ tɨwɨrɨ rɨ uko'man nɨto', to' uya ɨi'tuto' pe i'napairon Papa pe ɨwesi, Sises Kʉrai nɨrɨ i'tuto' pe to' uya ɨnennoko'pʉ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Serɨ non po ayapurɨpɨ'to' ne'sa' uya man, tʉrawaso ɨntʉrʉ'pʉ iku'to' pe uya i'ma'kasa' uya winɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Papai, serɨ pe uyapurɨpɨ'kɨ upiyau ɨwesi ke rɨ, pena ɨpokon pe esi a'tai uyapurɨpɨ'taine' kasa non ekoneka wapiya. ");
INSERT INTO akeNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ɨi'tuto' pe ɨyenpoika'pʉ uya ka'pon amʉ' urepasa' auya na'ne' nan orʉ apai ena'. Ɨiwano' pe to' esi'pʉ; to' tʉsa' auya uyena', mɨrɨpan kon uya amaimu apurɨsa'. ");
INSERT INTO akeNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","To' uya nɨrɨ i'tusa' serɨ tanporon urepa'pʉ auya esi ɨwinon pe tukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Main urepa'pʉ auya ike ke to' repasa' uya, mɨrɨpan anʉnsa' to' uya. To' uya nɨrɨ i'tusa' ɨwinɨ uye'sa' tukai', uyenno'sa' auya tukai' nɨrɨ to' uya apurɨsa'. ");
INSERT INTO akeNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","To' pona ɨpʉrema. Orʉ pona ɨpʉrema pen, e'tane urepa'pʉ auya ton pona, apʉne pʉra ɨiwano' pe to' esi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tanporo upiyau na'ne' nɨrɨ esi ɨiwano' pe, tanporo ɨpiyau na'ne' esi nɨrɨ uiwano' pe. Kamoro uriya' uyapurɨpɨ'to' uye'sa'. ");
INSERT INTO akeNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Inke serɨ orʉ po esi pen, e'tane serɨ orʉ po to' esi, mɨrɨ awonsi'kɨ utɨ nin si ɨpiya'. Wakʉ ikʉipʉnʉ, ɨyese' meruntɨ ke to' iwapu'tɨkɨ—itese' urepa'pʉ auya ike—tikin nɨ to' e'to' pe, tikin nɨ e'nɨ na'ne' kasa. ");
INSERT INTO akeNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","To' piyau esi koro'tau, to' wapu pe e'sa' man, to' pa'sima pɨ' mɨrɨ itese' urepa'pʉ auya ike ke. Ɨnʉ' rɨ utano'masa' pʉra man, kʉrɨ rɨken tʉuma'tasen ye' pe rɨ iye'ku'sa' rʉ'pʉ iye'menukasa' itekare a'ku'tɨnin pe rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ɨpiya' si utɨ serɨ, e'tane serɨ ton ekama uya serɨ non po rɨ marɨ esi koro'tau, pori' pe e'to' eponin pe to' e'to' pe tʉyau'nokon. ");
INSERT INTO akeNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Amaimu ke to' repasa' uya, mɨrɨpan kon ewaruma'tɨ orʉ pon kon uya, orʉ pon kon pe pʉra to' esi wenai, urɨ nɨrɨ esi orʉ pon pe pʉra na'ne' kasa. ");
INSERT INTO akeNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ɨpʉrema orʉ apai to' mo'ka pa pen, e'tane to' wapu pe ɨwesi pa ɨri namai'. ");
INSERT INTO akeNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Orʉ iwano' ton pe pʉra to' esi, orʉ iwano' pe pʉra e'ai'ne' kasa. ");
INSERT INTO akeNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Wakʉ pe i'napairon poro to' iku'kɨ, amaimu esi i'napairon. ");
INSERT INTO akeNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Orʉ pona uyenno'sa' auya na'ne' kasa, mɨrɨ kasa rɨ marɨ to' enno'sa' uya non pon kon koro'ta'. ");
INSERT INTO akeNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","To' iwano' pe ekonekasa' wakʉ pe, to' nɨrɨ ekonekasa' e'to' pe wakʉ pe. ");
INSERT INTO akeNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Kamoro rɨken pona ɨpʉrema pen, e'tane kamoro uyapurɨnin nan pona nɨrɨ to' maimu wenai. ");
INSERT INTO akeNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tikin nɨ tanporo to' e'to' pe, Papai, ɨmɨrɨ esi na'ne' kasa uyau, urɨ nɨrɨ ayau. To' nɨrɨ e'to' pe tikin nɨ nɨrɨ uyau'nokon, orʉ pon kon uya apurɨto' pe uyenno'sa' auya tukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Uyapurɨpɨ'to' pe urepa'pʉ auya na'ne' ke to' repasa' uya, to' e'to' pe tikin nɨ, tikin nɨ e'nɨ na'ne' kasa rɨ marɨ: ");
INSERT INTO akeNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","urɨ to' yau, ɨmɨrɨ nɨrɨ uyau. To' ekonekato' pe wakʉ pe tikin nan nɨ yau, uyenno'sa' auya tukai' orʉ pon kon uya i'tuto' pe, to' i'nʉnkasa' uya, ui'nʉnkasa' auya na'ne' kasa. ");
INSERT INTO akeNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Papai, urepasa' auya ike na'ne' nan i'se esi upiyau e'ai'ne' yau, uyapurɨpɨ'to' ento' pe to' uya, urepa'pʉ auya na'ne' ike, apʉne pʉra ui'nʉnka auya pɨ', orʉ ekoneka rawɨrɨ rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Ipokena' Papai, orʉ uya ɨi'tu pʉra iye'tane, ɨi'tu uya. Uyenno'sa' auya tukai' nɨrɨ pʉsamoro uya i'tu. ");
INSERT INTO akeNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ɨyenpoikasa' uya to' ena', mɨrɨ kupʉ uya miyarɨ rɨ, ui'nʉnkato' auya e'to' pe to' iwano' pe, urɨ rɨ nɨrɨ si e'to' pe to' yau,” tukai' iwɨpʉrema'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tʉwɨpʉrema e'nonkasa' a'tai, Sises utɨ'pʉ tʉpoitorʉ ton pokon pe Kitʉron aranta tʉnɨ'kwɨrɨ'nʉ'se. Iratoi po are' e'kwa esi'pʉ, mɨrɨ ya' tʉpoitorʉ ton pokon pe Sises utɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Isutas si, eparankanin oton, uya mɨrɨ pata i'tu'pʉ, apʉne pʉra mɨrɨ ya' inke rɨ tʉpoitorʉ ton pokon pe tʉutɨpɨ'sen pe Sises e'pɨtʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Mɨrɨ pɨ', Isutas utɨ'pʉ are' e'kwa na', tamu'kuru' tawon kon soisa amʉ' arɨ pe mɨrɨ awonsi'kɨ use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru mɨrɨ awonsi'kɨ Pari'si amʉ' poitorʉ ton arɨ pe. To' uya ta'sʉrai' ton, raan'pu ton mɨrɨ awonsi'kɨ tepaai kon arɨ esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Sises uya tanporon nɨ tʉpɨ' te'ku'ton i'tu wenai, itɨ'pʉ to' ekama'poi', “Ɨnʉ' i'se ɨwesi kon?” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“Sises, Nasare' pon,” tukai' to' uya eikʉ'pʉ. “Kʉrɨ rɨ urɨ,” ta'pʉ Sises uya. (Isutas nin si eparankanin e'soto'kasa' esi'pʉ mɨrɨ to' pokon pe.) ");
INSERT INTO akeNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Sises uya, “Kʉrɨ rɨ urɨ,” ta etasa' tʉuya'nokon a'tai, ta'poi kon ya' to' enna'po uta'mo'ka'pʉ non pona. ");
INSERT INTO akeNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","To' kanan ekama'pokaa'pʉ iya, “Ɨnʉ' i'se ɨwesi kon?” ta'pʉ iya. Mɨrɨpan kon uya, “Sises, Nasare' pon,” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Kʉrɨ rɨ urɨ, ukayai'ne ko,” ta'pʉ Sises uya. “Uwarinpa auya'nokon pe iyesi yau, tɨwɨ pʉsamoro ka'pon amʉ' nʉtɨi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Serɨ e'kupʉ'pʉ isaurokʉ'pʉ a'ku'tɨnin pe: “Tikin nɨ rɨ urepa'pʉ auya ton tonpa ano'masa' uya pʉra man,” ta'pʉ iya rʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Mɨrɨ a'tai, Saiman Pi'ta, supara esa' pe te'sen uya imo'ka'pʉ, mɨrɨpan uya use'man nɨto' tʉrawasomanin nan epuru poitorʉ pana enwo'ne' winon a'tɨ'pʉ. (Ipoitorʉ ese' esi'pʉ Marʉ'kas.) ");
INSERT INTO akeNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Sises uya Pi'ta apiyo'ma'pʉ, “Ɨsuparaai emaika'! Ukʉipʉnʉ uya pe' uwo'pasa' na'ne' ike ensi uya pen?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mɨrɨ a'tai, tamu'kuru' tawon kon Roman soisaai amʉ', tepuru kon pokon pe esii'ma, mɨrɨ awonsi'kɨ Esuwerʉ amʉ' erasu ton uya Sises a'si'pʉ. To' uya auronpɨtʉ'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","mɨrɨpan kon uya arɨ'pʉ wapiya Anas piya' Kaya'pas tamo, mɨrɨ wʉipiya yau use'man nɨto' tʉrawasomanin nan epuru pe te'sen. ");
INSERT INTO akeNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaya'pas kʉrɨ rɨ Esuwerʉ amʉ' pɨ' wakʉ pe iwa iyesi mɨrɨ tikin nan ka'pon uma'tasa' a'tai ka'pon amʉ' iwano' pe tawon nʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saiman Pi'ta mɨrɨ awonsi'kɨ tʉron nɨ ipoitorʉ uya Sises e'ma'pʉka esi'pʉ. Apʉne pʉra use'man nɨto' tʉrawasomanin nan epuru ni'tunʉ pe pʉse rɨ ipoitorʉ esi'pʉ, mɨrɨpan utɨ'pʉ Sises a'kɨrɨ use'man nɨto' tʉrawasomanin nan epuru iwʉ' pʉ'kʉ ta'. ");
INSERT INTO akeNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","E'tane Pi'ta esi'pʉ mʉra'ta nau itenupɨkɨrɨ e'nɨ pɨ'. Tʉron nɨ ipoitorʉ use'man nɨto' tʉrawasomanin nan epuru ni'tunʉ, enna'posa' uyee'pʉ, mɨrɨpan uya mɨrɨ yawon uri'san auro'ka'pʉ, mɨrɨpan uya Pi'ta ewonnʉkʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","“Ɨmɨrɨ pen pe' kʉrɨ rɨ, kʉrɨ rɨ poitorʉ ton tonpa, ɨmɨrɨ rɨ?” tukai' uri'san mʉra'ta nawon uya Pi'ta ekama'po'pʉ. Entakanoma'pʉ iya, “Urɨ pen nɨ kʉrɨ rɨ,” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Komi' pe pata esi'pʉ, mɨrɨ pɨ' to' poitorʉ ton mɨrɨ awonsi'kɨ eke ton nɨ e'soto'pɨ'sa' esi'pʉ a'non pɨ' apo' piyau. Pi'ta rɨ nɨrɨ e'soto'kasa' esi'pʉ to' koro'tau a'non pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mɨrɨ koro'tau, use'man nɨto' tʉrawasomanin nan epuru uya Sises ekama'popɨtʉ'pʉ ipoitorʉ pɨ' mɨrɨ awonsi'kɨ enupan nɨto' iya pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Sises uya imaimu eikʉ'pʉ, “Ama'ai pʉra usauro'sa' man usenupan ku'sa' uya man Esuwerʉ amʉ' usenupato' iwʉ' tau, use'man nɨto', ɨpʉreman nɨto' iwʉ' tau, Esuwerʉ amʉ' amʉrato' yau'ne. ");
INSERT INTO akeNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ɨ'rɨ pe iyesi pɨ' uyekama'po auya? Uyetanin nʉ'san ekama'pokɨ. To' uya rɨ i'tu mɨrɨ umaimu rʉ'pʉ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Serɨ kasa isaurokʉ a'tai, soisa amʉ' tonpa iye'mʉ'sa'kasa' uya temiyatʉ ke itemʉ' pɨ' iwɨnɨ'pʉ. “Mɨrɨ kasa pe' tʉmaimu'sen kʉrɨ use'man nɨto' tʉrawasomanin nan epuru?” tai'ma. ");
INSERT INTO akeNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Sises uya imaimu eikʉ'pʉ, “Ipoken pʉra usauro'sa' pe iyesi yau, ekama'. E'tane i'napairon pɨ' usauro'sa' pe iyesi yau, ɨ'rɨ pe iyesi pɨ' uwɨnɨ auya?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anas uya ennoko'pʉ auronpɨ'sa' pe rɨ marɨ Kaya'pas piya' use'man nɨto' tʉrawasomanin nan epuru. ");
INSERT INTO akeNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saiman Pi'ta e'mʉ'sa'kasa' esi koro'tau a'non pɨ'. “Ipoitorʉ ton tonpa pen pe' ɨmɨrɨ?” ta'pʉ to' uya ipɨ'. I'tunin pe pʉra iye'kuu'pʉ, “Urɨ pen nɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Use'man nɨto' tʉrawasomanin nan epuru poitorʉ tonpa pe te'sen, Pi'ta nakʉtʉ'pʉ ipana tonpa pe te'sen uya ta'pʉ, “Ɨmɨrɨ pen pe' iya'kɨrɨ are' e'kwa nau sentaine' pen?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pi'ta kanan e'ku'kaa'pʉ i'tunin pe pʉra. Mɨrɨ a'tai rɨ, kɨrɨtɨkɨ epiya'tɨ'pʉ uturun nɨ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mɨrɨ a'tai, Esuwerʉ amʉ' uya Sises arɨ'pʉ Kaya'pas piyapai Roman amʉ' kopʉnaai iwʉ' ta'. Awanakʉi' si pata enaka'sa' esi'pʉ, ɨri pe enapai pʉra tesi kon pɨ' Esuwerʉ amʉ' ewomʉ'pʉ pen mɨrɨ ya', enta'napai tesi kon pɨ' Itepoi Itɨ'pʉ Weyu Rʉ'pʉ a'taino pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Paire' epa'ka'pʉ to' piya', “Ɨ'rɨ waraino ke eseru'tɨ auya'nokon?” tase'na. ");
INSERT INTO akeNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","To' uya imaimu eikʉ'pʉ, “Ɨri ku'sa' iya pʉra iyesi yau, ina nʉnepʉi'no pen ɨyena',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Paire' uya ta'pʉ to' pɨ', “Atɨ' si iteseru aimenka kon pa main, Mosi' winon awɨrɨ,” ta'pʉ iya. Esuwerʉ amʉ' epuru ton uya ta'pʉ ipɨ', “Main, Mosi' winon pe pʉra rɨ iyesi ɨnʉ' rɨ tʉto' pe ina uya iyeri'to' ya',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Serɨ e'kupʉ'pʉ Sises uya ta'pʉ rʉ'pʉ uta'ku'tɨto' pe mɨrɨ kasa eri'to' oton ta'pʉ iya rʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Paire' kanan ewonkaa'pʉ tiwʉ' ta', mɨrɨpan uya Sises kɨ'ma'pʉ, mɨrɨpan uya ekama'po'pʉ, “Esuwerʉ amʉ' kin pe' ɨmɨrɨ?” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Sises uya imaimu eikʉ'pʉ, “Ɨmɨrɨ pe rɨ pe' serɨ mʉkayan, tʉron kon uya rɨ katɨ ayauro'kasa' upɨ'?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Paire' uya imaimu eikʉ'pʉ, “Esuwerʉ pe' urɨ? Ɨtonpa ton, use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru uya ɨtʉsa' uyena'. Ɨ'rɨ kupʉ'pʉ auya?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Sises uya imaimu eikʉ'pʉ, “Serɨ non po itesa' pe e'to' esi pen. Serɨ non po itesa' pe e'to' esi yau, upoitorʉ ton nepanta'mai'no Esuwerʉ amʉ' uya uya'si namai', e'tane serɨ po itesa' pe e'to' esi pen tʉron nɨ yau rɨ iyesi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Paire' uya ta'pʉ, “Kin pe ka'si ɨwesi wa!” ta'pʉ iya. Sises uya imaimu eikʉ'pʉ, “Ipoken nɨ ɨwesi, kin pe esi mʉkayai'ne'. I'nai rɨ, entu'pʉ serɨ wenai, serɨ pɨ' uyee'pʉ serɨ non pona, i'napairon ekamai'. Tanporon kon i'napairon winɨ na'ne' uya umaimu eta,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Paire' uya ta'pʉ ipɨ', “Ɨ'rɨ mɨrɨ i'napairon?” Serɨ ta pe, itɨ'pʉ kanan Esuwerʉ amʉ' piya'. Ta'pʉ iya to' pɨ', “Ɨ'rɨ imakooi eposa' uya pʉra man. ");
INSERT INTO akeNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","E'tane ɨyeseru kon esi tikin nɨ a'sisa' nonkato' pe Itepoi Itɨ'pʉ Weyu Rʉ'pʉ a'tai. Mɨrɨ wenai Esuwerʉ amʉ' kin ken pe' nonka uya ɨyena'nokon?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tʉukɨ'pɨ'nʉmʉ kon yau, “Kane, kʉrɨ rɨ pen. Parapas kuru!” ta'pʉ to' uya. Parapas esi'pʉ Roman kopʉnaai ewa'noma yau iye'sa' rʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Mɨrɨ a'tai, Paire' uya Sises anʉmʉ'pʉ, mɨrɨpan ari'po'pɨ'to' pe ikupʉ'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soisa amʉ' uya tikʉkena' e'mepɨtʉ'pʉ aro', kʉron pe, mɨrɨpan tʉrʉ'pʉ to' uya i'pai pona. To' uya ipontɨ'pʉ tʉtariren ya', ");
INSERT INTO akeNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","mɨrɨpan ekare pɨ' to' utɨpɨtʉ'pʉ, “Miyarɨ, Esuwerʉ amʉ' kin!” tapɨtʉi'ma. To' uya temiyatʉ kon ke iwɨnɨ'pʉ itemʉ' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Paire' epa'kakaa'pʉ kanan Esuwerʉ amʉ' pɨ' tase'na, “Apʉne entɨ', enpa'ka uya serɨ ɨyena'nokon i'tu kon pa ɨri pe iyesi tato' uya ipɨkɨrɨ pʉra rɨ iyesi,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Sises epa'kasa' a'tai, ɨmɨ'nɨ si e'mepɨ'sa' iyarʉkooi pe mɨrɨ awonsi'kɨ tʉtariren pe si ipon, Paire' uya si ta'pʉ to' pɨ', “Pʉse rɨ si!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ensa' tʉuya'nokon a'tai, use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru mɨrɨ awonsi'kɨ to' poitorʉ ton ukɨ'pɨ'nʉnpɨtʉ'pʉ, “Kurusu' pona ipokapɨ'tɨ'! Kurusu' pona ipokapɨ'tɨ'!” tukai'. E'tane Paire' uya to' eikʉ'pʉ, “Anʉntɨ', kurusu' pona ipokapɨtʉ kon pa. Urɨ nin, ɨri pe iyesi tato' uya ipɨkɨrɨ pʉra nin man,” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Esuwerʉ amʉ' uya ta'pʉ, “Main esanon ina, mɨrɨ awɨrɨ ima'tato' pe rɨ iyesi, apʉne pʉra Papa Mumu pe iye'kupʉ pɨ',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Paire' uya mɨrɨ etasa' a'tai, mɨrɨ uya rɨ miyarɨ rɨ enari'pa'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","mɨrɨpan enna'po'pʉ tiwʉ' ta', mɨrɨpan uya Sises ekama'po'pʉ, “Nai winɨpai ɨuye'sa'?” tukai', e'tane Sises uya eikʉ'pʉ pen. ");
INSERT INTO akeNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","“Uyauro'kapai pʉra si ɨwesi?” ta'pʉ iya ipɨ'. “I'tu auya pʉra pe' iyesi tʉmeruntɨrʉ ke esi ɨmo'kato' ike mɨrɨ pe pʉra kurusu' pona ɨpokapɨ'to' ike?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Sises uya eikʉ'pʉ, “Uyentai ɨmeruntɨrʉ pʉra iyesi ka'tapai ɨrepa'pʉ ike. Mɨrɨ pɨ' kʉrɨ ɨyena' utʉnin nʉ'pʉ umakoitasa' mɨrɨ eke pe kuru,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Mɨrɨ si'kɨrɨ, Paire' esi'pʉ Sises ɨnmo'kapai to' uya iwɨnɨ namai', e'tane Esuwerʉ amʉ' ukɨ'pɨ'nʉnpɨtʉ'pʉ, “Pʉse rɨ utɨto' pe iku'sa' auya yau, Sisa tonpa pe pʉra rɨ ɨwesi mɨrɨ. Ɨnʉ' rɨ kin pe ne'ku'ai'ne' esi mɨrɨ Sisa ewa'nomanin pe,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Serɨ etasa' tʉuya a'tai, Paire' uya Sises enpa'ka'pʉ, mɨrɨpan ereuta'pʉ eseru aimenkato' apon po, pata, Tɨ' Konekasa' tato' yau, (Arami' pe Kapa'ta tato' ipɨ'). ");
INSERT INTO akeNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Itepoi Itɨ'pʉ Weyu Rʉ'pʉ e'ma ta' ekonekan nɨto' pe iyesi'pʉ, pʉre'po'si e'to' a'tai rɨ, “Pʉse rɨ si kin, ɨiwano' kon,” ta'pʉ Paire' uya Esuwerʉ amʉ' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","E'tane to' ukɨ'pɨ'nʉnpɨtʉ'pʉ, “Atɨ'! Atɨ'! Kurusu' pona ipokapɨ'tɨ'!” ta'pʉ to' uya. “Kin pe' ɨiwano' kon pokapɨtʉ uya kurusu' pona?” ta'pʉ Paire' uya to' pɨ'. “Ina kin pʉra rɨ man, e'tane Sisa rɨken ina kin,” ta'pʉ use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru uya. ");
INSERT INTO akeNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Iye'nonka pe rɨ nin si, Paire' uya itʉrʉ'pʉ mɨrɨ to' ena' kurusu' pona to' uya ipokapɨ'to' pe. Soisa amʉ' uya nin si Sises a'sikaa'pʉ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tiwarɨ rɨ tʉkurusukuui arɨi'ma itɨ'pʉ Pu'pɨ Ɨ'pʉ Rʉ'pʉ pata'se' ya' (Arami' pe Korʉko'ta tato' ya'). ");
INSERT INTO akeNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Serɨ yau si kurusu' pona to' uya ipokapɨtʉ'pʉ mɨrɨ, asa'ron kon tʉron kon pokon pe, sen winɨ'ne Sises si to' aporo' po. ");
INSERT INTO akeNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Paire' uya ento' ipɨ' menukasa' esi'pʉ, mɨrɨpan tʉsa' iya esi'pʉ kurusu' pɨ', sises, nasare' pon esuwerʉ amʉ' kin, tawon. ");
INSERT INTO akeNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Tu'kan kon Esuwerʉ amʉ' uya serɨ tawon ene'pʉ, apʉne pʉra a'ko pe pata piyau Sises pokapɨ'sa' to' uya esi'pʉ, kurusu' pona ento' ipɨ' e'menukasa' esi'pʉ Arami' pe, Ra'ten pe, mɨrɨ awonsi'kɨ Kiri' pe. ");
INSERT INTO akeNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Esuwerʉ amʉ' use'mato', ɨpʉremato' tʉrawasomanin nan epuru ton eke ton kuru uya ta'pʉ Paire' pɨ', “‘Esuwerʉ Amʉ' Kin’ tukai' kʉ'menukai, e'tane pʉse rɨ e'kupʉ Esuwerʉ amʉ' kin pe, tukai' rɨken imenuka',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Paire' uya to' eikʉ'pʉ, “Imenukasa' uya na'ne' esi mɨrɨ, imenukasa' uya pe rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sises pokapɨ'sa' tʉuya'nokon a'tai kurusu' pona, soisa amʉ' uya ipon anʉmʉ'pʉ asakɨrɨ'ne tʉkaisarɨ'nokon to' uya ekamʉ'pʉ, iyo'non nɨken tʉnonkai'. Serɨ ipon esi'pʉ to'sa rɨ ika'sa' tikin nan nɨ inakapu ponsi'kɨ ipʉrakon pʉ'kʉ pona. ");
INSERT INTO akeNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","“Ikarapɨ'pai'nokon pʉra, apʉne tʉusi'tui' te'wapiya'kai' imo'kapai'nokon,” ta'pʉ to' uya. Serɨ e'kupʉ'pʉ iye'menukasa' itekare uta'ku'tɨto' pe, “To' uya tʉkaisarɨ'nokon upon ekamʉ'pʉ, mɨrɨ awonsi'kɨ tʉusi'tui' te'wapiya'kai' to' uya upon anʉmʉ'pʉ,” tawon. Mɨrɨ si kupʉ'pʉ soisa amʉ' uya mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Sises kurusukuui piyau isan e'soto'kasa' esi'pʉ, isan pasi Meri, Kʉro'pas no'pʉ, mɨrɨ awonsi'kɨ Meri Mataren. ");
INSERT INTO akeNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Mɨrɨ yau Sises uya tʉsan ensa' a'tai, mɨrɨ awonsi'kɨ tʉpoitorʉ tʉni'nʉnkanʉ e'soto'kasa' a'ko pe, ta'pʉ iya tʉsan pɨ', “Kʉrɨ rɨ si ɨmʉre,” ta'pʉ iya, ");
INSERT INTO akeNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","mɨrɨ awonsi'kɨ tʉpoitorʉ pɨ', “Kʉrɨ rɨ si asan,” ta'pʉ iya. Mɨrɨ a'tai rɨ, ipoitorʉ uya arɨ'pʉ tʉpata'se' ya'. ");
INSERT INTO akeNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Emennʉ'pʉ, tanporon nɨ enuka'sa' i'tu tʉuya pɨ', imenukasa' si itekare uta'ku'tɨto' pe, ta'pʉ mɨrɨ, “Tuna'kiri' ke e'ai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Moro iyesi'pʉ mɨrɨ yau wai yawon waain peneka, mɨrɨpan ka' su'pa tʉki'se, iyʉi i'so'pu ye' pɨ' to' uya inta na' itʉrʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Mɨrɨpan ku'kasa' tʉuya a'tai, Sises uya, “Nu'ma'tai si,” ta'pʉ. Mɨrɨ pe rɨ nin si, ti'pai tʉpeimai' ta'kwarʉ tʉrʉ'pʉ iya mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mɨrɨ si esi'pʉ mɨrɨ ekonekan weyu pe, mɨrɨ ema'sa' yawon Sapa' esi pɨ' eke pe kuru To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ pe. Apʉne pʉra Sapa' a'tai eke' amʉ' i'se pʉra tesi kon wenai kurusu' po'ne, Esuwerʉ amʉ' uya Paire' ekama'po'pʉ to' pisi ton i'kwɨ'pɨ'to' pe iku'to' pe iya, mɨrɨpan kon ekepu nu'tɨpɨ'to' pe kurusu' poi. ");
INSERT INTO akeNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Mɨrɨ pɨ' si soisa amʉ' uyee'pʉ wapiyaro' pisi ton i'kwɨ'pɨ'se'na Sises pokon pe kurusu' pona ipokapɨ'sa' rʉ'pʉ, mɨrɨ awonsi'kɨ si isakon pisi ton. ");
INSERT INTO akeNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","E'tane si Sises piya' to' uye'sa' a'tai, iyeri'ka'sa' pe to' uya ene'pʉ; mɨrɨ wenai, to' uya i'si ton i'kwɨ'pɨtʉ'pʉ pen. ");
INSERT INTO akeNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","E'tane nin, soisa amʉ' tonpa uya apuruka'pʉ iteire' airɨ suparari ke, mɨrɨpan yai mʉn mɨrɨ awonsi'kɨ tuna e'kwamʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ka'pon ennin nʉ'pʉ uya ekamasa', mɨrɨpan nekama'pʉ esi i'napai rɨ. I'tu iya i'napai rɨ tʉnekamanʉ esi tukai', ɨmɨrɨ rɨ nɨrɨ uya apurɨto' pe tʉkasimai' pʉra. ");
INSERT INTO akeNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Serɨ ton e'kupʉ'pʉ iye'menukasa' itekare uta'ku'tɨto' pe, “Tikin nɨ rɨ iyɨ'pʉ e'kwɨ'to' oton pen,” tawon, ");
INSERT INTO akeNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","mɨrɨ awonsi'kɨ tʉron nɨ kanan iye'menukasa', “Tʉnapuruka'pʉ kon enpɨ'to' oton to' uya,” tawon. ");
INSERT INTO akeNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Emennʉ'pʉ iwa rɨ, Isose', Arama'tiya pon uya Sises ekepu ekama'po'pʉ Paire' pɨ'. Isose' esi'pʉ Sises poitorʉ pe, e'tane ama'ai, apʉne pʉra Esuwerʉ amʉ' pɨ' tenari'nʉmʉ pɨ'. Paire' uya ewai' tasa' pɨ' iyee'pʉ Sises ekepu kan. ");
INSERT INTO akeNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nekutimas esi'pʉ isakon pe, pena iwa Sises piya' ewarupɨ nau itɨsa' rʉ'pʉ. Nekutimas uya karapa mɨrʉ isumasa' aro tato' pokon pe nee'pʉ, 75 pon e'to' airɨ rɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Asa' ipɨ' si esii'ma Sises ekepu asa' tʉuya'nokon ontɨ'pʉ to' uya mɨrɨ a'po'nan pokon pe, pon renen tato' atʉ saai'pɨ'sa' ke. Serɨ esi'pʉ mɨrɨ Esuwerʉ amʉ' uya tekepu kon u'na'tɨ eseru yau. ");
INSERT INTO akeNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Pata, Sises pokapɨtʉ'pʉ to' uya kurusu' pona na'ne' airɨ iyesi'pʉ umɨ, mɨrɨ umɨ yau emenna' pe tɨ' akasa' uruwai' pe esi'pʉ ɨnʉ' rɨ emaikasa' rʉ'pʉ pen nɨ ya'. ");
INSERT INTO akeNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Apʉne pʉra si Esuwerʉ amʉ' ekonekato' weyu pe iyesi pɨ', mɨrɨ awonsi'kɨ a'ko pe tɨ' akasa' uruwai' pe esi pɨ', mɨrɨ ya' Sises emaika'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Awanakʉi' kuru, suntaaka epiya'tɨ pe, ewarupɨ pe rɨ marɨ pata e'tane, Meri Mataren utɨ'pʉ tɨ' akasa' uruwai' pe pona, mɨrɨpan uya tɨ' utamasa' imʉra'taai apai ene'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mɨrɨpan eka'tunsa' utɨ'pʉ Saiman Pi'ta mɨrɨ awonsi'kɨ tʉron nɨ ipoitorʉ, kʉrɨ Sises ni'nʉnkanʉ piya', mɨrɨpan uya ta'pʉ, “To' uya Itepuru mo'ka'pʉ man tɨ' akasa' uruwai' pe apai, mɨrɨpan i'tu pʉra rɨ iyesi nai ya' rɨ nawon to' uya itʉrʉ'pʉ!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Mɨrɨ pɨ' si Pi'ta mɨrɨ awonsi'kɨ tʉron nɨ ipoitorʉ ton e'sara'tɨ'pʉ tɨ' akasa' uruwai' pe pona utɨn pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Asa'rɨ rɨ to' eka'tumʉ esi'pʉ, e'tane isakon uya Pi'ta entaka'pʉ, mɨrɨpan uya tɨ' akasa' uruwai' pe eporo'pʉ iwapiya. ");
INSERT INTO akeNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Te'tɨmuikai' tenu tʉpɨtʉ'pʉ iya pon renen atʉ saai'pɨ'sa' kusan pe ene'pʉ iya mɨrɨ yau, e'tane iyewomʉ'pʉ pen. ");
INSERT INTO akeNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","E'tane nin si Saiman Pi'ta, ite'ma'pʉ pe te'sen uyee'pʉ, mɨrɨpan ewomʉ'pʉ tɨ' akasa' uruwai' pe ya'. Pon saai'pɨ'sa' kusan pe renen tato' ene'pʉ iya mɨrɨ yau, ");
INSERT INTO akeNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","eke' on pe kanan te'sen Sises i'pai won nʉ'pʉ. Tʉpona rɨ e'mepɨ'sa' esi'pʉ, pon renen atʉ saai'pɨ'sa' kusan pe pokon pe pʉra. ");
INSERT INTO akeNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Mɨrɨ awonsi'kɨ nin si tʉron nɨ ipoitorʉ, tɨ' akasa' uruwai' pe eponin nʉ'pʉ wapiya, rɨ marɨ ewomʉ'pʉ. Mɨrɨpan uya tʉnene'pʉ apurɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(To' uya ito'ka'nʉkʉ pʉra rɨ marɨ iyesi'pʉ iye'menukasa' itekare Sises e'mʉ'sa'kato' oton terikʉ'pʉ apai, tawon.) ");
INSERT INTO akeNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Mɨrɨ a'tai, ipoitorʉ ton enna'po'pʉ tʉpata kon ya', ");
INSERT INTO akeNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","e'tane Meri, e'soto'kasa' esi'pʉ tɨ' akasa' uruwai' pe piyau ukaran nɨ pɨ'. Akaramʉi'ma te'tɨmuikai' tenu tʉpɨtʉ'pʉ iya tɨ' akasa' uruwai' pe ya', ");
INSERT INTO akeNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","mɨrɨpan uya asa'ron kon aimu'nan ipon ton inserʉ amʉ' ereutapɨ'sa' ene'pʉ, Sises ekepu pata'pʉ yau, i'pai pata'pʉ airɨ mɨrɨ awonsi'kɨ i'ta pata'pʉ airɨ isakon. ");
INSERT INTO akeNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","To' uya ekama'po'pʉ, “Ma'non, ɨ'rɨ pɨ' aukaramʉ?” ta'pʉ to' uya. “To' uya uyepuru arɨ'pʉ, nai ya' rɨ nawon to' uya itʉrʉ'pʉ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tai'ma iyera'tɨ'pʉ, mɨrɨpan uya Sises ene'pʉ iye'soto'kasa' mɨrɨ yau, e'tane Sises tukai' i'tu iya pʉra iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","“Ma'non, ɨ'rɨ pɨ' aukaramʉ? Ɨnʉ' warinpa auya?” ta'pʉ iya ipɨ'. Umɨ tʉrawasomanin pe rɨ nin si tekamai', “Apʉne ken, arɨ'pʉ auya pe iyesi yau, ekamakɨ nai ya' itʉrʉ'pʉ auya, ikan utɨto' pe,” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","“Meri,” ta'pʉ Sises uya ipɨ'. Iyera'tɨ'pʉ Sises winɨkʉi' ɨkɨ'pɨ'nʉmʉi'ma Arami' pe, “Raponai!” (Ti'sa ta e'kwa pe). ");
INSERT INTO akeNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Sises uya ta'pʉ, “Upɨ' kata'sii, apʉne pʉra enna'posa' pʉra rɨ marɨ man ikʉipʉnʉ piya'. E'tane, enta ru'ku uyakon non piya', to' pana'tɨi', ‘Utɨyai' ukʉipʉnʉ piya', mɨrɨ awonsi'kɨ ɨkʉipʉnʉ kon piya', itese' pɨ' e'to' piya', mɨrɨ awonsi'kɨ itese' pɨ' ɨwe'to' kon piya',’” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Meri Mataren nin si utɨ'pʉ mɨrɨ itekareei esa' pe ipoitorʉ ton piya', “Itepuru ene'pʉ uya,” ta'pʉ iya. Tauro'ka'pʉ iya ke to' pana'tɨ'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mɨrɨ rɨ suntaaka e'sara'tɨ ko'mamiri pe, a'samʉtʉ yau ipoitorʉ ton esi a'tai, mʉra'ta ta'kopɨ'se Esuwerʉ amʉ' pɨ' enari'ke' pe tesi kon pɨ', Sises uyee'pʉ, mɨrɨpan e'soto'ka'pʉ to' koro'tau, mɨrɨpan uya, “Miyarɨ'nokon!” ta'pʉ to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Serɨ ta tʉpo, temiyatʉ mɨrɨ awonsi'kɨ tʉteire' enpoika'pʉ iya to' ena'. Ipan pe rɨ ipoitorʉ ton epori'ma'pʉ itepuru ensa' tʉuya'nokon a'tai. ");
INSERT INTO akeNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Sises uya kanan takaa'pʉ to' pɨ', “Miyarɨ'nokon! Ikʉipʉnʉ uya uyenno'sa' na'ne' kasa rɨ, ɨyennoko uya 'nokon serɨ,” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Mɨrɨ tai'ma to' pona ise'netu'ka'pʉ, “Wakʉ A'kwarʉ anʉntɨ',” tai'ma. ");
INSERT INTO akeNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","“Ɨnʉ' makoi ton pɨ' rɨ ɨusentu'ma yau, ipɨ' rɨ usentu'man; mɨrɨ ton pɨ' ɨusentu'ma pʉra iyesi yau, mɨrɨ ton pɨ' rɨ usentu'man pʉra iyesi mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tamas nin si (Titimas tato' ipɨ'), 12 kaisaron kon tonpa pʉra iyesi'pʉ, tʉtonpa ton koro'tau Sises uye'sa' a'tai to' piya'. ");
INSERT INTO akeNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tʉron kon nin si ipoitorʉ ton uya, Itepuru ensa' tʉuya'nokon nʉ'pʉ ekama a'tai, ta'pʉ iya, “Tui' ɨ rʉ'pʉ itemiyatʉ pokon, mɨrɨpan ya' uyemiyatʉ tʉsa' uya a'tai, mɨrɨ awonsi'kɨ iteire' ya' uyemiyatʉ tʉsa' uya a'tai kuru nin apurɨ uya mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tikin nɨ suntaaka pata'pʉ pe, ipoitorʉ ton kanan esi'pʉ ɨutɨ tau, Tamas nin si esi'pʉ mɨrɨ to' piyau. Mʉra'ta rɨ uta'kosa' e'tane, Sises uyee'pʉ to' koro'ta' e'soto'kai', mɨrɨpan uya ta'pʉ, “Miyarɨ'nokon!” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Mɨrɨ a'tai, ta'pʉ iya Tamas pɨ', “Ɨyemiyatʉ itʉkɨ se ya'; uyemiyatʉ ton enkɨ. Ɨyemiyatʉ tɨnkai' uteire' ya' itʉkɨ. Ikasimato' auya tʉnonkai' apurɨkɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tamas uya ta'pʉ ipɨ', “Uyepuru mɨrɨ awonsi'kɨ Papa, itese' pɨ' e'to'!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Mɨrɨ a'tai, Sises uya ta'pʉ ipɨ', “Apʉne pʉra uyensa' auya pɨ', apurɨsa' auya; pori' pe kamo esi mɨrɨ ene tʉpo pʉra rɨ apurɨnin nan,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Sises uya tu'ke rɨ eke Papa tʉrawasooi ti'tuto' ipɨkɨrɨ kupʉ'pʉ tʉpoitorʉ ton uya entane, e'tane serɨ kareta pɨ' iye'menukasa' pʉra iyesi. ");
INSERT INTO akeNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","E'tane serɨ ton e'menukasa' apurɨ kon pa, Sises esi Kʉrai, Papa Mu, mɨrɨpan apurɨ auya'nokon winɨ ɨuko'manto' kon eporo kon pa itese' yau. ");
INSERT INTO akeNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Mɨrɨ pata'pʉ pe, Sises kanan usenpoikakaa'pʉ tʉpoitorʉ ton piya', Taipiriyas ku'pɨri piyau. Se kasa iyesi'pʉ: ");
INSERT INTO akeNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saiman Pi'ta, Tamas (Titimas tato' ipɨ'), Na'taniyerʉ, Kena, Kiyarari yawon winon; Sepiti munkɨ amʉ', mɨrɨ awonsi'kɨ asa'ron kon tʉron kon ipoitorʉ ton esi'pʉ a'samʉtʉ yau. ");
INSERT INTO akeNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","“E'saponka serɨ moro' amʉ' a'sii',” ta'pʉ Saiman Pi'ta uya to' pɨ', mɨrɨpan pɨ', “Aya'kɨrɨ ina utɨ serɨ,” ta'pʉ to' uya. Mɨrɨpan kon utɨsa' ekanwa'tɨpɨtʉ'pʉ kanau ya', e'tane mɨrɨ ewarupɨɨi tau, moro' amʉ' a'si'pʉ to' uya pen nɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Awanakʉi' kuru, Sises e'soto'kasa' esi'pʉ tuna e'pi po, e'tane ipoitorʉ ton uya ito'ka'nʉkʉ pʉra iyesi'pʉ Sises pe. ");
INSERT INTO akeNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","To' kɨ'pɨ'nʉnpa'pʉ iya, “Utonpa ton, moro' amʉ' pe' a'sisa' auya'nokon pʉra nai?” ta'pʉ iya. “Kane!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","“Ɨpunwerʉ kon eno'matɨ' kanau enwo'netʉ winɨkʉi'; mɨrɨ a'tai, to' rɨ eporo auya'nokon mɨrɨ,” ta'pʉ iya. To' uya iku'sa' a'tai, to' uya ipi'sikʉ poken pʉra rɨ to' punwerʉ esi'pʉ, apʉne pʉra tu'ke rɨ moro' amʉ' esi ke. ");
INSERT INTO akeNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mɨrɨ a'tai si, ipoitorʉ Sises ni'nʉnkanʉ uya Pi'ta pɨ', “Itepuru pe man!” ta'pʉ mɨrɨ. “Itepuru pe man,” ta iya etasa' tʉuya pe rɨ, Saiman Pi'ta uya tʉpon pʉro'pon e'me'pʉ tʉwoi (imo'kasa' iya esi'pʉ), mɨrɨpan e'sanʉmʉ'pʉ tuna ka'. ");
INSERT INTO akeNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Tʉron kon ipoitorʉ ton uya nin si e'ma'pʉka'pʉ mɨrɨ kanau yau, tu'kan kon moro' amʉ' en punwe tewa'tɨi' to' uya ipi'sikʉ'pʉ, apʉne pʉra ɨnnɨ kuru pʉra rɨ 300 pi' e'to' airɨ rɨ tuna e'pi piyapai tesi kon ke. ");
INSERT INTO akeNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","To' e'te'kasa' a'tai, enkena' pe apo' e'sɨmikasa' ene'pʉ to' uya moro' e'puru ipo, mɨrɨ awonsi'kɨ pʉreti esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Sises uya, “Moro' amʉ' si serɨ pe kuru ma'sitʉune' ɨnne'tɨ',” ta'pʉ mɨrɨ to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saiman Pi'ta ekanwa'tɨsa' uya nin si punwe pi'sikʉ'pʉ mɨrɨ makʉi'. Tu'ke rɨ, 153 kaisa rɨ eke ton moro' amʉ' esi'pʉ, e'tane punwe ekaraka pʉra rɨ iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Sises uya, “Ɨsi'tɨ', enta'natanʉ'tɨ',” ta'pʉ to' pɨ'. Ipoitorʉ ton uya, “Ɨnʉ' ɨmɨrɨ?” ta pʉra rɨ iyesi'pʉ ipɨ'. Itepuru pe to' uya i'tu'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Sises uyee'pʉ, pʉreti tanʉnse to' repa'pʉ iya, mɨrɨ kasa rɨ moro' ke to' repa'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Serɨ si serɨ itosorʉwano ite'kwa pe Sises usenpoika'pʉ tʉpoitorʉ ton ena', terikʉ tʉpo te'mʉ'sa'kasa' a'tai. ");
INSERT INTO akeNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Tenta'na kon e'nonkasa' a'tai, Sises uya ta'pʉ Saiman Pi'ta pɨ', “Saiman, Isaan mumu, ui'nʉnka auya kuru rɨ pe' pʉsamo entai?” ta'pʉ iya. “Ewai', uyepuru, ɨi'nʉnka uya rɨ i'tu auya,” ta'pʉ Pi'ta uya. Sises uya ta'pʉ ipɨ', “Uikʉn non karimeru munkɨ amʉ' ken si ewe'kɨ,” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Sises uya kanan takaa'pʉ ipɨ', “Saiman, Isaan mumu, ui'nʉnka auya kuru rɨ pe'?” ta'pʉ iya. Eikʉ'pʉ iya, “Ewai', uyepuru, ɨi'nʉnka uya rɨ i'tu auya,” ta'pʉ iya. Sises uya, “Uikʉn non ken si karimeru amʉ' ipa'simakɨ,” ta'pʉ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Itosorʉwano ite'kwa pe Sises uya ta'pʉ ipɨ', “Saiman, Isaan mumu, ui'nʉnkayan pe'?” ta'pʉ iya. Pi'ta ena'pʉ pokoi pe, apʉne pʉra Sises uya tekama'posa' pɨ' osorʉwau ite'kwa, “Ui'nʉnkayan pe'?” tukai', mɨrɨpan uya, “Uyepuru, tanporon nɨ i'tu auya; ɨi'nʉnka uya rɨ i'tu auya,” ta'pʉ. Sises uya, “Uikʉn non ken si karimeru amʉ' ewe'kɨ. ");
INSERT INTO akeNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","I'napairon ekama uya ɨpɨ'; moine pe iwa ɨwesi a'tai, ɨiwano' pe rɨ ɨyepontɨpɨtʉ'pʉ mɨrɨ awonsi'kɨ ɨutɨpɨtʉ'pʉ i'se ɨwe'to' ya'; e'tane ɨukɨɨi'pansa' a'tai, ɨyemiyatʉ ton ɨnka auya mɨrɨ awonsi'kɨ ka'pon uya nin si ɨpontɨ mɨrɨ, mɨrɨpan uya ayarɨ itɨpai ɨwe'to' pen nɨ ya',” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Sises uya serɨ ta'pʉ Pi'ta uma'tato' eseru ekama tʉuya pe Papa apurɨpɨ'to' ipɨ' pe, mɨrɨpan uya, “Upɨkɨrɨ ɨsi'kɨ!” ta'pʉ ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pi'ta uya tenu ra'tɨ'pʉ, mɨrɨpan uya ipoitorʉ, Sises ni'nʉnkanʉ uyepʉ tʉpɨkɨrɨ'nokon ene'pʉ. (Pʉse rɨ kʉrɨ rɨ Sises pona iye'tʉnkasa' rʉ'pʉ to' enta'na a'tai, “Uyepuru, ɨnʉ' uya si ɨyeparankato' oton?” tawon nʉ'pʉ.) ");
INSERT INTO akeNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pi'ta uya ensa' a'tai, ekama'po'pʉ iya, “Uyepuru, pʉse kanan si?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Sises uya eikʉ'pʉ, “Iko'mamʉ i'se esi yau enna'po pona rɨ, ɨ'rɨ pe mɨrɨ esi ɨpona? Ɨisirɨ, upɨkɨrɨ ɨsi'kɨ,” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Mɨrɨ si etasa' tʉuya'nokon tukai' itonpa ton esi'pʉ mɨrɨ, pʉse rɨ si ipoitorʉ erikʉ pʉra iye'to' oton, tukai'. E'tane Sises uya iyeri'to' oton pen tasa' pʉra iyesi; “Iko'mamʉ i'se esi yau enna'po pona rɨ, ɨ'rɨ pe mɨrɨ esi ɨpona?” tasa' iya rɨken esi. ");
INSERT INTO akeNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Pʉse rɨ si kʉrɨ rɨ ipoitorʉ ekama pɨ' na'ne' imenukasa' iya rɨ na'ne'. I'tu i'napai rɨ inekamanʉ esi. ");
INSERT INTO akeNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Sises uya tu'ke rɨ tʉron nɨ ton nɨ nɨrɨ kupʉ'pʉ. Tanporo rɨ iye'menukasa' pe iyesi yau, si'tuyai', serɨ non po imenukapɨ'sa' kareta ton pata pʉra iyesi.");
INSERT INTO akeNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Eke Tiyo'peras, wapiyaro' ukaretaai yau imenukasa' uya man, tanporon nɨ Sises nʉkupʉ'pʉ mɨrɨ awonsi'kɨ to' enupa'pʉ iya rʉ'pʉ ");
INSERT INTO akeNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","iyenuku pona rɨ Epʉn pona. Mɨrɨ rawɨrɨ, Papa meruntɨrʉ ke tʉuta'kwarʉ'tɨi', tʉneporo'san tʉnenno'ton kon pe itekare ekamai' apiyo'ma'pʉ iya tʉtʉrawasooi kon ku'to' pe to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Sises ekota'ma'pʉ, mɨrɨ awonsi'kɨ iyerikʉ'pʉ tʉpo kurusu' po, to' piya' isenpoikapɨtʉ'pʉ inke ite'kwa rɨ, to' uya te'mʉ'sa'kasa' apurɨto' pe. Inke rɨ to' piya' isenpoikapɨtʉ'pʉ 40 kaisa rɨ wʉi ton u'matʉ koro'tau terikʉ tʉpo te'mʉ'sa'kasa' a'tai, mɨrɨpan usaurokʉ'pʉ Papa e'to' esa' wannɨ pe pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tʉron nɨ a'tai to' piyau tesi koro'tau, to' auro'ka'pʉ iya, “Surusiran apai kʉtɨtʉu, e'tane ukʉipʉnʉ usauro'sa' rʉ'pʉ ipɨ' enupɨkɨrɨ me'tʉi' usaurokʉ rɨ metata'tʉine'nokon ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Isaan uya ka'pon amʉ' pa'taisimapɨtʉ'pʉ tuna ke, e'tane serɨ pe iwa'ne rɨ Papa uya apa'taisimapɨtʉ kon mɨrɨ Wakʉ Ta'kwarʉ ke,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Sises pokon pe kanan tamʉrasa' kon a'tai, to' uya ekama'po'pʉ, “Ina epuru, serɨ a'tai pe' urɨ'nokon Esuwerʉ amʉ' e'to' itesa' pe na'po auya serɨ?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Mɨrɨpan uya ta'pʉ to' pɨ', “Iweyu i'tuto' auya'nokon kuru pʉra rɨ iyesi. Ukʉipʉnʉ uya ikoneka mɨrɨ tʉweyu a'tai rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","E'tane Wakʉ A'kwarʉ uye'sa' a'tai ɨpona'nokon, meruntɨ pe ɨyena kon mɨrɨ, mɨrɨpan uyekareei ekama auya'nokon mɨrɨ Surusiran po, Isutiya po, Sameriya po, mɨrɨ awonsi'kɨ siya rɨ non emʉ' kaisa rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Serɨ ta'pʉ iya tʉpo, itanʉmʉ'pʉ to' enu airɨ rɨ, mɨrɨpan onamʉ'pʉ kapuru' uya to' enu apai. ");
INSERT INTO akeNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","To' esi'pʉ ka'ta' tenu kon tʉtʉse enpɨtʉ pɨ' iyenu'tane. Mɨrɨ koro'tau, ite'kwanau pʉra rɨ, asa'ron kon inserʉ amʉ' e'soto'kasa' esi'pʉ to' piyau. ");
INSERT INTO akeNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Ɨmɨrɨ'nokon, Kiyarari pon kon, ɨ'rɨ pɨ' serɨ yau ɨye'soto'pɨ'sa' kon uya ka'ta' ɨyenu kon tʉpɨtʉ? Pʉse rɨ Sises enuku menyatʉine' Epʉn pona uye'to' oton, itɨ ene'pʉ auya'nokon kasa rɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mɨrɨ tʉpo, enno'sa' kon enna'po'pʉ Surusiran pona Are' Wʉpʉ poi, ɨnnɨ kuru pʉra rɨ, 1 mayirʉ o'koi' rɨ pata pona. ");
INSERT INTO akeNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pata eposa' tʉuya'nokon a'tai, pata tʉto' tʉuya'nokon itau, ka'tawon ɨutɨ ta' to' utɨ'pʉ. Pʉsamoro iyamʉrasa' kon esi'pʉ; Pi'ta, Isaan, Isens, Anturu, Piri', Tamas, Pa'taramiu, Ma'siu, Isens (Arʉ'piyas mu), Saiman (Usera' tukai' tesa'sen), mɨrɨ awonsi'kɨ Isutas (tʉron nɨ Isens mu). ");
INSERT INTO akeNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","To' amʉrapɨtʉ'pʉ ɨsewenapai rɨ ɨpʉremai'. Uri'sami'si amʉ', Sises san Meri, mɨrɨ awonsi'kɨ Sises akon non esi'pʉ to' koro'tau. ");
INSERT INTO akeNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mɨrɨ a'tai, Pi'ta e'mʉ'sa'ka'pʉ tʉtonpa ton Sises apurɨnin nan koro'tau. 120 kaisaron kon esi'pʉ mɨrɨ yau. ");
INSERT INTO akeNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Utonpa ton, kin Tepi' poro Wakʉ A'kwarʉ usauro'sa' rʉ'pʉ Isutas pɨ' si uta'ku'tɨsa' man. Sises a'si ton kon anin pe iyena'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Isutas esi'pʉ anʉnsa' rʉ'pʉ ina tonpa pe itekare ekama pɨ' iye'tʉrawasomato' pe,” ta'pʉ Pi'ta uya. ");
INSERT INTO akeNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ɨri eseru ku'sa' tʉuya epe'pʉ ke Isutas uya non e'ma'pʉ, mɨrɨpan yau ita'mo'ka'pʉ, iye'toi'kwa'pʉ tʉwenu'pɨ takanʉ'se. ");
INSERT INTO akeNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tanporon kon Surusiran pon kon uya itekareei eta'pʉ, mɨrɨpan kon uya mɨrɨ non ese'tɨ'pʉ A'ketama tukai', Mʉn Pata'se' ta e'kwa pe.) ");
INSERT INTO akeNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Miyarɨ rɨ Pi'ta usaurokʉ'pʉ, “Iye'menukasa' man Eren yau, “‘Tɨwɨ itawon pʉra itiwʉ' nesii, ɨnʉ' rɨ kʉse'nin itau,’ mɨrɨ awonsi'kɨ, “‘Tɨwɨ tʉron nɨ itepuru pe te'ton ipata'pʉ anʉmʉi,’ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Mɨrɨ pe iyesi pɨ', Isutas pata'pʉ iyakan epopai'nokon, pena rɨ Sises a'tai uya'kɨrɨ'nokon iye'sa' rʉ'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Isaan uya epa'taisiman ekareei ekama'pʉ si'kɨrɨ mɨrɨ awonsi'kɨ Sises enuku pʉ'kʉ pona rɨ iye'sa' rʉ'pʉ, mɨrɨpan e'to' pe utonpa kon pe Sises e'mʉ'sa'kasa' ene'pʉ tʉuya ekamanin pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Mɨrɨpan kon uya asa'rɨ ka'pon amʉ' anʉmʉ'pʉ; Isose', Parʉsapas tukai' to' nesakʉnʉ, Isu'su'tas tato' to' uya ipɨ', mɨrɨ awonsi'kɨ Ma'tayas. ");
INSERT INTO akeNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Mɨrɨpan tanporo mɨrɨ yau te'san ɨpʉrema'pʉ, “Ina epuru, tanporon kon usenuminkato' i'tu auya. Apʉne ekamakɨ nai kʉrɨ rupɨ anʉnsa' auya pʉsamoro asa'ron kon ka'pon amʉ' apai ");
INSERT INTO akeNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","enno'sa' pe iye'to' pe, Isutas pata'pʉ iyakan pe. Isutas uya ina nonkasa' man tʉpata'se' ya' tʉutɨ pɨ',” tukai' to' ɨpʉrema'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","I'tun nɨto' ike ke to' i'tu'pʉ to' uya, mɨrɨpan i'ki'ma tane to' uya ita'mo'ka'pʉ Ma'tayas winɨkʉi', mɨrɨpan Ma'tayas ena'pʉ 11 pan kon enno'sa' kon tonpa pe. ");
INSERT INTO akeNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Penti'kas tato' weyu e'seposa' a'tai, tanporo Sises apurɨnin nan amʉrasa' esi'pʉ tikin nɨ ipata Surusiran po. ");
INSERT INTO akeNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mɨrɨ yau, ite'kwanau pʉra rɨ, pata a'merumʉ'pʉ, eke pe a'setun kasa, ka' winɨpai, mɨrɨpan ewomʉ'pʉ to' iwʉ' ta', ");
INSERT INTO akeNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","mɨrɨpan kon uya apo' waraino ene'pʉ, mɨrɨpan e'ta'nʉkʉ'pʉ to' kaisa rɨ to' i'pai pona'ne ereutai'. ");
INSERT INTO akeNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tanporo to' uta'kwarʉ'tɨ'pʉ Wakʉ A'kwarʉ ke, mɨrɨpan kon e'sara'tɨ'pʉ usauro'nɨ pɨ' tʉron kon ka'pon amʉ' maimu yau'ne, Iya'kwarʉ uya tʉusauro'to' kon pe tʉkupʉ kon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Mɨrɨ a'tai, Esuwerʉ amʉ' amʉrasa' esi'pʉ mɨ awɨrɨ'nan nɨ, pata emʉ' apaino kon Surusiran pona. ");
INSERT INTO akeNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pata a'merumʉ tetai', to' amʉra'pʉ Sises apurɨnin nan pata'se' ya'. To' usewansiuka'pʉ tʉmaimu kon tau'ne to' usaurokʉ eta tʉuya'nokon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ipan pe to' usewansiuka'pʉ, mɨrɨpan kon uya ta'pʉ, “Pʉsamoro nʉsauro'ai'ne' nan sa'ne Kiyarari ko' amʉ' ko! ");
INSERT INTO akeNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ɨ'rɨ kasa ken si umaimu kon tau'ne to' usaurokʉ eta serɨ? ");
INSERT INTO akeNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tʉron kon sa'ne uye'pɨ'sa' man ko, Pa'tiya winɨpai, Metiya winɨpai, mɨrɨ awonsi'kɨ Eran winɨpai, mɨrɨ awonsi'kɨ tʉron kon kanan Me'sa'po'temiya, Isutiya, Ka'pato'siya, Pontas, Eisa Mʉre'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","Pʉrekiya, Panperiya, Isi', Ripiya mɨrɨ awonsi'kɨ Ron piyaworo' nan nɨ uye'sa' man ko, Esuwerʉ amʉ' mɨrɨ awonsi'kɨ Esuwerʉ amʉ' pen e'tane, Esuwerʉ amʉ' napurɨnʉ apurɨnin nan. Tʉron kon kanan Kʉri' winɨpaino kon mɨrɨ awonsi'kɨ Arepiya winɨpaino kon, e'tane si umaimu kon tau'ne to' usaurokʉ eta'nokon, eke rɨ Papa nʉkupʉ'pʉ ekareei pɨ'!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tanporon kon usewansiuka'pʉ, i'tu tʉuya'nokon pʉra iyesi pɨ'. “Ɨ'rɨ ekamanin pe serɨ esi?” tukai' to' usekama'popɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","E'tane tʉron kon uta'kɨrɨ'pʉ to' pɨ' to' sapema pe rɨ. “To' e'taripasa' man,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Mɨrɨ a'tai, Pi'ta e'mʉ'sa'ka'pʉ 11 pan kon tʉtonpa ton pokon pe, anpisin ka'pon amʉ' koro'tau, mɨrɨpan usaurokʉ'pʉ eke pe, “Utonpa ton, Esuwerʉ amʉ' tʉron nɨ pata winɨ'nan mɨrɨ awonsi'kɨ Surusiran po tʉuko'mansan, apʉne etatɨ'! Ɨ'rɨ ta e'kwa pe serɨ e'ku'sa' tukai' ekama uya. ");
INSERT INTO akeNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ipoken pʉra rɨ ɨusenuminka kon ina e'taripasa' tukai'. Awanakʉi' rɨ marɨ pata man, 9 a'kʉra' rɨ marɨ. Ɨnʉ' e'taripa pʉra rɨ iyesi mɨrɨ a'tai. ");
INSERT INTO akeNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","E'tane pu'kena' Isowerʉ nekama'pʉ rʉ'pʉ uta'ku'tɨ serɨ, ");
INSERT INTO akeNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“‘Papa uya se kasa tasa': Se ton kupʉ uya mɨrɨ non weyu u'matʉ a'tai: Uya'kwarʉ enno'to' uya oton tanporon kon pona. Ɨmu kon mɨrɨ awonsi'kɨ ɨyensi kon amʉ' uya umaimu ekamato' oton, moineri'san enu uta'kwakasa' uya ento' oton, mɨrɨ awonsi'kɨ kɨɨyi' amʉ' e'ne'pɨ'to' oton. ");
INSERT INTO akeNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Mɨrɨ rɨken pe pʉra, upoitorʉ ton, warawoti'si amʉ' mɨrɨ awonsi'kɨ uri'sami'si amʉ' pona uya'kwarʉ enno'to' uya oton nɨ marɨ, mɨrɨpan kon uya umaimu ekamato' oton. ");
INSERT INTO akeNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","A'kwarʉpɨ'nin ku'to' uya oton ka' yau, mɨrɨ awonsi'kɨ i'tuto' ipɨ' non po kanan. Mɨrɨ a'tai, mɨrɨ yau mʉn e'to' oton, apo' mɨrɨ awonsi'kɨ ipun pe ikɨrɨsin e'to' oton. ");
INSERT INTO akeNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Wʉi enu ewarumanto' oton, mɨrɨ awonsi'kɨ kapʉi usuitato' oton mʉn kasa. Eke rɨ, mɨrɨ awonsi'kɨ wakʉ rɨ Itepuru Weyu uyepʉ rawɨrɨ tanporo serɨ ton e'ku'to' oton. ");
INSERT INTO akeNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ɨnʉ' rɨ kʉrɨ rɨ Itepuru ekama'ponin nʉ'pʉ tʉpika'tɨnin pe, epika'tɨto' oton tasa' iya,’ ta'pʉ rʉ'pʉ Isowerʉ uya. ");
INSERT INTO akeNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Ɨmɨrɨ'nokon Esuwerʉ amʉ', serɨ umaimu etatɨ'! Pʉse rɨ Sises, Nasare' pon, ɨ'koro'tau'nokon iyesi'pʉ Papa nennoko'pʉ. Tu'kan nɨ eke Papa tʉrawasooi, a'kwarʉpɨ'nin, mɨrɨ awonsi'kɨ i'tuto' ipɨkɨrɨ rɨ ku'to' pe iya ɨyena'nokon. Papa uya enpoika'pʉ ɨyena'nokon inkupʉnʉ winɨ, Papa nennoko'pʉ tukai' i'tu kon pa, mi'tuyatʉi'ne' kasa rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pena rɨ Papa uya iku'sa' esi'pʉ ɨyena'nokon itʉto' pe tʉuya, mɨrɨpan tʉrʉ'pʉ auya'nokon ɨri ton ena' to' uya kurusu' pona ipokapɨ'to' pe, iyeri'to' pe. ");
INSERT INTO akeNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","E'tane Papa uya i'mʉ'sa'ka'pʉ eri'nɨto' meruntɨrʉ apai, eri'nɨto' uya a'sisa' ko'manʉkʉ namai'. ");
INSERT INTO akeNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Pena Tepi' uya Itepuru maimu ekama'pʉ, “‘Papa, Itepuru ene uya inke rɨ upiyau. Mɨrɨ uriya', usi'nʉkʉ pen. ");
INSERT INTO akeNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Mɨrɨ pe iyesi pɨ', pori' pe uyewan yau esii'ma, uyesen uya epori'mato' enpoika. Ayapurɨ uya, Papa, eri'sa' rɨ e'tane, upun uko'mamʉ te'ku'to' yau, ");
INSERT INTO akeNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","apʉne pʉra uruwai' yau esi i'se pʉra ɨwesi pɨ', mɨrɨ awonsi'kɨ wakʉ, urɨ ɨpoitorʉ ukɨta i'se pʉra ɨwesi. ");
INSERT INTO akeNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ɨko'manse'na utɨto' e'ma enpoikasa' auya man; pori' pe uku'to' auya oton, apʉne pʉra tɨwɨ rɨ upiyau ɨwesi pɨ',’ ta'pʉ Tepi' uya,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pi'ta usaurokʉ'pʉ tɨpiyɨ'se pʉra, “Utonpa ton, eke utamokori kon Tepi' erikʉ'pʉ, mɨrɨpan uruwasii esi serɨ pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tepi' esi'pʉ pu'kena', mɨrɨpan uya Papa uya, ‘Ikupʉ uya kuru rɨ mɨrɨ,’ tukai' tauro'ka'pʉ rʉ'pʉ si i'tu'pʉ: tikin nɨ ipayan amʉ' tonpa ku'to' oton Papa uya itepuru pe, Papa munkɨ amʉ' esa' pe, Tepi' esi'pʉ to' esa' pe kasa, tawon. ");
INSERT INTO akeNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Mɨrɨ pe iyesi pɨ', Tepi' uya nin si Kʉrai e'mʉ'sa'kato' oton i'tusa' tʉuya pɨ' ekama'pʉ, uruwai' yau iko'manto' oton pen nɨ, mɨrɨ awonsi'kɨ ipun ukɨta pen nɨ, tukai'. ");
INSERT INTO akeNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Pʉse rɨ Sises, iyeri'sa' rʉ'pʉ i'mʉ'sa'ka'pʉ Papa uya. Ina si iya'kɨron kon nʉ'san uya iye'mʉ'sa'kasa' ene'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Papa uya eke pe kuru ikupʉ'pʉ, mɨrɨpan ereutanʉ'sa' iya tenwo'netʉ winɨ, mɨrɨpan uya apiyo'ma'pʉ ta'kwarʉ enno'to' pe iya tʉpoitorʉ ton pona, tʉusaurokʉ'pʉ awɨrɨ rɨ. Sises uya si eke pe kuru rɨ ina repasa' Wakʉ A'kwarʉ ke menyatʉi'ne' mɨrɨ awonsi'kɨ metayatʉi'ne'. ");
INSERT INTO akeNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tepi' enu'sa' pʉra iyesi tʉpun yau Epʉn pona, e'tane Tepi' uya ta'pʉ, “‘Itepuru uya ta'pʉ uyepuru pɨ'; “Uyenwo'netʉ winɨkʉi' ereutatanʉ'kɨ Itepuru pe ɨwesi pa, ");
INSERT INTO akeNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","apʉne ɨyeyaton non entai ɨwesi pa ɨku'tane uya to' esa' pe ɨwesi pa,”’ tasa'. ");
INSERT INTO akeNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Ɨmɨrɨ'nokon mɨrɨ awonsi'kɨ tanporo rɨ Esuwerʉ amʉ' uya i'tu i'se esi i'napai rɨ kuru iyesi tukai': Pʉse rɨ si Sises ɨnwɨnɨ'pʉ kon ku'sa' Papa uya man Itepuru pe mɨrɨ awonsi'kɨ Kʉrai pe,” ta'pʉ Pi'ta uya. ");
INSERT INTO akeNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ka'pon amʉ' uya serɨ etasa' a'tai, ipan pe to' ewan poka'pʉ iya, mɨrɨpan kon uya Pi'ta mɨrɨ awonsi'kɨ itonpa ton ekama'po'pʉ, “Ina tonpa ton, ɨ'rɨ ken si kupʉ ina uya serɨ?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pi'ta uya to' maimu eikʉ'pʉ, “Ɨmɨrɨ'nokon tikin pa'ne me'atʉi'ne' kaisa rɨ amakooi kon apai era'tɨtɨ', ina uya apa'taisimato' kon pe Sises ese' yau amakooi kon pɨ' usentu'man nɨto' pe, mɨrɨpan uya Wakʉ A'kwarʉ ke ɨrepa kon mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Papa uya tʉusaurokʉ'pʉ kupʉ mɨrɨ ɨpɨ'nokon, apayan kon nʉ'san pɨ', mɨrɨ awonsi'kɨ sunwaron kon pɨ' nɨrɨ, tanporon kon Itepuru, itese' pɨ' e'nɨto' Papa nʉkɨ'manʉ ton pɨ' rɨ nɨrɨ,” ta'pʉ Pi'ta uya. ");
INSERT INTO akeNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Miyarɨ rɨ Pi'ta usaurokʉ'pʉ to' emiya'pontɨnin pe, “Epika'tɨtɨ' ɨri ton serɨ a'taino kon piyapai,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pi'ta maimu apurɨnin nʉ'san pa'taisima'pʉ enno'sa' kon uya, mɨrɨpan 3,000 kaisaron kon ena'pʉ to' tonpa pe. ");
INSERT INTO akeNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Inke rɨ tenupato' kon awɨrɨ kuru rɨ to' e'pɨtʉ'pʉ, tʉusi'nʉnka kon ke to' amʉrapɨtʉ'pʉ, to' uta're'tɨpɨtʉ'pʉ mɨrɨ awonsi'kɨ to' ɨpʉremapɨtʉ'pʉ a'samʉtʉ yau. ");
INSERT INTO akeNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tu'ke rɨ a'kwarʉpɨ'nin mɨrɨ awonsi'kɨ i'tuto' ipɨkɨrɨ kupʉ'pʉ enno'sa' kon uya, mɨrɨpan pɨ' tanporon kon enari'nʉmʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tanporo Sises apurɨnin nan amʉrapɨtʉ'pʉ a'samʉtʉ yau, mɨrɨpan kon e'repapɨtʉ'pʉ tanporon ke rɨ tʉtonpa kon pokon pe, ");
INSERT INTO akeNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","mɨrɨpan kon uya tʉnono kon mɨrɨ awonsi'kɨ timamin kon tonpa kʉrʉpo'pomapɨtʉ'pʉ. Mɨrɨ epe'pʉ ke tʉtonpa kon repapɨtʉ'pʉ to' uya i'se iye'to' airɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Wʉi kaisa rɨ to' amʉrapɨtʉ'pʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' pʉ'kʉ ta', tanporo tamʉrapɨ'se to' uta're'tɨpɨtʉ'pʉ tiwʉ' kon tau'ne pori' pe, amʉre' pe pʉra to' usekanpɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Papa apurɨpɨtʉ pɨ' to' esi'pʉ, mɨrɨpan tʉron kon ka'pon amʉ' esi'pʉ pori' pe to' pɨ'. Wʉi kaisa rɨ Itepuru uya tʉnkoneka'san ke to' tonpa'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tʉron nɨ wʉi a'tai, Pi'ta mɨrɨ awonsi'kɨ Isaan pokon utɨ'pʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' ta' ɨpʉreman weyu a'tai, ko'mamʉ pe, 3 a'kʉra'. ");
INSERT INTO akeNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mɨrɨ yau, ka'pon esi'pʉ ise'mesa' iyentu'pʉ si'kɨron nɨ to' napɨtʉnʉ “Akorʉwan Mʉra'ta” tukai' to' nesakʉnʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' pʉrorooi mʉra'ta na'. Mɨrɨ yau, to' uya inonkapɨtʉ'pʉ tʉpʉrataai oton ekama'poto' pe iya ka'pon amʉ' tewonsan pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pi'ta mɨrɨ awonsi'kɨ Isaan pokon ewontane tʉpʉrataai oton pɨ' to' ekama'po'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pi'ta mɨrɨ awonsi'kɨ Isaan uya to'sa rɨ ene'pʉ. “Apʉne, ina enkɨ,” ta'pʉ Pi'ta uya ipɨ', ");
INSERT INTO akeNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","mɨrɨpan kon ene'pʉ iya, pʉrata ke to' uya tʉrepa tukai'. ");
INSERT INTO akeNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pi'ta uya ta'pʉ, “Pʉrata pʉra man, e'tane itesa' pe rɨ e'ai'ne' ke ɨrepa uya: Sises Kʉrai Nasare' pon ese' yau, e'mʉ'sa'ka', mɨrɨ awonsi'kɨ asakɨ,” ta'pʉ iya ise'mesa' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Itenwo'netʉ winɨ itemekon a'si'pʉ iya iye'mʉ'sa'ka tane, mɨrɨpan i'ta ton mɨrɨ awonsi'kɨ ipʉrakon amʉ' ena'pʉ pana' pe inke pʉra rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Mɨrɨpan e'sanʉmʉ'pʉ iye'sara'tɨ'pʉ usarɨn pɨ'. To' a'kɨrɨ iyewomʉ'pʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' ta', iye'sanʉnpɨtʉ'pʉ Papa apurɨpɨtʉ pe. ");
INSERT INTO akeNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tanporo ka'pon amʉ' mɨrɨ yau te'san uya isarɨ ene'pʉ Papa apurɨpɨtʉ pɨ', ");
INSERT INTO akeNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","mɨrɨpan kʉrɨ rɨ teta'kwanʉnsen tukai' to' ni'tunʉ Akorʉwan Mʉra'ta tato' yau Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' mʉra'ta nau te'sen pe ti'tuse, ipan pe to' usewansiuka'pʉ, iye'ku'sa' na'ne' ipɨ' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Pʉse rɨ si ka'pon uta'sisa' esi'pʉ Pi'ta mɨrɨ awonsi'kɨ Isaan pokon pɨ', mɨrɨpan ka'pon amʉ' usewansiukasa' eka'tumʉ'pʉ to' piya' Saraman Epa'kato' Iya' tato' ya'. ");
INSERT INTO akeNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ka'pon amʉ' ensa' Pi'ta uya a'tai, ta'pʉ iya to' pɨ', “Utonpa ton, Esuwerʉ amʉ', ɨ'rɨ pe iyesi pɨ' ɨusewansiukasa' kon serɨ pɨ'? Ɨ'rɨ pe iyesi pɨ' ina enpɨtʉ auya'nokon? Tʉmeruntɨrʉ kon ke mɨrɨ awonsi'kɨ Papa pori'manin nan pe tesi kon pɨ' ina uya epi'tɨsa' pen mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Utamokori kon amʉ' Epʉra'an, Aisi', mɨrɨ awonsi'kɨ Seko' e'to' itese' pɨ' Papa uya tʉpoitorʉ Sises ku'sa' eke pe, mɨrɨpan Paire' piya' inee'pʉ auya'nokon iwɨto' pe iya. Inonka tane iya rɨ, ‘Sises i'se pʉra ina man,’ ta'pʉ auya'nokon Paire' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Sises esi'pʉ wakʉ, ipokena' rɨ e'tane, ‘I'se pʉra ina man,’ ta'pʉ auya'nokon. Sises ɨnnonkapai Paire' esi'pʉ, e'tane ka'pon amʉ' wɨpɨ'nin nʉ'pʉ enna'pʉ auya'nokon inonkato' pe iya. ");
INSERT INTO akeNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Inke ka'pon amʉ' uko'manto' sara'tɨnin nʉ'pʉ wɨnɨ'pʉ auya'nokon e'tane, Papa uya i'mʉ'sa'ka'pʉ iyeri'sa' apai. Ina esi serɨ ennin nʉ'san pe mɨrɨ awonsi'kɨ ekamanin nan pe. ");
INSERT INTO akeNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ina mɨrɨ awonsi'kɨ pʉse rɨ ka'pon uya Sises apurɨ uriya' pʉse rɨ e'mʉ'sa'kasa' pana' pe. Sises apurɨ ina uya uriya', pʉse rɨ ise'mesa' usepi'tɨsa' tanporon kon pe menyatʉi'ne'. ");
INSERT INTO akeNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ɨmɨrɨ'nokon mɨrɨ awonsi'kɨ itepuru ton uya serɨ kupʉ'pʉ Sises pɨ' ɨnkupʉnʉ kon i'tu auya'nokon pʉra iyesi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","E'tane pʉra rɨ, Papa uya pu'kena' amʉ' auro'kasa' rʉ'pʉ pena rɨ awɨrɨ serɨ e'kupʉ'pʉ, pʉse rɨ Kʉrai ekota'mato' oton tawon. ");
INSERT INTO akeNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mɨrɨ pe iyesi pɨ', amakooi kon inonkatɨ', Papa winɨkʉi' era'tɨtɨ'. Mɨrɨ a'tai, Papa usentu'ma ɨpɨ'nokon uya tanporo amakooi kon korʉkato' pe. Mɨrɨ a'tai, wakʉ pe rɨ Papa uya ɨmeruntɨtanʉkʉ kon mɨrɨ, ");
INSERT INTO akeNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","mɨrɨ awonsi'kɨ Kʉrai, Papa Nanʉmʉ'pʉ ennoko iya mɨrɨ—Sises rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pʉse rɨ Sises si e'to' oton Epʉn po Papa uya tanporon koneka emenna' pe pona rɨ, pena rɨ tʉusaurokʉ'pʉ kasa wakʉ ton pu'kena' amʉ' yai. ");
INSERT INTO akeNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Apʉne pʉra Mosi' uya ekama'pʉ, ‘Papa, Itepuru uya pu'kena', uwaraino anʉnto' oton ɨtonpa kon nɨ. Tanporon inekamanʉ main awɨrɨ me'tʉi'. ");
INSERT INTO akeNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kʉrɨ rɨ si pu'kena' maimu awɨron pen esi a'tai, Papa uya ima'tanʉ'to' oton tʉmunkɨ amʉ' koro'tapai,’” ta'pʉ Pi'ta uya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Miyarɨ rɨ Pi'ta usaurokʉ'pʉ, “Serɨ pe si ne'ku'ai'ne' esi penaro' rɨ tanporon kon pu'kena' amʉ' nekama'pʉ Sanwerʉ esi'pʉ si'kɨrɨ rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Papa uya ta'pʉ rʉ'pʉ atamokori kon pɨ' pu'kena' amʉ' awɨrɨ tʉnku'ton kuru pɨ'. To' uya si eporo'pʉ, ɨmɨrɨ'nokon uya rɨ nɨrɨ kanan eporo. Epʉra'an auro'ka'pʉ Papa uya i'tutɨ': ‘Tanporon kon ka'pon amʉ' pʉrema uya mɨrɨ apayan nʉ'san poro,’ tasa' iya rʉ'pʉ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Te'nonka pe, Pi'ta uya ta'pʉ, “Papa uya, tʉron kon piya' ennoko tʉuya wapiya kuru, tʉni'mʉ'sa'ka'pʉ, tʉpoitorʉ ennoko'pʉ ɨpiya'nokon, ɨpʉrema kon pe, ɨri ɨyeseru kon tʉnonkai' ɨwesi kon pa,” ta'pʉ Pi'ta uya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Papa ena' use'man nɨto' tʉrawasomanin nan, Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' erasu ton epuru, mɨrɨ awonsi'kɨ Satu'si amʉ' uyee'pʉ, Pi'ta mɨrɨ awonsi'kɨ Isaan pokon nɨ marɨ usaurokʉ koro'tau. ");
INSERT INTO akeNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Mɨrɨ a'tai, to' usakorota'pʉ se kasa iyesi pɨ', asa'ron kon enno'sa' kon uya ka'pon amʉ' enupa esi'pʉ Sises e'mʉ'sa'ka'pʉ pɨ' teri'sa' apai. Serɨ enta', iyeri'sa' kon e'mʉ'sa'ka ekamanin pe. ");
INSERT INTO akeNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Pi'ta mɨrɨ awonsi'kɨ Isaan a'si'pʉ to' uya pariki'si ta'; pata uko'mansa' pɨ', tʉron nɨ wʉi emakʉ pʉ'kʉ pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","E'tane tu'kan kon ka'pon amʉ' uya itekare etaka'sa' esi'pʉ, mɨrɨpan kon uya apurɨ'pʉ, mɨrɨpan kon e'tonpa'tɨsa' esi'pʉ 5,000 kaisa rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Mɨrɨ ema'sa' yau, Esuwerʉ amʉ' epuru ton mɨrɨ awonsi'kɨ Main pɨ' enupanin nan amʉra'pʉ Surusiran pona. ");
INSERT INTO akeNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Mɨrɨ yau, Anas, Papa ena' use'man nɨto' tʉrawasomanin nan epuru pe te'sen esi'pʉ, Kaya'pas a'kɨrɨ te'san, Isaan, Arisanta mɨrɨ awonsi'kɨ tʉron kon nɨ esi'pʉ itepuru tonpa ton pe te'san. ");
INSERT INTO akeNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tʉpiya'nokon Pi'ta mɨrɨ awonsi'kɨ Isaan nepʉ'pʉ to' uya to' ekama'popɨ'to' pe tʉuya'nokon, “Nai kasa ikupʉ'pʉ auya'nokon? Ɨnʉ' meruntɨrʉ yau, ɨnʉ' ese' yau ikupʉ'pʉ auya'nokon?” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Mɨrɨ a'tai, Pi'ta, uta'kwarʉ'tɨsa' Wakʉ A'kwarʉ ke uya ta'pʉ to' pɨ', “Eke ton ka'pon amʉ' epuru ton, ");
INSERT INTO akeNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","serɨ pe ina ekama'po auya'nokon ise'mesa' epi'tɨsa' ina uya pɨ', ɨ'rɨ kasa isepi'tɨsa' tukai'. ");
INSERT INTO akeNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Serɨ i'tutɨ' ɨmiyamoro ka'pon amʉ' Esuwerʉ amʉ'; Nasare' pon, Sises ese' uya pʉse rɨ warawo' epi'tɨsa' e'mʉ'sa'kasa' esi ɨpiyau'nokon. Ɨnpokapɨtʉ'pʉ kon kurusu' pona iyeri'to' pe i'mʉ'sa'kasa' Papa uya. ");
INSERT INTO akeNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Papa Maimu uya tasa' na'ne' Sises pɨ', “‘Serɨ tɨ' ɨmɨrɨ'nokon amɨnin nan newaruma'tɨ'pʉ enasa' man amɨnin nan uya amɨto' apon pe kuru,’ tasa'. ");
INSERT INTO akeNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Makooi apai epika'tɨn nɨto' e'seposa' Sises poro rɨken, tanporo serɨ non po ɨnʉ' rɨ Papa nʉtʉrʉ'pʉ pika'tɨnin wannɨ pe pʉra rɨ iyesi mɨrɨ,” ta'pʉ Pi'ta uya. ");
INSERT INTO akeNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Itepuru ton usewansiuka'pʉ, ɨpiyɨ'ke' pe pʉra Pi'ta mɨrɨ awonsi'kɨ Isaan ene tʉuya'nokon pɨ' sepa' nan nɨ mɨrɨ awonsi'kɨ isenupasa' kon pen nɨ, e'tane to' uya to' to'ka'nʉkʉ'pʉ Sises a'kɨron kon nʉ'san pe. ");
INSERT INTO akeNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","E'tane si ka'pon to' nepi'tɨ'pʉ e'mʉ'sa'kasa' ene'pʉ to' uya to' piyau. Mɨrɨ a'tai, ɨ'rɨ rɨ tato' to' uya pʉra iyesi'pʉ Pi'ta mɨrɨ awonsi'kɨ Isaan pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Konsʉrʉ amʉ' uya to' enpa'ka'pʉ tiwʉ' kon tapai, mɨrɨpan kon e'sara'tɨ'pʉ usauro'nɨ pɨ' tʉtonpa kon amʉ' pokon pe, ");
INSERT INTO akeNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Ɨ'rɨ pe to' kupʉ serɨ, tanporon kon Surusiran po tʉuko'mansan uya rɨ tanporo to' nʉkupʉ'pʉ i'tu, mɨrɨpan wapu'tɨ poken pʉra iyesi. ");
INSERT INTO akeNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","E'tane serɨ ereutanʉ'pai iyesi iye'ta'nʉ'kapʉ wapiya ka'pon amʉ' koro'tawɨrɨ. To' enari'papai'nokon, mɨrɨ entakasa' auya'nokon a'tai ɨkota'ma kon mɨrɨ tukai',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Mɨrɨ a'tai, to' kanan kɨ'makaa'pʉ to' uya. Ta'pʉ to' uya to' pɨ', “Serɨ tʉpo ɨnʉ' rɨ kʉsauro'katʉu, kʉsenupatʉu Sises ese' pɨ',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","E'tane Pi'ta mɨrɨ awonsi'kɨ Isaan pokon uya to' maimu eikʉ'pʉ, “Ɨmɨrɨ'nokon pe i'tutɨ', ipoken pe' ɨwesi kon Papa enu yau, amaimu kon awɨrɨ e'nɨ yau Papa Maimu tentakai'? ");
INSERT INTO akeNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ina e'pakapʉ poken pʉra man ina nene'pʉ ton, mɨrɨ awonsi'kɨ ina neta'pʉ ekamato' tʉuya'nokon piyapai,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ipan pe to' enari'pa tʉuya'nokon tʉpo, Konsʉrʉ amʉ' uya to' nonka'pʉ. Nai kasa to' kota'mato' tʉuya'nokon tukai' to' uya i'tu pʉra rɨ iyesi'pʉ, apʉne pʉra tanporon kon uya rɨ Papa apurɨpɨtʉ pɨ' iye'ku'sa' rʉ'pʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Warawo' isepi'tɨsa' na'ne' esi'pʉ 40 kaisaron entaino rɨ iwʉipiyaai. ");
INSERT INTO akeNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tʉnonkasa' kon a'tai, Pi'ta mɨrɨ awonsi'kɨ Isaan enna'po'pʉ tʉtonpa kon amʉ' koro'ta', ekamase'na tanporon nɨ use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru mɨrɨ awonsi'kɨ itepuru ton uya ta'pʉ tʉpɨ'nokon nʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Serɨ etasa' tʉuya'nokon a'tai, to' ɨpʉrema'pʉ ɨsewan ya' tenai' Papa pɨ'. “Itepuru, Ɨmɨrɨ nʉkoneka'pʉ Epʉn mɨrɨ awonsi'kɨ non mɨrɨ awonsi'kɨ parau mɨrɨ awonsi'kɨ tanporon nɨ mɨrɨ yawon. ");
INSERT INTO akeNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ausaurokʉ'pʉ Wakʉ A'kwarʉ awɨrɨ ina tamokori, ɨpoitorʉ Tepi' poro rɨ, se kasa tukai': “‘Ɨ'rɨ pɨ' Esuwerʉ amʉ' pen usakorota; ɨ'rɨ pɨ' ka'pon amʉ' e'kama, epoton kon kasa rɨ? ");
INSERT INTO akeNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kin amʉ' e'kama, mɨrɨ awonsi'kɨ non esanon nɨ amʉra ɨsipokon pe, Papa, Itepuru mɨrɨ awonsi'kɨ inanʉmʉ'pʉ, Kʉrai ewa'nomase'na,’ tukai'. ");
INSERT INTO akeNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","I'napai rɨ Era' mɨrɨ awonsi'kɨ kopʉna Ponsiyas Paire' pokon amʉra'pʉ Esuwerʉ amʉ' pen ka'pon amʉ' Esuwerʉ pon kon pokon pe serɨ pata yau, wakʉ ayapiyo' Sises ananʉmʉ'pʉ ewa'noma pɨ' te'to' kon pe ekonekai'. ");
INSERT INTO akeNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","To' amʉrasa' tanporon nɨ ɨmeruntɨrʉ mɨrɨ awonsi'kɨ ɨyeseru awɨrɨ iye'ku'to' pe ɨnkupʉ'pʉ ku'se'na. ");
INSERT INTO akeNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Mɨrɨpan, serɨ pe si enkɨ, Papa: ina enari'pa to' uya; ina, ɨpoitorʉ ton iku'kɨ wakʉ pe, tepiyɨ'se pʉra amaimu ekamato' pe ina uya. ");
INSERT INTO akeNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ɨyemiyatʉ tɨnkai' rɨ usepi'tɨn iku'kɨ, tɨwɨ i'tuto' ipɨkɨrɨ mɨrɨ awonsi'kɨ a'kwarʉpɨ'nin nɨrɨ iku'kɨ, wakʉ ɨpoitorʉ Sises ese' yau,” tukai' to' ɨpʉrema'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tʉwɨpʉrema kon tʉpo, to' e'nonkasa' a'tai, to' e'to' yau usi'ki'ma'pʉ. Tanporo to' uta'kwarʉ'tɨ'pʉ Wakʉ A'kwarʉ ke, mɨrɨpan kon uya Papa Maimu ekama'pʉ tepiyɨ'se pʉra. ");
INSERT INTO akeNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Sises apurɨnin nan esi'pʉ tikin nɨ rɨ isenuminkato', tikin nɨ rɨ itewan. Ɨnʉ' uya rɨ uiwano' serɨ ta pʉra rɨ, e'tane tiwano' kon ke rɨ te'repasan pe to' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Meruntɨ pe kuru esii'ma enno'sa' kon uya Itepuru Sises e'mʉ'sa'ka'pʉ terikʉ'pʉ apai ekama'pʉ, mɨrɨpan kon pona eke pe rɨ wakʉ nonkasa' tanporo to' pona. ");
INSERT INTO akeNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ɨnʉ' rɨ tekota'masen kuru rɨ pʉra iyesi'pʉ to' koro'tau, kamoro tʉmainarʉ ke, tiwʉ' ke rɨ te'san uya ikʉrʉpo'pomapɨtʉ'pʉ, mɨrɨpan epe'pʉ rʉ'pʉ ne'pɨtʉ'pʉ to' uya ");
INSERT INTO akeNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","enno'sa' kon ena', mɨrɨpan ekanpɨtʉ'pʉ to' uya to' kaisa rɨ ipʉra kuru to' esi pɨ' tense. ");
INSERT INTO akeNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Mɨrɨ kasa si, Isose' esi'pʉ mɨrɨ, Ripai pa rʉ'pʉ pe te'sen, Sai'pʉras po iyentusa' rʉ'pʉ, Panapas tukai' enno'sa' kon nesakʉnʉ (Pori'mapɨ'nin ta e'kwa pe). ");
INSERT INTO akeNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Tʉmainarʉ kʉrʉpo'poma'pʉ iya, mɨrɨpan epe'pʉ nee'pʉ iya enno'sa' kon ena'. ");
INSERT INTO akeNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ananayas, ino'pʉ Sa'paira uya kanan tʉnono kon kʉrʉpo'poma'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Itepe'pʉ tonpa'ka'pʉ to' uya tʉno'pʉ ya' rɨ esii'ma tiwano' kon pe iye'to' pe, mɨrɨpan tonpa'pʉ nee'pʉ iya enno'sa' kon ena'. ");
INSERT INTO akeNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Mɨrɨ a'tai, Pi'ta uya ta'pʉ, “Ananayas, ɨ'rɨ pe iyesi pɨ' ɨri rɨ Se'tan ewonsa' ɨyewan ya', kasi pe rɨ Wakʉ A'kwarʉ enku'tɨ pa, mɨrɨ awonsi'kɨ itonpa rɨ kupʉ'pʉ esii'ma ɨpiyau? ");
INSERT INTO akeNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ikʉrʉpo'poma auya wapiya pe' ɨiwano' pe iyesi'pʉ pen mɨrɨ? Mɨrɨ awonsi'kɨ ikʉrʉpo'poma tʉpo, itepe'pʉ esi'pʉ ɨiwano' pe pen nɨ pe' mɨrɨ? Ɨ'rɨ pe iyesi pɨ' tʉku'sen pen nɨ kupʉ'pʉ auya? Ka'pon amʉ' pɨ' pe' kasi pe ɨwe'sa' pe ekama auya e'tane, kasi pe ɨwe'sa' Papa pɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Serɨ etasa' tʉuya a'tai, Ananayas uta'mo'ka'pʉ eke' pe, mɨrɨ awonsi'kɨ ipan pe rɨ serɨ etanin nʉ'san enari'nʉmʉ'pʉ iye'ku'sa' rʉ'pʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Mɨrɨ tʉpo, moine ton warawo' amʉ' uyee'pʉ itekepu ontɨse'na, mɨrɨpan enpa'ka'pʉ to' uya iu'na'tɨto' pe tʉuya'nokon. ");
INSERT INTO akeNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Osorʉwau ite'kwa kʉra' emiya era'tɨsa' tʉpo'ne rɨ, ino'pʉ uyee'pʉ, ɨ'rɨ e'ku'sa' tukai' i'tu iya pʉra iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pi'ta uya ekama'po'pʉ, “Serɨ rɨken pe' Ananayas ya' ɨnono kon epe'pʉ pe ɨneporo'pʉ kon?” ta'pʉ iya. “Ewai', mɨrɨ rɨken itepe'pʉ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pi'ta uya ta'pʉ ipɨ', “Ɨ'rɨ pe iyesi pɨ' Itepuru A'kwarʉ i'tupɨtʉ kon pa ɨyekoneka'pʉ kon?” ta'pʉ iya. “Apʉne enkɨ, ataan'pʉ u'na'tɨnin nʉ'san nɨ marɨ esi moro mʉra'ta nau, mɨrɨ awonsi'kɨ to' uya rɨ marɨ ɨyenpa'ka mɨrɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Mɨrɨ a'tai rɨ, ipiyau ita'mo'ka'pʉ eke' pe, mɨrɨpan moine ton warawo' amʉ' ewomʉ'pʉ itekepu ekare pɨ'. Itekepu arɨ'pʉ to' uya iu'na'tɨto' pe itaan'pʉ piyau rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Mɨrɨ pɨ', ipan pe rɨ Sises apurɨnin nan mɨrɨ awonsi'kɨ tanporon kon serɨ etanin nʉ'san enari'nʉmʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Enno'sa' kon uya tu'kan nɨ i'tuto' ipɨkɨrɨ mɨrɨ awonsi'kɨ a'kwarʉpɨ'nin kupʉ'pʉ ka'pon amʉ' koro'tau, mɨrɨ awonsi'kɨ tanporon kon Sises apurɨnin nan pe te'san esi'pʉ pʉroroi po, Saraman Epa'kato' Iya' tato' tau. ");
INSERT INTO akeNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tanporon kon nɨ esi'pʉ ɨpiyɨ'ke' pe to' koro'ta' enapai pʉra, ka'pon amʉ' uya ipan pe rɨ to' nama tane. ");
INSERT INTO akeNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Mɨrɨ koro'tau rɨ, tu'kan kon warawoti'si amʉ' mɨrɨ awonsi'kɨ uri'sami'si amʉ' uya rɨ Itepuru apurɨ'pʉ, mɨrɨ awonsi'kɨ to' tonpa pe to' era'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Mɨrɨ pe iyesi pɨ', ka'pon amʉ' uya e'ne' ton nepʉ'pʉ, asanta ta' to' nonka'pʉ to' uya to' e'kwe' po'ne to' apon po'ne rɨ, Pi'ta utɨ a'kwarʉ'pʉ uya rɨ to' epi'tɨto' pe. ");
INSERT INTO akeNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Anpisin ka'pon amʉ' Surusiran woi tʉuko'mansan uya e'ne' ton, makoi a'kwarʉ yen ton nɨ nee'pʉ, mɨrɨpan kon usepi'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Mɨrɨpan Papa ena' use'man nɨto' tʉrawasomanin nan epuru mɨrɨ awonsi'kɨ tanporon kon iya'kɨrɨ te'san Satu'si amʉ' tonpa ton ɨkɨntato' esi'pʉ ipan pe to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","To' uya enno'sa' kon a'si'pʉ, mɨrɨpan kon uya to' tʉrʉ'pʉ pariki'si ta'. ");
INSERT INTO akeNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","E'tane ewarupɨ nau, Papa inserʉʉi uya pariki'si mʉra'taai a'koka'pʉ, mɨrɨpan uya to' enpa'ka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' ta' entantɨ', ka'pon amʉ' pɨ' tanporo serɨ main ekamatantɨ' emenna' pe uko'man nɨto' ekareei,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Pata ema'sa' a'tai, to' ewomʉ'pʉ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' ta' tauro'ka'pʉ kon awɨrɨ rɨ, mɨrɨ awonsi'kɨ to' e'sara'tɨ'pʉ ka'pon amʉ' enupa pɨ'. Papa ena' use'man nɨto' tʉrawasomanin nan epuru mɨrɨ awonsi'kɨ itonpa ton uye'sa' a'tai, Esuwerʉ amʉ' Konsʉrʉʉi ton kɨ'ma'pʉ to' uya—tanporo Esuwerʉ amʉ' epuru ton—to' amʉrato' pe. To' uya Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' erasu pe te'san ennoko'pʉ pariki'si ta' a'sisa' rʉ'san enpa'kase'na. ");
INSERT INTO akeNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","E'tane to' utɨsa' pariki'si ta' a'tai, to' eporo to' uya pʉra iyesi'pʉ. Mɨrɨ pɨ' to' enna'po'pʉ ɨsekamase'na, ");
INSERT INTO akeNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“A'kopɨ'sa' pe kuru rɨ pariki'si eporo'pʉ ina uya iterasu ton nɨ e'soto'pɨ'sa' esi'pʉ mʉra'ta nau, e'tane ina uya a'kokasa' a'tai, ɨnʉ' pʉra iyesi'pʉ itau,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Serɨ tawon eta tʉuya a'tai, Esuwerʉ amʉ' use'mato', ɨpʉremato' erasu ton epuru mɨrɨ awonsi'kɨ Esuwerʉ amʉ' use'mato', ɨpʉremato' epuru ton usenu'mere'ma'pʉ mɨrɨ, “Ɨ'rɨ rɨ si e'kupʉ'pʉ serɨ ko? Ɨ'rɨ pe to' esi'pʉ?” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Mɨrɨpan e'tane, ka'pon uyee'pʉ, “Apʉne entɨ', pariki'si ta' ana'si'pʉ kon amʉ' e'soto'pɨ'sa' use'man nɨto', ɨpʉreman nɨto' iwʉ' tau ka'pon amʉ' enupa pɨ',” tase'na. ");
INSERT INTO akeNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mɨrɨ a'tai rɨ, erasu ton epuru utɨ'pʉ tʉtonpa ton pokon pe enno'sa' kon ne'se'na. To' ta'kwarʉkai' to' ɨnne'pai pʉra to' esi'pʉ, apʉne pʉra ka'pon amʉ' uya tʉwɨnɨ kon tɨ' ke tukai' to' usenari'pa'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Enno'sa' kon nepʉ'pʉ to' uya Esuwerʉ amʉ' Konsʉrʉʉi ton piya', Papa ena' use'man nɨto' tʉrawasomanin nan epuru uya to' ekama'popɨ'to' pe. ");
INSERT INTO akeNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“E'se'ne' pe ina uya ta'pʉ ɨpɨ'nokon, ‘Sises ese' pɨ' ka'pon amʉ' kʉsenupatʉu,’ ta'pʉ e'tane rɨ, pata Surusiran emʉ' wɨsa' auya'nokon enupan nɨto' auya'nokon ike ke mɨrɨ awonsi'kɨ tʉmakooi ke ina esi pʉse rɨ mʉnʉ uriya' ta auya'nokon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pi'ta mɨrɨ awonsi'kɨ itonpa ton uya imaimu eikʉ'pʉ, “Papa Maimu awɨrɨ ina e'to' pe iyesi, ka'pon maimu awɨrɨ pen. ");
INSERT INTO akeNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Papa, ina tamokori ton e'to' itese' pɨ', Sises i'mʉ'sa'kanin nʉ'pʉ iyeri'sa' apai ɨnwɨnɨ'pʉ kon tʉpokapɨ'se yʉi pona. ");
INSERT INTO akeNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Papa uya i'mʉ'sa'kasa' tenwo'netʉ winɨ, iku'sa' iya esa' wannɨ pe mɨrɨ awonsi'kɨ pika'tɨnin pe, Esuwerʉ amʉ' ra'tɨnin pe, to' makooi pɨ' isentu'ma ke. ");
INSERT INTO akeNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Serɨ e'kupʉ ennin nʉ'san ina, Wakʉ A'kwarʉ uya rɨ nɨrɨ ene'pʉ, Papa nʉtʉrʉ'pʉ tʉmaimu awɨron kon ena',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Serɨ eta tʉuya'nokon a'tai, ipan pe rɨ to' usakorota'pʉ, mɨrɨ awonsi'kɨ to' rɨ ɨnwɨpai to' ena'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","e'tane Pari'si, Main pɨ' enupanin nan tonpa, Kamariyerʉ itese', ka'pon amʉ' nʉnamanʉ rɨ e'soto'ka'pʉ to' piya', “Apʉne rʉ'kwɨ, kamoro warawo' amʉ' enpa'katɨ' aka'ne' pe,” ka'se'na. ");
INSERT INTO akeNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Mɨrɨpan uya to' auro'ka'pʉ, “Esuwerʉ amʉ', ɨnkupʉnʉ kon ti'tui' e'tɨ' pʉsamoro ka'pon amʉ' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Pena sa'ne Tiyotas itese' ka'pon esi'pʉ ɨnʉ' pe rɨ e'kupʉ i'se. Tu'kan kon nɨ ka'pon amʉ', 400 kaisaron kon era'tɨ'pʉ ipoitorʉ pe. Iwɨnɨ'pʉ to' uya, mɨrɨpan poitorʉ ton nʉ'san e'ta'nʉkʉ'pʉ, mɨrɨ awonsi'kɨ ɨ'rɨ pʉra rɨ iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kʉrɨ rɨ e'ma'pʉ ta', Isutas, Kiyarari ko' kanan esi'pʉ, ka'pon amʉ' ese' menukapɨ'to' a'tai, mɨrɨ awonsi'kɨ ka'pon amʉ' kanan anin pe iyesi'pʉ. Kʉrɨ rɨ kanan wɨnɨ'pʉ to' uya, mɨrɨpan poitorʉ rʉ'san e'ta'nʉkʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Mɨrɨ pe iyesi pɨ', serɨ pe na'ne' pɨ' kapai e'ai' ɨpɨ'nokon: tɨwɨ pʉsamoro warawo' amʉ' nesii; tɨwɨ to' nʉtɨi. Serɨ te'ku'sen esi a'tai ka'pon eseru pe, iye'kupʉ pʉra iyesi mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","E'tane Papa winon pe iyesi a'tai, ɨnʉ' uya rɨ pʉsamoro ereutanʉkʉ pʉra rɨ iyesi. Papa ewa'noma auya'nokon pe rɨ iye'to' oton,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Serɨ ta iya pɨ', “Ewai' rɨ ka'wa,” ta'pʉ to' uya. Enno'sa' kon kɨ'ma'pʉ to' uya, mɨrɨpan kon ari'po'pɨtʉ'pʉ to' uya, mɨrɨpan kon uya ta'pʉ to' pɨ', “Sises ese' yau kasauro'tʉu serɨ tʉpo,” ta'pʉ to' uya. To' utɨto' pe to' nonka'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Enno'sa' kon utɨ'pʉ Esuwerʉ amʉ' Konsʉrʉʉi ton piyapai. Pori' pe to' esi'pʉ, apʉne pʉra Papa pona wakʉ pe rɨ iyesi pɨ' to' ekota'ma Sises ese' wenai. ");
INSERT INTO akeNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Mɨrɨ awonsi'kɨ wʉi kaisarɨ rɨ Esuwerʉ amʉ' use'mato', ɨpʉremato' iwʉ' tau, ka'pon amʉ' iwʉ' tau'ne tereutai' pʉra rɨ, Sises pɨ' to' enupa pɨ' to' esi'pʉ, wakʉ itekare ekama pɨ' to' esi'pʉ, Sises esi Papa Nanʉmʉ'pʉ, tukai'. ");
INSERT INTO akeNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mɨrɨ a'tai, tu'ke rɨ Sises apurɨnin nan tu'kanoro epirikʉ'pʉ. Kiri' pe tʉusauro'san Esuwerʉ amʉ' mɨrɨ awonsi'kɨ patawon amʉ' Esuwerʉ amʉ' pokon pe to' e'manenpato' esi'pʉ, kiyari ke tʉtonpa kon uri'sami'si amʉ' itaan'pʉ ima'tasa' kon ɨnɨ to' uya pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Mɨrɨ pɨ' si ka'pon amʉ' amʉranʉkʉ'pʉ 12 kaisaron kon uya tanporon kon Sises apurɨnin nan, mɨrɨ awonsi'kɨ ta'pʉ to' uya, “Iye'to' pe pʉra iyesi mɨrɨ upona'nokon Papa Maimu tekamai' pʉra tʉron nɨ pɨ' e'nɨ a'tai usekan nɨ pɨ' rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Utonpa ton, 7 kaisaron kon ka'pon amʉ' epotɨ' ɨ'koro'tapai'nokon, i'tunin nan pe kuru ka'pon amʉ' ni'tunʉ ton, Wakʉ A'kwarʉ ke ita'kwarʉ'tɨsa' kon, serɨ i'se e'nɨto' tʉrawasomanin pe te'ton kon, ");
INSERT INTO akeNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ɨpʉreman pɨ' parɨ ina e'to' pe ka'pon amʉ' enupa pɨ' Papa Maimu ke,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tanporon kon epori'ma'pʉ enno'sa' kon maimu pɨ', mɨrɨpan kon uya si Si'tipʉn anʉmʉ'pʉ Papa Maimu apurɨnin ye' kuru, Wakʉ A'kwarʉ yen; Piri' rɨ kanan to' tonpa pe; tʉron kon Pʉro'koras; Ni'kanorʉ; Timon; Parʉmenas; Ne'koras, Antiyo' winon, iyera'tɨsa' rʉ'pʉ Esuwerʉ amʉ' tonpa pe. ");
INSERT INTO akeNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","To' uya si pʉsamoro anʉnsa' kon nʉ'san tʉrʉ'pʉ enno'sa' kon piya', to' pʉremato' pe si to' uya, tʉtʉrawasooi kon si ku'to' pe to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Mɨrɨpan Papa Maimu usekama'pʉ miyarɨ rɨ tu'kan kon pɨ' rɨ tu'ke rɨ Sises apurɨnin nan tu'kanoro epirikʉ'pʉ Surusiran po. Use'man nɨto' tʉrawasomanin nan nɨ era'tɨ'pʉ tu'ke kuru rɨ Sises uya enupan nɨto' awɨrɨ te'to' kon pe. ");
INSERT INTO akeNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Si'tipʉn, eke rɨ Papa uya wakʉ nonkasa' esa' mɨrɨ awonsi'kɨ tʉmeruntɨrʉ kenan uya, eke pe rɨ a'kwarʉpɨ'nin mɨrɨ awonsi'kɨ i'tuto' ipɨkɨrɨ rɨ kupʉ'pʉ ka'pon amʉ' koro'tau. ");
INSERT INTO akeNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","E'tane tʉron kon ka'pon amʉ' Esuwerʉ amʉ' usenupato' iwʉ' tau te'san tonpa ton Inonkasa' Kon tukai' tesa'san, Esuwerʉ amʉ' pe rɨ te'san, Sairini mɨrɨ awonsi'kɨ Arisantiriya winon kon ena'pʉ ewa'noma pɨ'. Kamoro mɨrɨ awonsi'kɨ Esuwerʉ amʉ' Siri'siya mɨrɨ awonsi'kɨ Eisa Mʉre'pʉ winon kon pokon pe te'sepose Si'tipʉn pokon pe to' e'sei'pɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","E'tane ipoken pʉra rɨ iyesi tato' ipɨkɨrɨ pʉra rɨ iyesi'pʉ, apʉne pʉra isaurokʉ pɨ' i'tunin pe kuru Iya'kwarʉ uya iku'sa' ke. ");
INSERT INTO akeNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Mɨrɨpan kon uya ama'ai ka'pon amʉ' anʉmʉ'pʉ eseru'tɨnin nan pe, “Si'tipʉn eta'pʉ ina uya Mosi' mɨrɨ awonsi'kɨ Papa sapema pe rɨ isaurokʉ'pʉ,” taton kon. ");
INSERT INTO akeNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mɨrɨpan kon uya ka'pon amʉ', Esuwerʉ amʉ' epuru ton mɨrɨ awonsi'kɨ Main pɨ' enupanin nan nɨ tʉrʉnka'pʉ. To' uya Si'tipʉn a'si'pʉ, mɨrɨpan nepʉ'pʉ to' uya Esuwerʉ amʉ' Konsʉrʉʉi ton piya'. ");
INSERT INTO akeNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","To' uya kasi pe rɨ Si'tipʉn eseru'tɨsa' tʉuya'nokon nʉ'pʉ ekama'pʉ Konsʉrʉ amʉ' pɨ'. “Iyereuta pʉra rɨ pʉse rɨ usauro'nɨ pɨ' man ɨri pe use'man nɨto', ɨpʉreman nɨto' iwʉ' pɨ' mɨrɨ awonsi'kɨ Main, Mosi' winon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ina uya etasa' man ta iya pʉse rɨ Sises, Nasare' pon uya serɨ pata ma'tanʉkʉ tawon. Mɨrɨ awonsi'kɨ ensima iya uko'man nɨ eseru Mosi' nʉtʉrʉ'pʉ uyena'nokon,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tanporo ense'na iyamʉrasa' kon Esuwerʉ amʉ' Konsʉrʉʉi ton iwʉ' ta' uya enpɨtʉ'pʉ itemʉ' poi rɨ, mɨrɨpan kon uya itemʉ' ene'pʉ inserʉ emʉ' kasa rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mɨrɨ a'tai, use'man nɨto' tʉrawasomanin nan epuru uya Si'tipʉn ekama'po'pʉ, “I'napai rɨ pe' ka'pon amʉ' nʉsauro'ai'ne' ɨpɨ' esi?” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Si'tipʉn uya imaimu eikʉ'pʉ, “Ɨmɨrɨ'nokon, tʉnamasan itepuru ton, apʉne etatɨ'. Papa usenpoika'pʉ Epʉra'an piya' Me'sa'po'temiya po Eran pona itɨ rawɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Apata'se' mɨrɨ awonsi'kɨ ɨtonpa ton inɨnkɨ, itɨkɨ mɨrɨ non sekamayai'ne' ya',’ ta'pʉ Papa uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Mɨrɨpan uya Karʉtiya pon kon nɨmɨ'pʉ. Eran po iyepatama'pʉ. Ikʉipʉnʉ uma'ta'pʉ tʉpo, Papa uya ennoko'pʉ serɨ mʉko'manyatʉi'ne' ya'. ");
INSERT INTO akeNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","E'tane intʉrʉnʉ pe te'sen itimamin tʉsa' iya pʉra iyesi'pʉ, e'tane Papa usaurokʉ'pʉ iku'to' pe uya tukai', ‘Ɨmɨrɨ, mɨrɨ awonsi'kɨ apayan nʉ'san, Esuwerʉ amʉ' uya non epoto' oton.’ Mɨrɨ a'tai, imʉre pʉra Epʉra'an esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Mɨrɨ tʉpo, Papa usaurokʉ'pʉ, ‘Apayan nʉ'san, Esuwerʉ amʉ' e'to' oton ka'kʉran pe tʉron kon pata yau. Mɨrɨ yau, tapiyo' kon pe to' e'tane, to' kota'mato' oton to' uya 400 kaisa rɨ wʉipiya, ");
INSERT INTO akeNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","e'tane urɨ uya mɨrɨ eke pata kota'mato' oton. To' epa'kato' oton mɨrɨ eke pata yapai, serɨ pata ya' uyapurɨpɨ'se'na,’ ta'pʉ Papa uya. ");
INSERT INTO akeNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Mɨrɨ a'tai, Papa uya Epʉra'an auro'ka'pʉ tanporo warawo' amʉ' uya tʉyun kon pi'pɨ puturʉkapɨ'to' pe, tʉmunkɨ pe to' esi ekamanin pe. Mɨrɨ a'tai, Aisi', Epʉra'an mu entu'pʉ, 8 kaisa rɨ wʉi tʉpo, itun pi'pɨ puturʉka'pʉ iya. Mɨrɨ tʉpo, Aisi' mu, Seko' entu'pʉ, mɨrɨpan yun pi'pɨ puturʉka'pʉ iya. Seko' uya nɨrɨ 12 kaisaron kon tʉmunkɨ amʉ' yun pi'pɨ puturʉkapɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Isose' esi'pʉ to' tonpa pe. Irunan nɨ ɨkɨnta'pʉ Isose' pɨ', mɨrɨpan kon uya ikʉrʉpo'poma'pʉ Isi' yawon kon poitorʉ pe. E'tane Papa esi'pʉ iya'kɨrɨ, ");
INSERT INTO akeNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","mɨrɨpan uya ipika'tɨ'pʉ tanporo ewankamanin apai. Isose' repa'pʉ iya ipu'ketʉ ke, mɨrɨpan uya iku'sa' esi'pʉ wakʉ pe kin Peero ewakiri pe. Mɨrɨ a'tai, Peero uya Isose' kupʉ'pʉ tanporo Isi' mɨrɨ awonsi'kɨ tʉpata'se' epuru pe. ");
INSERT INTO akeNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Mɨrɨ a'tai, iwankan uta'mo'ka'pʉ tanporo Isi' mɨrɨ awonsi'kɨ Kenan pata pona. Mɨrɨ a'tai, ka'pon amʉ' apʉ'kaa'pʉ iwan pɨ', utamokori kon amʉ' rɨ enta'nato' ipɨ' pʉra iyesi'pʉ, mɨrɨpan uya eke rɨ ewankamanin nee'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Seko' uya eta'pʉ, ‘Kiyari esi Isi' po,’ tawon, mɨrɨpan uya tʉmunkɨ amʉ', utamokori kon amʉ' ennoko'pʉ kiyari ennase'na. ");
INSERT INTO akeNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Iyakon ite'kwa pe to' utɨsa' a'tai, Isose' usekama'pʉ tʉrui ton pɨ'. Mɨrɨ a'tai si, Peero uya Isose' tonpa ton i'tu'pʉ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Serɨ tʉpo, Isose' uya tʉmaimu ennoko'pʉ tʉkʉipʉnʉ uye'to' pe tanporo tʉtonpa ton pokon pe Isi' pona. 75 kaisa rɨ tanporo to' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Mɨrɨ a'tai, Seko' utɨ'pʉ Isi' pona, mɨrɨpan uma'ta'pʉ. Imunkɨ amʉ' rɨ nɨrɨ uma'tapɨtʉ'pʉ mɨrɨ yau. ");
INSERT INTO akeNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","To' ekepu nee'pʉ to' uya Si'ken pona, mɨrɨpan kon u'na'tɨpɨtʉ'pʉ to' uya Epʉra'an ne'ma'pʉ yau Amorʉ munkɨ amʉ' winɨ, Si'ken po. ");
INSERT INTO akeNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“A'ko pe iweyu uyepʉ koro'tau, Papa uya tʉusaurokʉ'pʉ ku'to' pe Epʉra'an pɨ', tu'ke kuru utonpa kon amʉ' epansa' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Mɨrɨ a'tai, tʉron nɨ kin, Isose' i'tunin pen ena'pʉ Isi' epuru pe. ");
INSERT INTO akeNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kʉrɨ rɨ e'kupʉ'pʉ to' wanmʉra ɨri pe to' ma'tanʉkʉ pɨ', urɨ'nokon tamokori ton kota'ma'pʉ to' uya. To' apiyo'ma'pʉ to' uya tentusan mʉre amʉ' eno'mato' pe to' uya, to' uma'tato' pe. ");
INSERT INTO akeNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Mɨrɨ koro'tau, Mosi' entu'pʉ. Wakʉ pe rʉ'kwɨ iyesi'pʉ, mʉre e'pɨ'to' kasa pʉra. Osorʉwau kapʉi to' uya imainanpa'pʉ ikʉipʉnʉ iwʉ' tau. ");
INSERT INTO akeNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","To' uya enpa'kanʉ'sa' a'tai, Peero ensi uya anʉmʉ'pʉ, mɨrɨpan emo'ka'pʉ iya tʉmʉre kasa kuru rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mosi' usenupasa' esi'pʉ tanporo Isi' pon kon eseru yau. Imaimu, mɨrɨ awonsi'kɨ inkupʉnʉ esi'pʉ meruntɨ pe. ");
INSERT INTO akeNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“40 kaisa rɨ iwʉipiyaai Mosi' enasa' a'tai, tʉtonpa ton ka'kʉranpa pɨ' iye'kupʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","To' tonpa Esuwerʉ pon wɨpɨtʉ Isi' ko' uya ene'pʉ iya, mɨrɨpan utɨ'pʉ Esuwerʉ pon pika'tɨse'na. Mɨrɨpan e'ma'pʉ Mosi' uya, Isi' ko' tʉwɨse. ");
INSERT INTO akeNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosi' usenuminka'pʉ tʉtonpa ton uya tʉto'ka'nʉkʉ tukai' Papa uya tʉku'sa' to' pika'tɨnin pe tukai', e'tane to' uya ito'ka'nʉkʉ pʉra iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mɨrɨ ema'sa' yau, Mosi' uya asa'ron kon Esuwerʉ pon kon epanta'ma ene'pʉ, to' epanta'ma ereutanʉkʉ i'se iyesi'pʉ. Ta'pʉ iya to' pɨ', ‘Warawo' amʉ' ɨsitonpa pe ɨwesi kon mɨrɨ. Ɨtonpa kʉ'wɨpɨtʉi,’ ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“E'tane warawo' tʉtonpa wɨpɨ'nin uya Mosi' a'tu'ma'pʉ, ‘Ɨnʉ' uya ɨku'sa' ina epuru pe, mɨrɨ pe pʉra ina eseru aimenkanin pe? ");
INSERT INTO akeNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Uwɨpai pe' ɨwesi Isi' ko' wɨnɨ'pʉ auya kasa ko'mamiyau?’ tai'ma. ");
INSERT INTO akeNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mosi' uya mɨrɨ etasa' a'tai, iyapʉrʉmʉ'pʉ Metiyan pona. Mɨrɨ yau, iko'mamʉ'pʉ ka'kʉran pe. Mɨrɨ yau, asa'rɨ imu'ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“40 kaisa rɨ wʉipiya tʉpo, inserʉ usenpoika'pʉ Mosi' piya' yu' epo'tɨ yau, rɨmono' tau, a'ko pe Sainai Wʉpʉ piyau. ");
INSERT INTO akeNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mɨrɨ ensa' tʉuya a'tai, ipan pe isewansiuka'pʉ yu' epo'tɨ pʉra iyesi pɨ'. A'ko pe iwinɨkʉi' itɨ koro'tau, Papa maimu eta'pʉ iya: ");
INSERT INTO akeNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Papa urɨ, atamokori kon Epʉra'an, Aisi', mɨrɨ awonsi'kɨ Seko' e'to' itese' pɨ'.’ Mosi' enari'nʉmʉ e'tɨtɨtɨ'ka'pʉ, ɨnenpai pʉra. ");
INSERT INTO akeNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Mɨrɨ a'tai, Papa uya ta'pʉ ipɨ', ‘Asapatooi imo'kakɨ! Mɨrɨ ɨye'mʉ'sa'kasa' na'ne' yau esi wakʉ pe. ");
INSERT INTO akeNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Umunkɨ amʉ' ekota'ma ensa' uya man Isi' po. To' a'nʉmʉ etasa' uya man. Mɨrɨ pɨ' uye'sa' man to' mo'kase'na. Inke pʉra ɨsi'kɨ; ɨyennoko uya serɨ Isi' pona’ ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Pʉse rɨ Mosi' Esuwerʉ amʉ' newaruma'tɨ'pʉ, ‘Ɨnʉ' uya ɨku'sa' ina epuru pe, ina eseru aimenkanin pe?’ ta'pʉ ipɨ' rʉ'pʉ, kʉrɨ rɨ ennoko'pʉ Papa uya to' epuru pe, to' pika'tɨnin pe nɨrɨ, inserʉ winɨ isenpoikasa' rʉ'pʉ yu' yau. ");
INSERT INTO akeNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mosi' kʉrɨ rɨ utamokori kon amʉ' anin nʉ'pʉ ɨnnɨ Isi' apai, a'kwarʉpɨ'nin mɨrɨ awonsi'kɨ i'tuto' ipɨkɨrɨ rɨ kupʉ'pʉ iya, Papa uya imeruntɨɨi tʉsa' esi'pʉ. Mɨrɨ ton kupʉ'pʉ iya Isi' po, Isuweyu Parau kau mɨrɨ awonsi'kɨ rɨmono' tau nɨrɨ 40 kaisa rɨ wʉipiya yau. ");
INSERT INTO akeNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Pʉse rɨ Mosi', Esuwerʉ amʉ' auro'kanin nʉ'pʉ, ‘Papa uya pu'kena' anʉnto' oton ɨ'koro'tapai'nokon uwaraino,’ tawon nʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Pʉse rɨ Mosi' esi'pʉ to' koro'tau rɨmono' tau. Inserʉ, Papa winon uya auro'ka'pʉ Sainai Wʉpʉ po. Main, uko'man nɨto' ipɨ' ekama'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“E'tane utamokori kon amʉ' uya apurɨ pʉra iyesi'pʉ. To' uya inurunpa'pʉ. Tewan kon yau, enna'popai to' esi'pʉ Isi' pona. ");
INSERT INTO akeNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Eran auro'ka'pʉ to' uya, ‘Papa tato' ipɨ' pe ika'sa' ɨnkoneka', uyanin kon pe te'ton. Pʉse rɨ Mosi', une'nin nʉ'pʉ kon Isi' apai e'tane, ɨ'rɨ pe rɨ nawon iyesi'pʉ tukai' ina uya i'tu pʉra man!’ ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Mɨrɨ a'tai, to' uya papa tato' pe ipɨ' ika'sa' koneka'pʉ paka mʉre kasa, tʉuse'mato' kon nee'pʉ to' uya ipiya', mɨrɨpan kon userenka'pʉ, to' umanumʉ'pʉ tʉnkoneka'pʉ kon nama tʉuya'nokon ekamanin pe. ");
INSERT INTO akeNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","E'tane Papa usakorotasa' era'tɨ'pʉ to' piyapai, apʉne pʉra papa tato' ipɨ' ika'sa' konekasa' to' uya wenai. To' nonka'pʉ iya to' ɨpʉremato' pe wʉi enu, kapʉi, mɨrɨ awonsi'kɨ sirikɨ amʉ' pɨ'. Serɨ e'menukasa' esi'pʉ pu'kena' karetaai yau: “‘Esuwerʉ amʉ' rʉ'kwɨ, serɨ ɨuse'mato' kon nepʉ auya'nokon pʉra iyesi'pʉ uyena' 40 kaisa rɨ wʉipiya rɨmono' tau ɨwesi kon a'tai. ");
INSERT INTO akeNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Papa tato' pe ipɨ' ika'sa' More' iwʉ' apɨtʉ'pʉ auya'nokon, sirikɨ pe ika'sa' ka'pon amʉ' nesakʉnʉ Re'pan tukai'. Ika'sa' ɨwɨpʉremato' kon ipɨ'. Mɨrɨ pe iyesi pɨ', ɨyenno'to' uya 'nokon oton ɨnnɨ’ Paperan enta'. ");
INSERT INTO akeNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Utamokori kon amʉ' piyau Papa uya amʉranʉ'nɨto' ita' esi'pʉ rɨmono' tau. Iyekonekasa' esi'pʉ Mosi' pɨ' Papa nekama'pʉ awɨrɨ. Ikonekato' ipɨ' pe tʉnene'pʉ kasa. ");
INSERT INTO akeNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Utamokori kon amʉ' uya mɨrɨ amʉranʉ'nɨto' ita' eporo'pʉ tʉkʉipʉnʉ kon winɨ, mɨrɨpan arɨ'pʉ to' uya ta'kɨrɨ'nokon Isa'suwa a'kɨrɨ tʉutɨ kon a'tai non mo'kai'. Mɨrɨ non mo'ka'pʉ to' uya tʉron kon ka'pon amʉ' enapai. Papa uya to' ainʉnpa'pʉ Esuwerʉ amʉ' uya non mo'kato' pe. Iko'mamʉ'pʉ mɨrɨ pata yau Tepi' weyu e'seporo pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Kʉrɨ rɨ Papa ewakiri pe iye'sa' rʉ'pʉ, mɨrɨpan uya Papa ekama'po'pʉ ɨutɨ amɨto' pe tʉuya tʉmɨrɨ pe. ");
INSERT INTO akeNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","E'tane Saraman uya kuru ɨutɨ amɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Mɨrɨpan e'tane, Papa esi eke pe ka'pon namɨ'pʉ tau tʉuko'mansen pen. Pu'kena' amʉ' tonpa uya tasa', ");
INSERT INTO akeNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“‘Epʉn esi uyapon pe, non esi u'ta apon pe. Ɨ'rɨ warai ɨutɨ amɨ auya'nokon uiwʉ' pe? ta Itepuru uya. Mɨrɨ pe pʉra nai yau umoronka'to' pata'se' esi? ");
INSERT INTO akeNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Unkoneka'pʉ ton pen pe' se ton tanporon nɨ?’ ");
INSERT INTO akeNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Ɨmɨrɨ'nokon ɨri ton nɨ, sa'man ton nɨ ɨyewan kon! Ɨmɨrɨ'nokon e'makoima atamokori kon amʉ' esi'pʉ kasa. Ɨuko'mamʉ kon Wakʉ A'kwarʉ ewaruma'tɨ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Atamokori kon uya wapiyaro' kon pu'kena' amʉ' kota'ma'pʉ. To' uya rɨ Ipokena' Ka'pon uyepʉ ekamanin nan tʉ'ka'pʉ. Serɨ pe si eparanka'pʉ auya'nokon iteyaton non ena' to' uya iwɨto' pe. ");
INSERT INTO akeNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ɨmɨrɨ'nokon uya Papa Maimu eporo'pʉ mɨrɨ, Papa nʉtʉrʉ'pʉ atamokori kon ena'. Inserʉ amʉ' uya mɨrɨ tʉrʉ'pʉ atamokori kon ena'. Mɨrɨ e'tane, iyawɨrɨ pʉra ɨwesi kon,” ta'pʉ Si'tipʉn uya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Esuwerʉ amʉ' Konsʉrʉʉi ton uya pʉse rɨ Si'tipʉn maimu etasa' a'tai, ipan pe to' usakorota'pʉ. Mɨrɨ a'tai, to' uya tʉyɨ kon kɨtɨtɨi'ma'pʉ, ipan pe tʉusakorota kon pe. ");
INSERT INTO akeNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","E'tane, Si'tipʉn uya eke pe Wakʉ A'kwarʉ eposa' esi'pʉ, ka'ta' tenu tʉrʉ'pʉ iya. Mɨrɨ a'tai, Papa a'kwarii ene'pʉ iya. Mɨrɨ a'tai, Sises e'mʉ'sa'kasa' ene'pʉ iya Papa enwo'netʉ winɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Apʉne entɨ', Papa uya Epʉn mʉra'taai a'kokasa'! Sises e'mʉ'sa'kasa' esi Papa enwo'netʉ winɨ!” ta'pʉ Si'tipʉn uya. ");
INSERT INTO akeNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Eke pe to' ukɨ'pɨ'nʉnpɨtʉ'pʉ. Tanporo to' utɨ'pʉ itekare pɨ', temiyatʉ kon tʉpɨtʉ'pʉ to' uya tʉpana kon pona imaimu eta tʉuya'nokon namai'. ");
INSERT INTO akeNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","To' uya tʉpi'si'se enpa'ka'pʉ pata yapai, mɨrɨpan kon e'sara'tɨ'pʉ eke ton tɨ' ma'kɨrɨ pɨ' ipona, iwɨnɨ'pʉ to' uya. Ka'pon amʉ' iwɨnin nan uya tʉpon kon pʉro'pon kanka'pʉ, mɨrɨpan nonka'pʉ to' uya non pona moineri'pɨ, Saarʉ piyau. ");
INSERT INTO akeNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Tɨ' ke to' uya tʉwɨnɨ koro'tau, Si'tipʉn ɨpʉrema'pʉ, “Uyepuru, Sises, uya'kwarʉ anʉnkɨ!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tese'mu po ita'mo'ka'pʉ, eke pe iyɨpʉrema'pʉ, “Uyepuru, to' kʉ'kota'mai to' uya uwɨnɨ pɨ'!” ta'pʉ iya. Mɨrɨ ta tʉpo, iyerikʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saarʉ esi'pʉ mɨrɨ yau iwɨtɨ' rɨ ta pɨ'. Mɨrɨ a'tai, ka'pon amʉ' e'sara'tɨ'pʉ ipan pe Sises apurɨnin nan kota'ma pɨ' Surusiran po tʉuko'mansan. Mɨrɨ a'tai, tu'kan kon Sises apurɨnin nan apʉrʉmʉ'pʉ Isutiya mɨrɨ awonsi'kɨ Sameriya pona. Enno'sa' kon nɨken e'nɨnsa' esi'pʉ Surusiran po. ");
INSERT INTO akeNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Papa uya tasa' kasa warawo' amʉ' uya Si'tipʉn u'na'tɨ'pʉ, eke pe tʉuta'kwarʉkai' to' ukaramʉ'pʉ iwenai. ");
INSERT INTO akeNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Mɨrɨ koro'tau, Saarʉ e'sara'tɨ'pʉ Sises apurɨnin nan ma'tanʉkʉ pɨ'. Iyewonpɨtʉ'pʉ ɨutɨ kaisa rɨ'ne, warawo' amʉ', uri'san amʉ' nɨrɨ Sises apurɨnin nan tʉpɨtʉ'pʉ pariki'si ta'. ");
INSERT INTO akeNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Sises apurɨnin nan, ka'pon amʉ' nainʉnpa'san Surusiran apai utɨ'pʉ pata kaisa rɨ wakʉ Sises ekareei ekama pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Sises apurɨnin nan tonpa, Piri' itese' utɨ'pʉ Sameriya pata ya', mɨrɨpan uya mɨrɨ yau Kʉrai ekama'pʉ ka'pon amʉ' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Mɨrɨ a'tai, tu'kan kon esi'pʉ ipan pe Piri' maimu ɨnetapai, wakʉ i'tuto' ipɨ' inkupʉnʉ ensa' tʉuya'nokon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Makoi a'kwarʉ ton epa'ka'pʉ ɨpirorʉnpɨtʉi'ma ka'pon amʉ' apai. Tu'kan kon ise'mesa' kon, sekentei'pa' nan usepi'tɨ'pʉ, apʉne pʉra Papa uya Piri' ku'sa' wenai to' epi'tɨnin pe. ");
INSERT INTO akeNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tu'kan kon ka'pon amʉ' esi'pʉ ipan pe pori' pe mɨrɨ pata yau. ");
INSERT INTO akeNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mɨrɨ yau iyesi'pʉ ka'pon, Saiman itese', enwoke', eke pe te'ku'sen mɨrɨ pata yau. Enwoke' pe tesi winɨ te'ku'sen pen nɨ ku'nin pe iyesi'pʉ Sameriya yawon kon tewansiukai'. ");
INSERT INTO akeNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tanporo ka'pon amʉ' mɨrɨ yawon kon aiko ton mɨrɨ awonsi'kɨ eke ton nɨ uya apurɨ'pʉ. “Pʉse rɨ ka'pon esi Papa meruntɨrʉ yau,” ta'pʉ to' uya. Eke kuru tukai' ka'pon amʉ' uya esakʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Apurɨ pɨ' to' esi'pʉ, apʉne pʉra enwoke' pe tesi ke to' ewansiukapɨtʉ'pʉ iya, inke rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","E'tane nin si Piri' nekamanʉ wakʉ itekare, Papa e'to' esa' wannɨ pe, mɨrɨ awonsi'kɨ Sises Kʉrai ese' ekareei apurɨsa' to' uya a'tai, warawoti'si amʉ' mɨrɨ awonsi'kɨ uri'sami'si amʉ' epa'taisima'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saiman uya rɨ nɨrɨ Piri' maimu apurɨ'pʉ. Piri' uya ipa'taisima'pʉ tʉpo, ipɨkɨrɨ Saiman esi'pʉ mɨ airɨ rɨ Piri' utɨ a'tai. Tɨwɨrɨ rɨ Saiman usewansiukapɨtʉ'pʉ, i'tuto' ipɨ' mɨrɨ awonsi'kɨ eke Papa tʉrawasooi Piri' nʉkupʉnʉ tense. ");
INSERT INTO akeNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Surusiran pon kon enno'sa' kon uya etasa' a'tai, tu'kan kon Sameriya yawon kon uya Papa maimu apurɨsa' tawon, to' uya Pi'ta mɨrɨ awonsi'kɨ Isaan ennoko'pʉ to' piya'. ");
INSERT INTO akeNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","To' uya to' eposa' a'tai, to' ɨpʉrema'pʉ to' pona Wakʉ A'kwarʉ epoto' pe to' uya, ");
INSERT INTO akeNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","apʉne pʉra Wakʉ A'kwarʉ uye'sa' pʉra rɨ marɨ iyesi'pʉ to' pona. Piri' uya to' pa'taisima'pʉ esi'pʉ Itepuru Sises ese' yau rɨken. ");
INSERT INTO akeNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Mɨrɨ a'tai, Pi'ta mɨrɨ awonsi'kɨ Isaan uya temiyatʉ kon tʉrʉ'pʉ to' pona, mɨrɨpan kon uya Wakʉ A'kwarʉ eporo'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saiman uya ene'pʉ Papa uya Ta'kwarʉ tʉrʉ ka'pon amʉ' pona enno'sa' kon uya temiyatʉ kon tʉrʉ to' pona a'tai, pʉrata ke to' repa i'se iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Urepatɨ' mɨrɨ ku'nin ke. Mɨrɨ a'tai, tanporo uyemiyatʉ tʉto' uya ton ipona uya, Wakʉ A'kwarʉ epoto' pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pi'ta uya imaimu eikʉ'pʉ, “Ɨpʉrataai pokon pe auma'ta mɨrɨ, apʉne pʉra ɨusenuminka pɨ' Papa winon e'ma auya pʉrata ke tukai'! ");
INSERT INTO akeNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Papa uya ɨku'sa' pʉra man ɨ'rɨ ku'nin pe ina a'kɨrɨ serɨ tʉrawaso yau, apʉne pʉra ɨyewan esi wakʉ pe pʉra Papa pona. ");
INSERT INTO akeNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Mɨrɨ pe iyesi pɨ', ɨri pe ɨusenuminkato' inonka' mɨrɨ awonsi'kɨ ɨwɨpʉrema pa Itepuru pɨ'. Mɨrɨ a'tai, ɨpɨ' isentu'ma uya amakooi eno'mato' pe ikupʉ i'se ɨusenuminka'pʉ na'ne'. ");
INSERT INTO akeNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ɨi'tu uya wenai ipan pe ɨyɨkɨnta ina pɨ' tukai', tɨwɨ rɨ ɨye'makoima winɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Mɨrɨ a'tai, Saiman uya ta'pʉ Pi'ta mɨrɨ awonsi'kɨ Isaan pɨ', “Ɨpʉrematɨ' upona. Mɨrɨ a'tai, mʉkayatʉi'ne' rɨ e'kupʉ namai' upɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pi'ta mɨrɨ awonsi'kɨ Isaan uya ka'pon amʉ' auro'ka'pʉ tʉpo, Sises i'tusa' tʉuya'nokon nʉ'pʉ pɨ' itekare ekama'pʉ to' uya to' pɨ', Papa winon Sises ekareei, to' e'sara'tɨ'pʉ enna'pon pɨ' Surusiran winɨkʉi'. Tʉutɨ kon koro'tau, wakʉ Sises ekareei ekama'pʉ to' uya ka'pon amʉ' pɨ' Sameriya yawon eke iwa ton pata yau'ne. ");
INSERT INTO akeNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Inserʉ, Papa nennoko'pʉ uya Piri' auro'ka'pʉ, “Ekoneka' ɨutɨ pa wʉi enu enuku kamisi winɨkʉi' Surusiran poino asanta Kesa ponakan ta',” ta'pʉ iya. (Mɨrɨ asanta e'nonka'pʉ mɨrɨ.) ");
INSERT INTO akeNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Mɨrɨpan ekonekasa' utɨ koro'tau, ka'pon eporo'pʉ iya mɨrɨ asanta tau tʉutɨsen, eke kuru rɨ I'tiyo'piya pata kwin pʉrataai esa', Surusiran pona itɨsa' rʉ'pʉ ɨpʉremai'. ");
INSERT INTO akeNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Iyenna'po a'tai, iyereutasa' esi'pʉ tʉkanwa tararan yau. Eke pe pu'kena' Aisaya nʉmenuka'pʉ kareta ekama iya esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Papa A'kwarʉ uya Piri' auro'ka'pʉ, “Enta mɨrɨ tararan piyau a'ko pe e'se'na,” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Mɨrɨ a'tai, Piri' utɨ'pʉ tararan piya', mɨrɨpan uya eta'pʉ ekama iya pu'kena' Aisaya nʉmenuka'pʉ yau. Piri' uya ekama'po'pʉ, “Mekamayai'ne' pe' mʉto'ka'nʉ'an?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","“Kane, ito'ka'nʉkʉ uya pʉra man. Ka'pon uya rɨ nin enpoika a'tai, ito'ka'nʉkʉ uya rɨ,” ta'pʉ iya. Mɨrɨpan uya Piri' kɨ'ma'pʉ tʉpiyau iyereutato' pe tʉkanwa ya'. ");
INSERT INTO akeNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Se tawon ekama pɨ' iyesi'pʉ: “To' uya arɨ'pʉ karimeru arɨ kasa iwɨse'na. Karimeru mʉre kasa ti'po' akʉ'tane e'pana te'sen, mɨrɨpan kasa isaurokʉ pʉra iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Se pe rɨ iye'ku'to' yau, ɨnʉ' rɨ iwenaino' pʉra iyesi'pʉ. Ɨnʉ' uya rɨ ipayan nʉ'san ekamato' oton pen nɨ, apʉne pʉra non po iko'manto' emo'ka'pʉ pɨ',” tawon. ");
INSERT INTO akeNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kwin pʉrataai esa' uya Piri' ekama'po'pʉ, “Ekamakɨ ɨnʉ' pɨ' pu'kena' uya imenukasa'; tʉmɨrɨ pɨ' pe', tʉron nɨ pɨ' rɨ katɨ?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Mɨrɨ a'tai, Piri' epiya'tɨ'pʉ mɨrɨ rɨ iye'menukasa' itekare apai wakʉ Sises ekareei ke ipana'tɨ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","To' utɨ koro'tau asanta tawɨrɨ, tuna eporo'pʉ to' uya. “Apʉne tuna enkɨ! Upa'taisimakɨ. Ɨ'rɨ nɨrɨ ken uwa'kʉtʉi'no mɨrɨ apai?” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Piri' uya ta'pʉ, “Apurɨ auya a'tai tanporo ɨyewan a'kɨrɨ, iye'kupʉ rɨ,” ta'pʉ iya. Mɨrɨpan maimu eikʉ'pʉ iya, “Apurɨ uya serɨ Sises Kʉrai esi Papa Mu pe tukai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Mɨrɨpan uya tararan ereutanʉkʉ'pʉ. Mɨrɨ a'tai, asa'rɨ rɨ marɨ Piri' mɨrɨ awonsi'kɨ kwin pʉrataai esa' utɨ'pʉ tuna ka', mɨrɨpan pa'taisima'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","To' ekanwaka a'tai tuna kapai, Itepuru A'kwarʉ uya Piri' arɨ'pʉ. Kwin pʉrataai esa' uya ene pʉra iyena'pʉ. Mɨrɨ rɨ e'tane, itɨ'pʉ pori' pe esii'ma asanta tawɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Mɨrɨ a'tai, Piri' esi ene'pʉ to' uya itekare ekama pɨ' Aso'tas po, siya rɨ pata kaisa rɨ'ne Sisariya pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Mɨrɨ koro'tau, Saarʉ usakorotasa' uya, “Sises poitorʉ ton tʉ'ka uya,” ta'pʉ. Saarʉ utɨ'pʉ Papa ena' use'man nɨto' tʉrawasomanin nan epuru piya' ");
INSERT INTO akeNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","tekamanin kareta, Tamaskas pon Esuwerʉ amʉ' usenupato' iwʉ' ton ta' epose'na. Serɨ kareta uya Saarʉ ku'sa' esi'pʉ, Ite'ma awɨron kon, warawoti'si mɨrɨ awonsi'kɨ uri'sami'si a'sisa' ato' pe iya Surusiran pona. ");
INSERT INTO akeNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ta'kɨron kon pokon pe itɨ uya pata eporo koro'tau, Tamaskas itese', a'kwa, Epʉn winon uya iwei'tɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ita'mo'ka'pʉ non pona. Mɨrɨ a'tai, main eta'pʉ iya, “Saarʉ, Saarʉ, ɨ'rɨ pe iyesi pɨ' ukota'ma auya?” tawon. ");
INSERT INTO akeNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saarʉ uya ekama'po'pʉ, “Ɨnʉ' ɨmɨrɨ, Uyepuru?” ta'pʉ iya. “Urɨ Sises, ɨnkota'manʉ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“E'mʉ'sa'ka', itɨkɨ pata pona. Mɨrɨ yau iyesi mɨrɨ ayauro'ka ton ɨnku'ton pɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ka'pon amʉ' iya'kɨrɨ tʉutɨsan e'takʉ'ka'pʉ, ɨ'rɨ tai'ma pʉra rɨ; mɨrɨpan kon uya main eta'pʉ, e'tane ɨnʉ' rɨ ene to' uya pʉra iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saarʉ e'mʉ'sa'ka'pʉ non poi, e'tane ɨ'rɨ ene iya pʉra iyesi'pʉ. Mɨrɨ wenai, to' uya arɨ'pʉ itemiyatʉ pɨ' ta'sii' Tamaskas pona. ");
INSERT INTO akeNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Osorʉwau wʉi itenu pʉra iyesi'pʉ. Iyenta'na pʉra, ɨ'rɨ rɨ ensi iya pʉra iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Mɨrɨ yau iyesi'pʉ Sises apurɨnin, Ananayas itese'. Ananayas enu uta'kwakasa' koro'tau, Itepuru maimu eta'pʉ iya, “Ananayas!” tawon. “Setayai' rɨ, Uyepuru,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","“Ekoneka', enta Isutas piya', To'saron itese' asanta ta',” ta'pʉ Itepuru uya ipɨ'. “Ɨnʉ' rɨ mekama'poi' mɨrɨ yau, ‘Ka'pon, Saarʉ itese', Tarʉsas winon pe' serɨ yau nai?’ tukai'. Serɨ a'tai, ɨpʉreman pɨ' man. ");
INSERT INTO akeNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Itenu uta'kwakasa' uya ene'pʉ ka'pon, Ananayas itese' uyepʉ, temiyatʉ tʉse'na tʉpona, ennin pe tenato' pe,” ta'pʉ Itepuru uya itenu uta'kwakasa' koro'tau. ");
INSERT INTO akeNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","“Uyepuru, tu'kan kon ka'pon amʉ' uya uyauro'kasa' man, wakʉ ton Papa nʉkupʉ'san ekota'mato' emapu'tɨsa' iya ipan pe Surusiran po. ");
INSERT INTO akeNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Papa ena' use'man nɨto' tʉrawasomanin nan epuru ton uya auro'ka'pʉ iye'to' pe Tamaskas pona ɨyese' pɨ' te'san a'sipɨ'se'na, to' ase'na Surusiran pona,” ta'pʉ Ananayas uya. ");
INSERT INTO akeNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","E'tane, “Saarʉ piya' enta. Anʉnsa' uya man uyapiyo' pe, uyekareei pɨ' Esuwerʉ amʉ' pen, to' epuru ton, mɨrɨ awonsi'kɨ Esuwerʉ amʉ' auro'kato' pe iya. ");
INSERT INTO akeNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Urɨ wenai eke pe iyekota'mato' enpoika uya mɨrɨ itenu ya',” ta'pʉ Itepuru uya Ananayas pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Mɨrɨ a'tai, Ananayas utɨ'pʉ itau iye'to' ɨutɨ ta', mɨrɨpan uya temiyatʉ tʉrʉ'pʉ Saarʉ pona. “Utonpa Saarʉ, Sises, asanta tau isenpoikasa' rʉ'pʉ ɨyena' uya uyenno'sa' man, ennin pe kanan ɨyena pa, auta'kwarʉ'tɨ pa nɨrɨ Wakʉ A'kwarʉ ke,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Mɨrɨ ta iya pe rɨ, moro' pi'pɨ waraino uta'pokʉ'pʉ itenu ton poi. Ennin pe kanan iyena'pʉ. Mɨrɨ a'tai, iye'mʉ'sa'ka'pʉ, mɨrɨ pe rɨ Ananayas uya ipa'taisima'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Mɨrɨpan enta'nasa' ena'pʉ pana' pe. Saarʉ uko'mamʉ'pʉ Sises poitorʉ rʉ'san piyau Tamaskas po. ");
INSERT INTO akeNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Mɨrɨ a'tai rɨ, itekare ekama pɨ' iye'sara'tɨ'pʉ, “Sises esi Papa Mu pe,” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tanporo etanin nan usewansiuka'pʉ, “Pʉse rɨ pen pe' pʉse, Surusiran pon kon kʉrɨ rɨ ese' pokon kon tʉ'kataine' pen? Iye'sa' kanan pen pe' se, kamoro a'sipɨ'se'na, mɨrɨpan kon ase'na use'man nɨto' tʉrawasomanin nan epuru ton eke ton kuru ena'?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","E'tane miyarɨ rɨ tʉnekamanʉ yau meruntɨ pe Saarʉ ena'pʉ. Papa Maimu winɨ enpoika pɨ' iyesi'pʉ, “Sises esi Kʉrai pe,” tukai', mɨrɨpan pɨ' to' utanpokʉma'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Inke Tamaskas po Saarʉ esi koro'tau, Esuwerʉ amʉ' e'kama'pʉ iwɨnɨ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Tʉwɨnɨ pɨ' e'kamanɨsa' eta'pʉ Saarʉ uya. Wʉi nai, ewarupɨ nau nɨrɨ mʉra'ta nau Saarʉ enupɨkɨrɨ to' esi'pʉ, iwɨto' pe tʉuya'nokon e'tane, to' uya iwɨnɨ'pʉ pen. ");
INSERT INTO akeNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Inenupanʉ ton uya ipika'tɨ'pʉ, ewarupɨ nau tʉpa'kai'. Mɨrɨ a'tai, eke pa'siki'ti yau si'na' pɨ' to' uya inu'tɨ'pʉ pata wekupiri euta yai. ");
INSERT INTO akeNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Surusiran pona Saarʉ epa'kasa' a'tai, Sises poitorʉ rʉ'san tonpa pe kuru enapai iyesi'pʉ, e'tane tu'kan kon enari'nʉmʉ'pʉ ipɨ', “I'napai rɨ pe' ken Sises apurɨnin pe iyenasa'?” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","E'tane Panapas uya inee'pʉ itekare ekamase'na enno'sa' kon piya'. Panapas uya enpoika'pʉ to' pɨ', “Saarʉ utɨ koro'tau Tamaskas e'ma tau, Itepuru ene'pʉ iya, mɨrɨpan uya auro'ka'pʉ,” ta'pʉ iya. Panapas uya nɨrɨ to' auro'ka'pʉ, “Saarʉ uya Sises ekareei ekama'pʉ enari'mʉra Tamaskas pon kon ka'pon amʉ' pɨ',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Panapas maimu apurɨsa' to' uya wenai, Sises apurɨnin nan Surusiran pon kon tonpa pe Saarʉ ena'pʉ, mɨrɨpan usarɨ'pʉ enari'mʉra rɨ Surusiran poro Sises ekareei ekama pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Saarʉ esi'pʉ usauro'nɨ pɨ' e'maimu'pɨ' nɨ pɨ' Sises ekareei pɨ' Esuwerʉ amʉ', Kiri' pe tʉusauro'san pokon pe enpoika i'se to' pɨ', e'tane miyarɨ rɨ iwɨnɨ pɨ' to' e'kama'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tʉron kon Sises apurɨnin nan uya i'tusa' a'tai, ka'pon amʉ' e'kamasa' iwɨnɨ pɨ', to' uya arɨ'pʉ Sisariya pona, mɨrɨpan ennoko'pʉ to' uya Tarʉsas pona. ");
INSERT INTO akeNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mɨrɨ a'tai, Sises apurɨnin nan Isutiya, Kiyarari, mɨrɨ awonsi'kɨ Sameriya pon kon uko'mamʉ'pʉ ewankamanin pʉra, ɨnʉ' uya rɨ to' kota'ma pʉra iyesi wenai. Wakʉ A'kwarʉ uya to' meruntɨtanʉkʉ'pʉ, to' pori'ma'pʉ iya rɨ. Miyarɨ rɨ Sises apurɨ pɨ' tu'ke to' ena'pʉ. Mɨrɨpan kon uko'mamʉ'pʉ Itepuru nama pɨ' rɨ tʉuko'mamʉ kon kaisa rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pi'ta esi koro'tau utɨn pɨ' pata ton kaisa rɨ'ne, Reta pon kon wakʉ ton Papa nʉkupʉ'san ka'kʉranpai' itɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Mɨrɨ yau, ka'pon eporo'pʉ iya, Eniyas itese'. Te'kwe' poi iye'mʉ'sa'ka pʉra iyesi'pʉ, 8 kaisa rɨ wʉipiya ise'mesa' uko'mansa' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pi'ta uya ta'pʉ ipɨ', “Eniyas, serɨ pe Sises uya ɨyepi'tɨ. E'mʉ'sa'ka', ɨye'kwe' e'mepɨ'kɨ,” ta'pʉ iya. Mɨrɨ a'tai rɨ, Eniyas e'mʉ'sa'ka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tanporo tʉuko'mansan Reta mɨrɨ awonsi'kɨ Isaran yawon kon uya ene'pʉ, to' era'tɨ'pʉ Itepuru Sises winɨkʉi'. ");
INSERT INTO akeNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Isa'pa pata po, Sises apurɨnin uri'san esi'pʉ, Tapi'ta itese'. Itese' esi'pʉ Kiri' maimu yau Tarʉ'kas, “usari” ta e'kwa pe. Tɨwɨrɨ rɨ wakʉ ku'nin pe iye'pɨtʉ'pʉ, entu'manin nan nɨ pika'tɨ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Reta po Pi'ta esi a'tai, e'ne' pe tenai', uri'san Tarʉ'kas erikʉ'pʉ. Iyeri'sa' ekepu korʉka'pʉ to' uya, mɨrɨpan kon uya ka'tawon ɨutɨ tau inonka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Reta esi'pʉ a'ko pe Isa'pa piyau. Sises poitorʉ rʉ'san uya Reta po Pi'ta esi tukai' etasa' a'tai, asa'ron kon ka'pon amʉ' ennoko'pʉ to' uya ipiya'. “Inke pʉra ɨsi'kɨ,” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Mɨrɨ a'tai rɨ, itɨ'pʉ Isa'pa pona to' a'kɨrɨ. Pata eposa' iya a'tai, to' uya arɨ'pʉ ka'ta', Tarʉ'kas ekepu piya'. Tanporo uri'sami'si amʉ' itaan'pʉ ima'tasa' kon nʉ'san amʉrasa' esi'pʉ ipiyau, ukaran nɨ pɨ', pon amʉ' Tarʉ'kas nʉkonepɨtʉ'pʉ enpoikapɨtʉ pɨ' to' esi'pʉ nurɨne iyesi a'taino rʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Tanporo Pi'ta uya to' enpa'ka'pʉ, mɨrɨpan e'sekunka'pʉ ɨpʉremai', nurɨne kanan Tarʉ'kas enato' pe. Mɨrɨ tʉpo, eke' winɨkʉi' iyera'tɨ'pʉ, “Tapi'ta, e'mʉ'sa'ka'!” ta'pʉ iya. Mɨrɨ a'tai rɨ, itenu ton uta'koka'pʉ. Pi'ta ene iya a'tai, iye'mʉ'sa'ka'pʉ ta'mu pona. ");
INSERT INTO akeNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Itemiya pɨ' ta'sii' i'mʉ'sa'ka'pʉ iya, mɨrɨpan uya Sises poitorʉ rʉ'san mɨrɨ awonsi'kɨ uri'sami'si amʉ' itaan'pʉ ima'tasa' kon nʉ'san kɨ'ma'pʉ, mɨrɨpan uya nurɨne inee'pʉ to' piya'. ");
INSERT INTO akeNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mɨrɨ a'tai rɨ, mɨ poro rɨ te'san ka'pon amʉ' uya Isa'pa po eke Papa tʉrawasooi e'ku'sa' i'tu'pʉ. Tu'kan kon uya Itepuru apurɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pi'ta uko'mamʉ'pʉ Isa'pa po ka'pon, Saiman itese', o' pi'pɨ konepɨ'nin piyau. ");
INSERT INTO akeNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mɨrɨ yau iyesi'pʉ ka'pon, Koneriyas itese', Sisariya pata po tʉuko'mansen, Roman amʉ' soisaai epuru ton tonpa pe te'sen, I'tariyan soisa amʉ' tukai' tesa'san kon. ");
INSERT INTO akeNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tɨwɨrɨ rɨ tʉtonpa ton amʉtʉ pe Papa eseru poro ɨko'mamʉ i'se te'sen, tɨwɨrɨ rɨ entu'manin nan repanin pe iyesi'pʉ eke pe rɨ, tɨwɨrɨ rɨ tʉwɨpʉremasen Papa pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ko'maan pe iwa, 3 a'kʉra', Papa uya itenu a'kwakasa' uya, kɨpo'po Papa inserʉʉi uyepʉ tʉpiya' ene'pʉ. “Koneriyas!” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Koneriyas uya enari'ke' pe esii'ma ene'pʉ, “Ɨ'rɨ na'kɨ i'se me'ai', uyepuru?” ta'pʉ iya ipɨ'. Inserʉ uya ta'pʉ ipɨ', “Papa epori'masa' man entu'manin nan repasa' auya pɨ', ɨwɨpʉremasa' pɨ' tʉpɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Saiman, Pi'ta tukai' tesa'sen kɨ'manin nan ka'pon amʉ' ɨnenno'kɨ Isa'pa pata pona. ");
INSERT INTO akeNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Saiman nɨ marɨ itese' ka'pon, o' pi'pɨ konepɨtʉ pɨ' te'sen iwʉ' tau iyesi mɨrɨ, parau e'pi po na'ne',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Auro'kanin nʉ'pʉ inserʉ utɨ'pʉ a'tai, Koneriyas uya asa'rɨ tʉpoitorʉ ton kɨ'ma'pʉ. Tikin nɨ soisa kɨ'ma'pʉ iya nɨrɨ, Papa apurɨnin, tʉtonpa pe te'sen. ");
INSERT INTO akeNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Tanporo iye'ku'sa' rʉ'pʉ pɨ' to' auro'ka'pʉ iya. Mɨrɨ tʉpo, Isa'pa pona Pi'ta kɨ'mai' to' ennoko'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Pʉre'po'si a'tai rɨ, mɨrɨ ema'sa' yau, pata eporo to' uya koro'tau, Pi'ta enuku'pʉ ai'tou pan ɨutɨ nakapu pona ɨpʉremai'. ");
INSERT INTO akeNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Mɨrɨ a'tai, iwan pe iyesi'pʉ, enta'napai iyesi'pʉ. Iti'kiyari ekoneka koro'tau, Papa uya itenu a'kwaka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ka' uta'kokasa' ene'pʉ iya. Kareku waraino u'tɨ non pona a'kwa' kasa ewa'tɨsa' asakɨrɨ'nan si'na' ke itekun enne'pɨ'ne ene'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mɨrɨ yau iyesi'pʉ ti'tui' pʉra rɨ ene amʉ', ɨkʉi amʉ', mɨrɨ awonsi'kɨ ɨri ton nɨ toron amʉ' nɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Mɨrɨ a'tai, main eta'pʉ iya, “Ɨyo' tʉwɨse enta'nakɨ,” tawon. ");
INSERT INTO akeNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","E'tane Pi'ta uya imaimu eikʉ'pʉ, “Uyepuru, mɨrɨ kupʉ uya pʉra man; ɨri tasa' na'ne' nan ipɨ' Main uya annin pen urɨ,” ta'pʉ Pi'ta uya. ");
INSERT INTO akeNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Papa uya ta'pʉ ipɨ', akon ite'kwa pe, “Wakʉ enta'nan nɨto' pe Papa nʉkoneka'pʉ pɨ' ɨri kʉkai,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Pi'ta uya serɨ main eta'pʉ osorʉwau ite'kwa, mɨrɨ pe rɨ, o' amʉ' en enuku'pʉ ka' pona. ");
INSERT INTO akeNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pi'ta usenuminka koro'tau, “Ɨ'rɨ kuru si ekamanin se ko?” tukai', Koneriyas nennoko'san ka'pon amʉ' esi'pʉ enuri'nɨ pɨ' mʉra'ta nau. ");
INSERT INTO akeNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","To' uya ekama'po'pʉ, “Moro pe' serɨ yau ka'pon, Saiman, Pi'ta tato' nai?” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ɨ'rɨ ta e'kwa pe serɨ esi se, ta Pi'ta uya koro'tau, “Osorʉwawon kon ka'pon amʉ' esi ɨyenpai,” ta'pʉ Ita'kwarʉ uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","“E'mʉ'sa'ka', ɨu'tɨ'; tʉusenuminkai' pʉra itɨkɨ to' a'kɨrɨ. To' enno'sa' uya mɨrɨ ɨpiya',” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","“Urɨ kʉrɨ rɨ anwarinpanʉ kon. Ɨ'rɨ na'kɨ pɨkɨrɨ uyense'na mɨsi'tʉu?” ta'pʉ Pi'ta uya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","“Koneriyas, Roman amʉ' soisaai epuru uya ina enno'sa' man,” ta'pʉ to' uya ipɨ'. “Ipokena' pe te'sen mɨrɨ awonsi'kɨ tɨwɨrɨ rɨ Papa eseru poro ɨko'mamʉ i'se te'sen; Esuwerʉ amʉ' uya nɨrɨ wakʉ kʉrɨ rɨ tato' ipɨ'. Papa inserʉʉi uya auro'ka'pʉ ɨuye'to' pe itiwʉ' ta' auro'kato' auya etato' pe iya,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","“Ewai',” ta'pʉ Pi'ta uya to' pɨ', mɨrɨpan uya to' ewonnʉkʉ'pʉ tʉpiya' to' apontɨi'. Mɨrɨ ema'sa' yau, Pi'ta e'sara'tɨ'pʉ utɨn pɨ' to' a'kɨrɨ. Isa'pa apai Sises apurɨnin nan e'sara'tɨ'pʉ itonpa pe. ");
INSERT INTO akeNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Iyema'sa' yau, Sisariya epokaa'pʉ to' uya. Tʉtonpa ton akonta awon kon mɨrɨ awonsi'kɨ tʉtonpa ton kuru tamʉranʉ'se Koneriyas esi'pʉ to' enupɨkɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pi'ta ewomʉ koro'tau, Koneriyas utɨ'pʉ mʉra'ta na' ipiya' ata'mo'kai' inama tʉuya ekamanin pe. ");
INSERT INTO akeNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pi'ta uya ipika'tɨ'pʉ i'mʉ'sa'ka pɨ' itemiyatʉ pɨ' ta'sii', “E'mʉ'sa'ka', urɨ pɨ' kɨpʉremai, ka'pon nɨ marɨ urɨ, awaraino,” ta'pʉ iya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Asaurokʉi'ma iya'kɨrɨ Pi'ta ewomʉ'pʉ, tu'kan kon ka'pon amʉ' amʉrasa' koro'ta'. ");
INSERT INTO akeNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","“I'tu auya'nokon mɨrɨ Esuwerʉ amʉ' enta'na pʉra iyesi tʉron kon Esuwerʉ amʉ' pen a'kɨrɨ, to' rɨ ka'kʉranpa to' uya pʉra rɨ iyesi to' iwʉ' ta'. E'tane pʉra, Papa uya enpoikasa' man uyenu ya' tʉron kon wakʉ pe inkoneka'san pɨ' ɨri tukai' esi namai'. ");
INSERT INTO akeNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Mɨrɨ wenai, ukan ka'pon amʉ' enno'sa' auya a'tai, inke pʉra rɨ uye'nɨ pɨ' epori'ma'pʉ. Apʉne ekama'; ɨ'rɨ pe iyesi pɨ' ukɨ'masa' auya?” ta'pʉ Pi'ta uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Koneriyas uya imaimu eikʉ'pʉ, “Asakɨrɨ'ne ipata'pʉ pe wʉi utɨka'sa' serɨ, uiwʉ' tau ɨpʉreman pɨ' esi koro'tau, ko'maan pe iwa, 3 a'kʉra', ite'kwanau pʉra rɨ, ka'pon a'kwa ipon e'soto'kasa' esi'pʉ upiyau, ");
INSERT INTO akeNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","mɨrɨpan uya ta'pʉ, ‘Koneriyas, Papa uya ɨwɨpʉremato' etasa' man, entu'manin nan repa auya nɨrɨ i'tusa' iya man. ");
INSERT INTO akeNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Mɨrɨ wenai, Isa'pa pona Saiman Pi'ta kɨ'mase'na ka'pon amʉ' ɨnenno'kɨ. Saiman nɨ marɨ itese' ka'pon o' pi'pɨ konepɨtʉ pɨ' te'sen piyau iyesi mɨrɨ, parau e'pi po na'ne',’ ta'pʉ iya upɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Mɨrɨ a'tai rɨ, ka'pon amʉ' ennoko'pʉ uya ɨkɨ'mai'. Wakʉ pe rɨ umaimu awɨrɨ ɨuye'sa' man. Serɨ pe si ina amʉrasa' man tanporo Papa uya tentane'nokon, tanporo rɨ Itepuru uya ɨrepasa' ina auro'kato' auya ike ke ekama auya etase'na. Asauro'kɨ si,” ta'pʉ Koneriyas uya. ");
INSERT INTO akeNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pi'ta e'sara'tɨ'pʉ to' auro'ka pɨ', “Serɨ pe ito'ka'nʉkʉ uya, i'napai rɨ Papa esi tanporo ka'pon amʉ' i'nʉnkanin pe ɨsi'kaisa rɨ, ");
INSERT INTO akeNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","tanporon kon nɨ tʉnamanin nan, ipoken te'sen ku'nin nan anʉmʉ Papa uya, ɨnʉ' yan pe rɨ to' e'tane. ");
INSERT INTO akeNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","I'tu auya'nokon, Papa uya tʉmaimu ennoko'pʉ Esuwerʉ amʉ' piya'. Wakʉ itekare ekama'pʉ iya, wakʉ pe tʉpokon pe uko'man nɨ emapu'tɨnin Sises poro. (Sises esi Esuwerʉ amʉ' epuru pe rɨken pen, e'tane tanporon kon nɨ epuru pe iyesi.) ");
INSERT INTO akeNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Tanporon nɨ e'kupʉ'pʉ Isutiya pata poro'ne i'tu auya'nokon mɨrɨ. Mɨrɨ ton e'sara'tɨ'pʉ Kiyarari po, itekare ekama pɨ' epa'taisimapɨ' nɨ pɨ' Isaan esi'pʉ pata'pʉ pe. ");
INSERT INTO akeNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","I'tu auya'nokon Sises, Nasare' pon Papa uya Ta'kwarʉ mɨrɨ awonsi'kɨ tʉmeruntɨrʉ tʉrʉ'pʉ ipona. Sises utɨpɨtʉ'pʉ nɨrɨ wakʉ kupʉ pɨ' pata kaisa rɨ'ne, ka'pon amʉ' epi'tɨpɨtʉ pɨ' Makoi meruntɨrʉ apai. Sises uya serɨ ton kupʉ'pʉ Papa esi wenai tʉpika'tɨnin pe. ");
INSERT INTO akeNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Ina esi mɨrɨ tanporo Esuwerʉ amʉ' pata'se' awɨrɨ, Surusiran poro rɨ, inkupʉ'pʉ tʉnene'pʉ kon ekamanin pe. To' uya iwɨnɨ'pʉ kurusu' pona tʉpokapɨ'se. ");
INSERT INTO akeNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Mɨrɨ rɨ e'tane, nurɨne iye'to' pe Papa uya i'mʉ'sa'ka'pʉ osorʉwau wʉi tʉpo. Papa uya ka'pon amʉ' uya ento' pe ikupʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Tanporon kon uya kuru ene'pʉ pen; ina rɨken ennin nan pe anʉnsa' kon uya Sises ene'pʉ, tʉron kon ka'pon amʉ' auro'kanin nan pe ina e'to' pe. Ina iyenta'nasa' kon iya'kɨrɨ, ensinin nʉ'san nɨ iya'kɨrɨ, nurɨne iyenasa' a'tai terikʉ tʉpo, ");
INSERT INTO akeNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","kʉrɨ rɨ uya ina auro'kasa' itekare ekamanin pe ina e'to' pe ka'pon amʉ' pɨ'. Kʉrɨ rɨ kʉrɨ rɨ Papa Nanʉmʉ'pʉ tanporon kon eseru aimenkanin pe tanporo nurɨnan kon, iyeri'sa' kon nɨ nɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tanporo kareta amʉ' pu'kena' ton nʉmenuka'pʉ ka'pon amʉ' auro'kanin pe ipɨ' uya serɨ ekamasa': Ɨnʉ' rɨ kʉrɨ Sises apurɨnin pe te'sen uya, tʉmakooi pɨ' usentu'man nɨto' eporo mɨrɨ itese' poro,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pi'ta usaurokʉ koro'tau, ite'kwanau pʉra rɨ, Wakʉ A'kwarʉ u'tɨ'pʉ tanporo ka'pon amʉ' etanin nan pona. ");
INSERT INTO akeNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Isa'pa winon kon, Esuwerʉ amʉ', Sises apurɨnin nan, Pi'ta a'kɨrɨ iye'sa' kon usewansiuka'pʉ, apʉne pʉra Papa uya Ta'kwarʉ tʉsa' pɨ' Esuwerʉ amʉ' pen nɨ pona. ");
INSERT INTO akeNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","47","Tʉron nɨ main yau'ne, Papa apurɨpɨtʉ to' uya, eta'pʉ to' uya. Mɨrɨ a'tai, Pi'ta uya ta'pʉ, “I'napai rɨ man wakʉ pe, pʉsamoro epa'taisimato' pe iyesi tuna ke. To' uya Wakʉ A'kwarʉ eposa' man urɨ'nokon uya eposa' na'ne' kasa rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","To' apiyo'ma'pʉ iya to' epa'taisimato' pe Sises Kʉrai ese' yau, mɨrɨpan kon uya Pi'ta ekama'po'pʉ tʉpiyau'nokon iko'manto' pe miyarɨ rʉ'kwɨ parɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Enno'sa' kon mɨrɨ awonsi'kɨ tʉron kon to' tonpa ton Isutiya po tʉuko'mansan uya, Esuwerʉ amʉ' pen nɨ uya Papa ekareei anʉnsa' tawon eta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pi'ta utɨsa' a'tai Surusiran pona, Esuwerʉ amʉ' pen yun pi'pɨ puturʉka tawon nan uya isapema'pʉ mɨrɨ yau. ");
INSERT INTO akeNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Esuwerʉ amʉ' pen nɨ piya' ɨutɨpɨtʉ mɨrɨ awonsi'kɨ auta're'tɨpɨtʉ to' piyau,” ta'pʉ to' uya Pi'ta pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Mɨrɨ pɨ' nin si tanporo iye'ku'sa' rʉ'pʉ pataka'pʉ Pi'ta uya na'ne' to' pɨ'; ");
INSERT INTO akeNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Isa'pa pata po ɨpʉreman pɨ' esi'pʉ. Mɨrɨpan koro'tau, ka' apai eke kareku waraino a'kwa' kasa ewa'tɨsa' asakɨrɨ'nan si'na' ke itekun enne'pɨ'ne u'tɨ ene'pʉ uya upiya', Papa uya uyenu a'kwakasa' koro'tau. ");
INSERT INTO akeNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mɨrɨ yau, tu'kan kon nɨ ti'tui' pʉra rɨ ene amʉ', ɨkʉi amʉ' mɨrɨ awonsi'kɨ ɨri ton nɨ toron amʉ' rɨ ene'pʉ uya. ");
INSERT INTO akeNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mɨrɨ tʉpo, Papa uya uyauro'ka eta'pʉ uya, ‘Pi'ta, ɨyo' oton tʉwɨse enta'na',’ tawon. ");
INSERT INTO akeNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“‘Kane, Uyepuru, ikupʉ uya pʉra iyesi, apʉne pʉra kamoro warai'nan o' amʉ' ansa' uya pʉra kuru rɨ iyesi,’ tukai' imaimu eikʉ'pʉ uya. ");
INSERT INTO akeNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Akon ite'kwa pe kanan uyauro'ka'pʉ iya, ‘Ɨ'rɨ pɨ' rɨ ɨri kʉkai, tanporon nɨ Papa nʉkoneka'pʉ esi wakʉ pe.’ ");
INSERT INTO akeNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Serɨ e'kupʉ'pʉ osorʉwau ite'kwa. Mɨrɨ tʉpo, ene amʉ' apon kareku waraino enuku'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Mɨrɨ a'tai, osorʉwawon kon ka'pon amʉ' uyee'pʉ itau e'to' ɨutɨ airɨ, Koneriyas nennoko'san upiya' Sisariya apai. ");
INSERT INTO akeNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Papa A'kwarʉ uya uyauro'ka'pʉ te'kʉ'kʉ'mai' pʉra rɨ to' a'kɨrɨ utɨto' pe, Esuwerʉ amʉ' pe pʉra rɨ to' e'tane. 6 kaisaron kon Isa'pa pon kon utonpa ton utɨ'pʉ uya'kɨrɨ Sisariya pona. Mɨrɨ yau, ka'pon iwʉ' ta' ina ewomʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Mɨrɨpan uya inserʉ e'mʉ'sa'kasa' ene'pʉ tʉuya ekama'pʉ ina pɨ', ‘Ka'pon amʉ' enno'kɨ Isa'pa pona Saiman Pi'ta kɨ'mai'. ");
INSERT INTO akeNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ekama iya mɨrɨ, Papa uya tanporo ɨiwʉ' tawon kon pika'tɨto' oton,’ tukai', ta'pʉ inserʉ uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Usaurokʉ e'sara'tɨ pe rɨ, Wakʉ A'kwarʉ u'tɨ'pʉ to' pona, wapiya upona'nokon iu'tɨ'pʉ kasa. ");
INSERT INTO akeNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Mɨrɨ a'tai, i'tu'pʉ uya Itepuru Sises uya ta'pʉ rʉ'pʉ, ‘Isaan uya ka'pon amʉ' pa'taisimapɨtʉ tuna ke, e'tane ɨmɨrɨ'nokon epa'taisimato' oton Wakʉ A'kwarʉ ke,’ tawon. ");
INSERT INTO akeNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Papa uya mɨrɨ rɨ Wakʉ A'kwarʉ ke to' repasa' urɨ'nokon repa'pʉ tʉuya ike ke rɨ Itepuru Sises Kʉrai apurɨ'nokon a'tai, ɨnʉ' pe ken si te'ku'se Papa ereutanʉkʉ i'se esi?” ta'pʉ Pi'ta uya ka'pon amʉ' Surusiran pon kon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Serɨ eta to' uya a'tai, Pi'ta sapemato' tʉuya'nokon ereutanʉkʉ'pʉ to' uya, Papa rɨken apurɨpɨtʉ'pʉ to' uya. “Papa uya ken ka'wa Esuwerʉ amʉ' pen kanan ku'sa' tʉmakooi kon apai tera'tɨi' tʉuko'mansan pe,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ka'pon amʉ' uya Si'tipʉn wɨnɨ'pʉ si'kɨrɨ, Sises apurɨnin nan apʉrʉmʉ'pʉ Surusiran apai tʉron nɨ pata ya'ne, apʉne pʉra mɨrɨ yawon kon ka'pon amʉ' uya tʉkota'ma kon pɨ'. Tʉron kon to' tonpa ton utɨ'pʉ Pini'siya pata ya', Sai'pʉras opa'wʉ pona, mɨrɨ awonsi'kɨ Antiyo' pata ya'. To' uya Sises ekareei ekama esi'pʉ Esuwerʉ amʉ' pɨ' rɨken mɨrɨ ton pata yau'ne. ");
INSERT INTO akeNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Tʉron kon Sises apurɨnin nan esi'pʉ Sai'pʉras opa'wʉ pon kon mɨrɨ awonsi'kɨ Sairini pata yawon kon, mɨrɨpan kon utɨ'pʉ Antiyo' pata ya'. Mɨrɨ yau, itekare ekama'pʉ to' uya Esuwerʉ amʉ' pen nɨ pɨ', wakʉ Itepuru Sises ekareei. ");
INSERT INTO akeNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Mɨrɨpan kon pika'tɨ'pʉ Papa uya. Itekare ekama pɨ' to' esi koro'tau, tu'kan kon nɨ Esuwerʉ amʉ' pen nɨ ena'pʉ Sises apurɨnin nan pe, mɨrɨpan kon era'tɨ'pʉ Papa winɨkʉi'. ");
INSERT INTO akeNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Surusiran pon kon apurɨnin nan uya serɨ etasa' esi'pʉ, mɨrɨpan kon uya Panapas ennoko'pʉ Antiyo' pona. ");
INSERT INTO akeNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Pata eposa' tʉuya a'tai, Papa uya eke pe rɨ wakʉ nonkasa' to' pona ene'pʉ iya. Pori' pe iyesi'pʉ, mɨrɨpan uya to' pori'mapɨtʉ'pʉ miyarɨ rɨ Sises apurɨnin nan pe to' e'to' pe tanporo tewan kon pokon pe. ");
INSERT INTO akeNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Panapas esi'pʉ wakʉ kuru ka'pon, Wakʉ A'kwarʉ ke ita'kwarʉ'tɨsa', mɨrɨ awonsi'kɨ apurɨto' ke, mɨrɨpan uya tu'kan kon nɨ pika'tɨ'pʉ Itepuru Sises apurɨnin nan pe. ");
INSERT INTO akeNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mɨrɨpan tʉpo, Panapas utɨ'pʉ Tarʉsas pona Saarʉ epose'na. ");
INSERT INTO akeNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Mɨrɨpan uya eposa' a'tai, inee'pʉ iya Antiyo' pona. Mɨrɨ yau, Panapas mɨrɨ awonsi'kɨ Saarʉ pokon uko'mamʉ'pʉ tikin nɨ wʉipiya apurɨnin nan pokon pe te'sepopɨ'se, mɨrɨpan kon uya tu'kan kon nɨ ka'pon amʉ' enupapɨtʉ'pʉ. Antiyo' po wapiya kuru Sises poitorʉ ton esakʉ'pʉ to' uya mɨrɨ Kʉri'san amʉ' tukai'. ");
INSERT INTO akeNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mɨrɨ a'tai'ne, Sises apurɨnin nan, pu'kena' amʉ' utɨ'pʉ Antiyo' pona, Surusiran apai. ");
INSERT INTO akeNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Tikin nɨ to' tonpa, Akapas itese', e'mʉ'sa'ka'pʉ asauro'se'na. Papa A'kwarʉ uya tauro'kato' awɨrɨ ekama'pʉ iya to' pɨ', “Eke iwankan uta'mo'kan pɨ' man tanporo pata emʉ' kaisa rɨ,” ta'pʉ iya. (Serɨ e'kupʉ'pʉ Kʉrautiyas esi a'tai Ron o'no te'san pata ton epuru pe.) ");
INSERT INTO akeNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Sises pɨ' enupasa' kon e'kama'pʉ Isutiya pon kon tʉtonpa kon repa pɨ' pʉrata ke. ");
INSERT INTO akeNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Mɨrɨpan kon uya ikupʉ'pʉ, pʉrata ennoko'pʉ to' uya so'si epuru ton ena', Panapas mɨrɨ awonsi'kɨ Saarʉ pokon enau. ");
INSERT INTO akeNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mɨrɨ koro'tau, Sises apurɨnin nan kota'ma i'se kin Era' esi'pʉ, mɨrɨpan uya soisa amʉ' ennoko'pʉ so'si epuru ton Surusiran pon kon a'sise'na, mɨrɨpan kon tʉto' pe to' uya pariki'si ta'. ");
INSERT INTO akeNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Era' uya soisa apiyo'ma'pʉ Isens, Isaan rui wɨto' pe iya supara ke. ");
INSERT INTO akeNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Era' uya i'tu'pʉ Isens wɨsa' tʉuya a'tai, pori' pe kuru Esuwerʉ amʉ' ena'pʉ tukai', mɨrɨ awonsi'kɨ soisa amʉ' kanan apiyo'ma'pʉ iya Pi'ta a'sito' pe to' uya iwɨto' pe kanan. Serɨ e'kupʉ'pʉ A'sarutanʉ'sa' Pen Pʉreti Pɨ' Enta'nan Weyu a'tai. ");
INSERT INTO akeNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Soisa amʉ' uya Pi'ta a'si tʉpo, to' uya arɨ'pʉ pariki'si ta', mɨrɨpan Era' uya asakɨrɨ'nan kon iyamu'kuru' ton asakɨrɨ'nan yawon kon soisa amʉ' apiyo'ma'pʉ erasuntɨ pɨ'. Era' esi'pʉ Pi'ta tenpa'kai' pariki'si tapai ɨnekama'popɨ'pai Esuwerʉ amʉ' pana airɨ, To' Epoi Itɨ'pʉ Weyu Rʉ'pʉ tʉpo. ");
INSERT INTO akeNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Mɨrɨ pɨ' rɨ pariki'si tau Pi'ta enkurunpa'pʉ to' uya, e'tane apurɨnin nan esi'pʉ Papa ekama'po pɨ', Pi'ta pika'tɨto' pe iya. ");
INSERT INTO akeNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Era' e'kamasa' Pi'ta enpa'ka pɨ' ekama'popɨ'to' pe tʉuya mɨn winon ewarupɨɨi tau, Pi'ta esi'pʉ e'nʉn nɨ pɨ' asa'ron kon soisa amʉ' a'sanau. To' uya itemekon auronpɨ'sa' esi'pʉ. Tʉron kon soisa amʉ' esi'pʉ mʉra'ta erasuntɨ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ite'kwanau pʉra rɨ, inserʉ usenpoika'pʉ Pi'ta piya', mɨrɨpan uya a'kwa pe pata kupʉ'pʉ pariki'si tau. Inserʉ uya Pi'ta enpaka'pʉ ta'pɨ'pɨ'se, “Inke pʉra e'mʉ'sa'ka',” ta'pʉ iya, mɨrɨpan auronpɨ'sa' itemiyatʉ utaranka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Mɨrɨ tʉpo, “Ekoneka', asapatooi ipata'tɨ',” ta'pʉ inserʉ uya ipɨ', mɨrɨpan kupʉ'pʉ Pi'ta uya. “Ɨpon pʉro'pon ipata'tɨ', mɨrɨ awonsi'kɨ uya'kɨrɨ ɨsi'kɨ,” ta'pʉ inserʉ uya. ");
INSERT INTO akeNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pi'ta utɨ'pʉ iya'kɨrɨ pariki'si tapai. I'napai rɨ pe' ne'ku'ai'ne' esi tai'ma rɨ Pi'ta epa'ka'pʉ pariki'si tapai, tenu uta'kwakasa' uya rɨ na'kɨ ene tukai' ɨsenuminkai'ma. ");
INSERT INTO akeNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pi'ta mɨrɨ awonsi'kɨ inserʉ uya wapiyaro' kon soisa amʉ' entakakaa'pʉ, mɨrɨ awonsi'kɨ ite'ma'pʉ pe te'san kanan entakakaa'pʉ to' uya. Soisa amʉ' uya to' ene pʉra. To' uye'kaa'pʉ wa'ka pun pe te'sen mʉra'ta na', pata ya' tʉutɨsen, mɨrɨpan mʉra'ta uta'koka'pʉ tiwano' pe rɨ, mɨrɨpan kon epa'ka'pʉ. Ɨnnɨ rʉ'kwɨ rɨ asanta tau to' utɨkaa'pʉ tʉpo, inserʉ uya inɨmɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","“I'napairɨ rɨ ka'si, pariki'si tapai epa'kasa' serɨ wa!” ta'pʉ Pi'ta uya. “Si'tuka'ai' si, Itepuru uya tinserʉʉi enno'sa' upika'tɨi' Era' esi tʉnkupʉnʉ ɨnku'pai upɨ' apai mɨrɨ awonsi'kɨ iye'kupʉ kuru tawon nan nɨrɨ Esuwerʉ amʉ' piyapai,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pi'ta uya i'tusa' a'tai, itɨ'pʉ Meri, Isaan san iwʉ' ta'. Tu'kan kon nɨ ka'pon amʉ' amʉrasa' ɨpʉremase'na tepose. ");
INSERT INTO akeNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pi'ta uya mʉra'ta wɨpɨtʉ'pʉ. Ka'pon uya rɨ tewonnʉ'to' pe, apiyo' pe rʉ'kwɨ te'sen, Rota itese' uyee'pʉ imaimu'se'na mʉra'ta na'. ");
INSERT INTO akeNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pi'ta maimu etasa' tʉuya a'tai, epori'mai'ma iyeka'tumʉ'pʉ, mʉra'ta ta'kokai' pʉra, ɨutɨ tawon kon pana'tɨi', “Pi'ta man mʉra'ta nau!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Ɨ'rɨ uya ayano'ma, Rota?” ta'pʉ to' uya ipɨ', e'tane rɨ akonomapɨ'kaa'pʉ iya, “Pi'ta esi mɨ airɨ ukayai'ne ko!” takaa'pʉ iya kanan. “A'tai pʉra itinserʉʉi rɨ na'kɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Mʉra'ta wɨpɨtʉ pɨ' rɨ Pi'ta esi'pʉ to' uya a'kokato' pe. To' uya a'kokasa' a'tai, to' usewansiuka'pʉ ene tʉuya'nokon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pi'ta uya temiyatʉ ke e'pana e'tɨ' ta'pʉ to' pɨ', mɨrɨpan uya Papa inserʉʉi uya tenpa'kasa' pariki'si tapai rʉ'pʉ ekama'pʉ. “Serɨ mekamatʉi' Isens pɨ' mɨrɨ awonsi'kɨ tʉron kon ɨtonpa kon amʉ' pɨ',” ta'pʉ iya. Mɨrɨ tʉpo, tʉron nɨ pata ya' itɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Mɨrɨ ema'sa' yau, soisa amʉ' utaipo'pʉ ipan pe rɨ, apʉne pʉra ɨ'rɨ kasa Pi'ta epa'ka'pʉ tukai' to' uya i'tu pʉra rɨ iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Era' uya soisa amʉ' apiyo'ma'pʉ Pi'ta warinpato' pe to' uya, e'tane to' uya eporo pʉra iyesi'pʉ. Mɨrɨ pɨ' to' ekama'popɨtʉ'pʉ iya, ɨ'rɨ kasa Pi'ta epa'ka'pʉ tukai', e'tane to' nekama ton pʉra rɨ iyesi'pʉ, mɨrɨpan uya tʉron kon soisa amʉ' apiyo'ma'pʉ Pi'ta erasuntɨnin nan pe iku'sa' kon nʉ'san wɨto' pe to' uya. Mɨrɨ tʉpo, Era' utɨ'pʉ Sisariya pona Isutiya ponsi'kɨ, mɨrɨpan uko'mamʉ'pʉ inke rʉ'kwɨ rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Era' usakorota'pʉ ipan pe rɨ Taya mɨrɨ awonsi'kɨ Saitan pon kon ka'pon amʉ' pɨ'. Tʉron kon ka'pon amʉ' Taya mɨrɨ awonsi'kɨ Saitan pon kon tonpa ton utɨ'pʉ Era' ense'na. Era' poitorʉ, eke pe kuru te'sen Pʉrastas e'to' pe tʉmaimu kon awɨrɨ kin Era' auro'kato' pe to' uya ekama'po'pʉ, tʉpata'se' kon yawon kon ka'pon amʉ' e'to' pe wakʉ pe kin a'kɨrɨ tukai', apʉne pʉra kin pata'se' apai ti'kiyari kon eponin nan pe te'to' kon pe. ");
INSERT INTO akeNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Tʉweyu pe tʉneporo'pʉ a'tai, Era' uya tʉpon pata'tɨ'pʉ kin pe tesi ekamanin, mɨrɨpan ereuta'pʉ tapon po, ka'pon amʉ' iyamʉrasa' kon auro'ka pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","“Pʉse rɨ kʉrɨ rɨ Papa nʉsauro'ai'ne', ka'pon pen nɨ!” tukai', ka'pon amʉ' ukɨ'pɨ'nʉnpɨtʉ'pʉ Era' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Inke pʉra Papa inserʉʉi uya eno'ma'pʉ non pona, apʉne pʉra ka'pon amʉ' uya tapurɨ i'se iyesi wenai mɨrɨ awonsi'kɨ Papa ru'ku inamatɨ' ta iya kasa pʉra. Mɨrɨpan anɨ'pʉ weruwe amʉ' uya, mɨrɨpan erikʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","E'tane Papa maimu rɨ esi'pʉ miyarɨ rɨ utɨn pɨ' mɨrɨ awonsi'kɨ epan nɨ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Tʉtʉrawasooi kon u'ma'sa' a'tai, Panapas mɨrɨ awonsi'kɨ Saarʉ pokon enna'po'pʉ Surusiran poi. Isaan, Ma' tato' nee'pʉ to' uya ta'kɨrɨ'nokon. ");
INSERT INTO akeNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiyo' po so'si tau te'san koro'tau, pu'kena' ton mɨrɨ awonsi'kɨ enupanin nan esi'pʉ. Kamoro si esi'pʉ Panapas; Simiyan, Mekoro tukai' to' nesakʉnʉ; Rusiyas, Sairini itese' pata winon; Manayen, kopʉna Era' isakon pe isemo'kasa' rʉ'pʉ; mɨrɨ awonsi'kɨ Saarʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Papa apurɨ pɨ' to' esi koro'tau, mɨrɨ awonsi'kɨ tʉuta're'tɨi' pʉra to' useruma koro'tau, Papa A'kwarʉ uya to' auro'ka'pʉ, “Inke pʉra serɨ pe Panapas mɨrɨ awonsi'kɨ Saarʉ pokon anʉntɨ', uyapiyo' ton pe, mɨrɨ awonsi'kɨ tʉkɨ'ma'pʉ uya 'nokon ya' ku'se'na to' utɨto' pe,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Mɨrɨpan tenta'nai' pʉra tʉuseruma kon tʉpo, mɨrɨ awonsi'kɨ tʉwɨpʉrema kon tʉpo, to' pona'ne temiyatʉ kon nonkapɨtʉ'pʉ to' uya to' pʉrema pe, mɨrɨpan kon ennoko'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Papa A'kwarʉ uya Panapas mɨrɨ awonsi'kɨ Saarʉ pokon ennoko'pʉ tu'kan pata yau'ne tʉnekamanʉ kon ekama pɨ'. To' utɨ'pʉ Antiyo' ponsi'kɨ Seru'siya pona, mɨrɨpan kon ekanwa'tɨ'pʉ, Saramis pona tʉutɨto' kon pe, Sai'pʉras opa'wʉri pon. ");
INSERT INTO akeNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Saramis po si tesi kon koro'tau, Esuwerʉ amʉ' usenupato' iwʉ' ta' to' utɨ'pʉ, Papa Maimu ekama'pʉ to' uya. Isaan Ma' esi'pʉ mɨrɨ to' a'kɨrɨ to' pika'tɨ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tanporo mɨrɨ opa'wʉ ti'ma'kai' to' usarɨ'pʉ, Pa'pos itese' pata eporo tʉuya'nokon pona rɨ. Mɨrɨ pata yau, Esuwerʉ enwoke' pe esii'ma akono pe te'sen esi'pʉ Parʉ-Sises itese'. ");
INSERT INTO akeNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Mɨrɨ opa'wʉ epuru pe te'sen, Sɨsiyas Paaros itese' a'kɨrɨ inke itɨpɨtʉ'pʉ. Kʉrɨ rɨ kopʉna esi'pʉ i'tunin kuru. Tikin nan ka'pon ennoko'pʉ iya Panapas mɨrɨ awonsi'kɨ Saarʉ kɨ'mase'na to' uye'to' pe tʉpiya', apʉne pʉra Papa Maimu ɨnetapai tesi pɨ'. Mɨrɨ a'tai, Panapas mɨrɨ awonsi'kɨ Saarʉ pokon utɨ'pʉ ipɨ' ekamase'na. ");
INSERT INTO akeNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","E'tane pʉse rɨ ka'pon, Erimas tato' ipɨ' Kiri' amʉ' maimu yau, enwoke' ta e'kwa pe esi'pʉ to' i'se pʉra, kopʉna auro'ka'pʉ iya Sises apurɨ iya namai'. ");
INSERT INTO akeNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Mɨrɨ a'tai Saarʉ, Paarʉ tukai' to' nesakʉnʉ uta'kwarʉ'tɨ'pʉ Wakʉ A'kwarʉ ke uya to'sa rɨ Erimas ene'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","mɨrɨpan uya, “Makoi kasa kuru me'ai'! Wakʉ pe te'sen ewaruma'tɨ auya! Kasi pe rɨ ka'pon amʉ' auro'ka auya, mɨrɨ awonsi'kɨ tʉron nɨ ton nɨ ɨri ton nɨ kupʉ auya to' pɨ'. I'napairon nɨ Papa eseru ensima i'se ɨwe'to' ereutanʉ'kɨ! ");
INSERT INTO akeNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Serɨ pe kuru Papa uya ɨkota'ma mɨrɨ, tenku'ne ɨyena mɨrɨ, mɨrɨpan inke kuru pʉra rɨ wʉi enu tense pʉra ɨuko'mamʉ mɨrɨ,” ta'pʉ Paarʉ uya ipɨ'. Inke pʉra rɨ, tenku'ne iyena'pʉ kapuru' mɨrɨ awonsi'kɨ ewarupɨ uyee'pʉ ipona, mɨrɨpan usarɨ'pʉ te'ma a'pɨtʉ i'se, ka'pon nɨ i'se iyesi'pʉ temiyatʉ pɨ' tanin oton. ");
INSERT INTO akeNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Paarʉ uya enwoke' auro'ka'pʉ iye'ku'sa' ipɨ' tense, kopʉna uya, “i'napairon,” ta'pʉ Sises ekareei pɨ'. Paarʉ mɨrɨ awonsi'kɨ Panapas nekamanʉ Sises ekareei pɨ' isewansiuka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Mɨrɨ tʉpo, Paarʉ mɨrɨ awonsi'kɨ iya'kɨrɨ te'san itonpa ton utɨ'pʉ kanau yai Pa'pos ponsi'kɨ Pɨrʉka, Panperiya awon pona. Mɨrɨ yau, Isaan Ma' uya to' nɨmɨ'pʉ. Surusiran pona iyenna'po'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pɨrʉka ponsi'kɨ to' utɨ'pʉ Antiyo', Pi'sitiya yawon pona. Sapa' a'tai, to' utɨ'pʉ Esuwerʉ amʉ' usenupato' iwʉ' ta', mɨrɨpan kon ereuta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Mosi' nʉmenuka'pʉ mɨrɨ awonsi'kɨ pu'kena' amʉ' nʉmenuka'pʉ usekama'pʉ tʉpo, Esuwerʉ amʉ' usenupato' iwʉ' epuru ton uya ka'pon ennoko'pʉ Paarʉ mɨrɨ awonsi'kɨ Panapas piya' tʉmaimu kon pe, mɨrɨpan uya, “Ina tonpa ton, ɨnʉ' rɨ esi a'tai asauro'pai tɨwɨ ka'pon amʉ' auro'kai' to' pori'ma pe,” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Mɨrɨ yau, Paarʉ e'mʉ'sa'ka'pʉ, temiyatʉ ari'ma'pʉ iya, e'pana to' e'to' pe, mɨrɨpan uya, “Utonpa ton, Esuwerʉ amʉ', mɨrɨ awonsi'kɨ Esuwerʉ amʉ' pen, Papa namanin nan, umaimu etatɨ'! ");
INSERT INTO akeNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Papa, urɨ'nokon Esuwerʉ amʉ' napurɨnʉ uya utamokori kon anʉmʉ'pʉ, mɨrɨpan kon epankasa' tʉuya, ka'kʉran pe to' esi koro'tau Isi' po. Inke rɨ tʉuko'mamʉ tʉpo, Papa uya tʉmeruntɨrʉ ke to' enpa'ka'pʉ mɨrɨ pata apai. ");
INSERT INTO akeNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Tʉmaimu awɨrɨ pʉra rɨ to' e'tane, to' nʉkupʉnʉ moronka pɨ' iyesi'pʉ 40 kaisa rɨ wʉipiya rɨmono' tau to' uko'mamʉ koro'tau. ");
INSERT INTO akeNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Papa uya to' pika'tɨ'pʉ 7 kaisaron kon tʉpataron kon Kenan pon kon ka'pon amʉ' enpa'kato' pe to' uya, mɨrɨpan uya to' nono tʉsa' uiwano' kon pe. ");
INSERT INTO akeNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Serɨ e'kupʉ'pʉ 450 kaisa rɨ wʉipiya yau iwa'ne rɨ. “Mɨrɨ tʉpo, Papa uya to' usewa'noma epuru pe te'ton kon anʉnpɨtʉ'pʉ, Sanwerʉ, pu'kena' pe te'sen ena to' epuru pe pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Mɨrɨ a'tai, tepuru kon pe kin i'se ka'pon amʉ' esi'pʉ. Mɨrɨpan Saarʉ, Kisi mu anʉmʉ'pʉ Papa uya kin pe, mɨrɨpan uko'mamʉ'pʉ 40 kaisa rɨ wʉipiya to' epuru pe. ");
INSERT INTO akeNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kin pe iye'to' yapai Saarʉ mo'ka tʉuya tʉpo, Papa uya Tepi' anʉmʉ'pʉ kin pe. Wakʉ pe kuru Papa usaurokʉ'pʉ ipɨ', ‘Eposa' uya man warawo' Tepi', Ise'si mu upori'manin pe te'sen ku'nin, i'se e'to' ku'to' iya oton mɨrɨ,’ ta'pʉ Papa uya. ");
INSERT INTO akeNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Papa uya Tepi' pa rʉ'pʉ, Sises ennoko'pʉ Esuwerʉ amʉ' pika'tɨse'na. Mɨrɨ kupʉ uya ta'pʉ tʉuya utamokori ton pɨ' awɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Sises e'sara'tɨ e'tʉrawasoman pɨ' rawɨrɨ, Isaan uya itekare ekama'pʉ tanporon kon Esuwerʉ awon kon pɨ', ɨri tʉnkupʉnʉ kon apai to' era'tɨto' pe, mɨrɨpan kon epa'taisimato' pe. ");
INSERT INTO akeNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Tʉtʉrawasooi i'ma'ka tʉuya winɨkʉi', Isaan uya to' ekama'popɨtʉ'pʉ, ‘Ɨnʉ' pe uku'atʉu? Ka'pon ennoko uya mɨrɨ, tasa' rʉ'pʉ Papa uya ipɨ' pe, uyekama auya'nokon serɨ, e'tane etatɨ', serɨ pe rɨ iyepʉ mɨrɨ e'tane isapatooi mʉ' ara'ka poken pʉra rɨ esi,’ ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Utonpa ton Esuwerʉ amʉ', Epʉra'an payan nʉ'san, Esuwerʉ amʉ' pen nɨ nɨrɨ Papa namanin nan, etatɨ'! Urɨ'nokon iwano' pe kuru Papa uya epika'tɨn nɨto' eseru ennoko'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Surusiran pon kon ka'pon amʉ' mɨrɨ awonsi'kɨ to' epuru ton uya i'tu pʉra iyesi'pʉ pʉse rɨ Sises esi pika'tɨnin pe tukai', mɨrɨ awonsi'kɨ pu'kena' amʉ' maimu Sapa' kaisa rɨ tʉusekamasen to'ka'nʉkʉ to' uya pʉra iyesi'pʉ, e'tane pu'kena' amʉ' uya ekama'pʉ awɨrɨ to' uya iwɨnɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Tu'kan kon nɨ ka'pon amʉ' usaurokʉ'pʉ, ‘Ɨri kupʉ Sises uya,’ tukai', e'tane iwɨto' ipɨkɨrɨ oton eporo to' uya pʉra iyesi'pʉ. Mɨrɨ rɨ e'tane, itepuru Paire' ekama'po'pʉ to' uya ima'tanʉ'to' pe iya. ");
INSERT INTO akeNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Pena rɨ pu'kena' ton nekama'pʉ kupʉ'pʉ ka'pon amʉ' uya mɨrɨ Sises pɨ'. To' uya iwɨnɨ'pʉ. Kurusu' pona to' uya ipokapɨtʉ'pʉ, mɨrɨpan mo'ka'pʉ tʉron kon uya kurusu' poi, mɨrɨpan emaika'pʉ to' uya tɨ' akasa' uruwai' pe ya'. ");
INSERT INTO akeNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","E'tane Papa uya i'mʉ'sa'ka'pʉ eri'nɨto' apai. ");
INSERT INTO akeNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Inke rɨ isenpoikapɨtʉ'pʉ ta'kɨrɨ Kiyarari ponsi'kɨ Surusiran pona itɨsa' kon enu ya', ka'pon amʉ' si ennin nʉ'san esi mɨrɨ tʉron kon ka'pon amʉ' pana ya' ekama pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Ina uya kanan si serɨ wakʉ kuru itekare ekama serɨ ɨpɨ'nokon. ‘Mɨrɨ kupʉ uya,’ ta'pʉ Papa uya utamokori kon pɨ' uta'ku'tɨsa' rʉ'pʉ ");
INSERT INTO akeNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","urɨ'nokon, to' payan non pɨ'. Mɨrɨ si ku'sa' iya Sises ti'mʉ'sa'kase Eren apon yau isakon pe te'sen Eren uya ekamasa' kasa, “‘Serɨ pe umu, tikin nan pe kuru ɨwesi mɨrɨ, ɨkʉipʉnʉ pe enasa' serɨ.’ ");
INSERT INTO akeNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Papa uya tʉmu i'mʉ'sa'ka'pʉ iyeri'sa' apai, mɨrɨpan eri'to' oton pen nɨ mɨrɨ enta'. Mɨrɨ pɨ', Papa uya utamokori kon amʉ' auro'ka'pʉ, “‘Ɨpika'tɨ uya 'nokon kuru mɨrɨ, umunkɨ amʉ', Tepi' auro'ka'pʉ uya awɨrɨ rɨ.’ ");
INSERT INTO akeNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Tepi' uya Kʉrai pɨ' Papa auro'kasa' tʉron nɨ Eren yau, “‘Ikɨtato' pe uyekepu nonka auya pen, apʉne pʉra wakʉ urɨ, ɨpoitorʉ ukɨta i'se pʉra ɨwesi.’ ");
INSERT INTO akeNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Tʉuko'mamʉ koro'tau, Tepi' uya, ikupʉ iya i'se Papa e'to' ku'pɨtʉ'pʉ. E'tane iyerikʉ'pʉ, ka'pon uya iu'na'tɨ'pʉ, itamokori ton esi'pʉ kasa rɨ, mɨrɨpan pun ukɨta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","E'tane kʉrɨ Papa nʉ'mʉ'sa'ka'pʉ iyerikʉ'pʉ yapai ukɨta'pʉ pen. ");
INSERT INTO akeNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Mɨrɨ pe iyesi pɨ', utonpa ton, i'tu auya'nokon i'se esi Sises poro makoi pɨ' usentu'man, usekama ɨpɨ'nokon. ");
INSERT INTO akeNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kʉrɨ rɨ poro tanporon kon apurɨnin nan ekoneka, tanporon nɨ ekonekan pokena' pen nɨ ipiyapai, Mosi' nʉmenuka'pʉ winɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mɨrɨ pe iyesi pɨ', ti'tui' e'tɨ', pu'kena' amʉ' nekama'pʉ e'kupʉ namai' ɨpɨ'nokon: ");
INSERT INTO akeNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“‘Etatɨ' ɨmiyamoro, Papa sapemanin nan! Ɨusewansiuka kon mɨrɨ Papa nʉkupʉnʉ tense mɨrɨ awonsi'kɨ ɨyeri'to' oton kon. Iku'to' uya oton aya'tai'nokon anapurɨnʉ ton kon pen nɨ ka'pon uya ekama tane ɨpɨ'nokon,’ tawon,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paarʉ mɨrɨ awonsi'kɨ Panapas uya Esuwerʉ amʉ' usenupato' iwʉ' nɨmɨ koro'tau, ka'pon amʉ' uya to' kɨ'ma'pʉ Sapa' a'tai to' uye'to' pe miyarɨ parɨ serɨ ton ekamase'na. ");
INSERT INTO akeNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ka'pon amʉ' e'nonkasa' a'tai, anpisin pe Esuwerʉ amʉ' mɨrɨ awonsi'kɨ Esuwerʉ amʉ' pen e'tane Papa namanin nan uya Paarʉ mɨrɨ awonsi'kɨ Panapas e'ma'pʉka'pʉ. Paarʉ mɨrɨ awonsi'kɨ Panapas uya to' auro'ka'pʉ, Papa uya wakʉ nonkasa' tʉpona'nokon awɨrɨ to' uko'manto' pe. ");
INSERT INTO akeNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Tʉron nɨ Sapa' a'tai, tu'ke rɨ anpisin pe Antiyo' pon kon amʉra'pʉ Esuwerʉ amʉ' usenupato' iwʉ' ta' Paarʉ mɨrɨ awonsi'kɨ Panapas usaurokʉ etase'na Itepuru Sises pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Esuwerʉ amʉ' ɨkɨnta'pʉ anpisin pe ka'pon amʉ' ene tʉuya'nokon a'tai, mɨrɨpan kon usaurokʉ'pʉ ɨri pe Paarʉ pa'nʉkʉ pe. ");
INSERT INTO akeNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Mɨrɨpan kon maimu eikʉ'pʉ Paarʉ mɨrɨ awonsi'kɨ Panapas uya te'namai' pʉra, “Sises ekareei, Papa winon ekamato' ina uya pe iyesi wapiya Esuwerʉ amʉ' pɨ', e'tane Papa Maimu ewaruma'tɨ auya'nokon, mɨrɨ uya ekama wakʉ tɨwɨrɨ uko'man nɨto' eponin nan pe pʉra rɨ tukai' ɨye'kupʉ kon. ");
INSERT INTO akeNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Apʉne pʉra Papa uya ina apiyontɨsa' ina uya iku'to' pe, “‘To' weyu pe ɨyennoko uya serɨ non emʉ' kaisaron kon ka'pon amʉ' pana'tɨse'na, to' pika'tɨnin pe urɨ esi pɨ',’ tukai',” ta'pʉ Paarʉ uya. ");
INSERT INTO akeNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Mɨrɨ eta Esuwerʉ amʉ' pen uya a'tai, to' epori'ma'pʉ. Papa Maimu inamato' uya. Esuwerʉ amʉ' pen, Papa nanʉmʉ'san tʉpiyau to' e'to' pe uya Sises ekareei apurɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Mɨrɨ a'tai, Itepuru maimu utɨ'pʉ tanporo mɨrɨ nono awɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Mɨrɨ e'tane tʉron kon Esuwerʉ amʉ' epuru ton uya, eke ton pe te'san ka'pon amʉ', mɨrɨ awonsi'kɨ Papa namanin nan uri'sami'si amʉ' uya Paarʉ mɨrɨ awonsi'kɨ Panapas ewaruma'tɨto' pe ikupʉ'pʉ. Kamoro Esuwerʉ amʉ' uya tʉron kon ka'pon amʉ' auro'ka'pʉ Paarʉ mɨrɨ awonsi'kɨ Panapas kota'mato' pe to' uya. Mɨrɨpan kon uya Paarʉ mɨrɨ awonsi'kɨ Panapas enpa'ka'pʉ tʉnono kon apai. ");
INSERT INTO akeNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Mɨrɨpan Paarʉ mɨrɨ awonsi'kɨ Panapas uya ti'ta kon poi non tɨutɨ'pʉ pata nɨmɨi'ma, Papa uya to' nonkasa' ekamanin pe, mɨrɨpan kon utɨ'pʉ Ai'koniyan pona, Antiyo' ponsi'kɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Mɨrɨ koro'tau, Sises apurɨnin nan uta'kwarʉ'tɨ'pʉ pori' ke mɨrɨ awonsi'kɨ Wakʉ A'kwarʉ ke. ");
INSERT INTO akeNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Te'to' kon kasa rɨ Ai'koniyan po, Paarʉ mɨrɨ awonsi'kɨ Panapas pokon utɨ'pʉ Esuwerʉ amʉ' usenupato' iwʉ' ta', mɨrɨpan kon uya wakʉ pe pori'ma' kuru rɨ itekare ekama'pʉ. Mɨrɨpan tu'ke rɨ Esuwerʉ amʉ' mɨrɨ awonsi'kɨ Esuwerʉ amʉ' pen nɨ nɨrɨ ena'pʉ Sises apurɨnin nan pe. ");
INSERT INTO akeNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","E'tane Esuwerʉ amʉ' itekare apurɨnin nan pen uya Esuwerʉ amʉ' pen tʉrʉnka'pʉ ɨri pe to' pɨ' to' e'ku'to' pe. ");
INSERT INTO akeNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Mɨrɨ yau, Paarʉ mɨrɨ awonsi'kɨ Panapas pokon uya wʉi apɨtʉ'pʉ inke rɨ. Enari'mʉra Sises ekareei ekama pɨ' to' esi'pʉ, i'napai rɨ wakʉ nonkasa' iya ekareei esi enpoikanin pe, to' repa'pʉ iya winɨ to' meruntɨrʉ ke, i'tuto' ipɨkɨrɨ mɨrɨ awonsi'kɨ a'kwarʉpɨ'nin ku'to' pe to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kamoro Ai'koniyan po tʉuko'mansan epantakapɨ'sa' esi'pʉ; tʉron kon uya enno'sa' kon apurɨ'pʉ, tʉron kon uya tʉron kon Esuwerʉ amʉ' apurɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Mɨrɨ yau, Esuwerʉ amʉ' pen mɨrɨ awonsi'kɨ Esuwerʉ amʉ' usaurokʉ'pʉ Paarʉ mɨrɨ awonsi'kɨ Panapas kota'mato', tepuru kon pokon pe to' e'kama'pʉ, tɨ' ke to' wɨto' pe tʉuya'nokon. ");
INSERT INTO akeNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","E'tane Paarʉ mɨrɨ awonsi'kɨ Panapas uya etasa' esi'pʉ, mɨrɨpan kon utɨ'pʉ tʉron nɨ pata pona, Restʉra, Terʉpi, mɨrɨ awonsi'kɨ iwoino' nan pata pona, Rai'koniya pata yau. ");
INSERT INTO akeNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Mɨrɨ yau tesi kon a'tai, itekare ekama pɨ' to' esi'pʉ ka'pon amʉ' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Restʉra po ka'pon esi'pʉ ise'mepɨ'sa' i'ta. Iyentusa' a'tai, mɨrɨ kasa rɨ iyesi'pʉ, mɨrɨpan usarɨ pʉra rɨ iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Paarʉ usaurokʉ Itepuru Sises pɨ' etapɨtʉ pɨ' iyesi'pʉ. Paarʉ uya enpɨtʉ'pʉ, mɨrɨpan ene'pʉ iya Itepuru Sises uya kuru upika'tɨ tukai' apurɨ'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Mɨrɨpan Paarʉ uya, “E'mʉ'sa'ka', utonpa!” ta'pʉ ipɨ' tʉukɨ'pɨ'nʉnse. Mɨrɨ etasa' tʉuya a'tai, iye'sanʉmʉ'pʉ, mɨrɨpan usarɨ'pʉ wakʉ pe. ");
INSERT INTO akeNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Paarʉ nʉkupʉ'pʉ tense, papa amʉ' tato' pe rɨ Paarʉ mɨrɨ awonsi'kɨ Panapas kupʉ'pʉ to' uya. Tʉmaimu kon, Rai'koniya pon kon maimu yau to' ukɨ'pɨ'nʉnpɨtʉ'pʉ, “Apʉne, entɨ'! Pʉsamoro ka'pon amʉ' esi mɨrɨ papa amʉ' pe, e'tane ka'pon amʉ' pe to' era'tɨsa', mɨrɨpan kon u'tɨsa' ka' winɨpai upika'tɨse'na'nokon!” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Mɨrɨ yau, Panapas esakʉ'pʉ to' uya Isus tukai', “Eke pe iyesi,” ta'pʉ to' uya, mɨrɨpan Paarʉ esakʉ'pʉ to' uya Ɨrʉmes tukai', apʉne pʉra tʉusauro'sen pe iyesi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Eke pata mʉra'ta yau rɨ to' use'mato', ɨpʉremato' iwʉ' esi'pʉ Isus itese' tepuru kon apurɨse'na ka'pon amʉ' utɨto' ita'. Mɨrɨpan to' use'mato' tʉrawasomanin uya Paarʉ mɨrɨ awonsi'kɨ Panapas nʉkupʉ'pʉ eta'pʉ. Mɨrɨpan uya asa'rɨ paka amʉ' nee'pʉ, pata ipʉrʉ to' i'mʉ woi, to' use'mato' tʉrawasomanin, mɨrɨ awonsi'kɨ ka'pon amʉ' esi'pʉ paka amʉ' ɨnwɨpai Paarʉ mɨrɨ awonsi'kɨ Panapas apurɨ pe tenta'nato' kon pe. ");
INSERT INTO akeNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Mɨrɨ yau, Paarʉ mɨrɨ awonsi'kɨ Panapas uya to' e'kamasa' i'tu'pʉ paka amʉ' wɨnɨ pɨ' tapurɨ kon pe to' po'tɨto' pe tʉuya'nokon, mɨrɨpan kon uya tʉpon kon pʉro'pon karapɨtʉ'pʉ, “Kane!” ta tʉuya'nokon e'kwa pe. To' eka'tumʉ'pʉ ka'pon amʉ' koro'ta' tʉukɨ'pɨ'nʉnpɨtʉi'ma'nokon, ");
INSERT INTO akeNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Ina tonpa ton, mɨrɨ kʉ'ku'tʉu! Ka'pon amʉ' rɨ marɨ ina, awarai'nokon nɨ marɨ! Emenna' itekare wakʉ kuru ekamai' ina uye'sa' ɨpɨ'nokon. Tʉron kon ika'sa' ton piyapai era'tɨtɨ'; i'napairon Papa piya' era'tɨtɨ'! To' uya ɨpika'tɨ kon pʉra iyesi. Kʉrɨ rɨ esi Papa pe, tanporon non koneka'pʉ iya tanporo ipo te'sen. Non koneka'pʉ iya, parau, tuna ton, ka' mɨrɨ awonsi'kɨ tanporo urɨ'nokon. ");
INSERT INTO akeNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Pena rɨ ɨmɨrɨ'nokon Esuwerʉ amʉ' pen esi'pʉ i'se rɨ ɨwe'to' kon apurɨ pɨ' Papa uya rɨ ɨyenpɨtʉ'pʉ kon, apʉne pʉra ti'tu auya'nokon pʉra iyesi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","E'tane si, tanporon kon ka'pon amʉ' enu ya' isenpoikasa', kʉrɨ rɨ uya wakʉ ton ke repan nɨsa' tukai' i'tu kon pa. Wakʉ ton nɨ ku'sa' iya ɨiwano' kon pe: tuna enno'sa' iya; tʉweyu a'tai iyepetato' pe ɨi'kiyari kon ku'sa' iya; eke pe rɨ kiyari ke ɨrepasa' iya 'nokon; mɨrɨ awonsi'kɨ pori' pe ɨku'sa' iya 'nokon,” ta'pʉ Paarʉ uya. ");
INSERT INTO akeNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","To' usaurokʉ eta'pʉ ka'pon amʉ' uya e'tane rɨ, to' ereutanʉkʉ i'se to' e'tane paka amʉ' wɨnɨ to' uya namai', to' ereutanʉkʉ to' uya poken pʉra iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Mɨrɨ a'tai, Esuwerʉ amʉ' Antiyo' mɨrɨ awonsi'kɨ Ai'koniyan pon kon uyee'pʉ, mɨrɨpan kon uya tʉwinɨkʉi'nokon to' mo'ka'pʉ. Mɨrɨpan kon uya tɨ' ke Paarʉ wɨpɨtʉ'pʉ. Iyeri'sa' pe tekamai', to' uya ipi'sikʉ'pʉ pata apai. ");
INSERT INTO akeNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","E'tane Sises apurɨnin nan utɨ'pʉ Paarʉ piya'. To' amʉra'pʉ iwoi. Iye'mʉ'sa'ka'pʉ, mɨrɨpan enna'po'pʉ pata pona to' a'kɨrɨ. Iyema'sa' yau, Paarʉ mɨrɨ awonsi'kɨ Panapas utɨ'pʉ Terʉpi pona Restʉra ponsi'kɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Mɨrɨ yau, to' uko'mamʉ'pʉ Sises ekareei Papa Maimu ekama pɨ'. Tu'kan kon nɨ kupʉ'pʉ to' uya Sises apurɨnin nan pe. Mɨrɨ tʉpo, enna'pon pɨ' to' e'sara'tɨ'pʉ Restʉra pona mɨrɨ awonsi'kɨ Ai'koniyan pona mɨrɨ awonsi'kɨ Antiyo' pona. ");
INSERT INTO akeNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pata kaisarɨ rɨ Sises apurɨnin nan epopɨtʉ'pʉ to' uya. To' meruntɨtanʉkʉ'pʉ to' uya, mɨrɨpan kon auro'ka'pʉ to' uya itekare pɨ' to' pori'ma pe, Sises rɨ apurɨ pɨ' to' uko'manto' pe. “Urɨ'nokon ekota'mato' pe iyesi Papa e'to' esa' wannɨ pe ya' epa'kan nɨto' pe,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paarʉ mɨrɨ awonsi'kɨ Panapas uya so'si epuru pe te'ton kon anʉmʉ'pʉ. Tʉwɨpʉremai' mɨrɨ awonsi'kɨ tenta'nai' pʉra tʉuserumai' to' tʉrʉ'pʉ to' uya to' napurɨnʉ Itepuru ena'. ");
INSERT INTO akeNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pi'sitiya itese' pata poro tʉutɨ kon tʉpo, Paarʉ mɨrɨ awonsi'kɨ Panapas utɨ'pʉ Panperiya pona. ");
INSERT INTO akeNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Mɨrɨpan kon uya Pɨrʉka itese' pata eporo'pʉ, to' uya Papa Maimu ekama'pʉ ka'pon amʉ' pɨ'. Mɨrɨ tʉpo, to' utɨ'pʉ parau e'pi pona, to' uya A'tariya itese' pata eporo'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","A'tariya ponsi'kɨ kanau yau, parau kau to' utɨ'pʉ Antiyo' pona rɨ marɨ te'sara'tɨ'pʉ kon ya'. Mɨrɨ yau, to' tʉrʉ'pʉ Papa uya wakʉ nonkasa' ya' to' tʉrawasooi to' uya enuka'nʉ'sa' na'ne' si ku'nin pe to' e'to' pe. ");
INSERT INTO akeNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antiyo' pona tʉuye'sa' kon a'tai, tanporo apurɨnin nan amʉranʉkʉ'pʉ to' uya. Papa nʉkupʉ'pʉ tʉporo'nokon ekama'pʉ to' uya to' pɨ', Esuwerʉ amʉ' pen uya apurɨto' pe ikupʉ'pʉ iya rʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Paarʉ mɨrɨ awonsi'kɨ Panapas pokon uko'manpɨtʉ'pʉ Antiyo' po inke rɨ kapʉi tenno'pɨ'se, Sises pɨ' enupasa' kon mɨrɨ pata yawon kon piyau. ");
INSERT INTO akeNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tʉron kon Sises apurɨnin nan utɨ'pʉ Isutiya yapai Antiyo' pona tʉtonpa kon enupase'na, “Ɨyun kon pi'pɨ puturʉkasa' auya'nokon a'tai rɨken, Mosi' nekama'pʉ awɨrɨ, Papa uya ɨpika'tɨ kon,” tase'na. ");
INSERT INTO akeNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Serɨ uya, Paarʉ mɨrɨ awonsi'kɨ Panapas pokon sakoropa'pʉ, mɨrɨpan pɨ' to' pokon pe to' e'sei'pɨtʉ'pʉ. Mɨrɨ a'tai, Paarʉ mɨrɨ awonsi'kɨ Panapas anʉmʉ'pʉ to' uya tʉron kon apurɨnin nan pokon pe, to' utɨto' pe Surusiran pona, enno'sa' kon mɨrɨ awonsi'kɨ so'si epuru ton ense'na to' utɨ'pʉ mɨrɨ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Apurɨnin nan uya to' ennoko'pʉ. To' utɨ koro'tau Pini'siya, Sameriya yawɨrɨ, Sises apurɨnin nan auro'ka'pʉ to' uya, “Esuwerʉ amʉ' pen enasa' man Sises apurɨnin nan pe,” tukai'. Tanporon kon epori'ma'pʉ ipan pe eta tʉuya'nokon a'tai. ");
INSERT INTO akeNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","To' uye'sa' a'tai Surusiran pona, to' ereutanʉkʉ'pʉ apurɨnin nan uya, enno'sa' kon mɨrɨ awonsi'kɨ so'si epuru ton uya. Mɨrɨ a'tai, Paarʉ mɨrɨ awonsi'kɨ Panapas uya to' pɨ' ekama'pʉ tanporo Papa nʉkupʉ'pʉ tʉporo'nokon Esuwerʉ amʉ' pen koro'tau. ");
INSERT INTO akeNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Mɨrɨ a'tai, Sises apurɨnin nan Pari'si amʉ' tonpa ton e'mʉ'sa'ka'pʉ, mɨrɨpan kon uya ta'pʉ, “Esuwerʉ amʉ' pen yun pi'pɨ puturʉkato' pe kuru rɨ iyesi mɨrɨ. Mosi' nekama'pʉ main apurɨto' pe to' uya ekama auya'nokon kuru mɨrɨ to' pɨ',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Serɨ pɨ' ɨsenuminkase'na itekare ekamai' enno'sa' kon mɨrɨ awonsi'kɨ so'si epuru ton amʉra'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Inke kuru tʉusaurokʉ kon tʉpo, Pi'ta e'mʉ'sa'ka'pʉ, ta'pʉ iya to' pɨ', “Utonpa ton, i'tu auya'nokon pena Papa uya uyanʉmʉ'pʉ ɨ'koro'tapai'nokon, Esuwerʉ amʉ' pen uya itekare etato' pe urɨ winɨ, to' uya apurɨto' pe nɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Papa, tanporon usenuminkato' i'tunin uya enpoika'pʉ Esuwerʉ amʉ' pen anʉmʉ tʉuya Wakʉ A'kwarʉ tʉrʉ tʉuya winɨ to' pona, urɨ'nokon pɨ' ikupʉ'pʉ tʉuya kasa. ");
INSERT INTO akeNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Tʉron nɨ pe uku'sa' iya 'nokon pʉra rɨ iyesi kamoro piyapai. To' ewan korʉka'pʉ iya to' uya apurɨto' winɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ɨ'rɨ pe ken si iyesi pɨ' Papa i'tupɨtʉ i'se ɨwesi kon? Sa'man pe rɨ Esuwerʉ amʉ' pen apurɨnin nan kupʉ i'se ɨwesi kon mɨrɨ, urɨ'nokon mɨrɨ awonsi'kɨ ukʉipʉnʉ kon nʉkupʉ'pʉ pen nɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kane! Apurɨ Itepuru Sises uya wakʉ nonkasa' poro epika'tɨn nɨsa', to' kasa rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tanporo iyamʉrasa' kon esi'pʉ e'pana Panapas mɨrɨ awonsi'kɨ Paarʉ eta pɨ' i'tuto' ipɨkɨrɨ mɨrɨ awonsi'kɨ a'kwarʉpɨ'nin ku'sa' Papa uya tʉporo'nokon Esuwerʉ amʉ' pen koro'tau ekama tane to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","To' e'nonkasa' a'tai, Isens usaurokʉ'pʉ, “Utonpa ton, uyetatɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saiman nekamayan ko upɨ'nokon, Esuwerʉ amʉ' pen pɨ' ‘aiko’ tato' tʉuya enpoika Papa uya, to' tonpa ton anʉmʉ tʉuya winɨ tʉmunkɨ pe to' e'to' pe. ");
INSERT INTO akeNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Serɨ si esi serɨ pena pu'kena' amʉ' nʉmenuka'pʉ awɨrɨ. Iye'menukasa' na'ne' kasa: ");
INSERT INTO akeNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“‘Serɨ tʉpo, enna'poto' oton Tepi' iwʉ' rʉ'pʉ uta'mo'kasa' konekase'na, mɨrɨpan a'motasa' amɨ uya emenna' pe, inna'po uya pena iyesi'pʉ kasa. ");
INSERT INTO akeNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Mɨrɨ a'tai, ka'pon amʉ' tonpa rʉ'san uya Itepuru warinpato' pe, tanporo kamoro Esuwerʉ amʉ' pen urɨ iwano' pe to' esi, tasa' Itepuru uya, serɨ ku'nin nʉ'pʉ uya’ ");
INSERT INTO akeNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Pena rɨ isi'tusa' rʉ'pʉ serɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Mɨrɨ pe iyesi pɨ', mɨrɨ pɨ' ekonekasa' man: sa'man pe iku'pai pʉra man Esuwerʉ amʉ' pen pona nera'tɨyai'ne' nan Papa winɨkʉi'. ");
INSERT INTO akeNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Mɨrɨ pe iyesi pɨ' to' ena' imenukapai'nokon, to' auro'kapai'nokon ɨri kiyari ika'sa' ena' itʉsa' pɨ' to' enta'na namai'; tekumai' makoi tʉku'se pʉra to' e'to' pe; terupatu'kai' iwɨsa' o' mɨrɨ awonsi'kɨ mʉnʉ'pan pɨ' to' enta'na namai'. ");
INSERT INTO akeNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Papa uya Mosi' repa'pʉ ike Main ekama pɨ' ka'pon amʉ' nʉko'manyan pena si'kɨrɨ rɨ, Sapa' kaisa rɨ usenupan nɨto' iwʉ' tau pata kaisarɨ rɨ serɨ pʉ'kʉ pona rɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Mɨrɨ a'tai, enno'sa' kon mɨrɨ awonsi'kɨ so'si epuru ton, tanporo so'si tawon kon pona rɨ nɨrɨ, wakʉ pe poken iyesi'pʉ ka'pon amʉ' anʉnto' pe to' uya tʉ'koro'tapai'nokon, mɨrɨpan kon uya to' ennoko'pʉ Antiyo' pona Paarʉ mɨrɨ awonsi'kɨ Panapas a'kɨrɨ. Asa'ron kon anʉmʉ'pʉ to' uya: Isutas, Pa'sapas tato'; mɨrɨ awonsi'kɨ Sairas, tʉtonpa kon epuru pe te'san. ");
INSERT INTO akeNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Mɨrɨpan kon enau kareta ennoko'pʉ to' uya se tawon si: “Ina, enno'sa' kon mɨrɨ awonsi'kɨ so'si epuru ton, ɨrunan kon uya, ‘Miyarɨ'nokon,’ ina tonpa ton pe iyenasa' kon Esuwerʉ amʉ' pen Antiyo', Siriya, Siri'siya pon kon. ");
INSERT INTO akeNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ina uya etasa' man ina nennoko'san pen nɨ utɨ'pʉ mɨrɨ ya' amanenpase'na'nokon, ɨusenuminkato' kon tʉmanenpai'. ");
INSERT INTO akeNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Mɨrɨ wenai, tanporo ina e'kupʉ'pʉ ka'pon amʉ' anʉmʉ pɨ', mɨrɨpan kon ennoko'pʉ ina uya ɨmiyamoro piya', Panapas mɨrɨ awonsi'kɨ Paarʉ pokon a'kɨrɨ, ");
INSERT INTO akeNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ka'pon amʉ' tʉuma'tato' kon pɨ' tenari'nʉnsan pen nɨ pena iyepa'kaka'sa' kon nɨ mɨrɨ yai, uyepuru kon Sises Kʉrai ese' wenai. ");
INSERT INTO akeNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","“Mɨrɨ pe iyesi pɨ', ina uya Isutas mɨrɨ awonsi'kɨ Sairas ennoko mɨrɨ, kareta ina nʉmenuka'pʉ enpoikase'na tʉnta kon yai. ");
INSERT INTO akeNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Wakʉ poken iyesi'pʉ Wakʉ A'kwarʉ mɨrɨ awonsi'kɨ ina pona, ɨmɨrɨ'nokon pona e'tape'ne' rɨ tʉrʉ namai' i'se e'nɨto' entai rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Papa tato' pe ipɨ' ika'sa' ena' use'man nɨsa' rʉ'pʉ pɨ' kenta'natʉu; mɨrɨ pona mʉn pɨ' kenta'natʉu, mɨrɨ awonsi'kɨ o' erupatu'kasa' rʉ'pʉ nɨrɨ; tekumai' nɨrɨ ke'makoimatʉu. Wakʉ pe ɨwesi kon mɨrɨ serɨ ton apanama'pʉ kon awɨron pe ɨwesi kon yau. Ɨisirɨ ina ne'nonkayan, wakʉ pe si tanporo mɨko'mantʉi',” tawon. ");
INSERT INTO akeNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Asakɨrɨ'nan kon warawo' amʉ' ennoko'pʉ to' uya Antiyo' pata pona. To' amʉrasa' a'tai tanporo so'si ta', kareta tʉrʉ'pʉ to' uya to' ena', ");
INSERT INTO akeNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","mɨrɨpan ekama to' uya a'tai, to' epori'ma'pʉ tʉpika'tɨnin kon pe main esi pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Mɨrɨ a'tai, Sairas mɨrɨ awonsi'kɨ Isutas, pu'kena' pe te'san uya eke pe rɨ to' pika'tɨ'pʉ. Meruntɨ pe rɨ tʉtonpa kon amʉ' kupʉ'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","To' uko'mamʉ tʉpo mɨrɨ yau, to' tonpa ton uya to' ennoko'pʉ tʉusewankamai' pʉra to' utɨto' pe tenno'nin nʉ'san kon piya'. ");
INSERT INTO akeNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Mɨrɨ e'tane, Sairas ekoneka'pʉ mɨrɨ yau rɨ tʉuko'manto' pe. ");
INSERT INTO akeNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","E'tane Paarʉ mɨrɨ awonsi'kɨ Panapas pokon e'nɨmɨ'pʉ Antiyo' po. Mɨrɨ yau, tu'kan kon pokon pe esii'ma enupan pɨ', mɨrɨ awonsi'kɨ Itepuru Sises maimu ekama pɨ' rɨ to' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Mɨrɨ tʉpo, Paarʉ uya ta'pʉ Panapas pɨ', “Enna'ponpai utonpa kon amʉ' ka'kʉranpase'na tanporo pata kaisarɨ Itepuru Maimu ekama ne'taine' awɨrɨ, ikupʉ to' uya ense'na,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Panapas esi'pʉ Isaan, Ma' tukai' tesa'sen arɨ i'se ta'kɨrɨ'nokon, ");
INSERT INTO akeNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","e'tane Paarʉ pona ipoken pʉra iyesi'pʉ, apʉne pʉra tʉnɨnsa' iya 'nokon pɨ' Panperiya yau iye'tʉrawasoma pʉra iyesi'pʉ to' a'kɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ipan pe ɨsɨ pe to' e'sei'pɨtʉ'pʉ. Mɨrɨ wenai, to' e'nonka'pʉ ɨsipiyapai; Panapas uya Ma' anʉmʉ'pʉ tisakon pe. To' utɨ'pʉ kanau yau Sai'pʉras pona; ");
INSERT INTO akeNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","e'tane Paarʉ uya Sairas anʉmʉ'pʉ. Sises apurɨnin nan uya to' tʉrʉ'pʉ Itepuru uya wakʉ nonkasa' ya'. Mɨrɨpan kon nin si utɨ'pʉ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","To' utɨ'pʉ Siriya mɨrɨ awonsi'kɨ Siri'siya awɨrɨ, apurɨnin nan meruntɨtanʉkʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paarʉ mɨrɨ awonsi'kɨ Sairas pokon utɨ'pʉ Siri'siya itese' pata ponsi'kɨ Terʉpi pona, mɨrɨpan kon utɨ'pʉ Restʉra pona Sises apurɨnin Temu'ti itese' pata'se' ya'. Isan esi'pʉ Esuwerʉ amʉ' tonpa pe, Sises apurɨnin, e'tane ikʉipʉnʉ esi'pʉ Kiri' pe. ");
INSERT INTO akeNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Itekare apurɨnin nan, Restʉra mɨrɨ awonsi'kɨ Ai'koniyan pon kon uya, “Wakʉ kʉrɨ rɨ Temu'ti,” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ta'kɨrɨ tʉron nɨ pata ya'ne Temu'ti mɨrɨ awonsi'kɨ Sairas anapai Paarʉ esi'pʉ, mɨrɨpan uya Temu'ti yun pi'pɨ puturʉka'pʉ. Mɨrɨ kupʉ'pʉ iya, Temu'ti uya ekamʉra mɨrɨ pata yau te'san Esuwerʉ amʉ' e'kupʉ emapu'tɨ namai', apʉne pʉra Esuwerʉ pe pʉra ikʉipʉnʉ esi uya iku'sa' pe pʉra to' uya i'tu'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Mɨrɨ yau, pata kaisa rɨ to' usarɨ'pʉ. Surusiran pon kon enno'sa' kon mɨrɨ awonsi'kɨ so'si epuru ton nʉkoneka'pʉ main Esuwerʉ amʉ' pen napurɨ ton pe iku'sa' ekama pɨ' to' esi'pʉ pata kaisa rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Mɨrɨ pɨ', Sises apurɨnin nan umeruntɨta'pʉ apurɨto' tʉuya'nokon yau, mɨrɨpan kon epirikʉ'pʉ tu'ke rɨ wʉi kaisa rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paarʉ mɨrɨ awonsi'kɨ itonpa ton utɨ'pʉ Pʉrekiya nono poro mɨrɨ awonsi'kɨ Kare'siya itese' pata epose'na, apʉne pʉra Wakʉ A'kwarʉ esi'pʉ Sises ekareei ekama to' uya i'se pʉra Eisa po. ");
INSERT INTO akeNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Paarʉ mɨrɨ awonsi'kɨ iya'kɨrɨ te'san uya Maisa itese' pata eposa' a'tai, Pi'tiniya itese' pata ya' itɨpai to' esi'pʉ, e'tane Sises A'kwarʉ esi'pʉ mɨrɨ ya' to' utɨ i'se pʉra. ");
INSERT INTO akeNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Mɨrɨ pe iyesi pɨ', to' utɨ'pʉ to'sarɨ rɨ Maisa poro, mɨrɨpan kon epa'ka'pʉ Tʉrowas pona. ");
INSERT INTO akeNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ewarupɨ nau, Papa uya ka'pon Ma'sitoniya pon ento' pe Paarʉ enu a'kwaka'pʉ. Ka'pon e'mʉ'sa'kasa' ene'pʉ iya ata'kwarʉkase'na, “Ma'sitoniya pona ina ipika'tɨtanʉ'kɨ,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paarʉ enu uta'kwaka'pʉ tʉpo, inke pʉra rɨ Ma'sitoniya pona tʉutɨto' kon pe ina e'kama'pʉ, apʉne pʉra ina uya i'tu'pʉ Papa esi mɨrɨ yau ina uya itekare ekama i'se tukai'. ");
INSERT INTO akeNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ina ekanwa'tɨ'pʉ kanau ya' Tʉrowas po, mɨrɨpan parau nɨ'kwɨrɨ'nʉkʉ'pʉ ina uya opa'wʉ Samo'tʉres itese' pona. Iyema'sa' yau, ina utɨ'pʉ Niya'pores itese' pata pona kanau yau. ");
INSERT INTO akeNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Mɨrɨ tʉpo, ina utɨ'pʉ makʉi' Piri'pai itese' pata pona, Roman amʉ' neporo'pʉ. Eke pe kuru serɨ pata esi'pʉ Ma'sitoniya po. Inke rʉ'kwɨ rɨ wʉi ina uko'manpɨtʉ'pʉ Piri'pai yau. ");
INSERT INTO akeNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ina utɨ'pʉ pata apai tuna tʉu'tɨsen e'pi pona Sapa' a'tai, Esuwerʉ amʉ' ɨpʉremato' pata'se' eporo i'se ina esi'pʉ. Ina ereutapɨtʉ'pʉ, mɨrɨpan usauro'nɨ pɨ' ina e'sara'tɨ'pʉ mɨrɨ yau, iyamʉrasa' kon uri'sami'si amʉ' pokon pe. ");
INSERT INTO akeNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mɨrɨ yau, tikin nan to' tonpa ina maimu eta pɨ' te'sen esi'pʉ, Retiya itese', Taya'tira itese' pata winon, tʉtariren pon atʉ kʉrʉpo'poma pɨ' te'sen. Retiya esi'pʉ Esuwerʉ amʉ' tonpa pen nɨ, e'tane rɨ Papa pɨ' tʉwɨpʉremasen pe iyesi'pʉ. Paarʉ nekamanʉ Sises ekareei apurɨto' pe iya Itepuru uya itewan a'koka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Retiya mɨrɨ awonsi'kɨ itiwʉ' tau te'san pa'taisima ina uya tʉpo, tiwʉ' ta' ina kɨ'ma'pʉ iya. “Itepuru Sises apurɨnin pe esi tukai' i'tu auya'nokon pɨ' si, uiwʉ' ta' ɨsi'tɨ',” ta'pʉ iya. Ina utɨto' pe tiwʉ' ta' ina kuu'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Tʉron nɨ a'tai, Esuwerʉ amʉ' ɨpʉremato' ya' ina utɨ a'tai, to' poitorʉ pe te'sen uri'san eporo'pʉ ina uya, makoi a'kwarʉ yen pe iyesi'pʉ, mɨrɨpan esi'pʉ pena rɨ te'ku'ton i'tunin pe. Itesa' pe te'san uya eke pe pʉrata eporo esi'pʉ, apʉne pʉra ka'pon amʉ' uya e'ma'pʉ to' ena' te'ku'sen ekamato' pe iya. ");
INSERT INTO akeNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Pʉse rɨ uri'san uya Paarʉ mɨrɨ awonsi'kɨ itonpa ton e'ma'pʉkapɨtʉ'pʉ inke ɨkɨ'pɨ'nʉnpɨtʉi'ma, “Pʉsamoro ka'pon amʉ' esi Eke Papa poitorʉ ton pe, mɨrɨpan kon uya epika'tɨn nɨto' eseru ekama!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Inke rɨ mɨrɨ ta pɨ' iyesi'pʉ Paarʉ tanpokʉmai', mɨrɨpan era'tɨ'pʉ makoi a'kwarʉ yen winɨkʉi', mɨrɨpan uya, “Sises Kʉrai ese' yau ayauro'ka uya, pʉse uri'san apai epa'ka'!” ta'pʉ. Mɨrɨ a'tai rɨ, makoi a'kwarʉ epa'ka'pʉ iyapai. ");
INSERT INTO akeNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Itesanon uya serɨ enta' tʉpʉrataai kon epoto' iya oton pen tukai' i'tusa' a'tai, Paarʉ mɨrɨ awonsi'kɨ Sairas a'si'pʉ to' uya. To' pi'sikʉ'pʉ to' uya kʉrʉpo'po pɨ' e'nɨto' pata'se' ya' eke ton pata esanon piya'. ");
INSERT INTO akeNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Roman amʉ' epuru ton piya' to' arɨ'pʉ to' uya, mɨrɨpan kon uya, “Esuwerʉ amʉ' pʉsamoro, e'tane upata'se' kon yawon kon ka'pon amʉ' anpokʉma to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Utonpa kon amʉ' enupa to' uya urɨ'nokon Roman amʉ' nʉkupʉnʉ pen nɨ ku'to' pe to' uya,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mɨrɨ yau, anpisin ton ka'pon amʉ' e'sara'tɨ'pʉ to' tonpa pe Paarʉ mɨrɨ awonsi'kɨ Sairas ewa'noma pɨ', mɨrɨpan itepuru ton uya soisa amʉ' apiyontɨ'pʉ to' pon kara'pɨ'to' pe to' uya, mɨrɨ awonsi'kɨ to' ari'po'pɨ'to' pe to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ɨsɨ pe to' ari'po'pɨtʉ tʉpo, Paarʉ mɨrɨ awonsi'kɨ Sairas a'si'pʉ to' uya pariki'si ta'. Itepuru ton uya to' a'sinin auro'ka'pʉ, wakʉ pe to' erasuntɨto' pe iya. ");
INSERT INTO akeNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Main etasa' tʉuya a'tai, i'na' kuru to' ennin uya to' ewonnʉkʉ'pʉ, mɨrɨpan uya yʉi akʉ'pɨ'sa' yai'ne to' pʉrakon amʉ' enpa'kapɨtʉ'pʉ, ti'si kon amʉ' amapɨtʉ to' uya namai'. ");
INSERT INTO akeNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Anomʉra' a'tai, Paarʉ mɨrɨ awonsi'kɨ Sairas esi'pʉ eke pe ɨpʉreman pɨ'. To' userenka'pʉ Papa apurɨpɨtʉ'pʉ to' uya, tʉron kon a'sisa' kon esi'pʉ to' etapɨtʉ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Mɨrɨ koro'tau, pana' pe tʉrʉ'pʉnʉ esi'pʉ, pariki'si usi'ki'ma'pʉ mɨrɨ, iyapon nɨ usi'ki'ma'pʉ. Inke pʉra rɨ, pariki'si mʉra'ta amʉ' uta'kokapɨtʉ'pʉ, mɨrɨ awonsi'kɨ a'sisa' kon auronpɨ'to' ike i'sen amʉ' emo'kapɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mɨrɨ a'tai, a'sisa' kon esa' upaka'pʉ, mɨrɨpan mʉra'ta amʉ' uta'kokapɨ'sa' tense, tʉsuparaai mo'ka'pʉ tʉutapurukato' pe ike, apʉne pʉra a'sisa' kon utɨpɨtʉ'pʉ tukai' tʉusenuminka ke. ");
INSERT INTO akeNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","“Ɨiwano' pe rɨ, katapurukai, tanporo rɨ serɨ yau ina man!” tukai' nin si Paarʉ ukɨ'pɨ'nʉnpɨtʉ'pʉ mɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tʉweyu nin si i'se a'sinin ukɨ'pɨ'nʉnpɨtʉ'pʉ mɨrɨ, mɨrɨpan ewomʉ'pʉ Paarʉ mɨrɨ awonsi'kɨ Sairas pokon rakʉi' iye'sekunka'pʉ e'tɨtɨtɨ'kai'ma. ");
INSERT INTO akeNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","To' enpa'ka'pʉ iya pariki'si tapai, mɨrɨpan kon pɨ', “Ɨ'rɨ kuru tʉku'se epika'tɨto' pe iyesi?” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Mɨrɨpan kon uya, “Itepuru Sises apurɨkɨ ɨyepika'tɨ pa, ɨmɨrɨ mɨrɨ awonsi'kɨ ɨiwʉ' tau te'san,” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Mɨrɨ yau, Paarʉ mɨrɨ awonsi'kɨ Sairas uya Itepuru Sises ekareei ekama'pʉ a'sinin mɨrɨ awonsi'kɨ itiwʉ' tawon kon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mɨrɨ a'tai rɨ, a'sinin uya to' arɨ'pʉ to' ari'po'pɨtʉ'pʉ pata'pʉ korʉkase'na. Inke pʉra rɨ mɨrɨ tʉpo, Paarʉ mɨrɨ awonsi'kɨ Sairas uya kʉrɨ rɨ mɨrɨ awonsi'kɨ itiwʉ' tawon kon pa'taisima'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Mɨrɨ yau Paarʉ mɨrɨ awonsi'kɨ Sairas arɨ'pʉ a'sinin uya tiwʉ' ta' to' a're'tɨi'. Papa apurɨ tʉuya pɨ' nin si ipan pe pori' pe iyesi'pʉ mɨrɨ, mɨrɨ awonsi'kɨ itonpa ton nɨ nɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Mɨrɨ ema'sa' yau, itepuru ton uya pʉresiman amʉ' ennoko'pʉ a'sinin piya'. “Tɨwɨ kamoro ka'pon amʉ' nʉtɨi,” tawon main esa' pe. ");
INSERT INTO akeNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Mɨrɨpan uya Paarʉ mɨrɨ awonsi'kɨ Sairas pɨ', “Itepuru amʉ' uya uyapiyontɨsa' man ɨyenno'to' kon pe uya, mɨrɨpan yau entantɨ' rɨ si, tʉusewankamai' pʉra,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","E'tane Paarʉ uya pʉresiman amʉ' maimu eikʉ'pʉ, “Ɨri ku'sa' ina uya pʉra rɨ iye'tane, soisa amʉ' uya anpisin koro'tau ina ari'po'pɨ'to' pe to' uya, to' auro'ka'pʉ! Roman amʉ' ina e'tane pariki'si ta' ina a'si'pʉ to' uya, mɨrɨpan kon esi ama'ai ina ennoko i'se. Kane! Tɨwɨ Roman amʉ' epuru ton nʉyepʉi ina enpa'kai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Mɨrɨ yau, pʉresiman amʉ' epuru ton enna'po'pʉ Paarʉ maimu rʉ'pʉ ekamai' Roman amʉ' epuru ton pɨ'. Roman amʉ' ina, tasa' Paarʉ mɨrɨ awonsi'kɨ Sairas uya etasa' tʉuya'nokon a'tai, to' usenari'pa'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Mɨrɨpan kon utɨ'pʉ to' pɨ' ɨri pe rɨ ina e'sa' man tase'na. Paarʉ mɨrɨ awonsi'kɨ Sairas enpa'ka'pʉ to' uya pariki'si tapai, mɨrɨpan kon pɨ', “Entantɨ',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pariki'si tapai tepa'ka kon tʉpo, Paarʉ mɨrɨ awonsi'kɨ Sairas pokon utɨ'pʉ Retiya iwʉ' ta', mɨrɨpan kon e'seporo'pʉ tʉtonpa kon amʉ' pokon pe. To' auro'ka tʉpo to' pori'ma pe, Paarʉ mɨrɨ awonsi'kɨ Sairas utɨ'pʉ Piri'pai apai. ");
INSERT INTO akeNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paarʉ mɨrɨ awonsi'kɨ Sairas utɨ'pʉ Anpi'pores mɨrɨ awonsi'kɨ A'poroniya pata ton awɨrɨ. Tesaroni'ka pata eposa' to' uya a'tai, Esuwerʉ amʉ' usenupato' iwʉ' eporo'pʉ to' uya mɨrɨ pata yau. ");
INSERT INTO akeNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Te'pɨ'to' kasa rɨ, Paarʉ utɨ'pʉ Esuwerʉ amʉ' usenupato' iwʉ' ta' osorʉwau Sapa' kaisa rɨ ka'pon amʉ' auro'ka pɨ' iyesi'pʉ iye'menukasa' itekare ke. ");
INSERT INTO akeNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Enpoika pɨ' iyesi'pʉ Kʉrai ekota'mato' pe iyesi'pʉ, ima'tato' pe iyesi'pʉ, mɨrɨ tʉpo iye'mʉ'sa'kato' pe terikʉ'pʉ apai iyesi'pʉ nɨrɨ. “Pʉse rɨ Sises kanyauro'kayatʉi'ne' esi mɨrɨ Kʉrai pe,” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Tʉron kon Esuwerʉ amʉ' ena'pʉ Paarʉ mɨrɨ awonsi'kɨ Sairas pokon tonpa pe, tu'kan kon nɨ Kiri' amʉ' Papa namanin nan pokon pe rɨ nɨrɨ, mɨrɨ awonsi'kɨ tʉnamai' te'san uri'sami'si amʉ' rɨ nɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","E'tane tʉron kon Esuwerʉ amʉ' ɨkɨnta'pʉ. Mɨrɨ a'tai, ɨri iteseru ton ka'pon amʉ' kan to' utɨ'pʉ kʉrʉpo'po pɨ' e'nɨ pata'se' apai. Mɨrɨ tʉpo, ka'pon amʉ' amʉranʉkʉ'pʉ to' uya, mɨrɨpan kon uya usewankaman nɨto' sara'tɨ'pʉ. Mɨrɨpan kon utɨ'pʉ Ise'sʉn iwʉ' ta' Paarʉ mɨrɨ awonsi'kɨ Sairas warinpai', to' ne'to' pe tʉuya'nokon tu'kan kon ka'pon amʉ' koro'ta'. ");
INSERT INTO akeNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","E'tane Paarʉ mɨrɨ awonsi'kɨ Sairas eporo'pʉ to' uya pen. Mɨrɨ wenai, Ise'sʉn pi'sikʉ'pʉ to' uya. Tʉron kon nɨrɨ Sises apurɨnin nan ne'sa' nɨrɨ to' uya esi'pʉ eke ton itepuru ton piya'. Tu'kan kon ka'pon amʉ' ukɨ'pɨ'nʉmʉ'pʉ, “Pʉsamoro manenpanin ku'nin nan pata yau uye'sa' man serɨ yau. ");
INSERT INTO akeNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ise'sʉn uya to' ereutanʉ'sa' tʉpiyau. Tu'kan nɨ kupʉ'pʉ to' uya kin Sisa uya tasa' poro pʉra. Ta to' uya moro man tʉron nɨ kin, Sises tukai' tesa'sen ta to' uya,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Serɨ etasa' pata epuru mɨrɨ awonsi'kɨ anpisin ka'pon amʉ' uya a'tai, to' e'sakoropa'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Mɨrɨ tʉpo, Ise'sʉn mɨrɨ awonsi'kɨ tʉron kon ka'pon amʉ' uya pʉrata tʉto' pe to' kupʉ'pʉ itepuru ton uya to' nonkato' pe to' utɨto' pe aka'ne' pe. ");
INSERT INTO akeNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ewarupɨ uye'sa' pe rɨ, to' tonpa ton uya Paarʉ mɨrɨ awonsi'kɨ Sairas ennoko'pʉ Pereya pata pona. Pereya pata eposa' tʉuya'nokon a'tai, Paarʉ mɨrɨ awonsi'kɨ Sairas pokon utɨ'pʉ Esuwerʉ amʉ' usenupato' iwʉ' ta'. ");
INSERT INTO akeNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Pereya pon kon Esuwerʉ amʉ' esi wakʉ pe parɨ iteseru, ɨsenupapai parɨ Tesaroni'ka pon kon ka'pon amʉ' entai, ipan pe Sises ekareei ɨnetapai to' esi'pʉ. Tɨwɨrɨ wʉi kaisa rɨ iye'menukasa' itekare warinpa pɨ' to' esi'pʉ, i'napai rɨ pe' Paarʉ uya tenupato' kon esi tukai'. ");
INSERT INTO akeNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Tu'ke kuru Esuwerʉ amʉ' uya itekare apurɨ'pʉ, mɨrɨ awonsi'kɨ eke ton Kiri' pasi ton mɨrɨ awonsi'kɨ warawoti'si amʉ' uya nɨrɨ apurɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Paarʉ uya Pereya po Papa Maimu ekama tukai' Esuwerʉ amʉ' Tesaroni'ka pon kon uya etasa' a'tai, to' kanan utɨ'pʉ ka'pon amʉ' tʉrʉnkase'na. ");
INSERT INTO akeNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","E'tane inke pʉra Paarʉ ennoko'pʉ itonpa ton uya tʉron nɨ pata ya', e'tane Sairas mɨrɨ awonsi'kɨ Temu'ti pokon uko'manpɨtʉ'pʉ Pereya po rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Paarʉ apʉrʉnpanin nʉ'san uya arɨ'pʉ A'tens itese' eke pata pona, mɨrɨpan kon enna'po'pʉ Pereya pona Paarʉ maimu esa' pe, “Inke pʉra parɨ Sairas mɨrɨ awonsi'kɨ Temu'ti pokon uya uyepoto' pe,” tawon. ");
INSERT INTO akeNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","To' enupɨkɨrɨ Paarʉ esi koro'tau A'tens po, ipan pe rɨ ekamʉra iye'kupʉ'pʉ ika'sa' ton ɨpʉreman nɨto' ton ipɨ' ene tʉuya a'tai mɨrɨ pata yau. ");
INSERT INTO akeNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Esuwerʉ amʉ' usenupato' iwʉ' tau, Esuwerʉ amʉ' mɨrɨ awonsi'kɨ Esuwerʉ amʉ' pen Papa namanin nan pokon pe usauro'nɨ pɨ' iyesi'pʉ, mɨrɨ awonsi'kɨ kʉrʉpo'po pɨ' e'nɨto' yau rɨ nɨrɨ, mɨrɨ ya' tʉutɨpɨ'san pokon pe wʉi kaisa rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Tʉron kon enupanin nan, E'pi'kuriyan tato' ton ipɨ' mɨrɨ awonsi'kɨ tʉron kon Si'towi' tato' kon esi'pʉ ipokon pe e'sei'pɨ' nɨ pɨ' inapurɨnʉ ton pɨ'. Tʉron kon pʉsamoro uya, “Ɨ'rɨ si ta pʉse iya'kwarʉ pʉn ka'pon uya?” ta'pʉ to' uya. Tʉron kon uya ta'pʉ, “Tʉron nɨ papa pɨ' ɨpʉreman nɨto' pe enupan nɨ iya, tʉron nɨ pata awon kon kasa,” ta'pʉ to' uya. Serɨ ta'pʉ ka'pon amʉ' uya, apʉne pʉra wakʉ Sises e'mʉ'sa'ka'pʉ ekareei ekama Paarʉ uya pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Mɨrɨ tʉpo, Paarʉ nee'pʉ to' uya Areyo'pakas itese' pata'se' ya'. Mɨrɨ yau, “Ina auro'ka' serɨ emenna' ɨyekareei ke,” ta'pʉ to' uya ipɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","“Ɨyekareei man ina netapɨtʉnʉ pe pʉra rɨ; mɨrɨ wenai, ɨ'rɨ kuru ta auya e'kwa pe iyesi tukai' ina pɨ' enpoikakɨ,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Tanporo A'tens mɨrɨ tʉpo ka'kʉran amʉ' mɨrɨ yau tʉuko'mansan esi'pʉ tʉweyu kon enno'pɨtʉ pɨ' emenna' itekare pɨ' usauro'nɨ pɨ'.) ");
INSERT INTO akeNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Mɨrɨ tʉpo, Paarʉ e'mʉ'sa'ka'pʉ ka'pon amʉ' amʉrasa' koro'tau, Areyo'pakas pata'se' yau, “A'tens pon kon ka'pon amʉ'! Ɨyene uya 'nokon tanporo rɨ ɨpʉreman iya'kwarʉ pe me'atʉi', ");
INSERT INTO akeNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","apʉne pʉra tanporo pata yau upinimʉ koro'tau, ɨwɨpʉremato' kon yau ene pɨ' ɨuse'mato' kon apon eporo'pʉ uya. Mɨrɨ pɨ' iye'menukasa' ensa' uya man, ‘Ti'tusen pen nɨ Papa ena',’ tawon. Serɨ pe si ɨni'tunʉ kon pen nɨ ɨpʉreman nɨto' ipɨ' ekareei ekama uya serɨ ɨpɨ'nokon. ");
INSERT INTO akeNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Papa, non konekanin nʉ'pʉ, tanporon Epʉn mɨrɨ awonsi'kɨ non esi itiwano' pe, mɨrɨpan uko'mamʉ pen ka'pon namɨ'pʉ temiyatʉ ke ɨutɨ tau. ");
INSERT INTO akeNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Papa esi mɨrɨ ka'pon uya tʉrepa enupɨkɨron pen, apʉne pʉra tanporon nɨ i'se iye'to' esi ipiyau, apʉne pʉra Papa kʉrɨ rɨ tanporon kon nɨ repanin uko'man nɨ a'kwarʉ ke. ");
INSERT INTO akeNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Tikin nan Papa nʉkaa'pʉ ka'pon winɨ, tu'ke ka'pon amʉ' epamʉ'pʉ serɨ non po, serɨ non emʉ' poro'ne to' uko'manto' pe. Pata weyu ton koneka'pʉ iya iye'to' awɨrɨ'ne. Pata ton nɨrɨ iye'to' airɨ'ne ka'pon uko'manto' yau pe'ne. ");
INSERT INTO akeNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Serɨ kupʉ'pʉ iya, to' uya tʉwarinpato' pe, to' uya rɨ iwarinpa tʉuya'nokon koro'tau epoto' pe, ɨnnɨ pʉra rɨ Papa e'tane upiyapai'nokon. ");
INSERT INTO akeNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Kʉrɨ rɨ uriya' uko'man nɨ, upinin nɨ, nurɨne e'nɨ.’ Imenukanin, ɨtonpa kon pe te'sen uya, ‘Urɨ'nokon kamoro ipayan nʉ'san,’ tasa' na'ne' kasa rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Papa nʉkoneka'san pe e'nɨ wenai, usenuminkan poken pʉra iyesi ika'sa' pe iyesi tukai'; korʉ, tɨ', mɨrɨ pe pʉra sirʉpa, ka'pon nʉkoneka'pʉ ɨpʉreman nɨto' pe e'tane nurɨne pʉra iyesi. ");
INSERT INTO akeNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Pena a'tai, ka'pon amʉ' uya ti'tu pʉra iyesi pɨ', Papa uya to' enpɨtʉ'pʉ, ɨ'rɨ pe to' tʉku'se pʉra rɨ. E'tane si serɨ pe, mɨ yawɨron kon nɨ ka'pon amʉ' pɨ', ‘Amakooi kon apai era'tɨka'tɨ'!’ ta iya. ");
INSERT INTO akeNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Apʉne pʉra tikin nɨ wʉi tʉweyu ku'sa' iya ka'pon amʉ' eseru aimenkato' tʉuya weyu pe, serɨ ku'ton ka'pon epoka'sa' Papa uya tiwano' pe ka'pon amʉ' uya apurɨto' pe. Papa uya tʉnanʉmʉ'pʉ enpoikasa' to' enu ya', i'mʉ'sa'ka tʉuya winɨ iyerikʉ'pʉ apai,” ta'pʉ Paarʉ uya. ");
INSERT INTO akeNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ka'pon amʉ' uya iyeri'sa' kon e'mʉ'sa'ka'pʉ ta iya eta a'tai, isapema pe to' uta'kɨrɨ'pʉ, e'tane tʉron kon uya, “Serɨ ekareei parɨ ɨnetapai ina man,” ta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Mɨrɨ tʉpo, Paarʉ epa'ka'pʉ usauro'nɨto' pata apai. ");
INSERT INTO akeNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Tu'kan kon pen nɨ ka'pon amʉ' ena'pʉ Paarʉ pɨkɨron kon pe, mɨrɨpan kon uya nɨrɨ Sises apurɨ'pʉ. To' koro'tau Sises apurɨnin pe iyenasa' ese' esi Tayano'siyas, Areyo'pakas itese' konsʉrʉ amʉ' tonpa pe te'sen, Tamares itese' nɨrɨ uri'san, mɨrɨ tʉpo tʉron kon uya rɨ nɨrɨ Sises apurɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Serɨ tʉpo, Paarʉ uya A'tens nɨmɨ'pʉ, mɨrɨpan tʉpo Koren pata pona itɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Mɨrɨ yau, A'kira itese', Esuwerʉ eporo'pʉ iya, Pontas pon, pena pʉra iye'sa' kon I'tari pata winɨpai tʉno'pʉ Pʉre'sira a'kɨrɨ, apʉne pʉra Roman pata epuru Kʉrautiyas itese' uya tanporo Esuwerʉ amʉ' epa'kato' pe tasa' pɨ'. Paarʉ utɨ'pʉ A'kira mɨrɨ awonsi'kɨ Pʉre'sira ense'na. ");
INSERT INTO akeNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Tʉkasa ta'porin ton ka'pɨ'nin pe to' esi wenai, to' piyau e'tʉrawasoman pɨ' iko'mamʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Tɨwɨrɨ Sapa' kaisa rɨ'ne Esuwerʉ amʉ' mɨrɨ awonsi'kɨ Kiri' amʉ' pokon pe itekare pɨ' usauro'nɨ pɨ' iyesi'pʉ, Sises esi pika'tɨnin pe enno'sa' tukai' to' enu ya' enpoika i'se tesi wenai. ");
INSERT INTO akeNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sairas mɨrɨ awonsi'kɨ Temu'ti uye'sa' a'tai Paarʉ piya' Ma'sitoniya pata apai, Paarʉ uya tʉweyu ennoko'pʉ itekare rɨken ekama pɨ' Esuwerʉ amʉ' pɨ', Sises, kʉrɨ rɨ Kʉrai, tukai' enpoika'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","E'tane Esuwerʉ amʉ' e'sara'tɨ a'tai ɨri pe, ipa'nʉkʉ pe Paarʉ pɨ' usauro'nɨ pɨ', Paarʉ uya tʉpon tɨutɨ'pʉ, Papa uya to' nonkasa' ekamanin pe. “Ɨiwano' kon pe rɨ aumakoita kon ɨmʉnʉ kon utɨ emapu'tɨ auya'nokon ke, urɨ iwano' pe pʉra iye'to' oton Papa uya ɨponi'sima kon a'tai. Serɨ apai utɨto' oton Esuwerʉ amʉ' pen piya',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Mɨrɨ tʉpo, Paarʉ utɨ'pʉ Ti'tiyas Isa'su'tas, Esuwerʉ pen iwʉ' ta' itekare ekamai'. Ti'tiyas Isa'su'tas esi'pʉ Papa pɨ' tʉwɨpʉremasen pe, Esuwerʉ amʉ' usenupato' iwʉ' piyawon itiwʉ'. ");
INSERT INTO akeNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kiri'pas, Esuwerʉ amʉ' usenupato' iwʉ' epuru, mɨrɨ awonsi'kɨ itiwʉ' tau te'san uya Sises apurɨ'pʉ. Tu'ke itekare etanin nʉ'san Koren pon kon uya apurɨ'pʉ, mɨrɨpan kon epa'taisima'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Tʉron nɨ a'tai ewarupɨ nau, Itepuru Sises uya Paarʉ auro'ka'pʉ itenu uta'kwakasa' yau, “Enari'ke' kesii. Asauro'kɨ rɨ. E'pana kesii, ");
INSERT INTO akeNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","apʉne pʉra aya'kɨrɨ e'ai' ɨnʉ' uya rɨ ɨwɨnɨ pen mɨrɨ, apʉne pʉra tu'ke ka'pon amʉ' man serɨ pata yau uyapurɨnin nan,” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Mɨrɨ a'tai, Paarʉ uko'mamʉ'pʉ tikin nɨ wʉipiya mɨrɨ awonsi'kɨ 6 kaisa rɨ kapʉi ipona Papa maimu ke to' enupa pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Kariyo esi a'tai Roman amʉ' kopʉnaai pe, A'kaya pata epuru pe a'samʉtʉ ya' tʉwenai, Esuwerʉ amʉ' uya Paarʉ a'si'pʉ, mɨrɨpan kon uya inee'pʉ ko'tʉ pɨ' e'nɨ iwʉ' ta'. ");
INSERT INTO akeNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“Pʉse rɨ ka'pon uya ka'pon amʉ' auro'ka Papa pɨ' to' ɨpʉremato' pe Main uya mɨrɨ kasa tasa' pʉra rɨ iye'tane,” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paarʉ e'sara'tɨ rawɨrɨ usauro'nɨ pɨ', Kariyo uya ta'pʉ Esuwerʉ amʉ' pɨ', “Ɨri kuru rɨ, ipokena' pen kuru rɨ ku'sa' Paarʉ uya wenai, ausaurokʉ kon a'tai amaimu kon setai'no. ");
INSERT INTO akeNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","E'tane se pe rɨ usekama'popɨ' nɨ main ton pɨ' mɨrɨ tʉpo ɨiwano' kon ɨyeseru kon, ɨiwano' kon pe rɨ ɨnkoneka'pʉ kon pɨ' rɨ ɨwesi kon wenai, ɨiwano' kon pe ikonekatɨ'. Serɨ waraino ɨyeseru kon aimenka uya pʉra man,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Mɨrɨ tʉpo, Kariyo uya to' enpa'ka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Mɨrɨpan kon era'tɨ'pʉ, Esuwerʉ amʉ' usenupato' iwʉ' epuru a'sise'na, Sostenes itese', mɨrɨpan arɨ'pʉ to' uya ko'tʉ pɨ' e'nɨto' iwʉ' tapai, mɨrɨpan ari'po'pɨtʉ'pʉ to' uya ko'tʉ pɨ' e'nɨto' iwʉ' pʉrorooi po. Mɨrɨ pɨ' Kariyo usewankama'pʉ pen nɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paarʉ uko'mamʉ'pʉ inke rʉ'kwɨ rɨ Koren pata po. Mɨrɨ yau, tʉtonpa ton tʉnɨnse itɨ'pʉ kanau epotorʉ'pʉ yau Siriya pona. Tʉutɨ rawɨrɨ, ti'pai kiriri'ka'pʉ iya, Papa auro'kasa' tʉuya pɨ', mɨrɨpan a'kɨrɨ Pʉre'sira mɨrɨ awonsi'kɨ A'kira e'sara'tɨ'pʉ itonpa pe. ");
INSERT INTO akeNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","To' uya E'pe'sas eporo'pʉ. Mɨrɨ yau, Paarʉ uya Pʉre'sira mɨrɨ awonsi'kɨ A'kira nɨmɨ'pʉ. Mɨrɨ yau, itɨ'pʉ Esuwerʉ amʉ' usenupato' iwʉ' ta', itekare pɨ' asauro'se'na Esuwerʉ amʉ' pokon pe. ");
INSERT INTO akeNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Inke parɨ iko'manto' pe to' uya ekama'po tane, e'pai pʉra iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","E'tane tʉutɨkapʉ a'tai, “Papa eseru pe iyesi yau, uyepʉ kanan mɨrɨ ɨpiya'nokon,” ta'pʉ iya to' pɨ'. Mɨrɨ tʉpo, iyekanwa'tɨ'pʉ kanau ya', mɨrɨpan utɨ'pʉ E'pe'sas poi. ");
INSERT INTO akeNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Paarʉ uya Sisariya eposa' a'tai, iyekanwaka'pʉ, “Miyarɨ!” ka'se'na Sises apurɨnin nan pɨ' Surusiran pona, mɨrɨ awonsi'kɨ iu'tɨ'pʉ Antiyo' pona. ");
INSERT INTO akeNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Antiyo' po inke rʉ'kwɨ rɨ kanan tesi tʉpo, itɨ'pʉ kanan mɨrɨ apai. Mɨrɨpan utɨ'pʉ Kare'siya mɨrɨ awonsi'kɨ Pʉresiya nono awɨrɨ'ne, mɨrɨpan uya Sises apurɨnin nan meruntɨtanʉkʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Mɨrɨ koro'tau, A'poros, Esuwerʉ pe te'sen, Arisantiriya pon uyee'pʉ E'pe'sas pona. Wakʉ pe kuru tʉusauro'sen ye', iye'menukasa' itekare i'tunin pe iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Papa eseru awɨrɨ kuru enupasa' pe iyesi'pʉ. Pana' pe kuru nɨrɨ tʉusauro'sen pe iyesi'pʉ, iye'to' poro kuru Itepuru Sises eseru pɨ' enupanin pe kuru nɨrɨ iyesi'pʉ. Isaan Pa'tes ekareei epa'taisiman tawon nɨken i'tunin pe iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","A'poros e'sara'tɨ'pʉ enari'mʉra Sises ekareei ekama pɨ' Esuwerʉ amʉ' usenupato' iwʉ' tau. Pʉre'sira mɨrɨ awonsi'kɨ A'kira uya etasa' a'tai, to' uya ikɨ'ma'pʉ tiwʉ' kon ta'. Mɨrɨ pata yau, wakʉ pe parɨ Papa eseru enpoika'pʉ to' uya ipana ya'. ");
INSERT INTO akeNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","A'poros esi a'tai ɨtɨpai A'kaya pata pona, E'pe'sas awon kon to' tonpa ton uya ipori'ma'pʉ miyarɨ parɨ itɨto' pe. To' uya kareta menuka'pʉ, mɨrɨ yau te'san Sises apurɨnin nan ena' to' uya ereutanʉ'to' pe. Ipan pe kuru pata eporo iya a'tai, kamoro wakʉ nonkasa' winɨ apurɨnin pe iyenasa' kon pika'tɨnin pe iyesi'pʉ, ");
INSERT INTO akeNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","apʉne pʉra pana' pe tʉusaurokʉ winɨ Esuwerʉ amʉ' a'kɨrɨ ipoken pʉra to' e'sa' tukai'. Iye'menukasa' itekare winɨpai enpoika'pʉ iya Sises esi Kʉrai pe tukai'. ");
INSERT INTO akeNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","A'poros esi koro'tau Koren po, Paarʉ uya makʉi' tʉutɨsen asanta anʉmʉ'pʉ, mɨrɨpan epa'ka'pʉ E'pe'sas pona. Mɨrɨ yau, Sises apurɨnin nan eporo'pʉ iya, ");
INSERT INTO akeNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","mɨrɨpan uya to' ekama'po'pʉ, “Wakʉ A'kwarʉ pe' mepotantʉu Sises apurɨsa' auya'nokon a'tai?” tukai'. “Kane, Wakʉ A'kwarʉ esi moro tukai' ina uya i'tusa' pʉra rɨ man,” tukai' to' uya imaimu eikʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paarʉ uya to' ekama'po'pʉ, “Ɨ'rɨ waraino epa'taisiman nɨto' ke ɨyepa'taisima'pʉ kon?” tukai'. “Isaan Pa'tes uya epa'taisiman nɨto' ke ka'pon amʉ' enupa'pʉ poro ina epa'taisimasa',” tukai' to' uya imaimu eikʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paarʉ uya to' maimu eikʉ'pʉ, “Isaan uya pa'taisiman nɨto' esi'pʉ mɨrɨ makoi yapai ka'pon amʉ' era'tɨto' pe, to' auro'ka'pʉ iya te'ma'pʉ pe tʉuye'sen Sises tapurɨi' to' e'to' pe,” ta'pʉ iya to' pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Serɨ etasa' to' uya a'tai, to' epa'taisima'pʉ Sises ese' yau. ");
INSERT INTO akeNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paarʉ uya temiyatʉ ton nonka'pʉ a'tai to' pona, Wakʉ A'kwarʉ uyee'pʉ to' pona'ne. Mɨrɨ a'tai, to' usaurokʉ'pʉ tʉron nɨ ton main yai'ne, mɨrɨpan kon uya Papa Maimu ekama'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","12 kaisa rɨ iye'to' airɨ rɨ to' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paarʉ utɨ'pʉ Esuwerʉ amʉ' usenupato' iwʉ' ta' E'pe'sas po, mɨrɨpan usaurokʉ'pʉ enari'mʉra osorʉwau kapʉi kaisa rɨ. To' pɨ' ipatakapɨtʉ'pʉ iya, to' uya ito'ka'nʉkʉ i'se tesi wenai, Papa e'to' esa' wannɨ pe pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","E'tane tʉron kon ka'pon amʉ' ena'pʉ main ɨnetapai pʉra. To' uya tewan kon sa'mantanʉkʉ'pʉ, mɨrɨpan kon usaurokʉ'pʉ ɨri pe Ite'ma awɨron kon pɨ' tu'kan kon ka'pon amʉ' koro'tau. Mɨrɨ pɨ' si Paarʉ uya to' nɨmɨ'pʉ, mɨrɨpan uya Sises pɨ' enupasa' kon arɨ'pʉ ta'kɨrɨ, mɨrɨpan kon esi'pʉ tʉusenupa kon pe usauro'pɨ' nɨ pɨ' tɨwɨrɨ wʉi kaisa rɨ Tiranas sikuruui tau. ");
INSERT INTO akeNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Serɨ kupʉ'pʉ Paarʉ uya mɨrɨ asa'rɨ wʉipiya kaisa rɨ. Mɨrɨ a'tai, tu'kan kon nʉ'kwɨ rɨ Esuwerʉ amʉ' mɨrɨ awonsi'kɨ Kiri' amʉ', eke Eisa awɨrɨ tʉuko'mansan uya Itepuru ekareei eta'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","E'pe'sas po Paarʉ esi a'tai, eke tʉrawaso e'kupʉ emapu'tɨ'pʉ Papa uya iporo. ");
INSERT INTO akeNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Enki'sa amʉ' mɨrɨ awonsi'kɨ pon ton nɨ Paarʉ napurɨpɨtʉ'pʉ rɨ apɨtʉ'pʉ to' uya e'ne' ton piya' to' epi'tɨpɨ'nin pe. Mɨrɨ a'tai, to' eparan apai to' usepi'tɨpɨtʉ'pʉ, makoi a'kwarʉ uya to' nonkapɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Mɨrɨ yau nɨrɨ, Esuwerʉ amʉ' esi'pʉ pata kaisa rɨ makoi a'kwarʉ pa'kapɨtʉ pɨ', Itepuru ese' tesa'pɨ'se makoi a'kwarʉ pa'ka i'se usi'tupɨ' nɨ pɨ' to' esi'pʉ. Ta to' uya, “Itepuru Sises ese' yau, Paarʉ itekareei nekamanʉ pe na'ne', kʉrɨ rɨ ese' yau epa'ka',” ta'pʉ to' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","7 kaisaron kon Sʉ'kepa, use'man nɨto' Papa ena' tʉrawasomanin nan epuru pe te'sen munkɨ amʉ' uya serɨ ku'pɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","E'tane, makoi a'kwarʉ uya to' maimu eikʉ'pʉ, “Sises si'tuyai', Paarʉ nɨrɨ si'tuyai', e'tane ɨnʉ' yan ken ɨmɨrɨ'nokon?” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Mɨrɨ a'tai, ka'pon makoi a'kwarʉ yen pe te'sen e'sanʉmʉ'pʉ 7 kaisaron kon ka'pon amʉ' pona to' entai tenai', ɨsɨ pe kuru rɨ to' wɨpɨtʉ'pʉ iya to' pon ton tʉkarapɨ'se, mɨrɨpan kon ainʉmʉ'pʉ itiwʉ' tapai, mʉn ennokoi'ma. ");
INSERT INTO akeNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Serɨ etasa' Esuwerʉ amʉ' mɨrɨ awonsi'kɨ Kiri' amʉ' tʉuko'mansan E'pe'sas po uya a'tai, ipan pe enari'ke' to' ena'pʉ. Mɨrɨ a'tai, ipan pe kuru Itepuru Sises ese' nama'pʉ to' uya imeruntɨrʉ wenai. ");
INSERT INTO akeNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Tu'kan kon Sises apurɨnin nan pe iyenasa' kon e'sara'tɨ'pʉ uye'nɨ pɨ', mɨrɨpan kon uya tʉmakooi kon ekama'pʉ tʉron kon apurɨnin nan pana ya'. ");
INSERT INTO akeNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Tu'kan kon piyai'san amʉ' eseru kupʉ pɨ' iko'mansa' kon uya tu'kan nɨ ɨri ekareei apon kareta amʉranʉkʉ'pʉ, mɨrɨpan po'tɨpɨtʉ'pʉ to' uya annau. Pʉrata pe kareta ton epe' i'tu'pʉ to' uya a'tai, 50,000 kaisa rɨ sirʉpa pun pe iyepa'ka'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Serɨ winɨ Itepuru Sises ekareei utɨ'pʉ miyarɨ rɨ pata yau, mɨrɨpan nɨrɨ usemo'ka'pʉ meruntɨ pe kuru. ");
INSERT INTO akeNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Serɨ ton e'kupʉ'pʉ tʉpo, Paarʉ e'kama'pʉ utɨn pɨ' Surusiran pona, Ma'sitoniya mɨrɨ awonsi'kɨ A'kaya poro, “Surusiran pona tʉutɨ'pʉ tʉpo, utɨ kuru mɨrɨ Ron pata pona,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Asa'ron kon, Temu'ti mɨrɨ awonsi'kɨ Erastas, tʉpika'tɨnin nan ennoko'pʉ iya tʉwapiya Ma'sitoniya pona inke rʉ'kwɨ parɨ ɨko'mamʉi'ma Eisa nono pata yau. ");
INSERT INTO akeNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Mɨrɨ a'tai, ipan nɨ anpokʉmanin e'sara'tɨ'pʉ Ite'ma awɨron kon pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","E'pe'sas po iyesi'pʉ ka'pon, Temi'tʉriyas itese', ɨpʉreman Arʉ'times pɨ' iwʉ' ka'pɨ'nin sirʉpa ke, mɨrɨpan tonpa ton uya eke pe kuru pʉrata epopɨtʉ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Temi'tʉriyas uya tʉtonpa ton kɨ'ma'pʉ, mɨrɨ waraino rɨ marɨ itʉrawasooi ton to' pokon pe tʉusauro'to' pe. Ta'pʉ iya, “Mi'tuyatʉu pe' utonpa ton, serɨ utʉrawasooi kon ikupʉ na'ne' winɨ eke pe pʉrata eporo uya'nokon? ");
INSERT INTO akeNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Miyarɨ rɨ ensa', etasa' auya'nokon E'pe'sas po rɨken pen, e'tane siya rɨ Eisa pata awɨrɨ, tu'kan kon ka'pon amʉ' uya apurɨto' pe Paarʉ uya iku'sa' ka'pon nʉkoneka'pʉ ɨpʉreman nɨto' ipɨ' pe esi papa pe pʉra rɨ ta iya. ");
INSERT INTO akeNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ɨsɨ esi mɨrɨ yau, miyarɨ rɨ Paarʉ uya tato' apurɨ pɨ' ka'pon amʉ' esi a'tai, urɨ'nokon nʉkupʉnʉ enato' oton tʉnamasen pe pʉra rɨ. Eke kuru uri'san papa tukai' tʉku'sen Arʉ'times iwʉ' enato' oton ka'pon amʉ' enu yau pʉra rɨ. Kamo rɨ nɨrɨ ika'sa' pɨ' tʉwɨpʉremasan Eisa pata awɨrɨ'ne, mɨrɨ awonsi'kɨ non emʉ' kaisa rɨ nɨrɨ inamato' pʉra rɨ iyenato' oton,” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Serɨ ta Temi'tʉriyas uya eta tʉuya'nokon a'tai, to' ena'pʉ sakoro' pe. Ukɨ'pɨ'nʉnpɨ' nɨ pɨ' to' e'sara'tɨ'pʉ, “Eke kʉrɨ rɨ papa tato' ipɨ' pe ika'sa', Arʉ'times, ɨpʉreman nɨto' kon ipɨ' E'pe'sas po!” tukai'. ");
INSERT INTO akeNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Mɨrɨ pe rɨ, eke utanpokʉman esi'pʉ mɨrɨ pata yau. Ka'pon amʉ' uya Kayas mɨrɨ awonsi'kɨ Aresta'kos a'si'pʉ, Paarʉ upinimʉ tonpa pe te'san. Mɨrɨ a'tai, anpisin ka'pon amʉ' enasa' tikin nɨ uya Kayas mɨrɨ awonsi'kɨ Aresta'kos pi'sikʉ'pʉ amʉran nɨto' iwʉ' ta'. ");
INSERT INTO akeNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Mɨrɨ a'tai, Paarʉ esi'pʉ ka'pon amʉ' anauro'kapai e'tane, Sises apurɨnin nan esi'pʉ itɨ i'se pʉra. ");
INSERT INTO akeNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Kamoro nɨrɨ eke pata epuru ton, Paarʉ mai'pʉremu ton uya main ennoko'pʉ itɨ namai'. ");
INSERT INTO akeNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Iyamʉrasa' kon esi'pʉ ɨsɨ pe ukɨ'pɨ'nʉnpɨ' nɨ pɨ'; tʉron kon esi'pʉ tʉron nɨ pe ukɨ'pɨ'nʉnpɨ' nɨ pɨ'; tʉron kon nɨrɨ, tʉron nɨ pe rɨ. Mɨrɨ yawon kon tu'kan kon ka'pon amʉ' uya ɨ'rɨ pe iyesi pɨ' to' amʉrasa' mɨrɨ yau tukai' i'tu pʉra rɨ iyesi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Tʉron kon Esuwerʉ amʉ' uya Arisanta itese' ka'pon a'tu'ma'pʉ amʉran nɨto' iwʉ' tau, ka'pon amʉ' rau iye'mʉ'sa'kato' pe. Tʉron kon ka'pon amʉ' anpisin koro'tau te'san ukɨ'pɨ'nʉmʉ'pʉ Arisanta auro'ka pe. Arisanta uya temiyatʉ anʉmʉ'pʉ, e'pana e'tɨ' ta tʉuya e'kwa pe, tiwano' pe rɨ tʉusaurokʉ wenai. ");
INSERT INTO akeNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","E'tane Esuwerʉ pe to' uya ito'ka'nʉ'sa' a'tai, isaurokʉ i'se pʉra to' esi'pʉ. Tikin nɨ te'sepose to' ukɨ'pɨ'nʉmʉ'pʉ asa' ite'kwa kʉra' emiya era'tɨto' e'to' poro, “Eke kʉrɨ rɨ Arʉ'times E'pe'sas pon kon iwano'!” tai'ma. ");
INSERT INTO akeNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Pata karetaai menukapɨ'nin uya anpisin e'paka'nʉkʉ'pʉ. “E'pe'sas pon kon ka'pon amʉ'! I'tu auya'nokon pʉra pe' nai tanporo mɨ awɨron pata uya i'tu E'pe'sas esi eke Arʉ'times pɨ' ɨpʉreman nɨto' iwʉ' erasu pe te'san pe tukai'? Mɨrɨ nɨrɨ ipe ika'sa' Epʉn winɨ ita'mo'kasa' erasuntɨnin pe e'nɨ'nokon tukai'. ");
INSERT INTO akeNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Mɨrɨ wenai, serɨ ton esi ke onamʉ poken pʉra, e'pana ɨwe'to' kon pe iyesi, tʉusenuminkai' pʉra ɨ'rɨ rɨ tʉku'se pʉra. ");
INSERT INTO akeNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Serɨ uya rɨ pʉsamoro asa'ron kon ka'pon amʉ' ne'to' auya'nokon wenai pe pʉra iyesi'pʉ man. Ɨpʉreman nɨto' yawon ama'masa' mɨrɨ awonsi'kɨ ika'sa' itese' pɨ' e'nɨto' pe pa'nʉ'sa' to' uya pʉra iyesi nɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","E'tane Temi'tʉriyas mɨrɨ awonsi'kɨ ɨpʉreman nɨto' ku'pɨ'nin nan uya pata eseru main i'kwɨ'sa' pe iyesi yau, serɨ rupɨ konekato' esi moro rɨ. Mɨrɨ yau, konekanin nan eke ton esi. Mɨrɨ yau, to' utɨto' pe iyesi teseru kon konekai'. ");
INSERT INTO akeNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","E'tane miyarɨ rɨ ɨri i'se ɨwesi kon yau, ikonekato' pe iyesi pata eseru uya tasa' awɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ɨsɨ yau e'nɨ'nokon man, apʉne pʉra Roman amʉ' uya uyekama'popɨtʉ kon mɨrɨ serɨ pe ne'kupʉine' pɨ'. Ɨ'rɨ wenai ɨsɨ pe ukɨ'pɨ'nʉnpɨ' nɨ esi'pʉ tukai', ekama ton pʉra iye'tane mɨrɨ wenai tukai',” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Serɨ ta'pʉ iya tʉpo, iyamʉrasa' kon nin si ka'pon amʉ' ennoko'pʉ iya mɨrɨ, mɨrɨ apai. ");
INSERT INTO akeNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ɨsɨ pe ukɨ'pɨ'nʉnpɨ' nɨ ereutasa' tʉpo, Paarʉ uya tʉtonpa ton kɨ'ma'pʉ, mɨrɨpan kon pori'mapɨtʉ tʉpo, Paarʉ uya, “Ɨisirɨ utɨyai',” ta'pʉ to' pɨ', mɨrɨpan utɨ'pʉ Ma'sitoniya pona, to' tʉnɨnse E'pe'sas po. ");
INSERT INTO akeNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Mɨrɨ awɨrɨ rɨ, itɨ'pʉ. Eke pe rɨ ka'pon amʉ' pori'ma'pʉ iya, tu'kan pɨ' rɨ, mɨrɨpan uyee'pʉ Kiris pona. ");
INSERT INTO akeNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Mɨrɨ yau, iko'mamʉ'pʉ osorʉwau kapʉi. Iye'kama koro'tau kanau epotorʉ'pʉ yau utɨn pɨ' Siriya pona, Esuwerʉ amʉ' ekonekasa' eta'pʉ iya ipɨ' te'to' kon pe. Mɨrɨ pe iyesi pɨ', iyekoneka'pʉ tenna'poto' pe Ma'sitoniya poro. ");
INSERT INTO akeNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Iya'kɨron kon esi'pʉ So'pa'tarʉ, Piros mu, Pereya winon; Aresta'kos, Sekuntos, Tesaroni'ka winon kon; Kayas, Terʉpi winon; Tai'ki'kas, Tʉro'pimas, Eisa winon kon; Temu'ti nɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Pʉsamoro warawo' amʉ' utɨ'pʉ ina rawɨrɨ to' esi'pʉ ina enupɨkɨrɨ Tʉrowas po. ");
INSERT INTO akeNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","E'tane ina utɨ'pʉ kanau yau Piri'pai yapai A'sarutanʉ'sa' Pen Pʉreti Pɨ' Enta'nan Weyu tʉpo. 5 kaisa rɨ wʉi tʉpo, ina e'seporo'pʉ tʉron kon a'kɨrɨ Tʉrowas po. Mɨrɨ yau, ina uko'mamʉ'pʉ 7 kaisa rɨ wʉi. ");
INSERT INTO akeNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Suntaaka e'sara'tɨ pe, ina amʉra'pʉ pʉreti pɨ' enta'nai'. Paarʉ uya ka'pon amʉ' auro'ka'pʉ. Awanapai rɨ tʉutɨto' esi pɨ' isaurokʉ'pʉ anomʉra' pona rɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Mɨrɨ yau, tu'ke raan'pu amʉ' esi'pʉ ka'tawon tau ina amʉrato' yau. ");
INSERT INTO akeNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Moine ka'pon ereutasa' esi'pʉ winto po, Iu'tai'kos itese'. Kʉrɨ rɨ e'nʉnpɨtʉ'pʉ, miyarɨ rɨ Paarʉ usaurokʉ koro'tau, mɨrɨpan e'nʉnkaa'pʉ ipan pe, nʉta'mo'kai osorʉwawon ikawono ɨutɨ apai. Mɨrɨpan uma'tasa' anʉmʉ'pʉ to' uya eke' pe. ");
INSERT INTO akeNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paarʉ u'tɨ'pʉ, mɨrɨpan ena'pʉ ipʉro'pona, temiyatʉ tʉrʉ'pʉ iya iwoi, “Ipan pe kuru kɨsewankamatʉu! Nurɨne rɨ man!” ta'pʉ iya. ");
INSERT INTO akeNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Mɨrɨ tʉpo kanan, ka'ta' iyenuku'pʉ pʉreti pɨ' enta'nai'. Pata tema'kwai' tʉusaurokʉ tʉpo, itɨ'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ka'pon amʉ' uya moine arɨ'pʉ nurɨne. Ipan pe kuru pori' pe to' epori'masa' esi'pʉ. ");
INSERT INTO akeNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ina utɨ'pʉ kanau yau A'sos pona. Mɨrɨ yau, Paarʉ anʉnse'na ina utɨ'pʉ. “Mɨrɨ yau uyepotʉi',” ta'pʉ iya a'mun po tʉutɨ pɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ina eposa' iya a'tai A'sos po, ina uya arɨ'pʉ Me'tirin pona. ");
INSERT INTO akeNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Mɨrɨ ema'sa' yau, ina utɨ'pʉ mɨrɨ apai Kiyos pona. Mɨrɨ tʉpo, ina e'kwɨrɨtʉ'pʉ Samos pona; mɨrɨ ema'sa' yau, Mairi'tos eporo'pʉ ina uya. ");
INSERT INTO akeNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paarʉ e'ku'sa' esi'pʉ E'pe'sas entakato' pe tʉuya kanau yau, inke ɨko'manpai pʉra iyesi'pʉ Eisa po. Surusiran ɨnepopai isenutɨ'pʉ Penti'kas weyu a'tai. ");
INSERT INTO akeNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mairi'tos ponsi'kɨ, E'pe'sas so'sii epuru ton kɨ'ma'pʉ Paarʉ uya. ");
INSERT INTO akeNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","To' uya teposa' a'tai, ta'pʉ iya to' pɨ'; “Uko'mamʉ'pʉ eseru i'tu auya'nokon mɨrɨ ɨpiyau'nokon Eisa po esi a'tai. ");
INSERT INTO akeNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Itepuru apiyo' pe esi'pʉ se pe rɨ tenai', tʉukaranpɨ'se nɨrɨ, sa'man pe rɨ Esuwerʉ amʉ' uya ukota'ma tane. ");
INSERT INTO akeNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","I'tu auya'nokon mɨrɨ, tanporo unekamanʉ ekama'pʉ uya ɨpika'tɨnin kon pe te'sen, ɨyenupa'pʉ uya 'nokon annau'ne rɨ, ɨiwʉ' kon tau'ne nɨrɨ. ");
INSERT INTO akeNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Enpoika'pʉ uya Esuwerʉ amʉ', Kiri' amʉ' pɨ' nɨrɨ tʉmakooi kon pɨ' to' usewankama era'tɨto' pe Papa winɨkʉi', Sises yau apurɨto' esa' pe to' enato' pe. ");
INSERT INTO akeNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Serɨ si Papa A'kwarʉ uya tapiyo'mai', utɨ si serɨ Surusiran pona, ɨ'rɨ e'kupʉ upɨ' mɨrɨ yau tukai' i'tui'ma pʉra. ");
INSERT INTO akeNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Se rɨken i'tu uya tanporo pata yau'ne Wakʉ A'kwarʉ uya upana'tɨ. Mɨrɨ yau, pariki'si ta' uya'sito', mɨrɨ awonsi'kɨ sa'man nɨ e'ku'to' esi upɨ'. ");
INSERT INTO akeNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","E'tane usewankama pʉra rɨ iyesi uwɨnin nan pɨ', utʉrawasooi ɨnku'pai esi Itepuru Sises nʉtʉrʉ'pʉ iku'to' pe uya utʉrawasooi, tanporon kon pɨ' Papa uya wakʉ nonkasa' ekareei ekamato' uya. ");
INSERT INTO akeNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Si'tuyai' ɨmɨrɨ'nokon serɨ itekare, Papa e'to' esa' wannɨ pe ekama'pʉ uya ipana ya' ton uya uyento' oton pen serɨ enta'. ");
INSERT INTO akeNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Mɨrɨ pe iyesi pɨ', ekama uya ɨpɨ'nokon serɨ pe; makoi pʉra esi tanporon kon ka'pon amʉ' mʉnʉ piyapai