﻿USE sofia;
DROP TABLE IF EXISTS sofia.aii_vpl;
CREATE TABLE aii_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES aii_vpl WRITE;
INSERT INTO aii_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","ܛܘܼܒ݂ܵܐ ܠܐܢܵܫܵܐ ܕܒܡܸܠܟܵܐ ܕܒܝܼܫܹ̈ܐ ܠܵܐ ܚܕܝܼܪܹܗ، ܘܒܐܘܼܪܚܵܐ ܕܚܲܛܵܝܹ̈ܐ ܠܵܐ ܟܠܹܐ ܠܹܗ، ܘܒܡܵܘܬܒ݂ܵܐ ܕܡܲܣܚܸܪ̈ܵܢܹܐ ܠܵܐ ܝܬܝܼܒ݂ ܠܹܗ؛ ");
INSERT INTO aii_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","ܐܸܠܵܐ ܒܢܵܡܘܿܣܵܐ ܕܡܵܪܝܵܐ ܝܠܹܗ ܒܘܼܣܵܡܹܗ، ܘܒܢܵܡܘܿܣܹܗ ܟܹܐ ܗܲܓܹܐ ܐܝܼܡܵܡܵܐ ܘܠܲܝܠܹܐ؛ ");
INSERT INTO aii_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","ܒܸܬ ܗܵܘܹܐ ܐܲܝܟ݂ ܐܝܼܠܵܢܵܐ ܫܬܝܼܠܵܐ ܥܲܠܔ ܫܵܩ̈ܝܼܵܬܹ‌ܐ ܕܡ̈ܝܼܵܐ، ܕܛܥܘܼܢܬܹܗ ܟܹܐ ܝܵܗܒܹܠܔ ܒܙܲܒ݂ܢܹܗ، ܘܛܲܪܦܹܗ ܠܹܐ ܢܵܬܹܪ، ܘܟܠܔ ܕܥܵܒܹܕ ܟܹܐ ܡܲܢܬܹ‌ܐ؛ ");
INSERT INTO aii_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","ܠܹܐ ܝܢܵܐ ܗܵܕܟ݂ܵܐ ܒܝܼܫܹ̈ܐ، ܐܸܠܵܐ ܐܲܝܟ݂ ܬܸܒ݂ܢܵܐ ܝܢܵܐ ܕܟܹܐ ܕܲܪܹܐ ܠܹܗ ܦܵܘܚܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","ܒܘܼܬ ܐܵܗܵܐ، ܒܝܼܫܹ̈ܐ ܠܹܐ ܟܵܠܝܼ ܡܩܵܘܝܵܢܹ̈ܐ ܒܕܝܵܢܬܵ‌ܐ، ܐܵܦܠܵܐ ܚܲܛܵܝܹ̈ܐ ܒܟܢܘܼܫܝܵܐ ܕܙܲܕܝܼܩܹ̈ܐ؛ ");
INSERT INTO aii_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","ܣܵܒܵܒ ܟܹܐ ܝܵܕܹܥ ܡܵܪܝܵܐ ܐܘܼܪܚܵܐ ܕܙܲܕܝܼܩܹ̈ܐ، ܐܝܼܢܵܐ ܐܘܼܪܚܵܐ ܕܒܝܼܫܹ̈ܐ ܒܸܬ ܛܵܠܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","ܩܵܡܘܿܕܝܼ ܫܵܓ݂ܫܝܼ ܐܸܡܘܵܬܹ̈‌ܐ، ܘܥܲܡܡܹ̈ܐ ܗܲܓܝܼ ܒܣܪܝܼܩܘܼܬܵ‌ܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","ܫܩܝܼܠܔ ܠܗܘܿܢ ܫܵܘܦܵܝܗ‌ܝ ܡܲܠܟܹ̈ܐ ܕܐܲܪܥܵܐ، ܘܫܲܠܝܼ̈ܛܹܐ ܥܒ݂ܝܼܕ ܠܗܘܿܢ ܡܸܠܟܵܐ ܥܲܡ ܚܕܵܕܹ̈ܐ، ܥܲܠܔ ܡܵܪܝܵܐ ܘܥܲܠܔ ܡܫܝܼܚܹܗ، ܒܹܐܡܵܪܵܐ: ");
INSERT INTO aii_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","”ܩܵܛܥܲܚ ܐܸܣܘܼܪ̈ܵܝܗ‌ܝ، ܘܪܲܦܲܚ ܡܥܲܠܲܢ ܚܲܒ݂ܠܵܝ̈ܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","ܝܵܬܒ݂ܵܢܵܐ ܒܫܡܲܝܵܐ ܒܸܓܚܵܟܵܐ ܝܠܹܗ، ܡܵܪܝܵܐ ܡܲܣܚܘܼܪܹܐ ܒܝܼܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","ܗ̇ܝܓܵܗ ܒܸܬ ܗܲܡܙܸܡ ܐܸܠܵܝܗ‌ܝ ܒܟܲܪܒܹܗ، ܘܒܚܸܡܬܹܗ ܒܸܬ ܡܲܪܓܸܕ ܠܗܘܿܢ، ܒܹܐܡܵܪܵܐ: ");
INSERT INTO aii_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","”ܐܝܼܢܵܐ ܐܵܢܵܐ ܡܘܼܩܸܡ ܠܝܼ ܡܲܠܟܝܼ ܥܲܠܔ ܨܸܗܝܘܿܢ، ܛܘܼܪܵܐ ܕܩܘܼܕܫܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","ܒܸܬ ܗܲܩܹܝܢ ܒܘܼܬ ܩܵܢܘܿܢܵܐ ܕܡܵܪܝܵܐ. ܐܡܝܼܪܹܗ ܐܸܠܝܼ: ”ܒܪܘܿܢܝܼ ܝܘܸܬ ܐܲܢ݇ܬ، ܐܵܢܵܐ ܐܸܕܝܘܿܡ ܩܵܡ ܡܲܠܸܕܸܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","”ܛܠܘܿܒ ܡܸܢܝܼ ܘܒܸܬ ܝܵܗܒܹܢ ܐܸܡܘܵܬܹ̈‌ܐ ܠܝܵܪܬܘܼܬܘܼܟ݂، ܘܡܘܼܠܟܘܼܟ݂ ܗܲܠܔ ܡܲܪ̈ܙܵܢܹܐ ܕܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","”ܒܸܬ ܬܵܒ݂ܪܹܬ ܠܗܘܿܢ ܒܩܵܛܝܼܵܐ ܕܦܪܸܙܠܵܐ، ܐܲܝܟ݂ ܡܵܐܢܵܐ ܕܦܲܚܵܪܵܐ ܒܸܬ ܛܵܒ݂ܚܹܬ ܠܗܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","ܒܘܼܬ ܐܵܗܵܐ، ܝܵܐ ܡܲܠܟܹ̈ܐ، ܗܘܹܝܡܘܼܢ ܗܵܘܢܵܢܹ̈ܐ، ܩܲܒܠܘܼܢ ܡܲܪܕܘܼܬܵ‌ܐ، ܝܵܐ ܕܲܝܵܢܹ̈ܐ ܕܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","ܦܠܘܿܚܘܼܢ ܠܡܵܪܝܵܐ ܒܙܕܘܼܥܬܵ‌ܐ، ܘܦܨܘܿܚܘܼܢ ܒܪܲܬܪܲܬܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","ܢܫܘܿܩܘܼܢ ܠܒܪܘܿܢܵܐ ܕܠܵܐ ܟܵܪܹܒ ܘܐܵܙܠ݇ܝܼܬܘܿܢ ܠܐܲܒ݂ܕܵܢܵܐ ܓܵܘ ܐܘܼܪܚܵܐ، ܣܵܒܵܒ ܒܸܬ ܠܵܒ݂ܟ݂ܵܐ ܒܓ̰ܲܠܕܘܼܬܵ‌ܐ ܚܸܡܬܹܗ. ܛܘܼܒ݂ܵܐ ܠܐܵܢܝܼ ܕܫܵܩܠܝܼ ܓܵܘܣܵܐ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","ܝܵܐ ܡܵܪܝܵܐ، ܟܡܵܐ ܙܝܼܕܹܐ ܝܢܵܐ ܡܲܠܝܸܨܵܢܝܼ̈، ܪܵܒܵܐ ܝܢܵܐ ܩܵܝܡܵܢܹ̈ܐ ܕܥܲܠܝܼ، ");
INSERT INTO aii_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","ܪܵܒܵܐ ܝܢܵܐ ܐܵܡܪ̈ܵܢܹܐ ܒܘܼܬ ܓܵܢܝܼ: ”ܠܲܝܬ ܠܹܗ ܦܘܼܨܵܝܵܐ ܒܐܲܠܵܗܵܐ.“ ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","ܐܝܼܢܵܐ ܐܲܢ݇ܬ، ܝܵܐ ܡܵܪܝܵܐ، ܡܵܛܵܠܵܐ ܝܘܸܬ ܠܚܵܕܸܪ̈ܘܵܢܝܼ، ܚܸܩܪܝܼ ܘܡܲܪܡܵܢܵܐ ܕܪܹܝܫܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","ܒܩܵܠܝܼ ܠܡܵܪܝܵܐ ܟܹܐ ܩܵܪܹܝܢ، ܘܟܹܐ ܓ̰ܲܘܸܒ ܠܝܼ ܡ̣ܢ ܛܘܼܪܵܐ ܕܩܘܼܕܫܹܗ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","ܐܵܢܵܐ ܟܹܐ ܕܵܡܟܹܢ ܘܛܵܠܥܹܢ، ܟܹܐ ܪܵܥܫܹܢ، ܣܵܒܵܒ ܡܵܪܝܵܐ ܟܹܐ ܣܵܢܹܕ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","ܠܹܐ ܙܵܕܥܹܢ ܡ̣ܢ ܪܸ̈ܒܘܵܬܹ‌ܐ ܕܥܲܡܡܹ̈ܐ، ܐܲܝܢܝܼ ܕܟܪܝܼܟ݂ ܠܗܘܿܢ ܠܕܲܠܩܘܼܒ݂ܠܝܼ ܡ̣ܢ ܟܠܔ ܓܹܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","ܩܘܼܡ، ܝܵܐ ܡܵܪܝܵܐ! ܦܲܪܸܩ ܠܝܼ، ܝܵܐ ܐܲܠܵܗ‌ܝܼ! ܣܵܒܵܒ ܡܸܚܝܵܝ ܝܘܸܬ ܟܠܵܝܗ‌ܝ ܕܸܫ̃ܡܸܢܝܼ̈ ܥܲܠܔ ܦܵܬܵܝܗ‌ܝ، ܟܹܟܹ̈ܐ ܕܒܝܼܫܹ̈ܐ ܬܒ݂ܝܼܪܵܝ ܝܘܸܬ. ");
INSERT INTO aii_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","ܕܡܵܪܝܵܐ ܝܠܹܗ ܦܘܼܨܵܝܵܐ، ܥܲܠܔ ܥܲܡܘܼܟ݂ ܝܼܠܵܗ̇ ܒܘܼܪܟܬܘܼܟ݂. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","ܒܩܪܵܝܬ‌ܝܼ ܓ̰ܲܘܸܒ ܠܝܼ، ܝܵܐ ܐܲܠܵܗܵܐ ܕܙܲܕܝܼܩܘܼܬ‌ܝܼ، ܓܵܘ ܐܘܼܠܨܵܢܝܼ ܩܵܡ ܡܲܪܘܸܚܸܬ ܠܝܼ، ܪܲܚܸܡ ܥܲܠܝܼ ܘܫܡܹܥ ܠܨܠܘܿܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","ܝܵܐ ܒܢܲܝ̈ܢܵܫܵܐ، ܗܲܠܔ ܐܝܼܡܲܢ ܡܲܕܸܪܝܼܬܘܿܢ ܐܝܼܩܵܪܝܼ ܠܢܟ݂ܝܼܦܬܵ‌ܐ؟ ܗܲܠܔ ܐܝܼܡܲܢ ܡܲܚܸܒܝܼܬܘܿܢ ܣܪܝܼܩܘܼܬܵ‌ܐ، ܘܛܵܥܹܝܬܘܿܢ ܒܵܬܪ ܕܘܼܓܠܵܐ؟ ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","ܐܝܼܢܵܐ ܝܕܹܥܡܘܼܢ ܕܦܪܝܼܫ ܠܹܗ ܡܵܪܝܵܐ ܡܗܘܼܡܢܵܐ ܩܵܐ ܓܵܢܹܗ، ܡܵܪܝܵܐ ܒܸܬ ܫܵܡܹܥ ܒܩܪܵܝܬ‌ܝܼ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","ܪܓܘܿܕܘܼܢ ܒܙܕܘܼܥܬܵ‌ܐ ܘܠܵܐ ܚܵܛܹܝܬܘܿܢ، ܗܲܓܹܝܡܘܼܢ ܒܠܸܒܵܘܟ݂ܘܿܢ ܥܲܠܔ ܫܘܝܼܬܵܘܟ݂ܘܿܢ ܘܦܘܼܫܘܼܢ ܫܸܠܝܹܐ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","ܕܒ݂ܘܿܚܘܼܢ ܕܸܒ݂ܚܹ̈ܐ ܕܙܲܕܝܼܩܘܼܬܵ‌ܐ، ܘܣܒܘܿܪܘܼܢ ܒܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","ܪܵܒܵܐ ܝܢܵܐ ܐܵܡܪ̈ܵܢܹܐ: ”ܡܵܢܝܼ ܡܵܨܹܐ ܡܲܚܙܹܐ ܠܲܢ ܛܵܒ݂ܬܵ‌ܐ؟“ ܡܲܪܸܡ ܥܲܠܲܢ ܒܲܗܪܵܐ ܕܦܵܬܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","ܕܪܹܐ ܠܘܼܟ݂ ܦܨܵܚܵܐ ܒܠܸܒܝܼ، ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܙܲܒ݂ܢܵܐ ܕܦܸܪܝܘܼܬܵ‌ܐ ܕܕܲܚܠܵܝܗ‌ܝ ܘܚܲܡܪܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","ܒܫܠܵܡܵܐ ܒܸܬ ܕܵܡܟܹܢ ܐܘܼܦ ܒܸܬ ܛܵܠܥܹܢ، ܣܵܒܵܒ ܐܲܢ݇ܬ ܒܢܲܦ̮ܫܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܒܫܲܝܢܵܐ ܒܸܬ ܡܲܫܪܹܝܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","ܠܗܹܡܸܙܡܵܢܝܼ̈ ܨܲܠܝܼ ܢܵܬܵ‌ܐ، ܝܵܐ ܡܵܪܝܵܐ، ܡܲܣܸܡ ܒܵܠܵܐ ܠܬܲܢܲܚܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","ܗܲܒ݂ܠܔ ܢܵܬܵ‌ܐ ܠܩܵܠܵܐ ܕܓܥܵܝܬ‌ܝܼ، ܡܲܠܟܝܼ ܘܐܲܠܵܗ‌ܝܼ، ܒܗ̇ܝ ܕܐܸܠܘܼܟ݂ ܨܲܠܘܼܝܹܐ ܝܘܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","ܝܵܐ ܡܵܪܝܵܐ، ܒܨܲܦܪܵܐ ܒܸܬ ܫܵܡܥܹܬ ܩܵܠܝܼ، ܒܨܲܦܪܵܐ ܒܸܬ ܡܲܩܪܸܒܸܢ ܨܠܘܿܬ‌ܝܼ ܐܸܠܘܼܟ݂، ܘܒܸܬ ܗܵܘܹܝܢ ܩܲܙܘܼܕܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","ܒܗ̇ܝ ܕܐܲܢ݇ܬ ܠܹܐ ܝܘܸܬ ܐܲܠܵܗܵܐ ܕܒܵܣܡܵܐ ܠܹܗ ܒܒܝܼܫܬܵ‌ܐ، ܠܹܐ ܥܵܡܹܪ ܒܝܼܫܵܐ ܥܲܡܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","ܠܹܐ ܟܵܠܝܼ ܫܲܒ݂ܗܸܪ̈ܵܢܹܐ ܩܲܕܡ ܥܲܝ̈ܢܘܼܟ݂، ܟܹܐ ܣܵܢܹܝܬ ܟܠܵܝܗ‌ܝ ܦܵܠܚܵܢܹ̈ܐ ܕܥܵܘܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","ܟܹܐ ܛܲܠܩܸܬ ܠܗܲܡܙܸܡܵܢܹ̈ܐ ܕܕܲܓܵܠܘܼܬܵ‌ܐ، ܡ̣ܢ ܫܲܦܟ݂ܵܢܵܐ ܕܕܸܡܵܐ ܘܡ̣ܢ ܦܸܠܡܵܐ ܟܹܐ ܓܲܢܓܸܙ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","ܐܝܼܢܵܐ ܐܵܢܵܐ ܒܣܲܓܝܼܐܘܼܬܵ‌ܐ ܕܛܵܒ݂ܵܬܘܼ̈ܟ݂ ܒܸܬ ܥܵܒ݂ܪܹܢ ܠܒܲܝܬܘܼܟ݂، ܒܙܕܘܼܥܬܵ‌ܐ ܡܸܢܘܼܟ݂ ܒܸܬ ܣܵܓ݂ܕܹܢ ܠܓܹܒܵܐ ܕܗܲܝܟܠܵܐ ܕܩܘܼܕܫܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","ܝܵܐ ܡܵܪܝܵܐ، ܡܗܲܕܝܼ ܠܝܼ ܒܙܲܕܝܼܩܘܼܬܘܼܟ݂ ܒܥܸܠܬܵ‌ܐ ܕܕܸܫ̃ܡܸܢܝܼ̈، ܥܒ݂ܘܿܕ ܬܪܘܼܨܬܵ‌ܐ ܩܲܕܡܝܼ ܐܘܼܪܚܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","ܒܗ̇ܝ ܕܠܲܝܬ ܒܦܘܼܡܵܝܗ‌ܝ ܫܪܵܪܵܐ ܡܩܵܘܝܵܢܵܐ، ܓܵܘܵܝܗ‌ܝ ܚܪܵܒ݂ܵܐ ܝܠܹܗ. ܒܵܠܘܿܥܬܵܝܗ‌ܝ ܩܲܒ݂ܪܵܐ ܦܬܘܼܚܬܵ‌ܐ، ܒܠܸܫܵܢܵܝܗ‌ܝ ܟܹܐ ܫܲܕܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","ܕܘܼܢ ܐܸܠܵܝܗ‌ܝ ܐܲܝܟ݂ ܚܲܝܵܒܹ̈ܐ، ܝܵܐ ܐܲܠܵܗܵܐ، ܫܒ݂ܘܿܩ ܢܵܦܠܝܼ ܒܡܸܠܟܵܐ ܕܓܵܢܵܝܗ‌ܝ، ܒܘܼܬ ܦܸܪܝܘܼܬܵ‌ܐ ܕܓܢܵܗܵܝ̈ܗ‌ܝ ܚܲܪܙܸܦ ܠܗܘܿܢ، ܒܗ̇ܝ ܕܗܘܹܐ ܠܗܘܿܢ ܡܵܪ̈ܘܿܕܹܐ ܥܲܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","ܐܝܼܢܵܐ ܦܵܨܚܝܼ ܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܫܵܩܠܝܼ ܓܵܘܣܵܐ ܠܟܸܣܠܘܼܟ݂، ܫܲܒܚܝܼ ܒܚܲܕܘܼܬܵ‌ܐ ܠܥܵܠܲܡ، ܘܟܲܣܝܼ ܠܗܘܿܢ ܒܢܵܛܘܿܪܘܼܬܘܼܟ݂، ܕܦܨܵܚܵܐ ܦܵܨܚܝܼ ܒܝܼܘܼܟ݂ ܡܲܚܸܒܵܢܹ̈ܐ ܕܫܸܡܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","ܣܵܒܵܒ ܐܲܢ݇ܬ ܟܹܐ ܒܲܪܟܸܬ ܠܙܲܕܝܼܩܵܐ، ܝܵܐ ܡܵܪܝܵܐ، ܐܲܝܟ݂ ܡܵܛܵܠܵܐ ܒܫܵܦܵܩܲܬ ܟܹܐ ܚܲܪܕܸܬ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","ܒܟܲܪܒܘܼܟ݂ ܠܵܐ ܡܲܢܟܸܣܸܬ ܠܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܘܒܚܸܡܬܘܼܟ݂ ܠܵܐ ܬܲܥܠܡܸܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","ܪܲܚܸܡ ܥܲܠܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܒܗ̇ܝ ܕܟܪܝܼܗܵܐ ܝܘܸܢ ܐܵܢܵܐ، ܒܲܣܸܡ ܠܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܒܗ̇ܝ ܕܪܓܝܼܕ ܠܗܘܿܢ ܓܲܪ̈ܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","ܘܓܵܢܝܼ ܪܓܝܼܕܬܵ‌ܐ ܝܠܵܗ̇ ܪܵܒܵܐ. ܗܲܠܔ ܐܝܼܡܲܢ، ܝܵܐ ܡܵܪܝܵܐ، ܗܲܠܔ ܐܝܼܡܲܢ؟ ");
INSERT INTO aii_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","ܕܘܼܪ، ܝܵܐ ܡܵܪܝܵܐ، ܦܲܨܝܼ ܠܵܗ̇ ܓܵܢܝܼ، ܦܲܪܸܩ ܠܝܼ ܒܘܼܬ ܛܲܝܒܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","ܒܗ̇ܝ ܕܠܲܝܬ ܓܵܘ ܡܵܘܬܵ‌ܐ ܕܟ݂ܵܪܘܼܟ݂، ܒܫܝܘܿܠܔ ܡܵܢܝܼ ܒܸܬ ܫܲܒܸܚ ܠܘܼܟ݂؟ ");
INSERT INTO aii_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","ܟܟ̰ܝܼܚ ܠܝܼ ܡ̣ܢ ܬܲܢܲܚܬ‌ܝܼ، ܟܹܐ ܡܲܣܚܹܝܢ ܫܘܝܼܬ‌ܝܼ ܟܠܹܗ ܠܲܝܠܹܐ، ܒܕܸܡܥܝܼ̈ ܕܘܼܟܵܐ ܕܕܡܵܟ݂ܬ‌ܝܼ ܟܹܐ ܡܲܬܪܹܝܢ. ");
INSERT INTO aii_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","ܡ̣ܢ ܚܲܫܵܐ ܢܘܝܼܠܔ ܠܗܘܿܢ ܥܲܝܢܝܼ̈، ܚܒܹܐ ܠܗܘܿܢ ܒܥܸܠܬܵ‌ܐ ܕܟܠܵܝܗ‌ܝ ܕܲܠܩܘܼܒ݂ܠܵܝܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","ܪܚܘܿܩܘܼܢ ܡܸܢܝܼ ܟܠܵܝܗ‌ܝ ܦܵܠܚܵܢܹ̈ܐ ܕܥܵܘܠܵܐ، ܒܗ̇ܝ ܕܫܡܝܼܥ ܠܹܗ ܡܵܪܝܵܐ ܩܵܠܵܐ ܕܒܸܟ݂ܝܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","ܫܡܝܼܥܘܼܗ̇ ܝܠܹܗ ܡܵܪܝܵܐ ܦܲܪܦܲܠܬ‌ܝܼ، ܒܸܬ ܩܲܒܸܠܔ ܡܵܪܝܵܐ ܨܠܘܿܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","ܒܸܬ ܢܵܟ݂ܦܝܼ ܘܪܵܓܕܝܼ ܪܵܒܵܐ ܟܠܵܝܗ‌ܝ ܕܸܫ̃ܡܸܢܝܼ̈، ܒܸܬ ܕܵܝܪܝܼ ܘܒܸܬ ܢܵܟ݂ܦܝܼ ܡܸܢܫܸܠܬܵܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","ܝܵܐ ܡܵܪܝܵܐ ܐܲܠܵܗ‌ܝܼ، ܒܝܼܘܼܟ݂ ܫܩܝܼܠܔ ܠܝܼ ܓܵܘܣܵܐ، ܦܲܪܸܩ ܠܝܼ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܪ̈ܵܕܘܿܦܝܼ ܘܦܲܨܝܼ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","ܠܵܐ ܗܵܘܹܐ ܕܐܲܝܟ݂ ܐܲܪܝܵܐ ܦܲܪܦܸܛ ܠܵܗ̇ ܓܵܢܝܼ، ܦܵܪܹܛ ܟܲܕ ܠܲܝܬ ܦܲܨܝܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","ܝܵܐ ܡܵܪܝܵܐ ܐܲܠܵܗ‌ܝܼ، ܐܸܢ ܥܒ݂ܝܼܕ ܠܝܼ ܐܵܗܵܐ، ܐܸܢ ܐܝܼܬ ܥܵܘܠܵܐ ܒܐܝܼܕܝܼ̈؛ ");
INSERT INTO aii_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","ܐܸܢ ܦܪܝܼܥ ܠܝܼ ܒܝܼܫܬܵ‌ܐ ܠܡ̇ܢ ܕܝܼܠܹܗ ܒܫܠܵܡܵܐ ܥܲܡܝܼ، ܘܣܠܝܼܒ ܠܝܼ ܠܕܲܠܩܘܼܒ݂ܠܵܝܝܼ ܒܠܵܐ ܥܸܠܬܵ‌ܐ؛ ");
INSERT INTO aii_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","ܫܒ݂ܘܿܩ ܢܵܦܹܠܔ ܕܸܫ̃ܡܸܢ ܒܵܬܪ ܓܵܢܝܼ ܘܡܵܛܹܐ ܥܲܠܝܼ، ܘܕܲܫܕܸܫ ܠܐܲܪܥܵܐ ܚܲܝܝܼ̈، ܘܡܲܬܸܒ݂ ܠܥܲܦܪܵܐ ܐܝܼܩܵܪܝܼ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","ܩܘܼܡ، ܝܵܐ ܡܵܪܝܵܐ، ܒܟܲܪܒܘܼܟ݂، ܡܲܪܸܡ ܓܵܢܘܼܟ݂ ܥܲܠܔ ܚܸܡܬܵ‌ܐ ܕܕܸܫ̃ܡܸܢܝܼ̈، ܘܪܥܘܿܫ ܒܘܼܬ ܕܝܼܝܼ ܒܕܝܼܘܵܢ ܕܦܩܝܼܕܵܐ ܝܘܸܬ، ");
INSERT INTO aii_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","ܘܫܒ݂ܘܿܩ ܟܸܢܫܵܐ ܕܐܸܡܘܵܬܹ̈‌ܐ ܓ̰ܵܡܥܝܼ ܚܵܕܸܪ̈ܘܵܢܘܼܟ݂، ܘܝܬܘܿܒ݂ ܥܲܠܵܝܗ‌ܝ ܕܲܝܵܢܵܐ ܡ̣ܢ ܪܵܘܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","ܡܵܪܝܵܐ ܟܹܐ ܕܵܐܹܢ ܠܥܲܡܡܹ̈ܐ، ܥܒ݂ܘܿܕ ܠܵܗ̇ ܕܝܼܘܵܢܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܐܲܝܟ݂ ܙܲܕܝܼܩܘܼܬ‌ܝܼ ܘܐܲܝܟ݂ ܬܲܡܝܼܡܘܼܬܵ‌ܐ ܕܐܝܼܬ ܒܝܼܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","ܗܵܐ، ܫܒ݂ܘܿܩ ܬܵܝܡܵܐ ܒܝܼܫܬܵ‌ܐ ܕܪ̈ܲܫܝܼܥܹܐ، ܘܡܲܩܘܝܼ ܠܙܲܕܝܼܩܵܐ؛ ܝܵܐ ܒܵܚܪܵܢܵܐ ܕܠܸܒܵܘܵܬܹ̈‌ܐ ܘܪܸ̈ܥܝܵܢܹܐ، ܐܲܠܵܗܵܐ ܙܲܕܝܼܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","ܡܵܛܵܠܝܼ ܝܠܹܗ ܥܲܡ ܐܲܠܵܗܵܐ، ܦܲܪܩܵܢܵܐ ܕܬܪ̈ܘܼܨܹܐ ܕܠܸܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","ܕܲܝܵܢܵܐ ܙܲܕܝܼܩܵܐ ܝܠܹܗ ܐܲܠܵܗܵܐ، ܘܓܵܘ ܚܸܡܬܵ‌ܐ ܝܠܹܗ ܐܲܠܵܗܵܐ ܟܠܔ ܝܘܿܡ. ");
INSERT INTO aii_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","ܐܸܢ ܠܵܐ ܬܲܘܸܒ ܐܢܵܫܵܐ، ܣܲܝܦܹܗ ܒܸܬ ܡܲܚܪܸܦ ܠܹܗ ܐܲܠܵܗܵܐ، ܩܸܫܬܹܗ ܡܬܝܼܚܘܼܗ̇ ܝܠܹܗ ܘܗܘܼܕܪܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","ܘܙܲܝܢܹ̈ܐ ܕܡܵܘܬܵ‌ܐ ܗܘܼܕܪܵܝ ܠܹܗ ܐܸܠܹܗ، ܓܹܐܪ̈ܘܼܗ‌ܝ ܥܒ݂ܝܼܕܵܝ ܠܵܗܝܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","ܗܵܐ، ܪܲܫܝܼܥܵܐ ܟܹܐ ܕܵܒܹܩ ܚܸܒ݂ܠܹ̈ܐ ܕܥܵܘܠܵܐ، ܘܟܹܐ ܒܵܛܹܢ ܐܘܼܠܨܵܢܵܐ، ܘܝܵܠܹܕ ܦܸܠܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","ܒܹܐܪܵܐ ܟܹܐ ܥܵܩܹܪ ܘܚܵܦܹܪ، ܘܢܵܦܹܠܔ ܒܓܘܼܒܵܐ ܕܬܘܼܪܸܨ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","ܐܘܼܠܨܵܢܹܗ ܒܪܹܝܫܹܗ ܒܸܬ ܕܵܐܹܪ، ܘܛܠܘܼܡܝܹܗ ܠܩܲܪܩܲܦܬܹܗ ܒܸܬ ܨܵܠܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","ܒܸܬ ܫܲܟܪܸܢ ܠܡܵܪܝܵܐ ܐܲܝܟ݂ ܙܲܕܝܼܩܘܼܬܹܗ، ܘܒܸܬ ܙܵܡܪܹܢ ܫܸܡܵܐ ܕܡܵܪܝܵܐ ܥܸܠܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","ܡܵܪܝܵܐ، ܡܵܪܲܢ، ܟܡܵܐ ܡܫܘܼܒܚܵܐ ܝܠܹܗ ܫܸܡܘܼܟ݂ ܒܟܠܵܗ̇ ܐܲܪܥܵܐ، ܕܡܘܼܫܪܹܐ ܠܘܼܟ݂ ܚܸܩܪܘܼܟ݂ ܥܲܠܔ ܫܡܲܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","ܡ̣ܢ ܦܘܼܡܵܐ ܕܝܵܠܹ̈ܕ݇ܐ ܘܝܲܠܘܼܕܹ̈ܐ ܫܘܼܬܐܸܣ ܠܘܼܟ݂ ܚܲܝܠܵܐ، ܒܥܸܠܬܵ‌ܐ ܕܕܲܠܩܘܼܒ݂ܠܵܝܘܼܟ݂، ܠܡܲܫܠܘܼܝܹܐ ܕܸܫ̃ܡܸܢ ܘܫܵܩܠܵܢܵܐ ܕܬܘܼܥܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","ܐܝܼܡܲܢ ܕܓܲܫܩܸܢ ܠܫܡܲܝܘܼ̈ܟ݂، ܦܘܼܠܚܵܢܵܐ ܕܨܸܒܥܵܬܘܼ̈ܟ݂، ܣܲܗܪܵܐ ܘܟܵܘܟ݂ܒܹ̈ܐ ܕܡܘܼܬܒ݂ܵܝ ܠܘܼܟ݂ ܒܕܘܼܟܵܝܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","ܡܘܼܕܝܼ ܝܠܹܗ ܐܢܵܫܵܐ ܕܕܵܟ݂ܪܹܬ ܠܹܗ، ܘܒܲܪܢܵܫܵܐ ܕܣܲܚܒܸܪܸܬ ܠܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","ܘܥܒ݂ܝܼܕ ܠܘܼܟ݂ ܐܸܠܹܗ ܚܲܕܟ̰ܵܐ ܒܘܼܫ ܒܵܨܘܿܪܵܐ ܡ̣ܢ ܡܲܠܲܐܟܹ̈ܐ، ܘܒܚܸܩܪܵܐ ܘܐܝܼܩܵܪܵܐ ܒܘܼܢܦܸܪܘܼܟ݂ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","ܝܘܼܗܒܹܠܔ ܠܘܼܟ݂ ܫܘܼܠܛܵܢܵܐ ܐܸܠܹܗ ܥܲܠܔ ܦܘܼܠܚܵܢܹ̈ܐ ܕܐܝܼܕܵܬܘܼ̈ܟ݂؛ ܟܠܔ ܡܸܢܕܝܼ ܡܘܼܬܸܒ݂ ܠܘܼܟ݂ ܬܚܘܿܬ ܐܲܩܠܵܬܘܼ̈ܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","ܥܸܪ̈ܒܹܐ ܘܬܵܘܪܹ̈ܐ ܟܠܵܝܗ‌ܝ، ܘܐܘܼܦ ܚܲܝܘܵܬܹ̈‌ܐ ܕܕܸܫܬܵ‌ܐ؛ ");
INSERT INTO aii_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","ܛܲܝܪܹ̈ܐ ܕܫܡܲܝܵܐ ܘܢܘܼܢܹ̈ܐ ܕܝܵܡܵܐ، ܟܠܔ ܓ̰ܵܘܓ̰ܵܢܵܐ ܒܪܵܗܛܵܐ ܕܡ̈ܝܼܵܐ ܓܵܘ ܝܵܡܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","ܡܵܪܝܵܐ، ܡܵܪܲܢ، ܟܡܵܐ ܡܫܘܼܒܚܵܐ ܝܠܹܗ ܫܸܡܘܼܟ݂ ܒܟܠܵܗ̇ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","ܒܸܬ ܫܲܟܪܸܢ ܠܡܵܪܝܵܐ ܒܟܠܹܗ ܠܸܒܝܼ، ܒܸܬ ܗܲܩܹܝܢ ܟܠܵܝܗ‌ܝ ܕܘܼܡܵܪ̈ܘܼܟ݂؛ ");
INSERT INTO aii_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","ܒܸܬ ܚܵܕܹܝܢ ܘܒܸܬ ܦܵܨܚܹܢ ܒܝܼܘܼܟ݂، ܒܸܬ ܙܵܡܪܹܢ ܫܸܡܘܼܟ݂، ܝܵܐ ܥܸܠܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","ܐܝܼܡܲܢ ܕܕܵܝܪܝܼ ܕܸܫ̃ܡܸܢܝܼ ܠܒܵܬܪܵܐ، ܟܹܐ ܬܲܪܩܸܠܝܼ ܘܛܵܠܩܝܼ ܡ̣ܢ ܩܲܕܡܘܼܟ݂؛ ");
INSERT INTO aii_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","ܣܵܒܵܒ ܥܒ݂ܝܼܕ ܠܘܼܟ݂ ܕܝܼܘܵܢܝܼ ܘܕܝܵܢܬ‌ܝܼ؛ ܝܬܝܼܒ݂ ܠܘܼܟ݂ ܥܲܠܔ ܟܘܼܪܣܝܵܐ ܒܸܕܝܵܢܵܐ ܒܙܲܕܝܼܩܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","ܢܓ̰ܝܼܘ ܠܘܼܟ݂ ܒܐܸܡܘܵܬܹ̈‌ܐ، ܛܘܼܠܸܩ ܠܘܼܟ݂ ܠܒܝܼܫܹ̈ܐ، ܫܸܡܵܝܗ‌ܝ ܓܪܝܼܕ ܠܘܼܟ݂ ܠܥܵܠܲܡ ܥܵܠܡܝܼܢ. ");
INSERT INTO aii_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","ܕܸܫ̃ܡܸܢ ܬܝܼܡ ܠܹܗ ܒܚܪܵܒ݂ܵܐ ܥܵܠܡܝܼܢܵܝܵܐ، ܘܡܕܝܼܢܵܬܵܝ̈ܗ‌ܝ ܥܩܝܼܪܘܼܟ݂، ܛܠܝܼܩ ܠܹܗ ܕܟ݂ܵܪܵܐ ܕܝܼܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","ܐܝܼܢܵܐ ܡܵܪܝܵܐ ܠܥܵܠܲܡ ܝܬܝܼܒ݂ܵܐ ܝܠܹܗ، ܡܘܼܩܘܝܼܵܐ ܝܠܹܗ ܟܘܼܪܣܝܹܗ ܠܕܝܵܢܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","ܘܗ̇ܘ ܒܸܬ ܕܵܐܹܢ ܠܒܪܝܼܬܵ‌ܐ ܒܙܲܕܝܼܩܘܼܬܵ‌ܐ، ܒܸܬ ܥܵܒܹܕ ܕܝܵܢܬܵ‌ܐ ܠܥܲܡܡܹ̈ܐ ܒܬܪܘܼܨܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","ܘܒܸܬ ܗܵܘܹܐ ܡܵܪܝܵܐ ܒܹܝܬ ܓܵܘܣܵܐ ܠܡܘܼܠܝܸܨܹ̈ܐ، ܒܹܝܬ ܓܵܘܣܵܐ ܒܥܕܵܢܵܐ ܕܐܘܼܠܨܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","ܘܒܸܬ ܣܵܒܪܝܼ ܒܝܼܘܼܟ݂ ܝܵܕܥܵܢܹ̈ܐ ܕܫܸܡܘܼܟ݂، ܒܗ̇ܝ ܕܠܹܐ ܝܘܸܬ ܫܒ݂ܝܼܩܵܐ ܠܛܵܥܝܵܢܹ̈ܐ ܕܐܸܠܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","ܙܡܘܿܪܘܼܢ ܠܡܵܪܝܵܐ ܥܵܡܪܵܢܵܐ ܒܨܸܗܝܘܿܢ، ܡܲܕܸܥܡܘܼܢ ܥܒ݂ܵܕܘܼ̈ܗ‌ܝ ܓܵܘ ܥܲܡܡܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","ܒܗ̇ܝ ܕܫܵܩܠܵܢܵܐ ܕܬܘܼܥܠܵܐ ܕܕܸܡܵܐ ܟܹܐ ܕܵܟܹܪ ܠܡܘܼܠܝܸܨܹ̈ܐ؛ ܠܹܐ ܡܲܢܫܹܐ ܠܡܲܩܘܲܚܬܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","ܪܲܚܸܡ ܥܲܠܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܚܙܝܼ ܐܘܼܠܨܵܢܝܼ ܕܡ̣ܢ ܣܵܢܝܵܢܝܼ̈، ܝܵܐ ܡܲܪܡܵܢܝܼ ܡ̣ܢ ܕܲܪ̈ܘܵܙܹܐ ܕܡܵܘܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","ܕܗܲܩܹܝܢ ܟܠܵܝܗ‌ܝ ܬܸܫܒܘܿܚܝܵܬܘܼ̈ܟ݂ ܒܕܲܪ̈ܘܵܙܹܐ ܕܒܪܵܬ ܨܸܗܝܘܿܢ، ܥܵܒ݂ܕܹܢ ܦܨܵܚܵܐ ܒܦܘܼܪܩܵܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","ܛܒܝܼܥ ܠܗܘܿܢ ܐܸܡܘܵܬܹ̈‌ܐ ܒܓܘܼܒܵܐ ܕܚܦܝܼܪܗܘܿܢ، ܒܓܲܪܕܵܐ ܕܛܘܼܡܸܪܗܘܿܢ ܦܝܼܫ ܠܵܗ̇ ܕܒ݂ܝܼܩܬܵ‌ܐ ܐܲܩܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","ܦܝܼܫܵܐ ܝܠܹܗ ܝܕܝܼܥܵܐ ܡܵܪܝܵܐ ܒܕܝܼܘܵܢ ܕܥܒ݂ܝܼܕ ܠܹܗ، ܪܲܫܝܼܥܵܐ ܒܦܘܼܠܚܵܢܵܐ ܕܐܝܼܕܘܼ̈ܗ‌ܝ ܟܹܐ ܦܵܐܹܫ ܕܒ݂ܝܼܩܵܐ ܒܩܘܼܠܬܵ‌ܐ. ܗܓܵܝܘܿܢ ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","ܒܸܬ ܕܵܝܪܝܼ ܒܝܼܫܹ̈ܐ ܠܫܝܘܿܠܔ، ܟܠܵܝܗ‌ܝ ܐܸܡܘܵܬܹ̈‌ܐ ܢܵܫܝܵܢܹ̈ܐ ܕܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","ܣܵܒܵܒ ܠܥܵܠܲܡ ܠܹܐ ܦܵܐܹܫ ܡܘܼܢܫܝܼܵܐ ܣܢܝܼܩܵܐ، ܠܹܐ ܛܵܠܹܩ ܣܲܒ݂ܪܵܐ ܕܡܸܣܟܹܢܹ̈ܐ ܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","ܩܘܼܡ، ܝܵܐ ܡܵܪܝܵܐ، ܕܠܵܐ ܡܲܫ݇ܟ̰ܸܚ ܙܵܟ݂ܘܼܬܵ‌ܐ ܐܢܵܫܵܐ، ܦܵܝܫܝܼ ܕܝܼܢܹܐ ܐܸܡܘܵܬܹ̈‌ܐ ܩܲܕܡ ܦܵܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","ܡܲܬܸܒ݂، ܝܵܐ ܡܵܪܝܵܐ، ܙܕܘܼܥܬܵ‌ܐ ܥܲܠܵܝܗ‌ܝ، ܕܝܵܕܥܝܼ ܐܸܡܘܵܬܹ̈‌ܐ ܕܒܢܲܝ̈ܢܵܫܵܐ ܝܢܵܐ ܐܵܢܝܼ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","ܩܵܡܘܿܕܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܟܵܠܹܝܬ ܪܸܚܩܵܐ، ܛܲܫܹܝܬ ܓܵܢܘܼܟ݂ ܒܥܕܵܢܵܬܹ̈‌ܐ ܕܥܵܘܩܵܢܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","ܒܝܼܫܹ̈ܐ ܒܫܘܼܒ݂ܗܵܪܵܐ ܟܹܐ ܡܲܠܝܸܨܝܼ ܠܡܸܣܟܹܢܵܐ، ܫܒ݂ܘܿܩ ܦܵܝܫܝܼ ܕܒ݂ܝܼܩܹܐ ܒܚܘܼܫܵܒܹ̈ܐ ܕܥܒ݂ܝܼܕ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","ܣܵܒܵܒ ܟܹܐ ܚܵܬܹܪ ܒܝܼܫܵܐ ܒܘܼܬ ܫܲܗܘܲܬܬܵ‌ܐ ܕܢܲܦ̮ܫܹܗ، ܘܚܵܛܘܿܦܵܐ ܟܹܐ ܠܵܐܹܛ ܘܟܹܐ ܡܲܣܠܹܐ ܠܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","ܒܝܼܫܵܐ ܢܵܚܝܼܪܹܗ ܪܵܡܵܐ ܠܹܐ ܛܵܥܹܐ ܒܵܬܪܹܗ، ܠܲܝܬ ܐܲܠܵܗܵܐ ܒܟܠܵܝܗ‌ܝ ܚܘܼܫܵܒ݂ܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","ܡܲܢܬܝܼܵܢܹ̈ܐ ܝܢܵܐ ܐܘܼܪ̈ܚܵܬܘܼܗ‌ܝ ܒܟܠܔ ܥܕܵܢܵܐ، ܪ̈ܵܡܹܐ ܝܢܵܐ ܕܝܼܘܵܢܘܼ̈ܟ݂، ܥܸܠܸܠܔ ܡ̣ܢ ܚܙܵܝܬܹܗ، ܟܹܐ ܓܲܫܸܩ ܒܥܲܝܢܵܐ ܕܡܲܣܠܲܝܬܵ‌ܐ ܠܟܠܵܝܗ‌ܝ ܕܸܫ̃ܡܸܢܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","ܐܡܝܼܪܹܗ ܒܠܸܒܹܗ: ”ܠܹܐ ܫܵܥܫܹܢ، ܠܹܐ ܚܵܙܹܝܢ ܣܸܪܝܘܼܬܵ‌ܐ ܡ̣ܢ ܕܵܪܵܐ ܠܕܵܪܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","ܦܘܼܡܹܗ ܡܸܠܝܵܐ ܝܠܹܗ ܠܵܘܛܬܵ‌ܐ ܘܦܸܠܡܹ̈ܐ ܘܓܸܙܡܵܐ، ܬܚܘܿܬ ܠܸܫܵܢܹܗ ܡܲܠܝܲܨܬܵ‌ܐ ܘܥܵܘܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","ܟܹܐ ܝܵܬܹܒ݂ ܒܟܡܹܐܢܵܐ ܓܵܘ ܡܵܬܘܵܬܹ̈‌ܐ، ܓܵܘ ܣܸܬܵܪܹ̈ܐ ܟܹܐ ܩܵܛܹܠܔ ܠܙܲܟܵܝܵܐ، ܥܲܝܢܘܼ̈ܗ‌ܝ ܒܛܸܫܘܵܐ ܟܹܐ ܛܵܥܝܼ ܠܒܝܼܫܓܲܕܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","ܟܹܐ ܝܵܬܹܒ݂ ܒܣܸܬܵܪܹ̈ܐ ܐܲܝܟ݂ ܐܲܪܝܵܐ ܒܓܘܼܒܹܗ، ܟܹܐ ܝܵܬܹܒ݂ ܒܟܡܹܐܢܵܐ ܠܸܚܛܵܦܵܐ ܠܡܸܣܟܹܢܵܐ، ܟܹܐ ܚܵܛܹܦ ܠܡܸܣܟܹܢܵܐ ܐܝܼܡܲܢ ܕܓܵܪܹܫ ܠܹܗ ܠܓܲܪܕܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","ܟܹܐ ܟܵܐܹܦ ܠܸܨܦܵܚܵܐ، ܘܒܚܲܝܠܹܗ ܟܹܐ ܢܵܦܠܝܼ ܒܝܼܫܓܲܕܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","ܐܡܝܼܪܹܗ ܒܠܸܒܹܗ: ”ܠܹܐ ܡܲܣܸܡ ܒܵܠܵܐ ܐܲܠܵܗܵܐ، ܟܘܼܣܝܘܼܗ̇ ܝܠܹܗ ܦܵܬܹܗ، ܠܹܐ ܚܵܙܹܐ ܠܥܵܠܲܡ.“ ");
INSERT INTO aii_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","ܩܘܼܡ، ܝܵܐ ܡܵܪܝܵܐ ܐܲܠܵܗܵܐ، ܡܲܪܸܡ ܐܝܼܕܘܼܟ݂، ܠܵܐ ܢܵܫܹܝܬ ܠܡܸܣܟܹܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","ܩܵܡܘܿܕܝܼ ܡܲܣܠܹܐ ܪܲܫܝܼܥܵܐ ܠܐܲܠܵܗܵܐ؟ ܐܡܝܼܪܹܗ ܒܠܸܒܹܗ: ”ܠܹܐ ܚܲܫܒܸܢܵܗ̇ ܥܲܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","ܐܝܼܢܵܐ ܚܸܙܝܵܐ ܠܘܼܟ݂ ܐܲܢ݇ܬ! ܟܹܐ ܚܵܝܪܹܬ ܠܥܵܘܩܵܢܵܐ ܘܠܚܲܫܵܐ، ܠܸܫܩܵܠܵܐ ܓܵܘ ܐܝܼܕܵܬܹ̈‌ܐ ܕܓܵܢܘܼܟ݂؛ ܥܲܠܘܼܟ݂ ܟܹܐ ܣܲܦܹܐ ܠܵܗ̇ ܓܵܢܹܗ ܒܝܼܫܓܲܕܵܐ، ܠܝܲܬܘܼܡܵܐ ܐܲܢ݇ܬ ܟܹܐ ܗܵܘܹܝܬ ܗܲܝܸܪܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","ܬܵܒ݂ܪܹܬ ܕܪܲܥܢܵܐ ܕܪܲܫܝܼܥܵܐ ܘܕܒܝܼܫܵܐ، ܬܲܥܠܡܸܬ ܠܒܝܼܫܬܹܗ ܗܲܠܔ ܕܠܵܐ ܡܲܫ݇ܟ̰ܚܸܬ ܠܵܗ̇ ܐܚܹܪܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","ܡܵܪܝܵܐ ܡܲܠܟܵܐ ܝܠܹܗ ܠܥܵܠܲܡ ܥܵܠܡܝܼܢ، ܛܠܝܼܩ ܠܗܘܿܢ ܐܸܡܘܵܬܹ̈‌ܐ ܡ̣ܢ ܐܲܪܥܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","ܛܠܵܒܬܵ‌ܐ ܕܡܸܣܟܹܢܹ̈ܐ ܫܡܝܼܥ ܠܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܒܸܬ ܡܲܩܘܹܝܬ ܠܸܒܵܝܗ‌ܝ، ܒܸܬ ܨܲܠܹܝܬ ܢܵܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","ܠܸܥܒ݂ܵܕܵܐ ܕܝܼܘܵܢ ܕܝܲܬܘܼܡܵܐ ܘܡܘܼܠܝܸܨܵܐ، ܕܐܢܵܫܵܐ ܕܡ̣ܢ ܐܲܪܥܵܐ ܠܵܐ ܡܲܙܝܸܕ ܐܚܹܪܢܵܐ ܠܡܲܙܕܘܼܥܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","ܒܡܵܪܝܵܐ ܫܩܝܼܠܔ ܠܝܼ ܓܵܘܣܵܐ، ܕܐܲܝܟ݂ ܐܵܡܪܝܼܬܘܿܢ ܠܓܵܢܝܼ: ”ܥܪܘܿܩܝ ܠܛܘܼܪܵܟ݂ܝ ܐܲܝܟ݂ ܛܲܝܪܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","ܒܗ̇ܝ ܕܗܵܐ، ܪ̈ܲܫܝܼܥܹܐ ܒܸܡܬܵܚܵܐ ܝܢܵܐ ܩܸܫܬܵ‌ܐ، ܗܘܼܕܸܪܗܘܿܢ ܓܹܐܪ̈ܵܝܗ‌ܝ ܥܲܠܔ ܡܸܠܬܵ‌ܐ، ܠܪܲܦܘܼܝܹܐ ܒܚܸܫܟܵܐ ܥܲܠܔ ܬܪ̈ܘܼܨܹܐ ܕܠܸܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","ܐܝܼܡܲܢ ܕܫܲܬܐܸܣܹ̈ܐ ܦܵܝܫܝܼ ܬܠܝܼܚܹܐ، ܡܘܼܕܝܼ ܥܵܒܹܕ ܙܲܕܝܼܩܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","ܡܵܪܝܵܐ ܒܗܲܝܟܠܵܐ ܕܩܘܼܕܫܹܗ، ܡܵܪܝܵܐ ܒܫܡܲܝܵܐ ܟܘܼܪܣܝܹܗ، ܥܲܝܢܘܼ̈ܗ‌ܝ ܟܹܐ ܚܵܙܝܼ، ܛܸܠܦܵܦܘܼ̈ܗ‌ܝ ܟܹܐ ܒܵܚܪܝܼ ܠܒܢܲܝ̈ܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","ܡܵܪܝܵܐ ܟܹܐ ܒܵܚܹܪ ܠܙܲܕܝܼܩܵܐ، ܐܝܼܢܵܐ ܠܒܝܼܫܵܐ ܘܠܡܲܚܸܒܵܢܵܐ ܕܛܠܘܼܡܝܵܐ ܟܹܐ ܣܵܢܝܵܐ ܓܵܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","ܒܸܬ ܡܲܥܪܹܐ ܥܲܠܔ ܪ̈ܲܫܝܼܥܹܐ ܦܲܚܹ̈ܐ، ܢܘܼܪܵܐ، ܘܟܸܒܪܝܼܬ، ܘܦܵܘܚܵܐ ܚܲܡܝܼܡܵܐ؛ ܣܵܗܡܵܐ ܕܟܵܣܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","ܒܗ̇ܝ ܕܙܲܕܝܼܩܵܐ ܝܠܹܗ ܡܵܪܝܵܐ، ܟܹܐ ܡܲܚܸܒ ܙܲܕܝܼܩܘܼܬܵ‌ܐ، ܬܪ̈ܘܼܨܹܐ ܒܸܬ ܚܵܙܝܼ ܠܦܵܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","ܦܲܪܸܩ، ܝܵܐ ܡܵܪܝܵܐ، ܒܗ̇ܝ ܕܬܝܼܡ ܠܹܗ ܙܲܕܝܼܩܵܐ، ܒܗ̇ܝ ܕܦܪܝܼܩ ܠܗܘܿܢ ܡܗܘܼܡܢܹ̈ܐ ܡ̣ܢ ܓܵܘ ܒܢܲܝ̈ܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","ܣܪܝܼܩܘܼܬܵ‌ܐ ܟܹܐ ܗܲܡܙܸܡܝܼ ܐܢܵܫܵܐ ܥܲܡ ܚܲܒ݂ܪܹܗ؛ ܒܣܸܦܘܵܬܹ̈‌ܐ ܟ̰ܘܼܥܝܹ̈ܐ، ܒܬܪܹܝ ܠܸܒܹ̈ܐ ܦܪ̈ܝܼܫܹܐ ܟܹܐ ܗܲܡܙܸܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","ܒܸܬ ܩܵܛܹܥ ܡܵܪܝܵܐ ܟܠܵܝܗ‌ܝ ܣܸܦܘܵܬܹ̈‌ܐ ܟ̰ܘܼܥܝܹ̈ܐ، ܘܠܸܫܵܢܵܐ ܕܗܲܡܙܸܡ ܡܸܢܕܝܼܵܢܹ̈ܐ ܓܘܼܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","ܐܵܢܝܼ ܕܐܡܝܼܪܗܘܿܢ: ”ܒܠܸܫܵܢܲܢ ܒܸܬ ܙܲܪܒܸܢܲܚ، ܣܸܦܘܵܬܲܢ̈ ܕܝܼܲܢ ܝܼܢܵܐ، ܡܵܢܝܼ ܝܠܹܗ ܡܵܪܵܐ ܥܲܠܲܢ؟“ ");
INSERT INTO aii_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","”ܡ̣ܢ ܥܸܠܬܵ‌ܐ ܕܛܠܘܼܡܝܵܐ ܕܡܸܣܟܹܢܹ̈ܐ، ܡ̣ܢ ܥܸܠܬܵ‌ܐ ܕܬܲܢܲܚܬܵ‌ܐ ܕܣܢܝܼܩܹ̈ܐ، ܐܵܕܝܼܵܐ ܒܸܬ ܩܵܝܡܹܢ،“ ܒܹܐܡܵܪܵܐ ܝܠܹܗ ܡܵܪܝܵܐ، ”ܒܸܬ ܡܲܬܒܸܢܗܘܿܢ ܒܫܲܝܢܵܐ، ܐܲܝܟܵܐ ܕܪܲܚܪܘܼܚܹܐ ܝܢܵܐ ܕܗܵܘܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","ܗܹܡܸܙܡܵܢܹ̈ܐ ܕܡܵܪܝܵܐ، ܗܹܡܸܙܡܵܢܹ̈ܐ ܕܸܟ݂ܝܹ̈ܐ ܝܢܵܐ، ܐܲܝܟ݂ ܣܹܐܡܵܐ ܨܘܼܪܸܦܵܐ ܒܐܲܬܘܼܢܵܐ ܕܐܲܪܥܵܐ، ܨܘܼܦܝܵܐ ܫܒܲܥ ܓܵܗܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","ܐܲܢ݇ܬ، ܝܵܐ ܡܵܪܝܵܐ، ܒܸܬ ܢܵܛܪܹܬ ܠܗܘܿܢ، ܒܸܬ ܚܲܡܹܝܬ ܠܗܘܿܢ ܡ̣ܢ ܐܵܗܵܐ ܕܵܪܵܐ ܗܲܠܔ ܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","ܒܟܠܔ ܓܹܒܵܐ ܪ̈ܲܫܝܼܥܹܐ ܟܹܐ ܚܵܕܪܝܼ، ܐܝܼܡܲܢ ܕܡܲܣܠܲܝܬܵ‌ܐ ܦܵܝܫܵܐ ܡܝܘܼܩܸܪܬܵ‌ܐ ܓܵܘ ܒܢܲܝ̈ܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","ܗܲܠܔ ܐܝܼܡܲܢ، ܝܵܐ ܡܵܪܝܵܐ؟ ܒܸܬ ܡܲܢܫܹܝܬ ܠܝܼ ܠܥܵܠܲܡ؟ ܗܲܠܔ ܐܝܼܡܲܢ ܒܸܬ ܛܲܫܹܝܬ ܦܵܬܘܼܟ݂ ܡܸܢܝܼ؟ ");
INSERT INTO aii_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","ܗܲܠܔ ܐܝܼܡܲܢ ܡܲܬܒܸܢ ܪܸܢܝܵܐ ܒܓܵܢܝܼ، ܚܲܫܵܐ ܒܠܸܒܝܼ ܟܠܹܗ ܝܵܘܡܵܐ؟ ܗܲܠܔ ܐܝܼܡܲܢ ܪܵܐܹܡ ܕܸܫ̃ܡܸܢܝܼ ܥܲܠܝܼ؟ ");
INSERT INTO aii_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","ܚܘܼܪ ܓ̰ܲܘܸܒ ܠܝܼ، ܝܵܐ ܡܵܪܝܵܐ ܐܲܠܵܗ‌ܝܼ، ܒܲܗܪܸܢ ܥܲܝܢܝܼ̈ ܕܠܵܐ ܛܵܡܪܹܢ ܒܫܸܢܬܵ‌ܐ ܕܡܵܘܬܵ‌ܐ؛ ");
INSERT INTO aii_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","ܕܠܵܐ ܐܵܡܹܪ ܕܸܫ̃ܡܸܢܝܼ: ”ܗܘܹܐ ܠܝܼ ܓ݂ܵܠܒܵܢܵܐ ܥܲܠܘܼܗ‌ܝ،“ ܘܡܲܠܝܸܨܵܢܝܼ̈ ܦܵܨܚܝܼ ܐܝܼܡܲܢ ܕܫܵܥܫܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","ܐܝܼܢܵܐ ܐܵܢܵܐ ܒܛܲܝܒܘܼܬܘܼܟ݂ ܣܒܝܼܪܝܼ، ܒܸܬ ܦܵܨܹܚ ܠܸܒܝܼ ܒܦܘܼܪܩܵܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","ܒܸܬ ܙܵܡܪܹܢ ܠܡܵܪܝܵܐ، ܒܗ̇ܝ ܕܒܦܸܪܝܘܼܬܵ‌ܐ ܩܵܡ ܦܵܪܹܥ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","ܐܡܝܼܪܹܗ ܣܲܟ݂ܠܵܐ ܒܠܸܒܹܗ: ”ܠܲܝܬ ܐܲܠܵܗܵܐ.“ ܚܪܝܼܒܹܐ ܝܢܵܐ، ܥܒ݂ܝܼܕ ܠܗܘܿܢ ܦܘܼܠܚܵܢܹ̈ܐ ܛܲܢ̈ܦܹܐ، ܠܲܝܬ ܥܵܒ݂ܕܵܢܵܐ ܕܛܵܒ݂ܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","ܡܵܪܝܵܐ ܡ̣ܢ ܫܡܲܝܵܐ ܓܘܼܫܸܩ ܠܹܗ ܥܲܠܔ ܒܢܲܝ̈ܢܵܫܵܐ، ܠܸܚܙܵܝܵܐ ܐܸܢ ܐܝܼܬ ܦܲܪܡܝܼܵܢܵܐ، ܛܵܥܝܵܢܵܐ ܠܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","ܟܠܵܝܗ‌ܝ ܩܠܝܼܒ ܠܗܘܿܢ، ܡܸܚܕܵܕܹ̈ܐ ܗܘܹܐ ܠܗܘܿܢ ܛܲܡܐܹ̈ܐ، ܠܲܝܬ ܥܵܒ݂ܕܵܢܵܐ ܕܛܵܒ݂ܬܵ‌ܐ، ܠܲܝܬ ܐܘܼܦ ܚܲܕ. ");
INSERT INTO aii_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","ܗܵܐ، ܠܵܐ ܝܕܝܼܥ ܠܗܘܿܢ ܟܠܵܝܗ‌ܝ ܦܵܠܚܵܢܹ̈ܐ ܕܥܵܘܠܵܐ، ܕܟܹܐ ܐܵܟ݂ܠܝܼ ܠܥܲܡܝܼ ܐܲܝܟ݂ ܕܐܵܟ݂ܠܝܼ ܠܲܚܡܵܐ، ܘܠܡܵܪܝܵܐ ܠܹܐ ܩܵܪܝܼ؟ ");
INSERT INTO aii_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","ܬܵܡܵܐ ܙܕܝܼܥ ܠܗܘܿܢ ܙܕܘܼܥܬܵ‌ܐ، ܒܗ̇ܝ ܕܐܲܠܵܗܵܐ ܝܼܠܹܗ ܥܲܡ ܬܵܘܠܲܕܬܵ‌ܐ ܙܲܕܝܼܩܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","ܡܸܠܟܵܐ ܕܡܸܣܟܹܢܵܐ ܟܹܐ ܡܲܣܠܹܝܬܘܿܢ، ܐܝܼܢܵܐ ܡܵܪܝܵܐ ܝܠܹܗ ܒܹܝܬ ܓܵܘܣܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","ܛܘܼܒ݂ܵܐ ܕܐܵܬܹ‌ܐ ܡ̣ܢ ܨܸܗܝܘܿܢ ܦܘܼܪܩܵܢܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ؛ ܐܝܼܡܲܢ ܕܡܲܕܸܪ ܡܵܪܝܵܐ ܠܥܲܡܹܗ ܡ̣ܢ ܓܵܠܘܼܬܵ‌ܐ، ܒܸܬ ܦܵܨܹܚ ܝܲܥܩܘܿܒ݂، ܒܸܬ ܚܵܕܹܐ ܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","ܝܵܐ ܡܵܪܝܵܐ، ܡܵܢܝܼ ܡܵܨܹܐ ܥܵܡܹܪ ܒܡܲܫܟܢܘܼܟ݂؟ ܡܵܢܝܼ ܡܵܨܹܐ ܫܵܪܹܐ ܒܛܘܼܪܵܐ ܕܩܘܼܕܫܘܼܟ݂؟ ");
INSERT INTO aii_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","ܗ̇ܘ ܕܚܵܕܹܪ ܒܬܲܡܝܼܡܘܼܬܵ‌ܐ ܘܦܵܠܹܚ ܙܲܕܝܼܩܘܼܬܵ‌ܐ، ܘܗܲܡܙܸܡ ܫܪܵܪܵܐ ܒܠܸܒܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","ܘܠܹܐ ܕܵܪܹܐ ܒܘܼܚܬܵܢ ܒܠܸܫܵܢܹܗ، ܘܠܹܐ ܥܵܒܹܕ ܒܝܼܫܬܵ‌ܐ ܠܚܲܒ݂ܪܹܗ، ܘܠܹܐ ܡܲܪܸܡ ܠܵܘܡܵܐ ܥܲܠܔ ܫܒ݂ܵܒܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","ܘܒܥܲܝܢܘܼ̈ܗ‌ܝ ܦܝܼܫ ܠܹܗ ܡܘܼܣܠܝܼܵܐ ܟܵܦܘܿܪܵܐ، ܘܟܹܐ ܡܝܲܩܸܪ ܠܙܕܝܼ̈ܥܹܐ ܕܡܵܪܝܵܐ، ܘܟܹܐ ܝܵܡܹܐ ܠܓܵܢܹܗ ܘܠܹܐ ܫܲܚܠܸܦ، ܐܵܦܸܢ ܕܐܵܬܝܵܐ ܥܲܠܘܼܗ‌ܝ ܒܝܼܫܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","ܘܠܹܐ ܡܲܕܝܸܢ ܣܹܐܡܹܗ ܒܙܵܘܕܘܼܢܝܵܐ، ܘܠܹܐ ܫܵܩܹܠܔ ܪܸܫܘܲܬ ܥܲܠܔ ܙܲܟܵܝܵܐ. ܥܵܒ݂ܕܵܢܹ̈ܐ ܕܐܲܢܹܐ ܠܹܐ ܫܵܥܹܫ ܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","ܢܛܘܿܪܝܼ، ܝܵܐ ܐܲܠܵܗܵܐ، ܒܗ̇ܝ ܕܫܩܝܼܠܔ ܠܝܼ ܓܵܘܣܵܐ ܒܝܼܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","ܐܡܝܼܪܝܼ ܠܡܵܪܝܵܐ: ”ܡܵܪܝܼ ܝܘܸܬ ܐܲܢ݇ܬ، ܛܵܒ݂ܬܵ‌ܐ ܠܲܝܬ ܠܝܼ ܫܒ݂ܘܿܩ ܡܸܢܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","ܒܘܼܬ ܩܲܕܝܼܫܹ̈ܐ ܕܒܐܲܪܥܵܐ، ܕܝܼܢܵܐ ܚܩܝܼܪܹ̈ܐ، ܟܠܵܝܗ‌ܝ ܒܘܼܣܵܡܝܼ ܒܝܼܵܝܗ‌ܝ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","ܒܸܬ ܙܵܝܕܝܼ ܐܘܼܠܨܵܢܹ̈ܐ ܕܐܵܢܝܼ ܕܪܵܚܛܝܼ ܒܵܬܪ ܐܲܠܵܗܵܐ ܐܚܹܪܢܵܐ، ܠܹܐ ܨܲܢܨܸܠܸܢ ܢܘܼܩܵܝܵܝ̈ܗ‌ܝ ܕܕܸܡܵܐ، ܘܠܹܐ ܡܲܕܟܸܪܸܢ ܫܸܡܵܢܵܝ̈ܗ‌ܝ ܥܲܠܔ ܣܸܦܘܵܬ‌ܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","ܡܵܪܝܵܐ ܝܠܹܗ ܣܵܗܡܝܼ ܘܟܵܣܝܼ، ܐܲܢ݇ܬ ܕܒ݂ܝܼܩܵܐ ܝܘܸܬ ܒܐܝܼܕܘܼܟ݂ ܦܸܫܟܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","ܟܝܘܼܠܹ̈ܐ ܢܦܝܼܠܔ ܠܗܘܿܢ ܐܸܠܝܼ ܒܕܘܼܟܵܢܹ̈ܐ ܒܲܣܝܼܡܹ̈ܐ، ܐܘܼܦ ܝܵܪܬܘܼܬ‌ܝܼ ܫܦܝܼܪܵܗ̇ ܒܥܲܝܢܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","ܒܸܬ ܒܲܪܟܸܢ ܠܡܵܪܝܵܐ ܕܥܒ݂ܝܼܕ ܠܹܗ ܡܸܠܟܵܐ ܐܸܠܝܼ، ܐܘܼܦ ܒܠܲܝܠܵܘܵܬܹ̈‌ܐ ܟܹܐ ܬܲܥܠܸܡ ܠܝܼ ܪܸܥܝܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","ܡܘܼܬܸܒ݂ ܠܝܼ ܠܡܵܪܝܵܐ ܒܲܠܩܘܼܒ݂ܠܝܼ ܐܲܡܝܼܢܵܐܝܼܬ، ܣܵܒܵܒ ܡ̣ܢ ܝܲܡܝܼܢܝܼ ܝܠܹܗ، ܠܹܐ ܫܵܥܫܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","ܒܘܼܬ ܐܵܗܵܐ، ܚܕܹܐ ܠܹܗ ܠܸܒܝܼ ܘܦܨܝܼܚ ܠܵܗ̇ ܓܵܢܝܼ، ܐܘܼܦ ܦܲܓ݂ܪܝܼ ܒܸܬ ܫܵܪܹܐ ܒܫܲܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","ܣܵܒܵܒ ܠܹܐ ܫܵܒ݂ܩܹܬ ܠܓܵܢܝܼ ܒܫܝܘܿܠܔ، ܠܹܐ ܝܵܗܒܹܬ ܠܩܲܕܝܼܫܘܼܟ݂ ܠܸܚܙܵܝܵܐ ܚܪܵܒ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","ܒܸܬ ܡܲܕܥܸܬ ܠܝܼ ܐܘܼܪܚܵܐ ܕܚܲܝܹ̈ܐ، ܣܘܼܒ݂ܵܥܬܵ‌ܐ ܕܚܲܕܘܼܝܵܬܹ̈‌ܐ ܐܝܼܬ ܒܗܸܙܘܼܪܘܼܟ݂، ܒܘܼܣܵܡܹ̈ܐ ܒܝܲܡܝܼܢܘܼܟ݂ ܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","ܫܡܹܥ، ܝܵܐ ܡܵܪܝܵܐ، ܠܦܲܪܦܲܠܬܵ‌ܐ ܙܲܕܝܼܩܬܵ‌ܐ، ܨܘܼܬ ܠܡܲܩܘܲܚܬ‌ܝܼ، ܗܲܒ݂ܠܔ ܢܵܬܵ‌ܐ ܠܨܠܘܿܬ‌ܝܼ، ܕܠܹܐ ܝܠܵܗ̇ ܒܣܸܦܘܵܬܹ̈‌ܐ ܕܦܸܠܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","ܫܒ݂ܘܿܩ ܦܵܠܛܵܐ ܕܝܼܘܵܢܝܼ ܡܸܢܘܼܟ݂، ܥܲܝ̈ܢܘܼܟ݂ ܚܵܙܝܼ ܠܬܪ̈ܘܼܨܘܼܝܵܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","ܒܘܼܚܸܪܘܼܟ݂ ܠܸܒܝܼ، ܣܘܼܚܒܸܪܘܼܟ݂ ܐܸܠܝܼ ܒܠܲܝܠܹܐ، ܨܘܼܪܸܦܸܢܘܼܟ݂، ܠܵܐ ܡܘܼܫ݇ܟ̰ܸܚ ܠܘܼܟ݂ ܡܸܢܕܝܼ ܚܸܠܛܵܐ ܒܝܼܝܼ، ܥܒ݂ܝܼܕ ܠܝܼ ܩܛܵܥܬܵ‌ܐ ܕܠܹܐ ܚܵܛܹܐ ܦܘܼܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","ܒܘܼܬ ܦܘܼܠܚܵܢܹ̈ܐ ܕܒܲܪܢܵܫܵܐ، ܐܲܝܟ݂ ܗܹܡܸܙܡܵܢ ܕܣܸܦܘܵܬܘܼ̈ܟ݂، ܐܵܢܵܐ ܢܛܝܼܪܝܼ ܓܵܢܝܼ ܡ̣ܢ ܐܘܼܪ̈ܚܵܬܹ‌ܐ ܕܒܝܼܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","ܩܘܹܐ ܠܗܘܿܢ ܦܵܣܘܿܥܝܵܬ‌ܝܼ̈ ܒܫܒ݂ܝܼܠܘܼ̈ܟ݂، ܠܵܐ ܫܥܝܼܫ ܠܗܘܿܢ ܐܲܩܠܵܬ‌ܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","ܐܵܢܵܐ ܩܪܹܐ ܠܝܼ ܐܸܠܘܼܟ݂، ܝܵܐ ܐܲܠܵܗܵܐ، ܒܗ̇ܝ ܕܒܸܬ ܓ̰ܲܘܸܒܸܬ ܠܝܼ، ܡܲܟܸܦ ܢܵܬܘܼܟ݂ ܐܸܠܝܼ، ܫܡܹܥ ܠܗܹܡܸܙܡܵܢܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","ܡܲܚܙܝܼ ܛܲܝܒܘܼܬܘܼܟ݂ ܒܥܲܓ̰ܝܼܒܘܼܬܵ‌ܐ، ܝܵܐ ܦܵܪܘܿܩܵܐ ܕܐܵܢܝܼ ܕܡ̣ܢ ܕܸܫ̃ܡܸܢܵܝ̈ܗ‌ܝ ܫܵܩܠܝܼ ܓܵܘܣܵܐ ܒܝܲܡܝܼܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","ܢܛܘܿܪܝܼ ܐܲܝܟ݂ ܒܹܒܸܠܬܵ‌ܐ ܕܥܲܝܢܵܐ، ܒܛܸܠܵܢܝܼܬܵ‌ܐ ܕܓܘܼܠܦܵܢܘܼ̈ܟ݂ ܛܲܫܹܝܬ ܠܝܼ؛ ");
INSERT INTO aii_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","ܡ̣ܢ ܩܲܕܡ ܒܝܼܫܹ̈ܐ ܕܦܲܪܦܘܼܣܝܼ ܝܢܵܐ، ܡ̣ܢ ܕܸܫ̃ܡܸܢܝܼ̈ ܕܚܲܪܕܝܼ ܠܓܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","ܕܒ݂ܝܼܪܘܼܗ‌ܝ ܝܢܵܐ ܠܸܒܵܝܗ‌ܝ ܩܸܫܝܵܐ، ܒܦܘܼܡܵܝܗ‌ܝ ܟܹܐ ܗܲܡܙܸܡܝܼ ܫܘܼܒ݂ܗܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","ܚܘܼܪܕܝܼܹܐ ܝܢܵܐ ܐܸܠܝܼ ܐܵܕܝܼܵܐ ܒܦܵܣܘܿܥܝܵܬ‌ܝܼ̈، ܡܘܼܬܸܒ݂ ܠܗܘܿܢ ܥܲܝ̈ܢܵܝܗ‌ܝ ܠܪܲܦܘܼܝܝܼ ܠܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","ܒܸܕܡܵܝܵܐ ܠܐܲܪܝܵܐ ܕܫܲܗܘܸܬ ܠܸܦܪܵܛܵܐ، ܘܠܓܘܼܪܝܵܐ ܕܐܲܪܝܵܐ ܝܬܝܼܒ݂ܵܐ ܒܣܸܬܵܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","ܩܘܼܡ، ܝܵܐ ܡܵܪܝܵܐ، ܟܠܝܼ ܩܲܕܡ ܦܵܬܵܝܗ‌ܝ ܘܡܲܒܪܸܟ ܠܗܘܿܢ، ܦܲܨܝܼ ܠܓܵܢܝܼ ܡ̣ܢ ܪ̈ܲܫܝܼܥܹܐ ܒܝܲܕ ܣܲܝܦܘܼܟ݂؛ ");
INSERT INTO aii_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","ܡ̣ܢ ܐܢܵܫܹ̈ܐ ܒܝܲܕ ܐܝܼܕܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܡ̣ܢ ܐܢܵܫܹ̈ܐ ܕܐܵܗܵܐ ܥܵܠܡܵܐ، ܕܣܵܗܡܵܝܗ‌ܝ ܒܐܲܢܹܐ ܚܲܝܹ̈ܐ ܝܠܹܗ، ܘܒܣܝܼܡܬܘܼܟ݂ ܟܹܐ ܡܵܠܹܝܬ ܟܹܪ݇ܣܵܝܗ‌ܝ، ܘܟܹܐ ܣܵܒ݂ܥܝܼ ܒܢܘܿܢܵܝ̈ܗ‌ܝ، ܘܫܵܒ݂ܩܝܼ ܫܲܪܟܵܢܵܐ ܠܝܲܠܘܼܕܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","ܐܝܼܢܵܐ ܐܵܢܵܐ، ܒܸܬ ܚܵܙܹܝܢ ܠܦܵܬܘܼܟ݂ ܒܙܲܕܝܼܩܘܼܬܵ‌ܐ، ܒܸܬ ܣܵܒ݂ܥܹܢ ܒܨܘܼܪܬܘܼܟ݂ ܐܝܼܡܲܢ ܕܪܵܥܫܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","ܘܐܡܝܼܪܹܗ: ܟܹܐ ܡܲܚܸܒܸܢܘܼܟ݂ ܡܵܪܝܵܐ، ܚܲܝܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","ܡܵܪܝܵܐ ܩܵܝܝܼ ܝܠܹܗ، ܘܚܸܣܢܝܼ، ܘܦܲܨܝܵܢܝܼ، ܐܲܠܵܗܵܐ ܐܝܼܨܵܪܝܼ ܕܫܵܩܠܹܢ ܓܵܘܣܵܐ ܒܝܼܹܗ، ܡܵܛܵܠܝܼ، ܩܲܠܥܝܼ ܘܚܲܝܠܵܐ ܕܦܘܼܪܩܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","ܒܸܬ ܩܵܪܹܝܢ ܠܡܵܪܝܵܐ ܕܝܼܠܹܗ ܡܫܘܼܒܚܵܐ، ܘܡ̣ܢ ܕܸܫ̃ܡܸܢܝܼ̈ ܒܸܬ ܦܵܝܫܹܢ ܦܘܼܪܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","ܟܪܝܼܟܸܢܗܘܿܢ ܚܸܒ݂ܠܹ̈ܐ ܕܡܵܘܬܵ‌ܐ، ܛܵܘܦܵܢܹ̈ܐ ܣܸܪ̈ܝܹܐ ܨܦܝܼܚ ܠܗܘܿܢ ܥܲܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","ܚܲܒ݂ܠܹ̈ܐ ܕܫܝܘܿܠܔ ܩܵܡ ܚܲܪܕܝܼ ܠܝܼ، ܬܦܝܼܩ ܠܗܘܿܢ ܒܝܼܝܼ ܢܸܫܒܹ̈ܐ ܕܡܵܘܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","ܟܲܕ ܥܝܼܩ ܠܵܗ̇ ܐܸܠܝܼ، ܩܪܹܐ ܠܝܼ ܠܡܵܪܝܵܐ، ܘܡܘܼܩܘܸܚ ܠܝܼ ܠܐܲܠܵܗ‌ܝܼ، ܫܡܝܼܥ ܠܹܗ ܡ̣ܢ ܗܲܝܟܠܹܗ ܩܵܠܝܼ، ܘܓܥܵܝܬ‌ܝܼ ܩܲܕܡܘܼܗ‌ܝ ܡܛܹܐ ܠܵܗ̇ ܠܢܵܬܝܵܬܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","ܗ̇ܝܓܵܗ ܫܥܝܼܫ ܠܵܗ̇ ܘܕܘܼܪܘܸܕ ܠܵܗ̇ ܐܲܪܥܵܐ، ܪܓܝܼܕ ܠܗܘܿܢ ܘܫܥܝܼܫ ܠܗܘܿܢ ܒܸܢܝܲܬܹ̈‌ܐ ܕܛܘܼܪ̈ܵܢܹܐ، ܡ̣ܢ ܚܸܡܬܵ‌ܐ ܕܟܲܪܒܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","ܐܣܝܼܩ ܠܹܗ ܬܸܢܵܐ ܡ̣ܢ ܢܵܚܝܼܪܹܗ، ܘܢܘܼܪܵܐ ܐܵܟ݂ܘܿܠܵܐ ܡ̣ܢ ܦܘܼܡܹܗ، ܓܘܼܡܪܹ̈ܐ ܠܒ݂ܝܼܟ݂ ܠܗܘܿܢ ܡܸܢܹܗ، ");
INSERT INTO aii_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","ܡܘܼܟܸܦ ܠܹܗ ܫܡܲܝܹ̈ܐ ܘܨܠܹܐ ܠܹܗ، ܟܲܕ ܥܲܝܒ݂ܵܐ ܚܸܫܟܵܢܬܵ‌ܐ ܬܚܘܿܬ ܐܲܩܠܵܬܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","ܪܟܝܼܒ݂ ܠܹܗ ܥܲܠܔ ܟܪܘܿܒ݂ܵܐ ܘܦܪܝܼܚ ܠܹܗ، ܘܣܛܹܐ ܠܹܗ ܥܲܠܔ ܓܘܼܠܦܵܢܹ̈ܐ ܕܦܵܘܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","ܥܒ݂ܝܼܕ ܠܹܗ ܠܚܸܫܟܵܐ ܣܸܬܵܪܹܗ، ܡܛܲܠܠܹܗ ܚܵܕܸܪ̈ܘܵܢܘܼܗ‌ܝ، ܠܚܸܫܟܵܐ ܕܡ̈ܝܼܵܐ، ܥܲܝܒ݂ܵܬܹ̈‌ܐ ܕܪܩܝܼܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","ܡ̣ܢ ܫܲܦ̮ܩܵܐ ܕܩܲܕܡ ܦܵܬܹܗ ܥܲܝܒ݂ܵܬܘܼ̈ܗ‌ܝ ܡܘܼܥܪܹܐ ܠܗܘܿܢ ܒܲܪܕܵܐ ܘܓܘܼܡܪܹ̈ܐ ܕܢܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","ܘܩܘܼܪܩܸܡ ܠܹܗ ܒܫܡܲܝܵܐ ܡܵܪܝܵܐ، ܘܥܸܠܵܝܵܐ ܝܘܼܗܒܹܠܔ ܠܹܗ ܩܵܠܹܗ، ܒܲܪܕܵܐ ܘܓܘܼܡܪܹ̈ܐ ܕܢܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","ܘܫܘܼܕܸܪܹܗ ܓܹܐܪ̈ܘܼܗ‌ܝ ܘܒܘܼܪܒܸܙܵܝ ܠܹܗ، ܘܫܘܼܕܸܪܹܗ ܒܸܪ̈ܩܹܐ ܪܵܒܵܐ ܘܚܒ݂ܝܼܛܵܝ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","ܘܡܘܼܒܝܸܢܗܘܿܢ ܪ̈ܵܗܛܹܐ ܕܡ̈ܝܼܵܐ، ܘܦܝܼܫ ܠܗܘܿܢ ܓܸܠܝܹܐ ܫܘܼܬܐܵܣܹ̈ܐ ܕܬܹܒܹܝܠܔ، ܡ̣ܢ ܢܓ̰ܵܘܬܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܡ̣ܢ ܢܫܲܡܬܵ‌ܐ ܕܦܵܘܚܵܐ ܕܢܵܚܝܼܪܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","ܫܘܼܕܸܪܹܗ ܡ̣ܢ ܪܵܘܡܵܐ ܓ̰ܢܝܼܒܸܢܹܗ، ܓܪܝܼܫܸܢܹܗ ܡ̣ܢ ܡ̈ܝܼܵܐ ܙܲܪ̈ܒܵܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","ܩܵܡ ܦܲܨܹܐ ܠܝܼ ܡ̣ܢ ܕܸܫ̃ܡܸܢܝܼ̈ ܚܲܝܠܵܢܹ̈ܐ، ܘܡ̣ܢ ܣܵܢܝܵܢܝܼ̈ ܕܝܼܢܵܐ ܒܘܼܫ ܙܲܪ̈ܒܵܢܹܐ ܡܸܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","ܐܬܹ‌ܐ ܠܗܘܿܢ ܥܲܠܝܼ ܒܝܵܘܡܵܐ ܕܓܘܼܢܚܝܼ، ܐܝܼܢܵܐ ܗܘܹܐ ܠܹܗ ܡܵܪܝܵܐ ܣܢܵܕܬܵ‌ܐ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","ܘܦܘܼܠܛܸܢܹܗ ܠܪܘܵܚܵܢܝܼ، ܩܵܡ ܦܲܨܹܐ ܠܝܼ ܒܗ̇ܝ ܕܒܣܝܼܡ ܠܵܗ̇ ܠܹܗ ܒܝܼܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","ܩܵܡ ܦܵܪܹܥ ܠܝܼ ܡܵܪܝܵܐ ܐܲܝܟ݂ ܙܲܕܝܼܩܘܼܬ‌ܝܼ، ܐܲܝܟ݂ ܕܸܟ݂ܝܘܼܬܵ‌ܐ ܕܐܝܼܕܵܬ‌ܝܼ̈ ܡܘܼܕܸܪܹܗ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","ܣܵܒܵܒ ܢܛܝܼܪܝܼ ܐܘܼܪ̈ܚܵܬܹ‌ܐ ܕܡܵܪܝܵܐ، ܘܒܪܲܫܝܼܥܘܼܬܵ‌ܐ ܠܵܐ ܦܪܝܼܫ ܠܝܼ ܡ̣ܢ ܐܲܠܵܗ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","ܣܵܒܵܒ ܟܠܵܝܗ‌ܝ ܕܝܼܘܵܢܘܼ̈ܗ‌ܝ ܠܒܲܠܩܘܼܒ݂ܠܝܼ ܝܢܵܐ، ܘܡ̣ܢ ܩܵܢܘܿܢܘܼ̈ܗ‌ܝ ܠܵܐ ܕܝܼܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","ܘܗܘܹܐ ܠܝܼ ܬܲܡܝܼܡܵܐ ܥܲܡܹܗ، ܘܢܛܝܼܪܝܼ ܓܵܢܝܼ ܡ̣ܢ ܥܵܘܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","ܒܘܼܬ ܐܵܗܵܐ، ܡܘܼܕܸܪܹܗ ܐܸܠܝܼ ܡܵܪܝܵܐ ܐܲܝܟ݂ ܙܲܕܝܼܩܘܼܬ‌ܝܼ، ܐܲܝܟ݂ ܕܸܟ݂ܝܘܼܬܵ‌ܐ ܕܐܝܼܕܵܬ‌ܝܼ̈ ܩܲܕܡ ܥܲܝܢܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","ܥܲܡ ܡܪܲܚܡܵܢܵܐ ܟܹܐ ܗܵܘܹܝܬ ܡܪܲܚܡܵܢܵܐ، ܥܲܡ ܓܲܒ݂ܪܵܐ ܬܲܡܝܼܡܵܐ ܟܹܐ ܗܵܘܹܝܬ ܬܲܡܝܼܡܵܐ؛ ");
INSERT INTO aii_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","ܥܲܡ ܕܸܟ݂ܝܵܐ ܟܹܐ ܗܵܘܹܝܬ ܕܸܟ݂ܝܵܐ، ܘܥܲܡ ܦܟ̰ܝܼܠܵܐ ܟܹܐ ܗܵܘܹܝܬ ܝܵܕܘܿܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","ܣܵܒܵܒ ܐܲܢ݇ܬ ܟܹܐ ܦܲܪܩܹܬ ܥܲܡܵܐ ܡܸܣܟܹܢܵܐ، ܐܝܼܢܵܐ ܥܲܝ̈ܢܹܐ ܪ̈ܵܡܵܢܹܐ ܟܹܐ ܡܲܟܸܦܸܬ. ");
INSERT INTO aii_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","ܣܵܒܵܒ ܐܲܢ݇ܬ ܟܹܐ ܒܲܗܪܸܢܸܬ ܫܪܵܓ݂ܝܼ، ܡܵܪܝܵܐ ܐܲܠܵܗ‌ܝܼ ܟܹܐ ܒܲܗܪܸܢ ܚܸܫܟܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","ܣܵܒܵܒ ܒܝܼܘܼܟ݂ ܡܵܨܹܝܢ ܪܵܚܛܹܢ ܥܲܠܔ ܓܲܝܣܵܐ، ܘܒܐܲܠܵܗ‌ܝܼ ܡܵܨܹܝܢ ܫܵܘܪܹܢ ܡܥܲܠܔ ܫܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","ܬܲܡܝܼܡܬܵ‌ܐ ܝܠܵܗ̇ ܐܘܼܪܚܵܐ ܕܐܲܠܵܗܵܐ، ܚܲܒܪܵܐ ܕܡܵܪܝܵܐ ܨܘܼܪܸܦܵܐ ܝܠܹܗ، ܡܵܛܵܠܵܐ ܝܠܹܗ ܠܟܠܔ ܡ̇ܢ ܕܫܵܩܹܠܔ ܓܵܘܣܵܐ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","ܣܵܒܵܒ ܡܵܢܝܼ ܝܠܹܗ ܐܲܠܵܗܵܐ ܫܒ݂ܘܿܩ ܡ̣ܢ ܡܵܪܝܵܐ؟ ܘܡܵܢܝܼ ܝܠܹܗ ܐܝܼܨܵܪܵܐ ܫܒ݂ܘܿܩ ܡ̣ܢ ܐܲܠܵܗܲܢ؟ ");
INSERT INTO aii_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","ܐܲܠܵܗܵܐ ܕܟܹܐ ܡܲܠܒܸܫ ܠܝܼ ܚܲܝܠܵܐ، ܥܒ݂ܝܼܕ ܠܹܗ ܐܘܼܪܚܝܼ ܬܲܡܝܼܡܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","ܟܹܐ ܥܵܒܹܕ ܐܲܩܠܵܬ‌ܝܼ̈ ܐܲܝܟ݂ ܐܲܩܠܹ̈ܐ ܕܐܲܝ̈ܠܹܐ، ܘܥܲܠܔ ܕܘܼܟܵܢܝܼ̈ ܪ̈ܵܡܹܐ ܟܹܐ ܡܲܟܠܹܐ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","ܟܹܐ ܬܲܠܡܸܕ ܐܝܼܕܵܬ‌ܝܼ̈ ܠܦܠܵܫܵܐ، ܕܡܵܬܚܝܼ ܕܪ̈ܵܥܢܵܢܝܼ ܩܸܫܬܵ‌ܐ ܕܢܚܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","ܩܵܡ ܝܵܗܒܹܬ ܠܝܼ ܡܵܛܵܠܵܐ ܕܦܘܼܪܩܵܢܘܼܟ݂، ܘܝܲܡܝܼܢܘܼܟ݂ ܩܵܡ ܣܵܢܕܵܐ ܠܝܼ، ܘܓ̰ܲܘܲܒܬܘܼܟ݂ ܐܸܠܝܼ ܩܵܡ ܓܲܪܘܸܣܵܐ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","ܡܘܼܪܘܸܚ ܠܘܼܟ݂ ܐܘܼܪܚܝܼ ܩܵܐ ܦܵܣܘܿܥܝܵܬ‌ܝܼ̈، ܗܵܕܵܐ ܕܠܵܐ ܫܥܝܼܫ ܠܗܘܿܢ ܦܟ̰ܘܼܪܹ̈ܐ ܕܐܲܩܠܵܬ‌ܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","ܢܦܝܼܠܔ ܠܝܼ ܒܵܬܪ ܕܸܫ̃ܡܸܢܝܼ̈ ܘܛܘܼܠܩܵܝ ܠܝܼ، ܘܠܵܐ ܕܝܼܪܝܼ ܗܲܠܔ ܬܝܵܡܬܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","ܒܠܝܼܣܵܝ ܠܝܼ ܘܠܹܐ ܡܵܨܝܼ ܩܵܝܡܝܼ، ܢܦܝܼܠܔ ܠܗܘܿܢ ܬܚܘܿܬ ܐܲܩܠܵܬ‌ܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","ܘܫܩܝܼܠܔ ܠܝܼ ܚܲܝܠܵܐ ܠܦܠܵܫܵܐ، ܡܘܼܒܪܸܟ ܠܘܼܟ݂ ܬܚܘܿܬ‌ܝܼ ܠܩܵܝܡܵܢܹ̈ܐ ܕܥܲܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","ܘܕܸܫ̃ܡܸܢܝܼ̈ ܡܘܼܥܒܸܕ ܠܘܼܟ݂ ܕܥܵܪܩܝܼ ܡ̣ܢ ܩܲܕܡܝܼ، ܝܘܼܗܒܹܠܔ ܠܘܼܟ݂ ܐܸܠܝܼ ܕܛܲܠܩܸܢ ܠܣܵܢܝܵܢܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","ܡܘܼܩܘܸܚ ܠܗܘܿܢ، ܐܝܼܢܵܐ ܠܲܝܬ ܗܘܵܐ ܦܲܪܩܵܢܵܐ، ܡܘܼܩܘܸܚ ܠܗܘܿܢ ܠܡܵܪܝܵܐ، ܘܠܵܐ ܓ̰ܘܼܘܸܒܵܝ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","ܘܕܘܼܩܕܸܩܵܝ ܠܝܼ ܐܲܝܟ݂ ܥܲܦܪܵܐ ܩܲܕܡ ܦܵܘܚܵܐ، ܐܲܝܟ݂ ܛܝܼܢܵܐ ܕܥܵܠܘܿܠܹ̈ܐ ܪܘܼܦܝܵܝ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","ܘܩܵܡ ܦܲܨܹܝܬ ܠܝܼ ܡ̣ܢ ܡܲܩܲܪ̈ܵܨܘܼܝܵܬܹ‌ܐ ܕܥܲܡܵܐ، ܩܵܡ ܡܲܬܒܸܬ ܠܝܼ ܠܪܹܝܫܵܢܘܼܬܵ‌ܐ ܕܐܸܡܘܵܬܹ̈‌ܐ، ܥܲܡܵܐ ܕܠܹܐ ܝܘܸܢ ܝܕܝܼܥܹܗ ܒܸܬ ܦܵܠܹܚ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","ܟܲܕ ܫܵܡܥܵܐ ܢܵܬܵܝܗ‌ܝ، ܒܸܬ ܨܵܝܬ‌ܝܼ ܐܸܠܝܼ، ܒܢܲܝ̈ ܢܘܼܟ݂ܪ̈ܵܝܹܐ ܒܸܬ ܫܵܠܡܝܼ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","ܒܢܲܝ̈ ܢܘܼܟ݂ܪ̈ܵܝܹܐ ܒܸܬ ܛܲܠܩܝܼ ܓ̰ܘܼܪܐܲܬܵܝܗ‌ܝ، ܘܪܲܬܪܘܼܬܹ‌ܐ ܒܸܬ ܦܵܠܛܝܼ ܡ̣ܢ ܩܲܠܥܵܬܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","ܚܵܝܵܐ ܝܠܹܗ ܡܵܪܝܵܐ ܘܒܪܝܼܟ݂ܵܐ ܝܠܹܗ ܐܝܼܨܵܪܝܼ، ܘܪܘܼܡܪܵܡܵܐ ܠܐܲܠܵܗܵܐ ܕܦܘܼܪܩܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","ܐܲܠܵܗܵܐ ܫܵܩܠܵܢܵܐ ܕܬܘܼܥܠܵܐ ܝܠܹܗ ܩܵܬ‌ܝܼ، ܘܙܲܒܛܸܢܵܢܵܐ ܕܥܲܡܡܹ̈ܐ ܬܚܘܿܬ ܐܲܩܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","ܟܹܐ ܦܲܨܹܐ ܠܝܼ ܡ̣ܢ ܕܸܫ̃ܡܸܢܝܼ̈، ܘܟܹܐ ܡܲܪܡܹܝܬ ܠܝܼ ܠܥܸܠܔ ܡ̣ܢ ܩܵܝܡܵܢܹ̈ܐ ܕܥܲܠܝܼ، ܡ̣ܢ ܐܢܵܫܵܐ ܕܛܠܘܼܡܝܵܐ ܟܹܐ ܦܲܨܹܝܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","ܒܘܼܬ ܐܵܗܵܐ، ܒܸܬ ܫܲܟܪܸܢܘܼܟ݂ ܓܵܘ ܐܸܡܘܵܬܹ̈‌ܐ، ܝܵܐ ܡܵܪܝܵܐ، ܘܠܫܸܡܘܼܟ݂ ܒܸܬ ܙܵܡܪܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","ܒܘܼܪܓ̰ܵܐ ܕܦܘܼܪܩܵܢܵܐ ܝܠܹܗ ܠܡܲܠܟܹܗ، ܘܥܵܒ݂ܕܵܢܵܐ ܕܛܲܝܒܘܼܬܵ‌ܐ ܠܡܫܝܼܚܹܗ، ܠܕܵܘܝܼܕ ܘܠܙܲܪܥܹܗ ܗܲܠܔ ܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","ܫܡܲܝܹ̈ܐ ܗܲܩܘܼܝܹܐ ܝܢܵܐ ܚܸܩܪܵܐ ܕܐܲܠܵܗܵܐ، ܘܪܩܝܼܥܵܐ ܡܲܕܘܼܥܹܐ ܝܠܹܗ ܦܘܼܠܚܵܢܹ̈ܐ ܕܐܝܼܕܵܬܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","ܐܝܼܡܵܡܵܐ ܠܐܝܼܡܵܡܵܐ ܟܹܐ ܡܲܢܒܸܥ ܡܹܐܡܪܵܐ، ܘܠܲܝܠܹܐ ܠܠܲܝܠܹܐ ܟܹܐ ܡܲܚܙܹܐ ܝܕܵܥܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","ܠܲܝܬ ܡܹܐܡܪܵܐ ܘܠܲܝܬ ܗܹܡܸܙܡܵܢܹ̈ܐ، ܕܠܹܐ ܦܵܝܫܝܼ ܫܡܝܼܥܹܐ ܒܩܵܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","ܒܟܠܵܗ̇ ܐܲܪܥܵܐ ܦܠܝܼܛ ܠܹܗ ܟܝܘܼܠܵܝܗ‌ܝ، ܘܒܡܲܪܙܵܐ ܕܒܪܝܼܬܵ‌ܐ ܚܲܒܪ̈ܵܢܵܝܗ‌ܝ، ܩܵܐ ܫܸܡܫܵܐ ܢܩܝܼܫ ܠܹܗ ܡܲܫܟܢܵܐ ܒܓܵܘܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","ܘܗ̇ܘ ܐܲܝܟ݂ ܚܸܬܢܵܐ ܕܦܵܠܹܛ ܡ̣ܢ ܒܹܝܬ ܓܢܘܿܢܹܗ، ܟܹܐ ܦܵܨܹܚ ܐܲܝܟ݂ ܓܲܒܵܪܵܐ ܠܸܪܚܵܛܵܐ ܪܲܗܛܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","ܡ̣ܢ ܡܲܪܙܵܐ ܕܫܡܲܝܹ̈ܐ ܦܠܵܛܹܗ، ܘܚܕܵܪܬܹܗ ܡ̣ܢ ܚܲܕ ܓܹܒܵܐ ܠܓܹܒܵܐ ܐܚܹܪܢܵܐ، ܘܠܲܝܬ ܕܦܵܐܹܫ ܛܘܼܫܝܵܐ ܡ̣ܢ ܚܸܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","ܢܵܡܘܿܣܵܐ ܕܡܵܪܝܵܐ ܬܲܡܝܼܡܵܐ ܝܠܹܗ، ܡܲܕܸܪܵܢܵܐ ܕܓܵܢܵܐ، ܣܵܗܕܘܼܬܵ‌ܐ ܕܡܵܪܝܵܐ ܡܗܲܝܡܵܢܬܵ‌ܐ ܝܠܵܗ̇، ܟܹܐ ܥܵܒ݂ܕܵܐ ܚܲܟܝܼܡܵܐ ܠܦܫܝܼ̈ܛܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","ܦܘܼܩܵܕܹ̈ܐ ܕܡܵܪܝܵܐ ܬܪ̈ܘܼܨܹܐ ܝܢܵܐ، ܡܲܚܕܝܼܵܢܹ̈ܐ ܕܠܸܒܵܐ، ܦܘܼܩܕܵܢܵܐ ܕܡܵܪܝܵܐ ܕܸܟ݂ܝܵܐ ܝܠܹܗ، ܒܲܗܪܸܢܵܢܵܐ ܕܥܲܝ̈ܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","ܙܕܘܼܥܬܵ‌ܐ ܕܡܵܪܝܵܐ ܕܟ݂ܝܼܬܵ‌ܐ ܝܠܵܗ̇، ܩܲܝܵܡ ܠܥܵܠܲܡ، ܕܝܼܘܵܢܹ̈ܐ ܕܡܵܪܝܵܐ ܫܲܪܝܼܪܹ̈ܐ ܝܢܵܐ، ܙܲܕܝܼܩܹ̈ܐ ܒܟܠܔ ܥܕܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","ܒܘܼܫ ܫܘܼܗܘܸܬܹ‌ܐ ܝܢܵܐ ܡ̣ܢ ܕܲܗܒ݂ܵܐ، ܘܡ̣ܢ ܪܵܒܵܐ ܕܲܗܒ݂ܵܐ ܨܸܦܝܵܐ، ܘܒܘܼܫ ܚܸܠܝܹܐ ܝܢܵܐ ܡ̣ܢ ܕܸܒ݂ܫܵܐ، ܘܡ̣ܢ ܢܵܛܘܿܦܝܵܬܹ̈‌ܐ ܕܫܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","ܐܘܼܦ ܪܹܓܘܼܟ݂ ܟܹܐ ܦܵܐܹܫ ܙܗܝܼܪܵܐ ܒܝܼܵܝܗ‌ܝ، ܒܢܛܵܪܬܵܝܗ‌ܝ ܐܝܼܬ ܦܘܼܪܥܵܢܵܐ ܓܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","ܡܵܢܝܼ ܟܹܐ ܡܵܨܹܐ ܦܲܪܡܹܐ ܚܸܠܛܹܗ؟ ܥܒ݂ܘܿܕ ܠܝܼ ܙܲܟܵܝܵܐ ܡ̣ܢ ܚܛܝܼܵܬܹ̈‌ܐ ܕܠܵܐ ܒܝܕܵܥܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","ܐܘܼܦ ܡ̣ܢ ܚܬܵܪ̈ܝܵܬܹ‌ܐ ܚܣܘܿܟ݂ ܠܹܗ ܪܹܓܘܼܟ݂، ܠܵܐ ܫܵܒ݂ܩܹܬ ܗܵܘܹܐ ܠܗܘܿܢ ܫܘܼܠܛܵܢܵܐ ܥܲܠܝܼ، ܗ̇ܝܓܵܗ ܒܸܬ ܗܵܘܹܝܢ ܬܲܡܝܼܡܵܐ، ܘܒܸܬ ܗܵܘܹܝܢ ܙܲܟܵܝܵܐ ܡ̣ܢ ܓܢܵܗܵܐ ܓܘܼܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","ܗܵܘܝܼ ܡܩܲܒܠܹܐ ܩܲܕܡܘܼܟ݂ ܗܹܡܸܙܡܵܢܹ̈ܐ ܕܦܘܼܡܝܼ ܘܗܲܓܲܝܬܵ‌ܐ ܕܠܸܒܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܐܝܼܨܵܪܝܼ، ܘܦܵܪܘܿܩܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","ܓ̰ܲܘܸܒ ܠܘܼܟ݂ ܡܵܪܝܵܐ ܒܝܵܘܡܵܐ ܕܥܵܘܩܵܢܵܐ، ܡܲܪܸܡ ܠܘܼܟ݂ ܠܫܲܝܢܵܐ ܫܸܡܵܐ ܕܐܲܠܵܗܵܐ ܕܝܲܥܩܘܿܒ݂. ");
INSERT INTO aii_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","ܫܲܕܸܪ ܗܲܝܲܪܬܘܼܟ݂ ܡ̣ܢ ܡܲܩܕܫܵܐ، ܘܣܵܢܹܕ ܠܘܼܟ݂ ܡ̣ܢ ܨܸܗܝܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","ܕܵܟܹܪ ܠܟܠܵܝܗ‌ܝ ܩܘܼܪ̈ܒܵܢܘܼܟ݂، ܘܩܲܒܸܠܔ ܠܹܗ ܕܸܒ݂ܚܘܼܟ݂ ܡܘܼܩܕܵܐ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","ܝܵܗܒܹܠܔ ܠܘܼܟ݂ ܐܲܝܟ݂ ܠܸܒܘܼܟ݂، ܘܬܲܡܸܡ ܟܠܵܗ̇ ܬܲܚܡܲܢܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","ܒܸܬ ܫܲܒܚܲܚ ܥܲܠܔ ܦܘܼܪܩܵܢܘܼܟ݂، ܘܒܫܸܡܵܐ ܕܐܲܠܵܗܲܢ ܒܸܬ ܡܲܪܡܲܚ ܐܵܬܵ‌ܐ، ܬܲܡܸܡ ܡܵܪܝܵܐ ܠܟܠܵܝܗ‌ܝ ܛܠܵܒܝܵܬܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","ܐܵܕܝܼܵܐ ܝܕܝܼܥ ܠܝܼ ܕܟܹܐ ܦܲܪܸܩ ܡܵܪܝܵܐ ܠܡܫܝܼܚܹܗ، ܟܹܐ ܓ̰ܲܘܸܒ ܠܹܗ ܡ̣ܢ ܫܡܲܝܵܐ ܕܩܘܼܕܫܹܗ، ܒܦܘܼܪ̈ܩܵܢܹܐ ܓܲܒܵܪܹ̈ܐ ܕܝܲܡܝܼܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","ܚܲܕܟܡܵܐ ܟܹܐ ܣܵܒܪܝܼ ܒܡܲܪ̈ܟܒ݂ܵܬܹ‌ܐ، ܘܚܲܕܟܡܵܐ ܒܣܘܼܣܵܘܵܬܹ̈‌ܐ، ܐܝܼܢܵܐ ܐܲܚܢܲܢ ܒܫܸܡܵܐ ܕܡܵܪܝܵܐ ܐܲܠܵܗܲܢ ܒܸܬ ܡܲܕܟܸܪܲܚ. ");
INSERT INTO aii_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","ܐܵܢܝܼ ܒܪܝܼܟ ܠܗܘܿܢ ܘܢܦܝܼܠܔ ܠܗܘܿܢ، ܐܝܼܢܵܐ ܐܲܚܢܲܢ ܩܝܼܡ ܠܲܢ ܘܟܠܹܐ ܠܲܢ ܬܪܘܼܨܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","ܝܵܐ ܡܵܪܝܵܐ، ܦܲܪܸܩ، ܡܲܠܟܵܐ ܓ̰ܲܘܸܒ ܠܲܢ ܒܝܵܘܡܵܐ ܕܩܵܪܲܚ. ");
INSERT INTO aii_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","ܝܵܐ ܡܵܪܝܵܐ، ܒܚܲܝܠܘܼܟ݂ ܟܹܐ ܚܵܕܹܐ ܡܲܠܟܵܐ، ܘܒܦܘܼܪܩܵܢܘܼܟ݂ ܟܡܵܐ ܪܵܒܵܐ ܟܹܐ ܦܵܨܹܚ. ");
INSERT INTO aii_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","ܛܠܵܒܬܵ‌ܐ ܕܠܸܒܹܗ ܝܘܼܗܒܹܠܔ ܠܘܼܟ݂ ܐܸܠܹܗ، ܘܒܵܥܘܼܬܵ‌ܐ ܕܣܸܦܘܵܬܘܼ̈ܗ‌ܝ ܠܵܐ ܡܘܼܟܠܹܐ ܠܘܼܟ݂. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","ܒܗ̇ܝ ܕܟܹܐ ܡܲܬܦܸܩܸܬ ܒܝܼܹܗ ܒܘܼܪ̈ܟܵܬܹ‌ܐ ܛܵܒܹ̈ܐ، ܟܹܐ ܡܲܬܒܸܬ ܒܪܹܝܫܹܗ ܬܵܓ݂ܵܐ ܕܕܲܗܒ݂ܵܐ ܨܸܦܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","ܚܲܝܹ̈ܐ ܛܠܝܼܒ ܠܹܗ ܡܸܢܘܼܟ݂ ܘܝܘܼܗܒܹܠܔ ܠܘܼܟ݂ ܐܸܠܹܗ، ܝܵܘܡܵܢܹ̈ܐ ܝܲܪ̈ܝܼܟܹܐ ܠܥܵܠܲܡ ܥܵܠܡܝܼܢ. ");
INSERT INTO aii_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","ܓܘܼܪܵܐ ܝܠܹܗ ܐܝܼܩܵܪܹܗ ܒܦܘܼܪܩܵܢܘܼܟ݂، ܚܸܩܪܵܐ ܘܙܲܗܝܘܼܬܵ‌ܐ ܟܹܐ ܡܲܬܒܸܬ ܥܲܠܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","ܒܗ̇ܝ ܕܟܹܐ ܡܲܬܒܸܬ ܐܸܠܹܗ ܒܘܼܪ̈ܟܵܬܹ‌ܐ ܠܥܵܠܲܡ، ܟܹܐ ܡܲܚܕܸܝܬ ܠܹܗ ܒܦܨܵܚܬܵ‌ܐ ܕܗܸܙܘܼܪܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","ܣܵܒܵܒ ܡܲܠܟܵܐ ܒܸܣܒܵܪܵܐ ܝܠܹܗ ܒܡܵܪܝܵܐ، ܘܒܛܲܝܒܘܼܬܵ‌ܐ ܕܥܸܠܵܝܵܐ ܠܹܐ ܫܵܥܹܫ. ");
INSERT INTO aii_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","ܡܲܫ݇ܟ̰ܚܵܐ ܐܝܼܕܘܼܟ݂ ܠܟܠܵܝܗ‌ܝ ܕܸܫ̃ܡܸܢܘܼ̈ܟ݂، ܝܲܡܝܼܢܘܼܟ݂ ܡܲܫ݇ܟ̰ܚܵܐ ܠܣܵܢܝܵܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","ܒܸܬ ܥܵܒ݂ܕܹܬ ܠܗܘܿܢ ܐܲܝܟ݂ ܐܲܬܘܼܢܵܐ ܕܢܘܼܪܵܐ ܒܥܕܵܢܵܐ ܕܡܲܒܝܲܢܬܘܼܟ݂، ܡܵܪܝܵܐ ܒܚܸܡܬܹܗ ܒܸܬ ܒܵܠܹܥ ܠܗܘܿܢ، ܘܢܘܼܪܵܐ ܒܸܬ ܐܵܟܹܠܔ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","ܝܵܠܵܕ݇ܝ̈ܗ‌ܝ ܡ̣ܢ ܐܲܪܥܵܐ ܒܸܬ ܛܲܠܩܸܬ، ܘܙܲܪ̈ܥܵܝܗ‌ܝ ܡ̣ܢ ܒܢܲܝ̈ܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","ܒܗ̇ܝ ܕܬܘܼܚܡܸܢܗܘܿܢ ܥܲܠܘܼܟ݂ ܒܝܼܫܬܵ‌ܐ، ܚܫܝܼܒ݂ ܠܗܘܿܢ ܦܸܠܡܵܐ، ܐܝܼܢܵܐ ܠܹܐ ܡܵܨܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","ܣܵܒܵܒ ܒܸܬ ܡܲܥܒܸܕܸܬ ܠܗܘܿܢ ܕܥܵܪܩܝܼ، ܩܸܫܬܘܼܟ݂ ܒܸܬ ܗܲܕܪܸܬ ܠܦܵܬܘܵܬܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","ܪܘܼܡ، ܝܵܐ ܡܵܪܝܵܐ، ܒܥܘܼܫܢܘܼܟ݂، ܒܸܬ ܫܲܒܚܲܚ ܘܙܵܡܪܲܚ ܓܲܒܵܪܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","ܐܲܠܵܗ‌ܝܼ، ܐܲܠܵܗ‌ܝܼ، ܩܵܡܘܿܕܝܼ ܫܒ݂ܝܼܩܸܢܘܼܟ݂، ܪܸܚܩܵܐ ܡ̣ܢ ܦܘܼܪܩܵܢܝܼ ܘܡ̣ܢ ܗܹܡܸܙܡܵܢܹ̈ܐ ܕܓܥܵܝܬ‌ܝܼ؟ ");
INSERT INTO aii_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","ܐܲܠܵܗ‌ܝܼ، ܒܸܩܪܵܝܵܐ ܝܘܸܢ ܒܐܝܼܡܵܡܵܐ ܘܠܹܐ ܝܘܸܬ ܓ̰ܲܘܘܼܒܹܐ، ܘܒܠܲܝܠܹܐ، ܘܠܲܝܬ ܫܠܵܝܬܵ‌ܐ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","ܘܐܲܢ݇ܬ ܩܲܕܝܼܫܵܐ ܝܘܸܬ، ܝܵܬܒ݂ܵܢܵܐ ܒܫܘܼܒ݂ܚܹ̈ܐ ܕܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","ܒܝܼܘܼܟ݂ ܣܒܝܼܪܗܘܿܢ ܐܲܒ݂ܵܗܵܬܲܢ̈، ܣܒܝܼܪܗܘܿܢ ܒܝܼܘܼܟ݂، ܘܦܘܼܨܝܵܝ ܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","ܐܸܠܘܼܟ݂ ܡܘܼܩܘܸܚ ܠܗܘܿܢ، ܘܦܝܼܫ ܠܗܘܿܢ ܦܘܼܪܩܹܐ، ܒܝܼܘܼܟ݂ ܣܒܝܼܪܗܘܿܢ، ܘܠܵܐ ܢܟ݂ܝܼܦ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","ܐܝܼܢܵܐ ܐܵܢܵܐ ܬܸܘܸܠܥܵܐ ܝܘܸܢ ܘܠܵܐ ܐܢܵܫܵܐ، ܠܵܘܡܵܐ ܕܒܲܪܢܵܫܵܐ ܘܡܘܼܣܠܝܼܵܐ ܒܥܲܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","ܟܠܵܝܗ‌ܝ ܚܵܙܝܵܢܝܼ̈ ܟܹܐ ܡܲܣܚܸܪܝܼ ܒܝܼܝܼ، ܟܹܐ ܡܲܦܟ̰ܸܠܝܼ ܦܘܼܡܵܐ، ܟܹܐ ܫܵܥܫܝܼ ܪܹܝܫܵܐ، ܒܹܐܡܵܪܵܐ: ");
INSERT INTO aii_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","”ܕܵܪܹܐ ܣܲܒ݂ܪܹܗ ܥܲܠܔ ܡܵܪܝܵܐ، ܕܗ̇ܘ ܦܲܨܹܐ ܠܹܗ، ܫܒ݂ܘܿܩ ܦܲܪܸܩ ܠܹܗ ܒܗ̇ܝ ܕܟܹܐ ܒܵܣܡܵܐ ܠܹܗ ܒܝܼܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","ܣܵܒܵܒ ܐܲܢ݇ܬ ܝܼܘܸܬ ܦܲܠܛܵܢܝܼ ܡ̣ܢ ܒܲܛܢܵܐ، ܘܥܒ݂ܝܼܕ ܠܘܼܟ݂ ܕܣܵܒܪܹܢ ܒܝܼܘܼܟ݂ ܥܲܠܔ ܨܲܕܪ̈ܵܢܹܐ ܕܝܸܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","ܕܝܼܘܼܟ݂ ܗܘܹܐ ܠܝܼ ܡ̣ܢ ܡܲܪܒܥܵܐ، ܐܲܠܵܗ‌ܝܼ ܝܘܸܬ ܐܲܢ݇ܬ ܡ̣ܢ ܒܲܛܢܵܐ ܕܝܸܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","ܠܵܐ ܪܵܚܩܹܬ ܡܸܢܝܼ ܒܗ̇ܝ ܕܩܘܼܪܒܵܐ ܝܠܹܗ ܥܵܘܩܵܢܵܐ، ܒܗ̇ܝ ܕܠܲܝܬ ܗܲܝܸܪܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","ܩܵܡ ܚܲܪܕܝܼ ܠܝܼ ܬܵܘܪܹ̈ܐ ܪܵܒܵܐ، ܩܵܡ ܟܵܪܟ݂ܝܼ ܠܝܼ ܬܵܘܪܹ̈ܐ ܙܲܪ̈ܒܵܢܹܐ ܕܒܲܝܫܵܢ. ");
INSERT INTO aii_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","ܦܬܝܼܚ ܠܗܘܿܢ ܥܲܠܝܼ ܦܘܼܡܵܝܗ‌ܝ، ܐܲܝܟ݂ ܐܲܪܝܵܐ ܦܵܪܘܿܛܵܐ ܘܓܲܪܓܸܡܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","ܐܲܝܟ݂ ܡ̈ܝܼܵܐ ܦܝܼܫ ܠܝܼ ܫܘܼܦܟ݂ܵܐ، ܘܫܪܹܐ ܠܗܘܿܢ ܟܠܵܝܗ‌ܝ ܓܲܪܡܝܼ، ܗܘܹܐ ܠܹܗ ܠܸܒܝܼ ܐܲܝܟ݂ ܫܲܡܲܥ، ܦܫܝܼܪܹܗ ܒܓܵܘܵܐ ܕܨܲܕܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","ܒܪܝܼܙ ܠܹܗ ܐܲܝܟ݂ ܦܹܚܵܪܵܐ ܚܲܝܠܝܼ، ܘܠܸܫܵܢܝܼ ܫܸܥܝܵܐ ܝܠܹܗ ܠܫܵܡܵܟܝܼ، ܘܩܵܡ ܡܲܬܒܸܬ ܠܝܼ ܠܥܲܦܪܵܐ ܕܡܵܘܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","ܒܗ̇ܝ ܕܩܵܡ ܚܲܪܕܝܼ ܠܝܼ ܟܲܠܒܹ̈ܐ، ܟܸܢܫܵܐ ܕܒܝܼܫܹ̈ܐ ܩܵܡ ܟܵܪܟ݂ܝܼ ܠܝܼ، ܒܙܝܼܥ ܠܗܘܿܢ ܠܐܝܼܕܵܬ‌ܝܼ̈ ܘܠܐܲܩܠܵܬ‌ܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","ܡܵܨܹܝܢ ܡܵܢܹܝܢ ܟܠܵܝܗ‌ܝ ܓܲܪ̈ܡܝܼ، ܐܵܢܝܼ ܓܘܼܫܸܩ ܠܗܘܿܢ ܘܚܝܼܪܗܘܿܢ ܒܝܼܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","ܦܘܼܠܸܥ ܠܗܘܿܢ ܓ̰ܘܼܠܝܼ̈ ܒܹܝܠܵܝܗ‌ܝ، ܘܥܲܠܔ ܠܒ݂ܝܼܫܬ‌ܝܼ ܕܪܹܐ ܠܗܘܿܢ ܦܸܫܟܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","ܘܐܲܢ݇ܬ، ܝܵܐ ܡܵܪܝܵܐ، ܠܵܐ ܟܵܠܹܝܬ ܪܸܚܩܵܐ، ܝܵܐ ܚܲܝܠܝܼ، ܡܲܠܝܸܙ ܠܗܲܝܲܪܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","ܦܲܨܝܼ ܡ̣ܢ ܣܲܝܦܵܐ ܠܓܵܢܝܼ، ܡ̣ܢ ܐܝܼܕܵܐ ܕܟܲܠܒܵܐ ܐܝܼܚܝܼܕܵܝܘܼܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","ܦܲܪܸܩ ܠܝܼ ܡ̣ܢ ܦܘܼܡܵܐ ܕܐܲܪܝܵܐ، ܘܦܲܨܝܼ ܠܝܼ ܡ̣ܢ ܩܲܪ̈݇ܢܵܢܹܐ ܕܪ̈ܲܝܡܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","ܒܸܬ ܗܲܩܹܝܢ ܫܸܡܘܼܟ݂ ܠܐܲܚܘܿܢܘܵܬ‌ܝܼ̈، ܒܓܵܘܵܐ ܕܟܸܢܫܵܐ ܒܸܬ ܫܲܒܚܸܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","ܙܕܝܼ̈ܥܹܐ ܕܡܵܪܝܵܐ ܫܲܒܚܘܼܢ ܐܸܠܹܗ، ܟܠܹܗ ܙܲܪܥܵܐ ܕܝܲܥܩܘܿܒ݂ ܡܝܲܩܪܘܼܢ ܠܹܗ، ܘܙܕܹܥܡܘܼܢ ܡܸܢܹܗ ܟܠܹܗ ܙܲܪܥܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","ܒܗ̇ܝ ܕܠܵܐ ܡܘܼܣܠܹܐ ܠܹܗ ܘܠܵܐ ܓܘܼܢܓܸܙ ܠܹܗ ܡ̣ܢ ܐܘܼܠܨܵܢܵܐ ܕܡܘܼܠܝܸܨܵܐ، ܘܠܵܐ ܛܘܼܫܹܐ ܠܹܗ ܦܵܬܹܗ ܡܸܢܹܗ، ܐܸܠܵܐ ܫܡܝܼܥ ܠܹܗ ܟܲܕ ܡܘܼܩܘܸܚ ܠܹܗ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","ܡ̣ܢ ܠܟܸܣ ܠܘܼܟ݂ ܝܼܠܵܗ̇ ܬܸܫܒܘܿܚܬ‌ܝܼ ܒܟܸܢܫܵܐ ܓܘܼܪܵܐ، ܢܸܕܪ̈ܝܼ ܒܸܬ ܬܲܡܸܡܸܢ ܩܲܕܡ ܙܕܝܼܥܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","ܒܸܬ ܐܵܟ݂ܠܝܼ ܡܸܣܟܹܢܹ̈ܐ ܘܣܵܒ݂ܥܝܼ، ܒܸܬ ܫܲܒܚܝܼ ܠܡܵܪܝܵܐ ܛܵܥܝܵܢܹ̈ܐ ܐܸܠܹܗ، ܚܵܝܹܐ ܠܸܒܵܘܟ݂ܘܿܢ ܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","ܒܸܬ ܕܵܟ݂ܪܝܼ ܘܕܵܝܪܝܼ ܠܟܸܣ ܡܵܪܝܵܐ ܟܠܵܝܗ‌ܝ ܡܲܪ̈ܙܵܢܹܐ ܕܐܲܪܥܵܐ، ܘܒܸܬ ܣܵܓ݂ܕܝܼ ܩܲܕܡܘܼܟ݂ ܟܠܵܝܗ‌ܝ ܫܲܪ̈ܒܵܬܹ‌ܐ ܕܐܸܡܘܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","ܒܗ̇ܝ ܕܠܡܵܪܝܵܐ ܝܠܵܗ̇ ܡܲܠܟܘܼܬܵ‌ܐ، ܘܗ̇ܘ ܝܼܠܹܗ ܗܲܟܡܵܢܵܐ ܠܐܸܡܘܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","ܘܒܸܬ ܐܵܟ݂ܠܝܼ ܘܒܸܬ ܣܵܓ݂ܕܝܼ ܟܠܵܝܗ‌ܝ ܥܲܬܝܼܪܹ̈ܐ ܕܐܲܪܥܵܐ، ܩܲܕܡܘܼܗ‌ܝ ܒܸܬ ܟܵܝܦܝܼ ܟܠܵܝܗ‌ܝ ܨܵܠܝܵܢܹ̈ܐ ܠܥܲܦܪܵܐ، ܘܐܘܼܦ ܗ̇ܘ ܕܠܹܐ ܡܵܨܹܐ ܚܲܡܹܐ ܠܵܗ̇ ܓܵܢܹܗ ܚܵܝܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","ܙܲܪܥܵܐ ܒܸܬ ܦܵܠܹܚ ܐܸܠܹܗ، ܒܸܬ ܗܲܩܝܼ ܒܘܼܬ ܡܵܪܝܵܐ ܠܕܵܪܵܐ ܕܐܵܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","ܒܸܬ ܐܵܬ‌ܝܼ ܘܒܸܬ ܡܲܕܥܝܼ ܙܲܕܝܼܩܘܼܬܹܗ ܠܥܲܡܵܐ ܕܦܵܐܹܫ ܝܠܝܼܕܵܐ، ܕܗ̇ܘ ܥܒ݂ܝܼܕ ܠܹܗ ܐܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","ܡܵܪܝܵܐ ܪܵܥܝܝܼ ܝܠܹܗ، ܠܹܐ ܚܵܣܪܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","ܥܲܠܔ ܡܲܪ̈ܓܹܐ ܩܝܼܢܹ̈ܐ ܟܹܐ ܡܲܕܡܸܟ݂ ܠܝܼ، ܠܡ̈ܝܼܵܐ ܢܝܼܚܹ̈ܐ ܟܹܐ ܡܗܲܕܹܐ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","ܟܹܐ ܚܲܕܸܬ ܠܵܗ̇ ܓܵܢܝܼ، ܟܹܐ ܠܲܒܸܠܔ ܠܝܼ ܒܫܒ݂ܝܼܠܹ̈ܐ ܕܙܲܕܝܼܩܘܼܬܵ‌ܐ ܒܘܼܬ ܫܸܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","ܐܘܼܦ ܟܲܕ ܚܵܕܪܹܢ ܒܪܵܘܘܿܠܵܐ ܕܛܸܠܵܢܝܼܬܵ‌ܐ ܕܡܵܘܬܵ‌ܐ، ܠܹܐ ܙܵܕܥܹܢ ܡ̣ܢ ܒܝܼܫܬܵ‌ܐ، ܣܵܒܵܒ ܐܲܢ݇ܬ ܥܲܡܝܼ ܝܘܸܬ، ܩܵܛܝܼܘܼܟ݂ ܘܚܘܼܛܪܘܼܟ݂، ܐܵܢܝܼ ܟܹܐ ܝܵܗܒ݂ܝܼ ܠܝܼ ܠܸܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","ܟܹܐ ܚܵܪܙܹܬ ܩܲܕܡܝܼ ܨܘܼܦܪܵܐ، ܠܒܲܠܩܘܼܒ݂ܠܔ ܕܕܸܫ̃ܡܸܢܝܼ̈، ܡܫܝܼܚ ܠܘܼܟ݂ ܒܡܸܫܚܵܐ ܪܹܝܫܝܼ، ܟܵܣܝܼ ܫܦܝܼܟ݂ܵܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","ܐܲܚܟ̰ܝܼ ܛܵܒ݂ܬܵ‌ܐ ܘܛܲܝܒܘܼܬܵ‌ܐ ܒܸܬ ܢܵܦܠܝܼ ܒܵܬܪܝܼ ܟܠܵܝܗ‌ܝ ܝܵܘܡܵܢܹ̈ܐ ܕܚܲܝܝܼ̈، ܘܒܸܬ ܝܵܬܒܹܢ ܓܵܘ ܒܲܝܬܵ‌ܐ ܕܡܵܪܝܵܐ ܒܝܘܼܪܟ݂ܵܐ ܕܝܵܘܡܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","ܕܡܵܪܝܵܐ ܝܠܵܗ̇ ܐܲܪܥܵܐ ܘܡܸܠܝܘܼܬܘܼܗ̇، ܒܪܝܼܬܵ‌ܐ ܘܥܵܡܪ̈ܵܢܹܐ ܕܓܵܘܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","ܣܵܒܵܒ ܗ̇ܘ ܥܲܠܔ ܝܵܡܵܬܹ̈‌ܐ ܫܘܼܬܐܸܣܵܐ ܠܹܗ، ܘܥܲܠܔ ܢܲܗܪ̈ܵܘܵܬܹ‌ܐ ܡܘܼܩܘܝܼܵܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","ܡܵܢܝܼ ܐܵܣܹܩ ܒܛܘܼܪܵܐ ܕܡܵܪܝܵܐ؟ ܘܡܵܢܝܼ ܟܵܠܹܐ ܒܕܘܼܟܬܵ‌ܐ ܕܩܘܼܕܫܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","ܗ̇ܘ ܕܙܲܟܵܝܹܐ ܝܢܵܐ ܐܝܼܕܵܬܘܼ̈ܗ‌ܝ ܘܕܸܟ݂ܝܵܐ ܝܠܹܗ ܠܸܒܹܗ، ܕܠܵܐ ܡܘܼܪܸܡ ܠܹܗ ܒܣܪܝܼܩܘܼܬܵ‌ܐ ܓܵܢܹܗ، ܘܠܵܐ ܝܡܹܐ ܠܹܗ ܒܦܸܠܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","ܒܸܬ ܩܲܒܸܠܔ ܒܘܼܪܟܬܵ‌ܐ ܡ̣ܢ ܡܵܪܝܵܐ، ܘܙܲܕܝܼܩܘܼܬܵ‌ܐ ܡ̣ܢ ܐܲܠܵܗܵܐ ܕܦܘܼܪܩܵܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","ܐܵܗܵܐ ܝܠܹܗ ܕܵܪܵܐ ܕܐܵܢܝܼ ܕܛܵܥܝܼ ܐܸܠܹܗ، ܛܵܥܝܵܢܹ̈ܐ ܕܦܵܬܘܼܟ݂، ܝܵܐ ܐܲܠܵܗܵܐ ܕܝܲܥܩܘܿܒ݂. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","ܡܲܪܡܘܼܢ، ܝܵܐ ܕܲܪ̈ܘܵܙܹܐ، ܪܹ̈ܝܫܵܘܟ݂ܘܿܢ، ܘܦܘܼܫܘܼܢ ܡܘܼܪܡܹܐ، ܝܵܐ ܬܲܪ̈ܥܵܢܹܐ ܕܥܵܠܲܡ، ܕܥܵܒܹܪ ܡܲܠܟܵܐ ܕܐܝܼܩܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","ܡܵܢܝܼ ܝܠܹܗ ܐܵܗܵܐ ܡܲܠܟܵܐ ܕܐܝܼܩܵܪܵܐ؟ ܡܵܪܝܵܐ ܥܲܫܝܼܢܵܐ ܘܓܲܒܵܪܵܐ؛ ܡܵܪܝܵܐ ܓܲܒܵܪܵܐ ܕܦܠܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","ܡܲܪܡܘܼܢ، ܝܵܐ ܕܲܪ̈ܘܵܙܹܐ، ܪܹ̈ܝܫܵܘܟ݂ܘܿܢ، ܘܦܘܼܫܘܼܢ ܡܘܼܪܡܹܐ، ܝܵܐ ܬܲܪ̈ܥܵܢܹܐ ܕܥܵܠܲܡ، ܕܥܵܒܹܪ ܡܲܠܟܵܐ ܕܐܝܼܩܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","ܡܵܢܝܼ ܝܠܹܗ ܐܵܗܵܐ ܡܲܠܟܵܐ ܕܐܝܼܩܵܪܵܐ؟ ܡܵܪܝܵܐ ܚܲܝܠܬܵܢܵܐ، ܗ̇ܘ ܝܼܠܹܗ ܡܲܠܟܵܐ ܕܐܝܼܩܵܪܵܐ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","ܐܸܠܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܡܲܪܘܼܡܘܼܗ̇ ܝܘܸܢ ܓܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","ܐܲܠܵܗ‌ܝܼ ܒܝܼܘܼܟ݂ ܣܒܝܼܪܝܼ، ܠܵܐ ܫܵܒ݂ܩܹܬ ܢܵܟ݂ܦܹܢ، ܠܵܐ ܫܵܒ݂ܩܹܬ ܦܵܨܚܝܼ ܕܸܫ̃ܡܸܢܝܼ̈ ܥܲܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","ܐܘܼܦ ܟܠܵܝܗ‌ܝ ܣܵܦܪ̈ܵܢܹܐ ܐܸܠܘܼܟ݂ ܠܹܐ ܢܵܟ݂ܦܝܼ، ܒܸܬ ܢܵܟ݂ܦܝܼ ܐܵܢܝܼ ܕܚܵܝܝܼܢܹ̈ܐ ܝܢܵܐ ܒܠܵܐ ܥܸܠܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","ܐܘܼܪ̈ܚܵܬܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܡܲܕܸܥ ܠܗܘܿܢ ܐܸܠܝܼ، ܫܒ݂ܝܼܠܘܼ̈ܟ݂ ܡܲܠܸܦ ܠܗܘܿܢ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","ܡܲܚܕܸܪܝܼ ܒܫܲܪܝܼܪܘܼܬܘܼܟ݂ ܘܡܲܠܸܦ ܠܝܼ، ܣܵܒܵܒ ܐܲܢ݇ܬ ܝܼܘܸܬ ܐܲܠܵܗܵܐ ܕܦܘܼܪܩܵܢܝܼ، ܐܸܠܘܼܟ݂ ܣܦܝܼܪܝܼ ܟܠܹܗ ܝܵܘܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","ܕܟ݂ܘܿܪ ܪ̈ܲܚܡܘܼܟ݂ ܡܵܪܝܵܐ ܘܛܲܝܒܘܼܬܘܼܟ݂، ܣܵܒܵܒ ܡ̣ܢ ܥܵܠܲܡ ܝܼܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","ܚܛܵܗܹ̈ܐ ܕܥܠܲܝܡܘܼܬ‌ܝܼ ܘܓܢܵܗ‌ܝܼ̈ ܠܵܐ ܕܵܟ݂ܪܹܬ، ܐܲܝܟ݂ ܛܲܝܒܘܼܬܘܼܟ݂ ܕܟ݂ܘܿܪ ܐܸܠܝܼ ܐܲܢ݇ܬ، ܒܘܼܬ ܚܵܬܸܪ ܕܛܵܒ݂ܘܼܬܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","ܛܵܒ݂ܵܐ ܘܬܪܘܼܨܵܐ ܝܠܹܗ ܡܵܪܝܵܐ، ܒܘܼܬ ܐܵܗܵܐ ܟܹܐ ܬܲܠܡܸܕ ܚܲܛܵܝܹ̈ܐ ܒܐܘܼܪܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","ܟܹܐ ܡܗܲܕܹܐ ܠܡܲܟܝܼܟܹ̈ܐ ܒܕܝܼܘܵܢ، ܘܡܲܠܸܦ ܠܡܲܟܝܼܟܹ̈ܐ ܐܘܼܪܚܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","ܛܲܝܒܘܼܬܵ‌ܐ ܘܫܲܪܝܼܪܘܼܬܵ‌ܐ ܝܢܵܐ ܟܠܵܝܗ‌ܝ ܐܘܼܪ̈ܚܵܬܹ‌ܐ ܕܡܵܪܝܵܐ، ܠܢܵܛܪ̈ܵܢܹܐ ܕܘܲܥܕܹܗ ܘܣܵܗܕܘܵܬܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","ܒܘܼܬ ܫܸܡܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܫܒ݂ܘܿܩ ܠܥܵܘܠܝܼ ܒܗ̇ܝ ܕܝܼܠܹܗ ܓܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","ܡܵܢܝܼ ܝܠܹܗ ܙܕܝܼܥܵܐ ܕܡܵܪܝܵܐ؟ ܒܸܬ ܡܲܠܸܦ ܠܹܗ ܐܘܼܪܚܵܐ ܕܓܲܒܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","ܓܵܢܹܗ ܒܛܵܒ݂ܬܵ‌ܐ ܒܸܬ ܫܵܪܝܵܐ، ܘܙܲܪܥܹܗ ܒܸܬ ܝܵܪܹܬ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","ܫܵܘܬܵܦܘܼܬܵ‌ܐ ܕܡܵܪܝܵܐ ܥܲܡ ܙܕܝܼܥܘܼ̈ܗ‌ܝ ܝܠܵܗ̇، ܘܘܲܥܕܹܗ ܒܸܬ ܡܲܕܸܥ ܐܸܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","ܥܲܝܢܝܼ̈ ܐܲܡܝܼܢܵܐܝܼܬ ܠܡܵܪܝܵܐ ܝܢܵܐ، ܣܵܒܵܒ ܗ̇ܘ ܒܸܬ ܦܲܠܸܛ ܠܗܘܿܢ ܐܲܩܠܝܼ̈ ܡ̣ܢ ܓܲܪܕܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","ܕܘܼܪ ܠܟܸܣܠܝܼ ܘܪܲܚܸܡ ܥܲܠܝܼ، ܒܗ̇ܝ ܕܒܢܲܦ̮ܫܝܼ ܝܘܸܢ ܘܡܸܣܟܹܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","ܥܵܘܩܵܢܹ̈ܐ ܕܠܸܒܝܼ ܙܝܼܕ ܠܗܘܿܢ، ܡ̣ܢ ܐܘܼܠܨܵܢܝܼ ܦܲܠܸܛ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","ܚܙܝܼ ܥܵܘܩܵܢܝܼ ܘܥܲܡܠܝܼ، ܘܦܲܚܸܠܔ ܠܟܠܵܝܗ‌ܝ ܚܛܝܼܵܬ‌ܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","ܚܙܝܼ ܠܕܸܫ̃ܡܸܢܝܼ̈ ܕܙܝܼܕܹܐ ܝܢܵܐ، ܘܒܣܢܵܝܬܵ‌ܐ ܚܸܡܬܵܢܬܵ‌ܐ ܩܵܡ ܣܵܢܝܼ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","ܢܛܘܿܪ ܓܵܢܝܼ ܘܦܲܨܝܼ ܠܝܼ، ܠܵܐ ܫܵܒ݂ܩܹܬ ܢܵܟ݂ܦܹܢ ܒܗ̇ܝ ܕܫܩܝܼܠܔ ܠܝܼ ܓܵܘܣܵܐ ܒܝܼܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","ܫܒ݂ܘܿܩ ܬܲܡܝܼܡܘܼܬܵ‌ܐ ܘܬܪܘܼܨܘܼܬܵ‌ܐ ܚܲܡܹܐ ܠܝܼ، ܒܗ̇ܝ ܕܣܦܝܼܪܝܼ ܥܲܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","ܦܲܪܸܩ، ܝܵܐ ܐܲܠܵܗܵܐ، ܠܐܝܼܣܪܵܐܹܝܠܔ، ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܥܵܘܩܵܢܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","ܥܒ݂ܘܿܕ ܠܵܗ̇ ܕܝܼܘܵܢܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܒܗ̇ܝ ܕܐܵܢܵܐ ܒܬܲܡܝܼܡܘܼܬ‌ܝܼ ܚܕܝܼܪܝܼ، ܘܠܡܵܪܝܵܐ ܦܝܼܫ ܠܝܼ ܒܣܲܒ݂ܪܵܐ، ܠܹܐ ܫܵܥܫܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","ܒܚܘܿܪ ܐܸܠܝܼ، ܡܵܪܝܵܐ، ܘܓ̰ܲܪܸܒ ܠܝܼ، ܨܲܪܸܦ ܪܸܥܝܵܢܝܼ ܘܠܸܒܝܼ؛ ");
INSERT INTO aii_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","ܒܗ̇ܝ ܕܛܲܝܒܘܼܬܘܼܟ݂ ܩܲܕܡ ܥܲܝܢܝܼ̈ ܝܠܵܗ̇، ܘܚܕܝܼܪܝܼ ܒܡܗܘܼܡܢܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","ܠܵܐ ܝܬܝܼܒ݂ ܠܝܼ ܥܲܡ ܡܲܚܠܸܛܵܢܹ̈ܐ، ܘܥܲܡ ܡܲܫܦܸܪ̈ܵܢܹܐ ܠܹܐ ܥܵܒ݂ܕܹܢ ܫܵܘܬܵܦܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","ܣܢܹܐ ܠܝܼ ܠܟܢܘܼܫܝܵܐ ܕܥܵܒ݂ܕܵܢܹ̈ܐ ܕܒܝܼܫܬܵ‌ܐ، ܘܥܲܡ ܪ̈ܲܫܝܼܥܹܐ ܠܹܐ ܝܵܬܒܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","ܒܸܬ ܚܲܠܸܠܸܢ ܒܙܲܟܵܝܘܼܬܵ‌ܐ ܐܝܼܕܵܬ‌ܝܼ̈، ܘܚܵܕܪܹܢ ܠܚܵܕܸܪ̈ܘܵܢܹܐ ܕܡܲܕܒܚܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","ܠܡܲܫܡܘܼܥܹܐ ܩܵܠܵܐ ܕܫܲܟܲܪܬܵ‌ܐ، ܘܠܗܲܩܘܼܝܹܐ ܟܠܵܝܗ‌ܝ ܥܲܓ̰ܝܼܒܘܼܝܵܬܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","ܝܵܐ ܡܵܪܝܵܐ، ܡܘܼܚܸܒ ܠܝܼ ܠܡܲܥܡܪܵܐ ܕܒܲܝܬܘܼܟ݂، ܕܘܼܟܵܐ ܕܫܵܪܹܐ ܫܘܼܒ݂ܚܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","ܠܵܐ ܛܲܠܩܸܬ ܠܵܗ̇ ܓܵܢܝܼ ܥܲܡ ܚܲܛܵܝܹ̈ܐ، ܐܵܦܠܵܐ ܚܲܝܝܼ̈ ܥܲܡ ܫܲܦܟ݂ܵܢܹ̈ܐ ܕܕܸܡܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","ܐܲܝܢܝܼ ܕܒܐܝܼܕܵܝ̈ܗ‌ܝ ܐܝܼܬ ܨܢܝܼܥܘܼܬܵ‌ܐ، ܘܝܲܡܝܼܢܵܝܗ‌ܝ ܡܠܝܼܬܵ‌ܐ ܝܠܵܗ̇ ܪܸܫܘܲܬ. ");
INSERT INTO aii_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","ܐܝܼܢܵܐ ܐܵܢܵܐ، ܒܬܲܡܝܼܡܘܼܬ‌ܝܼ ܒܸܬ ܚܵܕܪܹܢ، ܦܲܪܸܩ ܠܝܼ ܘܪܲܚܸܡ ܥܲܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","ܐܲܩܠܝܼ ܟܠܹܐ ܠܵܗ̇ ܒܕܘܼܟܵܐ ܬܪܘܼܨܬܵ‌ܐ، ܓܵܘ ܟܸܢܫܹ̈ܐ ܒܸܬ ܒܲܪܟܸܢ ܠܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","ܡܵܪܝܵܐ ܒܲܗܪܝܼ ܝܠܹܗ ܘܦܘܼܪܩܵܢܝܼ، ܡ̣ܢ ܡܵܢܝܼ ܙܵܕܥܹܢ؟ ܡܵܪܝܵܐ ܩܲܠܥܵܐ ܕܚܲܝܝܼ̈ ܝܠܹܗ، ܡ̣ܢ ܡܵܢܝܼ ܫܵܥܫܹܢ؟ ");
INSERT INTO aii_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","ܟܲܕ ܩܘܼܪܒܸܢܗܘܿܢ ܥܲܠܝܼ ܒܝܼܫܹ̈ܐ ܕܐܵܟ݂ܠܝܼ ܒܸܣܪܝܼ، ܡܲܠܝܸܨܵܢܝܼ̈ ܘܕܸܫ̃ܡܸܢܝܼ̈، ܐܵܢܝܼ ܬܘܼܪܩܸܠܔ ܠܗܘܿܢ ܘܢܦܝܼܠܔ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","ܐܸܢ ܫܵܪܝܵܐ ܥܲܠܝܼ ܡܲܫܪܝܼܬܵ‌ܐ، ܠܹܐ ܙܵܕܹܥ ܠܸܒܝܼ؛ ܐܸܢ ܩܵܐܹܡ ܥܲܠܝܼ ܦܠܵܫܵܐ، ܗܸܫ ܐܵܢܵܐ ܒܣܲܒ݂ܪܵܐ ܝܘܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","ܚܕܵܐ ܛܠܵܒܬܵ‌ܐ ܥܒ݂ܝܼܕ ܠܝܼ ܡ̣ܢ ܡܵܪܝܵܐ، ܠܗ̇ܝ ܒܸܬ ܛܵܥܹܝܢ: ܕܝܵܬܒܹܢ ܒܒܲܝܬܵ‌ܐ ܕܡܵܪܝܵܐ ܟܠܵܝܗ‌ܝ ܝܵܘܡܵܢܹ̈ܐ ܕܚܲܝܝܼ̈؛ ܠܸܚܙܵܝܵܐ ܒܲܣܝܼܡܘܼܬܵ‌ܐ ܕܡܵܪܝܵܐ، ܘܠܦܲܪܦܘܼܠܹܐ ܒܗܲܝܟܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","ܣܵܒܵܒ ܒܸܬ ܛܲܫܹܐ ܠܝܼ ܒܡܛܲܠܠܹܗ ܒܝܵܘܡܵܐ ܕܒܝܼܫܬܵ‌ܐ، ܒܸܬ ܟܲܣܹܐ ܠܝܼ ܒܣܸܬܵܪܵܐ ܕܡܲܫܟܢܹܗ، ܥܲܠܔ ܐܝܼܨܵܪܵܐ ܒܸܬ ܡܲܪܸܡ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","ܘܐܵܕܝܼܵܐ ܒܸܬ ܦܵܐܹܫ ܡܘܼܪܡܵܐ ܪܹܝܫܝܼ ܥܸܠܸܠܔ ܡ̣ܢ ܕܸܫ̃ܡܸܢܝܼ̈ ܕܠܚܵܕܸܪ̈ܘܵܢܝܼ، ܘܒܸܬ ܕܵܒ݂ܚܹܢ ܒܡܲܫܟܢܹܗ ܕܸܒ݂ܚܹ̈ܐ ܟܲܕ ܫܲܒܘܼܚܹܐ، ܒܸܬ ܫܲܒܚܸܢ ܘܒܸܬ ܙܵܡܪܹܢ ܠܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","ܫܡܹܥ ܡܵܪܝܵܐ ܩܵܠܝܼ ܐܝܼܡܲܢ ܕܩܵܪܹܝܢ، ܘܪܲܚܸܡ ܥܲܠܝܼ ܘܓ̰ܲܘܸܒ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","ܐܝܼܡܲܢ ܕܐܡܝܼܪܘܼܟ݂: ”ܛܥܹܝܡܘܼܢ ܐܸܠܝܼ،“ ܐܡܝܼܪܹܗ ܐܸܠܘܼܟ݂ ܠܸܒܝܼ: ”ܐܸܠܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܒܸܬ ܛܵܥܹܝܢ.“ ");
INSERT INTO aii_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","ܠܵܐ ܛܲܫܹܝܬ ܦܵܬܘܼܟ݂ ܡܸܢܝܼ، ܠܵܐ ܡܲܕܸܪܸܬ ܠܹܗ ܪܹܓܘܼܟ݂ ܒܟܲܪܒܵܐ، ܗܲܝܲܪܬ‌ܝܼ ܗܘܹܐ ܠܘܼܟ݂، ܠܵܐ ܪܲܦܹܝܬ ܠܝܼ ܘܠܵܐ ܫܵܒ݂ܩܹܬ ܠܝܼ، ܝܵܐ ܐܲܠܵܗܵܐ ܕܦܘܼܪܩܵܢܝܼ؛ ");
INSERT INTO aii_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","ܣܵܒܵܒ ܒܵܒܝܼ ܘܝܸܡܝܼ ܫܒ݂ܝܼܩܸܢܗܘܿܢ، ܐܝܼܢܵܐ ܡܵܪܝܵܐ ܒܸܬ ܓ̰ܲܡܸܥ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","ܡܲܠܸܦ ܠܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܐܘܼܪܚܘܼܟ݂، ܘܡܗܲܕܝܼ ܠܝܼ ܒܫܒ݂ܝܼܠܵܐ ܬܪܘܼܨܵܐ، ܡ̣ܢ ܥܸܠܬܵ‌ܐ ܕܕܸܫ̃ܡܸܢܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","ܠܵܐ ܣܲܦܹܝܬ ܠܝܼ ܒܨܸܒ݂ܝܵܢܵܐ ܕܕܲܠܩܘܼܒ݂ܠܵܝܝܼ̈، ܣܵܒܵܒ ܩܝܼܡ ܠܗܘܿܢ ܥܲܠܝܼ ܣܵܗܕܹ̈ܐ ܕܲܓܵܠܹ̈ܐ ܘܢܵܦܚܵܢܹ̈ܐ ܕܚܸܡܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","ܐܵܢܵܐ ܗܘܼܡܸܢܝܼ ܠܸܚܙܵܝܵܐ ܠܛܵܒ݂ܬܵ‌ܐ ܕܡܵܪܝܵܐ ܒܐܲܪܥܵܐ ܕܚܵܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","ܣܦܘܿܪ ܠܡܵܪܝܵܐ، ܚܲܠܸܢ ܘܙܲܪܒܸܢ ܠܸܒܘܼܟ݂، ܘܣܦܘܿܪ ܠܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","ܐܸܠܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܟܹܐ ܩܵܪܹܝܢ، ܝܵܐ ܐܝܼܨܵܪܝܼ، ܠܵܐ ܐܵܟ̰ܡܹܬ ܢܵܬܘܼܟ݂ ܥܲܠܝܼ. ܠܵܐ ܗܵܘܹܐ ܕܫܵܬܩܹܬ ܥܲܠܝܼ، ܘܕܵܡܹܝܢ ܠܨܵܠܝܵܢܹ̈ܐ ܕܓܘܼܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","ܫܡܹܥ ܩܵܠܵܐ ܕܦܲܪܦܲܠܬ‌ܝܼ ܒܓܥܵܝܬ‌ܝܼ ܐܸܠܘܼܟ݂، ܒܡܲܪܲܡܬܵ‌ܐ ܕܐܝܼܕܵܬ‌ܝܼ̈ ܠܗܲܝܟܠܵܐ ܕܩܘܼܕܫܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","ܠܵܐ ܓܵܪܫܹܬ ܠܝܼ ܥܲܡ ܪ̈ܲܫܝܼܥܹܐ، ܘܥܲܡ ܦܵܠܚܵܢܹ̈ܐ ܕܥܵܘܠܵܐ، ܕܟܹܐ ܗܲܡܙܸܡܝܼ ܫܠܵܡܵܐ ܥܲܡ ܚܲܒ݂ܪ̈ܵܘܵܬܵܝܗ‌ܝ، ܟܲܕ ܒܝܼܫܬܵ‌ܐ ܒܠܸܒܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","ܦܪܹܥ ܠܗܘܿܢ ܐܲܝܟ݂ ܦܘܼܠܚܵܢܵܝܗ‌ܝ، ܘܐܲܝܟ݂ ܒܝܼܫܘܼܬܵ‌ܐ ܕܣܘܼܥܪ̈ܵܢܵܝܗ‌ܝ، ܐܲܝܟ݂ ܥܒ݂ܵܕܵܐ ܕܐܝܼܕܵܬܵܝ̈ܗ‌ܝ ܦܪܹܥ ܠܗܘܿܢ، ܡܲܕܸܪ ܦܘܼܪܥܵܢܵܝܗ‌ܝ ܥܲܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","ܒܗ̇ܝ ܕܠܹܐ ܦܲܪܡܝܼ ܠܦܘܼܠܚܵܢܹ̈ܐ ܕܡܵܪܝܵܐ، ܐܵܦܠܵܐ ܠܥܒ݂ܵܕܵܐ ܕܐܝܼܕܵܬܘܼ̈ܗ‌ܝ، ܒܸܬ ܬܲܠܸܚ ܠܗܘܿܢ ܘܠܹܐ ܒܵܢܹܐ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","ܒܪܝܼܟ݂ܵܐ ܝܠܹܗ ܡܵܪܝܵܐ، ܒܗ̇ܝ ܕܫܡܝܼܥ ܠܹܗ ܩܵܠܵܐ ܕܦܲܪܦܲܠܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","ܡܵܪܝܵܐ ܝܠܹܗ ܥܘܼܫܢܝܼ ܘܡܵܛܵܠܝܼ، ܒܝܼܹܗ ܣܒܝܼܪܹܗ ܠܸܒܝܼ، ܘܦܝܼܫ ܠܝܼ ܗܘܼܝܸܪܵܐ؛ ܒܘܼܬ ܐܵܗܵܐ، ܦܨܝܼܚ ܠܹܗ ܠܸܒܝܼ، ܘܒܙܡܵܪܬ‌ܝܼ ܒܸܬ ܫܲܟܪܸܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","ܡܵܪܝܵܐ ܝܠܹܗ ܥܘܼܫܢܵܐ ܠܥܲܡܹܗ، ܘܩܲܠܥܵܐ ܕܦܘܼܪܩܵܢܵܐ ܕܡܫܝܼܚܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","ܦܲܪܸܩ ܠܥܲܡܘܼܟ݂، ܘܒܲܪܸܟ݂ ܠܝܵܪܬܘܼܬܘܼܟ݂، ܘܡܲܪܥܝܼ ܠܗܘܿܢ، ܘܛܥܘܿܢ ܠܗܘܿܢ ܥܲܠܔ ܕܪ̈ܵܥܢܵܢܘܼܟ݂ ܗܲܠܔ ܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","ܗܲܒ݂ܠܘܼܢ ܠܡܵܪܝܵܐ، ܝܵܐ ܒܢܘܿܢܹ̈ܐ ܕܐܲܠܵܗܵܐ، ܗܲܒ݂ܠܘܼܢ ܠܡܵܪܝܵܐ ܐܝܼܩܵܪܵܐ ܘܚܲܝܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","ܗܲܒ݂ܠܘܼܢ ܠܡܵܪܝܵܐ ܐܝܼܩܵܪܵܐ ܕܫܸܡܹܗ، ܣܓ݂ܘܿܕܘܼܢ ܠܡܵܪܝܵܐ ܒܣܸܩܠܵܐ ܩܲܕܝܼܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","ܩܵܠܵܐ ܕܡܵܪܝܵܐ ܥܲܠܔ ܡ̈ܝܼܵܐ، ܐܲܠܵܗܵܐ ܕܐܝܼܩܵܪܵܐ ܩܲܪܩܘܼܡܹܐ، ܡܵܪܝܵܐ ܥܲܠܔ ܡ̈ܝܼܵܐ ܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","ܩܵܠܵܐ ܕܡܵܪܝܵܐ ܒܚܲܝܠܵܐ، ܩܵܠܵܐ ܕܡܵܪܝܵܐ ܒܣܸܩܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","ܩܵܠܵܐ ܕܡܵܪܝܵܐ ܒܸܬܒ݂ܵܪܵܐ ܐܲܪ̈ܙܹܐ، ܟܹܐ ܬܵܒܹܪ ܡܵܪܝܵܐ ܠܐܲܪ̈ܙܹܐ ܕܠܸܒ݂ܢܵܢ. ");
INSERT INTO aii_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","ܘܟܹܐ ܡܲܪܩܸܕ ܠܗܘܿܢ ܐܲܝܟ݂ ܡܘܼܓ̰ܵܐ، ܠܸܒ݂ܢܵܢ ܘܫܸܪܝܘܿܢ ܐܲܝܟ݂ ܒܲܪ ܪ̈ܲܝܡܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","ܩܵܠܵܐ ܕܡܵܪܝܵܐ ܡܲܢܕܘܼܝܹܐ ܠܵܗܹ̈ܐ ܕܢܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","ܩܵܠܵܐ ܕܡܵܪܝܵܐ ܟܹܐ ܡܲܫܥܸܫ ܒܲܪܝܼܵܐ، ܟܹܐ ܡܲܫܥܸܫ ܡܵܪܝܵܐ ܒܲܪܝܼܵܐ ܕܩܕܸܫ. ");
INSERT INTO aii_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","ܩܵܠܵܐ ܕܡܵܪܝܵܐ ܟܹܐ ܡܲܫܥܸܫ ܐܝܼܠܵܢܹ̈ܐ، ܘܟܹܐ ܥܵܩܹܪ ܡܲܝ̈ܫܵܬܹ‌ܐ، ܘܓܵܘ ܗܲܝܟܠܹܗ ܟܠܔ ܐܢܵܫܵܐ ܟܹܐ ܐܵܡܹܪ: ”ܐܝܼܩܵܪܵܐ!“ ");
INSERT INTO aii_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","ܡܵܪܝܵܐ ܥܲܠܔ ܛܵܘܦܵܢܵܐ ܟܹܐ ܝܵܬܹܒ݂، ܘܡܵܪܝܵܐ ܟܹܐ ܝܵܬܹܒ݂ ܡܲܠܟܵܐ ܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","ܡܵܪܝܵܐ ܩܵܐ ܥܲܡܹܗ ܚܲܝܠܵܐ ܒܸܬ ܝܵܗܒܹܠܔ، ܡܵܪܝܵܐ ܒܸܬ ܒܲܪܸܟ݂ ܠܥܲܡܹܗ ܒܫܠܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","ܒܸܬ ܡܲܪܡܸܢ ܐܸܠܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܒܗ̇ܝ ܕܓܪܝܼܫܸܢܘܼܟ݂ ܡ̣ܢ ܓܘܼܒܵܐ، ܘܠܵܐ ܡܘܼܚܕܹܐ ܠܘܼܟ݂ ܠܕܸܫ̃ܡܸܢܝܼ̈ ܒܝܼܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","ܝܵܐ ܡܵܪܝܵܐ ܐܲܠܵܗ‌ܝܼ، ܡܘܼܩܘܸܚ ܠܝܼ ܐܸܠܘܼܟ݂ ܘܩܵܡ ܒܲܣܡܸܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","ܝܵܐ ܡܵܪܝܵܐ، ܡܘܼܐܣܸܩ ܠܘܼܟ݂ ܠܓܵܢܝܼ ܡ̣ܢ ܫܝܘܿܠܔ، ܡܘܼܚܹܐ ܠܘܼܟ݂ ܐܸܠܝܼ ܡܓܵܘ ܨܵܠܝܵܢܹ̈ܐ ܕܓܘܼܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","ܙܡܘܿܪܘܼܢ ܠܡܵܪܝܵܐ، ܝܵܐ ܟܫܝܼܛܘܼ̈ܗ‌ܝ، ܘܫܲܟܪܘܼܢ ܠܕܟ݂ܵܪܵܐ ܕܩܘܼܕܫܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","ܒܗ̇ܝ ܕܩܵܐ ܚܕܵܐ ܛܲܪܦܲܛܬܵ‌ܐ ܝܠܵܗ̇ ܚܸܡܬܹܗ، ܐܝܼܢܵܐ ܩܵܐ ܡܸܬܚܵܐ ܕܚܲܝܘܼܬܵ‌ܐ ܝܠܹܗ ܒܘܼܣܵܡܹܗ، ܒܪܲܡܫܵܐ ܟܹܐ ܥܲܪܩܸܠܔ ܒܸܟ݂ܝܵܐ، ܐܝܼܢܵܐ ܒܨܲܦܪܵܐ ܟܹܐ ܐܵܬܝܵܐ ܫܲܒܲܚܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","ܘܐܵܢܵܐ ܐܡܝܼܪܝܼ ܒܫܸܠܝܘܼܬ‌ܝܼ: ”ܠܹܐ ܫܵܥܫܹܢ ܠܥܵܠܲܡ.“ ");
INSERT INTO aii_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","ܝܵܐ ܡܵܪܝܵܐ، ܒܨܸܒ݂ܝܵܢܘܼܟ݂ ܡܘܼܥܒܸܕ ܠܘܼܟ݂ ܛܘܼܪܝܼ ܕܟܵܠܹܐ ܚܲܝܠܵܢܵܐ، ܐܝܼܢܵܐ ܛܘܼܫܹܐ ܠܘܼܟ݂ ܦܵܬܘܼܟ݂ ܘܦܝܼܫ ܠܝܼ ܫܥܝܼܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","ܐܸܠܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܩܪܹܐ ܠܝܼ، ܘܒܡܵܪܝܵܐ ܢܘܼܢܹܐ ܠܝܼ: ");
INSERT INTO aii_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","”ܡܘܼܕܝܼ ܝܘܼܬܪܵܢܵܐ ܐܝܼܬ ܒܡܵܘܬ‌ܝܼ ܟܲܕ ܨܵܠܹܝܢ ܓܵܘ ܓܘܼܒܵܐ؟ ܗܵܐ، ܒܸܬ ܫܲܟܸܪܘܼܟ݂ ܥܲܦܪܵܐ؟ ܗܵܐ، ܒܸܬ ܡܲܕܸܥ ܫܲܪܝܼܪܘܼܬܘܼܟ݂؟ ");
INSERT INTO aii_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","”ܫܡܹܥ، ܝܵܐ ܡܵܪܝܵܐ، ܘܪܲܚܸܡ ܥܲܠܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܗܘܝܼ ܗܲܝܸܪܵܢܵܐ ܐܸܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","ܡܘܼܚܕܸܪܘܼܟ݂ ܐܸܒ݂ܠܝܼ ܠܪܸܩܕܵܐ، ܫܘܼܠܸܚ ܠܘܼܟ݂ ܣܲܩܝܼ ܘܩܵܡ ܡܲܠܒܸܫܸܬ ܠܝܼ ܚܲܕܘܼܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","ܩܵܐ ܕܙܵܡܪܵܐ ܐܸܠܘܼܟ݂ ܓܵܢܝܼ ܘܠܵܐ ܫܵܬܩܵܐ، ܝܵܐ ܡܵܪܝܵܐ ܐܲܠܵܗ‌ܝܼ، ܠܥܵܠܲܡ ܒܸܬ ܫܲܟܪܸܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","ܒܝܼܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܫܩܝܼܠܔ ܠܝܼ ܓܵܘܣܵܐ، ܠܵܐ ܫܵܒ݂ܩܹܬ ܢܵܟ݂ܦܹܢ ܠܥܵܠܲܡ، ܒܙܲܕܝܼܩܘܼܬܘܼܟ݂ ܦܲܨܝܼ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","ܡܲܟܸܦ ܐܸܠܝܼ ܢܵܬܘܼܟ݂، ܓ̰ܲܠܕܹܐ ܦܲܨܝܼ ܠܝܼ، ܗܘܝܼ ܐܸܠܝܼ ܐܝܼܨܵܪܵܐ ܕܩܲܠܥܵܐ، ܚܸܣܢܵܐ ܠܦܲܪܘܼܩܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","ܒܗ̇ܝ ܕܩܵܝܝܼ ܘܚܸܣܢܝܼ ܐܲܢ݇ܬ ܝܼܘܸܬ، ܘܒܘܼܬ ܫܸܡܘܼܟ݂ ܡܗܲܕܹܝܬ ܠܝܼ ܘܡܕܲܒܪܸܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","ܦܲܠܛܸܬ ܠܝܼ ܡ̣ܢ ܓܲܪܕܵܐ ܕܛܘܼܡܸܪܗܘܿܢ ܩܵܬ‌ܝܼ، ܒܗ̇ܝ ܕܐܲܢ݇ܬ ܝܼܘܸܬ ܩܲܠܥܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","ܒܐܝܼܕܘܼܟ݂ ܣܲܦܘܼܝܹܐ ܝܘܸܢ ܪܘܼܚܝܼ، ܦܘܼܪܸܩ ܠܘܼܟ݂ ܐܸܠܝܼ ܡܵܪܝܵܐ ܐܲܠܵܗܵܐ ܕܫܪܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","ܟܹܐ ܣܵܢܹܝܢ ܠܐܵܢܝܼ ܕܕܵܒ݂ܩܝܼ ܠܨܵܢܲܡܹ̈ܐ ܣܪ̈ܝܼܩܹܐ، ܘܒܡܵܪܝܵܐ ܣܒܝܼܪܝܼ ܐܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","ܒܸܬ ܦܵܨܚܹܢ ܘܒܸܬ ܚܵܕܹܝܢ ܒܛܲܝܒܘܼܬܘܼܟ݂، ܒܗ̇ܝ ܕܚܙܹܐ ܠܘܼܟ݂ ܥܵܘܩܵܢܝܼ، ܟܹܐ ܝܵܕܥܹܬ ܠܗܘܿܢ ܐܘܼܠܨܵܢܹ̈ܐ ܕܢܲܦ̮ܫܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","ܘܠܵܐ ܩܵܡ ܣܲܦܹܝܬ ܠܝܼ ܒܐܝܼܕܵܬܹ̈‌ܐ ܕܕܸܫ̃ܡܸܢ، ܡܘܼܟܠܹܐ ܠܘܼܟ݂ ܐܲܩܠܵܬ‌ܝܼ̈ ܒܕܘܼܟܵܐ ܪܘܝܼܚܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","ܪܲܚܸܡ ܥܲܠܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܒܗ̇ܝ ܕܥܝܼܩ ܠܵܗ̇ ܐܸܠܝܼ، ܚܒܹܐ ܠܗܘܿܢ ܥܲܝܢܝܼ̈ ܡ̣ܢ ܓ̰ܘܼܢܓ̰ܵܪܝܼ، ܢܘܝܼܠܔ ܠܗܘܿܢ ܓܵܢܝܼ ܘܐܘܼܦ ܦܲܓ݂ܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","ܒܗ̇ܝ ܕܬܝܼܡ ܠܗܘܿܢ ܚܲܝܝܼ̈ ܒܚܲܫܵܐ، ܘܥܒ݂ܝܼܪܗܘܿܢ ܫܸܢܝܼ̈ ܒܬܲܢܲܚܬܵ‌ܐ، ܡ̣ܢ ܥܵܘܠܝܼ ܒܨܝܼܪܹܗ ܚܲܝܠܝܼ، ܘܓܲܪ̈ܡܝܼ ܢܘܝܼܠܔ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","ܗܘܹܐ ܠܝܼ ܠܵܘܡܵܐ ܒܥܸܠܬܵ‌ܐ ܕܟܠܵܝܗ‌ܝ ܕܸܫ̃ܡܸܢܝܼ̈، ܘܠܟܸܣ ܫܒ݂ܵܒ݂ܝܼ̈ ܟܠܵܢܵܐܝܼܬ، ܘܗܘܹܐ ܠܝܼ ܙܕܘܼܥܬܵ‌ܐ ܠܝܵܕܥܵܢܝܼ̈، ܚܵܙܝܵܢܝܼ̈ ܒܥܵܠܘܿܠܵܐ ܥܪܝܼܩ ܠܗܘܿܢ ܡܸܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","ܦܝܼܫ ܠܝܼ ܢܸܫܝܵܐ ܡ̣ܢ ܠܸܒܵܐ ܐܲܝܟ݂ ܡܝܼܬܵ‌ܐ، ܗܘܹܐ ܠܝܼ ܐܲܝܟ݂ ܡܵܐܢܵܐ ܡܪܘܼܦܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","ܒܗ̇ܝ ܕܫܡܝܼܥ ܠܝܼ ܒܘܼܚܬܵܢ ܡ̣ܢ ܪܵܒܵܐ، ܐܝܼܬ ܙܕܘܼܥܬܵܐ ܡ̣ܢ ܚܵܕܸܪ̈ܘܵܢܝܼ، ܟܲܕ ܥܒ݂ܝܼܕ ܠܗܘܿܢ ܡܸܠܟܵܐ ܥܲܡ ܚܕܵܕܹ̈ܐ ܥܲܠܝܼ، ܬܘܼܚܡܸܢܗܘܿܢ ܠܸܫܩܵܠܵܐ ܓܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","ܘܐܵܢܵܐ ܒܝܼܘܼܟ݂ ܣܒܝܼܪܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܐܡܝܼܪܝܼ: ”ܐܲܠܵܗ‌ܝܼ ܝܘܸܬ ܐܲܢ݇ܬ.“ ");
INSERT INTO aii_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","ܒܐܝܼܕܘܼܟ݂ ܝܼܢܵܐ ܚܲܝܝܼ̈، ܦܲܨܝܼ ܠܝܼ ܡ̣ܢ ܐܝܼܕܵܐ ܕܕܸܫ̃ܡܸܢܝܼ̈، ܘܡ̣ܢ ܢܵܦܠܵܢܹ̈ܐ ܕܒܵܬܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","ܒܲܗܪܸܢ ܦܵܬܘܼܟ݂ ܥܲܠܔ ܪܹܓܘܼܟ݂، ܦܲܪܸܩ ܠܝܼ ܒܛܲܝܒܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","ܝܵܐ ܡܵܪܝܵܐ، ܠܵܐ ܫܵܒ݂ܩܹܬ ܢܵܟ݂ܦܹܢ ܒܗ̇ܝ ܕܩܪܹܐ ܠܝܼ ܐܸܠܘܼܟ݂، ܫܒ݂ܘܿܩ ܢܵܟ݂ܦܝܼ ܪ̈ܲܫܝܼܥܹܐ ܘܫܵܬܩܝܼ ܒܫܝܘܿܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","ܦܵܝܫܝܼ ܐܟ̰ܝܼܡܹܐ ܣܸܦܘܵܬܹ̈‌ܐ ܕܲܓܵܠܹ̈ܐ، ܕܒܫܘܼܒ݂ܗܵܪܵܐ ܟܹܐ ܗܲܡܙܸܡܝܼ ܥܲܠܔ ܙܲܕܝܼܩܵܐ، ܒܚܬܝܼܪܘܼܬܵ‌ܐ ܘܡܲܣܠܲܝܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","ܟܡܵܐ ܓܘܼܪܬܵ‌ܐ ܝܠܵܗ̇ ܛܵܒ݂ܬܘܼܟ݂ ܕܚܘܼܡܝܘܼܗ̇ ܝܘܸܬ ܩܵܐ ܙܕܝܼܥܘܼ̈ܟ݂، ܕܗܘܼܕܪܘܼܗ̇ ܝܘܸܬ ܩܲܕܡ ܒܢܲܝ̈ܢܵܫܵܐ ܩܵܐ ܣܵܒܪ̈ܵܢܹܐ ܕܒܝܼܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","ܟܹܐ ܟܲܣܹܝܬ ܠܗܘܿܢ ܒܣܸܬܵܪܵܐ ܕܦܵܬܘܼܟ݂ ܡ̣ܢ ܦܸܬܢܵܐ ܕܐܢܵܫܹ̈ܐ، ܟܹܐ ܛܲܫܹܝܬ ܠܗܘܿܢ ܒܡܛܲܠܠܵܐ ܡ̣ܢ ܡܲܩܪܲܨܬܵ‌ܐ ܕܠܸܫܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","ܒܪܝܼܟ݂ܵܐ ܝܠܹܗ ܡܵܪܝܵܐ، ܣܵܒܵܒ ܥܒ݂ܝܼܕܵܐ ܠܹܗ ܥܓ̰ܝܼܒܬܵ‌ܐ ܛܲܝܒܘܼܬܹܗ ܩܵܬ‌ܝܼ ܒܡܕܝܼܢ݇ܬܵ‌ܐ ܡܗܘܼܨܸܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","ܘܐܵܢܵܐ ܐܡܝܼܪܝܼ ܓܵܘ ܬܸܫܘܸܫܬ‌ܝܼ: ”ܦܝܼܫ ܠܝܼ ܩܛܝܼܥܵܐ ܡ̣ܢ ܩܲܕܡ ܥܲܝ̈ܢܘܼܟ݂،“ ܐܝܼܢܵܐ ܫܡܝܼܥ ܠܘܼܟ݂ ܩܵܠܵܐ ܕܦܲܪܦܲܠܬ‌ܝܼ ܐܝܼܡܲܢ ܕܡܘܼܩܘܸܚ ܠܝܼ ܐܸܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","ܡܲܚܸܒܘܼܢ ܠܡܵܪܝܵܐ ܟܠܵܝܗ‌ܝ ܙܲܕܝܼܩܘܼ̈ܗ‌ܝ. ܠܡܗܘܼܡܢܹ̈ܐ ܟܹܐ ܢܵܛܹܪ ܡܵܪܝܵܐ، ܐܝܼܢܵܐ ܡܸܠܝܵܐܝܼܬ ܟܹܐ ܦܵܪܹܥ ܠܚܵܬܪ̈ܵܢܹܐ ܐܲܝܟ݂ ܥܒ݂ܵܕܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","ܚܲܠܸܢܘܼܢ ܘܗܵܘܹܐ ܙܲܪܒܵܢܵܐ ܠܸܒܵܘܟ݂ܘܿܢ ܟܠܵܝܗ‌ܝ ܣܵܦܪ̈ܵܢܹܐ ܠܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","ܛܘܼܒ݂ܵܐ ܠܗ̇ܘ ܕܦܝܼܫܬܵ‌ܐ ܝܠܵܗ̇ ܦܘܼܚܸܠܬܵ‌ܐ ܓܢܵܗܹܗ، ܘܡܘܼܟܸܣܬܵ‌ܐ ܝܠܵܗ̇ ܚܛܝܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","ܛܘܼܒ݂ܵܐ ܠܐܢܵܫܵܐ ܕܠܵܐ ܚܲܫܒܸܢ ܡܵܪܝܵܐ ܐܸܠܹܗ ܥܵܘܠܵܐ، ܘܠܗ̇ܘ ܕܠܲܝܬ ܒܪܘܼܚܹܗ ܦܸܠܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","ܡ̣ܢ ܫܸܬܩܝܼ ܒܠܹܐ ܠܗܘܿܢ ܓܲܪ̈ܡܝܼ، ܒܬܲܢܲܚܬ‌ܝܼ ܟܠܹܗ ܝܵܘܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","ܣܵܒܵܒ ܒܐܝܼܡܵܡܵܐ ܘܒܠܲܝܠܹܐ ܝܘܼܩܪܸܢܵܗ̇ ܥܲܠܝܼ ܐܝܼܕܘܼܟ݂، ܚܕܝܼܪܵܗ̇ ܬܲܠܝܼܠܘܼܬ‌ܝܼ ܠܒܸܪ̈ܙܹܐ ܕܩܲܝܛܵܐ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","ܚܛܝܼܬ‌ܝܼ ܡܘܼܕܸܥ ܠܝܼ ܐܸܠܘܼܟ݂ ܘܥܵܘܠܝܼ ܠܵܐ ܟܘܼܣܹܐ ܠܝܼ، ܐܡܝܼܪܝܼ: ”ܒܸܬ ܡܵܘܕܸܢܗܘܿܢ ܓܢܵܗ‌ܝܼ̈ ܠܡܵܪܝܵܐ،“ ܘܐܲܢ݇ܬ ܫܒ݂ܝܼܩ ܠܘܼܟ݂ ܥܵܘܠܵܐ ܕܚܛܝܼܬ‌ܝܼ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","ܒܘܼܬ ܐܵܗܵܐ، ܒܸܬ ܨܲܠܹܐ ܟܠܔ ܛܵܒ݂ܵܐ ܐܸܠܘܼܟ݂ ܟܲܕ ܐܝܼܬ ܦܘܼܪܣܵܐ، ܒܫܪܵܪܵܐ، ܐܝܼܡܲܢ ܕܫܵܦܟ݂ܝܼ ܡ̈ܝܼܵܐ ܪܵܒܵܐ، ܠܹܐ ܡܵܛܝܼ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","ܐܲܢ݇ܬ ܣܸܬܵܪܵܐ ܝܘܸܬ ܩܵܬ‌ܝܼ، ܒܸܬ ܢܵܛܪܹܬ ܠܝܼ ܡ̣ܢ ܥܵܘܩܵܢܵܐ، ܒܩܲܘܲܚ̈ܝܵܬܹ‌ܐ ܕܦܘܼܪܩܵܢܵܐ ܒܸܬ ܟܵܪܟܹܬ ܠܝܼ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","ܒܸܬ ܡܲܦܪܸܡܸܢܘܼܟ݂ ܘܒܸܬ ܡܲܠܦܸܢܘܼܟ݂ ܒܐܘܼܪܚܵܐ ܕܐܵܙܹܠ݇ܬ، ܒܸܬ ܥܵܒ݂ܕܹܢ ܡܸܠܟܵܐ ܟܲܕ ܥܲܝܢܝܼ ܥܲܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","ܠܵܐ ܗܵܘܹܝܬܘܿܢ ܐܲܝܟ݂ ܣܘܼܣܵܐ ܝܲܢ ܐܲܝܟ݂ ܟܵܘܸܕܢܵܐ ܕܠܲܝܬ ܠܗܘܿܢ ܦܲܪܡܲܝܬܵ‌ܐ، ܐܲܝܢܝܼ ܕܐܵܬ‌ܝܼ ܠܙܲܒܛܘܼܢܹܐ ܒܦܓ݂ܘܼܕܵܐ ܘܠܲܥܡܵܐ، ܐܸܢ ܠܵܐ، ܠܹܐ ܩܲܪܒܸܢܝܼ ܐܸܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","ܪܵܒܵܐ ܝܢܵܐ ܕܲܪ̈ܕܹܐ ܕܪܲܫܝܼܥܵܐ، ܐܝܼܢܵܐ ܣܵܒܪܵܢܵܐ ܒܡܵܪܝܵܐ ܛܲܝܒܘܼܬܵ‌ܐ ܒܸܬ ܟܵܪܟ݂ܵܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","ܚܕܹܝܡܘܼܢ ܒܡܵܪܝܵܐ ܘܦܨܘܿܚܘܼܢ، ܝܵܐ ܙܲܕܝܼܩܹ̈ܐ، ܘܩܲܘܸܚܘܼܢ ܟܠܵܝܗ‌ܝ ܬܪ̈ܘܼܨܹܐ ܕܠܸܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","ܡܲܩܘܸܚܘܼܢ ܠܡܵܪܝܵܐ، ܝܵܐ ܙܲܕܝܼܩܹ̈ܐ، ܠܬܪ̈ܘܼܨܹܐ ܚܫܝܼܚܬܵ‌ܐ ܝܠܵܗ̇ ܬܸܫܒܘܿܚܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","ܫܲܟܪܘܼܢ ܠܡܵܪܝܵܐ ܒܟܸܢܵܪܵܐ، ܒܩܝܼܬܵܪܵܐ ܕܥܸܣܪܵܐ ܣܝܼܡܹ̈ܐ ܙܡܘܿܪܘܼܢ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","ܙܡܘܿܪܘܼܢ ܐܸܠܹܗ ܙܡܵܪܬܵ‌ܐ ܚܲܕܬܵ‌ܐ، ܨܦܵܝܝܼ ܡܚܹܝܡܘܼܢ ܥܲܡ ܩܲܘܲܚܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","ܣܵܒܵܒ ܬܪܘܼܨܵܐ ܝܠܹܗ ܚܲܒܪܵܐ ܕܡܵܪܝܵܐ، ܘܒܡܗܘܼܡܢܘܼܬܵ‌ܐ ܝܠܹܗ ܟܠܹܗ ܦܘܼܠܚܵܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","ܟܹܐ ܡܲܚܸܒ ܙܲܕܝܼܩܘܼܬܵ‌ܐ ܘܕܝܼܘܵܢ، ܡܠܝܼܬܵ‌ܐ ܝܠܵܗ̇ ܐܲܪܥܵܐ ܛܲܝܒܘܼܬܵ‌ܐ ܕܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","ܒܗܹܡܸܙܡܵܢ ܕܡܵܪܝܵܐ ܫܡܲܝܹ̈ܐ ܦܝܼܫ ܠܗܘܿܢ ܥܒ݂ܝܼܕܹܐ، ܒܢܫܲܡܬܵ‌ܐ ܕܦܘܼܡܹܗ ܟܠܹܗ ܚܲܝܠܵܘܵܬܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","ܟܹܐ ܓ̰ܲܡܸܥ ܐܲܝܟ݂ ܩܘܼܚܵܐ ܡ̈ܝܼܵܐ ܕܝܵܡܵܐ، ܟܹܐ ܡܲܬܸܒ݂ ܒܐܲܢܒܵܪܹ̈ܐ ܬܗܘܿܡܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","ܙܵܕܥܵܐ ܡ̣ܢ ܡܵܪܝܵܐ ܟܠܵܗ̇ ܐܲܪܥܵܐ، ܡܸܢܹܗ ܪܲܬܪܸܬ‌ܝܼ ܟܠܵܝܗ‌ܝ ܥܵܡܪ̈ܵܢܹܐ ܕܒܪܝܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","ܣܵܒܵܒ ܗ̇ܘ ܐܡܝܼܪܹܗ ܘܗܘܹܐ ܠܵܗ̇، ܗ̇ܘ ܦܩܝܼܕ ܠܹܗ ܘܟܠܹܐ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","ܡܵܪܝܵܐ ܟܹܐ ܫܵܡܹܛ ܡܸܠܟܵܐ ܕܐܸܡܘܵܬܹ̈‌ܐ، ܟܹܐ ܒܲܛܸܠܔ ܚܘܼܫܵܒܹ̈ܐ ܕܥܲܡܡܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","ܡܸܠܟܵܐ ܕܡܵܪܝܵܐ ܠܥܵܠܲܡ ܒܸܬ ܟܵܠܹܐ، ܚܘܼܫܵܒܹ̈ܐ ܕܠܸܒܹܗ ܠܕܵܪܵܐ ܘܕܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","ܛܘܼܒ݂ܵܐ ܠܐܘܼܡܬܵ‌ܐ ܕܡܵܪܝܵܐ ܝܠܹܗ ܐܲܠܵܗܘܼܗ̇، ܥܲܡܵܐ ܕܓܘܼܒܹܐ ܠܹܗ ܠܝܵܪܬܘܼܬܵ‌ܐ ܐܸܠܹܗ، ");
INSERT INTO aii_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","ܡ̣ܢ ܫܡܲܝܵܐ ܓܘܼܫܸܩ ܠܹܗ ܡܵܪܝܵܐ، ܚܙܹܐ ܠܹܗ ܠܟܠܵܝܗ‌ܝ ܒܢܲܝ̈ܢܵܫܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","ܡ̣ܢ ܕܘܼܟܵܐ ܕܝܬܵܒ݂ܬܹܗ ܚܝܼܪܹܗ ܥܲܠܔ ܟܠܵܝܗ‌ܝ ܥܵܡܪ̈ܵܢܹܐ ܕܐܲܪܥܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","ܓܵܒ݂ܠܵܢܵܐ ܕܠܸܒܵܐ ܕܟܠܵܝܗ‌ܝ، ܗ̇ܘ ܕܦܲܪܡܹܐ ܟܠܵܝܗ‌ܝ ܥܒ݂ܵܕܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","ܠܲܝܬ ܡܲܠܟܵܐ ܕܦܝܼܫ ܠܹܗ ܦܘܼܪܩܵܐ ܒܓܘܼܪܘܼܬܵ‌ܐ ܕܚܲܝܠܵܘܵܬܹ̈‌ܐ، ܓܲܒܵܪܵܐ ܠܹܐ ܦܵܐܹܫ ܦܘܼܨܝܵܐ ܒܓܘܼܪܘܼܬܵ‌ܐ ܕܚܲܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","ܕܘܼܓܠܵܐ ܝܠܹܗ ܣܘܼܣܵܐ ܩܵܐ ܦܲܪܲܩܬܵ‌ܐ، ܘܒܓܘܼܪܘܼܬܵ‌ܐ ܕܚܲܝܠܹܗ ܠܹܐ ܡܵܨܹܐ ܚܲܠܸܨ. ");
INSERT INTO aii_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","ܗܵܐ، ܥܲܝܢܵܐ ܕܡܵܪܝܵܐ ܠܙܕܝܼܥܘܼ̈ܗ‌ܝ ܝܠܵܗ̇، ܠܐܵܢܝܼ ܕܣܵܦܪܝܼ ܠܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","ܠܦܲܨܘܼܝܹܐ ܡ̣ܢ ܡܵܘܬܵ‌ܐ ܓܵܢܵܬܵܝ̈ܗ‌ܝ، ܘܠܡܲܚܘܼܝܵܝ ܒܙܲܒ݂ܢܵܐ ܕܟܸܦܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","ܓܵܢܲܢ ܣܦܝܼܪܵܗ̇ ܠܡܵܪܝܵܐ، ܗܲܝܲܪܬܲܢ ܘܡܵܛܵܠܲܢ ܗ̇ܘ ܝܼܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","ܣܵܒܵܒ ܒܝܼܹܗ ܒܸܬ ܚܵܕܹܐ ܠܸܒܲܢ، ܣܵܒܵܒ ܒܫܸܡܵܐ ܕܩܘܼܕܫܹܗ ܣܒܝܼܪܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","ܗܵܘܝܵܐ ܛܲܝܒܘܼܬܘܼܟ݂ ܥܲܠܲܢ، ܝܵܐ ܡܵܪܝܵܐ، ܕܵܐܟ݂ܝܼ ܕܣܦܝܼܪܲܢ ܐܸܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","ܒܸܬ ܒܲܪܟܸܢ ܠܡܵܪܝܵܐ ܒܟܠܔ ܥܕܵܢܵܐ، ܐܲܡܝܼܢܵܐܝܼܬ ܬܸܫܒܘܿܚܬܹܗ ܒܦܘܼܡܝܼ ܝܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","ܒܡܵܪܝܵܐ ܒܸܬ ܥܵܒ݂ܕܵܐ ܫܘܼܒ݂ܗܵܪܵܐ ܓܵܢܝܼ، ܫܵܡܥܝܼ ܡܸܣܟܹܢܹ̈ܐ ܘܚܵܕܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","ܥܲܡܝܼ ܓܲܪܘܸܣܘܼܢ ܠܡܵܪܝܵܐ، ܘܡܲܪܡܲܚ ܫܸܡܹܗ ܥܲܡ ܚܕܵܕܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","ܛܥܹܐ ܠܝܼ ܠܡܵܪܝܵܐ ܘܩܵܡ ܓ̰ܲܘܸܒ ܠܝܼ، ܘܡ̣ܢ ܟܠܵܝܗ‌ܝ ܙܕܘܼܥܝܵܬ‌ܝܼ̈ ܩܵܡ ܦܲܨܹܐ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","ܚܝܼܪܗܘܿܢ ܐܸܠܹܗ ܘܒܘܼܗܪܸܢܗܘܿܢ، ܘܦܵܬܘܵܬܵܝ̈ܗ‌ܝ ܠܹܐ ܦܵܝܫܝܼ ܢܟ݂ܝܼܦܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","ܐܵܗܵܐ ܡܸܣܟܹܢܵܐ ܩܪܹܐ ܠܹܗ، ܘܡܵܪܝܵܐ ܫܡܝܼܥ ܠܹܗ، ܘܡ̣ܢ ܟܠܵܝܗ‌ܝ ܐܘܼܠܨܵܢܘܼ̈ܗ‌ܝ ܦܘܼܪܸܩ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","ܟܹܐ ܡܵܚܹܐ ܡܲܫܪܝܼܬܵ‌ܐ ܡܲܠܲܐܟ݂ܵܐ ܕܡܵܪܝܵܐ ܚܵܕܸܪ̈ܘܵܢܹܐ ܕܙܕܝܼܥܘܼ̈ܗ‌ܝ، ܘܟܹܐ ܦܲܨܹܐ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","ܛܥܘܿܡܘܼܢ ܘܚܙܹܝܡܘܼܢ ܕܛܵܒ݂ܵܐ ܝܠܹܗ ܡܵܪܝܵܐ، ܛܘܼܒ݂ܵܐ ܠܐܢܵܫܵܐ ܕܫܵܩܹܠܔ ܓܵܘܣܵܐ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","ܙܕܹܥܡܘܼܢ ܡ̣ܢ ܡܵܪܝܵܐ، ܝܵܐ ܩܲܕܝܼܫܘܼ̈ܗ‌ܝ، ܣܵܒܵܒ ܠܲܝܬ ܚܘܼܣܪܵܢܵܐ ܠܙܕܝܼܥܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","ܓܘܼܪ̈ܝܹܐ ܕܐܲܪܝܵܐ ܡܘܼܣܟܸܢܗܘܿܢ ܘܟܦܝܼܢܗܘܿܢ، ܐܝܼܢܵܐ ܐܵܢܝܼ ܕܛܵܥܝܼ ܠܡܵܪܝܵܐ ܠܹܐ ܚܵܣܪܝܼ ܟܠܔ ܛܵܒ݂ܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","ܬܹܝܡܘܼܢ ܒܢܘܿܢܹ̈ܐ، ܫܡܹܥܡܘܼܢ ܐܸܠܝܼ، ܙܕܘܼܥܬܵ‌ܐ ܕܡܵܪܝܵܐ ܡܲܠܦܸܢܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","ܡܵܢܝܼ ܝܠܹܗ ܐܢܵܫܵܐ ܕܒܵܣܡܝܼ ܠܹܗ ܚܲܝܹ̈ܐ، ܗ̇ܘ ܕܡܲܚܸܒ ܝܵܘܡܵܢܹ̈ܐ ܠܸܚܙܵܝܵܐ ܛܵܒ݂ܬܵ‌ܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","ܢܛܘܿܪ ܠܸܫܵܢܘܼܟ݂ ܡ̣ܢ ܒܝܼܫܬܵ‌ܐ، ܘܣܸܦܘܵܬܘܼ̈ܟ݂ ܡ̣ܢ ܗܲܡܙܘܼܡܹܐ ܦܸܠܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","ܩܠܘܿܒ ܡ̣ܢ ܒܝܼܫܬܵ‌ܐ ܘܥܒ݂ܘܿܕ ܛܵܒ݂ܬܵ‌ܐ، ܛܥܝܼ ܫܠܵܡܵܐ ܘܢܦܘܿܠܔ ܒܵܬܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","ܥܲܝ̈ܢܹܐ ܕܡܵܪܝܵܐ ܠܙܲܕܝܼܩܹ̈ܐ ܝܢܵܐ، ܘܢܵܬܝܵܬܘܼ̈ܗ‌ܝ ܠܓܥܵܝܬܵܝܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","ܦܵܬܵ‌ܐ ܕܡܵܪܝܵܐ ܕܲܠܩܘܼܒ݂ܠܔ ܕܥܵܒ݂ܕܵܢܹ̈ܐ ܕܒܝܼܫܬܵ‌ܐ ܝܠܵܗ̇، ܠܸܩܛܵܥܵܐ ܡ̣ܢ ܐܲܪܥܵܐ ܕܟ݂ܵܪܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","ܡܘܼܩܘܸܚ ܠܗܘܿܢ ܘܡܵܪܝܵܐ ܫܡܝܼܥ ܠܹܗ، ܘܡ̣ܢ ܟܠܵܝܗ‌ܝ ܐܘܼܠܨܵܢܵܝ̈ܗ‌ܝ ܦܘܼܨܝܵܝ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","ܩܘܼܪܒܵܐ ܝܠܹܗ ܡܵܪܝܵܐ ܠܬܒ݂ܝܼܪܹ̈ܐ ܕܠܸܒܵܐ، ܘܠܡܲܟܝܼܟܹ̈ܐ ܒܪܘܼܚܵܐ ܟܹܐ ܦܲܪܸܩ. ");
INSERT INTO aii_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","ܪܵܒܵܐ ܝܢܵܐ ܥܵܘܩܵܢܹ̈ܐ ܕܙܲܕܝܼܩܵܐ، ܘܡ̣ܢ ܟܠܵܝܗ‌ܝ ܟܹܐ ܦܲܨܹܐ ܠܹܗ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","ܟܹܐ ܢܵܛܹܪ ܠܟܠܵܝܗ‌ܝ ܓܲܪ̈ܡܘܼܗ‌ܝ، ܐܘܼܦ ܚܲܕ ܠܵܐ ܦܝܼܫ ܠܹܗ ܬܒ݂ܝܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","ܒܝܼܫܬܵ‌ܐ ܒܸܬ ܡܲܡܝܸܬܵ‌ܐ ܠܪܲܫܝܼܥܵܐ، ܘܣܵܢܝܵܢܹ̈ܐ ܕܙܲܕܝܼܩܵܐ ܒܸܬ ܗܵܘܝܼ ܚܲܝܵܒܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","ܟܹܐ ܦܲܪܸܩ ܡܵܪܝܵܐ ܓܵܢܵܐ ܕܪܹ̈ܓܵܘܵܬܘܼܗ‌ܝ، ܘܠܹܐ ܗܵܘܝܼ ܚܲܝܵܒܹ̈ܐ ܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܫܵܩܠܝܼ ܓܵܘܣܵܐ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","ܟܠܝܼ ܒܕܝܼܘܵܢ، ܝܵܐ ܡܵܪܝܵܐ، ܩܲܕܡ ܐܵܢܝܼ ܕܥܵܒ݂ܕܝܼ ܕܝܼܘܵܢ ܥܲܠܝܼ، ܦܠܘܿܫ ܥܲܡ ܦܵܠܫܵܢܹ̈ܐ ܥܲܡܝܼ، ");
INSERT INTO aii_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","ܕܒ݂ܘܿܩ ܡܵܛܵܠܵܐ ܘܣܲܟܪܵܐ، ܘܩܘܼܡ ܠܗܲܝܲܪܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","ܘܓܪܘܿܫ ܪܘܼܡܚܵܐ ܘܕܒ݂ܘܿܩ ܠܐܘܼܪܚܵܐ ܕܢܵܦܠܵܢܹ̈ܐ ܒܵܬܪܝܼ، ܐܡܘܿܪ ܠܓܵܢܝܼ: ”ܐܵܢܵܐ ܝܘܸܢ ܦܘܼܪܩܵܢܵܟ݂ܝ.“ ");
INSERT INTO aii_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","ܢܵܟ݂ܦܝܼ ܘܦܵܝܫܝܼ ܡܘܼܢܟܸܦܹܐ ܛܵܥܝܵܢܹ̈ܐ ܠܓܵܢܝܼ، ܦܵܝܫܝܼ ܡܘܼܕܸܪܹܐ ܠܒܵܬܪܵܐ ܘܡܘܼܢܟܸܦܹܐ ܐܵܢܝܼ ܕܬܲܚܡܘܼܢܹܐ ܝܢܵܐ ܠܸܥܒ݂ܵܕܵܐ ܒܝܼܫܬܵ‌ܐ ܥܲܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","ܗܵܘܝܼ ܐܲܝܟ݂ ܬܸܒ݂ܢܵܐ ܩܲܕܡ ܦܵܘܚܵܐ، ܘܡܲܠܲܐܟ݂ܵܐ ܕܡܵܪܝܵܐ ܚܲܪܙܘܼܦܵܝ. ");
INSERT INTO aii_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","ܗܵܘܝܵܐ ܐܘܼܪܚܵܝܗ‌ܝ ܚܸܫܟܵܐ ܘܡܲܓ̰ܪ̈ܲܛܝܵܬܹ‌ܐ، ܘܡܲܠܲܐܟ݂ܵܐ ܕܡܵܪܝܵܐ ܒܸܢܦܵܠܵܐ ܒܵܬܪܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","ܒܗ̇ܝ ܕܠܵܐ ܥܸܠܬܵ‌ܐ ܛܘܼܫܹܐ ܠܗܘܿܢ ܐܸܠܝܼ ܓܲܪܕܵܝܗ‌ܝ، ܕܠܵܐ ܥܸܠܬܵ‌ܐ ܚܦܝܼܪܗܘܿܢ ܓܘܼܒܵܐ ܠܓܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","ܐܵܬܹ‌ܐ ܥܲܠܘܼܗ‌ܝ ܚܪܵܒ݂ܵܐ ܒܠܵܐ ܣܦܵܪܬܵ‌ܐ، ܕܵܒܹܩ ܐܸܠܹܗ ܓܲܪܕܵܐ ܕܛܘܼܫܹܐ ܠܹܗ، ܢܵܦܹܠܔ ܒܝܼܹܗ ܠܚܪܵܒ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","ܘܓܵܢܝܼ ܒܸܬ ܦܵܨܚܵܐ ܒܡܵܪܝܵܐ، ܦܨܵܚܵܐ ܒܸܬ ܦܵܨܚܵܐ ܒܦܘܼܪܩܵܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","ܟܠܵܗ̇ ܓܵܢܝܼ ܒܸܬ ܐܵܡܪܵܐ: ”ܝܵܐ ܡܵܪܝܵܐ، ܡܵܢܝܼ ܐܝܼܬ ܐܲܝܟ݂ ܕܝܼܘܼܟ݂؟ ܦܲܨܝܵܢܵܐ ܠܡܸܣܟܹܢܵܐ ܡ̣ܢ ܚܲܕ ܒܘܼܫ ܙܲܪܒܵܢܵܐ ܡܸܢܹܗ، ܘܠܡܸܣܟܹܢܵܐ ܘܠܣܢܝܼܩܵܐ ܡ̣ܢ ܚܵܛܘܿܦܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","ܟܹܐ ܩܵܝܡܝܼ ܣܵܗܕܹ̈ܐ ܣܸܪ̈ܝܹܐ، ܟܹܐ ܨܲܚܨܹܐ ܠܝܼ ܒܘܼܬ ܡܸܢܕܝܼ ܕܠܹܐ ܝܵܕܥܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","ܟܹܐ ܦܵܪܥܝܼ ܠܝܼ ܒܝܼܫܬܵ‌ܐ ܡܓܹܒܵܐ ܕܛܵܒ݂ܬܵ‌ܐ، ܠܸܥܒ݂ܵܕܘܼܗ̇ ܡܘܼܫܲܡܸܪ ܓܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","ܐܝܼܢܵܐ ܐܵܢܵܐ، ܟܲܕ ܡܪܝܼܥ ܠܗܘܿܢ ܠܒ݂ܝܼܫ ܠܝܼ ܣܲܩܵܐ، ܡܘܼܥܝܸܩܵܐ ܠܝܼ ܒܨܵܘܡܵܐ ܓܵܢܝܼ، ܘܨܠܘܿܬ‌ܝܼ ܠܚܦܵܩܝܼ ܕܝܼܪܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","ܐܲܝܟ݂ ܠܚܲܒ݂ܪܝܼ، ܐܲܝܟ݂ ܠܐܲܚܘܿܢܝܼ، ܚܕܝܼܪܝܼ ܠܸܥܒ݂ܵܕܵܐ ܐܸܒ݂ܠܵܐ، ܐܲܝܟ݂ ܥܵܒ݂ܕܵܢܵܐ ܕܬܵܥܙܝܼ ܠܝܸܡܵܐ، ܠܒ݂ܝܼܫܵܐ ܟܘܼܡܵܐ، ܡܘܼܟܸܦܵܐ ܠܝܼ ܓܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","ܐܝܼܢܵܐ ܒܬܲܪܩܲܠܬ‌ܝܼ ܦܨܝܼܚ ܠܗܘܿܢ ܘܓ̰ܡܝܼܥ ܠܗܘܿܢ، ܓ̰ܡܝܼܥ ܠܗܘܿܢ ܥܲܠܝܼ ܡܵܚܝܵܢܝܼ̈ ܘܠܵܐ ܝܕܝܼܥ ܠܝܼ، ܦܘܼܪܦܸܛܸܢܗܘܿܢ ܘܠܵܐ ܫܠܹܐ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","ܐܲܝܟ݂ ܚܲܢܦܹ̈ܐ ܡܲܣܚܘܼܪܹܐ ܡܘܼܣܚܸܪܗܘܿܢ ܒܝܼܝܼ، ܚܲܪܚܘܼܟ̰ܹܐ ܟܹܟܵܝ̈ܗ‌ܝ ܥܲܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","ܝܵܐ ܡܵܪܝܵܐ، ܟܡܵܐ ܒܸܬ ܗܵܘܹܝܬ ܓܲܫܘܼܩܹܐ، ܦܲܨܝܼ ܓܵܢܝܼ ܡ̣ܢ ܚܪ̈ܵܒ݂ܵܝܗ‌ܝ، ܡ̣ܢ ܓܘܼܪ̈ܝܹܐ ܕܐܲܪ̈ܝܹܐ ܝܼܚܝܼܕܵܝܘܼܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","ܒܸܬ ܫܲܟܪܸܢܘܼܟ݂ ܓܵܘ ܟܸܢܫܵܐ ܓܘܼܪܵܐ، ܓܵܘ ܥܲܡܵܐ ܙܲܪܒܵܢܵܐ ܒܸܬ ܫܲܒܚܸܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","ܠܵܐ ܚܵܕܝܼ ܥܲܠܝܼ ܕܸܫ̃ܡܸܢܝܼ̈ ܕܒܕܘܼܓܠܵܐ، ܣܵܢܝܵܢܝܼ̈ ܕܠܵܐ ܥܸܠܬܵ‌ܐ ܠܵܐ ܠܵܟܙܝܼ ܥܲܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","ܣܵܒܵܒ ܠܹܐ ܗܲܡܙܸܡܝܼ ܫܠܵܡܵܐ، ܘܥܲܠܔ ܫܸܠܝܹ̈ܐ ܕܒܐܲܪܥܵܐ ܟܹܐ ܚܵܫܒ݂ܝܼ ܦܸܠܡܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","ܘܡܘܼܪܘܸܚ ܠܗܘܿܢ ܦܘܼܡܵܝܗ‌ܝ ܥܲܠܝܼ، ܐܡܝܼܪܗܘܿܢ: ”ܐܲܗܵܐ! ܐܲܗܵܐ! ܚܙܹܐ ܠܗܘܿܢ ܥܲܝܢܲܢ̈.“ ");
INSERT INTO aii_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","ܚܙܹܐ ܠܘܼܟ݂ ܡܵܪܝܵܐ، ܠܵܐ ܗܵܘܹܝܬ ܫܬܝܼܩܵܐ، ܝܵܐ ܡܵܪܝܵܐ، ܠܵܐ ܪܵܚܩܹܬ ܡܸܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","ܪܥܘܿܫ ܘܬܥܘܿܪ ܠܕܝܼܘܵܢܝܼ، ܝܵܐ ܐܲܠܵܗ‌ܝܼ ܘܡܵܪܝܼ، ܠܨܒ݂ܘܼܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","ܥܒ݂ܘܿܕ ܠܵܗ̇ ܕܝܼܘܵܢܝܼ ܐܲܝܟ݂ ܙܲܕܝܼܩܘܼܬܘܼܟ݂، ܡܵܪܝܵܐ ܐܲܠܵܗ‌ܝܼ، ܕܠܵܐ ܚܵܕܝܼ ܒܝܼܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","ܠܵܐ ܐܵܡܪܝܼ ܒܠܸܒܵܝܗ‌ܝ: ”ܐܲܗܵܐ! ܗܘܹܐ ܠܹܗ ܨܸܒ݂ܝܵܢܵܐ ܕܓܵܢܲܢ. ܠܵܐ ܐܵܡܪܝܼ: ܒܠܝܼܥ ܠܲܢ ܐܸܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","ܢܵܟ݂ܦܝܼ ܘܦܵܝܫܝܼ ܡܘܼܢܟܸܦܹܐ ܟܠܵܝܗ‌ܝ ܡܸܚܕܵܕܹ̈ܐ ܚܵܕܝܵܢܹ̈ܐ ܠܒܝܼܫܓܲܕܘܼܬ‌ܝܼ، ܠܵܒ݂ܫܝܼ ܢܟ݂ܝܼܦܬܵ‌ܐ ܘܦܵܝܫܝܼ ܡܘܼܢܟܸܦܹܐ ܓܲܪ̈ܘܸܣܵܢܹܐ ܕܓܵܢܵܝܗ‌ܝ ܥܲܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","ܡܲܩܘܸܚܝܼ ܘܦܵܨܚܝܼ ܐܵܢܝܼ ܕܒܵܣܡܵܐ ܠܗܘܿܢ ܒܙܲܕܝܼܩܘܼܬ‌ܝܼ، ܘܐܲܡܝܼܢܵܐܝܼܬ ܐܵܡܪܝܼ: ”ܓܘܼܪܵܐ ܝܠܹܗ ܡܵܪܝܵܐ، ܗ̇ܘ ܕܒܵܣܡܵܐ ܠܹܗ ܒܫܠܵܡܵܐ ܕܪܹܓܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","ܘܠܸܫܵܢܝܼ ܒܸܬ ܗܲܡܙܸܡ ܙܲܕܝܼܩܘܼܬܘܼܟ݂، ܟܠܹܗ ܝܵܘܡܵܐ ܬܸܫܒܘܿܚܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","ܥܵܘܠܵܐ ܟܹܐ ܚܵܫܹܒ݂ ܪܲܫܝܼܥܵܐ ܒܓܵܘܵܐ ܕܠܸܒܹܗ، ܠܲܝܬ ܙܕܘܼܥܬܵ‌ܐ ܕܐܲܠܵܗܵܐ ܩܲܕܡ ܥܲܝܢܘܼ̈ܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","ܣܵܒܵܒ ܟܹܐ ܡܲܫܦܸܪܵܗ̇ ܓܵܢܹܗ ܒܥܲܝܢܘܼ̈ܗ‌ܝ، ܗܵܕܵܐ ܕܠܵܐ ܡܲܫ݇ܟ̰ܸܚ ܠܥܵܘܠܹܗ ܘܣܵܢܹܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","ܗܹܡܸܙܡܵܢܹ̈ܐ ܕܦܘܼܡܹܗ ܥܵܘܠܵܐ ܘܦܸܠܡܵܐ، ܫܠܹܐ ܠܹܗ ܡ̣ܢ ܠܦܲܪܡܘܼܝܹܐ ܘܠܸܥܒ݂ܵܕܵܐ ܛܵܒ݂ܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","ܥܵܘܠܵܐ ܟܹܐ ܬܲܚܡܸܢ ܥܲܠܔ ܫܘܝܼܬܹܗ، ܟܹܐ ܟܵܠܹܐ ܥܲܠܔ ܐܘܼܪܚܵܐ ܠܵܐ ܨܦܵܝܝܼ، ܒܝܼܫܬܵ‌ܐ ܠܹܐ ܡܲܣܠܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","ܡܵܪܝܵܐ ܗܲܠܔ ܫܡܲܝܵܐ ܝܠܵܗ̇ ܛܲܝܒܘܼܬܘܼܟ݂، ܡܗܘܼܡܢܘܼܬܘܼܟ݂ ܗܲܠܔ ܥܢܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","ܙܲܕܝܼܩܘܼܬܘܼܟ݂ ܐܲܝܟ݂ ܛܘܼܪ̈ܵܢܹܐ ܕܐܲܠܵܗܵܐ ܝܠܵܗ̇، ܕܝܼܘܵܢܘܼ̈ܟ݂ ܐܲܝܟ݂ ܬܗܘܿܡܵܐ ܓܘܼܪܵܐ، ܒܲܪܢܵܫܵܐ ܘܗܲܝܘܵܢ ܟܹܐ ܦܲܪܩܸܬ، ܝܵܐ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","ܟܡܵܐ ܝܲܩܝܼܪܬܵ‌ܐ ܝܠܵܗ̇ ܛܲܝܒܘܼܬܘܼܟ݂، ܝܵܐ ܐܲܠܵܗܵܐ، ܘܒܢܲܝ̈ܢܵܫܵܐ ܒܛܸܠܵܢܝܼܬܵ‌ܐ ܕܓܘܼܠܦܵܢܘܼ̈ܟ݂ ܟܹܐ ܫܵܩܠܝܼ ܓܵܘܣܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","ܟܹܐ ܫܵܬ‌ܝܼ ܣܒ݂ܵܥܬܵܝܗ‌ܝ ܡ̣ܢ ܫܲܡܝܼܢܘܼܬܵ‌ܐ ܕܒܲܝܬܘܼܟ݂، ܘܡ̣ܢ ܢܲܗܪܵܐ ܕܒܲܣܝܼܡܘܼܝܵܬ̈ܘܼܟ݂ ܟܹܐ ܡܲܫܬܹܝܬ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","ܣܵܒܵܒ ܥܲܡܘܼܟ݂ ܝܼܠܹܗ ܡܲܒܘܼܥܵܐ ܕܚܲܝܹ̈ܐ، ܒܒܲܗܪܘܼܟ݂ ܟܹܐ ܚܵܙܲܚ ܒܲܗܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","ܡܲܪܝܸܟ݂ ܛܲܝܒܘܼܬܘܼܟ݂ ܠܝܵܕܥܵܢܘܼ̈ܟ݂، ܘܙܲܕܝܼܩܘܼܬܘܼܟ݂ ܠܬܪ̈ܘܼܨܹܐ ܕܠܸܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","ܠܵܐ ܐܵܬܝܵܐ ܥܲܠܝܼ ܐܲܩܠܵܐ ܕܫܲܒ݂ܗܸܪ̈ܵܢܹܐ، ܘܐܝܼܕܵܐ ܕܪ̈ܲܫܝܼܥܹܐ ܠܵܐ ܫܵܥܫܵܐ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","ܬܵܡܵܐ ܢܦܝܼܠܔ ܠܗܘܿܢ ܦܵܠܚܵܢܹ̈ܐ ܕܥܵܘܠܵܐ، ܦܝܼܫ ܠܗܘܿܢ ܚܘܼܪܙܸܦܹܐ ܘܠܹܐ ܡܵܨܝܼ ܩܵܝܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","ܠܵܐ ܥܵܒ݂ܕܹܬ ܚܣܵܡܵܐ ܠܒܝܼܫܹ̈ܐ، ܠܵܐ ܒܲܚܸܠܸܬ ܒܥܵܒ݂ܕܵܢܹ̈ܐ ܕܥܵܘܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","ܣܵܒܵܒ ܐܲܝܟ݂ ܓܸܠܵܐ ܓ̰ܲܠܕܹܐ ܟܹܐ ܒܵܪܙܝܼ، ܘܐܲܝܟ݂ ܝܲܪܩܵܐ ܩܝܼܢܵܐ ܟܹܐ ܟ̰ܲܡܟ̰ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","ܣܒܘܿܪ ܒܡܵܪܝܵܐ ܘܥܒ݂ܘܿܕ ܛܵܒ݂ܬܵ‌ܐ، ܫܪܝܼ ܒܐܲܪܥܵܐ ܘܗܘܝܼ ܒܫܲܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","ܘܥܒ݂ܘܿܕ ܒܘܼܣܵܡܵܐ ܒܡܵܪܝܵܐ، ܘܒܸܬ ܝܵܗܒܹܠܔ ܠܘܼܟ݂ ܛܠܵܒܬܵ‌ܐ ܕܠܸܒܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","ܕܪܝܼ ܥܲܠܔ ܡܵܪܝܵܐ ܐܘܼܪܚܘܼܟ݂، ܘܣܒܘܿܪ ܒܝܼܹܗ، ܘܗ̇ܘ ܒܸܬ ܡܲܟܡܸܠܔ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","ܘܒܸܬ ܦܲܠܸܛ ܐܲܝܟ݂ ܒܲܗܪܵܐ ܙܲܕܝܼܩܘܼܬܘܼܟ݂، ܘܕܝܼܘܵܢܘܼ̈ܟ݂ ܐܲܝܟ݂ ܛܲܗܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","ܫܠܝܼ ܩܲܕܡ ܡܵܪܝܵܐ، ܘܣܦܘܿܪ ܐܸܠܹܗ، ܠܵܐ ܥܵܒ݂ܕܹܬ ܚܣܵܡܵܐ ܒܡܲܢܬܝܼܵܢܵܐ ܒܐܘܼܪܚܹܗ، ܒܐܢܵܫܵܐ ܥܵܒ݂ܕܵܢܵܐ ܕܦܸܠܡܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","ܪܦܝܼ ܡ̣ܢ ܟܲܪܒܵܐ ܘܫܒ݂ܘܿܩ ܚܸܡܬܵ‌ܐ، ܠܵܐ ܥܵܒ݂ܕܹܬ ܚܣܵܡܵܐ ܠܸܥܒ݂ܵܕܵܐ ܒܝܼܫܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","ܣܵܒܵܒ ܒܝܼܫܹ̈ܐ ܒܸܬ ܦܵܝܫܝܼ ܩܛܝܼܥܹܐ، ܐܝܼܢܵܐ ܣܵܦܪ̈ܵܢܹܐ ܠܡܵܪܝܵܐ، ܐܵܢܝܼ ܒܸܬ ܝܵܪܬ‌ܝܼ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","ܘܚܲܕܟ̰ܵܐ ܐܚܹܪܢܵܐ، ܘܠܲܝܬ ܪܲܫܝܼܥܵܐ، ܘܒܸܬ ܚܵܝܪܹܬ ܥܲܠܔ ܕܘܼܟܬܹܗ، ܐܝܼܢܵܐ ܠܲܝܬ ܗ̇ܘ. ");
INSERT INTO aii_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","ܐܝܼܢܵܐ ܡܸܣܟܹܢܹ̈ܐ ܒܸܬ ܝܵܪܬ‌ܝܼ ܐܲܪܥܵܐ، ܘܒܸܬ ܥܵܒ݂ܕܝܼ ܒܘܼܣܵܡܵܐ ܒܦܸܪܝܘܼܬܵ‌ܐ ܕܫܠܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","ܪܲܫܝܼܥܵܐ ܟܹܐ ܥܵܒܹܕ ܦܸܠܡܵܐ ܥܲܠܔ ܙܲܕܝܼܩܵܐ، ܘܟܹܐ ܚܲܪܚܸܟ̃ ܥܲܠܘܼܗ‌ܝ ܟܹܟܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","ܐܝܼܢܵܐ ܡܵܪܝܵܐ ܟܹܐ ܓܵܚܹܟ ܒܝܼܹܗ، ܣܵܒܵܒ ܚܙܹܐ ܠܹܗ ܕܒܸܬ ܐܵܬܹ‌ܐ ܝܵܘܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","ܣܲܝܦܵܐ ܓܪܝܼܫ ܠܗܘܿܢ ܪ̈ܲܫܝܼܥܹܐ، ܘܡܬܝܼܚ ܠܗܘܿܢ ܩܸܫܬܵܝܗ‌ܝ، ܠܡܲܢܦܘܼܠܹܐ ܡܸܣܟܹܢܵܐ ܘܣܢܝܼܩܵܐ، ܠܸܩܛܵܠܵܐ ܠܬܪ̈ܘܼܨܹܐ ܕܐܘܼܪܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","ܣܲܝܦܵܝܗ‌ܝ ܒܸܬ ܥܵܒܹܪ ܒܠܸܒܵܝܗ‌ܝ، ܘܩܸܫܬܵܬܵܝ̈ܗ‌ܝ ܒܸܬ ܦܵܝܫܝܼ ܬܒ݂ܝܼܪܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","ܡܸܢܕܝܼ ܩܲܠܝܼܠܔ ܕܙܲܕܝܼܩܵܐ ܒܘܼܫ ܨܦܵܝܝܼ ܝܠܹܗ ܡ̣ܢ ܥܘܼܬܪܵܐ ܕܪ̈ܲܫܝܼܥܹܐ ܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","ܣܵܒܵܒ ܕܪ̈ܲܥܢܵܢܹܐ ܕܪ̈ܲܫܝܼܥܹܐ ܒܸܬ ܦܵܝܫܝܼ ܬܒ݂ܝܼܪܹܐ، ܐܝܼܢܵܐ ܟܹܐ ܣܵܢܹܕ ܠܙܲܕܝܼܩܹ̈ܐ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","ܟܹܐ ܝܵܕܹܥ ܡܵܪܝܵܐ ܝܵܘܡܵܢܹ̈ܐ ܕܬܲܡܝܼܡܹ̈ܐ، ܝܵܪܬܘܼܬܵܝܗ‌ܝ ܠܥܵܠܲܡ ܒܸܬ ܗܵܘܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","ܠܹܐ ܢܵܟ݂ܦܝܼ ܒܙܲܒ݂ܢܵܐ ܕܒܝܼܫܬܵ‌ܐ، ܘܒܝܵܘܡܵܢܹ̈ܐ ܕܟܸܦܢܵܐ ܒܸܬ ܣܵܒ݂ܥܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","ܐܝܼܢܵܐ ܪ̈ܲܫܝܼܥܹܐ ܒܸܬ ܛܵܠܩܝܼ، ܘܕܸܫ̃ܡܸܢܹ̈ܐ ܕܡܵܪܝܵܐ ܐܲܝܟ݂ ܫܘܼܦܪܵܐ ܕܡܲܪ̈ܓܹܐ، ܒܸܬ ܬܵܝܡܝܼ، ܒܬܸܢܵܐ ܒܸܬ ܬܵܝܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","ܟܹܐ ܡܲܕܝܸܢ ܪܲܫܝܼܥܵܐ ܘܠܹܐ ܦܵܪܹܥ، ܐܝܼܢܵܐ ܙܲܕܝܼܩܵܐ ܟܹܐ ܪܲܚܸܡ ܘܟܹܐ ܝܵܗܒܹܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","ܣܵܒܵܒ ܡܒܘܼܪ̈ܟܹܐ ܕܡܵܪܝܵܐ ܒܸܬ ܝܵܪܬ‌ܝܼ ܐܲܪܥܵܐ، ܘܠܝܼܛܘܼ̈ܗ‌ܝ ܒܸܬ ܦܵܝܫܝܼ ܩܛܝܼܥܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","ܡ̣ܢ ܡܵܪܝܵܐ ܟܹܐ ܦܵܝܫܝܼ ܡܘܼܩܘܝܼܹܐ ܦܵܣܘܿܥܝܵܬܹ̈‌ܐ ܕܐܢܵܫܵܐ، ܘܒܐܘܼܪܚܹܗ ܟܹܐ ܒܵܣܡܵܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","ܐܵܦܸܢ ܢܵܦܹܠܔ، ܠܹܐ ܦܵܐܹܫ ܟ̰ܘܼܡܟ̰ܸܡܵܐ، ܣܵܒܵܒ ܡܵܪܝܵܐ ܟܹܐ ܣܵܢܹܕ ܐܝܼܕܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","ܝܵܠܵܕ݇ܐ ܗܘܹܐ ܠܝܼ ܐܘܼܦ ܣܝܼܒ݂ ܠܝܼ، ܐܝܼܢܵܐ ܠܵܐ ܚܙܹܐ ܠܝܼ ܙܲܕܝܼܩܵܐ ܫܒ݂ܝܼܩܵܐ، ܝܲܢ ܙܲܪܥܹܗ ܛܵܥܹܐ ܠܲܚܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","ܟܠܹܗ ܝܵܘܡܵܐ ܡܪܲܚܡܵܢܵܐ ܝܠܹܗ ܘܟܹܐ ܝܵܗܒܹܠܔ ܕܲܝܢܵܐ، ܘܠܒܘܼܪܟܬܵ‌ܐ ܝܢܵܐ ܙܲܪ̈ܥܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","ܩܠܘܿܒ ܡ̣ܢ ܒܝܼܫܬܵ‌ܐ ܘܥܒ݂ܘܿܕ ܛܵܒ݂ܬܵ‌ܐ، ܘܥܡܘܿܪ ܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","ܣܵܒܵܒ ܡܵܪܝܵܐ ܟܹܐ ܡܲܚܸܒ ܕܝܼܘܵܢ، ܘܠܹܐ ܫܵܒܹܩ ܠܛܵܒ݂ܘܼ̈ܗ‌ܝ، ܠܥܵܠܲܡ ܟܹܐ ܦܵܝܫܝܼ ܢܛܝܼܪܹܐ، ܐܝܼܢܵܐ ܙܲܪܥܵܐ ܕܪ̈ܲܫܝܼܥܹܐ ܒܸܬ ܦܵܐܹܫ ܩܛܝܼܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","ܙܲܕܝܼܩܹ̈ܐ ܒܸܬ ܝܵܪܬ‌ܝܼ ܐܲܪܥܵܐ، ܘܒܸܬ ܫܵܪܝܼ ܠܥܵܠܲܡ ܥܲܠܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","ܦܘܼܡܵܐ ܕܙܲܕܝܼܩܵܐ ܟܹܐ ܗܲܓܹܐ ܚܸܟ݂ܡܬܵ‌ܐ، ܘܠܸܫܵܢܹܗ ܟܹܐ ܗܲܡܙܸܡ ܕܝܼܘܵܢ. ");
INSERT INTO aii_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","ܢܵܡܘܿܣܵܐ ܕܐܲܠܵܗܹܗ ܒܠܸܒܹܗ ܝܠܹܗ، ܠܹܐ ܫܵܥܫܝܼ ܦܵܣܘܿܥܝܵܬܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","ܟܹܐ ܩܲܙܸܕ ܒܝܼܫܵܐ ܠܙܲܕܝܼܩܵܐ، ܘܟܹܐ ܛܵܥܹܐ ܠܡܲܡܝܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","ܐܝܼܢܵܐ ܡܵܪܝܵܐ ܠܹܐ ܫܵܒܹܩ ܠܹܗ ܒܐܝܼܕܹܗ، ܘܠܹܐ ܥܵܒܹܕ ܠܹܗ ܚܲܝܵܒ݂ܵܐ ܐܝܼܡܲܢ ܕܦܵܐܹܫ ܕܝܼܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","ܣܦܘܿܪ ܠܡܵܪܝܵܐ ܘܢܛܘܿܪ ܐܘܼܪܚܹܗ، ܘܒܸܬ ܡܲܪܸܡ ܠܘܼܟ݂ ܕܝܵܪܬܹܬ ܐܲܪܥܵܐ، ܐܝܼܡܲܢ ܕܦܵܝܫܝܼ ܩܛܝܼܥܹܐ ܪ̈ܲܫܝܼܥܹܐ ܒܸܬ ܚܵܙܹܝܬ. ");
INSERT INTO aii_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","ܚܙܹܐ ܠܝܼ ܪܲܫܝܼܥܵܐ ܙܵܠܝܼܡ ܓܲܪܘܘܼܣܘܼܗ̇ ܓܵܢܹܗ ܐܲܝܟ݂ ܐܝܼܠܵܢܵܐ ܩܝܼܢܵܐ ܒܐܲܪܥܹܗ ܟܝܵܢܵܝܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","ܘܫܘܼܢܹܐ ܠܹܗ، ܘܗܵܐ ܠܲܝܬ، ܘܛܥܹܐ ܠܝܼ ܒܵܬܪܹܗ، ܐܝܼܢܵܐ ܠܵܐ ܡܫ݇ܟ̰ܝܼܚ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","ܓܲܫܸܩ ܠܬܲܡܝܼܡܵܐ ܘܚܙܝܼ ܠܬܪܘܼܨܵܐ، ܣܵܒܵܒ ܐܝܼܬ ܕܲܥܬܝܼܕ ܩܵܐ ܐܢܵܫܵܐ ܕܫܠܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","ܐܝܼܢܵܐ ܥܵܘܵܠܹ̈ܐ ܒܸܬ ܛܵܠܩܝܼ ܥܲܡ ܚܕܵܕܹ̈ܐ، ܚܲܪܬܵ‌ܐ ܕܪ̈ܲܫܝܼܥܹܐ ܒܸܬ ܦܵܝܫܵܐ ܩܛܝܼܥܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","ܘܦܘܼܪܩܵܢܵܐ ܕܙܲܕܝܼܩܹ̈ܐ ܡ̣ܢ ܡܵܪܝܵܐ ܝܠܹܗ، ܗ̇ܘ ܝܼܠܹܗ ܩܲܠܥܵܝܗ‌ܝ ܒܙܲܒ݂ܢܵܐ ܕܥܵܘܩܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","ܘܟܹܐ ܗܲܝܸܪܗܘܿܢ ܡܵܪܝܵܐ ܘܟܹܐ ܦܲܨܹܐ ܠܗܘܿܢ، ܟܹܐ ܦܲܨܹܐ ܠܗܘܿܢ ܡ̣ܢ ܪ̈ܲܫܝܼܥܹܐ ܘܟܹܐ ܦܲܪܸܩ ܠܗܘܿܢ، ܣܵܒܵܒ ܟܹܐ ܫܵܩܠܝܼ ܓܵܘܣܵܐ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","ܒܟܲܪܒܘܼܟ݂ ܠܵܐ ܡܲܢܟܸܣܸܬ ܠܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܘܒܚܸܡܬܘܼܟ݂ ܠܵܐ ܬܲܥܠܡܸܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","ܒܗ̇ܝ ܕܓܹܐܪ̈ܘܼܟ݂ ܛܥܝܼܨ ܠܗܘܿܢ ܒܝܼܝܼ، ܘܥܲܠܝܼ ܨܠܹܐ ܠܵܗ̇ ܐܝܼܕܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","ܠܲܝܬ ܚܘܼܠܡܵܢܵܐ ܒܒܸܣܪܝܼ ܒܥܸܠܬܵ‌ܐ ܕܚܸܡܬܘܼܟ݂، ܠܲܝܬ ܫܲܠܡܘܼܬܵ‌ܐ ܒܓܲܪ̈ܡܝܼ ܒܥܸܠܬܵ‌ܐ ܕܚܛܝܼܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","ܣܵܒܵܒ ܐܣܝܼܩ ܠܗܘܿܢ ܥܵܘܠܝܼ̈ ܥܸܠܸܠܔ ܡ̣ܢ ܪܹܝܫܝܼ، ܐܲܝܟ݂ ܟܵܪܬܵ‌ܐ ܝܲܩܘܼܪܬܵ‌ܐ ܙܵܘܕܵܐ ܡ̣ܢ ܚܲܝܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","ܚܡܝܼܩ ܠܗܘܿܢ، ܓ̰ܪܹܐ ܠܗܘܿܢ ܕܲܪ̈ܒܵܬ‌ܝܼ، ܒܥܸܠܬܵ‌ܐ ܕܣܲܟ݂ܠܘܼܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","ܦܝܼܫ ܠܝܼ ܩܘܼܛܪܸܢܵܐ، ܟܝܼܦ ܠܝܼ ܗܲܠܔ ܦܪܵܩܬܵ‌ܐ، ܗܘܹܐ ܠܝܼ ܒܸܚܕܵܪܵܐ ܒܐܸܒ݂ܠܵܐ ܟܠܹܗ ܝܵܘܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","ܣܵܒܵܒ ܕܸܦܢܵܬ‌ܝܼ̈ ܡܸܠܝܹܐ ܝܢܵܐ ܩܝܘܼܕܵܐ، ܘܠܲܝܬ ܚܘܼܠܡܵܢܵܐ ܒܒܸܣܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","ܬܒ݂ܝܼܢܝܼ ܘܦܝܼܫ ܠܝܼ ܛܒ݂ܝܼܚܵܐ ܟ̰ܸܡ ܪܵܒܵܐ، ܒܘܼܪܒܸܪܝܼ ܡܣܵܒܵܒ ܫܓ݂ܝܼܫܘܼܬܵ‌ܐ ܕܠܸܒܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","ܡܵܪܝܵܐ، ܒܲܠܩܘܼܒ݂ܠܘܼܟ݂ ܝܼܠܵܗ̇ ܟܠܵܗ̇ ܛܠܵܒܬ‌ܝܼ، ܘܬܲܢܲܚܬ‌ܝܼ ܡܸܢܘܼܟ݂ ܠܹܐ ܝܠܵܗ̇ ܛܫܝܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","ܠܸܒܝܼ ܪܲܦܪܘܼܦܹܐ ܝܠܹܗ، ܫܒ݂ܝܼܩܸܢܹܗ ܚܲܝܠܝܼ، ܘܒܲܗܪܵܐ ܕܥܲܝܢܝܼ̈، ܐܘܼܦ ܗ̇ܘ ܠܲܝܬ ܥܲܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","ܡܲܚܸܒܵܢܝܼ̈ ܘܪ̈ܵܚܡܝܼ ܟܹܐ ܟܵܠܝܼ ܪܚܝܼܩܹܐ ܡ̣ܢ ܡܚܘܿܬ‌ܝܼ، ܘܚܸܙܡܵܢܝܼ̈ ܪܸܚܩܵܐ ܟܸܠܝܹܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","ܘܡܘܼܬܸܒ݂ ܠܗܘܿܢ ܢܸܫܒܹ̈ܐ ܛܵܥܝܵܢܹ̈ܐ ܠܓܵܢܝܼ، ܘܒܵܥܝܵܢܹ̈ܐ ܕܒܝܼܫܬ‌ܝܼ ܗܘܼܡܙܸܡ ܠܗܘܿܢ ܒܘܼܬ ܚܪܵܒ݂ܝܼ، ܘܟܹܐ ܗܲܓܝܼ ܦܸܠܡܹ̈ܐ ܟܠܹܗ ܝܵܘܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","ܐܝܼܢܵܐ ܐܵܢܵܐ ܐܲܝܟ݂ ܚܲܪܫܵܐ ܝܘܸܢ ܕܠܹܐ ܫܵܡܹܥ، ܘܐܲܝܟ݂ ܠܲܥܠܵܐ ܕܠܹܐ ܦܵܬܹܚ ܦܘܼܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","ܘܗܘܹܐ ܠܝܼ ܐܲܝܟ݂ ܐܢܵܫܵܐ ܕܠܹܐ ܫܵܡܹܥ، ܘܕܠܲܝܬ ܕܪܵܫܬܵ‌ܐ ܒܦܘܼܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","ܣܵܒܵܒ ܐܸܠܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܣܒܝܼܪܝܼ، ܐܲܢ݇ܬ ܒܸܬ ܓ̰ܲܘܸܒܸܬ، ܡܵܪܝܵܐ ܐܲܠܵܗ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","ܒܗ̇ܝ ܕܐܡܝܼܪܝܼ: ”ܠܵܐ ܗܵܘܹܐ ܕܚܵܕܝܼ ܥܲܠܝܼ، ܒܓ̰ܪܵܛܬܵ‌ܐ ܕܐܲܩܠܝܼ ܓܲܪܘܸܣܝܼ ܓܵܢܵܝܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","ܣܵܒܵܒ ܐܵܢܵܐ ܩܘܼܪܒܵܐ ܝܘܸܢ ܠܸܢܦܵܠܵܐ، ܘܟܹܐܒ݂ܝܼ ܥܲܡܝܼ ܝܠܹܗ ܒܟܠܔ ܥܕܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","ܗܹܐ، ܒܸܬ ܡܵܘܕܸܢܹܗ ܥܵܘܠܝܼ، ܒܸܬ ܦܵܫܡܹܢ ܒܘܼܬ ܚܛܝܼܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","ܘܕܸܫ̃ܡܸܢܝܼ̈ ܚܵܝܹ̈ܐ ܝܢܵܐ ܪܵܒܵܐ ܘܓܘܼܪܹ̈ܐ ܒܡܸܢܝܵܢܵܐ، ܘܦܸܪ̈ܝܹܐ ܝܢܵܐ ܣܵܢܝܵܢܝܼ̈ ܒܠܵܐ ܥܸܠܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","ܘܦܵܪ̈ܥܵܢܹܐ ܕܒܝܼܫܬܵ‌ܐ ܡ̣ܢ ܓܹܒܵܐ ܕܛܵܒ݂ܬܵ‌ܐ ܗܘܹܐ ܠܗܘܿܢ ܕܲܠܩܘܼܒ݂ܠܝܼ، ܒܗ̇ܝ ܕܢܦܝܼܠܔ ܠܝܼ ܒܵܬܪ ܛܵܒ݂ܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","ܠܵܐ ܫܵܒ݂ܩܹܬ ܠܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܝܵܐ ܐܲܠܵܗ‌ܝܼ، ܠܵܐ ܪܵܚܩܹܬ ܡܸܢܝܼ؛ ");
INSERT INTO aii_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","ܡܲܠܝܸܙ ܠܗܲܝܲܪܬ‌ܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܦܘܼܪܩܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","ܐܡܝܼܪܝܼ: ”ܒܸܬ ܢܵܛܪܹܢ ܐܘܼܪ̈ܚܵܬ‌ܝܼ، ܡ̣ܢ ܠܸܚܛܵܝܵܐ ܒܠܸܫܵܢܝܼ، ܒܸܬ ܐܵܣܪܹܢ ܠܦܘܼܡܝܼ، ܟܡܵܐ ܕܒܝܼܫܵܐ ܒܲܠܩܘܼܒ݂ܠܝܼ ܝܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","ܗܘܹܐ ܠܝܼ ܠܲܥܠܵܐ ܘܫܬܝܼܩܵܐ، ܐܘܼܦ ܫܬܝܼܩ ܠܝܼ ܡ̣ܢ ܛܵܒ݂ܬܵ‌ܐ، ܘܕܲܪ̈ܕܝܼ ܙܝܼܕ ܠܗܘܿܢ، ");
INSERT INTO aii_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","ܚܝܼܡ ܠܹܗ ܠܸܒܝܼ ܒܓܵܘܝܼ، ܒܗܲܓܲܝܬ‌ܝܼ ܒܸܠܒ݂ܵܟ݂ܵܐ ܝܗܘܵܐ ܢܘܼܪܵܐ، ܗ̇ܝܓܵܗ ܗܘܼܡܙܸܡ ܠܝܼ ܒܠܸܫܵܢܝܼ: ");
INSERT INTO aii_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","”ܡܲܕܸܥ ܐܸܠܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܚܲܪܬ‌ܝܼ، ܘܡܫܘܼܚܬܵ‌ܐ ܕܝܵܘܡܵܢܝܼ̈ ܡܘܼܕܝܼ ܝܠܵܗ̇، ܕܝܵܕܥܹܢ ܟܡܵܐ ܙܲܒ݂ܢܵܢܵܝܵܐ ܝܘܸܢ ܐܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","”ܗܵܐ، ܟܸܪ̈ܝܹܐ ܥܒ݂ܝܼܕܵܝ ܠܘܼܟ݂ ܝܵܘܡܵܢܝܼ̈، ܘܡܸܬܚܵܐ ܕܚܲܝܝܼ̈ ܐܲܝܟ݂ ܗܸܟ̃ ܡܸܢܕܝܼ ܝܠܹܗ ܠܟܸܣܠܘܼܟ݂، ܫܲܪܝܼܪܵܐܝܼܬ، ܐܲܚܟ̰ܝܼ ܚܕܵܐ ܢܫܲܡܬܵ‌ܐ ܝܠܹܗ ܟܠܔ ܒܲܪܢܵܫܵܐ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","”ܫܲܪܝܼܪܵܐܝܼܬ، ܐܲܝܟ݂ ܨܲܠܡܵܐ ܟܹܐ ܚܵܕܹܪ ܐܢܵܫܵܐ، ܫܲܪܝܼܪܵܐܝܼܬ، ܒܣܪܝܼܩܘܼܬܵ‌ܐ ܟܹܐ ܫܵܓܹܫ، ܟܹܐ ܡܲܙܝܸܕ ܥܘܼܬܪܵܐ ܘܠܹܐ ܝܵܕܹܥ ܡܵܢܝܼ ܒܸܬ ܓ̰ܲܡܸܥ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","”ܘܐܵܕܝܼܵܐ، ܠܡܘܼܕܝܼ ܣܵܦܪܹܢ، ܝܵܐ ܡܵܪܝܵܐ؟ ܣܲܒ݂ܪܝܼ ܒܝܼܘܼܟ݂ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","”ܦܲܨܝܼ ܠܝܼ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܓܢܵܗ‌ܝܼ̈، ܠܵܐ ܥܵܒ݂ܕܹܬ ܠܝܼ ܠܵܘܡܵܐ ܕܣܲܟ݂ܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","”ܗܘܹܐ ܠܝܼ ܠܲܥܠܵܐ، ܠܵܐ ܦܬܝܼܚ ܠܝܼ ܦܘܼܡܝܼ، ܣܵܒܵܒ ܐܲܢ݇ܬ ܥܒ݂ܝܼܕ ܠܘܼܟ݂ ܐܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","”ܡܲܥܒܸܪ ܡܥܲܠܝܼ ܡܚܘܿܬܘܼܟ݂، ܡ̣ܢ ܡܚܵܝܬܵ‌ܐ ܕܐܝܼܕܘܼܟ݂ ܐܵܢܵܐ ܬܝܼܡ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","”ܟܹܐ ܬܲܥܠܡܸܬ ܐܢܵܫܵܐ ܒܢܓ̰ܵܘ̈ܝܵܬܹ‌ܐ ܒܘܼܬ ܥܵܘܠܵܐ، ܘܟܹܐ ܡܲܚܪܸܒܸܬ ܐܲܝܟ݂ ܐܸܟ݂ܠܵܐ ܡܸܢܕܝܼ ܕܫܲܗܘܸܬ ܐܸܠܹܗ، ܫܲܪܝܼܪܵܐܝܼܬ، ܢܫܲܡܬܵ‌ܐ ܝܠܹܗ ܟܠܔ ܒܲܪܢܵܫܵܐ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","”ܫܡܹܥ ܨܠܘܿܬ‌ܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܘܠܓܥܵܝܬ‌ܝܼ ܗܲܒ݂ܠܔ ܢܵܬܵ‌ܐ، ܠܕܸܡܥܝܼܬ‌ܝܼ ܠܵܐ ܫܵܬܩܹܬ، ܒܗ̇ܝ ܕܡܵܫܵܚܲܛ ܝܘܸܢ ܐܵܢܵܐ ܠܟܸܣܠܘܼܟ݂، ܬܵܘܬܵܒ݂ܵܐ ܐܲܝܟ݂ ܟܠܵܝܗ‌ܝ ܐܲܒ݂ܵܗܵܬ‌ܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","”ܦܪܘܿܩ ܡܸܢܝܼ ܕܚܵܕܹܝܢ ܡܩܲܕܡ ܕܐܵܙܹܠ݇ܢ ܘܠܵܐ ܗܵܘܹܝܢ ܐܚܹܪܢܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","ܣܦܵܪܵܐ ܣܦܝܼܪܝܼ ܠܡܵܪܝܵܐ، ܘܦܬܝܼܠܔ ܠܹܗ ܠܟܸܣܠܝܼ ܘܫܡܝܼܥ ܠܹܗ ܓܥܵܝܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","ܘܩܵܡ ܡܲܐܣܸܩ ܠܝܼ ܡ̣ܢ ܓܘܼܒܵܐ ܕܚܪܵܒ݂ܵܐ، ܡ̣ܢ ܛܝܼܢܵܐ ܕܙܸܢܵܐ، ܘܡܘܼܩܸܡ ܠܹܗ ܥܲܠܔ ܩܵܝܵܐ ܐܲܩܠܵܬ‌ܝܼ̈، ܟܲܕ ܡܲܩܘܘܼܝܹܐ ܦܵܣܘܿܥܝܵܬ‌ܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","ܘܡܘܼܬܸܒ݂ ܠܹܗ ܒܦܘܼܡܝܼ ܙܡܵܪܬܵ‌ܐ ܚܲܕܬܵ‌ܐ ܕܬܸܫܒܘܿܚܬܵ‌ܐ ܠܐܲܠܵܗܵܐ، ܒܸܬ ܚܵܙܝܼ ܪܵܒܵܐ ܘܒܸܬ ܙܵܕܥܝܼ، ܘܒܸܬ ܣܵܒܪܝܼ ܒܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","ܛܘܼܒ݂ܵܐ ܠܐܢܵܫܵܐ ܕܥܵܒܹܕ ܠܡܵܪܝܵܐ ܬܘܼܟ݂ܠܵܢܹܗ، ܘܠܵܐ ܦܬܝܼܠܔ ܠܹܗ ܠܚܵܬܪ̈ܵܢܹܐ، ܐܘܼܦ ܠܵܐ ܠܐܵܙܵܠ݇ܢܹ̈ܐ ܒܵܬܪ ܕܘܼܓܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","ܪܵܒܵܐ ܥܒ݂ܝܼܕ ܠܘܼܟ݂ ܐܲܢ݇ܬ، ܝܵܐ ܡܵܪܝܵܐ ܐܲܠܵܗ‌ܝܼ، ܕܘܼܡܵܪܹ̈ܐ ܘܚܘܼܫܵܒܹ̈ܐ ܐܸܠܲܢ، ܠܲܝܬ ܐܲܝܟ݂ ܕܝܼܘܼܟ݂، ܐܸܢ ܡܲܕܥܸܢ ܗܘܵܐ ܘܗܲܡܙܸܡܸܢ ܗܘܵܐ، ܒܸܬ ܗܵܘܝܼ ܗܘܵܘ ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܠܸܡܢܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","ܒܕܸܒ݂ܚܵܐ ܘܒܩܘܼܪܒܵܢܵܐ ܠܵܐ ܒܣܝܼܡ ܠܵܗ̇ ܠܘܼܟ݂، ܩܵܡ ܦܵܬܚܹܬ ܠܗܘܿܢ ܢܵܬܝܵܬ‌ܝܼ̈، ܕܸܒ݂ܚܵܐ ܡܘܼܩܕܵܐ ܘܕܸܒ݂ܚܵܐ ܕܚܛܝܼܬܵ‌ܐ ܠܵܐ ܛܠܝܼܒ ܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","ܗ̇ܝܓܵܗ ܐܡܝܼܪܝܼ: ”ܗܵܐ، ܐܬܝܼܵܐ ܝܘܸܢ، ܒܟܸܪܟ݂ܵܐ ܕܟܬܵܒ݂ܵܐ ܦܝܼܫܵܐ ܠܹܗ ܟܬܝܼܒ݂ܵܐ ܒܘܼܬ ܕܝܼܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","”ܠܸܥܒ݂ܵܕܵܐ ܨܸܒ݂ܝܵܢܘܼܟ݂، ܝܵܐ ܐܲܠܵܗ‌ܝܼ، ܩܘܼܒܸܠܔ ܠܝܼ ܒܘܼܣܵܡܵܐ، ܘܢܵܡܘܿܣܘܼܟ݂ ܓܵܘ ܠܸܒܝܼ ܝܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","ܡܘܼܫܚܸܕ ܠܝܼ ܙܲܕܝܼܩܘܼܬܵ‌ܐ ܒܟܸܢܫܵܐ ܓܘܼܪܵܐ، ܗܵܐ، ܣܸܦܘܵܬ‌ܝܼ̈ ܠܹܐ ܡܲܟܠܸܢܗܘܿܢ، ܐܲܢ݇ܬ ܟܹܐ ܝܵܕܥܹܬ، ܝܵܐ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","ܙܲܕܝܼܩܘܼܬܘܼܟ݂ ܠܵܐ ܟܘܼܣܝܵܐ ܠܝܼ ܓܵܘ ܠܸܒܝܼ، ܗܘܼܡܙܸܡ ܠܝܼ ܒܘܼܬ ܡܗܘܼܡܢܘܼܬܘܼܟ݂ ܘܒܘܼܬ ܦܘܼܪܩܵܢܘܼܟ݂، ܠܛܲܝܒܘܼܬܘܼܟ݂ ܘܫܲܪܝܼܪܘܼܬܘܼܟ݂ ܠܵܐ ܛܘܼܫܹܐ ܠܝܼ ܡ̣ܢ ܟܸܢܫܵܐ ܓܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","ܐܲܢ݇ܬ، ܝܵܐ ܡܵܪܝܵܐ، ܠܹܐ ܚܵܣܟܹܬ ܪ̈ܲܚܡܘܼܟ݂ ܡܸܢܝܼ، ܛܲܝܒܘܼܬܘܼܟ݂ ܘܫܲܪܝܼܪܘܼܬܘܼܟ݂ ܐܲܡܝܼܢܵܐܝܼܬ ܟܹܐ ܢܵܛܪܝܼ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","ܣܵܒܵܒ ܩܵܡ ܟܵܪܟ݂ܝܼ ܠܝܼ ܒܝܼܫܵܬܹ̈‌ܐ ܒܠܵܐ ܡܸܢܝܵܢܵܐ، ܡܸܛܝܸܢܗܘܿܢ ܥܵܘܠܝܼ̈ ܘܠܹܐ ܝܘܸܢ ܒܸܡܨܵܝܵܐ ܕܚܵܙܹܝܢ، ܙܝܼܕ ܠܗܘܿܢ ܡ̣ܢ ܣܲܥܪܵܐ ܕܪܹܝܫܝܼ ܘܠܸܒܝܼ ܩܵܡ ܫܵܒܹܩ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","ܒܵܣܡܵܐ ܠܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܠܦܲܨܘܼܝܝܼ، ܡܲܠܝܸܙ ܠܗܲܝܲܪܬ‌ܝܼ، ܝܵܐ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","ܢܵܟ݂ܦܝܼ ܘܦܵܝܫܝܼ ܡܘܼܢܟܸܦܹܐ ܟܠܵܝܗ‌ܝ ܛܵܥܝܵܢܹ̈ܐ ܠܓܵܢܝܼ ܠܛܲܠܘܼܩܘܼܗ̇، ܕܵܝܪܝܼ ܠܒܵܬܪܵܐ ܘܗܵܘܝܼ ܡܘܼܣܠܝܼܹܐ ܐܵܢܝܼ ܕܒܵܣܡܵܐ ܠܗܘܿܢ ܒܒܝܼܫܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","ܦܵܝܫܝܼ ܬܡܝܼܗܹܐ ܡ̣ܢ ܢܟ݂ܝܼܦܬܵܝܗ‌ܝ، ܐܵܢܝܼ ܕܟܹܐ ܐܵܡܪܝܼ ܐܸܠܝܼ: ”ܐܘܿܚܲܝ! ܐܘܿܚܲܝ!“ ");
INSERT INTO aii_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","ܚܵܕܝܼ ܘܦܵܨܚܝܼ ܒܝܼܘܼܟ݂ ܟܠܵܝܗ‌ܝ ܛܵܥܝܵܢܹ̈ܐ ܐܸܠܘܼܟ݂، ܐܵܡܪܝܼ ܐܲܡܝܼܢܵܐܝܼܬ ܡܲܚܸܒܵܢܹ̈ܐ ܕܦܘܼܪܩܵܢܘܼܟ݂: ”ܗܵܘܹܐ ܓܘܼܪܵܐ ܡܵܪܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","ܘܐܵܢܵܐ ܡܸܣܟܹܢܵܐ ܝܘܸܢ ܘܣܢܝܼܩܵܐ، ܡܵܪܝܵܐ ܟܹܐ ܬܲܚܡܸܢ ܒܘܼܬ ܕܝܼܝܼ، ܗܲܝܲܪܬ‌ܝܼ ܘܦܲܨܝܵܢܝܼ ܐܲܢ݇ܬ ܝܼܘܸܬ، ܝܵܐ ܐܲܠܵܗ‌ܝܼ، ܠܵܐ ܥܲܪܩܸܠܸܬ. ");
INSERT INTO aii_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","ܛܘܼܒ݂ܵܐ ܠܡ̇ܢ ܕܬܲܚܡܸܢ ܒܘܼܬ ܡܸܣܟܹܢܵܐ، ܒܝܵܘܡܵܐ ܕܒܝܼܫܬܵ‌ܐ ܒܸܬ ܦܲܨܹܐ ܠܹܗ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","ܡܵܪܝܵܐ ܒܸܬ ܢܵܛܹܪܹܗ ܘܚܲܡܹܐ ܠܹܗ ܚܵܝܵܐ، ܒܸܬ ܗܵܘܹܐ ܛܘܼܒ݂ܵܢܵܐ ܒܐܲܪܥܵܐ، ܘܠܹܐ ܣܲܦܹܝܬ ܠܹܗ ܒܨܸܒ݂ܝܵܢܵܐ ܕܕܸܫ̃ܡܸܢܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","ܡܵܪܝܵܐ ܒܸܬ ܣܵܢܹܕ ܠܹܗ ܥܲܠܔ ܫܘܝܼܬܵ‌ܐ ܕܟܹܐܒ݂ܘܼ̈ܗ‌ܝ، ܠܚܘܼܠܡܵܢܵܐ ܡܘܼܕܸܪܘܼܟ݂ ܟܠܹܗ ܡܲܪܥܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","ܐܵܢܵܐ ܐܡܝܼܪܝܼ: ”ܝܵܐ ܡܵܪܝܵܐ، ܪܲܚܸܡ ܥܲܠܝܼ، ܒܲܣܸܡ ܠܓܵܢܝܼ ܒܗ̇ܝ ܕܚܛܹܐ ܠܝܼ ܐܸܠܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","ܕܸܫ̃ܡܸܢܝܼ̈ ܟܹܐ ܐܵܡܪܝܼ ܒܝܼܫܬܵ‌ܐ ܥܲܠܝܼ: ”ܐܝܼܡܲܢ ܒܸܬ ܡܵܐܹܬ ܘܛܵܠܹܩ ܫܸܡܹܗ؟“ ");
INSERT INTO aii_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","ܘܐܸܢ ܐܵܬܹ‌ܐ ܠܸܚܙܵܝܝܼ ܣܪܝܼܩܘܼܬܵ‌ܐ ܟܹܐ ܗܲܡܙܸܡ، ܟܹܐ ܓ̰ܲܡܸܥ ܥܵܘܠܵܐ ܠܸܒܹܗ، ܟܹܐ ܦܵܠܹܛ ܠܫܘܼܩܵܐ ܘܟܹܐ ܗܲܡܙܸܡ. ");
INSERT INTO aii_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","ܟܠܵܝܗ‌ܝ ܣܵܢܝܵܢܝܼ̈ ܡܸܚܕܵܕܹ̈ܐ ܟܹܐ ܦܲܛܦܸܛܝܼ ܠܕܲܠܩܘܼܒ݂ܠܝܼ، ܟܹܐ ܚܵܫܒ݂ܝܼ ܒܝܼܫܬܵ‌ܐ ܥܲܠܝܼ، ܒܹܐܡܵܪܵܐ: ");
INSERT INTO aii_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","”ܡܸܢܕܝܼ ܣܸܪܝܵܐ ܫܦܝܼܟ݂ܵܐ ܝܠܹܗ ܥܲܠܘܼܗ‌ܝ، ܘܐܝܼܡܲܢ ܕܕܵܡܹܟ݂ ܠܹܐ ܩܵܐܹܡ ܡܸܢܕܪܸܫ.“ ");
INSERT INTO aii_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","ܐܘܼܦ ܪܵܚܡܝܼ ܕܩܘܼܪܒܵܐ، ܗ̇ܘ ܕܗܘܼܡܸܢܝܼ ܒܝܼܹܗ، ܐܵܟ݂ܠܵܢܵܐ ܕܠܲܚܡܝܼ، ܡܘܼܪܸܡ ܠܹܗ ܥܲܠܝܼ ܥܸܩܒܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","ܐܝܼܢܵܐ ܐܲܢ݇ܬ، ܝܵܐ ܡܵܪܝܵܐ، ܪܲܚܸܡ ܥܲܠܝܼ، ܘܡܲܩܸܡ ܠܝܼ ܕܦܵܪܥܹܢܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","ܒܐܵܗܵܐ ܝܕܝܼܥ ܠܝܼ ܕܟܹܐ ܒܵܣܡܵܐ ܠܘܼܟ݂ ܒܝܼܝܼ، ܒܗ̇ܝ ܕܠܹܐ ܡܲܩܘܸܚ ܕܸܫ̃ܡܸܢܝܼ ܒܙܵܟ݂ܘܼܬܵ‌ܐ ܥܲܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","ܘܒܘܼܬ ܕܝܼܝܼ، ܩܵܡ ܣܵܢܕܹܬ ܠܝܼ ܒܬܲܡܝܼܡܘܼܬ‌ܝܼ، ܘܢܨܝܼܒ݂ ܠܘܼܟ݂ ܐܸܠܝܼ ܩܲܕܡ ܦܵܬܘܼܟ݂ ܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","ܒܪܝܼܟ݂ܵܐ ܝܠܹܗ ܡܵܪܝܵܐ ܐܲܠܵܗܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ، ܡ̣ܢ ܥܵܠܲܡ ܗܲܠܔ ܥܵܠܲܡ، ܐܵܡܹܝܢ ܘܐܵܡܹܝܢ. ");
INSERT INTO aii_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","ܐܲܝܟ݂ ܐܲܝܠܵܐ ܕܪܲܚܪܸܚ ܠܫܵܩ̈ܝܼܵܬܹ‌ܐ ܕܡ̈ܝܼܵܐ، ܗܵܕܟ݂ܵܐ ܓܵܢܝܼ ܪܲܚܪܘܼܚܹܐ ܝܠܵܗ̇ ܐܸܠܘܼܟ݂، ܝܵܐ ܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","ܨܗܝܼܬܵ‌ܐ ܝܠܵܗ̇ ܓܵܢܝܼ ܠܐܲܠܵܗܵܐ، ܠܐܲܠܵܗܵܐ ܚܵܝܵܐ. ܐܝܼܡܲܢ ܒܸܬ ܐܵܬܹܝܢ ܘܦܵܝܫܹܢ ܚܸܙܝܵܐ ܩܲܕܡ ܐܲܠܵܗܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","ܕܸܡܥܝܼܬ‌ܝܼ ܗܘܹܐ ܠܵܗ̇ ܐܸܠܝܼ ܠܡܹܐܟ݂ܘܼܠܬܵ‌ܐ، ܐܝܼܡܵܡܵܐ ܘܠܲܝܠܹܐ، ܟܲܕ ܒܹܐܡܵܪܵܐ ܝܢܵܐ ܐܸܠܝܼ ܟܠܹܗ ܝܵܘܡܵܐ: ”ܐܲܝܟܵܐ ܝܠܹܗ ܐܲܠܵܗܘܼܟ݂؟“ ");
INSERT INTO aii_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","ܐܲܢܹܐ ܟܹܐ ܕܵܟ݂ܪܹܢ ܘܟܹܐ ܝܵܠܨܵܐ ܥܲܠܝܼ ܓܵܢܝܼ: ܕܵܐܟ݂ܝܼ ܕܥܒ݂ܝܼܪܝܼ ܓܵܘ ܟܸܢܫܵܐ، ܙܘܼܝܸܚ ܠܝܼ ܥܲܡܵܝܗ‌ܝ ܗܲܠܔ ܒܲܝܬܵ‌ܐ ܕܐܲܠܵܗܵܐ، ܒܩܵܠܵܐ ܕܬܸܫܒܘܿܚܬܵ‌ܐ ܘܫܲܟܲܪܬܵ‌ܐ، ܟܢܘܼܫܝܵܐ ܒܸܥܒ݂ܵܕܵܐ ܥܹܐܕܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","ܩܵܡܘܿܕܝܼ ܟܝܼܦܬܵ‌ܐ ܝܘܲܬ‌ܝ، ܝܵܐ ܓܵܢܝܼ، ܘܫܓ݂ܝܼܫܬܵ‌ܐ ܝܘܲܬ‌ܝ ܒܓܵܘܝܼ؟ ܣܦܘܿܪܝ ܠܐܲܠܵܗܵܐ، ܣܵܒܵܒ ܡܸܢܕܪܸܫ ܒܸܬ ܫܲܟܪܸܢܹܗ، ܝܵܐ ܦܵܪܘܿܩܝܼ ");
INSERT INTO aii_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","ܘܐܲܠܵܗ‌ܝܼ. ܓܵܢܝܼ ܟܝܼܦܬܵ‌ܐ ܝܠܵܗ̇ ܒܓܵܘܝܼ، ܒܘܼܬ ܐܵܗܵܐ، ܒܸܬ ܕܵܟ݂ܪܹܢܘܼܟ݂ ܡ̣ܢ ܐܲܪܥܵܐ ܕܝܘܿܪܕܢܵܢ، ܘܛܘܼܪ̈ܵܢܹܐ ܕܚܸܪܡܘܿܢ، ܡ̣ܢ ܛܘܼܪܵܐ ܕܡܸܨܥܲܪ. ");
INSERT INTO aii_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","ܬܗܘܿܡܵܐ ܠܬܗܘܿܡܵܐ ܟܹܐ ܩܵܪܹܐ ܒܩܵܠܵܐ ܕܫܲܪܫܘܿܪ̈ܘܼܟ݂، ܟܠܵܝܗ‌ܝ ܡܲܚܫܘܼܠܘܼ̈ܟ݂ ܘܠܲܦܘܼ̈ܟ݂ ܥܲܠܝܼ ܥܒ݂ܝܼܪܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","ܒܐܝܼܡܵܡܵܐ ܟܹܐ ܦܵܩܹܕ ܡܵܪܝܵܐ ܛܲܝܒܘܼܬܹܗ، ܘܒܠܲܝܠܹܐ ܬܸܫܒܘܿܚܬܹܗ ܥܲܡܝܼ ܝܠܵܗ̇- ܨܠܘܿܬܵ‌ܐ ܠܐܲܠܵܗܵܐ ܕܚܲܝܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","ܒܸܬ ܐܵܡܪܹܢ ܠܐܲܠܵܗܵܐ ܩܵܝܝܼ: ”ܩܵܡܘܿܕܝܼ ܩܵܡ ܡܲܢܫܹܝܬ ܠܝܼ؟ ܩܵܡܘܿܕܝܼ ܚܵܕܪܹܢ ܒܸܥܒ݂ܵܕܵܐ ܐܸܒ݂ܠܵܐ ܒܡܲܠܝܲܨܬܵ‌ܐ ܕܕܸܫ̃ܡܸܢ؟ ");
INSERT INTO aii_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","”ܐܲܝܟ݂ ܬܒ݂ܵܪܬܵ‌ܐ ܕܓܵܘ ܓܲܪ̈ܡܝܼ ܟܹܐ ܠܵܝܡܝܼ ܠܝܼ ܡܲܠܝܸܨܵܢܝܼ̈، ܟܲܕ ܒܹܐܡܵܪܵܐ ܝܢܵܐ ܐܸܠܝܼ ܟܠܹܗ ܝܵܘܡܵܐ: ܐܲܝܟܵܐ ܝܠܹܗ ܐܲܠܵܗܘܼܟ݂؟“ ");
INSERT INTO aii_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","ܩܵܡܘܿܕܝܼ ܟܝܼܦܬܵ‌ܐ ܝܘܲܬ‌ܝ، ܝܵܐ ܓܵܢܝܼ؟ ܘܩܵܡܘܿܕܝܼ ܫܓ݂ܝܼܫܬܵ‌ܐ ܝܘܲܬ‌ܝ ܒܓܵܘܝܼ؟ ܣܦܘܿܪܝ ܠܐܲܠܵܗܵܐ ܣܵܒܵܒ ܡܸܢܕܪܸܫ ܒܸܬ ܫܲܟܪܸܢܹܗ، ܝܵܐ ܦܵܪܘܿܩܝܼ ܘܐܲܠܵܗ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","ܥܒ݂ܘܿܕ ܕܝܼܘܵܢܝܼ، ܝܵܐ ܐܲܠܵܗܵܐ، ܘܫܩܘܿܠܔ ܬܘܼܥܠܝܼ ܡ̣ܢ ܐܘܼܡܬܵ‌ܐ ܠܵܐ ܡܗܘܼܡܸܢܬܵ‌ܐ، ܡ̣ܢ ܐܢܵܫܵܐ ܕܦܸܠܡܵܐ ܘܥܵܘܠܵܐ ܦܲܨܝܼ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","ܣܵܒܵܒ ܐܲܢ݇ܬ ܝܼܘܸܬ ܐܲܠܵܗܵܐ ܕܚܲܝܠܝܼ؛ ܩܵܡܘܿܕܝܼ ܡܘܼܚܦܸܠܔ ܠܘܼܟ݂ ܐܸܠܝܼ؟ ܩܵܡܘܿܕܝܼ ܚܵܕܪܹܢ ܒܸܥܒ݂ܵܕܵܐ ܐܸܒ݂ܠܵܐ ܒܡܲܠܝܲܨܬܵ‌ܐ ܕܕܸܫ̃ܡܸܢ؟ ");
INSERT INTO aii_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","ܫܲܕܸܪ ܒܲܗܪܘܼܟ݂ ܘܫܲܪܝܼܪܘܼܬܘܼܟ݂، ܐܵܢܝܼ ܒܸܬ ܡܕܲܒܪܝܼ ܠܝܼ، ܒܸܬ ܡܲܝܬ‌ܝܼ ܠܝܼ ܠܛܘܼܪܵܐ ܕܩܘܼܕܫܘܼܟ݂ ܘܠܡܲܫܟܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","ܗ̇ܝܓܵܗ ܒܸܬ ܐܵܬܹܝܢ ܠܡܲܕܒܚܵܐ ܕܐܲܠܵܗܵܐ، ܠܟܸܣ ܐܲܠܵܗܵܐ ܕܪܲܒܘܼܬܵ‌ܐ ܕܦܨܵܚܬ‌ܝܼ، ܘܒܸܬ ܫܲܟܪܸܢܘܼܟ݂ ܒܟܸܢܵܪܵܐ، ܝܵܐ ܐܲܠܵܗܵܐ، ܐܲܠܵܗ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","ܩܵܡܘܿܕܝܼ ܟܝܼܦܬܵ‌ܐ ܝܘܲܬ‌ܝ، ܝܵܐ ܓܵܢܝܼ؟ ܘܩܵܡܘܿܕܝܼ ܫܓ݂ܝܼܫܬܵ‌ܐ ܝܘܲܬ‌ܝ ܒܓܵܘܝܼ؟ ܣܦܘܿܪܝ ܠܐܲܠܵܗܵܐ ܣܵܒܵܒ ܡܸܢܕܪܸܫ ܒܸܬ ܫܲܟܪܸܢܹܗ، ܝܵܐ ܦܵܪܘܿܩܝܼ ܘܐܲܠܵܗ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","ܝܵܐ ܐܲܠܵܗܵܐ ܒܢܵܬܝܵܬܲܢ̈ ܫܡܝܼܥ ܠܲܢ، ܐܲܒ݂ܵܗܵܬܲܢ̈ ܗܘܼܩܹܐ ܠܗܘܿܢ ܐܸܠܲܢ، ܒܘܼܬ ܦܘܼܠܚܵܢܹ̈ܐ ܕܦܠܝܼܚ ܠܘܼܟ݂ ܒܝܵܘܡܵܢܵܝ̈ܗ‌ܝ، ܒܝܵܘܡܵܢܹ̈ܐ ܩܲܕܝܼܡܵܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","ܐܲܢ݇ܬ ܒܐܝܼܕܘܼܟ݂ ܛܪܝܼܕܵܝ ܠܘܼܟ݂ ܐܸܡܘܵܬܹ̈‌ܐ ܘܢܨܝܼܒ݂ܵܝ ܠܘܼܟ݂ ܐܲܒ݂ܵܗܵܬܲܢ̈، ܥܒ݂ܝܼܕ ܠܘܼܟ݂ ܣܪܝܼܬܵ‌ܐ ܠܥܲܡܡܹ̈ܐ ܘܡܘܼܦܪܸܣܵܝ ܠܘܼܟ݂ ܐܲܒ݂ܵܗܵܬܲܢ̈. ");
INSERT INTO aii_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","ܣܵܒܵܒ ܠܹܐ ܝܗܘܵܐ ܒܣܲܝܦܵܝܗ‌ܝ ܕܩܵܡ ܝܵܪܬ‌ܝܼ ܠܵܗ̇ ܐܲܪܥܵܐ، ܐܵܦܠܵܐ ܕܪܲܥܢܵܝܗ‌ܝ ܩܵܡ ܦܲܪܸܩ ܠܗܘܿܢ، ܐܸܠܵܐ ܝܲܡܝܼܢܘܼܟ݂ ܘܕܪܲܥܢܘܼܟ݂ ܘܒܲܗܪܵܐ ܕܦܵܬܘܼܟ݂، ܣܵܒܵܒ ܒܣܝܼܡ ܠܵܗ̇ ܠܘܼܟ݂ ܒܝܼܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","ܐܲܢ݇ܬ ܝܼܘܸܬ ܡܲܠܟܝܼ، ܝܵܐ ܐܲܠܵܗܵܐ، ܦܩܘܿܕ ܦܘܼܪܩܵܢܵܐ ܕܝܲܥܩܘܿܒ݂. ");
INSERT INTO aii_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","ܒܝܼܘܼܟ݂ ܒܸܬ ܡܵܚܲܚ ܠܡܲܠܝܸܨܵܢܲܢ̈، ܒܫܸܡܘܼܟ݂ ܒܸܬ ܕܲܫܕܸܫܲܚ ܠܩܵܝܡܵܢܹ̈ܐ ܕܥܲܠܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","ܣܵܒܵܒ ܒܩܸܫܬ‌ܝܼ ܠܹܐ ܦܵܝܫܹܢ ܒܣܲܒ݂ܪܵܐ، ܘܣܲܝܦܝܼ ܠܹܐ ܦܲܪܸܩ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","ܣܵܒܵܒ ܐܲܢ݇ܬ ܩܵܡ ܦܲܪܩܸܬ ܠܲܢ ܡ̣ܢ ܡܲܠܝܸܨܵܢܲܢ̈، ܘܣܵܢܝܵܢܲܢ̈ ܡܘܼܢܟܸܦܵܝ ܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","ܒܐܲܠܵܗܵܐ ܫܘܼܒܸܚ ܠܲܢ ܟܠܹܗ ܝܵܘܡܵܐ، ܘܠܫܸܡܘܼܟ݂ ܗܲܠܔ ܥܵܠܲܡ ܒܸܬ ܫܲܟܪܲܚ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","ܐܝܼܢܵܐ ܡܘܼܚܦܸܠܔ ܠܘܼܟ݂ ܘܡܘܼܢܟܸܦ ܠܘܼܟ݂ ܐܸܠܲܢ، ܘܠܹܐ ܦܵܠܛܹܬ ܥܲܡ ܚܲܝܠܵܘܵܬܲܢ̈. ");
INSERT INTO aii_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","ܡܘܼܕܸܪܘܼܟ݂ ܐܸܠܲܢ ܠܒܵܬܪܵܐ ܡ̣ܢ ܩܲܕܡ ܕܸܫ̃ܡܸܢ، ܘܣܵܢܝܵܢܲܢ̈ ܣܠܝܼܒ ܠܗܘܿܢ ܩܵܐ ܓܵܢܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","ܩܵܡ ܝܵܗܒܹܬ ܠܲܢ ܐܲܝܟ݂ ܥܸܪ̈ܒܹܐ ܕܦܵܝܫܲܚ ܐܟ݂ܝܼܠܹܐ، ܘܓܵܘ ܐܸܡܘܵܬܹ̈‌ܐ ܩܵܡ ܒܵܙܩܹܬ ܠܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","ܙܘܼܒܸܢܘܼܟ݂ ܠܥܲܡܘܼܟ݂ ܪܵܒܵܐ ܐܲܪܙܵܢ، ܘܠܵܐ ܩܢܹܐ ܠܘܼܟ݂ ܒܛܝܼܡܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","ܩܵܡ ܥܵܒ݂ܕܹܬ ܠܲܢ ܠܵܘܡܵܐ ܠܫܒ݂ܵܒܲܢ̈، ܡܲܣܚܲܪܬܵ‌ܐ ܘܠܵܘܡܵܐ ܠܐܵܢܝܼ ܕܝܼܢܵܐ ܚܵܕܸܪ̈ܘܵܢܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","ܩܵܡ ܥܵܒ݂ܕܹܬ ܠܲܢ ܡܲܬܠܵܐ ܓܵܘ ܐܸܡܘܵܬܹ̈‌ܐ، ܥܸܠܬܵ‌ܐ ܕܫܥܵܫܬܵ‌ܐ ܕܪܹܝܫܵܐ ܓܵܘ ܥܲܡܡܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","ܟܠܹܗ ܝܵܘܡܵܐ ܢܟܸܦܬ‌ܝܼ ܩܲܕܡܝܼ ܝܠܵܗ̇، ܘܢܟܸܦܬܵ‌ܐ ܕܦܵܬ‌ܝܼ ܩܵܡ ܟܲܣܝܵܐ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","ܡ̣ܢ ܥܸܠܬܵ‌ܐ ܕܩܵܠܵܐ ܕܠܵܝܡܵܢܵܐ ܘܓܵܕܦܵܢܵܐ، ܡ̣ܢ ܩܲܕܡ ܕܸܫ̃ܡܸܢ ܘܫܵܩܠܵܢܵܐ ܕܬܘܼܥܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","ܟܠܵܗ̇ ܐܵܗܵܐ ܐܬܹ‌ܐ ܠܵܗ̇ ܥܲܠܲܢ ܘܠܵܐ ܢܫܹܐ ܠܲܢ ܐܸܠܘܼܟ݂، ܘܠܵܐ ܕܘܼܓܸܠܔ ܠܲܢ ܠܘܲܥܕܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","ܠܵܐ ܕܝܼܪܹܗ ܠܒܵܬܪܵܐ ܠܸܒܲܢ، ܐܵܦܠܵܐ ܩܠܝܼܒ ܠܗܘܿܢ ܦܵܣܘܿܥܝܵܬܲܢ̈ ܡ̣ܢ ܐܘܼܪܚܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","ܐܝܼܢܵܐ ܩܵܡ ܛܵܒ݂ܚܹܬ ܠܲܢ ܒܐܲܪܥܵܐ ܕܟ̰ܲܩܵܠܹ̈ܐ، ܘܩܵܡ ܡܲܟܣܸܬ ܠܲܢ ܒܛܸܠܵܢܝܼܬܵ‌ܐ ܕܡܵܘܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","ܐܸܢ ܗܵܘܲܚ ܢܸܫܝܹܗ ܫܸܡܵܐ ܕܐܲܠܵܗܲܢ، ܘܦܪܝܼܣܵܝ ܐܝܼܕܵܬܲܢ̈ ܠܟܸܣ ܐܲܠܵܗܵܐ ܢܘܼܟ݂ܪܵܝܵܐ؛ ");
INSERT INTO aii_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","ܗܵܐ، ܠܹܐ ܒܵܚܹܪ ܐܲܠܵܗܵܐ ܠܐܵܗܵܐ؟ ܣܵܒܵܒ ܗ̇ܘ ܟܹܐ ܝܵܕܹܥ ܡܸܢܕܝܼ ܛܸܫܝܵܐ ܕܠܸܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","ܐܝܼܢܵܐ ܒܘܼܬ ܕܝܼܘܼܟ݂ ܦܝܵܫܵܐ ܝܘܲܚ ܩܛܝܼܠܹܐ ܟܠܹܗ ܝܵܘܡܵܐ، ܦܝܼܫ ܠܲܢ ܚܘܼܫܒܸܢܹܐ ܐܲܝܟ݂ ܥܸܪ̈ܒܹܐ ܠܦܪܵܡܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","ܪܥܘܿܫ، ܩܵܡܘܿܕܝܼ ܛܵܠܥܹܬ، ܝܵܐ ܡܵܪܝܵܐ؟ ܦܘܼܫ ܪܥܝܼܫܵܐ، ܠܵܐ ܪܲܦܹܝܬ ܠܲܢ ܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","ܩܵܡܘܿܕܝܼ ܛܲܫܹܝܬ ܠܵܗ̇ ܦܵܬܘܼܟ݂، ܘܢܵܫܹܝܬ ܥܵܘܩܵܢܲܢ̈ ܘܐܘܼܠܨܵܢܲܢ̈؟ ");
INSERT INTO aii_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","ܣܵܒܵܒ ܟܝܼܦ ܠܵܗ̇ ܠܥܲܦܪܵܐ ܓܵܢܲܢ، ܛܦܹܐ ܠܵܗ̇ ܠܐܲܪܥܵܐ ܟܹܪ݇ܣܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","ܩܘܼܡ ܠܗܲܝܲܪܬܵ‌ܐ ܐܸܠܲܢ، ܘܦܲܪܸܩ ܠܲܢ ܒܘܼܬ ܛܲܝܒܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","ܚܲܒܪܵܐ ܛܵܒ݂ܵܐ ܒܸܢܒ݂ܵܥܵܐ ܝܠܹܗ ܡ̣ܢ ܠܸܒܝܼ، ܒܹܐܡܵܪܵܝ ܝܘܸܢ ܓ̰ܲܪ̈ܓܝܼ ܠܡܲܠܟܵܐ، ܠܸܫܵܢܝܼ ܩܲܢܝܵܐ ܕܣܵܦܪܵܐ ܡܗܝܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","ܒܘܼܫ ܫܲܦܝܼܪܵܐ ܝܘܸܬ ܡ̣ܢ ܒܢܲܝ̈ܢܵܫܵܐ، ܫܦܝܼܟ݂ܬܵ‌ܐ ܝܠܵܗ̇ ܫܵܦܵܩܲܬ ܥܲܠܔ ܣܸܦܘܵܬܘܼ̈ܟ݂، ܒܘܼܬ ܐܵܗܵܐ، ܩܵܡ ܒܲܪܸܟ݂ ܠܘܼܟ݂ ܐܲܠܵܗܵܐ ܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","ܐܣܘܿܪ ܣܲܝܦܘܼܟ݂ ܥܲܠܔ ܥܸܛܡܵܐ، ܝܵܐ ܓܲܒܵܪܵܐ، ܒܚܸܩܪܘܼܟ݂ ܘܫܘܼܒ݂ܚܘܼܟ݂، ");
INSERT INTO aii_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","ܘܒܫܘܼܒ݂ܚܘܼܟ݂ ܪܟܘܿܒ݂ ܥܲܠܔ ܣܘܼܣܵܐ ܘܗܘܝܼ ܓ݂ܵܠܒܵܢܵܐ، ܩܵܐ ܒܘܼܬ ܫܪܵܪܵܐ ܘܡܲܟܝܼܟ݂ܘܼܬܵ‌ܐ ܘܙܲܕܝܼܩܘܼܬܵ‌ܐ، ܫܒ݂ܘܿܩ ܝܲܡܝܼܢܘܼܟ݂ ܡܲܠܦܵܐ ܐܸܠܘܼܟ݂ ܥܒ݂ܵܕܹ̈ܐ ܣܲܗܡܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","ܚܲܪ̈ܝܼܦܹܐ ܝܢܵܐ ܓܹܐܪ̈ܘܼܟ݂، ܥܲܡܡܹ̈ܐ ܬܚܘܿܬ ܐܲܩܠܘܼ̈ܟ݂ ܟܹܐ ܢܵܦܠܝܼ، ܟܹܐ ܛܵܥܨܝܼ ܓܹܐܪ̈ܘܼܟ݂ ܒܠܸܒܵܐ ܕܕܸܫ̃ܡܸܢܘܼ̈ܟ݂، ܝܵܐ ܡܲܠܟܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","ܬܪܘܿܢܘܿܣܘܼܟ݂، ܝܵܐ ܐܲܠܵܗܵܐ، ܠܥܵܠܲܡ ܥܵܠܡܝܼܢ، ܚܘܼܛܪܵܐ ܕܬܪܘܼܨܘܼܬܵ‌ܐ ܚܘܼܛܪܵܐ ܕܡܲܠܟܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","ܡܘܼܚܸܒ ܠܘܼܟ݂ ܙܲܕܝܼܩܘܼܬܵ‌ܐ ܘܣܢܹܐ ܠܘܼܟ݂ ܒܝܼܫܘܼܬܵ‌ܐ، ܒܘܼܬ ܐܵܗܵܐ، ܝܵܐ ܐܲܠܵܗܵܐ، ܩܵܡ ܡܵܫܹܚ ܠܘܼܟ݂ ܐܲܠܵܗܘܼܟ݂، ܒܡܸܫܚܵܐ ܕܦܨܝܼܚܘܼܬܵ‌ܐ ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܚܲܒ݂ܪ̈ܵܘܵܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","ܒܡܘܼܪܵܐ، ܥܸܠܘܲܝ، ܘܩܲܣܝܵܐ ܥܘܼܛܪܸܢܹܐ ܝܢܵܐ ܟܠܵܝܗ‌ܝ ܠܒ݂ܘܼܫܘܼ̈ܟ݂، ܡ̣ܢ ܩܲܨܪܵܐ ܕܓܪܲܡܦܝܼܠܵܐ ܣܝܼܡܹ̈ܐ ܕܩܝܼܬܵܪܹ̈ܐ ܩܵܡ ܡܲܚܕܝܼ ܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","ܒܢܵܬܹ̈‌ܐ ܕܡܲܠܟܹ̈ܐ ܒܹܝܠܔ ܡܝܲܩܪ̈ܵܬܘܼܟ݂ ܝܼܢܵܐ، ܡܲܠܟܬܵ‌ܐ ܟܠܝܼܬܵ‌ܐ ܝܠܵܗ̇ ܒܝܲܡܝܼܢܘܼܟ݂ ܒܕܲܗܒ݂ܵܐ ܕܐܵܘܦܹܝܪ. ");
INSERT INTO aii_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","ܫܡܹܥ، ܝܵܐ ܒܪܵܬܵ‌ܐ، ܘܚܙܝܼ، ܘܡܲܟܸܦ ܢܵܬܵܟ݂ܝ، ܘܢܫܝܼ ܥܲܡܵܟ݂ܝ ܘܒܲܝܬܵ‌ܐ ܕܒܵܒܵܟ݂ܝ، ");
INSERT INTO aii_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","ܕܫܲܗܘܸܬ ܡܲܠܟܵܐ ܠܫܘܼܦܪܵܟ݂ܝ، ܣܵܒܵܒ ܗ̇ܘ ܝܼܠܹܗ ܡܵܪܵܟ݂ܝ، ܡܲܟܸܦܝ ܓܵܢܵܟ݂ܝ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","ܒܪܵܬܵ‌ܐ ܕܨܘܿܪ ܒܸܬ ܐܵܬܝܵܐ ܒܡܵܘܗܲܒ݂ܬܵ‌ܐ، ܘܦܵܬܵܟ݂ܝ ܒܸܬ ܛܵܥܝܼ ܥܲܬܝܼܪܹ̈ܐ ܕܥܲܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","ܒܟܠܔ ܚܸܩܪܵܐ ܝܠܵܗ̇ ܒܪܵܬܵ‌ܐ ܕܡܲܠܟܵܐ ܓܵܘ ܩܲܨܪܵܐ، ܠܒ݂ܝܼܫܬܘܼܗ̇ ܡ̣ܢ ܙܩܘܼܪܹ̈ܐ ܕܕܲܗܒ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","ܒܠܒ݂ܘܼܫܹ̈ܐ ܠܩܝܼܛܹ̈ܐ ܒܸܬ ܦܵܝܫܵܐ ܠܘܼܒܸܠܬܵ‌ܐ ܠܡܲܠܟܵܐ، ܩܲܪ̈ܝܼܒ݂ܝܵܬܹ‌ܐ ܒܬܘܼܠܵܬܹ̈‌ܐ ܕܒܵܬܪܘܼܗ̇ ܦܝܵܫܵܐ ܡܘܼܬܝܹܐ ܩܲܕܡܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","ܒܸܬ ܦܵܝܫܝܼ ܠܘܼܒܠܹܐ ܒܚܲܕܘܼܬܵ‌ܐ ܘܦܨܵܚܬܵ‌ܐ، ܒܸܬ ܥܵܒ݂ܪܝܼ ܓܵܘ ܩܲܨܪܵܐ ܕܡܲܠܟܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","ܒܫܵܘܦܵܐ ܕܒܵܒܵܘܵܬܘܼ̈ܟ݂ ܒܸܬ ܗܵܘܝܼ ܒܢܘܿܢܘܼ̈ܟ݂، ܡܲܬܒܸܬ ܠܗܘܿܢ ܪܹ̈ܝܫܵܢܹܐ ܒܟܠܵܗ̇ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","ܒܸܬ ܡܲܕܟܸܪܸܢ ܫܸܡܘܼܟ݂ ܒܟܠܔ ܕܵܪܵܐ ܘܕܵܪܵܐ، ܒܘܼܬ ܐܵܗܵܐ، ܥܲܡܡܹ̈ܐ ܒܸܬ ܫܲܟܪܝܼ ܠܘܼܟ݂ ܠܥܵܠܲܡ ܥܵܠܡܝܼܢ. ");
INSERT INTO aii_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","ܐܲܠܵܗܵܐ ܝܠܹܗ ܐܸܠܲܢ ܒܹܝܬ ܓܵܘܣܵܐ ܘܥܘܼܫܢܵܐ، ܗܲܝܲܪܬܵ‌ܐ ܝܠܹܗ ܓܵܘ ܐܘܼܠܨܵܢܹ̈ܐ ܒܟܠܔ ܥܕܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","ܒܘܼܬ ܐܵܗܵܐ، ܠܹܐ ܙܵܕܥܲܚ ܟܲܕ ܫܲܚܠܸܦܵܐ ܐܲܪܥܵܐ، ܘܟܲܕ ܫܵܥܫܝܼ ܛܘܼܪ̈ܵܢܹܐ ܒܥܘܼܡܩܵܐ ܕܝܵܡܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","ܟܲܕ ܫܵܓ݂ܫܝܼ ܘܓܲܒܓܸܒܝܼ ܡܝܼܵܝ̈ܗ‌ܝ، ܪܲܬܪܸܬ‌ܝܼ ܛܘܼܪ̈ܵܢܹܐ ܒܪܝܵܡܬܵܝܗ‌ܝ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","ܐܝܼܬ ܢܲܗܪܵܐ ܕܫܵܩܝܼܵܬܘܼ̈ܗ‌ܝ ܟܹܐ ܡܲܚܕܝܼ ܠܡܕܝܼܢ݇ܬܵ‌ܐ ܕܐܲܠܵܗܵܐ، ܡܲܫܟܢܵܐ ܩܲܕܝܼܫܵܐ ܕܥܸܠܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","ܐܲܠܵܗܵܐ ܒܓܵܘܘܼܗ̇ ܝܠܹܗ، ܠܹܐ ܫܵܥܫܵܐ، ܒܸܬ ܗܲܝܸܪܵܗ̇ ܐܲܠܵܗܵܐ ܒܕܝܵܪܬܵ‌ܐ ܕܨܲܦܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","ܫܓ݂ܝܼܫ ܠܗܘܿܢ ܐܸܡܘܵܬܹ̈‌ܐ، ܫܥܝܼܫ ܠܗܘܿܢ ܡܲܠܟܘܵܬܹ̈‌ܐ، ܡܘܼܪܸܡ ܠܹܗ ܩܵܠܹܗ، ܦܫܝܼܪܵܗ̇ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","ܡܵܪܝܵܐ ܚܲܝܠܬܵܢܵܐ ܥܲܡܲܢ ܝܼܠܹܗ، ܩܲܠܥܵܐ ܐܸܠܲܢ ܐܲܠܵܗܵܐ ܕܝܲܥܩܘܿܒ݂. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","ܬܹܝܡܘܼܢ ܚܙܹܝܡܘܼܢ ܦܘܼܠܚܵܢܹ̈ܐ ܕܡܵܪܝܵܐ، ܕܡܘܼܝܬܹ‌ܐ ܠܹܗ ܚܪ̈ܵܒܹܐ ܒܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","ܟܹܐ ܡܲܟܠܹܐ ܦܠܵܫܹ̈ܐ ܗܲܠܔ ܡܲܪܙܵܐ ܕܐܲܪܥܵܐ، ܟܹܐ ܬܵܒܹܪ ܩܸܫܬܵ‌ܐ، ܘܟܹܐ ܫܵܡܹܛ ܪܘܼܡܚܵܐ، ܟܹܐ ܡܲܩܸܕ ܡܲܪ̈ܟܒ݂ܵܬܹ‌ܐ ܒܢܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","ܟܹܐ ܐܵܡܹܪ: ”ܗܘܹܝܡܘܼܢ ܫܸܠܝܹܐ ܘܝܕܹܥܡܘܼܢ ܕܐܵܢܵܐ ܝܘܸܢ ܐܲܠܵܗܵܐ، ܒܸܬ ܦܵܝܫܹܢ ܡܘܼܪܡܵܐ ܓܵܘ ܐܸܡܘܵܬܹ̈‌ܐ، ܒܸܬ ܦܵܝܫܹܢ ܡܘܼܪܡܵܐ ܒܐܲܪܥܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","ܡܵܪܝܵܐ ܚܲܝܠܬܵܢܵܐ ܥܲܡܲܢ ܝܼܠܹܗ، ܩܲܠܥܵܐ ܐܸܠܲܢ ܐܲܠܵܗܵܐ ܕܝܲܥܩܘܿܒ݂. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","ܡܚܹܝܡܘܼܢ ܟ̰ܲܦܹ̈ܐ ܟܠܵܝܗ‌ܝ ܥܲܡܡܹ̈ܐ، ܩܲܘܸܚܘܼܢ ܠܐܲܠܵܗܵܐ ܒܩܵܠܵܐ ܕܫܘܼܒ݂ܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","ܣܵܒܵܒ ܡܵܪܝܵܐ ܥܸܠܵܝܵܐ ܣܲܗܡܵܢܵܐ ܝܠܹܗ، ܡܲܠܟܵܐ ܓܘܼܪܵܐ ܥܲܠܔ ܟܠܵܗ̇ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","ܩܵܡ ܙܲܒܛܸܢ ܥܲܡܡܹ̈ܐ ܬܚܘܿܬܲܢ، ܘܐܸܡܘܵܬܹ̈‌ܐ ܬܚܘܿܬ ܐܲܩܠܵܬܲܢ̈. ");
INSERT INTO aii_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","ܩܵܡ ܓܲܒܹܐ ܩܵܬܲܢ ܝܵܪܬܘܼܬܲܢ، ܫܘܼܒ݂ܗܵܪܵܐ ܕܝܲܥܩܘܿܒ݂، ܗ̇ܘ ܕܡܘܼܚܸܒ ܠܹܗ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","ܐܣܝܼܩ ܠܹܗ ܐܲܠܵܗܵܐ ܒܩܲܘܲܚܬܵ‌ܐ، ܡܵܪܝܵܐ ܒܩܵܠܵܐ ܕܫܝܼܦܘܿܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","ܙܡܘܿܪܘܼܢ ܠܐܲܠܵܗܵܐ، ܙܡܘܿܪܘܼܢ، ܙܡܘܿܪܘܼܢ ܠܡܲܠܟܲܢ، ܙܡܘܿܪܘܼܢ. ");
INSERT INTO aii_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","ܣܵܒܵܒ ܐܲܠܵܗܵܐ ܝܠܹܗ ܡܲܠܟܵܐ ܕܟܠܵܗ̇ ܐܲܪܥܵܐ، ܙܡܘܿܪܘܼܢ ܡܲܣܟܝܼܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","ܒܸܥܒ݂ܵܕܵܐ ܝܠܹܗ ܡܲܠܟܘܼܬܵ‌ܐ ܐܲܠܵܗܵܐ ܥܲܠܔ ܐܸܡܘܵܬܹ̈‌ܐ، ܐܲܠܵܗܵܐ ܝܬܝܼܒ݂ܵܐ ܝܠܹܗ ܥܲܠܔ ܟܘܼܪܣܝܵܐ ܕܩܘܼܕܫܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","ܓ̰ܡܝܼܥܹܐ ܝܢܵܐ ܢܲܨܝܼܚܹ̈ܐ ܕܥܲܡܡܹ̈ܐ، ܥܲܡܵܐ ܕܐܲܠܵܗܵܐ ܕܐܲܒ݂ܪܵܗܵܡ، ܣܵܒܵܒ ܡܵܛܵܠܹ̈ܐ ܕܐܲܪܥܵܐ ܕܐܲܠܵܗܵܐ ܝܢܵܐ، ܗ̇ܘ ܪܵܒܵܐ ܦܝܼܫܵܐ ܝܠܹܗ ܪܝܼܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","ܓܘܼܪܵܐ ܝܠܹܗ ܡܵܪܝܵܐ ܘܡܫܘܼܒܚܵܐ ܪܵܒܵܐ، ܒܡܕܝܼܢ݇ܬܵ‌ܐ ܕܐܲܠܵܗܲܢ، ܛܘܼܪܵܐ ܕܩܘܼܕܫܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","ܫܲܦܝܼܪܵܐ ܒܪܵܡܘܼܬܵ‌ܐ، ܚܲܕܘܼܬܵ‌ܐ ܕܟܠܵܗ̇ ܐܲܪܥܵܐ، ܛܘܼܪܵܐ ܕܨܸܗܝܘܿܢ ܒܫܸܦܘܼܠܹ̈ܐ ܕܓܲܪܒܝܵܐ، ܡܕܝܼܢ݇ܬܵ‌ܐ ܕܡܲܠܟܵܐ ܓܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","ܐܲܠܵܗܵܐ ܒܩܲܨܪ̈ܘܼܗ̇ ܡܘܼܕܸܥܵܐ ܠܹܗ ܓܵܢܹܗ ܐܲܝܟ݂ ܓܵܘܣܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","ܣܵܒܵܒ ܗܵܐ، ܡܲܠܟܹ̈ܐ ܚܘܼܝܸܕ ܠܗܘܿܢ، ܥܒ݂ܝܼܪܗܘܿܢ ܥܲܡ ܚܕܵܕܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","ܐܵܢܝܼ ܟܲܕ ܚܙܹܐ ܠܗܘܿܢ، ܦܝܼܫ ܠܗܘܿܢ ܬܡܝܼܗܹܐ، ܫܥܝܼܫ ܠܗܘܿܢ ܘܡܘܼܠܝܸܙ ܠܗܘܿܢ ܠܸܥܪܵܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","ܪܲܬܪܲܬܬܵ‌ܐ ܩܵܡ ܕܵܒ݂ܩܵܐ ܠܗܘܿܢ ܬܵܡܵܐ، ܘܚܸܒ݂ܠܹ̈ܐ ܐܲܝܟ݂ ܝܵܠܸܕܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","ܒܦܵܘܚܵܐ ܕܡܲܕܢܚܵܐ، ܟܹܐ ܬܵܒ݂ܪܹܬ ܓܵܡܝܼܹ̈ܐ ܕܬܲܪܫܝܼܫ. ");
INSERT INTO aii_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","ܕܵܐܟ݂ܝܼ ܕܫܡܝܼܥ ܠܲܢ، ܗܵܕܟ݂ܵܐ ܚܙܹܐ ܠܲܢ، ܒܡܕܝܼܢ݇ܬܵ‌ܐ ܕܡܵܪܝܵܐ ܚܲܝܠܬܵܢܵܐ، ܒܡܕܝܼܢ݇ܬܵ‌ܐ ܕܐܲܠܵܗܲܢ، ܐܲܠܵܗܵܐ ܒܸܬ ܡܲܩܘܹܐ ܠܵܗ̇ ܗܲܠܔ ܥܵܠܲܡ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","ܬܘܼܚܡܸܢܲܢ، ܝܵܐ ܐܲܠܵܗܵܐ، ܒܘܼܬ ܛܲܝܒܘܼܬܘܼܟ݂، ܒܓܵܘܵܐ ܕܗܲܝܟܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","ܐܲܝܟ݂ ܫܸܡܘܼܟ݂، ܝܵܐ ܐܲܠܵܗܵܐ، ܗܵܕܟ݂ܵܐ ܝܠܵܗ̇ ܬܸܫܒܘܿܚܬܘܼܟ݂ ܗܲܠܔ ܡܲܪ̈ܙܵܢܹܐ ܕܐܲܪܥܵܐ، ܡܠܝܼܬܵ‌ܐ ܝܠܵܗ̇ ܝܲܡܝܼܢܘܼܟ݂ ܙܲܕܝܼܩܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","ܚܵܕܹܐ ܛܘܼܪܵܐ ܕܨܸܗܝܘܿܢ، ܦܵܨܚܝܼ ܒܢܵܬܹ̈‌ܐ ܕܝܼܗܘܼܕܵܐ، ܒܘܼܬ ܕܝܼܘܵܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","ܚܕܘܿܪܘܼܢ ܚܵܕܸܪ̈ܘܵܢܹܐ ܕܨܸܗܝܘܿܢ، ܘܟܪܘܿܟ݂ܘܼܢ ܠܵܗ̇، ܡܢܹܝܡܘܼܢ ܒܘܼܪ̈ܓ̰ܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","ܡܲܣܸܡܘܼܢ ܒܵܠܵܐ ܒܫܘܼܪ̈ܘܼܗ̇، ܨܲܚܨܹܝܡܘܼܢ ܠܩܲܨܪ̈ܘܼܗ̇، ܩܵܐ ܕܗܲܩܹܝܬܘܿܢ ܠܕܵܪܵܐ ܐܚܹܪܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","ܕܐܵܗܵܐ ܐܲܠܵܗܵܐ، ܐܲܠܵܗܲܢ ܝܼܠܹܗ، ܠܥܵܠܲܡ ܥܵܠܡܝܼܢ، ܗ̇ܘ ܒܸܬ ܡܕܲܒܸܪܲܢ ܗܲܠܔ ܡܵܘܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","ܫܡܹܥܡܘܼܢ ܐܵܗܵܐ ܟܠܵܝܗ‌ܝ ܥܲܡܡܹ̈ܐ، ܗܲܒ݂ܠܘܼܢ ܢܵܬܵ‌ܐ ܟܠܵܝܗ‌ܝ ܥܵܡܪ̈ܵܢܹܐ ܕܒܪܝܼܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","ܐܘܼܦ ܒܢܲܝ̈ ܐܵܕܵܡ ܐܘܼܦ ܒܢܲܝ̈ܢܵܫܵܐ، ܥܲܡ ܚܕܵܕܹ̈ܐ ܥܲܬܝܼܪܵܐ ܘܣܢܝܼܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","ܦܘܼܡܝܼ ܒܸܬ ܗܲܡܙܸܡ ܚܸܟ݂ܡܬܵ‌ܐ، ܘܗܲܓܲܝܬܵ‌ܐ ܕܠܸܒܝܼ ܦܲܪܡܲܝܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","ܒܸܬ ܨܲܠܹܝܢ ܠܡܲܬܠܵܐ ܢܵܬ‌ܝܼ، ܘܦܵܬܚܹܢ ܒܟܸܢܵܪܵܐ ܩܸܨܸܡܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","ܩܵܡܘܿܕܝܼ ܙܵܕܥܹܢ ܒܝܵܘܡܵܢܹ̈ܐ ܕܒܝܼܫܬܵ‌ܐ، ܟܲܕ ܥܵܘܠܵܐ ܕܕܵܒ݂ܩܵܢܹ̈ܐ ܕܥܸܩܒܝܼ̈ ܚܲܪܕܝܼ ܠܝܼ؟ ");
INSERT INTO aii_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","ܐܵܢܝܼ ܟܹܐ ܣܵܒܪܝܼ ܒܕܵܘܸܠܬܵܝܗ‌ܝ، ܘܒܦܸܪܝܘܼܬܵ‌ܐ ܕܥܘܼܬܪܵܝܗ‌ܝ ܟܹܐ ܫܲܒ݂ܗܸܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","ܠܐܲܚܘܿܢܵܐ ܦܲܪܘܼܩܹܐ ܠܹܐ ܡܵܨܹܐ ܦܲܪܸܩ ܐܢܵܫܵܐ، ܠܹܐ ܡܵܨܹܐ ܝܵܗܒܹܠܔ ܠܐܲܠܵܗܵܐ ܛܝܼܡܵܐ ܕܦܘܼܪܩܵܢܹܗ، ");
INSERT INTO aii_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","(ܣܵܒܵܒ ܛܝܼܡܵܢܵܐ ܝܠܹܗ ܦܘܼܪܩܵܢܵܐ ܕܓܵܢܵܐ، ܒܵܣ ܫܒ݂ܘܿܩ ܫܵܠܹܐ ܠܥܵܠܲܡ) ");
INSERT INTO aii_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","ܘܗܸܫ ܚܵܝܹܐ ܠܥܵܠܲܡ، ܘܠܵܐ ܚܵܙܹܐ ܚܪܵܒ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","ܣܵܒܵܒ ܟܹܐ ܚܵܙܹܐ ܠܚܲܟܝܼܡܹ̈ܐ ܕܟܹܐ ܡܵܝܬ‌ܝܼ، ܥܲܡ ܚܕܵܕܹ̈ܐ ܣܲܟ݂ܠܵܐ ܘܐܲܗܡܲܩ ܟܹܐ ܛܵܠܩܝܼ، ܘܟܹܐ ܫܵܒ݂ܩܝܼ ܠܐܚܹܪ̈ܢܹܐ ܕܵܘܸܠܬܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","ܟܹܐ ܚܵܫܒ݂ܝܼ ܒܵܬܵܝ̈ܗ‌ܝ ܠܥܵܠܲܡ ܝܼܢܵܐ، ܒܹܝܬ ܡܲܥܡܪܵܝܗ‌ܝ ܠܕܵܪܵܐ ܘܕܵܪܵܐ، ܘܩܪܹܐ ܠܗܘܿܢ ܐܲܪ̈ܥܵܬܹ‌ܐ ܒܫܸܡܵܢܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","ܐܝܼܢܵܐ ܒܲܪܢܵܫܵܐ ܒܐܝܼܩܵܪܵܐ ܠܹܐ ܥܲܪܩܸܠܔ، ܟܹܐ ܕܵܡܹܐ ܠܗܲܝܘܵܢܹ̈ܐ ܕܛܵܠܩܝܼ، ");
INSERT INTO aii_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","ܐܵܗܵܐ ܝܠܵܗ̇ ܐܘܼܪܚܵܝܗ‌ܝ، ܣܲܟ݂ܠܘܼܬܵ‌ܐ ܐܸܠܵܝܗ‌ܝ، ܘܐܵܙܵܠ݇ܢܹ̈ܐ ܕܒܵܬܪܵܝܗ‌ܝ ܕܒܵܣܡܵܐ ܠܗܘܿܢ ܒܚܲܒܪ̈ܵܝܗ‌ܝ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","ܐܲܝܟ݂ ܥܸܪ̈ܒܹܐ ܠܫܝܘܿܠܔ ܪܫܝܼܡܹܐ ܝܢܵܐ، ܡܵܘܬܵ‌ܐ ܒܸܬ ܗܵܘܹܐ ܪܵܥܝܵܝܗ‌ܝ، ܘܬܪ̈ܘܼܨܹܐ ܒܸܬ ܗܲܟܡܝܼ ܥܲܠܵܝܗ‌ܝ ܒܨܲܦܪܵܐ، ܘܨܘܼܪܬܵܝܗ‌ܝ ܒܸܬ ܒܵܠܝܵܐ ܒܫܝܘܿܠܔ ܪܸܚܩܵܐ ܡ̣ܢ ܒܵܬܵܝ̈ܗ‌ܝ ܫܲܦܝܼܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","ܐܝܼܢܵܐ ܐܲܠܵܗܵܐ ܒܸܬ ܦܲܪܸܩ ܠܓܵܢܝܼ ܡ̣ܢ ܐܝܼܕܵܐ ܕܫܝܘܿܠܔ، ܣܵܒܵܒ ܒܸܬ ܩܲܒܸܠܔ ܠܝܼ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","ܠܵܐ ܙܵܕܥܹܬ ܟܲܕ ܗܵܘܹܐ ܥܲܬܝܼܪܵܐ ܐܢܵܫܵܐ، ܟܲܕ ܙܵܐܹܕ ܐܝܼܩܵܪܵܐ ܕܒܲܝܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","ܣܵܒܵܒ ܒܡܵܘܬܹܗ ܠܹܐ ܠܲܒܸܠܔ ܡܸܢܕܝܼ، ܠܹܐ ܨܵܠܹܐ ܒܵܬܪܹܗ ܐܝܼܩܵܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","ܐܵܦܸܢ ܒܚܲܝܘܼ̈ܗ‌ܝ ܠܓܵܢܹܗ ܟܹܐ ܒܲܪܸܟ݂ ܗܘܵܐ، (ܒܗ̇ܝ ܕܒܸܬ ܚܲܩܪܝܼ ܠܘܼܟ݂ ܟܲܕ ܥܵܒ݂ܕܹܬ ܛܵܒ݂ܬܵ‌ܐ ܠܓܵܢܘܼܟ݂)، ");
INSERT INTO aii_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","ܒܸܬ ܐܵܙܹܠܔ ܠܟܸܣ ܐܲܒ݂ܵܗܵܬܘܼ̈ܗ‌ܝ، ܗܲܠܔ ܥܵܠܲܡ ܠܹܐ ܚܵܙܝܼ ܒܲܗܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","ܒܲܪܢܵܫܵܐ ܕܐܝܼܬ ܠܹܗ ܐܝܼܩܵܪܵܐ ܐܝܼܢܵܐ ܠܵܐ ܦܲܪܡܹܐ، ܟܹܐ ܕܵܡܹܐ ܠܗܲܝܘܵܢܹ̈ܐ ܕܛܵܠܩܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","ܐܹܝܠܔ، ܐܲܠܵܗܵܐ، ܡܵܪܝܵܐ، ܗܘܼܡܙܸܡ ܠܹܗ، ܘܩܪܹܐ ܠܹܗ ܠܐܲܪܥܵܐ ܡ̣ܢ ܙܪܵܩܵܐ ܕܫܸܡܫܵܐ ܗܲܠܔ ܓܢܵܝܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","ܡ̣ܢ ܨܸܗܝܘܿܢ، ܓܡܝܼܪܘܼܬܵ‌ܐ ܕܫܘܼܦܪܵܐ، ܐܲܠܵܗܵܐ ܙܪܝܼܩ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","ܒܸܬ ܐܵܬܹ‌ܐ ܐܲܠܵܗܲܢ ܘܠܹܐ ܫܵܬܹܩ، ܩܲܕܡܘܼܗ‌ܝ ܢܘܼܪܵܐ ܒܸܬ ܐܵܟܹܠܔ، ܚܵܕܸܪ̈ܘܵܢܘܼܗ‌ܝ ܥܲܠܥܵܠܵܐ ܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","ܒܸܬ ܩܵܪܹܐ ܠܫܡܲܝܵܐ ܡ̣ܢ ܥܸܠܸܠܔ، ܘܠܐܲܪܥܵܐ ܠܸܕܝܵܢܵܐ ܠܥܲܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","”ܓ̰ܲܡܸܥܡܘܼܢ ܠܟܸܣܠܝܼ ܡܗܘܼܡܢܝܼ̈، ܩܵܛܥܵܢܹ̈ܐ ܕܘܲܥܕܝܼ ܒܕܸܒ݂ܚܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","ܘܟܹܐ ܡܲܕܥܵܐ ܫܡܲܝܵܐ ܙܲܕܝܼܩܘܼܬܹܗ، ܣܵܒܵܒ ܐܲܠܵܗܵܐ ܝܠܹܗ ܕܲܝܵܢܵܐ ܗ̇ܘ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","”ܫܡܹܥ، ܝܵܐ ܥܲܡܝܼ، ܘܒܸܬ ܗܲܡܙܸܡܸܢ، ܝܵܐ ܐܝܼܣܪܵܐܹܝܠܔ، ܘܒܸܬ ܣܵܗܕܹܢ ܕܲܠܩܘܼܒ݂ܠܘܼܟ݂، ܐܲܠܵܗܵܐ، ܐܲܠܵܗܘܼܟ݂ ܐܵܢܵܐ ܝܘܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","”ܒܘܼܬ ܕܸܒ݂ܚܘܼ̈ܟ݂ ܠܹܐ ܡܲܢܟܸܣܸܢܘܼܟ݂، ܝܲܢ ܒܘܼܬ ܕܸܒ݂ܚܘܼ̈ܟ݂ ܡܘܼܩܕܹ̈ܐ ܕܝܼܢܵܐ ܠܒܲܠܩܘܼܒ݂ܠܝܼ ܐܲܡܝܼܢܵܐܝܼܬ. ");
INSERT INTO aii_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","”ܠܹܐ ܫܵܩܠܹܢ ܡ̣ܢ ܒܲܝܬܘܼܟ݂ ܬܵܘܪܵܐ، ܠܵܐ ܡ̣ܢ ܓܘܼܡܵܢܘܼ̈ܟ݂ ܢܹܐܪ̈ܝܼܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","”ܣܵܒܵܒ ܕܝܼܝܼ ܝܢܵܐ ܟܠܵܝܗ‌ܝ ܚܲܝܘܵܬܹ̈‌ܐ ܕܥܵܒ݂ܵܐ، ܘܒܥܝܼܪܹ̈ܐ ܕܒܐܲܠܦܵܐ ܛܘܼܪ̈ܵܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","”ܟܹܐ ܝܵܕܥܹܢ ܠܟܠܵܗ̇ ܦܵܪܲܚܬܵ‌ܐ ܕܛܘܼܪ̈ܵܢܹܐ، ܘܓ̰ܵܘܓ̰ܵܢܹ̈ܐ ܕܕܸܫܬܵ‌ܐ ܥܲܡܝܼ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","”ܐܸܢ ܟܵܦܢܹܢ ܗܘܵܐ ܠܹܐ ܐܵܡܪܹܢ ܗܘܵܐ ܐܸܠܘܼܟ݂، ܣܵܒܵܒ ܕܝܼܝܼ ܝܠܵܗ̇ ܒܪܝܼܬܵ‌ܐ ܘܡܸܠܝܘܼܬܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","”ܗܵܐ، ܒܸܬ ܐܵܟ݂ܠܹܢ ܒܸܣܪܵܐ ܕܡܘܼܓ̰ܹ̈ܐ، ܘܫܵܬܹܝܢ ܕܸܡܵܐ ܕܢܹܐܪ̈ܝܼܹܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","”ܕܒ݂ܘܿܚ ܠܐܲܠܵܗܵܐ ܫܲܟܲܪܬܵ‌ܐ، ܘܬܲܡܸܡ ܠܥܸܠܵܝܵܐ ܢܸܕܪ̈ܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","”ܘܩܪܝܼ ܐܸܠܝܼ ܒܝܵܘܡܵܐ ܕܐܘܼܠܨܵܢܵܐ، ܒܸܬ ܦܲܨܸܢܘܼܟ݂ ܘܒܸܬ ܡܝܲܩܪܸܬ ܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","ܐܝܼܢܵܐ ܠܪܲܫܝܼܥܵܐ ܒܹܐܡܵܪܵܐ ܝܠܹܗ ܐܲܠܵܗܵܐ: ”ܡܵܐ ܠܘܼܟ݂ ܠܗܲܩܘܼܝܹܐ ܩܵܢܘܿܢܝܼ̈، ܘܠܸܫܩܵܠܵܐ ܘܲܥܕܝܼ ܒܦܘܼܡܘܼܟ݂؟ ");
INSERT INTO aii_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","”ܣܵܒܵܒ ܐܲܢ݇ܬ ܣܢܹܐ ܠܘܼܟ݂ ܬܲܥܠܲܡܬܵ‌ܐ، ܘܪܘܼܦܹܐ ܠܘܼܟ݂ ܗܹܡܸܙܡܵܢܝܼ̈ ܒܵܬܪܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","”ܐܸܢ ܚܙܹܐ ܠܘܼܟ݂ ܓܹܢܵܒ݂ܵܐ، ܟܹܐ ܒܵܣܡܵܐ ܠܘܼܟ݂ ܒܝܼܹܗ، ܘܥܲܡ ܓܲܝܵܪܹ̈ܐ ܝܠܹܗ ܣܵܗܡܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","”ܦܘܼܡܘܼܟ݂ ܝܘܼܗܒܹܠܔ ܠܘܼܟ݂ ܠܒܝܼܫܬܵ‌ܐ، ܘܠܸܫܵܢܘܼܟ݂ ܟܹܐ ܡܲܠܚܸܡ ܦܸܠܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","”ܟܹܐ ܝܵܬܒܹܬ ܗܲܡܙܸܡܸܬ ܕܲܠܩܘܼܒ݂ܠܔ ܕܐܲܚܘܿܢܘܼܟ݂، ܥܲܠܔ ܒܪܘܿܢܵܐ ܕܝܸܡܘܼܟ݂ ܟܹܐ ܕܵܪܹܝܬ ܒܘܼܚܬܵܢ. ");
INSERT INTO aii_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","”ܐܲܢܹܐ ܥܒ݂ܝܼܕ ܠܘܼܟ݂ ܘܐܵܢܵܐ ܫܬܝܼܩ ܠܝܼ؛ ܚܫܝܼܒ݂ ܠܘܼܟ݂ ܗܘܵܝܵܐ ܒܸܬ ܗܵܘܹܝܢ ܐܲܝܟ݂ ܕܝܼܘܼܟ݂، ܐܝܼܢܵܐ ܒܸܬ ܡܲܢܟܸܣܸܢܘܼܟ݂ ܘܒܸܬ ܚܵܪܙܹܢ ܥܒ݂ܵܕܘܼ̈ܟ݂ ܩܲܕܡ ܥܲܝ̈ܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","”ܦܲܪܡܹܝܡܘܼܢ ܐܵܗܵܐ، ܝܵܐ ܢܵܫܝܵܢܹ̈ܐ ܕܐܲܠܵܗܵܐ، ܕܠܵܐ ܗܵܘܝܵܐ ܕܦܲܪܦܸܛܸܢ ܘܠܵܐ ܗܵܘܹܐ ܦܲܨܝܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","”ܟܠܔ ܕܕܵܒܹܚ ܫܲܟܲܪܬܵ‌ܐ ܟܹܐ ܡܝܲܩܸܪܝܼ، ܘܠܡܲܪܝܸܙܸܢܵܐ ܕܐܘܼܪܚܹܗ ܒܸܬ ܡܲܚܙܹܝܢ ܦܘܼܪܩܵܢܵܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","ܪܚܘܿܡ ܥܲܠܝܼ، ܝܵܐ ܐܲܠܵܗܵܐ، ܐܲܝܟ݂ ܛܲܝܒܘܼܬܘܼܟ݂، ܐܲܝܟ݂ ܦܸܪܝܘܼܬܵ‌ܐ ܕܪ̈ܲܚܡܘܼܟ݂ ܓܪܘܿܕ ܠܗܘܿܢ ܓܢܵܗ‌ܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","ܡ̣ܢ ܥܵܘܠܝܼ ܚܲܠܸܠܔ ܠܝܼ ܓܡܝܼܪܵܐܝܼܬ، ܘܡ̣ܢ ܚܛܝܼܬ‌ܝܼ ܕܲܟ݂ܝܼ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","ܒܗ̇ܝ ܕܐܵܢܵܐ ܟܹܐ ܝܵܕܥܹܢ ܠܓܢܵܗ‌ܝܼ̈، ܘܚܛܝܼܬ‌ܝܼ ܒܲܠܩܘܼܒ݂ܠܝܼ ܝܠܵܗ̇ ܐܲܡܝܼܢܵܐܝܼܬ. ");
INSERT INTO aii_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","ܐܸܠܘܼܟ݂، ܐܲܚܟ̰ܝܼ ܐܸܠܘܼܟ݂، ܚܛܹܐ ܠܝܼ، ܘܒܝܼܫܘܼܬܵ‌ܐ ܩܲܕܡ ܥܲܝ̈ܢܘܼܟ݂ ܥܒ݂ܝܼܕ ܠܝܼ، ܒܘܼܬ ܐܵܗܵܐ، ܒܸܬ ܗܵܘܹܝܬ ܙܲܕܝܼܩܵܐ ܒܗܲܡܙܲܡܬܘܼܟ݂، ܒܸܬ ܗܵܘܹܝܬ ܕܸܟ݂ܝܵܐ ܒܕܝܵܢܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","ܗܵܐ، ܒܥܵܘܠܵܐ ܦܝܼܫ ܠܝܼ ܝܠܝܼܕܵܐ، ܘܒܚܛܝܼܬܵ‌ܐ ܒܛܝܼܢܸܢܵܗ̇ ܝܸܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","ܗܵܐ، ܟܹܐ ܒܵܣܡܵܐ ܠܘܼܟ݂ ܒܫܲܪܝܼܪܘܼܬܵ‌ܐ ܕܝܼܠܵܗ̇ ܡ̣ܢ ܥܘܼܡܩܵܐ ܕܓܵܢܵܐ، ܘܒܕܘܼܟܵܐ ܛܫܝܼܬܵ‌ܐ ܚܸܟ݂ܡܬܵ‌ܐ ܒܸܬ ܡܲܕܥܸܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","ܕܲܟܹܝܬ ܠܝܼ ܒܙܘܿܦܵܐ ܘܒܸܬ ܗܵܘܹܝܢ ܕܸܟ݂ܝܵܐ، ܚܲܠܸܠܸܬ ܠܝܼ ܘܒܸܬ ܗܵܘܹܝܢ ܒܘܼܫ ܚܘܵܪܵܐ ܡ̣ܢ ܬܲܠܓܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","ܫܒ݂ܘܿܩ ܫܵܡܥܹܢ ܦܨܵܚܵܐ ܘܚܲܕܘܼܬܵ‌ܐ، ܦܵܨܚܝܼ ܓܲܪ̈ܡܹܐ ܕܛܒ݂ܝܼܚ ܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","ܛܲܫܝܼ ܦܵܬܘܼܟ݂ ܡ̣ܢ ܚܛܝܼܵܬ‌ܝܼ̈، ܘܟܠܵܝܗ‌ܝ ܥܵܘܠܝܼ̈ ܓܪܘܿܕ. ");
INSERT INTO aii_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","ܠܸܒܵܐ ܕܸܟ݂ܝܵܐ ܒܪܝܼ ܓܵܘܝܼ، ܝܵܐ ܐܲܠܵܗܵܐ، ܘܚܲܕܸܬ ܪܘܼܚܵܐ ܡܗܘܼܡܸܢܬܵ‌ܐ ܒܓܵܘܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","ܠܵܐ ܪܲܦܹܝܬ ܠܝܼ ܡ̣ܢ ܗܸܙܘܼܪܘܼܟ݂، ܘܪܘܼܚܵܐ ܕܩܘܼܕܫܘܼܟ݂ ܠܵܐ ܫܵܩܠܹܬ ܡܸܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","ܡܲܕܸܪ ܐܸܠܝܼ ܦܨܵܚܵܐ ܕܦܘܼܪܩܵܢܘܼܟ݂، ܘܒܪܘܼܚܵܐ ܕܨܸܒ݂ܝܵܢܘܼܬܵ‌ܐ ܣܵܢܕܹܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","ܗ̇ܝܓܵܗ ܒܸܬ ܡܲܠܦܸܢ ܠܥܵܘܵܠܹ̈ܐ ܐܘܼܪ̈ܚܵܬܘܼܟ݂، ܘܚܲܛܵܝܹ̈ܐ ܠܟܸܣܠܘܼܟ݂ ܒܸܬ ܕܵܝܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","ܦܲܨܝܼ ܠܝܼ ܡ̣ܢ ܚܛܝܼܬܵ‌ܐ ܕܫܲܦܲܟ݂ܬܵ‌ܐ ܕܕܸܡܵܐ، ܝܵܐ ܐܲܠܵܗܵܐ، ܐܲܠܵܗܵܐ ܕܦܘܼܪܩܵܢܝܼ، ܘܒܦܨܝܼܚܘܼܬܵ‌ܐ ܒܸܬ ܙܵܡܹܪ ܠܸܫܵܢܝܼ ܙܲܕܝܼܩܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","ܝܵܐ ܡܵܪܝܵܐ، ܦܵܬܚܹܬ ܣܸܦܘܵܬ‌ܝܼ̈، ܩܵܐ ܕܦܘܼܡܝܼ ܡܲܕܸܥ ܬܸܫܒܘܿܚܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","ܣܵܒܵܒ ܠܹܐ ܒܵܣܡܵܐ ܠܘܼܟ݂ ܒܕܸܒ݂ܚܵܐ، ܐܸܠܵܐ ܒܸܬ ܝܵܗܒܹܢ ܗܘܵܐ، ܕܸܒ݂ܚܵܐ ܡܘܼܩܕܵܐ ܠܹܐ ܗܵܢܝܵܐ ܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","ܕܸܒ݂ܚܵܐ ܕܐܲܠܵܗܵܐ ܪܘܼܚܵܐ ܬܒ݂ܝܼܪܬܵ‌ܐ ܝܠܵܗ̇، ܠܸܒܵܐ ܬܒ݂ܝܼܪܵܐ ܘܒܠܝܼܣܵܐ، ܝܵܐ ܐܲܠܵܗܵܐ، ܠܹܐ ܡܲܣܠܹܝܬ. ");
INSERT INTO aii_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","ܥܒ݂ܘܿܕ ܛܵܒ݂ܬܵ‌ܐ ܒܨܸܒ݂ܝܵܢܘܼܟ݂ ܠܨܸܗܝܘܿܢ، ܒܵܢܹܝܬ ܫܘܼܪܹ̈ܐ ܕܐܘܿܪܸܫܠܸܡ. ");
INSERT INTO aii_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","ܗ̇ܝܓܵܗ ܒܸܬ ܒܵܣܡܵܐ ܠܘܼܟ݂ ܒܕܸܒ݂ܚܹ̈ܐ ܕܙܲܕܝܼܩܘܼܬܵ‌ܐ، ܕܸܒ݂ܚܵܐ ܡܘܼܩܕܵܐ ܘܕܸܒ݂ܚܵܐ ܓܡܝܼܪܵܐܝܼܬ ܡܘܼܩܕܵܐ، ܗ̇ܝܓܵܗ ܒܸܬ ܡܲܐܣܩܝܼ ܬܵܘܪܹ̈ܐ ܥܲܠܔ ܡܲܕܒܚܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","ܩܵܡܘܿܕܝܼ ܫܲܒ݂ܗܘܼܪܹܐ ܝܘܸܬ ܒܒܝܼܫܬܵ‌ܐ، ܝܵܐ ܓܲܒܵܪܵܐ؟ ܛܲܝܒܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ ܒܟܠܹܗ ܝܵܘܡܵܐ ܝܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","ܡܲܚܪܲܒ݂ܬܵ‌ܐ ܬܲܚܡܘܼܢܹܐ ܝܠܹܗ ܠܸܫܵܢܘܼܟ݂، ܐܲܝܟ݂ ܡܲܓܪܲܥܬܵ‌ܐ ܚܲܪܝܼܦܬܵ‌ܐ، ܝܵܐ ܥܵܒ݂ܕܵܢܵܐ ܕܦܸܠܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","ܡܘܼܚܸܒ ܠܘܼܟ݂ ܒܝܼܫܬܵ‌ܐ ܒܘܼܫ ܡ̣ܢ ܛܵܒ݂ܬܵ‌ܐ، ܕܲܓܵܠܘܼܬܵ‌ܐ ܡ̣ܢ ܠܗܲܡܙܘܼܡܹܐ ܙܲܕܝܼܩܘܼܬܵ‌ܐ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","ܡܘܼܚܸܒ ܠܘܼܟ݂ ܟܠܵܝܗ‌ܝ ܗܹܡܸܙܡܵܢܹ̈ܐ ܒܵܠܥܵܢܹ̈ܐ، ܝܵܐ ܠܸܫܵܢܵܐ ܕܦܸܠܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","ܗܵܕܟ݂ܵܐ ܐܲܠܵܗܵܐ ܒܸܬ ܬܵܠܹܚ ܠܘܼܟ݂ ܠܥܵܠܲܡ، ܒܸܬ ܚܵܛܹܦ ܠܘܼܟ݂ ܘܣܵܬܹܪܘܼܟ݂ ܡ̣ܢ ܡܲܫܟܢܘܼܟ݂، ܘܒܸܬ ܥܵܩܹܪܘܼܟ݂ ܡ̣ܢ ܐܲܪܥܵܐ ܕܚܵܝܹ̈ܐ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","ܘܒܸܬ ܚܵܙܝܼ ܙܲܕܝܼܩܹ̈ܐ ܘܒܸܬ ܙܵܕܥܝܼ، ܘܥܲܠܘܼܗ‌ܝ ܒܸܬ ܓܵܚܟܝܼ، ܒܹܐܡܵܪܵܐ: ");
INSERT INTO aii_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","”ܗܵܐ، ܓܲܒ݂ܪܵܐ ܕܠܹܐ ܥܵܒܹܕ ܠܹܗ ܐܲܠܵܗܵܐ ܩܲܠܥܹܗ، ܐܸܠܵܐ ܡܘܼܬܸܒ݂ ܠܹܗ ܣܲܒ݂ܪܹܗ ܒܦܸܪܝܘܼܬܵ‌ܐ ܕܥܘܼܬܪܹܗ، ܘܚܘܼܠܸܢܹܗ ܒܫܲܗܘܲܬܬܹܗ ܡܲܚܪܸܒ݂ܵܢܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","ܐܝܼܢܵܐ ܐܵܢܵܐ، ܐܲܝܟ݂ ܙܲܝܬܵ‌ܐ ܩܝܼܢܵܐ ܝܘܸܢ ܓܵܘ ܒܲܝܬܵ‌ܐ ܕܐܲܠܵܗܵܐ، ܡܘܼܬܸܒ݂ ܠܝܼ ܣܲܒ݂ܪܝܼ ܒܛܲܝܒܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ ܠܥܵܠܲܡ ܥܵܠܡܝܼܢ. ");
INSERT INTO aii_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","ܒܸܬ ܫܲܟܪܸܢܘܼܟ݂ ܠܥܵܠܲܡ ܣܵܒܵܒ ܥܒ݂ܝܼܕ ܠܘܼܟ݂ ܐܵܗܵܐ، ܘܒܸܬ ܡܲܬܒܸܢ ܣܲܒ݂ܪܝܼ ܒܫܸܡܘܼܟ݂ ܣܵܒܵܒ ܛܵܒ݂ܵܐ ܝܠܹܗ ܩܲܕܡ ܗܲܡܸܢܵܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","ܐܡܝܼܪܹܗ ܣܲܟ݂ܠܵܐ ܒܠܸܒܹܗ: ”ܠܲܝܬ ܐܲܠܵܗܵܐ.“ ܚܪܝܼܒܹܐ ܝܢܵܐ، ܘܥܒ݂ܝܼܕ ܠܗܘܿܢ ܛܲܢܦܘܼܬܵ‌ܐ ܒܥܵܘܠܵܐ، ܠܲܝܬ ܥܵܒ݂ܕܵܢܵܐ ܕܛܵܒ݂ܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","ܐܲܠܵܗܵܐ ܡ̣ܢ ܫܡܲܝܵܐ ܓܘܼܫܸܩ ܠܹܗ ܥܲܠܔ ܒܢܲܝ̈ܢܵܫܵܐ، ܠܸܚܙܵܝܵܐ ܐܸܢ ܐܝܼܬ ܦܲܪܡܝܼܵܢܵܐ، ܛܵܥܝܵܢܵܐ ܠܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","ܟܠܵܝܗ‌ܝ ܩܠܝܼܒ ܠܗܘܿܢ، ܡܸܚܕܵܕܹ̈ܐ ܗܘܹܐ ܠܗܘܿܢ ܛܲܡܐܹ̈ܐ، ܠܲܝܬ ܥܵܒ݂ܕܵܢܵܐ ܕܛܵܒ݂ܬܵ‌ܐ، ܠܲܝܬ ܐܘܼܦ ܚܲܕ. ");
INSERT INTO aii_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","ܗܵܐ، ܠܵܐ ܝܕܝܼܥ ܠܗܘܿܢ ܦܵܠܚܵܢܹ̈ܐ ܕܥܵܘܠܵܐ، ܕܟܹܐ ܐܵܟ݂ܠܝܼ ܠܥܲܡܝܼ ܐܲܝܟ݂ ܕܐܵܟ݂ܠܝܼ ܠܲܚܡܵܐ، ܘܠܐܲܠܵܗܵܐ ܠܹܐ ܩܵܪܝܼ؟ ");
INSERT INTO aii_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","ܬܵܡܵܐ ܙܕܝܼܥ ܠܗܘܿܢ ܙܕܘܼܥܬܵ‌ܐ ܓܘܼܪܬܵ‌ܐ ܐܲܝܟܵܐ ܕܠܲܝܬ ܗܘܵܐ ܙܕܘܼܥܬܵ‌ܐ، ܣܵܒܵܒ ܐܲܠܵܗܵܐ ܒܘܼܪܒܸܙ ܠܹܗ ܓܲܪ̈ܡܹܐ ܕܡܵܚܝܵܢܹ̈ܐ ܕܡܲܫܪܝܼܬܵ‌ܐ ܥܲܠܘܼܟ݂، ܡܘܼܢܟܸܦܵܝ ܠܘܼܟ݂ ܣܵܒܵܒ ܐܲܠܵܗܵܐ ܡܘܼܣܠܝܼܵܝ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","ܛܘܼܒ݂ܵܐ ܕܐܵܬܹ‌ܐ ܡ̣ܢ ܨܸܗܝܘܿܢ ܦܘܼܪܩܵܢܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ؛ ܟܲܕ ܡܲܕܸܪ ܐܲܠܵܗܵܐ ܥܲܡܹܗ ܡ̣ܢ ܓܵܠܘܼܬܵ‌ܐ، ܒܸܬ ܦܵܨܹܚ ܝܲܥܩܘܿܒ݂، ܒܸܬ ܚܵܕܹܐ ܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","ܝܵܐ ܐܲܠܵܗܵܐ، ܦܲܪܸܩ ܠܝܼ ܒܫܸܡܘܼܟ݂، ܘܥܒ݂ܘܿܕ ܕܝܼܘܵܢܝܼ ܒܓܲܒܵܪܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","ܝܵܐ ܐܲܠܵܗܵܐ، ܫܡܹܥ ܠܵܗ̇ ܨܠܘܿܬ‌ܝܼ، ܗܲܒ݂ܠܔ ܢܵܬܵ‌ܐ ܠܗܹܡܸܙܡܵܢܹ̈ܐ ܕܦܘܼܡܝܼ، ");
INSERT INTO aii_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","ܒܗ̇ܝ ܕܢܘܼܟ݂ܪ̈ܵܝܹܐ ܩܝܼܡ ܠܗܘܿܢ ܥܲܠܝܼ، ܘܛܵܠܝܼܡܹ̈ܐ ܛܥܹܐ ܠܗܘܿܢ ܠܓܵܢܝܼ، ܠܵܐ ܡܘܼܬܸܒ݂ ܠܗܘܿܢ ܐܲܠܵܗܵܐ ܒܲܠܩܘܼܒ݂ܠܵܝܗ‌ܝ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","ܗܵܐ، ܐܲܠܵܗܵܐ ܗܲܝܸܪܵܢܵܐ ܝܠܹܗ ܐܸܠܝܼ، ܡܵܪܝܵܐ ܝܠܹܗ ܣܵܢܕܵܢܵܐ ܕܓܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","ܒܸܬ ܡܲܕܸܪ ܒܝܼܫܬܵ‌ܐ ܥܲܠܔ ܕܸܫ̃ܡܸܢܝܼ̈، ܒܫܲܪܝܼܪܘܼܬܘܼܟ݂ ܡܲܫܬܸܩ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","ܒܩܘܼܪܒܵܢܵܐ ܕܨܸܒ݂ܝܵܢܵܐ ܒܸܬ ܕܵܒ݂ܚܹܢ ܐܸܠܘܼܟ݂، ܒܸܬ ܫܲܟܪܸܢ ܠܫܸܡܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܒܗ̇ܝ ܕܛܵܒ݂ܵܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","ܒܗ̇ܝ ܕܡ̣ܢ ܟܠܔ ܥܵܘܩܵܢܵܐ ܩܵܡ ܦܲܨܹܐ ܠܝܼ، ܘܚܙܹܐ ܠܵܗ̇ ܥܲܝܢܝܼ ܙܵܟ݂ܘܼܬܵ‌ܐ ܠܕܸܫ̃ܡܸܢܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","ܗܲܒ݂ܠܔ ܢܵܬܵ‌ܐ، ܝܵܐ ܐܲܠܵܗܵܐ، ܠܨܠܘܿܬ‌ܝܼ، ܘܠܵܐ ܛܲܫܹܝܬ ܓܵܢܘܼܟ݂ ܡ̣ܢ ܦܲܪܦܲܠܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","ܡܲܨܝܸܬ ܐܸܠܝܼ ܘܓ̰ܲܘܸܒ ܠܝܼ، ܢܲܟܢܘܼܟܹܐ ܝܘܸܢ ܒܬܲܢܲܚܬ‌ܝܼ ܘܛܠܝܼܩܬܵ‌ܐ ܝܠܵܗ̇ ܥܲܠܝܼ، ");
INSERT INTO aii_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","ܡ̣ܢ ܩܵܠܵܐ ܕܕܸܫ̃ܡܸܢ، ܡ̣ܢ ܥܵܘܩܵܢܵܐ ܕܪܲܫܝܼܥܵܐ، ܒܗ̇ܝ ܕܟܹܐ ܡܲܫܦܸܟ݂ܝܼ ܥܲܠܝܼ ܣܸܪܝܘܼܬܵ‌ܐ، ܘܒܚܸܡܬܵ‌ܐ ܟܹܐ ܣܵܢܝܼ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","ܠܸܒܝܼ ܟܹܐ ܪܵܓܹܕ ܒܓܵܘܝܼ، ܘܣܘܼܪ̈ܵܕܹܐ ܕܡܵܘܬܵ‌ܐ ܢܦܝܼܠܔ ܠܗܘܿܢ ܥܲܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","ܙܕܘܼܥܬܵ‌ܐ ܘܪܲܬܪܲܬܬܵ‌ܐ ܥܒ݂ܝܼܪܗܘܿܢ ܒܝܼܝܼ، ܘܪܓܘܼܕܵܐ ܩܵܡ ܟܲܣܹܐ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","ܘܐܡܝܼܪܝܼ: ”ܛܘܼܒ݂ܵܐ ܕܗܵܘܹܐ ܗܘܵܐ ܠܝܼ ܓܘܼܠܦܵܢܹ̈ܐ ܐܲܝܟ݂ ܝܵܘܢܵܐ، ܕܦܵܪܚܹܢ ܗܘܵܐ ܘܪܵܝܦܹܢ ܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","”ܗܵܐ، ܒܸܬ ܥܵܪܩܹܢ ܗܘܵܐ ܪܸܚܩܵܐ، ܒܸܬ ܫܵܪܹܝܢ ܗܘܵܐ ܒܠܲܝܠܹܐ ܓܵܘ ܒܲܪܝܼܵܐ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","”ܒܸܬ ܡܲܠܝܸܙܸܢ ܠܦܲܪܘܼܩܘܼܗ̇ ܓܵܢܝܼ، ܡ̣ܢ ܦܵܘܚܵܐ ܚܲܝܠܵܢܵܐ ܘܡ̣ܢ ܥܲܠܥܵܠܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","ܒܲܠܒܸܠܔ، ܝܵܐ ܡܵܪܝܵܐ، ܦܲܠܸܥ ܠܸܫܵܢܵܝܗ‌ܝ، ܣܵܒܵܒ ܚܙܹܐ ܠܝܼ ܛܠܘܼܡܝܵܐ ܘܡܲܩܲܪܵܨܘܼܬܵ‌ܐ ܓܵܘ ܡܕܝܼܢ݇ܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","ܐܝܼܡܵܡܵܐ ܘܠܲܝܠܹܐ ܟܹܐ ܚܵܕܪܝܼ ܥܲܠܔ ܫܘܼܪ̈ܘܼܗ̇، ܘܥܵܘܠܵܐ ܘܐܘܼܠܨܵܢܵܐ ܒܓܵܘܘܼܗ̇ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","ܚܪ̈ܵܒܹܐ ܐܝܼܬ ܓܵܘܘܼܗ̇، ܘܠܹܐ ܦܵܪܩܝܼ ܛܠܘܼܡܝܵܐ ܘܦܸܠܡܵܐ ܡ̣ܢ ܫܘܼܩܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","ܣܵܒܵܒ ܠܹܐ ܝܗܘܵܐ ܕܸܫ̃ܡܸܢ ܕܠܝܼܡ ܠܹܗ ܐܸܠܝܼ، ܕܩܲܒܠܸܢ ܗܘܵܐ. ܠܹܐ ܝܗܘܵܐ ܣܵܢܝܵܢܝܼ ܕܓܘܼܪܘܸܣܵܐ ܠܹܗ ܓܵܢܹܗ ܥܲܠܝܼ، ܕܛܲܫܹܝܢ ܗܘܵܐ ܠܵܗ̇ ܓܵܢܝܼ ܡܸܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","ܐܝܼܢܵܐ ܐܲܢ݇ܬ، ܐܢܵܫܵܐ ܐܲܝܟ݂ ܕܝܼܝܼ، ܪܵܚܡܝܼ ܘܝܵܕܥܵܢܝܼ، ");
INSERT INTO aii_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","ܕܥܲܡ ܚܕܵܕܹ̈ܐ ܥܒ݂ܝܼܕ ܠܲܢ ܫܵܘܬܵܦܘܼܬܵ‌ܐ ܚܠܝܼܬܵ‌ܐ، ܓܵܘ ܒܲܝܬܵ‌ܐ ܕܐܲܠܵܗܵܐ ܟܹܐ ܚܵܕܪܲܚ ܗܘܵܘ ܥܲܡ ܟܸܢܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","ܐܵܬܹ‌ܐ ܡܵܘܬܵ‌ܐ ܥܲܠܵܝܗ‌ܝ ܡܸܢܫܸܠܬܵܢܹܐ، ܨܵܠܝܼ ܠܫܝܘܿܠܔ ܟܲܕ ܚܵܝܹ̈ܐ، ܣܵܒܵܒ ܒܝܼܫܵܬܹ̈‌ܐ ܐܝܼܬ ܓܵܘ ܒܹܝܬ ܡܲܥܡܪ̈ܵܝܗ‌ܝ، ܒܓܵܘܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","ܐܝܼܢܵܐ ܐܵܢܵܐ، ܠܐܲܠܵܗܵܐ ܒܸܬ ܩܵܪܹܝܢ، ܘܡܵܪܝܵܐ ܒܸܬ ܦܲܪܸܩ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","ܪܲܡܫܵܐ، ܘܨܲܦܪܵܐ، ܘܛܲܗܪܵܐ، ܒܸܬ ܩܵܒ݂ܠܹܢ ܘܬܲܢܸܚܸܢ، ܘܒܸܬ ܫܵܡܹܥ ܠܹܗ ܩܵܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","ܒܸܬ ܦܲܪܸܩ ܒܫܠܵܡܵܐ ܓܵܢܝܼ ܡ̣ܢ ܦܠܵܫܵܐ ܕܥܲܠܝܼ، ܣܵܒܵܒ ܪܵܒܵܐ ܝܢܵܐ ܕܲܠܩܘܼܒ݂ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","ܒܸܬ ܫܵܡܹܥ ܐܲܠܵܗܵܐ، ܝܵܬܒ݂ܵܢܵܐ ܕܡ̣ܢ ܙܲܒ݂ܢܹ̈ܐ ܩܲܕܝܼܡܵܝܹ̈ܐ، ܘܒܸܬ ܡܲܠܝܸܨ ܠܗܘܿܢ. ܣܹܠܵܗ ܣܵܒܵܒ ܠܹܐ ܫܲܚܠܸܦܝܼ، ܘܠܹܐ ܙܵܕܥܝܼ ܡ̣ܢ ܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","ܦܘܼܫܸܛ ܠܹܗ ܐܝܼܕܵܬܘܼ̈ܗ‌ܝ ܥܲܠܔ ܕܐܵܢܝܼ ܕܝܼܢܵܐ ܒܫܠܵܡܵܐ ܥܲܡܹܗ، ܫܡܝܼܛ ܠܹܗ ܩܵܘܠܹܗ، ");
INSERT INTO aii_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","ܟ̰ܘܼܥܝܵܐ ܐܲܝܟ݂ ܟܲܪܥܵܐ ܦܘܼܡܹܗ، ܐܝܼܢܵܐ ܐܝܼܬ ܦܠܵܫܵܐ ܒܠܸܒܹܗ؛ ܪܲܟܝܼܟܹܐ ܚܲܒܪ̈ܘܼܗ‌ܝ ܡ̣ܢ ܡܸܫܚܵܐ، ܐܝܼܢܵܐ ܣܲܝܦܹ̈ܐ ܓܪ̈ܝܼܫܹܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","ܕܪܝܼ ܠܵܗ̇ ܥܲܠܔ ܡܵܪܝܵܐ ܟܵܪܬܘܼܟ݂، ܘܗ̇ܘ ܒܸܬ ܬܲܪܣܹܐ ܠܘܼܟ݂، ܠܹܐ ܫܵܒܹܩ ܠܥܵܠܲܡ ܙܲܕܝܼܩܵܐ ܫܵܥܹܫ. ");
INSERT INTO aii_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","ܐܝܼܢܵܐ ܐܲܢ݇ܬ، ܝܵܐ ܐܲܠܵܗܵܐ، ܒܸܬ ܡܲܨܠܹܝܬ ܠܗܘܿܢ ܠܓܘܼܒܵܐ ܕܚܪܵܒ݂ܵܐ، ܫܲܦܟ݂ܵܢܹ̈ܐ ܕܕܸܡܵܐ ܘܥܵܒ݂ܕܵܢܹ̈ܐ ܕܦܸܠܡܵܐ ܠܹܐ ܡܵܛܝܼ ܠܦܲܠܓܵܐ ܕܚܲܝܵܝ̈ܗ‌ܝ؛ ܐܝܼܢܵܐ ܐܵܢܵܐ ܒܸܬ ܣܵܒܪܹܢ ܒܝܼܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","ܪܲܚܸܡ ܥܲܠܝܼ، ܝܵܐ ܐܲܠܵܗܵܐ، ܒܗ̇ܝ ܕܩܵܡ ܕܵܐܹܫ ܠܝܼ ܒܲܪܢܵܫܵܐ، ܟܠܹܗ ܝܵܘܡܵܐ ܦܵܠܫܵܢܹ̈ܐ ܡܲܠܝܘܼܨܝܼ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","ܩܵܡ ܕܵܝܫܝܼ ܠܝܼ ܕܸܫ̃ܡܸܢܝܼ̈ ܟܠܹܗ ܝܵܘܡܵܐ، ܒܗ̇ܝ ܕܪܵܒܵܐ ܝܢܵܐ ܦܵܠܫܵܢܹ̈ܐ ܥܲܡܝܼ ܒܚܬܝܼܪܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","ܝܵܘܡܵܐ ܕܙܵܕܥܹܢ ܐܵܢܵܐ، ܒܝܼܘܼܟ݂ ܒܸܬ ܣܵܒܪܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","ܒܐܲܠܵܗܵܐ، ܗ̇ܘ ܕܟܹܐ ܚܵܩܪܹܢ ܗܹܡܸܙܡܵܢܹܗ، ܒܐܲܠܵܗܵܐ ܣܒܝܼܪܝܼ، ܠܹܐ ܙܵܕܥܹܢ. ܡܘܼܕܝܼ ܡܵܨܹܐ ܥܵܒܹܕ ܒܲܪܢܵܫܵܐ ܐܸܠܝܼ؟ ");
INSERT INTO aii_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","ܟܠܹܗ ܝܵܘܡܵܐ ܗܹܡܸܙܡܵܢܝܼ̈ ܟܹܐ ܡܲܦܟ̰ܸܠܝܼ، ܟܠܵܝܗ‌ܝ ܚܘܼܫܵܒ݂ܵܝ̈ܗ‌ܝ ܒܘܼܬ ܕܝܼܝܼ ܠܒܝܼܫܬܵ‌ܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","ܓ̰ܡܝܼܥ ܠܗܘܿܢ، ܝܬܝܼܒ݂ ܠܗܘܿܢ ܒܟܡܹܐܢܵܐ ܐܵܢܝܼ، ܢܛܝܼܪܗܘܿܢ ܥܸܩܒܝܼ̈، ܒܸܣܦܵܪܵܐ ܕܫܵܩܠܝܼ ܠܓܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","ܠܲܝܬ ܚܠܵܨܵܐ ܐܸܠܵܝܗ‌ܝ ܡ̣ܢ ܥܸܠܬܵ‌ܐ ܕܥܵܘܠܵܝܗ‌ܝ، ܡܲܨܠܝܼ ܠܗܘܿܢ ܥܲܡܡܹ̈ܐ ܒܚܸܡܬܵ‌ܐ، ܝܵܐ ܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","ܚܕܵܪ̈ܝܵܬ‌ܝܼ ܡܢܹܐ ܠܘܼܟ݂ ܐܲܢ݇ܬ، ܡܲܬܸܒ݂ ܕܸܡܥܝܼ̈ ܒܓܘܼܕܘܼܟ݂. ܗܵܐ، ܠܹܐ ܝܢܵܐ ܒܟܬܵܒ݂ܘܼܟ݂؟ ");
INSERT INTO aii_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","ܗ̇ܝܓܵܗ ܒܸܬ ܕܵܝܪܝܼ ܕܸܫ̃ܡܸܢܝܼ̈ ܠܒܵܬܪܵܐ ܒܝܵܘܡܵܐ ܕܩܵܪܹܝܢ، ܐܵܗܵܐ ܝܕܝܼܥ ܠܝܼ، ܕܐܲܠܵܗܵܐ ܩܵܬ‌ܝܼ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","ܒܐܲܠܵܗܵܐ، ܗ̇ܘ ܕܟܹܐ ܚܵܩܪܹܢ ܗܹܡܸܙܡܵܢܹܗ، ܒܡܵܪܝܵܐ، ܗ̇ܘ ܕܟܹܐ ܚܵܩܪܹܢ ܗܹܡܸܙܡܵܢܹܗ، ");
INSERT INTO aii_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","ܒܐܲܠܵܗܵܐ ܣܒܝܼܪܝܼ، ܠܹܐ ܙܵܕܥܹܢ؛ ܡܘܼܕܝܼ ܡܵܨܹܐ ܥܵܒܹܕ ܒܲܪܢܵܫܵܐ ܐܸܠܝܼ؟ ");
INSERT INTO aii_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","ܘܵܠܝܼܬ‌ܝܼ ܝܢܵܐ ܢܸܕܪܹ̈ܐ ܕܐܸܠܘܼܟ݂، ܝܵܐ ܐܲܠܵܗܵܐ، ܒܸܬ ܬܲܡܸܡܸܢ ܕܸܒ݂ܚܹ̈ܐ ܕܫܲܟܲܪ̈ܝܵܬܹ‌ܐ ܐܸܠܘܼܟ݂، ");
INSERT INTO aii_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","ܒܗ̇ܝ ܕܩܵܡ ܦܲܨܹܝܬ ܠܵܗ̇ ܓܵܢܝܼ ܡ̣ܢ ܡܵܘܬܵ‌ܐ، ܗܹܐ، ܐܲܩܠܵܬ‌ܝܼ̈ ܡ̣ܢ ܬܲܪܩܲܠܬܵ‌ܐ، ܕܚܵܕܪܹܢ ܩܲܕܡ ܐܲܠܵܗܵܐ ܒܒܲܗܪܵܐ ܕܚܵܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","ܪܲܚܸܡ ܥܲܠܝܼ، ܝܵܐ ܐܲܠܵܗܵܐ، ܪܲܚܸܡ ܥܲܠܝܼ، ܒܗ̇ܝ ܕܒܝܼܘܼܟ݂ ܒܸܫܩܵܠܵܐ ܝܠܵܗ̇ ܓܵܘܣܵܐ ܓܵܢܝܼ، ܘܒܛܸܠܵܢܝܼܬܵ‌ܐ ܕܓܘܼܠܦܵܢܘܼ̈ܟ݂ ܒܸܬ ܫܵܩܠܹܢ ܓܵܘܣܵܐ، ܗܲܠܔ ܕܥܵܒ݂ܪܝܼ ܐܘܼܠܨܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","ܒܸܬ ܩܵܪܹܝܢ ܠܐܲܠܵܗܵܐ ܥܸܠܵܝܵܐ، ܠܐܲܠܵܗܵܐ ܕܟܹܐ ܬܲܡܸܡ ܟܠܔ ܡܸܢܕܝܼ ܩܵܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","ܒܸܬ ܫܲܕܸܪ ܡ̣ܢ ܫܡܲܝܵܐ ܘܦܲܪܸܩ ܠܝܼ، ܒܸܬ ܠܵܐܹܡ ܠܗ̇ܘ ܕܝܼܠܹܗ ܛܲܚܛܘܼܚܹܐ ܠܝܼ، ܣܹܠܵܗ ܒܸܬ ܫܲܕܸܪ ܐܲܠܵܗܵܐ ܛܲܝܒܘܼܬܹܗ ܘܫܲܪܝܼܪܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","ܓܵܢܝܼ ܓܵܘܵܐ ܕܐܲܪ̈ܝܹܐ ܝܠܵܗ̇، ܟܹܐ ܕܵܡܟܹܢ ܓܵܘܵܐ ܕܢܘܼܪܹ̈ܐ ܠܵܗܝܵܢܹ̈ܐ، ܒܢܲܝ̈ܢܵܫܵܐ ܕܟܹܟܵܝ̈ܗ‌ܝ ܪܘܼܡܚܵܐ ܝܢܵܐ ܘܓܹܐܪܹ̈ܐ، ܘܠܸܫܵܢܵܝܗ‌ܝ ܣܲܝܦܵܐ ܚܲܪܝܼܦܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","ܪܘܼܡ ܥܲܠܔ ܫܡܲܝܵܐ، ܝܵܐ ܐܲܠܵܗܵܐ، ܥܲܠܔ ܟܠܵܗ̇ ܐܲܪܥܵܐ ܗܵܘܹܐ ܐܝܼܩܵܪܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","ܓܲܪܕܵܐ ܗܘܼܕܸܪܗܘܿܢ ܠܦܵܣܘܿܥܝܵܬ‌ܝܼ̈، ܟܝܼܦ ܠܵܗ̇ ܓܵܢܝܼ، ܚܦܝܼܪܗܘܿܢ ܓܘܼܒܵܐ ܒܐܘܼܪܚܝܼ، ܐܝܼܢܵܐ ܒܓܵܢܵܝܗ‌ܝ ܢܦܝܼܠܔ ܠܗܘܿܢ ܒܓܵܘܹܗ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","ܡܩܵܘܝܵܢܵܐ ܝܠܹܗ ܠܸܒܝܼ، ܝܵܐ ܐܲܠܵܗܵܐ، ܡܩܵܘܝܵܢܵܐ ܝܠܹܗ ܠܸܒܝܼ، ܒܸܬ ܫܲܒܚܸܢ ܘܒܸܬ ܙܵܡܪܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","ܪܥܘܿܫܝ، ܝܵܐ ܓܵܢܝܼ! ܪܥܘܿܫܝ، ܩܝܼܬܵܪܵܐ ܘܟܸܢܵܪܵܐ! ܒܸܬ ܡܲܪܥܸܫܸܢ ܠܨܲܦܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","ܒܸܬ ܫܲܟܪܸܢܘܼܟ݂ ܓܵܘ ܥܲܡܡܹ̈ܐ، ܝܵܐ ܡܵܪܝܵܐ، ܒܸܬ ܙܵܡܪܹܢ ܐܸܠܘܼܟ݂ ܓܵܘ ܐܸܡܘܵܬܹ̈‌ܐ، ");
INSERT INTO aii_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","ܒܗ̇ܝ ܕܓܘܼܪܬܵ‌ܐ ܝܠܵܗ̇ ܗܲܠܔ ܫܡܲܝܵܐ ܛܲܝܒܘܼܬܘܼܟ݂، ܘܗܲܠܔ ܥܢܵܢܹ̈ܐ ܫܲܪܝܼܪܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","ܪܘܼܡ ܥܲܠܔ ܫܡܲܝܵܐ، ܝܵܐ ܐܲܠܵܗܵܐ، ܥܲܠܔ ܟܠܵܗ̇ ܐܲܪܥܵܐ ܗܵܘܹܐ ܐܝܼܩܵܪܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","ܗܵܐ ܒܫܪܵܪܵܐ، ܙܲܕܝܼܩܘܼܬܵ‌ܐ ܗܲܡܙܘܼܡܹܐ ܝܬܘܿܢ، ܝܵܐ ܕܲܝܵܢܹ̈ܐ؟ ܒܬܪܘܼܨܘܼܬܵ‌ܐ ܒܸܕܝܵܢܵܐ ܝܬܘܿܢ ܒܢܲܝ̈ܢܵܫܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","ܠܵܐ، ܐܸܠܵܐ ܒܠܸܒܵܘܟ݂ܘܿܢ ܒܸܦܠܵܚܵܐ ܝܬܘܿܢ ܥܵܘ̈ܠܹܐ، ܒܐܲܪܥܵܐ ܦܲܠܘܼܥܹܐ ܝܬܘܿܢ ܚܸܡܬܵ‌ܐ ܕܐܝܼܕܵܬܵܘ̈ܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","ܪ̈ܲܫܝܼܥܹܐ ܗܘܹܐ ܠܗܘܿܢ ܢܘܼܟ݂ܪ̈ܵܝܹܐ ܡ̣ܢ ܡܲܪܒܥܵܐ، ܚܠܝܼܛ ܠܗܘܿܢ ܡ̣ܢ ܒܲܛܢܵܐ ܗܲܡܙܸܡܵܢܹ̈ܐ ܕܕܘܼܓܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","ܚܸܡܬܵܝܗ‌ܝ ܐܲܝܟ݂ ܕܡܘܼܬܵ‌ܐ ܕܚܸܡܬܵ‌ܐ ܕܚܘܼܘܹܐ ܝܠܵܗ̇، ܐܲܝܟ݂ ܦܲܬܢܵܐ ܚܲܪܫܵܐ ܕܟܹܐ ܕܵܒܹܪ ܢܵܬܹܗ، ");
INSERT INTO aii_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","ܕܠܹܐ ܫܵܡܹܥ ܩܵܠܵܐ ܕܦܲܛܦܸܛܵܢܹ̈ܐ، ܝܲܢ ܕܡܲܪܩܸܕܵܢܵܐ ܡܗܝܼܪܵܐ ܕܚܘܼܵܘܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","ܝܵܐ ܐܲܠܵܗܵܐ، ܫܡܘܿܛ ܟܹܟܵܝ̈ܗ‌ܝ ܓܵܘ ܦܘܼܡܵܝܗ‌ܝ، ܢܝܼܒܹ̈ܐ ܕܓܘܼܪ̈ܝܹܐ ܕܐܲܪ̈ܝܹܐ ܥܩܘܿܪ، ܝܵܐ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","ܫܒ݂ܘܿܩ ܛܵܠܩܝܼ ܐܲܝܟ݂ ܡ̈ܝܼܵܐ ܕܟܹܐ ܓ̰ܵܪܝܼ، ܩܵܛܥܝܼ ܓܹܐܪ̈ܘܼܗ‌ܝ ܐܝܼܡܲܢ ܕܡܵܬܹܚ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","ܗܵܘܝܼ ܐܲܝܟ݂ ܚܲܠܵܙܘܿܢܵܐ ܒܸܦܫܵܪܵܐ ܟܲܕ ܒܸܪܚܵܫܵܐ، ܐܲܝܟ݂ ܡܘܼܪ̈ܚܸܫܹܐ ܕܒܲܟ݂ܬܵܬܹ̈‌ܐ ܕܠܵܐ ܚܙܹܐ ܠܗܘܿܢ ܫܸܡܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","ܡ̣ܢ ܩܲܕܡ ܕܡܵܪܸ̈ܓܠܵܘܟ݂ܘܿܢ ܫܵܚܢܝܼ ܡ̣ܢ ܢܘܼܪܵܐ ܕܟܸܬܘܹ̈ܐ، ܐܲܝܟ݂ ܬܲܠܝܼܠܵܐ ܐܘܼܦ ܒܪܝܼܙܵܐ، ܒܸܬ ܦܵܝܫܝܼ ܓܪܝܼܦܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","ܒܸܬ ܚܵܕܝܼ ܙܲܕܝܼܩܹ̈ܐ ܟܲܕ ܚܙܹܐ ܠܗܘܿܢ ܬܘܼܥܠܵܐ، ܐܲܩܠܵܬܵܝ̈ܗ‌ܝ ܒܸܬ ܚܲܠܸܠܔ ܠܝܼ ܒܕܸܡܵܐ ܕܪ̈ܲܫܝܼܥܹܐ، ");
INSERT INTO aii_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","ܘܒܸܬ ܐܵܡܹܪ ܒܲܪܢܵܫܵܐ: ”ܒܫܪܵܪܵܐ، ܐܝܼܬ ܦܘܼܪܥܵܢܵܐ ܠܙܲܕܝܼܩܵܐ، ܒܫܪܵܪܵܐ، ܐܝܼܬ ܐܲܠܵܗܵܐ ܕܟܹܐ ܕܵܐܹܢ ܒܐܲܪܥܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","ܦܲܨܝܼ ܠܝܼ ܡ̣ܢ ܕܸܫ̃ܡܸܢܝܼ̈، ܝܵܐ ܐܲܠܵܗ‌ܝܼ، ܡܲܪܡܹܝܬ ܠܝܼ ܪܸܚܩܵܐ ܠܥܸܠܔ ܡ̣ܢ ܩܵܝܡܵܢܹ̈ܐ ܕܥܲܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","ܦܲܨܝܼ ܠܝܼ ܡ̣ܢ ܦܵܠܚܵܢܹ̈ܐ ܕܥܵܘܠܵܐ، ܘܦܲܪܸܩ ܠܝܼ ܡ̣ܢ ܫܲܦܟ݂ܵܢܹ̈ܐ ܕܕܸܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","ܣܵܒܵܒ ܗܵܐ، ܝܬܝܼܒ݂ ܠܗܘܿܢ ܒܟܡܹܐܢܵܐ ܠܓܵܢܝܼ، ܓ̰ܡܝܼܥ ܠܗܘܿܢ ܥܲܠܝܼ ܙܲܪ̈ܒܵܢܹܐ، ܐܵܦܸܢ ܕܠܹܐ ܝܘܸܢ ܥܒ݂ܝܼܕܵܐ ܓܢܵܗܵܐ ܐܵܦܠܵܐ ܚܛܝܼܬܵ‌ܐ، ܝܵܐ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","ܟܲܕ ܠܵܐ ܥܒ݂ܝܼܕܵܐ ܥܵܘܠܵܐ، ܟܹܐ ܪܵܚܛܝܼ ܘܗܲܕܪܝܼ ܓܵܢܵܝܗ‌ܝ، ܬܥܘܿܪ ܠܸܬܦܵܩܵܐ ܒܝܼܝܼ، ܘܚܙܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","ܘܐܲܢ݇ܬ، ܝܵܐ ܡܵܪܝܵܐ ܐܲܠܵܗܵܐ ܚܲܝܠܬܵܢܵܐ، ܐܲܠܵܗܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ، ܪܥܘܿܫ ܠܸܦܪܵܥܵܐ ܠܟܠܵܝܗ‌ܝ ܐܸܡܘܵܬܹ̈‌ܐ، ܠܵܐ ܪܵܚܡܹܬ ܠܗܸܟ̃ ܥܵܘܵܠܵܐ ܠܵܐ ܡܗܘܼܡܢܵܐ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","ܟܹܐ ܕܵܝܪܝܼ ܒܪܲܡܫܵܐ ܙܵܘܙܝܼ ܐܲܝܟ݂ ܟܲܠܒܹ̈ܐ، ܘܚܵܕܪܝܼ ܚܵܕܸܪ̈ܘܵܢܹܐ ܕܡܕܝܼܢ݇ܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","ܗܵܐ، ܟܹܐ ܓܲܒܓܸܒܝܼ ܠܹܗ ܦܘܼܡܵܝܗ‌ܝ ܒܡܹܐܡܪܹ̈ܐ، ܕܝܼܢܵܐ ܣܲܝܦܹ̈ܐ ܒܣܸܦܘܵܬܵܝ̈ܗ‌ܝ، ܣܵܒܵܒ ܟܹܐ ܐܵܡܪܝܼ: ”ܡܵܢܝܼ ܝܠܹܗ ܒܸܫܡܵܥܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","ܐܝܼܢܵܐ ܐܲܢ݇ܬ، ܝܵܐ ܡܵܪܝܵܐ، ܒܸܬ ܓܵܚܟܹܬ ܒܝܼܵܝܗ‌ܝ، ܒܸܬ ܡܲܣܚܸܪܸܬ ܒܟܠܵܝܗ‌ܝ ܐܸܡܘܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","ܝܵܐ ܚܲܝܠܝܼ، ܐܸܠܘܼܟ݂ ܒܸܬ ܣܵܦܪܹܢ، ܣܵܒܵܒ ܐܲܠܵܗܵܐ ܝܠܹܗ ܒܹܝܬ ܓܵܘܣܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","ܐܲܠܵܗܵܐ ܕܛܲܝܒܘܼܬ‌ܝܼ ܒܸܬ ܬܵܦܹܩ ܒܝܼܝܼ، ܐܲܠܵܗܵܐ ܒܸܬ ܡܲܚܙܹܐ ܠܝܼ ܙܵܟ݂ܘܼܬܵ‌ܐ ܠܕܸܫ̃ܡܸܢܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","ܠܵܐ ܩܵܛܠܹܬ ܠܗܘܿܢ ܕܠܵܐ ܗܵܘܹܐ ܕܥܲܡܝܼ ܢܵܫܝܼ، ܡܲܫܥܸܫ ܠܗܘܿܢ ܒܚܲܝܠܘܼܟ݂، ܘܡܲܢܦܸܠܔ ܠܗܘܿܢ، ܝܵܐ ܡܵܪܝܵܐ ܡܵܛܵܠܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","ܒܘܼܬ ܚܛܝܼܬܵ‌ܐ ܕܦܘܼܡܵܝܗ‌ܝ، ܗܹܡܸܙܡܵܢ ܕܣܸܦܘܵܬܵܝ̈ܗ‌ܝ، ܦܵܝܫܝܼ ܕܒ݂ܝܼܩܹܐ ܒܫܘܼܒ݂ܗܵܪܵܝܗ‌ܝ، ܘܒܘܼܬ ܠܵܘܛܬܵ‌ܐ ܘܕܲܓܵܠܘܼܬܵ‌ܐ ܕܟܹܐ ܗܲܩܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","ܛܲܠܸܩ ܠܗܘܿܢ ܒܚܸܡܬܵ‌ܐ، ܛܲܠܸܩ ܠܗܘܿܢ ܕܠܵܐ ܦܵܝܫܝܼ، ܕܝܵܕܥܝܼ ܐܲܠܵܗܵܐ ܒܸܥܒ݂ܵܕܵܐ ܝܠܹܗ ܫܘܼܠܛܵܢܵܐ ܥܲܠܔ ܝܲܥܩܘܿܒ݂، ܗܲܠܔ ܡܲܪ̈ܙܵܢܹܐ ܕܐܲܪܥܵܐ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","ܟܹܐ ܕܵܝܪܝܼ ܒܪܲܡܫܵܐ ܙܵܘܙܝܼ ܐܲܝܟ݂ ܟܲܠܒܹ̈ܐ، ܘܚܵܕܪܝܼ ܚܵܕܸܪ̈ܘܵܢܹܐ ܕܡܕܝܼܢ݇ܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","ܐܵܢܝܼ ܟܹܐ ܚܵܕܪܝܼ ܒܵܬܪ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ، ܐܸܢ ܠܵܐ ܣܵܒ݂ܥܝܼ ܟܹܐ ܡܲܪܡܸܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","ܐܝܼܢܵܐ ܐܵܢܵܐ، ܒܸܬ ܙܵܡܪܹܢ ܒܘܼܬ ܚܲܝܠܘܼܟ݂، ܘܒܸܬ ܫܲܒܚܸܢ ܒܨܲܦܪܵܐ ܒܘܼܬ ܛܲܝܒܘܼܬܘܼܟ݂، ܣܵܒܵܒ ܗܘܹܐ ܠܘܼܟ݂ ܒܹܝܬ ܓܵܘܣܵܐ ܩܵܬ‌ܝܼ، ܘܚܸܣܢܵܐ ܒܝܵܘܡܵܐ ܕܥܵܘܩܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","ܝܵܐ ܚܲܝܠܝܼ، ܐܸܠܘܼܟ݂ ܒܸܬ ܙܵܡܪܹܢ، ܣܵܒܵܒ ܐܲܠܵܗܵܐ ܒܹܝܬ ܓܵܘܣܝܼ ܝܠܹܗ، ܐܲܠܵܗܵܐ ܕܛܲܝܒܘܼܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","ܝܵܐ ܐܲܠܵܗܵܐ، ܩܵܡ ܡܲܚܦܸܠܸܬ ܠܲܢ ܘܩܵܡ ܬܵܪܥܹܬ ܠܲܢ، ܟܪܝܼܒ ܠܘܼܟ݂؛ ܡܲܕܸܪܸܬ ܠܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","ܕܘܼܪܘܸܕܵܐ ܠܘܼܟ݂ ܐܲܪܥܵܐ، ܟ̰ܠܝܼܦܵܐ ܠܘܼܟ݂، ܒܲܣܸܡ ܬܒ݂ܵܪܬܘܼܗ̇ ܣܵܒܵܒ ܫܥܝܼܫܬܵ‌ܐ ܝܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","ܡܘܼܚܙܹܐ ܠܘܼܟ݂ ܠܥܲܡܘܼܟ݂ ܩܸܫܝܘܼܬܵ‌ܐ، ܩܵܡ ܡܲܫܬܹܝܬ ܠܲܢ ܚܲܡܪܵܐ ܦܲܢܦܸܠܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","ܝܘܼܗܒܹܠܔ ܠܘܼܟ݂ ܐܵܬܵ‌ܐ ܠܙܕܝܼܥܘܼ̈ܟ݂، ܠܸܥܪܵܩܵܐ ܟܸܣ ܠܘܼܗ̇ ܡܩܲܕܡ ܩܸܫܬܵ‌ܐ، ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","ܩܵܐ ܕܚܵܠܨܝܼ ܡܘܼܚܸܒܘܼ̈ܟ݂، ܦܲܪܸܩ ܒܝܲܡܝܼܢܘܼܟ݂ ܘܓ̰ܲܘܸܒ ܠܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","ܐܲܠܵܗܵܐ ܗܘܼܡܙܸܡ ܠܹܗ ܒܩܘܼܕܫܹܗ: ”ܒܸܬ ܦܵܨܚܹܢ، ܒܸܬ ܦܲܠܥܸܢ ܠܫܟܹܝܡ ܘܪܵܘܘܿܠܵܐ ܕܣܵܟܘܼܬ ܒܸܬ ܟܵܝܠܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","”ܕܝܼܝܼ ܝܠܹܗ ܓܸܠܥܵܕ، ܘܕܝܼܝܼ ܝܠܹܗ ܡܢܲܫܹܐ، ܐܲܦܪܹܝܡ ܣܲܢܘܲܪܬܵ‌ܐ ܕܪܹܝܫܝܼ، ܝܼܗܘܼܕܵܐ ܚܘܼܛܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","”ܡܘܼܐܵܒ݂ ܡܵܪܸܓܠܵܐ ܕܚܲܠܲܠܬ‌ܝܼ، ܥܲܠܔ ܐܲܕܘܿܡ ܒܸܬ ܪܲܦܹܝܢ ܨܵܘܸܠܬ‌ܝܼ، ܥܲܠܔ ܦܠܸܫܬ ܒܸܬ ܡܲܩܘܸܚܸܢ.“ ");
INSERT INTO aii_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","ܡܵܢܝܼ ܒܸܬ ܠܲܒܸܠܔ ܠܝܼ ܠܡܕܝܼܢ݇ܬܵ‌ܐ ܡܘܼܩܘܝܼܬܵ‌ܐ؟ ܡܵܢܝܼ ܒܸܬ ܡܗܲܕܹܐ ܠܝܼ ܗܲܠܔ ܐܲܕܘܿܡ؟ ");
INSERT INTO aii_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","ܗܵܐ، ܠܹܐ ܝܘܸܬ ܐܲܢ݇ܬ ܡܘܼܚܦܸܠܵܐ ܐܸܠܲܢ، ܝܵܐ ܐܲܠܵܗܵܐ؟ ܘܠܹܐ ܦܵܠܛܹܬ ܥܲܡ ܚܲܝܠܵܘܵܬܲܢ̈، ܝܵܐ ܐܲܠܵܗܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","ܗܲܒ݂ܠܔ ܠܲܢ ܗܲܝܲܪܬܵ‌ܐ ܩܲܕܡ ܕܸܫ̃ܡܸܢ، ܣܵܒܵܒ ܣܪܝܼܩܘܼܬܵ‌ܐ ܝܠܵܗ̇ ܦܲܪܲܩܬܵ‌ܐ ܕܒܲܪܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","ܒܐܲܠܵܗܵܐ ܒܸܬ ܥܵܒ݂ܕܲܚ ܓܲܒܵܪܘܼܬܵ‌ܐ، ܘܗ̇ܘ ܒܸܬ ܕܲܫܕܸܫ ܠܕܸܫ̃ܡܸܢܲܢ̈. ");
INSERT INTO aii_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","ܫܡܹܥ، ܝܵܐ ܐܲܠܵܗܵܐ، ܠܡܲܩܘܲܚܬ‌ܝܼ، ܨܘܼܬ ܠܨܠܘܿܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","ܡ̣ܢ ܦܪܵܩܬܵ‌ܐ ܕܐܲܪܥܵܐ ܒܸܬ ܩܵܪܹܝܢ ܐܸܠܘܼܟ݂ ܟܲܕ ܕܘܼܪܕܸܫ̃ܵܐ ܠܸܒܝܼ، ܡܗܲܕܝܼ ܠܝܼ ܠܐܝܼܨܵܪܵܐ ܒܘܼܫ ܪܵܡܵܐ ܡܸܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","ܣܵܒܵܒ ܗܘܹܐ ܠܘܼܟ݂ ܒܹܝܬ ܓܵܘܣܵܐ ܐܸܠܝܼ، ܒܘܼܪܓ̰ܵܐ ܙܲܪܒܵܢܵܐ ܩܲܕܡ ܕܸܫ̃ܡܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","ܒܸܬ ܥܵܡܪܹܢ ܓܵܘ ܡܲܫܟܢܘܼܟ݂ ܠܥܵܠܡܝܼܢ، ܒܸܬ ܫܵܩܠܹܢ ܓܵܘܣܵܐ ܒܣܸܬܵܪܵܐ ܕܓܘܼܠܦܵܢܘܼ̈ܟ݂. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","ܒܗ̇ܝ ܕܐܲܢ݇ܬ، ܝܵܐ ܐܲܠܵܗܵܐ، ܫܡܝܼܥ ܠܘܼܟ݂ ܢܸܕܪ̈ܝܼ، ܩܵܡ ܝܵܗܒܹܬ ܠܝܼ ܝܘܼܪܬܵܢܵܐ ܥܲܡ ܙܕܝܼ̈ܥܹܐ ܕܫܸܡܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","ܝܵܘܡܵܢܹ̈ܐ ܒܸܬ ܡܲܙܝܸܕܸܬ ܥܲܠܔ ܝܵܘܡܵܢܹ̈ܐ ܕܡܲܠܟܵܐ، ܫܸܢܘܼ̈ܗ‌ܝ ܒܸܬ ܗܵܘܝܼ ܠܕܵܪܵܐ ܘܕܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","ܒܸܬ ܝܵܬܹܒ݂ ܠܥܵܠܲܡ ܩܲܕܡ ܐܲܠܵܗܵܐ، ܦܩܘܿܕ ܛܲܝܒܘܼܬܵ‌ܐ ܘܫܪܵܪܵܐ ܠܸܢܛܵܪܵܐ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","ܗܵܕܟ݂ܵܐ ܠܫܸܡܘܼܟ݂ ܒܸܬ ܙܵܡܪܹܢ ܠܥܵܠܲܡ، ܟܲܕ ܬܲܡܘܼܡܹܐ ܢܸܕܪ̈ܝܼ ܝܵܘܡܵܐ ܒܝܵܘܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","ܐܲܚܟ̰ܝܼ ܠܐܲܠܵܗܵܐ ܒܫܸܬܩܵܐ ܒܸܣܦܵܪܵܐ ܝܠܵܗ̇ ܓܵܢܝܼ، ܡܸܢܹܗ ܝܠܹܗ ܦܘܼܪܩܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","ܐܲܚܟ̰ܝܼ ܗ̇ܘ ܝܼܠܹܗ ܐܝܼܨܵܪܝܼ ܘܦܘܼܪܩܵܢܝܼ، ܩܲܠܥܝܼ ܝܠܹܗ، ܗܲܪ ܠܹܐ ܫܵܥܫܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","ܗܲܠܔ ܐܝܼܡܲܢ ܒܸܬ ܬܵܪܥܝܼܬܘܿܢ ܥܲܠܔ ܐܢܵܫܵܐ؟ ܟܠܵܘܟ݂ܘܿܢ ܒܵܥܹܝܬܘܿܢ ܠܸܩܛܵܠܵܐ ܐܸܠܹܗ، ܐܲܝܟ݂ ܓܘܼܕܵܐ ܓܸܢܝܵܐ، ܣܝܵܓ݂ܵܐ ܚܘܼܪܙܸܦܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","ܐܲܚܟ̰ܝܼ ܥܒ݂ܝܼܕ ܠܗܘܿܢ ܡܸܠܟܵܐ ܠܸܛܪܵܕܹܗ ܡ̣ܢ ܪܵܡܘܼܬܹܗ، ܟܹܐ ܒܵܣܡܵܐ ܠܗܘܿܢ ܒܕܘܼܓܠܵܐ، ܒܦܘܼܡܵܝܗ‌ܝ ܟܹܐ ܒܲܪܟ݂ܝܼ، ܐܝܼܢܵܐ ܒܓܵܘܵܝܗ‌ܝ ܟܹܐ ܠܵܝܛܝܼ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","ܐܲܚܟ̰ܝܼ ܠܐܲܠܵܗܵܐ ܒܫܸܬܩܵܐ ܣܦܘܿܪܝ، ܝܵܐ ܓܵܢܝܼ، ܣܵܒܵܒ ܡܸܢܹܗ ܝܠܹܗ ܣܲܒ݂ܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","ܐܲܚܟ̰ܝܼ ܗ̇ܘ ܝܼܠܹܗ ܐܝܼܨܵܪܝܼ ܘܦܘܼܪܩܵܢܝܼ، ܩܲܠܥܝܼ ܝܠܹܗ، ܠܹܐ ܫܵܥܫܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","ܥܲܠܔ ܐܲܠܵܗܵܐ ܝܠܹܗ ܦܘܼܪܩܵܢܝܼ ܘܐܝܼܩܵܪܝܼ، ܗ̇ܘ ܝܼܠܹܗ ܐܝܼܨܵܪܵܐ ܕܥܘܼܫܢܝܼ، ܒܹܝܬ ܓܵܘܣܝܼ ܒܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","ܣܒܘܿܪܘܼܢ ܒܝܼܹܗ ܒܟܠܔ ܙܲܒ݂ܢܵܐ، ܝܵܐ ܥܲܡܵܐ، ܫܲܦܟ݂ܘܼܢ ܩܲܕܡܘܼܗ‌ܝ ܠܸܒܵܘܟ݂ܘܿܢ، ܐܲܠܵܗܵܐ ܒܹܝܬ ܓܵܘܣܵܐ ܝܠܹܗ ܩܵܬܲܢ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","ܫܲܪܝܼܪܵܐܝܼܬ، ܣܪܝܼܩܘܼܬܵ‌ܐ ܝܢܵܐ ܒܢܲܝ̈ ܐܵܕܵܡ، ܕܘܼܓܠܵܐ ܝܢܵܐ ܒܢܲܝ̈ܢܵܫܵܐ، ܥܲܠܔ ܡܲܣܲܐܬܵ‌ܐ ܟܹܐ ܐܵܣܩܝܼ، ܐܵܢܝܼ ܥܲܠܔ ܚܕܵܕܹ̈ܐ ܒܘܼܫ ܩܲܠܘܼ̈ܠܹܐ ܝܢܵܐ ܡ̣ܢ ܢܫܲܡܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","ܠܵܐ ܡܲܬܒ݂ܝܼܬܘܿܢ ܣܲܒ݂ܪܵܐ ܥܲܠܔ ܛܠܘܼܡܝܵܐ، ܘܒܚܛܘܼܦܝܵܐ ܠܵܐ ܗܵܘܝܼ ܠܵܘܟ݂ܘܿܢ ܬܘܼܟ݂ܠܵܢܵܐ ܣܪܝܼܩܵܐ، ܥܘܼܬܪܵܐ ܟܲܕ ܙܵܐܹܕ، ܠܵܐ ܡܲܬܒ݂ܝܼܬܘܿܢ ܠܸܒܵܐ ܥܲܠܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","ܚܕܵܐ ܓܵܗܵܐ ܗܘܼܡܙܸܡ ܠܹܗ ܐܲܠܵܗܵܐ، ܐܲܢܹܐ ܬܲܪܬܹܝ ܫܡܝܼܥ ܠܝܼ، ܕܚܲܝܠܵܐ ܝܼܠܹܗ ܕܐܲܠܵܗܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","ܘܕܝܼܘܼܟ݂ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܵ‌ܐ، ܝܵܐ ܡܵܪܝܵܐ، ܒܗ̇ܝ ܕܐܲܢ݇ܬ ܟܹܐ ܦܵܪܥܹܬ ܠܐܢܵܫܵܐ ܐܲܝܟ݂ ܦܘܼܠܚܵܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","ܝܵܐ ܐܲܠܵܗܵܐ، ܐܲܠܵܗ‌ܝܼ ܝܘܸܬ ܐܲܢ݇ܬ، ܒܸܬ ܛܵܥܹܝܢ ܐܸܠܘܼܟ݂، ܨܗܝܼܬܵ‌ܐ ܝܠܵܗ̇ ܐܸܠܘܼܟ݂ ܓܵܢܝܼ، ܪܲܚܪܘܼܚܹܐ ܝܠܹܗ ܐܸܠܘܼܟ݂ ܢܲܦ̮ܫܝܼ، ܒܐܲܪܥܵܐ ܒܵܪܘܿܙܬܵ‌ܐ ܘܟܟ̰ܝܼܚܬܵ‌ܐ ܒܠܵܐ ܡ̈ܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","ܗܵܕܟ݂ܵܐ ܓܵܘ ܡܲܩܕܫܵܐ ܩܵܡ ܚܵܙܹܢܘܼܟ݂، ܒܸܚܙܵܝܵܐ ܚܲܝܠܘܼܟ݂ ܘܐܝܼܩܵܪܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","ܣܵܒܵܒ ܒܘܼܫ ܨܦܵܝܝܼ ܝܠܵܗ̇ ܛܲܝܒܘܼܬܘܼܟ݂ ܡ̣ܢ ܚܲܝܹ̈ܐ، ܣܸܦܘܵܬ‌ܝܼ̈ ܒܸܬ ܫܲܒܚܝܼ ܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","ܗܵܕܟ݂ܵܐ ܒܸܬ ܒܲܪܟܸܢܘܼܟ݂ ܒܚܲܝܝܼ̈، ܒܫܸܡܘܼܟ݂ ܒܸܬ ܡܲܪܡܸܢ ܐܝܼܕܵܬ‌ܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","ܐܲܝܟ݂ ܒܬܲܪܒܵܐ ܘܒܛܪܝܼܨܘܼܬܵ‌ܐ ܒܸܬ ܣܵܒ݂ܥܵܐ ܓܵܢܝܼ، ܘܒܣܸܦܘܵܬܹ̈‌ܐ ܕܦܨܝܼܚܘܼܬܵ‌ܐ ܒܸܬ ܫܲܒܸܚ ܦܘܼܡܝܼ؛ ");
INSERT INTO aii_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","ܟܲܕ ܕܵܟ݂ܪܹܢܘܼܟ݂ ܥܲܠܔ ܫܘܝܼܬ‌ܝܼ، ܒܒܲܕ̈ܠܹܐ ܒܸܬ ܗܲܓܹܝܢ ܒܘܼܬ ܕܝܼܘܼܟ݂، ");
INSERT INTO aii_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","ܣܵܒܵܒ ܗܘܹܐ ܠܘܼܟ݂ ܗܲܝܲܪܬܵ‌ܐ ܐܸܠܝܼ، ܘܬܚܘܿܬ ܛܸܠܵܢܝܼܬܵ‌ܐ ܕܓܘܼܠܦܵܢܘܼ̈ܟ݂ ܒܸܬ ܫܲܒܚܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","ܬܒܝܼܥ ܠܵܗ̇ ܓܵܢܝܼ ܐܸܠܘܼܟ݂، ܐܸܠܝܼ ܣܢܝܼܕ ܠܵܗ̇ ܝܲܡܝܼܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","ܐܝܼܢܵܐ ܐܵܢܝܼ ܕܟܹܐ ܛܵܥܝܼ ܠܸܛܠܵܩܵܐ ܠܓܵܢܝܼ، ܒܸܬ ܥܵܒ݂ܪܝܼ ܒܬܲܚ̈ܬܵܝܵܬܹ‌ܐ ܕܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","ܒܸܬ ܦܵܝܫܝܼ ܣܘܼܦܝܹܐ ܒܐܝܼܕܵܐ ܕܣܲܝܦܵܐ، ܒܸܬ ܗܵܘܝܼ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ ܕܬܲܥ̈ܠܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","ܐܝܼܢܵܐ ܡܲܠܟܵܐ ܒܸܬ ܦܵܨܹܚ ܒܐܲܠܵܗܵܐ. ܒܸܬ ܥܵܒܹܕ ܫܘܼܒ݂ܗܵܪܵܐ ܟܠܔ ܕܝܵܡܹܐ ܒܝܼܹܗ، ܣܵܒܵܒ ܒܸܬ ܦܵܝܫܝܼ ܐܟ̰ܝܼܡܹܐ ܦܘܼܡܹ̈ܐ ܕܗܲܡܙܸܡܵܢܹ̈ܐ ܕܕܘܼܓܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","ܫܡܹܥ، ܝܵܐ ܐܲܠܵܗܵܐ، ܩܵܠܝܼ ܟܲܕ ܩܵܒ݂ܠܹܢ، ܢܛܘܿܪܘܼܢ ܚܲܝܝܼ̈ ܡ̣ܢ ܙܕܘܼܥܬܵ‌ܐ ܕܕܸܫ̃ܡܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","ܛܲܫܝܼ ܠܝܼ ܡ̣ܢ ܒܘܼܨܵܐ ܕܥܵܒ݂ܕܵܢܹ̈ܐ ܕܒܝܼܫܬܵ‌ܐ، ܡ̣ܢ ܫܓ݂ܘܼܫܝܵܐ ܕܦܵܠܚܵܢܹ̈ܐ ܕܥܵܘܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","ܕܡܘܼܚܪܸܦ ܠܗܘܿܢ ܠܸܫܵܢܵܝܗ‌ܝ ܐܲܝܟ݂ ܣܲܝܦܵܐ، ܡܬܝܼܚ ܠܗܘܿܢ ܗܹܡܸܙܡܵܢ ܡܲܪܝܼܪܬܵ‌ܐ ܐܲܝܟ݂ ܓܹܐܪܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","ܠܪܲܦܘܼܝܹܐ ܡ̣ܢ ܣܸܬܵܪܹ̈ܐ ܥܲܠܔ ܬܲܡܝܼܡܵܐ، ܡܸܢܫܸܠܬܵܢܹܐ ܟܹܐ ܪܲܦܝܼ ܥܲܠܘܼܗ‌ܝ، ܘܠܹܐ ܙܵܕܥܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","ܟܹܐ ܚܲܠܸܢܝܼ ܠܵܗ̇ ܓܵܢܵܝܗ‌ܝ ܒܨܒ݂ܘܼܬܵ‌ܐ ܒܝܼܫܬܵ‌ܐ، ܗܘܼܡܙܸܡ ܠܗܘܿܢ ܒܘܼܬ ܛܲܫܘܼܝܹܐ ܦܲܚܹ̈ܐ؛ ܐܡܝܼܪܗܘܿܢ: ”ܡܵܢܝܼ ܒܸܬ ܚܵܙܹܐ ܠܗܘܿܢ؟“ ");
INSERT INTO aii_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","ܟܹܐ ܬܲܚܡܸܢܝܼ ܥܵܘ̈ܠܹܐ، ܒܹܐܡܵܪܵܐ: ”ܡܛܹܐ ܠܲܢ ܠܬܲܚܡܲܢܬܵ‌ܐ ܨܢܝܼܥܬܵ‌ܐ.“ ܘܓܵܘܵܐ ܕܐܢܵܫܵܐ ܘܠܸܒܹܗ ܥܲܡܘܼܩܹ̈ܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","ܐܝܼܢܵܐ ܐܲܠܵܗܵܐ ܒܸܬ ܕܵܪܹܐ ܓܹܐܪܵܐ ܥܲܠܵܝܗ‌ܝ، ܒܸܬ ܗܵܘܝܼ ܡܲܚܘܵܬܵܝ̈ܗ‌ܝ ܡܸܢܫܸܠܬܵܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","ܒܸܬ ܦܵܝܫܝܼ ܬܘܼܪܩܸܠܹܐ، ܒܠܸܫܵܢܵܐ ܕܓܵܢܵܝܗ‌ܝ ܚܕܝܼܪܵܐ ܠܕܲܠܩܘܼܒ݂ܠܵܝܗ‌ܝ. ܒܸܬ ܡܲܫܥܸܫ ܪܹܝܫܵܐ ܟܠܔ ܕܚܵܙܹܐ ܐܸܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","ܘܒܸܬ ܙܵܕܥܝܼ ܟܠܵܝܗ‌ܝ ܐܢܵܫܹ̈ܐ، ܘܡܲܕܥܝܼ ܦܘܼܠܚܵܢܵܐ ܕܐܲܠܵܗܵܐ، ܘܥܒ݂ܵܕܹܗ ܒܸܬ ܦܲܪܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","ܒܸܬ ܚܵܕܹܐ ܙܲܕܝܼܩܵܐ ܒܡܵܪܝܵܐ ܘܫܵܩܹܠܔ ܓܵܘܣܵܐ ܒܝܼܹܗ، ܘܒܸܬ ܥܵܒ݂ܕܝܼ ܫܘܼܒ݂ܗܵܪܵܐ ܟܠܵܝܗ‌ܝ ܬܪ̈ܘܼܨܹܐ ܕܠܸܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","ܐܸܠܘܼܟ݂ ܒܸܣܦܵܪܵܐ ܝܠܵܗ̇ ܬܸܫܒܘܿܚܬܵ‌ܐ ܒܨܸܗܝܘܿܢ، ܝܵܐ ܐܲܠܵܗܵܐ، ܘܐܸܠܘܼܟ݂ ܒܸܬ ܦܵܐܹܫ ܦܪܝܼܥܵܐ ܢܸܕܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","ܝܵܐ ܫܵܡܥܵܢܵܐ ܕܨܠܘܿܬܵ‌ܐ، ܠܟܸܣܠܘܼܟ݂ ܟܠܔ ܐܢܵܫܵܐ ܒܸܬ ܐܵܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","ܥܵܘ̈ܠܹܐ ܙܘܼܪܒܸܢܗܘܿܢ ܥܲܠܝܼ، ܓܢܵܗܲܢ̈ ܐܲܢ݇ܬ ܟܹܐ ܦܲܚܠܸܬ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","ܛܘܼܒ݂ܵܐ ܠܡ̇ܢ ܕܓܲܒܹܝܬ ܘܩܲܪܒܸܢܸܬ ܠܹܗ ܐܸܠܘܼܟ݂ ܕܫܵܪܹܐ ܒܕܵܪ̈ܵܬܘܼܟ݂. ܒܸܬ ܣܵܒ݂ܥܲܚ ܒܛܵܒ݂ܬܵ‌ܐ ܕܒܲܝܬܘܼܟ݂، ܒܩܲܕܝܼܫܘܼܬܵ‌ܐ ܕܗܲܝܟܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","ܒܣܲܗܡܵܢܘܼܝܵܬܹ̈ܐ ܟܹܐ ܓ̰ܲܘܸܒܸܬ ܠܲܢ ܒܙܲܕܝܼܩܘܼܬܵ‌ܐ، ܝܵܐ ܐܲܠܵܗܵܐ ܕܦܘܼܪܩܵܢܲܢ، ܣܲܒ݂ܪܵܐ ܕܟܠܵܝܗ‌ܝ ܡܲܪ̈ܙܵܢܹܐ ܕܐܲܪܥܵܐ، ܘܝܵܡܵܬܹ̈‌ܐ ܪ̈ܲܚܝܼܩܹܐ، ");
INSERT INTO aii_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","ܡܫܲܬܐܸܣܵܢܵܐ ܕܛܘܼܪܹ̈ܐ ܒܚܲܝܠܹܗ، ܚܠܝܼܨܵܐ ܒܓܲܒܵܪܘܼܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","ܡܲܫܠܝܼܵܢܵܐ ܕܫܓ݂ܘܼܫܝܵܐ ܕܝܵܡܵܬܹ̈‌ܐ، ܫܓ݂ܘܼܫܝܵܐ ܕܠܲܦܵܝ̈ܗ‌ܝ، ܘܚܒ݂ܵܛܵܐ ܕܥܲܡܡܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","ܘܟܹܐ ܙܵܕܥܝܼ ܥܵܡܪ̈ܵܢܹܐ ܕܡܲܪ̈ܙܵܢܹܐ ܕܐܲܪܥܵܐ ܡ̣ܢ ܢܝܼܫܲܢܩܘܼ̈ܟ݂، ܦܠܵܛܵܐ ܕܨܲܦܪܵܐ ܘܕܪܲܡܫܵܐ ܟܹܐ ܥܵܒ݂ܕܹܬ ܫܲܒܚܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","ܣܘܼܚܒܸܪܘܼܟ݂ ܠܐܲܪܥܵܐ ܘܡܘܼܫܬܝܼܵܐ ܠܘܼܟ݂، ܟܹܐ ܥܵܒ݂ܕܹܬ ܠܵܗ̇ ܥܲܬܝܼܪܬܵ‌ܐ ܪܵܒܵܐ. ܫܵܩܝܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ ܡܠܝܼܬܵ‌ܐ ܝܠܵܗ̇ ܡ̈ܝܼܵܐ، ܟܹܐ ܬܲܪܨܸܬ ܕܲܚܠܵܝܗ‌ܝ ܣܵܒܵܒ ܗܵܕܟ݂ܵܐ ܗܘܼܕܪܘܼܗ̇ ܝܘܸܬ. ");
INSERT INTO aii_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","ܟܪ̈ܝܼܒ݂ܘܼܗ̇ ܟܹܐ ܡܲܫܬܹܝܬ ܒܣܒ݂ܵܥܬܵܝܗ‌ܝ، ܟܹܐ ܡܲܫܘܹܝܬ ܝܵܝܘܼ̈ܗ̇. ܒܩܲܫܩܲܫܝܵܬܹ̈‌ܐ ܟܹܐ ܡܲܪܟܸܟܸܬ ܠܵܗ̇، ܡܲܓ̰ܝܲܢܬܘܼܗ̇ ܟܹܐ ܒܲܪܟܸܬ. ");
INSERT INTO aii_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","ܒܘܼܢܦܸܪܘܼܟ݂ ܫܹܢ݇ܬܵ‌ܐ ܒܛܵܒ݂ܬܘܼܟ݂، ܘܐܘܼܪ̈ܚܵܬܘܼܟ݂ ܟܹܐ ܡܲܫܦܸܟ݂ܝܼ ܦܸܪܝܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","ܟܹܐ ܡܲܫܦܸܟ݂ܝܼ ܡܲܪ̈ܥܝܹܐ ܕܒܲܪܝܼܵܐ، ܘܠܒ݂ܝܼܫܹܐ ܝܢܵܐ ܪ̈ܘܼܡܝܵܬܹ‌ܐ ܦܨܵܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","ܙܩܝܼܪܵܐ ܝܢܵܐ ܡܲܪ̈ܓܹܐ ܒܦܸܣܩܵܐ، ܘܓܲܠܝܼܹ̈ܐ ܟܘܼܣܝܹܐ ܝܢܵܐ ܒܕܲܚܠܵܐ، ܟܹܐ ܩܲܘܸܚܝܼ، ܐܘܼܦ ܟܹܐ ܙܵܡܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","ܩܲܘܸܚܘܼܢ ܠܐܲܠܵܗܵܐ ܟܠܵܗ̇ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","ܙܡܘܿܪܘܼܢ ܠܐܝܼܩܵܪܵܐ ܕܫܸܡܹܗ، ܡܲܬܒ݂ܘܼܢ ܐܝܼܩܵܪܵܐ ܠܬܸܫܒܘܿܚܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","ܐܡܘܿܪܘܼܢ ܠܐܲܠܵܗܵܐ: ”ܟܡܵܐ ܣܲܗܡܵܢܹ̈ܐ ܝܢܵܐ ܦܘܼܠܚܵܢܘܼ̈ܟ݂، ܡܥܸܠܬܵ‌ܐ ܕܓܘܼܪܘܼܬܵ‌ܐ ܕܥܘܼܫܢܘܼܟ݂ ܒܸܬ ܫܵܠܡܝܼ ܐܸܠܘܼܟ݂ ܕܸܫ̃ܡܸܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","”ܟܠܵܗ̇ ܒܢܲܝ̈ ܐܲܪܥܵܐ ܒܸܬ ܣܵܓ݂ܕܝܼ ܐܸܠܘܼܟ݂، ܘܒܸܬ ܙܵܡܪܝܼ ܐܸܠܘܼܟ݂، ܒܸܬ ܙܵܡܪܝܼ ܠܫܸܡܘܼܟ݂.“ ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","ܬܹܝܡܘܼܢ ܘܚܙܹܝܡܘܼܢ ܦܘܼܠܚܵܢܹ̈ܐ ܕܐܲܠܵܗܵܐ، ܣܲܗܡܵܢܹ̈ܐ ܝܢܵܐ ܦܘܼܠܚܵܢܘܼ̈ܗ‌ܝ ܒܓܵܘܵܐ ܕܒܢܲܝ̈ܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","ܡܘܼܚܕܸܪܹܗ ܝܵܡܵܐ ܠܒܸܪܙܵܐ، ܡܓܵܘ ܢܲܗܪܵܐ ܥܒ݂ܝܼܪܗܘܿܢ ܒܐܲܩܠܵܐ، ܫܒ݂ܘܿܩ ܚܵܕܲܚ ܒܝܼܹܗ ܬܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","ܫܲܠܛܵܢܵܐ ܝܠܹܗ ܒܓܲܒܵܪܘܼܬܹܗ ܠܥܵܠܲܡ، ܥܲܝܢܘܼ̈ܗ‌ܝ ܠܐܸܡܘܵܬܹ̈‌ܐ ܟܹܐ ܩܲܙܸܕܝܼ، ܡܵܪ̈ܘܿܕܹܐ ܠܵܐ ܡܲܪܡܝܼ ܓܵܢܵܝܗ‌ܝ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","ܒܲܪܟ݂ܘܼܢ، ܝܵܐ ܥܲܡܡܹ̈ܐ، ܠܐܲܠܵܗܲܢ، ܘܡܲܫܡܸܥܡܘܼܢ ܩܵܠܵܐ ܕܬܸܫܒܘܿܚܬܹܗ، ");
INSERT INTO aii_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","ܗ̇ܘ ܕܚܘܼܡܹܐ ܠܹܗ ܓܵܢܲܢ ܒܚܲܝܹ̈ܐ، ܘܠܵܐ ܫܒ݂ܝܼܩ ܠܹܗ ܕܫܵܥܫܵܐ ܐܲܩܠܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","ܒܗ̇ܝ ܕܩܵܡ ܒܵܚܪܹܬ ܠܲܢ، ܝܵܐ ܐܲܠܵܗܵܐ، ܩܵܡ ܨܲܪܸܦܸܬ ܠܲܢ ܐܲܝܟ݂ ܨܲܪܲܦܬܵ‌ܐ ܕܣܹܐܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","ܩܵܡ ܡܲܥܒܸܪܸܬ ܠܲܢ ܓܵܘ ܓܲܪܕܵܐ، ܡܘܼܬܸܒ݂ ܠܘܼܟ݂ ܟܵܪܬܵ‌ܐ ܥܲܠܔ ܚܵܨܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","ܡܘܼܪܟܸܒ݂ ܠܘܼܟ݂ ܒܲܪܢܵܫܵܐ ܒܪܹܝܫܲܢ، ܥܒ݂ܝܼܪܲܢ ܒܢܘܼܪܵܐ ܘܒܡ̈ܝܼܵܐ، ܐܝܼܢܵܐ ܩܵܡ ܦܲܠܛܸܬ ܠܲܢ ܠܕܘܼܟܬܵ‌ܐ ܕܦܸܪܝܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","ܒܸܬ ܥܵܒ݂ܪܹܢ ܠܒܲܝܬܘܼܟ݂ ܒܕܸܒ݂ܚܹ̈ܐ ܡܘܼܩܕܹ̈ܐ، ܒܸܬ ܬܲܡܸܡܸܢ ܐܸܠܘܼܟ݂ ܢܸܕܪ̈ܝܼ؛ ");
INSERT INTO aii_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","ܐܲܝܢܝܼ ܕܗܘܼܡܙܸܡ ܠܗܘܿܢ ܣܸܦܘܵܬ‌ܝܼ̈، ܘܦܠܝܼܛ ܠܗܘܿܢ ܡ̣ܢ ܦܘܼܡܝܼ ܟܲܕ ܒܥܵܘܩܵܢܵܐ ܝܘܸܢ ܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","ܕܸܒ݂ܚܹ̈ܐ ܡܘܼܩܕܹ̈ܐ ܕܛܪ̈ܝܼܨܹܐ ܒܸܬ ܡܲܐܣܩܸܢ ܐܸܠܘܼܟ݂، ܥܲܡ ܒܸܣܡܵܐ ܕܒܲܪ̈ܥܵܢܹܐ، ܒܸܬ ܥܵܒ݂ܕܹܢ ܕܸܒ݂ܚܹ̈ܐ ܕܬܵܘܪܹ̈ܐ ܥܲܡ ܓܸܕܝܹ̈ܐ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","ܬܹܝܡܘܼܢ ܫܡܹܥܡܘܼܢ ܟܠܵܝܗ‌ܝ ܙܕܝܼ̈ܥܹܐ ܕܐܲܠܵܗܵܐ، ܘܒܸܬ ܗܲܩܹܝܢ ܡܸܢܕܝܼ ܕܥܒ݂ܝܼܕ ܠܹܗ ܩܵܐ ܓܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","ܐܸܠܹܗ ܒܦܘܼܡܝܼ ܩܪܹܐ ܠܝܼ، ܘܦܝܼܫ ܠܹܗ ܡܘܼܪܡܵܐ ܒܠܸܫܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","ܐܸܢ ܢܵܛܪܹܢ ܗܘܵܐ ܥܵܘܠܵܐ ܒܠܸܒܝܼ، ܠܹܐ ܫܵܡܹܥ ܗܘܵܐ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","ܐܝܼܢܵܐ ܒܫܪܵܪܵܐ، ܫܡܝܼܥ ܠܹܗ ܐܲܠܵܗܵܐ، ܡܘܼܨܝܸܬ ܠܹܗ ܠܩܵܠܵܐ ܕܨܠܘܿܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","ܒܪܝܼܟ݂ܵܐ ܝܠܹܗ ܐܲܠܵܗܵܐ، ܕܠܵܐ ܡܘܼܕܸܪܹܗ ܨܠܘܿܬ‌ܝܼ، ܐܵܦܠܵܐ ܡܘܼܥܒܸܪܹܗ ܛܲܝܒܘܼܬܹܗ ܡܸܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","ܐܲܠܵܗܵܐ ܗܵܘܹܐ ܚܲܢܵܢܵܐ ܐܸܠܲܢ ܘܒܲܪܸܟ݂ ܠܲܢ، ܒܲܗܪܸܢ ܦܵܬܹܗ ܠܟܸܣܠܲܢ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","ܫܒ݂ܘܿܩ ܦܵܝܫܵܐ ܝܕܝܼܥܬܵ‌ܐ ܒܐܲܪܥܵܐ ܐܘܼܪܚܘܼܟ݂، ܒܟܠܵܝܗ‌ܝ ܐܸܡܘܵܬܹ̈‌ܐ ܦܘܼܪܩܵܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","ܫܲܟܪܝܼ ܠܘܼܟ݂ ܥܲܡܡܹ̈ܐ، ܝܵܐ ܐܲܠܵܗܵܐ، ܫܲܟܪܝܼ ܠܘܼܟ݂ ܟܠܵܝܗ‌ܝ ܥܲܡܡܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","ܚܵܕܝܼ ܘܫܲܒܚܝܼ ܐܸܡܘܵܬܹ̈‌ܐ، ܣܵܒܵܒ ܟܹܐ ܕܵܝܢܹܬ ܥܲܡܡܹ̈ܐ ܒܬܪܘܼܨܘܼܬܵ‌ܐ، ܘܐܸܡܘܵܬܹ̈‌ܐ ܒܐܲܪܥܵܐ ܟܹܐ ܡܕܲܒܪܸܬ ܠܗܘܿܢ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","ܫܲܟܪܝܼ ܠܘܼܟ݂ ܥܲܡܡܹ̈ܐ، ܝܵܐ ܐܲܠܵܗܵܐ، ܫܲܟܪܝܼ ܠܘܼܟ݂ ܟܠܵܝܗ‌ܝ ܥܲܡܡܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","ܐܲܪܥܵܐ ܝܘܼܗܒܹܠܔ ܠܵܗ̇ ܛܥܘܼܢܬܘܼܗ̇، ܟܹܐ ܒܲܪܸܟ݂ ܠܲܢ، ܐܲܠܵܗܵܐ، ܐܲܠܵܗܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","ܟܹܐ ܒܲܪܸܟ݂ ܠܲܢ ܐܲܠܵܗܵܐ، ܘܟܹܐ ܙܵܕܥܝܼ ܡܸܢܹܗ ܟܠܵܝܗ‌ܝ ܡܲܪ̈ܙܵܢܹܐ ܕܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","ܟܹܐ ܩܵܐܹܡ ܐܲܠܵܗܵܐ، ܟܹܐ ܒܲܪܒܸܙܝܼ ܕܸܫ̃ܡܸܢܘܼ̈ܗ‌ܝ، ܘܥܵܪܩܝܼ ܣܵܢܝܵܢܘܼ̈ܗ‌ܝ ܡ̣ܢ ܩܲܕܡܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","ܐܲܝܟ݂ ܕܦܵܐܹܫ ܒܘܼܪܒܸܙܵܐ ܬܸܢܵܐ ܒܲܪܒܸܙܸܬ ܠܗܘܿܢ، ܐܲܝܟ݂ ܕܦܵܫܪܵܐ ܫܲܡܲܥ ܡ̣ܢ ܩܲܕܡ ܢܘܼܪܵܐ، ܛܵܠܩܝܼ ܪ̈ܲܫܝܼܥܹܐ ܡ̣ܢ ܩܲܕܡ ܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","ܐܝܼܢܵܐ ܙܲܕܝܼܩܹ̈ܐ ܚܵܕܝܼ ܘܦܵܨܚܝܼ ܩܲܕܡ ܐܲܠܵܗܵܐ، ܘܗܵܘܝܼ ܦܨܝܼܚܹܐ ܒܚܲܕܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","ܫܲܒܚܘܼܢ ܠܐܲܠܵܗܵܐ، ܙܡܘܿܪܘܼܢ ܫܸܡܹܗ، ܡܲܪܡܘܼܢ ܠܪܲܟܵܒ݂ܵܐ ܒܕܸܫܝܵܬܹ̈‌ܐ، ܡܵܪܝܵܐ ܝܠܹܗ ܫܸܡܹܗ، ܘܦܨܘܿܚܘܼܢ ܩܲܕܡܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","ܒܵܒܵܐ ܕܝܲܬܘܼܡܹ̈ܐ ܘܥܵܒ݂ܕܵܢܵܐ ܕܕܝܼܘܵܢ ܕܐܲܪ̈ܡܸܠܝܵܬܹ‌ܐ، ܐܲܠܵܗܵܐ ܒܡܲܥܡܪܵܐ ܕܩܘܼܕܫܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","ܐܲܠܵܗܵܐ ܟܹܐ ܡܲܬܸܒ݂ ܒܒܲܝܬܵ‌ܐ ܠܐܵܢܝܼ ܕܝܼܢܵܐ ܒܢܲܦ̮ܫܵܝܗ‌ܝ، ܟܹܐ ܦܲܠܸܛ ܐܲܣܝܼܪܹ̈ܐ ܠܟܲܫܝܼܪܘܼܬܵ‌ܐ، ܐܝܼܢܵܐ ܡܵܪ̈ܘܿܕܹܐ ܟܹܐ ܥܵܡܪܝܼ ܒܐܲܪܥܵܐ ܨܗܝܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","ܝܵܐ ܐܲܠܵܗܵܐ، ܟܲܕ ܦܠܝܼܛ ܠܘܼܟ݂ ܩܲܕܡ ܥܲܡܘܼܟ݂، ܒܦܣܵܥܬܘܼܟ݂ ܓܵܘ ܒܲܪܝܼܵܐ، ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","ܐܲܪܥܵܐ ܫܥܝܼܫ ܠܵܗ̇، ܐܘܼܦ ܫܡܲܝܹ̈ܐ ܡܘܼܢܛܸܦ ܠܗܘܿܢ ܡܸܛܪܵܐ ܩܲܕܡ ܐܲܠܵܗܵܐ، ܐܲܠܵܗܵܐ ܕܐܵܗܵܐ ܣܝܼܢܲܝ؛ ܡ̣ܢ ܩܲܕܡ ܐܲܠܵܗܵܐ، ܐܲܠܵܗܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","ܡܸܛܪܵܐ ܕܨܸܒ݂ܝܵܢܵܐ ܡܘܼܫܦܸܟ݂ ܠܘܼܟ݂، ܝܵܐ ܐܲܠܵܗܵܐ، ܠܝܵܪܬܘܼܬܘܼܟ݂ ܟܲܕ ܢܘܝܼܠܔ ܠܵܗ̇ ܐܲܢ݇ܬ ܬܘܼܪܣܝܼܵܐ ܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","ܦܸܣܩܘܼܟ݂ ܝܬܝܼܒ݂ ܠܗܘܿܢ ܓܵܘܘܼܗ̇، ܬܘܼܪܣܹܐ ܠܘܼܟ݂ ܒܛܲܝܒܘܼܬܘܼܟ݂ ܠܡܸܣܟܹܢܹ̈ܐ، ܝܵܐ ܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","ܡܵܪܝܵܐ ܟܹܐ ܝܵܗܒܹܠܔ ܦܘܼܩܕܵܢܵܐ، ܘܒܲܟ݂ܬܵܬܹ̈‌ܐ ܕܡܲܫܚܸܕܝܼ ܠܹܗ ܚܲܝܠܵܐ ܓܘܼܪܵܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","ܡܲܠܟܹ̈ܐ ܕܚܲܝܠܵܘܵܬܹ̈‌ܐ ܟܹܐ ܥܵܪܩܝܼ، ܟܹܐ ܥܵܪܩܝܼ، ܘܥܵܡܪܵܢܬܵ‌ܐ ܕܒܲܝܬܵ‌ܐ ܟܹܐ ܦܲܠܥܵܐ ܣܠܵܒܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","ܐܵܦܸܢ ܕܕܵܡܟ݂ܝܼܬܘܿܢ ܒܓܵܘܵܐ ܕܓܘܼܡܵܢܹ̈ܐ، ܓܘܼܠܦܵܢܹ̈ܐ ܕܝܵܘܢܵܐ ܩܪܝܼܡܹܐ ܝܢܵܐ ܒܣܹܐܡܵܐ، ܘܦܲܪ̈ܘܼܗ̇ ܒܕܲܗܒ݂ܵܐ ܡܲܙܪܘܼܟ̰ܹܐ ܩܝܼܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","ܟܲܕ ܒܘܼܪܒܸܙ ܠܹܗ ܐܹܝܠܔ ܫܲܕܲܝ ܡܲܠܟܹ̈ܐ ܓܵܘܘܼܗ̇، ܒܸܥܪܵܝܵܐ ܝܗܘܵܐ ܬܲܠܓܵܐ ܓܵܘ ܨܲܠܡܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","ܛܘܼܪܵܐ ܕܐܲܠܵܗܵܐ ܛܘܼܪܵܐ ܕܒܲܝܫܵܢ ܝܼܠܹܗ، ܛܘܼܪܵܐ ܡܵܪܹܐ ܩܲܪ̈ܩܲܦܝܵܬܹ‌ܐ ܝܠܹܗ ܛܘܼܪܵܐ ܕܒܲܝܫܵܢ. ");
INSERT INTO aii_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","ܝܵܐ ܛܘܼܪ̈ܵܢܹܐ ܡܵܪܹܐ ܩܲܪ̈ܩܲܦܝܵܬܹ‌ܐ، ܩܵܡܘܿܕܝܼ ܚܵܝܪܝܼܬܘܿܢ ܒܥܲܝܢܵܐ ܕܒܲܚܲܠܬܵ‌ܐ ܠܛܘܼܪܵܐ ܕܒܣܝܼܡ ܠܵܗ̇ ܠܹܗ ܐܲܠܵܗܵܐ ܠܸܬܝܵܒ݂ܵܐ ܓܵܘܹܗ، ܐܘܼܦ ܠܥܵܠܲܡ ܡܵܪܝܵܐ ܒܸܬ ܫܵܪܹܐ ܓܵܘܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","ܡܲܪ̈ܟܒ݂ܵܬܹ‌ܐ ܕܐܲܠܵܗܵܐ ܬܲܪܬܹܝ ܪܸ̈ܒܘܵܬܹ‌ܐ ܝܢܵܐ، ܐܲܠܦܹ̈ܐ ܥܲܠܔ ܐܲܠܦܹ̈ܐ، ܡܵܪܝܵܐ ܕܣܝܼܢܲܝ ܒܓܵܘܵܝܗ‌ܝ ܝܠܹܗ ܒܩܲܕܝܼܫܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","ܐܣܝܼܩ ܠܘܼܟ݂ ܠܡܪܵܘܡܵܐ، ܠܘܼܒܸܠܔ ܠܘܼܟ݂ ܐܲܣܝܼܪܹ̈ܐ ܠܐܲܣܝܼܪܘܼܬܵ‌ܐ، ܫܩܝܼܠܔ ܠܘܼܟ݂ ܡܵܘܗܒ݂ܵܬܹ̈‌ܐ ܡ̣ܢ ܒܢܲܝ̈ܢܵܫܵܐ، ܘܐܘܼܦ ܡ̣ܢ ܡܵܪ̈ܘܿܕܹܐ، ܕܫܵܪܹܐ ܡܵܪܝܵܐ ܐܲܠܵܗܵܐ ܬܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","ܒܪܝܼܟ݂ܵܐ ܝܠܹܗ ܡܵܪܝܵܐ، ܝܵܘܡܵܐ ܒܝܵܘܡܵܐ ܟܹܐ ܛܵܥܹܢ ܝܘܼܩܪܲܢ، ܐܲܠܵܗܵܐ ܕܦܘܼܪܩܵܢܲܢ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","ܐܲܠܵܗܵܐ ܐܸܠܲܢ ܐܲܠܵܗܵܐ ܕܦܘܼܪ̈ܩܵܢܹܐ ܝܠܹܗ، ܘܕܐܲܠܵܗܵܐ ܡܵܪܝܵܐ ܝܢܵܐ ܦܠܵܛܹ̈ܐ ܡ̣ܢ ܡܵܘܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","ܒܫܪܵܪܵܐ ܐܲܠܵܗܵܐ ܒܸܬ ܒܵܠܹܣ ܪܹܝܫܵܐ ܕܕܸܫ̃ܡܸܢܘܼ̈ܗ‌ܝ، ܩܲܪܩܲܦܬܵ‌ܐ ܡܸܙܬܵܢܬܵ‌ܐ ܕܚܵܕܪܵܢܵܐ ܒܓܢܵܗܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","ܐܡܝܼܪܹܗ ܡܵܪܝܵܐ: ”ܡ̣ܢ ܒܲܝܫܵܢ ܒܸܬ ܡܲܕܸܪܸܢܗܘܿܢ، ܒܸܬ ܡܲܕܸܪܸܢܗܘܿܢ ܡ̣ܢ ܥܘܼܡܩܹ̈ܐ ܕܝܵܡܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","”ܩܵܐ ܕܒܵܠܣܵܐ ܠܗܘܿܢ ܐܲܩܠܘܼܟ݂ ܒܕܸܡܵܐ، ܘܠܸܫܵܢܹ̈ܐ ܕܟܲܠܒܘܼ̈ܟ݂ ܩܲܒܠܝܼ ܣܵܗܡܵܝܗ‌ܝ ܡ̣ܢ ܕܸܫ̃ܡܸܢܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","ܚܙܹܐ ܠܗܘܿܢ ܙܘܼܝܵܚܘܼ̈ܟ݂، ܝܵܐ ܐܲܠܵܗܵܐ، ܙܘܼܝܵܚܹ̈ܐ ܕܐܲܠܵܗ‌ܝܼ ܡܲܠܟܝܼ ܒܒܹܝܬ ܩܘܼܕܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","ܩܘܼܕܸܡ ܠܗܘܿܢ ܙܲܡܵܪܹ̈ܐ، ܒܵܬܪܵܝܗ‌ܝ ܡܵܚܝܵܢܹ̈ܐ ܕܩܝܼܬܵܪܹ̈ܐ، ܒܓܵܘܵܐ ܕܥܠܲܝܡܵܬܹ̈‌ܐ ܡܵܚܝܵܢܹ̈ܐ ܕܦܠܲܓܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","ܓܵܘ ܟܢܘܼܫܝܹ̈ܐ ܒܲܪܟ݂ܘܼܢ ܠܐܲܠܵܗܵܐ، ܒܲܪܟ݂ܘܼܢ ܠܡܵܪܝܵܐ، ܐܲܚܬܘܿܢ ܕܡ̣ܢ ܡܲܒܘܼܥܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","ܬܵܡܵܐ ܝܠܹܗ ܒܸܢܝܵܡܹܝܢ ܙܥܘܿܪܵܐ، ܫܲܠܝܼܛܵܝܗ‌ܝ، ܓܘܼܪ̈ܵܢܹܐ ܕܝܼܗܘܼܕܵܐ ܒܟܸܢܫܵܝ̈ܗ‌ܝ، ܓܘܼܪ̈ܵܢܹܐ ܕܙܒ݂ܘܿܠܘܿܢ ܘܓܘܼܪ̈ܵܢܹܐ ܕܢܲܦ̮ܬܵܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","ܦܩܘܿܕ، ܝܵܐ ܐܲܠܵܗܵܐ، ܥܘܼܫܢܘܼܟ݂، ܚܲܠܸܢ، ܝܵܐ ܐܲܠܵܗܵܐ، ܡܸܢܕܝܼ ܕܦܠܝܼܚ ܠܘܼܟ݂ ܐܸܠܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","ܡ̣ܢ ܗܲܝܟܠܘܼܟ݂ ܒܐܘܿܪܸܫܠܸܡ، ܡܲܠܟܹ̈ܐ ܒܸܬ ܡܲܝܬ‌ܝܼ ܠܘܼܟ݂ ܕܲܫܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","ܢܓ̰ܘܿܘ ܒܗܲܝܘܵܢ ܕܙܹܠܵܐ، ܒܓ̰ܵܡܵܥܲܬ ܕܬܵܘܪܹ̈ܐ ܥܲܡ ܡܘܼܓ̰ܹ̈ܐ ܕܥܲܡܡܹ̈ܐ، ܡܲܟܘܼܦܹܐ ܓܵܢܵܝܗ‌ܝ ܘܡܲܩܪܘܼܒܹܐ ܩܸܛܥܵܛܹ̈ܐ ܕܣܹܐܡܵܐ، ܒܲܪܒܸܙ ܥܲܡܡܹ̈ܐ ܕܟܹܐ ܒܵܣܡܵܐ ܠܗܘܿܢ ܒܦܠܵܫܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","ܒܸܬ ܐܵܬ‌ܝܼ ܐܝܼܙܓܲܕܹ̈ܐ ܡ̣ܢ ܡܸܨܪܹܝܢ، ܟܘܼܫ ܒܸܬ ܦܲܫܛܵܐ ܐܝܼܕܵܬܘܼ̈ܗ̇ ܠܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","ܝܵܐ ܡܲܠܟܘܵܬܹ̈‌ܐ ܕܐܲܪܥܵܐ، ܫܲܒܚܘܼܢ ܠܐܲܠܵܗܵܐ، ܙܡܘܿܪܘܼܢ ܠܡܵܪܝܵܐ، ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","ܠܪܵܟܒ݂ܵܢܵܐ ܕܥܲܠܔ ܫܡܲܝ̈ ܫܡܲܝܹ̈ܐ ܩܲܕܝܼܡܵܝܹ̈ܐ، ܗܵܐ، ܪܲܦܘܼܝܹܗ ܩܵܠܹܗ، ܩܵܠܵܐ ܙܲܪܒܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","ܗܲܒ݂ܠܘܼܢ ܥܘܼܫܢܵܐ ܠܐܲܠܵܗܵܐ، ܥܲܠܔ ܐܝܼܣܪܵܐܹܝܠܔ ܝܠܵܗ̇ ܪܵܡܘܼܬܹܗ، ܘܚܲܝܠܹܗ ܒܪܩܝܼܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","ܣܲܗܡܵܢܵܐ ܝܘܸܬ، ܝܵܐ ܐܲܠܵܗܵܐ، ܡ̣ܢ ܡܲܩܕܫܘܼܟ݂، ܐܲܠܵܗܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ ܗ̇ܘ ܟܹܐ ܝܵܗܒܹܠܔ ܥܘܼܫܢܵܐ ܘܚܲܝܠܵܐ ܠܥܲܡܵܐ، ܒܪܝܼܟ݂ܵܐ ܝܠܹܗ ܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","ܦܲܪܸܩ ܠܝܼ، ܝܵܐ ܐܲܠܵܗܵܐ، ܣܵܒܵܒ ܡܛܹܐ ܠܗܘܿܢ ܡ̈ܝܼܵܐ ܗܲܠܔ ܓܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","ܛܒܝܼܥ ܠܝܼ ܓܵܘ ܛܝܼܢܵܐ ܥܲܡܘܼܩܵܐ ܘܠܲܝܬ ܕܘܼܟܬܵ‌ܐ ܕܟܠܵܝܬܵ‌ܐ، ܥܒ݂ܝܼܪܝܼ ܒܥܘܼܡܩܹ̈ܐ ܕܡ̈ܝܼܵܐ ܘܛܵܘܦܵܢܵܐ ܩܵܡ ܟܲܪܦܸܫ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","ܟܟ̰ܝܼܚ ܠܝܼ ܒܩܪܵܝܬ‌ܝܼ، ܚܪܝܼܟ݂ ܠܵܗ̇ ܒܵܠܘܿܥܬ‌ܝܼ، ܚܒܹܐ ܠܗܘܿܢ ܥܲܝܢܝܼ̈ ܒܸܣܦܵܪܵܐ ܠܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","ܒܘܼܫ ܪܵܒܵܐ ܝܢܵܐ ܡ̣ܢ ܡܸܙܝܵܬܹ̈‌ܐ ܕܪܹܝܫܝܼ ܣܵܢܝܵܢܝܼ̈ ܕܠܵܐ ܥܸܠܬܵ‌ܐ، ܙܘܼܪܒܸܢܗܘܿܢ ܛܲܠܩܵܢܝܼ̈، ܕܸܫ̃ܡܸܢܝܼ̈ ܕܒܕܘܼܓܠܵܐ، ܡܘܼܕܸܪܝܼ ܡܸܢܕܝܼ ܕܠܹܐ ܝܘܸܢ ܗܘܵܐ ܟ̰ܠܝܼܓ̰ܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","ܝܵܐ ܐܲܠܵܗܵܐ، ܐܲܢ݇ܬ ܟܹܐ ܝܵܕܥܹܬ ܣܲܟ݂ܠܘܼܬ‌ܝܼ، ܘܓܢܵܗ‌ܝܼ̈ ܡܸܢܘܼܟ݂ ܠܹܐ ܝܢܵܐ ܛܸܫܝܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","ܠܵܐ ܢܵܟ݂ܦܝܼ ܒܘܼܬ ܕܝܼܝܼ ܣܵܒܪ̈ܵܢܹܐ ܐܸܠܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ ܐܲܠܵܗܵܐ ܚܲܝܠܬܵܢܵܐ؛ ܠܵܐ ܦܵܝܫܝܼ ܢܟ݂ܝܼܦܹܐ ܒܘܼܬ ܕܝܼܝܼ ܛܵܥܝܵܢܹ̈ܐ ܕܐܸܠܘܼܟ݂، ܝܵܐ ܐܲܠܵܗܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","ܣܵܒܵܒ ܒܘܼܬ ܕܝܼܘܼܟ݂ ܩܘܼܒܸܠܔ ܠܝܼ ܠܵܘܡܵܐ، ܟܘܼܣܹܐ ܠܵܗ̇ ܢܟܸܦܬܵ‌ܐ ܠܦܵܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","ܩܵܪܝܼܒܵܝܵܐ ܗܘܹܐ ܠܝܼ ܠܐܲܚܘܿܢܘܵܬ‌ܝܼ̈، ܘܢܘܼܟ݂ܪܵܝܵܐ ܠܒܢܘܿܢܹ̈ܐ ܕܝܸܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","ܣܵܒܵܒ ܛܢܵܢܵܐ ܕܒܲܝܬܘܼܟ݂ ܩܵܡ ܐܵܟܹܠܔ ܠܝܼ، ܘܠܵܘܡܹ̈ܐ ܕܠܵܝܡܵܢܘܼ̈ܟ݂ ܢܦܝܼܠܔ ܠܗܘܿܢ ܥܲܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","ܘܒܟܹܐ ܠܝܼ ܓܵܘ ܓܵܢܝܼ ܒܨܵܘܡܵܐ، ܘܗܘܹܐ ܠܹܗ ܠܠܵܘܡܵܐ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","ܘܥܒ݂ܝܼܕ ܠܝܼ ܠܒ݂ܝܼܫܬ‌ܝܼ ܣܲܩܵܐ، ܘܗܘܹܐ ܠܝܼ ܐܸܠܵܝܗ‌ܝ ܠܡܲܬܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","ܟܹܐ ܗܲܡܙܸܡܝܼ ܒܘܼܬ ܕܝܼܝܼ ܝܵܬܒ݂ܵܢܹ̈ܐ ܒܕܲܪܘܵܙܵܐ، ܘܗܘܹܐ ܠܝܼ ܙܡܵܪ̈ܝܵܬܹ‌ܐ ܠܫܵܬܝܵܢܹ̈ܐ ܕܫܲܟ݂ܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","ܐܝܼܢܵܐ ܐܵܢܵܐ، ܨܠܘܿܬ‌ܝܼ ܐܸܠܘܼܟ݂ ܝܠܵܗ̇، ܝܵܐ ܡܵܪܝܵܐ، ܒܙܲܒ݂ܢܵܐ ܡܩܲܒܠܵܐ، ܝܵܐ ܐܲܠܵܗܵܐ، ܒܦܸܪܝܘܼܬܵ‌ܐ ܕܛܲܝܒܘܼܬܘܼܟ݂، ܓ̰ܲܘܸܒ ܠܝܼ ܒܫܲܪܝܼܪܘܼܬܵ‌ܐ ܕܦܘܼܪܩܵܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","ܦܲܨܝܼ ܠܝܼ ܡ̣ܢ ܛܝܼܢܵܐ ܕܠܵܐ ܛܵܒܥܹܢ، ܦܵܝܫܹܢ ܦܘܼܨܝܵܐ ܡ̣ܢ ܣܵܢܝܵܢܝܼ̈، ܘܡ̣ܢ ܥܘܼܡܩܵܐ ܕܡ̈ܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","ܠܵܐ ܟܲܪܦܸܫ ܠܝܼ ܛܵܘܦܵܢܵܐ ܕܡ̈ܝܼܵܐ، ܘܠܵܐ ܒܵܠܹܥ ܐܸܠܝܼ ܥܘܼܡܩܵܐ، ܘܠܵܐ ܐܵܟ̰ܹܡ ܥܲܠܝܼ ܒܹܐܪܵܐ ܦܘܼܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","ܓ̰ܲܘܸܒ ܠܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܒܗ̇ܝ ܕܨܦܵܝܝܼ ܝܠܵܗ̇ ܛܲܝܒܘܼܬܘܼܟ݂، ܐܲܝܟ݂ ܦܸܪܝܘܼܬܵ‌ܐ ܕܪ̈ܲܚܡܘܼܟ݂ ܕܘܼܪ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","ܘܠܵܐ ܛܲܫܹܝܬ ܦܵܬܘܼܟ݂ ܡ̣ܢ ܪܹܓܘܼܟ݂، ܣܵܒܵܒ ܥܝܼܩ ܠܵܗ̇ ܐܸܠܝܼ؛ ܡܲܠܝܸܙ ܓ̰ܲܘܸܒ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","ܩܲܪܒܸܢ ܠܓܵܢܝܼ، ܦܲܨܝܼ ܠܵܗ̇، ܡ̣ܢ ܕܸܫ̃ܡܸܢܝܼ̈ ܦܲܪܸܩ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","ܐܲܢ݇ܬ ܟܹܐ ܝܵܕܥܹܬ ܠܵܘܡܝܼ، ܘܢܟܸܦܬ‌ܝܼ، ܘܡܲܣܠܲܝܬ‌ܝܼ، ܩܲܕܡܘܼܟ݂ ܝܼܢܵܐ ܟܠܵܝܗ‌ܝ ܡܲܠܝܸܨܵܢܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","ܠܵܘܡܵܐ ܬܒ݂ܝܼܪܹܗ ܠܸܒܝܼ ܘܩܵܡ ܡܲܡܪܸܥ ܠܝܼ. ܣܦܝܼܪܝܼ ܠܚܲܕ ܕܡܲܩܸܕ ܠܸܒܵܐ ܥܲܠܝܼ، ܐܝܼܢܵܐ ܠܲܝܬ، ܘܠܝܵܗܒ݂ܵܢܹ̈ܐ ܕܠܸܒܵܐ، ܐܝܼܢܵܐ ܠܵܐ ܡܘܼܫ݇ܟ̰ܸܚ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","ܘܝܘܼܗܒܹܠܔ ܠܗܘܿܢ ܡܪܵܪܹ̈ܐ ܩܵܐ ܐܟ݂ܵܠܬ‌ܝܼ، ܘܩܵܐ ܨܲܗܘܝܼ ܩܵܡ ܡܲܫܬ‌ܝܼ ܠܝܼ ܚܲܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","ܗܵܘܹܐ ܦܵܬܘܿܪܵܝܗ‌ܝ ܠܦܲܚܵܐ ܩܲܕܡܵܝܗ‌ܝ، ܘܗܵܘܹܐ ܫܠܵܡܵܝܗ‌ܝ ܠܩܘܼܠܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","ܚܵܒ݂ܝܼ ܥܲܝ̈ܢܵܝܗ‌ܝ ܡ̣ܢ ܠܸܚܙܵܝܵܐ، ܘܐܲܡܝܼܢܵܐܝܼܬ ܪܵܓܹܕ ܚܲܨܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","ܡܲܫܦܸܟ݂ ܟܲܪܒܘܼܟ݂ ܥܲܠܵܝܗ‌ܝ، ܘܚܸܡܬܵ‌ܐ ܕܟܲܪܒܘܼܟ݂ ܡܵܛܝܵܐ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","ܗܵܘܹܐ ܡܲܥܡܪܵܝܗ‌ܝ ܚܵܪܵܒܵܐ، ܒܡܲܫܟܢܵܝ̈ܗ‌ܝ ܠܵܐ ܗܵܘܹܐ ܥܵܡܪܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","ܣܵܒܵܒ ܠܗ̇ܘ ܕܐܲܢ݇ܬ ܡܚܹܐ ܠܘܼܟ݂، ܪܕܝܼܦ ܠܗܘܿܢ، ܘܟܹܐ ܗܲܩܝܼ ܒܘܼܬ ܟܹܐܒܹ̈ܐ ܕܡܵܢܝܼ ܕܕܘܼܪܒܸܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","ܗܲܒ݂ܠܔ ܥܵܘܠܵܐ ܥܲܠܔ ܥܵܘܠܵܝܗ‌ܝ، ܘܠܵܐ ܫܵܒ݂ܩܹܬ ܥܵܒ݂ܪܝܼ ܒܙܲܕܝܼܩܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","ܫܒ݂ܘܿܩ ܦܵܝܫܝܼ ܓܪܝܼܕܹܐ ܡ̣ܢ ܟܬܵܒ݂ܵܐ ܕܚܲܝܹ̈ܐ، ܘܥܲܡ ܙܲܕܝܼܩܹ̈ܐ ܠܵܐ ܦܵܝܫܝܼ ܟܬܝܼܒܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","ܐܝܼܢܵܐ ܐܵܢܵܐ، ܡܸܣܟܹܢܵܐ ܝܘܸܢ ܘܕܘܼܪܕܸܫ̃ܵܐ، ܦܘܼܪܩܵܢܘܼܟ݂ ܡܲܪܸܡ ܠܝܼ ܠܫܲܝܢܵܐ، ܝܵܐ ܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","ܒܸܬ ܫܲܒܚܸܢ ܠܫܸܡܵܐ ܕܐܲܠܵܗܵܐ ܒܙܡܵܪܬܵ‌ܐ، ܘܒܸܬ ܓܲܪܘܸܣܸܢܹܗ ܒܫܲܟܲܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","ܐܵܗܵܐ ܒܸܬ ܫܵܦܪܵܐ ܠܡܵܪܝܵܐ ܒܘܼܫ ܡ̣ܢ ܕܒ݂ܵܚܬܵ‌ܐ ܕܬܵܘܪܵܐ، ܝܲܢ ܡܘܼܓ̰ܵܐ ܡܵܪܹܐ ܩܲܪ̈݇ܢܵܢܹܐ ܘܣܸܡܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","ܒܸܬ ܚܵܙܝܼ ܡܸܣܟܹܢܹ̈ܐ ܘܒܸܬ ܦܵܨܚܝܼ. ܝܵܐ ܛܵܥܝܵܢܹ̈ܐ ܕܐܲܠܵܗܵܐ، ܚܵܝܹܐ ܠܸܒܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","ܣܵܒܵܒ ܟܹܐ ܫܵܡܹܥ ܡܵܪܝܵܐ ܠܣܢܝܼܩܹ̈ܐ، ܘܠܐܲܣܝܼܪ̈ܘܼܗ‌ܝ ܠܹܐ ܡܲܣܠܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","ܫܲܒܚܝܼ ܠܹܗ ܫܡܲܝܵܐ ܘܐܲܪܥܵܐ، ܝܵܡܵܬܹ̈‌ܐ ܘܟܠܔ ܕܪܵܚܹܫ ܓܵܘܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","ܣܵܒܵܒ ܐܲܠܵܗܵܐ ܒܸܬ ܦܲܪܸܩ ܠܨܸܗܝܘܿܢ ܘܒܵܢܹܐ ܡܕܝܼܢܵܬܹ̈‌ܐ ܕܝܼܗܘܼܕܵܐ، ܘܒܸܬ ܝܵܬܒ݂ܝܼ ܬܵܡܵܐ ܘܝܵܪܬ‌ܝܼ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","ܘܙܲܪ̈ܥܹܐ ܕܪܹ̈ܓܵܘܵܬܘܼܗ‌ܝ ܒܸܬ ܝܵܪܬ‌ܝܼ ܠܵܗ̇، ܘܡܲܚܸܒܵܢܹ̈ܐ ܕܫܸܡܹܗ ܒܸܬ ܫܵܪܝܼ ܓܵܘܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","ܝܵܐ ܐܲܠܵܗܵܐ، ܡܲܠܝܸܙ ܠܦܲܨܘܼܝܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܡܲܠܝܸܙ ܠܗܲܝܲܪܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","ܢܵܟ݂ܦܝܼ ܘܦܵܝܫܝܼ ܡܘܼܟܸܦܹܐ، ܛܵܥܝܵܢܹ̈ܐ ܠܓܵܢܝܼ، ܕܵܝܪܝܼ ܠܒܵܬܪܵܐ ܘܦܵܝܫܝܼ ܡܘܼܢܟܸܦܹܐ، ܐܵܢܝܼ ܕܒܵܣܡܵܐ ܠܗܘܿܢ ܒܒܝܼܫܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","ܕܵܝܪܝܼ ܡ̣ܢ ܥܸܠܬܵ‌ܐ ܕܢܟ݂ܝܼܦܬܵܝܗ‌ܝ، ܐܵܢܝܼ ܕܒܹܐܡܵܪܵܐ ܝܢܵܐ: ”ܐܲܗܵܐ! ܐܲܗܵܐ!“ ");
INSERT INTO aii_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","ܐܝܼܢܵܐ ܚܵܕܝܼ ܘܦܵܨܚܝܼ ܒܝܼܘܼܟ݂ ܟܠܵܝܗ‌ܝ ܛܵܥܝܵܢܹ̈ܐ ܐܸܠܘܼܟ݂، ܘܐܲܡܝܼܢܵܐܝܼܬ ܐܵܡܪܝܼ ܡܲܚܸܒܵܢܹ̈ܐ ܕܦܘܼܪܩܵܢܘܼܟ݂: ܗܵܘܹܐ ܓܘܼܪܵܐ ܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","ܘܐܵܢܵܐ ܡܸܣܟܹܢܵܐ ܝܘܸܢ ܘܣܢܝܼܩܵܐ، ܝܵܐ ܐܲܠܵܗܵܐ، ܡܲܠܝܸܙ ܒܘܼܬ ܕܝܼܝܼ، ܗܲܝܲܪܬ‌ܝܼ ܘܦܲܨܝܵܢܝܼ ܐܲܢ݇ܬ ܝܼܘܸܬ، ܝܵܐ ܡܵܪܝܵܐ، ܠܵܐ ܥܲܪܩܸܠܸܬ. ");
INSERT INTO aii_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","ܒܝܼܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܫܩܝܼܠܔ ܠܝܼ ܓܵܘܣܵܐ، ܠܵܐ ܫܵܒ݂ܩܹܬ ܢܵܟ݂ܦܹܢ ܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","ܒܙܲܕܝܼܩܘܼܬܘܼܟ݂ ܦܲܨܹܝܬ ܠܝܼ ܘܦܲܪܩܸܬ ܠܝܼ، ܡܲܨܠܝܼ ܢܵܬܘܼܟ݂ ܐܸܠܝܼ ܘܗܲܒ݂ܠܔ ܠܝܼ ܦܘܼܪܩܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","ܗܘܝܼ ܐܸܠܝܼ ܠܐܝܼܨܵܪܵܐ ܕܡܲܥܡܪܵܐ ܕܥܵܒ݂ܪܹܢ ܓܵܘܹܗ ܒܟܠܔ ܥܕܵܢܵܐ، ܦܩܝܼܕ ܠܘܼܟ݂ ܠܦܲܪܘܼܩܹܐ ܐܸܠܝܼ، ܒܗ̇ܝ ܕܩܵܝܝܼ ܘܚܸܣܢܝܼ ܐܲܢ݇ܬ ܝܼܘܸܬ. ");
INSERT INTO aii_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","ܝܵܐ ܐܲܠܵܗ‌ܝܼ، ܦܲܨܝܼ ܠܝܼ ܡ̣ܢ ܐܝܼܕܵܐ ܕܪܲܫܝܼܥܵܐ، ܡ̣ܢ ܟ̰ܲܢܓܘܼܪܬܵ‌ܐ ܕܥܵܘܵܠܵܐ ܘܛܵܠܘܿܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","ܒܗ̇ܝ ܕܐܲܢ݇ܬ ܝܼܘܸܬ ܣܲܒ݂ܪܝܼ، ܝܵܐ ܡܵܪܝܵܐ ܐܲܠܵܗܵܐ، ܬܘܼܟ݂ܠܵܢܝܼ ܡ̣ܢ ܙܥܘܿܪܘܼܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","ܥܲܠܘܼܟ݂ ܣܢܝܼܕ ܠܝܼ ܡ̣ܢ ܒܲܛܢܵܐ، ܐܲܢ݇ܬ ܝܼܘܸܬ ܦܲܠܛܵܢܝܼ ܡ̣ܢ ܡܲܪܒܥܵܐ ܕܝܸܡܝܼ، ܐܸܠܘܼܟ݂ ܝܼܠܵܗ̇ ܬܸܫܒܘܿܚܬ‌ܝܼ ܐܲܡܝܼܢܵܐܝܼܬ. ");
INSERT INTO aii_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","ܐܲܝܟ݂ ܕܘܼܡܵܪܵܐ ܗܘܹܐ ܠܝܼ ܠܪܵܒܵܐ، ܐܝܼܢܵܐ ܐܲܢ݇ܬ ܒܹܝܬ ܓܵܘܣܝܼ ܥܲܫܝܼܢܵܐ ܝܘܸܬ. ");
INSERT INTO aii_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","ܡܸܠܝܵܐ ܝܠܹܗ ܦܘܼܡܝܼ ܬܸܫܒܘܿܚܬܘܼܟ݂، ܘܟܠܹܗ ܝܵܘܡܵܐ ܚܸܩܪܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","ܠܵܐ ܪܲܦܹܝܬ ܠܝܼ ܒܙܲܒ݂ܢܵܐ ܕܣܲܝܒܘܼܬ‌ܝܼ، ܟܲܕ ܬܵܐܹܡ ܚܲܝܠܝܼ ܠܵܐ ܫܵܒ݂ܩܹܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","ܒܗ̇ܝ ܕܗܘܼܡܙܸܡ ܠܗܘܿܢ ܕܸܫ̃ܡܸܢܝܼ̈ ܥܲܠܝܼ، ܘܢܵܛܪ̈ܵܢܹܐ ܠܓܵܢܝܼ ܥܒ݂ܝܼܕ ܠܗܘܿܢ ܡܸܠܟܵܐ ܥܲܡ ܚܕܵܕܹ̈ܐ، ");
INSERT INTO aii_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","ܒܹܐܡܵܪܵܐ: ”ܐܲܠܵܗܵܐ ܩܵܡ ܫܵܒܹܩ ܠܹܗ؛ ܢܦܘܿܠܘܼܢ ܒܵܬܪܹܗ ܘܕܒ݂ܘܿܩܘܼܢ ܠܹܗ، ܒܗ̇ܝ ܕܠܲܝܬ ܠܹܗ ܦܲܨܝܵܢܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","ܝܵܐ ܐܲܠܵܗܵܐ، ܠܵܐ ܪܵܚܩܹܬ ܡܸܢܝܼ، ܝܵܐ ܐܲܠܵܗ‌ܝܼ، ܡܲܠܝܸܙ ܠܗܲܝܲܪܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","ܢܵܟ݂ܦܝܼ ܘܬܵܝܡܝܼ ܥܵܒ݂ܕܵܢܹ̈ܐ ܕܕܲܠܩܘܼܒ݂ܠܘܼܬܵ‌ܐ ܠܓܵܢܝܼ، ܠܵܒ݂ܫܝܼ ܠܵܘܡܵܐ ܘܢܟ݂ܝܼܦܬܵ‌ܐ ܛܵܥܝܵܢܹ̈ܐ ܠܒܝܼܫܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","ܘܐܵܢܵܐ ܐܲܡܝܼܢܵܐܝܼܬ ܒܸܬ ܣܵܦܪܹܢ، ܘܒܸܬ ܝܵܗܒܹܢܘܼܟ݂ ܬܸܫܒܘܿܚܬܵ‌ܐ ܥܲܠܔ ܬܸܫܒܘܿܚܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","ܦܘܼܡܝܼ ܒܸܬ ܗܲܩܹܐ ܙܲܕܝܼܩܘܼܬܘܼܟ݂، ܟܠܹܗ ܝܵܘܡܵܐ ܦܘܼܪܩܵܢܘܼܟ݂، ܒܗ̇ܝ ܕܠܵܐ ܝܕܝܼܥ ܠܝܼ ܡܸܢܝܵܢܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","ܒܸܬ ܐܵܬܹܝܢ ܒܓܲܒܵܪ̈ܘܼܝܵܬܹ‌ܐ ܕܡܵܪܝܵܐ ܐܲܠܵܗܵܐ، ܒܸܬ ܡܲܕܟܸܪܸܢ ܙܲܕܝܼܩܘܼܬܵ‌ܐ ܕܕܝܼܘܼܟ݂ ܐܲܚܟ̰ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","ܝܵܐ ܐܲܠܵܗܵܐ، ܩܵܡ ܡܲܠܦܸܬ ܠܝܼ ܡ̣ܢ ܙܥܘܿܪܘܼܬ‌ܝܼ، ܘܗܲܠܔ ܠܲܐܟ݂ܵܐ ܡܘܼܕܸܥ ܠܝܼ ܕܘܼܡܵܪ̈ܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","ܘܐܘܼܦ ܗܲܠܔ ܚܘܵܪܕܸܩܢܘܼܬܵ‌ܐ ܘܣܲܝܒܘܼܬܵ‌ܐ، ܝܵܐ ܐܲܠܵܗܵܐ، ܠܵܐ ܪܲܦܹܝܬ ܠܝܼ، ܗܲܠܔ ܕܡܲܕܥܸܢ ܚܲܝܠܘܼܟ݂ ܠܕܵܪܵܐ ܐܚܹܪܢܵܐ، ܓܲܒܵܪܘܼܬܘܼܟ݂ ܠܟܠܔ ܕܐܵܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","ܙܲܕܝܼܩܘܼܬܘܼܟ݂، ܝܵܐ ܐܲܠܵܗܵܐ، ܗܲܠܔ ܡܪܵܘܡܵܐ ܝܠܵܗ̇، ܐܲܢ݇ܬ ܕܥܒ݂ܝܼܕ ܠܘܼܟ݂ ܦܘܼܠܚܵܢܹ̈ܐ ܓܘܼܪܹ̈ܐ، ܝܵܐ ܐܲܠܵܗܵܐ، ܡܵܢܝܼ ܝܠܹܗ ܐܲܝܟ݂ ܕܝܼܘܼܟ݂؟ ");
INSERT INTO aii_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","ܐܲܢ݇ܬ ܕܩܵܡ ܡܲܚܙܹܝܬ ܠܝܼ ܪܵܒܵܐ ܥܵܘܩܵܢܹ̈ܐ ܣܸܪ̈ܝܹܐ، ܒܸܬ ܕܵܝܪܹܬ ܡܲܚܹܝܬ ܠܝܼ، ܘܡ̣ܢ ܥܘܼܡܩܹ̈ܐ ܕܐܲܪܥܵܐ ܒܸܬ ܕܵܝܪܹܬ ܡܲܐܣܩܸܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","ܒܸܬ ܡܲܙܝܸܕܸܬ ܓܘܼܪܘܼܬ‌ܝܼ، ܘܒܸܬ ܕܵܝܪܹܬ ܝܵܗܒܹܬ ܠܝܼ ܠܸܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","ܐܘܼܦ ܐܵܢܵܐ ܒܸܬ ܫܲܟܪܸܢܘܼܟ݂ ܒܩܝܼܬܵܪܵܐ، ܩܵܐ ܫܲܪܝܼܪܘܼܬܘܼܟ݂، ܝܵܐ ܐܲܠܵܗ‌ܝܼ، ܒܸܬ ܙܵܡܪܹܢ ܐܸܠܘܼܟ݂ ܒܟܸܢܵܪܵܐ، ܝܵܐ ܩܲܕܝܼܫܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","ܒܸܬ ܫܲܒܚܝܼ ܣܸܦܘܵܬ‌ܝܼ̈ ܟܲܕ ܙܵܡܪܹܢ ܐܸܠܘܼܟ݂، ܐܘܼܦ ܓܵܢܝܼ ܕܦܘܼܪܩܵܐ ܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","ܐܘܼܦ ܠܸܫܵܢܝܼ ܟܠܹܗ ܝܵܘܡܵܐ ܒܸܬ ܗܲܡܙܸܡ ܙܲܕܝܼܩܘܼܬܘܼܟ݂، ܒܗ̇ܝ ܕܢܟ݂ܝܼܦ ܠܗܘܿܢ ܕܦܝܼܫ ܠܗܘܿܢ ܡܘܼܟܸܦܹܐ ܛܵܥܝܵܢܹ̈ܐ ܠܒܝܼܫܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","ܝܵܐ ܐܲܠܵܗܵܐ، ܕܝܼܘܵܢܘܼ̈ܟ݂ ܠܡܲܠܟܵܐ ܗܲܒ݂ܠܔ، ܘܙܲܕܝܼܩܘܼܬܘܼܟ݂ ܠܒܪܘܿܢܵܐ ܕܡܲܠܟܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","ܒܸܬ ܕܵܐܹܢ ܠܥܲܡܘܼܟ݂ ܒܙܲܕܝܼܩܘܼܬܵ‌ܐ، ܘܠܡܸܣܟܹܢܘܼ̈ܟ݂ ܒܕܝܼܘܵܢ. ");
INSERT INTO aii_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","ܒܸܬ ܛܵܥܢܝܼ ܛܘܼܪܹ̈ܐ ܫܠܵܡܵܐ ܠܥܲܡܵܐ، ܘܪ̈ܘܼܡܝܵܬܹ‌ܐ ܒܙܲܕܝܼܩܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","ܒܸܬ ܥܵܒܹܕ ܕܝܼܘܵܢ ܕܡܸܣܟܹܢܹ̈ܐ ܕܥܲܡܵܐ، ܒܸܬ ܦܲܪܸܩ ܠܒܢܘܿܢܹ̈ܐ ܕܣܢܝܼܩܹ̈ܐ، ܘܒܸܬ ܒܵܠܹܣ ܠܛܵܠܘܿܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","ܒܸܬ ܙܵܕܥܝܼ ܡܸܢܘܼܟ݂ ܟܡܵܐ ܕܐܝܼܬ ܫܸܡܫܵܐ، ܘܟܡܵܐ ܕܐܝܼܬ ܣܲܗܪܵܐ، ܠܕܵܪܵܐ ܕܕܵܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","ܒܸܬ ܨܵܠܹܐ ܐܲܝܟ݂ ܡܸܛܪܵܐ ܥܲܠܔ ܥܸܩܪܵܐ ܕܓܸܠܵܐ ܚܨܝܼܕܵܐ، ܐܲܝܟ݂ ܩܲܫܩܲܫܝܵܬܹ̈‌ܐ ܒܸܫܦܵܟ݂ܵܐ ܥܲܠܔ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","ܒܸܬ ܡܲܓ̰ܝܸܢܵܐ ܙܲܕܝܼܩܘܼܬܵ‌ܐ ܒܝܵܘܡܵܢܘܼ̈ܗ‌ܝ، ܘܒܘܼܫܵܝܘܼܬܵ‌ܐ ܕܫܠܵܡܵܐ ܗܲܠܔ ܕܠܵܐ ܗܵܘܹܐ ܣܲܗܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","ܘܒܸܬ ܗܲܟܸܡ ܡ̣ܢ ܝܵܡܵܐ ܗܲܠܔ ܝܵܡܵܐ، ܘܡ̣ܢ ܢܲܗܪܵܐ ܕܦܪܵܬ ܗܲܠܔ ܡܲܪ̈ܙܵܢܹܐ ܕܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","ܩܲܕܡܘܼܗ‌ܝ ܒܸܬ ܛܵܥܦܝܼ ܥܵܡܪ̈ܵܢܹܐ ܕܒܲܪܝܼܵܐ، ܘܕܸܫ̃ܡܸܢܘܼ̈ܗ‌ܝ ܥܲܦܪܵܐ ܒܸܬ ܠܵܟܚܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","ܡܲܠܟܹ̈ܐ ܕܬܲܪܫܝܼܫ ܘܕܓܵܙܪ̈ܵܬܹ‌ܐ ܡܵܘܗܲܒ݂ܬܵ‌ܐ ܒܸܬ ܡܲܝܬ‌ܝܼ، ܡܲܠܟܹ̈ܐ ܕܫܒ݂ܵܐ ܘܕܣܵܒ݂ܵܐ ܕܲܫܢܵܐ ܒܸܬ ܡܲܩܪܸܒ݂ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","ܘܒܸܬ ܟܵܝܦܝܼ ܩܲܕܡܘܼܗ‌ܝ ܟܠܵܝܗ‌ܝ ܡܲܠܟܹ̈ܐ، ܟܠܵܝܗ‌ܝ ܐܸܡܘܵܬܹ̈‌ܐ ܒܸܬ ܦܵܠܚܝܼ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","ܣܵܒܵܒ ܒܸܬ ܦܲܨܹܐ ܠܣܢܝܼܩܵܐ ܕܩܲܘܸܚ، ܘܠܡܸܣܟܹܢܵܐ ܕܠܲܝܬ ܗܲܝܸܪܵܢܵܐ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","ܒܸܬ ܥܵܒܹܕ ܪ̈ܲܚܡܹܐ ܥܲܠܔ ܡܸܣܟܹܢܵܐ ܘܣܢܝܼܩܵܐ، ܘܓܵܢܵܬܹ̈‌ܐ ܕܣܢܝܼܩܹ̈ܐ ܒܸܬ ܦܲܪܸܩ. ");
INSERT INTO aii_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","ܡ̣ܢ ܛܠܘܼܡܝܵܐ ܘܡ̣ܢ ܚܸܡܬܵ‌ܐ ܒܸܬ ܦܲܪܸܩ ܓܵܢܵܝܗ‌ܝ، ܘܒܸܬ ܗܵܘܹܐ ܝܲܩܝܼܪܵܐ ܕܸܡܵܝܗ‌ܝ ܒܥܲܝܢܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","ܘܒܸܬ ܚܵܝܹܐ، ܘܒܸܬ ܝܵܗܒ݂ܝܼ ܐܸܠܹܗ ܡ̣ܢ ܕܲܗܒ݂ܵܐ ܕܫܒ݂ܵܐ، ܘܒܸܬ ܨܲܠܝܼ ܒܘܼܬ ܕܝܼܹܗ ܐܲܡܝܼܢܵܐܝܼܬ، ܟܠܹܗ ܝܵܘܡܵܐ ܒܸܬ ܒܲܪܟ݂ܝܼ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","ܒܸܬ ܗܵܘܝܵܐ ܦܸܪܝܘܼܬܵ‌ܐ ܕܕܲܚܠܵܐ ܒܐܲܪܥܵܐ ܒܪܹܝܫܵܐ ܕܛܘܼܪ̈ܵܢܹܐ، ܒܸܬ ܫܵܥܫܵܐ ܐܲܝܟ݂ ܠܸܒ݂ܢܵܢ ܛܥܘܼܢܬܹܗ، ܘܒܸܬ ܦܵܩܚܝܼ ܐܢܵܫܹ̈ܐ ܡ̣ܢ ܡܕܝܼܢ݇ܬܵ‌ܐ ܐܲܝܟ݂ ܓܸܠܵܐ ܕܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","ܒܸܬ ܗܵܘܹܐ ܫܸܡܹܗ ܠܥܵܠܲܡ، ܘܒܸܬ ܦܵܐܹܫ ܫܸܡܹܗ ܟܡܵܐ ܕܐܝܼܬ ܫܸܡܫܵܐ، ܘܒܸܬ ܦܵܝܫܝܼ ܒܘܼܪܟܹܐ ܒܝܼܹܗ ܟܠܵܝܗ‌ܝ ܐܸܡܘܵܬܹ̈‌ܐ، ܘܒܸܬ ܝܵܗܒ݂ܝܼ ܠܹܗ ܛܘܼܒ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","ܒܪܝܼܟ݂ܵܐ ܝܠܹܗ ܡܵܪܝܵܐ ܐܲܠܵܗܵܐ، ܐܲܠܵܗܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ، ܥܵܒ݂ܕܵܢܹ̈ܐ ܕܥܲܓ̰ܝܼܒܘܼܝܵܬܹ̈‌ܐ ܒܢܲܦ̮ܫܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","ܘܒܪܝܼܟ݂ܵܐ ܝܠܹܗ ܫܸܡܹܗ ܡܝܘܼܩܪܵܐ ܠܥܵܠܲܡ، ܘܦܵܝܫܵܐ ܡܠܝܼܬܵ‌ܐ ܟܠܵܗ̇ ܐܲܪܥܵܐ ܐܝܼܩܵܪܹܗ، ܐܵܡܹܝܢ ܘܐܵܡܹܝܢ. ");
INSERT INTO aii_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","ܬܝܼܡ ܠܗܘܿܢ ܨܠܵܘܵܬܹ̈‌ܐ ܕܕܵܘܝܼܕ ܒܪܘܿܢܵܐ ܕܐܝܼܫܲܝ. ");
INSERT INTO aii_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","ܒܫܪܵܪܵܐ، ܛܵܒ݂ܵܐ ܝܠܹܗ ܠܐܝܼܣܪܵܐܹܝܠܔ ܐܲܠܵܗܵܐ، ܠܕܸܟ݂ܝܹ̈ܐ ܕܠܸܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","ܘܐܵܢܵܐ، ܒܵܬܪ ܚܲܕܟ̰ܵܐ ܒܸܬ ܬܲܪܩܸܠܝܼ ܗܘܵܘ ܐܲܩܠܵܬ‌ܝܼ̈، ܚܲܕܟ̰ܵܐ ܦܝܼܫ ܠܵܗ̇ ܕܓ̰ܵܪܦܝܼ ܗܘܵܘ ܦܵܣܘܿܥܝܵܬ‌ܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","ܣܵܒܵܒ ܒܘܼܚܸܠܔ ܠܝܼ ܒܚܬܝܼܪܹ̈ܐ، ܫܠܵܡܵܐ ܕܪ̈ܲܫܝܼܥܹܐ ܚܙܹܐ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","ܣܵܒܵܒ ܠܲܝܬ ܚܸܒ݂ܠܹ̈ܐ ܒܡܵܘܬܵܝܗ‌ܝ، ܘܛܪܝܼܨܵܐ ܝܠܹܗ ܦܲܓ݂ܪܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","ܒܥܲܡܠܵܐ ܕܐܢܵܫܵܐ ܠܹܐ ܝܢܵܐ، ܘܒܡܲܚܘܵܬܹ̈‌ܐ ܕܒܲܪܢܵܫܵܐ ܠܹܐ ܦܵܝܫܝܼ ܡܸܚܝܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","ܒܘܼܬ ܐܵܗܵܐ، ܠܒ݂ܝܼܫ ܠܗܘܿܢ ܫܘܼܒ݂ܗܵܪܵܐ ܠܬܵܘܩܵܝܗ‌ܝ، ܟܹܐ ܟܲܣܹܐ ܠܒ݂ܘܼܫܵܐ ܕܙܠܘܼܡܝܵܐ ܐܸܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","ܦܠܝܼܛܹܐ ܝܢܵܐ ܡ̣ܢ ܬܲܪܒܵܐ ܥܲܝ̈ܢܵܝܗ‌ܝ، ܥܒ݂ܝܼܪܗܘܿܢ ܡ̣ܢ ܟܝܘܼܠܵܐ ܚܘܼܫܵܒܹ̈ܐ ܕܠܸܒܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","ܟܹܐ ܡܲܣܚܸܪܝܼ ܘܟܹܐ ܗܲܡܙܸܡܝܼ ܒܒܝܼܫܬܵ‌ܐ، ܡ̣ܢ ܪܵܡܘܼܬܵ‌ܐ ܟܹܐ ܗܲܡܙܸܡܝܼ ܙܠܘܼܡܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","ܡܘܼܬܸܒ݂ ܠܗܘܿܢ ܒܫܡܲܝܵܐ ܦܘܼܡܵܝܗ‌ܝ، ܘܠܸܫܵܢܵܝܗ‌ܝ ܟܹܐ ܚܵܕܹܪ ܒܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","ܒܘܼܬ ܐܵܗܵܐ، ܥܲܡܵܐ ܟܹܐ ܕܵܐܹܪ ܠܟܸܣܠܵܝܗ‌ܝ، ܘܡ̈ܝܼܵܐ ܕܟܵܣܵܐ ܡܸܠܝܵܐ ܟܹܐ ܦܵܝܫܝܼ ܣܪܝܼܦܹܐ ܒܝܼܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","ܘܟܹܐ ܐܵܡܪܝܼ: ”ܕܵܐܟ݂ܝܼ ܟܹܐ ܝܵܕܹܥ ܐܲܠܵܗܵܐ؟ ܐܝܼܬ ܝܕܵܥܬܵ‌ܐ ܒܥܸܠܵܝܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","ܗܵܐ، ܐܲܢܹܐ ܝܢܵܐ ܪ̈ܲܫܝܼܥܹܐ، ܒܫܲܝܢܵܐ ܝܢܵܐ ܠܥܵܠܲܡ، ܘܡܘܼܙܝܸܕܹܐ ܝܢܵܐ ܥܘܼܬܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","ܒܫܪܵܪܵܐ، ܣܪܝܼܩܵܐܝܼܬ ܕܘܼܟܹܐ ܠܝܼ ܠܸܒܝܼ، ܘܚܘܼܠܸܠܔ ܠܝܼ ܒܙܲܟܵܝܘܼܬܵ‌ܐ ܐܝܼܕܵܬ‌ܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","ܘܗܘܹܐ ܠܝܼ ܡܸܚܝܵܐ ܒܡܲܚܘܵܬܹ̈‌ܐ ܟܠܹܗ ܝܵܘܡܵܐ، ܘܡܲܢܟܲܣܬ‌ܝܼ ܟܠܔ ܨܲܦܪܵܐ ܝܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","ܐܸܢ ܐܵܡܪܹܢ ܗܘܵܐ: ”ܒܸܬ ܗܲܩܹܝܢ ܗܵܕܟ݂ܵܐ،“ ܗܵܐ، ܠܬܵܘܠܲܕܬܵ‌ܐ ܕܒܢܘܿܢܘܼ̈ܟ݂ ܒܸܬ ܥܵܒ݂ܕܹܢ ܗܘܵܐ ܚܵܝܝܼܢܘܼܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","ܘܐܝܼܡܲܢ ܕܬܘܼܚܡܸܢܝܼ ܕܦܲܪܡܹܝܢ ܐܵܗܵܐ، ܚܙܹܐ ܠܝܼ ܕܥܲܡܠܵܐ ܝܗܘܵܐ ܒܥܲܝܢܝܼ̈، ");
INSERT INTO aii_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","ܗܲܠܔ ܕܥܒ݂ܝܼܪܝܼ ܠܡܲܩܕܫܵܐ ܕܐܲܠܵܗܵܐ، ܘܦܘܼܪܡܹܐ ܠܝܼ ܠܚܲܪܬܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","ܬܪܘܼܨܵܐ، ܟܹܐ ܡܲܬܒܸܬ ܠܗܘܿܢ ܒܕܘܼܟܵܢܹ̈ܐ ܡܲܓ̰ܪܸ̈ܛܵܢܹܐ، ܟܹܐ ܡܲܢܦܸܠܸܬ ܠܗܘܿܢ ܠܚܵܪ̈ܵܒܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","ܕܐܲܝܟ݂ ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܚܪܵܒ݂ܵܐ ܒܛܲܪܦܲܛܬܵ‌ܐ ܕܥܲܝܢܵܐ، ܩܛܝܼܥ ܠܗܘܿܢ ܘܬܝܼܡ ܠܗܘܿܢ ܒܓܘܼܢܚܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","ܐܲܝܟ݂ ܚܸܠܡܵܐ ܝܢܵܐ ܡܒܵܬܪ ܪܥܵܫܬܵ‌ܐ، ܝܵܐ ܡܵܪܝܵܐ، ܒܬܥܵܪܬܘܼܟ݂ ܨܲܠܡܵܝܗ‌ܝ ܒܸܬ ܡܲܣܠܹܝܬ. ");
INSERT INTO aii_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","ܐܝܼܡܲܢ ܕܦܝܼܫ ܠܹܗ ܡܘܼܡܪܸܪܵܐ ܠܸܒܝܼ، ܘܓܵܘܝܼ ܦܝܼܫ ܠܹܗ ܟ̰ܪܝܼܙܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","ܐܵܢܵܐ ܐܲܗܡܲܩ ܝܼܘܸܢ ܗܘܵܐ، ܘܠܵܐ ܝܕܝܼܥ ܠܝܼ، ܗܲܝܘܵܢ ܗܘܹܐ ܠܝܼ ܟܸܣ ܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","ܘܗܸܫ ܐܵܢܵܐ ܐܲܡܝܼܢܵܐܝܼܬ ܥܲܡܘܼܟ݂ ܝܼܘܸܢ، ܕܒ݂ܝܼܩ ܠܘܼܟ݂ ܒܐܝܼܕܝܼ ܕܝܲܡܝܼܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","ܒܡܸܠܟܘܼܟ݂ ܒܸܬ ܬܲܓܒܸܪܸܬ ܠܝܼ، ܘܒܵܬܪ ܗܵܕܵܐ ܒܐܝܼܩܵܪܵܐ ܩܲܒܠܸܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","ܡܵܢܝܼ ܐܝܼܬ ܠܝܼ ܒܫܡܲܝܵܐ؟ ܘܫܒ݂ܘܿܩ ܡܸܢܘܼܟ݂ ܠܹܐ ܒܵܣܡܵܐ ܠܝܼ ܒܡܸܢܕܝܼ ܒܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","ܬܝܼܡ ܠܹܗ ܒܸܣܪܝܼ ܘܠܸܒܝܼ، ܐܝܼܨܵܪܵܐ ܕܠܸܒܝܼ ܘܣܵܗܡܝܼ ܐܲܠܵܗܵܐ ܝܠܹܗ ܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","ܣܵܒܵܒ ܗܵܐ، ܐܵܢܝܼ ܕܝܼܢܵܐ ܪܸܚܩܵܐ ܡܸܢܘܼܟ݂ ܒܸܬ ܛܵܠܩܝܼ، ܦܘܼܢܹܐ ܠܘܼܟ݂ ܟܠܔ ܙܲܢܵܝܵܐ ܡ̣ܢ ܟܸܣ ܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","ܘܐܵܢܵܐ، ܩܲܪܒܲܢܬܵ‌ܐ ܠܐܲܠܵܗܵܐ ܩܵܬ‌ܝܼ ܨܦܵܝܝܼ ܝܠܵܗ̇، ܡܘܼܬܸܒ݂ ܠܝܼ ܒܡܵܪܝܵܐ ܐܲܠܵܗܵܐ ܒܹܝܬ ܓܵܘܣܝܼ، ܠܗܲܩܘܼܝܹܐ ܟܠܵܝܗ‌ܝ ܦܘܼܠܚܵܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","ܩܵܡܘܿܕܝܼ، ܝܵܐ ܐܲܠܵܗܵܐ، ܩܵܡ ܡܲܚܦܸܠܸܬ ܠܲܢ ܠܥܵܠܲܡ؟ ܬܲܢܬܘܼܢܹܐ ܝܠܵܗ̇ ܚܸܡܬܘܼܟ݂ ܥܲܠܔ ܦܸܣܩܵܐ ܕܡܲܪܥܝܼܬܘܼܟ݂؟ ");
INSERT INTO aii_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","ܕܟ݂ܘܿܪ ܠܟܢܘܼܫܝܘܼܟ݂ ܕܙܒ݂ܝܼܢܘܼܟ݂ ܡ̣ܢ ܙܲܒ݂ܢܵܐ ܩܲܕܝܼܡܵܝܵܐ، ܫܲܒ݂ܛܵܐ ܕܝܵܪܬܘܼܬܘܼܟ݂ ܕܦܘܼܪܸܩ ܠܘܼܟ݂، ܠܐܵܗܵܐ ܛܘܼܪܵܐ ܕܨܸܗܝܘܿܢ ܕܫܪܹܐ ܠܘܼܟ݂ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","ܡܲܦܬܸܠܔ ܦܵܣܘܿܥܝܵܬܘܼ̈ܟ݂ ܠܓܹܒܵܐ ܕܚܵܪ̈ܵܒܹܐ ܕܥܵܠܲܡ، ܟܠܔ ܒܝܼܫܬܵ‌ܐ ܥܒ݂ܝܼܕ ܠܹܗ ܕܸܫ̃ܡܸܢ ܒܡܲܩܕܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","ܓܘܼܪܓܸܡ ܠܗܘܿܢ ܕܸܫ̃ܡܸܢܘܼ̈ܟ݂ ܒܓܵܘܵܐ ܕܓ̰ܵܡܵܥܲܬܘܼܟ݂، ܡܘܼܩܸܡ ܠܗܘܿܢ ܐܵܬܘܵܬܵܝ̈ܗ‌ܝ ܐܲܝܟ݂ ܢܝܼܫܲܢܩܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","ܗܘܝܼܹܐ ܝܗܘܵܘ ܐܲܝܟ݂ ܡܵܚܝܵܢܵܐ ܕܢܲܪ̈ܥܹܐ ܒܐܝܼܠܵܢܹ̈ܐ ܕܥܵܒ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","ܘܐܵܕܝܼܵܐ، ܢܩܵܪ̈ܝܵܬܘܼܗ‌ܝ ܟܠܵܝܗ‌ܝ ܡܸܚܕܵܕܹ̈ܐ، ܒܚܵܨܝܼܢܹ̈ܐ ܘܢܲܪ̈ܥܹܐ ܛܲܚܛܘܼܚܹܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","ܕܪܹܐ ܠܗܘܿܢ ܒܢܘܼܪܵܐ ܡܲܩܕܫܘܼܟ݂، ܠܐܲܪܥܵܐ ܫܚܝܼܡ ܠܗܘܿܢ ܡܲܫܟܢܵܐ ܕܫܸܡܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","ܐܡܝܼܪܗܘܿܢ ܒܠܸܒܵܝܗ‌ܝ: ”ܙܵܠܡܲܚ ܠܟܠܵܝܗ‌ܝ.“ ܡܘܼܩܸܕ ܠܗܘܿܢ ܟܠܵܝܗ‌ܝ ܟܢܘܼܫܝܵܬܹ̈‌ܐ ܕܐܲܠܵܗܵܐ ܒܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","ܢܝܼܫܲܢܩܹ̈ܐ ܐܸܠܲܢ ܠܹܐ ܝܘܲܚ ܒܸܚܙܵܝܵܐ، ܠܲܝܬ ܐܚܹܪܢܵܐ ܢܒ݂ܝܼܵܐ، ܘܠܲܝܬ ܥܲܡܲܢ ܚܲܕ ܕܝܵܕܹܥ ܗܲܠܔ ܐܝܼܡܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","ܗܲܠܔ ܐܝܼܡܲܢ، ܝܵܐ ܐܲܠܵܗܵܐ، ܒܸܬ ܠܵܐܹܡ ܡܲܠܝܸܨܵܢܵܐ؟ ܒܸܬ ܡܲܣܚܸܪ ܕܸܫ̃ܡܸܢ ܒܫܸܡܘܼܟ݂ ܠܥܵܠܲܡ؟ ");
INSERT INTO aii_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","ܩܵܡܘܿܕܝܼ ܡܲܕܘܼܪܹܐ ܝܘܸܬ ܐܝܼܕܘܼܟ݂ ܘܝܲܡܝܼܢܘܼܟ݂؟ ܡ̣ܢ ܓܵܘ ܥܘܼܒܘܼܟ݂ ܦܲܠܸܛ ܠܵܗ̇ ܘܛܲܠܸܩ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","ܘܐܲܠܵܗܵܐ ܡܲܠܟܝܼ ܝܠܹܗ ܡ̣ܢ ܙܲܒ݂ܢܵܐ ܩܲܕܝܼܡܵܝܵܐ، ܦܵܠܚܵܢܹ̈ܐ ܕܦܘܼܪ̈ܩܵܢܹܐ ܒܓܵܘܵܐ ܕܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","ܐܲܢ݇ܬ ܒܥܘܼܫܢܘܼܟ݂ ܟ̰ܠܝܼܦܵܐ ܠܘܼܟ݂ ܝܵܡܵܐ، ܬܒ݂ܝܼܪܘܼܟ݂ ܪܹ̈ܝܫܵܢܹܐ ܕܬܲܢܝܼܢܹ̈ܐ ܒܡ̈ܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","ܐܲܢ݇ܬ ܛܒ݂ܝܼܚ ܠܘܼܟ݂ ܪܹ̈ܝܫܵܢܹܐ ܕܠܹܘܝܵܬܵܢ، ܩܵܡ ܝܵܗܒܹܬ ܠܹܗ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ ܠܥܲܡܵܐ، ܠܥܵܡܪ̈ܵܢܹܐ ܕܒܲܪܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","ܐܲܢ݇ܬ ܡܘܼܦܩܸܥ ܠܘܼܟ݂ ܥܲܝܢܵܬܹ̈‌ܐ ܘܢܲܚܠܹ̈ܐ، ܐܲܢ݇ܬ ܡܘܼܒܪܸܙ ܠܘܼܟ݂ ܢܲܗܪ̈ܵܘܵܬܹ‌ܐ ܙܲܪ̈ܒܵܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","ܕܝܼܘܼܟ݂ ܝܠܹܗ ܝܵܘܡܵܐ، ܐܘܼܦ ܕܝܼܘܼܟ݂ ܝܠܹܗ ܠܲܝܠܹܐ، ܐܲܢ݇ܬ ܫܘܼܬܐܸܣ ܠܘܼܟ݂ ܒܲܗܪܵܐ ܘܫܸܡܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","ܐܲܢ݇ܬ ܡܘܼܬܸܒ݂ ܠܘܼܟ݂ ܟܠܵܝܗ‌ܝ ܬܚܘܼܡܹ̈ܐ ܕܐܲܪܥܵܐ، ܩܲܝܛܵܐ ܘܣܸܬܘܵܐ ܐܲܢ݇ܬ ܥܒ݂ܝܼܕܵܝ ܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","ܕܟ݂ܘܿܪ ܐܵܗܵܐ، ܕܵܐܟ݂ܝܼ ܠܝܼܡ ܠܹܗ ܕܸܫ̃ܡܸܢ، ܝܵܐ ܡܵܪܝܵܐ، ܘܥܲܡܵܐ ܣܲܟ݂ܠܵܐ ܡܘܼܣܚܸܪܹܗ ܒܫܸܡܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","ܠܵܐ ܝܵܗܒܹܬ ܓܵܢܵܐ ܕܓܘܼܪܓܘܼܡܘܼܟ݂ ܠܚܲܝܘܬܵ‌ܐ، ܠܵܐ ܡܲܢܫܹܝܬ ܚܲܝܹ̈ܐ ܕܡܸܣܟܹܢܘܼ̈ܟ݂ ܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","ܚܘܼܪ ܠܘܲܥܕܵܐ، ܣܵܒܵܒ ܡܸܠܝܹܐ ܝܢܵܐ ܕܘܼܟܵܢܹ̈ܐ ܚܸܫܟܵܢܹ̈ܐ ܕܐܲܪܥܵܐ ܒܕܘܼܝܵܪܹ̈ܐ ܕܚܸܡܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","ܠܵܐ ܕܵܐܹܪ ܡܘܼܠܝܸܨܵܐ ܟܲܕ ܢܟ݂ܝܼܦܵܐ، ܡܸܣܟܹܢܵܐ ܘܣܢܝܼܩܵܐ ܫܲܒܚܝܼ ܠܫܸܡܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","ܩܘܼܡ، ܝܵܐ ܐܲܠܵܗܵܐ، ܥܒ݂ܘܿܕ ܕܝܼܘܵܢܘܼܟ݂، ܕܟ݂ܘܿܪ ܠܵܘܡܘܼܟ݂ ܡ̣ܢ ܣܲܟ݂ܠܵܐ ܟܠܹܗ ܝܵܘܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","ܠܵܐ ܡܲܢܫܹܝܬ ܩܵܠܵܐ ܕܕܸܫ̃ܡܸܢܘܼ̈ܟ݂، ܫܓ݂ܘܼܫܝܵܐ ܕܩܵܝܡܵܢܹ̈ܐ ܕܲܠܩܘܼܒ݂ܠܘܼܟ݂ ܒܹܐܣܵܩܵܐ ܐܲܡܝܼܢܵܐܝܼܬ. ");
INSERT INTO aii_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","ܫܲܟܘܼܪܹܐ ܝܘܲܚ ܐܸܠܘܼܟ݂، ܝܵܐ ܐܲܠܵܗܵܐ، ܫܲܟܘܼܪܹܐ ܝܘܲܚ ܘܩܘܼܪܒܵܐ ܝܠܹܗ ܫܸܡܘܼܟ݂، ܕܘܼܡܵܪ̈ܘܼܟ݂ ܗܘܼܩܹܐ ܠܗܘܿܢ ܐܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","”ܐܝܼܡܲܢ ܕܪܵܫܡܹܢ ܥܕܵܢܵܐ، ܒܬܪܘܼܨܘܼܬܵ‌ܐ ܒܸܬ ܕܵܝܢܹܢ ܐܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","”ܦܫܝܼܪܹܐ ܝܢܵܐ ܐܲܪܥܵܐ ܘܟܠܵܝܗ‌ܝ ܥܵܡܪ̈ܵܢܘܼܗ̇، ܐܵܢܵܐ ܡܘܼܩܘܹܐ ܠܝܼ ܣܛܘܼܢܘܼ̈ܗ̇. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","”ܐܡܝܼܪܝܼ ܠܚܵܬܪ̈ܵܢܹܐ: ’ܠܵܐ ܚܵܬܪܝܼܬܘܿܢ،‘ ܘܠܪ̈ܲܫܝܼܥܹܐ: ’ܠܵܐ ܡܲܪܡܝܼܬܘܿܢ ܪܹܝܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","’ܠܵܐ ܡܲܪܡܝܼܬܘܿܢ ܠܡܪܵܘܡܵܐ ܪܹܝܫܵܘܟ݂ܘܿܢ، ܐܵܦܠܵܐ ܗܲܡܙܸܡܝܼܬܘܿܢ ܒܩܕܵܠܵܐ ܪܵܡܵܐ.‘“ ");
INSERT INTO aii_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","ܣܵܒܵܒ ܠܵܐ ܡ̣ܢ ܡܲܕܢܚܵܐ ܘܠܵܐ ܡ̣ܢ ܡܲܥܪܒ݂ܵܐ، ܘܠܵܐ ܡ̣ܢ ܒܲܪܝܼܵܐ ܟܹܐ ܐܵܬܝܵܐ ܪܵܡܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","ܐܸܠܵܐ ܐܲܠܵܗܵܐ ܝܠܹܗ ܕܲܝܵܢܵܐ، ܠܐܵܗܵܐ ܟܹܐ ܡܲܟܸܦ ܘܠܐܵܗܵܐ ܟܹܐ ܡܲܪܸܡ. ");
INSERT INTO aii_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","ܣܵܒܵܒ ܟܵܣܵܐ ܒܐܝܼܕܵܐ ܕܡܵܪܝܵܐ ܝܠܹܗ، ܘܚܲܡܪܵܐ ܡܸܛܝܵܐ ܝܠܹܗ، ܡܸܠܝܵܐ ܝܠܹܗ ܡܙܵܓ݂ܵܐ ܘܡܸܢܹܗ ܟܹܐ ܕܵܪܹܐ، ܫܲܪܝܼܪܵܐܝܼܬ، ܒܸܬ ܫܵܬ‌ܝܼ ܡܸܢܹܗ، ܘܕܘܼܪܕܹܗ ܒܸܬ ܠܵܡܨܝܼ ܟܠܵܝܗ‌ܝ ܪ̈ܲܫܝܼܥܹܐ ܕܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","ܐܝܼܢܵܐ ܐܵܢܵܐ ܒܸܬ ܡܲܕܥܸܢ ܐܵܗܵܐ ܠܥܵܠܲܡ، ܒܸܬ ܙܵܡܪܹܢ ܠܐܲܠܵܗܵܐ ܕܝܲܥܩܘܿܒ݂، ܕܐܵܡܹܪ: ");
INSERT INTO aii_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","”ܒܸܬ ܫܵܡܛܹܢ ܟܠܹܗ ܚܲܝܠܵܐ ܕܪ̈ܲܫܝܼܥܹܐ، ܒܸܬ ܦܵܝܫܝܼ ܡܘܼܪܡܹܐ ܪܹ̈ܝܫܹܐ ܕܙܲܕܝܼܩܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","ܦܝܼܫܵܐ ܝܠܹܗ ܝܕܝܼܥܵܐ ܐܲܠܵܗܵܐ ܓܵܘ ܝܼܗܘܼܕܵܐ، ܓܘܼܪܵܐ ܝܠܹܗ ܫܸܡܹܗ ܓܵܘ ܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","ܘܗܘܹܐ ܠܵܗ̇ ܡܛܲܠܠܹܗ ܓܵܘ ܫܵܠܝܼܡ، ܘܡܲܥܡܪܹܗ ܓܵܘ ܨܸܗܝܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","ܬܵܡܵܐ ܬܒ݂ܝܼܪܹܗ ܠܓܹܐܪܹ̈ܐ ܠܵܗܝܵܢܹ̈ܐ ܕܩܸܫܬܵ‌ܐ، ܡܵܛܵܠܵܐ ܘܣܲܝܦܵܐ ܘܙܲܝܢܵܐ ܕܦܠܵܫܵܐ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","ܫܲܦ̮ܩܵܢܵܐ ܝܘܸܬ ܐܲܢ݇ܬ، ܒܘܼܫ ܡܫܘܼܒܚܵܐ ܡ̣ܢ ܛܘܼܪ̈ܵܢܹܐ ܐܲܝܟܵܐ ܕܦܘܼܪܦܸܛ ܠܘܼܟ݂ ܠܕܸܫ̃ܡܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","ܦܝܼܫ ܠܗܘܿܢ ܣܠܝܼܒܹܐ ܙܲܪ̈ܒܵܢܹܐ ܕܠܸܒܵܐ، ܛܡܝܼܪܗܘܿܢ ܒܫܸܢܬܵܝܗ‌ܝ، ܘܐܘܼܦ ܚܲܕ ܡ̣ܢ ܩܪ̈ܲܒ݂ܬܵܢܹܐ ܠܵܐ ܡܨܹܐ ܠܗܘܿܢ ܡܲܪܡܝܼ ܐܝܼܕܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","ܡ̣ܢ ܢܓ̰ܵܘܬܘܼܟ݂، ܝܵܐ ܐܲܠܵܗܵܐ ܕܝܲܥܩܘܿܒ݂، ܥܒ݂ܝܼܪܗܘܿܢ ܒܫܸܢܬܵ‌ܐ ܝܲܩܘܼܪܬܵ‌ܐ، ܐܘܼܦ ܪܲܟܵܒ݂ܵܐ ܐܘܼܦ ܣܘܼܣܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","ܐܲܢ݇ܬ، ܣܲܗܡܵܢܵܐ ܝܘܸܬ، ܐܲܢ݇ܬ، ܘܡܵܢܝܼ ܡܵܨܹܐ ܟܵܠܹܐ ܩܲܕܡܘܼܟ݂ ܒܥܕܵܢܵܐ ܕܚܸܡܬܘܼܟ݂؟ ");
INSERT INTO aii_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","ܡ̣ܢ ܫܡܲܝܵܐ ܡܘܼܫܡܸܥ ܠܘܼܟ݂ ܕܝܼܘܵܢ، ܙܕܝܼܥ ܠܵܗ̇ ܐܲܪܥܵܐ ܘܗܘܹܐ ܠܵܗ̇ ܫܠܝܼܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","ܟܲܕ ܩܝܼܡ ܠܹܗ ܐܲܠܵܗܵܐ ܠܕܝܼܘܵܢ، ܠܦܲܪܘܼܩܹܐ ܟܠܵܝܗ‌ܝ ܡܘܼܠܝܸܨܹܐ ܕܐܲܪܥܵܐ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","ܣܵܒܵܒ ܚܸܡܬܘܼܟ݂ ܠܒܲܪܢܵܫܵܐ ܒܸܬ ܡܲܝܬܝܵܐ ܫܲܟܲܪܬܵ‌ܐ، ܘܦܵܝܫܵܢܬܵ‌ܐ ܕܚܸܡܬܵ‌ܐ ܒܸܬ ܡܲܟܠܹܝܬ. ");
INSERT INTO aii_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","ܢܕܘܿܪܘܼܢ ܘܬܲܡܸܡܘܼܢ ܠܗܘܿܢ ܠܡܵܪܝܵܐ ܐܲܠܵܗܵܘܟ݂ܘܿܢ، ܟܠܵܝܗ‌ܝ ܕܝܼܢܵܐ ܠܚܵܕܸܪ̈ܘܵܢܘܼܗ‌ܝ ܠܲܒܠܝܼ ܕܲܫܢܹ̈ܐ ܠܣܲܗܡܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","ܒܸܬ ܩܵܛܹܥ ܪܘܼܚܵܐ ܕܫܲܠܝܼܛܵܢܹ̈ܐ، ܣܲܗܡܵܢܵܐ ܝܠܹܗ ܥܲܠ ܡܲܠܟܹ̈ܐ ܕܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","ܟܹܐ ܕܵܪܹܝܢ ܩܵܠܹ̈ܐ ܠܐܲܠܵܗܵܐ، ܘܒܸܬ ܡܲܩܘܸܚܸܢ، ܟܹܐ ܕܵܪܹܝܢ ܩܵܠܹ̈ܐ ܠܐܲܠܵܗܵܐ، ܘܒܸܬ ܝܵܗܒܹܠܔ ܢܵܬܵ‌ܐ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","ܒܝܵܘܡܵܐ ܕܥܵܘܩܵܢܝܼ ܠܡܵܪܝܵܐ ܛܥܹܐ ܠܝܼ، ܐܝܼܕܝܼ ܒܠܲܝܠܹܐ ܦܝܼܫ ܠܵܗ̇ ܦܘܼܫܸܛܬܵ‌ܐ ܘܠܵܐ ܬܒ݂ܝܼܢܵܗ̇، ܡܘܼܚܦܸܠܔ ܠܵܗ̇ ܠܸܫܩܵܠܵܐ ܠܸܒܵܐ ܓܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","ܟܹܐ ܕܵܟ݂ܪܹܢ ܠܐܲܠܵܗܵܐ ܘܟܹܐ ܢܲܟܢܸܟܸܢ، ܟܹܐ ܗܲܓܹܝܢ ܘܦܝܼܫ ܠܵܗ̇ ܕܘܼܪܕܸܫ̃ܬܵ‌ܐ ܪܘܼܚܝܼ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","ܠܵܐ ܫܒ݂ܝܼܩ ܠܘܼܟ݂ ܐܵܟ̰ܡܝܼ ܛܸܠܦܵܦܝܼ̈، ܦܝܼܫ ܠܝܼ ܫܓ݂ܝܼܫܵܐ ܗܵܕܵܐ ܕܠܹܐ ܡܵܨܹܝܢ ܗܲܡܙܸܡܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","ܬܘܼܚܡܸܢܝܼ ܒܘܼܬ ܝܵܘܡܵܢܹ̈ܐ ܥܲܬܝܼܩܹ̈ܐ، ܫܸܢܹ̈ܐ ܕܥܵܠܡܝܼܢ. ");
INSERT INTO aii_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","ܒܸܕܟ݂ܵܪܵܐ ܝܘܸܢ ܙܡܵܪܬ‌ܝܼ ܒܠܲܝܠܹܐ، ܒܠܸܒܝܼ ܟܹܐ ܗܲܓܹܝܢ ܘܟܹܐ ܨܲܚܨܝܼܵܐ ܪܘܼܚܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","ܗܵܐ، ܒܸܬ ܪܲܦܹܐ ܠܝܼ ܡܵܪܝܵܐ ܠܥܵܠܡܝܼܢ، ܘܠܹܐ ܡܲܙܝܸܕ ܗܸܢܝܵܢܹܗ ܡܸܢܕܪܸܫ؟ ");
INSERT INTO aii_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","ܗܵܐ، ܫܠܹܐ ܠܵܗ̇ ܠܥܵܠܲܡ ܛܲܝܒܘܼܬܹܗ، ܬܝܼܡ ܠܹܗ ܩܵܘܠܹܗ ܠܕܵܪܵܐ ܘܕܵܪܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","ܗܵܐ، ܡܘܼܢܫܹܐ ܠܹܗ ܠܸܥܒ݂ܵܕܵܐ ܪ̈ܲܚܡܹܐ ܐܲܠܵܗܵܐ، ܝܲܢ ܒܚܸܡܬܵ‌ܐ ܚܣܝܼܟ݂ܵܝ ܠܹܗ ܪ̈ܲܚܡܘܼܗ‌ܝ؟ ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","ܘܐܡܝܼܪܝܼ: ”ܒܸܒܙܵܥܵܐ ܝܠܹܗ ܠܸܒܝܼ ܒܘܼܬ ܫܲܚܠܲܦܬܵ‌ܐ ܕܝܲܡܝܼܢܵܐ ܕܥܸܠܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","”ܒܸܬ ܡܲܕܟܸܪܸܢ ܥܒ݂ܵܕܹ̈ܐ ܕܡܵܪܝܵܐ، ܗܹܐ، ܒܸܬ ܕܵܟ݂ܪܹܢ ܕܘܼܡܵܪ̈ܘܼܟ݂ ܡ̣ܢ ܙܲܒ݂ܢܵܐ ܩܲܕܝܼܡܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","”ܘܒܸܬ ܗܲܓܹܝܢ ܟܠܹܗ ܦܘܼܠܚܵܢܘܼܟ݂، ܘܒܘܼܬ ܥܒ݂ܵܕܘܼ̈ܟ݂ ܒܸܬ ܬܲܚܡܸܢܸܢ.“ ");
INSERT INTO aii_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","ܝܵܐ ܐܲܠܵܗܵܐ، ܒܩܲܕܝܼܫܘܼܬܵ‌ܐ ܝܠܵܗ̇ ܐܘܼܪܚܘܼܟ݂؛ ܡܵܢܝܼ ܝܠܹܗ ܐܲܠܵܗܵܐ ܓܘܼܪܵܐ ܐܲܝܟ݂ ܐܲܠܵܗܲܢ؟ ");
INSERT INTO aii_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","ܐܲܢ݇ܬ ܝܼܘܸܬ ܐܲܠܵܗܵܐ ܥܵܒ݂ܕܵܢܹ̈ܐ ܕܕܘܼܡܵܪܹ̈ܐ، ܡܘܼܕܸܥ ܠܘܼܟ݂ ܓܵܘ ܥܲܡܡܹ̈ܐ ܚܲܝܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","ܦܘܼܪܸܩ ܠܘܼܟ݂ ܒܕܪܲܥܢܘܼܟ݂ ܠܥܲܡܘܼܟ݂، ܒܢܲܝ̈ ܝܲܥܩܘܿܒ݂ ܘܝܵܘܣܸܦ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","ܚܙܹܐ ܠܗܘܿܢ ܐܸܠܘܼܟ݂ ܡ̈ܝܼܵܐ، ܝܵܐ ܐܲܠܵܗܵܐ، ܚܙܹܐ ܠܗܘܿܢ ܐܸܠܘܼܟ݂ ܡ̈ܝܼܵܐ ܘܪܘܼܬܪܸܬ ܠܗܘܿܢ، ܐܘܼܦ ܪܓܝܼܕ ܠܗܘܿܢ ܬܗܘܿܡܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","ܥܢܵܢܹ̈ܐ ܫܘܼܦܸܟ݂ ܠܗܘܿܢ ܡ̈ܝܼܵܐ، ܩܘܼܪܩܸܡ ܠܗܘܿܢ ܫܡܲܝܹ̈ܐ، ܐܘܼܦ ܓܹܐܪ̈ܘܼܟ݂ ܣܛܹܐ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","ܩܵܠܵܐ ܕܩܲܪ̈ܩܲܡܝܵܬܘܼܟ݂ ܒܓܵܪܕܵܒܘܼܠܹܐ، ܒܘܼܗܪܸܢܗܘܿܢ ܒܸܪ̈ܩܹܐ ܠܒܪܝܼܬܵ‌ܐ، ܪܓܝܼܕ ܠܵܗ̇ ܘܕܘܼܪܘܸܕ ܠܵܗ̇ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","ܒܝܵܡܵܐ ܝܼܗܘܵܐ ܐܘܼܪܚܘܼܟ݂، ܘܫܒ݂ܝܼܠܘܼܟ݂ ܝܼܗܘܵܐ ܒܡ̈ܝܼܵܐ ܪܵܒܵܐ، ܘܫܵܘܦܵܦܹ̈ܐ ܕܐܲܩܠܘܼ̈ܟ݂ ܠܵܐ ܦܝܼܫ ܠܗܘܿܢ ܚܸܙܝܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","ܡܗܘܼܕܹܐ ܠܘܼܟ݂ ܐܲܝܟ݂ ܥܸܪ̈ܒܹܐ ܠܥܲܡܘܼܟ݂، ܒܐܝܼܕܵܐ ܕܡܘܼܫܹܐ ܘܕܐܲܗܪܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","ܗܲܒ݂ܠܔ ܢܵܬܵ‌ܐ، ܝܵܐ ܥܲܡܝܼ، ܠܢܵܡܘܿܣܝܼ، ܨܲܠܹܝܡܘܼܢ ܢܵܬܵܘܟ݂ܘܿܢ ܠܗܹܡܸܙܡܵܢܹ̈ܐ ܕܦܘܼܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","ܒܸܬ ܦܵܬܚܹܢ ܒܡܲܬܠܵܐ ܦܘܼܡܝܼ، ܒܸܬ ܡܲܢܒܸܥܸܢ ܩܸܨܸܡ̈ܝܵܬܹ‌ܐ ܡ̣ܢ ܙܲܒ݂ܢܹ̈ܐ ܩܲܕܝܼܡܵܝܹ̈ܐ، ");
INSERT INTO aii_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","ܐܲܝܢܝܼ ܕܫܡܝܼܥ ܠܲܢ ܘܝܕܝܼܥܵܝ ܠܲܢ، ܘܐܲܒ݂ܵܗܵܬܲܢ̈ ܗܘܼܩܹܐ ܠܗܘܿܢ ܐܸܠܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","ܠܹܐ ܛܲܫܲܚ ܠܗܘܿܢ ܡ̣ܢ ܒܢܘܿܢܵܝ̈ܗ‌ܝ، ܠܬܵܘܠܲܕܬܵ‌ܐ ܐܚܹܪܬܵ‌ܐ ܗܲܩܘܼܝܹܐ ܬܸܫܒܘܿܚܝܵܬܹ̈‌ܐ ܕܡܵܪܝܵܐ، ܘܚܲܝܠܹܗ ܘܥܲܓ̰ܝܼܒܘܼܝܵܬܘܼ̈ܗ‌ܝ ܕܥܒ݂ܝܼܕ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","ܒܗ̇ܝ ܕܡܘܼܩܸܡ ܠܹܗ ܣܵܗܕܘܼܬܵ‌ܐ ܓܵܘ ܝܲܥܩܘܿܒ݂، ܘܢܵܡܘܿܣܵܐ ܡܘܼܬܸܒ݂ ܠܹܗ ܓܵܘ ܐܝܼܣܪܵܐܹܝܠܔ، ܕܦܩܝܼܕ ܠܹܗ ܠܐܲܒ݂ܵܗܵܬܲܢ̈، ܠܡܲܕܘܼܥܵܝ ܠܒܢܘܿܢܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","ܩܵܐ ܕܝܵܕܥܵܐ ܬܵܘܠܲܕܬܵ‌ܐ ܐܚܹܪܬܵ‌ܐ، ܒܢܘܿܢܹ̈ܐ ܕܦܵܝܫܝܼ ܝܠܝܼܕܹܐ، ܩܵܝܡܝܼ ܘܗܲܩܝܼ ܠܒܢܘܿܢܵܝ̈ܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","ܕܡܲܬܒ݂ܝܼ ܒܐܲܠܵܗܵܐ ܬܘܼܟ݂ܠܵܢܵܝܗ‌ܝ، ܘܠܵܐ ܢܵܫܝܼ ܦܘܼܠܚܵܢܹ̈ܐ ܕܐܲܠܵܗܵܐ، ܐܝܼܢܵܐ ܢܵܛܪܝܼ ܠܗܘܿܢ ܦܘܼܩܕܵܢܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","ܘܠܵܐ ܗܵܘܝܼ ܐܲܝܟ݂ ܐܲܒ݂ܵܗܵܬܵܝ̈ܗ‌ܝ، ܬܵܘܠܲܕܬܵ‌ܐ ܩܫܝܼܬܵ‌ܐ ܘܡܵܪܘܿܕܬܵ‌ܐ، ܬܵܘܠܲܕܬܵ‌ܐ ܕܠܵܐ ܡܘܼܩܘܹܐ ܠܵܗ̇ ܠܸܒܘܼܗ̇، ܘܠܵܐ ܗܘܹܐ ܠܵܗ̇ ܪܘܼܚܘܼܗ̇ ܡܗܘܼܡܸܢܬܵ‌ܐ ܒܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","ܒܢܲܝ̈ ܐܲܦܪܹܝܡ ܟ̰ܘܼܟܒܸܢܹ̈ܐ، ܕܵܪ̈ܝܵܢܹܐ ܕܩܸܫܬܵ‌ܐ، ܐܝܼܢܵܐ ܕܝܼܪܗܘܿܢ ܠܒܵܬܪܵܐ ܒܝܵܘܡܵܐ ܕܦܠܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","ܠܵܐ ܢܛܝܼܪܗܘܿܢ ܘܲܥܕܵܐ ܕܐܲܠܵܗܵܐ، ܘܡܘܼܚܦܸܠܔ ܠܗܘܿܢ ܠܸܚܕܵܪܵܐ ܒܢܵܡܘܿܣܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","ܘܢܫܹܐ ܠܗܘܿܢ ܦܘܼܠܚܵܢܘܼ̈ܗ‌ܝ، ܘܕܘܼܡܵܪ̈ܘܼܗ‌ܝ ܕܡܘܼܚܙܹܐ ܠܹܗ ܐܸܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","ܩܲܕܡ ܐܲܒ݂ܵܗܵܬܵܝ̈ܗ‌ܝ ܥܒ݂ܝܼܕ ܠܹܗ ܕܘܼܡܵܪܹ̈ܐ، ܒܐܲܪܥܵܐ ܕܡܸܨܪܹܝܢ، ܒܕܸܫܬܵ‌ܐ ܕܨܘܿܥܵܢ. ");
INSERT INTO aii_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","ܦܘܼܠܸܥ ܠܹܗ ܝܵܡܵܐ ܘܡܘܼܥܒܸܪܵܝ ܠܹܗ، ܘܡܘܼܟܠܹܐ ܠܹܗ ܡ̈ܝܼܵܐ ܐܲܝܟ݂ ܩܘܼܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","ܘܡܕܘܼܒܪܵܝ ܠܹܗ ܒܥܢܵܢܵܐ ܒܐܝܼܡܵܡܵܐ، ܘܟܠܹܗ ܠܲܝܠܹܐ ܒܒܲܗܪܵܐ ܕܢܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","ܟ̰ܠܝܼܦ ܠܹܗ ܐܝܼܨܵܪܹ̈ܐ ܓܵܘ ܒܲܪܝܼܵܐ، ܘܡܘܼܫܬܝܼܵܝ ܠܹܗ ܪܵܒܵܐ ܐܲܝܟ݂ ܕܡ̣ܢ ܬܗܘܿܡܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","ܘܦܘܼܠܸܛ ܠܹܗ ܫܵܩ̈ܝܼܵܬܹ‌ܐ ܡ̣ܢ ܩܵܝܵܐ، ܘܡܘܼܓ̰ܪܹܐ ܠܹܗ ܐܲܝܟ݂ ܢܲܗܪ̈ܵܘܵܬܹ‌ܐ ܡ̈ܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","ܐܝܼܢܵܐ ܡܘܼܙܝܸܕ ܠܗܘܿܢ ܡܸܢܕܪܸܫ ܠܸܚܛܵܝܵܐ ܥܲܠܘܼܗ‌ܝ، ܠܸܥܒ݂ܵܕܵܐ ܡܵܪܘܿܕܘܼܬܵ‌ܐ ܥܲܠܔ ܥܸܠܵܝܵܐ ܒܐܲܪܥܵܐ ܒܵܪܘܿܙܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","ܘܓ̰ܘܼܪܸܒ ܠܗܘܿܢ ܠܐܲܠܵܗܵܐ ܒܠܸܒܵܝܗ‌ܝ، ܠܸܛܠܵܒܵܐ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ ܩܵܐ ܓܵܢܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","ܘܗܘܼܡܙܸܡ ܠܗܘܿܢ ܥܲܠܔ ܐܲܠܵܗܵܐ، ܐܡܝܼܪܗܘܿܢ: ”ܗܵܐ، ܡܵܨܹܐ ܐܲܠܵܗܵܐ ܠܡܲܪܝܘܼܙܹܐ ܨܘܼܦܪܵܐ ܓܵܘ ܒܲܪܝܼܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","”ܗܵܐ، ܡܚܹܐ ܠܹܗ ܠܐܝܼܨܵܪܵܐ ܘܓ̰ܪܹܐ ܠܗܘܿܢ ܡ̈ܝܼܵܐ، ܘܫܵܩ̈ܝܼܵܬܹ‌ܐ ܫܦܝܼܟ݂ ܠܗܘܿܢ، ܗܵܐ، ܐܘܼܦ ܠܲܚܡܵܐ ܡܵܨܹܐ ܠܝܼܵܗܒ݂ܵܐ؟ ܝܲܢ ܡܵܨܹܐ ܗܲܕܸܪ ܒܸܣܪܵܐ ܩܵܐ ܥܲܡܹܗ؟“ ");
INSERT INTO aii_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","ܒܘܼܬ ܐܵܗܵܐ، ܫܡܝܼܥ ܠܹܗ ܡܵܪܝܵܐ ܘܟܪܝܼܒ ܠܹܗ، ܘܢܘܼܪܵܐ ܬܦܹܐ ܠܹܗ ܒܝܲܥܩܘܿܒ݂، ܘܟܲܪܒܵܐ ܐܣܝܼܩ ܠܵܗ̇ ܥܲܠܔ ܐܝܼܣܪܵܐܹܝܠܔ، ");
INSERT INTO aii_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","ܣܵܒܵܒ ܠܵܐ ܗܘܼܡܸܢܗܘܿܢ ܒܐܲܠܵܗܵܐ، ܘܠܵܐ ܣܒܝܼܪܗܘܿܢ ܒܦܘܼܪܩܵܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","ܐܝܼܢܵܐ ܦܩܝܼܕ ܠܹܗ ܠܥܢܵܢܹ̈ܐ ܡ̣ܢ ܥܸܠܸܠܔ، ܘܦܬܝܼܚ ܠܹܗ ܬܲܪ̈ܥܵܢܹܐ ܕܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","ܘܡܘܼܪܥܹܐ ܠܹܗ ܥܲܠܵܝܗ‌ܝ ܡܲܢܢܵܐ ܠܹܐܟ݂ܵܠܵܐ، ܘܕܲܚܠܵܐ ܕܫܡܲܝܵܐ ܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","ܠܲܚܡܵܐ ܕܡܲܠܲܐܟܹ̈ܐ ܐܟ݂ܝܼܠܔ ܠܹܗ ܐܢܵܫܵܐ، ܙܘܵܕܹ̈ܐ ܫܘܼܕܸܪܹܗ ܐܸܠܵܝܗ‌ܝ ܠܸܣܒ݂ܵܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","ܡܘܼܡܚܹܐ ܠܹܗ ܦܵܘܚܵܐ ܕܡܲܕܢܚܵܐ ܒܫܡܲܝܵܐ، ܘܡܕܘܼܒܸܪܹܗ ܒܚܲܝܠܹܗ ܦܵܘܚܵܐ ܕܬܲܝܡܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","ܡܘܼܪܥܹܐ ܠܹܗ ܥܲܠܵܝܗ‌ܝ ܒܸܣܪܵܐ ܐܲܝܟ݂ ܥܲܦܪܵܐ، ܘܛܲܝܪܵܐ ܡܵܪܹܐ ܓܘܼܠܦܵܐ ܐܲܝܟ݂ ܣܹܠܵܐ ܕܝܵܡܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","ܕܪܹܐ ܠܹܗ ܒܓܵܘܵܐ ܕܡܲܫܪܝܼܬܵܝܗ‌ܝ، ܠܚܵܕܸܪ̈ܘܵܢܹܐ ܕܡܲܫܟܢܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","ܘܐܟ݂ܝܼܠܔ ܠܗܘܿܢ ܘܣܒ݂ܝܼܥ ܠܗܘܿܢ ܪܵܒܵܐ، ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܫܲܗܘܲܬܬܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","ܘܟܲܕ ܠܵܐ ܦܪܝܼܩܹܐ ܡ̣ܢ ܫܲܗܘܲܬܬܵܝܗ‌ܝ، ܗܸܫ ܡܹܐܟ݂ܘܼܠܬܵܝܗ‌ܝ ܓܵܘ ܦܘܼܡܵܝܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","ܟܲܪܒܵܐ ܕܐܲܠܵܗܵܐ ܐܣܝܼܩ ܠܵܗ̇ ܥܲܠܵܝܗ‌ܝ، ܘܩܛܝܼܠܔ ܠܹܗ ܡ̣ܢ ܓܲܒܵܪ̈ܵܝܗ‌ܝ، ܘܠܥܠܲܝܡܹ̈ܐ ܕܐܝܼܣܪܵܐܹܝܠܔ ܡܘܼܟܸܦ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","ܒܟܠܹܗ ܐܵܗܵܐ ܚܛܹܐ ܠܗܘܿܢ ܡܸܢܕܪܸܫ، ܘܠܵܐ ܗܘܼܡܸܢܗܘܿܢ ܒܥܲܓ̰ܝܼܒܘܼܝܵܬܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","ܘܬܝܼܡܵܝ ܠܹܗ ܝܵܘܡܵܢܵܝ̈ܗ‌ܝ ܒܣܪܝܼܩܘܼܬܵ‌ܐ، ܘܫܸܢܵܝ̈ܗ‌ܝ ܒܣܘܼܪܵܕܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","ܐܝܼܡܲܢ ܕܩܛܝܼܠܵܝ ܠܹܗ، ܛܥܹܐ ܠܗܘܿܢ ܐܸܠܹܗ، ܘܕܝܼܪܗܘܿܢ ܘܩܘܼܕܸܡ ܠܗܘܿܢ ܠܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","ܕܟ݂ܝܼܪܗܘܿܢ ܕܐܲܠܵܗܵܐ ܝܗܘܵܐ ܐܝܼܨܵܪܵܝܗ‌ܝ، ܘܐܲܠܵܗܵܐ ܥܸܠܵܝܵܐ ܝܗܘܵܐ ܦܵܪܘܿܩܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","ܐܝܼܢܵܐ ܫܘܼܕܸܠܔ ܠܗܘܿܢ ܐܸܠܹܗ ܒܦܘܼܡܵܝܗ‌ܝ، ܘܒܠܸܫܵܢܵܝܗ‌ܝ ܕܘܼܓܸܠܔ ܠܗܘܿܢ ܐܸܠܹܗ، ");
INSERT INTO aii_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","ܣܵܒܵܒ ܠܸܒܵܝܗ‌ܝ ܠܹܐ ܝܗܘܵܐ ܡܩܵܘܝܵܢܵܐ ܥܲܡܹܗ، ܐܘܼܦ ܠܹܐ ܝܗܘܵܘ ܡܗܘܼܡܢܹ̈ܐ ܒܘܲܥܕܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","ܐܝܼܢܵܐ ܗ̇ܘ ܡܪܲܚܡܵܢܵܐ ܦܘܼܚܸܠܔ ܠܹܗ ܥܵܘܠܵܝܗ‌ܝ ܘܠܵܐ ܡܘܼܚܪܸܒ݂ܵܝ ܠܹܗ، ܘܡܘܼܙܝܸܕ ܠܹܗ ܠܡܲܕܘܼܪܹܐ ܟܲܪܒܹܗ، ܘܠܵܐ ܡܘܼܪܥܸܫ ܠܹܗ ܟܠܵܗ̇ ܚܸܡܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","ܘܕܟ݂ܝܼܪܹܗ ܕܒܸܣܪܵܐ ܝܗܘܵܘ ܐܵܢܝܼ، ܦܵܘܚܵܐ ܕܐܵܙܹܠܔ ܘܠܹܐ ܕܵܐܹܪ. ");
INSERT INTO aii_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","ܟܡܵܐ ܥܒ݂ܝܼܕ ܠܗܘܿܢ ܡܵܪܘܿܕܘܼܬܵ‌ܐ ܐܸܠܹܗ ܓܵܘ ܒܲܪܝܼܵܐ، ܩܵܡ ܡܲܟܪܸܒܝܼ ܠܹܗ ܓܵܘ ܒܲܝܵܒܵܢ. ");
INSERT INTO aii_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","ܘܕܝܼܪܗܘܿܢ ܘܓ̰ܘܼܪܸܒ ܠܗܘܿܢ ܠܐܲܠܵܗܵܐ، ܘܠܩܲܕܝܼܫܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ ܡܘܼܦܫܸܡ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","ܠܵܐ ܕܟ݂ܝܼܪܗܘܿܢ ܐܝܼܕܹܗ، ܝܵܘܡܵܐ ܕܦܘܼܪܩܵܝ ܠܹܗ ܡ̣ܢ ܡܲܠܝܸܨܵܢܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","ܐܝܼܡܲܢ ܕܡܘܼܬܸܒ݂ ܠܹܗ ܒܡܸܨܪܹܝܢ ܢܝܼܫܲܢܩܘܼ̈ܗ‌ܝ، ܘܥܲܓ̰ܝܼܒܘܼܝܵܬܘܼ̈ܗ‌ܝ ܓܵܘ ܕܸܫܬܵ‌ܐ ܕܨܘܿܥܵܢ، ");
INSERT INTO aii_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","ܘܡܘܼܚܕܸܪܹܗ ܠܕܸܡܵܐ ܢܲܗܪ̈ܵܘܵܬܵܝܗ‌ܝ ܘܫܵܩܝܼܵܬܵܝ̈ܗ‌ܝ، ܕܠܵܐ ܡܵܨܝܼ ܫܵܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","ܫܘܼܕܸܪܹܗ ܥܲܠܵܝܗ‌ܝ ܕܸܒܘܼܪܬܵ‌ܐ ܘܩܵܡ ܐܵܟ݂ܠܵܐ ܠܗܘܿܢ، ܘܦܸܩܵܐ ܘܩܵܡ ܡܲܚܪܸܒ݂ܵܐ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","ܝܘܼܗܒܹܠܔ ܠܹܗ ܠܬܸܪܬܸܪܵܐ ܛܥܘܼܢܬܵܝܗ‌ܝ، ܘܓ̰ܵܦܵܝܗ‌ܝ ܠܩܲܡܨܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","ܩܛܝܼܠܔ ܠܹܗ ܒܒܲܪܕܵܐ ܓܸܦܝܵܬܵܝ̈ܗ‌ܝ، ܘܫܲܩܡܵܝ̈ܗ‌ܝ ܒܛܠܘܼܠܵܐ ܡܘܼܓܕܸܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","ܣܘܼܦܹܐ ܠܹܗ ܠܒܲܪܕܵܐ ܒܥܝܼܪܵܝܗ‌ܝ، ܘܩܸܢܝܵܢܵܝ̈ܗ‌ܝ ܠܒܸܪ̈ܩܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","ܫܘܼܕܸܪܹܗ ܥܲܠܵܝܗ‌ܝ ܚܸܡܬܵ‌ܐ ܕܟܲܪܒܹܗ، ܚܸܡܬܵ‌ܐ، ܟܲܪܒܵܐ، ܘܐܘܼܠܨܵܢܵܐ، ܡܫܲܕܪܹ̈ܐ ܕܡܲܠܲܐܟܹ̈ܐ ܕܣܸܪ̈ܝܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","ܡܘܼܫܘܹܐ ܠܹܗ ܫܒ݂ܝܼܠܵܐ ܠܟܲܪܒܹܗ، ܠܵܐ ܚܣܝܼܟ݂ ܠܹܗ ܡ̣ܢ ܡܵܘܬܵ‌ܐ ܓܵܢܵܝܗ‌ܝ، ܐܸܠܵܐ ܚܲܝܵܝ̈ܗ‌ܝ ܠܡܵܘܬܵܢܵܐ ܣܘܼܦܹܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","ܡܚܹܐ ܠܹܗ ܟܠܔ ܒܘܼܟ݂ܪܵܐ ܓܵܘ ܡܸܨܪܹܝܢ، ܪܹܝܫܝܼܬܵ‌ܐ ܕܥܘܼܫܢܵܝ̈ܗ‌ܝ ܓܵܘ ܡܲܫܟܢܵܐ ܕܚܵܡ. ");
INSERT INTO aii_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","ܘܦܘܼܠܸܛ ܠܹܗ ܠܥܲܡܹܗ ܐܲܝܟ݂ ܥܸܪ̈ܒܹܐ، ܘܡܕܘܼܒܪܵܝ ܠܹܗ ܐܲܝܟ݂ ܦܸܣܩܵܐ ܓܵܘ ܒܲܪܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","ܘܡܗܘܼܕܝܵܝ ܠܹܗ ܒܫܲܝܢܵܐ ܗܵܕܵܐ ܕܠܵܐ ܙܕܝܼܥ ܠܗܘܿܢ، ܐܝܼܢܵܐ ܠܕܸܫ̃ܡܸܢܵܝ̈ܗ‌ܝ ܟܘܼܣܹܐ ܠܵܗ̇ ܝܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","ܘܡܘܼܝܬܵܝ ܠܹܗ ܠܬܚܘܼܡܵܐ ܕܩܘܼܕܫܹܗ، ܛܘܼܪܵܐ ܕܩܢܹܐ ܠܵܗ̇ ܝܲܡܝܼܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","ܘܛܪܝܼܕ ܠܹܗ ܡ̣ܢ ܩܲܕܡܵܝܗ‌ܝ ܐܸܡܘܵܬܹ̈‌ܐ، ܘܦܘܼܠܸܥ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܵܪܬܘܼܬܵ‌ܐ ܒܟܝܘܼܠܵܐ، ܘܡܘܼܫܪܹܐ ܠܹܗ ܒܡܲܫܟܢܵܝ̈ܗ‌ܝ ܫܲܒ݂ܛܹ̈ܐ ܕܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","ܐܝܼܢܵܐ ܓ̰ܘܼܪܸܒ ܠܗܘܿܢ ܘܥܒ݂ܝܼܕ ܠܗܘܿܢ ܡܵܪܘܿܕܘܼܬܵ‌ܐ ܥܲܠܔ ܐܲܠܵܗܵܐ ܥܸܠܵܝܵܐ، ܘܣܵܗܕܘܵܬܘܼ̈ܗ‌ܝ ܠܵܐ ܢܛܝܼܪܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","ܘܩܠܝܼܒ ܠܗܘܿܢ ܘܥܒ݂ܝܼܕ ܠܗܘܿܢ ܚܵܝܝܼܢܘܼܬܵ‌ܐ ܐܲܝܟ݂ ܐܲܒ݂ܵܗܵܬܵܝ̈ܗ‌ܝ، ܦܟ̰ܝܼܠܔ ܠܗܘܿܢ ܐܲܝܟ݂ ܩܸܫܬܵ‌ܐ ܦܠܝܼܡܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","ܘܡܘܼܟܪܸܒ ܠܗܘܿܢ ܐܸܠܹܗ ܒܘܼܬ ܕܘܼܟܵܢܵܝ̈ܗ‌ܝ ܪ̈ܵܡܹܐ، ܘܒܨܲܠܡܵܝ̈ܗ‌ܝ ܩܵܡ ܡܲܥܒܸܪܝܼ ܠܹܗ ܒܛܢܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","ܫܡܝܼܥ ܠܹܗ ܐܲܠܵܗܵܐ ܘܟܪܝܼܒ ܠܹܗ، ܘܡܘܼܣܠܹܐ ܠܹܗ ܪܵܒܵܐ ܠܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","ܘܫܒ݂ܝܼܩ ܠܹܗ ܡܲܫܟܢܵܐ ܕܫܝܼܠܘܿ، ܡܛܲܠܠܵܐ ܕܡܘܼܫܪܹܐ ܠܹܗ ܒܹܝܠܔ ܒܢܲܝ̈ܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","ܘܣܘܼܦܹܐ ܠܹܗ ܠܓܵܠܘܼܬܵ‌ܐ ܚܲܝܠܹܗ، ܘܚܸܩܪܹܗ ܒܐܝܼܕܵܐ ܕܡܲܠܝܸܨܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","ܘܣܘܼܦܹܐ ܠܹܗ ܥܲܡܹܗ ܠܣܲܝܦܵܐ، ܘܠܝܵܪܬܘܼܬܹܗ ܟܪܝܼܒ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","ܥܠܲܝܡܵܝ̈ܗ‌ܝ ܩܵܡ ܐܵܟܹܠܔ ܠܗܘܿܢ ܢܘܼܪܵܐ، ܘܒܬܘܼܠܵܬܵܝ̈ܗ‌ܝ ܠܵܐ ܦܝܼܫ ܠܗܘܿܢ ܚܩܝܼܪܹܐ ܒܓܒ݂ܵܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","ܟܵܗܢܵܝ̈ܗ‌ܝ ܒܣܲܝܦܵܐ ܢܦܝܼܠܔ ܠܗܘܿܢ، ܘܐܲܪ̈ܡܸܠܝܵܬܵܝܗ‌ܝ ܠܵܐ ܒܟܹܐ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","ܗ̇ܝܓܵܗ ܪܥܝܼܫ ܠܹܗ ܐܲܝܟ݂ ܛܠܝܼܥܵܐ ܡܵܪܝܵܐ، ܐܲܝܟ݂ ܓܲܒܵܪܵܐ ܕܨܲܠܸܠܔ ܡ̣ܢ ܚܲܡܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","ܘܡܚܹܐ ܠܹܗ ܕܸܫ̃ܡܸܢܘܼ̈ܗ‌ܝ ܠܒܵܬܪܵܐ؛ ܠܵܘܡܵܐ ܕܠܥܵܠܲܡ ܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","ܘܡܘܼܣܠܹܐ ܠܹܗ ܠܡܲܫܟܢܵܐ ܕܝܵܘܣܸܦ، ܘܠܫܲܒ݂ܛܵܐ ܕܐܲܦܪܹܝܡ ܠܵܐ ܓܘܼܒܹܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","ܐܸܠܵܐ ܓܘܼܒܹܐ ܠܹܗ ܠܫܲܒ݂ܛܵܐ ܕܝܼܗܘܼܕܵܐ، ܠܛܘܼܪܵܐ ܕܨܸܗܝܘܿܢ ܕܟܹܐ ܡܲܚܸܒ. ");
INSERT INTO aii_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","ܘܒܢܹܐ ܠܹܗ ܐܲܝܟ݂ ܪ̈ܵܘܡܹܐ ܡܲܩܕܫܹܗ، ܐܲܝܟ݂ ܐܲܪܥܵܐ ܕܫܘܼܬܐܸܣ ܠܹܗ ܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","ܘܓܘܼܒܹܐ ܠܹܗ ܠܕܵܘܝܼܕ ܪܹܓܹܗ، ܘܩܵܡ ܫܵܩܹܠܔ ܠܹܗ ܡ̣ܢ ܓܘܼܡܵܢܹ̈ܐ ܕܥܸܪ̈ܒܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","ܡ̣ܢ ܒܵܬܪ ܘܲܥܢܹ̈ܐ ܡܲܡܸܨܵܢܹ̈ܐ ܩܵܡ ܡܲܝܬܹ‌ܐ ܠܹܗ، ܕܡܲܪܥܹܐ ܠܝܲܥܩܘܿܒ݂ ܥܲܡܹܗ، ܘܠܐܝܼܣܪܵܐܹܝܠܔ ܝܵܪܬܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","ܘܡܘܼܪܥܝܼܵܝ ܠܹܗ ܐܲܝܟ݂ ܬܲܡܝܼܡܘܼܬܵ‌ܐ ܕܠܸܒܹܗ، ܘܒܡܗܝܼܪܘܼܬܵ‌ܐ ܕܐܝܼܕܵܬܘܼ̈ܗ‌ܝ ܡܗܘܼܕܝܵܝ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","ܝܵܐ ܐܲܠܵܗܵܐ، ܥܒ݂ܝܼܪܗܘܿܢ ܐܸܡܘܵܬܹ̈‌ܐ ܠܓܵܘ ܝܵܪܬܘܼܬܘܼܟ݂، ܟ̰ܘܼܦܠܸܢܗܘܿܢ ܠܗܲܝܟܠܵܐ ܕܩܘܼܕܫܘܼܟ݂، ܡܘܼܚܕܸܪܵܐ ܠܗܘܿܢ ܐܘܿܪܸܫܠܸܡ ܠܚܵܪ̈ܵܒܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","ܝܘܼܗܒܹܠܔ ܠܗܘܿܢ ܫܠܲܕܵܐ ܕܪܹ̈ܓܵܘܵܬܘܼܟ݂ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ ܠܦܵܪܲܚܬܵ‌ܐ ܕܫܡܲܝܵܐ، ܒܸܣܪܵܐ ܕܙܲܕܝܼܩܘܼ̈ܟ݂ ܠܚܲܝܘܬܵ‌ܐ ܕܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","ܫܘܼܦܸܟ݂ ܠܗܘܿܢ ܕܸܡܵܝܗ‌ܝ ܐܲܝܟ݂ ܡ̈ܝܼܵܐ ܠܚܵܕܸܪ̈ܘܵܢܹܐ ܕܐܘܿܪܸܫܠܸܡ، ܘܠܲܝܬ ܗܘܵܐ ܩܵܒ݂ܪܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","ܗܘܹܐ ܠܲܢ ܠܵܘܡܵܐ ܠܫܒ݂ܵܒܲܢ̈، ܡܲܣܠܲܝܬܵ‌ܐ ܘܡܲܣܚܲܪܬܵ‌ܐ ܠܐܵܢܝܼ ܕܝܼܢܵܐ ܠܚܵܕܸܪ̈ܘܵܢܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","ܗܲܠܔ ܐܝܼܡܲܢ، ܝܵܐ ܡܵܪܝܵܐ؟ ܒܸܬ ܟܵܪܒܹܬ ܠܥܵܠܲܡ؟ ܒܸܬ ܝܵܩܹܕ ܐܲܝܟ݂ ܢܘܼܪܵܐ ܛܢܵܢܘܼܟ݂؟ ");
INSERT INTO aii_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","ܫܲܦܸܟ݂ ܚܸܡܬܘܼܟ݂ ܥܲܠܔ ܐܸܡܘܵܬܹ̈‌ܐ ܕܠܹܐ ܝܵܕܥܝܼ ܠܘܼܟ݂، ܘܥܲܠܔ ܡܲܠܟܘܵܬܹ̈‌ܐ ܕܒܫܸܡܘܼܟ݂ ܠܹܐ ܩܵܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","ܣܵܒܵܒ ܦܘܼܪܦܸܛ ܠܗܘܿܢ ܠܝܲܥܩܘܿܒ݂، ܘܠܕܘܼܝܵܪܹܗ ܡܘܼܚܪܸܒ݂ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","ܠܵܐ ܕܵܟ݂ܪܹܬ ܥܲܠܲܢ ܥܵܘ̈ܠܹܐ ܩܲܕܝܼܡܵܝܹ̈ܐ، ܡܲܠܝܸܙ ܠܡܲܬܦܘܼܩܹܐ ܒܝܼܲܢ ܪ̈ܲܚܡܘܼܟ݂، ܣܵܒܵܒ ܦܝܼܫ ܠܲܢ ܡܘܼܟܸܦܹܐ ܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","ܗܲܝܸܪܲܢ، ܝܵܐ ܐܲܠܵܗܵܐ ܕܦܘܼܪܩܵܢܲܢ، ܒܘܼܬ ܚܸܩܪܵܐ ܕܫܸܡܘܼܟ݂، ܘܦܲܨܝܼ ܠܲܢ ܘܥܒ݂ܘܿܕ ܚܘܼܣܵܝܵܐ ܥܲܠܔ ܚܛܝܼܵܬܲܢ̈ ܡ̣ܢ ܥܸܠܬܵ‌ܐ ܕܫܸܡܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","ܩܵܡܘܿܕܝܼ ܐܵܡܪܝܼ ܐܸܡܘܵܬܹ̈‌ܐ: ”ܐܲܝܟܵܐ ܝܠܹܗ ܐܲܠܵܗܵܝܗ‌ܝ؟“ ܫܒ݂ܘܿܩ ܩܲܕܡ ܥܲܝܢܲܢ̈ ܦܵܐܹܫ ܝܕܝܼܥܵܐ ܓܵܘ ܐܸܡܘܵܬܹ̈‌ܐ ܕܐܲܢ݇ܬ ܟܹܐ ܫܵܩܠܹܬ ܬܘܼܥܠܵܐ ܕܕܸܡܵܐ ܕܪܹ̈ܓܵܘܵܬܘܼܟ݂ ܕܦܝܼܫ ܠܹܗ ܫܘܼܦܟ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","ܐܵܬܝܵܐ ܩܲܕܡܘܼܟ݂ ܬܲܢܲܚܬܵ‌ܐ ܕܐܲܣܝܼܪܵܐ، ܒܪܲܒܘܼܬܵ‌ܐ ܕܕܪܲܥܢܘܼܟ݂ ܫܪܝܼ ܠܒܢܲܝ̈ ܡܵܘܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","ܘܡܲܕܸܪ ܠܥܘܼܒܵܐ ܕܫܒ݂ܵܒܲܢ̈ ܚܲܕ ܒܫܲܒ݂ܥܵܐ ܠܵܘܡܵܝܗ‌ܝ، ܗ̇ܘ ܕܩܵܡ ܠܵܝܡܝܼ ܠܘܼܟ݂ ܒܝܼܹܗ، ܝܵܐ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","ܘܐܲܚܢܲܢ ܐܢܵܫܘܼ̈ܟ݂ ܘܦܸܣܩܵܐ ܕܡܲܪܥܝܼܬܘܼܟ݂، ܒܸܬ ܫܲܟܪܲܚ ܠܘܼܟ݂ ܠܥܵܠܲܡ، ܠܕܵܪܵܐ ܘܕܵܪܵܐ ܒܸܬ ܗܲܩܲܚ ܬܸܫܒܘܿܚܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","ܝܵܐ ܪܵܥܝܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ، ܗܲܒ݂ܠܔ ܢܵܬܵ‌ܐ، ܝܵܐ ܡܕܲܒܪܵܢܵܐ ܕܝܵܘܣܸܦ ܐܲܝܟ݂ ܦܸܣܩܵܐ. ܝܵܐ ܝܵܬܒ݂ܵܢܵܐ ܒܹܝܠܔ ܟܪ̈ܘܿܒܹܐ، ܙܪܘܿܩ. ");
INSERT INTO aii_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","ܩܲܕܡ ܐܲܦܪܹܝܡ، ܘܒܸܢܝܵܡܹܝܢ، ܘܡܢܲܫܹܐ، ܡܲܪܥܸܫ ܠܓܲܒܵܪܘܼܬܘܼܟ݂، ܘܬܵ‌ܐ ܠܦܘܼܪܩܵܢܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","ܝܵܐ ܐܲܠܵܗܵܐ، ܡܲܕܸܪܲܢ، ܘܒܲܗܪܸܢ ܦܵܬܘܼܟ݂ ܕܦܵܝܫܲܚ ܦܘܼܪܩܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","ܝܵܐ ܡܵܪܝܵܐ ܐܲܠܵܗܵܐ ܚܲܝܠܬܵܢܵܐ، ܗܲܠܔ ܐܝܼܡܲܢ ܒܸܬ ܟܵܪܒܹܬ ܥܲܠܔ ܨܠܘܿܬܵ‌ܐ ܕܥܲܡܘܼܟ݂؟ ");
INSERT INTO aii_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","ܡܘܼܐܟ݂ܠܵܝ ܠܘܼܟ݂ ܠܲܚܡܵܐ ܕܕܸܡܥܝܼܬܵ‌ܐ، ܘܡܘܼܫܬܝܼܵܝ ܠܘܼܟ݂ ܕܸܡ̈ܥܹܐ ܒܟܝܘܼܠܵܐ ܓܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","ܥܒ݂ܝܼܕܲܚ ܠܘܼܟ݂ ܡܲܩܲܪܵܨܘܼܬܵ‌ܐ ܠܫܒ݂ܵܒܲܢ̈، ܘܒܹܝܠܵܝܗ‌ܝ ܡܘܼܣܚܸܪܗܘܿܢ ܕܸܫ̃ܡܸܢܲܢ̈ ܒܝܼܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","ܝܵܐ ܐܲܠܵܗܵܐ ܚܲܝܠܬܵܢܵܐ، ܡܲܕܸܪܲܢ، ܘܒܲܗܪܸܢ ܦܵܬܘܼܟ݂ ܕܦܵܝܫܲܚ ܦܘܼܪܩܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","ܓܸܦܬܵ‌ܐ ܡ̣ܢ ܡܸܨܪܹܝܢ ܦܘܼܠܛܵܐ ܠܘܼܟ݂، ܛܪܝܼܕ ܠܘܼܟ݂ ܠܐܸܡܘܵܬܹ̈‌ܐ ܘܢܨܝܼܒ݂ܵܐ ܠܘܼܟ݂ ܒܫܵܘܦܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","ܗܘܼܕܸܪܘܼܟ݂ ܥܲܦܪܘܼܗ̇، ܘܕܒ݂ܝܼܩ ܠܵܗ̇ ܥܸܩܪܘܼܗ̇، ܘܡܠܹܐ ܠܵܗ̇ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","ܦܝܼܫ ܠܗܘܿܢ ܡܘܼܟܣܹܐ ܛܘܼܪ̈ܵܢܹܐ ܡ̣ܢ ܛܸܠܵܢܝܼܬܘܼܗ̇، ܘܐܲܪ̈ܙܹܐ ܓܘܼܪܹ̈ܐ ܡ̣ܢ ܦܲܥܘܵܢܘܼ̈ܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","ܦܘܼܫܸܛ ܠܵܗ̇ ܦܲܥܘܵܢܘܼ̈ܗ̇ ܗܲܠܔ ܝܵܡܵܐ، ܘܦܪܝܼܣ ܠܵܗ̇ ܠܢܲܗܪܵܐ ܨܸܒܥܵܬܘܼ̈ܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","ܩܵܡܘܿܕܝܼ ܬܪܝܼܥ ܠܘܼܟ݂ ܣܝܵܓ݂ܘܼܗ̇، ܘܢܟ̰ܝܼܠܔ ܠܗܘܿܢ ܡܸܢܘܼܗ̇ ܟܠܵܝܗ‌ܝ ܥܵܒ݂ܪ̈ܵܢܹܐ ܕܐܘܼܪܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","ܐܟ݂ܵܠܵܐ ܒܹܐܟ݂ܵܠܘܼܗ̇ ܝܠܹܗ ܚܙܘܼܪܵܐ ܡ̣ܢ ܥܵܒ݂ܵܐ، ܘܓ̰ܵܘܓ̰ܵܢܹ̈ܐ ܕܕܸܫܬܵ‌ܐ ܒܸܪܥܵܝܘܼܗ̇ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","ܝܵܐ ܐܲܠܵܗܵܐ ܚܲܝܠܬܵܢܵܐ، ܕܘܼܪ ܐܵܕܝܼܵܐ، ܚܘܼܪ ܡ̣ܢ ܫܡܲܝܵܐ ܘܚܙܝܼ، ܘܣܲܚܒܸܪ ܠܐܵܗܵܐ ܓܸܦܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","ܠܥܸܩܪܵܐ ܕܢܨܝܼܒ݂ ܠܵܗ̇ ܝܲܡܝܼܢܘܼܟ݂، ܠܒܪܘܿܢܵܐ ܕܚܘܼܠܸܢܘܼܟ݂ ܩܵܐ ܓܵܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","ܡܘܼܩܸܕܬܵ‌ܐ ܝܠܵܗ̇ ܒܢܘܼܪܵܐ، ܦܪܝܼܡܬܵ‌ܐ ܝܠܵܗ̇، ܡ̣ܢ ܢܓ̰ܵܘܬܵ‌ܐ ܕܦܵܬܘܼܟ݂ ܟܹܐ ܛܵܠܩܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","ܗܵܘܝܵܐ ܐܝܼܕܘܼܟ݂ ܠܐܢܵܫܵܐ ܕܡ̣ܢ ܝܲܡܝܼܢܘܼܟ݂، ܠܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܕܚܘܼܠܸܢܘܼܟ݂ ܩܵܐ ܓܵܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","ܕܠܵܐ ܩܵܠܒܲܚ ܡܸܢܘܼܟ݂، ܡܲܚܹܝܬ ܠܲܢ، ܘܒܫܸܡܘܼܟ݂ ܒܸܬ ܩܵܪܲܚ. ");
INSERT INTO aii_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","ܝܵܐ ܡܵܪܝܵܐ ܐܲܠܵܗܵܐ ܚܲܝܠܬܵܢܵܐ، ܡܲܕܸܪܲܢ، ܒܲܗܪܸܢ ܦܵܬܘܼܟ݂ ܕܦܵܝܫܲܚ ܦܘܼܪܩܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","ܫܲܒܚܘܼܢ ܠܐܲܠܵܗܵܐ ܥܘܼܫܢܲܢ، ܩܲܘܸܚܘܼܢ ܠܐܲܠܵܗܵܐ ܕܝܲܥܩܘܿܒ݂. ");
INSERT INTO aii_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","ܡܲܪܡܘܼܢ ܙܡܵܪܬܵ‌ܐ ܘܡܚܹܝܡܘܼܢ ܦܠܲܓܵܐ، ܟܸܢܵܪܵܐ ܒܲܣܝܼܡܬܵ‌ܐ ܥܲܡ ܩܝܼܬܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","ܡܚܹܝܡܘܼܢ ܫܝܼܦܘܿܪܵܐ ܒܪܹܝܫ ܝܲܪܚܵܐ، ܒܡܸܠܝܘܼܬܵ‌ܐ ܕܣܲܗܪܵܐ، ܒܝܵܘܡܵܐ ܕܥܹܐܕܲܢ، ");
INSERT INTO aii_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","ܣܵܒܵܒ ܩܵܢܘܿܢܵܐ ܝܠܹܗ ܠܐܝܼܣܪܵܐܹܝܠܔ، ܕܝܼܘܵܢ ܕܐܲܠܵܗܵܐ ܕܝܲܥܩܘܿܒ݂. ");
INSERT INTO aii_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","ܩܵܡ ܡܲܬܸܒ݂ ܠܹܗ ܣܵܗܕܘܼܬܵ‌ܐ ܒܝܵܘܣܸܦ، ܟܲܕ ܦܠܝܼܛ ܠܹܗ ܥܲܠܔ ܐܲܪܥܵܐ ܕܡܸܨܪܹܝܢ. ܠܸܫܵܢܵܐ ܕܠܵܐ ܝܕܝܼܥ ܠܝܼ ܫܡܝܼܥ ܠܝܼ: ");
INSERT INTO aii_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","ܡܘܼܩܠܸܒ ܠܝܼ ܪܘܼܦ̮ܫܹܗ ܡ̣ܢ ܟܵܪܬܵ‌ܐ، ܫܪܹܐ ܠܝܼ ܐܝܼܕܵܬܘܼ̈ܗ‌ܝ ܡ̣ܢ ܩܸܪܛܵܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","ܓܵܘ ܐܘܼܠܨܵܢܵܐ ܩܪܹܐ ܠܘܼܟ݂ ܘܩܵܡ ܦܲܨܸܢܘܼܟ݂، ܩܵܡ ܓ̰ܲܘܸܒܸܢܘܼܟ݂ ܒܣܸܬܵܪܵܐ ܕܪܲܥܡܵܐ، ܩܵܡ ܒܵܚܪܹܢܘܼܟ݂ ܒܡ̈ܝܼܵܐ ܕܡܪܝܼܒ݂ܵܐ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","ܫܡܹܥ، ܝܵܐ ܥܲܡܝܼ، ܘܣܵܗܕܹܢ ܥܲܠܘܼܟ݂، ܝܵܐ ܐܝܼܣܪܵܐܹܝܠܔ، ܛܘܼܒ݂ܵܐ ܕܫܵܡܥܹܬ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","ܠܵܐ ܗܵܘܹܐ ܓܵܘܘܼܟ݂ ܐܲܠܵܗܵܐ ܩܵܪܝܼܒܵܝܵܐ، ܘܠܵܐ ܣܵܓ݂ܕܹܬ ܠܐܲܠܵܗܵܐ ܢܘܼܟ݂ܪܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","ܐܵܢܵܐ ܝܘܸܢ ܡܵܪܝܵܐ ܐܲܠܵܗܘܼܟ݂، ܕܩܵܡ ܡܲܐܣܩܸܢܘܼܟ݂ ܡ̣ܢ ܐܲܪܥܵܐ ܕܡܸܨܪܹܝܢ، ܦܬܘܿܚ ܠܹܗ ܦܘܼܡܘܼܟ݂ ܘܒܸܬ ܡܵܠܹܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","ܐܝܼܢܵܐ ܥܲܡܝܼ ܠܵܐ ܩܵܡ ܫܵܡܹܥ ܠܹܗ ܩܵܠܝܼ، ܘܐܝܼܣܪܵܐܹܝܠܔ ܠܵܐ ܒܥܹܐ ܠܹܗ ܡܲܨܝܸܬ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","ܒܘܼܬ ܐܵܗܵܐ، ܣܘܼܦܝܵܝ ܠܝܼ ܠܩܸܫܝܘܼܬܵ‌ܐ ܕܠܸܒܵܝܗ‌ܝ، ܕܚܵܕܪܝܼ ܒܚܘܼܫܵܒ݂ܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","ܛܘܼܒ݂ܵܐ ܕܥܲܡܝܼ ܫܵܡܹܥ ܗܘܵܐ ܐܸܠܝܼ، ܐܝܼܣܪܵܐܹܝܠܔ ܒܐܘܼܪ̈ܚܵܬ‌ܝܼ ܚܵܕܹܪ ܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","ܒܵܬܪ ܚܲܕܟ̰ܵܐ ܕܸܫ̃ܡܸܢܵܝ̈ܗ‌ܝ ܒܸܬ ܙܲܒܛܸܢܸܢ ܗܘܵܐ ܠܗܘܿܢ، ܘܥܲܠܔ ܡܲܠܝܸܨܵܢܵܝ̈ܗ‌ܝ ܒܸܬ ܡܲܕܸܪܸܢ ܗܘܵܐ ܐܝܼܕܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","ܣܵܢܝܵܢܹ̈ܐ ܕܡܵܪܝܵܐ ܒܸܬ ܫܵܠܡܝܼ ܗܘܵܘ ܐܸܠܹܗ، ܘܒܸܬ ܗܵܘܹܐ ܗܘܵܐ ܚܸܠܩܵܝܗ‌ܝ ܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","ܐܝܼܢܵܐ ܒܸܬ ܡܲܐܟ݂ܠܸܢ ܗܘܵܐ ܠܘܼܟ݂ ܡ̣ܢ ܫܲܡܝܼܢܘܼܬܵ‌ܐ ܕܚܸܛܹ̈ܐ، ܘܡ̣ܢ ܕܸܒ݂ܫܵܐ ܕܐܝܼܨܵܪܵܐ ܒܸܬ ܡܲܣܒܸܥܸܢ ܗܘܵܐ ܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","ܐܲܠܵܗܵܐ ܟܸܠܝܵܐ ܝܠܹܗ ܒܟܢܘܼܫܬܹܗ، ܒܓܵܘܵܐ ܕܐܲܠܵܗܹ̈ܐ ܒܸܕܝܵܢܵܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","”ܗܲܠܔ ܐܝܼܡܲܢ ܒܸܬ ܕܵܝܢܝܼܬܘܿܢ ܒܥܵܘܠܵܐ، ܘܚܵܙܹܝܬܘܿܢ ܦܵܬܵ‌ܐ ܠܪ̈ܲܫܝܼܥܹܐ؟ ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","”ܥܒ݂ܘܿܕܘܼܢ ܕܝܼܘܵܢ ܕܡܚܝܼܠܵܐ ܘܕܝܲܬܘܼܡܵܐ، ܠܡܘܼܠܝܸܨܵܐ ܘܠܡܸܣܟܹܢܵܐ ܥܒ݂ܘܿܕܘܼܢ ܗܵܩܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","”ܦܲܪܩܘܼܢ ܠܡܚܝܼܠܵܐ ܘܠܣܢܝܼܩܵܐ، ܡ̣ܢ ܐܝܼܕܵܐ ܕܪ̈ܲܫܝܼܥܹܐ ܦܲܨܹܝܡܘܼܢ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","”ܠܹܐ ܝܵܕܥܝܼ ܘܠܹܐ ܦܲܪܡܝܼ، ܒܚܸܫܟܵܐ ܟܹܐ ܚܵܕܪܝܼ، ܫܥܝܼܫܹܐ ܝܢܵܐ ܟܠܵܝܗ‌ܝ ܫܲܬܐܸܣܝܵܬܹ̈‌ܐ ܕܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","”ܐܵܢܵܐ ܐܡܝܼܪܝܼ: ’ܐܲܠܵܗܹ̈ܐ ܝܬܘܿܢ ܐܲܚܬܘܿܢ، ܘܒܢܲܝ̈ ܥܸܠܵܝܵܐ ܟܠܵܘܟ݂ܘܿܢ.‘ ");
INSERT INTO aii_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","”ܐܝܼܢܵܐ ܐܲܝܟ݂ ܒܲܪܢܵܫܵܐ ܒܸܬ ܡܵܝܬܝܼܬܘܿܢ، ܘܐܲܝܟ݂ ܚܲܕ ܡ̣ܢ ܓܘܼܪ̈ܵܢܹܐ ܒܸܬ ܢܵܦܠܝܼܬܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","ܩܘܼܡ، ܝܵܐ ܐܲܠܵܗܵܐ، ܕܘܼܢ ܠܐܲܪܥܵܐ، ܣܵܒܵܒ ܐܲܢ݇ܬ ܒܸܬ ܝܵܪܬܹܬ ܠܗܘܿܢ ܟܠܵܝܗ‌ܝ ܐܸܡܘܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","ܝܵܐ ܐܲܠܵܗܵܐ، ܠܵܐ ܗܵܘܝܵܐ ܫܠܵܝܬܵ‌ܐ ܐܸܠܘܼܟ݂، ܠܵܐ ܫܵܬܩܹܬ ܘܠܵܐ ܗܵܘܹܝܬ ܫܸܠܝܵܐ، ܝܵܐ ܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","ܣܵܒܵܒ ܗܵܐ، ܕܸܫ̃ܡܸܢܘܼ̈ܟ݂ ܒܸܥܒ݂ܵܕܵܐ ܝܢܵܐ ܫܓ݂ܘܼܫܝܵܐ، ܘܣܵܢܝܵܢܘܼ̈ܟ݂ ܡܘܼܪܸܡ ܠܗܘܿܢ ܪܹܝܫܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","ܥܲܠܔ ܥܲܡܘܼܟ݂ ܥܒ݂ܝܼܕ ܠܗܘܿܢ ܒܘܼܨܵܐ ܨܢܝܼܥܵܐ، ܘܥܒ݂ܝܼܕ ܠܗܘܿܢ ܡܸܠܟܵܐ ܥܲܠܔ ܣܝܼܡܵܬܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","ܐܡܝܼܪܗܘܿܢ: ”ܬܹܝܡܘܼܢ ܘܛܲܠܩܲܚ ܠܗܘܿܢ ܡ̣ܢ ܐܘܼܡܬܵ‌ܐ، ܕܠܵܐ ܦܵܐܹܫ ܕܟ݂ܝܼܪܵܐ ܫܸܡܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ ܡܸܢܕܪܸܫ.“ ");
INSERT INTO aii_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","ܣܵܒܵܒ ܥܒ݂ܝܼܕ ܠܗܘܿܢ ܡܸܠܟܵܐ ܒܠܸܒܵܐ ܥܲܡ ܚܕܵܕܹ̈ܐ، ܩܛܝܼܥ ܠܗܘܿܢ ܩܵܘܠܵܐ ܥܲܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","ܡܲܫܟܢܹ̈ܐ ܕܐܲܕܘܿܡ ܘܕܐܝܼܫܡܲܥܠܵܝܹ̈ܐ، ܡܘܼܐܵܒ݂ ܘܗܵܓ݂ܵܪ̈ܵܝܹܐ، ");
INSERT INTO aii_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","ܓܒܲܠܔ ܘܥܲܡܘܿܢ ܘܥܡܵܠܹܝܩ، ܦܠܸܫܬ ܥܲܡ ܥܵܡܪ̈ܵܢܹܐ ܕܨܘܿܪ. ");
INSERT INTO aii_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","ܐܘܼܦ ܐܵܬܘܿܪ ܙܘܼܘܸܓ ܠܹܗ ܥܲܡܵܝܗ‌ܝ، ܗܘܹܐ ܠܗܘܿܢ ܕܪܲܥܢܵܐ ܠܒܢܘܿܢܹ̈ܐ ܕܠܘܿܛ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","ܥܒ݂ܘܿܕ ܐܸܠܵܝܗ‌ܝ ܐܲܝܟ݂ ܠܡܸܕܝܲܢ، ܐܲܝܟ݂ ܠܣܝܼܣܪܵܐ ܘܝܵܒ݂ܝܼܢ ܒܢܲܗܪܵܐ ܕܩܝܼܫܘܿܢ، ");
INSERT INTO aii_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","ܕܦܝܼܫ ܠܗܘܿܢ ܛܘܼܠܩܹܐ ܒܥܝܼܢܕܘܿܪ، ܘܗܘܹܐ ܠܗܘܿܢ ܙܸܒܠܵܐ ܠܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","ܥܒ݂ܘܿܕ ܠܗܘܿܢ ܢܲܨܝܼܚܵܝ̈ܗ‌ܝ ܐܲܝܟ݂ ܥܘܿܪܝܼܒ݂ ܘܐܲܝܟ݂ ܙܝܼܒ݂، ܘܟܠܵܝܗ‌ܝ ܫܲܠܝܼܛܵܝ̈ܗ‌ܝ ܐܲܝܟ݂ ܙܵܒ݂ܵܚ ܘܐܲܝܟ݂ ܨܲܠܡܢܲܥ. ");
INSERT INTO aii_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","ܕܐܡܝܼܪܗܘܿܢ: ”ܝܵܪܬܲܚ ܠܗܘܿܢ ܠܓܵܢܲܢ ܡܲܪ̈ܥܝܹܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","ܝܵܐ ܐܲܠܵܗ‌ܝܼ، ܥܒ݂ܘܿܕ ܠܗܘܿܢ ܐܲܝܟ݂ ܓܵܪܕܵܒܘܼܠܹܐ، ܐܲܝܟ݂ ܟܘܼܠܵܫ ܩܲܕܡ ܦܵܘܚܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","ܐܲܝܟ݂ ܢܘܼܪܵܐ ܕܡܲܩܸܕ ܥܵܒ݂ܵܐ، ܘܐܲܝܟ݂ ܠܵܗܵܐ ܕܡܲܠܗܸܒ݂ ܛܘܼܪ̈ܵܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","ܗܵܕܟ݂ܵܐ ܢܵܦܠܹܬ ܒܵܬܪܵܝܗ‌ܝ ܒܥܲܠܥܵܠܘܼܟ݂، ܘܒܓܵܪܕܵܒܘܼܠܘܼܟ݂ ܡܲܪܓܸܕܸܬ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","ܡܠܝܼ ܦܵܬܘܵܬܵܝ̈ܗ‌ܝ ܒܘܼܨܵܪܵܐ، ܕܛܵܥܝܼ ܠܫܸܡܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","ܢܵܟ݂ܦܝܼ ܘܦܵܝܫܝܼ ܫܓ݂ܝܼܫܹܐ ܗܲܠܔ ܥܵܠܲܡ، ܘܦܵܝܫܝܼ ܢܟ݂ܝܼܦܹܐ ܘܛܵܠܩܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","ܘܝܵܕܥܝܼ ܕܐܲܢ݇ܬ ܒܢܲܦ̮ܫܘܼܟ݂ ܫܸܡܘܼܟ݂ ܡܵܪܝܵܐ ܝܠܹܗ، ܥܸܠܵܝܵܐ ܥܲܠܔ ܟܠܵܗ̇ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","ܟܡܵܐ ܡܘܼܚܸܒܹ̈ܐ ܝܢܵܐ ܡܲܫܟܢܘܼ̈ܟ݂، ܝܵܐ ܡܵܪܝܵܐ ܚܲܝܠܬܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","ܪܘܼܚܪܸܚ ܠܵܗ̇ ܘܐܘܼܦ ܬܝܼܡ ܠܵܗ̇ ܓܵܢܝܼ ܠܕܵܪ̈ܵܬܹ‌ܐ ܕܡܵܪܝܵܐ، ܠܸܒܝܼ ܘܦܲܓ݂ܪܝܼ ܟܹܐ ܫܲܒܚܝܼ ܠܐܲܠܵܗܵܐ ܚܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","ܐܘܼܦ ܨܸܦܪܬܵ‌ܐ ܡܘܼܫ݇ܟ̰ܸܚ ܠܵܗ̇ ܒܲܝܬܵ‌ܐ، ܘܣܢܘܿܢܝܼܬܵ‌ܐ ܩܸܢܵܐ ܩܵܬܘܼܗ̇، ܕܡܲܬܒ݂ܵܐ ܙܲܥܝܘܼ̈ܗ̇، ܠܟܸܣ ܡܲܕܒܚܘܼ̈ܟ݂، ܝܵܐ ܡܵܪܝܵܐ ܚܲܝܠܬܵܢܵܐ، ܡܲܠܟܝܼ ܘܐܲܠܵܗ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","ܛܘܼܒ݂ܵܐ ܠܥܵܡܪ̈ܵܢܹܐ ܕܒܲܝܬܘܼܟ݂، ܗܲܪ ܒܸܬ ܫܲܒܚܝܼ ܠܘܼܟ݂. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","ܛܘܼܒ݂ܵܐ ܠܐܢܵܫܹ̈ܐ ܕܚܲܝܠܵܝܗ‌ܝ ܒܝܼܘܼܟ݂ ܝܼܠܹܗ، ܫܒ݂ܝܼܠܹ̈ܐ ܕܠܨܸܗܝܘܿܢ ܒܠܸܒܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","ܥܵܒ݂ܪ̈ܵܢܹܐ ܕܪܵܘܘܿܠܵܐ ܕܒܸܟ݂ܝܵܐ، ܟܹܐ ܥܵܒ݂ܕܝܼ ܠܹܗ ܥܲܝܢܵܬܹ̈‌ܐ، ܐܘܼܦ ܡܸܛܪܵܐ ܩܲܕܡܵܝܬܵ‌ܐ ܟܹܐ ܡܲܒܪܝܼܵܐ ܒܸܪ̈ܟܹܐ ܕܡ̈ܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","ܟܹܐ ܐܵܙܠ݇ܝܼ ܡ̣ܢ ܚܲܝܠܵܐ ܠܚܲܝܠܵܐ، ܒܸܬ ܦܵܝܫܝܼ ܚܸܙܝܵܐ ܠܐܲܠܵܗܵܐ ܒܨܸܗܝܘܿܢ، ");
INSERT INTO aii_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","ܝܵܐ ܡܵܪܝܵܐ ܐܲܠܵܗܵܐ ܚܲܝܠܬܵܢܵܐ، ܫܡܹܥ ܨܠܘܿܬ‌ܝܼ، ܗܲܒ݂ܠܔ ܢܵܬܵ‌ܐ، ܝܵܐ ܐܲܠܵܗܵܐ ܕܝܲܥܩܘܿܒ݂. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","ܚܙܝܼ ܡܵܛܵܠܲܢ، ܝܵܐ ܐܲܠܵܗܵܐ، ܘܚܘܼܪ ܒܦܵܬܵ‌ܐ ܕܡܫܝܼܚܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","ܣܵܒܵܒ ܒܘܼܫ ܨܦܵܝܝܼ ܝܠܹܗ ܚܲܕ ܝܵܘܡܵܐ ܒܕܵܪ̈ܵܬܘܼܟ݂ ܡ̣ܢ ܐܲܠܦܵܐ ܒܕܘܼܟܵܐ ܐܚܹܪܬܵ‌ܐ. ܓܘܼܒܹܐ ܠܝܼ ܠܹܗܘܵܝܵܐ ܒܣܩܘܼܦܬܵ‌ܐ ܕܒܲܝܬܵ‌ܐ ܕܐܲܠܵܗ‌ܝܼ، ܡ̣ܢ ܠܸܥܡܵܪܵܐ ܒܡܲܫܟܢܹ̈ܐ ܕܪ̈ܲܫܝܼܥܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","ܣܵܒܵܒ ܫܸܡܫܵܐ ܘܡܵܛܵܠܵܐ ܝܠܹܗ ܡܵܪܝܵܐ ܐܲܠܵܗܵܐ، ܫܵܦܵܩܲܬ ܘܐܝܼܩܵܪܵܐ ܒܸܬ ܝܵܗܒܹܠܔ ܡܵܪܝܵܐ، ܠܹܐ ܡܲܟܠܹܐ ܛܵܒ݂ܬܵ‌ܐ ܡ̣ܢ ܕܐܵܢܝܼ ܕܚܵܕܪܝܼ ܒܬܲܡܝܼܡܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","ܝܵܐ ܡܵܪܝܵܐ ܚܲܝܠܬܵܢܵܐ، ܛܘܼܒ݂ܵܐ ܠܐܢܵܫܵܐ ܕܣܵܒܹܪ ܒܝܼܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","ܒܣܝܼܡ ܠܵܗ̇ ܠܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܒܐܲܪܥܘܼܟ݂، ܡܘܼܕܸܪܘܼܟ݂ ܠܝܲܥܩܘܿܒ݂ ܡ̣ܢ ܓܵܠܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","ܫܒ݂ܝܼܩ ܠܘܼܟ݂ ܠܥܲܡܘܼܟ݂ ܥܵܘܠܵܝܗ‌ܝ، ܟܘܼܣܹܐ ܠܘܼܟ݂ ܠܟܠܔ ܚܛܝܼܬܵܝܗ‌ܝ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","ܡܘܼܥܒܸܪܘܼܟ݂ ܟܠܵܗ̇ ܚܸܡܬܘܼܟ݂، ܕܝܼܪܘܼܟ݂ ܡ̣ܢ ܚܸܡܬܵ‌ܐ ܕܟܲܪܒܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","ܡܲܕܸܪܲܢ، ܝܵܐ ܐܲܠܵܗܵܐ ܕܦܘܼܪܩܵܢܲܢ، ܘܒܲܛܸܠܔ ܠܟܲܪܒܘܼܟ݂ ܡܸܢܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","ܗܵܐ، ܠܥܵܠܲܡ ܒܸܬ ܟܵܪܒܹܬ ܥܲܠܲܢ، ܡܲܓܪܸܫܸܬ ܚܸܡܬܘܼܟ݂ ܠܕܵܪܵܐ ܘܕܵܪܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","ܗܵܐ، ܐܲܢ݇ܬ ܠܹܐ ܕܵܝܪܹܬ ܡܲܚܹܝܬ ܠܲܢ، ܩܵܐ ܕܥܲܡܘܼܟ݂ ܚܵܕܝܼ ܒܝܼܘܼܟ݂؟ ");
INSERT INTO aii_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","ܡܲܚܙܝܼ ܠܲܢ ܛܲܝܒܘܼܬܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܘܦܘܼܪܩܵܢܘܼܟ݂ ܝܵܗܒܹܬ ܐܸܠܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","ܫܵܡܥܹܢ ܡܘܼܕܝܼ ܒܸܬ ܗܲܡܙܸܡ ܐܲܠܵܗܵܐ ܡܵܪܝܵܐ، ܣܵܒܵܒ ܒܸܬ ܗܲܡܙܸܡ ܫܠܵܡܵܐ ܠܥܲܡܹܗ ܘܠܙܲܕܝܼܩܘܼ̈ܗ‌ܝ، ܘܠܵܐ ܕܵܝܪܝܼ ܠܣܲܟ݂ܠܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","ܗܹܐ، ܩܘܼܪܒܵܐ ܝܠܹܗ ܠܙܕܝܼܥܘܼ̈ܗ‌ܝ ܦܘܼܪܩܵܢܹܗ، ܕܫܵܪܹܐ ܚܸܩܪܵܐ ܒܐܲܪܥܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","ܛܲܝܒܘܼܬܵ‌ܐ ܘܫܲܪܝܼܪܘܼܬܵ‌ܐ ܬܦܝܼܩ ܠܗܘܿܢ، ܙܲܕܝܼܩܘܼܬܵ‌ܐ ܘܫܠܵܡܵܐ ܢܫܝܼܩ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","ܫܲܪܝܼܪܘܼܬܵ‌ܐ ܡ̣ܢ ܐܲܪܥܵܐ ܒܸܬ ܡܲܓ̰ܝܸܢܵܐ، ܘܙܲܕܝܼܩܘܼܬܵ‌ܐ ܡ̣ܢ ܫܡܲܝܵܐ ܒܸܬ ܓܲܫܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","ܐܘܼܦ ܡܵܪܝܵܐ ܒܸܬ ܝܵܗܒܹܠܔ ܛܵܒ݂ܬܵ‌ܐ، ܘܐܲܪܥܲܢ ܒܸܬ ܝܵܗܒ݂ܵܐ ܛܥܘܼܢܬܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","ܙܲܕܝܼܩܘܼܬܵ‌ܐ ܩܲܕܡܘܼܗ‌ܝ ܒܸܬ ܐܵܙܵܠ݇ܐ، ܘܫܵܘܦܵܦܹ̈ܐ ܕܐܲܩܠܘܼ̈ܗ̇ ܒܸܬ ܥܵܒ݂ܕܝܼ ܐܘܼܪܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","ܨܲܠܝܼ ܢܵܬܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܘܓ̰ܲܘܸܒ ܠܝܼ، ܒܗ̇ܝ ܕܡܸܣܟܹܢܵܐ ܝܘܸܢ ܘܣܢܝܼܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","ܢܛܘܿܪ ܓܵܢܝܼ ܒܗ̇ܝ ܕܟܫܝܼܛܵܐ ܝܘܸܢ ܐܵܢܵܐ، ܦܲܪܸܩ ܠܪܹܓܘܼܟ݂، ܝܵܐ ܐܲܠܵܗܵܐ، ܕܒܸܣܒܵܪܵܐ ܝܠܹܗ ܒܝܼܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","ܪܲܚܸܡ ܥܲܠܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܒܗ̇ܝ ܕܐܸܠܘܼܟ݂ ܒܸܩܪܵܝܵܐ ܝܘܸܢ ܟܠܹܗ ܝܵܘܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","ܡܲܚܕܝܼ ܓܵܢܵܐ ܕܪܹܓܘܼܟ݂، ܒܗ̇ܝ ܕܐܸܠܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܡܲܪܘܼܡܘܼܗ̇ ܝܘܸܢ ܓܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","ܒܗ̇ܝ ܕܐܲܢ݇ܬ، ܝܵܐ ܡܵܪܝܵܐ، ܛܵܒ݂ܵܐ ܝܘܸܬ ܘܫܵܒ݂ܩܵܢܵܐ، ܘܦܸܪܝܵܐ ܒܛܲܝܒܘܼܬܵ‌ܐ ܠܟܠܔ ܕܩܵܪܹܐ ܐܸܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","ܗܲܒ݂ܠܔ ܢܵܬܵ‌ܐ، ܝܵܐ ܡܵܪܝܵܐ، ܠܨܠܘܿܬ‌ܝܼ، ܘܡܲܨܝܸܬ ܠܩܵܠܵܐ ܕܢܵܘܢܲܝܵܬ‌ܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","ܒܝܵܘܡܵܐ ܕܥܵܘܩܵܢܝܼ ܒܸܬ ܩܵܪܹܝܢ ܐܸܠܘܼܟ݂، ܒܗ̇ܝ ܕܒܸܬ ܓ̰ܲܘܸܒܸܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","ܠܲܝܬ ܐܲܝܟ݂ ܕܝܼܘܼܟ݂ ܓܵܘ ܐܲܠܵܗܹ̈ܐ، ܝܵܐ ܡܵܪܝܵܐ، ܘܠܲܝܬ ܦܘܼܠܚܵܢܹ̈ܐ ܐܲܝܟ݂ ܦܘܼܠܚܵܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","ܟܠܵܝܗ‌ܝ ܐܸܡܘܵܬܹ̈‌ܐ ܕܥܒ݂ܝܼܕ ܠܘܼܟ݂ ܒܸܬ ܐܵܬ‌ܝܼ ܘܣܵܓ݂ܕܝܼ ܩܲܕܡܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܘܒܸܬ ܡܝܲܩܪܝܼ ܠܫܸܡܘܼܟ݂، ");
INSERT INTO aii_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","ܒܗ̇ܝ ܕܓܘܼܪܵܐ ܝܘܸܬ ܐܲܢ݇ܬ ܘܥܵܒ݂ܕܵܢܵܐ ܕܕܘܼܡܵܪܹ̈ܐ، ܐܲܢ݇ܬ ܝܼܘܸܬ ܐܲܠܵܗܵܐ ܒܢܲܦ̮ܫܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","ܡܲܠܸܦ ܠܝܼ ܐܘܼܪܚܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܕܚܵܕܪܹܢ ܒܫܲܪܝܼܪܘܼܬܘܼܟ݂، ܥܒ݂ܘܿܕ ܠܹܗ ܠܸܒܝܼ ܚܲܕ، ܕܙܵܕܹܥ ܡ̣ܢ ܫܸܡܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","ܒܸܬ ܫܲܟܪܸܢܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ ܐܲܠܵܗ‌ܝܼ، ܒܟܠܹܗ ܠܸܒܝܼ، ܘܒܸܬ ܡܝܲܩܪܸܢܹܗ ܫܸܡܘܼܟ݂ ܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","ܒܗ̇ܝ ܕܛܲܝܒܘܼܬܘܼܟ݂ ܓܘܼܪܬܵ‌ܐ ܝܠܵܗ̇ ܥܲܠܝܼ، ܘܦܘܼܨܹܐ ܠܘܼܟ݂ ܓܵܢܝܼ ܡ̣ܢ ܫܝܘܿܠܔ ܬܲܚܬܵܝܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","ܝܵܐ ܐܲܠܵܗܵܐ، ܚܵܬܪ̈ܵܢܹܐ ܩܝܼܡ ܠܗܘܿܢ ܥܲܠܝܼ، ܘܟܸܢܫܵܐ ܕܛܵܠܘܿܡܹ̈ܐ ܛܥܹܐ ܠܗܘܿܢ ܠܓܵܢܝܼ، ܘܠܵܐ ܩܵܡ ܡܲܬܒ݂ܝܼ ܠܘܼܟ݂ ܩܲܕܡ ܦܵܬܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","ܘܐܲܢ݇ܬ، ܝܵܐ ܡܵܪܝܵܐ، ܐܲܠܵܗܵܐ ܡܪܲܚܡܵܢܵܐ ܘܚܲܢܵܢܵܐ ܝܘܸܬ، ܝܲܪܝܼܟ݂ܬܵ‌ܐ ܒܹܐܢܹܗ، ܘܪܵܒܵܐ ܒܛܲܝܒܘܼܬܵ‌ܐ ܘܒܫܲܪܝܼܪܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","ܕܘܼܪ ܠܟܸܣܠܝܼ ܘܪܲܚܸܡ ܥܲܠܝܼ، ܗܲܒ݂ܠܔ ܥܘܼܫܢܘܼܟ݂ ܠܪܹܓܘܼܟ݂، ܘܦܲܪܸܩ ܠܒܪܘܿܢܵܐ ܕܚܸܕܲܡܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","ܥܒ݂ܘܿܕ ܥܲܡܝܼ ܢܝܼܫܲܢܩܵܐ ܠܛܵܒ݂ܬܵ‌ܐ، ܕܚܵܙܝܼ ܣܵܢܝܵܢܝܼ̈ ܘܢܵܟ݂ܦܝܼ، ܒܗ̇ܝ ܕܐܲܢ݇ܬ، ܝܵܐ ܡܵܪܝܵܐ، ܩܵܡ ܗܲܝܸܪܸܬ ܘܝܵܗܒܹܬ ܠܝܼ ܠܸܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","ܫܲܬܐܸܣܬܵ‌ܐ ܕܡܕܝܼܢ݇ܬܹܗ ܒܛܘܼܪ̈ܵܢܹܐ ܕܩܘܼܕܫܵܐ ܝܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","ܟܹܐ ܡܲܚܸܒ ܡܵܪܝܵܐ ܕܲܪ̈ܘܵܙܹܐ ܕܨܸܗܝܘܿܢ، ܒܘܼܫ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܡܲܫܟܢܹ̈ܐ ܕܝܲܥܩܘܿܒ݂. ");
INSERT INTO aii_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","ܚܲܒܪܹ̈ܐ ܡܝܘܼܩܪܹ̈ܐ ܗܘܼܡܙܸܡܹܐ ܝܢܵܐ ܒܘܼܬ ܕܝܼܵܟ݂ܝ، ܝܵܐ ܡܕܝܼܢ݇ܬܵ‌ܐ ܕܐܲܠܵܗܵܐ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","ܒܸܬ ܡܲܕܟܸܪܸܢ ܪܵܚܵܒ݂ ܘܒܵܒܹܠܔ ܓܵܘ ܝܵܕܥܵܢܝܼ̈، ܗܵܐ، ܦܠܸܫܬ ܘܨܘܿܪ ܥܲܡ ܟܘܼܫ: ܐܵܗܵܐ ܦܝܼܫ ܠܹܗ ܝܠܝܼܕܵܐ ܬܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","ܐܝܼܢܵܐ ܒܘܼܬ ܨܸܗܝܘܿܢ ܒܸܬ ܦܵܐܹܫ ܐܡܝܼܪܵܐ: ”ܐܵܗܵܐ ܘܗ̇ܘ ܦܝܼܫ ܠܹܗ ܝܠܝܼܕܵܐ ܓܵܘܘܼܗ̇. ܘܗ̇ܘ ܥܸܠܵܝܵܐ ܒܸܬ ܡܲܩܘܹܐ ܠܵܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","ܡܵܪܝܵܐ ܒܸܬ ܡܵܢܹܐ ܐܝܼܡܲܢ ܕܟܵܬܹܒ݂ ܥܲܡܡܹ̈ܐ: ”ܐܵܗܵܐ ܦܝܼܫ ܠܹܗ ܝܠܝܼܕܵܐ ܬܵܡܵܐ.“ ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","ܙܲܡܵܪܹ̈ܐ ܥܲܡ ܪ̈ܲܩܵܕܹܐ ܐܵܡܪܝܼ: ”ܟܠܵܝܗ‌ܝ ܥܲܝܢܵܬ‌ܝܼ̈ ܕܡ̈ܝܼܵܐ ܓܵܘܵܟ݂ܝ ܝܼܢܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","ܡܵܪܝܵܐ ܐܲܠܵܗܵܐ ܕܦܘܼܪܩܵܢܝܼ، ܒܐܝܼܡܵܡܵܐ ܘܒܠܲܝܠܹܐ ܡܘܼܩܘܸܚ ܠܝܼ ܩܲܕܡܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","ܫܒ݂ܘܿܩ ܐܵܬܝܵܐ ܠܩܲܕܡܘܼܟ݂ ܨܠܘܿܬ‌ܝܼ، ܡܲܟܸܦ ܢܵܬܘܼܟ݂ ܠܡܲܩܘܲܚܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","ܣܵܒܵܒ ܡܠܹܐ ܠܵܗ̇ ܡ̣ܢ ܣܸܪ̈ܝܵܬܹ‌ܐ ܓܵܢܝܼ، ܘܚܲܝܝܼ̈ ܠܫܝܘܿܠܔ ܡܛܹܐ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","ܦܝܼܫ ܠܝܼ ܚܘܼܫܒܸܢܵܐ ܥܲܡ ܨܵܠܝܵܢܹ̈ܐ ܕܓܘܼܒܵܐ، ܗܘܹܐ ܠܝܼ ܐܲܝܟ݂ ܓܲܒ݂ܪܵܐ ܕܠܲܝܬ ܠܹܗ ܚܲܝܠܵܐ؛ ");
INSERT INTO aii_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","ܒܓܵܘܵܐ ܕܡܝܼ̈ܬܹ‌ܐ ܫܒ݂ܝܼܩܵܐ، ܐܲܝܟ݂ ܩܛܝܼ̈ܠܹܐ ܕܵܡܟ݂ܵܢܹ̈ܐ ܒܩܲܒ݂ܪܵܐ، ܕܠܹܐ ܕܵܟ݂ܪܹܬ ܠܗܘܿܢ ܐܚܹܪܢܵܐ، ܘܐܵܢܝܼ ܡ̣ܢ ܐܝܼܕܘܼܟ݂ ܦܝܼܫ ܠܗܘܿܢ ܩܛܝܼܥܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","ܡܘܼܬܸܒ݂ ܠܘܼܟ݂ ܐܸܠܝܼ ܒܓܘܼܒܵܐ ܬܲܚܬܵܝܵܐ، ܒܕܘܼܟܵܢܹ̈ܐ ܚܸܫܟܵܢܹ̈ܐ، ܒܥܘܼܡܩܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","ܥܲܠܝܼ ܦܝܼܫ ܠܵܗ̇ ܡܘܼܬܸܒ݂ܬܵ‌ܐ ܚܸܡܬܘܼܟ݂، ܘܩܵܡ ܡܲܥܝܸܩܸܬ ܠܝܼ ܒܟܠܵܝܗ‌ܝ ܡܲܚܫܘܼܠܘܼ̈ܟ݂. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","ܡܘܼܪܚܸܩ ܠܘܼܟ݂ ܝܵܕܥܵܢܝܼ̈ ܡܸܢܝܼ، ܥܒ݂ܝܼܕܸܢܘܼܟ݂ ܛܲܡܐܘܼܬܵ‌ܐ ܐܸܠܵܝܗ‌ܝ، ܦܝܼܫܵܐ ܝܘܸܢ ܚܒ݂ܝܼܫܵܐ ܘܠܹܐ ܡܵܨܹܝܢ ܦܵܠܛܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","ܥܲܝܢܝܼ ܢܘܝܼܠܔ ܠܵܗ̇ ܡ̣ܢ ܥܵܘܩܵܢܵܐ، ܒܟܠܹܗ ܝܵܘܡܵܐ ܩܪܹܐ ܠܝܼ ܐܸܠܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܦܪܝܼܣ ܠܝܼ ܐܸܠܘܼܟ݂ ܐܝܼܕܵܬ‌ܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","ܗܵܐ، ܠܡܝܼ̈ܬܹ‌ܐ ܒܸܬ ܥܵܒ݂ܕܹܬ ܕܘܼܡܵܪܹ̈ܐ؟ ܝܲܢ ܪ̈ܘܼܚܵܬܹ‌ܐ ܕܡܝܼ̈ܬܹ‌ܐ ܒܸܬ ܩܵܝܡܝܼ ܫܲܟܪܝܼ ܠܘܼܟ݂؟ ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","ܗܵܐ، ܒܸܬ ܦܵܝܫܵܐ ܗܘܼܩܝܼܬܵ‌ܐ ܒܩܲܒ݂ܪܵܐ ܛܲܝܒܘܼܬܘܼܟ݂، ܝܲܢ ܒܐܲܒ݂ܕܵܢܵܐ ܡܗܘܼܡܢܘܼܬܘܼܟ݂؟ ");
INSERT INTO aii_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","ܗܵܐ، ܒܸܬ ܦܵܝܫܝܼ ܝܕܝܼܥܹܐ ܒܚܸܫܟܵܐ ܕܘܼܡܵܪ̈ܘܼܟ݂، ܝܲܢ ܒܐܲܪܥܵܐ ܕܡܲܢܫܲܝܬܵ‌ܐ ܙܲܕܝܼܩܘܼܬܘܼܟ݂؟ ");
INSERT INTO aii_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","ܐܝܼܢܵܐ ܐܵܢܵܐ ܐܸܠܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܡܘܼܩܘܸܚ ܠܝܼ، ܘܒܨܲܦܪܵܐ ܨܠܘܿܬ‌ܝܼ ܠܟܸܣܠܘܼܟ݂ ܟܹܐ ܐܵܬܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","ܩܵܡܘܿܕܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܪܲܦܹܝܬ ܠܵܗ̇ ܓܵܢܝܼ؟ ܩܵܡܘܿܕܝܼ ܛܲܫܹܝܬ ܠܵܗ̇ ܦܵܬܘܼܟ݂ ܡܸܢܝܼ؟ ");
INSERT INTO aii_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","ܡܘܼܥܝܸܩܵܐ ܝܘܸܢ ܐܵܢܵܐ، ܘܒܸܡܝܵܬܵ‌ܐ ܡ̣ܢ ܥܠܲܝܡܘܼܬ‌ܝܼ، ܩܘܼܒܸܠܔ ܠܝܼ ܙܕܘܼܥܝܵܬܘܼ̈ܟ݂، ܦܝܼܫ ܠܝܼ ܗܝܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","ܚܸܡܬܵ‌ܐ ܕܟܲܪ̈ܒܘܼܟ݂ ܐܬܹ‌ܐ ܠܵܗ̇ ܥܲܠܝܼ، ܙܕܘܼܥܝܵܬܘܼ̈ܟ݂ ܩܵܡ ܡܲܫܬܸܩܝܼ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","ܩܵܡ ܟܵܪܟ݂ܝܼ ܠܝܼ ܐܲܝܟ݂ ܡ̈ܝܼܵܐ ܟܠܹܗ ܝܵܘܡܵܐ، ܚܘܼܪܕܹܐ ܠܗܘܿܢ ܥܲܠܝܼ ܡܥܘܼܕܵܠܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","ܡܘܼܪܚܸܩ ܠܘܼܟ݂ ܡܸܢܝܼ ܡܘܼܚܸܒܵܐ ܘܪܵܚܡܵܐ، ܝܵܕܥܵܢܝܼ̈ ܒܚܸܫܟܵܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","ܛܲܝܒܘܵܬܹ̈‌ܐ ܕܡܵܪܝܵܐ ܠܥܵܠܲܡ ܒܸܬ ܙܵܡܪܹܢ، ܠܕܵܪܵܐ ܘܕܵܪܵܐ ܒܸܬ ܡܲܕܥܸܢ ܡܗܘܼܡܢܘܼܬܘܼܟ݂ ܒܦܘܼܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","ܣܵܒܵܒ ܐܡܝܼܪܝܼ: ܠܥܵܠܲܡ ܛܲܝܒܘܼܬܵ‌ܐ ܒܸܬ ܦܵܝܫܵܐ ܒܢܝܼܬܵ‌ܐ، ܒܫܡܲܝܵܐ ܒܸܬ ܡܲܩܘܹܝܬ ܡܗܘܼܡܢܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","ܐܡܝܼܪܹܗ ܡܵܪܝܵܐ: ”ܩܛܝܼܥ ܠܝܼ ܘܲܥܕܵܐ ܠܓܘܼܒܝܝܼ، ܝܡܹܐ ܠܝܼ ܠܕܵܘܝܼܕ ܪܹܓܝܼ، ");
INSERT INTO aii_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","”ܗܲܠܔ ܥܵܠܲܡ ܒܸܬ ܡܲܩܘܹܝܢ ܙܲܪܥܘܼܟ݂، ܘܒܸܬ ܒܵܢܹܝܢ ܠܕܵܪܵܐ ܘܕܵܪܵܐ ܟܘܼܪܣܝܘܼܟ݂.“ ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","ܒܸܬ ܫܲܟܪܝܼ ܫܡܲܝܹ̈ܐ ܕܘܼܡܵܪ̈ܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܐܘܼܦ ܡܗܘܼܡܢܘܼܬܘܼܟ݂ ܒܟܸܢܫܵܐ ܕܩܲܕܝܼܫܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","ܣܵܒܵܒ ܡܵܢܝܼ ܒܫܡܲܝܵܐ ܦܵܐܹܫ ܡܘܼܕܒܸܩܵܐ ܥܲܡ ܡܵܪܝܵܐ؟ ܡܵܢܝܼ ܕܵܡܹܐ ܠܡܵܪܝܵܐ ܓܵܘ ܒܢܘܿܢܹ̈ܐ ܕܐܲܠܵܗܹ̈ܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","ܐܲܠܵܗܵܐ ܣܲܗܡܵܢܵܐ ܝܠܹܗ ܪܵܒܵܐ ܓܵܘ ܡܵܘܬܒ݂ܵܐ ܕܩܲܕܝܼܫܹ̈ܐ، ܘܣܲܗܡܵܢܵܐ ܥܲܠܔ ܟܠܵܝܗ‌ܝ ܚܵܕܸܪ̈ܘܵܢܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","ܝܵܐ ܡܵܪܝܵܐ ܐܲܠܵܗܵܐ ܚܲܝܠܬܵܢܵܐ، ܡܵܢܝܼ ܝܠܹܗ ܐܲܝܟ݂ ܕܝܼܘܼܟ݂ ܥܲܫܝܼܢܵܐ، ܡܵܪܝܵܐ؟ ܡܗܘܼܡܢܘܼܬܘܼܟ݂ ܒܚܵܕܸܪ̈ܘܵܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","ܐܲܢ݇ܬ ܟܹܐ ܥܵܒ݂ܕܹܬ ܫܘܼܠܛܵܢܵܐ ܥܲܠܔ ܪܵܡܘܼܬܵ‌ܐ ܕܝܵܡܵܐ، ܟܲܕ ܪܵܝܡܝܼ ܠܲܦܘܼ̈ܗ̇ ܐܲܢ݇ܬ ܟܹܐ ܡܲܫܠܹܝܬ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","ܐܲܢ݇ܬ ܛܒ݂ܝܼܚ ܠܘܼܟ݂ ܠܪܵܚܵܒ݂ ܐܲܝܟ݂ ܩܛܝܼܠܵܐ، ܒܕܪܲܥܢܵܐ ܕܥܘܼܫܢܘܼܟ݂ ܒܙܝܼܩ ܠܘܼܟ݂ ܕܸܫ̃ܡܸܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","ܕܝܼܘܼܟ݂ ܝܼܠܵܗ̇ ܫܡܲܝܵܐ، ܐܘܼܦ ܕܝܼܘܼܟ݂ ܝܼܠܵܗ̇ ܐܲܪܥܵܐ، ܒܪܝܼܬܵ‌ܐ ܘܡܸܠܝܘܼܬܘܼܗ̇ ܐܲܢ݇ܬ ܫܘܼܬܐܸܣܵܝ ܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","ܓܲܪܒܝܵܐ ܘܬܲܝܡܢܵܐ ܐܲܢ݇ܬ ܒܸܪܝܵܝ ܠܘܼܟ݂، ܬܵܒ݂ܘܿܪ ܘܚܸܪܡܘܿܢ ܒܫܸܡܘܼܟ݂ ܟܹܐ ܩܲܘܸܚܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","ܕܝܼܘܼܟ݂ ܝܼܠܹܗ ܕܪܲܥܢܵܐ ܥܲܡ ܓܲܒܵܪܘܼܬܵ‌ܐ، ܚܲܝܠܵܢܬܵ‌ܐ ܝܠܵܗ̇ ܐܝܼܕܘܼܟ݂، ܪܵܡܬܵ‌ܐ ܝܠܵܗ̇ ܝܲܡܝܼܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","ܙܲܕܝܼܩܘܼܬܵ‌ܐ ܘܕܝܼܘܵܢ ܫܲܬܐܸܣܬܵ‌ܐ ܕܟܘܼܪܣܝܘܼܟ݂، ܛܲܝܒܘܼܬܵ‌ܐ ܘܫܪܵܪܵܐ ܟܹܐ ܩܲܕܡܝܼ ܦܵܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","ܛܘܼܒ݂ܵܐ ܠܥܲܡܵܐ ܕܝܵܕܥܝܼ ܩܲܘܲܚܬܵ‌ܐ ܕܚܲܕܘܼܬܵ‌ܐ، ܝܵܐ ܡܵܪܝܵܐ، ܒܒܲܗܪܵܐ ܕܦܵܬܘܼܟ݂ ܟܹܐ ܚܵܕܪܝܼ، ");
INSERT INTO aii_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","ܒܫܸܡܘܼܟ݂ ܟܹܐ ܦܵܨܚܝܼ ܟܠܹܗ ܝܵܘܡܵܐ، ܘܒܙܲܕܝܼܩܘܼܬܘܼܟ݂ ܟܹܐ ܪܵܝܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","ܣܵܒܵܒ ܚܸܩܪܵܐ ܕܥܘܼܫܢܵܝܗ‌ܝ ܐܲܢ݇ܬ ܝܼܘܸܬ، ܘܒܨܸܒ݂ܝܵܢܘܼܟ݂ ܟܹܐ ܪܵܐܹܡ ܚܲܝܠܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","ܣܵܒܵܒ ܡܵܛܵܠܲܢ ܕܡܵܪܝܵܐ ܝܠܵܗ̇، ܘܡܲܠܟܲܢ ܕܩܲܕܝܼܫܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","ܗ̇ܝܓܵܗ ܗܘܼܡܙܸܡ ܠܘܼܟ݂ ܒܚܸܙܘܵܐ ܥܲܡ ܙܲܕܝܼܩܘܼ̈ܟ݂، ܘܐܡܝܼܪܘܼܟ݂: ”ܝܘܼܗܒܹܠܔ ܠܝܼ ܗܲܝܲܪܬܵ‌ܐ ܠܓܲܒܵܪܵܐ، ܡܘܼܪܸܡ ܠܝܼ ܓܘܼܒܝܵܐ ܡ̣ܢ ܓܵܘ ܥܲܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","”ܡܘܼܫ݇ܟ̰ܸܚ ܠܝܼ ܠܕܵܘܝܼܕ ܪܹܓܝܼ، ܒܡܸܫܚܵܐ ܕܩܘܼܕܫܝܼ ܩܵܡ ܡܵܫܚܹܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","”ܐܝܼܕܝܼ ܒܸܬ ܗܵܘܝܵܐ ܡܩܵܘܝܵܢܬܵ‌ܐ ܥܲܡܹܗ، ܐܘܼܦ ܕܪܲܥܢܝܼ ܒܸܬ ܚܲܠܸܢ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","”ܠܹܐ ܥܲܠܕܹܐ ܕܸܫ̃ܡܸܢ ܐܸܠܹܗ، ܘܒܪܘܿܢܵܐ ܕܥܵܘܠܵܐ ܠܹܐ ܡܲܠܝܸܨ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","”ܒܸܬ ܛܵܒ݂ܚܹܢ ܡ̣ܢ ܩܲܕܡܘܼܗ‌ܝ ܕܸܫ̃ܡܸܢܘܼ̈ܗ‌ܝ، ܘܣܵܢܝܵܢܘܼ̈ܗ‌ܝ ܒܸܬ ܡܵܚܹܝܢ. ");
INSERT INTO aii_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","”ܡܗܘܼܡܢܘܼܬ‌ܝܼ ܘܛܲܝܒܘܼܬ‌ܝܼ ܥܲܡܹܗ ܒܸܬ ܗܵܘܝܼ، ܘܒܫܸܡܝܼ ܒܸܬ ܪܵܐܹܡ ܚܲܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","”ܒܸܬ ܡܲܬܒܸܢ ܒܝܵܡܵܐ ܐܝܼܕܹܗ، ܘܒܢܲܗܪ̈ܵܘܵܬܹ‌ܐ ܝܲܡܝܼܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","”ܗ̇ܘ ܒܸܬ ܩܵܪܹܐ ܠܝܼ: ’ܒܵܒܝܼ ܝܘܸܬ ܐܲܢ݇ܬ، ܐܲܠܵܗ‌ܝܼ ܘܐܝܼܨܵܪܵܐ ܕܦܘܼܪܩܵܢܝܼ.‘ ");
INSERT INTO aii_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","”ܐܘܼܦ ܐܵܢܵܐ ܒܘܼܟ݂ܪܵܐ ܒܸܬ ܥܵܒ݂ܕܹܢܹܗ، ܥܸܠܵܝܵܐ ܥܲܠܔ ܡܲܠܟܹ̈ܐ ܕܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","”ܠܥܵܠܲܡ ܒܸܬ ܢܵܛܪܹܢ ܩܵܐ ܕܝܼܹܗ ܛܲܝܒܘܼܬ‌ܝܼ، ܘܘܲܥܕܝܼ ܒܸܬ ܦܵܐܹܫ ܡܘܼܩܘܝܼܵܐ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","”ܒܸܬ ܡܲܬܒܸܢ ܠܥܵܠܲܡ ܙܲܪܥܹܗ، ܘܟܘܼܪܣܝܹܗ ܐܲܝܟ݂ ܝܵܘܡܵܢܹ̈ܐ ܕܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","”ܐܸܢ ܫܵܒ݂ܩܝܼ ܒܢܘܿܢܘܼ̈ܗ‌ܝ ܢܵܡܘܿܣܝܼ، ܘܒܕܝܼܘܵܢܝܼ̈ ܠܵܐ ܚܵܕܪܝܼ، ");
INSERT INTO aii_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","”ܐܸܢ ܩܵܢܘܿܢܝܼ ܟ̰ܲܦܠܸܢܝܼ، ܘܦܘܼܩܕܵܢܝܼ̈ ܠܵܐ ܢܵܛܪܝܼ، ");
INSERT INTO aii_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","”ܒܸܬ ܣܲܚܒܸܪܸܢ ܒܩܵܛܝܼܵܐ ܓܢܵܗܵܝܗ‌ܝ، ܘܒܡܲܚܘܵܬܹ̈‌ܐ ܥܵܘܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","”ܐܝܼܢܵܐ ܛܲܝܒܘܼܬ‌ܝܼ ܠܹܐ ܩܵܛܥܹܢ ܡܸܢܹܗ، ܘܠܹܐ ܕܲܓܠܸܢ ܥܲܠܔ ܡܗܘܼܡܢܘܼܬ‌ܝܼ، ");
INSERT INTO aii_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","”ܠܹܐ ܟ̰ܲܦܠܸܢܸܢ ܘܲܥܕܝܼ، ܘܡܸܢܕܝܼ ܕܦܠܝܼܛ ܠܹܗ ܡ̣ܢ ܣܸܦܘܵܬ‌ܝܼ̈ ܠܹܐ ܫܲܚܠܸܦܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","”ܚܕܵܐ ܓܵܗܵܐ ܝܡܹܐ ܠܝܼ ܒܩܘܼܕܫܝܼ، ܠܹܐ ܕܲܓܠܸܢ ܠܕܵܘܝܼܕ. ");
INSERT INTO aii_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","”ܙܲܪܥܹܗ ܠܥܵܠܲܡ ܒܸܬ ܗܵܘܹܐ، ܘܟܘܼܪܣܝܹܗ ܐܲܝܟ݂ ܫܸܡܫܵܐ ܠܒܲܠܩܘܼܒ݂ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","”ܐܲܝܟ݂ ܣܲܗܪܵܐ ܒܸܬ ܩܵܘܹܐ ܠܥܵܠܲܡ، ܘܣܵܗܕܵܐ ܒܫܡܲܝܵܐ ܡܗܘܼܡܢܵܐ.“ ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","ܐܝܼܢܵܐ ܐܲܢ݇ܬ، ܪܘܼܦܹܐ ܠܘܼܟ݂ ܘܡܘܼܣܠܹܐ ܠܘܼܟ݂، ܟܪܝܼܒ ܠܘܼܟ݂ ܥܲܠܔ ܡܫܝܼܚܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","ܣܪܝܼܒ݂ ܠܘܼܟ݂ ܘܲܥܕܵܐ ܕܪܹܓܘܼܟ݂، ܟ̰ܘܼܦܠܸܢܘܼܟ݂ ܥܲܠܔ ܐܲܪܥܵܐ ܒܸܢܦܵܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","ܬܪܝܼܥ ܠܘܼܟ݂ ܠܟܠܵܝܗ‌ܝ ܣܝܵܓ݂ܘܼ̈ܗ‌ܝ، ܥܒ݂ܝܼܕ ܠܘܼܟ݂ ܩܲܠܥܵܬܘܼ̈ܗ‌ܝ ܚܵܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","ܣܠܝܼܒ ܠܗܘܿܢ ܐܸܠܹܗ ܟܠܵܝܗ‌ܝ ܥܵܒ݂ܪ̈ܵܢܹܐ ܕܐܘܼܪܚܵܐ، ܗܘܹܐ ܠܹܗ ܠܵܘܡܵܐ ܠܫܒ݂ܵܒ݂ܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","ܡܘܼܪܸܡ ܠܘܼܟ݂ ܝܲܡܝܼܢܵܐ ܕܡܲܠܝܸܨܵܢܘܼ̈ܗ‌ܝ، ܡܘܼܚܕܹܐ ܠܘܼܟ݂ ܟܠܵܝܗ‌ܝ ܕܸܫ̃ܡܸܢܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","ܐܘܼܦ ܡܘܼܚܕܸܪܘܼܟ݂ ܚܸܪܦܵܐ ܕܣܲܝܦܹܗ، ܘܠܵܐ ܡܘܼܩܘܹܐ ܠܘܼܟ݂ ܐܸܠܹܗ ܓܵܘ ܦܠܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","ܡܘܼܟܠܹܐ ܠܘܼܟ݂ ܠܙܲܗܝܘܼܬܹܗ، ܘܟܘܼܪܣܝܹܗ ܠܐܲܪܥܵܐ ܚܘܼܪܙܸܦ ܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","ܡܘܼܟܪܹܐ ܠܘܼܟ݂ ܝܵܘܡܵܢܹ̈ܐ ܕܥܠܲܝܡܘܼܬܹܗ، ܡܘܼܟܸܣ ܠܘܼܟ݂ ܥܲܠܘܼܗ‌ܝ ܢܟ݂ܝܼܦܬܵ‌ܐ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","ܗܲܠܔ ܐܝܼܡܲܢ، ܝܵܐ ܡܵܪܝܵܐ، ܒܸܬ ܛܲܫܹܝܬ ܓܵܢܘܼܟ݂ ܠܥܵܠܲܡ؟ ܒܸܬ ܠܵܗܝܵܐ ܐܲܝܟ݂ ܢܘܼܪܵܐ ܚܸܡܬܘܼܟ݂؟ ");
INSERT INTO aii_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","ܕܟ݂ܘܿܪ ܡܘܼܕܝܼ ܝܠܹܗ ܡܸܬܚܵܐ ܕܚܲܝܝܼ̈، ܒܘܼܬ ܡܘܼܕܝܼ ܣܪܝܼܩܘܼܬܵ‌ܐ ܒܪܹܐ ܠܘܼܟ݂ ܠܟܠܵܝܗ‌ܝ ܒܢܲܝ̈ܢܵܫܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","ܡܵܢܝܼ ܝܠܹܗ ܓܲܒ݂ܪܵܐ ܕܚܵܝܹܐ ܘܠܵܐ ܚܵܙܹܐ ܡܵܘܬܵ‌ܐ، ܕܚܲܠܹܨ ܠܵܗ̇ ܓܵܢܹܗ ܡ̣ܢ ܐܝܼܕܵܐ ܕܫܝܘܿܠܔ؟ ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","ܐܲܝܟܵܐ ܝܢܵܐ ܛܲܝܒܘܵܬܘܼ̈ܟ݂ ܩܲܕܝܼܡܵܝܹ̈ܐ، ܝܵܐ ܡܵܪܝܵܐ، ܕܝܡܹܐ ܠܘܼܟ݂ ܠܕܵܘܝܼܕ ܒܡܗܘܼܡܢܘܼܬܘܼܟ݂؟ ");
INSERT INTO aii_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","ܕܟ݂ܘܿܪ، ܝܵܐ ܡܵܪܝܵܐ، ܠܵܘܡܵܐ ܕܪܹ̈ܓܵܘܵܬܘܼܟ݂، ܕܩܘܼܒܸܠܔ ܠܝܼ ܒܥܘܼܒܝܼ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܥܲܡܡܹ̈ܐ ܣܲܓܝܼܐܹ̈ܐ، ");
INSERT INTO aii_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","ܕܠܝܼܡ ܠܗܘܿܢ ܕܸܫ̃ܡܸܢܘܼ̈ܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܕܠܝܼܡ ܠܗܘܿܢ ܠܦܵܣܘܿܥܝܵܬܹ̈‌ܐ ܕܡܫܝܼܚܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","ܒܪܝܼܟ݂ܵܐ ܝܠܹܗ ܡܵܪܝܵܐ ܠܥܵܠܲܡ، ܐܵܡܹܝܢ ܘܐܵܡܹܝܢ. ");
INSERT INTO aii_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","ܝܵܐ ܡܵܪܝܵܐ، ܒܹܝܬ ܡܲܥܡܪܵܐ ܐܲܢ݇ܬ ܗܘܹܐ ܠܘܼܟ݂ ܐܸܠܲܢ ܒܕܵܪܵܐ ܘܕܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","ܡ̣ܢ ܩܲܕܡ ܕܛܘܼܪܹ̈ܐ ܦܵܝܫܝܼ ܗܘܵܘ ܝܠܝܼܕܹܐ، ܘܬܲܪܨܸܬ ܗܘܵܐ ܐܲܪܥܵܐ ܘܒܪܝܼܬܵ‌ܐ، ܡ̣ܢ ܥܵܠܲܡ ܘܥܵܠܲܡ ܐܲܢ݇ܬ ܝܼܘܸܬ ܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","ܟܹܐ ܡܲܕܸܪܸܬ ܠܹܗ ܐܢܵܫܵܐ ܠܥܲܦܪܵܐ، ܘܟܹܐ ܐܵܡܪܹܬ: ”ܕܘܼܪܘܼܢ، ܝܵܐ ܒܢܲܝ̈ܢܵܫܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","ܣܵܒܵܒ ܐܲܠܦܵܐ ܫܸܢܹ̈ܐ ܒܥܲܝ̈ܢܘܼܟ݂، ܐܲܝܟ݂ ܐܬܸܡܵܠܝ ܝܢܵܐ ܕܥܒ݂ܝܼܪܹܗ، ܘܐܲܝܟ݂ ܒܲܕܠܵܐ ܕܠܲܝܠܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","ܓܪܝܼܦܵܝ ܠܘܼܟ݂، ܗܘܹܐ ܠܗܘܿܢ ܐܲܝܟ݂ ܫܸܢܬܵ‌ܐ، ܐܲܝܟ݂ ܓܸܠܵܐ ܕܡܲܩܝܸܢ ܒܨܲܦܪܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","ܒܨܲܦܪܵܐ ܟܹܐ ܡܲܓ̰ܝܸܢ ܘܟܹܐ ܡܲܩܝܸܢ، ܒܪܲܡܫܵܐ ܟܹܐ ܟ̰ܵܡܹܟ̃ ܘܟܹܐ ܒܵܪܹܙ. ");
INSERT INTO aii_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","ܣܵܒܵܒ ܬܝܼܡ ܠܲܢ ܒܟܲܪܒܘܼܟ݂، ܘܒܚܸܡܬܘܼܟ݂ ܦܝܼܫ ܠܲܢ ܫܓ݂ܝܼܫܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","ܡܘܼܬܸܒ݂ ܠܘܼܟ݂ ܥܵܘܠܲܢ̈ ܠܒܲܠܩܘܼܒ݂ܠܘܼܟ݂، ܚܛܵܗܲܢ̈ ܛܸܫܝܹ̈ܐ ܩܲܕܡ ܒܲܗܪܵܐ ܕܦܵܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","ܣܵܒܵܒ ܟܠܵܝܗ‌ܝ ܝܵܘܡܵܢܲܢ̈ ܥܒ݂ܝܼܪܗܘܿܢ ܒܚܸܡܬܘܼܟ݂، ܬܝܼܡܵܝ ܠܲܢ ܫܸܢܲܢ̈ ܐܲܝܟ݂ ܬܲܢܲܚܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","ܝܵܘܡܵܢܹ̈ܐ ܕܚܲܝܲܢ̈ ܫܲܒ݂ܥܝܼ ܫܸܢܹ̈ܐ ܝܢܵܐ، ܘܐܸܢ ܒܓܲܒܵܪܘܼܬܵ‌ܐ، ܬܡܵܢܝܼ ܫܸܢܹ̈ܐ، ܒܪܲܒܘܼܬܵܝܗ‌ܝ ܥܲܡܠܵܐ ܘܕܲܪܕ، ܣܵܒܵܒ ܟܹܐ ܥܵܒ݂ܪܝܼ ܓ̰ܲܠܕܹܐ ܘܟܹܐ ܦܵܪܚܲܚ. ");
INSERT INTO aii_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","ܡܵܢܝܼ ܝܵܕܹܥ ܚܲܝܠܵܐ ܕܚܸܡܬܘܼܟ݂، ܣܵܒܵܒ ܗܲܪ ܐܲܝܟ݂ ܙܕܘܼܥܬܵ‌ܐ ܕܡܸܢܘܼܟ݂ ܝܼܠܵܗ̇ ܟܲܪܒܘܼܟ݂؟ ");
INSERT INTO aii_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","ܗܵܕܟ݂ܵܐ ܡܲܕܸܥ ܠܲܢ ܠܸܡܢܵܝܵܐ ܝܵܘܡܵܢܲܢ̈، ܕܡܵܛܲܚ ܠܠܸܒܵܐ ܕܚܸܟ݂ܡܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","ܕܘܼܪ، ܝܵܐ ܡܵܪܝܵܐ! ܗܲܠܔ ܐܝܼܡܲܢ؟ ܘܪܲܚܸܡ ܥܲܠܔ ܪܹ̈ܓܵܘܵܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","ܡܲܣܒܸܥ ܠܲܢ ܒܨܲܦܪܵܐ ܒܛܲܝܒܘܼܬܘܼܟ݂، ܕܫܲܒܚܲܚ ܘܚܵܕܲܚ ܒܟܠܵܝܗ‌ܝ ܝܵܘܡܵܢܲܢ̈. ");
INSERT INTO aii_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","ܡܲܚܕܝܼ ܠܲܢ ܐܲܝܟ݂ ܝܵܘܡܵܢܹ̈ܐ ܕܩܵܡ ܡܲܠܝܸܨܸܬ ܠܲܢ، ܐܲܝܟ݂ ܫܸܢܹ̈ܐ ܕܚܙܹܐ ܠܲܢ ܒܝܼܫܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","ܦܵܐܹܫ ܚܸܙܝܵܐ ܠܪܹ̈ܓܵܘܵܬܘܼܟ݂ ܦܘܼܠܚܵܢܘܼܟ݂، ܘܫܘܼܒ݂ܚܘܼܟ݂ ܠܒܢܘܿܢܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","ܘܗܵܘܝܵܐ ܒܲܣܝܼܡܘܼܬܵ‌ܐ ܕܡܵܪܝܵܐ ܐܲܠܵܗܵܐ ܥܲܠܲܢ، ܘܥܒ݂ܵܕܵܐ ܕܐܝܼܕܵܬܲܢ̈ ܡܲܩܘܹܐ ܥܲܠܲܢ، ܘܥܒ݂ܵܕܵܐ ܕܐܝܼܕܵܬܲܢ̈ ܡܲܩܘܹܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","ܝܵܬܒ݂ܵܢܵܐ ܒܣܸܬܵܪܵܐ ܕܥܸܠܵܝܵܐ، ܒܛܸܠܵܢܝܼܬܵ‌ܐ ܕܚܲܝܠܬܵܢܵܐ ܒܸܬ ܫܵܪܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","ܒܸܬ ܐܵܡܪܹܢ ܒܘܼܬ ܡܵܪܝܵܐ: ”ܗ̇ܘ ܝܼܠܹܗ ܒܹܝܬ ܓܵܘܣܝܼ ܘܚܸܣܢܝܼ، ܐܲܠܵܗ‌ܝܼ، ܒܸܬ ܣܵܒܪܹܢ ܒܝܼܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","ܒܗ̇ܝ ܕܗ̇ܘ ܒܸܬ ܦܲܨܹܐ ܠܘܼܟ݂ ܡ̣ܢ ܢܸܫܒ݂ܵܐ ܕܨܲܝܵܕܵܐ، ܡ̣ܢ ܡܲܪ̈ܥܹܐ ܩܵܛܠܵܢܹ̈ܐ ܘܛܲܠܩܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","ܒܦܲܪ̈ܘܼܗ‌ܝ ܒܸܬ ܟܲܣܹܐ ܠܘܼܟ݂، ܘܬܚܘܿܬ ܓܘܼܠܦܵܢܘܼ̈ܗ‌ܝ ܒܸܬ ܥܵܪܩܹܬ، ܣܲܟܪܵܐ ܘܡܵܛܵܠܵܐ ܝܠܵܗ̇ ܫܲܪܝܼܪܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","ܠܹܐ ܙܵܕܥܹܬ ܡ̣ܢ ܙܕܘܼܥܬܵ‌ܐ ܕܠܲܝܠܹܐ، ܡ̣ܢ ܓܹܐܪܵܐ ܕܦܵܪܹܚ ܒܐܝܼܡܵܡܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","ܡ̣ܢ ܡܲܪܥܵܐ ܩܵܛܠܵܢܵܐ ܕܚܵܕܹܪ ܒܚܸܫܟܵܐ، ܡ̣ܢ ܡܲܚܪܲܒ݂ܬܵ‌ܐ ܕܛܲܠܩܵܐ ܒܛܲܗܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","ܟܲܕ ܢܵܦܠܝܼ ܐܲܠܦܵܐ ܡ̣ܢ ܕܸܦܢܘܼܟ݂، ܘܪܸܒܘܼܬܵ‌ܐ ܡ̣ܢ ܝܲܡܝܼܢܘܼܟ݂، ܠܟܸܣܠܘܼܟ݂ ܠܹܐ ܩܲܪܒܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","ܐܲܚܟ̰ܝܼ ܒܥܲܝ̈ܢܘܼܟ݂ ܒܸܬ ܚܵܝܪܹܬ، ܘܦܘܼܪܥܵܢܵܐ ܕܪ̈ܲܫܝܼܥܹܐ ܒܸܬ ܚܵܙܹܝܬ. ");
INSERT INTO aii_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","ܒܗ̇ܝ ܕܠܡܵܪܝܵܐ ܥܸܠܵܝܵܐ، ܗ̇ܘ ܕܝܼܠܹܗ ܒܹܝܬ ܓܵܘܣܝܼ، ܥܒ݂ܝܼܕ ܠܘܼܟ݂ ܡܲܥܡܪܘܼܟ݂، ");
INSERT INTO aii_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","ܠܹܐ ܬܵܦܩܵܐ ܒܝܼܘܼܟ݂ ܒܝܼܫܬܵ‌ܐ، ܘܠܹܐ ܩܲܪܒܸܢܵܐ ܠܡܲܫܟܢܘܼܟ݂ ܡܚܘܿܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","ܣܵܒܵܒ ܒܸܬ ܦܵܩܹܕ ܠܡܲܠܲܐܟ݂ܘܼ̈ܗ‌ܝ ܒܘܼܬ ܕܝܼܘܼܟ݂، ܕܢܵܛܪܝܼ ܠܘܼܟ݂ ܒܟܠܵܝܗ‌ܝ ܐܘܼܪ̈ܚܵܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","ܥܲܠܔ ܐܝܼܕܵܬܵܝ̈ܗ‌ܝ ܒܸܬ ܛܵܥܢܝܼ ܠܘܼܟ݂، ܕܠܵܐ ܬܲܪܩܸܠܵܐ ܒܟܹܐܦܵܐ ܐܲܩܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","ܥܲܠܔ ܐܲܪܝܵܐ ܘܦܲܬܢܵܐ ܒܸܬ ܦܵܣܥܹܬ، ܓܘܼܪܝܵܐ ܕܐܲܪܝܵܐ ܘܬܲܢܝܼܢܵܐ ܒܸܬ ܕܲܫܕܸܫܸܬ. ");
INSERT INTO aii_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","”ܒܸܬ ܦܲܨܹܢܹܗ ܣܵܒܵܒ ܡܘܼܚܸܒ ܠܹܗ ܐܸܠܝܼ، ܒܸܬ ܡܲܪܡܸܢܹܗ ܠܫܲܝܢܵܐ ܒܗ̇ܝ ܕܝܕܝܼܥ ܠܹܗ ܫܸܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","”ܒܸܬ ܓ̰ܲܘܸܒܸܢܹܗ ܐܝܼܡܲܢ ܕܩܵܪܹܐ ܠܝܼ، ܥܲܡܹܗ ܝܘܸܢ ܐܵܢܵܐ ܒܥܕܵܢܵܐ ܕܥܵܘܩܵܢܵܐ، ܒܸܬ ܦܲܨܹܢܹܗ ܘܒܸܬ ܡܝܲܩܪܸܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","”ܒܝܘܼܪܟ݂ܵܐ ܕܝܵܘܡܵܢܹ̈ܐ ܒܸܬ ܡܲܣܒܸܥܸܢܹܗ، ܘܒܸܬ ܡܲܚܙܹܝܢ ܐܸܠܹܗ ܦܘܼܪܩܵܢܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","ܨܦܵܝܝܼ ܝܠܵܗ̇ ܠܫܲܟܘܼܪܹܐ ܠܡܵܪܝܵܐ، ܘܠܸܙܡܵܪܵܐ ܠܫܸܡܘܼܟ݂، ܝܵܐ ܥܸܠܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","ܠܡܲܕܘܼܥܹܐ ܒܨܲܦܪܵܐ ܛܲܝܒܘܼܬܘܼܟ݂، ܘܒܠܲܝܠܵܘܵܬܹ̈‌ܐ ܡܗܘܼܡܢܘܼܬܘܼܟ݂، ");
INSERT INTO aii_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","ܥܲܠܔ ܡܵܐܢܹ̈ܐ ܕܙܡܵܪܵܐ ܕܥܸܣܪܵܐ ܣܝܼܡܹ̈ܐ، ܘܥܲܠܔ ܩܝܼܬܵܪܵܐ، ܥܲܠܔ ܗܵܘܵܙ ܕܟܸܢܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","ܒܗ̇ܝ ܕܩܵܡ ܡܲܚܕܹܝܬ ܠܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܒܦܘܼܠܚܵܢܘܼܟ݂، ܒܘܼܬ ܦܘܼܠܚܵܢܹ̈ܐ ܕܐܝܼܕܵܬܘܼ̈ܟ݂ ܒܸܬ ܫܲܒܚܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","ܟܡܵܐ ܓܘܼܪܹ̈ܐ ܝܢܵܐ ܦܘܼܠܚܵܢܘܼ̈ܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܪܵܒܵܐ ܥܲܡܘܼܩܹ̈ܐ ܝܢܵܐ ܚܘܼܫܵܒ݂ܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","ܐܢܵܫܵܐ ܫܹܐܕܵܢܵܐ ܠܹܐ ܝܵܕܹܥ، ܘܣܲܟ݂ܠܵܐ ܠܹܐ ܦܲܪܡܹܐ ܐܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","ܐܝܼܡܲܢ ܕܒܲܪܛܸܢܝܼ ܪ̈ܲܫܝܼܥܹܐ ܐܲܝܟ݂ ܓܸܠܵܐ، ܘܦܵܩܚܝܼ ܟܠܵܝܗ‌ܝ ܦܵܠܚܵܢܹ̈ܐ ܕܥܵܘܠܵܐ، ܗܵܕܟ݂ܵܐ ܟܹܐ ܗܵܘܝܵܐ ܕܦܵܝܫܝܼ ܛܘܼܠܩܹܐ ܗܲܠܔ ܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","ܐܝܼܢܵܐ ܐܲܢ݇ܬ ܪܵܡܵܐ ܝܘܸܬ ܠܥܵܠܲܡ، ܝܵܐ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","ܒܗ̇ܝ ܕܗܵܐ، ܕܸܫ̃ܡܸܢܘܼ̈ܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܒܗ̇ܝ ܕܗܵܐ، ܕܸܫ̃ܡܸܢܘܼ̈ܟ݂ ܒܸܬ ܛܵܠܩܝܼ، ܒܸܬ ܦܵܝܫܝܼ ܒܘܼܪܒܸܙܹܐ ܟܠܵܝܗ‌ܝ ܦܵܠܚܵܢܹ̈ܐ ܕܥܵܘܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","ܘܡܘܼܪܸܡ ܠܘܼܟ݂ ܩܲܪ݇ܢܝܼ ܐܲܝܟ݂ ܩܲܪ݇ܢܵܐ ܕܪܲܝܡܵܐ، ܦܝܼܫ ܠܝܼ ܡܫܝܼܚܵܐ ܒܡܸܫܚܵܐ ܚܵܕܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","ܘܚܙܹܐ ܠܵܗ̇ ܥܲܝܢܝܼ ܙܵܟ݂ܘܼܬܵ‌ܐ ܠܕܸܫ̃ܡܸܢܝܼ̈، ܫܡܝܼܥ ܠܗܘܿܢ ܢܵܬܝܵܬ‌ܝܼ̈ ܒܘܼܬ ܩܵܝܡܵܢܹ̈ܐ ܥܲܠܝܼ، ܥܵܒ݂ܕܵܢܹ̈ܐ ܕܒܝܼܫܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","ܙܲܕܝܼܩܵܐ ܐܲܝܟ݂ ܐܝܼܠܵܢܵܐ ܕܚܘܼܪ̈ܡܹܐ ܒܸܬ ܒܲܪܛܸܢ، ܐܲܝܟ݂ ܐܲܪ̈ܙܹܐ ܕܒܠܸܒ݂ܢܵܢ ܒܸܬ ܓܲܪܘܸܣ. ");
INSERT INTO aii_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","ܫܬܝܼܠܹܐ ܝܢܵܐ ܒܒܲܝܬܵ‌ܐ ܕܡܵܪܝܵܐ، ܒܕܵܪ̈ܵܬܹ‌ܐ ܕܐܲܠܵܗܲܢ ܒܸܬ ܒܲܪܛܸܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","ܗܸܫ ܒܸܬ ܡܲܝܬ‌ܝܼ ܛܥܘܼܢܬܵ‌ܐ ܒܣܲܝܒܘܼܬܵ‌ܐ، ܫܲܡܝܼܢܹ̈ܐ ܘܩܝܼܢܹ̈ܐ ܒܸܬ ܗܵܘܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","ܠܡܲܕܘܼܥܹܐ ܕܬܪܘܼܨܵܐ ܝܠܹܗ ܡܵܪܝܵܐ، ܐܝܼܨܵܪܝܼ، ܘܠܲܝܬ ܥܵܘܠܵܐ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","ܡܵܪܝܵܐ ܒܸܥܒ݂ܵܕܵܐ ܝܠܹܗ ܡܲܠܟܘܼܬܵ‌ܐ، ܠܒ݂ܝܼܫܵܐ ܝܠܹܗ ܚܸܩܪܵܐ، ܠܒ݂ܝܼܫܵܐ ܝܠܹܗ ܡܵܪܝܵܐ ܥܘܼܫܢܵܐ ܘܚܠܝܼܨܘܼܗ̇ ܝܠܹܗ ܓܵܢܹܗ، ܐܘܼܦ ܡܘܼܩܘܝܼܬܵ‌ܐ ܝܠܵܗ̇ ܒܪܝܼܬܵ‌ܐ ܕܠܵܐ ܫܵܥܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","ܡܘܼܩܘܝܼܵܐ ܝܠܹܗ ܟܘܼܪܣܝܘܼܟ݂ ܡ̣ܢ ܙܲܒ݂ܢܵܐ ܩܲܕܝܼܡܵܝܵܐ، ܡ̣ܢ ܥܵܠܲܡ ܐܲܢ݇ܬ ܝܼܘܸܬ. ");
INSERT INTO aii_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","ܡܘܼܪܸܡ ܠܗܘܿܢ ܢܲܗܪ̈ܵܘܵܬܹ‌ܐ، ܝܵܐ ܡܵܪܝܵܐ، ܡܘܼܪܸܡ ܠܗܘܿܢ ܢܲܗܪ̈ܵܘܵܬܹ‌ܐ ܩܵܠܵܝܗ‌ܝ، ܡܲܪܘܼܡܹܐ ܝܢܵܐ ܢܲܗܪ̈ܵܘܵܬܹ‌ܐ ܓܲܒܓܲܒܬܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","ܒܘܼܫ ܡ̣ܢ ܩܵܠܹ̈ܐ ܕܡ̈ܝܼܵܐ ܪܵܒܵܐ، ܒܘܼܫ ܡ̣ܢ ܠܲܦܹ̈ܐ ܙܲܪ̈ܒܵܢܹܐ ܕܝܵܡܵܐ، ܙܲܪܒܵܢܵܐ ܝܠܹܗ ܒܲܡܪܵܘܡܵܐ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","ܣܵܗܕܘܵܬܘܼ̈ܟ݂ ܡܗܘܼܡܢܹ̈ܐ ܝܢܵܐ ܪܵܒܵܐ، ܠܒܲܝܬܘܼܟ݂ ܟܹܐ ܠܵܚܡܵܐ ܩܲܕܝܼܫܘܼܬܵ‌ܐ، ܝܵܐ ܡܵܪܝܵܐ، ܠܝܘܼܪܟ݂ܵܐ ܕܝܵܘܡܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","ܝܵܐ ܐܲܠܵܗܵܐ ܫܵܩܠܵܢܵܐ ܕܬܘܼܥܠܵܐ، ܝܵܐ ܡܵܪܝܵܐ، ܝܵܐ ܐܲܠܵܗܵܐ ܫܵܩܠܵܢܵܐ ܕܬܘܼܥܠܵܐ، ܙܪܘܿܩ. ");
INSERT INTO aii_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","ܦܘܼܫ ܪܝܼܡܵܐ، ܝܵܐ ܕܲܝܵܢܵܐ ܕܐܲܪܥܵܐ، ܡܲܕܸܪ ܦܘܼܪܥܵܢܵܐ ܥܲܠܔ ܚܵܬܪ̈ܵܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","ܗܲܠܔ ܐܝܼܡܲܢ ܪ̈ܲܫܝܼܥܹܐ، ܝܵܐ ܡܵܪܝܵܐ، ܗܲܠܔ ܐܝܼܡܲܢ ܪ̈ܲܫܝܼܥܹܐ ܦܵܨܚܝܼ؟ ");
INSERT INTO aii_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","ܟܹܐ ܓܲܒܓܸܒܝܼ، ܟܹܐ ܗܲܡܙܸܡܝܼ ܒܫܘܼܒ݂ܗܵܪܵܐ، ܟܹܐ ܚܵܬܪܝܼ ܒܓܵܢܵܝܗ‌ܝ ܟܠܵܝܗ‌ܝ ܦܵܠܚܵܢܹ̈ܐ ܕܥܵܘܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","ܠܥܲܡܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܟܹܐ ܛܲܚܛܸܚܝܼ، ܘܠܝܵܪܬܘܼܬܘܼܟ݂ ܟܹܐ ܡܲܠܝܸܨܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","ܠܐܲܪܡܸܠܬܵ‌ܐ ܘܠܡܵܫܵܚܲܛ ܟܹܐ ܩܵܛܠܝܼ، ܘܠܝܲܬܘܼܡܹ̈ܐ ܟܹܐ ܡܲܡܝܸܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","ܘܟܹܐ ܐܵܡܪܝܼ: ”ܠܹܐ ܚܵܙܹܐ ܡܵܪܝܵܐ، ܘܐܲܠܵܗܵܐ ܕܝܲܥܩܘܿܒ݂ ܠܹܐ ܡܲܣܸܡ ܒܵܠܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","ܡܲܣܸܡܘܼܢ ܒܵܠܵܐ، ܝܵܐ ܐܲܗܡܲܩܹ̈ܐ ܕܓܵܘ ܥܲܡܵܐ؛ ܐܝܼܡܲܢ ܒܸܬ ܦܲܪܡܹܝܬܘܿܢ، ܝܵܐ ܣܲܟ݂ܠܹ̈ܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","ܢܵܨܒ݂ܵܢܵܐ ܕܢܵܬܵ‌ܐ، ܗܵܐ، ܠܹܐ ܫܵܡܹܥ؟ ܝܲܢ ܓܵܒ݂ܠܵܢܵܐ ܕܥܲܝܢܵܐ، ܗܵܐ، ܠܹܐ ܚܵܙܹܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","ܬܲܠܡܸܕܵܢܵܐ ܕܐܸܡܘܵܬܹ̈‌ܐ، ܗܵܐ، ܠܹܐ ܡܲܢܟܸܣ، ܗ̇ܘ ܕܟܹܐ ܡܲܠܸܦ ܝܕܵܥܬܵ‌ܐ ܠܒܲܪܢܵܫܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","ܡܵܪܝܵܐ ܟܹܐ ܝܵܕܹܥ ܚܘܼܫܵܒܹ̈ܐ ܕܐܢܵܫܵܐ ܕܣܪܝܼܩܘܼܬܵ‌ܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","ܛܘܼܒ݂ܵܐ ܠܐܢܵܫܵܐ ܕܬܲܠܡܸܕܸܬ ܠܹܗ، ܝܵܐ ܡܵܪܝܵܐ، ܘܡ̣ܢ ܢܵܡܘܿܣܘܼܟ݂ ܡܲܠܦܸܬ ܠܹܗ، ");
INSERT INTO aii_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","ܠܝܼܵܗܒܹܗ ܢܝܵܚܵܐ ܡ̣ܢ ܝܵܘܡܵܢܹ̈ܐ ܕܒܝܼܫܬܵ‌ܐ، ܗܲܠܔ ܕܦܵܐܹܫ ܚܦܝܼܪܵܐ ܓܘܼܒܵܐ ܠܪܲܫܝܼܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","ܣܵܒܵܒ ܠܹܐ ܪܲܦܹܐ ܡܵܪܝܵܐ ܠܥܲܡܹܗ، ܘܠܝܵܪܬܘܼܬܹܗ ܠܹܐ ܫܵܒܹܩ. ");
INSERT INTO aii_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","ܣܵܒܵܒ ܠܙܲܕܝܼܩܘܼܬܵ‌ܐ ܒܸܬ ܕܵܝܪܵܐ ܕܝܼܘܵܢ، ܘܒܸܬ ܐܵܙܠ݇ܝܼ ܒܵܬܪܘܼܗ̇ ܟܠܵܝܗ‌ܝ ܬܪ̈ܘܼܨܹܐ ܕܠܸܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","ܡܵܢܝܼ ܒܸܬ ܩܵܐܹܡ ܩܵܬ‌ܝܼ ܕܲܠܩܘܼܒ݂ܠܔ ܕܥܵܒ݂ܕܵܢܹ̈ܐ ܕܒܝܼܫܬܵ‌ܐ؟ ܡܵܢܝܼ ܒܸܬ ܟܵܠܹܐ ܩܵܬ‌ܝܼ ܕܲܠܩܘܼܒ݂ܠܔ ܕܦܵܠܚܵܢܹ̈ܐ ܕܥܵܘܠܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","ܐܸܢ ܠܵܐ ܗܵܘܹܐ ܗܘܵܐ ܡܵܪܝܵܐ ܗܲܝܲܪܬܵ‌ܐ ܐܸܠܝܼ، ܒܵܬܪ ܚܲܕܟ̰ܵܐ ܒܸܬ ܫܵܪܝܵܐ ܗܘܵܐ ܓܵܢܝܼ ܒܕܘܼܝܵܪܵܐ ܕܫܸܬܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","ܐܸܢ ܐܡܝܼܪܝܼ: ”ܓ̰ܪܝܼܛ ܠܵܗ̇ ܐܲܩܠܝܼ،“ ܛܲܝܒܘܼܬܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܟܹܐ ܣܵܢܕܵܐ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","ܟܲܕ ܙܵܝܕܝܼ ܚܲܡܝܼ̈ ܒܓܵܘܝܼ، ܒܘܼܝܵܐܘܼ̈ܟ݂ ܟܹܐ ܡܲܚܕܝܼ ܠܓܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","ܗܵܐ، ܡܵܨܝܼ ܥܵܒ݂ܕܝܼ ܚܲܒ݂ܪܘܼܬܵ‌ܐ ܥܲܡܘܼܟ݂ ܫܘܼܠܛܵܢܹ̈ܐ ܕܛܠܘܼܡܝܵܐ، ܐܵܢܝܼ ܕܟܹܐ ܓܵܒ݂ܠܝܼ ܡܲܠܝܲܨܬܵ‌ܐ ܒܩܵܢܘܿܢܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","ܘܟܹܐ ܓ̰ܵܡܥܝܼ ܥܲܠܔ ܓܵܢܵܐ ܕܙܲܕܝܼܩܵܐ، ܘܕܸܡܵܐ ܙܲܟܵܝܵܐ ܟܹܐ ܥܵܒ݂ܕܝܼ ܚܲܝܵܒ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","ܐܝܼܢܵܐ ܗܘܹܐ ܠܹܗ ܡܵܪܝܵܐ ܐܸܠܝܼ ܩܲܠܥܵܐ، ܘܐܲܠܵܗ‌ܝܼ ܐܝܼܨܵܪܵܐ ܕܒܹܝܬ ܓܵܘܣܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","ܘܒܸܬ ܡܲܕܸܪ ܥܲܠܵܝܗ‌ܝ ܥܵܘܠܵܝܗ‌ܝ، ܘܓܵܘ ܒܝܼܫܘܼܬܵܝܗ‌ܝ ܒܸܬ ܛܲܠܸܩ ܠܗܘܿܢ، ܒܸܬ ܛܲܠܸܩ ܠܗܘܿܢ ܡܵܪܝܵܐ ܐܲܠܵܗܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","ܬܹܝܡܘܼܢ ܫܲܒܚܲܚ ܠܡܵܪܝܵܐ، ܩܲܘܸܚܲܚ ܠܐܝܼܨܵܪܵܐ ܕܦܘܼܪܩܵܢܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","ܐܵܬܲܚ ܩܲܕܡ ܦܵܬܹܗ ܒܫܲܟܲܪܬܵ‌ܐ، ܩܲܘܸܚܲܚ ܐܸܠܹܗ ܒܙܡܵܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","ܣܵܒܵܒ ܐܲܠܵܗܵܐ ܓܘܼܪܵܐ ܝܠܹܗ ܡܵܪܝܵܐ، ܘܡܲܠܟܵܐ ܓܘܼܪܵܐ ܥܲܠܔ ܟܠܵܝܗ‌ܝ ܐܲܠܵܗܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","ܗ̇ܘ ܕܒܐܝܼܕܹܗ ܝܢܵܐ ܥܘܼܡܩܹ̈ܐ ܕܐܲܪܥܵܐ، ܘܕܝܼܹܗ ܝܢܵܐ ܪܹ̈ܝܫܹܐ ܕܛܘܼܪ̈ܵܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","ܕܝܼܹܗ ܝܠܵܗ̇ ܝܵܡܵܐ ܘܗ̇ܘ ܥܒ݂ܝܼܕܵܐ ܠܹܗ، ܘܐܝܼܕܵܬܘܼ̈ܗ‌ܝ ܓܒ݂ܝܼܠܔ ܠܗܘܿܢ ܒܸܪܙܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","ܬܹܝܡܘܼܢ ܣܵܓ݂ܕܲܚ ܘܟܵܝܦܲܚ، ܒܵܪܟܲܚ ܩܲܕܡ ܡܵܪܝܵܐ ܒܵܪܝܵܢܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","ܣܵܒܵܒ ܗ̇ܘ ܝܼܠܹܗ ܐܲܠܵܗܲܢ، ܘܐܲܚܢܲܢ ܥܲܡܵܐ ܕܡܲܪܥܝܼܬܹܗ ܘܥܸܪ̈ܒܹܐ ܕܓܵܘ ܐܝܼܕܹܗ. ܐܸܕܝܘܿܡ ܐܸܢ ܩܵܠܹܗ ܫܵܡܥܝܼܬܘܿܢ، ");
INSERT INTO aii_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","ܠܵܐ ܡܲܩܫܹܝܬܘܿܢ ܠܸܒܵܘܟ݂ܘܿܢ ܕܵܐܟ݂ܝܼ ܕܓܵܘ ܡܪܝܼܒ݂ܵܐ، ܐܲܝܟ݂ ܝܵܘܡܵܐ ܕܡܲܣܵܐ ܓܵܘ ܒܲܪܝܼܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","ܐܝܼܡܲܢ ܕܓ̰ܘܼܪܒܸܢܗܘܿܢ ܐܲܒ݂ܵܗܵܬܵܘ̈ܟ݂ܘܿܢ، ܨܘܼܚܨܹܐ ܠܗܘܿܢ ܐܸܠܝܼ، ܐܵܦܸܢ ܚܸܙܝܹܐ ܝܗܘܵܘ ܦܘܼܠܚܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","ܐܲܪܒܥܝܼ ܫܸܢܹ̈ܐ ܣܩܝܼܕ ܠܝܼ ܒܗ̇ܘ ܕܵܪܵܐ، ܘܐܡܝܼܪܝܼ: ܥܲܡܵܐ ܚܵܠܛܵܢܵܐ ܒܠܸܒܵܐ ܝܢܵܐ ܐܵܢܝܼ، ܘܐܵܢܝܼ ܠܵܐ ܝܕܝܼܥ ܠܗܘܿܢ ܐܘܼܪ̈ܚܵܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","ܒܘܼܬ ܐܵܗܵܐ، ܝܡܹܐ ܠܝܼ ܒܟܲܪܒܝܼ، ܕܠܹܐ ܥܵܒ݂ܪܝܼ ܠܢܝܵܚܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","ܙܡܘܿܪܘܼܢ ܠܡܵܪܝܵܐ ܙܡܵܪܬܵ‌ܐ ܚܲܕܬܵ‌ܐ، ܙܡܘܿܪܘܼܢ ܠܡܵܪܝܵܐ ܟܠܵܗ̇ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","ܙܡܘܿܪܘܼܢ ܠܡܵܪܝܵܐ، ܒܲܪܟ݂ܘܼܢ ܠܫܸܡܹܗ، ܡܲܫܚܸܕܘܼܢ ܦܘܼܪܩܵܢܹܗ ܡ̣ܢ ܝܵܘܡܵܐ ܠܝܵܘܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","ܗܲܩܹܝܡܘܼܢ ܓܵܘ ܐܸܡܘܵܬܹ̈‌ܐ ܐܝܼܩܵܪܹܗ، ܓܵܘ ܟܠܵܝܗ‌ܝ ܥܲܡܡܹ̈ܐ ܕܘܼܡܵܪ̈ܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","ܣܵܒܵܒ ܓܘܼܪܵܐ ܝܠܹܗ ܡܵܪܝܵܐ ܘܡܫܘܼܒܚܵܐ ܝܠܹܗ ܪܵܒܵܐ، ܣܲܗܡܵܢܵܐ ܝܠܹܗ ܥܲܠܔ ܟܠܵܝܗ‌ܝ ܐܲܠܵܗܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","ܣܵܒܵܒ ܟܠܵܝܗ‌ܝ ܐܲܠܵܗܹ̈ܐ ܕܥܲܡܡܹ̈ܐ ܨܵܢܲܡܹ̈ܐ ܣܪ̈ܝܼܩܹܐ ܝܢܵܐ، ܐܝܼܢܵܐ ܡܵܪܝܵܐ ܥܒ݂ܝܼܕ ܠܹܗ ܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","ܚܸܩܪܵܐ ܘܙܲܗܝܘܼܬܵ‌ܐ ܩܲܕܡܘܼܗ‌ܝ ܝܢܵܐ، ܥܘܼܫܢܵܐ ܘܣܸܩܠܵܐ ܓܵܘ ܡܲܩܕܫܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","ܗܲܒ݂ܠܘܼܢ ܠܡܵܪܝܵܐ، ܝܵܐ ܫܲܪ̈ܒܵܬܹ‌ܐ ܕܥܲܡܡܹ̈ܐ، ܗܲܒ݂ܠܘܼܢ ܠܡܵܪܝܵܐ ܐܝܼܩܵܪܵܐ ܘܥܘܼܫܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","ܗܲܒ݂ܠܘܼܢ ܠܡܵܪܝܵܐ ܐܝܼܩܵܪܵܐ ܕܫܸܡܹܗ، ܫܩܘܿܠܘܼܢ ܩܘܼܪܒܵܢܵܐ ܘܥܒ݂ܘܿܪܘܼܢ ܠܕܵܪ̈ܵܬܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","ܣܓ݂ܘܿܕܘܼܢ ܠܡܵܪܝܵܐ ܒܣܸܩܠܵܐ ܕܩܘܼܕܫܵܐ، ܪܵܓܕܵܐ ܡ̣ܢ ܩܲܕܡܘܼܗ‌ܝ ܟܠܵܗ̇ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","ܐܡܘܿܪܘܼܢ ܓܵܘ ܐܸܡܘܵܬܹ̈‌ܐ: ܡܵܪܝܵܐ ܒܸܥܒ݂ܵܕܵܐ ܝܠܹܗ ܡܲܠܟܘܼܬܵ‌ܐ، ܐܘܼܦ ܡܘܼܩܘܝܼܬܵ‌ܐ ܝܠܵܗ̇ ܒܪܝܼܬܵ‌ܐ ܕܠܵܐ ܫܵܥܫܵܐ، ܒܸܬ ܕܵܐܹܢ ܠܥܲܡܡܹ̈ܐ ܒܬܪܘܼܨܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","ܚܵܕܝܼ ܫܡܲܝܹ̈ܐ ܘܦܵܨܚܵܐ ܐܲܪܥܵܐ، ܒܲܪܒܸܪܵܐ ܝܵܡܵܐ ܘܡܸܠܝܘܼܬܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","ܦܵܨܚܵܐ ܕܸܫܬܵ‌ܐ ܘܟܠܔ ܕܐܝܼܬ ܓܵܘܘܼܗ̇، ܗ̇ܝܓܵܗ ܒܸܬ ܩܲܘܸܚܝܼ ܟܠܵܝܗ‌ܝ ܐܝܼܠܵܢܹ̈ܐ ܕܡܲܝܫܵܐ ");
INSERT INTO aii_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","ܩܲܕܡ ܡܵܪܝܵܐ؛ ܣܵܒܵܒ ܒܹܐܬܵܝܵܐ ܝܠܹܗ، ܣܵܒܵܒ ܒܹܐܬܵܝܵܐ ܝܠܹܗ ܠܸܕܝܵܢܵܐ ܠܐܲܪܥܵܐ، ܒܸܬ ܕܵܐܹܢ ܠܒܪܝܼܬܵ‌ܐ ܒܙܲܕܝܼܩܘܼܬܵ‌ܐ، ܘܠܥܲܡܡܹ̈ܐ ܒܡܗܘܼܡܢܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","ܡܵܪܝܵܐ ܒܸܥܒ݂ܵܕܵܐ ܝܠܹܗ ܡܲܠܟܘܼܬܵ‌ܐ، ܦܵܨܚܵܐ ܐܲܪܥܵܐ، ܚܵܕܝܼ ܓܵܙܪ̈ܵܬܹ‌ܐ ܦܸܪ̈ܝܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","ܥܢܵܢܵܐ ܘܚܸܫܟܵܐ ܥܲܡܘܼܩܵܐ ܠܚܵܕܸܪ̈ܘܵܢܘܼܗ‌ܝ، ܙܲܕܝܼܩܘܼܬܵ‌ܐ ܘܕܝܼܘܵܢ ܫܲܬܐܸܣܬܵ‌ܐ ܕܟܘܼܪܣܝܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","ܢܘܼܪܵܐ ܩܲܕܡܘܼܗ‌ܝ ܟܹܐ ܐܵܙܹܠܔ، ܘܟܹܐ ܡܲܩܸܕ ܕܸܫ̃ܡܸܢܘܼ̈ܗ‌ܝ ܒܚܵܕܸܪ̈ܘܵܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","ܒܘܼܗܪܸܢܗܘܿܢ ܒܸܪ̈ܩܘܼܗ‌ܝ ܠܒܪܝܼܬܵ‌ܐ، ܚܙܹܐ ܠܵܗ̇ ܘܪܘܼܬܪܸܬ ܠܵܗ̇ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","ܦܫܝܼܪܗܘܿܢ ܛܘܼܪ̈ܵܢܹܐ ܐܲܝܟ݂ ܫܲܡܲܥ ܡ̣ܢ ܩܲܕܡ ܡܵܪܝܵܐ، ܡ̣ܢ ܩܲܕܡ ܡܵܪܵܐ ܕܟܠܵܗ̇ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","ܟܹܐ ܡܲܕܥܝܼ ܫܡܲܝܹ̈ܐ ܙܲܕܝܼܩܘܼܬܹܗ، ܘܚܙܹܐ ܠܗܘܿܢ ܟܠܵܝܗ‌ܝ ܥܲܡܡܹ̈ܐ ܐܝܼܩܵܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","ܢܵܟ݂ܦܝܼ ܟܠܵܝܗ‌ܝ ܦܵܠܚܵܢܹ̈ܐ ܕܨܲܠܡܹ̈ܐ، ܥܵܒ݂ܕܵܢܹ̈ܐ ܕܫܘܼܒ݂ܗܵܪܵܐ ܒܨܵܢܲܡܹ̈ܐ ܣܪ̈ܝܼܩܹܐ. ܣܓ݂ܘܿܕܘܼܢ ܐܸܠܹܗ ܟܠܵܝܗ‌ܝ ܐܲܠܵܗܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","ܫܡܝܼܥ ܠܵܗ̇ ܘܚܕܹܐ ܠܵܗ̇ ܨܸܗܝܘܿܢ، ܘܦܨܝܼܚ ܠܗܘܿܢ ܒܢܵܬܹ̈‌ܐ ܕܝܼܗܘܼܕܵܐ، ܒܘܼܬ ܕܝܼܘܵܢܘܼ̈ܟ݂، ܝܵܐ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","ܣܵܒܵܒ ܐܲܢ݇ܬ، ܝܵܐ ܡܵܪܝܵܐ، ܥܸܠܵܝܵܐ ܝܘܸܬ ܥܲܠܔ ܟܠܵܗ̇ ܐܲܪܥܵܐ، ܦܝܼܫܵܐ ܝܘܸܬ ܡܘܼܪܡܵܐ ܪܵܒܵܐ ܥܲܠܔ ܟܠܵܝܗ‌ܝ ܐܲܠܵܗܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","ܝܵܐ ܡܲܚܸܒܵܢܹ̈ܐ ܕܡܵܪܝܵܐ، ܣܢܹܝܡܘܼܢ ܠܒܝܼܫܬܵ‌ܐ، ܗ̇ܘ ܟܹܐ ܢܵܛܹܪ ܓܵܢܵܬܹ̈‌ܐ ܕܡܗܘܼܡܢܘܼ̈ܗ‌ܝ، ܟܹܐ ܦܲܨܹܐ ܠܗܘܿܢ ܡ̣ܢ ܐܝܼܕܵܐ ܕܪ̈ܲܫܝܼܥܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","ܒܲܗܪܵܐ ܙܪܝܼܩ ܠܹܗ ܠܙܲܕܝܼܩܵܐ، ܘܠܬܪ̈ܘܼܨܹܐ ܕܠܸܒܵܐ ܚܲܕܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","ܚܕܹܝܡܘܼܢ، ܝܵܐ ܙܲܕܝܼܩܹ̈ܐ، ܒܡܵܪܝܵܐ، ܘܫܲܟܪܘܼܢ ܠܕܟ݂ܵܪܵܐ ܕܩܘܼܕܫܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","ܙܡܘܿܪܘܼܢ ܠܡܵܪܝܵܐ ܙܡܵܪܬܵ‌ܐ ܚܲܕܬܵ‌ܐ، ܣܵܒܵܒ ܕܘܼܡܵܪܹ̈ܐ ܥܒ݂ܝܼܕ ܠܹܗ، ܥܒ݂ܝܼܕ ܠܵܗ̇ ܦܘܼܪܩܵܢܵܐ ܐܸܠܹܗ ܝܲܡܝܼܢܹܗ ܘܕܪܲܥܢܵܐ ܕܩܘܼܕܫܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","ܡܘܼܕܸܥ ܠܹܗ ܡܵܪܝܵܐ ܦܘܼܪܩܵܢܹܗ، ܩܲܕܡ ܥܲܝ̈ܢܹܐ ܕܐܸܡܘܵܬܹ̈‌ܐ ܓܠܹܐ ܠܹܗ ܙܲܕܝܼܩܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","ܕܟ݂ܝܼܪܹܗ ܛܲܝܒܘܼܬܹܗ ܘܡܗܘܼܡܢܘܼܬܹܗ ܠܒܹܝܬ ܐܝܼܣܪܵܐܹܝܠܔ، ܚܙܹܐ ܠܗܘܿܢ ܟܠܵܝܗ‌ܝ ܡܲܪ̈ܙܵܢܹܐ ܕܐܲܪܥܵܐ ܦܘܼܪܩܵܢܵܐ ܕܐܲܠܵܗܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","ܩܲܘܸܚܘܼܢ ܠܡܵܪܝܵܐ ܟܠܵܗ̇ ܐܲܪܥܵܐ، ܦܨܘܿܚܘܼܢ ܘܫܲܒܚܘܼܢ ܘܙܡܘܿܪܘܼܢ. ");
INSERT INTO aii_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","ܙܡܘܿܪܘܼܢ ܠܡܵܪܝܵܐ ܒܟܸܢܵܪܵܐ، ܒܟܸܢܵܪܵܐ ܘܩܵܠܵܐ ܕܙܡܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","ܒܢܲܦܝܼܪܹ̈ܐ ܘܩܵܠܵܐ ܕܫܝܼܦܘܿܪܵܐ، ܩܲܘܸܚܘܼܢ ܩܲܕܡ ܡܲܠܟܵܐ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","ܒܲܪܒܸܪܵܐ ܝܵܡܵܐ ܘܡܸܠܝܘܼܬܘܼܗ̇، ܬܹܒܹܝܠܔ ܘܥܵܡܪ̈ܵܢܹܐ ܕܓܵܘܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","ܢܲܗܪ̈ܵܘܵܬܹ‌ܐ ܡܵܚܝܼ ܟ̰ܲܦܹ̈ܐ، ܛܘܼܪ̈ܵܢܹܐ ܩܲܘܸܚܝܼ ܥܲܡ ܚܕܵܕܹ̈ܐ ");
INSERT INTO aii_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","ܩܲܕܡ ܡܵܪܝܵܐ، ܣܵܒܵܒ ܒܹܐܬܵܝܵܐ ܝܠܹܗ ܠܸܕܝܵܢܵܐ ܠܐܲܪܥܵܐ، ܒܸܬ ܕܵܐܹܢ ܬܹܒܹܝܠܔ ܒܙܲܕܝܼܩܘܼܬܵ‌ܐ، ܘܠܥܲܡܡܹ̈ܐ ܒܬܪܘܼܨܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","ܡܵܪܝܵܐ ܒܸܥܒ݂ܵܕܵܐ ܝܠܹܗ ܡܲܠܟܘܼܬܵ‌ܐ، ܪܵܓܕܝܼ ܥܲܡܡܹ̈ܐ، ܒܸܬܝܵܒ݂ܵܐ ܝܠܹܗ ܒܹܝܠܔ ܟܪ̈ܘܿܒܹܐ، ܪܲܬܪܸܬܵ‌ܐ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","ܡܵܪܝܵܐ ܓܘܼܪܵܐ ܝܠܹܗ ܒܨܸܗܝܘܿܢ، ܘܪܵܡܵܐ ܥܲܠܔ ܟܠܵܝܗ‌ܝ ܥܲܡܡܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","ܫܲܟܪܝܼ ܠܫܸܡܘܼܟ݂ ܓܘܼܪܵܐ ܘܣܲܗܡܵܢܵܐ، ܩܲܕܝܼܫܵܐ ܝܠܹܗ ܗ̇ܘ. ");
INSERT INTO aii_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","ܥܘܼܫܢܵܐ ܕܡܲܠܟܵܐ ܟܹܐ ܡܲܚܸܒ ܕܝܼܘܵܢ، ܐܲܢ݇ܬ ܡܘܼܩܘܹܐ ܠܘܼܟ݂ ܬܪܘܼܨܘܼܬܵ‌ܐ، ܕܝܼܘܵܢ ܘܙܲܕܝܼܩܘܼܬܵ‌ܐ ܒܝܲܥܩܘܿܒ݂ ܐܲܢ݇ܬ ܥܒ݂ܝܼܕ ܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","ܡܲܪܡܘܼܢ ܠܡܵܪܝܵܐ ܐܲܠܵܗܲܢ، ܘܣܓ݂ܘܿܕܘܼܢ ܠܟܘܼܒ݂ܫܵܐ ܕܐܲܩܠܵܬܘܼ̈ܗ‌ܝ، ܩܲܕܝܼܫܵܐ ܝܠܹܗ ܗ̇ܘ. ");
INSERT INTO aii_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","ܡܘܼܫܹܐ ܘܐܲܗܪܘܿܢ ܓܵܘ ܟܵܗܢܘܼ̈ܗ‌ܝ، ܘܫܡܘܼܐܹܝܠܔ ܒܩܵܪ̈ܝܵܢܹܐ ܕܫܸܡܹܗ، ܟܹܐ ܩܵܪܝܼ ܗܘܵܘ ܠܡܵܪܝܵܐ، ܘܗ̇ܘ ܟܹܐ ܓ̰ܲܘܸܒ ܗܘܵܐ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","ܒܣܛܘܼܢܵܐ ܕܥܢܵܢܵܐ ܟܹܐ ܗܲܡܙܸܡ ܗܘܵܐ ܥܲܡܵܝܗ‌ܝ، ܢܛܝܼܪܗܘܿܢ ܣܵܗܕܘܵܬܘܼ̈ܗ‌ܝ ܘܩܵܢܘܿܢܵܐ ܕܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","ܝܵܐ ܡܵܪܝܵܐ ܐܲܠܵܗܲܢ، ܐܲܢ݇ܬ ܩܵܡ ܓ̰ܲܘܸܒܸܬ ܠܗܘܿܢ، ܐܲܠܵܗܵܐ ܫܵܒ݂ܩܵܢܵܐ ܗܘܹܐ ܠܘܼܟ݂ ܐܸܠܵܝܗ‌ܝ، ܘܗܸܫ ܫܵܩܠܵܢܵܐ ܕܬܘܼܥܠܵܐ ܥܲܠܔ ܦܘܼܠܚܵܢܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","ܡܲܪܡܘܼܢ ܠܡܵܪܝܵܐ ܐܲܠܵܗܲܢ، ܘܣܓ݂ܘܿܕܘܼܢ ܠܓܹܒܵܐ ܕܛܘܼܪܵܐ ܕܩܘܼܕܫܹܗ، ܣܵܒܵܒ ܩܲܕܝܼܫܵܐ ܝܠܹܗ ܡܵܪܝܵܐ ܐܲܠܵܗܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","ܩܲܘܸܚܘܼܢ ܠܡܵܪܝܵܐ ܟܠܵܗ̇ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","ܦܠܘܿܚܘܼܢ ܠܡܵܪܝܵܐ ܒܚܲܕܘܼܬܵ‌ܐ، ܥܒ݂ܘܿܪܘܼܢ ܩܲܕܡܘܼܗ‌ܝ ܒܬܸܫܒܘܿܚܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","ܝܕܹܥܡܘܼܢ ܕܡܵܪܝܵܐ ܝܠܹܗ ܐܲܠܵܗܵܐ، ܗ̇ܘ ܩܵܡ ܥܵܒܹܕ ܠܲܢ ܘܠܵܐ ܐܲܚܢܲܢ، ܐܢܵܫܘܼ̈ܗ‌ܝ ܝܘܲܚ ܘܥܸܪ̈ܒܹܐ ܕܡܲܪܥܝܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","ܥܒ݂ܘܿܪܘܼܢ ܒܕܲܪ̈ܘܵܙܘܼܗ‌ܝ ܒܫܲܟܲܪܬܵ‌ܐ، ܒܕܵܪ̈ܵܬܘܼܗ‌ܝ ܒܫܘܼܒ݂ܚܵܐ، ܫܲܟܪܘܼܢ ܐܸܠܹܗ، ܒܲܪܟ݂ܘܼܢ ܠܫܸܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","ܣܵܒܵܒ ܛܵܒ݂ܵܐ ܝܠܹܗ ܡܵܪܝܵܐ، ܠܥܵܠܲܡ ܝܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ، ܘܗܲܠܔ ܕܵܪܵܐ ܘܕܵܪܵܐ ܡܗܘܼܡܢܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","ܒܘܼܬ ܛܲܝܒܘܼܬܵ‌ܐ ܘܕܝܼܘܵܢ ܒܸܬ ܙܵܡܪܹܢ، ܐܸܠܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܒܸܬ ܫܲܒܚܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","ܒܸܬ ܐܵܙܹܠ݇ܢ ܒܗܵܘܢܵܐ ܒܐܘܼܪܚܵܐ ܬܲܡܝܼܡܬܵ‌ܐ. ܐܝܼܡܲܢ ܒܸܬ ܐܵܬܹܝܬ ܠܟܸܣܠܝܼ؟ ܒܸܬ ܚܵܕܪܹܢ ܒܬܲܡܝܼܡܘܼܬܵ‌ܐ ܕܠܸܒܝܼ ܒܓܵܘܵܐ ܕܒܲܝܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","ܠܹܐ ܡܲܬܒܸܢ ܩܲܕܡ ܥܲܝܢܝܼ̈ ܡܸܢܕܝܼ ܕܥܵܘܠܵܐ، ܣܢܹܐ ܠܝܼ ܠܥܒ݂ܵܕܵܐ ܕܩܵܠܒܵܢܹ̈ܐ، ܠܹܐ ܕܵܒܹܫ ܒܝܼܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","ܠܸܒܵܐ ܦܟ̰ܝܼܠܵܐ ܒܸܬ ܥܵܒܹܪ ܡܸܢܝܼ، ܒܝܼܫܬܵ‌ܐ ܠܹܐ ܝܵܕܥܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","ܗ̇ܘ ܕܡܵܚܹܐ ܕܲܠܩܘܼܒ݂ܠܔ ܕܚܲܒ݂ܪܹܗ ܒܛܸܫܘܵܐ، ܒܸܬ ܛܲܠܩܸܢ ܐܸܠܹܗ، ܗ̇ܘ ܕܝܼܢܵܐ ܪ̈ܵܡܵܢܹܐ ܥܲܝܢܘܼ̈ܗ‌ܝ ܘܫܲܒ݂ܗܸܪܵܢܵܐ ܠܸܒܹܗ، ܠܹܐ ܡܵܨܹܝܢ ܛܵܥܢܹܢ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","ܥܲܝܢܝܼ̈ ܥܲܠܔ ܡܗܘܼܡܢܹ̈ܐ ܕܐܲܪܥܵܐ ܝܢܵܐ ܕܝܵܬܒ݂ܝܼ ܥܲܡܝܼ، ܗ̇ܘ ܕܚܵܕܹܪ ܒܐܘܼܪܚܵܐ ܬܲܡܝܼܡܬܵ‌ܐ، ܗ̇ܘ ܒܸܬ ܥܵܒܹܕ ܚܸܠܡܲܬ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","ܠܹܐ ܝܵܬܹܒ݂ ܒܓܵܘܵܐ ܕܒܲܝܬ‌ܝܼ ܥܵܒ݂ܕܵܢܵܐ ܕܦܸܠܡܵܐ، ܗܲܡܙܸܡܵܢܵܐ ܕܕܘܼܓܠܹ̈ܐ ܠܹܐ ܗܵܘܹܐ ܩܸܘܝܵܐ ܩܲܕܡ ܥܲܝܢܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","ܨܲܦܪܵܐ ܒܨܲܦܪܵܐ ܒܸܬ ܛܲܠܩܸܢ ܟܠܵܝܗ‌ܝ ܪ̈ܲܫܝܼܥܹܐ ܕܐܲܪܥܵܐ، ܠܸܩܛܵܥܵܐ ܡ̣ܢ ܡܕܝܼܢ݇ܬܵ‌ܐ ܕܡܵܪܝܵܐ ܟܠܵܝܗ‌ܝ ܦܵܠܚܵܢܹ̈ܐ ܕܥܵܘܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","ܝܵܐ ܡܵܪܝܵܐ، ܫܡܹܥ ܨܠܘܿܬ‌ܝܼ، ܘܓܥܵܝܬ‌ܝܼ ܠܟܸܣܠܘܼܟ݂ ܥܵܒ݂ܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","ܠܵܐ ܛܲܫܹܝܬ ܦܵܬܘܼܟ݂ ܡܸܢܝܼ ܒܝܵܘܡܵܐ ܕܥܵܝܩܵܐ ܐܸܠܝܼ، ܡܲܟܸܦ ܐܸܠܝܼ ܢܵܬܘܼܟ݂، ܒܝܵܘܡܵܐ ܕܩܵܪܹܝܢ ܡܲܠܝܸܙ ܓ̰ܲܘܸܒ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","ܣܵܒܵܒ ܬܝܼܡ ܠܗܘܿܢ ܝܵܘܡܵܢܝܼ̈ ܐܲܝܟ݂ ܬܸܢܵܐ، ܘܓܲܪ̈ܡܝܼ ܐܲܝܟ݂ ܝܵܩܕܵܢܵܐ ܝܩܝܼܕ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","ܦܝܼܫ ܠܹܗ ܡܸܚܝܵܐ ܠܸܒܝܼ ܐܲܝܟ݂ ܓܸܠܵܐ ܘܒܪܝܼܙ ܠܹܗ، ܗܲܠܔ ܕܡܘܼܢܫܹܐ ܠܝܼ ܠܹܐܟ݂ܵܠܵܐ ܠܲܚܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","ܡ̣ܢ ܩܵܠܵܐ ܕܬܲܢܲܚܬ‌ܝܼ، ܫܥܹܐ ܠܹܗ ܓܸܠܕܝܼ ܠܓܲܪ̈ܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","ܕܡܹܐ ܠܝܼ ܠܩܵܩܵܐ ܕܒܲܪܝܼܵܐ، ܗܘܹܐ ܠܝܼ ܐܲܝܟ݂ ܩܘܼܦܬܵ‌ܐ ܕܚܵܪ̈ܵܒܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","ܦܝܼܫ ܠܝܼ ܪܥܝܼܫܵܐ؛ ܗܘܹܐ ܠܝܼ ܐܲܝܟ݂ ܛܲܝܪܵܐ ܒܢܲܦ̮ܫܹܗ ܥܲܠܔ ܐܓܵܪܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","ܩܵܡ ܠܵܝܡܝܼ ܠܝܼ ܕܸܫ̃ܡܸܢܝܼ̈ ܟܠܹܗ ܝܵܘܡܵܐ، ܡܲܣܚܸܪ̈ܵܢܝܼ ܡܘܼܦܠܸܚ ܠܗܘܿܢ ܫܸܡܝܼ ܒܠܵܘܛܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","ܣܵܒܵܒ ܩܸܛܡܵܐ ܐܲܝܟ݂ ܠܲܚܡܵܐ ܐܟ݂ܝܼܠܔ ܠܝܼ، ܘܫܬܵܝܬ‌ܝܼ ܒܕܸܡ̈ܥܹܐ ܡܙܝܼܓ݂ ܠܝܼ، ");
INSERT INTO aii_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","ܡ̣ܢ ܥܸܠܬܵ‌ܐ ܕܟܲܪܒܘܼܟ݂ ܘܚܸܡܬܘܼܟ݂، ܒܗ̇ܝ ܕܩܵܡ ܡܲܪܡܹܝܬ ܘܪܲܦܹܝܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","ܝܵܘܡܵܢܝܼ̈ ܐܲܝܟ݂ ܛܸܠܵܢܝܼܬܵ‌ܐ ܒܸܓܢܵܝܵܐ ܝܢܵܐ، ܘܐܵܢܵܐ ܐܲܝܟ݂ ܓܸܠܵܐ ܒܸܒܪܵܙܵܐ ܝܘܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","ܐܝܼܢܵܐ ܐܲܢ݇ܬ، ܝܵܐ ܡܵܪܝܵܐ، ܠܥܵܠܲܡ ܝܬܝܼܒ݂ܵܐ ܝܘܸܬ، ܘܕܟ݂ܵܪܘܼܟ݂ ܠܕܵܪܵܐ ܘܕܵܪܵܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","ܐܲܢ݇ܬ ܒܸܬ ܩܵܝܡܹܬ، ܒܸܬ ܪܲܚܡܸܬ ܥܲܠܔ ܨܸܗܝܘܿܢ، ܣܵܒܵܒ ܥܕܵܢܵܐ ܝܠܵܗ̇ ܠܸܥܒ݂ܵܕܵܐ ܚܢܵܢܵܐ ܥܲܠܘܼܗ̇، ܒܗ̇ܝ ܕܐܬܹ‌ܐ ܠܵܗ̇ ܥܕܵܢܵܐ ܪܫܝܼܡܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","ܣܵܒܵܒ ܟܹܐ ܒܵܣܡܵܐ ܠܗܘܿܢ ܪܹ̈ܓܵܘܵܬܘܼܟ݂ ܒܟܹܐܦܘܼ̈ܗ̇. ܘܥܲܠܔ ܥܲܦܪܘܼܗ̇ ܟܹܐ ܥܵܒ݂ܕܝܼ ܚܢܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","ܘܒܸܬ ܙܵܕܥܝܼ ܐܸܡܘܵܬܹ̈‌ܐ ܡ̣ܢ ܫܸܡܵܐ ܕܡܵܪܝܵܐ، ܘܟܠܵܝܗ‌ܝ ܡܲܠܟܹ̈ܐ ܕܐܲܪܥܵܐ ܡ̣ܢ ܐܝܼܩܵܪܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","ܣܵܒܵܒ ܒܸܬ ܒܵܢܹܐ ܡܵܪܝܵܐ ܠܨܸܗܝܘܿܢ، ܒܸܬ ܦܵܐܹܫ ܚܸܙܝܵܐ ܒܫܘܼܒ݂ܚܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","ܫܡܝܼܥܵܐ ܠܹܗ ܨܠܘܿܬܵ‌ܐ ܕܡܸܣܟܹܢܹ̈ܐ، ܘܠܵܐ ܡܘܼܣܠܹܐ ܠܹܗ ܠܨܠܘܿܬܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","ܒܸܬ ܦܵܝܫܵܐ ܟܬܝܼܒ݂ܬܵ‌ܐ ܐܵܗܵܐ ܠܕܵܪܵܐ ܕܐܵܬܹ‌ܐ، ܘܥܲܡܵܐ ܕܦܵܐܹܫ ܒܸܪܝܵܐ ܒܸܬ ܫܲܒܸܚ ܠܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","ܣܵܒܵܒ ܓܘܼܫܸܩ ܠܹܗ ܡ̣ܢ ܡܪܵܘܡܵܐ ܕܩܘܼܕܫܹܗ، ܡܵܪܝܵܐ ܡ̣ܢ ܫܡܲܝܵܐ ܠܐܲܪܥܵܐ ܚܝܼܪܹܗ، ");
INSERT INTO aii_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","ܠܸܫܡܵܥܵܐ ܫܲܦܠܲܦܬܵ‌ܐ ܕܐܲܣܝܼܪܵܐ، ܠܸܫܪܵܝܵܐ ܠܒܢܲܝ̈ ܡܵܘܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","ܕܗܲܩܝܼ ܓܵܘ ܨܸܗܝܘܿܢ ܫܸܡܵܐ ܕܡܵܪܝܵܐ، ܘܬܸܫܒܘܿܚܬܹܗ ܓܵܘ ܐܘܿܪܸܫܠܸܡ، ");
INSERT INTO aii_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","ܐܝܼܡܲܢ ܕܓ̰ܵܡܥܝܼ ܥܲܡܡܹ̈ܐ ܥܲܡ ܚܕܵܕܹ̈ܐ، ܘܡܲܠܟܘܵܬܹ̈‌ܐ، ܠܸܦܠܵܚܵܐ ܠܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","ܫܡܝܼܛ ܠܹܗ ܚܲܝܠܝܼ ܒܪܲܗܛܵܐ ܕܚܲܝܝܼ̈، ܡܘܼܟܪܝܼܵܝ ܠܹܗ ܝܵܘܡܵܢܝܼ̈، ");
INSERT INTO aii_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","ܒܸܬ ܐܵܡܪܹܢ، ܝܵܐ ܐܲܠܵܗ‌ܝܼ، ܠܵܐ ܫܵܩܠܹܬ ܠܝܼ ܒܦܲܠܓܵܐ ܕܝܵܘܡܵܢܝܼ̈، ܒܕܵܪܵܐ ܕܕܵܪܹ̈ܐ ܝܢܵܐ ܫܸܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","ܡ̣ܢ ܙܲܒ݂ܢܵܐ ܩܲܕܝܼܡܵܝܵܐ، ܫܘܼܬܐܸܣܵܐ ܠܘܼܟ݂ ܐܲܪܥܵܐ، ܘܫܡܲܝܹ̈ܐ ܦܘܼܠܚܵܢܵܐ ܕܐܝܼܕܵܬܘܼ̈ܟ݂ ܝܼܢܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","ܐܵܢܝܼ ܒܸܬ ܛܵܠܩܝܼ، ܐܝܼܢܵܐ ܐܲܢ݇ܬ ܦܵܝܫܵܢܵܐ ܝܘܸܬ، ܘܟܠܵܝܗ‌ܝ ܐܲܝܟ݂ ܓ̰ܘܼܠܵܐ ܒܸܬ ܒܵܠܝܼ، ܐܲܝܟ݂ ܠܒ݂ܘܼܫܵܐ ܒܸܬ ܫܲܚܠܸܦܸܬ ܠܗܘܿܢ، ܘܐܵܢܝܼ ܒܸܬ ܦܵܝܫܝܼ ܬܝܼܡܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","ܐܝܼܢܵܐ ܐܲܢ݇ܬ ܗܲܪ ܗ̇ܘ ܝܼܘܸܬ، ܘܫܸܢܘܼ̈ܟ݂ ܠܹܐ ܬܵܝܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","ܒܢܘܿܢܹ̈ܐ ܕܪܹ̈ܓܵܘܵܬܘܼܟ݂ ܒܸܬ ܥܵܡܪܝܼ ܒܫܲܝܢܵܐ، ܘܙܲܪܥܵܝܗ‌ܝ ܩܲܕܡܘܼܟ݂ ܒܸܬ ܡܩܲܘܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","ܒܲܪܸܟ݂ܝ، ܝܵܐ ܓܵܢܝܼ، ܠܡܵܪܝܵܐ، ܘܟܠܔ ܕܒܓܵܘܝܼ ܠܫܸܡܵܐ ܕܩܘܼܕܫܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","ܒܲܪܸܟ݂ܝ، ܝܵܐ ܓܵܢܝܼ، ܠܡܵܪܝܵܐ، ܘܠܵܐ ܢܵܫܝܲܬ‌ܝ ܟܠܵܝܗ‌ܝ ܦܘܼܪ̈ܥܵܢܘܼܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","ܕܟܹܐ ܫܵܒܹܩ ܟܠܹܗ ܥܵܘܠܵܟ݂ܝ، ܕܟܹܐ ܒܲܣܸܡ ܟܠܵܝܗ‌ܝ ܡܲܪ̈ܥܵܟ݂ܝ، ");
INSERT INTO aii_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","ܕܟܹܐ ܦܲܪܸܩ ܡ̣ܢ ܓܘܼܒܵܐ ܚܲܝܵܟ݂ܝ̈، ܕܟܹܐ ܒܲܢܦܸܪܵܟ݂ܝ ܒܛܲܝܒܘܼܬܵ‌ܐ ܘܪ̈ܲܚܡܹܐ، ");
INSERT INTO aii_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","ܕܟܹܐ ܡܲܣܒܸܥ ܒܛܵܒ݂ܬܵ‌ܐ ܚܲܝܘܼܬܵܟ݂ܝ، ܕܦܵܝܫܵܐ ܚܘܼܕܸܬܬܵ‌ܐ ܐܲܝܟ݂ ܢܸܫܪܵܐ ܥܠܲܝܡܘܼܬܵܟ݂ܝ. ");
INSERT INTO aii_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","ܟܹܐ ܥܵܒܹܕ ܦܘܼܠܚܵܢܹ̈ܐ ܕܙܲܕܝܼܩܘܼܬܵ‌ܐ ܡܵܪܝܵܐ، ܘܕܝܼܘܵܢܹ̈ܐ ܠܟܠܵܝܗ‌ܝ ܛܠܝܼܡܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","ܡܘܼܕܸܥ ܠܹܗ ܐܘܼܪ̈ܚܵܬܘܼܗ‌ܝ ܠܡܘܼܫܹܐ، ܠܒܢܲܝ̈ ܐܝܼܣܪܵܐܹܝܠܔ ܦܘܼܠܚܵܢܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","ܡܪܲܚܡܵܢܵܐ ܝܠܹܗ ܘܚܲܢܵܢܵܐ ܡܵܪܝܵܐ، ܝܲܪܝܼܟ݂ܬܵ‌ܐ ܒܹܐܢܹܗ ܘܦܪܝܼܬܵ‌ܐ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","ܠܥܵܠܲܡ ܠܹܐ ܕܵܪܹܫ، ܘܠܵܐ ܠܥܵܠܲܡ ܢܵܛܹܪ ܟܲܪܒܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","ܠܵܐ ܐܲܝܟ݂ ܚܛܵܗܲܢ̈ ܥܒ݂ܝܼܕ ܠܹܗ ܐܸܠܲܢ، ܘܠܵܐ ܐܲܝܟ݂ ܥܵܘܠܲܢ̈ ܦܪܝܼܥ ܠܹܗ ܐܸܠܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","ܣܵܒܵܒ ܐܲܝܟ݂ ܕܝܼܠܵܗ̇ ܪܵܡܬܵ‌ܐ ܫܡܲܝܵܐ ܥܲܠܔ ܐܲܪܥܵܐ، ܗܵܕܟ݂ܵܐ ܓܘܼܪܬܵ‌ܐ ܝܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ ܥܲܠܔ ܙܕܝܼܥܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","ܐܲܝܟ݂ ܕܝܼܠܹܗ ܪܸܚܩܵܐ ܡܲܕܢܚܵܐ ܡ̣ܢ ܡܲܥܪܒ݂ܵܐ، ܗܵܕܟ݂ܵܐ ܡܘܼܪܚܸܩ ܠܹܗ ܡܸܢܲܢ ܓܢܵܗܲܢ̈. ");
INSERT INTO aii_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","ܐܲܝܟ݂ ܕܪܲܚܸܡ ܒܵܒܵܐ ܥܲܠܔ ܒܢܘܿܢܘܼ̈ܗ‌ܝ، ܗܵܕܟ݂ܵܐ ܟܹܐ ܪܲܚܸܡ ܡܵܪܝܵܐ ܥܲܠܔ ܙܕܝܼܥܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","ܣܵܒܵܒ ܗ̇ܘ ܟܹܐ ܝܵܕܹܥ ܓܒ݂ܝܼܠܬܲܢ، ܟܹܐ ܕܵܟܹܪ ܕܥܲܦܪܵܐ ܝܘܲܚ ܐܲܚܢܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","ܐܢܵܫܵܐ ܐܲܝܟ݂ ܓܸܠܵܐ ܝܢܵܐ ܝܵܘܡܵܢܘܼ̈ܗ‌ܝ، ܐܲܝܟ݂ ܦܸܩܚܵܐ ܕܕܸܫܬܵ‌ܐ ܗܵܕܟ݂ܵܐ ܟܹܐ ܦܵܩܹܚ، ");
INSERT INTO aii_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","ܐܝܼܡܲܢ ܕܦܵܘܚܵܐ ܟܹܐ ܥܵܒܹܪ ܥܲܠܘܼܗ‌ܝ، ܐܚܹܪܢܵܐ ܠܲܝܬ ܗ̇ܘ، ܘܠܹܐ ܝܵܕܥܵܐ ܠܹܗ ܐܚܹܪܢܵܐ ܕܘܼܟܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","ܐܝܼܢܵܐ ܛܲܝܒܘܼܬܵ‌ܐ ܕܡܵܪܝܵܐ ܡ̣ܢ ܥܵܠܲܡ ܝܼܠܵܗ̇ ܘܗܲܠܔ ܥܵܠܲܡ ܥܲܠܔ ܙܕܝܼܥܘܼ̈ܗ‌ܝ، ܘܙܲܕܝܼܩܘܼܬܹܗ ܥܲܠܔ ܒܢܘܿܢܹ̈ܐ ܕܒܢܘܿܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","ܠܢܵܛܪܵܢܵܐ ܕܘܲܥܕܹܗ، ܘܠܕܵܟ݂ܪܵܢܵܐ ܕܦܘܼܩܕܵܢܘܼ̈ܗ‌ܝ ܠܸܥܒ݂ܵܕܵܝ. ");
INSERT INTO aii_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","ܡܵܪܝܵܐ ܒܫܡܲܝܵܐ ܡܘܼܩܘܹܐ ܠܹܗ ܟܘܼܪܣܝܹܗ، ܘܡܲܠܟܘܼܬܹܗ ܟܹܐ ܗܲܟܡܵܐ ܥܲܠܔ ܟܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","ܒܲܪܟ݂ܘܼܢ ܠܡܵܪܝܵܐ، ܝܵܐ ܡܲܠܲܐܟ݂ܘܼ̈ܗ‌ܝ، ܓܲܒܵܪܹ̈ܐ ܕܚܲܝܠܵܐ ܥܵܒ݂ܕܵܢܹ̈ܐ ܕܚܲܒܪܹܗ، ܠܸܫܡܵܥܵܐ ܠܩܵܠܵܐ ܕܚܲܒܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","ܒܲܪܟ݂ܘܼܢ ܠܡܵܪܝܵܐ، ܝܵܐ ܟܠܵܝܗ‌ܝ ܚܲܝܠܵܘܵܬܘܼ̈ܗ‌ܝ، ܡܫܲܡܫܵܢܘܼ̈ܗ‌ܝ ܥܵܒ݂ܕܵܢܹ̈ܐ ܕܨܸܒ݂ܝܵܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","ܒܲܪܟ݂ܘܼܢ ܠܡܵܪܝܵܐ، ܝܵܐ ܟܠܵܝܗ‌ܝ ܥܒ݂ܵܕܘܼ̈ܗ‌ܝ، ܒܟܠܵܝܗ‌ܝ ܕܘܼܟܵܢܹ̈ܐ ܕܫܘܼܠܛܵܢܹܗ، ܒܲܪܸܟ݂ܝ، ܝܵܐ ܓܵܢܝܼ، ܠܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","ܒܲܪܸܟ݂ܝ، ܝܵܐ ܓܵܢܝܼ، ܠܡܵܪܝܵܐ، ܡܵܪܝܵܐ ܐܲܠܵܗ‌ܝܼ ܓܘܼܪܵܐ ܝܘܸܬ ܪܵܒܵܐ، ܙܲܗܝܘܼܬܵ‌ܐ ܘܣܸܩܠܵܐ ܠܒ݂ܝܼܫ ܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","ܟܹܐ ܩܵܛܹܒ݂ ܒܲܗܪܵܐ ܐܲܝܟ݂ ܥܵܒܵܝܬܵ‌ܐ، ܟܹܐ ܡܵܬܹܚ ܫܡܲܝܵܐ ܐܲܝܟ݂ ܣܸܬܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","ܟܹܐ ܒܵܢܹܐ ܥܲܠܔ ܡ̈ܝܼܵܐ ܥܸܠܝܼܵܬܘܼ̈ܗ‌ܝ، ܟܹܐ ܥܵܒܹܕ ܥܲܝܒ݂ܵܬܹ̈‌ܐ ܡܲܪܟܲܒ݂ܬܹܗ، ܟܹܐ ܚܵܕܹܪ ܥܲܠܔ ܓܘܼܠܦܵܢܹ̈ܐ ܕܦܵܘܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","ܟܹܐ ܥܵܒܹܕ ܡܲܠܲܐܟ݂ܘܼ̈ܗ‌ܝ ܦܵܘܚܹ̈ܐ، ܡܫܲܡܫܵܢܘܼ̈ܗ‌ܝ ܢܘܼܪܵܐ ܠܵܗܝܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","ܡܘܼܩܘܹܐ ܠܹܗ ܐܲܪܥܵܐ ܥܲܠܔ ܫܲܬܐܸܣܬܘܼܗ̇، ܠܹܐ ܫܵܥܫܵܐ ܠܥܵܠܲܡ ܥܵܠܡܝܼܢ. ");
INSERT INTO aii_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","ܒܬܗܘܿܡܵܐ ܐܲܝܟ݂ ܠܒܼܝܼܫܬܵ‌ܐ ܟܘܼܣܹܐ ܠܘܼܟ݂ ܐܸܠܘܼܗ̇، ܥܲܠܔ ܛܘܼܪ̈ܵܢܹܐ ܟܠܹܐ ܠܗܘܿܢ ܡ̈ܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","ܡ̣ܢ ܢܓ̰ܵܘܬܘܼܟ݂ ܥܪܝܼܩ ܠܗܘܿܢ، ܡ̣ܢ ܩܵܠܵܐ ܕܪܲܥܡܘܼܟ݂ ܡܘܼܠܝܸܙ ܠܗܘܿܢ ܠܸܥܪܵܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","ܐܣܝܼܩ ܠܗܘܿܢ ܛܘܼܪ̈ܵܢܹܐ، ܨܠܹܐ ܠܗܘܿܢ ܪ̈ܵܘܘܿܠܹܐ، ܠܕܘܼܟܵܐ ܕܫܘܼܬܐܸܣ ܠܘܼܟ݂ ܐܸܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","ܬܚܘܼܡܵܐ ܡܘܼܬܸܒ݂ ܠܘܼܟ݂ ܕܠܵܐ ܥܵܒ݂ܪܝܼ، ܠܵܐ ܕܵܝܪܝܼ ܠܟܲܣܘܼܝܘܼܗ̇ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","ܟܹܐ ܫܲܕܸܪ ܥܲܝܢܵܬܹ̈‌ܐ ܓܵܘ ܪ̈ܵܘܘܿܠܹܐ، ܒܹܝܠܔ ܛܘܼܪ̈ܵܢܹܐ ܟܹܐ ܓ̰ܵܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","ܟܹܐ ܡܲܫܬ‌ܝܼ ܠܟܠܵܝܗ‌ܝ ܗܲܝܘܵܢܹ̈ܐ ܕܕܸܫܬܵ‌ܐ، ܚܡܵܪܹ̈ܐ ܕܒܲܪܝܼܵܐ ܟܹܐ ܡܲܬܪܝܼ ܨܲܗܘܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","ܠܟܸܣܠܵܝܗ‌ܝ ܛܲܝܪܹ̈ܐ ܕܫܡܲܝܵܐ ܟܹܐ ܪܵܝܦܝܼ، ܡ̣ܢ ܓܵܘܵܐ ܕܦܲܥܘܵܢܹ̈ܐ ܟܹܐ ܡܲܪܡܝܼ ܩܵܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","ܟܹܐ ܡܲܫܬܹ‌ܐ ܛܘܼܪ̈ܵܢܹܐ ܡ̣ܢ ܥܸܠܝܼܵܬܘܼ̈ܗ‌ܝ، ܡ̣ܢ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܕܦܘܼܠܚܵܢܘܼ̈ܟ݂ ܒܸܬ ܣܵܒ݂ܥܵܐ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","ܟܹܐ ܡܲܓ̰ܝܸܢ ܓܸܠܵܐ ܩܵܐ ܪܸܣܩܵܐ، ܘܝܲܪܩܵܐ ܩܵܐ ܡܲܦܠܲܚܬܵ‌ܐ ܕܒܲܪܢܵܫܵܐ، ܘܠܦܲܠܘܼܛܹܐ ܬܘܼܪܣܵܝܵܐ ܡ̣ܢ ܐܲܪܥܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","ܘܚܲܡܪܵܐ ܕܟܹܐ ܡܲܚܕܹܐ ܠܸܒܵܐ ܕܐܢܵܫܵܐ، ܡܸܫܚܵܐ ܠܡܲܒܪܘܼܩܹܐ ܦܵܬܘܵܬܹ̈‌ܐ، ܘܠܲܚܡܵܐ ܕܟܹܐ ܣܵܢܹܕ ܠܸܒܵܐ ܕܐܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","ܟܹܐ ܣܵܒ݂ܥܝܼ ܐܝܼܠܵܢܹ̈ܐ ܕܡܵܪܝܵܐ، ܐܲܪ̈ܙܹܐ ܕܠܸܒ݂ܢܵܢ ܕܢܨܝܼܒ݂ ܠܹܗ، ");
INSERT INTO aii_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","ܕܬܵܡܵܐ ܛܲܝܪܹ̈ܐ ܟܹܐ ܬܲܪܨܝܼ ܩܸܢܵܬܹ̈‌ܐ، ܠܲܩܠܵܩ ܒܲܝܬܘܼܗ̇ ܒܫܲܪ̈ܘܲܝܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","ܛܘܼܪ̈ܵܢܹܐ ܪ̈ܵܡܹܐ ܩܵܐ ܕܲܝܨܹ̈ܐ، ܩܵܝܹ̈ܐ ܣܸܬܵܪܵܐ ܠܝܲܪ̈ܒܘܼܥܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","ܥܒ݂ܝܼܕ ܠܹܗ ܣܲܗܪܵܐ ܠܘܲܥܕܹ̈ܐ، ܫܸܡܫܵܐ ܟܹܐ ܝܵܕܹܥ ܓܢܵܝܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","ܟܹܐ ܡܲܬܒܸܬ ܚܸܫܟܵܐ ܘܟܹܐ ܗܵܘܹܐ ܠܲܝܠܹܐ، ܒܓܵܘܹܗ ܟܹܐ ܚܵܕܪܝܼ ܗܲܝܘܵܢܹ̈ܐ ܕܡܲܝܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","ܓܘܼܪ̈ܝܹܐ ܕܐܲܪ̈ܝܹܐ ܟܹܐ ܓܲܪܓܸܡܝܼ ܥܲܠܔ ܨܲܝܕܵܝܗ‌ܝ، ܠܸܛܠܵܒܵܐ ܡ̣ܢ ܐܲܠܵܗܵܐ ܡܹܐܟ݂ܘܼܠܬܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","ܒܙܪܵܩܵܐ ܕܫܸܡܫܵܐ ܟܹܐ ܓ̰ܵܡܥܝܼ، ܘܓܵܘ ܒܹܝܬ ܡܲܥܡܪܵܝܗ‌ܝ ܟܹܐ ܕܵܡܟ݂ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","ܟܹܐ ܦܵܠܹܛ ܒܲܪܢܵܫܵܐ ܠܫܘܼܠܹܗ، ܘܠܦܘܼܠܚܵܢܹܗ ܗܲܠܔ ܪܲܡܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","ܟܡܵܐ ܪܵܒܵܐ ܝܢܵܐ ܥܒ݂ܵܕܘܼ̈ܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܟܠܵܝܗ‌ܝ ܒܚܸܟ݂ܡܬܵ‌ܐ ܥܒ݂ܝܼܕ ܠܘܼܟ݂، ܡܠܹܐ ܠܵܗ̇ ܐܲܪܥܵܐ ܡ̣ܢ ܥܘܼܬܪܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","ܐܵܗܵܐ ܝܵܡܵܐ ܓܘܼܪܬܵ‌ܐ ܘܪܘܝܼܚܬܵ‌ܐ، ܬܵܡܵܐ ܐܝܼܬ ܪ̈ܲܚܫܹܐ ܕܠܵܐ ܡܸܢܝܵܢܵܐ، ܚܲܝܘܵܬܹ̈‌ܐ ܙܥܘܿܪܹ̈ܐ ܥܲܡ ܓܘܼܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","ܬܵܡܵܐ ܓܵܡܝܼܹ̈ܐ ܟܹܐ ܚܵܕܪܝܼ، ܘܠܹܘܝܵܬܵܢ ܕܒܪܹܐ ܠܘܼܟ݂ ܠܛܲܐܘܼܠܹܐ ܓܵܘܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","ܟܠܵܝܗ‌ܝ ܐܸܠܘܼܟ݂ ܟܹܐ ܣܵܒܪܝܼ، ܠܝܼܵܗܒ݂ܵܐ ܡܹܐܟ݂ܘܼܠܬܵܝܗ‌ܝ ܒܥܕܵܢܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","ܟܹܐ ܝܵܗܒܹܬ ܐܸܠܵܝܗ‌ܝ، ܟܹܐ ܟܲܦܫܝܼ، ܟܹܐ ܦܵܬܚܹܬ ܐܝܼܕܘܼܟ݂، ܟܹܐ ܣܵܒ݂ܥܝܼ ܒܛܵܒ݂ܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","ܟܹܐ ܛܲܫܹܝܬ ܦܵܬܘܼܟ݂، ܟܹܐ ܦܵܝܫܝܼ ܫܓ݂ܝܼܫܹܐ، ܟܹܐ ܫܵܩܠܹܬ ܪܘܼܚܵܝܗ‌ܝ، ܟܹܐ ܦܵܝܫܝܼ ܛܠܝܼܩܹܐ، ܘܠܥܲܦܪܵܝܗ‌ܝ ܟܹܐ ܕܵܝܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","ܟܹܐ ܫܲܕܪܸܬ ܪܘܼܚܘܼܟ݂، ܟܹܐ ܦܵܝܫܝܼ ܒܸܪܝܹܐ، ܘܟܹܐ ܚܲܕܸܬܸܬ ܦܵܬܵ‌ܐ ܕܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","ܗܵܘܹܐ ܚܸܩܪܵܐ ܕܡܵܪܝܵܐ ܠܥܵܠܲܡ، ܚܵܕܹܐ ܡܵܪܝܵܐ ܒܦܘܼܠܚܵܢܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","ܟܹܐ ܚܵܐܹܪ ܒܐܲܪܥܵܐ ܘܟܹܐ ܪܲܬܪܸܬܵ‌ܐ، ܟܹܐ ܕܵܩܹܪ ܒܛܘܼܪ̈ܵܢܹܐ ܘܟܹܐ ܬܲܢܬܸܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","ܒܸܬ ܫܲܒܚܸܢ ܠܡܵܪܝܵܐ ܒܚܲܝܝܼ̈، ܒܸܬ ܙܵܡܪܹܢ ܠܐܲܠܵܗ‌ܝܼ ܟܡܵܐ ܕܝܼܘܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","ܗܵܘܝܵܐ ܒܲܣܝܼܡܬܵ‌ܐ ܐܸܠܹܗ ܗܲܓܲܝܬ‌ܝܼ، ܐܵܢܵܐ ܒܸܬ ܚܵܕܹܝܢ ܒܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","ܬܵܝܡܝܼ ܚܲܛܵܝܹ̈ܐ ܡ̣ܢ ܦܵܬܵ‌ܐ ܕܐܲܪܥܵܐ، ܘܪ̈ܲܫܝܼܥܹܐ ܐܚܹܪܢܵܐ ܠܵܐ ܗܵܘܝܼ. ܒܲܪܸܟ݂ܝ، ܝܵܐ ܓܵܢܝܼ، ܠܡܵܪܝܵܐ. ܗܲܠܸܠܘܼܝܵܐ ");
INSERT INTO aii_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","ܫܲܟܪܘܼܢ ܠܡܵܪܝܵܐ، ܩܪܹܝܡܘܼܢ ܒܫܸܡܹܗ، ܡܲܕܸܥܡܘܼܢ ܓܵܘ ܥܲܡܡܹ̈ܐ ܥܒ݂ܵܕܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","ܫܲܒܚܘܼܢ ܐܸܠܹܗ، ܙܡܘܿܪܘܼܢ ܐܸܠܹܗ، ܗܲܓܹܝܡܘܼܢ ܟܠܵܝܗ‌ܝ ܕܘܼܡܵܪ̈ܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","ܫܲܒܚܘܼܢ ܒܫܸܡܵܐ ܕܩܘܼܕܫܹܗ، ܚܵܕܹܐ ܠܸܒܵܐ ܕܛܵܥܝܵܢܹ̈ܐ ܠܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","ܒܥܹܝܡܘܼܢ ܠܡܵܪܝܵܐ ܘܠܥܘܼܫܢܹܗ، ܛܥܹܝܡܘܼܢ ܠܦܵܬܹܗ ܐܲܡܝܼܢܵܐܝܼܬ. ");
INSERT INTO aii_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","5","ܕܟ݂ܘܿܪܘܼܢ ܕܘܼܡܵܪ̈ܘܼܗ‌ܝ ܕܥܒ݂ܝܼܕ ܠܹܗ، ܢܝܼܫܲܢܩܘܼ̈ܗ‌ܝ ܘܕܝܼܘܵܢܹ̈ܐ ܕܦܘܼܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS105_6","020_105_6","PSA","105","6","6","ܝܵܐ ܙܲܪܥܵܐ ܕܐܲܒ݂ܪܵܗܵܡ ܪܹܓܹܗ، ܝܵܐ ܒܢܲܝ̈ ܝܲܥܩܘܿܒ݂ ܓܘܼܒܝܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","ܗ̇ܘ ܝܼܠܹܗ ܡܵܪܝܵܐ ܐܲܠܵܗܲܢ، ܒܟܠܵܝܗ‌ܝ ܐܲܪܥܵܐ ܕܝܼܘܵܢܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","ܕܟ݂ܝܼܪܹܗ ܠܥܵܠܲܡ ܘܲܥܕܹܗ، ܚܲܒܪܵܐ ܕܦܩܝܼܕ ܠܹܗ ܠܐܲܠܦܵܐ ܕܵܪܹ̈ܐ، ");
INSERT INTO aii_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","ܘܲܥܕܵܐ ܕܩܛܝܼܥ ܠܹܗ ܥܲܡ ܐܲܒ݂ܪܵܗܵܡ، ܘܡܵܘܡܝܼܬܹܗ ܠܐܝܼܣܚܵܩ، ");
INSERT INTO aii_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","ܘܡܘܼܩܘܹܐ ܠܹܗ ܘܲܥܕܹܗ ܠܝܲܥܩܘܿܒ݂ ܠܩܵܢܘܿܢܵܐ، ܠܐܝܼܣܪܵܐܹܝܠܔ ܘܲܥܕܵܐ ܕܥܵܠܲܡ، ");
INSERT INTO aii_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","ܒܹܐܡܵܪܵܐ: ”ܐܸܠܘܼܟ݂ ܒܸܬ ܝܵܗܒܹܢ ܐܲܪܥܵܐ ܕܟܢܲܥܢ، ܣܵܗܡܵܐ ܕܝܵܪܬܘܼܬܵܘܟ݂ܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","ܟܲܕ ܝܼܗܘܵܘ ܒܵܨܘܿܪܹ̈ܐ ܒܡܸܢܝܵܢܵܐ، ܪܵܒܵܐ ܒܵܨܘܿܪܹ̈ܐ، ܘܡܵܫܵܚܲܛܹ̈ܐ ܓܵܘܘܼܗ̇، ");
INSERT INTO aii_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","ܗܘܹܐ ܠܗܘܿܢ ܒܸܚܕܵܪܵܐ ܡ̣ܢ ܐܘܼܡܬܵ‌ܐ ܠܐܘܼܡܬܵ‌ܐ، ܡ̣ܢ ܡܲܠܟܘܼܬܵ‌ܐ ܠܥܲܡܵܐ ܐܚܹܪܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","ܠܵܐ ܫܒ݂ܝܼܩ ܠܹܗ ܕܐܢܵܫܵܐ ܕܙܵܠܹܡ ܥܲܠܵܝܗ‌ܝ، ܘܡܘܼܢܟܸܣ ܠܹܗ ܡܲܠܟܹ̈ܐ ܒܘܼܬ ܕܝܼܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","ܐܡܝܼܪܹܗ: ”ܠܵܐ ܕܵܩܪܝܼܬܘܿܢ ܒܡܫܝܼܚܝܼ̈، ܘܠܢܒ݂ܝܼܝܼ̈ ܠܵܐ ܥܵܒ݂ܕܝܼܬܘܿܢ ܒܝܼܫܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","ܘܩܪܹܐ ܠܹܗ ܟܸܦܢܵܐ ܥܲܠܔ ܐܲܪܥܵܐ، ܟܠܔ ܕܵܘܪܵܢܵܐ ܕܠܲܚܡܵܐ ܬܒ݂ܝܼܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","ܫܘܼܕܸܪܹܗ ܩܲܕܡܵܝܗ‌ܝ ܐܢܵܫܵܐ، ܠܪܹܓܘܼܬܵ‌ܐ ܦܝܼܫ ܠܹܗ ܙܘܼܒܢܵܐ ܝܵܘܣܸܦ. ");
INSERT INTO aii_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","ܡܘܼܠܝܸܨ ܠܗܘܿܢ ܠܐܲܩܠܵܬܘܼ̈ܗ‌ܝ ܒܩܵܘܕܹ̈ܐ، ܒܬܵܘܩܵܐ ܕܦܪܸܙܠܵܐ ܥܒ݂ܝܼܪܹܗ ܩܕܵܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","ܗܲܠܔ ܙܲܒ݂ܢܵܐ ܕܦܝܼܫ ܠܹܗ ܬܘܼܡܸܡܵܐ ܚܲܒܪܹܗ، ܡܹܐܡܪܵܐ ܕܡܵܪܝܵܐ ܩܵܡ ܨܲܪܸܦ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","ܫܘܼܕܸܪܹܗ ܡܲܠܟܵܐ ܘܩܵܡ ܫܵܪܹܐ ܠܹܗ، ܫܲܠܝܼܛܵܐ ܕܥܲܡܡܹ̈ܐ ܩܵܡ ܥܵܒܹܕ ܠܹܗ ܚܹܐܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","ܩܵܡ ܡܲܬܸܒ݂ ܠܹܗ ܡܵܪܵܐ ܠܒܲܝܬܹܗ، ܘܫܲܠܝܼܛܵܐ ܥܲܠܔ ܟܠܹܗ ܥܘܼܬܪܹܗ، ");
INSERT INTO aii_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","ܠܹܐܣܵܪܵܐ ܓܘܼܪ̈ܵܢܘܼܗ‌ܝ ܒܨܸܒ݂ܝܵܢܹܗ، ܘܠܚܘܵܪ̈ܕܸܩܢܘܼܗ‌ܝ ܡܲܠܸܦ ܚܸܟ݂ܡܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","ܥܒ݂ܝܼܪܹܗ ܐܝܼܣܪܵܐܹܝܠܔ ܠܡܸܨܪܹܝܢ، ܘܝܲܥܩܘܿܒ݂ ܡܘܼܫܚܸܛ ܠܹܗ ܒܐܲܪܥܵܐ ܕܚܵܡ. ");
INSERT INTO aii_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","ܘܡܘܼܦܪܹܐ ܠܹܗ ܠܥܲܡܹܗ ܪܵܒܵܐ، ܘܩܵܡ ܥܵܒܹܕ ܠܹܗ ܒܘܼܫ ܥܲܫܝܼܢܵܐ ܡ̣ܢ ܕܸܫ̃ܡܸܢܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","ܡܘܼܕܸܪܹܗ ܠܸܒܵܝܗ‌ܝ ܠܸܣܢܵܝܵܐ ܠܥܲܡܹܗ، ܠܸܥܒ݂ܵܕܵܐ ܦܸܠܡܵܐ ܒܪܹ̈ܓܵܘܵܬܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","ܫܘܼܕܸܪܹܗ ܠܡܘܼܫܹܐ ܪܹܓܹܗ، ܘܠܐܲܗܪܘܿܢ ܕܓܘܼܒܹܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","ܐܵܢܝܼ ܥܒ݂ܝܼܕ ܠܗܘܿܢ ܓܵܘܵܝܗ‌ܝ ܫܘܼܠܹ̈ܐ ܕܢܝܼܫܲܢܩܘܼ̈ܗ‌ܝ، ܘܕܘܼܡܵܪܹ̈ܐ ܒܐܲܪܥܵܐ ܕܚܵܡ. ");
INSERT INTO aii_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","ܫܘܼܕܸܪܹܗ ܚܸܫܟܵܐ ܘܚܘܼܫܟܸܢܵܐ ܠܹܗ، ܘܠܵܐ ܥܒ݂ܝܼܕ ܠܗܘܿܢ ܡܵܪܘܿܕܘܼܬܵ‌ܐ ܥܲܠܔ ܗܹܡܸܙܡܵܢܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","ܡܘܼܚܕܸܪܹܗ ܡܝܼܵܝ̈ܗ‌ܝ ܠܕܸܡܵܐ، ܘܡܘܼܡܝܸܬ ܠܹܗ ܠܢܘܼܢܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","ܡܠܹܐ ܠܵܗ̇ ܐܲܪܥܵܐ ܦܸܩܵܩܹ̈ܐ، ܐܘܼܦ ܓܵܘ ܬܵܘܵܢܹ̈ܐ ܕܡܲܠܟܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","ܐܡܝܼܪܹܗ ܘܐܬܹ‌ܐ ܠܵܗ̇ ܕܸܒܘܼܪܬܵ‌ܐ، ܘܩܲܠܡܵܐ ܓܵܘ ܟܠܹܗ ܬܚܘܼܡܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","ܥܒ݂ܝܼܕ ܠܹܗ ܡܸܛܪ̈ܵܝܗ‌ܝ ܒܲܪܕܵܐ، ܘܢܘܼܪܵܐ ܠܵܗܝܵܢܵܐ ܒܐܲܪܥܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","ܘܡܚܹܐ ܠܹܗ ܓܸܦܝܵܬܵܝ̈ܗ‌ܝ ܘܬܹܐܢܵܝ̈ܗ‌ܝ، ܘܬܒ݂ܝܼܪܹܗ ܐܝܼܠܵܢܹ̈ܐ ܕܬܚܘܼܡܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","ܐܡܝܼܪܹܗ ܘܐܬܹ‌ܐ ܠܹܗ ܩܲܡܨܵܐ، ܘܙܵܚܠܵܐ ܒܠܵܐ ܡܸܢܝܵܢܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","ܘܐܟ݂ܝܼܠܔ ܠܹܗ ܟܠܔ ܓܸܠܵܐ ܒܐܲܪܥܵܝܗ‌ܝ، ܘܐܟ݂ܝܼܠܔ ܠܹܗ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܕܐܲܪܥܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","ܡܚܹܐ ܠܹܗ ܟܠܔ ܒܘܼܟ݂ܪܵܐ ܒܐܲܪܥܵܝܗ‌ܝ، ܪܹܝܫܝܼܬܵ‌ܐ ܕܟܠܹܗ ܥܘܼܫܢܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","ܗ̇ܝܓܵܗ ܦܘܼܠܸܛ ܠܹܗ ܠܥܲܡܹܗ ܒܣܹܐܡܵܐ ܘܒܕܲܗܒ݂ܵܐ، ܘܠܲܝܬ ܗܘܵܐ ܒܫܲܒ݂ܛܘܼ̈ܗ‌ܝ ܬܲܪܩܸܠܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","ܚܕܹܐ ܠܵܗ̇ ܡܸܨܪܹܝܢ ܒܦܠܵܛܬܵܝܗ‌ܝ، ܣܵܒܵܒ ܢܦܝܼܠܔ ܠܵܗ̇ ܙܕܘܼܥܬܵܝܗ‌ܝ ܥܲܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","ܦܪܝܼܣ ܠܹܗ ܥܢܵܢܵܐ ܠܟܲܣܲܝܬܵ‌ܐ، ܘܢܘܼܪܵܐ ܠܒܲܗܪܘܼܢܹܐ ܒܠܲܝܠܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","ܛܠܝܼܒ ܠܗܘܿܢ ܘܡܘܼܝܬܹ‌ܐ ܠܹܗ ܩܘܼܦܫܝܼܢܹ̈ܐ، ܘܒܠܲܚܡܵܐ ܕܫܡܲܝܵܐ ܡܘܼܣܒܸܥܵܝ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","ܦܬܝܼܚ ܠܹܗ ܐܝܼܨܵܪܵܐ ܘܓ̰ܪܹܐ ܠܗܘܿܢ ܡ̈ܝܼܵܐ، ܐܙܝܼܠܔ ܠܗܘܿܢ ܐܲܝܟ݂ ܢܲܗܪܵܐ ܒܐܲܪ̈ܥܵܬܹ‌ܐ ܨܹܗܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","ܣܵܒܵܒ ܕܟ݂ܝܼܪܹܗ ܠܚܲܒܪܵܐ ܕܩܘܼܕܫܹܗ ܠܐܲܒ݂ܪܵܗܵܡ ܪܹܓܹܗ، ");
INSERT INTO aii_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","ܦܘܼܠܸܛ ܠܹܗ ܠܥܲܡܹܗ ܒܚܲܕܘܼܬܵ‌ܐ، ܠܓܘܼܒܝܘܼ̈ܗ‌ܝ ܒܩܲܘܲܚܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܐܲܪ̈ܥܵܬܹ‌ܐ ܕܐܸܡܘܵܬܹ̈‌ܐ، ܘܥܲܡܠܵܐ ܕܥܲܡܡܹ̈ܐ ܝܪܝܼܬ ܠܗܘܿܢ، ");
INSERT INTO aii_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","ܩܵܐ ܕܢܵܛܪܝܼ ܩܵܢܘܿܢܘܼ̈ܗ‌ܝ، ܘܚܲܡܝܼ ܢܵܡܘܿܣܹܗ. ܗܲܠܸܠܘܼܝܵܐ ");
INSERT INTO aii_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","ܫܲܟܪܘܼܢ ܠܡܵܪܝܵܐ ܣܵܒܵܒ ܛܵܒ݂ܵܐ ܝܠܹܗ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","ܡܵܢܝܼ ܝܠܹܗ ܕܗܲܡܙܸܡ ܥܲܠܔ ܓܲܒܵܪ̈ܘܼܝܵܬܹ‌ܐ ܕܡܵܪܝܵܐ، ܝܲܢ ܡܲܫܡܸܥ ܟܠܵܗ̇ ܬܸܫܒܘܿܚܬܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","ܛܘܼܒ݂ܵܐ ܠܢܵܛܪ̈ܵܢܹܐ ܕܕܝܼܘܵܢ، ܥܵܒ݂ܕܵܢܹ̈ܐ ܕܙܲܕܝܼܩܘܼܬܵ‌ܐ ܒܟܠܔ ܙܲܒ݂ܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","ܕܟ݂ܘܿܪܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܐܝܼܡܲܢ ܕܡܲܚܙܹܝܬ ܒܘܼܣܵܡܵܐ ܠܥܲܡܘܼܟ݂، ܣܲܚܒܸܪܝܼ ܒܦܘܼܪܩܵܢܘܼܟ݂، ");
INSERT INTO aii_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","ܩܵܐ ܕܚܵܙܹܝܢ ܛܵܒ݂ܬܵ‌ܐ ܕܓܘܼܒܝܘܼ̈ܟ݂، ܩܵܐ ܕܚܵܕܹܝܢ ܒܚܲܕܘܼܬܵ‌ܐ ܕܐܘܼܡܬܘܼܟ݂، ܩܵܐ ܕܫܲܒܚܸܢ ܥܲܡ ܝܵܪܬܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","ܚܛܹܐ ܠܲܢ ܥܲܡ ܐܲܒ݂ܵܗܵܬܲܢ̈، ܥܒ݂ܝܼܕ ܠܲܢ ܥܵܘܠܵܐ، ܥܒ݂ܝܼܕ ܠܲܢ ܒܝܼܫܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","ܐܲܒ݂ܵܗܵܬܲܢ̈ ܓܵܘ ܡܸܨܪܹܝܢ ܠܵܐ ܦܘܼܪܡܹܐ ܠܗܘܿܢ ܥܲܓ̰ܝܼܒܘܼܝܵܬܘܼ̈ܟ݂، ܠܵܐ ܕܟ݂ܝܼܪܗܘܿܢ ܠܦܸܪܝܘܼܬܵ‌ܐ ܕܛܲܝܒܘܵܬܘܼ̈ܟ݂، ܐܸܠܵܐ ܥܒ݂ܝܼܕ ܠܗܘܿܢ ܡܵܪܘܿܕܘܼܬܵ‌ܐ ܠܟܸܣ ܝܵܡܵܐ، ܝܵܡܵܐ ܕܣܘܿܦ. ");
INSERT INTO aii_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","ܐܝܼܢܵܐ ܦܘܼܪܩܵܝ ܠܹܗ ܒܘܼܬ ܫܸܡܹܗ، ܠܡܲܕܘܼܥܹܐ ܓܲܒܵܪܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","ܘܢܓ̰ܝܼܘ ܠܹܗ ܒܝܵܡܵܐ ܕܣܘܿܦ ܘܒܪܝܼܙ ܠܵܗ̇، ܘܡܘܼܚܕܸܪܵܝ ܠܹܗ ܓܵܘ ܥܘܼܡܩܹ̈ܐ ܐܲܝܟ݂ ܕܐܸܢ ܓܵܘ ܒܲܪܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","ܘܦܘܼܪܩܵܝ ܠܹܗ ܡ̣ܢ ܐܝܼܕܵܐ ܕܣܵܢܝܵܢܵܐ، ܘܦܘܼܨܝܵܝ ܠܹܗ ܡ̣ܢ ܐܝܼܕܵܐ ܕܕܸܫ̃ܡܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","ܘܟܘܼܣܹܐ ܠܗܘܿܢ ܡ̈ܝܼܵܐ ܠܡܲܠܝܸܨܵܢܵܝ̈ܗ‌ܝ، ܚܲܕ ܡܸܢܵܝܗ‌ܝ ܠܵܐ ܦܝܼܫ ܠܹܗ ܫܒ݂ܝܼܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","ܘܗܘܼܡܸܢܗܘܿܢ ܒܗܹܡܸܙܡܵܢܘܼ̈ܗ‌ܝ، ܙܡܝܼܪܗܘܿܢ ܬܸܫܒܘܿܚܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","ܓ̰ܲܠܕܹܐ ܢܫܹܐ ܠܗܘܿܢ ܦܘܼܠܚܵܢܘܼ̈ܗ‌ܝ، ܠܵܐ ܣܦܝܼܪܗܘܿܢ ܠܡܸܠܟܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","ܘܫܘܼܗܘܸܬ ܠܗܘܿܢ ܫܲܗܘܲܬܬܵ‌ܐ ܓܵܘ ܒܲܪܝܼܵܐ، ܓ̰ܘܼܪܸܒ ܠܗܘܿܢ ܠܐܲܠܵܗܵܐ ܓܵܘ ܡܲܕܒܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܛܠܵܒܬܵܝܗ‌ܝ، ܐܝܼܢܵܐ ܫܘܼܕܸܪܹܗ ܒܲܓܝܼܪܘܼܬܵ‌ܐ ܒܓܵܢܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","ܘܒܘܼܚܸܠܔ ܠܗܘܿܢ ܒܡܘܼܫܹܐ ܓܵܘ ܡܲܫܪܝܼܬܵ‌ܐ، ܘܒܐܲܗܪܘܿܢ ܩܲܕܝܼܫܵܐ ܕܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","ܦܬܝܼܚ ܠܵܗ̇ ܐܲܪܥܵܐ ܘܒܠܝܼܥ ܠܵܗ̇ ܠܕܵܬܵܢ، ܘܟܘܼܣܹܐ ܠܵܗ̇ ܥܲܠܔ ܟܸܢܫܵܐ ܕܐܲܒ݂ܝܼܪܵܡ. ");
INSERT INTO aii_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","ܘܛܦܹܐ ܠܹܗ ܢܘܼܪܵܐ ܓܵܘ ܟܸܢܫܵܝܗ‌ܝ، ܠܵܗܵܐ ܠܒ݂ܝܼܟ݂ ܠܹܗ ܒܒܝܼܫܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","ܬܘܼܪܸܨ ܠܗܘܿܢ ܡܘܼܓ̰ܵܐ ܓܵܘ ܚܘܿܪܝܼܒ݂، ܘܣܓ݂ܝܼܕ ܠܗܘܿܢ ܠܨܲܠܡܵܐ ܪܸܡܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","ܘܡܘܼܚܠܸܦ ܠܗܘܿܢ ܚܸܩܪܵܝܗ‌ܝ ܒܕܘܼܡܝܵܐ ܕܬܵܘܪܵܐ ܐܵܟ݂ܠܵܢܵܐ ܕܓܸܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","ܢܫܹܐ ܠܗܘܿܢ ܠܐܲܠܵܗܵܐ ܦܵܪܘܿܩܵܝܗ‌ܝ، ܥܵܒ݂ܕܵܢܵܐ ܕܫܘܼܠܵܢܹ̈ܐ ܓܘܼܪܹ̈ܐ ܓܵܘ ܡܸܨܪܹܝܢ، ");
INSERT INTO aii_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","ܥܲܓ̰ܝܼܒܘܼܝܵܬܹ̈‌ܐ ܓܵܘ ܐܲܪܥܵܐ ܕܚܵܡ، ܣܲܗܡܵܢܘܼܝܵܬܹ̈‌ܐ ܒܝܵܡܵܐ ܕܣܘܿܦ. ");
INSERT INTO aii_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","ܒܘܼܬ ܐܵܗܵܐ ܐܡܝܼܪܹܗ ܕܒܸܬ ܛܲܠܸܩ ܠܗܘܿܢ، ܐܸܢ ܠܵܐ ܟܵܠܹܐ ܗܘܵܐ ܡܘܼܫܹܐ ܓܘܼܒܝܹܗ ܒܬܪܵܥܬܵ‌ܐ ܩܲܕܡܘܼܗ‌ܝ، ܠܡܲܕܘܼܪܹܐ ܚܸܡܬܹܗ ܡ̣ܢ ܡܲܚܪܘܼܒܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","ܘܡܘܼܣܠܹܐ ܠܗܘܿܢ ܠܐܲܪܥܵܐ ܫܘܼܗܘܸܬܬܵ‌ܐ، ܠܵܐ ܗܘܼܡܸܢܗܘܿܢ ܠܚܲܒܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","ܘܛܘܼܪܛܸܡ ܠܗܘܿܢ ܓܵܘ ܡܲܫܟܢܵܝ̈ܗ‌ܝ، ܠܵܐ ܫܡܝܼܥ ܠܗܘܿܢ ܠܩܵܠܵܐ ܕܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","ܘܡܘܼܪܸܡ ܠܹܗ ܐܝܼܕܹܗ ܥܲܠܵܝܗ‌ܝ، ܠܡܲܢܦܘܼܠܵܝ ܓܵܘ ܒܲܪܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","ܘܠܡܲܢܦܘܼܠܹܐ ܙܲܪܥܵܝܗ‌ܝ ܓܵܘ ܐܸܡܘܵܬܹ̈‌ܐ، ܘܠܒܲܪܒܘܼܙܵܝ ܓܵܘ ܐܲܪ̈ܥܵܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","ܘܬܒܝܼܥ ܠܗܘܿܢ ܠܒܥܸܠܔ ܦܥܘܿܪ، ܘܐܟ݂ܝܼܠܔ ܠܗܘܿܢ ܕܸܒ݂ܚܹ̈ܐ ܡܘܼܩܪܸܒܹܐ ܠܡܝܼ̈ܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","ܘܡܘܼܟܪܸܒ ܠܗܘܿܢ ܐܸܠܹܗ ܒܥܒ݂ܵܕܵܝ̈ܗ‌ܝ، ܘܬܪܝܼܥ ܠܵܗ̇ ܒܝܼܵܝܗ‌ܝ ܡܚܘܿܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","ܩܝܼܡ ܠܹܗ ܦܝܼܢܚܸܣ ܘܥܒ݂ܝܼܕ ܠܹܗ ܡܸܨܥܵܝܘܼܬܵ‌ܐ، ܘܦܝܼܫ ܠܵܗ̇ ܡܘܼܟܠܝܼܬܵ‌ܐ ܡܚܘܿܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","ܘܦܝܼܫ ܠܵܗ̇ ܚܘܼܫܒܸܢܬܵ‌ܐ ܐܸܠܹܗ ܠܙܲܕܝܼܩܘܼܬܵ‌ܐ ܠܕܵܪܵܐ ܘܕܵܪܵܐ ܗܲܠܔ ܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","ܘܩܵܡ ܡܲܟܪܸܒܝܼ ܠܹܗ ܥܲܠܔ ܡ̈ܝܼܵܐ ܕܡܪܝܼܒ݂ܵܐ، ܘܗܘܹܐ ܠܵܗ̇ ܣܪܝܼܬܵ‌ܐ ܠܡܘܼܫܹܐ ܡܥܸܠܬܵܝܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","ܣܵܒܵܒ ܡܘܼܟܪܸܒ ܠܗܘܿܢ ܠܪܘܼܚܹܗ، ܘܒܘܼܠܒܸܠܔ ܠܹܗ ܒܣܸܦܘܵܬܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","ܠܵܐ ܛܘܼܠܸܩ ܠܗܘܿܢ ܠܥܲܡܡܹ̈ܐ، ܐܲܝܟ݂ ܕܐܡܝܼܪܹܗ ܡܵܪܝܵܐ ܐܸܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","ܐܝܼܢܵܐ ܚܒ݂ܝܼܛ ܠܗܘܿܢ ܒܐܸܡܘܵܬܹ̈‌ܐ، ܘܝܠܝܼܦ ܠܗܘܿܢ ܦܘܼܠܚܵܢܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","ܦܠܝܼܚ ܠܗܘܿܢ ܠܨܵܢܲܡܵܝ̈ܗ‌ܝ ܘܗܘܹܐ ܠܗܘܿܢ ܐܸܠܵܝܗ‌ܝ ܠܢܸܫܒ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","ܘܕܒ݂ܝܼܚ ܠܗܘܿܢ ܒܢܘܿܢܵܝ̈ܗ‌ܝ ܘܒܢܵܬܵܝ̈ܗ‌ܝ ܠܫܹܐܕܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","ܫܘܼܦܸܟ݂ ܠܗܘܿܢ ܕܸܡܵܐ ܙܲܟܵܝܵܐ، ܕܸܡܵܐ ܕܒܢܘܿܢܵܝ̈ܗ‌ܝ ܘܕܒܢܵܬܵܝ̈ܗ‌ܝ، ܐܲܝܢܝܼ ܕܕܒ݂ܝܼܚ ܠܗܘܿܢ ܠܨܵܢܲܡܹ̈ܐ ܕܟܢܲܥܢ، ܘܦܝܼܫ ܠܵܗ̇ ܟ̰ܘܼܦܠܸܢܬܵ‌ܐ ܐܲܪܥܵܐ ܒܕܸܡܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","ܗܘܹܐ ܠܗܘܿܢ ܛܲܡܐܹ̈ܐ ܒܦܘܼܠܚܵܢܵܝ̈ܗ‌ܝ، ܘܙܢܹܐ ܠܗܘܿܢ ܒܥܒ݂ܵܕܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","ܒܘܼܬ ܐܵܗܵܐ ܚܝܼܡ ܠܵܗ̇ ܟܲܪܒܵܐ ܕܡܵܪܝܵܐ ܥܲܠܔ ܥܲܡܹܗ، ܘܓܘܼܢܓܸܙ ܠܹܗ ܡ̣ܢ ܝܵܪܬܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","ܣܘܼܦܝܵܝ ܠܹܗ ܒܐܝܼܕܵܐ ܕܐܸܡܘܵܬܹ̈‌ܐ، ܘܗܘܼܟܸܡ ܠܗܘܿܢ ܥܲܠܵܝܗ‌ܝ ܣܵܢܝܵܢܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","ܡܘܼܠܝܸܨܵܝ ܠܗܘܿܢ ܕܸܫ̃ܡܸܢܵܝ̈ܗ‌ܝ، ܘܦܝܼܫ ܠܗܘܿܢ ܙܘܼܒܛܸܢܹܐ ܬܚܘܿܬ ܐܝܼܕܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","ܪܵܒܵܐ ܓܵܗܹ̈ܐ ܦܘܼܨܝܵܝ ܠܹܗ، ܐܝܼܢܵܐ ܐܵܢܝܼ ܥܒ݂ܝܼܕ ܠܗܘܿܢ ܡܵܪܘܿܕܘܼܬܵ‌ܐ ܒܚܘܼܫܵܒ݂ܵܝ̈ܗ‌ܝ، ܘܦܝܼܫ ܠܗܘܿܢ ܡܘܼܟܸܦܹܐ ܒܥܵܘܠܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","ܐܝܼܢܵܐ ܚܙܹܐ ܠܹܗ ܐܘܼܠܨܵܢܵܝܗ‌ܝ، ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܹܗ ܠܓܥܵܝܬܵܝܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","ܘܒܘܼܬ ܕܝܼܵܝܗ‌ܝ ܕܟ݂ܝܼܪܹܗ ܘܲܥܕܹܗ، ܘܦܫܝܼܡ ܠܹܗ ܐܲܝܟ݂ ܦܸܪܝܘܼܬܵ‌ܐ ܕܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܪ̈ܲܚܡܹܐ، ܩܲܕܡ ܟܠܵܝܗ‌ܝ ܠܲܒܠܵܢܵܝ̈ܗ‌ܝ ܠܐܲܣܝܼܪܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","ܦܲܪܸܩ ܠܲܢ، ܝܵܐ ܡܵܪܝܵܐ ܐܲܠܵܗܲܢ، ܘܓ̰ܲܡܸܥ ܠܲܢ ܡ̣ܢ ܐܸܡܘܵܬܹ̈‌ܐ، ܕܫܲܟܪܲܚ ܠܫܸܡܵܐ ܕܩܘܼܕܫܘܼܟ݂، ܕܫܲܒܚܲܚ ܒܬܸܫܒܘܿܚܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","ܒܪܝܼܟ݂ܵܐ ܝܠܹܗ ܡܵܪܝܵܐ ܐܲܠܵܗܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ، ܡ̣ܢ ܥܵܠܲܡ ܘܗܲܠܔ ܥܵܠܲܡ، ܘܐܵܡܹܪ ܟܠܹܗ ܥܲܡܵܐ ܐܵܡܹܝܢ. ܗܲܠܸܠܘܼܝܵܐ ");
INSERT INTO aii_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","ܫܲܟܪܘܼܢ ܠܡܵܪܝܵܐ ܣܵܒܵܒ ܛܵܒ݂ܵܐ ܝܠܹܗ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","ܫܒ݂ܘܿܩ ܐܵܡܪܝܼ ܦܪ̈ܝܼܩܹܐ ܕܡܵܪܝܵܐ، ܕܦܘܼܪܩܵܝ ܠܹܗ ܡ̣ܢ ܐܝܼܕܵܐ ܕܡܲܠܝܸܨܵܢܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","ܘܡ̣ܢ ܐܲܪ̈ܥܵܬܹ‌ܐ ܓ̰ܘܼܡܥܵܝ ܠܹܗ، ܡ̣ܢ ܡܲܕܢܚܵܐ ܘܡ̣ܢ ܡܲܥܪܒ݂ܵܐ، ܡ̣ܢ ܓܲܪܒܝܵܐ ܘܡ̣ܢ ܬܲܝܡܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","ܚܕܝܼܪܗܘܿܢ ܓܵܘ ܒܲܪܝܼܵܐ، ܒܐܘܼܪܚܵܐ ܚܵܪܵܒܵܐ، ܠܵܐ ܡܘܼܫ݇ܟ̰ܸܚ ܠܗܘܿܢ ܡܕܝܼܢ݇ܬܵ‌ܐ ܕܥܡܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","ܟܦܝܼܢܹ̈ܐ ܐܘܼܦ ܨܹܗܝܹ̈ܐ، ܓܵܢܵܝܗ‌ܝ ܕܘܼܪܕܸܫ̃ ܠܵܗ̇ ܒܓܵܘܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","ܗ̇ܝܓܵܗ ܡܘܼܩܘܸܚ ܠܗܘܿܢ ܠܡܵܪܝܵܐ ܟܲܕ ܥܝܼܩ ܠܵܗ̇ ܐܸܠܵܝܗ‌ܝ، ܘܡ̣ܢ ܐܘܼܠܨܵܢܵܝ̈ܗ‌ܝ ܦܘܼܨܝܵܝ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","ܘܠܘܼܒܠܵܝ ܠܹܗ ܒܐܘܼܪܚܵܐ ܬܪܘܼܨܬܵ‌ܐ، ܠܹܐܙܵܠܵܐ ܠܡܕܝܼܢ݇ܬܵ‌ܐ ܕܥܡܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","ܫܒ݂ܘܿܩ ܫܲܟܪܝܼ ܠܡܵܪܝܵܐ ܒܘܼܬ ܛܲܝܒܘܼܬܹܗ، ܘܒܘܼܬ ܕܘܼܡܵܪ̈ܘܼܗ‌ܝ ܠܒܢܲܝ̈ܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","ܣܵܒܵܒ ܟܹܐ ܡܲܣܒܸܥ ܓܵܢܵܐ ܨܗܝܼܬܵ‌ܐ، ܘܟܹܐ ܡܵܠܹܐ ܛܵܒ݂ܬܵ‌ܐ ܠܓܵܢܵܐ ܟܦܝܼܢܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","ܐܚܹܪ̈ܢܹܐ ܝܬܝܼܒ݂ ܠܗܘܿܢ ܒܚܸܫܟܵܐ ܘܒܛܸܠܵܢܝܼܬܵ‌ܐ ܕܡܵܘܬܵ‌ܐ، ܐܲܣܝܼܪܹ̈ܐ ܒܐܘܼܠܨܵܢܵܐ ܘܒܦܪܸ̈ܙܠܹܐ، ");
INSERT INTO aii_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","ܣܵܒܵܒ ܥܒ݂ܝܼܕ ܠܗܘܿܢ ܡܵܪܘܿܕܘܼܬܵ‌ܐ ܥܲܠܔ ܗܹܡܸܙܡܵܢܹ̈ܐ ܕܐܲܠܵܗܵܐ، ܘܡܸܠܟܵܐ ܕܥܸܠܵܝܵܐ ܡܘܼܣܠܹܐ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","ܒܘܼܬ ܐܵܗܵܐ، ܡܘܼܟܸܦ ܠܹܗ ܒܥܲܡܠܵܐ ܠܸܒܵܝܗ‌ܝ، ܬܘܼܪܩܸܠܔ ܠܗܘܿܢ ܘܠܲܝܬ ܗܘܵܐ ܗܲܝܸܪܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","ܗ̇ܝܓܵܗ ܡܘܼܩܘܸܚ ܠܗܘܿܢ ܠܡܵܪܝܵܐ ܟܲܕ ܥܝܼܩ ܠܵܗ̇ ܐܸܠܵܝܗ‌ܝ، ܘܡ̣ܢ ܐܘܼܠܨܵܢܵܝ̈ܗ‌ܝ ܦܘܼܪܩܵܝ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","ܦܘܼܠܛܵܝ ܠܹܗ ܡ̣ܢ ܚܸܫܟܵܐ ܘܛܸܠܵܢܝܼܬܵ‌ܐ ܕܡܵܘܬܵ‌ܐ، ܘܩܛܝܼܥ ܠܹܗ ܐܸܣܘܼܪ̈ܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","ܫܒ݂ܘܿܩ ܫܲܟܪܝܼ ܠܡܵܪܝܵܐ ܒܘܼܬ ܛܲܝܒܘܼܬܹܗ، ܘܒܘܼܬ ܕܘܼܡܵܪ̈ܘܼܗ‌ܝ ܠܒܢܲܝ̈ܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","ܣܵܒܵܒ ܬܒ݂ܝܼܪܹܗ ܬܲܪ̈ܥܵܢܹܐ ܕܢܚܵܫܵܐ، ܘܢܣܝܼܪܹܗ ܕܵܒ݂ܪܹ̈ܐ ܕܦܪܸܙܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","ܣܲܟ݂ܠܹ̈ܐ ܡ̣ܢ ܐܘܼܪܚܵܐ ܕܓܢܵܗܵܝܗ‌ܝ، ܦܝܼܫ ܠܗܘܿܢ ܡܘܼܠܝܸܨܹܐ ܡ̣ܢ ܥܸܠܬܵ‌ܐ ܕܥܵܘܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","ܡ̣ܢ ܟܠܔ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ ܓܘܼܢܓܸܙ ܠܵܗ̇ ܓܵܢܵܝܗ‌ܝ، ܘܩܘܼܪܒܸܢܗܘܿܢ ܗܲܠܔ ܬܲܪ̈ܥܵܢܹܐ ܕܡܵܘܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","ܗ̇ܝܓܵܗ ܡܘܼܩܘܸܚ ܠܗܘܿܢ ܠܡܵܪܝܵܐ ܟܲܕ ܥܝܼܩ ܠܵܗ̇ ܐܸܠܵܝܗ‌ܝ، ܘܡ̣ܢ ܐܘܼܠܨܵܢܵܝ̈ܗ‌ܝ ܦܘܼܪܩܵܝ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","ܫܘܼܕܸܪܹܗ ܚܲܒܪܹܗ ܘܒܘܼܣܡܵܝ ܠܹܗ، ܘܦܘܼܨܝܵܝ ܠܹܗ ܡ̣ܢ ܚܪ̈ܵܒ݂ܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","ܫܒ݂ܘܿܩ ܫܲܟܪܝܼ ܠܡܵܪܝܵܐ ܒܘܼܬ ܛܲܝܒܘܼܬܹܗ، ܘܒܘܼܬ ܕܘܼܡܵܪ̈ܘܼܗ‌ܝ ܠܒܢܲܝ̈ܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","ܘܕܵܒ݂ܚܝܼ ܕܸܒ݂ܚܵܐ ܕܫܲܟܲܪܬܵ‌ܐ، ܘܗܲܩܝܼ ܒܘܼܬ ܦܘܼܠܚܵܢܘܼ̈ܗ‌ܝ ܒܩܲܘܲܚܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","ܨܵܠܝܵܢܹ̈ܐ ܕܝܵܡܵܐ ܒܓܵܡܝܼܹ̈ܐ، ܬܲܓܵܪܹ̈ܐ ܒܡ̈ܝܼܵܐ ܪ̈ܘܝܼܚܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","ܐܵܢܝܼ ܚܙܹܐ ܠܗܘܿܢ ܦܘܼܠܚܵܢܹ̈ܐ ܕܡܵܪܝܵܐ، ܘܕܘܼܡܵܪ̈ܘܼܗ‌ܝ ܒܥܘܼܡܩܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","ܐܡܝܼܪܹܗ ܘܡܘܼܩܸܡ ܠܹܗ ܦܵܘܚܵܐ ܕܥܲܠܥܵܠܵܐ، ܘܦܝܼܫ ܠܗܘܿܢ ܡܘܼܪܡܹܐ ܠܲܦܹ̈ܐ ܕܝܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","ܐܣܝܼܩ ܠܗܘܿܢ ܠܫܡܲܝܵܐ ܘܨܠܹܐ ܠܗܘܿܢ ܠܬܗܘܿܡܹ̈ܐ، ܦܫܝܼܪܵܗ̇ ܓܵܢܵܝܗ‌ܝ ܒܣܸܪܝܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","ܦܘܼܢܦܸܠܔ ܠܗܘܿܢ ܘܫܥܝܼܫ ܠܗܘܿܢ ܐܲܝܟ݂ ܪ̈ܵܘܵܝܹܐ، ܘܟܠܵܗ̇ ܚܸܟ݂ܡܬܵܝܗ‌ܝ ܦܝܼܫ ܠܵܗ̇ ܒܠܝܼܥܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","ܗ̇ܝܓܵܗ ܡܘܼܩܘܸܚ ܠܗܘܿܢ ܠܡܵܪܝܵܐ ܟܲܕ ܥܝܼܩ ܠܵܗ̇ ܐܸܠܵܝܗ‌ܝ، ܘܡ̣ܢ ܐܘܼܠܨܵܢܵܝ̈ܗ‌ܝ ܩܵܡ ܦܲܠܸܛ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","ܡܘܼܫܬܸܩ ܠܹܗ ܠܥܲܠܥܵܠܵܐ، ܘܗܘܹܐ ܠܗܘܿܢ ܫܸܠܝܹܐ ܠܲܦܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","ܘܚܕܹܐ ܠܗܘܿܢ ܟܲܕ ܫܬܝܼܩ ܠܵܗ̇، ܘܡܕܘܼܒܪܵܝ ܠܹܗ ܠܠܡܹܐܢܵܐ ܕܨܸܒ݂ܝܵܢܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","ܫܒ݂ܘܿܩ ܫܲܟܪܝܼ ܠܡܵܪܝܵܐ ܒܘܼܬ ܛܲܝܒܘܼܬܹܗ، ܘܒܘܼܬ ܕܘܼܡܵܪ̈ܘܼܗ‌ܝ ܠܒܢܲܝ̈ܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","ܘܡܲܪܡܝܼ ܠܹܗ ܒܟܸܢܫܵܐ ܕܥܲܡܵܐ، ܘܓܵܘ ܡܵܘܬܒ݂ܵܐ ܕܚܘܵܪ̈ܕܸܩܢܹܐ ܚܵܩܪܝܼ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","ܟܹܐ ܡܲܚܕܸܪ ܢܲܗܪ̈ܵܘܵܬܹ‌ܐ ܠܒܲܪܝܼܵܐ، ܘܡܲܒܘܼܥܹ̈ܐ ܕܡ̈ܝܼܵܐ ܠܐܲܪܥܵܐ ܨܗܝܼܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","ܘܐܲܪܥܵܐ ܕܛܥܘܼܢܝܵܬܹ̈‌ܐ ܠܐܲܪܥܵܐ ܡܸܠܚܵܢܬܵ‌ܐ، ܡ̣ܢ ܥܸܠܬܵ‌ܐ ܕܒܝܼܫܘܼܬܵ‌ܐ ܕܝܵܬܒ݂ܵܢܹ̈ܐ ܕܓܵܘܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","ܟܹܐ ܡܲܚܕܸܪ ܒܲܪܝܼܵܐ ܠܒܸܪ̈ܟܹܐ ܕܡ̈ܝܼܵܐ، ܘܐܲܪܥܵܐ ܨܗܝܼܬܵ‌ܐ ܠܡܲܒܘܼܥܹ̈ܐ ܕܡ̈ܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","ܘܟܹܐ ܡܲܬܸܒ݂ ܬܵܡܵܐ ܟܦܝܼܢܹ̈ܐ، ܘܟܹܐ ܫܲܬܐܸܣܝܼ ܡܕܝܼܢ݇ܬܵ‌ܐ ܠܸܥܡܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","ܘܟܹܐ ܙܵܪܥܝܼ ܚܲܩܠܵܢܹ̈ܐ ܘܢܵܨܒ݂ܝܼ ܟܲܪ̈ܡܵܢܹܐ، ܘܫܵܩܠܝܼ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܦܸܪ̈ܝܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","ܘܟܹܐ ܒܲܪܸܟ݂ ܠܗܘܿܢ ܘܟܹܐ ܙܵܝܕܝܼ ܪܵܒܵܐ، ܘܪܸܣܩܵܝܗ‌ܝ ܠܹܐ ܡܲܒܨܸܪ. ");
INSERT INTO aii_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","ܐܝܼܡܲܢ ܕܚܵܣܪܝܼ ܘܦܵܝܫܝܼ ܡܘܼܟܸܦܹܐ ܡ̣ܢ ܙܠܘܼܡܝܵܐ، ܒܝܼܫܘܼܬܵ‌ܐ، ܘܚܲܫܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","ܟܹܐ ܫܲܦܸܟ݂ ܡܲܣܠܲܝܬܵ‌ܐ ܥܲܠܔ ܢܲܨܝܼܚܹ̈ܐ، ܘܟܹܐ ܡܲܚܠܸܛ ܠܵܗ̇ ܐܘܼܪܚܵܝܗ‌ܝ ܒܐܲܪܥܵܐ ܚܵܪܵܒܵܐ ܕܠܲܝܬ ܠܵܗ̇ ܦܠܵܛܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","ܐܝܼܢܵܐ ܟܹܐ ܡܲܪܸܡ ܠܗܘܿܢ ܣܢܝܼܩܹ̈ܐ ܠܫܲܝܢܵܐ ܡ̣ܢ ܐܘܼܠܨܵܢܵܐ، ܘܟܹܐ ܥܵܒܹܕ ܐܲܝܟ݂ ܦܸܣܩܵܐ ܫܲܪ̈ܒܵܬܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","ܒܸܬ ܚܵܙܝܼ ܬܪ̈ܘܼܨܹܐ ܘܒܸܬ ܚܵܕܝܼ، ܘܟܠܔ ܥܵܘܠܵܐ ܒܸܬ ܐܵܟ̰ܹܡ ܦܘܼܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","ܡܵܢܝܼ ܝܠܹܗ ܚܲܟܝܼܡܵܐ؟ ܫܒ݂ܘܿܩ ܢܵܛܹܪ ܐܲܢܹܐ، ܘܦܲܪܡܹܐ ܛܲܝܒܘܼܬܵ‌ܐ ܕܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","ܡܘܼܩܘܝܼܵܐ ܝܠܹܗ ܠܸܒܝܼ، ܝܵܐ ܐܲܠܵܗܵܐ، ܒܸܬ ܫܲܒܚܸܢ ܘܒܸܬ ܙܵܡܪܹܢ ܒܟܠܵܗ̇ ܓܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","ܪܥܘܿܫܝ ܩܝܼܬܵܪܵܐ ܘܟܸܢܵܪܵܐ، ܒܸܬ ܡܲܪܥܸܫܸܢ ܠܨܲܦܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","ܒܸܬ ܫܲܟܪܸܢ ܐܸܠܘܼܟ݂ ܓܵܘ ܥܲܡܡܹ̈ܐ، ܝܵܐ ܡܵܪܝܵܐ، ܘܒܸܬ ܙܵܡܪܹܢ ܐܸܠܘܼܟ݂ ܓܵܘ ܐܸܡܘܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","ܣܵܒܵܒ ܓܘܼܪܬܵ‌ܐ ܝܠܵܗ̇ ܛܲܝܒܘܼܬܘܼܟ݂ ܥܸܠܸܠܔ ܡ̣ܢ ܫܡܲܝܵܐ، ܘܗܲܠܔ ܪܩܝܼܥܵܐ ܡܗܘܼܡܢܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","ܪܘܼܡ ܥܸܠܸܠܔ ܡ̣ܢ ܫܡܲܝܵܐ، ܝܵܐ ܐܲܠܵܗܵܐ، ܘܥܲܠܔ ܟܠܵܗ̇ ܐܲܪܥܵܐ ܐܝܼܩܵܪܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","ܩܵܐ ܕܦܵܨܝܼ ܡܘܼܚܸܒܘܼ̈ܟ݂، ܦܲܪܸܩ ܒܝܲܡܝܼܢܘܼܟ݂ ܘܓ̰ܲܘܸܒ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","ܐܲܠܵܗܵܐ ܗܘܼܡܙܸܡ ܠܹܗ ܒܩܘܼܕܫܹܗ: ”ܒܸܬ ܦܵܨܚܹܢ، ܒܸܬ ܦܲܠܥܸܢ ܠܫܟܹܝܡ، ܘܪܵܘܘܿܠܵܐ ܕܣܵܟܘܼܬ ܒܸܬ ܟܵܝܠܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","”ܕܝܼܝܼ ܝܠܹܗ ܓܸܠܥܵܕ، ܕܝܼܝܼ ܝܠܹܗ ܡܢܲܫܹܐ، ܐܲܦܪܹܝܡ ܣܲܢܘܲܪܬܵ‌ܐ ܕܪܹܝܫܝܼ، ܝܼܗܘܼܕܵܐ ܚܘܼܛܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","ܡܘܼܐܵܒ݂ ܡܵܪܸܓܠܵܐ ܕܚܲܠܲܠܬ‌ܝܼ، ܥܲܠܔ ܐܲܕܘܿܡ ܒܸܬ ܪܲܦܹܝܢ ܨܵܘܸܠܬ‌ܝܼ، ܥܲܠܔ ܦܠܸܫܬ ܒܸܬ ܡܲܩܘܸܚܸܢ.“ ");
INSERT INTO aii_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","ܡܵܢܝܼ ܒܸܬ ܠܲܒܸܠܔ ܠܝܼ ܠܡܕܝܼܢ݇ܬܵ‌ܐ ܡܘܼܩܘܝܼܬܵ‌ܐ؟ ܡܵܢܝܼ ܒܸܬ ܡܗܲܕܹܐ ܠܝܼ ܗܲܠܔ ܐܲܕܘܿܡ؟ ");
INSERT INTO aii_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","ܗܵܐ، ܠܹܐ ܝܘܸܬ ܡܘܼܚܦܸܠܵܐ ܐܸܠܲܢ، ܝܵܐ ܐܲܠܵܗܵܐ؟ ܘܠܹܐ ܦܵܠܛܹܬ ܥܲܡ ܚܲܝܠܵܘܵܬܲܢ̈، ܝܵܐ ܐܲܠܵܗܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","ܗܲܒ݂ܠܔ ܠܲܢ ܗܲܝܲܪܬܵ‌ܐ ܡ̣ܢ ܕܸܫ̃ܡܸܢ، ܣܵܒܵܒ ܣܪܝܼܩܘܼܬܵ‌ܐ ܝܠܵܗ̇ ܦܲܪܲܩܬܵ‌ܐ ܕܒܲܪܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","ܒܐܲܠܵܗܵܐ ܒܸܬ ܥܵܒ݂ܕܲܚ ܓܲܒܵܪܘܼܬܵ‌ܐ، ܘܗ̇ܘ ܒܸܬ ܕܲܫܕܸܫ ܠܕܸܫ̃ܡܸܢܲܢ̈. ");
INSERT INTO aii_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","ܝܵܐ ܐܲܠܵܗܵܐ ܕܬܸܫܒܘܿܚܬ‌ܝܼ، ܠܵܐ ܫܵܬܩܹܬ. ");
INSERT INTO aii_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","ܣܵܒܵܒ ܦܘܼܡܵܐ ܪܲܫܝܼܥܵܐ ܘܦܘܼܡܵܐ ܦܵܠܘܿܡܵܐ ܥܲܠܝܼ ܦܬܝܼܚ ܠܗܘܿܢ، ܗܘܼܡܙܸܡ ܠܗܘܿܢ ܥܲܡܝܼ ܒܠܸܫܵܢܵܐ ܕܲܓܵܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","ܘܒܗܹܡܸܙܡܵܢܹ̈ܐ ܕܣܢܵܝܬܵ‌ܐ ܩܵܡ ܚܲܪܕܝܼ ܠܝܼ، ܘܦܠܝܼܫ ܠܗܘܿܢ ܥܲܡܝܼ ܒܠܵܐ ܥܸܠܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","ܡ̣ܢ ܓܹܒܵܐ ܕܚܘܼܒܝܼ ܗܘܹܐ ܠܗܘܿܢ ܕܲܠܩܘܼܒ݂ܠܝܼ، ܟܲܕ ܐܵܢܵܐ ܒܨܠܘܿܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","ܘܦܪܝܼܥ ܠܗܘܿܢ ܐܸܠܝܼ ܒܝܼܫܬܵ‌ܐ ܡ̣ܢ ܓܹܒܵܐ ܕܛܵܒ݂ܬܵ‌ܐ، ܘܣܢܵܝܬܵ‌ܐ ܡ̣ܢ ܓܹܒܵܐ ܕܚܘܼܒܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","ܡܲܩܸܡ ܥܲܠܘܼܗ‌ܝ ܪܲܫܝܼܥܵܐ، ܘܕܲܠܩܘܼܒ݂ܠܵܝܵܐ ܟܵܠܹܐ ܥܲܠܔ ܝܲܡܝܼܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","ܐܝܼܡܲܢ ܕܦܵܐܹܫ ܕܝܼܢܵܐ، ܫܒ݂ܘܿܩ ܦܵܠܹܛ ܚܲܝܵܒ݂ܵܐ، ܘܨܠܘܿܬܹܗ ܚܵܕܪܵܐ ܠܚܛܝܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","ܗܵܘܝܼ ܝܵܘܡܵܢܘܼ̈ܗ‌ܝ ܒܵܨܘܿܪܹ̈ܐ، ܘܡܕܲܒܪܵܢܘܼܬܹܗ ܫܵܩܹܠܔ ܚܲܕ ܐܚܹܪܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","ܗܵܘܝܼ ܒܢܘܿܢܘܼ̈ܗ‌ܝ ܝܲܬܘܼܡܹ̈ܐ، ܘܒܲܟ݂ܬܹܗ ܐܲܪܡܸܠܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","ܚܕܵܪܵܐ ܚܵܕܪܝܼ ܒܢܘܿܢܘܼ̈ܗ‌ܝ ܘܓܵܒ݂ܝܼ، ܘܛܵܥܝܼ ܒܵܬܪ ܠܲܚܡܵܐ ܒܕܘܼܟܵܢܵܝ̈ܗ‌ܝ ܚܵܪ̈ܵܒܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","ܟ̰ܵܠܹܓ̰ ܡܵܪܵܐ ܕܕܲܝܢܵܐ ܠܟܠܔ ܡܸܢܕܝܼ ܕܐܝܼܬ ܠܹܗ، ܘܣܵܠܒܝܼ ܢܘܼܟ݂ܪ̈ܵܝܹܐ ܛܥܘܼܢܬܵ‌ܐ ܕܥܲܡܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","ܠܵܐ ܗܵܘܹܐ ܐܸܠܹܗ ܝܵܗܒ݂ܵܢܵܐ ܕܪ̈ܲܚܡܹܐ، ܘܠܵܐ ܗܵܘܹܐ ܥܵܒ݂ܕܵܢܵܐ ܕܚܢܵܢܵܐ ܠܝܲܬܘܼܡܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","ܦܵܐܹܫ ܩܛܝܼܥܵܐ ܙܲܪܥܹܗ، ܘܩܵܐ ܕܵܪܵܐ ܐܚܹܪܢܵܐ ܫܸܡܵܝܗ‌ܝ ܗܵܘܹܐ ܓܪܝܼܕܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","ܦܵܐܹܫ ܕܟ݂ܝܼܪܵܐ ܥܵܘܠܵܐ ܕܐܲܒ݂ܵܗܵܬܘܼ̈ܗ‌ܝ ܠܟܸܣ ܡܵܪܝܵܐ، ܘܚܛܝܼܬܵ‌ܐ ܕܝܸܡܹܗ ܠܵܐ ܦܵܝܫܵܐ ܓܪܝܼܕܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","ܗܵܘܝܼ ܩܲܕܡ ܡܵܪܝܵܐ ܒܟܠܔ ܙܲܒ݂ܢܵܐ، ܘܩܵܛܹܥ ܕܟ݂ܵܪܵܝܗ‌ܝ ܡ̣ܢ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","ܣܵܒܵܒ ܠܵܐ ܕܟ݂ܝܼܪܹܗ ܠܸܥܒ݂ܵܕܵܐ ܛܵܒ݂ܬܵ‌ܐ، ܐܸܠܵܐ ܢܦܝܼܠܔ ܠܹܗ ܒܵܬܪ ܐܢܵܫܵܐ ܡܸܣܟܹܢܵܐ ܘܣܢܝܼܩܵܐ، ܘܡܘܼܥܝܸܩܵܐ ܒܠܸܒܵܐ، ܠܡܲܡܝܘܼܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","ܟܲܕ ܡܘܼܚܸܒ ܠܹܗ ܠܵܘܛܬܵ‌ܐ، ܫܒ݂ܘܿܩ ܐܵܬܝܵܐ ܥܲܠܘܼܗ‌ܝ، ܠܵܐ ܒܣܝܼܡ ܠܵܗ̇ ܠܹܗ ܒܒܘܼܪܟܬܵ‌ܐ، ܫܒ݂ܘܿܩ ܪܵܚܩܵܐ ܡܸܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","ܘܠܒ݂ܝܼܫ ܠܹܗ ܠܵܘܛܬܵ‌ܐ ܐܲܝܟ݂ ܠܒ݂ܝܼܫܬܹܗ، ܘܥܒ݂ܝܼܪܵܗ̇ ܒܓܵܘܹܗ ܐܲܝܟ݂ ܡ̈ܝܼܵܐ، ܘܒܓܲܪ̈ܡܘܼܗ‌ܝ ܐܲܝܟ݂ ܡܸܫܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","ܗܵܘܝܵܐ ܐܸܠܹܗ ܐܲܝܟ݂ ܥܵܒܵܝܬܵ‌ܐ ܕܩܵܛܹܒ݂ ܠܵܗ̇ ܠܓܵܢܹܗ، ܘܐܲܝܟ݂ ܬܲܣܡܵܐ ܒܟܠܔ ܙܲܒ݂ܢܵܐ ܐܵܣܹܪܵܗ̇ ܒܚܲܨܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","ܐܵܗܵܐ ܝܠܹܗ ܦܘܼܪܥܵܢܵܐ ܕܕܲܠܩܘܼܒ݂ܠܵܝܝܼ̈ ܡ̣ܢ ܠܟܸܣ ܡܵܪܝܵܐ، ܘܕܗܲܡܙܸܡܵܢܹ̈ܐ ܕܒܝܼܫܬܵ‌ܐ ܥܲܠܔ ܓܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","ܐܝܼܢܵܐ ܐܲܢ݇ܬ، ܝܵܐ ܡܵܪܝܵܐ ܐܲܠܵܗܵܐ، ܦܠܘܿܚ ܠܓܹܒܝܼ ܒܘܼܬ ܫܸܡܘܼܟ݂، ܦܲܨܝܼ ܠܝܼ، ܣܵܒܵܒ ܨܦܵܝܝܼ ܝܠܵܗ̇ ܛܲܝܒܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","ܣܵܒܵܒ ܡܸܣܟܹܢܵܐ ܘܣܢܝܼܩܵܐ ܝܘܸܢ ܐܵܢܵܐ، ܘܠܸܒܝܼ ܟ̰ܪܝܼܙܵܐ ܝܠܹܗ ܒܓܵܘܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","ܐܲܝܟ݂ ܛܸܠܵܢܝܼܬܵ‌ܐ ܕܒܥܕܵܢܵܐ ܕܓܢܵܝܬܵ‌ܐ ܒܸܛܠܵܩܵܐ ܝܘܸܢ، ܐܲܝܟ݂ ܩܲܡܨܵܐ ܦܝܼܫܵܐ ܝܘܸܢ ܢܦܝܼܨܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","ܒܸܪ̈ܟܵܟܝܼ ܪܓܝܼܕ ܠܗܘܿܢ ܡ̣ܢ ܨܵܘܡܵܐ، ܘܒܸܣܪܝܼ ܢܘܝܼܠܔ ܠܹܗ ܒܗ̇ܝ ܕܠܲܝܬ ܬܲܪܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","ܘܐܵܢܵܐ ܗܘܹܐ ܠܝܼ ܠܵܘܡܵܐ ܐܸܠܵܝܗ‌ܝ، ܟܲܕ ܚܵܙܝܼ ܠܝܼ ܟܹܐ ܫܵܥܫܝܼ ܪܹܝܫܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","ܗܲܝܸܪܝܼ، ܝܵܐ ܡܵܪܝܵܐ ܐܲܠܵܗ‌ܝܼ، ܦܲܪܸܩ ܠܝܼ ܐܲܝܟ݂ ܛܲܝܒܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","ܕܝܵܕܥܝܼ ܕܐܝܼܕܘܼܟ݂ ܝܼܠܵܗ̇ ܐܵܗܵܐ، ܘܐܲܢ݇ܬ، ܝܵܐ ܡܵܪܝܵܐ، ܥܒ݂ܝܼܕܵܐ ܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","ܫܒ݂ܘܿܩ ܐܵܢܝܼ ܠܵܝܛܝܼ، ܐܝܼܢܵܐ ܐܲܢ݇ܬ ܒܲܪܟܸܬ، ܐܝܼܡܲܢ ܕܩܵܝܡܝܼ ܒܸܬ ܢܵܟ݂ܦܝܼ، ܐܝܼܢܵܐ ܪܹܓܘܼܟ݂ ܒܸܬ ܚܵܕܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","ܠܵܒ݂ܫܝܼ ܕܲܠܩܘܼܒ݂ܠܵܝܝܼ̈ ܢܟܸܦܬܵ‌ܐ، ܘܩܵܛܒ݂ܝܼ ܐܲܝܟ݂ ܥܵܒܵܝܬܵ‌ܐ ܢܟܸܦܬܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","ܪܵܒܵܐ ܒܸܬ ܫܲܟܪܸܢ ܠܡܵܪܝܵܐ ܒܦܘܼܡܝܼ، ܘܒܓܵܘܵܐ ܕܟܸܢܫܹ̈ܐ ܒܸܬ ܫܲܒܚܸܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","ܣܵܒܵܒ ܟܹܐ ܟܵܠܹܐ ܠܝܲܡܝܼܢܵܐ ܕܣܢܝܼܩܵܐ، ܠܦܲܪܘܼܩܹܗ ܡ̣ܢ ܕܲܝܵܢܹ̈ܐ ܕܢܲܦ̮ܫܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","ܐܡܝܼܪܹܗ ܡܵܪܝܵܐ ܠܡܵܪܝܼ: ”ܝܬܘܿܒ݂ ܠܝܲܡܝܼܢܝܼ، ܗܲܠܔ ܕܡܲܬܒܸܢ ܕܸܫ̃ܡܸܢܘܼ̈ܟ݂ ܟܘܼܒ݂ܫܵܐ ܬܚܘܿܬ ܐܲܩܠܘܼ̈ܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","ܚܘܼܛܪܵܐ ܕܥܘܼܫܢܘܼܟ݂ ܒܸܬ ܫܲܕܸܪ ܡܵܪܝܵܐ ܡ̣ܢ ܨܸܗܝܘܿܢ، ܒܹܐܡܵܪܵܐ: ”ܥܒ݂ܘܿܕ ܫܘܼܠܛܵܢܵܐ ܓܵܘ ܕܸܫ̃ܡܸܢܘܼ̈ܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","ܥܲܡܘܼܟ݂ ܒܸܬ ܡܲܩܪܸܒ݂ ܓܵܢܹܗ ܒܨܸܒ݂ܝܵܢܵܐ ܒܝܵܘܡܵܐ ܕܚܲܝܠܘܼܟ݂، ܒܣܸܩ̈ܠܹܐ ܕܩܘܼܕܫܵܐ، ܡ̣ܢ ܡܲܪܒܥܵܐ ܕܨܲܦܪܵܐ، ܐܸܠܘܼܟ݂ ܛܠܘܼܠܵܐ ܕܝܵܠܕ݇ܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","ܝܡܹܐ ܠܹܗ ܡܵܪܝܵܐ ܘܠܹܐ ܦܵܫܹܡ: ”ܐܲܢ݇ܬ ܝܼܘܸܬ ܟܵܗܢܵܐ ܠܥܵܠܲܡ ܒܣܸܕܪܵܐ ܕܡܲܠܟܝܼܙܕܸܩ.“ ");
INSERT INTO aii_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","ܡܵܪܝܵܐ ܥܲܠܔ ܝܲܡܝܼܢܘܼܟ݂ ܝܼܠܹܗ، ܗ̇ܘ ܒܸܬ ܛܵܒܹܚ ܡܲܠܟܹ̈ܐ ܒܝܵܘܡܵܐ ܕܚܸܡܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","ܒܸܬ ܕܵܐܹܢ ܓܵܘ ܐܸܡܘܵܬܹ̈‌ܐ، ܒܸܬ ܡܵܠܹܐ ܠܗܘܿܢ ܫܠܲܕܹ̈ܐ، ܒܸܬ ܛܵܒܹܚ ܪܹ̈ܝܫܵܢܹܐ ܥܲܠܔ ܐܲܪܥܵܐ ܪܘܝܼܚܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","ܡ̣ܢ ܢܲܚܠܵܐ ܒܐܘܼܪܚܵܐ ܒܸܬ ܫܵܬܹ‌ܐ، ܒܘܼܬ ܐܵܗܵܐ، ܒܸܬ ܡܲܪܸܡ ܪܹܝܫܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","ܒܸܬ ܫܲܟܪܸܢ ܠܡܵܪܝܵܐ ܒܟܠܹܗ ܠܸܒܝܼ، ܒܡܵܘܬܒ݂ܵܐ ܕܬܪ̈ܘܼܨܹܐ ܘܒܟܢܘܼܫܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","ܓܘܼܪܹ̈ܐ ܝܢܵܐ ܦܘܼܠܚܵܢܹ̈ܐ ܕܡܵܪܝܵܐ، ܟܹܐ ܛܵܥܝܼ ܐܸܠܵܝܗ‌ܝ ܟܠܔ ܕܒܵܣܡܵܐ ܠܗܘܿܢ ܒܝܼܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","ܚܩܝܼܪܵܐ ܘܣܘܼܩܠܵܐ ܝܠܹܗ ܦܘܼܠܚܵܢܹܗ، ܘܙܲܕܝܼܩܘܼܬܹܗ ܦܵܝܫܵܢܬܵ‌ܐ ܝܠܵܗ̇ ܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","ܥܒ݂ܝܼܕܵܝ ܠܹܗ ܕܘܼܡܵܪ̈ܘܼܗ‌ܝ ܠܸܦܝܵܫܵܐ ܕܟ݂ܝܼܪܹܐ، ܚܲܢܵܢܵܐ ܝܠܹܗ ܘܡܪܲܚܡܵܢܵܐ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ ܝܘܼܗܒܹܠܔ ܠܹܗ ܠܙܕܝܼܥܘܼ̈ܗ‌ܝ، ܒܸܬ ܕܵܟܹܪ ܠܥܵܠܲܡ ܘܲܥܕܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","ܚܲܝܠܵܐ ܕܦܘܼܠܚܵܢܘܼ̈ܗ‌ܝ ܡܘܼܕܸܥ ܠܹܗ ܠܥܲܡܹܗ، ܠܝܼܵܗܒ݂ܵܐ ܐܸܠܵܝܗ‌ܝ ܝܵܪܬܘܼܬܵ‌ܐ ܕܐܸܡܘܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","ܦܘܼܠܚܵܢܹ̈ܐ ܕܐܝܼܕܵܬܘܼ̈ܗ‌ܝ ܫܲܪܝܼܪܘܼܬܵ‌ܐ ܝܢܵܐ ܘܕܝܼܘܵܢ، ܡܗܘܼܡܢܹ̈ܐ ܝܢܵܐ ܟܠܵܝܗ‌ܝ ܦܘܼܩܵܕܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","ܦܝܼܫܹܐ ܝܢܵܐ ܡܘܼܩܘܝܼܹܐ ܠܥܵܠܲܡ ܥܵܠܡܝܼܢ، ܦܝܼܫܹܐ ܝܢܵܐ ܥܒ݂ܝܼܕܹܐ ܒܫܲܪܝܼܪܘܼܬܵ‌ܐ ܘܬܪܘܼܨܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","ܦܘܼܪܩܵܢܵܐ ܫܘܼܕܸܪܹܗ ܠܥܲܡܹܗ، ܦܩܝܼܕ ܠܹܗ ܠܥܵܠܲܡ ܘܲܥܕܹܗ، ܩܲܕܝܼܫܵܐ ܝܠܹܗ ܘܣܲܗܡܵܢܵܐ ܫܸܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","ܪܹܝܫܵܐ ܕܚܸܟ݂ܡܬܵ‌ܐ ܙܕܘܼܥܬܵ‌ܐ ܕܡܵܪܝܵܐ ܝܠܵܗ̇، ܦܲܪܡܲܝܬܵ‌ܐ ܨܦܵܝܝܼ ܐܝܼܬ ܠܗܘܿܢ ܟܠܵܝܗ‌ܝ ܥܵܒ݂ܕܵܢܹ̈ܐ ܕܦܘܼܩܵܕܘܼ̈ܗ‌ܝ، ܬܸܫܒܘܿܚܬܹܗ ܦܵܝܫܵܢܬܵ‌ܐ ܝܠܵܗ̇ ܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","ܛܘܼܒ݂ܵܐ ܠܐܢܵܫܵܐ ܕܙܵܕܹܥ ܡ̣ܢ ܡܵܪܝܵܐ، ܒܦܘܼܩܕܵܢܘܼ̈ܗ‌ܝ ܒܵܣܡܵܐ ܠܹܗ ܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","ܓܲܒܵܪܵܐ ܒܐܲܪܥܵܐ ܒܸܬ ܗܵܘܹܐ ܙܲܪܥܹܗ، ܕܵܪܵܐ ܕܬܪ̈ܘܼܨܹܐ ܒܸܬ ܦܵܐܹܫ ܒܘܼܪܟ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","ܕܵܘܸܠܬܵ‌ܐ ܘܥܘܼܬܪܵܐ ܓܵܘ ܒܲܝܬܹܗ ܝܢܵܐ، ܘܙܲܕܝܼܩܘܼܬܹܗ ܦܵܝܫܵܢܬܵ‌ܐ ܝܠܵܗ̇ ܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","ܙܪܝܼܩ ܠܹܗ ܒܲܗܪܵܐ ܓܵܘ ܚܸܫܟܵܐ ܠܬܪܘܼܨܵܐ، ܚܲܢܵܢܵܐ ܝܠܹܗ ܘܡܪܲܚܡܵܢܵܐ ܘܙܲܕܝܼܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","ܛܘܼܒ݂ܵܢܵܐ ܝܠܹܗ ܐܢܵܫܵܐ ܚܲܢܵܢܵܐ ܘܕܟܹܐ ܝܵܗܒܹܠܔ ܕܲܝܢܵܐ، ܕܟܹܐ ܥܵܒܹܕ ܨܒ݂ܘܼܝܵܬܘܼ̈ܗ‌ܝ ܒܗܵܩܘܼܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","ܘܠܥܵܠܲܡ ܠܹܐ ܫܵܥܹܫ، ܕܟ݂ܵܪܵܐ ܕܙܲܕܝܼܩܵܐ ܒܸܬ ܗܵܘܹܐ ܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","ܡ̣ܢ ܚܲܒܪܵܐ ܚܸܪܒܵܐ، ܠܹܐ ܙܵܕܹܥ، ܡܩܵܘܝܵܢܵܐ ܝܠܹܗ ܠܸܒܹܗ ܒܣܲܒ݂ܪܵܐ ܠܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","ܣܢܝܼܕܵܐ ܝܠܹܗ ܠܸܒܹܗ ܠܹܐ ܙܵܕܹܥ، ܗܲܠܔ ܕܚܵܙܹܐ ܙܵܟ݂ܘܼܬܵ‌ܐ ܠܕܸܫ̃ܡܸܢܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","ܒܘܼܪܒܸܙ ܠܹܗ ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܠܣܢܝܼܩܹ̈ܐ، ܙܲܕܝܼܩܘܼܬܹܗ ܦܵܝܫܵܢܬܵ‌ܐ ܝܠܵܗ̇ ܠܥܵܠܲܡ، ܪܹܝܫܹܗ ܒܸܬ ܪܵܐܹܡ ܒܐܝܼܩܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","ܪܲܫܝܼܥܵܐ ܒܸܬ ܚܵܙܹܐ ܘܒܸܬ ܟܵܪܹܒ، ܟܹܟܘܼ̈ܗ‌ܝ ܒܸܬ ܚܲܪܚܸܟ̃ ܘܒܸܬ ܦܵܫܹܪ، ܫܲܗܘܲܬܬܵ‌ܐ ܕܪ̈ܲܫܝܼܥܹܐ ܒܸܬ ܛܵܠܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","ܫܲܒܚܘܼܢ، ܝܵܐ ܪܹ̈ܓܵܘܵܬܹ‌ܐ ܕܡܵܪܝܵܐ، ܫܲܒܚܘܼܢ ܠܫܸܡܵܐ ܕܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","ܗܵܘܹܐ ܫܸܡܵܐ ܕܡܵܪܝܵܐ ܒܘܼܪܟ݂ܵܐ، ܡ̣ܢ ܐܵܕܝܼܵܐ ܘܗܲܠܔ ܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","ܡ̣ܢ ܙܪܵܩܵܐ ܕܫܸܡܫܵܐ ܗܲܠܔ ܓܢܵܝܬܹܗ، ܦܵܐܹܫ ܡܫܘܼܒܚܵܐ ܫܸܡܵܐ ܕܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","ܪܵܡܵܐ ܝܠܹܗ ܥܲܠܔ ܟܠܵܝܗ‌ܝ ܐܸܡܘܵܬܹ̈‌ܐ ܡܵܪܝܵܐ، ܥܸܠܸܠܔ ܡ̣ܢ ܫܡܲܝܵܐ ܝܠܹܗ ܐܝܼܩܵܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","ܡܵܢܝܼ ܝܠܹܗ ܐܲܝܟ݂ ܡܵܪܝܵܐ ܐܲܠܵܗܲܢ، ܕܟܹܐ ܝܵܬܹܒ݂ ܒܪܵܘܡܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","ܕܟܹܐ ܟܵܐܹܦ ܠܸܚܙܵܝܵܐ ܒܫܡܲܝܵܐ ܘܒܐܲܪܥܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","ܟܹܐ ܡܲܩܸܡ ܡ̣ܢ ܥܲܦܪܵܐ ܡܸܣܟܹܢܵܐ، ܡ̣ܢ ܣܘܼܠܬܵ‌ܐ ܟܹܐ ܡܲܪܸܡ ܣܢܝܼܩܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","ܠܡܲܬܘܼܒܹܗ ܥܲܡ ܢܲܨܝܼܚܹ̈ܐ، ܥܲܡ ܢܲܨܝܼܚܹ̈ܐ ܒܓܵܘܵܐ ܕܥܲܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","ܟܹܐ ܝܵܗܒܹܠܔ ܒܲܝܬܵ‌ܐ ܠܥܩܲܪܬܵ‌ܐ، ܠܹܗܘܵܝܵܐ ܝܸܡܵܐ ܚܕܝܼܬܵ‌ܐ ܕܒܢܘܿܢܹ̈ܐ. ܗܲܠܸܠܘܼܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","ܟܲܕ ܦܠܝܼܛ ܠܹܗ ܐܝܼܣܪܵܐܹܝܠܔ ܡ̣ܢ ܡܸܨܪܹܝܢ، ܒܹܝܬ ܝܲܥܩܘܿܒ݂ ܡ̣ܢ ܥܲܡܵܐ ܕܠܸܫܵܢܵܐ ܦܪܝܼܫܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","ܗܘܹܐ ܠܹܗ ܝܼܗܘܼܕܵܐ ܩܘܼܕܫܹܗ، ܐܝܼܣܪܵܐܹܝܠܔ ܫܘܼܠܛܵܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","ܝܵܡܵܐ ܚܙܹܐ ܠܵܗ̇ ܘܥܪܝܼܩ ܠܵܗ̇، ܝܘܿܪܕܢܵܢ ܕܝܼܪܹܗ ܠܒܵܬܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","ܛܘܼܪ̈ܵܢܹܐ ܪܩܝܼܕ ܠܗܘܿܢ ܐܲܝܟ݂ ܒܲܪ̈ܥܵܢܹܐ، ܪ̈ܘܼܡܝܵܬܹ‌ܐ ܐܲܝܟ݂ ܦܹܐܪܹ̈ܐ ܕܦܸܣܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","ܡܵܐ ܠܵܟ݂ܝ ܝܵܡܵܐ ܕܥܵܪܩܲܬ‌ܝ، ܝܘܿܪܕܢܵܢ ܕܕܵܝܪܹܬ ܠܒܵܬܪܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","ܛܘܼܪ̈ܵܢܹܐ ܕܪܵܩܕܝܼܬܘܿܢ ܐܲܝܟ݂ ܒܲܪ̈ܥܵܢܹܐ، ܪ̈ܘܼܡܝܵܬܹ‌ܐ ܐܲܝܟ݂ ܦܹܐܪܹ̈ܐ ܕܦܸܣܩܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","ܪܓܘܿܕܝ ܡ̣ܢ ܩܲܕܡ ܡܵܪܝܵܐ، ܝܵܐ ܐܲܪܥܵܐ، ܡ̣ܢ ܩܲܕܡ ܐܲܠܵܗܵܐ ܕܝܲܥܩܘܿܒ݂، ");
INSERT INTO aii_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","ܗ̇ܘ ܕܡܘܼܚܕܸܪܹܗ ܩܵܝܵܐ ܠܒܸܪ̈ܟܹܐ ܕܡ̈ܝܼܵܐ، ܣܸܡܛܵܐ ܠܥܲܝܢܵܐ ܕܡ̈ܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","ܠܵܐ ܐܸܠܲܢ، ܝܵܐ ܡܵܪܝܵܐ، ܠܵܐ ܐܸܠܲܢ، ܐܸܠܵܐ ܠܫܸܡܘܼܟ݂ ܗܲܒ݂ܠܔ ܐܝܼܩܵܪܵܐ، ܒܘܼܬ ܛܲܝܒܘܼܬܘܼܟ݂، ܒܘܼܬ ܫܲܪܝܼܪܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","ܩܵܡܘܿܕܝܼ ܐܵܡܪܝܼ ܐܸܡܘܵܬܹ̈‌ܐ: ”ܐܲܝܟܵܐ ܝܠܹܗ ܐܲܠܵܗܵܝܗ‌ܝ؟“ ");
INSERT INTO aii_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","ܟܲܕ ܐܲܠܵܗܲܢ ܒܫܡܲܝܵܐ ܝܠܹܗ، ܟܠܔ ܕܒܵܣܡܵܐ ܠܹܗ ܟܹܐ ܥܵܒܹܕ. ");
INSERT INTO aii_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","ܨܵܢܲܡܵܝ̈ܗ‌ܝ ܣܹܐܡܵܐ ܘܕܲܗܒ݂ܵܐ ܝܢܵܐ، ܦܘܼܠܚܵܢܵܐ ܕܐܝܼܕܵܬܹ̈‌ܐ ܕܒܲܪܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","ܦܘܼܡܵܐ ܐܝܼܬ ܠܗܘܿܢ، ܐܝܼܢܵܐ ܠܹܐ ܗܲܡܙܸܡܝܼ، ܥܲܝ̈ܢܹܐ ܐܝܼܬ ܠܗܘܿܢ، ܐܝܼܢܵܐ ܠܹܐ ܚܵܙܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","ܢܵܬܝܵܬܹ̈‌ܐ ܐܝܼܬ ܠܗܘܿܢ، ܐܝܼܢܵܐ ܠܹܐ ܫܵܡܥܝܼ، ܢܵܚܝܼܪܵܐ ܐܝܼܬ ܠܗܘܿܢ، ܐܝܼܢܵܐ ܠܹܐ ܫܵܩܠܝܼ ܪܹܝܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","ܐܝܼܕܵܬܹ̈‌ܐ ܐܝܼܬ ܠܗܘܿܢ، ܐܝܼܢܵܐ ܠܹܐ ܪܵܓ݂ܫܝܼ، ܐܲܩܠܵܬܹ̈‌ܐ ܐܝܼܬ ܠܗܘܿܢ، ܐܝܼܢܵܐ ܠܹܐ ܚܵܕܪܝܼ، ܠܹܐ ܦܲܠܛܝܼ ܩܵܠܵܐ ܒܒܵܠܘܿܥܬܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","ܐܲܝܟ݂ ܕܝܼܵܝܗ‌ܝ ܒܸܬ ܗܵܘܝܼ ܬܲܪ̈ܨܵܢܵܝܗ‌ܝ، ܘܟܠܔ ܕܣܵܒܹܪ ܒܝܼܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","ܝܵܐ ܐܝܼܣܪܵܐܹܝܠܔ، ܣܒܘܿܪ ܒܡܵܪܝܵܐ، ܗܲܝܲܪܬܵܝܗ‌ܝ ܘܡܵܛܵܠܵܝܗ‌ܝ ܗ̇ܘ ܝܼܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","ܝܵܐ ܒܹܝܬ ܐܲܗܪܘܿܢ، ܣܒܘܿܪܘܼܢ ܒܡܵܪܝܵܐ، ܗܲܝܲܪܬܵܝܗ‌ܝ ܘܡܵܛܵܠܵܝܗ‌ܝ ܗ̇ܘ ܝܼܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","ܝܵܐ ܙܕܝܼ̈ܥܹܐ ܕܡܵܪܝܵܐ، ܣܒܘܿܪܘܼܢ ܒܡܵܪܝܵܐ، ܗܲܝܲܪܬܵܝܗ‌ܝ ܘܡܵܛܵܠܵܝܗ‌ܝ ܗ̇ܘ ܝܼܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","ܡܵܪܝܵܐ ܩܵܡ ܕܵܟܹܪܲܢ؛ ܒܸܬ ܒܲܪܸܟ݂، ܒܸܬ ܒܲܪܸܟ݂ ܠܒܹܝܬ ܐܝܼܣܪܵܐܹܝܠܔ، ܒܸܬ ܒܲܪܸܟ݂ ܠܒܹܝܬ ܐܲܗܪܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","ܒܸܬ ܒܲܪܸܟ݂ ܠܙܕܝܼ̈ܥܹܐ ܕܡܵܪܝܵܐ، ܙܥܘܿܪܹ̈ܐ ܥܲܡ ܓܘܼܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","ܡܲܙܝܸܕ ܡܵܪܝܵܐ ܥܲܠܵܘܟ݂ܘܿܢ، ܥܲܠܵܘܟ݂ܘܿܢ ܘܥܲܠܔ ܒܢܘܿܢܵܘ̈ܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","ܒܪܝܼܟܹܐ ܝܬܘܿܢ ܠܡܵܪܝܵܐ، ܥܵܒ݂ܕܵܢܵܐ ܕܫܡܲܝܵܐ ܘܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","ܫܡܲܝܹ̈ܐ، ܫܡܲܝܹ̈ܐ ܕܡܵܪܝܵܐ ܝܢܵܐ، ܐܝܼܢܵܐ ܐܲܪܥܵܐ ܝܘܼܗܒܹܠܔ ܠܹܗ ܠܒܢܲܝ̈ܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","ܡܝܼ̈ܬܹ‌ܐ ܠܹܐ ܫܲܒܚܝܼ ܠܡܵܪܝܵܐ، ܐܵܦܠܵܐ ܟܠܵܝܗ‌ܝ ܨܵܠܝܵܢܹ̈ܐ ܠܫܸܬܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","ܐܝܼܢܵܐ ܐܲܚܢܲܢ ܒܸܬ ܒܲܪܟܲܚ ܠܡܵܪܝܵܐ، ܡ̣ܢ ܐܵܕܝܼܵܐ ܘܗܲܠܔ ܥܵܠܲܡ. ܗܲܠܸܠܘܼܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","ܡܘܼܚܸܒ ܠܝܼ ܠܡܵܪܝܵܐ ܣܵܒܵܒ ܫܡܝܼܥ ܠܹܗ ܩܵܠܝܼ ܘܦܲܪ̈ܦܲܠܝܵܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","ܣܵܒܵܒ ܡܘܼܟܸܦ ܠܹܗ ܢܵܬܹܗ ܐܸܠܝܼ، ܒܝܘܼܪܟ݂ܵܐ ܕܝܵܘܡܵܢܝܼ̈ ܒܸܬ ܩܵܪܹܝܢ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","ܟܪܝܼܟܸܢܗܘܿܢ ܚܸܒ݂ܠܹ̈ܐ ܕܡܵܘܬܵ‌ܐ، ܘܡܘܼܫ݇ܟ̰ܚܸܢܗܘܿܢ ܐܘܼܠܨܵܢܹ̈ܐ ܕܫܝܘܿܠܔ، ܥܵܘܩܵܢܵܐ ܘܚܲܫܵܐ ܡܘܼܫ݇ܟ̰ܸܚ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","ܗ̇ܝܓܵܗ ܒܫܸܡܵܐ ܕܡܵܪܝܵܐ ܩܪܹܐ ܠܝܼ: ”ܐܘܿܗ، ܝܵܐ ܡܵܪܝܵܐ، ܦܲܨܝܼ ܠܓܵܢܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","ܚܲܢܵܢܵܐ ܝܠܹܗ ܡܵܪܝܵܐ ܘܙܲܕܝܼܩܵܐ، ܘܐܲܠܵܗܲܢ ܡܪܲܚܡܵܢܵܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","ܟܹܐ ܢܵܛܹܪ ܠܦܫܝܼ̈ܛܹܐ ܡܵܪܝܵܐ، ܦܝܼܫ ܠܝܼ ܡܘܼܟܸܦܵܐ ܘܩܵܡ ܦܲܪܸܩ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","ܕܘܼܪܝ، ܝܵܐ ܓܵܢܝܼ، ܠܢܝܵܚܬܵܟ݂ܝ، ܣܵܒܵܒ ܡܵܪܝܵܐ ܦܪܝܼܥ ܠܹܗ ܐܸܠܵܟ݂ܝ ܒܦܸܪܝܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","ܣܵܒܵܒ ܦܘܼܨܹܐ ܠܘܼܟ݂ ܓܵܢܝܼ ܡ̣ܢ ܡܵܘܬܵ‌ܐ، ܥܲܝܢܝܼ ܡ̣ܢ ܕܸܡܥܝܼܬܵ‌ܐ، ܐܲܩܠܝܼ ܡ̣ܢ ܬܲܪܩܲܠܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","ܒܸܬ ܚܵܕܪܹܢ ܩܲܕܡ ܡܵܪܝܵܐ ܒܐܲܪ̈ܥܵܬܹ‌ܐ ܕܚܵܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","ܗܘܼܡܸܢܝܼ ܟܲܕ ܗܘܼܡܙܸܡ ܠܝܼ: ”ܐܵܢܵܐ ܦܝܼܫ ܠܝܼ ܡܘܼܠܝܸܨܵܐ ܪܵܒܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","ܐܵܢܵܐ ܐܡܝܼܪܝܼ ܓܵܘ ܡܲܠܝܲܙܬ‌ܝܼ: ”ܟܠܔ ܒܲܪܢܵܫܵܐ ܕܲܓܵܠܵܐ ܝܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","ܡܘܼܕܝܼ ܡܲܕܸܪܸܢ ܠܡܵܪܝܵܐ، ܒܘܼܬ ܟܠܹܗ ܦܘܼܪܥܵܢܹܗ ܐܸܠܝܼ؟ ");
INSERT INTO aii_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","ܟܵܣܵܐ ܕܦܘܼܪ̈ܩܵܢܹܐ ܒܸܬ ܡܲܪܡܸܢ، ܘܒܫܸܡܵܐ ܕܡܵܪܝܵܐ ܒܸܬ ܩܵܪܹܝܢ. ");
INSERT INTO aii_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","ܢܸܕܪ̈ܝܼ ܠܡܵܪܝܵܐ ܒܸܬ ܬܲܡܸܡܸܢ ܩܲܕܡ ܦܵܬܵ‌ܐ ܕܟܠܹܗ ܥܲܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","ܝܲܩܝܼܪܵܐ ܝܠܹܗ ܒܥܲܝ̈ܢܹܐ ܕܡܵܪܝܵܐ ܡܵܘܬܵ‌ܐ ܕܙܲܕܝܼܩܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","ܐܘܿܗ، ܝܵܐ ܡܵܪܝܵܐ، ܗܹܐ، ܐܵܢܵܐ ܪܹܓܘܼܟ݂ ܝܼܘܸܢ، ܪܹܓܘܼܟ݂ ܒܪܘܿܢܵܐ ܕܚܸܕܲܡܬܘܼܟ݂، ܩܵܡ ܫܵܪܹܝܬ ܠܗܘܿܢ ܐܸܣܘܼܪ̈ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","ܐܸܠܘܼܟ݂ ܒܸܬ ܕܵܒ݂ܚܹܢ ܕܸܒ݂ܚܵܐ ܕܫܲܟܲܪܬܵ‌ܐ، ܘܒܫܸܡܵܐ ܕܡܵܪܝܵܐ ܒܸܬ ܩܵܪܹܝܢ. ");
INSERT INTO aii_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","ܢܸܕܪ̈ܝܼ ܠܡܵܪܝܵܐ ܒܸܬ ܬܲܡܸܡܸܢ ܩܲܕܡ ܦܵܬܵ‌ܐ ܕܟܠܹܗ ܥܲܡܹܗ، ");
INSERT INTO aii_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","ܓܵܘ ܕܵܪ̈ܵܬܹ‌ܐ ܕܒܲܝܬܵ‌ܐ ܕܡܵܪܝܵܐ، ܒܓܵܘܵܟ݂ܝ، ܝܵܐ ܐܘܿܪܸܫܠܸܡ. ܗܲܠܸܠܘܼܝܵܐ ");
INSERT INTO aii_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","ܫܲܒܚܘܼܢ ܠܡܵܪܝܵܐ ܟܠܵܝܗ‌ܝ ܐܸܡܘܵܬܹ̈‌ܐ، ܫܲܒܚܘܼܢ ܠܹܗ ܟܠܵܝܗ‌ܝ ܥܲܡܡܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","ܣܵܒܵܒ ܓܘܼܪܘܸܣ ܠܵܗ̇ ܥܲܠܲܢ ܛܲܝܒܘܼܬܹܗ، ܘܫܲܪܝܼܪܘܼܬܵ‌ܐ ܕܡܵܪܝܵܐ ܠܥܵܠܲܡ ܝܠܵܗ̇. ܗܲܠܸܠܘܼܝܵܐ ");
INSERT INTO aii_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","ܫܲܟܪܘܼܢ ܠܡܵܪܝܵܐ ܣܵܒܵܒ ܛܵܒ݂ܵܐ ܝܠܹܗ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","ܐܵܡܹܪ ܐܝܼܣܪܵܐܹܝܠܔ: ”ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","ܐܵܡܪܝܼ ܒܹܝܬ ܐܲܗܪܘܿܢ: ”ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","ܐܵܡܪܝܼ ܙܕܝܼ̈ܥܹܐ ܕܡܵܪܝܵܐ: ”ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","ܡ̣ܢ ܐܘܼܠܨܵܢܝܼ ܩܪܹܐ ܠܝܼ ܠܡܵܪܝܵܐ، ܩܵܡ ܓ̰ܲܘܸܒ ܠܝܼ ܘܡܲܬܸܒ݂ ܠܝܼ ܒܪܘܵܚܵܢܝܼ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","ܡܵܪܝܵܐ ܥܲܡܝܼ ܝܠܹܗ، ܠܹܐ ܙܵܕܥܹܢ؛ ܡܘܼܕܝܼ ܡܵܨܹܐ ܥܵܒܹܕ ܐܸܠܝܼ ܒܲܪܢܵܫܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","ܡܵܪܝܵܐ ܥܲܡܝܼ ܝܠܹܗ ܠܗܲܝܘܼܪܝܼ، ܘܐܵܢܵܐ ܒܸܬ ܚܵܙܹܝܢ ܙܵܟ݂ܘܼܬܵ‌ܐ ܠܣܵܢܝܵܢܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","ܒܘܼܫ ܨܦܵܝܝܼ ܝܠܵܗ̇ ܠܸܫܩܵܠܵܐ ܓܵܘܣܵܐ ܒܡܵܪܝܵܐ، ܡ̣ܢ ܠܸܣܒܵܪܵܐ ܒܒܲܪܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","ܒܘܼܫ ܨܦܵܝܝܼ ܝܠܵܗ̇ ܠܸܫܩܵܠܵܐ ܓܵܘܣܵܐ ܒܡܵܪܝܵܐ، ܡ̣ܢ ܠܸܣܒܵܪܵܐ ܒܢܲܨܝܼܚܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","ܟܠܵܝܗ‌ܝ ܐܸܡܘܵܬܹ̈‌ܐ ܟܪܝܼܟܸܢܗܘܿܢ، ܒܫܸܡܵܐ ܕܡܵܪܝܵܐ ܒܸܬ ܩܵܛܥܹܢܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","ܩܵܡ ܟܵܪܟ݂ܝܼ ܠܝܼ، ܗܹܐ، ܟܪܝܼܟܸܢܗܘܿܢ، ܒܫܸܡܵܐ ܕܡܵܪܝܵܐ ܒܸܬ ܩܵܛܥܹܢܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","ܩܵܡ ܟܵܪܟ݂ܝܼ ܠܝܼ ܐܲܝܟ݂ ܕܵܒܵܫܹ̈ܐ، ܐܝܼܢܵܐ ܟ̰ܡܝܼܥ ܠܗܘܿܢ ܐܲܝܟ݂ ܢܘܼܪܵܐ ܕܟܸܬܘܹ̈ܐ، ܒܫܸܡܵܐ ܕܡܵܪܝܵܐ ܒܸܬ ܩܵܛܥܹܢܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","ܚܲܪܙܘܼܦܹܐ ܩܵܡ ܚܲܪܙܸܦܸܬ ܠܝܼ ܕܢܵܦܠܹܢ، ܐܝܼܢܵܐ ܡܵܪܝܵܐ ܗܘܼܝܸܪܹܗ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","ܥܘܼܫܢܝܼ ܘܙܡܵܪܬ‌ܝܼ ܡܵܪܝܵܐ ܝܠܹܗ، ܘܗܘܹܐ ܠܹܗ ܐܸܠܝܼ ܦܘܼܪܩܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","ܩܵܠܵܐ ܕܫܘܼܒ݂ܚܵܐ ܘܕܦܘܼܪܩܵܢܵܐ ܓܵܘ ܡܲܫܟܢܹ̈ܐ ܕܙܲܕܝܼܩܹ̈ܐ، ܝܲܡܝܼܢܵܐ ܕܡܵܪܝܵܐ ܥܵܒ݂ܕܵܢܬܵ‌ܐ ܕܚܲܝܠܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","ܝܲܡܝܼܢܵܐ ܕܡܵܪܝܵܐ ܪܝܼܡܬܵ‌ܐ ܝܠܵܗ̇، ܝܲܡܝܼܢܵܐ ܕܡܵܪܝܵܐ ܥܵܒ݂ܕܵܢܬܵ‌ܐ ܕܚܲܝܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","ܠܹܐ ܡܵܝܬܹܢ ܐܸܠܵܐ ܒܸܬ ܚܵܝܹܝܢ، ܘܒܸܬ ܗܲܩܹܝܢ ܥܒ݂ܵܕܹ̈ܐ ܕܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","ܬܲܥܠܘܼܡܹܐ ܬܘܼܥܠܡܸܢܹܗ ܡܵܪܝܵܐ، ܐܝܼܢܵܐ ܠܡܵܘܬܵ‌ܐ ܠܵܐ ܣܘܼܦܝܸܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","ܦܬܘܿܚܘܼܢ ܐܸܠܝܼ ܕܲܪ̈ܘܵܙܹܐ ܕܙܲܕܝܼܩܘܼܬܵ‌ܐ، ܕܥܵܒ݂ܪܹܢ ܒܝܼܵܝܗ‌ܝ ܘܫܲܟܪܸܢ ܠܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","ܐܵܗܵܐ ܝܠܹܗ ܕܲܪܘܵܙܵܐ ܕܡܵܪܝܵܐ، ܙܲܕܝܼܩܹ̈ܐ ܒܸܬ ܥܵܒ݂ܪܝܼ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","ܒܸܬ ܫܲܟܪܸܢܘܼܟ݂ ܕܩܵܡ ܓ̰ܲܘܸܒܸܬ ܠܝܼ، ܘܗܘܹܐ ܠܘܼܟ݂ ܐܸܠܝܼ ܦܘܼܪܩܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","ܟܹܐܦܵܐ ܕܡܘܼܣܠܹܐ ܠܗܘܿܢ ܒܲܢܵܝܹ̈ܐ ܗܘܹܐ ܠܹܗ ܠܪܹܝܫܵܐ ܕܩܘܼܪܢܝܼܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","ܡ̣ܢ ܠܟܸܣ ܡܵܪܝܵܐ ܗܘܹܐ ܠܵܗ̇ ܐܵܗܵܐ، ܗ̇ܝ ܥܘܼܓ̰ܵܒܵܐ ܝܠܵܗ̇ ܒܥܲܝܢܲܢ̈. ");
INSERT INTO aii_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","ܐܵܗܵܐ ܝܠܹܗ ܝܵܘܡܵܐ ܕܥܒ݂ܝܼܕ ܠܹܗ ܡܵܪܝܵܐ، ܦܵܨܚܲܚ ܘܚܵܕܲܚ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","ܦܲܪܦܘܼܠܹܐ ܝܘܲܚ، ܝܵܐ ܡܵܪܝܵܐ، ܦܲܪܸܩ ܠܲܢ، ܦܲܪܦܘܼܠܹܐ ܝܘܲܚ، ܝܵܐ ܡܵܪܝܵܐ، ܡܲܢܬ‌ܝܼ ܠܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","ܒܪܝܼܟ݂ܵܐ ܝܠܹܗ ܗ̇ܘ ܕܒܹܐܬܵܝܵܐ ܝܠܹܗ ܒܫܸܡܵܐ ܕܡܵܪܝܵܐ، ܩܵܡ ܒܲܪܟܲܚ ܠܵܘܟ݂ܘܿܢ ܡ̣ܢ ܒܲܝܬܵ‌ܐ ܕܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","ܐܲܠܵܗܵܐ ܡܵܪܝܵܐ ܝܠܹܗ، ܘܒܘܼܗܪܸܢܹܗ ܐܸܠܲܢ، ܐܣܘܿܪܘܼܢ ܙܵܘܚܵܐ ܒܝܲܕ ܦܲܥܘܵܢܹ̈ܐ ܗܲܠܔ ܩܲܪ̈݇ܢܵܢܹܐ ܕܡܲܕܒܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","ܐܲܠܵܗ‌ܝܼ ܝܘܸܬ ܐܲܢ݇ܬ، ܘܒܸܬ ܫܲܟܪܸܢܘܼܟ݂، ܐܲܠܵܗ‌ܝܼ ܝܘܸܬ ܐܲܢ݇ܬ، ܘܒܸܬ ܡܲܪܡܸܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","ܫܲܟܪܘܼܢ ܠܡܵܪܝܵܐ ܣܵܒܵܒ ܛܵܒ݂ܵܐ ܝܠܹܗ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","ܛܘܼܒ݂ܵܐ ܠܬܲܡܝܼܡܹ̈ܐ ܒܐܘܼܪܚܵܝܗ‌ܝ، ܕܟܹܐ ܚܵܕܪܝܼ ܒܢܵܡܘܿܣܵܐ ܕܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","ܛܘܼܒ݂ܵܐ ܠܢܵܛܪ̈ܵܢܹܐ ܕܣܵܗܕܘܵܬܘܼ̈ܗ‌ܝ، ܕܒܟܠܹܗ ܠܸܒܵܐ ܟܹܐ ܛܵܥܝܼ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","ܐܘܼܦ ܠܹܐ ܦܵܠܚܝܼ ܥܵܘܠܵܐ، ܒܐܘܼܪ̈ܚܵܬܘܼܗ‌ܝ ܟܹܐ ܚܵܕܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","ܐܲܢ݇ܬ ܦܘܼܩܸܕ ܠܘܼܟ݂ ܦܘܼܩܵܕܘܼ̈ܟ݂، ܕܦܵܝܫܝܼ ܢܛܝܼܪܹܐ ܚܦܝܼܛܵܐܝܼܬ. ");
INSERT INTO aii_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","ܛܘܼܒ݂ܵܐ ܕܗܵܘܝܼ ܡܩܵܘܝܵܢܹ̈ܐ ܐܘܼܪ̈ܚܵܬ‌ܝܼ، ܠܸܢܛܵܪܵܐ ܩܵܢܘܿܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","ܗ̇ܝܓܵܗ ܠܹܐ ܢܵܟ݂ܦܹܢ، ܟܲܕ ܚܵܝܪܹܢ ܠܟܠܵܝܗ‌ܝ ܦܘܼܩܕܵܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","ܒܸܬ ܫܲܟܪܸܢܘܼܟ݂ ܒܬܪܘܼܨܘܼܬܵ‌ܐ ܕܠܸܒܵܐ، ܟܲܕ ܝܵܠܦܹܢ ܕܝܼܘܵܢܹ̈ܐ ܕܙܲܕܝܼܩܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","ܩܵܢܘܿܢܘܼ̈ܟ݂ ܒܸܬ ܢܵܛܪܹܢ، ܫܒ݂ܵܩܵܐ ܠܵܐ ܫܵܒ݂ܩܹܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","ܒܡܘܼܕܝܼ ܡܵܨܹܐ ܕܲܟܹܐ ܠܵܗ̇ ܥܠܲܝܡܵܐ ܐܘܼܪܚܹܗ؟ ܒܢܛܵܪܬܘܼܗ̇ ܐܲܝܟ݂ ܚܲܒܪܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","ܒܟܠܹܗ ܠܸܒܝܼ ܛܥܹܐ ܠܝܼ ܐܸܠܘܼܟ݂، ܠܵܐ ܫܵܒ݂ܩܹܬ ܚܵܠܛܹܢ ܡ̣ܢ ܦܘܼܩܕܵܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","ܓܵܘ ܠܸܒܝܼ ܛܘܼܫܝܵܐ ܠܝܼ ܗܹܡܸܙܡܵܢܘܼܟ݂، ܩܵܐ ܕܠܵܐ ܚܵܛܹܝܢ ܥܲܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","ܒܪܝܼܟ݂ܵܐ ܝܘܸܬ، ܝܵܐ ܡܵܪܝܵܐ، ܡܲܠܸܦ ܠܝܼ ܩܵܢܘܿܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","ܒܣܸܦܘܵܬ‌ܝܼ̈ ܗܘܼܩܹܐ ܠܝܼ ܟܠܵܝܗ‌ܝ ܕܝܼܘܵܢܹ̈ܐ ܕܦܘܼܡܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","ܒܐܘܼܪܚܵܐ ܕܣܵܗܕܘܵܬܘܼ̈ܟ݂ ܦܨܝܼܚ ܠܝܼ، ܗܲܪ ܐܲܝܟ݂ ܕܒܟܠܹܗ ܥܘܼܬܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","ܠܦܘܼܩܵܕܘܼ̈ܟ݂ ܒܸܬ ܗܲܓܹܝܢ، ܘܠܐܘܼܪ̈ܚܵܬܘܼܟ݂ ܒܸܬ ܚܵܝܪܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","ܒܩܵܢܘܿܢܘܼ̈ܟ݂ ܒܸܬ ܡܲܒܣܸܡܸܢܵܗ̇ ܓܵܢܝܼ، ܠܹܐ ܢܵܫܹܝܢ ܠܚܲܒܪܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","ܥܒ݂ܘܿܕ ܛܵܒ݂ܬܵ‌ܐ ܠܪܹܓܘܼܟ݂ ܕܚܵܝܹܝܢ، ܘܢܵܛܪܹܢܗܘܿܢ ܗܹܡܸܙܡܵܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","ܓܲܠܝܼ ܠܗܘܿܢ ܥܲܝܢܝܼ̈ ܕܚܵܙܹܝܢ ܕܘܼܡܵܪܹ̈ܐ ܡ̣ܢ ܢܵܡܘܿܣܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","ܡܵܫܵܚܲܛ ܝܼܘܸܢ ܐܵܢܵܐ ܒܐܲܪܥܵܐ، ܠܵܐ ܛܲܫܹܝܬ ܡܸܢܝܼ ܦܘܼܩܕܵܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","ܓܪܝܼܣܬܵ‌ܐ ܝܠܵܗ̇ ܓܵܢܝܼ ܒܪܲܚܪܲܚܬܵ‌ܐ ܠܕܝܼܘܵܢܘܼ̈ܟ݂ ܒܟܠܔ ܙܲܒ݂ܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","ܢܓ̰ܝܼܘ ܠܘܼܟ݂ ܒܚܵܬܪ̈ܵܢܹܐ، ܒܠܝܼܛܹ̈ܐ، ܐܲܝܢܝܼ ܕܚܵܠܛܝܼ ܡ̣ܢ ܦܘܼܩܕܵܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","ܡܲܥܒܸܪ ܡܥܲܠܝܼ ܠܵܘܡܵܐ ܘܡܲܣܠܲܝܬܵ‌ܐ، ܒܗ̇ܝ ܕܢܛܝܼܪܵܐ ܝܘܸܢ ܠܣܵܗܕܘܵܬܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","ܐܘܼܦ ܝܬܝܼܒ݂ ܠܗܘܿܢ ܓܘܼܪ̈ܵܢܹܐ ܘܗܘܼܡܙܸܡ ܠܗܘܿܢ ܕܲܠܩܘܼܒ݂ܠܝܼ، ܐܝܼܢܵܐ ܪܹܓܘܼܟ݂ ܗܘܼܓܹܐ ܠܹܗ ܩܵܢܘܿܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","ܐܘܼܦ ܣܵܗܕܘܵܬܘܼ̈ܟ݂ ܒܲܣܝܼܡܘܼܬ‌ܝܼ ܝܢܵܐ، ܡܵܠܘܿܟܹ̈ܐ ܝܢܵܐ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","ܬܒܝܼܥ ܠܵܗ̇ ܠܥܲܦܪܵܐ ܓܵܢܝܼ، ܡܲܚܝܼ ܠܝܼ ܐܲܝܟ݂ ܚܲܒܪܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","ܗܘܼܩܹܐ ܠܝܼ ܐܸܠܘܼܟ݂ ܐܘܼܪ̈ܚܵܬ‌ܝܼ ܘܩܵܡ ܓ̰ܲܘܸܒܸܬ ܠܝܼ، ܡܲܠܸܦ ܠܝܼ ܩܵܢܘܿܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","ܐܘܼܪܚܵܐ ܕܦܘܼܩܵܕܘܼ̈ܟ݂ ܡܲܦܪܸܡ ܠܝܼ، ܘܒܸܬ ܗܲܓܹܝܢ ܠܕܘܼܡܵܪ̈ܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","ܡܘܼܥܝܸܩܬܵ‌ܐ ܝܠܵܗ̇ ܓܵܢܝܼ ܡ̣ܢ ܚܲܫܵܐ، ܣܢܘܿܕ ܠܝܼ ܐܲܝܟ݂ ܚܲܒܪܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","ܐܘܼܪܚܵܐ ܕܕܘܼܓܠܵܐ ܡܲܥܒܸܪ ܡܸܢܝܼ، ܘܒܚܢܵܢܵܐ ܡܲܠܸܦ ܠܝܼ ܢܵܡܘܿܣܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","ܐܘܼܪܚܵܐ ܕܫܪܵܪܵܐ ܓܘܼܒܹܐ ܠܝܼ، ܕܝܼܘܵܢܘܼ̈ܟ݂ ܡܘܼܬܸܒ݂ ܠܝܼ ܒܲܠܩܘܼܒ݂ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","ܬܒܝܼܥ ܠܝܼ ܠܣܵܗܕܘܵܬܘܼ̈ܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܠܵܐ ܡܲܢܟܸܦܸܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","ܒܐܘܼܪܚܵܐ ܕܦܘܼܩܕܵܢܘܼ̈ܟ݂ ܒܸܬ ܪܵܚܛܹܢ، ܒܗ̇ܝ ܕܒܸܬ ܡܲܪܘܸܚܸܬ ܠܸܒܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","ܡܲܠܸܦ ܠܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܐܘܼܪܚܵܐ ܕܩܵܢܘܿܢܘܼ̈ܟ݂، ܘܒܸܬ ܢܵܛܪܹܢܵܗ̇ ܗܲܠܔ ܚܲܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","ܡܲܦܪܸܡ ܠܝܼ ܕܢܵܛܪܹܢ ܢܵܡܘܿܣܘܼܟ݂، ܘܒܸܬ ܢܵܛܪܹܢܹܗ ܒܟܠܹܗ ܠܸܒܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","ܡܲܚܕܸܪܝܼ ܒܫܒ݂ܝܼܠܵܐ ܕܦܘܼܩܕܵܢܘܼ̈ܟ݂، ܒܗ̇ܝ ܕܒܝܼܹܗ ܒܣܝܼܡ ܠܵܗ̇ ܓܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","ܡܲܦܬܸܠܔ ܠܸܒܝܼ ܠܣܵܗܕܘܵܬܘܼ̈ܟ݂، ܘܠܵܐ ܠܩܢܵܝܬܵ‌ܐ ܛܲܢܦܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","ܡܲܥܒܸܪ ܥܲܝܢܝܼ̈ ܡ̣ܢ ܠܸܚܙܵܝܵܐ ܣܪܝܼܩܘܼܬܵ‌ܐ، ܒܐܘܼܪܚܘܼܟ݂ ܡܲܚܝܼ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","ܡܲܩܘܝܼ ܗܹܡܸܙܡܵܢܘܼܟ݂ ܠܪܹܓܘܼܟ݂، ܗ̇ܝ ܕܝܼܠܵܗ̇ ܕܙܵܕܹܥ ܡܸܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","ܡܲܥܒܸܪ ܡܸܢܝܼ ܠܵܘܡܝܼ ܕܟܹܐ ܙܵܕܥܹܢ ܡܸܢܹܗ، ܒܗ̇ܝ ܕܕܝܼܘܵܢܘܼ̈ܟ݂ ܛܵܒܹ̈ܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","ܗܵܐ، ܪܘܼܚܪܸܚ ܠܝܼ ܠܦܘܼܩܵܕܘܼ̈ܟ݂، ܒܙܲܕܝܼܩܘܼܬܘܼܟ݂ ܡܲܚܝܼ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","ܘܐܵܬܝܵܐ ܥܲܠܝܼ ܛܲܝܒܘܼܬܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܘܦܘܼܪܩܵܢܘܼܟ݂، ܐܲܝܟ݂ ܩܵܘܠܘܼܟ݂، ");
INSERT INTO aii_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","ܗܵܕܟ݂ܵܐ ܕܝܵܗܒܹܢ ܓ̰ܘܼܘܵܒ ܠܠܵܝܡܵܢܝܼ، ܒܗ̇ܝ ܕܣܒܝܼܪܝܼ ܒܚܲܒܪܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","ܘܠܵܐ ܫܵܩܠܹܬ ܡ̣ܢ ܦܘܼܡܝܼ ܗܹܡܸܙܡܵܢ ܕܫܪܵܪܵܐ، ܣܵܒܵܒ ܠܕܝܼܘܵܢܘܼ̈ܟ݂ ܣܦܝܼܪܝܼ، ");
INSERT INTO aii_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","ܘܒܸܬ ܢܵܛܪܹܢ ܢܵܡܘܿܣܘܼܟ݂ ܐܲܡܝܼܢܵܐܝܼܬ، ܠܥܵܠܲܡ ܥܵܠܡܝܼܢ، ");
INSERT INTO aii_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","ܘܒܸܬ ܚܵܕܪܹܢ ܒܪܘܵܚܵܢܝܼ، ܒܗ̇ܝ ܕܠܦܘܼܩܵܕܘܼ̈ܟ݂ ܛܥܹܐ ܠܝܼ، ");
INSERT INTO aii_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","ܘܒܸܬ ܗܲܡܙܸܡܸܢ ܒܘܼܬ ܣܵܗܕܘܵܬܘܼ̈ܟ݂ ܩܲܕܡ ܡܲܠܟܹ̈ܐ، ܘܠܹܐ ܢܵܟ݂ܦܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","ܘܒܸܬ ܩܲܒܠܸܢ ܒܘܼܣܵܡܵܐ ܒܦܘܼܩܕܵܢܘܼ̈ܟ݂ ܕܡܘܼܚܸܒܵܝ ܠܝܼ، ");
INSERT INTO aii_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","ܘܒܸܬ ܡܲܪܡܸܢ ܐܝܼܕܵܬ‌ܝܼ̈ ܠܦܘܼܩܕܵܢܘܼ̈ܟ݂ ܕܡܘܼܚܸܒܵܝ ܠܝܼ، ܘܒܸܬ ܗܲܓܹܝܢ ܩܵܢܘܿܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","ܕܟ݂ܘܿܪܹܗ ܚܲܒܪܘܼܟ݂ ܠܪܹܓܘܼܟ݂، ܗ̇ܘ ܕܒܝܼܹܗ ܩܵܡ ܥܵܒ݂ܕܹܬ ܕܣܵܒܪܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","ܐܵܗܵܐ ܝܠܵܗ̇ ܝܵܗܒ݂ܵܠܬܵ‌ܐ ܕܠܸܒܵܐ ܐܸܠܝܼ ܓܵܘ ܐܘܼܠܨܵܢܝܼ، ܣܵܒܵܒ ܗܹܡܸܙܡܵܢܘܼܟ݂ ܩܵܡ ܡܲܚܝܼܵܐ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","ܚܵܬܪ̈ܵܢܹܐ ܡܘܼܣܚܸܪܗܘܿܢ ܟ̰ܸܡ ܪܵܒܵܐ ܒܝܼܝܼ، ܘܡ̣ܢ ܢܵܡܘܿܣܘܼܟ݂ ܠܵܐ ܩܠܝܼܒ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","ܕܟ݂ܝܼܪܝܼ ܕܝܼܘܵܢܘܼ̈ܟ݂ ܡ̣ܢ ܥܵܠܲܡ، ܝܵܐ ܡܵܪܝܵܐ، ܘܦܝܼܫ ܠܝܼ ܝܘܼܗܒ݂ܵܐ ܠܸܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","ܚܸܡܬܵ‌ܐ ܩܵܡ ܕܵܒ݂ܩܵܐ ܠܝܼ ܡ̣ܢ ܥܸܠܬܵ‌ܐ ܕܪ̈ܲܫܝܼܥܹܐ ܫܵܒ݂ܩܵܢܹ̈ܐ ܕܢܵܡܘܿܣܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","ܩܵܢܘܿܢܘܼ̈ܟ݂ ܗܘܹܐ ܠܗܘܿܢ ܙܡܝܼܪ̈ܵܬܹ‌ܐ ܐܸܠܝܼ، ܓܵܘ ܒܲܝܬܵ‌ܐ ܕܬܵܘܬܵܒ݂ܘܼܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","ܕܟ݂ܝܼܪܝܼ ܒܠܲܝܠܹܐ ܫܸܡܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܘܢܛܝܼܪܝܼ ܢܵܡܘܿܣܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","ܐܵܗܵܐ ܗܘܹܐ ܠܵܗ̇ ܥܝܵܕܵܐ ܐܸܠܝܼ، ܒܗ̇ܝ ܕܢܛܝܼܪܝܼ ܦܘܼܩܵܕܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","ܡܵܪܝܵܐ ܝܼܠܹܗ ܣܵܗܡܵܐ ܐܸܠܝܼ، ܐܡܝܼܪܝܼ ܕܒܸܬ ܢܵܛܪܹܢ ܗܹܡܸܙܡܵܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","ܦܘܼܪܦܸܠܔ ܠܝܼ ܒܝܼܘܼܟ݂ ܒܟܠܹܗ ܠܸܒܝܼ، ܗܘܝܼ ܚܲܢܵܢܵܐ ܐܸܠܝܼ ܐܲܝܟ݂ ܩܵܘܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","ܬܘܼܚܡܸܢܝܼ ܒܘܼܬ ܐܘܼܪ̈ܚܵܬ‌ܝܼ، ܘܡܘܼܕܸܪܵܝ ܠܝܼ ܐܲܩܠܝܼ̈ ܠܣܵܗܕܘܵܬܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","ܡܘܼܠܝܸܙ ܠܝܼ ܘܠܵܐ ܥܘܼܪܩܸܠܔ ܠܝܼ، ܠܸܢܛܵܪܵܐ ܦܘܼܩܕܵܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","ܚܲܒ݂ܠܹ̈ܐ ܕܪ̈ܲܫܝܼܥܹܐ ܩܵܡ ܚܲܪܕܝܼ ܠܝܼ، ܐܝܼܢܵܐ ܢܵܡܘܿܣܘܼܟ݂ ܠܵܐ ܡܘܼܢܫܹܐ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","ܒܦܲܠܓܵܐ ܕܠܲܝܠܹܐ ܒܸܬ ܩܵܝܡܹܢ ܠܫܲܟܘܼܪܘܼܟ݂ ܒܘܼܬ ܕܝܼܘܵܢܹ̈ܐ ܕܙܲܕܝܼܩܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","ܚܲܒ݂ܪܵܐ ܝܘܸܢ ܐܵܢܵܐ ܠܟܠܵܝܗ‌ܝ ܙܕܝܼܥܘܼ̈ܟ݂، ܘܠܢܵܛܪ̈ܵܢܹܐ ܕܦܘܼܩܵܕܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","ܛܲܝܒܘܼܬܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܡܠܹܐ ܠܵܗ̇ ܠܐܲܪܥܵܐ، ܡܲܠܸܦ ܠܝܼ ܩܵܢܘܿܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","ܛܵܒ݂ܬܵ‌ܐ ܥܒ݂ܝܼܕܵܐ ܝܘܸܬ ܥܲܡ ܪܹܓܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܐܲܝܟ݂ ܚܲܒܪܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","ܦܲܪܡܲܝܬܵ‌ܐ ܨܦܵܝܝܼ ܘܝܕܵܥܬܵ‌ܐ ܡܲܠܸܦ ܠܝܼ، ܒܗ̇ܝ ܕܒܦܘܼܩܕܵܢܘܼ̈ܟ݂ ܗܘܼܡܸܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","ܡ̣ܢ ܩܲܕܡ ܕܦܵܝܫܹܢ ܗܘܵܐ ܡܘܼܠܝܸܨܵܐ ܒܸܚܠܵܛܵܐ ܝܘܸܢ ܗܘܵܐ، ܐܝܼܢܵܐ ܐܵܕܝܼܵܐ ܗܹܡܸܙܡܵܢܘܼ̈ܟ݂ ܒܸܢܛܵܪܵܝ ܝܘܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","ܛܵܒ݂ܵܐ ܝܘܸܬ ܐܲܢ݇ܬ ܘܥܵܒ݂ܕܵܢܵܐ ܕܛܵܒ݂ܬܵ‌ܐ، ܡܲܠܸܦ ܠܝܼ ܩܵܢܘܿܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","ܗܘܼܡܙܸܡ ܠܗܘܿܢ ܒܘܼܚܬܵܢ ܥܲܠܝܼ ܚܵܬܪ̈ܵܢܹܐ، ܐܝܼܢܵܐ ܐܵܢܵܐ ܒܟܠܹܗ ܠܸܒܝܼ ܒܸܬ ܢܵܛܪܹܢ ܦܘܼܩܵܕܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","ܛܪܝܼܨ ܠܹܗ ܐܲܝܟ݂ ܬܲܪܒܵܐ ܠܸܒܵܝܗ‌ܝ، ܐܝܼܢܵܐ ܐܵܢܵܐ ܒܢܵܡܘܿܣܘܼܟ݂ ܒܣܝܼܡ ܠܵܗ̇ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","ܨܦܵܝܝܼ ܝܠܵܗ̇ ܩܵܬ‌ܝܼ ܕܦܝܼܫ ܠܝܼ ܡܘܼܠܝܸܨܵܐ، ܩܵܐ ܕܝܵܠܦܹܢ ܩܵܢܘܿܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","ܒܘܼܫ ܨܦܵܝܝܼ ܝܠܹܗ ܩܵܬ‌ܝܼ ܢܵܡܘܿܣܵܐ ܕܦܘܼܡܘܼܟ݂، ܡ̣ܢ ܐܲܠܦܹ̈ܐ ܕܕܲܗܒ݂ܵܐ ܘܕܣܹܐܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","ܐܝܼܕܵܬܘܼ̈ܟ݂ ܥܒ݂ܝܼܕ ܠܗܘܿܢ ܘܬܘܼܪܸܨ ܠܗܘܿܢ ܐܸܠܝܼ، ܡܲܦܪܸܡ ܠܝܼ ܘܒܸܬ ܝܵܠܦܹܢ ܦܘܼܩܕܵܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","ܙܕܝܼܥܘܼ̈ܟ݂ ܒܸܬ ܚܵܙܝܼ ܠܝܼ ܘܒܸܬ ܚܵܕܝܼ، ܒܗ̇ܝ ܕܒܚܲܒܪܘܼܟ݂ ܣܒܝܼܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","ܟܹܐ ܝܵܕܥܹܢ، ܝܵܐ ܡܵܪܝܵܐ، ܕܙܲܕܝܼܩܘܼܬܵ‌ܐ ܝܢܵܐ ܕܝܼܘܵܢܘܼ̈ܟ݂، ܘܒܡܗܘܼܡܢܘܼܬܘܼܟ݂ ܩܵܡ ܡܲܡܟܸܟܸܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","ܦܲܪܦܘܼܠܹܐ ܝܘܸܢ، ܗܵܘܝܵܐ ܛܲܝܒܘܼܬܘܼܟ݂ ܠܝܼܵܗܒ݂ܝܼ ܠܸܒܵܐ، ܐܲܝܟ݂ ܗܹܡܸܙܡܵܢܘܼܟ݂ ܠܪܹܓܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","ܐܵܬ‌ܝܼ ܥܲܠܝܼ ܪ̈ܲܚܡܘܼܟ݂ ܕܚܵܝܹܝܢ، ܒܗ̇ܝ ܕܢܵܡܘܿܣܘܼܟ݂ ܒܲܣܝܼܡܘܼܬܵ‌ܐ ܝܠܹܗ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","ܢܵܟ݂ܦܝܼ ܚܵܬܪ̈ܵܢܹܐ ܣܵܒܵܒ ܒܒܘܼܚܬܵܢ ܩܵܡ ܙܵܠܡܝܼ ܐܸܠܝܼ، ܐܵܢܵܐ ܒܸܬ ܗܲܓܹܝܢ ܦܘܼܩܵܕܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","ܦܵܬܠܝܼ ܠܟܸܣܠܝܼ ܙܕܝܼܥܘܼ̈ܟ݂، ܘܝܵܕܥܵܢܹ̈ܐ ܕܣܵܗܕܘܵܬܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","ܗܵܘܹܐ ܠܸܒܝܼ ܬܲܡܝܼܡܵܐ ܒܩܵܢܘܿܢܘܼ̈ܟ݂، ܩܵܐ ܕܠܵܐ ܢܵܟ݂ܦܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","ܢܘܝܼܠܔ ܠܵܗ̇ ܓܵܢܝܼ ܩܵܐ ܦܘܼܪܩܵܢܘܼܟ݂، ܠܚܲܒܪܘܼܟ݂ ܣܦܝܼܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","ܚܒܹܐ ܠܗܘܿܢ ܥܲܝܢܝܼ̈ ܒܸܣܦܵܪܵܐ ܠܗܹܡܸܙܡܵܢܘܼܟ݂، ܟܲܕ ܒܹܐܡܵܪܵܐ ܝܘܸܢ: ”ܐܝܼܡܲܢ ܒܸܬ ܝܵܗܒܹܬ ܠܝܼ ܠܸܒܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","ܣܵܒܵܒ ܗܘܹܐ ܠܝܼ ܐܲܝܟ݂ ܡܙܝܼܕܵܐ ܓܵܘ ܬܸܢܵܐ، ܐܝܼܢܵܐ ܩܵܢܘܿܢܘܼ̈ܟ݂ ܠܵܐ ܡܘܼܢܫܹܐ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","ܟܡܵܐ ܝܼܢܵܐ ܝܵܘܡܵܢܹ̈ܐ ܕܪܹܓܘܼܟ݂؟ ܐܝܼܡܲܢ ܒܸܬ ܥܵܒ݂ܕܹܬ ܕܝܼܘܵܢ ܥܲܠܔ ܢܵܦܠܵܢܹ̈ܐ ܒܵܬܪܝܼ؟ ");
INSERT INTO aii_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","ܚܦܝܼܪܗܘܿܢ ܚܵܬܪ̈ܵܢܹܐ ܓܘܼܒܹ̈ܐ ܩܵܬ‌ܝܼ، ܕܠܹܐ ܝܠܵܗ̇ ܡ̣ܢ ܢܵܡܘܿܣܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","ܟܠܵܝܗ‌ܝ ܦܘܼܩܕܵܢܘܼ̈ܟ݂ ܡܗܘܼܡܢܹ̈ܐ ܝܢܵܐ، ܒܠܵܐ ܥܸܠܬܵ‌ܐ ܢܦܝܼܠܔ ܠܗܘܿܢ ܒܵܬܪܝܼ؛ ܗܲܝܸܪܝܼ! ");
INSERT INTO aii_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","ܚܲܕܟ̰ܵܐ ܦܝܼܫ ܠܵܗ̇ ܕܬܵܝܡܝܼ ܗܘܵܘ ܠܝܼ ܒܐܲܪܥܵܐ، ܐܝܼܢܵܐ ܐܵܢܵܐ ܠܵܐ ܫܒ݂ܝܼܩ ܠܝܼ ܦܘܼܩܵܕܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","ܐܲܝܟ݂ ܛܲܝܒܘܼܬܘܼܟ݂ ܡܲܚܝܼ ܠܝܼ، ܕܢܵܛܪܹܢ ܣܵܗܕܘܵܬܹ̈‌ܐ ܕܦܘܼܡܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","ܠܥܵܠܲܡ، ܝܵܐ ܡܵܪܝܵܐ، ܚܲܒܪܘܼܟ݂ ܡܩܵܘܝܵܢܵܐ ܝܠܹܗ ܒܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","ܠܕܵܪܵܐ ܘܕܵܪܵܐ ܡܗܘܼܡܢܘܼܬܘܼܟ݂، ܫܘܼܬܐܸܣܵܐ ܠܘܼܟ݂ ܐܲܪܥܵܐ ܘܒܸܟܠܵܝܵܐ ܝܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","ܒܕܝܼܘܵܢܘܼ̈ܟ݂ ܒܸܟܠܵܝܵܐ ܝܢܵܐ ܐܸܕܝܘܿܡ، ܣܵܒܵܒ ܟܠܵܝܗ‌ܝ ܪܹ̈ܓܵܘܵܬܘܼܟ݂ ܝܼܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","ܐܸܢ ܠܵܐ ܗܵܘܹܐ ܗܘܵܐ ܢܵܡܘܿܣܘܼܟ݂ ܒܲܣܝܼܡܘܼܬ‌ܝܼ، ܒܸܬ ܛܵܠܩܹܢ ܗܘܵܐ ܒܥܵܘܩܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","ܠܥܵܠܲܡ ܠܹܐ ܡܲܢܫܹܝܢ ܦܘܼܩܵܕܘܼ̈ܟ݂، ܣܵܒܵܒ ܒܝܼܵܝܗ‌ܝ ܩܵܡ ܡܲܚܹܝܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","ܕܝܼܘܼܟ݂ ܝܼܘܸܢ ܐܵܢܵܐ، ܦܲܪܸܩ ܠܝܼ، ܣܵܒܵܒ ܠܦܘܼܩܵܕܘܼ̈ܟ݂ ܛܥܹܐ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","ܣܦܝܼܪܗܘܿܢ ܐܸܠܝܼ ܪ̈ܲܫܝܼܥܹܐ ܠܛܲܠܘܼܩܝܼ، ܐܝܼܢܵܐ ܣܵܗܕܘܵܬܘܼ̈ܟ݂ ܒܸܬ ܦܲܪܡܹܝܢ. ");
INSERT INTO aii_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","ܠܟܠܔ ܟܡܝܼܠܘܼܬܵ‌ܐ ܚܙܹܐ ܠܝܼ ܚܘܼܬܵܡܵܐ، ܐܝܼܢܵܐ ܦܘܼܩܕܵܢܘܼܟ݂ ܪܘܝܼܚܵܐ ܝܠܹܗ ܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","ܟܡܵܐ ܟܹܐ ܡܲܚܸܒܸܢ ܠܢܵܡܘܿܣܘܼܟ݂، ܟܠܹܗ ܝܵܘܡܵܐ ܗ̇ܘ ܝܼܠܹܗ ܗܲܓܲܝܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","ܦܘܼܩܕܵܢܘܼ̈ܟ݂ ܩܵܡ ܥܵܒ݂ܕܝܼ ܠܝܼ ܒܘܼܫ ܚܲܟܝܼܡܵܐ ܡ̣ܢ ܕܸܫ̃ܡܸܢܝܼ̈، ܣܵܒܵܒ ܠܟܸܣܠܝܼ ܝܢܵܐ ܗܲܠܔ ܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","ܗܘܹܐ ܠܝܼ ܒܘܼܫ ܚܲܟܝܼܡܵܐ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܡܲܠܦܵܢܝܼ̈، ܣܵܒܵܒ ܣܵܗܕܘܵܬܘܼ̈ܟ݂ ܗܲܓܲܝܬܵ‌ܐ ܝܢܵܐ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܚܘܵܪ̈ܕܸܩܢܹܐ ܟܹܐ ܦܲܪܡܹܝܢ، ܣܵܒܵܒ ܦܘܼܩܵܕܘܼ̈ܟ݂ ܢܛܝܼܪܵܝ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","ܡ̣ܢ ܟܠܔ ܐܘܼܪܚܵܐ ܒܝܼܫܬܵ‌ܐ ܡܘܼܟܠܹܐ ܠܝܼ ܐܲܩܠܝܼ̈، ܩܵܐ ܕܢܵܛܪܹܢ ܚܲܒܪܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","ܡ̣ܢ ܕܝܼܘܵܢܘܼܟ݂ ܠܵܐ ܩܠܝܼܒ ܠܝܼ، ܣܵܒܵܒ ܐܲܢ݇ܬ ܩܵܡ ܡܲܠܦܸܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","ܟܡܵܐ ܚܸܠܝܹ̈ܐ ܝܢܵܐ ܠܫܵܡܵܟܝܼ̈ ܗܹܡܸܙܡܵܢܘܼ̈ܟ݂، ܒܘܼܫ ܚܸܠܝܹ̈ܐ ܡ̣ܢ ܕܸܒ݂ܫܵܐ ܠܦܘܼܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","ܡ̣ܢ ܦܘܼܩܵܕܘܼ̈ܟ݂ ܟܹܐ ܫܵܩܠܹܢ ܦܲܪܡܲܝܬܵ‌ܐ، ܒܘܼܬ ܐܵܗܵܐ، ܣܢܹܐ ܠܝܼ ܟܠܔ ܐܘܼܪܚܵܐ ܕܕܘܼܓܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","ܫܪܵܓ݂ܵܐ ܝܠܹܗ ܠܐܲܩܠܝܼ ܚܲܒܪܘܼܟ݂، ܘܒܲܗܪܵܐ ܠܫܒ݂ܝܼܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","ܝܡܹܐ ܠܝܼ ܘܒܸܬ ܡܲܩܘܹܝܢ ܡܵܘܡܝܼܬ‌ܝܼ، ܠܸܢܛܵܪܵܐ ܕܝܼܘܵܢܹ̈ܐ ܕܙܲܕܝܼܩܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","ܦܝܼܫ ܠܝܼ ܡܘܼܠܝܸܨܵܐ ܟ̰ܸܡ ܪܵܒܵܐ، ܝܵܐ ܡܵܪܝܵܐ، ܡܲܚܝܼ ܠܝܼ ܐܲܝܟ݂ ܚܲܒܪܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","ܩܲܒܸܠܔ ܠܗܘܿܢ ܩܘܼܪ̈ܒܵܢܹܐ ܕܨܸܒ݂ܝܵܢܵܐ ܡ̣ܢ ܦܘܼܡܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܘܕܝܼܘܵܢܘܼ̈ܟ݂ ܡܲܠܸܦ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","ܓܵܢܝܼ ܒܩܹܘܲܢܕܹܢܘܿܣ ܝܠܵܗ̇ ܐܲܡܝܼܢܵܐܝܼܬ، ܐܝܼܢܵܐ ܢܵܡܘܿܣܘܼܟ݂ ܠܵܐ ܡܘܼܢܫܹܐ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","ܡܘܼܬܸܒ݂ ܠܗܘܿܢ ܪ̈ܲܫܝܼܥܹܐ ܦܲܚܵܐ ܐܸܠܝܼ، ܐܝܼܢܵܐ ܡ̣ܢ ܦܘܼܩܵܕܘܼ̈ܟ݂ ܠܵܐ ܚܠܝܼܛ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","ܗܘܹܐ ܠܗܘܿܢ ܝܵܪܬܘܼܬܵ‌ܐ ܐܸܠܝܼ ܣܵܗܕܘܵܬܘܼ̈ܟ݂ ܠܥܵܠܲܡ، ܣܵܒܵܒ ܦܨܝܼܚܘܼܬܵ‌ܐ ܕܠܸܒܝܼ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","ܡܘܼܬܸܒ݂ ܠܝܼ ܠܸܒܝܼ ܠܸܥܒ݂ܵܕܵܐ ܩܵܢܘܿܢܘܼ̈ܟ݂، ܠܥܵܠܲܡ، ܗܲܠܔ ܚܲܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","ܠܦܠܝܼܥܵܐ ܒܪܸܥܝܵܢܵܐ ܟܹܐ ܣܵܢܹܝܢ، ܐܝܼܢܵܐ ܠܢܵܡܘܿܣܘܼܟ݂ ܟܹܐ ܡܲܚܸܒܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","ܣܸܬܵܪܝܼ ܘܡܵܛܵܠܝܼ ܐܲܢ݇ܬ ܝܼܘܸܬ، ܠܚܲܒܪܘܼܟ݂ ܟܹܐ ܣܵܦܪܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","ܪܚܘܿܩܘܼܢ ܡܸܢܝܼ، ܝܵܐ ܒܝܼܫܹ̈ܐ، ܕܢܵܛܪܹܢ ܦܘܼܩܕܵܢܹ̈ܐ ܕܐܲܠܵܗ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","ܣܢܘܿܕ ܠܝܼ ܐܲܝܟ݂ ܗܹܡܸܙܡܵܢܘܼܟ݂ ܩܵܐ ܕܚܵܝܹܝܢ، ܘܠܵܐ ܫܵܒ݂ܩܹܬ ܢܵܟ݂ܦܹܢ ܡ̣ܢ ܣܲܒ݂ܪܵܐ ܕܐܝܼܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","ܣܢܘܿܕ ܠܝܼ ܩܵܐ ܕܦܵܝܫܹܢ ܦܘܼܪܩܵܐ، ܘܒܸܬ ܚܵܝܪܹܢ ܒܩܵܢܘܿܢܘܼ̈ܟ݂ ܐܲܡܝܼܢܵܐܝܼܬ. ");
INSERT INTO aii_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","ܡܘܼܣܠܹܐ ܠܘܼܟ݂ ܠܟܠܵܝܗ‌ܝ ܚܵܠܛܵܢܹ̈ܐ ܡ̣ܢ ܩܵܢܘܿܢܘܼ̈ܟ݂، ܣܵܒܵܒ ܣܪܝܼܩܵܐ ܝܠܹܗ ܦܸܠܡܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","ܐܲܝܟ݂ ܚܸܠܬ ܕܣܹܐܡܵܐ ܪܘܼܦܝܵܝ ܠܘܼܟ݂ ܟܠܵܝܗ‌ܝ ܪ̈ܲܫܝܼܥܹܐ ܕܐܲܪܥܵܐ، ܒܘܼܬ ܐܵܗܵܐ، ܟܹܐ ܡܲܚܸܒܸܢ ܠܟܠܵܝܗ‌ܝ ܣܵܗܕܘܵܬܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","ܪܘܼܬܪܸܬ ܠܹܗ ܒܸܣܪܝܼ ܒܥܸܠܬܵ‌ܐ ܕܣܘܼܪܵܕܘܼܟ݂، ܘܡ̣ܢ ܕܝܼܘܵܢܘܼ̈ܟ݂ ܟܹܐ ܙܵܕܥܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","ܥܒ݂ܝܼܕ ܠܝܼ ܕܝܼܘܵܢ ܘܙܲܕܝܼܩܘܼܬܵ‌ܐ، ܠܵܐ ܫܵܒ݂ܩܹܬ ܠܝܼ ܒܐܝܼܕܵܐ ܕܙܵܠܡܵܢܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","ܗܘܝܼ ܥܲܪܵܒ݂ܵܐ ܕܪܹܓܘܼܟ݂ ܠܛܵܒ݂ܬܵ‌ܐ، ܠܵܐ ܫܵܒ݂ܩܹܬ ܙܵܠܡܝܼ ܐܸܠܝܼ ܚܵܬܪ̈ܵܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","ܥܲܝܢܝܼ̈ ܚܒܹܐ ܠܗܘܿܢ ܒܸܣܦܵܪܵܐ ܠܦܘܼܪܩܵܢܘܼܟ݂، ܘܠܗܹܡܸܙܡܵܢ ܕܙܲܕܝܼܩܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","ܥܒ݂ܘܿܕ ܥܲܡ ܪܹܓܘܼܟ݂ ܐܲܝܟ݂ ܛܲܝܒܘܼܬܘܼܟ݂، ܘܩܵܢܘܿܢܘܼ̈ܟ݂ ܡܲܠܸܦ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","ܥܲܒ݂ܕܘܼܟ݂ ܝܼܘܸܢ ܐܵܢܵܐ، ܡܲܦܪܸܡ ܠܝܼ ܕܝܵܕܥܹܢ ܣܵܗܕܘܵܬܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","ܥܕܵܢܵܐ ܝܠܵܗ̇ ܕܥܵܒܹܕ ܚܲܕ ܡܸܢܕܝܼ ܡܵܪܝܵܐ، ܒܗ̇ܝ ܕܒܘܼܛܸܠܔ ܠܗܘܿܢ ܢܵܡܘܿܣܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","ܒܘܼܬ ܐܵܗܵܐ، ܟܹܐ ܡܲܚܸܒܸܢ ܦܘܼܩܕܵܢܘܼ̈ܟ݂، ܒܘܼܫ ܡ̣ܢ ܕܲܗܒ݂ܵܐ، ܘܡ̣ܢ ܕܲܗܒ݂ܵܐ ܨܸܦܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","ܒܘܼܬ ܐܵܗܵܐ، ܟܠܵܝܗ‌ܝ ܦܘܼܩܵܕܹ̈ܐ ܟܹܐ ܢܵܛܪܹܢ ܬܪܘܼܨܵܐܝܼܬ، ܟܠܵܗ̇ ܐܘܼܪܚܵܐ ܕܕܘܼܓܠܵܐ ܣܢܹܐ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","ܥܓ̰ܝܼܒܹ̈ܐ ܝܢܵܐ ܣܵܗܕܘܵܬܘܼ̈ܟ݂، ܒܘܼܬ ܐܵܗܵܐ ܢܛܝܼܪܵܝ ܠܵܗ̇ ܓܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","ܦܬܵܚܬܵ‌ܐ ܕܚܲܒܪܘܼܟ݂ ܟܹܐ ܒܲܗܪܸܢܵܐ، ܟܹܐ ܡܲܦܪܸܡܵܐ ܠܗܘܿܢ ܦܫܝܼ̈ܛܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","ܦܘܼܡܝܼ ܦܬܝܼܚ ܠܝܼ ܘܡܘܼܠܗܸܕ ܠܝܼ، ܣܵܒܵܒ ܠܦܘܼܩܕܵܢܘܼ̈ܟ݂ ܪܘܼܚܪܸܚ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","ܕܘܼܪ ܠܟܸܣܠܝܼ ܘܪܲܚܸܡ ܥܲܠܝܼ، ܐܲܝܟ݂ ܕܝܼܘܵܢܘܼܟ݂ ܠܡܲܚܸܒܵܢܹ̈ܐ ܕܫܸܡܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","ܡܲܩܘܝܼ ܦܵܣܘܿܥܝܵܬ‌ܝܼ̈ ܒܗܹܡܸܙܡܵܢܘܼܟ݂، ܘܠܵܐ ܫܵܒ݂ܩܹܬ ܗܲܟܸܡ ܥܲܠܝܼ ܟܠܔ ܥܵܘܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","ܦܲܪܸܩ ܠܝܼ ܡ̣ܢ ܙܠܘܼܡܝܵܐ ܕܒܲܪܢܵܫܵܐ، ܩܵܐ ܕܢܵܛܪܹܢ ܦܘܼܩܵܕܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","ܒܲܗܪܸܢ ܦܵܬܘܼܟ݂ ܥܲܠܔ ܪܹܓܘܼܟ݂، ܘܡܲܠܸܦ ܠܝܼ ܩܵܢܘܿܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","ܫܵܩ̈ܝܼܵܬܹ‌ܐ ܕܡ̈ܝܼܵܐ ܓ̰ܪܹܐ ܠܗܘܿܢ ܡ̣ܢ ܥܲܝܢܝܼ̈، ܣܵܒܵܒ ܠܵܐ ܢܛܝܼܪܗܘܿܢ ܢܵܡܘܿܣܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","ܙܲܕܝܼܩܵܐ ܝܘܸܬ ܐܲܢ݇ܬ، ܝܵܐ ܡܵܪܝܵܐ، ܘܬܪ̈ܘܼܨܹܐ ܝܢܵܐ ܕܝܼܘܵܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","ܦܩܝܼܕܵܝ ܠܘܼܟ݂ ܣܵܗܕܘܵܬܘܼ̈ܟ݂ ܒܙܲܕܝܼܩܘܼܬܵ‌ܐ، ܘܒܟܠܔ ܡܗܘܼܡܢܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","ܩܵܡ ܐܵܟܹܠܔ ܠܝܼ ܛܢܵܢܝܼ، ܣܵܒܵܒ ܡܘܼܢܫܹܐ ܠܗܘܿܢ ܚܲܒܪ̈ܵܢܘܼܟ݂ ܕܸܫ̃ܡܸܢܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","ܨܘܼܪܸܦܬܵ‌ܐ ܝܠܵܗ̇ ܗܹܡܸܙܡܵܢܘܼܟ݂ ܪܵܒܵܐ، ܘܪܹܓܘܼܟ݂ ܟܹܐ ܡܲܚܸܒ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","ܙܥܘܿܪܵܐ ܝܘܸܢ ܐܵܢܵܐ ܘܡܘܼܣܠܝܼܵܐ، ܐܝܼܢܵܐ ܦܘܼܩܵܕܘܼ̈ܟ݂ ܠܵܐ ܢܸܫܝܵܝ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","ܙܲܕܝܼܩܘܼܬܘܼܟ݂ ܙܲܕܝܼܩܘܼܬܵ‌ܐ ܝܠܵܗ̇ ܠܥܵܠܲܡ، ܘܢܵܡܘܿܣܘܼܟ݂ ܫܪܵܪܵܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","ܥܵܘܩܵܢܵܐ ܘܐܘܼܠܨܵܢܵܐ ܩܵܡ ܡܲܫ݇ܟ̰ܚܝܼ ܠܝܼ، ܐܝܼܢܵܐ ܒܲܣܝܼܡܘܼܬ‌ܝܼ ܝܢܵܐ ܦܘܼܩܕܵܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","ܙܲܕܝܼܩܘܼܬܵ‌ܐ ܝܢܵܐ ܣܵܗܕܘܵܬܘܼ̈ܟ݂ ܠܥܵܠܲܡ، ܗܲܒ݂ܠܔ ܠܝܼ ܦܲܪܡܲܝܬܵ‌ܐ ܕܚܵܝܹܝܢ. ");
INSERT INTO aii_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","ܩܪܹܐ ܠܝܼ ܒܟܠܹܗ ܠܸܒܵܐ؛ ܓ̰ܲܘܸܒ ܠܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܘܩܵܢܘܿܢܘܼ̈ܟ݂ ܒܸܬ ܢܵܛܪܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","ܩܪܹܐ ܠܝܼ ܐܸܠܘܼܟ݂، ܦܲܪܸܩ ܠܝܼ، ܘܒܸܬ ܢܵܛܪܹܢ ܣܵܗܕܘܵܬܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","ܩܕܝܼܡ ܠܝܼ ܓ̰ܲܠܕܹܐ ܒܨܲܦܪܵܐ ܘܓܥܹܐ ܠܝܼ، ܠܚܲܒܪܘܼܟ݂ ܣܦܝܼܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","ܦܬܝܼܚܹܐ ܝܢܵܐ ܥܲܝܢܝܼ̈ ܒܒܲܕ̈ܠܹܐ ܕܠܲܝܠܹܐ، ܠܗܲܓܘܼܝܹܐ ܗܹܡܸܙܡܵܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","ܫܡܹܥ ܩܵܠܝܼ ܐܲܝܟ݂ ܛܲܝܒܘܼܬܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܐܲܝܟ݂ ܕܝܼܘܵܢܘܼܟ݂ ܡܲܚܝܼ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","ܩܘܼܪܒܸܢܗܘܿܢ ܐܸܠܝܼ ܢܵܦܠܵܢܹ̈ܐ ܕܒܵܬܪ ܒܝܼܫܬܵ‌ܐ، ܪܚܝܼܩ ܠܗܘܿܢ ܡ̣ܢ ܢܵܡܘܿܣܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","ܩܘܼܪܒܵܐ ܝܘܸܬ ܐܲܢ݇ܬ، ܝܵܐ ܡܵܪܝܵܐ، ܘܫܪܵܪܵܐ ܝܢܵܐ ܟܠܵܝܗ‌ܝ ܦܘܼܩܕܵܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","ܡ̣ܢ ܓ̰ܲܠܕܹܐ ܝܕܝܼܥ ܠܝܼ ܡ̣ܢ ܣܵܗܕܘܵܬܘܼ̈ܟ݂، ܕܠܥܵܠܲܡ ܫܘܼܬܐܸܣܵܝ ܝܘܸܬ. ");
INSERT INTO aii_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","ܚܙܝܼ ܐܘܼܠܨܵܢܝܼ ܘܦܲܨܝܼ ܠܝܼ، ܣܵܒܵܒ ܢܵܡܘܿܣܘܼܟ݂ ܠܵܐ ܡܘܼܢܫܹܐ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","ܥܒ݂ܘܿܕ ܕܝܼܘܵܢܝܼ ܘܦܲܪܸܩ ܠܝܼ، ܐܲܝܟ݂ ܗܹܡܸܙܡܵܢܘܼܟ݂ ܡܲܚܝܼ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","ܪܸܚܩܵܐ ܝܠܹܗ ܦܘܼܪܩܵܢܵܐ ܡ̣ܢ ܪ̈ܲܫܝܼܥܹܐ، ܣܵܒܵܒ ܠܩܵܢܘܿܢܘܼ̈ܟ݂ ܠܵܐ ܛܥܹܐ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","ܪܵܒܵܐ ܝܢܵܐ ܪ̈ܲܚܡܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܐܲܝܟ݂ ܕܝܼܘܵܢܘܼ̈ܟ݂ ܡܲܚܝܼ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","ܪܵܒܵܐ ܝܢܵܐ ܪ̈ܵܕܘܿܦܝܼ ܘܕܸܫ̃ܡܸܢܝܼ̈، ܐܝܼܢܵܐ ܡ̣ܢ ܣܵܗܕܘܵܬܘܼ̈ܟ݂ ܠܵܐ ܩܠܝܼܒ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","ܚܙܹܐ ܠܝܼ ܚܵܝܝܼܢܹ̈ܐ ܘܓܘܼܢܓܸܙ ܠܝܼ، ܣܵܒܵܒ ܗܹܡܸܙܡܵܢܘܼ̈ܟ݂ ܠܵܐ ܢܛܝܼܪܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","ܚܙܝܼ ܕܵܐܟ݂ܝܼ ܦܘܼܩܵܕܘܼ̈ܟ݂ ܟܹܐ ܡܲܚܸܒܸܢ، ܝܵܐ ܡܵܪܝܵܐ، ܐܲܝܟ݂ ܛܲܝܒܘܼܬܘܼܟ݂ ܡܲܚܝܼ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","ܐܝܼܬܘܼܬܵ‌ܐ ܕܚܲܒܪܘܼܟ݂ ܫܲܪܝܼܪܘܼܬܵ‌ܐ ܝܠܵܗ̇، ܘܠܥܵܠܲܡ ܝܼܢܵܐ ܟܠܵܝܗ‌ܝ ܕܝܼܘܵܢܹ̈ܐ ܕܙܲܕܝܼܩܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","ܓܘܼܪ̈ܵܢܹܐ ܢܦܝܼܠܔ ܠܗܘܿܢ ܒܵܬܪܝܼ ܒܠܵܐ ܥܸܠܬܵ‌ܐ، ܐܝܼܢܵܐ ܡ̣ܢ ܚܲܒܪ̈ܘܼܟ݂ ܟܹܐ ܙܵܕܹܥ ܠܸܒܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","ܒܸܦܨܵܚܵܐ ܝܘܸܢ ܐܵܢܵܐ ܥܲܠܔ ܗܹܡܸܙܡܵܢܘܼܟ݂، ܐܲܝܟ݂ ܗ̇ܘ ܕܡܲܫ݇ܟ̰ܸܚ ܣܠܵܒܬܵ‌ܐ ܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","ܟܹܐ ܣܵܢܹܝܢ ܠܕܘܼܓܠܵܐ ܘܟܹܐ ܓܲܢܓܸܙܸܢ ܡܸܢܹܗ، ܐܝܼܢܵܐ ܢܵܡܘܿܣܘܼܟ݂ ܟܹܐ ܡܲܚܸܒܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","ܫܒܲܥ ܓܵܗܹ̈ܐ ܒܝܵܘܡܵܐ ܟܹܐ ܫܲܒܚܸܢܘܼܟ݂، ܒܘܼܬ ܕܝܼܘܵܢܹ̈ܐ ܕܙܲܕܝܼܩܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","ܫܠܵܡܵܐ ܪܵܒܵܐ ܐܝܼܬ ܠܡܲܚܸܒܵܢܹ̈ܐ ܕܢܵܡܘܿܣܘܼܟ݂، ܘܠܲܝܬ ܐܸܠܵܝܗ‌ܝ ܬܘܼܪܩܵܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","ܣܒܝܼܪܝܼ ܒܦܘܼܪܩܵܢܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܘܦܘܼܩܕܵܢܘܼ̈ܟ݂ ܥܒ݂ܝܼܕ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","ܢܛܝܼܪܵܗ̇ ܓܵܢܝܼ ܣܵܗܕܘܵܬܘܼ̈ܟ݂، ܘܟܹܐ ܡܲܚܸܒܸܢܗܘܿܢ ܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","ܢܛܝܼܪܝܼ ܦܘܼܩܵܕܘܼ̈ܟ݂ ܘܣܵܗܕܘܵܬܘܼ̈ܟ݂، ܣܵܒܵܒ ܟܠܵܝܗ‌ܝ ܐܘܼܪ̈ܚܵܬ‌ܝܼ ܩܲܕܡ ܥܲܝ̈ܢܘܼܟ݂ ܝܼܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","ܩܲܪܒܸܢܵܐ ܡܲܩܘܲܚܬ‌ܝܼ ܠܟܸܣܠܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܐܲܝܟ݂ ܚܲܒܪܘܼܟ݂ ܡܲܦܪܸܡ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","ܥܵܒ݂ܪܵܐ ܩܲܕܡܘܼܟ݂ ܦܲܪܦܲܠܬ‌ܝܼ، ܐܲܝܟ݂ ܗܹܡܸܙܡܵܢܘܼܟ݂ ܦܲܨܝܼ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","ܡܲܢܒܸܥܝܼ ܣܸܦܘܵܬ‌ܝܼ̈ ܬܸܫܒܘܿܚܬܵ‌ܐ، ܣܵܒܵܒ ܟܹܐ ܡܲܠܦܸܬ ܠܝܼ ܩܵܢܘܿܢܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","ܙܵܡܹܪ ܠܸܫܵܢܝܼ ܗܹܡܸܙܡܵܢܘܼܟ݂، ܣܵܒܵܒ ܟܠܵܝܗ‌ܝ ܦܘܼܩܕܵܢܘܼ̈ܟ݂ ܙܲܕܝܼܩܘܼܬܵ‌ܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","ܗܵܘܝܵܐ ܐܝܼܕܘܼܟ݂ ܠܗܲܝܘܼܪܝܼ، ܣܵܒܵܒ ܦܘܼܩܵܕܘܼ̈ܟ݂ ܓܘܼܒܹܐ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","ܪܘܼܚܪܸܚ ܠܝܼ ܠܦܘܼܪܩܵܢܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܘܢܵܡܘܿܣܘܼܟ݂ ܒܘܼܣܵܡܝܼ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","ܚܵܝܵܐ ܓܵܢܝܼ ܘܫܲܒܚܵܐ ܐܸܠܘܼܟ݂، ܘܕܝܼܘܵܢܘܼ̈ܟ݂ ܗܲܝܸܪܝܼ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","ܚܠܝܼܛ ܠܝܼ ܐܲܝܟ݂ ܥܸܪܒܵܐ ܛܠܝܼܩܵܐ؛ ܛܥܝܼ ܒܵܬܪ ܪܹܓܘܼܟ݂، ܣܵܒܵܒ ܦܘܼܩܕܵܢܘܼ̈ܟ݂ ܠܵܐ ܡܘܼܢܫܹܐ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","ܠܡܵܪܝܵܐ ܒܥܵܘܩܵܢܝܼ ܩܪܹܐ ܠܝܼ، ܘܩܵܡ ܓ̰ܲܘܸܒ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","ܝܵܐ ܡܵܪܝܵܐ، ܦܲܨܝܼ ܓܵܢܝܼ ܡ̣ܢ ܣܸܦܘܵܬܹ̈‌ܐ ܕܕܘܼܓܠܵܐ، ܡ̣ܢ ܠܸܫܵܢܵܐ ܕܦܸܠܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","ܡܘܼܕܝܼ ܒܸܬ ܥܵܒܹܕ ܐܸܠܘܼܟ݂، ܘܡܘܼܕܝܼ ܒܸܬ ܡܲܙܝܸܕ، ܠܸܫܵܢܵܐ ܕܦܸܠܡܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","ܓܹܐܪܹ̈ܐ ܚܲܪ̈ܝܼܦܹܐ ܕܓܲܒܵܪܵܐ، ܥܲܡ ܓܘܼܡܪܹ̈ܐ ܕܐܝܼܠܵܢܹ̈ܐ ܕܒܸܛܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","ܘܵܝ ܐܸܠܝܼ ܒܗ̇ܝ ܕܗܘܹܐ ܠܝܼ ܡܵܫܵܚܲܛ ܒܡܹܫܲܟ، ܫܪܹܐ ܠܝܼ ܒܡܲܫܟܢܹ̈ܐ ܕܩܹܕܲܪ. ");
INSERT INTO aii_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","ܝܪܝܼܟ݂ ܠܵܗ̇ ܥܲܠܝܼ ܥܡܵܪܬܵ‌ܐ ܕܓܵܢܝܼ، ܥܲܡ ܣܵܢܝܵܢܹ̈ܐ ܕܫܠܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","ܐܵܢܵܐ ܒܵܬܪ ܫܠܵܡܵܐ ܝܘܸܢ، ܐܝܼܢܵܐ ܐܝܼܡܲܢ ܕܗܲܡܙܸܡܸܢ، ܐܵܢܝܼ ܒܵܬܪ ܦܠܵܫܵܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","ܒܸܬ ܡܲܪܡܸܢ ܥܲܝܢܝܼ̈ ܠܛܘܼܪ̈ܵܢܹܐ، ܡ̣ܢ ܐܲܝܟܵܐ ܒܸܬ ܐܵܬܝܵܐ ܗܲܝܲܪܬ‌ܝܼ؟ ");
INSERT INTO aii_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","ܗܲܝܲܪܬ‌ܝܼ ܡ̣ܢ ܠܟܸܣ ܡܵܪܝܵܐ ܝܠܵܗ̇، ܥܵܒ݂ܕܵܢܵܐ ܕܫܡܲܝܵܐ ܘܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","ܠܹܐ ܫܵܒܹܩ ܐܲܩܠܘܼܟ݂ ܓ̰ܵܪܛܵܐ، ܠܹܐ ܢܵܐܹܡ ܢܵܛܘܿܪܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","ܗܵܐ، ܠܹܐ ܢܵܐܹܡ ܘܠܹܐ ܛܵܠܹܥ، ܢܵܛܘܿܪܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","ܡܵܪܝܵܐ ܝܠܹܗ ܢܵܛܘܿܪܘܼܟ݂، ܡܵܪܝܵܐ ܝܠܹܗ ܛܸܠܵܢܝܼܬܘܼܟ݂ ܥܲܠܔ ܐܝܼܕܵܐ ܕܝܲܡܝܼܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","ܒܐܝܼܡܵܡܵܐ ܫܸܡܫܵܐ ܠܹܐ ܡܵܚܹܐ ܠܘܼܟ݂، ܐܵܦܠܵܐ ܣܲܗܪܵܐ ܒܠܲܝܠܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","ܡܵܪܝܵܐ ܒܸܬ ܢܵܛܹܪܘܼܟ݂ ܡ̣ܢ ܟܠܔ ܒܝܼܫܬܵ‌ܐ، ܒܸܬ ܢܵܛܹܪ ܠܓܵܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","ܡܵܪܝܵܐ ܒܸܬ ܢܵܛܹܪ ܦܠܵܛܘܼܟ݂ ܘܥܒ݂ܵܪܘܼܟ݂، ܡ̣ܢ ܐܵܕܝܼܵܐ ܘܗܲܠܔ ܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","ܚܕܹܐ ܠܝܼ ܟܲܕ ܐܡܝܼܪܗܘܿܢ ܐܸܠܝܼ: ”ܠܒܲܝܬܵ‌ܐ ܕܡܵܪܝܵܐ ܐܵܙܲܠ݇ܚ.“ ");
INSERT INTO aii_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","ܒܸܟܠܵܝܵܐ ܝܗܘܵܘ ܐܲܩܠܵܬܲܢ̈ ܒܕܲܪ̈ܘܵܙܵܟ݂ܝ، ܝܵܐ ܐܘܿܪܸܫܠܸܡ. ");
INSERT INTO aii_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","ܐܘܿܪܸܫܠܸܡ ܒܢܝܼܬܵ‌ܐ، ܐܲܝܟ݂ ܡܕܝܼܢ݇ܬܵ‌ܐ ܩܕܝܼܚܬܵ‌ܐ ܒܚܕܵܕܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","ܕܬܵܡܵܐ ܐܣܝܼܩ ܠܗܘܿܢ ܫܲܒ݂ܛܹ̈ܐ، ܫܲܒ݂ܛܹ̈ܐ ܕܡܵܪܝܵܐ، ܣܵܗܕܘܼܬܵ‌ܐ ܠܐܝܼܣܪܵܐܹܝܠܔ، ܠܫܲܟܘܼܪܹܐ ܠܫܸܡܵܐ ܕܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","ܣܵܒܵܒ ܬܵܡܵܐ ܝܬܝܼܒ݂ ܠܗܘܿܢ ܟܘܼܪ̈ܣܝܼܹܐ ܠܕܝܼܘܵܢ، ܟܘܼܪ̈ܣܝܼܹܐ ܕܒܹܝܬ ܕܵܘܝܼܕ. ");
INSERT INTO aii_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","ܛܠܘܿܒܘܼܢ ܫܠܵܡܵܐ ܕܐܘܿܪܸܫܠܸܡ، ܗܵܘܝܼ ܡܲܢܬܝܼܵܢܹ̈ܐ ܡܲܚܸܒܵܢܵܟ݂ܝ̈. ");
INSERT INTO aii_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","ܗܵܘܹܐ ܫܠܵܡܵܐ ܒܫܘܼܪ̈ܵܟ݂ܝ، ܫܸܠܝܘܼܬܵ‌ܐ ܒܩܲܨܪ̈ܵܟ݂ܝ. ");
INSERT INTO aii_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","ܒܘܼܬ ܐܲܚܘܿܢܘܵܬ‌ܝܼ̈ ܘܪ̈ܵܚܡܝܼ، ܒܸܬ ܐܵܡܪܹܢ: ”ܗܵܘܹܐ ܫܠܵܡܵܐ ܓܵܘܵܟ݂ܝ.“ ");
INSERT INTO aii_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","ܒܘܼܬ ܒܲܝܬܵ‌ܐ ܕܡܵܪܝܵܐ ܐܲܠܵܗܲܢ، ܒܸܬ ܒܵܥܹܝܢ ܛܵܒ݂ܬܵ‌ܐ ܐܸܠܵܟ݂ܝ. ");
INSERT INTO aii_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","ܠܟܸܣܠܘܼܟ݂ ܡܲܪܘܼܡܹܐ ܝܘܸܢ ܥܲܝܢܝܼ̈، ܝܵܐ ܝܵܬܒ݂ܵܢܵܐ ܒܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","ܗܵܐ، ܐܲܝܟ݂ ܥܲܝ̈ܢܹܐ ܕܪܹ̈ܓܵܘܵܬܹ‌ܐ ܠܐܝܼܕܵܐ ܕܡܵܪ̈ܵܘܵܬܵܝܗ‌ܝ، ܐܲܝܟ݂ ܥܲܝ̈ܢܹܐ ܕܚܸܕܲܡܬܵ‌ܐ ܠܐܝܼܕܵܐ ܕܡܵܪܬܘܼܗ̇، ܗܵܕܟ݂ܵܐ ܝܢܵܐ ܥܲܝܢܲܢ̈ ܠܡܵܪܝܵܐ ܐܲܠܵܗܲܢ، ܗܲܠܔ ܕܪܲܚܸܡ ܥܲܠܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","ܪܲܚܸܡ ܥܲܠܲܢ، ܝܵܐ ܡܵܪܝܵܐ، ܪܲܚܸܡ ܥܲܠܲܢ، ܣܵܒܵܒ ܪܵܒܵܐ ܣܒ݂ܝܼܥ ܠܲܢ ܡ̣ܢ ܡܲܣܠܲܝܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","ܪܵܒܵܐ ܣܒ݂ܝܼܥ ܠܵܗ̇ ܓܵܢܲܢ، ܡ̣ܢ ܡܲܣܚܲܪܬܵ‌ܐ ܕܪ̈ܵܘܚܵܢܹܐ، ܡ̣ܢ ܡܲܣܠܲܝܬܵ‌ܐ ܕܫܲܒ݂ܗܸܪ̈ܵܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","ܐܸܢ ܠܵܐ ܗܵܘܹܐ ܗܘܵܐ ܡܵܪܝܵܐ ܠܓܹܒܲܢ، ܫܒ݂ܘܿܩ ܐܵܡܹܪ ܐܝܼܣܪܵܐܹܝܠܔ، ");
INSERT INTO aii_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","ܐܸܢ ܠܵܐ ܗܵܘܹܐ ܗܘܵܐ ܡܵܪܝܵܐ ܠܓܹܒܲܢ، ܐܝܼܡܲܢ ܕܩܝܼܡ ܠܗܘܿܢ ܥܲܠܲܢ ܐܢܵܫܹ̈ܐ، ");
INSERT INTO aii_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","ܗ̇ܝܓܵܗ ܚܵܝܹ̈ܐ ܒܸܬ ܒܵܠܥܝܼ ܗܘܵܘ ܠܲܢ، ܐܝܼܡܲܢ ܕܚܝܼܡ ܠܵܗ̇ ܟܲܪܒܵܝܗ‌ܝ ܥܲܠܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","ܗ̇ܝܓܵܗ ܡ̈ܝܼܵܐ ܒܸܬ ܓܵܪܦܝܼ ܗܘܵܘ ܠܲܢ، ܛܵܘܦܵܢܵܐ ܒܸܬ ܥܵܒܹܪ ܗܘܵܐ ܡܥܲܠܔ ܓܵܢܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","ܗ̇ܝܓܵܗ ܒܸܬ ܥܵܒ݂ܪܝܼ ܗܘܵܘ ܥܲܠܔ ܓܵܢܲܢ ܡ̈ܝܼܵܐ ܓܲܒܓܸܒܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","ܒܪܝܼܟ݂ܵܐ ܝܠܹܗ ܡܵܪܝܵܐ، ܕܠܵܐ ܩܵܡ ܝܵܗܒܹܠܔ ܠܲܢ ܨܲܝܕܵܐ ܠܟܹܟܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","ܓܵܢܲܢ ܚܠܝܼܨ ܠܵܗ̇ ܐܲܝܟ݂ ܛܲܝܪܵܐ ܡ̣ܢ ܦܲܚܵܐ ܕܨܲܝܵܕܹ̈ܐ، ܦܲܚܵܐ ܦܝܼܫ ܠܹܗ ܬܒ݂ܝܼܪܵܐ ܘܐܲܚܢܲܢ ܚܠܝܼܨ ܠܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","ܗܲܝܲܪܬܲܢ ܒܫܸܡܵܐ ܕܡܵܪܝܵܐ ܝܠܵܗ̇، ܥܵܒ݂ܕܵܢܵܐ ܕܫܡܲܝܵܐ ܘܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","ܐܵܢܝܼ ܕܣܵܒܪܝܼ ܒܡܵܪܝܵܐ، ܐܲܝܟ݂ ܛܘܼܪܵܐ ܕܨܸܗܝܘܿܢ ܝܼܢܵܐ ܕܠܹܐ ܫܵܥܹܫ، ܐܸܠܵܐ ܠܥܵܠܲܡ ܟܹܐ ܡܩܲܘܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","ܐܲܝܟ݂ ܕܝܼܢܵܐ ܛܘܼܪ̈ܵܢܹܐ ܚܵܕܸܪ̈ܘܵܢܹܐ ܕܐܘܿܪܸܫܠܸܡ، ܗܵܕܟ݂ܵܐ ܡܵܪܝܵܐ ܠܚܵܕܸܪ̈ܘܵܢܹܐ ܕܥܲܡܹܗ ܝܠܹܗ، ܡ̣ܢ ܐܵܕܝܼܵܐ ܘܗܲܠܔ ܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","ܣܵܒܵܒ ܠܹܐ ܫܵܪܹܐ ܚܘܼܛܪܵܐ ܕܪܲܫܝܼܥܵܐ ܥܲܠܔ ܝܵܪܬܘܼܬܵ‌ܐ ܕܙܲܕܝܼܩܹ̈ܐ، ܩܵܐ ܕܠܵܐ ܦܲܫܛܝܼ ܙܲܕܝܼܩܹ̈ܐ ܐܝܼܕܵܬܵܝ̈ܗ‌ܝ ܠܥܵܘܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","ܥܒ݂ܘܿܕ ܛܵܒ݂ܬܵ‌ܐ، ܝܵܐ ܡܵܪܝܵܐ، ܠܛܵܒܹ̈ܐ، ܘܠܬܪ̈ܘܼܨܹܐ ܒܠܸܒܵܘܵܬܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","ܐܝܼܢܵܐ ܐܵܢܝܼ ܕܩܵܠܒܝܼ ܠܐܘܼܪ̈ܚܵܬܵܝܗ‌ܝ ܦܟ̰ܝܼܠܹ̈ܐ، ܒܸܬ ܠܲܒܸܠܔ ܠܗܘܿܢ ܡܵܪܝܵܐ ܥܲܡ ܦܵܠܚܵܢܹ̈ܐ ܕܥܵܘܠܵܐ، ܫܠܵܡܵܐ ܥܲܠܔ ܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","ܟܲܕ ܡܘܼܕܸܪܹܗ ܡܵܪܝܵܐ ܓܵܠܘܼܬܵ‌ܐ ܕܨܸܗܝܘܿܢ، ܗܘܹܐ ܠܲܢ ܐܲܝܟ݂ ܚܵܙܝܵܢܹ̈ܐ ܕܚܸܠܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","ܗ̇ܝܓܵܗ ܦܝܼܫ ܠܹܗ ܡܸܠܝܵܐ ܓܸܚܟܵܐ ܦܘܼܡܲܢ، ܘܠܸܫܵܢܲܢ ܫܲܒܲܚܬܵ‌ܐ، ܗ̇ܝܓܵܗ ܐܡܝܼܪܗܘܿܢ ܓܵܘ ܐܸܡܘܵܬܹ̈‌ܐ: ”ܥܒ݂ܝܼܕ ܠܹܗ ܡܵܪܝܵܐ ܫܘܼܠܵܢܹ̈ܐ ܓܘܼܪܹ̈ܐ ܩܵܐ ܐܲܢܹܐ.“ ");
INSERT INTO aii_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","ܥܒ݂ܝܼܕ ܠܹܗ ܡܵܪܝܵܐ ܫܘܼܠܵܢܹ̈ܐ ܓܘܼܪܹ̈ܐ ܩܵܬܲܢ، ܚܸܕܝܹܐ ܝܘܲܚ. ");
INSERT INTO aii_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","ܡܲܕܸܪ، ܝܵܐ ܡܵܪܝܵܐ، ܓܵܠܘܼܬܲܢ، ܐܲܝܟ݂ ܫܵܩ̈ܝܼܵܬܹ‌ܐ ܒܬܲܝܡܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","ܐܵܢܝܼ ܕܙܵܪܥܝܼ ܒܕܸܡܥܝܼܬܵ‌ܐ، ܒܫܲܒܲܚܬܵ‌ܐ ܒܸܬ ܚܵܨܕܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","ܗ̇ܘ ܕܚܕܵܪܵܐ ܚܵܕܹܪ ܘܒܵܟܹܐ ܟܲܕ ܛܥܝܼܢܵܐ ܟܝܼܣܬܵ‌ܐ ܕܒܲܪܙܲܪܥܵܐ، ܐܬܵܝܵܐ ܒܸܬ ܐܵܬܹ‌ܐ ܒܫܲܒܲܚܬܵ‌ܐ ܟܲܕ ܛܥܝܼܢܵܐ ܕܲܪ̈ܙܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","ܐܸܢ ܡܵܪܝܵܐ ܠܵܐ ܒܵܢܹܐ ܒܲܝܬܵ‌ܐ، ܣܪܝܼܩܵܐ ܝܠܹܗ ܥܲܡܠܵܐ ܕܒܲܢܵܝܘܼ̈ܗ‌ܝ، ܐܸܢ ܡܵܪܝܵܐ ܠܵܐ ܢܵܛܹܪ ܡܕܝܼܢ݇ܬܵ‌ܐ، ܣܪܝܼܩܬܵ‌ܐ ܝܠܵܗ̇ ܫܵܗܲܪܬܵ‌ܐ ܕܢܵܛܘܿܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","ܣܪܝܼܩܬܵ‌ܐ ܝܠܵܗ̇ ܐܸܠܵܘܟ݂ܘܿܢ ܕܩܲܕܡܝܼܬܘܿܢ ܠܸܩܝܵܡܵܐ، ܥܲܪܩܸܠܝܼܬܘܿܢ ܠܸܬܝܵܒ݂ܵܐ، ܐܵܟ݂ܠܝܼܬܘܿܢ ܠܲܚܡܵܐ ܕܓ̰ܵܦܹ̈ܐ، ܣܵܒܵܒ ܟܹܐ ܝܵܗܒܹܠܔ ܠܡܘܼܚܸܒܹܗ ܒܫܸܢܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","ܗܵܐ، ܝܵܪܬܘܼܬܵ‌ܐ ܡ̣ܢ ܡܵܪܝܵܐ ܒܢܘܿܢܹ̈ܐ ܝܢܵܐ، ܦܘܼܪܥܵܢܵܐ ܝܠܵܗ̇ ܛܥܘܼܢܬܵ‌ܐ ܕܡܲܪܒܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","ܐܲܝܟ݂ ܓܹܐܪܹ̈ܐ ܓܵܘ ܐܝܼܕܵܐ ܕܓܲܒܵܪܵܐ، ܗܵܕܟ݂ܵܐ ܝܢܵܐ ܒܢܘܿܢܹ̈ܐ ܕܫܸܢܹ̈ܐ ܕܥܠܲܝܡܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","ܛܘܼܒ݂ܵܐ ܠܓܲܒ݂ܪܵܐ ܕܡܠܹܐ ܠܹܗ ܚܸܠܬܹܗ ܡܸܢܵܝܗ‌ܝ، ܠܹܐ ܢܵܟ݂ܦܝܼ، ܟܲܕ ܗܲܡܙܸܡܝܼ ܥܲܡ ܕܸܫ̃ܡܸܢܹ̈ܐ ܒܕܲܪܘܵܙܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","ܛܘܼܒ݂ܵܐ ܠܟܠܔ ܕܙܵܕܹܥ ܡ̣ܢ ܡܵܪܝܵܐ، ܠܗ̇ܘ ܕܚܵܕܹܪ ܒܐܘܼܪ̈ܚܵܬܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","ܓ̰ܵܦܵܐ ܕܐܝܼܕܵܬܘܼ̈ܟ݂ ܒܸܬ ܐܵܟ݂ܠܹܬ، ܛܘܼܒ݂ܵܐ ܐܸܠܘܼܟ݂ ܘܛܵܒ݂ܬܵ‌ܐ ܐܸܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","ܒܲܟ݂ܬܘܼܟ݂ ܒܸܬ ܗܵܘܝܵܐ ܐܲܝܟ݂ ܓܸܦܬܵ‌ܐ ܡܵܪܹܐ ܛܥܘܼܢܬܵ‌ܐ ܓܵܘ ܠܸܒܵܐ ܕܒܲܝܬܘܼܟ݂، ܒܢܘܿܢܘܼ̈ܟ݂ ܒܸܬ ܗܵܘܝܼ ܐܲܝܟ݂ ܫܸܬܠܹ̈ܐ ܕܙܲܝ̈ܬܹ‌ܐ ܚܘܼܪܕܝܼܹܐ ܠܨܘܼܦܪܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","ܗܵܐ، ܗܵܕܟ݂ܵܐ ܒܸܬ ܦܵܐܹܫ ܒܘܼܪܟ݂ܵܐ ܓܲܒ݂ܪܵܐ ܕܙܵܕܹܥ ܡ̣ܢ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","ܒܲܪܸܟ݂ ܠܘܼܟ݂ ܡܵܪܝܵܐ ܡ̣ܢ ܨܸܗܝܘܿܢ، ܘܚܵܙܹܝܬ ܛܵܒ݂ܬܵ‌ܐ ܕܐܘܿܪܸܫܠܸܡ ܟܠܵܝܗ‌ܝ ܝܵܘܡܵܢܹ̈ܐ ܕܚܲܝܘܼ̈ܟ݂، ");
INSERT INTO aii_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","ܘܚܵܙܹܝܬ ܒܢܘܿܢܹ̈ܐ ܕܒܢܘܿܢܘܼ̈ܟ݂، ܫܠܵܡܵܐ ܥܲܠܔ ܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","”ܪܵܒܵܐ ܩܵܡ ܡܲܠܝܸܨܝܼ ܠܝܼ ܡ̣ܢ ܙܥܘܿܪܘܼܬ‌ܝܼ،“ ܫܒ݂ܘܿܩ ܐܵܡܹܪ ܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","”ܪܵܒܵܐ ܩܵܡ ܡܲܠܝܸܨܝܼ ܠܝܼ ܡ̣ܢ ܙܥܘܿܪܘܼܬ‌ܝܼ، ܐܝܼܢܵܐ ܠܵܐ ܡܨܹܐ ܠܗܘܿܢ ܒܝܼܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","ܡܵܚܝܵܢܹ̈ܐ ܕܟܪܝܼܒ݂ܵܐ ܡܚܹܐ ܠܗܘܿܢ ܟܪܝܼܒ݂ܵܐ ܥܲܠܔ ܚܲܨܝܼ؛ ܡܘܼܪܝܸܟ݂ ܠܗܘܿܢ ܟܪ̈ܝܼܒ݂ܵܝܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","ܐܝܼܢܵܐ ܡܵܪܝܵܐ ܙܲܕܝܼܩܵܐ ܝܠܹܗ، ܩܛܝܼܥ ܠܹܗ ܚܲܒ݂ܠܹ̈ܐ ܕܒܝܼܫܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","ܢܵܟ݂ܦܝܼ ܘܕܵܝܪܝܼ ܠܒܵܬܪܵܐ ܟܠܵܝܗ‌ܝ ܣܵܢܝܵܢܹ̈ܐ ܕܨܸܗܝܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","ܗܵܘܝܼ ܐܲܝܟ݂ ܓܸܠܵܐ ܕܐܓܵܪ̈ܵܘܵܬܹ‌ܐ، ܗ̇ܘ ܕܟܹܐ ܒܵܪܹܙ ܡ̣ܢ ܩܲܕܡ ܕܦܵܐܹܫ ܢܟ̰ܝܼܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","ܕܠܹܐ ܡܵܠܝܵܐ ܡܸܢܹܗ ܐܝܼܕܵܐ ܕܚܲܨܵܕܵܐ، ܘܠܵܐ ܚܦܵܩܵܐ ܕܐܵܣܪܵܢܵܐ ܕܕܲܪ̈ܙܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","ܘܠܹܐ ܐܵܡܪܝܼ ܥܵܒ݂ܪ̈ܵܢܹܐ: ”ܒܘܼܪܟܬܵ‌ܐ ܕܡܵܪܝܵܐ ܥܲܠܵܘܟ݂ܘܿܢ، ܒܲܪܘܼܟܹܐ ܝܘܲܚ ܐܸܠܵܘܟ݂ܘܿܢ ܒܫܸܡܵܐ ܕܡܵܪܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","ܡ̣ܢ ܥܘܼܡܩܹ̈ܐ ܩܪܹܐ ܠܝܼ ܐܸܠܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ؛ ");
INSERT INTO aii_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","ܡܵܪܝܵܐ، ܫܡܹܥ ܠܩܵܠܝܼ، ܗܵܘܝܼ ܢܵܬܝܵܬܘܼ̈ܟ݂ ܡܲܨܝܘܼܬܹ‌ܐ ܠܩܵܠܵܐ ܕܦܲܪ̈ܦܲܠܝܵܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","ܐܸܢ ܥܵܘ̈ܠܹܐ ܚܲܫܒܸܢܸܬ، ܝܵܐ ܡܵܪܝܵܐ، ܡܵܪܝܵܐ، ܡܵܢܝܼ ܡܵܨܹܐ ܟܵܠܹܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","ܒܗ̇ܝ ܕܐܝܼܬ ܥܲܡܘܼܟ݂ ܫܘܼܒ݂ܩܵܢܵܐ، ܕܙܵܕܥܝܼ ܡܸܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","ܣܦܝܼܪܝܼ ܠܡܵܪܝܵܐ، ܣܦܝܼܪܵܗ̇ ܓܵܢܝܼ، ܘܒܚܲܒܪܹܗ ܡܘܼܬܸܒ݂ ܠܝܼ ܣܲܒ݂ܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","ܓܵܢܝܼ ܟܹܐ ܣܵܦܪܵܐ ܠܡܵܪܝܵܐ، ܒܘܼܫ ܡ̣ܢ ܢܵܛܪ̈ܵܢܹܐ ܠܨܲܦܪܵܐ، ܢܵܛܪ̈ܵܢܹܐ ܠܨܲܦܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","ܡܲܬܸܒ݂ ܣܲܒ݂ܪܘܼܟ݂، ܝܵܐ ܐܝܼܣܪܵܐܹܝܠܔ، ܒܡܵܪܝܵܐ، ܒܗ̇ܝ ܕܥܲܡ ܡܵܪܝܵܐ ܐܝܼܬ ܚܢܵܢܵܐ، ܘܦܸܪܝܵܐ ܦܘܼܪܩܵܢܵܐ ܐܝܼܬ ܥܲܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","ܘܗ̇ܘ ܒܸܬ ܦܲܪܸܩ ܠܐܝܼܣܪܵܐܹܝܠܔ، ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܥܵܘܠܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","ܝܵܐ ܡܵܪܝܵܐ، ܠܹܐ ܝܠܹܗ ܫܘܼܒ݂ܗܸܪܵܐ ܠܸܒܝܼ، ܘܠܹܐ ܝܢܵܐ ܚܬܝܼܪܹܐ ܥܲܝܢܝܼ̈، ܘܠܵܐ ܚܕܝܼܪܝܼ ܒܫܘܼܠܵܢܹ̈ܐ ܒܘܼܫ ܓܘܼܪܹ̈ܐ ܝܲܢ ܒܘܼܫ ܡܲܥܓ̰ܸܒܵܢܹ̈ܐ ܩܵܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","ܐܸܠܵܐ ܡܘܼܫܠܝܼܵܐ ܠܝܼ ܘܡܘܼܫܬܸܩܵܐ ܠܝܼ ܓܵܢܝܼ، ܐܲܝܟ݂ ܩܛܝܼܥܵܐ ܡ̣ܢ ܚܲܠܒ݂ܵܐ ܒܥܘܼܒܵܐ ܕܝܸܡܹܗ، ܐܲܝܟ݂ ܩܛܝܼܥܵܐ ܡ̣ܢ ܚܲܠܒ݂ܵܐ ܝܠܵܗ̇ ܓܵܢܝܼ ܒܓܵܘܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","ܣܒܘܿܪ، ܝܵܐ ܐܝܼܣܪܵܐܹܝܠܔ، ܒܡܵܪܝܵܐ، ܡ̣ܢ ܐܵܕܝܼܵܐ ܘܗܲܠܔ ܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","ܕܟ݂ܘܿܪ، ܝܵܐ ܡܵܪܝܵܐ، ܠܕܵܘܝܼܕ، ܠܟܠܵܝܗ‌ܝ ܐܘܼܠܨܵܢܘܼ̈ܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","ܕܵܐܟ݂ܝܼ ܕܝܡܹܐ ܠܹܗ ܠܡܵܪܝܵܐ، ܢܕܝܼܪܹܗ ܠܙܲܪܒܵܢܵܐ ܕܝܲܥܩܘܿܒ݂: ");
INSERT INTO aii_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","”ܠܹܐ ܥܵܒ݂ܪܹܢ ܬܚܘܿܬ ܫܟܘܼܪܹܐ ܕܒܲܝܬ‌ܝܼ، ܠܹܐ ܐܵܣܩܹܢ ܥܲܠܔ ܫܘܝܼܬܵ‌ܐ ܕܕܡܵܟ݂ܬ‌ܝܼ، ");
INSERT INTO aii_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","”ܠܹܐ ܝܵܗܒܹܢ ܫܸܢܬܵ‌ܐ ܠܥܲܝܢܝܼ̈، ܢܵܘܡܵܐ ܠܛܸܠܦܵܦܝܼ̈، ");
INSERT INTO aii_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","”ܗܲܠܔ ܕܡܲܫ݇ܟ̰ܚܸܢ ܕܘܼܟܬܵ‌ܐ ܩܵܐ ܡܵܪܝܵܐ، ܡܲܫܟܢܵܐ ܩܵܐ ܙܲܪܒܵܢܵܐ ܕܝܲܥܩܘܿܒ݂.“ ");
INSERT INTO aii_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","ܗܵܐ، ܫܡܝܼܥ ܠܲܢ ܒܘܼܬ ܕܝܼܘܼܗ̇ ܓܵܘ ܐܵܦܲܪܬܵ‌ܐ، ܡܘܼܫ݇ܟ̰ܚܵܐ ܠܲܢ ܓܵܘ ܚܲܩܠܵܢܹ̈ܐ ܕܡܲܝܫܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","ܥܵܒ݂ܪܲܚ ܠܡܲܫܟܢܘܼ̈ܗ‌ܝ، ܣܵܓ݂ܕܲܚ ܠܓܹܒܵܐ ܕܟܘܼܒ݂ܫܵܐ ܕܐܲܩܠܘܼ̈ܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","ܒܹܐܡܵܪܵܐ: ”ܩܘܼܡ، ܝܵܐ ܡܵܪܝܵܐ، ܠܢܝܵܚܬܘܼܟ݂، ܐܲܢ݇ܬ ܘܩܹܒ݂ܘܼܬܵ‌ܐ ܕܙܲܪܒܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","”ܟܵܗܢܘܼ̈ܟ݂ ܠܵܒ݂ܫܝܼ ܙܲܕܝܼܩܘܼܬܵ‌ܐ، ܘܙܲܕܝܼܩܘܼ̈ܟ݂ ܫܲܒܚܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","ܒܘܼܬ ܕܵܘܝܼܕ ܪܹܓܘܼܟ݂، ܠܵܐ ܡܲܕܸܪܸܬ ܦܵܬܵ‌ܐ ܕܡܫܝܼܚܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","ܝܡܹܐ ܠܹܗ ܡܵܪܝܵܐ ܠܕܵܘܝܼܕ ܒܫܲܪܝܼܪܘܼܬܵ‌ܐ، ܘܠܹܐ ܕܵܐܹܪ ܡܸܢܘܼܗ̇: ”ܡ̣ܢ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܕܟܹܪ݇ܣܘܼܟ݂ ܒܸܬ ܡܲܬܒܸܢ ܥܲܠܔ ܟܘܼܪܣܝܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","”ܐܸܢ ܢܵܛܪܝܼ ܒܢܘܿܢܘܼ̈ܟ݂ ܘܲܥܕܝܼ، ܘܣܵܗܕܘܵܬ‌ܝܼ̈ ܕܡܲܠܦܸܢܗܘܿܢ، ܐܘܼܦ ܒܢܘܿܢܵܝ̈ܗ‌ܝ ܠܥܵܠܲܡ ܒܸܬ ܝܵܬܒ݂ܝܼ ܥܲܠܔ ܟܘܼܪܣܝܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","ܣܵܒܵܒ ܓܘܼܒܹܐ ܠܹܗ ܡܵܪܝܵܐ ܠܨܸܗܝܘܿܢ، ܫܘܼܗܘܸܬ ܠܹܗ ܕܗܵܘܝܵܐ ܒܹܝܬ ܡܲܥܡܪܹܗ، ܒܹܐܡܵܪܵܐ: ");
INSERT INTO aii_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","”ܐܵܗܵܐ ܝܠܵܗ̇ ܢܝܵܚܬ‌ܝܼ ܗܲܠܔ ܥܵܠܲܡ، ܠܲܐܟ݂ܵܐ ܒܸܬ ܝܵܬܒܹܢ ܣܵܒܵܒ ܫܘܼܗܘܸܬ ܠܝܼ ܐܸܠܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","”ܡܹܐܟ݂ܘܼܠܬܘܼܗ̇ ܒܲܪܘܼܟܹܐ ܒܸܬ ܒܲܪܟܸܢ، ܣܢܝܼܩܘܼ̈ܗ̇ ܒܸܬ ܡܲܣܒܸܥܸܢ ܒܠܲܚܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","”ܘܠܟܵܗܢܘܼ̈ܗ̇ ܒܸܬ ܡܲܠܒܸܫܸܢ ܦܘܼܪܩܵܢܵܐ، ܘܙܲܕܝܼܩܘܼ̈ܗ̇ ܫܲܒܲܚܬܵ‌ܐ ܒܸܬ ܫܲܒܚܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","”ܬܵܡܵܐ ܒܸܬ ܡܲܩܸܡܸܢ ܚܲܝܠܵܐ ܠܕܵܘܝܼܕ، ܡܘܼܪܝܸܙ ܠܝܼ ܫܪܵܓ݂ܵܐ ܩܵܐ ܡܫܝܼܚܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","”ܠܕܸܫ̃ܡܸܢܘܼ̈ܗ‌ܝ ܒܸܬ ܡܲܠܒܸܫܸܢ ܢܟ݂ܝܼܦܬܵ‌ܐ، ܐܝܼܢܵܐ ܥܲܠܘܼܗ‌ܝ ܒܸܬ ܦܵܩܹܚ ܬܵܓܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","ܗܵܐ، ܟܡܵܐ ܨܦܵܝܝܼ ܝܠܵܗ̇ ܘܟܡܵܐ ܒܲܣܝܼܡܬܵ‌ܐ، ܝܬܵܒ݂ܬܵ‌ܐ ܕܐܲܚܘܿܢܘܵܬܹ̈‌ܐ ܥܲܡ ܚܕܵܕܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","ܐܲܝܟ݂ ܡܸܫܚܵܐ ܨܦܵܝܝܼ ܥܲܠܔ ܪܹܝܫܵܐ، ܒܸܨܠܵܝܵܐ ܥܲܠܔ ܕܸܩܢܵܐ، ܕܸܩܢܵܐ ܕܐܲܗܪܘܿܢ، ܕܒܸܨܠܵܝܵܐ ܝܗܘܵܐ ܥܲܠܔ ܩܕܵܠܵܐ ܕܠܒ݂ܘܼܫܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","ܐܲܝܟ݂ ܛܠܘܼܠܵܐ ܕܚܸܪܡܘܿܢ، ܕܨܵܠܹܐ ܥܲܠܔ ܛܘܼܪܹ̈ܐ ܕܨܸܗܝܘܿܢ، ܣܵܒܵܒ ܬܵܡܵܐ ܦܩܝܼܕ ܠܹܗ ܡܵܪܝܵܐ ܒܘܼܪܟܬܵ‌ܐ، ܚܲܝܹ̈ܐ ܗܲܠܔ ܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","ܗܵܐ، ܒܲܪܟ݂ܘܼܢ ܠܡܵܪܝܵܐ ܟܠܵܝܗ‌ܝ ܪܹ̈ܓܵܘܵܬܹ‌ܐ ܕܡܵܪܝܵܐ، ܟܵܠܝܵܢܹ̈ܐ ܒܒܲܝܬܵ‌ܐ ܕܡܵܪܝܵܐ ܒܠܲܝܠܵܘܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","ܡܲܪܡܘܼܢ ܐܝܼܕܵܘܟ݂ܘܿܢ ܠܡܲܩܕܫܵܐ، ܘܒܲܪܟ݂ܘܼܢ ܠܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","ܒܲܪܸܟ݂ ܠܘܼܟ݂ ܡܵܪܝܵܐ ܡ̣ܢ ܨܸܗܝܘܿܢ، ܥܵܒ݂ܕܵܢܵܐ ܕܫܡܲܝܵܐ ܘܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","ܫܲܒܚܘܼܢ ܠܫܸܡܵܐ ܕܡܵܪܝܵܐ، ܫܲܒܚܘܼܢ، ܝܵܐ ܪܹ̈ܓܵܘܵܬܹ‌ܐ ܕܡܵܪܝܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","ܐܵܢܝܼ ܕܟܹܐ ܟܵܠܝܼ ܒܒܲܝܬܵ‌ܐ ܕܡܵܪܝܵܐ، ܒܕܵܪ̈ܵܬܹ‌ܐ ܕܒܲܝܬܵ‌ܐ ܕܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","ܫܲܒܚܘܼܢ ܠܡܵܪܝܵܐ ܣܵܒܵܒ ܛܵܒ݂ܵܐ ܝܠܹܗ ܡܵܪܝܵܐ، ܙܡܘܿܪܘܼܢ ܠܫܸܡܹܗ ܣܵܒܵܒ ܒܲܣܝܼܡܵܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","ܣܵܒܵܒ ܓܘܼܒܹܐ ܠܹܗ ܡܵܪܝܵܐ ܠܝܲܥܩܘܿܒ݂ ܩܵܐ ܓܵܢܹܗ، ܠܐܝܼܣܪܵܐܹܝܠܔ ܣܝܼܡܬܵ‌ܐ ܩܵܐ ܓܵܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","ܣܵܒܵܒ ܐܵܢܵܐ ܟܹܐ ܝܵܕܥܹܢ ܕܓܘܼܪܵܐ ܝܠܹܗ ܡܵܪܝܵܐ، ܘܥܸܠܵܝܵܐ ܝܠܹܗ ܡܵܪܲܢ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܐܲܠܵܗܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","ܟܹܐ ܥܵܒܹܕ ܡܵܪܝܵܐ ܟܠܔ ܕܒܵܣܡܵܐ ܠܹܗ، ܒܫܡܲܝܵܐ ܘܒܐܲܪܥܵܐ، ܒܝܵܡܵܬܹ̈‌ܐ ܘܒܟܠܵܝܗ‌ܝ ܬܗܘܿܡܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","ܡܲܣܩܵܢܵܐ ܕܗܵܘܓܹ̈ܐ ܡ̣ܢ ܡܲܪܙܵܐ ܕܐܲܪܥܵܐ، ܥܵܒ݂ܕܵܢܵܐ ܕܒܸܪ̈ܩܹܐ ܩܵܐ ܡܸܛܪܵܐ، ܦܲܠܛܵܢܵܐ ܕܦܵܘܚܵܐ ܡ̣ܢ ܐܲܢܒܵܪ̈ܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","ܗ̇ܘ ܝܼܗܘܵܐ ܕܡܚܹܐ ܠܹܗ ܒܘܼܟ݂ܪܹ̈ܐ ܕܡܸܨܪܹܝܢ، ܡ̣ܢ ܒܲܪܢܵܫܵܐ ܗܲܠܔ ܒܥܝܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","ܩܵܡ ܫܲܕܸܪ ܢܝܼܫܲܢܩܹ̈ܐ ܘܕܘܼܡܵܪܹ̈ܐ ܓܵܘܵܟ݂ܝ، ܝܵܐ ܡܸܨܪܹܝܢ، ܥܲܠܔ ܦܸܪܥܘܿܢ ܘܥܲܠܔ ܟܠܵܝܗ‌ܝ ܪܹ̈ܓܵܘܵܬܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","ܗ̇ܘ ܝܼܗܘܵܐ ܕܡܚܹܐ ܠܹܗ ܐܸܡܘܵܬܹ̈‌ܐ ܪܵܒܵܐ، ܘܩܛܝܼܠܔ ܠܹܗ ܡܲܠܟܹ̈ܐ ܥܲܫܝܼܢܹ̈ܐ؛ ");
INSERT INTO aii_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","ܠܣܝܼܚܘܿܢ ܡܲܠܟܵܐ ܕܐܵܡܘܿܪ̈ܵܝܹܐ، ܘܠܥܘܿܓ݂ ܡܲܠܟܵܐ ܕܒܲܝܫܵܢ، ܘܠܟܠܵܝܗ‌ܝ ܡܲܠܟܘܵܬܹ̈‌ܐ ܕܟܢܲܥܢ. ");
INSERT INTO aii_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܐܲܪܥܵܝܗ‌ܝ ܠܝܵܪܬܘܼܬܵ‌ܐ، ܝܵܪܬܘܼܬܵ‌ܐ ܠܐܝܼܣܪܵܐܹܝܠܔ ܥܲܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","ܝܵܐ ܡܵܪܝܵܐ، ܫܸܡܘܼܟ݂ ܠܥܵܠܲܡ ܝܼܠܹܗ، ܝܵܐ ܡܵܪܝܵܐ، ܕܟ݂ܵܪܘܼܟ݂ ܠܕܵܪܵܐ ܘܕܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","ܣܵܒܵܒ ܒܸܬ ܥܵܒܹܕ ܡܵܪܝܵܐ ܕܝܼܘܵܢ ܕܥܲܡܹܗ، ܘܥܲܠܔ ܪܹ̈ܓܵܘܵܬܘܼܗ‌ܝ ܒܸܬ ܪܲܚܸܡ. ");
INSERT INTO aii_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","ܨܵܢܲܡܹ̈ܐ ܕܐܸܡܘܵܬܹ̈‌ܐ ܣܹܐܡܵܐ ܘܕܲܗܒ݂ܵܐ ܝܢܵܐ، ܦܘܼܠܚܵܢܵܐ ܕܐܝܼܕܵܬܹ̈‌ܐ ܕܒܲܪܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","ܦܘܼܡܵܐ ܐܝܼܬ ܠܗܘܿܢ ܐܝܼܢܵܐ ܠܹܐ ܗܲܡܙܸܡܝܼ، ܥܲܝܢܵܬܹ̈‌ܐ ܐܝܼܬ ܠܗܘܿܢ ܐܝܼܢܵܐ ܠܹܐ ܚܵܙܝܼ، ");
INSERT INTO aii_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","ܢܵܬܝܵܬܹ̈‌ܐ ܐܝܼܬ ܠܗܘܿܢ ܐܝܼܢܵܐ ܠܹܐ ܫܵܡܥܝܼ، ܐܘܼܦ ܠܲܝܬ ܢܫܲܡܬܵ‌ܐ ܒܦܘܼܡܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","ܐܲܝܟ݂ ܕܝܼܵܝܗ‌ܝ ܗܵܘܝܼ ܥܵܒ݂ܕܵܢܵܝ̈ܗ‌ܝ، ܘܟܠܔ ܕܣܵܒܹܪ ܒܝܼܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","ܝܵܐ ܒܹܝܬ ܐܝܼܣܪܵܐܹܝܠܔ، ܒܲܪܟ݂ܘܼܢ ܠܡܵܪܝܵܐ، ܝܵܐ ܒܹܝܬ ܐܲܗܪܘܿܢ، ܒܲܪܟ݂ܘܼܢ ܠܡܵܪܝܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","ܝܵܐ ܒܹܝܬ ܠܹܘܝܼ، ܒܲܪܟ݂ܘܼܢ ܠܡܵܪܝܵܐ، ܝܵܐ ܙܕܝܼ̈ܥܹܐ ܕܡܵܪܝܵܐ، ܒܲܪܟ݂ܘܼܢ ܠܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","ܒܘܼܪܟ݂ܵܐ ܝܠܹܗ ܡܵܪܝܵܐ ܡ̣ܢ ܨܸܗܝܘܿܢ، ܥܵܡܪܵܢܵܐ ܕܐܘܿܪܸܫܠܸܡ. ܗܲܠܸܠܘܼܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","ܫܲܟܪܘܼܢ ܠܡܵܪܝܵܐ ܣܵܒܵܒ ܛܵܒ݂ܵܐ ܝܠܹܗ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","ܫܲܟܪܘܼܢ ܠܐܲܠܵܗܵܐ ܕܐܲܠܵܗܹ̈ܐ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","ܫܲܟܪܘܼܢ ܠܡܵܪܵܐ ܕܡܵܪ̈ܵܘܵܬܹ‌ܐ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","ܠܥܵܒ݂ܕܵܢܵܐ ܕܕܘܼܡܵܪܹ̈ܐ ܓܘܼܪܹ̈ܐ ܒܢܲܦ̮ܫܹܗ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","ܠܗ̇ܘ ܕܥܒ݂ܝܼܕ ܠܹܗ ܫܡܲܝܵܐ ܒܦܲܪܡܲܝܬܵ‌ܐ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","ܠܗ̇ܘ ܕܦܪܝܼܣܵܐ ܠܹܗ ܐܲܪܥܵܐ ܥܲܠܔ ܡ̈ܝܼܵܐ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","ܠܗ̇ܘ ܕܥܒ݂ܝܼܕ ܠܹܗ ܢܲܗܝܼܪܹ̈ܐ ܓܘܼܪܹ̈ܐ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","ܫܸܡܫܵܐ ܠܗܲܟܘܼܡܹܐ ܒܐܝܼܡܵܡܵܐ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","ܣܲܗܪܵܐ ܘܟܵܘܟ݂ܒܹ̈ܐ ܠܗܲܟܘܼܡܹܐ ܒܠܲܝܠܹܐ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","ܠܗ̇ܘ ܕܡܚܹܐ ܠܹܗ ܠܒܘܼܟ݂ܪܹ̈ܐ ܕܡܸܨܪܹܝܢ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","ܘܦܘܼܠܸܛ ܠܹܗ ܐܝܼܣܪܵܐܹܝܠܔ ܡ̣ܢ ܓܵܘܵܝܗ‌ܝ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","ܒܐܝܼܕܵܐ ܙܲܪܒܵܢܬܵ‌ܐ ܘܒܕܪܲܥܢܵܐ ܦܘܼܫܛܵܐ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","ܠܗ̇ܘ ܕܦܘܼܠܸܥ ܠܹܗ ܝܵܡܵܐ ܕܣܘܿܦ ܠܬܪܹܝ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","ܘܡܘܼܥܒܸܪܹܗ ܐܝܼܣܪܵܐܹܝܠܔ ܡܓܵܘܘܼܗ̇، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","ܘܛܪܝܼܦ ܠܹܗ ܠܦܸܪܥܘܿܢ ܘܠܚܲܝܠܵܘܵܬܘܼ̈ܗ‌ܝ ܒܝܵܡܵܐ ܕܣܘܿܦ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","ܠܗ̇ܘ ܕܡܘܼܚܕܸܪܹܗ ܠܥܲܡܹܗ ܓܵܘ ܒܲܪܝܼܵܐ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","ܠܗ̇ܘ ܕܡܚܹܐ ܠܹܗ ܡܲܠܟܹ̈ܐ ܓܘܼܪܹ̈ܐ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","ܘܩܛܝܼܠܔ ܠܹܗ ܡܲܠܟܹ̈ܐ ܥܲܫܝܼܢܹ̈ܐ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","ܠܣܝܼܚܘܿܢ ܡܲܠܟܵܐ ܕܐܵܡܘܿܪ̈ܵܝܹܐ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","ܘܠܥܘܿܓ݂ ܡܲܠܟܵܐ ܕܒܲܝܫܵܢ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","ܘܝܘܼܗܒ݂ܵܐ ܠܹܗ ܐܲܪܥܵܝܗ‌ܝ ܠܝܵܪܬܘܼܬܵ‌ܐ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","ܝܵܪܬܘܼܬܵ‌ܐ ܠܐܝܼܣܪܵܐܹܝܠܔ ܪܹܓܹܗ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","ܕܒܟܘܼܦܘܼܬܲܢ ܕܟ݂ܝܼܪܹܗ ܐܸܠܲܢ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","ܘܦܘܼܪܩܲܚ ܠܹܗ ܡ̣ܢ ܕܸܫ̃ܡܸܢܲܢ̈، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","ܟܹܐ ܝܵܗܒܹܠܔ ܠܲܚܡܵܐ ܠܟܠܔ ܓܵܢܵܐ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","ܫܲܟܪܘܼܢ ܠܐܲܠܵܗܵܐ ܕܫܡܲܝܵܐ، ܣܵܒܵܒ ܠܥܵܠܲܡ ܝܼܠܵܗ̇ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","ܥܲܠܔ ܢܲܗܪ̈ܵܘܵܬܹ‌ܐ ܕܒܵܒܹܠܔ، ܬܵܡܵܐ ܝܬܝܼܒ݂ ܠܲܢ، ܐܘܼܦ ܒܟܹܐ ܠܲܢ، ܟܲܕ ܕܟ݂ܝܼܪܵܐ ܠܲܢ ܨܸܗܝܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","ܥܲܠܔ ܚܹܠܵܦܹ̈ܐ ܕܒܓܵܘܘܼܗ̇، ܬܠܹܐ ܠܲܢ ܟܸܢܵܪ̈ܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","ܒܗ̇ܝ ܕܬܵܡܵܐ ܠܲܒܠܵܢܲܢ̈ ܠܐܲܣܝܼܪܘܼܬܵ‌ܐ ܛܠܝܼܒ ܠܗܘܿܢ ܡܸܢܲܢ ܙܡܵܪ̈ܝܵܬܹ‌ܐ، ܘܓ̰ܲܢܓ̰ܸܪ̈ܵܢܲܢ ܛܠܝܼܒ ܠܗܘܿܢ ܡܸܢܲܢ ܚܲܕܘܼܬܵ‌ܐ، ܒܹܐܡܵܪܵܐ: ”ܙܡܘܿܪܘܼܢ ܐܸܠܲܢ ܡ̣ܢ ܙܡܵܪ̈ܝܵܬܹ‌ܐ ܕܨܸܗܝܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","ܕܵܐܟ݂ܝܼ ܙܵܡܪܲܚ ܙܡܵܪ̈ܝܵܬܹ‌ܐ ܕܡܵܪܝܵܐ، ܥܲܠܔ ܐܲܪܥܵܐ ܢܘܼܟ݂ܪܵܝܬܵ‌ܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","ܐܸܢ ܢܵܫܹܢܵܟ݂ܝ، ܝܵܐ ܐܘܿܪܸܫܠܸܡ، ܢܵܫܝܵܐ ܝܲܡܝܼܢܝܼ ܡܗܝܼܪܘܼܬܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","ܫܵܥܹܐ ܠܸܫܵܢܝܼ ܠܫܵܡܵܟܝܼ، ܐܸܢ ܠܵܐ ܕܵܟ݂ܪܹܢܵܟ݂ܝ، ܐܸܢ ܠܵܐ ܡܲܐܣܩܸܢ ܠܐܘܿܪܸܫܠܸܡ، ܥܸܠܸܠܔ ܡ̣ܢ ܪܹܝܫܵܐ ܕܚܲܕܘܼܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","ܕܟ݂ܘܿܪ، ܝܵܐ ܡܵܪܝܵܐ، ܠܒܢܲܝ̈ ܐܲܕܘܿܡ، ܒܝܵܘܡܵܐ ܕܓܵܠܘܼܬܵ‌ܐ ܕܐܘܿܪܸܫܠܸܡ، ܕܐܡܝܼܪܗܘܿܢ: ”ܬܠܘܿܚܘܼܢ، ܬܠܘܿܚܘܼܢ، ܗܲܠܔ ܫܲܬܐܸܣܬܘܼܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","ܝܵܐ ܒܪܵܬ ܒܵܒܹܠܔ، ܗܕܝܼܪܬܵ‌ܐ ܠܚܪܵܒ݂ܵܐ، ܛܘܼܒ݂ܵܐ ܠܗ̇ܘ ܕܦܵܪܹܥ ܠܵܟ݂ܝ، ܒܦܘܼܪܥܵܢܵܐ ܕܦܪܝܼܥ ܠܵܟ݂ܝ ܐܸܠܲܢ. ");
INSERT INTO aii_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","ܛܘܼܒ݂ܵܐ ܠܗ̇ܘ ܕܕܵܒܹܩ ܘܛܵܪܹܦ ܠܝܵܠܵܕ݇ܟ݂ܝ̈ ܥܲܠܔ ܩܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","ܒܸܬ ܫܲܟܪܸܢܘܼܟ݂ ܒܟܠܹܗ ܠܸܒܝܼ، ܩܲܕܡ ܐܲܠܵܗܹ̈ܐ ܒܸܬ ܙܵܡܪܹܢ ܐܸܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","ܒܸܬ ܣܵܓ݂ܕܹܢ ܠܓܹܒܵܐ ܕܗܲܝܟܠܵܐ ܕܩܘܼܕܫܘܼܟ݂، ܘܒܸܬ ܫܲܟܪܸܢ ܠܫܸܡܘܼܟ݂ ܒܘܼܬ ܛܲܝܒܘܼܬܘܼܟ݂ ܘܒܘܼܬ ܫܲܪܝܼܪܘܼܬܘܼܟ݂، ܣܵܒܵܒ ܓܘܼܪܘܸܣ ܠܘܼܟ݂ ܫܸܡܘܼܟ݂ ܘܗܹܡܸܙܡܵܢܘܼܟ݂ ܥܸܠܸܠܔ ܡ̣ܢ ܟܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","ܩܵܡ ܓ̰ܲܘܸܒܸܬ ܠܝܼ ܒܝܵܘܡܵܐ ܕܩܪܹܐ ܠܝܼ، ܩܵܡ ܝܵܗܒܹܬ ܠܝܼ ܓ̰ܘܼܪܐܲܬ ܒܚܲܝܠܵܐ ܓܵܘ ܓܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","ܒܸܬ ܫܲܟܪܝܼ ܠܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܟܠܵܝܗ‌ܝ ܡܲܠܟܹ̈ܐ ܕܐܲܪܥܵܐ، ܣܵܒܵܒ ܫܡܝܼܥ ܠܗܘܿܢ ܗܹܡܸܙܡܵܢܹ̈ܐ ܕܦܘܼܡܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","ܘܒܸܬ ܙܵܡܪܝܼ ܒܘܼܬ ܐܘܼܪ̈ܚܵܬܹ‌ܐ ܕܡܵܪܝܵܐ، ܣܵܒܵܒ ܓܘܼܪܵܐ ܝܠܹܗ ܐܝܼܩܵܪܵܐ ܕܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","ܘܪܵܡܵܐ ܝܠܹܗ ܡܵܪܝܵܐ ܘܠܟܘܼܦܵܐ ܟܹܐ ܚܵܙܹܐ، ܘܠܪܵܡܵܢܵܐ ܡ̣ܢ ܪܸܚܩܵܐ ܟܹܐ ܝܵܕܹܥ. ");
INSERT INTO aii_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","ܐܸܢ ܚܵܕܪܹܢ ܒܓܵܘܵܐ ܕܥܵܘܩܵܢܵܐ ܒܸܬ ܡܲܚܹܝܬ ܠܝܼ، ܥܲܠܔ ܟܲܪܒܵܐ ܕܕܸܫ̃ܡܸܢܝܼ̈ ܒܸܬ ܦܲܫܛܸܬ ܐܝܼܕܘܼܟ݂، ܘܒܸܬ ܦܲܪܩܵܐ ܠܝܼ ܝܲܡܝܼܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","ܡܵܪܝܵܐ ܒܸܬ ܬܲܡܸܡ ܟܠܔ ܒܘܼܬ ܕܝܼܝܼ، ܡܵܪܝܵܐ ܛܲܝܒܘܼܬܘܼܟ݂ ܠܥܵܠܲܡ ܝܼܠܵܗ̇، ܦܘܼܠܚܵܢܹ̈ܐ ܕܐܝܼܕܵܬܘܼ̈ܟ݂ ܠܵܐ ܪܲܦܹܝܬ. ");
INSERT INTO aii_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","ܝܵܐ ܡܵܪܝܵܐ، ܨܘܼܚܨܝܼܵܐ ܝܘܸܬ ܐܸܠܝܼ ܘܟܹܐ ܝܵܕܥܹܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","ܐܲܢ݇ܬ ܟܹܐ ܝܵܕܥܹܬ ܝܬܵܒ݂ܬ‌ܝܼ ܘܩܝܵܡܬ‌ܝܼ، ܦܘܼܪܡܹܐ ܠܘܼܟ݂ ܚܘܼܫܵܒ݂ܝܼ ܡ̣ܢ ܪܸܚܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","ܐܘܼܪܚܝܼ ܘܕܡܵܟ݂ܬ‌ܝܼ ܬܘܼܦ̮ܬܸܫ ܠܘܼܟ݂، ܘܟܠܵܝܗ‌ܝ ܐܘܼܪ̈ܚܵܬ‌ܝܼ ܟܹܐ ܝܵܕܥܹܬ. ");
INSERT INTO aii_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","ܟܲܕ ܗܸܫ ܠܲܝܬ ܚܲܒܪܵܐ ܒܠܸܫܵܢܝܼ، ܗܵܐ ܐܲܢ݇ܬ، ܝܵܐ ܡܵܪܝܵܐ، ܟܹܐ ܝܵܕܥܹܬ ܠܹܗ ܟܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","ܡ̣ܢ ܒܵܬܪܵܐ ܘܩܲܕܡܵܐ ܩܵܡ ܚܲܪܕܸܬ ܠܝܼ، ܘܩܵܡ ܡܲܬܒܸܬ ܐܝܼܕܘܼܟ݂ ܥܲܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","ܥܓ̰ܝܼܒܬܵ‌ܐ ܝܠܵܗ̇ ܐܵܗܵܐ ܝܕܵܥܬܵ‌ܐ ܩܵܬ‌ܝܼ، ܥܸܠܸܠܔ ܝܼܠܵܗ̇ ܡ̣ܢ ܨܲܠܡܲܢܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","ܠܐܲܝܟܵܐ ܐܵܙܹܠ݇ܢ ܡ̣ܢ ܪܘܼܚܘܼܟ݂، ܘܠܐܲܝܟܵܐ ܥܵܪܩܹܢ ܡ̣ܢ ܦܵܬܘܼܟ݂؟ ");
INSERT INTO aii_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","ܐܸܢ ܐܵܣܩܹܢ ܠܫܡܲܝܵܐ، ܬܵܡܵܐ ܝܘܸܬ ܐܲܢ݇ܬ، ܘܐܸܢ ܫܲܘܹܝܢ ܫܘܝܼܬ‌ܝܼ ܓܵܘ ܫܝܘܿܠܔ، ܗܵܐ، ܬܵܡܵܐ ܝܘܸܬ. ");
INSERT INTO aii_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","ܐܸܢ ܫܵܩܠܹܢ ܓܘܼܠܦܵܢܹ̈ܐ ܕܨܸܡܚܵܐ، ܘܫܵܪܹܝܢ ܒܚܲܪܬܵ‌ܐ ܕܝܵܡܵܐ، ");
INSERT INTO aii_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","ܐܘܼܦ ܬܵܡܵܐ ܐܝܼܕܘܼܟ݂ ܒܸܬ ܡܗܲܕܝܵܐ ܠܝܼ، ܘܝܲܡܝܼܢܘܼܟ݂ ܒܸܬ ܕܵܒ݂ܩܵܐ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","ܘܐܸܢ ܐܵܡܪܹܢ: ”ܒܫܪܵܪܵܐ، ܚܸܫܟܵܐ ܒܸܬ ܟܲܣܹܐ ܠܝܼ، ܘܒܲܗܪܵܐ ܕܥܲܠܝܼ ܒܸܬ ܗܵܘܹܐ ܠܲܝܠܹܐ،“ ");
INSERT INTO aii_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","ܐܘܼܦ ܚܸܫܟܵܐ ܠܹܐ ܝܠܹܗ ܚܸܫܟܵܢܵܐ ܐܸܠܘܼܟ݂، ܘܠܲܝܠܹܐ ܐܲܝܟ݂ ܐܝܼܡܵܡܵܐ ܟܹܐ ܒܲܗܪܸܢ، ܐܲܝܟ݂ ܚܸܫܟܵܐ، ܗܵܕܟ݂ܵܐ ܒܲܗܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","ܒܗ̇ܝ ܕܐܲܢ݇ܬ ܒܪܹܐ ܠܘܼܟ݂ ܠܪܸܥܝܵܢܝܼ، ܩܵܡ ܙܵܩܪܹܬ ܠܝܼ ܒܒܲܛܢܵܐ ܕܝܸܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","ܒܸܬ ܫܲܟܪܸܢܘܼܟ݂ ܒܗ̇ܝ ܕܣܲܗܡܵܢܵܐ ܘܥܓ̰ܝܼܒܵܐ ܦܝܼܫ ܠܝܼ ܥܒ݂ܝܼܕܵܐ، ܥܓ̰ܝܼܒܹ̈ܐ ܝܢܵܐ ܦܘܼܠܚܵܢܘܼ̈ܟ݂، ܘܓܵܢܝܼ ܨܦܵܝܝܼ ܟܹܐ ܝܵܕܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","ܠܵܐ ܦܝܼܫ ܠܗܘܿܢ ܛܸܫܝܹܐ ܓܲܪ̈ܡܝܼ ܡܸܢܘܼܟ݂، ܟܲܕ ܦܝܼܫ ܠܝܼ ܥܒ݂ܝܼܕܵܐ ܒܣܸܬܵܪܵܐ، ܦܝܼܫ ܠܝܼ ܙܩܝܼܪܵܐ ܓܵܘ ܬܲܚ̈ܬܵܝܵܬܹ‌ܐ ܕܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","ܚܙܹܐ ܠܗܘܿܢ ܥܲܝ̈ܢܘܼܟ݂ ܓܒ݂ܝܼܠܬ‌ܝܼ، ܘܓܵܘ ܟܬܵܒ݂ܘܼܟ݂ ܟܠܵܝܗ‌ܝ ܝܵܘܡܵܢܝܼ̈ ܦܝܼܫ ܠܗܘܿܢ ܟܬܝܼܒܹܐ، ܦܝܼܫ ܠܗܘܿܢ ܪܫܝܼܡܹܐ، ܟܲܕ ܠܲܝܬ ܗܘܵܐ ܐܘܼܦ ܚܲܕ ܡܸܢܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","ܘܐܸܠܝܼ ܟܡܵܐ ܡܝܘܼܩܪܹ̈ܐ ܝܢܵܐ ܚܘܼܫܵܒ݂ܘܼ̈ܟ݂، ܝܵܐ ܐܲܠܵܗܵܐ، ܟܡܵܐ ܪܵܒܵܐ ܝܢܵܐ ܡܸܢܝܵܢܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","ܐܸܢ ܡܵܢܹܢܗܘܿܢ ܒܘܼܫ ܒܸܬ ܙܵܝܕܝܼ ܡ̣ܢ ܣܹܠܵܐ، ܟܹܐ ܪܵܥܫܹܢ ܘܗܸܫ ܐܵܢܵܐ ܥܲܡܘܼܟ݂ ܝܼܘܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","ܛܘܼܒ݂ܵܐ ܕܩܵܛܠܹܬ ܠܪ̈ܲܫܝܼܥܹܐ، ܝܵܐ ܐܲܠܵܗܵܐ، ܪܚܘܿܩܘܼܢ ܡܸܢܝܼ، ܝܵܐ ܫܲܦܟ݂ܵܢܹ̈ܐ ܕܕܸܡܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","ܟܹܐ ܗܲܡܙܸܡܝܼ ܒܘܼܬ ܕܝܼܘܼܟ݂ ܒܥܵܘܠܵܐ، ܕܸܫ̃ܡܸܢܘܼ̈ܟ݂ ܟܹܐ ܫܵܩܠܝܼ ܫܸܡܘܼܟ݂ ܒܣܪܝܼܩܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","ܗܵܐ، ܠܹܐ ܣܵܢܹܝܢ ܠܣܵܢܝܵܢܘܼ̈ܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܘܠܹܐ ܓܲܢܓܸܙܸܢ ܡ̣ܢ ܩܵܝܡܵܢܹ̈ܐ ܕܕܲܠܩܘܼܒ݂ܠܘܼܟ݂؟ ");
INSERT INTO aii_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","ܣܢܵܝܬܵ‌ܐ ܓܡܝܼܪܬܵ‌ܐ ܟܹܐ ܣܵܢܹܢܗܘܿܢ، ܗܘܹܐ ܠܗܘܿܢ ܐܸܠܝܼ ܕܸܫ̃ܡܸܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","ܨܲܚܨܝܼ ܠܝܼ، ܝܵܐ ܐܲܠܵܗܵܐ، ܘܝܕܹܥ ܠܸܒܝܼ، ܬܲܦ̮ܬܸܫ ܠܝܼ ܘܝܕܹܥ ܚܲܡܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","ܘܚܙܝܼ ܐܸܢ ܐܝܼܬ ܒܝܼܝܼ ܡܸܢܕܝܼ ܥܲܓ̰ܸܙܵܢܵܐ ܩܵܬܘܼܟ݂، ܘܡܗܲܕܝܼ ܠܝܼ ܒܐܘܼܪܚܵܐ ܕܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","ܦܲܨܝܼ ܠܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܡ̣ܢ ܒܲܪܢܵܫܵܐ ܒܝܼܫܵܐ، ܡ̣ܢ ܐܢܵܫܹ̈ܐ ܛܵܠܘܿܡܹ̈ܐ ܢܵܛܪܹܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","ܐܵܢܝܼ ܕܚܫܝܼܒ݂ ܠܗܘܿܢ ܒܝܼܫܵܬܹ̈‌ܐ ܒܠܸܒܵܝܗ‌ܝ، ܒܟܠܹܗ ܝܵܘܡܵܐ ܟܹܐ ܚܲܦܛܝܼ ܦܠܵܫܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","ܡܘܼܚܪܸܦ ܠܗܘܿܢ ܠܸܫܵܢܵܝܗ‌ܝ ܐܲܝܟ݂ ܚܘܼܘܹܐ، ܣܲܡܵܐ ܕܐܸܣܦܸܣ ܬܚܘܿܬ ܣܸܦܘܵܬܵܝ̈ܗ‌ܝ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","ܢܛܘܿܪܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܡ̣ܢ ܐܝܼܕܵܬܹ̈‌ܐ ܕܪ̈ܲܫܝܼܥܹܐ، ܡ̣ܢ ܐܢܵܫܹ̈ܐ ܛܵܠܘܿܡܹ̈ܐ ܢܵܛܪܹܬ ܠܝܼ، ܐܵܢܝܼ ܕܚܫܝܼܒ݂ ܠܗܘܿܢ ܠܬܲܪܩܘܼܠܹܐ ܦܵܣܘܿܥܝܵܬ‌ܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","ܛܘܼܡܸܪܗܘܿܢ ܫܲܒ݂ܗܸܪ̈ܵܢܹܐ ܢܸܫܒ݂ܵܐ ܐܸܠܝܼ، ܘܒܚܲܒ݂ܠܹ̈ܐ ܦܪܝܼܣ ܠܗܘܿܢ ܓܲܪܕܵܐ ܥܲܠܔ ܐܘܼܪܚܝܼ، ܦܲܚܹ̈ܐ ܨܘܼܠܹܐ ܠܗܘܿܢ ܐܸܠܝܼ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","ܐܡܝܼܪܝܼ ܠܡܵܪܝܵܐ: ”ܐܲܠܵܗ‌ܝܼ ܝܘܸܬ ܐܲܢ݇ܬ، ܗܲܒ݂ܠܔ ܢܵܬܵ‌ܐ، ܝܵܐ ܡܵܪܝܵܐ، ܠܩܵܠܵܐ ܕܢܵܘܢܲܝܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","”ܡܵܪܝܵܐ ܐܲܠܵܗܵܐ، ܚܲܝܠܵܐ ܕܦܘܼܪܩܵܢܝܼ، ܟܘܼܣܹܐ ܠܘܼܟ݂ ܪܹܝܫܝܼ ܒܝܵܘܡܵܐ ܕܦܠܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","”ܠܵܐ ܝܵܗܒܹܬ، ܝܵܐ ܡܵܪܝܵܐ، ܫܲܗܘܲܬܝܵܬܹ̈‌ܐ ܕܪ̈ܲܫܝܼܥܹܐ، ܢܝܼܫܵܝܗ‌ܝ ܠܵܐ ܫܵܒ݂ܩܹܬ ܦܵܠܹܛ ܒܪܹܝܫܵܐ ܕܠܵܐ ܪܵܝܡܝܼ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","”ܪܹܝܫܵܐ ܕܚܲܪ̈ܕܝܼܵܢܝܼ ܦܵܐܹܫ ܟܘܼܣܝܵܐ ܒܦܸܠܡܵܐ ܕܣܸܦܘܵܬܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","”ܫܒ݂ܘܿܩ ܨܵܠܝܼ ܥܲܠܵܝܗ‌ܝ ܓܘܼܡܪܹ̈ܐ، ܓܵܘ ܢܘܼܪܵܐ ܦܵܝܫܝܼ ܡܘܼܢܦܸܠܔ ܠܹܗ، ܓܵܘ ܥܘܼܡܩܹ̈ܐ، ܕܠܵܐ ܩܵܝܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","”ܕܵܪܝܵܢܵܐ ܕܒܘܼܚܬܵܢ ܠܹܐ ܩܵܘܹܐ ܒܐܲܪܥܵܐ، ܐܢܵܫܵܐ ܛܵܠܘܿܡܵܐ ܒܝܼܫܬܵ‌ܐ ܒܸܬ ܨܵܝܕܵܐ ܠܹܗ ܒܓ̰ܲܠܕܘܼܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","ܟܹܐ ܝܵܕܥܹܢ ܕܒܸܬ ܥܵܒܹܕ ܡܵܪܝܵܐ ܕܝܼܢܵܐ ܕܡܘܼܠܝܸܨܹ̈ܐ، ܕܝܼܘܵܢ ܕܡܸܣܟܹܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","ܒܫܪܵܪܵܐ، ܙܲܕܝܼܩܹ̈ܐ ܒܸܬ ܫܲܟܪܝܼ ܠܫܸܡܘܼܟ݂، ܒܸܬ ܝܵܬܒ݂ܝܼ ܬܪ̈ܘܼܨܹܐ ܩܲܕܡ ܦܵܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","ܝܵܐ ܡܵܪܝܵܐ، ܩܪܹܐ ܠܝܼ ܐܸܠܘܼܟ݂، ܡܲܠܝܸܙ ܠܟܸܣܠܝܼ، ܗܲܒ݂ܠܔ ܢܵܬܵ‌ܐ ܠܩܵܠܝܼ ܟܲܕ ܩܵܪܹܝܢ ܐܸܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","ܗܵܘܝܵܐ ܨܠܘܿܬ‌ܝܼ ܐܲܝܟ݂ ܒܸܣܡܵܐ ܩܲܕܡܘܼܟ݂، ܡܲܪܲܡܬܵ‌ܐ ܕܐܝܼܕܵܬ‌ܝܼ̈ ܐܲܝܟ݂ ܩܘܼܪܒܵܢܵܐ ܕܪܲܡܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","ܝܵܐ ܡܵܪܝܵܐ، ܡܲܬܸܒ݂ ܢܛܵܪܬܵ‌ܐ ܠܦܘܼܡܝܼ، ܢܛܘܿܪ ܠܬܲܪܥܵܐ ܕܣܸܦܘܵܬ‌ܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","ܠܵܐ ܫܵܒ݂ܩܹܬ ܦܵܬܹܠܔ ܠܸܒܝܼ ܠܗܹܡܸܙܡܵܢ ܒܝܼܫܬܵ‌ܐ، ܠܸܥܒ݂ܵܕܵܐ ܥܒ݂ܵܕܹ̈ܐ ܒܪܲܫܝܼܥܘܼܬܵ‌ܐ، ܥܲܡ ܦܵܠܚܵܢܹ̈ܐ ܕܥܵܘܠܵܐ، ܘܠܵܐ ܫܵܒ݂ܩܹܬ ܐܵܟ݂ܠܹܢ ܡ̣ܢ ܛܲܥܡܵܬܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","ܫܒ݂ܘܿܩ ܡܵܚܹܐ ܠܝܼ ܙܲܕܝܼܩܵܐ، ܛܲܝܒܘܼܬܵ‌ܐ ܝܠܵܗ̇ ܐܵܗܵܐ، ܘܡܲܢܟܸܣ ܠܝܼ، ܡܸܫܚܵܐ ܕܪܹܝܫܵܐ ܝܠܹܗ، ܠܵܐ ܡܲܚܦܸܠܔ ܪܹܝܫܝܼ، ܒܗ̇ܝ ܕܗܸܫ ܨܠܘܿܬ‌ܝܼ ܕܲܠܩܘܼܒ݂ܠܔ ܕܒܝܼܫܵܬܵܝ̈ܗ‌ܝ ܝܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","ܟܲܕ ܦܵܝܫܝܼ ܪܘܼܦܝܹܐ ܒܕܸܦܢܵܬܹ̈‌ܐ ܕܩܵܝܵܐ ܕܲܝܵܢܵܝ̈ܗ‌ܝ، ܒܸܬ ܫܵܡܥܝܼ ܗܹܡܸܙܡܵܢܝܼ̈ ܒܗ̇ܝ ܕܒܲܣܝܼܡܹ̈ܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","ܐܲܝܟ݂ ܛܵܪܝܵܢܵܐ ܕܦܕܵܢܵܐ ܕܛܵܪܹܐ ܠܵܗ̇ ܐܲܪܥܵܐ، ܗܵܕܟ݂ܵܐ ܦܝܼܫ ܠܗܘܿܢ ܒܘܼܪܒܸܙܹܐ ܓܲܪ̈ܡܲܢ ܥܲܠܔ ܦܘܼܡܵܐ ܕܫܝܘܿܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","ܐܝܼܢܵܐ ܥܲܝܢܝܼ̈ ܐܸܠܘܼܟ݂ ܝܼܢܵܐ، ܝܵܐ ܡܵܪܝܵܐ ܐܲܠܵܗܵܐ، ܒܝܼܘܼܟ݂ ܫܩܝܼܠܔ ܠܝܼ ܓܵܘܣܵܐ، ܠܵܐ ܫܵܒ݂ܩܹܬ ܠܵܗ̇ ܓܵܢܝܼ ܒܠܵܐ ܢܛܵܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","ܢܛܘܿܪܝܼ ܡ̣ܢ ܦܲܚܹ̈ܐ ܕܡܘܼܬܸܒ݂ ܠܗܘܿܢ ܐܸܠܝܼ، ܘܡ̣ܢ ܢܸܫܒ݂ܵܐ ܕܦܵܠܚܵܢܹ̈ܐ ܕܥܵܘܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","ܢܵܦܠܝܼ ܪ̈ܲܫܝܼܥܹܐ ܥܲܡ ܚܕܵܕܹ̈ܐ ܒܓܲܪܕܵܝܗ‌ܝ، ܗܲܠܔ ܕܐܵܢܵܐ ܥܵܒ݂ܪܹܢ. ");
INSERT INTO aii_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","ܒܩܵܠܝܼ ܠܡܵܪܝܵܐ ܟܹܐ ܡܲܩܘܸܚܸܢ، ܒܩܵܠܝܼ ܠܡܵܪܝܵܐ ܟܹܐ ܦܲܪܦܸܠܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","ܟܹܐ ܫܲܦܟܸܢ ܩܲܕܡܘܼܗ‌ܝ ܩܒ݂ܵܠܬ‌ܝܼ. ܥܵܘܩܵܢܝܼ ܩܲܕܡܘܼܗ‌ܝ ܟܹܐ ܡܲܕܥܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","ܟܲܕ ܒܓܵܘܝܼ ܕܘܼܪܕܸܫ̃ ܠܵܗ̇ ܪܘܼܚܝܼ، ܐܲܢ݇ܬ ܟܹܐ ܝܵܕܥܹܬ ܠܹܗ ܫܒ݂ܝܼܠܝܼ، ܒܐܘܼܪܚܵܐ ܕܟܹܐ ܚܵܕܪܹܢ، ܛܘܼܫܹܐ ܠܗܘܿܢ ܢܸܫܒ݂ܵܐ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","ܚܘܼܪ ܠܝܲܡܝܼܢܵܐ، ܘܚܙܝܼ ܕܠܲܝܬ ܠܝܼ ܝܵܕܥܵܢܵܐ، ܛܠܝܼܩ ܠܵܗ̇ ܡܸܢܝܼ ܕܘܼܟܬܵ‌ܐ ܕܥܪܵܩܬܵ‌ܐ، ܠܲܝܬ ܒܲܩܪܵܢܵܐ ܒܘܼܬ ܓܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","ܡܘܼܩܘܸܚ ܠܝܼ ܠܟܸܣܠܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܐܡܝܼܪܝܼ: ܐܲܢ݇ܬ ܝܼܘܸܬ ܒܹܝܬ ܓܵܘܣܝܼ، ܣܵܗܡܝܼ ܒܐܲܪܥܵܐ ܕܚܲܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","ܨܘܼܬ ܠܓܥܵܝܬ‌ܝܼ ܒܗ̇ܝ ܕܦܝܼܫ ܠܝܼ ܡܘܼܟܸܦܵܐ ܪܵܒܵܐ، ܦܲܨܝܼ ܠܝܼ ܡ̣ܢ ܢܵܦܠܵܢܹ̈ܐ ܒܵܬܪܝܼ ܒܗ̇ܝ ܕܒܘܼܫ ܚܲܝܠܵܢܹ̈ܐ ܝܢܵܐ ܡܸܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","ܦܲܠܸܛ ܠܵܗ̇ ܓܵܢܝܼ ܡ̣ܢ ܒܹܝܬ ܚܒ݂ܘܼܫܝܵܐ ܕܫܲܟܪܸܢ ܠܫܸܡܘܼܟ݂، ܠܚܵܕܸܪ̈ܘܵܢܝܼ ܒܸܬ ܟܵܪܟ݂ܝܼ ܙܲܕܝܼܩܹ̈ܐ، ܒܗ̇ܝ ܕܒܦܸܪܝܘܼܬܵ‌ܐ ܒܸܬ ܦܵܪܥܹܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","ܝܵܐ ܡܵܪܝܵܐ، ܫܡܹܥ ܨܠܘܿܬ‌ܝܼ، ܗܲܒ݂ܠܔ ܢܵܬܵ‌ܐ ܠܢܵܘܢܲܝܬ‌ܝܼ، ܒܡܗܘܼܡܢܘܼܬܘܼܟ݂ ܓ̰ܲܘܸܒ ܠܝܼ، ܒܙܲܕܝܼܩܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","ܘܠܵܐ ܡܲܥܒܸܪܸܬ ܠܹܗ ܪܹܓܘܼܟ݂ ܠܕܝܵܢܬܵ‌ܐ، ܣܵܒܵܒ ܠܹܐ ܝܠܹܗ ܙܲܕܝܼܩܵܐ ܩܲܕܡܘܼܟ݂ ܟܠܔ ܐܢܵܫܵܐ ܚܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","ܒܗ̇ܝ ܕܢܦܝܼܠܔ ܠܹܗ ܕܸܫ̃ܡܸܢ ܒܵܬܪ ܓܵܢܝܼ، ܛܒ݂ܝܼܚ ܠܹܗ ܠܐܲܪܥܵܐ ܚܲܝܝܼ̈، ܩܵܡ ܡܲܬܸܒ݂ ܠܝܼ ܒܕܘܼܟܵܢܹ̈ܐ ܚܸܫܟܵܢܹ̈ܐ ܐܲܝܟ݂ ܡܝܼ̈ܬܹ‌ܐ ܕܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","ܘܕܘܼܪܕܸܫ̃ܬܵ‌ܐ ܝܠܵܗ̇ ܒܓܵܘܝܼ ܪܘܼܚܝܼ، ܒܓܵܘܝܼ ܫܓ݂ܝܼܫܵܐ ܝܠܹܗ ܠܸܒܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","ܕܟ݂ܝܼܪܝܼ ܠܝܵܘܡܵܢܹ̈ܐ ܩܲܕܝܼܡܵܝܹ̈ܐ، ܗܘܼܓܹܐ ܠܝܼ ܒܘܼܬ ܟܠܵܝܗ‌ܝ ܦܘܼܠܚܵܢܘܼ̈ܟ݂، ܒܘܼܬ ܥܒ݂ܵܕܹ̈ܐ ܕܐܝܼܕܵܬܘܼ̈ܟ݂ ܬܘܼܚܡܸܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","ܦܘܼܫܸܛ ܠܝܼ ܐܝܼܕܵܬ‌ܝܼ̈ ܠܟܸܣܠܘܼܟ݂، ܓܵܢܝܼ ܨܗܝܼܬܵ‌ܐ ܝܠܵܗ̇ ܐܸܠܘܼܟ݂ ܐܲܝܟ݂ ܐܲܪܥܵܐ ܒܪܝܼܙܬܵ‌ܐ. ܣܹܠܵܗ ");
INSERT INTO aii_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","ܡܲܠܝܸܙ ܓ̰ܲܘܸܒ ܠܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܬܝܼܡ ܠܵܗ̇ ܪܘܼܚܝܼ، ܠܵܐ ܛܲܫܹܝܬ ܦܵܬܘܼܟ݂ ܡܸܢܝܼ، ܐܸܠܵܐ ܒܸܬ ܗܵܘܹܝܢ ܕܘܼܡܝܵܐ ܠܨܵܠܝܵܢܹ̈ܐ ܕܓܘܼܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","ܡܲܫܡܸܥ ܠܝܼ ܒܨܲܦܪܵܐ ܛܲܝܒܘܼܬܘܼܟ݂، ܣܵܒܵܒ ܒܝܼܘܼܟ݂ ܦܝܼܫ ܠܝܼ ܒܣܲܒ݂ܪܵܐ، ܡܲܕܸܥ ܠܝܼ ܐܘܼܪܚܵܐ ܕܐܵܙܹܠ݇ܢ، ܒܗ̇ܝ ܕܐܸܠܘܼܟ݂ ܡܘܼܪܡܵܐ ܠܝܼ ܓܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","ܦܲܨܝܼ ܠܝܼ ܡ̣ܢ ܕܸܫ̃ܡܸܢܝܼ̈، ܝܵܐ ܡܵܪܝܵܐ، ܠܟܸܣܠܘܼܟ݂ ܛܘܼܫܝܘܼܗ̇ ܝܘܸܢ ܓܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","ܡܲܠܸܦ ܠܝܼ ܠܸܥܒ݂ܵܕܵܐ ܨܸܒ݂ܝܵܢܘܼܟ݂، ܒܗ̇ܝ ܕܐܲܢ݇ܬ ܝܼܘܸܬ ܐܲܠܵܗ‌ܝܼ، ܪܘܼܚܘܼܟ݂ ܛܵܒ݂ܵܐ ܡܗܲܕܹܐ ܠܝܼ ܒܐܲܪܥܵܐ ܬܪܘܼܨܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","ܒܘܼܬ ܫܸܡܘܼܟ݂ ܡܲܚܹܝܬ ܠܝܼ، ܝܵܐ ܡܵܪܝܵܐ، ܒܙܲܕܝܼܩܘܼܬܘܼܟ݂ ܦܲܠܛܸܬ ܓܵܢܝܼ ܡ̣ܢ ܐܘܼܠܨܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","ܘܒܛܲܝܒܘܼܬܘܼܟ݂ ܡܲܫܬܸܩܸܬ ܠܕܸܫ̃ܡܸܢܝܼ̈، ܘܛܲܠܩܸܬ ܠܟܠܵܝܗ‌ܝ ܡܲܠܝܸܨܵܢܹ̈ܐ ܕܓܵܢܝܼ، ܒܗ̇ܝ ܕܪܹܓܘܼܟ݂ ܝܼܘܸܢ ܐܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","ܒܪܝܼܟ݂ܵܐ ܝܠܹܗ ܡܵܪܝܵܐ ܐܝܼܨܵܪܝܼ، ܕܡܘܼܠܦܵܝ ܠܹܗ ܐܝܼܕܵܬ‌ܝܼ̈ ܠܩܪܵܒ݂ܵܐ، ܘܨܸܒܥܵܬ‌ܝܼ̈ ܠܦܠܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","ܛܲܝܒܘܼܬ‌ܝܼ ܘܚܸܣܢܝܼ، ܒܹܝܬ ܓܵܘܣܝܼ ܘܦܲܨܝܵܢܝܼ، ܡܵܛܵܠܝܼ ܕܒܝܼܹܗ ܫܩܝܼܠܔ ܠܝܼ ܓܵܘܣܵܐ، ܙܲܒܛܸܢܵܢܵܐ ܕܥܲܡܡܹ̈ܐ ܬܚܘܿܬ ܐܝܼܕܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","ܝܵܐ ܡܵܪܝܵܐ، ܡܘܼܕܝܼ ܝܠܹܗ ܐܢܵܫܵܐ ܕܝܵܕܥܹܬ ܠܹܗ؟ ܒܲܪܢܵܫܵܐ ܕܚܵܫܒܹܬ ܠܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","ܐܢܵܫܵܐ ܠܢܫܲܡܬܵ‌ܐ ܟܹܐ ܕܵܡܹܐ، ܝܵܘܡܵܢܘܼ̈ܗ‌ܝ ܐܲܝܟ݂ ܛܸܠܵܢܝܼܬܵ‌ܐ ܥܵܒ݂ܪܵܢܬܵ‌ܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","ܝܵܐ ܡܵܪܝܵܐ، ܡܲܟܸܦ ܫܡܲܝܘܼ̈ܟ݂ ܘܨܠܝܼ، ܕܩܘܿܪ ܒܛܘܼܪ̈ܵܢܹܐ ܕܬܲܢܬܸܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","ܡܲܒܪܸܩ ܒܸܪܩܵܐ ܘܒܲܪܒܸܙ ܠܗܘܿܢ، ܫܲܕܸܪ ܓܹܐܪ̈ܘܼܟ݂ ܘܚܒ݂ܘܿܛ ܠܵܗ̇ ܥܲܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","ܦܲܫܸܛ ܐܝܼܕܘܼ̈ܟ݂ ܡ̣ܢ ܡܪܵܘܡܵܐ، ܦܲܨܝܼ ܠܝܼ ܘܦܲܪܸܩ ܠܝܼ ܡ̣ܢ ܡ̈ܝܼܵܐ ܪܵܒܵܐ، ܡ̣ܢ ܐܝܼܕܵܐ ܕܢܘܼܟ݂ܪ̈ܵܝܹܐ، ");
INSERT INTO aii_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","ܐܲܝܢܝܼ ܕܦܘܼܡܵܝܗ‌ܝ ܟܹܐ ܗܲܡܙܸܡ ܒܲܛܝܼܠܘܼܬܵ‌ܐ، ܘܝܲܡܝܼܢܵܝܗ‌ܝ ܝܲܡܝܼܢܵܐ ܕܕܘܼܓܠܵܐ ܝܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","ܝܵܐ ܐܲܠܵܗܵܐ، ܙܡܵܪܬܵ‌ܐ ܚܲܕܬܵ‌ܐ ܒܸܬ ܙܵܡܪܹܢ ܐܸܠܘܼܟ݂، ܒܩܝܼܬܵܪܵܐ ܕܥܸܣܪܵܐ ܣܝܼܡܹ̈ܐ ܒܸܬ ܫܲܒܚܸܢ ܐܸܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","ܗ̇ܘ ܕܟܹܐ ܝܵܗܒܹܠܔ ܦܘܼܪܩܵܢܵܐ ܠܡܲܠܟܹ̈ܐ، ܕܟܹܐ ܦܲܨܹܐ ܠܕܵܘܝܼܕ ܪܹܓܹܗ ܡ̣ܢ ܣܲܝܦܵܐ ܒܝܼܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","ܦܲܨܝܼ ܠܝܼ ܘܦܲܪܸܩ ܠܝܼ ܡ̣ܢ ܐܝܼܕܵܐ ܕܢܘܼܟ݂ܪ̈ܵܝܹܐ، ܐܲܝܢܝܼ ܕܦܘܼܡܵܝܗ‌ܝ ܟܹܐ ܗܲܡܙܸܡ ܒܲܛܝܼܠܘܼܬܵ‌ܐ، ܘܝܲܡܝܼܢܵܝܗ‌ܝ ܝܲܡܝܼܢܵܐ ܕܕܘܼܓܠܵܐ ܝܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","ܗ̇ܝܓܵܗ ܒܢܘܿܢܲܢ̈ ܒܥܠܲܝܡܘܼܬܵܝܗ‌ܝ ܒܸܬ ܗܵܘܝܼ ܐܲܝܟ݂ ܢܨܝܼܒ݂ܝܵܬܹ̈‌ܐ ܒܓ̰ܝܼܪܹ̈ܐ، ܒܢܵܬܲܢ̈ ܐܲܝܟ݂ ܥܲܡܘܼܕܹ̈ܐ ܦܪ̈ܝܼܡܹܐ ܕܩܘܼܪ̈ܢܝܼܵܬܹ‌ܐ ܓܵܘ ܒܸܢܝܵܢܵܐ ܕܩܲܨܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","ܐܲܢܒܵܪ̈ܲܢ ܒܸܬ ܗܵܘܝܼ ܡܸܠܝܹ̈ܐ، ܦܲܠܘܼܛܹܐ ܡ̣ܢ ܟܠܔ ܬܘܼܚܡܵܐ، ܥܸܪ̈ܒܲܢ ܒܸܬ ܝܵܠܕܝܼ ܒܐܲܠܦܹ̈ܐ، ܒܝܼܠܵܕܵܐ ܪܸ̈ܒܘܵܬܹ‌ܐ ܒܥܵܠܘܿܠܵܢܲܢ̈. ");
INSERT INTO aii_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","ܬܵܘܸܪ̈ܝܵܬܲܢ ܒܸܬ ܗܵܘܝܼ ܒܛܝܼܢܹܐ، ܠܹܐ ܗܵܘܹܐ ܬܪܵܥܬܵ‌ܐ ܕܫܘܼܪܵܐ، ܘܠܵܐ ܠܲܒܲܠܬܵ‌ܐ ܠܓܵܠܘܼܬܵ‌ܐ، ܘܠܹܐ ܗܵܘܝܵܐ ܡܲܩܘܲܚܬܵ‌ܐ ܒܫܘܼܩܲܢ̈. ");
INSERT INTO aii_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","ܛܘܼܒ݂ܵܐ ܠܥܲܡܵܐ ܕܗܵܕܟ݂ܵܐ ܝܠܵܗ̇ ܐܸܠܹܗ، ܛܘܼܒ݂ܵܐ ܠܥܲܡܵܐ ܕܡܵܪܝܵܐ ܝܠܹܗ ܐܲܠܵܗܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","ܒܸܬ ܡܲܪܡܸܢܘܼܟ݂، ܝܵܐ ܐܲܠܵܗ‌ܝܼ ܡܲܠܟܵܐ، ܘܒܸܬ ܒܲܪܟܸܢ ܫܸܡܘܼܟ݂ ܠܥܵܠܲܡ ܥܵܠܡܝܼܢ. ");
INSERT INTO aii_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","ܒܟܠܔ ܝܘܿܡ ܒܸܬ ܒܲܪܟܸܢܘܼܟ݂، ܘܒܸܬ ܫܲܒܚܸܢ ܠܫܸܡܘܼܟ݂ ܠܥܵܠܲܡ ܥܵܠܡܝܼܢ. ");
INSERT INTO aii_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","ܓܘܼܪܵܐ ܝܠܹܗ ܡܵܪܝܵܐ ܘܡܫܘܼܒܚܵܐ ܪܵܒܵܐ، ܘܠܓܘܼܪܘܼܬܹܗ ܠܲܝܬ ܨܲܚܨܲܝܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","ܕܵܪܵܐ ܒܸܬ ܫܲܒܸܚ ܦܘܼܠܚܵܢܘܼ̈ܟ݂ ܠܕܵܪܵܐ، ܘܓܲܒܵܪ̈ܘܼܝܵܬܘܼܟ݂ ܒܸܬ ܡܲܕܥܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","ܠܣܸܩܠܵܐ ܕܚܸܩܪܵܐ ܕܫܘܼܒ݂ܚܘܼܟ݂، ܘܥܒ݂ܵܕܘܼ̈ܟ݂ ܡܲܥܓ̰ܸܒܵܢܹ̈ܐ ܒܸܬ ܗܲܓܹܝܢ. ");
INSERT INTO aii_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","ܘܒܘܼܬ ܚܲܝܠܵܐ ܕܥܒ݂ܵܕܘܼ̈ܟ݂ ܣܲܗܡܵܢܹ̈ܐ ܒܸܬ ܐܵܡܪܝܼ، ܘܓܘܼܪܘܼܬܘܼܟ݂ ܒܸܬ ܗܲܩܹܝܢ. ");
INSERT INTO aii_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","ܕܟ݂ܵܪܵܐ ܕܦܸܪܝܘܼܬܵ‌ܐ ܕܛܵܒ݂ܘܼܬܘܼܟ݂ ܒܸܬ ܬܲܢܝܼ، ܘܙܲܕܝܼܩܘܼܬܘܼܟ݂ ܒܸܬ ܡܲܩܘܸܚܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","ܚܲܢܵܢܵܐ ܝܠܹܗ ܘܡܪܲܚܡܵܢܵܐ ܡܵܪܝܵܐ، ܝܲܪܝܼܟ݂ܬܵ‌ܐ ܒܹܐܢܹܗ ܘܓܘܼܪܬܵ‌ܐ ܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","ܛܵܒ݂ܵܐ ܝܠܹܗ ܡܵܪܝܵܐ ܠܟܠܵܝܗ‌ܝ، ܘܪ̈ܲܚܡܘܼܗ‌ܝ ܥܲܠܔ ܟܠܵܝܗ‌ܝ ܦܘܼܠܚܵܢܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","ܒܸܬ ܫܲܟܪܝܼ ܠܘܼܟ݂، ܝܵܐ ܡܵܪܝܵܐ، ܟܠܵܝܗ‌ܝ ܦܘܼܠܚܵܢܘܼ̈ܟ݂، ܘܡܗܘܼܡܢܘܼ̈ܟ݂ ܒܸܬ ܒܲܪܟ݂ܝܼ ܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","ܒܘܼܬ ܚܸܩܪܵܐ ܕܡܲܠܟܘܼܬܘܼܟ݂ ܒܸܬ ܐܵܡܪܝܼ، ܘܓܲܒܵܪܘܼܬܘܼܟ݂ ܒܸܬ ܗܲܡܙܸܡܝܼ، ");
INSERT INTO aii_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","ܠܡܲܕܘܼܥܹܐ ܠܒܢܲܝ̈ܢܵܫܵܐ ܓܲܒܵܪ̈ܘܼܝܵܬܘܼܟ݂، ܘܚܸܩܪܵܐ ܕܣܸܩܠܵܐ ܕܡܲܠܟܘܼܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","ܡܲܠܟܘܼܬܘܼܟ݂ ܡܲܠܟܘܼܬܵ‌ܐ ܥܵܠܡܝܼܢܵܝܬܵ‌ܐ ܝܠܵܗ̇، ܘܫܘܼܠܛܵܢܘܼܟ݂ ܒܟܠܔ ܕܵܪܵܐ ܘܕܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","ܟܹܐ ܣܵܢܹܕ ܡܵܪܝܵܐ ܠܟܠܵܝܗ‌ܝ ܢܵܦܠܵܢܹ̈ܐ، ܘܟܹܐ ܡܲܩܸܡ ܠܟܠܵܝܗ‌ܝ ܛܥܝܼ̈ܦܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","ܥܲܝ̈ܢܹܐ ܕܟܠܵܝܗ‌ܝ ܐܸܠܘܼܟ݂ ܟܹܐ ܣܵܦܪܝܼ، ܘܐܲܢ݇ܬ ܟܹܐ ܝܵܗܒܹܬ ܠܗܘܿܢ ܡܹܐܟ݂ܘܼܠܬܵܝܗ‌ܝ ܒܥܕܵܢܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","ܟܹܐ ܦܵܬܚܹܬ ܐܝܼܕܘܼܟ݂، ܘܟܹܐ ܡܲܣܒܸܥܸܬ ܠܨܸܒ݂ܝܵܢܵܐ ܕܟܠܔ ܚܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","ܙܲܕܝܼܩܵܐ ܝܠܹܗ ܡܵܪܝܵܐ ܒܟܠܵܝܗ‌ܝ ܐܘܼܪ̈ܚܵܬܘܼܗ‌ܝ، ܘܡܗܘܼܡܢܵܐ ܒܟܠܵܝܗ‌ܝ ܦܘܼܠܚܵܢܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","ܩܘܼܪܒܵܐ ܝܠܹܗ ܡܵܪܝܵܐ ܠܟܠܵܝܗ‌ܝ ܩܵܪ̈ܝܵܢܘܼܗ‌ܝ، ܠܟܠܔ ܡ̇ܢ ܕܩܵܪܹܐ ܠܹܗ ܒܫܲܪܝܼܪܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","ܨܸܒ݂ܝܵܢܵܐ ܕܙܕܝܼܥܘܼ̈ܗ‌ܝ ܟܹܐ ܥܵܒܹܕ، ܘܡܲܩܘܲܚܬܵܝܗ‌ܝ ܟܹܐ ܫܵܡܹܥ، ܘܟܹܐ ܦܲܪܸܩ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","ܟܹܐ ܢܵܛܹܪ ܡܵܪܝܵܐ ܠܟܠܵܝܗ‌ܝ ܡܲܚܸܒܵܢܘܼ̈ܗ‌ܝ، ܐܝܼܢܵܐ ܠܟܠܵܝܗ‌ܝ ܪ̈ܲܫܝܼܥܹܐ ܒܸܬ ܛܲܠܸܩ. ");
INSERT INTO aii_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","ܬܸܫܒܘܿܚܬܵ‌ܐ ܕܡܵܪܝܵܐ ܒܸܬ ܗܲܡܙܸܡ ܦܘܼܡܝܼ، ܘܒܸܬ ܒܲܪܟ݂ܵܐ ܟܠܔ ܓܵܢܵܐ ܫܸܡܵܐ ܕܩܘܼܕܫܹܗ ܠܥܵܠܲܡ ܥܵܠܡܝܼܢ. ");
INSERT INTO aii_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","ܗܲܠܸܠܘܼܝܵܐ، ܫܲܒܸܚܝ، ܝܵܐ ܓܵܢܝܼ، ܠܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","ܒܸܬ ܫܲܒܚܸܢ ܠܡܵܪܝܵܐ ܒܚܲܝܝܼ̈، ܒܸܬ ܙܵܡܪܹܢ ܠܐܲܠܵܗ‌ܝܼ ܟܡܵܐ ܕܝܼܘܸܢ. ");
INSERT INTO aii_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","ܠܵܐ ܣܵܒܪܝܼܬܘܿܢ ܒܢܲܨܝܼܚܹ̈ܐ، ܒܒܲܪܢܵܫܵܐ ܕܠܲܝܬ ܒܐܝܼܕܹܗ ܦܘܼܪܩܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","ܟܹܐ ܦܵܠܛܵܐ ܪܘܼܚܹܗ، ܟܹܐ ܕܵܐܹܪ ܠܥܲܦܪܹܗ، ܒܗ̇ܘ ܝܵܘܡܵܐ ܟܹܐ ܛܵܠܩܝܼ ܚܘܼܫܵܒ݂ܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","ܛܘܼܒ݂ܵܐ ܠܡ̇ܢ ܕܐܲܠܵܗܵܐ ܕܝܲܥܩܘܿܒ݂ ܝܼܠܹܗ ܠܗܲܝܲܪܬܹܗ، ܕܣܲܒ݂ܪܹܗ ܥܲܠܔ ܡܵܪܝܵܐ ܐܲܠܵܗܹܗ، ");
INSERT INTO aii_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","ܥܵܒ݂ܕܵܢܵܐ ܕܫܡܲܝܵܐ ܘܐܲܪܥܵܐ، ܝܵܡܵܐ ܘܟܠܔ ܕܐܝܼܬ ܓܵܘܵܝܗ‌ܝ، ܢܵܛܪܵܢܵܐ ܕܫܪܵܪܵܐ ܠܥܵܠܲܡ، ");
INSERT INTO aii_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","ܥܵܒ݂ܕܵܢܵܐ ܕܕܝܼܘܵܢ ܕܛܠܝܼܡܹ̈ܐ، ܝܵܗܒ݂ܵܢܵܐ ܕܠܲܚܡܵܐ ܠܟܦܝܼܢܹ̈ܐ، ܡܵܪܝܵܐ ܫܵܪܝܵܢܵܐ ܕܐܲܣܝܼܪܹ̈ܐ، ");
INSERT INTO aii_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","ܡܵܪܝܵܐ ܦܵܬܚܵܢܵܐ ܕܥܲܝ̈ܢܹܐ ܕܣܸܡܝܹ̈ܐ، ܡܵܪܝܵܐ ܡܲܪܡܵܢܵܐ ܕܛܥܝܼ̈ܦܹܐ، ܡܵܪܝܵܐ ܡܲܚܸܒܵܢܵܐ ܕܙܲܕܝܼܩܹ̈ܐ، ");
INSERT INTO aii_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","ܡܵܪܝܵܐ ܢܵܛܪܵܢܵܐ ܕܡܵܫܵܚܲܛܹ̈ܐ، ܣܵܢܕܵܢܵܐ ܕܝܲܬܘܼܡܹ̈ܐ ܘܐܲܪ̈ܡܸܠܝܵܬܹ‌ܐ، ܐܝܼܢܵܐ ܐܘܼܪܚܵܐ ܕܪ̈ܲܫܝܼܥܹܐ ܟܹܐ ܡܲܦܟ̰ܸܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","ܡܵܪܝܵܐ ܒܸܬ ܥܵܒܹܕ ܡܲܠܟܘܼܬܵ‌ܐ ܠܥܵܠܲܡ، ܐܲܠܵܗܵܟ݂ܝ، ܝܵܐ ܨܸܗܝܘܿܢ، ܠܕܵܪܵܐ ܘܕܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","ܫܲܒܚܘܼܢ ܠܡܵܪܝܵܐ، ܣܵܒܵܒ ܨܦܵܝܝܼ ܝܠܵܗ̇ ܠܸܙܡܵܪܵܐ ܠܐܲܠܵܗܲܢ، ܣܵܒܵܒ ܒܲܣܝܼܡܬܵ‌ܐ ܝܠܵܗ̇؛ ܠܚܝܼܡܬܵ‌ܐ ܝܠܵܗ̇ ܐܸܠܹܗ ܬܸܫܒܘܿܚܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","ܒܸܒܢܵܝܵܐ ܝܠܹܗ ܠܐܘܿܪܸܫܠܸܡ ܡܵܪܝܵܐ، ܒܘܼܪ̈ܒܸܙܹܐ ܕܐܝܼܣܪܵܐܹܝܠܔ ܓ̰ܲܡܘܼܥܵܝ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","ܟܹܐ ܒܲܣܸܡ ܠܬܒ݂ܝܼܪܹ̈ܐ ܕܠܸܒܵܐ، ܘܟܹܐ ܐܵܣܹܪ ܕܲܪ̈ܒܵܬܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","ܟܹܐ ܡܵܢܹܐ ܡܸܢܝܵܢܵܐ ܕܟܵܘܟ݂ܒܹ̈ܐ، ܠܟܠܵܝܗ‌ܝ ܟܹܐ ܩܵܪܹܐ ܫܸܡܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","ܓܘܼܪܵܐ ܝܠܹܗ ܡܵܪܲܢ ܘܪܵܒܵܐ ܚܲܝܠܵܢܵܐ، ܠܦܲܪܡܲܝܬܹܗ ܠܲܝܬ ܬܚܘܼܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","ܟܹܐ ܣܵܢܹܕ ܡܸܣܟܹܢܹ̈ܐ ܡܵܪܝܵܐ، ܟܹܐ ܡܲܟܸܦ ܪ̈ܲܫܝܼܥܹܐ ܗܲܠܔ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","ܙܡܘܿܪܘܼܢ ܠܡܵܪܝܵܐ ܒܫܲܟܲܪܬܵ‌ܐ، ܙܡܘܿܪܘܼܢ ܠܐܲܠܵܗܲܢ ܒܟܸܢܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","ܗ̇ܘ ܕܟܲܣܹܐ ܫܡܲܝܹ̈ܐ ܒܥܲܝܒܹ̈ܐ، ܗܲܕܸܪ ܩܵܐ ܐܲܪܥܵܐ ܡܸܛܪܵܐ، ܡܲܓ̰ܝܸܢ ܥܲܠܔ ܛܘܼܪܹ̈ܐ ܓܸܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","ܝܵܗܒܹܠܔ ܠܒܸܩܪܵܐ ܡܹܐܟ݂ܘܼܠܬܵܝܗ‌ܝ، ܠܙܲܥܝܹ̈ܐ ܕܥܘܼܪܒ݂ܵܐ ܕܟܹܐ ܩܵܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","ܠܵܐ ܒܓܲܒܵܪܘܼܬܵ‌ܐ ܕܣܘܼܣܵܐ ܟܹܐ ܒܵܣܡܵܐ ܠܹܗ، ܠܵܐ ܒܐܲܩܠܹ̈ܐ ܕܐܢܵܫܵܐ ܟܹܐ ܩܲܒܸܠܔ ܗܸܢܝܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","ܟܹܐ ܒܵܣܡܵܐ ܠܹܗ ܡܵܪܝܵܐ ܒܙܕܝܼܥܘܼ̈ܗ‌ܝ، ܒܐܵܢܝܼ ܕܣܵܦܪܝܼ ܠܛܲܝܒܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","ܫܲܒܸܚܝ، ܝܵܐ ܐܘܿܪܸܫܠܸܡ، ܠܡܵܪܝܵܐ، ܡܲܐܣܸܩܝ ܗܲܠܸܠܘܼܝܵܐ ܠܐܲܠܵܗܵܟ݂ܝ، ܝܵܐ ܨܸܗܝܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","ܣܵܒܵܒ ܚܘܼܠܸܢܵܝ ܠܹܗ ܕܵܒ݂ܪܹ̈ܐ ܕܕܲܪ̈ܘܵܙܵܟ݂ܝ، ܒܘܼܪܸܟ݂ ܠܹܗ ܠܒܢܘܿܢܵܟ݂ܝ̈ ܒܓܵܘܵܟ݂ܝ. ");
INSERT INTO aii_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","ܟܹܐ ܡܲܬܸܒ݂ ܫܠܵܡܵܐ ܒܬܚܘܼܡܵܟ݂ܝ، ܒܫܲܡܝܼܢܘܼܬܵ‌ܐ ܕܚܸܛܹ̈ܐ ܟܹܐ ܡܲܣܒܸܥ ܠܵܟ݂ܝ. ");
INSERT INTO aii_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","ܟܹܐ ܫܲܕܸܪ ܗܹܡܸܙܡܵܢܹܗ ܥܲܠܔ ܐܲܪܥܵܐ، ܓ̰ܲܠܕܹܐ ܟܹܐ ܪܵܚܹܛ ܚܲܒܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","ܟܹܐ ܝܵܗܒܹܠܔ ܬܲܠܓܵܐ ܐܲܝܟ݂ ܥܲܡܪܵܐ، ܛܠܘܼܠܵܐ ܡܘܼܓܕܸܠܵܐ ܐܲܝܟ݂ ܩܸܛܡܵܐ ܟܹܐ ܒܵܙܹܩ. ");
INSERT INTO aii_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","ܟܹܐ ܕܵܪܹܐ ܓܕܝܼܠܹܗ ܐܲܝܟ݂ ܦܸܪ̈ܬܘܼܚܹܐ، ܩܲܕܡ ܩܲܪܬܹܗ ܡܵܢܝܼ ܟܵܠܹܐ؟ ");
INSERT INTO aii_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","ܟܹܐ ܫܲܕܸܪ ܚܲܒܪܹܗ ܘܟܹܐ ܡܲܦܫܸܪܗܘܿܢ، ܟܹܐ ܡܵܚܹܐ ܦܵܘܚܹܗ، ܟܹܐ ܓ̰ܵܪܝܼ ܡ̈ܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","ܟܹܐ ܡܲܕܸܥ ܚܲܒܪܹܗ ܠܝܲܥܩܘܿܒ݂، ܩܵܢܘܿܢܘܼ̈ܗ‌ܝ ܘܕܝܼܘܵܢܘܼ̈ܗ‌ܝ ܠܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","ܠܵܐ ܥܒ݂ܝܼܕ ܠܹܗ ܗܵܕܟ݂ܵܐ ܠܟܠܔ ܐܘܼܡܬܵ‌ܐ، ܘܕܝܼܘܵܢܘܼ̈ܗ‌ܝ ܠܵܐ ܝܕܝܼܥܵܝ ܠܗܘܿܢ. ܗܲܠܸܠܘܼܝܵܐ ");
INSERT INTO aii_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","ܗܲܠܸܠܘܼܝܵܐ، ܫܲܒܚܘܼܢ ܠܡܵܪܝܵܐ ܡ̣ܢ ܫܡܲܝܵܐ، ܫܲܒܚܘܼܢ ܠܹܗ ܒܲܡܪ̈ܵܘܡܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","ܫܲܒܚܘܼܢ ܠܹܗ، ܟܠܵܝܗ‌ܝ ܡܲܠܲܐܟ݂ܘܼ̈ܗ‌ܝ، ܫܲܒܚܘܼܢ ܠܹܗ، ܟܠܵܝܗ‌ܝ ܚܲܝܠܵܘܵܬܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","ܫܲܒܚܘܼܢ ܠܹܗ، ܫܸܡܫܵܐ ܘܣܲܗܪܵܐ، ܫܲܒܚܘܼܢ ܠܹܗ، ܟܠܵܝܗ‌ܝ ܟܵܘܟ݂ܒܹ̈ܐ ܕܒܲܗܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","ܫܲܒܚܘܼܢ ܠܹܗ، ܫܡܲܝ̈ ܫܡܲܝܹ̈ܐ، ܘܡ̈ܝܼܵܐ ܕܠܥܸܠܸܠܔ ܡ̣ܢ ܫܡܲܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","ܫܲܒܚܝܼ ܠܫܸܡܵܐ ܕܡܵܪܝܵܐ، ܣܵܒܵܒ ܗ̇ܘ ܦܩܝܼܕ ܠܹܗ ܘܦܝܼܫ ܠܗܘܿܢ ܒܸܪܝܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","ܘܫܘܼܬܐܸܣܵܝ ܠܹܗ ܠܥܵܠܲܡ ܥܵܠܡܝܼܢ، ܝܘܼܗܒܹܠܔ ܠܹܗ ܩܵܢܘܿܢܵܐ ܕܠܹܐ ܒܵܛܹܠܔ. ");
INSERT INTO aii_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","ܫܲܒܚܘܼܢ ܠܡܵܪܝܵܐ ܡ̣ܢ ܐܲܪܥܵܐ، ܬܲܢܝܼܢܹ̈ܐ ܘܟܠܵܝܗ‌ܝ ܬܗܘܿܡܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","ܢܘܼܪܵܐ ܘܒܲܪܕܵܐ، ܬܲܠܓܵܐ ܘܗܵܘܓܵܐ، ܦܵܘܚܵܐ ܕܥܲܠܥܵܠܵܐ ܥܵܒ݂ܕܵܢܵܐ ܕܚܲܒܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","ܛܘܼܪ̈ܵܢܹܐ ܘܟܠܵܝܗ‌ܝ ܪ̈ܘܼܡܝܵܬܹ‌ܐ، ܐܝܼܠܵܢܹ̈ܐ ܕܛܥܘܼܢܬܵ‌ܐ ܘܟܠܵܝܗ‌ܝ ܐܲܪ̈ܙܹܐ. ");
INSERT INTO aii_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","ܚܲܝܘܬܵ‌ܐ ܘܟܠܔ ܒܸܩܪܵܐ، ܪܸܓ̰ܒܵܐ ܘܛܲܝܪܵܐ ܡܵܪܹܐ ܓܘܼܠܦܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","ܡܲܠܟܹ̈ܐ ܕܐܲܪܥܵܐ ܘܟܠܵܝܗ‌ܝ ܐܸܡܘܵܬܹ̈‌ܐ، ܓܘܼܪ̈ܵܢܹܐ ܘܟܠܵܝܗ‌ܝ ܕܲܝܵܢܹ̈ܐ ܕܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","ܥܠܲܝܡܹ̈ܐ ܘܐܘܼܦ ܥܠܲܝܡܵܬܹ̈‌ܐ، ܣܵܒܹ̈ܐ ܥܲܡ ܝܵܠܹ̈ܕ݇ܐ ܙܥܘܿܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","ܫܲܒܚܝܼ ܠܫܸܡܵܐ ܕܡܵܪܝܵܐ، ܣܵܒܵܒ ܪܝܼܡܵܐ ܝܠܹܗ ܫܸܡܹܗ ܒܢܲܦ̮ܫܹܗ، ܚܸܩܪܹܗ ܥܲܠܔ ܐܲܪܥܵܐ ܘܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","ܘܡܘܼܪܸܡ ܠܹܗ ܚܲܝܠܵܐ ܕܥܲܡܹܗ، ܕܝܼܠܹܗ ܬܸܫܒܘܿܚܬܵ‌ܐ ܕܟܠܵܝܗ‌ܝ ܙܲܕܝܼܩܘܼ̈ܗ‌ܝ، ܕܒܢܲܝ̈ ܐܝܼܣܪܵܐܹܝܠܔ، ܥܲܡܵܐ ܕܩܘܼܪܒܵܐ ܐܸܠܹܗ. ܗܲܠܸܠܘܼܝܵܐ ");
INSERT INTO aii_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","ܗܲܠܸܠܘܼܝܵܐ، ܙܡܘܿܪܘܼܢ ܠܡܵܪܝܵܐ ܙܡܵܪܬܵ‌ܐ ܚܲܕܬܵ‌ܐ، ܬܸܫܒܘܿܚܬܹܗ ܒܟܸܢܫܵܐ ܕܙܲܕܝܼܩܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","ܚܵܕܹܐ ܐܝܼܣܪܵܐܹܝܠܔ ܒܥܵܒ݂ܕܵܢܹܗ، ܒܢܲܝ̈ ܨܸܗܝܘܿܢ ܦܵܨܚܝܼ ܒܡܲܠܟܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","ܫܲܒܚܝܼ ܠܫܸܡܹܗ ܒܪܸܩܕܵܐ، ܒܕܲܦ̮ ܘܟܸܢܵܪܵܐ ܙܵܡܪܝܼ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","ܣܵܒܵܒ ܟܹܐ ܒܵܣܡܵܐ ܠܹܗ ܡܵܪܝܵܐ ܒܥܲܡܹܗ، ܟܹܐ ܫܲܦܪܸܢ ܠܡܸܣܟܹܢܹ̈ܐ ܒܦܘܼܪܩܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","ܦܵܨܚܝܼ ܙܲܕܝܼܩܹ̈ܐ ܒܐܝܼܩܵܪܵܐ، ܡܲܩܘܸܚܝܼ ܥܲܠܔ ܫܘܝܼܵܬܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","ܪܘܼܡܪܵܡܵܐ ܕܐܲܠܵܗܵܐ ܗܵܘܹܐ ܒܒܵܠܘܿܥܬܵܝܗ‌ܝ، ܘܣܲܝܦܵܐ ܕܬܪܹܝ ܦܘܼܡܵܢܹ̈ܐ ܒܐܝܼܕܵܝܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","ܠܸܥܒ݂ܵܕܵܐ ܬܘܼܥܠܵܐ ܒܐܸܡܘܵܬܹ̈‌ܐ، ܬܲܥܠܲܡ̈ܝܵܬܹ‌ܐ ܒܥܲܡܡܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","ܠܹܐܣܵܪܵܐ ܡܲܠܟܵܝ̈ܗ‌ܝ ܒܫܹܫܠܵܬܹ̈‌ܐ، ܘܡܝܘܼܩܪ̈ܵܝܗ‌ܝ ܒܩܵܘܕܹ̈ܐ ܕܦܪܸܙܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","ܠܸܥܒ݂ܵܕܵܐ ܒܝܼܵܝܗ‌ܝ ܕܝܼܘܵܢ ܕܝܼܠܵܗ̇ ܟܬܝܼܒ݂ܬܵ‌ܐ- ܣܸܩܠܵܐ ܝܠܹܗ ܠܟܠܵܝܗ‌ܝ ܙܲܕܝܼܩܘܼ̈ܗ‌ܝ. ܗܲܠܸܠܘܼܝܵܐ ");
INSERT INTO aii_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","ܗܲܠܸܠܘܼܝܵܐ، ܫܲܒܚܘܼܢ ܠܐܲܠܵܗܵܐ ܒܩܘܼܕܫܹܗ، ܫܲܒܚܘܼܢ ܠܹܗ ܒܪܩܝܼܥܵܐ ܕܥܘܼܫܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","ܫܲܒܚܘܼܢ ܠܹܗ ܒܘܼܬ ܓܲܒܵܪ̈ܘܼܝܵܬܘܼܗ‌ܝ، ܫܲܒܚܘܼܢ ܠܹܗ ܐܲܝܟ݂ ܦܸܪܝܘܼܬܵ‌ܐ ܕܓܘܼܪܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","ܫܲܒܚܘܼܢ ܠܹܗ ܒܩܵܠܵܐ ܕܫܝܼܦܘܿܪܵܐ، ܫܲܒܚܘܼܢ ܠܹܗ ܒܩܝܼܬܵܪܵܐ ܘܒܟܸܢܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","ܫܲܒܚܘܼܢ ܠܹܗ ܒܕܲܦ̮ ܘܒܪܸܩܕܵܐ، ܫܲܒܚܘܼܢ ܠܹܗ ܒܡܵܐܢܹ̈ܐ ܕܙܡܵܪܵܐ ܕܣܝܼܡܹ̈ܐ ܘܒܫܲܒܝܼܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","ܫܲܒܚܘܼܢ ܠܹܗ ܒܨܸܨ̈ܠܹܐ ܕܫܡܵܥܬܵ‌ܐ، ܫܲܒܚܘܼܢ ܠܹܗ ܒܨܸܨ̈ܠܹܐ ܕܩܲܘܲܚܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","ܟܠܔ ܢܫܲܡܬܵ‌ܐ ܫܲܒܚܵܐ ܠܡܵܪܝܵܐ، ܗܲܠܸܠܘܼܝܵܐ.");
INSERT INTO aii_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ܐܵܗܵܐ ܝܠܹܗ ܟܬܵܒ݂ܵܐ ܕܝܼܠܝܼܕܘܼܬܵ‌ܐ ܕܝܼܫܘܿܥ ܡܫܝܼܚܵܐ، ܒܪܘܿܢܵܐ ܕܕܵܘܝܼܕ، ܒܪܘܿܢܵܐ ܕܐܲܒ݂ܪܵܗܵܡ. ");
INSERT INTO aii_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ܐܲܒ݂ܪܵܗܵܡ ܡܘܼܠܸܕ ܠܹܗ ܠܐܝܼܣܚܵܩ؛ ܐܝܼܣܚܵܩ ܡܘܼܠܸܕ ܠܹܗ ܠܝܲܥܩܘܿܒ݂؛ ܝܲܥܩܘܿܒ݂ ܡܘܼܠܸܕ ܠܹܗ ܠܝܼܗܘܼܕܵܐ ܘܠܐܲܚܘܿܢܘܵܬܘܼ̈ܗ‌ܝ؛ ");
INSERT INTO aii_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ܝܼܗܘܼܕܵܐ ܡܘܼܠܸܕ ܠܹܗ ܠܦܲܪܨ ܘܠܙܲܪܚ ܡ̣ܢ ܬܵܡܵܪ؛ ܦܲܪܨ ܡܘܼܠܸܕ ܠܹܗ ܠܚܸܨܪܘܿܢ؛ ܚܸܨܪܘܿܢ ܡܘܼܠܸܕ ܠܹܗ ܠܐܵܪܵܡ؛ ");
INSERT INTO aii_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ܐܵܪܵܡ ܡܘܼܠܸܕ ܠܹܗ ܠܥܲܡܝܼܢܵܕܵܒ݂؛ ܥܲܡܝܼܢܵܕܵܒ݂ ܡܘܼܠܸܕ ܠܹܗ ܠܢܸܚܫܘܿܢ؛ ܢܸܚܫܘܿܢ ܡܘܼܠܸܕ ܠܹܗ ܠܣܲܠܡܘܿܢ؛ ");
INSERT INTO aii_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ܣܲܠܡܘܿܢ ܡܘܼܠܸܕ ܠܹܗ ܠܒܵܥܲܙ ܡ̣ܢ ܪܵܚܵܒ݂؛ ܒܵܥܲܙ ܡܘܼܠܸܕ ܠܹܗ ܠܥܘܿܒ݂ܝܼܕ ܡ̣ܢ ܪܥܘܿܬ؛ ܥܘܿܒ݂ܝܼܕ ܡܘܼܠܸܕ ܠܹܗ ܠܐܝܼܫܲܝ؛ ");
INSERT INTO aii_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ܐܝܼܫܲܝ ܡܘܼܠܸܕ ܠܹܗ ܠܕܵܘܝܼܕ ܡܲܠܟܵܐ؛ ܕܵܘܝܼܕ ܡܘܼܠܸܕ ܠܹܗ ܠܫܠܹܝܡܘܿܢ ܡ̣ܢ ܒܲܟ݂ܬܵ‌ܐ ܕܐܘܿܪܝܼܵܐ؛ ");
INSERT INTO aii_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ܫܠܹܝܡܘܿܢ ܡܘܼܠܸܕ ܠܹܗ ܠܪܚܸܒ݂ܥܲܡ؛ ܪܚܸܒ݂ܥܲܡ ܡܘܼܠܸܕ ܠܹܗ ܠܐܲܒ݂ܝܼܵܐ؛ ܐܲܒ݂ܝܼܵܐ ܡܘܼܠܸܕ ܠܹܗ ܠܐܵܣܵܐ؛ ");
INSERT INTO aii_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ܐܵܣܵܐ ܡܘܼܠܸܕ ܠܹܗ ܠܝܵܗܘܿܫܵܦܵܛ؛ ܝܵܗܘܿܫܵܦܵܛ ܡܘܼܠܸܕ ܠܹܗ ܠܝܘܿܪܵܡ؛ ܝܘܿܪܵܡ ܡܘܼܠܸܕ ܠܹܗ ܠܥܘܿܙܝܼܵܐ؛ ");
INSERT INTO aii_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ܥܘܿܙܝܼܵܐ ܡܘܼܠܸܕ ܠܹܗ ܠܝܘܿܬܵܡ؛ ܝܘܿܬܵܡ ܡܘܼܠܸܕ ܠܹܗ ܠܐܵܚܵܙ؛ ܐܵܚܵܙ ܡܘܼܠܸܕ ܠܹܗ ܠܚܹܙܲܩܝܵܐ؛ ");
INSERT INTO aii_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ܚܹܙܲܩܝܵܐ ܡܘܼܠܸܕ ܠܹܗ ܠܡܢܲܫܹܐ؛ ܡܢܲܫܹܐ ܡܘܼܠܸܕ ܠܹܗ ܠܐܲܡܘܿܢ؛ ܐܲܡܘܿܢ ܡܘܼܠܸܕ ܠܹܗ ܠܝܘܿܫܝܼܵܐ؛ ");
INSERT INTO aii_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ܝܘܿܫܝܼܵܐ ܡܘܼܠܸܕ ܠܹܗ ܠܝܘܿܟܲܢܝܵܐ ܘܠܐܲܚܘܿܢܘܵܬܘܼ̈ܗ‌ܝ، ܒܥܕܵܢܵܐ ܕܓܵܠܘܼܬܵ‌ܐ ܕܒܵܒܹܠܔ. ");
INSERT INTO aii_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ܡ̣ܢ ܒܵܬܪ ܓܵܠܘܼܬܵ‌ܐ ܕܒܵܒܹܠܔ، ܝܘܿܟܲܢܝܵܐ ܡܘܼܠܸܕ ܠܹܗ ܠܫܹܠܲܬܐܹܝܠܔ؛ ܫܹܠܲܬܐܹܝܠܔ ܡܘܼܠܸܕ ܠܹܗ ܠܙܘܼܪܒܵܒܹܠܔ؛ ");
INSERT INTO aii_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ܙܘܼܪܒܵܒܹܠܔ ܡܘܼܠܸܕ ܠܹܗ ܠܐܲܒ݂ܝܼܘܿܕ؛ ܐܲܒ݂ܝܼܘܿܕ ܡܘܼܠܸܕ ܠܹܗ ܠܐܸܠܝܵܩܝܼܡ؛ ܐܸܠܝܵܩܝܼܡ ܡܘܼܠܸܕ ܠܹܗ ܠܥܵܙܘܿܪ؛ ");
INSERT INTO aii_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ܥܵܙܘܿܪ ܡܘܼܠܸܕ ܠܹܗ ܠܙܵܕܘܿܩ؛ ܙܵܕܘܿܩ ܡܘܼܠܸܕ ܠܹܗ ܠܐܲܟܝܼܢ؛ ܐܲܟܝܼܢ ܡܘܼܠܸܕ ܠܹܗ ܠܐܹܠܝܼܘܿܕ؛ ");
INSERT INTO aii_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ܐܹܠܝܼܘܿܕ ܡܘܼܠܸܕ ܠܹܗ ܠܐܹܠܝܼܥܵܙܲܪ؛ ܐܹܠܝܼܥܵܙܲܪ ܡܘܼܠܸܕ ܠܹܗ ܠܡܵܬܲܢ؛ ܡܵܬܲܢ ܡܘܼܠܸܕ ܠܹܗ ܠܝܲܥܩܘܿܒ݂؛ ");
INSERT INTO aii_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ܝܲܥܩܘܿܒ݂ ܡܘܼܠܸܕ ܠܹܗ ܠܝܵܘܣܸܦ ܓܲܒ݂ܪܵܐ ܕܡܲܪܝܲܡ، ܕܡܸܢܘܼܗ̇ ܦܝܼܫ ܠܹܗ ܝܠܝܼܕܵܐ ܝܼܫܘܿܥ، ܕܦܝܼܫܵܐ ܝܠܹܗ ܩܸܪܝܵܐ ܡܫܝܼܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ܗܵܕܟ݂ܵܐ، ܟܠܵܝܗ‌ܝ ܫܲܪ̈ܒܵܬܹ‌ܐ ܡ̣ܢ ܐܲܒ݂ܪܵܗܵܡ ܗܲܠܔ ܕܵܘܝܼܕ ܐܲܪܒܲܥܣܲܪ ܫܲܪ̈ܒܵܬܹ‌ܐ ܝܢܵܐ، ܡ̣ܢ ܕܵܘܝܼܕ ܗܲܠܔ ܓܵܠܘܼܬܵ‌ܐ ܕܒܵܒܹܠܔ ܐܲܪܒܲܥܣܲܪ ܫܲܪ̈ܒܵܬܹ‌ܐ ܝܢܵܐ، ܘܡ̣ܢ ܓܵܠܘܼܬܵ‌ܐ ܕܒܵܒܹܠܔ ܗܲܠܔ ܡܫܝܼܚܵܐ ܐܲܪܒܲܥܣܲܪ ܫܲܪ̈ܒܵܬܹ‌ܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ܡܵܘܠܵܕܵܐ ܕܝܼܫܘܿܥ ܡܫܝܼܚܵܐ ܗܵܕܟ݂ܵܐ ܗܘܹܐ ܠܹܗ: ܐܝܼܡܲܢ ܕܡܲܪܝܲܡ ܝܸܡܹܗ ܛܠܝܼܒܬܵ‌ܐ ܝܗܘܵܐ ܠܝܵܘܣܸܦ، ܡ̣ܢ ܩܲܕܡ ܫܲܪܲܟܬܵܝܗ‌ܝ ܦܝܼܫ ܠܵܗ̇ ܚܙܝܼܬܵ‌ܐ ܒܛܝܼܢܬܵ‌ܐ ܡ̣ܢ ܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ܣܵܒܵܒ ܝܵܘܣܸܦ ܓܲܒ݂ܪܘܼܗ̇ ܟܹܐܢܵܐ ܝܗܘܵܐ، ܠܵܐ ܒܥܹܐ ܠܹܗ ܕܡܲܢܟܸܦ ܗܘܵܐ ܠܵܗ̇ ܓܲܠܝܵܐܝܼܬ، ܘܬܘܼܚܡܸܢܹܗ ܕܒܛܸܫܘܵܐ ܪܲܦܹܐ ܗܘܵܐ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ܐܝܼܢܵܐ ܟܲܕ ܗ̇ܘ ܗܵܕܟ݂ܵܐ ܬܲܚܡܘܼܢܹܐ، ܦܝܼܫ ܠܹܗ ܚܸܙܝܵܐ ܐܸܠܹܗ ܡܲܠܲܐܟ݂ܵܐ ܕܡܵܪܝܵܐ ܒܚܸܠܡܵܐ، ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܝܵܘܣܸܦ ܒܪܘܿܢܵܐ ܕܕܵܘܝܼܕ، ܠܵܐ ܙܵܕܥܹܬ ܠܸܫܩܵܠܵܐ ܠܡܲܪܝܲܡ ܕܗܵܘܝܵܐ ܒܲܟ݂ܬܘܼܟ݂، ܣܵܒܵܒ ܗ̇ܘ ܕܦܝܼܫ ܠܹܗ ܒܛܝܼܢܵܐ ܒܝܼܘܼܗ̇ ܡ̣ܢ ܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","”ܒܸܬ ܗܲܨܠܵܐ ܒܪܘܿܢܵܐ، ܘܒܸܬ ܩܵܪܹܝܬ ܫܸܡܹܗ ܝܼܫܘܿܥ، ܣܵܒܵܒ ܗ̇ܘ ܒܸܬ ܦܲܪܸܩ ܠܥܲܡܹܗ ܡ̣ܢ ܚܛܝܼܵܬܵܝ̈ܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ܟܠܵܗ̇ ܐܵܗܵܐ ܗܘܹܐ ܠܵܗ̇ ܕܦܵܐܹܫ ܬܘܼܡܸܡܵܐ ܡܸܢܕܝܼ ܕܦܝܼܫ ܠܹܗ ܐܡܝܼܪܵܐ ܡ̣ܢ ܡܵܪܝܵܐ ܒܝܲܕ ܢܒ݂ܝܼܵܐ، ܕܐܡܝܼܪܹܗ: ");
INSERT INTO aii_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ܗܵܐ ܒܬܘܼܠܬܵ‌ܐ ܒܸܬ ܒܵܛܢܵܐ ܘܒܸܬ ܗܲܨܠܵܐ ܒܪܘܿܢܵܐ، ܘܒܸܬ ܩܵܪܝܼ ܫܸܡܹܗ ܥܲܡܲܢܘܼܐܹܝܠܔ، ܕܦܝܵܫܵܐ ܝܠܹܗ ܦܘܼܫܩܵܐ: ”ܐܲܠܵܗܵܐ ܥܲܡܲܢ.“ ");
INSERT INTO aii_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ܘܟܲܕ ܪܥܝܼܫ ܠܹܗ ܝܵܘܣܸܦ ܡ̣ܢ ܫܸܢܬܹܗ، ܥܒ݂ܝܼܕ ܠܹܗ ܐܲܝܟ݂ ܕܦܝܼܫ ܠܹܗ ܦܩܝܼܕܵܐ ܒܡܲܠܲܐܟ݂ܵܐ ܕܡܵܪܝܵܐ، ܘܫܩܝܼܠܵܐ ܠܹܗ ܕܗܵܘܝܵܐ ܒܲܟ݂ܬܹܗ؛ ");
INSERT INTO aii_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ܘܠܵܐ ܝܕܝܼܥܵܐ ܠܹܗ ܗܲܠܔ ܕܗܘܼܨܸܠܔ ܠܵܗ̇ ܒܪܘܿܢܘܼܗ̇؛ ܘܩܪܹܐ ܠܵܗ̇ ܫܸܡܹܗ ܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ܡ̣ܢ ܒܵܬܪ ܕܦܝܼܫ ܠܹܗ ܝܠܝܼܕܵܐ ܝܼܫܘܿܥ ܓܵܘ ܒܹܝܬܠܚܸܡ ܕܝܼܗܘܼܕܵܐ ܒܝܵܘܡܵܢܹ̈ܐ ܕܗܹܪܘܿܕܸܣ ܡܲܠܟܵܐ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܡܓ݂ܘܼܫܹ̈ܐ ܡ̣ܢ ܡܲܕܢܚܵܐ ܠܐܘܿܪܸܫܠܸܡ، ");
INSERT INTO aii_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ܘܒܘܼܩܸܪܗܘܿܢ: ”ܐܲܝܟܵܐ ܝܠܹܗ ܗ̇ܘ ܕܦܝܼܫ ܠܹܗ ܝܠܝܼܕܵܐ ܡܲܠܟܵܐ ܕܝܗܘܼܕܵܝܹ̈ܐ؟ ܣܵܒܵܒ ܚܙܹܐ ܠܲܢ ܠܟܵܘܟ݂ܒܹܗ ܒܡܲܕܢܚܵܐ ܘܐܬܹ‌ܐ ܠܲܢ ܕܣܵܓ݂ܕܲܚ ܐܸܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܹܗ ܗܹܪܘܿܕܸܣ ܡܲܠܟܵܐ ܐܵܗܵܐ، ܦܝܼܫ ܠܹܗ ܫܓ݂ܝܼܫܵܐ، ܘܟܠܵܗ̇ ܐܘܿܪܸܫܠܸܡ ܥܲܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ܘܩܪܹܐ ܠܹܗ ܠܟܠܵܝܗ‌ܝ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܣܵܦܪܹ̈ܐ ܕܥܲܡܵܐ، ܘܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ ܐܲܝܟܵܐ ܒܸܬ ܦܵܐܹܫ ܗܘܵܐ ܝܠܝܼܕܵܐ ܡܫܝܼܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ܘܐܡܝܼܪܗܘܿܢ: ”ܒܒܹܝܬܠܚܸܡ ܕܝܼܗܘܼܕܵܐ ܣܵܒܵܒ ܗܵܕܟ݂ܵܐ ܦܝܼܫܵܐ ܝܠܹܗ ܟܬܝܼܒ݂ܵܐ ܒܝܲܕ ܢܒ݂ܝܼܵܐ: ");
INSERT INTO aii_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ܐܘܼܦ ܐܲܢ݇ܬ‌ܝ ܒܹܝܬܠܚܸܡ، ܒܐܲܪܥܵܐ ܕܝܼܗܘܼܕܵܐ، ܠܹܐ ܝܘܲܬ‌ܝ ܒܵܨܘܿܪܬܵ‌ܐ ܓܵܘ ܫܲܠܝܼܛܹ̈ܐ ܕܝܼܗܘܼܕܵܐ، ܣܵܒܵܒ ܡܸܢܵܟ݂ܝ ܒܸܬ ܦܵܠܹܛ ܫܲܠܝܼܛܵܐ، ܘܗ̇ܘ ܒܸܬ ܡܲܪܥܹܐ ܠܥܲܡܝܼ ܐܝܼܣܪܵܐܹܝܠܔ.“ ");
INSERT INTO aii_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ܗ̇ܝܓܵܗ ܩܪܹܐ ܠܹܗ ܗܹܪܘܿܕܸܣ ܠܡܓ݂ܘܼܫܹ̈ܐ ܕܬܵܦܩܝܼ ܒܝܼܹܗ ܒܛܸܫܘܵܐ، ܘܡܸܢܵܝܗ‌ܝ ܝܕܝܼܥ ܠܹܗ ܕܒܐܲܝܢܝܼ ܙܲܒ݂ܢܵܐ ܡܘܼܒܝܸܢܹܗ ܐܸܠܵܝܗ‌ܝ ܟܵܘܟ݂ܒ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ܘܫܘܼܕܪܵܝ ܠܹܗ ܠܒܹܝܬܠܚܸܡ، ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܙܹܠ݇ܡܘܼܢ ܒܲܩܪܘܼܢ ܒܘܼܬ ܝܵܠܵܕ݇ܐ ܒܚܦܝܼܛܘܼܬܵ‌ܐ، ܘܐܝܼܡܲܢ ܕܡܘܼܫ݇ܟ̰ܸܚ ܠܵܘܟ݂ܘܿܢ ܐܸܠܹܗ، ܡܲܕܸܥܡܘܼܢ ܠܝܼ ܕܐܘܼܦ ܐܵܢܵܐ ܐܵܙܹܠ݇ܢ ܣܵܓ݂ܕܹܢ ܐܸܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ܡ̣ܢ ܒܵܬܪ ܕܫܡܝܼܥ ܠܗܘܿܢ ܡ̣ܢ ܡܲܠܟܵܐ، ܐܙܝܼܠܔ ܠܗܘܿܢ، ܘܗܵܐ، ܗ̇ܘ ܟܵܘܟ݂ܒ݂ܵܐ ܕܚܙܹܐ ܠܗܘܿܢ ܒܡܲܕܢܚܵܐ ܐܵܙܹܠܔ ܗܘܵܐ ܩܲܕܡܵܝܗ‌ܝ، ܗܲܠܔ ܕܐܬܹ‌ܐ ܠܹܗ ܘܟܠܹܐ ܠܹܗ ܠܥܸܠܸܠܔ ܡ̣ܢ ܕܘܼܟܵܐ ܕܝܼܗܘܵܐ ܝܵܠܵܕ݇ܐ. ");
INSERT INTO aii_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ܘܟܲܕ ܚܙܹܐ ܠܗܘܿܢ ܠܟܵܘܟ݂ܒ݂ܵܐ، ܚܕܹܐ ܠܗܘܿܢ ܚܲܕܘܼܬܵ‌ܐ ܪܵܒܵܐ ܓܘܼܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ܘܥܒ݂ܝܼܪܗܘܿܢ ܠܒܲܝܬܵ‌ܐ ܘܚܙܹܐ ܠܗܘܿܢ ܠܝܵܠܵܕ݇ܐ ܥܲܡ ܡܲܪܝܲܡ ܝܸܡܹܗ، ܘܢܦܝܼܠܔ ܠܗܘܿܢ ܘܣܓ݂ܝܼܕ ܠܗܘܿܢ ܐܸܠܹܗ. ܗ̇ܝܓܵܗ ܦܬܝܼܚ ܠܗܘܿܢ ܣܝܼܡܵܬܵܝ̈ܗ‌ܝ، ܘܡܘܼܩܪܸܒ݂ ܠܗܘܿܢ ܐܸܠܹܗ ܕܲܫܢܹ̈ܐ: ܕܲܗܒ݂ܵܐ، ܘܠܒ݂ܘܿܢܬܵ‌ܐ، ܘܡܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ܘܟܲܕ ܦܝܼܫ ܠܗܘܿܢ ܡܘܼܕܸܥܹܐ ܒܚܸܠܡܵܐ ܕܠܵܐ ܕܵܝܪܝܼ ܠܟܸܣ ܗܹܪܘܿܕܸܣ، ܕܝܼܪܗܘܿܢ ܠܐܲܬܪܵܝܗ‌ܝ ܒܚܕܵܐ ܐܘܼܪܚܵܐ ܦܪܝܼܫܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ܡ̣ܢ ܒܵܬܪ ܕܐܙܝܼܠܔ ܠܗܘܿܢ ܡܓ݂ܘܼܫܹ̈ܐ، ܦܝܼܫ ܠܹܗ ܚܸܙܝܵܐ ܡܲܠܲܐܟ݂ܵܐ ܕܡܵܪܝܵܐ ܒܚܸܠܡܵܐ ܠܝܵܘܣܸܦ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܩܘܼܡ، ܠܲܒܸܠܔ ܠܝܵܠܵܕ݇ܐ ܘܠܝܸܡܹܗ ܘܥܪܘܿܩ ܠܡܸܨܪܹܝܢ، ܘܦܘܼܫ ܬܵܡܵܐ ܗܲܠܔ ܕܐܵܡܪܹܢܘܼܟ݂، ܣܵܒܵܒ ܗܕܝܼܪܵܐ ܝܠܹܗ ܗܹܪܘܿܕܸܣ ܠܸܛܥܵܝܵܐ ܒܵܬܪ ܝܵܠܵܕ݇ܐ ܕܛܲܠܸܩ ܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ܗ̇ܝܓܵܗ ܩܝܼܡ ܠܹܗ ܝܵܘܣܸܦ ܘܫܩܝܼܠܔ ܠܹܗ ܠܝܵܠܵܕ݇ܐ ܙܥܘܿܪܵܐ ܘܠܝܸܡܹܗ ܒܠܲܝܠܹܐ ܘܥܪܝܼܩ ܠܹܗ ܠܡܸܨܪܹܝܢ. ");
INSERT INTO aii_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ܘܦܝܼܫ ܠܹܗ ܬܵܡܵܐ ܗܲܠܔ ܡܵܘܬܵ‌ܐ ܕܗܹܪܘܿܕܸܣ، ܕܦܵܐܹܫ ܬܘܼܡܸܡܵܐ ܡܸܢܕܝܼ ܕܦܝܼܫ ܠܹܗ ܐܡܝܼܪܵܐ ܡ̣ܢ ܡܵܪܝܵܐ ܒܝܲܕ ܢܒ݂ܝܼܵܐ، ܕܐܡܝܼܪܹܗ: ܡ̣ܢ ܡܸܨܪܹܝܢ ܩܪܹܐ ܠܝܼ ܠܒܪܘܿܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ܗ̇ܝܓܵܗ ܟܲܕ ܚܙܹܐ ܠܹܗ ܗܹܪܘܿܕܸܣ ܕܦܝܼܫ ܠܹܗ ܡܘܼܣܚܸܪܵܐ ܒܝܲܕ ܡܓ݂ܘܼܫܹ̈ܐ، ܦܝܼܫ ܠܹܗ ܡܸܠܝܵܐ ܚܸܡܬܵ‌ܐ؛ ܘܫܘܼܕܸܪܹܗ ܘܡܘܼܩܛܸܠܔ ܠܹܗ ܠܟܠܵܝܗ‌ܝ ܝܵܠܹ̈ܕ݇ܐ ܕܓܵܘ ܒܹܝܬܠܚܸܡ ܘܕܟܠܵܝܗ‌ܝ ܬܚܘܼܡܘܼ̈ܗ̇، ܐܵܢܝܼ ܕܝܼܗܘܵܘ ܡ̣ܢ ܒܲܪ ܬܲܪܬܹܝ ܫܸܢܹ̈ܐ ܘܠܬܸܚܬ، ܐܲܝܟ݂ ܙܲܒ݂ܢܵܐ ܕܦܝܼܫ ܠܹܗ ܓܸܠܝܵܐ ܐܸܠܹܗ ܒܡܓ݂ܘܼܫܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ܘܗܵܕܟ݂ܵܐ ܦܝܼܫ ܠܹܗ ܬܘܼܡܸܡܵܐ ܡܸܢܕܝܼ ܕܦܝܼܫܵܐ ܝܗܘܵܐ ܐܡܝܼܪܵܐ ܒܝܲܕ ܐܹܪܲܡܝܵܐ ܢܒ݂ܝܼܵܐ، ܕܐܡܝܼܪܹܗ: ");
INSERT INTO aii_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","ܩܵܠܵܐ ܦܝܼܫ ܠܹܗ ܫܡܝܼܥܵܐ ܓܵܘ ܪܵܡܬܵ‌ܐ، ܒܸܟ݂ܝܵܐ ܘܐܸܠܝܵܐ ܪܵܒܵܐ؛ ܪܵܚܹܝܠܔ ܒܸܒܟ݂ܵܝܵܐ ܥܲܠܔ ܒܢܘܿܢܘܼ̈ܗ̇، ܘܠܹܐ ܒܵܣܡܵܐ ܗܘܵܐ ܠܵܗ̇ ܠܸܫܩܵܠܵܐ ܠܸܒܵܐ، ܣܵܒܵܒ ܡܝܼܬܹ‌ܐ ܝܗܘܵܘ. ");
INSERT INTO aii_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ܐܝܼܡܲܢ ܕܡܝܼܬ ܠܹܗ ܗܹܪܘܿܕܸܣ، ܦܝܼܫ ܠܹܗ ܚܸܙܝܵܐ ܡܲܠܲܐܟ݂ܵܐ ܕܡܵܪܝܵܐ ܒܚܸܠܡܵܐ ܠܝܵܘܣܸܦ ܓܵܘ ܡܸܨܪܹܝܢ، ");
INSERT INTO aii_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܩܘܼܡ، ܠܲܒܸܠܔ ܠܝܵܠܵܕ݇ܐ ܘܠܝܸܡܹܗ، ܘܙܹܠܔ݇ ܠܐܲܪܥܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ، ܣܵܒܵܒ ܡܝܼܬ ܠܗܘܿܢ ܐܵܢܝܼ ܕܒܸܒܥܵܝܵܐ ܝܗܘܵܘ ܠܸܩܛܵܠܹܗ ܝܵܠܵܕ݇ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ܗ̇ܝܓܵܗ ܩܝܼܡ ܠܹܗ ܝܵܘܣܸܦ ܘܫܩܝܼܠܔ ܠܹܗ ܠܝܵܠܵܕ݇ܐ ܘܠܝܸܡܹܗ، ܘܐܙܝܼܠܔ ܠܹܗ ܠܐܲܪܥܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ܐܝܼܢܵܐ ܟܲܕ ܫܡܝܼܥ ܠܹܗ ܕܐܲܪܟܹܠܹܐܘܿܣ ܗܘܹܐ ܠܹܗ ܡܲܠܟܵܐ ܒܝܼܗܘܼܕ ܡ̣ܢ ܓܹܒܵܐ ܕܗܹܪܘܿܕܸܣ ܒܵܒܘܼܗ‌ܝ، ܙܕܝܼܥ ܠܹܗ ܕܐܵܙܹܠܔ ܗܘܵܐ ܠܬܵܡܵܐ؛ ܘܟܲܕ ܦܝܼܫ ܠܹܗ ܡܘܼܕܸܥܵܐ ܒܚܸܠܡܵܐ، ܐܬܹ‌ܐ ܠܹܗ ܠܐܲܬܪܵܐ ܕܓܠܝܼܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ܘܐܬܹ‌ܐ ܠܹܗ ܥܡܝܼܪܹܗ ܒܡܕܝܼܢ݇ܬܵ‌ܐ ܕܦܵܝܫܵܐ ܩܪܝܼܬܵ‌ܐ ܢܵܨܪܲܬ، ܕܦܵܐܹܫ ܬܘܼܡܸܡܵܐ ܡܸܢܕܝܼ ܕܦܝܼܫ ܠܹܗ ܐܡܝܼܪܵܐ ܒܝܲܕ ܢܒ݂ܝܼܹ̈ܐ، ܕܢܵܨܪܵܝܵܐ ܒܸܬ ܦܵܐܹܫ ܩܸܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ܒܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ، ܐܬܹ‌ܐ ܠܹܗ ܝܘܿܚܲܢܵܢ ܡܲܥܡܕܵܢܵܐ، ܡܲܟܪܘܼܙܹܐ ܓܵܘ ܒܲܪܝܼܵܐ ܕܝܼܗܘܼܕ، ");
INSERT INTO aii_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ܒܹܐܡܵܪܵܐ: ”ܬܲܘܸܒܘܼܢ، ܣܵܒܵܒ ܩܘܼܪܒܸܢܵܗ̇ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ܐܵܗܵܐ ܝܠܹܗ ܗ̇ܘ ܕܦܝܼܫ ܠܹܗ ܐܡܝܼܪܵܐ ܒܘܼܬ ܕܝܼܹܗ ܒܝܲܕ ܐܹܫܲܥܝܵܐ ܢܒ݂ܝܼܵܐ، ܕܐܡܝܼܪܹܗ: ܩܵܠܵܐ ܒܸܩܪܵܝܵܐ ܓܵܘ ܒܲܪܝܼܵܐ: ”ܗܲܕܪܘܼܢ ܐܘܼܪܚܵܐ ܕܡܵܪܝܵܐ، ܘܡܲܫܘܹܝܡܘܼܢ ܠܗܘܿܢ ܫܒ݂ܝܼܠܘܼ̈ܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ܘܠܒ݂ܝܼܫܬܵ‌ܐ ܕܝܘܿܚܲܢܵܢ ܡ̣ܢ ܣܲܥܪܵܐ ܕܓܘܼܡܠܹ̈ܐ ܝܗܘܵܐ، ܘܐܝܼܬ ܗܘܵܐ ܠܹܗ ܙܘܼܢܵܪܵܐ ܕܓܸܠܕܵܐ ܒܚܲܨܹܗ، ܘܡܹܐܟ݂ܘܼܠܬܹܗ ܩܲܡܨܹ̈ܐ ܝܗܘܵܐ ܘܕܸܒ݂ܫܵܐ ܕܒܲܪܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ܗ̇ܝܓܵܗ ܦܠܝܼܛ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܐܢܵܫܹ̈ܐ ܕܐܘܿܪܸܫܠܸܡ ܘܟܠܵܗ̇ ܝܼܗܘܼܕ، ܘܟܠܹܗ ܐܲܬܪܵܐ ܕܚܵܕܸܪ̈ܘܵܢܹܐ ܕܝܘܿܪܕܢܵܢ. ");
INSERT INTO aii_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ܘܦܵܝܫܝܼ ܗܘܵܘ ܡܘܼܥܡܸܕܹܐ ܒܝܼܹܗ ܓܵܘ ܢܲܗܪܵܐ ܕܝܘܿܪܕܢܵܢ، ܟܲܕ ܡܵܘܕܘܼܝܹܐ ܒܚܛܝܼܵܬܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ܐܝܼܢܵܐ ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܹܗ ܪܵܒܵܐ ܡ̣ܢ ܦܪ̈ܝܼܫܹܐ ܘܙܲܕܘܼܩܵܝܹ̈ܐ ܒܹܐܬܵܝܵܐ ܝܗܘܵܘ ܠܡܲܥܡܘܿܕܝܼܬܹܗ، ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܝܵܐ ܙܲܪ̈ܥܹܐ ܕܐܵܟܸܕܢܹ̈ܐ، ܡܵܢܝܼ ܡܘܼܕܸܥ ܠܹܗ ܐܸܠܵܘܟ݂ܘܿܢ ܕܥܵܪܩܝܼܬܘܿܢ ܡ̣ܢ ܟܲܪܒܵܐ ܕܒܹܐܬܵܝܵܐ ܝܠܵܗ̇؟ ");
INSERT INTO aii_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","”ܗܵܕܟ݂ܵܐ ܥܒ݂ܘܿܕܘܼܢ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܕܚܵܫܚܝܼ ܠܬܝܵܒ݂ܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","”ܘܠܵܐ ܚܵܫܒ݂ܝܼܬܘܿܢ ܘܐܵܡܪܝܼܬܘܿܢ ܒܓܵܢܵܘܟ݂ܘܿܢ: ’ܒܵܒܵܐ ܐܝܼܬ ܠܲܢ، ܐܲܒ݂ܪܵܗܵܡ،‘ ܣܵܒܵܒ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ ܕܐܲܠܵܗܵܐ ܡܵܨܹܐ ܡ̣ܢ ܐܲܢܹܐ ܟܹܐܦܹ̈ܐ ܡܲܩܸܡ ܒܢܘܿܢܹ̈ܐ ܠܐܲܒ݂ܪܵܗܵܡ! ");
INSERT INTO aii_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","”ܗܵܐ ܢܲܪܥܵܐ ܦܝܼܫܵܐ ܝܠܹܗ ܡܘܼܬܒ݂ܵܐ ܥܲܠܔ ܥܸܩܪܵܐ ܕܐܝܼܠܵܢܹ̈ܐ؛ ܘܟܠܔ ܐܝܼܠܵܢܵܐ ܕܠܵܐ ܛܵܥܹܢ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܛܵܒܹ̈ܐ ܒܸܬ ܦܵܐܹܫ ܦܪܝܼܡܵܐ ܘܕܸܪܝܵܐ ܒܢܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","”ܐܵܢܵܐ ܡܲܥܡܘܼܕܹܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ ܒܡ̈ܝܼܵܐ ܠܬܝܵܒ݂ܘܼܬܵ‌ܐ، ܐܝܼܢܵܐ ܗ̇ܘ ܕܒܹܐܬܵܝܵܐ ܝܠܹܗ ܡ̣ܢ ܒܵܬܪ ܕܝܼܝܼ ܒܘܼܫ ܚܲܝܠܵܢܵܐ ܝܠܹܗ ܡܸܢܝܼ، ܗ̇ܘ ܕܐܵܢܵܐ ܠܹܐ ܚܵܫܚܹܢ ܕܛܵܥܢܹܢ ܠܨܵܘܠܘܼ̈ܗ‌ܝ. ܗ̇ܘ ܒܸܬ ܡܲܥܡܸܕ ܠܵܘܟ݂ܘܿܢ ܒܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ ܘܒܢܘܼܪܵܐ، ");
INSERT INTO aii_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","”ܗ̇ܘ ܕܪܘܼܦ̮ܫܬܵ‌ܐ ܒܐܝܼܕܹܗ ܝܠܵܗ̇ ܘܒܸܬ ܕܲܟܹܐ ܠܒܹܐܕܪ̈ܵܬܘܼܗ‌ܝ، ܘܒܸܬ ܟܲܦܸܫ ܚܸܛܹ̈ܐ ܠܐܲܢܒܵܪ̈ܘܼܗ‌ܝ، ܘܒܸܬ ܡܲܩܸܕ ܬܸܒ݂ܢܵܐ ܓܵܘ ܢܘܼܪܵܐ ܕܠܹܐ ܟ̰ܵܡܹܥ.“ ");
INSERT INTO aii_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ܗ̇ܝܓܵܗ ܐܬܹ‌ܐ ܠܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܓܠܝܼܠܵܐ ܠܝܘܿܪܕܢܵܢ، ܠܟܸܣ ܝܘܿܚܲܢܵܢ، ܕܦܵܐܹܫ ܗܘܵܐ ܡܘܼܥܡܸܕܵܐ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ܐܝܼܢܵܐ ܝܘܿܚܲܢܵܢ ܡܘܼܟܠܹܐ ܠܹܗ ܐܸܠܹܗ ܘܐܡܝܼܪܹܗ: ”ܐܵܢܵܐ ܣܢܝܼܩܵܐ ܝܘܸܢ ܕܦܵܝܫܹܢ ܡܘܼܥܡܸܕܵܐ ܒܝܼܘܼܟ݂، ܘܐܲܢ݇ܬ ܠܟܸܣܠܝܼ ܒܹܐܬܵܝܵܐ ܝܘܸܬ؟“ ");
INSERT INTO aii_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܓ̰ܘܼܘܸܒ ܠܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܫܒ݂ܘܿܩ ܐܵܕܝܼܵܐ، ܣܵܒܵܒ ܗܵܕܟ݂ܵܐ ܘܵܠܹܐ ܝܠܵܗ̇ ܐܸܠܲܢ ܕܬܲܡܸܡܲܚ ܟܠܵܗ̇ ܟܹܐܢܘܼܬܵ‌ܐ.“ ܗ̇ܝܓܵܗ ܫܒ݂ܝܼܩ ܠܹܗ ܕܡܲܥܡܸܕ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ܘܟܲܕ ܦܝܼܫ ܠܹܗ ܡܘܼܥܡܸܕܵܐ ܝܼܫܘܿܥ، ܐܣܝܼܩ ܠܹܗ ܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܡ̣ܢ ܡ̈ܝܼܵܐ، ܘܦܝܼܫ ܠܗܘܿܢ ܦܬܝܼܚܹܐ ܐܸܠܹܗ ܫܡܲܝܹ̈ܐ، ܘܚܙܹܐ ܠܹܗ ܠܪܘܼܚܵܐ ܕܐܲܠܵܗܵܐ ܒܸܨܠܵܝܵܐ ܐܲܝܟ݂ ܝܵܘܢܵܐ ܘܒܹܐܬܵܝܵܐ ܥܲܠܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ܘܗܵܐ، ܩܵܠܵܐ ܡ̣ܢ ܫܡܲܝܵܐ ܒܹܐܡܵܪܵܐ: ”ܐܵܗܵܐ ܝܠܹܗ ܒܪܘܿܢܝܼ ܡܘܼܚܸܒܵܐ ܕܒܝܼܹܗ ܒܣܝܼܡ ܠܵܗ̇ ܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ܗ̇ܝܓܵܗ ܦܝܼܫ ܠܹܗ ܠܘܼܒܠܵܐ ܝܼܫܘܿܥ ܒܝܲܕ ܪܘܼܚܵܐ ܠܒܲܪܝܼܵܐ ܕܦܵܐܹܫ ܓ̰ܘܼܪܒܵܐ ܒܐܵܟܹܠܩܲܪܨܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ܘܨܝܼܡ ܠܹܗ ܐܲܪܒܥܝܼ ܝܵܘܡܵܢܹ̈ܐ ܘܐܲܪܒܥܝܼ ܠܲܝܠܵܘܵܬܹ̈‌ܐ، ܘܒܚܲܪܬܵ‌ܐ ܟܦܝܼܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ܘܩܘܼܪܒܸܢܹܗ ܓ̰ܲܪܒܵܢܵܐ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܐܸܢ ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ ܝܘܸܬ، ܦܩܘܿܕ ܠܐܲܢܹܐ ܟܹܐܦܹ̈ܐ ܕܗܵܘܝܼ ܠܲܚܡܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ܐܝܼܢܵܐ ܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ ܘܐܡܝܼܪܹܗ: ”ܦܝܼܫܬܵ‌ܐ ܝܠܵܗ̇ ܟܬܝܼܒ݂ܬܵ‌ܐ: ܠܹܐ ܝܠܵܗ̇ ܐܲܚܟ̰ܝܼ ܒܠܲܚܡܵܐ ܕܟܹܐ ܚܵܝܹܐ ܒܲܪܢܵܫܵܐ، ܐܸܠܵܐ ܒܟܠܔ ܗܹܡܸܙܡܵܢ ܕܦܵܠܛܵܐ ܡ̣ܢ ܦܘܼܡܵܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ܗ̇ܝܓܵܗ ܠܘܼܒܸܠܔ ܠܹܗ ܐܸܠܹܗ ܐܵܟܹܠܩܲܪܨܵܐ ܠܡܕܝܼܢ݇ܬܵ‌ܐ ܩܲܕܝܼܫܬܵ‌ܐ، ܘܡܘܼܟܠܹܐ ܠܹܗ ܐܸܠܹܗ ܥܲܠܔ ܟܸܢܦܵܐ ܕܗܲܝܟܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܐܸܢ ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ ܝܘܸܬ، ܪܲܦܝܼ ܓܵܢܘܼܟ݂ ܠܬܸܚܬ؛ ܣܵܒܵܒ ܦܝܼܫܬܵ‌ܐ ܝܠܵܗ̇ ܟܬܝܼܒ݂ܬܵ‌ܐ: ܒܸܬ ܦܵܩܹܕ ܠܡܲܠܲܐܟ݂ܘܼ̈ܗ‌ܝ ܒܘܼܬ ܕܝܼܘܼܟ݂، ܘܒܸܬ ܛܵܥܢܝܼ ܠܘܼܟ݂ ܥܲܠܔ ܐܝܼܕܵܬܵܝ̈ܗ‌ܝ، ܕܠܵܐ ܬܲܪܩܸܠܵܐ ܐܲܩܠܘܼܟ݂ ܒܟܹܐܦܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܡܸܢܕܪܸܫ ܦܝܼܫܬܵ‌ܐ ܝܠܵܗ̇ ܟܬܝܼܒ݂ܬܵ‌ܐ: ܠܵܐ ܓ̰ܲܪܒܸܬ ܠܡܵܪܝܵܐ ܐܲܠܵܗܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ܡ̣ܢ ܒܵܬܪ ܐܵܗܵܐ، ܡܸܢܕܪܸܫ ܠܘܼܒܸܠܔ ܠܹܗ ܐܸܠܹܗ ܐܵܟܹܠܩܲܪܨܵܐ ܠܚܲܕ ܛܘܼܪܵܐ ܪܵܒܵܐ ܪܵܡܵܐ، ܘܡܘܼܚܙܹܐ ܠܹܗ ܐܸܠܹܗ ܟܠܵܝܗ‌ܝ ܡܲܠܟܘܵܬܹ̈‌ܐ ܕܕܘܼܢܝܹܐ ܘܚܸܩܪܵܝܗ‌ܝ؛ ");
INSERT INTO aii_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܒܸܬ ܝܵܗܒܹܢ ܐܸܠܘܼܟ݂ ܟܠܵܝܗ‌ܝ ܐܲܢܹܐ، ܐܸܢ ܢܵܦܠܹܬ ܘܣܵܓ݂ܕܹܬ ܐܸܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ܗ̇ܝܓܵܗ ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܛܠܘܿܩ، ܝܵܐ ܣܵܛܵܢܵܐ، ܣܵܒܵܒ ܦܝܼܫܬܵ‌ܐ ܝܠܵܗ̇ ܟܬܝܼܒ݂ܬܵ‌ܐ: ܠܡܵܪܝܵܐ ܐܲܠܵܗܘܼܟ݂ ܣܵܓ݂ܕܹܬ، ܘܐܸܠܹܗ ܒܢܲܦ̮ܫܹܗ ܦܵܠܚܹܬ.“ ");
INSERT INTO aii_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ܗ̇ܝܓܵܗ، ܫܒ݂ܝܼܩ ܠܹܗ ܐܸܠܹܗ ܐܵܟܹܠܩܲܪܨܵܐ، ܘܗܵܐ ܡܲܠܲܐܟܹ̈ܐ ܐܬܹ‌ܐ ܠܗܘܿܢ ܘܥܒ݂ܝܼܕ ܠܗܘܿܢ ܚܸܠܡܲܬ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܹܗ ܝܼܫܘܿܥ ܕܦܝܼܫ ܠܹܗ ܕܒ݂ܝܼܩܵܐ ܝܘܿܚܲܢܵܢ، ܫܘܼܢܹܐ ܠܹܗ ܠܓܠܝܼܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ܘܫܒ݂ܝܼܩܵܐ ܠܹܗ ܢܵܨܪܲܬ، ܐܬܹ‌ܐ ܠܹܗ ܘܥܡܝܼܪܹܗ ܓܵܘ ܟܦܲܪܢܵܚܘܿܡ، ܕܝܼܠܵܗ̇ ܥܲܠܔ ܡܲܪܙܵܐ ܕܝܵܡܵܐ، ܓܵܘ ܬܚܘܼܡܵܐ ܕܙܒ݂ܘܿܠܘܿܢ ܘܕܢܲܦ̮ܬܵܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ܗܵܕܟ݂ܵܐ ܕܦܵܐܹܫ ܬܘܼܡܸܡܵܐ ܡܸܢܕܝܼ ܕܦܝܼܫ ܠܹܗ ܐܡܝܼܪܵܐ ܒܐܹܫܲܥܝܵܐ ܢܒ݂ܝܼܵܐ ܕܐܡܝܼܪܹܗ: ");
INSERT INTO aii_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","ܐܲܪܥܵܐ ܕܙܒ݂ܘܿܠܘܿܢ، ܐܲܪܥܵܐ ܕܢܲܦ̮ܬܵܠܝܼ، ܕܝܼܠܵܗ̇ ܥܲܠܔ ܐܘܼܪܚܵܐ ܕܝܵܡܵܐ، ܥܸܒ݂ܪܵܐ ܕܝܘܿܪܕܢܵܢ، ܓܠܝܼܠܵܐ ܕܐܸܡܘܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ܥܲܡܵܐ ܕܝܬܝܼܒ݂ܵܐ ܝܠܹܗ ܓܵܘ ܚܸܫܟܵܐ ܚܙܹܐ ܠܹܗ ܒܲܗܪܵܐ ܓܘܼܪܵܐ، ܘܐܵܢܝܼ ܕܝܬܝܼܒܹܐ ܝܢܵܐ ܒܐܲܪܥܵܐ ܘܒܛܸܠܵܠܹ̈ܐ ܕܡܵܘܬܵ‌ܐ، ܙܪܝܼܩ ܠܹܗ ܒܲܗܪܵܐ ܥܲܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ܡ̣ܢ ܗ̇ܝ ܥܕܵܢܵܐ ܫܘܼܪܹܐ ܠܹܗ ܝܼܫܘܿܥ ܡܲܟܪܘܼܙܹܐ ܘܒܹܐܡܵܪܵܐ: ”ܬܲܘܸܒܘܼܢ، ܣܵܒܵܒ ܩܘܼܪܒܸܢܬܵ‌ܐ ܝܠܵܗ̇ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ܟܲܕ ܒܸܚܕܵܪܵܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܥܲܠܔ ܡܲܪܙܵܐ ܕܝܵܡܵܐ ܕܓܠܝܼܠܵܐ ܚܙܹܐ ܠܹܗ ܬܪܹܝ ܐܲܚܘܿܢܘܵܬܹ̈‌ܐ، ܫܸܡܥܘܿܢ ܕܦܝܼܫ ܠܹܗ ܩܸܪܝܵܐ ܟܹܐܦܵܐ ܘܐܲܢܕܪܹܐܘܿܣ ܐܲܚܘܿܢܘܼܗ‌ܝ، ܒܸܕܪܵܝܵܐ ܓܲܪ̈ܕܵܝܗ‌ܝ ܓܵܘ ܝܵܡܵܐ، ܣܵܒܵܒ ܨܲܝܵܕܹ̈ܐ ܝܗܘܵܘ. ");
INSERT INTO aii_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܬܹܝܡܘܼܢ ܒܵܬܪܝܼ ܘܒܸܬ ܥܵܒ݂ܕܹܢܵܘܟ݂ܘܿܢ ܨܲܝܵܕܹ̈ܐ ܕܒܢܲܝ̈ܢܵܫܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ܘܒܗ̇ܝ ܥܕܵܢܵܐ، ܫܒ݂ܝܼܩ ܠܗܘܿܢ ܓܲܪ̈ܕܵܝܗ‌ܝ ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܒܵܬܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ܘܟܲܕ ܥܒ݂ܝܼܪܹܗ ܡ̣ܢ ܬܵܡܵܐ، ܚܙܹܐ ܠܹܗ ܬܪܹܝ ܐܲܚܘܿܢܘܵܬܹ̈‌ܐ ܐܚܹܪ̈ܢܹܐ، ܝܲܥܩܘܿܒ݂ ܒܪܘܿܢܵܐ ܕܙܲܒ݂ܕܲܝ ܘܝܘܿܚܲܢܵܢ ܐܲܚܘܿܢܘܼܗ‌ܝ، ܓܵܘ ܓܵܡܝܼ ܥܲܡ ܙܲܒ݂ܕܲܝ ܒܵܒܵܝܗ‌ܝ ܬܲܪܘܼܨܹܐ ܓܲܪ̈ܕܵܝܗ‌ܝ؛ ܘܩܸܪܝܵܝ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܫܒ݂ܝܼܩ ܠܗܘܿܢ ܠܓܵܡܝܼ ܘܠܒܵܒܵܝܗ‌ܝ ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܒܵܬܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ܒܸܚܕܵܪܵܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܒܟܠܹܗ ܓܠܝܼܠܵܐ ܘܡܲܠܘܼܦܹܐ ܝܗܘܵܐ ܓܵܘ ܟܢܘܼܫܝܵܬܵܝ̈ܗ‌ܝ ܘܡܲܟܪܘܼܙܹܐ ܐܹܘܲܢܓܲܠܝܼܘܿܢ ܕܡܲܠܟܘܼܬܵ‌ܐ ܘܒܲܣܘܼܡܹܐ ܟܠܔ ܟܹܐܒ݂ܵܐ ܘܟܠܔ ܡܲܪܥܵܐ ܕܓܵܘ ܥܲܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ܦܝܼܫ ܠܵܗ̇ ܫܡܝܼܥܬܵ‌ܐ ܒܘܼܬ ܕܝܼܹܗ ܓܵܘ ܟܠܵܗ̇ ܣܘܼܪܝܼܵܐ، ܘܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܓ̰ܲܢܓ̰ܘܼܪܹܐ ܝܗܘܵܘ ܒܡܲܪ̈ܥܹܐ ܦܪ̈ܝܼܫܹܐ ܘܡܘܼܠܝܸܨܹܐ ܒܬܘܼܫܢܵܩܹ̈ܐ، ܘܐܵܢܝܼ ܕܐܝܼܬ ܗܘܵܘ ܒܝܼܵܝܗ‌ܝ ܫܹܐܕܹ̈ܐ، ܘܒܲܪ ܐܸܓܵܪܹ̈ܐ، ܘܫܦܝܼܠܹ̈ܐ، ܘܒܘܼܣܡܵܝ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܒܵܬܪܹܗ ܪܵܒܵܐ ܟܸܢܫܹ̈ܐ ܡ̣ܢ ܓܠܝܼܠܵܐ ܘܡ̣ܢ ܐܘܼܚܕܵܢܵܐ ܕܥܸܣܪܲܬ ܡܕܝܼܢܵܬܹ̈‌ܐ ܘܡ̣ܢ ܐܘܿܪܸܫܠܸܡ ܘܡ̣ܢ ܝܼܗܘܼܕ، ܘܡ̣ܢ ܥܸܒ݂ܪܵܐ ܕܝܘܿܪܕܢܵܢ. ");
INSERT INTO aii_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܹܗ ܝܼܫܘܿܥ ܠܟܸܢܫܹ̈ܐ، ܐܣܝܼܩ ܠܹܗ ܠܛܘܼܪܵܐ؛ ܘܟܲܕ ܝܬܝܼܒ݂ ܠܹܗ، ܩܘܼܪܒܸܢܗܘܿܢ ܠܟܸܣܠܹܗ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ܘܫܘܼܪܹܐ ܠܹܗ ܠܡܲܠܘܼܦܵܝ ܘܐܡܝܼܪܹܗ: ");
INSERT INTO aii_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","”ܛܘܼܒ݂ܵܐ ܠܡܸܣܟܹܢܹ̈ܐ ܒܪܘܼܚܵܐ، ܣܵܒܵܒ ܕܝܼܵܝܗ‌ܝ ܝܠܵܗ̇ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","”ܛܘܼܒ݂ܵܐ ܠܥܵܒ݂ܕܵܢܹ̈ܐ ܕܬܵܥܙܝܼ، ܣܵܒܵܒ ܐܵܢܝܼ ܒܸܬ ܦܵܝܫܝܼ ܝܘܼܗܒܹܐ ܠܸܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","”ܛܘܼܒ݂ܵܐ ܠܡܲܟܝܼܟܹ̈ܐ، ܣܵܒܵܒ ܐܵܢܝܼ ܒܸܬ ܝܵܪܬ‌ܝܼ ܠܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","”ܛܘܼܒ݂ܵܐ ܠܐܵܢܝܼ ܕܟܵܦܢܝܼ ܘܨܵܗ‌ܝܼ ܠܟܹܐܢܘܼܬܵ‌ܐ، ܣܵܒܵܒ ܐܵܢܝܼ ܒܸܬ ܣܵܒ݂ܥܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","”ܛܘܼܒ݂ܵܐ ܠܡܪ̈ܲܚܡܵܢܹܐ، ܣܵܒܵܒ ܥܲܠܵܝܗ‌ܝ ܒܸܬ ܗܵܘܝܼ ܪ̈ܲܚܡܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","”ܛܘܼܒ݂ܵܐ ܠܐܵܢܝܼ ܕܝܼܢܵܐ ܕܸܟ݂ܝܹܐ ܒܠܸܒܵܝܗ‌ܝ، ܣܵܒܵܒ ܐܵܢܝܼ ܒܸܬ ܚܵܙܝܼ ܠܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","”ܛܘܼܒ݂ܵܐ ܠܥܵܒ݂ܕܵܢܹ̈ܐ ܕܫܠܵܡܵܐ، ܣܵܒܵܒ ܒܢܘܿܢܹ̈ܐ ܕܐܲܠܵܗܵܐ ܒܸܬ ܦܵܝܫܝܼ ܩܸܪܝܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","”ܛܘܼܒ݂ܵܐ ܠܐܵܢܝܼ ܕܩܘܼܒܸܠܔ ܠܗܘܿܢ ܪܕܘܼܦܝܵܐ ܒܘܼܬ ܟܹܐܢܘܼܬܵ‌ܐ، ܣܵܒܵܒ ܕܝܼܵܝܗ‌ܝ ܝܠܵܗ̇ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","”ܛܘܼܒ݂ܵܐ ܐܸܠܵܘܟ݂ܘܿܢ ܐܝܼܡܲܢ ܕܠܵܝܡܝܼ ܠܵܘܟ݂ܘܿܢ ܘܟܲܡܪܝܼ ܠܵܘܟ݂ܘܿܢ ܘܗܲܡܙܸܡܝܼ ܥܲܠܵܘܟ݂ܘܿܢ ܒܕܲܓܵܠܘܼܬܵ‌ܐ ܟܠܔ ܗܹܡܸܙܡܵܢ ܒܝܼܫܬܵ‌ܐ ܒܘܼܬ ܕܝܼܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","”ܗ̇ܝܓܵܗ ܚܕܹܝܡܘܼܢ ܘܦܨܘܿܚܘܼܢ، ܣܵܒܵܒ ܙܝܼܕ ܠܹܗ ܦܘܼܪܥܵܢܵܘܟ݂ܘܿܢ ܒܫܡܲܝܵܐ. ܣܵܒܵܒ ܗܵܕܟ݂ܵܐ ܟܘܼܡܸܪܗܘܿܢ ܠܢܒ݂ܝܼܹ̈ܐ ܕܡܩܲܕܡ ܡܸܢܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","”ܐܲܚܬܘܿܢ ܝܼܬܘܿܢ ܡܸܠܚܵܐ ܕܐܲܪܥܵܐ، ܐܝܼܢܵܐ ܐܸܢ ܡܸܠܚܵܐ ܦܵܝܟܵܐ، ܒܡܘܼܕܝܼ ܒܸܬ ܦܵܝܫܵܐ ܡܠܝܼܚܬܵ‌ܐ؟ ܐܚܹܪܢܵܐ ܠܹܐ ܚܵܫܚܵܐ، ܐܸܠܵܐ ܕܦܵܝܫܵܐ ܪܘܼܦܝܼܬܵ‌ܐ ܠܒܲܕܲܪ ܘܕܘܼܫܕܸܫܬܵ‌ܐ ܒܐܢܵܫܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","”ܐܲܚܬܘܿܢ ܝܼܬܘܿܢ ܒܲܗܪܵܐ ܕܕܘܼܢܝܹܐ. ܡܕܝܼܢ݇ܬܵ‌ܐ ܒܢܝܼܬܵ‌ܐ ܥܲܠܔ ܛܘܼܪܵܐ ܠܹܐ ܐܵܬܝܵܐ ܠܛܲܫܘܼܝܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","”ܘܠܹܐ ܡܲܠܗ‌ܝܼ ܫܪܵܓ݂ܵܐ ܘܡܲܬܒ݂ܝܼ ܠܵܗ̇ ܬܚܘܿܬ ܣܲܐܬܵ‌ܐ، ܐܸܠܵܐ ܥܲܠܔ ܡܢܵܪܬܵ‌ܐ ܕܒܲܗܪܸܢܵܐ ܠܐܵܢܝܼ ܕܝܼܢܵܐ ܓܵܘ ܒܲܝܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","”ܫܒ݂ܘܿܩܘܼܢ ܒܲܗܪܵܘܟ݂ܘܿܢ ܗܵܕܟ݂ܵܐ ܒܲܗܪܸܢ ܩܲܕܡ ܒܢܲܝ̈ܢܵܫܵܐ، ܕܚܵܙܝܼ ܦܘܼܠܚܵܢܵܘ̈ܟ݂ܘܿܢ ܛܵܒܹ̈ܐ ܘܫܲܒܚܝܼ ܠܒܵܒܵܘܟ݂ܘܿܢ ܕܒܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","”ܠܵܐ ܚܵܫܒ݂ܝܼܬܘܿܢ ܕܐܬܹ‌ܐ ܠܝܼ ܕܒܲܛܠܸܢ ܠܢܵܡܘܿܣܵܐ ܝܲܢ ܠܢܒ݂ܝܼܹ̈ܐ. ܠܵܐ ܐܬܹ‌ܐ ܠܝܼ ܕܒܲܛܠܸܢ ܐܸܠܵܐ ܕܬܲܡܸܡܸܢ. ");
INSERT INTO aii_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܗܲܠܔ ܕܬܵܝܡܝܼ ܫܡܲܝܵܐ ܘܐܲܪܥܵܐ، ܠܹܐ ܢܵܦܠܵܐ ܚܕܵܐ ܝܘܿܕ، ܘܠܹܐ ܢܵܦܹܠܔ ܚܲܕ ܣܸܪܛܵܐ ܡ̣ܢ ܢܵܡܘܿܣܵܐ، ܗܲܠܔ ܕܟܠܹܗ ܦܵܐܹܫ ܬܘܼܡܸܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","”ܒܘܼܬ ܐܵܗܵܐ، ܟܠܔ ܡ̇ܢ ܕܫܵܪܹܐ ܚܲܕ ܡ̣ܢ ܐܲܢܹܐ ܦܘܼܩܕܵܢܹ̈ܐ ܪܵܒܵܐ ܙܥܘܿܪܹ̈ܐ، ܝܲܢ ܗܵܕܟ݂ܵܐ ܡܲܠܸܦ ܠܒܢܲܝ̈ܢܵܫܵܐ، ܒܸܬ ܦܵܐܹܫ ܩܸܪܝܵܐ ܪܵܒܵܐ ܙܥܘܿܪܵܐ ܓܵܘ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ؛ ܐܝܼܢܵܐ ܟܠܔ ܡ̇ܢ ܕܢܵܛܹܪܗܘܿܢ ܘܡܲܠܸܦ ܠܗܘܿܢ، ܐܵܗܵܐ ܓܘܼܪܵܐ ܒܸܬ ܦܵܐܹܫ ܩܸܪܝܵܐ ܓܵܘ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","”ܐܵܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܐܸܢ ܠܵܐ ܙܵܝܕܵܐ ܟܹܐܢܘܼܬܵܘܟ݂ܘܿܢ ܒܘܼܫ ܡ̣ܢ ܗ̇ܝ ܕܣܵܦܪܹ̈ܐ ܘܕܦܪ̈ܝܼܫܹܐ، ܠܹܐ ܥܵܒ݂ܪܝܼܬܘܿܢ ܠܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","”ܫܡܝܼܥ ܠܵܘܟ݂ܘܿܢ ܕܦܝܼܫ ܠܵܗ̇ ܐܡܝܼܪܬܵ‌ܐ ܠܐܵܢܝܼ ܕܩܲܕܡ ܕܝܼܵܘܟ݂ܘܿܢ: ’ܠܵܐ ܩܵܛܠܹܬ،‘ ܘܡ̇ܢ ܕܩܵܛܹܠܔ، ܚܲܝܵܒ݂ܵܐ ܝܠܹܗ ܠܕܝܵܢܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","”ܐܝܼܢܵܐ ܐܵܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ: ܟܠܔ ܡ̇ܢ ܕܟܵܪܹܒ ܥܲܠܔ ܐܲܚܘܿܢܘܼܗ‌ܝ ܕܠܵܐ ܚܕܵܐ ܥܸܠܬܵ‌ܐ، ܚܲܝܵܒ݂ܵܐ ܝܠܹܗ ܠܕܝܵܢܬܵ‌ܐ؛ ܘܟܠܔ ܡ̇ܢ ܕܩܵܪܹܐ ܠܐܲܚܘܿܢܘܼܗ‌ܝ ܣܲܟ݂ܠܵܐ، ܚܲܝܵܒ݂ܵܐ ܝܠܹܗ ܩܲܕܡ ܟܢܘܼܫܝܵܐ؛ ܘܟܠܔ ܡ̇ܢ ܕܐܵܡܹܪ ܫܹܐܕܵܢܵܐ، ܚܲܝܵܒ݂ܵܐ ܝܠܹܗ ܠܓܹܗܲܢܵܐ ܕܢܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","”ܗܵܕܟ݂ܵܐ ܐܸܢ ܡܲܩܪܘܼܒܹܐ ܝܘܸܬ ܩܘܼܪܒܵܢܘܼܟ݂ ܥܲܠܔ ܡܲܕܒܚܵܐ، ܘܬܵܡܵܐ ܕܵܟ݂ܪܹܬ ܕܐܲܚܘܿܢܘܼܟ݂ ܕܒ݂ܝܼܩܵܐ ܝܠܹܗ ܟܲܪܒܵܐ ܒܠܸܒܹܗ ܥܲܠܘܼܟ݂، ");
INSERT INTO aii_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","”ܫܒ݂ܘܿܩ ܩܘܼܪܒܵܢܘܼܟ݂ ܬܵܡܵܐ ܥܲܠܔ ܡܲܕܒܚܵܐ، ܘܙܹܠܔ݇ ܩܲܕܡܵܝܬܵ‌ܐ ܣܲܙܓܸܪ ܥܲܡ ܐܲܚܘܿܢܘܼܟ݂، ܘܗ̇ܝܓܵܗ ܬܵ‌ܐ ܘܡܲܩܪܸܒ݂ ܩܘܼܪܒܵܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","”ܥܒ݂ܘܿܕ ܫܠܵܡܵܐ ܥܲܡ ܕܲܠܩܘܼܒ݂ܠܵܝܘܼܟ݂ ܒܓ̰ܲܠܕܘܼܬܵ‌ܐ ܟܲܕ ܒܹܐܙܵܠܵܐ ܝܘܸܬ ܥܲܡܹܗ ܠܕܝܼܘܵܢ؛ ܕܠܵܐ ܣܲܦܹܐ ܠܘܼܟ݂ ܕܲܠܩܘܼܒ݂ܠܵܝܘܼܟ݂ ܠܕܲܝܵܢܵܐ، ܘܕܲܝܵܢܵܐ ܣܲܦܹܐ ܠܘܼܟ݂ ܠܢܵܛܘܿܪܵܐ، ܘܦܵܝܫܹܬ ܕܸܪܝܵܐ ܓܵܘ ܒܹܝܬ ܐܲܣܝܼܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܘܼܟ݂، ܕܠܹܐ ܦܵܠܛܹܬ ܡ̣ܢ ܬܵܡܵܐ، ܗܲܠܔ ܕܝܵܗܒܹܬ ܦܘܼܠܣܵܐ ܐܚܵܪܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","”ܫܡܝܼܥ ܠܵܘܟ݂ܘܿܢ ܕܦܝܼܫ ܠܵܗ̇ ܐܡܝܼܪܬܵ‌ܐ: ’ܠܵܐ ܥܵܒ݂ܕܹܬ ܓܲܝܵܪܘܼܬܵ‌ܐ.‘ ");
INSERT INTO aii_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","”ܐܝܼܢܵܐ ܐܵܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܟܠܔ ܡ̇ܢ ܕܓܲܫܸܩ ܠܒܲܟ݂ܬܵ‌ܐ ܒܫܲܗܘܲܬܬܵ‌ܐ، ܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܥܒ݂ܝܼܕ ܠܹܗ ܓܲܝܵܪܘܼܬܵ‌ܐ ܥܲܡܘܼܗ̇ ܓܵܘ ܠܸܒܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","”ܐܸܢ ܥܲܝܢܘܼܟ݂ ܕܝܲܡܝܼܢܵܐ ܗܵܘܝܵܐ ܥܸܠܬܵ‌ܐ ܕܬܘܼܪܩܵܠܵܐ ܐܸܠܘܼܟ݂، ܚܪܘܿܛ ܠܵܗ̇ ܘܪܲܦܝܼ ܠܵܗ̇ ܡܸܢܘܼܟ݂؛ ܣܵܒܵܒ ܒܘܼܫ ܨܦܵܝܝܼ ܝܠܵܗ̇ ܐܸܠܘܼܟ݂ ܕܛܵܠܹܩ ܚܲܕ ܡ̣ܢ ܗܲܕܵܡܹ̈ܐ ܕܦܲܓ݂ܪܘܼܟ݂، ܘܠܵܐ ܟܠܹܗ ܦܲܓ݂ܪܘܼܟ݂ ܦܵܐܹܫ ܕܸܪܝܵܐ ܓܵܘ ܓܹܗܲܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","”ܘܐܸܢ ܐܝܼܕܘܼܟ݂ ܕܝܲܡܝܼܢܵܐ ܗܵܘܝܵܐ ܥܸܠܬܵ‌ܐ ܕܬܘܼܪܩܵܠܵܐ ܐܸܠܘܼܟ݂، ܩܛܹܥ ܠܵܗ̇ ܘܪܲܦܝܼ ܠܵܗ̇ ܡܸܢܘܼܟ݂، ܣܵܒܵܒ ܒܘܼܫ ܨܦܵܝܝܼ ܝܠܵܗ̇ ܐܸܠܘܼܟ݂ ܕܛܵܠܹܩ ܚܲܕ ܡ̣ܢ ܗܲܕܵܡܹ̈ܐ ܕܦܲܓ݂ܪܘܼܟ݂، ܘܠܵܐ ܟܠܹܗ ܦܲܓ݂ܪܘܼܟ݂ ܦܵܐܹܫ ܕܸܪܝܵܐ ܓܵܘ ܓܹܗܲܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","”ܦܝܼܫ ܠܵܗ̇ ܐܡܝܼܪܬܵ‌ܐ: ’ܡ̇ܢ ܕܪܲܦܹܐ ܒܲܟ݂ܬܹܗ، ܝܵܗܒܹܠܔ ܠܵܗ̇ ܟܬܵܒ݂ܵܐ ܕܕܘܼܠܵܠܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","”ܐܝܼܢܵܐ ܐܵܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܟܠܔ ܡ̇ܢ ܕܪܲܦܹܐ ܒܲܟ݂ܬܹܗ، ܫܒ݂ܘܿܩ ܡ̣ܢ ܥܸܠܬܵ‌ܐ ܕܙܵܢܝܘܼܬܵ‌ܐ، ܒܸܥܒ݂ܵܕܘܼܗ̇ ܝܠܹܗ ܓܲܝܵܪܬܵ‌ܐ. ܘܡ̇ܢ ܕܓܵܒܹܪ ܪܘܼܦܝܼܬܵ‌ܐ، ܒܸܥܒ݂ܵܕܵܐ ܝܠܹܗ ܓܲܝܵܪܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","”ܡܸܢܕܪܸܫ ܫܡܝܼܥ ܠܵܘܟ݂ܘܿܢ ܕܦܝܼܫ ܠܵܗ̇ ܐܡܝܼܪܬܵ‌ܐ ܠܐܵܢܝܼ ܕܩܲܕܡ ܕܝܼܵܘܟ݂ܘܿܢ: ’ܠܵܐ ܕܲܓܠܸܬ ܒܡܵܘܡܵܬܘܼ̈ܟ݂، ܐܝܼܢܵܐ ܬܲܡܸܡܸܬ ܡܵܘܡܵܬܘܼ̈ܟ݂ ܠܡܵܪܝܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","”ܐܝܼܢܵܐ ܐܵܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܗܸܟ̃ ܠܵܐ ܝܵܡܹܝܬܘܿܢ، ܠܵܐ ܒܫܡܲܝܵܐ، ܣܵܒܵܒ ܟܘܼܪܣܝܵܐ ܕܐܲܠܵܗܵܐ ܝܠܵܗ̇، ");
INSERT INTO aii_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","”ܘܐܘܼܦ ܠܵܐ ܒܐܲܪܥܵܐ، ܣܵܒܵܒ ܝܼܠܵܗ̇ ܟܘܼܒ݂ܫܵܐ ܬܚܘܿܬ ܐܲܩܠܵܬܘܼ̈ܗ‌ܝ؛ ܘܐܘܼܦ ܠܵܐ ܒܐܘܿܪܸܫܠܸܡ، ܣܵܒܵܒ ܝܼܠܵܗ̇ ܡܕܝܼܢ݇ܬܵ‌ܐ ܕܡܲܠܟܵܐ ܓܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","”ܐܘܼܦ ܠܵܐ ܝܵܡܹܝܬ ܒܪܹܝܫܘܼܟ݂، ܣܵܒܵܒ ܠܹܐ ܡܵܨܹܝܬ ܫܲܚܠܸܦܸܬ ܓܵܘܹܗ ܚܕܵܐ ܡܸܙܬܵ‌ܐ ܟܘܼܡܬܵ‌ܐ ܝܲܢ ܚܘܵܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","”ܐܸܠܵܐ ܗܵܘܝܼ ܗܹܡܸܙܡܵܢܵܘ̈ܟ݂ܘܿܢ: ܗܹܐ، ܗܹܐ، ܘܠܵܐ، ܠܵܐ؛ ܘܡܸܢܕܝܼ ܕܙܵܐܹܕ ܥܲܠܔ ܐܲܢܹܐ، ܡ̣ܢ ܒܝܼܫܵܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","”ܫܡܝܼܥ ܠܵܘܟ݂ܘܿܢ ܕܦܝܼܫ ܠܵܗ̇ ܐܡܝܼܪܬܵ‌ܐ: ’ܥܲܝܢܵܐ ܡܒܵܕܵܠܔ ܕܥܲܝܢܵܐ، ܘܟܹܟܵܐ ܡܒܵܕܵܠܔ ܕܟܹܟܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","”ܐܝܼܢܵܐ ܐܵܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܠܵܐ ܫܵܩܠܝܼܬܘܿܢ ܬܘܼܥܠܵܐ ܕܒܝܼܫܵܐ، ܐܸܠܵܐ ܡ̇ܢ ܕܡܵܚܹܐ ܠܘܼܟ݂ ܥܲܠܔ ܦܵܬܘܼܟ݂ ܕܝܲܡܝܼܢܵܐ، ܡܲܚܕܸܪ ܐܸܠܹܗ ܐܘܼܦ ܗ̇ܝ ܐܚܹܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","”ܘܡ̇ܢ ܕܒܵܥܹܐ ܕܵܐܹܢܘܼܟ݂ ܘܫܵܩܹܠܔ ܨܘܼܕܪܘܼܟ݂، ܫܒ݂ܘܿܩ ܕܫܵܩܹܠܔ ܐܘܼܦ ܥܵܒܵܝܬܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","”ܘܡ̇ܢ ܕܠܲܒܸܠܔ ܠܘܼܟ݂ ܒܫܘܼܚܪܵܐ ܩܵܐ ܚܲܕ ܡܝܼܠܵܐ، ܙܹܠܔ݇ ܥܲܡܹܗ ܬܪܹܝ. ");
INSERT INTO aii_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","”ܡ̇ܢ ܕܛܵܠܹܒ ܡܸܢܘܼܟ݂، ܗܲܒ݂ܠܔ ܠܹܗ، ܘܡ̇ܢ ܕܒܵܥܹܐ ܡܲܕܝܸܢ ܡܸܢܘܼܟ݂، ܠܵܐ ܡܲܕܸܪܸܬ ܠܹܗ ܣܦܝܼܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","”ܫܡܝܼܥ ܠܵܘܟ݂ܘܿܢ ܕܦܝܼܫ ܠܵܗ̇ ܐܡܝܼܪܬܵ‌ܐ: ’ܡܲܚܸܒ ܠܫܒ݂ܵܒ݂ܘܼܟ݂، ܘܣܢܝܼ ܠܕܸܫ̃ܡܸܢܘܼܟ݂.‘ ");
INSERT INTO aii_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","”ܐܝܼܢܵܐ ܐܵܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ: ܡܲܚܸܒܘܼܢ ܠܕܸܫ̃ܡܸܢܵܘܟ݂ܘܿܢ ܘܒܲܪܟ݂ܘܼܢ ܠܡ̇ܢ ܕܟܲܡܸܪܵܘܟ݂ܘܿܢ، ܘܥܒ݂ܘܿܕܘܼܢ ܛܵܒ݂ܬܵ‌ܐ ܠܡ̇ܢ ܕܣܵܢܹܐ ܠܵܘܟ݂ܘܿܢ، ܘܨܲܠܹܝܡܘܼܢ ܨܠܘܿܬܵ‌ܐ ܥܲܠܔ ܐܵܢܝܼ ܕܡܲܠܝܸܨܝܼ ܠܵܘܟ݂ܘܿܢ ܘܛܵܪܕܝܼ ܠܵܘܟ݂ܘܿܢ، ");
INSERT INTO aii_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","”ܕܗܵܘܹܝܬܘܿܢ ܒܢܘܿܢܹ̈ܐ ܕܒܵܒܵܘܟ݂ܘܿܢ ܕܒܫܡܲܝܵܐ، ܗ̇ܘ ܕܡܲܙܪܸܩ ܫܸܡܫܹܗ ܥܲܠܔ ܛܵܒܹ̈ܐ ܘܥܲܠܔ ܒܝܼܫܹ̈ܐ، ܘܡܲܨܠܹܐ ܡܸܛܪܹܗ ܥܲܠܔ ܟܹܐܢܹ̈ܐ ܘܥܲܠܔ ܥܵܘܵܠܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","”ܐܸܢ ܡܲܚܸܒܝܼܬܘܿܢ ܠܐܵܢܝܼ ܕܡܲܚܸܒܝܼ ܠܵܘܟ݂ܘܿܢ، ܡܘܼܕܝܼ ܦܘܼܪܥܵܢܵܐ ܐܝܼܬ ܠܵܘܟ݂ܘܿܢ؟ ܩܵܡܘܿܕܝܼ ܐܘܼܦ ܡܵܟ݂ܣܹ̈ܐ ܠܹܐ ܥܵܒ݂ܕܝܼ ܗܵܕܟ݂ܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","”ܘܐܸܢ ܕܵܪܹܝܬܘܿܢ ܫܠܵܡܵܐ ܠܐܲܚܘܿܢܘܵܬܵܘ̈ܟ݂ܘܿܢ ܐܲܚܟ̰ܝܼ، ܡܘܼܕܝܼ ܝܬܘܿܢ ܒܸܥܒ݂ܵܕܵܐ ܙܵܘܕܵܐ؟ ܩܵܡܘܿܕܝܼ ܐܘܼܦ ܡܵܟ݂ܣܹ̈ܐ ܠܹܐ ܥܵܒ݂ܕܝܼ ܗܵܕܟ݂ܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","”ܒܘܼܬ ܐܵܗܵܐ، ܗܘܹܝܡܘܼܢ ܓܡܝܼܪܹ̈ܐ، ܐܲܝܟ݂ ܕܝܼܠܹܗ ܒܵܒܵܘܟ݂ܘܿܢ ܕܒܫܡܲܝܵܐ ܓܡܝܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","”ܗܘܹܝܡܘܼܢ ܗܸܫܝܲܪ، ܠܵܐ ܗܵܘܝܵܐ ܕܥܵܒ݂ܕܝܼܬܘܿܢ ܐܸܪܘܵܢܵܘܟ݂ܘܿܢ ܩܲܕܡ ܒܢܲܝ̈ܢܵܫܵܐ، ܕܦܵܝܫܝܼܬܘܿܢ ܚܸܙܝܹܐ ܒܝܼܵܝܗ‌ܝ، ܐܸܢ ܥܵܒ݂ܕܝܼܬܘܿܢ ܗܵܕܟ݂ܵܐ، ܠܲܝܬ ܠܵܘܟ݂ܘܿܢ ܦܘܼܪܥܵܢܵܐ ܡ̣ܢ ܒܵܒܵܘܟ݂ܘܿܢ ܕܒܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","”ܒܘܼܬ ܐܵܗܵܐ، ܐܝܼܡܲܢ ܕܥܵܒ݂ܕܹܬ ܐܸܪܘܵܢܵܐ، ܠܵܐ ܡܲܕܥܸܬ ܠܹܗ ܐܸܪܘܵܢܘܼܟ݂ ܒܡܚܵܝܬܵ‌ܐ ܕܩܲܪܢܵܐ ܩܲܕܡܵܐ ܩܲܕܡܘܼܟ݂، ܐܲܝܟ݂ ܕܟܹܐ ܥܵܒ݂ܕܝܼ ܡܲܫܦܸܪ̈ܵܢܹܐ ܒܟܢܘܼܫܝܵܬܹ̈‌ܐ ܘܒܥܵܠܘܿܠܹ̈ܐ، ܕܦܵܝܫܝܼ ܚܩܝܼܪܹܐ ܒܝܲܕ ܒܢܲܝ̈ܢܵܫܵܐ. ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܐܵܢܝܼ ܩܘܼܒܸܠܔ ܠܗܘܿܢ ܦܘܼܪܥܵܢܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","”ܐܝܼܢܵܐ ܐܲܢ݇ܬ، ܐܝܼܡܲܢ ܕܥܵܒ݂ܕܹܬ ܐܸܪܘܵܢܵܐ، ܠܵܐ ܫܵܒ݂ܩܹܬ ܣܸܡܵܠܘܼܟ݂ ܝܵܕܥܵܐ ܡܘܼܕܝܼ ܒܸܥܒ݂ܵܕܵܐ ܝܠܵܗ̇ ܝܲܡܝܼܢܘܼܟ݂، ");
INSERT INTO aii_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","”ܕܗܵܘܹܐ ܐܸܪܘܵܢܘܼܟ݂ ܒܛܸܫܘܵܐ، ܘܒܵܒܘܼܟ݂ ܕܟܹܐ ܚܵܙܹܐ ܒܛܸܫܘܵܐ، ܗ̇ܘ ܒܸܬ ܦܵܪܹܥ ܠܘܼܟ݂ ܓܲܠܝܵܐܝܼܬ. ");
INSERT INTO aii_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","”ܘܐܝܼܡܲܢ ܕܨܲܠܹܝܬ ܨܠܘܿܬܵ‌ܐ، ܠܵܐ ܗܵܘܹܝܬ ܐܲܝܟ݂ ܡܲܫܦܸܪ̈ܵܢܹܐ، ܐܵܢܝܼ ܕܟܹܐ ܡܲܚܸܒܝܼ ܟܵܠܝܼ ܠܨܲܠܘܼܝܹܐ ܒܟܢܘܼܫܝܵܬܹ̈‌ܐ ܘܒܩܘܼܪ̈ܢܝܼܵܬܹ‌ܐ ܕܥܵܠܘܿܠܹ̈ܐ، ܕܦܵܝܫܝܼ ܚܸܙܝܹܐ ܒܐܢܵܫܹ̈ܐ. ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܐܵܢܝܼ ܩܘܼܒܸܠܔ ܠܗܘܿܢ ܦܘܼܪܥܵܢܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","”ܐܝܼܢܵܐ ܐܲܢ݇ܬ ܐܝܼܡܲܢ ܕܨܲܠܹܝܬ ܨܠܘܿܬܵ‌ܐ، ܥܒ݂ܘܿܪ ܠܟܘܼܚܬܘܼܟ݂، ܘܐܟ̰ܘܿܡ ܬܲܪܥܘܼܟ݂، ܘܨܲܠܝܼ ܩܵܐ ܒܵܒܘܼܟ݂ ܕܝܼܠܹܗ ܒܛܸܫܘܵܐ، ܘܒܵܒܘܼܟ݂ ܕܟܹܐ ܚܵܙܹܐ ܒܛܸܫܘܵܐ، ܗ̇ܘ ܒܸܬ ܦܵܪܹܥ ܠܘܼܟ݂ ܓܲܠܝܵܐܝܼܬ. ");
INSERT INTO aii_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","”ܐܝܼܡܲܢ ܕܨܲܠܹܝܬܘܿܢ ܨܠܘܿܬܵ‌ܐ، ܠܵܐ ܗܵܘܹܝܬܘܿܢ ܒܸܬܢܵܝܵܐ ܗܹܡܸܙܡܵܢ ܐܲܝܟ݂ ܚܲܢܦܹ̈ܐ، ܐܲܝܢܝܼ ܕܟܹܐ ܚܵܫܒ݂ܝܼ ܕܒܗܲܡܙܲܡܬܵ‌ܐ ܪܵܒܵܐ ܒܸܬ ܦܵܝܫܝܼ ܫܡܝܼܥܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","”ܒܘܼܬ ܐܵܗܵܐ ܠܵܐ ܕܵܡܹܝܬܘܿܢ ܐܸܠܵܝܗ‌ܝ، ܣܵܒܵܒ ܒܵܒܵܘܟ݂ܘܿܢ ܟܹܐ ܝܵܕܹܥ ܠܡܘܼܕܝܼ ܝܬܘܿܢ ܣܢܝܼܩܹܐ، ܡ̣ܢ ܩܲܕܡ ܕܛܵܠܒܝܼܬܘܿܢ ܡܸܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","”ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ ܗܵܕܟ݂ܵܐ ܨܲܠܹܝܡܘܼܢ ܨܠܘܿܬܵ‌ܐ: ܒܵܒܲܢ ܕܒܫܡܲܝܵܐ، ܦܵܐܹܫ ܡܩܘܼܕܫܵܐ ܫܸܡܘܼܟ݂، ");
INSERT INTO aii_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ܐܵܬܝܵܐ ܡܲܠܟܘܼܬܘܼܟ݂، ܗܵܘܹܐ ܨܸܒ݂ܝܵܢܘܼܟ݂، ܕܵܐܟ݂ܝܼ ܕܒܫܡܲܝܵܐ ܐܘܼܦ ܒܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ܗܲܒ݂ܠܔ ܠܲܢ ܠܲܚܡܵܐ ܕܣܘܼܢܩܵܢܲܢ ܐܸܕܝܘܿܡ ܝܵܘܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ܘܫܒ݂ܘܿܩ ܐܸܠܲܢ ܕܵܝܢܲܢ̈، ܕܵܐܟ݂ܝܼ ܕܐܘܼܦ ܐܲܚܢܲܢ ܫܒ݂ܝܼܩ ܠܲܢ ܠܐܵܢܝܼ ܕܕܵܝܢܵܢܹ̈ܐ ܝܢܵܐ ܐܸܠܲܢ. ");
INSERT INTO aii_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ܠܵܐ ܡܲܥܒܸܪܸܬ ܠܲܢ ܠܢܸܣܝܘܿܢܵܐ، ܐܸܠܵܐ ܦܲܨܝܼ ܠܲܢ ܡ̣ܢ ܒܝܼܫܵܐ، ܣܵܒܵܒ ܕܝܼܘܼܟ݂ ܝܼܠܵܗ̇ ܡܲܠܟܘܼܬܵ‌ܐ، ܘܚܲܝܠܵܐ، ܘܬܸܫܒܘܿܚܬܵ‌ܐ ܠܥܵܠܲܡ ܥܵܠܡܝܼܢ. ܐܵܡܹܝܢ. ");
INSERT INTO aii_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","”ܣܵܒܵܒ ܐܸܢ ܦܲܚܠܝܼܬܘܿܢ ܠܒܢܲܝ̈ܢܵܫܵܐ ܓܢܵܗܵܝ̈ܗ‌ܝ، ܐܘܼܦ ܒܵܒܵܘܟ݂ܘܿܢ ܕܒܫܡܲܝܵܐ ܒܸܬ ܦܲܚܸܠܔ ܠܓܢܵܗܵܘ̈ܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","”ܐܝܼܢܵܐ ܐܸܢ ܠܵܐ ܦܲܚܠܝܼܬܘܿܢ ܠܒܢܲܝ̈ܢܵܫܵܐ ܓܢܵܗܵܝ̈ܗ‌ܝ، ܐܘܼܦ ܒܵܒܵܘܟ݂ܘܿܢ ܕܒܫܡܲܝܵܐ ܠܹܐ ܦܲܚܸܠܔ ܠܓܢܵܗܵܘ̈ܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","”ܘܐܝܼܡܲܢ ܕܨܵܝܡܝܼܬܘܿܢ، ܠܵܐ ܗܵܘܹܝܬܘܿܢ ܚܲܫܵܢܹ̈ܐ ܐܲܝܟ݂ ܡܲܫܦܸܪ̈ܵܢܹܐ، ܐܵܢܝܼ ܕܟܹܐ ܡܲܣܪܝܼ ܦܲܪܨܘܿܦܵܝܗ‌ܝ، ܕܡܲܒܝܸܢܝܼ ܠܐܢܵܫܹ̈ܐ ܕܨܝܼܡܹܐ ܝܢܵܐ. ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ ܕܐܵܢܝܼ ܩܘܼܒܸܠܔ ܠܗܘܿܢ ܦܘܼܪܥܵܢܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","”ܐܝܼܢܵܐ ܐܲܢ݇ܬ ܐܝܼܡܲܢ ܕܨܵܝܡܹܬ، ܚܲܠܸܠܔ ܦܵܬܘܼܟ݂ ܘܡܫܘܿܚ ܪܹܝܫܘܼܟ݂، ");
INSERT INTO aii_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","”ܕܠܵܐ ܡܲܒܝܸܢܸܬ ܠܐܢܵܫܹ̈ܐ ܕܨܝܼܡܵܐ ܝܘܸܬ، ܐܸܠܵܐ ܠܒܵܒܘܼܟ݂ ܕܝܼܠܹܗ ܒܛܸܫܘܵܐ، ܘܒܵܒܘܼܟ݂ ܕܟܹܐ ܚܵܙܹܐ ܒܛܸܫܘܵܐ، ܗ̇ܘ ܒܸܬ ܦܵܪܹܥ ܠܘܼܟ݂ ܓܲܠܝܵܐܝܼܬ. ");
INSERT INTO aii_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","”ܠܵܐ ܡܲܬܒ݂ܝܼܬܘܿܢ ܠܵܘܟ݂ܘܿܢ ܣܝܼܡܵܬܹ̈‌ܐ ܒܐܲܪܥܵܐ، ܐܲܝܟܵܐ ܕܡܪܲܝܬܵ‌ܐ ܘܐܸܟ݂ܠܵܐ ܟܹܐ ܡܲܚܪܸܒ݂ܝܼ، ܘܐܲܝܟܵܐ ܕܓܹܢܵܒܹ̈ܐ ܟܹܐ ܒܵܙܥܝܼ ܘܓܵܢܒ݂ܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","”ܐܸܠܵܐ ܡܲܬܒ݂ܘܼܢ ܠܵܘܟ݂ܘܿܢ ܣܝܼܡܵܬܹ̈‌ܐ ܒܫܡܲܝܵܐ، ܐܲܝܟܵܐ ܕܠܵܐ ܡܪܲܝܬܵ‌ܐ ܘܠܵܐ ܐܸܟ݂ܠܵܐ ܟܹܐ ܡܲܚܪܸܒ݂ܝܼ، ܘܐܲܝܟܵܐ ܕܓܹܢܵܒܹ̈ܐ ܠܹܐ ܒܵܙܥܝܼ ܘܠܹܐ ܓܵܢܒ݂ܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ܣܵܒܵܒ ܐܲܝܟܵܐ ܕܝܼܢܵܐ ܣܝܼܡܵܬܵܘ̈ܟ݂ܘܿܢ، ܬܵܡܵܐ ܒܸܬ ܗܵܘܹܐ ܐܘܼܦ ܠܸܒܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","”ܒܲܗܪܵܐ ܕܦܲܓ݂ܪܵܐ ܥܲܝܢܵܐ ܝܠܵܗ̇. ܗܵܕܟ݂ܵܐ، ܐܸܢ ܥܲܝܢܘܼܟ݂ ܗܵܘܝܵܐ ܕܟ݂ܝܼܬܵ‌ܐ، ܟܠܹܗ ܦܲܓ݂ܪܘܼܟ݂ ܒܲܗܪܵܢܵܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","”ܐܝܼܢܵܐ ܐܸܢ ܥܲܝܢܘܼܟ݂ ܒܝܼܫܬܵ‌ܐ ܝܠܵܗ̇، ܟܠܹܗ ܦܲܓ݂ܪܘܼܟ݂ ܒܸܬ ܗܵܘܹܐ ܚܸܫܟܵܢܵܐ. ܘܗܵܕܟ݂ܵܐ، ܐܸܢ ܒܲܗܪܵܐ ܕܝܼܠܹܗ ܓܵܘܘܼܟ݂ ܚܸܫܟܵܢܵܐ ܝܠܹܗ، ܚܸܫܟܘܼܟ݂ ܟܡܵܐ ܒܸܬ ܗܵܘܹܐ! ");
INSERT INTO aii_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","”ܠܹܐ ܡܵܨܹܐ ܚܲܕ ܐܢܵܫܵܐ ܦܵܠܹܚ ܠܬܪܹܝ ܡܵܪ̈ܵܘܵܬܹ‌ܐ، ܣܵܒܵܒ ܝܲܢ ܠܚܲܕ ܒܸܬ ܣܵܢܹܐ ܘܠܗ̇ܘ ܐܚܹܪܢܵܐ ܒܸܬ ܡܲܚܸܒ؛ ܝܲܢ ܒܸܬ ܡܝܲܩܸܪ ܠܚܲܕ ܘܠܗ̇ܘ ܐܚܹܪܢܵܐ ܒܸܬ ܡܲܣܠܹܐ. ܠܹܐ ܡܵܨܹܝܬܘܿܢ ܦܵܠܚܝܼܬܘܿܢ ܠܐܲܠܵܗܵܐ ܘܠܙܘܼܙܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","”ܒܘܼܬ ܐܵܗܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܠܵܐ ܐܵܟ݂ܠܝܼܬܘܿܢ ܚܲܡ ܒܘܼܬ ܚܲܝܘܼܬܵܘܟ݂ܘܿܢ ܕܡܘܼܕܝܼ ܒܸܬ ܐܵܟ݂ܠܝܼܬܘܿܢ ܘܡܘܼܕܝܼ ܒܸܬ ܫܵܬܹܝܬܘܿܢ، ܘܠܵܐ ܒܘܼܬ ܦܲܓ݂ܪܵܘܟ݂ܘܿܢ ܕܡܘܼܕܝܼ ܒܸܬ ܠܵܒ݂ܫܝܼܬܘܿܢ. ܠܹܐ ܝܠܵܗ̇ ܓܵܢܵܐ ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ، ܘܦܲܓ݂ܪܵܐ ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܠܒ݂ܝܼܫܬܵ‌ܐ؟ ");
INSERT INTO aii_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","”ܓܲܫܩܘܼܢ ܒܛܲܝܪܹ̈ܐ ܕܫܡܲܝܵܐ: ܠܹܐ ܙܵܪܥܝܼ ܘܠܹܐ ܚܵܨܕܝܼ، ܘܠܹܐ ܓ̰ܲܡܥܝܼ ܓܵܘ ܐܲܢܒܵܪܹ̈ܐ، ܐܝܼܢܵܐ ܒܵܒܵܘܟ݂ܘܿܢ ܕܒܫܡܲܝܵܐ ܟܹܐ ܬܲܪܣܹܐ ܠܗܘܿܢ. ܠܹܐ ܝܬܘܿܢ ܐܲܚܬܘܿܢ ܒܘܼܫ ܙܵܘܕܵܐ ܡܸܢܵܝܗ‌ܝ؟ ");
INSERT INTO aii_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","”ܐܲܝܢܝܼ ܡܸܢܵܘܟ݂ܘܿܢ، ܟܡܵܐ ܕܐܵܟܹܠܔ ܚܲܡ ܒܩܸܫܝܘܼܬܵ‌ܐ ܡܵܨܹܐ ܡܲܙܝܸܕ ܥܲܠܔ ܩܵܘܡܬܹܗ ܚܕܵܐ ܝܲܡܝܼܢܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","”ܘܩܵܡܘܿܕܝܼ ܗܵܕܟ݂ܵܐ ܒܹܐܟ݂ܵܠܵܐ ܝܬܘܿܢ ܚܲܡ ܒܘܼܬ ܠܒ݂ܝܼܫܬܵ‌ܐ؟ ܓܲܫܩܘܼܢ ܒܫܘܿܫܲܢܹ̈ܐ ܕܕܸܫܬܵ‌ܐ، ܕܵܐܟ݂ܝܼ ܟܹܐ ܓܲܪܘܸܣܝܼ؛ ܠܹܐ ܦܵܠܚܝܼ ܘܠܹܐ ܥܵܙܠܝܼ، ");
INSERT INTO aii_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","”ܐܝܼܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܐܘܼܦ ܫܠܹܝܡܘܿܢ ܒܟܠܹܗ ܚܸܩܪܹܗ ܠܹܐ ܝܗܘܵܐ ܠܒ݂ܝܼܫܵܐ ܐܲܝܟ݂ ܚܲܕ ܡܸܢܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","”ܐܸܢ ܐܲܠܵܗܵܐ ܗܵܕܟ݂ܵܐ ܟܹܐ ܡܲܠܒܸܫ ܠܓܸܠܵܐ ܕܚܲܩܠܵܐ ܕܝܼܠܹܗ ܩܵܐ ܚܲܕ ܝܵܘܡܵܐ، ܘܩܲܝܕܵܡܬܵ‌ܐ ܟܹܐ ܦܵܐܹܫ ܕܸܪܝܵܐ ܒܬܲܢܘܼܪܵܐ، ܠܹܐ ܒܘܼܫ ܙܵܘܕܵܐ ܡܲܠܒܸܫ ܐܸܠܵܘܟ݂ܘܿܢ ܝܵܐ ܒܵܨܘܿܪܹ̈ܐ ܕܗܲܝܡܵܢܘܼܬܵ‌ܐ؟ ");
INSERT INTO aii_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","”ܒܘܼܬ ܐܵܗܵܐ، ܠܵܐ ܐܵܟ݂ܠܝܼܬܘܿܢ ܚܲܡ ܘܐܵܡܪܝܼܬܘܿܢ: ’ܡܘܼܕܝܼ ܐܵܟ݂ܠܲܚ؟‘ ܝܲܢ: ’ܡܘܼܕܝܼ ܫܵܬܲܚ؟‘ ܝܲܢ: ’ܡܘܼܕܝܼ ܠܵܒ݂ܫܲܚ؟‘ ");
INSERT INTO aii_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","”ܣܵܒܵܒ ܟܠܵܝܗ‌ܝ ܐܲܢܹܐ ܐܸܡܘܵܬܹ̈‌ܐ ܟܹܐ ܛܵܠܒܝܼ ܠܗܘܿܢ؛ ܐܝܼܢܵܐ ܒܵܒܵܘܟ݂ܘܿܢ ܕܒܫܡܲܝܵܐ ܟܹܐ ܝܵܕܹܥ ܕܐܘܼܦ ܐܲܚܬܘܿܢ ܣܢܝܼܩܹܐ ܝܬܘܿܢ ܠܟܠܵܝܗ‌ܝ ܐܲܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","”ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ ܛܠܘܿܒܘܼܢ ܩܲܕܡܵܝܬܵ‌ܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ ܘܙܲܕܝܼܩܘܼܬܹܗ، ܘܟܠܵܝܗ‌ܝ ܐܲܢܹܐ ܒܸܬ ܦܵܝܫܝܼ ܡܘܼܙܝܸܕܹܐ ܐܸܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","”ܒܘܼܬ ܐܵܗܵܐ ܠܵܐ ܐܵܟ݂ܠܝܼܬܘܿܢ ܚܲܡ ܒܘܼܬ ܩܲܝܕܵܡܬܵ‌ܐ، ܣܵܒܵܒ ܩܲܝܕܵܡܬܵ‌ܐ ܒܸܬ ܬܲܚܡܸܢܵܐ ܒܘܼܬ ܓܵܢܘܼܗ̇. ܡܵܠܝܵܢܬܵ‌ܐ ܝܠܵܗ̇ ܒܝܼܫܬܵ‌ܐ ܕܝܵܘܡܵܐ ܩܵܐ ܓܵܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","”ܠܵܐ ܕܵܝܢܝܼܬܘܿܢ، ܕܠܵܐ ܦܵܝܫܝܼܬܘܿܢ ܕܝܼܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","”ܣܵܒܵܒ ܒܕܝܵܢܬܵ‌ܐ ܕܒܝܼܘܼܗ̇ ܕܵܝܢܝܼܬܘܿܢ، ܒܸܬ ܦܵܝܫܝܼܬܘܿܢ ܕܝܼܢܹܐ، ܘܒܟܝܘܼܠܵܐ ܕܒܝܼܹܗ ܟܵܝܠܝܼܬܘܿܢ، ܒܸܬ ܦܵܐܹܫ ܟܝܼܠܵܐ ܐܸܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","”ܩܵܡܘܿܕܝܼ ܒܸܚܙܵܝܵܐ ܝܘܸܬ ܙܸܠܸܟܵܐ ܕܓܵܘ ܥܲܝܢܵܐ ܕܐܲܚܘܿܢܘܼܟ݂، ܐܝܼܢܵܐ ܩܵܪܝܼܬܵ‌ܐ ܕܓܵܘ ܥܲܝܢܘܼܟ݂ ܠܹܐ ܝܘܸܬ ܒܸܚܙܵܝܘܼܗ̇؟ ");
INSERT INTO aii_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","”ܝܲܢ ܕܵܐܟ݂ܝܼ ܒܹܐܡܵܪܵܐ ܝܘܸܬ ܠܐܲܚܘܿܢܘܼܟ݂: ’ܫܒ݂ܘܿܩ ܕܦܲܠܛܸܢܹܗ ܙܸܠܸܟܵܐ ܡ̣ܢ ܓܵܘ ܥܲܝܢܘܼܟ݂،‘ ܟܲܕ ܐܝܼܬ ܩܵܪܝܼܬܵ‌ܐ ܓܵܘ ܥܲܝܢܵܐ ܕܓܵܢܘܼܟ݂؟ ");
INSERT INTO aii_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","”ܐܲܢ݇ܬ ܝܵܐ ܡܲܫܦܸܪܵܢܵܐ، ܩܲܕܡܵܝܬܵ‌ܐ ܦܲܠܸܛ ܩܵܪܝܼܬܵ‌ܐ ܡ̣ܢ ܓܵܘ ܥܲܝܢܵܐ ܕܓܵܢܘܼܟ݂، ܘܗ̇ܝܓܵܗ ܒܸܬ ܚܵܙܹܝܬ ܒܨܸܦܝܘܼܬܵ‌ܐ ܠܦܲܠܘܼܛܹܐ ܙܸܠܸܟܵܐ ܡ̣ܢ ܓܵܘ ܥܲܝܢܵܐ ܕܐܲܚܘܿܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","”ܠܵܐ ܝܵܗܒ݂ܝܼܬܘܿܢ ܡܸܢܕܝܼ ܡܩܘܼܕܫܵܐ ܠܟܲܠܒܹ̈ܐ، ܘܠܵܐ ܕܵܪܹܝܬܘܿܢ ܡܲܪ̈ܓܵܢܝܵܬܵܘܟ݂ܘܿܢ ܩܲܕܡ ܚܙܘܼܪܹ̈ܐ، ܕܠܵܐ ܕܲܫܕܸܫܝܼ ܠܗܘܿܢ ܒܐܲܩܠܵܬܵܝ̈ܗ‌ܝ، ܘܒܚܲܪܬܵ‌ܐ ܕܵܝܪܝܼ ܘܟ̰ܲܢܟ̰ܸܪܝܼ ܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","”ܛܠܘܿܒܘܼܢ، ܘܒܸܬ ܦܵܐܹܫ ܝܘܼܗܒ݂ܵܐ ܐܸܠܵܘܟ݂ܘܿܢ؛ ܛܥܹܝܡܘܼܢ، ܘܒܸܬ ܡܲܫ݇ܟ̰ܚܝܼܬܘܿܢ؛ ܬܲܩܬܸܩܘܼܢ، ܘܒܸܬ ܦܵܐܹܫ ܦܬܝܼܚܵܐ ܐܸܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","”ܣܵܒܵܒ ܟܠܔ ܡ̇ܢ ܕܛܵܠܹܒ، ܒܸܬ ܩܲܒܸܠܔ؛ ܘܗ̇ܘ ܕܛܵܥܹܐ ܒܸܬ ܡܲܫ݇ܟ̰ܸܚ؛ ܘܠܗ̇ܘ ܕܬܲܩܬܸܩ، ܒܸܬ ܦܵܐܹܫ ܦܬܝܼܚܵܐ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","”ܝܲܢ ܐܲܝܢܝܼ ܝܠܹܗ ܡܸܢܵܘܟ݂ܘܿܢ ܕܐܸܢ ܒܪܘܿܢܹܗ ܛܵܠܹܒ ܡܸܢܹܗ ܠܲܚܡܵܐ، ܒܸܬ ܦܲܫܸܛ ܐܸܠܹܗ ܟܹܐܦܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","”ܘܐܸܢ ܛܵܠܹܒ ܡܸܢܹܗ ܢܘܼܢܵܐ، ܒܸܬ ܦܲܫܸܛ ܐܸܠܹܗ ܚܘܼܘܹܐ؟ ");
INSERT INTO aii_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","”ܐܸܢ ܗܵܕܟ݂ܵܐ ܐܲܚܬܘܿܢ ܕܝܼܬܘܿܢ ܒܝܼܫܹ̈ܐ ܟܹܐ ܝܵܕܥܝܼܬܘܿܢ ܠܝܼܵܗܒ݂ܵܐ ܡܵܘܗܒ݂ܵܬܹ̈‌ܐ ܛܵܒܹ̈ܐ ܠܒܢܘܿܢܵܘ̈ܟ݂ܘܿܢ، ܟܡܵܐ ܒܘܼܫ ܙܵܘܕܵܐ ܒܵܒܵܘܟ݂ܘܿܢ ܕܒܫܡܲܝܵܐ ܒܸܬ ܝܵܗܒܹܠܔ ܛܵܒ݂ܵܬܹ̈‌ܐ ܠܐܵܢܝܼ ܕܛܵܠܒܝܼ ܡܸܢܹܗ! ");
INSERT INTO aii_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","”ܟܠܔ ܡܸܢܕܝܼ ܕܒܵܣܡܵܐ ܠܵܘܟ݂ܘܿܢ ܕܥܵܒ݂ܕܝܼ ܐܸܠܵܘܟ݂ܘܿܢ ܒܢܲܝ̈ܢܵܫܵܐ، ܗܵܕܟ݂ܵܐ ܐܘܼܦ ܐܲܚܬܘܿܢ ܥܒ݂ܘܿܕܘܼܢ ܐܸܠܵܝܗ‌ܝ؛ ܣܵܒܵܒ ܗܵܕܟ݂ܵܐ ܒܹܐܡܵܪܵܐ ܝܢܵܐ ܢܵܡܘܿܣܵܐ ܘܢܒ݂ܝܼܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","”ܥܒ݂ܘܿܪܘܼܢ ܒܬܲܪܥܵܐ ܥܝܼܩܵܐ، ܣܵܒܵܒ ܦܸܬܝܵܐ ܝܠܹܗ ܬܲܪܥܵܐ ܘܪܘܝܼܚܬܵ‌ܐ ܝܠܵܗ̇ ܐܘܼܪܚܵܐ ܕܟܹܐ ܠܲܒܠܵܐ ܠܛܠܵܩܵܐ، ܘܪܵܒܵܐ ܝܢܵܐ ܐܵܢܝܼ ܕܟܹܐ ܐܵܙܠ݇ܝܼ ܒܝܼܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","”ܟܡܵܐ ܙܥܘܿܪܵܐ ܝܠܹܗ ܬܲܪܥܵܐ، ܘܟܡܵܐ ܥܝܼܩܬܵ‌ܐ ܝܠܵܗ̇ ܐܘܼܪܚܵܐ ܕܟܹܐ ܠܲܒܠܵܐ ܠܚܲܝܹ̈ܐ؛ ܘܒܵܨܘܿܪܹ̈ܐ ܝܢܵܐ ܐܵܢܝܼ ܕܟܹܐ ܡܲܫ݇ܟ̰ܚܝܼ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","”ܗܵܘܹܝܬܘܿܢ ܗܸܫܝܲܪ ܡ̣ܢ ܢܒ݂ܝܼܹ̈ܐ ܕܲܓܵܠܹ̈ܐ ܕܐܵܬ‌ܝܼ ܠܟܸܣܠܵܘܟ݂ܘܿܢ ܒܠܒ݂ܝܼܫܝܵܬܹ̈‌ܐ ܕܦܹܐܪܹ̈ܐ، ܐܝܼܢܵܐ ܓܵܘܵܐܝܼܬ ܕܹܐܒܹ̈ܐ ܟ̰ܵܠܘܿܓ̰ܹ̈ܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","”ܡ̣ܢ ܛܥܘܼܢܝܵܬܵܝ̈ܗ‌ܝ ܒܸܬ ܝܵܕܥܝܼܬܘܿܢ ܠܗܘܿܢ. ܩܵܡܘܿܕܝܼ ܟܹܐ ܩܵܛܦܝܼ ܡ̣ܢ ܟܸܬܘܹ̈ܐ ܥܲܢܒܹ̈ܐ، ܝܲܢ ܡ̣ܢ ܩܝܼܘܵܪܹ̈ܐ ܬܹܐܢܹ̈ܐ؟ ");
INSERT INTO aii_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","”ܗܵܕܟ݂ܵܐ، ܟܠܔ ܐܝܼܠܵܢܵܐ ܛܵܒ݂ܵܐ، ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܛܵܒܹ̈ܐ ܟܹܐ ܛܵܥܹܢ؛ ܐܝܼܢܵܐ ܐܝܼܠܵܢܵܐ ܒܝܼܫܵܐ، ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܒܝܼܫܹ̈ܐ ܟܹܐ ܛܵܥܹܢ. ");
INSERT INTO aii_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","”ܐܝܼܠܵܢܵܐ ܛܵܒ݂ܵܐ ܠܹܐ ܡܵܨܹܐ ܛܵܥܹܢ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܒܝܼܫܹ̈ܐ، ܘܠܵܐ ܐܝܼܠܵܢܵܐ ܒܝܼܫܵܐ ܡܵܨܹܐ ܛܵܥܹܢ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܛܵܒܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","”ܟܠܔ ܐܝܼܠܵܢܵܐ ܕܠܵܐ ܛܵܥܹܢ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܛܵܒܹ̈ܐ، ܟܹܐ ܦܵܐܹܫ ܦܪܝܼܡܵܐ ܘܕܸܪܝܵܐ ܒܢܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","”ܒܘܼܬ ܐܵܗܵܐ، ܡ̣ܢ ܛܥܘܼܢܝܵܬܵܝ̈ܗ‌ܝ ܒܸܬ ܝܵܕܥܝܼܬܘܿܢ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","”ܠܹܐ ܝܠܵܗ̇ ܟܠܔ ܡ̇ܢ ܕܐܵܡܹܪ ܐܸܠܝܼ: ’ܡܵܪܝܼ، ܡܵܪܝܼ،‘ ܒܸܬ ܥܵܒܹܪ ܠܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ؛ ܐܸܠܵܐ ܡ̇ܢ ܕܥܵܒܹܕ ܨܸܒ݂ܝܵܢܵܐ ܕܒܵܒܝܼ ܕܝܼܠܹܗ ܒܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","”ܪܵܒܵܐ ܒܸܬ ܐܵܡܪܝܼ ܐܸܠܝܼ ܒܗ̇ܘ ܝܵܘܡܵܐ: ’ܡܵܪܝܼ، ܡܵܪܝܼ، ܠܹܐ ܝܗܘܵܐ ܒܫܸܡܘܼܟ݂ ܢܘܼܒܹܐ ܠܲܢ؟ ܘܒܫܸܡܘܼܟ݂ ܫܹܐܕܹ̈ܐ ܦܘܼܠܸܛ ܠܲܢ؟ ܘܒܫܸܡܘܼܟ݂ ܪܵܒܵܐ ܚܲܝ̈ܠܹܐ ܓܘܼܪܹ̈ܐ ܥܒ݂ܝܼܕ ܠܲܢ؟‘ ");
INSERT INTO aii_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","”ܗ̇ܝܓܵܗ ܒܸܬ ܐܵܡܪܹܢ ܐܸܠܵܝܗ‌ܝ: ’ܐܵܢܵܐ ܗܸܟ̃ ܠܹܐ ܝܵܕܥܹܢܵܘܟ݂ܘܿܢ؛ ܪܚܘܿܩܘܼܢ ܐܲܚܬܘܿܢ ܡܸܢܝܼ، ܝܵܐ ܦܲܠܵܚܹ̈ܐ ܕܥܵܘܠܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","”ܒܘܼܬ ܐܵܗܵܐ، ܟܠܔ ܡ̇ܢ ܕܫܵܡܹܥ ܐܲܢܹܐ ܗܹܡܸܙܡܵܢܝܼ̈، ܘܢܵܛܹܪܗܘܿܢ، ܒܸܬ ܦܵܐܹܫ ܡܘܼܕܡܝܼܵܐ ܠܚܲܕ ܐܢܵܫܵܐ ܚܲܟܝܼܡܵܐ، ܗ̇ܘ ܕܒܢܹܐ ܠܹܗ ܒܲܝܬܹܗ ܥܲܠܔ ܩܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","”ܘܨܠܹܐ ܠܵܗ̇ ܡܸܛܪܵܐ، ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܢܲܗܪ̈ܵܘܵܬܹ‌ܐ، ܘܩܝܼܡ ܠܗܘܿܢ ܦܵܘܚܹ̈ܐ، ܘܩܝܼܬ ܠܗܘܿܢ ܒܗ̇ܘ ܒܲܝܬܵ‌ܐ، ܐܝܼܢܵܐ ܠܵܐ ܢܦܝܼܠܔ ܠܹܗ، ܣܵܒܵܒ ܫܲܬܐܸܣܬܹܗ ܥܲܠܔ ܩܵܝܵܐ ܡܘܼܬܸܒ݂ܬܵ‌ܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","”ܘܟܠܔ ܡ̇ܢ ܕܫܵܡܹܥ ܐܲܢܹܐ ܗܹܡܸܙܡܵܢܝܼ̈، ܘܠܵܐ ܢܵܛܹܪܗܘܿܢ، ܒܸܬ ܦܵܐܹܫ ܡܘܼܕܡܝܼܵܐ ܠܐܢܵܫܵܐ ܣܲܟ݂ܠܵܐ، ܗ̇ܘ ܕܒܢܹܐ ܠܹܗ ܒܲܝܬܹܗ ܥܲܠܔ ܣܹܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","”ܨܠܹܐ ܠܵܗ̇ ܡܸܛܪܵܐ، ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܢܲܗܪ̈ܵܘܵܬܹ‌ܐ، ܘܩܝܼܡ ܠܗܘܿܢ ܦܵܘܚܹ̈ܐ، ܘܩܝܼܬ ܠܗܘܿܢ ܒܗ̇ܘ ܒܲܝܬܵ‌ܐ، ܘܢܦܝܼܠܔ ܠܹܗ، ܘܗܘܹܐ ܠܵܗ̇ ܢܦܵܠܬܹܗ ܓܘܼܪܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ܐܝܼܡܲܢ ܕܚܬܝܼܡ ܠܹܗ ܝܼܫܘܿܥ ܐܲܢܹܐ ܗܹܡܸܙܡܵܢܹ̈ܐ، ܥܘܼܓ̰ܸܒ ܠܗܘܿܢ ܟܸܢܫܹ̈ܐ ܒܝܘܼܠܦܵܢܹܗ؛ ");
INSERT INTO aii_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ܣܵܒܵܒ ܡܲܠܘܼܦܵܝ ܝܗܘܵܐ ܐܲܝܟ݂ ܚܲܕ ܡܵܪܹܐ ܫܘܼܠܛܵܢܵܐ، ܘܠܵܐ ܐܲܝܟ݂ ܣܵܦܪ̈ܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ܐܝܼܡܲܢ ܕܨܠܹܐ ܠܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܛܘܼܪܵܐ، ܬܒܝܼܥ ܠܗܘܿܢ ܐܸܠܹܗ ܟܸܢܫܹ̈ܐ ܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ܘܐܬܹ‌ܐ ܠܹܗ ܚܲܕ ܓܸܪܒ݂ܵܢܵܐ ܘܣܓ݂ܝܼܕ ܠܹܗ ܐܸܠܹܗ ܘܐܡܝܼܪܹܗ: ”ܡܵܪܝܼ، ܐܸܢ ܒܵܥܹܝܬ، ܡܵܨܹܝܬ ܕܲܟܹܝܬ ܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ܘܦܘܼܫܛܵܐ ܠܹܗ ܝܼܫܘܿܥ ܐܝܼܕܹܗ، ܘܕܩܝܼܪܹܗ ܒܝܼܹܗ، ܘܐܡܝܼܪܹܗ: ”ܒܵܥܹܝܢ، ܦܘܼܫ ܕܸܟ݂ܝܵܐ.“ ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܦܝܼܫ ܠܹܗ ܕܸܟ݂ܝܵܐ ܡ̣ܢ ܓܸܪܒܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܠܵܐ ܗܵܘܝܵܐ ܕܐܵܡܪܹܬ ܠܐܘܼܦ ܚܲܕ، ܐܸܠܵܐ ܙܹܠܔ݇ ܡܲܚܙܝܼ ܓܵܢܘܼܟ݂ ܠܟܵܗܢܵܐ، ܘܡܲܩܪܸܒ݂ ܕܸܒ݂ܚܵܐ ܐܲܝܟ݂ ܕܦܩܝܼܕ ܠܹܗ ܡܘܼܫܹܐ ܠܣܵܗܕܘܼܬܵܝܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ܐܝܼܡܲܢ ܕܥܒ݂ܝܼܪܹܗ ܝܼܫܘܿܥ ܓܵܘ ܟܦܲܪܢܵܚܘܿܡ، ܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣܠܹܗ ܚܲܕ ܪܲܒ ܡܵܐܐ ܘܦܘܼܪܦܸܠܔ ܠܹܗ ܒܝܼܹܗ، ");
INSERT INTO aii_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ܘܐܡܝܼܪܹܗ: ”ܡܵܪܝܼ، ܪܹܓܝܼ ܒܫܘܝܼܬܵ‌ܐ ܝܠܹܗ ܓܵܘ ܒܲܝܬܵ‌ܐ، ܫܦܝܼܠܵܐ، ܘܓ̰ܲܢܓ̰ܘܼܪܹܐ ܝܠܹܗ ܪܵܒܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܐܵܢܵܐ ܒܸܬ ܐܵܬܹܝܢ ܘܒܲܣܡܸܢܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ܓ̰ܘܼܘܸܒ ܠܹܗ ܪܲܒ ܡܵܐܐ ܘܐܡܝܼܪܹܗ: ”ܡܵܪܝܼ، ܐܵܢܵܐ ܠܹܐ ܝܘܸܢ ܚܫܝܼܚܵܐ ܕܐܲܢ݇ܬ ܥܵܒ݂ܪܹܬ ܓܵܘ ܒܲܝܬ‌ܝܼ، ܐܸܠܵܐ ܐܡܘܿܪ، ܒܗܹܡܸܙܡܵܢ ܐܲܚܟ̰ܝܼ، ܘܒܸܬ ܒܵܣܹܡ ܪܹܓܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","”ܐܘܼܦ ܐܵܢܵܐ ܚܲܕ ܐܢܵܫܵܐ ܝܘܸܢ ܬܚܘܿܬ ܫܘܼܠܛܵܢܵܐ، ܘܐܝܼܬ ܬܚܘܿܬ ܐܝܼܕܝܼ ܕܲܚܫܹ̈ܐ، ܘܟܹܐ ܐܵܡܪܹܢ ܠܐܵܗܵܐ: ’ܙܹܠܔ݇،‘ ܘܟܹܐ ܐܵܙܹܠܔ؛ ܘܠܗ̇ܘ ܐܚܹܪܢܵܐ: ’ܬܵ‌ܐ،‘ ܘܟܹܐ ܐܵܬܹ‌ܐ؛ ܘܠܪܹܓܝܼ: ’ܥܒ݂ܘܿܕ ܐܵܗܵܐ،‘ ܘܟܹܐ ܥܵܒܹܕ.“ ");
INSERT INTO aii_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܹܗ ܝܼܫܘܿܥ ܐܵܗܵܐ، ܥܘܼܓ̰ܸܒ ܠܹܗ، ܘܐܡܝܼܪܹܗ ܠܐܵܢܝܼ ܕܒܹܐܬܵܝܵܐ ܝܗܘܵܘ ܥܲܡܹܗ: ”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܘܼܦ ܓܵܘ ܐܝܼܣܪܵܐܹܝܠܔ ܠܵܐ ܡܘܼܫ݇ܟ̰ܸܚ ܠܝܼ ܗܲܝܡܵܢܘܼܬܵ‌ܐ ܐܲܝܟ݂ ܐܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","”ܘܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܪܵܒܵܐ ܒܸܬ ܐܵܬ‌ܝܼ ܡ̣ܢ ܡܲܕܢܚܵܐ ܘܡ̣ܢ ܡܲܥܪܒ݂ܵܐ، ܘܒܸܬ ܝܵܬܒ݂ܝܼ ܥܲܡ ܐܲܒ݂ܪܵܗܵܡ ܘܐܝܼܣܚܵܩ ܘܝܲܥܩܘܿܒ݂ ܓܵܘ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ؛ ");
INSERT INTO aii_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","”ܐܝܼܢܵܐ ܒܢܘܿܢܹ̈ܐ ܕܡܲܠܟܘܼܬܵ‌ܐ ܒܸܬ ܦܵܝܫܝܼ ܪܘܼܦܝܹܐ ܓܵܘ ܚܸܫܟܵܐ ܒܲܪܵܝܵܐ، ܐܲܝܟܵܐ ܕܒܸܬ ܗܵܘܹܐ ܒܸܟ݂ܝܵܐ ܘܚܲܪܚܲܟ̰ܬܵ‌ܐ ܕܟܹܟܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ܘܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܠܗ̇ܘ ܪܲܒ ܡܵܐܐ: ”ܙܹܠܔ݇، ܐܲܝܟ݂ ܕܗܘܼܡܸܢܘܼܟ݂ ܗܵܘܹܐ ܠܘܼܟ݂.“ ܘܒܣܝܼܡ ܠܹܗ ܪܹܓܹܗ ܒܗ̇ܝ ܣܵܥܲܬ. ");
INSERT INTO aii_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ܐܬܹ‌ܐ ܠܹܗ ܝܼܫܘܿܥ ܠܒܲܝܬܵ‌ܐ ܕܫܸܡܥܘܿܢ ܟܹܐܦܵܐ، ܘܚܙܹܐ ܠܹܗ ܠܚܡܵܬܹܗ ܕܡܝܼܟ݂ܬܵ‌ܐ ܘܕܒ݂ܝܼܩܬܘܼܗ̇ ܚܲܡܚܲܡܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ܘܕܩܝܼܪܹܗ ܒܐܝܼܕܘܼܗ̇ ܘܫܒ݂ܝܼܩ ܠܵܗ̇ ܐܸܠܘܼܗ̇ ܚܲܡܚܲܡܬܵ‌ܐ، ܘܩܝܼܡ ܠܵܗ̇ ܘܥܒ݂ܝܼܕ ܠܵܗ̇ ܐܸܠܵܝܗ‌ܝ ܚܸܠܡܲܬ. ");
INSERT INTO aii_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ܐܝܼܡܲܢ ܕܗܘܹܐ ܠܹܗ ܪܲܡܫܵܐ، ܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܪܵܒܵܐ ܡ̣ܢ ܐܵܢܝܼ ܕܐܝܼܬ ܗܘܵܘ ܒܝܼܵܝܗ‌ܝ ܫܹܐܕܹ̈ܐ. ܘܦܘܼܠܸܛ ܠܹܗ ܠܫܹܐܕܵܝ̈ܗ‌ܝ ܒܗܹܡܸܙܡܵܢ، ܘܒܘܼܣܸܡ ܠܹܗ ܠܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܡܪܝܼܥܹܐ ܝܗܘܵܘ. ");
INSERT INTO aii_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ܘܐܵܗܵܐ ܗܘܹܐ ܠܵܗ̇ ܕܦܵܐܹܫ ܬܘܼܡܸܡܵܐ ܡܸܢܕܝܼ ܕܦܝܼܫ ܠܹܗ ܐܡܝܼܪܵܐ ܒܐܹܫܲܥܝܵܐ ܢܒ݂ܝܼܵܐ ܕܐܡܝܼܪܹܗ: ܗ̇ܘ ܫܩܝܼܠܔ ܠܹܗ ܡܲܪ̈ܥܲܢ ܘܛܥܝܼܢܹܗ ܟܹܐܒܲܢ̈. ");
INSERT INTO aii_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܹܗ ܝܼܫܘܿܥ ܠܟܸܢܫܹ̈ܐ ܪܵܒܵܐ ܕܝܼܗܘܵܘ ܠܚܵܕܸܪ̈ܘܵܢܘܼܗ‌ܝ، ܦܩܝܼܕ ܠܹܗ ܕܐܵܙܠ݇ܝܼ ܠܗ̇ܘ ܡܲܪܙܵܐ ܐܚܹܪܢܵܐ ܕܝܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ܘܩܘܼܪܒܸܢܹܗ ܚܲܕ ܣܵܦܪܵܐ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܪܲܒܝܼ، ܒܸܬ ܐܵܬܹܝܢ ܒܵܬܪܘܼܟ݂ ܠܐܲܝܟܵܐ ܕܐܵܙܹܠ݇ܬ.“ ");
INSERT INTO aii_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܬܲܥ̈ܠܹܐ ܒܸܙܥܵܙܹ̈ܐ ܐܝܼܬ ܠܗܘܿܢ، ܘܛܲܝܪܹ̈ܐ ܕܫܡܲܝܵܐ ܩܸܢܵܬܹ̈‌ܐ، ܐܝܼܢܵܐ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܠܲܝܬ ܠܹܗ ܕܘܼܟܵܐ ܕܡܲܬܸܒ݂ ܪܹܝܫܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܚܲܕ ܐܚܹܪܢܵܐ ܡ̣ܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܡܵܪܝܼ، ܗܲܒ݂ܠܔ ܠܝܼ ܦܣܵܣܵܐ ܩܲܕܡܵܝܬܵ‌ܐ ܐܵܙܹܠ݇ܢ ܘܩܵܒ݂ܪܹܢ ܠܒܵܒܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܬܵ‌ܐ ܒܵܬܪܝܼ، ܘܫܒ݂ܘܿܩ ܡܝܼ̈ܬܹ‌ܐ ܩܵܒ݂ܪܝܼ ܡܝܼܬܵܝ̈ܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ܐܝܼܡܲܢ ܕܐܣܝܼܩ ܠܹܗ ܝܼܫܘܿܥ ܓܵܘ ܓܵܡܝܼ، ܥܒ݂ܝܼܪܗܘܿܢ ܥܲܡܹܗ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ܘܗܘܹܐ ܠܹܗ ܚܲܕ ܫܓ݂ܘܼܫܝܵܐ ܓܘܼܪܵܐ ܒܝܵܡܵܐ، ܗܵܕܟ݂ܵܐ ܕܠܲܦܹ̈ܐ ܟܘܼܣܹܐ ܠܗܘܿܢ ܠܓܵܡܝܼ. ܘܝܼܫܘܿܥ ܕܡܝܼܟ݂ܵܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ܘܩܘܼܪܒܸܢܗܘܿܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܡܘܼܪܥܸܫ ܠܗܘܿܢ ܐܸܠܹܗ، ܘܐܡܝܼܪܗܘܿܢ: ”ܡܵܪܲܢ، ܦܲܨܝܼ ܠܲܢ، ܒܸܛܠܵܩܵܐ ܝܘܲܚ.“ ");
INSERT INTO aii_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܩܵܡܘܿܕܝܼ ܒܸܙܕܵܥܵܐ ܝܬܘܿܢ، ܝܵܐ ܒܵܨܘܿܪܹ̈ܐ ܕܗܲܝܡܵܢܘܼܬܵ‌ܐ؟“ ܗ̇ܝܓܵܗ ܩܝܼܡ ܠܹܗ ܢܓ̰ܝܼܘ ܠܹܗ ܒܦܵܘܚܵܐ ܘܒܝܵܡܵܐ، ܘܗܘܹܐ ܠܹܗ ܫܸܬܩܵܐ ܓܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ܐܢܵܫܹ̈ܐ ܥܘܼܓ̰ܸܒ ܠܗܘܿܢ ܘܐܡܝܼܪܗܘܿܢ: ”ܡܵܢܝܼ ܝܠܹܗ ܐܵܗܵܐ ܕܦܵܘܚܵܐ ܘܝܵܡܵܐ ܒܸܫܠܵܡܵܐ ܝܢܵܐ ܐܸܠܹܗ؟“ ");
INSERT INTO aii_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ܘܐܝܼܡܲܢ ܕܐܬܹ‌ܐ ܠܹܗ ܝܼܫܘܿܥ ܠܡܲܪܙܵܐ ܐܚܹܪܢܵܐ ܓܵܘ ܐܲܬܪܵܐ ܕܓܸܕܪ̈ܵܝܹܐ، ܬܦܝܼܩ ܠܗܘܿܢ ܒܝܼܹܗ ܬܪܹܝ ܫܹܐܕܵܢܹ̈ܐ ܒܸܦܠܵܛܵܐ ܡ̣ܢ ܒܹܝܬ ܩܒ݂ܘܼܪܹ̈ܐ، ܘܗܵܕܟ݂ܵܐ ܝܗܘܵܘ ܣܪ̈ܝܼܚܹܐ ܕܐܘܼܦ ܚܲܕ ܠܹܐ ܡܵܨܹܐ ܗܘܵܐ ܥܵܒܹܪ ܗܘܵܐ ܒܗ̇ܝ ܐܘܼܪܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ܡܘܼܩܘܸܚ ܠܗܘܿܢ ܘܐܡܝܼܪܗܘܿܢ: ”ܡܵܐ ܠܘܼܟ݂ ܡܸܢܲܢ، ܝܵܐ ܝܼܫܘܿܥ ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ؟ ܐܬܹ‌ܐ ܠܘܼܟ݂ ܠܲܐܟ݂ܵܐ ܡ̣ܢ ܩܲܕܡ ܥܕܵܢܵܐ ܕܓ̰ܲܢܓ̰ܸܪܸܬ ܠܲܢ؟“ ");
INSERT INTO aii_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ܐܝܼܬ ܗܘܵܐ ܪܸܚܩܵܐ ܡܸܢܵܝܗ‌ܝ ܚܕܵܐ ܒܸܩܪܵܐ ܓܘܼܪܬܵ‌ܐ ܕܚܙܘܼܪܹ̈ܐ ܒܸܪܥܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ܘܛܠܝܼܒ ܠܗܘܿܢ ܡܸܢܹܗ ܐܵܢܝܼ ܫܹܐܕܹ̈ܐ ܘܐܡܝܼܪܗܘܿܢ: ”ܐܸܢ ܦܲܠܛܸܬ ܠܲܢ، ܗܲܒ݂ܠܔ ܠܲܢ ܦܣܵܣܵܐ ܕܐܵܙܲܠ݇ܚ ܓܵܘ ܒܸܩܪܵܐ ܕܚܙܘܼܪܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܙܹܠ݇ܡܘܼܢ.“ ܘܒܗ̇ܝ ܥܕܵܢܵܐ ܦܠܝܼܛ ܠܗܘܿܢ ܘܥܒ݂ܝܼܪܗܘܿܢ ܓܵܘ ܒܸܩܪܵܐ ܕܚܙܘܼܪܹ̈ܐ، ܘܗ̇ܝܓܵܗ ܪܚܝܼܛ ܠܵܗ̇ ܒܸܩܪܵܐ ܕܚܙܘܼܪܹ̈ܐ ܠܫܩܝܼܦܵܐ، ܘܢܦܝܼܠܔ ܠܗܘܿܢ ܓܵܘ ܝܵܡܵܐ، ܘܚܢܝܼܩ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ܐܵܢܝܼ ܕܡܲܪܥܘܼܝܹܐ ܝܗܘܵܘ ܥܪܝܼܩ ܠܗܘܿܢ ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܠܡܕܝܼܢ݇ܬܵ‌ܐ ܘܗܘܼܩܹܐ ܠܗܘܿܢ ܒܘܼܬ ܟܠܔ ܡܸܢܕܝܼ ܕܗܘܹܐ ܠܹܗ، ܘܒܘܼܬ ܐܵܢܝܼ ܕܐܝܼܬ ܗܘܵܘ ܒܝܼܵܝܗ‌ܝ ܫܹܐܕܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ܘܦܠܝܼܛ ܠܗܘܿܢ ܟܠܵܝܗ‌ܝ ܐܢܵܫܹ̈ܐ ܕܡܕܝܼܢ݇ܬܵ‌ܐ ܠܐܘܼܪܚܵܐ ܕܝܼܫܘܿܥ، ܘܐܝܼܡܲܢ ܕܚܙܹܐ ܠܗܘܿܢ ܐܸܠܹܗ، ܛܠܝܼܒ ܠܗܘܿܢ ܡܸܢܹܗ ܕܐܵܙܹܠܔ ܡ̣ܢ ܬܚܘܼܡܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ܘܐܣܝܼܩ ܠܹܗ ܝܼܫܘܿܥ ܓܵܘ ܓܵܡܝܼ، ܘܐܙܝܼܠܔ ܠܹܗ ܠܗ̇ܘ ܡܲܪܙܵܐ ܐܚܹܪܢܵܐ ܘܐܬܹ‌ܐ ܠܹܗ ܠܡܕܝܼܢ݇ܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ܘܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܚܲܕ ܫܦܝܼܠܵܐ ܕܸܪܝܵܐ ܒܫܘܝܼܬܵ‌ܐ. ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܹܗ ܝܼܫܘܿܥ ܗܲܝܡܵܢܘܼܬܵܝܗ‌ܝ، ܐܡܝܼܪܹܗ ܠܗ̇ܘ ܫܦܝܼܠܵܐ: ”ܗܘܝܼ ܠܸܒܵܢܵܐ ܒܪܘܿܢܝܼ، ܦܘܼܚܠܹܐ ܝܢܵܐ ܐܸܠܘܼܟ݂ ܚܛܝܼܵܬܘܼ̈ܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ܗ̇ܝܓܵܗ ܐܡܝܼܪܗܘܿܢ ܚܲܕܟܡܵܐ ܣܵܦܪܹ̈ܐ ܓܵܘ ܓܵܢܵܝܗ‌ܝ: ”ܐܵܗܵܐ ܒܸܓܕܵܦܵܐ ܝܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ܝܕܝܼܥ ܠܹܗ ܝܼܫܘܿܥ ܚܘܼܫܵܒ݂ܵܝ̈ܗ‌ܝ ܘܐܡܝܼܪܹܗ: ”ܩܵܡܘܿܕܝܼ ܒܸܚܫܵܒ݂ܵܐ ܝܬܘܿܢ ܒܝܼܫܬܵ‌ܐ ܒܠܸܒܵܘܟ݂ܘܿܢ؟ ");
INSERT INTO aii_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","”ܐܲܝܢܝܼ ܝܠܵܗ̇ ܒܘܼܫ ܦܫܘܼܩܬܵ‌ܐ ܠܹܐܡܵܪܵܐ: ’ܦܘܼܚܠܹܐ ܝܢܵܐ ܐܸܠܘܼܟ݂ ܚܛܝܼܵܬܘܼ̈ܟ݂،‘ ܝܲܢ ܠܹܐܡܵܪܵܐ: ’ܩܘܼܡ ܚܕܘܿܪ؟‘ ");
INSERT INTO aii_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","”ܐܝܼܢܵܐ ܕܝܵܕܥܝܼܬܘܿܢ ܕܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܐܝܼܬ ܠܹܗ ܫܘܼܠܛܵܢܵܐ ܒܐܲܪܥܵܐ ܕܦܲܚܸܠܔ ܚܛܝܼܵܬܹ̈‌ܐ.“ ܗ̇ܝܓܵܗ ܐܡܝܼܪܹܗ ܠܗ̇ܘ ܫܦܝܼܠܵܐ: ”ܩܘܼܡ، ܫܩܘܿܠܔ ܫܘܝܼܬܘܼܟ݂، ܘܙܹܠܔ݇ ܠܒܲܝܬܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ܘܩܝܼܡ ܠܹܗ ܘܐܙܝܼܠܔ ܠܹܗ ܠܒܲܝܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ܘܐܝܼܡܲܢ ܕܚܙܹܐ ܠܗܘܿܢ ܟܸܢܫܹ̈ܐ، ܙܕܝܼܥ ܠܗܘܿܢ، ܘܫܘܼܒܸܚ ܠܗܘܿܢ ܠܐܲܠܵܗܵܐ ܕܝܘܼܗܒܹܠܔ ܠܹܗ ܗܵܕܟ݂ܵܐ ܫܘܼܠܛܵܢܵܐ ܠܒܢܲܝ̈ܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ܘܟܲܕ ܥܒ݂ܝܼܪܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܬܵܡܵܐ، ܚܙܹܐ ܠܹܗ ܚܲܕ ܐܢܵܫܵܐ ܫܸܡܹܗ ܡܲܬܲ‌ܝ، ܝܬܝܼܒ݂ܵܐ ܒܒܹܝܬ ܡܵܟ݂ܣܹ̈ܐ، ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܬܵ‌ܐ ܒܵܬܪܝܼ.“ ܩܝܼܡ ܠܹܗ ܘܐܙܝܼܠܔ ܠܹܗ ܒܵܬܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ܘܟܲܕ ܝܬܝܼܒ݂ܵܐ ܝܗܘܵܐ ܠܣܘܼܦܪܵܐ ܓܵܘ ܒܲܝܬܵ‌ܐ ܕܡܲܬܲ‌ܝ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܪܵܒܵܐ ܡܵܟ݂ܣܹ̈ܐ ܘܚܲܛܵܝܹ̈ܐ ܘܝܬܝܼܒ݂ ܠܗܘܿܢ ܥܲܠܔ ܣܘܼܦܪܵܐ ܥܲܡ ܝܼܫܘܿܥ ܘܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ܟܲܕ ܦܪ̈ܝܼܫܹܐ ܚܙܹܐ ܠܗܘܿܢ ܐܸܠܵܝܗ‌ܝ، ܐܡܝܼܪܗܘܿܢ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܩܵܡܘܿܕܝܼ ܥܲܡ ܡܵܟ݂ܣܹ̈ܐ ܘܚܲܛܵܝܹ̈ܐ ܒܹܐܟ݂ܵܠܵܐ ܝܠܹܗ ܪܲܒܝܼܵܘܟ݂ܘܿܢ؟“ ");
INSERT INTO aii_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ܘܟܲܕ ܫܡܝܼܥ ܠܹܗ ܝܼܫܘܿܥ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܠܹܐ ܝܢܵܐ ܣܢܝܼܩܹܐ ܠܐܵܣܝܵܐ ܐܵܢܝܼ ܕܝܼܢܵܐ ܒܚܘܼܠܡܵܢܵܐ، ܐܸܠܵܐ ܐܵܢܝܼ ܕܡܪܝܼܥܹܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","”ܙܹܠ݇ܡܘܼܢ ܘܝܠܘܿܦܘܼܢ ܡܘܼܕܝܼ ܝܠܹܗ: ’ܪ̈ܲܚܡܹܐ ܟܹܐ ܒܵܥܹܝܢ، ܘܠܵܐ ܕܸܒ݂ܚܵܐ.‘ ܣܵܒܵܒ ܐܵܢܵܐ ܠܵܐ ܐܬܹ‌ܐ ܠܝܼ ܕܩܵܪܹܝܢ ܠܙܲܕܝܼܩܹ̈ܐ، ܐܸܠܵܐ ܠܚܲܛܵܝܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ܗ̇ܝܓܵܗ ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣ ܝܼܫܘܿܥ ܬܲܠܡܝܼ̈ܕܹܐ ܕܝܘܿܚܲܢܵܢ ܘܐܡܝܼܪܗܘܿܢ: ”ܩܵܡܘܿܕܝܼ ܐܲܚܢܲܢ ܘܦܪ̈ܝܼܫܹܐ ܟܹܐ ܨܵܝܡܲܚ ܪܵܒܵܐ، ܐܝܼܢܵܐ ܬܲܠܡܝܼܕܘܼ̈ܟ݂ ܠܹܐ ܨܵܝܡܝܼ؟“ ");
INSERT INTO aii_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܩܵܡܘܿܕܝܼ، ܟܹܐ ܡܵܨܝܼ ܐܢܵܫܹ̈ܐ ܕܓܢܘܿܢܵܐ ܥܵܒ݂ܕܝܼ ܬܵܥܙܝܼ ܟܡܵܐ ܕܚܸܬܢܵܐ ܥܲܡܵܝܗ‌ܝ ܝܠܹܗ؟ ܐܝܼܢܵܐ ܒܸܬ ܐܵܬ‌ܝܼ ܝܵܘܡܵܢܹ̈ܐ ܐܝܼܡܲܢ ܕܦܵܐܹܫ ܫܩܝܼܠܵܐ ܡܸܢܵܝܗ‌ܝ ܚܸܬܢܵܐ، ܘܗ̇ܝܓܵܗ ܒܸܬ ܨܵܝܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","”ܐܘܼܦ ܚܲܕ ܠܹܐ ܕܵܪܹܐ ܥܵܪܵܝܬܵ‌ܐ ܚܲܕܬܵ‌ܐ ܥܲܠܔ ܠܒ݂ܝܼܫܬܵ‌ܐ ܒܠܝܼܬܵ‌ܐ، ܕܠܵܐ ܗܵܘܝܵܐ ܕܓܵܪܫܵܐ ܥܵܪܵܝܬܵ‌ܐ ܡ̣ܢ ܗ̇ܝ ܠܒ݂ܝܼܫܬܵ‌ܐ، ܘܒܸܙܥܵܐ ܒܘܼܫ ܓܲܪܘܸܣ. ");
INSERT INTO aii_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","”ܘܐܢܵܫܹ̈ܐ ܠܹܐ ܕܵܪܝܼ ܚܲܡܪܵܐ ܚܵܕܬܵ‌ܐ ܓܵܘ ܓܘܼܕܹ̈ܐ ܒܸܠܝܹ̈ܐ، ܕܠܵܐ ܦܵܪܛܝܼ ܓܘܼܕܹ̈ܐ، ܘܫܵܦܹܟ݂ ܚܲܡܪܵܐ، ܘܚܵܪܒ݂ܝܼ ܓܘܼܕܹ̈ܐ. ܐܝܼܢܵܐ ܟܹܐ ܕܵܪܝܼ ܚܲܡܪܵܐ ܚܵܕܬܵ‌ܐ ܓܵܘ ܓܘܼܕܹ̈ܐ ܚܵܕܬܹ̈‌ܐ، ܕܗܵܕܟ݂ܵܐ ܬܸܪܘܵܝ ܦܵܝܫܝܼ ܢܛܝܼܪܹܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ܟܲܕ ܝܼܫܘܿܥ ܗܲܡܙܘܼܡܹܐ ܝܗܘܵܐ ܥܲܡܵܝܗ‌ܝ، ܐܬܹ‌ܐ ܠܹܗ ܚܲܕ ܫܲܠܝܼܛܵܐ ܘܣܓ݂ܝܼܕ ܠܹܗ ܐܸܠܹܗ، ܘܐܡܝܼܪܹܗ: ”ܒܪܵܬ‌ܝܼ ܐܵܕܝܼܵܐ ܡܝܼܬ ܠܵܗ̇، ܐܝܼܢܵܐ ܬܵ‌ܐ ܘܡܲܬܸܒ݂ ܐܝܼܕܘܼܟ݂ ܥܲܠܘܼܗ̇ ܘܒܸܬ ܚܵܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ܩܝܼܡ ܠܹܗ ܝܼܫܘܿܥ، ܘܥܲܡܹܗ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܒܵܬܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ܘܗܵܐ ܚܕܵܐ ܒܲܟ݂ܬܵ‌ܐ ܕܒܹܐܙܵܠܵܐ ܝܗܘܵܐ ܕܸܡܘܼܗ̇ ܩܵܐ ܬܪܸܥܣܲܪ ܫܸܢܹ̈ܐ، ܐܬܹ‌ܐ ܠܵܗ̇ ܡ̣ܢ ܒܵܬܪܹܗ، ܘܕܩܝܼܪܵܗ̇ ܒܫܸܦܘܼܠܵܐ ܕܠܒ݂ܝܼܫܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ܣܵܒܵܒ ܐܡܝܼܪܵܗ̇ ܒܓܵܢܘܼܗ̇: ”ܐܵܦܸܢ ܒܠܒ݂ܝܼܫܬܹܗ ܐܲܚܟ̰ܝܼ ܕܵܩܪܵܢ، ܒܸܬ ܦܵܝܫܵܢ ܒܣܝܼܡܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ܘܦܬܝܼܠܔ ܠܹܗ ܝܼܫܘܿܥ ܘܚܸܙܝܵܐ ܠܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇: ”ܗܘܝܼ ܠܸܒܵܢܬܵ‌ܐ ܒܪܵܬ‌ܝܼ، ܗܲܝܡܵܢܘܼܬܵܟ݂ܝ ܩܵܡ ܡܲܚܝܼܵܐ ܠܵܟ݂ܝ.“ ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܦܝܼܫ ܠܵܗ̇ ܒܣܝܼܡܬܵ‌ܐ ܗ̇ܝ ܒܲܟ݂ܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ܐܬܹ‌ܐ ܠܹܗ ܝܼܫܘܿܥ ܠܒܲܝܬܵ‌ܐ ܕܫܲܠܝܼܛܵܐ، ܘܚܙܹܐ ܠܹܗ ܠܡܵܚܝܵܢܹ̈ܐ ܕܫܲܒܝܼܒܹ̈ܐ ܘܟܸܢܫܵܐ ܫܓ݂ܝܼܫܹܐ، ");
INSERT INTO aii_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܦܠܘܿܛܘܼܢ. ܒܪܵܬܵ‌ܐ ܠܹܐ ܝܠܵܗ̇ ܡܝܼܬܬܵ‌ܐ، ܐܸܠܵܐ ܕܡܝܼܟ݂ܬܵ‌ܐ ܝܠܵܗ̇.“ ܘܓܚܝܼܟ ܠܗܘܿܢ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ܘܐܝܼܡܲܢ ܕܦܘܼܠܸܛ ܠܹܗ ܠܟܸܢܫܵܐ، ܥܒ݂ܝܼܪܹܗ ܘܕܒ݂ܝܼܩ ܠܹܗ ܒܐܝܼܕܘܼܗ̇، ܘܩܝܼܡ ܠܵܗ̇ ܗ̇ܝ ܒܪܵܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ܘܦܪܝܼܣ ܠܹܗ ܐܵܗܵܐ ܚܲܒܪܵܐ ܒܟܠܵܗ̇ ܗ̇ܝ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ܘܟܲܕ ܫܘܼܢܹܐ ܠܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܬܵܡܵܐ، ܐܙܝܼܠܔ ܠܗܘܿܢ ܒܵܬܪܹܗ ܬܪܹܝ ܣܸܡܝܹ̈ܐ، ܡܲܩܘܘܼܚܹܐ ܘܒܹܐܡܵܪܵܐ: ”ܥܒ݂ܘܿܕ ܪ̈ܲܚܡܹܐ ܥܲܠܲܢ، ܒܪܘܿܢܵܐ ܕܕܵܘܝܼܕ.“ ");
INSERT INTO aii_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ܘܐܝܼܡܲܢ ܕܐܬܹ‌ܐ ܠܹܗ ܠܒܲܝܬܵ‌ܐ، ܩܘܼܪܒܸܢܗܘܿܢ ܐܸܠܹܗ ܐܵܢܝܼ ܣܸܡܝܹ̈ܐ. ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܗܲܡܘܼܢܹܐ ܝܬܘܿܢ ܕܡܵܨܹܝܢ ܐܵܢܵܐ ܥܵܒ݂ܕܹܢ ܐܵܗܵܐ؟“ ܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܗܹܐ ܡܵܪܲܢ.“ ");
INSERT INTO aii_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ܗ̇ܝܓܵܗ ܕܩܝܼܪܹܗ ܒܥܲܝ̈ܢܵܝܗ‌ܝ ܘܐܡܝܼܪܹܗ: ”ܐܲܝܟ݂ ܕܗܘܼܡܸܢܵܘܟ݂ܘܿܢ ܗܵܘܹܐ ܐܸܠܵܘܟ݂ܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ܘܒܗ̇ܝ ܥܕܵܢܵܐ ܚܙܹܐ ܠܗܘܿܢ. ܘܩܲܫܝܵܐܝܼܬ ܣܘܼܦܹܐ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ: ”ܚܙܹܝܡܘܼܢ ܕܐܘܼܦ ܚܲܕ ܠܵܐ ܝܵܕܹܥ ܒܘܼܬ ܐܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ܐܝܼܢܵܐ ܐܵܢܝܼ ܦܠܝܼܛ ܠܗܘܿܢ ܘܦܪܝܼܣ ܠܗܘܿܢ ܐܵܗܵܐ ܚܲܒܪܵܐ ܒܟܠܵܗ̇ ܗ̇ܝ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ܘܟܲܕ ܒܸܦܠܵܛܵܐ ܝܗܘܵܘ ܝܼܫܘܿܥ ܘܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܚܲܕ ܚܲܪܫܵܐ ܕܐܝܼܬ ܗܘܵܐ ܒܝܼܹܗ ܫܹܐܕܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ܘܐܝܼܡܲܢ ܕܦܝܼܫ ܠܹܗ ܦܘܼܠܛܵܐ ܫܹܐܕܵܐ، ܗܘܼܡܙܸܡ ܠܹܗ ܗ̇ܘ ܚܲܪܫܵܐ. ܘܥܘܼܓ̰ܸܒ ܠܗܘܿܢ ܟܸܢܫܹ̈ܐ ܘܐܡܝܼܪܗܘܿܢ: ”ܚܲܕ ܗܵܕܟ݂ܵܐ ܡܸܢܕܝܼ ܠܲܝܬ ܦܝܼܫܵܐ ܚܸܙܝܵܐ ܓܵܘ ܐܝܼܣܪܵܐܹܝܠܔ.“ ");
INSERT INTO aii_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ܐܝܼܢܵܐ ܦܪ̈ܝܼܫܹܐ ܐܡܝܼܪܗܘܿܢ: ”ܒܝܲܕ ܓܘܼܪܵܐ ܕܫܹܐܕܹ̈ܐ ܦܲܠܘܼܛܹܐ ܝܠܹܗ ܫܹܐܕܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ܒܸܚܕܵܪܵܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܒܟܠܵܝܗ‌ܝ ܡܕܝܼܢܵܬܹ̈‌ܐ ܘܒܡܵܬܘܵܬܹ̈‌ܐ، ܘܡܲܠܘܼܦܹܐ ܒܟܢܘܼܫܝܵܬܵܝ̈ܗ‌ܝ، ܘܡܲܟܪܘܼܙܹܐ ܐܹܘܲܢܓܲܠܝܼܘܿܢ ܕܡܲܠܟܘܼܬܵ‌ܐ، ܘܒܲܣܘܼܡܹܐ ܟܠܵܝܗ‌ܝ ܟܘܼܪ̈ܗܵܢܹܐ ܘܟܠܵܝܗ‌ܝ ܡܲܪ̈ܥܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ܘܟܲܕ ܚܙܹܐ ܠܹܗ ܝܼܫܘܿܥ ܠܟܸܢܫܹ̈ܐ، ܪܘܼܚܸܡ ܠܹܗ ܥܲܠܵܝܗ‌ܝ، ܕܫܘܼܪܫܝܼܹܐ ܝܗܘܵܘ ܘܫܸܪܝܹܐ، ܐܲܝܟ݂ ܥܸܪ̈ܒܹܐ ܕܠܲܝܬ ܠܗܘܿܢ ܪܵܥܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ܐܡܝܼܪܹܗ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܚܸܨܕܵܐ ܪܵܒܵܐ ܝܠܹܗ، ܘܦܵܥ̈ܠܹܐ ܒܵܨܘܿܪܹ̈ܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","”ܒܘܼܬ ܐܵܗܵܐ، ܛܠܘܿܒܘܼܢ ܡ̣ܢ ܡܵܪܵܐ ܕܚܸܨܕܵܐ، ܕܫܲܕܸܪ ܦܵܥ̈ܠܹܐ ܠܚܸܨܕܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ܘܩܪܹܐ ܠܹܗ ܠܬܪܸܥܣܲܪ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܫܘܼܠܛܵܢܵܐ ܕܦܲܠܛܝܼ ܪ̈ܘܼܚܹܐ ܛܲܡܐܹ̈ܐ، ܘܕܒܲܣܡܝܼ ܟܠܔ ܡܲܪܥܵܐ ܘܟܘܼܪܗܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ܘܐܲܢܹܐ ܝܢܵܐ ܫܸܡܵܢܹ̈ܐ ܕܐܵܢܝܼ ܬܪܸܥܣܲܪ ܫܠܝܼܚܹ̈ܐ: ܗ̇ܘ ܩܲܕܡܵܝܵܐ، ܫܸܡܥܘܿܢ ܕܟܹܐ ܦܵܐܹܫ ܩܸܪܝܵܐ ܟܹܐܦܵܐ، ܘܐܲܢܕܪܹܐܘܿܣ ܐܲܚܘܿܢܘܼܗ‌ܝ؛ ܘܝܲܥܩܘܿܒ݂ ܒܪܘܿܢܵܐ ܕܙܲܒ݂ܕܲܝ، ܘܝܘܿܚܲܢܵܢ ܐܲܚܘܿܢܘܼܗ‌ܝ؛ ");
INSERT INTO aii_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ܘܦܝܼܠܝܼܦܘܿܣ، ܘܒܲܪ ܬܘܼܠܡܲܝ؛ ܘܬܐܘܿܡܵܐ، ܘܡܲܬܲ‌ܝ ܡܵܟ݂ܣܵܐ؛ ܘܝܲܥܩܘܿܒ݂ ܒܪܘܿܢܵܐ ܕܚܲܠܦܲܝ؛ ܘܠܲܒܲܝ ܕܦܝܼܫ ܠܹܗ ܩܸܪܝܵܐ ܬܲܕܲܝ؛ ");
INSERT INTO aii_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ܘܫܸܡܥܘܿܢ ܩܢܵܢܵܝܵܐ، ܘܝܼܗܘܼܕܵܐ ܣܟܲܪܝܘܿܛܵܐ، ܗ̇ܘ ܕܣܘܼܦܹܐ ܠܹܗ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ܠܐܲܢܹܐ ܬܪܸܥܣܲܪ ܫܘܼܕܸܪܹܗ ܝܼܫܘܿܥ، ܘܦܩܝܼܕܵܝ ܠܹܗ ܘܐܡܝܼܪܹܗ: ”ܠܵܐ ܐܵܙܠ݇ܝܼܬܘܿܢ ܒܐܘܼܪܚܵܐ ܕܐܸܡܘܵܬܹ̈‌ܐ، ܘܠܵܐ ܥܵܒ݂ܪܝܼܬܘܿܢ ܓܵܘ ܡܕܝܼܢ݇ܬܵ‌ܐ ܕܫܵܡܪ̈ܵܝܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","”ܐܝܼܢܵܐ ܙܹܠ݇ܡܘܼܢ ܒܘܼܫ ܙܵܘܕܵܐ ܠܟܸܣ ܥܸܪ̈ܒܹܐ ܛܠܝܼܩܹ̈ܐ ܕܒܹܝܬ ܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","”ܘܟܲܕ ܐܵܙܠ݇ܝܼܬܘܿܢ، ܡܲܟܪܸܙܘܼܢ ܘܐܡܘܿܪܘܼܢ: ’ܩܘܼܪܒܸܢܵܗ̇ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","”ܒܲܣܡܘܼܢ ܡܪ̈ܝܼܥܹܐ، ܘܕܲܟܹܝܡܘܼܢ ܓܸܪ̈ܒ݂ܵܢܹܐ، ܘܡܲܩܸܡܘܼܢ ܡܝܼ̈ܬܹ‌ܐ، ܘܦܲܠܛܘܼܢ ܫܹܐܕܹ̈ܐ. ܚܘܼܪܵܝܝܼ ܫܩܝܼܠܔ ܠܵܘܟ݂ܘܿܢ، ܚܘܼܪܵܝܝܼ ܗܲܒ݂ܠܘܼܢ. ");
INSERT INTO aii_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","”ܠܵܐ ܠܲܒܠܝܼܬܘܿܢ ܥܲܡܵܘܟ݂ܘܿܢ ܕܲܗܒ݂ܵܐ، ܘܠܵܐ ܣܹܐܡܵܐ، ܘܠܵܐ ܢܚܵܫܵܐ ܒܟܝܼܣܝܵܬܵܘ̈ܟ݂ܘܿܢ؛ ");
INSERT INTO aii_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","”ܘܠܵܐ ܓ̰ܲܢܬܵ‌ܐ ܩܵܐ ܐܘܼܪܚܵܐ، ܘܠܵܐ ܬܲܪܬܹܝ ܨܘܼܕܪ̈ܵܬܹ‌ܐ، ܘܠܵܐ ܨܵܘܠܹ̈ܐ، ܘܠܵܐ ܚܘܼܛܪܵܐ، ܣܵܒܵܒ ܚܫܝܼܚܵܐ ܝܠܹܗ ܦܵܥܠܵܐ ܠܡܹܐܟ݂ܘܼܠܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","”ܘܓܵܘ ܐܲܝܢܝܼ ܡܕܝܼܢ݇ܬܵ‌ܐ ܝܲܢ ܡܵܬܵ‌ܐ ܕܥܵܒ݂ܪܝܼܬܘܿܢ، ܒܲܩܪܘܼܢ ܡܵܢܝܼ ܐܝܼܬ ܚܫܝܼܚܵܐ ܓܵܘܘܼܗ̇، ܘܦܘܼܫܘܼܢ ܬܵܡܵܐ ܗܲܠܔ ܕܦܵܠܛܝܼܬܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","”ܘܐܝܼܡܲܢ ܕܥܵܒ݂ܪܝܼܬܘܿܢ ܠܚܲܕ ܒܲܝܬܵ‌ܐ، ܕܪܹܝܡܘܼܢ ܫܠܵܡܵܐ ܥܲܠܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","”ܐܸܢ ܗ̇ܘ ܒܲܝܬܵ‌ܐ ܚܫܝܼܚܵܐ ܝܠܹܗ، ܫܠܵܡܵܘܟ݂ܘܿܢ ܫܵܪܹܐ ܥܲܠܘܼܗ‌ܝ؛ ܐܝܼܢܵܐ ܐܸܢ ܠܹܐ ܝܠܹܗ ܚܫܝܼܚܵܐ، ܫܠܵܡܵܘܟ݂ܘܿܢ ܕܵܐܹܪ ܥܲܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","”ܡ̇ܢ ܕܠܵܐ ܩܲܒܸܠܔ ܠܵܘܟ݂ܘܿܢ، ܘܠܵܐ ܫܵܡܹܥ ܗܹܡܸܙܡܵܢܵܘܟ݂ܘܿܢ، ܢܦܘܿܨܘܼܢ ܠܥܲܦܪܵܐ ܡ̣ܢ ܐܲܩܠܵܬܵܘ̈ܟ݂ܘܿܢ ܐܝܼܡܲܢ ܕܦܵܠܛܝܼܬܘܿܢ ܡ̣ܢ ܗ̇ܘ ܒܲܝܬܵ‌ܐ ܝܲܢ ܡ̣ܢ ܗ̇ܝ ܡܵܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܠܐܲܪܥܵܐ ܕܣܕܘܿܡ ܘܕܥܵܡܘܿܪܵܐ ܒܸܬ ܗܵܘܹܐ ܢܝܵܚܵܐ ܒܝܵܘܡܵܐ ܕܕܝܵܢܬܵ‌ܐ ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܠܗ̇ܝ ܡܕܝܼܢ݇ܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","”ܗܵܐ ܐܵܢܵܐ ܫܲܕܘܼܪܵܘܟ݂ܘܿܢ ܝܼܘܸܢ ܐܲܝܟ݂ ܥܸܪ̈ܒܹܐ ܓܵܘ ܕܹܐܒܹ̈ܐ؛ ܒܘܼܬ ܐܵܗܵܐ ܗܘܹܝܡܘܼܢ ܚܲܟܝܼܡܹ̈ܐ ܐܲܝܟ݂ ܚܘܼܵܘܵܬܹ̈‌ܐ، ܘܨܸܦܝܹ̈ܐ ܐܲܝܟ݂ ܝܵܘܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","”ܗܘܹܝܡܘܼܢ ܗܸܫܝܲܪ ܡ̣ܢ ܒܢܲܝ̈ܢܵܫܵܐ: ܣܵܒܵܒ ܒܸܬ ܣܲܦܝܼ ܠܵܘܟ݂ܘܿܢ ܠܒܹܝܬ ܕܝܼܢܹ̈ܐ، ܘܓܵܘ ܟܢܘܼܫܝܵܬܵܝ̈ܗ‌ܝ ܒܸܬ ܓ̰ܲܢܓ̰ܸܪܝܼ ܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","”ܘܒܘܼܬ ܕܝܼܝܼ ܒܸܬ ܡܲܝܬ‌ܝܼ ܠܵܘܟ݂ܘܿܢ ܩܲܕܡ ܫܲܠܝܼ̈ܛܹܐ ܘܡܲܠܟܹ̈ܐ، ܠܣܵܗܕܘܼܬܵ‌ܐ ܐܸܠܵܝܗ‌ܝ ܘܠܐܸܡܘܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","”ܐܝܼܢܵܐ ܐܝܼܡܲܢ ܕܣܲܦܝܼ ܠܵܘܟ݂ܘܿܢ، ܠܵܐ ܐܵܟ݂ܠܝܼܬܘܿܢ ܚܲܡ ܕܵܐܟ݂ܝܼ ܝܲܢ ܡܘܼܕܝܼ ܒܸܬ ܗܲܡܙܸܡܝܼܬܘܿܢ؛ ܡܸܢܕܝܼ ܕܗܲܡܙܸܡܝܼܬܘܿܢ ܠܹܗ ܒܗ̇ܝ ܥܕܵܢܵܐ، ܒܸܬ ܦܵܐܹܫ ܝܘܼܗܒ݂ܵܐ ܐܸܠܵܘܟ݂ܘܿܢ؛ ");
INSERT INTO aii_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","”ܣܵܒܵܒ ܠܹܐ ܗܵܘܹܝܬܘܿܢ ܐܲܚܬܘܿܢ ܗܲܡܙܘܼܡܹܐ؛ ܐܸܠܵܐ ܪܘܼܚܵܐ ܕܒܵܒܵܘܟ݂ܘܿܢ ܒܸܬ ܗܲܡܙܸܡ ܒܝܼܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","”ܒܸܬ ܣܲܦܹܐ ܠܡܵܘܬܵ‌ܐ ܐܲܚܘܿܢܵܐ ܠܐܲܚܘܿܢܘܼܗ‌ܝ، ܘܒܵܒܵܐ ܠܒܪܘܿܢܹܗ، ܘܒܸܬ ܩܵܝܡܝܼ ܒܢܘܿܢܹ̈ܐ ܥܲܠܔ ܐܲܒ݂ܵܗܵܝ̈ܗ‌ܝ ܘܒܸܬ ܡܲܡܝܸܬ‌ܝܼ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","”ܘܒܘܼܬ ܫܸܡܝܼ ܒܸܬ ܦܵܝܫܝܼܬܘܿܢ ܣܸܢܝܹܐ ܒܟܠܔ ܐܢܵܫܵܐ؛ ܐܝܼܢܵܐ ܡ̇ܢ ܕܚܵܡܹܠܔ ܗܲܠܔ ܚܲܪܬܵ‌ܐ، ܗ̇ܘ ܒܸܬ ܦܵܪܹܩ. ");
INSERT INTO aii_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","”ܐܝܼܡܲܢ ܕܟܲܡܪܝܼ ܠܵܘܟ݂ܘܿܢ ܓܵܘ ܐܵܗܵܐ ܡܕܝܼܢ݇ܬܵ‌ܐ، ܥܪܘܿܩܘܼܢ ܠܗ̇ܝ ܐܚܹܪܬܵ‌ܐ. ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܠܹܐ ܬܲܡܸܡܝܼܬܘܿܢ ܠܗܘܿܢ ܟܠܵܝܗ‌ܝ ܡܕܝܼܢܵܬܹ̈‌ܐ ܕܒܹܝܬ ܐܝܼܣܪܵܐܹܝܠܔ، ܡܩܲܕܡ ܕܐܵܬܹ‌ܐ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","”ܬܲܠܡܝܼܕܵܐ ܠܹܐ ܝܠܹܗ ܒܘܼܫ ܛܵܒ݂ܵܐ ܡ̣ܢ ܡܲܠܦܵܢܹܗ، ܘܠܵܐ ܪܹܓܵܐ ܡ̣ܢ ܡܵܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","”ܟܹܐ ܡܵܠܝܵܐ ܠܹܗ ܬܲܠܡܝܼܕܵܐ ܕܗܵܘܹܐ ܐܲܝܟ݂ ܡܲܠܦܵܢܹܗ، ܘܪܹܓܵܐ ܐܲܝܟ݂ ܡܵܪܹܗ. ܐܸܢ ܠܡܵܪܵܐ ܕܒܲܝܬܵ‌ܐ ܩܪܹܐ ܠܗܘܿܢ ܒܥܸܠܙܒ݂ܘܿܒ݂، ܟܡܵܐ ܒܘܼܫ ܙܵܘܕܵܐ ܒܸܬ ܩܵܪܝܼ ܠܒܢܘܿܢܹ̈ܐ ܕܒܲܝܬܵ‌ܐ؟ ");
INSERT INTO aii_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","”ܒܘܼܬ ܐܵܗܵܐ، ܠܵܐ ܙܵܕܥܝܼܬܘܿܢ ܡܸܢܵܝܗ‌ܝ، ܣܵܒܵܒ ܠܲܝܬ ܡܸܢܕܝܼ ܕܝܼܠܹܗ ܟܸܣܝܵܐ ܕܠܵܐ ܦܵܐܹܫ ܓܸܠܝܵܐ، ܘܛܸܫܝܵܐ ܕܠܵܐ ܦܵܐܹܫ ܝܕܝܼܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","”ܡܸܢܕܝܼ ܕܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ ܒܚܸܫܟܵܐ، ܐܡܘܿܪܘܼܢ ܠܹܗ ܐܲܚܬܘܿܢ ܒܒܲܗܪܵܐ؛ ܘܡܸܢܕܝܼ ܕܒܸܫܡܵܥܵܐ ܝܬܘܿܢ ܒܢܵܬܝܵܬܵܘ̈ܟ݂ܘܿܢ، ܡܲܟܪܸܙܘܼܢ ܠܹܗ ܥܲܠܔ ܐ݇ܓܵܪ̈ܵܘܵܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","”ܠܵܐ ܙܵܕܥܝܼܬܘܿܢ ܡ̣ܢ ܐܵܢܝܼ ܕܩܵܛܠܝܼ ܠܦܲܓ݂ܪܵܐ، ܐܝܼܢܵܐ ܠܓܵܢܵܐ ܠܹܐ ܡܵܨܝܼ ܩܵܛܠܝܼ؛ ܙܕܹܥܡܘܼܢ ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܗ̇ܘ ܕܡܵܨܹܐ ܠܓܵܢܵܐ ܘܠܦܲܓ݂ܪܵܐ ܛܲܠܸܩ ܓܵܘ ܓܹܗܲܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","”ܠܹܐ ܝܢܵܐ ܬܪܹܝ ܨܸܦܪܹ̈ܐ ܙܘܼܒܢܹܐ ܒܚܲܕ ܦܘܼܠܣܵܐ؟ ܐܝܼܢܵܐ ܐܘܼܦ ܚܲܕ ܡܸܢܵܝܗ‌ܝ ܠܹܐ ܢܵܦܹܠܔ ܥܲܠܔ ܐܲܪܥܵܐ ܕܠܵܐ ܝܕܵܥܬܵ‌ܐ ܕܒܵܒܵܘܟ݂ܘܿܢ ");
INSERT INTO aii_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","”ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ، ܐܘܼܦ ܡܸܙܝܵܬܹ̈‌ܐ ܕܪܹܝܫܵܘܟ݂ܘܿܢ ܟܠܵܝܗ‌ܝ ܡܸܢܝܹܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","”ܒܘܼܬ ܐܵܗܵܐ، ܠܵܐ ܙܵܕܥܝܼܬܘܿܢ؛ ܐܲܚܬܘܿܢ ܒܘܼܫ ܛܝܼܡܵܢܹ̈ܐ ܝܬܘܿܢ ܡ̣ܢ ܪܵܒܵܐ ܨܸܦܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","”ܗܵܕܟ݂ܵܐ، ܟܠܔ ܡ̇ܢ ܕܡܵܘܕܹܐ ܒܝܼܝܼ ܩܲܕܡ ܒܢܲܝ̈ܢܵܫܵܐ، ܐܘܼܦ ܐܵܢܵܐ ܒܸܬ ܡܵܘܕܹܝܢ ܒܝܼܹܗ ܩܲܕܡ ܒܵܒܝܼ ܕܒܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","”ܐܝܼܢܵܐ ܡ̇ܢ ܕܣܵܪܹܒ݂ ܠܝܼ ܩܲܕܡ ܒܢܲܝ̈ܢܵܫܵܐ، ܐܘܼܦ ܐܵܢܵܐ ܒܸܬ ܣܵܪܒܹܢܹܗ ܩܲܕܡ ܒܵܒܝܼ ܕܒܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","”ܠܵܐ ܚܵܫܒ݂ܝܼܬܘܿܢ ܐܬܹ‌ܐ ܠܝܼ ܕܕܵܪܹܝܢ ܫܠܵܡܵܐ ܠܐܲܪܥܵܐ، ܠܵܐ ܐܬܹ‌ܐ ܠܝܼ ܕܕܵܪܹܝܢ ܫܠܵܡܵܐ، ܐܸܠܵܐ ܣܲܝܦܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","”ܣܵܒܵܒ ܐܬܝܼܵܐ ܝܘܸܢ ܕܡܲܩܸܡܸܢ ܐܢܵܫܵܐ ܕܲܠܩܘܼܒ݂ܠܔ ܕܒܵܒܘܼܗ‌ܝ، ܘܒܪܵܬܵ‌ܐ ܕܲܠܩܘܼܒ݂ܠܔ ܕܝܸܡܘܼܗ̇، ܘܟܵܠܬܵ‌ܐ ܕܲܠܩܘܼܒ݂ܠܔ ܕܚܡܵܬܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","”ܘܕܸܫ̃ܡܸܢܹ̈ܐ ܕܐܢܵܫܵܐ ܒܸܬ ܗܵܘܝܼ ܒܢܘܿܢܹ̈ܐ ܕܒܲܝܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","”ܡ̇ܢ ܕܡܲܚܸܒ ܒܵܒܵܐ ܝܲܢ ܝܸܡܵܐ ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܕܡܲܚܸܒ ܐܸܠܝܼ، ܠܹܐ ܚܵܫܹܚ ܐܸܠܝܼ. ܘܡ̇ܢ ܕܡܲܚܸܒ ܒܪܘܿܢܵܐ ܝܲܢ ܒܪܵܬܵ‌ܐ ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܕܡܲܚܸܒ ܐܸܠܝܼ، ܠܹܐ ܚܵܫܹܚ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","”ܘܟܠܔ ܕܠܵܐ ܫܵܩܹܠܔ ܙܩܝܼܦܹܗ ܘܐܵܬܹ‌ܐ ܒܵܬܪܝܼ، ܠܹܐ ܚܵܫܹܚ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","”ܡ̇ܢ ܕܡܲܫ݇ܟ̰ܸܚ ܓܵܢܹܗ، ܒܸܬ ܛܲܠܸܩ ܠܵܗ̇؛ ܘܡ̇ܢ ܕܛܲܠܸܩ ܠܓܵܢܹܗ ܒܘܼܬ ܕܝܼܝܼ، ܒܸܬ ܡܲܫ݇ܟ̰ܸܚ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","”ܡ̇ܢ ܕܩܲܒܸܠܔ ܠܵܘܟ݂ܘܿܢ، ܐܸܠܝܼ ܩܲܒܘܼܠܹܐ ܝܠܹܗ؛ ܘܡ̇ܢ ܕܐܸܠܝܼ ܩܲܒܸܠܔ، ܠܡ̇ܢ ܕܫܘܼܕܪܸܢܹܗ ܩܲܒܘܼܠܹܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","”ܘܡ̇ܢ ܕܩܲܒܸܠܔ ܠܢܒ݂ܝܼܵܐ ܣܵܒܵܒ ܢܒ݂ܝܼܵܐ ܝܠܹܗ، ܦܘܼܪܥܵܢܵܐ ܕܢܒ݂ܝܼܵܐ ܒܸܬ ܫܵܩܹܠܔ؛ ܘܡ̇ܢ ܕܩܲܒܸܠܔ ܙܲܕܝܼܩܵܐ ܣܵܒܵܒ ܙܲܕܝܼܩܵܐ ܝܠܹܗ، ܦܘܼܪܥܵܢܵܐ ܕܙܲܕܝܼܩܵܐ ܒܸܬ ܫܵܩܹܠܔ. ");
INSERT INTO aii_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","”ܘܟܠܔ ܡ̇ܢ ܕܡܲܫܬܹ‌ܐ ܠܚܲܕ ܡ̣ܢ ܐܲܢܹܐ ܙܥܘܿܪܹ̈ܐ ܟܵܣܵܐ ܕܡ̈ܝܼܵܐ ܩܲܪܝܼܪܹ̈ܐ ܐܲܚܟ̰ܝܼ، ܣܵܒܵܒ ܬܲܠܡܝܼܕܵܐ ܝܠܹܗ، ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ ܕܠܹܐ ܛܵܠܹܩ ܦܘܼܪܥܵܢܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ܐܝܼܡܲܢ ܕܦܪܝܼܩ ܠܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܡܲܠܘܼܦܹܐ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ܫܘܼܢܹܐ ܠܹܗ ܡ̣ܢ ܗ̇ܝ ܕܘܼܟܵܐ ܕܝܼܗܘܵܐ، ܘܐܙܝܼܠܔ ܠܹܗ ܠܡܲܠܘܼܦܹܐ ܘܡܲܟܪܘܼܙܹܐ ܓܵܘ ܡܕܝܼܢܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ܘܫܡܝܼܥ ܠܹܗ ܝܘܿܚܲܢܵܢ ܓܵܘ ܒܹܝܬ ܐܲܣܝܼܪܹ̈ܐ ܒܘܼܬ ܦܘܼܠܚܵܢܹ̈ܐ ܕܝܼܫܘܿܥ، ܫܘܼܕܸܪܹܗ ܠܟܸܣܠܹܗ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ܒܹܐܡܵܪܵܐ: ”ܐܲܢ݇ܬ ܝܼܘܸܬ ܗ̇ܘ ܕܐܵܬܹ‌ܐ، ܝܲܢ ܣܵܦܪܲܚ ܠܚܲܕ ܐܚܹܪܢܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܙܹܠ݇ܡܘܼܢ ܘܐܡܘܿܪܘܼܢ ܠܝܘܿܚܲܢܵܢ ܡܸܢܕܝܼܵܢܹ̈ܐ ܕܒܸܫܡܵܥܵܐ ܝܬܘܿܢ ܘܒܸܚܙܵܝܵܐ؛ ");
INSERT INTO aii_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","”ܣܸܡܝܹ̈ܐ ܒܸܚܙܵܝܵܐ ܝܢܵܐ، ܫܦܝܼܠܹ̈ܐ ܒܸܚܕܵܪܵܐ ܝܢܵܐ، ܓܸܪ̈ܒ݂ܵܢܹܐ ܦܝܵܫܵܐ ܝܢܵܐ ܕܘܼܟ݂ܝܹܐ، ܘܚܲܪ̈ܫܹܐ ܒܸܫܡܵܥܵܐ ܝܢܵܐ، ܘܡܝܼ̈ܬܹ‌ܐ ܦܝܵܫܵܐ ܝܢܵܐ ܡܘܼܩܸܡܹܐ، ܘܡܸܣܟܹܢܹ̈ܐ ܦܝܵܫܵܐ ܝܢܵܐ ܡܘܼܟܪܸܙܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","”ܘܛܘܼܒ݂ܵܐ ܠܗ̇ܘ ܕܠܵܐ ܬܲܪܩܸܠܔ ܒܘܼܬ ܕܝܼܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ܟܲܕ ܐܵܢܝܼ ܐܙܝܼܠܔ ܠܗܘܿܢ، ܫܘܼܪܹܐ ܠܹܗ ܝܼܫܘܿܥ ܠܹܐܡܵܪܵܐ ܠܟܸܢܫܹ̈ܐ ܒܘܼܬ ܝܘܿܚܲܢܵܢ: ”ܡܘܼܕܝܼ ܦܠܝܼܛ ܠܵܘܟ݂ܘܿܢ ܠܸܚܙܵܝܵܐ ܓܵܘ ܒܲܪܝܼܵܐ، ܙܹܠܵܐ ܫܥܝܼܫܵܐ ܒܝܲܕ ܦܵܘܚܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","”ܝܲܢ ܡܘܼܕܝܼ ܦܠܝܼܛ ܠܵܘܟ݂ܘܿܢ ܠܸܚܙܵܝܵܐ، ܐܢܵܫܵܐ ܠܒ݂ܝܼܫܵܐ ܓ̰ܘܼܠܹ̈ܐ ܪ̈ܲܟܝܼܟܹܐ؟ ܐܵܢܝܼ ܕܟܹܐ ܠܵܒ݂ܫܝܼ ܓ̰ܘܼܠܹ̈ܐ ܪ̈ܲܟܝܼܟܹܐ ܓܵܘ ܒܵܬܹ̈‌ܐ ܕܡܲܠܟܹ̈ܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","”ܡܘܼܕܝܼ ܦܠܝܼܛ ܠܵܘܟ݂ܘܿܢ ܠܸܚܙܵܝܵܐ، ܢܒ݂ܝܼܵܐ؟ ܗܹܐ، ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܢܒ݂ܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","”ܐܵܗܵܐ ܝܠܹܗ ܗ̇ܘ ܕܦܝܼܫܵܐ ܝܠܹܗ ܟܬܝܼܒ݂ܵܐ ܒܘܼܬ ܕܝܼܹܗ: ܗܵܐ ܫܲܕܘܼܪܹܐ ܝܘܸܢ ܐܝܼܙܓܲܕܝܼ ܡ̣ܢ ܩܲܕܡ ܕܝܼܘܼܟ݂، ܕܗܲܕܸܪ ܐܘܼܪܚܘܼܟ݂ ܩܲܕܡܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܠܹܐ ܝܠܹܗ ܩܝܼܡܵܐ ܓܵܘ ܒܢܲܝ̈ܢܵܫܵܐ ܒܘܼܫ ܓܘܼܪܵܐ ܡ̣ܢ ܝܘܿܚܲܢܵܢ ܡܲܥܡܕܵܢܵܐ. ܐܝܼܢܵܐ ܗ̇ܘ ܒܘܼܫ ܙܥܘܿܪܵܐ ܓܵܘ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ ܒܘܼܫ ܓܘܼܪܵܐ ܝܠܹܗ ܡܸܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","”ܗܵܐ ܡ̣ܢ ܝܵܘܡܵܢܹ̈ܐ ܕܝܘܿܚܲܢܵܢ ܡܲܥܡܕܵܢܵܐ ܘܗܲܠܔ ܐܵܕܝܼܵܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ ܒܚܲܝܠܵܐ ܟܹܐ ܦܵܝܫܵܐ ܠܘܼܒܸܠܬܵ‌ܐ، ܘܠܲܒܠܵܢܘܼ̈ܗ̇ ܓ̰ܢܵܒ݂ܵܐ ܟܹܐ ܓ̰ܵܢܒ݂ܝܼ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","”ܣܵܒܵܒ ܟܠܵܝܗ‌ܝ ܢܒ݂ܝܼܹ̈ܐ ܘܢܵܡܘܿܣܵܐ ܗܲܠܔ ܝܘܿܚܲܢܵܢ ܢܘܼܒܹܐ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","”ܘܐܸܢ ܗܕܝܼܪܹܐ ܝܬܘܿܢ ܕܩܲܒܠܝܼܬܘܿܢ ܠܹܗ، ܐܵܗܵܐ ܝܠܹܗ ܐܹܠܝܼܵܐ ܕܗܕܝܼܪܵܐ ܝܠܹܗ ܠܹܐܬܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","”ܡ̇ܢ ܕܐܝܼܬ ܠܹܗ ܢܵܬܝܵܬܹ̈‌ܐ ܠܸܫܡܵܥܵܐ ܫܵܡܹܥ. ");
INSERT INTO aii_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","”ܠܡ̇ܢ ܡܲܕܡܸܢܵܗ̇ ܐܵܗܵܐ ܫܲܪܒܬܵ‌ܐ؟ ܟܹܐ ܕܵܡܝܵܐ ܠܝܵܠܹ̈ܕ݇ܐ ܕܝܵܬܒ݂ܝܼ ܒܫܘܼܩܹ̈ܐ ܘܡܲܩܘܸܚܝܼ ܠܚܲܒ݂ܪ̈ܵܘܵܬܵܝܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","”ܘܐܵܡܪܝܼ: ’ܡܚܹܐ ܠܲܢ ܙܘܼܪܢܵܐ ܐܸܠܵܘܟ݂ܘܿܢ ܘܠܵܐ ܪܩܝܼܕ ܠܵܘܟ݂ܘܿܢ، ܝܠܹܐ ܠܲܢ ܘܠܵܐ ܥܒ݂ܝܼܕ ܠܵܘܟ݂ܘܿܢ ܬܵܥܙܝܼ.‘ ");
INSERT INTO aii_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","”ܣܵܒܵܒ ܐܬܹ‌ܐ ܠܹܗ ܝܘܿܚܲܢܵܢ ܠܵܐ ܒܹܐܟ݂ܵܠܵܐ ܘܠܵܐ ܒܸܫܬܵܝܵܐ، ܐܡܝܼܪܗܘܿܢ: ’ܫܹܐܕܵܐ ܐܝܼܬ ܒܝܼܹܗ.‘ ");
INSERT INTO aii_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","”ܐܬܹ‌ܐ ܠܹܗ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܹܐܟ݂ܵܠܵܐ ܘܒܸܫܬܵܝܵܐ، ܐܡܝܼܪܗܘܿܢ: ’ܐܵܗܵܐ ܐܢܵܫܵܐ ܐܵܟ݂ܠܵܢܵܐ ܝܠܹܗ ܘܫܵܬܝܵܢܵܐ ܕܚܲܡܪܵܐ، ܘܚܲܒ݂ܪܵܐ ܕܡܵܟ݂ܣܹ̈ܐ ܘܕܚܲܛܵܝܹ̈ܐ.‘ ܐܝܼܢܵܐ ܦܝܼܫ ܠܵܗ̇ ܡܘܼܟܫܸܛܬܵ‌ܐ ܚܸܟ݂ܡܬܵ‌ܐ ܒܥܒ݂ܵܕܘܼ̈ܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ܗ̇ܝܓܵܗ ܫܘܼܪܹܐ ܠܹܗ ܝܼܫܘܿܥ ܒܸܠܝܵܡܵܐ ܠܡܕܝܼܢܵܬܹ̈‌ܐ ܕܥܒ݂ܝܼܕ ܠܹܗ ܓܵܘܵܝܗ‌ܝ ܚܲܝ̈ܠܹܐ ܓܘܼܪܹ̈ܐ ܣܵܒܵܒ ܠܵܐ ܬܘܼܘܸܒ ܠܗܘܿܢ، ܘܐܡܝܼܪܹܗ: ");
INSERT INTO aii_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","”ܘܵܝ ܐܸܠܵܟ݂ܝ ܟܘܼܪܙܝܼܢ، ܘܵܝ ܐܸܠܵܟ݂ܝ ܒܹܝܬ ܨܲܝܵܕܵܐ. ܐܸܢ ܒܨܘܿܪ ܘܒܨܲܝܕܘܿܢ ܦܵܝܫܝܼ ܗܘܵܘ ܥܒ݂ܝܼܕܹܐ ܚܲܝ̈ܠܹܐ ܓܘܼܪܹ̈ܐ ܕܦܝܼܫ ܠܗܘܿܢ ܥܒ݂ܝܼܕܹܐ ܓܵܘܵܘܟ݂ܘܿܢ، ܡ̣ܢ ܓ̰ܲܠܕܹܐ ܒܣܲܩܹ̈ܐ ܘܒܩܸܛܡܵܐ ܒܸܬ ܬܲܘܸܒܝܼ ܗܘܵܘ. ");
INSERT INTO aii_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","”ܐܝܼܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܠܨܘܿܪ ܘܠܨܲܝܕܘܿܢ ܒܸܬ ܗܵܘܹܐ ܢܝܵܚܵܐ ܒܝܵܘܡܵܐ ܕܕܝܵܢܬܵ‌ܐ ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܕܐܸܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","”ܘܐܲܢ݇ܬ‌ܝ ܟܦܲܪܢܵܚܘܿܡ، ܠܵܐ ܗܲܠܔ ܫܡܲܝܵܐ ܡܘܼܪܸܡܬܘܼܗ̇ ܝܘܲܬ‌ܝ ܓܵܢܵܟ݂ܝ؟ ܒܸܬ ܦܵܝܫܲܬ‌ܝ ܡܘܼܟܸܦܬܵ‌ܐ ܗܲܠܔ ܫܝܘܿܠܔ. ܣܵܒܵܒ ܚܲܝ̈ܠܹܐ ܓܘܼܪܹ̈ܐ ܕܦܝܼܫ ܠܗܘܿܢ ܥܒ݂ܝܼܕܹܐ ܓܵܘܵܟ݂ܝ، ܐܸܢ ܦܵܝܫܝܼ ܗܘܵܘ ܥܒ݂ܝܼܕܹܐ ܓܵܘ ܣܕܘܿܡ، ܒܸܬ ܦܵܝܫܵܐ ܗܘܵܐ ܗܲܠܔ ܐܸܕܝܘܿܡ ܝܵܘܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","”ܒܘܼܬ ܐܵܗܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܟ݂ܝ: ܠܐܲܪܥܵܐ ܕܣܕܘܿܡ ܒܸܬ ܗܵܘܹܐ ܢܝܵܚܵܐ ܒܝܵܘܡܵܐ ܕܕܝܵܢܬܵ‌ܐ ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܕܐܸܠܵܟ݂ܝ.“ ");
INSERT INTO aii_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ܒܗ̇ܝ ܥܕܵܢܵܐ ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ: ”ܫܲܒܘܼܚܹܐ ܝܘܸܢ ܐܸܠܘܼܟ݂ ܝܵܐ ܒܵܒܵܐ، ܡܵܪܵܐ ܕܫܡܲܝܵܐ ܘܕܐܲܪܥܵܐ، ܕܛܘܼܫܹܐ ܠܘܼܟ݂ ܐܲܢܹܐ ܡ̣ܢ ܚܲܟܝܼܡܹ̈ܐ ܘܝܵܕܥܵܢܹ̈ܐ، ܘܓܸܠܝܵܝ ܠܘܼܟ݂ ܠܝܵܠܹ̈ܕ݇ܐ ܙܥܘܿܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","”ܗܹܐ ܒܵܒܵܐ، ܣܵܒܵܒ ܗܵܕܟ݂ܵܐ ܒܣܝܼܡ ܠܵܗ̇ ܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","”ܟܠܔ ܡܸܢܕܝܼ ܦܝܼܫ ܠܹܗ ܣܘܼܦܝܵܐ ܐܸܠܝܼ ܒܝܲܕ ܒܵܒܝܼ. ܐܘܼܦ ܚܲܕ ܠܹܐ ܝܵܕܹܥ ܠܒܪܘܿܢܵܐ ܐܸܠܵܐ ܒܵܒܵܐ، ܘܐܘܼܦ ܚܲܕ ܠܹܐ ܝܵܕܹܥ ܠܒܵܒܵܐ ܐܸܠܵܐ ܒܪܘܿܢܵܐ، ܘܒܪܘܿܢܵܐ ܟܹܐ ܡܲܕܸܥ ܠܹܗ ܠܡ̇ܢ ܕܒܵܣܡܵܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","”ܬܹܝܡܘܼܢ ܠܟܸܣܠܝܼ ܟܠܵܘܟ݂ܘܿܢ ܟܟ̰ܝܼܚܹ̈ܐ ܘܛܥܝܼܢܹ̈ܐ ܟܵܪ̈ܵܬܹ‌ܐ ܘܐܵܢܵܐ ܒܸܬ ܡܲܢܝܸܚܸܢܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","”ܛܥܘܿܢܘܼܢ ܢܝܼܪܝܼ ܥܲܠܵܘܟ݂ܘܿܢ ܘܝܠܘܿܦܘܼܢ ܡܸܢܝܼ، ܣܵܒܵܒ ܡܲܟܝܼܟ݂ܵܐ ܝܘܸܢ ܘܟܘܼܦܵܐ ܒܠܸܒܝܼ، ܘܒܸܬ ܡܲܫ݇ܟ̰ܚܝܼܬܘܿܢ ܢܝܵܚܵܐ ܠܓܵܢܵܬܵܘ̈ܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","”ܣܵܒܵܒ ܢܝܼܪܝܼ ܒܲܣܝܼܡܵܐ ܝܠܹܗ، ܘܟܵܪܬ‌ܝܼ ܩܲܠܘܼܠܬܵ‌ܐ ܝܠܵܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ܒܗ̇ܘ ܙܲܒ݂ܢܵܐ، ܒܸܚܕܵܪܵܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ ܓܵܘ ܚܲܩܠܵܢܹ̈ܐ؛ ܘܟܦܝܼܢܗܘܿܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ܘܫܘܼܪܹܐ ܠܗܘܿܢ ܒܸܫܠܵܓܵܐ ܫܸܒܠܹ̈ܐ ܘܒܹܐܟ݂ܵܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ܐܝܼܡܲܢ ܕܦܪ̈ܝܼܫܹܐ ܚܸܙܝܵܝ ܠܗܘܿܢ، ܐܡܝܼܪܗܘܿܢ ܠܝܼܫܘܿܥ: ”ܗܵܐ ܬܲܠܡܝܼܕܘܼ̈ܟ݂ ܒܸܥܒ݂ܵܕܵܐ ܝܢܵܐ ܡܸܢܕܝܼ ܕܠܹܐ ܝܠܹܗ ܩܵܢܘܿܢܵܝܵܐ ܠܸܥܒ݂ܵܕܵܐ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ܐܝܼܢܵܐ ܗ̇ܘ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܠܵܐ ܩܪܹܐ ܠܵܘܟ݂ܘܿܢ ܡܘܼܕܝܼ ܥܒ݂ܝܼܕ ܠܹܗ ܕܵܘܝܼܕ ܐܝܼܡܲܢ ܕܗ̇ܘ ܘܐܵܢܝܼ ܕܝܼܗܘܵܘ ܥܲܡܹܗ ܟܦܝܼܢܗܘܿܢ، ");
INSERT INTO aii_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","”ܕܵܐܟ݂ܝܼ ܥܒ݂ܝܼܪܹܗ ܠܒܲܝܬܵ‌ܐ ܕܐܲܠܵܗܵܐ، ܘܠܲܚܡܵܐ ܕܦܵܬܘܿܪܵܐ ܕܡܵܪܝܵܐ ܐܟ݂ܝܼܠܔ ܠܹܗ، ܟܲܕ ܠܹܐ ܝܗܘܵܐ ܩܵܢܘܿܢܵܝܬܵ‌ܐ ܐܸܠܹܗ ܠܹܐܟ݂ܵܠܹܗ، ܘܐܘܼܦ ܠܵܐ ܠܐܵܢܝܼ ܕܝܼܗܘܵܘ ܥܲܡܹܗ، ܫܒ݂ܘܿܩ ܡ̣ܢ ܠܟܵܗ̈ܢܹܐ ܒܢܲܦ̮ܫܵܝܗ‌ܝ؟ ");
INSERT INTO aii_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","”ܝܲܢ ܠܵܐ ܩܪܹܐ ܠܵܘܟ݂ܘܿܢ ܓܵܘ ܢܵܡܘܿܣܵܐ، ܕܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ ܟܵܗ̈ܢܹܐ ܕܗܲܝܟܠܵܐ ܟܹܐ ܫܵܪܝܼ ܠܫܲܒܬܵ‌ܐ، ܘܠܲܝܬ ܠܵܘܡܵܐ ܥܲܠܵܝܗ‌ܝ؟ ");
INSERT INTO aii_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","”ܐܵܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ ܕܐܝܼܬ ܠܲܐܟ݂ܵܐ ܚܲܕ ܒܘܼܫ ܓܘܼܪܵܐ ܡ̣ܢ ܗܲܝܟܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","”ܘܐܸܢ ܗܵܘܹܝܬܘܿܢ ܗܘܵܘ ܒܝܼܕܵܥܵܐ ܡܘܼܕܝܼ ܝܠܹܗ: ’ܪ̈ܲܚܡܹܐ ܒܸܒܥܵܝܵܐ ܝܘܸܢ ܘܠܵܐ ܕܸܒ݂ܚܵܐ،‘ ܠܹܐ ܕܵܝܢܝܼܬܘܿܢ ܗܘܵܐ ܠܐܵܢܝܼ ܕܠܵܐ ܠܵܘܡܵܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ܣܵܒܵܒ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܡܵܪܵܐ ܕܫܲܒܬܵ‌ܐ ܝܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ܘܫܘܼܢܹܐ ܠܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܬܵܡܵܐ، ܘܐܬܹ‌ܐ ܠܹܗ ܠܟܢܘܼܫܬܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ܘܐܝܼܬ ܗܘܵܐ ܬܵܡܵܐ ܚܲܕ ܐܢܵܫܵܐ ܕܐܝܼܕܹܗ ܒܪܝܼܙܬܵ‌ܐ ܝܗܘܵܐ. ܘܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ ܘܐܡܝܼܪܗܘܿܢ: ”ܩܵܢܘܿܢܵܝܬܵ‌ܐ ܝܠܵܗ̇ ܠܒܲܣܘܼܡܹܐ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ؟“ ܕܩܵܒ݂ܠܝܼ ܗܘܵܘ ܥܲܠܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ܐܝܼܢܵܐ ܗ̇ܘ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܐܲܝܢܝܼ ܡܸܢܵܘܟ݂ܘܿܢ ܕܐܝܼܬ ܠܹܗ ܚܲܕ ܥܸܪܒܵܐ، ܘܐܸܢ ܢܵܦܹܠܔ ܓܵܘ ܗܵܘܬܵ‌ܐ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ، ܠܹܐ ܕܵܒܹܩ ܘܦܲܠܸܛ ܠܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","”ܟܡܵܐ ܒܘܼܫ ܙܵܘܕܵܐ ܛܝܼܡܵܢܵܐ ܝܠܹܗ ܒܲܪܢܵܫܵܐ ܡ̣ܢ ܥܸܪܒܵܐ. ܗܵܕܟ݂ܵܐ ܩܵܢܘܿܢܵܝܬܵ‌ܐ ܝܠܵܗ̇ ܠܸܥܒ݂ܵܕܵܐ ܛܵܒ݂ܬܵ‌ܐ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ܗ̇ܝܓܵܗ ܐܡܝܼܪܹܗ ܠܗ̇ܘ ܐܢܵܫܵܐ: ”ܦܲܫܸܛ ܐܝܼܕܘܼܟ݂.“ ܘܦܘܼܫܛܵܐ ܠܹܗ ܐܝܼܕܹܗ، ܘܬܪܝܼܨ ܠܵܗ̇ ܐܲܝܟ݂ ܗ̇ܝ ܐܚܹܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ܦܠܝܼܛ ܠܗܘܿܢ ܦܪ̈ܝܼܫܹܐ ܘܣܘܼܙܓܸܪܗܘܿܢ ܕܛܲܠܩܝܼ ܗܘܵܘ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܝܕܝܼܥ ܠܹܗ ܒܐܵܗܵܐ ܘܫܘܼܢܹܐ ܠܹܗ ܡ̣ܢ ܬܵܡܵܐ، ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܒܵܬܪܹܗ ܟܸܢܫܹ̈ܐ ܪܵܒܵܐ، ܘܒܘܼܣܸܡ ܠܹܗ ܠܟܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ܘܦܩܝܼܕܵܝ ܠܹܗ ܕܠܵܐ ܓܵܠܝܼ ܗܘܵܘ ܒܘܼܬ ܕܝܼܹܗ، ");
INSERT INTO aii_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ܕܦܵܐܹܫ ܬܘܼܡܸܡܵܐ ܡܸܢܕܝܼ ܕܦܝܼܫܵܐ ܝܗܘܵܐ ܐܡܝܼܪܵܐ ܒܝܲܕ ܐܹܫܲܥܝܵܐ ܢܒ݂ܝܼܵܐ ܕܐܡܝܼܪܹܗ: ");
INSERT INTO aii_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","ܐܵܗܵܐ ܝܠܹܗ ܪܹܓܝܼ ܕܓܘܼܒܹܐ ܠܝܼ، ܡܘܼܚܸܒܝܼ ܕܦܨܝܼܚ ܠܵܗ̇ ܒܝܼܹܗ ܓܵܢܝܼ. ܪܘܼܚܝܼ ܒܸܬ ܡܲܬܒܸܢ ܥܲܠܘܼܗ‌ܝ، ܘܕܝܵܢܬܵ‌ܐ ܠܐܸܡܘܵܬܹ̈‌ܐ ܒܸܬ ܡܲܟܪܸܙ. ");
INSERT INTO aii_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ܠܹܐ ܡܲܩܪܸܨ ܘܠܹܐ ܡܲܩܘܸܚ، ܘܐܢܵܫܵܐ ܠܹܐ ܫܵܡܹܥ ܩܵܠܹܗ ܒܥܵܠܘܿܠܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ܙܹܠܵܐ ܒܠܝܼܣܵܐ ܠܹܐ ܫܵܡܹܛ، ܘܫܪܵܓ݂ܵܐ ܕܛܲܦܛܸܦܵܐ ܠܹܐ ܡܲܟ̰ܡܸܥ، ܗܲܠܔ ܕܡܲܡܛܹܐ ܠܵܗ̇ ܕܝܵܢܬܵ‌ܐ ܠܓ݂ܵܠܹܒܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ܘܒܫܸܡܹܗ ܐܸܡܘܵܬܹ̈‌ܐ ܒܸܬ ܣܵܒܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ܗ̇ܝܓܵܗ ܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣ ܝܼܫܘܿܥ ܚܲܕ ܕܐܝܼܬ ܗܘܵܐ ܒܝܼܹܗ ܫܹܐܕܵܐ، ܕܝܼܗܘܵܐ ܣܸܡܝܵܐ ܘܚܲܪܫܵܐ، ܘܩܵܡ ܒܲܣܸܡ ܠܹܗ، ܗܵܕܟ݂ܵܐ ܕܣܸܡܝܵܐ ܘܚܲܪܫܵܐ ܗܘܼܡܙܸܡ ܠܹܗ ܘܚܙܹܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ܘܦܝܼܫ ܠܗܘܿܢ ܥܘܼܓ̰ܒܹܐ ܟܠܵܝܗ‌ܝ ܟܸܢܫܹ̈ܐ ܘܐܡܝܼܪܗܘܿܢ: ”ܠܹܐ ܝܠܹܗ ܐܵܗܵܐ ܒܪܘܿܢܵܐ ܕܕܵܘܝܼܕ؟“ ");
INSERT INTO aii_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ܐܝܼܢܵܐ ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܗܘܿܢ ܦܪ̈ܝܼܫܹܐ، ܐܡܝܼܪܗܘܿܢ: ”ܐܵܗܵܐ ܠܹܐ ܝܠܹܗ ܦܲܠܘܼܛܹܐ ܫܹܐܕܹ̈ܐ ܐܸܠܵܐ ܒܒܥܸܠܙܒ݂ܘܿܒ݂ ܓܘܼܪܵܐ ܕܫܹܐܕܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ܝܕܝܼܥ ܠܹܗ ܝܼܫܘܿܥ ܚܘܼܫܵܒ݂ܵܝ̈ܗ‌ܝ، ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܟܠܔ ܡܲܠܟܘܼܬܵ‌ܐ ܦܠܝܼܥܬܵ‌ܐ ܥܲܠܔ ܓܵܢܘܼܗ̇ ܒܸܬ ܚܵܪܒ݂ܵܐ، ܘܟܠܔ ܡܕܝܼܢ݇ܬܵ‌ܐ ܝܲܢ ܒܲܝܬܵ‌ܐ ܦܠܝܼܥܵܐ ܥܲܠܔ ܓܵܢܹܗ ܠܹܐ ܟܵܠܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","”ܘܐܸܢ ܣܵܛܵܢܵܐ ܠܣܵܛܵܢܵܐ ܦܲܠܸܛ، ܥܲܠܔ ܓܵܢܹܗ ܦܝܵܫܵܐ ܝܠܹܗ ܦܠܝܼܥܵܐ. ܕܵܐܟ݂ܝܼ ܗܵܕܟ݂ܵܐ ܒܸܬ ܟܵܠܝܵܐ ܡܲܠܟܘܼܬܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","”ܘܐܸܢ ܐܵܢܵܐ ܒܒܥܸܠܙܒ݂ܘܿܒ݂ ܦܲܠܘܼܛܹܐ ܝܘܸܢ ܫܹܐܕܹ̈ܐ، ܒܢܘܿܢܵܘ̈ܟ݂ܘܿܢ ܒܡܵܢܝܼ ܟܹܐ ܦܲܠܛܝܼ ܠܗܘܿܢ؟ ܒܘܼܬ ܐܵܗܵܐ، ܐܵܢܝܼ ܒܸܬ ܗܵܘܝܼ ܐܸܠܵܘܟ݂ܘܿܢ ܕܲܝܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","”ܘܐܸܢ ܒܐܘܼܪܚܵܐ ܕܪܘܼܚܵܐ ܕܐܲܠܵܗܵܐ ܐܵܢܵܐ ܦܲܠܘܼܛܹܐ ܝܘܸܢ ܫܹܐܕܹ̈ܐ، ܒܵܣ ܩܘܼܪܒܸܢܵܗ̇ ܥܲܠܵܘܟ݂ܘܿܢ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","”ܝܲܢ ܕܵܐܟ݂ܝܼ ܡܵܨܹܐ ܐܢܵܫܵܐ ܥܵܒܹܪ ܠܒܲܝܬܵ‌ܐ ܕܚܲܝܠܵܢܵܐ ܘܣܵܠܹܒ ܠܡܸܢܕܝܼܹܗ، ܐܸܢ ܠܵܐ ܩܲܕܡܵܝܬܵ‌ܐ ܐܵܣܹܪ ܠܚܲܝܠܵܢܵܐ، ܘܗ̇ܝܓܵܗ ܣܵܠܹܒ ܠܒܲܝܬܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","”ܡ̇ܢ ܕܠܹܐ ܝܠܹܗ ܥܲܡܝܼ، ܠܕܲܠܩܘܼܒ݂ܠܝܼ ܝܠܹܗ، ܘܡ̇ܢ ܕܠܵܐ ܟܲܦܸܫ ܥܲܡܝܼ، ܒܸܬ ܒܲܪܒܸܙ. ");
INSERT INTO aii_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","”ܒܘܼܬ ܐܵܗܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܟܠܔ ܚܛܝܼܬܵ‌ܐ ܘܓܘܼܕܵܦܵܐ ܒܸܬ ܦܵܝܫܝܼ ܦܘܼܚܠܹܐ ܠܒܢܲܝ̈ܢܵܫܵܐ، ܐܝܼܢܵܐ ܓܘܼܕܵܦܵܐ ܥܲܠܔ ܪܘܼܚܵܐ ܠܹܐ ܦܵܐܹܫ ܦܘܼܚܠܵܐ ܠܒܢܲܝ̈ܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","”ܘܟܠܔ ܡ̇ܢ ܕܐܵܡܹܪ ܗܹܡܸܙܡܵܢ ܥܲܠܔ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ، ܒܸܬ ܦܵܝܫܵܐ ܦܘܼܚܸܠܬܵ‌ܐ ܐܸܠܹܗ، ܐܝܼܢܵܐ ܟܠܔ ܕܥܲܠܔ ܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ ܐܵܡܹܪ، ܠܹܐ ܦܵܝܫܵܐ ܦܘܼܚܸܠܬܵ‌ܐ ܐܸܠܹܗ، ܠܵܐ ܒܐܵܗܵܐ ܙܲܒ݂ܢܵܐ، ܘܠܵܐ ܒܙܲܒ݂ܢܵܐ ܕܐܵܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","”ܐܝܼܠܵܢܵܐ ܛܵܒ݂ܵܐ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܛܵܒܹ̈ܐ ܟܹܐ ܥܵܒܹܕ، ܘܐܝܼܠܵܢܵܐ ܒܝܼܫܵܐ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܒܝܼܫܹ̈ܐ ܟܹܐ ܥܵܒܹܕ. ܡ̣ܢ ܛܥܘܼܢܝܵܬܘܼ̈ܗ‌ܝ ܟܹܐ ܦܵܐܹܫ ܝܕܝܼܥܵܐ ܐܝܼܠܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","”ܝܵܐ ܙܲܪ̈ܥܹܐ ܕܐܵܟܸܕܢܹ̈ܐ، ܕܵܐܟ݂ܝܼ ܡܵܨܹܝܬܘܿܢ ܗܲܡܙܸܡܝܼܬܘܿܢ ܛܵܒ݂ܵܬܹ̈‌ܐ ܟܲܕ ܐܲܚܬܘܿܢ ܒܝܼܫܹ̈ܐ ܝܬܘܿܢ؟ ܣܵܒܵܒ ܡ̣ܢ ܙܵܘܕܘܼܢܝܘܼܬܵ‌ܐ ܕܠܸܒܵܐ ܟܹܐ ܗܲܡܙܸܡ ܦܘܼܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","”ܐܢܵܫܵܐ ܛܵܒ݂ܵܐ ܡ̣ܢ ܣܝܼܡܵܬܹ̈‌ܐ ܛܵܒܹ̈ܐ ܟܹܐ ܦܲܠܸܛ ܛܵܒ݂ܵܬܹ̈‌ܐ؛ ܘܐܢܵܫܵܐ ܒܝܼܫܵܐ ܡ̣ܢ ܣܝܼܡܵܬܹ̈‌ܐ ܒܝܼܫܹ̈ܐ ܟܹܐ ܦܲܠܸܛ ܒܝܼܫܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","”ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܟܠܔ ܗܹܡܸܙܡܵܢ ܒܲܛܝܼܠܬܵ‌ܐ ܕܐܵܡܪܝܼ ܠܵܗ̇ ܒܢܲܝ̈ܢܵܫܵܐ، ܒܸܬ ܝܵܗܒ݂ܝܼ ܓ̰ܘܼܘܵܒ ܥܲܠܘܼܗ̇ ܒܝܵܘܡܵܐ ܕܕܝܵܢܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","”ܣܵܒܵܒ ܡ̣ܢ ܗܹܡܸܙܡܵܢܘܼܟ݂ ܒܸܬ ܦܵܝܫܹܬ ܡܘܼܟܫܸܛܵܐ، ܘܡ̣ܢ ܗܹܡܸܙܡܵܢܘܼܟ݂ ܒܸܬ ܦܵܝܫܹܬ ܕܝܼܢܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ܗ̇ܝܓܵܗ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܚܲܕܟܡܵܐ ܡ̣ܢ ܣܵܦܪܹ̈ܐ ܘܡ̣ܢ ܦܪ̈ܝܼܫܹܐ ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܡܲܠܦܵܢܵܐ، ܒܵܥܲܚ ܕܚܵܙܲܚ ܡܸܢܘܼܟ݂ ܚܲܕ ܢܝܼܫܲܢܩܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ܐܝܼܢܵܐ ܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܫܲܪܒܬܵ‌ܐ ܒܝܼܫܬܵ‌ܐ ܘܓܲܝܵܪܬܵ‌ܐ ܢܝܼܫܲܢܩܵܐ ܒܸܛܠܵܒܵܐ ܝܠܵܗ̇، ܘܢܝܼܫܲܢܩܵܐ ܠܹܐ ܦܵܐܹܫ ܝܘܼܗܒ݂ܵܐ ܐܸܠܘܼܗ̇ ܫܒ݂ܘܿܩ ܡ̣ܢ ܢܝܼܫܲܢܩܵܐ ܕܝܵܘܢܵܢ ܢܒ݂ܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","”ܕܵܐܟ݂ܝܼ ܕܗܘܹܐ ܠܹܗ ܝܵܘܢܵܢ ܓܵܘ ܟܹܪ݇ܣܵܐ ܕܢܘܼܢܵܐ ܬܠܵܬܵ‌ܐ ܝܵܘܡܵܢܹ̈ܐ ܘܬܠܵܬܵ‌ܐ ܠܲܝܠܵܘܵܬܹ̈‌ܐ، ܗܵܕܟ݂ܵܐ ܒܸܬ ܗܵܘܹܐ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܓܵܘ ܠܸܒܵܐ ܕܐܲܪܥܵܐ ܬܠܵܬܵ‌ܐ ܝܵܘܡܵܢܹ̈ܐ ܘܬܠܵܬܵ‌ܐ ܠܲܝܠܵܘܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","”ܐܢܵܫܹ̈ܐ ܕܢܝܼܢܘܹܐ ܒܸܬ ܩܵܝܡܝܼ ܒܝܵܘܡܵܐ ܕܕܝܵܢܬܵ‌ܐ ܥܲܡ ܐܵܗܵܐ ܫܲܪܒܬܵ‌ܐ ܘܒܸܬ ܕܵܝܢܝܼ ܠܵܗ̇، ܣܵܒܵܒ ܐܵܢܝܼ ܬܘܼܘܸܒ ܠܗܘܿܢ ܒܟܵܪܘܿܙܘܼܬܵ‌ܐ ܕܝܵܘܢܵܢ؛ ܘܗܵܐ ܚܲܕ ܒܘܼܫ ܓܘܼܪܵܐ ܡ̣ܢ ܝܵܘܢܵܢ ܐܝܼܬ ܠܲܐܟ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","”ܡܲܠܟܬܵ‌ܐ ܕܬܲܝܡܢܵܐ ܒܸܬ ܩܵܝܡܵܐ ܒܝܵܘܡܵܐ ܕܕܝܵܢܬܵ‌ܐ ܥܲܡ ܐܵܗܵܐ ܫܲܪܒܬܵ‌ܐ ܘܒܸܬ ܕܵܝܢܵܐ ܠܵܗ̇، ܣܵܒܵܒ ܐܬܹ‌ܐ ܠܵܗ̇ ܡ̣ܢ ܡܲܪ̈ܙܵܢܹܐ ܕܐܲܪܥܵܐ ܕܫܵܡܥܵܐ ܚܸܟ݂ܡܬܵ‌ܐ ܕܫܠܹܝܡܘܿܢ، ܘܗܵܐ ܚܲܕ ܒܘܼܫ ܓܘܼܪܵܐ ܡ̣ܢ ܫܠܹܝܡܘܿܢ ܐܝܼܬ ܠܲܐܟ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","”ܐܝܼܡܲܢ ܕܪܘܼܚܵܐ ܛܲܡܐܹܐ ܦܵܠܛܵܐ ܡ̣ܢ ܒܲܪܢܵܫܵܐ، ܟܹܐ ܚܵܕܪܵܐ ܒܕܘܼܟܵܢܹ̈ܐ ܕܠܲܝܬ ܓܵܘܵܝܗ‌ܝ ܡ̈ܝܼܵܐ، ܘܟܹܐ ܛܵܠܒܵܐ ܢܝܵܚܵܐ ܘܠܹܐ ܡܲܫ݇ܟ̰ܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","”ܗ̇ܝܓܵܗ ܟܹܐ ܐܵܡܪܵܐ: ’ܒܸܬ ܕܵܝܪܵܢ ܠܒܲܝܬ‌ܝܼ ܡ̣ܢ ܐܲܝܟܵܐ ܕܦܠܝܼܛ ܠܝܼ.‘ ܘܟܹܐ ܐܵܬܝܵܐ ܘܡܲܫ݇ܟ̰ܚܵܐ ܠܹܗ ܣܦܝܼܩܵܐ ܘܟܢܝܼܫܵܐ ܘܣܘܼܩܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","”ܗ̇ܝܓܵܗ ܟܹܐ ܐܵܙܵܠ݇ܐ ܘܠܲܒܠܵܐ ܥܲܡܘܼܗ̇ ܫܒܲܥ ܪ̈ܘܼܚܹܐ ܒܘܼܫ ܒܝܼܫܹ̈ܐ ܡܸܢܘܼܗ̇، ܘܟܹܐ ܥܵܒ݂ܪܝܼ ܘܥܵܡܪܝܼ ܓܵܘܹܗ، ܘܟܹܐ ܗܵܘܝܵܐ ܚܲܪܬܵ‌ܐ ܕܗ̇ܘ ܐܢܵܫܵܐ ܒܘܼܫ ܣܪܝܼܬܵ‌ܐ ܡ̣ܢ ܩܲܕܡܵܝܬܵ‌ܐ. ܗܵܕܟ݂ܵܐ ܒܸܬ ܗܵܘܹܐ ܠܐܵܗܵܐ ܫܲܪܒܬܵ‌ܐ ܒܝܼܫܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ܟܲܕ ܝܼܫܘܿܥ ܗܲܡܙܘܼܡܹܐ ܝܗܘܵܐ ܠܟܸܢܫܹ̈ܐ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܝܸܡܹܗ ܘܐܲܚܘܿܢܘܵܬܘܼ̈ܗ‌ܝ ܘܟܠܹܐ ܠܗܘܿܢ ܩܲܕܡ ܬܲܪܥܵܐ، ܘܒܵܥܝܼ ܗܘܵܘ ܕܗܲܡܙܸܡܝܼ ܗܘܵܘ ܥܲܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܚܲܕ ܐܢܵܫܵܐ: ”ܗܵܐ ܝܸܡܘܼܟ݂ ܘܐܲܚܘܿܢܘܵܬܘܼ̈ܟ݂ ܟܸܠܝܹܐ ܝܢܵܐ ܩܲܕܡ ܬܲܪܥܵܐ، ܘܒܵܥܝܼ ܕܗܲܡܙܸܡܝܼ ܥܲܡܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܠܗ̇ܘ ܕܬܘܼܢܹܐ ܠܹܗ ܐܸܠܹܗ: ”ܡܵܢܝܼ ܝܠܵܗ̇ ܝܸܡܝܼ، ܘܡܵܢܝܼ ܝܢܵܐ ܐܲܚܘܿܢܘܵܬ‌ܝܼ̈؟“ ");
INSERT INTO aii_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ܘܦܘܼܫܛܵܐ ܠܹܗ ܐܝܼܕܹܗ ܠܟܸܣ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܐܡܝܼܪܹܗ: ”ܗܵܐ ܝܸܡܝܼ، ܘܗܵܐ ܐܲܚܘܿܢܘܵܬ‌ܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","”ܣܵܒܵܒ ܟܠܔ ܐܢܵܫܵܐ ܕܥܵܒܹܕ ܨܸܒ݂ܝܵܢܵܐ ܕܒܵܒܝܼ ܕܒܫܡܲܝܵܐ، ܗ̇ܘ ܝܼܠܹܗ ܐܲܚܘܿܢܝܼ ܘܚܵܬ‌ܝܼ ܘܝܸܡܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ܒܗ̇ܘ ܝܵܘܡܵܐ، ܦܠܝܼܛ ܠܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܒܲܝܬܵ‌ܐ، ܘܝܬܝܼܒ݂ ܠܹܗ ܥܲܠܔ ܡܲܪܙܵܐ ܕܝܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ܘܟܸܢܫܹ̈ܐ ܪܵܒܵܐ ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ، ܗܵܕܵܐ ܕܐܣܝܼܩ ܠܹܗ ܘܝܬܝܼܒ݂ ܠܹܗ ܓܵܘ ܓܵܡܝܼ، ܘܟܠܵܝܗ‌ܝ ܟܸܢܫܹ̈ܐ ܟܸܠܝܹܐ ܝܗܘܵܘ ܠܡܲܪܙܵܐ ܕܝܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ܘܡܘܼܠܦܵܝ ܠܹܗ ܪܵܒܵܐ ܒܡܲܬܠܹ̈ܐ، ܘܐܡܝܼܪܹܗ: ”ܦܠܝܼܛ ܠܹܗ ܚܲܕ ܙܵܪܥܵܢܵܐ ܠܸܙܪܵܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","”ܟܲܕ ܒܸܙܪܵܥܵܐ ܝܗܘܵܐ ܒܲܪܙܲܪܥܵܐ، ܐܝܼܬ ܗܘܵܐ ܕܢܦܝܼܠܔ ܠܹܗ ܥܲܠܔ ܡܲܪܙܵܐ ܕܐܘܼܪܚܵܐ، ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܛܲܝܪܹ̈ܐ ܘܠܩܝܼܛ ܠܗܘܿܢ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","”ܘܐܚܹܪܢܵܐ ܢܦܝܼܠܔ ܠܹܗ ܥܲܠܔ ܐܲܪܥܵܐ ܟܹܐܦܵܢܬܵ‌ܐ، ܐܲܝܟܵܐ ܕܠܲܝܬ ܗܘܵܐ ܥܲܦܪܵܐ ܪܵܒܵܐ، ܘܒܓ̰ܲܠܕܘܼܬܵ‌ܐ ܡܘܼܓ̰ܝܸܢܹܗ ܣܵܒܵܒ ܠܲܝܬ ܗܘܵܐ ܥܘܼܡܩܵܐ ܒܥܲܦܪܵܐ، ");
INSERT INTO aii_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","”ܐܝܼܡܲܢ ܕܙܪܝܼܩ ܠܹܗ ܫܸܡܫܵܐ، ܝܩܝܼܕ ܠܹܗ، ܘܣܵܒܵܒ ܠܲܝܬ ܗܘܵܐ ܠܹܗ ܥܸܩܪܵܐ، ܒܪܝܼܙ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","”ܘܐܚܹܪܢܵܐ ܢܦܝܼܠܔ ܠܹܗ ܓܵܘ ܟܸܬܘܹ̈ܐ، ܘܓܘܼܪܘܸܣ ܠܗܘܿܢ ܟܸܬܘܹ̈ܐ ܘܚܢܝܼܩ ܠܗܘܿܢ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","”ܐܝܼܢܵܐ ܐܚܹܪܢܵܐ ܢܦܝܼܠܔ ܠܹܗ ܥܲܠܔ ܐܲܪܥܵܐ ܫܲܡܝܼܢܬܵ‌ܐ، ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܛܥܘܼܢܝܵܬܹ̈‌ܐ، ܐܝܼܬ ܗܘܵܐ ܒܡܵܐܐ، ܘܐܝܼܬ ܗܘܵܐ ܒܫܬ‌ܝܼ، ܘܐܝܼܬ ܗܘܵܐ ܒܬܠܵܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","”ܡ̇ܢ ܕܐܝܼܬ ܠܹܗ ܢܵܬܝܵܬܹ̈‌ܐ ܠܸܫܡܵܥܵܐ ܫܵܡܹܥ.“ ");
INSERT INTO aii_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܠܟܸܣܠܹܗ ܘܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ: ”ܩܵܡܘܿܕܝܼ ܒܡܲܬܠܹ̈ܐ ܗܲܡܙܘܼܡܹܐ ܝܘܸܬ ܥܲܡܵܝܗ‌ܝ؟“ ");
INSERT INTO aii_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ܓ̰ܘܼܘܸܒ ܠܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܐܸܠܵܘܟ݂ܘܿܢ ܦܝܼܫܵܐ ܝܠܹܗ ܝܘܼܗܒ݂ܵܐ ܕܝܵܕܥܝܼܬܘܿܢ ܐܪ̈ܵܙܹܐ ܕܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ، ܐܝܼܢܵܐ ܠܐܵܢܝܼ ܠܹܐ ܝܠܹܗ ܦܝܼܫܵܐ ܝܘܼܗܒ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","”ܣܵܒܵܒ ܡ̇ܢ ܕܐܝܼܬ ܠܹܗ ܒܸܬ ܦܵܐܹܫ ܝܘܼܗܒ݂ܵܐ ܘܡܘܼܙܝܸܕܵܐ ܐܸܠܹܗ؛ ܘܡ̇ܢ ܕܠܲܝܬ ܠܹܗ، ܐܘܼܦ ܗ̇ܘ ܕܐܝܼܬ ܠܹܗ ܒܸܬ ܦܵܐܹܫ ܫܩܝܼܠܵܐ ܡܸܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","”ܒܘܼܬ ܐܵܗܵܐ ܗܲܡܙܘܼܡܹܐ ܝܘܸܢ ܥܲܡܵܝܗ‌ܝ ܒܡܲܬܠܹ̈ܐ، ܣܵܒܵܒ ܚܙܵܝܵܐ ܠܹܐ ܚܵܙܝܼ، ܘܫܡܵܥܵܐ ܠܹܐ ܫܵܡܥܝܼ، ܘܠܹܐ ܦܲܪܡܝܼ، ");
INSERT INTO aii_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","”ܦܝܼܫ ܠܵܗ̇ ܬܘܼܡܸܡܬܵ‌ܐ ܒܘܼܬ ܕܝܼܵܝܗ‌ܝ ܗܹܡܸܙܡܵܢ ܕܐܹܫܲܥܝܵܐ ܢܒ݂ܝܼܵܐ ܕܐܡܝܼܪܹܗ: ܫܡܵܥܵܐ ܒܸܬ ܫܵܡܥܝܼܬܘܿܢ ܘܠܹܐ ܦܲܪܡܹܝܬܘܿܢ، ܘܚܙܵܝܵܐ ܒܸܬ ܚܵܙܹܝܬܘܿܢ ܘܠܹܐ ܝܵܕܥܝܼܬܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ܣܵܒܵܒ ܚܠܝܼܡ ܠܹܗ ܠܸܒܵܐ ܕܐܵܗܵܐ ܥܲܡܵܐ، ܘܢܵܬܝܵܬܵܝ̈ܗ‌ܝ ܝܘܼܩܪܸܢܗܘܿܢ ܠܸܫܡܵܥܵܐ، ܘܥܲܝ̈ܢܵܝܗ‌ܝ ܐܟ̰ܝܼܡ ܠܗܘܿܢ، ܕܠܵܐ ܚܵܙܝܼ ܒܥܲܝ̈ܢܵܝܗ‌ܝ ܘܫܵܡܥܝܼ ܒܢܵܬܝܵܬܵܝ̈ܗ‌ܝ، ܘܦܲܪܡܝܼ ܒܠܸܒܵܝܗ‌ܝ، ܘܕܵܝܪܝܼ ܘܒܲܣܡܸܢܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","”ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ ܛܘܼܒ݂ܵܐ ܠܥܲܝ̈ܢܵܘܟ݂ܘܿܢ ܕܟܹܐ ܚܵܙܝܼ، ܘܠܢܵܬܝܵܬܵܘ̈ܟ݂ܘܿܢ ܕܟܹܐ ܫܵܡܥܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܪܵܒܵܐ ܢܒ݂ܝܼܹ̈ܐ ܘܙܲܕܝܼܩܹ̈ܐ ܫܘܼܗܘܸܬ ܠܗܘܿܢ ܠܸܚܙܵܝܵܐ ܡܸܢܕܝܼ ܕܐܲܚܬܘܿܢ ܒܸܚܙܵܝܵܐ ܝܬܘܿܢ ܘܠܵܐ ܚܙܹܐ ܠܗܘܿܢ، ܘܡܸܢܕܝܼ ܕܐܲܚܬܘܿܢ ܒܸܫܡܵܥܵܐ ܝܬܘܿܢ ܘܠܵܐ ܫܡܝܼܥ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","”ܫܡܹܥܡܘܼܢ ܐܵܕܝܼܵܐ ܡܲܬܠܵܐ ܕܙܵܪܥܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","”ܟܠܔ ܡ̇ܢ ܕܫܵܡܹܥ ܗܹܡܸܙܡܵܢ ܕܡܲܠܟܘܼܬܵ‌ܐ ܘܠܵܐ ܦܲܪܡܹܐ ܠܵܗ̇، ܟܹܐ ܐܵܬܹ‌ܐ ܒܝܼܫܵܐ ܘܓ̰ܵܢܹܒ݂ ܠܵܗ̇ ܗܹܡܸܙܡܵܢ ܕܦܝܼܫ ܠܵܗ̇ ܙܪܝܼܥܬܵ‌ܐ ܒܠܸܒܹܗ. ܐܵܗܵܐ ܝܠܹܗ ܗ̇ܘ ܒܲܪܙܲܪܥܵܐ ܕܢܦܝܼܠܔ ܠܹܗ ܥܲܠܔ ܡܲܪܙܵܐ ܕܐܘܼܪܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","”ܘܗ̇ܘ ܕܢܦܝܼܠܔ ܠܹܗ ܥܲܠܔ ܐܲܪܥܵܐ ܟܹܐܦܵܢܬܵ‌ܐ، ܗ̇ܘ ܝܼܠܹܗ ܕܟܹܐ ܫܵܡܹܥ ܗܹܡܸܙܡܵܢ، ܘܒܓ̰ܲܠܕܘܼܬܵ‌ܐ ܘܒܚܲܕܘܼܬܵ‌ܐ ܟܹܐ ܩܲܒܸܠܔ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","”ܐܝܼܢܵܐ ܣܵܒܵܒ ܠܲܝܬ ܠܹܗ ܥܸܩܪܵܐ، ܐܸܠܵܐ ܩܵܐ ܚܲܕ ܙܲܒ݂ܢܵܐ ܟܸܪܝܵܐ ܝܠܹܗ، ܘܐܝܼܡܲܢ ܕܟܹܐ ܗܵܘܹܐ ܐܘܼܠܨܵܢܵܐ ܝܲܢ ܪܕܘܼܦܝܵܐ ܒܘܼܬ ܗܹܡܸܙܡܵܢ ܕܐܲܠܵܗܵܐ، ܟܹܐ ܢܵܦܹܠܔ ܒܬܘܼܪܩܵܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","”ܘܗ̇ܘ ܕܦܝܼܫ ܠܹܗ ܙܪܝܼܥܵܐ ܓܵܘ ܟܸܬܘܹ̈ܐ، ܗ̇ܘ ܝܼܠܹܗ ܕܫܵܡܹܥ ܗܹܡܸܙܡܵܢ، ܐܝܼܢܵܐ ܪܸܢܝܵܐ ܕܐܵܗܵܐ ܙܲܒ݂ܢܵܐ ܘܡܲܚܠܸܛܵܢܘܼܬܵ‌ܐ ܕܕܵܘܸܠܬܵ‌ܐ ܟܹܐ ܚܵܢܩܝܼ ܠܵܗ̇، ܘܟܹܐ ܗܵܘܝܵܐ ܕܠܵܐ ܛܥܘܼܢܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","”ܐܝܼܢܵܐ ܗ̇ܘ ܕܦܝܼܫ ܠܹܗ ܙܪܝܼܥܵܐ ܥܲܠܔ ܐܲܪܥܵܐ ܫܲܡܝܼܢܬܵ‌ܐ، ܗ̇ܘ ܝܼܠܹܗ ܕܫܵܡܹܥ ܗܹܡܸܙܡܵܢ ܘܦܲܪܡܹܐ ܠܵܗ̇، ܘܟܹܐ ܝܵܗܒ݂ܵܐ ܛܥܘܼܢܝܵܬܹ̈‌ܐ، ܐܝܼܬ ܒܡܵܐܐ، ܐܝܼܬ ܒܫܬ‌ܝܼ ܘܐܝܼܬ ܒܬܠܵܬ‌ܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ܡܲܬܠܵܐ ܐܚܹܪܢܵܐ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܟܹܐ ܕܵܡܝܵܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ ܠܐܢܵܫܵܐ ܕܙܪܝܼܥ ܠܹܗ ܒܲܪܙܲܪܥܵܐ ܛܵܒ݂ܵܐ ܒܚܲܩܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","”ܘܐܝܼܡܲܢ ܕܕܡܝܼܟ݂ ܠܗܘܿܢ ܟܠܵܝܗ‌ܝ ܐܢܵܫܹ̈ܐ، ܐܬܹ‌ܐ ܠܹܗ ܕܸܫ̃ܡܸܢܹܗ ܘܙܪܝܼܥ ܠܹܗ ܙܝܼܘܵܢܹ̈ܐ ܓܵܘ ܚܸܛܹ̈ܐ ܘܐܙܝܼܠܔ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","”ܐܝܼܢܵܐ ܐܝܼܡܲܢ ܕܡܘܼܓ̰ܝܸܢܹܗ ܝܸܩܢܵܐ، ܥܒ݂ܝܼܕ ܠܹܗ ܛܥܘܼܢܝܵܬܹ̈‌ܐ، ܗ̇ܝܓܵܗ ܦܝܼܫ ܠܗܘܿܢ ܚܸܙܝܹܐ ܐܘܼܦ ܙܝܼܘܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","”ܐܬܹ‌ܐ ܠܗܘܿܢ ܪܹ̈ܓܵܘܵܬܹ‌ܐ ܕܡܵܪܵܐ ܕܒܲܝܬܵ‌ܐ ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ’ܡܵܪܲܢ، ܠܹܐ ܝܗܘܵܐ ܒܲܪܙܲܪܥܵܐ ܛܵܒ݂ܵܐ ܙܪܝܼܥ ܠܘܼܟ݂ ܒܚܲܩܠܘܼܟ݂، ܕܵܐܟ݂ܝܼ ܩܝܼܡ ܠܗܘܿܢ ܙܝܼܘܵܢܹ̈ܐ ܓܵܘܹܗ؟‘ ");
INSERT INTO aii_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","”ܘܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ: ’ܐܢܵܫܵܐ ܕܸܫ̃ܡܸܢ ܥܒ݂ܝܼܕ ܠܹܗ ܐܵܗܵܐ ܫܘܼܠܵܐ.‘ ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ ܪܹ̈ܓܵܘܵܬܘܼܗ‌ܝ: ’ܒܵܥܹܝܬ ܕܐܵܙܲܠ݇ܚ ܘܓܲܒܲܚ ܠܗܘܿܢ؟‘ ");
INSERT INTO aii_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","”ܘܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ: ’ܠܵܐ، ܕܠܵܐ ܗܵܘܝܵܐ ܟܲܕ ܓܲܒܹܝܬܘܿܢ ܙܝܼܘܵܢܹ̈ܐ، ܥܵܩܪܝܼܬܘܿܢ ܥܲܡܵܝܗ‌ܝ ܐܘܼܦ ܚܸܛܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","”ܫܒ݂ܘܿܩܘܼܢ ܠܗܘܿܢ ܕܓܲܪܘܸܣܝܼ ܬܸܪܘܵܝ ܡܥܘܼܕܵܠܹܐ ܗܲܠܔ ܥܕܵܢܵܐ ܕܚܸܨܕܵܐ، ܘܒܥܕܵܢܵܐ ܕܚܸܨܕܵܐ ܒܸܬ ܐܵܡܪܹܢ ܠܚܲܨܵܕܹ̈ܐ: ’ܓܲܒܹܝܡܘܼܢ ܩܲܕܡܵܝܬܵ‌ܐ ܙܝܼܘܵܢܹ̈ܐ، ܘܐܣܘܿܪܘܼܢ ܠܗܘܿܢ ܕܲܪ̈ܙܹܐ ܠܡܲܩܘܼܕܹܐ، ܘܚܸܛܹ̈ܐ ܓ̰ܲܡܸܥܡܘܼܢ ܠܗܘܿܢ ܠܐܲܢܒܵܪܹ̈ܐ.‘“ ");
INSERT INTO aii_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ܡܲܬܠܵܐ ܐܚܹܪܢܵܐ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܟܹܐ ܕܵܡܝܵܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ ܠܕܲܢܕܸܟܬܵ‌ܐ ܕܚܲܪܕܲܠܔ، ܕܙܪܝܼܥܵܐ ܠܹܗ ܚܲܕ ܐܢܵܫܵܐ ܒܚܲܩܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","”ܗ̇ܝ ܒܘܼܫ ܙܥܘܿܪܬܵ‌ܐ ܝܠܵܗ̇ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܒܲܪܙܲܪ̈ܥܹܐ، ܐܝܼܢܵܐ ܐܝܼܡܲܢ ܕܓܲܪܘܸܣܵܐ، ܟܹܐ ܗܵܘܝܵܐ ܒܘܼܫ ܓܘܼܪܬܵ‌ܐ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܝܲܪ̈ܩܹܐ، ܟܹܐ ܗܵܘܝܵܐ ܐܝܼܠܵܢܵܐ، ܗܵܕܵܐ ܕܐܵܬ‌ܝܼ ܛܲܝܪܹ̈ܐ ܕܫܡܲܝܵܐ ܘܫܵܪܝܼ ܓܵܘ ܦܲܥܘܵܢܘܼ̈ܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ܡܲܬܠܵܐ ܐܚܹܪܢܵܐ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܟܹܐ ܕܵܡܝܵܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ ܠܚܡܝܼܪܵܐ ܕܫܩܝܼܠܔ ܠܵܗ̇ ܒܲܟ݂ܬܵ‌ܐ ܘܡܘܼܬܸܒ݂ ܠܵܗ̇ ܓܵܘ ܬܠܵܬܵ‌ܐ ܟܝܘܼܠܹ̈ܐ ܕܩܲܡܚܵܐ ܗܲܠܔ ܕܟܠܹܗ ܚܡܝܼܥ ܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ܟܠܵܝܗ‌ܝ ܐܲܢܹܐ ܗܘܼܡܙܸܡܵܝ ܠܹܗ ܝܼܫܘܿܥ ܒܡܲܬܠܹ̈ܐ ܩܵܐ ܟܸܢܫܹ̈ܐ، ܘܕܠܵܐ ܡܲܬܠܹ̈ܐ ܠܵܐ ܗܘܼܡܙܸܡ ܠܹܗ ܥܲܡܵܝܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ܕܦܵܐܹܫ ܬܘܼܡܸܡܵܐ ܡܸܢܕܝܼ ܕܦܝܼܫ ܠܹܗ ܐܡܝܼܪܵܐ ܒܝܲܕ ܢܒ݂ܝܼܵܐ: ܒܸܬ ܗܲܡܙܸܡܸܢ ܒܡܲܬܠܹ̈ܐ، ܘܒܸܬ ܡܲܕܥܸܢ ܫܘܼܠܹ̈ܐ ܛܸܫܝܹ̈ܐ ܗܵܐ ܡ̣ܢ ܫܘܼܪܵܝܵܐ ܕܒܪܝܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ܗ̇ܝܓܵܗ ܫܒ݂ܝܼܩ ܠܹܗ ܝܼܫܘܿܥ ܠܟܸܢܫܹ̈ܐ ܘܐܬܹ‌ܐ ܠܹܗ ܠܒܲܝܬܵ‌ܐ. ܐܬܹ‌ܐ ܠܗܘܿܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܠܟܸܣܠܹܗ ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܦܲܫܸܩ ܐܸܠܲܢ ܡܲܬܠܵܐ ܕܙܝܼܘܵܢܹ̈ܐ ܘܕܚܲܩܠܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܗ̇ܘ ܕܙܪܝܼܥ ܠܹܗ ܒܲܪܙܲܪܥܵܐ ܛܵܒ݂ܵܐ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","”ܚܲܩܠܵܐ ܕܘܼܢܝܹܐ ܝܠܵܗ̇، ܘܒܲܪܙܲܪܥܵܐ ܛܵܒ݂ܵܐ ܒܢܘܿܢܹ̈ܐ ܕܡܲܠܟܘܼܬܵ‌ܐ ܝܢܵܐ، ܘܙܝܼܘܵܢܹ̈ܐ ܒܢܘܿܢܹ̈ܐ ܕܒܝܼܫܵܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","”ܘܕܸܫ̃ܡܸܢ ܕܙܪܝܼܥ ܠܹܗ ܙܝܼܘܵܢܹ̈ܐ، ܐܵܟܹܠܩܲܪܨܵܐ ܝܠܹܗ؛ ܚܸܨܕܵܐ ܫܘܼܠܵܡܵܐ ܕܙܲܒ݂ܢܵܐ ܝܠܹܗ، ܘܚܲܨܵܕܹ̈ܐ ܡܲܠܲܐܟܹ̈ܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","”ܐܲܝܟ݂ ܕܦܵܝܫܝܼ ܓܘܼܒܝܹܐ ܙܝܼܘܵܢܹ̈ܐ ܘܡܘܼܩܕܹܐ ܒܢܘܼܪܵܐ، ܗܵܕܟ݂ܵܐ ܒܸܬ ܗܵܘܹܐ ܒܫܘܼܠܵܡܵܐ ܕܐܵܗܵܐ ܙܲܒ݂ܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","”ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܸܬ ܫܲܕܸܪ ܡܲܠܲܐܟ݂ܘܼ̈ܗ‌ܝ، ܘܒܸܬ ܓܲܒܝܼ ܡ̣ܢ ܡܲܠܟܘܼܬܹܗ ܟܠܵܝܗ‌ܝ ܕܲܠܩܘܼܒ݂ܠܵܝܹ̈ܐ ܘܥܵܒ݂ܕܵܢܹ̈ܐ ܕܥܵܘܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","”ܘܒܸܬ ܕܵܪܝܼ ܠܗܘܿܢ ܓܵܘ ܐܲܬܘܼܢܵܐ ܕܢܘܼܪܵܐ، ܐܲܝܟܵܐ ܕܝܼܠܹܗ ܒܸܟ݂ܝܵܐ ܘܚܲܪܚܲܟ̰ܬܵ‌ܐ ܕܟܹܟܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","”ܗ̇ܝܓܵܗ ܙܲܕܝܼܩܹ̈ܐ ܒܸܬ ܒܲܗܪܸܢܝܼ ܐܲܝܟ݂ ܫܸܡܫܵܐ ܓܵܘ ܡܲܠܟܘܼܬܵ‌ܐ ܕܒܵܒܵܝܗ‌ܝ. ܡ̇ܢ ܕܐܝܼܬ ܠܹܗ ܢܵܬܝܵܬܹ̈‌ܐ ܠܸܫܡܵܥܵܐ، ܫܵܡܹܥ. ");
INSERT INTO aii_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","”ܡܸܢܕܪܸܫ ܟܹܐ ܕܵܡܝܵܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ ܠܣܝܼܡܬܵ‌ܐ ܛܘܼܫܝܼܬܵ‌ܐ ܒܚܲܩܠܵܐ، ܐܝܼܡܲܢ ܕܚܸܙܝܵܐ ܠܹܗ ܚܲܕ ܐܢܵܫܵܐ، ܛܘܼܫܝܵܐ ܠܹܗ، ܘܡ̣ܢ ܚܲܕܘܼܬܹܗ ܐܙܝܼܠܔ ܠܹܗ ܙܘܼܒܸܢܹܗ ܟܠܔ ܡܸܢܕܝܼ ܕܐܝܼܬ ܗܘܵܐ ܠܹܗ ܘܙܒ݂ܝܼܢܵܐ ܠܹܗ ܗ̇ܝ ܚܲܩܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","”ܡܸܢܕܪܸܫ ܟܹܐ ܕܵܡܝܵܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ ܠܐܢܵܫܵܐ ܬܲܓܵܪܵܐ ܒܸܛܥܵܝܵܐ ܒܵܬܪ ܡܲܪ̈ܓܵܢܝܵܬܹ‌ܐ ܫܲܦܝܼܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","”ܘܐܝܼܡܲܢ ܕܚܙܹܐ ܠܹܗ ܚܕܵܐ ܡܲܪܓܵܢܝܼܬܵ‌ܐ ܪܵܒܵܐ ܛܝܼܡܵܢܬܵ‌ܐ، ܐܙܝܼܠܔ ܠܹܗ ܘܙܘܼܒܸܢܹܗ ܟܠܔ ܡܸܢܕܝܼ ܕܐܝܼܬ ܗܘܵܐ ܠܹܗ ܘܙܒ݂ܝܼܢܵܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","”ܡܸܢܕܪܸܫ ܟܹܐ ܕܵܡܝܵܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ ܠܓܲܪܕܵܐ ܕܸܪܝܵܐ ܒܝܵܡܵܐ، ܕܓ̰ܘܼܡܸܥ ܠܹܗ ܡ̣ܢ ܟܠܔ ܓܸܢܣܵܐ ܕܢܘܼܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","”ܘܟܲܕ ܡܠܹܐ ܠܹܗ، ܓܪܝܼܫ ܠܗܘܿܢ ܠܡܲܪܙܵܐ ܕܝܵܡܵܐ، ܝܬܝܼܒ݂ ܠܗܘܿܢ ܘܓܘܼܒܝܵܝ ܠܗܘܿܢ، ܐܵܢܝܼ ܨܦܵܝܝܼ ܕܸܪܝܵܝ ܠܗܘܿܢ ܓܵܘ ܡܵܐܢܹ̈ܐ، ܘܚܸܪܒܵܐ ܪܘܼܦܝܵܝ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","”ܗܵܕܟ݂ܵܐ ܒܸܬ ܗܵܘܹܐ ܒܫܘܼܠܵܡܵܐ ܕܙܲܒ݂ܢܵܐ. ܒܸܬ ܐܵܬ‌ܝܼ ܡܲܠܲܐܟܹ̈ܐ ܘܒܸܬ ܦܵܪܫܝܼ ܒܝܼܫܹ̈ܐ ܡ̣ܢ ܛܵܒܹ̈ܐ، ");
INSERT INTO aii_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","”ܘܒܸܬ ܕܵܪܝܼ ܠܗܘܿܢ ܒܝܼܫܹ̈ܐ ܓܵܘ ܐܲܬܘܼܢܵܐ ܕܢܘܼܪܵܐ، ܐܲܝܟܵܐ ܕܒܸܬ ܗܵܘܹܐ ܒܸܟ݂ܝܵܐ ܘܚܲܪܚܲܟ̰ܬܵ‌ܐ ܕܟܹܟܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܦܘܼܪܡܹܐ ܠܵܘܟ݂ܘܿܢ ܟܠܵܝܗ‌ܝ ܐܲܢܹܐ؟“ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ: ”ܗܹܐ ܡܵܪܲܢ.“ ");
INSERT INTO aii_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܟܠܔ ܣܵܦܪܵܐ ܕܦܝܼܫܵܐ ܝܠܹܗ ܬܘܼܠܡܸܕܵܐ ܩܵܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ ܟܹܐ ܕܵܡܹܐ ܠܐܢܵܫܵܐ ܡܵܪܵܐ ܕܒܲܝܬܵ‌ܐ ܕܟܹܐ ܦܲܠܸܛ ܡ̣ܢ ܣܝܼܡܵܬܘܼ̈ܗ‌ܝ ܡܸܢܕܝܼܵܢܹ̈ܐ ܚܵܕܬܹ̈‌ܐ ܘܥܲܬܝܼܩܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ܐܝܼܡܲܢ ܕܬܘܼܡܸܡ ܠܹܗ ܝܼܫܘܿܥ ܠܐܲܢܹܐ ܡܲܬܠܹ̈ܐ، ܫܘܼܢܹܐ ܠܹܗ ܡ̣ܢ ܬܵܡܵܐ، ");
INSERT INTO aii_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ܘܐܬܹ‌ܐ ܠܹܗ ܠܡܕܝܼܢ݇ܬܹܗ، ܘܡܲܠܸܦ ܗܘܵܐ ܓܵܘ ܟܢܘܼܫܝܵܬܵܝ̈ܗ‌ܝ، ܕܵܐܟ݂ܝܼ ܕܥܲܓ̰ܒܝܼ ܗܘܵܘ ܘܐܵܡܪܝܼ ܗܘܵܘ: ”ܡ̣ܢ ܐܲܝܟܵܐ ܐܵܗܵܐ ܐܢܵܫܵܐ ܐܝܼܬ ܠܹܗ ܐܵܗܵܐ ܚܸܟ݂ܡܬܵ‌ܐ ܘܐܲܢܹܐ ܚܲܝ̈ܠܹܐ ܓܘܼܪܹ̈ܐ؟ ");
INSERT INTO aii_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","”ܠܹܐ ܝܠܹܗ ܐܵܗܵܐ ܒܪܘܿܢܵܐ ܕܢܲܓܵܪܵܐ؟ ܠܹܐ ܝܠܵܗ̇ ܝܸܡܹܗ ܡܲܪܝܲܡ، ܘܐܲܚܘܿܢܘܵܬܘܼ̈ܗ‌ܝ ܝܲܥܩܘܿܒ݂ ܘܝܘܿܣܹܐ ܘܫܸܡܥܘܿܢ ܘܝܼܗܘܼܕܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","”ܘܠܹܐ ܝܢܵܐ ܚܵܬܘܵܬܘܼ̈ܗ‌ܝ ܟܠܵܝܗ‌ܝ ܠܟܸܣܠܲܢ؟ ܡ̣ܢ ܐܲܝܟܵܐ ܐܝܼܬ ܠܹܗ ܟܠܵܝܗ‌ܝ ܐܲܢܹܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ܘܢܵܦܠܝܼ ܗܘܵܘ ܒܬܘܼܪܩܵܠܵܐ ܒܝܼܹܗ. ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܠܲܝܬ ܢܒ݂ܝܼܵܐ ܡܘܼܣܠܝܼܵܐ ܐܸܠܵܐ ܓܵܘ ܡܕܝܼܢ݇ܬܹܗ ܘܓܵܘ ܒܲܝܬܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ܘܠܵܐ ܥܒ݂ܝܼܕ ܠܹܗ ܬܵܡܵܐ ܚܲܝ̈ܠܹܐ ܓܘܼܪܹ̈ܐ ܪܵܒܵܐ ܒܘܼܬ ܠܲܝܬܵܝܘܼܬܵ‌ܐ ܕܗܲܝܡܵܢܘܼܬܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ܒܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ، ܫܡܝܼܥ ܠܹܗ ܗܹܪܘܿܕܸܣ ܛܸܛܪܲܪܟܵܐ ܒܘܼܬ ܫܘܼܠܵܢܹ̈ܐ ܕܝܼܫܘܿܥ، ");
INSERT INTO aii_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ܘܐܡܝܼܪܹܗ ܠܪܹ̈ܓܵܘܵܬܘܼܗ‌ܝ: ”ܐܵܗܵܐ ܝܠܹܗ ܝܘܿܚܲܢܵܢ ܡܲܥܡܕܵܢܵܐ ܕܩܝܼܡܵܐ ܝܠܹܗ ܡ̣ܢ ܓܵܘ ܡܝܼ̈ܬܹ‌ܐ، ܒܘܼܬ ܐܵܗܵܐ ܚܲܝ̈ܠܹܐ ܓܘܼܪܹ̈ܐ ܦܝܵܫܵܐ ܝܢܵܐ ܥܒ݂ܝܼܕܹܐ ܒܝܼܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ܣܵܒܵܒ ܗܹܪܘܿܕܸܣ ܕܒ݂ܝܼܩܵܐ ܝܗܘܵܐ ܠܝܘܿܚܲܢܵܢ، ܐܣܝܼܪܹܗ ܘܕܸܪܝܹܗ ܓܵܘ ܒܹܝܬ ܐܲܣܝܼܪܹ̈ܐ ܒܘܼܬ ܗܹܪܘܿܕܝܼܵܐ، ܒܲܟ݂ܬܵ‌ܐ ܕܦܝܼܠܝܼܦܘܿܣ ܐܲܚܘܿܢܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ܣܵܒܵܒ ܐܡܝܼܪܵܐ ܝܗܘܵܐ ܐܸܠܹܗ ܝܘܿܚܲܢܵܢ: ”ܠܹܐ ܝܠܵܗ̇ ܩܵܢܘܿܢܵܝܬܵ‌ܐ ܕܫܵܩܠܹܬ ܠܵܗ̇ ܐܸܠܘܼܟ݂ ܒܲܟ݂ܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ܘܒܵܥܹܐ ܗܘܵܐ ܗܹܪܘܿܕܸܣ ܕܩܵܛܹܠܔ ܗܘܵܐ ܠܝܘܿܚܲܢܵܢ، ܐܝܼܢܵܐ ܟܹܐ ܙܵܕܹܥ ܗܘܵܐ ܡ̣ܢ ܟܸܢܫܵܐ ܣܵܒܵܒ ܐܲܝܟ݂ ܢܒ݂ܝܼܵܐ ܟܹܐ ܚܵܫܒ݂ܝܼ ܗܘܵܘ ܠܝܘܿܚܲܢܵܢ. ");
INSERT INTO aii_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ܐܝܼܢܵܐ ܐܝܼܡܲܢ ܕܗܘܹܐ ܠܹܗ ܒܹܝܬ ܝܲܠܕܵܐ ܕܗܹܪܘܿܕܸܣ، ܪܩܝܼܕ ܠܵܗ̇ ܒܪܵܬܵ‌ܐ ܕܗܹܪܘܿܕܝܼܵܐ ܩܲܕܡ ܐܵܢܝܼ ܕܝܬܝܼܒܹܐ ܝܗܘܵܘ، ܘܒܣܝܼܡ ܠܵܗ̇ ܠܹܗ ܗܹܪܘܿܕܸܣ ܒܝܼܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ܘܩܘܼܘܸܠܔ ܠܹܗ ܒܡܵܘܡܵܬܹ̈‌ܐ ܕܒܸܬ ܝܵܗܒܹܠܔ ܠܵܗ̇ ܟܠܔ ܡܸܢܕܝܼ ܕܛܵܠܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ܘܗ̇ܝ، ܟܲܕ ܡ̣ܢ ܩܲܕܡ ܥܕܵܢܵܐ ܦܝܼܫܬܵ‌ܐ ܝܗܘܵܐ ܡܘܼܠܸܦܬܵ‌ܐ ܒܝܲܕ ܝܸܡܘܼܗ̇، ܐܡܝܼܪܵܗ̇: ”ܗܲܒ݂ܠܔ ܠܝܼ ܐܵܕܝܼܵܐ ܠܲܐܟ݂ܵܐ ܓܵܘ ܡܵܐܢܵܐ ܪܹܝܫܵܐ ܕܝܘܿܚܲܢܵܢ ܡܲܥܡܕܵܢܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ܦܫܝܼܡ ܠܹܗ ܡܲܠܟܵܐ، ܐܝܼܢܵܐ ܒܘܼܬ ܡܵܘܡܵܬܹ̈‌ܐ، ܘܒܘܼܬ ܐܵܢܝܼ ܕܝܬܝܼܒܹܐ ܝܗܘܵܘ، ܦܩܝܼܕ ܠܹܗ ܕܦܵܐܹܫ ܝܘܼܗܒ݂ܵܐ ܐܸܠܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ܫܘܼܕܸܪܹܗ ܘܡܘܼܦܪܸܡ ܠܹܗ ܪܹܝܫܵܐ ܕܝܘܿܚܲܢܵܢ ܓܵܘ ܒܹܝܬ ܐܲܣܝܼܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ܘܦܝܼܫ ܠܹܗ ܡܘܼܬܝܵܐ ܪܹܝܫܹܗ ܓܵܘ ܡܵܐܢܵܐ، ܘܦܝܼܫ ܠܹܗ ܝܘܼܗܒ݂ܵܐ ܠܒܪܵܬܵ‌ܐ، ܘܗ̇ܝ ܡܘܼܝܬܹ‌ܐ ܠܵܗ̇ ܩܵܐ ܝܸܡܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ܐܬܹ‌ܐ ܠܗܘܿܢ ܬܲܠܡܝܼ̈ܕܹܐ ܕܝܘܿܚܲܢܵܢ ܘܫܩܝܼܠܔ ܠܗܘܿܢ ܠܫܠܲܕܹܗ ܘܩܒ݂ܝܼܪܵܐ ܠܗܘܿܢ، ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܡܘܼܚܒܸܪܗܘܿܢ ܠܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܹܗ ܝܼܫܘܿܥ ܒܘܼܬ ܝܘܿܚܲܢܵܢ، ܒܢܲܦ̮ܫܹܗ ܫܘܼܢܹܐ ܠܹܗ ܒܓܵܡܝܼ ܠܕܘܼܟܵܐ ܐܚܹܪܬܵ‌ܐ. ܘܟܲܕ ܫܡܝܼܥ ܠܗܘܿܢ ܟܸܢܫܹ̈ܐ ܕܐܲܝܟܵܐ ܝܗܘܵܐ، ܐܙܝܼܠܔ ܠܗܘܿܢ ܒܵܬܪܹܗ ܒܐܲܩܠܵܝܗ‌ܝ ܡ̣ܢ ܡܕܝܼܢܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ܦܠܝܼܛ ܠܹܗ ܝܼܫܘܿܥ ܘܚܙܹܐ ܠܹܗ ܟܸܢܫܹ̈ܐ ܪܵܒܵܐ، ܘܪܘܼܚܸܡ ܠܹܗ ܥܲܠܵܝܗ‌ܝ، ܘܒܘܼܣܸܡ ܠܹܗ ܠܡܲܪ̈ܥܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ܘܟܲܕ ܗܘܹܐ ܠܹܗ ܪܲܡܫܵܐ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܐܡܝܼܪܗܘܿܢ ܠܝܼܫܘܿܥ: ”ܓܵܘ ܒܲܪܝܼܵܐ ܝܘܲܚ ܘܥܕܵܢܵܐ ܥܒ݂ܝܼܪܬܵ‌ܐ ܝܠܵܗ̇. ܫܪܝܼ ܠܟܸܢܫܹ̈ܐ ܕܐܵܙܠ݇ܝܼ ܠܡܵܬܘܵܬܹ̈‌ܐ، ܘܙܵܒ݂ܢܝܼ ܠܗܘܿܢ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܠܹܐ ܝܠܵܗ̇ ܣܢܝܼܩܬܵ‌ܐ ܕܐܵܙܠ݇ܝܼ، ܐܲܚܬܘܿܢ ܗܲܒ݂ܠܘܼܢ ܠܗܘܿܢ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ܐܵܢܝܼ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܐܸܠܹܗ: ”ܠܲܝܬ ܠܲܢ ܠܲܐܟ݂ܵܐ ܐܸܠܵܐ ܚܲܡܫܵܐ ܠܲܚܡܹ̈ܐ ܘܬܪܹܝ ܢܘܼܢܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܡܲܝܬܹܝܡܘܼܢ ܠܗܘܿܢ ܠܲܐܟ݂ܵܐ ܠܟܸܣܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ܘܦܩܝܼܕ ܠܹܗ ܠܟܸܢܫܹ̈ܐ ܕܝܵܬܒ݂ܝܼ ܗܘܵܘ ܥܲܠܔ ܓܸܠܵܐ. ܘܫܩܝܼܠܔ ܠܹܗ ܐܵܢܝܼ ܚܲܡܫܵܐ ܠܲܚܡܹ̈ܐ ܘܬܪܹܝ ܢܘܼܢܹ̈ܐ، ܘܚܝܼܪܹܗ ܠܫܡܲܝܵܐ، ܒܘܼܪܸܟ݂ ܠܹܗ، ܘܩܨܹܐ ܠܹܗ، ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ܘܬܲܠܡܝܼ̈ܕܹܐ ܝܘܼܗܒܹܠܔ ܠܗܘܿܢ ܠܟܸܢܫܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ܘܟܠܵܝܗ‌ܝ ܐܟ݂ܝܼܠܔ ܠܗܘܿܢ ܘܣܒ݂ܝܼܥ ܠܗܘܿܢ، ܘܫܩܝܼܠܔ ܠܗܘܿܢ ܩܸܛܥܵܛܹ̈ܐ ܕܙܝܼܕ ܠܗܘܿܢ، ܬܪܸܥܣܲܪ ܩܘܼܦܹ̈ܐ ܡܸܠܝܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ܐܵܢܝܼ ܕܐܟ݂ܝܼܠܔ ܠܗܘܿܢ ܐܲܝܟ݂ ܚܲܡܫܵܐ ܐܲܠܦܹ̈ܐ ܐܢܵܫܹ̈ܐ ܝܗܘܵܘ، ܫܒ݂ܘܿܩ ܡ̣ܢ ܒܲܟ݂ܬܵܬܹ̈‌ܐ ܘܝܲܠܘܼܕܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ܗ̇ܝ ܓܵܗܵܐ ܦܩܝܼܕ ܠܹܗ ܝܼܫܘܿܥ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܕܐܵܣܩܝܼ ܗܘܵܘ ܓܵܘ ܓܵܡܝܼ ܘܐܵܙܠ݇ܝܼ ܗܘܵܘ ܡ̣ܢ ܩܲܕܡ ܕܝܼܹܗ ܠܗ̇ܘ ܡܲܪܙܵܐ ܐܚܹܪܢܵܐ، ܟܲܕ ܗ̇ܘ ܡܲܦܫܸܛ ܗܘܵܐ ܠܟܸܢܫܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ܐܝܼܡܲܢ ܕܫܘܼܕܸܪܹܗ ܠܟܸܢܫܹ̈ܐ، ܐܣܝܼܩ ܠܹܗ ܠܛܘܼܪܵܐ ܒܢܲܦ̮ܫܹܗ ܠܨܲܠܘܼܝܹܐ. ܘܗܘܹܐ ܠܹܗ ܚܸܫܟܵܐ ܘܗܸܫ ܗ̇ܘ ܬܵܡܵܐ ܒܢܲܦ̮ܫܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ܘܓܵܡܝܼ ܪܵܒܵܐ ܪܸܚܩܵܐ ܝܗܘܵܐ ܡ̣ܢ ܒܸܪܙܵܐ ܘܦܝܵܫܵܐ ܡܘܼܫܥܸܫܬܵ‌ܐ ܪܵܒܵܐ ܒܝܲܕ ܠܲܦܹ̈ܐ، ܣܵܒܵܒ ܦܵܘܚܵܐ ܠܒܲܠܩܘܼܒ݂ܠܘܼܗ̇ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ܡܐܲܝܟ݂ ܣܵܥܲܬ ܕܐܸܫܸܬ ܩܲܝܕܵܡܬܵ‌ܐ ܐܙܝܼܠܔ ܠܹܗ ܝܼܫܘܿܥ ܠܟܸܣܠܵܝܗ‌ܝ ܒܸܚܕܵܪܵܐ ܥܲܠܔ ܡ̈ܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܗܘܿܢ ܐܸܠܹܗ ܬܲܠܡܝܼ̈ܕܹܐ ܒܸܚܕܵܪܵܐ ܥܲܠܔ ܡ̈ܝܼܵܐ، ܡ̣ܢ ܙܕܘܼܥܬܵܝܗ‌ܝ ܫܓ݂ܝܼܫ ܠܗܘܿܢ ܘܡܘܼܩܘܸܚ ܠܗܘܿܢ: ”ܚܸܙܘܵܐ ܝܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܗܘܹܝܡܘܼܢ ܠܸܒܵܢܹ̈ܐ، ܐܵܢܵܐ ܝܘܸܢ، ܠܵܐ ܙܵܕܥܝܼܬܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ: ”ܡܵܪܝܼ، ܐܸܢ ܐܲܢ݇ܬ ܝܼܘܸܬ، ܦܩܘܿܕ ܠܝܼ ܕܐܵܬܹܝܢ ܠܟܸܣܠܘܼܟ݂ ܥܲܠܔ ܡ̈ܝܼܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܬܵ‌ܐ.“ ܘܨܠܹܐ ܠܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܡ̣ܢ ܓܵܡܝܼ ܒܸܚܕܵܪܵܐ ܥܲܠܔ ܡ̈ܝܼܵܐ، ܕܐܵܬܹ‌ܐ ܠܟܸܣ ܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ܘܟܲܕ ܚܙܹܐ ܠܹܗ ܦܵܘܚܵܐ ܚܲܝܠܵܢܵܐ، ܙܕܝܼܥ ܠܹܗ، ܘܫܘܼܪܹܐ ܠܹܗ ܠܸܛܒܵܥܵܐ، ܘܡܘܼܩܘܸܚ ܠܹܗ: ”ܡܵܪܝܼ، ܦܲܪܸܩ ܠܝܼ،“ ");
INSERT INTO aii_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܦܘܼܫܛܵܐ ܠܹܗ ܐܝܼܕܹܗ ܝܼܫܘܿܥ ܘܕܒ݂ܝܼܩ ܠܹܗ ܒܝܼܹܗ ܘܐܡܝܼܪܹܗ: ”ܝܵܐ ܒܵܨܘܿܪܵܐ ܕܗܲܝܡܵܢܘܼܬܵ‌ܐ، ܩܵܡܘܿܕܝܼ ܦܝܼܫ ܠܘܼܟ݂ ܒܫܸܟ؟“ ");
INSERT INTO aii_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ܘܟܲܕ ܥܒ݂ܝܼܪܹܗ ܓܵܘ ܓܵܡܝܼ، ܫܠܹܐ ܠܹܗ ܦܵܘܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ܘܐܵܢܝܼ ܕܝܼܗܘܵܘ ܓܵܘ ܓܵܡܝܼ ܣܓ݂ܝܼܕ ܠܗܘܿܢ ܐܸܠܹܗ، ܘܐܡܝܼܪܗܘܿܢ: ”ܫܲܪܝܼܪܵܐܝܼܬ ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ ܝܘܸܬ.“ ");
INSERT INTO aii_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ܥܒ݂ܝܼܪܗܘܿܢ ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܠܐܲܪܥܵܐ ܕܓܹܢܹܣܲܪ. ");
INSERT INTO aii_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܗܘܿܢ ܒܘܼܬ ܕܝܼܹܗ ܐܢܵܫܹ̈ܐ ܕܗ̇ܝ ܕܘܼܟܵܐ، ܫܘܼܕܸܪܗܘܿܢ ܘܡܘܼܚܒܸܪܗܘܿܢ ܠܟܠܵܝܗ‌ܝ ܡܵܬܘܵܬܹ̈‌ܐ ܕܚܵܕܸܪ̈ܘܵܢܵܝܗ‌ܝ، ܘܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܡܪ̈ܝܼܥܹܐ ܝܗܘܵܘ. ");
INSERT INTO aii_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ܘܦܘܼܪܦܸܠܔ ܠܗܘܿܢ ܒܝܼܹܗ ܕܕܵܩܪܝܼ ܐܲܚܟ̰ܝܼ ܒܫܸܦܘܼܠܵܐ ܕܠܒ݂ܝܼܫܬܹܗ. ܘܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܕܩܝܼܪܗܘܿܢ، ܒܣܝܼܡ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ܗ̇ܝܓܵܗ ܐܬܹ‌ܐ ܠܗܘܿܢ ܣܵܦܪܹ̈ܐ ܘܦܪ̈ܝܼܫܹܐ ܡ̣ܢ ܐܘܿܪܸܫܠܸܡ ܠܟܸܣ ܝܼܫܘܿܥ ܘܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ: ");
INSERT INTO aii_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","”ܩܵܡܘܿܕܝܼ ܬܲܠܡܝܼܕܘܼ̈ܟ݂ ܒܸܫܡܵܛܵܐ ܝܢܵܐ ܠܣܲܦܝܵܢܘܼܝܵܬܹ̈‌ܐ ܕܚܘܵܪ̈ܕܸܩܢܹܐ؟ ܣܵܒܵܒ ܠܹܐ ܝܢܵܐ ܚܲܠܘܼܠܹܐ ܐܝܼܕܵܬܵܝ̈ܗ‌ܝ ܡ̣ܢ ܩܲܕܡ ܕܐܵܟ݂ܠܝܼ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܩܵܡܘܿܕܝܼ ܐܘܼܦ ܐܲܚܬܘܿܢ ܒܸܫܡܵܛܵܐ ܝܬܘܿܢ ܦܘܼܩܕܵܢܵܐ ܕܐܲܠܵܗܵܐ ܒܝܲܕ ܣܲܦܝܵܢܘܼܬܵܘܟ݂ܘܿܢ؟ ");
INSERT INTO aii_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","”ܣܵܒܵܒ ܐܲܠܵܗܵܐ ܦܩܝܼܕ ܠܹܗ: ’ܡܝܲܩܸܪ ܠܒܵܒܘܼܟ݂ ܘܠܝܸܡܘܼܟ݂، ܘܡ̇ܢ ܕܨܲܥܸܪ ܠܒܵܒܘܼܗ‌ܝ ܝܲܢ ܠܝܸܡܹܗ، ܡܵܘܬܵ‌ܐ ܡܵܐܹܬ.‘ ");
INSERT INTO aii_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","”ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ ܟܹܐ ܐܵܡܪܝܼܬܘܿܢ ܟܠܔ ܡ̇ܢ ܕܐܵܡܹܪ ܠܒܵܒܘܼܗ‌ܝ ܝܲܢ ܠܝܸܡܹܗ: ’ܡܸܢܕܝܼ ܕܗܵܘܹܐ ܝܘܼܬܪܵܢܵܐ ܐܸܠܘܼܟ݂، ܢܸܕܪܵܐ ܝܠܹܗ ܡܸܢܝܼ ܩܵܐ ܐܲܠܵܗܵܐ،‘ ܠܹܐ ܝܠܵܗ̇ ܐܵܢܲܢܩܵܝܬܵ‌ܐ ܕܡܝܲܩܸܪ ܠܒܵܒܘܼܗ‌ܝ ܝܲܢ ܠܝܸܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","”ܒܘܼܛܸܠܔ ܠܵܘܟ݂ܘܿܢ ܗܹܡܸܙܡܵܢ ܕܐܲܠܵܗܵܐ ܒܝܲܕ ܣܲܦܝܵܢܘܼܬܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","”ܝܵܐ ܡܲܫܦܸܪ̈ܵܢܹܐ، ܨܦܵܝܝܼ ܢܘܼܒܹܐ ܠܹܗ ܒܘܼܬ ܕܝܼܵܘܟ݂ܘܿܢ ܐܹܫܲܥܝܵܐ ܢܒ݂ܝܼܵܐ ܒܹܐܡܵܪܵܐ: ");
INSERT INTO aii_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ܐܵܗܵܐ ܥܲܡܵܐ ܒܣܸܦܘܵܬܘܼ̈ܗ‌ܝ ܟܹܐ ܡܝܲܩܸܪ ܐܸܠܝܼ، ܐܝܼܢܵܐ ܠܸܒܹܗ ܪܸܚܩܵܐ ܝܠܹܗ ܡܸܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ܘܣܪܝܼܩܵܐܝܼܬ ܒܸܣܓ݂ܵܕܵܐ ܝܢܵܐ ܐܸܠܝܼ، ܡܲܠܘܼܦܹܐ ܝܢܵܐ ܝܘܼܠܦܵܢܹ̈ܐ ܕܦܘܼܩܕܵܢܹ̈ܐ ܕܒܢܲܝ̈ܢܵܫܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ܘܩܪܹܐ ܠܹܗ ܠܟܸܢܫܹ̈ܐ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܫܡܹܥܡܘܼܢ ܘܦܲܪܡܹܝܡܘܼܢ، ");
INSERT INTO aii_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","”ܡܸܢܕܝܼ ܕܥܵܒܹܪ ܠܦܘܼܡܵܐ ܠܹܐ ܟ̰ܲܦܠܸܢ ܠܒܲܪܢܵܫܵܐ، ܐܸܠܵܐ ܡܸܢܕܝܼ ܕܦܵܠܹܛ ܡ̣ܢ ܦܘܼܡܵܐ، ܗ̇ܘ ܟܹܐ ܟ̰ܲܦܠܸܢ ܠܒܲܪܢܵܫܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ܗ̇ܝܓܵܗ ܐܬܹ‌ܐ ܠܗܘܿܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܠܟܸܣܠܹܗ ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܒܝܼܕܵܥܵܐ ܝܘܸܬ ܕܟܪܝܼܒ ܠܗܘܿܢ ܦܪ̈ܝܼܫܹܐ ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܗܘܿܢ ܐܵܗܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ܐܝܼܢܵܐ ܗ̇ܘ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܟܠܔ ܢܨܝܼܒ݂ܬܵ‌ܐ ܕܠܵܐ ܢܨܝܼܒ݂ܵܐ ܠܹܗ ܒܵܒܝܼ ܕܒܫܡܲܝܵܐ ܒܸܬ ܦܵܝܫܵܐ ܥܩܝܼܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","”ܫܒ݂ܘܿܩܘܼܢ ܠܗܘܿܢ، ܣܸܡܝܹ̈ܐ ܝܢܵܐ ܘܡܗܲܕܝܵܢܹ̈ܐ ܕܣܸܡܝܹ̈ܐ. ܘܐܸܢ ܣܸܡܝܵܐ ܠܣܸܡܝܵܐ ܡܗܲܕܹܐ، ܬܸܪܘܵܝ ܒܓܘܼܒܵܐ ܒܸܬ ܢܵܦܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ܗ̇ܝܓܵܗ ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ: ”ܡܵܪܝܼ، ܦܲܫܸܩ ܠܲܢ ܐܵܗܵܐ ܡܲܬܠܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ: ”ܐܘܼܦ ܐܲܚܬܘܿܢ ܗܸܫ ܕܠܵܐ ܦܲܪܡܲܝܬܵ‌ܐ ܝܬܘܿܢ؟ ");
INSERT INTO aii_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","”ܠܹܐ ܝܵܕܥܝܼܬܘܿܢ، ܡܸܢܕܝܼ ܕܥܵܒܹܪ ܠܦܘܼܡܵܐ ܟܹܐ ܐܵܙܹܠܔ ܠܟܹܪ݇ܣܵܐ، ܘܡ̣ܢ ܬܵܡܵܐ ܟܹܐ ܦܵܐܹܫ ܪܘܼܦܝܵܐ ܠܒܲܕܲܪ؟ ");
INSERT INTO aii_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","”ܐܝܼܢܵܐ ܡܸܢܕܝܼ ܕܦܵܠܹܛ ܡ̣ܢ ܦܘܼܡܵܐ ܟܹܐ ܐܵܬܹ‌ܐ ܡ̣ܢ ܠܸܒܵܐ، ܗ̇ܘ ܟܹܐ ܟ̰ܲܦܠܸܢ ܠܒܲܪܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","”ܣܵܒܵܒ ܡ̣ܢ ܠܸܒܵܐ ܟܹܐ ܦܵܠܛܝܼ ܚܘܼܫܵܒܹ̈ܐ ܒܝܼܫܹ̈ܐ: ܩܸܛܠܹ̈ܐ، ܓܲܝܵܪܘܼܬܵ‌ܐ، ܙܵܢܝܘܼܬܵ‌ܐ، ܣܵܗܕܘܼܬܵ‌ܐ ܕܕܘܼܓܠܵܐ، ܓܹܢܵܒ݂ܘܼܬܵ‌ܐ، ܘܓܘܼܕܵܦܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","”ܐܲܢܹܐ ܝܢܵܐ ܕܟܹܐ ܟ̰ܲܦܠܸܢܝܼ ܠܒܲܪܢܵܫܵܐ. ܐܝܼܢܵܐ ܐܟ݂ܵܠܬܵ‌ܐ ܒܐܝܼܕܵܬܹ̈‌ܐ ܠܵܐ ܚܘܼܠܸܠܹܐ ܠܹܐ ܟ̰ܲܦܠܸܢܵܐ ܠܒܲܪܢܵܫܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ܘܦܠܝܼܛ ܠܹܗ ܡ̣ܢ ܬܵܡܵܐ ܝܼܫܘܿܥ ܘܐܬܹ‌ܐ ܠܹܗ ܠܬܚܘܼܡܵܐ ܕܨܘܿܪ ܘܨܲܝܕܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ܘܗܵܐ ܚܕܵܐ ܒܲܟ݂ܬܵ‌ܐ ܟܢܲܥܢܵܝܬܵ‌ܐ ܐܬܹ‌ܐ ܠܵܗ̇ ܡ̣ܢ ܐܵܢܝܼ ܬܚܘܼܡܹ̈ܐ، ܡܲܩܘܘܼܚܹܐ، ܘܒܹܐܡܵܪܵܐ: ”ܪܲܚܸܡ ܥܲܠܝܼ ܡܵܪܝܼ، ܒܪܘܿܢܵܐ ܕܕܵܘܝܼܕ، ܒܪܵܬ‌ܝܼ ܚܸܪܒܵܐ ܦܝܵܫܵܐ ܝܠܵܗ̇ ܓ̰ܘܼܢܓ̰ܸܪܬܵ‌ܐ ܒܫܹܐܕܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ܐܝܼܢܵܐ ܗ̇ܘ ܠܵܐ ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܘܼܗ̇ ܐܘܼܦ ܚܲܕ ܚܲܒܪܵܐ. ܘܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܫܲܕܸܪܵܗ̇، ܡܲܩܘܘܼܚܹܐ ܠܵܗ̇ ܒܵܬܪܲܢ.“ ");
INSERT INTO aii_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ: ”ܠܵܐ ܦܝܼܫ ܠܝܼ ܫܘܼܕܪܵܐ ܐܸܠܵܐ ܩܵܐ ܥܸܪ̈ܒܹܐ ܛܠܝܼܩܹ̈ܐ ܕܒܢܲܝ̈ ܐܝܼܣܪܵܐܹܝܠܔ.“ ");
INSERT INTO aii_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ܐܝܼܢܵܐ ܗ̇ܝ ܒܲܟ݂ܬܵ‌ܐ ܐܬܹ‌ܐ ܠܵܗ̇، ܣܓ݂ܝܼܕ ܠܵܗ̇ ܐܸܠܹܗ ܒܹܐܡܵܪܵܐ: ”ܡܵܪܝܼ، ܗܲܝܸܪܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ܐܝܼܢܵܐ ܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ ܘܐܡܝܼܪܹܗ: ”ܠܹܐ ܝܠܵܗ̇ ܚܫܝܼܚܬܵ‌ܐ ܠܸܫܩܵܠܵܐ ܠܲܚܡܵܐ ܕܒܢܘܿܢܹ̈ܐ ܘܠܝܼܵܗܒܹܗ ܠܟܲܠܒܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ܘܗ̇ܝ ܓ̰ܘܼܘܸܒ ܠܵܗ̇: ”ܗܹܐ ܡܵܪܝܼ، ܐܝܼܢܵܐ ܐܘܼܦ ܟܲܠܒܹ̈ܐ ܟܹܐ ܐܵܟ݂ܠܝܼ ܡ̣ܢ ܦܸܪ̈ܬܘܼܚܹܐ ܕܢܵܦܠܝܼ ܡ̣ܢ ܦܵܬܘܿܪܹ̈ܐ ܕܡܵܪ̈ܵܘܵܬܵܝܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ܗ̇ܝܓܵܗ ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇: ”ܒܲܟ݂ܬܵ‌ܐ، ܓܘܼܪܬܵ‌ܐ ܝܠܵܗ̇ ܗܲܝܡܵܢܘܼܬܵܟ݂ܝ، ܗܵܘܹܐ ܠܵܟ݂ܝ ܐܲܝܟ݂ ܕܒܵܥܝܲܬ‌ܝ.“ ܘܒܣܝܼܡ ܠܵܗ̇ ܒܪܵܬܘܼܗ̇ ܡ̣ܢ ܗ̇ܝ ܣܵܥܲܬ. ");
INSERT INTO aii_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ܫܘܼܢܹܐ ܠܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܗ̇ܝ ܕܘܼܟܵܐ ܕܝܼܗܘܵܐ ܘܐܬܹ‌ܐ ܠܹܗ ܠܡܲܪܙܵܐ ܕܝܵܡܵܐ ܕܓܠܝܼܠܵܐ، ܐܣܝܼܩ ܠܹܗ ܠܛܘܼܪܵܐ، ܘܝܬܝܼܒ݂ ܠܹܗ ܬܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ܘܟܸܢܫܹ̈ܐ ܪܵܒܵܐ ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ، ܘܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܥܲܡܵܝܗ‌ܝ ܫܦܝܼܠܹ̈ܐ ܘܫܸܠܹ̈ܐ ܘܣܸܡܝܹ̈ܐ ܘܚܲܪ̈ܫܹܐ، ܘܪܵܒܵܐ ܐܚܹܪ̈ܢܹܐ، ܘܡܘܼܬܒ݂ܵܝ ܠܗܘܿܢ ܩܲܕܡ ܐܲܩܠܵܬܹ̈‌ܐ ܕܝܼܫܘܿܥ ܘܒܘܼܣܡܵܝ ܠܹܗ، ");
INSERT INTO aii_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ܗܵܕܟ݂ܵܐ ܕܥܲܓ̰ܒܝܼ ܗܘܵܘ ܟܸܢܫܹ̈ܐ، ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܗܘܿܢ ܚܲܪ̈ܫܹܐ ܗܲܡܙܘܼܡܹܐ، ܘܫܸܠܹ̈ܐ ܦܝܵܫܵܐ ܒܘܼܣܡܹܐ، ܘܫܦܝܼܠܹ̈ܐ ܒܸܚܕܵܪܵܐ، ܘܣܸܡܝܹ̈ܐ ܒܸܚܙܵܝܵܐ؛ ܫܘܼܒܸܚ ܠܗܘܿܢ ܠܐܲܠܵܗܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ܘܩܪܹܐ ܠܹܗ ܝܼܫܘܿܥ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܐܡܝܼܪܹܗ: ”ܒܸܬ ܪܲܚܡܸܢ ܥܲܠܔ ܐܲܢܹܐ ܟܸܢܫܹ̈ܐ، ܣܵܒܵܒ ܐܲܢܹܐ ܬܠܵܬܵ‌ܐ ܝܵܘܡܵܢܹ̈ܐ ܠܲܐܟ݂ܵܐ ܝܢܵܐ ܠܟܸܣܠܝܼ، ܘܠܲܝܬ ܠܗܘܿܢ ܡܸܢܕܝܼ ܕܐܵܟ݂ܠܝܼ، ܘܠܹܐ ܒܵܥܹܝܢ ܕܫܲܕܪܸܢܗܘܿܢ ܟܦܝܼܢܹܐ، ܕܠܵܐ ܫܲܡܫܸܡܝܼ ܒܐܘܼܪܚܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܡ̣ܢ ܐܲܝܟܵܐ ܐܝܼܬ ܠܲܢ ܚܲܕ ܗܵܕܟ݂ܵܐ ܠܲܚܡܵܐ ܓܵܘ ܒܲܪܝܼܵܐ، ܕܡܲܣܒܸܥܲܚ ܚܲܕ ܗܵܕܟ݂ܵܐ ܟܸܢܫܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ܒܘܼܩܸܪܹܗ ܝܼܫܘܿܥ ܡܸܢܵܝܗ‌ܝ: ”ܟܡܵܐ ܠܲܚܡܹ̈ܐ ܐܝܼܬ ܠܵܘܟ݂ܘܿܢ؟“ ܘܐܵܢܝܼ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ: ”ܫܲܒ݂ܥܵܐ، ܘܚܲܕܟܡܵܐ ܢܘܼܢܹ̈ܐ ܙܥܘܿܪܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ܘܦܩܝܼܕ ܠܹܗ ܠܟܸܢܫܹ̈ܐ ܕܝܵܬܒ݂ܝܼ ܥܲܠܔ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ܘܫܩܝܼܠܔ ܠܹܗ ܠܫܲܒ݂ܥܵܐ ܠܲܚܡܹ̈ܐ ܥܲܡ ܢܘܼܢܹ̈ܐ ܘܒܘܼܪܸܟ݂ ܠܹܗ، ܘܩܨܹܐ ܠܹܗ، ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ܘܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܝܘܼܗܒܹܠܔ ܠܗܘܿܢ ܠܟܸܢܫܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ܐܟ݂ܝܼܠܔ ܠܗܘܿܢ ܟܠܵܝܗ‌ܝ ܘܣܒ݂ܝܼܥ ܠܗܘܿܢ، ܘܫܩܝܼܠܔ ܠܗܘܿܢ ܩܸܛܥܵܛܹ̈ܐ ܕܙܝܼܕ ܠܗܘܿܢ ܫܲܒ݂ܥܵܐ ܩܘܼܦܹ̈ܐ ܡܸܠܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ܘܐܵܢܝܼ ܕܐܟ݂ܝܼܠܔ ܠܗܘܿܢ ܐܲܪܒܥܵܐ ܐܲܠܦܹ̈ܐ ܐܢܵܫܹ̈ܐ ܝܗܘܵܘ ܫܒ݂ܘܿܩ ܡ̣ܢ ܒܲܟ݂ܬܵܬܹ̈‌ܐ ܘܝܲܠܘܼܕܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ܡ̣ܢ ܒܵܬܪ ܕܫܘܼܕܸܪܹܗ ܠܟܸܢܫܹ̈ܐ، ܐܣܝܼܩ ܠܹܗ ܠܓܵܡܝܼ ܘܐܬܹ‌ܐ ܠܹܗ ܠܬܚܘܼܡܹ̈ܐ ܕܡܲܓܹܕܘܿ. ");
INSERT INTO aii_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ܐܬܹ‌ܐ ܠܗܘܿܢ ܦܪ̈ܝܼܫܹܐ ܘܙܲܕܘܼܩܵܝܹ̈ܐ ܠܟܸܣ ܝܼܫܘܿܥ ܕܓ̰ܲܪܒܝܼ ܗܘܵܘ ܠܹܗ. ܛܠܝܼܒ ܠܗܘܿܢ ܡܸܢܹܗ ܕܡܲܚܙܹܐ ܠܗܘܿܢ ܢܝܼܫܲܢܩܵܐ ܡ̣ܢ ܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܐܝܼܡܲܢ ܕܝܼܠܹܗ ܪܲܡܫܵܐ، ܟܹܐ ܐܵܡܪܝܼܬܘܿܢ: ’ܨܸܚܘܵܐ ܝܠܵܗ̇ ܕܘܼܢܝܹܐ ܣܵܒܵܒ ܣܡܝܼܩ ܠܵܗ̇ ܫܡܲܝܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","”ܘܒܨܲܦܪܵܐ ܟܹܐ ܐܵܡܪܝܼܬܘܿܢ: ’ܐܸܕܝܘܿܡ ܗܵܘܵܐ ܕܒܘܼܪܲܢ ܝܼܠܹܗ، ܣܵܒܵܒ ܣܡܝܼܩ ܠܵܗ̇ ܫܡܲܝܵܐ ܘܚܘܼܫܟܸܢܵܗ̇.‘ ܝܵܐ ܡܲܫܦܸܪ̈ܵܢܹܐ، ܦܵܬܵ‌ܐ ܕܫܡܲܝܵܐ ܟܹܐ ܝܵܕܥܝܼܬܘܿܢ ܕܦܵܪܫܝܼܬܘܿܢ ܠܵܗ̇، ܐܝܼܢܵܐ ܢܝܼܫܲܢܩܹ̈ܐ ܕܐܵܗܵܐ ܙܲܒ݂ܢܵܐ ܠܹܐ ܡܵܨܹܝܬܘܿܢ ܦܵܪܫܝܼܬܘܿܢ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","”ܫܲܪܒܬܵ‌ܐ ܒܝܼܫܬܵ‌ܐ ܘܓܲܝܵܪܬܵ‌ܐ ܢܝܼܫܲܢܩܵܐ ܒܸܛܠܵܒܵܐ ܝܠܵܗ̇، ܘܢܝܼܫܲܢܩܵܐ ܠܹܐ ܦܵܐܹܫ ܝܘܼܗܒ݂ܵܐ ܐܸܠܘܼܗ̇ ܫܒ݂ܘܿܩ ܡ̣ܢ ܢܝܼܫܲܢܩܵܐ ܕܝܵܘܢܵܢ ܢܒ݂ܝܼܵܐ.“ ܘܫܒ݂ܝܼܩܵܝ ܠܹܗ ܘܐܙܝܼܠܔ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ܐܝܼܡܲܢ ܕܥܒ݂ܝܼܪܗܘܿܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܠܗ̇ܘ ܡܲܪܙܵܐ ܐܚܹܪܢܵܐ ܕܝܵܡܵܐ، ܡܘܼܢܫܹܐ ܠܗܘܿܢ ܕܫܵܩܠܝܼ ܗܘܵܘ ܠܲܚܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ܗ̇ܝܓܵܗ ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܗܘܹܝܡܘܼܢ ܗܸܫܝܲܪ ܡ̣ܢ ܚܡܝܼܪܵܐ ܕܦܪ̈ܝܼܫܹܐ ܘܕܙܲܕܘܼܩܵܝܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ܘܐܵܢܝܼ ܚܫܝܼܒ݂ ܠܗܘܿܢ ܒܓܵܢܵܝܗ‌ܝ ܘܐܡܝܼܪܗܘܿܢ: ”ܕܠܵܐ ܫܩܝܼܠܔ ܠܲܢ ܠܲܚܡܵܐ ܥܲܡܲܢ.“ ");
INSERT INTO aii_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܝܕܝܼܥ ܠܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܝܵܐ ܒܵܨܘܿܪܹ̈ܐ ܕܗܲܝܡܵܢܘܼܬܵ‌ܐ، ܩܵܡܘܿܕܝܼ ܒܸܚܫܵܒ݂ܵܐ ܝܬܘܿܢ ܒܓܵܢܵܘܟ݂ܘܿܢ ܕܠܲܚܡܵܐ ܠܵܐ ܫܩܝܼܠܔ ܠܵܘܟ݂ܘܿܢ؟ ");
INSERT INTO aii_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","”ܗܲܠܔ ܐܵܕܝܼܵܐ ܠܵܐ ܦܘܼܪܡܹܐ ܠܵܘܟ݂ܘܿܢ؟ ܠܹܐ ܝܬܘܿܢ ܒܸܕܟ݂ܵܪܵܐ ܠܐܵܢܝܼ ܚܲܡܫܵܐ ܠܲܚܡܹ̈ܐ ܘܚܲܡܫܵܐ ܐܲܠܦܹ̈ܐ ܐܢܵܫܹ̈ܐ، ܘܟܡܵܐ ܩܘܼܦܹ̈ܐ ܕܫܩܝܼܠܔ ܠܵܘܟ݂ܘܿܢ؟ ");
INSERT INTO aii_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","”ܘܠܐܵܢܝܼ ܫܲܒ݂ܥܵܐ ܠܲܚܡܹ̈ܐ ܘܐܲܪܒܥܵܐ ܐܲܠܦܹ̈ܐ ܐܢܵܫܹ̈ܐ، ܘܟܡܵܐ ܣܵܠܹ̈ܐ ܕܫܩܝܼܠܔ ܠܵܘܟ݂ܘܿܢ؟ ");
INSERT INTO aii_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","”ܕܵܐܟ݂ܝܼ ܠܵܐ ܦܘܼܪܡܹܐ ܠܵܘܟ݂ܘܿܢ ܕܠܹܐ ܝܗܘܵܐ ܒܘܼܬ ܠܲܚܡܵܐ ܐܡܝܼܪܝܼ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܝܼܢܵܐ ܕܗܵܘܹܝܬܘܿܢ ܗܸܫܝܲܪ ܡ̣ܢ ܚܡܝܼܪܵܐ ܕܦܪ̈ܝܼܫܹܐ ܘܕܙܲܕܘܼܩܵܝܹ̈ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ܗ̇ܝܓܵܗ ܦܘܼܪܡܹܐ ܠܗܘܿܢ ܬܲܠܡܝܼ̈ܕܹܐ ܕܠܵܐ ܐܡܝܼܪܹܗ ܕܗܵܘܝܼ ܗܸܫܝܲܪ ܡ̣ܢ ܚܡܝܼܪܵܐ ܕܠܲܚܡܵܐ، ܐܝܼܢܵܐ ܡ̣ܢ ܝܘܼܠܦܵܢܵܐ ܕܦܪ̈ܝܼܫܹܐ ܘܕܙܲܕܘܼܩܵܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ܟܲܕ ܐܬܹ‌ܐ ܠܹܗ ܝܼܫܘܿܥ ܠܬܚܘܼܡܹ̈ܐ ܕܩܹܣܲܪܝܵܐ ܕܦܝܼܠܝܼܦܘܿܣ، ܒܘܼܩܸܪܹܗ ܡ̣ܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܡܘܼܕܝܼ ܟܹܐ ܐܵܡܪܝܼ ܐܢܵܫܹ̈ܐ، ܕܡܵܢܝܼ ܝܠܹܗ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ܘܐܵܢܝܼ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ: ”ܚܲܕܟܡܵܐ ܟܹܐ ܐܵܡܪܝܼ، ܐܲܢ݇ܬ ܝܼܘܸܬ ܝܘܿܚܲܢܵܢ ܡܲܥܡܕܵܢܵܐ، ܘܚܲܕܟܡܵܐ ܟܹܐ ܐܵܡܪܝܼ، ܐܹܠܝܼܵܐ ܝܘܸܬ، ܘܚܲܕܟܡܵܐ ܟܹܐ ܐܵܡܪܝܼ ܐܹܪܲܡܝܵܐ ܝܘܸܬ، ܝܲܢ ܚܲܕ ܡ̣ܢ ܢܒ݂ܝܼܹ̈ܐ ܐܚܹܪ̈ܢܹܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ܐܝܼܢܵܐ ܗ̇ܘ ܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ: ”ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ ܡܵܢܝܼ ܒܹܐܡܵܪܵܐ ܝܬܘܿܢ ܕܝܼܘܸܢ؟“ ");
INSERT INTO aii_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ܓ̰ܘܼܘܸܒ ܠܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܘܐܡܝܼܪܹܗ: ”ܐܲܢ݇ܬ ܝܼܘܸܬ ܡܫܝܼܚܵܐ، ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ ܚܵܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܛܘܼܒ݂ܵܐ ܐܸܠܘܼܟ݂ ܫܸܡܥܘܿܢ، ܒܪܘܿܢܵܐ ܕܝܵܘܢܵܐ، ܣܵܒܵܒ ܒܸܣܪܵܐ ܘܕܸܡܵܐ ܠܵܐ ܓܠܹܐ ܠܹܗ ܐܸܠܘܼܟ݂ ܐܸܠܵܐ ܒܵܒܝܼ ܕܒܫܡܲܝܵܐ، ");
INSERT INTO aii_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","”ܘܐܵܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܘܼܟ݂، ܐܲܢ݇ܬ ܝܼܘܸܬ ܟܹܐܦܵܐ، ܘܥܲܠܔ ܐܵܗܵܐ ܟܹܐܦܵܐ ܒܸܬ ܒܵܢܹܢܵܗ̇ ܥܹܕܬ‌ܝܼ، ܘܬܲܪ̈ܥܵܢܹܐ ܕܫܝܘܿܠܔ ܠܹܐ ܟܵܠܝܼ ܩܲܕܡܘܼܗ̇، ");
INSERT INTO aii_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","”ܘܐܵܢܵܐ ܒܸܬ ܝܵܗܒܹܢܘܼܟ݂ ܩܕܝܼܠܹ̈ܐ ܕܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ، ܕܟܠܔ ܡܸܢܕܝܼ ܕܐܵܣܪܹܬ ܒܐܲܪܥܵܐ ܒܸܬ ܗܵܘܹܐ ܐܣܝܼܪܵܐ ܒܫܡܲܝܵܐ، ܘܟܠܔ ܡܸܢܕܝܼ ܕܫܵܪܹܝܬ ܒܐܲܪܥܵܐ ܒܸܬ ܗܵܘܹܐ ܫܸܪܝܵܐ ܒܫܡܲܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ܘܦܩܝܼܕ ܠܹܗ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܕܠܵܐ ܐܵܡܪܝܼ ܠܐܢܵܫܵܐ ܕܗ̇ܘ ܝܼܠܹܗ ܡܫܝܼܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ܡ̣ܢ ܗ̇ܝ ܥܕܵܢܵܐ ܫܘܼܪܹܐ ܠܹܗ ܝܼܫܘܿܥ ܠܡܲܕܘܼܥܹܐ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܕܵܐܟ݂ܝܼ ܘܵܠܹܐ ܝܗܘܵܐ ܕܐܵܙܹܠܔ ܠܐܘܿܪܸܫܠܸܡ ܘܩܲܒܸܠܔ ܪܵܒܵܐ ܚܲܫܵܐ ܡ̣ܢ ܚܘܵܪ̈ܕܸܩܢܹܐ ܘܡ̣ܢ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܣܵܦܪܹ̈ܐ، ܘܦܵܐܹܫ ܩܛܝܼܠܵܐ، ܘܒܝܵܘܡܵܐ ܕܬܠܵܬܵ‌ܐ ܩܵܐܹܡ. ");
INSERT INTO aii_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ܐܝܼܢܵܐ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܠܘܼܒܸܠܔ ܠܹܗ ܐܸܠܹܗ ܠܚܲܕ ܓܹܒܵܐ، ܘܫܘܼܪܹܐ ܠܹܗ ܠܡܲܢܟ݂ܘܼܣܹܗ ܘܒܹܐܡܵܪܵܐ: ”ܚܵܣ ܡܸܢܘܼܟ݂، ܡܵܪܝܼ، ܕܐܵܗܵܐ ܡܸܢܕܝܼ ܗܵܘܹܐ ܥܲܠܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ܐܝܼܢܵܐ ܗ̇ܘ ܕܝܼܪܹܗ ܘܐܡܝܼܪܹܗ ܠܫܸܡܥܘܿܢ ܟܹܐܦܵܐ: ”ܙܹܠܔ݇ ܠܘܼܟ݂ ܠܒܵܬܪܵܐ ܣܵܛܵܢܵܐ، ܬܘܼܪܩܵܠܵܐ ܝܘܸܬ ܐܸܠܝܼ، ܣܵܒܵܒ ܠܹܐ ܝܘܸܬ ܬܲܚܡܘܼܢܹܐ ܒܘܼܬ ܡܸܢܕܝܼ ܕܝܼܠܹܗ ܕܐܲܠܵܗܵܐ ܐܸܠܵܐ ܕܒܢܲܝ̈ܢܵܫܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ܗ̇ܝܓܵܗ ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܡ̇ܢ ܕܒܵܥܹܐ ܐܵܬܹ‌ܐ ܒܵܬܪܝܼ، ܣܵܪܹܒ݂ ܠܓܵܢܹܗ، ܘܫܵܩܹܠܔ ܙܩܝܼܦܹܗ، ܘܐܵܬܹ‌ܐ ܒܵܬܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","”ܣܵܒܵܒ ܡ̇ܢ ܕܒܵܥܹܐ ܦܲܪܸܩ ܠܓܵܢܹܗ ܒܸܬ ܛܲܠܸܩ ܠܵܗ̇، ܘܡ̇ܢ ܕܛܲܠܸܩ ܠܓܵܢܹܗ ܒܘܼܬ ܕܝܼܝܼ ܒܸܬ ܡܲܫ݇ܟ̰ܸܚ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","”ܣܵܒܵܒ ܡܘܼܕܝܼ ܝܘܼܬܪܵܢܵܐ ܐܝܼܬ ܠܒܲܪܢܵܫܵܐ ܐܸܢ ܩܵܢܹܐ ܠܵܗ̇ ܟܠܵܗ̇ ܕܘܼܢܝܹܐ ܐܝܼܢܵܐ ܛܲܠܸܩ ܠܵܗ̇ ܓܵܢܹܗ؟ ܝܲܢ ܡܘܼܕܝܼ ܒܸܬ ܝܵܗܒܹܠܔ ܒܲܪܢܵܫܵܐ ܡܒܵܕܵܠܔ ܕܓܵܢܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","”ܒܸܬ ܐܵܬܹ‌ܐ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܫܘܼܒ݂ܚܵܐ ܕܒܵܒܘܼܗ‌ܝ ܥܲܡ ܡܲܠܲܐܟ݂ܘܼ̈ܗ‌ܝ، ܘܗ̇ܝܓܵܗ ܒܸܬ ܦܵܪܹܥ ܠܟܠܔ ܚܲܕ ܐܲܝܟ݂ ܦܘܼܠܚܵܢܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܝܼܬ ܐܢܵܫܹ̈ܐ ܟܸܠܝܹܐ ܠܲܐܟ݂ܵܐ ܕܠܹܐ ܚܵܙܝܼ ܡܵܘܬܵ‌ܐ ܗܲܠܔ ܕܚܵܙܝܼ ܠܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܹܐܬܵܝܵܐ ܒܡܲܠܟܘܼܬܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ܡ̣ܢ ܒܵܬܪ ܫܬܵ‌ܐ ܝܵܘܡܵܢܹ̈ܐ، ܠܘܼܒܸܠܔ ܠܹܗ ܝܼܫܘܿܥ ܥܲܡܹܗ ܠܫܸܡܥܘܿܢ ܟܹܐܦܵܐ، ܘܠܝܲܥܩܘܿܒ݂، ܘܠܝܘܿܚܲܢܵܢ ܐܲܚܘܿܢܵܐ ܕܝܲܥܩܘܿܒ݂، ܘܐܣܝܼܩ ܠܗܘܿܢ ܠܛܘܼܪܵܐ ܪܵܡܵܐ ܒܢܲܦ̮ܫܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ܦܝܼܫ ܠܹܗ ܫܘܼܚܠܸܦܵܐ ܩܲܕܡܵܝܗ‌ܝ. ܦܵܬܹܗ ܒܘܼܗܪܸܢܵܗ̇ ܐܲܝܟ݂ ܫܸܡܫܵܐ، ܘܠܒ݂ܝܼܫܬܹܗ ܡܘܼܚܘܸܪܵܗ̇ ܐܲܝܟ݂ ܢܘܼܗܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ܘܗܵܐ ܦܝܼܫ ܠܗܘܿܢ ܚܸܙܝܹܐ ܐܸܠܵܝܗ‌ܝ ܡܘܼܫܹܐ ܘܐܹܠܝܼܵܐ ܗܲܡܙܘܼܡܹܐ ܥܲܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ܘܐܡܝܼܪܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܠܝܼܫܘܿܥ: ”ܡܵܪܝܼ، ܨܦܵܝܝܼ ܝܠܵܗ̇ ܐܸܠܲܢ ܕܦܵܝܫܲܚ ܠܲܐܟ݂ܵܐ، ܘܐܸܢ ܐܲܢ݇ܬ ܒܵܥܹܝܬ، ܒܸܬ ܥܵܒ݂ܕܹܢ ܬܠܵܬ ܡܛܲܠܠܹ̈ܐ، ܚܕܵܐ ܩܵܬܘܼܟ݂، ܘܚܕܵܐ ܩܵܐ ܡܘܼܫܹܐ ܘܚܕܵܐ ܩܵܐ ܐܹܠܝܼܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ܘܟܲܕ ܗ̇ܘ ܗܲܡܙܘܼܡܹܐ، ܗܵܐ ܥܢܵܢܵܐ ܒܲܗܪܵܢܬܵ‌ܐ ܥܒ݂ܝܼܕ ܠܵܗ̇ ܛܸܠܵܢܝܼܬܵ‌ܐ ܥܲܠܵܝܗ‌ܝ، ܘܗܵܐ ܩܵܠܵܐ ܡ̣ܢ ܓܵܘ ܥܢܵܢܵܐ ܐܬܹ‌ܐ ܠܹܗ ܒܹܐܡܵܪܵܐ: ”ܐܵܗܵܐ ܝܠܹܗ ܒܪܘܿܢܝܼ ܡܘܼܚܸܒܵܐ ܕܒܝܼܹܗ ܒܣܝܼܡ ܠܵܗ̇ ܠܝܼ، ܐܸܠܹܗ ܫܡܹܥܡܘܼܢ.“ ");
INSERT INTO aii_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܗܘܿܢ ܬܲܠܡܝܼ̈ܕܹܐ، ܢܦܝܼܠܔ ܠܗܘܿܢ ܥܲܠܔ ܦܵܬܘܵܬܵܝ̈ܗ‌ܝ ܘܙܕܝܼܥ ܠܗܘܿܢ ܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܐܬܹ‌ܐ ܠܹܗ ܘܕܩܝܼܪܹܗ ܒܝܼܵܝܗ‌ܝ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܩܘܼܡܘܼܢ، ܠܵܐ ܙܵܕܥܝܼܬܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ܐܝܼܡܲܢ ܕܡܘܼܪܸܡ ܠܗܘܿܢ ܥܲܝ̈ܢܵܝܗ‌ܝ، ܠܵܐ ܚܙܹܐ ܠܗܘܿܢ ܐܢܵܫܵܐ ܐܸܠܵܐ ܝܼܫܘܿܥ ܒܢܲܦ̮ܫܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ܘܟܲܕ ܒܸܨܠܵܝܵܐ ܝܗܘܵܘ ܡ̣ܢ ܛܘܼܪܵܐ، ܦܩܝܼܕܵܝ ܠܹܗ ܝܼܫܘܿܥ ܕܠܐܢܵܫܵܐ ܠܵܐ ܐܵܡܪܝܼ ܡܸܢܕܝܼ ܒܘܼܬ ܐܵܗܵܐ ܚܸܙܘܵܐ ܗܲܠܔ ܕܩܵܐܹܡ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܡ̣ܢ ܓܵܘ ܡܝܼ̈ܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܐܡܝܼܪܗܘܿܢ: ”ܩܵܡܘܿܕܝܼ ܣܵܦܪܹ̈ܐ ܟܹܐ ܐܵܡܪܝܼ ܕܐܹܠܝܼܵܐ ܘܵܠܹܐ ܝܠܵܗ̇ ܕܐܵܬܹ‌ܐ ܩܲܕܡܵܝܬܵ‌ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܐܹܠܝܼܵܐ ܒܹܐܬܵܝܵܐ ܝܠܹܗ ܩܲܕܡܵܝܬܵ‌ܐ ܕܡܲܕܸܪ ܡܸܢܕܪܸܫ ܟܠܵܝܗ‌ܝ ܡܸܢܕܝܼܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","”ܐܝܼܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܐܹܠܝܼܵܐ ܐܬܝܼܵܐ ܝܠܹܗ، ܘܐܢܵܫܹ̈ܐ ܠܵܐ ܝܕܝܼܥ ܠܗܘܿܢ ܐܸܠܹܗ، ܘܥܒ݂ܝܼܕ ܠܗܘܿܢ ܒܝܼܹܗ ܡܸܢܕܝܼ ܕܒܣܝܼܡ ܠܵܗ̇ ܠܗܘܿܢ، ܘܗܵܕܟ݂ܵܐ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܸܬ ܩܲܒܸܠܔ ܚܲܫܵܐ ܡܸܢܵܝܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ܗ̇ܝܓܵܗ ܦܘܼܪܡܹܐ ܠܗܘܿܢ ܬܲܠܡܝܼ̈ܕܹܐ ܕܒܘܼܬ ܝܘܿܚܲܢܵܢ ܡܲܥܡܕܵܢܵܐ ܗܲܡܙܘܼܡܹܐ ܝܗܘܵܐ ܥܲܡܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ܟܲܕ ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣ ܟܸܢܫܵܐ، ܩܘܼܪܒܸܢܹܗ ܠܟܸܣ ܝܼܫܘܿܥ ܚܲܕ ܐܢܵܫܵܐ، ܘܒܪܝܼܟ ܠܹܗ ܩܲܕܡܘܼܗ‌ܝ ܘܐܡܝܼܪܹܗ: ");
INSERT INTO aii_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","”ܡܵܪܝܼ، ܪܲܚܸܡ ܥܲܠܔ ܒܪܘܿܢܝܼ، ܕܒܲܪ ܐܸܓܵܪܵܐ ܝܠܹܗ، ܘܚܸܪܒܵܐ ܡܪܝܼܥܵܐ ܝܠܹܗ. ܪܵܒܵܐ ܓܵܗܹ̈ܐ ܟܹܐ ܢܵܦܹܠܔ ܓܵܘ ܢܘܼܪܵܐ، ܘܪܵܒܵܐ ܓܵܗܹ̈ܐ ܟܹܐ ܢܵܦܹܠܔ ܓܵܘ ܡ̈ܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","”ܘܡܘܼܝܬܹ‌ܐ ܠܝܼ ܠܟܸܣ ܬܲܠܡܝܼܕܘܼ̈ܟ݂. ܐܝܼܢܵܐ ܠܵܐ ܡܨܹܐ ܠܗܘܿܢ ܒܲܣܡܝܼ ܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ: ”ܝܵܐ ܫܲܪܒܬܵ‌ܐ ܠܵܐ ܡܗܘܼܡܸܢܬܵ‌ܐ ܘܦܟ̰ܝܼܠܬܵ‌ܐ، ܗܲܠܔ ܐܝܼܡܲܢ ܒܸܬ ܗܵܘܹܝܢ ܥܲܡܵܘܟ݂ܘܿܢ؟ ܗܲܠܔ ܐܝܼܡܲܢ ܒܸܬ ܛܵܥܢܹܢ ܝܘܼܩܪܵܘܟ݂ܘܿܢ؟ ܡܲܝܬܹܝܡܘܼܢ ܠܹܗ ܠܟܸܣܠܝܼ ܠܲܐܟ݂ܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ܘܢܓ̰ܝܼܘ ܠܹܗ ܝܼܫܘܿܥ ܒܫܹܐܕܵܐ، ܘܦܠܝܼܛ ܠܹܗ ܡܸܢܹܗ، ܘܒܣܝܼܡ ܠܹܗ ܝܵܠܵܕ݇ܐ ܒܗ̇ܝ ܣܵܥܲܬ. ");
INSERT INTO aii_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ܗ̇ܝܓܵܗ ܐܬܹ‌ܐ ܠܗܘܿܢ ܬܲܠܡܝܼ̈ܕܹܐ ܠܟܸܣ ܝܼܫܘܿܥ ܒܢܲܦ̮ܫܵܝܗ‌ܝ ܘܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ: ”ܩܵܡܘܿܕܝܼ ܠܵܐ ܡܨܹܐ ܠܲܢ ܐܲܚܢܲܢ ܦܲܠܛܲܚ ܡܸܢܹܗ ܫܹܐܕܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ: ”ܒܘܼܬ ܒܵܨܘܿܪܘܼܬܵ‌ܐ ܕܗܲܝܡܵܢܘܼܬܵܘܟ݂ܘܿܢ. ܣܵܒܵܒ ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܸܢ ܗܵܘܹܐ ܠܵܘܟ݂ܘܿܢ ܗܲܝܡܵܢܘܼܬܵ‌ܐ ܐܲܝܟ݂ ܕܲܢܕܸܟܬܵ‌ܐ ܕܚܲܪܕܲܠܔ، ܒܸܬ ܐܵܡܪܝܼܬܘܿܢ ܠܐܵܗܵܐ ܛܘܼܪܵܐ: ’ܫܲܢܝܼ ܡ̣ܢ ܐܵܗܵܐ ܕܘܼܟܵܐ ܠܗ̇ܝ ܕܘܼܟܵܐ ܐܚܹܪܬܵ‌ܐ،‘ ܘܒܸܬ ܦܵܐܹܫ ܫܘܼܢܝܵܐ. ܡܸܢܕܝܼ ܠܹܐ ܗܵܘܹܐ ܥܸܨܝܵܐ ܐܸܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ܐܝܼܢܵܐ ܐܵܗܵܐ ܓܸܢܣܵܐ ܠܹܐ ܦܵܠܹܛ ܐܸܠܵܐ ܒܨܵܘܡܵܐ ܘܒܨܠܘܿܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ܟܲܕ ܫܸܪܝܹܐ ܝܗܘܵܘ ܓܵܘ ܓܠܝܼܠܵܐ، ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܐܸܠܵܝܗ‌ܝ: ”ܗܕܝܼܪܵܐ ܝܠܹܗ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܕܦܵܐܹܫ ܣܘܼܦܝܵܐ ܒܐܝܼܕܵܬܹ̈‌ܐ ܕܒܢܲܝ̈ܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","”ܒܸܬ ܩܵܛܠܝܼ ܠܹܗ، ܘܒܝܵܘܡܵܐ ܕܬܠܵܬܵ‌ܐ ܒܸܬ ܦܵܐܹܫ ܡܘܼܩܸܡܵܐ.“ ܘܦܫܝܼܡ ܠܗܘܿܢ ܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ܘܟܲܕ ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܦܲܪܢܵܚܘܿܡ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܐܵܢܝܼ ܕܫܵܩܠܝܼ ܗܘܵܘ ܬܪܹܝ ܙܘܼܙܹ̈ܐ ܩܵܐ ܟܠܔ ܪܹܝܫܵܐ، ܘܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ: ”ܠܹܐ ܝܵܗܒܹܠܔ ܪܲܒܝܼܵܘܟ݂ܘܿܢ ܬܪܹܝ ܙܘܼܙܹ̈ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ܓ̰ܘܼܘܸܒ ܠܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܘܐܡܝܼܪܹܗ: ”ܗܹܐ.“ ܘܐܝܼܡܲܢ ܕܥܒ݂ܝܼܪܹܗ ܠܒܲܝܬܵ‌ܐ، ܡ̣ܢ ܩܲܕܡ ܕܗܲܡܙܸܡ ܗܘܵܐ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ، ܒܘܼܩܸܪܹܗ ܡܸܢܹܗ ܝܼܫܘܿܥ: ”ܡܘܼܕܝܼ ܒܸܚܫܵܒ݂ܵܐ ܝܘܸܬ ܫܸܡܥܘܿܢ، ܡܲܠܟܹ̈ܐ ܕܐܲܪܥܵܐ ܡ̣ܢ ܡܵܢܝܼ ܟܹܐ ܫܵܩܠܝܼ ܙܘܼܙܵܐ ܕܪܹܝܫܝܼܬܵ‌ܐ، ܡ̣ܢ ܒܢܘܿܢܵܝ̈ܗ‌ܝ ܝܲܢ ܡ̣ܢ ܢܘܼܟ݂ܪ̈ܵܝܹܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ܓ̰ܘܼܘܸܒ ܠܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܘܐܡܝܼܪܹܗ: ”ܡ̣ܢ ܢܘܼܟ݂ܪ̈ܵܝܹܐ.“ ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ: ”ܒܵܣ ܒܢܘܿܢܹ̈ܐ ܚܹܐܪܹ̈ܐ ܝܢܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","”ܐܝܼܢܵܐ ܕܠܵܐ ܡܲܟܪܸܒܲܚ ܠܗܘܿܢ، ܙܹܠܔ݇ ܠܝܵܡܵܐ ܘܕܪܝܼ ܟ̰ܲܢܓܲܠܔ، ܘܢܘܼܢܵܐ ܩܲܕܡܵܝܵܐ ܕܕܵܒ݂ܩܹܬ ܠܹܗ، ܦܬܘܿܚ ܦܘܼܡܹܗ ܘܒܸܬ ܡܲܫ݇ܟ̰ܚܸܬ ܙܘܼܙܵܐ ܕܣܹܐܡܵܐ. ܫܩܘܿܠܔ ܘܗܲܒ݂ܠܔ ܠܹܗ ܡ̣ܢ ܓܹܒܝܼ ܘܡ̣ܢ ܓܹܒܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ܒܗ̇ܝ ܥܕܵܢܵܐ ܐܬܹ‌ܐ ܠܗܘܿܢ ܬܲܠܡܝܼ̈ܕܹܐ ܠܟܸܣ ܝܼܫܘܿܥ ܘܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ: ”ܡܵܢܝܼ ܝܠܹܗ ܒܘܼܫ ܓܘܼܪܵܐ ܓܵܘ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ܩܪܹܐ ܠܹܗ ܝܼܫܘܿܥ ܠܚܲܕ ܝܵܠܵܕ݇ܐ ܙܥܘܿܪܵܐ ܘܡܘܼܟܠܹܐ ܠܹܗ ܒܓܵܘܵܝܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ܘܐܡܝܼܪܹܗ: ”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܸܢ ܠܵܐ ܕܵܝܪܝܼܬܘܿܢ ܘܗܵܘܹܝܬܘܿܢ ܐܲܝܟ݂ ܝܵܠܹ̈ܕ݇ܐ ܙܥܘܿܪܹ̈ܐ ܠܹܐ ܥܵܒ݂ܪܝܼܬܘܿܢ ܠܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","”ܗܵܕܟ݂ܵܐ ܟܠܔ ܡ̇ܢ ܕܡܲܟܸܦ ܓܵܢܹܗ ܐܲܝܟ݂ ܕܐܵܗܵܐ ܝܵܠܵܕ݇ܐ ܙܥܘܿܪܵܐ، ܗ̇ܘ ܝܼܠܹܗ ܓܘܼܪܵܐ ܓܵܘ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","”ܘܡ̇ܢ ܕܩܲܒܸܠܔ ܒܫܸܡܝܼ ܚܲܕ ܝܵܠܵܕ݇ܐ ܙܥܘܿܪܵܐ ܐܲܝܟ݂ ܕܐܵܗܵܐ، ܐܸܠܝܼ ܩܲܒܘܼܠܹܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","”ܘܡ̇ܢ ܕܗܵܘܹܐ ܬܘܼܪܩܵܠܵܐ ܠܚܲܕ ܡ̣ܢ ܐܲܢܹܐ ܕܟܹܐ ܗܲܡܸܢܝܼ ܒܝܼܝܼ، ܨܦܵܝܝܼ ܝܗܘܵܐ ܐܸܠܹܗ ܕܗܵܘܹܐ ܗܘܵܐ ܬܸܠܝܵܐ ܟܹܐܦܵܐ ܕܐܸܪܚܹܐ ܒܩܕܵܠܹܗ ܘܗܵܘܹܐ ܗܘܵܐ ܪܘܼܦܝܵܐ ܒܥܘܼܡܩܵܐ ܕܝܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","”ܘܵܝ ܠܥܵܠܡܵܐ ܡ̣ܢ ܬܘܼܪ̈ܩܵܠܹܐ. ܐܵܢܲܢܩܵܝܬܵ‌ܐ ܝܠܵܗ̇ ܕܐܵܬ‌ܝܼ ܬܘܼܪ̈ܩܵܠܹܐ، ܐܝܼܢܵܐ ܘܵܝ ܠܗ̇ܘ ܐܢܵܫܵܐ ܕܗܵܘܹܐ ܥܸܠܬܵ‌ܐ ܕܬܘܼܪ̈ܩܵܠܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","”ܒܘܼܬ ܐܵܗܵܐ، ܐܸܢ ܐܝܼܕܘܼܟ݂ ܝܲܢ ܐܲܩܠܘܼܟ݂ ܡܲܚܛܝܼܵܐ ܠܘܼܟ݂، ܦܪܘܿܡ ܠܵܗ̇ ܘܪܲܦܝܼ ܠܵܗ̇ ܡܸܢܘܼܟ݂، ܣܵܒܵܒ ܒܘܼܫ ܨܦܵܝܝܼ ܝܠܵܗ̇ ܐܸܠܘܼܟ݂ ܕܥܵܒ݂ܪܹܬ ܠܚܲܝܹ̈ܐ ܫܸܠܵܐ ܝܲܢ ܫܦܝܼܠܵܐ ܡ̣ܢ ܕܗܵܘܹܐ ܠܘܼܟ݂ ܬܲܪܬܹܝ ܐܝܼܕܵܬܹ̈‌ܐ ܝܲܢ ܬܲܪܬܹܝ ܐܲܩܠܵܬܹ̈‌ܐ ܘܦܵܝܫܹܬ ܕܸܪܝܵܐ ܒܢܘܼܪܵܐ ܕܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","”ܘܐܸܢ ܥܲܝܢܘܼܟ݂ ܡܲܚܛܝܼܵܐ ܠܘܼܟ݂، ܚܪܘܿܛ ܠܵܗ̇ ܘܪܲܦܝܼ ܠܵܗ̇ ܡܸܢܘܼܟ݂، ܣܵܒܵܒ ܒܘܼܫ ܨܦܵܝܝܼ ܝܠܵܗ̇ ܐܸܠܘܼܟ݂ ܕܥܵܒ݂ܪܹܬ ܠܚܲܝܹ̈ܐ ܒܚܕܵܐ ܥܲܝܢܵܐ ܡ̣ܢ ܕܗܵܘܹܐ ܠܘܼܟ݂ ܬܲܪܬܹܝ ܥܲܝ̈ܢܹܐ ܘܦܵܝܫܹܬ ܕܸܪܝܵܐ ܓܵܘ ܓܹܗܲܢܵܐ ܕܢܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","”ܗܘܹܝܡܘܼܢ ܗܸܫܝܲܪ ܕܠܵܐ ܡܲܣܠܹܝܬܘܿܢ ܠܚܲܕ ܡ̣ܢ ܐܲܢܹܐ ܙܥܘܿܪܹ̈ܐ. ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܡܲܠܲܐܟ݂ܵܝ̈ܗ‌ܝ ܐܲܡܝܼܢܵܐܝܼܬ ܟܹܐ ܚܵܙܝܼ ܦܵܬܵ‌ܐ ܕܒܵܒܝܼ ܕܝܼܠܹܗ ܒܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","”ܣܵܒܵܒ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܐܬܹ‌ܐ ܠܹܗ ܕܦܲܪܸܩ ܠܗ̇ܘ ܕܛܠܝܼܩܵܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","”ܡܘܼܕܝܼ ܒܸܚܫܵܒ݂ܵܐ ܝܬܘܿܢ، ܐܸܢ ܐܢܵܫܵܐ ܗܵܘܹܐ ܠܹܗ ܡܵܐܐ ܥܸܪ̈ܒܹܐ، ܘܚܲܕ ܡܸܢܵܝܗ‌ܝ ܛܵܠܹܩ، ܠܹܐ ܫܵܒܹܩ ܬܸܫܥܝܼ ܘܬܸܫܥܵܐ ܥܲܠܔ ܛܘܼܪ̈ܵܢܹܐ ܘܐܵܙܹܠܔ ܛܵܥܹܐ ܒܵܬܪ ܕܗ̇ܘ ܕܛܠܝܼܩ ܠܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܝܼܡܲܢ ܕܚܵܙܹܐ ܠܹܗ ܒܸܬ ܚܵܕܹܐ ܒܗ̇ܘ ܥܸܪܒܵܐ ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܬܸܫܥܝܼ ܘܬܸܫܥܵܐ ܕܠܵܐ ܛܠܝܼܩ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","”ܗܵܕܟ݂ܵܐ، ܠܹܐ ܝܠܹܗ ܨܸܒ݂ܝܵܢܵܐ ܕܒܵܒܵܘܟ݂ܘܿܢ ܕܒܫܡܲܝܵܐ ܕܛܵܠܹܩ ܚܲܕ ܡ̣ܢ ܐܲܢܹܐ ܙܥܘܿܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","”ܐܸܢ ܥܵܒܹܕ ܓܢܵܗܵܐ ܒܝܼܘܼܟ݂ ܐܲܚܘܿܢܘܼܟ݂، ܙܹܠܔ݇ ܘܡܲܕܸܥ ܐܸܠܹܗ ܓܢܵܗܹܗ ܒܹܝܠܘܼܟ݂ ܘܒܹܝܠܹܗ ܐܲܚܟ̰ܝܼ. ܐܸܢ ܫܵܡܹܥ ܐܸܠܘܼܟ݂، ܩܢܹܐ ܠܘܼܟ݂ ܐܲܚܘܿܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","”ܐܝܼܢܵܐ ܐܸܢ ܠܵܐ ܫܵܡܹܥ ܐܸܠܘܼܟ݂، ܠܲܒܸܠܔ ܥܲܡܘܼܟ݂ ܚܲܕ ܝܲܢ ܬܪܹܝ ܐܚܹܪ̈ܢܹܐ، ܕܥܲܠܔ ܦܘܼܡܵܐ ܕܬܪܹܝ ܝܲܢ ܬܠܵܬܵ‌ܐ ܣܵܗܕܹ̈ܐ ܦܵܝܫܵܐ ܡܘܼܩܘܝܼܬܵ‌ܐ ܟܠܔ ܗܹܡܸܙܡܵܢ. ");
INSERT INTO aii_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","”ܘܐܸܢ ܠܵܐ ܫܵܡܹܥ ܐܘܼܦ ܐܸܠܵܝܗ‌ܝ، ܐܡܘܿܪ ܠܥܹܕܬܵ‌ܐ، ܘܐܸܢ ܠܵܐ ܫܵܡܹܥ ܠܥܹܕܬܵ‌ܐ، ܗܵܘܹܐ ܐܸܠܘܼܟ݂ ܐܲܝܟ݂ ܡܵܟ݂ܣܵܐ ܘܐܲܝܟ݂ ܚܲܢܦܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܟܠܔ ܡܸܢܕܝܼ ܕܐܵܣܪܝܼܬܘܿܢ ܒܐܲܪܥܵܐ ܒܸܬ ܗܵܘܹܐ ܐܣܝܼܪܵܐ ܒܫܡܲܝܵܐ، ܘܟܠܔ ܡܸܢܕܝܼ ܕܫܵܪܹܝܬܘܿܢ ܒܐܲܪܥܵܐ ܒܸܬ ܗܵܘܹܐ ܫܸܪܝܵܐ ܒܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","”ܡܸܢܕܪܸܫ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܸܢ ܬܪܹܝ ܡܸܢܵܘܟ݂ܘܿܢ ܣܲܙܓܸܪܝܼ ܥܲܠܔ ܐܲܪܥܵܐ ܥܲܠܔ ܟܠܔ ܡܸܢܕܝܼ ܕܛܵܠܒܝܼ، ܒܸܬ ܗܵܘܹܐ ܐܸܠܵܝܗ‌ܝ ܡ̣ܢ ܠܟܸܣ ܒܵܒܝܼ ܕܒܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","”ܣܵܒܵܒ ܐܲܝܟܵܐ ܕܬܪܹܝ ܝܲܢ ܬܠܵܬܵ‌ܐ ܓ̰ܡܝܼܥܹܐ ܝܢܵܐ ܒܫܸܡܝܼ، ܬܵܡܵܐ ܝܘܸܢ ܐܵܢܵܐ ܓܵܘܵܝܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ܐܬܹ‌ܐ ܠܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܠܟܸܣ ܝܼܫܘܿܥ ܘܒܘܼܩܸܪܹܗ: ”ܡܵܪܝܼ، ܟܡܵܐ ܓܵܗܹ̈ܐ ܚܵܛܹܐ ܐܸܠܝܼ ܐܲܚܘܿܢܝܼ ܘܦܲܚܠܸܢܹܗ، ܗܲܠܔ ܫܒܲܥ ܓܵܗܹ̈ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܠܹܐ ܝܘܸܢ ܒܹܐܡܵܪܵܐ ܐܸܠܘܼܟ݂ ܗܲܠܔ ܫܒܲܥ ܓܵܗܹ̈ܐ، ܐܝܼܢܵܐ ܗܲܠܔ ܫܲܒ݂ܥܝܼ ܓܵܗܹ̈ܐ ܫܒܲܥ. ");
INSERT INTO aii_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","”ܗܵܕܟ݂ܵܐ ܟܹܐ ܕܵܡܝܵܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ ܠܚܲܕ ܡܲܠܟܵܐ ܕܒܥܹܐ ܠܹܗ ܕܫܵܩܹܠܔ ܚܸܫܒܘܼܢܵܐ ܡ̣ܢ ܪܹ̈ܓܵܘܵܬܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","”ܘܟܲܕ ܫܘܼܪܹܐ ܠܹܗ ܠܸܫܩܵܠܵܐ ܚܸܫܒܘܼܢܵܐ، ܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܚܲܕ ܕܕܲܝܢܵܢܵܐ ܝܗܘܵܐ ܐܸܠܹܗ ܥܸܣܪܵܐ ܐܲܠܦܹ̈ܐ ܟܲܟܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","”ܐܝܼܢܵܐ ܣܵܒܵܒ ܠܲܝܬ ܗܘܵܐ ܠܹܗ ܠܸܦܪܵܥܵܐ، ܦܩܝܼܕ ܠܹܗ ܡܵܪܹܗ ܕܦܵܐܹܫ ܙܘܼܒܢܵܐ، ܗ̇ܘ ܘܒܲܟ݂ܬܹܗ ܘܝܵܠܕ݇ܘܼ̈ܗ‌ܝ ܘܟܠܔ ܡܸܢܕܝܼ ܕܐܝܼܬ ܗܘܵܐ ܠܹܗ، ܘܦܵܪܹܥ ܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","”ܐܝܼܢܵܐ ܪܹܓܵܐ ܢܦܝܼܠܔ ܠܹܗ ܥܲܠܔ ܒܸܪ̈ܟܵܟܘܼܗ‌ܝ ܘܦܘܼܪܦܸܠܔ ܠܹܗ ܒܝܼܹܗ ܘܐܡܝܼܪܹܗ: ’ܡܵܪܝܼ، ܚܡܘܿܠܔ ܥܲܠܝܼ، ܘܒܸܬ ܦܵܪܥܹܢܘܼܟ݂ ܟܠܔ ܡܸܢܕܝܼ.‘ ");
INSERT INTO aii_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","”ܗ̇ܝܓܵܗ ܪܘܼܚܸܡ ܠܹܗ ܥܲܠܘܼܗ‌ܝ ܡܵܪܹܗ ܘܫܪܹܐ ܠܹܗ، ܘܦܘܼܚܸܠܔ ܠܹܗ ܐܸܠܹܗ ܕܲܝܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","”ܐܝܼܢܵܐ ܗ̇ܘ ܪܹܓܵܐ ܦܠܝܼܛ ܠܹܗ ܘܚܙܹܐ ܠܹܗ ܚܲܕ ܚܲܒ݂ܪܹܗ ܒܪܹܓܘܼܬܵ‌ܐ ܐܚܹܪܢܵܐ ܕܕܲܝܢܵܢܵܐ ܝܗܘܵܐ ܐܸܠܹܗ ܡܵܐܐ ܕܝܼܢܵܪܹ̈ܐ، ܕܒ݂ܝܼܩ ܠܹܗ ܕܚܵܢܹܩ ܗܘܵܐ ܠܹܗ، ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ’ܗܲܒ݂ܠܔ ܠܝܼ ܡܸܢܕܝܼ ܕܕܲܝܢܵܢܵܐ ܝܘܸܬ ܐܸܠܝܼ.‘ ");
INSERT INTO aii_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","”ܘܢܦܝܼܠܔ ܠܹܗ ܗ̇ܘ ܚܲܒ݂ܪܹܗ ܒܪܹܓܘܼܬܵ‌ܐ ܩܲܕܡ ܐܲܩܠܵܬܘܼ̈ܗ‌ܝ ܘܦܘܼܪܦܸܠܔ ܠܹܗ ܒܝܼܹܗ ܒܹܐܡܵܪܵܐ: ’ܡܲܪܝܸܟ݂ ܥܲܠܝܼ ܒܹܐܢܵܐ، ܒܸܬ ܦܵܪܥܹܢܘܼܟ݂.‘ ");
INSERT INTO aii_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","”ܐܝܼܢܵܐ ܗ̇ܘ ܠܵܐ ܒܣܝܼܡ ܠܵܗ̇ ܠܹܗ. ܐܸܠܵܐ ܐܙܝܼܠܔ ܠܹܗ ܘܕܪܹܐ ܠܹܗ ܐܸܠܹܗ ܓܵܘ ܒܹܝܬ ܐܲܣܝܼܪܹ̈ܐ ܗܲܠܔ ܕܦܵܪܹܥ ܗܘܵܐ ܠܕܲܝܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","”ܟܲܕ ܚܙܹܐ ܠܗܘܿܢ ܚܲܒ݂ܪ̈ܵܘܵܬܵܝܗ‌ܝ ܒܪܹܓܘܼܬܵ‌ܐ ܡܸܢܕܝܼ ܕܗܘܹܐ ܠܹܗ، ܦܫܝܼܡ ܠܗܘܿܢ ܪܵܒܵܐ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܘܡܘܼܚܒܸܪܗܘܿܢ ܠܡܵܪܵܝܗ‌ܝ ܟܠܔ ܡܸܢܕܝܼ ܕܗܘܹܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","”ܗ̇ܝܓܵܗ ܡܵܪܹܗ ܩܪܹܐ ܠܹܗ ܐܸܠܹܗ ܘܐܡܝܼܪܹܗ: ’ܪܹܓܵܐ ܒܝܼܫܵܐ، ܟܠܹܗ ܗ̇ܘ ܕܲܝܢܵܐ ܦܘܼܚܸܠܔ ܠܝܼ ܐܸܠܘܼܟ݂ ܣܵܒܵܒ ܦܘܼܪܦܸܠܔ ܠܘܼܟ݂ ܒܝܼܝܼ، ");
INSERT INTO aii_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","”’ܘܵܠܹܐ ܝܗܘܵܐ ܕܐܘܼܦ ܐܲܢ݇ܬ ܪܲܚܡܸܬ ܗܘܵܐ ܠܚܲܒ݂ܪܘܼܟ݂ ܒܪܹܓܘܼܬܵ‌ܐ ܐܲܝܟ݂ ܕܐܵܢܵܐ ܪܘܼܚܸܡ ܠܝܼ ܥܲܠܘܼܟ݂.‘ ");
INSERT INTO aii_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","”ܟܪܝܼܒ ܠܹܗ ܡܵܪܹܗ، ܘܣܘܼܦܹܐ ܠܹܗ ܠܡܲܠܝܸܨܵܢܹ̈ܐ ܗܲܠܔ ܕܦܵܪܹܥ ܗܘܵܐ ܟܠܔ ܡܸܢܕܝܼ ܕܕܲܝܢܵܢܵܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","”ܗܵܕܟ݂ܵܐ ܐܘܼܦ ܒܵܒܝܼ ܕܒܫܡܲܝܵܐ ܒܸܬ ܥܵܒܹܕ ܐܸܠܵܘܟ݂ܘܿܢ ܐܸܢ ܠܵܐ ܦܲܚܠܝܼܬܘܿܢ ܡ̣ܢ ܠܸܒܵܘܟ݂ܘܿܢ ܐܢܵܫܵܐ ܠܐܲܚܘܿܢܘܼܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ܟܲܕ ܬܘܼܡܸܡ ܠܹܗ ܝܼܫܘܿܥ ܐܲܢܹܐ ܗܹܡܸܙܡܵܢܹ̈ܐ، ܫܘܼܢܹܐ ܠܹܗ ܡ̣ܢ ܓܠܝܼܠܵܐ ܘܐܬܹ‌ܐ ܠܹܗ ܠܬܚܘܼܡܹ̈ܐ ܕܝܼܗܘܼܕ، ܠܗ̇ܘ ܡܲܪܙܵܐ ܐܚܹܪܢܵܐ ܕܢܲܗܪܵܐ ܕܝܘܿܪܕܢܵܢ. ");
INSERT INTO aii_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܒܵܬܪܹܗ ܟܸܢܫܹ̈ܐ ܪܵܒܵܐ، ܘܒܘܼܣܡܵܝ ܠܹܗ ܬܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܦܪ̈ܝܼܫܹܐ ܕܓ̰ܲܪܒܝܼ ܗܘܵܘ ܠܹܗ، ܘܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ ܐܸܢ ܩܵܢܘܿܢܵܝܬܵ‌ܐ ܝܠܵܗ̇ ܠܐܢܵܫܵܐ ܕܪܲܦܹܐ ܒܲܟ݂ܬܹܗ ܒܟܠܔ ܥܸܠܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܠܵܐ ܩܪܹܐ ܠܵܘܟ݂ܘܿܢ ܗ̇ܘ ܕܒܸܪܝܵܝ ܠܹܗ ܡ̣ܢ ܫܘܼܪܵܝܵܐ، ܐܘܼܪܙܵܐ ܘܢܸܩܒ݂ܵܐ ܒܸܪܝܵܝ ܠܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","”ܘܐܡܝܼܪܹܗ: ’ܒܘܼܬ ܐܵܗܵܐ ܒܸܬ ܫܵܒܹܩ ܐܢܵܫܵܐ ܠܒܵܒܘܼܗ‌ܝ ܘܠܝܸܡܹܗ ܘܒܸܬ ܬܵܒܹܥ ܠܒܲܟ݂ܬܹܗ، ܘܬܸܪܘܵܝ ܒܸܬ ܗܵܘܝܼ ܚܲܕ ܦܲܓ݂ܪܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","”ܗܵܕܟ݂ܵܐ ܐܚܹܪܢܵܐ ܠܹܐ ܝܢܵܐ ܬܪܹܝ ܐܸܠܵܐ ܚܲܕ ܦܲܓ݂ܪܵܐ ܝܢܵܐ. ܒܘܼܬ ܐܵܗܵܐ، ܡܸܢܕܝܼ ܕܐܲܠܵܗܵܐ ܙܘܼܘܸܓ ܠܹܗ، ܒܲܪܢܵܫܵܐ ܠܵܐ ܦܵܪܹܫ ܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ܘܐܵܢܝܼ ܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܒܵܣ ܩܵܡܘܿܕܝܼ ܡܘܼܫܹܐ ܦܩܝܼܕ ܠܹܗ ܠܝܼܵܗܒ݂ܵܐ ܟܬܵܒ݂ܵܐ ܕܕܘܼܠܵܠܵܐ ܘܠܪܲܦܘܼܝܘܼܗ̇؟“ ");
INSERT INTO aii_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ܘܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ: ”ܒܘܼܬ ܩܸܫܝܘܼܬܵ‌ܐ ܕܠܸܒܵܘܟ݂ܘܿܢ ܡܘܼܫܹܐ ܦܩܝܼܕ ܠܹܗ ܐܸܠܵܘܟ݂ܘܿܢ ܕܪܲܦܹܝܬܘܿܢ ܠܒܲܟ݂ܬܵܬܵܘ̈ܟ݂ܘܿܢ، ܐܝܼܢܵܐ ܡ̣ܢ ܫܘܼܪܵܝܵܐ ܠܹܐ ܝܗܘܵܐ ܗܵܕܟ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","”ܐܝܼܢܵܐ ܐܵܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܡ̇ܢ ܕܪܲܦܹܐ ܒܲܟ݂ܬܹܗ، ܫܒ݂ܘܿܩ ܡ̣ܢ ܥܸܠܬܵ‌ܐ ܕܙܵܢܝܘܼܬܵ‌ܐ، ܘܓܵܒܹܪ ܚܕܵܐ ܐܚܹܪܬܵ‌ܐ ܒܸܥܒ݂ܵܕܵܐ ܝܠܹܗ ܓܲܝܵܪܘܼܬܵ‌ܐ، ܘܡ̇ܢ ܕܓܵܒܹܪ ܪܘܼܦܝܼܬܵ‌ܐ، ܒܸܥܒ݂ܵܕܵܐ ܝܠܹܗ ܓܲܝܵܪܘܼܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܐܸܢ ܗܵܕܟ݂ܵܐ ܝܠܹܗ ܫܘܼܠܵܐ ܒܹܝܠܔ ܓܲܒ݂ܪܵܐ ܘܒܲܟ݂ܬܵ‌ܐ، ܠܹܐ ܝܠܵܗ̇ ܨܦܵܝܝܼ ܠܸܓܒ݂ܵܪܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ܐܝܼܢܵܐ ܗ̇ܘ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܟܠܵܝܗ‌ܝ ܐܢܵܫܹ̈ܐ ܠܹܐ ܡܵܨܝܼ ܩܲܒܠܝܼ ܠܐܵܗܵܐ ܗܹܡܸܙܡܵܢ ܐܸܠܵܐ ܐܵܢܝܼ ܕܦܝܼܫܬܵ‌ܐ ܝܠܵܗ̇ ܝܘܼܗܒܹܠܬܵ‌ܐ ܐܸܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","”ܣܵܒܵܒ ܐܝܼܬ ܡܗܲܝܡܢܹ̈ܐ ܕܡ̣ܢ ܟܹܪ݇ܣܵܐ ܕܝܸܡܵܝܗ‌ܝ ܗܘܹܐ ܠܗܘܿܢ ܡܗܲܝܡܢܹ̈ܐ، ܘܐܝܼܬ ܡܗܲܝܡܢܹ̈ܐ ܕܒܝܲܕ ܒܢܲܝ̈ܢܵܫܵܐ ܦܝܼܫ ܠܗܘܿܢ ܥܒ݂ܝܼܕܹܐ ܡܗܲܝܡܢܹ̈ܐ، ܘܐܝܼܬ ܐܵܢܝܼ ܕܥܒ݂ܝܼܕܵܐ ܠܗܘܿܢ ܓܵܢܵܝܗ‌ܝ ܡܗܲܝܡܢܹ̈ܐ ܒܘܼܬ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ. ܡ̇ܢ ܕܡܵܨܹܐ ܩܲܒܸܠܔ ܠܵܗ̇، ܩܲܒܸܠܔ ܠܵܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ܗ̇ܝܓܵܗ ܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܝܵܠܹ̈ܕ݇ܐ ܙܥܘܿܪܹ̈ܐ ܕܡܲܬܸܒ݂ ܐܝܼܕܵܬܘܼ̈ܗ‌ܝ ܘܨܲܠܹܐ ܥܲܠܵܝܗ‌ܝ؛ ܐܝܼܢܵܐ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܢܓ̰ܝܼܘ ܠܗܘܿܢ ܒܝܼܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ܝܼܫܘܿܥ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܫܒ݂ܘܿܩܘܼܢ ܝܵܠܹ̈ܕ݇ܐ ܙܥܘܿܪܹ̈ܐ ܐܵܬ‌ܝܼ ܠܟܸܣܠܝܼ ܘܠܵܐ ܡܲܟܠܹܝܬܘܿܢ ܠܗܘܿܢ، ܣܵܒܵܒ ܩܵܐ ܡܐܲܝܟ݂ ܕܐܲܢܹܐ ܝܠܵܗ̇ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ܘܡܘܼܬܸܒ݂ ܠܹܗ ܐܝܼܕܵܬܘܼ̈ܗ‌ܝ ܥܲܠܵܝܗ‌ܝ، ܘܐܙܝܼܠܔ ܠܹܗ ܡ̣ܢ ܬܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ܘܗܵܐ ܚܲܕ ܐܢܵܫܵܐ ܐܬܹ‌ܐ ܠܹܗ ܘܒܘܼܩܸܪܹܗ ܡܸܢܹܗ: ”ܡܲܠܦܵܢܵܐ، ܡܘܼܕܝܼ ܛܵܒ݂ܵܐ ܥܵܒ݂ܕܹܢ ܕܝܵܪܬܹܢ ܠܚܲܝܹ̈ܐ ܕܠܥܵܠܲܡ؟“ ");
INSERT INTO aii_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܩܵܡܘܿܕܝܼ ܒܲܩܘܼܪܝܼ ܝܘܸܬ ܒܘܼܬ ܡܘܼܕܝܼ ܝܠܹܗ ܛܵܒ݂ܵܐ؟ ܠܲܝܬ ܐܘܼܦ ܚܲܕ ܛܵܒ݂ܵܐ ܐܸܠܵܐ ܐܲܠܵܗܵܐ ܐܲܚܟ̰ܝܼ. ܐܝܼܢܵܐ ܐܸܢ ܒܵܥܹܝܬ ܝܵܪܬܹܬ ܠܚܲܝܹ̈ܐ، ܢܛܘܿܪ ܦܘܼܩܕܵܢܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ܘܗ̇ܘ ܒܘܼܩܸܪܹܗ ܡܸܢܹܗ: ”ܐܲܝܢܝܼ ܦܘܼܩܕܵܢܹ̈ܐ؟“ ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ: ”ܠܵܐ ܩܵܛܠܹܬ، ܠܵܐ ܙܵܢܹܝܬ، ܠܵܐ ܓܵܢܒܹܬ، ܠܵܐ ܝܵܗܒܹܬ ܣܵܗܕܘܼܬܵ‌ܐ ܕܕܘܼܓܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","”ܡܝܲܩܸܪ ܠܒܵܒܘܼܟ݂ ܘܠܝܸܡܘܼܟ݂، ܘܡܲܚܸܒܸܬ ܠܫܒ݂ܵܒ݂ܘܼܟ݂ ܐܲܝܟ݂ ܓܵܢܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ܓ̰ܘܼܘܸܒ ܠܹܗ ܗ̇ܘ ܥܠܲܝܡܵܐ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܟܠܵܝܗ‌ܝ ܐܲܢܹܐ ܢܛܝܼܪܵܝ ܝܘܸܢ ܡ̣ܢ ܝܵܠܕ݇ܘܼܬ‌ܝܼ، ܡܘܼܕܝܼ ܐܚܹܪܢܵܐ ܒܵܨܘܿܪܵܐ ܝܠܹܗ ܡܸܢܝܼ؟“ ");
INSERT INTO aii_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܐܸܢ ܒܵܥܹܝܬ ܕܗܵܘܹܝܬ ܟܡܝܼܠܵܐ، ܙܹܠܔ݇ ܙܲܒܸܢ ܡܸܢܕܝܼܘܼܟ݂ ܘܗܲܒ݂ܠܔ ܠܹܗ ܠܡܸܣܟܹܢܹ̈ܐ ܘܒܸܬ ܗܵܘܹܐ ܠܘܼܟ݂ ܣܝܼܡܬܵ‌ܐ ܒܫܡܲܝܵܐ، ܘܬܵ‌ܐ ܒܵܬܪܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ܐܝܼܢܵܐ ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܹܗ ܗ̇ܘ ܥܠܲܝܡܵܐ ܐܵܗܵܐ ܗܹܡܸܙܡܵܢ، ܐܙܝܼܠܔ ܠܹܗ ܦܫܝܼܡܵܐ، ܣܵܒܵܒ ܐܝܼܬ ܗܘܵܐ ܠܹܗ ܡܸܢܕܝܼ ܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ܗ̇ܝܓܵܗ ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܥܲܣܩܵܐ ܝܠܵܗ̇ ܠܚܲܕ ܥܲܬܝܼܪܵܐ ܕܥܵܒܹܪ ܠܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ، ");
INSERT INTO aii_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","”ܘܡܸܢܕܪܸܫ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܒܘܼܫ ܦܫܘܼܩܬܵ‌ܐ ܝܠܵܗ̇ ܠܓܘܼܡܠܵܐ ܠܸܥܒ݂ܵܪܵܐ ܒܢܸܩܒܵܐ ܕܚܡܵܛܵܐ ܡ̣ܢ ܕܥܲܬܝܼܪܵܐ ܥܵܒܹܪ ܠܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܗܘܿܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܐܵܗܵܐ، ܥܘܼܓ̰ܸܒ ܠܗܘܿܢ ܪܵܒܵܐ ܘܐܡܝܼܪܗܘܿܢ: ”ܒܵܣ ܡܵܢܝܼ ܡܵܨܹܐ ܦܵܪܹܩ؟“ ");
INSERT INTO aii_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܚܝܼܪܹܗ ܒܝܼܵܝܗ‌ܝ ܘܐܡܝܼܪܹܗ: ”ܠܟܸܣ ܒܢܲܝ̈ܢܵܫܵܐ ܐܵܗܵܐ ܡܸܢܕܝܼ ܠܹܐ ܡܵܨܹܐ ܗܵܘܹܐ، ܐܝܼܢܵܐ ܠܟܸܣ ܐܲܠܵܗܵܐ ܟܠܔ ܡܸܢܕܝܼ ܟܹܐ ܡܵܨܹܐ ܗܵܘܹܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ܗ̇ܝܓܵܗ ܓ̰ܘܼܘܸܒ ܠܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܗܵܐ ܐܲܚܢܲܢ ܫܒ݂ܝܼܩ ܠܲܢ ܟܠܔ ܡܸܢܕܝܼ ܘܐܬܹ‌ܐ ܠܲܢ ܒܵܬܪܘܼܟ݂. ܡܘܼܕܝܼ ܒܸܬ ܩܲܒܠܲܚ؟“ ");
INSERT INTO aii_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܲܚܬܘܿܢ ܕܐܬܹ‌ܐ ܠܵܘܟ݂ܘܿܢ ܒܵܬܪܝܼ، ܒܚܘܼܕܵܬܵ‌ܐ ܕܒܪܝܼܬܵ‌ܐ، ܐܝܼܡܲܢ ܕܝܵܬܹܒ݂ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܥܲܠܔ ܬܪܘܿܢܘܿܣ ܕܚܸܩܪܹܗ، ܐܘܼܦ ܐܲܚܬܘܿܢ ܒܸܬ ܝܵܬܒ݂ܝܼܬܘܿܢ ܥܲܠܔ ܬܪܸܥܣܲܪ ܬܪ̈ܘܿܢܘܿܣܹܐ ܘܕܵܝܢܝܼܬܘܿܢ ܬܪܸܥܣܲܪ ܫܲܒ݂ܛܹ̈ܐ ܕܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","”ܘܟܠܔ ܐܢܵܫܵܐ ܕܫܵܒܹܩ ܒܵܬܹ̈‌ܐ، ܝܲܢ ܐܲܚܘܿܢܘܵܬܹ̈‌ܐ، ܝܲܢ ܚܵܬܘܵܬܹ̈‌ܐ، ܝܲܢ ܒܵܒܵܐ، ܝܲܢ ܝܸܡܵܐ، ܝܲܢ ܒܲܟ݂ܬܵ‌ܐ، ܝܲܢ ܝܵܠܹ̈ܕ݇ܐ، ܝܲܢ ܚܲܩܠܵܢܹ̈ܐ ܒܘܼܬ ܫܸܡܝܼ، ܒܸܬ ܩܲܒܸܠܔ ܚܲܕ ܒܡܵܐܐ، ܘܒܸܬ ܝܵܪܹܬ ܚܲܝܹ̈ܐ ܕܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","”ܐܝܼܢܵܐ ܪܵܒܵܐ ܕܝܼܢܵܐ ܩܲܕܡܵܝܹ̈ܐ ܒܸܬ ܗܵܘܝܼ ܐܚܵܪ̈ܵܝܹܐ، ܘܐܚܵܪ̈ܵܝܹܐ ܒܸܬ ܗܵܘܝܼ ܩܲܕܡܵܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","”ܟܹܐ ܕܵܡܝܵܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ ܠܐܢܵܫܵܐ ܡܵܪܵܐ ܕܒܲܝܬܵ‌ܐ ܕܦܠܝܼܛ ܠܹܗ ܒܩܲܝܕܵܡܬܵ‌ܐ ܓ̰ܲܠܕܹܐ ܠܸܕܒ݂ܵܩܵܐ ܦܵܥ̈ܠܹܐ ܩܵܐ ܟܲܪܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","”ܡ̣ܢ ܒܵܬܪ ܕܩܛܝܼܥ ܠܹܗ ܥܲܡ ܦܵܥ̈ܠܹܐ ܕܝܼܢܵܪܵܐ ܒܝܵܘܡܵܐ، ܫܘܼܕܪܵܝ ܠܹܗ ܕܦܵܠܚܝܼ ܓܵܘ ܟܲܪܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","”ܘܦܠܝܼܛ ܠܹܗ ܡܸܢܕܪܸܫ ܒܣܵܥܲܬ ܕܬܫܲܥ ܕܩܲܝܕܵܡܬܵ‌ܐ، ܘܚܙܹܐ ܠܹܗ ܐܚܹܪ̈ܢܹܐ ܟܸܠܝܹܐ ܒܫܘܼܩܵܐ ܒܲܛܝܼܠܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","”ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ’ܙܹܠ݇ܡܘܼܢ ܐܘܼܦ ܐܲܚܬܘܿܢ ܘܦܠܘܿܚܘܼܢ ܓܵܘ ܟܲܪܡܝܼ، ܘܡܸܢܕܝܼ ܕܘܵܠܹܐ ܝܠܹܗ ܒܸܬ ܦܵܪܥܹܢܵܘܟ݂ܘܿܢ.‘ ܘܐܙܝܼܠܔ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","”ܦܠܝܼܛ ܠܹܗ ܡܸܢܕܪܸܫ ܒܣܵܥܲܬ ܕܬܪܸܥܣܲܪ، ܘܒܣܵܥܲܬ ܕܬܠܵܬ ܡ̣ܢ ܒܵܬܪ ܟܵܘܸܬܪܵܐ، ܘܥܒ݂ܝܼܕ ܠܹܗ ܗܵܕܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","”ܘܡܐܲܝܟ݂ ܣܵܥܲܬ ܕܚܲܡܸܫ ܡ̣ܢ ܒܵܬܪ ܟܵܘܸܬܪܵܐ، ܦܠܝܼܛ ܠܹܗ ܡܸܢܕܪܸܫ ܘܚܙܹܐ ܠܹܗ ܦܵܥ̈ܠܹܐ ܐܚܹܪ̈ܢܹܐ ܟܸܠܝܹܐ ܒܲܛܝܼܠܹ̈ܐ، ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ’ܩܵܡܘܿܕܝܼ ܟܸܠܝܹܐ ܝܬܘܿܢ ܠܲܐܟ݂ܵܐ ܒܲܛܝܼܠܹ̈ܐ ܟܠܹܗ ܝܵܘܡܵܐ؟‘ ");
INSERT INTO aii_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","”ܘܐܵܢܝܼ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܐܸܠܹܗ: ’ܣܵܒܵܒ ܐܢܵܫܵܐ ܠܵܐ ܩܵܡ ܡܲܦܠܸܚ ܠܲܢ.‘ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ’ܙܹܠ݇ܡܘܼܢ ܘܦܠܘܿܚܘܼܢ ܓܵܘ ܟܲܪܡܝܼ، ܘܡܸܢܕܝܼ ܕܘܵܠܹܐ ܝܠܹܗ ܒܸܬ ܩܲܒܠܝܼܬܘܿܢ.‘ ");
INSERT INTO aii_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","”ܟܲܕ ܗܘܹܐ ܠܹܗ ܪܲܡܫܵܐ، ܐܡܝܼܪܹܗ ܡܵܪܵܐ ܕܟܲܪܡܵܐ ܠܪܲܒ ܒܲܝܬܹܗ: ’ܩܪܝܼ ܠܦܵܥ̈ܠܹܐ، ܘܦܪܹܥ ܠܹܗ ܗܵܩܵܝܗ‌ܝ. ܫܲܪܝܼ ܡ̣ܢ ܐܚܵܪ̈ܵܝܹܐ ܘܗܲܠܔ ܩܲܕܡܵܝܹ̈ܐ.‘ ");
INSERT INTO aii_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","”ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܐܵܢܝܼ ܕܫܘܼܪܝܹܐ ܝܗܘܵܘ ܡ̣ܢ ܣܵܥܲܬ ܕܚܲܡܸܫ ܕܒܵܬܪ ܟܵܘܸܬܪܵܐ، ܘܫܩܝܼܠܔ ܠܹܗ ܟܠܔ ܚܲܕ ܡܸܢܵܝܗ‌ܝ ܚܲܕ ܕܝܼܢܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","”ܐܝܼܢܵܐ ܐܝܼܡܲܢ ܕܐܬܹ‌ܐ ܠܗܘܿܢ ܐܵܢܝܼ ܩܲܕܡܵܝܹ̈ܐ، ܚܫܝܼܒ݂ ܠܗܘܿܢ ܒܸܬ ܩܲܒܠܝܼ ܗܘܵܘ ܗܵܩܵܐ ܙܵܘܕܵܐ. ܐܝܼܢܵܐ ܐܘܼܦ ܐܵܢܝܼ ܫܩܝܼܠܔ ܠܗܘܿܢ ܟܠܔ ܡܸܢܵܝܗ‌ܝ ܚܲܕ ܕܝܼܢܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","”ܘܟܲܕ ܫܩܝܼܠܔ ܠܗܘܿܢ، ܛܘܼܪܛܸܡ ܠܗܘܿܢ ܥܲܠܔ ܡܵܪܵܐ ܕܒܲܝܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","”ܘܐܡܝܼܪܗܘܿܢ: ’ܐܲܢܹܐ ܐܚܵܪ̈ܵܝܹܐ ܦܠܝܼܚ ܠܗܘܿܢ ܚܕܵܐ ܣܵܥܲܬ ܘܚܘܼܫܒܸܢܵܝ ܠܘܼܟ݂ ܡܐܲܝܟ݂ ܕܝܼܲܢ، ܐܲܚܢܲܢ ܕܛܥܝܼܢܲܢ ܝܘܼܩܪܵܐ ܕܝܵܘܡܵܐ ܘܚܸܡܹܗ.‘ ");
INSERT INTO aii_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","”ܓ̰ܘܼܘܸܒ ܠܹܗ ܡܵܪܵܐ ܕܟܲܪܡܵܐ ܠܚܲܕ ܡܸܢܵܝܗ‌ܝ ܘܐܡܝܼܪܹܗ: ’ܚܲܒ݂ܪܝܼ، ܠܹܐ ܝܘܸܢ ܒܸܥܒ݂ܵܕܵܐ ܓܢܵܗܵܐ ܒܝܼܘܼܟ݂. ܠܹܐ ܝܗܘܵܐ ܒܕܝܼܢܵܪܵܐ ܩܛܝܼܥ ܠܘܼܟ݂ ܥܲܡܝܼ؟ ");
INSERT INTO aii_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","”’ܫܩܘܿܠܔ ܗܵܩܘܼܟ݂ ܘܙܹܠܔ݇. ܒܵܥܹܝܢ ܕܝܵܗܒܹܢ ܠܐܵܗܵܐ ܐܚܵܪܵܝܵܐ ܡܐܲܝܟ݂ ܕܝܘܼܗܒܹܠܔ ܠܝܼ ܐܸܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","”’ܠܲܝܬ ܠܝܼ ܗܵܩܘܼܬܵ‌ܐ ܕܥܵܒ݂ܕܹܢ ܒܡܸܢܕܝܼ ܕܓܵܢܝܼ ܐܲܝܟ݂ ܕܒܵܣܡܵܐ ܠܝܼ؟ ܝܲܢ ܒܲܚܘܼܠܹܐ ܝܘܸܬ ܒܝܼܝܼ ܣܵܒܵܒ ܛܵܒ݂ܵܐ ܝܘܸܢ؟‘ ");
INSERT INTO aii_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","”ܗܵܕܟ݂ܵܐ، ܐܚܵܪ̈ܵܝܹܐ ܒܸܬ ܗܵܘܝܼ ܩܲܕܡܵܝܹ̈ܐ، ܘܩܲܕܡܵܝܹ̈ܐ ܐܚܵܪ̈ܵܝܹܐ؛ ܣܵܒܵܒ ܪܵܒܵܐ ܝܢܵܐ ܟ̰ܝܼܕܹܐ ܘܒܵܨܘܿܪܹ̈ܐ ܝܢܵܐ ܓܘܼܒܝܹܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ܟܲܕ ܒܹܐܣܵܩܵܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܠܐܘܿܪܸܫܠܸܡ، ܩܸܪܝܵܝ ܠܹܗ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܠܚܲܕ ܓܹܒܵܐ ܒܢܲܦ̮ܫܵܝܗ‌ܝ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ");
INSERT INTO aii_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","”ܐܵܕܝܼܵܐ ܒܹܐܣܵܩܵܐ ܝܘܲܚ ܠܐܘܿܪܸܫܠܸܡ، ܘܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܸܬ ܦܵܐܹܫ ܣܘܼܦܝܵܐ ܠܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܠܣܵܦܪܹ̈ܐ، ܘܒܸܬ ܕܵܝܢܝܼ ܠܹܗ ܠܡܵܘܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","”ܘܒܸܬ ܣܲܦܝܼ ܠܹܗ ܠܐܸܡܘܵܬܹ̈‌ܐ ܕܡܲܣܚܸܪܝܼ ܒܝܼܹܗ، ܘܡܵܚܝܼ ܠܹܗ ܒܫܵܘܛܹ̈ܐ ܘܡܵܚܝܼ ܠܹܗ ܠܙܩܝܼܦܵܐ، ܘܒܝܵܘܡܵܐ ܕܬܠܵܬܵ‌ܐ ܒܸܬ ܩܵܐܹܡ.“ ");
INSERT INTO aii_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ܗ̇ܝܓܵܗ ܐܬܹ‌ܐ ܠܵܗ̇ ܠܟܸܣܠܹܗ ܝܸܡܵܐ ܕܒܢܘܿܢܹ̈ܐ ܕܙܲܒ݂ܕܲܝ ܥܲܡ ܒܢܘܿܢܘܼ̈ܗ̇، ܘܣܓ݂ܝܼܕ ܠܵܗ̇ ܐܸܠܹܗ، ܘܛܠܝܼܒ ܠܵܗ̇ ܡܸܢܹܗ ܚܕܵܐ ܒܵܥܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ܒܘܼܩܸܪܹܗ ܡܸܢܘܼܗ̇ ܝܼܫܘܿܥ: ”ܡܘܼܕܝܼ ܒܵܥܝܲܬ‌ܝ؟“ ܘܓ̰ܘܼܘܸܒ ܠܵܗ̇ ܘܐܡܝܼܪܵܗ̇ ܐܸܠܹܗ: ”ܫܒ݂ܘܿܩ ܐܲܢܹܐ ܬܪܹܝ ܒܢܘܿܢܝܼ̈ ܝܵܬܒ݂ܝܼ ܥܲܡܘܼܟ݂ ܒܡܲܠܟܘܼܬܘܼܟ݂، ܚܲܕ ܡ̣ܢ ܝܲܡܝܼܢܘܼܟ݂ ܘܚܲܕ ܡ̣ܢ ܣܸܡܵܠܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇: ”ܠܹܐ ܝܬܘܿܢ ܒܝܼܕܵܥܵܐ ܡܘܼܕܝܼ ܒܸܛܠܵܒܵܐ ܝܬܘܿܢ. ܡܵܨܹܝܬܘܿܢ ܫܵܬܹܝܬܘܿܢ ܡ̣ܢ ܟܵܣܵܐ ܕܐܵܢܵܐ ܗܕܝܼܪܵܐ ܝܘܸܢ ܠܸܫܬܵܝܹܗ، ܝܲܢ ܕܥܵܡܕܝܼܬܘܿܢ ܒܡܲܥܡܘܿܕܝܼܬܵ‌ܐ ܕܒܝܼܘܼܗ̇ ܦܵܝܫܹܢ ܥܡܝܼܕܵܐ؟“ ܘܐܵܢܝܼ ܐܡܝܼܪܗܘܿܢ: ”ܗܹܐ، ܟܹܐ ܡܵܨܲܚ.“ ");
INSERT INTO aii_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܡ̣ܢ ܟܵܣܝܼ ܗܲܪ ܒܸܬ ܫܵܬܹܝܬܘܿܢ، ܘܡܲܥܡܘܿܕܝܼܬܵ‌ܐ ܕܒܝܼܘܼܗ̇ ܦܵܝܫܹܢ ܥܡܝܼܕܵܐ ܒܸܬ ܥܵܡܕܝܼܬܘܿܢ. ܐܝܼܢܵܐ ܝܬܵܒ݂ܬܵ‌ܐ ܡ̣ܢ ܣܸܡܵܠܝܼ ܘܡ̣ܢ ܝܲܡܝܼܢܝܼ ܠܹܐ ܐܵܢܵܐ ܝܵܗܒܹܢܵܗ̇، ܐܸܠܵܐ ܒܸܬ ܦܵܝܫܵܐ ܝܘܼܗܒܹܠܬܵ‌ܐ ܠܐܵܢܝܼ ܕܗܘܼܕܸܪܬܵ‌ܐ ܝܠܵܗ̇ ܐܸܠܵܝܗ‌ܝ ܡ̣ܢ ܒܵܒܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ܟܲܕ ܫܡܝܼܥ ܠܗܘܿܢ ܥܸܣܪܵܐ ܬܲܠܡܝܼ̈ܕܹܐ، ܟܪܝܼܒ ܠܗܘܿܢ ܥܲܠܔ ܐܵܢܝܼ ܬܪܹܝ ܐܲܚܘܿܢܘܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܩܸܪܝܵܝ ܠܹܗ ܘܐܡܝܼܪܹܗ: ”ܟܹܐ ܝܵܕܥܝܼܬܘܿܢ ܕܓܘܼܪ̈ܵܢܹܐ ܕܐܸܡܘܵܬܹ̈‌ܐ ܡܵܪ̈ܵܘܵܬܵܝܗ‌ܝ ܝܢܵܐ، ܘܓܘܼܪ̈ܵܢܵܝܗ‌ܝ ܟܹܐ ܥܵܒ݂ܕܝܼ ܫܘܼܠܛܵܢܵܐ ܥܲܠܵܝܗ‌ܝ؟ ");
INSERT INTO aii_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","”ܐܝܼܢܵܐ ܐܵܗܵܐ ܡܸܢܕܝܼ ܠܵܐ ܗܵܘܹܐ ܓܵܘܵܘܟ݂ܘܿܢ، ܐܸܠܵܐ ܡ̇ܢ ܕܒܵܥܹܐ ܗܵܘܹܐ ܓܘܼܪܵܐ ܓܵܘܵܘܟ݂ܘܿܢ، ܗܵܘܹܐ ܥܵܒ݂ܕܵܢܵܐ ܕܚܸܠܡܲܬ ܐܸܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","”ܘܡ̇ܢ ܕܒܵܥܹܐ ܡܸܢܵܘܟ݂ܘܿܢ ܠܹܗܘܵܝܵܐ ܩܲܕܡܵܝܵܐ، ܗܵܘܹܐ ܐܸܠܵܘܟ݂ܘܿܢ ܥܲܒ݂ܕܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","”ܕܵܐܟ݂ܝܼ ܕܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܠܵܐ ܐܬܹ‌ܐ ܠܹܗ ܕܦܵܐܹܫ ܥܒ݂ܝܼܕܵܐ ܚܸܠܡܲܬ ܡ̣ܢ ܐܢܵܫܹ̈ܐ، ܐܸܠܵܐ ܕܥܵܒܹܕ ܠܗܘܿܢ ܚܸܠܡܲܬ، ܘܝܵܗܒܹܠܔ ܓܵܢܹܗ ܦܘܼܪܩܵܢܵܐ ܡ̣ܢ ܓܹܒܵܐ ܕܪܵܒܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ܟܲܕ ܒܸܦܠܵܛܵܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܡ̣ܢ ܐܝܼܪܝܼܚܘܿ، ܐܬܹ‌ܐ ܠܹܗ ܒܵܬܪܹܗ ܟܸܢܫܵܐ ܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ܘܗܵܐ ܬܪܹܝ ܣܸܡܝܹ̈ܐ ܝܬܝܼܒܹܐ ܝܗܘܵܘ ܒܡܲܪܙܵܐ ܕܐܘܼܪܚܵܐ. ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܗܘܿܢ ܕܝܼܫܘܿܥ ܒܸܥܒ݂ܵܪܵܐ ܝܗܘܵܐ ܡ̣ܢ ܬܵܡܵܐ، ܡܘܼܩܘܸܚ ܠܗܘܿܢ: ”ܡܵܪܲܢ، ܒܪܘܿܢܵܐ ܕܕܵܘܝܼܕ، ܪܲܚܸܡ ܥܲܠܲܢ!“ ");
INSERT INTO aii_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ܘܟܸܢܫܵܐ ܢܓ̰ܝܼܘ ܠܹܗ ܒܝܼܵܝܗ‌ܝ ܕܫܵܬܩܝܼ. ܐܝܼܢܵܐ ܐܵܢܝܼ ܒܘܼܫ ܙܵܘܕܵܐ ܡܘܼܩܘܸܚ ܠܗܘܿܢ: ”ܡܵܪܲܢ، ܒܪܘܿܢܵܐ ܕܕܵܘܝܼܕ، ܪܲܚܸܡ ܥܲܠܲܢ.“ ");
INSERT INTO aii_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ܘܟܠܹܐ ܠܹܗ ܝܼܫܘܿܥ ܘܩܸܪܝܵܝ ܠܹܗ ܠܟܸܣܠܹܗ ܘܐܡܝܼܪܹܗ: ”ܡܘܼܕܝܼ ܒܵܥܹܝܬܘܿܢ ܕܥܵܒ݂ܕܹܢ ܐܸܠܵܘܟ݂ܘܿܢ؟“ ");
INSERT INTO aii_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܐܸܠܹܗ: ”ܡܵܪܲܢ، ܒܵܥܲܚ ܕܦܵܬܚܝܼ ܥܲܝܢܲܢ̈.“ ");
INSERT INTO aii_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ܘܪܘܼܚܸܡ ܠܹܗ ܥܲܠܵܝܗ‌ܝ ܝܼܫܘܿܥ، ܘܕܩܝܼܪܹܗ ܒܥܲܝ̈ܢܵܝܗ‌ܝ، ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܚܙܹܐ ܠܗܘܿܢ، ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܒܵܬܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ܟܲܕ ܩܘܼܪܒܸܢܗܘܿܢ ܝܼܫܘܿܥ ܘܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܠܐܘܿܪܸܫܠܸܡ، ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܠܒܹܝܬ ܦܵܓܹ̈ܐ ܠܓܹܒܵܐ ܕܛܘܼܪܵܐ ܕܙܲܝ̈ܬܹ‌ܐ، ܫܘܼܕܸܪܹܗ ܝܼܫܘܿܥ ܬܪܹܝ ܡ̣ܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܙܹܠ݇ܡܘܼܢ ܠܐܵܗܵܐ ܡܵܬܵ‌ܐ ܕܝܼܠܵܗ̇ ܠܒܲܠܩܘܼܒ݂ܠܵܘܟ݂ܘܿܢ، ܘܒܸܬ ܡܲܫ݇ܟ̰ܚܝܼܬܘܿܢ ܚܡܵܪܬܵ‌ܐ ܐܣܝܼܪܬܵ‌ܐ ܘܓ̰ܲܥܫܵܐ ܥܲܡܘܼܗ̇. ܫܪܹܝܡܘܼܢ ܘܡܲܝܬܹܝܡܘܼܢ ܠܗܘܿܢ ܠܟܸܣܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","”ܘܐܸܢ ܐܢܵܫܵܐ ܐܵܡܹܪ ܐܸܠܵܘܟ݂ܘܿܢ ܡܸܢܕܝܼ، ܐܡܘܿܪܘܼܢ ܐܸܠܹܗ، ܡܵܪܲܢ ܒܵܥܹܐ ܠܗܘܿܢ، ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܒܸܬ ܫܲܕܸܪܗܘܿܢ ܐܸܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ܐܵܗܵܐ ܟܠܵܗ̇ ܗܘܹܐ ܠܵܗ̇ ܕܦܵܐܹܫ ܬܘܼܡܸܡܵܐ ܡܸܢܕܝܼ ܕܐܡܝܼܪܵܐ ܝܗܘܵܐ ܒܝܲܕ ܢܒ݂ܝܼܵܐ ܕܐܡܝܼܪܹܗ: ");
INSERT INTO aii_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ܐܡܘܿܪܘܼܢ ܠܒܪܵܬܵ‌ܐ ܕܨܸܗܝܘܿܢ، ܗܵܐ ܡܲܠܟܵܟ݂ܝ ܒܹܐܬܵܝܵܐ ܝܠܹܗ ܠܟܸܣܠܵܟ݂ܝ، ܡܲܟܝܼܟ݂ܵܐ ܘܪܟܝܼܒ݂ܵܐ ܥܲܠܔ ܚܡܵܪܬܵ‌ܐ، ܘܥܲܠܔ ܓ̰ܲܥܫܵܐ ܙܲܥܝܵܐ ܕܚܡܵܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܬܲܠܡܝܼ̈ܕܹܐ ܘܥܒ݂ܝܼܕ ܠܗܘܿܢ ܕܵܐܟ݂ܝܼ ܕܦܩܝܼܕܵܝ ܠܹܗ ܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܠܚܡܵܪܬܵ‌ܐ ܘܠܓ̰ܲܥܫܵܐ، ܘܡܘܼܬܸܒ݂ ܠܗܘܿܢ ܥܲܠܵܝܗ‌ܝ ܓ̰ܘܼܠܵܝ̈ܗ‌ܝ، ܘܪܟܝܼܒ݂ ܠܹܗ ܥܲܠܵܝܗ‌ܝ ܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ܘܪܵܒܵܐ ܡ̣ܢ ܟܸܢܫܹ̈ܐ ܫܲܘܝܼ ܗܘܵܘ ܓ̰ܘܼܠܵܝ̈ܗ‌ܝ ܒܐܘܼܪܚܵܐ، ܘܐܚܹܪ̈ܢܹܐ ܦܵܪܡܝܼ ܗܘܵܘ ܦܲܥܘܵܢܹ̈ܐ ܡ̣ܢ ܐܝܼܠܵܢܹ̈ܐ ܘܕܵܪܝܼ ܗܘܵܘ ܒܐܘܼܪܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ܘܟܸܢܫܹ̈ܐ ܕܒܹܐܙܵܠܵܐ ܝܗܘܵܘ ܩܲܕܡܘܼܗ‌ܝ ܘܒܵܬܪܹܗ ܡܲܩܘܘܼܚܹܐ ܝܗܘܵܘ: ”ܐܘܿܫܲܥܢܵܐ ܒܪܘܿܢܵܐ ܕܕܵܘܝܼܕ، ܒܪܝܼܟ݂ܵܐ ܝܠܹܗ ܗ̇ܘ ܕܒܹܐܬܵܝܵܐ ܝܠܹܗ ܒܫܸܡܵܐ ܕܡܵܪܝܵܐ، ܐܘܿܫܲܥܢܵܐ ܒܲܡܪ̈ܵܘܡܹܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ܟܲܕ ܥܒ݂ܝܼܪܹܗ ܝܼܫܘܿܥ ܠܐܘܿܪܸܫܠܸܡ، ܫܓ݂ܝܼܫ ܠܗܘܿܢ ܟܠܵܝܗ‌ܝ ܐܢܵܫܹ̈ܐ ܕܡܕܝܼܢ݇ܬܵ‌ܐ، ܘܒܲܩܪܝܼ ܗܘܵܘ، ܡܵܢܝܼ ܝܠܹܗ ܐܵܗܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ܘܟܸܢܫܹ̈ܐ ܐܵܡܪܝܼ ܗܘܵܘ: ”ܐܵܗܵܐ ܝܠܹܗ ܝܼܫܘܿܥ ܢܒ݂ܝܼܵܐ ܡ̣ܢ ܢܵܨܪܲܬ ܕܓܠܝܼܠܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ܥܒ݂ܝܼܪܹܗ ܝܼܫܘܿܥ ܠܗܲܝܟܠܵܐ ܕܐܲܠܵܗܵܐ ܘܦܘܼܠܸܛ ܠܹܗ ܠܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܒܸܙܒ݂ܵܢܵܐ ܝܗܘܵܘ ܘܙܲܒܘܼܢܹܐ ܬܵܡܵܐ، ܘܡܘܼܚܕܸܪܹܗ ܠܦܵܬܘܿܪܹ̈ܐ ܕܨܲܪ̈ܵܦܹܐ ܘܟܘܼܪ̈ܣܝܼܹܐ ܕܐܵܢܝܼ ܕܙܲܒܘܼܢܹܐ ܝܗܘܵܘ ܝܵܘܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܟܬܝܼܒ݂ܵܐ ܝܠܹܗ ܕܒܲܝܬ‌ܝܼ ܒܲܝܬܵ‌ܐ ܕܨܠܘܿܬܵ‌ܐ ܒܸܬ ܦܵܐܹܫ ܩܸܪܝܵܐ، ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ ܥܒ݂ܝܼܕ ܠܵܘܟ݂ܘܿܢ ܓܸܦܝܼܬܵ‌ܐ ܕܓܲܝܵܣܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ܘܡܘܼܩܪܸܒ݂ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܓܵܘ ܗܲܝܟܠܵܐ ܣܸܡܝܹ̈ܐ ܘܫܦܝܼܠܹ̈ܐ، ܘܒܘܼܣܡܵܝ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ܟܲܕ ܚܙܹܐ ܠܗܘܿܢ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܣܵܦܪܹ̈ܐ ܘܦܪ̈ܝܼܫܹܐ ܕܘܼܡܵܪܹ̈ܐ ܕܒܸܥܒ݂ܵܕܵܐ ܝܗܘܵܐ، ܘܝܵܠܹ̈ܕ݇ܐ ܡܲܩܘܘܼܚܹܐ ܒܗܲܝܟܠܵܐ: ”ܐܘܿܫܲܥܢܵܐ ܒܪܘܿܢܵܐ ܕܕܵܘܝܼܕ،“ ܟܪܝܼܒ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܒܸܫܡܵܥܵܐ ܝܘܸܬ ܡܘܼܕܝܼ ܝܢܵܐ ܒܹܐܡܵܪܵܐ؟“ ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ: ”ܗܹܐ. ܠܵܐ ܩܪܹܐ ܠܵܘܟ݂ܘܿܢ ܡܘܼܕܝܼ ܝܠܹܗ ܟܬܝܼܒ݂ܵܐ: ܡ̣ܢ ܦܘܼܡܵܐ ܕܝܵܠܹ̈ܕ݇ܐ ܘܝܲܠܘܼܕܹ̈ܐ ܬܘܼܪܸܨ ܠܘܼܟ݂ ܬܸܫܒܘܿܚܬܵ‌ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ܘܦܠܝܼܛ ܠܹܗ ܠܒܲܕܲܪ ܡ̣ܢ ܡܕܝܼܢ݇ܬܵ‌ܐ ܠܒܹܝܬ ܥܲܢܝܵܐ ܘܦܝܼܫ ܠܹܗ ܬܵܡܵܐ ܒܠܲܝܠܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ܘܩܲܝܕܵܡܬܵ‌ܐ ܐܝܼܡܲܢ ܕܝܼܪܹܗ ܠܡܕܝܼܢ݇ܬܵ‌ܐ، ܟܦܝܼܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ܘܚܙܹܐ ܠܹܗ ܚܲܕ ܐܝܼܠܵܢܵܐ ܕܬܹܐܢܹ̈ܐ ܒܐܘܼܪܚܵܐ، ܘܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣܠܹܗ ܐܝܼܢܵܐ ܠܵܐ ܡܘܼܫ݇ܟ̰ܸܚ ܠܹܗ ܒܝܼܹܗ ܛܥܘܼܢܬܵ‌ܐ ܐܸܠܵܐ ܛܲܪ̈ܦܹܐ، ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܠܵܐ ܗܵܘܝܼ ܐܚܹܪܢܵܐ ܒܝܼܘܼܟ݂ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܗܲܠܔ ܥܵܠܲܡ.“ ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܒܪܝܼܙ ܠܹܗ ܗ̇ܘ ܐܝܼܠܵܢܵܐ ܕܬܹܐܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ܟܲܕ ܚܙܹܐ ܠܗܘܿܢ ܬܲܠܡܝܼ̈ܕܹܐ ܥܘܼܓ̰ܸܒ ܠܗܘܿܢ ܘܐܡܝܼܪܗܘܿܢ: ”ܕܵܐܟ݂ܝܼ ܒܓ̰ܲܠܕܘܼܬܵ‌ܐ ܒܪܝܼܙ ܠܹܗ ܐܵܗܵܐ ܐܝܼܠܵܢܵܐ ܕܬܹܐܢܹ̈ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܸܢ ܗܵܘܹܐ ܠܵܘܟ݂ܘܿܢ ܗܲܝܡܵܢܘܼܬܵ‌ܐ ܘܠܵܐ ܗܵܘܹܐ ܦܘܼܠܵܓ݂ܵܐ ܒܚܘܼܫܵܒ݂ܵܘ̈ܟ݂ܘܿܢ، ܠܵܐ ܠܐܵܗܵܐ ܐܝܼܠܵܢܵܐ ܐܝܼܢܵܐ ܐܘܼܦ ܠܐܵܗܵܐ ܛܘܼܪܵܐ ܐܸܢ ܐܵܡܪܝܼܬܘܿܢ: ’ܦܘܼܫ ܫܩܝܼܠܵܐ ܘܪܘܼܦܝܵܐ ܒܝܵܡܵܐ،‘ ܒܸܬ ܗܵܘܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","”ܘܟܠܔ ܡܸܢܕܝܼ ܕܛܵܠܒܝܼܬܘܿܢ ܒܨܠܘܿܬܵ‌ܐ ܘܒܗܲܝܡܵܢܘܼܬܵ‌ܐ ܒܸܬ ܩܲܒܠܝܼܬܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ܘܥܒ݂ܝܼܪܹܗ ܝܼܫܘܿܥ ܠܗܲܝܟܠܵܐ. ܘܟܲܕ ܡܲܠܘܼܦܹܐ ܝܗܘܵܐ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܚܘܵܪ̈ܕܸܩܢܹܐ ܕܥܲܡܵܐ ܘܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ: ”ܒܐܲܝܢܝܼ ܫܘܼܠܛܵܢܵܐ ܒܸܥܒ݂ܵܕܵܐ ܝܘܸܬ ܐܲܢܹܐ؟ ܡܵܢܝܼ ܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܘܼܟ݂ ܐܵܗܵܐ ܫܘܼܠܛܵܢܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܐܘܼܦ ܐܵܢܵܐ ܒܸܬ ܒܲܩܪܸܢܵܘܟ݂ܘܿܢ ܚܲܕ ܒܘܼܩܵܪܵܐ، ܘܐܸܢ ܓ̰ܲܘܸܒܝܼܬܘܿܢ ܠܝܼ ܐܘܼܦ ܐܵܢܵܐ ܒܸܬ ܐܵܡܪܹܢ ܐܸܠܵܘܟ݂ܘܿܢ ܒܐܲܝܢܝܼ ܫܘܼܠܛܵܢܵܐ ܒܸܥܒ݂ܵܕܵܐ ܝܘܸܢ ܐܲܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","”ܡܲܥܡܘܿܕܝܼܬܵ‌ܐ ܕܝܘܿܚܲܢܵܢ ܡ̣ܢ ܐܲܝܟܵܐ ܝܗܘܵܐ، ܡ̣ܢ ܐܲܠܵܗܵܐ ܝܲܢ ܡ̣ܢ ܒܢܲܝ̈ܢܵܫܵܐ؟“ ܐܝܼܢܵܐ ܐܵܢܝܼ ܚܫܝܼܒ݂ ܠܗܘܿܢ ܓܵܘ ܓܵܢܵܝܗ‌ܝ ܒܹܐܡܵܪܵܐ، ”ܐܸܢ ܐܵܡܪܲܚ: ’ܡ̣ܢ ܐܲܠܵܗܵܐ،‘ ܒܸܬ ܐܵܡܹܪ ܐܸܠܲܢ: ’ܒܵܣ ܩܵܡܘܿܕܝܼ ܠܵܐ ܗܘܼܡܸܢܵܘܟ݂ܘܿܢ ܒܝܼܹܗ؟‘ ");
INSERT INTO aii_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","”ܘܐܸܢ ܐܵܡܪܲܚ: ’ܡ̣ܢ ܒܢܲܝ̈ܢܵܫܵܐ،‘ ܒܸܙܕܵܥܵܐ ܝܘܲܚ ܡ̣ܢ ܟܸܢܫܵܐ، ܣܵܒܵܒ ܟܠܵܝܗ‌ܝ ܐܲܝܟ݂ ܢܒ݂ܝܼܵܐ ܟܹܐ ܚܵܫܒ݂ܝܼ ܠܝܘܿܚܲܢܵܢ.“ ");
INSERT INTO aii_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܠܹܐ ܝܵܕܥܲܚ.“ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܐܘܼܦ ܐܵܢܵܐ ܠܹܐ ܐܵܡܪܹܢܵܘܟ݂ܘܿܢ ܒܐܲܝܢܝܼ ܫܘܼܠܛܵܢܵܐ ܒܸܥܒ݂ܵܕܵܐ ܝܘܸܢ ܐܲܢܹܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܡܘܼܕܝܼ ܒܸܚܫܵܒ݂ܵܐ ܝܬܘܿܢ ܒܘܼܬ ܐܵܗܵܐ؟ ܚܲܕ ܐܢܵܫܵܐ ܐܝܼܬ ܗܘܵܐ ܠܹܗ ܬܪܹܝ ܒܢܘܿܢܹ̈ܐ. ܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣ ܗ̇ܘ ܩܲܕܡܵܝܵܐ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ’ܒܪܘܿܢܝܼ، ܙܹܠܔ݇ ܐܸܕܝܘܿܡ ܘܦܠܘܿܚ ܓܵܘ ܟܲܪܡܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","”ܐܝܼܢܵܐ ܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ ܘܐܡܝܼܪܹܗ: ’ܠܹܐ ܐܵܙܹܠ݇ܢ.‘ ܐܝܼܢܵܐ ܒܚܲܪܬܵ‌ܐ ܦܫܝܼܡ ܠܹܗ ܘܐܙܝܼܠܔ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","”ܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣ ܗ̇ܘ ܬܪܲܝܵܢܵܐ ܘܛܠܝܼܒ ܠܹܗ ܡܸܢܹܗ ܕܐܵܙܹܠܔ ܘܦܵܠܹܚ ܓܵܘ ܟܲܪܡܹܗ. ܘܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ ܘܐܡܝܼܪܹܗ: ’ܗܹܐ ܒܵܒܝܼ، ܒܸܬ ܐܵܙܹܠ݇ܢ،‘ ܐܝܼܢܵܐ ܠܵܐ ܐܙܝܼܠܔ ܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܐܲܝܢܝܼ ܡ̣ܢ ܐܲܢܹܐ ܬܪܹܝ ܥܒ݂ܝܼܕ ܠܹܗ ܒܚܲܒܪܵܐ ܕܒܵܒܘܼܗ‌ܝ؟“ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܐܸܠܹܗ: ”ܗ̇ܘ ܩܲܕܡܵܝܵܐ.“ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܡܵܟ݂ܣܹ̈ܐ ܘܙܵܢܝܵܬܹ̈‌ܐ ܡ̣ܢ ܩܲܕܡ ܕܝܼܵܘܟ݂ܘܿܢ ܒܸܥܒ݂ܵܪܵܐ ܝܢܵܐ ܠܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","”ܣܵܒܵܒ ܐܬܹ‌ܐ ܠܹܗ ܝܘܿܚܲܢܵܢ ܡܲܥܡܕܵܢܵܐ ܠܟܸܣܠܵܘܟ݂ܘܿܢ ܡܲܟܪܘܼܙܹܐ ܙܲܕܝܼܩܘܼܬܵ‌ܐ ܘܠܵܐ ܗܘܼܡܸܢܵܘܟ݂ܘܿܢ ܒܝܼܹܗ. ܐܝܼܢܵܐ ܡܵܟ݂ܣܹ̈ܐ ܘܙܵܢܝܵܬܹ̈‌ܐ ܗܘܼܡܸܢܗܘܿܢ ܒܝܼܹܗ. ܐܲܚܬܘܿܢ ܐܵܦܸܢ ܕܚܙܹܐ ܠܵܘܟ݂ܘܿܢ، ܒܚܲܪܬܵ‌ܐ ܠܵܐ ܦܫܝܼܡ ܠܵܘܟ݂ܘܿܢ ܕܗܲܡܸܢܝܼܬܘܿܢ ܗܘܵܘ ܒܝܼܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ܘܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܡܲܬܠܵܐ ܐܚܹܪܢܵܐ: ”ܐܝܼܬ ܗܘܵܐ ܚܲܕ ܐܢܵܫܵܐ ܡܵܪܵܐ ܕܒܲܝܬܵ‌ܐ، ܕܢܨܝܼܒ݂ ܠܹܗ ܟܲܪܡܵܐ ܘܡܚܹܐ ܠܹܗ ܠܚܵܕܸܪ̈ܘܵܢܘܼܗ‌ܝ ܣܝܵܓ݂ܵܐ، ܘܚܦܝܼܪܹܗ ܓܵܘܹܗ ܡܲܥܨܲܪܬܵ‌ܐ، ܘܒܢܹܐ ܠܹܗ ܓܵܘܹܗ ܒܘܼܪܓ̰ܵܐ، ܘܣܘܼܦܹܐ ܠܹܗ ܠܦܲܠܵܚܹ̈ܐ، ܘܐܙܝܼܠܔ ܠܹܗ ܒܣܵܦܵܪ. ");
INSERT INTO aii_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","”ܘܟܲܕ ܡܛܹܐ ܠܹܗ ܙܲܒ݂ܢܵܐ ܕܛܥܘܼܢܝܵܬܹ̈‌ܐ، ܫܘܼܕܸܪܹܗ ܠܪܹ̈ܓܵܘܵܬܘܼܗ‌ܝ ܠܟܸܣ ܦܲܠܵܚܹ̈ܐ ܕܫܵܩܠܝܼ ܗܘܵܘ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܡ̣ܢ ܟܲܪܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","”ܐܝܼܢܵܐ ܦܲܠܵܚܹ̈ܐ ܕܒ݂ܝܼܩ ܠܗܘܿܢ ܠܪܹ̈ܓܵܘܵܬܹ‌ܐ، ܡܚܹܐ ܠܗܘܿܢ ܠܚܲܕ، ܘܪܓ̰ܝܼܡ ܠܗܘܿܢ ܠܚܲܕ ܐܚܹܪܢܵܐ ܘܩܛܝܼܠܔ ܠܗܘܿܢ ܠܗ̇ܘ ܐܚܹܪܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","”ܓܵܗܵܐ ܕܬܲܪܬܹܝ ܫܘܼܕܸܪܹܗ ܪܹ̈ܓܵܘܵܬܹ‌ܐ ܐܚܹܪ̈ܢܹܐ ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܩܲܕܡܵܝܹ̈ܐ، ܐܝܼܢܵܐ ܦܲܠܵܚܹ̈ܐ ܥܒ݂ܝܼܕ ܠܗܘܿܢ ܒܝܼܵܝܗ‌ܝ ܡܐܲܝܟ݂ ܕܐܵܢܝܼ ܩܲܕܡܵܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","”ܒܚܲܪܬܵ‌ܐ ܫܘܼܕܸܪܹܗ ܠܟܸܣܠܵܝܗ‌ܝ ܒܪܘܿܢܹܗ ܒܹܐܡܵܪܵܐ: ’ܩܵܘܡܵܐ ܕܢܵܟ݂ܦܝܼ ܡ̣ܢ ܒܪܘܿܢܝܼ.‘ ");
INSERT INTO aii_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","”ܐܝܼܢܵܐ ܦܲܠܵܚܹ̈ܐ ܟܲܕ ܚܙܹܐ ܠܗܘܿܢ ܠܒܪܘܿܢܵܐ، ܐܡܝܼܪܗܘܿܢ ܒܓܵܢܵܝܗ‌ܝ: ’ܐܵܗܵܐ ܝܠܹܗ ܝܵܪܘܿܬܵ‌ܐ، ܬܹܝܡܘܼܢ ܩܵܛܠܲܚ ܠܹܗ، ܘܫܵܩܠܲܚ ܠܝܵܪܬܘܼܬܵ‌ܐ.‘ ");
INSERT INTO aii_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","”ܕܒ݂ܝܼܩ ܠܗܘܿܢ ܘܦܘܼܠܸܛ ܠܗܘܿܢ ܠܒܲܕܲܪ ܡ̣ܢ ܟܲܪܡܵܐ ܘܩܛܝܼܠܔ ܠܗܘܿܢ ܐܸܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܐܝܼܡܲܢ ܕܐܵܬܹ‌ܐ ܡܵܪܵܐ ܕܟܲܪܡܵܐ، ܡܘܼܕܝܼ ܒܸܬ ܥܵܒܹܕ ܠܐܵܢܝܼ ܦܲܠܵܚܹ̈ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܐܸܠܹܗ: ”ܣܸܪܝܵܐ ܒܸܬ ܛܲܠܸܩ ܠܗܘܿܢ ܐܵܢܝܼ ܒܝܼܫܹ̈ܐ، ܘܟܲܪܡܵܐ ܒܸܬ ܝܵܗܒܹܠܔ ܠܹܗ ܠܦܲܠܵܚܹ̈ܐ ܐܚܹܪ̈ܢܹܐ، ܐܲܝܢܝܼ ܕܝܵܗܒ݂ܝܼ ܠܹܗ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܒܙܲܒ݂ܢܵܝܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܗܵܐ ܠܵܐ ܩܪܹܐ ܠܵܘܟ݂ܘܿܢ ܒܟܬܵܒܹ̈ܐ، ܕܟܹܐܦܵܐ ܕܡܘܼܣܠܹܐ ܠܗܘܿܢ ܒܲܢܵܝܹ̈ܐ، ܗ̇ܘ ܗܘܹܐ ܠܹܗ ܟܹܐܦܵܐ ܕܩܘܼܪܢܝܼܬܵ‌ܐ؟ ܡ̣ܢ ܡܵܪܝܵܐ ܝܗܘܵܐ ܐܵܗܵܐ، ܘܥܘܼܓ̰ܵܒܵܐ ܝܠܹܗ ܒܥܲܝܢܲܢ̈. ");
INSERT INTO aii_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","”ܒܘܼܬ ܐܵܗܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܒܸܬ ܦܵܝܫܵܐ ܫܩܝܼܠܬܵ‌ܐ ܡܸܢܵܘܟ݂ܘܿܢ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ ܘܒܸܬ ܦܵܝܫܵܐ ܝܘܼܗܒܹܠܬܵ‌ܐ ܠܐܘܼܡܬܵ‌ܐ ܕܝܵܗܒ݂ܵܐ ܛܥܘܼܢܝܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","”ܟܠܔ ܡ̇ܢ ܕܢܵܦܹܠܔ ܥܲܠܔ ܐܵܗܵܐ ܟܹܐܦܵܐ ܒܸܬ ܦܵܐܹܫ ܫܡܝܼܛܵܐ، ܘܟܠܔ ܡ̇ܢ ܕܥܲܠܘܼܗ‌ܝ ܢܵܦܹܠܔ ܐܵܗܵܐ ܟܹܐܦܵܐ ܒܸܬ ܦܵܐܹܫ ܛܒ݂ܝܼܚܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ܟܲܕ ܫܡܝܼܥ ܠܗܘܿܢ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܦܪ̈ܝܼܫܹܐ ܐܲܢܹܐ ܡܲܬܠܘܼ̈ܗ‌ܝ، ܝܕܝܼܥ ܠܗܘܿܢ ܕܥܲܠܵܝܗ‌ܝ ܗܘܼܡܙܸܡ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ܘܒܥܹܐ ܠܗܘܿܢ ܠܸܕܒ݂ܵܩܹܗ ܐܝܼܢܵܐ ܙܕܝܼܥ ܠܗܘܿܢ ܡ̣ܢ ܟܸܢܫܵܐ، ܣܵܒܵܒ ܐܲܝܟ݂ ܢܒ݂ܝܼܵܐ ܟܹܐ ܚܵܫܒ݂ܝܼ ܗܘܵܘ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ܡܸܢܕܪܸܫ ܗܘܼܡܙܸܡ ܠܹܗ ܝܼܫܘܿܥ ܒܡܲܬܠܹ̈ܐ ܘܐܡܝܼܪܹܗ: ");
INSERT INTO aii_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","”ܟܹܐ ܕܵܡܝܵܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ ܠܚܲܕ ܡܲܠܟܵܐ ܕܥܒ݂ܝܼܕ ܠܹܗ ܚܠܘܼܠܵܐ ܩܵܐ ܒܪܘܿܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","”ܘܫܘܼܕܸܪܹܗ ܠܪܹ̈ܓܵܘܵܬܘܼܗ‌ܝ ܕܩܵܪܝܼ ܠܗܘܿܢ ܟ̰ܝܼܕܹܐ ܠܚܠܘܼܠܵܐ، ܐܝܼܢܵܐ ܐܵܢܝܼ ܠܵܐ ܒܥܹܐ ܠܗܘܿܢ ܕܐܵܬ‌ܝܼ ܗܘܵܘ. ");
INSERT INTO aii_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","”ܡܸܢܕܪܸܫ ܫܘܼܕܸܪܹܗ ܪܹ̈ܓܵܘܵܬܹ‌ܐ ܐܚܹܪ̈ܢܹܐ ܒܹܐܡܵܪܵܐ: ’ܐܡܘܿܪܘܼܢ ܠܟ̰ܝܼ̈ܕܹܐ: ”ܗܵܐ ܚܠܘܼܠܵܐ ܗܘܼܕܪܹܗ ܝܘܸܢ، ܘܛܪ̈ܝܼܨܝܼ ܦܪܝܼܡܵܝ ܝܘܸܢ، ܟܠܔ ܡܸܢܕܝܼ ܗܘܼܕܪܵܐ ܝܠܹܗ، ܬܹܝܡܘܼܢ ܠܚܠܘܼܠܵܐ.“‘ ");
INSERT INTO aii_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","”ܐܝܼܢܵܐ ܐܵܢܝܼ ܡܘܼܣܠܹܐ ܠܗܘܿܢ ܐܸܠܵܝܗ‌ܝ ܘܐܙܝܼܠܔ ܠܗܘܿܢ، ܐܝܼܬ ܗܘܵܐ ܕܐܙܝܼܠܔ ܠܹܗ ܠܚܲܩܠܹܗ، ܘܐܝܼܬ ܗܘܵܐ ܕܐܙܝܼܠܔ ܠܹܗ ܠܬܲܓܵܪܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","”ܘܣܵܗܡܵܐ ܦܝܼܫܵܐ ܕܟ̰ܝܼ̈ܕܹܐ ܕܒ݂ܝܼܩ ܠܗܘܿܢ ܠܪܹ̈ܓܵܘܵܬܹ‌ܐ، ܡܘܼܣܠܹܐ ܠܗܘܿܢ ܐܸܠܵܝܗ‌ܝ ܘܩܛܝܼܠܵܝ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","”ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܹܗ ܡܲܠܟܵܐ، ܟܪܝܼܒ ܠܹܗ. ܘܫܘܼܕܸܪܹܗ ܚܲܝܠܵܘܵܬܹ̈‌ܐ ܘܛܘܼܠܸܩ ܠܹܗ ܠܐܵܢܝܼ ܩܵܛܘܿܠܹ̈ܐ، ܘܠܡܕܝܼܢܵܬܵܝ̈ܗ‌ܝ ܡܘܼܩܸܕ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","”ܗ̇ܝܓܵܗ ܐܡܝܼܪܹܗ ܡܲܠܟܵܐ ܠܪܹ̈ܓܵܘܵܬܘܼܗ‌ܝ: ’ܚܠܘܼܠܵܐ ܗܘܼܕܪܵܐ ܝܠܹܗ، ܘܐܵܢܝܼ ܕܦܝܼܫܹܐ ܝܗܘܵܘ ܟ̰ܝܼܕܹܐ ܠܹܐ ܝܗܘܵܘ ܚܫܝܼܚܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","’ܐܝܼܢܵܐ ܙܹܠ݇ܡܘܼܢ ܠܦܪܵܫܬܵ‌ܐ ܕܐܘܼܪ̈ܚܵܬܹ‌ܐ، ܘܟܠܔ ܡ̇ܢ ܕܚܵܙܹܝܬܘܿܢ ܩܪܹܝܡܘܼܢ ܠܹܗ ܠܚܠܘܼܠܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","”ܘܦܠܝܼܛ ܠܗܘܿܢ ܐܵܢܝܼ ܪܹ̈ܓܵܘܵܬܹ‌ܐ ܠܐܘܼܪ̈ܚܵܬܹ‌ܐ ܘܓ̰ܘܼܡܸܥ ܠܗܘܿܢ ܟܠܔ ܡ̇ܢ ܕܡܘܼܫ݇ܟ̰ܸܚ ܠܗܘܿܢ، ܒܝܼܫܹ̈ܐ ܘܛܵܒܹ̈ܐ، ܘܦܝܼܫ ܠܹܗ ܡܸܠܝܵܐ ܒܲܝܬܵ‌ܐ ܕܚܠܘܼܠܵܐ ܡ̣ܢ ܐܲܪ̈ܚܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","”ܟܲܕ ܥܒ݂ܝܼܪܹܗ ܡܲܠܟܵܐ ܠܸܚܙܵܝܵܐ ܠܐܲܪ̈ܚܹܐ، ܚܙܹܐ ܠܹܗ ܬܵܡܵܐ ܚܲܕ ܐܢܵܫܵܐ ܕܠܹܐ ܝܗܘܵܐ ܠܒ݂ܝܼܫܵܐ ܠܒ݂ܝܼܫܬܵ‌ܐ ܕܚܠܘܼܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","”ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ’ܚܲܒ݂ܪܝܼ، ܕܵܐܟ݂ܝܼ ܥܒ݂ܝܼܪܘܼܟ݂ ܠܲܐܟ݂ܵܐ ܟܲܕ ܠܒ݂ܝܼܫܬܵ‌ܐ ܕܚܠܘܼܠܵܐ ܠܲܝܬ ܠܘܼܟ݂؟‘ ܐܝܼܢܵܐ ܗ̇ܘ ܦܝܼܫ ܠܹܗ ܫܬܝܼܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","”ܗ̇ܝܓܵܗ ܦܩܝܼܕ ܠܹܗ ܡܲܠܟܵܐ ܠܪܹ̈ܓܵܘܵܬܘܼܗ‌ܝ: ’ܐܣܘܿܪܘܼܢ ܐܝܼܕܵܬܘܼ̈ܗ‌ܝ ܘܐܲܩܠܵܬܘܼ̈ܗ‌ܝ، ܘܕܪܹܝܡܘܼܢ ܠܹܗ ܓܵܘ ܚܸܫܟܵܐ ܒܲܪܵܝܵܐ ܐܲܝܟܵܐ ܕܐܝܼܬ ܒܸܟ݂ܝܵܐ ܘܚܲܪܚܲܟ̰ܬܵ‌ܐ ܕܟܹܟܹ̈ܐ.‘ ");
INSERT INTO aii_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","”ܣܵܒܵܒ ܪܵܒܵܐ ܝܢܵܐ ܟ̰ܝܼ̈ܕܹܐ ܘܒܵܨܘܿܪܹ̈ܐ ܝܢܵܐ ܓܘܼܒܝܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ܗ̇ܝܓܵܗ ܐܙܝܼܠܔ ܠܗܘܿܢ ܦܪ̈ܝܼܫܹܐ ܘܣܘܼܙܓܸܪܗܘܿܢ ܕܵܐܟ݂ܝܼ ܡܲܢܦܸܠܝܼ ܗܘܵܘ ܠܹܗ ܒܗܹܡܸܙܡܵܢ. ");
INSERT INTO aii_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ܫܘܼܕܸܪܗܘܿܢ ܠܟܸܣܠܹܗ ܬܲܠܡܝܼܕܵܝ̈ܗ‌ܝ ܘܐܢܵܫܹ̈ܐ ܡ̣ܢ ܒܹܝܬ ܗܹܪܘܿܕܸܣ، ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܡܲܠܦܵܢܵܐ، ܒܝܼܕܵܥܵܐ ܝܘܲܚ ܕܫܲܪܝܼܪܵܐ ܝܘܸܬ، ܘܐܘܼܪܚܵܐ ܕܐܲܠܵܗܵܐ ܒܫܲܪܝܼܪܘܼܬܵ‌ܐ ܡܲܠܘܼܦܘܼܗ̇ ܝܘܸܬ، ܘܠܹܐ ܬܲܚܡܸܢܸܬ ܡܘܼܕܝܼ ܐܢܵܫܹ̈ܐ ܒܸܬ ܐܵܡܪܝܼ، ܘܠܹܐ ܝܘܸܬ ܡܲܫܦܸܪܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","”ܐܡܘܿܪ ܐܸܠܲܢ، ܡܘܼܕܝܼ ܒܸܚܫܵܒ݂ܵܐ ܝܘܸܬ: ܩܵܢܘܿܢܵܝܬܵ‌ܐ ܝܠܵܗ̇ ܕܝܵܗܒܲܚ ܟܸܣܦܵܐ ܕܪܹܝܫܵܐ ܠܩܹܣܲܪ ܝܲܢ ܠܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܝܕܝܼܥ ܠܹܗ ܒܝܼܫܘܼܬܵܝܗ‌ܝ ܘܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܩܵܡܘܿܕܝܼ ܓ̰ܲܪܘܼܒܝܼ ܝܬܘܿܢ ܝܵܐ ܡܲܫܦܸܪ̈ܵܢܹܐ؟ ");
INSERT INTO aii_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","”ܡܲܚܙܹܝܡܘܼܢ ܠܝܼ ܙܘܼܙܵܐ ܕܟܸܣܦܵܐ ܕܪܹܝܫܵܐ.“ ܘܐܵܢܝܼ ܡܘܼܚܙܹܐ ܠܗܘܿܢ ܐܸܠܹܗ ܕܝܼܢܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ܘܒܘܼܩܪܵܝ ܠܹܗ ܝܼܫܘܿܥ: ”ܕܡܵܢܝܼ ܝܠܵܗ̇ ܐܵܗܵܐ ܨܘܼܪܬܵ‌ܐ، ܘܕܡܵܢܝܼ ܝܠܵܗ̇ ܐܵܗܵܐ ܟܬܝܼܒ݂ܬܵ‌ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ܘܐܵܢܝܼ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ: ”ܕܩܹܣܲܪ.“ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܗܲܒ݂ܠܘܼܢ ܗܵܕܟ݂ܵܐ ܡܸܢܕܝܼ ܕܩܹܣܲܪ ܠܩܹܣܲܪ، ܘܡܸܢܕܝܼ ܕܐܲܠܵܗܵܐ ܠܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ܘܐܵܢܝܼ ܟܲܕ ܫܡܝܼܥ ܠܗܘܿܢ ܐܵܗܵܐ، ܥܘܼܓ̰ܸܒ ܠܗܘܿܢ، ܘܫܒ݂ܝܼܩ ܠܗܘܿܢ ܐܸܠܹܗ ܘܐܙܝܼܠܔ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ܒܗ̇ܘ ܝܵܘܡܵܐ ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣ ܝܼܫܘܿܥ ܙܲܕܘܼܩܵܝܹ̈ܐ، ܕܠܹܐ ܗܲܡܸܢܝܼ ܒܩܝܵܡܬܵ‌ܐ ܕܡܝܼ̈ܬܹ‌ܐ، ܘܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ، ");
INSERT INTO aii_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ܒܹܐܡܵܪܵܐ: ”ܡܲܠܦܵܢܵܐ، ܡܘܼܫܹܐ ܡܘܼܠܸܦ ܠܹܗ ܐܸܠܲܢ، ܕܐܸܢ ܐܢܵܫܵܐ ܡܵܐܹܬ ܟܲܕ ܠܲܝܬ ܠܹܗ ܒܢܘܿܢܹ̈ܐ، ܐܲܚܘܿܢܘܼܗ‌ܝ ܓܵܒܹܪ ܠܒܲܟ݂ܬܹܗ، ܘܡܲܩܸܡ ܒܢܘܿܢܹ̈ܐ ܠܐܲܚܘܿܢܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","”ܐܝܼܬ ܗܘܵܘ ܠܟܸܣܠܲܢ ܫܲܒ݂ܥܵܐ ܐܲܚܘܿܢܘܵܬܹ̈‌ܐ. ܗ̇ܘ ܩܲܕܡܵܝܵܐ ܓܒ݂ܝܼܪܹܗ ܒܲܟ݂ܬܵ‌ܐ ܘܡܝܼܬ ܠܹܗ، ܘܠܲܝܬ ܗܘܵܐ ܠܹܗ ܒܢܘܿܢܹ̈ܐ، ܘܫܒ݂ܝܼܩܵܐ ܠܹܗ ܒܲܟ݂ܬܹܗ ܠܐܲܚܘܿܢܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","”ܗܵܕܟ݂ܵܐ ܐܘܼܦ ܗ̇ܘ ܕܬܪܹܝ، ܐܘܼܦ ܗ̇ܘ ܕܬܠܵܬܵ‌ܐ، ܗܲܠܔ ܗ̇ܘ ܕܫܲܒ݂ܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","”ܒܚܲܪܬܵ‌ܐ ܟܠܵܝܗ‌ܝ ܡܝܼܬ ܠܗܘܿܢ، ܐܘܼܦ ܒܲܟ݂ܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","”ܒܩܝܵܡܬܵ‌ܐ، ܠܐܲܝܢܝܼ ܡ̣ܢ ܐܲܢܹܐ ܫܲܒ݂ܥܵܐ ܒܸܬ ܗܵܘܝܵܐ ܒܲܟ݂ܬܵ‌ܐ؟ ܣܵܒܵܒ ܟܠܵܝܗ‌ܝ ܓܒ݂ܝܼܪܵܐ ܠܗܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܒܸܚܠܵܛܵܐ ܝܬܘܿܢ ܣܵܒܵܒ ܠܹܐ ܝܬܘܿܢ ܒܝܼܕܵܥܵܐ ܟܬܵܒܹ̈ܐ ܘܐܘܼܦ ܠܵܐ ܚܲܝܠܵܐ ܕܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","”ܣܵܒܵܒ ܒܩܝܵܡܬܵ‌ܐ، ܓܲܒ݂ܪܹ̈ܐ ܠܹܐ ܫܵܩܠܝܼ ܒܲܟ݂ܬܵܬܹ̈‌ܐ ܘܒܲܟ݂ܬܵܬܹ̈‌ܐ ܠܹܐ ܫܵܩܠܝܼ ܓܲܒ݂ܪܹ̈ܐ. ܐܸܠܵܐ ܟܠܵܝܗ‌ܝ ܐܲܝܟ݂ ܡܲܠܲܐܟܹ̈ܐ ܕܐܲܠܵܗܵܐ ܒܸܬ ܗܵܘܝܼ ܒܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","”ܒܘܼܬ ܩܝܵܡܬܵ‌ܐ ܕܡܝܼ̈ܬܹ‌ܐ ܠܵܐ ܩܪܹܐ ܠܵܘܟ݂ܘܿܢ ܡܸܢܕܝܼ ܕܦܝܼܫ ܠܹܗ ܐܡܝܼܪܵܐ ܐܸܠܵܘܟ݂ܘܿܢ ܡ̣ܢ ܐܲܠܵܗܵܐ ܒܹܐܡܵܪܵܐ: ");
INSERT INTO aii_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","”’ܐܵܢܵܐ ܝܘܸܢ ܐܲܠܵܗܵܐ ܕܐܲܒ݂ܪܵܗܵܡ، ܐܲܠܵܗܵܐ ܕܐܝܼܣܚܵܩ، ܐܲܠܵܗܵܐ ܕܝܲܥܩܘܿܒ݂.‘ ܐܲܠܵܗܵܐ ܠܹܐ ܝܠܹܗ ܐܲܠܵܗܵܐ ܕܡܝܼ̈ܬܹ‌ܐ، ܐܸܠܵܐ ܕܚܵܝܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ܘܟܲܕ ܫܡܝܼܥ ܠܗܘܿܢ ܟܸܢܫܹ̈ܐ ܐܲܢܹܐ ܚܲܒܪܹ̈ܐ، ܥܘܼܓ̰ܸܒ ܠܗܘܿܢ ܒܝܘܼܠܦܵܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܗܘܿܢ ܦܪ̈ܝܼܫܹܐ ܕܡܘܼܫܬܸܩ ܠܹܗ ܠܙܲܕܘܼܩܵܝܹ̈ܐ، ܓ̰ܡܝܼܥ ܠܗܘܿܢ ܡܥܘܼܕܵܠܹܐ، ");
INSERT INTO aii_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ܘܚܲܕ ܡܸܢܵܝܗ‌ܝ ܕܝܼܗܘܵܐ ܢܵܡܘܿܣܵܝܵܐ ܒܘܼܩܸܪܹܗ ܠܓ̰ܲܪܘܼܒܹܗ، ܒܹܐܡܵܪܵܐ: ");
INSERT INTO aii_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","”ܡܲܠܦܵܢܵܐ، ܐܲܝܢܝܼ ܦܘܼܩܕܵܢܵܐ ܒܘܼܫ ܓܘܼܪܵܐ ܝܠܹܗ ܒܢܵܡܘܿܣܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ: ”ܡܲܚܸܒܸܬ ܠܡܵܪܝܵܐ ܐܲܠܵܗܘܼܟ݂ ܡ̣ܢ ܟܠܹܗ ܠܸܒܘܼܟ݂، ܘܡ̣ܢ ܟܠܵܗ̇ ܓܵܢܘܼܟ݂، ܘܡ̣ܢ ܟܠܵܝܗ‌ܝ ܚܘܼܫܵܒ݂ܘܼ̈ܟ݂. ");
INSERT INTO aii_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","”ܐܵܗܵܐ ܝܠܹܗ ܗ̇ܘ ܦܘܼܩܕܵܢܵܐ ܓܘܼܪܵܐ ܘܩܲܕܡܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","”ܘܗ̇ܘ ܕܬܪܹܝ ܟܹܐ ܕܵܡܹܐ ܐܸܠܹܗ: ܡܲܚܸܒܸܬ ܠܫܒ݂ܵܒ݂ܘܼܟ݂ ܐܲܝܟ݂ ܓܵܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","”ܥܲܠܔ ܐܲܢܹܐ ܬܪܹܝ ܦܘܼܩܕܵܢܹ̈ܐ ܒܸܢܝܹܐ ܝܢܵܐ ܢܵܡܘܿܣܵܐ ܘܢܒ݂ܝܼܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ܟܲܕ ܓ̰ܡܝܼܥܹܐ ܝܗܘܵܘ ܦܪ̈ܝܼܫܹܐ، ܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ ܝܼܫܘܿܥ: ");
INSERT INTO aii_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","”ܡܘܼܕܝܼ ܒܸܚܫܵܒ݂ܵܐ ܝܬܘܿܢ ܒܘܼܬ ܡܫܝܼܚܵܐ، ܒܪܘܿܢܵܐ ܕܡܵܢܝܼ ܝܠܹܗ؟“ ܘܐܵܢܝܼ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ: ”ܒܪܘܿܢܵܐ ܕܕܵܘܝܼܕ.“ ");
INSERT INTO aii_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܒܵܣ ܕܵܐܟ݂ܝܼ ܕܵܘܝܼܕ ܒܪܘܼܚܵܐ ܒܸܩܪܵܝܹܗ ܝܠܹܗ ܡܵܪܝܵܐ، ܒܹܐܡܵܪܵܐ: ");
INSERT INTO aii_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ܐܡܝܼܪܹܗ ܡܵܪܝܵܐ ܠܡܵܪܝܼ: ’ܝܬܘܿܒ݂ ܡ̣ܢ ܝܲܡܝܼܢܝܼ ܗܲܠܔ ܕܡܲܬܒܸܢ ܕܸܫ̃ܡܸܢܘܼܟ݂ ܬܚܘܿܬ ܐܲܩܠܵܬܘܼ̈ܟ݂.‘ ");
INSERT INTO aii_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","”ܐܸܢ ܗܵܕܟ݂ܵܐ ܕܵܘܝܼܕ ܒܸܩܪܵܝܹܗ ܝܠܹܗ ܡܵܪܝܵܐ، ܕܵܐܟ݂ܝܼ ܒܸܬ ܗܵܘܹܐ ܒܪܘܿܢܹܗ؟“ ");
INSERT INTO aii_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ܐܘܼܦ ܚܲܕ ܠܵܐ ܡܨܹܐ ܠܹܗ ܓ̰ܲܘܸܒ ܚܲܒܪܵܐ، ܘܡ̣ܢ ܗ̇ܘ ܝܵܘܡܵܐ ܐܘܼܦ ܚܲܕ ܠܵܐ ܩܘܼܫܕܸܪܹܗ ܠܒܲܩܘܼܪܹܐ ܡܸܢܹܗ ܒܘܼܩܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ܗ̇ܝܓܵܗ ܗܘܼܡܙܸܡ ܠܹܗ ܝܼܫܘܿܥ ܥܲܡ ܟܸܢܫܹ̈ܐ ܘܥܲܡ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܣܵܦܪܹ̈ܐ ܘܦܪ̈ܝܼܫܹܐ ܕܒ݂ܝܼܩ ܠܗܘܿܢ ܕܘܼܟܵܐ ܕܡܘܼܫܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","”ܗܵܕܟ݂ܵܐ ܟܠܔ ܡܸܢܕܝܼ ܕܐܵܡܪܝܼ ܐܸܠܵܘܟ݂ܘܿܢ ܕܢܵܛܪܝܼܬܘܿܢ، ܥܒ݂ܘܿܕܘܼܢ ܘܢܛܘܿܪܘܼܢ؛ ܐܝܼܢܵܐ ܐܲܝܟ݂ ܦܘܼܠܚܵܢܵܝ̈ܗ‌ܝ ܠܵܐ ܥܵܒ݂ܕܝܼܬܘܿܢ، ܣܵܒܵܒ ܟܹܐ ܐܵܡܪܝܼ ܘܠܹܐ ܥܵܒ݂ܕܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","”ܟܹܐ ܐܵܣܪܝܼ ܟܵܪ̈ܵܬܹ‌ܐ ܝܲܩܘܼܪܹ̈ܐ ܘܡܲܬܒ݂ܝܼ ܠܗܘܿܢ ܥܲܠܔ ܪ̈ܘܼܦ̮ܫܵܢܹܐ ܕܒܢܲܝ̈ܢܵܫܵܐ، ܐܝܼܢܵܐ ܒܓܵܢܵܝܗ‌ܝ ܠܹܐ ܒܵܥܝܼ ܐܘܼܦ ܒܨܸܒܥܵܝܗ‌ܝ ܕܵܩܪܝܼ ܒܝܼܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","”ܟܠܵܝܗ‌ܝ ܦܘܼܠܚܵܢܵܝ̈ܗ‌ܝ ܟܹܐ ܥܵܒ݂ܕܝܼ ܠܗܘܿܢ ܕܦܵܝܫܝܼ ܚܸܙܝܹܐ ܡ̣ܢ ܒܢܲܝ̈ܢܵܫܵܐ؛ ܟܹܐ ܡܲܦܬ‌ܝܼ ܬܸܦܠܵܝ̈ܗ‌ܝ ܘܡܲܪܝܸܟ݂ܝܼ ܬܸܟ݂ܠܵܬܹ̈‌ܐ ܕܩܛܲܒ݂ܝܵܬܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","”ܟܹܐ ܡܲܚܸܒܝܼ ܕܝܵܬܒ݂ܝܼ ܒܪܹܝܫܵܐ ܕܡܸܫܬܘܼܝܵܬܹ̈‌ܐ ܘܒܪܹܝܫܵܐ ܕܡܵܘܬܒܹ̈ܐ ܕܟܢܘܼܫܝܵܬܹ̈‌ܐ، ");
INSERT INTO aii_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","”ܘܟܹܐ ܡܲܚܸܒܝܼ ܫܠܵܡܵܐ ܡ̣ܢ ܐܢܵܫܹ̈ܐ ܒܫܘܼܩܹ̈ܐ، ܘܦܵܝܫܝܼ ܩܸܪܝܹܐ ܪܲܒܝܼ، ܪܲܒܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","”ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ ܠܵܐ ܦܵܝܫܝܼܬܘܿܢ ܩܸܪܝܹܐ ܪܲܒܝܼ، ܣܵܒܵܒ ܚܲܕ ܝܼܠܹܗ ܪܲܒܝܼܵܘܟ݂ܘܿܢ، ܘܐܲܚܬܘܿܢ ܟܠܵܘܟ݂ܘܿܢ ܐܲܚܘܿܢܘܵܬܹ̈‌ܐ ܝܬܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","”ܘܠܵܐ ܩܵܪܹܝܬܘܿܢ ܠܵܘܟ݂ܘܿܢ ܒܵܒܵܐ ܥܲܠܔ ܐܲܪܥܵܐ، ܣܵܒܵܒ ܚܲܕ ܝܼܠܹܗ ܒܵܒܵܘܟ݂ܘܿܢ، ܗ̇ܘ ܕܒܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","”ܘܠܵܐ ܦܵܝܫܝܼܬܘܿܢ ܩܸܪܝܹܐ ܡܕܲܒܪ̈ܵܢܹܐ، ܣܵܒܵܒ ܚܲܕ ܝܼܠܹܗ ܡܕܲܒܪܵܢܵܘܟ݂ܘܿܢ، ܡܫܝܼܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","”ܐܝܼܢܵܐ ܗ̇ܘ ܕܝܼܠܹܗ ܓܘܼܪܵܐ ܓܵܘܵܘܟ݂ܘܿܢ ܗܵܘܹܐ ܐܸܠܵܘܟ݂ܘܿܢ ܪܹܓܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","”ܣܵܒܵܒ ܟܠܔ ܡ̇ܢ ܕܡܲܪܸܡ ܓܵܢܹܗ ܒܸܬ ܦܵܐܹܫ ܡܘܼܟܸܦܵܐ، ܘܡ̇ܢ ܕܡܲܟܸܦ ܓܵܢܹܗ ܒܸܬ ܦܵܐܹܫ ܡܘܼܪܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","”ܘܵܝ ܐܸܠܵܘܟ݂ܘܿܢ ܣܵܦܪܹ̈ܐ ܘܦܪ̈ܝܼܫܹܐ، ܡܲܫܦܸܪ̈ܵܢܹܐ، ܕܟܹܐ ܐܵܟ݂ܠܝܼܬܘܿܢ ܒܵܬܹ̈‌ܐ ܕܐܲܪ̈ܡܸܠܝܵܬܹ‌ܐ ܘܡܲܪܝܸܟ݂ܝܼܬܘܿܢ ܨܠܵܘܵܬܵܘ̈ܟ݂ܘܿܢ ܕܠܵܐ ܥܸܠܬܵ‌ܐ. ܒܘܼܬ ܐܵܗܵܐ ܒܸܬ ܩܲܒܠܝܼܬܘܿܢ ܕܝܵܢܬܵ‌ܐ ܒܘܼܫ ܙܵܘܕܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","”ܘܵܝ ܐܸܠܵܘܟ݂ܘܿܢ ܣܵܦܪܹ̈ܐ ܘܦܪ̈ܝܼܫܹܐ، ܡܲܫܦܸܪ̈ܵܢܹܐ، ܣܵܒܵܒ ܟܹܐ ܕܵܒ݂ܪܝܼܬܘܿܢ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ ܥܲܠܔ ܒܢܲܝ̈ܢܵܫܵܐ. ܐܲܚܬܘܿܢ ܠܹܐ ܥܵܒ݂ܪܝܼܬܘܿܢ، ܘܐܵܢܝܼ ܕܒܵܥܝܼ ܥܵܒ݂ܪܝܼ ܠܹܐ ܫܵܒ݂ܩܝܼܬܘܿܢ ܠܗܘܿܢ ܕܥܵܒ݂ܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","”ܘܵܝ ܐܸܠܵܘܟ݂ܘܿܢ ܣܵܦܪܹ̈ܐ ܘܦܪ̈ܝܼܫܹܐ، ܡܲܫܦܸܪ̈ܵܢܹܐ، ܕܟܹܐ ܚܵܕܪܝܼܬܘܿܢ ܝܵܡܵܐ ܘܒܸܪܙܵܐ ܠܡܲܩܠܘܼܒܹܐ ܚܲܕ ܢܘܼܟ݂ܪܵܝܵܐ ܠܬܵܘܕܝܼܬܵܘܟ݂ܘܿܢ، ܘܐܝܼܡܲܢ ܕܡܲܩܠܸܒܝܼܬܘܿܢ ܠܹܗ، ܟܹܐ ܥܵܒ݂ܕܝܼܬܘܿܢ ܠܹܗ ܒܪܘܿܢܵܐ ܕܓܹܗܲܢܵܐ ܚܲܕ ܒܬܪܹܝ ܥܲܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","”ܘܵܝ ܐܸܠܵܘܟ݂ܘܿܢ ܡܗܲܕܝܵܢܹ̈ܐ ܣܸܡܝܹ̈ܐ، ܕܟܹܐ ܐܵܡܪܝܼܬܘܿܢ: ’ܡ̇ܢ ܕܝܵܡܹܐ ܒܗܲܝܟܠܵܐ، ܠܹܐ ܝܠܵܗ̇ ܚܲܕ ܡܸܢܕܝܼ؛ ܐܝܼܢܵܐ ܡ̇ܢ ܕܝܵܡܹܐ ܒܕܲܗܒ݂ܵܐ ܕܓܵܘ ܗܲܝܟܠܵܐ، ܚܲܝܵܒ݂ܵܐ ܝܠܹܗ.‘ ");
INSERT INTO aii_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","”ܝܵܐ ܣܲܟ݂ܠܹ̈ܐ ܘܣܸܡܝܹ̈ܐ، ܐܲܝܢܝܼ ܝܠܹܗ ܒܘܼܫ ܓܘܼܪܵܐ، ܕܲܗܒ݂ܵܐ ܝܲܢ ܗܲܝܟܠܵܐ ܕܟܹܐ ܡܩܲܕܸܫ ܠܕܲܗܒ݂ܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","”ܟܹܐ ܐܵܡܪܝܼܬܘܿܢ: ’ܐܸܢ ܐܢܵܫܵܐ ܝܵܡܹܐ ܒܡܲܕܒܚܵܐ، ܠܹܐ ܝܠܵܗ̇ ܚܲܕ ܡܸܢܕܝܼ، ܐܝܼܢܵܐ ܡ̇ܢ ܕܝܵܡܹܐ ܒܩܘܼܪܒܵܢܵܐ ܕܥܲܠܔ ܡܲܕܒܚܵܐ، ܒܸܬ ܦܵܐܹܫ ܐܣܝܼܪܵܐ ܒܡܵܘܡܝܼܬܹܗ.‘ ");
INSERT INTO aii_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","”ܝܵܐ ܣܲܟ݂ܠܹ̈ܐ ܘܣܸܡܝܹ̈ܐ، ܐܲܝܢܝܼ ܝܠܹܗ ܒܘܼܫ ܓܘܼܪܵܐ، ܩܘܼܪܒܵܢܵܐ ܝܲܢ ܡܲܕܒܚܵܐ ܕܟܹܐ ܡܩܲܕܸܫ ܠܩܘܼܪܒܵܢܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","”ܗܵܕܟ݂ܵܐ ܟܠܔ ܡ̇ܢ ܕܝܵܡܹܐ ܒܡܲܕܒܚܵܐ، ܟܹܐ ܝܵܡܹܐ ܒܝܼܹܗ ܘܒܟܠܔ ܡܸܢܕܝܼ ܕܐܝܼܬ ܥܲܠܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","”ܘܡ̇ܢ ܕܝܵܡܹܐ ܒܗܲܝܟܠܵܐ، ܟܹܐ ܝܵܡܹܐ ܒܝܼܹܗ ܘܒܡ̇ܢ ܕܥܵܡܹܪ ܓܵܘܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","”ܘܡ̇ܢ ܕܝܵܡܹܐ ܒܫܡܲܝܵܐ، ܟܹܐ ܝܵܡܹܐ ܒܟܘܼܪܣܝܵܐ ܕܐܲܠܵܗܵܐ ܘܒܡ̇ܢ ܕܝܵܬܹܒ݂ ܥܲܠܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","”ܘܵܝ ܐܸܠܵܘܟ݂ܘܿܢ ܣܵܦܪܹ̈ܐ ܘܦܪ̈ܝܼܫܹܐ، ܡܲܫܦܸܪ̈ܵܢܹܐ. ܟܹܐ ܝܵܗܒ݂ܝܼܬܘܿܢ ܡܲܥܣܵܪܹ̈ܐ ܕܢܵܥܢܵܐ ܘܫܸܒܸܬ ܘܟܲܡܘܼܢܵܐ، ܐܝܼܢܵܐ ܟܹܐ ܫܵܒ݂ܩܝܼܬܘܿܢ ܡܸܢܕܝܼܵܢܹ̈ܐ ܡܝܘܼܩܪܹ̈ܐ ܕܢܵܡܘܿܣܵܐ: ܕܝܼܘܵܢ، ܘܪ̈ܲܚܡܹܐ، ܘܗܲܝܡܵܢܘܼܬܵ‌ܐ. ܐܲܢܹܐ ܘܵܠܹܐ ܝܗܘܵܐ ܕܥܵܒ݂ܕܝܼܬܘܿܢ ܗܘܵܘ ܠܗܘܿܢ، ܘܐܵܢܝܼ ܐܚܹܪ̈ܢܹܐ ܠܵܐ ܫܵܒ݂ܩܝܼܬܘܿܢ ܗܘܵܘ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","”ܝܵܐ ܡܗܲܕܝܵܢܹ̈ܐ ܣܸܡܝܹ̈ܐ، ܨܲܦܝܵܢܹ̈ܐ ܕܒܲܩܬܵ‌ܐ ܘܒܵܠܥܵܢܹ̈ܐ ܕܓܘܼܡܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","”ܘܵܝ ܐܸܠܵܘܟ݂ܘܿܢ ܣܵܦܪܹ̈ܐ ܘܦܪ̈ܝܼܫܹܐ، ܡܲܫܦܸܪ̈ܵܢܹܐ، ܕܟܹܐ ܕܲܟܹܝܬܘܿܢ ܠܒܵܬܪܹܗ ܕܟܵܣܵܐ ܘܕܙܵܒ݂ܘܿܪܵܐ، ܐܝܼܢܵܐ ܡ̣ܢ ܠܓܵܘܵܐ ܡܸܠܝܹܐ ܝܢܵܐ ܚܛܘܼܦܝܵܐ ܘܛܲܡܲܥܟܵܪܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","”ܝܵܐ ܦܪ̈ܝܼܫܹܐ ܣܸܡܝܹ̈ܐ، ܩܲܕܡܵܝܬܵ‌ܐ ܕܲܟܹܝܡܘܼܢ ܓܵܘܵܐ ܕܟܵܣܵܐ ܘܕܙܵܒ݂ܘܿܪܵܐ، ܗ̇ܝܓܵܗ ܐܘܼܦ ܒܵܬܪܵܝܗ‌ܝ ܒܸܬ ܗܵܘܹܐ ܕܸܟ݂ܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","”ܘܵܝ ܐܸܠܵܘܟ݂ܘܿܢ ܣܵܦܪܹ̈ܐ ܘܦܪ̈ܝܼܫܹܐ، ܡܲܫܦܸܪ̈ܵܢܹܐ، ܟܹܐ ܕܵܡܹܝܬܘܿܢ ܠܩܲܒ݂ܪܹ̈ܐ ܡܘܼܚܘܸܪܹ̈ܐ، ܕܡ̣ܢ ܠܒܲܕܲܪ ܟܹܐ ܦܵܝܫܝܼ ܚܸܙܝܹܐ ܫܲܦܝܼܪܹ̈ܐ، ܐܝܼܢܵܐ ܡ̣ܢ ܠܓܵܘܵܐ ܡܸܠܝܹܐ ܝܢܵܐ ܓܲܪ̈ܡܹܐ ܕܡܝܼ̈ܬܹ‌ܐ ܘܟܠܵܗ̇ ܛܲܢܦܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","”ܗܵܕܟ݂ܵܐ ܐܘܼܦ ܐܲܚܬܘܿܢ، ܡ̣ܢ ܠܒܲܕܲܪ ܟܹܐ ܕܵܡܹܝܬܘܿܢ ܐܲܝܟ݂ ܙܲܕܝܼܩܹ̈ܐ، ܐܝܼܢܵܐ ܡ̣ܢ ܠܓܵܘܵܐ ܡܸܠܝܹܐ ܝܬܘܿܢ ܥܵܘܠܵܐ ܘܡܲܫܦܲܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","”ܘܵܝ ܐܸܠܵܘܟ݂ܘܿܢ ܣܵܦܪܹ̈ܐ ܘܦܪ̈ܝܼܫܹܐ، ܡܲܫܦܸܪ̈ܵܢܹܐ، ܕܟܹܐ ܒܵܢܹܝܬܘܿܢ ܩܲܒ݂ܪ̈ܵܘܵܬܹ‌ܐ ܕܢܒ݂ܝܼܹ̈ܐ، ܘܣܲܩܠܝܼܬܘܿܢ ܒܹܝܬ ܩܒ݂ܘܼܪܹ̈ܐ ܕܙܲܕܝܼܩܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","”ܘܟܹܐ ܐܵܡܪܝܼܬܘܿܢ: ’ܐܸܢ ܗܵܘܲܚ ܗܘܵܘ ܒܸܚܵܝܵܐ ܒܝܵܘܡܵܢܹ̈ܐ ܕܒܵܒܵܘܵܬܲܢ̈، ܠܹܐ ܗܵܘܲܚ ܗܘܵܘ ܫܲܪ̈ܝܼܟܹܐ ܥܲܡܵܝܗ‌ܝ ܒܩܛܵܠܬܵ‌ܐ ܕܢܒ݂ܝܼܹ̈ܐ.‘ ");
INSERT INTO aii_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","”ܗܵܕܟ݂ܵܐ ܒܸܣܗܵܕܵܐ ܝܬܘܿܢ ܥܲܠܔ ܓܵܢܵܘܟ݂ܘܿܢ ܕܝܼܬܘܿܢ ܒܢܘܿܢܹ̈ܐ ܕܐܵܢܝܼ ܕܩܛܝܼܠܔ ܠܗܘܿܢ ܠܢܒ݂ܝܼܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","”ܗܵܕܟ݂ܵܐ ܐܲܚܬܘܿܢ ܡܠܹܐ ܠܵܘܟ݂ܘܿܢ ܟܝܘܼܠܵܐ ܕܐܲܒ݂ܵܗܵܬܵܘ̈ܟ݂ܘܿܢ ܘܙܝܼܕ ܠܵܘܟ݂ܘܿܢ ܥܲܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","”ܝܵܐ ܚܘܼܵܘܵܬܹ̈‌ܐ ܘܙܲܪ̈ܥܹܐ ܕܐܵܟܸܕܢܹ̈ܐ، ܕܵܐܟ݂ܝܼ ܒܸܬ ܥܵܪܩܝܼܬܘܿܢ ܡ̣ܢ ܕܝܼܘܵܢ ܕܓܹܗܲܢܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","”ܒܘܼܬ ܐܵܗܵܐ، ܗܵܐ ܐܵܢܵܐ ܫܲܕܘܼܪܹܐ ܝܘܸܢ ܠܟܸܣܠܵܘܟ݂ܘܿܢ ܢܒ݂ܝܼܹ̈ܐ ܘܚܲܟܝܼܡܹ̈ܐ ܘܣܵܦܪܹ̈ܐ. ܡܸܢܵܝܗ‌ܝ ܒܸܬ ܩܵܛܠܝܼܬܘܿܢ ܘܡܵܚܹܝܬܘܿܢ ܠܙܩܝܼܦܵܐ، ܘܠܚܲܕܟܡܵܐ ܒܸܬ ܡܵܚܹܝܬܘܿܢ ܒܫܵܘܛܹ̈ܐ ܓܵܘ ܟܢܘܼܫܝܵܬܵܘ̈ܟ݂ܘܿܢ، ܘܟܲܡܪܝܼܬܘܿܢ ܠܗܘܿܢ ܡ̣ܢ ܡܕܝܼܢ݇ܬܵ‌ܐ ܠܡܕܝܼܢ݇ܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","”ܒܘܼܬ ܐܵܗܵܐ، ܒܸܬ ܐܵܬܹ‌ܐ ܥܲܠܵܘܟ݂ܘܿܢ ܟܠܹܗ ܕܸܡܵܐ ܕܙܲܕܝܼܩܹ̈ܐ ܕܦܝܼܫ ܠܹܗ ܫܘܼܦܟ݂ܵܐ ܥܲܠܔ ܐܲܪܥܵܐ، ܡ̣ܢ ܕܸܡܵܐ ܕܗܵܒܹܝܠܔ ܙܲܕܝܼܩܵܐ ܗܲܠܔ ܕܸܡܵܐ ܕܙܟܲܪܝܵܐ ܒܪܘܿܢܵܐ ܕܒܪܵܟ݂ܝܵܐ، ܗ̇ܘ ܕܩܛܝܼܠܔ ܠܵܘܟ݂ܘܿܢ ܒܹܝܠܔ ܗܲܝܟܠܵܐ ܘܠܡܲܕܒܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܟܠܵܝܗ‌ܝ ܐܲܢܹܐ ܒܸܬ ܐܵܬ‌ܝܼ ܥܲܠܔ ܐܵܗܵܐ ܫܲܪܒܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","”ܐܘܿܪܸܫܠܸܡ، ܐܘܿܪܸܫܠܸܡ، ܩܵܛܠܵܢܬܵ‌ܐ ܕܢܒ݂ܝܼܹ̈ܐ ܘܪܵܓ̰ܡܵܢܬܵ‌ܐ ܕܐܵܢܝܼ ܕܝܼܢܵܐ ܫܘܼܕܪܹܐ ܠܟܸܣܠܘܼܗ̇، ܟܡܵܐ ܓܵܗܹ̈ܐ ܒܥܹܐ ܠܝܼ ܕܓ̰ܲܡܥܸܢ ܠܒܢܘܿܢܵܟ݂ܝ̈ ܐܲܝܟ݂ ܟܬܵܝܬܵ‌ܐ ܕܓ̰ܲܡܥܵܐ ܙܲܥܝܘܼ̈ܗ̇ ܬܚܘܿܬ ܓܘܼܠܦܵܢܘܼ̈ܗ̇، ܘܠܵܐ ܒܣܝܼܡ ܠܵܗ̇ ܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","”ܗܵܐ ܦܝܵܫܵܐ ܝܠܹܗ ܫܒ݂ܝܼܩܵܐ ܒܲܝܬܵܘܟ݂ܘܿܢ ܚܵܪܵܒܵܐ ܐܸܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","”ܣܵܒܵܒ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܠܹܐ ܚܵܙܹܝܬܘܿܢ ܠܝܼ ܡ̣ܢ ܐܵܕܝܼܵܐ ܗܲܠܔ ܕܐܵܡܪܝܼܬܘܿܢ: ’ܒܪܝܼܟ݂ܵܐ ܝܠܹܗ ܗ̇ܘ ܕܒܹܐܬܵܝܵܐ ܝܠܹܗ ܒܫܸܡܵܐ ܕܡܵܪܝܵܐ.‘“ ");
INSERT INTO aii_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ܘܦܠܝܼܛ ܠܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܗܲܝܟܠܵܐ، ܘܟܲܕ ܒܹܐܙܵܠܵܐ ܝܗܘܵܐ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܠܡܲܚܙܘܼܝܹܗ ܒܸܢܝܵܢܵܐ ܕܗܲܝܟܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ܐܝܼܢܵܐ ܗ̇ܘ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܒܸܚܙܵܝܵܐ ܝܬܘܿܢ ܟܠܵܝܗ‌ܝ ܐܲܢܹܐ؟ ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܠܹܐ ܦܵܐܹܫ ܫܒ݂ܝܼܩܵܐ ܟܹܐܦܵܐ ܥܲܠܔ ܟܹܐܦܵܐ ܕܠܵܐ ܦܵܐܹܫ ܣܬܝܼܪܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ܘܟܲܕ ܝܬܝܼܒ݂ ܠܹܗ ܝܼܫܘܿܥ ܥܲܠܔ ܛܘܼܪܵܐ ܕܙܲܝ̈ܬܹ‌ܐ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܒܢܲܦ̮ܫܵܝܗ‌ܝ ܒܹܐܡܵܪܵܐ: ”ܐܡܘܿܪ ܐܸܠܲܢ، ܐܝܼܡܲܢ ܒܸܬ ܗܵܘܝܼ ܐܲܢܹܐ، ܘܡܘܼܕܝܼ ܝܠܹܗ ܢܝܼܫܲܢܩܵܐ ܕܐܬܵܝܬܘܼܟ݂، ܘܫܘܼܠܵܡܵܐ ܕܙܲܒ݂ܢܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܗܘܹܝܡܘܼܢ ܗܸܫܝܲܪ ܕܐܢܵܫܵܐ ܠܵܐ ܡܲܚܠܸܛ ܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","”ܣܵܒܵܒ ܪܵܒܵܐ ܒܸܬ ܐܵܬ‌ܝܼ ܒܫܸܡܝܼ ܘܒܸܬ ܐܵܡܪܝܼ: ’ܐܵܢܵܐ ܝܘܸܢ ܡܫܝܼܚܵܐ،‘ ܘܒܸܬ ܡܲܚܠܸܛܝܼ ܠܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","”ܒܸܬ ܫܵܡܥܝܼܬܘܿܢ ܦܠܵܫܹ̈ܐ ܘܚܲܒܪܹ̈ܐ ܒܘܼܬ ܦܠܵܫܹ̈ܐ. ܚܙܹܝܡܘܼܢ ܕܠܵܐ ܫܵܓ݂ܫܝܼܬܘܿܢ، ܣܵܒܵܒ ܘܵܠܹܐ ܝܠܵܗ̇ ܐܲܢܹܐ ܟܠܵܝܗ‌ܝ ܗܵܘܝܼ، ܐܝܼܢܵܐ ܗܸܫ ܠܹܐ ܝܠܹܗ ܫܘܼܠܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","”ܒܸܬ ܩܵܝܡܵܐ ܐܘܼܡܬܵ‌ܐ ܥܲܠܔ ܐܘܼܡܬܵ‌ܐ، ܘܡܲܠܟܘܼܬܵ‌ܐ ܥܲܠܔ ܡܲܠܟܘܼܬܵ‌ܐ، ܘܒܸܬ ܗܵܘܝܼ ܟܸܦܢܹ̈ܐ، ܘܡܵܘܬܵܢܹ̈ܐ، ܘܪ̈ܵܘܕܵܢܹܐ ܒܕܘܼܟܵܢܹ̈ܐ ܦܪ̈ܝܼܫܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","”ܐܝܼܢܵܐ ܐܲܢܹܐ ܟܠܵܝܗ‌ܝ ܫܘܼܪܵܝܵܐ ܕܐܘܼܠܨܵܢܹ̈ܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","”ܗ̇ܝܓܵܗ ܒܸܬ ܣܲܦܝܼ ܠܵܘܟ݂ܘܿܢ ܕܦܵܝܫܝܼܬܘܿܢ ܓ̰ܘܼܢܓ̰ܸܪܹܐ، ܘܒܸܬ ܩܵܛܠܝܼ ܠܵܘܟ݂ܘܿܢ، ܘܒܸܬ ܦܵܝܫܝܼܬܘܿܢ ܣܸܢܝܹܐ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܐܸܡܘܵܬܹ̈‌ܐ ܒܘܼܬ ܫܸܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","”ܗ̇ܝܓܵܗ ܒܸܬ ܩܵܠܒܝܼ ܪܵܒܵܐ، ܘܒܸܬ ܣܵܢܝܼ ܚܲܕ ܠܗ̇ܘ ܐܚܹܪܢܵܐ، ܘܒܸܬ ܣܲܦܝܼ ܚܲܕ ܠܗ̇ܘ ܐܚܹܪܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","”ܘܒܸܬ ܩܵܝܡܝܼ ܪܵܒܵܐ ܢܒ݂ܝܼܹ̈ܐ ܕܲܓܵܠܹ̈ܐ ܘܒܸܬ ܡܲܚܠܸܛܝܼ ܠܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","”ܘܒܘܼܬ ܙܵܘܕܘܼܢܝܘܼܬܵ‌ܐ ܕܥܵܘܠܵܐ، ܒܸܬ ܦܵܐܹܚ ܚܘܼܒܵܐ ܕܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","”ܐܝܼܢܵܐ ܡ̇ܢ ܕܚܵܡܹܠܔ ܗܲܠܔ ܚܲܪܬܵ‌ܐ، ܗ̇ܘ ܒܸܬ ܦܵܪܹܩ. ");
INSERT INTO aii_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","”ܘܒܸܬ ܦܵܐܹܫ ܡܘܼܟܪܸܙܵܐ ܐܵܗܵܐ ܐܹܘܲܢܓܲܠܝܼܘܿܢ ܕܡܲܠܟܘܼܬܵ‌ܐ ܒܟܠܵܗ̇ ܕܘܼܢܝܹܐ ܠܣܵܗܕܘܼܬܵ‌ܐ ܕܟܠܵܝܗ‌ܝ ܐܸܡܘܵܬܹ̈‌ܐ، ܘܗ̇ܝܓܵܗ ܒܸܬ ܐܵܬܹ‌ܐ ܫܘܼܠܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","”ܗܵܕܟ݂ܵܐ ܐܝܼܡܲܢ ܕܚܵܙܹܝܬܘܿܢ ܢܝܼܫܲܢܩܵܐ ܕܛܲܢܦܘܼܬܵ‌ܐ ܕܚܵܪܵܒܵܐ، ܒܸܟܠܵܝܵܐ ܒܕܘܼܟܵܐ ܩܲܕܝܼܫܬܵ‌ܐ، ܕܦܝܼܫܬܵ‌ܐ ܝܠܵܗ̇ ܡܘܼܕܟܸܪܬܵ‌ܐ ܒܝܲܕ ܕܵܢܝܼܐܹܝܠܔ ܢܒ݂ܝܼܵܐ، ܗ̇ܘ ܕܩܵܪܹܐ ܦܲܪܡܹܐ، ");
INSERT INTO aii_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","”ܗ̇ܝܓܵܗ ܐܵܢܝܼ ܕܝܼܢܵܐ ܒܝܼܗܘܼܕ ܥܵܪܩܝܼ ܠܛܘܼܪ̈ܵܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","”ܘܗ̇ܘ ܕܝܼܠܹܗ ܥܲܠܔ ܐܓܵܪܹܐ، ܠܵܐ ܨܵܠܹܐ ܠܸܫܩܵܠܵܐ ܡܸܢܕܝܼ ܕܝܼܠܹܗ ܓܵܘ ܒܲܝܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","”ܘܗ̇ܘ ܕܝܼܠܹܗ ܓܵܘ ܚܲܩܠܵܐ، ܠܵܐ ܕܵܐܹܪ ܠܒܵܬܪܹܗ ܠܸܫܩܵܠܵܐ ܠܒ݂ܝܼܫܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","”ܘܵܝ ܠܒܛܝܼܢܹ̈ܐ، ܘܠܡܲܡܸܨܵܢܹ̈ܐ ܒܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","”ܒܘܼܬ ܐܵܗܵܐ، ܨܲܠܹܝܡܘܼܢ ܕܠܵܐ ܗܵܘܹܐ ܥܪܵܩܵܘܟ݂ܘܿܢ ܒܣܸܬܘܵܐ ܘܠܵܐ ܒܫܲܒܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","”ܣܵܒܵܒ ܗ̇ܝܓܵܗ ܒܸܬ ܗܵܘܹܐ ܐܘܼܠܨܵܢܵܐ ܓܘܼܪܵܐ ܕܠܹܐ ܝܠܹܗ ܗܘܝܼܵܐ ܡܐܲܝܟ݂ ܕܝܼܹܗ ܗܵܐ ܡ̣ܢ ܫܘܼܪܵܝܵܐ ܕܒܪܝܼܬܵ‌ܐ ܘܗܲܠܔ ܐܵܕܝܼܵܐ، ܘܐܘܼܦ ܠܹܐ ܗܵܘܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","”ܘܐܸܢ ܠܵܐ ܗܵܘܝܼ ܗܘܵܘ ܡܘܼܟܪܝܼܹܐ ܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ، ܠܹܐ ܦܵܪܹܩ ܗܘܵܐ ܐܘܼܦ ܚܲܕ. ܐܝܼܢܵܐ ܒܘܼܬ ܚܵܬܸܪ ܕܓܘܼܒܝܹ̈ܐ ܒܸܬ ܦܵܝܫܝܼ ܡܘܼܟܪܝܼܹܐ ܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","”ܗ̇ܝܓܵܗ ܐܸܢ ܐܢܵܫܵܐ ܐܵܡܹܪ ܐܸܠܵܘܟ݂ܘܿܢ: ’ܠܲܐܟ݂ܵܐ ܝܠܹܗ ܡܫܝܼܚܵܐ،‘ ܝܲܢ ’ܬܵܡܵܐ ܝܠܹܗ،‘ ܠܵܐ ܗܲܡܸܢܝܼܬܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","”ܣܵܒܵܒ ܒܸܬ ܩܵܝܡܝܼ ܡܫܝܼܚܹ̈ܐ ܕܲܓܵܠܹ̈ܐ ܘܢܒ݂ܝܼܹ̈ܐ ܕܲܓܵܠܹ̈ܐ ܘܒܸܬ ܥܵܒ݂ܕܝܼ ܢܝܼܫܲܢܩܹ̈ܐ ܓܘܼܪܹ̈ܐ ܘܕܘܼܡܵܪܹ̈ܐ ܠܡܲܚܠܘܼܛܹܐ ܐܸܢ ܡܵܨܝܵܐ ܐܘܼܦ ܠܓܘܼܒܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","”ܗܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ ܡ̣ܢ ܩܲܕܡ ܕܗܵܘܝܼ ܐܲܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","”ܒܘܼܬ ܐܵܗܵܐ، ܐܸܢ ܐܵܡܪܝܼ ܐܸܠܵܘܟ݂ܘܿܢ: ’ܗܵܐ ܓܵܘ ܒܲܪܝܼܵܐ ܝܠܹܗ،‘ ܠܵܐ ܦܵܠܛܝܼܬܘܿܢ؛ ܝܲܢ ’ܗܵܐ ܓܵܘ ܐܵܘܵܢܵܐ ܝܠܹܗ،‘ ܠܵܐ ܗܲܡܸܢܝܼܬܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","”ܣܵܒܵܒ ܕܵܐܟ݂ܝܼ ܒܸܪܩܵܐ ܡܵܚܹܐ ܡ̣ܢ ܡܲܕܢܚܵܐ ܘܦܵܐܹܫ ܚܸܙܝܵܐ ܗܲܠܔ ܡܲܥܪܒ݂ܵܐ، ܗܵܕܟ݂ܵܐ ܒܸܬ ܗܵܘܝܵܐ ܐܬܵܝܬܵ‌ܐ ܕܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","”ܐܲܝܟܵܐ ܕܝܼܠܵܗ̇ ܫܠܲܕܵܐ، ܬܵܡܵܐ ܒܸܬ ܓ̰ܵܡܥܝܼ ܢܸܫܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","”ܘܒܓ̰ܲܠܕܘܼܬܵ‌ܐ ܡ̣ܢ ܒܵܬܪ ܐܘܼܠܨܵܢܵܐ ܕܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ، ܒܸܬ ܚܵܒܹܐ ܫܸܡܫܵܐ، ܘܣܲܗܪܵܐ ܠܹܐ ܝܵܗܒܹܠܔ ܒܲܗܪܹܗ، ܘܟܵܘܟ݂ܒܹ̈ܐ ܒܸܬ ܢܵܦܠܝܼ ܡ̣ܢ ܫܡܲܝܵܐ، ܘܚܲܝܠܵܘܵܬܹ̈‌ܐ ܕܫܡܲܝܵܐ ܒܸܬ ܦܵܝܫܝܼ ܫܥܝܼܫܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","”ܗ̇ܝܓܵܗ ܒܸܬ ܦܵܐܹܫ ܚܸܙܝܵܐ ܢܝܼܫܲܢܩܵܐ ܕܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܫܡܲܝܵܐ، ܘܒܸܬ ܥܵܒ݂ܕܝܼ ܬܵܥܙܝܼ ܟܠܵܝܗ‌ܝ ܫܲܒ݂ܛܹ̈ܐ ܕܐܲܪܥܵܐ، ܘܒܸܬ ܚܵܙܝܼ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܹܐܬܵܝܵܐ ܥܲܠܔ ܥܢܵܢܹ̈ܐ ܕܫܡܲܝܵܐ ܥܲܡ ܚܲܝܠܵܐ ܘܚܸܩܪܵܐ ܓܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","”ܒܸܬ ܫܲܕܸܪ ܡܲܠܲܐܟ݂ܘܼ̈ܗ‌ܝ ܒܩܵܠܵܐ ܪܵܡܵܐ ܕܫܝܼܦܘܿܪܵܐ، ܘܒܸܬ ܓ̰ܲܡܥܝܼ ܠܓܘܼܒܝܹ̈ܐ ܕܝܼܹܗ ܡ̣ܢ ܐܲܪܒܥܵܐ ܓܹܒܵܢܹ̈ܐ ܕܕܘܼܢܝܹܐ، ܡ̣ܢ ܚܲܕ ܓܹܒܵܐ ܕܫܡܲܝܵܐ ܠܗ̇ܘ ܐܚܹܪܢܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","”ܡ̣ܢ ܐܝܼܠܵܢܵܐ ܕܬܹܐܢܹ̈ܐ ܝܠܘܿܦܘܼܢ ܡܲܬܠܵܐ. ܐܝܼܡܲܢ ܕܟܹܐ ܪܵܟܟ݂ܝܼ ܦܲܥܘܵܢܘܼ̈ܗ‌ܝ ܘܒܲܪܛܸܢܝܼ ܛܲܪ̈ܦܘܼܗ‌ܝ، ܟܹܐ ܝܵܕܥܝܼܬܘܿܢ ܕܡܛܹܐ ܠܹܗ ܩܲܝܛܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","”ܗܵܕܟ݂ܵܐ ܐܘܼܦ ܐܲܚܬܘܿܢ، ܐܝܼܡܲܢ ܕܚܵܙܹܝܬܘܿܢ ܐܲܢܹܐ ܟܠܵܝܗ‌ܝ، ܝܕܹܥܡܘܼܢ ܕܡܛܹܐ ܠܵܗ̇ ܥܕܵܢܵܐ، ܘܩܲܕܡ ܬܲܪܥܵܐ ܝܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܠܹܐ ܥܵܒܹܪ ܐܵܗܵܐ ܕܵܘܪܵܐ ܗܲܠܔ ܕܟܠܵܝܗ‌ܝ ܐܲܢܹܐ ܗܵܘܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","”ܫܡܲܝܵܐ ܘܐܲܪܥܵܐ ܒܸܬ ܥܵܒ݂ܪܝܼ، ܐܝܼܢܵܐ ܗܹܡܸܙܡܵܢܝܼ̈ ܠܹܐ ܥܵܒ݂ܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","”ܐܝܼܢܵܐ ܠܗ̇ܘ ܝܵܘܡܵܐ ܘܠܗ̇ܝ ܣܵܥܲܬ ܐܘܼܦ ܚܲܕ ܐܢܵܫܵܐ ܠܹܐ ܝܵܕܹܥ، ܘܐܘܼܦ ܠܵܐ ܡܲܠܲܐܟܹ̈ܐ ܕܫܡܲܝܵܐ، ܐܸܠܵܐ ܒܵܒܵܐ ܒܢܲܦ̮ܫܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","”ܕܵܐܟ݂ܝܼ ܕܝܼܗܘܵܐ ܒܝܵܘܡܵܢܹ̈ܐ ܕܢܘܿܚ، ܗܵܕܟ݂ܵܐ ܒܸܬ ܗܵܘܝܵܐ ܐܬܵܝܬܵ‌ܐ ܕܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","”ܣܵܒܵܒ ܕܵܐܟ݂ܝܼ ܕܝܼܗܘܵܐ ܒܝܵܘܡܵܢܹ̈ܐ ܕܩܲܕܡ ܛܵܘܦܵܢܵܐ، ܐܢܵܫܹ̈ܐ ܒܹܐܟ݂ܵܠܵܐ ܘܒܸܫܬܵܝܵܐ، ܒܸܓܒ݂ܵܪܵܐ ܘܡܲܓܒ݂ܘܼܪܹܐ، ܗܲܠܔ ܝܵܘܡܵܐ ܕܥܒ݂ܝܼܪܹܗ ܢܘܿܚ ܠܩܹܒ݂ܘܼܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","”ܘܐܢܵܫܹ̈ܐ ܠܵܐ ܝܕܝܼܥ ܠܗܘܿܢ ܗܲܠܔ ܕܐܬܹ‌ܐ ܠܹܗ ܛܵܘܦܵܢܵܐ ܘܩܛܝܼܠܔ ܠܹܗ ܠܟܠܵܝܗ‌ܝ. ܗܵܕܟ݂ܵܐ ܒܸܬ ܗܵܘܝܵܐ ܐܬܵܝܬܵ‌ܐ ܕܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","”ܒܗ̇ܘ ܝܵܘܡܵܐ ܐܸܢ ܬܪܹܝ ܗܵܘܝܼ ܒܚܲܩܠܵܐ، ܚܲܕ ܒܸܬ ܦܵܐܹܫ ܠܘܼܒܠܵܐ ܘܗ̇ܘ ܐܚܹܪܢܵܐ ܒܸܬ ܦܵܐܹܫ ܫܒ݂ܝܼܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","”ܘܐܸܢ ܬܲܪܬܹܝ ܒܲܟ݂ܬܵܬܹ̈‌ܐ ܗܵܘܝܼ ܒܸܓܪܵܣܵܐ ܒܓܵܪܘܿܣܬܵ‌ܐ، ܚܕܵܐ ܒܸܬ ܦܵܝܫܵܐ ܠܘܼܒܸܠܬܵ‌ܐ ܘܗ̇ܝ ܐܚܹܪܬܵ‌ܐ ܒܸܬ ܦܵܝܫܵܐ ܫܒ݂ܝܼܩܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","”ܒܘܼܬ ܐܵܗܵܐ ܗܘܹܝܡܘܼܢ ܪܥܝܼܫܹܐ، ܣܵܒܵܒ ܠܹܐ ܝܵܕܥܝܼܬܘܿܢ ܒܐܲܝܢܝܼ ܝܵܘܡܵܐ ܒܸܬ ܐܵܬܹ‌ܐ ܡܵܪܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","”ܐܝܼܢܵܐ ܝܕܹܥܡܘܼܢ ܐܵܗܵܐ، ܕܐܸܢ ܝܵܕܹܥ ܗܘܵܐ ܡܵܪܵܐ ܕܒܲܝܬܵ‌ܐ ܒܐܲܝܢܝܼ ܥܕܵܢܵܐ ܒܸܬ ܐܵܬܹ‌ܐ ܗܘܵܐ ܓܹܢܵܒ݂ܵܐ، ܒܸܬ ܦܵܐܹܫ ܗܘܵܐ ܪܥܝܼܫܵܐ ܘܠܹܐ ܫܵܒܹܩ ܗܘܵܐ ܕܦܵܐܹܫ ܗܘܵܐ ܣܠܝܼܒܵܐ ܒܲܝܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","”ܗܵܕܟ݂ܵܐ ܐܘܼܦ ܐܲܚܬܘܿܢ ܗܘܹܝܡܘܼܢ ܗܕܝܼܪܹܐ، ܣܵܒܵܒ ܒܣܵܥܲܬ ܕܠܹܐ ܣܵܦܪܝܼܬܘܿܢ ܒܸܬ ܐܵܬܹ‌ܐ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","”ܡܵܢܝܼ ܝܠܹܗ ܪܹܓܵܐ ܡܗܘܼܡܢܵܐ ܘܚܲܟܝܼܡܵܐ ܕܡܵܪܹܗ ܥܵܒܹܕ ܠܹܗ ܡܕܲܒܪܵܢܵܐ ܥܲܠܔ ܒܢܲܝ̈ ܒܲܝܬܹܗ ܕܝܵܗܒܹܠܔ ܠܗܘܿܢ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ ܒܥܕܵܢܘܼܗ̇؟ ");
INSERT INTO aii_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","”ܛܘܼܒ݂ܵܐ ܠܗ̇ܘ ܪܹܓܵܐ ܐܝܼܡܲܢ ܕܐܵܬܹ‌ܐ ܡܵܪܹܗ ܘܚܵܙܹܐ ܠܹܗ ܒܸܥܒ݂ܵܕܵܐ ܗܵܕܟ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܒܸܬ ܥܵܒܹܕ ܠܹܗ ܡܕܲܒܪܵܢܵܐ ܥܲܠܔ ܟܠܔ ܡܸܢܕܝܼ ܕܐܝܼܬ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","”ܐܝܼܢܵܐ ܐܸܢ ܗܵܘܹܐ ܪܹܓܵܐ ܒܝܼܫܵܐ، ܘܐܵܡܹܪ ܒܠܸܒܹܗ: ’ܡܵܪܝܼ ܥܲܪܩܘܼܠܹܐ ܝܠܹܗ ܠܹܐܬܵܝܵܐ،‘ ");
INSERT INTO aii_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","”ܘܫܲܪܹܐ ܠܸܡܚܵܝܵܐ ܠܚܲܒ݂ܪ̈ܵܘܵܬܘܼܗ‌ܝ ܒܪܹܓܘܼܬܵ‌ܐ، ܘܗܵܘܹܐ ܒܹܐܟ݂ܵܠܵܐ ܘܒܸܫܬܵܝܵܐ ܥܲܡ ܪ̈ܵܘܵܝܹܐ، ");
INSERT INTO aii_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","”ܒܸܬ ܐܵܬܹ‌ܐ ܡܵܪܵܐ ܕܗ̇ܘ ܪܹܓܵܐ ܒܝܵܘܡܵܐ ܕܠܹܐ ܣܵܦܹܪ، ܘܒܣܵܥܲܬ ܕܠܹܐ ܝܵܕܹܥ، ");
INSERT INTO aii_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","”ܒܸܬ ܥܵܒܹܕ ܠܹܗ ܬܪܹܝ ܩܸܛܥܵܛܹ̈ܐ ܘܒܸܬ ܚܲܫܒܸܢܹܗ ܐܲܝܟ݂ ܡܲܫܦܸܪܵܢܵܐ، ܬܵܡܵܐ ܒܸܬ ܗܵܘܹܐ ܒܸܟ݂ܝܵܐ ܘܚܲܪܚܲܟ̰ܬܵ‌ܐ ܕܟܹܟܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","”ܟܹܐ ܕܵܡܝܵܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ ܠܥܣܲܪ ܒܬܘܼܠܵܬܹ̈‌ܐ ܕܫܩܝܼܠܔ ܠܗܘܿܢ ܠܲܡܦܝܼ̈ܕܵܝܗ‌ܝ ܘܦܠܝܼܛ ܠܗܘܿܢ ܠܐܘܼܪܚܵܐ ܕܚܸܬܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","”ܚܲܡܸܫ ܡ̣ܢ ܐܲܢܹܐ ܒܬܘܼܠܵܬܹ̈‌ܐ ܗܵܘܢܵܢܹ̈ܐ ܝܗܘܵܘ، ܘܚܲܡܸܫ ܡܸܢܵܝܗ‌ܝ ܣܲܟ݂ܠܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","”ܐܵܢܝܼ ܚܲܡܸܫ ܣܲܟ݂ܠܹ̈ܐ ܫܩܝܼܠܔ ܠܗܘܿܢ ܠܲܡܦܝܼ̈ܕܵܝܗ‌ܝ، ܐܝܼܢܵܐ ܠܵܐ ܫܩܝܼܠܔ ܠܗܘܿܢ ܥܲܡܵܝܗ‌ܝ ܡܸܫܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","”ܐܝܼܢܵܐ ܐܵܢܝܼ ܚܲܡܸܫ ܗܵܘܢܵܢܹ̈ܐ ܫܩܝܼܠܔ ܠܗܘܿܢ ܠܲܡܦܝܼ̈ܕܵܝܗ‌ܝ ܘܐܘܼܦ ܡܸܫܚܵܐ ܥܲܡܵܝܗ‌ܝ ܓܵܘ ܡܵܐܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","”ܘܟܲܕ ܥܘܼܪܩܸܠܔ ܠܹܗ ܚܸܬܢܵܐ، ܕܡܝܼܟ݂ ܠܗܘܿܢ ܟܠܵܝܗ‌ܝ ܘܛܠܝܼܥ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","”ܘܒܦܲܠܓܵܐ ܕܠܲܝܠܹܐ ܗܘܹܐ ܠܵܗ̇ ܡܲܩܘܲܚܬܵ‌ܐ: ’ܗܵܐ ܚܸܬܢܵܐ ܒܹܐܬܵܝܵܐ ܝܠܹܗ، ܦܠܘܿܛܘܼܢ ܠܐܘܼܪܚܹܗ.‘ ");
INSERT INTO aii_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","”ܗ̇ܝܓܵܗ ܩܝܼܡ ܠܗܘܿܢ ܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܒܬܘܼܠܵܬܹ̈‌ܐ ܘܗܘܼܕܸܪܗܘܿܢ ܠܲܡܦܝܼ̈ܕܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","”ܐܡܝܼܪܗܘܿܢ ܐܵܢܝܼ ܒܬܘܼܠܵܬܹ̈‌ܐ ܣܲܟ݂ܠܹ̈ܐ ܠܐܵܢܝܼ ܗܵܘܢܵܢܹ̈ܐ: ’ܗܲܒ݂ܠܘܼܢ ܠܲܢ ܡ̣ܢ ܡܸܫܚܵܘܟ݂ܘܿܢ، ܣܵܒܵܒ ܠܲܡܦܝܼ̈ܕܲܢ ܒܸܟ̰ܡܵܥܵܐ ܝܢܵܐ.‘“ ");
INSERT INTO aii_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","”ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܐܵܢܝܼ ܗܵܘܢܵܢܹ̈ܐ ܘܐܡܝܼܪܗܘܿܢ: ’ܠܵܐ. ܣܵܒܵܒ ܠܹܐ ܡܵܠܹܐ ܐܸܠܲܢ ܘܐܸܠܵܘܟ݂ܘܿܢ. ܙܹܠ݇ܡܘܼܢ ܠܟܸܣ ܙܲܒܢܵܢܹ̈ܐ ܘܙܒ݂ܘܿܢܘܼܢ ܠܵܘܟ݂ܘܿܢ.‘ ");
INSERT INTO aii_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","”ܘܟܲܕ ܐܙܝܼܠܔ ܠܗܘܿܢ ܠܸܙܒ݂ܵܢܵܐ، ܐܬܹ‌ܐ ܠܹܗ ܚܸܬܢܵܐ. ܘܐܵܢܝܼ ܕܗܕܝܼܪܹܐ ܝܗܘܵܘ ܥܒ݂ܝܼܪܗܘܿܢ ܥܲܡܹܗ ܠܒܹܝܬ ܚܠܘܼܠܵܐ، ܘܦܝܼܫ ܠܹܗ ܕܒ݂ܝܼܪܵܐ ܬܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","”ܒܚܲܪܬܵ‌ܐ ܐܬܹ‌ܐ ܠܗܘܿܢ ܐܘܼܦ ܐܵܢܝܼ ܒܬܘܼܠܵܬܹ̈‌ܐ ܐܚܹܪ̈ܢܹܐ، ܘܐܡܝܼܪܗܘܿܢ: ’ܡܵܪܲܢ، ܡܵܪܲܢ، ܦܬܘܿܚ ܐܸܠܲܢ ܬܲܪܥܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","”ܐܝܼܢܵܐ ܚܸܬܢܵܐ ܓ̰ܘܼܘܸܒ ܠܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ’ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܠܹܐ ܝܵܕܥܹܢܵܘܟ݂ܘܿܢ.‘ ");
INSERT INTO aii_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","”ܗܵܕܟ݂ܵܐ ܦܘܼܫܘܼܢ ܪܥܝܼܫܹܐ، ܣܵܒܵܒ ܠܹܐ ܝܵܕܥܝܼܬܘܿܢ ܠܗ̇ܘ ܝܵܘܡܵܐ ܘܠܵܐ ܠܗ̇ܝ ܣܵܥܲܬ.“ ");
INSERT INTO aii_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","”ܟܹܐ ܕܵܡܝܵܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ ܠܐܢܵܫܵܐ ܒܹܐܙܵܠܵܐ ܒܣܵܦܵܪ، ܘܩܪܹܐ ܠܹܗ ܠܪܹ̈ܓܵܘܵܬܘܼܗ‌ܝ ܘܣܘܼܦܹܐ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܡܸܢܕܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","”ܠܚܲܕ ܡܸܢܵܝܗ‌ܝ ܝܘܼܗܒܹܠܔ ܠܹܗ ܚܲܡܫܵܐ ܟܲܟܪܹ̈ܐ، ܘܠܗ̇ܘ ܐܚܹܪܢܵܐ ܬܪܹܝ، ܘܠܗ̇ܘ ܐܚܹܪܢܵܐ ܚܲܕ ܟܲܟܪܵܐ، ܠܟܠܔ ܚܲܕ ܡܸܢܵܝܗ‌ܝ ܝܘܼܗܒܹܠܔ ܠܹܗ ܐܲܝܟ݂ ܡܨܵܝܬܹܗ، ܘܫܒ݂ܝܼܩ ܠܹܗ ܘܐܙܝܼܠܔ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","”ܐܙܝܼܠܔ ܠܹܗ ܗ̇ܘ ܕܫܩܝܼܠܔ ܠܹܗ ܚܲܡܫܵܐ ܟܲܟܪܹ̈ܐ ܘܦܠܝܼܚ ܠܹܗ ܒܝܼܵܝܗ‌ܝ، ܘܡܘܼܙܝܸܕ ܠܹܗ ܥܲܠܵܝܗ‌ܝ ܚܲܡܫܵܐ ܟܲܟܪܹ̈ܐ ܐܚܹܪ̈ܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","”ܗܵܕܟ݂ܵܐ ܐܘܼܦ ܗ̇ܘ ܕܫܩܝܼܠܔ ܠܹܗ ܬܪܹܝ ܟܲܟܪܹ̈ܐ، ܦܠܝܼܚ ܠܹܗ ܒܝܼܵܝܗ‌ܝ ܘܩܢܹܐ ܠܹܗ ܬܪܹܝ ܟܲܟܪܹ̈ܐ ܐܚܹܪ̈ܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","”ܐܝܼܢܵܐ ܗ̇ܘ ܕܫܩܝܼܠܔ ܠܹܗ ܚܲܕ ܟܲܟܪܵܐ ܐܙܝܼܠܔ ܠܹܗ ܘܚܦܝܼܪܹܗ ܐܲܪܥܵܐ ܘܛܘܼܫܹܐ ܠܹܗ ܙܘܼܙܵܐ ܕܡܵܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","”ܡ̣ܢ ܒܵܬܪ ܚܲܕ ܙܲܒ݂ܢܵܐ ܝܲܪܝܼܟ݂ܵܐ، ܕܝܼܪܹܗ ܡܵܪܵܐ ܕܐܵܢܝܼ ܪܹ̈ܓܵܘܵܬܹ‌ܐ، ܘܫܩܝܼܠܔ ܠܹܗ ܚܸܫܒܘܼܢܵܐ ܡܸܢܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","”ܐܬܹ‌ܐ ܠܹܗ ܗ̇ܘ ܕܝܼܗܘܵܐ ܫܩܝܼܠܵܐ ܚܲܡܫܵܐ ܟܲܟܪܹ̈ܐ، ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܚܲܡܫܵܐ ܟܲܟܪܹ̈ܐ ܐܚܹܪ̈ܢܹܐ ܙܵܘܕܵܐ، ܘܐܡܝܼܪܹܗ: ’ܡܵܪܝܼ، ܚܲܡܫܵܐ ܟܲܟܪܹ̈ܐ ܝܘܼܗܒܹܠܔ ܠܘܼܟ݂ ܐܸܠܝܼ، ܗܵܐ ܚܲܡܫܵܐ ܐܚܹܪ̈ܢܹܐ ܡܘܼܙܝܸܕ ܠܝܼ ܥܲܠܵܝܗ‌ܝ.‘ ");
INSERT INTO aii_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","”ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܡܵܪܹܗ: ’ܛܘܼܒ݂ܵܐ ܐܸܠܘܼܟ݂ ܪܹܓܵܐ ܛܵܒ݂ܵܐ ܘܡܗܘܼܡܢܵܐ، ܥܲܠܔ ܚܲܕܟ̰ܵܐ ܗܘܹܐ ܠܘܼܟ݂ ܡܗܘܼܡܢܵܐ، ܥܲܠܔ ܪܵܒܵܐ ܒܸܬ ܥܵܒ݂ܕܹܢܘܼܟ݂ ܡܕܲܒܪܵܢܵܐ، ܥܒ݂ܘܿܪ ܠܚܲܕܘܼܬܵ‌ܐ ܕܡܵܪܘܼܟ݂.‘ ");
INSERT INTO aii_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","”ܘܐܬܹ‌ܐ ܠܹܗ ܗ̇ܘ ܕܫܩܝܼܠܵܐ ܝܗܘܵܐ ܬܪܹܝ ܟܲܟܪܹ̈ܐ ܘܐܡܝܼܪܹܗ: ’ܡܵܪܝܼ، ܬܪܹܝ ܟܲܟܪܹ̈ܐ ܝܘܼܗܒܹܠܔ ܠܘܼܟ݂ ܐܸܠܝܼ. ܗܵܐ ܬܪܹܝ ܐܚܹܪ̈ܢܹܐ ܡܘܼܙܝܸܕ ܠܝܼ ܥܲܠܵܝܗ‌ܝ.‘ ");
INSERT INTO aii_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","”ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ ܡܵܪܹܗ: ’ܛܘܼܒ݂ܵܐ ܐܸܠܘܼܟ݂ ܪܹܓܵܐ ܛܵܒ݂ܵܐ ܘܡܗܘܼܡܢܵܐ، ܥܲܠܔ ܚܲܕܟ̰ܵܐ ܗܘܹܐ ܠܘܼܟ݂ ܡܗܘܼܡܢܵܐ. ܥܲܠܔ ܪܵܒܵܐ ܒܸܬ ܥܵܒ݂ܕܹܢܘܼܟ݂ ܡܕܲܒܪܵܢܵܐ. ܥܒ݂ܘܿܪ ܠܚܲܕܘܼܬܵ‌ܐ ܕܡܵܪܘܼܟ݂.‘ ");
INSERT INTO aii_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","”ܘܐܬܹ‌ܐ ܠܹܗ ܐܘܼܦ ܗ̇ܘ ܕܫܩܝܼܠܵܐ ܝܗܘܵܐ ܚܲܕ ܟܲܟܪܵܐ، ܘܐܡܝܼܪܹܗ: ’ܡܵܪܝܼ، ܟܹܐ ܝܵܕܥܹܢ ܗܘܵܐ ܠܘܼܟ݂ ܕܐܢܵܫܵܐ ܩܸܫܝܵܐ ܝܘܸܬ، ܟܹܐ ܚܵܨܕܹܬ ܡ̣ܢ ܐܲܝܟܵܐ ܕܠܵܐ ܙܪܝܼܥ ܠܘܼܟ݂، ܘܟܹܐ ܓ̰ܲܡܥܸܬ ܡ̣ܢ ܐܲܝܟܵܐ ܕܠܵܐ ܒܙܝܼܩ ܠܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","”’ܒܘܼܬ ܐܵܗܵܐ ܙܕܝܼܥ ܠܝܼ، ܐܙܝܼܠܔ ܠܝܼ ܘܛܘܼܫܹܐ ܠܝܼ ܟܲܟܪܘܼܟ݂ ܒܐܲܪܥܵܐ، ܫܩܘܿܠܔ ܟܲܟܪܘܼܟ݂ ܐܵܕܝܼܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","”ܓ̰ܘܼܘܸܒ ܠܹܗ ܡܵܪܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ’ܪܹܓܵܐ ܒܝܼܫܵܐ ܘܡܲܟܣܸܠܵܢܵܐ، ܒܝܼܕܵܥܵܐ ܝܘܸܬ ܗܘܵܐ ܕܟܹܐ ܚܵܨܕܹܢ ܡ̣ܢ ܐܲܝܟܵܐ ܕܠܵܐ ܙܪܝܼܥ ܠܝܼ، ܘܟܹܐ ܓ̰ܲܡܥܸܢ ܡ̣ܢ ܐܲܝܟܵܐ ܕܠܵܐ ܒܙܝܼܩ ܠܝܼ، ");
INSERT INTO aii_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","”’ܘܵܠܹܐ ܝܗܘܵܐ ܐܸܠܘܼܟ݂ ܕܡܲܬܒܸܬ ܗܘܵܐ ܙܘܼܙܝܼ ܥܲܠܔ ܦܵܬܘܿܪܵܐ ܕܨܲܪ̈ܵܦܹܐ، ܘܐܵܬܹܝܢ ܗܘܵܐ ܘܫܵܩܠܹܢ ܗܘܵܐ ܟܲܟܪܝܼ ܥܲܡ ܙܵܘܕܘܼܢܝܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","”’ܒܘܼܬ ܐܵܗܵܐ، ܫܩܘܿܠܘܼܢ ܡܸܢܹܗ ܟܲܟܪܵܐ، ܘܗܲܒ݂ܠܘܼܢ ܠܹܗ ܠܗ̇ܘ ܕܐܝܼܬ ܠܹܗ ܥܸܣܪܵܐ ܟܲܟܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","”’ܣܵܒܵܒ ܟܠܔ ܡ̇ܢ ܕܐܝܼܬ ܠܹܗ ܒܸܬ ܦܵܐܹܫ ܝܘܼܗܒ݂ܵܐ ܐܸܠܹܗ، ܘܒܸܬ ܦܵܐܹܫ ܡܘܼܙܝܸܕܵܐ ܐܸܠܹܗ، ܐܝܼܢܵܐ ܗ̇ܘ ܕܠܲܝܬ ܠܹܗ، ܐܘܼܦ ܗ̇ܘ ܕܐܝܼܬ ܠܹܗ ܒܸܬ ܦܵܐܹܫ ܫܩܝܼܠܵܐ ܡܸܢܹܗ، ");
INSERT INTO aii_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","”’ܘܠܪܹܓܵܐ ܠܵܐ ܝܘܼܬܪܵܢܵܐ ܦܲܠܛܘܼܢ ܠܚܸܫܟܵܐ ܒܲܪܵܝܵܐ ܐܲܝܟܵܐ ܕܐܝܼܬ ܒܸܟ݂ܝܵܐ ܘܚܲܪܚܲܟ̰ܬܵ‌ܐ ܕܟܹܟܹ̈ܐ.‘ ");
INSERT INTO aii_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","”ܐܝܼܡܲܢ ܕܐܵܬܹ‌ܐ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܚܸܩܪܹܗ، ܘܟܠܵܝܗ‌ܝ ܡܲܠܲܐܟ݂ܘܼ̈ܗ‌ܝ ܥܲܡܹܗ، ܗ̇ܝܓܵܗ ܒܸܬ ܝܵܬܹܒ݂ ܥܲܠܔ ܬܪܘܿܢܘܿܣ ܕܚܸܩܪܹܗ، ");
INSERT INTO aii_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","”ܘܒܸܬ ܦܵܝܫܝܼ ܓ̰ܘܼܡܥܹܐ ܩܲܕܡܘܼܗ‌ܝ ܟܠܵܝܗ‌ܝ ܐܸܡܘܵܬܹ̈‌ܐ، ܘܒܸܬ ܦܵܪܹܫ ܠܗܘܿܢ ܐܢܵܫܹ̈ܐ ܚܲܕ ܡ̣ܢ ܗ̇ܘ ܐܚܹܪܢܵܐ، ܐܲܝܟ݂ ܪܵܥܝܵܐ ܕܦܵܪܹܫ ܥܸܪ̈ܒܹܐ ܡ̣ܢ ܥܸܙܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","”ܒܸܬ ܡܲܟܠܹܐ ܥܸܪ̈ܒܹܐ ܡ̣ܢ ܝܲܡܝܼܢܹܗ، ܘܥܸܙܹ̈ܐ ܡ̣ܢ ܣܸܡܵܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","”ܗ̇ܝܓܵܗ ܒܸܬ ܐܵܡܹܪ ܡܲܠܟܵܐ ܠܐܵܢܝܼ ܕܡ̣ܢ ܝܲܡܝܼܢܹܗ: ’ܬܹܝܡܘܼܢ ܒܪ̈ܝܼܟܹܐ ܕܒܵܒܝܼ، ܩܲܒܠܘܼܢ ܝܵܪܬܘܼܬܵ‌ܐ ܠܡܲܠܟܘܼܬܵ‌ܐ ܕܝܼܗܘܵܐ ܗܘܼܕܸܪܬܵ‌ܐ ܐܸܠܵܘܟ݂ܘܿܢ ܡ̣ܢ ܫܘܼܪܵܝܵܐ ܕܒܪܝܼܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","”’ܣܵܒܵܒ ܟܦܝܼܢܝܼ ܘܡܘܼܐܟܸܠܔ ܠܵܘܟ݂ܘܿܢ ܐܸܠܝܼ، ܨܗܹܐ ܠܝܼ ܘܡܘܼܫܬܹ‌ܐ ܠܵܘܟ݂ܘܿܢ ܐܸܠܝܼ، ܢܘܼܟ݂ܪܵܝܵܐ ܗܘܹܐ ܠܝܼ، ܘܡܘܼܫܪܹܐ ܠܵܘܟ݂ܘܿܢ ܐܸܠܝܼ، ");
INSERT INTO aii_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","”’ܫܘܼܠܚܵܝܵܐ ܗܘܹܐ ܠܝܼ ܘܡܘܼܠܒܸܫ ܠܵܘܟ݂ܘܿܢ ܐܸܠܝܼ، ܡܪܝܼܥܵܐ ܗܘܹܐ ܠܝܼ ܘܬܦܝܼܩ ܠܵܘܟ݂ܘܿܢ ܒܝܼܝܼ، ܓܵܘ ܒܹܝܬ ܐܲܣܝܼܪܹ̈ܐ ܗܘܹܐ ܠܝܼ ܘܐܬܹ‌ܐ ܠܵܘܟ݂ܘܿܢ ܠܟܸܣܠܝܼ.‘ ");
INSERT INTO aii_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","”ܗ̇ܝܓܵܗ ܒܸܬ ܓ̰ܲܘܸܒܝܼ ܐܵܢܝܼ ܙܲܕܝܼܩܹ̈ܐ ܘܐܵܡܪܝܼ ܐܸܠܹܗ: ’ܡܵܪܲܢ، ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܲܢ ܐܸܠܘܼܟ݂ ܟܦܝܼܢܹ̈ܐ ܘܬܘܼܪܣܹܐ ܠܲܢ ܐܸܠܘܼܟ݂، ܝܲܢ ܨܹܗܝܵܐ ܘܡܘܼܫܬܹ‌ܐ ܠܲܢ ܐܸܠܘܼܟ݂؟ ");
INSERT INTO aii_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","”’ܘܐܝܼܡܲܢ ܚܙܹܐ ܠܲܢ ܐܸܠܘܼܟ݂ ܢܘܼܟ݂ܪܵܝܵܐ ܘܡܘܼܫܪܹܐ ܠܲܢ ܐܸܠܘܼܟ݂؟ ܝܲܢ ܫܘܼܠܚܵܝܵܐ ܘܡܘܼܠܒܸܫ ܠܲܢ ܐܸܠܘܼܟ݂؟ ");
INSERT INTO aii_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","”’ܘܐܝܼܡܲܢ ܚܙܹܐ ܠܲܢ ܐܸܠܘܼܟ݂ ܡܪܝܼܥܵܐ ܝܲܢ ܓܵܘ ܒܹܝܬ ܐܲܣܝܼܪܹ̈ܐ ܘܐܬܹ‌ܐ ܠܲܢ ܠܟܸܣܠܘܼܟ݂؟‘ ");
INSERT INTO aii_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","”ܒܸܬ ܓ̰ܲܘܸܒ ܡܲܠܟܵܐ ܘܐܵܡܹܪ ܐܸܠܵܝܗ‌ܝ: ’ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܣܵܒܵܒ ܥܒ݂ܝܼܕ ܠܵܘܟ݂ܘܿܢ ܐܲܢܹܐ ܠܚܲܕ ܡ̣ܢ ܐܲܚܘܿܢܘܵܬ‌ܝܼ̈ ܙܥܘܿܪܹ̈ܐ، ܐܲܝܟ݂ ܕܐܸܢ ܐܸܠܝܼ ܥܒ݂ܝܼܕ ܠܵܘܟ݂ܘܿܢ.‘ ");
INSERT INTO aii_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","”ܗ̇ܝܓܵܗ ܒܸܬ ܐܵܡܹܪ ܐܘܼܦ ܠܐܵܢܝܼ ܕܡ̣ܢ ܣܸܡܵܠܹܗ: ’ܪܚܘܿܩܘܼܢ ܡܸܢܝܼ ܝܵܐ ܠܝܼ̈ܛܹܐ ܠܢܘܼܪܵܐ ܕܠܥܵܠܲܡ، ܕܝܼܠܹܗ ܗܘܼܕܪܵܐ ܩܵܐ ܐܵܟܹܠܩܲܪܨܵܐ ܘܦܲܠܵܚܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","”’ܣܵܒܵܒ ܟܦܝܼܢܝܼ ܘܠܵܐ ܡܘܼܐܟܸܠܔ ܠܵܘܟ݂ܘܿܢ ܐܸܠܝܼ، ܘܨܗܹܐ ܠܝܼ ܘܠܵܐ ܡܘܼܫܬܹ‌ܐ ܠܵܘܟ݂ܘܿܢ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","”ܢܘܼܟ݂ܪܵܝܵܐ ܗܘܹܐ ܠܝܼ ܘܠܵܐ ܡܘܼܫܪܹܐ ܠܵܘܟ݂ܘܿܢ ܐܸܠܝܼ، ܫܘܼܠܚܵܝܵܐ ܗܘܹܐ ܠܝܼ ܘܠܵܐ ܡܘܼܠܒܸܫ ܠܵܘܟ݂ܘܿܢ ܐܸܠܝܼ، ܡܪܝܼܥܵܐ ܗܘܹܐ ܠܝܼ ܘܓܵܘ ܒܹܝܬ ܐܲܣܝܼܪܹ̈ܐ ܗܘܹܐ ܠܝܼ، ܘܠܵܐ ܬܦܝܼܩ ܠܵܘܟ݂ܘܿܢ ܒܝܼܝܼ.‘ ");
INSERT INTO aii_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","”ܗ̇ܝܓܵܗ ܐܘܼܦ ܐܵܢܝܼ ܒܸܬ ܓ̰ܲܘܸܒܝܼ ܐܸܠܹܗ ܘܐܵܡܪܝܼ: ’ܡܵܪܲܢ، ܐܝܼܡܲܢ ܚܙܹܐ ܠܲܢ ܐܸܠܘܼܟ݂ ܟܦܝܼܢܵܐ، ܝܲܢ ܨܹܗܝܵܐ، ܝܲܢ ܢܘܼܟ݂ܪܵܝܵܐ، ܝܲܢ ܫܘܼܠܚܵܝܵܐ، ܝܲܢ ܡܪܝܼܥܵܐ، ܝܲܢ ܓܵܘ ܒܹܝܬ ܐܲܣܝܼܪܹ̈ܐ ܘܠܵܐ ܥܒ݂ܝܼܕ ܠܲܢ ܚܸܠܡܲܬ ܐܸܠܘܼܟ݂؟‘ ");
INSERT INTO aii_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","”ܘܗ̇ܘ ܒܸܬ ܓ̰ܲܘܸܒ ܘܐܵܡܹܪ ܐܸܠܵܝܗ‌ܝ: ’ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܣܵܒܵܒ ܠܵܐ ܥܒ݂ܝܼܕ ܠܵܘܟ݂ܘܿܢ ܐܲܢܹܐ ܠܚܲܕ ܡ̣ܢ ܐܲܢܹܐ ܙܥܘܿܪܹ̈ܐ، ܐܸܠܝܼ ܠܵܐ ܥܒ݂ܝܼܕ ܠܵܘܟ݂ܘܿܢ.‘ ");
INSERT INTO aii_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","”ܐܲܢܹܐ ܒܸܬ ܐܵܙܠ݇ܝܼ ܠܓ̰ܘܼܢܓ̰ܵܪܵܐ ܕܠܥܵܠܲܡ، ܘܙܲܕܝܼܩܹ̈ܐ ܠܚܲܝܹ̈ܐ ܕܠܥܵܠܲܡ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ܟܲܕ ܬܘܼܡܸܡ ܠܹܗ ܝܼܫܘܿܥ ܟܠܵܝܗ‌ܝ ܗܹܡܸܙܡܵܢܘܼ̈ܗ‌ܝ، ܐܡܝܼܪܹܗ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ");
INSERT INTO aii_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","”ܒܝܼܕܵܥܵܐ ܝܬܘܿܢ ܕܡ̣ܢ ܒܵܬܪ ܬܪܹܝ ܝܵܘܡܵܢܹ̈ܐ ܒܸܬ ܗܵܘܹܐ ܥܹܐܕܵܐ ܕܦܸܨܚܵܐ، ܘܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܸܬ ܦܵܐܹܫ ܣܘܼܦܝܵܐ ܘܒܸܬ ܦܵܐܹܫ ܡܸܚܝܵܐ ܠܙܩܝܼܦܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ܗ̇ܝܓܵܗ ܓ̰ܡܝܼܥ ܠܗܘܿܢ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܣܵܦܪܹ̈ܐ ܘܚܘܵܪ̈ܕܸܩܢܹܐ ܕܥܲܡܵܐ ܓܵܘ ܕܵܪܬܵ‌ܐ ܕܓܘܼܪܵܐ ܕܟܵܗ̈ܢܹܐ ܫܸܡܹܗ ܩܲܝܵܦܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ܘܟܠܵܝܗ‌ܝ ܣܘܼܙܓܸܪܗܘܿܢ ܥܲܡ ܥܘܼܕܵܠܹܐ ܕܒܦܸܠܡܵܐ ܕܵܒ݂ܩܝܼ ܠܝܼܫܘܿܥ ܘܩܵܛܠܝܼ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ܐܝܼܢܵܐ ܐܡܝܼܪܗܘܿܢ: ”ܠܵܐ ܒܥܹܐܕܵܐ، ܕܠܵܐ ܗܵܘܹܐ ܫܓ݂ܘܼܫܝܵܐ ܓܵܘ ܥܲܡܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ܘܐܬܹ‌ܐ ܠܹܗ ܝܼܫܘܿܥ ܠܒܹܝܬ ܥܲܢܝܵܐ، ܘܥܒ݂ܝܼܪܹܗ ܓܵܘ ܒܲܝܬܵ‌ܐ ܕܫܸܡܥܘܿܢ ܓܸܪܒ݂ܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ܐܬܹ‌ܐ ܠܵܗ̇ ܠܟܸܣܠܹܗ ܚܕܵܐ ܒܲܟ݂ܬܵ‌ܐ ܘܥܲܡܘܼܗ̇ ܚܕܵܐ ܫܵܛܝܼܦܬܵ‌ܐ ܕܡܸܫܚܵܐ ܕܒܸܣܡܵܐ ܪܵܒܵܐ ܛܝܼܡܵܢܵܐ، ܫܘܼܦܸܟ݂ ܠܵܗ̇ ܥܲܠܔ ܪܹܝܫܵܐ ܕܝܼܫܘܿܥ ܟܲܕ ܗ̇ܘ ܝܬܝܼܒ݂ܵܐ ܠܣܘܼܦܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ܐܝܼܢܵܐ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܟܲܕ ܚܙܹܐ ܠܗܘܿܢ ܐܵܗܵܐ، ܟܪܝܼܒ ܠܗܘܿܢ ܘܐܡܝܼܪܗܘܿܢ: ”ܩܵܡܘܿܕܝܼ ܟܠܹܗ ܐܵܗܵܐ ܚܘܼܣܪܵܢܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","”ܣܵܒܵܒ ܘܵܠܹܐ ܝܗܘܵܐ ܕܦܵܐܹܫ ܗܘܵܐ ܙܘܼܒܢܵܐ ܐܵܗܵܐ ܡܸܫܚܵܐ ܒܙܘܼܙܹ̈ܐ ܪܵܒܵܐ ܘܝܘܼܗܒ݂ܵܐ ܠܡܸܣܟܹܢܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܝܕܝܼܥ ܠܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܩܵܡܘܿܕܝܼ ܡܲܠܝܘܼܨܹܐ ܝܬܘܿܢ ܠܐܵܗܵܐ ܒܲܟ݂ܬܵ‌ܐ؟ ܦܘܼܠܚܵܢܵܐ ܛܵܒ݂ܵܐ ܥܒ݂ܝܼܕ ܠܵܗ̇ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","”ܡܸܣܟܹܢܹ̈ܐ ܒܟܠܔ ܙܲܒ݂ܢܵܐ ܥܲܡܵܘܟ݂ܘܿܢ ܝܼܢܵܐ، ܐܝܼܢܵܐ ܐܵܢܵܐ ܠܹܐ ܝܘܸܢ ܥܲܡܵܘܟ݂ܘܿܢ ܒܟܠܔ ܙܲܒ݂ܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","”ܐܵܗܵܐ ܒܲܟ݂ܬܵ‌ܐ ܫܘܼܦܸܟ݂ ܠܵܗ̇ ܐܵܗܵܐ ܒܸܣܡܵܐ ܥܲܠܔ ܦܲܓ݂ܪܝܼ، ܐܲܝܟ݂ ܕܐܸܢ ܥܲܠܔ ܩܒ݂ܵܪܬ‌ܝܼ ܥܒ݂ܝܼܕ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܒܟܠܔ ܥܕܵܢܵܐ ܕܦܵܐܹܫ ܡܘܼܟܪܸܙܵܐ ܐܵܗܵܐ ܐܹܘܲܢܓܲܠܝܼܘܿܢ ܒܟܠܵܗ̇ ܕܘܼܢܝܹܐ، ܒܸܬ ܦܵܐܹܫ ܡܘܼܕܟܸܪܵܐ ܐܵܗܵܐ ܡܸܢܕܝܼ ܕܥܒ݂ܝܼܕ ܠܵܗ̇ ܐܵܗܵܐ ܒܲܟ݂ܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ܗ̇ܝܓܵܗ ܐܙܝܼܠܔ ܠܹܗ ܚܲܕ ܡ̣ܢ ܬܪܸܥܣܲܪ ܬܲܠܡܝܼ̈ܕܹܐ ܫܸܡܹܗ ܝܼܗܘܼܕܵܐ ܣܟܲܪܝܘܿܛܵܐ ܠܟܸܣ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ، ");
INSERT INTO aii_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܡܘܼܕܝܼ ܒܸܬ ܝܵܗܒ݂ܝܼܬܘܿܢ ܠܝܼ ܕܣܲܦܸܢܹܗ ܐܸܠܵܘܟ݂ܘܿܢ؟“ ܘܐܵܢܝܼ ܥܒ݂ܝܼܕ ܠܗܘܿܢ ܩܵܘܠܵܐ ܥܲܡܹܗ ܕܒܸܬ ܝܵܗܒ݂ܝܼ ܠܹܗ ܬܠܵܬ‌ܝܼ ܙܘܼܙܹ̈ܐ ܕܣܹܐܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ܘܡ̣ܢ ܗ̇ܘ ܝܵܘܡܵܐ ܗܘܹܐ ܠܹܗ ܒܸܛܥܵܝܵܐ ܒܵܬܪ ܦܸܪܣܲܬ ܕܣܲܦܹܐ ܗܘܵܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ܒܝܵܘܡܵܐ ܩܲܕܡܵܝܵܐ ܕܦܲܛܝܼܪܹ̈ܐ ܐܬܹ‌ܐ ܠܗܘܿܢ ܬܲܠܡܝܼ̈ܕܹܐ ܠܟܸܣ ܝܼܫܘܿܥ ܘܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ: ”ܐܲܝܟܵܐ ܒܵܥܹܝܬ ܕܗܲܕܪܲܚ ܐܸܠܘܼܟ݂ ܕܐܵܟ݂ܠܹܬ ܦܸܨܚܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܙܹܠ݇ܡܘܼܢ ܠܡܕܝܼܢ݇ܬܵ‌ܐ ܠܟܸܣ ܦܸܠܲܢ، ܘܐܡܘܿܪܘܼܢ ܐܸܠܹܗ: ’ܪܲܒܝܼܲܢ ܒܹܐܡܵܪܵܐ ܝܠܹܗ، ܥܕܵܢܝܼ ܡܛܹܐ ܠܵܗ̇، ܒܵܥܹܝܢ ܥܵܒ݂ܕܹܢ ܦܸܨܚܵܐ ܠܟܸܣܠܘܼܟ݂ ܥܲܡ ܬܲܠܡܝܼܕܝܼ̈.‘“ ");
INSERT INTO aii_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ܘܥܒ݂ܝܼܕ ܠܗܘܿܢ ܬܲܠܡܝܼ̈ܕܹܐ ܐܲܝܟ݂ ܕܦܩܝܼܕܵܝ ܠܹܗ ܝܼܫܘܿܥ، ܘܗܘܼܕܸܪܗܘܿܢ ܦܸܨܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ܐܝܼܡܲܢ ܕܗܘܹܐ ܠܹܗ ܪܲܡܫܵܐ، ܝܬܝܼܒ݂ܵܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܠܣܘܼܦܪܵܐ ܥܲܡ ܬܪܸܥܣܲܪ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ܘܟܲܕ ܒܹܐܟ݂ܵܠܵܐ ܝܗܘܵܘ، ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܚܲܕ ܡܸܢܵܘܟ݂ܘܿܢ ܒܸܬ ܣܲܦܹܐ ܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ܦܫܝܼܡ ܠܗܘܿܢ ܪܵܒܵܐ، ܘܫܘܼܪܹܐ ܠܗܘܿܢ ܠܒܲܩܘܼܪܹܐ ܡܸܢܹܗ، ܚܲܕ ܒܚܲܕ: ”ܐܵܢܵܐ ܝܘܸܢ، ܡܵܪܝܼ؟“ ");
INSERT INTO aii_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ܘܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ ܘܐܡܝܼܪܹܗ: ”ܗ̇ܘ ܕܒܸܛܡܵܫܵܐ ܝܠܹܗ ܐܝܼܕܹܗ ܥܲܡܝܼ ܒܡܵܐܢܵܐ، ܗ̇ܘ ܒܸܬ ܣܲܦܹܐ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","”ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܹܐܙܵܠܵܐ ܝܠܹܗ ܕܵܐܟ݂ܝܼ ܕܝܼܠܹܗ ܟܬܝܼܒ݂ܵܐ ܒܘܼܬ ܕܝܼܹܗ، ܐܝܼܢܵܐ ܘܵܝ ܠܗ̇ܘ ܐܢܵܫܵܐ ܕܒܐܝܼܕܹܗ ܦܵܐܹܫ ܣܘܼܦܝܵܐ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ. ܒܘܼܫ ܨܦܵܝܝܼ ܝܗܘܵܐ ܠܗ̇ܘ ܐܢܵܫܵܐ ܕܠܵܐ ܦܵܐܹܫ ܗܘܵܐ ܝܠܝܼܕܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ܒܘܼܩܸܪܹܗ ܝܼܗܘܼܕܵܐ ܣܲܦܝܵܢܵܐ ܘܐܡܝܼܪܹܗ: ”ܪܲܒܝܼ، ܐܵܢܵܐ ܝܘܸܢ؟“ ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ: ”ܐܲܢ݇ܬ ܐܡܝܼܪܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ܘܟܲܕ ܒܹܐܟ݂ܵܠܵܐ ܝܗܘܵܘ، ܫܩܝܼܠܔ ܠܹܗ ܝܼܫܘܿܥ ܠܲܚܡܵܐ ܘܒܘܼܪܸܟ݂ ܠܹܗ ܘܩܨܹܐ ܠܹܗ، ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܐܡܝܼܪܹܗ: ”ܫܩܘܿܠܘܼܢ ܐܟ݂ܘܿܠܘܼܢ، ܐܵܗܵܐ ܝܠܹܗ ܦܲܓ݂ܪܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ܘܫܩܝܼܠܔ ܠܹܗ ܟܵܣܵܐ، ܘܫܘܼܟܸܪܹܗ ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܘܐܡܝܼܪܹܗ: ”ܫܩܘܿܠܘܼܢ ܘܫܬܹܝܡܘܼܢ ܡܸܢܹܗ ܟܠܵܘܟ݂ܘܿܢ، ");
INSERT INTO aii_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","”ܣܵܒܵܒ ܐܵܗܵܐ ܝܠܹܗ ܕܸܡܝܼ ܕܘܲܥܕܵܐ ܚܵܕܬܵ‌ܐ ܕܡ̣ܢ ܓܹܒܵܐ ܕܪܵܒܵܐ ܦܝܵܫܵܐ ܝܠܹܗ ܫܘܼܦܟ݂ܵܐ ܠܦܘܼܚܵܠܵܐ ܕܚܛܝܼܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","”ܗܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܡ̣ܢ ܐܵܕܝܼܵܐ ܠܹܐ ܫܵܬܹܝܢ ܡ̣ܢ ܛܥܘܼܢܬܵ‌ܐ ܕܐܵܗܵܐ ܓܸܦܬܵ‌ܐ ܗܲܠܔ ܗ̇ܘ ܝܵܘܡܵܐ ܕܫܵܬܹܢܵܗ̇ ܚܲܕܬܵ‌ܐ ܥܲܡܵܘܟ݂ܘܿܢ ܒܡܲܠܟܘܼܬܵ‌ܐ ܕܒܵܒܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ܘܡ̣ܢ ܒܵܬܪ ܕܫܘܼܒܸܚ ܠܗܘܿܢ، ܦܠܝܼܛ ܠܗܘܿܢ ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܠܛܘܼܪܵܐ ܕܙܲܝ̈ܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ܗ̇ܝܓܵܗ ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܐܸܠܵܝܗ‌ܝ: ”ܟܠܵܘܟ݂ܘܿܢ ܒܸܬ ܫܵܒ݂ܩܝܼܬܘܿܢ ܠܝܼ ܒܐܵܗܵܐ ܠܲܝܠܹܐ. ܣܵܒܵܒ ܟܬܝܼܒ݂ܵܐ ܝܠܹܗ: ܒܸܬ ܡܵܚܹܝܢ ܠܪܵܥܝܵܐ ܘܒܸܬ ܦܵܝܫܝܼ ܒܘܼܪܒܸܙܹܐ ܥܸܪ̈ܒܹܐ ܕܦܸܣܩܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","”ܐܝܼܢܵܐ ܡ̣ܢ ܒܵܬܪ ܕܦܵܝܫܹܢ ܡܘܼܩܸܡܵܐ، ܒܸܬ ܐܵܙܹܠ݇ܢ ܡܩܲܕܡ ܕܝܼܵܘܟ݂ܘܿܢ ܠܓܠܝܼܠܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ܓ̰ܘܼܘܸܒ ܠܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܐܘܼܦ ܐܸܢ ܕܟܠܵܝܗ‌ܝ ܫܵܒ݂ܩܝܼ ܠܘܼܟ݂، ܐܵܢܵܐ ܠܹܐ ܫܵܒ݂ܩܹܢܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܘܼܟ݂، ܒܐܵܗܵܐ ܠܲܝܠܹܐ، ܡ̣ܢ ܩܲܕܡ ܕܩܵܪܹܐ ܩܵܪܘܿܝܵܐ، ܬܠܵܬ ܓܵܗܹ̈ܐ ܒܸܬ ܣܵܪܒܹܬ ܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ: ”ܐܘܼܦ ܐܸܢ ܕܗܵܘܝܵܐ ܕܡܵܝܬܹܢ ܥܲܡܘܼܟ݂ ܠܹܐ ܣܵܪܒܹܢܘܼܟ݂.“ ܘܗܵܕܟ݂ܵܐ ܐܡܝܼܪܗܘܿܢ ܐܘܼܦ ܟܠܵܝܗ‌ܝ ܬܲܠܡܝܼ̈ܕܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ܗ̇ܝܓܵܗ ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܕܘܼܟܵܐ ܕܦܝܵܫܵܐ ܝܠܵܗ̇ ܩܪܝܼܬܵ‌ܐ ܓܲܕܣܹܡܵܢ، ܘܐܡܝܼܪܹܗ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܝܬܘܿܒ݂ܘܼܢ ܐܲܚܬܘܿܢ ܠܲܐܟ݂ܵܐ ܗܲܠܔ ܕܐܵܙܹܠ݇ܢ ܘܨܲܠܹܝܢ ܨܠܘܿܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ܠܘܼܒܸܠܔ ܠܹܗ ܥܲܡܹܗ ܠܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܘܠܬܪܹܝ ܒܢܘܿܢܹ̈ܐ ܕܙܲܒ݂ܕܲܝ، ܘܫܘܼܪܹܐ ܠܹܗ ܠܸܦܫܵܡܵܐ ܘܒܸܥܒ݂ܵܪܵܐ ܒܥܵܘܩܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ܘܐܡܝܼܪܹܗ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܦܫܝܼܡܬܵ‌ܐ ܝܠܵܗ̇ ܓܵܢܝܼ ܗܲܠܔ ܡܵܘܬܵ‌ܐ. ܟܠܹܝܡܘܼܢ ܠܲܐܟ݂ܵܐ ܘܥܒ݂ܘܿܕܘܼܢ ܫܵܗܲܪܬܵ‌ܐ ܥܲܡܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ܘܪܚܝܼܩ ܠܹܗ ܚܲܕ ܡܸܬܚܵܐ ܡܸܢܵܝܗ‌ܝ، ܘܢܦܝܼܠܔ ܠܹܗ ܥܲܠܔ ܦܵܬܹܗ ܘܨܘܼܠܹܐ ܠܹܗ ܒܹܐܡܵܪܵܐ: ”ܝܵܐ ܒܵܒܝܼ، ܐܸܢ ܗܵܘܝܵܐ ܡܲܥܒܸܪ ܡܸܢܝܼ ܐܵܗܵܐ ܟܵܣܵܐ، ܐܝܼܢܵܐ ܠܵܐ ܐܲܝܟ݂ ܕܐܵܢܵܐ ܒܵܣܡܵܐ ܠܝܼ ܐܸܠܵܐ ܐܲܝܟ݂ ܕܐܲܢ݇ܬ ܒܵܣܡܵܐ ܠܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ܘܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܚܸܙܝܵܝ ܠܹܗ ܕܡܝܼܟܹܐ، ܘܐܡܝܼܪܹܗ ܠܫܸܡܥܘܿܢ ܟܹܐܦܵܐ: ”ܗܵܕܟ݂ܵܐ ܠܵܐ ܡܨܹܐ ܠܵܘܟ݂ܘܿܢ ܥܵܒ݂ܕܝܼܬܘܿܢ ܗܘܵܘ ܫܵܗܲܪܬܵ‌ܐ ܥܲܡܝܼ ܚܕܵܐ ܣܵܥܲܬ؟ ");
INSERT INTO aii_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","”ܪܥܘܿܫܘܼܢ ܘܨܲܠܹܝܡܘܼܢ ܕܠܵܐ ܥܵܒ݂ܪܝܼܬܘܿܢ ܠܓ̰ܘܼܪܵܒܵܐ. ܪܘܼܚܵܐ ܟܹܐ ܒܵܥܝܵܐ، ܐܝܼܢܵܐ ܦܲܓ݂ܪܵܐ ܙܲܒܘܼܢ ܝܼܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ܡܸܢܕܪܸܫ ܐܙܝܼܠܔ ܠܹܗ ܓܵܗܵܐ ܕܬܲܪܬܹܝ ܘܨܘܼܠܹܐ ܠܹܗ ܒܹܐܡܵܪܵܐ: ”ܝܵܐ ܒܵܒܝܼ، ܐܸܢ ܠܹܐ ܗܵܘܝܵܐ ܕܥܵܒܹܪ ܡܸܢܝܼ ܐܵܗܵܐ ܟܵܣܵܐ ܐܸܠܵܐ ܕܫܵܬܹܢܹܗ، ܫܒ݂ܘܿܩ ܗܵܘܹܐ ܨܸܒ݂ܝܵܢܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ܘܐܬܹ‌ܐ ܠܹܗ ܡܸܢܕܪܸܫ ܘܚܸܙܝܵܝ ܠܹܗ ܕܡܝܼܟܹܐ ܣܵܒܵܒ ܥܲܝ̈ܢܵܝܗ‌ܝ ܝܘܼܩܪܸܢܹܐ ܝܗܘܵܘ ܒܫܸܢܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ܫܒ݂ܝܼܩܵܝ ܠܹܗ ܘܐܙܝܼܠܔ ܠܹܗ ܡܸܢܕܪܸܫ ܓܵܗܵܐ ܕܬܠܵܬ ܠܨܲܠܘܼܝܹܐ، ܘܬܸܢܝܵܐ ܠܹܗ ܗ̇ܝ ܗܹܡܸܙܡܵܢ ܩܲܕܡܵܝܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ܘܕܝܼܪܹܗ ܠܟܸܣ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܕܡܘܿܟ݂ܘܼܢ ܐܵܕܝܼܵܐ ܘܡܲܢܝܸܚܘܼܢ، ܗܵܐ ܡܛܹܐ ܠܵܗ̇ ܣܵܥܲܬ ܕܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܦܵܐܹܫ ܣܘܼܦܝܵܐ ܒܐܝܼܕܵܬܹ̈‌ܐ ܕܚܲܛܵܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","”ܩܘܼܡܘܼܢ ܕܐܵܙܲܠ݇ܚ، ܗܵܐ ܐܬܹ‌ܐ ܠܹܗ ܗ̇ܘ ܕܣܲܦܹܐ ܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ܟܲܕ ܝܼܫܘܿܥ ܗܲܡܙܘܼܡܹܐ ܝܗܘܵܐ، ܗܵܐ ܝܼܗܘܼܕܵܐ، ܚܲܕ ܡ̣ܢ ܬܪܸܥܣܲܪ ܬܲܠܡܝܼ̈ܕܹܐ ܘܟܸܢܫܵܐ ܪܵܒܵܐ ܥܲܡܹܗ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܒܝܲܕ ܣܲܝܦܹ̈ܐ ܘܚܘܼܛܪܹ̈ܐ، ܫܘܼܕܪܹܐ ܒܝܲܕ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܚܘܵܪ̈ܕܸܩܢܹܐ ܕܥܲܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ܘܝܘܼܗܒ݂ܵܐ ܝܗܘܵܐ ܐܸܠܵܝܗ‌ܝ ܝܼܗܘܼܕܵܐ ܣܲܦܝܵܢܵܐ ܢܝܼܫܲܢܩܵܐ ܒܹܐܡܵܪܵܐ: ”ܠܗ̇ܘ ܕܢܵܫܩܹܢ، ܗ̇ܘ ܝܼܠܹܗ. ܕܵܒ݂ܩܝܼܬܘܿܢ ܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ܘܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ: ”ܫܠܵܡܵܐ ܐܸܠܘܼܟ݂ ܪܲܒܝܼ،“ ܘܢܫܝܼܩ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܒܘܼܬ ܐܵܗܵܐ ܐܬܹ‌ܐ ܠܘܼܟ݂ ܚܲܒ݂ܪܝܼ؟“ ܗ̇ܝܓܵܗ ܩܘܼܪܒܸܢܗܘܿܢ ܘܕܒ݂ܝܼܩ ܠܗܘܿܢ ܠܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ܚܲܕ ܡ̣ܢ ܐܵܢܝܼ ܕܝܼܗܘܵܘ ܥܲܡ ܝܼܫܘܿܥ ܕܪܹܐ ܠܹܗ ܐܝܼܕܹܗ ܠܣܲܝܦܹܗ ܘܓܪܝܼܫ ܠܹܗ ܘܡܚܹܐ ܠܹܗ ܠܪܹܓܵܐ ܕܓܘܼܪܵܐ ܕܟܵܗ̈ܢܹܐ ܘܦܪܝܼܡܵܐ ܠܹܗ ܢܵܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܡܲܕܸܪ ܣܲܝܦܘܼܟ݂ ܠܕܘܼܟܹܗ، ܣܵܒܵܒ ܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܡܲܦܠܸܚܝܼ ܣܲܝܦܵܐ، ܒܣܲܝܦܵܐ ܒܸܬ ܡܵܝܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","”ܒܸܚܫܵܒ݂ܵܐ ܝܘܸܬ ܠܹܐ ܡܵܨܹܝܢ ܛܵܠܒܹܢ ܡ̣ܢ ܒܵܒܝܼ ܕܗܲܪ ܐܵܕܝܼܵܐ ܫܲܕܸܪ ܐܸܠܝܼ ܙܵܘܕܵܐ ܡ̣ܢ ܬܪܸܥܣܲܪ ܠܸܓ݂ܝܘܿܢܹ̈ܐ ܕܡܲܠܲܐܟܹ̈ܐ؟ ");
INSERT INTO aii_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","”ܐܝܼܢܵܐ ܕܵܐܟ݂ܝܼ ܒܸܬ ܦܵܝܫܝܼ ܬܘܼܡܸܡܹܐ ܟܬܵܒܹ̈ܐ ܕܒܹܐܡܵܪܵܐ ܝܢܵܐ ܘܵܠܹܐ ܝܠܵܗ̇ ܕܗܵܕܟ݂ܵܐ ܗܵܘܹܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ܒܗ̇ܝ ܥܕܵܢܵܐ ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܠܟܸܢܫܵܐ: ”ܐܲܝܟ݂ ܕܥܲܠܔ ܓܹܢܵܒ݂ܵܐ ܦܠܝܼܛ ܠܵܘܟ݂ܘܿܢ ܒܣܲܝܦܹ̈ܐ ܘܒܚܘܼܛܪܹ̈ܐ ܠܸܕܒ݂ܵܩܝܼ؟ ܟܠܔ ܝܘܿܡ ܥܲܡܵܘܟ݂ܘܿܢ ܟܹܐ ܝܵܬܒܹܢ ܗܘܵܐ ܓܵܘ ܗܲܝܟܠܵܐ ܘܡܲܠܦܸܢ ܗܘܵܐ ܘܠܵܐ ܩܵܡ ܕܵܒ݂ܩܝܼܬܘܿܢ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","”ܐܝܼܢܵܐ ܐܵܗܵܐ ܟܠܵܗ̇ ܗܘܹܐ ܠܵܗ̇ ܕܦܵܝܫܝܼ ܬܘܼܡܸܡܹܐ ܟܬܵܒܹ̈ܐ ܕܢܒ݂ܝܼܹ̈ܐ.“ ܗ̇ܝܓܵܗ ܬܲܠܡܝܼ̈ܕܹܐ ܟܠܵܝܗ‌ܝ ܫܒ݂ܝܼܩ ܠܗܘܿܢ ܐܸܠܹܗ ܘܥܪܝܼܩ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ܘܐܵܢܝܼ ܕܕܒ݂ܝܼܩ ܠܗܘܿܢ ܠܝܼܫܘܿܥ ܠܘܼܒܸܠܔ ܠܗܘܿܢ ܐܸܠܹܗ ܠܟܸܣ ܩܲܝܵܦܵܐ، ܓܘܼܪܵܐ ܕܟܵܗ̈ܢܹܐ، ܐܲܝܟܵܐ ܕܣܵܦܪܹ̈ܐ ܘܚܘܵܪ̈ܕܸܩܢܹܐ ܓ̰ܡܝܼܥܹܐ ܝܗܘܵܘ. ");
INSERT INTO aii_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ܘܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܐܙܝܼܠܔ ܠܹܗ ܒܵܬܪܹܗ ܡ̣ܢ ܪܸܚܩܵܐ ܗܲܠܔ ܠܟܸܣ ܕܵܪܬܵ‌ܐ ܕܓܘܼܪܵܐ ܕܟܵܗ̈ܢܹܐ. ܘܥܒ݂ܝܼܪܹܗ ܓܵܘ ܕܵܪܬܵ‌ܐ ܘܝܬܝܼܒ݂ ܠܹܗ ܥܲܡ ܦܲܠܵܚܹ̈ܐ ܕܚܵܙܹܐ ܗܘܵܐ ܡܘܼܕܝܼ ܒܸܬ ܗܵܘܹܐ ܒܚܲܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܚܘܵܪ̈ܕܸܩܢܹܐ ܘܟܠܹܗ ܟܢܘܼܫܝܵܐ ܛܵܥܝܼ ܗܘܵܘ ܣܵܗܕܘܼܬܵ‌ܐ ܕܕܘܼܓܠܵܐ ܥܲܠܔ ܝܼܫܘܿܥ ܕܩܵܛܠܝܼ ܗܘܵܘ ܠܹܗ، ");
INSERT INTO aii_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ܘܠܵܐ ܡܘܼܫ݇ܟ̰ܸܚ ܠܗܘܿܢ. ܐܬܹ‌ܐ ܠܗܘܿܢ ܪܵܒܵܐ ܣܵܗܕܹ̈ܐ ܕܲܓܵܠܹ̈ܐ، ܐܝܼܢܵܐ ܒܚܲܪܬܵ‌ܐ ܐܬܹ‌ܐ ܠܗܘܿܢ ܬܪܹܝ ܣܵܗܕܹ̈ܐ، ");
INSERT INTO aii_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ܘܐܡܝܼܪܗܘܿܢ: ”ܐܵܗܵܐ ܐܢܵܫܵܐ ܐܡܝܼܪܹܗ: ’ܡܵܨܹܝܢ ܣܵܬܪܹܢ ܠܗܲܝܟܠܵܐ ܕܐܲܠܵܗܵܐ، ܘܒܬܠܵܬܵ‌ܐ ܝܵܘܡܵܢܹ̈ܐ ܒܵܢܹܢܹܗ.‘“ ");
INSERT INTO aii_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ܘܩܝܼܡ ܠܹܗ ܓܘܼܪܵܐ ܕܟܵܗ̈ܢܹܐ ܘܒܘܼܩܸܪܹܗ ܡ̣ܢ ܝܼܫܘܿܥ: ”ܩܵܡܘܿܕܝܼ ܠܹܐ ܝܘܸܬ ܓ̰ܲܘܘܼܒܹܐ ܡܸܢܕܝܼ ܥܲܠܔ ܐܲܢܹܐ ܕܒܸܣܗܵܕܵܐ ܝܢܵܐ ܥܲܠܘܼܟ݂؟“ ");
INSERT INTO aii_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܫܬܝܼܩܵܐ ܝܗܘܵܐ. ܘܗܘܼܡܙܸܡ ܠܹܗ ܓܘܼܪܵܐ ܕܟܵܗ̈ܢܹܐ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܡܲܡܘܼܝܘܼܟ݂ ܝܼܘܸܢ ܒܐܲܠܵܗܵܐ ܚܵܝܵܐ ܕܐܵܡܪܹܬ ܠܲܢ، ܕܐܸܢ ܐܲܢ݇ܬ ܝܼܘܸܬ ܡܫܝܼܚܵܐ، ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܐܲܢ݇ܬ ܐܡܝܼܪܘܼܟ݂. ܐܝܼܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܡ̣ܢ ܐܵܕܝܼܵܐ ܒܸܬ ܚܵܙܹܝܬܘܿܢ ܠܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܝܬܝܼܒ݂ܵܐ ܡ̣ܢ ܝܲܡܝܼܢܵܐ ܕܚܲܝܠܵܐ ܘܒܹܐܬܵܝܵܐ ܥܲܠܔ ܥܢܵܢܵܐ ܕܫܡܲܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ܗ̇ܝܓܵܗ ܓܘܼܪܵܐ ܕܟܵܗ̈ܢܹܐ ܟ̰ܘܼܢܟ̰ܸܪܹܗ ܓ̰ܘܼܠܘܼ̈ܗ‌ܝ ܘܐܡܝܼܪܹܗ: ”ܓܕܝܼܦ ܠܹܗ! ܐܚܹܪܢܵܐ ܠܹܐ ܝܘܲܚ ܣܢܝܼܩܹܐ ܠܣܵܗܕܹ̈ܐ، ܐܵܕܝܼܵܐ ܫܡܝܼܥ ܠܵܘܟ݂ܘܿܢ ܓܘܼܕܵܦܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","”ܡܘܼܕܝܼ ܒܸܚܫܵܒ݂ܵܐ ܝܬܘܿܢ؟“ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܘܐܡܝܼܪܗܘܿܢ: ”ܚܲܝܵܒ݂ܵܐ ܝܠܹܗ ܠܡܵܘܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ܗ̇ܝܓܵܗ ܪܝܼܩ ܠܗܘܿܢ ܥܲܠܔ ܦܵܬܹܗ، ܘܩܲܪܦܸܚܝܼ ܗܘܵܘ ܠܹܗ، ܘܐܚܹܪ̈ܢܹܐ ܡܵܚܝܼ ܗܘܵܘ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ܘܐܵܡܪܝܼ ܗܘܵܘ: ”ܢܲܒܝܼ ܐܸܠܲܢ، ܡܫܝܼܚܵܐ، ܡܵܢܝܼ ܩܵܡ ܡܵܚܹܐ ܠܘܼܟ݂؟“ ");
INSERT INTO aii_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ܐܝܼܢܵܐ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܝܬܝܼܒ݂ܵܐ ܝܗܘܵܐ ܓܵܘ ܕܵܪܬܵ‌ܐ، ܘܐܬܹ‌ܐ ܠܵܗ̇ ܠܟܸܣܠܹܗ ܚܕܵܐ ܚܸܕܲܡܬܵ‌ܐ ܘܐܡܝܼܪܵܗ̇ ܐܸܠܹܗ: ”ܐܘܼܦ ܐܲܢ݇ܬ ܥܲܡ ܝܼܫܘܿܥ ܢܵܨܪܵܝܵܐ ܝܘܸܬ ܗܘܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ܐܝܼܢܵܐ ܗ̇ܘ ܣܪܝܼܒ݂ ܠܹܗ ܩܲܕܡ ܟܠܵܝܗ‌ܝ ܘܐܡܝܼܪܹܗ: ”ܠܹܐ ܝܘܸܢ ܒܝܼܕܵܥܵܐ ܡܘܼܕܝܼ ܒܹܐܡܵܪܵܐ ܝܘܲܬ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ܘܦܠܝܼܛ ܠܹܗ ܒܬܲܪܥܵܐ، ܘܚܙܹܐ ܠܵܗ̇ ܐܸܠܹܗ ܚܕܵܐ ܐܚܹܪܬܵ‌ܐ ܘܐܡܝܼܪܵܗ̇: ”ܐܘܼܦ ܐܵܗܵܐ ܥܲܡ ܝܼܫܘܿܥ ܢܵܨܪܵܝܵܐ ܝܗܘܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ܡܸܢܕܪܸܫ ܣܪܝܼܒ݂ ܠܹܗ ܒܡܵܘܡܝܼܬܵ‌ܐ ܒܹܐܡܵܪܵܐ: ”ܠܹܐ ܝܵܕܥܹܢ ܠܐܵܗܵܐ ܐܢܵܫܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ܘܡ̣ܢ ܒܵܬܪ ܚܲܕ ܡܸܬܚܵܐ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܐܵܢܝܼ ܕܟܸܠܝܹܐ ܝܗܘܵܘ ܬܵܡܵܐ، ܘܐܡܝܼܪܗܘܿܢ ܠܫܸܡܥܘܿܢ ܟܹܐܦܵܐ: ”ܫܲܪܝܼܪܵܐܝܼܬ ܐܘܼܦ ܐܲܢ݇ܬ ܡܸܢܵܝܗ‌ܝ ܝܘܸܬ، ܣܵܒܵܒ ܗܲܡܙܲܡܬܘܼܟ݂ ܡܲܕܘܼܥܹܐ ܝܠܵܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ܗ̇ܝܓܵܗ ܫܘܼܪܹܐ ܠܹܗ ܠܡܲܚܪܘܼܡܹܐ ܘܠܸܡܝܵܝܵܐ: ”ܠܹܐ ܝܵܕܥܹܢ ܠܐܵܗܵܐ ܐܢܵܫܵܐ.“ ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܩܪܹܐ ܠܹܗ ܩܵܪܘܿܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ܘܕܟ݂ܝܼܪܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܗܹܡܸܙܡܵܢ ܕܝܼܫܘܿܥ ܕܐܡܝܼܪܵܐ ܝܗܘܵܐ ܐܸܠܹܗ: ”ܡ̣ܢ ܩܲܕܡ ܕܩܵܪܹܐ ܩܵܪܘܿܝܵܐ ܒܸܬ ܣܵܪܒܹܬ ܠܝܼ ܬܠܵܬ ܓܵܗܹ̈ܐ.“ ܦܠܝܼܛ ܠܹܗ ܠܒܲܕܲܪ ܘܒܟܹܐ ܠܹܗ ܒܡܲܪܝܼܪܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ܟܲܕ ܗܘܹܐ ܠܹܗ ܨܲܦܪܵܐ، ܣܘܼܙܓܸܪܗܘܿܢ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܚܘܵܪ̈ܕܸܩܢܹܐ ܕܥܲܡܵܐ ܕܩܵܛܠܝܼ ܠܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ܘܐܣܝܼܪܗܘܿܢ ܐܸܠܹܗ ܘܠܘܼܒܸܠܔ ܠܗܘܿܢ ܘܣܘܼܦܹܐ ܠܗܘܿܢ ܐܸܠܹܗ ܠܦܝܼܠܵܛܘܿܣ ܫܲܠܝܼܛܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ܐܝܼܢܵܐ ܟܲܕ ܝܼܗܘܼܕܵܐ ܣܲܦܝܵܢܵܐ ܚܙܹܐ ܠܹܗ ܕܦܝܼܫ ܠܹܗ ܕܝܼܢܵܐ ܝܼܫܘܿܥ، ܦܫܝܼܡ ܠܹܗ، ܐܙܝܼܠܔ ܠܹܗ ܘܡܘܼܕܸܪܹܗ ܠܐܵܢܝܼ ܬܠܵܬ‌ܝܼ ܙܘܼܙܹ̈ܐ ܕܣܹܐܡܵܐ ܠܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܠܚܘܵܪ̈ܕܸܩܢܹܐ، ");
INSERT INTO aii_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ܘܐܡܝܼܪܹܗ: ”ܚܛܹܐ ܠܝܼ ܕܣܘܼܦܹܐ ܠܝܼ ܕܸܡܵܐ ܙܲܟܵܝܵܐ.“ ܐܝܼܢܵܐ ܐܵܢܝܼ ܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܠܲܝܬ ܠܲܢ ܫܘܼܠܵܐ ܡܸܢܘܼܟ݂، ܐܲܢ݇ܬ ܟܹܐ ܝܵܕܥܹܬ ܒܓܵܢܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ܘܪܘܼܦܹܐ ܠܹܗ ܠܙܘܼܙܹ̈ܐ ܕܣܹܐܡܵܐ ܓܵܘ ܗܲܝܟܠܵܐ، ܦܠܝܼܛ ܠܹܗ ܘܐܙܝܼܠܔ ܠܹܗ ܚܢܝܼܩܵܐ ܠܹܗ ܓܵܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ܐܝܼܢܵܐ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܫܩܝܼܠܔ ܠܗܘܿܢ ܠܙܘܼܙܹ̈ܐ ܕܣܹܐܡܵܐ ܘܐܡܝܼܪܗܘܿܢ: ”ܠܹܐ ܝܠܵܗ̇ ܚܫܝܼܚܬܵ‌ܐ ܕܕܵܪܲܚ ܠܗܘܿܢ ܓܵܘ ܒܹܝܬ ܓܲܙܵܐ ܣܵܒܵܒ ܛܝܼܡܵܐ ܕܕܸܡܵܐ ܝܢܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ܘܣܘܼܙܓܸܪܗܘܿܢ ܘܙܒ݂ܝܼܢܗܘܿܢ ܒܝܼܵܝܗ‌ܝ ܚܲܩܠܵܐ ܕܦܲܚܵܪܵܐ ܩܵܐ ܒܹܝܬ ܩܒ݂ܘܼܪܹ̈ܐ ܕܢܘܼܟ݂ܪ̈ܵܝܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ܒܘܼܬ ܐܵܗܵܐ ܦܝܼܫ ܠܵܗ̇ ܩܪܝܼܬܵ‌ܐ ܗ̇ܝ ܚܲܩܠܵܐ، ”ܚܲܩܠܵܐ ܕܕܸܡܵܐ“ ܗܲܠܔ ܐܵܗܵܐ ܝܵܘܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ܗ̇ܝܓܵܗ ܦܝܼܫ ܠܹܗ ܬܘܼܡܸܡܵܐ ܡܸܢܕܝܼ ܕܐܡܝܼܪܵܐ ܝܗܘܵܐ ܒܝܲܕ ܐܹܪܲܡܝܵܐ ܢܒ݂ܝܼܵܐ ܕܐܡܝܼܪܹܗ: ܫܩܝܼܠܔ ܠܗܘܿܢ ܬܠܵܬ‌ܝܼ ܙܘܼܙܹ̈ܐ ܕܣܹܐܡܵܐ، ܛܝܼܡܵܐ ܕܡܘܼܬܒܹܐ ܝܗܘܵܘ ܥܲܠܘܼܗ‌ܝ ܒܢܲܝ̈ ܐܝܼܣܪܵܐܹܝܠܔ، ");
INSERT INTO aii_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ܘܝܘܼܗܒ݂ܵܝ ܠܗܘܿܢ ܒܚܲܩܠܵܐ ܕܦܲܚܵܪܵܐ، ܐܲܝܟ݂ ܕܦܩܝܼܕ ܠܹܗ ܐܸܠܝܼ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ܟܠܹܐ ܠܹܗ ܝܼܫܘܿܥ ܩܲܕܡ ܦܝܼܠܵܛܘܿܣ ܫܲܠܝܼܛܵܐ، ܘܒܘܼܩܸܪܹܗ ܡܸܢܹܗ ܫܲܠܝܼܛܵܐ ܘܐܡܝܼܪܹܗ: ”ܐܲܢ݇ܬ ܝܼܘܸܬ ܡܲܠܟܵܐ ܕܝܗܘܼܕܵܝܹ̈ܐ؟“ ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܐܲܢ݇ܬ ܐܡܝܼܪܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ܘܐܝܼܡܲܢ ܕܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܚܘܵܪ̈ܕܸܩܢܹܐ ܗܲܡܙܘܼܡܹܐ ܝܗܘܵܘ ܕܲܠܩܘܼܒ݂ܠܹܗ، ܝܼܫܘܿܥ ܫܬܝܼܩܵܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ܗ̇ܝܓܵܗ ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܦܝܼܠܵܛܘܿܣ ”ܒܸܫܡܵܥܵܐ ܝܘܸܬ ܕܵܐܟ݂ܝܼ ܣܵܗܕܘܼܬܵ‌ܐ ܒܝܼܵܗܒ݂ܵܐ ܝܢܵܐ ܥܲܠܘܼܟ݂؟“ ");
INSERT INTO aii_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ܘܠܵܐ ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܐܘܼܦ ܚܕܵܐ ܗܹܡܸܙܡܵܢ. ܥܘܼܓ̰ܸܒ ܠܹܗ ܪܵܒܵܐ ܫܲܠܝܼܛܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ܒܟܠܔ ܥܹܐܕܵܐ ܕܦܸܨܚܵܐ ܐܝܼܬ ܗܘܵܐ ܥܵܕܲܬ ܕܫܵܪܹܐ ܗܘܵܐ ܫܲܠܝܼܛܵܐ ܠܚܲܕ ܐܲܣܝܼܪܵܐ ܩܵܐ ܟܸܢܫܵܐ، ܗ̇ܘ ܕܐܵܢܝܼ ܒܵܥܝܼ ܗܘܵܘ. ");
INSERT INTO aii_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ܘܐܝܼܬ ܗܘܵܘ ܠܗܘܿܢ ܚܲܕ ܐܲܣܝܼܪܵܐ ܝܕܝܼܥܵܐ ܫܸܡܹܗ ܒܲܪ ܐܲܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ܟܲܕ ܓ̰ܡܝܼܥܹܐ ܝܗܘܵܘ، ܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ ܦܝܼܠܵܛܘܿܣ: ”ܡܵܢܝܼ ܒܵܥܹܝܬܘܿܢ ܕܫܵܪܹܝܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܒܲܪ ܐܲܒܵܐ، ܝܲܢ ܝܼܫܘܿܥ ܕܦܝܵܫܵܐ ܝܠܹܗ ܩܸܪܝܵܐ ܡܫܝܼܚܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ܣܵܒܵܒ ܟܹܐ ܝܵܕܹܥ ܗܘܵܐ ܕܡ̣ܢ ܒܲܚܸܠܵܢܘܼܬܵ‌ܐ ܣܘܼܦܝܹܐ ܝܗܘܵܘ ܠܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ܘܟܲܕ ܝܬܝܼܒ݂ܵܐ ܝܗܘܵܐ ܦܝܼܠܵܛܘܿܣ ܥܲܠܔ ܟܘܼܪܣܝܵܐ ܕܕܝܼܘܵܢ، ܫܘܼܕܸܪܵܗ̇ ܒܲܟ݂ܬܹܗ ܚܲܒܪܵܐ ܐܸܠܹܗ ܒܹܐܡܵܪܵܐ: ”ܠܵܐ ܗܵܘܹܐ ܠܘܼܟ݂ ܫܘܼܠܵܐ ܒܗ̇ܘ ܙܲܕܝܼܩܵܐ، ܣܵܒܵܒ ܐܸܕܝܘܿܡ ܓܵܘ ܚܸܠܡܝܼ ܪܵܒܵܐ ܓ̰ܘܼܢܓ̰ܸܪܝܼ ܒܘܼܬ ܕܝܼܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ܐܝܼܢܵܐ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܚܘܵܪ̈ܕܸܩܢܹܐ ܡܘܼܠܸܦ ܠܗܘܿܢ ܠܟܸܢܫܵܐ ܕܛܵܠܒܝܼ ܗܘܵܘ ܠܒܲܪ ܐܲܒܵܐ ܘܩܵܛܠܝܼ ܗܘܵܘ ܠܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ܒܘܼܩܸܪܹܗ ܫܲܠܝܼܛܵܐ ܡܸܢܵܝܗ‌ܝ: ”ܠܐܲܝܢܝܼ ܡ̣ܢ ܐܲܢܹܐ ܬܪܹܝ ܒܵܥܹܝܬܘܿܢ ܕܫܵܪܹܝܢ ܐܸܠܵܘܟ݂ܘܿܢ؟“ ܘܐܵܢܝܼ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ: ”ܠܒܲܪ ܐܲܒܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ܘܒܘܼܩܸܪܹܗ ܦܝܼܠܵܛܘܿܣ: ”ܡܘܼܕܝܼ ܥܵܒ݂ܕܹܢ ܒܝܼܫܘܿܥ ܕܦܝܵܫܵܐ ܝܠܹܗ ܩܸܪܝܵܐ ܡܫܝܼܚܵܐ؟“ ܘܐܵܢܝܼ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ: ”ܦܵܐܹܫ ܡܸܚܝܵܐ ܠܙܩܝܼܦܵܐ!“ ");
INSERT INTO aii_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ ܦܝܼܠܵܛܘܿܣ: ”ܡܘܼܕܝܼ ܒܝܼܫܬܵ‌ܐ ܥܒ݂ܝܼܕܵܐ ܝܠܹܗ؟“ ܐܝܼܢܵܐ ܐܵܢܝܼ ܒܘܼܫ ܙܵܘܕܵܐ ܡܘܼܩܘܸܚ ܠܗܘܿܢ ܒܹܐܡܵܪܵܐ: ”ܦܵܐܹܫ ܡܸܚܝܵܐ ܠܙܩܝܼܦܵܐ!“ ");
INSERT INTO aii_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ܟܲܕ ܚܙܹܐ ܠܹܗ ܦܝܼܠܵܛܘܿܣ ܕܠܹܐ ܝܗܘܵܐ ܡܲܢܬܘܼܝܹܐ، ܐܸܠܵܐ ܫܓ݂ܘܼܫܝܵܐ ܒܘܼܫ ܒܸܙܝܵܕܵܐ ܝܗܘܵܐ، ܫܩܝܼܠܔ ܠܹܗ ܡ̈ܝܼܵܐ ܘܚܘܼܠܸܠܔ ܠܹܗ ܐܝܼܕܵܬܘܼ̈ܗ‌ܝ ܩܲܕܡ ܥܲܝ̈ܢܹܐ ܕܟܸܢܫܵܐ ܘܐܡܝܼܪܹܗ: ”ܦܪܝܼܩ ܠܝܼ ܡ̣ܢ ܕܸܡܵܐ ܕܐܵܗܵܐ ܙܲܕܝܼܩܵܐ، ܐܲܚܬܘܿܢ ܚܙܹܝܡܘܼܢ ܡܘܼܕܝܼ ܒܸܬ ܥܵܒ݂ܕܝܼܬܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ܓ̰ܘܼܘܸܒ ܠܹܗ ܟܠܹܗ ܥܲܡܵܐ ܘܐܡܝܼܪܹܗ: ”ܕܸܡܹܗ ܥܲܠܲܢ ܘܥܲܠܔ ܒܢܘܿܢܲܢ̈.“ ");
INSERT INTO aii_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ܗ̇ܝܓܵܗ ܦܝܼܠܵܛܘܿܣ ܫܪܹܐ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܠܒܲܪ ܐܲܒܵܐ، ܘܡܘܼܡܚܹܐ ܠܹܗ ܠܝܼܫܘܿܥ ܒܫܵܘܛܹ̈ܐ، ܘܣܘܼܦܹܐ ܠܹܗ ܕܦܵܐܹܫ ܙܩܝܼܦܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ܗ̇ܝܓܵܗ ܢܵܛܘܿܪܹ̈ܐ ܕܫܲܠܝܼܛܵܐ ܠܘܼܒܸܠܔ ܠܗܘܿܢ ܠܝܼܫܘܿܥ ܠܒܹܝܬ ܕܝܼܢܵܐ ܘܓ̰ܘܼܡܸܥ ܠܗܘܿܢ ܥܲܠܘܼܗ‌ܝ ܟܠܵܗ̇ ܣܝܼܥܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ܘܫܘܼܠܸܚ ܠܗܘܿܢ ܓ̰ܘܼܠܘܼ̈ܗ‌ܝ، ܘܡܘܼܠܒܸܫ ܠܗܘܿܢ ܐܸܠܹܗ ܓ̰ܘܼܒܵܐ ܣܡܘܿܩܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ܘܓܕܝܼܠܔ ܠܗܘܿܢ ܟܠܝܼܠܵܐ ܕܟܸܬܘܹ̈ܐ ܘܡܘܼܬܸܒ݂ ܠܗܘܿܢ ܒܪܹܝܫܹܗ، ܘܙܹܠܵܐ ܒܐܝܼܕܹܗ ܕܝܲܡܝܼܢܵܐ، ܘܒܪܝܼܟ ܠܗܘܿܢ ܩܲܕܡܘܼܗ‌ܝ ܥܲܠܔ ܒܸܪ̈ܟܵܟܵܝܗ‌ܝ، ܘܡܘܼܣܚܸܪܗܘܿܢ ܒܝܼܹܗ ܒܹܐܡܵܪܵܐ: ”ܫܠܵܡܵܐ ܐܸܠܘܼܟ݂ ܝܵܐ ܡܲܠܟܵܐ ܕܝܗܘܼܕܵܝܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ܪܝܼܩ ܠܗܘܿܢ ܓܵܘ ܦܵܬܹܗ، ܘܫܩܝܼܠܔ ܠܗܘܿܢ ܙܹܠܵܐ ܘܡܚܹܐ ܠܗܘܿܢ ܒܝܼܹܗ ܥܲܠܔ ܪܹܝܫܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ܘܡ̣ܢ ܒܵܬܪ ܕܡܘܼܣܚܸܪܗܘܿܢ ܒܝܼܹܗ، ܫܘܼܠܸܚ ܠܗܘܿܢ ܡܸܢܹܗ ܓ̰ܘܼܒܵܐ ܘܡܘܼܠܒܸܫ ܠܗܘܿܢ ܐܸܠܹܗ ܓ̰ܘܼܠܘܼ̈ܗ‌ܝ، ܘܠܘܼܒܸܠܔ ܠܗܘܿܢ ܐܸܠܹܗ ܕܦܵܐܹܫ ܙܩܝܼܦܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ܟܲܕ ܒܸܦܠܵܛܵܐ ܝܗܘܵܘ، ܬܦܝܼܩ ܠܗܘܿܢ ܒܚܲܕ ܐܢܵܫܵܐ ܩܸܘܪܝܼܢܵܝܵܐ ܫܸܡܹܗ ܫܸܡܥܘܿܢ. ܥܒ݂ܝܼܕ ܠܗܘܿܢ ܫܘܼܚܪܵܐ ܐܸܠܹܗ ܕܛܵܥܹܢ ܗܘܵܐ ܠܙܩܝܼܦܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܠܕܘܼܟܵܐ ܕܟܹܐ ܦܵܝܫܵܐ ܩܪܝܼܬܵ‌ܐ ܓܵܓ݂ܘܿܠܬܵ‌ܐ، ܕܦܘܼܫܵܩܘܼܗ̇ ܝܼܠܹܗ ܩܲܪܩܲܦܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ܝܘܼܗܒܹܠܔ ܠܗܘܿܢ ܐܸܠܹܗ ܚܲܡܪܵܐ ܠܸܫܬܵܝܵܐ، ܚܒ݂ܝܼܛܵܐ ܒܡܪܲܪܬܵ‌ܐ، ܐܝܼܢܵܐ ܐܝܼܡܲܢ ܕܛܥܝܼܡ ܠܹܗ ܠܵܐ ܒܥܹܐ ܠܹܗ ܠܸܫܬܵܝܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ܘܐܝܼܡܲܢ ܕܙܩܝܼܦ ܠܗܘܿܢ، ܦܘܼܠܸܥ ܠܗܘܿܢ ܓ̰ܘܼܠܘܼ̈ܗ‌ܝ ܒܕܪܵܝܬܵ‌ܐ ܕܦܸܫܟܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ܘܝܬܝܼܒ݂ ܠܗܘܿܢ ܒܸܢܛܵܪܵܐ ܐܸܠܹܗ ܬܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ܡܘܼܬܸܒ݂ ܠܗܘܿܢ ܥܸܠܸܠܔ ܡ̣ܢ ܪܹܝܫܹܗ ܟܬܝܼܒ݂ܬܵ‌ܐ ܡܲܚܙܘܼܝܹܐ ܥܸܠܬܵ‌ܐ ܕܡܵܘܬܹܗ: ”ܐܵܗܵܐ ܝܠܹܗ ܝܼܫܘܿܥ، ܡܲܠܟܵܐ ܕܝܗܘܼܕܵܝܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ܘܦܝܼܫ ܠܗܘܿܢ ܙܩܝܼܦܹܐ ܥܲܡܹܗ ܬܪܹܝ ܓܲܝܵܣܹ̈ܐ، ܚܲܕ ܡ̣ܢ ܝܲܡܝܼܢܹܗ ܘܚܲܕ ܡ̣ܢ ܣܸܡܵܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ܘܐܵܢܝܼ ܕܒܸܥܒ݂ܵܪܵܐ ܝܗܘܵܘ ܡ̣ܢ ܠܟܸܣܠܹܗ ܓܵܕܦܝܼ ܗܘܵܘ ܥܲܠܘܼܗ‌ܝ، ܘܫܵܥܫܝܼ ܗܘܵܘ ܪܹ̈ܝܫܵܝܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ܘܐܵܡܪܝܼ ܗܘܵܘ: ”ܝܵܐ ܣܵܬܪܵܢܵܐ ܕܗܲܝܟܠܵܐ ܘܒܵܢܝܵܢܹܗ ܒܬܠܵܬܵ‌ܐ ܝܵܘܡܵܢܹ̈ܐ، ܦܲܪܸܩ ܓܵܢܘܼܟ݂ ܐܸܢ ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ ܝܘܸܬ، ܨܠܝܼ ܡ̣ܢ ܙܩܝܼܦܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ܗܵܕܟ݂ܵܐ ܐܘܼܦ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܥܲܡ ܣܵܦܪܹ̈ܐ ܘܚܘܵܪ̈ܕܸܩܢܹܐ ܘܦܪ̈ܝܼܫܹܐ ܡܲܣܚܸܪܝܼ ܗܘܵܘ ܘܐܵܡܪܝܼ ܗܘܵܘ: ");
INSERT INTO aii_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","”ܠܐܚܹܪ̈ܢܹܐ ܦܘܼܪܸܩ ܠܹܗ، ܐܝܼܢܵܐ ܓܵܢܹܗ ܠܹܐ ܡܵܨܹܐ ܦܲܪܸܩ ܠܵܗ̇. ܐܸܢ ܡܲܠܟܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ ܝܼܠܹܗ، ܨܵܠܹܐ ܡ̣ܢ ܙܩܝܼܦܵܐ ܕܚܵܙܲܚ ܘܗܲܡܸܢܲܚ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","”ܕܪܹܐ ܠܹܗ ܗܹܒ݂ܝܼܹܗ ܠܐܲܠܵܗܵܐ، ܫܒ݂ܘܿܩ ܐܲܠܵܗܵܐ ܦܲܪܸܩ ܠܹܗ ܐܵܕܝܼܵܐ ܐܸܢ ܟܹܐ ܡܲܚܸܒ ܠܹܗ، ܣܵܒܵܒ ܐܡܝܼܪܹܗ: ’ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ ܝܘܸܢ.‘“ ");
INSERT INTO aii_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ܗܵܕܟ݂ܵܐ ܐܘܼܦ ܐܵܢܝܼ ܓܲܝܵܣܹ̈ܐ ܕܦܝܼܫ ܠܗܘܿܢ ܙܩܝܼܦܹܐ ܥܲܡܹܗ ܡܲܣܚܸܪܝܼ ܗܘܵܘ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ܘܡ̣ܢ ܣܵܥܲܬ ܕܬܪܸܥܣܲܪ ܗܘܹܐ ܠܹܗ ܚܸܫܟܵܐ ܥܲܠܔ ܟܠܵܗ̇ ܐܲܪܥܵܐ ܗܲܠܔ ܣܵܥܲܬ ܕܬܠܵܬ. ");
INSERT INTO aii_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ܘܐܲܝܟ݂ ܣܵܥܲܬ ܕܬܠܵܬ ܡܘܼܩܘܸܚ ܠܹܗ ܝܼܫܘܿܥ ܒܩܵܠܵܐ ܪܵܡܵܐ ܘܐܡܝܼܪܹܗ: ”ܐܹܝܠܝ، ܐܹܝܠܝ، ܠܡܵܢܵܐ ܫܒܲܩܬܵܢܝ؟“ ܝܲܥܢܹܐ، ”ܐܲܠܵܗ‌ܝܼ، ܐܲܠܵܗ‌ܝܼ، ܩܵܡܘܿܕܝܼ ܫܒ݂ܝܼܩܸܢܘܼܟ݂؟“ ");
INSERT INTO aii_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ܚܲܕܟܡܵܐ ܡ̣ܢ ܐܢܵܫܹ̈ܐ ܕܟܸܠܝܹܐ ܝܗܘܵܘ ܬܵܡܵܐ، ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܗܘܿܢ، ܐܡܝܼܪܗܘܿܢ: ”ܐܵܗܵܐ ܠܐܹܠܝܼܵܐ ܒܸܩܪܵܝܵܐ ܝܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ܒܓ̰ܲܠܕܘܼܬܵ‌ܐ ܪܚܝܼܛ ܠܹܗ ܚܲܕ ܡܸܢܵܝܗ‌ܝ ܘܫܩܝܼܠܔ ܠܹܗ ܐܸܣܦܘܼܓܵܐ ܘܡܸܠܝܵܐ ܠܹܗ ܚܲܠܵܐ، ܡܘܼܬܒ݂ܵܐ ܠܹܗ ܥܲܠܔ ܩܲܝܣܵܐ ܘܝܘܼܗܒ݂ܵܐ ܠܹܗ ܐܸܠܹܗ ܠܸܫܬܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ܘܐܚܹܪ̈ܢܹܐ ܐܵܡܪܝܼ ܗܘܵܘ: ”ܫܒ݂ܘܿܩܘܼܢ ܚܵܙܲܚ ܐܸܢ ܒܸܬ ܐܵܬܹ‌ܐ ܐܹܠܝܼܵܐ ܘܦܲܪܸܩ ܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ܝܼܫܘܿܥ ܡܸܢܕܪܸܫ ܡܘܼܩܘܸܚ ܠܹܗ ܒܩܵܠܵܐ ܪܵܡܵܐ ܘܣܘܼܦܝܵܐ ܠܹܗ ܓܵܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ܒܗ̇ܝ ܥܕܵܢܵܐ ܣܸܬܪܹ̈ܐ ܕܗܲܝܟܠܵܐ ܦܝܼܫ ܠܗܘܿܢ ܟ̰ܠܝܼܦܹܐ ܠܬܪܹܝ ܣܵܗܡܹ̈ܐ، ܡ̣ܢ ܥܸܠܸܠܔ ܗܲܠܔ ܠܬܸܚܬ، ܘܐܲܪܥܵܐ ܫܥܝܼܫ ܠܵܗ̇، ܘܟܹܐܦܹ̈ܐ ܦܝܼܫ ܠܗܘܿܢ ܟ̰ܠܝܼܦܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ܘܒܹܝܬ ܩܒ݂ܘܼܪܹ̈ܐ ܦܝܼܫ ܠܗܘܿܢ ܦܬܝܼܚܹܐ، ܘܦܲܓ݂ܪܹ̈ܐ ܕܪܵܒܵܐ ܩܲܕܝܼܫܹ̈ܐ ܕܡܝܼܬܹ‌ܐ ܝܗܘܵܘ ܩܝܼܡ ܠܗܘܿܢ، ");
INSERT INTO aii_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ܘܦܠܝܼܛ ܠܗܘܿܢ ܡ̣ܢ ܒܹܝܬ ܩܒ݂ܘܼܪܹ̈ܐ ܡ̣ܢ ܒܵܬܪ ܩܝܵܡܬܵ‌ܐ ܕܡܫܝܼܚܵܐ ܘܥܒ݂ܝܼܪܗܘܿܢ ܠܡܕܝܼܢ݇ܬܵ‌ܐ ܩܲܕܝܼܫܬܵ‌ܐ، ܘܦܝܼܫ ܠܗܘܿܢ ܚܸܙܝܹܐ ܒܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ܪܲܒ ܡܵܐܐ ܘܐܵܢܝܼ ܕܥܲܡܹܗ ܕܒܸܢܛܵܪܵܐ ܝܗܘܵܘ ܠܝܼܫܘܿܥ، ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܗܘܿܢ ܪܵܘܕܵܢܵܐ ܘܡܸܢܕܝܼܵܢܹ̈ܐ ܕܗܘܹܐ ܠܗܘܿܢ، ܙܕܝܼܥ ܠܗܘܿܢ ܪܵܒܵܐ ܘܐܡܝܼܪܗܘܿܢ: ”ܫܲܪܝܼܪܵܐܝܼܬ ܐܵܗܵܐ ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ ܝܗܘܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ܐܝܼܬ ܗܘܵܘ ܬܵܡܵܐ ܒܲܟ݂ܬܵܬܹ̈‌ܐ ܪܵܒܵܐ ܕܒܸܚܝܵܪܵܐ ܝܗܘܵܘ ܡ̣ܢ ܪܸܚܩܵܐ، ܐܵܢܝܼ ܕܐܬܝܼܹܐ ܝܗܘܵܘ ܒܵܬܪ ܝܼܫܘܿܥ ܡ̣ܢ ܓܠܝܼܠܵܐ ܕܥܵܒ݂ܕܝܼ ܗܘܵܘ ܠܹܗ ܚܸܠܡܲܬ. ");
INSERT INTO aii_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ܡܸܢܵܝܗ‌ܝ ܝܼܗܘܵܘ ܡܲܪܝܲܡ ܡܲܓ݂ܕܠܵܝܬܵ‌ܐ، ܘܡܲܪܝܲܡ ܝܸܡܵܐ ܕܝܲܥܩܘܿܒ݂ ܘܕܝܘܿܣܹܐ، ܘܝܸܡܵܐ ܕܒܢܘܿܢܹ̈ܐ ܕܙܲܒ݂ܕܲܝ. ");
INSERT INTO aii_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ܟܲܕ ܗܘܹܐ ܠܹܗ ܪܲܡܫܵܐ، ܐܬܹ‌ܐ ܠܹܗ ܚܲܕ ܐܢܵܫܵܐ ܥܲܬܝܼܪܵܐ ܡ̣ܢ ܪܵܡܬܵ‌ܐ ܫܸܡܹܗ ܝܵܘܣܸܦ، ܕܦܝܼܫܵܐ ܝܗܘܵܐ ܬܘܼܠܡܸܕܵܐ ܒܝܲܕ ܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ܐܵܗܵܐ ܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣ ܦܝܼܠܵܛܘܿܣ ܘܛܠܝܼܒ ܠܹܗ ܦܲܓ݂ܪܵܐ ܕܝܼܫܘܿܥ. ܘܦܝܼܠܵܛܘܿܣ ܦܩܝܼܕ ܠܹܗ ܕܦܵܐܹܫ ܝܘܼܗܒ݂ܵܐ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ܫܩܝܼܠܔ ܠܹܗ ܝܵܘܣܸܦ ܠܦܲܓ݂ܪܵܐ ܘܟܪܝܼܟ݂ ܠܹܗ ܒܩܸܛܥܵܐ ܕܟܸܬܲܢ ܕܸܟ݂ܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ܘܡܘܼܬܸܒ݂ ܠܹܗ ܓܵܘ ܒܹܝܬ ܩܒ݂ܘܼܪܵܐ ܚܵܕܬܵ‌ܐ ܕܓܵܢܹܗ، ܢܩܝܼܪܵܐ ܓܵܘ ܩܵܝܵܐ، ܘܡܘܼܚܕܸܪܹܗ ܟܹܐܦܵܐ ܓܘܼܪܵܐ ܥܲܠܔ ܬܲܪܥܵܐ ܕܒܹܝܬ ܩܒ݂ܘܼܪܵܐ ܘܐܙܝܼܠܔ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ܐܝܼܬ ܗܘܵܐ ܬܵܡܵܐ ܡܲܪܝܲܡ ܡܲܓ݂ܕܠܵܝܬܵ‌ܐ ܘܚܕܵܐ ܡܲܪܝܲܡ ܐܚܹܪܬܵ‌ܐ ܝܬܝܼܒܹܐ ܠܒܲܠܩܘܼܒ݂ܠܔ ܕܩܲܒ݂ܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ܘܒܩܲܝܕܵܡܬܵ‌ܐ، ܕܝܼܗܘܵܐ ܡ̣ܢ ܒܵܬܪ ܝܵܘܡܵܐ ܕܗܲܕܲܪܬܵ‌ܐ، ܓ̰ܡܝܼܥ ܠܗܘܿܢ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܦܪ̈ܝܼܫܹܐ ܠܟܸܣ ܦܝܼܠܵܛܘܿܣ، ");
INSERT INTO aii_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܡܵܪܲܢ، ܒܸܕܟ݂ܵܪܵܐ ܝܘܲܚ ܕܗ̇ܘ ܡܲܚܠܸܛܵܢܵܐ، ܟܲܕ ܚܵܝܵܐ ܝܗܘܵܐ، ܐܡܝܼܪܹܗ ܕܡ̣ܢ ܒܵܬܪ ܬܠܵܬܵ‌ܐ ܝܵܘܡܵܢܹ̈ܐ ܒܸܬ ܩܵܐܹܡ. ");
INSERT INTO aii_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","”ܒܘܼܬ ܐܵܗܵܐ، ܦܩܘܿܕ ܕܦܵܐܹܫ ܢܛܝܼܪܵܐ ܒܹܝܬ ܩܒ݂ܘܼܪܵܐ ܗܲܠܔ ܝܵܘܡܵܐ ܕܬܠܵܬܵ‌ܐ، ܕܠܵܐ ܐܵܬ‌ܝܼ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܓܵܢܒ݂ܝܼ ܠܹܗ ܒܠܲܝܠܹܐ، ܘܐܵܡܪܝܼ ܠܥܲܡܵܐ ܕܩܝܼܡ ܠܹܗ ܡ̣ܢ ܓܵܘ ܡܝܼ̈ܬܹ‌ܐ. ܘܐܵܗܵܐ ܚܸܠܛܵܐ ܐܚܵܪܵܝܵܐ ܒܸܬ ܗܵܘܹܐ ܒܘܼܫ ܚܸܪܒܵܐ ܡ̣ܢ ܗ̇ܘ ܩܲܕܡܵܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ܐܡܝܼܪܹܗ ܦܝܼܠܵܛܘܿܣ: ”ܫܩܘܿܠܘܼܢ ܢܵܛܘܿܪܹ̈ܐ، ܙܹܠ݇ܡܘܼܢ ܘܢܛܘܿܪܘܼܢ ܠܹܗ ܕܵܐܟ݂ܝܼ ܕܝܵܕܥܝܼܬܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ܘܐܵܢܝܼ ܐܙܝܼܠܔ ܠܗܘܿܢ ܘܢܛܝܼܪܗܘܿܢ ܠܩܲܒ݂ܪܵܐ، ܘܚܬܝܼܡ ܠܗܘܿܢ ܠܟܹܐܦܵܐ ܩܲܕܡ ܥܲܝ̈ܢܹܐ ܕܢܵܛܘܿܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ܒܦܪܵܩܬܵ‌ܐ ܕܫܲܒܬܵ‌ܐ ܘܒܙܪܵܩܵܐ ܕܚܲܕ݇ܒܫܵܒܵܐ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܡܲܪܝܲܡ ܡܲܓ݂ܕܠܵܝܬܵ‌ܐ ܘܡܲܪܝܲܡ ܐܚܹܪܬܵ‌ܐ ܕܚܵܙܝܼ ܠܩܲܒ݂ܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ܘܗܵܐ ܪܵܘܕܵܢܵܐ ܓܘܼܪܵܐ ܗܘܹܐ ܠܹܗ، ܣܵܒܵܒ ܡܲܠܲܐܟ݂ܵܐ ܕܡܵܪܝܵܐ ܨܠܹܐ ܠܹܗ ܡ̣ܢ ܫܡܲܝܵܐ ܘܡܘܼܚܕܸܪܹܗ ܠܟܹܐܦܵܐ ܡ̣ܢ ܬܲܪܥܵܐ ܘܝܬܝܼܒ݂ ܠܹܗ ܥܲܠܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ܦܵܬܹܗ ܐܲܝܟ݂ ܒܸܪܩܵܐ ܝܗܘܵܐ، ܘܠܒ݂ܝܼܫܬܹܗ ܚܘܵܪܬܵ‌ܐ ܐܲܝܟ݂ ܬܲܠܓܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ܪܓܝܼܕ ܠܗܘܿܢ ܢܵܛܘܿܪܹ̈ܐ ܡ̣ܢ ܙܕܘܼܥܬܵܝܗ‌ܝ ܡܸܢܹܗ، ܘܗܘܹܐ ܠܗܘܿܢ ܐܲܝܟ݂ ܡܝܼ̈ܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ܐܝܼܢܵܐ ܗܘܼܡܙܸܡ ܠܹܗ ܡܲܠܲܐܟ݂ܵܐ ܘܐܡܝܼܪܹܗ ܠܒܲܟ݂ܬܵܬܹ̈‌ܐ: ”ܐܲܚܬܘܿܢ ܠܵܐ ܙܵܕܥܝܼܬܘܿܢ، ܣܵܒܵܒ ܒܝܼܕܵܥܵܐ ܝܘܸܢ ܕܒܸܛܥܵܝܵܐ ܝܬܘܿܢ ܒܵܬܪ ܝܼܫܘܿܥ ܕܦܝܼܫ ܠܹܗ ܡܸܚܝܵܐ ܠܙܩܝܼܦܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","”ܠܹܐ ܝܠܹܗ ܠܲܐܟ݂ܵܐ، ܩܝܼܡ ܠܹܗ ܕܵܐܟ݂ܝܼ ܕܐܡܝܼܪܵܐ ܝܗܘܵܐ. ܬܹܝܡܘܼܢ ܘܚܙܹܝܡܘܼܢ ܠܕܘܼܟܵܐ ܕܓܵܘܘܼܗ̇ ܡܘܼܬܒ݂ܵܐ ܝܗܘܵܐ ܡܵܪܲܢ. ");
INSERT INTO aii_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","”ܙܹܠ݇ܡܘܼܢ ܒܓ̰ܲܠܕܘܼܬܵ‌ܐ ܘܐܡܘܿܪܘܼܢ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܕܩܝܼܡ ܠܹܗ ܡ̣ܢ ܓܵܘ ܡܝܼ̈ܬܹ‌ܐ، ܘܒܸܬ ܐܵܙܹܠܔ ܡ̣ܢ ܩܲܕܡ ܕܝܼܵܘܟ݂ܘܿܢ ܠܓܠܝܼܠܵܐ، ܬܵܡܵܐ ܒܸܬ ܚܵܙܹܝܬܘܿܢ ܠܹܗ. ܗܵܐ ܐܡܝܼܪܝܼ ܐܸܠܵܘܟ݂ܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ܘܕܝܼܪܗܘܿܢ ܐܵܢܝܼ ܒܲܟ݂ܬܵܬܹ̈‌ܐ ܒܡܲܠܝܲܙܬܵ‌ܐ ܡ̣ܢ ܩܲܒ݂ܪܵܐ، ܒܙܕܘܼܥܬܵ‌ܐ ܘܒܚܲܕܘܼܬܵ‌ܐ ܓܘܼܪܬܵ‌ܐ، ܘܪܚܝܼܛ ܠܗܘܿܢ ܘܡܘܼܕܸܥ ܠܗܘܿܢ ܠܬܲܠܡܝܼ̈ܕܹܐ. ");
INSERT INTO aii_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ܘܗܵܐ ܝܼܫܘܿܥ ܬܦܝܼܩ ܠܹܗ ܒܝܼܵܝܗ‌ܝ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܫܠܵܡܵܐ ܐܸܠܵܘܟ݂ܘܿܢ.“ ܘܐܵܢܝܼ ܐܬܹ‌ܐ ܠܗܘܿܢ ܘܕܒ݂ܝܼܩ ܠܗܘܿܢ ܐܲܩܠܵܬܘܼ̈ܗ‌ܝ ܘܣܓ݂ܝܼܕ ܠܗܘܿܢ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ܗ̇ܝܓܵܗ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܠܵܐ ܙܵܕܥܝܼܬܘܿܢ، ܙܹܠ݇ܡܘܼܢ ܘܐܡܘܿܪܘܼܢ ܠܐܲܚܘܿܢܘܵܬ‌ܝܼ̈ ܕܐܵܙܠ݇ܝܼ ܠܓܠܝܼܠܵܐ ܘܬܵܡܵܐ ܒܸܬ ܚܵܙܝܼ ܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ܘܟܲܕ ܐܵܢܝܼ ܒܹܐܙܵܠܵܐ ܝܗܘܵܘ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܐܢܵܫܹ̈ܐ ܡ̣ܢ ܐܵܢܝܼ ܢܵܛܘܿܪܹ̈ܐ ܠܡܕܝܼܢ݇ܬܵ‌ܐ ܘܡܘܼܚܒܸܪܗܘܿܢ ܠܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܟܠܔ ܡܸܢܕܝܼ ܕܗܘܹܐ ܠܹܗ، ");
INSERT INTO aii_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ܓ̰ܡܝܼܥ ܠܗܘܿܢ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܥܲܡ ܚܘܵܪ̈ܕܸܩܢܹܐ، ܘܣܘܼܙܓܸܪܗܘܿܢ، ܘܝܘܼܗܒܹܠܔ ܠܗܘܿܢ ܙܘܼܙܹ̈ܐ ܪܵܒܵܐ ܠܢܵܛܘܿܪܹ̈ܐ، ");
INSERT INTO aii_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܵܝܗ‌ܝ: ”ܐܡܘܿܪܘܼܢ: ’ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܐܬܹ‌ܐ ܠܗܘܿܢ ܒܠܲܝܠܹܐ ܘܓܢܝܼܒ݂ ܠܗܘܿܢ ܐܸܠܹܗ ܟܲܕ ܐܲܚܢܲܢ ܕܡܝܼܟܹܐ.‘ ");
INSERT INTO aii_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","”ܘܐܸܢ ܦܵܝܫܵܐ ܫܡܝܼܥܬܵ‌ܐ ܐܵܗܵܐ ܩܲܕܡ ܫܲܠܝܼܛܵܐ، ܐܲܚܢܲܢ ܒܸܬ ܡܲܫܠܲܚ ܠܹܗ، ܘܥܲܠܵܘܟ݂ܘܿܢ ܠܹܐ ܐܵܬܹ‌ܐ ܡܸܢܕܝܼ ܣܸܪܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ܐܵܢܝܼ ܫܩܝܼܠܔ ܠܗܘܿܢ ܙܘܼܙܹ̈ܐ ܘܥܒ݂ܝܼܕ ܠܗܘܿܢ ܕܵܐܟ݂ܝܼ ܕܦܝܼܫ ܠܗܘܿܢ ܡܘܼܠܦܹܐ. ܘܦܠܝܼܛ ܠܵܗ̇ ܐܵܗܵܐ ܗܹܡܸܙܡܵܢ ܓܵܘ ܝܗܘܼܕܵܝܹ̈ܐ ܗܲܠܔ ܐܵܗܵܐ ܝܵܘܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ܗ̇ܝܓܵܗ ܐܙܝܼܠܔ ܠܗܘܿܢ ܚܲܕܸܥܣܲܪ ܬܲܠܡܝܼ̈ܕܹܐ ܠܓܠܝܼܠܵܐ، ܠܛܘܼܪܵܐ ܐܲܝܟܵܐ ܕܐܡܝܼܪܵܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܕܐܵܙܠ݇ܝܼ. ");
INSERT INTO aii_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ܘܐܝܼܡܲܢ ܕܩܵܡ ܚܵܙܝܼ ܠܹܗ، ܣܓ݂ܝܼܕ ܠܗܘܿܢ ܐܸܠܹܗ. ܐܝܼܢܵܐ ܚܲܕܟܡܵܐ ܡܸܢܵܝܗ‌ܝ ܢܦܝܼܠܔ ܠܗܘܿܢ ܓܵܘ ܫܸܟܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ܐܬܹ‌ܐ ܠܹܗ ܝܼܫܘܿܥ ܘܗܘܼܡܙܸܡ ܠܹܗ ܥܲܡܵܝܗ‌ܝ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܦܝܼܫ ܠܹܗ ܝܘܼܗܒ݂ܵܐ ܐܸܠܝܼ ܟܠܔ ܫܘܼܠܛܵܢܵܐ ܒܫܡܲܝܵܐ ܘܒܐܲܪܥܵܐ. ܕܵܐܟ݂ܝܼ ܕܩܵܡ ܫܲܕܸܪܝܼ ܒܵܒܝܼ، ܗܵܕܟ݂ܵܐ ܐܘܼܦ ܐܵܢܵܐ ܫܲܕܘܼܪܵܘܟ݂ܘܿܢ ܝܼܘܸܢ. ");
INSERT INTO aii_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","”ܒܘܼܬ ܐܵܗܵܐ ܙܹܠ݇ܡܘܼܢ ܘܬܲܠܡܸܕܘܼܢ ܠܟܠܵܝܗ‌ܝ ܐܸܡܘܵܬܹ̈‌ܐ، ܘܡܲܥܡܸܕܘܼܢ ܠܗܘܿܢ ܒܫܸܡܵܐ ܕܒܵܒܵܐ ܘܒܪܘܿܢܵܐ ܘܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","”ܘܡܲܠܦܘܼܢ ܠܗܘܿܢ ܕܢܵܛܪܝܼ ܟܠܔ ܡܸܢܕܝܼ ܕܦܩܝܼܕ ܠܝܼ ܐܸܠܵܘܟ݂ܘܿܢ، ܘܗܵܐ ܐܵܢܵܐ ܥܲܡܵܘܟ݂ܘܿܢ ܝܼܘܸܢ ܟܠܵܝܗ‌ܝ ܝܵܘܡܵܢܹ̈ܐ ܗܲܠܔ ܫܘܼܠܵܡܵܐ ܕܙܲܒ݂ܢܵܐ.“ ܐܵܡܹܝܢ.");
INSERT INTO aii_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ܐܵܗܵܐ ܝܠܹܗ ܫܘܼܪܵܝܵܐ ܕܐܹܘܲܢܓܲܠܝܼܘܿܢ ܕܝܼܫܘܿܥ ܡܫܝܼܚܵܐ ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ܕܵܐܟ݂ܝܼ ܕܝܼܠܹܗ ܟܬܝܼܒ݂ܵܐ ܒܐܹܫܲܥܝܵܐ ܢܒ݂ܝܼܵܐ: ܗܵܐ ܫܲܕܘܼܪܹܐ ܝܘܸܢ ܐܝܼܙܓܲܕܝܼ ܩܲܕܡܘܼܟ݂ ܕܗܲܕܸܪ ܐܘܼܪܚܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ܩܵܠܵܐ ܕܚܲܕ ܒܸܩܪܵܝܵܐ ܓܵܘ ܒܲܪܝܼܵܐ ”ܗܲܕܪܘܼܢ ܐܘܼܪܚܵܐ ܕܡܵܪܝܵܐ، ܘܡܲܫܘܹܝܡܘܼܢ ܫܒ݂ܝܼܠܘܼ̈ܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ܘܗ̇ܘ ܝܘܿܚܲܢܵܢ ܡܲܥܡܘܼܕܹܐ ܝܗܘܵܐ ܓܵܘ ܒܲܪܝܼܵܐ ܘܡܲܟܪܘܼܙܹܐ ܡܲܥܡܘܿܕܝܼܬܵ‌ܐ ܕܬܝܵܒ݂ܘܼܬܵ‌ܐ ܠܦܘܼܚܵܠܵܐ ܕܚܛܝܼܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ܘܦܠܝܼܛ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܟܠܵܝܗ‌ܝ ܐܢܵܫܹ̈ܐ ܕܝܼܗܘܼܕ ܘܐܘܼܦ ܕܐܘܿܪܸܫܠܸܡ، ܘܦܵܝܫܝܼ ܗܘܵܘ ܥܡܝܼܕܹܐ ܡܸܢܹܗ ܒܢܲܗܪܵܐ ܕܝܘܿܪܕܢܵܢ ܟܲܕ ܡܵܘܕܘܼܝܹܐ ܒܚܛܝܼܵܬܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ܠܒ݂ܝܼܫܬܵ‌ܐ ܕܝܘܿܚܲܢܵܢ ܡ̣ܢ ܣܲܥܪܵܐ ܕܓܘܼܡܠܹ̈ܐ ܝܗܘܵܐ، ܘܐܝܼܬ ܗܘܵܐ ܙܘܼܢܵܪܵܐ ܕܓܸܠܕܵܐ ܒܚܲܨܹܗ، ܘܡܹܐܟ݂ܘܼܠܬܹܗ ܩܲܡܨܹ̈ܐ ܘܕܸܒ݂ܫܵܐ ܕܒܲܪܝܼܵܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ܘܡܲܟܪܸܙ ܗܘܵܐ ܒܹܐܡܵܪܵܐ: ”ܗܵܐ ܒܹܐܬܵܝܵܐ ܝܠܹܗ ܡ̣ܢ ܒܵܬܪ ܡܸܢܝܼ ܚܲܕ ܒܘܼܫ ܚܲܝܠܵܢܵܐ ܡܸܢܝܼ، ܗ̇ܘ ܕܐܵܢܵܐ ܠܹܐ ܚܵܫܚܹܢ ܠܸܟܝܵܦܵܐ ܘܠܸܫܪܵܝܵܐ ܬܲܣܡܵܬܹ̈‌ܐ ܕܨܵܘܠܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","”ܐܵܢܵܐ ܡܲܥܡܘܼܕܹܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ ܒܡ̈ܝܼܵܐ، ܐܝܼܢܵܐ ܗ̇ܘ ܒܸܬ ܡܲܥܡܸܕ ܠܵܘܟ݂ܘܿܢ ܒܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ܒܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ ܐܬܹ‌ܐ ܠܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܢܵܨܪܲܬ ܕܓܠܝܼܠܵܐ، ܘܦܝܼܫ ܠܹܗ ܡܘܼܥܡܸܕܵܐ ܡ̣ܢ ܝܘܿܚܲܢܵܢ ܓܵܘ ܢܲܗܪܵܐ ܕܝܘܿܪܕܢܵܢ. ");
INSERT INTO aii_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܐܣܝܼܩ ܠܹܗ ܡ̣ܢ ܡ̈ܝܼܵܐ، ܚܙܹܐ ܠܹܗ ܫܡܲܝܵܐ ܦܬܝܼܚܬܵ‌ܐ ܘܪܘܼܚܵܐ ܐܲܝܟ݂ ܝܵܘܢܵܐ ܒܸܨܠܵܝܵܐ ܥܲܠܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ܘܩܵܠܵܐ ܐܬܹ‌ܐ ܠܹܗ ܡ̣ܢ ܫܡܲܝܵܐ ܒܹܐܡܵܪܵܐ: ”ܐܲܢ݇ܬ ܝܼܘܸܬ ܒܪܘܿܢܝܼ ܡܘܼܚܸܒܵܐ ܕܒܝܼܘܼܟ݂ ܒܣܝܼܡ ܠܵܗ̇ ܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܦܘܼܠܸܛ ܠܹܗ ܐܸܠܹܗ ܪܘܼܚܵܐ ܠܒܲܪܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ܘܗܘܹܐ ܠܹܗ ܬܵܡܵܐ ܓܵܘ ܒܲܪܝܼܵܐ ܐܲܪܒܥܝܼ ܝܵܘܡܵܢܹ̈ܐ، ܒܸܦܝܵܫܵܐ ܓ̰ܘܼܪܒܵܐ ܡ̣ܢ ܣܵܛܵܢܵܐ. ܘܥܲܡ ܗܲܝܘܵܢܹ̈ܐ ܕܒܲܪܝܼܵܐ ܝܗܘܵܐ، ܘܡܲܠܲܐܟܹ̈ܐ ܒܸܥܒ݂ܵܕܵܐ ܝܗܘܵܘ ܚܸܠܡܲܬ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ܡ̣ܢ ܒܵܬܪ ܕܦܝܼܫ ܠܹܗ ܕܸܪܝܵܐ ܝܘܿܚܲܢܵܢ ܓܵܘ ܒܹܝܬ ܐܲܣܝܼܪܹ̈ܐ، ܐܬܹ‌ܐ ܠܹܗ ܝܼܫܘܿܥ ܠܓܠܝܼܠܵܐ، ܡܲܟܪܘܼܙܹܐ ܐܹܘܲܢܓܲܠܝܼܘܿܢ ܕܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ، ");
INSERT INTO aii_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ܘܒܹܐܡܵܪܵܐ: ”ܬܘܼܡܸܡ ܠܹܗ ܙܲܒ݂ܢܵܐ، ܘܩܘܼܪܒܸܢܵܗ̇ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ. ܬܲܘܸܒܘܼܢ، ܘܗܲܡܸܢܘܼܢ ܒܐܹܘܲܢܓܲܠܝܼܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ܟܲܕ ܒܸܚܕܵܪܵܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܒܡܲܪܙܵܐ ܕܝܵܡܵܐ ܕܓܠܝܼܠܵܐ، ܚܙܹܐ ܠܹܗ ܠܫܸܡܥܘܿܢ ܘܠܐܲܢܕܪܹܐܘܿܣ ܐܲܚܘܿܢܘܼܗ‌ܝ ܒܸܕܪܵܝܵܐ ܓܲܪ̈ܕܵܝܗ‌ܝ ܒܝܵܡܵܐ، ܣܵܒܵܒ ܨܲܝܵܕܹ̈ܐ ܝܗܘܵܘ. ");
INSERT INTO aii_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܬܹܝܡܘܼܢ ܒܵܬܪܝܼ ܘܒܸܬ ܥܵܒ݂ܕܹܢܵܘܟ݂ܘܿܢ ܨܲܝܵܕܹ̈ܐ ܕܒܢܲܝ̈ܢܵܫܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܫܒ݂ܝܼܩ ܠܗܘܿܢ ܠܓܲܪ̈ܕܵܝܗ‌ܝ ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܒܵܬܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ܘܟܲܕ ܐܙܝܼܠܔ ܠܹܗ ܚܲܕ ܡܸܬܚܵܐ ܟܸܪܝܵܐ، ܚܙܹܐ ܠܹܗ ܠܝܲܥܩܘܿܒ݂ ܒܪܘܿܢܵܐ ܕܙܲܒ݂ܕܲܝ، ܘܝܘܿܚܲܢܵܢ ܐܲܚܘܿܢܘܼܗ‌ܝ، ܘܐܘܼܦ ܐܵܢܝܼ ܓܵܘ ܓܵܡܝܼ ܬܲܪܘܼܨܹܐ ܓܲܪ̈ܕܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܩܸܪܝܵܝ ܠܹܗ، ܘܫܒ݂ܝܼܩ ܠܗܘܿܢ ܠܙܲܒ݂ܕܲܝ ܒܵܒܵܝܗ‌ܝ ܓܵܘ ܓܵܡܝܼ ܥܲܡ ܪܹ̈ܓܵܘܵܬܹ‌ܐ ܕܒ݂ܝܼܩܹ̈ܐ ܒܗܵܩܵܐ، ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܒܵܬܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ܟܲܕ ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܦܲܪܢܵܚܘܿܡ، ܥܒ݂ܝܼܪܹܗ ܝܼܫܘܿܥ ܠܟܢܘܼܫܬܵ‌ܐ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ ܘܫܘܼܪܹܐ ܠܹܗ ܠܡܲܠܘܼܦܹܐ. ");
INSERT INTO aii_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ܘܥܲܓ̰ܒܝܼ ܗܘܵܘ ܒܝܘܼܠܦܵܢܹܗ ܣܵܒܵܒ ܡܲܠܸܦ ܗܘܵܐ ܠܗܘܿܢ ܐܲܝܟ݂ ܚܲܕ ܕܐܝܼܬ ܠܹܗ ܫܘܼܠܛܵܢܵܐ، ܘܠܵܐ ܐܲܝܟ݂ ܣܵܦܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ܘܐܝܼܬ ܗܘܵܐ ܓܵܘ ܟܢܘܼܫܬܵܝܗ‌ܝ ܚܲܕ ܐܢܵܫܵܐ ܕܐܝܼܬ ܗܘܵܐ ܒܝܼܹܗ ܪܘܼܚܵܐ ܛܲܡܐܹܐ، ܘܡܘܼܩܘܸܚ ܠܹܗ ܒܹܐܡܵܪܵܐ: ");
INSERT INTO aii_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","”ܡܵܐ ܠܘܼܟ݂ ܡܸܢܲܢ، ܝܵܐ ܝܼܫܘܿܥ ܢܵܨܪܵܝܵܐ؟ ܐܬܹ‌ܐ ܠܘܼܟ݂ ܕܛܲܠܩܸܬ ܠܲܢ؟ ܒܝܼܕܵܥܵܐ ܝܘܸܢ ܡܵܢܝܼ ܝܘܸܬ، ܐܲܢ݇ܬ ܝܼܘܸܬ ܩܲܕܝܼܫܵܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ܢܓ̰ܝܼܘ ܠܹܗ ܒܝܼܹܗ ܝܼܫܘܿܥ ܒܹܐܡܵܪܵܐ: ”ܫܬܘܿܩ، ܘܦܠܘܿܛ ܡܸܢܹܗ!“ ");
INSERT INTO aii_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ܪܘܼܦܹܐ ܠܵܗ̇ ܐܸܠܹܗ ܪܘܼܚܵܐ ܛܲܡܐܹܐ، ܘܡܘܼܩܘܸܚ ܠܵܗ̇ ܒܩܵܠܵܐ ܪܵܡܵܐ ܘܦܠܝܼܛ ܠܵܗ̇ ܡܸܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ܘܟܠܵܝܗ‌ܝ ܥܲܓ̰ܒܝܼ ܗܘܵܘ، ܗܵܕܟ݂ܵܐ ܕܒܲܩܪܝܼ ܗܘܵܘ ܚܲܕ ܥܲܡ ܗ̇ܘ ܐܚܹܪܢܵܐ ܒܹܐܡܵܪܵܐ: ”ܡܘܼܕܝܼ ܝܠܹܗ ܐܵܗܵܐ؟ ܝܘܼܠܦܵܢܵܐ ܚܵܕܬܵ‌ܐ ܒܫܘܼܠܛܵܢܵܐ! ܐܘܼܦ ܒܸܦܩܵܕܵܐ ܝܠܹܗ ܠܪ̈ܘܼܚܹܐ ܛܲܡܐܹ̈ܐ ܘܡܲܨܝܘܼܬܹ‌ܐ ܝܢܵܐ ܐܸܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ܘܒܓ̰ܲܠܕܘܼܬܵ‌ܐ ܦܪܝܼܣ ܠܹܗ ܚܲܒܪܵܐ ܒܘܼܬ ܕܝܼܹܗ ܒܟܠܹܗ ܐܲܬܪܵܐ ܕܓܠܝܼܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ، ܟܲܕ ܦܠܝܼܛ ܠܗܘܿܢ ܡ̣ܢ ܟܢܘܼܫܬܵ‌ܐ، ܥܒ݂ܝܼܪܗܘܿܢ ܠܒܲܝܬܵ‌ܐ ܕܫܸܡܥܘܿܢ ܘܐܲܢܕܪܹܐܘܿܣ، ܥܲܡ ܝܲܥܩܘܿܒ݂ ܘܝܘܿܚܲܢܵܢ. ");
INSERT INTO aii_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ܘܚܡܵܬܵ‌ܐ ܕܫܸܡܥܘܿܢ ܕܒ݂ܝܼܩܬܘܼܗ̇ ܝܗܘܵܐ ܚܲܡܚܲܡܬܵ‌ܐ، ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܐܡܝܼܪܗܘܿܢ ܠܝܼܫܘܿܥ ܒܘܼܬ ܕܝܼܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ܐܬܹ‌ܐ ܠܹܗ ܘܕܒ݂ܝܼܩܵܐ ܠܹܗ ܒܐܝܼܕܘܼܗ̇ ܘܡܘܼܩܸܡܵܐ ܠܹܗ، ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܫܒ݂ܝܼܩܵܐ ܠܵܗ̇ ܚܲܡܚܲܡܬܵ‌ܐ، ܘܫܘܼܪܹܐ ܠܵܗ̇ ܒܸܥܒ݂ܵܕܵܐ ܐܸܠܵܝܗ‌ܝ ܚܸܠܡܲܬ. ");
INSERT INTO aii_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ܘܒܪܲܡܫܵܐ، ܒܓܢܵܝܬܵ‌ܐ ܕܫܸܡܫܵܐ، ܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܝܼܗܘܵܘ ܡܪ̈ܝܼܥܹܐ، ܘܐܵܢܝܼ ܕܐܝܼܬ ܗܘܵܘ ܒܝܼܵܝܗ‌ܝ ܫܹܐܕܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ܘܟܠܵܝܗ‌ܝ ܐܢܵܫܹ̈ܐ ܕܡܕܝܼܢ݇ܬܵ‌ܐ ܓ̰ܡܝܼܥ ܠܗܘܿܢ ܩܲܕܡ ܬܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ܘܒܘܼܣܸܡ ܠܹܗ ܪܵܒܵܐ ܡ̣ܢ ܐܵܢܝܼ ܕܝܼܗܘܵܘ ܡܪܝܼܥܹܐ ܒܡܲܪ̈ܥܹܐ ܦܪ̈ܝܼܫܹܐ، ܘܦܘܼܠܸܛ ܠܹܗ ܪܵܒܵܐ ܫܹܐܕܹ̈ܐ ܘܠܵܐ ܫܒ݂ܝܼܩ ܠܹܗ ܫܹܐܕܹ̈ܐ ܕܗܲܡܙܸܡܝܼ ܗܘܵܘ، ܣܵܒܵܒ ܟܹܐ ܝܵܕܥܝܼ ܗܘܵܘ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ܘܒܨܲܦܪܵܐ، ܩܲܕܡ ܙܪܵܩܵܐ ܕܝܵܘܡܵܐ، ܩܝܼܡ ܠܹܗ ܘܦܠܝܼܛ ܠܹܗ ܠܒܲܪܝܼܵܐ، ܘܬܵܡܵܐ ܨܲܠܹܐ ܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ܘܛܥܹܐ ܠܗܘܿܢ ܒܵܬܪܹܗ ܫܸܡܥܘܿܢ ܘܐܵܢܝܼ ܕܥܲܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ܘܐܝܼܡܲܢ ܕܡܘܼܫ݇ܟ̰ܸܚ ܠܗܘܿܢ ܐܸܠܹܗ ܐܡܝܼܪܗܘܿܢ: ”ܟܠܵܝܗ‌ܝ ܐܢܵܫܹ̈ܐ ܒܸܛܥܵܝܵܐ ܝܢܵܐ ܒܵܬܪܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ܐܝܼܢܵܐ ܗ̇ܘ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܐܵܙܲܠ݇ܚ ܠܡܵܬܘܵܬܹ̈‌ܐ ܕܚܵܕܸܪ̈ܘܵܢܲܢ ܕܡܲܟܪܸܙܸܢ ܐܘܼܦ ܬܵܡܵܐ، ܣܵܒܵܒ ܒܘܼܬ ܐܵܗܵܐ ܐܬܹ‌ܐ ܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ܘܐܙܝܼܠܔ ܠܹܗ ܡܲܟܪܘܼܙܹܐ ܓܵܘ ܟܢܘܼܫܝܵܬܵܝ̈ܗ‌ܝ ܒܟܠܵܗ̇ ܓܠܝܼܠܵܐ، ܘܦܲܠܘܼܛܹܐ ܫܹܐܕܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ܘܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣܠܹܗ ܚܲܕ ܓܸܪܒ݂ܵܢܵܐ، ܒܪܝܼܟ ܠܹܗ ܩܲܕܡܘܼܗ‌ܝ، ܦܲܪܦܘܼܠܹܐ ܒܝܼܹܗ ܒܹܐܡܵܪܵܐ: ”ܐܸܢ ܒܵܥܹܝܬ، ܡܵܨܹܝܬ ܕܲܟܹܝܬ ܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ܪܘܼܚܸܡ ܠܹܗ ܥܲܠܘܼܗ‌ܝ ܝܼܫܘܿܥ، ܦܘܼܫܸܛ ܠܹܗ ܐܝܼܕܹܗ ܘܕܩܝܼܪܹܗ ܒܝܼܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܒܸܒܥܵܝܵܐ ܝܘܸܢ، ܦܘܼܫ ܕܸܟ݂ܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ، ܐܙܝܼܠܔ ܠܹܗ ܓܸܪܒܹܗ ܡܸܢܹܗ، ܘܦܝܼܫ ܠܹܗ ܕܘܼܟ݂ܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ܘܩܲܫܝܵܐܝܼܬ ܦܩܝܼܕ ܠܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܩܵܡ ܫܲܕܸܪܹܗ، ");
INSERT INTO aii_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ܒܹܐܡܵܪܵܐ ܐܸܠܹܗ: ”ܠܵܐ ܐܵܡܪܹܬ ܠܐܢܵܫܵܐ ܡܸܢܕܝܼ، ܐܝܼܢܵܐ ܙܹܠܔ݇ ܘܡܲܚܙܝܼ ܓܵܢܘܼܟ݂ ܠܟܵܗܢܵܐ ܘܡܲܩܪܸܒ݂ ܩܘܼܪܒܵܢܵܐ ܒܘܼܬ ܕܲܟܲܝܬܘܼܟ݂ ܕܵܐܟ݂ܝܼ ܕܦܩܝܼܕ ܠܹܗ ܡܘܼܫܹܐ، ܠܣܵܗܕܘܼܬܵܝܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ܐܝܼܢܵܐ ܗ̇ܘ ܦܠܝܼܛ ܠܹܗ ܘܫܘܼܪܹܐ ܠܹܗ ܠܗܲܡܙܘܼܡܹܐ ܪܵܒܵܐ، ܘܦܪܝܼܣ ܠܹܗ ܠܐܵܗܵܐ ܚܲܒܪܵܐ، ܗܵܕܵܐ ܕܝܼܫܘܿܥ ܠܵܐ ܡܨܹܐ ܠܹܗ ܓܲܠܝܵܐܝܼܬ ܥܵܒܹܪ ܠܡܕܝܼܢ݇ܬܵ‌ܐ، ܐܸܠܵܐ ܠܒܲܕܲܪ ܝܼܗܘܵܐ ܓܵܘ ܒܲܪܝܼܵܐ، ܘܐܢܵܫܹ̈ܐ ܟܹܐ ܐܵܬ‌ܝܼ ܗܘܵܘ ܠܟܸܣܠܹܗ ܡ̣ܢ ܟܠܔ ܕܘܼܟܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ܡܸܢܕܪܸܫ ܥܒ݂ܝܼܪܹܗ ܝܼܫܘܿܥ ܠܟܦܲܪܢܵܚܘܿܡ ܡ̣ܢ ܒܵܬܪ ܚܲܕܟܡܵܐ ܝܵܘܡܵܢܹ̈ܐ، ܘܟܲܕ ܫܡܝܼܥ ܠܗܘܿܢ ܕܓܵܘ ܒܲܝܬܵ‌ܐ ܝܗܘܵܐ، ");
INSERT INTO aii_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ܓ̰ܡܝܼܥ ܠܗܘܿܢ ܟܸܢܫܹ̈ܐ ܪܵܒܵܐ ܗܵܕܵܐ ܕܠܲܝܬ ܗܘܵܐ ܕܘܼܟܵܐ، ܐܘܼܦ ܠܵܐ ܩܲܕܡ ܬܲܪܥܵܐ، ܘܗܲܡܙܸܡ ܗܘܵܐ ܐܸܠܵܝܗ‌ܝ ܗܹܡܸܙܡܵܢ. ");
INSERT INTO aii_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ܗ̇ܝܓܵܗ ܐܬܹ‌ܐ ܠܗܘܿܢ ܘܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܚܲܕ ܫܦܝܼܠܵܐ، ܦܝܼܫܵܐ ܛܥܝܼܢܵܐ ܒܝܲܕ ܐܲܪܒܥܵܐ ܐܢܵܫܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ܘܐܝܼܡܲܢ ܕܠܵܐ ܡܨܹܐ ܠܗܘܿܢ ܩܲܪܒܸܢܝܼ ܗܘܵܘ ܠܟܸܣ ܝܼܫܘܿܥ ܡ̣ܢ ܟܸܢܫܵܐ، ܓܘܼܠܹܐ ܠܗܘܿܢ ܠܐܓܵܪܹܐ ܐܲܝܟܵܐ ܕܝܼܗܘܵܐ ܝܼܫܘܿܥ، ܘܡܘܼܨܠܹܐ ܠܗܘܿܢ ܠܫܘܝܼܬܵ‌ܐ ܕܥܲܠܘܼܗ̇ ܝܗܘܵܐ ܗ̇ܘ ܫܦܝܼܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ܟܲܕ ܚܙܹܐ ܠܹܗ ܝܼܫܘܿܥ ܗܲܝܡܵܢܘܼܬܵܝܗ‌ܝ، ܐܡܝܼܪܹܗ ܠܗ̇ܘ ܫܦܝܼܠܵܐ: ”ܒܪܘܿܢܝܼ، ܦܘܼܚܠܹܐ ܝܢܵܐ ܐܸܠܘܼܟ݂ ܚܛܝܼܵܬܘܼ̈ܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ܐܝܼܢܵܐ ܚܲܕܟܡܵܐ ܣܵܦܪܹ̈ܐ ܕܝܬܝܼܒܹܐ ܝܗܘܵܘ ܬܵܡܵܐ، ܒܸܚܫܵܒ݂ܵܐ ܝܗܘܵܘ ܒܠܸܒܵܝܗ‌ܝ: ");
INSERT INTO aii_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","”ܩܵܡܘܿܕܝܼ ܒܸܓܕܵܦܵܐ ܝܠܹܗ ܐܵܗܵܐ؟ ܡܵܢܝܼ ܡܵܨܹܐ ܦܲܚܸܠܔ ܚܛܝܼܵܬܹ̈‌ܐ ܐܸܠܵܐ ܐܲܠܵܗܵܐ ܐܲܚܟ̰ܝܼ؟“ ");
INSERT INTO aii_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ܝܼܫܘܿܥ ܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܝܕܝܼܥ ܠܹܗ ܒܪܘܼܚܹܗ ܕܗܵܕܟ݂ܵܐ ܒܸܚܫܵܒ݂ܵܐ ܝܗܘܵܘ ܒܓܵܢܵܝܗ‌ܝ، ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܩܵܡܘܿܕܝܼ ܒܸܚܫܵܒ݂ܵܐ ܝܬܘܿܢ ܗܵܕܟ݂ܵܐ ܒܠܸܒܵܘܟ݂ܘܿܢ؟ ");
INSERT INTO aii_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","”ܐܲܝܢܝܼ ܝܠܹܗ ܒܘܼܫ ܦܫܘܼܩܵܐ ܠܹܐܡܵܪܵܐ ܠܫܦܝܼܠܵܐ: ’ܦܘܼܚܠܹܐ ܝܢܵܐ ܐܸܠܘܼܟ݂ ܚܛܝܼܵܬܘܼ̈ܟ݂،‘ ܝܲܢ ܠܹܐܡܵܪܵܐ: ’ܩܘܼܡ، ܫܩܘܿܠܔ ܫܘܝܼܬܘܼܟ݂ ܘܚܕܘܿܪ؟‘ ");
INSERT INTO aii_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","”ܐܝܼܢܵܐ ܕܝܵܕܥܝܼܬܘܿܢ ܕܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܐܝܼܬ ܠܹܗ ܫܘܼܠܛܵܢܵܐ ܥܲܠܔ ܐܲܪܥܵܐ ܕܦܲܚܸܠܔ ܚܛܝܼܵܬܹ̈‌ܐ،“ ܗ̇ܝܓܵܗ ܐܡܝܼܪܹܗ ܠܫܦܝܼܠܵܐ: ");
INSERT INTO aii_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","”ܐܸܠܘܼܟ݂ ܒܹܐܡܵܪܵܐ ܝܘܸܢ: ܩܘܼܡ، ܫܩܘܿܠܔ ܫܘܝܼܬܘܼܟ݂ ܘܙܹܠܔ݇ ܠܒܲܝܬܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܩܝܼܡ ܠܹܗ، ܫܩܝܼܠܔ ܠܹܗ ܫܘܝܼܬܹܗ ܘܦܠܝܼܛ ܠܹܗ ܩܲܕܡ ܥܲܝ̈ܢܹܐ ܕܟܠܵܝܗ‌ܝ، ܗܵܕܟ݂ܵܐ ܕܥܲܓ̰ܒܝܼ ܗܘܵܘ ܟܠܵܝܗ‌ܝ، ܘܫܲܒܚܝܼ ܗܘܵܘ ܠܐܲܠܵܗܵܐ، ܒܹܐܡܵܪܵܐ: ”ܗܲܪ ܠܹܐ ܝܘܲܚ ܚܸܙܝܹܐ ܗܵܕܟ݂ܵܐ ܡܸܢܕܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ܘܦܠܝܼܛ ܠܹܗ ܝܼܫܘܿܥ ܡܸܢܕܪܸܫ ܠܟܸܣ ܝܵܡܵܐ، ܘܟܠܹܗ ܟܸܢܫܵܐ ܒܹܐܬܵܝܵܐ ܝܗܘܵܘ ܠܟܸܣܠܹܗ، ܘܡܲܠܘܼܦܵܝ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ܘܟܲܕ ܒܸܥܒ݂ܵܪܵܐ، ܚܙܹܐ ܠܹܗ ܠܠܹܘܝܼ ܒܪܘܿܢܵܐ ܕܚܲܠܦܲܝ ܝܬܝܼܒ݂ܵܐ ܓܵܘ ܒܹܝܬ ܡܵܟ݂ܣܹ̈ܐ، ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܬܵ‌ܐ ܒܵܬܪܝܼ.“ ܘܩܝܼܡ ܠܹܗ ܐܙܝܼܠܔ ܠܹܗ ܒܵܬܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ܟܲܕ ܝܬܝܼܒ݂ܵܐ ܝܗܘܵܐ ܠܣܘܼܦܪܵܐ ܓܵܘ ܒܲܝܬܵ‌ܐ ܕܠܹܘܝܼ، ܪܵܒܵܐ ܡܵܟ݂ܣܹ̈ܐ ܘܚܲܛܵܝܹ̈ܐ ܝܬܝܼܒܹܐ ܝܗܘܵܘ ܥܲܡ ܝܼܫܘܿܥ ܘܥܲܡ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ܣܵܒܵܒ ܪܵܒܵܐ ܝܗܘܵܘ ܐܵܢܝܼ ܕܐܬܹ‌ܐ ܠܗܘܿܢ ܒܵܬܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ܐܝܼܢܵܐ ܣܵܦܪܹ̈ܐ ܘܦܪ̈ܝܼܫܹܐ، ܟܲܕ ܚܙܹܐ ܠܗܘܿܢ ܠܝܼܫܘܿܥ ܒܹܐܟ݂ܵܠܵܐ ܥܲܡ ܡܵܟ݂ܣܹ̈ܐ ܘܚܲܛܵܝܹ̈ܐ، ܐܡܝܼܪܗܘܿܢ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܩܵܡܘܿܕܝܼ ܒܹܐܟ݂ܵܠܵܐ ܝܠܹܗ ܥܲܡ ܡܵܟ݂ܣܹ̈ܐ ܘܚܲܛܵܝܹ̈ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ܟܲܕ ܫܡܝܼܥ ܠܹܗ ܝܼܫܘܿܥ ܐܵܗܵܐ، ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܠܹܐ ܝܢܵܐ ܣܢܝܼܩܹܐ ܠܐܵܣܝܵܐ ܐܵܢܝܼ ܕܝܼܢܵܐ ܒܚܘܼܠܡܵܢܵܐ، ܐܸܠܵܐ ܐܵܢܝܼ ܕܡܪܝܼܥܹܐ ܝܢܵܐ. ܠܵܐ ܐܬܹ‌ܐ ܠܝܼ ܕܩܵܪܹܝܢ ܠܙܲܕܝܼܩܹ̈ܐ ܐܸܠܵܐ ܠܚܲܛܵܝܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܬܲܠܡܝܼ̈ܕܹܐ ܕܝܘܿܚܲܢܵܢ ܘܕܦܪ̈ܝܼܫܹܐ ܕܝܼܗܘܵܘ ܨܝܼܡܹܐ، ܘܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ: ”ܩܵܡܘܿܕܝܼ ܬܲܠܡܝܼ̈ܕܹܐ ܕܝܘܿܚܲܢܵܢ ܘܕܦܪ̈ܝܼܫܹܐ ܟܹܐ ܨܵܝܡܝܼ ܐܝܼܢܵܐ ܬܲܠܡܝܼ̈ܕܹܐ ܕܝܼܘܼܟ݂ ܠܹܐ ܨܵܝܡܝܼ؟“ ");
INSERT INTO aii_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܩܵܡܘܿܕܝܼ ܟܹܐ ܡܵܨܝܼ ܐܲܪ̈ܚܹܐ ܕܚܠܘܼܠܵܐ ܨܵܝܡܝܼ ܟܡܵܐ ܕܚܸܬܢܵܐ ܥܲܡܵܝܗ‌ܝ ܝܠܹܗ؟ ܠܵܐ، ܠܹܐ ܡܵܨܝܼ ܟܡܵܐ ܕܗ̇ܘ ܥܲܡܵܝܗ‌ܝ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","”ܐܝܼܢܵܐ ܒܸܬ ܐܵܬ‌ܝܼ ܝܵܘܡܵܢܹ̈ܐ ܐܝܼܡܲܢ ܕܦܵܐܹܫ ܫܩܝܼܠܵܐ ܚܸܬܢܵܐ ܡܸܢܵܝܗ‌ܝ، ܗ̇ܝܓܵܗ ܒܸܬ ܨܵܝܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","”ܐܢܵܫܵܐ ܠܹܐ ܚܵܐܹܛ ܥܵܪܵܝܬܵ‌ܐ ܚܲܕܬܵ‌ܐ ܥܲܠܔ ܠܒ݂ܝܼܫܬܵ‌ܐ ܒܠܝܼܬܵ‌ܐ، ܘܐܸܢ ܠܵܐ، ܒܸܬ ܓܵܪܫܵܐ ܥܵܪܵܝܬܵ‌ܐ ܡ̣ܢ ܠܒ݂ܝܼܫܬܵ‌ܐ، ܘܒܸܬ ܙܵܐܹܕ ܦܸܪܛܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","”ܘܐܘܼܦ ܚܲܕ ܠܹܐ ܕܵܪܹܐ ܚܲܡܪܵܐ ܚܵܕܬܵ‌ܐ ܓܵܘ ܓܘܼܕܹ̈ܐ ܒܸܠܝܹ̈ܐ، ܘܐܸܢ ܠܵܐ، ܚܲܡܪܵܐ ܒܸܬ ܒܵܙܹܥ ܠܗܘܿܢ ܓܘܼܕܹ̈ܐ، ܘܓܘܼܕܹ̈ܐ ܒܸܬ ܚܵܪܒ݂ܝܼ ܘܚܲܡܪܵܐ ܫܵܦܹܟ݂؛ ܐܸܠܵܐ ܟܹܐ ܕܵܪܝܼ ܚܲܡܪܵܐ ܚܵܕܬܵ‌ܐ ܓܵܘ ܓܘܼܕܹ̈ܐ ܚܵܕܬܹ̈‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ܟܲܕ ܒܸܚܕܵܪܵܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ ܓܵܘ ܚܲܩܠܵܢܹ̈ܐ، ܫܘܼܪܹܐ ܠܗܘܿܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܒܸܫܠܵܓܵܐ ܫܸܒܠܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ ܦܪ̈ܝܼܫܹܐ: ”ܚܙܝܼ، ܩܵܡܘܿܕܝܼ ܒܸܥܒ݂ܵܕܵܐ ܝܢܵܐ ܡܸܢܕܝܼ ܕܠܹܐ ܝܠܹܗ ܩܵܢܘܿܢܵܝܵܐ ܠܸܥܒ݂ܵܕܵܐ ܒܫܲܒܬܵ‌ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ܐܝܼܢܵܐ ܗ̇ܘ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܗܵܐ ܠܹܐ ܝܬܘܿܢ ܩܸܪܝܹܐ ܡܘܼܕܝܼ ܥܒ݂ܝܼܕ ܠܹܗ ܕܵܘܝܼܕ ܐܝܼܡܲܢ ܕܗ̇ܘ ܘܐܵܢܝܼ ܕܥܲܡܹܗ ܣܢܝܼܩ ܠܗܘܿܢ ܘܟܦܝܼܢܗܘܿܢ؟ ");
INSERT INTO aii_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","”ܕܵܐܟ݂ܝܼ ܥܒ݂ܝܼܪܹܗ ܠܒܲܝܬܵ‌ܐ ܕܐܲܠܵܗܵܐ، ܒܥܕܵܢܵܐ ܕܝܼܗܘܵܐ ܐܲܒ݂ܝܼܬܵܪ ܓܘܼܪܵܐ ܕܟܵܗ̈ܢܹܐ، ܘܠܲܚܡܵܐ ܕܦܵܬܘܿܪܵܐ ܕܡܵܪܝܵܐ ܐܟ݂ܝܼܠܔ ܠܹܗ، ܗ̇ܘ ܕܠܹܐ ܝܗܘܵܐ ܩܵܢܘܿܢܵܝܬܵ‌ܐ ܐܸܠܹܗ ܠܹܐܟ݂ܵܠܵܐ ܫܒ݂ܘܿܩ ܡ̣ܢ ܠܟܵܗ̈ܢܹܐ. ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܐܘܼܦ ܠܐܵܢܝܼ ܕܝܼܗܘܵܘ ܥܲܡܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܫܲܒܬܵ‌ܐ ܦܝܼܫܬܵ‌ܐ ܝܠܵܗ̇ ܒܪܝܼܬܵ‌ܐ ܩܵܐ ܒܲܪܢܵܫܵܐ، ܠܵܐ ܒܲܪܢܵܫܵܐ ܩܵܐ ܫܲܒܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","”ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܗܵܕܟ݂ܵܐ ܐܘܼܦ ܡܵܪܵܐ ܕܫܲܒܬܵ‌ܐ ܝܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ܡܸܢܕܪܸܫ ܥܒ݂ܝܼܪܹܗ ܝܼܫܘܿܥ ܠܟܢܘܼܫܬܵ‌ܐ، ܘܬܵܡܵܐ ܐܝܼܬ ܗܘܵܐ ܚܲܕ ܐܢܵܫܵܐ ܐܝܼܕܹܗ ܒܪܝܼܙܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ܘܨܵܝܕܝܼ ܗܘܵܘ ܠܹܗ ܕܐܸܢ ܒܸܬ ܒܲܣܸܡ ܠܹܗ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ، ܩܵܐ ܕܩܵܒ݂ܠܝܼ ܗܘܵܘ ܥܲܠܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ܐܡܝܼܪܹܗ ܠܗ̇ܘ ܐܢܵܫܵܐ ܐܝܼܕܹܗ ܒܪܝܼܙܬܵ‌ܐ: ”ܟܠܝܼ ܒܹܝܦܲܠܓܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ܘܒܘܼܩܸܪܹܗ ܡ̣ܢ ܐܵܢܝܼ ܕܝܼܗܘܵܘ ܬܵܡܵܐ: ”ܩܵܢܘܿܢܵܝܬܵ‌ܐ ܝܠܵܗ̇ ܠܸܥܒ݂ܵܕܵܐ ܛܵܒ݂ܬܵ‌ܐ ܝܲܢ ܒܝܼܫܬܵ‌ܐ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ، ܠܦܲܪܘܼܩܹܐ ܓܵܢܵܐ ܝܲܢ ܠܛܲܠܘܼܩܹܐ؟“ ܐܝܼܢܵܐ ܐܵܢܝܼ ܠܵܐ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ܘܚܝܼܪܹܗ ܝܼܫܘܿܥ ܒܝܼܵܝܗ‌ܝ ܒܟܲܪܒܵܐ ܘܒܦܵܫܲܡܬܵ‌ܐ ܥܲܠܔ ܩܸܫܝܘܼܬܵ‌ܐ ܕܠܸܒܵܝܗ‌ܝ، ܘܐܡܝܼܪܹܗ ܠܗ̇ܘ ܐܢܵܫܵܐ: ”ܦܲܫܸܛ ܐܝܼܕܘܼܟ݂.“ ܘܦܘܼܫܛܵܐ ܠܹܗ ܐܝܼܕܹܗ، ܘܒܣܝܼܡ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ܗ̇ܝܓܵܗ ܦܠܝܼܛ ܠܗܘܿܢ ܦܪ̈ܝܼܫܹܐ ܘܣܘܼܙܓܸܪܗܘܿܢ ܥܲܡ ܗܹܪ̈ܘܿܕܸܣܵܝܹܐ ܕܵܐܟ݂ܝܼ ܩܵܛܠܝܼ ܠܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܫܘܼܢܹܐ ܠܹܗ ܡ̣ܢ ܬܵܡܵܐ ܘܐܬܹ‌ܐ ܠܹܗ ܠܓܹܒܵܐ ܕܝܵܡܵܐ ܥܲܡ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܒܵܬܪܹܗ ܟܸܢܫܹ̈ܐ ܪܵܒܵܐ ܡ̣ܢ ܓܠܝܼܠܵܐ ܘܡ̣ܢ ܝܼܗܘܼܕ، ");
INSERT INTO aii_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ܘܡ̣ܢ ܐܘܿܪܸܫܠܸܡ، ܘܡ̣ܢ ܐܲܕܘܿܡ، ܘܡ̣ܢ ܥܸܒ݂ܪܵܐ ܕܝܘܿܪܕܢܵܢ، ܘܚܵܕܸܪ̈ܘܵܢܹܐ ܕܨܘܿܪ ܘܨܲܝܕܘܿܢ، ܘܟܸܢܫܹ̈ܐ ܪܵܒܵܐ ܕܫܡܝܼܥ ܠܗܘܿܢ ܒܘܼܬ ܡܸܢܕܝܼܵܢܹ̈ܐ ܕܒܸܥܒ݂ܵܕܵܐ ܝܗܘܵܐ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ܘܐܡܝܼܪܹܗ ܠܬܲܠܡܝܼ̈ܕܹܐ ܕܡܲܝܬ‌ܝܼ ܗܘܵܘ ܠܹܗ ܓܵܡܝܼ ܙܥܘܿܪܬܵ‌ܐ ܕܝܵܬܹܒ݂ ܗܘܵܐ ܓܵܘܘܼܗ̇ ܕܠܵܐ ܡܲܠܝܸܨܝܼ ܗܘܵܘ ܠܹܗ ܟܸܢܫܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ܣܵܒܵܒ ܒܘܼܣܸܡ ܠܹܗ ܪܵܒܵܐ، ܘܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܐܝܼܬ ܗܘܵܘ ܠܗܘܿܢ ܡܲܪ̈ܥܹܐ ܩܲܪܒܸܢܝܼ ܗܘܵܘ ܐܸܠܹܗ ܠܸܕܩܵܪܵܐ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ܘܐܵܢܝܼ ܕܐܝܼܬ ܗܘܵܘ ܒܝܼܵܝܗ‌ܝ ܪ̈ܘܼܚܹܐ ܛܲܡܐܹ̈ܐ، ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܗܘܿܢ ܐܸܠܹܗ، ܢܦܝܼܠܔ ܠܗܘܿܢ ܩܲܕܡܘܼܗ‌ܝ ܡܲܩܘܘܼܚܹܐ ܘܒܹܐܡܵܪܵܐ: ”ܐܲܢ݇ܬ ܝܼܘܸܬ ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ܐܝܼܢܵܐ ܗ̇ܘ ܩܲܫܝܵܐܝܼܬ ܦܩܝܼܕܵܝ ܠܹܗ ܕܠܵܐ ܓܵܠܝܼ ܗܘܵܘ ܒܘܼܬ ܕܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ܐܣܝܼܩ ܠܹܗ ܝܼܫܘܿܥ ܠܛܘܼܪܵܐ ܘܩܪܹܐ ܠܹܗ ܠܐܵܢܝܼ ܕܒܵܥܹܐ ܗܘܵܐ. ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ܦܪܝܼܫ ܠܹܗ ܬܪܸܥܣܲܪ ܕܗܵܘܝܼ ܗܘܵܘ ܥܲܡܹܗ، ܕܫܲܕܸܪ ܗܘܵܘ ܠܗܘܿܢ ܕܡܲܟܪܸܙܝܼ ܗܘܵܘ، ");
INSERT INTO aii_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ܘܕܗܵܘܹܐ ܗܘܵܐ ܠܗܘܿܢ ܫܘܼܠܛܵܢܵܐ ܠܦܲܠܘܼܛܹܐ ܫܹܐܕܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ܡܘܼܬܸܒ݂ ܠܹܗ ܫܸܡܵܐ ܕܫܸܡܥܘܿܢ، ”ܟܹܐܦܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ܘܠܝܲܥܩܘܿܒ݂ ܘܠܝܘܿܚܲܢܵܢ ܐܲܚܘܿܢܘܼܗ‌ܝ، ܒܢܘܿܢܹ̈ܐ ܕܙܲܒ݂ܕܲܝ، ܡܘܼܬܸܒ݂ ܠܹܗ ܫܸܡܵܐ، ”ܒܢܲܝ̈ ܪܲܓ݂ܫܝܼ،“ ܝܲܥܢܹܐ، ”ܒܢܘܿܢܹ̈ܐ ܕܪܲܥܡܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ܘܐܲܢܕܪܹܐܘܿܣ، ܘܦܝܼܠܝܼܦܘܿܣ، ܘܒܲܪ ܬܘܼܠܡܲܝ، ܘܡܲܬܲ‌ܝ، ܘܬܐܘܿܡܵܐ، ܘܝܲܥܩܘܿܒ݂ ܒܲܪ ܚܲܠܦܲܝ، ܘܬܲܕܲܝ، ܘܫܸܡܥܘܿܢ ܩܢܵܢܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ܘܝܼܗܘܼܕܵܐ ܣܟܲܪܝܘܿܛܵܐ، ܗ̇ܘ ܕܣܘܼܦܹܐ ܠܹܗ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ܐܬܹ‌ܐ ܠܹܗ ܝܼܫܘܿܥ ܠܒܲܝܬܵ‌ܐ، ܘܡܸܢܕܪܸܫ ܓ̰ܡܝܼܥ ܠܹܗ ܟܸܢܫܵܐ ܗܵܕܟ݂ܵܐ ܕܠܵܐ ܡܨܹܐ ܠܗܘܿܢ ܗ̇ܘ ܘܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܐܵܟ݂ܠܝܼ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܗܘܿܢ ܚܸܙܡܵܢܘܼ̈ܗ‌ܝ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܕܠܲܒܠܝܼ ܗܘܵܘ ܠܹܗ ܣܵܒܵܒ ܐܡܝܼܪܗܘܿܢ: ”ܫܘܼܕܸܢܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ܘܐܵܢܝܼ ܣܵܦܪܹ̈ܐ ܕܨܠܹܐ ܠܗܘܿܢ ܡ̣ܢ ܐܘܿܪܸܫܠܸܡ ܐܵܡܪܝܼ ܗܘܵܘ ܒܘܼܬ ܕܝܼܹܗ: ”ܐܝܼܬ ܒܝܼܹܗ ܒܥܸܠܙܒ݂ܘܿܒ݂، ܘܒܚܲܝܠܵܐ ܕܓܘܼܪܵܐ ܕܫܹܐܕܹ̈ܐ ܦܲܠܘܼܛܹܐ ܝܠܹܗ ܫܹܐܕܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܩܸܪܝܵܝ ܠܹܗ ܠܟܸܣܠܹܗ ܘܗܘܼܡܙܸܡ ܠܹܗ ܥܲܡܵܝܗ‌ܝ ܒܡܲܬܠܹ̈ܐ ܒܹܐܡܵܪܵܐ: ”ܕܵܐܟ݂ܝܼ ܡܵܨܹܐ ܣܵܛܵܢܵܐ ܦܲܠܸܛ ܣܵܛܵܢܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","”ܘܐܸܢ ܡܲܠܟܘܼܬܵ‌ܐ ܦܵܝܫܵܐ ܦܠܝܼܥܬܵ‌ܐ ܥܲܠܔ ܓܵܢܘܼܗ̇ ܠܹܐ ܡܵܨܝܵܐ ܟܵܠܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","”ܘܐܸܢ ܒܲܝܬܵ‌ܐ ܥܲܠܔ ܓܵܢܹܗ ܦܵܐܹܫ ܦܠܝܼܥܵܐ ܠܹܐ ܡܵܨܹܐ ܟܵܠܹܐ. ");
INSERT INTO aii_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","”ܘܐܸܢ ܣܵܛܵܢܵܐ ܩܵܐܹܡ ܠܕܲܠܩܘܼܒ݂ܠܔ ܕܓܵܢܹܗ ܘܦܵܐܹܫ ܦܠܝܼܥܵܐ، ܠܹܐ ܡܵܨܹܐ ܟܵܠܹܐ، ܐܸܠܵܐ ܒܸܬ ܡܵܛܹܐ ܠܚܘܼܬܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","”ܐܘܼܦ ܚܲܕ ܠܹܐ ܡܵܨܹܐ ܥܵܒܹܪ ܠܒܲܝܬܵ‌ܐ ܕܚܲܕ ܐܢܵܫܵܐ ܚܲܝܠܵܢܵܐ ܘܣܵܠܹܒ ܠܡܸܢܕܝܼܹܗ، ܐܸܢ ܠܵܐ ܩܲܕܡܵܝܬܵ‌ܐ ܐܵܣܹܪ ܠܚܲܝܠܵܢܵܐ ܘܗ̇ܝܓܵܗ ܣܵܠܹܒ ܠܒܲܝܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܟܠܵܝܗ‌ܝ ܚܛܝܼܵܬܹ̈‌ܐ ܒܸܬ ܦܵܝܫܝܼ ܦܘܼܚܠܹܐ ܠܒܢܲܝ̈ܢܵܫܵܐ، ܘܟܠܵܝܗ‌ܝ ܓܘܼܕܵܦܹ̈ܐ ܕܓܵܕܦܝܼ ܠܗܘܿܢ ܒܸܬ ܦܵܝܫܝܼ ܦܘܼܚܠܹܐ ܐܸܠܵܝܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","”ܐܝܼܢܵܐ ܡ̇ܢ ܕܓܵܕܹܦ ܥܲܠܔ ܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ، ܠܲܝܬ ܠܹܗ ܦܘܼܚܵܠܵܐ ܗܲܠܔ ܥܵܠܲܡ، ܐܝܼܢܵܐ ܚܲܝܵܒ݂ܵܐ ܝܠܹܗ ܠܚܛܝܼܬܵ‌ܐ ܕܠܥܵܠܲܡ.“ ");
INSERT INTO aii_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ܣܵܒܵܒ ܐܵܡܪܝܼ ܗܘܵܘ: ”ܪܘܼܚܵܐ ܛܲܡܐܹܐ ܐܝܼܬ ܒܝܼܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ܒܗ̇ܝ ܥܕܵܢܵܐ ܐܬܹ‌ܐ ܠܗܘܿܢ ܝܸܡܹܗ ܘܐܲܚܘܿܢܘܵܬܘܼ̈ܗ‌ܝ، ܟܠܹܐ ܠܗܘܿܢ ܠܒܲܕܲܪ، ܘܫܘܼܕܸܪܗܘܿܢ ܠܟܸܣܠܹܗ ܕܐܵܬܹ‌ܐ ܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ܘܟܸܢܫܵܐ ܕܝܬܝܼܒ݂ܵܐ ܝܗܘܵܘ ܠܟܸܣܠܹܗ ܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܗܵܐ ܝܸܡܘܼܟ݂ ܘܐܲܚܘܿܢܘܵܬܘܼ̈ܟ݂ ܟܸܠܝܵܐ ܝܢܵܐ ܠܒܲܕܲܪ، ܘܒܸܛܠܵܒܘܼܟ݂ ܝܼܢܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ܘܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܡܵܢܝܼ ܝܠܵܗ̇ ܝܸܡܝܼ، ܘܡܵܢܝܼ ܝܢܵܐ ܐܲܚܘܿܢܘܵܬ‌ܝܼ̈؟“ ");
INSERT INTO aii_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ܘܚܝܼܪܹܗ ܒܐܵܢܝܼ ܕܝܬܝܼܒܹܐ ܝܗܘܵܘ ܠܚܵܕܸܪ̈ܘܵܢܘܼܗ‌ܝ ܘܐܡܝܼܪܹܗ: ”ܗܵܐ، ܝܸܡܝܼ، ܘܗܵܐ، ܐܲܚܘܿܢܘܵܬ‌ܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","”ܣܵܒܵܒ ܟܠܔ ܡ̇ܢ ܕܥܵܒܹܕ ܨܸܒ݂ܝܵܢܵܐ ܕܐܲܠܵܗܵܐ، ܗ̇ܘ ܝܼܠܹܗ ܐܲܚܘܿܢܝܼ، ܘܚܵܬ‌ܝܼ، ܘܝܸܡܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ܡܸܢܕܪܸܫ ܫܘܼܪܹܐ ܠܹܗ ܝܼܫܘܿܥ ܠܡܲܠܘܼܦܹܐ ܠܡܲܪܙܵܐ ܕܝܵܡܵܐ، ܘܓ̰ܡܝܼܥ ܠܹܗ ܠܟܸܣܠܹܗ ܟܸܢܫܵܐ ܟ̰ܸܡ ܪܵܒܵܐ، ܗܵܕܵܐ ܕܗ̇ܘ ܐܣܝܼܩ ܠܹܗ ܘܝܬܝܼܒ݂ ܠܹܗ ܓܵܘ ܓܵܡܝܼ، ܘܟܸܢܫܵܐ ܟܸܠܝܵܐ ܝܗܘܵܐ ܥܲܠܔ ܒܸܪܙܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ܘܡܲܠܘܼܦܵܝ ܝܗܘܵܐ ܪܵܒܵܐ ܡܸܢܕܝܼܵܢܹ̈ܐ ܒܡܲܬܠܹ̈ܐ، ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܒܡܲܠܲܦܬܹܗ: ");
INSERT INTO aii_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","”ܫܡܹܥܡܘܼܢ، ܗܵܐ، ܦܠܝܼܛ ܠܹܗ ܙܵܪܥܵܢܵܐ ܠܸܙܪܵܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","”ܘܗܘܹܐ ܠܵܗ̇ ܟܲܕ ܗ̇ܘ ܒܸܙܪܵܥܵܐ ܝܗܘܵܐ، ܐܝܼܬ ܗܘܵܐ ܡ̣ܢ ܒܲܪܙܲܪܥܵܐ ܕܢܦܝܼܠܔ ܠܹܗ ܠܡܲܪܙܵܐ ܕܐܘܼܪܚܵܐ، ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܛܲܝܪܹ̈ܐ ܘܠܩܝܼܛ ܠܗܘܿܢ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","”ܘܐܚܹܪܢܵܐ ܢܦܝܼܠܔ ܠܹܗ ܥܲܠܔ ܐܲܪܥܵܐ ܟܹܐܦܵܢܬܵ‌ܐ، ܐܲܝܟܵܐ ܕܠܲܝܬ ܗܘܵܐ ܥܲܦܪܵܐ ܪܵܒܵܐ، ܘܒܓ̰ܲܠܕܘܼܬܵ‌ܐ ܡܘܼܓ̰ܝܸܢܹܗ ܣܵܒܵܒ ܠܲܝܬ ܗܘܵܐ ܥܘܼܡܩܵܐ ܒܥܲܦܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","”ܘܟܲܕ ܙܪܝܼܩ ܠܹܗ ܫܸܡܫܵܐ، ܝܩܝܼܕ ܠܹܗ، ܘܣܵܒܵܒ ܠܲܝܬ ܗܘܵܐ ܠܹܗ ܥܸܩܪܵܐ، ܒܪܝܼܙ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","”ܘܐܚܹܪܢܵܐ ܢܦܝܼܠܔ ܠܹܗ ܓܵܘ ܟܸܬܘܹ̈ܐ. ܓܘܼܪܘܸܣ ܠܗܘܿܢ ܟܸܬܘܹ̈ܐ ܘܚܢܝܼܩ ܠܗܘܿܢ ܐܸܠܹܗ، ܘܠܵܐ ܝܘܼܗܒܹܠܔ ܠܹܗ ܛܥܘܼܢܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","”ܘܐܚܹܪ̈ܢܹܐ ܢܦܝܼܠܔ ܠܗܘܿܢ ܥܲܠܔ ܐܲܪܥܵܐ ܫܲܡܝܼܢܬܵ‌ܐ ܘܝܘܼܗܒܹܠܔ ܠܗܘܿܢ ܛܥܘܼܢܝܵܬܹ̈‌ܐ؛ ܐܣܝܼܩ ܠܗܘܿܢ ܘܓܘܼܪܘܸܣ ܠܗܘܿܢ ܘܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܕܬܠܵܬ‌ܝܼ، ܘܕܫܬ‌ܝܼ، ܘܕܡܵܐܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܡ̇ܢ ܕܐܝܼܬ ܠܹܗ ܢܵܬܝܵܬܹ̈‌ܐ ܠܸܫܡܵܥܵܐ، ܫܵܡܹܥ.“ ");
INSERT INTO aii_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ܐܝܼܡܲܢ ܕܝܼܗܘܵܐ ܒܢܲܦ̮ܫܹܗ، ܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ ܐܵܢܝܼ ܕܝܼܗܘܵܘ ܐܲܪ̈ܙܹܒܵܢܘܼܗ‌ܝ، ܥܲܡ ܬܪܸܥܣܲܪ ܬܲܠܡܝܼ̈ܕܹܐ، ܒܘܼܬ ܡܲܬܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܐܸܠܵܘܟ݂ܘܿܢ ܦܝܼܫܵܐ ܝܠܹܗ ܝܘܼܗܒ݂ܵܐ ܕܝܵܕܥܝܼܬܘܿܢ ܐܪܵܙܵܐ ܕܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ، ܐܝܼܢܵܐ ܠܐܵܢܝܼ ܕܝܼܢܵܐ ܠܒܲܕܲܪ ܟܠܵܝܗ‌ܝ ܐܲܢܹܐ ܟܹܐ ܦܵܝܫܝܼ ܐܡܝܼܪܹܐ ܒܡܲܬܠܹ̈ܐ، ");
INSERT INTO aii_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","”ܩܵܐ ܕܚܙܵܝܵܐ ܚܵܙܝܼ ܘܠܵܐ ܝܵܕܥܝܼ، ܘܫܡܵܥܵܐ ܫܵܡܥܝܼ ܘܠܵܐ ܦܲܪܡܝܼ، ܕܠܵܐ ܕܵܝܪܝܼ ܘܦܵܝܫܝܼ ܦܘܼܚܠܹܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܐܸܢ ܠܹܐ ܝܵܕܥܝܼܬܘܿܢ ܐܵܗܵܐ ܡܲܬܠܵܐ، ܕܵܐܟ݂ܝܼ ܒܸܬ ܝܵܕܥܝܼܬܘܿܢ ܟܠܵܝܗ‌ܝ ܡܲܬܠܹ̈ܐ ܐܚܹܪ̈ܢܹܐ؟ ");
INSERT INTO aii_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","”ܙܵܪܥܵܢܵܐ ܕܙܪܝܼܥ ܠܹܗ، ܗܹܡܸܙܡܵܢ ܙܪܝܼܥ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","”ܘܐܲܢܹܐ ܝܢܵܐ ܐܵܢܝܼ ܕܢܦܝܼܠܔ ܠܗܘܿܢ ܠܡܲܪܙܵܐ ܕܐܘܼܪܚܵܐ، ܐܲܝܟܵܐ ܕܦܵܝܫܵܐ ܙܪܝܼܥܬܵ‌ܐ ܗܹܡܸܙܡܵܢ. ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܗܘܿܢ ܠܗܹܡܸܙܡܵܢ، ܟܹܐ ܐܵܬܹ‌ܐ ܣܵܛܵܢܵܐ ܒܓ̰ܲܠܕܘܼܬܵ‌ܐ ܘܚܵܛܹܦ ܠܵܗ̇ ܡ̣ܢ ܠܸܒܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","”ܘܐܵܢܝܼ ܕܦܝܼܫ ܠܗܘܿܢ ܙܪܝܼܥܹܐ ܥܲܠܔ ܐܲܪܥܵܐ ܟܹܐܦܵܢܬܵ‌ܐ، ܐܵܢܝܼ ܝܢܵܐ ܐܝܼܡܲܢ ܫܡܝܼܥ ܠܗܘܿܢ ܠܗܹܡܸܙܡܵܢ، ܒܓ̰ܲܠܕܘܼܬܵ‌ܐ ܘܒܚܲܕܘܼܬܵ‌ܐ ܟܹܐ ܩܲܒܠܝܼ ܠܵܗ̇، ");
INSERT INTO aii_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","”ܐܝܼܢܵܐ ܠܲܝܬ ܠܗܘܿܢ ܥܸܩܪܵܐ ܒܓܵܢܵܝܗ‌ܝ، ܐܸܠܵܐ ܩܵܐ ܚܲܕ ܙܲܒ݂ܢܵܐ ܟܸܪܝܵܐ ܝܢܵܐ، ܘܐܝܼܡܲܢ ܕܟܹܐ ܗܵܘܹܐ ܐܘܼܠܨܵܢܵܐ ܝܲܢ ܪܕܘܼܦܝܵܐ ܒܘܼܬ ܗܹܡܸܙܡܵܢ، ܒܓ̰ܲܠܕܘܼܬܵ‌ܐ ܟܹܐ ܩܵܠܒܝܼ. ");
INSERT INTO aii_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","”ܐܝܼܢܵܐ ܐܵܢܝܼ ܕܦܝܼܫ ܠܗܘܿܢ ܙܪܝܼܥܹܐ ܓܵܘ ܟܸܬܘܹ̈ܐ، ܐܵܢܝܼ ܝܢܵܐ ܕܫܡܝܼܥ ܠܗܘܿܢ ܠܗܹܡܸܙܡܵܢ، ");
INSERT INTO aii_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","”ܐܝܼܢܵܐ ܪܸܢܝܵܐ ܕܐܵܗܵܐ ܕܘܼܢܝܹܐ ܘܡܲܚܠܸܛܵܢܘܼܬܵ‌ܐ ܕܕܵܘܸܠܬܵ‌ܐ، ܘܫܲܗܘܲܬܝܵܬܹ̈‌ܐ ܕܡܸܢܕܝܼܵܢܹ̈ܐ ܐܚܹܪ̈ܢܹܐ، ܟܹܐ ܐܵܬ‌ܝܼ ܘܚܵܢܩܝܼ ܠܵܗ̇ ܗܹܡܸܙܡܵܢ، ܘܟܹܐ ܗܵܘܝܵܐ ܕܠܵܐ ܛܥܘܼܢܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","”ܘܐܵܢܝܼ ܕܦܝܼܫ ܠܗܘܿܢ ܙܪܝܼܥܹܐ ܒܐܲܪܥܵܐ ܫܲܡܝܼܢܬܵ‌ܐ، ܐܲܢܹܐ ܝܢܵܐ ܕܟܹܐ ܫܵܡܥܝܼ ܗܹܡܸܙܡܵܢ ܘܩܲܒܠܝܼ ܠܵܗ̇ ܘܝܵܗܒ݂ܝܼ ܛܥܘܼܢܝܵܬܹ̈‌ܐ، ܒܬܠܵܬ‌ܝܼ، ܘܒܫܬ‌ܝܼ، ܘܒܡܵܐܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܟܹܐ ܗܵܘܝܵܐ ܡܲܠܗ‌ܝܼ ܫܪܵܓ݂ܵܐ ܘܡܲܬܒ݂ܝܼ ܠܵܗ̇ ܬܚܘܿܬ ܣܲܐܬܵ‌ܐ، ܝܲܢ ܬܚܘܿܬ ܫܘܝܼܬܵ‌ܐ؟ ܠܹܐ ܝܠܵܗ̇ ܕܡܲܬܒ݂ܝܼ ܠܵܗ̇ ܥܲܠܔ ܡܢܵܪܬܵ‌ܐ؟ ");
INSERT INTO aii_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","”ܣܵܒܵܒ ܠܲܝܬ ܡܸܢܕܝܼ ܛܸܫܝܵܐ ܕܠܵܐ ܦܵܐܹܫ ܓܸܠܝܵܐ، ܘܠܵܐ ܡܸܢܕܝܼ ܕܒܚܸܫܟܵܐ ܕܠܵܐ ܦܵܠܹܛ ܠܒܲܗܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","”ܡ̇ܢ ܕܐܝܼܬ ܠܹܗ ܢܵܬܝܵܬܹ̈‌ܐ ܠܸܫܡܵܥܵܐ، ܫܵܡܹܥ.“ ");
INSERT INTO aii_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܗܘܹܝܡܘܼܢ ܗܸܫܝܲܪ ܡܘܼܕܝܼ ܫܵܡܥܝܼܬܘܿܢ، ܣܵܒܵܒ ܒܟܝܘܼܠܵܐ ܕܟܵܝܠܝܼܬܘܿܢ ܒܸܬ ܦܵܐܹܫ ܟܝܼܠܵܐ ܐܸܠܵܘܟ݂ܘܿܢ، ܘܡܘܼܙܝܸܕܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","”ܣܵܒܵܒ ܡ̇ܢ ܕܐܝܼܬ ܠܹܗ ܒܸܬ ܦܵܐܹܫ ܝܘܼܗܒ݂ܵܐ ܐܸܠܹܗ، ܘܡ̇ܢ ܕܠܲܝܬ ܠܹܗ ܐܘܼܦ ܗ̇ܘ ܕܐܝܼܬ ܠܹܗ ܒܸܬ ܦܵܐܹܫ ܫܩܝܼܠܵܐ ܡܸܢܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܟܹܐ ܕܵܡܝܵܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܫܡܲܝܵܐ ܠܐܢܵܫܵܐ ܕܙܪܝܼܥ ܠܹܗ ܒܲܪܙܲܪܥܵܐ ܒܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","”ܘܕܡܝܼܟ݂ ܠܹܗ ܒܠܲܝܠܹܐ ܘܩܝܼܡ ܠܹܗ ܒܝܵܘܡܵܐ، ܘܒܲܪܙܲܪܥܵܐ ܡܲܓ̰ܝܘܼܢܹܐ ܘܓܲܪܘܘܼܣܹܐ، ܘܗ̇ܘ ܠܵܐ ܒܝܼܕܵܥܵܐ ܕܵܐܟ݂ܝܼ ܝܠܹܗ ܓܲܪܘܘܼܣܹܐ. ");
INSERT INTO aii_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","”ܣܵܒܵܒ ܐܲܪܥܵܐ ܒܓܵܢܘܼܗ̇ ܟܹܐ ܝܵܗܒ݂ܵܐ ܛܥܘܼܢܬܵ‌ܐ، ܩܲܕܡܵܝܬܵ‌ܐ ܒܘܼܠܵܐ، ܗ̇ܝܓܵܗ ܫܸܒܸܠܬܵ‌ܐ، ܘܒܚܲܪܬܵ‌ܐ ܚܸܛܝܼܬܵ‌ܐ ܡܠܝܼܬܵ‌ܐ ܓܵܘ ܫܸܒܸܠܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","”ܘܐܝܼܡܲܢ ܕܟܹܐ ܡܵܛܝܵܐ ܛܥܘܼܢܬܵ‌ܐ، ܟܹܐ ܕܵܪܹܐ ܡܲܓܠܵܐ ܓܵܘܘܼܗ̇ ܘܫܲܪܹܐ ܒܸܚܨܵܕܵܐ، ܣܵܒܵܒ ܡܛܹܐ ܠܹܗ ܚܸܨܕܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ: ”ܠܡܘܼܕܝܼ ܡܲܕܡܲܚ ܠܵܗ̇ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ؟ ܘܒܐܲܝܢܝܼ ܡܲܬܠܵܐ ܡܵܬܠܲܚ ܠܵܗ̇؟ ");
INSERT INTO aii_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","”ܟܹܐ ܕܵܡܝܵܐ ܠܕܲܢܕܸܟܬܵ‌ܐ ܕܚܲܪܕܲܠܔ، ܗ̇ܝ ܕܐܝܼܡܲܢ ܟܹܐ ܦܵܝܫܵܐ ܙܪܝܼܥܬܵ‌ܐ ܒܐܲܪܥܵܐ ܒܘܼܫ ܙܥܘܿܪܬܵ‌ܐ ܝܠܵܗ̇ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܒܲܪܙܲܪ̈ܥܹܐ ܕܥܲܠܔ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","”ܐܝܼܢܵܐ ܐܝܼܡܲܢ ܕܦܵܝܫܵܐ ܙܪܝܼܥܬܵ‌ܐ، ܟܹܐ ܓܲܪܘܸܣܵܐ ܘܗܵܘܝܵܐ ܒܘܼܫ ܓܘܼܪܬܵ‌ܐ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܝܲܪ̈ܩܹܐ، ܘܟܹܐ ܥܵܒ݂ܕܵܐ ܦܲܥܘܵܢܹ̈ܐ ܓܘܼܪܹ̈ܐ، ܗܵܕܟ݂ܵܐ ܕܡܵܨܝܼ ܛܲܝܪܹ̈ܐ ܕܫܡܲܝܵܐ ܫܵܪܝܼ ܬܚܘܿܬ ܛܸܠܵܢܝܼܬܘܼܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ܘܪܵܒܵܐ ܡܲܬܠܹ̈ܐ ܐܚܹܪ̈ܢܹܐ ܡܐܲܝܟ݂ ܐܲܢܹܐ ܗܘܼܡܙܸܡ ܠܹܗ ܝܼܫܘܿܥ ܥܲܡܵܝܗ‌ܝ، ܕܵܐܟ݂ܝܼ ܕܡܵܨܝܼ ܗܘܵܘ ܫܵܡܥܝܼ. ");
INSERT INTO aii_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ܕܠܵܐ ܡܲܬܠܹ̈ܐ ܠܹܐ ܗܲܡܙܸܡ ܗܘܵܐ ܥܲܡܵܝܗ‌ܝ. ܐܝܼܢܵܐ ܐܝܼܡܲܢ ܕܝܼܗܘܵܐ ܒܢܲܦ̮ܫܹܗ ܥܲܡ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ܟܹܐ ܦܲܫܸܩ ܗܘܵܐ ܟܠܔ ܡܸܢܕܝܼ. ");
INSERT INTO aii_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ܒܗ̇ܘ ܝܵܘܡܵܐ ܒܪܲܡܫܵܐ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܥܵܒ݂ܪܲܚ ܠܗ̇ܘ ܡܲܪܙܵܐ ܐܚܹܪܢܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ܘܫܒ݂ܝܼܩ ܠܗܘܿܢ ܠܟܸܢܫܹ̈ܐ ܘܠܘܼܒܸܠܔ ܠܗܘܿܢ ܐܸܠܹܗ ܒܓܵܡܝܼ، ܐܲܝܟ݂ ܕܝܼܗܘܵܐ. ܘܐܝܼܬ ܗܘܵܘ ܓܵܡܝܼܹ̈ܐ ܐܚܹܪ̈ܢܹܐ ܥܲܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ܘܩܝܼܡ ܠܹܗ ܦܵܘܚܵܐ ܪܵܒܵܐ ܚܲܝܠܵܢܵܐ، ܘܠܲܦܹ̈ܐ ܒܸܡܚܵܝܵܐ ܝܗܘܵܘ ܠܓܵܘ ܓܵܡܝܼ ܗܵܕܵܐ ܕܩܘܼܪܒܸܢܵܗ̇ ܠܸܡܠܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ܝܼܫܘܿܥ ܕܡܝܼܟ݂ܵܐ ܝܗܘܵܐ ܥܲܠܔ ܣܦܵܕܝܼܬܵ‌ܐ ܒܚܲܪܬܵ‌ܐ ܕܓܵܡܝܼ. ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܘܡܘܼܪܥܸܫ ܠܗܘܿܢ ܘܐܡܝܼܪܗܘܿܢ: ”ܪܲܒܝܼܲܢ، ܠܹܐ ܝܘܸܬ ܬܲܚܡܘܼܢܹܐ ܕܒܸܛܠܵܩܵܐ ܝܘܲܚ؟“ ");
INSERT INTO aii_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ܩܝܼܡ ܠܹܗ، ܘܢܓ̰ܝܼܘ ܠܹܗ ܒܦܵܘܚܵܐ ܘܐܡܝܼܪܹܗ ܠܝܵܡܵܐ، ”ܫܠܝܼ، ܫܬܘܿܩ.“ ܘܟܠܹܐ ܠܹܗ ܦܵܘܚܵܐ، ܘܗܘܹܐ ܠܹܗ ܢܝܵܚܵܐ ܓܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܩܵܡܘܿܕܝܼ ܗܵܕܟ݂ܵܐ ܙܵܕܘܿܥܹ̈ܐ ܝܬܘܿܢ؟ ܗܸܫ ܠܲܝܬ ܠܵܘܟ݂ܘܿܢ ܗܲܝܡܵܢܘܼܬܵ‌ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ܘܙܕܝܼܥ ܠܗܘܿܢ ܪܵܒܵܐ، ܘܐܡܝܼܪܗܘܿܢ ܚܲܕ ܠܗ̇ܘ ܐܚܹܪܢܵܐ: ”ܡܵܢܝܼ ܝܠܹܗ ܐܵܗܵܐ ܕܐܘܼܦ ܦܵܘܚܵܐ ܘܝܵܡܵܐ ܡܲܨܝܘܼܬܹ‌ܐ ܝܢܵܐ ܐܸܠܹܗ؟“ ");
INSERT INTO aii_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܠܡܲܪܙܵܐ ܐܚܹܪܢܵܐ ܕܝܵܡܵܐ ܠܐܲܬܪܵܐ ܕܓܸܕܪ̈ܵܝܹܐ. ");
INSERT INTO aii_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ܘܟܲܕ ܦܠܝܼܛ ܠܹܗ ܡ̣ܢ ܓܵܡܝܼ، ܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܬܦܝܼܩ ܠܹܗ ܒܝܼܹܗ ܚܲܕ ܐܢܵܫܵܐ ܒܸܦܠܵܛܵܐ ܡ̣ܢ ܒܹܝܬ ܩܒ݂ܘܼܪܹ̈ܐ، ܒܝܼܹܗ ܪܘܼܚܵܐ ܛܲܡܐܹܐ. ");
INSERT INTO aii_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ܘܟܹܐ ܥܵܡܹܪ ܗܘܵܐ ܓܵܘ ܒܹܝܬ ܩܒ݂ܘܼܪܹ̈ܐ، ܘܐܢܵܫܵܐ ܠܹܐ ܡܵܨܹܐ ܗܘܵܐ ܐܵܣܹܪ ܗܘܵܐ ܠܹܗ ܐܘܼܦ ܒܫܸܫܠܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ܣܵܒܵܒ ܪܵܒܵܐ ܓܵܗܹ̈ܐ ܒܩܵܘܕܹ̈ܐ ܘܒܫܸܫܠܵܬܹ̈‌ܐ ܟܹܐ ܦܵܐܹܫ ܗܘܵܐ ܐܣܝܼܪܵܐ، ܐܝܼܢܵܐ ܟܹܐ ܩܵܛܹܥ ܗܘܵܐ ܫܸܫܠܵܬܹ̈‌ܐ، ܘܩܵܘܕܹ̈ܐ ܬܵܒܹܪ ܗܘܵܐ ܠܗܘܿܢ، ܘܐܢܵܫܵܐ ܠܹܐ ܡܵܨܹܐ ܗܘܵܐ ܙܲܒܛܸܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ܒܟܠܔ ܥܕܵܢܵܐ، ܒܠܲܝܠܹܐ ܘܒܐܝܼܡܵܡܵܐ، ܟܹܐ ܗܵܘܹܐ ܗܘܵܐ ܓܵܘ ܛܘܼܪ̈ܵܢܹܐ ܘܓܵܘ ܒܹܝܬ ܩܒ݂ܘܼܪܹ̈ܐ، ܡܲܩܘܘܼܚܹܐ ܘܕܲܪܒܘܼܢܹܐ ܓܵܢܹܗ ܒܟܹܐܦܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ܐܝܼܢܵܐ ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܹܗ ܠܝܼܫܘܿܥ ܡ̣ܢ ܪܸܚܩܵܐ، ܪܚܝܼܛ ܠܹܗ ܠܟܸܣܠܹܗ ܘܒܪܝܼܟ ܠܹܗ ܩܲܕܡ ܐܲܩܠܵܬܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ܘܡܘܼܩܘܸܚ ܠܹܗ ܒܩܵܠܵܐ ܪܵܡܵܐ ܒܹܐܡܵܪܵܐ: ”ܡܵܐ ܠܘܼܟ݂ ܡܸܢܝܼ، ܝܼܫܘܿܥ ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ ܥܸܠܵܝܵܐ؟ ܡܲܡܘܼܝܘܼܟ݂ ܝܼܘܸܢ ܒܐܲܠܵܗܵܐ ܕܠܵܐ ܓ̰ܲܢܓ̰ܸܪܸܬ ܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ܣܵܒܵܒ ܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܦܠܘܿܛܝ ܡ̣ܢ ܐܢܵܫܵܐ، ܪܘܼܚܵܐ ܛܲܡܐܹܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ܘܒܘܼܩܸܪܹܗ ܡܸܢܹܗ ܝܼܫܘܿܥ: ”ܡܘܼܕܝܼ ܝܠܹܗ ܫܸܡܘܼܟ݂؟“ ܘܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ: ”ܫܸܡܝܼ ܠܸܓ݂ܝܘܿܢ ܝܼܠܹܗ، ܣܵܒܵܒ ܪܵܒܵܐ ܝܘܲܚ.“ ");
INSERT INTO aii_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ܘܦܘܼܪܦܸܠܔ ܠܹܗ ܒܝܼܹܗ ܪܵܒܵܐ ܕܠܵܐ ܫܲܕܸܪܗܘܿܢ ܠܒܲܕܲܪ ܡ̣ܢ ܐܲܬܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ܐܝܼܬ ܗܘܵܐ ܬܵܡܵܐ ܩܘܼܪܒܵܐ ܠܛܘܼܪܵܐ ܒܸܩܪܵܐ ܓܘܼܪܬܵ‌ܐ ܕܚܙܘܼܪܹ̈ܐ ܒܸܪܥܵܝܵܐ، ");
INSERT INTO aii_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ܘܦܘܼܪܦܸܠܔ ܠܗܘܿܢ ܒܝܼܹܗ ܐܵܢܝܼ ܫܹܐܕܹ̈ܐ ܒܹܐܡܵܪܵܐ: ”ܫܲܕܸܪܲܢ ܓܵܘ ܚܙܘܼܪܹ̈ܐ ܕܥܵܒ݂ܪܲܚ ܓܵܘܵܝܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܦܣܵܣܵܐ، ܘܦܠܝܼܛ ܠܗܘܿܢ ܐܵܢܝܼ ܪ̈ܘܼܚܹܐ ܛܲܡܐܹ̈ܐ ܘܥܒ݂ܝܼܪܗܘܿܢ ܓܵܘ ܚܙܘܼܪܹ̈ܐ، ܘܗ̇ܝ ܒܸܩܪܵܐ ܐܲܝܟ݂ ܬܪܹܝ ܐܲܠܦܹ̈ܐ ܚܙܘܼܪܹ̈ܐ ܪܚܝܼܛ ܠܵܗ̇ ܠܫܩܝܼܦܵܐ ܘܢܦܝܼܠܔ ܠܵܗ̇ ܓܵܘ ܝܵܡܵܐ، ܘܚܢܝܼܩ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ܐܵܢܝܼ ܕܡܲܪܥܘܼܝܹܐ ܝܗܘܵܘ ܠܚܙܘܼܪܹ̈ܐ ܥܪܝܼܩ ܠܗܘܿܢ ܘܗܘܼܩܹܐ ܠܗܘܿܢ ܓܵܘ ܡܕܝܼܢ݇ܬܵ‌ܐ ܘܓܵܘ ܡܵܬܘܵܬܹ̈‌ܐ. ܘܦܠܝܼܛ ܠܗܘܿܢ ܐܢܵܫܹ̈ܐ ܠܸܚܙܵܝܵܐ ܡܸܢܕܝܼ ܕܗܘܹܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣ ܝܼܫܘܿܥ، ܘܚܙܹܐ ܠܗܘܿܢ ܠܗ̇ܘ ܕܐܝܼܬ ܗܘܵܐ ܒܝܼܹܗ ܠܸܓ݂ܝܘܿܢ ܕܫܹܐܕܹ̈ܐ ܝܬܝܼܒ݂ܵܐ، ܘܠܒ݂ܝܼܫܵܐ ܘܗܵܘܢܹܗ ܒܪܹܝܫܹܗ، ܘܙܕܝܼܥ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ܘܐܵܢܝܼ ܕܚܙܹܐ ܠܗܘܿܢ ܗܘܼܩܹܐ ܠܗܘܿܢ ܠܐܢܵܫܹ̈ܐ ܡܘܼܕܝܼ ܗܘܹܐ ܠܹܗ ܠܗ̇ܘ ܕܐܝܼܬ ܗܘܵܐ ܒܝܼܹܗ ܫܹܐܕܹ̈ܐ ܘܐܘܼܦ ܠܚܙܘܼܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ܘܦܘܼܪܦܸܠܔ ܠܗܘܿܢ ܒܝܼܹܗ ܕܫܲܢܹܐ ܗܘܵܐ ܡ̣ܢ ܬܚܘܼܡܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ܘܟܲܕ ܐܣܝܼܩ ܠܹܗ ܝܼܫܘܿܥ ܠܓܵܡܝܼ، ܛܠܝܼܒ ܠܹܗ ܡܸܢܹܗ ܗ̇ܘ ܕܦܝܼܫ ܠܹܗ ܒܘܼܣܡܵܐ ܡ̣ܢ ܫܹܐܕܵܐ ܕܐܵܙܹܠܔ ܥܲܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܠܵܐ ܫܒ݂ܝܼܩ ܠܹܗ ܕܐܵܙܹܠܔ ܗܘܵܐ ܥܲܡܹܗ، ܐܸܠܵܐ ܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܙܹܠܔ݇ ܠܒܲܝܬܘܼܟ݂ ܠܟܸܣ ܐܢܵܫܘܼ̈ܟ݂ ܘܗܲܩܝܼ ܠܗܘܿܢ ܡܘܼܕܝܼ ܥܒ݂ܝܼܕ ܠܹܗ ܐܸܠܘܼܟ݂ ܡܵܪܝܵܐ، ܘܕܵܐܟ݂ܝܼ ܪܘܼܚܸܡ ܠܹܗ ܥܲܠܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ܘܐܙܝܼܠܔ ܠܹܗ ܗ̇ܘ ܐܢܵܫܵܐ، ܘܫܘܼܪܹܐ ܠܹܗ ܠܡܲܟܪܘܼܙܹܐ ܓܵܘ ܥܸܣܪܲܬ ܡܕܝܼܢܵܬܹ̈‌ܐ ܡܸܢܕܝܼ ܕܥܒ݂ܝܼܕ ܠܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ، ܘܟܠܵܝܗ‌ܝ ܐܢܵܫܹ̈ܐ ܥܲܓ̰ܒܝܼ ܗܘܵܘ. ");
INSERT INTO aii_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ܟܲܕ ܥܒ݂ܝܼܪܹܗ ܡܸܢܕܪܸܫ ܝܼܫܘܿܥ ܠܗ̇ܘ ܡܲܪܙܵܐ ܐܚܹܪܢܵܐ، ܓ̰ܡܝܼܥ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܟܸܢܫܹ̈ܐ ܪܵܒܵܐ، ܘܗ̇ܘ ܥܲܠܔ ܡܲܪܙܵܐ ܕܝܵܡܵܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ܘܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣܠܹܗ ܚܲܕ ܡ̣ܢ ܓܘܼܪ̈ܵܢܹܐ ܕܟܢܘܼܫܬܵ‌ܐ، ܫܸܡܹܗ ܝܘܿܐܵܪܵܫ، ܘܐܝܼܡܲܢ ܕܚܙܹܐ ܠܹܗ ܐܸܠܹܗ، ܢܦܝܼܠܔ ܠܹܗ ܩܲܕܡ ܐܲܩܠܵܬܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ܘܦܘܼܪܦܸܠܔ ܠܹܗ ܒܝܼܹܗ ܪܵܒܵܐ، ܒܹܐܡܵܪܵܐ ܐܸܠܹܗ: ”ܒܪܵܬ‌ܝܼ ܙܥܘܿܪܬܵ‌ܐ ܩܲܕܡ ܡܵܘܬܵ‌ܐ ܝܠܵܗ̇. ܬܵ‌ܐ ܘܡܲܬܸܒ݂ ܐܝܼܕܘܼܟ݂ ܥܲܠܘܼܗ̇ ܕܦܵܝܫܵܐ ܒܣܝܼܡܬܵ‌ܐ ܘܚܵܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ܐܙܝܼܠܔ ܠܹܗ ܥܲܡܹܗ ܝܼܫܘܿܥ، ܘܟܸܢܫܵܐ ܪܵܒܵܐ ܒܹܐܙܵܠܵܐ ܝܗܘܵܘ ܒܵܬܪܹܗ، ܘܒܸܚܠܵܨܵܐ ܝܗܘܵܐ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ܘܚܕܵܐ ܒܲܟ݂ܬܵ‌ܐ ܕܟܹܐ ܐܵܙܹܠܔ ܗܘܵܐ ܕܸܡܵܐ ܡܸܢܘܼܗ̇ ܩܵܐ ܬܪܸܥܣܲܪ ܫܸܢܹ̈ܐ، ");
INSERT INTO aii_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ܘܪܵܒܵܐ ܓ̰ܘܼܢܓ̰ܸܪܬܵ‌ܐ ܝܗܘܵܐ ܡ̣ܢ ܪܵܒܵܐ ܐܵܣܝܹ̈ܐ، ܘܚܘܼܪܸܓ̰ܬܵ‌ܐ ܝܗܘܵܐ ܟܠܔ ܡܸܢܕܝܼ ܕܐܝܼܬ ܗܘܵܐ ܠܵܗ̇، ܘܠܹܐ ܝܗܘܵܐ ܗܘܝܼܬܵ‌ܐ ܨܦܵܝܝܼ، ܐܸܠܵܐ ܒܘܼܫ ܚܸܪܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ܟܲܕ ܫܡܝܼܥ ܠܵܗ̇ ܒܘܼܬ ܝܼܫܘܿܥ، ܐܬܹ‌ܐ ܠܵܗ̇ ܡܓܵܘܵܐ ܕܟܸܢܫܵܐ ܡ̣ܢ ܒܵܬܪܹܗ، ܘܕܩܝܼܪܵܗ̇ ܒܠܒ݂ܝܼܫܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ܣܵܒܵܒ ܐܡܝܼܪܵܗ̇ ܒܓܵܢܘܼܗ̇: ”ܐܘܼܦ ܐܸܢ ܕܒܠܒ݂ܝܼܫܬܹܗ ܕܵܩܪܵܢ ܒܸܬ ܒܵܣܡܵܢ.“ ");
INSERT INTO aii_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܒܪܝܼܙ ܠܵܗ̇ ܥܲܝܢܵܐ ܕܕܸܡܘܼܗ̇، ܘܪܥܝܼܫ ܠܵܗ̇ ܒܦܲܓ݂ܪܘܼܗ̇ ܕܦܝܼܫ ܠܵܗ̇ ܒܣܝܼܡܬܵ‌ܐ ܡ̣ܢ ܡܲܪܥܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܝܼܫܘܿܥ ܝܕܝܼܥ ܠܹܗ ܒܓܵܢܹܗ ܕܚܲܝܠܵܐ ܦܠܝܼܛ ܠܹܗ ܡܸܢܹܗ، ܦܬܝܼܠܔ ܠܹܗ ܠܟܸܣ ܟܸܢܫܵܐ ܘܐܡܝܼܪܹܗ: ”ܡܵܢܝܼ ܕܩܝܼܪܹܗ ܒܠܒ݂ܝܼܫܬ‌ܝܼ؟“ ");
INSERT INTO aii_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܐܸܠܹܗ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܒܸܚܙܵܝܵܐ ܝܘܸܬ ܕܵܐܟ݂ܝܼ ܟܸܢܫܵܐ ܒܸܚܠܵܨܘܼܟ݂ ܝܼܠܹܗ، ܘܒܹܐܡܵܪܵܐ ܝܘܸܬ: ’ܡܵܢܝܼ ܕܩܝܼܪܹܗ ܒܝܼܝܼ؟‘“ ");
INSERT INTO aii_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ܘܒܸܚܝܵܪܵܐ ܠܚܵܕܸܪ̈ܘܵܢܘܼܗ‌ܝ ܕܚܵܙܹܐ ܡܵܢܝܼ ܕܩܝܼܪܹܗ ܒܝܼܹܗ، ");
INSERT INTO aii_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ܗ̇ܝ ܒܲܟ݂ܬܵ‌ܐ، ܒܸܙܕܵܥܵܐ ܘܪܲܬܪܘܼܬܹ‌ܐ، ܘܒܝܼܕܵܥܵܐ ܡܸܢܕܝܼ ܕܩܘܼܘܸܡ ܠܹܗ ܐܸܠܘܼܗ̇، ܐܬܹ‌ܐ ܠܵܗ̇ ܘܢܦܝܼܠܔ ܠܵܗ̇ ܩܲܕܡ ܐܲܩܠܵܬܘܼ̈ܗ‌ܝ، ܘܐܡܝܼܪܵܗ̇ ܐܸܠܹܗ ܟܠܹܗ ܫܪܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ܐܝܼܢܵܐ ܗ̇ܘ ܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇: ”ܒܪܵܬ‌ܝܼ، ܗܲܝܡܵܢܘܼܬܵܟ݂ܝ ܩܵܡ ܡܲܚܝܼܵܐ ܠܵܟ݂ܝ، ܙܹܠ݇ܝ ܒܫܠܵܡܵܐ، ܘܦܘܼܫܝ ܒܣܝܼܡܬܵ‌ܐ ܡ̣ܢ ܡܲܪܥܵܟ݂ܝ.“ ");
INSERT INTO aii_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ܘܟܲܕ ܗ̇ܘ ܗܲܡܙܘܼܡܹܐ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܐܢܵܫܹ̈ܐ ܡ̣ܢ ܒܲܝܬܵ‌ܐ ܕܓܘܼܪܵܐ ܕܟܢܘܼܫܬܵ‌ܐ ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܒܪܵܬܘܼܟ݂ ܡܝܼܬ ܠܵܗ̇، ܩܵܡܘܿܕܝܼ ܐܚܹܪܢܵܐ ܥܲܓ̰ܘܼܙܹܐ ܝܘܸܬ ܠܡܲܠܦܵܢܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ܐܝܼܢܵܐ ܟܲܕ ܝܼܫܘܿܥ ܫܡܝܼܥ ܠܹܗ ܡܘܼܕܝܼ ܗܘܼܡܙܸܡ ܠܗܘܿܢ، ܐܡܝܼܪܹܗ ܠܓܘܼܪܵܐ ܕܟܢܘܼܫܬܵ‌ܐ: ”ܠܵܐ ܙܵܕܥܹܬ، ܐܲܚܟ̰ܝܼ ܗܲܡܸܢ.“ ");
INSERT INTO aii_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ܘܠܵܐ ܫܒ݂ܝܼܩ ܠܹܗ ܠܐܢܵܫܵܐ ܕܐܵܙܹܠܔ ܗܘܵܐ ܥܲܡܹܗ ܫܒ݂ܘܿܩ ܡ̣ܢ ܟܹܐܦܵܐ ܘܝܲܥܩܘܿܒ݂ ܘܝܘܿܚܲܢܵܢ ܐܲܚܘܿܢܵܐ ܕܝܲܥܩܘܿܒ݂. ");
INSERT INTO aii_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܠܒܲܝܬܵ‌ܐ ܕܗ̇ܘ ܓܘܼܪܵܐ ܕܟܢܘܼܫܬܵ‌ܐ، ܘܚܙܹܐ ܠܹܗ ܫܓ݂ܘܼܫܝܵܐ، ܘܐܢܵܫܹ̈ܐ ܒܸܒܟ݂ܵܝܵܐ ܘܒܸܠܝܵܝܵܐ ܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ܘܥܒ݂ܝܼܪܹܗ ܝܼܫܘܿܥ ܠܒܲܝܬܵ‌ܐ، ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܩܵܡܘܿܕܝܼ ܫܓ݂ܝܼܫܹܐ ܝܬܘܿܢ ܘܒܸܒܟ݂ܵܝܵܐ؟ ܒܪܵܬܵ‌ܐ ܠܹܐ ܝܠܵܗ̇ ܡܝܼܬܬܵ‌ܐ، ܐܸܠܵܐ ܕܡܝܼܟ݂ܬܵ‌ܐ ܝܠܵܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ܘܓܚܝܼܟ ܠܗܘܿܢ ܒܝܼܹܗ. ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܦܘܼܠܸܛ ܠܹܗ ܠܟܠܵܝܗ‌ܝ، ܘܠܘܼܒܸܠܔ ܠܹܗ ܠܒܵܒܵܐ ܕܒܪܵܬܵ‌ܐ ܘܠܝܸܡܘܼܗ̇ ܘܠܐܵܢܝܼ ܕܥܲܡܹܗ ܝܗܘܵܘ، ܘܥܒ݂ܝܼܪܹܗ ܠܐܲܝܟܵܐ ܕܝܼܗܘܵܐ ܒܪܵܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ܕܒ݂ܝܼܩ ܠܹܗ ܒܐܝܼܕܵܐ ܕܒܪܵܬܵ‌ܐ ܘܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇: ”ܛܠܝܼܬܵ‌ܐ ܩܘܼܡܝ،“ ܕܦܝܵܫܵܐ ܝܠܹܗ ܦܘܼܫܩܵܐ: ”ܒܪܵܬܵ‌ܐ، ܐܸܠܵܟ݂ܝ ܒܹܐܡܵܪܵܐ ܝܘܸܢ، ܩܘܼܡܝ.“ ");
INSERT INTO aii_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܩܝܼܡ ܠܵܗ̇ ܒܪܵܬܵ‌ܐ ܘܚܕܝܼܪܵܗ̇، ܘܗ̇ܝ ܒܲܪܬ ܬܪܸܥܣܲܪ ܫܸܢܹ̈ܐ ܝܗܘܵܐ، ܘܟܠܵܝܗ‌ܝ ܥܘܼܓ̰ܸܒ ܠܗܘܿܢ ܥܘܼܓ̰ܵܒܵܐ ܓܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ܘܦܩܝܼܕ ܠܹܗ ܩܸܘܝܵܐ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ ܕܐܘܼܦ ܚܲܕ ܠܵܐ ܝܵܕܹܥ ܐܵܗܵܐ. ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܕܝܵܗܒ݂ܝܼ ܠܵܗ̇ ܡܸܢܕܝܼ ܠܹܐܟ݂ܵܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ܦܠܝܼܛ ܠܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܬܵܡܵܐ ܘܐܬܹ‌ܐ ܠܹܗ ܠܡܕܝܼܢ݇ܬܹܗ، ܘܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܐܙܝܼܠܔ ܠܗܘܿܢ ܒܵܬܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ܘܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ ܫܘܼܪܹܐ ܠܹܗ ܠܡܲܠܘܼܦܹܐ ܓܵܘ ܟܢܘܼܫܬܵ‌ܐ، ܘܪܵܒܵܐ ܡܸܢܵܝܗ‌ܝ ܕܫܡܝܼܥ ܠܗܘܿܢ ܥܲܓ̰ܒܝܼ ܗܘܵܘ، ܘܐܵܡܪܝܼ ܗܘܵܘ: ”ܡ̣ܢ ܐܲܝܟܵܐ ܐܝܼܬ ܠܹܗ ܐܲܢܹܐ، ܘܡܘܼܕܝܼ ܚܸܟ݂ܡܬܵ‌ܐ ܦܝܼܫܬܵ‌ܐ ܝܠܵܗ̇ ܝܘܼܗܒܹܠܬܵ‌ܐ ܐܸܠܹܗ ܕܗܵܕܟ݂ܵܐ ܚܲܝ̈ܠܹܐ ܓܘܼܪܹ̈ܐ ܒܐܝܼܕܘܼ̈ܗ‌ܝ ܒܹܗܘܵܝܵܐ ܝܢܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","”ܠܹܐ ܝܠܹܗ ܐܵܗܵܐ ܢܲܓܵܪܵܐ ܒܪܘܿܢܵܐ ܕܡܲܪܝܲܡ، ܘܐܲܚܘܿܢܵܐ ܕܝܲܥܩܘܿܒ݂ ܘܕܝܘܿܣܹܐ ܘܕܝܼܗܘܼܕܵܐ ܘܕܫܸܡܥܘܿܢ؟ ܘܠܹܐ ܝܢܵܐ ܚܵܬܘܵܬܘܼ̈ܗ‌ܝ ܠܲܐܟ݂ܵܐ ܠܟܸܣܠܲܢ؟“ ܘܬܲܪܩܸܠܝܼ ܗܘܵܘ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܠܲܝܬ ܢܒ݂ܝܼܵܐ ܕܠܵܐ ܐܝܼܩܵܪܵܐ ܐܸܠܵܐ ܓܵܘ ܡܕܝܼܢ݇ܬܵ‌ܐ ܕܓܵܢܹܗ، ܘܓܵܘ ܚܸܙܡܵܢܘܼ̈ܗ‌ܝ ܘܓܵܘ ܒܲܝܬܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ܘܠܵܐ ܡܨܹܐ ܠܹܗ ܥܵܒܹܕ ܗܘܵܐ ܬܵܡܵܐ ܐܘܼܦ ܚܲܕ ܚܲܝܠܵܐ، ܐܸܠܵܐ ܡܘܼܬܸܒ݂ ܠܹܗ ܐܝܼܕܹܗ ܥܲܠܔ ܚܲܕܟܡܵܐ ܡܪ̈ܝܼܥܹܐ ܘܒܘܼܣܡܵܝ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ܘܥܘܼܓ̰ܸܒ ܠܹܗ ܒܠܲܝܬܵܝܘܼܬܵ‌ܐ ܕܗܲܝܡܵܢܘܼܬܵܝܗ‌ܝ. ܘܒܸܚܕܵܪܵܐ ܝܗܘܵܐ ܓܵܘ ܡܵܬܘܵܬܹ̈‌ܐ ܕܚܵܕܸܪ̈ܘܵܢܹܐ ܟܲܕ ܡܲܠܘܼܦܹܐ. ");
INSERT INTO aii_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ܘܩܪܹܐ ܠܹܗ ܠܬܪܸܥܣܲܪ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܫܘܼܠܛܵܢܵܐ ܥܲܠܔ ܪ̈ܘܼܚܵܬܹ‌ܐ ܛܲܡܐܹ̈ܐ، ܘܫܘܼܕܪܵܝ ܠܹܗ ܬܪܹܝ ܬܪܹܝ. ");
INSERT INTO aii_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ܘܦܩܝܼܕܵܝ ܠܹܗ ܕܠܵܐ ܫܵܩܠܝܼ ܡܸܢܕܝܼ ܩܵܐ ܐܘܼܪܚܵܐ ܐܸܠܵܐ ܚܘܼܛܪܵܐ، ܠܵܐ ܬܲܪܡܵܠܵܐ، ܘܠܵܐ ܠܲܚܡܵܐ، ܘܠܵܐ ܙܘܼܙܵܐ ܒܟܸܣܝܵܬܵܝ̈ܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ܐܸܠܵܐ ܕܠܵܒ݂ܫܝܼ ܟ̰ܵܪ̈ܘܿܚܹܐ، ܘܠܵܐ ܠܵܒ݂ܫܝܼ ܬܲܪܬܹܝ ܨܘܼܕܪ̈ܵܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܠܐܲܝܢܝܼ ܒܲܝܬܵ‌ܐ ܕܥܵܒ݂ܪܝܼܬܘܿܢ، ܬܵܡܵܐ ܗܘܹܝܡܘܼܢ ܗܲܠܔ ܕܦܵܠܛܝܼܬܘܿܢ ܡ̣ܢ ܗ̇ܝ ܕܘܼܟܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","”ܘܡ̇ܢ ܕܠܵܐ ܩܲܒܸܠܔ ܠܵܘܟ݂ܘܿܢ ܘܠܵܐ ܫܵܡܹܥ ܐܸܠܵܘܟ݂ܘܿܢ، ܢܦܘܿܨܘܼܢ ܠܥܲܦܪܵܐ ܡ̣ܢ ܐܲܩܠܵܬܵܘ̈ܟ݂ܘܿܢ ܠܣܵܗܕܘܼܬܵܝܗ‌ܝ ܐܝܼܡܲܢ ܕܦܵܠܛܝܼܬܘܿܢ ܡ̣ܢ ܬܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ܘܦܠܝܼܛ ܠܗܘܿܢ ܘܡܘܼܟܪܸܙ ܠܗܘܿܢ ܬܝܵܒ݂ܘܼܬܵ‌ܐ ܠܐܢܵܫܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ܪܵܒܵܐ ܫܹܐܕܹ̈ܐ ܦܘܼܠܸܛ ܠܗܘܿܢ، ܘܪܵܒܵܐ ܡܪ̈ܝܼܥܹܐ ܡܫܝܼܚ ܠܗܘܿܢ ܒܡܸܫܚܵܐ، ܘܒܘܼܣܡܵܝ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ܟܲܕ ܫܡܝܼܥ ܠܹܗ ܗܹܪܘܿܕܸܣ ܡܲܠܟܵܐ ܒܘܼܬ ܝܼܫܘܿܥ، ܣܵܒܵܒ ܦܪܝܼܣܵܐ ܝܗܘܵܐ ܫܸܡܹܗ، ܐܡܝܼܪܹܗ: ”ܐܵܗܵܐ ܝܘܿܚܲܢܵܢ ܡܲܥܡܕܵܢܵܐ ܝܠܹܗ، ܩܝܼܡܵܐ ܡ̣ܢ ܓܵܘ ܡܝܼ̈ܬܹ‌ܐ. ܒܘܼܬ ܐܵܗܵܐ ܚܲܝ̈ܠܹܐ ܓܘܼܪܹ̈ܐ ܦܝܵܫܵܐ ܝܢܵܐ ܥܒ݂ܝܼܕܹܐ ܒܝܼܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ܐܝܼܢܵܐ ܐܚܹܪ̈ܢܹܐ ܐܵܡܪܝܼ ܗܘܵܘ ܕܐܹܠܝܼܵܐ ܝܠܹܗ، ܘܐܚܹܪ̈ܢܹܐ ܕܢܒ݂ܝܼܵܐ ܝܠܹܗ، ܡܐܲܝܟ݂ ܚܲܕ ܡ̣ܢ ܢܒ݂ܝܼܹ̈ܐ ܩܲܕܡܵܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ܐܝܼܢܵܐ ܟܲܕ ܫܡܝܼܥ ܠܹܗ ܗܹܪܘܿܕܸܣ ܐܡܝܼܪܹܗ: ”ܐܵܗܵܐ ܝܘܿܚܲܢܵܢ ܝܼܠܹܗ، ܗ̇ܘ ܕܐܵܢܵܐ ܦܪܝܼܡ ܠܝܼ ܪܹܝܫܹܗ، ܩܝܼܡܵܐ ܝܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ܣܵܒܵܒ ܗܹܪܘܿܕܸܣ ܒܓܵܢܹܗ ܫܘܼܕܪܵܐ ܝܗܘܵܐ ܘܕܒ݂ܝܼܩܹܗ ܝܘܿܚܲܢܵܢ ܘܕܸܪܝܹܗ ܓܵܘ ܒܹܝܬ ܐܲܣܝܼܪܹ̈ܐ ܒܘܼܬ ܗܹܪܘܿܕܝܼܵܐ ܒܲܟ݂ܬܵ‌ܐ ܕܦܝܼܠܝܼܦܘܿܣ ܐܲܚܘܿܢܘܼܗ‌ܝ، ܕܓܒ݂ܝܼܪܘܼܗ̇ ܝܗܘܵܐ ܗܹܪܘܿܕܸܣ. ");
INSERT INTO aii_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ܣܵܒܵܒ ܟܹܐ ܐܵܡܹܪ ܗܘܵܐ ܝܘܿܚܲܢܵܢ ܠܗܹܪܘܿܕܸܣ: ”ܠܹܐ ܝܠܵܗ̇ ܩܵܢܘܿܢܵܝܬܵ‌ܐ ܐܸܠܘܼܟ݂ ܕܓܵܒ݂ܪܹܬ ܒܲܟ݂ܬܵ‌ܐ ܕܐܲܚܘܿܢܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ܘܗܹܪܘܿܕܝܼܵܐ ܕܒ݂ܝܼܩܬܵ‌ܐ ܝܗܘܵܐ ܟܲܪܒܵܐ ܒܠܸܒܘܼܗ̇ ܐܸܠܹܗ، ܘܒܵܥܝܵܐ ܗܘܵܐ ܕܩܵܛܠܵܐ ܗܘܵܐ ܠܹܗ، ܐܝܼܢܵܐ ܠܹܐ ܡܵܨܝܵܐ ܗܘܵܐ، ");
INSERT INTO aii_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ܣܵܒܵܒ ܗܹܪܘܿܕܸܣ ܟܹܐ ܙܵܕܹܥ ܗܘܵܐ ܡ̣ܢ ܝܘܿܚܲܢܵܢ، ܒܗ̇ܝ ܕܟܹܐ ܝܵܕܹܥ ܗܘܵܐ ܕܐܢܵܫܵܐ ܟܹܐܢܵܐ ܘܩܲܕܝܼܫܵܐ ܝܗܘܵܐ، ܘܟܹܐ ܢܵܛܹܪ ܗܘܵܐ ܠܹܗ. ܘܟܲܕ ܫܵܡܹܥ ܗܘܵܐ ܠܹܗ، ܠܹܐ ܝܵܕܹܥ ܗܘܵܐ ܡܘܼܕܝܼ ܥܵܒܹܕ ܗܘܵܐ، ܐܝܼܢܵܐ ܒܚܲܕܘܼܬܵ‌ܐ ܟܹܐ ܫܵܡܹܥ ܗܘܵܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ܐܝܼܢܵܐ ܡܛܹܐ ܠܵܗ̇ ܥܕܵܢܵܐ ܠܵܚܘܿܡܬܵ‌ܐ ܒܝܵܘܡܵܐ ܕܒܹܝܬ ܝܲܠܕܵܐ ܕܗܹܪܘܿܕܸܣ ܐܝܼܡܲܢ ܕܥܒ݂ܝܼܕ ܠܹܗ ܗܹܪܘܿܕܸܣ ܡܸܫܬܘܼܬܵ‌ܐ ܠܓܘܼܪ̈ܵܢܘܼܗ‌ܝ ܘܠܪ̈ܲܒܲܝ ܐܲܠܦܹ̈ܐ ܕܚܲܝܠܵܘܵܬܹ̈‌ܐ ܘܠܓܘܼܪ̈ܵܢܹܐ ܕܓܠܝܼܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ܘܥܒ݂ܝܼܪܵܗ̇ ܒܪܵܬܵ‌ܐ ܕܗܹܪܘܿܕܝܼܵܐ ܘܪܩܝܼܕ ܠܵܗ̇، ܘܫܦܝܼܪܵܗ̇ ܠܗܹܪܘܿܕܸܣ ܘܠܐܵܢܝܼ ܕܝܬܝܼܒܹܐ ܝܗܘܵܘ ܥܲܡܹܗ. ܘܐܡܝܼܪܹܗ ܡܲܠܟܵܐ ܠܒܪܵܬܵ‌ܐ: ”ܛܠܘܿܒ ܡܸܢܝܼ ܡܸܢܕܝܼ ܕܒܵܣܡܵܐ ܠܵܟ݂ܝ، ܘܐܵܢܵܐ ܒܸܬ ܝܵܗܒܹܢܵܟ݂ܝ.“ ");
INSERT INTO aii_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ܘܝܡܹܐ ܠܹܗ ܐܸܠܘܼܗ̇: ”ܡܸܢܕܝܼ ܕܛܵܠܒܲܬ‌ܝ ܡܸܢܝܼ ܒܸܬ ܝܵܗܒܹܢܵܟ݂ܝ، ܗܲܠܔ ܦܲܠܓܵܐ ܕܡܲܠܟܘܼܬ‌ܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ܘܗ̇ܝ ܦܠܝܼܛ ܠܵܗ̇ ܘܒܘܼܩܸܪܵܗ̇ ܡ̣ܢ ܝܸܡܘܼܗ̇: ”ܡܘܼܕܝܼ ܛܵܠܒܵܢ؟“ ܘܐܡܝܼܪܵܗ̇ ܐܸܠܘܼܗ̇ ܝܸܡܘܼܗ̇: ”ܛܠܘܿܒܝ ܪܹܝܫܵܐ ܕܝܘܿܚܲܢܵܢ ܡܲܥܡܕܵܢܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܐܬܹ‌ܐ ܠܵܗ̇ ܒܓ̰ܲܠܕܘܼܬܵ‌ܐ ܠܟܸܣ ܡܲܠܟܵܐ ܘܛܠܝܼܒ ܠܵܗ̇ ܒܹܐܡܵܪܵܐ: ”ܒܵܥܝܵܢ ܐܵܕܝܼܵܐ ܕܝܵܗܒܹܬ ܠܝܼ ܓܵܘ ܡܵܐܢܵܐ ܪܹܝܫܵܐ ܕܝܘܿܚܲܢܵܢ ܡܲܥܡܕܵܢܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ܦܫܝܼܡ ܠܹܗ ܡܲܠܟܵܐ ܪܵܒܵܐ، ܐܝܼܢܵܐ ܒܘܼܬ ܡܵܘܡܵܬܹ̈‌ܐ ܕܝܡܹܐ ܠܹܗ ܘܒܘܼܬ ܐܵܢܝܼ ܕܝܬܝܼܒܹܐ ܝܗܘܵܘ ܥܲܡܹܗ ܠܣܘܼܦܪܵܐ، ܠܵܐ ܒܥܹܐ ܠܹܗ ܕܡܲܚܦܸܠܔ ܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܫܘܼܕܸܪܹܗ ܢܵܛܘܿܪܵܐ ܘܦܩܝܼܕ ܠܹܗ ܐܸܠܹܗ ܕܡܲܝܬܹ‌ܐ ܗܘܵܐ ܠܪܹܝܫܵܐ ܕܝܘܿܚܲܢܵܢ. ܐܙܝܼܠܔ ܠܹܗ ܗ̇ܘ ܘܦܪܝܼܡ ܠܹܗ ܪܹܝܫܵܐ ܕܝܘܿܚܲܢܵܢ ܓܵܘ ܒܹܝܬ ܐܲܣܝܼܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ܘܡܘܼܝܬܹ‌ܐ ܠܹܗ ܪܹܝܫܹܗ ܓܵܘ ܡܵܐܢܵܐ ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܠܒܪܵܬܵ‌ܐ، ܘܗ̇ܝ ܝܘܼܗܒܹܠܔ ܠܵܗ̇ ܠܝܸܡܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ܘܫܡܝܼܥ ܠܗܘܿܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܘܫܩܝܼܠܔ ܠܗܘܿܢ ܠܫܠܲܕܹܗ ܘܡܘܼܬܒ݂ܵܐ ܠܗܘܿܢ ܓܵܘ ܒܹܝܬ ܩܒ݂ܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ܘܓ̰ܡܝܼܥ ܠܗܘܿܢ ܫܠܝܼܚܹ̈ܐ ܠܟܸܣ ܝܼܫܘܿܥ ܘܡܘܼܕܸܥ ܠܗܘܿܢ ܐܸܠܹܗ ܟܠܔ ܡܸܢܕܝܼ ܕܥܒ݂ܝܼܕ ܠܗܘܿܢ ܘܡܘܼܠܸܦ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ܘܗ̇ܘ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܬܹܝܡܘܼܢ ܐܵܙܲܠ݇ܚ ܠܚܕܵܐ ܕܘܼܟܵܐ ܓܵܘ ܒܲܪܝܼܵܐ ܒܢܲܦ̮ܫܲܢ ܘܡܲܢܝܸܚܘܼܢ ܚܲܕܟ̰ܵܐ،“ ܣܵܒܵܒ ܐܝܼܬ ܗܘܵܘ ܪܵܒܵܐ ܒܹܐܙܵܠܵܐ ܘܒܹܐܬܵܝܵܐ، ܘܠܲܝܬ ܗܘܵܘ ܠܗܘܿܢ ܥܕܵܢܵܐ ܐܘܼܦ ܠܹܐܟ݂ܵܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܒܓܵܡܝܼ ܠܕܘܼܟܵܐ ܡܘܼܫܲܡܸܪ ܒܢܲܦ̮ܫܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ܘܚܸܙܝܵܝ ܠܗܘܿܢ ܪܵܒܵܐ ܐܢܵܫܹ̈ܐ ܟܲܕ ܒܹܐܙܵܠܵܐ، ܝܕܝܼܥܵܝ ܠܗܘܿܢ، ܘܪܚܝܼܛ ܠܗܘܿܢ ܠܬܵܡܵܐ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܡܕܝܼܢܵܬܹ̈‌ܐ، ܘܡܛܹܐ ܠܗܘܿܢ ܡ̣ܢ ܩܲܕܡ ܕܝܼܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ܘܦܠܝܼܛ ܠܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܓܵܡܝܼ ܘܚܙܹܐ ܠܹܗ ܠܟܸܢܫܵܐ ܓܘܼܪܵܐ ܘܪܘܼܚܸܡ ܠܹܗ ܥܲܠܵܝܗ‌ܝ، ܣܵܒܵܒ ܒܸܕܡܵܝܵܐ ܝܗܘܵܘ ܠܥܸܪ̈ܒܹܐ ܕܠܵܐ ܪܵܥܝܵܐ. ܘܫܘܼܪܹܐ ܠܹܗ ܠܡܲܠܘܼܦܵܝ ܪܵܒܵܐ ܡܸܢܕܝܼܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ܟܲܕ ܩܘܼܪܒܸܢܹܗ ܝܵܘܡܵܐ ܠܸܓܢܵܝܵܐ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܕܘܼܟܵܐ ܒܲܪܝܼܵܐ ܝܠܵܗ̇، ܘܥܕܵܢܵܐ ܥܒ݂ܝܼܪܬܵ‌ܐ ܝܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ܫܪܝܼ ܠܟܸܢܫܵܐ ܕܐܵܙܠ݇ܝܼ ܠܙܘܼܡܵܢܹ̈ܐ ܕܚܵܕܸܪ̈ܘܵܢܹܐ ܘܠܡܵܬܘܵܬܹ̈‌ܐ ܘܙܵܒ݂ܢܝܼ ܠܗܘܿܢ ܡܸܢܕܝܼ ܠܹܐܟ݂ܵܠܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ܐܝܼܢܵܐ ܗ̇ܘ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܗܲܒ݂ܠܘܼܢ ܐܲܚܬܘܿܢ ܐܸܠܵܝܗ‌ܝ ܡܸܢܕܝܼ ܠܹܐܟ݂ܵܠܵܐ.“ ܘܐܵܢܝܼ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ: ”ܐܵܙܲܠ݇ܚ ܘܙܵܒ݂ܢܲܚ ܒܬܪܲܝܡܵܐܐ ܕܝܼܢܵܪܹ̈ܐ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ ܘܝܵܗܒܲܚ ܠܗܘܿܢ ܕܐܵܟ݂ܠܝܼ؟“ ");
INSERT INTO aii_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܙܹܠ݇ܡܘܼܢ ܘܚܙܹܝܡܘܼܢ ܟܡܵܐ ܠܲܚܡܹ̈ܐ ܐܝܼܬ ܠܵܘܟ݂ܘܿܢ.“ ܘܐܝܼܡܲܢ ܕܚܙܹܐ ܠܗܘܿܢ، ܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܐܝܼܬ ܠܲܢ ܚܲܡܫܵܐ ܠܲܚܡܹ̈ܐ ܘܬܪܹܝ ܢܘܼܢܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ܦܩܝܼܕܵܝ ܠܹܗ ܝܼܫܘܿܥ ܕܡܲܬܒ݂ܝܼ ܠܐܢܵܫܹ̈ܐ ܒܣܝܼܥܵܬܹ̈‌ܐ ܥܲܠܔ ܓܸܠܵܐ ܩܝܼܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ܘܝܬܝܼܒ݂ ܠܗܘܿܢ ܒܣܝܼܥܵܬܹ̈‌ܐ ܕܡܵܐܐ ܡܵܐܐ، ܘܕܚܲܡܫܝܼ ܚܲܡܫܝܼ. ");
INSERT INTO aii_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ܘܫܩܝܼܠܔ ܠܹܗ ܐܵܢܝܼ ܚܲܡܫܵܐ ܠܲܚܡܹ̈ܐ ܘܬܪܹܝ ܢܘܼܢܹ̈ܐ، ܘܚܝܼܪܹܗ ܒܫܡܲܝܵܐ، ܒܘܼܪܸܟ݂ ܠܹܗ، ܘܩܨܹܐ ܠܹܗ ܠܲܚܡܹ̈ܐ، ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܕܡܲܬܒ݂ܝܼ ܩܲܕܡ ܟܸܢܫܵܐ. ܘܐܘܼܦ ܠܐܵܢܝܼ ܬܪܹܝ ܢܘܼܢܹ̈ܐ، ܦܠܝܼܥܵܝ ܠܹܗ ܠܟܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ܐܟ݂ܝܼܠܔ ܠܗܘܿܢ ܟܠܵܝܗ‌ܝ ܘܣܒ݂ܝܼܥ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ܘܫܩܝܼܠܔ ܠܗܘܿܢ ܬܪܸܥܣܲܪ ܩܘܼܦܹ̈ܐ ܡܸܠܝܹܐ ܡ̣ܢ ܩܸܛܥܵܛܹ̈ܐ ܕܠܲܚܡܵܐ ܘܕܢܘܼܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ܘܐܵܢܝܼ ܕܐܟ݂ܝܼܠܔ ܠܗܘܿܢ ܠܲܚܡܹ̈ܐ ܚܲܡܫܵܐ ܐܲܠܦܹ̈ܐ ܓܲܒ݂ܪܹ̈ܐ ܝܗܘܵܘ. ");
INSERT INTO aii_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܡܘܼܥܒܸܕ ܠܹܗ ܝܼܫܘܿܥ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܕܐܵܣܩܝܼ ܗܘܵܘ ܠܓܵܡܝܼ ܘܐܵܙܠ݇ܝܼ ܗܘܵܘ ܡ̣ܢ ܩܲܕܡ ܕܝܼܹܗ ܠܗ̇ܘ ܡܲܪܙܵܐ ܐܚܹܪܢܵܐ ܠܒܹܝܬ ܨܲܝܵܕܵܐ، ܟܲܕ ܗ̇ܘ ܡܲܦܫܸܛ ܗܘܵܐ ܠܟܸܢܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ܘܐܝܼܡܲܢ ܕܫܘܼܕܪܵܝ ܠܹܗ، ܐܙܝܼܠܔ ܠܹܗ ܠܛܘܼܪܵܐ ܠܨܲܠܘܼܝܹܐ. ");
INSERT INTO aii_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ܟܲܕ ܗܘܹܐ ܠܹܗ ܪܲܡܫܵܐ، ܓܵܡܝܼ ܒܹܝܦܲܠܓܵܐ ܕܝܵܡܵܐ ܝܗܘܵܐ، ܘܗ̇ܘ ܒܢܲܦ̮ܫܹܗ ܥܲܠܔ ܒܸܪܙܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ܘܚܸܙܝܵܝ ܠܹܗ ܝܼܫܘܿܥ ܓ̰ܲܢܓ̰ܘܼܪܹܐ ܒܛܪܵܝܬܵ‌ܐ ܕܓܵܡܝܼ ܣܵܒܵܒ ܦܵܘܚܵܐ ܒܲܠܩܘܼܒ݂ܠܵܝܗ‌ܝ ܝܗܘܵܐ. ܘܒܒܲܕܠܵܐ ܕܐܲܪܒܥܵܐ ܕܠܲܝܠܹܐ، ܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣܠܵܝܗ‌ܝ ܒܸܚܕܵܪܵܐ ܥܲܠܔ ܝܵܡܵܐ ܘܒܥܹܐ ܠܹܗ ܕܥܵܒܹܪ ܗܘܵܐ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ܘܐܝܼܡܲܢ ܕܐܵܢܝܼ ܚܙܹܐ ܠܗܘܿܢ ܐܸܠܹܗ ܒܸܚܕܵܪܵܐ ܥܲܠܔ ܝܵܡܵܐ، ܚܫܝܼܒ݂ ܠܗܘܿܢ ܕܚܸܙܘܵܐ ܝܗܘܵܐ، ܘܡܘܼܩܘܸܚ ܠܗܘܿܢ، ");
INSERT INTO aii_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ܣܵܒܵܒ ܟܠܵܝܗ‌ܝ ܚܙܹܐ ܠܗܘܿܢ ܐܸܠܹܗ، ܘܙܕܝܼܥ ܠܗܘܿܢ. ܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܗܘܼܡܙܸܡ ܠܹܗ ܥܲܡܵܝܗ‌ܝ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܗܘܹܝܡܘܼܢ ܠܸܒܵܢܹ̈ܐ، ܐܵܢܵܐ ܝܘܸܢ، ܠܵܐ ܙܵܕܥܝܼܬܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ܘܐܣܝܼܩ ܠܹܗ ܓܵܘ ܓܵܡܝܼ ܠܟܸܣܠܵܝܗ‌ܝ، ܘܫܠܹܐ ܠܹܗ ܦܵܘܚܵܐ، ܘܥܘܼܓ̰ܸܒ ܠܗܘܿܢ ܒܓܵܢܵܝܗ‌ܝ ܪܵܒܵܐ، ");
INSERT INTO aii_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ܣܵܒܵܒ ܠܵܐ ܦܘܼܪܡܹܐ ܠܗܘܿܢ ܡ̣ܢ ܐܵܢܝܼ ܠܲܚܡܹ̈ܐ، ܒܗ̇ܝ ܕܩܸܫܝܵܐ ܝܗܘܵܐ ܠܸܒܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ܘܟܲܕ ܥܒ݂ܝܼܪܗܘܿܢ ܠܡܲܪܙܵܐ ܐܚܹܪܢܵܐ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܐܲܪܥܵܐ ܕܓܹܢܹܣܲܪ، ܘܓܪܝܼܫ ܠܗܘܿܢ ܠܡܲܪܙܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ܘܐܝܼܡܲܢ ܕܦܠܝܼܛ ܠܗܘܿܢ ܡ̣ܢ ܓܵܡܝܼ، ܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܝܕܝܼܥ ܠܗܘܿܢ ܐܸܠܹܗ ܐܢܵܫܹ̈ܐ، ");
INSERT INTO aii_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ܘܪܚܝܼܛ ܠܗܘܿܢ ܒܟܠܹܗ ܗ̇ܘ ܐܲܬܪܵܐ، ܘܫܘܼܪܹܐ ܠܗܘܿܢ ܠܡܲܝܬܘܼܝܹܐ ܠܡܲܪ̈ܥܵܢܹܐ ܥܲܠܔ ܫܘܝܼܵܬܹ̈‌ܐ، ܟܠܔ ܐܲܝܟܵܐ ܕܫܵܡܥܝܼ ܗܘܵܘ ܕܬܵܡܵܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ܘܐܲܝܟܵܐ ܕܥܵܒܹܪ ܗܘܵܐ، ܓܵܘ ܡܵܬܘܵܬܹ̈‌ܐ، ܝܲܢ ܓܵܘ ܡܕܝܼܢܵܬܹ̈‌ܐ، ܝܲܢ ܓܵܘ ܙܘܼܡܵܢܹ̈ܐ، ܟܹܐ ܡܲܬܒ݂ܝܼ ܗܘܵܘ ܡܪ̈ܝܼܥܹܐ ܓܵܘ ܫܘܼܩܹ̈ܐ، ܘܦܲܪܦܸܠܝܼ ܗܘܵܘ ܒܝܼܹܗ ܕܕܵܩܪܝܼ ܐܘܼܦ ܐܸܢ ܕܗܵܘܝܵܐ ܒܫܸܦܘܼܠܵܐ ܕܠܒ݂ܝܼܫܬܹܗ. ܘܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܕܵܩܪܝܼ ܗܘܵܘ ܟܹܐ ܦܵܝܫܝܼ ܗܘܵܘ ܒܣܝܼܡܹܐ. ");
INSERT INTO aii_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ܗ̇ܝܓܵܗ ܓ̰ܡܝܼܥ ܠܗܘܿܢ ܠܟܸܣ ܝܼܫܘܿܥ ܦܪ̈ܝܼܫܹܐ ܘܚܲܕܟܡܵܐ ܣܵܦܪܹ̈ܐ ܕܐܬܹ‌ܐ ܠܗܘܿܢ ܡ̣ܢ ܐܘܿܪܸܫܠܸܡ. ");
INSERT INTO aii_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ܘܚܙܹܐ ܠܗܘܿܢ ܕܚܲܕܟܡܵܐ ܡ̣ܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܒܹܐܟ݂ܵܠܵܐ ܠܲܚܡܵܐ ܒܐܝܼܕܵܬܹ̈‌ܐ ܛܲܡܐܹ̈ܐ، ܠܵܐ ܚܘܼܠܸܠܹܐ، ");
INSERT INTO aii_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ܣܵܒܵܒ ܦܪ̈ܝܼܫܹܐ ܘܟܠܵܝܗ‌ܝ ܝܗܘܼܕܵܝܹ̈ܐ ܐܸܢ ܒܛܝܼܠܵܐܝܼܬ ܠܵܐ ܚܲܠܸܠܝܼ ܐܝܼܕܵܬܵܝ̈ܗ‌ܝ ܠܹܐ ܐܵܟ݂ܠܝܼ، ܗܵܕܟ݂ܵܐ ܟܹܐ ܗܵܘܝܼ ܒܸܢܛܵܪܵܐ ܠܣܲܦܝܵܢܘܼܬܵ‌ܐ ܕܚܘܵܪ̈ܕܸܩܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ܘܐܝܼܡܲܢ ܕܐܵܬ‌ܝܼ ܡ̣ܢ ܫܘܼܩܵܐ، ܐܸܢ ܠܵܐ ܚܲܠܸܠܝܼ ܠܹܐ ܐܵܟ݂ܠܝܼ. ܘܪܵܒܵܐ ܣܲܦܝܵܢܘܼܝܵܬܹ̈‌ܐ ܐܚܹܪ̈ܢܹܐ ܩܘܼܒܸܠܔ ܠܗܘܿܢ ܕܢܵܛܪܝܼ، ܐܲܝܟ݂ ܚܲܠܲܠܬܵ‌ܐ ܕܟܵܣܹ̈ܐ، ܘܬܲܠܸܡܝܵܬܹ̈‌ܐ، ܘܡܵܐܢܹ̈ܐ ܕܢܚܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ ܣܵܦܪܹ̈ܐ ܘܦܪ̈ܝܼܫܹܐ: ”ܩܵܡܘܿܕܝܼ ܬܲܠܡܝܼܕܘܼ̈ܟ݂ ܠܹܐ ܝܢܵܐ ܒܸܥܒ݂ܵܕܵܐ ܐܲܝܟ݂ ܣܲܦܝܵܢܘܼܬܵ‌ܐ ܕܚܘܵܪ̈ܕܸܩܢܹܐ، ܐܸܠܵܐ ܒܹܐܟ݂ܵܠܵܐ ܝܢܵܐ ܠܲܚܡܵܐ ܒܐܝܼܕܵܬܹ̈‌ܐ ܠܵܐ ܚܘܼܠܸܠܹܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܝܵܐ ܡܲܫܦܸܪ̈ܵܢܹܐ، ܨܦܵܝܝܼ ܢܘܼܒܹܐ ܠܹܗ ܒܘܼܬ ܕܝܼܵܘܟ݂ܘܿܢ ܐܹܫܲܥܝܵܐ، ܐܲܝܟ݂ ܕܝܼܠܹܗ ܟܬܝܼܒ݂ܵܐ: ܐܵܗܵܐ ܥܲܡܵܐ ܟܹܐ ܡܝܲܩܸܪ ܐܸܠܝܼ ܒܣܸܦܘܵܬܘܼ̈ܗ‌ܝ، ܐܝܼܢܵܐ ܠܸܒܵܝܗ‌ܝ ܪܸܚܩܵܐ ܝܠܹܗ ܡܸܢܝܼ، ");
INSERT INTO aii_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ܘܣܪܝܼܩܵܐܝܼܬ ܒܸܣܓ݂ܵܕܵܐ ܝܢܵܐ ܐܸܠܝܼ، ܟܲܕ ܡܲܠܘܼܦܹܐ ܦܘܼܩܕܵܢܹ̈ܐ ܕܒܢܲܝ̈ܢܵܫܵܐ ܐܲܝܟ݂ ܡܲܠܦܵܢܘܼܝܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","”ܣܵܒܵܒ ܫܒ݂ܝܼܩ ܠܵܘܟ݂ܘܿܢ ܦܘܼܩܕܵܢܹ̈ܐ ܕܐܲܠܵܗܵܐ ܘܕܒ݂ܝܼܩ ܠܵܘܟ݂ܘܿܢ ܒܣܲܦܝܵܢܘܼܬܵ‌ܐ ܕܒܢܲܝ̈ܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","”ܘܒܹܐܡܵܪܵܐ ܝܗܘܵܐ ܐܸܠܵܝܗ‌ܝ: ܨܦܵܝܝܼ ܟܹܐ ܒܲܛܠܝܼܬܘܿܢ ܦܘܼܩܕܵܢܹ̈ܐ ܕܐܲܠܵܗܵܐ ܠܡܲܩܘܼܡܹܐ ܣܲܦܝܵܢܘܼܬܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","”ܣܵܒܵܒ ܡܘܼܫܹܐ ܐܡܝܼܪܹܗ: ’ܡܝܲܩܸܪ ܠܒܵܒܘܼܟ݂ ܘܠܝܸܡܘܼܟ݂،‘ ܘܐܘܼܦ ܐܡܝܼܪܹܗ: ’ܡ̇ܢ ܕܨܲܥܸܪ ܠܒܵܒܵܐ ܝܲܢ ܠܝܸܡܵܐ، ܡܵܘܬܵ‌ܐ ܡܵܐܹܬ.‘ ");
INSERT INTO aii_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","”ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ ܟܹܐ ܐܵܡܪܝܼܬܘܿܢ: ’ܐܸܢ ܐܢܵܫܵܐ ܐܵܡܹܪ ܠܒܵܒܘܼܗ‌ܝ ܝܲܢ ܠܝܸܡܹܗ، ܡܸܢܕܝܼ ܕܗܵܘܹܐ ܡܸܢܝܼ ܡܵܘܬܪܵܢܵܐ ܐܸܠܘܼܟ݂، ܩܘܼܪܒܵܢ ܝܼܠܹܗ، ܦܘܼܫܵܩܹܗ، ܡܵܘܗܲܒ݂ܬܵ‌ܐ ܠܐܲܠܵܗܵܐ، ");
INSERT INTO aii_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","”ܐܚܹܪܢܵܐ ܠܹܐ ܫܵܒ݂ܩܝܼܬܘܿܢ ܕܥܵܒܹܕ ܡܸܢܕܝܼ ܠܒܵܒܘܼܗ‌ܝ ܝܲܢ ܠܝܸܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","”ܒܲܛܘܼܠܹܐ ܝܬܘܿܢ ܗܹܡܸܙܡܵܢ ܕܐܲܠܵܗܵܐ ܒܝܲܕ ܣܲܦܝܵܢܘܼܬܵ‌ܐ ܕܣܘܼܦܹܐ ܠܵܘܟ݂ܘܿܢ.‘ ܘܪܵܒܵܐ ܡܸܢܕܝܼܵܢܹ̈ܐ ܐܚܹܪ̈ܢܹܐ ܐܲܝܟ݂ ܐܲܢܹܐ ܟܹܐ ܥܵܒ݂ܕܝܼܬܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ܗ̇ܝܓܵܗ ܩܪܹܐ ܠܹܗ ܝܼܫܘܿܥ ܠܟܠܹܗ ܟܸܢܫܵܐ ܠܟܸܣܠܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܫܡܹܥܡܘܼܢ ܐܸܠܝܼ ܟܠܵܘܟ݂ܘܿܢ ܘܦܲܪܡܹܝܡܘܼܢ، ");
INSERT INTO aii_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","”ܠܲܝܬ ܡܸܢܕܝܼ ܠܒܲܕܲܪ ܡ̣ܢ ܒܲܪܢܵܫܵܐ ܕܥܵܒܹܪ ܓܵܘ ܦܲܓ݂ܪܹܗ ܘܡܵܨܹܐ ܟ̰ܲܦܠܸܢ ܐܸܠܹܗ، ܐܸܠܵܐ ܡܸܢܕܝܼ ܕܦܵܠܹܛ ܡܸܢܹܗ، ܗ̇ܘ ܟܹܐ ܟ̰ܲܦܠܸܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","”ܡ̇ܢ ܕܐܝܼܬ ܠܹܗ ܢܵܬܝܵܬܹ̈‌ܐ ܠܸܫܡܵܥܵܐ، ܫܵܡܹܥ.“ ");
INSERT INTO aii_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ܘܐܝܼܡܲܢ ܕܥܒ݂ܝܼܪܹܗ ܝܼܫܘܿܥ ܠܒܲܝܬܵ‌ܐ ܡ̣ܢ ܠܟܸܣ ܟܸܢܫܵܐ، ܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܒܘܼܬ ܡܲܬܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܐܘܼܦ ܐܲܚܬܘܿܢ ܠܹܐ ܝܬܘܿܢ ܦܲܪܡܘܼܝܹܐ، ܠܹܐ ܝܵܕܥܝܼܬܘܿܢ ܕܟܠܔ ܡܸܢܕܝܼ ܕܡ̣ܢ ܠܒܲܕܲܪ ܥܵܒܹܪ ܓܵܘ ܦܲܓ݂ܪܵܐ ܕܒܲܪܢܵܫܵܐ ܠܹܐ ܡܵܨܹܐ ܟ̰ܲܦܠܸܢܹܗ، ");
INSERT INTO aii_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","”ܣܵܒܵܒ ܠܹܐ ܥܵܒܹܪ ܓܵܘ ܠܸܒܹܗ، ܐܸܠܵܐ ܓܵܘ ܟܹܪ݇ܣܹܗ، ܘܟܹܐ ܦܵܠܹܛ ܠܒܲܕܲܪ ܡ̣ܢ ܦܲܓ݂ܪܹܗ؟ (ܗܵܕܟ݂ܵܐ ܥܒ݂ܝܼܕܵܝ ܠܹܗ ܕܸܟ݂ܝܹܐ ܟܠܵܝܗ‌ܝ ܡܹܐܟ݂ܘܼܠܝܵܬܹ̈‌ܐ.) ");
INSERT INTO aii_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","”ܐܝܼܢܵܐ ܡܸܢܕܝܼ ܕܦܵܠܹܛ ܡ̣ܢ ܒܲܪܢܵܫܵܐ، ܗ̇ܘ ܟܹܐ ܟ̰ܲܦܠܸܢ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","”ܣܵܒܵܒ ܡ̣ܢ ܓܵܘ ܠܸܒܵܐ ܕܒܢܲܝ̈ܢܵܫܵܐ ܟܹܐ ܦܵܠܛܝܼ ܚܘܼܫܵܒܹ̈ܐ ܒܝܼܫܹ̈ܐ: ܓܲܝܵܪܘܼܬܵ‌ܐ، ܙܵܢܝܘܼܬܵ‌ܐ، ܓܹܢܵܒ݂ܘܼܬܵ‌ܐ، ܩܸܛܠܵܐ، ");
INSERT INTO aii_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","”ܛܲܡܲܥܟܵܪܘܼܬܵ‌ܐ، ܒܝܼܫܘܼܬܵ‌ܐ، ܥܲܠܕܲܝܬܵ‌ܐ، ܫܪܝܼܚܘܼܬܵ‌ܐ، ܥܲܝܢܵܐ ܒܝܼܫܬܵ‌ܐ، ܓܘܼܕܵܦܵܐ، ܫܲܒ݂ܗܸܪܵܢܘܼܬܵ‌ܐ، ܣܲܟ݂ܠܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","”ܟܠܵܝܗ‌ܝ ܐܲܢܹܐ ܒܝܼܫܵܬܹ̈‌ܐ ܟܹܐ ܦܵܠܛܝܼ ܡ̣ܢ ܓܵܘܵܐ ܘܟ̰ܲܦܠܸܢܝܼ ܠܒܲܪܢܵܫܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ܘܩܝܼܡ ܠܹܗ ܡ̣ܢ ܬܵܡܵܐ ܝܼܫܘܿܥ ܘܐܙܝܼܠܔ ܠܹܗ ܠܬܚܘܼܡܵܐ ܕܨܘܿܪ ܘܨܲܝܕܘܿܢ. ܘܥܒ݂ܝܼܪܹܗ ܠܚܲܕ ܒܲܝܬܵ‌ܐ، ܘܠܹܐ ܒܵܥܹܐ ܗܘܵܐ ܕܐܘܼܦ ܚܲܕ ܝܵܕܹܥ ܗܘܵܐ، ܐܝܼܢܵܐ ܠܵܐ ܡܨܹܐ ܠܹܗ ܦܵܐܹܫ ܗܘܵܐ ܛܸܫܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ܐܝܼܢܵܐ ܚܕܵܐ ܒܲܟ݂ܬܵ‌ܐ ܕܐܝܼܬ ܗܘܵܐ ܠܵܗ̇ ܒܪܵܬܵ‌ܐ ܙܥܘܿܪܬܵ‌ܐ ܒܝܼܘܼܗ̇ ܪܘܼܚܵܐ ܛܲܡܐܹܐ، ܟܲܕ ܫܡܝܼܥ ܠܵܗ̇ ܒܘܼܬ ܕܝܼܹܗ، ܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܐܬܹ‌ܐ ܠܵܗ̇ ܘܢܦܝܼܠܔ ܠܵܗ̇ ܩܲܕܡ ܐܲܩܠܵܬܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ܘܗ̇ܝ ܒܲܟ݂ܬܵ‌ܐ ܢܘܼܟ݂ܪܵܝܬܵ‌ܐ ܝܗܘܵܐ، ܡ̣ܢ ܒܢܲܝ̈ ܦܹܘܢܝܼܩܹܐ ܕܣܘܼܪܝܼܵܐ. ܘܦܲܪܦܘܼܠܹܐ ܝܗܘܵܐ ܒܝܼܹܗ ܕܦܲܠܸܛ ܗܘܵܐ ܫܹܐܕܵܐ ܡ̣ܢ ܒܪܵܬܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇: ”ܫܒ݂ܘܿܩܝ ܩܲܕܡܵܝܬܵ‌ܐ ܕܣܵܒ݂ܥܝܼ ܒܢܘܿܢܹ̈ܐ، ܣܵܒܵܒ ܠܹܐ ܝܠܵܗ̇ ܨܦܵܝܝܼ ܠܸܫܩܵܠܵܐ ܠܲܚܡܵܐ ܕܒܢܘܿܢܹ̈ܐ ܘܠܸܕܪܵܝܹܗ ܩܲܕܡ ܟܲܠܒܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ܐܝܼܢܵܐ ܗ̇ܝ ܓ̰ܘܼܘܸܒ ܠܵܗ̇ ܘܐܡܝܼܪܵܗ̇ ܐܸܠܹܗ: ”ܗܹܐ ܡܵܪܝܼ، ܐܝܼܢܵܐ ܐܘܼܦ ܟܲܠܒܹ̈ܐ ܟܹܐ ܐܵܟ݂ܠܝܼ ܡ̣ܢ ܦܸܪ̈ܬܘܼܚܹܐ ܕܢܵܦܠܝܼ ܡ̣ܢ ܦܵܬܘܿܪܹ̈ܐ ܕܒܢܘܿܢܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇ ܝܼܫܘܿܥ: ”ܣܵܒܵܒ ܐܡܝܼܪܵܟ݂ܝ ܗܵܕܟ݂ܵܐ، ܙܹܠ݇ܝ، ܦܠܝܼܛ ܠܹܗ ܫܹܐܕܵܐ ܡ̣ܢ ܒܪܵܬܵܟ݂ܝ.“ ");
INSERT INTO aii_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ܘܟܲܕ ܐܙܝܼܠܔ ܠܵܗ̇ ܒܲܟ݂ܬܵ‌ܐ ܠܒܲܝܬܘܼܗ̇، ܚܙܹܐ ܠܵܗ̇ ܒܪܵܬܘܼܗ̇ ܥܲܠܔ ܫܘܝܼܬܵ‌ܐ، ܘܫܹܐܕܵܐ ܦܠܝܼܛܵܐ ܡܸܢܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ܘܦܠܝܼܛ ܠܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܬܚܘܼܡܵܐ ܕܨܘܿܪ، ܘܐܬܹ‌ܐ ܠܹܗ ܡ̣ܢ ܓܵܘܵܐ ܕܨܲܝܕܘܿܢ ܠܝܵܡܵܐ ܕܓܠܝܼܠܵܐ، ܓܵܘ ܬܚܘܼܡܵܐ ܕܥܸܣܪܲܬ ܡܕܝܼܢܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ܘܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܚܲܕ ܕܝܼܗܘܵܐ ܚܲܪܫܵܐ ܘܦܸܠܬܸܟ، ܘܛܠܝܼܒ ܠܗܘܿܢ ܡܸܢܹܗ ܕܡܲܬܸܒ݂ ܗܘܵܐ ܥܲܠܘܼܗ‌ܝ ܐܝܼܕܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ܘܦܘܼܠܸܛ ܠܹܗ ܠܒܲܕܲܪ ܡ̣ܢ ܟܸܢܫܵܐ ܒܢܲܦ̮ܫܹܗ، ܡܘܼܬܸܒ݂ ܠܹܗ ܨܸܒܥܵܬܘܼ̈ܗ‌ܝ ܒܢܵܬܝܵܬܘܼ̈ܗ‌ܝ، ܘܒܵܬܪ ܕܪܝܼܩ ܠܹܗ، ܕܩܝܼܪܹܗ ܒܠܸܫܵܢܹܗ، ");
INSERT INTO aii_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ܘܚܝܼܪܹܗ ܒܫܡܲܝܵܐ، ܬܘܼܢܸܚ ܠܹܗ ܘܐܡܝܼܪܹܗ: ”ܐܸܬ݂ܦܲܬܲܚ،“ ܕܝܼܠܵܗ̇ ”ܦܘܼܫ ܦܬܝܼܚܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܦܝܼܫ ܠܗܘܿܢ ܦܬܝܼܚܹܐ ܢܵܬܝܵܬܘܼ̈ܗ‌ܝ، ܘܦܝܼܫ ܠܹܗ ܫܸܪܝܵܐ ܐܸܣܘܼܪܵܐ ܕܠܸܫܵܢܹܗ، ܘܗܘܼܡܙܸܡ ܠܹܗ ܒܨܸܦܝܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ܘܦܩܝܼܕ ܠܹܗ ܝܼܫܘܿܥ ܠܐܢܵܫܹ̈ܐ ܕܠܵܐ ܡܲܕܥܝܼ ܠܐܘܼܦ ܚܲܕ ܒܘܼܬ ܐܵܗܵܐ. ܐܝܼܢܵܐ ܟܡܵܐ ܕܗ̇ܘ ܦܵܩܹܕ ܗܘܵܐ ܠܗܘܿܢ ܐܵܢܝܼ ܒܘܼܫ ܙܵܘܕܵܐ ܡܲܚܒܸܪܝܼ ܗܘܵܘ. ");
INSERT INTO aii_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ܪܵܒܵܐ ܙܵܘܕܵܐ ܥܲܓ̰ܒܝܼ ܗܘܵܘ ܒܹܐܡܵܪܵܐ: ”ܟܠܔ ܡܸܢܕܝܼ ܛܵܒ݂ܵܐ ܒܸܥܒ݂ܵܕܵܐ ܝܠܹܗ، ܚܲܪ̈ܫܹܐ ܒܸܥܒ݂ܵܕܵܐ ܝܠܹܗ ܕܫܵܡܥܝܼ، ܘܠܲܥܠܹ̈ܐ ܕܗܲܡܙܸܡܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ܒܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ ܡܸܢܕܪܸܫ ܟܸܢܫܵܐ ܪܵܒܵܐ ܝܗܘܵܐ، ܘܠܲܝܬ ܗܘܵܐ ܠܗܘܿܢ ܡܸܢܕܝܼ ܠܹܐܟ݂ܵܠܵܐ. ܩܪܹܐ ܠܹܗ ܝܼܫܘܿܥ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ");
INSERT INTO aii_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","”ܪܲܚܘܼܡܹܐ ܝܘܸܢ ܥܲܠܔ ܐܵܗܵܐ ܟܸܢܫܵܐ، ܣܵܒܵܒ ܐܲܢܹܐ ܬܠܵܬܵ‌ܐ ܝܵܘܡܵܢܹ̈ܐ ܥܘܼܪܩܸܠܔ ܠܗܘܿܢ ܠܟܸܣܠܝܼ، ܘܠܲܝܬ ܠܗܘܿܢ ܡܸܢܕܝܼ ܕܐܵܟ݂ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","”ܐܸܢ ܫܲܕܪܸܢܗܘܿܢ ܟܦܝܼܢܹܐ ܠܒܵܬܵܝ̈ܗ‌ܝ، ܒܸܬ ܫܲܡܫܸܡܝܼ ܒܐܘܼܪܚܵܐ، ܘܚܲܕܟܡܵܐ ܡܸܢܵܝܗ‌ܝ ܡ̣ܢ ܕܘܼܟܵܢܹ̈ܐ ܪܸܚܩܵܐ ܐܬܝܼܹܐ ܝܢܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ܘܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܐܸܠܹܗ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܡ̣ܢ ܐܲܝܟܵܐ ܡܵܨܹܐ ܐܢܵܫܵܐ ܠܲܐܟ݂ܵܐ ܓܵܘ ܒܲܪܝܼܵܐ ܡܲܣܒܸܥ ܒܠܲܚܡܵܐ ܠܟܠܵܝܗ‌ܝ ܐܲܢܹܐ ܐܢܵܫܹ̈ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܟܡܵܐ ܠܲܚܡܹ̈ܐ ܐܝܼܬ ܠܵܘܟ݂ܘܿܢ؟“ ܘܐܵܢܝܼ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ: ”ܫܲܒ݂ܥܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ܘܦܩܝܼܕ ܠܹܗ ܠܟܸܢܫܵܐ ܠܸܬܝܵܒ݂ܵܐ ܥܲܠܔ ܐܲܪܥܵܐ. ܘܫܩܝܼܠܔ ܠܹܗ ܠܐܵܢܝܼ ܫܲܒ݂ܥܵܐ ܠܲܚܡܹ̈ܐ، ܘܒܘܼܪܸܟ݂ ܠܹܗ ܘܩܨܹܐ ܠܹܗ ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ܕܡܲܬܒ݂ܝܼ ܗܘܵܘ. ܘܐܵܢܝܼ ܡܘܼܬܸܒ݂ ܠܗܘܿܢ ܩܲܕܡ ܟܸܢܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ܘܐܝܼܬ ܗܘܵܘ ܠܗܘܿܢ ܚܲܕܟܡܵܐ ܢܘܼܢܹ̈ܐ ܙܥܘܿܪܹ̈ܐ. ܐܘܼܦ ܐܵܢܝܼ ܒܘܼܪܟ݂ܵܝ ܠܹܗ، ܘܦܩܝܼܕ ܠܹܗ ܕܡܲܬܒ݂ܝܼ ܗܘܵܘ ܠܗܘܿܢ ܩܲܕܡ ܟܸܢܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ܐܟ݂ܝܼܠܔ ܠܗܘܿܢ ܘܣܒ݂ܝܼܥ ܠܗܘܿܢ، ܘܫܩܝܼܠܔ ܠܗܘܿܢ ܩܸܛܥܵܛܹ̈ܐ ܕܙܝܼܕ ܠܗܘܿܢ، ܫܲܒ݂ܥܵܐ ܩܘܼܦܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ܘܐܵܢܝܼ ܕܐܟ݂ܝܼܠܔ ܠܗܘܿܢ ܡܐܲܝܟ݂ ܐܲܪܒܥܵܐ ܐܲܠܦܹ̈ܐ ܝܗܘܵܘ. ܘܫܘܼܕܪܵܝ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ܗ̇ܝܓܵܗ ܐܣܝܼܩ ܠܹܗ ܝܼܫܘܿܥ ܠܓܵܡܝܼ ܥܲܡ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܐܬܹ‌ܐ ܠܹܗ ܠܐܲܬܪܵܐ ܕܕܲܠܡܵܢܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܦܪ̈ܝܼܫܹܐ ܠܟܸܣܠܹܗ ܕܓ̰ܲܪܒܝܼ ܗܘܵܘ ܠܹܗ. ܫܘܼܪܹܐ ܠܗܘܿܢ ܒܸܕܪܵܫܵܐ ܥܲܡܹܗ، ܘܛܠܝܼܒ ܠܗܘܿܢ ܡܸܢܹܗ ܕܡܲܚܙܹܐ ܗܘܵܐ ܠܗܘܿܢ ܢܝܼܫܲܢܩܵܐ ܡ̣ܢ ܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ܐܝܼܢܵܐ ܗ̇ܘ ܬܘܼܢܸܚ ܠܹܗ ܒܪܘܼܚܹܗ ܘܐܡܝܼܪܹܗ: ”ܩܵܡܘܿܕܝܼ ܒܸܛܠܵܒܵܐ ܝܠܵܗ̇ ܢܝܼܫܲܢܩܵܐ ܐܵܗܵܐ ܫܲܪܒܬܵ‌ܐ؟ ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܠܹܐ ܦܵܐܹܫ ܝܘܼܗܒ݂ܵܐ ܢܝܼܫܲܢܩܵܐ ܠܐܵܗܵܐ ܫܲܪܒܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ܘܫܒ݂ܝܼܩܵܝ ܠܹܗ ܘܐܣܝܼܩ ܠܹܗ ܠܓܵܡܝܼ ܡܸܢܕܪܸܫ، ܘܐܙܝܼܠܔ ܠܹܗ ܠܗ̇ܘ ܡܲܪܙܵܐ ܐܚܹܪܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ܡܘܼܢܫܹܐ ܠܗܘܿܢ ܬܲܠܡܝܼ̈ܕܹܐ ܕܫܵܩܠܝܼ ܗܘܵܘ ܥܲܡܵܝܗ‌ܝ ܠܲܚܡܵܐ، ܘܐܘܼܦ ܓܵܘ ܓܵܡܝܼ ܠܲܝܬ ܗܘܵܘ ܠܗܘܿܢ ܠܲܚܡܵܐ ܫܒ݂ܘܿܩ ܡ̣ܢ ܚܕܵܐ ܓܸܪܕܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܚܙܹܝܡܘܼܢ، ܗܘܹܝܡܘܼܢ ܗܸܫܝܲܪ ܡ̣ܢ ܚܡܝܼܪܵܐ ܕܦܪ̈ܝܼܫܹܐ ܘܕܗܹܪܘܿܕܸܣ.“ ");
INSERT INTO aii_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ܐܝܼܢܵܐ ܐܵܢܝܼ ܚܫܝܼܒ݂ ܠܗܘܿܢ ܒܓܵܢܵܝܗ‌ܝ ܕܐܡܝܼܪܹܗ ܐܵܗܵܐ ܣܵܒܵܒ ܠܹܐ ܝܗܘܵܘ ܫܩܝܼܠܹܐ ܥܲܡܵܝܗ‌ܝ ܠܲܚܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܝܕܝܼܥ ܠܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܩܵܡܘܿܕܝܼ ܒܸܚܫܵܒ݂ܵܐ ܝܬܘܿܢ ܒܓܵܢܵܘܟ݂ܘܿܢ ܕܠܲܚܡܵܐ ܠܲܝܬ ܠܵܘܟ݂ܘܿܢ؟ ܗܸܫ ܠܹܐ ܝܬܘܿܢ ܒܝܼܕܵܥܵܐ ܘܠܹܐ ܝܬܘܿܢ ܦܲܪܡܘܼܝܹܐ، ܗܸܫ ܠܸܒܵܘܟ݂ܘܿܢ ܩܸܫܝܵܐ ܝܠܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","”ܐܝܼܬ ܠܵܘܟ݂ܘܿܢ ܥܲܝ̈ܢܹܐ ܘܠܹܐ ܝܬܘܿܢ ܒܸܚܙܵܝܵܐ، ܐܝܼܬ ܠܵܘܟ݂ܘܿܢ ܢܵܬܝܵܬܹ̈‌ܐ ܘܠܹܐ ܝܬܘܿܢ ܒܸܫܡܵܥܵܐ. ܠܹܐ ܝܬܘܿܢ ܒܸܕܟ݂ܵܪܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","”ܐܝܼܡܲܢ ܕܩܨܹܐ ܠܝܼ ܐܵܢܝܼ ܚܲܡܫܵܐ ܠܲܚܡܹ̈ܐ ܩܵܐ ܚܲܡܫܵܐ ܐܲܠܦܹ̈ܐ، ܟܡܵܐ ܩܘܼܦܹ̈ܐ ܕܩܸܛܥܵܛܹ̈ܐ ܡܸܠܝܹܐ ܫܩܝܼܠܔ ܠܵܘܟ݂ܘܿܢ؟“ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ: ”ܬܪܸܥܣܲܪ.“ ");
INSERT INTO aii_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","”ܘܐܵܢܝܼ ܫܲܒ݂ܥܵܐ ܠܲܚܡܹ̈ܐ ܩܵܐ ܐܲܪܒܥܵܐ ܐܲܠܦܹ̈ܐ، ܟܡܵܐ ܣܵܠܹ̈ܐ ܡܸܠܝܹܐ ܡ̣ܢ ܩܸܛܥܵܛܹ̈ܐ ܫܩܝܼܠܔ ܠܵܘܟ݂ܘܿܢ؟“ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ: ”ܫܲܒ݂ܥܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ܗ̇ܝܓܵܗ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܩܵܡܘܿܕܝܼ ܠܹܐ ܝܬܘܿܢ ܦܲܪܡܘܼܝܹܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܒܹܝܬ ܨܲܝܵܕܵܐ، ܘܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܚܲܕ ܣܸܡܝܵܐ، ܘܦܘܼܪܦܸܠܔ ܠܗܘܿܢ ܕܕܵܩܹܪ ܗܘܵܐ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ܕܒ݂ܝܼܩ ܠܹܗ ܒܐܝܼܕܵܐ ܕܗ̇ܘ ܣܸܡܝܵܐ ܘܦܘܼܠܸܛ ܠܹܗ ܠܒܲܕܲܪ ܡ̣ܢ ܡܵܬܵ‌ܐ، ܘܪܝܼܩ ܠܹܗ ܥܲܠܔ ܥܲܝܢܘܼ̈ܗ‌ܝ، ܘܡܘܼܬܸܒ݂ ܠܹܗ ܐܝܼܕܵܬܘܼ̈ܗ‌ܝ ܥܲܠܘܼܗ‌ܝ، ܘܒܘܼܩܸܪܹܗ ܡܸܢܹܗ ܐܸܢ ܒܸܚܙܵܝܵܐ ܝܗܘܵܐ ܡܸܢܕܝܼ. ");
INSERT INTO aii_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ܘܗ̇ܘ ܚܝܼܪܹܗ ܘܐܡܝܼܪܹܗ: ”ܒܸܚܙܵܝܵܐ ܝܘܸܢ ܠܐܢܵܫܹ̈ܐ ܐܲܝܟ݂ ܐܝܼܠܵܢܹ̈ܐ ܒܸܚܕܵܪܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ܡܸܢܕܪܸܫ ܡܘܼܬܸܒ݂ ܠܹܗ ܝܼܫܘܿܥ ܐܝܼܕܵܬܘܼ̈ܗ‌ܝ ܥܲܠܔ ܥܲܝܢܘܼ̈ܗ‌ܝ، ܘܒܣܝܼܡ ܠܹܗ ܘܚܝܼܪܹܗ ܘܚܙܹܐ ܠܹܗ ܟܠܔ ܡܸܢܕܝܼ ܒܨܸܦܝܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ܘܫܘܼܕܸܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ ܠܒܲܝܬܹܗ ܘܐܡܝܼܪܹܗ: ”ܠܵܐ ܥܵܒ݂ܪܹܬ ܠܡܵܬܵ‌ܐ، ܘܠܵܐ ܐܵܡܪܹܬ ܠܐܘܼܦ ܚܲܕ.“ ");
INSERT INTO aii_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ܘܦܠܝܼܛ ܠܹܗ ܝܼܫܘܿܥ ܥܲܡ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܠܡܵܬܘܵܬܹ̈‌ܐ ܕܩܹܣܲܪܝܵܐ ܕܦܝܼܠܝܼܦܘܿܣ، ܘܒܐܘܼܪܚܵܐ ܒܘܼܩܸܪܹܗ ܡ̣ܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܡܘܼܕܝܼ ܟܹܐ ܐܵܡܪܝܼ ܐܢܵܫܹ̈ܐ ܒܘܼܬ ܕܝܼܝܼ ܕܐܵܢܵܐ ܝܼܘܸܢ؟“ ");
INSERT INTO aii_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ܐܵܢܝܼ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ: ”ܚܲܕܟܡܵܐ ܟܹܐ ܚܵܫܒ݂ܝܼ ܐܲܢ݇ܬ ܝܼܘܸܬ ܝܘܿܚܲܢܵܢ ܡܲܥܡܕܵܢܵܐ، ܘܐܚܹܪ̈ܢܹܐ ܟܹܐ ܐܵܡܪܝܼ ܐܹܠܝܼܵܐ ܝܘܸܬ، ܘܐܚܹܪ̈ܢܹܐ ܚܲܕ ܡ̣ܢ ܢܒ݂ܝܼܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ܐܝܼܢܵܐ ܗ̇ܘ ܒܘܼܩܸܪܹܗ: ”ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ، ܡܵܢܝܼ ܒܹܐܡܵܪܵܐ ܝܬܘܿܢ ܕܐܵܢܵܐ ܝܼܘܸܢ؟“ ܓ̰ܘܼܘܸܒ ܠܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܒܹܐܡܵܪܵܐ ܐܸܠܹܗ: ”ܐܲܢ݇ܬ ܝܼܘܸܬ ܡܫܝܼܚܵܐ، ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ ܚܵܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ܘܦܩܝܼܕ ܠܹܗ ܕܠܐܢܵܫܵܐ ܠܵܐ ܐܵܡܪܝܼ ܒܘܼܬ ܕܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ܘܫܘܼܪܹܐ ܠܹܗ ܝܼܫܘܿܥ ܡܲܕܘܼܥܹܐ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܕܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܘܵܠܹܐ ܝܠܵܗ̇ ܕܩܲܒܸܠܔ ܪܵܒܵܐ ܚܲܫܵܐ ܘܦܵܐܹܫ ܡܘܼܣܠܝܼܵܐ ܡ̣ܢ ܚܘܵܪ̈ܕܸܩܢܹܐ ܘܡ̣ܢ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܡ̣ܢ ܣܵܦܪܹ̈ܐ. ܒܸܬ ܦܵܐܹܫ ܩܛܝܼܠܵܐ، ܘܒܝܵܘܡܵܐ ܕܬܠܵܬܵ‌ܐ ܒܸܬ ܩܵܐܹܡ. ");
INSERT INTO aii_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ܘܓܲܠܝܵܐܝܼܬ ܐܡܝܼܪܹܗ ܐܵܗܵܐ ܗܹܡܸܙܡܵܢ ܐܸܠܵܝܗ‌ܝ. ܗ̇ܝܓܵܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܠܘܼܒܸܠܔ ܠܹܗ ܐܸܠܹܗ ܠܚܲܕ ܓܹܒܵܐ ܘܫܘܼܪܹܐ ܠܹܗ ܠܡܲܢܟ݂ܘܼܣܹܐ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ܐܝܼܢܵܐ ܗ̇ܘ ܕܝܼܪܹܗ ܘܚܝܼܪܹܗ ܒܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܡܘܼܢܟܸܣ ܠܹܗ ܠܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܪܚܘܿܩ ܡܸܢܝܼ ܣܵܛܵܢܵܐ، ܣܵܒܵܒ ܠܹܐ ܝܘܸܬ ܬܲܚܡܘܼܢܹܐ ܒܘܼܬ ܡܘܼܕܝܼ ܕܝܼܠܹܗ ܕܐܲܠܵܗܵܐ، ܐܸܠܵܐ ܕܒܲܪܢܵܫܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ܘܩܪܹܐ ܠܹܗ ܝܼܫܘܿܥ ܠܟܸܢܫܵܐ ܥܲܡ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܡ̇ܢ ܕܒܵܥܹܐ ܐܵܬܹ‌ܐ ܒܵܬܪܝܼ، ܣܵܪܹܒ݂ ܓܵܢܹܗ، ܘܫܵܩܹܠܔ ܙܩܝܼܦܹܗ، ܘܐܵܬܹ‌ܐ ܒܵܬܪܝܼ، ");
INSERT INTO aii_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","”ܣܵܒܵܒ ܡ̇ܢ ܕܒܵܥܹܐ ܦܲܪܸܩ ܓܵܢܹܗ ܒܸܬ ܛܲܠܸܩ ܠܵܗ̇. ܘܡ̇ܢ ܕܛܲܠܸܩ ܓܵܢܹܗ ܒܘܼܬ ܕܝܼܝܼ ܘܒܘܼܬ ܐܹܘܲܢܓܲܠܝܼܘܿܢ ܒܸܬ ܦܲܪܸܩ ܠܵܗ̇، ");
INSERT INTO aii_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","”ܣܵܒܵܒ ܡܘܼܕܝܼ ܝܘܼܬܪܵܢܵܐ ܐܝܼܬ ܠܒܲܪܢܵܫܵܐ ܐܸܢ ܩܵܢܹܐ ܠܵܗ̇ ܟܠܵܗ̇ ܕܘܼܢܝܹܐ ܐܝܼܢܵܐ ܓܵܢܹܗ ܛܲܠܸܩ ܠܵܗ̇؟ ");
INSERT INTO aii_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","”ܝܲܢ ܡܘܼܕܝܼ ܒܸܬ ܝܵܗܒܹܠܔ ܒܲܪܢܵܫܵܐ ܡܒܵܕܵܠܔ ܕܓܵܢܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","”ܟܠܔ ܡ̇ܢ ܕܢܵܟܹܦ ܒܝܼܝܼ ܘܒܗܹܡܸܙܡܵܢܝܼ̈ ܓܵܘ ܐܵܗܵܐ ܫܲܪܒܬܵ‌ܐ ܚܲܛܵܝܬܵ‌ܐ ܘܓܲܝܵܪܬܵ‌ܐ، ܐܘܼܦ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܸܬ ܢܵܟܹܦ ܒܝܼܹܗ ܐܝܼܡܲܢ ܕܐܵܬܹ‌ܐ ܒܫܘܼܒ݂ܚܵܐ ܕܒܵܒܘܼܗ‌ܝ ܥܲܡ ܡܲܠܲܐܟ݂ܘܼ̈ܗ‌ܝ ܩܲܕܝܼܫܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܝܼܬ ܐܢܵܫܹ̈ܐ ܠܲܐܟ݂ܵܐ ܕܠܹܐ ܡܵܝܬ‌ܝܼ ܗܲܠܔ ܕܚܵܙܝܼ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ ܒܹܐܬܵܝܵܐ ܒܚܲܝܠܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ܒܵܬܪ ܫܬܵ‌ܐ ܝܵܘܡܵܢܹ̈ܐ، ܠܘܼܒܸܠܔ ܠܹܗ ܝܼܫܘܿܥ ܥܲܡܹܗ ܠܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܘܠܝܲܥܩܘܿܒ݂ ܘܠܝܘܿܚܲܢܵܢ، ܘܡܘܼܐܣܩܵܝ ܠܹܗ ܠܛܘܼܪܵܐ ܪܵܡܵܐ ܒܢܲܦ̮ܫܵܝܗ‌ܝ. ܘܦܝܼܫ ܠܹܗ ܫܘܼܚܠܸܦܵܐ ܩܲܕܡܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ܘܡܘܼܒܪܸܩ ܠܵܗ̇ ܠܒ݂ܝܼܫܬܹܗ ܘܡܘܼܚܘܸܪܵܗ̇ ܪܵܒܵܐ ܐܲܝܟ݂ ܬܲܠܓܵܐ، ܗܵܕܵܐ ܕܐܘܼܦ ܚܲܕ ܡܲܚܘܸܪܵܢܵܐ ܓܵܘ ܕܘܼܢܝܹܐ ܠܹܐ ܡܵܨܹܐ ܗܘܵܐ ܠܡܲܚܘܘܼܪܹܐ. ");
INSERT INTO aii_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ܘܚܙܹܐ ܠܗܘܿܢ ܡܘܼܫܹܐ ܘܐܹܠܝܼܵܐ ܗܲܡܙܘܼܡܹܐ ܥܲܡ ܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ: ”ܪܲܒܝܼ، ܨܦܵܝܝܼ ܝܠܵܗ̇ ܕܦܵܝܫܲܚ ܠܲܐܟ݂ܵܐ، ܘܥܵܒ݂ܕܲܚ ܬܠܵܬ ܡܛܲܠܠܹ̈ܐ، ܚܕܵܐ ܩܵܬܘܼܟ݂، ܘܚܕܵܐ ܩܵܐ ܡܘܼܫܹܐ، ܘܚܕܵܐ ܩܵܐ ܐܹܠܝܼܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ܠܵܐ ܝܕܝܼܥ ܠܹܗ ܡܘܼܕܝܼ ܗܲܡܙܘܼܡܹܐ ܝܗܘܵܐ، ܣܵܒܵܒ ܟܠܵܝܗ‌ܝ ܓܵܘ ܙܕܘܼܥܬܵ‌ܐ ܝܗܘܵܘ. ");
INSERT INTO aii_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ܘܗܘܹܐ ܠܵܗ̇ ܥܢܵܢܵܐ ܘܥܒ݂ܝܼܕ ܠܵܗ̇ ܛܸܠܵܢܝܼܬܵ‌ܐ ܥܲܠܵܝܗ‌ܝ، ܘܩܵܠܵܐ ܐܬܹ‌ܐ ܠܹܗ ܡ̣ܢ ܥܢܵܢܵܐ ܒܹܐܡܵܪܵܐ: ”ܐܵܗܵܐ ܝܠܹܗ ܒܪܘܿܢܝܼ ܡܘܼܚܸܒܵܐ، ܐܸܠܹܗ ܫܡܹܥܡܘܼܢ.“ ");
INSERT INTO aii_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ܘܡܸܢܫܸܠܬܵܢܹܐ ܚܝܼܪܗܘܿܢ ܬܲܠܡܝܼ̈ܕܹܐ، ܠܐܢܵܫܵܐ ܠܵܐ ܚܙܹܐ ܠܗܘܿܢ ܐܸܠܵܐ ܠܝܼܫܘܿܥ ܒܢܲܦ̮ܫܹܗ ܥܲܡܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ܘܟܲܕ ܒܸܨܠܵܝܵܐ ܝܗܘܵܘ ܡ̣ܢ ܛܘܼܪܵܐ، ܦܩܝܼܕܵܝ ܠܹܗ ܝܼܫܘܿܥ ܕܠܐܢܵܫܵܐ ܠܵܐ ܐܵܡܪܝܼ ܒܘܼܬ ܡܸܢܕܝܼ ܕܚܙܹܐ ܠܗܘܿܢ ܗܲܠܔ ܕܩܵܐܹܡ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܡ̣ܢ ܓܵܘ ܡܝܼ̈ܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ܘܕܒ݂ܝܼܩܵܐ ܠܗܘܿܢ ܐܵܗܵܐ ܗܹܡܸܙܡܵܢ ܓܵܘ ܠܸܒܵܝܗ‌ܝ. ܐܝܼܢܵܐ ܒܲܩܪܝܼ ܗܘܵܘ ܚܲܕ ܡ̣ܢ ܗ̇ܘ ܐܚܹܪܢܵܐ ܘܐܵܡܪܝܼ ܗܘܵܘ: ܡܘܼܕܝܼ ܝܠܵܗ̇ ܡܲܥܢܵܝܵܐ ܕܩܵܐܹܡ ܡ̣ܢ ܓܵܘ ܡܝܼ̈ܬܹ‌ܐ؟ ");
INSERT INTO aii_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ ܒܹܐܡܵܪܵܐ: ”ܩܵܡܘܿܕܝܼ ܟܹܐ ܐܵܡܪܝܼ ܣܵܦܪܹ̈ܐ ܕܐܹܠܝܼܵܐ ܘܵܠܹܐ ܝܠܵܗ̇ ܕܐܵܬܹ‌ܐ ܩܲܕܡܵܝܬܵ‌ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܒܹܐܡܵܪܵܐ ܐܸܠܵܝܗ‌ܝ: ”ܐܹܠܝܼܵܐ ܒܫܲܪܝܼܪܘܼܬܵ‌ܐ ܒܹܐܬܵܝܵܐ ܝܠܹܗ ܩܲܕܡܵܝܬܵ‌ܐ ܕܗܲܕܸܪ ܟܠܔ ܡܸܢܕܝܼ. ܕܵܐܟ݂ܝܼ ܦܝܼܫܵܐ ܝܠܹܗ ܟܬܝܼܒ݂ܵܐ ܒܘܼܬ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܕܪܵܒܵܐ ܒܸܬ ܩܲܒܸܠܔ ܚܲܫܵܐ ܘܒܸܬ ܦܵܐܹܫ ܡܘܼܣܠܝܼܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","”ܐܝܼܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܐܘܼܦ ܐܹܠܝܼܵܐ ܐܬܹ‌ܐ ܠܹܗ ܘܥܒ݂ܝܼܕ ܠܗܘܿܢ ܒܝܼܹܗ ܟܠܔ ܡܸܢܕܝܼ ܕܒܣܝܼܡ ܠܵܗ̇ ܠܗܘܿܢ، ܕܵܐܟ݂ܝܼ ܕܝܼܠܹܗ ܟܬܝܼܒ݂ܵܐ ܒܘܼܬ ܕܝܼܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ܟܲܕ ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ܚܙܹܐ ܠܗܘܿܢ ܟܸܢܫܵܐ ܪܵܒܵܐ ܚܵܕܸܪ̈ܘܵܢܵܝܗ‌ܝ، ܘܣܵܦܪܹ̈ܐ ܒܸܕܪܵܫܵܐ ܥܲܡܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ، ܟܠܹܗ ܟܸܢܫܵܐ ܟܲܕ ܚܙܹܐ ܠܗܘܿܢ ܐܸܠܹܗ، ܥܘܼܓ̰ܸܒ ܠܗܘܿܢ، ܘܪܚܝܼܛ ܠܗܘܿܢ ܘܕܪܹܐ ܠܗܘܿܢ ܫܠܵܡܵܐ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ܘܒܘܼܩܸܪܹܗ ܡ̣ܢ ܣܵܦܪܹ̈ܐ ܒܹܐܡܵܪܵܐ: ”ܩܵܡܘܿܕܝܼ ܒܸܕܪܵܫܵܐ ܝܬܘܿܢ ܥܲܡܵܝܗ‌ܝ؟“ ");
INSERT INTO aii_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ܓ̰ܘܼܘܸܒ ܠܹܗ ܚܲܕ ܡ̣ܢ ܟܸܢܫܵܐ ܒܹܐܡܵܪܵܐ ܐܸܠܹܗ: ”ܡܲܠܦܵܢܵܐ، ܡܘܼܝܬܹ‌ܐ ܠܝܼ ܒܪܘܿܢܝܼ ܠܟܸܣܠܘܼܟ݂ ܣܵܒܵܒ ܐܝܼܬ ܒܝܼܹܗ ܪܘܼܚܵܐ ܠܲܥܠܹܐ، ");
INSERT INTO aii_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","”ܘܐܝܼܡܲܢ ܕܟܹܐ ܕܵܒ݂ܩܵܐ ܠܹܗ، ܟܹܐ ܪܲܦܝܵܐ ܠܹܗ ܠܐܲܪܥܵܐ، ܘܟܹܐ ܓܲܒܓܸܒ ܦܘܼܡܹܗ، ܘܚܲܪܚܸܟ̰ܝܼ ܟܹܟܘܼ̈ܗ‌ܝ، ܘܟܹܐ ܒܵܪܹܙ. ܛܠܝܼܒ ܠܝܼ ܡ̣ܢ ܬܲܠܡܝܼܕܘܼ̈ܟ݂ ܕܦܲܠܛܝܼ ܗܘܵܘ ܪܘܼܚܵܐ ܡܸܢܹܗ، ܐܝܼܢܵܐ ܠܵܐ ܡܨܹܐ ܠܗܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܒܹܐܡܵܪܵܐ ܐܸܠܵܝܗ‌ܝ: ”ܝܵܐ ܫܲܪܒܬܵ‌ܐ ܠܵܐ ܡܗܘܼܡܸܢܬܵ‌ܐ، ܗܲܠܔ ܐܝܼܡܲܢ ܒܸܬ ܗܵܘܹܝܢ ܥܲܡܵܘܟ݂ܘܿܢ، ܘܗܲܠܔ ܐܝܼܡܲܢ ܒܸܬ ܛܵܥܢܹܢ ܝܘܼܩܪܵܘܟ݂ܘܿܢ؟ ܡܲܝܬܹܝܡܘܼܢ ܠܹܗ ܠܟܸܣܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ، ܘܟܲܕ ܚܙܹܐ ܠܵܗ̇ ܐܸܠܹܗ ܪܘܼܚܵܐ، ܪܘܼܦܹܐ ܠܵܗ̇ ܐܸܠܹܗ، ܘܢܦܝܼܠܔ ܠܹܗ ܥܲܠܔ ܐܲܪܥܵܐ ܥܲܪܒܘܼܛܹܐ، ܘܓܘܼܒܓܸܒ ܠܹܗ ܦܘܼܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ܒܘܼܩܸܪܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܒܵܒܘܼܗ‌ܝ: ”ܐܵܗܵܐ ܟܡܵܐ ܥܕܵܢܵܐ ܗܵܕܟ݂ܵܐ ܝܠܹܗ؟“ ܓ̰ܘܼܘܸܒ ܠܹܗ ܒܵܒܘܼܗ‌ܝ ܒܹܐܡܵܪܵܐ: ”ܗܵܐ ܡ̣ܢ ܝܵܠܕ݇ܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","”ܘܪܵܒܵܐ ܓܵܗܹ̈ܐ ܟܹܐ ܕܵܪܝܵܐ ܠܹܗ ܒܢܘܼܪܵܐ ܘܒܡ̈ܝܼܵܐ ܕܩܵܛܠܵܐ ܠܹܗ. ܐܝܼܢܵܐ ܐܸܢ ܡܵܨܹܝܬ ܥܵܒ݂ܕܹܬ ܡܸܢܕܝܼ، ܗܲܝܸܪܲܢ ܘܪܲܚܸܡ ܥܲܠܲܢ.“ ");
INSERT INTO aii_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܐܸܢ ܡܵܨܹܝܬ ܗܲܡܸܢܸܬ، ܟܠܔ ܡܸܢܕܝܼ ܒܸܬ ܗܵܘܹܐ ܠܡ̇ܢ ܕܗܲܡܸܢ.“ ");
INSERT INTO aii_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ܡܘܼܩܘܸܚ ܠܹܗ ܒܵܒܵܐ ܕܝܵܠܵܕ݇ܐ ܒܹܐܡܵܪܵܐ: ”ܗܲܡܘܼܢܹܐ ܝܘܸܢ، ܗܲܝܸܪ ܠܒܵܨܘܿܪܘܼܬܵ‌ܐ ܕܗܲܝܡܵܢܘܼܬ‌ܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ܟܲܕ ܚܙܹܐ ܠܹܗ ܝܼܫܘܿܥ ܠܟܸܢܫܵܐ ܒܸܪܚܵܛܵܐ ܘܒܸܓ̰ܡܵܥܵܐ ܠܟܸܣܠܹܗ، ܢܓ̰ܝܼܘ ܠܹܗ ܒܗ̇ܝ ܪܘܼܚܵܐ ܛܲܡܐܹܐ ܘܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇: ”ܪܘܼܚܵܐ ܚܲܪܫܬܵ‌ܐ ܘܠܲܥܠܹܐ، ܒܸܦܩܵܕܵܐ ܝܘܸܢ ܐܸܠܵܟ݂ܝ ܕܦܵܠܛܲܬ‌ܝ ܡܸܢܹܗ ܘܠܵܐ ܥܵܒ݂ܪܲܬ‌ܝ ܐܚܹܪܢܵܐ ܒܝܼܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ܡܘܼܩܘܸܚ ܠܵܗ̇ ܗ̇ܝ ܪܘܼܚܵܐ ܪܵܒܵܐ، ܪܘܼܦܹܐ ܠܵܗ̇ ܐܸܠܹܗ ܘܦܠܝܼܛ ܠܵܗ̇ ܡܸܢܹܗ، ܘܗܘܹܐ ܠܹܗ ܐܲܝܟ݂ ܡܝܼܬܵ‌ܐ ܗ̇ܘ ܝܵܠܵܕ݇ܐ، ܗܵܕܟ݂ܵܐ ܕܪܵܒܵܐ ܐܡܝܼܪܗܘܿܢ ܕܡܝܼܬܵ‌ܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܕܒ݂ܝܼܩ ܠܹܗ ܒܐܝܼܕܹܗ ܘܡܘܼܩܸܡ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ܐܝܼܡܲܢ ܕܥܒ݂ܝܼܪܹܗ ܝܼܫܘܿܥ ܠܒܲܝܬܵ‌ܐ، ܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܒܢܲܦ̮ܫܵܝܗ‌ܝ: ”ܩܵܡܘܿܕܝܼ ܠܵܐ ܡܨܹܐ ܠܲܢ ܐܲܚܢܲܢ ܕܦܲܠܛܲܚ ܡܸܢܹܗ ܫܹܐܕܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܐܵܗܵܐ ܓܸܢܣܵܐ ܠܹܐ ܦܵܠܹܛ ܐܸܠܵܐ ܒܨܵܘܡܵܐ ܘܒܨܠܘܿܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ܘܟܲܕ ܦܠܝܼܛ ܠܗܘܿܢ ܡ̣ܢ ܬܵܡܵܐ، ܥܒ݂ܝܼܪܗܘܿܢ ܡ̣ܢ ܓܵܘ ܓܠܝܼܠܵܐ ܘܠܵܐ ܒܥܹܐ ܠܹܗ ܕܐܢܵܫܵܐ ܝܵܕܹܥ ܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ܣܵܒܵܒ ܡܲܠܘܼܦܹܐ ܝܗܘܵܐ ܠܬܲܠܡܝܼ̈ܕܹܐ، ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܸܬ ܦܵܐܹܫ ܣܘܼܦܝܵܐ ܒܐܝܼܕܵܬܹ̈‌ܐ ܕܒܢܲܝ̈ܢܵܫܵܐ ܘܒܸܬ ܩܵܛܠܝܼ ܠܹܗ. ܘܡ̣ܢ ܒܵܬܪ ܕܦܵܐܹܫ ܩܛܝܼܠܵܐ، ܒܝܵܘܡܵܐ ܕܬܠܵܬܵ‌ܐ ܒܸܬ ܩܵܐܹܡ.“ ");
INSERT INTO aii_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ܐܝܼܢܵܐ ܐܵܢܝܼ ܠܵܐ ܦܘܼܪܡܹܐ ܠܗܘܿܢ ܡܘܼܕܝܼ ܒܹܐܡܵܪܵܐ ܝܗܘܵܐ، ܘܙܕܝܼܥ ܠܗܘܿܢ ܕܒܲܩܪܝܼ ܗܘܵܘ ܠܹܗ ܙܵܘܕܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܦܲܪܢܵܚܘܿܡ، ܘܟܲܕ ܓܵܘ ܒܲܝܬܵ‌ܐ ܝܗܘܵܐ، ܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܡܘܼܕܝܼ ܒܸܕܪܵܫܵܐ ܝܬܘܿܢ ܗܘܵܘ ܒܐܘܼܪܚܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ܐܝܼܢܵܐ ܐܵܢܝܼ ܠܵܐ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ، ܣܵܒܵܒ ܒܸܕܪܵܫܵܐ ܝܗܘܵܘ ܒܐܘܼܪܚܵܐ ܚܲܕ ܥܲܡ ܗ̇ܘ ܐܚܹܪܢܵܐ ܕܡܵܢܝܼ ܝܠܹܗ ܓܘܼܪܵܐ ܓܵܘܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ܝܬܝܼܒ݂ ܠܹܗ ܝܼܫܘܿܥ، ܘܩܪܹܐ ܠܹܗ ܠܬܪܸܥܣܲܪ ܬܲܠܡܝܼ̈ܕܹܐ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܡ̇ܢ ܕܒܵܥܹܐ ܗܵܘܹܐ ܩܲܕܡܵܝܵܐ، ܗܵܘܹܐ ܐܚܵܪܵܝܵܐ ܕܟܠܵܝܗ‌ܝ ܘܥܵܒ݂ܕܵܢܵܐ ܕܚܸܠܡܲܬ ܠܟܠܵܝܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ܘܫܩܝܼܠܔ ܠܹܗ ܚܲܕ ܝܵܠܵܕ݇ܐ ܘܡܘܼܟܠܹܐ ܠܹܗ ܒܹܝܦܲܠܓܵܐ. ܘܡ̣ܢ ܒܵܬܪ ܕܫܩܝܼܠܔ ܠܹܗ ܓܵܘ ܕܪ̈ܲܥܢܵܢܘܼܗ‌ܝ، ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ");
INSERT INTO aii_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","”ܟܠܔ ܡ̇ܢ ܕܩܲܒܸܠܔ ܚܲܕ ܝܵܠܵܕ݇ܐ ܐܲܝܟ݂ ܐܵܗܵܐ ܒܫܸܡܝܼ، ܐܸܠܝܼ ܩܲܒܘܼܠܹܐ ܝܠܹܗ، ܘܡ̇ܢ ܕܐܸܠܝܼ ܩܲܒܸܠܔ، ܠܹܐ ܝܠܹܗ ܐܸܠܝܼ ܩܲܒܘܼܠܹܐ ܐܸܠܵܐ ܠܡ̇ܢ ܕܫܘܼܕܪܸܢܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܘܿܚܲܢܵܢ: ”ܪܲܒܝܼ، ܚܙܹܐ ܠܲܢ ܚܲܕ ܐܢܵܫܵܐ ܦܲܠܘܼܛܹܐ ܫܹܐܕܹ̈ܐ ܒܫܸܡܘܼܟ݂، ܐܝܼܢܵܐ ܡܘܼܟܠܹܐ ܠܲܢ ܐܸܠܹܗ ܣܵܒܵܒ ܠܵܐ ܬܒܝܼܥ ܠܹܗ ܐܸܠܲܢ.“ ");
INSERT INTO aii_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܠܵܐ ܡܲܟܠܹܝܬܘܿܢ ܠܹܗ، ܣܵܒܵܒ ܠܲܝܬ ܚܲܕ ܕܥܵܒܹܕ ܕܘܼܡܵܪܵܐ ܒܫܸܡܝܼ ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܗܲܡܙܸܡ ܒܝܼܫܬܵ‌ܐ ܥܲܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","”ܡ̇ܢ ܕܠܹܐ ܝܠܹܗ ܠܕܲܠܩܘܼܒ݂ܠܲܢ ܠܓܹܒܲܢ ܝܼܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","”ܟܠܔ ܡ̇ܢ ܕܡܲܫܬܹ‌ܐ ܠܵܘܟ݂ܘܿܢ ܟܵܣܵܐ ܕܡ̈ܝܼܵܐ ܒܫܸܡܝܼ ܣܵܒܵܒ ܝܼܬܘܿܢ ܕܡܫܝܼܚܵܐ، ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ ܠܹܐ ܛܵܠܹܩ ܦܘܼܪܥܵܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","”ܟܠܔ ܡ̇ܢ ܕܡܲܚܛܹܐ ܠܚܲܕ ܡ̣ܢ ܐܲܢܹܐ ܙܥܘܿܪܹ̈ܐ ܕܟܹܐ ܗܲܡܸܢܝܼ ܒܝܼܝܼ، ܨܦܵܝܝܼ ܝܗܘܵܐ ܐܸܠܹܗ ܕܗܵܘܹܐ ܗܘܵܐ ܬܸܠܝܵܐ ܟܹܐܦܵܐ ܕܐܸܪܚܹܐ ܒܩܕܵܠܹܗ ܘܗܵܘܹܐ ܗܘܵܐ ܕܸܪܝܵܐ ܒܝܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","”ܐܸܢ ܐܝܼܕܘܼܟ݂ ܡܲܚܛܝܼܵܐ ܠܘܼܟ݂، ܦܪܘܿܡ ܠܵܗ̇، ܣܵܒܵܒ ܒܘܼܫ ܨܦܵܝܝܼ ܝܠܵܗ̇ ܐܸܠܘܼܟ݂ ܕܫܸܠܵܐ ܥܵܒ݂ܪܹܬ ܠܚܲܝܹ̈ܐ ܡ̣ܢ ܕܗܵܘܹܐ ܠܘܼܟ݂ ܬܲܪܬܹܝ ܐܝܼܕܵܬܹ̈‌ܐ ܘܐܵܙܹܠ݇ܬ ܠܓܹܗܲܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","”ܐܲܝܟܵܐ ܕܬܸܘܸܠܥܬܘܼܗ̇ ܠܹܐ ܡܵܝܬܵ‌ܐ ܘܢܘܼܪܘܼܗ̇ ܠܹܐ ܟ̰ܵܡܹܥ. ");
INSERT INTO aii_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","”ܘܐܸܢ ܐܲܩܠܘܼܟ݂ ܡܲܚܛܝܼܵܐ ܠܘܼܟ݂، ܦܪܘܿܡ ܠܵܗ̇، ܣܵܒܵܒ ܒܘܼܫ ܨܦܵܝܝܼ ܝܠܵܗ̇ ܐܸܠܘܼܟ݂ ܕܫܦܝܼܠܵܐ ܥܵܒ݂ܪܹܬ ܠܚܲܝܹ̈ܐ ܡ̣ܢ ܕܗܵܘܹܐ ܠܘܼܟ݂ ܬܲܪܬܹܝ ܐܲܩܠܵܬܹ̈‌ܐ ܘܦܵܝܫܹܬ ܪܘܼܦܝܵܐ ܒܓܹܗܲܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","”ܐܲܝܟܵܐ ܕܬܸܘܸܠܥܬܘܼܗ̇ ܠܹܐ ܡܵܝܬܵ‌ܐ ܘܢܘܼܪܘܼܗ̇ ܠܹܐ ܟ̰ܵܡܹܥ. ");
INSERT INTO aii_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","”ܘܐܸܢ ܥܲܝܢܘܼܟ݂ ܡܲܚܛܝܼܵܐ ܠܘܼܟ݂، ܚܪܘܿܛ ܠܵܗ̇، ܣܵܒܵܒ ܒܘܼܫ ܨܦܵܝܝܼ ܝܠܵܗ̇ ܐܸܠܘܼܟ݂ ܒܚܕܵܐ ܥܲܝܢܵܐ ܥܵܒ݂ܪܹܬ ܠܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ ܘܠܵܐ ܕܗܵܘܹܐ ܠܘܼܟ݂ ܬܲܪܬܹܝ ܥܲܝ̈ܢܹܐ ܘܦܵܝܫܹܬ ܪܘܼܦܝܵܐ ܒܢܘܼܪܵܐ ܕܓܹܗܲܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","”ܐܲܝܟܵܐ ܕܬܸܘܸܠܥܬܘܼܗ̇ ܠܹܐ ܡܵܝܬܵ‌ܐ ܘܢܘܼܪܘܼܗ̇ ܠܹܐ ܟ̰ܵܡܹܥ. ");
INSERT INTO aii_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","”ܣܵܒܵܒ ܟܠܔ ܚܲܕ ܒܢܘܼܪܵܐ ܟܹܐ ܦܵܐܹܫ ܡܘܼܡܠܸܚܵܐ، ܘܟܠܔ ܕܸܒ݂ܚܵܐ ܒܡܸܠܚܵܐ ܟܹܐ ܦܵܐܹܫ ܡܘܼܡܠܸܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","”ܡܸܠܚܵܐ ܨܦܵܝܝܼ ܝܠܵܗ̇، ܐܝܼܢܵܐ ܐܸܢ ܡܸܠܚܵܐ ܦܵܝܟܵܐ، ܒܡܘܼܕܝܼ ܒܸܬ ܡܲܡܠܸܚܝܼܬܘܿܢ ܠܵܗ̇؟ ܗܵܘܝܵܐ ܓܵܘܵܘܟ݂ܘܿܢ ܡܸܠܚܵܐ، ܘܚܹܝܡܘܼܢ ܒܫܠܵܡܵܐ ܚܲܕ ܥܲܡ ܗ̇ܘ ܐܚܹܪܢܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ܩܝܼܡ ܠܹܗ ܡ̣ܢ ܬܵܡܵܐ ܝܼܫܘܿܥ ܘܐܬܹ‌ܐ ܠܹܗ ܠܬܚܘܼܡܵܐ ܕܝܼܗܘܼܕ، ܠܡܲܪܙܵܐ ܐܚܹܪܢܵܐ ܕܝܘܿܪܕܢܵܢ، ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܟܸܢܫܹ̈ܐ ܪܵܒܵܐ، ܘܡܲܠܸܦ ܗܘܵܐ ܠܗܘܿܢ ܡܸܢܕܪܸܫ ܐܲܝܟ݂ ܕܐܝܼܬ ܗܘܵܐ ܠܹܗ ܥܵܕܲܬ. ");
INSERT INTO aii_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ܩܘܼܪܒܸܢܗܘܿܢ ܠܟܸܣܠܹܗ ܦܪ̈ܝܼܫܹܐ ܠܓ̰ܲܪܘܼܒܹܗ، ܘܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ ܐܸܢ ܩܵܢܘܿܢܵܝܬܵ‌ܐ ܝܠܵܗ̇ ܕܐܢܵܫܵܐ ܪܲܦܹܐ ܒܲܟ݂ܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܡܘܼܕܝܼ ܦܩܝܼܕ ܠܹܗ ܐܸܠܵܘܟ݂ܘܿܢ ܡܘܼܫܹܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ܘܐܵܢܝܼ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ: ”ܡܘܼܫܹܐ ܝܘܼܗܒܹܠܔ ܠܹܗ ܦܣܵܣܵܐ ܐܸܠܲܢ ܕܟܵܬܒܲܚ ܟܬܵܒ݂ܵܐ ܕܕܘܼܠܵܠܵܐ ܘܪܲܦܲܚ.“ ");
INSERT INTO aii_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ ܒܹܐܡܵܪܵܐ: ”ܡܘܼܫܹܐ ܒܘܼܬ ܩܸܫܝܘܼܬܵ‌ܐ ܕܠܸܒܵܘܟ݂ܘܿܢ ܟܬܝܼܒ݂ ܠܹܗ ܐܸܠܵܘܟ݂ܘܿܢ ܐܵܗܵܐ ܦܘܼܩܕܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","”ܐܝܼܢܵܐ ܡ̣ܢ ܫܘܼܪܵܝܵܐ ܕܒܪܝܼܬܵ‌ܐ ܐܘܼܪܙܵܐ ܘܢܸܩܒ݂ܵܐ ܒܸܪܝܵܝ ܠܹܗ ܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","”ܒܘܼܬ ܐܵܗܵܐ ܒܸܬ ܫܵܒܹܩ ܓܲܒ݂ܪܵܐ ܠܒܵܒܘܼܗ‌ܝ ܘܠܝܸܡܹܗ ܘܒܸܬ ܬܵܒܹܥ ܠܒܲܟ݂ܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","”ܘܬܸܪܘܵܝ ܒܸܬ ܗܵܘܝܼ ܚܲܕ ܦܲܓ݂ܪܵܐ، ܣܵܒܵܒ ܐܚܹܪܢܵܐ ܠܹܐ ܝܢܵܐ ܬܪܹܝ ܐܸܠܵܐ ܚܲܕ ܦܲܓ݂ܪܵܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","”ܗܵܕܟ݂ܵܐ ܡܸܢܕܝܼ ܕܐܲܠܵܗܵܐ ܙܘܼܘܸܓ ܠܹܗ، ܒܲܪܢܵܫܵܐ ܠܵܐ ܦܵܪܹܫ ܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ܐܝܼܡܲܢ ܕܝܼܗܘܵܘ ܓܵܘ ܒܲܝܬܵ‌ܐ، ܒܘܼܩܸܪܗܘܿܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܡܸܢܹܗ ܒܘܼܬ ܐܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܟܠܔ ܡ̇ܢ ܕܪܲܦܹܐ ܒܲܟ݂ܬܹܗ ܘܓܵܒܹܪ ܚܕܵܐ ܐܚܹܪܬܵ‌ܐ، ܒܸܥܒ݂ܵܕܵܐ ܝܠܹܗ ܓܲܝܵܪܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","”ܘܐܸܢ ܒܲܟ݂ܬܵ‌ܐ ܪܲܦܝܵܐ ܓܲܒ݂ܪܘܼܗ̇ ܘܓܵܒ݂ܪܵܐ ܚܲܕ ܐܚܹܪܢܵܐ ܒܸܥܒ݂ܵܕܵܐ ܝܠܵܗ̇ ܓܲܝܵܪܘܼܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܐܢܵܫܹ̈ܐ ܝܵܠܹ̈ܕ݇ܐ ܙܥܘܿܪܹ̈ܐ ܠܟܸܣ ܝܼܫܘܿܥ ܕܡܲܬܸܒ݂ ܗܘܵܐ ܐܝܼܕܹܗ ܥܲܠܵܝܗ‌ܝ، ܐܝܼܢܵܐ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܢܓ̰ܝܼܘ ܠܗܘܿܢ ܒܐܵܢܝܼ ܕܡܲܝܬܘܼܝܵܝ ܝܗܘܵܘ. ");
INSERT INTO aii_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܹܗ ܝܼܫܘܿܥ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܗܵܕܟ݂ܵܐ ܒܸܥܒ݂ܵܕܵܐ، ܟܪܝܼܒ ܠܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܫܒ݂ܘܿܩܘܼܢ ܝܵܠܹ̈ܕ݇ܐ ܙܥܘܿܪܹ̈ܐ ܐܵܬ‌ܝܼ ܠܟܸܣܠܝܼ ܘܠܵܐ ܡܲܟܠܹܝܬܘܿܢ ܠܗܘܿܢ، ܣܵܒܵܒ ܕܝܼܵܝܗ‌ܝ ܝܠܵܗ̇ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܟܠܔ ܡ̇ܢ ܕܠܵܐ ܩܲܒܸܠܔ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ ܡܐܲܝܟ݂ ܚܲܕ ܝܵܠܵܕ݇ܐ ܙܥܘܿܪܵܐ ܕܟܹܐ ܩܲܒܸܠܔ ܠܵܗ̇، ܠܹܐ ܥܵܒܹܪ ܓܵܘܘܼܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ܘܫܩܝܼܠܵܝ ܠܹܗ ܓܵܘ ܕܪ̈ܲܥܢܵܢܘܼܗ‌ܝ ܘܡܘܼܬܸܒ݂ ܠܹܗ ܐܝܼܕܹܗ ܥܲܠܵܝܗ‌ܝ ܘܒܘܼܪܟ݂ܵܝ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ܟܲܕ ܒܹܐܙܵܠܵܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܒܐܘܼܪܚܵܐ، ܪܚܝܼܛ ܠܹܗ ܚܲܕ ܐܢܵܫܵܐ ܘܒܪܝܼܟ ܠܹܗ ܩܲܕܡܘܼܗ‌ܝ ܘܒܘܼܩܸܪܹܗ ܡܸܢܹܗ: ”ܡܲܠܦܵܢܵܐ ܛܵܒ݂ܵܐ، ܡܘܼܕܝܼ ܥܵܒ݂ܕܹܢ ܕܝܵܪܬܹܢ ܚܲܝܹ̈ܐ ܕܠܥܵܠܲܡ؟“ ");
INSERT INTO aii_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܩܵܡܘܿܕܝܼ ܒܸܩܪܵܝܝܼ ܝܘܸܬ ܛܵܒ݂ܵܐ؟ ܠܲܝܬ ܛܵܒ݂ܵܐ ܐܸܠܵܐ ܐܲܠܵܗܵܐ ܐܲܚܟ̰ܝܼ. ");
INSERT INTO aii_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","”ܦܘܼܩܕܵܢܹ̈ܐ ܟܹܐ ܝܵܕܥܹܬ: ܠܵܐ ܙܵܢܹܝܬ، ܠܵܐ ܓܵܢܒܹܬ، ܠܵܐ ܩܵܛܠܹܬ، ܠܵܐ ܝܵܗܒܹܬ ܣܵܗܕܘܼܬܵ‌ܐ ܕܕܘܼܓܠܵܐ، ܠܵܐ ܙܵܠܡܹܬ، ܡܝܲܩܸܪ ܠܒܵܒܘܼܟ݂ ܘܠܝܸܡܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ܓ̰ܘܼܘܸܒ ܠܹܗ ܗ̇ܘ ܒܹܐܡܵܪܵܐ: ”ܡܲܠܦܵܢܵܐ، ܐܲܢܹܐ ܟܠܵܝܗ‌ܝ ܢܛܝܼܪܵܝ ܝܘܸܢ ܡ̣ܢ ܝܵܠܕ݇ܘܼܬ‌ܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܚܝܼܪܹܗ ܒܝܼܹܗ ܘܡܘܼܚܸܒ ܠܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܚܲܕ ܡܸܢܕܝܼ ܒܵܨܘܿܪܵܐ ܝܠܹܗ ܐܸܠܘܼܟ݂. ܙܹܠܔ݇ ܙܲܒܸܢ ܟܠܔ ܡܸܢܕܝܼ ܕܐܝܼܬ ܠܘܼܟ݂ ܘܗܲܒ݂ܠܔ ܠܹܗ ܠܡܸܣܟܹܢܹ̈ܐ، ܘܒܸܬ ܗܵܘܹܐ ܠܘܼܟ݂ ܣܝܼܡܬܵ‌ܐ ܒܫܡܲܝܵܐ، ܘܫܩܘܿܠܔ ܙܩܝܼܦܘܼܟ݂ ܘܬܵ‌ܐ ܒܵܬܪܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ܐܝܼܢܵܐ ܗ̇ܘ ܦܫܝܼܡ ܠܹܗ ܒܐܵܗܵܐ ܗܹܡܸܙܡܵܢ، ܘܐܙܝܼܠܔ ܠܹܗ ܚܲܫܵܢܵܐ ܣܵܒܵܒ ܐܝܼܬ ܗܘܵܐ ܠܹܗ ܥܘܼܬܪܵܐ ܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ܗ̇ܝܓܵܗ ܚܝܼܪܹܗ ܝܼܫܘܿܥ ܒܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܟܡܵܐ ܥܲܣܩܵܐ ܝܠܵܗ̇ ܠܐܵܢܝܼ ܕܐܝܼܬ ܠܗܘܿܢ ܥܘܼܬܪܵܐ ܕܥܵܒ݂ܪܝܼ ܠܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ܐܝܼܢܵܐ ܬܲܠܡܝܼ̈ܕܹܐ ܥܘܼܓ̰ܸܒ ܠܗܘܿܢ ܥܲܠܔ ܗܹܡܸܙܡܵܢܘܼ̈ܗ‌ܝ. ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܡܸܢܕܪܸܫ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܒܢܘܿܢܝܼ̈، ܟܡܵܐ ܥܲܣܩܵܐ ܝܠܵܗ̇ ܠܐܵܢܝܼ ܕܝܼܢܵܐ ܒܗܹܒ݂ܝܼ ܥܲܠܔ ܥܘܼܬܪܵܝܗ‌ܝ ܕܥܵܒ݂ܪܝܼ ܠܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","”ܒܘܼܫ ܦܫܝܼܛܬܵ‌ܐ ܝܠܵܗ̇ ܠܓܘܼܡܠܵܐ ܕܥܵܒ݂ܪܵܐ ܒܢܸܩܒܵܐ ܕܚܡܵܛܵܐ ܡ̣ܢ ܕܥܲܬܝܼܪܵܐ ܥܵܒܹܪ ܠܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ܘܬܲܠܡܝܼ̈ܕܹܐ ܒܘܼܫ ܙܵܘܕܵܐ ܥܘܼܓ̰ܸܒ ܠܗܘܿܢ ܘܐܵܡܪܝܼ ܗܘܵܘ ܒܹܝܠܵܝܗ‌ܝ: ”ܒܵܣ ܡܵܢܝܼ ܡܵܨܹܐ ܦܵܪܹܩ؟“ ");
INSERT INTO aii_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܚܝܼܪܹܗ ܒܝܼܵܝܗ‌ܝ ܘܐܡܝܼܪܹܗ: ”ܒܲܪܢܵܫܵܐ ܠܹܐ ܡܵܨܹܐ ܥܵܒܹܕ ܐܵܗܵܐ، ܐܝܼܢܵܐ ܐܲܠܵܗܵܐ ܡܵܨܹܐ ܥܵܒܹܕ ܟܠܔ ܡܸܢܕܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ܓ̰ܘܼܘܸܒ ܠܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܒܹܐܡܵܪܵܐ ܐܸܠܹܗ: ”ܗܵܐ ܐܲܚܢܲܢ ܫܒ݂ܝܼܩ ܠܲܢ ܟܠܔ ܡܸܢܕܝܼ ܘܐܬܹ‌ܐ ܠܲܢ ܒܵܬܪܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ: ”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܟܠܔ ܐܢܵܫܵܐ ܕܫܵܒܹܩ ܒܲܝܬܵ‌ܐ، ܝܲܢ ܐܲܚܘܿܢܘܵܬܹ̈‌ܐ ܝܲܢ ܚܵܬܘܵܬܹ̈‌ܐ، ܝܲܢ ܒܵܒܵܐ ܝܲܢ ܝܸܡܵܐ، ܝܲܢ ܒܲܟ݂ܬܵ‌ܐ ܝܲܢ ܒܢܘܿܢܹ̈ܐ، ܝܲܢ ܚܲܩܠܵܢܹ̈ܐ، ܒܘܼܬ ܕܝܼܝܼ ܘܒܘܼܬ ܐܹܘܲܢܓܲܠܝܼܘܿܢ، ");
INSERT INTO aii_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","”ܒܸܬ ܩܲܒܸܠܔ ܚܲܕ ܒܡܵܐܐ ܐܵܕܝܼܵܐ ܒܐܵܗܵܐ ܙܲܒ݂ܢܵܐ، ܒܵܬܹ̈‌ܐ ܘܐܲܚܘܿܢܘܵܬܹ̈‌ܐ ܘܚܵܬܘܵܬܹ̈‌ܐ، ܘܝܸܡܵܬܹ̈‌ܐ ܘܒܢܘܿܢܹ̈ܐ، ܘܚܲܩܠܵܢܹ̈ܐ، ܥܲܡ ܪܕܘܼܦܝܵܐ، ܘܒܙܲܒ݂ܢܵܐ ܕܐܵܬܹ‌ܐ ܚܲܝܹ̈ܐ ܕܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","”ܪܵܒܵܐ ܕܝܼܢܵܐ ܩܲܕܡܵܝܹ̈ܐ ܒܸܬ ܗܵܘܝܼ ܐܚܵܪ̈ܵܝܹܐ، ܘܐܚܵܪ̈ܵܝܹܐ ܒܸܬ ܗܵܘܝܼ ܩܲܕܡܵܝܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ܟܲܕ ܒܹܐܣܵܩܵܐ ܝܗܘܵܘ ܒܐܘܼܪܚܵܐ ܠܐܘܿܪܸܫܠܸܡ، ܘܝܼܫܘܿܥ ܒܹܐܙܵܠܵܐ ܝܗܘܵܐ ܩܲܕܡܵܝܗ‌ܝ، ܥܲܓ̰ܒܝܼ ܗܘܵܘ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ܘܙܵܕܥܝܼ ܗܘܵܘ ܐܵܢܝܼ ܕܐܵܙܠ݇ܝܼ ܗܘܵܘ ܒܵܬܪܹܗ. ܘܠܘܼܒܸܠܔ ܠܹܗ ܠܬܪܸܥܣܲܪ ܠܚܲܕ ܓܹܒܵܐ ܘܫܘܼܪܹܐ ܠܹܗ ܠܹܐܡܵܪܵܐ ܐܸܠܵܝܗ‌ܝ ܡܸܢܕܝܼ ܕܗܕܝܼܪܵܐ ܝܗܘܵܐ ܕܩܲܘܸܡ ܗܘܵܐ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ܐܡܝܼܪܹܗ: ”ܗܵܐ ܒܹܐܣܵܩܵܐ ܝܘܲܚ ܠܐܘܿܪܸܫܠܸܡ، ܘܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܸܬ ܦܵܐܹܫ ܣܘܼܦܝܵܐ ܠܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܠܣܵܦܪܹ̈ܐ، ܘܒܸܬ ܕܵܝܢܝܼ ܠܹܗ ܠܡܵܘܬܵ‌ܐ ܘܒܸܬ ܣܲܦܝܼ ܠܹܗ ܠܐܸܡܘܵܬܹ̈‌ܐ، ");
INSERT INTO aii_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","”ܘܐܵܢܝܼ ܒܸܬ ܡܲܣܚܸܪܝܼ ܒܝܼܹܗ ܘܡܵܚܝܼ ܠܹܗ ܒܫܵܘܛܹ̈ܐ ܘܪܵܝܩܝܼ ܥܲܠܘܼܗ‌ܝ ܘܩܵܛܠܝܼ ܠܹܗ. ܘܒܝܵܘܡܵܐ ܕܬܠܵܬܵ‌ܐ ܒܸܬ ܩܵܐܹܡ.“ ");
INSERT INTO aii_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܝܲܥܩܘܿܒ݂ ܘܝܘܿܚܲܢܵܢ، ܒܢܘܿܢܹ̈ܐ ܕܙܲܒ݂ܕܲܝ، ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܡܲܠܦܵܢܵܐ، ܒܵܥܲܚ ܕܥܵܒ݂ܕܹܬ ܐܸܠܲܢ ܟܠܔ ܡܸܢܕܝܼ ܕܛܵܠܒܲܚ ܡܸܢܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܡܘܼܕܝܼ ܒܵܥܹܝܬܘܿܢ ܕܥܵܒ݂ܕܹܢ ܐܸܠܵܘܟ݂ܘܿܢ؟“ ");
INSERT INTO aii_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܐܸܠܹܗ: ”ܒܵܥܲܚ ܕܚܲܕ ܡܸܢܲܢ ܝܵܬܹܒ݂ ܡ̣ܢ ܝܲܡܝܼܢܘܼܟ݂ ܘܚܲܕ ܡ̣ܢ ܣܸܡܵܠܘܼܟ݂، ܒܚܸܩܪܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ܐܝܼܢܵܐ ܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ ܒܹܐܡܵܪܵܐ ܐܸܠܵܝܗ‌ܝ: ”ܠܹܐ ܝܬܘܿܢ ܒܝܼܕܵܥܵܐ ܡܘܼܕܝܼ ܒܸܛܠܵܒܵܐ ܝܬܘܿܢ. ܡܵܨܹܝܬܘܿܢ ܫܵܬܹܝܬܘܿܢ ܟܵܣܵܐ ܕܐܵܢܵܐ ܫܵܬܹܢܹܗ، ܘܡܲܥܡܘܿܕܝܼܬܵ‌ܐ ܕܒܝܼܘܼܗ̇ ܦܵܝܫܹܢ ܥܡܝܼܕܵܐ، ܥܵܡܕܝܼܬܘܿܢ؟“ ");
INSERT INTO aii_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ܐܵܢܝܼ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܐܸܠܹܗ: ”ܗܹܐ، ܟܹܐ ܡܵܨܲܚ.“ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܟܵܣܵܐ ܕܫܵܬܹܢܹܗ ܒܸܬ ܫܵܬܹܝܬܘܿܢ، ܘܡܲܥܡܘܿܕܝܼܬܵ‌ܐ ܕܒܝܼܘܼܗ̇ ܦܵܝܫܹܢ ܥܡܝܼܕܵܐ، ܒܸܬ ܥܵܡܕܝܼܬܘܿܢ، ");
INSERT INTO aii_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","”ܐܝܼܢܵܐ ܝܬܵܒ݂ܬܵ‌ܐ ܡ̣ܢ ܝܲܡܝܼܢܝܼ ܘܡ̣ܢ ܣܸܡܵܠܝܼ ܠܹܐ ܝܠܵܗ̇ ܕܐܵܢܵܐ ܝܵܗܒܹܢܵܗ̇، ܐܸܠܵܐ ܒܸܬ ܦܵܝܫܵܐ ܝܘܼܗܒܹܠܬܵ‌ܐ ܠܐܵܢܝܼ ܕܦܝܼܫܬܵ‌ܐ ܝܠܵܗ̇ ܗܘܼܕܸܪܬܵ‌ܐ ܩܵܬܵܝܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܗܘܿܢ ܥܸܣܪܵܐ ܬܲܠܡܝܼ̈ܕܹܐ ܐܚܹܪ̈ܢܹܐ، ܟܪܝܼܒ ܠܗܘܿܢ ܥܲܠܔ ܝܲܥܩܘܿܒ݂ ܘܝܘܿܚܲܢܵܢ. ");
INSERT INTO aii_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܩܸܪܝܵܝ ܠܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܟܹܐ ܝܵܕܥܝܼܬܘܿܢ ܐܵܢܝܼ ܕܚܵܫܒ݂ܝܼ ܕܓܘܼܪ̈ܵܢܹܐ ܕܐܸܡܘܵܬܹ̈‌ܐ ܝܢܵܐ ܟܹܐ ܥܵܒ݂ܕܝܼ ܡܵܪܘܼܬܵ‌ܐ، ܘܓܘܼܪ̈ܵܢܵܝܗ‌ܝ ܟܹܐ ܥܵܒ݂ܕܝܼ ܫܘܼܠܛܵܢܵܐ ܥܲܠܵܝܗ‌ܝ؟ ");
INSERT INTO aii_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","”ܐܝܼܢܵܐ ܐܵܗܵܐ ܡܸܢܕܝܼ ܠܵܐ ܗܵܘܹܐ ܓܵܘܵܘܟ݂ܘܿܢ. ܡ̇ܢ ܕܒܵܥܹܐ ܗܵܘܹܐ ܓܘܼܪܵܐ ܓܵܘܵܘܟ݂ܘܿܢ، ܗܵܘܹܐ ܥܵܒ݂ܕܵܢܵܐ ܕܚܸܠܡܲܬ ܐܸܠܵܘܟ݂ܘܿܢ، ");
INSERT INTO aii_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","”ܘܡ̇ܢ ܕܒܵܥܹܐ ܡܸܢܵܘܟ݂ܘܿܢ ܗܵܘܹܐ ܩܲܕܡܵܝܵܐ، ܗܵܘܹܐ ܥܲܒ݂ܕܵܐ ܕܟܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","”ܣܵܒܵܒ ܐܘܼܦ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܠܵܐ ܐܬܹ‌ܐ ܠܹܗ ܕܐܢܵܫܹ̈ܐ ܥܵܒ݂ܕܝܼ ܠܹܗ ܚܸܠܡܲܬ، ܐܸܠܵܐ ܕܗ̇ܘ ܥܵܒܹܕ ܚܸܠܡܲܬ ܠܐܢܵܫܹ̈ܐ ܘܕܝܵܗܒܹܠܔ ܓܵܢܹܗ ܕܸܒ݂ܚܵܐ ܕܦܘܼܪܩܵܢܵܐ ܡ̣ܢ ܓܹܒܵܐ ܕܪܵܒܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܠܐܝܼܪܝܼܚܘܿ. ܘܐܝܼܡܲܢ ܕܦܠܝܼܛ ܠܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܐܝܼܪܝܼܚܘܿ ܥܲܡ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܟܸܢܫܵܐ ܪܵܒܵܐ، ܚܲܕ ܣܸܡܝܵܐ ܫܸܡܹܗ ܛܝܼܡܲܝ، ܒܪܘܿܢܵܐ ܕܛܝܼܡܲܝ، ܝܬܝܼܒ݂ܵܐ ܝܗܘܵܐ ܥܲܠܔ ܡܲܪܙܵܐ ܕܐܘܼܪܚܵܐ ܘܒܸܓܒ݂ܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܹܗ ܕܝܼܫܘܿܥ ܢܵܨܪܵܝܵܐ ܝܗܘܵܐ، ܫܘܼܪܹܐ ܠܹܗ ܠܡܲܩܘܘܼܚܹܐ ܘܠܹܐܡܵܪܵܐ: ”ܒܪܘܿܢܵܐ ܕܕܵܘܝܼܕ، ܪܲܚܸܡ ܥܲܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ܪܵܒܵܐ ܐܢܵܫܹ̈ܐ ܢܓ̰ܝܼܘ ܠܗܘܿܢ ܒܝܼܹܗ ܕܫܵܬܹܩ ܗܘܵܐ، ܐܝܼܢܵܐ ܗ̇ܘ ܒܘܼܫ ܙܵܘܕܵܐ ܡܘܼܩܘܸܚ ܠܹܗ، ”ܒܪܘܿܢܵܐ ܕܕܵܘܝܼܕ، ܪܲܚܸܡ ܥܲܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ܟܠܹܐ ܠܹܗ ܝܼܫܘܿܥ ܘܦܩܝܼܕ ܠܹܗ ܕܡܲܝܬ‌ܝܼ ܠܹܗ ܠܟܸܣܠܹܗ. ܘܩܪܹܐ ܠܗܘܿܢ ܠܗ̇ܘ ܣܸܡܝܵܐ ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܗܘܝܼ ܠܸܒܵܢܵܐ، ܩܘܼܡ، ܒܸܩܪܵܝܘܼܟ݂ ܝܼܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ܘܗ̇ܘ ܣܸܡܝܵܐ ܪܘܼܦܝܵܐ ܠܹܗ ܠܒ݂ܝܼܫܬܹܗ ܘܩܝܼܡ ܠܹܗ ܘܐܙܝܼܠܔ ܠܹܗ ܠܟܸܣ ܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ܒܘܼܩܸܪܹܗ ܡܸܢܹܗ ܝܼܫܘܿܥ: ”ܡܘܼܕܝܼ ܒܵܥܹܝܬ ܕܥܵܒ݂ܕܹܢ ܐܸܠܘܼܟ݂؟“ ܓ̰ܘܼܘܸܒ ܠܹܗ ܗ̇ܘ ܣܸܡܝܵܐ ܒܹܐܡܵܪܵܐ: ”ܪܲܒܝܼ، ܒܵܥܹܝܢ ܕܚܵܙܹܝܢ.“ ");
INSERT INTO aii_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܙܹܠܔ݇، ܗܲܝܡܵܢܘܼܬܘܼܟ݂ ܩܵܡ ܒܵܣܡܵܐ ܠܘܼܟ݂.“ ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܚܙܹܐ ܠܹܗ ܘܐܙܝܼܠܔ ܠܹܗ ܒܵܬܪܹܗ ܒܐܘܼܪܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ܘܟܲܕ ܩܘܼܪܒܸܢܗܘܿܢ ܠܐܘܿܪܸܫܠܸܡ، ܥܲܠܔ ܓܹܒܵܐ ܕܒܹܝܬ ܦܵܓܹ̈ܐ ܘܒܹܝܬ ܥܲܢܝܵܐ، ܠܟܸܣ ܛܘܼܪܵܐ ܕܙܲܝ̈ܬܹ‌ܐ، ܫܘܼܕܸܪܹܗ ܝܼܫܘܿܥ ܬܪܹܝ ܡ̣ܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܙܹܠ݇ܡܘܼܢ ܠܐܵܗܵܐ ܡܵܬܵ‌ܐ ܕܝܼܠܵܗ̇ ܠܒܲܠܩܘܼܒ݂ܠܵܘܟ݂ܘܿܢ، ܘܐܝܼܡܲܢ ܕܥܵܒ݂ܪܝܼܬܘܿܢ ܓܵܘܘܼܗ̇ ܒܸܬ ܡܲܫ݇ܟ̰ܚܝܼܬܘܿܢ ܓ̰ܲܥܫܵܐ ܐܣܝܼܪܵܐ ܕܗܸܫ ܐܢܵܫܵܐ ܠܹܐ ܝܠܹܗ ܪܟܝܼܒ݂ܵܐ ܥܲܠܘܼܗ‌ܝ. ܫܪܹܝܡܘܼܢ ܘܡܲܝܬܹܝܡܘܼܢ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","”ܘܐܸܢ ܐܢܵܫܵܐ ܒܲܩܸܪܵܘܟ݂ܘܿܢ: ’ܩܵܡܘܿܕܝܼ ܒܸܥܒ݂ܵܕܵܐ ܝܬܘܿܢ ܐܵܗܵܐ؟‘ ܐܡܘܿܪܘܼܢ ܐܸܠܹܗ: ’ܡܵܪܲܢ ܒܵܥܹܐ ܠܹܗ، ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܒܸܬ ܫܲܕܸܪܹܗ ܠܲܐܟ݂ܵܐ.‘“ ");
INSERT INTO aii_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܘܚܙܹܐ ܠܗܘܿܢ ܠܓ̰ܲܥܫܵܐ ܐܣܝܼܪܵܐ ܩܲܕܡ ܬܲܪܥܵܐ ܠܒܲܕܲܪ ܒܥܵܠܘܿܠܵܐ، ܘܫܪܹܐ ܠܗܘܿܢ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ܐܢܵܫܹ̈ܐ ܕܟܸܠܝܹܐ ܝܗܘܵܘ ܬܵܡܵܐ ܒܘܼܩܸܪܗܘܿܢ: ”ܡܘܼܕܝܼ ܒܸܥܒ݂ܵܕܵܐ ܝܬܘܿܢ ܕܒܸܫܪܵܝܵܐ ܝܬܘܿܢ ܠܓ̰ܲܥܫܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ܘܐܵܢܝܼ ܐܡܝܼܪܗܘܿܢ ܐܸܠܵܝܗ‌ܝ ܕܵܐܟ݂ܝܼ ܕܦܩܝܼܕܵܝ ܝܗܘܵܐ ܝܼܫܘܿܥ. ܘܫܒ݂ܝܼܩܵܝ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ܘܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܓ̰ܲܥܫܵܐ ܠܟܸܣ ܝܼܫܘܿܥ ܘܕܪܹܐ ܠܗܘܿܢ ܥܲܠܘܼܗ‌ܝ ܓ̰ܘܼܠܵܝ̈ܗ‌ܝ، ܘܪܟܝܼܒ݂ ܠܹܗ ܥܲܠܘܼܗ‌ܝ ܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ܪܵܒܵܐ ܫܲܘܝܼ ܗܘܵܘ ܓ̰ܘܼܠܵܝ̈ܗ‌ܝ ܒܐܘܼܪܚܵܐ، ܘܐܚܹܪ̈ܢܹܐ ܦܵܪܡܝܼ ܗܘܵܘ ܦܲܥܘܵܢܹ̈ܐ ܕܐܝܼܠܵܢܹ̈ܐ ܡ̣ܢ ܓܵܘ ܚܲܩܠܵܢܹ̈ܐ، ܘܫܲܘܝܼ ܗܘܵܘ ܠܗܘܿܢ ܒܐܘܼܪܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ܘܐܵܢܝܼ ܕܒܹܐܙܵܠܵܐ ܝܗܘܵܘ ܩܲܕܡܘܼܗ‌ܝ ܘܒܵܬܪܹܗ ܡܲܩܘܸܚܝܼ ܗܘܵܘ: ”ܐܘܿܫܲܥܢܵܐ، ܒܪܝܼܟ݂ܵܐ ܝܠܹܗ ܗ̇ܘ ܕܒܹܐܬܵܝܵܐ ܝܠܹܗ ܒܫܸܡܵܐ ܕܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","”ܘܒܪܝܼܟ݂ܬܵ‌ܐ ܝܠܵܗ̇ ܡܲܠܟܘܼܬܵ‌ܐ ܕܒܵܒܲܢ ܕܵܘܝܼܕ ܕܒܹܐܬܵܝܵܐ ܝܠܵܗ̇، ܐܘܿܫܲܥܢܵܐ ܒܲܡܪ̈ܵܘܡܹܐ“ ");
INSERT INTO aii_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ܘܥܒ݂ܝܼܪܹܗ ܝܼܫܘܿܥ ܠܐܘܿܪܸܫܠܸܡ ܘܠܗܲܝܟܠܵܐ، ܘܚܝܼܪܹܗ ܠܚܵܕܸܪ̈ܘܵܢܘܼܗ‌ܝ ܒܟܠܔ ܡܸܢܕܝܼ. ܘܐܝܼܡܲܢ ܕܗܘܹܐ ܠܹܗ ܪܲܡܫܵܐ، ܦܠܝܼܛ ܠܹܗ ܠܒܹܝܬ ܥܲܢܝܵܐ ܥܲܡ ܬܪܸܥܣܲܪ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ܒܝܵܘܡܵܐ ܐܚܹܪܢܵܐ، ܐܝܼܡܲܢ ܕܦܠܝܼܛ ܠܗܘܿܢ ܝܼܫܘܿܥ ܘܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܡ̣ܢ ܒܹܝܬ ܥܲܢܝܵܐ، ܟܦܝܼܢܹܗ، ");
INSERT INTO aii_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ܘܚܙܹܐ ܠܹܗ ܚܲܕ ܐܝܼܠܵܢܵܐ ܕܬܹܐܢܹ̈ܐ ܡ̣ܢ ܪܸܚܩܵܐ ܕܐܝܼܬ ܗܘܵܐ ܒܝܼܹܗ ܛܲܪ̈ܦܹܐ. ܘܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣܠܹܗ ܒܗܹܒ݂ܝܼ ܕܡܲܫ݇ܟ̰ܸܚ ܗܘܵܐ ܒܝܼܹܗ ܡܸܢܕܝܼ، ܐܝܼܢܵܐ ܠܵܐ ܡܘܼܫ݇ܟ̰ܸܚ ܠܹܗ ܡܸܢܕܝܼ ܫܒ݂ܘܿܩ ܡ̣ܢ ܛܲܪ̈ܦܹܐ، ܣܵܒܵܒ ܠܹܐ ܝܗܘܵܐ ܥܕܵܢܵܐ ܕܬܹܐܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ܘܐܡܝܼܪܹܗ: ”ܡ̣ܢ ܐܵܕܝܼܵܐ ܘܗܲܠܔ ܥܵܠܲܡ ܠܵܐ ܐܵܟܹܠܔ ܐܢܵܫܵܐ ܡܸܢܘܼܟ݂ ܛܥܘܼܢܝܵܬܹ̈‌ܐ.“ ܘܫܡܝܼܥ ܠܗܘܿܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ܐܬܹ‌ܐ ܠܹܗ ܝܼܫܘܿܥ ܠܐܘܿܪܸܫܠܸܡ ܘܥܒ݂ܝܼܪܹܗ ܠܗܲܝܟܠܵܐ ܕܐܲܠܵܗܵܐ، ܘܫܘܼܪܹܐ ܠܹܗ ܠܦܲܠܘܼܛܹܐ ܠܐܵܢܝܼ ܕܒܸܙܒ݂ܵܢܵܐ ܝܗܘܵܘ ܘܙܲܒܘܼܢܹܐ ܓܵܘ ܗܲܝܟܠܵܐ، ܘܡܘܼܚܕܸܪܹܗ ܠܦܵܬܘܿܪܹ̈ܐ ܕܨܲܪ̈ܵܦܹܐ ܘܟܘܼܪ̈ܣܝܼܹܐ ܕܐܵܢܝܼ ܕܙܲܒܘܼܢܹܐ ܝܗܘܵܘ ܝܵܘܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ܘܠܵܐ ܫܒ݂ܝܼܩ ܠܹܗ ܐܢܵܫܵܐ ܕܡܲܥܒܸܪ ܗܘܵܐ ܡܵܐܢܵܐ ܓܵܘ ܗܲܝܟܠܵܐ، ");
INSERT INTO aii_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ܡܘܼܠܦܵܝ ܠܹܗ ܒܹܐܡܵܪܵܐ: ”ܠܹܐ ܝܠܹܗ ܟܬܝܼܒ݂ܵܐ ܕܒܲܝܬ‌ܝܼ ܒܲܝܬܵ‌ܐ ܕܨܠܘܿܬܵ‌ܐ ܒܸܬ ܦܵܐܹܫ ܩܸܪܝܵܐ ܠܟܠܵܝܗ‌ܝ ܐܸܡܘܵܬܹ̈‌ܐ؟ ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ ܥܒ݂ܝܼܕ ܠܵܘܟ݂ܘܿܢ ܓܸܦܝܼܬܵ‌ܐ ܕܓܲܝܵܣܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ܘܫܡܝܼܥ ܠܗܘܿܢ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܣܵܦܪܹ̈ܐ، ܘܛܥܹܐ ܠܗܘܿܢ ܕܵܐܟ݂ܝܼ ܩܵܛܠܝܼ ܗܘܵܘ ܠܹܗ، ܐܝܼܢܵܐ ܟܹܐ ܙܵܕܥܝܼ ܗܘܵܘ ܡܸܢܹܗ ܣܵܒܵܒ ܟܠܹܗ ܟܸܢܫܵܐ ܟܹܐ ܥܲܓ̰ܒܝܼ ܗܘܵܘ ܒܝܘܼܠܦܵܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ܐܝܼܡܲܢ ܕܗܘܹܐ ܠܹܗ ܪܲܡܫܵܐ، ܦܠܝܼܛ ܠܗܘܿܢ ܠܒܲܕܲܪ ܡ̣ܢ ܡܕܝܼܢ݇ܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ܒܨܲܦܪܵܐ ܟܲܕ ܒܹܐܙܵܠܵܐ ܝܗܘܵܘ ܝܼܫܘܿܥ ܘܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܒܐܘܼܪܚܵܐ، ܚܙܹܐ ܠܗܘܿܢ ܠܗ̇ܘ ܐܝܼܠܵܢܵܐ ܕܬܹܐܢܹ̈ܐ ܒܪܝܼܙܵܐ ܡ̣ܢ ܥܸܩܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ܕܟ݂ܝܼܪܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܪܲܒܝܼ، ܗܵܐ ܗ̇ܘ ܐܝܼܠܵܢܵܐ ܕܬܹܐܢܹ̈ܐ ܕܠܝܼܛ ܠܘܼܟ݂، ܒܪܝܼܙ ܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܒܹܐܡܵܪܵܐ ܐܸܠܹܗ: ”ܗܵܘܝܵܐ ܒܝܼܵܘܟ݂ܘܿܢ ܗܲܝܡܵܢܘܼܬܵ‌ܐ ܒܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܡ̇ܢ ܕܐܵܡܹܪ ܠܐܵܗܵܐ ܛܘܼܪܵܐ: ’ܦܘܼܫ ܫܩܝܼܠܵܐ ܘܪܘܼܦܝܵܐ ܒܝܵܡܵܐ،‘ ܘܠܵܐ ܗܵܘܹܐ ܦܘܼܠܵܓ݂ܵܐ ܒܠܸܒܹܗ، ܐܸܠܵܐ ܗܲܡܸܢ ܕܡܸܢܕܝܼ ܕܛܵܠܹܒ ܒܸܬ ܗܵܘܹܐ، ܒܸܬ ܦܵܐܹܫ ܥܒ݂ܝܼܕܵܐ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","”ܒܘܼܬ ܐܵܗܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ: ܟܠܔ ܡܸܢܕܝܼ ܕܛܵܠܒܝܼܬܘܿܢ ܒܨܠܘܿܬܵ‌ܐ، ܘܗܲܡܸܢܝܼܬܘܿܢ ܕܒܸܬ ܫܵܩܠܝܼܬܘܿܢ، ܒܸܬ ܗܵܘܹܐ ܐܸܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","”ܘܐܝܼܡܲܢ ܕܟܵܠܹܝܬܘܿܢ ܠܨܲܠܘܼܝܹܐ، ܦܲܚܠܘܼܢ ܠܐܢܵܫܵܐ ܡܸܢܕܝܼ ܕܐܝܼܬ ܠܵܘܟ݂ܘܿܢ ܥܲܠܘܼܗ‌ܝ، ܕܐܘܼܦ ܒܵܒܵܘܟ݂ܘܿܢ ܕܒܫܡܲܝܵܐ ܦܲܚܸܠܔ ܐܸܠܵܘܟ݂ܘܿܢ ܓܢܵܗܵܘ̈ܟ݂ܘܿܢ، ");
INSERT INTO aii_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","”ܐܝܼܢܵܐ ܐܸܢ ܠܵܐ ܦܲܚܠܝܼܬܘܿܢ، ܐܘܼܦ ܒܵܒܵܘܟ݂ܘܿܢ ܕܒܫܡܲܝܵܐ ܠܹܐ ܦܲܚܸܠܔ ܐܸܠܵܘܟ݂ܘܿܢ ܓܢܵܗܵܘ̈ܟ݂ܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ܐܬܹ‌ܐ ܠܗܘܿܢ ܡܸܢܕܪܸܫ ܠܐܘܿܪܸܫܠܸܡ، ܘܟܲܕ ܒܸܚܕܵܪܵܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܓܵܘ ܗܲܝܟܠܵܐ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܣܵܦܪܹ̈ܐ ܘܚܘܵܪ̈ܕܸܩܢܹܐ، ");
INSERT INTO aii_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ܘܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ: ”ܒܐܲܝܢܝܼ ܫܘܼܠܛܵܢܵܐ ܒܸܥܒ݂ܵܕܵܐ ܝܘܸܬ ܐܲܢܹܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܒܹܐܡܵܪܵܐ: ”ܐܘܼܦ ܐܵܢܵܐ ܒܸܬ ܒܲܩܪܸܢܵܘܟ݂ܘܿܢ ܚܲܕ ܒܘܼܩܵܪܵܐ. ܐܸܢ ܓ̰ܲܘܸܒܝܼܬܘܿܢ ܠܝܼ ܐܘܼܦ ܐܵܢܵܐ ܒܸܬ ܐܵܡܪܹܢ ܐܸܠܵܘܟ݂ܘܿܢ ܒܐܲܝܢܝܼ ܫܘܼܠܛܵܢܵܐ ܒܸܥܒ݂ܵܕܵܐ ܝܘܸܢ ܐܲܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","”ܡܲܥܡܘܿܕܝܼܬܵ‌ܐ ܕܝܘܿܚܲܢܵܢ ܡ̣ܢ ܐܲܝܟܵܐ ܝܗܘܵܐ، ܡ̣ܢ ܫܡܲܝܵܐ ܝܲܢ ܡ̣ܢ ܒܢܲܝ̈ܢܵܫܵܐ؟ ܐܡܘܿܪܘܼܢ ܐܸܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ܐܵܢܝܼ ܬܘܼܚܡܸܢܗܘܿܢ ܓܵܘ ܓܵܢܵܝܗ‌ܝ ܒܹܐܡܵܪܵܐ: ”ܐܸܢ ܐܵܡܪܲܚ ܡ̣ܢ ܫܡܲܝܵܐ، ܒܸܬ ܐܵܡܹܪ ܐܸܠܲܢ: ’ܩܵܡܘܿܕܝܼ ܠܵܐ ܗܘܼܡܸܢܵܘܟ݂ܘܿܢ ܒܝܼܹܗ؟‘ ");
INSERT INTO aii_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","”ܘܐܸܢ ܐܵܡܪܲܚ ܡ̣ܢ ܒܢܲܝ̈ܢܵܫܵܐ.“ (ܒܸܙܕܵܥܵܐ ܝܗܘܵܘ ܡ̣ܢ ܥܲܡܵܐ، ܣܵܒܵܒ ܟܠܵܝܗ‌ܝ ܐܢܵܫܹ̈ܐ ܒܫܲܪܝܼܪܘܼܬܵ‌ܐ ܐܲܝܟ݂ ܢܒ݂ܝܼܵܐ ܟܹܐ ܚܵܫܒ݂ܝܼ ܗܘܵܘ ܠܝܘܿܚܲܢܵܢ.) ");
INSERT INTO aii_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܒܹܐܡܵܪܵܐ ܐܸܠܹܗ: ”ܠܹܐ ܝܵܕܥܲܚ.“ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܐܘܼܦ ܐܵܢܵܐ ܠܹܐ ܐܵܡܪܹܢ ܐܸܠܵܘܟ݂ܘܿܢ ܒܐܲܝܢܝܼ ܫܘܼܠܛܵܢܵܐ ܒܸܥܒ݂ܵܕܵܐ ܝܘܸܢ ܐܲܢܹܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ܫܘܼܪܹܐ ܠܹܗ ܝܼܫܘܿܥ ܠܗܲܡܙܘܼܡܹܐ ܐܸܠܵܝܗ‌ܝ ܒܡܲܬܠܹ̈ܐ، ܘܐܡܝܼܪܹܗ: ”ܚܲܕ ܐܢܵܫܵܐ ܢܨܝܼܒ݂ ܠܹܗ ܟܲܪܡܵܐ، ܘܡܚܹܐ ܠܹܗ ܠܚܵܕܸܪ̈ܘܵܢܘܼܗ‌ܝ ܣܝܵܓ݂ܵܐ، ܘܚܦܝܼܪܹܗ ܓܵܘܹܗ ܡܲܥܨܲܪܬܵ‌ܐ، ܘܒܢܹܐ ܠܹܗ ܓܵܘܹܗ ܒܘܼܪܓ̰ܵܐ، ܘܣܘܼܦܹܐ ܠܹܗ ܠܦܲܠܵܚܹ̈ܐ، ܘܐܙܝܼܠܔ ܠܹܗ ܒܣܵܦܵܪ. ");
INSERT INTO aii_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","”ܘܐܝܼܡܲܢ ܕܡܛܹܐ ܠܵܗ̇ ܥܕܵܢܵܐ ܕܛܥܘܼܢܝܵܬܹ̈‌ܐ، ܫܘܼܕܸܪܹܗ ܪܹܓܹܗ ܠܟܸܣ ܦܲܠܵܚܹ̈ܐ ܕܫܵܩܹܠܔ ܗܘܵܐ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܡ̣ܢ ܟܲܪܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","”ܐܝܼܢܵܐ ܐܵܢܝܼ ܦܲܠܵܚܹ̈ܐ ܕܒ݂ܝܼܩ ܠܗܘܿܢ ܘܡܚܹܐ ܠܗܘܿܢ ܐܸܠܹܗ، ܘܫܘܼܕܸܪܗܘܿܢ ܣܦܝܼܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","”ܫܘܼܕܸܪܹܗ ܡܸܢܕܪܸܫ ܚܲܕ ܪܹܓܵܐ ܐܚܹܪܢܵܐ، ܘܠܗ̇ܘ ܕܘܼܪܒܸܢܗܘܿܢ ܪܹܝܫܹܗ ܘܡܘܼܣܠܹܐ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ܘܫܘܼܕܸܪܹܗ ܪܹܓܵܐ ܐܚܹܪܢܵܐ، ܘܠܗ̇ܘ ܩܛܝܼܠܔ ܠܗܘܿܢ. ܘܠܪܵܒܵܐ ܐܚܹܪ̈ܢܹܐ ܕܫܘܼܕܸܪܹܗ، ܡܸܢܵܝܗ‌ܝ ܡܚܹܐ ܠܗܘܿܢ، ܘܡܸܢܵܝܗ‌ܝ ܩܛܝܼܠܔ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","”ܒܚܲܪܬܵ‌ܐ ܐܝܼܬ ܗܘܵܐ ܠܹܗ ܦܝܵܫܵܐ ܚܲܕ ܒܪܘܿܢܵܐ ܡܘܼܚܸܒܵܐ. ܫܘܼܕܸܪܹܗ ܠܟܸܣܠܵܝܗ‌ܝ، ܒܹܐܡܵܪܵܐ: ’ܒܸܬ ܢܵܟ݂ܦܝܼ ܡ̣ܢ ܒܪܘܿܢܝܼ.‘ ");
INSERT INTO aii_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","”ܐܝܼܢܵܐ ܦܲܠܵܚܹ̈ܐ ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܗܘܿܢ ܠܒܪܘܿܢܵܐ ܐܡܝܼܪܗܘܿܢ ܒܓܵܢܵܝܗ‌ܝ: ’ܐܵܗܵܐ ܝܠܹܗ ܝܵܪܘܿܬܵ‌ܐ، ܬܹܝܡܘܼܢ ܩܵܛܠܲܚ ܠܹܗ، ܘܒܸܬ ܗܵܘܝܵܐ ܕܝܼܲܢ ܝܵܪܬܘܼܬܵ‌ܐ.‘ ");
INSERT INTO aii_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","”ܕܒ݂ܝܼܩ ܠܗܘܿܢ ܘܩܛܝܼܠܔ ܠܗܘܿܢ ܐܸܠܹܗ، ܘܪܘܼܦܹܐ ܠܗܘܿܢ ܐܸܠܹܗ ܠܒܲܕܲܪ ܡ̣ܢ ܟܲܪܡܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ܘܒܘܼܩܸܪܹܗ ܝܼܫܘܿܥ: ”ܡܘܼܕܝܼ ܒܸܬ ܥܵܒܹܕ ܡܵܪܵܐ ܕܟܲܪܡܵܐ؟ ܒܸܬ ܐܵܬܹ‌ܐ ܘܒܸܬ ܩܵܛܹܠܔ ܠܐܵܢܝܼ ܦܲܠܵܚܹ̈ܐ، ܘܒܸܬ ܝܵܗܒܹܠܔ ܟܲܪܡܵܐ ܠܦܲܠܵܚܹ̈ܐ ܐܚܹܪ̈ܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","”ܠܵܐ ܩܪܹܐ ܠܵܘܟ݂ܘܿܢ ܓܵܘ ܟܬܵܒ݂ܵܐ: ܟܹܐܦܵܐ ܕܡܘܼܣܠܹܐ ܠܗܘܿܢ ܒܲܢܵܝܹ̈ܐ، ܗ̇ܘ ܗܘܹܐ ܠܹܗ ܟܹܐܦܵܐ ܕܩܘܼܪܢܝܼܬܵ‌ܐ؟ ");
INSERT INTO aii_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","”ܡ̣ܢ ܡܵܪܝܵܐ ܝܗܘܵܐ ܐܵܗܵܐ ܘܥܘܼܓ̰ܵܒܵܐ ܝܠܹܗ ܒܥܲܝܢܲܢ̈.“ ");
INSERT INTO aii_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ܘܒܥܹܐ ܠܗܘܿܢ ܠܸܕܒ݂ܵܩܹܗ، ܣܵܒܵܒ ܝܕܝܼܥ ܠܗܘܿܢ ܕܥܲܠܵܝܗ‌ܝ ܡܚܹܐ ܠܹܗ ܐܵܗܵܐ ܡܲܬܠܵܐ، ܐܝܼܢܵܐ ܙܕܝܼܥ ܠܗܘܿܢ ܡ̣ܢ ܟܸܢܫܵܐ. ܘܫܒ݂ܝܼܩ ܠܗܘܿܢ ܐܸܠܹܗ ܘܐܙܝܼܠܔ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ܘܫܘܼܕܸܪܗܘܿܢ ܠܟܸܣܠܹܗ ܐܢܵܫܹ̈ܐ ܡ̣ܢ ܦܪ̈ܝܼܫܹܐ ܘܡ̣ܢ ܒܹܝܬ ܗܹܪܘܿܕܸܣ ܕܡܲܢܦܸܠܝܼ ܗܘܵܘ ܠܹܗ ܒܗܹܡܸܙܡܵܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ܐܲܢܹܐ ܐܢܵܫܹ̈ܐ ܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܡܲܠܦܵܢܵܐ، ܒܝܼܕܵܥܵܐ ܝܘܲܚ ܕܫܲܪܝܼܪܵܐ ܝܘܸܬ، ܘܠܹܐ ܬܲܚܡܸܢܸܬ ܡܘܼܕܝܼ ܐܢܵܫܹ̈ܐ ܒܸܬ ܐܵܡܪܝܼ، ܘܠܹܐ ܝܘܸܬ ܡܲܫܦܸܪܵܢܵܐ، ܐܸܠܵܐ ܒܫܲܪܝܼܪܘܼܬܵ‌ܐ ܟܹܐ ܡܲܠܦܸܬ ܐܘܼܪܚܵܐ ܕܐܲܠܵܗܵܐ. ܩܵܢܘܿܢܵܝܬܵ‌ܐ ܝܠܵܗ̇ ܕܝܵܗܒܲܚ ܟܸܣܦܵܐ ܕܪܹܝܫܵܐ ܩܵܐ ܩܹܣܲܪ ܝܲܢ ܠܵܐ؟ ܝܵܗܒܲܚ ܝܲܢ ܠܵܐ ܝܵܗܒܲܚ؟“ ");
INSERT INTO aii_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ܐܝܼܢܵܐ ܗ̇ܘ ܝܕܝܼܥ ܠܹܗ ܡܲܫܦܲܪܬܵܝܗ‌ܝ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܩܵܡܘܿܕܝܼ ܓ̰ܲܪܘܼܒܝܼ ܝܬܘܿܢ؟ ܡܲܝܬܹܝܡܘܼܢ ܠܝܼ ܚܲܕ ܕܝܼܢܵܪܵܐ ܕܚܵܙܹܢܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ܘܡܘܼܚܙܹܐ ܠܗܘܿܢ ܐܸܠܹܗ. ܘܗ̇ܘ ܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ: ”ܕܡܵܢܝܼ ܝܠܵܗ̇ ܐܵܗܵܐ ܨܘܼܪܬܵ‌ܐ، ܘܕܡܵܢܝܼ ܝܠܵܗ̇ ܐܵܗܵܐ ܟܬܝܼܒ݂ܬܵ‌ܐ؟“ ܘܐܵܢܝܼ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ: ”ܕܩܹܣܲܪ.“ ");
INSERT INTO aii_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܗܲܒ݂ܠܘܼܢ ܡܸܢܕܝܼ ܕܩܹܣܲܪ ܠܩܹܣܲܪ، ܘܡܸܢܕܝܼ ܕܐܲܠܵܗܵܐ ܠܐܲܠܵܗܵܐ.“ ܘܥܘܼܓ̰ܸܒ ܠܗܘܿܢ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܙܲܕܘܼܩܵܝܹ̈ܐ، ܐܵܢܝܼ ܕܠܹܐ ܗܲܡܸܢܝܼ ܒܩܝܵܡܬܵ‌ܐ ܡ̣ܢ ܓܵܘ ܡܝܼ̈ܬܹ‌ܐ، ܘܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ ܒܹܐܡܵܪܵܐ: ");
INSERT INTO aii_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","”ܡܲܠܦܵܢܵܐ، ܡܘܼܫܹܐ ܟܬܝܼܒ݂ ܠܹܗ ܐܸܠܲܢ ܒܹܐܡܵܪܵܐ، ܐܸܢ ܡܵܐܹܬ ܐܲܚܘܿܢܵܐ ܕܐܢܵܫܵܐ ܘܦܵܝܫܵܐ ܒܲܟ݂ܬܹܗ ܘܟܲܕ ܠܲܝܬ ܠܹܗ ܒܢܘܿܢܹ̈ܐ، ܫܵܩܹܠܔ ܗ̇ܘ ܐܢܵܫܵܐ ܠܒܲܟ݂ܬܵ‌ܐ ܘܡܲܩܸܡ ܒܢܘܿܢܹ̈ܐ ܠܐܲܚܘܿܢܘܼܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","”ܐܝܼܬ ܗܘܵܘ ܫܲܒ݂ܥܵܐ ܐܲܚܘܿܢܘܵܬܹ̈‌ܐ. ܗ̇ܘ ܩܲܕܡܵܝܵܐ ܓܒ݂ܝܼܪܹܗ ܒܲܟ݂ܬܵ‌ܐ ܘܡܝܼܬ ܠܹܗ، ܘܠܲܝܬ ܗܘܵܐ ܠܹܗ ܒܢܘܿܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","”ܗ̇ܘ ܕܬܪܹܝ ܓܒ݂ܝܼܪܹܗ ܒܲܟ݂ܬܵ‌ܐ ܕܐܲܚܘܿܢܘܼܗ‌ܝ ܘܡܝܼܬ ܠܹܗ، ܐܘܼܦ ܗ̇ܘ ܠܲܝܬ ܗܘܵܐ ܠܹܗ ܒܢܘܿܢܹ̈ܐ، ܗܵܕܟ݂ܵܐ ܐܘܼܦ ܗ̇ܘ ܕܬܠܵܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","”ܫܲܒ݂ܥܘܿܢܬܵܝܗ‌ܝ ܓܒ݂ܝܼܪܵܐ ܠܗܘܿܢ ܗ̇ܝ ܒܲܟ݂ܬܵ‌ܐ ܘܠܵܐ ܩܵܡ ܗܵܘܹܐ ܠܗܘܿܢ ܒܢܘܿܢܹ̈ܐ. ܘܒܚܲܪܬܵ‌ܐ ܕܟܠܵܝܗ‌ܝ ܐܘܼܦ ܗ̇ܝ ܒܲܟ݂ܬܵ‌ܐ ܡܝܼܬ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","”ܒܩܝܵܡܬܵ‌ܐ، ܒܲܟ݂ܬܵ‌ܐ ܕܐܲܝܢܝܼ ܡܸܢܵܝܗ‌ܝ ܒܸܬ ܗܵܘܝܵܐ؟ ܣܵܒܵܒ ܫܲܒ݂ܥܘܿܢܬܵܝܗ‌ܝ ܓܒ݂ܝܼܪܵܐ ܠܗܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܠܹܐ ܝܠܵܗ̇ ܒܘܼܬ ܐܵܗܵܐ ܒܸܚܠܵܛܵܐ ܝܬܘܿܢ ܕܠܹܐ ܝܬܘܿܢ ܒܝܼܕܵܥܵܐ ܟܬܵܒܹ̈ܐ ܘܠܵܐ ܚܲܝܠܵܐ ܕܐܲܠܵܗܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","”ܣܵܒܵܒ ܒܩܝܵܡܬܵ‌ܐ ܕܡܝܼ̈ܬܹ‌ܐ، ܠܹܐ ܓܵܒ݂ܪܝܼ ܘܠܹܐ ܡܲܓܒܸܪܝܼ، ܐܸܠܵܐ ܐܲܝܟ݂ ܡܲܠܲܐܟܹ̈ܐ ܕܒܫܡܲܝܵܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","”ܒܘܼܬ ܩܝܵܡܬܵ‌ܐ ܕܡܝܼ̈ܬܹ‌ܐ، ܠܵܐ ܩܪܹܐ ܠܵܘܟ݂ܘܿܢ ܓܵܘ ܟܬܵܒ݂ܵܐ ܕܡܘܼܫܹܐ، ܕܵܐܟ݂ܝܼ ܡ̣ܢ ܓܵܘ ܣܲܢܝܵܐ ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܐܲܠܵܗܵܐ: ’ܐܵܢܵܐ ܝܘܸܢ ܐܲܠܵܗܵܐ ܕܐܲܒ݂ܪܵܗܵܡ، ܘܐܲܠܵܗܵܐ ܕܐܝܼܣܚܵܩ ܘܐܲܠܵܗܵܐ ܕܝܲܥܩܘܿܒ݂‘؟ ");
INSERT INTO aii_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","”ܐܲܠܵܗܵܐ ܠܹܐ ܝܠܹܗ ܐܲܠܵܗܵܐ ܕܡܝܼ̈ܬܹ‌ܐ، ܐܸܠܵܐ ܕܚܵܝܹ̈ܐ. ܐܲܚܬܘܿܢ ܪܵܒܵܐ ܒܸܚܠܵܛܵܐ ܝܬܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ܘܐܬܹ‌ܐ ܠܹܗ ܚܲܕ ܐܢܵܫܵܐ ܡ̣ܢ ܣܵܦܪܹ̈ܐ ܘܫܡܝܼܥܵܝ ܠܹܗ ܒܸܕܪܵܫܵܐ. ܘܐܝܼܡܲܢ ܕܚܙܹܐ ܠܹܗ ܕܨܦܵܝܝܼ ܓ̰ܘܼܘܸܒ ܠܹܗ ܠܙܲܕܘܼܩܵܝܹ̈ܐ، ܒܘܼܩܸܪܹܗ ܡ̣ܢ ܝܼܫܘܿܥ: ”ܐܲܝܢܝܼ ܦܘܼܩܕܵܢܵܐ ܩܲܕܡܵܝܵܐ ܝܠܹܗ ܕܟܠܵܝܗ‌ܝ ܦܘܼܩܕܵܢܹ̈ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܗ̇ܘ ܦܘܼܩܕܵܢܵܐ ܩܲܕܡܵܝܵܐ ܐܵܗܵܐ ܝܠܹܗ: ܫܡܹܥ ܐܝܼܣܪܵܐܹܝܠܔ، ܡܵܪܝܵܐ ܐܲܠܵܗܲܢ ܡܵܪܝܵܐ ܚܲܕ ܝܼܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","”ܘܡܲܚܸܒܸܬ ܠܡܵܪܝܵܐ ܐܲܠܵܗܘܼܟ݂ ܡ̣ܢ ܟܠܹܗ ܠܸܒܘܼܟ݂، ܘܡ̣ܢ ܟܠܹܗ ܓܵܢܘܼܟ݂، ܘܡ̣ܢ ܟܠܹܗ ܪܸܥܝܵܢܘܼܟ݂، ܘܡ̣ܢ ܟܠܹܗ ܚܲܝܠܘܼܟ݂. ܐܵܗܵܐ ܝܠܹܗ ܗ̇ܘ ܦܘܼܩܕܵܢܵܐ ܩܲܕܡܵܝܵܐ، ");
INSERT INTO aii_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","”ܘܦܘܼܩܕܵܢܵܐ ܕܬܪܹܝ ܟܹܐ ܕܵܡܹܐ ܐܸܠܹܗ، ܕܡܲܚܸܒܸܬ ܠܫܒ݂ܵܒ݂ܘܼܟ݂ ܐܲܝܟ݂ ܓܵܢܘܼܟ݂. ܠܲܝܬ ܦܘܼܩܕܵܢܵܐ ܒܘܼܫ ܓܘܼܪܵܐ ܡ̣ܢ ܐܲܢܹܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ܓ̰ܘܼܘܸܒ ܠܹܗ ܗ̇ܘ ܣܵܦܪܵܐ: ”ܨܦܵܝܝܼ ܪܲܒܝܼ، ܒܫܲܪܝܼܪܘܼܬܵ‌ܐ ܗܘܼܡܙܸܡ ܠܘܼܟ݂، ܕܚܲܕ ܝܼܠܹܗ ܐܲܠܵܗܵܐ، ܘܠܲܝܬ ܚܲܕ ܐܚܹܪܢܵܐ ܫܒ݂ܘܿܩ ܡܸܢܹܗ، ");
INSERT INTO aii_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","”ܘܕܡܲܚܸܒ ܠܹܗ ܐܢܵܫܵܐ ܡ̣ܢ ܟܠܹܗ ܠܸܒܹܗ، ܘܡ̣ܢ ܟܠܹܗ ܚܝܼܵܠܹܗ، ܘܡ̣ܢ ܟܠܹܗ ܓܵܢܹܗ، ܘܡ̣ܢ ܟܠܹܗ ܪܸܥܝܵܢܹܗ، ܘܕܡܲܚܸܒ ܠܫܒ݂ܵܒܹܗ ܐܲܝܟ݂ ܕܠܓܵܢܹܗ، ܐܵܗܵܐ ܙܵܘܕܵܐ ܝܠܹܗ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܕܸܒ݂ܚܹ̈ܐ ܡܘܼܩܕܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ܝܼܫܘܿܥ ܚܙܹܐ ܠܹܗ ܒܗܵܘܢܵܢܘܼܬܵ‌ܐ ܓ̰ܘܼܘܸܒ ܠܹܗ، ܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܠܹܐ ܝܘܸܬ ܪܸܚܩܵܐ ܡ̣ܢ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ.“ ܘܠܵܐ ܐܢܵܫܵܐ ܩܘܼܫܕܸܪܹܗ ܙܵܘܕܵܐ ܠܒܲܩܘܼܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ܟܲܕ ܡܲܠܘܼܦܹܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܓܵܘ ܗܲܝܟܠܵܐ، ܒܘܼܩܸܪܹܗ: ”ܕܵܐܟ݂ܝܼ ܟܹܐ ܐܵܡܪܝܼ ܣܵܦܪܹ̈ܐ ܕܡܫܝܼܚܵܐ ܒܪܘܿܢܵܐ ܕܕܵܘܝܼܕ ܝܼܠܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","”ܣܵܒܵܒ ܕܵܘܝܼܕ ܒܓܵܢܹܗ ܐܡܝܼܪܹܗ ܒܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ: ܐܡܝܼܪܹܗ ܡܵܪܝܵܐ ܠܡܵܪܝܼ، ’ܝܬܘܿܒ݂ ܡ̣ܢ ܝܲܡܝܼܢܝܼ ܗܲܠܔ ܕܡܲܬܒܸܢ ܕܸܫ̃ܡܸܢܘܼܟ݂ ܟܘܼܒ݂ܫܵܐ ܬܚܘܿܬ ܐܲܩܠܵܬܘܼ̈ܟ݂.‘ ");
INSERT INTO aii_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","”ܐܸܢ ܕܵܘܝܼܕ ܗܵܕܟ݂ܵܐ ܒܸܩܪܵܝܹܗ ܝܠܹܗ ܡܵܪܝܵܐ، ܕܵܐܟ݂ܝܼ ܒܸܬ ܗܵܘܹܐ ܒܪܘܿܢܹܗ؟“ ܘܟܸܢܫܵܐ ܓܘܼܪܵܐ ܟܹܐ ܫܵܡܹܥ ܗܘܵܐ ܠܹܗ ܒܚܲܕܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ܘܐܡܝܼܪܹܗ ܟܲܕ ܡܲܠܘܼܦܹܐ: ”ܗܘܹܝܡܘܼܢ ܗܸܫܝܲܪ ܡ̣ܢ ܣܵܦܪܹ̈ܐ ܕܟܹܐ ܡܲܚܸܒܝܼ ܕܚܵܕܪܝܼ ܒܠܒ݂ܝܼܫܝܵܬܹ̈‌ܐ ܝܲܪ̈ܝܼܟܹܐ، ܘܡܲܚܸܒܝܼ ܕܐܢܵܫܹ̈ܐ ܕܵܪܝܼ ܠܗܘܿܢ ܫܠܵܡܵܐ ܒܫܘܼܩܹ̈ܐ، ");
INSERT INTO aii_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","”ܘܪܹܝܫܵܐ ܕܡܵܘܬܒܹ̈ܐ ܓܵܘ ܟܢܘܼܫܝܵܬܹ̈‌ܐ ܘܡܸܫܬܘܼܝܵܬܹ̈‌ܐ، ");
INSERT INTO aii_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","”ܘܟܹܐ ܐܵܟ݂ܠܝܼ ܒܵܬܹ̈‌ܐ ܕܐܲܪ̈ܡܸܠܝܵܬܹ‌ܐ، ܘܒܡܲܫܦܲܪܬܵ‌ܐ ܡܲܪܝܸܟ݂ܝܼ ܨܠܵܘܵܬܵܝ̈ܗ‌ܝ. ܐܲܢܹܐ ܒܸܬ ܩܲܒܠܝܼ ܕܝܵܢܬܵ‌ܐ ܓܘܼܪܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ܝܬܝܼܒ݂ ܠܹܗ ܝܼܫܘܿܥ ܠܒܲܠܩܘܼܒ݂ܠܔ ܕܒܹܝܬ ܓܲܙܵܐ، ܘܒܸܚܝܵܪܵܐ ܒܟܸܢܫܵܐ ܕܒܸܕܪܵܝܵܐ ܝܗܘܵܘ ܙܘܼܙܹ̈ܐ ܓܵܘ ܒܹܝܬ ܓܲܙܵܐ. ܘܪܵܒܵܐ ܥܲܬܝܼܪܹ̈ܐ ܒܸܕܪܵܝܵܐ ܝܗܘܵܘ ܪܵܒܵܐ ܙܘܼܙܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ܘܐܬܹ‌ܐ ܠܵܗ̇ ܚܕܵܐ ܐܲܪܡܸܠܬܵ‌ܐ ܡܸܣܟܹܢܬܵ‌ܐ، ܘܕܪܹܐ ܠܵܗ̇ ܬܪܹܝ ܦܘܼܠܣܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ܩܪܹܐ ܠܹܗ ܝܼܫܘܿܥ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܵܗܵܐ ܐܲܪܡܸܠܬܵ‌ܐ ܡܸܣܟܹܢܬܵ‌ܐ ܕܪܹܐ ܠܵܗ̇ ܓܵܘ ܒܹܝܬ ܓܲܙܵܐ ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܐܲܢܹܐ ܐܢܵܫܹ̈ܐ ܕܒܸܕܪܵܝܵܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","”ܣܵܒܵܒ ܟܠܵܝܗ‌ܝ ܡ̣ܢ ܙܵܘܕܘܼܢܝܘܼܬܵܝܗ‌ܝ ܕܪܹܐ ܠܗܘܿܢ، ܐܝܼܢܵܐ ܐܵܗܵܐ ܡ̣ܢ ܒܵܨܘܿܪܘܼܬܘܼܗ̇ ܕܪܹܐ ܠܵܗ̇، ܟܠܔ ܡܸܢܕܝܼ ܕܐܝܼܬ ܗܘܵܐ ܠܵܗ̇، ܟܠܵܗ̇ ܚܲܝܘܼܬܘܼܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ܟܲܕ ܒܸܦܠܵܛܵܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܡ̣ܢ ܗܲܝܟܠܵܐ، ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܚܲܕ ܡ̣ܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܡܲܠܦܵܢܵܐ، ܚܙܝܼ ܐܲܢܹܐ ܟܹܐܦܹ̈ܐ ܓܘܼܪܹ̈ܐ ܘܐܲܢܹܐ ܒܸܢܝܵܢܹ̈ܐ ܫܲܦܝܼܪܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܒܸܚܙܵܝܵܐ ܝܘܸܬ ܐܲܢܹܐ ܒܸܢܝܵܢܹ̈ܐ ܓܘܼܪܹ̈ܐ؟ ܠܹܐ ܦܵܐܹܫ ܫܒ݂ܝܼܩܵܐ ܟܹܐܦܵܐ ܥܲܠܔ ܟܹܐܦܵܐ ܕܠܵܐ ܦܵܐܹܫ ܣܬܝܼܪܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ܘܐܝܼܡܲܢ ܕܝܬܝܼܒ݂ ܠܹܗ ܝܼܫܘܿܥ ܥܲܠܔ ܛܘܼܪܵܐ ܕܙܲܝ̈ܬܹ‌ܐ، ܒܲܠܩܘܼܒ݂ܠܔ ܕܗܲܝܟܠܵܐ، ܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܘܝܲܥܩܘܿܒ݂ ܘܝܘܿܚܲܢܵܢ ܘܐܲܢܕܪܹܐܘܿܣ ܒܢܲܦ̮ܫܵܝܗ‌ܝ: ");
INSERT INTO aii_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","”ܐܡܘܿܪ ܐܸܠܲܢ، ܐܝܼܡܲܢ ܒܸܬ ܗܵܘܝܼ ܐܲܢܹܐ، ܘܡܘܼܕܝܼ ܝܠܹܗ ܢܝܼܫܲܢܩܵܐ ܐܝܼܡܲܢ ܕܐܲܢܹܐ ܦܵܝܫܝܼ ܬܘܼܡܸܡܹܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ܘܫܘܼܪܹܐ ܠܹܗ ܝܼܫܘܿܥ ܠܹܐܡܵܪܵܐ ܐܸܠܵܝܗ‌ܝ: ”ܗܘܹܝܡܘܼܢ ܗܸܫܝܲܪ ܕܐܢܵܫܵܐ ܠܵܐ ܡܲܚܠܸܛ ܠܵܘܟ݂ܘܿܢ، ");
INSERT INTO aii_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","”ܣܵܒܵܒ ܪܵܒܵܐ ܒܸܬ ܐܵܬ‌ܝܼ ܒܫܸܡܝܼ ܘܒܸܬ ܐܵܡܪܝܼ: ’ܐܵܢܵܐ ܝܘܸܢ،‘ ܘܒܸܬ ܡܲܚܠܸܛܝܼ ܠܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","”ܐܝܼܢܵܐ ܐܝܼܡܲܢ ܕܫܵܡܥܝܼܬܘܿܢ ܒܘܼܬ ܦܠܵܫܹ̈ܐ ܘܚܲܒܪܹ̈ܐ ܒܘܼܬ ܦܠܵܫܹ̈ܐ، ܠܵܐ ܙܵܕܥܝܼܬܘܿܢ، ܣܵܒܵܒ ܘܵܠܹܐ ܝܠܵܗ̇ ܐܲܢܹܐ ܟܠܵܝܗ‌ܝ ܗܵܘܝܼ، ܐܝܼܢܵܐ ܗܸܫ ܠܹܐ ܝܠܹܗ ܫܘܼܠܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","”ܒܸܬ ܩܵܝܡܵܐ ܐܘܼܡܬܵ‌ܐ ܥܲܠܔ ܐܘܼܡܬܵ‌ܐ، ܘܒܸܬ ܩܵܝܡܵܐ ܡܲܠܟܘܼܬܵ‌ܐ ܥܲܠܔ ܡܲܠܟܘܼܬܵ‌ܐ، ܘܒܸܬ ܗܵܘܝܼ ܪ̈ܵܘܕܵܢܹܐ ܒܕܘܼܟܵܢܹ̈ܐ ܦܪ̈ܝܼܫܹܐ، ܘܒܸܬ ܗܵܘܝܼ ܟܸܦܢܹ̈ܐ ܘܫܓ݂ܘܼܫܝܹ̈ܐ. ܐܝܼܢܵܐ ܐܲܢܹܐ ܟܠܵܝܗ‌ܝ ܐܲܚܟ̰ܝܼ ܫܘܼܪܵܝܵܐ ܕܐܘܼܠܨܵܢܹ̈ܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","”ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ ܗܘܹܝܡܘܼܢ ܗܸܫܝܲܪ، ܣܵܒܵܒ ܒܸܬ ܣܲܦܝܼ ܠܵܘܟ݂ܘܿܢ ܠܒܹܝܬ ܕܝܼܢܹ̈ܐ، ܘܓܵܘ ܟܢܘܼܫܝܵܬܹ̈‌ܐ ܒܸܬ ܡܵܚܝܼ ܠܵܘܟ݂ܘܿܢ، ܘܩܲܕܡ ܡܲܠܟܹ̈ܐ ܘܫܲܠܝܼ̈ܛܹܐ ܒܸܬ ܟܵܠܹܝܬܘܿܢ ܒܘܼܬ ܕܝܼܝܼ ܠܣܵܗܕܘܼܬܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","”ܐܝܼܢܵܐ ܩܲܕܡܵܝܬܵ‌ܐ ܒܸܬ ܦܵܐܹܫ ܡܘܼܟܪܸܙܵܐ ܐܵܗܵܐ ܐܹܘܲܢܓܲܠܝܼܘܿܢ ܠܟܠܵܝܗ‌ܝ ܐܸܡܘܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","”ܐܝܼܡܲܢ ܕܠܲܒܠܝܼ ܠܵܘܟ݂ܘܿܢ ܠܣܲܦܘܼܝܵܘܟ݂ܘܿܢ، ܠܵܐ ܐܵܟ݂ܠܝܼܬܘܿܢ ܚܲܡ ܡ̣ܢ ܩܲܕܡ ܥܕܵܢܵܐ ܕܡܘܼܕܝܼ ܒܸܬ ܗܲܡܙܸܡܝܼܬܘܿܢ، ܐܸܠܵܐ ܡܸܢܕܝܼ ܕܦܵܐܹܫ ܝܘܼܗܒ݂ܵܐ ܐܸܠܵܘܟ݂ܘܿܢ ܒܗ̇ܝ ܥܕܵܢܵܐ ܗ̇ܘ ܗܲܡܙܸܡܘܼܢ ܠܹܗ، ܣܵܒܵܒ ܠܹܐ ܐܲܚܬܘܿܢ ܗܲܡܙܸܡܝܼܬܘܿܢ، ܐܸܠܵܐ ܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","”ܒܸܬ ܣܲܦܹܐ ܐܲܚܘܿܢܵܐ ܠܐܲܚܘܿܢܵܐ ܠܡܵܘܬܵ‌ܐ، ܘܒܵܒܵܐ ܠܒܪܘܿܢܹܗ، ܘܒܸܬ ܩܵܝܡܝܼ ܒܢܘܿܢܹ̈ܐ ܕܲܠܩܘܼܒ݂ܠܔ ܕܐܲܒ݂ܵܗܵܝ̈ܗ‌ܝ ܘܒܸܬ ܡܲܡܝܸܬ‌ܝܼ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","”ܘܒܸܬ ܦܵܝܫܝܼܬܘܿܢ ܣܸܢܝܹܐ ܡ̣ܢ ܟܠܔ ܐܢܵܫܵܐ ܒܘܼܬ ܫܸܡܝܼ، ܐܝܼܢܵܐ ܡ̇ܢ ܕܚܵܡܹܠܔ ܗܲܠܔ ܚܲܪܬܵ‌ܐ، ܗ̇ܘ ܒܸܬ ܦܵܪܹܩ. ");
INSERT INTO aii_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","”ܐܝܼܢܵܐ ܐܝܼܡܲܢ ܕܚܵܙܹܝܬܘܿܢ ܛܲܢܦܘܼܬܵ‌ܐ ܕܚܵܪܵܒܵܐ ܒܸܟܠܵܝܵܐ ܒܕܘܼܟܵܐ ܕܠܵܐ ܦܵܝܫܵܐ ܗܘܵܐ ܟܠܝܼܬܵ‌ܐ، (ܗ̇ܘ ܕܩܵܪܹܐ ܦܲܪܡܹܐ)، ܗ̇ܝܓܵܗ ܐܵܢܝܼ ܕܝܼܢܵܐ ܒܝܼܗܘܼܕ ܥܵܪܩܝܼ ܠܛܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","”ܘܗ̇ܘ ܕܝܼܠܹܗ ܥܲܠܔ ܐܓܵܪܹܐ، ܠܵܐ ܨܵܠܹܐ ܘܠܵܐ ܥܵܒܹܪ ܠܸܫܩܵܠܵܐ ܡܸܢܕܝܼ ܕܓܵܘ ܒܲܝܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","”ܘܗ̇ܘ ܕܝܼܠܹܗ ܓܵܘ ܚܲܩܠܵܐ، ܠܵܐ ܕܵܐܹܪ ܠܒܵܬܪܹܗ ܠܸܫܩܵܠܵܐ ܠܒ݂ܝܼܫܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","”ܘܵܝ ܠܒܛܝܼܢܹ̈ܐ، ܘܠܡܲܡܸܨܵܢܹ̈ܐ ܒܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","”ܗܵܕܟ݂ܵܐ ܨܲܠܹܝܡܘܼܢ ܕܠܵܐ ܗܵܘܹܐ ܥܪܵܩܵܘܟ݂ܘܿܢ ܒܣܸܬܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","”ܣܵܒܵܒ ܡܸܢܕܪܸܫ ܒܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ ܒܸܬ ܗܵܘܹܐ ܐܘܼܠܨܵܢܵܐ ܕܠܹܐ ܝܠܹܗ ܗܘܝܼܵܐ ܡܐܲܝܟ݂ ܕܝܼܹܗ ܡ̣ܢ ܫܘܼܪܵܝܵܐ ܕܒܪܝܼܬܵ‌ܐ ܕܒܸܪܝܵܐ ܠܹܗ ܐܲܠܵܗܵܐ ܘܗܲܠܔ ܐܵܕܝܼܵܐ، ܘܠܹܐ ܗܵܘܹܐ ܡܸܢܕܪܸܫ ");
INSERT INTO aii_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","”ܘܐܸܢ ܡܵܪܝܵܐ ܠܵܐ ܡܲܟܪܹܐ ܗܘܵܐ ܠܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ، ܠܹܐ ܦܵܪܹܩ ܗܘܵܐ ܐܘܼܦ ܚܲܕ. ܐܝܼܢܵܐ ܒܘܼܬ ܚܵܬܸܪ ܕܓܘܼܒܝܹ̈ܐ ܕܓܘܼܒܹܐ ܠܹܗ، ܡܘܼܟܪܹܐ ܠܹܗ ܠܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","”ܗ̇ܝܓܵܗ ܐܸܢ ܐܢܵܫܵܐ ܐܵܡܹܪ ܐܸܠܵܘܟ݂ܘܿܢ: ”ܗܵܐ ’ܠܲܐܟ݂ܵܐ ܝܠܹܗ ܡܫܝܼܚܵܐ،‘ ܝܲܢ ’ܬܵܡܵܐ ܝܠܹܗ،‘ ܠܵܐ ܗܲܡܸܢܝܼܬܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","”ܣܵܒܵܒ ܒܸܬ ܩܵܝܡܝܼ ܡܫܝܼܚܹ̈ܐ ܕܲܓܵܠܹ̈ܐ ܘܢܒ݂ܝܼܹ̈ܐ ܕܲܓܵܠܹ̈ܐ ܘܒܸܬ ܥܵܒ݂ܕܝܼ ܢܝܼܫܲܢܩܹ̈ܐ ܘܕܘܼܡܵܪܹ̈ܐ، ܕܡܲܚܠܸܛܝܼ ܐܸܢ ܡܵܨܝܵܐ ܐܘܼܦ ܠܓܘܼܒܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","”ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ ܗܘܹܝܡܘܼܢ ܗܸܫܝܲܪ، ܣܵܒܵܒ ܐܡܝܼܪܝܼ ܐܸܠܵܘܟ݂ܘܿܢ ܟܠܔ ܡܸܢܕܝܼ ܡ̣ܢ ܩܲܕܡܵܝܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","”ܘܒܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ ܡ̣ܢ ܒܵܬܪ ܗ̇ܘ ܐܘܼܠܨܵܢܵܐ، ܫܸܡܫܵܐ ܒܸܬ ܚܲܫܟܸܢ، ܘܣܲܗܪܵܐ ܠܹܐ ܝܵܗܒܹܠܔ ܒܲܗܪܹܗ، ");
INSERT INTO aii_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","”ܘܟܵܘܟ݂ܒܹ̈ܐ ܒܸܬ ܢܵܦܠܝܼ ܡ̣ܢ ܫܡܲܝܵܐ، ܘܚܲܝܠܵܘܵܬܹ̈‌ܐ ܕܫܡܲܝܵܐ ܒܸܬ ܦܵܝܫܝܼ ܡܘܼܫܥܸܫܹܐ. ");
INSERT INTO aii_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","”ܗ̇ܝܓܵܗ ܒܸܬ ܚܵܙܝܼ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܹܐܬܵܝܵܐ ܥܲܠܔ ܥܢܵܢܵܐ ܥܲܡ ܚܲܝܠܵܐ ܓܘܼܪܵܐ ܘܚܸܩܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","”ܗ̇ܝܓܵܗ ܒܸܬ ܫܲܕܸܪ ܡܲܠܲܐܟ݂ܘܼ̈ܗ‌ܝ ܘܒܸܬ ܓ̰ܲܡܸܥ ܠܓܘܼܒܝܘܼ̈ܗ‌ܝ ܡ̣ܢ ܐܲܪܒܥܵܐ ܓܹܒܵܢܹ̈ܐ، ܘܡ̣ܢ ܡܲܪܙܵܐ ܕܐܲܪܥܵܐ ܘܗܲܠܔ ܡܲܪܙܵܐ ܕܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","”ܡ̣ܢ ܐܝܼܠܵܢܵܐ ܕܬܹܐܢܹ̈ܐ ܝܠܘܿܦܘܼܢ ܡܲܬܠܵܐ: ܐܝܼܡܲܢ ܕܟܹܐ ܪܵܟܟ݂ܝܼ ܦܲܥܘܵܢܘܼ̈ܗ‌ܝ ܘܒܲܪܛܸܢܝܼ ܛܲܪ̈ܦܘܼܗ‌ܝ، ܟܹܐ ܝܵܕܥܝܼܬܘܿܢ ܕܡܛܹܐ ܠܹܗ ܩܲܝܛܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","”ܗܵܕܟ݂ܵܐ ܐܘܼܦ ܐܲܚܬܘܿܢ، ܐܝܼܡܲܢ ܕܚܵܙܹܝܬܘܿܢ ܐܲܢܹܐ ܒܹܗܘܵܝܵܐ، ܝܕܹܥܡܘܼܢ ܕܩܘܼܪܒܵܐ ܝܠܹܗ، ܩܲܕܡ ܬܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܠܹܐ ܥܵܒܹܪ ܐܵܗܵܐ ܕܵܘܪܵܐ ܗܲܠܔ ܕܗܵܘܝܼ ܟܠܵܝܗ‌ܝ ܐܲܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","”ܫܡܲܝܵܐ ܘܐܲܪܥܵܐ ܒܸܬ ܥܵܒ݂ܪܝܼ، ܐܝܼܢܵܐ ܗܹܡܸܙܡܵܢܝܼ̈ ܠܹܐ ܥܵܒ݂ܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","”ܐܝܼܢܵܐ ܒܘܼܬ ܗ̇ܘ ܝܵܘܡܵܐ ܘܒܘܼܬ ܗ̇ܝ ܣܵܥܲܬ، ܐܢܵܫܵܐ ܠܹܐ ܝܵܕܹܥ ܐܘܼܦ ܠܵܐ ܡܲܠܲܐܟܹ̈ܐ ܕܫܡܲܝܵܐ ܘܠܵܐ ܒܪܘܿܢܵܐ، ܐܸܠܵܐ ܒܵܒܵܐ ܒܢܲܦ̮ܫܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","”ܚܙܹܝܡܘܼܢ، ܪܥܘܿܫܘܼܢ، ܘܨܲܠܹܝܡܘܼܢ، ܣܵܒܵܒ ܠܹܐ ܝܵܕܥܝܼܬܘܿܢ ܐܝܼܡܲܢ ܝܼܠܵܗ̇ ܥܕܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","”ܐܲܝܟ݂ ܐܢܵܫܵܐ ܝܠܹܗ ܕܐܙܝܼܠܔ ܠܹܗ ܒܣܵܦܵܪ: ܫܒ݂ܝܼܩ ܠܹܗ ܒܲܝܬܹܗ، ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܫܘܼܠܛܵܢܵܐ ܠܪܹ̈ܓܵܘܵܬܘܼܗ‌ܝ ܘܠܟܠܔ ܐܢܵܫܵܐ ܦܘܼܠܚܵܢܹܗ، ܘܦܩܝܼܕ ܠܹܗ ܠܢܵܛܘܿܪܵܐ ܕܗܵܘܹܐ ܪܥܝܼܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","”ܗܵܕܟ݂ܵܐ ܐܘܼܦ ܐܲܚܬܘܿܢ ܗܘܹܝܡܘܼܢ ܪܥܝܼܫܹܐ، ܣܵܒܵܒ ܠܹܐ ܝܵܕܥܝܼܬܘܿܢ ܐܝܼܡܲܢ ܒܸܬ ܐܵܬܹ‌ܐ ܡܵܪܵܐ ܕܒܲܝܬܵ‌ܐ، ܒܪܲܡܫܵܐ ܝܲܢ ܒܦܲܠܓܵܐ ܕܠܲܝܠܹܐ ܝܲܢ ܒܩܪܵܝܬܵ‌ܐ ܕܩܵܪܘܿܝܵܐ ܝܲܢ ܒܨܲܦܪܵܐ، ");
INSERT INTO aii_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","”ܠܵܐ ܗܵܘܹܐ ܕܐܵܬܹ‌ܐ ܡܸܢܫܸܠܬܵܢܹܐ ܘܡܲܫ݇ܟ̰ܸܚ ܠܵܘܟ݂ܘܿܢ ܕܡܝܼܟܹܐ. ");
INSERT INTO aii_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","”ܡܸܢܕܝܼ ܕܐܸܠܵܘܟ݂ܘܿܢ ܒܹܐܡܵܪܵܐ ܝܘܸܢ، ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܠܟܠܵܘܟ݂ܘܿܢ: ܗܘܹܝܡܘܼܢ ܪܥܝܼܫܹܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ܡ̣ܢ ܒܵܬܪ ܬܪܹܝ ܝܵܘܡܵܢܹ̈ܐ ܗܘܹܐ ܠܹܗ ܥܹܐܕܵܐ ܕܦܲܛܝܼܪܹ̈ܐ، ܘܒܥܹܐ ܠܗܘܿܢ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܒܦܸܠܡܵܐ ܕܵܒ݂ܩܝܼ ܗܘܵܘ ܠܝܼܫܘܿܥ ܘܩܵܛܠܝܼ ܗܘܵܘ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ܐܝܼܢܵܐ ܐܡܝܼܪܗܘܿܢ: ”ܠܵܐ ܒܥܹܐܕܵܐ، ܕܠܵܐ ܗܵܘܹܐ ܫܓ݂ܘܼܫܝܵܐ ܓܵܘ ܥܲܡܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ܟܲܕ ܝܼܫܘܿܥ ܓܵܘ ܒܹܝܬ ܥܲܢܝܵܐ ܝܗܘܵܐ ܓܵܘ ܒܲܝܬܵ‌ܐ ܕܫܸܡܥܘܿܢ ܓܸܪܒ݂ܵܢܵܐ، ܘܝܬܝܼܒ݂ܵܐ ܠܣܘܼܦܪܵܐ، ܐܬܹ‌ܐ ܠܵܗ̇ ܚܕܵܐ ܒܲܟ݂ܬܵ‌ܐ ܥܲܡܘܼܗ̇ ܫܵܛܝܼܦܬܵ‌ܐ ܕܒܸܣܡܵܐ ܕܢܵܪܕܝܼܢ ܪܹܝܫܵܝܵܐ ܘܡܵܪܹܐ ܛܝܼܡܵܐ ܪܵܒܵܐ، ܦܬܝܼܚܵܐ ܠܵܗ̇ ܫܵܛܝܼܦܬܵ‌ܐ ܘܫܘܼܦܸܟ݂ ܠܵܗ̇ ܒܸܣܡܵܐ ܥܲܠܔ ܪܹܝܫܵܐ ܕܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ܐܝܼܢܵܐ ܐܢܵܫܹ̈ܐ ܕܝܼܗܘܵܘ ܬܵܡܵܐ ܟܪܝܼܒ ܠܗܘܿܢ ܘܐܡܝܼܪܗܘܿܢ: ”ܩܵܡܘܿܕܝܼ ܐܵܗܵܐ ܚܘܼܣܪܵܢܵܐ ܕܒܸܣܡܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","”ܟܹܐ ܡܵܨܹܐ ܗܘܵܐ ܦܵܐܹܫ ܗܘܵܐ ܙܘܼܒܢܵܐ ܙܵܘܕܵܐ ܡ̣ܢ ܬܠܵܬܡܵܐܐ ܕܝܼܢܵܪܹ̈ܐ ܘܝܘܼܗܒ݂ܵܐ ܠܡܸܣܟܹܢܹ̈ܐ،“ ܘܛܲܪܛܸܡܝܼ ܗܘܵܘ ܥܲܠܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܫܒ݂ܘܿܩܘܼܢ ܠܵܗ̇، ܩܵܡܘܿܕܝܼ ܡܲܠܝܘܼܨܹܐ ܝܬܘܿܢ ܐܸܠܘܼܗ̇؟ ܦܘܼܠܚܵܢܵܐ ܛܵܒ݂ܵܐ ܥܒ݂ܝܼܕ ܠܵܗ̇ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","”ܡܸܣܟܹܢܹ̈ܐ ܒܟܠܔ ܥܕܵܢܵܐ ܐܝܼܬ ܥܲܡܵܘܟ݂ܘܿܢ، ܘܐܝܼܡܲܢ ܕܒܵܥܹܝܬܘܿܢ ܡܵܨܹܝܬܘܿܢ ܥܵܒ݂ܕܝܼܬܘܿܢ ܛܵܒ݂ܬܵ‌ܐ ܐܸܠܵܝܗ‌ܝ، ܐܝܼܢܵܐ ܐܵܢܵܐ ܠܹܐ ܝܘܸܢ ܒܟܠܔ ܥܕܵܢܵܐ ܠܟܸܣܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","”ܐܵܗܵܐ ܒܲܟ݂ܬܵ‌ܐ ܥܒ݂ܝܼܕ ܠܵܗ̇ ܗ̇ܘ ܡܸܢܕܝܼ ܕܡܨܹܐ ܠܵܗ̇. ܐܲܝܟ݂ ܠܩܒ݂ܵܪܬ‌ܝܼ ܡܫܝܼܚ ܠܵܗ̇ ܦܲܓ݂ܪܝܼ ܡ̣ܢ ܩܲܕܡ ܥܕܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܒܟܠܔ ܕܘܼܟܵܐ ܕܦܵܐܹܫ ܡܘܼܟܪܸܙܵܐ ܐܵܗܵܐ ܐܹܘܲܢܓܲܠܝܼܘܿܢ ܒܟܠܵܗ̇ ܒܪܝܼܬܵ‌ܐ، ܒܸܬ ܦܵܐܹܫ ܗܘܼܡܙܸܡܵܐ ܐܵܗܵܐ ܡܸܢܕܝܼ ܕܥܒ݂ܝܼܕ ܠܵܗ̇، ܠܕܟ݂ܵܪܵܐ ܐܸܠܘܼܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ܗ̇ܝܓܵܗ ܝܼܗܘܼܕܵܐ ܣܟܲܪܝܘܿܛܵܐ، ܚܲܕ ܡ̣ܢ ܬܪܸܥܣܲܪ ܬܲܠܡܝܼ̈ܕܹܐ، ܐܙܝܼܠܔ ܠܹܗ ܠܟܸܣ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܕܣܲܦܹܐ ܗܘܵܐ ܠܹܗ ܝܼܫܘܿܥ ܐܸܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ܘܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܗܘܿܢ ܐܵܢܝܼ ܚܕܹܐ ܠܗܘܿܢ ܘܥܒ݂ܝܼܕ ܠܗܘܿܢ ܩܵܘܠܵܐ ܥܲܡܹܗ ܕܝܵܗܒ݂ܝܼ ܠܹܗ ܙܘܼܙܹ̈ܐ. ܘܗ̇ܘ ܛܵܥܹܐ ܗܘܵܐ ܒܵܬܪ ܦܸܪܣܲܬ ܠܣܲܦܘܼܝܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ܒܝܵܘܡܵܐ ܩܲܕܡܵܝܵܐ ܕܦܲܛܝܼܪܹ̈ܐ، ܐܝܼܡܲܢ ܕܝܗܘܼܕܵܝܹ̈ܐ ܟܹܐ ܕܵܒ݂ܚܝܼ ܦܹܐܪܵܐ ܕܦܸܨܚܵܐ، ܐܡܝܼܪܗܘܿܢ ܬܲܠܡܝܼ̈ܕܹܐ ܠܝܼܫܘܿܥ: ”ܐܲܝܟܵܐ ܒܵܣܡܵܐ ܠܘܼܟ݂ ܕܐܵܙܲܠ݇ܚ ܘܗܲܕܪܲܚ ܩܵܬܘܼܟ݂ ܕܘܼܟܵܐ ܕܦܸܨܚܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ܘܫܘܼܕܸܪܹܗ ܬܪܹܝ ܡ̣ܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܙܹܠ݇ܡܘܼܢ ܠܡܕܝܼܢ݇ܬܵ‌ܐ ܘܒܸܬ ܬܵܦܹܩ ܒܝܼܵܘܟ݂ܘܿܢ ܚܲܕ ܐܢܵܫܵܐ ܛܥܝܼܢܵܐ ܬܲܠܡܵܐ ܕܡ̈ܝܼܵܐ. ܙܹܠ݇ܡܘܼܢ ܒܵܬܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","”ܘܠܐܲܝܟܵܐ ܕܥܵܒܹܪ ܐܡܘܿܪܘܼܢ ܠܡܵܪܵܐ ܕܒܲܝܬܵ‌ܐ: ’ܪܲܒܝܼܲܢ ܒܹܐܡܵܪܵܐ ܝܠܹܗ، ܐܲܝܟܵܐ ܝܠܵܗ̇ ܕܘܼܟܵܐ ܕܐܵܟ݂ܠܹܢ ܦܸܨܚܵܐ ܥܲܡ ܬܲܠܡܝܼܕܝܼ̈؟‘ ");
INSERT INTO aii_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","”ܘܗ̇ܘ ܒܸܬ ܡܲܚܙܹܐ ܠܵܘܟ݂ܘܿܢ ܥܸܠܝܼܬܵ‌ܐ ܓܘܼܪܬܵ‌ܐ، ܫܘܼܘܝܼܬܵ‌ܐ ܘܗܘܼܕܸܪܬܵ‌ܐ. ܬܵܡܵܐ ܗܲܕܪܘܼܢ.“ ");
INSERT INTO aii_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ܘܦܠܝܼܛ ܠܗܘܿܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܠܡܕܝܼܢ݇ܬܵ‌ܐ ܘܚܙܹܐ ܠܗܘܿܢ ܕܵܐܟ݂ܝܼ ܕܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ، ܘܗܘܼܕܸܪܗܘܿܢ ܦܸܨܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ܐܝܼܡܲܢ ܕܗܘܹܐ ܠܹܗ ܪܲܡܫܵܐ، ܐܬܹ‌ܐ ܠܹܗ ܝܼܫܘܿܥ ܥܲܡ ܬܪܸܥܣܲܪ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ܘܟܲܕ ܝܬܝܼܒܹܐ ܝܗܘܵܘ ܒܹܐܟ݂ܵܠܵܐ، ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ: ܚܲܕ ܡܸܢܵܘܟ݂ܘܿܢ ܕܒܹܐܟ݂ܵܠܵܐ ܝܠܹܗ ܥܲܡܝܼ ܒܸܬ ܣܲܦܹܐ ܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ܗ̇ܝܓܵܗ ܐܵܢܝܼ ܫܘܼܪܹܐ ܠܗܘܿܢ ܠܸܦܫܵܡܵܐ، ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ ܚܲܕ ܒܚܲܕ: ”ܩܵܡܘܿ ܐܵܢܵܐ ܝܘܸܢ؟“ ");
INSERT INTO aii_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ܐܝܼܢܵܐ ܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ: ”ܚܲܕ ܡ̣ܢ ܬܪܸܥܣܲܪ ܕܒܸܛܡܵܫܵܐ ܝܠܹܗ ܥܲܡܝܼ ܒܡܵܐܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","”ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܹܐܙܵܠܵܐ ܝܠܹܗ ܕܵܐܟ݂ܝܼ ܕܝܼܠܹܗ ܟܬܝܼܒ݂ܵܐ ܒܘܼܬ ܕܝܼܹܗ، ܐܝܼܢܵܐ ܘܵܝ ܠܗ̇ܘ ܐܢܵܫܵܐ ܕܒܐܝܼܕܹܗ ܦܵܐܹܫ ܣܘܼܦܝܵܐ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ. ܒܘܼܫ ܨܦܵܝܝܼ ܝܗܘܵܐ ܠܗ̇ܘ ܐܢܵܫܵܐ ܕܠܵܐ ܗܵܘܹܐ ܗܘܵܐ ܝܠܝܼܕܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ܘܟܲܕ ܒܹܐܟ݂ܵܠܵܐ ܝܗܘܵܘ، ܫܩܝܼܠܔ ܠܹܗ ܝܼܫܘܿܥ ܠܲܚܡܵܐ، ܘܒܘܼܪܸܟ݂ ܠܹܗ، ܘܩܨܹܐ ܠܹܗ، ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܝܗ‌ܝ، ܘܐܡܝܼܪܹܗ: ”ܫܩܘܿܠܘܼܢ، ܐܵܗܵܐ ܝܠܹܗ ܦܲܓ݂ܪܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ܘܫܩܝܼܠܔ ܠܹܗ ܟܵܣܵܐ، ܘܫܘܼܟܸܪܹܗ، ܘܒܘܼܪܸܟ݂ ܠܹܗ، ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܝܗ‌ܝ، ܘܫܬܹ‌ܐ ܠܗܘܿܢ ܡܸܢܹܗ ܟܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܐܵܗܵܐ ܕܸܡܝܼ ܝܠܹܗ ܕܘܲܥܕܵܐ ܚܵܕܬܵ‌ܐ، ܕܡ̣ܢ ܓܹܒܵܐ ܕܪܵܒܵܐ ܦܝܵܫܵܐ ܝܠܹܗ ܫܘܼܦܟ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܚܹܪܢܵܐ ܠܹܐ ܫܵܬܹܝܢ ܡ̣ܢ ܛܥܘܼܢܬܵ‌ܐ ܕܓܸܦܬܵ‌ܐ ܗܲܠܔ ܗ̇ܘ ܝܵܘܡܵܐ ܕܫܵܬܹܢܵܗ̇ ܚܲܕܬܵ‌ܐ ܒܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ܘܡ̣ܢ ܒܵܬܪ ܕܫܘܼܒܸܚ ܠܗܘܿܢ، ܐܣܝܼܩ ܠܗܘܿܢ ܠܛܘܼܪܵܐ ܕܙܲܝ̈ܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܟܠܵܘܟ݂ܘܿܢ ܒܸܬ ܫܵܒ݂ܩܝܼܬܘܿܢ ܠܝܼ، ܣܵܒܵܒ ܟܬܝܼܒ݂ܵܐ ܝܠܹܗ: ܒܸܬ ܡܵܚܹܝܢ ܠܪܵܥܝܵܐ ܘܒܸܬ ܦܵܝܫܝܼ ܒܘܼܪܒܸܙܹܐ ܥܸܪ̈ܒܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","”ܐܝܼܢܵܐ ܡ̣ܢ ܒܵܬܪ ܕܩܵܝܡܹܢ، ܒܸܬ ܐܵܙܹܠ݇ܢ ܡ̣ܢ ܩܲܕܡ ܕܝܼܵܘܟ݂ܘܿܢ ܠܓܠܝܼܠܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ܐܝܼܢܵܐ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܐܘܼܦ ܐܸܢ ܕܟܠܵܝܗ‌ܝ ܫܵܒ݂ܩܝܼ ܠܘܼܟ݂، ܐܵܢܵܐ ܠܹܐ ܫܵܒ݂ܩܹܢܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܘܼܟ݂، ܐܸܕܝܘܿܡ ܒܐܵܗܵܐ ܠܲܝܠܹܐ، ܡ̣ܢ ܩܲܕܡ ܕܬܲܪܬܹܝ ܓܵܗܹ̈ܐ ܩܵܪܹܐ ܩܵܪܘܿܝܵܐ، ܬܠܵܬ ܓܵܗܹ̈ܐ ܒܸܬ ܣܵܪܒܹܬ ܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ܐܝܼܢܵܐ ܗ̇ܘ ܡܲܙܝܸܕ ܗܘܵܐ ܠܹܐܡܵܪܵܐ: ”ܐܘܼܦ ܐܸܢ ܕܗܵܘܝܵܐ ܕܡܵܝܬܹܢ ܥܲܡܘܼܟ݂، ܠܹܐ ܣܵܪܒܹܢܘܼܟ݂.“ ܘܗܵܕܟ݂ܵܐ ܐܘܼܦ ܟܠܵܝܗ‌ܝ ܬܲܠܡܝܼ̈ܕܹܐ ܐܡܝܼܪܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܕܘܼܟܵܐ ܕܦܝܵܫܵܐ ܝܠܵܗ̇ ܩܪܝܼܬܵ‌ܐ ܓܲܕܣܹܡܵܢ، ܘܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܝܬܘܿܒ݂ܘܼܢ ܠܲܐܟ݂ܵܐ ܗܲܠܔ ܕܐܵܙܹܠ݇ܢ ܘܨܲܠܹܝܢ ܨܠܘܿܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ܘܠܘܼܒܸܠܔ ܠܹܗ ܥܲܡܹܗ ܠܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܘܠܝܲܥܩܘܿܒ݂ ܘܠܝܘܿܚܲܢܵܢ، ܘܫܘܼܪܹܐ ܠܹܗ ܠܸܦܫܵܡܵܐ ܘܠܸܥܒ݂ܵܪܵܐ ܒܥܵܘܩܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܦܫܝܼܡܬܵ‌ܐ ܝܠܵܗ̇ ܓܵܢܝܼ ܗܲܠܔ ܡܵܘܬܵ‌ܐ. ܦܘܼܫܘܼܢ ܠܲܐܟ݂ܵܐ ܘܗܘܹܝܡܘܼܢ ܪܥܝܼܫܹܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ܘܪܚܝܼܩ ܠܹܗ ܡܸܢܵܝܗ‌ܝ ܘܢܦܝܼܠܔ ܠܹܗ ܥܲܠܔ ܐܲܪܥܵܐ، ܘܫܘܼܪܹܐ ܠܹܗ ܠܨܲܠܘܼܝܹܐ ܕܐܸܢ ܡܵܨܝܵܐ ܥܵܒ݂ܪܵܐ ܡܸܢܹܗ ܐܵܗܵܐ ܣܵܥܲܬ. ");
INSERT INTO aii_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ܘܐܡܝܼܪܹܗ: ”ܐܲܒܵܐ، ܒܵܒܝܼ، ܟܠܔ ܡܸܢܕܝܼ ܡܵܨܹܝܬ ܥܵܒ݂ܕܹܬ، ܡܲܥܒܸܪ ܡܸܢܝܼ ܐܵܗܵܐ ܟܵܣܵܐ. ܐܝܼܢܵܐ ܠܵܐ ܐܲܝܟ݂ ܨܸܒ݂ܝܵܢܝܼ، ܐܸܠܵܐ ܐܲܝܟ݂ ܨܸܒ݂ܝܵܢܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ܘܕܝܼܪܹܗ ܠܟܸܣ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܚܸܙܝܵܝ ܠܹܗ ܕܡܝܼܟܹܐ، ܘܐܡܝܼܪܹܗ ܠܫܸܡܥܘܿܢ ܟܹܐܦܵܐ: ”ܫܸܡܥܘܿܢ، ܕܡܝܼܟ݂ܵܐ ܝܘܸܬ؟ ܠܵܐ ܡܨܹܐ ܠܘܼܟ݂ ܥܵܒ݂ܕܹܬ ܗܘܵܐ ܫܵܗܲܪܬܵ‌ܐ ܚܕܵܐ ܣܵܥܲܬ؟ ");
INSERT INTO aii_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","”ܪܥܘܿܫܘܼܢ ܘܨܲܠܹܝܡܘܼܢ ܕܠܵܐ ܥܵܒ݂ܪܝܼܬܘܿܢ ܠܓ̰ܘܼܪܵܒܵܐ. ܪܘܼܚܵܐ ܟܹܐ ܒܵܥܝܵܐ ܐܝܼܢܵܐ ܦܲܓ݂ܪܵܐ ܙܲܒܘܼܢ ܝܼܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ܘܐܙܝܼܠܔ ܠܹܗ ܡܸܢܕܪܸܫ ܘܨܘܼܠܹܐ ܠܹܗ ܡܐܲܝܟ݂ ܗ̇ܝ ܓܵܗܵܐ ܩܲܕܡܵܝܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ܘܕܝܼܪܹܗ ܡܸܢܕܪܸܫ ܘܚܸܙܝܵܝ ܠܹܗ ܕܡܝܼܟܹܐ ܣܵܒܵܒ ܥܲܝ̈ܢܵܝܗ‌ܝ ܝܘܼܩܪܸܢܹܐ ܝܗܘܵܘ ܒܫܸܢܬܵ‌ܐ، ܘܠܵܐ ܝܕܝܼܥ ܠܗܘܿܢ ܡܘܼܕܝܼ ܐܵܡܪܝܼ ܗܘܵܘ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ܘܓܵܗܵܐ ܕܬܠܵܬ ܐܬܹ‌ܐ ܠܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܐܵܕܝܼܵܐ ܕܡܘܿܟ݂ܘܼܢ ܘܡܲܢܝܸܚܘܼܢ، ܡܛܹܐ ܠܵܗ̇ ܚܲܪܬܵ‌ܐ ܘܐܬܹ‌ܐ ܠܵܗ̇ ܣܵܥܲܬ. ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܦܝܵܫܵܐ ܝܠܹܗ ܣܘܼܦܝܵܐ ܒܐܝܼܕܵܬܹ̈‌ܐ ܕܚܲܛܵܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","”ܩܘܼܡܘܼܢ ܕܐܵܙܲܠ݇ܚ، ܗܵܐ ܩܘܼܪܒܸܢܹܗ ܗ̇ܘ ܕܣܲܦܹܐ ܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ܟܲܕ ܗ̇ܘ ܗܲܡܙܘܼܡܹܐ ܝܗܘܵܐ، ܐܬܹ‌ܐ ܠܹܗ ܝܼܗܘܼܕܵܐ ܣܟܲܪܝܘܿܛܵܐ، ܚܲܕ ܡ̣ܢ ܬܪܸܥܣܲܪ ܬܲܠܡܝܼ̈ܕܹܐ، ܘܥܲܡܹܗ ܟܸܢܫܵܐ ܪܵܒܵܐ، ܒܣܲܝܦܹ̈ܐ ܘܚܘܼܛܪܹ̈ܐ، ܦܝܼܫܹܐ ܫܘܼܕܪܹܐ ܡ̣ܢ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܣܵܦܪܹ̈ܐ ܘܚܘܵܪ̈ܕܸܩܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ܘܝܼܗܘܼܕܵܐ ܣܲܦܝܵܢܵܐ ܝܘܼܗܒ݂ܵܐ ܝܗܘܵܐ ܐܸܠܵܝܗ‌ܝ ܢܝܼܫܲܢܩܵܐ ܒܹܐܡܵܪܵܐ: ”ܗ̇ܘ ܕܢܵܫܩܹܢܹܗ، ܗ̇ܘ ܝܼܠܹܗ. ܕܵܒ݂ܩܝܼܬܘܿܢ ܠܹܗ ܘܠܲܒܠܝܼܬܘܿܢ ܠܹܗ ܒܗܸܫܝܲܪܘܼܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ܒܓ̰ܲܠܕܘܼܬܵ‌ܐ ܐܬܹ‌ܐ ܠܹܗ ܣܲܦܝܵܢܵܐ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܪܲܒܝܼ، ܪܲܒܝܼ،“ ܘܢܫܝܼܩ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ܘܐܵܢܝܼ ܕܝܼܗܘܵܘ ܥܲܡܹܗ ܕܒ݂ܝܼܩ ܠܗܘܿܢ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ܗ̇ܝܓܵܗ ܚܲܕ ܡ̣ܢ ܐܵܢܝܼ ܕܝܼܗܘܵܘ ܥܲܡ ܝܼܫܘܿܥ ܓܪܝܼܫ ܠܹܗ ܣܲܝܦܵܐ ܘܡܚܹܐ ܠܹܗ ܠܪܹܓܵܐ ܕܓܘܼܪܵܐ ܕܟܵܗ̈ܢܹܐ ܘܦܪܝܼܡܵܐ ܠܹܗ ܢܵܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܒܹܐܡܵܪܵܐ ܐܸܠܵܝܗ‌ܝ: ”ܐܲܝܟ݂ ܕܥܲܠܔ ܓܲܝܵܣܵܐ ܦܠܝܼܛ ܠܵܘܟ݂ܘܿܢ ܥܲܠܝܼ ܒܣܲܝܦܹ̈ܐ ܘܒܚܘܼܛܪܹ̈ܐ ܕܕܵܒ݂ܩܝܼܬܘܿܢ ܠܝܼ؟ ");
INSERT INTO aii_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","”ܟܠܔ ܝܘܿܡ ܟܹܐ ܗܵܘܹܝܢ ܗܘܵܐ ܠܟܸܣܠܵܘܟ݂ܘܿܢ ܡܲܠܘܼܦܹܐ ܒܗܲܝܟܠܵܐ ܘܠܵܐ ܩܵܡ ܕܵܒ݂ܩܝܼܬܘܿܢ ܠܝܼ. ܐܸܠܵܐ ܗܘܹܐ ܠܵܗ̇ ܐܵܗܵܐ ܕܦܵܝܫܝܼ ܬܘܼܡܸܡܹܐ ܟܬܵܒܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ܗ̇ܝܓܵܗ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܫܒ݂ܝܼܩ ܠܗܘܿܢ ܐܸܠܹܗ ܘܥܪܝܼܩ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ܘܚܲܕ ܥܠܲܝܡܵܐ ܒܹܐܬܵܝܵܐ ܝܗܘܵܐ ܒܵܬܪܹܗ، ܕܸܪܝܵܐ ܟܸܬܲܢ ܠܦܲܓ݂ܪܹܗ ܫܘܼܠܚܵܝܵܐ. ܕܒ݂ܝܼܩ ܠܗܘܿܢ ܐܸܠܹܗ، ");
INSERT INTO aii_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ܐܝܼܢܵܐ ܗ̇ܘ ܫܒ݂ܝܼܩ ܠܹܗ ܓ̰ܘܼܠܵܐ ܕܟܸܬܲܢ ܘܥܪܝܼܩ ܠܹܗ ܫܘܼܠܚܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ܠܘܼܒܸܠܔ ܠܗܘܿܢ ܠܝܼܫܘܿܥ ܠܟܸܣ ܓܘܼܪܵܐ ܕܟܵܗ̈ܢܹܐ، ܘܓ̰ܡܝܼܥ ܠܗܘܿܢ ܬܵܡܵܐ ܟܠܵܝܗ‌ܝ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܣܵܦܪܹ̈ܐ ܘܚܘܵܪ̈ܕܸܩܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ܘܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܒܹܐܙܵܠܵܐ ܝܗܘܵܐ ܒܵܬܪ ܝܼܫܘܿܥ ܡ̣ܢ ܪܸܚܩܵܐ ܗܲܠܔ ܓܵܘ ܕܵܪܬܵ‌ܐ ܕܓܘܼܪܵܐ ܕܟܵܗ̈ܢܹܐ، ܘܝܬܝܼܒ݂ ܠܹܗ ܥܲܡ ܢܵܛܘܿܪܹ̈ܐ ܒܸܫܚܵܢܵܐ ܩܲܕܡ ܢܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܟܠܹܗ ܟܢܘܼܫܝܵܐ ܛܵܥܝܼ ܗܘܵܘ ܣܵܗܕܘܼܬܵ‌ܐ ܥܲܠܔ ܝܼܫܘܿܥ ܕܡܲܡܝܸܬ‌ܝܼ ܗܘܵܘ ܠܹܗ، ܘܠܵܐ ܡܘܼܫ݇ܟ̰ܸܚ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ܪܵܒܵܐ ܝܘܼܗܒܹܠܔ ܠܗܘܿܢ ܥܲܠܘܼܗ‌ܝ ܣܵܗܕܘܼܬܵ‌ܐ ܕܲܓܵܠܬܵ‌ܐ، ܐܝܼܢܵܐ ܣܵܗܕܘܵܬܵܝ̈ܗ‌ܝ ܠܵܐ ܕܒ݂ܝܼܩ ܠܗܘܿܢ ܥܲܡ ܥܘܼܕܵܠܹܐ. ");
INSERT INTO aii_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ܘܩܝܼܡ ܠܗܘܿܢ ܣܵܗܕܹ̈ܐ ܕܲܓܵܠܹ̈ܐ ܘܐܡܝܼܪܗܘܿܢ: ");
INSERT INTO aii_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","”ܐܲܚܢܲܢ ܫܡܝܼܥ ܠܲܢ ܕܐܡܝܼܪܹܗ: ’ܐܵܢܵܐ ܒܸܬ ܬܵܠܚܹܢܹܗ ܐܵܗܵܐ ܗܲܝܟܠܵܐ ܒܸܢܝܵܐ ܒܐܝܼܕܵܬܹ̈‌ܐ، ܘܒܬܠܵܬܵ‌ܐ ܝܵܘܡܵܢܹ̈ܐ ܒܸܬ ܒܵܢܹܝܢ ܚܲܕ ܐܚܹܪܢܵܐ ܠܵܐ ܒܸܢܝܵܐ ܒܐܝܼܕܵܬܹ̈‌ܐ.‘“ ");
INSERT INTO aii_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ܐܝܼܢܵܐ ܐܘܼܦ ܐܵܗܵܐ ܣܵܗܕܘܼܬܵ‌ܐ ܠܵܐ ܕܒ݂ܝܼܩ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ܗ̇ܝܓܵܗ ܩܝܼܡ ܠܹܗ ܓܘܼܪܵܐ ܕܟܵܗ̈ܢܹܐ ܒܹܝܦܲܠܓܵܐ، ܘܒܘܼܩܸܪܹܗ ܡ̣ܢ ܝܼܫܘܿܥ: ”ܩܵܡܘܿܕܝܼ ܠܹܐ ܝܘܸܬ ܓ̰ܲܘܘܼܒܹܐ ܠܐܲܢܹܐ ܕܒܸܣܗܵܕܵܐ ܝܢܵܐ ܥܲܠܘܼܟ݂؟“ ");
INSERT INTO aii_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܫܬܝܼܩܵܐ ܝܗܘܵܐ، ܘܡܸܢܕܝܼ ܠܵܐ ܓ̰ܘܼܘܸܒ ܠܹܗ. ܡܸܢܕܪܸܫ ܒܘܼܩܸܪܹܗ ܡܸܢܹܗ ܓܘܼܪܵܐ ܕܟܵܗ̈ܢܹܐ: ”ܐܲܢ݇ܬ ܝܼܘܸܬ ܡܫܝܼܚܵܐ، ܒܪܘܿܢܵܐ ܕܡܒܘܼܪܟ݂ܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܒܹܐܡܵܪܵܐ: ”ܐܵܢܵܐ ܝܘܸܢ. ܘܒܸܬ ܚܵܙܹܝܬܘܿܢ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܝܬܝܼܒ݂ܵܐ ܡ̣ܢ ܝܲܡܝܼܢܵܐ ܕܚܲܝܠܬܵܢܵܐ ܘܒܹܐܬܵܝܵܐ ܥܲܠܔ ܥܢܵܢܵܐ ܕܫܡܲܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ܘܓܘܼܪܵܐ ܕܟܵܗ̈ܢܹܐ ܟ̰ܘܼܢܟ̰ܸܪܹܗ ܓ̰ܘܼܠܘܼ̈ܗ‌ܝ ܒܹܐܡܵܪܵܐ: ”ܩܵܡܘܿܕܝܼ ܐܚܹܪܢܵܐ ܣܢܝܼܩܹܐ ܝܘܲܚ ܠܣܵܗܕܹ̈ܐ؟ ");
INSERT INTO aii_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","”ܗܵܐ ܫܡܝܼܥ ܠܵܘܟ݂ܘܿܢ ܡ̣ܢ ܦܘܼܡܹܗ ܓܘܼܕܵܦܵܐ. ܡܘܼܕܝܼ ܒܸܚܫܵܒ݂ܵܐ ܝܬܘܿܢ؟“ ܘܐܵܢܝܼ ܟܠܵܝܗ‌ܝ ܕܝܼܢܗܘܿܢ ܕܚܲܝܵܒ݂ܵܐ ܝܠܹܗ ܠܡܵܘܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ܫܘܼܪܹܐ ܠܗܘܿܢ ܐܢܵܫܹ̈ܐ ܒܸܪܵܩܵܐ ܥܲܠܘܼܗ‌ܝ، ܘܟܘܼܣܹܐ ܠܗܘܿܢ ܦܵܬܹܗ، ܘܩܲܪܦܸܚܝܼ ܗܘܵܘ ܠܹܗ ܘܐܵܡܪܝܼ ܗܘܵܘ: ”ܢܲܒܝܼ.“ ܘܢܵܛܘܿܪܹ̈ܐ ܡܵܚܝܼ ܗܘܵܘ ܠܹܗ ܒܟ̰ܲܦܘܼܠܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ܘܟܲܕ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܠܬܸܚܬ ܓܵܘ ܕܵܪܬܵ‌ܐ ܝܗܘܵܐ، ܐܬܹ‌ܐ ܠܵܗ̇ ܚܕܵܐ ܚܵܡܬܵ‌ܐ ܕܓܘܼܪܵܐ ܕܟܵܗ̈ܢܹܐ، ");
INSERT INTO aii_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ܘܚܙܹܐ ܠܵܗ̇ ܐܸܠܹܗ ܟܲܕ ܒܸܫܚܵܢܵܐ. ܚܝܼܪܵܗ̇ ܒܝܼܹܗ ܘܐܡܝܼܪܵܗ̇ ܐܸܠܹܗ: ”ܐܘܼܦ ܐܲܢ݇ܬ ܥܲܡ ܝܼܫܘܿܥ ܢܵܨܪܵܝܵܐ ܝܘܸܬ ܗܘܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ܐܝܼܢܵܐ ܗ̇ܘ ܣܪܝܼܒ݂ ܠܹܗ ܘܐܡܝܼܪܹܗ: ”ܠܹܐ ܝܘܸܢ ܒܝܼܕܵܥܵܐ ܘܠܵܐ ܦܲܪܡܘܼܝܹܐ ܡܘܼܕܝܼ ܒܹܐܡܵܪܵܐ ܝܘܲܬ‌ܝ.“ ܘܦܠܝܼܛ ܠܹܗ ܠܒܲܕܲܪ ܠܨܘܼܦܵܐ، ܘܩܪܹܐ ܠܹܗ ܩܵܪܘܿܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ܡܸܢܕܪܸܫ ܚܙܹܐ ܠܵܗ̇ ܐܸܠܹܗ ܗ̇ܝ ܚܵܡܬܵ‌ܐ ܘܫܘܼܪܹܐ ܠܵܗ̇ ܒܹܐܡܵܪܵܐ ܠܐܵܢܝܼ ܕܬܵܡܵܐ ܝܗܘܵܘ: ”ܐܘܼܦ ܐܵܗܵܐ ܡܸܢܵܝܗ‌ܝ ܝܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ܐܝܼܢܵܐ ܗ̇ܘ ܡܸܢܕܪܸܫ ܣܪܝܼܒ݂ ܠܹܗ. ܘܡ̣ܢ ܒܵܬܪ ܚܲܕ ܡܸܬܚܵܐ ܐܵܢܝܼ ܕܟܸܠܝܹܐ ܝܗܘܵܘ ܬܵܡܵܐ ܐܡܝܼܪܗܘܿܢ ܠܫܸܡܥܘܿܢ ܟܹܐܦܵܐ: ”ܫܲܪܝܼܪܵܐܝܼܬ ܐܲܢ݇ܬ ܡܸܢܵܝܗ‌ܝ ܝܘܸܬ، ܘܐܘܼܦ ܓܠܝܼܠܵܝܵܐ ܝܘܸܬ، ܣܵܒܵܒ ܗܲܡܙܲܡܬܘܼܟ݂ ܡܲܕܘܼܥܹܐ ܝܠܵܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ܐܝܼܢܵܐ ܗ̇ܘ ܫܘܼܪܹܐ ܠܹܗ ܠܡܲܚܪܘܼܡܹܐ ܘܠܸܡܝܵܝܵܐ: ”ܠܹܐ ܝܵܕܥܹܢ ܠܐܵܗܵܐ ܐܢܵܫܵܐ ܕܗܲܡܙܘܼܡܹܐ ܝܬܘܿܢ ܒܘܼܬ ܕܝܼܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܩܪܹܐ ܠܹܗ ܩܵܪܘܿܝܵܐ ܓܵܗܵܐ ܕܬܲܪܬܹܝ. ܘܕܟ݂ܝܼܪܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܗܹܡܸܙܡܵܢ ܕܝܼܫܘܿܥ ܕܐܡܝܼܪܵܐ ܝܗܘܵܐ ܐܸܠܹܗ: ”ܡ̣ܢ ܩܲܕܡ ܕܩܵܪܹܐ ܩܵܪܘܿܝܵܐ ܬܲܪܬܹܝ ܓܵܗܹ̈ܐ، ܒܸܬ ܣܵܪܒܹܬ ܠܝܼ ܬܠܵܬ ܓܵܗܹ̈ܐ.“ ܘܫܘܼܪܹܐ ܠܹܗ ܠܸܒܟ݂ܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ܒܝܵܘܡܵܐ ܐܚܹܪܢܵܐ ܒܨܲܦܪܵܐ، ܣܘܼܙܓܸܪܗܘܿܢ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܥܲܡ ܚܘܵܪ̈ܕܸܩܢܹܐ ܘܥܲܡ ܣܵܦܪܹ̈ܐ ܘܥܲܡ ܟܠܹܗ ܟܢܘܼܫܝܵܐ، ܘܐܣܝܼܪܗܘܿܢ ܠܝܼܫܘܿܥ ܘܠܘܼܒܸܠܔ ܠܗܘܿܢ ܘܣܘܼܦܹܐ ܠܗܘܿܢ ܐܸܠܹܗ ܠܦܝܼܠܵܛܘܿܣ. ");
INSERT INTO aii_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ܘܒܘܼܩܸܪܹܗ ܡܸܢܹܗ ܦܝܼܠܵܛܘܿܣ: ”ܐܲܢ݇ܬ ܝܼܘܸܬ ܡܲܠܟܵܐ ܕܝܗܘܼܕܵܝܹ̈ܐ؟“ ܘܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ ܒܹܐܡܵܪܵܐ ܐܸܠܹܗ: ”ܐܲܢ݇ܬ ܐܡܝܼܪܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ܘܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܩܵܒ݂ܠܝܼ ܗܘܵܘ ܥܲܠܘܼܗ‌ܝ ܒܪܵܒܵܐ ܡܸܢܕܝܼܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ܡܸܢܕܪܸܫ ܒܘܼܩܸܪܹܗ ܡܸܢܹܗ ܦܝܼܠܵܛܘܿܣ ܒܹܐܡܵܪܵܐ: ”ܩܵܡܘܿܕܝܼ ܠܹܐ ܝܘܸܬ ܓ̰ܲܘܘܼܒܹܐ، ܒܸܚܙܵܝܵܐ ܝܘܸܬ ܟܡܵܐ ܒܸܩܒ݂ܵܠܵܐ ܝܢܵܐ ܥܲܠܘܼܟ݂؟“ ");
INSERT INTO aii_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܠܵܐ ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܘܼܦ ܚܕܵܐ ܗܹܡܸܙܡܵܢ، ܗܵܕܟ݂ܵܐ ܕܥܘܼܓ̰ܸܒ ܠܹܗ ܦܝܼܠܵܛܘܿܣ. ");
INSERT INTO aii_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ܒܟܠܔ ܥܹܐܕܵܐ ܐܝܼܬ ܗܘܵܐ ܥܵܕܲܬ ܕܫܵܪܹܐ ܗܘܵܐ ܫܲܠܝܼܛܵܐ ܚܲܕ ܐܲܣܝܼܪܵܐ ܩܵܐ ܥܲܡܵܐ، ܗ̇ܘ ܕܐܵܢܝܼ ܛܵܠܒܝܼ ܗܘܵܘ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ܘܐܝܼܬ ܗܘܵܘ ܠܗܘܿܢ ܚܲܕ ܐܲܣܝܼܪܵܐ ܫܸܡܹܗ ܒܲܪ ܐܲܒܵܐ، ܗ̇ܘ ܕܦܝܼܫܵܐ ܝܗܘܵܐ ܕܸܪܝܵܐ ܓܵܘ ܒܹܝܬ ܐܲܣܝܼܪܹ̈ܐ ܥܲܡ ܡܵܪ̈ܘܿܕܹܐ، ܐܵܢܝܼ ܕܒܩܸܛܠܵܐ ܟܹܐ ܥܵܒ݂ܕܝܼ ܗܘܵܘ ܫܓ݂ܘܼܫܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ܡܘܼܩܘܸܚ ܠܹܗ ܟܸܢܫܵܐ ܘܫܘܼܪܹܐ ܠܹܗ ܠܸܛܠܵܒܵܐ ܕܥܵܒܹܕ ܗܘܵܐ ܐܸܠܵܝܗ‌ܝ، ܐܲܝܟ݂ ܕܟܹܐ ܥܵܒܹܕ ܗܘܵܐ ܥܝܵܕܵܐܝܼܬ. ");
INSERT INTO aii_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ܘܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ ܦܝܼܠܵܛܘܿܣ: ”ܒܵܥܹܝܬܘܿܢ ܕܫܵܪܹܝܢ ܐܸܠܵܘܟ݂ܘܿܢ ܡܲܠܟܵܐ ܕܝܗܘܼܕܵܝܹ̈ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ܣܵܒܵܒ ܟܹܐ ܝܵܕܹܥ ܗܘܵܐ ܦܝܼܠܵܛܘܿܣ ܕܡ̣ܢ ܒܲܚܸܠܵܢܘܼܬܵ‌ܐ ܣܘܼܦܹܐ ܠܗܘܿܢ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܠܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ܐܝܼܢܵܐ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܚܘܼܦܸܛ ܠܗܘܿܢ ܠܟܸܢܫܵܐ ܕܫܵܪܹܐ ܗܘܵܐ ܐܸܠܵܝܗ‌ܝ ܠܒܲܪ ܐܲܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ܡܸܢܕܪܸܫ ܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ ܦܝܼܠܵܛܘܿܣ: ”ܡܘܼܕܝܼ ܒܵܥܹܝܬܘܿܢ ܕܥܵܒ݂ܕܹܢ ܠܐܵܗܵܐ ܐܢܵܫܵܐ ܕܒܸܩܪܵܝܹܗ ܝܬܘܿܢ ܡܲܠܟܵܐ ܕܝܗܘܼܕܵܝܹ̈ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ܘܐܵܢܝܼ ܡܘܼܩܘܸܚ ܠܗܘܿܢ: ”ܙܩܘܿܦ ܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ܓ̰ܘܼܘܸܒ ܠܹܗ ܦܝܼܠܵܛܘܿܣ: ”ܡܘܼܕܝܼ ܒܝܼܫܬܵ‌ܐ ܥܒ݂ܝܼܕܵܐ ܝܠܹܗ؟“ ܐܝܼܢܵܐ ܐܵܢܝܼ ܒܘܼܫ ܙܵܘܕܵܐ ܡܲܩܘܸܚܝܼ ܗܘܵܘ: ”ܙܩܘܿܦ ܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ܘܒܥܹܐ ܠܹܗ ܦܝܼܠܵܛܘܿܣ ܕܥܵܒܹܕ ܗܘܵܐ ܕܵܐܟ݂ܝܼ ܕܟܸܢܫܵܐ ܒܵܣܡܵܐ ܗܘܵܐ ܠܹܗ. ܫܪܹܐ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܠܒܲܪ ܐܲܒܵܐ، ܘܣܘܼܦܹܐ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ ܕܦܵܐܹܫ ܡܸܚܝܵܐ ܠܙܩܝܼܦܵܐ ܡ̣ܢ ܒܵܬܪ ܕܦܝܼܫܵܐ ܝܗܘܵܐ ܡܸܚܝܵܐ ܒܫܵܘܛܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ܗ̇ܝܓܵܗ ܢܵܛܘܿܪܹ̈ܐ ܠܘܼܒܸܠܔ ܠܗܘܿܢ ܐܸܠܹܗ ܠܓܵܘ ܕܵܪܬܵ‌ܐ ܕܝܼܠܵܗ̇ ܦܪܵܛܘܿܪܝܼܢ ܘܩܪܹܐ ܠܗܘܿܢ ܠܟܠܵܗ̇ ܣܝܼܥܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ܘܡܘܼܠܒܸܫ ܠܗܘܿܢ ܐܸܠܹܗ ܐܲܪܓܘܵܢܵܐ، ܘܓܕܝܼܠܔ ܠܗܘܿܢ ܟܠܝܼܠܵܐ ܕܟܸܬܘܹ̈ܐ ܘܡܘܼܬܸܒ݂ ܠܗܘܿܢ ܒܪܹܝܫܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ܘܫܘܼܪܹܐ ܠܗܘܿܢ ܒܸܕܪܵܝܵܐ ܫܠܵܡܵܐ ܥܲܠܘܼܗ‌ܝ، ܒܹܐܡܵܪܵܐ: ”ܫܠܵܡܵܐ ܠܘܼܟ݂ ܡܲܠܟܵܐ ܕܝܗܘܼܕܵܝܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ܘܡܵܚܝܼ ܗܘܵܘ ܒܙܹܠܵܐ ܥܲܠܔ ܪܹܝܫܹܗ، ܘܪܵܝܩܝܼ ܗܘܵܘ ܥܲܠܘܼܗ‌ܝ، ܘܒܵܪܟܝܼ ܗܘܵܘ ܥܲܠܔ ܒܸܪ̈ܟܵܟܵܝܗ‌ܝ ܩܲܕܡܘܼܗ‌ܝ، ܘܣܵܓ݂ܕܝܼ ܗܘܵܘ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ܡ̣ܢ ܒܵܬܪ ܕܡܘܼܣܚܸܪܗܘܿܢ ܒܝܼܹܗ، ܫܘܼܠܸܚ ܠܗܘܿܢ ܡܸܢܹܗ ܓ̰ܘܼܠܹ̈ܐ ܕܐܲܪܓܘܵܢܵܐ، ܘܡܘܼܠܒܸܫ ܠܗܘܿܢ ܐܸܠܹܗ ܓ̰ܘܼܠܹ̈ܐ ܕܓܵܢܹܗ، ܘܦܘܼܠܸܛ ܠܗܘܿܢ ܕܦܵܐܹܫ ܡܸܚܝܵܐ ܠܙܩܝܼܦܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ܚܲܕ ܐܢܵܫܵܐ ܩܸܘܪܝܼܢܵܝܵܐ، ܫܸܡܹܗ ܫܸܡܥܘܿܢ، ܒܵܒܵܐ ܕܐܵܠܸܟܣܲܢܕܪܘܿܣ ܘܕܪܘܼܦܘܿܣ، ܒܸܥܒ݂ܵܪܵܐ ܝܗܘܵܐ ܡ̣ܢ ܬܵܡܵܐ، ܒܹܐܬܵܝܵܐ ܡ̣ܢ ܚܲܩܠܵܐ. ܥܒ݂ܝܼܕ ܠܗܘܿܢ ܫܘܼܚܪܵܐ ܥܲܠܘܼܗ‌ܝ ܕܛܵܥܹܢ ܗܘܵܐ ܠܙܩܝܼܦܵܐ ܕܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ܘܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܐܸܠܹܗ ܠܓܵܓ݂ܘܿܠܬܵ‌ܐ، ܕܘܼܟܵܐ ܕܦܝܵܫܵܐ ܝܠܵܗ̇ ܦܘܼܫܸܩܬܵ‌ܐ ”ܕܘܼܟܵܐ ܕܩܲܪܩܲܦܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ܘܝܘܼܗܒܹܠܔ ܠܗܘܿܢ ܐܸܠܹܗ ܚܲܡܪܵܐ ܠܸܫܬܵܝܵܐ، ܚܒ݂ܝܼܛܵܐ ܒܡܘܼܪܵܐ. ܐܝܼܢܵܐ ܠܵܐ ܫܬܹ‌ܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ܘܙܩܝܼܦ ܠܗܘܿܢ ܐܸܠܹܗ، ܘܦܘܼܠܸܥ ܠܗܘܿܢ ܠܓ̰ܘܼܠܘܼ̈ܗ‌ܝ ܒܕܪܵܝܬܵ‌ܐ ܕܦܸܫܟܹ̈ܐ، ܟܠܔ ܚܲܕ ܡܘܼܕܝܼ ܒܸܬ ܫܵܩܹܠܔ. ");
INSERT INTO aii_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ܣܵܥܲܬ ܕܬܫܲܥ ܝܗܘܵܐ ܐܝܼܡܲܢ ܕܡܚܹܐ ܠܗܘܿܢ ܐܸܠܹܗ ܠܙܩܝܼܦܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ܘܟܬܝܼܒ݂ܬܵ‌ܐ ܝܗܘܵܐ ܥܸܠܬܵ‌ܐ ܕܡܵܘܬܹܗ: ”ܐܵܗܵܐ ܝܠܹܗ ܡܲܠܟܵܐ ܕܝܗܘܼܕܵܝܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ܘܙܩܝܼܦ ܠܗܘܿܢ ܥܲܡܹܗ ܬܪܹܝ ܓܲܝܵܣܹ̈ܐ، ܚܲܕ ܡ̣ܢ ܝܲܡܝܼܢܹܗ ܘܚܲܕ ܡ̣ܢ ܣܸܡܵܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ܘܦܝܼܫ ܠܹܗ ܬܘܼܡܸܡܵܐ ܟܬܵܒ݂ܵܐ ܕܐܡܝܼܪܹܗ: ”ܥܲܡ ܥܵܘܵܠܹ̈ܐ ܦܝܼܫ ܠܹܗ ܚܘܼܫܒܸܢܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ܘܐܘܼܦ ܐܵܢܝܼ ܕܥܵܒ݂ܪܝܼ ܗܘܵܘ ܓܵܕܦܝܼ ܗܘܵܘ ܥܲܠܘܼܗ‌ܝ ܘܫܵܥܫܝܼ ܗܘܵܘ ܪܹ̈ܝܫܵܝܗ‌ܝ ܘܐܵܡܪܝܼ ܗܘܵܘ: ”ܝܵܐ ܣܵܬܪܵܢܵܐ ܕܗܲܝܟܠܵܐ ܘܒܵܢܝܵܢܹܗ ܒܬܠܵܬܵ‌ܐ ܝܵܘܡܵܢܹ̈ܐ، ");
INSERT INTO aii_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","”ܦܲܨܝܼ ܓܵܢܘܼܟ݂ ܘܨܠܝܼ ܡ̣ܢ ܙܩܝܼܦܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ܗܵܕܟ݂ܵܐ ܐܘܼܦ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܓܵܚܟܝܼ ܗܘܵܘ ܚܲܕ ܥܲܡ ܕܗ̇ܘ ܐܚܹܪܢܵܐ ܘܥܲܡ ܣܵܦܪܹ̈ܐ ܘܐܡܝܼܪܗܘܿܢ: ”ܠܐܚܹܪ̈ܢܹܐ ܦܘܼܪܸܩ ܠܹܗ، ܐܝܼܢܵܐ ܓܵܢܹܗ ܠܹܐ ܡܵܨܹܐ ܦܲܪܸܩ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","”ܡܫܝܼܚܵܐ ܡܲܠܟܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ، ܫܒ݂ܘܿܩ ܨܵܠܹܐ ܐܵܕܝܼܵܐ ܡ̣ܢ ܙܩܝܼܦܵܐ ܕܚܵܙܲܚ ܘܗܲܡܸܢܲܚ ܒܝܼܹܗ.“ ܐܘܼܦ ܐܵܢܝܼ ܕܦܝܼܫ ܠܗܘܿܢ ܙܩܝܼܦܹܐ ܥܲܡܹܗ ܡܲܣܚܸܪܝܼ ܗܘܵܘ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ܟܲܕ ܗܘܹܐ ܠܵܗ̇ ܣܵܥܲܬ ܕܬܪܸܥܣܲܪ، ܗܘܹܐ ܠܹܗ ܚܸܫܟܵܐ ܥܲܠܔ ܟܠܵܗ̇ ܐܲܪܥܵܐ ܗܲܠܔ ܣܵܥܲܬ ܕܬܠܵܬ. ");
INSERT INTO aii_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ܘܒܣܵܥܲܬ ܕܬܠܵܬ، ܡܘܼܩܘܸܚ ܠܹܗ ܝܼܫܘܿܥ ܒܩܵܠܵܐ ܪܵܡܵܐ ܒܹܐܡܵܪܵܐ: ”ܐܹܝܠܝ ܐܹܝܠܝ، ܠܡܵܢܵܐ ܫܒܲܩܬܵܢܝ؟“ ܕܦܝܵܫܵܐ ܝܠܵܗ̇ ܦܘܼܫܸܩܬܵ‌ܐ: ”ܐܲܠܵܗ‌ܝܼ، ܐܲܠܵܗ‌ܝܼ، ܩܵܡܘܿܕܝܼ ܫܒ݂ܝܼܩܸܢܘܼܟ݂؟“ ");
INSERT INTO aii_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ܐܢܵܫܹ̈ܐ ܕܟܸܠܝܹܐ ܝܗܘܵܘ ܬܵܡܵܐ ܐܡܝܼܪܗܘܿܢ: ”ܠܐܹܠܝܼܵܐ ܒܸܩܪܵܝܵܐ ܝܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ܘܪܚܝܼܛ ܠܹܗ ܚܲܕ ܡܸܢܵܝܗ‌ܝ ܘܡܠܹܐ ܠܹܗ ܐܸܣܦܘܼܓܵܐ ܚܲܠܵܐ ܘܐܣܝܼܪܹܗ ܒܙܹܠܵܐ ܕܡܲܫܬܹ‌ܐ ܗܘܵܐ ܠܹܗ، ܘܐܡܝܼܪܹܗ: ”ܫܒ݂ܘܿܩܘܼܢ ܕܚܵܙܲܚ ܐܸܢ ܒܸܬ ܐܵܬܹ‌ܐ ܐܹܠܝܼܵܐ ܘܡܲܨܠܹܐ ܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ܡܘܼܩܘܸܚ ܠܹܗ ܝܼܫܘܿܥ ܒܩܵܠܵܐ ܪܵܡܵܐ ܘܣܘܼܦܝܵܐ ܠܹܗ ܪܘܼܚܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ܘܣܸܬܪܵܐ ܕܗܲܝܟܠܵܐ ܦܝܼܫ ܠܹܗ ܦܪܝܼܛܵܐ ܠܬܪܹܝ ܣܵܗܡܹ̈ܐ، ܡ̣ܢ ܥܸܠܸܠܔ ܘܗܲܠܔ ܠܬܸܚܬ. ");
INSERT INTO aii_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ܘܟܲܕ ܚܙܹܐ ܠܹܗ ܪܲܒ ܡܵܐܐ ܕܟܸܠܝܵܐ ܝܗܘܵܐ ܠܟܸܣܠܹܗ ܕܵܐܟ݂ܝܼ ܡܘܼܩܘܸܚ ܠܹܗ ܝܼܫܘܿܥ ܘܣܘܼܦܝܵܐ ܠܹܗ ܪܘܼܚܹܗ، ܐܡܝܼܪܹܗ: ”ܫܲܪܝܼܪܵܐܝܼܬ ܐܵܗܵܐ ܐܢܵܫܵܐ ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ ܝܗܘܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ܐܝܼܬ ܗܘܵܘ ܐܘܼܦ ܒܲܟ݂ܬܵܬܹ̈‌ܐ ܒܸܚܝܵܪܵܐ ܡ̣ܢ ܪܸܚܩܵܐ. ܡܸܢܵܝܗ‌ܝ ܡܲܪܝܲܡ ܡܲܓ݂ܕܠܵܝܬܵ‌ܐ، ܡܲܪܝܲܡ ܝܸܡܵܐ ܕܝܲܥܩܘܿܒ݂ ܙܥܘܿܪܵܐ ܘܕܝܘܿܣܹܐ، ܘܫܵܠܘܿܡ، ");
INSERT INTO aii_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ܐܲܝܢܝܼ ܕܐܬܹ‌ܐ ܠܗܘܿܢ ܒܵܬܪ ܝܼܫܘܿܥ ܐܝܼܡܲܢ ܕܗ̇ܘ ܓܵܘ ܓܠܝܼܠܵܐ ܝܗܘܵܐ، ܘܥܵܒ݂ܕܝܼ ܗܘܵܘ ܚܸܠܡܲܬ ܐܸܠܹܗ. ܘܪܵܒܵܐ ܒܲܟ݂ܬܵܬܹ̈‌ܐ ܐܚܹܪ̈ܢܹܐ ܕܐܣܝܼܩ ܠܗܘܿܢ ܥܲܡܹܗ ܠܐܘܿܪܸܫܠܸܡ. ");
INSERT INTO aii_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ܘܟܲܕ ܗܘܹܐ ܠܹܗ ܪܲܡܫܵܐ، ܣܵܒܵܒ ܝܼܗܘܵܐ ܝܵܘܡܵܐ ܕܗܲܕܲܪܬܵ‌ܐ، ܕܝܼܠܹܗ ܡ̣ܢ ܩܲܕܡ ܫܲܒܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ܐܬܹ‌ܐ ܠܹܗ ܝܵܘܣܸܦ، ܚܲܕ ܐܢܵܫܵܐ ܡ̣ܢ ܪܵܡܬܵ‌ܐ، ܡܵܠܘܿܟ݂ܵܐ ܡܝܘܼܩܪܵܐ، ܕܒܓܵܢܹܗ ܒܸܣܦܵܪܵܐ ܝܗܘܵܐ ܠܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ. ܐܵܗܵܐ ܩܘܼܫܕܸܪܹܗ ܘܥܒ݂ܝܼܪܹܗ ܠܟܸܣ ܦܝܼܠܵܛܘܿܣ ܘܛܠܝܼܒ ܠܹܗ ܦܲܓ݂ܪܵܐ ܕܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ܥܘܼܓ̰ܸܒ ܠܹܗ ܦܝܼܠܵܛܘܿܣ ܕܗܵܕܟ݂ܵܐ ܓ̰ܲܠܕܹܐ ܡܝܼܬ ܠܹܗ. ܘܩܪܹܐ ܠܹܗ ܠܪܲܒ ܡܵܐܐ ܘܒܘܼܩܸܪܹܗ ܡܸܢܹܗ ܕܐܸܢ ܡܝܼܬܵ‌ܐ ܝܗܘܵܐ ܡ̣ܢ ܩܲܕܡ ܥܕܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ܡ̣ܢ ܒܵܬܪ ܕܫܡܝܼܥ ܠܹܗ ܦܝܼܠܵܛܘܿܣ ܡ̣ܢ ܪܲܒ ܡܵܐܐ، ܝܘܼܗܒܹܠܔ ܠܹܗ ܦܲܓ݂ܪܵܐ ܠܝܵܘܣܸܦ. ");
INSERT INTO aii_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ܘܙܒ݂ܝܼܢܹܗ ܝܵܘܣܸܦ ܟܸܬܲܢ، ܘܡܘܼܨܠܹܐ ܠܹܗ ܠܦܲܓ݂ܪܵܐ ܘܟܘܼܪܡܸܟ݂ ܠܹܗ ܒܟܸܬܲܢ، ܘܡܘܼܬܸܒ݂ ܠܹܗ ܓܵܘ ܩܲܒ݂ܪܵܐ ܕܢܩܝܼܪܵܐ ܝܗܘܵܐ ܓܵܘ ܩܵܝܵܐ، ܘܡܘܼܚܕܸܪܹܗ ܟܹܐܦܵܐ ܥܲܠܔ ܬܲܪܥܵܐ ܕܩܲܒ݂ܪܵܐ، ");
INSERT INTO aii_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ܡܲܪܝܲܡ ܡܲܓ݂ܕܠܵܝܬܵ‌ܐ، ܘܡܲܪܝܲܡ ܝܸܡܵܐ ܕܝܘܿܣܹܐ ܚܙܹܐ ܠܗܘܿܢ ܐܲܝܟܵܐ ܦܝܼܫ ܠܹܗ ܡܘܼܬܒ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ܟܲܕ ܥܒ݂ܝܼܪܵܗ̇ ܫܲܒܬܵ‌ܐ، ܡܲܪܝܲܡ ܡܲܓ݂ܕܠܵܝܬܵ‌ܐ ܘܡܲܪܝܲܡ ܝܸܡܵܐ ܕܝܲܥܩܘܿܒ݂، ܘܫܵܠܘܿܡ، ܙܒ݂ܝܼܢܗܘܿܢ ܒܸܣܡܹ̈ܐ ܕܐܵܬ‌ܝܼ ܗܘܵܘ ܘܡܵܫܚܝܼ ܗܘܵܘ ܠܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ܘܒܨܲܦܪܵܐ ܕܚܲܕ݇ܒܫܵܒܵܐ، ܒܙܪܵܩܵܐ ܕܫܸܡܫܵܐ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܒܹܝܬ ܩܒ݂ܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ܘܐܵܡܪܝܼ ܗܘܵܘ ܓܵܘ ܓܵܢܵܝܗ‌ܝ: ”ܡܵܢܝܼ ܒܸܬ ܡܲܚܕܸܪ ܐܸܠܲܢ ܠܟܹܐܦܵܐ ܡ̣ܢ ܬܲܪܥܵܐ ܕܒܹܝܬ ܩܒ݂ܘܼܪܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ܐܝܼܢܵܐ ܐܝܼܡܲܢ ܕܚܝܼܪܗܘܿܢ ܚܙܹܐ ܠܗܘܿܢ ܠܟܹܐܦܵܐ، ܕܝܼܗܘܵܐ ܓܘܼܪܵܐ، ܡܘܼܚܕܸܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ܥܒ݂ܝܼܪܗܘܿܢ ܠܒܹܝܬ ܩܒ݂ܘܼܪܵܐ ܘܚܙܹܐ ܠܗܘܿܢ ܥܠܲܝܡܵܐ ܝܬܝܼܒ݂ܵܐ ܡ̣ܢ ܝܲܡܝܼܢܵܐ، ܠܒ݂ܝܼܫܵܐ ܠܒ݂ܝܼܫܬܵ‌ܐ ܚܘܵܪܬܵ‌ܐ، ܘܙܕܝܼܥ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ܐܝܼܢܵܐ ܗ̇ܘ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܠܵܐ ܙܵܕܥܝܼܬܘܿܢ، ܠܝܼܫܘܿܥ ܢܵܨܪܵܝܵܐ ܒܸܛܥܵܝܵܐ ܝܬܘܿܢ، ܗ̇ܘ ܕܦܝܼܫ ܠܹܗ ܙܩܝܼܦܵܐ. ܩܝܼܡ ܠܹܗ، ܠܹܐ ܝܠܹܗ ܠܲܐܟ݂ܵܐ. ܚܙܹܝܡܘܼܢ، ܐܵܗܵܐ ܝܠܵܗ̇ ܕܘܼܟܵܐ ܕܡܘܼܬܸܒ݂ ܠܗܘܿܢ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","”ܐܝܼܢܵܐ ܙܹܠ݇ܡܘܼܢ ܘܐܡܘܿܪܘܼܢ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܠܫܸܡܥܘܿܢ ܟܹܐܦܵܐ، ܕܐܙܝܼܠܔ ܠܹܗ ܡ̣ܢ ܩܲܕܡ ܕܝܼܵܘܟ݂ܘܿܢ ܠܓܠܝܼܠܵܐ. ܬܵܡܵܐ ܒܸܬ ܚܵܙܹܝܬܘܿܢ ܠܹܗ ܕܵܐܟ݂ܝܼ ܕܐܡܝܼܪܹܗ ܐܸܠܵܘܟ݂ܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܗܘܿܢ، ܦܠܝܼܛ ܠܗܘܿܢ ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܡ̣ܢ ܩܲܒ݂ܪܵܐ، ܒܥܘܼܓ̰ܵܒܵܐ ܘܪܲܬܪܲܬܬܵ‌ܐ، ܘܠܐܢܵܫܵܐ ܡܸܢܕܝܼ ܠܵܐ ܐܡܝܼܪܗܘܿܢ ܣܵܒܵܒ ܒܸܙܕܵܥܵܐ ܝܗܘܵܘ. ");
INSERT INTO aii_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ܒܨܲܦܪܵܐ ܕܚܲܕ݇ܒܫܵܒܵܐ ܐܝܼܡܲܢ ܕܩܝܼܡ ܠܹܗ ܝܼܫܘܿܥ، ܦܝܼܫ ܠܹܗ ܚܸܙܝܵܐ ܩܲܕܡܵܝܬܵ‌ܐ ܠܡܲܪܝܲܡ ܡܲܓ݂ܕܠܵܝܬܵ‌ܐ، ܗ̇ܝ ܕܦܘܼܠܛܵܐ ܝܗܘܵܐ ܡܸܢܘܼܗ̇ ܫܲܒ݂ܥܵܐ ܫܹܐܕܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ܘܗ̇ܝ ܐܙܝܼܠܔ ܠܵܗ̇ ܘܐܡܝܼܪܵܗ̇ ܠܐܵܢܝܼ ܕܗܘܝܼܹܐ ܝܗܘܵܘ ܥܲܡܹܗ، ܘܐܵܢܝܼ ܒܸܥܒ݂ܵܕܵܐ ܝܗܘܵܘ ܬܵܥܙܝܼ ܘܒܸܒܟ݂ܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ܘܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܗܘܿܢ ܕܐܡܝܼܪܵܗ̇ ܚܵܝܵܐ ܝܠܹܗ ܘܦܝܼܫ ܠܹܗ ܚܸܙܝܵܐ ܐܸܠܘܼܗ̇، ܠܵܐ ܗܘܼܡܸܢܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ܡ̣ܢ ܒܵܬܪ ܐܵܗܵܐ، ܦܝܼܫ ܠܹܗ ܚܸܙܝܵܐ ܠܬܪܹܝ ܡܸܢܵܝܗ‌ܝ ܒܕܡܘܼܬܵ‌ܐ ܐܚܹܪܬܵ‌ܐ، ܟܲܕ ܒܹܐܙܵܠܵܐ ܠܚܕܵܐ ܡܵܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ܐܲܢܹܐ ܬܪܹܝ ܐܙܝܼܠܔ ܠܗܘܿܢ ܘܡܘܼܚܒܸܪܗܘܿܢ ܠܐܵܢܝܼ ܬܲܠܡܝܼ̈ܕܹܐ ܐܚܹܪ̈ܢܹܐ، ܘܐܘܼܦ ܐܸܠܵܝܗ‌ܝ ܠܵܐ ܗܘܼܡܸܢܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ܒܚܲܪܬܵ‌ܐ ܦܝܼܫ ܠܹܗ ܚܸܙܝܵܐ ܠܚܲܕܸܥܣܲܪ ܟܲܕ ܝܬܝܼܒܹܐ ܠܣܘܼܦܪܵܐ، ܘܠܝܼܡܵܝ ܠܹܗ ܥܲܠܔ ܒܵܨܘܿܪܘܼܬܵ‌ܐ ܕܗܲܝܡܵܢܘܼܬܵܝܗ‌ܝ ܘܠܩܸܫܝܘܼܬܵ‌ܐ ܕܠܸܒܵܝܗ‌ܝ ܕܠܵܐ ܗܘܼܡܸܢܗܘܿܢ ܠܐܵܢܝܼ ܕܚܙܹܐ ܠܗܘܿܢ ܐܸܠܹܗ ܩܝܼܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܙܹܠ݇ܡܘܼܢ ܠܟܠܹܗ ܥܵܠܡܵܐ ܘܡܲܟܪܸܙܘܼܢ ܐܹܘܲܢܓܲܠܝܼܘܿܢ ܒܟܠܵܗ̇ ܒܪܝܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","”ܗ̇ܘ ܕܗܲܡܸܢ ܘܥܵܡܹܕ ܒܸܬ ܦܵܪܹܩ، ܘܗ̇ܘ ܕܠܵܐ ܗܲܡܸܢ ܒܸܬ ܦܵܐܹܫ ܕܝܼܢܵܐ، ");
INSERT INTO aii_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","”ܘܐܵܢܝܼ ܕܗܲܡܸܢܝܼ ܒܸܬ ܥܵܒ݂ܕܝܼ ܢܝܼܫܲܢܩܹ̈ܐ: ܒܸܬ ܦܲܠܛܝܼ ܫܹܐܕܹ̈ܐ ܒܫܸܡܝܼ، ܘܒܸܬ ܗܲܡܙܸܡܝܼ ܒܠܸܫܵܢܹ̈ܐ ܚܵܕܬܹ̈‌ܐ، ");
INSERT INTO aii_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","”ܒܸܬ ܫܵܩܠܝܼ ܚܘܼܵܘܵܬܹ̈‌ܐ، ܘܐܸܢ ܣܲܡܵܐ ܕܡܵܘܬܵ‌ܐ ܫܵܬ‌ܝܼ ܗܸܟ̃ ܠܹܐ ܚܲܙܕܸܓ ܠܗܘܿܢ، ܘܒܸܬ ܡܲܬܒ݂ܝܼ ܐܝܼܕܵܬܵܝ̈ܗ‌ܝ ܥܲܠܔ ܡܪ̈ܝܼܥܹܐ ܘܒܸܬ ܒܵܣܡܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ܡ̣ܢ ܒܵܬܪ ܕܗܘܼܡܙܸܡ ܠܹܗ ܡܵܪܲܢ ܝܼܫܘܿܥ ܥܲܡܵܝܗ‌ܝ، ܦܝܼܫ ܠܹܗ ܡܘܼܐܣܩܵܐ ܠܫܡܲܝܵܐ ܘܝܬܝܼܒ݂ ܠܹܗ ܡ̣ܢ ܝܲܡܝܼܢܵܐ ܕܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ܘܐܵܢܝܼ ܦܠܝܼܛ ܠܗܘܿܢ ܘܡܘܼܟܪܸܙ ܠܗܘܿܢ ܒܟܠܔ ܕܘܼܟܵܐ، ܘܡܵܪܲܢ ܟܹܐ ܗܲܝܸܪ ܗܘܵܐ ܠܗܘܿܢ ܘܡܲܩܘܹܐ ܗܘܵܐ ܗܹܡܸܙܡܵܢܵܝ̈ܗ‌ܝ ܒܢܝܼܫܲܢܩܹ̈ܐ ܕܥܵܒ݂ܕܝܼ ܗܘܵܘ.");
INSERT INTO aii_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ܪܵܒܵܐ ܓ̰ܘܼܪܸܒ ܠܗܘܿܢ ܠܸܟܬܵܒ݂ܵܐ ܬܲܫܥܝܼܵܬܹ̈‌ܐ ܕܥܒ݂ܵܕܹ̈ܐ ܒܘܼܬ ܐܵܢܝܼ ܕܦܝܼܫ ܠܗܘܿܢ ܡܫܘܼܪܸܪܹܐ ܓܵܘܲܢ، ");
INSERT INTO aii_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ܕܵܐܟ݂ܝܼ ܕܣܘܼܦܹܐ ܠܗܘܿܢ ܐܸܠܲܢ ܐܵܢܝܼ ܕܡ̣ܢ ܩܲܕܡܵܝܬܵ‌ܐ ܣܵܗܕܹ̈ܐ ܘܦܲܠܵܚܹ̈ܐ ܕܗܹܡܸܙܡܵܢ ܝܼܗܘܵܘ. ");
INSERT INTO aii_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ܣܵܒܵܒ ܐܘܼܦ ܐܵܢܵܐ ܡ̣ܢ ܩܲܕܡܵܝܬܵ‌ܐ ܨܘܼܚܨܹܐ ܠܝܼ ܚܲܬܝܼܬܵܐܝܼܬ، ܘܚܘܼܦܸܛ ܠܝܼ ܕܟܵܬܒܹܢ ܟܠܔ ܡܸܢܕܝܼ ܐܸܠܘܼܟ݂ ܒܪܹܐܙܵܐ، ܝܵܐ ܢܲܨܝܼܚܵܐ ܬܹܐܘܿܦܝܼܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ܕܝܵܕܥܹܬ ܫܲܪܝܼܪܘܼܬܵ‌ܐ ܕܐܵܢܝܼ ܗܹܡܸܙܡܵܢܹ̈ܐ ܕܒܝܼܵܝܗ‌ܝ ܦܝܼܫ ܠܘܼܟ݂ ܬܘܼܠܡܸܕܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ܒܝܵܘܡܵܢܹ̈ܐ ܕܗܹܪܘܿܕܸܣ، ܡܲܠܟܵܐ ܕܝܼܗܘܼܕܵܐ، ܐܝܼܬ ܗܘܵܐ ܚܲܕ ܟܵܗܢܵܐ ܫܸܡܹܗ ܙܟܲܪܝܵܐ ܡ̣ܢ ܕܲܪܓ݂ܵܐ ܕܟܵܗܢܘܼܬܵ‌ܐ ܕܒܹܝܬ ܐܲܒ݂ܝܼܵܐ، ܘܒܲܟ݂ܬܹܗ ܡ̣ܢ ܒܢܵܬܹ̈‌ܐ ܕܐܲܗܪܘܿܢ، ܫܸܡܘܼܗ̇ ܐܹܠܝܼܫܒܲܥ. ");
INSERT INTO aii_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ܬܸܪܘܵܝ ܙܲܕܝܼܩܹ̈ܐ ܝܗܘܵܘ ܩܲܕܡ ܐܲܠܵܗܵܐ، ܒܸܚܕܵܪܵܐ ܕܠܵܐ ܡܘܼܡܵܐ ܒܟܠܵܝܗ‌ܝ ܦܘܼܩܕܵܢܹ̈ܐ ܘܩܵܢܘܿܢܹ̈ܐ ܕܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ܐܝܼܢܵܐ ܠܲܝܬ ܗܘܵܘ ܠܗܘܿܢ ܒܪܘܿܢܵܐ، ܣܵܒܵܒ ܐܹܠܝܼܫܒܲܥ ܥܩܲܪܬܵ‌ܐ ܝܗܘܵܐ، ܘܬܸܪܘܵܝ ܓܘܼܪܹ̈ܐ ܝܗܘܵܘ ܒܫܸܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ܘܗܘܹܐ ܠܵܗ̇ ܟܲܕ ܙܟܲܪܝܵܐ ܒܸܥܒ݂ܵܕܵܐ ܝܗܘܵܐ ܚܸܠܡܲܬ ܩܲܕܡ ܐܲܠܵܗܵܐ ܐܲܝܟ݂ ܛܲܟ݂ܣܵܐ ܕܟܵܗܢܘܼܬܹܗ، ");
INSERT INTO aii_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ܡܛܹܐ ܠܵܗ̇ ܥܕܵܢܹܗ ܐܲܝܟ݂ ܪܹܐܙܵܐ ܕܟܵܗܢܘܼܬܵ‌ܐ ܕܡܲܩܸܕ ܒܸܣܡܵܐ، ܘܥܒ݂ܝܼܪܹܗ ܠܗܲܝܟܠܵܐ ܕܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ܘܟܠܹܗ ܟܸܢܫܵܐ ܕܥܲܡܵܐ ܨܲܠܘܼܝܹܐ ܝܗܘܵܘ ܠܒܲܕܲܪ ܒܥܕܵܢܵܐ ܕܡܲܩܲܕܬܵ‌ܐ ܕܒܸܣܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ܚܙܹܐ ܠܹܗ ܙܟܲܪܝܵܐ ܡܲܠܲܐܟ݂ܵܐ ܕܡܵܪܝܵܐ، ܟܸܠܝܵܐ ܡ̣ܢ ܝܲܡܝܼܢܵܐ ܕܡܲܕܒܚܵܐ ܕܒܸܣܡܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ܘܫܓ݂ܝܼܫ ܠܹܗ ܙܟܲܪܝܵܐ ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܹܗ ܠܡܲܠܲܐܟ݂ܵܐ، ܘܙܕܘܼܥܬܵ‌ܐ ܢܦܝܼܠܔ ܠܵܗ̇ ܥܲܠܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ܐܝܼܢܵܐ ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܡܲܠܲܐܟ݂ܵܐ: ”ܠܵܐ ܙܵܕܥܹܬ ܙܟܲܪܝܵܐ، ܣܵܒܵܒ ܦܝܼܫ ܠܵܗ̇ ܫܡܝܼܥܬܵ‌ܐ ܨܠܘܿܬܘܼܟ݂، ܘܒܲܟ݂ܬܘܼܟ݂ ܐܹܠܝܼܫܒܲܥ ܒܸܬ ܗܲܨܠܵܐ ܠܘܼܟ݂ ܒܪܘܿܢܵܐ، ܘܒܸܬ ܩܵܪܹܝܬ ܫܸܡܹܗ ܝܘܿܚܲܢܵܢ. ");
INSERT INTO aii_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","”ܒܸܬ ܗܵܘܹܐ ܠܘܼܟ݂ ܚܲܕܘܼܬܵ‌ܐ ܘܦܨܵܚܵܐ، ܘܪܵܒܵܐ ܐܢܵܫܹ̈ܐ ܒܸܬ ܚܵܕܝܼ ܒܡܵܘܠܵܕܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","”ܒܸܬ ܗܵܘܹܐ ܓܘܼܪܵܐ ܩܲܕܡ ܡܵܪܝܵܐ. ܚܲܡܪܵܐ ܘܫܲܟ݂ܪܵܐ ܠܹܐ ܫܵܬܹ‌ܐ، ܘܒܸܬ ܦܵܐܹܫ ܡܸܠܝܵܐ ܡ̣ܢ ܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ ܗܸܫ ܗ̇ܘ ܒܟܹܪ݇ܣܵܐ ܕܝܸܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","”ܒܸܬ ܡܲܕܸܪ ܪܵܒܵܐ ܡ̣ܢ ܒܢܲܝ̈ ܐܝܼܣܪܵܐܹܝܠܔ ܠܟܸܣ ܡܵܪܝܵܐ ܐܲܠܵܗܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","”ܘܒܸܬ ܚܵܕܹܪ ܩܲܕܡ ܐܲܠܵܗܵܐ ܒܪܘܼܚܵܐ ܘܒܚܲܝܠܵܐ ܕܐܹܠܝܼܵܐ ܢܒ݂ܝܼܵܐ، ܕܡܲܕܸܪ ܠܸܒܵܐ ܕܐܲܒ݂ܵܗܹ̈ܐ ܠܟܸܣ ܒܢܘܿܢܹ̈ܐ، ܘܐܵܢܝܼ ܕܠܹܐ ܡܲܨܝܸܬ‌ܝܼ ܒܸܬ ܡܲܕܸܪܗܘܿܢ ܠܦܲܪܡܲܝܬܵ‌ܐ ܕܙܲܕܝܼܩܹ̈ܐ، ܘܒܸܬ ܗܲܕܸܪ ܩܵܐ ܡܵܪܝܵܐ ܥܲܡܵܐ ܓܡܝܼܪܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ܐܡܝܼܪܹܗ ܙܟܲܪܝܵܐ ܠܡܲܠܲܐܟ݂ܵܐ: ”ܕܵܐܟ݂ܝܼ ܒܸܬ ܝܵܕܥܹܢ ܐܵܗܵܐ؟ ܐܵܢܵܐ ܣܵܒ݂ܵܐ ܝܘܸܢ، ܘܒܲܟ݂ܬ‌ܝܼ ܓܘܼܪܬܵ‌ܐ ܝܠܵܗ̇ ܒܫܸܢܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ܓ̰ܘܼܘܸܒ ܠܹܗ ܡܲܠܲܐܟ݂ܵܐ ܒܹܐܡܵܪܵܐ ܐܸܠܹܗ: ”ܐܵܢܵܐ ܝܘܸܢ ܓܲܒ݂ܪܝܼܹܠܔ ܕܟܹܐ ܟܵܠܹܝܢ ܩܲܕܡ ܐܲܠܵܗܵܐ. ܦܝܼܫ ܠܝܼ ܫܘܼܕܪܵܐ ܕܗܲܡܙܸܡܸܢ ܥܲܡܘܼܟ݂، ܘܡܲܫܚܸܕܸܢܘܼܟ݂ ܒܐܲܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","”ܘܡ̣ܢ ܐܵܕܝܼܵܐ ܒܸܬ ܗܵܘܹܝܬ ܫܬܝܼܩܵܐ، ܘܠܹܐ ܡܵܨܹܝܬ ܗܲܡܙܸܡܸܬ ܗܲܠܔ ܝܵܘܡܵܐ ܕܐܲܢܹܐ ܗܵܘܝܼ، ܣܵܒܵܒ ܠܵܐ ܗܘܼܡܸܢܘܼܟ݂ ܠܗܹܡܸܙܡܵܢܝܼ̈، ܐܵܢܝܼ ܕܒܸܬ ܦܵܝܫܝܼ ܬܘܼܡܸܡܹܐ ܒܥܕܵܢܵܝܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ܘܥܲܡܵܐ ܒܸܣܦܵܪܵܐ ܝܗܘܵܘ ܠܙܟܲܪܝܵܐ، ܘܥܘܼܓ̰ܸܒ ܠܗܘܿܢ ܕܥܘܼܪܩܸܠܔ ܠܹܗ ܓܵܘ ܗܲܝܟܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ܐܝܼܡܲܢ ܕܦܠܝܼܛ ܠܹܗ ܙܟܲܪܝܵܐ، ܠܵܐ ܡܨܹܐ ܠܹܗ ܗܲܡܙܸܡ ܥܲܡܵܝܗ‌ܝ، ܘܝܕܝܼܥ ܠܗܘܿܢ ܕܚܸܙܘܵܐ ܚܙܹܐ ܠܹܗ ܓܵܘ ܗܲܝܟܠܵܐ، ܘܗ̇ܘ ܒܪܸܡܙܵܐ ܪܵܡܹܙ ܗܘܵܐ ܐܸܠܵܝܗ‌ܝ. ܘܦܝܼܫ ܠܹܗ ܠܲܥܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ܘܐܝܼܡܲܢ ܕܬܘܼܡܸܡ ܠܗܘܿܢ ܝܵܘܡܵܢܹ̈ܐ ܕܚܸܠܡܲܬܹܗ، ܐܙܝܼܠܔ ܠܹܗ ܠܒܲܝܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ܘܗܘܹܐ ܠܵܗ̇ ܡ̣ܢ ܒܵܬܪ ܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ ܒܛܝܼܢܵܗ̇ ܐܹܠܝܼܫܒܲܥ ܒܲܟ݂ܬܵ‌ܐ ܕܙܟܲܪܝܵܐ، ܘܛܘܼܫܝܵܐ ܠܵܗ̇ ܓܵܢܘܼܗ̇ ܚܲܡܫܵܐ ܝܲܪ̈ܚܹܐ، ܘܐܵܡܪܵܐ ܗܘܵܐ: ");
INSERT INTO aii_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","”ܗܵܕܟ݂ܵܐ ܥܒ݂ܝܼܕ ܠܹܗ ܒܝܼܝܼ ܡܵܪܝܵܐ، ܒܝܵܘܡܵܢܹ̈ܐ ܕܚܝܼܪܹܗ ܒܝܼܝܼ ܠܸܫܩܵܠܵܐ ܠܵܘܡܝܼ ܡ̣ܢ ܓܵܘ ܒܢܲܝ̈ܢܵܫܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ܒܝܲܪܚܵܐ ܕܫܬܵ‌ܐ ܦܝܼܫ ܠܹܗ ܫܘܼܕܪܵܐ ܡܲܠܲܐܟ݂ܵܐ ܓܲܒ݂ܪܝܼܹܠܔ ܡ̣ܢ ܠܟܸܣ ܐܲܠܵܗܵܐ ܠܓܠܝܼܠܵܐ، ܠܡܕܝܼܢ݇ܬܵ‌ܐ ܫܸܡܘܼܗ̇ ܢܵܨܪܲܬ، ");
INSERT INTO aii_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ܠܟܸܣ ܒܬܘܼܠܬܵ‌ܐ ܛܠܝܼܒܬܵ‌ܐ ܠܓܲܒ݂ܪܵܐ ܫܸܡܹܗ ܝܵܘܣܸܦ، ܡ̣ܢ ܒܹܝܬ ܕܵܘܝܼܕ، ܘܫܸܡܵܐ ܕܒܬܘܼܠܬܵ‌ܐ ܡܲܪܝܲܡ. ");
INSERT INTO aii_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ܘܥܒ݂ܝܼܪܹܗ ܡܲܠܲܐܟ݂ܵܐ ܠܟܸܣܠܘܼܗ̇ ܘܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇: ”ܫܠܵܡܵܐ ܠܵܟ݂ܝ ܡܠܝܼܬܵ‌ܐ ܫܵܦܵܩܲܬ، ܡܵܪܝܵܐ ܥܲܡܵܟ݂ܝ، ܝܵܐ ܒܪܝܼܟ݂ܬܵ‌ܐ ܓܵܘ ܒܲܟ݂ܬܵܬܹ̈‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ܗ̇ܝ ܫܓ݂ܝܼܫ ܠܵܗ̇ ܒܗܹܡܸܙܡܵܢܘܼ̈ܗ‌ܝ، ܘܚܵܫܒ݂ܵܐ ܗܘܵܐ ܕܡܘܼܕܝܼ ܝܠܹܗ ܐܵܗܵܐ ܫܠܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇ ܡܲܠܲܐܟ݂ܵܐ: ”ܠܵܐ ܙܵܕܥܲܬ‌ܝ ܡܲܪܝܲܡ، ܣܵܒܵܒ ܡܘܼܫ݇ܟ̰ܸܚ ܠܵܟ݂ܝ ܫܵܦܵܩܲܬ ܠܟܸܣ ܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","”ܗܵܐ ܒܸܬ ܒܵܛܢܲܬ‌ܝ، ܘܒܸܬ ܗܲܨܠܲܬ‌ܝ ܒܪܘܿܢܵܐ، ܘܒܸܬ ܩܵܪܝܲܬ‌ܝ ܫܸܡܹܗ ܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","”ܘܗ̇ܘ ܒܸܬ ܗܵܘܹܐ ܓܘܼܪܵܐ، ܘܒܪܘܿܢܵܐ ܕܥܸܠܵܝܵܐ ܒܸܬ ܦܵܐܹܫ ܩܸܪܝܵܐ، ܘܒܸܬ ܥܵܒܹܕ ܠܹܗ ܡܵܪܝܵܐ ܐܲܠܵܗܵܐ ܡܲܠܟܵܐ ܥܲܠܔ ܒܲܝܬܵ‌ܐ ܕܕܵܘܝܼܕ ܒܵܒܘܼܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","”ܘܒܸܬ ܥܵܒܹܕ ܡܲܠܟܘܼܬܵ‌ܐ ܥܲܠܔ ܒܲܝܬܵ‌ܐ ܕܝܲܥܩܘܿܒ݂ ܗܲܠܔ ܥܵܠܲܡ، ܘܠܡܲܠܟܘܼܬܹܗ ܠܹܐ ܗܵܘܹܐ ܬܝܵܡܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ܐܡܝܼܪܵܗ̇ ܡܲܪܝܲܡ ܠܡܲܠܲܐܟ݂ܵܐ: ”ܕܵܐܟ݂ܝܼ ܒܸܬ ܗܵܘܹܐ ܐܵܗܵܐ ܡܸܢܕܝܼ ܟܲܕ ܓܲܒ݂ܪܵܐ ܠܹܐ ܝܘܵܢ ܝܕܝܼܥܬܵ‌ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ܓ̰ܘܼܘܸܒ ܠܹܗ ܡܲܠܲܐܟ݂ܵܐ ܒܹܐܡܵܪܵܐ ܐܸܠܘܼܗ̇: ”ܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ ܒܸܬ ܐܵܬܹ‌ܐ ܥܲܠܵܟ݂ܝ، ܘܚܲܝܠܵܐ ܕܥܸܠܵܝܵܐ ܒܸܬ ܫܵܪܹܐ ܥܲܠܵܟ݂ܝ. ܒܘܼܬ ܐܵܗܵܐ ܗ̇ܘ ܕܦܵܐܹܫ ܝܠܝܼܕܵܐ ܡܸܢܵܟ݂ܝ ܩܲܕܝܼܫܵܐ ܝܠܹܗ ܘܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ ܒܸܬ ܦܵܐܹܫ ܩܸܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","”ܘܗܵܐ ܐܘܼܦ ܐܹܠܝܼܫܒܲܥ ܚܸܙܡܵܟ݂ܝ ܒܛܝܼܢܬܵ‌ܐ ܝܠܵܗ̇ ܒܪܘܿܢܵܐ ܒܣܲܝܒܘܼܬܵ‌ܐ، ܘܐܵܗܵܐ ܝܲܪܚܵܐ ܕܫܬܵ‌ܐ ܝܠܹܗ ܠܗ̇ܝ ܕܟܹܐ ܦܵܝܫܵܐ ܩܪܝܼܬܵ‌ܐ ܥܩܲܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","”ܣܵܒܵܒ ܠܲܝܬ ܡܸܢܕܝܼ ܥܲܣܩܵܐ ܠܟܸܣ ܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ܓ̰ܘܼܘܸܒ ܠܵܗ̇ ܡܲܪܝܲܡ ܒܹܐܡܵܪܵܐ: ”ܗܵܐ ܐܵܢܵܐ ܚܸܕܲܡܬܵ‌ܐ ܕܡܵܪܝܵܐ. ܫܒ݂ܘܿܩ ܗܵܘܹܐ ܠܝܼ ܐܲܝܟ݂ ܗܹܡܸܙܡܵܢܘܼܟ݂.“ ܘܐܙܝܼܠܔ ܠܹܗ ܡܲܠܲܐܟ݂ܵܐ ܡ̣ܢ ܠܟܸܣܠܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ܒܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ ܩܝܼܡ ܠܵܗ̇ ܡܲܪܝܲܡ، ܘܐܙܝܼܠܔ ܠܵܗ̇ ܒܓ̰ܲܠܕܘܼܬܵ‌ܐ ܠܛܘܼܪܵܐ، ܠܡܕܝܼܢ݇ܬܵ‌ܐ ܕܝܼܗܘܼܕ. ");
INSERT INTO aii_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ܘܥܒ݂ܝܼܪܵܗ̇ ܠܒܲܝܬܵ‌ܐ ܕܙܟܲܪܝܵܐ، ܘܕܪܹܐ ܠܵܗ̇ ܫܠܵܡܵܐ ܠܐܹܠܝܼܫܒܲܥ. ");
INSERT INTO aii_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܵܗ̇ ܐܹܠܝܼܫܒܲܥ ܫܠܵܡܵܐ ܕܡܲܪܝܲܡ، ܓ̰ܘܝܼܓ̰ ܠܹܗ ܝܵܠܵܕ݇ܐ ܒܟܹܪ݇ܣܘܼܗ̇، ܘܦܝܼܫ ܠܵܗ̇ ܡܠܝܼܬܵ‌ܐ ܡ̣ܢ ܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ܡܘܼܩܘܸܚ ܠܵܗ̇ ܐܹܠܝܼܫܒܲܥ ܒܩܵܠܵܐ ܪܵܡܵܐ ܘܐܡܝܼܪܵܗ̇ ܠܡܲܪܝܲܡ: ”ܒܪܝܼܟ݂ܬܵ‌ܐ ܝܘܲܬ‌ܝ ܓܵܘ ܒܲܟ݂ܬܵܬܹ̈‌ܐ، ܘܒܪܝܼܟ݂ܬܵ‌ܐ ܝܠܵܗ̇ ܛܥܘܼܢܬܵ‌ܐ ܕܟܹܪ݇ܣܵܟ݂ܝ. ");
INSERT INTO aii_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","”ܕܵܐܟ݂ܝܼ ܝܠܵܗ̇ ܐܵܗܵܐ، ܕܝܸܡܵܐ ܕܡܵܪܝܼ ܐܵܬܝܵܐ ܠܟܸܣܠܝܼ؟ ");
INSERT INTO aii_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","”ܣܵܒܵܒ ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܝܼ ܩܵܠܵܟ݂ܝ، ܒܚܲܕܘܼܬܵ‌ܐ ܓܘܼܪܬܵ‌ܐ ܓ̰ܘܝܼܓ̰ ܠܹܗ ܝܵܠܵܕ݇ܐ ܒܟܹܪ݇ܣܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","”ܛܘܼܒ݂ܵܐ ܠܗ̇ܝ ܕܗܘܼܡܸܢܵܗ̇، ܣܵܒܵܒ ܐܲܠܵܗܵܐ ܒܸܬ ܬܲܡܸܡ ܗܹܡܸܙܡܵܢܹ̈ܐ ܕܗܘܼܡܙܸܡ ܠܹܗ ܥܲܡܘܼܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ܐܡܝܼܪܵܗ̇ ܡܲܪܝܲܡ: ”ܫܲܒܘܼܚܹܐ ܝܠܵܗ̇ ܓܵܢܝܼ ܠܡܵܪܝܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ܘܒܸܚܕܵܝܵܐ ܝܠܵܗ̇ ܪܘܼܚܝܼ ܒܐܲܠܵܗܵܐ ܦܵܪܘܿܩܝܼ، ");
INSERT INTO aii_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","”ܣܵܒܵܒ ܕܚܝܼܪܹܗ ܒܡܲܟܝܼܟ݂ܘܼܬܵ‌ܐ ܕܚܸܕܲܡܬܹܗ، ܘܡ̣ܢ ܐܵܕܝܼܵܐ ܟܠܵܝܗ‌ܝ ܫܲܪ̈ܒܵܬܹ‌ܐ ܒܸܬ ܩܵܪܝܼ ܠܝܼ ܒܪܝܼܟ݂ܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","”ܣܵܒܵܒ ܗ̇ܘ ܕܝܼܠܹܗ ܚܲܝܠܬܵܢܵܐ ܥܒ݂ܝܼܕ ܠܹܗ ܐܸܠܝܼ ܡܸܢܕܝܼܵܢܹ̈ܐ ܓܘܼܪܹ̈ܐ، ܩܲܕܝܼܫܵܐ ܝܠܹܗ ܫܸܡܹܗ، ");
INSERT INTO aii_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","”ܪ̈ܲܚܡܘܼܗ‌ܝ ܡ̣ܢ ܕܵܘܪܵܐ ܠܕܵܘܪܵܐ ܝܢܵܐ ܥܲܠܔ ܐܵܢܝܼ ܕܙܵܕܥܝܼ ܡܸܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","”ܥܒ݂ܝܼܕ ܠܹܗ ܓܲܒܵܪܘܼܬܵ‌ܐ ܒܕܪܲܥܢܹܗ، ܘܒܘܼܪܒܸܙ ܠܹܗ ܠܫܲܒ݂ܗܸܪ̈ܵܢܹܐ ܒܚܘܼܫܵܒܹ̈ܐ ܕܠܸܒܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","”ܡܘܼܢܦܸܠܔ ܠܹܗ ܠܓܲܒܵܪܹ̈ܐ ܡ̣ܢ ܟܘܼܪ̈ܣܝܼܵܝܗ‌ܝ، ܘܡܘܼܪܸܡ ܠܹܗ ܠܡܲܟܝܼܟܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","”ܡܘܼܣܒܸܥ ܠܹܗ ܠܟܦܝܼܢܹ̈ܐ ܒܛܵܒ݂ܵܬܹ̈‌ܐ، ܘܥܲܬܝܼܪܹ̈ܐ ܫܘܼܕܪܵܝ ܠܹܗ ܣܦܝܼܩܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","”ܗܘܼܝܸܪܹܗ ܠܐܝܼܣܪܵܐܹܝܠܔ ܪܹܓܹܗ ܟܲܕ ܕܟ݂ܝܼܪܹܗ ܪ̈ܲܚܡܘܼܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","”ܕܵܐܟ݂ܝܼ ܕܗܘܼܡܙܸܡ ܠܹܗ ܥܲܡ ܒܵܒܵܘܵܬܲܢ̈، ܥܲܡ ܐܲܒ݂ܪܵܗܵܡ ܘܥܲܡ ܒܢܘܿܢܘܼ̈ܗ‌ܝ ܠܥܵܠܲܡ.“ ");
INSERT INTO aii_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ܘܦܝܼܫ ܠܵܗ̇ ܡܲܪܝܲܡ ܠܟܸܣ ܐܹܠܝܼܫܒܲܥ ܐܲܝܟ݂ ܬܠܵܬܵ‌ܐ ܝܲܪ̈ܚܹܐ، ܘܕܝܼܪܵܗ̇ ܠܒܲܝܬܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ܘܡܛܹܐ ܠܹܗ ܙܲܒ݂ܢܵܐ ܕܗܲܨܠܵܐ ܗܘܵܐ ܐܹܠܝܼܫܒܲܥ، ܘܝܠܝܼܕ ܠܵܗ̇ ܒܪܘܿܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ܟܲܕ ܫܡܝܼܥ ܠܗܘܿܢ ܫܒ݂ܵܒ݂ܘܼ̈ܗ̇ ܘܚܸܙܡܵܢܘܼ̈ܗ̇ ܕܡܘܼܙܝܸܕ ܠܹܗ ܡܵܪܝܵܐ ܪ̈ܲܚܡܹܐ ܥܲܠܘܼܗ̇، ܚܕܹܐ ܠܗܘܿܢ ܥܲܡܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ܘܗܘܹܐ ܠܵܗ̇ ܒܝܵܘܡܵܐ ܕܬܡܵܢܝܵܐ، ܐܙܝܼܠܔ ܠܗܘܿܢ ܠܸܓܙܵܪܵܐ ܠܝܵܠܵܕ݇ܐ، ܘܒܥܹܐ ܠܗܘܿܢ ܕܡܲܬܒ݂ܝܼ ܠܹܗ ܫܸܡܹܗ ܙܟܲܪܝܵܐ، ܒܫܸܡܵܐ ܕܒܵܒܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ܐܝܼܢܵܐ ܝܸܡܹܗ ܓ̰ܘܼܘܸܒ ܠܵܗ̇ ܒܹܐܡܵܪܵܐ: ”ܠܵܐ ܐܵܗܵܐ ܫܸܡܵܐ، ܐܸܠܵܐ ܦܵܐܹܫ ܩܸܪܝܵܐ ܝܘܿܚܲܢܵܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ܐܡܝܼܪܗܘܿܢ ܐܸܠܘܼܗ̇: ”ܠܲܝܬ ܐܢܵܫܵܐ ܓܵܘ ܚܸܙܡܵܢܵܟ݂ܝ̈ ܒܐܵܗܵܐ ܫܸܡܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ܘܪܡܝܼܙ ܠܗܘܿܢ ܠܒܵܒܘܼܗ‌ܝ ܕܡܲܕܸܥ ܗܘܵܐ ܡܘܼܕܝܼ ܒܵܥܹܐ ܕܦܵܐܹܫ ܩܸܪܝܵܐ ܝܵܠܵܕ݇ܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ܛܠܝܼܒ ܠܹܗ ܠܘܼܚܵܐ، ܘܟܬܝܼܒ݂ ܠܹܗ ܘܐܡܝܼܪܹܗ: ”ܝܘܿܚܲܢܵܢ ܝܼܠܹܗ ܫܸܡܹܗ.“ ܘܥܘܼܓ̰ܸܒ ܠܗܘܿܢ ܟܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ܘܒܗ̇ܝ ܥܕܵܢܵܐ ܦܬܝܼܚ ܠܹܗ ܦܘܼܡܹܗ ܘܫܪܹܐ ܠܹܗ ܠܸܫܵܢܹܗ ܘܫܘܼܒܸܚ ܠܹܗ ܠܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ܙܕܝܼܥ ܠܗܘܿܢ ܟܠܵܝܗ‌ܝ ܕܒܸܥܡܵܪܵܐ ܝܗܘܵܘ ܠܚܵܕܸܪ̈ܘܵܢܵܝܗ‌ܝ، ܘܐܲܢܹܐ ܡܸܢܕܝܼܵܢܹ̈ܐ ܦܵܝܫܝܼ ܗܘܵܘ ܗܘܼܡܙܸܡܹܐ ܒܟܠܹܗ ܛܘܼܪܵܐ ܕܝܼܗܘܼܕ. ");
INSERT INTO aii_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ܘܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܫܵܡܥܝܼ ܗܘܵܘ ܚܵܫܒ݂ܝܼ ܗܘܵܘ ܒܠܸܒܵܝܗ‌ܝ ܘܐܵܡܪܝܼ ܗܘܵܘ: ”ܕܵܐܟ݂ܝܼ ܒܸܬ ܗܵܘܹܐ ܐܵܗܵܐ ܝܵܠܵܕ݇ܐ؟“ ܣܵܒܵܒ ܐܝܼܕܵܐ ܕܡܵܪܝܵܐ ܥܲܠܘܼܗ‌ܝ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ܘܙܟܲܪܝܵܐ ܒܵܒܘܼܗ‌ܝ ܦܝܼܫ ܠܹܗ ܡܸܠܝܵܐ ܡ̣ܢ ܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ، ܘܢܘܼܒܹܐ ܠܹܗ ܘܐܡܝܼܪܹܗ: ");
INSERT INTO aii_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","”ܡܒܘܼܪܟ݂ܵܐ ܝܠܹܗ ܡܵܪܝܵܐ ܐܲܠܵܗܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ، ܕܣܘܼܚܒܸܪܹܗ ܠܥܲܡܹܗ، ܘܗܘܼܕܸܪܹܗ ܐܸܠܹܗ ܦܘܼܪܩܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ܡܘܼܩܸܡ ܠܹܗ ܐܸܠܲܢ ܚܲܝܠܵܐ ܕܦܘܼܪܩܵܢܵܐ، ܡ̣ܢ ܒܲܝܬܵ‌ܐ ܕܕܵܘܝܼܕ ܪܹܓܹܗ، ");
INSERT INTO aii_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ܐܲܝܟ݂ ܕܗܘܼܡܙܸܡ ܠܹܗ ܒܦܘܼܡܵܐ ܕܢܒ݂ܝܼܘܼ̈ܗ‌ܝ ܩܲܕܝܼܫܹ̈ܐ ܕܡ̣ܢ ܥܵܠܲܡ، ");
INSERT INTO aii_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ܕܦܲܪܸܩ ܠܲܢ ܡ̣ܢ ܕܸܫ̃ܡܸܢܲܢ̈، ܘܡ̣ܢ ܐܝܼܕܵܐ ܕܟܠܵܝܗ‌ܝ ܣܵܢܝܵܢܲܢ̈. ");
INSERT INTO aii_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ܥܒ݂ܝܼܕ ܠܹܗ ܪ̈ܲܚܡܹܐ ܥܲܠܔ ܒܵܒܵܘܵܬܲܢ̈، ܘܕܟ݂ܝܼܪܹܗ ܠܘܲܥܕܹܗ ܩܲܕܝܼܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ܘܕܟ݂ܝܼܪܹܗ ܠܡܵܘܡܵܬܹ̈‌ܐ ܕܝܡܹܐ ܠܹܗ ܠܒܵܒܲܢ ܐܲܒ݂ܪܵܗܵܡ، ");
INSERT INTO aii_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ܕܒܸܬ ܦܲܨܹܐ ܠܲܢ ܡ̣ܢ ܐܝܼܕܵܐ ܕܕܸܫ̃ܡܸܢܲܢ̈، ܘܒܸܬ ܥܵܒ݂ܕܲܚ ܚܸܠܡܲܬ ܐܸܠܹܗ ܕܠܵܐ ܙܕܘܼܥܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ܒܩܲܕܝܼܫܘܼܬܵ‌ܐ ܘܒܙܲܕܝܼܩܘܼܬܵ‌ܐ ܒܸܬ ܚܵܕܪܲܚ ܩܲܕܡܘܼܗ‌ܝ ܟܠܵܝܗ‌ܝ ܝܵܘܡܵܢܲܢ̈. ");
INSERT INTO aii_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ܘܐܲܢ݇ܬ ܝܵܠܵܕ݇ܐ، ܢܒ݂ܝܼܵܐ ܕܥܸܠܵܝܵܐ ܒܸܬ ܦܵܝܫܹܬ ܩܸܪܝܵܐ، ܣܵܒܵܒ ܒܸܬ ܚܵܕܪܹܬ ܩܲܕܡ ܡܵܪܝܵܐ، ܘܗܲܕܪܸܬ ܐܘܼܪ̈ܚܵܬܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ܕܝܵܗܒܹܬ ܝܕܵܥܬܵ‌ܐ ܕܦܘܼܪܩܵܢܵܐ ܠܥܲܡܵܐ ܒܦܘܼܚܵܠܵܐ ܕܚܛܝܼܵܬܵܝ̈ܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ܒܪ̈ܲܚܡܹܐ ܘܚܢܵܢܵܐ ܕܐܲܠܵܗܲܢ، ܕܒܝܼܵܝܗ‌ܝ ܒܸܬ ܫܵܪܹܐ ܥܲܠܲܢ ܙܪܵܩܵܐ ܡ̣ܢ ܪܵܘܡܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ܠܒܲܗܪܘܼܢܹܐ ܠܐܵܢܝܼ ܕܝܼܢܵܐ ܝܬܝܼܒܹܐ ܒܚܸܫܟܵܐ ܘܒܛܸܠܵܢܝܵܬܹ̈‌ܐ ܕܡܵܘܬܵ‌ܐ، ܠܡܗܲܕܘܼܝܹܐ ܐܲܩܠܵܬܲܢ̈ ܒܐܘܼܪܚܵܐ ܕܫܠܵܡܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ܘܓܘܼܪܘܸܣ ܠܹܗ ܝܵܠܵܕ݇ܐ ܘܚܘܼܠܸܢܹܗ ܒܪܘܼܚܵܐ. ܘܗܘܹܐ ܠܹܗ ܓܵܘ ܒܲܪܝܼܵܐ ܗܲܠܔ ܝܵܘܡܵܐ ܕܡܲܚܙܲܝܬܹܗ ܠܒܢܲܝ̈ ܐܝܼܣܪܵܐܹܝܠܔ. ");
INSERT INTO aii_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ܒܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ ܦܠܝܼܛ ܠܹܗ ܦܘܼܩܕܵܢܵܐ ܡ̣ܢ ܐܵܓ݂ܘܼܣܛܘܿܣ ܩܹܣܲܪ ܕܦܵܝܫܝܼ ܡܘܼܟܬܸܒܹܐ ܟܠܵܝܗ‌ܝ ܐܢܵܫܹ̈ܐ ܕܡܲܠܟܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ܐܵܗܵܐ ܡܲܟܬܲܒ݂ܬܵ‌ܐ ܩܲܕܡܵܝܬܵ‌ܐ ܗܘܹܐ ܠܵܗ̇ ܒܥܕܵܢܵܐ ܕܩܸܘܪܝܼܢܘܿܣ ܝܼܗܘܵܐ ܫܲܠܝܼܛܵܐ ܒܣܘܼܪܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ܘܐܙܝܼܠܔ ܠܹܗ ܟܠܔ ܐܢܵܫܵܐ ܠܡܕܝܼܢ݇ܬܵ‌ܐ ܕܓܵܢܹܗ ܕܡܲܟܬܸܒ݂ ܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ܘܐܣܝܼܩ ܠܹܗ ܐܘܼܦ ܝܵܘܣܸܦ ܡ̣ܢ ܢܵܨܪܲܬ، ܡܕܝܼܢ݇ܬܵ‌ܐ ܕܓܠܝܼܠܵܐ، ܠܝܼܗܘܼܕ، ܠܡܕܝܼܢ݇ܬܵ‌ܐ ܕܕܵܘܝܼܕ ܕܦܝܵܫܵܐ ܝܠܵܗ̇ ܩܪܝܼܬܵ‌ܐ ܒܹܝܬܠܚܸܡ، ܣܵܒܵܒ ܡ̣ܢ ܒܲܝܬܵ‌ܐ ܘܫܲܪܒܬܵ‌ܐ ܕܕܵܘܝܼܕ ܝܼܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ܐܙܝܼܠܔ ܠܹܗ ܕܡܲܟܬܸܒ݂ ܗܘܵܐ ܬܵܡܵܐ ܥܲܡ ܡܲܪܝܲܡ ܛܠܝܼܒܬܹܗ ܟܲܕ ܗ̇ܝ ܒܛܝܼܢܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ܘܗܘܹܐ ܠܵܗ̇ ܟܲܕ ܐܵܢܝܼ ܬܵܡܵܐ ܝܗܘܵܘ ܡܛܹܐ ܠܗܘܿܢ ܝܵܘܡܵܢܹ̈ܐ ܕܗܲܨܠܵܐ ܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ܘܝܠܝܼܕ ܠܵܗ̇ ܒܪܘܿܢܘܼܗ̇ ܒܘܼܟ݂ܪܵܐ، ܘܟܘܼܪܡܸܟ݂ ܠܵܗ̇ ܐܸܠܹܗ ܒܒܲܢܕܹ̈ܐ، ܘܡܘܼܬܸܒ݂ ܠܵܗ̇ ܒܐܘܼܪܹܐ، ܣܵܒܵܒ ܠܲܝܬ ܗܘܵܘ ܠܗܘܿܢ ܕܘܼܟܵܐ ܓܵܘ ܡܲܫܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ܘܐܝܼܬ ܗܘܵܘ ܪ̈ܵܥܝܹܐ ܒܗ̇ܝ ܕܘܼܟܵܐ ܫܸܪܝܹܐ ܒܚܲܩܠܵܐ، ܒܸܢܛܵܪܵܐ ܒܲܕ̈ܠܹܐ ܕܠܲܝܠܹܐ ܥܲܠܔ ܦܸܣܩܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ܘܗܵܐ ܡܲܠܲܐܟ݂ܵܐ ܕܡܵܪܝܵܐ ܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣܠܵܝܗ‌ܝ، ܘܬܸܫܒܘܿܚܬܵ‌ܐ ܕܡܵܪܝܵܐ ܒܘܼܗܪܸܢܵܗ̇ ܠܚܵܕܸܪ̈ܘܵܢܵܝܗ‌ܝ، ܘܙܕܝܼܥ ܠܗܘܿܢ ܙܕܘܼܥܬܵ‌ܐ ܓܘܼܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܡܲܠܲܐܟ݂ܵܐ: ”ܠܵܐ ܙܵܕܥܝܼܬܘܿܢ، ܣܵܒܵܒ ܗܵܐ ܡܲܫܚܘܼܕܹܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ ܚܲܕܘܼܬܵ‌ܐ ܓܘܼܪܬܵ‌ܐ ܕܒܸܬ ܗܵܘܝܵܐ ܠܟܠܹܗ ܥܵܠܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","”ܦܝܼܫ ܠܹܗ ܝܠܝܼܕܵܐ ܐܸܠܵܘܟ݂ܘܿܢ ܐܸܕܝܘܿܡ ܝܵܘܡܵܐ ܓܵܘ ܡܕܝܼܢ݇ܬܵ‌ܐ ܕܕܵܘܝܼܕ، ܦܵܪܘܿܩܵܐ، ܗ̇ܘ ܕܝܼܠܹܗ ܡܫܝܼܚܵܐ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","”ܘܐܵܗܵܐ ܝܠܹܗ ܢܝܼܫܲܢܩܵܐ ܐܸܠܵܘܟ݂ܘܿܢ: ܒܸܬ ܡܲܫ݇ܟ̰ܚܝܼܬܘܿܢ ܝܵܠܵܕ݇ܐ ܟܘܼܪܡܸܟ݂ܵܐ ܒܒܲܢܕܹ̈ܐ، ܘܡܘܼܬܒ݂ܵܐ ܒܐܘܼܪܹܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ܘܡܸܢܫܸܠܬܵܢܹܐ ܦܝܼܫ ܠܗܘܿܢ ܚܸܙܝܹܐ ܥܲܡ ܡܲܠܲܐܟ݂ܵܐ ܚܲܝܠܵܘܵܬܹ̈‌ܐ ܕܫܡܲܝܵܐ ܪܵܒܵܐ، ܫܲܒܘܼܚܹܐ ܠܐܲܠܵܗܵܐ ܘܒܹܐܡܵܪܵܐ: ");
INSERT INTO aii_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","”ܬܸܫܒܘܿܚܬܵ‌ܐ ܠܐܲܠܵܗܵܐ ܒܲܡܪ̈ܵܘܡܹܐ، ܘܥܲܠܔ ܐܲܪܥܵܐ ܫܠܵܡܵܐ ܘܣܲܒ݂ܪܵܐ ܛܵܒ݂ܵܐ ܠܒܢܲܝ̈ܢܵܫܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ܗܘܹܐ ܠܵܗ̇ ܟܲܕ ܐܙܝܼܠܔ ܠܗܘܿܢ ܡ̣ܢ ܠܟܸܣܠܵܝܗ‌ܝ ܡܲܠܲܐܟܹ̈ܐ ܠܫܡܲܝܵܐ، ܗܘܼܡܙܸܡ ܠܗܘܿܢ ܪ̈ܵܥܝܹܐ ܚܲܕ ܥܲܡ ܗ̇ܘ ܐܚܹܪܢܵܐ، ܘܐܡܝܼܪܗܘܿܢ: ”ܐܵܙܲܠ݇ܚ ܗܲܠܔ ܒܹܝܬܠܚܸܡ، ܘܚܵܙܲܚ ܠܐܵܗܵܐ ܡܸܢܕܝܼ ܕܗܘܹܐ ܠܹܗ، ܐܲܝܟ݂ ܕܡܵܪܝܵܐ ܩܲܕܡ ܡܲܕܸܥ ܠܲܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܒܓ̰ܲܠܕܘܼܬܵ‌ܐ ܘܚܙܹܐ ܠܗܘܿܢ ܠܡܲܪܝܲܡ ܘܠܝܵܘܣܸܦ، ܘܠܝܵܠܵܕ݇ܐ ܡܘܼܬܒ݂ܵܐ ܒܐܘܼܪܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ܘܐܝܼܡܲܢ ܕܚܙܹܐ ܠܗܘܿܢ، ܡܘܼܕܸܥ ܠܗܘܿܢ ܡܸܢܕܝܼ ܕܦܝܼܫ ܠܹܗ ܗܘܼܡܙܸܡܵܐ ܐܸܠܵܝܗ‌ܝ ܒܘܼܬ ܐܵܗܵܐ ܝܵܠܵܕ݇ܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ܘܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܫܡܝܼܥ ܠܗܘܿܢ ܥܘܼܓ̰ܸܒ ܠܗܘܿܢ ܒܘܼܬ ܡܸܢܕܝܼܵܢܹ̈ܐ ܕܦܝܼܫ ܠܗܘܿܢ ܐܡܝܼܪܹܐ ܐܸܠܵܝܗ‌ܝ ܡ̣ܢ ܪ̈ܵܥܝܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ܐܝܼܢܵܐ ܡܲܪܝܲܡ ܢܵܛܪܵܐ ܗܘܵܐ ܟܠܵܝܗ‌ܝ ܐܲܢܹܐ ܗܹܡܸܙܡܵܢܹ̈ܐ، ܘܬܲܚܡܸܢܵܐ ܗܘܵܐ ܒܘܼܬ ܕܝܼܵܝܗ‌ܝ ܒܠܸܒܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ܕܝܼܪܗܘܿܢ ܐܵܢܝܼ ܪ̈ܵܥܝܹܐ ܟܲܕ ܫܲܒܘܼܚܹܐ ܘܡܲܐܣܘܼܩܹܐ ܫܘܼܒ݂ܚܹ̈ܐ ܠܐܲܠܵܗܵܐ ܒܘܼܬ ܟܠܔ ܡܸܢܕܝܼ ܕܚܙܹܐ ܠܗܘܿܢ ܘܕܫܡܝܼܥ ܠܗܘܿܢ، ܕܵܐܟ݂ܝܼ ܕܦܝܼܫ ܠܹܗ ܐܡܝܼܪܵܐ ܐܸܠܵܝܗ‌ܝ ܒܝܲܕ ܡܲܠܲܐܟ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ܘܐܝܼܡܲܢ ܕܬܘܼܡܸܡ ܠܗܘܿܢ ܬܡܵܢܝܵܐ ܝܵܘܡܵܢܹ̈ܐ ܕܦܵܐܹܫ ܓܙܝܼܪܵܐ ܝܵܠܵܕ݇ܐ، ܩܪܹܐ ܠܗܘܿܢ ܫܸܡܹܗ ܝܼܫܘܿܥ، ܕܵܐܟ݂ܝܼ ܕܦܝܼܫܵܐ ܝܗܘܵܐ ܩܸܪܝܵܐ ܒܝܲܕ ܡܲܠܲܐܟ݂ܵܐ ܡ̣ܢ ܩܲܕܡ ܕܦܵܐܹܫ ܗܘܵܐ ܒܛܝܼܢܵܐ ܒܟܹܪ݇ܣܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ܟܲܕ ܬܘܼܡܸܡ ܠܗܘܿܢ ܝܵܘܡܵܢܹ̈ܐ ܕܕܲܟܲܝܬܵܝܗ‌ܝ ܐܲܝܟ݂ ܢܵܡܘܿܣܵܐ ܕܡܘܼܫܹܐ، ܡܘܼܐܣܸܩ ܠܗܘܿܢ ܐܸܠܹܗ ܠܐܘܿܪܸܫܠܸܡ ܕܡܲܩܪܸܒ݂ܝܼ ܠܹܗ ܩܲܕܡ ܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ܐܲܝܟ݂ ܕܝܼܠܹܗ ܟܬܝܼܒ݂ܵܐ ܒܢܵܡܘܿܣܵܐ ܕܡܵܪܝܵܐ: ܟܠܔ ܐܘܼܪܙܵܐ ܒܸܪܝܵܐ ܩܲܕܡܵܝܵܐ، ܩܲܕܝܼܫܵܐ ܕܡܵܪܝܵܐ ܒܸܬ ܦܵܐܹܫ ܩܸܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ܘܗܵܕܟ݂ܵܐ ܡܘܼܩܪܸܒ݂ ܠܗܘܿܢ ܕܸܒ݂ܚܵܐ، ܕܵܐܟ݂ܝܼ ܕܝܼܠܹܗ ܐܡܝܼܪܵܐ ܒܢܵܡܘܿܣܵܐ ܕܡܵܪܝܵܐ: ܚܲܕ ܙܵܘܓܵܐ ܕܓܘܼܪ̈ܓܘܼܡܹܐ، ܝܲܢ ܬܪܹܝ ܙܲܥܝܹ̈ܐ ܕܝܵܘܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ܐܝܼܬ ܗܘܵܐ ܚܲܕ ܐܢܵܫܵܐ ܓܵܘ ܐܘܿܪܸܫܠܸܡ، ܫܸܡܹܗ ܫܸܡܥܘܿܢ، ܐܢܵܫܵܐ ܟܹܐܢܵܐ ܘܙܲܕܝܼܩܵܐ ܝܗܘܵܐ، ܘܒܸܣܦܵܪܵܐ ܝܗܘܵܐ ܠܝܵܗܒ݂ܵܠܬܵ‌ܐ ܕܠܸܒܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ، ܘܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ ܐܝܼܬ ܗܘܵܐ ܥܲܠܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ܘܦܝܼܫܵܐ ܝܗܘܵܐ ܓܸܠܝܵܐ ܐܸܠܹܗ ܒܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ ܕܠܹܐ ܚܵܙܹܐ ܡܵܘܬܵ‌ܐ ܗܲܠܔ ܕܚܵܙܹܐ ܡܫܝܼܚܵܐ ܕܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ܐܵܗܵܐ ܐܬܹ‌ܐ ܠܹܗ ܠܗܲܝܟܠܵܐ ܡܗܘܼܕܝܵܐ ܒܪܘܼܚܵܐ، ܒܥܕܵܢܵܐ ܕܡܲܥܒ݂ܘܼܪܹܐ ܝܗܘܵܘ ܐܲܒ݂ܵܗܹ̈ܐ ܕܝܼܫܘܿܥ ܠܝܵܠܵܕ݇ܐ ܕܥܵܒ݂ܕܝܼ ܐܸܠܹܗ ܕܵܐܟ݂ܝܼ ܕܦܝܼܫܵܐ ܝܠܹܗ ܦܩܝܼܕܵܐ ܒܢܵܡܘܿܣܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ܫܩܝܼܠܔ ܠܹܗ ܫܸܡܥܘܿܢ ܠܝܵܠܵܕ݇ܐ ܥܲܠܔ ܕܪ̈ܲܥܢܵܢܘܼܗ‌ܝ، ܘܫܘܼܒܸܚ ܠܹܗ ܠܐܲܠܵܗܵܐ، ܘܐܡܝܼܪܹܗ: ");
INSERT INTO aii_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","”ܝܵܐ ܡܵܪܝܵܐ، ܐܵܕܝܼܵܐ ܫܩܘܿܠܔ ܠܪܹܓܘܼܟ݂ ܒܫܠܵܡܵܐ ܐܲܝܟ݂ ܗܹܡܸܙܡܵܢܘܼܟ݂، ");
INSERT INTO aii_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ܣܵܒܵܒ ܚܙܹܐ ܠܗܘܿܢ ܥܲܝ̈ܢܝܼ ܦܘܼܪܩܵܢܘܼܟ݂، ");
INSERT INTO aii_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ܗ̇ܘ ܕܗܘܼܕܸܪܘܼܟ݂ ܩܲܕܡ ܥܲܝ̈ܢܹܐ ܕܟܠܹܗ ܥܵܠܡܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ܒܲܗܪܵܐ ܕܒܲܗܪܸܢ ܠܐܸܡܘܵܬܹ̈‌ܐ، ܘܚܸܩܪܵܐ ܠܥܲܡܘܼܟ݂ ܐܝܼܣܪܵܐܹܝܠܔ.“ ");
INSERT INTO aii_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ܝܵܘܣܸܦ ܘܡܲܪܝܲܡ ܥܘܼܓ̰ܸܒ ܠܗܘܿܢ ܒܐܲܢܹܐ ܕܦܝܼܫ ܠܗܘܿܢ ܐܡܝܼܪܹܐ ܒܘܼܬ ܕܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ܒܘܼܪܟ݂ܵܝ ܠܹܗ ܫܸܡܥܘܿܢ، ܘܐܡܝܼܪܹܗ ܠܡܲܪܝܲܡ ܝܸܡܹܗ ܕܝܵܠܵܕ݇ܐ: ”ܐܵܗܵܐ ܝܵܠܵܕ݇ܐ ܡܘܼܬܒ݂ܵܐ ܝܠܹܗ ܩܵܐ ܢܦܵܠܬܵ‌ܐ ܘܩܝܵܡܬܵ‌ܐ ܕܪܵܒܵܐ ܓܵܘ ܒܢܲܝ̈ ܐܝܼܣܪܵܐܹܝܠܔ، ܘܠܢܝܼܫܲܢܩܵܐ ܕܡܲܩܲܪܵܨܘܼܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","”ܕܦܵܝܫܝܼ ܓܸܠܝܹܐ ܚܘܼܫܵܒܹ̈ܐ ܕܪܵܒܵܐ ܠܸܒܵܘܵܬܹ̈‌ܐ، ܘܪܘܼܡܚܵܐ ܒܸܬ ܥܵܒ݂ܪܵܐ ܒܓܵܢܵܟ݂ܝ.“ ");
INSERT INTO aii_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ܘܐܝܼܬ ܗܘܵܐ ܚܕܵܐ ܢܒ݂ܝܼܬܵ‌ܐ ܫܸܡܘܼܗ̇ ܚܲܢܵܐ، ܒܪܵܬܵ‌ܐ ܕܦܢܘܼܐܹܝܠܔ، ܡ̣ܢ ܫܲܒ݂ܛܵܐ ܕܐܵܫܹܝܪ، ܓܘܼܪܬܵ‌ܐ ܒܫܸܢܹ̈ܐ ܘܚܝܹܐ ܠܵܗ̇ ܫܒܲܥ ܫܸܢܹ̈ܐ ܥܲܡ ܓܲܒ݂ܪܘܼܗ̇ ܗܵܐ ܡ̣ܢ ܒܬܘܼܠܘܼܬܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ܗܘܝܼܬܵ‌ܐ ܝܗܘܵܐ ܐܲܪܡܸܠܬܵ‌ܐ ܩܘܼܪܒܵܐ ܠܬܡܵܢܝܼ ܘܐܲܪܒܲܥ ܫܸܢܹ̈ܐ، ܘܒܟܠܔ ܥܕܵܢܵܐ ܗܵܘܝܵܐ ܗܘܵܐ ܓܵܘ ܗܲܝܟܠܵܐ ܒܨܵܘܡܵܐ ܘܒܨܠܘܿܬܵ‌ܐ، ܘܒܸܣܓ݂ܵܕܵܐ ܒܐܝܼܡܵܡܵܐ ܘܒܠܲܝܠܹܐ، ");
INSERT INTO aii_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ܐܘܼܦ ܗ̇ܝ ܟܠܹܐ ܠܵܗ̇ ܒܗ̇ܝ ܥܕܵܢܵܐ ܘܫܘܼܒܸܚ ܠܵܗ̇ ܠܐܲܠܵܗܵܐ، ܘܗܲܡܙܸܡܵܐ ܗܘܵܐ ܒܘܼܬ ܝܼܫܘܿܥ ܥܲܡ ܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܒܸܣܦܵܪܵܐ ܝܗܘܵܘ ܠܦܘܼܪܩܵܢܵܐ ܕܐܘܿܪܸܫܠܸܡ. ");
INSERT INTO aii_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ܘܟܲܕ ܬܘܼܡܸܡ ܠܗܘܿܢ ܟܠܔ ܡܸܢܕܝܼ ܐܲܝܟ݂ ܢܵܡܘܿܣܵܐ ܕܡܵܪܝܵܐ، ܕܝܼܪܗܘܿܢ ܠܓܠܝܼܠܵܐ، ܠܢܵܨܪܲܬ ܡܕܝܼܢ݇ܬܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ܘܝܵܠܵܕ݇ܐ ܓܘܼܪܘܸܣ ܠܹܗ، ܘܚܘܼܠܸܢܹܗ ܒܪܘܼܚܵܐ، ܘܦܝܼܫ ܠܹܗ ܡܸܠܝܵܐ ܚܸܟ݂ܡܬܵ‌ܐ، ܘܫܵܦܵܩܲܬ ܕܡܵܪܝܵܐ ܥܲܠܘܼܗ‌ܝ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ܒܟܠܔ ܫܹܢ݇ܬܵ‌ܐ ܐܲܒ݂ܵܗܹ̈ܐ ܕܝܼܫܘܿܥ ܟܹܐ ܐܵܙܠ݇ܝܼ ܗܘܵܘ ܠܐܘܿܪܸܫܠܸܡ ܩܵܐ ܥܹܐܕܵܐ ܕܦܸܨܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ܐܝܼܡܲܢ ܕܗܘܹܐ ܠܹܗ ܝܼܫܘܿܥ ܬܪܸܥܣܲܪ ܫܸܢܹ̈ܐ، ܐܣܝܼܩ ܠܗܘܿܢ ܠܥܹܐܕܵܐ ܡܐܲܝܟ݂ ܥܵܕܲܬ. ");
INSERT INTO aii_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ܘܐܝܼܡܲܢ ܕܬܘܼܡܸܡ ܠܗܘܿܢ ܝܵܘܡܵܢܹ̈ܐ ܕܥܹܐܕܵܐ ܕܝܼܪܗܘܿܢ ܝܵܘܣܸܦ ܘܡܲܪܝܲܡ، ܘܝܼܫܘܿܥ ܝܵܠܵܕ݇ܐ ܦܝܼܫ ܠܹܗ ܓܵܘ ܐܘܿܪܸܫܠܸܡ. ܝܵܘܣܸܦ ܘܝܸܡܹܗ ܠܵܐ ܝܕܝܼܥ ܠܗܘܿܢ ܒܝܼܹܗ، ");
INSERT INTO aii_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ܣܵܒܵܒ ܚܫܝܼܒ݂ ܠܗܘܿܢ ܕܥܲܡ ܚܲܒ݂ܪ̈ܵܘܵܬܘܼܗ‌ܝ ܝܗܘܵܐ. ܐܬܹ‌ܐ ܠܗܘܿܢ ܐܘܼܪܚܵܐ ܕܚܲܕ ܝܵܘܡܵܐ، ܘܛܥܹܐ ܠܗܘܿܢ ܒܵܬܪܹܗ ܓܵܘ ܚܸܙܡܵܢܵܝ̈ܗ‌ܝ ܘܓܵܘ ܐܵܢܝܼ ܕܝܵܕܥܝܼ ܗܘܵܘ ܠܗܘܿܢ، ");
INSERT INTO aii_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ܘܠܵܐ ܡܘܼܫ݇ܟ̰ܸܚ ܠܗܘܿܢ ܐܸܠܹܗ. ܕܝܼܪܗܘܿܢ ܡܸܢܕܪܸܫ ܠܐܘܿܪܸܫܠܸܡ ܒܸܛܥܵܝܵܐ ܒܵܬܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ܘܡ̣ܢ ܒܵܬܪ ܬܠܵܬܵ‌ܐ ܝܵܘܡܵܢܹ̈ܐ، ܡܘܼܫ݇ܟ̰ܸܚ ܠܗܘܿܢ ܐܸܠܹܗ ܓܵܘ ܗܲܝܟܠܵܐ، ܝܬܝܼܒ݂ܵܐ ܓܵܘ ܡܲܠܦܵܢܹ̈ܐ، ܒܸܫܡܵܥܵܐ ܐܸܠܵܝܗ‌ܝ، ܘܒܲܩܘܼܪܵܝ ܒܘܼܩܵܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ܥܲܓ̰ܒܝܼ ܗܘܵܘ ܒܚܸܟ݂ܡܬܹܗ ܘܒܓ̰ܘܼܘܵܒܘܼ̈ܗ‌ܝ ܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܫܵܡܥܝܼ ܗܘܵܘ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ܐܝܼܡܲܢ ܕܒܵܒܘܼܗ‌ܝ ܘܝܸܡܹܗ ܚܙܹܐ ܠܗܘܿܢ ܐܸܠܹܗ ܥܘܼܓ̰ܸܒ ܠܗܘܿܢ. ܘܐܡܝܼܪܵܗ̇ ܐܸܠܹܗ ܝܸܡܹܗ: ”ܒܪܘܿܢܝܼ، ܩܵܡܘܿܕܝܼ ܗܵܕܟ݂ܵܐ ܥܒ݂ܝܼܕ ܠܘܼܟ݂ ܒܝܼܲܢ؟ ܐܵܢܵܐ ܘܒܵܒܘܼܟ݂ ܓ̰ܘܼܢܓ̰ܸܪܲܢ ܒܸܛܥܵܝܵܐ ܒܵܬܪܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܩܵܡܘܿܕܝܼ ܒܸܛܥܵܝܵܐ ܝܬܘܿܢ ܗܘܵܘ ܒܵܬܪܝܼ؟ ܠܹܐ ܝܵܕܥܝܼܬܘܿܢ ܗܘܵܘ ܕܓܵܘ ܒܲܝܬܵ‌ܐ ܕܒܵܒܝܼ ܘܵܠܹܐ ܝܠܵܗ̇ ܕܗܵܘܹܝܢ؟“ ");
INSERT INTO aii_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ܐܝܼܢܵܐ ܐܵܢܝܼ ܠܵܐ ܦܘܼܪܡܹܐ ܠܗܘܿܢ ܐܵܗܵܐ ܡܸܢܕܝܼ ܕܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ܘܨܠܹܐ ܠܹܗ ܥܲܡܵܝܗ‌ܝ ܘܐܬܹ‌ܐ ܠܹܗ ܠܢܵܨܪܲܬ، ܘܟܹܐ ܫܵܠܹܡ ܗܘܵܐ ܐܸܠܵܝܗ‌ܝ. ܘܝܸܡܹܗ ܟܹܐ ܢܵܛܪܵܐ ܗܘܵܐ ܟܠܵܝܗ‌ܝ ܗܹܡܸܙܡܵܢܹ̈ܐ ܒܠܸܒܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ܘܝܼܫܘܿܥ ܓܲܪܘܘܼܣܹܐ ܝܗܘܵܐ ܒܩܵܘܡܬܵ‌ܐ ܘܒܚܸܟ݂ܡܬܵ‌ܐ، ܘܒܫܵܦܵܩܲܬ ܩܲܕܡ ܐܲܠܵܗܵܐ ܘܒܢܲܝ̈ܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ܒܫܹܢ݇ܬܵ‌ܐ ܕܚܲܡܫܲܥܣܲܪ ܝܼܗܘܵܐ ܠܡܲܠܟܘܼܬܵ‌ܐ ܕܛܹܒܲܪܝܼܘܿܣ ܩܹܣܲܪ، ܘܦܵܢܛܝܼܘܿܣ ܦܝܼܠܵܛܘܿܣ ܫܲܠܝܼܛܵܐ ܕܝܼܗܘܼܕ ܝܼܗܘܵܐ، ܘܗܹܪܘܿܕܸܣ ܛܸܛܪܲܪܟܵܐ ܕܓܠܝܼܠܵܐ، ܘܦܝܼܠܝܼܦܘܿܣ ܐܲܚܘܿܢܘܼܗ‌ܝ ܛܸܛܪܲܪܟܵܐ ܕܐܝܼܛܘܼܪܝܼܵܐ ܘܐܲܬܪܵܐ ܕܛܪܵܟ݂ܘܿܢܵܐ، ܘܠܘܼܣܵܢܝܵܐ ܛܸܛܪܲܪܟܵܐ ܕܐܵܒ݂ܝܼܠܝܼܢܹܐ، ");
INSERT INTO aii_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ܘܒܥܕܵܢܵܐ ܕܚܲܢܵܢ ܘܩܲܝܵܦܵܐ ܓܘܼܪܹ̈ܐ ܕܟܵܗ̈ܢܹܐ ܝܗܘܵܘ، ܗܘܹܐ ܠܵܗ̇ ܗܹܡܸܙܡܵܢ ܕܐܲܠܵܗܵܐ ܥܲܠܔ ܝܘܿܚܲܢܵܢ ܒܪܘܿܢܵܐ ܕܙܟܲܪܝܵܐ ܓܵܘ ܒܲܪܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ܘܐܬܹ‌ܐ ܠܹܗ ܒܟܠܹܗ ܐܲܬܪܵܐ ܕܚܵܕܸܪ̈ܘܵܢܹܐ ܕܝܘܿܪܕܢܵܢ، ܡܲܟܪܘܼܙܹܐ ܡܲܥܡܘܿܕܝܼܬܵ‌ܐ ܕܬܝܵܒ݂ܘܼܬܵ‌ܐ ܠܦܘܼܚܵܠܵܐ ܕܚܛܝܼܵܬܹ̈‌ܐ، ܕܐܢܵܫܹ̈ܐ ܦܵܝܫܝܼ ܥܡܝܼܕܹܐ ܘܬܲܘܸܒܝܼ ܕܦܵܝܫܝܼ ܫܒ݂ܝܼܩܹܐ ܚܛܝܼܵܬܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ܕܵܐܟ݂ܝܼ ܕܝܼܠܹܗ ܟܬܝܼܒ݂ܵܐ ܒܟܬܵܒ݂ܵܐ ܕܐܹܫܲܥܝܵܐ ܢܒ݂ܝܼܵܐ ܒܹܐܡܵܪܵܐ: ܩܵܠܵܐ ܒܸܩܪܵܝܵܐ ܓܵܘ ܒܲܪܝܼܵܐ: ”ܗܲܕܪܘܼܢ ܐܘܼܪܚܵܐ ܕܡܵܪܝܵܐ، ܘܡܲܫܘܹܝܡܘܼܢ ܫܒ݂ܝܼܠܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","”ܟܠܵܝܗ‌ܝ ܪ̈ܵܘܘܿܠܹܐ ܒܸܬ ܦܵܝܫܝܼ ܡܸܠܝܹܐ، ܘܟܠܵܝܗ‌ܝ ܛܘܼܪ̈ܵܢܹܐ ܘܪ̈ܘܼܡܝܵܬܹ‌ܐ ܒܸܬ ܦܵܝܫܝܼ ܡܘܼܟܸܦܹܐ، ܦܟ̰ܝܼܠܵܐ ܒܸܬ ܦܵܐܹܫ ܬܪܘܼܨܵܐ، ܘܕܘܼܟܵܐ ܥܲܣܩܵܐ ܒܸܬ ܗܵܘܝܵܐ ܐܲܝܟ݂ ܕܸܫܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","”ܘܟܠܔ ܐܢܵܫܵܐ ܒܸܬ ܚܵܙܹܐ ܦܘܼܪܩܵܢܵܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ܘܝܘܿܚܲܢܵܢ ܐܵܡܹܪ ܗܘܵܐ ܠܟܸܢܫܹ̈ܐ ܕܐܵܬ‌ܝܼ ܗܘܵܘ ܠܟܸܣܠܹܗ ܠܸܥܡܵܕܵܐ: ”ܙܲܪ̈ܥܹܐ ܕܐܵܟܸܕܢܹ̈ܐ، ܡܵܢܝܼ ܐܡܝܼܪܹܗ ܐܸܠܵܘܟ݂ܘܿܢ ܕܥܵܪܩܝܼܬܘܿܢ ܡ̣ܢ ܟܲܪܒܵܐ ܕܒܹܐܬܵܝܵܐ ܝܠܵܗ̇؟ ");
INSERT INTO aii_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","”ܥܒ݂ܘܿܕܘܼܢ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܕܚܵܫܚܝܼ ܠܬܝܵܒ݂ܘܼܬܵ‌ܐ. ܠܵܐ ܫܲܪܹܝܬܘܿܢ ܠܹܐܡܵܪܵܐ ܒܓܵܢܵܘܟ݂ܘܿܢ: ’ܐܲܚܢܲܢ ܒܢܘܿܢܹ̈ܐ ܕܐܲܒ݂ܪܵܗܵܡ ܝܼܘܲܚ،‘ ܣܵܒܵܒ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܟܹܐ ܡܵܨܹܐ ܐܲܠܵܗܵܐ ܡ̣ܢ ܐܲܢܹܐ ܟܹܐܦܹ̈ܐ ܡܲܩܸܡ ܒܢܘܿܢܹ̈ܐ ܠܐܲܒ݂ܪܵܗܵܡ. ");
INSERT INTO aii_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","”ܗܵܐ ܢܲܪܥܵܐ ܡܘܼܬܒ݂ܵܐ ܝܠܹܗ ܥܲܠܔ ܥܸܩܪܵܐ ܕܐܝܼܠܵܢܵܐ. ܟܠܔ ܐܝܼܠܵܢܵܐ ܕܠܵܐ ܛܵܥܹܢ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܛܵܒܹ̈ܐ، ܟܹܐ ܦܵܐܹܫ ܦܪܝܼܡܵܐ ܘܕܸܪܝܵܐ ܒܢܘܼܪܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ ܟܸܢܫܹ̈ܐ ܒܹܐܡܵܪܵܐ: ”ܡܘܼܕܝܼ ܥܵܒ݂ܕܲܚ؟“ ");
INSERT INTO aii_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܘܿܚܲܢܵܢ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܡ̇ܢ ܕܐܝܼܬ ܠܹܗ ܬܲܪܬܹܝ ܨܘܼܕܪ̈ܵܬܹ‌ܐ ܝܵܗܒܹܠܔ ܠܡ̇ܢ ܕܠܲܝܬ ܠܹܗ، ܘܡ̇ܢ ܕܐܝܼܬ ܠܹܗ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ ܝܵܗܒܹܠܔ ܠܡ̇ܢ ܕܠܲܝܬ ܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ܐܬܹ‌ܐ ܠܗܘܿܢ ܡܵܟ݂ܣܹ̈ܐ ܕܦܵܝܫܝܼ ܗܘܵܘ ܥܡܝܼܕܹܐ ܒܝܼܹܗ، ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܡܲܠܦܵܢܵܐ، ܡܘܼܕܝܼ ܥܵܒ݂ܕܲܚ؟“ ");
INSERT INTO aii_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ܘܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܠܵܐ ܫܵܩܠܝܼܬܘܿܢ ܡܸܢܕܝܼ ܙܵܘܕܵܐ ܡ̣ܢ ܕܦܝܼܫܹܐ ܝܬܘܿܢ ܦܩܝܼܕܹܐ ܠܸܫܩܵܠܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ܘܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ ܕܲܚܫܹ̈ܐ ܒܹܐܡܵܪܵܐ: ”ܘܐܲܚܢܲܢ ܡܘܼܕܝܼ ܥܵܒ݂ܕܲܚ؟“ ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܠܐܢܵܫܵܐ ܠܵܐ ܡܲܠܝܸܨܝܼܬܘܿܢ، ܘܠܐܢܵܫܵܐ ܠܵܐ ܝܵܗܒ݂ܝܼܬܘܿܢ ܣܵܗܕܘܼܬܵ‌ܐ ܕܕܘܼܓܠܵܐ. ܘܗܵܩܵܘܟ݂ܘܿܢ ܗܵܘܹܐ ܡܵܠܝܵܢܵܐ ܐܸܠܵܘܟ݂ܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ܘܟܲܕ ܒܸܣܦܵܪܵܐ ܝܗܘܵܘ ܥܲܡܵܐ، ܟܠܵܝܗ‌ܝ ܒܸܚܫܵܒ݂ܵܐ ܝܗܘܵܘ ܕܩܵܘܡܵܐ ܗ̇ܘ ܝܼܠܹܗ ܡܫܝܼܚܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܘܿܚܲܢܵܢ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܐܵܢܵܐ ܡܲܥܡܘܼܕܹܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ ܒܡ̈ܝܼܵܐ، ܐܝܼܢܵܐ ܗ̇ܘ ܕܒܹܐܬܵܝܵܐ ܝܠܹܗ ܡ̣ܢ ܒܵܬܪ ܡܸܢܝܼ ܒܘܼܫ ܚܲܝܠܵܢܵܐ ܝܠܹܗ ܡܸܢܝܼ، ܗ̇ܘ ܕܐܵܢܵܐ ܠܹܐ ܚܵܫܚܹܢ ܕܫܵܪܹܝܢ ܬܲܣܡܵܬܹ̈‌ܐ ܕܨܵܘܠܘܼ̈ܗ‌ܝ. ܗ̇ܘ ܒܸܬ ܡܲܥܡܸܕ ܠܵܘܟ݂ܘܿܢ ܒܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ ܘܒܢܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ܪܘܼܦ̮ܫܬܵ‌ܐ ܒܐܝܼܕܹܗ ܝܠܵܗ̇، ܘܒܸܬ ܕܲܟܹܐ ܠܗܘܿܢ ܒܹܐܕܪ̈ܵܬܘܼܗ‌ܝ، ܘܚܸܛܹ̈ܐ ܒܸܬ ܟܲܦܸܫ ܠܗܘܿܢ ܒܐܲܢܒܵܪ̈ܘܼܗ‌ܝ، ܐܝܼܢܵܐ ܬܸܒ݂ܢܵܐ ܒܸܬ ܡܲܩܸܕ ܠܹܗ ܓܵܘ ܢܘܼܪܵܐ ܕܠܹܐ ܟ̰ܵܡܹܥ.“ ");
INSERT INTO aii_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ܘܐܘܼܦ ܪܵܒܵܐ ܡܸܢܕܝܼܵܢܹ̈ܐ ܐܚܹܪ̈ܢܹܐ ܡܲܠܸܦ ܗܘܵܐ ܘܡܲܟܪܸܙ ܗܘܵܐ ܠܥܲܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ܐܝܼܢܵܐ ܗܹܪܘܿܕܸܣ ܛܸܛܪܲܪܟܵܐ ܟܲܕ ܦܝܼܫܵܐ ܝܗܘܵܐ ܡܘܼܢܟܸܣܵܐ ܒܝܼܹܗ ܒܘܼܬ ܗܹܪܘܿܕܝܼܵܐ ܒܲܟ݂ܬܵ‌ܐ ܕܦܝܼܠܝܼܦܘܿܣ ܐܲܚܘܿܢܘܼܗ‌ܝ، ܘܒܘܼܬ ܒܝܼܫܵܬܹ̈‌ܐ ܐܚܹܪ̈ܢܹܐ ܕܥܵܒܹܕ ܗܘܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ܡܘܼܙܝܸܕ ܠܹܗ ܐܘܼܦ ܐܵܗܵܐ ܠܟܠܵܝܗ‌ܝ: ܕܪܹܐ ܠܹܗ ܠܝܘܿܚܲܢܵܢ ܓܵܘ ܒܹܝܬ ܐܲܣܝܼܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ܗܘܹܐ ܠܵܗ̇ ܟܲܕ ܥܡܝܼܕ ܠܹܗ ܟܠܹܗ ܥܲܡܵܐ، ܐܘܼܦ ܝܼܫܘܿܥ ܦܝܼܫ ܠܹܗ ܥܡܝܼܕܵܐ. ܘܟܲܕ ܨܲܠܘܼܝܹܐ ܝܗܘܵܐ، ܦܝܼܫ ܠܗܘܿܢ ܦܬܝܼܚܹܐ ܫܡܲܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ܘܨܠܹܐ ܠܹܗ ܥܲܠܘܼܗ‌ܝ ܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ ܒܕܡܘܼܬܵ‌ܐ ܕܓܘܼܫܡܵܐ ܕܝܵܘܢܵܐ، ܘܩܵܠܵܐ ܗܘܹܐ ܠܹܗ ܡ̣ܢ ܫܡܲܝܵܐ ܒܹܐܡܵܪܵܐ: ”ܐܲܢ݇ܬ ܝܼܘܸܬ ܒܪܘܿܢܝܼ ܡܘܼܚܸܒܵܐ ܕܒܝܼܹܗ ܒܣܝܼܡ ܠܵܗ̇ ܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ܘܝܼܫܘܿܥ ܐܲܝܟ݂ ܒܲܪ ܬܠܵܬ‌ܝܼ ܫܸܢܹ̈ܐ ܝܗܘܵܐ، ܐܝܼܡܲܢ ܕܫܘܼܪܹܐ ܠܹܗ ܚܸܠܡܲܬܹܗ، ܒܹܗܘܵܝܵܐ، ܐܲܝܟ݂ ܕܦܵܐܹܫ ܗܘܵܐ ܚܫܝܼܒ݂ܵܐ، ܒܪܘܿܢܵܐ ܕܝܵܘܣܸܦ، ܒܪܘܿܢܵܐ ܕܗܹܠܝܼ، ");
INSERT INTO aii_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ܒܪܘܿܢܵܐ ܕܡܲܛܬܲܬ، ܒܪܘܿܢܵܐ ܕܠܹܘܝܼ، ܒܪܘܿܢܵܐ ܕܡܲܠܟܝܼ، ܒܪܘܿܢܵܐ ܕܝܲܐܢܝܼ، ܒܪܘܿܢܵܐ ܕܝܵܘܣܸܦ، ");
INSERT INTO aii_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ܒܪܘܿܢܵܐ ܕܡܲܬܬܲܬܝܼܵܐ، ܒܪܘܿܢܵܐ ܕܥܲܡܘܿܨ، ܒܪܘܿܢܵܐ ܕܢܵܚܘܿܡ، ܒܪܘܿܢܵܐ ܕܚܲܣܠܝܼ، ܒܪܘܿܢܵܐ ܕܢܵܓܝܼ، ");
INSERT INTO aii_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ܒܪܘܿܢܵܐ ܕܡܵܐܲܬ، ܒܪܘܿܢܵܐ ܕܡܲܛܲܬ، ܒܪܘܿܢܵܐ ܕܫܲܡܥܝܼ، ܒܪܘܿܢܵܐ ܕܝܵܘܣܸܦ، ܒܪܘܿܢܵܐ ܕܝܼܗܘܼܕܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ܒܪܘܿܢܵܐ ܕܝܘܿܚܲܢܵܢ، ܒܪܘܿܢܵܐ ܕܪܵܣܵܐ، ܒܪܘܿܢܵܐ ܕܙܘܼܪܒܵܒܹܠܔ، ܒܪܘܿܢܵܐ ܕܫܹܠܲܬܐܹܝܠܔ، ܒܪܘܿܢܵܐ ܕܢܹܪܝܼ، ");
INSERT INTO aii_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ܒܪܘܿܢܵܐ ܕܡܲܠܟܝܼ، ܒܪܘܿܢܵܐ ܕܐܲܕܲܝ، ܒܪܘܿܢܵܐ ܕܩܘܿܣܵܡ، ܒܪܘܿܢܵܐ ܕܐܲܠܡܘܿܕܵܕ، ܒܪܘܿܢܵܐ ܕܥܝܼܪ، ");
INSERT INTO aii_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ܒܪܘܿܢܵܐ ܕܝܘܿܣܹܐ، ܒܪܘܿܢܵܐ ܕܐܹܠܝܼܥܵܙܲܪ، ܒܪܘܿܢܵܐ ܕܝܘܿܪܵܡ، ܒܪܘܿܢܵܐ ܕܡܲܬܬܲܬ، ܒܪܘܿܢܵܐ ܕܠܹܘܝܼ، ");
INSERT INTO aii_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ܒܪܘܿܢܵܐ ܕܫܸܡܥܘܿܢ، ܒܪܘܿܢܵܐ ܕܝܼܗܘܼܕܵܐ، ܒܪܘܿܢܵܐ ܕܝܵܘܣܸܦ، ܒܪܘܿܢܵܐ ܕܝܘܿܪܵܡ، ܒܪܘܿܢܵܐ ܕܐܸܠܝܵܩܝܼܡ، ");
INSERT INTO aii_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ܒܪܘܿܢܵܐ ܕܡܲܠܝܵܐ، ܒܪܘܿܢܵܐ ܕܡܲܐܢܝܼ، ܒܪܘܿܢܵܐ ܕܡܲܛܬܵ‌ܐ، ܒܪܘܿܢܵܐ ܕܢܵܬܵܢ، ܒܪܘܿܢܵܐ ܕܕܵܘܝܼܕ، ");
INSERT INTO aii_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ܒܪܘܿܢܵܐ ܕܐܝܼܫܲܝ، ܒܪܘܿܢܵܐ ܕܥܘܿܒ݂ܝܼܕ، ܒܪܘܿܢܵܐ ܕܒܵܥܲܙ، ܒܪܘܿܢܵܐ ܕܣܲܠܡܘܿܢ، ܒܪܘܿܢܵܐ ܕܢܸܚܫܘܿܢ، ");
INSERT INTO aii_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ܒܪܘܿܢܵܐ ܕܥܲܡܝܼܢܵܕܵܒ݂، ܒܪܘܿܢܵܐ ܕܐܵܪܵܡ، ܒܪܘܿܢܵܐ ܕܚܸܨܪܘܿܢ، ܒܪܘܿܢܵܐ ܕܦܲܪܨ، ܒܪܘܿܢܵܐ ܕܝܼܗܘܼܕܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ܒܪܘܿܢܵܐ ܕܝܲܥܩܘܿܒ݂، ܒܪܘܿܢܵܐ ܕܐܝܼܣܚܵܩ، ܒܪܘܿܢܵܐ ܕܐܲܒ݂ܪܵܗܵܡ، ܒܪܘܿܢܵܐ ܕܬܲܪܚ، ܒܪܘܿܢܵܐ ܕܢܵܚܘܿܪ، ");
INSERT INTO aii_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ܒܪܘܿܢܵܐ ܕܣܵܪܘܿܓ݂، ܒܪܘܿܢܵܐ ܕܐܲܪܥܘܿ، ܒܪܘܿܢܵܐ ܕܦܵܠܵܓ݂، ܒܪܘܿܢܵܐ ܕܥܵܒ݂ܵܪ، ܒܪܘܿܢܵܐ ܕܫܵܠܵܚ، ");
INSERT INTO aii_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ܒܪܘܿܢܵܐ ܕܩܲܝܢܵܢ، ܒܪܘܿܢܵܐ ܕܐܲܪܦܲܟ݂ܫܵܕ، ܒܪܘܿܢܵܐ ܕܫܹܝܡ، ܒܪܘܿܢܵܐ ܕܢܘܿܚ، ܒܪܘܿܢܵܐ ܕܠܲܡܟ، ");
INSERT INTO aii_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ܒܪܘܿܢܵܐ ܕܡܲܬܘܼܫܠܲܚ، ܒܪܘܿܢܵܐ ܕܚܢܘܿܟ݂، ܒܪܘܿܢܵܐ ܕܝܲܪܕ، ܒܪܘܿܢܵܐ ܕܡܲܗܠܵܠܵܐܹܝܠܔ، ܒܪܘܿܢܵܐ ܕܩܲܝܢܵܢ، ");
INSERT INTO aii_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ܒܪܘܿܢܵܐ ܕܐܵܢܘܿܫ، ܒܪܘܿܢܵܐ ܕܫܹܝܬ، ܒܪܘܿܢܵܐ ܕܐܵܕܵܡ، ܕܡ̣ܢ ܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ܕܝܼܪܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܝܘܿܪܕܢܵܢ ܡܸܠܝܵܐ ܡ̣ܢ ܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ، ܘܠܘܼܒܸܠܔ ܠܹܗ ܐܸܠܹܗ ܪܘܼܚܵܐ ܠܒܲܪܝܼܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ܐܲܪܒܥܝܼ ܝܵܘܡܵܢܹ̈ܐ ܦܝܼܫ ܠܹܗ ܓ̰ܘܼܪܒܵܐ ܡ̣ܢ ܐܵܟܹܠܩܲܪܨܵܐ. ܠܵܐ ܐܟ݂ܝܼܠܔ ܠܹܗ ܡܸܢܕܝܼ ܒܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ، ܘܐܝܼܡܲܢ ܕܬܘܼܡܸܡ ܠܗܘܿܢ، ܒܚܲܪܬܵ‌ܐ ܟܦܝܼܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ ܐܵܟܹܠܩܲܪܨܵܐ: ”ܐܸܢ ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ ܝܘܸܬ، ܦܩܘܿܕ ܠܐܵܗܵܐ ܟܹܐܦܵܐ ܕܗܵܘܹܐ ܠܲܚܡܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ، ”ܟܬܝܼܒ݂ܵܐ ܝܠܹܗ: ܠܹܐ ܝܠܵܗ̇ ܒܠܲܚܡܵܐ ܐܲܚܟ̰ܝܼ ܕܟܹܐ ܚܵܝܹܐ ܒܲܪܢܵܫܵܐ، ܐܸܠܵܐ ܒܟܠܔ ܗܹܡܸܙܡܵܢ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ܘܡܘܼܐܣܸܩ ܠܹܗ ܐܸܠܹܗ ܐܵܟܹܠܩܲܪܨܵܐ ܠܛܘܼܪܵܐ ܪܵܡܵܐ، ܘܡܘܼܚܙܹܐ ܠܹܗ ܐܸܠܹܗ ܟܠܵܝܗ‌ܝ ܡܲܠܟܘܵܬܹ̈‌ܐ ܕܐܲܪܥܵܐ ܒܥܕܵܢܵܐ ܟܪܝܼܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܐܸܠܘܼܟ݂ ܒܸܬ ܝܵܗܒܹܢ ܟܠܹܗ ܐܵܗܵܐ ܫܘܼܠܛܵܢܵܐ ܘܚܸܩܪܵܐ ܕܐܲܢܹܐ ܡܲܠܟܘܵܬܹ̈‌ܐ، ܣܵܒܵܒ ܐܸܠܝܼ ܦܝܼܫܵܐ ܝܠܹܗ ܣܘܼܦܝܵܐ، ܘܠܡ̇ܢ ܕܒܵܥܹܝܢ ܒܸܬ ܝܵܗܒܹܢܹܗ، ");
INSERT INTO aii_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","”ܐܸܢ ܟܵܝܦܹܬ ܘܣܵܓ݂ܕܹܬ ܐܸܠܝܼ، ܐܸܠܘܼܟ݂ ܒܸܬ ܝܵܗܒܹܢܹܗ ܟܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ: ”ܟܬܝܼܒ݂ܵܐ ܝܠܹܗ: ܠܡܵܪܝܵܐ ܐܲܠܵܗܘܼܟ݂ ܣܵܓ݂ܕܹܬ، ܘܐܸܠܹܗ ܒܢܲܦ̮ܫܹܗ ܥܵܒ݂ܕܹܬ ܚܸܠܡܲܬ.“ ");
INSERT INTO aii_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ܗ̇ܝܓܵܗ ܠܘܼܒܸܠܔ ܠܹܗ ܐܸܠܹܗ ܣܵܛܵܢܵܐ ܠܐܘܿܪܸܫܠܸܡ، ܘܡܘܼܟܠܹܐ ܠܹܗ ܐܸܠܹܗ ܥܲܠܔ ܟܸܢܦܵܐ ܕܗܲܝܟܠܵܐ، ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܐܸܢ ܐܲܢ݇ܬ ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ ܝܘܸܬ، ܪܲܦܝܼ ܠܵܗ̇ ܓܵܢܘܼܟ݂ ܠܬܸܚܬ، ");
INSERT INTO aii_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","”ܣܵܒܵܒ ܟܬܝܼܒ݂ܵܐ ܝܠܹܗ: ܒܸܬ ܦܵܩܹܕ ܠܡܲܠܲܐܟ݂ܘܼ̈ܗ‌ܝ ܕܢܵܛܪܝܼ ܠܘܼܟ݂، ");
INSERT INTO aii_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ܘܥܲܠܔ ܐܝܼܕܵܬܵܝ̈ܗ‌ܝ ܒܸܬ ܛܵܥܢܝܼ ܠܘܼܟ݂، ܕܠܵܐ ܬܲܪܩܸܠܵܐ ܒܟܹܐܦܵܐ ܐܲܩܠܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܓ̰ܘܼܘܸܒ ܠܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܟܬܝܼܒ݂ܵܐ ܝܠܹܗ: ܠܵܐ ܓ̰ܲܪܒܸܬ ܠܡܵܪܝܵܐ ܐܲܠܵܗܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ܘܟܲܕ ܦܪܝܼܩ ܠܹܗ ܐܵܟܹܠܩܲܪܨܵܐ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܓ̰ܘܼܪ̈ܵܒܘܼܗ‌ܝ، ܫܒ݂ܝܼܩ ܠܹܗ ܠܝܼܫܘܿܥ ܩܵܐ ܚܲܕ ܙܲܒ݂ܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ܝܼܫܘܿܥ ܕܝܼܪܹܗ ܠܓܠܝܼܠܵܐ ܒܚܲܝܠܵܐ ܕܪܘܼܚܵܐ، ܘܦܝܼܫ ܠܵܗ̇ ܫܡܝܼܥܬܵ‌ܐ ܒܘܼܬ ܕܝܼܹܗ ܒܟܠܹܗ ܐܲܬܪܵܐ ܘܒܟܠܵܝܗ‌ܝ ܓܹܒܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ܘܟܹܐ ܡܲܠܸܦ ܗܘܵܐ ܓܵܘ ܟܢܘܼܫܝܵܬܵܝ̈ܗ‌ܝ، ܘܟܹܐ ܦܵܐܹܫ ܗܘܵܐ ܚܩܝܼܪܵܐ ܡ̣ܢ ܟܠܔ ܐܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ܐܬܹ‌ܐ ܠܹܗ ܝܼܫܘܿܥ ܠܢܵܨܪܲܬ ܐܲܝܟܵܐ ܕܝܼܗܘܵܐ ܓܘܼܪܘܸܣܵܐ، ܘܥܒ݂ܝܼܪܹܗ ܠܟܢܘܼܫܬܵ‌ܐ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ ܕܵܐܟ݂ܝܼ ܕܐܝܼܬ ܗܘܵܐ ܠܹܗ ܥܵܕܲܬ، ܘܩܝܼܡ ܠܹܗ ܠܸܩܪܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ܦܝܼܫ ܠܹܗ ܝܘܼܗܒ݂ܵܐ ܐܸܠܹܗ ܟܬܵܒ݂ܵܐ ܕܐܹܫܲܥܝܵܐ ܢܒ݂ܝܼܵܐ. ܦܬܝܼܚ ܠܹܗ ܟܬܵܒ݂ܵܐ ܘܡܘܼܫ݇ܟ̰ܸܚ ܠܹܗ ܕܘܼܟܵܐ ܐܲܝܟܵܐ ܕܟܬܝܼܒ݂ܵܐ ܝܠܹܗ: ");
INSERT INTO aii_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ܪܘܼܚܵܐ ܕܡܵܪܝܵܐ ܥܲܠܝܼ ܝܠܹܗ، ܣܵܒܵܒ ܩܵܡ ܡܵܫܹܚ ܠܝܼ ܕܡܲܟܪܸܙܸܢ ܠܡܸܣܟܹܢܹ̈ܐ، ܘܩܵܡ ܫܲܕܸܪܝܼ ܕܒܲܣܡܸܢ ܠܬܒ݂ܝܼܪܹ̈ܐ ܕܠܸܒܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ܘܡܲܟܪܸܙܸܢ ܚܹܐܪܘܼܬܵ‌ܐ ܠܐܲܣܝܼܪܹ̈ܐ، ܘܚܙܵܝܬܵ‌ܐ ܠܣܸܡܝܹ̈ܐ، ܘܚܹܐܪܘܼܬܵ‌ܐ ܠܡܘܼܠܝܸܨܹ̈ܐ، ܘܡܲܟܪܸܙܸܢ ܫܹܢ݇ܬܵ‌ܐ ܩܘܼܒܸܠܬܵ‌ܐ ܕܡܵܪܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ܟܪܝܼܟ݂ ܠܹܗ ܠܟܬܵܒ݂ܵܐ ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܠܡܫܲܡܫܵܢܵܐ، ܘܝܬܝܼܒ݂ ܠܹܗ. ܘܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܝܼܗܘܵܘ ܓܵܘ ܟܢܘܼܫܬܵ‌ܐ ܚܵܝܪܝܼ ܗܘܵܘ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܐܸܕܝܘܿܡ ܦܝܼܫ ܠܹܗ ܬܘܼܡܸܡܵܐ ܐܵܗܵܐ ܟܬܵܒ݂ܵܐ ܐܲܝܟ݂ ܕܫܡܝܼܥ ܠܵܘܟ݂ܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ܘܟܠܵܝܗ‌ܝ ܟܹܐ ܗܲܡܙܸܡܝܼ ܗܘܵܘ ܨܦܵܝܝܼ ܒܘܼܬ ܕܝܼܹܗ، ܘܥܲܓ̰ܒܝܼ ܗܘܵܘ ܒܗܹܡܸܙܡܵܢܹ̈ܐ ܕܫܵܦܵܩܲܬ ܕܦܵܠܛܝܼ ܗܘܵܘ ܡ̣ܢ ܦܘܼܡܹܗ، ܘܒܲܩܪܝܼ ܗܘܵܘ: ”ܠܹܐ ܝܠܹܗ ܐܵܗܵܐ ܒܪܘܿܢܵܐ ܕܝܵܘܣܸܦ؟“ ");
INSERT INTO aii_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܫܲܪܝܼܪܵܐܝܼܬ ܒܸܬ ܐܵܡܪܝܼܬܘܿܢ ܐܸܠܝܼ ܐܵܗܵܐ ܡܲܬܠܵܐ: ’ܐܵܣܝܵܐ ܒܲܣܸܡ ܓܵܢܘܼܟ݂.‘ ܘܒܸܬ ܐܵܡܪܝܼܬܘܿܢ: ’ܟܠܔ ܡܸܢܕܝܼ ܕܫܡܝܼܥ ܠܲܢ ܕܥܒ݂ܝܼܕ ܠܘܼܟ݂ ܒܟܦܲܪܢܵܚܘܿܡ، ܥܒ݂ܘܿܕ ܐܘܼܦ ܠܲܐܟ݂ܵܐ ܓܵܘ ܡܵܬܘܼܟ݂.‘“ ");
INSERT INTO aii_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ܗ̇ܝܓܵܗ ܝܼܫܘܿܥ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܠܲܝܬ ܢܒ݂ܝܼܵܐ ܕܦܵܐܹܫ ܩܘܼܒܠܵܐ ܓܵܘ ܡܕܝܼܢ݇ܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","”ܒܫܲܪܝܼܪܘܼܬܵ‌ܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܪܵܒܵܐ ܐܲܪ̈ܡܸܠܝܵܬܹ‌ܐ ܐܝܼܬ ܗܘܵܘ ܓܵܘ ܐܝܼܣܪܵܐܹܝܠܔ ܒܝܵܘܡܵܢܹ̈ܐ ܕܐܹܠܝܼܵܐ ܢܒ݂ܝܼܵܐ ܐܝܼܡܲܢ ܕܫܡܲܝܵܐ ܠܵܐ ܝܘܼܗܒܹܠܔ ܠܵܗ̇ ܡܸܛܪܵܐ ܬܠܵܬ ܫܸܢܹ̈ܐ ܘܦܲܠܓܹܐ، ܘܗܘܹܐ ܠܹܗ ܟܸܦܢܵܐ ܓܘܼܪܵܐ ܒܟܠܵܗ̇ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","”ܐܝܼܢܵܐ ܠܟܸܣ ܐܘܼܦ ܚܕܵܐ ܡܸܢܵܝܗ‌ܝ ܠܵܐ ܦܝܼܫ ܠܹܗ ܫܘܼܕܪܵܐ ܐܹܠܝܼܵܐ، ܫܒ݂ܘܿܩ ܡ̣ܢ ܠܟܸܣ ܚܕܵܐ ܒܲܟ݂ܬܵ‌ܐ ܐܲܪܡܸܠܬܵ‌ܐ، ܠܨܲܪܦܲܬ ܕܨܲܝܕܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","”ܘܪܵܒܵܐ ܓܸܪ̈ܒ݂ܵܢܹܐ ܐܝܼܬ ܗܘܵܘ ܓܵܘ ܐܝܼܣܪܵܐܹܝܠܔ ܒܝܵܘܡܵܢܹ̈ܐ ܕܐܹܠܝܼܫܲܥ ܢܒ݂ܝܼܵܐ، ܐܝܼܢܵܐ ܐܘܼܦ ܚܲܕ ܡܸܢܵܝܗ‌ܝ ܠܵܐ ܦܝܼܫ ܠܹܗ ܕܘܼܟ݂ܝܵܐ، ܐܸܠܵܐ ܢܲܥܡܵܢ ܐܵܪܵܡܵܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ܘܟܲܕ ܐܵܢܝܼ ܕܝܼܗܘܵܘ ܓܵܘ ܟܢܘܼܫܬܵ‌ܐ ܫܡܝܼܥ ܠܗܘܿܢ ܐܲܢܹܐ، ܦܝܼܫ ܠܗܘܿܢ ܡܸܠܝܹܐ ܚܸܡܬܵ‌ܐ ܟܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ܩܝܼܡ ܠܗܘܿܢ ܘܦܘܼܠܸܛ ܠܗܘܿܢ ܐܸܠܹܗ ܠܒܲܕܲܪ ܡ̣ܢ ܡܕܝܼܢ݇ܬܵ‌ܐ، ܘܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܐܸܠܹܗ ܠܓܒ݂ܝܼܢܵܐ ܕܛܘܼܪܵܐ ܐܲܝܟܵܐ ܕܡܕܝܼܢ݇ܬܵܝܗ‌ܝ ܒܢܝܼܬܵ‌ܐ ܝܗܘܵܐ ܥܲܠܘܼܗ‌ܝ، ܕܪܲܦܝܼ ܗܘܵܘ ܠܹܗ ܠܬܸܚܬ. ");
INSERT INTO aii_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ܐܝܼܢܵܐ ܗ̇ܘ ܥܒ݂ܝܼܪܹܗ ܡ̣ܢ ܓܵܘܵܝܗ‌ܝ ܘܐܙܝܼܠܔ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ܘܨܠܹܐ ܠܹܗ ܝܼܫܘܿܥ ܠܟܦܲܪܢܵܚܘܿܡ، ܡܕܝܼܢ݇ܬܵ‌ܐ ܕܓܵܘ ܓܠܝܼܠܵܐ، ܘܡܲܠܸܦ ܗܘܵܐ ܠܗܘܿܢ ܒܝܵܘܡܵܢܹ̈ܐ ܕܫܲܒܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ܟܹܐ ܥܲܓ̰ܒܝܼ ܗܘܵܘ ܒܝܘܼܠܦܵܢܹܗ، ܣܵܒܵܒ ܐܝܼܬ ܗܘܵܐ ܫܘܼܠܛܵܢܵܐ ܒܗܹܡܸܙܡܵܢܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ܐܝܼܬ ܗܘܵܐ ܓܵܘ ܟܢܘܼܫܬܵ‌ܐ ܚܲܕ ܐܢܵܫܵܐ ܕܐܝܼܬ ܗܘܵܐ ܒܝܼܹܗ ܪܘܼܚܵܐ ܕܫܹܐܕܵܐ ܛܲܡܐܹܐ، ܘܡܘܼܩܘܸܚ ܠܹܗ ܒܩܵܠܵܐ ܪܵܡܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ܘܐܡܝܼܪܹܗ: ”ܫܒ݂ܘܿܩ ܠܲܢ، ܝܵܐ ܝܼܫܘܿܥ ܢܵܨܪܵܝܵܐ. ܡܵܐ ܠܘܼܟ݂ ܡܸܢܲܢ، ܐܬܹ‌ܐ ܠܘܼܟ݂ ܠܛܲܠܘܼܩܲܢ؟ ܒܝܼܕܵܥܵܐ ܝܘܸܢ ܡܵܢܝܼ ܝܘܸܬ، ܐܲܢ݇ܬ ܝܼܘܸܬ ܩܲܕܝܼܫܵܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܢܓ̰ܝܼܘ ܠܹܗ ܒܝܼܹܗ ܘܐܡܝܼܪܹܗ: ”ܫܬܘܿܩ ܘܦܠܘܿܛ ܡܸܢܹܗ.“ ܘܪܘܼܦܹܐ ܠܹܗ ܐܸܠܹܗ ܫܹܐܕܵܐ ܒܹܝܦܲܠܓܵܐ، ܘܦܠܝܼܛ ܠܹܗ ܡܸܢܹܗ، ܘܠܵܐ ܚܘܼܙܕܸܓ ܠܹܗ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ܥܘܼܓ̰ܵܒܵܐ ܓܘܼܪܵܐ ܕܒ݂ܝܼܩ ܠܹܗ ܠܟܠܵܝܗ‌ܝ، ܘܗܲܡܙܸܡܝܼ ܗܘܵܘ ܚܲܕ ܥܲܡ ܗ̇ܘ ܐܚܹܪܢܵܐ ܘܐܵܡܪܝܼ ܗܘܵܘ: ”ܟܡܵܐ ܚܲܝܠܵܢܹ̈ܐ ܝܢܵܐ ܗܹܡܸܙܡܵܢܘܼ̈ܗ‌ܝ؟ ܒܫܘܼܠܛܵܢܵܐ ܘܒܚܲܝܠܵܐ ܒܸܦܩܵܕܵܐ ܝܠܹܗ ܠܪ̈ܘܼܚܹܐ ܛܲܡܐܹ̈ܐ ܘܒܸܦܠܵܛܵܐ ܝܢܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ܘܦܪܝܼܣ ܠܹܗ ܚܲܒܪܵܐ ܒܘܼܬ ܕܝܼܹܗ ܒܟܠܹܗ ܐܲܬܪܵܐ ܕܚܵܕܸܪ̈ܘܵܢܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ܦܠܝܼܛ ܠܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܟܢܘܼܫܬܵ‌ܐ، ܘܥܒ݂ܝܼܪܹܗ ܠܒܲܝܬܵ‌ܐ ܕܫܸܡܥܘܿܢ ܟܹܐܦܵܐ. ܘܚܡܵܬܵ‌ܐ ܕܫܸܡܥܘܿܢ ܡܪܝܼܥܬܵ‌ܐ ܝܗܘܵܐ ܒܚܲܡܚܲܡܬܵ‌ܐ ܚܲܝܠܵܢܬܵ‌ܐ، ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ ܒܘܼܬ ܕܝܼܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ܘܟܠܹܐ ܠܹܗ ܝܼܫܘܿܥ ܥܸܠܸܠܔ ܡܸܢܘܼܗ̇، ܘܢܓ̰ܝܼܘ ܠܹܗ ܒܚܲܡܚܲܡܬܵ‌ܐ ܘܩܵܡ ܫܵܒ݂ܩܵܐ ܠܵܗ̇. ܘܒܗ̇ܝ ܥܕܵܢܵܐ ܩܝܼܡ ܠܵܗ̇ ܕܥܵܒ݂ܕܵܐ ܗܘܵܐ ܠܗܘܿܢ ܚܸܠܡܲܬ. ");
INSERT INTO aii_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ܘܒܓܢܵܝܬܵ‌ܐ ܕܫܸܡܫܵܐ، ܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܐܝܼܬ ܗܘܵܘ ܠܗܘܿܢ ܡܲܪ̈ܥܵܢܹܐ ܒܡܲܪ̈ܥܹܐ ܦܪ̈ܝܼܫܹܐ، ܡܘܼܬܝܵܝ ܠܗܘܿܢ ܠܟܸܣܠܹܗ. ܘܗ̇ܘ ܡܘܼܬܸܒ݂ ܠܹܗ ܐܝܼܕܹܗ ܥܲܠܔ ܟܠܔ ܚܲܕ ܡܸܢܵܝܗ‌ܝ ܘܒܘܼܣܡܵܝ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ܐܘܼܦ ܫܹܐܕܹ̈ܐ ܟܹܐ ܦܵܠܛܝܼ ܗܘܵܘ ܡ̣ܢ ܪܵܒܵܐ، ܡܲܩܘܸܚܝܼ ܗܘܵܘ ܒܹܐܡܵܪܵܐ: ”ܐܲܢ݇ܬ ܝܼܘܸܬ ܡܫܝܼܚܵܐ، ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ.“ ܐܝܼܢܵܐ ܗ̇ܘ ܟܹܐ ܡܲܢܟܸܣ ܗܘܵܐ ܠܗܘܿܢ ܘܠܹܐ ܫܵܒܹܩ ܗܘܵܐ ܕܗܲܡܙܸܡܝܼ ܗܘܵܘ، ܣܵܒܵܒ ܟܹܐ ܝܵܕܥܝܼ ܗܘܵܘ ܕܗ̇ܘ ܝܼܠܹܗ ܡܫܝܼܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ܒܨܲܦܪܵܐ ܦܠܝܼܛ ܠܹܗ ܘܐܙܝܼܠܔ ܠܹܗ ܠܒܲܪܝܼܵܐ، ܘܟܸܢܫܹ̈ܐ ܛܵܥܝܼ ܗܘܵܘ ܒܵܬܪܹܗ. ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ، ܘܕܒ݂ܝܼܩ ܠܗܘܿܢ ܐܸܠܹܗ ܕܠܵܐ ܐܵܙܹܠܔ ܗܘܵܐ ܡ̣ܢ ܟܸܣܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܘܵܠܹܐ ܝܠܵܗ̇ ܕܡܲܟܪܸܙܸܢ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ ܓܵܘ ܡܕܝܼܢܵܬܹ̈‌ܐ ܐܚܹܪ̈ܢܹܐ، ܣܵܒܵܒ ܒܘܼܬ ܐܵܗܵܐ ܦܝܼܫ ܠܝܼ ܫܘܼܕܪܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ܘܟܹܐ ܡܲܟܪܸܙ ܗܘܵܐ ܓܵܘ ܟܢܘܼܫܝܵܬܹ̈‌ܐ ܕܓܠܝܼܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ܟܠܹܐ ܠܹܗ ܝܼܫܘܿܥ ܥܲܠܔ ܡܲܪܙܵܐ ܕܝܵܡܵܐ ܕܓܹܢܹܣܲܪ، ܘܓ̰ܡܝܼܥ ܠܹܗ ܠܟܸܣܠܹܗ ܟܸܢܫܵܐ ܠܸܫܡܵܥܵܐ ܗܹܡܸܙܡܵܢ ܕܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ܘܚܙܹܐ ܠܹܗ ܬܲܪܬܹܝ ܓܵܡܝܼܹ̈ܐ ܟܸܠܝܹܐ ܥܲܠܔ ܡܲܪܙܵܐ ܕܝܵܡܵܐ، ܐܝܼܢܵܐ ܨܲܝܵܕܹ̈ܐ ܦܠܝܼܛܹܐ ܝܗܘܵܘ ܡ̣ܢ ܓܵܘܵܝܗ‌ܝ، ܘܚܲܠܘܼܠܹܐ ܝܗܘܵܘ ܓܲܪ̈ܕܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ܚܕܵܐ ܡ̣ܢ ܓܵܡܝܼܹ̈ܐ ܕܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܝܗܘܵܐ. ܐܣܝܼܩ ܠܹܗ ܝܼܫܘܿܥ ܘܝܬܝܼܒ݂ ܠܹܗ ܓܵܘܘܼܗ̇. ܘܛܠܝܼܒ ܠܹܗ ܡ̣ܢ ܫܸܡܥܘܿܢ ܕܪܲܚܩܸܢ ܗܘܵܐ ܡ̣ܢ ܒܸܪܙܵܐ ܠܓܵܘ ܝܵܡܵܐ. ܘܫܘܼܪܹܐ ܠܹܗ ܠܡܲܠܘܼܦܹܐ ܠܟܸܢܫܵܐ ܡ̣ܢ ܓܵܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ܐܝܼܡܲܢ ܕܦܪܝܼܩ ܠܹܗ ܡ̣ܢ ܡܲܠܘܼܦܹܐ، ܐܡܝܼܪܹܗ ܠܫܸܡܥܘܿܢ ܟܹܐܦܵܐ: ”ܛܪܹܝܡܘܼܢ ܓܵܡܝܼ ܠܕܘܼܟܵܐ ܥܲܡܘܼܩܬܵ‌ܐ، ܘܕܪܹܝܡܘܼܢ ܓܲܪܕܵܘܟ݂ܘܿܢ ܠܨܲܝܕܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ܓ̰ܘܼܘܸܒ ܠܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ: ”ܪܲܒܝܼ، ܟܠܹܗ ܠܲܝܠܹܐ ܟܟ̰ܝܼܚ ܠܲܢ ܘܡܸܢܕܝܼ ܠܵܐ ܕܒ݂ܝܼܩ ܠܲܢ، ܐܝܼܢܵܐ ܒܘܼܬ ܗܹܡܸܙܡܵܢܘܼܟ݂ ܒܸܬ ܕܵܪܹܝܢ ܠܓܲܪܕܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ܕܪܹܐ ܠܹܗ ܓܲܪܕܵܐ، ܘܕܒ݂ܝܼܩ ܠܗܘܿܢ ܢܘܼܢܹ̈ܐ ܪܵܒܵܐ، ܗܵܕܵܐ ܕܦܪܝܼܛ ܠܹܗ ܓܲܪܕܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ܘܩܪܹܐ ܠܗܘܿܢ ܠܚܲܒ݂ܪ̈ܵܘܵܬܵܝܗ‌ܝ ܒܓܵܡܝܼ ܐܚܹܪܬܵ‌ܐ ܕܐܵܬ‌ܝܼ ܗܘܵܘ ܘܗܲܝܸܪܝܼ ܗܘܵܘ ܠܗܘܿܢ. ܐܬܹ‌ܐ ܠܗܘܿܢ ܘܡܠܹܐ ܠܗܘܿܢ ܬܲܪܬܹܝ ܓܵܡܝܼܹ̈ܐ ܗܲܠܔ ܕܫܘܼܪܹܐ ܠܗܘܿܢ ܠܸܛܒܵܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܐܵܗܵܐ، ܢܦܝܼܠܔ ܠܹܗ ܩܲܕܡ ܐܲܩܠܵܬܹ̈‌ܐ ܕܝܼܫܘܿܥ، ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܦܲܪܦܘܼܠܹܐ ܝܘܸܢ ܒܝܼܘܼܟ݂ ܡܵܪܝܼ ܕܪܵܚܩܹܬ ܡܸܢܝܼ، ܐܢܵܫܵܐ ܚܲܛܵܝܵܐ ܝܘܸܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ܐܡܝܼܪܹܗ ܐܵܗܵܐ ܣܵܒܵܒ ܥܘܼܓ̰ܸܒ ܠܹܗ ܗ̇ܘ ܘܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܥܲܡܹܗ ܥܲܠܔ ܨܲܝܕܵܐ ܕܢܘܼܢܹ̈ܐ ܕܕܒ݂ܝܼܩ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ܗܵܕܟ݂ܵܐ ܐܘܼܦ ܝܲܥܩܘܿܒ݂ ܘܝܘܿܚܲܢܵܢ ܒܢܘܿܢܹ̈ܐ ܕܙܲܒ݂ܕܲܝ ܕܝܼܗܘܵܘ ܦܲܠܵܚܹ̈ܐ ܥܲܡ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܥܘܼܓ̰ܸܒ ܠܗܘܿܢ. ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܠܫܸܡܥܘܿܢ ܟܹܐܦܵܐ: ”ܠܵܐ ܙܵܕܥܹܬ، ܡ̣ܢ ܐܵܕܝܼܵܐ ܒܸܬ ܗܵܘܹܝܬ ܒܸܨܝܵܕܵܐ ܐܢܵܫܹ̈ܐ ܠܚܲܝܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ܐܝܼܡܲܢ ܕܡܘܼܬܝܵܝ ܠܗܘܿܢ ܓܵܡܝܼܹ̈ܐ ܠܡܲܪܙܵܐ، ܫܒ݂ܝܼܩ ܠܗܘܿܢ ܟܠܔ ܡܸܢܕܝܼ ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܒܵܬܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ܐܝܼܡܲܢ ܕܝܼܗܘܵܐ ܝܼܫܘܿܥ ܓܵܘ ܚܕܵܐ ܡ̣ܢ ܡܕܝܼܢܵܬܹ̈‌ܐ، ܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣܠܹܗ ܚܲܕ ܐܢܵܫܵܐ ܓܸܪܒ݂ܵܢܵܐ. ܘܟܲܕ ܚܙܹܐ ܠܹܗ ܠܝܼܫܘܿܥ، ܢܦܝܼܠܔ ܠܹܗ ܥܲܠܔ ܦܵܬܹܗ، ܘܦܘܼܪܦܸܠܔ ܠܹܗ ܒܝܼܹܗ ܒܹܐܡܵܪܵܐ: ”ܡܵܪܝܼ، ܐܸܢ ܒܵܥܹܝܬ، ܡܵܨܹܝܬ ܕܲܟܹܝܬ ܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ܦܘܼܫܛܵܐ ܠܹܗ ܐܝܼܕܹܗ ܝܼܫܘܿܥ ܘܕܩܝܼܪܹܗ ܒܝܼܹܗ ܘܐܡܝܼܪܹܗ: ”ܒܸܒܥܵܝܵܐ ܝܘܸܢ، ܦܘܼܫ ܕܸܟ݂ܝܵܐ.“ ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܐܙܝܼܠܔ ܠܹܗ ܓܸܪܒܹܗ ܡܸܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ܘܦܩܝܼܕ ܠܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܠܐܢܵܫܵܐ ܠܵܐ ܐܵܡܪܹܬ، ܐܸܠܵܐ ܙܹܠܔ݇ ܡܲܚܙܝܼ ܓܵܢܘܼܟ݂ ܠܟܵܗܢܵܐ، ܘܡܲܩܪܸܒ݂ ܒܘܼܬ ܕܲܟܲܝܬܘܼܟ݂ ܐܲܝܟ݂ ܕܦܩܝܼܕ ܠܹܗ ܡܘܼܫܹܐ، ܠܣܵܗܕܘܼܬܵܝܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ܐܝܼܢܵܐ ܒܘܼܫ ܦܪܝܼܣ ܠܵܗ̇ ܗܹܡܸܙܡܵܢ ܒܘܼܬ ܕܝܼܹܗ. ܘܓ̰ܵܡܥܝܼ ܗܘܵܘ ܟܸܢܫܹ̈ܐ ܪܵܒܵܐ ܠܸܫܡܵܥܵܐ ܡܸܢܹܗ ܘܠܸܦܝܵܫܵܐ ܒܘܼܣܡܹܐ ܡ̣ܢ ܡܲܪ̈ܥܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ܐܝܼܢܵܐ ܗ̇ܘ ܦܠܝܼܛ ܠܹܗ ܠܒܲܪܝܼܵܐ ܠܨܲܠܘܼܝܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ܟܲܕ ܡܲܠܘܼܦܹܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܒܚܲܕ ܡ̣ܢ ܝܵܘܡܵܢܹ̈ܐ، ܦܪ̈ܝܼܫܹܐ ܘܡܲܠܦܵܢܹ̈ܐ ܕܢܵܡܘܿܣܵܐ ܝܬܝܼܒܹܐ ܝܗܘܵܘ ܬܵܡܵܐ، ܐܵܢܝܼ ܕܐܬܝܼܹܐ ܝܗܘܵܘ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܡܕܝܼܢܵܬܹ̈‌ܐ ܕܓܠܝܼܠܵܐ، ܘܕܝܼܗܘܼܕ، ܘܡ̣ܢ ܐܘܿܪܸܫܠܸܡ، ܘܚܲܝܠܵܐ ܕܡܵܪܝܵܐ ܒܲܣܘܼܡܵܝ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ܘܗܵܐ ܚܲܕܟܡܵܐ ܐܢܵܫܹ̈ܐ ܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܚܲܕ ܫܦܝܼܠܵܐ ܥܲܠܔ ܫܘܝܼܬܵ‌ܐ، ܘܒܥܹܐ ܠܗܘܿܢ ܕܥܵܒ݂ܪܝܼ ܗܘܵܘ ܘܡܲܬܒ݂ܝܼ ܗܘܵܘ ܠܹܗ ܩܲܕܡ ܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ܐܝܼܢܵܐ ܐܝܼܡܲܢ ܕܠܵܐ ܡܘܼܫ݇ܟ̰ܸܚ ܠܗܘܿܢ ܐܘܼܪܚܵܐ ܕܥܵܒ݂ܪܝܼ ܗܘܵܘ ܒܘܼܬ ܟܸܢܫܵܐ ܪܵܒܵܐ، ܐܣܝܼܩ ܠܗܘܿܢ ܠܐܓܵܪܹܐ، ܓܘܼܠܹܐ ܠܗܘܿܢ ܠܫܟܘܼܪܹܐ ܘܦܘܼܫܸܛ ܠܗܘܿܢ ܐܸܠܹܗ ܥܲܡ ܫܘܝܼܬܹܗ ܒܒܹܝܦܲܠܓܵܐ ܩܲܕܡ ܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ܟܲܕ ܚܙܹܐ ܠܹܗ ܝܼܫܘܿܥ ܗܲܝܡܵܢܘܼܬܵܝܗ‌ܝ، ܐܡܝܼܪܹܗ ܠܗ̇ܘ ܫܦܝܼܠܵܐ: ”ܝܵܐ ܐܢܵܫܵܐ، ܦܘܼܚܠܹܐ ܝܢܵܐ ܐܸܠܘܼܟ݂ ܚܛܝܼܵܬܘܼ̈ܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ܐܝܼܢܵܐ ܣܵܦܪܹ̈ܐ ܘܦܪ̈ܝܼܫܹܐ ܫܘܼܪܹܐ ܠܗܘܿܢ ܒܸܚܫܵܒ݂ܵܐ ܒܓܵܢܵܝܗ‌ܝ ܘܒܹܐܡܵܪܵܐ: ”ܡܵܢܝܼ ܝܠܹܗ ܐܵܗܵܐ ܕܒܸܓܕܵܦܵܐ ܝܠܹܗ؟ ܡܵܢܝܼ ܡܵܨܹܐ ܦܲܚܸܠܔ ܚܛܝܼܵܬܹ̈‌ܐ ܫܒ݂ܘܿܩ ܡ̣ܢ ܐܲܠܵܗܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܝܕܝܼܥ ܠܹܗ ܚܘܼܫܵܒ݂ܵܝ̈ܗ‌ܝ، ܘܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ: ”ܡܘܼܕܝܼ ܒܸܚܫܵܒ݂ܵܐ ܝܬܘܿܢ ܒܠܸܒܵܘܟ݂ܘܿܢ؟ ");
INSERT INTO aii_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","”ܐܲܝܢܝܼ ܝܠܹܗ ܒܘܼܫ ܦܫܘܼܩܵܐ ܠܹܐܡܵܪܵܐ: ’ܦܘܼܚܠܹܐ ܝܢܵܐ ܐܸܠܘܼܟ݂ ܚܛܝܼܵܬܘܼ̈ܟ݂،‘ ܝܲܢ ܠܹܐܡܵܪܵܐ: ’ܩܘܼܡ ܚܕܘܿܪ؟‘ ");
INSERT INTO aii_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","”ܐܝܼܢܵܐ ܐܵܢܵܐ ܒܸܬ ܡܲܚܙܸܢܵܘܟ݂ܘܿܢ ܕܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܐܝܼܬ ܠܹܗ ܫܘܼܠܛܵܢܵܐ ܥܲܠܔ ܐܲܪܥܵܐ ܕܦܲܚܸܠܔ ܚܛܝܼܵܬܹ̈‌ܐ“ - ܐܡܝܼܪܹܗ ܠܫܦܝܼܠܵܐ: ”ܐܸܠܘܼܟ݂ ܒܹܐܡܵܪܵܐ ܝܘܸܢ، ܩܘܼܡ، ܫܩܘܿܠܔ ܫܘܝܼܬܘܼܟ݂ ܘܙܹܠܔ݇ ܠܒܲܝܬܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ܘܩܝܼܡ ܠܹܗ ܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܩܲܕܡ ܥܲܝܢܵܝ̈ܗ‌ܝ، ܘܫܩܝܼܠܔ ܠܹܗ ܫܘܝܼܬܹܗ ܘܐܙܝܼܠܔ ܠܹܗ ܠܒܲܝܬܹܗ ܟܲܕ ܫܲܒܘܼܚܹܐ ܠܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ܟܠܵܝܗ‌ܝ ܥܘܼܓ̰ܸܒ ܠܗܘܿܢ، ܫܘܼܒܸܚ ܠܗܘܿܢ ܠܐܲܠܵܗܵܐ، ܘܦܝܼܫ ܠܗܘܿܢ ܡܸܠܝܹܐ ܙܕܘܼܥܬܵ‌ܐ ܘܐܡܝܼܪܗܘܿܢ: ”ܐܸܕܝܘܿܡ ܚܙܹܐ ܠܲܢ ܕܘܼܡܵܪܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ܡ̣ܢ ܒܵܬܪ ܐܲܢܹܐ، ܦܠܝܼܛ ܠܹܗ ܝܼܫܘܿܥ ܘܚܙܹܐ ܠܹܗ ܚܲܕ ܡܵܟ݂ܣܵܐ ܫܸܡܹܗ ܠܹܘܝܼ، ܝܬܝܼܒ݂ܵܐ ܓܵܘ ܒܹܝܬ ܡܵܟ݂ܣܹ̈ܐ، ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܬܵ‌ܐ ܒܵܬܪܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ܗ̇ܘ ܫܒ݂ܝܼܩ ܠܹܗ ܟܠܔ ܡܸܢܕܝܼ، ܩܝܼܡ ܠܹܗ ܘܐܙܝܼܠܔ ܠܹܗ ܒܵܬܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ܥܒ݂ܝܼܕ ܠܹܗ ܐܸܠܹܗ ܠܹܘܝܼ ܓܵܘ ܒܲܝܬܹܗ ܐܲܪܚܘܼܬܵ‌ܐ ܓܘܼܪܬܵ‌ܐ. ܘܐܝܼܬ ܗܘܵܐ ܟܸܢܫܵܐ ܪܵܒܵܐ ܕܡܵܟ݂ܣܹ̈ܐ ܘܕܐܚܹܪ̈ܢܹܐ ܝܬܝܼܒܹܐ ܠܣܘܼܦܪܵܐ ܥܲܡܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ܐܝܼܢܵܐ ܣܵܦܪܹ̈ܐ ܘܦܪ̈ܝܼܫܹܐ ܛܘܼܪܛܸܡ ܠܗܘܿܢ، ܘܐܡܝܼܪܗܘܿܢ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܩܵܡܘܿܕܝܼ ܥܲܡ ܡܵܟ݂ܣܹ̈ܐ ܘܚܲܛܵܝܹ̈ܐ ܒܹܐܟ݂ܵܠܵܐ ܝܬܘܿܢ ܘܒܸܫܬܵܝܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ، ”ܐܵܢܝܼ ܕܝܼܢܵܐ ܒܚܘܼܠܡܵܢܵܐ ܠܹܐ ܝܢܵܐ ܣܢܝܼܩܹܐ ܠܐܵܣܝܵܐ، ܐܸܠܵܐ ܐܵܢܝܼ ܕܚܸܪܒܵܐ ܡܪܝܼܥܹܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","”ܠܵܐ ܐܬܹ‌ܐ ܠܝܼ ܕܩܵܪܹܝܢ ܠܙܲܕܝܼܩܹ̈ܐ، ܐܸܠܵܐ ܠܚܲܛܵܝܹ̈ܐ ܠܬܝܵܒ݂ܘܼܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ܐܝܼܢܵܐ ܐܵܢܝܼ ܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܬܲܠܡܝܼ̈ܕܹܐ ܕܝܘܿܚܲܢܵܢ ܟܹܐ ܨܵܝܡܝܼ ܪܵܒܵܐ ܘܟܹܐ ܨܲܠܝܼ، ܘܗܵܕܵܐ ܐܘܼܦ ܕܦܪ̈ܝܼܫܹܐ، ܐܝܼܢܵܐ ܕܝܼܘܼܟ݂ ܟܹܐ ܐܵܟ݂ܠܝܼ ܘܫܵܬ‌ܝܼ؟“ ");
INSERT INTO aii_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܠܹܐ ܡܵܨܹܝܬܘܿܢ ܡܲܥܒܸܕܝܼܬܘܿܢ ܚܲܒ݂ܪ̈ܵܘܵܬܹ‌ܐ ܕܚܸܬܢܵܐ ܨܵܝܡܝܼ ܟܡܵܐ ܕܚܸܬܢܵܐ ܥܲܡܵܝܗ‌ܝ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","”ܐܝܼܢܵܐ ܒܸܬ ܐܵܬ‌ܝܼ ܝܵܘܡܵܢܹ̈ܐ ܕܒܸܬ ܦܵܐܹܫ ܫܩܝܼܠܵܐ ܚܸܬܢܵܐ ܡܸܢܵܝܗ‌ܝ، ܗ̇ܝܓܵܗ ܒܸܬ ܨܵܝܡܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܡܲܬܠܵܐ: ”ܐܢܵܫܵܐ ܠܹܐ ܦܵܪܹܛ ܥܵܪܵܝܬܵ‌ܐ ܡ̣ܢ ܠܒ݂ܝܼܫܬܵ‌ܐ ܚܲܕܬܵ‌ܐ ܘܕܵܪܹܐ ܠܵܗ̇ ܥܲܠܔ ܓ̰ܘܼܠܵܐ ܥܲܬܝܼܩܵܐ. ܣܵܒܵܒ ܬܸܪܘܵܝ ܠܹܐ ܕܵܒ݂ܩܝܼ ܥܲܡ ܥܘܼܕܵܠܹܐ، ܘܥܲܬܝܼܩܵܐ ܒܸܬ ܟ̰ܲܢܟ̰ܸܪ ܠܚܵܕܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","”ܘܠܹܐ ܕܵܪܹܐ ܐܢܵܫܵܐ ܚܲܡܪܵܐ ܚܵܕܬܵ‌ܐ ܓܵܘ ܓܘܼܕܹ̈ܐ ܥܲܬܝܼܩܹ̈ܐ، ܣܵܒܵܒ ܚܲܡܪܵܐ ܚܵܕܬܵ‌ܐ ܒܸܬ ܒܵܙܹܥ ܠܓܘܼܕܹ̈ܐ، ܘܚܲܡܪܵܐ ܒܸܬ ܬܵܦܹܟ݂، ܘܓܘܼܕܹ̈ܐ ܒܸܬ ܚܵܪܒ݂ܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ܐܝܼܢܵܐ ܟܹܐ ܕܵܪܝܼ ܚܲܡܪܵܐ ܚܵܕܬܵ‌ܐ ܒܓܘܼܕܹ̈ܐ ܚܵܕܬܹ̈‌ܐ، ܘܬܸܪܘܵܝ ܟܹܐ ܦܵܝܫܝܼ ܢܛܝܼܪܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ܘܐܢܵܫܵܐ ܠܹܐ ܒܵܥܹܐ ܕܫܵܬܹ‌ܐ ܚܲܡܪܵܐ ܚܵܕܬܵ‌ܐ ܡ̣ܢ ܒܵܬܪ ܕܗܵܘܹܐ ܫܸܬܝܵܐ ܚܲܡܪܵܐ ܥܲܬܝܼܩܵܐ، ܣܵܒܵܒ ܟܹܐ ܐܵܡܹܪ ܕܥܲܬܝܼܩܵܐ ܒܘܼܫ ܒܲܣܝܼܡܵܐ ܝܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ܟܲܕ ܒܸܥܒ݂ܵܪܵܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ ܡ̣ܢ ܓܵܘ ܚܲܩܠܵܢܹ̈ܐ، ܫܘܼܪܹܐ ܠܗܘܿܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܒܸܫܠܵܓܵܐ ܫܸܒܠܹ̈ܐ، ܘܒܸܦܪܵܟ݂ܵܐ ܒܐܝܼܕܵܬܵܝ̈ܗ‌ܝ ܘܒܹܐܟ݂ܵܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ܘܐܢܵܫܹ̈ܐ ܡ̣ܢ ܦܪ̈ܝܼܫܹܐ ܐܡܝܼܪܗܘܿܢ ܐܸܠܵܝܗ‌ܝ: ”ܩܵܡܘܿܕܝܼ ܒܸܥܒ݂ܵܕܵܐ ܝܬܘܿܢ ܡܸܢܕܝܼ ܕܠܹܐ ܝܠܹܗ ܩܵܢܘܿܢܵܝܵܐ ܠܸܥܒ݂ܵܕܵܐ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܐܸܠܵܝܗ‌ܝ: ”ܠܵܐ ܩܪܹܐ ܠܵܘܟ݂ܘܿܢ ܡܘܼܕܝܼ ܥܒ݂ܝܼܕ ܠܹܗ ܕܵܘܝܼܕ ܐܝܼܡܲܢ ܕܗ̇ܘ ܘܐܵܢܝܼ ܕܝܼܗܘܵܘ ܥܲܡܹܗ ܟܦܝܼܢܗܘܿܢ؟ ");
INSERT INTO aii_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","”ܥܒ݂ܝܼܪܹܗ ܠܒܲܝܬܵ‌ܐ ܕܐܲܠܵܗܵܐ، ܘܠܲܚܡܵܐ ܕܦܵܬܘܿܪܵܐ ܕܡܵܪܝܵܐ ܫܩܝܼܠܔ ܠܹܗ ܘܐܟ݂ܝܼܠܔ ܠܹܗ، ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܠܐܵܢܝܼ ܕܝܼܗܘܵܘ ܥܲܡܹܗ، ܐܘܼܦ ܐܸܢ ܕܠܹܐ ܝܗܘܵܐ ܩܵܢܘܿܢܵܝܬܵ‌ܐ ܐܸܠܹܗ ܠܹܐܟ݂ܵܠܵܐ ܫܒ݂ܘܿܩ ܡ̣ܢ ܠܟܵܗ̈ܢܹܐ ܒܢܲܦ̮ܫܵܝܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܡܵܪܵܐ ܕܫܲܒܬܵ‌ܐ ܝܠܹܗ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ܒܫܲܒܬܵ‌ܐ ܐܚܹܪܬܵ‌ܐ ܥܒ݂ܝܼܪܹܗ ܝܼܫܘܿܥ ܠܟܢܘܼܫܬܵ‌ܐ ܘܡܲܠܸܦ ܗܘܵܐ. ܘܐܝܼܬ ܗܘܵܐ ܬܵܡܵܐ ܚܲܕ ܐܢܵܫܵܐ ܕܐܝܼܕܹܗ ܕܝܲܡܝܼܢܵܐ ܒܪܝܼܙܬܵ‌ܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ܣܵܦܪܹ̈ܐ ܘܦܪ̈ܝܼܫܹܐ ܢܵܛܪܝܼ ܗܘܵܘ ܠܹܗ ܕܐܸܢ ܒܲܣܸܡ ܗܘܵܐ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ، ܩܵܐ ܕܡܲܫ݇ܟ̰ܚܝܼ ܗܘܵܘ ܥܸܠܬܵ‌ܐ ܠܸܩܒ݂ܵܠܵܐ ܥܲܠܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ܐܝܼܢܵܐ ܗ̇ܘ ܝܕܝܼܥ ܠܹܗ ܚܘܼܫܵܒ݂ܵܝ̈ܗ‌ܝ، ܘܐܡܝܼܪܹܗ ܠܐܢܵܫܵܐ ܐܝܼܕܹܗ ܒܪܝܼܙܬܵ‌ܐ: ”ܬܵ‌ܐ ܘܟܠܝܼ ܒܹܝܦܲܠܓܵܐ.“ ܐܬܹ‌ܐ ܠܹܗ ܘܟܠܹܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܒܵܥܹܝܢ ܕܒܲܩܪܸܢܵܘܟ݂ܘܿܢ ܚܲܕ ܡܸܢܕܝܼ: ܐܲܝܢܝܼ ܝܠܵܗ̇ ܩܵܢܘܿܢܵܝܬܵ‌ܐ ܠܸܥܒ݂ܵܕܵܐ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ، ܛܵܒ݂ܬܵ‌ܐ ܝܲܢ ܒܝܼܫܬܵ‌ܐ؟ ܠܦܲܪܘܼܩܹܐ ܝܲܢ ܠܛܲܠܘܼܩܹܐ ܓܵܢܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ܘܚܝܼܪܹܗ ܠܚܵܕܸܪ̈ܘܵܢܘܼܗ‌ܝ ܒܟܠܵܝܗ‌ܝ، ܘܐܡܝܼܪܹܗ ܠܗ̇ܘ ܐܢܵܫܵܐ: ”ܦܲܫܸܛ ܐܝܼܕܘܼܟ݂.“ ܦܘܼܫܛܵܐ ܠܹܗ ܘܒܣܝܼܡ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ܘܐܵܢܝܼ ܦܝܼܫ ܠܗܘܿܢ ܡܸܠܝܹܐ ܟܲܪܒܵܐ، ܘܗܲܡܙܸܡܝܼ ܗܘܵܘ ܚܲܕ ܥܲܡ ܗ̇ܘ ܐܚܹܪܢܵܐ ܕܡܘܼܕܝܼ ܥܵܒ݂ܕܝܼ ܠܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ܒܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ ܦܠܝܼܛ ܠܹܗ ܝܼܫܘܿܥ ܠܛܘܼܪܵܐ ܠܨܲܠܘܼܝܹܐ، ܘܬܵܡܵܐ ܗܘܹܐ ܠܹܗ ܟܠܹܗ ܠܲܝܠܹܐ ܒܨܠܘܿܬܵ‌ܐ ܠܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ܘܐܝܼܡܲܢ ܕܗܘܹܐ ܠܹܗ ܒܲܗܪܵܐ، ܩܪܹܐ ܠܹܗ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ܘܓܘܼܒܹܐ ܠܹܗ ܡܸܢܵܝܗ‌ܝ ܬܪܸܥܣܲܪ، ܐܵܢܝܼ ܕܩܸܪܝܵܝ ܠܹܗ ܐܘܼܦ ܫܠܝܼܚܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ܫܸܡܥܘܿܢ، ܗ̇ܘ ܕܡܘܼܬܸܒ݂ ܠܹܗ ܫܸܡܹܗ ܟܹܐܦܵܐ، ܘܐܲܢܕܪܹܐܘܿܣ ܐܲܚܘܿܢܘܼܗ‌ܝ، ܘܝܲܥܩܘܿܒ݂ ܘܝܘܿܚܲܢܵܢ، ܘܦܝܼܠܝܼܦܘܿܣ ܘܒܲܪ ܬܘܼܠܡܲܝ. ");
INSERT INTO aii_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ܡܲܬܲ‌ܝ ܘܬܐܘܿܡܵܐ، ܘܝܲܥܩܘܿܒ݂ ܒܪܘܿܢܵܐ ܕܚܲܠܦܲܝ، ܘܫܸܡܥܘܿܢ ܕܦܝܵܫܵܐ ܝܠܹܗ ܩܸܪܝܵܐ ܛܲܢܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ܘܝܼܗܘܼܕܵܐ ܒܪܘܿܢܵܐ ܕܝܲܥܩܘܿܒ݂، ܘܝܼܗܘܼܕܵܐ ܣܟܲܪܝܘܿܛܵܐ ܗ̇ܘ ܕܗܘܹܐ ܠܹܗ ܣܲܦܝܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ܨܠܹܐ ܠܹܗ ܥܲܡܵܝܗ‌ܝ ܝܼܫܘܿܥ ܘܟܠܹܐ ܠܹܗ ܓܵܘ ܕܸܫܬܵ‌ܐ، ܘܪܵܒܵܐ ܡ̣ܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ܘܟܸܢܫܵܐ ܪܵܒܵܐ ܕܥܲܡܵܐ ܡ̣ܢ ܟܠܵܗ̇ ܝܼܗܘܼܕ، ܘܡ̣ܢ ܐܘܿܪܸܫܠܸܡ، ܘܡ̣ܢ ܡܲܪܙܵܐ ܕܝܵܡܵܐ ܕܨܘܿܪ ܘܨܲܝܕܘܿܢ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܕܫܵܡܥܝܼ ܗܹܡܸܙܡܵܢܘܼ̈ܗ‌ܝ ܘܦܵܝܫܝܼ ܒܘܼܣܡܹܐ ܡ̣ܢ ܡܲܪ̈ܥܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ܘܐܵܢܝܼ ܕܝܼܗܘܵܘ ܡܘܼܠܝܸܨܹܐ ܡ̣ܢ ܪ̈ܘܼܚܵܬܹ‌ܐ ܛܲܡܐܹ̈ܐ، ܦܝܼܫ ܠܗܘܿܢ ܒܘܼܣܡܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ܟܠܹܗ ܟܸܢܫܵܐ ܒܵܥܹܐ ܗܘܵܐ ܠܸܕܩܵܪܵܐ ܒܝܼܹܗ، ܣܵܒܵܒ ܚܲܝܠܵܐ ܦܵܠܹܛ ܗܘܵܐ ܡܸܢܹܗ، ܘܠܟܠܵܝܗ‌ܝ ܒܲܣܸܡ ܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ܚܝܼܪܹܗ ܝܼܫܘܿܥ ܒܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܐܡܝܼܪܹܗ: ”ܛܘܼܒ݂ܵܐ ܐܸܠܵܘܟ݂ܘܿܢ ܡܸܣܟܹܢܹ̈ܐ، ܣܵܒܵܒ ܕܝܼܵܘܟ݂ܘܿܢ ܝܼܠܵܗ̇ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ܛܘܼܒ݂ܵܐ، ܐܸܠܵܘܟ݂ܘܿܢ ܕܟܦܝܼܢܹܐ ܝܬܘܿܢ ܐܵܕܝܼܵܐ، ܣܵܒܵܒ ܒܸܬ ܣܵܒ݂ܥܝܼܬܘܿܢ. ܛܘܼܒ݂ܵܐ ܐܸܠܵܘܟ݂ܘܿܢ ܐܲܚܬܘܿܢ ܕܒܵܟܹܝܬܘܿܢ ܐܵܕܝܼܵܐ، ܣܵܒܵܒ ܒܸܬ ܓܵܚܟܝܼܬܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ܛܘܼܒ݂ܵܐ ܐܸܠܵܘܟ݂ܘܿܢ ܐܝܼܡܲܢ ܕܣܵܢܝܼ ܠܵܘܟ݂ܘܿܢ ܐܢܵܫܹ̈ܐ، ܘܦܵܪܫܝܼ ܠܵܘܟ݂ܘܿܢ، ܘܠܵܝܡܝܼ ܠܵܘܟ݂ܘܿܢ، ܘܩܵܪܝܼ ܠܵܘܟ݂ܘܿܢ ܒܝܼܫܹ̈ܐ ܒܘܼܬ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ܚܕܹܝܡܘܼܢ ܘܦܨܘܿܚܘܼܢ ܒܗ̇ܘ ܝܵܘܡܵܐ، ܣܵܒܵܒ ܦܘܼܪܥܵܢܵܘܟ݂ܘܿܢ ܓܘܼܪܵܐ ܝܠܹܗ ܒܫܡܲܝܵܐ. ܗܵܕܟ݂ܵܐ ܟܹܐ ܥܵܒ݂ܕܝܼ ܗܘܵܘ ܐܘܼܦ ܒܵܒܵܘܵܬܵܝ̈ܗ‌ܝ ܠܢܒ݂ܝܼܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","”ܐܝܼܢܵܐ ܘܵܝ ܐܸܠܵܘܟ݂ܘܿܢ ܥܲܬܝܼܪܹ̈ܐ، ܣܵܒܵܒ ܩܘܼܒܸܠܔ ܠܵܘܟ݂ܘܿܢ ܝܵܗܒ݂ܵܠܬܵ‌ܐ ܕܠܸܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ܘܵܝ ܐܸܠܵܘܟ݂ܘܿܢ ܐܵܢܝܼ ܕܣܒ݂ܝܼܥܹܐ ܝܬܘܿܢ ܐܵܕܝܼܵܐ، ܣܵܒܵܒ ܒܸܬ ܟܵܦܢܝܼܬܘܿܢ. ܘܵܝ ܐܸܠܵܘܟ݂ܘܿܢ ܐܵܢܝܼ ܕܓܵܚܟܝܼܬܘܿܢ ܐܵܕܝܼܵܐ، ܣܵܒܵܒ ܒܸܬ ܒܵܟܹܝܬܘܿܢ ܘܥܵܒ݂ܕܝܼܬܘܿܢ ܬܵܥܙܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ܘܵܝ ܐܸܠܵܘܟ݂ܘܿܢ ܐܝܼܡܲܢ ܕܗܲܡܙܸܡܝܼ ܨܦܵܝܝܼ ܒܘܼܬ ܕܝܼܵܘܟ݂ܘܿܢ ܟܠܵܝܗ‌ܝ ܒܢܲܝ̈ܢܵܫܵܐ. ܗܵܕܟ݂ܵܐ ܟܹܐ ܥܵܒ݂ܕܝܼ ܗܘܵܘ ܐܘܼܦ ܒܵܒܵܘܵܬܵܝ̈ܗ‌ܝ ܠܢܒ݂ܝܼܹ̈ܐ ܕܲܓܵܠܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","”ܐܝܼܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ ܕܝܼܬܘܿܢ ܒܸܫܡܵܥܵܐ، ܡܲܚܸܒܘܼܢ ܠܕܸܫ̃ܡܸܢܵܘ̈ܟ݂ܘܿܢ، ܘܥܒ݂ܘܿܕܘܼܢ ܛܵܒ݂ܬܵ‌ܐ ܠܐܵܢܝܼ ܕܣܵܢܝܼ ܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","”ܒܲܪܟ݂ܘܼܢ ܠܐܵܢܝܼ ܕܠܵܝܛܝܼ ܠܵܘܟ݂ܘܿܢ، ܘܨܲܠܹܝܡܘܼܢ ܒܘܼܬ ܐܵܢܝܼ ܕܙܵܠܡܝܼ ܥܲܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","”ܘܡ̇ܢ ܕܡܵܚܹܐ ܠܘܼܟ݂ ܥܲܠܔ ܚܲܕ ܓܹܒܵܐ ܕܦܵܬܘܼܟ݂، ܡܲܚܕܸܪ ܐܸܠܹܗ ܐܘܼܦ ܗ̇ܘ ܓܹܒܵܐ ܐܚܹܪܢܵܐ. ܘܡ̇ܢ ܕܫܵܩܹܠܔ ܥܵܒܵܝܬܘܼܟ݂، ܗܲܒ݂ܠܔ ܠܹܗ ܐܘܼܦ ܨܘܼܕܪܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","”ܟܠܔ ܡ̇ܢ ܕܛܵܠܹܒ ܡܸܢܘܼܟ݂، ܗܲܒ݂ܠܔ ܠܹܗ، ܘܡ̇ܢ ܕܫܵܩܹܠܔ ܡܸܢܕܝܼ ܡܸܢܘܼܟ݂، ܠܵܐ ܛܵܠܒܹܬ ܠܹܗ ܡܸܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","”ܘܕܵܐܟ݂ܝܼ ܕܒܵܥܹܝܬܘܿܢ ܕܥܵܒ݂ܕܝܼ ܐܸܠܵܘܟ݂ܘܿܢ ܐܢܵܫܹ̈ܐ، ܗܵܕܟ݂ܵܐ ܥܒ݂ܘܿܕܘܼܢ ܐܸܠܵܝܗ‌ܝ ܐܘܼܦ ܐܲܚܬܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","”ܐܸܢ ܡܲܚܸܒܝܼܬܘܿܢ ܠܐܵܢܝܼ ܕܡܲܚܸܒܝܼ ܠܵܘܟ݂ܘܿܢ، ܡܘܼܕܝܼ ܝܠܵܗ̇ ܛܵܒ݂ܬܵܘܟ݂ܘܿܢ؟ ܐܘܼܦ ܚܲܛܵܝܹ̈ܐ ܟܹܐ ܡܲܚܸܒܝܼ ܠܐܵܢܝܼ ܕܡܲܚܸܒܝܼ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","”ܘܐܸܢ ܥܵܒ݂ܕܝܼܬܘܿܢ ܛܵܒ݂ܬܵ‌ܐ ܠܐܵܢܝܼ ܕܥܵܒ݂ܕܝܼ ܛܵܒ݂ܬܵ‌ܐ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܲܝܟܵܐ ܝܠܵܗ̇ ܛܵܒ݂ܬܵܘܟ݂ܘܿܢ؟ ܐܘܼܦ ܚܲܛܵܝܹ̈ܐ ܟܹܐ ܥܵܒ݂ܕܝܼ ܐܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","”ܘܐܸܢ ܝܵܗܒ݂ܝܼܬܘܿܢ ܕܲܝܢܵܐ ܠܐܵܢܝܼ ܕܐܝܼܬ ܠܵܘܟ݂ܘܿܢ ܗܹܒ݂ܝܼ ܕܦܵܪܥܝܼ ܠܹܗ ܕܲܝܢܵܘܟ݂ܘܿܢ، ܡܘܼܕܝܼ ܝܠܵܗ̇ ܛܵܒ݂ܬܵܘܟ݂ܘܿܢ؟ ܐܘܼܦ ܚܲܛܵܝܹ̈ܐ ܟܹܐ ܝܵܗܒ݂ܝܼ ܕܲܝܢܵܐ ܠܚܲܛܵܝܹ̈ܐ ܕܡܸܢܕܪܸܫ ܦܵܝܫܝܼ ܦܪܝܼܥܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","”ܐܝܼܢܵܐ ܡܲܚܸܒܘܼܢ ܠܕܸܫ̃ܡܸܢܵܘ̈ܟ݂ܘܿܢ، ܥܒ݂ܘܿܕܘܼܢ ܛܵܒ݂ܬܵ‌ܐ، ܗܲܒ݂ܠܘܼܢ ܕܲܝܢܵܐ، ܘܠܵܐ ܩܵܛܥܝܼܬܘܿܢ ܗܹܒ݂ܝܼ ܕܐܢܵܫܵܐ، ܘܒܸܬ ܗܵܘܹܐ ܦܘܼܪܥܵܢܵܘܟ݂ܘܿܢ ܓܘܼܪܵܐ، ܘܒܸܬ ܗܵܘܹܝܬܘܿܢ ܒܢܘܿܢܹ̈ܐ ܕܥܸܠܵܝܵܐ، ܗ̇ܘ ܕܡܲܟܝܼܟ݂ܵܐ ܝܠܹܗ ܥܲܠܔ ܒܝܼܫܹ̈ܐ ܘܥܲܠܔ ܣܵܪ̈ܒ݂ܵܢܹܐ ܕܛܵܒ݂ܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","”ܗܘܹܝܡܘܼܢ ܡܪ̈ܲܚܡܵܢܹܐ، ܕܵܐܟ݂ܝܼ ܕܐܘܼܦ ܒܵܒܵܘܟ݂ܘܿܢ ܡܪܲܚܡܵܢܵܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","”ܠܵܐ ܕܵܝܢܝܼܬܘܿܢ، ܘܠܹܐ ܦܵܝܫܝܼܬܘܿܢ ܕܝܼܢܹܐ. ܠܵܐ ܕܵܒ݂ܩܝܼܬܘܿܢ ܓܢܵܗܵܐ ܠܐܢܵܫܹ̈ܐ، ܘܠܹܐ ܦܵܝܫܝܼ ܕܒ݂ܝܼܩܹܐ ܓܢܵܗܵܘ̈ܟ݂ܘܿܢ. ܦܲܚܠܘܼܢ، ܘܒܸܬ ܦܵܝܫܝܼܬܘܿܢ ܦܘܼܚܠܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","”ܗܲܒ݂ܠܘܼܢ، ܘܒܸܬ ܦܵܐܹܫ ܝܘܼܗܒ݂ܵܐ ܐܸܠܵܘܟ݂ܘܿܢ، ܒܟܝܘܼܠܵܐ ܨܦܵܝܝܼ ܘܫܥܝܼܫܵܐ ܘܕܝܼܫܵܐ ܘܫܦܝܼܟ݂ܵܐ ܒܸܬ ܦܵܝܫܝܼܬܘܿܢ ܝܘܼܗܒܹܐ. ܣܵܒܵܒ ܒܟܝܘܼܠܵܐ ܕܟܵܝܠܝܼܬܘܿܢ ܒܸܬ ܦܵܐܹܫ ܟܝܼܠܵܐ ܐܸܠܵܘܟ݂ܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܡܲܬܠܵܐ: ”ܟܹܐ ܡܵܨܹܐ ܣܸܡܝܵܐ ܠܣܸܡܝܵܐ ܒܐܘܼܪܚܵܐ ܠܲܒܸܠܔ؟ ܠܹܐ ܢܵܦܠܝܼ ܬܸܪܘܵܝ ܒܓܘܼܒܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","”ܠܲܝܬ ܬܲܠܡܝܼܕܵܐ ܥܸܠܸܠܔ ܡ̣ܢ ܪܲܒܝܼܹܗ. ܐܝܼܢܵܐ ܟܠܔ ܐܢܵܫܵܐ ܕܝܼܠܹܗ ܟܡܝܼܠܵܐ ܒܝܘܼܠܦܵܢܵܐ ܒܸܬ ܗܵܘܹܐ ܐܲܝܟ݂ ܪܲܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","”ܩܵܡܘܿܕܝܼ ܒܸܚܙܵܝܵܐ ܝܘܸܬ ܙܸܠܸܟܵܐ ܕܓܵܘ ܥܲܝܢܵܐ ܕܐܲܚܘܿܢܘܼܟ݂، ܐܝܼܢܵܐ ܩܵܪܝܼܬܵ‌ܐ ܕܓܵܘ ܥܲܝܢܵܐ ܕܓܵܢܘܼܟ݂ ܠܹܐ ܝܘܸܬ ܒܸܚܙܵܝܘܼܗ̇؟ ");
INSERT INTO aii_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","”ܝܲܢ ܕܵܐܟ݂ܝܼ ܡܵܨܹܝܬ ܐܵܡܪܹܬ ܠܐܲܚܘܿܢܘܼܟ݂: ’ܐܲܚܘܿܢܝܼ، ܫܒ݂ܘܿܩ ܠܝܼ ܕܦܲܠܛܸܢ ܙܸܠܸܟܵܐ ܡ̣ܢ ܥܲܝܢܘܼܟ݂،‘ ܘܟܲܕ ܩܵܪܝܼܬܵ‌ܐ ܒܥܲܝܢܵܐ ܕܓܵܢܘܼܟ݂ ܠܹܐ ܝܘܸܬ ܒܸܚܙܵܝܘܼܗ̇؟ ܝܵܐ ܡܲܫܦܸܪܵܢܵܐ، ܩܲܕܡܵܝܬܵ‌ܐ ܦܲܠܸܛ ܩܵܪܝܼܬܵ‌ܐ ܡ̣ܢ ܥܲܝܢܘܼܟ݂، ܘܗ̇ܝܓܵܗ ܒܸܬ ܚܵܙܹܝܬ ܨܸܦܝܵܐ ܕܦܲܠܛܸܬ ܙܸܠܸܟܵܐ ܡ̣ܢ ܥܲܝܢܵܐ ܕܐܲܚܘܿܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","”ܠܲܝܬ ܐܝܼܠܵܢܵܐ ܛܵܒ݂ܵܐ ܕܥܵܒܹܕ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܚܸܪܒܵܐ، ܘܠܵܐ ܐܝܼܠܵܢܵܐ ܚܸܪܒܵܐ ܕܥܵܒܹܕ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܛܵܒܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","”ܣܵܒܵܒ ܟܠܔ ܐܝܼܠܵܢܵܐ ܡ̣ܢ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܕܝܼܹܗ ܟܹܐ ܦܵܐܹܫ ܝܕܝܼܥܵܐ. ܣܵܒܵܒ ܠܹܐ ܓܲܒܝܼ ܬܹܐܢܹ̈ܐ ܡ̣ܢ ܟܸܬܘܹ̈ܐ، ܘܠܵܐ ܥܲܢܒܹ̈ܐ ܡ̣ܢ ܩܝܼܘܵܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","”ܐܢܵܫܵܐ ܛܵܒ݂ܵܐ ܡ̣ܢ ܚܲܙܝܼܢܹ̈ܐ ܛܵܒܹ̈ܐ ܕܠܸܒܹܗ ܟܹܐ ܦܲܠܸܛ ܛܵܒ݂ܵܬܹ̈‌ܐ، ܘܐܢܵܫܵܐ ܒܝܼܫܵܐ ܡ̣ܢ ܚܲܙܝܼܢܹ̈ܐ ܒܝܼܫܹ̈ܐ ܕܠܸܒܹܗ ܟܹܐ ܦܲܠܸܛ ܒܝܼܫܵܬܹ̈‌ܐ. ܣܵܒܵܒ ܡ̣ܢ ܙܵܘܕܘܼܢܝܘܼܬܵ‌ܐ ܕܠܸܒܵܐ ܟܹܐ ܗܲܡܙܸܡ ܦܘܼܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","”ܩܵܡܘܿܕܝܼ ܒܸܩܪܵܝܝܼ ܝܬܘܿܢ: ’ܡܵܪܝܼ، ܡܵܪܝܼ،‘ ܐܝܼܢܵܐ ܡܸܢܕܝܼ ܕܒܹܐܡܵܪܵܐ ܝܘܸܢ ܠܹܐ ܝܬܘܿܢ ܒܸܥܒ݂ܵܕܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","”ܟܠܔ ܐܢܵܫܵܐ ܕܐܵܬܹ‌ܐ ܠܟܸܣܠܝܼ ܘܫܵܡܹܥ ܗܹܡܸܙܡܵܢܝܼ̈ ܘܥܵܒܹܕ ܠܗܘܿܢ، ܡܲܚܙܸܢܵܘܟ݂ܘܿܢ ܠܡܘܼܕܝܼ ܟܹܐ ܕܵܡܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","”ܟܹܐ ܕܵܡܹܐ ܠܐܢܵܫܵܐ ܕܒܢܹܐ ܠܹܗ ܒܲܝܬܵ‌ܐ، ܚܦܝܼܪܹܗ ܥܲܡܘܼܩܵܐ، ܘܡܘܼܬܸܒ݂ ܠܹܗ ܒܸܢܝܲܬܹܗ ܥܲܠܔ ܩܵܝܵܐ. ܘܐܝܼܡܲܢ ܕܗܘܹܐ ܠܹܗ ܡܸܠܐܵܐ، ܩܝܼܬ ܠܹܗ ܒܗ̇ܘ ܒܲܝܬܵ‌ܐ، ܐܝܼܢܵܐ ܠܵܐ ܡܨܹܐ ܠܹܗ ܫܵܥܹܫ ܗܘܵܐ ܠܹܗ، ܣܵܒܵܒ ܒܸܢܝܲܬܹܗ ܥܲܠܔ ܩܵܝܵܐ ܫܘܼܬܐܸܣܬܵ‌ܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","”ܘܗ̇ܘ ܕܫܵܡܹܥ ܗܹܡܸܙܡܵܢܝܼ̈ ܘܠܵܐ ܥܵܒܹܕ ܠܗܘܿܢ، ܟܹܐ ܕܵܡܹܐ ܠܐܢܵܫܵܐ ܕܒܢܹܐ ܠܹܗ ܒܲܝܬܹܗ ܥܲܠܔ ܥܲܦܪܵܐ، ܕܠܵܐ ܒܸܢܝܲܬ. ܘܩܝܼܬ ܠܹܗ ܒܝܼܹܗ ܢܲܗܪܵܐ، ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܢܦܝܼܠܔ ܠܹܗ. ܘܗܘܹܐ ܠܵܗ̇ ܢܦܵܠܬܹܗ ܓܘܼܪܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ܐܝܼܡܲܢ ܕܦܪܝܼܩ ܠܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܗܲܡܙܘܼܡܹܐ ܩܵܐ ܥܲܡܵܐ، ܥܒ݂ܝܼܪܹܗ ܠܟܦܲܪܢܵܚܘܿܡ. ");
INSERT INTO aii_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ܘܐܝܼܬ ܗܘܵܐ ܪܹܓܵܐ ܕܚܲܕ ܪܲܒ ܡܵܐܐ ܕܡܪܝܼܥܵܐ ܝܗܘܵܐ ܩܘܼܪܒܵܐ ܠܡܵܘܬܵ‌ܐ. ܘܪܲܒ ܡܵܐܐ ܟܹܐ ܡܲܚܸܒ ܗܘܵܐ ܠܹܗ ܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ܫܡܝܼܥ ܠܹܗ ܪܲܒ ܡܵܐܐ ܒܘܼܬ ܝܼܫܘܿܥ، ܘܫܘܼܕܸܪܹܗ ܠܟܸܣܠܹܗ ܚܘܵܪ̈ܕܸܩܢܹܐ ܕܝܗܘܼܕܵܝܹ̈ܐ، ܒܸܛܠܵܒܵܐ ܡܸܢܹܗ ܕܐܵܬܹ‌ܐ ܘܒܲܣܸܡ ܠܪܹܓܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ܐܲܢܹܐ ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣ ܝܼܫܘܿܥ ܘܛܠܝܼܒ ܠܗܘܿܢ ܡܸܢܹܗ ܚܦܝܼܛܵܐܝܼܬ ܘܐܡܝܼܪܗܘܿܢ: ”ܚܫܝܼܚܵܐ ܝܠܹܗ ܕܥܵܒ݂ܕܹܬ ܐܸܠܹܗ ܐܵܗܵܐ ܫܘܼܠܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","”ܣܵܒܵܒ ܟܹܐ ܡܲܚܸܒ ܠܛܵܝܸܦܲܢ، ܘܐܘܼܦ ܒܢܹܐ ܠܹܗ ܐܸܠܲܢ ܚܕܵܐ ܟܢܘܼܫܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ܘܐܙܝܼܠܔ ܠܹܗ ܝܼܫܘܿܥ ܥܲܡܵܝܗ‌ܝ. ܐܝܼܢܵܐ ܗܸܫ ܠܹܐ ܝܗܘܵܐ ܪܚܝܼܩܵܐ ܡ̣ܢ ܒܲܝܬܵ‌ܐ، ܫܘܼܕܸܪܹܗ ܠܟܸܣܠܹܗ ܪܲܒ ܡܵܐܐ ܐܢܵܫܘܼ̈ܗ‌ܝ ܒܹܐܡܵܪܵܐ: ”ܡܵܪܝܼ، ܠܵܐ ܥܲܓ̰ܸܙ ܓܵܢܘܼܟ݂، ܣܵܒܵܒ ܠܹܐ ܝܘܸܢ ܚܫܝܼܚܵܐ ܕܥܵܒ݂ܪܹܬ ܓܵܘ ܒܲܝܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","”ܒܘܼܬ ܐܵܗܵܐ ܐܵܢܵܐ ܒܓܵܢܝܼ ܠܵܐ ܐܬܹ‌ܐ ܠܝܼ ܠܟܸܣܠܘܼܟ݂، ܐܸܠܵܐ ܐܡܘܿܪ ܗܹܡܸܙܡܵܢ ܘܒܸܬ ܒܵܣܹܡ ܪܹܓܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","”ܣܵܒܵܒ ܐܘܼܦ ܐܵܢܵܐ ܚܲܕ ܐܢܵܫܵܐ ܝܘܸܢ ܬܚܘܿܬ ܫܘܼܠܛܵܢܵܐ، ܘܐܝܼܬ ܬܚܘܿܬ ܐܝܼܕܝܼ ܕܲܚܫܹ̈ܐ، ܟܹܐ ܐܵܡܪܹܢ ܠܐܵܗܵܐ: ’ܙܹܠܔ݇، ܘܟܹܐ ܐܵܙܹܠܔ؛ ܘܠܗ̇ܘ ܐܚܹܪܢܵܐ: ’ܬܵ‌ܐ،‘ ܘܟܹܐ ܐܵܬܹ‌ܐ؛ ܘܠܪܹܓܝܼ: ’ܥܒ݂ܘܿܕ ܐܵܗܵܐ،‘ ܘܟܹܐ ܥܵܒܹܕ.“ ");
INSERT INTO aii_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܹܗ ܝܼܫܘܿܥ ܐܲܢܹܐ، ܥܘܼܓ̰ܸܒ ܠܹܗ ܒܝܼܹܗ. ܕܝܼܪܹܗ ܘܐܡܝܼܪܹܗ ܠܟܸܢܫܵܐ ܕܒܹܐܬܵܝܵܐ ܝܗܘܵܐ ܒܵܬܪܹܗ: ”ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܘܼܦ ܓܵܘ ܐܝܼܣܪܵܐܹܝܠܔ ܠܵܐ ܚܙܹܐ ܠܝܼ ܗܲܝܡܵܢܘܼܬܵ‌ܐ ܐܲܝܟ݂ ܐܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ܘܕܝܼܪܗܘܿܢ ܠܒܲܝܬܵ‌ܐ ܐܵܢܝܼ ܕܝܼܗܘܵܘ ܫܘܼܕܪܹܐ، ܘܡܘܼܫ݇ܟ̰ܸܚ ܠܗܘܿܢ ܒܣܝܼܡܵܐ ܗ̇ܘ ܪܹܓܵܐ ܕܝܼܗܘܵܐ ܡܪܝܼܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ܘܒܝܵܘܡܵܐ ܐܚܹܪܢܵܐ، ܒܹܐܙܵܠܵܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܠܡܕܝܼܢ݇ܬܵ‌ܐ ܫܸܡܘܼܗ̇ ܢܵܐܹܝܢ، ܘܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܥܲܡܹܗ، ܘܟܸܢܫܵܐ ܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ܟܲܕ ܩܘܼܪܒܸܢܹܗ ܠܬܲܪܥܵܐ ܕܡܕܝܼܢ݇ܬܵ‌ܐ، ܚܙܹܐ ܠܹܗ ܐܢܵܫܹ̈ܐ ܦܲܠܘܼܛܹܐ ܚܲܕ ܡܝܼܬܵ‌ܐ، ܒܪܘܿܢܵܐ ܝܼܚܝܼܕܵܝܵܐ ܠܝܸܡܹܗ، ܗ̇ܝ ܕܐܲܪܡܸܠܬܵ‌ܐ ܝܗܘܵܐ، ܘܟܸܢܫܵܐ ܪܵܒܵܐ ܐܝܼܬ ܗܘܵܐ ܥܲܡܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ܐܝܼܡܲܢ ܕܚܸܙܝܵܐ ܠܹܗ ܝܼܫܘܿܥ ܪܘܼܚܸܡ ܠܹܗ ܥܲܠܘܼܗ̇، ܘܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇: ”ܠܵܐ ܒܵܟ݂ܝܲܬ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ܐܙܝܼܠܔ ܠܹܗ ܘܕܩܝܼܪܹܗ ܒܫܘܝܼܬܵ‌ܐ. ܘܐܵܢܝܼ ܕܛܥܝܼܢܘܼܗ̇ ܝܗܘܵܘ ܟܠܹܐ ܠܗܘܿܢ. ܘܐܡܝܼܪܹܗ ܝܼܫܘܿܥ: ”ܓ̰ܘܲܢܩܵܐ، ܐܸܠܘܼܟ݂ ܒܹܐܡܵܪܵܐ ܝܘܸܢ، ܩܘܼܡ.“ ");
INSERT INTO aii_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ܘܝܬܝܼܒ݂ ܠܹܗ ܗ̇ܘ ܡܝܼܬܵ‌ܐ، ܘܫܘܼܪܹܐ ܠܹܗ ܠܗܲܡܙܘܼܡܹܐ، ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܝܼܫܘܿܥ ܠܝܸܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ܕܒ݂ܝܼܩ ܠܵܗ̇ ܙܕܘܼܥܬܵ‌ܐ ܠܟܠܵܝܗ‌ܝ ܐܢܵܫܹ̈ܐ، ܘܫܲܒܚܝܼ ܗܘܵܘ ܠܐܲܠܵܗܵܐ ܒܹܐܡܵܪܵܐ: ”ܢܒ݂ܝܼܵܐ ܓܘܼܪܵܐ ܩܝܼܡ ܠܹܗ ܓܵܘܲܢ، ܘܣܘܼܚܒܸܪܹܗ ܐܲܠܵܗܵܐ ܠܥܲܡܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ܘܦܠܝܼܛ ܠܵܗ̇ ܒܘܼܬ ܕܝܼܹܗ ܐܵܗܵܐ ܗܹܡܸܙܡܵܢ ܒܟܠܵܗ̇ ܝܼܗܘܼܕ ܘܒܟܠܵܝܗ‌ܝ ܚܵܕܸܪ̈ܘܵܢܹܐ ܕܐܲܬܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ܗܘܼܩܹܐ ܠܗܘܿܢ ܬܲܠܡܝܼ̈ܕܹܐ ܕܝܘܿܚܲܢܵܢ ܐܸܠܹܗ ܟܠܵܝܗ‌ܝ ܐܲܢܹܐ ܕܥܒ݂ܝܼܕܵܝ ܠܹܗ ܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ܘܩܪܹܐ ܠܹܗ ܝܘܿܚܲܢܵܢ ܠܬܪܹܝ ܡ̣ܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܫܘܼܕܪܵܝ ܠܹܗ ܠܟܸܣ ܝܼܫܘܿܥ ܕܒܲܩܪܝܼ ܠܹܗ: ”ܐܲܢ݇ܬ ܝܼܘܸܬ ܗ̇ܘ ܕܐܵܬܹ‌ܐ، ܝܲܢ ܣܵܦܪܲܚ ܠܚܲܕ ܐܚܹܪܢܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܐܵܢܝܼ ܬܲܠܡܝܼ̈ܕܹܐ ܠܟܸܣ ܝܼܫܘܿܥ ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܝܘܿܚܲܢܵܢ ܡܲܥܡܕܵܢܵܐ ܩܵܡ ܫܲܕܸܪܲܢ ܠܟܸܣܠܘܼܟ݂ ܕܒܲܩܪܲܚ ܠܘܼܟ݂: ’ܐܲܢ݇ܬ ܝܼܘܸܬ ܗ̇ܘ ܕܐܵܬܹ‌ܐ ܝܲܢ ܣܵܦܪܲܚ ܠܚܲܕ ܐܚܹܪܢܵܐ؟‘“ ");
INSERT INTO aii_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ܒܗ̇ܝ ܥܕܵܢܵܐ ܝܼܫܘܿܥ ܒܲܣܘܼܡܹܐ ܝܗܘܵܐ ܪܵܒܵܐ ܐܢܵܫܹ̈ܐ ܡ̣ܢ ܡܲܪ̈ܥܹܐ ܘܡ̣ܢ ܡܲܚܘܵܬܹ̈‌ܐ ܘܡ̣ܢ ܪ̈ܘܼܚܵܬܹ‌ܐ ܒܝܼܫܹ̈ܐ، ܘܥܒ݂ܝܼܕ ܠܹܗ ܪܵܒܵܐ ܣܸܡܝܹ̈ܐ ܕܚܵܙܝܼ ܗܘܵܘ. ");
INSERT INTO aii_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܠܬܲܠܡܝܼ̈ܕܹܐ ܕܝܘܿܚܲܢܵܢ: ”ܙܹܠ݇ܡܘܼܢ ܘܐܡܘܿܪܘܼܢ ܠܝܘܿܚܲܢܵܢ ܡܸܢܕܝܼ ܕܚܙܹܐ ܠܵܘܟ݂ܘܿܢ ܘܫܡܝܼܥ ܠܵܘܟ݂ܘܿܢ، ܕܣܸܡܝܹ̈ܐ ܒܸܚܙܵܝܵܐ ܝܢܵܐ، ܫܦܝܼܠܹ̈ܐ ܒܸܚܕܵܪܵܐ ܝܢܵܐ، ܘܓܸܪ̈ܒ݂ܵܢܹܐ ܦܝܵܫܵܐ ܝܢܵܐ ܕܘܼܟ݂ܝܹܐ، ܘܚܲܪ̈ܫܹܐ ܒܸܫܡܵܥܵܐ ܝܢܵܐ، ܘܡܝܼ̈ܬܹ‌ܐ ܦܝܵܫܵܐ ܝܢܵܐ ܡܘܼܩܸܡܹܐ، ܘܡܸܣܟܹܢܹ̈ܐ ܦܝܵܫܵܐ ܝܢܵܐ ܡܘܼܟܪܸܙܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ܛܘܼܒ݂ܵܐ ܠܡ̇ܢ ܕܠܵܐ ܣܵܪܹܒ݂ ܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ܡ̣ܢ ܒܵܬܪ ܕܐܙܝܼܠܔ ܠܗܘܿܢ ܬܲܠܡܝܼ̈ܕܹܐ ܕܝܘܿܚܲܢܵܢ، ܗܘܼܡܙܸܡ ܠܹܗ ܝܼܫܘܿܥ ܠܟܸܢܫܵܐ ܒܘܼܬ ܝܘܿܚܲܢܵܢ ܘܐܡܝܼܪܹܗ: ”ܡܘܼܕܝܼ ܦܠܝܼܛ ܠܵܘܟ݂ܘܿܢ ܠܒܲܪܝܼܵܐ ܠܸܚܙܵܝܵܐ، ܙܹܠܵܐ ܫܥܝܼܫܵܐ ܒܝܲܕ ܦܵܘܚܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","”ܝܲܢ ܡܘܼܕܝܼ ܦܠܝܼܛ ܠܵܘܟ݂ܘܿܢ ܠܸܚܙܵܝܵܐ، ܐܢܵܫܵܐ ܠܒ݂ܝܼܫܵܐ ܓ̰ܘܼܠܹ̈ܐ ܪ̈ܲܟܝܼܟܹܐ؟ ܐܵܢܝܼ ܕܟܹܐ ܠܵܒ݂ܫܝܼ ܓ̰ܘܼܠܹ̈ܐ ܪ̈ܲܟܝܼܟܹܐ ܘܕܝܼܢܵܐ ܓܵܘ ܒܘܼܣܵܡܹ̈ܐ، ܓܵܘ ܒܵܬܹ̈‌ܐ ܕܡܲܠܟܹ̈ܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","”ܝܲܢ ܡܘܼܕܝܼ ܦܠܝܼܛ ܠܵܘܟ݂ܘܿܢ ܠܸܚܙܵܝܵܐ، ܢܒ݂ܝܼܵܐ؟ ܗܹܐ، ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܒܘܼܫ ܙܵܘܕܵܐ ܝܠܹܗ ܡ̣ܢ ܢܒ݂ܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","”ܐܵܗܵܐ ܝܠܹܗ ܗ̇ܘ ܕܝܼܠܹܗ ܦܝܼܫܵܐ ܟܬܝܼܒ݂ܵܐ ܒܘܼܬ ܕܝܼܹܗ: ܗܵܐ ܐܵܢܵܐ ܫܲܕܘܼܪܹܐ ܝܘܸܢ ܐܝܼܙܓܲܕܝܼ ܩܲܕܡܘܼܟ݂ ܕܗܲܕܸܪ ܐܘܼܪܚܘܼܟ݂ ܩܲܕܡܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","”ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܠܲܝܬ ܢܒ݂ܝܼܵܐ ܝܠܝܼܕܵܐ ܡ̣ܢ ܒܲܟ݂ܬܵ‌ܐ ܒܘܼܫ ܓܘܼܪܵܐ ܡ̣ܢ ܝܘܿܚܲܢܵܢ ܡܲܥܡܕܵܢܵܐ. ܐܝܼܢܵܐ ܗ̇ܘ ܒܘܼܫ ܙܥܘܿܪܵܐ ܓܵܘ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ ܒܘܼܫ ܓܘܼܪܵܐ ܝܠܹܗ ܡܸܢܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܹܗ ܟܠܹܗ ܥܲܡܵܐ، ܐܘܼܦ ܡܵܟ݂ܣܹ̈ܐ، ܡܘܼܕܹܐ ܠܗܘܿܢ ܒܙܲܕܝܼܩܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ ܕܥܡܝܼܕܹܐ ܝܗܘܵܘ ܒܡܲܥܡܘܿܕܝܼܬܵ‌ܐ ܕܝܘܿܚܲܢܵܢ. ");
INSERT INTO aii_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ܐܝܼܢܵܐ ܦܪ̈ܝܼܫܹܐ ܘܢܵܡܘܿܣܵܝܹ̈ܐ ܒܓܵܢܵܝܗ‌ܝ ܡܘܼܣܠܹܐ ܠܗܘܿܢ ܠܨܸܒ݂ܝܵܢܵܐ ܕܐܲܠܵܗܵܐ ܕܠܵܐ ܦܝܼܫ ܠܗܘܿܢ ܥܡܝܼܕܹܐ ܡܸܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ܘܐܡܝܼܪܹܗ ܡܵܪܲܢ: ”ܠܡ̇ܢ ܡܲܕܡܸܢܗܘܿܢ ܐܢܵܫܹ̈ܐ ܕܐܵܗܵܐ ܫܲܪܒܬܵ‌ܐ، ܘܠܡ̇ܢ ܟܹܐ ܕܵܡܝܼ؟ ");
INSERT INTO aii_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","”ܟܹܐ ܕܵܡܝܼ ܠܝܵܠܹ̈ܕ݇ܐ ܝܬܝܼܒܹܐ ܒܫܘܼܩܵܐ ܘܡܲܩܘܘܼܚܹܐ ܠܚܲܒ݂ܪ̈ܵܘܵܬܵܝܗ‌ܝ ܘܒܹܐܡܵܪܵܐ: ’ܙܡܝܼܪܲܢ ܐܸܠܵܘܟ݂ܘܿܢ ܘܠܵܐ ܪܩܝܼܕ ܠܵܘܟ݂ܘܿܢ، ܘܝܠܹܐ ܠܲܢ ܐܸܠܵܘܟ݂ܘܿܢ ܘܠܵܐ ܒܟܹܐ ܠܵܘܟ݂ܘܿܢ.‘ ");
INSERT INTO aii_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","”ܣܵܒܵܒ ܐܬܹ‌ܐ ܠܹܗ ܝܘܿܚܲܢܵܢ ܡܲܥܡܕܵܢܵܐ ܠܵܐ ܒܹܐܟ݂ܵܠܵܐ ܠܲܚܡܵܐ ܘܠܵܐ ܒܸܫܬܵܝܵܐ ܚܲܡܪܵܐ، ܘܒܹܐܡܵܪܵܐ ܝܬܘܿܢ: ’ܫܹܐܕܵܐ ܐܝܼܬ ܒܝܼܹܗ.‘ ");
INSERT INTO aii_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","”ܐܬܹ‌ܐ ܠܹܗ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܹܐܟ݂ܵܠܵܐ ܘܒܸܫܬܵܝܵܐ، ܒܹܐܡܵܪܵܐ ܝܬܘܿܢ: ’ܗܵܐ ܐܢܵܫܵܐ ܐܵܟ݂ܠܵܢܵܐ ܘܫܵܬܝܵܢܵܐ ܕܚܲܡܪܵܐ، ܘܚܲܒ݂ܪܵܐ ܕܡܵܟ݂ܣܹ̈ܐ ܘܚܲܛܵܝܹ̈ܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","”ܦܝܼܫ ܠܵܗ̇ ܡܘܼܟܫܸܛܬܵ‌ܐ ܚܸܟ݂ܡܬܵ‌ܐ ܒܟܠܵܝܗ‌ܝ ܒܢܘܿܢܘܼ̈ܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ܘܛܠܝܼܒ ܠܹܗ ܚܲܕ ܡ̣ܢ ܦܪ̈ܝܼܫܹܐ ܡ̣ܢ ܝܼܫܘܿܥ ܕܐܵܟܹܠܔ ܗܘܵܐ ܠܲܚܡܵܐ ܥܲܡܹܗ. ܘܥܒ݂ܝܼܪܹܗ ܠܒܲܝܬܵ‌ܐ ܕܗ̇ܘ ܦܪܝܼܫܵܐ ܘܝܬܝܼܒ݂ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ܘܝܕܝܼܥ ܠܵܗ̇ ܚܕܵܐ ܒܲܟ݂ܬܵ‌ܐ ܚܲܛܵܝܬܵ‌ܐ ܒܗ̇ܝ ܡܕܝܼܢ݇ܬܵ‌ܐ ܕܝܬܝܼܒ݂ܵܐ ܝܗܘܵܐ ܓܵܘ ܒܲܝܬܵ‌ܐ ܕܗ̇ܘ ܦܪܝܼܫܵܐ، ܫܩܝܼܠܔ ܠܵܗ̇ ܫܵܛܝܼܦܬܵ‌ܐ ܕܒܸܣܡܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ܐܬܹ‌ܐ ܠܵܗ̇ ܘܟܠܹܐ ܠܵܗ̇ ܒܵܬܪ ܚܲܨܹܗ ܠܟܸܣ ܐܲܩܠܵܬܘܼ̈ܗ‌ܝ ܒܸܒܟ݂ܵܝܵܐ. ܫܘܼܪܹܐ ܠܵܗ̇ ܒܕܸܡܥܘܼ̈ܗ̇ ܡܲܬܪܘܼܝܹܐ ܠܐܲܩܠܵܬܘܼ̈ܗ‌ܝ، ܘܒܟܵܘܣܘܼܗ̇ ܒܸܡܫܵܝܵܝ، ܘܢܵܫܩܵܐ ܗܘܵܐ ܠܗܘܿܢ، ܘܡܵܫܚܵܐ ܗܘܵܐ ܠܗܘܿܢ ܒܒܸܣܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܹܗ ܗ̇ܘ ܦܪܝܼܫܵܐ ܕܟ̰ܝܼܕܵܐ ܝܗܘܵܐ ܠܝܼܫܘܿܥ ܐܵܗܵܐ ܡܸܢܕܝܼ ܕܥܒ݂ܝܼܕ ܠܵܗ̇ ܗ̇ܝ ܒܲܟ݂ܬܵ‌ܐ، ܐܡܝܼܪܹܗ ܓܵܘ ܓܵܢܹܗ: ”ܐܸܢ ܐܵܗܵܐ ܐܢܵܫܵܐ ܗܵܘܹܐ ܗܘܵܐ ܢܒ݂ܝܼܵܐ، ܒܸܬ ܝܵܕܹܥ ܗܘܵܐ ܡܵܢܝܼ ܝܠܵܗ̇ ܘܡܘܼܕܝܼ ܒܲܟ݂ܬܵ‌ܐ ܝܠܵܗ̇ ܕܕܩܝܼܪܵܗ̇ ܒܝܼܹܗ، ܒܲܟ݂ܬܵ‌ܐ ܚܲܛܵܝܬܵ‌ܐ ܝܠܵܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܫܸܡܥܘܿܢ، ܒܵܥܹܝܢ ܕܐܵܡܪܹܢܘܼܟ݂ ܚܲܕ ܡܸܢܕܝܼ.“ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܐܡܘܿܪ ܪܲܒܝܼ.“ ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ");
INSERT INTO aii_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","”ܚܲܕ ܡܵܪܵܐ ܕܕܲܝܢܵܐ ܐܝܼܬ ܗܘܵܐ ܠܹܗ ܬܪܹܝ ܕܲܝܢܵܢܹ̈ܐ. ܚܲܕ ܡܸܢܵܝܗ‌ܝ ܕܲܝܢܵܢܵܐ ܝܗܘܵܐ ܐܸܠܹܗ ܚܲܡܸܫܡܵܐܐ ܕܝܼܢܵܪܹ̈ܐ، ܘܗ̇ܘ ܐܚܹܪܢܵܐ ܚܲܡܫܝܼ ܕܝܼܢܵܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","”ܘܠܲܝܬ ܗܘܵܐ ܠܗܘܿܢ ܡܨܵܝܬܵ‌ܐ ܠܸܦܪܵܥܵܐ، ܘܦܘܼܚܸܠܔ ܠܹܗ ܠܬܸܪܘܵܝ. ܐܡܘܿܪ ܐܸܠܝܼ، ܐܲܝܢܝܼ ܡ̣ܢ ܐܲܢܹܐ ܬܪܹܝ ܕܲܝܢܵܢܹ̈ܐ ܒܘܼܫ ܙܵܘܕܵܐ ܒܸܬ ܡܲܚܸܒ ܠܡܵܪܵܐ ܕܕܲܝܢܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ܓ̰ܘܼܘܸܒ ܠܹܗ ܫܸܡܥܘܿܢ ܘܐܡܝܼܪܹܗ: ”ܒܸܚܫܵܒ݂ܵܐ ܝܘܸܢ ܗ̇ܘ ܕܦܘܼܚܸܠܔ ܠܹܗ ܐܸܠܹܗ ܙܵܘܕܵܐ.“ ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܒܫܲܪܝܼܪܘܼܬܵ‌ܐ ܕܝܼܢܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ܦܬܝܼܠܔ ܠܹܗ ܠܓܹܒܵܐ ܕܒܲܟ݂ܬܵ‌ܐ ܘܐܡܝܼܪܹܗ ܠܫܸܡܥܘܿܢ: ”ܒܸܚܙܵܝܵܐ ܝܘܸܬ ܐܵܗܵܐ ܒܲܟ݂ܬܵ‌ܐ؟ ܥܒ݂ܝܼܪܝܼ ܠܒܲܝܬܘܼܟ݂، ܡ̈ܝܼܵܐ ܩܵܐ ܐܲܩܠܵܬ‌ܝܼ̈ ܠܵܐ ܝܘܼܗܒܹܠܔ ܠܘܼܟ݂. ܐܝܼܢܵܐ ܐܵܗܵܐ ܒܲܟ݂ܬܵ‌ܐ ܒܕܸܡܥܘܼ̈ܗ̇ ܡܘܼܬܪܹܐ ܠܵܗ̇ ܐܲܩܠܵܬ‌ܝܼ̈، ܘܒܟܵܘܣܘܼܗ̇ ܡܸܫܝܵܝ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","”ܐܲܢ݇ܬ ܠܵܐ ܢܫܝܼܩܸܢܘܼܟ݂، ܐܝܼܢܵܐ ܐܵܗܵܐ ܒܲܟ݂ܬܵ‌ܐ ܗܵܐ ܡ̣ܢ ܕܥܒ݂ܝܼܪܝܼ ܠܵܐ ܫܠܹܐ ܠܵܗ̇ ܡ̣ܢ ܠܸܢܫܵܩܵܐ ܐܲܩܠܵܬ‌ܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","”ܐܲܢ݇ܬ ܒܡܸܫܚܵܐ ܠܵܐ ܡܫܝܼܚ ܠܘܼܟ݂ ܠܪܹܝܫܝܼ، ܐܝܼܢܵܐ ܐܵܗܵܐ ܒܲܟ݂ܬܵ‌ܐ ܒܡܸܫܚܵܐ ܕܒܸܣܡܵܐ ܡܫܝܼܚ ܠܵܗ̇ ܐܲܩܠܵܬ‌ܝܼ̈. ");
INSERT INTO aii_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","”ܒܘܼܬ ܐܵܗܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܘܼܟ݂ ܕܦܘܼܚܠܹܐ ܝܢܵܐ ܐܸܠܘܼܗ̇ ܚܛܝܼܵܬܘܼ̈ܗ̇ ܪܵܒܵܐ، ܣܵܒܵܒ ܡܘܼܚܸܒ ܠܵܗ̇ ܪܵܒܵܐ. ܐܝܼܢܵܐ ܗ̇ܘ ܕܒܵܨܘܿܪܵܐ ܦܵܐܹܫ ܫܒ݂ܝܼܩܵܐ ܐܸܠܹܗ، ܒܵܨܘܿܪܵܐ ܟܹܐ ܡܲܚܸܒ.“ ");
INSERT INTO aii_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ܘܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܠܗ̇ܝ ܒܲܟ݂ܬܵ‌ܐ: ”ܦܘܼܚܠܹܐ ܝܢܵܐ ܐܸܠܵܟ݂ܝ ܚܛܝܼܵܬܵܟ݂ܝ̈.“ ");
INSERT INTO aii_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ܐܝܼܢܵܐ ܐܵܢܝܼ ܕܝܼܗܘܵܘ ܝܬܝܼܒܹܐ ܥܲܡܹܗ ܫܘܼܪܹܐ ܠܗܘܿܢ ܠܹܐܡܵܪܵܐ ܒܓܵܢܵܝܗ‌ܝ: ”ܡܵܢܝܼ ܝܠܹܗ ܐܵܗܵܐ ܕܐܘܼܦ ܚܛܝܼܵܬܹ̈‌ܐ ܦܲܚܘܼܠܹܐ ܝܠܹܗ؟“ ");
INSERT INTO aii_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܠܗ̇ܝ ܒܲܟ݂ܬܵ‌ܐ: ”ܗܲܝܡܵܢܘܼܬܵܟ݂ܝ ܩܵܡ ܒܵܣܡܵܐ ܠܵܟ݂ܝ، ܙܹܠ݇ܝ ܒܫܠܵܡܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ܡ̣ܢ ܒܵܬܪ ܐܲܢܹܐ، ܒܸܚܕܵܪܵܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܓܵܘ ܡܕܝܼܢܵܬܹ̈‌ܐ ܘܓܵܘ ܡܵܬܘܵܬܹ̈‌ܐ، ܡܲܟܪܘܼܙܹܐ ܘܡܲܫܚܘܼܕܹܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ، ܘܬܪܸܥܣܲܪ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܥܲܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ܐܝܼܬ ܗܘܵܘ ܐܘܼܦ ܒܲܟ݂ܬܵܬܹ̈‌ܐ ܥܲܡܹܗ، ܐܵܢܝܼ ܕܦܝܼܫ ܠܗܘܿܢ ܒܣܝܼܡܹܐ ܡ̣ܢ ܡܲܪ̈ܥܹܐ ܘܡ̣ܢ ܪ̈ܘܼܚܹܐ ܒܝܼܫܹ̈ܐ؛ ܡܸܢܵܝܗ‌ܝ ܡܲܪܝܲܡ ܕܦܵܝܫܵܐ ܗܘܵܐ ܩܪܝܼܬܵ‌ܐ ܡܲܓ݂ܕܠܵܝܬܵ‌ܐ، ܗ̇ܝ ܕܫܲܒ݂ܥܵܐ ܫܹܐܕܹ̈ܐ ܦܘܼܠܸܛ ܠܹܗ ܡܸܢܘܼܗ̇ ܝܼܫܘܿܥ، ");
INSERT INTO aii_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ܘܝܘܿܚܲܢ ܒܲܟ݂ܬܵ‌ܐ ܕܟܘܼܙܵܐ ܪܲܒ ܒܲܝܬܵ‌ܐ ܕܗܹܪܘܿܕܸܣ، ܘܫܘܿܫܲܢ، ܘܪܵܒܵܐ ܒܲܟ݂ܬܵܬܹ̈‌ܐ ܐܚܹܪ̈ܢܹܐ، ܕܟܹܐ ܥܵܒ݂ܕܝܼ ܗܘܵܘ ܠܗܘܿܢ ܚܸܠܡܲܬ ܡ̣ܢ ܡܸܢܕܝܼ ܕܐܝܼܬ ܗܘܵܘ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ܟܲܕ ܓ̰ܡܝܼܥܹܐ ܝܗܘܵܘ ܠܟܸܣ ܝܼܫܘܿܥ ܟܸܢܫܹ̈ܐ ܪܵܒܵܐ، ܕܐܬܝܼܹܐ ܝܗܘܵܘ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܡܕܝܼܢܵܬܹ̈‌ܐ، ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܐܵܗܵܐ ܡܲܬܠܵܐ: ");
INSERT INTO aii_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","”ܦܠܝܼܛ ܠܹܗ ܚܲܕ ܙܵܪܥܵܢܵܐ ܠܸܙܪܵܥܵܐ ܒܲܪܙܲܪܥܵܐ. ܘܟܲܕ ܒܸܙܪܵܥܵܐ ܝܗܘܵܐ، ܐܝܼܬ ܗܘܵܐ ܕܢܦܝܼܠܔ ܠܹܗ ܥܲܠܔ ܡܲܪܙܵܐ ܕܐܘܼܪܚܵܐ، ܘܦܝܼܫ ܠܹܗ ܕܝܼܫܵܐ، ܘܠܩܝܼܛ ܠܗܘܿܢ ܐܸܠܹܗ ܛܲܝܪܹ̈ܐ ܕܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","”ܘܐܚܹܪܢܵܐ ܢܦܝܼܠܔ ܠܹܗ ܥܲܠܔ ܐܲܪܥܵܐ ܟܹܐܦܵܢܬܵ‌ܐ، ܘܡ̣ܢ ܒܵܬܪ ܕܡܘܼܓ̰ܝܸܢܹܗ ܒܪܝܼܙ ܠܹܗ، ܣܵܒܵܒ ܠܲܝܬ ܗܘܵܐ ܠܹܗ ܬܲܠܝܼܠܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","”ܘܐܚܹܪܢܵܐ ܢܦܝܼܠܔ ܠܹܗ ܓܵܘ ܟܸܬܘܹ̈ܐ، ܐܝܼܢܵܐ ܡܘܼܓ̰ܝܸܢܗܘܿܢ ܥܲܡܹܗ ܐܘܼܦ ܟܸܬܘܹ̈ܐ، ܘܚܢܝܼܩ ܠܗܘܿܢ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","”ܘܐܚܹܪܢܵܐ ܢܦܝܼܠܔ ܠܹܗ ܒܐܲܪܥܵܐ ܫܲܡܝܼܢܬܵ‌ܐ، ܡܘܼܓ̰ܝܸܢܹܗ ܘܥܒ݂ܝܼܕ ܠܹܗ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܚܲܕ ܒܡܵܐܐ.“ ܘܐܝܼܡܲܢ ܕܦܪܝܼܩ ܠܹܗ، ܐܡܝܼܪܹܗ: ”ܡ̇ܢ ܕܐܝܼܬ ܠܹܗ ܢܵܬܝܵܬܹ̈‌ܐ ܠܸܫܡܵܥܵܐ، ܫܵܡܹܥ.“ ");
INSERT INTO aii_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ܘܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܡܘܼܕܝܼ ܝܠܹܗ ܡܲܥܢܵܝܵܐ ܕܐܵܗܵܐ ܡܲܬܠܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܐܸܠܵܘܟ݂ܘܿܢ ܦܝܼܫܵܐ ܝܠܹܗ ܝܘܼܗܒ݂ܵܐ ܠܝܼܕܵܥܵܐ ܐܪ̈ܵܙܹܐ ܕܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ، ܐܝܼܢܵܐ ܠܐܚܹܪ̈ܢܹܐ ܒܡܲܬܠܹ̈ܐ ܟܹܐ ܗܲܡܙܸܡܸܢ، ܣܵܒܵܒ ܟܹܐ ܓܲܫܩܝܼ ܘܠܹܐ ܚܵܙܝܼ، ܘܟܹܐ ܫܵܡܥܝܼ ܘܠܹܐ ܦܲܪܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","”ܐܵܗܵܐ ܝܠܹܗ ܡܲܥܢܵܝܵܐ ܕܡܲܬܠܵܐ. ܒܲܪܙܲܪܥܵܐ ܗܹܡܸܙܡܵܢ ܕܐܲܠܵܗܵܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","”ܗ̇ܘ ܕܢܦܝܼܠܔ ܠܹܗ ܥܲܠܔ ܡܲܪܙܵܐ ܕܐܘܼܪܚܵܐ، ܐܵܢܝܼ ܝܢܵܐ ܕܟܹܐ ܫܵܡܥܝܼ. ܐܝܼܢܵܐ ܟܹܐ ܐܵܬܹ‌ܐ ܐܵܟܹܠܩܲܪܨܵܐ ܘܫܵܩܹܠܔ ܠܵܗ̇ ܗܹܡܸܙܡܵܢ ܡ̣ܢ ܠܸܒܵܝܗ‌ܝ، ܕܠܵܐ ܗܲܡܸܢܝܼ ܘܦܵܪܩܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","”ܘܗ̇ܘ ܕܢܦܝܼܠܔ ܠܹܗ ܥܲܠܔ ܐܲܪܥܵܐ ܟܹܐܦܵܢܬܵ‌ܐ، ܐܵܢܝܼ ܝܢܵܐ ܕܟܹܐ ܫܵܡܥܝܼ ܠܗܹܡܸܙܡܵܢ ܘܒܚܲܕܘܼܬܵ‌ܐ ܟܹܐ ܩܲܒܠܝܼ ܠܵܗ̇. ܐܝܼܢܵܐ ܠܲܝܬ ܠܗܘܿܢ ܥܸܩܪܵܐ، ܐܸܠܵܐ ܗܲܝܡܵܢܘܼܬܵܝܗ‌ܝ ܩܵܐ ܚܕܵܐ ܥܕܵܢܵܐ ܟܪܝܼܬܵ‌ܐ ܝܠܵܗ̇، ܘܐܝܼܡܲܢ ܕܐܵܬܹ‌ܐ ܓ̰ܘܼܪܵܒܵܐ ܟܹܐ ܩܵܠܒܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","”ܘܗ̇ܘ ܕܢܦܝܼܠܔ ܠܹܗ ܓܵܘ ܟܸܬܘܹ̈ܐ، ܐܵܢܝܼ ܝܢܵܐ ܕܟܹܐ ܫܵܡܥܝܼ، ܘܐܝܼܡܲܢ ܕܟܹܐ ܐܵܙܠ݇ܝܼ، ܪܸܢܝܵܐ ܘܕܵܘܸܠܬܵ‌ܐ ܘܫܲܗܘܲܬܝܵܬܹ̈‌ܐ ܕܐܲܢܹܐ ܚܲܝܹ̈ܐ ܟܹܐ ܚܵܢܩܝܼ ܠܗܘܿܢ، ܘܛܥܘܼܢܝܵܬܹ̈‌ܐ ܠܹܐ ܝܵܗܒ݂ܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","”ܐܝܼܢܵܐ ܗ̇ܘ ܕܢܦܝܼܠܔ ܠܹܗ ܒܐܲܪܥܵܐ ܫܲܡܝܼܢܬܵ‌ܐ، ܐܵܢܝܼ ܝܢܵܐ ܕܒܠܸܒܵܐ ܨܸܦܝܵܐ ܘܛܵܒ݂ܵܐ ܟܹܐ ܫܵܡܥܝܼ ܠܗܹܡܸܙܡܵܢ ܘܢܵܛܪܝܼ ܠܵܗ̇، ܘܟܹܐ ܝܵܗܒ݂ܝܼ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܒܚܡܵܠܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","”ܐܢܵܫܵܐ ܠܹܐ ܡܲܠܗܹܐ ܫܪܵܓ݂ܵܐ ܘܟܲܣܹܐ ܠܵܗ̇ ܒܡܵܐܢܵܐ ܝܲܢ ܡܲܬܸܒ݂ ܠܵܗ̇ ܬܚܘܿܬ ܫܘܝܼܬܵ‌ܐ، ܐܸܠܵܐ ܟܹܐ ܡܲܬܸܒ݂ ܠܵܗ̇ ܥܲܠܔ ܡܢܵܪܬܵ‌ܐ ܕܟܠܔ ܥܵܒ݂ܪܵܢܵܐ ܚܵܙܹܐ ܒܲܗܪܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","”ܣܵܒܵܒ ܠܲܝܬ ܡܸܢܕܝܼ ܡܘܼܟܣܵܐ ܕܠܵܐ ܦܵܐܹܫ ܓܸܠܝܵܐ، ܘܠܵܐ ܛܸܫܝܵܐ ܕܠܵܐ ܦܵܐܹܫ ܝܕܝܼܥܵܐ ܘܦܵܠܹܛ ܠܒܲܗܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","”ܒܘܼܬ ܐܵܗܵܐ ܚܙܹܝܡܘܼܢ ܕܵܐܟ݂ܝܼ ܫܵܡܥܝܼܬܘܿܢ، ܣܵܒܵܒ ܡ̇ܢ ܕܐܝܼܬ ܠܹܗ ܒܸܬ ܦܵܐܹܫ ܝܘܼܗܒ݂ܵܐ ܙܵܘܕܵܐ ܐܸܠܹܗ، ܘܡ̇ܢ ܕܠܲܝܬ ܠܹܗ ܐܘܼܦ ܗ̇ܘ ܕܚܵܫܹܒ݂ ܐܝܼܬ ܠܹܗ ܒܸܬ ܦܵܐܹܫ ܫܩܝܼܠܵܐ ܡܸܢܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣ ܝܼܫܘܿܥ ܝܸܡܹܗ ܘܐܲܚܘܿܢܘܵܬܘܼ̈ܗ‌ܝ، ܐܝܼܢܵܐ ܠܵܐ ܡܨܹܐ ܠܗܘܿܢ ܡܵܛܝܼ ܠܟܸܣܠܹܗ ܣܵܒܵܒ ܟܸܢܫܵܐ ܪܵܒܵܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܗܵܐ ܝܸܡܘܼܟ݂ ܘܐܲܚܘܿܢܘܵܬܘܼ̈ܟ݂ ܟܸܠܝܹܐ ܝܢܵܐ ܠܒܲܕܲܪ ܘܒܵܥܝܼ ܕܚܵܙܝܼ ܠܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ܘܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܐܲܢܹܐ ܝܢܵܐ ܝܸܡܝܼ ܘܐܲܚܘܿܢܘܵܬ‌ܝܼ̈، ܐܵܢܝܼ ܕܫܵܡܥܝܼ ܗܹܡܸܙܡܵܢ ܕܐܲܠܵܗܵܐ ܘܢܵܛܪܝܼ ܠܵܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ܒܚܲܕ ܡ̣ܢ ܝܵܘܡܵܢܹ̈ܐ ܐܣܝܼܩ ܠܹܗ ܝܼܫܘܿܥ ܠܓܵܡܝܼ ܥܲܡ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܛܪܹܝܡܘܼܢ ܕܥܵܒ݂ܪܲܚ ܠܗ̇ܘ ܡܲܪܙܵܐ ܐܚܹܪܢܵܐ ܕܝܵܡܵܐ.“ ܘܛܪܹܐ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ܘܟܲܕ ܒܸܛܪܵܝܵܐ ܝܗܘܵܘ، ܕܡܝܼܟ݂ ܠܹܗ ܝܼܫܘܿܥ. ܗܘܹܐ ܠܵܗ̇ ܒܘܼܪܲܢ ܕܦܵܘܚܵܐ ܒܝܵܡܵܐ، ܘܩܘܼܪܒܸܢܵܗ̇ ܓܵܡܝܼ ܠܸܡܠܵܝܵܐ ܡ̈ܝܼܵܐ، ܘܗܘܹܐ ܠܗܘܿܢ ܓܵܘ ܩܹܘܲܢܕܹܢܘܿܣ ܓܘܼܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ܡܘܼܪܥܸܫ ܠܗܘܿܢ ܐܸܠܹܗ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܒܹܐܡܵܪܵܐ: ”ܪܲܒܝܼ، ܪܲܒܝܼ، ܒܸܛܠܵܩܵܐ ܝܘܲܚ.“ ܩܝܼܡ ܠܹܗ ܘܢܓ̰ܝܼܘ ܠܹܗ ܒܦܵܘܚܹ̈ܐ ܘܒܠܲܦܹ̈ܐ ܕܡ̈ܝܼܵܐ، ܘܟܠܹܐ ܠܗܘܿܢ. ܘܗܘܹܐ ܠܵܗ̇ ܫܸܠܝܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܐܲܝܟܵܐ ܝܠܵܗ̇ ܗܲܝܡܵܢܘܼܬܵܘܟ݂ܘܿܢ؟“ ܘܐܵܢܝܼ ܒܸܙܕܵܥܵܐ، ܥܲܓ̰ܒܝܼ ܗܘܵܘ ܘܐܵܡܪܝܼ ܗܘܵܘ ܚܲܕ ܠܗ̇ܘ ܐܚܹܪܢܵܐ: ”ܡܵܢܝܼ ܝܠܹܗ ܐܵܗܵܐ ܕܐܘܼܦ ܠܦܵܘܚܹ̈ܐ ܘܠܲܦܹ̈ܐ ܘܠܝܵܡܵܐ ܒܸܦܩܵܕܵܐ ܝܠܹܗ ܘܒܸܫܡܵܥܵܐ ܝܢܵܐ ܐܸܠܹܗ؟“ ");
INSERT INTO aii_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ܛܪܹܐ ܠܗܘܿܢ ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܠܐܲܬܪܵܐ ܕܓܸܕܪ̈ܵܝܹܐ، ܕܝܼܠܹܗ ܠܡܲܪܙܵܐ ܐܚܹܪܢܵܐ ܠܒܲܠܩܘܼܒ݂ܠܔ ܕܓܠܝܼܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ܘܐܝܼܡܲܢ ܕܦܠܝܼܛ ܠܹܗ ܠܒܸܪܙܵܐ، ܬܦܝܼܩ ܠܹܗ ܒܝܼܹܗ ܚܲܕ ܐܢܵܫܵܐ ܡ̣ܢ ܡܕܝܼܢ݇ܬܵ‌ܐ ܗ̇ܘ ܕܐܝܼܬ ܗܘܵܐ ܒܝܼܹܗ ܫܹܐܕܵܐ ܡ̣ܢ ܥܕܵܢܵܐ ܪܵܒܵܐ. ܠܹܐ ܠܵܒܹܫ ܗܘܵܐ ܓ̰ܘܼܠܹ̈ܐ، ܘܠܹܐ ܥܵܡܹܪ ܗܘܵܐ ܒܒܲܝܬܵ‌ܐ، ܐܸܠܵܐ ܟܹܐ ܚܵܝܹܐ ܗܘܵܐ ܓܵܘ ܒܹܝܬ ܩܒ݂ܘܼܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܹܗ ܠܝܼܫܘܿܥ، ܢܦܝܼܠܔ ܠܹܗ ܩܲܕܡܘܼܗ‌ܝ ܘܡܘܼܩܘܸܚ ܠܹܗ ܒܩܵܠܵܐ ܪܵܡܵܐ ܘܐܡܝܼܪܹܗ: ”ܡܵܐ ܠܘܼܟ݂ ܡܸܢܝܼ، ܝܵܐ ܝܼܫܘܿܥ ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ ܥܸܠܵܝܵܐ؟ ܦܲܪܦܘܼܠܹܐ ܝܘܸܢ ܒܝܼܘܼܟ݂، ܠܵܐ ܓ̰ܲܢܓ̰ܸܪܸܬ ܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ܣܵܒܵܒ ܦܩܝܼܕ ܠܹܗ ܝܼܫܘܿܥ ܠܪܘܼܚܵܐ ܛܲܡܐܹܐ ܕܦܵܠܛܵܐ ܡܸܢܹܗ، ܗ̇ܝ ܕܟܹܐ ܕܵܒ݂ܩܵܐ ܗܘܵܐ ܠܹܗ ܪܵܒܵܐ ܓܵܗܹ̈ܐ، ܘܟܹܐ ܦܵܐܹܫ ܗܘܵܐ ܢܛܝܼܪܵܐ ܘܐܣܝܼܪܵܐ ܒܩܵܘܕܹ̈ܐ ܘܒܫܸܫܠܵܬܹ̈‌ܐ، ܐܝܼܢܵܐ ܟܹܐ ܩܵܛܹܥ ܗܘܵܐ ܠܐܸܣܘܼܪ̈ܘܼܗ‌ܝ، ܘܟܹܐ ܦܵܐܹܫ ܗܘܵܐ ܠܘܼܒܠܵܐ ܒܝܲܕ ܫܹܐܕܵܐ ܠܒܲܪܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ܒܘܼܩܸܪܹܗ ܡܸܢܹܗ ܝܼܫܘܿܥ: ”ܡܘܼܕܝܼ ܝܠܹܗ ܫܸܡܘܼܟ݂؟“ ܘܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ: ”ܠܸܓ݂ܝܘܿܢ.“ ܣܵܒܵܒ ܪܵܒܵܐ ܫܹܐܕܹ̈ܐ ܥܒ݂ܝܼܪܹܐ ܝܗܘܵܘ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ܘܛܠܝܼܒ ܠܗܘܿܢ ܡܸܢܹܗ ܕܠܵܐ ܦܵܩܹܕ ܠܗܘܿܢ ܕܐܵܙܠ݇ܝܼ ܠܥܘܼܡܩܵܐ ܕܠܵܐ ܬܝܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ܐܝܼܬ ܗܘܵܐ ܬܵܡܵܐ ܒܸܩܪܵܐ ܓܘܼܪܬܵ‌ܐ ܕܚܙܘܼܪܹ̈ܐ ܒܸܪܥܵܝܵܐ ܒܛܘܼܪܵܐ. ܛܠܝܼܒ ܠܗܘܿܢ ܡܸܢܹܗ ܐܵܢܝܼ ܫܹܐܕܹ̈ܐ ܕܝܵܗܒܹܠܔ ܠܗܘܿܢ ܦܣܵܣܵܐ ܕܥܵܒ݂ܪܝܼ ܓܵܘ ܚܙܘܼܪܹ̈ܐ. ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ܘܦܠܝܼܛ ܠܗܘܿܢ ܫܹܐܕܹ̈ܐ ܡ̣ܢ ܗ̇ܘ ܐܢܵܫܵܐ ܘܥܒ݂ܝܼܪܗܘܿܢ ܓܵܘ ܚܙܘܼܪܹ̈ܐ، ܘܪܚܝܼܛ ܠܵܗ̇ ܗ̇ܝ ܒܸܩܪܵܐ ܠܫܸܢܵܐ ܘܠܬܸܚܬ ܒܝܵܡܵܐ، ܘܚܢܝܼܩ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܗܘܿܢ ܪ̈ܵܥܝܹܐ ܡܸܢܕܝܼ ܕܗܘܹܐ ܠܹܗ، ܪܚܝܼܛ ܠܗܘܿܢ ܘܗܘܼܩܹܐ ܠܗܘܿܢ ܓܵܘ ܡܕܝܼܢ݇ܬܵ‌ܐ ܘܓܵܘ ܡܵܬܘܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ܘܦܠܝܼܛ ܠܗܘܿܢ ܐܢܵܫܹ̈ܐ ܕܚܵܙܝܼ ܗܘܵܘ ܡܸܢܕܝܼ ܕܗܘܹܐ ܠܹܗ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣ ܝܼܫܘܿܥ، ܘܚܙܹܐ ܠܗܘܿܢ ܠܗ̇ܘ ܐܢܵܫܵܐ ܕܦܠܝܼܛ ܠܗܘܿܢ ܡܸܢܹܗ ܫܹܐܕܹ̈ܐ، ܠܒ݂ܝܼܫܵܐ ܘܗܵܘܢܹܗ ܒܪܹܝܫܹܗ ܘܝܬܝܼܒ݂ܵܐ ܠܟܸܣ ܐܲܩܠܵܬܹ̈‌ܐ ܕܝܼܫܘܿܥ، ܘܙܕܝܼܥ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ܘܐܵܢܝܼ ܕܚܙܹܐ ܠܗܘܿܢ ܗܘܼܩܹܐ ܠܗܘܿܢ ܐܸܠܵܝܗ‌ܝ ܕܵܐܟ݂ܝܼ ܦܝܼܫ ܠܹܗ ܒܣܝܼܡܵܐ ܗ̇ܘ ܕܐܝܼܬ ܗܘܵܐ ܒܝܼܹܗ ܫܹܐܕܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ܘܛܠܝܼܒ ܠܗܘܿܢ ܡܸܢܹܗ ܟܠܵܝܗ‌ܝ ܐܢܵܫܹ̈ܐ ܕܐܲܬܪܵܐ ܕܓܸܕܪ̈ܵܝܹܐ ܕܐܵܙܹܠܔ ܗܘܵܐ ܡ̣ܢ ܠܟܸܣܠܵܝܗ‌ܝ، ܣܵܒܵܒ ܙܕܘܼܥܬܵ‌ܐ ܓܘܼܪܬܵ‌ܐ ܕܒ݂ܝܼܩܵܝ ܠܵܗ̇. ܘܗ̇ܘ ܐܣܝܼܩ ܠܹܗ ܠܓܵܡܝܼ ܘܕܝܼܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ܗ̇ܘ ܐܢܵܫܵܐ ܕܦܠܝܼܛ ܠܗܘܿܢ ܡܸܢܹܗ ܫܹܐܕܹ̈ܐ ܛܠܝܼܒ ܠܹܗ ܡܸܢܹܗ ܕܦܵܐܹܫ ܗܘܵܐ ܥܲܡܹܗ. ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܐܡܝܼܪܹܗ ܐܸܠܹܗ: ");
INSERT INTO aii_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","”ܕܘܼܪ ܠܒܲܝܬܘܼܟ݂ ܘܗܲܩܝܼ ܡܘܼܕܝܼ ܥܒ݂ܝܼܕ ܠܹܗ ܐܸܠܘܼܟ݂ ܐܲܠܵܗܵܐ.“ ܘܗ̇ܘ ܐܙܝܼܠܔ ܠܹܗ ܘܗܘܼܩܹܐ ܠܹܗ ܒܟܠܵܗ̇ ܡܕܝܼܢ݇ܬܵ‌ܐ ܡܸܢܕܝܼ ܕܥܒ݂ܝܼܕ ܠܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ܐܝܼܡܲܢ ܕܕܝܼܪܹܗ ܝܼܫܘܿܥ، ܩܘܼܒܸܠܔ ܠܹܗ ܐܸܠܹܗ ܟܸܢܫܵܐ ܪܵܒܵܐ، ܣܵܒܵܒ ܟܠܵܝܗ‌ܝ ܒܸܣܦܵܪܵܐ ܝܗܘܵܘ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ܘܐܬܹ‌ܐ ܠܹܗ ܚܲܕ ܐܢܵܫܵܐ ܫܸܡܹܗ ܝܘܿܐܵܪܵܫ، ܓܘܼܪܵܐ ܕܟܢܘܼܫܬܵ‌ܐ، ܘܢܦܝܼܠܔ ܠܹܗ ܩܲܕܡ ܐܲܩܠܵܬܹ̈‌ܐ ܕܝܼܫܘܿܥ ܘܛܠܝܼܒ ܠܹܗ ܡܸܢܹܗ ܕܥܵܒܹܪ ܗܘܵܐ ܠܒܲܝܬܹܗ، ");
INSERT INTO aii_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ܣܵܒܵܒ ܐܝܼܬ ܗܘܵܐ ܠܹܗ ܒܪܵܬܵ‌ܐ ܝܼܚܝܼܕܵܝܬܵ‌ܐ ܒܵܬܪ ܬܪܸܥܣܲܪ ܫܸܢܹ̈ܐ ܘܩܘܼܪܒܸܢܬܵ‌ܐ ܝܗܘܵܐ ܠܸܡܝܵܬܵ‌ܐ. ܘܟܲܕ ܝܼܫܘܿܥ ܒܹܐܙܵܠܵܐ ܝܗܘܵܐ، ܟܸܢܫܵܐ ܪܵܒܵܐ ܒܸܚܠܵܨܵܐ ܝܗܘܵܐ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ܘܐܝܼܬ ܗܘܵܐ ܚܕܵܐ ܒܲܟ݂ܬܵ‌ܐ ܕܝܼܗܘܵܐ ܒܹܐܙܵܠܵܐ ܕܸܡܵܐ ܡܸܢܘܼܗ̇ ܩܵܐ ܬܪܸܥܣܲܪ ܫܸܢܹ̈ܐ، ܘܚܘܼܪܸܓ̰ܬܵ‌ܐ ܝܗܘܵܐ ܟܠܹܗ ܡܸܢܕܝܼܘܼܗ̇ ܩܵܐ ܐܵܣܝܹ̈ܐ، ܘܐܘܼܦ ܚܲܕ ܠܹܐ ܝܗܘܵܐ ܡܸܨܝܵܐ ܠܒܲܣܘܼܡܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ܩܘܼܪܒܸܢܵܗ̇ ܡ̣ܢ ܒܵܬܪ ܚܲܨܵܐ ܕܝܼܫܘܿܥ ܘܕܩܝܼܪܵܗ̇ ܒܫܸܦܘܼܠܵܐ ܕܠܒ݂ܝܼܫܬܹܗ، ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܟܠܹܐ ܠܵܗ̇ ܓ̰ܪܵܝܬܵ‌ܐ ܕܕܸܡܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ܘܐܡܝܼܪܹܗ ܝܼܫܘܿܥ: ”ܡܵܢܝܼ ܕܩܝܼܪܹܗ ܒܝܼܝܼ؟“ ܘܟܠܵܝܗ‌ܝ ܣܪܝܼܒ݂ ܠܗܘܿܢ ܠܕܩܵܪܬܵ‌ܐ ܕܒܝܼܹܗ. ܐܝܼܢܵܐ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܘܐܵܢܝܼ ܕܥܲܡܹܗ ܐܡܝܼܪܗܘܿܢ: ”ܪܲܒܝܼ، ܟܸܢܫܹ̈ܐ ܡܲܠܝܘܼܨܘܼܟ݂ ܝܼܢܵܐ ܘܒܸܚܠܵܨܘܼܟ݂، ܘܐܲܢ݇ܬ ܒܹܐܡܵܪܵܐ ܝܘܸܬ: ’ܡܵܢܝܼ ܕܩܝܼܪܹܗ ܒܝܼܝܼ؟‘“ ");
INSERT INTO aii_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܐܡܝܼܪܹܗ: ”ܚܲܕ ܕܩܝܼܪܹܗ ܒܝܼܝܼ، ܣܵܒܵܒ ܐܵܢܵܐ ܝܕܝܼܥ ܠܝܼ ܚܲܝܠܵܐ ܦܠܝܼܛ ܠܹܗ ܡܸܢܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ܗ̇ܝ ܒܲܟ݂ܬܵ‌ܐ، ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܵܗ̇ ܕܠܹܐ ܡܵܨܝܵܐ ܗܘܵܐ ܛܲܫܝܵܐ ܓܵܢܘܼܗ̇ ܡܸܢܹܗ، ܐܬܹ‌ܐ ܠܵܗ̇ ܒܸܪܓܵܕܵܐ ܘܢܦܝܼܠܔ ܠܵܗ̇ ܩܲܕܡܘܼܗ‌ܝ ܘܐܡܝܼܪܵܗ̇ ܩܲܕܡ ܟܠܹܗ ܟܸܢܫܵܐ ܩܵܡܘܿܕܝܼ ܕܩܝܼܪܵܗ̇ ܒܝܼܹܗ ܘܕܵܐܟ݂ܝܼ ܒܓ̰ܲܠܕܘܼܬܵ‌ܐ ܒܣܝܼܡ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇ ܝܼܫܘܿܥ: ”ܦܘܼܫܝ ܠܸܒܵܢܬܵ‌ܐ ܒܪܵܬ‌ܝܼ، ܗܲܝܡܵܢܘܼܬܵܟ݂ܝ ܩܵܡ ܒܵܣܡܵܐ ܠܵܟ݂ܝ، ܙܹܠ݇ܝ ܒܫܠܵܡܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ܘܗܸܫ ܝܼܫܘܿܥ ܗܲܡܙܘܼܡܹܐ، ܐܬܹ‌ܐ ܠܹܗ ܐܢܵܫܵܐ ܡ̣ܢ ܒܲܝܬܵ‌ܐ ܕܓܘܼܪܵܐ ܕܟܢܘܼܫܬܵ‌ܐ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܒܪܵܬܘܼܟ݂ ܡܝܼܬ ܠܵܗ̇، ܠܵܐ ܥܲܓ̰ܸܙ ܠܡܲܠܦܵܢܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܹܗ ܝܼܫܘܿܥ، ܐܡܝܼܪܹܗ ܠܒܵܒܵܐ ܕܒܪܵܬܵ‌ܐ: ”ܠܵܐ ܙܵܕܥܹܬ، ܐܸܠܵܐ ܗܲܡܸܢ ܘܒܸܬ ܚܵܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ܘܥܒ݂ܝܼܪܹܗ ܠܒܲܝܬܵ‌ܐ، ܘܠܵܐ ܫܒ݂ܝܼܩ ܠܹܗ ܕܥܵܒܹܪ ܥܲܡܹܗ ܐܢܵܫܵܐ ܫܒ݂ܘܿܩ ܡ̣ܢ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܘܝܲܥܩܘܿܒ݂ ܘܝܘܿܚܲܢܵܢ، ܘܒܵܒܵܐ ܘܝܸܡܵܐ ܕܒܪܵܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ܘܟܠܵܝܗ‌ܝ ܒܸܒܟ݂ܵܝܵܐ ܝܗܘܵܘ ܘܒܸܥܒ݂ܵܕܵܐ ܬܵܥܙܝܼ ܥܲܠܘܼܗ̇. ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܐܸܠܵܝܗ‌ܝ: ”ܠܵܐ ܒܵܟܹܝܬܘܿܢ، ܣܵܒܵܒ ܠܹܐ ܝܠܵܗ̇ ܡܝܼܬܬܵ‌ܐ ܐܸܠܵܐ ܕܡܝܼܟ݂ܬܵ‌ܐ ܝܠܵܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ܘܓܚܝܼܟ ܠܗܘܿܢ ܒܝܼܹܗ ܣܵܒܵܒ ܒܝܼܕܵܥܵܐ ܝܗܘܵܘ ܕܡܝܼܬܬܵ‌ܐ ܝܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ܦܘܼܠܸܛ ܠܹܗ ܝܼܫܘܿܥ ܠܟܠܵܝܗ‌ܝ ܠܒܲܕܲܪ، ܘܕܒ݂ܝܼܩ ܠܹܗ ܒܐܝܼܕܵܐ ܕܒܪܵܬܵ‌ܐ ܘܩܸܪܝܵܐ ܠܹܗ ܘܐܡܝܼܪܹܗ: ”ܒܪܵܬܵ‌ܐ، ܩܘܼܡܝ.“ ");
INSERT INTO aii_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ܘܕܝܼܪܵܗ̇ ܪܘܼܚܘܼܗ̇، ܘܩܝܼܡ ܠܵܗ̇ ܒܗ̇ܝ ܥܕܵܢܵܐ. ܘܦܩܝܼܕ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܕܝܵܗܒ݂ܝܼ ܗܘܵܘ ܠܵܗ̇ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ ܠܹܐܟ݂ܵܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ܘܥܘܼܓ̰ܸܒ ܠܗܘܿܢ ܐܲܒ݂ܵܗܘܼ̈ܗ̇. ܐܝܼܢܵܐ ܗ̇ܘ ܦܩܝܼܕܵܝ ܠܹܗ ܕܠܵܐ ܐܵܡܪܝܼ ܠܐܢܵܫܵܐ ܡܸܢܕܝܼ ܕܗܘܹܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ܩܪܹܐ ܠܹܗ ܝܼܫܘܿܥ ܠܬܪܸܥܣܲܪ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܚܲܝܠܵܐ ܘܫܘܼܠܛܵܢܵܐ ܥܲܠܔ ܟܠܵܝܗ‌ܝ ܫܹܐܕܹ̈ܐ ܘܠܒܲܣܘܼܡܹܐ ܡܲܪ̈ܥܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ܫܘܼܕܪܵܝ ܠܹܗ ܠܡܲܟܪܘܼܙܹܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ ܘܠܒܲܣܘܼܡܹܐ ܡܪ̈ܝܼܥܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܡܸܢܕܝܼ ܠܵܐ ܫܵܩܠܝܼܬܘܿܢ ܒܐܘܼܪܚܵܐ، ܠܵܐ ܚܘܼܛܪܵܐ، ܘܠܵܐ ܬܲܪܡܵܠܵܐ، ܘܠܵܐ ܠܲܚܡܵܐ ܘܠܵܐ ܙܘܼܙܹ̈ܐ، ܘܠܵܐ ܗܵܘܹܐ ܠܵܘܟ݂ܘܿܢ ܬܲܪܬܹܝ ܨܘܼܕܪ̈ܵܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","”ܘܠܒܲܝܬܵ‌ܐ ܕܥܵܒ݂ܪܝܼܬܘܿܢ ܓܵܘܹܗ، ܦܘܼܫܘܼܢ ܬܵܡܵܐ، ܗܲܠܔ ܕܦܵܠܛܝܼܬܘܿܢ ܡ̣ܢ ܬܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","”ܘܐܸܢ ܐܢܵܫܹ̈ܐ ܠܵܐ ܩܲܒܠܝܼ ܠܵܘܟ݂ܘܿܢ، ܐܝܼܡܲܢ ܕܦܵܠܛܝܼܬܘܿܢ ܡ̣ܢ ܗ̇ܝ ܡܕܝܼܢ݇ܬܵ‌ܐ، ܐܘܼܦ ܬܵܘܙ ܡ̣ܢ ܐܲܩܠܵܬܵܘ̈ܟ݂ܘܿܢ ܢܵܦܨܝܼܬܘܿܢ ܠܵܗ̇ ܠܣܵܗܕܘܼܬܵ‌ܐ ܥܲܠܵܝܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ܘܦܠܝܼܛ ܠܗܘܿܢ ܫܠܝܼܚܹ̈ܐ، ܒܸܚܕܵܪܵܐ ܡ̣ܢ ܡܵܬܵ‌ܐ ܠܡܵܬܵ‌ܐ، ܡܲܟܪܘܼܙܹܐ ܘܒܲܣܘܼܡܹܐ ܒܟܠܔ ܕܘܼܟܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܹܗ ܗܹܪܘܿܕܸܣ ܛܸܛܪܲܪܟܵܐ ܟܠܵܝܗ‌ܝ ܐܲܢܹܐ، ܫܓ݂ܝܼܫ ܠܗܘܿܢ ܚܘܼܫܵܒ݂ܘܼ̈ܗ‌ܝ ܣܵܒܵܒ ܐܢܵܫܹ̈ܐ ܐܵܡܪܝܼ ܗܘܵܘ: ”ܐܵܗܵܐ ܝܘܿܚܲܢܵܢ ܝܼܠܹܗ، ܩܝܼܡܵܐ ܝܠܹܗ ܡ̣ܢ ܓܵܘ ܡܝܼ̈ܬܹ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ܘܐܚܹܪ̈ܢܹܐ ܐܵܡܪܝܼ ܗܘܵܘ ܕܐܹܠܝܼܵܐ ܦܝܼܫ ܠܹܗ ܚܸܙܝܵܐ، ܘܐܚܹܪ̈ܢܹܐ ܐܵܡܪܝܼ ܗܘܵܘ، ܐܵܗܵܐ ܝܠܹܗ ܢܒ݂ܝܼܵܐ ܡ̣ܢ ܢܒ݂ܝܼܹ̈ܐ ܩܲܕܡܵܝܹ̈ܐ ܕܩܝܼܡܵܐ ܝܠܹܗ ܡ̣ܢ ܓܵܘ ܡܝܼ̈ܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ܐܡܝܼܪܹܗ ܗܹܪܘܿܕܸܣ: ”ܪܹܝܫܵܐ ܕܝܘܿܚܲܢܵܢ ܐܵܢܵܐ ܦܪܝܼܡ ܠܝܼ، ܘܡܵܢܝܼ ܝܠܹܗ ܐܵܗܵܐ ܕܒܸܫܡܵܥܵܝ ܝܘܸܢ ܐܲܢܹܐ ܒܘܼܬ ܕܝܼܹܗ؟“ ܘܒܵܥܹܐ ܗܘܵܐ ܕܚܵܙܹܐ ܗܘܵܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ܘܕܝܼܪܗܘܿܢ ܫܠܝܼܚܹ̈ܐ ܘܗܘܼܩܹܐ ܠܗܘܿܢ ܠܝܼܫܘܿܥ ܟܠܔ ܡܸܢܕܝܼ ܕܥܒ݂ܝܼܕ ܠܗܘܿܢ. ܘܠܘܼܒܠܵܝ ܠܹܗ ܝܼܫܘܿܥ ܒܢܲܦ̮ܫܵܝܗ‌ܝ ܠܚܕܵܐ ܡܕܝܼܢ݇ܬܵ‌ܐ ܕܟܹܐ ܦܵܝܫܵܐ ܩܪܝܼܬܵ‌ܐ ܒܹܝܬ ܨܲܝܵܕܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ܝܕܝܼܥ ܠܗܘܿܢ ܟܸܢܫܹ̈ܐ ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܒܵܬܪܹܗ. ܘܩܘܼܒܠܵܝ ܠܹܗ، ܘܗܲܡܙܸܡ ܗܘܵܐ ܥܲܡܵܝܗ‌ܝ ܒܘܼܬ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ. ܘܐܵܢܝܼ ܕܝܼܗܘܵܘ ܣܢܝܼܩܹܐ ܠܒܲܣܲܡܬܵ‌ܐ ܒܘܼܣܡܵܝ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ܘܟܲܕ ܩܘܼܪܒܸܢܹܗ ܝܵܘܡܵܐ ܠܸܓܢܵܝܵܐ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܐܡܝܼܪܗܘܿܢ ܠܝܼܫܘܿܥ: ”ܫܪܝܼ ܠܟܸܢܫܹ̈ܐ ܕܐܵܙܠ݇ܝܼ ܠܡܵܬܘܵܬܹ̈‌ܐ ܘܠܟܲܦܪ̈ܘܼܢܹܐ ܕܚܵܕܸܪ̈ܘܵܢܲܢ، ܕܫܵܪܝܼ ܓܵܘܵܝܗ‌ܝ، ܘܡܲܫ݇ܟ̰ܚܝܼ ܠܗܘܿܢ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ، ܣܵܒܵܒ ܒܕܘܼܟܵܐ ܒܲܪܝܼܵܐ ܝܘܲܚ.“ ");
INSERT INTO aii_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܗܲܒ݂ܠܘܼܢ ܠܗܘܿܢ ܐܲܚܬܘܿܢ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ.“ ܘܐܵܢܝܼ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ: ”ܠܲܝܬ ܠܲܢ ܙܵܘܕܵܐ ܡ̣ܢ ܚܲܡܫܵܐ ܠܲܚܡܹ̈ܐ ܘܬܪܹܝ ܢܘܼܢܹ̈ܐ، ܐܸܠܵܐ ܕܐܵܙܲܠ݇ܚ ܘܙܵܒ݂ܢܲܚ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ ܩܵܐ ܟܠܹܗ ܐܵܗܵܐ ܛܵܝܸܦܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ܐܝܼܬ ܗܘܵܐ ܬܵܡܵܐ ܡܐܲܝܟ݂ ܚܲܡܫܵܐ ܐܲܠܦܹ̈ܐ ܐܢܵܫܹ̈ܐ، ܘܐܡܝܼܪܹܗ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܡܲܬܒ݂ܘܼܢ ܠܗܘܿܢ ܒܣܝܼܥܵܬܹ̈‌ܐ، ܚܲܡܫܝܼ ܒܟܠܔ ܣܝܼܥܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ܘܥܒ݂ܝܼܕ ܠܗܘܿܢ ܗܵܕܟ݂ܵܐ ܬܲܠܡܝܼ̈ܕܹܐ، ܘܡܘܼܬܸܒ݂ ܠܗܘܿܢ ܠܟܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ܘܫܩܝܼܠܔ ܠܹܗ ܝܼܫܘܿܥ ܐܵܢܝܼ ܚܲܡܫܵܐ ܠܲܚܡܹ̈ܐ ܘܬܪܹܝ ܢܘܼܢܹ̈ܐ، ܚܝܼܪܹܗ ܠܫܡܲܝܵܐ ܘܒܘܼܪܸܟ݂ ܠܹܗ ܘܩܨܹܐ ܠܹܗ ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ܘܐܵܢܝܼ ܡܘܼܬܸܒ݂ ܠܗܘܿܢ ܩܲܕܡ ܟܸܢܫܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ܘܐܟ݂ܝܼܠܔ ܠܗܘܿܢ ܟܠܵܝܗ‌ܝ ܘܣܒ݂ܝܼܥ ܠܗܘܿܢ، ܘܫܩܝܼܠܔ ܠܗܘܿܢ ܩܸܛܥܵܛܹ̈ܐ ܕܙܝܼܕ ܠܗܘܿܢ، ܬܪܸܥܣܲܪ ܩܘܼܦܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ܗܘܹܐ ܠܵܗ̇ ܟܲܕ ܨܲܠܘܼܝܹܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܒܢܲܦ̮ܫܹܗ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ. ܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ: ”ܡܵܢܝܼ ܟܹܐ ܐܵܡܪܝܼ ܟܸܢܫܹ̈ܐ ܕܐܵܢܵܐ ܝܼܘܸܢ؟“ ");
INSERT INTO aii_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܘܐܡܝܼܪܗܘܿܢ: ”ܟܹܐ ܐܵܡܪܝܼ ܕܐܲܢ݇ܬ ܝܼܘܸܬ ܝܘܿܚܲܢܵܢ ܡܲܥܡܕܵܢܵܐ، ܘܐܚܹܪ̈ܢܹܐ ܟܹܐ ܐܵܡܪܝܼ ܐܹܠܝܼܵܐ ܝܘܸܬ، ܘܐܚܹܪ̈ܢܹܐ ܟܹܐ ܐܵܡܪܝܼ ܚܲܕ ܡ̣ܢ ܢܒ݂ܝܼܹ̈ܐ ܩܲܕܡܵܝܹ̈ܐ ܩܝܼܡܵܐ ܝܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ܐܝܼܢܵܐ ܗ̇ܘ ܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ: ”ܘܐܲܚܬܘܿܢ، ܡܵܢܝܼ ܒܹܐܡܵܪܵܐ ܝܬܘܿܢ ܕܐܵܢܵܐ ܝܼܘܸܢ؟“ ܓ̰ܘܼܘܸܒ ܠܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܘܐܡܝܼܪܹܗ: ”ܐܲܢ݇ܬ ܝܼܘܸܬ ܡܫܝܼܚܵܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܦܩܝܼܕܵܝ ܠܹܗ ܕܠܐܢܵܫܵܐ ܠܵܐ ܐܵܡܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܐܵܢܲܢܩܵܝܬܵ‌ܐ ܝܠܵܗ̇ ܕܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܩܲܒܸܠܔ ܪܵܒܵܐ ܚܲܫܵܐ ܘܦܵܐܹܫ ܡܘܼܣܠܝܼܵܐ ܡ̣ܢ ܚܘܵܪ̈ܕܸܩܢܹܐ ܘܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܣܵܦܪܹ̈ܐ. ܒܸܬ ܩܵܛܠܝܼ ܠܹܗ ܘܒܝܵܘܡܵܐ ܕܬܠܵܬܵ‌ܐ ܒܸܬ ܩܵܐܹܡ.“ ");
INSERT INTO aii_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ܘܐܡܝܼܪܹܗ ܠܟܠܵܝܗ‌ܝ: ”ܡ̇ܢ ܕܒܵܥܹܐ ܐܵܬܹ‌ܐ ܒܵܬܪܝܼ، ܣܵܪܹܒ݂ ܓܵܢܹܗ، ܘܫܵܩܹܠܔ ܙܩܝܼܦܹܗ ܝܵܘܡܵܐܝܼܬ ܘܐܵܬܹ‌ܐ ܒܵܬܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","”ܣܵܒܵܒ ܡ̇ܢ ܕܒܵܥܹܐ ܦܲܪܸܩ ܓܵܢܹܗ ܒܸܬ ܛܲܠܸܩ ܠܵܗ̇، ܐܝܼܢܵܐ ܡ̇ܢ ܕܛܲܠܸܩ ܓܵܢܹܗ ܒܘܼܬ ܕܝܼܝܼ، ܗ̇ܘ ܒܸܬ ܦܲܪܸܩ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","”ܣܵܒܵܒ ܡܘܼܕܝܼ ܝܘܼܬܪܵܢܵܐ ܐܝܼܬ ܠܒܲܪܢܵܫܵܐ ܐܸܢ ܩܵܢܹܐ ܠܹܗ ܟܠܵܗ̇ ܕܘܼܢܝܹܐ ܐܝܼܢܵܐ ܓܵܢܹܗ ܛܲܠܸܩ ܠܵܗ̇ ܝܲܢ ܚܵܣܹܪܵܗ̇؟ ");
INSERT INTO aii_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","”ܡ̇ܢ ܕܢܵܟܹܦ ܒܝܼܝܼ ܘܒܗܹܡܸܙܡܵܢܝܼ̈، ܒܸܬ ܢܵܟܹܦ ܒܝܼܹܗ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܐܝܼܡܲܢ ܕܐܵܬܹ‌ܐ ܒܫܘܼܒ݂ܚܵܐ ܕܒܵܒܘܼܗ‌ܝ، ܥܲܡ ܡܲܠܲܐܟ݂ܘܼ̈ܗ‌ܝ ܩܲܕܝܼܫܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","”ܫܲܪܝܼܪܵܐܝܼܬ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܐܝܼܬ ܐܢܵܫܹ̈ܐ ܟܸܠܝܹܐ ܠܲܐܟ݂ܵܐ ܕܠܹܐ ܚܵܙܝܼ ܡܵܘܬܵ‌ܐ ܗܲܠܔ ܕܚܵܙܝܼ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ܐܲܝܟ݂ ܬܡܵܢܝܵܐ ܝܵܘܡܵܢܹ̈ܐ ܡ̣ܢ ܒܵܬܪ ܐܲܢܹܐ ܗܹܡܸܙܡܵܢܹ̈ܐ، ܠܘܼܒܸܠܔ ܠܹܗ ܝܼܫܘܿܥ ܠܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܘܠܝܲܥܩܘܿܒ݂ ܘܠܝܘܿܚܲܢܵܢ، ܘܐܣܝܼܩ ܠܹܗ ܠܛܘܼܪܵܐ ܠܨܲܠܘܼܝܹܐ ܨܠܘܿܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ܘܟܲܕ ܨܲܠܘܼܝܹܐ ܝܗܘܵܐ، ܦܝܼܫ ܠܹܗ ܫܘܼܚܠܸܦܵܐ ܚܸܙܘܵܐ ܕܦܵܬܹܗ، ܘܠܒ݂ܝܼܫܬܹܗ ܚܘܝܼܪܵܗ̇ ܘܡܘܼܒܪܸܩ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ܘܗܵܐ ܬܪܹܝ ܐܢܵܫܹ̈ܐ، ܡܘܼܫܹܐ ܘܐܹܠܝܼܵܐ، ܗܲܡܙܘܼܡܹܐ ܥܲܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ܦܝܼܫ ܠܗܘܿܢ ܚܸܙܝܹܐ ܒܫܘܼܒ݂ܚܵܐ، ܘܗܲܡܙܘܼܡܹܐ ܗܘܵܘ ܒܘܼܬ ܫܲܢܲܝܬܹܗ ܗ̇ܝ ܕܗܕܝܼܪܵܐ ܝܗܘܵܐ ܠܬܲܡܘܼܡܘܼܗ̇ ܒܐܘܿܪܸܫܠܸܡ. ");
INSERT INTO aii_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܘܐܵܢܝܼ ܕܥܲܡܹܗ ܝܘܼܩܪܸܢܹܐ ܝܗܘܵܘ ܒܫܸܢܬܵ‌ܐ. ܘܐܝܼܡܲܢ ܕܪܥܝܼܫ ܠܗܘܿܢ ܚܙܹܐ ܠܗܘܿܢ ܚܸܩܪܹܗ، ܘܠܐܵܢܝܼ ܬܪܹܝ ܐܢܵܫܹ̈ܐ ܟܸܠܝܹܐ ܠܟܸܣܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ܘܟܲܕ ܒܹܐܙܵܠܵܐ ܝܗܘܵܘ ܡ̣ܢ ܠܟܸܣܠܹܗ ܡܘܼܫܹܐ ܘܐܹܠܝܼܵܐ، ܐܡܝܼܪܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܠܝܼܫܘܿܥ: ”ܪܲܒܝܼ، ܨܦܵܝܝܼ ܝܠܵܗ̇ ܕܦܵܝܫܲܚ ܠܲܐܟ݂ܵܐ. ܥܵܒ݂ܕܲܚ ܬܠܵܬ ܡܛܲܠܠܹ̈ܐ، ܚܕܵܐ ܩܵܬܘܼܟ݂، ܘܚܕܵܐ ܩܵܐ ܡܘܼܫܹܐ، ܘܚܕܵܐ ܩܵܐ ܐܹܠܝܼܵܐ.“ ܐܝܼܢܵܐ ܠܹܐ ܝܗܘܵܐ ܒܝܼܕܵܥܵܐ ܡܘܼܕܝܼ ܒܹܐܡܵܪܵܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ܘܟܲܕ ܗ̇ܘ ܗܲܡܙܘܼܡܹܐ، ܗܘܹܐ ܠܵܗ̇ ܥܢܵܢܵܐ ܘܥܒ݂ܝܼܕ ܠܵܗ̇ ܛܸܠܵܢܝܼܬܵ‌ܐ ܥܲܠܵܝܗ‌ܝ. ܘܙܕܝܼܥ ܠܗܘܿܢ ܐܝܼܡܲܢ ܕܚܸܙܝܵܝ ܠܗܘܿܢ ܒܸܥܒ݂ܵܪܵܐ ܓܵܘ ܥܢܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ܘܩܵܠܵܐ ܗܘܹܐ ܠܹܗ ܡ̣ܢ ܥܢܵܢܵܐ ܒܹܐܡܵܪܵܐ: ”ܐܵܗܵܐ ܝܠܹܗ ܒܪܘܿܢܝܼ ܡܘܼܚܸܒܵܐ، ܐܸܠܹܗ ܫܡܹܥܡܘܼܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ܡ̣ܢ ܒܵܬܪ ܕܗܘܹܐ ܠܹܗ ܩܵܠܵܐ، ܦܝܼܫ ܠܹܗ ܚܸܙܝܵܐ ܝܼܫܘܿܥ ܒܢܲܦ̮ܫܹܗ. ܘܐܵܢܝܼ ܫܬܝܼܩ ܠܗܘܿܢ. ܘܠܐܢܵܫܵܐ ܠܵܐ ܐܡܝܼܪܗܘܿܢ ܒܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ ܒܘܼܬ ܡܸܢܕܝܼ ܕܚܙܹܐ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ܒܝܵܘܡܵܐ ܐܚܹܪܢܵܐ ܒܸܨܠܵܝܵܐ ܝܗܘܵܘ ܡ̣ܢ ܛܘܼܪܵܐ، ܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣܠܹܗ ܟܸܢܫܵܐ ܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ܘܚܲܕ ܐܢܵܫܵܐ ܡ̣ܢ ܓܵܘ ܟܸܢܫܵܐ ܡܘܼܩܘܸܚ ܠܹܗ ܘܐܡܝܼܪܹܗ: ”ܡܲܠܦܵܢܵܐ، ܦܲܪܦܘܼܠܹܐ ܝܘܸܢ ܒܝܼܘܼܟ݂ ܕܪܲܚܡܸܬ ܥܲܠܔ ܒܪܘܿܢܝܼ ܣܵܒܵܒ ܝܼܚܝܼܕܵܝܵܐ ܝܠܹܗ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","”ܟܹܐ ܥܵܒ݂ܪܵܐ ܒܝܼܹܗ ܪܘܼܚܵܐ، ܘܡܸܢܫܸܠܬܵܢܹܐ ܟܹܐ ܡܲܩܘܸܚ، ܘܟܹܐ ܪܲܬܪܸܬ ܘܓܲܒܓܸܒ، ܘܒܚܲܝܠܵܐ ܟܹܐ ܦܵܪܩܵܐ ܡܸܢܹܗ ܐܝܼܡܲܢ ܕܟܹܐ ܓ̰ܲܢܓ̰ܸܪܵܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","”ܦܘܼܪܦܸܠܔ ܠܝܼ ܒܬܲܠܡܝܼܕܘܼ̈ܟ݂ ܕܦܲܠܛܝܼ ܠܵܗ̇ ܡܸܢܹܗ ܘܠܵܐ ܡܨܹܐ ܠܗܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ: ”ܝܵܐ ܫܲܪܒܬܵ‌ܐ ܦܟ̰ܝܼܠܬܵ‌ܐ ܘܠܵܐ ܡܗܘܼܡܸܢܬܵ‌ܐ، ܗܲܠܔ ܐܝܼܡܲܢ ܒܸܬ ܗܵܘܹܝܢ ܠܟܸܣܠܵܘܟ݂ܘܿܢ ܘܛܵܥܢܹܢ ܝܘܼܩܪܵܘܟ݂ܘܿܢ؟ ܡܲܝܬ‌ܝܼ ܠܹܗ ܠܲܐܟ݂ܵܐ ܒܪܘܿܢܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ܘܟܲܕ ܒܹܐܬܵܝܵܐ ܝܗܘܵܐ، ܪܘܼܦܹܐ ܠܹܗ ܫܹܐܕܵܐ ܠܗ̇ܘ ܝܵܠܵܕ݇ܐ ܠܐܲܪܥܵܐ ܘܪܘܼܬܪܸܬ ܠܹܗ. ܘܢܓ̰ܝܼܘ ܠܹܗ ܝܼܫܘܿܥ ܒܗ̇ܝ ܪܘܼܚܵܐ ܛܲܡܐܹܐ، ܒܘܼܣܸܡ ܠܹܗ ܠܝܵܠܵܕ݇ܐ، ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܠܒܵܒܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ܘܥܘܼܓ̰ܸܒ ܠܗܘܿܢ ܟܠܵܝܗ‌ܝ ܒܓܘܼܪܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ. ܘܟܲܕ ܟܠܵܝܗ‌ܝ ܐܢܵܫܹ̈ܐ ܥܲܓ̰ܒܝܼ ܗܘܵܘ ܒܡܸܢܕܝܼ ܕܥܵܒܹܕ ܗܘܵܐ ܝܼܫܘܿܥ، ܐܡܝܼܪܹܗ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ");
INSERT INTO aii_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","”ܕܟ݂ܘܿܪܘܼܢ ܐܲܚܬܘܿܢ ܐܲܢܹܐ ܗܹܡܸܙܡܵܢܹ̈ܐ. ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܗܕܝܼܪܵܐ ܝܠܹܗ ܕܦܵܐܹܫ ܣܘܼܦܝܵܐ ܒܐܝܼܕܵܬܹ̈‌ܐ ܕܒܢܲܝ̈ܢܵܫܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ܐܝܼܢܵܐ ܐܵܢܝܼ ܠܵܐ ܦܘܼܪܡܹܐ ܠܗܘܿܢ ܠܐܵܗܵܐ ܗܹܡܸܙܡܵܢ ܘܛܘܼܫܝܼܬܵ‌ܐ ܝܗܘܵܐ ܡܸܢܵܝܗ‌ܝ ܕܠܵܐ ܦܲܪܡܝܼ ܗܘܵܘ ܠܵܗ̇، ܘܒܸܙܕܵܥܵܐ ܝܗܘܵܘ ܕܒܲܩܪܝܼ ܗܘܵܘ ܒܘܼܬ ܕܝܼܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ܫܘܼܪܹܐ ܠܗܘܿܢ ܬܲܠܡܝܼ̈ܕܹܐ ܡܲܩܪܘܼܨܹܐ ܥܲܡ ܥܘܼܕܵܠܹܐ ܕܡܵܢܝܼ ܝܠܹܗ ܓܘܼܪܵܐ ܓܵܘܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ܘܝܼܫܘܿܥ ܝܕܝܼܥ ܠܹܗ ܚܘܼܫܵܒܹ̈ܐ ܕܠܸܒܵܝܗ‌ܝ. ܫܩܝܼܠܔ ܠܹܗ ܚܲܕ ܝܵܠܵܕ݇ܐ ܙܥܘܿܪܵܐ ܘܡܘܼܟܠܹܐ ܠܹܗ ܠܟܸܣܠܹܗ، ");
INSERT INTO aii_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܟܠܔ ܕܩܲܒܸܠܔ ܠܐܵܗܵܐ ܝܵܠܵܕ݇ܐ ܒܫܸܡܝܼ، ܐܸܠܝܼ ܩܲܒܘܼܠܹܐ ܝܠܹܗ؛ ܘܡ̇ܢ ܕܐܸܠܝܼ ܩܲܒܸܠܔ ܩܲܒܘܼܠܹܐ ܝܠܹܗ ܠܗ̇ܘ ܕܫܘܼܕܸܪܹܗ ܐܸܠܝܼ. ܗ̇ܘ ܕܝܼܠܹܗ ܙܥܘܿܪܵܐ ܓܵܘܵܘܟ݂ܘܿܢ، ܗ̇ܘ ܝܼܠܹܗ ܓܘܼܪܵܐ ܕܟܠܵܘܟ݂ܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܘܿܚܲܢܵܢ: ”ܪܲܒܝܼ، ܚܙܹܐ ܠܲܢ ܚܲܕ ܐܢܵܫܵܐ ܦܲܠܘܼܛܹܐ ܫܹܐܕܹ̈ܐ ܒܫܸܡܘܼܟ݂، ܐܝܼܢܵܐ ܡܘܼܟܠܹܐ ܠܲܢ ܐܸܠܹܗ ܣܵܒܵܒ ܠܵܐ ܐܬܹ‌ܐ ܠܹܗ ܥܲܡܲܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܠܵܐ ܡܲܟܠܹܝܬܘܿܢ ܠܹܗ، ܣܵܒܵܒ ܡ̇ܢ ܕܠܹܐ ܝܠܹܗ ܠܕܲܠܩܘܼܒ݂ܠܵܘܟ݂ܘܿܢ ܥܲܡܵܘܟ݂ܘܿܢ ܝܼܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ܟܲܕ ܦܝܵܫܵܐ ܝܗܘܵܘ ܬܘܼܡܸܡܹܐ ܝܵܘܡܵܢܹ̈ܐ ܕܣܘܼܠܵܩܹܗ، ܩܛܝܼܥ ܠܹܗ ܒܚܝܼܵܠܹܗ ܕܐܵܙܹܠܔ ܠܐܘܿܪܸܫܠܸܡ. ");
INSERT INTO aii_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ܘܫܘܼܕܸܪܹܗ ܐܝܼܙܓܲܕܹ̈ܐ ܡܩܲܕܡ ܕܝܼܹܗ، ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܘܥܒ݂ܝܼܪܗܘܿܢ ܠܡܵܬܵ‌ܐ ܕܫܵܡܪ̈ܵܝܹܐ ܕܗܲܕܪܝܼ ܗܘܵܘ ܩܵܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ܐܝܼܢܵܐ ܫܵܡܪ̈ܵܝܹܐ ܠܵܐ ܩܘܼܒܸܠܔ ܠܗܘܿܢ ܐܸܠܵܝܗ‌ܝ ܣܵܒܵܒ ܩܛܝܼܥܵܐ ܝܗܘܵܐ ܒܚܝܼܵܠܹܗ ܕܐܵܙܹܠܔ ܠܐܘܿܪܸܫܠܸܡ. ");
INSERT INTO aii_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ܐܝܼܡܲܢ ܕܬܲܠܡܝܼ̈ܕܹܐ، ܝܲܥܩܘܿܒ݂ ܘܝܘܿܚܲܢܵܢ، ܚܙܹܐ ܠܗܘܿܢ ܐܵܗܵܐ، ܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܡܵܪܲܢ، ܐܸܢ ܒܵܥܹܝܬ ܦܵܩܕܲܚ ܕܨܵܠܹܐ ܢܘܼܪܵܐ ܡ̣ܢ ܫܡܲܝܵܐ ܘܐܵܟܹܠܔ ܠܗܘܿܢ، ܐܲܝܟ݂ ܕܥܒ݂ܝܼܕ ܠܹܗ ܐܹܠܝܼܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ܕܝܼܪܹܗ ܝܼܫܘܿܥ ܘܢܓ̰ܝܼܘ ܠܹܗ ܒܝܼܵܝܗ‌ܝ ܘܐܡܝܼܪܹܗ: ”ܠܹܐ ܝܬܘܿܢ ܒܝܼܕܵܥܵܐ ܡ̣ܢ ܐܲܝܢܝܼ ܪܘܼܚܵܐ ܝܬܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","”ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܠܵܐ ܐܬܹ‌ܐ ܠܹܗ ܕܛܲܠܸܩ ܓܵܢܵܬܹ̈‌ܐ ܕܒܢܲܝ̈ܢܵܫܵܐ ܐܸܠܵܐ ܕܦܲܪܸܩ ܠܗܘܿܢ.“ ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܠܚܕܵܐ ܡܵܬܵ‌ܐ ܐܚܹܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ܟܲܕ ܒܹܐܙܵܠܵܐ ܝܗܘܵܘ ܝܼܫܘܿܥ ܘܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܒܐܘܼܪܚܵܐ، ܐܡܝܼܪܹܗ ܚܲܕ ܐܢܵܫܵܐ ܠܝܼܫܘܿܥ: ”ܡܵܪܝܼ، ܒܸܬ ܐܵܬܹܝܢ ܒܵܬܪܘܼܟ݂ ܠܐܲܝܟܵܐ ܕܐܵܙܹܠ݇ܬ.“ ");
INSERT INTO aii_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܬܲܥ̈ܠܹܐ ܐܝܼܬ ܠܗܘܿܢ ܒܸܙܥܵܙܹ̈ܐ، ܘܛܲܝܪܹ̈ܐ ܕܫܡܲܝܵܐ ܕܘܼܟܵܐ ܕܫܪܵܝܬܵ‌ܐ، ܐܝܼܢܵܐ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܠܲܝܬ ܠܹܗ ܕܘܼܟܵܐ ܕܡܲܬܸܒ݂ ܪܹܝܫܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ܘܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܠܚܲܕ ܐܚܹܪܢܵܐ: ”ܬܵ‌ܐ ܒܵܬܪܝܼ.“ ܐܝܼܢܵܐ ܗ̇ܘ ܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܡܵܪܝܼ، ܫܒ݂ܘܿܩ ܠܝܼ ܩܲܕܡܵܝܬܵ‌ܐ ܕܐܵܙܹܠ݇ܢ ܘܩܵܒ݂ܪܹܢ ܠܒܵܒܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܫܒ݂ܘܿܩ ܡܝܼ̈ܬܹ‌ܐ ܩܵܒ݂ܪܝܼ ܡܝܼܬܵܝ̈ܗ‌ܝ، ܐܲܢ݇ܬ ܙܹܠܔ݇ ܘܡܲܟܪܸܙ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܚܲܕ ܐܚܹܪܢܵܐ: ”ܡܵܪܝܼ، ܒܸܬ ܐܵܬܹܝܢ ܒܵܬܪܘܼܟ݂، ܐܝܼܢܵܐ ܫܒ݂ܘܿܩ ܠܝܼ ܩܲܕܡܵܝܬܵ‌ܐ ܕܐܵܙܹܠ݇ܢ ܘܫܵܒ݂ܩܹܢ ܒܫܲܝܢܵܐ ܠܐܢܵܫܹ̈ܐ ܕܒܲܝܬ‌ܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܐܢܵܫܵܐ ܠܹܐ ܕܵܒܹܩ ܐܝܼܕܹܗ ܒܦܕܵܢܵܐ ܘܓܲܫܸܩ ܠܒܵܬܪܹܗ ܘܚܵܫܹܚ ܠܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ܡ̣ܢ ܒܵܬܪ ܐܲܢܹܐ، ܓܘܼܒܹܐ ܠܹܗ ܡܵܪܲܢ ܫܲܒ݂ܥܝܼ ܦܲܪ̈ܨܘܿܦܹܐ ܐܚܹܪ̈ܢܹܐ، ܘܫܘܼܕܪܵܝ ܠܹܗ ܬܪܹܝ ܬܪܹܝ ܡ̣ܢ ܩܲܕܡ ܕܝܼܹܗ ܠܟܠܔ ܕܘܼܟܵܐ ܘܠܟܠܔ ܡܕܝܼܢ݇ܬܵ‌ܐ ܕܗ̇ܘ ܥܵܒܹܪ ܗܘܵܐ ܓܵܘܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܚܸܨܕܵܐ ܪܵܒܵܐ ܝܠܹܗ ܘܦܵܥ̈ܠܹܐ ܒܵܨܘܿܪܹ̈ܐ ܝܢܵܐ. ܛܠܘܿܒܘܼܢ ܡ̣ܢ ܡܵܪܵܐ ܕܚܸܨܕܵܐ ܕܫܲܕܸܪ ܦܵܥ̈ܠܹܐ ܠܚܸܨܕܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","”ܙܹܠ݇ܡܘܼܢ، ܗܵܐ ܐܵܢܵܐ ܫܲܕܘܼܪܹܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ ܐܲܝܟ݂ ܦܹܐܪܹ̈ܐ ܓܵܘ ܕܹܐܒܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","”ܠܵܐ ܠܲܒܠܝܼܬܘܿܢ ܥܲܡܵܘܟ݂ܘܿܢ ܟܝܼܣܬܵ‌ܐ ܘܠܵܐ ܬܲܪܡܵܠܵܐ ܘܠܵܐ ܨܵܘܠܹ̈ܐ، ܘܒܐܘܼܪܚܵܐ ܫܠܵܡܵܐ ܠܐܢܵܫܵܐ ܠܵܐ ܕܵܪܹܝܬܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","”ܘܠܟܠܔ ܒܲܝܬܵ‌ܐ ܕܥܵܒ݂ܪܝܼܬܘܿܢ، ܩܲܕܡܵܝܬܵ‌ܐ ܐܡܘܿܪܘܼܢ: ’ܫܠܵܡܵܐ ܠܐܵܗܵܐ ܒܲܝܬܵ‌ܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","”ܘܐܸܢ ܐܝܼܬ ܬܵܡܵܐ ܐܢܵܫܵܐ ܕܫܠܵܡܵܐ، ܒܸܬ ܥܲܪܩܸܠܔ ܫܠܵܡܵܘܟ݂ܘܿܢ ܥܲܠܘܼܗ‌ܝ، ܘܐܸܢ ܠܲܝܬ، ܫܠܵܡܵܘܟ݂ܘܿܢ ܥܲܠܵܘܟ݂ܘܿܢ ܒܸܬ ܕܵܐܹܪ. ");
INSERT INTO aii_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","”ܘܦܵܝܫܝܼܬܘܿܢ ܓܵܘ ܗ̇ܘ ܒܲܝܬܵ‌ܐ، ܒܹܐܟ݂ܵܠܵܐ ܘܒܸܫܬܵܝܵܐ ܡ̣ܢ ܡܸܢܕܝܼܵܝܗ‌ܝ، ܣܵܒܵܒ ܚܫܝܼܚܵܐ ܝܠܹܗ ܦܵܥܠܵܐ ܠܦܘܼܪܥܵܢܹܗ. ܠܵܐ ܫܲܢܹܝܬܘܿܢ ܡ̣ܢ ܒܲܝܬܵ‌ܐ ܠܒܲܝܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","”ܘܠܐܲܝܢܝܼ ܡܕܝܼܢ݇ܬܵ‌ܐ ܕܥܵܒ݂ܪܝܼܬܘܿܢ ܘܩܲܒܠܝܼ ܠܵܘܟ݂ܘܿܢ، ܐܟ݂ܘܿܠܘܼܢ ܡܸܢܕܝܼ ܕܦܵܐܹܫ ܡܘܼܬܒ݂ܵܐ ܩܲܕܡܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ܒܲܣܡܘܼܢ ܠܐܵܢܝܼ ܕܝܼܢܵܐ ܡܪ̈ܝܼܥܹܐ ܓܵܘܘܼܗ̇، ܘܐܡܘܿܪܘܼܢ ܐܸܠܵܝܗ‌ܝ: ’ܩܘܼܪܒܸܢܵܗ̇ ܥܲܠܵܘܟ݂ܘܿܢ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","”ܐܝܼܢܵܐ ܠܡܕܝܼܢ݇ܬܵ‌ܐ ܕܥܵܒ݂ܪܝܼܬܘܿܢ ܘܠܵܐ ܩܲܒܠܝܼ ܠܵܘܟ݂ܘܿܢ، ܦܠܘܿܛܘܼܢ ܓܵܘ ܥܵܠܘܿܠܵܢܘܼ̈ܗ̇ ܘܐܡܘܿܪܘܼܢ: ");
INSERT INTO aii_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","”ܐܘܼܦ ܬܵܘܙ ܕܝܼܠܵܗ̇ ܬܦܝܼܬܵ‌ܐ ܒܐܲܩܠܵܬܲܢ̈ ܡ̣ܢ ܡܕܝܼܢ݇ܬܵܘܟ݂ܘܿܢ ܒܸܢܦܵܨܘܼܗ̇ ܝܘܲܚ ܐܸܠܵܘܟ݂ܘܿܢ. ܐܝܼܢܵܐ ܝܕܹܥܡܘܼܢ ܐܵܗܵܐ، ܕܩܘܼܪܒܸܢܵܗ̇ ܥܲܠܵܘܟ݂ܘܿܢ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","”ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܠܣܕܘܿܡ ܒܸܬ ܗܵܘܹܐ ܢܝܵܚܵܐ ܒܝܵܘܡܵܐ ܕܕܝܵܢܬܵ‌ܐ ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܠܗ̇ܝ ܡܕܝܼܢ݇ܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","”ܘܵܝ ܐܸܠܵܟ݂ܝ ܟܘܼܪܙܝܼܢ، ܘܵܝ ܐܸܠܵܟ݂ܝ ܒܹܝܬ ܨܲܝܵܕܵܐ، ܐܸܢ ܓܵܘ ܨܘܿܪ ܘܨܲܝܕܘܿܢ ܗܵܘܝܼ ܗܘܵܘ ܚܲܝ̈ܠܹܐ ܓܘܼܪܹ̈ܐ ܕܗܘܹܐ ܠܗܘܿܢ ܒܝܼܵܘܟ݂ܘܿܢ، ܡ̣ܢ ܓ̰ܲܠܕܹܐ ܒܣܲܩܹ̈ܐ ܘܒܩܸܛܡܵܐ ܒܸܬ ܬܲܘܸܒܝܼ ܗܘܵܘ. ");
INSERT INTO aii_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","”ܐܝܼܢܵܐ ܠܨܘܿܪ ܘܠܨܲܝܕܘܿܢ ܒܸܬ ܗܵܘܹܐ ܢܝܵܚܵܐ ܒܝܵܘܡܵܐ ܕܕܝܵܢܬܵ‌ܐ ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܕܐܸܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","”ܘܐܲܢ݇ܬ‌ܝ ܟܦܲܪܢܵܚܘܿܡ، ܠܵܐ ܗܲܠܔ ܫܡܲܝܵܐ ܦܝܼܫ ܠܵܟ݂ܝ ܡܘܼܪܸܡܬܵ‌ܐ؟ ܗܲܠܔ ܓܹܗܲܢܵܐ ܒܸܬ ܦܵܝܫܲܬ‌ܝ ܡܘܼܨܠܝܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","”ܡ̇ܢ ܕܫܵܡܹܥ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܸܠܝܼ ܒܸܫܡܵܥܵܐ ܝܠܹܗ، ܘܡ̇ܢ ܕܐܸܠܵܘܟ݂ܘܿܢ ܡܲܣܠܹܐ، ܐܸܠܝܼ ܡܲܣܠܘܼܝܹܐ ܝܠܹܗ، ܘܡ̇ܢ ܕܐܸܠܝܼ ܡܲܣܠܹܐ، ܡܲܣܠܘܼܝܹܐ ܝܠܹܗ ܠܗ̇ܘ ܕܫܘܼܕܪܸܢܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ܘܕܝܼܪܗܘܿܢ ܐܵܢܝܼ ܫܲܒ݂ܥܝܼ ܫܠܝܼܚܹ̈ܐ ܒܚܲܕܘܼܬܵ‌ܐ ܓܘܼܪܬܵ‌ܐ، ܘܐܡܝܼܪܗܘܿܢ ܠܝܼܫܘܿܥ: ”ܡܵܪܲܢ، ܐܘܼܦ ܫܹܐܕܹ̈ܐ ܦܝܵܫܵܐ ܝܢܵܐ ܙܲܒܛ ܐܸܠܲܢ ܒܫܸܡܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ܘܗ̇ܘ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܐܵܢܵܐ ܚܙܹܐ ܠܝܼ ܠܣܵܛܵܢܵܐ ܒܸܢܦܵܠܵܐ ܐܲܝܟ݂ ܒܸܪܩܵܐ ܡ̣ܢ ܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","”ܗܵܐ ܒܝܼܵܗܒ݂ܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ ܫܘܼܠܛܵܢܵܐ ܕܗܵܘܹܝܬܘܿܢ ܒܸܕܝܵܫܵܐ ܚܘܼܵܘܵܬܹ̈‌ܐ ܘܥܵܩܸܪ̈ܒܹܐ ܘܠܟܠܹܗ ܚܲܝܠܵܐ ܕܕܸܫ̃ܡܸܢ، ܘܡܸܢܕܝܼ ܠܹܐ ܚܲܙܕܸܓ ܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","”ܐܝܼܢܵܐ ܠܵܐ ܚܵܕܹܝܬܘܿܢ ܣܵܒܵܒ ܪ̈ܘܼܚܹܐ ܦܝܵܫܵܐ ܝܢܵܐ ܙܲܒܛ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܸܠܵܐ ܚܕܹܝܡܘܼܢ ܣܵܒܵܒ ܫܸܡܵܢܵܘ̈ܟ݂ܘܿܢ ܦܝܼܫ ܠܗܘܿܢ ܟܬܝܼܒܹܐ ܒܫܡܲܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ܒܗ̇ܝ ܥܕܵܢܵܐ ܦܨܝܼܚ ܠܹܗ ܝܼܫܘܿܥ ܒܪܘܼܚܵܐ ܘܐܡܝܼܪܹܗ: ”ܫܲܒܘܼܚܹܐ ܝܘܸܢ ܐܸܠܘܼܟ݂، ܝܵܐ ܒܵܒܝܼ ܡܵܪܵܐ ܕܫܡܲܝܵܐ ܘܕܐܲܪܥܵܐ، ܕܡܘܼܟܸܣ ܠܘܼܟ݂ ܐܲܢܹܐ ܡ̣ܢ ܚܲܟܝܼܡܹ̈ܐ ܘܦܲܪ̈ܡܝܼܵܢܹܐ ܘܓܸܠܝܵܝ ܠܘܼܟ݂ ܠܝܵܠܹ̈ܕ݇ܐ ܙܥܘܿܪܹ̈ܐ. ܗܹܐ ܒܵܒܝܼ، ܗܵܕܟ݂ܵܐ ܒܣܝܼܡ ܠܵܗ̇ ܠܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ܘܕܝܼܪܹܗ ܠܟܸܣ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܟܠܔ ܡܸܢܕܝܼ ܦܝܼܫ ܠܹܗ ܣܘܼܦܝܵܐ ܐܸܠܝܼ ܡ̣ܢ ܒܵܒܝܼ. ܐܘܼܦ ܚܲܕ ܐܢܵܫܵܐ ܠܹܐ ܝܵܕܹܥ ܡܵܢܝܼ ܝܠܹܗ ܒܪܘܿܢܵܐ ܐܸܠܵܐ ܒܵܒܵܐ، ܝܲܢ ܡܵܢܝܼ ܝܠܹܗ ܒܵܒܵܐ ܐܸܠܵܐ ܒܪܘܿܢܵܐ، ܘܠܡ̇ܢ ܕܒܵܣܡܵܐ ܠܹܗ ܒܪܘܿܢܵܐ ܕܓܵܠܹܐ ܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ܗ̇ܝܓܵܗ ܕܝܼܪܹܗ ܠܟܸܣ ܬܲܠܡܝܼ̈ܕܹܐ ܒܢܲܦ̮ܫܵܝܗ‌ܝ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܛܘܼܒ݂ܵܐ ܠܥܲܝ̈ܢܹܐ ܕܚܵܙܝܼ ܡܸܢܕܝܼ ܕܐܲܚܬܘܿܢ ܒܸܚܙܵܝܵܐ ܝܬܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","”ܣܵܒܵܒ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܪܵܒܵܐ ܢܒ݂ܝܼܹ̈ܐ ܘܡܲܠܟܹ̈ܐ ܒܥܹܐ ܠܗܘܿܢ ܕܚܵܙܝܼ ܗܘܵܘ ܡܸܢܕܝܼ ܕܐܲܚܬܘܿܢ ܒܸܚܙܵܝܵܐ ܝܬܘܿܢ ܘܠܵܐ ܚܙܹܐ ܠܗܘܿܢ، ܘܠܸܫܡܵܥܵܐ ܡܸܢܕܝܼ ܕܐܲܚܬܘܿܢ ܒܸܫܡܵܥܵܐ ܝܬܘܿܢ ܘܠܵܐ ܫܡܝܼܥ ܠܗܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ܩܝܼܡ ܠܹܗ ܚܲܕ ܢܵܡܘܿܣܵܝܵܐ ܓ̰ܲܪܘܼܒܹܐ ܠܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܡܲܠܦܵܢܵܐ، ܡܘܼܕܝܼ ܥܵܒ݂ܕܹܢ ܕܝܵܪܬܹܢ ܚܲܝܹ̈ܐ ܕܠܥܵܠܲܡ؟“ ");
INSERT INTO aii_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ: ”ܡܘܼܕܝܼ ܝܠܹܗ ܟܬܝܼܒ݂ܵܐ ܒܢܵܡܘܿܣܵܐ؟ ܕܵܐܟ݂ܝܼ ܟܹܐ ܩܵܪܹܝܬ؟“ ");
INSERT INTO aii_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ܘܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ: ”ܟܬܝܼܒ݂ܵܐ ܝܠܹܗ ܕܡܲܚܸܒܸܬ ܠܡܵܪܝܵܐ ܐܲܠܵܗܘܼܟ݂ ܡ̣ܢ ܟܠܹܗ ܠܸܒܘܼܟ݂، ܘܡ̣ܢ ܟܠܵܗ̇ ܓܵܢܘܼܟ݂، ܘܡ̣ܢ ܟܠܹܗ ܚܲܝܠܘܼܟ݂، ܘܡ̣ܢ ܟܠܹܗ ܪܸܥܝܵܢܘܼܟ݂ ܘܡܲܚܸܒܸܬ ܠܫܒ݂ܵܒ݂ܘܼܟ݂ ܐܲܝܟ݂ ܓܵܢܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܒܫܲܪܝܼܪܘܼܬܵ‌ܐ ܓ̰ܘܼܘܸܒ ܠܘܼܟ݂. ܥܒ݂ܘܿܕ ܗܵܕܟ݂ܵܐ ܘܒܸܬ ܚܵܝܹܝܬ.“ ");
INSERT INTO aii_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ܐܝܼܢܵܐ ܗ̇ܘ ܒܥܹܐ ܠܹܗ ܠܡܲܟܫܘܼܛܹܐ ܓܵܢܹܗ، ܒܘܼܩܸܪܹܗ ܡ̣ܢ ܝܼܫܘܿܥ: ”ܡܵܢܝܼ ܝܠܹܗ ܫܒ݂ܵܒ݂ܝܼ؟“ ");
INSERT INTO aii_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ: ”ܚܲܕ ܐܢܵܫܵܐ ܒܸܨܠܵܝܵܐ ܝܗܘܵܐ ܡ̣ܢ ܐܘܿܪܸܫܠܸܡ ܠܐܝܼܪܝܼܚܘܿ. ܕܒ݂ܝܼܩ ܠܗܘܿܢ ܐܸܠܹܗ ܫܲܠܚܵܢܹ̈ܐ ܘܫܘܼܠܸܚ ܠܗܘܿܢ ܐܸܠܹܗ، ܘܡܚܹܐ ܠܗܘܿܢ ܘܫܒ݂ܝܼܩ ܠܗܘܿܢ ܐܸܠܹܗ ܒܹܝܠܔ ܡܝܼܬܵ‌ܐ ܘܚܵܝܵܐ، ܘܐܙܝܼܠܔ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","”ܘܗܘܹܐ ܠܵܗ̇ ܕܚܲܕ ܟܵܗܢܵܐ ܒܹܐܙܵܠܵܐ ܝܗܘܵܐ ܒܗ̇ܝ ܐܘܼܪܚܵܐ. ܚܙܹܐ ܠܹܗ ܐܸܠܹܗ، ܘܥܒ݂ܝܼܪܹܗ ܡ̣ܢ ܗ̇ܘ ܓܹܒܵܐ ܐܚܹܪܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","”ܐܬܹ‌ܐ ܠܹܗ ܚܲܕ ܠܹܘܵܝܵܐ، ܡܛܹܐ ܠܹܗ ܠܗ̇ܝ ܕܘܼܟܵܐ، ܐܘܼܦ ܗ̇ܘ ܚܙܹܐ ܠܹܗ ܐܸܠܹܗ، ܘܥܒ݂ܝܼܪܹܗ ܡ̣ܢ ܗ̇ܘ ܓܹܒܵܐ ܐܚܹܪܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","”ܐܝܼܢܵܐ ܚܲܕ ܫܵܡܪܵܝܵܐ ܒܸܥܒ݂ܵܪܵܐ ܝܗܘܵܐ ܡ̣ܢ ܬܵܡܵܐ، ܐܬܹ‌ܐ ܠܹܗ ܠܗ̇ܝ ܕܘܼܟܵܐ ܘܚܙܹܐ ܠܹܗ ܐܸܠܹܗ ܘܪܘܼܚܸܡ ܠܹܗ ܥܲܠܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","”ܐܣܝܼܪܹܗ ܠܕܲܪ̈ܒܵܬܘܼܗ‌ܝ، ܘܨܘܼܢܨܸܠܔ ܠܹܗ ܥܲܠܵܝܗ‌ܝ ܚܲܡܪܵܐ ܘܡܸܫܚܵܐ، ܡܘܼܬܸܒ݂ ܠܹܗ ܥܲܠܔ ܚܡܵܪܹܗ، ܡܘܼܝܬܹ‌ܐ ܠܹܗ ܠܒܹܝܬ ܡܲܫܪܝܵܐ، ܘܬܘܼܓܒܸܪܹܗ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","”ܘܒܩܲܝܕܵܡܬܵ‌ܐ ܕܝܵܘܡܵܐ ܐܚܹܪܢܵܐ ܐܝܼܡܲܢ ܕܒܹܐܙܵܠܵܐ ܝܗܘܵܐ، ܦܘܼܠܸܛ ܠܹܗ ܬܪܹܝ ܕܝܼܢܵܪܹ̈ܐ ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܠܬܲܓܒܸܪܵܢܵܐ ܕܒܹܝܬ ܡܲܫܪܝܵܐ، ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ’ܬܲܓܒܸܪܸܬ ܠܹܗ، ܘܐܸܢ ܨܵܪܦܹܬ ܥܲܠܘܼܗ‌ܝ ܡܸܢܕܝܼ ܙܵܘܕܵܐ، ܐܝܼܡܲܢ ܕܕܵܝܪܹܢ ܒܸܬ ܦܵܪܥܹܢܘܼܟ݂.‘ ");
INSERT INTO aii_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","”ܐܲܝܢܝܼ ܡ̣ܢ ܐܲܢܹܐ ܬܠܵܬܵ‌ܐ ܒܸܚܫܵܒ݂ܵܐ ܝܘܸܬ ܗܘܹܐ ܠܹܗ ܫܒ݂ܵܒ݂ܵܐ ܠܗ̇ܘ ܕܢܦܝܼܠܔ ܠܹܗ ܓܵܘ ܫܲܠܚܵܢܹ̈ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ܘܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ: ”ܗ̇ܘ ܕܪܘܼܚܸܡ ܠܹܗ ܥܲܠܘܼܗ‌ܝ.“ ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܙܹܠܔ݇ ܐܘܼܦ ܐܲܢ݇ܬ ܘܥܒ݂ܘܿܕ ܗܵܕܟ݂ܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ܟܲܕ ܒܹܐܙܵܠܵܐ ܝܗܘܵܘ ܒܐܘܼܪܚܵܐ، ܥܒ݂ܝܼܪܹܗ ܝܼܫܘܿܥ ܠܚܕܵܐ ܡܵܬܵ‌ܐ، ܘܚܕܵܐ ܒܲܟ݂ܬܵ‌ܐ ܫܸܡܘܼܗ̇ ܡܵܪܬܵ‌ܐ ܩܘܼܒܸܠܔ ܠܵܗ̇ ܐܸܠܹܗ ܓܵܘ ܒܲܝܬܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ܘܗ̇ܝ ܐܝܼܬ ܗܘܵܐ ܠܵܗ̇ ܚܵܬܵ‌ܐ ܫܸܡܘܼܗ̇ ܡܲܪܝܲܡ. ܐܵܗܵܐ ܝܬܝܼܒ݂ ܠܵܗ̇ ܠܟܸܣ ܐܲܩܠܵܬܹ̈‌ܐ ܕܡܵܪܲܢ ܒܸܫܡܵܥܵܐ ܗܹܡܸܙܡܵܢܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ܐܝܼܢܵܐ ܡܵܪܬܵ‌ܐ ܒܠܝܼܓܬܵ‌ܐ ܝܗܘܵܐ ܒܚܸܠܡܲܬ ܪܵܒܵܐ. ܐܬܹ‌ܐ ܠܵܗ̇ ܘܐܡܝܼܪܵܗ̇ ܠܝܼܫܘܿܥ: ”ܡܵܪܝܼ، ܠܹܐ ܝܘܸܬ ܬܲܚܡܘܼܢܹܐ ܒܘܼܬ ܕܝܼܝܼ؟ ܚܵܬ‌ܝܼ ܩܵܡ ܫܵܒ݂ܩܵܐ ܠܝܼ ܒܢܲܦ̮ܫܝܼ ܠܗܲܕܘܼܪܹܐ ܡܸܢܕܝܼ. ܐܡܘܿܪ ܐܸܠܘܼܗ̇ ܕܗܲܝܸܪܵܐ ܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇: ”ܡܵܪܬܵ‌ܐ، ܡܵܪܬܵ‌ܐ، ܐܲܢ݇ܬ‌ܝ ܒܹܐܟ݂ܵܠܵܐ ܝܘܲܬ‌ܝ ܚܲܡ ܘܫܓ݂ܝܼܫܬܵ‌ܐ ܒܘܼܬ ܪܵܒܵܐ ܡܸܢܕܝܼܵܢܹ̈ܐ، ");
INSERT INTO aii_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","”ܐܝܼܢܵܐ ܐܲܚܟ̰ܝܼ ܚܲܕ ܡܸܢܕܝܼ ܝܠܹܗ ܐܵܢܲܢܩܵܝܵܐ، ܡܲܪܝܲܡ ܓܘܼܒܹܐ ܠܵܗ̇ ܣܵܗܡܵܐ ܛܵܒ݂ܵܐ ܕܠܹܐ ܦܵܐܹܫ ܫܩܝܼܠܵܐ ܡܸܢܘܼܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ܟܲܕ ܨܲܠܘܼܝܹܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܨܠܘܿܬܵ‌ܐ ܒܚܕܵܐ ܕܘܼܟܵܐ، ܐܝܼܡܲܢ ܕܦܪܝܼܩ ܠܹܗ، ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܚܲܕ ܡ̣ܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܡܵܪܲܢ، ܡܲܠܸܦ ܠܲܢ ܠܨܲܠܘܼܝܹܐ ܨܠܘܿܬܵ‌ܐ، ܕܵܐܟ݂ܝܼ ܕܝܘܿܚܲܢܵܢ ܡܘܼܠܸܦ ܠܹܗ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܐܝܼܡܲܢ ܕܨܲܠܹܝܬܘܿܢ ܨܠܘܿܬܵ‌ܐ، ܐܡܘܿܪܘܼܢ: ܒܵܒܲܢ ܕܒܫܡܲܝܵܐ، ܦܵܐܹܫ ܡܩܘܼܕܫܵܐ ܫܸܡܘܼܟ݂، ܐܵܬܝܵܐ ܡܲܠܟܘܼܬܘܼܟ݂، ܗܵܘܹܐ ܨܸܒ݂ܝܵܢܘܼܟ݂، ܕܵܐܟ݂ܝܼ ܕܒܫܡܲܝܵܐ ܐܘܼܦ ܒܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ܗܲܒ݂ܠܔ ܠܲܢ ܠܲܚܡܵܐ ܕܣܘܼܢܩܵܢܲܢ ܐܸܕܝܘܿܡ ܝܵܘܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ܫܒ݂ܘܿܩ ܐܸܠܲܢ ܚܛܝܼܵܬܲܢ̈، ܕܵܐܟ݂ܝܼ ܕܐܘܼܦ ܐܲܚܢܲܢ ܫܒ݂ܝܼܩ ܠܲܢ ܠܐܵܢܝܼ ܕܕܵܝܢܵܢܹ̈ܐ ܐܸܠܲܢ. ܘܠܵܐ ܡܲܥܒܸܪܸܬ ܠܲܢ ܠܢܸܣܝܘܿܢܵܐ، ܐܸܠܵܐ ܦܲܨܝܼ ܠܲܢ ܡ̣ܢ ܒܝܼܫܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܐܸܢ ܚܲܕ ܡܸܢܵܘܟ݂ܘܿܢ ܐܝܼܬ ܠܹܗ ܚܲܒ݂ܪܵܐ، ܘܐܵܙܹܠܔ ܠܟܸܣܠܹܗ ܒܦܲܠܓܵܐ ܕܠܲܝܠܹܐ ܘܐܵܡܹܪ ܐܸܠܹܗ: ’ܪܵܚܡܝܼ، ܗܲܒ݂ܠܔ ܠܝܼ ܒܕܲܝܢܵܐ ܬܠܵܬ ܓܸܪ̈ܕܲܝܹܐ، ");
INSERT INTO aii_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","”’ܣܵܒܵܒ ܪܵܚܡܵܐ ܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣܠܝܼ ܡ̣ܢ ܣܵܦܵܪ، ܘܠܲܝܬ ܠܝܼ ܡܸܢܕܝܼ ܕܡܲܬܒܸܢ ܩܲܕܡܘܼܗ‌ܝ.‘ ");
INSERT INTO aii_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","”ܘܐܸܢ ܪܵܚܡܹܗ ܡ̣ܢ ܠܓܵܘܵܐ ܓ̰ܲܘܸܒ ܠܹܗ ܘܐܵܡܹܪ: ’ܠܵܐ ܡܲܠܝܸܨ ܠܝܼ، ܬܲܪܥܵܐ ܕܒ݂ܝܼܪܵܐ ܝܠܹܗ، ܘܝܵܠܕ݇ܝܼ̈ ܥܲܡܝܼ ܝܢܵܐ ܒܫܘܝܼܬܵ‌ܐ، ܠܹܐ ܡܵܨܹܝܢ ܩܵܝܡܹܢ ܘܝܵܗܒܹܢܘܼܟ݂،‘ ");
INSERT INTO aii_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","”ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܐܸܢ ܒܘܼܬ ܪܵܚܡܘܼܬܵ‌ܐ ܠܵܐ ܩܵܐܹܡ ܘܝܵܗܒܹܠܔ ܠܹܗ، ܐܝܼܢܵܐ ܒܘܼܬ ܩܸܘܝܘܼܬܵ‌ܐ ܕܦܵܬܹܗ ܒܸܬ ܩܵܐܹܡ ܘܝܵܗܒܹܠܔ ܠܹܗ ܟܡܵܐ ܕܒܵܥܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","”ܐܘܼܦ ܐܵܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ: ܛܠܘܿܒܘܼܢ ܘܒܸܬ ܦܵܐܹܫ ܝܘܼܗܒ݂ܵܐ ܐܸܠܵܘܟ݂ܘܿܢ، ܛܥܹܝܡܘܼܢ ܘܒܸܬ ܡܲܫ݇ܟ̰ܚܝܼܬܘܿܢ، ܘܬܲܩܬܸܩܘܼܢ ܘܒܸܬ ܦܵܐܹܫ ܦܬܝܼܚܵܐ ܐܸܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","”ܣܵܒܵܒ ܟܠܔ ܡ̇ܢ ܕܛܵܠܹܒ ܒܸܬ ܫܵܩܹܠܔ، ܘܗ̇ܘ ܕܛܵܥܹܐ ܒܸܬ ܡܲܫ݇ܟ̰ܸܚ، ܘܗ̇ܘ ܕܬܲܩܬܸܩ ܒܸܬ ܦܵܐܹܫ ܦܬܝܼܚܵܐ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","”ܘܐܲܝܢܝܼ ܒܵܒܵܐ ܡܸܢܵܘܟ݂ܘܿܢ، ܐܸܢ ܒܪܘܿܢܹܗ ܛܵܠܹܒ ܡܸܢܹܗ ܠܲܚܡܵܐ، ܒܸܬ ܝܵܗܒܹܠܔ ܠܹܗ ܟܹܐܦܵܐ؟ ܘܐܸܢ ܛܵܠܹܒ ܡܸܢܹܗ ܢܘܼܢܵܐ، ܒܸܬ ܝܵܗܒܹܠܔ ܠܹܗ ܚܘܼܘܹܐ؟ ");
INSERT INTO aii_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","”ܘܐܸܢ ܛܵܠܹܒ ܡܸܢܹܗ ܒܹܥܬܵ‌ܐ، ܒܸܬ ܝܵܗܒܹܠܔ ܠܹܗ ܥܵܩܸܪܒ݂ܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","”ܗܵܕܟ݂ܵܐ ܐܸܢ ܐܲܚܬܘܿܢ ܒܝܼܫܹ̈ܐ ܟܹܐ ܝܵܕܥܝܼܬܘܿܢ ܠܝܼܵܗܒ݂ܵܐ ܡܵܘܗܒ݂ܵܬܹ̈‌ܐ ܛܵܒܹ̈ܐ ܠܒܢܘܿܢܵܘ̈ܟ݂ܘܿܢ، ܟܡܵܐ ܙܵܘܕܵܐ ܒܵܒܵܘܟ݂ܘܿܢ ܕܒܫܡܲܝܵܐ ܒܸܬ ܝܵܗܒܹܠܔ ܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ ܠܐܵܢܝܼ ܕܛܵܠܒܝܼ ܡܸܢܹܗ؟“ ");
INSERT INTO aii_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ܦܲܠܘܼܛܹܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܫܹܐܕܵܐ ܡ̣ܢ ܚܲܕ ܚܲܪܫܵܐ، ܡ̣ܢ ܒܵܬܪ ܕܦܘܼܠܸܛ ܠܹܗ ܫܹܐܕܵܐ، ܗܘܼܡܙܸܡ ܠܹܗ ܗ̇ܘ ܚܲܪܫܵܐ، ܘܥܘܼܓ̰ܸܒ ܠܗܘܿܢ ܟܸܢܫܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ܐܝܼܢܵܐ ܚܲܕܟܡܵܐ ܡ̣ܢ ܐܢܵܫܹ̈ܐ ܐܡܝܼܪܗܘܿܢ: ”ܐܵܗܵܐ ܒܒܥܸܠܙܒ݂ܘܿܒ݂، ܓܘܼܪܵܐ ܕܫܹܐܕܹ̈ܐ ܦܲܠܘܼܛܹܐ ܝܠܹܗ ܫܹܐܕܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ܘܐܚܹܪ̈ܢܹܐ ܒܥܹܐ ܠܗܘܿܢ ܕܓ̰ܲܪܒܝܼ ܗܘܵܘ ܠܹܗ، ܘܛܠܝܼܒ ܠܗܘܿܢ ܡܸܢܹܗ ܕܡܲܚܙܹܐ ܠܗܘܿܢ ܢܝܼܫܲܢܩܵܐ ܡ̣ܢ ܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܝܕܝܼܥ ܠܹܗ ܚܘܼܫܵܒ݂ܵܝ̈ܗ‌ܝ، ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܟܠܔ ܡܲܠܟܘܼܬܵ‌ܐ ܕܦܵܝܫܵܐ ܦܘܼܠܸܥܬܵ‌ܐ ܥܲܠܔ ܓܵܢܘܼܗ̇ ܒܸܬ ܚܵܪܒ݂ܵܐ، ܘܟܠܔ ܒܲܝܬܵ‌ܐ ܕܦܵܐܹܫ ܦܘܼܠܸܥܵܐ ܥܲܠܔ ܓܵܢܹܗ ܒܸܬ ܢܵܦܹܠܔ. ");
INSERT INTO aii_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","”ܘܐܸܢ ܣܵܛܵܢܵܐ ܕܲܠܩܘܼܒ݂ܠܔ ܕܣܵܛܵܢܵܐ ܦܵܠܹܚ، ܕܵܐܟ݂ܝܼ ܒܸܬ ܟܵܠܝܵܐ ܡܲܠܟܘܼܬܹܗ؟ ܐܲܚܬܘܿܢ ܒܹܐܡܵܪܵܐ ܝܬܘܿܢ ܕܐܵܢܵܐ ܒܒܥܸܠܙܒ݂ܘܿܒ݂ ܦܲܠܘܼܛܹܐ ܝܘܸܢ ܫܹܐܕܹ̈ܐ، ");
INSERT INTO aii_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","”ܐܸܢ ܐܵܢܵܐ ܒܒܥܸܠܙܒ݂ܘܿܒ݂ ܦܲܠܘܼܛܹܐ ܝܘܸܢ ܫܹܐܕܹ̈ܐ، ܒܢܘܿܢܵܘ̈ܟ݂ܘܿܢ ܒܡܘܼܕܝܼ ܟܹܐ ܦܲܠܛܝܼ ܠܗܘܿܢ؟ ܒܘܼܬ ܐܵܗܵܐ ܐܵܢܝܼ ܒܸܬ ܗܵܘܝܼ ܐܸܠܵܘܟ݂ܘܿܢ ܕܲܝܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","”ܐܝܼܢܵܐ ܐܸܢ ܒܚܲܝܠܵܐ ܕܐܲܠܵܗܵܐ ܦܲܠܘܼܛܹܐ ܝܘܸܢ ܫܹܐܕܹ̈ܐ، ܩܘܼܪܒܸܢܵܗ̇ ܥܲܠܵܘܟ݂ܘܿܢ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","”ܐܝܼܡܲܢ ܕܚܲܕ ܚܲܝܠܵܢܵܐ ܘܟ̰ܘܼܟܒܸܢܵܐ ܗܵܘܹܐ ܒܸܢܛܵܪܵܐ ܒܲܝܬܹܗ، ܒܫܲܝܢܵܐ ܝܠܹܗ ܡܸܢܕܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","”ܐܝܼܢܵܐ ܐܸܢ ܐܵܬܹ‌ܐ ܚܲܕ ܒܘܼܫ ܚܲܝܠܵܢܵܐ ܡܸܢܹܗ ܘܓ݂ܵܠܹܒ ܠܹܗ، ܒܸܬ ܫܵܩܹܠܔ ܟܠܹܗ ܙܲܝܢܹܗ ܕܒܗܹܒ݂ܝܼ ܝܗܘܵܐ ܥܲܠܘܼܗ‌ܝ، ܘܣܠܵܒܬܹܗ ܒܸܬ ܦܲܠܸܥ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","”ܡ̇ܢ ܕܠܹܐ ܝܠܹܗ ܥܲܡܝܼ ܕܲܠܩܘܼܒ݂ܠܝܼ ܝܠܹܗ، ܘܡ̇ܢ ܕܠܵܐ ܓ̰ܲܡܸܥ ܥܲܡܝܼ ܟܹܐ ܒܲܪܒܸܙ. ");
INSERT INTO aii_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","”ܐܝܼܡܲܢ ܕܪܘܼܚܵܐ ܛܲܡܐܹܐ ܦܵܠܛܵܐ ܡ̣ܢ ܒܲܪܢܵܫܵܐ، ܟܹܐ ܚܵܕܪܵܐ ܒܕܘܼܟܵܢܹ̈ܐ ܕܡ̈ܝܼܵܐ ܠܲܝܬ ܓܵܘܵܝܗ‌ܝ، ܒܸܛܠܵܒܵܐ ܢܝܵܚܵܐ. ܘܐܝܼܡܲܢ ܕܠܹܐ ܡܲܫ݇ܟ̰ܚܵܐ ܢܝܵܚܵܐ، ܟܹܐ ܐܵܡܪܵܐ: ’ܒܸܬ ܕܵܝܪܵܢ ܡ̣ܢ ܐܲܝܟܵܐ ܕܦܠܝܼܛ ܠܝܼ.‘ ");
INSERT INTO aii_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","”ܘܐܝܼܡܲܢ ܕܟܹܐ ܕܵܝܪܵܐ، ܟܹܐ ܡܲܫ݇ܟ̰ܚܵܐ ܠܹܗ ܒܲܝܬܵ‌ܐ ܟܢܝܼܫܵܐ ܘܣܘܼܩܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","”ܗ̇ܝܓܵܗ ܟܹܐ ܐܵܙܵܠ݇ܐ ܘܠܲܒܠܵܐ ܥܲܡܘܼܗ̇ ܫܒܲܥ ܪ̈ܘܼܚܵܬܹ‌ܐ ܐܚܹܪ̈ܢܹܐ ܒܘܼܫ ܒܝܼܫܹܐ ܡ̣ܢ ܓܵܢܘܼܗ̇، ܘܟܹܐ ܥܵܒ݂ܪܝܼ ܘܥܵܡܪܝܼ ܬܵܡܵܐ، ܘܟܹܐ ܗܵܘܝܵܐ ܚܲܪܬܵ‌ܐ ܕܗ̇ܘ ܐܢܵܫܵܐ ܒܘܼܫ ܣܪܝܼܬܵ‌ܐ ܡ̣ܢ ܩܲܕܡܵܝܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ܟܲܕ ܗ̇ܘ ܗܲܡܙܘܼܡܹܐ ܝܗܘܵܐ ܐܲܢܹܐ، ܡܘܼܪܸܡ ܠܵܗ̇ ܩܵܠܘܼܗ̇ ܚܕܵܐ ܒܲܟ݂ܬܵ‌ܐ ܡ̣ܢ ܓܵܘ ܟܸܢܫܵܐ ܘܐܡܝܼܪܵܗ̇: ”ܛܘܼܒ݂ܵܐ ܠܟܹܪ݇ܣܵܐ ܕܩܵܡ ܛܵܥܢܵܐ ܠܘܼܟ݂، ܘܠܒܸܙܵܙܹ̈ܐ ܕܩܵܡ ܡܲܡܸܨܝܼ ܠܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ܘܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܘܼܗ̇: ”ܛܘܼܒ݂ܵܐ ܒܘܼܫ ܙܵܘܕܵܐ ܠܐܵܢܝܼ ܕܫܵܡܥܝܼ ܗܹܡܸܙܡܵܢ ܕܐܲܠܵܗܵܐ ܘܢܵܛܪܝܼ ܠܵܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ܟܲܕ ܓ̰ܡܝܼܥܹܐ ܝܗܘܵܘ ܟܸܢܫܹ̈ܐ، ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܐܵܗܵܐ ܫܲܪܒܬܵ‌ܐ ܒܝܼܫܬܵ‌ܐ ܢܝܼܫܲܢܩܵܐ ܒܸܛܠܵܒܵܐ ܝܠܵܗ̇، ܘܢܝܼܫܲܢܩܵܐ ܠܹܐ ܦܵܐܹܫ ܝܘܼܗܒ݂ܵܐ ܐܸܠܘܼܗ̇ ܫܒ݂ܘܿܩ ܡ̣ܢ ܢܝܼܫܲܢܩܵܐ ܕܝܵܘܢܵܢ ܢܒ݂ܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","”ܕܵܐܟ݂ܝܼ ܕܗܘܹܐ ܠܹܗ ܝܵܘܢܵܢ ܢܝܼܫܲܢܩܵܐ ܠܢܝܼܢ̈ܘܵܝܹܐ، ܗܵܕܟ݂ܵܐ ܒܸܬ ܗܵܘܹܐ ܐܘܼܦ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܢܝܼܫܲܢܩܵܐ ܠܐܵܗܵܐ ܫܲܪܒܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","”ܡܲܠܟܬܵ‌ܐ ܕܬܲܝܡܢܵܐ ܒܸܬ ܟܵܠܝܵܐ ܒܕܝܼܘܵܢ ܥܲܡ ܐܢܵܫܹ̈ܐ ܕܐܵܗܵܐ ܫܲܪܒܬܵ‌ܐ ܘܒܸܬ ܕܵܝܢܵܐ ܠܗܘܿܢ، ܣܵܒܵܒ ܐܬܹ‌ܐ ܠܵܗ̇ ܡ̣ܢ ܡܲܪ̈ܙܵܢܹܐ ܕܐܲܪܥܵܐ ܕܫܵܡܥܵܐ ܚܸܟ݂ܡܬܵ‌ܐ ܕܫܠܹܝܡܘܿܢ، ܘܠܲܐܟ݂ܵܐ ܐܝܼܬ ܚܲܕ ܒܘܼܫ ܓܘܼܪܵܐ ܡ̣ܢ ܫܠܹܝܡܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","”ܐܢܵܫܹ̈ܐ ܕܢܝܼܢܘܹܐ ܒܸܬ ܩܵܝܡܝܼ ܒܝܵܘܡܵܐ ܕܕܝܵܢܬܵ‌ܐ ܥܲܡ ܐܵܗܵܐ ܫܲܪܒܬܵ‌ܐ ܘܒܸܬ ܕܵܝܢܝܼ ܠܵܗ̇، ܣܵܒܵܒ ܐܵܢܝܼ ܬܘܼܘܸܒ ܠܗܘܿܢ ܒܟܵܪܘܿܙܘܼܬܵ‌ܐ ܕܝܵܘܢܵܢ، ܘܠܲܐܟ݂ܵܐ ܐܝܼܬ ܚܲܕ ܒܘܼܫ ܓܘܼܪܵܐ ܡ̣ܢ ܝܵܘܢܵܢ. ");
INSERT INTO aii_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","”ܐܢܵܫܵܐ ܠܹܐ ܡܲܠܗܹܐ ܫܪܵܓ݂ܵܐ ܘܛܲܫܹܐ ܠܵܗ̇، ܝܲܢ ܡܲܬܸܒ݂ ܠܵܗ̇ ܬܚܘܿܬ ܣܲܐܬܵ‌ܐ، ܐܸܠܵܐ ܥܲܠܔ ܡܢܵܪܬܵ‌ܐ، ܩܵܐ ܕܚܵܙܝܼ ܒܲܗܪܘܼܗ̇ ܐܵܢܝܼ ܕܥܵܒ݂ܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","”ܫܪܵܓ݂ܵܐ ܕܦܲܓ݂ܪܘܼܟ݂ ܥܲܝܢܘܼܟ݂ ܝܼܠܵܗ̇. ܐܸܢ ܥܲܝܢܘܼܟ݂ ܕܟ݂ܝܼܬܵ‌ܐ ܝܠܵܗ̇، ܐܘܼܦ ܦܲܓ݂ܪܘܼܟ݂ ܒܸܬ ܗܵܘܹܐ ܒܲܗܪܵܢܵܐ، ܐܝܼܢܵܐ ܐܸܢ ܥܲܝܢܘܼܟ݂ ܒܝܼܫܬܵ‌ܐ ܝܠܵܗ̇، ܐܘܼܦ ܦܲܓ݂ܪܘܼܟ݂ ܚܸܫܟܵܢܵܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","”ܗܵܕܟ݂ܵܐ ܗܘܝܼ ܙܗܝܼܪܵܐ ܕܠܵܐ ܗܵܘܹܐ ܒܲܗܪܵܐ ܕܓܵܘܘܼܟ݂ ܚܸܫܟܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","”ܐܝܼܢܵܐ ܐܸܢ ܟܠܹܗ ܦܲܓ݂ܪܘܼܟ݂ ܒܲܗܪܵܢܵܐ ܝܠܹܗ ܘܠܲܝܬ ܒܝܼܹܗ ܚܸܫܟܵܐ، ܒܸܬ ܒܲܗܪܸܢ ܐܸܠܘܼܟ݂ ܐܲܝܟ݂ ܫܲܦ̮ܩܵܐ ܕܫܪܵܓ݂ܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ܟܲܕ ܗܲܡܙܘܼܡܹܐ ܝܗܘܵܐ ܝܼܫܘܿܥ، ܛܠܝܼܒ ܠܹܗ ܡܸܢܹܗ ܚܲܕ ܦܪܝܼܫܵܐ ܕܐܵܟܹܠܔ ܥܲܡܹܗ. ܘܥܒ݂ܝܼܪܹܗ ܠܒܲܝܬܵ‌ܐ ܘܝܬܝܼܒ݂ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ܐܝܼܢܵܐ ܗ̇ܘ ܦܪܝܼܫܵܐ ܥܘܼܓ̰ܸܒ ܠܹܗ ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܹܗ ܕܝܼܫܘܿܥ ܠܵܐ ܚܘܼܠܸܠܔ ܠܹܗ ܡ̣ܢ ܩܲܕܡ ܕܐܵܟܹܠܔ ܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܡܵܪܲܢ: ”ܐܲܚܬܘܿܢ ܦܪ̈ܝܼܫܹܐ ܟܹܐ ܕܲܟܹܝܬܘܿܢ ܠܒܵܬܪܵܐ ܕܟܵܣܵܐ ܘܕܙܵܒ݂ܘܿܪܵܐ، ܐܝܼܢܵܐ ܓܵܘܵܘܟ݂ܘܿܢ ܡܸܠܝܵܐ ܝܠܹܗ ܚܛܘܼܦܝܵܐ ܘܒܝܼܫܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","”ܝܵܐ ܣܲܟ݂ܠܹ̈ܐ، ܠܹܐ ܝܗܘܵܐ ܗ̇ܘ ܕܥܒ݂ܝܼܕ ܠܹܗ ܠܒܲܕܲܪ ܐܘܼܦ ܠܓܵܘܵܐ ܗ̇ܘ ܥܒ݂ܝܼܕ ܠܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","”ܡܸܢܕܝܼ ܕܐܝܼܬ ܠܵܘܟ݂ܘܿܢ ܓܵܘ ܟܵܣܵܐ ܘܒܙܵܒ݂ܘܿܪܵܐ ܗܲܒ݂ܠܘܼܢ ܒܐܸܪܘܵܢܵܐ، ܘܟܠܔ ܡܸܢܕܝܼ ܐܚܹܪܢܵܐ ܒܸܬ ܗܵܘܹܐ ܕܸܟ݂ܝܵܐ ܐܸܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","”ܘܵܝ ܐܸܠܵܘܟ݂ܘܿܢ ܦܪ̈ܝܼܫܹܐ، ܟܹܐ ܝܵܗܒ݂ܝܼܬܘܿܢ ܡܲܥܣܵܪܹ̈ܐ ܕܢܵܥܢܵܐ ܘܦܸܓ݂ܢܵܐ ܘܕܟܠܵܝܗ‌ܝ ܝܲܪ̈ܩܹܐ، ܐܝܼܢܵܐ ܟܹܐ ܫܵܡܛܝܼܬܘܿܢ ܕܝܼܘܵܢ ܘܚܘܼܒܵܐ ܕܐܲܠܵܗܵܐ. ܐܲܢܹܐ ܘܵܠܹܐ ܝܗܘܵܐ ܕܥܵܒ݂ܕܝܼܬܘܿܢ ܗܘܵܘ، ܘܠܵܐ ܫܵܒ݂ܩܝܼܬܘܿܢ ܗܘܵܘ ܠܐܵܢܝܼ ܐܚܹܪ̈ܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","”ܘܵܝ ܐܸܠܵܘܟ݂ܘܿܢ ܦܪ̈ܝܼܫܹܐ، ܟܹܐ ܡܲܚܸܒܝܼܬܘܿܢ ܝܬܵܒ݂ܬܵ‌ܐ ܒܪܹܝܫܵܐ ܕܟܢܘܼܫܝܵܬܹ̈‌ܐ ܘܩܲܒܲܠܬܵ‌ܐ ܕܫܠܵܡܵܐ ܒܫܘܼܩܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","”ܘܵܝ ܐܸܠܵܘܟ݂ܘܿܢ ܣܵܦܪܹ̈ܐ ܘܦܪ̈ܝܼܫܹܐ، ܡܲܫܦܸܪ̈ܵܢܹܐ، ܕܝܼܬܘܿܢ ܐܲܝܟ݂ ܩܲܒ݂ܪܹ̈ܐ ܕܠܹܐ ܡܲܒܝܸܢܝܼ، ܘܐܢܵܫܹ̈ܐ ܟܹܐ ܚܵܕܪܝܼ ܥܲܠܵܝܗ‌ܝ ܘܠܹܐ ܝܵܕܥܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ ܚܲܕ ܢܵܡܘܿܣܵܝܵܐ ܘܐܡܝܼܪܹܗ: ”ܡܲܠܦܵܢܵܐ، ܟܲܕ ܒܹܐܡܵܪܵܐ ܝܘܸܬ ܐܲܢܹܐ ܐܘܼܦ ܐܸܠܲܢ ܡܲܣܠܘܼܝܹܐ ܝܘܸܬ.“ ");
INSERT INTO aii_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܐܘܼܦ ܐܲܚܬܘܿܢ ܢܵܡܘܿܣܵܝܹ̈ܐ ܘܵܝ ܐܸܠܵܘܟ݂ܘܿܢ، ܣܵܒܵܒ ܟܹܐ ܡܲܛܥܸܢܝܼܬܘܿܢ ܠܒܢܲܝ̈ܢܵܫܵܐ ܟܵܪ̈ܵܬܹ‌ܐ ܝܲܩܘܼܪܹ̈ܐ، ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ ܐܘܼܦ ܒܚܕܵܐ ܡ̣ܢ ܨܸܒܥܵܬܵܘ̈ܟ݂ܘܿܢ ܠܹܐ ܕܵܩܪܝܼܬܘܿܢ ܒܐܵܢܝܼ ܟܵܪ̈ܵܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","”ܘܵܝ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܟܹܐ ܒܵܢܹܝܬܘܿܢ ܩܲܒ݂ܪܹ̈ܐ ܩܵܐ ܢܒ݂ܝܼܹ̈ܐ ܕܦܝܼܫ ܠܗܘܿܢ ܩܛܝܼܠܹܐ ܒܝܲܕ ܐܲܒ݂ܵܗܵܬܵܘ̈ܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","”ܗܵܕܟ݂ܵܐ ܒܝܼܵܗܒ݂ܵܐ ܝܬܘܿܢ ܣܵܗܕܘܼܬܵ‌ܐ ܘܡܫܲܪܘܼܪܹܐ ܝܬܘܿܢ ܠܦܘܼܠܚܵܢܵܐ ܕܐܲܒ݂ܵܗܵܬܵܘ̈ܟ݂ܘܿܢ. ܐܵܢܝܼ ܩܛܝܼܠܔ ܠܗܘܿܢ ܠܢܒ݂ܝܼܹ̈ܐ، ܘܐܲܚܬܘܿܢ ܒܸܒܢܵܝܵܐ ܩܲܒ݂ܪ̈ܵܘܵܬܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","”ܒܘܼܬ ܐܵܗܵܐ ܐܡܝܼܪܹܗ ܐܲܠܵܗܵܐ ܒܚܸܟ݂ܡܬܹܗ: ’ܗܵܐ ܐܵܢܵܐ ܫܲܕܘܼܪܹܐ ܝܘܸܢ ܐܸܠܵܝܗ‌ܝ ܢܒ݂ܝܼܹ̈ܐ ܘܫܠܝܼܚܹ̈ܐ، ܡܸܢܵܝܗ‌ܝ ܒܸܬ ܟܲܡܪܝܼ ܘܩܵܛܠܝܼ.‘ ");
INSERT INTO aii_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","”ܕܦܵܐܹܫ ܛܠܝܼܒܵܐ ܡ̣ܢ ܐܵܗܵܐ ܫܲܪܒܬܵ‌ܐ ܕܸܡܵܐ ܕܟܠܵܝܗ‌ܝ ܢܒ݂ܝܼܹ̈ܐ ܕܦܝܼܫ ܠܹܗ ܫܦܝܼܟ݂ܵܐ ܗܵܐ ܡ̣ܢ ܫܘܼܪܵܝܵܐ ܕܒܪܝܼܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","”ܡ̣ܢ ܕܸܡܵܐ ܕܗܵܒܹܝܠܔ ܗܲܠܔ ܕܸܡܵܐ ܕܙܟܲܪܝܵܐ، ܗ̇ܘ ܕܦܝܼܫ ܠܹܗ ܩܛܝܼܠܵܐ ܒܹܝܠܔ ܗܲܝܟܠܵܐ ܘܡܲܕܒܚܵܐ. ܫܲܪܝܼܪܵܐܝܼܬ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ ܕܒܸܬ ܦܵܐܹܫ ܛܠܝܼܒܵܐ ܡ̣ܢ ܐܵܗܵܐ ܫܲܪܒܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","”ܘܵܝ ܐܸܠܵܘܟ݂ܘܿܢ ܢܵܡܘܿܣܵܝܹ̈ܐ، ܕܫܩܝܼܠܹܐ ܝܬܘܿܢ ܩܕܝܼܠܵܐ ܕܝܕܵܥܬܵ‌ܐ. ܒܓܵܢܵܘܟ݂ܘܿܢ ܠܹܐ ܝܬܘܿܢ ܒܸܥܒ݂ܵܪܵܐ، ܘܡܲܟܠܘܼܝܹܐ ܝܬܘܿܢ ܠܐܵܢܝܼ ܕܒܵܥܝܼ ܥܵܒ݂ܪܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ܟܲܕ ܦܠܝܼܛ ܠܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܬܵܡܵܐ، ܫܘܼܪܹܐ ܠܗܘܿܢ ܣܵܦܪܹ̈ܐ ܘܦܪ̈ܝܼܫܹܐ ܠܡܲܠܝܘܼܨܹܗ ܪܵܒܵܐ ܕܦܲܠܛܝܼ ܡܸܢܹܗ ܚܲܒܪܵܐ ܒܘܼܬ ܪܵܒܵܐ ܡܸܢܕܝܼܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ܘܢܵܛܪܝܼ ܗܘܵܘ ܠܹܗ ܕܵܐܟ݂ܝܼ ܕܵܒ݂ܩܝܼ ܗܘܵܘ ܠܹܗ ܒܗܹܡܸܙܡܵܢ ܡ̣ܢ ܦܘܼܡܹܗ ܕܕܵܝܢܝܼ ܗܘܵܘ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ܒܗ̇ܝ ܥܕܵܢܵܐ ܟܲܕ ܒܸܓ̰ܡܵܥܵܐ ܝܗܘܵܘ ܪܸ̈ܒܘܵܬܹ‌ܐ ܕܟܸܢܫܵܐ، ܗܵܕܟ݂ܵܐ ܕܚܲܕ ܒܸܕܝܵܫܵܐ ܝܗܘܵܐ ܠܗ̇ܘ ܐܚܹܪܢܵܐ، ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܩܲܕܡܵܝܬܵ‌ܐ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܗܘܹܝܡܘܼܢ ܗܸܫܝܲܪ ܠܓܵܢܵܘܟ݂ܘܿܢ ܡ̣ܢ ܚܡܝܼܪܵܐ ܕܦܪ̈ܝܼܫܹܐ، ܕܝܼܠܹܗ ܡܲܫܦܲܪܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","”ܠܲܝܬ ܡܸܢܕܝܼ ܡܘܼܟܣܵܐ ܕܠܵܐ ܦܵܐܹܫ ܓܸܠܝܵܐ، ܘܠܵܐ ܡܸܢܕܝܼ ܛܘܼܫܝܵܐ ܕܠܵܐ ܦܵܐܹܫ ܝܕܝܼܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","”ܣܵܒܵܒ ܟܠܔ ܡܸܢܕܝܼ ܕܒܚܸܫܟܵܐ ܐܵܡܪܝܼܬܘܿܢ، ܒܸܬ ܦܵܐܹܫ ܫܡܝܼܥܵܐ ܒܒܲܗܪܵܐ، ܘܡܸܢܕܝܼ ܕܒܟܘܼܚܝܵܬܹ̈‌ܐ ܓܵܘ ܢܵܬܝܵܬܹ̈‌ܐ ܦܲܛܦܸܛܝܼܬܘܿܢ، ܥܲܠܔ ܐ݇ܓܵܪ̈ܵܘܵܬܹ‌ܐ ܒܸܬ ܦܵܐܹܫ ܡܘܼܟܪܸܙܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","”ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ ܐܲܝܟ݂ ܕܠܪ̈ܵܚܡܝܼ، ܠܵܐ ܙܵܕܥܝܼܬܘܿܢ ܡ̣ܢ ܐܵܢܝܼ ܕܩܵܛܠܝܼ ܠܦܲܓ݂ܪܵܐ ܘܡ̣ܢ ܒܵܬܪ ܗܵܕܵܐ ܠܹܐ ܡܵܨܝܼ ܡܸܢܕܝܼ ܙܵܘܕܵܐ ܥܵܒ݂ܕܝܼ، ");
INSERT INTO aii_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","”ܐܝܼܢܵܐ ܐܵܡܪܹܢܵܘܟ݂ܘܿܢ ܡ̣ܢ ܡܵܢܝܼ ܙܵܕܥܝܼܬܘܿܢ: ܙܕܹܥܡܘܼܢ ܡ̣ܢ ܗ̇ܘ ܕܡ̣ܢ ܒܵܬܪ ܕܩܵܛܹܠܔ ܐܝܼܬ ܠܹܗ ܫܘܼܠܛܵܢܵܐ ܠܸܕܪܵܝܵܐ ܒܓܹܗܲܢܵܐ. ܗܹܐ، ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܡ̣ܢ ܗ̇ܘ ܙܕܹܥܡܘܼܢ. ");
INSERT INTO aii_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","”ܚܲܡܫܵܐ ܨܸܦܪܹ̈ܐ ܠܹܐ ܦܵܝܫܝܼ ܙܘܼܒܢܹܐ ܒܬܪܹܝ ܦܘܼܠܣܹ̈ܐ؟ ܐܝܼܢܵܐ ܐܘܼܦ ܚܲܕ ܡܸܢܵܝܗ‌ܝ ܠܹܐ ܦܵܐܹܫ ܡܘܼܢܫܝܼܵܐ ܒܝܲܕ ܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","”ܘܐܲܚܬܘܿܢ ܐܘܼܦ ܡܸܙܝܵܬܹ̈‌ܐ ܕܪܹܝܫܵܘܟ݂ܘܿܢ ܡܸܢܝܹܐ ܝܢܵܐ. ܠܵܐ ܙܵܕܥܝܼܬܘܿܢ، ܡ̣ܢ ܨܸܦܪܹ̈ܐ ܒܘܼܫ ܛܝܼܡܵܢܹ̈ܐ ܝܬܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","”ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܟܠܔ ܡ̇ܢ ܕܡܵܘܕܹܐ ܒܝܼܝܼ ܩܲܕܡ ܒܢܲܝ̈ܢܵܫܵܐ، ܐܘܼܦ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܸܬ ܡܵܘܕܹܐ ܒܝܼܹܗ ܩܲܕܡ ܡܲܠܲܐܟܹ̈ܐ ܕܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","”ܐܝܼܢܵܐ ܡ̇ܢ ܕܣܵܪܹܒ݂ ܠܝܼ ܩܲܕܡ ܒܢܲܝ̈ܢܵܫܵܐ، ܒܸܬ ܦܵܐܹܫ ܣܪܝܼܒ݂ܵܐ ܩܲܕܡ ܡܲܠܲܐܟܹ̈ܐ ܕܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","”ܟܠܔ ܡ̇ܢ ܕܗܲܡܙܸܡ ܕܲܠܩܘܼܒ݂ܠܔ ܕܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܸܬ ܦܵܐܹܫ ܦܘܼܚܠܵܐ، ܐܝܼܢܵܐ ܡ̇ܢ ܕܓܵܕܹܦ ܥܲܠܔ ܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ ܠܹܐ ܦܵܐܹܫ ܦܘܼܚܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","”ܐܝܼܡܲܢ ܕܡܲܝܬ‌ܝܼ ܠܵܘܟ݂ܘܿܢ ܠܟܢܘܼܫܝܵܬܹ̈‌ܐ ܘܩܲܕܡ ܪܹ̈ܝܫܵܢܹܐ ܘܫܲܠܝܼ̈ܛܹܐ، ܠܵܐ ܐܵܟ݂ܠܝܼܬܘܿܢ ܚܲܡ ܕܵܐܟ݂ܝܼ ܝܲܢ ܡܘܼܕܝܼ ܒܸܬ ܓ̰ܲܘܸܒܝܼܬܘܿܢ ܝܲܢ ܐܵܡܪܝܼܬܘܿܢ، ");
INSERT INTO aii_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","”ܣܵܒܵܒ ܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ ܒܸܬ ܡܲܠܸܦ ܠܵܘܟ݂ܘܿܢ ܒܗ̇ܝ ܥܕܵܢܵܐ ܡܸܢܕܝܼ ܕܘܵܠܹܐ ܝܠܹܗ ܕܐܵܡܪܝܼܬܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܚܲܕ ܐܢܵܫܵܐ ܡ̣ܢ ܓܵܘ ܟܸܢܫܵܐ: ”ܡܲܠܦܵܢܵܐ، ܐܡܘܿܪ ܠܐܲܚܘܿܢܝܼ ܕܦܲܠܸܥ ܥܲܡܝܼ ܝܵܪܬܘܼܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܝܵܐ ܐܢܵܫܵܐ، ܡܵܢܝܼ ܩܵܡ ܡܲܩܸܡ ܠܝܼ ܥܲܠܵܘܟ݂ܘܿܢ ܕܲܝܵܢܵܐ ܘܦܲܠܸܥܵܢܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ܘܐܡܝܼܪܹܗ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܚܙܹܝܡܘܼܢ ܘܗܘܹܝܡܘܼܢ ܗܸܫܝܲܪ ܡ̣ܢ ܟܠܵܗ̇ ܛܲܡܲܥܟܵܪܘܼܬܵ‌ܐ، ܣܵܒܵܒ ܠܹܐ ܝܠܵܗ̇ ܒܙܵܘܕܘܼܢܝܘܼܬܵ‌ܐ ܕܕܵܘܸܠܬܵ‌ܐ ܕܟܹܐ ܚܵܝܹܐ ܐܢܵܫܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܡܲܬܠܵܐ: ”ܚܲܕ ܐܢܵܫܵܐ ܥܲܬܝܼܪܵܐ ܡܘܼܝܬܹ‌ܐ ܠܵܗ̇ ܐܸܠܹܗ ܐܲܪܥܹܗ ܡܲܗܨܘܼܠܹ̈ܐ ܪܵܒܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","”ܬܘܼܚܡܸܢܹܗ ܘܐܡܝܼܪܹܗ ܒܓܵܢܹܗ: ’ܡܘܼܕܝܼ ܥܵܒ݂ܕܹܢ؟ ܠܲܝܬ ܠܝܼ ܕܘܼܟܵܐ ܕܓ̰ܲܡܥܸܢ ܡܲܗܨܘܼܠܝܼ̈.‘ ");
INSERT INTO aii_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","”ܘܐܡܝܼܪܹܗ: ’ܗܵܕܟ݂ܵܐ ܒܸܬ ܥܵܒ݂ܕܹܢ. ܒܸܬ ܬܵܠܚܹܢ ܐܲܢܒܵܪ̈ܝܼ، ܘܒܵܢܹܝܢ ܒܘܼܫ ܓܘܼܪܹ̈ܐ، ܘܒܸܬ ܓ̰ܲܡܥܸܢ ܬܵܡܵܐ ܟܠܵܝܗ‌ܝ ܡܲܗܨܘܼܠܝܼ̈ ܘܟܠܹܗ ܡܸܢܕܝܼܝܼ، ");
INSERT INTO aii_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","”’ܘܒܸܬ ܐܵܡܪܹܢ ܠܓܵܢܝܼ، ܝܵܐ ܓܵܢܝܼ، ܐܝܼܬ ܠܵܟ݂ܝ ܪܵܒܵܐ ܡܸܢܕܝܼܵܢܹ̈ܐ ܡܘܼܬܒܹܐ ܩܵܐ ܪܵܒܵܐ ܫܸܢܹ̈ܐ، ܡܲܢܝܸܚܝ، ܐܟ݂ܘܿܠܝ، ܘܫܬ‌ܝܼ ܘܡܲܒܣܸܡܝ.‘ ");
INSERT INTO aii_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","”ܐܝܼܢܵܐ ܐܲܠܵܗܵܐ ܐܡܝܼܪܹܗ ܐܸܠܹܗ: ’ܝܵܐ ܣܪܝܼܩܵܐ ܕܗܵܘܢܵܐ، ܒܐܵܗܵܐ ܠܲܝܠܹܐ ܒܸܬ ܫܵܩܠܝܼ ܠܵܗ̇ ܓܵܢܘܼܟ݂ ܡܸܢܘܼܟ݂، ܘܐܲܢܹܐ ܕܗܘܼܕܪܵܝ ܝܘܸܬ ܠܡܵܢܝܼ ܒܸܬ ܗܵܘܝܼ؟‘ ");
INSERT INTO aii_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","”ܗܵܕܟ݂ܵܐ ܝܠܹܗ ܗ̇ܘ ܕܡܲܬܸܒ݂ ܠܓܵܢܹܗ ܣܝܼܡܵܬܹ̈‌ܐ، ܘܠܟܸܣ ܐܲܠܵܗܵܐ ܠܹܐ ܝܠܹܗ ܥܲܬܝܼܪܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ܘܐܡܝܼܪܹܗ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܒܘܼܬ ܐܵܗܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܠܵܐ ܐܵܟ݂ܠܝܼܬܘܿܢ ܚܲܡ ܒܘܼܬ ܓܵܢܵܘܟ݂ܘܿܢ ܕܡܘܼܕܝܼ ܒܸܬ ܐܵܟ݂ܠܝܼܬܘܿܢ، ܘܠܵܐ ܒܘܼܬ ܦܲܓ݂ܪܵܘܟ݂ܘܿܢ ܕܡܘܼܕܝܼ ܒܸܬ ܠܵܒ݂ܫܝܼܬܘܿܢ، ");
INSERT INTO aii_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","”ܣܵܒܵܒ ܓܵܢܵܐ ܒܘܼܫ ܙܵܘܕܵܐ ܝܠܵܗ̇ ܡ̣ܢ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ، ܘܦܲܓ݂ܪܵܐ ܡ̣ܢ ܠܒ݂ܝܼܫܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","”ܓܲܫܩܘܼܢ ܒܩܲܪ̈ܓܹܐ، ܕܠܹܐ ܙܵܪܥܝܼ ܘܠܹܐ ܚܵܨܕܝܼ، ܘܠܲܝܬ ܠܗܘܿܢ ܕܘܼܟܵܢܹ̈ܐ ܕܫܪܵܝܬܵ‌ܐ ܘܐܲܢܒܵܪܹ̈ܐ، ܐܝܼܢܵܐ ܐܲܠܵܗܵܐ ܟܹܐ ܬܲܪܣܹܐ ܠܗܘܿܢ. ܟܡܵܐ ܐܲܚܬܘܿܢ ܒܘܼܫ ܛܝܼܡܵܢܹ̈ܐ ܝܬܘܿܢ ܡ̣ܢ ܛܲܝܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","”ܐܲܝܢܝܼ ܡܸܢܵܘܟ݂ܘܿܢ ܟܡܵܐ ܕܓ̰ܲܪܸܒ ܡܵܨܹܐ ܡܲܙܝܸܕ ܥܲܠܔ ܩܵܘܡܬܹܗ ܚܕܵܐ ܝܲܡܝܼܢܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","”ܐܸܢ ܗܵܕܟ݂ܵܐ ܡܸܢܕܝܼ ܙܥܘܿܪܵܐ ܠܹܐ ܡܵܨܹܝܬܘܿܢ ܥܵܒ݂ܕܝܼܬܘܿܢ، ܩܵܡܘܿܕܝܼ ܒܘܼܬ ܡܸܢܕܝܼܵܢܹ̈ܐ ܐܚܹܪ̈ܢܹܐ ܒܹܐܟ݂ܵܠܵܐ ܝܬܘܿܢ ܚܲܡ؟ ");
INSERT INTO aii_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","”ܓܲܫܩܘܼܢ ܒܫܘܿܫܲܢܹ̈ܐ ܕܵܐܟ݂ܝܼ ܟܹܐ ܓܲܪܘܸܣܝܼ. ܠܹܐ ܦܵܠܚܝܼ ܘܠܹܐ ܥܵܙܠܝܼ. ܐܝܼܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܘܼܦ ܫܠܹܝܡܘܿܢ ܒܟܠܹܗ ܚܸܩܪܹܗ ܠܹܐ ܝܗܘܵܐ ܠܒ݂ܝܼܫܵܐ ܐܲܝܟ݂ ܚܲܕ ܡܸܢܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","”ܐܸܢ ܐܲܠܵܗܵܐ ܗܵܕܟ݂ܵܐ ܟܹܐ ܡܲܠܒܸܫ ܠܓܸܠܵܐ ܕܐܸܕܝܘܿܡ ܒܚܲܩܠܵܐ ܝܠܹܗ، ܘܩܲܝܕܵܡܬܵ‌ܐ ܟܹܐ ܦܵܐܹܫ ܕܸܪܝܵܐ ܒܬܲܢܘܼܪܵܐ، ܟܡܵܐ ܒܘܼܫ ܙܵܘܕܵܐ ܒܸܬ ܡܲܠܒܸܫ ܠܵܘܟ݂ܘܿܢ ܐܲܚܬܘܿܢ ܝܵܐ ܒܵܨܘܿܪܹ̈ܐ ܕܗܲܝܡܵܢܘܼܬܵ‌ܐ؟ ");
INSERT INTO aii_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","”ܐܲܚܬܘܿܢ ܠܵܐ ܬܲܚܡܸܢܝܼܬܘܿܢ ܡܘܼܕܝܼ ܒܸܬ ܐܵܟ݂ܠܝܼܬܘܿܢ، ܝܲܢ ܡܘܼܕܝܼ ܒܸܬ ܫܵܬܹܝܬܘܿܢ. ܠܵܐ ܫܵܓ݂ܫܝܼ ܚܘܼܫܵܒ݂ܵܘ̈ܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","”ܣܵܒܵܒ ܐܲܢܹܐ ܟܠܵܝܗ‌ܝ ܐܸܡܘܵܬܹ̈‌ܐ ܕܥܵܠܡܵܐ ܟܹܐ ܛܵܥܝܼ ܒܵܬܪܵܝܗ‌ܝ. ܐܝܼܢܵܐ ܒܵܒܵܘܟ݂ܘܿܢ ܟܹܐ ܝܵܕܹܥ ܕܐܘܼܦ ܐܲܚܬܘܿܢ ܣܢܝܼܩܹܐ ܝܬܘܿܢ ܥܲܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","”ܐܝܼܢܵܐ ܛܠܘܿܒܘܼܢ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ، ܘܟܠܵܝܗ‌ܝ ܐܲܢܹܐ ܒܸܬ ܦܵܝܫܝܼ ܡܘܼܙܝܸܕܹܐ ܐܸܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","”ܠܵܐ ܙܵܕܥܹܬ ܝܵܐ ܦܸܣܩܵܐ ܙܥܘܿܪܵܐ، ܣܵܒܵܒ ܒܣܝܼܡ ܠܵܗ̇ ܠܹܗ ܒܵܒܵܘܟ݂ܘܿܢ ܕܝܵܗܒܹܠܔ ܠܵܘܟ݂ܘܿܢ ܡܲܠܟܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","”ܙܲܒܢܘܼܢ ܡܸܢܕܝܼܵܘܟ݂ܘܿܢ ܘܗܲܒ݂ܠܘܼܢ ܐܸܪܘܵܢܵܐ. ܥܒ݂ܘܿܕܘܼܢ ܠܵܘܟ݂ܘܿܢ ܟܝܼܣܝܵܬܹ̈‌ܐ ܕܠܹܐ ܒܵܠܝܼ، ܘܣܝܼܡܬܵ‌ܐ ܒܫܡܲܝܵܐ ܕܠܹܐ ܬܵܝܡܵܐ، ܐܲܝܟܵܐ ܕܓܹܢܵܒ݂ܵܐ ܠܹܐ ܩܲܪܒܸܢ، ܘܡܪܲܝܬܵ‌ܐ ܠܹܐ ܡܲܚܪܸܒ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","”ܣܵܒܵܒ ܐܲܝܟܵܐ ܕܝܼܠܵܗ̇ ܣܝܼܡܬܵܘܟ݂ܘܿܢ، ܬܵܡܵܐ ܒܸܬ ܗܵܘܹܐ ܐܘܼܦ ܠܸܒܵܘܟ݂ܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","”ܗܵܘܝܼ ܚܲܨܵܘ̈ܟ݂ܘܿܢ ܐܣܝܼܪܹ̈ܐ ܘܫܪ̈ܵܓ݂ܵܬܵܘܟ݂ܘܿܢ ܒܲܗܪܘܼܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","”ܗܘܹܝܡܘܼܢ ܗܕܝܼܪܹܐ ܐܲܝܟ݂ ܐܢܵܫܹ̈ܐ ܕܒܸܣܦܵܪܵܐ ܠܡܵܪܵܝܗ‌ܝ. ܐܝܼܡܲܢ ܕܕܵܐܹܪ ܡ̣ܢ ܚܠܘܼܠܵܐ ܘܬܲܩܬܸܩ ܠܬܲܪܥܵܐ، ܒܓ̰ܲܠܕܘܼܬܵ‌ܐ ܦܵܬܚܝܼ ܠܹܗ ܐܸܠܹܗ ܬܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","”ܛܘܼܒ݂ܵܐ ܠܐܵܢܝܼ ܪܹ̈ܓܵܘܵܬܹ‌ܐ ܐܝܼܡܲܢ ܕܐܵܬܹ‌ܐ ܡܵܪܵܝܗ‌ܝ ܘܡܲܫ݇ܟ̰ܸܚ ܠܗܘܿܢ ܪܥܝܼܫܹܐ. ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܒܸܬ ܡܲܬܸܒ݂ ܠܗܘܿܢ ܘܗ̇ܘ ܒܸܬ ܗܲܕܸܪ ܓܵܢܹܗ ܘܥܵܒܹܕ ܠܗܘܿܢ ܚܸܠܡܲܬ. ");
INSERT INTO aii_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","”ܘܐܸܢ ܐܵܬܹ‌ܐ ܒܒܲܕܠܵܐ ܕܬܪܹܝ ܝܲܢ ܕܬܠܵܬܵ‌ܐ ܘܡܲܫ݇ܟ̰ܸܚ ܠܗܘܿܢ ܗܕܝܼܪܹܐ، ܛܘܼܒ݂ܵܐ ܠܐܵܢܝܼ ܪܹ̈ܓܵܘܵܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","”ܝܕܹܥܡܘܼܢ ܐܵܗܵܐ، ܐܸܢ ܝܵܕܹܥ ܗܘܵܐ ܡܵܪܵܐ ܕܒܲܝܬܵ‌ܐ ܒܐܲܝܢܝܼ ܣܵܥܲܬ ܒܸܬ ܐܵܬܹ‌ܐ ܗܘܵܐ ܓܹܢܵܒ݂ܵܐ، ܒܸܬ ܦܵܐܹܫ ܗܘܵܐ ܪܥܝܼܫܵܐ ܘܠܹܐ ܫܵܒܹܩ ܗܘܵܐ ܕܦܵܐܹܫ ܗܘܵܐ ܒܙܝܼܥܵܐ ܒܲܝܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","”ܐܘܼܦ ܐܲܚܬܘܿܢ ܗܘܹܝܡܘܼܢ ܗܵܕܟ݂ܵܐ ܗܕܝܼܪܹܐ، ܣܵܒܵܒ ܒܣܵܥܲܬ ܕܠܹܐ ܚܵܫܒ݂ܝܼܬܘܿܢ ܒܸܬ ܐܵܬܹ‌ܐ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ܒܘܼܩܸܪܹܗ ܡܸܢܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ: ”ܡܵܪܲܢ، ܐܸܠܲܢ ܝܼܘܸܬ ܒܹܐܡܵܪܵܐ ܐܵܗܵܐ ܡܲܬܠܵܐ ܝܲܢ ܠܟܠܔ ܐܢܵܫܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ ܡܵܪܲܢ: ”ܡܵܢܝܼ ܝܠܹܗ ܡܕܲܒܪܵܢܵܐ ܡܗܘܼܡܢܵܐ ܘܚܲܟܝܼܡܵܐ ܕܡܲܩܸܡ ܠܹܗ ܡܵܪܹܗ ܥܲܠܔ ܒܢܲܝ̈ ܒܲܝܬܹܗ ܕܝܵܗܒܹܠܔ ܠܗܘܿܢ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ ܒܥܕܵܢܘܼܗ̇؟ ");
INSERT INTO aii_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","”ܛܘܼܒ݂ܵܐ ܠܗ̇ܘ ܪܹܓܵܐ ܕܐܵܬܹ‌ܐ ܡܵܪܹܗ ܘܡܲܫ݇ܟ̰ܸܚ ܠܹܗ ܒܸܥܒ݂ܵܕܵܐ ܗܵܕܟ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","”ܒܫܲܪܝܼܪܘܼܬܵ‌ܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܒܸܬ ܥܵܒܹܕ ܠܹܗ ܡܕܲܒܪܵܢܵܐ ܕܟܠܹܗ ܡܸܢܕܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","”ܐܝܼܢܵܐ ܐܸܢ ܐܵܡܹܪ ܗ̇ܘ ܪܹܓܵܐ ܒܓܵܢܹܗ: ’ܡܵܪܝܼ ܥܘܼܪܩܸܠܔ ܠܹܗ ܠܹܐܬܵܝܵܐ،‘ ܘܫܲܪܹܐ ܠܸܡܚܵܝܵܐ ܠܪܹ̈ܓܵܘܵܬܹ‌ܐ ܘܠܚܸܕܲܡܝܵܬܹ̈‌ܐ، ܘܫܲܪܹܐ ܠܹܐܟ݂ܵܠܵܐ ܘܠܸܫܬܵܝܵܐ ܘܠܸܪܘܵܝܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","”ܒܸܬ ܐܵܬܹ‌ܐ ܡܵܪܵܐ ܕܗ̇ܘ ܪܹܓܵܐ ܒܝܵܘܡܵܐ ܕܠܹܐ ܚܵܫܹܒ݂ ܘܒܣܵܥܲܬ ܕܠܹܐ ܝܵܕܹܥ، ܘܒܸܬ ܩܵܛܹܠܔ ܠܹܗ، ܘܒܸܬ ܚܲܫܒܸܢܹܗ ܥܲܡ ܕܐܵܢܝܼ ܠܵܐ ܡܗܘܼܡܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","”ܪܹܓܵܐ ܕܝܵܕܹܥ ܨܸܒ݂ܝܵܢܵܐ ܕܡܵܪܹܗ ܐܝܼܢܵܐ ܠܵܐ ܗܲܕܸܪ ܓܵܢܹܗ ܘܠܵܐ ܥܵܒܹܕ ܐܲܝܟ݂ ܕܡܵܪܹܗ ܒܵܥܹܐ، ܒܸܬ ܦܵܐܹܫ ܡܸܚܝܵܐ ܪܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","”ܐܝܼܢܵܐ ܗ̇ܘ ܕܠܹܐ ܝܵܕܹܥ ܘܥܵܒܹܕ ܡܸܢܕܝܼ ܕܚܵܫܹܚ ܠܡܚܵܝܬܵ‌ܐ، ܒܵܨܘܿܪܵܐ ܒܸܬ ܦܵܐܹܫ ܡܸܚܝܵܐ. ܣܵܒܵܒ ܡ̇ܢ ܕܦܝܼܫ ܠܹܗ ܝܘܼܗܒ݂ܵܐ ܐܸܠܹܗ ܪܵܒܵܐ، ܪܵܒܵܐ ܒܸܬ ܦܵܐܹܫ ܛܠܝܼܒܵܐ ܡܸܢܹܗ، ܘܠܗ̇ܘ ܕܦܝܼܫ ܠܹܗ ܣܘܼܦܝܵܐ ܐܸܠܹܗ ܪܵܒܵܐ، ܪܵܒܵܐ ܒܸܬ ܛܵܠܒܝܼ ܡܸܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","”ܐܬܹ‌ܐ ܠܝܼ ܕܕܵܪܹܝܢ ܢܘܼܪܵܐ ܠܐܲܪܥܵܐ، ܘܟܡܵܐ ܒܸܬ ܒܵܣܡܵܐ ܗܘܵܐ ܠܝܼ ܐܸܢ ܡ̣ܢ ܓ̰ܲܠܕܹܐ ܗܵܘܹܐ ܗܘܵܐ ܒܸܠܗܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","”ܡܲܥܡܘܿܕܝܼܬܵ‌ܐ ܐܝܼܬ ܠܝܼ ܕܦܵܝܫܹܢ ܡܘܼܥܡܸܕܵܐ ܒܝܼܘܼܗ̇، ܘܪܵܒܵܐ ܓ̰ܲܢܓ̰ܘܼܪܹܐ ܝܘܸܢ ܗܲܠܔ ܕܬܲܡܸܡܸܢܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","”ܒܸܚܫܵܒ݂ܵܐ ܝܬܘܿܢ ܐܬܹ‌ܐ ܠܝܼ ܕܕܵܪܹܝܢ ܫܠܵܡܵܐ ܠܐܲܪܥܵܐ؟ ܠܵܐ، ܐܸܠܵܐ ܐܬܹ‌ܐ ܠܝܼ ܕܕܵܪܹܝܢ ܦܘܼܠܵܓ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","”ܡ̣ܢ ܐܵܕܝܼܵܐ ܒܸܬ ܗܵܘܝܼ ܚܲܡܫܵܐ ܓܵܘ ܚܲܕ ܒܲܝܬܵ‌ܐ، ܬܠܵܬܵ‌ܐ ܒܸܬ ܗܵܘܝܼ ܕܲܠܩܘܼܒ݂ܠܔ ܕܬܪܹܝ، ܘܬܪܹܝ ܕܲܠܩܘܼܒ݂ܠܔ ܬܠܵܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","”ܒܸܬ ܩܵܐܹܡ ܒܵܒܵܐ ܕܲܠܩܘܼܒ݂ܠܔ ܕܒܪܘܿܢܵܐ، ܘܒܪܘܿܢܵܐ ܕܲܠܩܘܼܒ݂ܠܔ ܕܒܵܒܘܼܗ‌ܝ، ܝܸܡܵܐ ܕܲܠܩܘܼܒ݂ܠܔ ܕܒܪܵܬܘܼܗ̇، ܘܒܪܵܬܵ‌ܐ ܕܲܠܩܘܼܒ݂ܠܔ ܕܝܸܡܘܼܗ̇، ܚܡܵܬܵ‌ܐ ܕܲܠܩܘܼܒ݂ܠܔ ܕܟܵܠܬܘܼܗ̇، ܘܟܵܠܬܵ‌ܐ ܕܲܠܩܘܼܒ݂ܠܔ ܕܚܡܵܬܘܼܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܠܟܸܢܫܹ̈ܐ: ”ܐܝܼܡܲܢ ܕܚܵܙܹܝܬܘܿܢ ܥܢܵܢܵܐ ܒܹܐܣܵܩܵܐ ܡ̣ܢ ܡܲܥܪܒ݂ܵܐ، ܟܹܐ ܐܵܡܪܝܼܬܘܿܢ: ’ܒܸܬ ܐܵܬܝܵܐ ܡܸܛܪܵܐ،‘ ܘܟܹܐ ܐܵܬܝܵܐ ܡܸܛܪܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","”ܘܐܝܼܡܲܢ ܕܡܵܚܹܐ ܦܵܘܚܵܐ ܕܬܲܝܡܢܵܐ، ܟܹܐ ܐܵܡܪܝܼܬܘܿܢ: ’ܒܸܬ ܗܵܘܹܐ ܚܸܡܵܐ،‘ ܘܟܹܐ ܗܵܘܹܐ ܚܸܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","”ܝܵܐ ܡܲܫܦܸܪ̈ܵܢܹܐ، ܦܵܬܵ‌ܐ ܕܐܲܪܥܵܐ ܘܕܫܡܲܝܵܐ ܟܹܐ ܝܵܕܥܝܼܬܘܿܢ ܕܦܵܪܫܝܼܬܘܿܢ، ܐܝܼܢܵܐ ܕܵܐܟ݂ܝܼ ܠܹܐ ܝܬܘܿܢ ܒܸܦܪܵܫܵܐ ܠܐܵܗܵܐ ܙܲܒ݂ܢܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","”ܘܩܵܡܘܿܕܝܼ ܒܓܵܢܵܘܟ݂ܘܿܢ ܠܹܐ ܝܬܘܿܢ ܒܸܕܝܵܢܵܐ ܕܝܵܢܬܵ‌ܐ ܕܙܲܕܝܼܩܘܼܬܵ‌ܐ؟ ");
INSERT INTO aii_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","”ܐܝܼܡܲܢ ܕܐܵܙܹܠ݇ܬ ܥܲܡ ܕܸܫ̃ܡܸܢܘܼܟ݂ ܠܕܝܼܘܵܢ، ܗܸܫ ܐܲܢ݇ܬ ܥܲܡܹܗ ܝܘܸܬ ܒܐܘܼܪܚܵܐ، ܓ̰ܲܪܸܒ ܕܣܲܙܓܸܪܸܬ ܥܲܡܹܗ ܩܵܐ ܕܦܲܪܩܸܬ ܡܸܢܹܗ، ܕܠܵܐ ܠܲܒܸܠܔ ܠܘܼܟ݂ ܠܟܸܣ ܕܲܝܵܢܵܐ، ܘܕܲܝܵܢܵܐ ܣܲܦܹܐ ܠܘܼܟ݂ ܠܢܵܛܘܿܪܵܐ، ܘܢܵܛܘܿܪܵܐ ܕܵܪܹܐ ܠܘܼܟ݂ ܓܵܘ ܒܹܝܬ ܐܲܣܝܼܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","”ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܘܼܟ݂، ܕܠܹܐ ܦܵܠܛܹܬ ܡ̣ܢ ܬܵܡܵܐ ܗܲܠܔ ܕܦܵܪܥܹܬ ܙܘܼܙܵܐ ܐܚܵܪܵܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ܒܗ̇ܝ ܥܕܵܢܵܐ ܐܬܹ‌ܐ ܠܗܘܿܢ ܐܢܵܫܹ̈ܐ ܘܐܡܝܼܪܗܘܿܢ ܠܝܼܫܘܿܥ ܒܘܼܬ ܓܠܝܼܠܵܝܹ̈ܐ، ܐܵܢܝܼ ܕܦܝܼܠܵܛܘܿܣ ܓܒ݂ܝܼܠܔ ܠܹܗ ܕܸܡܵܝܗ‌ܝ ܒܕܸܒ݂ܚܵܝ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܒܸܚܫܵܒ݂ܵܐ ܝܬܘܿܢ ܕܐܵܢܝܼ ܓܠܝܼܠܵܝܹ̈ܐ ܒܘܼܫ ܚܲܛܵܝܹ̈ܐ ܝܗܘܵܘ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܓܠܝܼܠܵܝܹ̈ܐ ܕܗܵܕܟ݂ܵܐ ܩܘܼܘܸܡ ܠܹܗ ܐܸܠܵܝܗ‌ܝ؟ ");
INSERT INTO aii_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","”ܠܵܐ. ܐܝܼܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܘܼܦ ܐܲܚܬܘܿܢ ܗܵܕܟ݂ܵܐ ܒܸܬ ܛܵܠܩܝܼܬܘܿܢ ܐܸܢ ܠܵܐ ܬܲܘܸܒܝܼܬܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","”ܝܲܢ ܐܵܢܝܼ ܬܡܵܢܸܥܣܲܪ ܕܢܦܝܼܠܔ ܠܹܗ ܥܲܠܵܝܗ‌ܝ ܒܘܼܪܓ̰ܵܐ ܒܫܝܼܠܘܿܚܵܐ، ܘܩܛܝܼܠܵܝ ܠܹܗ، ܒܸܚܫܵܒ݂ܵܐ ܝܬܘܿܢ ܒܘܼܫ ܚܲܛܵܝܹ̈ܐ ܝܗܘܵܘ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܥܵܡܪ̈ܵܢܹܐ ܕܓܵܘ ܐܘܿܪܸܫܠܸܡ؟ ");
INSERT INTO aii_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","”ܠܵܐ. ܐܝܼܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܸܢ ܠܵܐ ܬܲܘܸܒܝܼܬܘܿܢ، ܟܠܵܘܟ݂ܘܿܢ ܗܵܕܟ݂ܵܐ ܒܸܬ ܛܵܠܩܝܼܬܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܐܵܗܵܐ ܡܲܬܠܵܐ: ”ܚܲܕ ܐܢܵܫܵܐ ܐܝܼܬ ܗܘܵܐ ܠܹܗ ܚܲܕ ܐܝܼܠܵܢܵܐ ܕܬܹܐܢܹ̈ܐ ܢܨܝܼܒ݂ܵܐ ܓܵܘ ܟܲܪܡܹܗ. ܐܬܹ‌ܐ ܠܹܗ ܒܸܛܥܵܝܵܐ ܒܝܼܹܗ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܘܠܵܐ ܡܘܼܫ݇ܟ̰ܸܚ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","”ܐܡܝܼܪܹܗ ܠܦܲܠܵܚܵܐ: ’ܐܲܢܹܐ ܬܠܵܬ ܫܸܢܹ̈ܐ ܒܹܐܬܵܝܵܐ ܝܘܸܢ ܒܸܛܥܵܝܵܐ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܒܐܵܗܵܐ ܐܝܼܠܵܢܵܐ ܕܬܹܐܢܹ̈ܐ ܘܠܹܐ ܝܘܸܢ ܡܲܫ݇ܟ̰ܘܼܚܹܐ. ܦܪܘܿܡ ܠܹܗ. ܩܵܡܘܿܕܝܼ ܡܲܒܛܘܼܠܹܐ ܝܠܹܗ ܠܐܲܪܥܵܐ؟‘ ");
INSERT INTO aii_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","”ܓ̰ܘܼܘܸܒ ܠܹܗ ܦܲܠܵܚܵܐ: ’ܡܵܪܝܼ، ܫܒ݂ܘܿܩ ܠܹܗ ܐܘܼܦ ܐܵܗܵܐ ܫܹܢ݇ܬܵ‌ܐ، ܗܲܠܔ ܕܚܵܦܪܹܢ ܚܵܕܸܪ̈ܘܵܢܘܼܗ‌ܝ ܘܕܵܪܹܝܢ ܙܸܒܠܵܐ ܬܚܘܿܬܘܼܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","”’ܩܵܘܡܵܐ ܕܥܵܒܹܕ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܒܕܲܥܬܝܼܕ، ܘܐܸܢ ܠܵܐ، ܗ̇ܝܓܵܗ ܦܵܪܡܹܬ ܠܹܗ.‘“ ");
INSERT INTO aii_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ܡܲܠܘܼܦܹܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ ܓܵܘ ܚܕܵܐ ܡ̣ܢ ܟܢܘܼܫܝܵܬܹ̈‌ܐ، ");
INSERT INTO aii_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ܘܗܵܐ، ܐܝܼܬ ܗܘܵܐ ܚܕܵܐ ܒܲܟ݂ܬܵ‌ܐ ܬܵܡܵܐ ܕܐܝܼܬ ܗܘܵܐ ܠܵܗ̇ ܪܘܼܚܵܐ ܕܡܲܪܥܵܐ ܬܡܵܢܸܥܣܲܪ ܫܸܢܹ̈ܐ. ܟܝܼܦܬܵ‌ܐ ܝܗܘܵܐ ܘܠܹܐ ܡܵܨܝܵܐ ܗܘܵܐ ܟܵܠܝܵܐ ܦܫܝܼܩܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ܚܸܙܝܵܐ ܠܹܗ ܝܼܫܘܿܥ، ܩܸܪܝܵܐ ܠܹܗ ܠܟܸܣܠܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇: ”ܒܲܟ݂ܬܵ‌ܐ، ܦܘܼܫܝ ܒܣܝܼܡܬܵ‌ܐ ܡ̣ܢ ܡܲܪܥܵܟ݂ܝ.“ ");
INSERT INTO aii_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ܡܘܼܬܸܒ݂ ܠܹܗ ܐܝܼܕܹܗ ܥܲܠܘܼܗ̇، ܘܒܗ̇ܝ ܥܕܵܢܵܐ ܦܫܝܼܩ ܠܵܗ̇، ܘܫܘܼܒܸܚ ܠܵܗ̇ ܠܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ܐܝܼܢܵܐ ܓܘܼܪܵܐ ܕܟܢܘܼܫܬܵ‌ܐ، ܟܲܕ ܚܙܹܐ ܠܹܗ ܕܒܘܼܣܸܡ ܠܹܗ ܝܼܫܘܿܥ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ، ܓ̰ܘܼܘܸܒ ܠܹܗ ܒܟܲܪܒܵܐ ܠܟܸܢܫܹ̈ܐ ܘܐܡܝܼܪܹܗ: ”ܫܬܵ‌ܐ ܝܵܘܡܵܢܹ̈ܐ ܐܝܼܬ ܠܸܦܠܵܚܵܐ، ܒܐܲܢܹܐ ܝܵܘܡܵܢܹ̈ܐ ܐܵܬܹܝܬܘܿܢ ܘܦܵܝܫܝܼܬܘܿܢ ܒܣܝܼܡܹܐ، ܘܠܵܐ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ܓ̰ܘܼܘܸܒ ܠܹܗ ܡܵܪܲܢ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܝܵܐ ܡܲܫܦܸܪ̈ܵܢܹܐ، ܟܠܔ ܚܲܕ ܡܸܢܵܘܟ݂ܘܿܢ ܠܹܐ ܫܵܪܹܐ ܬܵܘܪܹܗ ܝܲܢ ܚܡܵܪܹܗ ܡ̣ܢ ܐܘܼܪܹܐ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ ܘܠܲܒܸܠܔ ܠܹܗ ܕܡܲܫܬܹ‌ܐ ܠܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","”ܐܵܗܵܐ ܒܪܵܬܵ‌ܐ ܕܐܲܒ݂ܪܵܗܵܡ، ܐܣܝܼܪܵܐ ܠܹܗ ܣܵܛܵܢܵܐ ܬܡܵܢܸܥܣܲܪ ܫܸܢܹ̈ܐ، ܠܹܐ ܝܗܘܵܐ ܐܵܢܲܢܩܵܝܬܵ‌ܐ ܕܦܵܝܫܵܐ ܗܘܵܐ ܫܪܝܼܬܵ‌ܐ ܡ̣ܢ ܐܵܗܵܐ ܐܸܣܘܼܪܵܐ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ܟܲܕ ܗܲܡܙܸܡ ܗܘܵܐ ܗܵܕܟ݂ܵܐ ܢܵܟ݂ܦܝܼ ܗܘܵܘ ܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܩܵܝܡܝܼ ܗܘܵܘ ܠܕܲܠܩܘܼܒ݂ܠܹܗ. ܐܝܼܢܵܐ ܟܠܹܗ ܟܸܢܫܵܐ ܟܹܐ ܚܵܕܹܐ ܗܘܵܐ ܒܟܠܵܝܗ‌ܝ ܕܘܼܡܵܪܹ̈ܐ ܕܥܵܒܹܕ ܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ: ”ܠܡܘܼܕܝܼ ܟܹܐ ܕܵܡܝܵܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ، ܘܠܡܘܼܕܝܼ ܡܲܕܡܸܢܵܗ̇؟ ");
INSERT INTO aii_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","”ܟܹܐ ܕܵܡܝܵܐ ܠܕܲܢܕܸܟܬܵ‌ܐ ܕܚܲܪܕܲܠܔ ܕܫܩܝܼܠܵܐ ܠܹܗ ܐܢܵܫܵܐ ܘܙܪܝܼܥܵܐ ܠܹܗ ܒܓܲܢܬܹܗ، ܓܘܼܪܘܸܣ ܠܵܗ̇ ܘܗܘܹܐ ܠܵܗ̇ ܐܝܼܠܵܢܵܐ ܓܘܼܪܵܐ، ܘܛܲܝܪܹ̈ܐ ܕܫܡܲܝܵܐ ܒܢܹܐ ܠܗܘܿܢ ܩܸܢܵܐ ܒܦܲܥܘܵܢܘܼ̈ܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ܡܸܢܕܪܸܫ ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ: ”ܠܡܘܼܕܝܼ ܡܲܕܡܸܢܵܗ̇ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","”ܟܹܐ ܕܵܡܝܵܐ ܠܚܡܝܼܪܵܐ، ܗ̇ܘ ܕܫܩܝܼܠܔ ܠܵܗ̇ ܒܲܟ݂ܬܵ‌ܐ ܘܡܘܼܬܸܒ݂ ܠܵܗ̇ ܓܵܘ ܬܠܵܬܵ‌ܐ ܟܝܘܼܠܹ̈ܐ ܕܩܲܡܚܵܐ ܗܲܠܔ ܕܚܡܝܼܥ ܠܹܗ ܟܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ܡܲܠܘܼܦܹܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܓܵܘ ܡܵܬܘܵܬܹ̈‌ܐ ܘܡܕܝܼܢܵܬܹ̈‌ܐ، ܒܐܘܼܪܚܹܗ ܟܲܕ ܒܹܐܙܵܠܵܐ ܠܐܘܿܪܸܫܠܸܡ. ");
INSERT INTO aii_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ ܚܲܕ ܐܢܵܫܵܐ: ”ܡܵܪܲܢ، ܒܵܨܘܿܪܹ̈ܐ ܝܢܵܐ ܐܵܢܝܼ ܕܦܵܪܩܝܼ؟“ ܘܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ: ");
INSERT INTO aii_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","”ܓ̰ܲܪܒܘܼܢ ܠܸܥܒ݂ܵܪܵܐ ܒܬܲܪܥܵܐ ܥܝܼܩܵܐ، ܣܵܒܵܒ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܪܵܒܵܐ ܒܸܬ ܒܵܥܝܼ ܠܸܥܒ݂ܵܪܵܐ ܘܠܹܐ ܡܵܨܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","”ܐܝܼܡܲܢ ܕܩܵܐܹܡ ܡܵܪܵܐ ܕܒܲܝܬܵ‌ܐ ܘܕܵܒܹܪ ܬܲܪܥܵܐ، ܗ̇ܝܓܵܗ ܒܸܬ ܫܲܪܹܝܬܘܿܢ ܠܸܟܠܵܝܵܐ ܠܒܲܕܲܪ ܘܬܲܩܬܘܼܩܹܐ ܠܬܲܪܥܵܐ ܘܒܹܐܡܵܪܵܐ: ’ܡܵܪܲܢ، ܡܵܪܲܢ، ܦܬܘܿܚ ܬܲܪܥܵܐ ܐܸܠܲܢ.‘ ܘܗ̇ܘ ܒܸܬ ܓ̰ܲܘܸܒ ܐܸܠܵܘܟ݂ܘܿܢ: ’ܠܹܐ ܝܵܕܥܹܢܵܘܟ݂ܘܿܢ، ܡ̣ܢ ܐܲܝܟܵܐ ܝܬܘܿܢ.‘ ");
INSERT INTO aii_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","”ܗ̇ܝܓܵܗ ܒܸܬ ܫܲܪܹܝܬܘܿܢ ܠܹܐܡܵܪܵܐ: ’ܠܟܸܣܠܘܼܟ݂ ܐܟ݂ܝܼܠܔ ܠܲܢ ܘܫܬܹ‌ܐ ܠܲܢ، ܘܒܥܵܠܘܿܠܵܢܲܢ̈ ܡܘܼܠܸܦ ܠܘܼܟ݂.‘ ");
INSERT INTO aii_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","”ܘܗ̇ܘ ܒܸܬ ܓ̰ܲܘܸܒ ܠܵܘܟ݂ܘܿܢ: ’ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ ܕܠܹܐ ܝܵܕܥܹܢ ܡ̣ܢ ܐܲܝܟܵܐ ܝܬܘܿܢ. ܪܚܘܿܩܘܼܢ ܡܸܢܝܼ ܝܵܐ ܦܲܠܵܚܹ̈ܐ ܕܥܵܘܠܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","”ܬܵܡܵܐ ܒܸܬ ܗܵܘܹܐ ܒܸܟ݂ܝܵܐ ܘܚܲܪܚܲܟ̰ܬܵ‌ܐ ܕܟܹܟܹ̈ܐ ܐܝܼܡܲܢ ܕܚܵܙܹܝܬܘܿܢ ܠܐܲܒ݂ܪܵܗܵܡ ܘܠܐܝܼܣܚܵܩ ܘܠܝܲܥܩܘܿܒ݂ ܘܠܟܠܵܝܗ‌ܝ ܢܒ݂ܝܼܹ̈ܐ ܓܵܘ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ، ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ ܦܝܼܫܹܐ ܛܪܝܼܕܹܐ ܠܒܲܕܲܪ. ");
INSERT INTO aii_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","”ܒܸܬ ܐܵܬ‌ܝܼ ܡ̣ܢ ܡܲܕܢܚܵܐ ܘܡ̣ܢ ܡܲܥܪܒ݂ܵܐ ܘܡ̣ܢ ܬܲܝܡܢܵܐ ܘܡ̣ܢ ܓܲܪܒܝܵܐ، ܘܒܸܬ ܝܵܬܒ݂ܝܼ ܓܵܘ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","”ܘܗܵܐ ܐܚܵܪ̈ܵܝܹܐ ܒܸܬ ܗܵܘܝܼ ܩܲܕܡܵܝܹ̈ܐ، ܘܩܲܕܡܵܝܹ̈ܐ ܒܸܬ ܗܵܘܝܼ ܐܚܵܪ̈ܵܝܹܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ܒܗ̇ܘ ܝܵܘܡܵܐ ܐܬܹ‌ܐ ܠܗܘܿܢ ܐܢܵܫܹ̈ܐ ܡ̣ܢ ܦܪ̈ܝܼܫܹܐ ܘܐܡܝܼܪܗܘܿܢ ܠܝܼܫܘܿܥ: ”ܦܠܘܿܛ ܘܙܹܠܔ݇ ܡܐܲܟ݂ܵܐ، ܣܵܒܵܒ ܗܹܪܘܿܕܸܣ ܒܵܥܹܐ ܕܩܵܛܹܠܔ ܠܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܙܹܠ݇ܡܘܼܢ ܘܐܡܘܿܪܘܼܢ ܠܗ̇ܘ ܬܲܥܠܵܐ، ܐܵܢܵܐ ܦܲܠܘܼܛܹܐ ܝܘܸܢ ܫܹܐܕܹ̈ܐ ܘܒܲܣܘܼܡܹܐ ܝܘܸܢ ܐܸܕܝܘܿܡ ܘܩܲܝܕܵܡܬܵ‌ܐ، ܘܒܝܵܘܡܵܐ ܕܬܠܵܬܵ‌ܐ ܒܸܬ ܬܲܡܸܡܸܢ ܦܘܼܠܚܵܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","”ܐܝܼܢܵܐ ܘܵܠܹܐ ܝܠܵܗ̇ ܐܸܠܝܼ ܕܐܸܕܝܘܿܡ ܘܩܲܝܕܵܡܬܵ‌ܐ ܘܝܵܘܡܵܐ ܐܚܹܪܢܵܐ ܦܵܠܚܹܢ، ܣܵܒܵܒ ܢܒ݂ܝܼܹ̈ܐ ܟܹܐ ܦܵܝܫܝܼ ܩܛܝܼܠܹܐ ܐܲܚܟ̰ܝܼ ܓܵܘ ܐܘܿܪܸܫܠܸܡ. ");
INSERT INTO aii_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","”ܝܵܐ ܐܘܿܪܸܫܠܸܡ، ܐܘܿܪܸܫܠܸܡ، ܩܵܛܠܵܢܬܵ‌ܐ ܕܢܒ݂ܝܼܹ̈ܐ ܘܪܵܓ̰ܡܵܢܬܵ‌ܐ ܕܐܵܢܝܼ ܕܝܼܢܵܐ ܫܘܼܕܪܹܐ ܠܟܸܣܠܘܼܗ̇، ܟܡܵܐ ܓܵܗܹ̈ܐ ܒܣܝܼܡ ܠܵܗ̇ ܠܝܼ ܕܓ̰ܲܡܥܸܢ ܒܢܘܿܢܵܟ݂ܝ̈ ܐܲܝܟ݂ ܟܬܵܝܬܵ‌ܐ ܕܓ̰ܲܡܥܵܐ ܙܲܥܝܘܼ̈ܗ̇ ܬܚܘܿܬ ܓܘܼܠܦܵܢܘܼ̈ܗ̇، ܘܐܲܚܬܘܿܢ ܠܵܐ ܒܣܝܼܡ ܠܵܗ̇ ܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","”ܒܸܬ ܦܵܐܹܫ ܫܒ݂ܝܼܩܵܐ ܒܲܝܬܵܘܟ݂ܘܿܢ ܚܵܪܵܒܵܐ. ܫܲܪܝܼܪܵܐܝܼܬ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܠܹܐ ܚܵܙܹܝܬܘܿܢ ܠܝܼ ܗܲܠܔ ܕܐܵܬܝܵܐ ܥܕܵܢܵܐ ܘܐܵܡܪܝܼܬܘܿܢ: ’ܒܪܝܼܟ݂ܵܐ ܝܠܹܗ ܗ̇ܘ ܕܐܵܬܹ‌ܐ ܒܫܸܡܵܐ ܕܡܵܪܝܵܐ.‘“ ");
INSERT INTO aii_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ܥܒ݂ܝܼܪܹܗ ܝܼܫܘܿܥ ܠܒܲܝܬܵ‌ܐ ܕܚܲܕ ܡ̣ܢ ܓܘܼܪ̈ܵܢܹܐ ܕܦܪ̈ܝܼܫܹܐ ܕܐܵܟܹܠܔ ܗܘܵܐ ܠܲܚܡܵܐ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ، ܘܐܵܢܝܼ ܢܵܛܪܝܼ ܗܘܵܘ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ܘܐܝܼܬ ܗܘܵܐ ܬܵܡܵܐ ܩܲܕܡܘܼܗ‌ܝ ܚܲܕ ܐܢܵܫܵܐ ܡܪܝܼܥܵܐ، ܙܝܼܪܵܐ ܡ̣ܢ ܡ̈ܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ܒܘܼܩܸܪܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܢܵܡܘܿܣܵܝܹ̈ܐ ܘܦܪ̈ܝܼܫܹܐ ܘܐܡܝܼܪܹܗ: ”ܩܵܢܘܿܢܵܝܬܵ‌ܐ ܝܠܵܗ̇ ܠܒܲܣܘܼܡܹܐ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ ܝܲܢ ܠܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ܐܝܼܢܵܐ ܐܵܢܝܼ ܫܬܝܼܩ ܠܗܘܿܢ. ܕܒ݂ܝܼܩ ܠܹܗ ܘܒܘܼܣܸܡ ܠܹܗ ܐܸܠܹܗ ܘܫܒ݂ܝܼܩ ܠܹܗ ܕܐܵܙܹܠܔ ܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܐܲܝܢܝܼ ܡܸܢܵܘܟ݂ܘܿܢ ܐܸܢ ܢܵܦܹܠܔ ܒܪܘܿܢܹܗ ܝܲܢ ܬܵܘܪܹܗ ܓܵܘ ܒܹܐܪܵܐ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ، ܠܹܐ ܦܲܠܸܛ ܠܹܗ ܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ܘܠܵܐ ܡܨܹܐ ܠܗܘܿܢ ܓ̰ܲܘܸܒܝܼ ܐܸܠܹܗ ܒܘܼܬ ܐܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ܐܡܝܼܪܹܗ ܐܵܗܵܐ ܡܲܬܠܵܐ ܠܐܵܢܝܼ ܕܝܼܗܘܵܘ ܟ̰ܝܼܕܹܐ، ܣܵܒܵܒ ܒܸܚܙܵܝܵܐ ܝܗܘܵܐ ܕܵܐܟ݂ܝܼ ܓܲܒܘܼܝܹܐ ܝܗܘܵܘ ܕܘܼܟܵܢܹ̈ܐ ܒܪܹܝܫܵܐ ܕܡܸܫܬܘܼܝܵܬܹ̈‌ܐ. ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ");
INSERT INTO aii_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","”ܐܝܼܡܲܢ ܕܦܵܝܫܹܬ ܟ̰ܝܼܕܵܐ ܠܚܠܘܼܠܵܐ ܒܝܲܕ ܐܢܵܫܵܐ، ܠܵܐ ܝܵܬܒܹܬ ܒܪܹܝܫܵܐ ܕܡܸܫܬܘܼܬܵ‌ܐ، ܕܠܵܐ ܗܵܘܝܵܐ ܚܲܕ ܐܚܹܪܢܵܐ ܒܘܼܫ ܡܵܪܹܐ ܐܝܼܩܵܪܵܐ ܡܸܢܘܼܟ݂ ܦܵܐܹܫ ܟ̰ܝܼܕܵܐ ܬܵܡܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","”ܘܐܵܬܹ‌ܐ ܗ̇ܘ ܕܝܼܠܹܗ ܟ̰ܝܼܕܵܘܟ݂ܘܿܢ ܘܐܵܡܹܪ ܐܸܠܘܼܟ݂: ’ܗܲܒ݂ܠܔ ܕܘܼܟܘܼܟ݂ ܩܵܐ ܐܵܗܵܐ،‘ ܗ̇ܝܓܵܗ ܒܢܟܸܦܬܵ‌ܐ ܒܸܬ ܝܵܬܒܹܬ ܒܕܘܼܟܵܐ ܐܚܹܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","”ܐܝܼܡܲܢ ܕܦܵܝܫܹܬ ܟ̰ܝܼܕܵܐ، ܙܹܠܔ݇ ܘܝܬܘܿܒ݂ ܒܚܲܪܬܵ‌ܐ ܕܟܠܵܝܗ‌ܝ، ܘܐܝܼܡܲܢ ܕܐܵܬܹ‌ܐ ܗ̇ܘ ܕܟ̰ܝܼܕܘܼܟ݂ ܝܼܠܹܗ، ܒܸܬ ܐܵܡܹܪ ܐܸܠܘܼܟ݂: ’ܚܲܒ݂ܪܝܼ، ܣܘܿܩ ܥܸܠܸܠܔ.‘ ܗ̇ܝܓܵܗ ܒܸܬ ܗܵܘܹܐ ܠܘܼܟ݂ ܐܝܼܩܵܪܵܐ ܩܲܕܡ ܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܝܼܢܵܐ ܝܬܝܼܒܹܐ ܥܲܡܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","”ܣܵܒܵܒ ܟܠܔ ܕܡܲܪܸܡ ܓܵܢܹܗ ܒܸܬ ܦܵܐܹܫ ܡܘܼܟܸܦܵܐ، ܘܟܠܔ ܕܡܲܟܸܦ ܓܵܢܹܗ ܒܸܬ ܦܵܐܹܫ ܡܘܼܪܡܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ܘܐܡܝܼܪܹܗ ܠܡܵܪܵܐ ܕܒܲܝܬܵ‌ܐ: ”ܐܝܼܡܲܢ ܕܥܵܒ݂ܕܹܬ ܫܵܪܘܼܬܵ‌ܐ ܝܲܢ ܐܟ݂ܵܠ݇ܪܲܡܫܵܐ، ܠܵܐ ܟ̰ܵܝܕܹܬ ܚܲܒ݂ܪ̈ܵܘܵܬܘܼܟ݂، ܐܘܼܦ ܠܵܐ ܐܲܚܘܿܢܘܵܬܘܼ̈ܟ݂، ܝܲܢ ܚܸܙܡܵܢܘܼ̈ܟ݂، ܝܲܢ ܫܒ݂ܵܒ݂ܘܼ̈ܟ݂ ܥܲܬܝܼܪܹ̈ܐ، ܕܠܵܐ ܗܵܘܝܵܐ ܐܘܼܦ ܐܵܢܝܼ ܟ̰ܵܝܕܝܼ ܠܘܼܟ݂ ܘܡܲܕܸܪܝܼ ܠܹܗ ܦܘܼܪܥܵܢܘܼܟ݂. ");
INSERT INTO aii_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","”ܐܝܼܢܵܐ ܐܝܼܡܲܢ ܕܥܵܒ݂ܕܹܬ ܐܲܪܚܘܼܬܵ‌ܐ، ܩܪܝܼ ܠܡܸܣܟܹܢܹ̈ܐ، ܘܠܣܲܩܲܬܹ̈‌ܐ، ܘܠܫܦܝܼܠܹ̈ܐ ܘܠܣܸܡܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","”ܛܘܼܒ݂ܵܐ ܐܸܠܘܼܟ݂ ܕܠܲܝܬ ܠܗܘܿܢ ܕܦܵܪܥܝܼ ܠܘܼܟ݂، ܣܵܒܵܒ ܒܸܬ ܦܵܝܫܹܬ ܦܪܝܼܥܵܐ ܒܩܝܵܡܬܵ‌ܐ ܕܙܲܕܝܼܩܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ܚܲܕ ܡ̣ܢ ܐܵܢܝܼ ܕܝܼܗܘܵܐ ܝܬܝܼܒܹܐ، ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܹܗ ܐܲܢܹܐ ܗܹܡܸܙܡܵܢܹ̈ܐ، ܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܛܘܼܒ݂ܵܐ ܠܡ̇ܢ ܕܐܵܟܹܠܔ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ ܓܵܘ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܚܲܕ ܐܢܵܫܵܐ ܥܒ݂ܝܼܕ ܠܹܗ ܐܟ݂ܵܠ݇ܪܲܡܫܵܐ ܓܘܼܪܬܵ‌ܐ ܘܩܪܹܐ ܠܹܗ ܪܵܒܵܐ ܐܲܪ̈ܚܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","”ܘܫܘܼܕܸܪܹܗ ܪܹܓܹܗ ܒܥܕܵܢܵܐ ܕܐܟ݂ܵܠ݇ܪܲܡܫܵܐ ܕܐܵܡܹܪ ܗܘܵܐ ܠܐܵܢܝܼ ܕܝܼܗܘܵܘ ܟ̰ܝܼܕܹܐ: ’ܬܹܝܡܘܼܢ، ܐܵܕܝܼܵܐ ܟܠܔ ܡܸܢܕܝܼ ܗܘܼܕܪܵܐ ܝܠܹܗ.‘ ");
INSERT INTO aii_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","”ܘܫܘܼܪܹܐ ܠܗܘܿܢ ܚܲܕ ܒܚܲܕ ܠܸܕܒ݂ܵܩܵܐ ܡܵܗܵܢܵܐ. ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܗ̇ܘ ܩܲܕܡܵܝܵܐ: ’ܙܒ݂ܝܼܢܵܐ ܝܘܸܢ ܚܲܩܠܵܐ، ܘܵܠܹܐ ܝܠܵܗ̇ ܕܐܵܙܹܠ݇ܢ ܘܚܵܙܹܢܵܗ̇. ܒܸܒܥܵܝܵܐ ܝܘܸܢ ܡܸܢܘܼܟ݂ ܕܦܲܚܠܸܬ ܠܝܼ.‘ ");
INSERT INTO aii_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","”ܗ̇ܘ ܐܚܹܪܢܵܐ ܐܡܝܼܪܹܗ: ’ܙܒ݂ܝܼܢܵܐ ܝܘܸܢ ܚܲܡܫܵܐ ܙܵܘܓܹ̈ܐ ܬܵܘܪܹ̈ܐ، ܘܒܹܐܙܵܠܵܐ ܝܘܸܢ ܕܓ̰ܲܪܒܸܢܗܘܿܢ. ܒܸܛܠܵܒܵܐ ܝܘܸܢ ܡܸܢܘܼܟ݂ ܕܦܲܚܠܸܬ ܠܝܼ.‘ ");
INSERT INTO aii_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","”ܚܲܕ ܐܚܹܪܢܵܐ ܐܡܝܼܪܹܗ: ’ܐܵܕܝܼܵܐ ܝܘܸܢ ܓܒ݂ܝܼܪܵܐ، ܒܘܼܬ ܐܵܗܵܐ ܠܹܐ ܡܵܨܹܝܢ ܐܵܬܹܝܢ.‘ ");
INSERT INTO aii_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","”ܐܬܹ‌ܐ ܠܹܗ ܗ̇ܘ ܪܹܓܵܐ ܘܡܘܼܕܸܥ ܠܹܗ ܠܡܵܪܹܗ. ܟܪܝܼܒ ܠܹܗ ܡܵܪܵܐ ܕܒܲܝܬܵ‌ܐ، ܘܐܡܝܼܪܹܗ ܠܪܹܓܹܗ: ’ܦܠܘܿܛ ܓ̰ܲܠܕܹܐ ܠܥܵܠܘܿܠܹ̈ܐ ܘܠܩܘܼܪ̈ܢܝܼܵܬܹ‌ܐ ܕܡܕܝܼܢ݇ܬܵ‌ܐ، ܘܡܲܥܒܸܪ ܠܲܐܟ݂ܵܐ ܠܡܸܣܟܹܢܹ̈ܐ، ܘܠܣܲܩܲܬܹ̈‌ܐ، ܘܠܣܸܡܝܹ̈ܐ ܘܠܫܦܝܼܠܹ̈ܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","”ܘܐܡܝܼܪܹܗ ܪܹܓܵܐ: ’ܡܵܪܝܼ، ܥܒ݂ܝܼܕ ܠܝܼ ܐܲܝܟ݂ ܕܦܩܝܼܕ ܠܘܼܟ݂، ܘܗܸܫ ܐܝܼܬ ܕܘܼܟܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","”ܘܐܡܝܼܪܹܗ ܡܵܪܵܐ ܠܪܹܓܵܐ: ’ܦܠܘܿܛ ܠܐܘܼܪ̈ܚܵܬܹ‌ܐ ܘܠܒܹܝܬ ܣܝܵܓܹ̈ܐ، ܘܡܲܥܒܸܕ ܠܐܢܵܫܹ̈ܐ ܕܥܵܒ݂ܪܝܼ، ܕܦܵܐܹܫ ܡܸܠܝܵܐ ܒܲܝܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","”’ܣܵܒܵܒ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܘܼܦ ܚܲܕ ܡ̣ܢ ܐܵܢܝܼ ܐܢܵܫܹ̈ܐ ܕܟ̰ܝܼܕܹܐ ܝܗܘܵܘ ܠܹܐ ܛܵܥܹܡ ܠܵܗ̇ ܐܟ݂ܵܠ݇ܪܲܡܫܝܼ.‘“ ");
INSERT INTO aii_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ܟܲܕ ܒܹܐܙܵܠܵܐ ܝܗܘܵܘ ܥܲܡ ܝܼܫܘܿܥ ܟܸܢܫܹ̈ܐ ܪܵܒܵܐ، ܕܝܼܪܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ");
INSERT INTO aii_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","”ܡ̇ܢ ܕܐܵܬܹ‌ܐ ܒܵܬܪܝܼ ܘܠܵܐ ܣܵܢܹܐ ܠܒܵܒܘܼܗ‌ܝ، ܘܠܝܸܡܹܗ، ܘܠܐܲܚܘܿܢܘܵܬܘܼ̈ܗ‌ܝ ܘܠܚܵܬܘܵܬܘܼ̈ܗ‌ܝ، ܘܠܒܲܟ݂ܬܹܗ ܘܠܒܢܘܿܢܘܼ̈ܗ‌ܝ، ܘܐܘܼܦ ܠܓܵܢܹܗ، ܠܹܐ ܡܵܨܹܐ ܗܵܘܹܐ ܐܸܠܝܼ ܬܲܠܡܝܼܕܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","”ܘܡ̇ܢ ܕܠܵܐ ܫܵܩܹܠܔ ܙܩܝܼܦܹܗ ܘܐܵܬܹ‌ܐ ܒܵܬܪܝܼ، ܠܹܐ ܡܵܨܹܐ ܗܵܘܹܐ ܐܸܠܝܼ ܬܲܠܡܝܼܕܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","”ܐܲܝܢܝܼ ܡܸܢܵܘܟ݂ܘܿܢ ܐܸܢ ܒܵܥܹܐ ܒܵܢܹܐ ܒܘܼܪܓ̰ܵܐ، ܠܹܐ ܝܵܬܹܒ݂ ܩܲܕܡܵܝܬܵ‌ܐ ܘܚܲܫܒܸܢ ܢܲܦܩܵܬܘܼ̈ܗ‌ܝ، ܕܐܸܢ ܐܝܼܬ ܠܹܗ ܠܬܲܡܘܼܡܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","”ܕܠܵܐ ܗܵܘܝܵܐ ܕܡܲܬܸܒ݂ ܒܸܢܝܲܬ ܘܠܵܐ ܡܵܨܹܐ ܬܲܡܸܡ، ܘܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܚܵܙܝܼ ܠܹܗ ܫܲܪܝܼ ܡܲܣܚܘܼܪܹܐ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","”ܒܸܬ ܐܵܡܪܝܼ: ’ܐܵܗܵܐ ܐܢܵܫܵܐ ܫܘܼܪܹܐ ܠܹܗ ܠܸܒܢܵܝܵܐ ܘܠܵܐ ܡܨܹܐ ܠܹܗ ܬܲܡܸܡ.‘ ");
INSERT INTO aii_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","”ܝܲܢ ܐܲܝܢܝܼ ܡܲܠܟܵܐ ܕܐܵܙܹܠܔ ܠܸܦܠܵܫܵܐ ܠܕܲܠܩܘܼܒ݂ܠܔ ܕܚܲܕ ܡܲܠܟܵܐ ܐܚܹܪܢܵܐ، ܠܹܐ ܝܵܬܹܒ݂ ܩܲܕܡܵܝܬܵ‌ܐ ܘܚܲܫܒܸܢ ܕܐܸܢ ܡܵܨܹܐ ܒܥܸܣܪܵܐ ܐܲܠܦܹ̈ܐ ܦܵܠܹܫ ܥܲܡ ܗ̇ܘ ܕܐܵܬܹ‌ܐ ܥܲܠܘܼܗ‌ܝ ܒܥܸܣܪܝܼ ܐܲܠܦܹ̈ܐ؟ ");
INSERT INTO aii_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","”ܐܸܢ ܝܵܕܹܥ ܕܠܹܐ ܡܵܨܹܐ، ܗܸܫ ܗ̇ܘ ܪܸܚܩܵܐ ܡܸܢܹܗ، ܒܸܬ ܫܲܕܸܪ ܐܝܼܙܓܲܕܹ̈ܐ ܕܥܵܒܹܕ ܫܠܵܡܵܐ ܥܲܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","”ܘܗܵܕܟ݂ܵܐ ܟܠܔ ܚܲܕ ܡܸܢܵܘܟ݂ܘܿܢ، ܐܸܢ ܠܵܐ ܫܵܒܹܩ ܟܠܹܗ ܡܸܢܕܝܼܹܗ، ܠܹܐ ܡܵܨܹܐ ܗܵܘܹܐ ܐܸܠܝܼ ܬܲܠܡܝܼܕܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","”ܡܸܠܚܵܐ ܨܦܵܝܝܼ ܝܠܵܗ̇، ܐܝܼܢܵܐ ܐܸܢ ܦܵܝܟܵܐ ܡܸܠܚܵܐ، ܒܡܘܼܕܝܼ ܒܸܬ ܦܵܝܫܵܐ ܡܘܼܡܠܸܚܬܵ‌ܐ؟ ");
INSERT INTO aii_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","”ܠܵܐ ܩܵܐ ܐܲܪܥܵܐ ܘܠܵܐ ܩܵܐ ܙܸܒܠܵܐ ܐܝܼܬ ܠܵܗ̇ ܝܘܼܬܪܵܢܵܐ. ܟܹܐ ܪܲܦܝܼ ܠܵܗ̇ ܠܒܲܕܲܪ. ܡ̇ܢ ܕܐܝܼܬ ܠܹܗ ܢܵܬܝܵܬܹ̈‌ܐ ܠܸܫܡܵܥܵܐ، ܫܵܡܹܥ.“ ");
INSERT INTO aii_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣ ܝܼܫܘܿܥ ܡܵܟ݂ܣܹ̈ܐ ܘܚܲܛܵܝܹ̈ܐ ܕܫܵܡܥܝܼ ܗܘܵܘ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ܐܝܼܢܵܐ ܣܵܦܪܹ̈ܐ ܘܦܪ̈ܝܼܫܹܐ ܛܘܼܪܛܸܡ ܠܗܘܿܢ ܘܐܡܝܼܪܗܘܿܢ: ”ܐܵܗܵܐ ܐܢܵܫܵܐ ܩܲܒܘܼܠܹܐ ܝܠܹܗ ܚܲܛܵܝܹ̈ܐ ܘܒܹܐܟ݂ܵܠܵܐ ܝܠܹܗ ܥܲܡܵܝܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ ܐܵܗܵܐ ܡܲܬܠܵܐ: ");
INSERT INTO aii_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","”ܐܲܝܢܝܼ ܝܠܹܗ ܡܸܢܵܘܟ݂ܘܿܢ ܕܗܵܘܹܐ ܠܹܗ ܡܵܐܐ ܥܸܪ̈ܒܹܐ، ܐܸܢ ܛܵܠܹܩ ܚܲܕ ܡܸܢܵܝܗ‌ܝ ܠܹܐ ܫܵܒܹܩ ܬܸܫܥܝܼ ܘܬܸܫܥܵܐ ܓܵܘ ܒܲܪܝܼܵܐ ܘܐܵܙܹܠܔ ܛܵܥܹܐ ܒܵܬܪ ܗ̇ܘ ܕܝܼܠܹܗ ܛܠܝܼܩܵܐ ܗܲܠܔ ܕܡܲܫ݇ܟ̰ܸܚ ܠܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","”ܘܐܝܼܡܲܢ ܕܡܲܫ݇ܟ̰ܸܚ ܠܹܗ، ܟܹܐ ܚܵܕܹܐ ܘܟܹܐ ܫܵܩܹܠܔ ܠܹܗ ܥܲܠܔ ܪ̈ܘܼܦ̮ܫܵܢܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","”ܟܹܐ ܐܵܬܹ‌ܐ ܠܒܲܝܬܹܗ ܘܩܵܪܹܐ ܠܚܲܒ݂ܪ̈ܵܘܵܬܘܼܗ‌ܝ ܘܠܫܒ݂ܵܒ݂ܘܼ̈ܗ‌ܝ، ܘܐܵܡܹܪ ܐܸܠܵܝܗ‌ܝ: ’ܚܕܹܝܡܘܼܢ ܥܲܡܝܼ ܕܡܘܼܫ݇ܟ̰ܸܚ ܠܝܼ ܥܸܪܒܝܼ ܕܝܼܗܘܵܐ ܛܠܝܼܩܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","”ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܗܵܕܟ݂ܵܐ ܒܸܬ ܗܵܘܝܵܐ ܚܲܕܘܼܬܵ‌ܐ ܒܘܼܫ ܙܵܘܕܵܐ ܓܵܘ ܫܡܲܝܵܐ ܥܲܠܔ ܚܲܕ ܚܲܛܵܝܵܐ ܕܬܲܘܸܒ ܡ̣ܢ ܥܲܠܔ ܬܸܫܥܝܼ ܘܬܸܫܥܵܐ ܙܲܕܝܼܩܹ̈ܐ ܕܠܹܐ ܝܢܵܐ ܣܢܝܼܩܹܐ ܠܬܲܘܲܒܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","”ܝܲܢ ܐܲܝܢܝܼ ܒܲܟ݂ܬܵ‌ܐ ܕܗܵܘܹܐ ܠܵܗ̇ ܥܸܣܪܵܐ ܙܘܼܙܹ̈ܐ ܘܛܲܠܩܵܐ ܚܲܕ ܡܸܢܵܝܗ‌ܝ، ܠܹܐ ܡܲܠܗܝܼܵܐ ܫܪܵܓ݂ܵܐ ܘܟܵܢܫܵܐ ܒܲܝܬܵ‌ܐ ܘܛܵܥܝܵܐ ܒܵܬܪܹܗ ܒܚܦܝܼܛܘܼܬܵ‌ܐ ܗܲܠܔ ܕܡܲܫ݇ܟ̰ܚܵܐ ܠܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","”ܘܐܝܼܡܲܢ ܕܡܲܫ݇ܟ̰ܚܵܐ ܠܹܗ، ܟܹܐ ܩܵܪܝܵܐ ܠܚܲܒܸܪ̈ܝܵܬܘܼܗ̇ ܘܠܫܒ݂ܵܒ݂ܝܵܬܘܼ̈ܗ̇ ܘܐܵܡܪܵܐ ܐܸܠܵܝܗ‌ܝ: ’ܚܕܹܝܡܘܼܢ ܥܲܡܝܼ ܣܵܒܵܒ ܡܘܼܫ݇ܟ̰ܸܚ ܠܝܼ ܙܘܼܙܝܼ ܕܝܼܗܘܵܐ ܛܠܝܼܩܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","”ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܗܵܕܟ݂ܵܐ ܒܸܬ ܗܵܘܝܵܐ ܚܲܕܘܼܬܵ‌ܐ ܩܲܕܡ ܡܲܠܲܐܟܹ̈ܐ ܕܐܲܠܵܗܵܐ ܥܲܠܔ ܚܲܕ ܚܲܛܵܝܵܐ ܕܬܲܘܸܒ.“ ");
INSERT INTO aii_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ܡܸܢܕܪܸܫ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܚܲܕ ܐܢܵܫܵܐ ܐܝܼܬ ܗܘܵܐ ܠܹܗ ܬܪܹܝ ܒܢܘܿܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","”ܐܡܝܼܪܹܗ ܒܪܘܿܢܵܐ ܙܥܘܿܪܵܐ ܠܒܵܒܘܼܗ‌ܝ: ’ܒܵܒܝܼ، ܗܲܒ݂ܠܔ ܠܝܼ ܣܵܗܡܵܐ ܕܡܵܛܹܐ ܠܝܼ ܡ̣ܢ ܡܸܢܕܝܼ.‘ ܘܦܘܼܠܸܥ ܠܹܗ ܒܹܝܠܵܝܗ‌ܝ ܡܸܢܕܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","”ܡ̣ܢ ܒܵܬܪ ܚܲܕܟܡܵܐ ܝܵܘܡܵܢܹ̈ܐ ܓ̰ܘܼܡܸܥ ܠܹܗ ܗ̇ܘ ܒܪܘܿܢܵܐ ܙܥܘܿܪܵܐ ܟܠܔ ܡܸܢܕܝܼ ܕܡܛܹܐ ܠܹܗ ܐܸܠܹܗ ܘܐܙܝܼܠܔ ܠܹܗ ܠܐܲܬܪܵܐ ܪܸܚܩܵܐ، ܘܬܵܡܵܐ ܒܘܼܪܒܸܙ ܠܹܗ ܡܸܢܕܝܼܹܗ ܟܲܕ ܒܸܚܵܝܵܐ ܒܫܪܝܼܚܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","”ܡ̣ܢ ܒܵܬܪ ܕܚܘܼܪܸܓ̰ ܠܹܗ ܟܠܔ ܡܸܢܕܝܼ ܕܐܝܼܬ ܗܘܵܐ ܠܹܗ، ܗܘܹܐ ܠܹܗ ܟܸܦܢܵܐ ܓܘܼܪܵܐ ܓܵܘ ܗ̇ܘ ܐܲܬܪܵܐ، ܘܗ̇ܘ ܫܘܼܪܹܐ ܠܹܗ ܠܸܣܢܵܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","”ܐܙܝܼܠܔ ܠܹܗ ܘܙܘܼܘܸܓ ܠܹܗ ܥܲܡ ܚܲܕ ܡ̣ܢ ܒܢܲܝ̈ ܗ̇ܘ ܐܲܬܪܵܐ، ܘܗ̇ܘ ܫܘܼܕܸܪܹܗ ܐܸܠܹܗ ܠܚܲܩܠܹܗ ܕܡܲܪܥܹܐ ܚܙܘܼܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","”ܘܟܹܐ ܫܲܗܘܸܬ ܗܘܵܐ ܠܸܡܠܵܝܵܐ ܟܹܪ݇ܣܹܗ ܡ̣ܢ ܐܵܢܝܼ ܚܲܪ̈ܘܼܒܹܐ ܕܐܵܟ݂ܠܝܼ ܗܘܵܘ ܚܙܘܼܪܹ̈ܐ. ܘܐܢܵܫܵܐ ܠܹܐ ܝܵܗܒܹܠܔ ܗܘܵܐ ܠܹܗ ܡܸܢܕܝܼ ܠܹܐܟ݂ܵܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","”ܐܝܼܡܲܢ ܕܪܥܝܼܫ ܠܹܗ ܠܓܵܢܹܗ، ܐܡܝܼܪܹܗ: ’ܟܡܵܐ ܦܲܠܵܚܹ̈ܐ ܕܒ݂ܝܼܩܹܐ ܒܗܵܩܵܐ ܐܝܼܬ ܓܵܘ ܒܲܝܬܵ‌ܐ ܕܒܵܒܝܼ ܕܟܹܐ ܙܵܐܹܕ ܡ̣ܢ ܩܲܕܡܵܝܗ‌ܝ ܠܲܚܡܵܐ، ܘܐܵܢܵܐ ܠܲܐܟ݂ܵܐ ܒܸܡܝܵܬܵ‌ܐ ܝܘܸܢ ܡ̣ܢ ܟܸܦܢܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","”’ܒܸܬ ܩܵܝܡܹܢ ܘܐܵܙܹܠ݇ܢ ܠܟܸܣ ܒܵܒܝܼ، ܘܒܸܬ ܐܵܡܪܹܢ ܐܸܠܹܗ، ܒܵܒܝܼ، ܚܛܹܐ ܠܝܼ ܩܲܕܡ ܫܡܲܝܵܐ ܘܩܲܕܡܘܼܟ݂، ");
INSERT INTO aii_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","”’ܘܡ̣ܢ ܐܵܕܝܼܵܐ ܠܹܐ ܝܘܸܢ ܚܫܝܼܚܵܐ ܕܦܵܝܫܹܢ ܩܸܪܝܵܐ ܒܪܘܿܢܘܼܟ݂. ܥܒ݂ܘܿܕ ܠܝܼ ܐܲܝܟ݂ ܚܲܕ ܡ̣ܢ ܦܲܠܵܚܘܼ̈ܟ݂ ܕܒ݂ܝܼܩܹܐ ܒܗܵܩܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","”ܩܝܼܡ ܠܹܗ ܘܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣ ܒܵܒܘܼܗ‌ܝ، ܘܗܸܫ ܗ̇ܘ ܪܸܚܩܵܐ ܝܗܘܵܐ، ܚܙܹܐ ܠܹܗ ܐܸܠܹܗ ܒܵܒܘܼܗ‌ܝ ܘܪܘܼܚܸܡ ܠܹܗ ܥܲܠܘܼܗ‌ܝ، ܘܪܚܝܼܛ ܠܹܗ ܘܚܦܝܼܩ ܠܹܗ ܐܸܠܹܗ ܘܢܫܝܼܩ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","”ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ ܒܪܘܿܢܹܗ: ’ܒܵܒܝܼ، ܚܛܹܐ ܠܝܼ ܩܲܕܡ ܫܡܲܝܵܐ ܘܩܲܕܡܘܼܟ݂، ܡ̣ܢ ܐܵܕܝܼܵܐ ܠܹܐ ܚܵܫܚܹܢ ܕܦܵܝܫܹܢ ܩܸܪܝܵܐ ܒܪܘܿܢܘܼܟ݂.‘ ");
INSERT INTO aii_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","”ܐܝܼܢܵܐ ܐܡܝܼܪܹܗ ܒܵܒܘܼܗ‌ܝ ܠܪܹ̈ܓܵܘܵܬܘܼܗ‌ܝ: ’ܒܓ̰ܲܠܕܘܼܬܵ‌ܐ ܦܲܠܛܘܼܢ ܓ̰ܘܼܒܵܐ ܪܹܝܫܵܝܬܵ‌ܐ ܘܡܲܠܒܸܫܘܼܢ ܠܵܗ̇ ܥܲܠܘܼܗ‌ܝ، ܘܡܚܹܝܡܘܼܢ ܥܸܙܲܩܬܵ‌ܐ ܒܐܝܼܕܹܗ، ܘܡܲܠܒܸܫܘܼܢ ܨܵܘܠܹ̈ܐ ܒܐܲܩܠܵܬܘܼ̈ܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","”’ܘܡܲܝܬܹܝܡܘܼܢ ܘܦܪܘܿܡܘܼܢ ܬܵܘܪܵܐ ܛܪܝܼܨܵܐ ܕܐܵܟ݂ܠܲܚ ܘܥܵܒ݂ܕܲܚ ܒܘܼܣܵܡܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","”’ܣܵܒܵܒ ܐܵܗܵܐ ܒܪܘܿܢܝܼ ܡܝܼܬܵ‌ܐ ܝܗܘܵܐ ܘܚܝܹܐ ܠܹܗ، ܛܠܝܼܩܵܐ ܝܗܘܵܐ ܘܦܝܼܫ ܠܹܗ ܡܫ݇ܟ̰ܝܼܚܵܐ.‘ ܘܫܘܼܪܹܐ ܠܗܘܿܢ ܠܸܥܒ݂ܵܕܵܐ ܒܘܼܣܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","”ܒܪܘܿܢܹܗ ܓܘܼܪܵܐ ܓܵܘ ܚܲܩܠܵܐ ܝܗܘܵܐ، ܐܝܼܡܲܢ ܕܐܬܹ‌ܐ ܠܹܗ، ܘܩܘܼܪܒܸܢܹܗ ܠܒܲܝܬܵ‌ܐ، ܫܡܝܼܥ ܠܹܗ ܩܵܠܵܐ ܕܙܡܵܪܵܐ ܘܪܸܩܕܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","”ܩܪܹܐ ܠܹܗ ܚܲܕ ܡ̣ܢ ܪܹ̈ܓܵܘܵܬܹ‌ܐ ܘܒܘܼܩܸܪܹܗ ܡܸܢܹܗ: ’ܡܘܼܕܝܼ ܝܠܹܗ ܐܵܗܵܐ؟‘ ");
INSERT INTO aii_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","”ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ: ’ܐܲܚܘܿܢܘܼܟ݂ ܐܬܹ‌ܐ ܠܹܗ، ܘܒܵܒܘܼܟ݂ ܦܪܝܼܡ ܠܹܗ ܬܵܘܪܵܐ ܛܪܝܼܨܵܐ، ܣܵܒܵܒ ܩܘܼܒܸܠܔ ܠܹܗ ܐܸܠܹܗ ܚܵܝܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","”ܟܪܝܼܒ ܠܹܗ ܗ̇ܘ ܘܠܹܐ ܒܵܥܹܐ ܗܘܵܐ ܠܸܥܒ݂ܵܪܵܐ. ܦܠܝܼܛ ܠܹܗ ܒܵܒܘܼܗ‌ܝ ܘܦܘܼܪܦܸܠܔ ܠܹܗ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","”ܐܝܼܢܵܐ ܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ ܘܐܡܝܼܪܹܗ ܠܒܵܒܘܼܗ‌ܝ: ’ܐܲܢܹܐ ܟܡܵܐ ܫܸܢܹ̈ܐ ܒܸܦܠܵܚܵܐ ܝܘܸܢ ܐܸܠܘܼܟ݂ ܐܲܝܟ݂ ܚܲܕ ܥܲܒ݂ܕܵܐ، ܘܗܸܟ̃ ܠܹܐ ܝܘܸܢ ܫܡܝܼܛܵܐ ܦܘܼܩܕܵܢܘܼܟ݂، ܐܝܼܢܵܐ ܐܘܼܦ ܚܲܕ ܓܸܕܝܵܐ ܠܹܐ ܝܘܸܬ ܝܘܼܗܒ݂ܵܐ ܐܸܠܝܼ ܕܡܲܒܣܸܡܸܢ ܥܲܡ ܚܲܒ݂ܪ̈ܵܘܵܬ‌ܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","”’ܐܝܼܢܵܐ ܐܵܗܵܐ ܒܪܘܿܢܘܼܟ݂ ܕܒܘܼܪܒܸܙ ܠܹܗ ܡܸܢܕܝܼܘܼܟ݂ ܥܲܡ ܙܵܢܝܵܬܹ̈‌ܐ، ܐܝܼܡܲܢ ܕܐܬܹ‌ܐ ܠܹܗ ܦܪܝܼܡ ܠܘܼܟ݂ ܐܸܠܹܗ ܬܵܘܪܵܐ ܛܪܝܼܨܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","”ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܒܵܒܘܼܗ‌ܝ: ’ܒܪܘܿܢܝܼ، ܐܲܢ݇ܬ ܒܟܠܔ ܥܕܵܢܵܐ ܥܲܡܝܼ ܝܘܸܬ، ܘܟܠܔ ܡܸܢܕܝܼ ܕܐܝܼܬ ܠܝܼ ܕܝܼܘܼܟ݂ ܝܼܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","”’ܐܝܼܢܵܐ ܘܵܠܹܐ ܝܗܘܵܐ ܐܸܠܲܢ ܠܸܥܒ݂ܵܕܵܐ ܒܘܼܣܵܡܵܐ ܘܠܸܚܕܵܝܵܐ، ܣܵܒܵܒ ܐܵܗܵܐ ܐܲܚܘܿܢܘܼܟ݂ ܡܝܼܬܵ‌ܐ ܝܗܘܵܐ ܘܚܝܹܐ ܠܹܗ، ܛܠܝܼܩܵܐ ܝܗܘܵܐ ܘܦܝܼܫ ܠܹܗ ܡܫ݇ܟ̰ܝܼܚܵܐ.‘“ ");
INSERT INTO aii_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܐܝܼܬ ܗܘܵܐ ܚܲܕ ܐܢܵܫܵܐ ܥܲܬܝܼܪܵܐ، ܘܐܝܼܬ ܗܘܵܐ ܠܹܗ ܪܲܒ ܒܲܝܬܵ‌ܐ، ܗ̇ܘ ܕܩܒ݂ܝܼܠܔ ܠܗܘܿܢ ܥܲܠܘܼܗ‌ܝ ܕܒܲܪܒܘܼܙܹܐ ܝܗܘܵܐ ܡܸܢܕܝܼ ܕܡܵܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","”ܩܪܹܐ ܠܹܗ ܡܵܪܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ’ܡܘܼܕܝܼ ܝܠܹܗ ܐܵܗܵܐ ܕܒܸܫܡܵܥܵܐ ܝܘܸܢ ܒܘܼܬ ܕܝܼܘܼܟ݂؟ ܗܲܒ݂ܠܔ ܠܝܼ ܚܸܫܒܘܼܢܵܐ ܕܦܘܼܠܚܵܢܘܼܟ݂، ܣܵܒܵܒ ܡ̣ܢ ܐܵܕܝܼܵܐ ܠܹܐ ܡܵܨܹܝܬ ܗܵܘܹܝܬ ܐܸܠܝܼ ܪܲܒ ܒܲܝܬܵ‌ܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","”ܐܡܝܼܪܹܗ ܪܲܒ ܒܲܝܬܵ‌ܐ ܒܓܵܢܹܗ: ’ܡܘܼܕܝܼ ܥܵܒ݂ܕܹܢ؟ ܡܵܪܝܼ ܒܸܫܩܵܠܘܼܗ̇ ܝܠܹܗ ܪܲܒ ܒܲܝܬܘܼܬܵ‌ܐ ܡܸܢܝܼ. ܚܦܵܪܵܐ ܠܹܐ ܡܵܨܹܝܢ ܚܵܦܪܹܢ، ܘܠܸܓܒ݂ܵܝܵܐ ܒܸܢܟ݂ܵܦܵܐ ܝܘܸܢ. ");
INSERT INTO aii_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","”’ܝܕܝܼܥ ܠܝܼ ܡܘܼܕܝܼ ܒܸܬ ܥܵܒ݂ܕܹܢ، ܕܐܝܼܡܲܢ ܕܦܵܝܫܹܢ ܛܪܝܼܕܵܐ ܡ̣ܢ ܪܲܒ ܒܲܝܬܘܼܬܵ‌ܐ ܩܲܒܠܝܼ ܠܝܼ ܓܵܘ ܒܵܬܵܝ̈ܗ‌ܝ.‘ ");
INSERT INTO aii_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","”ܩܪܹܐ ܠܹܗ ܚܲܕ ܒܚܲܕ ܡ̣ܢ ܕܲܝܢܵܢܹ̈ܐ ܕܡܵܪܹܗ ܘܐܡܝܼܪܹܗ ܠܩܲܕܡܵܝܵܐ: ’ܟܡܵܐ ܕܲܝܢܵܢܵܐ ܝܘܸܬ ܩܵܐ ܡܵܪܝܼ؟‘ ");
INSERT INTO aii_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","”ܓ̰ܘܼܘܸܒ ܠܹܗ: ’ܡܵܐܐ ܟܝܘܼܠܹ̈ܐ ܕܡܸܫܚܵܐ.‘ ܐܡܝܼܪܹܗ ܐܸܠܹܗ: ’ܫܩܘܿܠܔ ܟܬܵܒ݂ܘܼܟ݂ ܘܝܬܘܿܒ݂ ܒܓ̰ܲܠܕܘܼܬܵ‌ܐ ܘܟܬܘܿܒ݂ ܚܲܡܫܝܼ ܟܝܘܼܠܹ̈ܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","”ܘܒܘܼܩܸܪܹܗ ܡ̣ܢ ܚܲܕ ܐܚܹܪܢܵܐ: ’ܐܲܢ݇ܬ ܟܡܵܐ ܕܲܝܢܵܢܵܐ ܝܘܸܬ ܩܵܐ ܡܵܪܝܼ؟‘ ܓ̰ܘܼܘܸܒ ܠܹܗ: ’ܡܵܐܐ ܟܘܿܪܹ̈ܐ ܕܚܸܛܹ̈ܐ.‘ ܐܡܝܼܪܹܗ ܐܸܠܹܗ: ’ܫܩܘܿܠܔ ܟܬܵܒ݂ܘܼܟ݂ ܘܝܬܘܿܒ݂ ܘܟܬܘܿܒ݂ ܬܡܵܢܝܼ ܟܘܿܪܹ̈ܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","”ܚܩܝܼܪܹܗ ܡܵܪܵܐ ܠܪܲܒ ܒܲܝܬܵ‌ܐ ܥܵܘܵܠܵܐ ܕܒܗܵܘܢܵܢܘܼܬܵ‌ܐ ܦܠܝܼܚ ܠܹܗ، ܣܵܒܵܒ ܐܢܵܫܹ̈ܐ ܕܐܵܗܵܐ ܙܲܒ݂ܢܵܐ ܒܘܼܫ ܚܲܟܝܼܡܹ̈ܐ ܝܢܵܐ ܓܵܘ ܕܵܘܪܵܝܗ‌ܝ ܡ̣ܢ ܒܢܘܿܢܹ̈ܐ ܕܒܲܗܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","”ܐܘܼܦ ܐܵܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܥܒ݂ܘܿܕܘܼܢ ܠܵܘܟ݂ܘܿܢ ܚܲܒ݂ܪ̈ܵܘܵܬܹ‌ܐ ܡ̣ܢ ܙܘܼܙܵܐ ܕܥܵܘܠܵܐ، ܕܐܝܼܡܲܢ ܕܦܵܪܹܩ، ܩܲܒܠܝܼ ܠܵܘܟ݂ܘܿܢ ܒܡܲܫܪ̈ܵܝܵܬܹ‌ܐ ܕܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","”ܡ̇ܢ ܕܒܚܲܕܟ̰ܵܐ ܡܗܘܼܡܢܵܐ ܝܠܹܗ، ܐܘܼܦ ܒܪܵܒܵܐ ܡܗܘܼܡܢܵܐ ܝܠܹܗ، ܘܡ̇ܢ ܕܒܚܲܕܟ̰ܵܐ ܥܵܘܵܠܵܐ ܝܠܹܗ، ܐܘܼܦ ܒܪܵܒܵܐ ܥܵܘܵܠܵܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","”ܐܸܢ ܒܡܸܢܕܝܼ ܕܥܵܘܠܵܐ ܠܵܐ ܗܵܘܹܝܬܘܿܢ ܡܗܘܼܡܢܹ̈ܐ، ܡܵܢܝܼ ܒܸܬ ܣܲܦܹܐ ܐܸܠܵܘܟ݂ܘܿܢ ܡܸܢܕܝܼ ܕܫܲܪܝܼܪܘܼܬܵ‌ܐ؟ ");
INSERT INTO aii_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","”ܐܸܢ ܒܡܸܢܕܝܼ ܕܠܹܐ ܝܠܹܗ ܕܝܼܵܘܟ݂ܘܿܢ ܠܵܐ ܗܵܘܹܝܬܘܿܢ ܡܗܘܼܡܢܹܐ، ܡܵܢܝܼ ܒܸܬ ܝܵܗܒܹܠܔ ܠܵܘܟ݂ܘܿܢ ܡܸܢܕܝܼ ܕܓܵܢܵܘܟ݂ܘܿܢ؟ ");
INSERT INTO aii_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","”ܠܲܝܬ ܥܲܒ݂ܕܵܐ ܕܡܵܨܹܐ ܦܵܠܹܚ ܠܬܪܹܝ ܡܵܪ̈ܵܘܵܬܹ‌ܐ، ܣܵܒܵܒ ܒܸܬ ܣܵܢܹܐ ܠܚܲܕ ܘܡܲܚܸܒ ܠܗ̇ܘ ܐܚܹܪܢܵܐ، ܝܲܢ ܒܸܬ ܡܝܲܩܸܪ ܠܚܲܕ ܘܡܲܣܠܹܐ ܠܗ̇ܘ ܐܚܹܪܢܵܐ. ܠܹܐ ܡܵܨܹܝܬܘܿܢ ܦܵܠܚܝܼܬܘܿܢ ܠܐܲܠܵܗܵܐ ܘܠܙܘܼܙܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܗܘܿܢ ܦܪ̈ܝܼܫܹܐ ܐܲܢܹܐ ܟܠܵܝܗ‌ܝ، ܡܘܼܣܚܸܪܗܘܿܢ ܒܝܼܹܗ ܣܵܒܵܒ ܟܹܐ ܡܲܚܸܒܝܼ ܗܘܵܘ ܙܘܼܙܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܐܲܚܬܘܿܢ ܝܼܬܘܿܢ ܕܟܹܐ ܡܲܟܫܸܛܝܼܬܘܿܢ ܓܵܢܵܘܟ݂ܘܿܢ ܩܲܕܡ ܒܢܲܝ̈ܢܵܫܵܐ، ܐܝܼܢܵܐ ܐܲܠܵܗܵܐ ܟܹܐ ܝܵܕܹܥ ܠܸܒܵܘܟ݂ܘܿܢ. ܡܸܢܕܝܼ ܕܝܼܠܹܗ ܡܝܘܼܩܪܵܐ ܠܟܸܣ ܒܢܲܝ̈ܢܵܫܵܐ، ܛܲܢܦܵܐ ܝܠܹܗ ܠܟܸܣ ܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","”ܢܵܡܘܿܣܵܐ ܘܢܒ݂ܝܼܹ̈ܐ ܗܲܠܔ ܝܘܿܚܲܢܵܢ ܦܝܼܫܹܐ ܝܗܘܵܘ ܡܘܼܟܪܸܙܹܐ. ܡ̣ܢ ܗ̇ܝܓܵܗ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ ܦܝܵܫܵܐ ܝܠܵܗ̇ ܡܘܼܟܪܸܙܬܵ‌ܐ، ܘܟܠܔ ܚܲܕ ܒܵܥܹܐ ܒܚܲܝܠܵܐ ܥܵܒܹܪ ܓܵܘܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","”ܒܘܼܫ ܦܫܘܼܩܬܵ‌ܐ ܝܠܵܗ̇ ܕܫܡܲܝܵܐ ܘܐܲܪܥܵܐ ܛܵܠܩܝܼ ܡ̣ܢ ܕܚܕܵܐ ܐܵܬܘܼܬܵ‌ܐ ܢܵܦܠܵܐ ܡ̣ܢ ܢܵܡܘܿܣܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","”ܟܠܔ ܡ̇ܢ ܕܪܲܦܹܐ ܒܲܟ݂ܬܹܗ ܘܓܵܒܹܪ ܚܕܵܐ ܐܚܹܪܬܵ‌ܐ، ܒܸܥܒ݂ܵܕܵܐ ܝܠܹܗ ܓܲܝܵܪܘܼܬܵ‌ܐ، ܘܟܠܔ ܡ̇ܢ ܕܓܵܒܹܪ ܒܲܟ݂ܬܵ‌ܐ ܪܘܼܦܝܼܬܵ‌ܐ ܒܝܲܕ ܓܲܒ݂ܪܵܐ، ܒܸܥܒ݂ܵܕܵܐ ܝܠܹܗ ܓܲܝܵܪܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","”ܐܝܼܬ ܗܘܵܐ ܚܲܕ ܐܢܵܫܵܐ ܥܲܬܝܼܪܵܐ، ܘܟܹܐ ܠܵܒܹܫ ܗܘܵܐ ܟܸܬܲܢ ܘܐܲܪܓܘܵܢܵܐ، ܘܟܠܔ ܝܘܿܡ ܟܹܐ ܚܵܝܹܐ ܗܘܵܐ ܓܵܘ ܒܘܼܣܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","”ܚܲܕ ܡܸܣܟܹܢܵܐ ܐܝܼܬ ܗܘܵܐ ܫܸܡܹܗ ܠܲܥܵܙܲܪ، ܡܸܠܝܵܐ ܡ̣ܢ ܕܲܪ̈ܒܵܬܹ‌ܐ، ܡܘܼܬܒ݂ܵܐ ܩܲܕܡ ܬܲܪܥܵܐ ܕܗ̇ܘ ܥܲܬܝܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","”ܘܟܹܐ ܫܲܗܘܸܬ ܗܘܵܐ ܕܡܵܠܹܐ ܗܘܵܐ ܟܹܪ݇ܣܹܗ ܡ̣ܢ ܦܸܪ̈ܬܘܼܚܹܐ ܕܢܵܦܠܝܼ ܗܘܵܘ ܡ̣ܢ ܦܵܬܘܿܪܵܐ ܕܗ̇ܘ ܥܲܬܝܼܪܵܐ. ܐܘܼܦ ܟܲܠܒܹ̈ܐ ܟܹܐ ܐܵܬ‌ܝܼ ܗܘܵܘ ܘܠܵܟܚܝܼ ܗܘܵܘ ܠܗܘܿܢ ܕܲܪ̈ܒܵܬܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","”ܡܝܼܬ ܠܹܗ ܗ̇ܘ ܡܸܣܟܹܢܵܐ ܘܠܘܼܒܸܠܔ ܠܗܘܿܢ ܐܸܠܹܗ ܡܲܠܲܐܟܹ̈ܐ ܠܥܘܼܒܵܐ ܕܐܲܒ݂ܪܵܗܵܡ. ܘܐܘܼܦ ܗ̇ܘ ܥܲܬܝܼܪܵܐ ܡܝܼܬ ܠܹܗ ܘܦܝܼܫ ܠܹܗ ܩܒ݂ܝܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","”ܘܓܵܘ ܫܝܘܿܠܔ، ܟܲܕ ܗ̇ܘ ܓ̰ܲܢܓ̰ܘܼܪܹܐ، ܡܘܼܪܸܡ ܠܹܗ ܥܲܝܢܘܼ̈ܗ‌ܝ ܡ̣ܢ ܪܸܚܩܵܐ ܘܚܙܹܐ ܠܹܗ ܠܠܲܥܵܙܲܪ ܒܥܘܼܒܵܐ ܕܐܲܒ݂ܪܵܗܵܡ، ");
INSERT INTO aii_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","”ܡܘܼܩܘܸܚ ܠܹܗ ܒܩܵܠܵܐ ܪܵܡܵܐ ܘܐܡܝܼܪܹܗ: ’ܝܵܐ ܒܵܒܝܼ ܐܲܒ݂ܪܵܗܵܡ، ܪܲܚܸܡ ܥܲܠܝܼ، ܘܫܲܕܸܪ ܠܠܲܥܵܙܲܪ ܕܛܵܡܹܫ ܪܹܝܫܵܐ ܕܨܸܒܥܹܗ ܓܵܘ ܡ̈ܝܼܵܐ ܘܡܲܬܪܹܐ ܠܹܗ ܠܸܫܵܢܝܼ، ܣܵܒܵܒ ܓ̰ܲܢܓ̰ܘܼܪܹܐ ܝܘܸܢ ܓܵܘ ܐܵܗܵܐ ܠܵܗܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","”ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ ܐܲܒ݂ܪܵܗܵܡ: ’ܒܪܘܿܢܝܼ، ܕܟ݂ܘܿܪ ܕܐܲܢ݇ܬ ܩܘܼܒܸܠܔ ܠܘܼܟ݂ ܒܘܼܣܵܡܘܼܟ݂ ܒܚܲܝܘܼ̈ܟ݂، ܘܠܲܥܵܙܲܪ ܩܘܼܒܸܠܔ ܠܹܗ ܓ̰ܘܼܢܓ̰ܵܪܹ̈ܐ ܒܚܲܝܘܼ̈ܗ‌ܝ. ܐܵܕܝܼܵܐ ܐܲܢ݇ܬ ܓ̰ܲܢܓ̰ܘܼܪܹܐ ܝܘܸܬ، ܘܗ̇ܘ ܡܲܢܝܘܼܚܹܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","”ܥܲܠܔ ܟܠܵܝܗ‌ܝ ܐܲܢܹܐ، ܐܝܼܬ ܗܵܘܬܵ‌ܐ ܓܘܼܪܬܵ‌ܐ ܡܘܼܬܸܒ݂ܬܵ‌ܐ ܒܹܝܠܲܢ ܘܒܹܝܠܵܘܟ݂ܘܿܢ، ܗܵܕܟ݂ܵܐ ܐܵܢܝܼ ܕܒܵܥܝܼ ܡ̣ܢ ܠܲܐܟ݂ܵܐ ܥܵܒ݂ܪܝܼ ܠܟܸܣܠܵܘܟ݂ܘܿܢ ܠܹܐ ܡܵܨܝܼ، ܘܐܵܢܝܼ ܕܡ̣ܢ ܠܟܸܣܠܵܘܟ݂ܘܿܢ ܒܵܥܝܼ ܐܵܬ‌ܝܼ ܠܟܸܣܠܲܢ ܠܹܐ ܡܵܨܝܼ.‘ ");
INSERT INTO aii_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","”ܐܡܝܼܪܹܗ ܐܸܠܹܗ: ’ܦܲܪܦܘܼܠܹܐ ܝܘܸܢ ܒܝܼܘܼܟ݂ ܒܵܒܝܼ، ܫܲܕܸܪܹܗ ܠܲܥܵܙܲܪ ܠܒܲܝܬܵ‌ܐ ܕܒܵܒܝܼ، ");
INSERT INTO aii_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","”’ܣܵܒܵܒ ܐܝܼܬ ܠܝܼ ܚܲܡܫܵܐ ܐܲܚܘܿܢܘܵܬܹ̈‌ܐ. ܫܒ݂ܘܿܩ ܕܐܵܙܹܠܔ ܘܡܲܕܸܥ ܐܸܠܵܝܗ‌ܝ، ܕܠܵܐ ܐܘܼܦ ܐܵܢܝܼ ܐܵܬ‌ܝܼ ܠܐܵܗܵܐ ܕܘܼܟܵܐ ܕܓ̰ܘܼܢܓ̰ܵܪܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","”ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܐܲܒ݂ܪܵܗܵܡ: ’ܐܝܼܬ ܠܗܘܿܢ ܡܘܼܫܹܐ ܘܢܒ݂ܝܼܹ̈ܐ، ܫܒ݂ܘܿܩ ܫܵܡܥܝܼ ܐܸܠܵܝܗ‌ܝ.‘ ");
INSERT INTO aii_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","”ܐܝܼܢܵܐ ܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ: ’ܠܵܐ ܒܵܒܝܼ ܐܲܒ݂ܪܵܗܵܡ، ܐܸܢ ܚܲܕ ܐܢܵܫܵܐ ܡ̣ܢ ܡܝܼ̈ܬܹ‌ܐ ܐܵܙܹܠܔ ܠܟܸܣܠܵܝܗ‌ܝ ܒܸܬ ܬܲܘܸܒܝܼ.‘ ");
INSERT INTO aii_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","”ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ ܐܲܒ݂ܪܵܗܵܡ ܘܐܡܝܼܪܹܗ: ’ܐܸܢ ܠܹܐ ܫܵܡܥܝܼ ܠܡܘܼܫܹܐ ܘܠܢܒ݂ܝܼܹ̈ܐ، ܐܘܼܦ ܐܸܢ ܕܚܲܕ ܐܢܵܫܵܐ ܡ̣ܢ ܡܝܼ̈ܬܹ‌ܐ ܩܵܐܹܡ ܠܹܐ ܗܲܡܸܢܝܼ.‘“ ");
INSERT INTO aii_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܠܹܐ ܗܵܘܝܵܐ ܕܠܵܐ ܐܵܬ‌ܝܼ ܬܘܼܪ̈ܩܵܠܹܐ، ܐܝܼܢܵܐ ܘܵܝ ܠܗ̇ܘ ܐܢܵܫܵܐ ܕܗܵܘܹܐ ܥܸܠܬܵ‌ܐ ܕܬܘܼܪ̈ܩܵܠܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","”ܒܘܼܫ ܨܦܵܝܝܼ ܝܗܘܵܐ ܐܸܠܹܗ ܐܸܢ ܟܹܐܦܵܐ ܕܐܸܪܚܹܐ ܗܵܘܹܐ ܗܘܵܐ ܬܸܠܝܵܐ ܒܩܕܵܠܹܗ ܘܪܘܼܦܝܵܐ ܒܝܵܡܵܐ، ܡ̣ܢ ܕܬܲܪܩܸܠܔ ܗܘܵܐ ܠܚܲܕ ܡ̣ܢ ܐܲܢܹܐ ܙܥܘܿܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","”ܗܘܹܝܡܘܼܢ ܗܸܫܝܲܪ. ܐܸܢ ܚܵܛܹܐ ܐܲܚܘܿܢܘܼܟ݂ ܥܲܠܘܼܟ݂، ܡܲܢܟܸܣ ܠܹܗ، ܘܐܸܢ ܬܲܘܸܒ ܦܲܚܸܠܔ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","”ܐܸܢ ܫܒܲܥ ܓܵܗܹ̈ܐ ܒܝܵܘܡܵܐ ܚܵܛܹܐ ܥܲܠܘܼܟ݂، ܘܫܒܲܥ ܓܵܗܹ̈ܐ ܒܝܵܘܡܵܐ ܕܵܐܹܪ ܠܟܸܣܠܘܼܟ݂ ܘܐܵܡܹܪ: ’ܬܲܘܘܼܒܹܐ ܝܘܸܢ،‘ ܦܲܚܸܠܔ ܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ܘܐܡܝܼܪܗܘܿܢ ܫܠܝܼܚܹ̈ܐ: ”ܡܵܪܲܢ، ܡܲܙܝܸܕ ܐܸܠܲܢ ܗܲܝܡܵܢܘܼܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ܐܡܝܼܪܹܗ ܡܵܪܲܢ ܐܸܠܵܝܗ‌ܝ: ”ܐܸܢ ܗܵܘܹܐ ܗܘܵܐ ܠܵܘܟ݂ܘܿܢ ܗܲܝܡܵܢܘܼܬܵ‌ܐ ܐܲܝܟ݂ ܕܲܢܕܸܟܬܵ‌ܐ ܕܚܲܪܕܲܠܔ ܘܐܵܡܪܝܼܬܘܿܢ ܗܘܵܘ ܠܐܵܗܵܐ ܬܘܼܬܵ‌ܐ: ’ܦܘܼܫܝ ܥܩܝܼܪܬܵ‌ܐ، ܘܢܨܝܼܒ݂ܬܵ‌ܐ ܒܝܵܡܵܐ،‘ ܒܸܬ ܫܵܡܥܵܐ ܗܘܵܐ ܐܸܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","”ܐܲܝܢܝܼ ܡܸܢܵܘܟ݂ܘܿܢ ܕܐܝܼܬ ܠܹܗ ܪܹܓܵܐ ܕܛܵܪܹܐ ܦܕܵܢܵܐ، ܝܲܢ ܕܡܲܪܥܹܐ ܥܸܪ̈ܒܹܐ، ܘܐܝܼܡܲܢ ܕܐܵܬܹ‌ܐ ܡ̣ܢ ܚܲܩܠܵܐ ܒܸܬ ܐܵܡܹܪ ܐܸܠܹܗ ܡܵܪܹܗ: ’ܥܒ݂ܘܿܪ، ܘܝܬܘܿܒ݂ ܘܐܟ݂ܘܿܠܔ‘؟ ");
INSERT INTO aii_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","”ܠܹܐ ܐܵܡܹܪ ܐܸܠܹܗ: ’ܗܲܕܸܪ ܐܸܠܝܼ ܡܸܢܕܝܼ ܕܐܵܟ݂ܠܹܢ ܐܟ݂ܵܠ݇ܪܲܡܫܵܐ، ܘܗܲܕܸܪ ܓܵܢܘܼܟ݂، ܥܒ݂ܘܿܕ ܠܝܼ ܚܸܠܡܲܬ ܗܲܠܔ ܕܐܵܟ݂ܠܹܢ ܘܫܵܬܹܝܢ، ܘܒܚܲܪܬܵ‌ܐ ܐܲܢ݇ܬ ܐܵܟ݂ܠܹܬ ܘܫܵܬܹܝܬ‘؟ ");
INSERT INTO aii_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","”ܒܸܬ ܛܵܥܹܢ ܡܸܢܬܵ‌ܐ ܡ̣ܢ ܗ̇ܘ ܪܹܓܵܐ ܕܥܒ݂ܝܼܕ ܠܹܗ ܡܸܢܕܝܼ ܕܦܝܼܫܵܐ ܝܗܘܵܐ ܦܩܝܼܕܵܐ ܐܸܠܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","”ܗܵܕܟ݂ܵܐ ܐܘܼܦ ܐܲܚܬܘܿܢ، ܐܝܼܡܲܢ ܕܥܒ݂ܝܼܕ ܠܵܘܟ݂ܘܿܢ ܟܠܵܝܗ‌ܝ ܐܲܢܹܐ ܕܝܼܢܵܐ ܦܝܼܫܹܐ ܦܩܝܼܕܹܐ ܐܸܠܵܘܟ݂ܘܿܢ ܠܸܥܒ݂ܵܕܵܐ، ܐܡܘܿܪܘܼܢ: ’ܪܹ̈ܓܵܘܵܬܹ‌ܐ ܠܵܐ ܝܘܼܬܪܵܢܵܐ ܝܘܲܚ. ܥܒ݂ܝܼܕ ܠܲܢ ܐܲܚܟ̰ܝܼ ܡܸܢܕܝܼ ܕܘܵܠܹܐ ܝܗܘܵܐ ܐܸܠܲܢ ܕܥܵܒ݂ܕܲܚ ܗܘܵܘ.‘“ ");
INSERT INTO aii_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ܟܲܕ ܒܹܐܙܵܠܵܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܠܐܘܿܪܸܫܠܸܡ، ܥܒ݂ܝܼܪܹܗ ܓܵܘ ܫܵܡܪܝܼܢ ܘܓܠܝܼܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ܘܐܝܼܡܲܢ ܕܩܘܼܪܒܸܢܹܗ ܠܚܕܵܐ ܡܵܬܵ‌ܐ، ܬܦܝܼܩ ܠܗܘܿܢ ܒܝܼܹܗ ܥܸܣܪܵܐ ܐܢܵܫܹ̈ܐ ܓܸܪ̈ܒ݂ܵܢܹܐ. ܟܠܹܐ ܠܗܘܿܢ ܡ̣ܢ ܪܸܚܩܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ܘܡܘܼܩܘܸܚ ܠܗܘܿܢ ܒܩܵܠܵܐ ܪܵܡܵܐ ܘܐܡܝܼܪܗܘܿܢ: ”ܝܼܫܘܿܥ، ܪܲܒܝܼ، ܪܲܚܸܡ ܥܲܠܲܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ܚܸܙܝܵܝ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܙܹܠ݇ܡܘܼܢ ܡܲܚܙܹܝܡܘܼܢ ܓܵܢܵܘܟ݂ܘܿܢ ܠܟܵܗ̈ܢܹܐ.“ ܘܟܲܕ ܒܹܐܙܵܠܵܐ ܝܗܘܵܘ، ܦܝܼܫ ܠܗܘܿܢ ܕܸܟ݂ܝܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ܚܲܕ ܡܸܢܵܝܗ‌ܝ ܟܲܕ ܚܙܹܐ ܠܹܗ ܕܦܝܼܫ ܠܹܗ ܕܸܟ݂ܝܵܐ، ܕܝܼܪܹܗ ܫܲܒܘܼܚܹܐ ܠܐܲܠܵܗܵܐ ܒܩܵܠܵܐ ܪܵܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ܘܢܦܝܼܠܔ ܠܹܗ ܩܲܕܡ ܐܲܩܠܵܬܹ̈‌ܐ ܕܝܼܫܘܿܥ ܫܲܟܘܼܪܹܐ ܐܸܠܹܗ. ܘܐܵܗܵܐ ܐܢܵܫܵܐ ܫܵܡܪܵܝܵܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ: ”ܠܹܐ ܝܗܘܵܘ ܥܸܣܪܵܐ ܐܵܢܝܼ ܕܦܝܼܫ ܠܗܘܿܢ ܕܸܟ݂ܝܹܐ؟ ܐܲܝܟܵܐ ܝܢܵܐ ܐܵܢܝܼ ܬܸܫܥܵܐ ܐܚܹܪ̈ܢܹܐ؟ ");
INSERT INTO aii_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","”ܩܵܡܘܿܕܝܼ ܠܵܐ ܕܝܼܪܗܘܿܢ ܕܝܵܗܒ݂ܝܼ ܬܸܫܒܘܿܚܬܵ‌ܐ ܠܐܲܠܵܗܵܐ ܫܒ݂ܘܿܩ ܡ̣ܢ ܐܵܗܵܐ ܢܘܼܟ݂ܪܵܝܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ܐܡܝܼܪܹܗ ܠܗ̇ܘ ܐܢܵܫܵܐ: ”ܩܘܼܡ ܙܹܠܔ݇، ܗܲܝܡܵܢܘܼܬܘܼܟ݂ ܩܵܡ ܒܲܣܡܵܐ ܠܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ܒܘܼܩܸܪܗܘܿܢ ܦܪ̈ܝܼܫܹܐ ܡ̣ܢ ܝܼܫܘܿܥ: ”ܐܝܼܡܲܢ ܒܸܬ ܐܵܬܝܵܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ؟“ ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ ܠܹܐ ܐܵܬܝܵܐ ܟܲܕ ܐܢܵܫܹ̈ܐ ܒܸܥܒ݂ܵܕܵܐ ܢܛܘܼܪܬܵ‌ܐ ܐܸܠܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","”ܠܹܐ ܐܵܡܪܝܼ: ’ܗܵܐ ܠܲܐܟ݂ܵܐ ܝܠܵܗ̇، ܝܲܢ ܬܵܡܵܐ ܝܠܵܗ̇.‘ ܣܵܒܵܒ ܗܵܐ، ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ ܓܵܘܵܘܟ݂ܘܿܢ ܝܼܠܵܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ܘܐܡܝܼܪܹܗ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܒܸܬ ܐܵܬ‌ܝܼ ܝܵܘܡܵܢܹ̈ܐ ܕܫܲܗܘܸܬܝܼܬܘܿܢ ܠܸܚܙܵܝܵܐ ܚܲܕ ܡ̣ܢ ܝܵܘܡܵܢܹ̈ܐ ܕܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ، ܘܠܹܐ ܚܵܙܹܝܬܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","”ܘܐܸܢ ܐܵܡܪܝܼ ܐܸܠܵܘܟ݂ܘܿܢ: ’ܗܵܐ ܠܲܐܟ݂ܵܐ ܝܠܹܗ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ،‘ ܝܲܢ: ’ܬܵܡܵܐ ܝܠܹܗ،‘ ܠܵܐ ܐܵܙܠ݇ܝܼܬܘܿܢ، ܘܠܵܐ ܬܵܒܥܝܼܬܘܿܢ ܐܸܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","”ܣܵܒܵܒ ܕܵܐܟ݂ܝܼ ܕܒܸܪܩܵܐ ܒܵܪܹܩ ܡ̣ܢ ܪܩܝܼܥܵܐ ܘܒܲܗܪܸܢ ܠܟܠܔ ܡܸܢܕܝܼ ܬܚܘܿܬ ܫܡܲܝܵܐ، ܗܵܕܟ݂ܵܐ ܒܸܬ ܗܵܘܹܐ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܝܵܘܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","”ܐܝܼܢܵܐ ܩܲܕܡܵܝܬܵ‌ܐ ܘܵܠܹܐ ܝܠܵܗ̇ ܕܩܲܒܸܠܔ ܚܲܫܵܐ ܪܵܒܵܐ، ܘܕܦܵܐܹܫ ܡܘܼܣܠܝܼܵܐ ܒܝܲܕ ܐܵܗܵܐ ܫܲܪܒܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","”ܘܕܵܐܟ݂ܝܼ ܕܗܘܹܐ ܠܹܗ ܒܝܵܘܡܵܢܹ̈ܐ ܕܢܘܿܚ، ܗܵܕܟ݂ܵܐ ܒܸܬ ܗܵܘܹܐ ܒܝܵܘܡܵܢܹ̈ܐ ܕܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","”ܗܘܹܐ ܠܗܘܿܢ ܒܹܐܟ݂ܵܠܵܐ ܘܒܸܫܬܵܝܵܐ، ܒܸܓܒ݂ܵܪܵܐ ܘܡܲܓܒ݂ܘܼܪܹܐ، ܗܲܠܔ ܝܵܘܡܵܐ ܕܥܒ݂ܝܼܪܹܗ ܢܘܿܚ ܓܵܘ ܩܹܒ݂ܘܼܬܵ‌ܐ، ܘܐܬܹ‌ܐ ܠܹܗ ܛܵܘܦܵܢܵܐ ܘܚܢܝܼܩ ܠܹܗ ܠܟܠܔ ܐܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","”ܡܸܢܕܪܸܫ ܕܵܐܟ݂ܝܼ ܕܗܘܹܐ ܠܹܗ ܒܝܵܘܡܵܢܹ̈ܐ ܕܠܘܿܛ، ܐܢܵܫܹ̈ܐ ܒܹܐܟ݂ܵܠܵܐ ܝܗܘܵܘ ܘܒܸܫܬܵܝܵܐ، ܒܸܙܒ݂ܵܢܵܐ ܘܙܲܒܘܼܢܹܐ، ܒܸܢܨܵܒ݂ܵܐ ܘܒܸܒܢܵܝܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","”ܘܒܝܵܘܡܵܐ ܕܦܠܝܼܛ ܠܹܗ ܠܘܿܛ ܡ̣ܢ ܣܕܘܿܡ، ܡܘܼܥܪܹܐ ܠܹܗ ܡܵܪܝܵܐ ܢܘܼܪܵܐ ܘܟܸܒܪܝܼܬ ܡ̣ܢ ܫܡܲܝܵܐ ܘܛܘܼܠܸܩ ܠܹܗ ܠܟܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","”ܗܵܕܟ݂ܵܐ ܒܸܬ ܗܵܘܹܐ ܐܝܼܡܲܢ ܕܦܵܐܹܫ ܚܸܙܝܵܐ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","”ܒܗ̇ܘ ܝܵܘܡܵܐ، ܡ̇ܢ ܕܝܼܠܹܗ ܥܲܠܔ ܐܓܵܪܹܐ ܘܡܸܢܕܝܼܹܗ ܓܵܘ ܒܲܝܬܵ‌ܐ، ܠܵܐ ܨܵܠܹܐ ܠܸܫܩܵܠܹܗ، ܘܗ̇ܘ ܕܝܼܠܹܗ ܓܵܘ ܚܲܩܠܵܐ، ܠܵܐ ܕܵܐܹܪ ܠܒܵܬܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","”ܕܟ݂ܘܿܪܘܼܢ ܠܒܲܟ݂ܬܵ‌ܐ ܕܠܘܿܛ. ");
INSERT INTO aii_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","”ܡ̇ܢ ܕܒܵܥܹܐ ܡܲܚܹܐ ܓܵܢܹܗ ܒܸܬ ܛܲܠܸܩ ܠܵܗ̇، ܘܡ̇ܢ ܕܛܲܠܸܩ ܓܵܢܹܗ ܒܸܬ ܡܲܚܹܐ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","”ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܒܗ̇ܘ ܠܲܝܠܹܐ ܬܪܹܝ ܒܸܬ ܗܵܘܝܼ ܓܵܘ ܚܕܵܐ ܫܘܝܼܬܵ‌ܐ؛ ܚܲܕ ܒܸܬ ܦܵܐܹܫ ܠܘܼܒܠܵܐ ܘܗ̇ܘ ܐܚܹܪܢܵܐ ܫܒ݂ܝܼܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","”ܘܬܲܪܬܹܝ ܒܲܟ݂ܬܵܬܹ̈‌ܐ ܒܸܬ ܗܵܘܝܼ ܒܸܓܪܵܣܵܐ ܡܥܘܼܕܵܠܹܐ؛ ܚܕܵܐ ܒܸܬ ܦܵܝܫܵܐ ܠܘܼܒܸܠܬܵ‌ܐ ܘܚܕܵܐ ܒܸܬ ܦܵܝܫܵܐ ܫܒ݂ܝܼܩܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","”ܬܪܹܝ ܒܸܬ ܗܵܘܝܼ ܒܚܲܩܠܵܐ؛ ܚܲܕ ܒܸܬ ܦܵܐܹܫ ܠܘܼܒܠܵܐ ܘܚܲܕ ܒܸܬ ܦܵܐܹܫ ܫܒ݂ܝܼܩܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܠܐܲܝܟܵܐ ܡܵܪܲܢ؟“ ܓ̰ܘܼܘܸܒ ܠܹܗ: ”ܐܲܝܟܵܐ ܕܝܼܠܹܗ ܦܲܓ݂ܪܵܐ، ܬܵܡܵܐ ܒܸܬ ܓ̰ܵܡܥܝܼ ܢܸܫܪܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ ܡܲܬܠܵܐ، ܕܘܵܠܹܐ ܝܠܵܗ̇ ܐܢܵܫܹ̈ܐ ܨܲܠܝܼ ܨܠܘܿܬܵ‌ܐ ܟܠܔ ܥܕܵܢܵܐ ܘܠܵܐ ܣܵܩܕܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","”ܚܲܕ ܕܲܝܵܢܵܐ ܐܝܼܬ ܗܘܵܐ ܓܵܘ ܚܕܵܐ ܡܕܝܼܢ݇ܬܵ‌ܐ، ܕܡ̣ܢ ܐܲܠܵܗܵܐ ܠܹܐ ܙܵܕܹܥ ܗܘܵܐ ܘܡ̣ܢ ܒܢܲܝ̈ܢܵܫܵܐ ܠܹܐ ܢܵܟܹܦ ܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","”ܚܕܵܐ ܐܲܪܡܸܠܬܵ‌ܐ ܐܝܼܬ ܗܘܵܐ ܒܗ̇ܝ ܡܕܝܼܢ݇ܬܵ‌ܐ، ܘܟܹܐ ܐܵܬܝܵܐ ܗܘܵܐ ܠܟܸܣܠܹܗ ܘܐܵܡܪܵܐ ܗܘܵܐ ܐܸܠܹܗ: ’ܥܒ݂ܘܿܕ ܠܵܗ̇ ܕܝܼܘܵܢܝܼ ܡ̣ܢ ܕܲܠܩܘܼܒ݂ܠܵܝܝܼ.‘ ");
INSERT INTO aii_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","”ܠܹܐ ܒܵܥܹܐ ܗܘܵܐ ܩܵܐ ܚܲܕ ܙܲܒ݂ܢܵܐ ܝܲܪܝܼܟ݂ܵܐ، ܐܝܼܢܵܐ ܡ̣ܢ ܒܵܬܪ ܗܵܕܵܐ ܐܡܝܼܪܹܗ ܒܓܵܢܹܗ: ’ܐܘܼܦ ܐܸܢ ܕܡ̣ܢ ܐܲܠܵܗܵܐ ܠܹܐ ܝܘܸܢ ܒܸܙܕܵܥܵܐ، ܘܡ̣ܢ ܒܢܲܝ̈ܢܵܫܵܐ ܠܹܐ ܝܘܸܢ ܒܸܢܟ݂ܵܦܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","”’ܒܸܬ ܥܵܒ݂ܕܹܢܵܗ̇ ܕܝܼܘܵܢ ܕܐܵܗܵܐ ܐܲܪܡܸܠܬܵ‌ܐ ܣܵܒܵܒ ܡܲܟܟ̰ܘܼܚܝܼ ܝܠܵܗ̇، ܘܕܠܵܐ ܗܵܘܝܵܐ ܒܟܠܔ ܥܕܵܢܵܐ ܒܹܐܬܵܝܵܐ ܘܡܲܣܩܘܼܕܝܼ.‘“ ");
INSERT INTO aii_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ܘܐܡܝܼܪܹܗ ܡܵܪܲܢ: ”ܫܡܹܥܡܘܼܢ ܡܘܼܕܝܼ ܐܡܝܼܪܹܗ ܕܲܝܵܢܵܐ ܥܵܘܵܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","”ܠܹܐ ܝܬܘܿܢ ܒܸܚܫܵܒ݂ܵܐ ܐܲܠܵܗܵܐ ܒܸܬ ܥܵܒܹܕ ܠܵܗ̇ ܕܝܼܘܵܢ ܕܓܘܼܒܝܘܼ̈ܗ‌ܝ، ܐܲܝܢܝܼ ܕܟܹܐ ܦܲܪܦܸܠܝܼ ܒܝܼܹܗ ܒܝܵܘܡܵܐ ܘܒܠܲܝܠܹܐ، ܘܒܸܬ ܡܲܪܝܸܟ݂ ܒܹܐܢܹܗ ܥܲܠܵܝܗ‌ܝ؟ ");
INSERT INTO aii_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","”ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܒܸܬ ܥܵܒܹܕ ܠܵܗ̇ ܕܝܼܘܵܢܵܝܗ‌ܝ ܒܓ̰ܲܠܕܘܼܬܵ‌ܐ. ܐܝܼܢܵܐ ܐܝܼܡܲܢ ܕܐܵܬܹ‌ܐ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ، ܒܸܬ ܡܲܫ݇ܟ̰ܸܚ ܗܲܝܡܵܢܘܼܬܵ‌ܐ ܥܲܠܔ ܐܲܪܥܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ܘܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܐܵܗܵܐ ܡܲܬܠܵܐ ܠܕܲܠܩܘܼܒ݂ܠܔ ܕܐܵܢܝܼ ܕܟܹܐ ܗܲܡܸܢܝܼ ܗܘܵܘ ܒܓܵܢܵܝܗ‌ܝ ܕܙܲܕܝܼܩܹ̈ܐ ܝܗܘܵܘ ܘܡܲܣܠܝܼ ܗܘܵܘ ܠܐܚܹܪ̈ܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","”ܬܪܹܝ ܐܢܵܫܹ̈ܐ ܐܣܝܼܩ ܠܗܘܿܢ ܠܗܲܝܟܠܵܐ ܠܨܲܠܘܼܝܹܐ، ܚܲܕ ܦܪܝܼܫܵܐ ܘܗ̇ܘ ܐܚܹܪܢܵܐ ܡܵܟ݂ܣܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","”ܗ̇ܘ ܦܪܝܼܫܵܐ ܟܸܠܝܵܐ ܝܗܘܵܐ ܨܲܠܘܼܝܹܐ ܓܵܘ ܓܵܢܹܗ ܗܵܕܟ݂ܵܐ: ’ܝܵܐ ܐܲܠܵܗܵܐ، ܫܲܟܘܼܪܘܼܟ݂ ܝܼܘܸܢ ܕܠܹܐ ܝܘܸܢ ܡܐܲܝܟ݂ ܐܢܵܫܹ̈ܐ ܐܚܹܪ̈ܢܹܐ، ܚܵܛܘܿܦܹ̈ܐ، ܘܥܵܘܵܠܹ̈ܐ، ܘܙܲܢܵܝܹ̈ܐ، ܘܠܵܐ ܐܲܝܟ݂ ܐܵܗܵܐ ܡܵܟ݂ܣܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","”’ܟܹܐ ܨܵܝܡܹܢ ܬܲܪܬܹܝ ܓܵܗܹ̈ܐ ܒܫܲܒܬܵ‌ܐ، ܘܟܹܐ ܝܵܗܒܹܢ ܡܲܥܣܵܪܹ̈ܐ ܥܲܠܔ ܟܠܔ ܡܸܢܕܝܼ ܕܩܵܢܹܝܢ.‘ ");
INSERT INTO aii_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","”ܐܝܼܢܵܐ ܡܵܟ݂ܣܵܐ ܟܸܠܝܵܐ ܝܗܘܵܐ ܡ̣ܢ ܪܸܚܩܵܐ ܘܠܹܐ ܒܵܥܹܐ ܗܘܵܐ ܐܘܼܦ ܥܲܝܢܘܼ̈ܗ‌ܝ ܡܲܪܸܡ ܗܘܵܐ ܠܗܘܿܢ ܠܫܡܲܝܵܐ، ܐܸܠܵܐ ܒܸܡܚܵܝܵܐ ܝܗܘܵܐ ܥܲܠܔ ܨܲܕܪܹܗ، ܒܹܐܡܵܪܵܐ: ’ܝܵܐ ܐܲܠܵܗܵܐ، ܪܲܚܸܡ ܥܲܠܝܼ، ܐܵܢܵܐ ܚܲܛܵܝܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","”ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܵܗܵܐ ܡܵܟ݂ܣܵܐ ܨܠܹܐ ܠܹܗ ܠܒܲܝܬܹܗ ܒܘܼܫ ܙܲܕܝܼܩܵܐ ܩܲܕܡ ܐܲܠܵܗܵܐ ܡ̣ܢ ܗ̇ܘ ܦܪܝܼܫܵܐ. ܣܵܒܵܒ ܟܠܔ ܡ̇ܢ ܕܡܲܪܸܡ ܠܵܗ̇ ܓܵܢܹܗ ܒܸܬ ܦܵܐܹܫ ܡܘܼܟܸܦܵܐ، ܘܟܠܔ ܡ̇ܢ ܕܡܲܟܸܦ ܓܵܢܹܗ ܒܸܬ ܦܵܐܹܫ ܡܘܼܪܡܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܐܢܵܫܹ̈ܐ ܝܵܠܹ̈ܕ݇ܐ ܙܥܘܿܪܹ̈ܐ ܠܟܸܣ ܝܼܫܘܿܥ ܕܡܲܬܸܒ݂ ܗܘܵܐ ܐܝܼܕܵܐ ܥܲܠܵܝܗ‌ܝ. ܐܝܼܢܵܐ ܬܲܠܡܝܼ̈ܕܹܐ ܐܝܼܡܲܢ ܕܚܸܙܝܵܝ ܠܗܘܿܢ ܡܘܼܢܟܸܣܵܝ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܩܸܪܝܵܝ ܠܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܫܒ݂ܘܿܩܘܼܢ ܝܵܠܹ̈ܕ݇ܐ ܙܥܘܿܪܹ̈ܐ ܐܵܬ‌ܝܼ ܠܟܸܣܠܝܼ ܘܠܵܐ ܡܲܟܠܹܝܬܘܿܢ ܠܗܘܿܢ، ܣܵܒܵܒ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ ܩܵܐ ܐܵܢܝܼ ܝܠܵܗ̇ ܕܝܼܢܵܐ ܡܐܲܝܟ݂ ܐܲܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܡ̇ܢ ܕܠܵܐ ܩܲܒܸܠܔ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ ܐܲܝܟ݂ ܚܲܕ ܝܵܠܵܕ݇ܐ ܙܥܘܿܪܵܐ ܠܹܐ ܥܵܒܹܪ ܓܵܘܘܼܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ܒܘܼܩܸܪܹܗ ܚܲܕ ܡ̣ܢ ܓܘܼܪ̈ܵܢܹܐ، ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܡܲܠܦܵܢܵܐ ܛܵܒ݂ܵܐ، ܡܘܼܕܝܼ ܥܵܒ݂ܕܹܢ ܕܝܵܪܬܹܢ ܚܲܝܹ̈ܐ ܕܠܥܵܠܲܡ؟“ ");
INSERT INTO aii_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܩܵܡܘܿܕܝܼ ܒܸܩܪܵܝܝܼ ܝܘܸܬ ܛܵܒ݂ܵܐ؟ ܠܲܝܬ ܛܵܒ݂ܵܐ ܐܸܠܵܐ ܚܲܕ، ܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","”ܟܹܐ ܝܵܕܥܹܬ ܦܘܼܩܕܵܢܹ̈ܐ: ܠܵܐ ܩܵܛܠܹܬ، ܠܵܐ ܙܵܢܹܝܬ، ܠܵܐ ܓܵܢܒܹܬ، ܠܵܐ ܝܵܗܒܹܬ ܣܵܗܕܘܼܬܵ‌ܐ ܕܕܘܼܓܠܵܐ، ܡܝܲܩܸܪ ܠܒܵܒܘܼܟ݂ ܘܠܝܸܡܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ: ”ܐܲܢܹܐ ܟܠܵܝܗ‌ܝ ܢܛܝܼܪܵܝ ܝܘܸܢ ܡ̣ܢ ܝܵܠܕ݇ܘܼܬ‌ܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܹܗ ܝܼܫܘܿܥ، ܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܚܲܕ ܡܸܢܕܝܼ ܒܵܨܘܿܪܵܐ ܝܠܹܗ ܐܸܠܘܼܟ݂: ܙܲܒܸܢ ܟܠܔ ܡܸܢܕܝܼ ܕܐܝܼܬ ܠܘܼܟ݂ ܘܗܲܒ݂ܠܔ ܠܹܗ ܠܡܸܣܟܹܢܹ̈ܐ، ܘܒܸܬ ܗܵܘܹܐ ܠܘܼܟ݂ ܣܝܼܡܬܵ‌ܐ ܒܫܡܲܝܵܐ، ܘܬܵ‌ܐ ܒܵܬܪܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ܐܝܼܢܵܐ ܗ̇ܘ ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܹܗ ܐܲܢܹܐ، ܦܫܝܼܡ ܠܹܗ، ܣܵܒܵܒ ܪܵܒܵܐ ܥܲܬܝܼܪܵܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ܟܲܕ ܚܙܹܐ ܠܹܗ ܝܼܫܘܿܥ ܕܦܫܝܼܡ ܠܹܗ، ܐܡܝܼܪܹܗ: ”ܟܡܵܐ ܥܲܣܩܵܐ ܝܠܵܗ̇ ܠܐܵܢܝܼ ܕܐܝܼܬ ܠܗܘܿܢ ܥܘܼܬܪܵܐ ܥܵܒ݂ܪܝܼ ܠܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","”ܒܘܼܫ ܦܫܘܼܩܬܵ‌ܐ ܝܠܵܗ̇ ܠܓܘܼܡܠܵܐ ܠܸܥܒ݂ܵܪܵܐ ܒܢܸܩܒܵܐ ܕܚܡܵܛܵܐ ܡ̣ܢ ܕܥܲܬܝܼܪܵܐ ܥܵܒܹܪ ܠܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ܐܵܢܝܼ ܕܫܡܝܼܥ ܠܗܘܿܢ ܐܡܝܼܪܗܘܿܢ: ”ܒܵܣ ܡܵܢܝܼ ܡܵܨܹܐ ܦܵܪܹܩ؟“ ");
INSERT INTO aii_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ: ”ܟܠܔ ܡܸܢܕܝܼ ܕܠܹܐ ܝܠܹܗ ܡܸܬܡܲܨܝܵܢܵܐ ܠܟܸܣ ܒܢܲܝ̈ܢܵܫܵܐ، ܡܸܬܡܲܨܝܵܢܵܐ ܝܠܹܗ ܠܟܸܣ ܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ: ”ܐܲܚܢܲܢ ܫܒ݂ܝܼܩ ܠܲܢ ܟܠܔ ܡܸܢܕܝܼ ܘܐܬܹ‌ܐ ܠܲܢ ܒܵܬܪܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܐܸܠܵܝܗ‌ܝ: ”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ، ܠܲܝܬ ܐܢܵܫܵܐ ܕܫܵܒܹܩ ܒܲܝܬܵ‌ܐ ܝܲܢ ܐܲܒ݂ܵܗܹ̈ܐ ܝܲܢ ܐܲܚܘܿܢܘܵܬܹ̈‌ܐ ܝܲܢ ܒܲܟ݂ܬܵ‌ܐ ܝܲܢ ܒܢܘܿܢܹ̈ܐ، ܒܘܼܬ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","”ܘܠܵܐ ܩܲܒܸܠܔ ܪܵܒܵܐ ܒܘܼܫ ܙܵܘܕܵܐ ܒܐܵܗܵܐ ܙܲܒ݂ܢܵܐ، ܘܒܙܲܒ݂ܢܵܐ ܕܐܵܬܹ‌ܐ، ܚܲܝܹ̈ܐ ܕܠܥܵܠܲܡ.“ ");
INSERT INTO aii_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ܠܘܼܒܸܠܔ ܠܹܗ ܝܼܫܘܿܥ ܠܬܪܸܥܣܲܪ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܗܵܐ ܒܹܐܣܵܩܵܐ ܝܘܲܚ ܠܐܘܿܪܸܫܠܸܡ، ܘܒܸܬ ܦܵܝܫܝܼ ܬܘܼܡܸܡܹܐ ܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܦܝܼܫܹܐ ܝܢܵܐ ܟܬܝܼܒܹܐ ܒܝܲܕ ܢܒ݂ܝܼܹ̈ܐ ܒܘܼܬ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","”ܒܸܬ ܦܵܐܹܫ ܣܘܼܦܝܵܐ ܠܐܸܡܘܵܬܹ̈‌ܐ، ܒܸܬ ܡܲܣܚܸܪܝܼ ܒܝܼܹܗ ܘܒܸܬ ܪܵܝܩܝܼ ܥܲܠܔ ܦܵܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","”ܒܸܬ ܡܵܚܝܼ ܠܹܗ ܒܫܵܘܛܹ̈ܐ، ܘܒܸܬ ܩܵܛܠܝܼ ܠܹܗ، ܘܒܝܵܘܡܵܐ ܕܬܠܵܬܵ‌ܐ ܒܸܬ ܩܵܐܹܡ.“ ");
INSERT INTO aii_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ܐܝܼܢܵܐ ܐܵܢܝܼ ܠܵܐ ܦܘܼܪܡܹܐ ܠܗܘܿܢ ܐܘܼܦ ܚܕܵܐ ܡ̣ܢ ܐܲܢܹܐ، ܣܵܒܵܒ ܛܫܝܼܬܵ‌ܐ ܝܗܘܵܐ ܡܸܢܵܝܗ‌ܝ ܐܵܗܵܐ ܗܹܡܸܙܡܵܢ، ܘܠܹܐ ܝܗܘܵܘ ܒܝܼܕܵܥܵܐ ܡܸܢܕܝܼܵܢܹ̈ܐ ܕܦܝܵܫܵܐ ܝܗܘܵܘ ܐܡܝܼܪܹܐ ܐܸܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ܟܲܕ ܩܘܼܪܒܸܢܹܗ ܝܼܫܘܿܥ ܠܐܝܼܪܝܼܚܘܿ، ܗܵܐ ܚܲܕ ܣܸܡܝܵܐ ܝܬܝܼܒ݂ܵܐ ܝܗܘܵܐ ܥܲܠܔ ܡܲܪܙܵܐ ܕܐܘܼܪܚܵܐ ܒܸܓܒ݂ܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܹܗ ܟܸܢܫܵܐ ܒܸܥܒ݂ܵܪܵܐ، ܒܘܼܩܸܪܹܗ: ”ܡܘܼܕܝܼ ܝܠܹܗ ܐܵܗܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܐܸܠܹܗ: ”ܝܼܫܘܿܥ ܢܵܨܪܵܝܵܐ ܒܸܥܒ݂ܵܪܵܐ ܝܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ܡܘܼܩܘܸܚ ܠܹܗ ܘܐܡܝܼܪܹܗ: ”ܝܼܫܘܿܥ ܒܪܘܿܢܵܐ ܕܕܵܘܝܼܕ، ܪܲܚܸܡ ܥܲܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ܐܵܢܝܼ ܕܒܹܐܙܵܠܵܐ ܝܗܘܵܘ ܡ̣ܢ ܩܲܕܡ ܝܼܫܘܿܥ ܢܓ̰ܝܼܘ ܠܗܘܿܢ ܒܝܼܹܗ ܕܫܵܬܹܩ ܗܘܵܐ. ܐܝܼܢܵܐ ܗ̇ܘ ܒܘܼܫ ܙܵܘܕܵܐ ܡܲܩܘܸܚ ܗܘܵܐ: ”ܝܵܐ ܒܪܘܿܢܵܐ ܕܕܵܘܝܼܕ، ܪܲܚܸܡ ܥܲܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ܘܟܠܹܐ ܠܹܗ ܝܼܫܘܿܥ ܘܦܩܝܼܕ ܠܹܗ ܕܡܲܝܬ‌ܝܼ ܗܘܵܘ ܠܹܗ ܠܟܸܣܠܹܗ. ܘܐܝܼܡܲܢ ܕܐܬܹ‌ܐ ܠܹܗ، ܒܘܼܩܸܪܹܗ ܡܸܢܹܗ: ");
INSERT INTO aii_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","”ܡܘܼܕܝܼ ܒܵܥܹܝܬ ܕܥܵܒ݂ܕܹܢ ܐܸܠܘܼܟ݂؟“ ܘܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ: ”ܡܵܪܝܼ، ܒܵܥܹܝܢ ܕܚܵܙܹܝܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܚܙܝܼ. ܗܲܝܡܵܢܘܼܬܘܼܟ݂ ܩܵܡ ܒܲܣܡܵܐ ܠܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ܒܗ̇ܝ ܥܕܵܢܵܐ ܚܙܹܐ ܠܹܗ، ܘܐܬܹ‌ܐ ܠܹܗ ܒܵܬܪ ܝܼܫܘܿܥ ܫܲܒܘܼܚܹܐ ܠܐܲܠܵܗܵܐ. ܘܐܘܼܦ ܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܚܙܹܐ ܠܗܘܿܢ ܫܲܒܚܝܼ ܗܘܵܘ ܠܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ܥܒ݂ܝܼܪܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܓܵܘ ܐܝܼܪܝܼܚܘܿ. ");
INSERT INTO aii_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ܘܐܝܼܬ ܗܘܵܐ ܬܵܡܵܐ ܚܲܕ ܐܢܵܫܵܐ ܥܲܬܝܼܪܵܐ ܫܸܡܹܗ ܙܲܟܲܝ، ܓܘܼܪܵܐ ܕܡܵܟ݂ܣܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ܒܵܥܹܐ ܗܘܵܐ ܕܚܵܙܹܐ ܗܘܵܐ ܠܝܼܫܘܿܥ ܡܵܢܝܼ ܝܠܹܗ، ܘܠܹܐ ܡܵܨܹܐ ܗܘܵܐ ܡ̣ܢ ܟܸܢܫܵܐ، ܣܵܒܵܒ ܟܸܪܝܵܐ ܝܗܘܵܐ ܒܩܵܘܡܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ܪܚܝܼܛ ܠܹܗ ܠܩܲܕܡܵܐ ܘܐܣܝܼܩ ܠܹܗ ܠܐܝܼܠܵܢܵܐ ܕܬܹܐܢܹ̈ܐ ܕܚܵܙܹܐ ܗܘܵܐ ܠܹܗ، ܣܵܒܵܒ ܒܸܬ ܥܵܒܹܪ ܗܘܵܐ ܡ̣ܢ ܗ̇ܝ ܐܘܼܪܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ܐܝܼܡܲܢ ܕܡܛܹܐ ܠܹܗ ܝܼܫܘܿܥ ܠܗ̇ܝ ܕܘܼܟܵܐ ܘܓܘܼܫܸܩ ܠܹܗ ܥܸܠܸܠܔ ܐܡܝܼܪܹܗ: ”ܙܲܟܲܝ، ܡܲܠܝܸܙ ܘܨܠܝܼ، ܣܵܒܵܒ ܘܵܠܹܐ ܝܠܵܗ̇ ܐܸܕܝܘܿܡ ܝܵܘܡܵܐ ܕܫܵܪܹܝܢ ܓܵܘ ܒܲܝܬܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ܡܘܼܠܝܸܙ ܠܹܗ ܙܲܟܲܝ ܘܨܠܹܐ ܠܹܗ، ܘܩܘܼܒܸܠܔ ܠܹܗ ܐܸܠܹܗ ܒܚܲܕܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ܐܝܼܢܵܐ ܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܚܙܹܐ ܠܗܘܿܢ ܛܘܼܪܛܸܡ ܠܗܘܿܢ ܘܐܡܝܼܪܗܘܿܢ: ”ܥܒ݂ܝܼܪܹܗ ܘܫܪܹܐ ܠܹܗ ܠܟܸܣ ܐܢܵܫܵܐ ܚܲܛܵܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ܘܟܠܹܐ ܠܹܗ ܙܲܟܲܝ ܘܐܡܝܼܪܹܗ ܠܡܵܪܲܢ: ”ܚܙܝܼ ܡܵܪܝܼ، ܦܲܠܓܵܐ ܕܡܸܢܕܝܼܝܼ ܒܸܬ ܝܵܗܒܹܢܹܗ ܠܡܸܣܟܹܢܹ̈ܐ، ܘܐܸܢ ܙܠܝܼܡܵܐ ܝܘܸܢ ܠܐܢܵܫܵܐ، ܒܸܬ ܦܵܪܥܹܢܹܗ ܚܲܕ ܒܐܲܪܒܥܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܐܸܕܝܘܿܡ ܝܵܘܡܵܐ ܗܘܹܐ ܠܹܗ ܦܘܼܪܩܵܢܵܐ ܠܐܵܗܵܐ ܒܲܝܬܵ‌ܐ، ܣܵܒܵܒ ܐܘܼܦ ܐܵܗܵܐ ܒܪܘܿܢܵܐ ܕܐܲܒ݂ܪܵܗܵܡ ܝܼܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","”ܣܵܒܵܒ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܐܬܹ‌ܐ ܠܹܗ ܕܛܵܥܹܐ ܘܦܲܪܸܩ ܠܗ̇ܘ ܕܝܼܗܘܵܐ ܛܠܝܼܩܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ܟܲܕ ܫܡܝܼܥ ܠܗܘܿܢ ܐܲܢܹܐ، ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܚܲܕ ܡܲܬܠܵܐ ܐܚܹܪܢܵܐ، ܣܵܒܵܒ ܩܲܪܒܘܼܢܹܐ ܝܗܘܵܐ ܠܐܘܿܪܸܫܠܸܡ، ܘܚܵܫܒ݂ܝܼ ܗܘܵܘ ܒܗ̇ܝ ܥܕܵܢܵܐ ܒܸܬ ܦܵܝܫܵܐ ܗܘܵܐ ܓܠܝܼܬܵ‌ܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ܐܡܝܼܪܹܗ: ”ܚܲܕ ܐܢܵܫܵܐ ܡܥܲܠܝܵܐ ܐܙܝܼܠܔ ܠܹܗ ܠܚܲܕ ܐܲܬܪܵܐ ܪܸܚܩܵܐ ܕܩܲܒܸܠܔ ܡܲܠܟܘܼܬܵ‌ܐ ܘܕܵܐܹܪ. ");
INSERT INTO aii_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","”ܩܪܹܐ ܠܹܗ ܥܸܣܪܵܐ ܪܹ̈ܓܵܘܵܬܘܼܗ‌ܝ ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܥܸܣܪܵܐ ܟܲܟܪܹ̈ܐ ܘܐܡܝܼܪܹܗ: ’ܡܲܦܠܸܚܘܼܢ ܠܗܘܿܢ ܗܲܠܔ ܕܕܵܝܪܹܢ.‘ ");
INSERT INTO aii_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","”ܐܝܼܢܵܐ ܒܢܲܝ̈ ܡܕܝܼܢ݇ܬܹܗ ܟܹܐ ܣܵܢܝܼ ܗܘܵܘ ܠܹܗ، ܗܵܕܟ݂ܵܐ ܫܘܼܕܸܪܗܘܿܢ ܡ̣ܢ ܒܵܬܪ ܡܸܢܹܗ ܐܝܼܙܓܲܕܹ̈ܐ ܒܹܐܡܵܪܵܐ: ’ܠܹܐ ܒܵܣܡܵܐ ܠܲܢ ܕܐܵܗܵܐ ܐܢܵܫܵܐ ܥܵܒܹܕ ܫܘܼܠܛܵܢܵܐ ܥܲܠܲܢ.‘ ");
INSERT INTO aii_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","”ܡ̣ܢ ܒܵܬܪ ܕܦܝܼܫ ܠܹܗ ܥܒ݂ܝܼܕܵܐ ܡܲܠܟܵܐ، ܕܝܼܪܹܗ ܘܦܩܝܼܕ ܠܹܗ ܕܦܵܝܫܝܼ ܩܸܪܝܹܐ ܐܵܢܝܼ ܪܹ̈ܓܵܘܵܬܹ‌ܐ ܕܝܘܼܗܒ݂ܵܐ ܝܗܘܵܐ ܐܸܠܵܝܗ‌ܝ ܙܘܼܙܹ̈ܐ، ܕܝܵܕܹܥ ܗܘܵܐ ܡܘܼܕܝܼ ܟܠܔ ܚܲܕ ܡܸܢܵܝܗ‌ܝ ܩܸܢܝܵܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ܐܬܹ‌ܐ ܠܹܗ ܗ̇ܘ ܩܲܕܡܵܝܵܐ ܘܐܡܝܼܪܹܗ: ’ܡܵܪܝܼ، ܟܲܟܪܘܼܟ݂ ܩܢܹܐ ܠܹܗ ܥܸܣܪܵܐ ܟܲܟܪܹ̈ܐ ܐܚܹܪ̈ܢܹܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","”ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܡܵܪܹܗ: ’ܛܘܼܒ݂ܵܐ ܐܸܠܘܼܟ݂ ܪܹܓܵܐ ܛܵܒ݂ܵܐ، ܣܵܒܵܒ ܗܘܹܐ ܠܘܼܟ݂ ܡܗܘܼܡܢܵܐ ܒܚܲܕ ܡܸܢܕܝܼ ܙܥܘܿܪܵܐ، ܗܘܝܼ ܡܕܲܒܪܵܢܵܐ ܥܲܠܔ ܥܣܲܪ ܡܕܝܼܢܵܬܹ̈‌ܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","”ܐܬܹ‌ܐ ܠܹܗ ܗ̇ܘ ܕܬܪܹܝ ܘܐܡܝܼܪܹܗ: ’ܡܵܪܝܼ، ܟܲܟܪܘܼܟ݂ ܩܢܹܐ ܠܹܗ ܚܲܡܫܵܐ ܟܲܟܪܹ̈ܐ ܐܚܹܪ̈ܢܹܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","”ܐܘܼܦ ܠܗ̇ܘ ܐܡܝܼܪܹܗ: ’ܗܘܝܼ ܡܕܲܒܪܵܢܵܐ ܥܲܠܔ ܚܲܡܸܫ ܡܕܝܼܢܵܬܹ̈‌ܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","”ܐܬܹ‌ܐ ܠܹܗ ܗ̇ܘ ܐܚܹܪܢܵܐ ܘܐܡܝܼܪܹܗ: ’ܡܵܪܝܼ، ܗܵܐ ܫܩܘܿܠܔ ܟܲܟܪܘܼܟ݂ ܕܝܼܗܘܵܐ ܠܟܸܣܠܝܼ، ܐܣܝܼܪܵܐ ܓܵܘ ܝܵܠܸܚܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","”’ܣܵܒܵܒ ܙܕܝܼܥ ܠܝܼ ܡܸܢܘܼܟ݂ ܕܐܢܵܫܵܐ ܩܸܫܝܵܐ ܝܘܸܬ. ܟܹܐ ܫܵܩܠܹܬ ܡ̣ܢ ܐܲܝܟܵܐ ܕܠܵܐ ܡܘܼܬܸܒ݂ ܠܘܼܟ݂، ܘܟܹܐ ܚܵܨܕܹܬ ܡܸܢܕܝܼ ܡ̣ܢ ܐܲܝܟܵܐ ܕܠܵܐ ܙܪܝܼܥ ܠܘܼܟ݂.‘ ");
INSERT INTO aii_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","”ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ ܡܵܪܹܗ: ’ܡ̣ܢ ܦܘܼܡܘܼܟ݂ ܒܸܬ ܕܵܝܢܹܢܘܼܟ݂ ܝܵܐ ܪܹܓܵܐ ܒܝܼܫܵܐ. ܒܝܼܕܵܥܵܐ ܝܘܸܬ ܗܘܵܐ ܕܐܢܵܫܵܐ ܩܸܫܝܵܐ ܝܘܸܢ، ܟܹܐ ܫܵܩܠܹܢ ܡܸܢܕܝܼ ܡ̣ܢ ܐܲܝܟܵܐ ܕܠܵܐ ܡܘܼܬܸܒ݂ ܠܝܼ، ܘܟܹܐ ܚܵܨܕܹܢ ܡܸܢܕܝܼ ܡ̣ܢ ܐܲܝܟܵܐ ܕܠܵܐ ܙܪܝܼܥ ܠܝܼ، ");
INSERT INTO aii_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","”’ܒܵܣ ܩܵܡܘܿܕܝܼ ܠܵܐ ܡܘܼܬܸܒ݂ ܠܘܼܟ݂ ܙܘܼܙܝܼ ܠܟܸܣ ܨܲܪ̈ܵܦܹܐ ܕܐܵܬܹܝܢ ܗܘܵܐ ܘܫܵܩܠܹܢ ܗܘܵܐ ܠܹܗ ܥܲܡ ܙܵܘܕܘܼܢܝܹܗ؟‘ ");
INSERT INTO aii_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","”ܘܐܡܝܼܪܹܗ ܠܐܵܢܝܼ ܕܟܸܠܝܹܐ ܝܗܘܵܘ ܠܟܸܣܠܹܗ: ’ܫܩܘܿܠܘܼܢ ܡܸܢܹܗ ܟܲܟܪܵܐ ܘܗܲܒ݂ܠܘܼܢ ܠܹܗ ܠܗ̇ܘ ܕܐܝܼܬ ܠܹܗ ܥܸܣܪܵܐ ܟܲܟܪܹ̈ܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","”ܘܐܵܢܝܼ ܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ’ܡܵܪܲܢ، ܗ̇ܘ ܐܝܼܬ ܠܹܗ ܥܸܣܪܵܐ ܟܲܟܪܹ̈ܐ.‘ ");
INSERT INTO aii_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","”ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ: ’ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܟܠܔ ܡ̇ܢ ܕܐܝܼܬ ܠܹܗ ܒܸܬ ܦܵܐܹܫ ܝܘܼܗܒ݂ܵܐ ܐܸܠܹܗ، ܘܡ̇ܢ ܕܠܲܝܬ ܠܹܗ، ܐܘܼܦ ܗ̇ܘ ܕܐܝܼܬ ܠܹܗ ܒܸܬ ܦܵܐܹܫ ܫܩܝܼܠܵܐ ܡܸܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","”’ܐܝܼܢܵܐ ܕܸܫ̃ܡܸܢܝܼ̈، ܐܵܢܝܼ ܕܠܵܐ ܒܣܝܼܡ ܠܵܗ̇ ܠܗܘܿܢ ܕܗܵܘܹܝܢ ܗܘܵܐ ܡܲܠܟܵܐ ܥܲܠܵܝܗ‌ܝ، ܡܲܝܬܹܝܡܘܼܢ ܠܗܘܿܢ ܘܩܛܘܿܠܘܼܢ ܠܗܘܿܢ ܩܲܕܡܝܼ.‘“ ");
INSERT INTO aii_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ܟܲܕ ܗܘܼܡܙܸܡ ܠܹܗ ܝܼܫܘܿܥ ܐܲܢܹܐ، ܦܠܝܼܛ ܠܹܗ ܠܐܘܼܪܚܹܗ ܘܐܙܝܼܠܔ ܠܹܗ ܩܲܕܡܵܐ ܩܲܕܡܵܝܗ‌ܝ ܒܹܐܣܵܩܵܐ ܠܐܘܿܪܸܫܠܸܡ. ");
INSERT INTO aii_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ܐܝܼܡܲܢ ܕܡܛܹܐ ܠܹܗ ܠܒܹܝܬ ܦܵܓܹ̈ܐ ܘܠܒܹܝܬ ܥܲܢܝܵܐ، ܠܓܹܒܵܐ ܕܛܘܼܪܵܐ ܕܦܝܵܫܵܐ ܝܠܹܗ ܩܸܪܝܵܐ ܛܘܼܪܵܐ ܕܙܲܝ̈ܬܹ‌ܐ، ܫܘܼܕܸܪܹܗ ܬܪܹܝ ܡ̣ܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ");
INSERT INTO aii_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܙܹܠ݇ܡܘܼܢ ܠܡܵܬܵ‌ܐ ܕܝܼܠܵܗ̇ ܠܒܲܠܩܘܼܒ݂ܠܲܢ، ܘܐܝܼܡܲܢ ܕܥܵܒ݂ܪܝܼܬܘܿܢ ܓܵܘܘܼܗ̇، ܒܸܬ ܡܲܫ݇ܟ̰ܚܝܼܬܘܿܢ ܓ̰ܲܥܫܵܐ ܐܣܝܼܪܵܐ ܗ̇ܘ ܕܐܢܵܫܵܐ ܗܸܟ̃ ܠܹܐ ܝܠܹܗ ܪܟܝܼܒ݂ܵܐ ܥܲܠܘܼܗ‌ܝ. ܫܪܹܝܡܘܼܢ ܘܡܲܝܬܹܝܡܘܼܢ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","”ܘܐܸܢ ܐܢܵܫܵܐ ܒܲܩܸܪܵܘܟ݂ܘܿܢ: ’ܩܵܡܘܿܕܝܼ ܒܸܫܪܵܝܵܐ ܝܬܘܿܢ ܐܸܠܹܗ؟‘ ܓ̰ܲܘܸܒܝܼܬܘܿܢ ܠܹܗ: ’ܡܵܪܲܢ ܣܢܝܼܩܵܐ ܝܠܹܗ ܐܸܠܹܗ.‘“ ");
INSERT INTO aii_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܐܵܢܝܼ ܕܦܝܼܫ ܠܗܘܿܢ ܫܘܼܕܪܹܐ ܘܡܘܼܫ݇ܟ̰ܸܚ ܠܗܘܿܢ ܕܵܐܟ݂ܝܼ ܕܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ܘܟܲܕ ܒܸܫܪܵܝܵܐ ܝܗܘܵܘ ܠܓ̰ܲܥܫܵܐ، ܒܘܼܩܸܪܗܘܿܢ ܡܵܪ̈ܵܘܵܬܘܼܗ‌ܝ: ”ܩܵܡܘܿܕܝܼ ܒܸܫܪܵܝܵܐ ܝܬܘܿܢ ܠܐܵܗܵܐ ܓ̰ܲܥܫܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܐܸܠܵܝܗ‌ܝ: ”ܡܵܪܲܢ ܣܢܝܼܩܵܐ ܝܠܹܗ ܐܸܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ܘܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣ ܝܼܫܘܿܥ ܘܕܪܹܐ ܠܗܘܿܢ ܥܲܠܔ ܓ̰ܲܥܫܵܐ ܓ̰ܘܼܠܵܝ̈ܗ‌ܝ، ܘܪܟܝܼܒ݂ ܠܹܗ ܝܼܫܘܿܥ ܥܲܠܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ܟܲܕ ܒܹܐܙܵܠܵܐ ܝܗܘܵܐ ܝܼܫܘܿܥ، ܐܵܢܝܼ ܕܥܲܡܹܗ ܫܲܘܝܼ ܗܘܵܘ ܓ̰ܘܼܠܵܝ̈ܗ‌ܝ ܒܐܘܼܪܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ܐܝܼܡܲܢ ܕܡܛܹܐ ܠܹܗ ܠܡܲܨܠܲܝܬܵ‌ܐ ܕܛܘܼܪܵܐ ܕܙܲܝ̈ܬܹ‌ܐ، ܫܘܼܪܹܐ ܠܹܗ ܟܠܹܗ ܟܸܢܫܵܐ ܕܬܲܠܡܝܼ̈ܕܹܐ ܒܸܚܕܵܝܵܐ ܘܫܲܒܘܼܚܹܐ ܠܐܲܠܵܗܵܐ ܒܩܵܠܵܐ ܪܵܡܵܐ ܒܘܼܬ ܟܠܵܝܗ‌ܝ ܚܲܝ̈ܠܹܐ ܓܘܼܪܹ̈ܐ ܕܚܙܹܐ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ܘܐܵܡܪܝܼ ܗܘܵܘ: ”ܒܪܝܼܟ݂ܵܐ ܝܠܹܗ ܡܲܠܟܵܐ ܕܒܹܐܬܵܝܵܐ ܝܠܹܗ ܒܫܸܡܵܐ ܕܡܵܪܝܵܐ. ܫܠܵܡܵܐ ܒܫܡܲܝܵܐ ܘܫܘܼܒ݂ܚܵܐ ܒܲܡܪ̈ܵܘܡܹܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ܐܝܼܢܵܐ ܐܢܵܫܹ̈ܐ ܡ̣ܢ ܦܪ̈ܝܼܫܹܐ ܡ̣ܢ ܓܵܘ ܟܸܢܫܹ̈ܐ ܐܵܡܪܝܼ ܗܘܵܘ ܠܹܗ: ”ܪܲܒܝܼ، ܡܲܫܬܸܩ ܠܬܲܠܡܝܼܕܘܼ̈ܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܸܢ ܐܲܢܹܐ ܫܵܬܩܝܼ، ܟܹܐܦܹ̈ܐ ܒܸܬ ܡܲܩܘܸܚܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ܟܲܕ ܩܘܼܪܒܸܢܹܗ ܝܼܫܘܿܥ ܠܡܕܝܼܢ݇ܬܵ‌ܐ ܘܚܸܙܝܵܐ ܠܹܗ، ܒܟܹܐ ܠܹܗ ܥܲܠܘܼܗ̇، ");
INSERT INTO aii_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ܘܐܡܝܼܪܹܗ: ”ܛܘܼܒ݂ܵܐ ܕܝܵܕܥܲܬ‌ܝ ܗܘܵܐ ܐܲܢ݇ܬ ܒܐܵܗܵܐ ܝܵܘܡܵܐ ܡܘܼܕܝܼ ܒܸܬ ܡܲܝܬܹ‌ܐ ܗܘܵܐ ܥܲܠܵܟ݂ܝ ܫܠܵܡܵܐ! ܐܝܼܢܵܐ ܐܵܕܝܼܵܐ ܛܸܫܝܵܐ ܝܠܹܗ ܡܸܢܵܟ݂ܝ. ");
INSERT INTO aii_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","”ܒܸܬ ܐܵܬ‌ܝܼ ܥܲܠܵܟ݂ܝ ܝܵܘܡܵܢܹ̈ܐ ܕܒܸܬ ܚܲܪܕܝܼ ܠܵܟ݂ܝ ܕܸܫ̃ܡܸܢܵܟ݂ܝ̈، ܡܵܚܝܼ ܫܘܼܪܵܐ ܠܚܵܕܸܪ̈ܘܵܢܵܟ݂ܝ، ܘܚܵܠܨܝܼ ܠܵܟ݂ܝ ܡ̣ܢ ܟܠܔ ܓܹܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","”ܒܸܬ ܬܵܠܚܝܼ ܠܵܟ݂ܝ ܘܒܢܘܿܢܵܟ݂ܝ̈ ܓܵܘܵܟ݂ܝ. ܠܹܐ ܫܵܒ݂ܩܝܼ ܓܵܘܵܟ݂ܝ ܟܹܐܦܵܐ ܥܲܠܔ ܟܹܐܦܵܐ ܣܵܒܵܒ ܠܵܐ ܝܕܝܼܥ ܠܵܟ݂ܝ ܙܲܒ݂ܢܵܐ ܕܣܲܚܒܲܪܬܵܟ݂ܝ.“ ");
INSERT INTO aii_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ܥܒ݂ܝܼܪܹܗ ܝܼܫܘܿܥ ܠܗܲܝܟܠܵܐ ܘܫܘܼܪܹܐ ܠܹܗ ܠܦܲܠܘܼܛܹܐ ܠܐܵܢܝܼ ܕܒܸܙܒ݂ܵܢܵܐ ܝܗܘܵܘ ܘܙܲܒܘܼܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܟܬܝܼܒ݂ܵܐ ܝܠܹܗ ܕܒܲܝܬ‌ܝܼ ܒܸܬ ܗܵܘܹܐ ܒܲܝܬܵ‌ܐ ܕܨܠܘܿܬܵ‌ܐ، ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ ܥܒ݂ܝܼܕ ܠܵܘܟ݂ܘܿܢ ܓܸܦܝܼܬܵ‌ܐ ܕܓܹܢܵܒܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ܘܟܠܔ ܝܵܘܡܵܐ ܟܹܐ ܡܲܠܸܦ ܗܘܵܐ ܒܗܲܝܟܠܵܐ، ܐܝܼܢܵܐ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܣܵܦܪܹ̈ܐ ܘܪܹ̈ܝܫܵܢܹܐ ܕܥܲܡܵܐ ܒܵܥܝܼ ܗܘܵܘ ܕܩܵܛܠܝܼ ܗܘܵܘ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ܐܝܼܢܵܐ ܠܵܐ ܡܨܹܐ ܠܗܘܿܢ ܡܲܫ݇ܟ̰ܚܝܼ ܗܘܵܘ ܚܕܵܐ ܐܘܼܪܚܵܐ ܕܵܐܟ݂ܝܼ ܩܵܛܠܝܼ ܗܘܵܘ ܠܹܗ، ܣܵܒܵܒ ܟܠܵܝܗ‌ܝ ܒܸܫܡܵܥܵܐ ܝܗܘܵܘ ܠܗܹܡܸܙܡܵܢܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ܒܚܲܕ ܡ̣ܢ ܝܵܘܡܵܢܹ̈ܐ ܟܲܕ ܡܲܠܘܼܦܹܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܘܡܲܟܪܘܼܙܹܐ ܓܵܘ ܗܲܝܟܠܵܐ ܩܵܐ ܥܲܡܵܐ، ܩܝܼܡ ܠܗܘܿܢ ܥܲܠܘܼܗ‌ܝ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܣܵܦܪܹ̈ܐ ܘܚܘܵܪ̈ܕܸܩܢܹܐ، ");
INSERT INTO aii_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ܘܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ: ”ܐܡܘܿܪ ܐܸܠܲܢ، ܒܐܲܝܢܝܼ ܫܘܼܠܛܵܢܵܐ ܒܸܥܒ݂ܵܕܵܐ ܝܘܸܬ ܐܲܢܹܐ، ܘܡܵܢܝܼ ܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܘܼܟ݂ ܐܵܗܵܐ ܫܘܼܠܛܵܢܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ: ”ܐܘܼܦ ܐܵܢܵܐ ܒܸܬ ܒܲܩܪܸܢܵܘܟ݂ܘܿܢ ܚܲܕ ܒܘܼܩܵܪܵܐ، ܓ̰ܲܘܸܒܘܼܢ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","”ܡܲܥܡܘܿܕܝܼܬܵ‌ܐ ܕܝܘܿܚܲܢܵܢ ܡ̣ܢ ܐܲܠܵܗܵܐ ܝܗܘܵܐ ܝܲܢ ܡ̣ܢ ܒܢܲܝ̈ܢܵܫܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ܘܐܵܢܝܼ ܕܪܝܼܫ ܠܗܘܿܢ ܥܲܡ ܥܘܼܕܵܠܹܐ ܘܐܡܝܼܪܗܘܿܢ: ”ܐܸܢ ܐܵܡܪܲܚ، ܡ̣ܢ ܐܲܠܵܗܵܐ، ܒܸܬ ܐܵܡܹܪ ܐܸܠܲܢ: ’ܒܵܣ ܩܵܡܘܿܕܝܼ ܠܵܐ ܗܘܼܡܸܢܵܘܟ݂ܘܿܢ ܒܝܼܹܗ؟‘ ");
INSERT INTO aii_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","”ܘܐܸܢ ܐܵܡܪܲܚ، ܡ̣ܢ ܒܢܲܝ̈ܢܵܫܵܐ، ܟܠܹܗ ܥܲܡܵܐ ܒܸܬ ܪܵܓ̰ܹܡ ܠܲܢ، ܣܵܒܵܒ ܟܠܵܝܗ‌ܝ ܗܘܼܡܸܢܹܐ ܝܢܵܐ ܕܝܘܿܚܲܢܵܢ ܢܒ݂ܝܼܵܐ ܝܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܐܸܠܹܗ: ”ܠܹܐ ܝܵܕܥܲܚ ܡ̣ܢ ܐܲܝܟܵܐ ܝܗܘܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܐܘܼܦ ܐܵܢܵܐ ܠܹܐ ܐܵܡܪܹܢ ܐܸܠܵܘܟ݂ܘܿܢ ܒܐܲܝܢܝܼ ܫܘܼܠܛܵܢܵܐ ܒܸܥܒ݂ܵܕܵܐ ܝܘܸܢ ܐܲܢܹܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ܘܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܐܵܗܵܐ ܡܲܬܠܵܐ ܠܥܲܡܵܐ: ”ܚܲܕ ܐܢܵܫܵܐ ܢܨܝܼܒ݂ ܠܹܗ ܟܲܪܡܵܐ، ܘܣܘܼܦܹܐ ܠܹܗ ܠܦܲܠܵܚܹ̈ܐ، ܘܐܙܝܼܠܔ ܠܹܗ ܠܚܲܕ ܐܲܬܪܵܐ ܪܸܚܩܵܐ ܩܵܐ ܚܲܕ ܙܲܒ݂ܢܵܐ ܝܲܪܝܼܟ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","”ܘܒܥܕܵܢܵܐ ܕܛܥܘܼܢܝܵܬܹ̈‌ܐ ܫܘܼܕܸܪܹܗ ܪܹܓܹܗ ܠܟܸܣ ܦܲܠܵܚܹ̈ܐ ܕܝܵܗܒ݂ܝܼ ܠܹܗ ܡ̣ܢ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܕܟܲܪܡܵܐ. ܐܝܼܢܵܐ ܦܲܠܵܚܹ̈ܐ ܡܚܹܐ ܠܗܘܿܢ ܐܸܠܹܗ ܘܫܘܼܕܸܪܗܘܿܢ ܣܦܝܼܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","”ܡܸܢܕܪܸܫ ܫܘܼܕܸܪܹܗ ܪܹܓܵܐ ܐܚܹܪܢܵܐ، ܐܝܼܢܵܐ ܐܘܼܦ ܠܗ̇ܘ ܡܚܹܐ ܠܗܘܿܢ ܦܲܠܵܚܹ̈ܐ، ܘܡܘܼܣܠܹܐ ܠܗܘܿܢ ܐܸܠܹܗ، ܘܫܘܼܕܸܪܗܘܿܢ ܣܦܝܼܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","”ܘܫܘܼܕܸܪܹܗ ܪܹܓܵܐ ܕܬܠܵܬܵ‌ܐ، ܐܝܼܢܵܐ ܐܘܼܦ ܠܗ̇ܘ ܕܘܼܪܒܸܢܗܘܿܢ ܘܛܪܝܼܕ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","”ܘܐܡܝܼܪܹܗ ܡܵܪܵܐ ܕܟܲܪܡܵܐ: ’ܡܘܼܕܝܼ ܥܵܒ݂ܕܹܢ؟ ܒܸܬ ܫܲܕܪܸܢ ܒܪܘܿܢܝܼ ܡܘܼܚܸܒܵܐ. ܩܵܘܡܵܐ ܒܸܬ ܡܝܲܩܪܝܼ ܠܹܗ.‘ ");
INSERT INTO aii_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","”ܐܝܼܢܵܐ ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܗܘܿܢ ܦܲܠܵܚܹ̈ܐ ܠܒܪܘܿܢܵܐ، ܐܡܝܼܪܗܘܿܢ ܒܓܵܢܵܝܗ‌ܝ: ’ܐܵܗܵܐ ܝܠܹܗ ܝܵܪܘܿܬܵ‌ܐ. ܬܹܝܡܘܼܢ ܩܵܛܠܲܚ ܠܹܗ ܕܦܵܝܫܵܐ ܝܵܪܬܘܼܬܵ‌ܐ ܩܵܬܲܢ.‘ ");
INSERT INTO aii_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","”ܦܘܼܠܸܛ ܠܗܘܿܢ ܐܸܠܹܗ ܠܒܲܕܲܪ ܡ̣ܢ ܟܲܪܡܵܐ ܘܩܛܝܼܠܔ ܠܗܘܿܢ ܐܸܠܹܗ. ܡܘܼܕܝܼ ܒܸܬ ܥܵܒܹܕ ܐܸܠܵܝܗ‌ܝ ܡܵܪܵܐ ܕܟܲܪܡܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","”ܒܸܬ ܐܵܬܹ‌ܐ ܘܒܸܬ ܛܲܠܸܩ ܠܐܵܢܝܼ ܦܲܠܵܚܹ̈ܐ، ܘܒܸܬ ܝܵܗܒܹܠܔ ܟܲܪܡܵܐ ܠܦܲܠܵܚܹ̈ܐ ܐܚܹܪ̈ܢܹܐ.“ ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܗܘܿܢ ܐܢܵܫܹ̈ܐ ܐܲܢܹܐ ܗܹܡܸܙܡܵܢܹ̈ܐ، ܐܡܝܼܪܗܘܿܢ: ”ܐܲܠܵܗܵܐ ܠܵܐ ܥܵܒܹܕ.“ ");
INSERT INTO aii_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ܐܝܼܢܵܐ ܗ̇ܘ ܚܝܼܪܹܗ ܒܝܼܵܝܗ‌ܝ ܘܐܡܝܼܪܹܗ: ”ܡܘܼܕܝܼ ܝܠܵܗ̇ ܡܲܥܢܵܝܵܐ ܕܗ̇ܝ ܕܟܬܝܼܒ݂ܬܵ‌ܐ ܝܠܵܗ̇: ܟܹܐܦܵܐ ܕܡܘܼܣܠܹܐ ܠܗܘܿܢ ܒܲܢܵܝܹ̈ܐ، ܗ̇ܘ ܗܘܹܐ ܠܹܗ ܟܹܐܦܵܐ ܕܩܘܼܪܢܝܼܬܵ‌ܐ؟ ");
INSERT INTO aii_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","”ܟܠܔ ܡ̇ܢ ܕܢܵܦܹܠܔ ܥܲܠܔ ܗ̇ܘ ܟܹܐܦܵܐ ܒܸܬ ܦܵܐܹܫ ܫܡܝܼܛܵܐ، ܘܟܠܔ ܡ̇ܢ ܕܥܲܠܘܼܗ‌ܝ ܢܵܦܹܠܔ ܗ̇ܘ ܟܹܐܦܵܐ، ܒܸܬ ܦܵܐܹܫ ܛܒ݂ܝܼܚܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ܒܗ̇ܝ ܥܕܵܢܵܐ ܒܥܹܐ ܠܗܘܿܢ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܣܵܦܪܹ̈ܐ ܕܵܒ݂ܩܝܼ ܗܘܵܘ ܠܹܗ، ܐܝܼܢܵܐ ܙܕܝܼܥ ܠܗܘܿܢ ܡ̣ܢ ܥܲܡܵܐ ܣܵܒܵܒ ܝܕܝܼܥ ܠܗܘܿܢ ܕܐܸܠܵܝܗ‌ܝ ܐܡܝܼܪܹܗ ܐܵܗܵܐ ܡܲܬܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ܫܘܼܕܸܪܗܘܿܢ ܠܟܸܣ ܝܼܫܘܿܥ ܓܵܫܘܿܫܹ̈ܐ ܒܕܡܘܼܬܵ‌ܐ ܕܙܲܕܝܼܩܹ̈ܐ ܕܡܲܢܦܸܠܝܼ ܗܘܵܘ ܠܹܗ ܒܗܹܡܸܙܡܵܢ، ܕܣܲܦܝܼ ܗܘܵܘ ܠܹܗ ܠܕܝܼܘܵܢ ܘܠܫܘܼܠܛܵܢܵܐ ܕܫܲܠܝܼܛܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ: ”ܡܲܠܦܵܢܵܐ، ܟܹܐ ܝܵܕܥܲܚ ܕܫܪܵܪܵܐ ܟܹܐ ܗܲܡܙܸܡܸܬ ܘܟܹܐ ܡܲܠܦܸܬ، ܘܠܹܐ ܚܵܙܹܝܬ ܦܵܬܵ‌ܐ ܐܸܠܵܐ ܒܫܲܪܝܼܪܘܼܬܵ‌ܐ ܐܘܼܪܚܵܐ ܕܐܲܠܵܗܵܐ ܟܹܐ ܡܲܠܦܸܬ. ");
INSERT INTO aii_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","”ܩܵܢܘܿܢܵܝܬܵ‌ܐ ܝܠܵܗ̇ ܕܝܵܗܒܲܚ ܙܘܼܙܹ̈ܐ ܕܪܹܝܫܝܼܬܵ‌ܐ ܠܩܹܣܲܪ ܝܲܢ ܠܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ܐܝܼܢܵܐ ܗ̇ܘ ܝܕܝܼܥ ܠܹܗ ܦܸܠܡܵܝܗ‌ܝ، ܓ̰ܘܼܘܸܒ ܠܹܗ: ”ܩܵܡܘܿܕܝܼ ܓ̰ܲܪܘܼܒܝܼ ܝܬܘܿܢ؟ ");
INSERT INTO aii_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","”ܡܲܚܙܹܝܡܘܼܢ ܠܝܼ ܕܝܼܢܵܪܵܐ.“ ܘܡܘܼܚܙܹܐ ܠܗܘܿܢ ܐܸܠܹܗ. ܘܒܘܼܩܸܪܹܗ: ”ܕܡܵܢܝܼ ܝܠܹܗ ܐܵܗܵܐ ܨܘܼܪܬܵ‌ܐ، ܘܕܡܵܢܝܼ ܝܠܵܗ̇ ܐܵܗܵܐ ܟܬܝܼܒ݂ܬܵ‌ܐ؟“ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܐܸܠܹܗ: ”ܕܩܹܣܲܪ.“ ");
INSERT INTO aii_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܗܲܒ݂ܠܘܼܢ ܗܵܕܟ݂ܵܐ ܡܸܢܕܝܼ ܕܩܹܣܲܪ ܠܩܹܣܲܪ، ܘܡܸܢܕܝܼ ܕܐܲܠܵܗܵܐ ܠܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ܘܠܵܐ ܡܨܹܐ ܠܗܘܿܢ ܡܲܢܦܸܠܝܼ ܠܹܗ ܒܗܹܡܸܙܡܵܢ ܩܲܕܡ ܥܲܡܵܐ. ܥܘܼܓ̰ܸܒ ܠܗܘܿܢ ܥܲܠܔ ܓ̰ܘܼܘܵܒܹܗ، ܘܫܬܝܼܩ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣ ܝܼܫܘܿܥ ܚܲܕܟܡܵܐ ܙܲܕܘܼܩܵܝܹ̈ܐ، ܐܵܢܝܼ ܕܟܹܐ ܐܵܡܪܝܼ ܕܠܲܝܬ ܩܝܵܡܬܵ‌ܐ، ܘܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ: ");
INSERT INTO aii_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","”ܡܲܠܦܵܢܵܐ، ܡܘܼܫܹܐ ܟܬܝܼܒ݂ ܠܹܗ ܐܸܠܲܢ، ܐܸܢ ܐܲܚܘܿܢܵܐ ܕܐܢܵܫܵܐ ܡܵܐܹܬ ܘܐܝܼܬ ܠܹܗ ܒܲܟ݂ܬܵ‌ܐ ܐܝܼܢܵܐ ܠܲܝܬ ܠܹܗ ܒܢܘܿܢܹ̈ܐ، ܓܵܒܹܪ ܐܲܚܘܿܢܘܼܗ‌ܝ ܠܒܲܟ݂ܬܹܗ ܘܡܲܩܸܡ ܒܢܘܿܢܹ̈ܐ ܠܐܲܚܘܿܢܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","”ܐܝܼܬ ܗܘܵܘ ܫܲܒ݂ܥܵܐ ܐܲܚܘܿܢܘܵܬܹ̈‌ܐ. ܗ̇ܘ ܩܲܕܡܵܝܵܐ ܓܒ݂ܝܼܪܹܗ ܒܲܟ݂ܬܵ‌ܐ ܘܡܝܼܬ ܠܹܗ ܕܠܵܐ ܒܢܘܿܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","”ܐܲܚܘܿܢܵܐ ܕܬܪܹܝ ܓܒ݂ܝܼܪܵܐ ܠܹܗ، ܐܝܼܢܵܐ ܐܘܼܦ ܗ̇ܘ ܡܝܼܬ ܠܹܗ ܕܠܵܐ ܒܢܘܿܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","”ܗ̇ܘ ܕܬܠܵܬܵ‌ܐ ܓܒ݂ܝܼܪܵܐ ܠܹܗ، ܗܵܕܟ݂ܵܐ ܗܲܠܔ ܫܲܒ݂ܥܘܿܢܬܵܝܗ‌ܝ. ܟܠܵܝܗ‌ܝ ܡܝܼܬ ܠܗܘܿܢ ܕܠܵܐ ܒܢܘܿܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","”ܒܚܲܪܬܵ‌ܐ ܐܘܼܦ ܒܲܟ݂ܬܵ‌ܐ ܡܝܼܬ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","”ܒܝܵܘܡܵܐ ܕܩܝܵܡܬܵ‌ܐ، ܠܡܵܢܝܼ ܒܸܬ ܗܵܘܝܵܐ ܗ̇ܝ ܒܲܟ݂ܬܵ‌ܐ؟ ܣܵܒܵܒ ܫܲܒ݂ܥܘܿܢܬܵܝܗ‌ܝ ܓܒ݂ܝܼܪܵܐ ܠܗܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܒܢܘܿܢܹ̈ܐ ܕܐܵܗܵܐ ܥܵܠܡܵܐ ܟܹܐ ܓܵܒ݂ܪܝܼ ܘܡܲܓܒܸܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","”ܐܝܼܢܵܐ ܐܵܢܝܼ ܕܝܼܢܵܐ ܚܫܝܼܚܹܐ ܠܗ̇ܘ ܥܵܠܡܵܐ ܐܚܹܪܢܵܐ، ܠܩܝܵܡܬܵ‌ܐ ܡ̣ܢ ܓܵܘ ܡܝܼ̈ܬܹ‌ܐ، ܠܹܐ ܓܵܒ݂ܪܝܼ ܘܠܹܐ ܡܲܓܒܸܪܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","”ܐܘܼܦ ܡܝܵܬܵ‌ܐ ܠܹܐ ܡܵܨܝܼ ܡܵܝܬ‌ܝܼ ܐܚܹܪܢܵܐ، ܣܵܒܵܒ ܐܲܝܟ݂ ܡܲܠܲܐܟܹ̈ܐ ܝܢܵܐ، ܘܒܢܘܿܢܹ̈ܐ ܕܐܲܠܵܗܵܐ ܝܢܵܐ، ܣܵܒܵܒ ܗܘܹܐ ܠܗܘܿܢ ܒܢܘܿܢܹ̈ܐ ܕܩܝܵܡܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","”ܐܝܼܢܵܐ ܒܘܼܬ ܩܝܵܡܬܵ‌ܐ ܕܡܝܼ̈ܬܹ‌ܐ، ܐܘܼܦ ܡܘܼܫܹܐ ܡܘܼܕܸܥ ܠܹܗ ܓܵܘ ܦܵܣܘܿܩܵܐ ܕܣܲܢܝܵܐ، ܟܲܕ ܩܪܹܐ ܠܹܗ ܠܡܵܪܝܵܐ: ’ܐܲܠܵܗܵܐ ܕܐܲܒ݂ܪܵܗܵܡ، ܘܐܲܠܵܗܵܐ ܕܐܝܼܣܚܵܩ، ܘܐܲܠܵܗܵܐ ܕܝܲܥܩܘܿܒ݂.‘ ");
INSERT INTO aii_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","”ܐܲܠܵܗܵܐ ܠܹܐ ܝܠܹܗ ܐܲܠܵܗܵܐ ܕܡܝܼ̈ܬܹ‌ܐ ܐܸܠܵܐ ܕܚܵܝܹ̈ܐ، ܣܵܒܵܒ ܩܵܬܹܗ ܟܠܵܝܗ‌ܝ ܚܵܝܹ̈ܐ ܝܢܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܐܢܵܫܹ̈ܐ ܡ̣ܢ ܣܵܦܪܹ̈ܐ ܘܐܡܝܼܪܗܘܿܢ: ”ܡܲܠܦܵܢܵܐ، ܫܲܦܝܼܪܵܐ ܗܲܡܙܘܼܡܹܐ ܝܘܸܬ.“ ");
INSERT INTO aii_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ܘܐܚܹܪܢܵܐ ܠܵܐ ܩܘܼܫܕܸܪܗܘܿܢ ܠܒܲܩܘܼܪܹܐ ܡܸܢܹܗ ܒܘܼܩܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܕܵܐܟ݂ܝܼ ܟܹܐ ܐܵܡܪܝܼ ܣܵܦܪܹ̈ܐ ܕܡܫܝܼܚܵܐ ܒܪܘܿܢܵܐ ܕܕܵܘܝܼܕ ܝܼܠܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","”ܕܵܘܝܼܕ ܒܓܵܢܹܗ ܐܡܝܼܪܹܗ ܓܵܘ ܟܬܵܒ݂ܵܐ ܕܡܲܙܡܘܿܪܹ̈ܐ: ܐܡܝܼܪܹܗ ܡܵܪܝܵܐ ܠܡܵܪܝܼ، ’ܝܬܘܿܒ݂ ܡ̣ܢ ܝܲܡܝܼܢܝܼ، ");
INSERT INTO aii_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ܗܲܠܔ ܕܡܲܬܒܸܢ ܕܸܫ̃ܡܸܢܘܼ̈ܟ݂ ܟܘܼܒ݂ܫܵܐ ܬܚܘܿܬ ܐܲܩܠܵܬܘܼ̈ܟ݂.‘ ");
INSERT INTO aii_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","”ܐܸܢ ܕܵܘܝܼܕ ܗܵܕܟ݂ܵܐ ܒܸܩܪܵܝܹܗ ܝܠܹܗ ܡܵܪܝܵܐ، ܕܵܐܟ݂ܝܼ ܒܸܬ ܗܵܘܹܐ ܒܪܘܿܢܹܗ؟“ ");
INSERT INTO aii_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ܘܟܲܕ ܟܠܹܗ ܥܲܡܵܐ ܒܸܫܡܵܥܵܐ، ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ");
INSERT INTO aii_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","”ܗܘܹܝܡܘܼܢ ܗܸܫܝܲܪ ܡ̣ܢ ܣܵܦܪܹ̈ܐ ܕܟܹܐ ܒܵܣܡܵܐ ܠܗܘܿܢ ܠܸܚܕܵܪܵܐ ܒܠܒ݂ܝܼܫܝܵܬܹ̈‌ܐ ܝܲܪ̈ܝܼܟܹܐ، ܘܟܹܐ ܡܲܚܸܒܝܼ ܫܠܵܡܵܐ ܒܫܘܼܩܹ̈ܐ، ܘܪܹܝܫܵܐ ܕܡܵܘܬܒܹ̈ܐ ܓܵܘ ܟܢܘܼܫܝܵܬܹ̈‌ܐ ܘܒܡܸܫܬܘܼܝܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","”ܟܹܐ ܐܵܟ݂ܠܝܼ ܒܵܬܹ̈‌ܐ ܕܐܲܪ̈ܡܸܠܝܵܬܹ‌ܐ ܘܡܲܚܙܝܼ ܓܵܢܵܝܗ‌ܝ ܒܡܲܪܝܲܟ݂ܬܵ‌ܐ ܕܨܠܵܘܵܬܵܝ̈ܗ‌ܝ ܒܕܲܓܵܠܘܼܬܵ‌ܐ. ܐܲܢܹܐ ܒܸܬ ܦܵܝܫܝܼ ܕܝܼܢܹܐ ܒܩܸܫܝܘܼܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ܓܘܼܫܸܩ ܠܹܗ ܝܼܫܘܿܥ ܒܥܲܬܝܼܪܹ̈ܐ ܕܒܸܕܪܵܝܵܐ ܝܗܘܵܘ ܕܒ݂ܵܚܝܵܬܵܝ̈ܗ‌ܝ ܓܵܘ ܒܹܝܬ ܓܲܙܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ܚܙܹܐ ܠܹܗ ܚܕܵܐ ܐܲܪܡܸܠܬܵ‌ܐ ܡܸܣܟܹܢܬܵ‌ܐ، ܐܘܼܦ ܗ̇ܝ ܕܪܹܐ ܠܵܗ̇ ܬܪܹܝ ܦܘܼܠܣܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ܘܐܡܝܼܪܹܗ: ”ܫܲܪܝܼܪܵܐܝܼܬ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܵܗܵܐ ܐܲܪܡܸܠܬܵ‌ܐ ܡܸܣܟܹܢܬܵ‌ܐ ܕܪܹܐ ܠܵܗ̇ ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܟܠܔ ܐܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","”ܣܵܒܵܒ ܐܲܢܹܐ ܟܠܵܝܗ‌ܝ ܕܪܹܐ ܠܗܘܿܢ ܓܵܘ ܒܹܝܬ ܓܲܙܵܐ ܕܐܲܠܵܗܵܐ ܡܸܢܕܝܼ ܕܙܵܘܕܵܐ ܝܗܘܵܐ ܐܸܠܵܝܗ‌ܝ، ܐܝܼܢܵܐ ܐܵܗܵܐ ܡ̣ܢ ܒܵܨܘܿܪܘܼܬܘܼܗ̇ ܟܠܔ ܡܸܢܕܝܼ ܕܐܝܼܬ ܗܘܵܐ ܠܵܗ̇ ܕܪܹܐ ܠܵܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ܗܲܡܙܘܼܡܹܐ ܝܗܘܵܘ ܚܲܕܟܡܵܐ ܡ̣ܢ ܬܲܠܡܝܼ̈ܕܹܐ ܥܲܡ ܝܼܫܘܿܥ ܒܘܼܬ ܗܲܝܟܠܵܐ ܕܵܐܟ݂ܝܼ ܦܝܼܫܵܐ ܝܗܘܵܐ ܒܸܢܝܵܐ ܒܟܹܐܦܹ̈ܐ ܫܲܦܝܼܪܹ̈ܐ ܘܣܘܼܩܠܵܐ ܒܚܲܠܥܲܬܹ̈‌ܐ. ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ");
INSERT INTO aii_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","”ܐܲܢܹܐ ܕܒܸܚܙܵܝܵܝ ܝܬܘܿܢ، ܒܸܬ ܐܵܬ‌ܝܼ ܝܵܘܡܵܢܹ̈ܐ ܕܠܹܐ ܦܵܐܹܫ ܫܒ݂ܝܼܩܵܐ ܟܹܐܦܵܐ ܥܲܠܔ ܟܹܐܦܵܐ ܕܠܵܐ ܦܵܐܹܫ ܣܬܝܼܪܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ܘܐܵܢܝܼ ܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ: ”ܡܲܠܦܵܢܵܐ، ܐܝܼܡܲܢ ܒܸܬ ܗܵܘܝܼ ܐܲܢܹܐ؟ ܘܡܘܼܕܝܼ ܝܠܹܗ ܢܝܼܫܲܢܩܵܐ ܐܝܼܡܲܢ ܕܐܲܢܹܐ ܩܲܪܒܸܢܝܼ ܠܹܗܘܵܝܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ܘܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܗܘܹܝܡܘܼܢ ܗܸܫܝܲܪ ܠܵܐ ܗܵܘܹܐ ܕܚܵܠܛܝܼܬܘܿܢ، ܣܵܒܵܒ ܪܵܒܵܐ ܒܸܬ ܐܵܬ‌ܝܼ ܒܫܸܡܝܼ ܘܒܸܬ ܐܵܡܪܝܼ: ’ܐܵܢܵܐ ܝܘܸܢ ܡܫܝܼܚܵܐ، ܘܥܕܵܢܵܐ ܩܘܼܪܒܸܢܵܗ̇.‘ ܐܝܼܢܵܐ ܠܵܐ ܐܵܙܠ݇ܝܼܬܘܿܢ ܒܵܬܪܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","”ܘܐܝܼܡܲܢ ܕܫܵܡܥܝܼܬܘܿܢ ܦܠܵܫܹ̈ܐ ܘܫܓ݂ܘܼܫܝܹ̈ܐ، ܠܵܐ ܙܵܕܥܝܼܬܘܿܢ، ܣܵܒܵܒ ܐܲܢܹܐ ܒܸܬ ܗܵܘܝܼ ܩܲܕܡܵܝܬܵ‌ܐ، ܐܝܼܢܵܐ ܗܸܫ ܠܹܐ ܝܠܹܗ ܫܘܼܠܵܡܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ܗ̇ܝܓܵܗ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܒܸܬ ܩܵܝܡܵܐ ܐܘܼܡܬܵ‌ܐ ܥܲܠܔ ܐܘܼܡܬܵ‌ܐ، ܘܡܲܠܟܘܼܬܵ‌ܐ ܥܲܠܔ ܡܲܠܟܘܼܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","”ܘܒܸܬ ܗܵܘܝܼ ܪ̈ܵܘܕܵܢܹܐ ܓܘܼܪܹ̈ܐ، ܟܸܦܢܹ̈ܐ ܘܡܵܘܬܵܢܹ̈ܐ ܒܕܘܼܟܵܢܹ̈ܐ ܦܪ̈ܝܼܫܹܐ؛ ܒܸܬ ܗܵܘܝܼ ܡܸܢܕܝܼܵܢܹ̈ܐ ܡܲܙܕܸܥܵܢܹ̈ܐ ܘܢܝܼܫܲܢܩܹ̈ܐ ܓܘܼܪܹ̈ܐ ܡ̣ܢ ܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","”ܐܝܼܢܵܐ ܡ̣ܢ ܩܲܕܡ ܐܲܢܹܐ ܟܠܵܝܗ‌ܝ ܗܵܘܝܼ، ܒܸܬ ܕܵܒ݂ܩܝܼ ܠܵܘܟ݂ܘܿܢ، ܘܒܸܬ ܟܲܡܪܝܼ ܠܵܘܟ݂ܘܿܢ، ܘܒܸܬ ܣܲܦܝܼ ܠܵܘܟ݂ܘܿܢ ܠܟܢܘܼܫܝܵܬܹ̈‌ܐ ܘܠܒܹܝܬ ܐܲܣܝܼܪܹ̈ܐ، ܘܒܸܬ ܡܲܝܬ‌ܝܼ ܠܵܘܟ݂ܘܿܢ ܩܲܕܡ ܡܲܠܟܹ̈ܐ ܘܫܲܠܝܼ̈ܛܹܐ ܒܘܼܬ ܫܸܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","”ܐܝܼܢܵܐ ܟܠܵܗ̇ ܐܵܗܵܐ ܒܸܬ ܗܵܘܝܵܐ ܕܝܵܗܒ݂ܝܼܬܘܿܢ ܣܵܗܕܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","”ܩܛܹܥܡܘܼܢ ܒܠܸܒܵܘܟ݂ܘܿܢ ܕܠܵܐ ܐܵܟ݂ܠܝܼܬܘܿܢ ܚܲܡ ܓܵܘ ܓܵܢܵܘܟ݂ܘܿܢ ܒܘܼܬ ܡܘܼܕܝܼ ܒܸܬ ܓ̰ܲܘܸܒܝܼܬܘܿܢ، ");
INSERT INTO aii_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","”ܣܵܒܵܒ ܐܵܢܵܐ ܒܸܬ ܝܵܗܒܹܢܵܘܟ݂ܘܿܢ ܗܹܡܸܙܡܵܢ ܘܚܸܟ݂ܡܬܵ‌ܐ، ܗ̇ܝ ܕܠܵܐ ܡܵܨܝܼ ܩܵܝܡܝܼ ܠܕܲܠܩܘܼܒ݂ܠܘܼܗ̇ ܘܡܲܕܸܪܝܼ ܓ̰ܘܼܘܵܒܘܼܗ̇ ܟܠܵܝܗ‌ܝ ܕܸܫ̃ܡܸܢܵܘ̈ܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","”ܒܸܬ ܣܲܦܝܼ ܠܵܘܟ݂ܘܿܢ ܐܲܒ݂ܵܗܵܬܵܘ̈ܟ݂ܘܿܢ، ܘܐܲܚܘܿܢܘܵܬܵܘ̈ܟ݂ܘܿܢ، ܘܚܸܙܡܵܢܵܘ̈ܟ݂ܘܿܢ، ܘܚܲܒ݂ܪ̈ܵܘܵܬܵܘܟ݂ܘܿܢ، ܘܒܸܬ ܡܲܡܝܸܬ‌ܝܼ ܠܚܲܕܟܡܵܐ ܡܸܢܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","”ܘܒܸܬ ܦܵܝܫܝܼܬܘܿܢ ܣܸܢܝܹܐ ܡ̣ܢ ܟܠܔ ܐܢܵܫܵܐ ܒܘܼܬ ܫܸܡܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","”ܐܝܼܢܵܐ ܐܘܼܦ ܚܕܵܐ ܡܸܙܬܵ‌ܐ ܡ̣ܢ ܪܹܝܫܵܘܟ݂ܘܿܢ ܠܹܐ ܛܵܠܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ܘܒܟܠܵܝܬܵܘܟ݂ܘܿܢ ܩܘܝܼܬܵ‌ܐ ܒܸܬ ܦܲܪܩܝܼܬܘܿܢ ܠܓܵܢܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","”ܐܝܼܡܲܢ ܕܚܵܙܹܝܬܘܿܢ ܐܘܿܪܸܫܠܸܡ ܚܘܼܪܕܝܼܘܼܗ̇ ܚܲܝܠܵܘܵܬܹ̈‌ܐ، ܗ̇ܝܓܵܗ ܝܕܹܥܡܘܼܢ ܕܩܘܼܪܒܸܢܵܐ ܝܠܹܗ ܚܪܵܒ݂ܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","”ܗ̇ܝܓܵܗ ܐܵܢܝܼ ܕܝܼܢܵܐ ܒܝܼܗܘܼܕ ܥܵܪܩܝܼ ܠܛܘܼܪܵܐ، ܘܐܵܢܝܼ ܕܝܼܢܵܐ ܓܵܘܘܼܗ̇ ܦܵܠܛܝܼ، ܘܐܵܢܝܼ ܕܝܼܢܵܐ ܓܵܘ ܡܵܬܘܵܬܹ̈‌ܐ ܠܵܐ ܥܵܒ݂ܪܝܼ ܓܵܘܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","”ܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ ܒܸܬ ܗܵܘܝܼ ܝܵܘܡܵܢܹ̈ܐ ܕܫܩܵܠܬܵ‌ܐ ܕܬܘܼܥܠܵܐ، ܕܦܵܐܹܫ ܬܘܼܡܸܡܵܐ ܟܠܔ ܡܸܢܕܝܼ ܕܝܼܠܹܗ ܟܬܝܼܒ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","”ܘܵܝ ܠܒܛܝܼܢܹ̈ܐ ܘܠܡܲܡܸܨܵܢܹ̈ܐ ܒܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ. ܣܵܒܵܒ ܒܸܬ ܗܵܘܹܐ ܐܘܼܠܨܵܢܵܐ ܓܘܼܪܵܐ ܒܐܲܪܥܵܐ، ܘܟܲܪܒܵܐ ܥܲܠܔ ܐܵܗܵܐ ܥܲܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","”ܒܸܬ ܢܵܦܠܝܼ ܒܦܘܼܡܵܐ ܕܣܲܝܦܵܐ، ܘܒܸܬ ܦܵܝܫܝܼ ܠܘܼܒܠܹܐ ܐܲܣܝܼܪܹ̈ܐ ܓܵܘ ܟܠܵܝܗ‌ܝ ܐܲܬܪ̈ܵܘܵܬܹ‌ܐ، ܘܐܘܿܪܸܫܠܸܡ ܒܸܬ ܦܵܝܫܵܐ ܕܘܼܫܕܸܫܬܵ‌ܐ ܒܝܲܕ ܐܸܡܘܵܬܹ̈‌ܐ ܗܲܠܔ ܕܬܲܡܸܡܝܼ ܙܲܒ݂ܢܹ̈ܐ ܕܐܸܡܘܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","”ܒܸܬ ܗܵܘܝܼ ܢܝܼܫܲܢܩܹ̈ܐ ܒܫܸܡܫܵܐ ܘܒܣܲܗܪܵܐ ܘܒܟܵܘܟ݂ܒܹ̈ܐ. ܘܥܲܠܔ ܐܲܪܥܵܐ ܒܸܬ ܗܵܘܹܐ ܐܘܼܠܨܵܢܵܐ ܓܵܘ ܐܸܡܘܵܬܹ̈‌ܐ، ܫܓ݂ܘܼܫܝܵܐ ܘܙܕܘܼܥܬܵ‌ܐ ܡ̣ܢ ܓܲܪܓܲܡܬܵ‌ܐ ܕܝܵܡܵܐ ܘܠܲܦܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","”ܐܢܵܫܹ̈ܐ ܒܸܬ ܫܵܦܠܝܼ ܡ̣ܢ ܙܕܘܼܥܬܵ‌ܐ، ܒܝܼܕܵܥܵܐ ܡܘܼܕܝܼ ܒܸܬ ܩܲܘܸܡ ܥܲܠܔ ܐܲܪܥܵܐ، ܣܵܒܵܒ ܚܲܝܠܵܘܵܬܹ̈‌ܐ ܕܫܡܲܝܵܐ ܒܸܬ ܦܵܝܫܝܼ ܫܥܝܼܫܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","”ܗ̇ܝܓܵܗ ܒܸܬ ܚܵܙܝܼ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܹܐܬܵܝܵܐ ܥܲܠܔ ܥܢܵܢܵܐ ܒܚܲܝܠܵܐ ܘܒܚܸܩܪܵܐ ܓܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","”ܐܝܼܡܲܢ ܕܫܲܪܝܼ ܐܲܢܹܐ ܠܹܗܘܵܝܵܐ، ܟܠܹܝܡܘܼܢ ܘܡܲܪܡܘܼܢ ܪܹܝܫܵܘܟ݂ܘܿܢ، ܣܵܒܵܒ ܩܘܼܪܒܸܢܵܐ ܝܠܹܗ ܦܘܼܪܩܵܢܵܘܟ݂ܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܡܲܬܠܵܐ: ”ܓܲܫܩܘܼܢ ܒܐܝܼܠܵܢܵܐ ܕܬܹܐܢܹ̈ܐ، ܘܒܟܠܵܝܗ‌ܝ ܐܝܼܠܵܢܹ̈ܐ، ");
INSERT INTO aii_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","”ܐܝܼܡܲܢ ܕܒܲܪܛܸܢܝܼ، ܟܹܐ ܚܵܙܹܝܬܘܿܢ ܘܝܵܕܥܝܼܬܘܿܢ ܒܓܵܢܵܘܟ݂ܘܿܢ ܕܩܘܼܪܒܸܢܹܗ ܩܲܝܛܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","”ܗܵܕܟ݂ܵܐ ܐܘܼܦ ܐܲܚܬܘܿܢ ܐܝܼܡܲܢ ܕܚܵܙܹܝܬܘܿܢ ܐܲܢܹܐ ܒܹܗܘܵܝܵܐ، ܝܕܹܥܡܘܼܢ ܕܩܘܼܪܒܸܢܵܗ̇ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܠܹܐ ܥܵܒܹܪ ܐܵܗܵܐ ܕܵܘܪܵܐ ܗܲܠܔ ܕܗܵܘܝܼ ܐܲܢܹܐ ܟܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","”ܫܡܲܝܵܐ ܘܐܲܪܥܵܐ ܒܸܬ ܛܵܠܩܝܼ، ܐܝܼܢܵܐ ܗܹܡܸܙܡܵܢܝܼ̈ ܠܹܐ ܛܵܠܩܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","”ܗܘܹܝܡܘܼܢ ܗܸܫܝܲܪ ܒܓܵܢܵܘܟ݂ܘܿܢ، ܘܠܵܐ ܡܵܠܝܼ ܠܸܒܵܘܟ݂ܘܿܢ ܒܐܵܣܘܿܛܘܼܬܵ‌ܐ ܘܪܵܘܵܝܘܼܬܵ‌ܐ ܘܪܸܢܝܵܐ ܒܘܼܬ ܐܲܢܹܐ ܚܲܝܹ̈ܐ، ܘܡܸܢܫܸܠܬܵܢܹܐ ܐܵܬܹ‌ܐ ܥܲܠܵܘܟ݂ܘܿܢ ܗ̇ܘ ܝܵܘܡܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","”ܣܵܒܵܒ ܒܸܬ ܐܵܬܹ‌ܐ ܗ̇ܘ ܝܵܘܡܵܐ ܐܲܝܟ݂ ܢܸܫܒ݂ܵܐ ܥܲܠܔ ܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܒܸܥܡܵܪܵܐ ܝܢܵܐ ܥܲܠܔ ܦܵܬܵ‌ܐ ܕܟܠܵܗ̇ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","”ܗܘܹܝܡܘܼܢ ܗܵܕܟ݂ܵܐ ܪܥܝܼܫܹܐ ܘܨܲܠܘܼܝܹܐ ܒܟܠܔ ܥܕܵܢܵܐ، ܕܡܵܨܹܝܬܘܿܢ ܥܵܪܩܝܼܬܘܿܢ ܡ̣ܢ ܐܲܢܹܐ ܕܗܕܝܼܪܹܐ ܝܢܵܐ ܠܹܗܘܵܝܵܐ، ܘܕܟܵܠܹܝܬܘܿܢ ܩܲܕܡ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ܒܝܵܘܡܵܐ ܟܹܐ ܡܲܠܸܦ ܗܘܵܐ ܝܼܫܘܿܥ ܓܵܘ ܗܲܝܟܠܵܐ، ܘܒܠܲܝܠܹܐ ܟܹܐ ܦܵܠܹܛ ܗܘܵܐ ܘܦܵܐܹܫ ܗܘܵܐ ܒܛܘܼܪܵܐ ܕܙܲܝ̈ܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ܘܟܠܹܗ ܥܲܡܵܐ ܟܹܐ ܐܵܬ‌ܝܼ ܗܘܵܘ ܠܟܸܣܠܹܗ ܓܵܘ ܗܲܝܟܠܵܐ ܩܲܝܕܵܡܬܵ‌ܐ ܓ̰ܲܠܕܹܐ ܕܫܵܡܥܝܼ ܗܘܵܘ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ܩܲܪܒܘܼܢܹܐ ܝܗܘܵܐ ܥܹܐܕܵܐ ܕܦܲܛܝܼܪܹ̈ܐ ܕܟܹܐ ܦܵܐܹܫ ܩܸܪܝܵܐ ܥܹܐܕܵܐ ܕܦܸܨܚܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ܘܒܸܛܥܵܝܵܐ ܝܗܘܵܘ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܣܵܦܪܹ̈ܐ ܠܚܕܵܐ ܦܸܪܣܲܬ ܕܵܐܟ݂ܝܼ ܩܵܛܠܝܼ ܠܝܼܫܘܿܥ، ܣܵܒܵܒ ܒܸܙܕܵܥܵܐ ܝܗܘܵܘ ܡ̣ܢ ܥܲܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ܘܥܒ݂ܝܼܪܹܗ ܣܵܛܵܢܵܐ ܒܝܼܗܘܼܕܵܐ ܣܟܲܪܝܘܿܛܵܐ ܕܝܼܗܘܵܐ ܚܲܕ ܡ̣ܢ ܬܪܸܥܣܲܪ. ");
INSERT INTO aii_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ܐܙܝܼܠܔ ܠܹܗ ܘܗܘܼܡܙܸܡ ܠܹܗ ܥܲܡ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܪܹ̈ܝܫܵܢܹܐ ܕܢܵܛܘܿܪܹ̈ܐ ܕܗܲܝܟܠܵܐ ܕܵܐܟ݂ܝܼ ܣܲܦܹܐ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ܘܐܵܢܝܼ ܚܕܹܐ ܠܗܘܿܢ، ܘܥܒ݂ܝܼܕ ܠܗܘܿܢ ܩܵܘܠܵܐ ܕܝܵܗܒ݂ܝܼ ܠܹܗ ܙܘܼܙܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ܘܗ̇ܘ ܝܘܼܗܒܹܠܔ ܠܹܗ ܩܵܘܠܵܐ ܐܸܠܵܝܗ‌ܝ، ܘܒܸܛܥܵܝܵܐ ܝܗܘܵܐ ܒܵܬܪ ܦܸܪܣܲܬ ܕܣܲܦܹܐ ܠܹܗ ܕܠܵܐ ܝܕܵܥܬܵ‌ܐ ܕܟܸܢܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ܡܛܹܐ ܠܹܗ ܝܵܘܡܵܐ ܕܦܲܛܝܼܪܹ̈ܐ ܕܒܝܼܹܗ ܐܝܼܬ ܥܝܵܕܵܐ ܕܟܹܐ ܦܵܐܹܫ ܦܪܝܼܡܵܐ ܦܹܐܪܵܐ ܕܦܸܨܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ܘܫܘܼܕܸܪܹܗ ܝܼܫܘܿܥ ܠܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܘܠܝܘܿܚܲܢܵܢ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܙܹܠ݇ܡܘܼܢ ܘܗܲܕܪܘܼܢ ܐܸܠܲܢ ܦܸܨܚܵܐ ܕܐܵܟ݂ܠܲܚ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ܐܵܢܝܼ ܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ: ”ܐܲܝܟܵܐ ܒܵܣܡܵܐ ܠܘܼܟ݂ ܕܗܲܕܪܲܚ؟“ ");
INSERT INTO aii_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܐܝܼܡܲܢ ܕܥܵܒ݂ܪܝܼܬܘܿܢ ܓܵܘ ܡܕܝܼܢ݇ܬܵ‌ܐ، ܒܸܬ ܬܵܦܹܩ ܒܝܼܵܘܟ݂ܘܿܢ ܚܲܕ ܐܢܵܫܵܐ ܛܥܝܼܢܵܐ ܬܲܠܡܵܐ ܕܡ̈ܝܼܵܐ. ܙܹܠ݇ܡܘܼܢ ܒܵܬܪܹܗ ܘܥܒ݂ܘܿܪܘܼܢ ܠܒܲܝܬܵ‌ܐ ܕܥܵܒܹܪ. ");
INSERT INTO aii_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","”ܘܐܡܘܿܪܘܼܢ ܠܡܵܪܵܐ ܕܒܲܝܬܵ‌ܐ: ’ܪܲܒܝܼܲܢ ܒܹܐܡܵܪܵܐ ܝܠܹܗ، ܐܲܝܟܵܐ ܝܠܵܗ̇ ܕܘܼܟܵܐ ܕܐܵܟ݂ܠܹܢ ܦܸܨܚܵܐ ܥܲܡ ܬܲܠܡܝܼܕܝܼ̈؟‘ ");
INSERT INTO aii_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","”ܘܗ̇ܘ ܒܸܬ ܡܲܚܙܹܐ ܠܵܘܟ݂ܘܿܢ ܥܸܠܝܼܬܵ‌ܐ ܓܘܼܪܬܵ‌ܐ ܘܫܘܼܘܝܼܬܵ‌ܐ. ܬܵܡܵܐ ܗܲܕܪܘܼܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܘܡܘܼܫ݇ܟ̰ܸܚ ܠܗܘܿܢ ܐܲܝܟ݂ ܕܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ. ܘܗܘܼܕܸܪܗܘܿܢ ܬܵܡܵܐ ܦܸܨܚܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ܐܝܼܡܲܢ ܕܗܘܹܐ ܠܵܗ̇ ܥܕܵܢܵܐ، ܐܬܹ‌ܐ ܠܹܗ ܝܼܫܘܿܥ ܘܝܬܝܼܒ݂ ܠܹܗ ܘܬܪܸܥܣܲܪ ܫܠܝܼܚܹ̈ܐ ܥܲܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܫܲܗܘܲܬܬܵ‌ܐ ܫܘܼܗܘܸܬ ܠܝܼ ܕܐܵܟ݂ܠܹܢܹܗ ܐܵܗܵܐ ܦܸܨܚܵܐ ܥܲܡܵܘܟ݂ܘܿܢ ܡ̣ܢ ܩܲܕܡ ܕܩܲܒܠܸܢ ܚܲܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","”ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܡ̣ܢ ܐܵܕܝܼܵܐ ܠܹܐ ܐܵܟ݂ܠܹܢܹܗ ܐܚܹܪܢܵܐ ܗܲܠܔ ܕܦܵܐܹܫ ܬܘܼܡܸܡܵܐ ܒܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ܘܫܩܝܼܠܔ ܠܹܗ ܟܵܣܵܐ ܘܫܘܼܟܸܪܹܗ ܘܐܡܝܼܪܹܗ: ”ܫܩܘܿܠܘܼܢ ܐܵܗܵܐ ܘܦܲܠܸܥܡܘܼܢ ܒܹܝܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","”ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܕܠܹܐ ܫܵܬܹܝܢ ܡ̣ܢ ܛܥܘܼܢܬܵ‌ܐ ܕܓܸܦܬܵ‌ܐ ܗܲܠܔ ܕܐܵܬܝܵܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ܘܫܩܝܼܠܔ ܠܹܗ ܠܲܚܡܵܐ ܘܫܘܼܟܸܪܹܗ ܘܩܨܹܐ ܠܹܗ ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܘܐܡܝܼܪܹܗ: ”ܐܵܗܵܐ ܝܠܹܗ ܦܲܓ݂ܪܝܼ ܕܒܘܼܬ ܕܝܼܵܘܟ݂ܘܿܢ ܦܝܵܫܵܐ ܝܠܹܗ ܝܘܼܗܒ݂ܵܐ، ܐܵܗܵܐ ܗܵܘܹܝܬܘܿܢ ܒܸܥܒ݂ܵܕܵܐ ܠܕܟ݂ܵܪܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ܗܵܕܟ݂ܵܐ ܐܘܼܦ ܠܟܵܣܵܐ، ܡ̣ܢ ܒܵܬܪ ܕܐܟ݂ܝܼܠܔ ܠܗܘܿܢ ܐܟ݂ܵܠ݇ܪܲܡܫܵܐ، ܐܡܝܼܪܹܗ: ”ܐܵܗܵܐ ܟܵܣܵܐ ܝܠܹܗ ܕܘܲܥܕܵܐ ܚܵܕܬܵ‌ܐ ܒܕܸܡܝܼ، ܒܘܼܬ ܕܝܼܵܘܟ݂ܘܿܢ ܦܝܵܫܵܐ ܝܠܹܗ ܫܘܼܦܟ݂ܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","”ܐܝܼܢܵܐ ܗܵܐ ܐܝܼܕܵܐ ܕܗ̇ܘ ܕܣܲܦܹܐ ܠܝܼ ܥܲܡ ܐܝܼܕܝܼ ܝܠܵܗ̇ ܥܲܠܔ ܦܵܬܘܿܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","”ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܹܐܙܵܠܵܐ ܝܠܹܗ ܕܵܐܟ݂ܝܼ ܕܝܼܠܹܗ ܩܛܝܼܥܵܐ ܐܸܠܹܗ ܕܐܵܙܹܠܔ، ܐܝܼܢܵܐ ܘܵܝ ܠܗ̇ܘ ܐܢܵܫܵܐ ܕܣܲܦܹܐ ܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ܘܫܘܼܪܹܐ ܠܗܘܿܢ ܨܲܚܨܘܼܝܹܐ ܓܵܢܵܝܗ‌ܝ ܘܒܲܩܘܼܪܹܐ ܐܲܝܢܝܼ ܡܸܢܵܝܗ‌ܝ ܒܸܬ ܗܵܘܹܐ ܣܲܦܝܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ܗܘܹܐ ܠܹܗ ܐܘܼܦ ܕܘܼܪܵܫܵܐ ܒܹܝܠܔ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ܕܐܲܝܢܝܼ ܡܸܢܵܝܗ‌ܝ ܚܫܝܼܚܵܐ ܝܠܹܗ ܕܗܵܘܹܐ ܒܘܼܫ ܓܘܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܡܲܠܟܹ̈ܐ ܕܐܸܡܘܵܬܹ̈‌ܐ ܡܵܪ̈ܵܘܵܬܵܝܗ‌ܝ ܝܢܵܐ، ܘܐܵܢܝܼ ܕܟܹܐ ܥܵܒ݂ܕܝܼ ܫܘܼܠܛܵܢܵܐ ܟܹܐ ܦܵܝܫܝܼ ܩܸܪܝܹܐ ܥܵܒ݂ܕܵܢܹܐ ܕܛܵܒ݂ܵܬܹ̈‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","”ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ ܠܵܐ ܗܵܘܹܝܬܘܿܢ ܗܵܕܟ݂ܵܐ، ܐܸܠܵܐ ܗ̇ܘ ܕܝܼܠܹܗ ܓܘܼܪܵܐ ܓܵܘܵܘܟ݂ܘܿܢ، ܗܵܘܹܐ ܐܲܝܟ݂ ܙܥܘܿܪܵܐ، ܘܗ̇ܘ ܕܝܼܠܹܗ ܩܲܕܡܵܝܵܐ ܗܵܘܹܐ ܐܲܝܟ݂ ܥܵܒ݂ܕܵܢܵܐ ܕܚܸܠܡܲܬ. ");
INSERT INTO aii_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","”ܡܵܢܝܼ ܝܠܹܗ ܒܘܼܫ ܓܘܼܪܵܐ، ܗ̇ܘ ܕܟܹܐ ܝܵܬܹܒ݂ ܠܣܘܼܦܪܵܐ ܝܲܢ ܗ̇ܘ ܕܟܹܐ ܥܵܒܹܕ ܚܸܠܡܲܬ؟ ܠܹܐ ܝܠܹܗ ܗ̇ܘ ܕܝܵܬܹܒ݂ ܠܣܘܼܦܪܵܐ؟ ܐܵܢܵܐ ܐܬܹ‌ܐ ܠܝܼ ܓܵܘܵܘܟ݂ܘܿܢ ܐܲܝܟ݂ ܕܗ̇ܘ ܕܥܵܒܹܕ ܚܸܠܡܲܬ. ");
INSERT INTO aii_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","”ܐܲܚܬܘܿܢ ܝܼܬܘܿܢ ܐܵܢܝܼ ܕܟܠܹܐ ܠܵܘܟ݂ܘܿܢ ܥܲܡܝܼ ܒܥܕܵܢܵܐ ܕܓ̰ܘܼܪܵܒܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","”ܘܐܵܢܵܐ ܒܸܥܒ݂ܵܕܵܐ ܝܘܸܢ ܩܵܘܠܵܐ ܐܸܠܵܘܟ݂ܘܿܢ ܕܝܵܗܒܹܢܵܘܟ݂ܘܿܢ ܡܲܠܟܘܼܬܵ‌ܐ، ܕܵܐܟ݂ܝܼ ܕܒܵܒܝܼ ܥܒ݂ܝܼܕ ܠܹܗ ܩܵܘܠܵܐ ܐܸܠܝܼ ܘܩܵܡ ܝܵܗܒܹܠܔ ܠܝܼ ܡܲܠܟܘܼܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","”ܕܐܵܟ݂ܠܝܼܬܘܿܢ ܘܫܵܬܹܝܬܘܿܢ ܥܲܠܔ ܦܵܬܘܿܪܝܼ ܒܡܲܠܟܘܼܬ‌ܝܼ، ܘܝܵܬܒ݂ܝܼܬܘܿܢ ܥܲܠܔ ܬܪ̈ܘܿܢܘܿܣܹܐ ܘܕܵܝܢܝܼܬܘܿܢ ܬܪܸܥܣܲܪ ܫܲܒ݂ܛܹ̈ܐ ܕܐܝܼܣܪܵܐܹܝܠܔ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܠܫܸܡܥܘܿܢ ܟܹܐܦܵܐ: ”ܫܸܡܥܘܿܢ، ܫܸܡܥܘܿܢ، ܗܵܐ ܣܵܛܵܢܵܐ ܒܸܒܥܵܝܵܐ ܝܠܹܗ ܕܣܵܪܹܕ ܠܵܘܟ݂ܘܿܢ ܐܲܝܟ݂ ܚܸܛܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","”ܐܝܼܢܵܐ ܐܵܢܵܐ ܨܘܼܠܹܐ ܠܝܼ ܒܘܼܬ ܕܝܼܘܼܟ݂ ܕܠܵܐ ܒܵܨܪܵܐ ܗܲܝܡܵܢܘܼܬܘܼܟ݂. ܘܐܘܼܦ ܐܲܢ݇ܬ ܐܝܼܡܲܢ ܕܕܵܝܪܹܬ، ܡܲܩܘܹܝܬ ܗܲܝܡܵܢܘܼܬܵ‌ܐ ܕܐܲܚܘܿܢܘܵܬܘܼ̈ܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ܘܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ: ”ܡܵܪܝܼ، ܐܵܢܵܐ ܗܕܝܼܪܵܐ ܝܘܸܢ ܕܐܵܙܹܠ݇ܢ ܥܲܡܘܼܟ݂ ܠܒܹܝܬ ܐܲܣܝܼܪܹ̈ܐ ܘܠܡܵܘܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܘܼܟ݂ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ، ܡ̣ܢ ܩܲܕܡ ܕܩܵܪܹܐ ܩܵܪܘܿܝܵܐ ܐܸܕܝܘܿܡ، ܬܠܵܬ ܓܵܗܹ̈ܐ ܒܸܬ ܣܵܪܒܹܬ ܕܟܹܐ ܝܵܕܥܹܬ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܐܝܼܡܲܢ ܕܫܘܼܕܸܪܝܼ ܐܸܠܵܘܟ݂ܘܿܢ ܕܠܵܐ ܟܝܼܣܝܵܬܹ̈‌ܐ، ܘܕܠܵܐ ܓ̰ܲܢܝܵܬܹ̈‌ܐ ܘܨܵܘܠܹ̈ܐ، ܒܵܨܘܿܪܵܐ ܝܗܘܵܐ ܡܸܢܕܝܼ ܐܸܠܵܘܟ݂ܘܿܢ؟“ ܘܐܵܢܝܼ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ: ”ܠܵܐ. ܐܘܼܦ ܚܲܕ ܡܸܢܕܝܼ ܠܹܐ ܝܗܘܵܐ ܒܵܨܘܿܪܵܐ ܐܸܠܲܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܐܝܼܢܵܐ ܡ̣ܢ ܐܵܕܝܼܵܐ ܡ̇ܢ ܕܐܝܼܬ ܠܹܗ ܟܝܼܣܝܵܬܹ̈‌ܐ ܫܵܩܹܠܔ ܠܗܘܿܢ، ܘܗܵܕܟ݂ܵܐ ܐܘܼܦ ܗ̇ܘ ܕܐܝܼܬ ܠܹܗ ܓ̰ܲܢܬܵ‌ܐ، ܘܡ̇ܢ ܕܠܲܝܬ ܠܹܗ ܣܲܝܦܵܐ ܙܲܒܸܢ ܠܒ݂ܝܼܫܬܹܗ ܘܙܵܒܹܢ ܣܲܝܦܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","”ܣܵܒܵܒ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܗ̇ܘ ܕܦܝܼܫܵܐ ܝܠܹܗ ܟܬܝܼܒ݂ܵܐ ܒܘܼܬ ܕܝܼܝܼ: ’ܥܲܡ ܥܵܘܵܠܹ̈ܐ ܦܝܼܫ ܠܹܗ ܡܸܢܝܵܐ،‘ ܘܵܠܹܐ ܝܠܵܗ̇ ܕܦܵܐܹܫ ܬܘܼܡܸܡܵܐ. ܗܹܐ، ܟܠܔ ܡܸܢܕܝܼ ܕܟܬܝܼܒ݂ܵܐ ܝܠܹܗ ܒܘܼܬ ܕܝܼܝܼ ܒܸܬ ܦܵܐܹܫ ܬܘܼܡܸܡܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ ܬܲܠܡܝܼ̈ܕܹܐ: ”ܡܵܪܲܢ، ܐܝܼܬ ܠܲܢ ܠܲܐܟ݂ܵܐ ܬܪܹܝ ܣܲܝܦܹ̈ܐ.“ ܘܗ̇ܘ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܒܲܣܵܘܟ݂ܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ܦܠܝܼܛ ܠܹܗ ܝܼܫܘܿܥ ܘܐܙܝܼܠܔ ܠܹܗ ܠܛܘܼܪܵܐ ܕܙܲܝ̈ܬܹ‌ܐ ܐܲܝܟ݂ ܕܐܝܼܬ ܗܘܵܐ ܠܹܗ ܥܵܕܲܬ، ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܒܵܬܪܹܗ ܐܘܼܦ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ܘܐܝܼܡܲܢ ܕܡܛܹܐ ܠܹܗ ܬܵܡܵܐ، ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܨܲܠܹܝܡܘܼܢ ܕܠܵܐ ܥܵܒ݂ܪܝܼܬܘܿܢ ܠܓ̰ܘܼܪܵܒܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ܘܗ̇ܘ ܪܚܝܼܩ ܠܹܗ ܡܸܢܵܝܗ‌ܝ ܐܲܝܟ݂ ܪܲܦܲܝܬܵ‌ܐ ܕܚܲܕ ܟܹܐܦܵܐ ܘܒܪܝܼܟ ܠܹܗ ܘܨܘܼܠܹܐ ܠܹܗ، ");
INSERT INTO aii_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ܘܐܡܝܼܪܹܗ: ”ܝܵܐ ܒܵܒܵܐ، ܐܸܢ ܒܵܣܡܵܐ ܠܘܼܟ݂ ܡܲܥܒܸܪ ܡܸܢܝܼ ܐܵܗܵܐ ܟܵܣܵܐ. ܐܝܼܢܵܐ ܗܵܘܹܐ ܨܸܒ݂ܝܵܢܘܼܟ݂ ܘܠܵܐ ܨܸܒ݂ܝܵܢܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ܘܦܝܼܫ ܠܹܗ ܚܸܙܝܵܐ ܐܸܠܹܗ ܡܲܠܲܐܟ݂ܵܐ ܡ̣ܢ ܫܡܲܝܵܐ ܚܲܠܘܼܢܹܐ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ܟܲܕ ܗ̇ܘ ܒܥܵܘܩܵܢܵܐ، ܗܘܹܐ ܠܹܗ ܨܲܠܘܼܝܹܐ ܒܘܼܫ ܚܲܝܠܵܢܵܐ، ܘܗܘܹܐ ܠܵܗ̇ ܕܲܥܬܹܗ ܐܲܝܟ݂ ܢܵܛܘܿܦܝܵܬܹ̈‌ܐ ܕܕܸܡܵܐ ܒܸܢܦܵܠܵܐ ܥܲܠܔ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ܩܝܼܡ ܠܹܗ ܡ̣ܢ ܨܠܘܿܬܵ‌ܐ ܘܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܚܸܙܝܵܝ ܠܹܗ ܕܡܝܼܟܹܐ ܣܵܒܵܒ ܦܫܝܼܡܹܐ ܝܗܘܵܘ، ");
INSERT INTO aii_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܩܵܡܘܿܕܝܼ ܕܡܝܼܟܹܐ ܝܬܘܿܢ؟ ܩܘܼܡܘܼܢ ܘܨܲܠܹܝܡܘܼܢ ܕܠܵܐ ܥܵܒ݂ܪܝܼܬܘܿܢ ܠܓ̰ܘܼܪܵܒܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ܘܟܲܕ ܝܼܫܘܿܥ ܗܲܡܙܘܼܡܹܐ ܝܗܘܵܐ، ܐܬܹ‌ܐ ܠܹܗ ܟܸܢܫܵܐ، ܘܝܼܗܘܼܕܵܐ، ܚܲܕ ܡ̣ܢ ܬܪܸܥܣܲܪ، ܒܹܐܙܵܠܵܐ ܩܲܕܡܵܝܗ‌ܝ. ܩܘܼܪܒܸܢܹܗ ܠܟܸܣ ܝܼܫܘܿܥ ܘܢܫܝܼܩ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܒܢܫܘܼܩܬܵ‌ܐ ܣܲܦܘܼܝܹܐ ܝܘܸܬ ܠܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ܟܲܕ ܚܙܹܐ ܠܗܘܿܢ ܐܵܢܝܼ ܕܝܼܗܘܵܘ ܥܲܡ ܝܼܫܘܿܥ ܡܸܢܕܝܼ ܕܗܘܹܐ ܠܹܗ، ܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܡܵܪܲܢ، ܡܵܚܲܚ ܠܗܘܿܢ ܒܣܲܝܦܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ܘܡܚܹܐ ܠܹܗ ܚܲܕ ܡܸܢܵܝܗ‌ܝ ܠܪܹܓܵܐ ܕܓܘܼܪܵܐ ܕܟܵܗ̈ܢܹܐ ܘܦܪܝܼܡܵܐ ܠܹܗ ܢܵܬܹܗ ܕܝܲܡܝܼܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܐܡܝܼܪܹܗ: ”ܠܵܐ ܗܵܕܟ݂ܵܐ.“ ܘܕܩܝܼܪܹܗ ܒܢܵܬܵ‌ܐ ܕܗ̇ܘ ܐܢܵܫܵܐ ܘܒܘܼܣܡܵܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܠܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܠܚܘܵܪ̈ܕܸܩܢܹܐ ܘܠܪܹ̈ܝܫܵܢܹܐ ܕܢܵܛܘܿܪܹ̈ܐ ܕܗܲܝܟܠܵܐ ܕܐܬܹ‌ܐ ܠܗܘܿܢ ܠܸܕܒ݂ܵܩܹܗ: ”ܦܠܝܼܛ ܠܵܘܟ݂ܘܿܢ ܥܲܠܝܼ ܒܣܲܝܦܹ̈ܐ ܘܒܚܘܼܛܪܹ̈ܐ ܠܸܕܒ݂ܵܩܝܼ ܐܲܝܟ݂ ܕܐܸܢ ܓܹܢܵܒ݂ܵܐ ܝܘܸܢ. ");
INSERT INTO aii_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","”ܟܠܔ ܝܘܿܡ ܟܹܐ ܗܵܘܹܝܢ ܗܘܵܐ ܥܲܡܵܘܟ݂ܘܿܢ ܓܵܘ ܗܲܝܟܠܵܐ، ܘܠܵܐ ܕܒ݂ܝܼܩ ܠܵܘܟ݂ܘܿܢ ܐܸܠܝܼ. ܐܝܼܢܵܐ ܐܵܕܝܼܵܐ ܝܠܵܗ̇ ܣܵܥܲܬܵܘܟ݂ܘܿܢ، ܕܫܘܼܠܛܵܢܵܐ ܕܚܸܫܟܵܐ ܒܸܥܡܵܪܵܐ ܝܠܹܗ ܒܝܼܵܘܟ݂ܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ܘܕܒ݂ܝܼܩ ܠܗܘܿܢ ܠܝܼܫܘܿܥ ܘܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܐܸܠܹܗ ܠܒܲܝܬܵ‌ܐ ܕܓܘܼܪܵܐ ܕܟܵܗ̈ܢܹܐ، ܘܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܒܹܐܬܵܝܵܐ ܝܗܘܵܐ ܒܵܬܪܹܗ ܡ̣ܢ ܪܸܚܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ܫܝܼܪܗܘܿܢ ܢܘܼܪܵܐ ܒܹܝܦܲܠܓܵܐ ܕܕܵܪܬܵ‌ܐ ܘܝܬܝܼܒ݂ ܠܗܘܿܢ ܠܚܵܕܸܪ̈ܘܵܢܘܼܗ‌ܝ، ܘܐܘܼܦ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܝܬܝܼܒ݂ܵܐ ܝܗܘܵܐ ܥܲܡܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ܘܚܕܵܐ ܚܵܡܬܵ‌ܐ ܚܙܹܐ ܠܵܗ̇ ܐܸܠܹܗ ܝܬܝܼܒ݂ܵܐ ܠܟܸܣ ܢܘܼܪܵܐ، ܚܝܼܪܵܗ̇ ܒܝܼܹܗ ܘܐܡܝܼܪܵܗ̇: ”ܐܘܼܦ ܐܵܗܵܐ ܥܲܡܹܗ ܝܗܘܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ܐܝܼܢܵܐ ܗ̇ܘ ܣܪܝܼܒ݂ ܠܹܗ ܘܐܡܝܼܪܹܗ: ”ܒܲܟ݂ܬܵ‌ܐ، ܠܹܐ ܝܵܕܥܹܢܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ܘܡ̣ܢ ܒܵܬܪ ܚܲܕ ܡܸܬܚܵܐ ܟܸܪܝܵܐ، ܚܙܹܐ ܠܹܗ ܐܸܠܹܗ ܚܲܕ ܐܚܹܪܢܵܐ ܘܐܡܝܼܪܹܗ: ”ܐܘܼܦ ܐܲܢ݇ܬ ܡܸܢܵܝܗ‌ܝ ܝܘܸܬ.“ ܘܓ̰ܘܼܘܸܒ ܠܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ: ”ܝܵܐ ܐܢܵܫܵܐ، ܐܵܢܵܐ ܠܹܐ ܝܘܸܢ ܡܸܢܵܝܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ܘܒܵܬܪ ܚܕܵܐ ܣܵܥܲܬ، ܚܲܕ ܐܚܹܪܢܵܐ ܐܡܝܼܪܹܗ ܡܩܵܘܝܵܐܝܼܬ: ”ܫܲܪܝܼܪܵܐܝܼܬ ܐܘܼܦ ܐܵܗܵܐ ܥܲܡܹܗ ܝܗܘܵܐ، ܣܵܒܵܒ ܓܠܝܼܠܵܝܵܐ ܝܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ܓ̰ܘܼܘܸܒ ܠܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ: ”ܝܵܐ ܐܢܵܫܵܐ، ܠܹܐ ܝܘܸܢ ܒܝܼܕܵܥܵܐ ܡܘܼܕܝܼ ܗܲܡܙܘܼܡܹܐ ܝܘܸܬ.“ ܘܒܗ̇ܝ ܥܕܵܢܵܐ ܟܲܕ ܗ̇ܘ ܗܲܡܙܘܼܡܹܐ، ܩܪܹܐ ܠܹܗ ܩܵܪܘܿܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ܕܝܼܪܹܗ ܝܼܫܘܿܥ ܘܚܝܼܪܹܗ ܒܫܸܡܥܘܿܢ ܟܹܐܦܵܐ. ܘܕܟ݂ܝܼܪܹܗ ܫܸܡܥܘܿܢ ܗܹܡܸܙܡܵܢ ܕܡܵܪܲܢ ܕܐܡܝܼܪܵܐ ܝܗܘܵܐ ܐܸܠܹܗ: ”ܡ̣ܢ ܩܲܕܡ ܕܩܵܪܹܐ ܩܵܪܘܿܝܵܐ، ܒܸܬ ܣܵܪܒܹܬ ܠܝܼ ܬܠܵܬ ܓܵܗܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ܘܦܠܝܼܛ ܠܹܗ ܫܸܡܥܘܿܢ ܠܒܲܕܲܪ ܘܒܟܹܐ ܠܹܗ ܒܡܲܪܝܼܪܘܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ܘܐܢܵܫܹ̈ܐ ܕܕܒ݂ܝܼܩܹܐ ܝܗܘܵܘ ܠܝܼܫܘܿܥ ܡܲܣܚܸܪܝܼ ܗܘܵܘ ܒܝܼܹܗ ܘܡܵܚܝܼ ܗܘܵܘ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ܡܲܟܣܝܼ ܗܘܵܘ ܥܲܝܢܘܼ̈ܗ‌ܝ ܘܡܵܚܝܼ ܗܘܵܘ ܥܲܠܔ ܦܵܬܹܗ، ܘܐܵܡܪܝܼ ܗܘܵܘ: ”ܢܲܒܝܼ، ܡܵܢܝܼ ܩܵܡ ܡܵܚܹܐ ܠܘܼܟ݂؟“ ");
INSERT INTO aii_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ܘܪܵܒܵܐ ܡܸܢܕܝܼܵܢܹ̈ܐ ܐܚܹܪ̈ܢܹܐ ܓܵܕܦܝܼ ܗܘܵܘ ܥܲܠܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ܟܲܕ ܗܘܹܐ ܠܹܗ ܝܵܘܡܵܐ، ܓ̰ܡܝܼܥ ܠܗܘܿܢ ܚܘܵܪ̈ܕܸܩܢܹܐ ܕܥܲܡܵܐ ܘܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܣܵܦܪܹ̈ܐ، ܘܠܘܼܒܸܠܔ ܠܗܘܿܢ ܠܝܼܫܘܿܥ ܩܲܕܡ ܟܢܘܼܫܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ܘܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ: ”ܐܸܢ ܐܲܢ݇ܬ ܝܼܘܸܬ ܡܫܝܼܚܵܐ، ܐܡܘܿܪ ܐܸܠܲܢ.“ ܘܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ: ”ܐܸܢ ܐܵܡܪܹܢܵܘܟ݂ܘܿܢ ܠܹܐ ܗܲܡܸܢܝܼܬܘܿܢ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","”ܘܐܸܢ ܒܲܩܪܸܢܵܘܟ݂ܘܿܢ ܠܹܐ ܓ̰ܲܘܸܒܝܼܬܘܿܢ ܠܝܼ، ܘܠܹܐ ܫܵܪܹܝܬܘܿܢ ܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","”ܡ̣ܢ ܐܵܕܝܼܵܐ ܒܸܬ ܝܵܬܹܒ݂ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܡ̣ܢ ܝܲܡܝܼܢܵܐ ܕܐܲܠܵܗܵܐ ܚܲܝܠܬܵܢܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ܘܟܠܵܝܗ‌ܝ ܒܘܼܩܸܪܗܘܿܢ: ”ܒܵܣ ܗܵܕܟ݂ܵܐ ܐܲܢ݇ܬ ܝܼܘܸܬ ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ؟“ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܗܹܐ، ܐܲܝܟ݂ ܕܒܹܐܡܵܪܵܐ ܝܬܘܿܢ، ܐܵܢܵܐ ܝܘܸܢ ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ܘܐܡܝܼܪܗܘܿܢ: ”ܩܵܡܘܿܕܝܼ ܐܚܹܪܢܵܐ ܣܢܝܼܩܹܐ ܝܘܲܚ ܠܣܵܗܕܹ̈ܐ؟ ܒܓܵܢܲܢ ܫܡܝܼܥ ܠܲܢ ܡ̣ܢ ܦܘܼܡܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ܘܩܝܼܡ ܠܗܘܿܢ ܟܠܹܗ ܟܸܢܫܵܝܗ‌ܝ ܘܠܘܼܒܸܠܔ ܠܗܘܿܢ ܠܝܼܫܘܿܥ ܠܟܸܣ ܦܝܼܠܵܛܘܿܣ. ");
INSERT INTO aii_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ܘܫܘܼܪܹܐ ܠܗܘܿܢ ܗܲܡܙܘܼܡܹܐ ܠܕܲܠܩܘܼܒ݂ܠܹܗ ܘܒܹܐܡܵܪܵܐ: ”ܚܙܹܐ ܠܲܢ ܐܵܗܵܐ ܐܢܵܫܵܐ ܡܲܚܠܘܼܛܹܐ ܠܛܵܝܸܦܲܢ ܘܡܲܟܠܘܼܝܹܐ ܡ̣ܢ ܠܝܼܵܗܒ݂ܵܐ ܙܘܼܙܹ̈ܐ ܕܪܹܝܫܝܼܬܵ‌ܐ ܠܩܹܣܲܪ، ܘܒܹܐܡܵܪܵܐ ܒܘܼܬ ܓܵܢܹܗ ܕܗ̇ܘ ܝܼܠܹܗ ܡܫܝܼܚܵܐ، ܡܲܠܟܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ܒܘܼܩܸܪܹܗ ܡܸܢܹܗ ܦܝܼܠܵܛܘܿܣ: ”ܐܲܢ݇ܬ ܝܼܘܸܬ ܡܲܠܟܵܐ ܕܝܗܘܼܕܵܝܹ̈ܐ؟“ ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ: ”ܗܹܐ، ܐܲܝܟ݂ ܕܒܹܐܡܵܪܵܐ ܝܘܸܬ.“ ");
INSERT INTO aii_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ܐܡܝܼܪܹܗ ܦܝܼܠܵܛܘܿܣ ܠܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܠܟܸܢܫܵܐ: ”ܐܵܢܵܐ ܠܹܐ ܝܘܸܢ ܡܲܫ݇ܟ̰ܘܼܚܹܐ ܥܸܠܬܵ‌ܐ ܕܲܠܩܘܼܒ݂ܠܔ ܕܐܵܗܵܐ ܐܢܵܫܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ܐܝܼܢܵܐ ܐܵܢܝܼ ܡܲܩܘܸܚܝܼ ܗܘܵܘ ܒܹܐܡܵܪܵܐ: ”ܡܲܫܓ݂ܘܼܫܹܐ ܝܠܹܗ ܠܥܲܡܲܢ ܒܝܘܼܠܦܵܢܹܗ ܓܵܘ ܟܠܹܗ ܝܼܗܘܼܕ. ܫܘܼܪܹܐ ܠܹܗ ܡ̣ܢ ܓܠܝܼܠܵܐ ܘܗܲܠܔ ܠܲܐܟ݂ܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܹܗ ܦܝܼܠܵܛܘܿܣ ܫܸܡܵܐ ܕܓܠܝܼܠܵܐ، ܒܘܼܩܸܪܹܗ ܕܐܸܢ ܐܵܗܵܐ ܐܢܵܫܵܐ ܓܠܝܼܠܵܝܵܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ܘܐܝܼܡܲܢ ܕܝܕܝܼܥ ܠܹܗ ܕܓܠܝܼܠܵܝܵܐ ܝܗܘܵܐ ܘܬܚܘܿܬ ܫܘܼܠܛܵܢܵܐ ܕܗܹܪܘܿܕܸܣ، ܫܘܼܕܸܪܹܗ ܐܸܠܹܗ ܠܟܸܣ ܗܹܪܘܿܕܸܣ ܣܵܒܵܒ ܗ̇ܘ ܓܵܘ ܐܘܿܪܸܫܠܸܡ ܝܼܗܘܵܐ ܒܐܵܢܝܼ ܝܵܘܡܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ܐܝܼܡܲܢ ܕܗܹܪܘܿܕܸܣ ܚܙܹܐ ܠܹܗ ܠܝܼܫܘܿܥ، ܚܕܹܐ ܠܹܗ ܪܵܒܵܐ، ܣܵܒܵܒ ܡ̣ܢ ܓ̰ܲܠܕܹܐ ܟܹܐ ܒܵܥܹܐ ܗܘܵܐ ܠܸܚܙܵܝܹܗ، ܒܗ̇ܝ ܕܫܡܝܼܥܵܐ ܝܗܘܵܐ ܒܘܼܬ ܕܝܼܹܗ ܪܵܒܵܐ ܡܸܢܕܝܼܵܢܹ̈ܐ، ܘܒܸܣܦܵܪܵܐ ܝܗܘܵܐ ܕܥܵܒܹܕ ܗܘܵܐ ܚܲܕ ܢܝܼܫܲܢܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ܪܵܒܵܐ ܒܘܼܩܵܪܹ̈ܐ ܒܘܼܩܸܪܹܗ ܗܹܪܘܿܕܸܣ ܡܸܢܹܗ، ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܠܵܐ ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ ܐܘܼܦ ܚܲܕ. ");
INSERT INTO aii_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ܘܟܸܠܝܹܐ ܝܗܘܵܘ ܬܵܡܵܐ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܣܵܦܪܹ̈ܐ، ܘܒܩܸܫܝܘܼܬܵ‌ܐ ܗܲܡܙܸܡܝܼ ܗܘܵܘ ܕܲܠܩܘܼܒ݂ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ܘܗܹܪܘܿܕܸܣ ܘܕܲܚܫܘܼ̈ܗ‌ܝ ܡܘܼܣܠܹܐ ܠܗܘܿܢ ܐܸܠܹܗ، ܘܡܘܼܣܚܸܪܗܘܿܢ ܒܝܼܹܗ، ܘܡܘܼܠܒܸܫ ܠܗܘܿܢ ܐܸܠܹܗ ܠܒ݂ܝܼܫܬܵ‌ܐ ܫܲܦܝܼܪܬܵ‌ܐ، ܘܡܘܼܕܸܪܗܘܿܢ ܐܸܠܹܗ ܠܟܸܣ ܦܝܼܠܵܛܘܿܣ. ");
INSERT INTO aii_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ܘܒܗ̇ܘ ܝܵܘܡܵܐ ܦܝܼܠܵܛܘܿܣ ܘܗܹܪܘܿܕܸܣ ܗܘܹܐ ܠܗܘܿܢ ܚܲܒ݂ܪ̈ܵܘܵܬܹ‌ܐ ܡܥܘܼܕܵܠܹܐ، ܣܵܒܵܒ ܕܸܫ̃ܡܸܢܵܝܘܼܬܵ‌ܐ ܡ̣ܢ ܓ̰ܲܠܕܹܐ ܐܝܼܬ ܗܘܵܐ ܒܹܝܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ܩܪܹܐ ܠܹܗ ܦܝܼܠܵܛܘܿܣ ܠܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܠܪܹ̈ܝܫܵܢܹܐ ܕܝܗܘܼܕܵܝܹ̈ܐ ܘܕܥܲܡܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܡܘܼܝܬܹ‌ܐ ܠܵܘܟ݂ܘܿܢ ܐܵܗܵܐ ܐܢܵܫܵܐ ܠܟܸܣܠܝܼ ܐܲܝܟ݂ ܚܲܕ ܚܵܒ݂ܛܵܢܵܐ ܕܥܲܡܵܐ، ܘܐܵܢܵܐ ܨܘܼܚܨܹܐ ܠܝܼ ܐܸܠܹܗ ܩܲܕܡܵܘܟ݂ܘܿܢ ܘܠܵܐ ܡܘܼܫ݇ܟ̰ܸܚ ܠܝܼ ܒܝܼܹܗ ܥܸܠܬܵ‌ܐ ܕܒܘܼܬ ܕܝܼܘܼܗ̇ ܒܸܠܝܵܡܹܗ ܝܬܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","”ܐܘܼܦ ܗܹܪܘܿܕܸܣ ܠܵܐ ܚܙܹܐ ܠܹܗ ܒܝܼܹܗ ܓܢܵܗܵܐ، ܗܵܕܟ݂ܵܐ ܫܘܼܕܸܪܹܗ ܐܸܠܹܗ ܠܲܐܟ݂ܵܐ. ܠܹܐ ܝܠܹܗ ܥܒ݂ܝܼܕܵܐ ܡܸܢܕܝܼ ܕܚܵܫܹܚ ܠܡܵܘܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","”ܒܘܼܬ ܐܵܗܵܐ ܒܸܬ ܬܲܥܠܸܡܸܢܹܗ ܘܫܵܪܹܢܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ܐܝܼܬ ܗܘܵܐ ܥܝܵܕܵܐ ܕܫܵܪܹܐ ܗܘܵܐ ܦܝܼܠܵܛܘܿܣ ܐܸܠܵܝܗ‌ܝ ܚܲܕ ܐܲܣܝܼܪܵܐ ܒܝܵܘܡܵܐ ܕܥܹܐܕܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ܐܝܼܢܵܐ ܟܠܵܝܗ‌ܝ ܡܘܼܩܘܸܚ ܠܗܘܿܢ ܒܚܲܕ ܩܵܠܵܐ ܘܐܡܝܼܪܗܘܿܢ: ”ܛܲܠܸܩ ܠܐܵܗܵܐ ܐܢܵܫܵܐ، ܘܫܪܝܼ ܐܸܠܲܢ ܠܒܲܪ ܐܲܒܵܐ!“ ");
INSERT INTO aii_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ܒܲܪ ܐܲܒܵܐ ܦܝܼܫܵܐ ܝܗܘܵܐ ܕܸܪܝܵܐ ܓܵܘ ܒܹܝܬ ܐܲܣܝܼܪܹ̈ܐ ܒܘܼܬ ܫܓ݂ܘܼܫܝܵܐ ܘܩܸܛܠܵܐ ܕܥܒ݂ܝܼܕܵܐ ܝܗܘܵܐ ܓܵܘ ܡܕܝܼܢ݇ܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ܡܸܢܕܪܸܫ ܗܘܼܡܙܸܡ ܠܹܗ ܥܲܡܵܝܗ‌ܝ ܦܝܼܠܵܛܘܿܣ ܟܲܕ ܒܸܒܥܵܝܵܐ ܕܫܵܪܹܐ ܗܘܵܐ ܠܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ܐܝܼܢܵܐ ܐܵܢܝܼ ܡܲܩܘܸܚܝܼ ܗܘܵܘ ܒܹܐܡܵܪܵܐ: ”ܡܚܝܼ ܠܹܗ ܠܙܩܝܼܦܵܐ!“ ");
INSERT INTO aii_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ܓܵܗܵܐ ܕܬܠܵܬ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܦܝܼܠܵܛܘܿܣ: ”ܡܘܼܕܝܼ ܒܝܼܫܬܵ‌ܐ ܥܒ݂ܝܼܕܵܐ ܝܠܹܗ؟ ܥܸܠܬܵ‌ܐ ܕܚܵܫܚܵܐ ܠܡܵܘܬܵ‌ܐ ܠܹܐ ܝܘܸܢ ܡܲܫ݇ܟ̰ܘܼܚܹܐ ܒܝܼܹܗ. ܒܸܬ ܬܲܥܠܸܡܸܢܹܗ ܘܫܵܪܹܢܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ܐܝܼܢܵܐ ܐܵܢܝܼ ܡܲܠܝܸܙܝܼ ܗܘܵܘ ܒܩܵܠܵܐ ܪܵܡܵܐ ܘܛܵܠܒܝܼ ܗܘܵܘ ܡܸܢܹܗ ܕܦܵܐܹܫ ܡܸܚܝܵܐ ܠܙܩܝܼܦܵܐ. ܘܓ݂ܠܝܼܒ ܠܹܗ ܩܵܠܵܝܗ‌ܝ ܘܩܵܠܵܐ ܕܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ܗ̇ܝܓܵܗ ܩܛܝܼܥ ܠܹܗ ܦܝܼܠܵܛܘܿܣ ܕܦܵܝܫܵܐ ܬܘܼܡܸܡܬܵ‌ܐ ܒܵܥܘܼܬܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ܫܪܹܐ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܠܒܲܪ ܐܲܒܵܐ، ܗ̇ܘ ܕܒܘܼܬ ܫܓ݂ܘܼܫܝܵܐ ܘܩܸܛܠܵܐ ܦܝܼܫܵܐ ܝܗܘܵܐ ܕܸܪܝܵܐ ܓܵܘ ܒܹܝܬ ܐܲܣܝܼܪܹ̈ܐ، ܗ̇ܘ ܕܐܵܢܝܼ ܛܠܝܼܒ ܠܗܘܿܢ. ܘܠܝܼܫܘܿܥ ܣܘܼܦܹܐ ܠܹܗ ܠܨܸܒ݂ܝܵܢܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ܟܲܕ ܠܲܒܘܼܠܹܐ ܝܗܘܵܘ ܠܝܼܫܘܿܥ، ܕܒ݂ܝܼܩ ܠܗܘܿܢ ܠܫܸܡܥܘܿܢ ܩܸܘܪܝܼܢܵܝܵܐ ܕܒܹܐܬܵܝܵܐ ܝܗܘܵܐ ܡ̣ܢ ܚܲܩܠܵܐ، ܘܡܘܼܬܸܒ݂ ܠܗܘܿܢ ܠܚܲܨܹܗ ܙܩܝܼܦܵܐ ܕܛܵܥܹܢܹܗ ܘܐܵܙܹܠܔ ܒܵܬܪܵܐ ܒܵܬܪ ܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ܘܒܹܐܬܵܝܵܐ ܝܗܘܵܐ ܒܵܬܪܹܗ ܟܸܢܫܵܐ ܪܵܒܵܐ، ܘܒܲܟ݂ܬܵܬܹ̈‌ܐ ܒܸܥܒ݂ܵܕܵܐ ܬܵܥܙܝܼ ܘܒܸܠܝܵܝܵܐ ܥܲܠܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ܘܕܝܼܪܹܗ ܝܼܫܘܿܥ ܠܟܸܣ ܒܲܟ݂ܬܵܬܹ̈‌ܐ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܒܢܵܬܹ̈‌ܐ ܕܐܘܿܪܸܫܠܸܡ، ܠܵܐ ܒܵܟܹܝܬܘܿܢ ܥܲܠܝܼ، ܐܝܼܢܵܐ ܒܟܹܝܡܘܼܢ ܥܲܠܔ ܓܵܢܵܘܟ݂ܘܿܢ ܘܥܲܠܔ ܒܢܘܿܢܵܘ̈ܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","”ܣܵܒܵܒ ܒܸܬ ܐܵܬ‌ܝܼ ܝܵܘܡܵܢܹ̈ܐ ܕܒܸܬ ܐܵܡܪܝܼ: ’ܛܘܼܒ݂ܵܐ ܠܥܲܩܪ̈ܵܬܹ‌ܐ ܘܠܟܹܪ̈݇ܣܵܬܹ‌ܐ ܕܠܵܐ ܗܘܼܨܸܠܔ ܠܗܘܿܢ، ܘܠܒܸܙܵܙܹ̈ܐ ܕܠܵܐ ܡܘܼܡܸܨ ܠܗܘܿܢ.‘ ");
INSERT INTO aii_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","”ܗ̇ܝܓܵܗ ܒܸܬ ܫܲܪܝܼ ܠܹܐܡܵܪܵܐ ܠܛܘܼܪ̈ܵܢܹܐ: ’ܢܦܘܿܠܘܼܢ ܥܲܠܲܢ، ܘܠܪ̈ܘܼܡܝܵܬܹ‌ܐ، ܟܲܣܹܝܡܘܼܢ ܠܲܢ.‘ ");
INSERT INTO aii_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","”ܐܸܢ ܒܐܝܼܠܵܢܵܐ ܬܲܠܝܼܠܵܐ ܐܲܢܹܐ ܒܸܥܒ݂ܵܕܵܐ ܝܢܵܐ، ܡܘܼܕܝܼ ܒܸܬ ܥܵܒ݂ܕܝܼ ܒܐܝܼܠܵܢܵܐ ܒܵܪܘܿܙܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ܘܦܝܼܫ ܠܗܘܿܢ ܠܘܼܒܠܹܐ ܥܲܡܹܗ ܬܪܹܝ ܐܚܹܪ̈ܢܹܐ، ܥܵܒ݂ܕܵܢܹ̈ܐ ܕܒܝܼܫܵܬܹ̈‌ܐ ܕܦܵܝܫܝܼ ܗܘܵܘ ܩܛܝܼܠܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ܘܟܲܕ ܡܛܹܐ ܠܗܘܿܢ ܠܚܕܵܐ ܕܘܼܟܵܐ ܕܦܝܵܫܵܐ ܝܠܵܗ̇ ܩܪܝܼܬܵ‌ܐ ܩܲܪܩܲܦܬܵ‌ܐ، ܙܩܝܼܦ ܠܗܘܿܢ ܐܸܠܹܗ ܬܵܡܵܐ. ܐܘܼܦ ܠܐܵܢܝܼ ܬܪܹܝ ܥܵܒ݂ܕܵܢܹ̈ܐ ܕܒܝܼܫܵܬܹ̈‌ܐ ܙܩܝܼܦ ܠܗܘܿܢ، ܚܲܕ ܡ̣ܢ ܝܲܡܝܼܢܹܗ ܘܚܲܕ ܡ̣ܢ ܣܸܡܵܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ܘܐܡܝܼܪܹܗ ܝܼܫܘܿܥ: ”ܝܵܐ ܒܵܒܵܐ، ܦܲܚܸܠܔ ܠܗܘܿܢ ܣܵܒܵܒ ܠܹܐ ܝܢܵܐ ܒܝܼܕܵܥܵܐ ܡܘܼܕܝܼ ܝܢܵܐ ܒܸܥܒ݂ܵܕܵܐ.“ ܘܦܘܼܠܸܥ ܠܗܘܿܢ ܓ̰ܘܼܠܘܼ̈ܗ‌ܝ، ܘܕܪܹܐ ܠܗܘܿܢ ܥܲܠܵܝܗ‌ܝ ܦܸܫܟܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ܟܸܠܝܵܐ ܝܗܘܵܐ ܬܵܡܵܐ ܥܲܡܵܐ ܘܒܸܚܙܵܝܵܐ، ܘܐܘܼܦ ܓܘܼܪ̈ܵܢܹܐ ܡܲܣܚܸܪܝܼ ܗܘܵܘ ܒܝܼܹܗ ܘܐܵܡܪܝܼ ܗܘܵܘ: ”ܠܐܚܹܪ̈ܢܹܐ ܦܘܼܪܸܩ ܠܹܗ، ܫܒ݂ܘܿܩ ܕܦܲܪܸܩ ܠܓܵܢܹܗ ܐܸܢ ܐܵܗܵܐ ܝܠܹܗ ܡܫܝܼܚܵܐ ܓܘܼܒܝܵܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ܐܘܼܦ ܕܲܚܫܹ̈ܐ ܡܲܣܚܸܪܝܼ ܗܘܵܘ ܒܝܼܹܗ. ܩܲܪܒܸܢܝܼ ܗܘܵܘ ܠܟܸܣܠܹܗ ܘܝܵܗܒ݂ܝܼ ܗܘܵܘ ܠܹܗ ܚܲܠܵܐ ܠܸܫܬܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ܘܐܵܡܪܝܼ ܗܘܵܘ ܐܸܠܹܗ: ”ܐܸܢ ܐܲܢ݇ܬ ܝܼܘܸܬ ܡܲܠܟܵܐ ܕܝܗܘܼܕܵܝܹ̈ܐ، ܦܲܪܸܩ ܓܵܢܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ܟܬܝܼܒ݂ ܠܗܘܿܢ ܐܘܼܦ ܟܬܝܼܒ݂ܬܵ‌ܐ ܥܸܠܸܠܔ ܡ̣ܢ ܪܹܝܫܹܗ ܒܠܸܫܵܢܵܐ ܝܵܘܢܵܝܵܐ ܘܪܗܘܿܡܵܝܵܐ ܘܥܸܒ݂ܪܵܝܵܐ: ”ܐܵܗܵܐ ܝܠܹܗ ܡܲܠܟܵܐ ܕܝܗܘܼܕܵܝܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ܚܲܕ ܡ̣ܢ ܐܵܢܝܼ ܬܪܹܝ ܥܵܒ݂ܕܵܢܹ̈ܐ ܕܒܝܼܫܵܬܹ̈‌ܐ ܕܙܩܝܼܦܵܐ ܝܗܘܵܐ ܥܲܡܹܗ ܓܵܕܹܦ ܗܘܵܐ ܥܲܠܘܼܗ‌ܝ ܘܐܵܡܹܪ ܗܘܵܐ: ”ܠܹܐ ܝܘܸܬ ܐܲܢ݇ܬ ܡܫܝܼܚܵܐ؟ ܦܲܪܸܩ ܓܵܢܘܼܟ݂، ܘܐܘܼܦ ܐܸܠܲܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ܐܝܼܢܵܐ ܗ̇ܘ ܐܚܹܪܢܵܐ ܡܘܼܢܟܸܣ ܠܹܗ ܐܸܠܹܗ ܘܐܡܝܼܪܹܗ: ”ܐܘܼܦ ܡ̣ܢ ܐܲܠܵܗܵܐ ܠܹܐ ܝܘܸܬ ܒܸܙܕܵܥܵܐ، ܟܲܕ ܬܚܘܿܬ ܕܗ̇ܝ ܕܝܵܢܬܵ‌ܐ ܝܘܸܬ ܐܲܝܟ݂ ܕܝܼܠܹܗ ܗ̇ܘ؟ ");
INSERT INTO aii_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","”ܐܲܚܢܲܢ ܒܗܵܩܘܼܬܵ‌ܐ ܦܝܵܫܵܐ ܝܘܲܚ ܕܝܼܢܹܐ، ܐܲܝܟ݂ ܕܚܵܫܚܵܐ ܐܸܠܲܢ ܘܐܲܝܟ݂ ܦܘܼܠܚܵܢܲܢ ܦܝܵܫܵܐ ܝܘܲܚ ܦܪܝܼܥܹܐ. ܐܝܼܢܵܐ ܐܵܗܵܐ ܐܢܵܫܵܐ ܡܸܢܕܝܼ ܚܸܪܒܵܐ ܠܹܐ ܝܠܹܗ ܥܒ݂ܝܼܕܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ܗ̇ܝܓܵܗ ܐܡܝܼܪܹܗ: ”ܝܵܐ ܝܼܫܘܿܥ، ܕܟ݂ܘܿܪܝܼ ܐܝܼܡܲܢ ܕܐܵܬܹܝܬ ܒܡܲܠܟܘܼܬܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܘܼܟ݂، ܐܸܕܝܘܿܡ ܒܸܬ ܗܵܘܹܝܬ ܥܲܡܝܼ ܓܵܘ ܦܲܪܕܲܝܣܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ܐܲܝܟ݂ ܣܵܥܲܬ ܕܬܪܸܥܣܲܪ ܕܟܵܘܸܬܪܵܐ، ܗܘܹܐ ܠܹܗ ܚܸܫܟܵܐ ܥܲܠܔ ܟܠܵܗ̇ ܐܲܪܥܵܐ ܗܲܠܔ ܣܵܥܲܬ ܕܬܠܵܬ ܡ̣ܢ ܒܵܬܪ ܟܵܘܸܬܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ܚܒܹܐ ܠܹܗ ܫܸܡܫܵܐ، ܘܦܝܼܫ ܠܹܗ ܦܪܝܼܛܵܐ ܣܸܬܪܵܐ ܕܗܲܝܟܠܵܐ ܡ̣ܢ ܒܹܝܦܲܠܓܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ܘܡܘܼܩܘܸܚ ܠܹܗ ܝܼܫܘܿܥ ܒܩܵܠܵܐ ܪܵܡܵܐ ܘܐܡܝܼܪܹܗ: ”ܝܵܐ ܒܵܒܝܼ، ܒܐܝܼܕܵܬܘܼ̈ܟ݂ ܣܲܦܘܼܝܘܼܗ̇ ܝܘܸܢ ܪܘܼܚܝܼ.“ ܐܡܝܼܪܹܗ ܗܵܕܟ݂ܵܐ ܘܣܘܼܦܝܵܐ ܠܹܗ ܪܘܼܚܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܹܗ ܪܲܒ ܡܵܐܐ ܡܸܢܕܝܼ ܕܗܘܹܐ ܠܹܗ، ܫܘܼܒܸܚ ܠܹܗ ܠܐܲܠܵܗܵܐ ܘܐܡܝܼܪܹܗ: ”ܫܲܪܝܼܪܵܐܝܼܬ ܐܵܗܵܐ ܐܢܵܫܵܐ ܙܲܕܝܼܩܵܐ ܝܗܘܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ܘܟܠܵܝܗ‌ܝ ܟܸܢܫܹ̈ܐ ܕܓ̰ܡܝܼܥܹܐ ܝܗܘܵܘ ܠܓܲܫܘܼܩܹܐ، ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܗܘܿܢ ܡܸܢܕܝܼ ܕܗܘܹܐ ܠܹܗ، ܕܝܼܪܗܘܿܢ ܒܸܡܚܵܝܵܐ ܥܲܠܔ ܨܲܕܪ̈ܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ܘܟܸܠܝܹܐ ܝܗܘܵܘ ܡ̣ܢ ܪܸܚܩܵܐ ܟܠܵܝܗ‌ܝ ܝܵܕܥܵܢܘܼ̈ܗ‌ܝ، ܐܘܼܦ ܒܲܟ݂ܬܵܬܹ̈‌ܐ ܕܝܼܗܘܵܘ ܐܬܝܼܹܐ ܥܲܡܹܗ ܡ̣ܢ ܓܠܝܼܠܵܐ، ܘܒܸܚܙܵܝܵܐ ܝܗܘܵܘ ܐܲܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ܐܝܼܬ ܗܘܵܐ ܚܲܕ ܐܢܵܫܵܐ ܫܸܡܹܗ ܝܵܘܣܸܦ ܕܐܬܹ‌ܐ ܠܹܗ ܡ̣ܢ ܪܵܡܬܵ‌ܐ ܡܕܝܼܢ݇ܬܵ‌ܐ ܕܝܼܗܘܼܕ، ܡܵܠܘܿܟ݂ܵܐ، ܐܢܵܫܵܐ ܛܵܒ݂ܵܐ ܘܟܹܐܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ܐܵܗܵܐ ܠܵܐ ܥܒ݂ܝܼܕ ܠܹܗ ܐܲܝܟ݂ ܨܸܒ݂ܝܵܢܵܝܗ‌ܝ ܘܠܵܐ ܐܲܝܟ݂ ܦܘܼܠܚܵܢܵܝܗ‌ܝ. ܐܝܼܢܵܐ ܒܸܣܦܵܪܵܐ ܝܗܘܵܐ ܠܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ܐܵܗܵܐ ܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣ ܦܝܼܠܵܛܘܿܣ ܘܛܠܝܼܒ ܠܹܗ ܦܲܓ݂ܪܵܐ ܕܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ܘܡܘܼܨܠܹܐ ܠܹܗ ܠܦܲܓ݂ܪܵܐ ܘܟܘܼܪܡܸܟ݂ ܠܹܗ ܒܟܸܬܵܢܵܐ، ܘܡܘܼܬܸܒ݂ ܠܹܗ ܓܵܘ ܒܹܝܬ ܩܒ݂ܘܼܪܵܐ ܢܩܝܼܪܵܐ ܓܵܘ ܟܹܐܦܵܐ، ܕܐܘܼܦ ܚܲܕ ܠܹܐ ܝܗܘܵܐ ܦܝܼܫܵܐ ܡܘܼܬܒ݂ܵܐ ܓܵܘܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ܝܵܘܡܵܐ ܕܗܲܕܲܪܬܵ‌ܐ ܝܗܘܵܐ، ܘܫܲܒܬܵ‌ܐ ܒܸܙܪܵܩܵܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ܘܒܲܟ݂ܬܵܬܹ̈‌ܐ ܕܐܬܝܼܹܐ ܝܗܘܵܘ ܥܲܡ ܝܼܫܘܿܥ ܡ̣ܢ ܓܠܝܼܠܵܐ ܚܙܹܐ ܠܗܘܿܢ ܠܩܲܒ݂ܪܵܐ، ܘܕܵܐܟ݂ܝܼ ܝܗܘܵܐ ܡܘܼܬܒ݂ܵܐ ܓܵܘܹܗ ܦܲܓ݂ܪܵܐ ܕܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ܕܝܼܪܗܘܿܢ ܘܗܘܼܕܸܪܗܘܿܢ ܒܸܣܡܹ̈ܐ ܘܗܹܪ̈ܘܿܡܹܐ، ܘܒܫܲܒܬܵ‌ܐ ܫܠܹܐ ܠܗܘܿܢ ܐܲܝܟ݂ ܦܘܼܩܕܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ܒܝܵܘܡܵܐ ܩܲܕܡܵܝܵܐ ܕܫܲܒܬܵ‌ܐ، ܒܨܲܦܪܵܐ، ܟܲܕ ܗܸܫ ܚܸܫܟܵܐ، ܫܩܝܼܠܔ ܠܗܘܿܢ ܐܵܢܝܼ ܒܲܟ݂ܬܵܬܹ̈‌ܐ ܗܹܪ̈ܘܿܡܹܐ ܕܗܘܼܕܪܵܝ ܝܗܘܵܘ ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܠܩܲܒ݂ܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ܘܚܙܹܐ ܠܗܘܿܢ ܠܟܹܐܦܵܐ ܡܘܼܚܕܸܪܵܐ ܡ̣ܢ ܩܲܒ݂ܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ܘܥܒ݂ܝܼܪܗܘܿܢ ܘܠܵܐ ܚܙܹܐ ܠܗܘܿܢ ܦܲܓ݂ܪܵܐ ܕܡܵܪܲܢ ܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ܟܲܕ ܐܵܢܝܼ ܥܓ̰ܝܼܒܹ̈ܐ ܒܐܵܗܵܐ، ܗܵܐ ܬܪܹܝ ܐܢܵܫܹ̈ܐ ܒܓ̰ܘܼܠܹ̈ܐ ܡܲܒܪܸ̈ܩܵܢܹܐ ܟܠܹܐ ܠܗܘܿܢ ܒܕܸܦܢܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ܘܗܘܹܐ ܠܗܘܿܢ ܒܙܕܘܼܥܬܵ‌ܐ، ܘܡܘܼܟܸܦ ܠܗܘܿܢ ܦܵܬܵܝܗ‌ܝ ܠܐܲܪܥܵܐ. ܐܝܼܢܵܐ ܐܵܢܝܼ ܐܢܵܫܹ̈ܐ ܐܡܝܼܪܗܘܿܢ ܐܸܠܵܝܗ‌ܝ: ”ܩܵܡܘܿܕܝܼ ܒܸܛܥܵܝܵܐ ܝܬܘܿܢ ܠܚܵܝܵܐ ܓܵܘ ܡܝܼ̈ܬܹ‌ܐ؟ ");
INSERT INTO aii_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","”ܠܹܐ ܝܠܹܗ ܠܲܐܟ݂ܵܐ، ܩܝܼܡܵܐ ܝܠܹܗ. ܕܟ݂ܘܿܪܘܼܢ ܕܵܐܟ݂ܝܼ ܗܘܼܡܙܸܡ ܠܹܗ ܥܲܡܵܘܟ݂ܘܿܢ ܗܸܫ ܗ̇ܘ ܓܵܘ ܓܠܝܼܠܵܐ، ");
INSERT INTO aii_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","”ܕܘܵܠܹܐ ܝܠܵܗ̇ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܦܵܐܹܫ ܣܘܼܦܝܵܐ ܒܐܝܼܕܵܬܹ̈‌ܐ ܕܐܢܵܫܹ̈ܐ ܚܲܛܵܝܹ̈ܐ، ܦܵܐܹܫ ܡܸܚܝܵܐ ܠܙܩܝܼܦܵܐ، ܘܒܝܵܘܡܵܐ ܕܬܠܵܬܵ‌ܐ ܩܵܐܹܡ.“ ");
INSERT INTO aii_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ܗ̇ܝܓܵܗ ܐܵܢܝܼ ܕܟ݂ܝܼܪܗܘܿܢ ܗܹܡܸܙܡܵܢܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ܘܕܝܼܪܗܘܿܢ ܡ̣ܢ ܩܲܒ݂ܪܵܐ، ܘܗܘܼܩܹܐ ܠܗܘܿܢ ܟܠܵܝܗ‌ܝ ܐܲܢܹܐ ܠܚܲܕܸܥܣܲܪ ܘܠܟܠܵܝܗ‌ܝ ܐܚܹܪ̈ܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ܘܐܲܢܹܐ ܝܗܘܵܘ ܒܲܟ݂ܬܵܬܹ̈‌ܐ: ܡܲܪܝܲܡ ܡܲܓ݂ܕܠܵܝܬܵ‌ܐ، ܘܝܘܿܚܲܢ، ܘܡܲܪܝܲܡ ܝܸܡܵܐ ܕܝܲܥܩܘܿܒ݂، ܘܒܲܟ݂ܬܵܬܹ̈‌ܐ ܐܚܹܪ̈ܢܹܐ ܥܲܡܵܝܗ‌ܝ. ܐܲܢܹܐ ܗܘܼܩܹܐ ܠܗܘܿܢ ܟܠܔ ܡܸܢܕܝܼ ܠܫܠܝܼܚܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ܐܝܼܢܵܐ ܐܵܢܝܼ ܠܵܐ ܗܘܼܡܸܢܗܘܿܢ ܠܒܲܟ݂ܬܵܬܹ̈‌ܐ، ܘܚܫܝܼܒ݂ ܠܗܘܿܢ ܗܹܡܸܙܡܵܢܵܝ̈ܗ‌ܝ ܐܲܝܟ݂ ܗܹܡܸܙܡܵܢܹ̈ܐ ܕܫܹܐܕܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ܩܝܼܡ ܠܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܘܪܚܝܼܛ ܠܹܗ ܠܩܲܒ݂ܪܵܐ، ܘܟܝܼܦ ܠܹܗ ܘܚܙܹܐ ܠܹܗ ܠܟܸܬܵܢܹ̈ܐ ܡܘܼܬܒܹܐ ܒܢܲܦ̮ܫܵܝܗ‌ܝ. ܘܐܙܝܼܠܔ ܠܹܗ ܟܲܕ ܥܲܓ̰ܘܼܒܹܐ ܒܘܼܬ ܡܸܢܕܝܼ ܕܗܘܹܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ܒܗ̇ܘ ܝܵܘܡܵܐ ܬܪܹܝ ܡܸܢܵܝܗ‌ܝ ܒܹܐܙܵܠܵܐ ܝܗܘܵܘ ܠܚܕܵܐ ܡܵܬܵ‌ܐ ܫܸܡܘܼܗ̇ ܥܲܡܵܐܘܿܣ، ܪܸܚܩܵܐ ܡ̣ܢ ܐܘܿܪܸܫܠܸܡ ܫܲܒ݂ܥܵܐ ܡܝܼܠܹ̈ܐ، ");
INSERT INTO aii_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ܘܗܲܡܙܘܼܡܹܐ ܝܗܘܵܘ ܚܲܕ ܥܲܡ ܗ̇ܘ ܐܚܹܪܢܵܐ ܒܘܼܬ ܟܠܵܝܗ‌ܝ ܐܲܢܹܐ ܕܩܘܼܘܸܡ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ܟܲܕ ܐܵܢܝܼ ܗܵܕܟ݂ܵܐ ܗܲܡܙܘܼܡܹܐ ܘܒܲܩܘܼܪܹܐ ܚܲܕ ܡ̣ܢ ܗ̇ܘ ܐܚܹܪܢܵܐ، ܝܼܫܘܿܥ ܒܓܵܢܹܗ ܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣܠܵܝܗ‌ܝ ܘܫܘܼܪܹܐ ܠܹܗ ܒܹܐܙܵܠܵܐ ܥܲܡܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ܐܝܼܢܵܐ ܐܵܢܝܼ ܠܵܐ ܝܕܝܼܥ ܠܗܘܿܢ ܐܸܠܹܗ ܣܵܒܵܒ ܥܲܝ̈ܢܵܝܗ‌ܝ ܕܒ݂ܝܼܩܹܐ ܝܗܘܵܘ ܡ̣ܢ ܠܝܼܕܵܥܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ܘܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ: ”ܡܘܼܕܝܼ ܝܢܵܐ ܐܲܢܹܐ ܗܹܡܸܙܡܵܢܹ̈ܐ ܕܗܲܡܙܘܼܡܹܐ ܝܬܘܿܢ ܚܲܕ ܥܲܡ ܗ̇ܘ ܐܚܹܪܢܵܐ ܟܲܕ ܒܹܐܙܵܠܵܐ؟“ ܘܐܵܢܝܼ ܟܠܹܐ ܠܗܘܿܢ ܦܫܝܼܡܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ܓ̰ܘܼܘܸܒ ܠܹܗ ܚܲܕ ܡܸܢܵܝܗ‌ܝ ܫܸܡܹܗ ܩܲܠܝܘܿܦܵܐ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܐܲܚܟ̰ܝܼ ܐܲܢ݇ܬ ܝܼܘܸܬ ܢܘܼܟ݂ܪܵܝܵܐ ܡ̣ܢ ܐܘܿܪܸܫܠܸܡ ܕܠܹܐ ܝܘܸܬ ܒܝܼܕܵܥܵܐ ܒܘܼܬ ܡܸܢܕܝܼ ܕܗܘܹܐ ܠܹܗ ܓܵܘܘܼܗ̇ ܒܐܲܢܹܐ ܝܵܘܡܵܢܹ̈ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ: ”ܡܘܼܕܝܼ؟“ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܐܸܠܹܗ: ”ܒܘܼܬ ܝܼܫܘܿܥ ܢܵܨܪܵܝܵܐ، ܐܢܵܫܵܐ ܢܒ݂ܝܼܵܐ ܘܚܲܝܠܵܢܵܐ ܒܗܹܡܸܙܡܵܢ ܘܒܦܘܼܠܚܵܢܵܐ ܩܲܕܡ ܐܲܠܵܗܵܐ ܘܩܲܕܡ ܟܠܹܗ ܥܲܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","”ܣܘܼܦܹܐ ܠܗܘܿܢ ܐܸܠܹܗ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܪܹ̈ܝܫܵܢܹܐ ܕܕܝܼܲܢ ܠܕܝܼܘܵܢ ܕܡܵܘܬܵ‌ܐ ܘܡܚܹܐ ܠܗܘܿܢ ܠܙܩܝܼܦܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","”ܐܲܚܢܲܢ ܒܗܹܒ݂ܝܼ ܝܘܲܚ ܗܘܵܘ ܕܗ̇ܘ ܒܸܬ ܦܲܪܸܩ ܗܘܵܐ ܠܐܝܼܣܪܵܐܹܝܠܔ. ܥܲܠܔ ܟܠܹܗ ܐܵܗܵܐ، ܐܸܕܝܘܿܡ ܝܵܘܡܵܐ ܕܬܠܵܬܵ‌ܐ ܝܠܹܗ ܗܵܐ ܡ̣ܢ ܕܐܲܢܹܐ ܗܘܹܐ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","”ܐܘܼܦ ܚܲܕܟܡܵܐ ܡ̣ܢ ܒܲܟ݂ܬܵܬܹ̈‌ܐ ܡܸܢܲܢ ܩܵܡ ܡܲܥܓ̰ܸܒܝܼ ܠܲܢ. ܐܙܝܼܠܔ ܠܗܘܿܢ ܠܩܲܒ݂ܪܵܐ ܩܲܝܕܵܡܬܵ‌ܐ ܓ̰ܲܠܕܹܐ، ");
INSERT INTO aii_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","”ܘܟܲܕ ܠܵܐ ܚܙܹܐ ܠܗܘܿܢ ܠܦܲܓ݂ܪܹܗ، ܐܬܹ‌ܐ ܠܗܘܿܢ ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܲܢ ܕܚܙܹܐ ܠܗܘܿܢ ܡܲܠܲܐܟܹ̈ܐ ܬܵܡܵܐ، ܐܲܝܢܝܼ ܕܐܡܝܼܪܗܘܿܢ ܐܸܠܵܝܗ‌ܝ ܕܚܵܝܵܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","”ܐܘܼܦ ܐܢܵܫܹ̈ܐ ܡܸܢܲܢ ܐܙܝܼܠܔ ܠܗܘܿܢ ܠܒܹܝܬ ܩܒ݂ܘܼܪܵܐ، ܘܡܘܼܫ݇ܟ̰ܸܚ ܠܗܘܿܢ ܗܵܕܟ݂ܵܐ، ܐܲܝܟ݂ ܕܐܡܝܼܪܗܘܿܢ ܒܲܟ݂ܬܵܬܹ̈‌ܐ، ܐܝܼܢܵܐ ܐܸܠܹܗ ܠܵܐ ܚܙܹܐ ܠܗܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ܗ̇ܝܓܵܗ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܝܵܐ ܒܵܨܘܿܪܹ̈ܐ ܕܦܲܪܡܲܝܬܵ‌ܐ، ܘܝܲܩܘܼܪܹ̈ܐ ܒܠܸܒܵܐ ܠܗܲܡܘܼܢܹܐ ܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܗܘܼܡܙܸܡ ܠܗܘܿܢ ܢܒ݂ܝܼܹ̈ܐ، ");
INSERT INTO aii_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","”ܠܹܐ ܝܗܘܵܐ ܐܵܢܲܢܩܵܝܬܵ‌ܐ ܕܩܲܒܸܠܔ ܗܘܵܐ ܚܲܫܵܐ ܡܫܝܼܚܵܐ ܒܐܲܢܹܐ ܘܥܵܒܹܪ ܗܘܵܐ ܠܬܸܫܒܘܿܚܬܹܗ؟“ ");
INSERT INTO aii_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ܘܫܘܼܪܹܐ ܠܹܗ ܡ̣ܢ ܡܘܼܫܹܐ ܘܡ̣ܢ ܟܠܵܝܗ‌ܝ ܢܒ݂ܝܼܹ̈ܐ ܦܲܫܘܼܩܹܐ ܐܸܠܵܝܗ‌ܝ ܟܠܵܝܗ‌ܝ ܟܬܵܒܹ̈ܐ ܒܘܼܬ ܓܵܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ܘܩܘܼܪܒܸܢܗܘܿܢ ܠܡܵܬܵ‌ܐ ܕܒܹܐܙܵܠܵܐ ܝܗܘܵܘ ܐܸܠܘܼܗ̇، ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܡܘܼܚܙܹܐ ܠܹܗ ܐܲܝܟ݂ ܕܐܸܢ ܒܹܐܙܵܠܵܐ ܝܗܘܵܐ ܠܚܕܵܐ ܕܘܼܟܵܐ ܒܘܼܫ ܪܸܚܩܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ܐܝܼܢܵܐ ܐܵܢܝܼ ܡܘܼܠܝܸܨ ܠܗܘܿܢ ܐܸܠܹܗ ܒܹܐܡܵܪܵܐ: ”ܦܘܼܫ ܠܟܸܣܠܲܢ، ܣܵܒܵܒ ܪܲܡܫܵܐ ܩܲܪܒܘܼܢܹܐ ܝܠܹܗ، ܘܝܵܘܡܵܐ ܒܸܓܢܵܝܵܐ ܝܠܹܗ.“ ܘܥܒ݂ܝܼܪܹܗ ܕܦܵܐܹܫ ܗܘܵܐ ܠܟܸܣܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ܘܟܲܕ ܝܬܝܼܒ݂ ܠܗܘܿܢ ܠܣܘܼܦܪܵܐ، ܫܩܝܼܠܔ ܠܹܗ ܠܲܚܡܵܐ ܘܒܘܼܪܸܟ݂ ܠܹܗ ܘܩܨܹܐ ܠܹܗ ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ܒܗ̇ܝ ܥܕܵܢܵܐ ܡܨܹܐ ܠܗܘܿܢ ܚܵܙܝܼ ܝܗܘܵܘ، ܘܝܕܝܼܥ ܠܗܘܿܢ ܐܸܠܹܗ، ܐܝܼܢܵܐ ܗ̇ܘ ܛܠܝܼܩ ܠܹܗ ܡ̣ܢ ܩܲܕܡ ܥܲܝ̈ܢܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ܘܐܡܝܼܪܗܘܿܢ ܚܲܕ ܠܗ̇ܘ ܐܚܹܪܢܵܐ: ”ܠܹܐ ܝܗܘܵܐ ܠܸܒܲܢ ܒܸܩܝܵܕܵܐ ܓܵܘܲܢ، ܟܲܕ ܗܲܡܙܘܼܡܹܐ ܝܗܘܵܐ ܥܲܡܲܢ ܒܐܘܼܪܚܵܐ ܘܦܲܫܘܼܩܹܐ ܟܬܵܒܹ̈ܐ ܐܸܠܲܢ؟“ ");
INSERT INTO aii_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ܩܝܼܡ ܠܗܘܿܢ ܒܗ̇ܝ ܥܕܵܢܵܐ ܘܕܝܼܪܗܘܿܢ ܠܐܘܿܪܸܫܠܸܡ، ܘܚܙܹܐ ܠܗܘܿܢ ܠܚܲܕܸܥܣܲܪ ܬܲܠܡܝܼ̈ܕܹܐ ܘܐܚܹܪ̈ܢܹܐ ܥܲܡܵܝܗ‌ܝ ܓ̰ܡܝܼܥܹܐ ܠܥܘܼܕܵܠܹܐ: ");
INSERT INTO aii_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","”ܘܒܹܐܡܵܪܵܐ، ܫܲܪܝܼܪܵܐܝܼܬ ܡܵܪܲܢ ܩܝܼܡܵܐ ܝܠܹܗ، ܘܦܝܼܫ ܠܹܗ ܚܸܙܝܵܐ ܠܫܸܡܥܘܿܢ ܟܹܐܦܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ܐܘܼܦ ܐܵܢܝܼ ܬܪܹܝ ܗܘܼܩܹܐ ܠܗܘܿܢ ܡܸܢܕܝܼ ܕܗܘܹܐ ܠܹܗ ܒܐܘܼܪܚܵܐ، ܘܕܵܐܟ݂ܝܼ ܝܕܝܼܥ ܠܗܘܿܢ ܐܸܠܹܗ ܐܝܼܡܲܢ ܕܩܨܹܐ ܠܹܗ ܠܲܚܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ܘܟܲܕ ܬܲܠܡܝܼ̈ܕܹܐ ܗܲܡܙܘܼܡܹܐ ܗܵܕܟ݂ܵܐ، ܝܼܫܘܿܥ ܒܓܵܢܹܗ ܟܠܹܐ ܠܹܗ ܓܵܘܵܝܗ‌ܝ ܘܐܡܝܼܪܹܗ: ”ܫܠܵܡܵܐ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܵܢܵܐ ܝܘܸܢ ܠܵܐ ܙܵܕܥܝܼܬܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ܘܐܵܢܝܼ ܚܓ̰ܝܼܠܔ ܠܗܘܿܢ ܘܙܕܝܼܥ ܠܗܘܿܢ، ܒܸܚܫܵܒ݂ܵܐ ܕܪܘܼܚܵܐ ܒܸܚܙܵܝܵܐ ܝܗܘܵܘ. ");
INSERT INTO aii_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܩܵܡܘܿܕܝܼ ܒܸܫܓ݂ܵܫܵܐ ܝܬܘܿܢ، ܘܩܵܡܘܿܕܝܼ ܒܸܥܒ݂ܵܪܵܐ ܝܢܵܐ ܚܘܼܫܵܒܹ̈ܐ ܓܵܘ ܠܸܒܵܘܟ݂ܘܿܢ؟ ");
INSERT INTO aii_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","”ܚܙܹܝܡܘܼܢ ܐܝܼܕܵܬ‌ܝܼ̈ ܘܐܲܩܠܵܬ‌ܝܼ̈ ܕܐܵܢܵܐ ܝܘܸܢ ܒܓܵܢܝܼ. ܕܩܘܿܪܘܼܢ ܒܝܼܝܼ ܘܚܙܹܝܡܘܼܢ، ܣܵܒܵܒ ܪܘܼܚܵܐ ܠܲܝܬ ܠܵܗ̇ ܒܸܣܪܵܐ ܘܓܲܪ̈ܡܹܐ، ܐܲܝܟ݂ ܕܒܸܚܙܵܝܵܐ ܝܬܘܿܢ ܕܐܵܢܵܐ ܐܝܼܬ ܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ܡ̣ܢ ܒܵܬܪ ܕܐܡܝܼܪܹܗ ܗܵܕܟ݂ܵܐ، ܡܘܼܚܙܹܐ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܐܝܼܕܵܬܘܼ̈ܗ‌ܝ ܘܐܲܩܠܵܬܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ܗܸܫ ܐܵܢܝܼ ܠܵܐ ܗܲܡܘܼܢܹܐ ܡ̣ܢ ܚܲܕܘܼܬܵ‌ܐ ܘܥܘܼܓ̰ܵܒܵܐ، ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܐܝܼܬ ܠܵܘܟ݂ܘܿܢ ܠܲܐܟ݂ܵܐ ܡܸܢܕܝܼ ܠܹܐܟ݂ܵܠܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ܘܝܘܼܗܒܹܠܔ ܠܗܘܿܢ ܐܸܠܹܗ ܚܲܕ ܣܵܗܡܵܐ ܡ̣ܢ ܢܘܼܢܵܐ ܛܘܝܼܬܵ‌ܐ ܘܫܵܢܵܐ ܕܕܸܒ݂ܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ܘܫܩܝܼܠܔ ܠܹܗ ܘܐܟ݂ܝܼܠܔ ܠܹܗ ܩܲܕܡ ܥܲܝ̈ܢܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܐܲܢܹܐ ܗܹܡܸܙܡܵܢܹ̈ܐ ܗܘܼܡܙܸܡ ܠܝܼ ܐܸܠܵܘܟ݂ܘܿܢ ܟܲܕ ܥܲܡܵܘܟ݂ܘܿܢ ܝܼܘܸܢ ܗܘܵܐ، ܕܘܵܠܹܐ ܝܗܘܵܐ ܕܦܵܐܹܫ ܬܘܼܡܸܡܵܐ ܟܠܔ ܡܸܢܕܝܼ ܕܟܬܝܼܒ݂ܵܐ ܝܠܹܗ ܒܘܼܬ ܕܝܼܝܼ ܒܢܵܡܘܿܣܵܐ ܕܡܘܼܫܹܐ ܘܒܢܒ݂ܝܼܹ̈ܐ ܘܒܡܲܙܡܘܿܪܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ܗ̇ܝܓܵܗ ܦܬܝܼܚ ܠܹܗ ܠܪܸܥܝܵܢܵܝܗ‌ܝ ܕܦܲܪܡܝܼ ܗܘܵܘ ܠܟܬܵܒܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܗܵܕܟ݂ܵܐ ܟܬܝܼܒ݂ܵܐ ܝܠܹܗ، ܘܵܠܹܐ ܝܗܘܵܐ ܕܡܫܝܼܚܵܐ ܩܲܒܸܠܔ ܗܘܵܐ ܚܲܫܵܐ ܘܒܝܵܘܡܵܐ ܕܬܠܵܬܵ‌ܐ ܩܵܐܹܡ ܗܘܵܐ ܡ̣ܢ ܓܵܘ ܡܝܼ̈ܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","”ܘܒܫܸܡܹܗ ܦܵܝܫܝܼ ܡܘܼܟܪܸܙܹܐ ܬܝܵܒ݂ܘܼܬܵ‌ܐ ܘܦܘܼܚܵܠܵܐ ܕܚܛܝܼܵܬܹ̈‌ܐ ܠܟܠܵܝܗ‌ܝ ܐܸܡܘܵܬܹ̈‌ܐ، ܫܲܪܘܼܝܹܐ ܩܲܕܡܵܝܬܵ‌ܐ ܡ̣ܢ ܐܘܿܪܸܫܠܸܡ. ");
INSERT INTO aii_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","”ܘܐܲܚܬܘܿܢ ܣܵܗܕܹ̈ܐ ܝܬܘܿܢ ܥܲܠܔ ܐܲܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","”ܗܵܐ ܐܵܢܵܐ ܒܸܬ ܫܲܕܪܸܢܵܘܟ݂ܘܿܢ ܡܸܢܕܝܼ ܕܒܵܒܝܼ ܩܘܼܘܸܠܔ ܠܹܗ ܕܒܸܬ ܫܲܕܸܪܵܘܟ݂ܘܿܢ. ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ ܟܠܹܝܡܘܼܢ ܓܵܘ ܡܕܝܼܢ݇ܬܵ‌ܐ ܕܐܘܿܪܸܫܠܸܡ ܗܲܠܔ ܕܩܲܒܠܝܼܬܘܿܢ ܚܲܝܠܵܐ ܡ̣ܢ ܪܵܘܡܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ܦܘܼܠܛܵܝ ܠܹܗ ܥܲܠܔ ܒܹܝܬ ܥܲܢܝܵܐ، ܡܘܼܪܸܡ ܠܹܗ ܐܝܼܕܵܬܘܼ̈ܗ‌ܝ ܘܒܘܼܪܟ݂ܵܝ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ܟܲܕ ܗ̇ܘ ܒܲܪܘܼܟ݂ܵܝ ܝܗܘܵܐ، ܦܪܝܼܫ ܠܹܗ ܡܸܢܵܝܗ‌ܝ ܘܦܝܼܫ ܠܹܗ ܡܘܼܐܣܩܵܐ ܠܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ܘܐܵܢܝܼ ܣܓ݂ܝܼܕ ܠܗܘܿܢ ܐܸܠܹܗ، ܘܕܝܼܪܗܘܿܢ ܠܐܘܿܪܸܫܠܸܡ ܒܚܲܕܘܼܬܵ‌ܐ ܓܘܼܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ܘܐܵܢܝܼ ܒܟܠܔ ܥܕܵܢܵܐ ܓܵܘ ܗܲܝܟܠܵܐ ܝܗܘܵܘ ܫܲܒܘܼܚܹܐ ܘܒܸܚܩܵܪܵܐ ܠܐܲܠܵܗܵܐ. ܐܵܡܹܝܢ.");
INSERT INTO aii_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ܒܪܵܫܝܼܬ ܝܼܗܘܵܐ ܡܸܠܬܵ‌ܐ، ܘܗ̇ܘ ܡܸܠܬܵ‌ܐ ܝܼܗܘܵܐ ܠܟܸܣ ܐܲܠܵܗܵܐ، ܘܐܲܠܵܗܵܐ ܝܗܘܵܐ ܗ̇ܘ ܡܸܠܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ܐܵܗܵܐ ܝܼܗܘܵܐ ܒܪܵܫܝܼܬ ܠܟܸܣ ܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ܟܠܵܝܗ‌ܝ ܡܸܢܕܝܼܵܢܹ̈ܐ ܒܝܲܕ ܕܝܼܹܗ ܗܘܹܐ ܠܗܘܿܢ، ܘܒܠܵܐ ܕܝܼܹܗ ܐܘܼܦ ܚܲܕ ܡܸܢܕܝܼ ܠܵܐ ܗܘܹܐ ܠܹܗ ܡ̣ܢ ܗ̇ܘ ܕܗܘܹܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ܒܝܼܹܗ ܚܲܝܹ̈ܐ ܝܗܘܵܘ، ܘܚܲܝܹ̈ܐ ܒܲܗܪܵܐ ܝܗܘܵܘ ܠܒܢܲܝ̈ܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ܘܒܲܗܪܵܐ ܓܵܘ ܚܸܫܟܵܐ ܟܹܐ ܙܵܪܹܩ، ܘܚܸܫܟܵܐ ܠܹܐ ܓ݂ܵܠܹܒ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ܐܝܼܬ ܗܘܵܐ ܚܲܕ ܐܢܵܫܵܐ ܫܘܼܕܪܵܐ ܡ̣ܢ ܐܲܠܵܗܵܐ، ܫܸܡܹܗ ܝܘܿܚܲܢܵܢ. ");
INSERT INTO aii_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ܐܵܗܵܐ ܐܬܹ‌ܐ ܠܹܗ ܕܝܵܗܒܹܠܔ ܣܵܗܕܘܼܬܵ‌ܐ ܒܘܼܬ ܗ̇ܘ ܒܲܗܪܵܐ، ܗܵܕܟ݂ܵܐ ܕܟܠܔ ܐܢܵܫܵܐ ܗܲܡܸܢ ܒܝܲܕ ܕܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ܗ̇ܘ ܠܹܐ ܝܗܘܵܐ ܗ̇ܘ ܒܲܗܪܵܐ، ܐܝܼܢܵܐ ܐܬܹ‌ܐ ܠܹܗ ܕܝܵܗܒܹܠܔ ܣܵܗܕܘܼܬܵ‌ܐ ܥܲܠܔ ܒܲܗܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ܗ̇ܘ ܒܲܗܪܵܐ ܫܲܪܝܼܪܵܐ ܕܟܹܐ ܒܲܗܪܸܢ ܠܟܠܔ ܐܢܵܫܵܐ، ܒܹܐܬܵܝܵܐ ܝܗܘܵܐ ܠܥܵܠܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ܗ̇ܘ ܓܵܘ ܥܵܠܡܵܐ ܝܗܘܵܐ، ܘܥܵܠܡܵܐ ܒܝܲܕ ܕܝܼܹܗ ܗܘܹܐ ܠܹܗ، ܐܝܼܢܵܐ ܥܵܠܡܵܐ ܠܵܐ ܝܕܝܼܥ ܠܹܗ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ܠܟܸܣ ܕܝܼܹܗ ܐܬܹ‌ܐ ܠܹܗ ܘܥܲܡܵܐ ܕܓܵܢܹܗ ܠܵܐ ܩܘܼܒܸܠܔ ܠܗܘܿܢ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ܐܝܼܢܵܐ ܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܩܘܼܒܸܠܔ ܠܗܘܿܢ ܐܸܠܹܗ، ܘܕܗܘܼܡܸܢܗܘܿܢ ܒܫܸܡܹܗ، ܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܫܘܼܠܛܵܢܵܐ ܕܗܵܘܝܼ ܒܢܘܿܢܹ̈ܐ ܕܐܲܠܵܗܵܐ، ");
INSERT INTO aii_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ܐܵܢܝܼ ܕܠܵܐ ܡ̣ܢ ܕܸܡܵܐ، ܘܠܵܐ ܡ̣ܢ ܨܸܒ݂ܝܵܢܵܐ ܕܦܲܓ݂ܪܵܐ، ܘܠܵܐ ܡ̣ܢ ܨܸܒ݂ܝܵܢܵܐ ܕܓܲܒ݂ܪܵܐ، ܐܸܠܵܐ ܡ̣ܢ ܐܲܠܵܗܵܐ ܦܝܼܫ ܠܗܘܿܢ ܗܘܝܼܹܐ. ");
INSERT INTO aii_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ܘܡܸܠܬܵ‌ܐ ܗܘܹܐ ܠܹܗ ܒܸܣܪܵܐ، ܘܫܪܹܐ ܠܹܗ ܒܓܵܘܲܢ، ܘܚܙܹܐ ܠܲܢ ܚܸܩܪܹܗ، ܚܸܩܪܵܐ ܕܝܼܚܝܼܕܵܝܵܐ ܕܡ̣ܢ ܒܵܒܵܐ، ܡܸܠܝܵܐ ܫܵܦܵܩܲܬ ܘܫܪܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ܝܘܿܚܲܢܵܢ ܣܗܝܼܕ ܠܹܗ ܒܘܼܬ ܕܝܼܹܗ، ܘܡܘܼܩܘܸܚ ܠܹܗ ܒܹܐܡܵܪܵܐ: ”ܐܵܗܵܐ ܝܗܘܵܐ ܗ̇ܘ ܕܐܡܝܼܪܝܼ ܒܘܼܬ ܕܝܼܹܗ ܕܒܹܐܬܵܝܵܐ ܝܠܹܗ ܡ̣ܢ ܒܵܬܪ ܕܝܼܝܼ، ܗ̇ܘ ܕܝܼܠܹܗ ܒܘܼܫ ܓܘܼܪܵܐ ܡܸܢܝܼ، ܣܵܒܵܒ ܝܼܗܘܵܐ ܡ̣ܢ ܩܲܕܡ ܕܝܼܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ܘܡ̣ܢ ܡܸܠܝܘܼܬܹܗ ܐܲܚܢܲܢ ܟܠܲܢ ܫܩܝܼܠܔ ܠܲܢ ܫܵܦܵܩܲܬ ܥܲܠܔ ܫܵܦܵܩܲܬ. ");
INSERT INTO aii_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ܣܵܒܵܒ ܢܵܡܘܿܣܵܐ ܒܝܲܕ ܡܘܼܫܹܐ ܦܝܼܫ ܠܹܗ ܝܘܼܗܒ݂ܵܐ، ܐܝܼܢܵܐ ܫܵܦܵܩܲܬ ܘܫܪܵܪܵܐ ܒܝܲܕ ܝܼܫܘܿܥ ܡܫܝܼܚܵܐ ܦܝܼܫ ܠܗܘܿܢ ܝܘܼܗܒܹܐ. ");
INSERT INTO aii_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ܐܘܼܦ ܚܲܕ ܠܹܐ ܝܠܹܗ ܚܸܙܝܵܐ ܠܐܲܠܵܗܵܐ. ܐܝܼܢܵܐ ܒܪܘܿܢܵܐ ܝܼܚܝܼܕܵܝܵܐ، ܗ̇ܘ ܕܝܼܠܹܗ ܒܥܘܼܒܵܐ ܕܒܵܒܘܼܗ‌ܝ، ܗ̇ܘ ܡܘܼܕܸܥ ܠܹܗ ܒܘܼܬ ܕܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ܐܵܗܵܐ ܝܗܘܵܐ ܣܵܗܕܘܼܬܵ‌ܐ ܕܝܘܿܚܲܢܵܢ، ܐܝܼܡܲܢ ܕܝܗܘܼܕܵܝܹ̈ܐ ܡ̣ܢ ܐܘܿܪܸܫܠܸܡ ܫܘܼܕܸܪܗܘܿܢ ܠܟܸܣܠܹܗ ܟܵܗ̈ܢܹܐ ܘܠܹܘܵܝܹ̈ܐ ܕܒܲܩܪܝܼ ܗܘܵܘ ܠܹܗ: ”ܐܲܢ݇ܬ ܡܵܢܝܼ ܝܘܸܬ؟“ ");
INSERT INTO aii_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ܗ̇ܘ ܡܘܼܕܹܐ ܠܹܗ ܘܠܵܐ ܣܪܝܼܒ݂ ܠܹܗ ܒܹܐܡܵܪܵܐ: ”ܐܵܢܵܐ ܠܹܐ ܝܘܸܢ ܡܫܝܼܚܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ: ”ܒܵܣ ܡܵܢܝܼ ܝܘܸܬ، ܐܹܠܝܼܵܐ ܝܘܸܬ؟“ ܓ̰ܘܼܘܸܒ ܠܹܗ: ”ܠܵܐ، ܠܹܐ ܝܘܸܢ.“ ”ܗ̇ܘ ܢܒ݂ܝܼܵܐ ܝܘܸܬ؟“ ܓ̰ܘܼܘܸܒ ܠܹܗ: ”ܠܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܡܵܢܝܼ ܝܘܸܬ؟ ܐܡܘܿܪ ܐܸܠܲܢ ܕܝܵܗܒܲܚ ܓ̰ܘܼܘܵܒ ܠܐܵܢܝܼ ܕܫܘܼܕܸܪܗܘܿܢ ܐܸܠܲܢ. ܡܘܼܕܝܼ ܒܹܐܡܵܪܵܐ ܝܘܸܬ ܒܘܼܬ ܓܵܢܘܼܟ݂؟“ ");
INSERT INTO aii_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܘܿܚܲܢܵܢ: ”ܐܵܢܵܐ ܩܵܠܵܐ ܝܘܸܢ ܒܸܩܪܵܝܵܐ ܓܵܘ ܒܲܪܝܼܵܐ: ’ܡܲܫܘܹܝܡܘܼܢ ܐܘܼܪܚܵܐ ܕܡܵܪܝܵܐ،‘ ܕܵܐܟ݂ܝܼ ܕܐܡܝܼܪܹܗ ܐܹܫܲܥܝܵܐ ܢܒ݂ܝܼܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ܐܵܢܝܼ ܕܦܝܼܫܹܐ ܝܗܘܵܘ ܫܘܼܕܪܹܐ ܡ̣ܢ ܦܪ̈ܝܼܫܹܐ ܝܗܘܵܘ، ");
INSERT INTO aii_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ܘܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ: ”ܒܵܣ ܩܵܡܘܿܕܝܼ ܡܲܥܡܘܼܕܹܐ ܝܘܸܬ، ܐܸܢ ܠܹܐ ܝܘܸܬ ܡܫܝܼܚܵܐ ܘܠܵܐ ܐܹܠܝܼܵܐ ܘܠܵܐ ܗ̇ܘ ܢܒ݂ܝܼܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܘܿܚܲܢܵܢ: ”ܐܵܢܵܐ ܡܲܥܡܘܼܕܹܐ ܝܘܸܢ ܒܡ̈ܝܼܵܐ، ܐܝܼܢܵܐ ܐܝܼܬ ܟܸܠܝܵܐ ܓܵܘܵܘܟ݂ܘܿܢ ܗ̇ܘ ܕܐܲܚܬܘܿܢ ܠܹܐ ܝܬܘܿܢ ܒܝܼܕܵܥܹܗ، ");
INSERT INTO aii_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","”ܐܵܗܵܐ ܝܠܹܗ ܗ̇ܘ ܕܒܹܐܬܵܝܵܐ ܝܠܹܗ ܡ̣ܢ ܒܵܬܪ ܕܝܼܝܼ، ܗ̇ܘ ܕܐܵܢܵܐ ܠܹܐ ܚܵܫܚܹܢ ܕܫܵܪܹܝܢ ܬܲܣܡܵܬܹ̈‌ܐ ܕܨܵܘܠܘܼ̈ܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ܐܲܢܹܐ ܗܘܹܐ ܠܗܘܿܢ ܓܵܘ ܒܹܝܬ ܥܲܢܝܵܐ، ܒܡܲܪܙܵܐ ܐܚܹܪܢܵܐ ܕܝܘܿܪܕܢܵܢ ܐܲܝܟܵܐ ܕܝܘܿܚܲܢܵܢ ܡܲܥܡܘܼܕܹܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ܘܠܝܵܘܡܵܐ ܕܒܵܬܪܹܗ ܚܙܹܐ ܠܹܗ ܝܘܿܚܲܢܵܢ ܠܝܼܫܘܿܥ ܒܹܐܬܵܝܵܐ ܠܟܸܣܠܹܗ، ܘܐܡܝܼܪܹܗ: ”ܗܵܐ ܦܹܐܪܵܐ ܕܐܲܠܵܗܵܐ، ܗ̇ܘ ܕܫܵܩܹܠܔ ܚܛܝܼܬܵ‌ܐ ܕܥܵܠܡܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","”ܐܵܗܵܐ ܝܠܹܗ ܗ̇ܘ ܕܐܵܢܵܐ ܐܡܝܼܪܝܼ ܒܘܼܬ ܕܝܼܹܗ: ܡ̣ܢ ܒܵܬܪ ܕܝܼܝܼ ܒܹܐܬܵܝܵܐ ܝܠܹܗ ܚܲܕ ܒܘܼܫ ܓܘܼܪܵܐ ܡܸܢܝܼ، ܣܵܒܵܒ ܡ̣ܢ ܩܲܕܡ ܕܝܼܝܼ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","”ܘܐܵܢܵܐ ܠܹܐ ܝܵܕܥܹܢ ܗܘܵܐ ܠܹܗ، ܐܸܠܵܐ ܩܵܐ ܕܦܵܐܹܫ ܗܘܵܐ ܝܕܝܼܥܵܐ ܠܐܝܼܣܪܵܐܹܝܠܔ، ܒܘܼܬ ܗܵܕܵܐ ܐܵܢܵܐ ܐܬܹ‌ܐ ܠܝܼ ܡܲܥܡܘܼܕܹܐ ܒܡ̈ܝܼܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ܝܘܿܚܲܢܵܢ ܣܗܝܼܕ ܠܹܗ، ܒܹܐܡܵܪܵܐ: ”ܚܙܹܐ ܠܝܼ ܪܘܼܚܵܐ ܒܸܨܠܵܝܵܐ ܡ̣ܢ ܫܡܲܝܵܐ ܐܲܝܟ݂ ܝܵܘܢܵܐ ܘܒܸܫܪܵܝܵܐ ܥܲܠܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","”ܘܐܵܢܵܐ ܠܵܐ ܝܕܝܼܥ ܠܝܼ ܐܸܠܹܗ، ܐܸܠܵܐ ܗ̇ܘ ܕܫܘܼܕܪܸܢܹܗ ܕܡܲܥܡܸܕܸܢ ܒܡ̈ܝܼܵܐ ܐܡܝܼܪܹܗ ܐܸܠܝܼ: ’ܠܡ̇ܢ ܕܚܵܙܹܝܬ ܪܘܼܚܵܐ ܒܸܨܠܵܝܵܐ ܘܒܸܫܪܵܝܵܐ ܥܲܠܘܼܗ‌ܝ، ܐܵܗܵܐ ܝܠܹܗ ܗ̇ܘ ܕܡܲܥܡܸܕ ܒܪܘܼܚܵܐ ܕܩܘܼܕܫܵܐ.‘ ");
INSERT INTO aii_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","”ܘܐܵܢܵܐ ܚܙܹܐ ܠܝܼ ܘܒܝܼܵܗܒ݂ܵܐ ܝܘܸܢ ܣܵܗܕܘܼܬܵ‌ܐ ܕܐܵܗܵܐ ܝܠܹܗ ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ܡܸܢܕܪܸܫ ܒܝܵܘܡܵܐ ܐܚܹܪܢܵܐ ܝܘܿܚܲܢܵܢ ܘܬܪܹܝ ܡ̣ܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܟܸܠܝܹܐ ܝܗܘܵܘ ܬܵܡܵܐ، ");
INSERT INTO aii_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ܘܚܝܼܪܹܗ ܒܝܼܫܘܿܥ ܒܸܚܕܵܪܵܐ ܐܡܝܼܪܹܗ: ”ܗܵܐ ܦܹܐܪܵܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܗܘܿܢ ܐܵܢܝܼ ܬܪܹܝ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ، ܐܙܝܼܠܔ ܠܗܘܿܢ ܒܵܬܪ ܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ܕܝܼܪܹܗ ܝܼܫܘܿܥ ܘܚܸܙܝܵܝ ܠܹܗ ܒܹܐܬܵܝܵܐ ܒܵܬܪܹܗ ܘܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ: ”ܡܘܼܕܝܼ ܒܵܥܹܝܬܘܿܢ؟“ ܐܵܢܝܼ ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ: ”ܪܲܒܝܼ (ܕܦܝܵܫܵܐ ܝܠܹܗ ܦܘܼܫܩܵܐ ܡܲܠܦܵܢܵܐ)، ܐܲܝܟܵܐ ܟܹܐ ܦܵܝܫܹܬ؟“ ");
INSERT INTO aii_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ܐܡܝܼܪܹܗ: ”ܬܹܝܡܘܼܢ ܘܚܙܹܝܡܘܼܢ.“ ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܘܚܙܹܐ ܠܗܘܿܢ ܐܲܝܟܵܐ ܦܝܵܫܵܐ ܝܗܘܵܐ، ܘܦܝܼܫ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܒܗ̇ܘ ܝܵܘܡܵܐ، ܘܐܲܝܟ݂ ܣܵܥܲܬ ܕܐܲܪܒܲܥ ܝܗܘܵܐ ܡ̣ܢ ܒܵܬܪ ܟܵܘܸܬܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ܚܲܕ ܡ̣ܢ ܐܵܢܝܼ ܬܪܹܝ ܕܫܡܝܼܥ ܠܗܘܿܢ ܡ̣ܢ ܝܘܿܚܲܢܵܢ ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܒܵܬܪ ܝܼܫܘܿܥ، ܐܲܢܕܪܹܐܘܿܣ ܝܼܗܘܵܐ، ܐܲܚܘܿܢܵܐ ܕܫܸܡܥܘܿܢ ܟܹܐܦܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ܐܵܗܵܐ ܡܘܼܫ݇ܟ̰ܸܚ ܠܹܗ ܩܲܕܡܵܝܬܵ‌ܐ ܠܫܸܡܥܘܿܢ ܐܲܚܘܿܢܘܼܗ‌ܝ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܡܘܼܫ݇ܟ̰ܸܚ ܠܲܢ ܠܡܫܝܼܚܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ܘܡܘܼܝܬܹ‌ܐ ܠܹܗ ܠܫܸܡܥܘܿܢ ܠܟܸܣ ܝܼܫܘܿܥ. ܚܝܼܪܹܗ ܒܝܼܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ: ”ܐܲܢ݇ܬ ܝܼܘܸܬ ܫܸܡܥܘܿܢ ܒܪܘܿܢܵܐ ܕܝܵܘܢܵܐ، ܐܲܢ݇ܬ ܒܸܬ ܦܵܝܫܹܬ ܩܸܪܝܵܐ ܟܹܐܦܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ܒܝܵܘܡܵܐ ܐܚܹܪܢܵܐ ܒܥܹܐ ܠܹܗ ܝܼܫܘܿܥ ܕܐܵܙܹܠܔ ܠܓܠܝܼܠܵܐ. ܡܘܼܫ݇ܟ̰ܸܚ ܠܹܗ ܠܦܝܼܠܝܼܦܘܿܣ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܬܵ‌ܐ ܒܵܬܪܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ܦܝܼܠܝܼܦܘܿܣ ܡ̣ܢ ܒܹܝܬ ܨܲܝܵܕܵܐ ܝܗܘܵܐ، ܡܕܝܼܢ݇ܬܵ‌ܐ ܕܐܲܢܕܪܹܐܘܿܣ ܘܫܸܡܥܘܿܢ ܟܹܐܦܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ܦܝܼܠܝܼܦܘܿܣ ܡܘܼܫ݇ܟ̰ܸܚ ܠܹܗ ܠܢܵܬܢܝܼܐܹܝܠܔ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܡܘܼܫ݇ܟ̰ܸܚ ܠܲܢ ܠܗ̇ܘ ܕܡܘܼܫܹܐ ܟܬܝܼܒ݂ ܠܹܗ ܒܘܼܬ ܕܝܼܹܗ ܒܢܵܡܘܿܣܵܐ، ܘܐܘܼܦ ܢܒ݂ܝܼܹ̈ܐ ܟܬܝܼܒ݂ ܠܗܘܿܢ ܒܘܼܬ ܕܝܼܹܗ، ܕܝܼܠܹܗ ܝܼܫܘܿܥ ܒܪܘܿܢܵܐ ܕܝܵܘܣܸܦ، ܡ̣ܢ ܢܵܨܪܲܬ.“ ");
INSERT INTO aii_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ܒܘܼܩܸܪܹܗ ܢܵܬܢܝܼܐܹܝܠܔ: ”ܟܹܐ ܗܵܘܝܵܐ ܕܡ̣ܢ ܢܵܨܪܲܬ ܦܵܠܹܛ ܡܸܢܕܝܼ ܛܵܒ݂ܵܐ؟“ ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܦܝܼܠܝܼܦܘܿܣ: ”ܬܵ‌ܐ ܘܚܙܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܹܗ ܝܼܫܘܿܥ ܠܢܵܬܢܝܼܐܹܝܠܔ ܒܹܐܬܵܝܵܐ ܠܟܸܣܠܹܗ، ܐܡܝܼܪܹܗ ܒܘܼܬ ܕܝܼܹܗ: ”ܗܵܐ، ܫܲܪܝܼܪܵܐܝܼܬ ܒܪܘܿܢܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ ܕܠܲܝܬ ܦܸܠܡܵܐ ܒܝܼܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ܒܘܼܩܸܪܹܗ ܡܸܢܹܗ ܢܵܬܢܝܼܐܹܝܠܔ: ”ܡ̣ܢ ܐܲܝܟܵܐ ܟܹܐ ܝܵܕܥܹܬ ܠܝܼ؟“ ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܡ̣ܢ ܩܲܕܡ ܕܩܵܪܹܐ ܗܘܵܐ ܠܘܼܟ݂ ܦܝܼܠܝܼܦܘܿܣ، ܟܲܕ ܬܚܘܿܬ ܐܝܼܠܵܢܵܐ ܕܬܹܐܢܹ̈ܐ، ܩܵܡ ܚܵܙܹܢܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ ܢܵܬܢܝܼܐܹܝܠܔ: ”ܪܲܒܝܼ، ܐܲܢ݇ܬ ܝܼܘܸܬ ܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ، ܐܲܢ݇ܬ ܝܼܘܸܬ ܡܲܠܟܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ.“ ");
INSERT INTO aii_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܣܵܒܵܒ ܐܡܝܼܪܝܼ ܐܸܠܘܼܟ݂ ܕܩܵܡ ܚܵܙܹܢܘܼܟ݂ ܬܚܘܿܬ ܐܝܼܠܵܢܵܐ ܕܬܹܐܢܹ̈ܐ، ܗܲܡܘܼܢܹܐ ܝܘܸܬ؟ ܒܸܬ ܚܵܙܹܝܬ ܡܸܢܕܝܼܵܢܹ̈ܐ ܒܘܼܫ ܓܘܼܪܹ̈ܐ ܡ̣ܢ ܐܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܬܪܘܼܨܵܐ، ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܡ̣ܢ ܐܵܕܝܼܵܐ ܒܸܬ ܚܵܙܹܝܬܘܿܢ ܫܡܲܝܵܐ ܦܬܝܼܚܬܵ‌ܐ ܘܡܲܠܲܐܟܹ̈ܐ ܕܐܲܠܵܗܵܐ ܒܹܐܣܵܩܵܐ ܘܒܸܨܠܵܝܵܐ ܠܟܸܣ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ܒܝܵܘܡܵܐ ܕܬܠܵܬܵ‌ܐ ܗܘܹܐ ܠܹܗ ܚܠܘܼܠܵܐ ܓܵܘ ܩܵܛܢܹܐ ܕܓܠܝܼܠܵܐ. ܝܸܡܵܐ ܕܝܼܫܘܿܥ ܬܵܡܵܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ܐܘܼܦ ܝܼܫܘܿܥ ܘܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܦܝܼܫܹܐ ܝܗܘܵܘ ܟ̰ܝܼܕܹܐ ܠܚܠܘܼܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ܐܝܼܡܲܢ ܕܦܪܝܼܩ ܠܹܗ ܚܲܡܪܵܐ، ܝܸܡܵܐ ܕܝܼܫܘܿܥ ܐܡܝܼܪܵܗ̇ ܐܸܠܹܗ: ”ܠܲܝܬ ܠܗܘܿܢ ܚܲܡܪܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇ ܝܼܫܘܿܥ: ”ܡܵܐ ܠܵܟ݂ܝ ܡܸܢܝܼ ܒܲܟ݂ܬܵ‌ܐ؟ ܗܸܫ ܠܹܐ ܝܠܵܗ̇ ܐܬܝܼܬܵ‌ܐ ܣܵܥܲܬ‌ܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ܘܗ̇ܝ ܐܡܝܼܪܵܗ̇ ܠܪܹ̈ܓܵܘܵܬܹ‌ܐ: ”ܥܒ݂ܘܿܕܘܼܢ ܟܠܔ ܡܸܢܕܝܼ ܕܐܵܡܹܪ ܐܸܠܵܘܟ݂ܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ܘܐܝܼܬ ܗܘܵܘ ܬܵܡܵܐ ܫܬܵ‌ܐ ܚܵܘܕܹ̈ܐ ܕܟܹܐܦܵܐ، ܡܘܼܬܒܹܐ ܩܵܐ ܕܲܟܲܝܬܵ‌ܐ ܕܝܗܘܼܕܵܝܹ̈ܐ، ܘܟܠܔ ܚܲܕ ܕܵܒܹܩ ܗܘܵܐ ܬܪܹܝ ܝܲܢ ܬܠܵܬܵ‌ܐ ܓܘܼܕܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܠܥܵܒ݂ܕܵܢܹ̈ܐ ܕܚܸܠܡܲܬ: ”ܡܠܹܝܡܘܼܢ ܠܗܘܿܢ ܐܲܢܹܐ ܚܵܘܕܹ̈ܐ ܡ̈ܝܼܵܐ.“ ܘܡܸܠܝܵܝ ܠܗܘܿܢ ܗܲܠܔ ܦܘܼܡܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܐܵܕܝܼܵܐ ܕܪܹܝܡܘܼܢ ܘܗܲܒ݂ܠܘܼܢ ܠܓܘܼܪܵܐ ܕܡܸܫܬܘܼܬܵ‌ܐ.“ ܘܕܪܹܐ ܠܗܘܿܢ ܘܝܘܼܗܒܹܠܔ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ܘܛܥܝܼܡ ܠܹܗ ܓܘܼܪܵܐ ܕܡܸܫܬܘܼܬܵ‌ܐ ܡ̈ܝܼܵܐ ܕܗܘܹܐ ܠܗܘܿܢ ܚܲܡܪܵܐ، ܐܝܼܢܵܐ ܠܵܐ ܝܕܝܼܥ ܠܹܗ ܡ̣ܢ ܐܲܝܟܵܐ ܝܗܘܵܐ. ܪܹ̈ܓܵܘܵܬܹ‌ܐ ܟܹܐ ܝܵܕܥܝܼ ܗܘܵܘ، ܣܵܒܵܒ ܐܵܢܝܼ ܝܗܘܵܘ ܡܸܠܝܵܝ ܚܵܘܕܹ̈ܐ ܡ̈ܝܼܵܐ. ܗ̇ܝܓܵܗ ܩܪܹܐ ܠܹܗ ܓܘܼܪܵܐ ܕܡܸܫܬܘܼܬܵ‌ܐ ܠܚܸܬܢܵܐ، ");
INSERT INTO aii_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܟܠܔ ܐܢܵܫܵܐ ܟܹܐ ܡܲܚܕܸܪ ܚܲܡܪܵܐ ܨܦܵܝܝܼ ܩܲܕܡܵܝܬܵ‌ܐ، ܘܐܝܼܡܲܢ ܕܪܘܹܐ ܠܗܘܿܢ ܐܢܵܫܹ̈ܐ، ܟܹܐ ܡܲܚܕܸܪ ܚܲܡܪܵܐ ܠܵܐ ܨܦܵܝܝܼ. ܐܝܼܢܵܐ ܐܲܢ݇ܬ ܫܒ݂ܝܼܩ ܠܘܼܟ݂ ܚܲܡܪܵܐ ܨܦܵܝܝܼ ܗܲܠܔ ܐܵܕܝܼܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ܐܵܗܵܐ ܝܗܘܵܐ ܗ̇ܘ ܢܝܼܫܲܢܩܵܐ ܩܲܕܡܵܝܵܐ ܕܥܒ݂ܝܼܕ ܠܹܗ ܝܼܫܘܿܥ ܓܵܘ ܩܵܛܢܹܐ ܕܓܠܝܼܠܵܐ، ܘܡܘܼܕܸܥ ܠܹܗ ܚܸܩܪܹܗ، ܘܗܘܼܡܸܢܗܘܿܢ ܒܝܼܹܗ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ܡ̣ܢ ܒܵܬܪ ܐܵܗܵܐ ܨܠܹܐ ܠܹܗ ܝܼܫܘܿܥ ܠܟܦܲܪܢܵܚܘܿܡ، ܗ̇ܘ ܘܝܸܡܹܗ ܘܐܲܚܘܿܢܘܵܬܘܼ̈ܗ‌ܝ ܘܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ. ܘܦܝܼܫ ܠܗܘܿܢ ܬܵܡܵܐ ܚܲܕܟܡܵܐ ܝܵܘܡܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ܘܐܝܼܡܲܢ ܕܩܲܪܒܘܼܢܹܐ ܝܗܘܵܐ ܦܸܨܚܵܐ ܕܝܗܘܼܕܵܝܹ̈ܐ، ܐܣܝܼܩ ܠܹܗ ܝܼܫܘܿܥ ܠܐܘܿܪܸܫܠܸܡ. ");
INSERT INTO aii_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ܓܵܘ ܗܲܝܟܠܵܐ ܚܙܹܐ ܠܹܗ ܐܢܵܫܹ̈ܐ ܙܲܒܘܼܢܹܐ ܬܵܘܪܹ̈ܐ ܘܥܸܪ̈ܒܹܐ ܘܝܵܘܢܹ̈ܐ، ܘܨܲܪ̈ܵܦܹܐ ܝܬܝܼܒܹܐ ܨܲܪܘܼܦܹܐ ܙܘܼܙܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ܬܘܼܪܸܨ ܠܹܗ ܩܲܡܟ̰ܝܼ ܡ̣ܢ ܚܲܒ݂ܠܵܐ، ܘܦܘܼܠܸܛ ܠܹܗ ܠܟܠܵܝܗ‌ܝ ܡ̣ܢ ܗܲܝܟܠܵܐ، ܘܠܥܸܪ̈ܒܹܐ ܘܠܬܵܘܪܹ̈ܐ، ܘܒܘܼܪܒܸܙ ܠܹܗ ܙܘܼܙܹ̈ܐ ܕܨܲܪ̈ܵܦܹܐ، ܘܡܘܼܚܕܸܪܹܗ ܦܵܬܘܿܪ̈ܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ܘܐܡܝܼܪܹܗ ܠܐܵܢܝܼ ܕܙܲܒܘܼܢܹܐ ܝܗܘܵܘ ܝܵܘܢܹ̈ܐ: ”ܫܩܘܿܠܘܼܢ ܐܲܢܹܐ ܡܐܲܟ݂ܵܐ، ܘܠܵܐ ܥܵܒ݂ܕܝܼܬܘܿܢ ܠܹܗ ܒܲܝܬܵ‌ܐ ܕܒܵܒܝܼ ܫܘܼܩܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ܘܕܟ݂ܝܼܪܗܘܿܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܕܟܬܝܼܒ݂ܵܐ ܝܠܹܗ: ”ܛܢܵܢܵܐ ܕܒܲܝܬܘܼܟ݂ ܩܵܡ ܐܵܟܹܠܔ ܠܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ ܝܗܘܼܕܵܝܹ̈ܐ: ”ܡܘܼܕܝܼ ܢܝܼܫܲܢܩܵܐ ܒܸܬ ܡܲܚܙܹܝܬ ܠܲܢ ܕܐܝܼܬ ܠܘܼܟ݂ ܫܘܼܠܛܵܢܵܐ ܠܸܥܒ݂ܵܕܵܐ ܐܲܢܹܐ؟“ ");
INSERT INTO aii_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܣܬܘܿܪܘܼܢ ܠܹܗ ܐܵܗܵܐ ܗܲܝܟܠܵܐ، ܘܐܵܢܵܐ ܒܸܬ ܡܲܩܸܡܸܢܹܗ ܒܬܠܵܬܵ‌ܐ ܝܵܘܡܵܢܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܐܸܠܹܗ ܝܗܘܼܕܵܝܹ̈ܐ: ”ܒܐܲܪܒܥܝܼ ܘܐܸܫܸܬ ܫܸܢܹ̈ܐ ܦܝܼܫ ܠܹܗ ܒܸܢܝܵܐ ܐܵܗܵܐ ܗܲܝܟܠܵܐ، ܘܐܲܢ݇ܬ ܒܸܬ ܒܡܲܩܸܡܸܬ ܠܹܗ ܒܬܠܵܬܵ‌ܐ ܝܵܘܡܵܢܹ̈ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ܐܝܼܢܵܐ ܗ̇ܘ ܗܲܡܙܘܼܡܹܐ ܝܗܘܵܐ ܒܘܼܬ ܗܲܝܟܠܵܐ ܕܦܲܓ݂ܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ܡ̣ܢ ܒܵܬܪ ܕܩܝܼܡ ܠܹܗ ܡ̣ܢ ܓܵܘ ܡܝܼ̈ܬܹ‌ܐ، ܕܟ݂ܝܼܪܗܘܿܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܕܡܘܼܕܝܼ ܝܗܘܵܐ ܐܡܝܼܪܵܐ. ܗ̇ܝܓܵܗ ܗܘܼܡܸܢܗܘܿܢ ܒܟܬܵܒܹ̈ܐ ܘܒܗܹܡܸܙܡܵܢ ܕܐܡܝܼܪܵܐ ܝܗܘܵܐ ܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ܟܲܕ ܝܼܫܘܿܥ ܓܵܘ ܐܘܿܪܸܫܠܸܡ ܝܼܗܘܵܐ ܒܥܹܐܕܵܐ ܕܦܸܨܚܵܐ، ܪܵܒܵܐ ܐܢܵܫܹ̈ܐ ܚܙܹܐ ܠܗܘܿܢ ܢܝܼܫܲܢܩܹ̈ܐ ܕܒܸܥܒ݂ܵܕܵܐ ܝܗܘܵܐ ܘܗܘܼܡܸܢܗܘܿܢ ܒܫܸܡܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܠܵܐ ܕܸܪܝܵܐ ܠܹܗ ܗܹܒ݂ܝܼܹܗ ܥܲܠܵܝܗ‌ܝ ܣܵܒܵܒ ܟܹܐ ܝܵܕܹܥ ܗܘܵܐ ܠܟܠܔ ܐܢܵܫܵܐ، ");
INSERT INTO aii_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ܘܠܹܐ ܝܗܘܵܐ ܣܢܝܼܩܵܐ ܠܐܢܵܫܵܐ ܕܝܵܗܒܹܠܔ ܠܹܗ ܣܵܗܕܘܼܬܵ‌ܐ ܒܘܼܬ ܒܲܪܢܵܫܵܐ، ܣܵܒܵܒ ܟܹܐ ܝܵܕܹܥ ܗܘܵܐ ܡܘܼܕܝܼ ܐܝܼܬ ܒܒܲܪܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ܐܝܼܬ ܗܘܵܐ ܚܲܕ ܐܢܵܫܵܐ ܡ̣ܢ ܦܪ̈ܝܼܫܹܐ ܫܸܡܹܗ ܢܝܼܩܵܕܹܡܘܿܣ، ܓܘܼܪܵܐ ܕܝܗܘܼܕܵܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ܐܵܗܵܐ ܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣ ܝܼܫܘܿܥ ܒܠܲܝܠܹܐ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܪܲܒܝܼ، ܒܝܼܕܵܥܵܐ ܝܘܲܚ ܕܡ̣ܢ ܐܲܠܵܗܵܐ ܐܬܝܼܵܐ ܝܘܸܬ ܡܲܠܦܵܢܵܐ، ܣܵܒܵܒ ܐܘܼܦ ܚܲܕ ܐܢܵܫܵܐ ܠܹܐ ܡܵܨܹܐ ܥܵܒܹܕ ܐܲܢܹܐ ܢܝܼܫܲܢܩܹ̈ܐ ܕܐܲܢ݇ܬ ܒܸܥܒ݂ܵܕܵܝ ܝܘܸܬ، ܐܸܢ ܐܲܠܵܗܵܐ ܠܵܐ ܗܵܘܹܐ ܥܲܡܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܬܪܘܼܨܵܐ، ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܘܼܟ݂، ܐܸܢ ܐܢܵܫܵܐ ܠܵܐ ܦܵܐܹܫ ܝܠܝܼܕܵܐ ܓܵܗܵܐ ܕܬܲܪܬܹܝ ܠܹܐ ܡܵܨܹܐ ܚܵܙܹܐ ܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܢܝܼܩܵܕܹܡܘܿܣ: ”ܕܵܐܟ݂ܝܼ ܡܵܨܹܐ ܐܢܵܫܵܐ ܦܵܐܹܫ ܝܠܝܼܕܵܐ ܟܲܕ ܣܵܒ݂ܵܐ ܝܠܹܗ؟ ܡܵܨܹܐ ܓܵܗܵܐ ܕܬܲܪܬܹܝ ܥܵܒܹܪ ܓܵܘ ܟܹܪ݇ܣܵܐ ܕܝܸܡܹܗ ܘܦܵܐܹܫ ܝܠܝܼܕܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܬܪܘܼܨܵܐ، ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܘܼܟ݂، ܐܸܢ ܐܢܵܫܵܐ ܠܵܐ ܦܵܐܹܫ ܝܠܝܼܕܵܐ ܡ̣ܢ ܡ̈ܝܼܵܐ ܘܪܘܼܚܵܐ، ܠܹܐ ܡܵܨܹܐ ܥܵܒܹܪ ܠܡܲܠܟܘܼܬܵ‌ܐ ܕܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","”ܗ̇ܘ ܕܝܼܠܹܗ ܝܠܝܼܕܵܐ ܡ̣ܢ ܒܸܣܪܵܐ، ܒܸܣܪܵܐ ܝܠܹܗ، ܘܗ̇ܘ ܕܝܼܠܹܗ ܗܘܝܼܵܐ ܡ̣ܢ ܪܘܼܚܵܐ، ܪܘܼܚܵܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","”ܠܵܐ ܥܲܓ̰ܒܸܬ ܕܐܡܝܼܪܝܼ ܐܸܠܘܼܟ݂ ܕܘܵܠܹܐ ܝܠܵܗ̇ ܕܦܵܝܫܝܼܬܘܿܢ ܝܠܝܼܕܹܐ ܓܵܗܵܐ ܕܬܲܪܬܹܝ. ");
INSERT INTO aii_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","”ܦܵܘܚܵܐ ܟܹܐ ܡܵܚܹܐ ܒܗ̇ܝ ܕܘܼܟܵܐ ܕܒܵܣܡܵܐ ܠܹܗ. ܟܹܐ ܫܵܡܥܹܬ ܩܵܠܹܗ، ܐܝܼܢܵܐ ܠܹܐ ܝܵܕܥܹܬ ܡ̣ܢ ܐܲܝܟܵܐ ܒܹܐܬܵܝܵܐ ܝܠܹܗ ܘܠܐܲܝܟܵܐ ܒܹܐܙܵܠܵܐ ܝܠܹܗ. ܗܵܕܟ݂ܵܐ ܝܠܹܗ ܟܠܔ ܡ̇ܢ ܕܝܼܠܹܗ ܝܠܝܼܕܵܐ ܡ̣ܢ ܪܘܼܚܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ܓ̰ܘܼܘܸܒ ܠܹܗ ܢܝܼܩܵܕܹܡܘܿܣ ܘܐܡܝܼܪܹܗ: ”ܕܵܐܟ݂ܝܼ ܡܵܨܝܼ ܐܲܢܹܐ ܗܵܘܝܼ؟“ ");
INSERT INTO aii_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܐܲܢ݇ܬ ܕܝܼܘܸܬ ܡܲܠܦܵܢܵܐ ܕܐܝܼܣܪܵܐܹܝܠܔ، ܘܠܹܐ ܝܘܸܬ ܒܝܼܕܵܥܵܐ ܐܲܢܹܐ؟ ");
INSERT INTO aii_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","”ܬܪܘܼܨܵܐ، ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܘܼܟ݂، ܡܸܢܕܝܼ ܕܒܝܼܕܵܥܵܐ ܝܘܲܚ ܗܲܡܙܘܼܡܹܐ ܝܘܲܚ، ܘܡܸܢܕܝܼ ܕܚܸܙܝܵܐ ܝܘܲܚ ܒܝܼܵܗܒ݂ܵܐ ܝܘܲܚ ܣܵܗܕܘܼܬܵ‌ܐ ܒܘܼܬ ܕܝܼܹܗ، ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ ܠܹܐ ܝܬܘܿܢ ܩܲܒܘܼܠܘܼܗ̇ ܣܵܗܕܘܼܬܲܢ. ");
INSERT INTO aii_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","”ܐܸܢ ܡܸܢܕܝܼܵܢܹ̈ܐ ܐܲܪ̈ܥܵܢܵܝܹܐ ܐܡܝܼܪܝܼ ܐܸܠܵܘܟ݂ܘܿܢ ܘܠܹܐ ܝܬܘܿܢ ܗܲܡܘܼܢܹܐ، ܕܵܐܟ݂ܝܼ ܒܸܬ ܗܲܡܸܢܝܼܬܘܿܢ ܐܸܢ ܐܵܡܪܹܢ ܐܸܠܵܘܟ݂ܘܿܢ ܡܸܢܕܝܼܵܢܹ̈ܐ ܫܡܲܝܵܢܵܝܹ̈ܐ؟ ");
INSERT INTO aii_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","”ܐܘܼܦ ܚܲܕ ܠܹܐ ܝܠܹܗ ܐܣܝܼܩܵܐ ܠܫܡܲܝܵܐ ܫܒ݂ܘܿܩ ܡ̣ܢ ܗ̇ܘ ܕܨܠܹܐ ܠܹܗ ܡ̣ܢ ܫܡܲܝܵܐ، ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܕܝܼܠܹܗ ܓܵܘ ܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","”ܘܕܵܐܟ݂ܝܼ ܕܡܘܼܪܸܡ ܠܹܗ ܡܘܼܫܹܐ ܚܘܼܘܹܐ ܓܵܘ ܒܲܪܝܼܵܐ، ܗܵܕܟ݂ܵܐ ܘܵܠܹܐ ܝܠܵܗ̇ ܕܦܵܐܹܫ ܡܘܼܪܡܵܐ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ، ");
INSERT INTO aii_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","”ܕܟܠܔ ܡ̇ܢ ܕܗܲܡܸܢ ܒܝܼܹܗ ܗܵܘܹܐ ܠܹܗ ܚܲܝܹ̈ܐ ܕܠܥܵܠܲܡ.“ ");
INSERT INTO aii_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ܣܵܒܵܒ ܗܵܕܟ݂ܵܐ ܡܘܼܚܸܒ ܠܹܗ ܐܲܠܵܗܵܐ ܠܥܵܠܡܵܐ ܕܵܐܟ݂ܝܼ ܕܝܘܼܗܒܹܠܔ ܠܹܗ ܠܒܪܘܿܢܹܗ ܝܼܚܝܼܕܵܝܵܐ، ܕܟܠܔ ܡ̇ܢ ܕܗܲܡܸܢ ܒܝܼܹܗ ܠܵܐ ܛܵܠܹܩ، ܐܸܠܵܐ ܗܵܘܹܐ ܠܹܗ ܚܲܝܹ̈ܐ ܕܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ܣܵܒܵܒ ܠܵܐ ܫܘܼܕܸܪܹܗ ܐܲܠܵܗܵܐ ܠܒܪܘܿܢܹܗ ܠܥܵܠܡܵܐ ܕܕܵܐܹܢ ܠܥܵܠܡܵܐ، ܐܸܠܵܐ ܕܦܵܪܹܩ ܥܵܠܡܵܐ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ܡ̇ܢ ܕܗܲܡܸܢ ܒܝܼܹܗ ܠܹܐ ܦܵܐܹܫ ܕܝܼܢܵܐ، ܘܡ̇ܢ ܕܠܵܐ ܗܲܡܸܢ ܡ̣ܢ ܓ̰ܲܠܕܹܐ ܦܝܼܫܵܐ ܝܠܹܗ ܕܝܼܢܵܐ، ܣܵܒܵܒ ܠܵܐ ܗܘܼܡܸܢܹܗ ܒܫܸܡܵܐ ܕܒܪܘܿܢܵܐ ܝܼܚܝܼܕܵܝܵܐ ܕܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ܘܐܵܗܵܐ ܝܠܵܗ̇ ܕܝܵܢܬܵ‌ܐ، ܕܒܲܗܪܵܐ ܐܬܹ‌ܐ ܠܹܗ ܠܥܵܠܡܵܐ، ܐܝܼܢܵܐ ܐܢܵܫܹ̈ܐ ܡܘܼܚܸܒ ܠܗܘܿܢ ܠܚܸܫܟܵܐ ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܒܲܗܪܵܐ ܣܵܒܵܒ ܦܘܼܠܚܵܢܵܝ̈ܗ‌ܝ ܒܝܼܫܹ̈ܐ ܝܗܘܵܘ. ");
INSERT INTO aii_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ܟܠܔ ܕܥܵܒܹܕ ܒܝܼܫܵܬܹ̈‌ܐ ܟܹܐ ܣܵܢܹܐ ܠܒܲܗܪܵܐ، ܘܠܹܐ ܐܵܬܹ‌ܐ ܠܟܸܣ ܒܲܗܪܵܐ ܕܠܵܐ ܦܵܝܫܝܼ ܓܸܠܝܹܐ ܦܘܼܠܚܵܢܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ܐܝܼܢܵܐ ܟܠܔ ܕܥܵܒܹܕ ܫܪܵܪܵܐ، ܟܹܐ ܐܵܬܹ‌ܐ ܠܟܸܣ ܒܲܗܪܵܐ ܕܦܵܝܫܝܼ ܝܕܝܼܥܹܐ ܦܘܼܠܚܵܢܘܼ̈ܗ‌ܝ ܕܒܐܲܠܵܗܵܐ ܝܢܵܐ ܥܒ݂ܝܼܕܹܐ. ");
INSERT INTO aii_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ܡ̣ܢ ܒܵܬܪ ܐܲܢܹܐ ܐܬܹ‌ܐ ܠܹܗ ܝܼܫܘܿܥ ܥܲܡ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܠܐܲܪܥܵܐ ܕܝܼܗܘܼܕ، ܘܦܝܼܫ ܠܹܗ ܬܵܡܵܐ ܥܲܡܵܝܗ‌ܝ ܘܡܲܥܡܸܕ ܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ܐܘܼܦ ܝܘܿܚܲܢܵܢ ܡܲܥܡܸܕ ܗܘܵܐ ܓܵܘ ܥܹܝܢ ܝܘܿܢ ܩܘܼܪܒܵܐ ܠܫܵܠܝܼܡ، ܣܵܒܵܒ ܐܝܼܬ ܗܘܵܐ ܡ̈ܝܼܵܐ ܪܵܒܵܐ ܬܵܡܵܐ، ܘܐܵܬ‌ܝܼ ܗܘܵܘ ܐܢܵܫܹ̈ܐ ܘܦܵܝܫܝܼ ܗܘܵܘ ܥܡܝܼܕܹܐ، ");
INSERT INTO aii_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ܣܵܒܵܒ ܗܸܫ ܝܘܿܚܲܢܵܢ ܠܹܐ ܝܗܘܵܐ ܦܝܼܫܵܐ ܕܸܪܝܵܐ ܓܵܘ ܒܹܝܬ ܐܲܣܝܼܪܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ܗܘܹܐ ܠܹܗ ܕܘܼܪܵܫܵܐ ܒܹܝܠܔ ܬܲܠܡܝܼ̈ܕܹܐ ܕܝܘܿܚܲܢܵܢ ܘܚܲܕ ܝܗܘܼܕܵܝܵܐ ܒܘܼܬ ܕܲܟܲܝܬܵ‌ܐ ܒܡ̈ܝܼܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣ ܝܘܿܚܲܢܵܢ ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܪܲܒܝܼܲܢ، ܗ̇ܘ ܕܝܼܗܘܵܐ ܥܲܡܘܼܟ݂ ܒܡܲܪܙܵܐ ܐܚܹܪܢܵܐ ܕܝܘܿܪܕܢܵܢ، ܗ̇ܘ ܕܝܘܼܗܒܹܠܔ ܠܘܼܟ݂ ܣܵܗܕܘܼܬܵ‌ܐ ܒܘܼܬ ܕܝܼܹܗ، ܐܘܼܦ ܗ̇ܘ ܡܲܥܡܘܼܕܹܐ ܝܠܹܗ، ܘܪܵܒܵܐ ܒܹܐܙܵܠܵܐ ܝܢܵܐ ܠܟܸܣܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܘܿܚܲܢܵܢ: ”ܠܹܐ ܡܵܨܹܐ ܐܢܵܫܵܐ ܫܵܩܹܠܔ ܡܸܢܕܝܼ، ܐܸܢ ܠܵܐ ܦܵܐܹܫ ܝܘܼܗܒ݂ܵܐ ܐܸܠܹܗ ܡ̣ܢ ܫܡܲܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","”ܐܲܚܬܘܿܢ ܣܵܗܕܹ̈ܐ ܝܬܘܿܢ ܕܐܵܢܵܐ ܐܡܝܼܪܝܼ: ’ܠܹܐ ܝܘܸܢ ܐܵܢܵܐ ܡܫܝܼܚܵܐ، ܐܸܠܵܐ ܕܦܝܼܫܵܐ ܝܘܸܢ ܫܘܼܕܪܵܐ ܡ̣ܢ ܩܲܕܡ ܕܝܼܹܗ.‘ ");
INSERT INTO aii_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","”ܡ̇ܢ ܕܐܝܼܬ ܠܹܗ ܟܵܠܬܵ‌ܐ ܚܸܬܢܵܐ ܝܠܹܗ، ܘܪܵܚܡܵܐ ܕܚܸܬܢܵܐ، ܗ̇ܘ ܕܟܵܠܹܐ ܘܡܲܨܝܸܬ ܐܸܠܹܗ، ܟܹܐ ܚܵܕܹܐ ܚܲܕܘܼܬܵ‌ܐ ܓܘܼܪܬܵ‌ܐ ܐܝܼܡܲܢ ܕܫܵܡܹܥ ܩܵܠܵܐ ܕܚܸܬܢܵܐ. ܐܵܗܵܐ ܚܲܕܘܼܬܵ‌ܐ ܕܝܼܝܼ ܝܠܵܗ̇، ܘܐܵܕܝܼܵܐ ܬܘܼܡܸܡ ܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","”ܗ̇ܘ ܘܵܠܹܐ ܝܠܵܗ̇ ܕܙܵܐܹܕ، ܘܐܵܢܵܐ ܕܒܵܨܪܹܢ. ");
INSERT INTO aii_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","”ܗ̇ܘ ܕܐܵܬܹ‌ܐ ܡ̣ܢ ܥܸܠܸܠܔ، ܥܸܠܸܠܔ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܝܠܹܗ، ܘܗ̇ܘ ܕܝܼܠܹܗ ܡ̣ܢ ܐܲܪܥܵܐ، ܐܲܪܥܵܢܵܝܵܐ ܝܠܹܗ ܘܡ̣ܢ ܐܲܪܥܵܐ ܟܹܐ ܗܲܡܙܸܡ. ܐܝܼܢܵܐ ܗ̇ܘ ܕܐܵܬܹ‌ܐ ܡ̣ܢ ܫܡܲܝܵܐ، ܥܸܠܸܠܔ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","”ܗ̇ܘ ܒܸܣܗܵܕܵܐ ܝܠܹܗ ܒܘܼܬ ܡܸܢܕܝܼ ܕܚܙܹܐ ܠܹܗ ܘܫܡܝܼܥ ܠܹܗ، ܐܝܼܢܵܐ ܐܘܼܦ ܚܲܕ ܠܹܐ ܝܠܹܗ ܩܲܒܘܼܠܘܼܗ̇ ܣܵܗܕܘܼܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","”ܐܝܼܢܵܐ ܟܠܔ ܡ̇ܢ ܕܩܘܼܒܠܵܐ ܝܠܹܗ ܣܵܗܕܘܼܬܹܗ، ܒܸܡܚܵܝܵܐ ܝܠܹܗ ܚܵܬܡܵܐ ܕܐܲܠܵܗܵܐ ܫܲܪܝܼܪܵܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","”ܣܵܒܵܒ ܗ̇ܘ ܕܐܲܠܵܗܵܐ ܫܘܼܕܸܪܹܗ، ܗܹܡܸܙܡܵܢܹ̈ܐ ܕܐܲܠܵܗܵܐ ܟܹܐ ܗܲܡܙܸܡ، ܣܵܒܵܒ ܐܲܠܵܗܵܐ ܟܹܐ ܝܵܗܒܹܠܔ ܠܹܗ ܪܘܼܚܵܐ ܕܠܵܐ ܟܝܘܼܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","”ܒܵܒܵܐ ܟܹܐ ܡܲܚܸܒ ܠܒܪܘܿܢܵܐ، ܘܡܘܼܬܒ݂ܵܐ ܝܠܹܗ ܟܠܔ ܡܸܢܕܝܼ ܒܐܝܼܕܵܬܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","”ܡ̇ܢ ܕܗܲܡܸܢ ܒܒܪܘܿܢܵܐ ܐܝܼܬ ܠܹܗ ܚܲܝܹ̈ܐ ܕܠܥܵܠܲܡ، ܘܡ̇ܢ ܕܠܵܐ ܗܲܡܸܢ ܒܒܪܘܿܢܵܐ، ܠܹܐ ܚܵܙܹܐ ܚܲܝܹ̈ܐ، ܐܸܠܵܐ ܟܲܪܒܵܐ ܕܐܲܠܵܗܵܐ ܥܲܪܩܘܼܠܹܐ ܝܠܵܗ̇ ܥܲܠܘܼܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ܟܲܕ ܝܕܝܼܥ ܠܹܗ ܝܼܫܘܿܥ ܕܫܡܝܼܥ ܠܗܘܿܢ ܦܪ̈ܝܼܫܹܐ ܕܗ̇ܘ ܒܸܥܒ݂ܵܕܵܐ ܝܗܘܵܘ ܬܲܠܡܝܼ̈ܕܹܐ ܘܡܲܥܡܘܼܕܹܐ ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܝܘܿܚܲܢܵܢ، ");
INSERT INTO aii_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(ܟܲܕ ܝܼܫܘܿܥ ܒܓܵܢܹܗ ܠܹܐ ܡܲܥܡܸܕ ܗܘܵܐ ܐܸܠܵܐ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ)، ");
INSERT INTO aii_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ܫܒ݂ܝܼܩܵܐ ܠܹܗ ܝܼܗܘܼܕ ܘܐܙܝܼܠܔ ܠܹܗ ܡܸܢܕܪܸܫ ܠܓܠܝܼܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ܘܘܵܠܹܐ ܝܗܘܵܐ ܐܸܠܹܗ ܕܥܵܒܹܪ ܗܘܵܐ ܡ̣ܢ ܓܵܘ ܫܵܡܪܝܼܢ. ");
INSERT INTO aii_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ܘܐܬܹ‌ܐ ܠܹܗ ܠܡܕܝܼܢ݇ܬܵ‌ܐ ܕܫܵܡܪ̈ܵܝܹܐ ܕܟܹܐ ܦܵܝܫܵܐ ܩܪܝܼܬܵ‌ܐ ܫܟܲܪ، ܩܘܼܪܒܵܐ ܕܚܲܩܠܵܐ ܕܝܘܼܗܒ݂ܘܼܗ̇ ܝܗܘܵܐ ܝܲܥܩܘܿܒ݂ ܠܝܵܘܣܸܦ ܒܪܘܿܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ܘܐܝܼܬ ܗܘܵܐ ܬܵܡܵܐ ܒܹܐܪܵܐ ܕܡ̈ܝܼܵܐ ܕܝܲܥܩܘܿܒ݂. ܘܝܼܫܘܿܥ، ܟܲܕ ܟܟ̰ܝܼܚܵܐ ܡ̣ܢ ܠܹܐܙܵܠܵܐ ܒܐܘܼܪܚܵܐ، ܝܬܝܼܒ݂ ܠܹܗ ܒܕܸܦܢܵܐ ܕܒܹܐܪܵܐ. ܐܲܝܟ݂ ܣܵܥܲܬ ܕܬܪܸܥܣܲܪ ܝܼܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ܘܐܬܹ‌ܐ ܠܵܗ̇ ܒܲܟ݂ܬܵ‌ܐ ܡ̣ܢ ܫܵܡܪܝܼܢ ܠܸܡܠܵܝܵܐ ܡ̈ܝܼܵܐ. ܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇ ܝܼܫܘܿܥ: ”ܗܲܒ݂ܠܔ ܠܝܼ ܡ̈ܝܼܵܐ ܕܫܵܬܹܝܢ.“ ");
INSERT INTO aii_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ܣܵܒܵܒ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܐܙܝܼܠܹܐ ܝܗܘܵܘ ܠܡܕܝܼܢ݇ܬܵ‌ܐ ܠܸܙܒ݂ܵܢܵܐ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ܐܡܝܼܪܵܗ̇ ܐܸܠܹܗ ܗ̇ܝ ܒܲܟ݂ܬܵ‌ܐ ܫܵܡܪܵܝܬܵ‌ܐ: ”ܐܲܢ݇ܬ ܝܗܘܼܕܵܝܵܐ ܝܘܸܬ ܘܐܵܢܵܐ ܫܵܡܪܵܝܬܵ‌ܐ، ܕܵܐܟ݂ܝܼ ܒܸܛܠܵܒܵܐ ܝܘܸܬ ܡܸܢܝܼ ܡ̈ܝܼܵܐ ܠܸܫܬܵܝܵܐ؟“ (ܝܗܘܼܕܵܝܹ̈ܐ ܘܫܵܡܪ̈ܵܝܹܐ ܠܹܐ ܚܵܒ݂ܛܝܼ ܥܲܡ ܥܘܼܕܵܠܹܐ). ");
INSERT INTO aii_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܘܼܗ̇ ܝܼܫܘܿܥ: ”ܐܸܢ ܝܵܕܥܲܬ‌ܝ ܗܘܵܐ ܡܵܘܗܲܒ݂ܬܵ‌ܐ ܕܐܲܠܵܗܵܐ، ܘܡܵܢܝܼ ܝܠܹܗ ܗ̇ܘ ܕܒܸܛܠܵܒܵܐ ܝܠܹܗ ܡܸܢܵܟ݂ܝ ܡ̈ܝܼܵܐ ܠܸܫܬܵܝܵܐ، ܐܲܢ݇ܬ‌ܝ ܒܸܬ ܛܵܠܒܲܬ‌ܝ ܗܘܵܐ ܡܸܢܹܗ ܘܗ̇ܘ ܒܸܬ ܝܵܗܒܹܠܔ ܗܘܵܐ ܠܵܟ݂ܝ ܡ̈ܝܼܵܐ ܚܵܝܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ܐܡܝܼܪܵܗ̇ ܐܸܠܹܗ ܒܲܟ݂ܬܵ‌ܐ: ”ܡܵܪܝܼ، ܘܲܕܪܵܐ ܠܲܝܬ ܠܘܼܟ݂ ܘܒܹܐܪܵܐ ܥܲܡܘܼܩܵܐ ܝܠܹܗ. ܡܐܲܝܟܵܐ ܠܘܼܟ݂ ܡ̈ܝܼܵܐ ܚܵܝܹ̈ܐ؟ ");
INSERT INTO aii_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","”ܩܵܡܘܿܕܝܼ ܐܲܢ݇ܬ ܒܘܼܫ ܓܘܼܪܵܐ ܝܘܸܬ ܡ̣ܢ ܒܵܒܲܢ ܝܲܥܩܘܿܒ݂، ܗ̇ܘ ܕܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܲܢ ܐܵܗܵܐ ܒܹܐܪܵܐ ܘܫܬܹ‌ܐ ܠܹܗ ܡܸܢܹܗ، ܗ̇ܘ ܘܒܢܘܿܢܘܼ̈ܗ‌ܝ ܘܩܸܢܝܵܢܘܼ̈ܗ‌ܝ؟“ ");
INSERT INTO aii_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇ ܝܼܫܘܿܥ: ”ܟܠܔ ܡ̇ܢ ܕܫܵܬܹ‌ܐ ܡ̣ܢ ܐܲܢܹܐ ܡ̈ܝܼܵܐ ܡܸܢܕܪܸܫ ܒܸܬ ܨܵܗܹܐ. ");
INSERT INTO aii_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","”ܐܝܼܢܵܐ ܟܠܔ ܡ̇ܢ ܕܫܵܬܹ‌ܐ ܡ̣ܢ ܡ̈ܝܼܵܐ ܕܐܵܢܵܐ ܝܵܗܒܹܢܹܗ ܠܹܐ ܨܵܗܹܐ ܠܥܵܠܲܡ، ܐܸܠܵܐ ܡ̈ܝܼܵܐ ܕܐܵܢܵܐ ܝܵܗܒܹܢܹܗ ܒܸܬ ܗܵܘܝܼ ܓܵܘܹܗ ܥܲܝܢܵܐ ܕܡ̈ܝܼܵܐ ܕܢܵܒ݂ܥܝܼ ܠܚܲܝܹ̈ܐ ܕܠܥܵܠܲܡ.“ ");
INSERT INTO aii_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ܐܡܝܼܪܵܗ̇ ܐܸܠܹܗ ܗ̇ܝ ܒܲܟ݂ܬܵ‌ܐ: ”ܡܵܪܝܼ، ܗܲܒ݂ܠܔ ܠܝܼ ܡ̣ܢ ܐܲܢܹܐ ܡ̈ܝܼܵܐ ܕܠܵܐ ܨܵܗܝܵܢ ܘܠܵܐ ܗܵܘܝܵܢ ܒܹܐܬܵܝܵܐ ܠܲܐܟ݂ܵܐ ܘܒܸܓܪܵܫܵܐ ܡ̈ܝܼܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇ ܝܼܫܘܿܥ: ”ܙܹܠ݇ܝ ܩܪܝܼ ܠܓܲܒ݂ܪܵܟ݂ܝ ܘܬܵܐܝ ܠܲܐܟ݂ܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ܓ̰ܘܼܘܸܒ ܠܵܗ̇ ܐܸܠܹܗ: ”ܠܲܝܬ ܠܝܼ ܓܲܒ݂ܪܵܐ.“ ܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇ ܝܼܫܘܿܥ: ”ܫܪܵܪܵܐ ܗܘܼܡܙܸܡ ܠܵܟ݂ܝ ܟܲܕ ܐܡܝܼܪܵܟ݂ܝ ܕܠܲܝܬ ܠܝܼ ܓܲܒ݂ܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","”ܣܵܒܵܒ ܚܲܡܫܵܐ ܓܲܒ݂ܪ̈ܵܢܹܐ ܐܝܼܬ ܗܘܵܐ ܠܵܟ݂ܝ، ܘܐܵܗܵܐ ܕܐܵܕܝܼܵܐ ܐܝܼܬ ܠܵܟ݂ܝ ܠܹܐ ܝܠܹܗ ܓܲܒ݂ܪܵܟ݂ܝ. ܐܵܗܵܐ ܫܲܪܝܼܪܵܐܝܼܬ ܗܘܼܡܙܸܡ ܠܵܟ݂ܝ.“ ");
INSERT INTO aii_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ܓ̰ܘܼܘܸܒ ܠܵܗ̇ ܐܸܠܹܗ ܗ̇ܝ ܒܲܟ݂ܬܵ‌ܐ: ”ܡܵܪܝܼ، ܒܸܚܙܵܝܵܐ ܝܘܵܢ ܕܢܒ݂ܝܼܵܐ ܝܘܸܬ. ");
INSERT INTO aii_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","”ܐܲܒ݂ܵܗܵܬܲܢ̈ ܣܓ݂ܝܼܕ ܠܗܘܿܢ ܒܐܵܗܵܐ ܛܘܼܪܵܐ، ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ ܝܗܘܼܕܵܝܹ̈ܐ ܟܹܐ ܐܵܡܪܝܼܬܘܿܢ ܕܘܼܟܵܐ ܕܘܵܠܹܐ ܝܠܵܗ̇ ܕܣܵܓ݂ܕܲܚ ܓܵܘܘܼܗ̇ ܐܘܿܪܸܫܠܸܡ ܝܼܠܵܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇ ܝܼܫܘܿܥ: ”ܒܲܟ݂ܬܵ‌ܐ، ܗܲܡܸܢܝ ܐܸܠܝܼ، ܣܵܥܲܬ ܒܹܐܬܵܝܵܐ ܝܠܵܗ̇ ܕܠܵܐ ܒܐܵܗܵܐ ܛܘܼܪܵܐ ܘܐܘܼܦ ܠܵܐ ܒܐܘܿܪܸܫܠܸܡ ܒܸܬ ܣܵܓ݂ܕܝܼܬܘܿܢ ܠܒܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","”ܐܲܚܬܘܿܢ ܫܵܡܪ̈ܵܝܹܐ ܟܹܐ ܣܵܓ݂ܕܝܼܬܘܿܢ ܠܡܸܢܕܝܼ ܕܠܹܐ ܝܵܕܥܝܼܬܘܿܢ. ܐܲܚܢܲܢ ܝܗܘܼܕܵܝܹ̈ܐ ܟܹܐ ܣܵܓ݂ܕܲܚ ܠܡܸܢܕܝܼ ܕܟܹܐ ܝܵܕܥܲܚ، ܣܵܒܵܒ ܦܘܼܪܩܵܢܵܐ ܡ̣ܢ ܝܗܘܼܕܵܝܹ̈ܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","”ܐܝܼܢܵܐ ܒܹܐܬܵܝܵܐ ܝܠܵܗ̇ ܣܵܥܲܬ ܘܐܵܕܝܼܵܐ ܝܠܵܗ̇، ܐܝܼܡܲܢ ܕܣܵܓ݂ܕܵܢܹ̈ܐ ܫܲܪܝܼܪܹ̈ܐ ܒܸܬ ܣܵܓ݂ܕܝܼ ܠܒܵܒܵܐ ܒܪܘܼܚܵܐ ܘܒܫܪܵܪܵܐ، ܣܵܒܵܒ ܐܘܼܦ ܒܵܒܵܐ ܗܵܕܟ݂ܵܐ ܣܵܓ݂ܕܵܢܹ̈ܐ ܟܹܐ ܒܵܥܹܐ. ");
INSERT INTO aii_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","”ܐܲܠܵܗܵܐ ܪܘܼܚܵܐ ܝܠܹܗ، ܘܐܵܢܝܼ ܕܣܵܓ݂ܕܝܼ ܠܹܗ ܘܵܠܹܐ ܝܠܵܗ̇ ܒܪܘܼܚܵܐ ܘܒܫܪܵܪܵܐ ܣܵܓ݂ܕܝܼ ܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ܐܡܝܼܪܵܗ̇ ܐܸܠܹܗ ܒܲܟ݂ܬܵ‌ܐ: ”ܐܵܢܵܐ ܟܹܐ ܝܵܕܥܵܢ ܕܡܫܝܼܚܵܐ ܒܹܐܬܵܝܵܐ ܝܠܹܗ، ܘܐܝܼܡܲܢ ܕܐܵܬܹ‌ܐ، ܗ̇ܘ ܒܸܬ ܡܲܠܸܦ ܠܲܢ ܟܠܔ ܡܸܢܕܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇ ܝܼܫܘܿܥ: ”ܐܵܢܵܐ ܝܘܸܢ، ܕܗܲܡܙܘܼܡܹܐ ܝܘܸܢ ܥܲܡܵܟ݂ܝ.“ ");
INSERT INTO aii_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ܘܒܐܵܗܵܐ ܥܕܵܢܵܐ ܐܬܹ‌ܐ ܠܗܘܿܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܘܥܘܼܓ̰ܸܒ ܠܗܘܿܢ ܕܗܲܡܙܘܼܡܹܐ ܝܗܘܵܐ ܥܲܡ ܒܲܟ݂ܬܵ‌ܐ. ܐܝܼܢܵܐ ܐܘܼܦ ܚܲܕ ܡܸܢܵܝܗ‌ܝ ܠܵܐ ܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܡܘܼܕܝܼ ܒܵܥܹܝܬ؟“ ܝܲܢ: ”ܩܵܡܘܿܕܝܼ ܗܲܡܙܘܼܡܹܐ ܝܘܸܬ ܥܲܡܘܼܗ̇؟“ ");
INSERT INTO aii_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ܘܫܒ݂ܝܼܩ ܠܵܗ̇ ܒܲܟ݂ܬܵ‌ܐ ܠܬܵܠܸܡܬܘܼܗ̇ ܘܐܙܝܼܠܔ ܠܵܗ̇ ܠܡܕܝܼܢ݇ܬܵ‌ܐ ܘܐܡܝܼܪܵܗ̇ ܠܐܢܵܫܹ̈ܐ: ");
INSERT INTO aii_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","”ܬܹܝܡܘܼܢ ܚܙܹܝܡܘܼܢ ܐܢܵܫܵܐ ܕܐܡܝܼܪܹܗ ܐܸܠܝܼ ܟܠܔ ܡܸܢܕܝܼ ܕܥܒ݂ܝܼܕܬܵ‌ܐ ܝܘܵܢ. ܗܵܐ، ܠܹܐ ܝܠܹܗ ܐܵܗܵܐ ܡܫܝܼܚܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ܘܦܠܝܼܛ ܠܗܘܿܢ ܡ̣ܢ ܡܕܝܼܢ݇ܬܵ‌ܐ ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ܒܗ̇ܝ ܥܕܵܢܵܐ ܛܠܝܼܒ ܠܗܘܿܢ ܡܸܢܹܗ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܒܹܐܡܵܪܵܐ: ”ܪܲܒܝܼܲܢ، ܐܟ݂ܘܿܠܔ.“ ");
INSERT INTO aii_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ܐܝܼܢܵܐ ܗ̇ܘ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܐܵܢܵܐ ܐܝܼܬ ܠܝܼ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ ܕܐܵܟ݂ܠܹܢ ܕܐܲܚܬܘܿܢ ܠܹܐ ܝܵܕܥܝܼܬܘܿܢ ܠܵܗ̇.“ ");
INSERT INTO aii_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ܐܡܝܼܪܗܘܿܢ ܬܲܠܡܝܼ̈ܕܹܐ ܒܹܝܠܵܝܗ‌ܝ: ”ܩܵܡܘܿ ܡܘܼܬܝܵܐ ܝܠܹܗ ܐܸܠܹܗ ܐܢܵܫܵܐ ܡܸܢܕܝܼ ܠܹܐܟ݂ܵܠܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܡܹܐܟ݂ܘܼܠܬ‌ܝܼ ܗ̇ܝ ܝܼܠܵܗ̇ ܕܥܵܒ݂ܕܹܢ ܨܸܒ݂ܝܵܢܵܐ ܕܗ̇ܘ ܕܫܘܼܕܸܪܹܗ ܐܸܠܝܼ ܘܬܲܡܸܡܸܢ ܦܘܼܠܚܵܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","”ܠܹܐ ܝܬܘܿܢ ܐܲܚܬܘܿܢ ܒܹܐܡܵܪܵܐ ܕܡ̣ܢ ܒܵܬܪ ܐܲܪܒܥܵܐ ܝܲܪ̈ܚܹܐ ܒܸܬ ܗܵܘܹܐ ܚܸܨܕܵܐ؟ ܐܝܼܢܵܐ ܐܵܢܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܡܲܪܡܘܼܢ ܥܲܝ̈ܢܵܘܟ݂ܘܿܢ ܘܚܙܹܝܡܘܼܢ ܕܚܲܩܠܵܢܹ̈ܐ ܚܘܝܼܪܹܐ ܝܢܵܐ، ܘܚܸܨܕܵܐ ܡܸܛܝܵܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","”ܗ̇ܘ ܕܟܹܐ ܚܵܨܹܕ ܟܹܐ ܫܵܩܹܠܔ ܦܘܼܪܥܵܢܵܐ، ܘܟܹܐ ܓ̰ܲܡܸܥ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܠܚܲܝܹ̈ܐ ܕܠܥܵܠܲܡ، ܘܗܵܕܟ݂ܵܐ ܕܙܵܪܥܵܢܵܐ ܘܚܵܨܕܵܢܵܐ ܚܵܕܝܼ ܡܥܘܼܕܵܠܹܐ. ");
INSERT INTO aii_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","”ܗܵܕܟ݂ܵܐ ܟܹܐ ܦܵܝܫܵܐ ܬܘܼܡܸܡܬܵ‌ܐ ܗܹܡܸܙܡܵܢ ܕܫܪܵܪܵܐ، ܚܲܕ ܟܹܐ ܙܵܪܹܥ ܘܐܚܹܪܢܵܐ ܟܹܐ ܚܵܨܹܕ. ");
INSERT INTO aii_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","”ܐܵܢܵܐ ܫܘܼܕܸܪܝܼ ܐܸܠܵܘܟ݂ܘܿܢ ܕܚܵܨܕܝܼܬܘܿܢ ܡܸܢܕܝܼ ܕܐܲܚܬܘܿܢ ܠܵܐ ܟܟ̰ܝܼܚ ܠܵܘܟ݂ܘܿܢ ܒܝܼܹܗ، ܐܸܠܵܐ ܐܚܹܪ̈ܢܹܐ ܟܟ̰ܝܼܚ ܠܗܘܿܢ، ܘܐܲܚܬܘܿܢ ܚܨܝܼܕ ܠܵܘܟ݂ܘܿܢ ܛܥܘܼܢܝܵܬܹ̈‌ܐ ܕܥܲܡܠܵܝܗ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ܪܵܒܵܐ ܫܵܡܪ̈ܵܝܹܐ ܡ̣ܢ ܗ̇ܝ ܡܕܝܼܢ݇ܬܵ‌ܐ ܗܘܼܡܸܢܗܘܿܢ ܒܝܼܹܗ ܒܘܼܬ ܚܲܒܪܵܐ ܕܒܲܟ݂ܬܵ‌ܐ ܕܣܗܝܼܕ ܠܵܗ̇ ܒܹܐܡܵܪܵܐ: ”ܐܡܝܼܪܹܗ ܐܸܠܝܼ ܟܠܔ ܡܸܢܕܝܼ ܕܥܒ݂ܝܼܕܬܵ‌ܐ ܝܘܵܢ.“ ");
INSERT INTO aii_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ܘܐܝܼܡܲܢ ܕܐܬܹ‌ܐ ܠܗܘܿܢ ܫܵܡܪ̈ܵܝܹܐ ܠܟܸܣܠܹܗ، ܛܠܝܼܒ ܠܗܘܿܢ ܡܸܢܹܗ ܕܦܵܐܹܫ ܗܘܵܐ ܠܟܸܣܠܵܝܗ‌ܝ، ܘܦܝܼܫ ܠܹܗ ܠܟܸܣܠܵܝܗ‌ܝ ܬܪܹܝ ܝܵܘܡܵܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ܘܒܘܼܫ ܙܵܘܕܵܐ ܗܘܼܡܸܢܗܘܿܢ ܒܝܼܹܗ ܒܘܼܬ ܚܲܒܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ܘܐܡܝܼܪܗܘܿܢ ܠܒܲܟ݂ܬܵ‌ܐ: ”ܐܵܕܝܼܵܐ ܠܵܐ ܐܲܚܟ̰ܝܼ ܒܘܼܬ ܚܲܒܪܵܟ݂ܝ ܗܲܡܘܼܢܹܐ ܝܘܲܚ، ܐܝܼܢܵܐ ܒܓܵܢܲܢ ܫܡܝܼܥ ܠܲܢ، ܘܒܝܼܕܵܥܵܐ ܝܘܲܚ ܕܐܵܗܵܐ ܐܢܵܫܵܐ ܫܲܪܝܼܪܵܐܝܼܬ ܡܫܝܼܚܵܐ ܝܠܹܗ، ܦܵܪܘܿܩܵܐ ܕܥܵܠܡܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ܡ̣ܢ ܒܵܬܪ ܬܪܹܝ ܝܵܘܡܵܢܹ̈ܐ، ܦܠܝܼܛ ܠܹܗ ܝܼܫܘܿܥ ܡ̣ܢ ܬܵܡܵܐ ܘܐܙܝܼܠܔ ܠܹܗ ܠܓܠܝܼܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ܣܵܒܵܒ ܝܼܫܘܿܥ ܒܓܵܢܹܗ ܣܗܝܼܕ ܠܹܗ ܕܢܒ݂ܝܼܵܐ ܓܵܘ ܡܕܝܼܢ݇ܬܵ‌ܐ ܕܓܵܢܹܗ ܠܲܝܬ ܠܹܗ ܐܝܼܩܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ܐܝܼܡܲܢ ܕܐܬܹ‌ܐ ܠܹܗ ܠܓܠܝܼܠܵܐ، ܩܘܼܒܸܠܔ ܠܗܘܿܢ ܐܸܠܹܗ ܓܠܝܼܠܵܝܹ̈ܐ، ܕܚܸܙܝܹܐ ܝܗܘܵܘ ܟܠܔ ܡܸܢܕܝܼ ܕܥܒ݂ܝܼܕ ܠܹܗ ܝܼܫܘܿܥ ܓܵܘ ܐܘܿܪܸܫܠܸܡ ܒܥܹܐܕܵܐ، ܣܵܒܵܒ ܐܘܼܦ ܐܵܢܝܼ ܬܵܡܵܐ ܝܗܘܵܘ ܒܥܹܐܕܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ܐܬܹ‌ܐ ܠܹܗ ܡܸܢܕܪܸܫ ܝܼܫܘܿܥ ܠܩܵܛܢܹܐ ܕܓܠܝܼܠܵܐ ܐܲܝܟܵܐ ܕܡܘܼܚܕܸܪܵܐ ܝܗܘܵܐ ܡ̈ܝܼܵܐ ܠܚܲܡܪܵܐ، ܘܐܝܼܬ ܗܘܵܐ ܓܵܘ ܟܦܲܪܢܵܚܘܿܡ ܚܲܕ ܫܲܠܝܼܛܵܐ ܕܒܪܘܿܢܹܗ ܡܪܝܼܥܵܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܹܗ ܐܵܗܵܐ ܐܢܵܫܵܐ ܕܝܼܫܘܿܥ ܐܬܝܼܵܐ ܝܗܘܵܐ ܠܓܠܝܼܠܵܐ ܡ̣ܢ ܝܼܗܘܼܕ، ܐܙܝܼܠܔ ܠܹܗ ܠܟܸܣܠܹܗ ܘܦܘܼܪܦܸܠܔ ܠܹܗ ܒܝܼܹܗ ܕܨܵܠܹܐ ܘܒܲܣܸܡ ܠܒܪܘܿܢܹܗ ܣܵܒܵܒ ܩܘܼܪܒܵܐ ܕܡܵܘܬܵ‌ܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܐܸܢ ܠܵܐ ܚܵܙܹܝܬܘܿܢ ܢܝܼܫܲܢܩܹ̈ܐ ܘܕܘܼܡܵܪܹ̈ܐ ܠܹܐ ܗܲܡܸܢܝܼܬܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܫܲܠܝܼܛܵܐ: ”ܡܵܪܝܼ، ܨܠܝܼ ܡ̣ܢ ܩܲܕܡ ܕܡܵܐܹܬ ܒܪܘܿܢܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܙܹܠܔ݇، ܒܪܘܿܢܘܼܟ݂ ܒܸܬ ܚܵܝܹܐ.“ ܘܗܘܼܡܸܢܹܗ ܗ̇ܘ ܐܢܵܫܵܐ ܒܗܹܡܸܙܡܵܢ ܕܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ، ܘܐܙܝܼܠܔ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ܘܟܲܕ ܗ̇ܘ ܗܸܫ ܒܸܨܠܵܝܵܐ، ܬܦܝܼܩ ܠܗܘܿܢ ܒܝܼܹܗ ܪܹ̈ܓܵܘܵܬܘܼܗ‌ܝ ܘܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܒܪܘܿܢܘܼܟ݂ ܚܵܝܵܐ ܝܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ܘܐܝܼܡܲܢ ܕܒܘܼܩܸܪܹܗ ܡܸܢܵܝܗ‌ܝ ܒܐܲܝܢܝܼ ܣܵܥܲܬ ܒܣܝܼܡ ܠܹܗ، ܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܐܬܸܡܵܠܝ ܒܣܵܥܲܬ ܕܚܕܵܐ ܫܒ݂ܝܼܩ ܠܵܗ̇ ܐܸܠܹܗ ܚܲܡܚܲܡܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ܘܝܕܝܼܥ ܠܹܗ ܒܵܒܘܼܗ‌ܝ ܕܒܐܵܗܵܐ ܣܵܥܲܬ ܝܗܘܵܐ ܕܝܼܫܘܿܥ ܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܒܪܘܿܢܘܼܟ݂ ܒܸܬ ܚܵܝܹܐ.“ ܘܗܘܼܡܸܢܹܗ ܗ̇ܘ ܘܟܠܹܗ ܒܲܝܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ܐܵܗܵܐ ܝܗܘܵܐ ܢܝܼܫܲܢܩܵܐ ܬܪܲܝܵܢܵܐ ܕܥܒ݂ܝܼܕ ܠܹܗ ܝܼܫܘܿܥ ܐܝܼܡܲܢ ܕܐܬܹ‌ܐ ܠܹܗ ܡ̣ܢ ܝܼܗܘܼܕ ܠܓܠܝܼܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ܒܵܬܪ ܐܲܢܹܐ، ܐܣܝܼܩ ܠܹܗ ܝܼܫܘܿܥ ܠܐܘܿܪܸܫܠܸܡ ܩܵܐ ܥܹܐܕܵܐ ܕܝܗܘܼܕܵܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ܘܐܝܼܬ ܬܵܡܵܐ ܓܵܘ ܐܘܿܪܸܫܠܸܡ ܠܟܸܣ ܕܲܪܘܵܙܵܐ ܕܥܸܪ̈ܒܹܐ ܚܕܵܐ ܗܵܘܘܼܙ ܕܟܹܐ ܦܵܝܫܵܐ ܩܪܝܼܬܵ‌ܐ ܒܠܸܫܵܢܵܐ ܥܸܒ݂ܪܵܝܵܐ ܒܹܝܬ ܚܸܣܕܵܐ، ܘܐܝܼܬ ܓܵܘܘܼܗ̇ ܚܲܡܫܵܐ ܣܛܘܼܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ܠܲܐܟ݂ܵܐ ܐܝܼܬ ܗܘܵܘ ܫܬܝܼܚܹ̈ܐ ܪܵܒܵܐ ܐܢܵܫܹ̈ܐ ܡܪ̈ܝܼܥܹܐ، ܣܸܡܝܹ̈ܐ، ܘܫܦܝܼܠܹ̈ܐ، ܘܒܪ̈ܝܼܙܹܐ، ܒܸܣܦܵܪܵܐ ܠܡ̈ܝܼܵܐ ܕܦܵܝܫܝܼ ܡܘܼܫܥܸܫܹܐ. ");
INSERT INTO aii_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ܣܵܒܵܒ ܡ̣ܢ ܥܕܵܢܵܐ ܠܥܕܵܢܵܐ ܟܹܐ ܨܵܠܹܐ ܗܘܵܐ ܡܲܠܲܐܟ݂ܵܐ ܠܗ̇ܝ ܗܵܘܘܼܙ ܘܡܲܫܥܸܫ ܗܘܵܐ ܠܗܘܿܢ ܡ̈ܝܼܵܐ، ܘܗ̇ܘ ܩܲܕܡܵܝܵܐ ܕܨܵܠܹܐ ܗܘܵܐ ܬܵܡܵܐ ܡ̣ܢ ܒܵܬܪ ܫܥܵܫܬܵ‌ܐ ܕܡ̈ܝܼܵܐ ܟܹܐ ܦܵܐܹܫ ܗܘܵܐ ܒܣܝܼܡܵܐ ܡ̣ܢ ܟܠܔ ܡܲܪܥܵܐ ܕܐܝܼܬ ܗܘܵܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ܐܝܼܬ ܗܘܵܐ ܒܗ̇ܝ ܕܘܼܟܵܐ ܚܲܕ ܐܢܵܫܵܐ ܕܡܪܝܼܥܵܐ ܝܗܘܵܐ ܬܠܵܬ‌ܝܼ ܘܬܡܵܢܝܵܐ ܫܸܢܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ܚܙܹܐ ܠܹܗ ܝܼܫܘܿܥ ܐܸܠܹܗ ܕܡܝܼܟ݂ܵܐ ܬܵܡܵܐ، ܝܕܝܼܥ ܠܹܗ ܕܙܲܒ݂ܢܵܐ ܝܲܪܝܼܟ݂ܵܐ ܡܪܝܼܥܵܐ ܝܗܘܵܐ، ܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܒܵܥܹܝܬ ܕܦܵܝܫܹܬ ܒܘܼܣܡܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ܓ̰ܘܼܘܸܒ ܠܹܗ ܗ̇ܘ ܡܪܝܼܥܵܐ ܘܐܡܝܼܪܹܗ: ”ܡܵܪܝܼ، ܠܲܝܬ ܠܝܼ ܐܢܵܫܵܐ ܕܕܵܪܹܐ ܠܝܼ ܓܵܘ ܗܵܘܘܼܙ ܐܝܼܡܲܢ ܕܦܝܵܫܵܐ ܝܢܵܐ ܡܘܼܫܥܸܫܹܐ ܡ̈ܝܼܵܐ. ܐܝܼܡܲܢ ܕܐܵܢܵܐ ܒܹܐܬܵܝܵܐ ܝܘܸܢ، ܚܲܕ ܐܚܹܪܢܵܐ ܡ̣ܢ ܩܲܕܡ ܕܝܼܝܼ ܒܸܨܠܵܝܵܐ ܝܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܝܼܫܘܿܥ: ”ܩܘܼܡ ܫܩܘܿܠܔ ܫܘܝܼܬܘܼܟ݂ ܘܚܕܘܿܪ.“ ");
INSERT INTO aii_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܒܣܝܼܡ ܠܹܗ ܗ̇ܘ ܐܢܵܫܵܐ. ܘܫܩܝܼܠܔ ܠܹܗ ܫܘܝܼܬܹܗ ܘܚܕܝܼܪܹܗ. ܐܵܗܵܐ ܗܘܹܐ ܠܵܗ̇ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ܝܗܘܼܕܵܝܹ̈ܐ ܐܡܝܼܪܗܘܿܢ ܠܗ̇ܘ ܕܦܝܼܫ ܠܹܗ ܒܘܼܣܡܵܐ: ”ܐܸܕܝܘܿܡ ܫܲܒܬܵ‌ܐ ܝܠܵܗ̇، ܠܹܐ ܝܠܵܗ̇ ܩܵܢܘܿܢܵܝܬܵ‌ܐ ܐܸܠܘܼܟ݂ ܠܸܫܩܵܠܵܐ ܫܘܝܼܬܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ܐܝܼܢܵܐ ܗ̇ܘ ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܗ̇ܘ ܕܩܵܡ ܒܲܣܸܡ ܠܝܼ، ܗ̇ܘ ܐܡܝܼܪܹܗ ܐܸܠܝܼ: ’ܫܩܘܿܠܔ ܫܘܝܼܬܘܼܟ݂ ܘܚܕܘܿܪ.‘“ ");
INSERT INTO aii_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ܘܐܵܢܝܼ ܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ: ”ܡܵܢܝܼ ܝܠܹܗ ܗ̇ܘ ܐܢܵܫܵܐ ܕܐܡܝܼܪܹܗ ܐܸܠܘܼܟ݂: ’ܫܩܘܿܠܔ ܫܘܝܼܬܘܼܟ݂ ܘܚܕܘܿܪ؟‘“ ");
INSERT INTO aii_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ܐܝܼܢܵܐ ܗ̇ܘ ܕܦܝܼܫ ܠܹܗ ܒܘܼܣܡܵܐ ܠܹܐ ܝܵܕܹܥ ܗܘܵܐ ܡܵܢܝܼ ܝܗܘܵܐ، ܣܵܒܵܒ ܪܵܒܵܐ ܟܸܢܫܵܐ ܐܝܼܬ ܗܘܵܐ ܬܵܡܵܐ ܒܗ̇ܝ ܕܘܼܟܵܐ، ܘܝܼܫܘܿܥ ܓܪܝܼܫܵܐ ܠܹܗ ܓܵܢܹܗ ܡ̣ܢ ܓܵܘܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ܡ̣ܢ ܒܵܬܪ ܚܲܕ ܙܲܒ݂ܢܵܐ، ܝܼܫܘܿܥ ܡܘܼܫ݇ܟ̰ܸܚ ܠܹܗ ܓܵܘ ܗܲܝܟܠܵܐ ܘܐܡܝܼܪܹܗ ܐܸܠܹܗ: ”ܗܵܐ، ܒܣܝܼܡ ܠܘܼܟ݂، ܠܵܐ ܚܵܛܹܝܬ ܐܚܹܪܢܵܐ ܕܠܵܐ ܚܲܕ ܡܸܢܕܝܼ ܒܘܼܫ ܚܸܪܒܵܐ ܡ̣ܢ ܗ̇ܘ ܩܲܕܡܵܝܵܐ ܩܲܘܸܡ ܥܲܠܘܼܟ݂.“ ");
INSERT INTO aii_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ܘܐܙܝܼܠܔ ܠܹܗ ܗ̇ܘ ܐܢܵܫܵܐ ܘܐܡܝܼܪܹܗ ܠܝܗܘܼܕܵܝܹ̈ܐ ܕܝܼܫܘܿܥ ܝܼܗܘܵܐ ܗ̇ܘ ܕܒܘܼܣܸܡ ܠܹܗ ܐܸܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ܒܘܼܬ ܐܵܗܵܐ ܕܒܸܥܒ݂ܵܕܵܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܐܲܢܹܐ ܒܫܲܒܬܵ‌ܐ، ܟܲܡܪܝܼ ܗܘܵܘ ܠܹܗ ܝܗܘܼܕܵܝܹ̈ܐ ܘܒܵܥܝܼ ܗܘܵܘ ܠܸܩܛܵܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܒܵܒܝܼ ܒܸܦܠܵܚܵܐ ܝܠܹܗ ܗܲܠܔ ܐܵܕܝܼܵܐ، ܐܘܼܦ ܐܵܢܵܐ ܒܸܦܠܵܚܵܐ ܝܘܸܢ.“ ");
INSERT INTO aii_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ܒܘܼܬ ܐܵܗܵܐ ܒܘܼܫ ܙܵܘܕܵܐ ܒܵܥܝܼ ܗܘܵܘ ܝܗܘܼܕܵܝܹ̈ܐ ܠܸܩܛܵܠܹܗ، ܠܵܐ ܐܲܚܟ̰ܝܼ ܕܒܸܫܡܵܛܵܐ ܝܗܘܵܐ ܫܲܒܬܵ‌ܐ، ܐܸܠܵܐ ܕܒܹܐܡܵܪܵܐ ܝܗܘܵܐ ܐܲܠܵܗܵܐ ܒܵܒܘܼܗ‌ܝ ܝܗܘܵܐ؛ ܗܵܕܟ݂ܵܐ ܒܸܥܒ݂ܵܕܘܼܗ̇ ܓܵܢܹܗ ܫܵܘܝܵܐ ܥܲܡ ܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ܗ̇ܝܓܵܗ ܓ̰ܘܼܘܸܒ ܠܹܗ ܝܼܫܘܿܥ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܬܪܘܼܨܵܐ، ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܒܪܘܿܢܵܐ ܠܹܐ ܡܵܨܹܐ ܥܵܒܹܕ ܡܸܢܕܝܼ ܡ̣ܢ ܓܵܢܹܗ، ܐܸܠܵܐ ܗ̇ܘ ܡܸܢܕܝܼ ܕܚܵܙܹܐ ܒܵܒܵܐ ܒܸܥܒ݂ܵܕܵܐ، ܒܗ̇ܝ ܕܟܠܔ ܡܸܢܕܝܼ ܕܒܵܒܵܐ ܥܵܒܹܕ، ܗܵܕܵܐ ܐܘܼܦ ܒܪܘܿܢܵܐ ܟܹܐ ܥܵܒܹܕ. ");
INSERT INTO aii_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","”ܣܵܒܵܒ ܒܵܒܵܐ ܟܹܐ ܡܲܚܸܒ ܠܒܪܘܿܢܵܐ، ܘܟܹܐ ܡܲܚܙܹܐ ܠܹܗ ܟܠܔ ܡܸܢܕܝܼ ܕܥܵܒܹܕ، ܘܒܘܼܫ ܓܘܼܪܵܐ ܡ̣ܢ ܐܲܢܹܐ ܦܘܼܠܚܵܢܹ̈ܐ ܒܸܬ ܡܲܚܙܹܐ ܠܹܗ، ܗܵܕܟ݂ܵܐ ܕܐܲܚܬܘܿܢ ܥܲܓ̰ܒܝܼܬܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","”ܣܵܒܵܒ ܕܵܐܟ݂ܝܼ ܕܒܵܒܵܐ ܟܹܐ ܡܲܩܸܡ ܡܝܼ̈ܬܹ‌ܐ ܘܡܲܚܹܐ ܠܗܘܿܢ، ܗܵܕܟ݂ܵܐ ܐܘܼܦ ܒܪܘܿܢܵܐ ܟܹܐ ܡܲܚܹܐ ܠܐܵܢܝܼ ܕܒܵܥܹܐ. ");
INSERT INTO aii_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","”ܣܵܒܵܒ ܒܵܒܵܐ ܠܹܐ ܕܵܐܹܢ ܠܐܢܵܫܵܐ، ܐܸܠܵܐ ܟܠܵܗ̇ ܕܝܵܢܬܵ‌ܐ ܝܘܼܗܒ݂ܵܐ ܠܹܗ ܒܐܝܼܕܵܐ ܕܒܪܘܿܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","”ܗܵܕܵܐ ܕܟܠܔ ܐܢܵܫܵܐ ܡܝܲܩܸܪ ܠܒܪܘܿܢܵܐ ܐܲܝܟ݂ ܕܟܹܐ ܡܝܲܩܸܪ ܠܒܵܒܵܐ، ܘܡ̇ܢ ܕܠܵܐ ܡܝܲܩܸܪ ܠܒܪܘܿܢܵܐ، ܠܹܐ ܡܝܲܩܸܪ ܠܒܵܒܵܐ ܕܫܘܼܕܸܪܹܗ ܠܒܪܘܿܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","”ܬܪܘܼܨܵܐ، ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܡ̇ܢ ܕܫܵܡܹܥ ܗܹܡܸܙܡܵܢܝܼ ܘܗܲܡܸܢ ܒܗ̇ܘ ܕܫܘܼܕܪܸܢܹܗ، ܐܝܼܬ ܠܹܗ ܚܲܝܹ̈ܐ ܕܠܥܵܠܲܡ، ܘܠܹܐ ܐܵܬܹ‌ܐ ܠܕܝܵܢܬܵ‌ܐ، ܐܸܠܵܐ ܫܘܼܢܹܐ ܠܹܗ ܡ̣ܢ ܡܵܘܬܵ‌ܐ ܠܚܲܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","”ܬܪܘܼܨܵܐ، ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܒܹܐܬܵܝܵܐ ܝܠܵܗ̇ ܣܵܥܲܬ ܘܐܵܕܝܼܵܐ ܝܠܵܗ̇، ܐܝܼܡܲܢ ܕܡܝܼ̈ܬܹ‌ܐ ܒܸܬ ܫܵܡܥܝܼ ܩܵܠܵܐ ܕܒܪܘܿܢܵܐ ܕܐܲܠܵܗܵܐ، ܘܐܵܢܝܼ ܕܫܵܡܥܝܼ ܒܸܬ ܚܵܝܝܼ. ");
INSERT INTO aii_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","”ܣܵܒܵܒ ܕܵܐܟ݂ܝܼ ܕܒܵܒܵܐ ܐܝܼܬ ܠܹܗ ܚܲܝܹ̈ܐ ܒܓܵܢܹܗ، ܗܵܕܟ݂ܵܐ ܝܘܼܗܒܹܠܔ ܠܹܗ ܐܘܼܦ ܠܒܪܘܿܢܵܐ ܕܗܵܘܹܐ ܠܹܗ ܚܲܝܹ̈ܐ ܒܓܵܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","”ܘܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܹܗ ܫܘܼܠܛܵܢܵܐ ܕܥܵܒܹܕ ܕܝܼܘܵܢ، ܣܵܒܵܒ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","”ܠܵܐ ܥܲܓ̰ܒܝܼܬܘܿܢ ܒܐܵܗܵܐ، ܣܵܒܵܒ ܒܹܐܬܵܝܵܐ ܝܠܵܗ̇ ܣܵܥܲܬ ܐܝܼܡܲܢ ܕܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܓܵܘ ܩܲܒ݂ܪ̈ܵܘܵܬܹ‌ܐ ܝܢܵܐ ܒܸܬ ܫܵܡܥܝܼ ܠܹܗ ܩܵܠܹܗ، ");
INSERT INTO aii_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","”ܘܒܸܬ ܦܵܠܛܝܼ، ܐܵܢܝܼ ܕܥܒ݂ܝܼܕ ܠܗܘܿܢ ܛܵܒ݂ܵܬܹ̈‌ܐ ܠܩܝܵܡܬܵ‌ܐ ܕܚܲܝܹ̈ܐ، ܘܐܵܢܝܼ ܕܥܒ݂ܝܼܕ ܠܗܘܿܢ ܒܝܼܫܵܬܹ̈‌ܐ ܠܩܝܵܡܬܵ‌ܐ ܕܕܝܼܘܵܢ. ");
INSERT INTO aii_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","”ܐܵܢܵܐ ܡ̣ܢ ܓܵܢܝܼ ܠܹܐ ܡܵܨܹܝܢ ܡܸܢܕܝܼ ܥܵܒ݂ܕܹܢ. ܕܵܐܟ݂ܝܼ ܕܫܵܡܥܹܢ ܟܹܐ ܕܵܝܢܹܢ، ܘܕܝܵܢܬ‌ܝܼ ܗܲܩ ܝܼܠܵܗ̇، ܣܵܒܵܒ ܠܹܐ ܒܵܥܹܝܢ ܕܥܵܒ݂ܕܹܢ ܨܸܒ݂ܝܵܢܝܼ ܐܸܠܵܐ ܨܸܒ݂ܝܵܢܵܐ ܕܗ̇ܘ ܕܫܘܼܕܸܪܹܗ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","”ܐܸܢ ܐܵܢܵܐ ܒܸܣܗܵܕܵܐ ܝܘܸܢ ܥܲܠܔ ܓܵܢܝܼ، ܣܵܗܕܘܼܬ‌ܝܼ ܠܹܐ ܝܠܵܗ̇ ܫܲܪܝܼܪܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","”ܐܝܼܬ ܚܲܕ ܐܚܹܪܢܵܐ ܕܟܹܐ ܝܵܗܒܹܠܔ ܣܵܗܕܘܼܬܵ‌ܐ ܥܲܠܝܼ، ܘܐܵܢܵܐ ܒܝܼܕܵܥܵܐ ܝܘܸܢ ܕܣܵܗܕܘܼܬܹܗ ܒܘܼܬ ܕܝܼܝܼ ܫܲܪܝܼܪܬܵ‌ܐ ܝܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","”ܐܲܚܬܘܿܢ ܫܘܼܕܸܪܵܘܟ݂ܘܿܢ ܠܟܸܣ ܝܘܿܚܲܢܵܢ، ܘܗ̇ܘ ܝܘܼܗܒܹܠܔ ܠܹܗ ܣܵܗܕܘܼܬܵ‌ܐ ܒܘܼܬ ܫܪܵܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","”ܠܹܐ ܝܠܵܗ̇ ܕܐܵܢܵܐ ܟܹܐ ܩܲܒܠܸܢ ܣܵܗܕܘܼܬܵ‌ܐ ܡ̣ܢ ܒܢܲܝ̈ܢܵܫܵܐ، ܐܝܼܢܵܐ ܐܲܢܹܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ ܕܦܵܪܩܝܼܬܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","”ܝܘܿܚܲܢܵܢ ܫܪܵܓ݂ܵܐ ܝܗܘܵܐ ܒܸܠܗܵܝܵܐ ܘܒܲܗܪܘܼܢܹܐ، ܘܐܲܚܬܘܿܢ ܒܣܝܼܡ ܠܵܗ̇ ܠܵܘܟ݂ܘܿܢ ܕܦܵܨܚܝܼܬܘܿܢ ܗܘܵܘ ܚܕܵܐ ܣܵܥܲܬ ܒܒܲܗܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","”ܐܝܼܢܵܐ ܐܵܢܵܐ ܐܝܼܬ ܠܝܼ ܣܵܗܕܘܼܬܵ‌ܐ ܒܘܼܫ ܓܘܼܪܬܵ‌ܐ ܡ̣ܢ ܣܵܗܕܘܼܬܵ‌ܐ ܕܝܘܿܚܲܢܵܢ. ܦܘܼܠܚܵܢܹ̈ܐ ܕܒܵܒܵܐ ܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܝܼ ܕܬܲܡܸܡܸܢ، ܘܐܲܝܢܝܼ ܕܒܸܥܒ݂ܵܕܵܝ ܝܘܸܢ، ܐܲܢܹܐ ܒܸܣܗܵܕܵܐ ܝܢܵܐ ܥܲܠܝܼ ܕܒܵܒܵܐ ܫܘܼܕܸܪܹܗ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","”ܘܒܵܒܵܐ ܕܫܘܼܕܸܪܹܗ ܐܸܠܝܼ ܗ̇ܘ ܣܗܝܼܕ ܠܹܗ ܥܲܠܝܼ، ܗ̇ܘ ܕܩܵܠܹܗ ܗܲܪ ܠܹܐ ܝܬܘܿܢ ܫܡܝܼܥܹܐ، ܘܚܸܙܘܹܗ ܠܹܐ ܝܬܘܿܢ ܚܸܙܝܹܐ. ");
INSERT INTO aii_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","”ܘܗܹܡܸܙܡܵܢܹܗ ܠܹܐ ܥܵܡܪܵܐ ܓܵܘܵܘܟ݂ܘܿܢ، ܣܵܒܵܒ ܠܹܐ ܝܬܘܿܢ ܗܲܡܘܼܢܹܐ ܒܗ̇ܘ ܕܫܘܼܕܸܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","”ܨܲܚܨܹܝܡܘܼܢ ܟܬܵܒܹ̈ܐ ܕܟܹܐ ܚܵܫܒ݂ܝܼܬܘܿܢ ܓܵܘܵܝܗ‌ܝ ܐܝܼܬ ܠܵܘܟ݂ܘܿܢ ܚܲܝܹ̈ܐ ܕܠܥܵܠܲܡ. ܐܲܢܹܐ ܟܬܵܒܹ̈ܐ ܒܝܼܵܗܒ݂ܵܐ ܝܢܵܐ ܣܵܗܕܘܼܬܵ‌ܐ ܒܘܼܬ ܕܝܼܝܼ. ");
INSERT INTO aii_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","”ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ ܠܹܐ ܒܵܥܹܝܬܘܿܢ ܕܐܵܬܹܝܬܘܿܢ ܠܟܸܣܠܝܼ ܕܗܵܘܹܐ ܠܵܘܟ݂ܘܿܢ ܚܲܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","”ܚܸܩܪܵܐ ܡ̣ܢ ܒܢܲܝ̈ܢܵܫܵܐ ܠܹܐ ܩܲܒܠܸܢ، ");
INSERT INTO aii_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","”ܐܸܠܵܐ ܟܹܐ ܝܵܕܥܹܢܵܘܟ݂ܘܿܢ ܕܠܲܝܬ ܒܝܼܵܘܟ݂ܘܿܢ ܚܘܼܒܵܐ ܕܐܲܠܵܗܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","”ܐܵܢܵܐ ܐܬܹ‌ܐ ܠܝܼ ܒܫܸܡܵܐ ܕܒܵܒܝܼ، ܘܠܹܐ ܝܬܘܿܢ ܩܲܒܘܼܠܹܐ ܐܸܠܝܼ. ܐܝܼܢܵܐ ܐܸܢ ܚܲܕ ܐܚܹܪܢܵܐ ܐܵܬܹ‌ܐ ܒܫܸܡܵܐ ܕܓܵܢܹܗ، ܠܗ̇ܘ ܒܸܬ ܩܲܒܠܝܼܬܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","”ܕܵܐܟ݂ܝܼ ܡܵܨܹܝܬܘܿܢ ܗܲܡܸܢܝܼܬܘܿܢ، ܟܲܕ ܩܲܒܘܼܠܹܐ ܝܬܘܿܢ ܚܸܩܪܵܐ ܚܲܕ ܡ̣ܢ ܗ̇ܘ ܐܚܹܪܢܵܐ، ܐܝܼܢܵܐ ܚܸܩܪܵܐ ܕܡ̣ܢ ܚܲܕ ܐܲܠܵܗܵܐ ܠܹܐ ܝܬܘܿܢ ܒܸܛܥܵܝܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","”ܠܵܐ ܚܵܫܒ݂ܝܼܬܘܿܢ ܕܐܵܢܵܐ ܒܸܬ ܩܵܒ݂ܠܹܢ ܐܸܠܵܘܟ݂ܘܿܢ ܩܲܕܡ ܒܵܒܵܐ. ܡܘܼܫܹܐ ܒܸܬ ܩܵܒܹܠܔ ܐܸܠܵܘܟ݂ܘܿܢ، ܗ̇ܘ ܕܟܠܵܗ̇ ܗܹܒ݂ܝܼܵܘܟ݂ܘܿܢ ܒܝܼܹܗ ܝܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","”ܣܵܒܵܒ ܐܸܢ ܗܲܡܸܢܝܼܬܘܿܢ ܗܘܵܘ ܒܡܘܼܫܹܐ، ܐܘܼܦ ܒܝܼܝܼ ܒܸܬ ܗܲܡܸܢܝܼܬܘܿܢ ܗܘܵܘ، ܣܵܒܵܒ ܗ̇ܘ ܟܬܝܼܒ݂ ܠܹܗ ܒܘܼܬ ܕܝܼܝܼ. ");
INSERT INTO aii_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","”ܐܝܼܢܵܐ ܐܸܢ ܠܟܬܵܒܹ̈ܐ ܕܡܘܼܫܹܐ ܠܹܐ ܗܲܡܸܢܝܼܬܘܿܢ، ܕܵܐܟ݂ܝܼ ܒܸܬ ܗܲܡܸܢܝܼܬܘܿܢ ܠܗܹܡܸܙܡܵܢܹ̈ܐ ܕܝܼܝܼ؟“ ");
INSERT INTO aii_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ܡ̣ܢ ܒܵܬܪ ܚܲܕܟܡܵܐ ܝܵܘܡܵܢܹ̈ܐ ܥܒ݂ܝܼܪܹܗ ܝܼܫܘܿܥ ܠܡܲܪܙܵܐ ܐܚܹܪܢܵܐ ܕܝܵܡܵܐ ܕܓܠܝܼܠܵܐ ܕܝܼܠܵܗ̇ ܝܵܡܵܐ ܕܛܹܒܲܪܝܼܘܿܣ. ");
INSERT INTO aii_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ܘܐܙܝܼܠܔ ܠܗܘܿܢ ܒܵܬܪܹܗ ܟܸܢܫܹ̈ܐ ܪܵܒܵܐ ܣܵܒܵܒ ܚܙܹܐ ܠܗܘܿܢ ܢܝܼܫܲܢܩܹ̈ܐ ܪܵܒܵܐ ܕܥܒ݂ܝܼܕ ܠܹܗ ܒܡܲܪ̈ܥܵܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ܘܐܣܝܼܩ ܠܹܗ ܝܼܫܘܿܥ ܠܛܘܼܪܵܐ، ܘܬܵܡܵܐ ܝܬܝܼܒ݂ ܠܹܗ ܥܲܡ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ܥܹܐܕܵܐ ܕܦܸܨܚܵܐ ܕܝܗܘܼܕܵܝܹ̈ܐ ܩܲܪܒܘܼܢܹܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ܡܘܼܪܸܡ ܠܹܗ ܝܼܫܘܿܥ ܥܲܝܢܘܼ̈ܗ‌ܝ ܘܚܙܹܐ ܠܹܗ ܟܸܢܫܵܐ ܪܵܒܵܐ ܒܹܐܬܵܝܵܐ ܠܟܸܣܠܹܗ. ܒܘܼܩܸܪܹܗ ܡ̣ܢ ܦܝܼܠܝܼܦܘܿܣ: ”ܡ̣ܢ ܐܲܝܟܵܐ ܙܵܒ݂ܢܲܚ ܠܲܚܡܵܐ ܕܐܵܟ݂ܠܝܼ ܐܲܢܹܐ ܐܢܵܫܹ̈ܐ؟“ ");
INSERT INTO aii_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ܐܵܗܵܐ ܒܘܼܩܸܪܹܗ ܡܸܢܹܗ ܠܓ̰ܲܪܘܼܒܹܗ، ܣܵܒܵܒ ܗ̇ܘ ܒܓܵܢܹܗ ܟܹܐ ܝܵܕܹܥ ܗܘܵܐ ܡܘܼܕܝܼ ܒܸܬ ܥܵܒܹܕ ܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܹܗ ܦܝܼܠܝܼܦܘܿܣ: ”ܠܲܚܡܵܐ ܒܛܝܼܡܵܐ ܕܬܪܲܝܡܵܐܐ ܕܝܼܢܵܪܹ̈ܐ ܠܹܐ ܡܵܠܹܐ ܠܗܘܿܢ، ܐܘܼܦ ܐܸܢ ܕܟܠܔ ܚܲܕ ܫܵܩܹܠܔ ܐܲܚܟ̰ܝܼ ܚܲܕ ܩܸܛܥܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ܐܡܝܼܪܹܗ ܐܸܠܹܗ ܚܲܕ ܬܲܠܡܝܼܕܵܐ ܐܚܹܪܢܵܐ، ܐܲܢܕܪܹܐܘܿܣ ܐܲܚܘܿܢܵܐ ܕܫܸܡܥܘܿܢ ܟܹܐܦܵܐ: ");
INSERT INTO aii_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","”ܐܝܼܬ ܚܲܕ ܝܵܠܵܕ݇ܐ ܠܲܐܟ݂ܵܐ ܕܐܝܼܬ ܠܹܗ ܚܲܡܸܫ ܓܸܪ̈ܕܲܝܹܐ ܕܣܥܵܪܹ̈ܐ ܘܬܪܹܝ ܢܘܼܢܹ̈ܐ ܙܥܘܿܪܹ̈ܐ، ܐܝܼܢܵܐ ܐܲܢܹܐ ܡܘܼܕܝܼ ܒܸܬ ܥܵܒ݂ܕܝܼ ܩܵܐ ܟܠܹܗ ܐܵܗܵܐ ܟܸܢܫܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܫܒ݂ܘܿܩܘܼܢ ܐܢܵܫܹ̈ܐ ܕܝܵܬܒ݂ܝܼ.“ ܐܝܼܬ ܗܘܵܐ ܓܸܠܵܐ ܪܵܒܵܐ ܒܗ̇ܝ ܕܘܼܟܵܐ. ܘܐܵܢܝܼ ܕܝܬܝܼܒ݂ ܠܗܘܿܢ ܐܲܝܟ݂ ܚܲܡܫܵܐ ܐܲܠܦܹ̈ܐ ܓܲܒ݂ܪܹ̈ܐ ܝܗܘܵܘ. ");
INSERT INTO aii_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ܘܫܩܝܼܠܔ ܠܹܗ ܝܼܫܘܿܥ ܠܲܚܡܵܐ ܘܒܘܼܪܸܟ݂ ܠܹܗ ܘܦܘܼܠܸܥ ܠܹܗ ܠܐܵܢܝܼ ܕܝܼܗܘܵܘ ܝܬܝܼܒܹܐ، ܘܗܵܕܟ݂ܵܐ ܐܘܼܦ ܢܘܼܢܹ̈ܐ، ܟܡܵܐ ܕܒܥܹܐ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ܡ̣ܢ ܒܵܬܪ ܕܐܟ݂ܝܼܠܔ ܠܗܘܿܢ ܘܣܒ݂ܝܼܥ ܠܗܘܿܢ، ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܠܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܓ̰ܲܡܸܥܡܘܼܢ ܠܩܸܛܥܵܛܹ̈ܐ ܙܝܼܕܹܐ ܕܠܵܐ ܛܵܠܹܩ ܡܸܢܕܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ܓ̰ܘܼܡܸܥ ܠܗܘܿܢ ܘܡܠܹܐ ܠܗܘܿܢ ܬܪܸܥܣܲܪ ܩܘܼܦܹ̈ܐ ܡ̣ܢ ܩܸܛܥܵܛܹ̈ܐ ܕܙܝܼܕ ܠܗܘܿܢ ܡ̣ܢ ܚܲܡܸܫ ܓܸܪ̈ܕܲܝܹܐ ܕܣܥܵܪܹ̈ܐ ܕܐܟ݂ܝܼܠܔ ܠܗܘܿܢ ܐܵܢܝܼ ܐܢܵܫܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܗܘܿܢ ܐܢܵܫܹ̈ܐ ܢܝܼܫܲܢܩܵܐ ܕܥܒ݂ܝܼܕ ܠܹܗ ܝܼܫܘܿܥ، ܐܡܝܼܪܗܘܿܢ: ”ܫܲܪܝܼܪܵܐܝܼܬ ܐܵܗܵܐ ܝܠܹܗ ܢܒ݂ܝܼܵܐ ܕܐܵܬܹ‌ܐ ܠܕܘܼܢܝܹܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ܝܼܫܘܿܥ ܝܕܝܼܥ ܠܹܗ ܕܒܵܥܝܼ ܗܘܵܘ ܐܵܬ‌ܝܼ ܗܘܵܘ ܘܒܚܲܝܠܵܐ ܥܵܒ݂ܕܝܼ ܗܘܵܘ ܠܹܗ ܡܲܠܟܵܐ، ܗܵܕܟ݂ܵܐ ܫܘܼܢܹܐ ܠܹܗ ܚܕܵܐ ܓܵܗܵܐ ܐܚܹܪܬܵ‌ܐ ܠܛܘܼܪܵܐ ܒܢܲܦ̮ܫܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ܐܝܼܡܲܢ ܕܗܘܹܐ ܠܹܗ ܪܲܡܫܵܐ، ܨܠܹܐ ܠܗܘܿܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܠܝܵܡܵܐ، ");
INSERT INTO aii_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ܘܐܣܝܼܩ ܠܗܘܿܢ ܠܓܵܡܝܼ ܘܛܪܹܐ ܠܗܘܿܢ ܥܲܠܔ ܝܵܡܵܐ ܠܓܹܒܵܐ ܕܟܦܲܪܢܵܚܘܿܡ، ܘܗܘܹܐ ܠܹܗ ܚܸܫܟܵܐ ܘܗܸܫ ܝܼܫܘܿܥ ܠܹܐ ܝܗܘܵܐ ܐܵܕܝܼܵܐ ܠܟܸܣܠܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ܦܵܘܚܵܐ ܚܲܝܠܵܢܵܐ ܒܸܡܚܵܝܵܐ ܝܗܘܵܐ، ܘܝܵܡܵܐ ܒܸܫܓ݂ܵܫܵܐ ܝܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ܐܝܼܡܲܢ ܕܛܪܹܐ ܠܗܘܿܢ ܡܐܲܝܟ݂ ܬܠܵܬܵ‌ܐ ܝܲܢ ܬܠܵܬܵ‌ܐ ܡܝܼܠܹ̈ܐ ܘܦܲܠܓܵܐ، ܚܙܹܐ ܠܗܘܿܢ ܠܝܼܫܘܿܥ ܒܸܚܕܵܪܵܐ ܥܲܠܔ ܝܵܡܵܐ، ܘܩܲܪܒܘܼܢܹܐ ܠܓܵܡܝܼ، ܘܙܕܝܼܥ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܐܵܢܵܐ ܝܘܸܢ، ܠܵܐ ܙܵܕܥܝܼܬܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ܘܒܥܹܐ ܠܗܘܿܢ ܕܩܲܒܠܝܼ ܗܘܵܘ ܠܹܗ ܓܵܘ ܓܵܡܝܼ، ܘܗܲܪ ܒܗ̇ܝ ܥܕܵܢܵܐ ܓܵܡܝܼ ܡܛܹܐ ܠܵܗ̇ ܠܒܸܪܙܵܐ ܠܕܘܼܟܵܐ ܕܒܹܐܙܵܠܵܐ ܝܗܘܵܘ ܐܸܠܘܼܗ̇. ");
INSERT INTO aii_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ܒܝܵܘܡܵܐ ܐܚܹܪܢܵܐ ܟܸܢܫܵܐ ܕܟܸܠܝܵܐ ܝܗܘܵܐ ܠܗ̇ܘ ܓܹܒܵܐ ܐܚܹܪܢܵܐ ܕܝܵܡܵܐ ܚܙܹܐ ܠܗܘܿܢ ܕܐܲܚܟ̰ܝܼ ܚܕܵܐ ܓܵܡܝܼ ܐܝܼܬ ܗܘܵܐ ܬܵܡܵܐ، ܐܲܝܢܝܼ ܕܝܼܫܘܿܥ ܘܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܠܹܐ ܝܗܘܵܘ ܓܵܘܘܼܗ̇، ܐܸܠܵܐ ܐܙܝܼܠܹܐ ܝܗܘܵܘ ܒܢܲܦ̮ܫܵܝܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ܐܝܼܢܵܐ ܓܵܡܝܼܹ̈ܐ ܐܚܹܪ̈ܢܹܐ ܐܬܹ‌ܐ ܠܗܘܿܢ ܡ̣ܢ ܛܹܒܲܪܝܼܘܿܣ ܩܘܼܪܒܵܐ ܠܕܘܼܟܵܐ ܐܲܝܟܵܐ ܕܟܸܢܫܹ̈ܐ ܐܟ݂ܝܼܠܹܐ ܝܗܘܵܘ ܠܲܚܡܵܐ ܡ̣ܢ ܒܵܬܪ ܕܒܘܼܪܸܟ݂ ܠܹܗ ܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ܐܝܼܡܲܢ ܕܝܕܝܼܥ ܠܹܗ ܟܸܢܫܵܐ ܕܠܵܐ ܝܼܫܘܿܥ ܘܐܵܦܠܵܐ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܬܵܡܵܐ ܝܗܘܵܘ، ܐܣܝܼܩ ܠܗܘܿܢ ܠܐܵܢܝܼ ܓܵܡܝܼܹ̈ܐ ܘܐܬܹ‌ܐ ܠܗܘܿܢ ܠܟܦܲܪܢܵܚܘܿܡ ܒܸܛܥܵܝܵܐ ܒܵܬܪ ܝܼܫܘܿܥ. ");
INSERT INTO aii_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ܐܝܼܡܲܢ ܕܚܙܹܐ ܠܗܘܿܢ ܐܸܠܹܗ ܠܡܲܪܙܵܐ ܐܚܹܪܢܵܐ ܕܝܵܡܵܐ، ܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ: ”ܪܲܒܝܼܲܢ، ܐܝܼܡܲܢ ܐܬܹ‌ܐ ܠܘܼܟ݂ ܠܲܐܟ݂ܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܬܪܘܼܨܵܐ، ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܒܸܛܥܵܝܵܐ ܝܬܘܿܢ ܒܵܬܪܝܼ ܠܵܐ ܕܚܙܹܐ ܠܵܘܟ݂ܘܿܢ ܢܝܼܫܲܢܩܹ̈ܐ، ܐܝܼܢܵܐ ܕܐܟ݂ܝܼܠܔ ܠܵܘܟ݂ܘܿܢ ܠܲܚܡܵܐ ܘܣܒ݂ܝܼܥ ܠܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","”ܠܵܐ ܦܵܠܚܝܼܬܘܿܢ ܩܵܐ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ ܕܠܹܐ ܦܵܝܫܵܐ، ܐܸܠܵܐ ܦܠܘܿܚܘܼܢ ܩܵܐ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ ܕܦܵܝܫܵܐ ܠܚܲܝܹ̈ܐ ܕܠܥܵܠܲܡ، ܗ̇ܝ ܕܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܝܵܗܒܹܠܔ ܠܵܘܟ݂ܘܿܢ، ܒܗ̇ܝ ܕܥܲܠܘܼܗ‌ܝ ܐܲܠܵܗܵܐ ܒܵܒܵܐ ܡܘܼܬܸܒ݂ ܠܹܗ ܚܵܬܡܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ܗ̇ܝܓܵܗ ܐܵܢܝܼ ܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ: ”ܡܘܼܕܝܼ ܥܵܒ݂ܕܲܚ ܕܦܵܠܚܲܚ ܦܘܼܠܚܵܢܹ̈ܐ ܕܐܲܠܵܗܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܐܵܗܵܐ ܝܠܹܗ ܦܘܼܠܚܵܢܵܐ ܕܐܲܠܵܗܵܐ، ܕܗܲܡܸܢܝܼܬܘܿܢ ܒܡ̇ܢ ܕܗ̇ܘ ܫܘܼܕܸܪܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ܘܐܵܢܝܼ ܒܘܼܩܸܪܗܘܿܢ ܡܸܢܹܗ: ”ܡܘܼܕܝܼ ܢܝܼܫܲܢܩܵܐ ܒܸܬ ܥܵܒ݂ܕܹܬ ܕܗܲܡܸܢܲܚ ܒܝܼܘܼܟ݂؟ ܡܘܼܕܝܼ ܒܸܥܒ݂ܵܕܵܐ ܝܘܸܬ؟ ");
INSERT INTO aii_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","”ܒܵܒܵܘܵܬܲܢ̈ ܐܟ݂ܝܼܠܔ ܠܗܘܿܢ ܡܲܢܢܵܐ ܓܵܘ ܒܲܪܝܼܵܐ، ܕܵܐܟ݂ܝܼ ܕܟܬܝܼܒ݂ܵܐ ܝܠܹܗ: ’ܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܠܲܚܡܵܐ ܡ̣ܢ ܫܡܲܝܵܐ ܕܐܵܟ݂ܠܝܼ.‘“ ");
INSERT INTO aii_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܬܪܘܼܨܵܐ، ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܠܹܐ ܝܗܘܵܐ ܡܘܼܫܹܐ ܕܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܘܟ݂ܘܿܢ ܠܲܚܡܵܐ ܡ̣ܢ ܫܡܲܝܵܐ ܐܸܠܵܐ ܒܵܒܝܼ ܒܝܼܵܗܒ݂ܵܘܟ݂ܘܿܢ ܝܼܠܹܗ ܠܲܚܡܵܐ ܫܲܪܝܼܪܵܐ ܡ̣ܢ ܫܡܲܝܵܐ، ");
INSERT INTO aii_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","”ܠܲܚܡܵܐ ܕܐܲܠܵܗܵܐ ܗ̇ܘ ܝܼܠܹܗ ܕܨܠܹܐ ܠܹܗ ܡ̣ܢ ܫܡܲܝܵܐ ܘܒܝܼܵܗܒ݂ܵܐ ܝܠܹܗ ܚܲܝܹ̈ܐ ܠܥܵܠܡܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ ܝܗܘܼܕܵܝܹ̈ܐ: ”ܡܵܪܲܢ، ܗܲܒ݂ܠܔ ܠܲܢ ܒܟܠܔ ܥܕܵܢܵܐ ܐܵܗܵܐ ܠܲܚܡܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܐܵܢܵܐ ܝܘܸܢ ܠܲܚܡܵܐ ܕܚܲܝܹ̈ܐ. ܡ̇ܢ ܕܐܵܬܹ‌ܐ ܠܟܸܣܠܝܼ ܠܹܐ ܟܵܦܹܢ، ܘܡ̇ܢ ܕܗܲܡܸܢ ܒܝܼܝܼ ܠܹܐ ܨܵܗܹܐ ܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","”ܐܝܼܢܵܐ ܕܵܐܟ݂ܝܼ ܕܐܡܝܼܪܝܼ ܐܸܠܵܘܟ݂ܘܿܢ، ܩܵܡ ܚܵܙܹܝܬܘܿܢ ܠܝܼ ܐܝܼܢܵܐ ܠܹܐ ܝܬܘܿܢ ܗܲܡܘܼܢܹܐ. ");
INSERT INTO aii_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","”ܟܠܔ ܚܲܕ ܕܒܵܒܵܐ ܝܵܗܒܹܠܔ ܐܸܠܝܼ، ܠܟܸܣܠܝܼ ܟܹܐ ܐܵܬܹ‌ܐ، ܘܟܠܔ ܡ̇ܢ ܕܐܵܬܹ‌ܐ ܠܟܸܣܠܝܼ ܠܹܐ ܛܵܪܕܹܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","”ܣܵܒܵܒ ܐܬܹ‌ܐ ܠܝܼ ܡ̣ܢ ܫܡܲܝܵܐ ܠܵܐ ܕܥܵܒ݂ܕܹܢ ܨܸܒ݂ܝܵܢܝܼ، ܐܸܠܵܐ ܨܸܒ݂ܝܵܢܵܐ ܕܡ̇ܢ ܕܫܘܼܕܸܪܹܗ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","”ܘܐܵܗܵܐ ܝܠܹܗ ܨܸܒ݂ܝܵܢܵܐ ܕܗ̇ܘ ܕܩܵܡ ܫܲܕܸܪܝܼ، ܕܠܵܐ ܛܵܠܹܩ ܐܘܼܦ ܚܲܕ ܡ̣ܢ ܟܠܵܝܗ‌ܝ ܐܵܢܝܼ ܕܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܝܼ، ܐܸܠܵܐ ܕܡܲܩܸܡܸܢܹܗ ܒܝܵܘܡܵܐ ܐܚܵܪܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","”ܘܐܵܗܵܐ ܝܠܹܗ ܨܸܒ݂ܝܵܢܵܐ ܕܒܵܒܝܼ، ܟܠܔ ܚܲܕ ܕܚܵܙܹܐ ܠܒܪܘܿܢܵܐ ܘܗܲܡܸܢ ܒܝܼܹܗ ܒܸܬ ܗܵܘܹܐ ܠܹܗ ܚܲܝܹ̈ܐ ܕܠܥܵܠܲܡ، ܘܐܵܢܵܐ ܒܸܬ ܡܲܩܸܡܸܢܹܗ ܒܝܵܘܡܵܐ ܐܚܵܪܵܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ܒܘܼܬ ܐܵܗܵܐ ܝܗܘܼܕܵܝܹ̈ܐ ܛܘܼܪܛܸܡ ܠܗܘܿܢ ܥܲܠܘܼܗ‌ܝ، ܣܵܒܵܒ ܐܡܝܼܪܹܗ: ”ܐܵܢܵܐ ܝܘܸܢ ܠܲܚܡܵܐ ܕܨܠܹܐ ܠܹܗ ܡ̣ܢ ܫܡܲܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ܘܐܡܝܼܪܗܘܿܢ: ”ܠܹܐ ܝܠܹܗ ܐܵܗܵܐ ܝܼܫܘܿܥ، ܒܪܘܿܢܵܐ ܕܝܵܘܣܸܦ؟ ܒܵܒܘܼܗ‌ܝ ܘܝܸܡܹܗ ܟܹܐ ܝܵܕܥܲܚ ܠܗܘܿܢ. ܕܵܐܟ݂ܝܼ ܐܵܕܝܼܵܐ ܒܹܐܡܵܪܵܐ ܝܠܹܗ ܕܐܵܢܵܐ ܨܠܹܐ ܠܝܼ ܡ̣ܢ ܫܡܲܝܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܠܵܐ ܛܲܪܛܸܡܝܼܬܘܿܢ ܒܓܵܢܵܘܟ݂ܘܿܢ، ");
INSERT INTO aii_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","”ܐܢܵܫܵܐ ܠܹܐ ܡܵܨܹܐ ܐܵܬܹ‌ܐ ܠܟܸܣܠܝܼ ܐܸܢ ܠܵܐ ܓܵܪܹܫ ܠܹܗ ܒܵܒܵܐ، ܗ̇ܘ ܕܫܘܼܕܸܪܹܗ ܐܸܠܝܼ، ܘܐܵܢܵܐ ܒܸܬ ܡܲܩܸܡܸܢܹܗ ܒܝܵܘܡܵܐ ܐܚܵܪܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","”ܟܬܝܼܒ݂ܵܐ ܝܠܹܗ ܒܝܲܕ ܢܒ݂ܝܼܹ̈ܐ، ܕܟܠܵܝܗ‌ܝ ܒܸܬ ܦܵܝܫܝܼ ܡܘܼܠܦܹܐ ܒܝܲܕ ܐܲܠܵܗܵܐ. ܗܵܕܟ݂ܵܐ ܟܠܔ ܡ̇ܢ ܕܫܵܡܹܥ ܘܝܵܠܹܦ ܡ̣ܢ ܒܵܒܵܐ ܟܹܐ ܐܵܬܹ‌ܐ ܠܟܸܣܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","”ܐܘܼܦ ܚܲܕ ܐܢܵܫܵܐ ܠܹܐ ܝܠܹܗ ܚܸܙܝܵܐ ܠܒܵܒܵܐ ܫܒ݂ܘܿܩ ܡ̣ܢ ܗ̇ܘ ܕܝܼܠܹܗ ܡ̣ܢ ܐܲܠܵܗܵܐ. ܐܲܚܟ̰ܝܼ ܗ̇ܘ ܚܸܙܝܵܐ ܝܠܹܗ ܠܒܵܒܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","”ܬܪܘܼܨܵܐ، ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܗ̇ܘ ܕܗܲܡܸܢ ܒܝܼܝܼ ܐܝܼܬ ܠܹܗ ܚܲܝܹ̈ܐ ܕܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","”ܐܵܢܵܐ ܝܘܸܢ ܠܲܚܡܵܐ ܕܚܲܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","”ܐܲܒ݂ܵܗܵܬܵܘ̈ܟ݂ܘܿܢ ܐܟ݂ܝܼܠܔ ܠܗܘܿܢ ܡܲܢܢܵܐ ܓܵܘ ܒܲܪܝܼܵܐ ܐܝܼܢܵܐ ܡܝܼܬ ܠܗܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","”ܐܝܼܢܵܐ ܐܵܗܵܐ ܝܠܹܗ ܠܲܚܡܵܐ ܕܨܠܹܐ ܠܹܗ ܡ̣ܢ ܫܡܲܝܵܐ، ܕܟܠܔ ܡ̇ܢ ܕܐܵܟܹܠܔ ܡܸܢܹܗ ܠܹܐ ܡܵܐܹܬ. ");
INSERT INTO aii_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","”ܐܵܢܵܐ ܝܘܸܢ ܠܲܚܡܵܐ ܕܚܲܝܹ̈ܐ ܕܨܠܹܐ ܠܝܼ ܡ̣ܢ ܫܡܲܝܵܐ. ܐܸܢ ܐܢܵܫܵܐ ܐܵܟܹܠܔ ܡ̣ܢ ܐܵܗܵܐ ܠܲܚܡܵܐ ܒܸܬ ܚܵܝܹܐ ܠܥܵܠܲܡ. ܘܦܲܓ݂ܪܝܼ ܝܠܹܗ ܐܵܗܵܐ ܠܲܚܡܵܐ ܕܝܵܗܒܹܢܹܗ، ܘܒܘܼܬ ܚܲܝܹ̈ܐ ܕܥܵܠܡܵܐ ܒܸܬ ܝܵܗܒܹܢܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ܝܗܘܼܕܵܝܹ̈ܐ ܕܵܪܫܝܼ ܗܘܵܘ ܚܲܕ ܥܲܡ ܗ̇ܘ ܐܚܹܪܢܵܐ ܘܐܵܡܪܝܼ ܗܘܵܘ: ”ܕܵܐܟ݂ܝܼ ܡܵܨܹܐ ܐܵܗܵܐ ܝܵܗܒܹܠܔ ܠܲܢ ܦܲܓ݂ܪܹܗ ܕܐܵܟ݂ܠܲܚ؟“ ");
INSERT INTO aii_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܬܪܘܼܨܵܐ، ܬܪܘܼܨܵܐ ܒܹܐܡܵܪܵܐ ܝܘܸܢ ܐܸܠܵܘܟ݂ܘܿܢ، ܐܸܢ ܠܵܐ ܐܵܟ݂ܠܝܼܬܘܿܢ ܦܲܓ݂ܪܵܐ ܕܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܘܫܵܬܹܝܬܘܿܢ ܕܸܡܹܗ، ܠܲܝܬ ܠܵܘܟ݂ܘܿܢ ܚܲܝܹ̈ܐ ܒܓܵܢܵܘܟ݂ܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","”ܡ̇ܢ ܕܐܵܟܹܠܔ ܦܲܓ݂ܪܝܼ ܘܫܵܬܹ‌ܐ ܕܸܡܝܼ ܐܝܼܬ ܠܹܗ ܚܲܝܹ̈ܐ ܕܠܥܵܠܲܡ، ܘܐܵܢܵܐ ܒܸܬ ܡܲܩܸܡܸܢܹܗ ܒܝܵܘܡܵܐ ܐܚܵܪܵܝܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","”ܣܵܒܵܒ ܦܲܓ݂ܪܝܼ ܒܫܲܪܝܼܪܘܼܬܵ‌ܐ ܡܹܐܟ݂ܘܼܠܬܵ‌ܐ ܝܠܹܗ، ܘܕܸܡܝܼ ܒܫܲܪܝܼܪܘܼܬܵ‌ܐ ܫܬܵܝܬܵ‌ܐ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","”ܡ̇ܢ ܕܐܵܟܹܠܔ ܦܲܓ݂ܪܝܼ ܘܫܵܬܹ‌ܐ ܕܸܡܝܼ، ܒܸܬ ܡܩܲܘܹܐ ܒܝܼܝܼ ܘܐܵܢܵܐ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","”ܕܵܐܟ݂ܝܼ ܕܒܵܒܵܐ ܚܵܝܵܐ ܫܘܼܕܸܪܹܗ ܐܸܠܝܼ ܘܐܵܢܵܐ ܒܸܚܵܝܵܐ ܝܘܸܢ ܒܘܼܬ ܒܵܒܵܐ، ܗܵܕܟ݂ܵܐ ܐܘܼܦ ܗ̇ܘ ܕܐܵܟܹܠܔ ܠܝܼ ܒܸܬ ܚܵܝܹܐ ܒܘܼܬ ܕܝܼܝܼ. ");
INSERT INTO aii_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","”ܐܵܗܵܐ ܝܠܹܗ ܠܲܚܡܵܐ ܕܨܠܹܐ ܠܹܗ ܡ̣ܢ ܫܡܲܝܵܐ، ܠܵܐ ܐܲܝܟ݂ ܗ̇ܘ ܕܐܟ݂ܝܼܠܔ ܠܗܘܿܢ ܐܲܒ݂ܵܗܵܬܵܘ̈ܟ݂ܘܿܢ ܐܝܼܢܵܐ ܡܝܼܬ ܠܗܘܿܢ. ܡ̇ܢ ܕܐܵܟܹܠܔ ܡ̣ܢ ܐܵܗܵܐ ܠܲܚܡܵܐ ܒܸܬ ܚܵܝܹܐ ܠܥܵܠܲܡ.“ ");
INSERT INTO aii_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ܐܲܢܹܐ ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܟܲܕ ܡܲܠܘܼܦܹܐ ܒܟܢܘܼܫܬܵ‌ܐ ܓܵܘ ܟܦܲܪܢܵܚܘܿܡ. ");
INSERT INTO aii_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ܪܵܒܵܐ ܡ̣ܢ ܬܲܠܡܝܼ̈ܕܹܐ، ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܗܘܿܢ ܐܲܢܹܐ ܗܹܡܸܙܡܵܢܹ̈ܐ، ܐܡܝܼܪܗܘܿܢ: ”ܐܵܗܵܐ ܝܘܼܠܦܵܢܵܐ ܥܲܣܩܵܐ ܝܠܹܗ. ܡܵܢܝܼ ܡܵܨܹܐ ܫܵܡܹܥ ܠܹܗ؟“ ");
INSERT INTO aii_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ܝܼܫܘܿܥ ܝܕܝܼܥ ܠܹܗ ܒܓܵܢܹܗ ܕܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܛܲܪܛܘܼܡܹܐ ܝܗܘܵܘ ܒܘܼܬ ܐܵܗܵܐ، ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܐܵܗܵܐ ܬܘܼܪܩܵܠܵܐ ܝܠܹܗ ܐܸܠܵܘܟ݂ܘܿܢ؟ ");
INSERT INTO aii_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","”ܡܘܼܕܝܼ ܐܸܢ ܚܵܙܹܝܬܘܿܢ ܒܪܘܿܢܵܐ ܕܐܢܵܫܵܐ ܒܹܐܣܵܩܵܐ ܠܕܘܼܟܵܐ ܕܝܼܗܘܵܐ ܡ̣ܢ ܩܲܕܡܵܝܬܵ‌ܐ؟ ");
INSERT INTO aii_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","”ܪܘܼܚܵܐ ܟܹܐ ܝܵܗܒܹܠܔ ܚܲܝܹ̈ܐ، ܦܲܓ݂ܪܵܐ ܠܹܐ ܝܠܹܗ ܡܸܢܕܝܼ. ܗܹܡܸܙܡܵܢܹ̈ܐ ܕܗܲܡܙܘܼܡܹܐ ܝܘܸܢ ܥܲܡܵܘܟ݂ܘܿܢ ܪܘܼܚܵܐ ܝܢܵܐ ܘܚܲܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","”ܐܝܼܢܵܐ ܐܝܼܬ ܓܵܘܵܘܟ݂ܘܿܢ ܐܢܵܫܹ̈ܐ ܕܠܹܐ ܗܲܡܸܢܝܼ.“ ܡ̣ܢ ܩܲܕܡܵܝܬܵ‌ܐ ܝܼܫܘܿܥ ܟܹܐ ܝܵܕܹܥ ܗܘܵܐ ܡܵܢܝܼ ܝܗܘܵܘ ܐܵܢܝܼ ܕܠܹܐ ܗܲܡܸܢܝܼ، ܘܡܵܢܝܼ ܝܗܘܵܐ ܗ̇ܘ ܕܣܲܦܹܐ ܗܘܵܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܒܘܼܬ ܐܵܗܵܐ ܐܡܝܼܪܝܼ ܐܸܠܵܘܟ݂ܘܿܢ ܕܐܢܵܫܵܐ ܠܹܐ ܡܵܨܹܐ ܐܵܬܹ‌ܐ ܠܟܸܣܠܝܼ ܐܸܢ ܒܵܒܝܼ ܠܵܐ ܡܲܥܒܸܕ ܠܹܗ ܕܐܵܬܹ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ܡ̣ܢ ܗ̇ܝ ܥܕܵܢܵܐ ܪܵܒܵܐ ܡ̣ܢ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ ܕܝܼܪܗܘܿܢ ܘܐܚܹܪܢܵܐ ܠܵܐ ܐܙܝܼܠܔ ܠܗܘܿܢ ܒܵܬܪܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ ܠܬܪܸܥܣܲܪ ܬܲܠܡܝܼܕܘܼ̈ܗ‌ܝ: ”ܐܘܼܦ ܐܲܚܬܘܿܢ ܒܵܥܹܝܬܘܿܢ ܕܫܵܒ݂ܩܝܼܬܘܿܢ ܠܝܼ؟“ ");
INSERT INTO aii_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ܓ̰ܘܼܘܸܒ ܠܹܗ ܫܸܡܥܘܿܢ ܟܹܐܦܵܐ ܘܐܡܝܼܪܹܗ: ”ܡܵܪܝܼ، ܠܟܸܣ ܡܵܢܝܼ ܐܵܙܲܠ݇ܚ؟ ܐܲܢ݇ܬ ܐܝܼܬ ܠܘܼܟ݂ ܗܹܡܸܙܡܵܢܹ̈ܐ ܕܚܲܝܹ̈ܐ ܕܠܥܵܠܲܡ. ");
INSERT INTO aii_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","”ܘܐܲܚܢܲܢ ܗܲܡܘܼܢܹܐ ܝܘܲܚ ܘܒܝܼܕܵܥܵܐ ܝܘܲܚ ܕܐܲܢ݇ܬ ܝܼܘܸܬ ܩܲܕܝܼܫܵܐ ܕܐܲܠܵܗܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܠܵܐ ܐܵܢܵܐ ܩܵܡ ܓܲܒܸܢܵܘܟ݂ܘܿܢ ܬܪܸܥܣܲܪ ܘܚܲܕ ܡܸܢܵܘܟ݂ܘܿܢ ܐܵܟܹܠܩܲܪܨܵܐ ܝܠܹܗ؟“ ");
INSERT INTO aii_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ܐܵܗܵܐ ܐܡܝܼܪܹܗ ܒܘܼܬ ܝܼܗܘܼܕܵܐ ܣܟܲܪܝܘܿܛܵܐ ܒܪܘܿܢܵܐ ܕܫܸܡܥܘܿܢ، ܚܲܕ ܡ̣ܢ ܬܪܸܥܣܲܪ، ܕܗܕܝܼܪܵܐ ܝܗܘܵܐ ܕܣܲܦܹܐ ܗܘܵܐ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ܡ̣ܢ ܒܵܬܪ ܐܲܢܹܐ، ܒܸܚܕܵܪܵܐ ܝܗܘܵܐ ܝܼܫܘܿܥ ܓܵܘ ܓܠܝܼܠܵܐ، ܣܵܒܵܒ ܠܹܐ ܒܵܥܹܐ ܗܘܵܐ ܕܦܵܐܹܫ ܗܘܵܐ ܓܵܘ ܝܼܗܘܼܕ، ܒܗ̇ܝ ܕܝܗܘܼܕܵܝܹ̈ܐ ܒܵܥܝܼ ܗܘܵܘ ܠܸܩܛܵܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ܘܩܘܼܪܒܸܢܵܐ ܝܗܘܵܐ ܥܹܐܕܵܐ ܕܡܛܲܠܠܹ̈ܐ ܕܝܗܘܼܕܵܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ܘܐܡܝܼܪܗܘܿܢ ܐܲܚܘܿܢܘܵܬܹ̈‌ܐ ܕܝܼܫܘܿܥ ܐܸܠܹܗ: ”ܫܲܢܝܼ ܡܐܲܟ݂ܵܐ ܘܙܹܠܔ݇ ܠܝܼܗܘܼܕ ܕܚܵܙܝܼ ܐܘܼܦ ܬܲܠܡܝܼܕܘܼ̈ܟ݂ ܦܘܼܠܚܵܢܹ̈ܐ ܕܒܸܥܒ݂ܵܕܵܐ ܝܘܸܬ. ");
INSERT INTO aii_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","”ܐܸܢ ܐܢܵܫܵܐ ܒܵܥܹܐ ܕܦܵܐܹܫ ܝܕܝܼܥܵܐ، ܠܹܐ ܦܵܠܹܚ ܒܛܸܫܘܵܐ. ܐܸܢ ܐܲܢܹܐ ܦܘܼܠܚܵܢܹ̈ܐ ܒܸܥܒ݂ܵܕܵܝ ܝܘܸܬ، ܡܲܚܙܝܼ ܓܵܢܘܼܟ݂ ܠܥܵܠܡܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ܣܵܒܵܒ ܐܘܼܦ ܐܲܚܘܿܢܘܵܬܘܼ̈ܗ‌ܝ ܠܹܐ ܝܗܘܵܘ ܗܘܼܡܸܢܹܐ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܥܕܵܢܝܼ ܗܸܫ ܠܹܐ ܝܠܵܗ̇ ܡܛܝܼܬܵ‌ܐ، ܐܝܼܢܵܐ ܥܕܵܢܵܐ ܕܝܼܵܘܟ݂ܘܿܢ ܒܟܠܔ ܙܲܒ݂ܢܵܐ ܝܠܵܗ̇. ");
INSERT INTO aii_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","”ܠܹܐ ܡܵܨܹܐ ܥܵܠܡܵܐ ܣܵܢܹܐ ܠܵܘܟ݂ܘܿܢ، ܐܝܼܢܵܐ ܐܸܠܝܼ ܟܹܐ ܣܵܢܹܐ ܣܵܒܵܒ ܐܵܢܵܐ ܒܸܣܗܵܕܵܐ ܝܘܸܢ ܒܘܼܬ ܕܝܼܹܗ ܕܦܘܼܠܚܵܢܘܼ̈ܗ‌ܝ ܒܝܼܫܹ̈ܐ ܝܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","”ܣܘܿܩܘܼܢ ܐܲܚܬܘܿܢ ܠܥܹܐܕܵܐ. ܐܵܢܵܐ ܐܵܕܝܼܵܐ ܠܹܐ ܐܵܣܩܹܢ ܠܐܵܗܵܐ ܥܹܐܕܵܐ، ܣܵܒܵܒ ܥܕܵܢܝܼ ܗܸܫ ܠܹܐ ܝܠܵܗ̇ ܡܛܝܼܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ܟܲܕ ܐܡܝܼܪܹܗ ܐܲܢܹܐ، ܦܝܼܫ ܠܹܗ ܓܵܘ ܓܠܝܼܠܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ܐܝܼܢܵܐ ܡ̣ܢ ܒܵܬܪ ܕܐܣܝܼܩ ܠܗܘܿܢ ܐܲܚܘܿܢܘܵܬܘܼ̈ܗ‌ܝ ܠܥܹܐܕܵܐ، ܐܘܼܦ ܝܼܫܘܿܥ ܐܣܝܼܩ ܠܹܗ، ܐܝܼܢܵܐ ܠܵܐ ܓܲܠܝܵܐܝܼܬ، ܐܸܠܵܐ ܒܛܸܫܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ܐܝܼܢܵܐ ܝܗܘܼܕܵܝܹ̈ܐ ܛܵܥܝܼ ܗܘܵܘ ܒܵܬܪܹܗ ܒܥܹܐܕܵܐ ܘܒܲܩܪܝܼ ܗܘܵܘ: ”ܐܲܝܟܵܐ ܝܠܹܗ ܗ̇ܘ ܐܢܵܫܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ܗܘܹܐ ܠܵܗ̇ ܛܲܪܛܲܡܬܵ‌ܐ ܪܵܒܵܐ ܒܘܼܬ ܕܝܼܹܗ ܓܵܘ ܟܸܢܫܵܐ. ܚܲܕܟܡܵܐ ܐܵܡܪܝܼ ܗܘܵܘ: ”ܐܢܵܫܵܐ ܛܵܒ݂ܵܐ ܝܠܹܗ،“ ܘܐܚܹܪ̈ܢܹܐ ܐܵܡܪܝܼ ܗܘܵܘ: ”ܠܵܐ، ܡܲܚܠܘܼܛܹܐ ܝܠܹܗ ܠܟܸܢܫܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ܐܝܼܢܵܐ ܐܘܼܦ ܚܲܕ ܠܹܐ ܗܲܡܙܸܡ ܗܘܵܐ ܓܲܠܝܵܐܝܼܬ ܒܘܼܬ ܕܝܼܹܗ ܡ̣ܢ ܙܕܘܼܥܬܵ‌ܐ ܕܝܗܘܼܕܵܝܹ̈ܐ. ");
INSERT INTO aii_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ܡ̣ܢ ܒܵܬܪ ܕܥܒ݂ܝܼܪܗܘܿܢ ܦܲܠܓܵܐ ܕܝܵܘܡܵܢܹ̈ܐ ܕܥܹܐܕܵܐ، ܐܣܝܼܩ ܠܹܗ ܝܼܫܘܿܥ ܠܗܲܝܟܠܵܐ ܘܡܲܠܸܦ ܗܘܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ܘܥܲܓ̰ܒܝܼ ܗܘܵܘ ܝܗܘܼܕܵܝܹ̈ܐ ܘܐܵܡܪܝܼ ܗܘܵܘ: ”ܕܵܐܟ݂ܝܼ ܐܵܗܵܐ ܒܝܼܕܵܥܵܐ ܝܠܹܗ ܟܬܵܒܹ̈ܐ ܟܲܕ ܠܹܐ ܝܠܹܗ ܝܠܝܼܦܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܝܘܼܠܦܵܢܝܼ ܠܹܐ ܝܠܹܗ ܡ̣ܢ ܓܵܢܝܼ ܐܸܠܵܐ ܡ̣ܢ ܕܗ̇ܘ ܕܫܘܼܕܪܸܢܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","”ܡ̇ܢ ܕܒܵܣܡܵܐ ܠܹܗ ܕܥܵܒܹܕ ܨܸܒ݂ܝܵܢܹܗ، ܒܸܬ ܝܵܕܹܥ ܕܐܸܢ ܝܘܼܠܦܵܢܝܼ ܡ̣ܢ ܐܲܠܵܗܵܐ ܝܠܹܗ ܝܲܢ ܡ̣ܢ ܓܵܢܝܼ ܝܘܸܢ ܡܲܠܘܼܦܹܐ. ");
INSERT INTO aii_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","”ܗ̇ܘ ܕܡ̣ܢ ܓܵܢܹܗ ܗܲܡܙܸܡ، ܚܸܩܪܵܐ ܩܵܐ ܓܵܢܹܗ ܟܹܐ ܛܵܥܹܐ، ܐܝܼܢܵܐ ܗ̇ܘ ܕܛܵܥܹܐ ܚܸܩܪܵܐ ܕܡ̇ܢ ܕܫܘܼܕܸܪܹܗ ܐܸܠܝܼ، ܗ̇ܘ ܫܲܪܝܼܪܵܐ ܝܠܹܗ، ܘܥܵܘܠܵܐ ܠܲܝܬ ܒܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","”ܠܹܐ ܝܗܘܵܐ ܡܘܼܫܹܐ ܕܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܘܟ݂ܘܿܢ ܢܵܡܘܿܣܵܐ؟ ܐܝܼܢܵܐ ܐܘܼܦ ܚܲܕ ܡܸܢܵܘܟ݂ܘܿܢ ܠܹܐ ܝܠܹܗ ܒܸܢܛܵܪܵܐ ܠܢܵܡܘܿܣܵܐ. ܩܵܡܘܿܕܝܼ ܒܸܒܥܵܝܵܐ ܝܬܘܿܢ ܠܸܩܛܵܠܝܼ؟“ ");
INSERT INTO aii_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ܓ̰ܘܼܘܸܒ ܠܹܗ ܟܸܢܫܵܐ ܐܸܠܹܗ: ”ܫܹܐܕܵܐ ܐܝܼܬ ܒܝܼܘܼܟ݂. ܡܵܢܝܼ ܒܵܥܹܐ ܠܸܩܛܵܠܘܼܟ݂؟“ ");
INSERT INTO aii_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܚܲܕ ܦܘܼܠܚܵܢܵܐ ܥܒ݂ܝܼܕ ܠܝܼ ܘܟܠܵܘܟ݂ܘܿܢ ܥܲܓ̰ܘܼܒܹܐ ܝܬܘܿܢ. ");
INSERT INTO aii_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","”ܡܘܼܫܹܐ ܝܘܼܗܒܹܠܔ ܠܹܗ ܐܸܠܵܘܟ݂ܘܿܢ ܓܙܘܼܪܬܵ‌ܐ، ܐܵܦܸܢ ܕܠܹܐ ܝܗܘܵܐ ܡܘܼܫܹܐ ܕܝܘܼܗܒ݂ܵܐ ܠܹܗ ܐܸܠܵܘܟ݂ܘܿܢ ܐܸܠܵܐ ܒܵܒܵܘܵܬܹ̈‌ܐ، ܘܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ ܟܹܐ ܓܵܙܪܝܼܬܘܿܢ ܒܲܪܢܵܫܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","”ܐܸܢ ܐܢܵܫܵܐ ܦܵܐܹܫ ܓܙܝܼܪܵܐ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ ܩܵܐ ܕܠܵܐ ܦܵܐܹܫ ܫܸܪܝܵܐ ܢܵܡܘܿܣܵܐ ܕܡܘܼܫܹܐ، ܩܵܡܘܿܕܝܼ ܒܸܟܪܵܒܵܐ ܝܬܘܿܢ ܡܸܢܝܼ ܕܟܠܵܢܵܐܝܼܬ ܒܘܼܣܸܡ ܠܝܼ ܐܵܗܵܐ ܐܢܵܫܵܐ ܒܝܵܘܡܵܐ ܕܫܲܒܬܵ‌ܐ؟ ");
INSERT INTO aii_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","”ܠܵܐ ܗܵܘܹܝܬܘܿܢ ܒܸܕܝܵܢܵܐ ܒܚܙܵܝܬܵ‌ܐ ܕܦܵܬܵ‌ܐ، ܐܝܼܢܵܐ ܕܘܼܢܘܼܢ ܕܝܵܢܬܵ‌ܐ ܫܲܪܝܼܪܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ܒܗ̇ܝ ܥܕܵܢܵܐ ܚܲܕܟܡܵܐ ܐܢܵܫܹ̈ܐ ܡ̣ܢ ܐܘܿܪܸܫܠܸܡ ܫܘܼܪܹܐ ܠܗܘܿܢ ܠܒܲܩܘܼܪܹܐ: ”ܠܹܐ ܝܠܹܗ ܐܵܗܵܐ ܗ̇ܘ ܕܒܵܥܝܼ ܕܩܵܛܠܝܼ ܠܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","”ܗܵܐ ܡܲܠܘܼܦܹܐ ܝܠܹܗ ܓܲܠܝܵܐܝܼܬ، ܐܘܼܦ ܚܲܕ ܠܹܐ ܝܠܹܗ ܡܲܟܠܘܼܝܹܐ ܐܸܠܹܗ. ܟܹܐ ܝܵܕܥܝܼ ܓܘܼܪ̈ܵܢܲܢ ܒܫܲܪܝܼܪܘܼܬܵ‌ܐ ܕܐܵܗܵܐ ܝܠܹܗ ܡܫܝܼܚܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","”ܐܵܗܵܐ ܟܹܐ ܝܵܕܥܲܚ ܠܹܗ ܡ̣ܢ ܐܲܝܟܵܐ ܝܠܹܗ، ܐܝܼܢܵܐ ܐܝܼܡܲܢ ܕܡܫܝܼܚܵܐ ܐܵܬܹ‌ܐ، ܐܘܼܦ ܚܲܕ ܠܹܐ ܝܵܕܹܥ ܡ̣ܢ ܐܲܝܟܵܐ ܝܠܹܗ.“ ");
INSERT INTO aii_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ܘܟܲܕ ܝܼܫܘܿܥ ܡܲܠܘܼܦܹܐ ܝܗܘܵܐ ܒܗܲܝܟܠܵܐ، ܡܘܼܩܘܸܚ ܠܹܗ ܘܐܡܝܼܪܹܗ: ”ܐܸܠܝܼ ܟܹܐ ܝܵܕܥܝܼܬܘܿܢ، ܘܡ̣ܢ ܐܲܝܟܵܐ ܝܘܸܢ ܟܹܐ ܝܵܕܥܝܼܬܘܿܢ. ܐܝܼܢܵܐ ܐܵܢܵܐ ܡ̣ܢ ܓܵܢܝܼ ܠܵܐ ܐܬܹ‌ܐ ܠܝܼ. ܗ̇ܘ ܕܫܘܼܕܸܪܹܗ ܐܸܠܝܼ ܫܲܪܝܼܪܵܐ ܝܠܹܗ، ܗ̇ܘ ܕܐܲܚܬܘܿܢ ܠܹܐ ܝܵܕܥܝܼܬܘܿܢ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","”ܐܝܼܢܵܐ ܐܵܢܵܐ ܟܹܐ ܝܵܕܥܹܢܹܗ، ܣܵܒܵܒ ܐܵܢܵܐ ܡܸܢܹܗ ܝܘܸܢ ܘܗ̇ܘ ܩܵܡ ܫܲܕܸܪܝܼ.“ ");
INSERT INTO aii_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ܘܒܥܹܐ ܠܗܘܿܢ ܠܸܕܒ݂ܵܩܹܗ، ܐܝܼܢܵܐ ܐܘܼܦ ܚܲܕ ܠܵܐ ܕܪܹܐ ܠܹܗ ܥܲܠܘܼܗ‌ܝ ܐܝܼܕܵܐ ܣܵܒܵܒ ܗܸܫ ܣܵܥܲܬܹܗ ܠܹܐ ܝܗܘܵܐ ܡܛܝܼܬܵ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ܐܝܼܢܵܐ ܪܵܒܵܐ ܡ̣ܢ ܟܸܢܫܵܐ ܗܘܼܡܸܢܗܘܿܢ ܒܝܼܹܗ ܘܐܵܡܪܝܼ ܗܘܵܘ: ”ܩܵܡܘܿ ܐܝܼܡܲܢ ܕܐܵܬܹ‌ܐ ܡܫܝܼܚܵܐ ܒܸܬ ܥܵܒܹܕ ܢܝܼܫܲܢܩܹ̈ܐ ܒܘܼܫ ܙܵܘܕܵܐ ܡ̣ܢ ܐܵܗܵܐ ܕܒܸܥܒ݂ܵܕܵܐ ܝܠܹܗ؟“ ");
INSERT INTO aii_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܗܘܿܢ ܦܪ̈ܝܼܫܹܐ ܠܟܸܢܫܹ̈ܐ ܦܲܟ̰ܦܘܼܟ̰ܹܐ ܐܲܢܹܐ ܚܲܒܪܹ̈ܐ ܒܘܼܬ ܕܝܼܹܗ، ܫܘܼܕܸܪܗܘܿܢ ܐܵܢܝܼ ܘܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܫܘܼܪ̈ܛܹܐ ܕܕܵܒ݂ܩܝܼ ܗܘܵܘ ܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ܐܡܝܼܪܹܗ ܝܼܫܘܿܥ: ”ܥܲܡܵܘܟ݂ܘܿܢ ܝܼܘܸܢ ܩܵܐ ܚܲܕ ܙܲܒ݂ܢܵܐ ܟܸܪܝܵܐ، ܘܗ̇ܝܓܵܗ ܒܸܬ ܐܵܙܹܠ݇ܢ ܠܟܸܣ ܗ̇ܘ ܕܫܘܼܕܸܪܹܗ ܐܸܠܝܼ. ");
INSERT INTO aii_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","”ܒܸܬ ܛܵܥܹܝܬܘܿܢ ܒܵܬܪܝܼ ܘܠܹܐ ܡܲܫ݇ܟ̰ܚܝܼܬܘܿܢ ܠܝܼ، ܘܐܲܝܟܵܐ ܕܐܵܢܵܐ ܝܘܸܢ، ܐܲܚܬܘܿܢ ܠܹܐ ܡܵܨܹܝܬܘܿܢ ܐܵܬܹܝܬܘܿܢ.“ ");
INSERT INTO aii_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ܐܡܝܼܪܗܘܿܢ ܝܗܘܼܕܵܝܹ̈ܐ ܚܲܕ ܠܗ̇ܘ ܐܚܹܪܢܵܐ: ”ܠܐܲܝܟܵܐ ܒܵܥܹܐ ܐܵܙܹܠܔ ܐܵܗܵܐ ܕܐܲܚܢܲܢ ܠܹܐ ܚܵܙܲܚ ܠܹܗ؟ ܩܵܡܘܿܕܝܼ ܒܵܥܹܐ ܐܵܙܹܠܔ ܠܟܸܣ ܒܢܲܝ̈ ܐܘܼܡܬܲܢ ܕܝܼܢܵܐ ܒܘܼܪܒܸܙܹܐ ܓܵܘ ܝܵܘܢܵܝܹ̈ܐ ܘܡܲܠܸܦ ܠܝܵܘܢܵܝܹ̈ܐ؟ ");
INSERT INTO aii_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","”ܡܘܼܕܝܼ ܝܠܹܗ ܐܵܗܵܐ ܕܒܹܐܡܵܪܵܐ ܝܠܹܗ: ’ܒܸܬ ܛܵܥܹܝܬܘܿܢ ܒܵܬܪܝܼ ܘܠܹܐ ܡܲܫ݇ܟ̰ܚܝܼܬܘܿܢ ܠܝܼ، ܘܠܐܲܝܟܵܐ ܕܐܵܢܵܐ ܝܘܸܢ ܐܲܚܬܘܿܢ ܠܹܐ ܡܵܨܹܝܬܘܿܢ ܐܵܬܹܝܬܘܿܢ‘؟“ ");
INSERT INTO aii_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ܒܝܵܘܡܵܐ ܐܚܵܪܵܝܵܐ ܕܥܹܐܕܵܐ، ܝܵܘܡܵܐ ܓܘܼܪܵܐ، ܟܠܹܐ ܠܹܗ ܝܼܫܘܿܥ ܘܗܘܼܡܙܸܡ ܠܹܗ ܒܩܵܠܵܐ ܪܵܡܵܐ ܘܐܡܝܼܪܹܗ: ”ܡ̇ܢ ܕܨܹܗܝܵܐ ܝܠܹܗ، ܐܵܬܹ‌ܐ ܠܟܸܣܠܝܼ ܘܫܵܬܹܐ، ");
INSERT INTO aii_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","”ܘܟܠܔ ܡ̇ܢ ܕܗܲܡܸܢ ܒܝܼܝܼ، ܢܲܗܪ̈ܵܘܵܬܹ‌ܐ ܕܡ̈ܝܼܵܐ ܚܵܝܹ̈ܐ ܒܸܬ ܗܵܘܝܼ ܒܸܫܦܵܟ݂ܵܐ ܡ̣ܢ ܟܹܪ݇ܣܹܗ، ܕܵܐܟ݂ܝܼ ܕܐܡܝܼܪܗܘܿܢ ܟܬܵܒܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ܐܵܗܵܐ ܐܡܝܼܪܹܗ ܒܘܼܬ ܪܘܼܚܵܐ ܕܩܲܒܠܝܼ ܗܘܵܘ ܐܵܢܝܼ ܕܗܲܡܸܢܝܼ ܗܘܵܘ ܒܝܼܹܗ. ܗܲܠܔ ܐܵܗܵܐ ܥܕܵܢܵܐ ܪܘܼܚܵܐ ܠܹܐ ܝܗܘܵܐ ܦܝܼܫܵܐ ܝܘܼܗܒ݂ܵܐ ܣܵܒܵܒ ܗܸܫ ܝܼܫܘܿܥ ܠܹܐ ܝܗܘܵܐ ܦܝܼܫܵܐ ܚܩܝܼܪܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ܪܵܒܵܐ ܡ̣ܢ ܟܸܢܫܵܐ ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܗܘܿܢ ܗܹܡܸܙܡܵܢܘܼ̈ܗ‌ܝ ܐܡܝܼܪܗܘܿܢ: ”ܫܲܪܝܼܪܵܐܝܼܬ ܐܵܗܵܐ ܝܠܹܗ ܗ̇ܘ ܢܒ݂ܝܼܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ܐܚܹܪ̈ܢܹܐ ܐܵܡܪܝܼ ܗܘܵܘ: ”ܐܵܗܵܐ ܝܠܹܗ ܡܫܝܼܚܵܐ.“ ܘܐܚܹܪ̈ܢܹܐ ܒܲܩܪܝܼ ܗܘܵܘ: ”ܩܵܡܘܿ ܟܹܐ ܗܵܘܝܵܐ ܕܡܫܝܼܚܵܐ ܐܵܬܹ‌ܐ ܡ̣ܢ ܓܠܝܼܠܵܐ؟ ");
INSERT INTO aii_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","”ܠܵܐ ܐܡܝܼܪܹܗ ܟܬܵܒ݂ܵܐ، ܕܡ̣ܢ ܙܲܪܥܵܐ ܕܕܵܘܝܼܕ ܘܡ̣ܢ ܒܹܝܬܠܚܸܡ ܡܵܬܵ‌ܐ، ܐܲܝܟܵܐ ܕܕܵܘܝܼܕ ܥܡܝܼܪܹܗ ܒܸܬ ܐܵܬܹ‌ܐ ܡܫܝܼܚܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ܗܵܕܟ݂ܵܐ ܗܘܹܐ ܠܹܗ ܓܵܘ ܟܸܢܫܵܐ ܦܘܼܠܵܓ݂ܵܐ ܒܘܼܬ ܕܝܼܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ܚܲܕܟܡܵܐ ܒܥܹܐ ܠܗܘܿܢ ܕܕܵܒ݂ܩܝܼ ܗܘܵܘ ܠܹܗ، ܐܝܼܢܵܐ ܐܘܼܦ ܚܲܕ ܠܵܐ ܕܪܹܐ ܠܹܗ ܐܝܼܕܵܐ ܥܲܠܘܼܗ‌ܝ. ");
INSERT INTO aii_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ܐܝܼܡܲܢ ܕܕܝܼܪܗܘܿܢ ܫܘܼܪ̈ܛܹܐ ܠܟܸܣ ܓܘܼܪ̈ܵܢܹܐ ܕܟܵܗ̈ܢܹܐ ܘܦܪ̈ܝܼܫܹܐ، ܐܡܝܼܪܗܘܿܢ ܐܸܠܵܝܗ‌ܝ ܟܵܗ̈ܢܹܐ: ”ܩܵܡܘܿܕܝܼ ܠܵܐ ܡܘܼܝܬܹ‌ܐ ܠܵܘܟ݂ܘܿܢ ܐܸܠܹܗ؟“ ");
INSERT INTO aii_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܫܘܼܪ̈ܛܹܐ: ”ܐܘܼܦ ܚܲܕ ܐܢܵܫܵܐ ܠܹܐ ܝܠܹܗ ܗܘܼܡܙܸܡܵܐ ܡܐܲܝܟ݂ ܕܝܼܠܹܗ ܐܵܗܵܐ ܐܢܵܫܵܐ ܗܲܡܙܘܼܡܹܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܐܸܠܵܝܗ‌ܝ ܦܪ̈ܝܼܫܹܐ: ”ܗܵܐ ܐܘܼܦ ܐܸܠܵܘܟ݂ܘܿܢ ܡܘܼܚܠܸܛ ܠܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","”ܩܵܡܘܿ ܐܢܵܫܵܐ ܡ̣ܢ ܓܘܼܪ̈ܵܢܹܐ ܝܲܢ ܡ̣ܢ ܦܪ̈ܝܼܫܹܐ ܗܘܼܡܸܢܹܗ ܒܝܼܹܗ؟ ");
INSERT INTO aii_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","”ܐܝܼܢܵܐ ܠܝܼܛܵܐ ܝܠܹܗ ܐܵܗܵܐ ܟܸܢܫܵܐ ܕܠܹܐ ܝܵܕܹܥ ܢܵܡܘܿܣܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ ܢܝܼܩܵܕܹܡܘܿܣ، ܚܲܕ ܡܸܢܵܝܗ‌ܝ، ܗ̇ܘ ܕܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣ ܝܼܫܘܿܥ ܩܲܕܡܵܝܬܵ‌ܐ: ");
INSERT INTO aii_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","”ܩܵܡܘܿ ܢܵܡܘܿܣܲܢ ܟܹܐ ܕܵܐܹܢ ܠܚܲܕ ܐܢܵܫܵܐ ܡܩܲܕܡ ܕܫܵܡܥܲܚ ܠܹܗ ܘܚܵܙܲܚ ܡܘܼܕܝܼ ܝܠܹܗ ܥܒ݂ܝܼܕܵܐ؟“ ");
INSERT INTO aii_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܐܸܠܹܗ ܘܐܡܝܼܪܗܘܿܢ: ”ܩܵܡܘܿ ܐܘܼܦ ܐܲܢ݇ܬ ܡ̣ܢ ܓܠܝܼܠܵܐ ܝܘܸܬ؟ ܨܲܚܨܝܼ ܘܚܙܝܼ، ܕܢܒ݂ܝܼܵܐ ܡ̣ܢ ܓܠܝܼܠܵܐ ܠܹܐ ܦܵܠܹܛ.“ ");
INSERT INTO aii_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ܗ̇ܝܓܵܗ ܟܠܔ ܚܲܕ ܐܙܝܼܠܔ ܠܹܗ ܠܒܲܝܬܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ܐܙܝܼܠܔ ܠܹܗ ܝܼܫܘܿܥ ܠܛܘܼܪܵܐ ܕܙܲܝ̈ܬܹ‌ܐ. ");
INSERT INTO aii_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ܘܒܨܲܦܪܵܐ ܡܸܢܕܪܸܫ ܐܬܹ‌ܐ ܠܹܗ ܠܗܲܝܟܠܵܐ، ܘܟܠܹܗ ܥܲܡܵܐ ܐܬܹ‌ܐ ܠܹܗ ܠܟܸܣܠܹܗ، ܘܟܲܕ ܝܬܝܼܒ݂ ܠܹܗ، ܫܘܼܪܹܐ ܠܹܗ ܡܲܠܘܼܦܵܝ. ");
INSERT INTO aii_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ܡܘܼܝܬܹ‌ܐ ܠܗܘܿܢ ܠܟܸܣܠܹܗ ܣܵܦܪܹ̈ܐ ܘܦܪ̈ܝܼܫܹܐ ܚܕܵܐ ܒܲܟ݂ܬܵ‌ܐ ܕܒ݂ܝܼܩܬܵ‌ܐ ܒܓܲܝܵܪܘܼܬܵ‌ܐ، ܘܟܲܕ ܡܘܼܟܠܝܼܵܐ ܠܗܘܿܢ ܒܹܝܦܲܠܓܵܐ، ");
INSERT INTO aii_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ܐܡܝܼܪܗܘܿܢ ܐܸܠܹܗ: ”ܡܲܠܦܵܢܵܐ، ܐܵܗܵܐ ܒܲܟ݂ܬܵ‌ܐ ܦܝܼܫ ܠܵܗ̇ ܕܒ݂ܝܼܩܬܵ‌ܐ ܓܲܠܝܵܐܝܼܬ ܒܫܘܼܠܵܐ ܕܓܲܝܵܪܘܼܬܵ‌ܐ، ");
INSERT INTO aii_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","”ܘܡܘܼܫܹܐ ܒܢܵܡܘܿܣܵܐ ܦܩܝܼܕ ܠܹܗ ܐܸܠܲܢ، ܐܵܢܝܼ ܕܥܵܒ݂ܕܝܼ ܗܵܕܟ݂ܵܐ ܦܵܝܫܝܼ ܪܓ̰ܝܼܡܹܐ. ܐܲܢ݇ܬ ܡܘܼܕܝܼ ܒܹܐܡܵܪܵܐ ܝܘܸܬ؟“ ");
INSERT INTO aii_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ܐܡܝܼܪܗܘܿܢ ܗܵܕܟ݂ܵܐ ܕܓ̰ܲܪܒܝܼ ܗܘܵܘ ܠܹܗ، ܕܗܵܘܹܐ ܗܘܵܐ ܠܗܘܿܢ ܥܸܠܬܵ‌ܐ ܕܩܵܒ݂ܠܝܼ ܗܘܵܘ ܥܲܠܘܼܗ‌ܝ. ܐܝܼܢܵܐ ܝܼܫܘܿܥ ܟܝܼܦ ܠܹܗ ܘܫܘܼܪܹܐ ܠܹܗ ܒܸܟܬܵܒ݂ܵܐ ܒܨܸܒܥܹܗ ܥܲܠܔ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ܐܝܼܢܵܐ ܟܲܕ ܡܘܼܙܝܸܕ ܠܗܘܿܢ ܠܒܲܩܘܼܪܹܗ، ܩܝܼܡ ܠܹܗ ܘܐܡܝܼܪܹܗ ܐܸܠܵܝܗ‌ܝ: ”ܟܠܔ ܡܸܢܵܘܟ݂ܘܿܢ ܕܝܼܠܹܗ ܕܠܵܐ ܚܛܝܼܬܵ‌ܐ ܕܵܪܹܐ ܒܝܼܘܼܗ̇ ܟܹܐܦܵܐ ܩܲܕܡܵܝܵܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ܡܸܢܕܪܸܫ ܟܝܼܦ ܠܹܗ ܒܸܟܬܵܒ݂ܵܐ ܥܲܠܔ ܐܲܪܥܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ܘܐܵܢܝܼ ܐܝܼܡܲܢ ܕܫܡܝܼܥ ܠܗܘܿܢ ܐܵܗܵܐ، ܦܠܝܼܛ ܠܗܘܿܢ ܚܲܕ ܒܚܲܕ، ܫܘܼܪܹܐ ܠܗܘܿܢ ܡ̣ܢ ܚܘܵܪ̈ܕܸܩܢܹܐ ܗܲܠܔ ܗ̇ܘ ܐܚܵܪܵܝܵܐ، ܘܦܝܼܫ ܠܹܗ ܝܼܫܘܿܥ ܒܢܲܦ̮ܫܹܗ، ܘܒܲܟ݂ܬܵ‌ܐ ܟܠܝܼܬܵ‌ܐ ܒܹܝܦܲܠܓܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ܐܝܼܡܲܢ ܕܩܝܼܡ ܠܹܗ ܝܼܫܘܿܥ، ܒܘܼܩܸܪܹܗ ܡܸܢܘܼܗ̇: ”ܒܲܟ݂ܬܵ‌ܐ، ܐܲܝܟܵܐ ܝܢܵܐ؟ ܐܢܵܫܵܐ ܠܵܐ ܩܵܡ ܕܵܐܹܢܵܟ݂ܝ؟“ ");
INSERT INTO aii_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ܘܗ̇ܝ ܓ̰ܘܼܘܸܒ ܠܵܗ̇: ”ܐܵܦܠܵܐ ܚܲܕ، ܡܵܪܝܼ.“ ܐܡܝܼܪܹܗ ܐܸܠܘܼܗ̇ ܝܼܫܘܿܥ: ”ܐܘܼܦ ܐܵܢܵܐ ܠܹܐ ܕܵܝܢܹܢܵܟ݂ܝ. ܙܹܠ݇ܝ، ܡ̣ܢ ܐܵܕܝܼܵܐ ܐܚܹܪܢܵܐ ܠܵܐ ܚܵܛܝܲܬ‌ܝ.“ ");
INSERT INTO aii_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ܗܘܼܡܙܸܡ ܠܹܗ ܝܼܫܘܿܥ ܡܸܢܕܪܸܫ ܠܟܸܢܫܵܐ ܘܐܡܝܼܪܹܗ: ”ܐܵܢܵܐ ܝܘܸܢ ܒܲܗܪܵܐ ܕܕܘܼܢܝܹܐ. ܡ̇ܢ ܕܐܵܬܹ‌ܐ ܒܵܬܪܝܼ ܠܹܐ ܚܵܕܹܪ ܓܵܘ ܚܸܫܟܵܐ، ܐܸܠܵܐ ܒܸܬ ܗܵܘܹܐ ܠܹܗ ܒܲܗܪܵܐ ܕܚܲܝܹ̈ܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ܓ̰ܘܼܘܸܒ ܠܗܘܿܢ ܐܸܠܹܗ ܦܪ̈ܝܼܫܹܐ: ”ܐܲܢ݇ܬ ܒܸܣܗܵܕܵܐ ܝܘܸܬ ܥܲܠܔ ܓܵܢܘܼܟ݂، ܘܣܵܗܕܘܼܬܘܼܟ݂ ܠܹܐ ܝܠܵܗ̇ ܫܲܪܝܼܪܬܵ‌ܐ.“ ");
INSERT INTO aii_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ܓ̰ܘܼܘܸܒ ܠܹܗ ܐܸܠܵܝܗ‌ܝ ܝܼܫܘܿܥ: ”ܐܘܼܦ ܐܸܢ ܕܒܸܣܗܵܕܵܐ ܝܘܸܢ ܥܲܠܔ ܓܵܢܝܼ، ܣܵܗܕܘܼܬ‌ܝܼ ܫܲܪܝܼܪܬܵ‌ܐ ܝܠܵܗ̇ ܣܵܒܵܒ ܟܹܐ ܝܵܕܥܹܢ ܡ̣ܢ ܐܲܝܟܵܐ ܐܬܹ‌ܐ ܠܝܼ ܘܠܐܲܝܟܵܐ ܒܹܐܙܵܠܵܐ ܝܘܸܢ. ܐܝܼܢܵܐ ܐܲܚܬܘܿܢ ܠܹܐ ܝܵܕܥܝܼܬܘܿܢ ܡ̣ܢ ܐܲܝܟܵܐ ܐܬܹ‌ܐ ܠܝܼ ܘܠܐܲܝܟܵܐ ܒܹܐܙܵܠܵܐ ܝܘܸܢ. ");
INSERT INTO aii_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","”ܐܲܚܬܘܿܢ ܒܸܕܝܵܢܵܐ ܝܬܘܿܢ ܒܟܝܘܼܠܵܐ ܕܒܢܲܝ̈ܢܵܫܵܐ، ܐܵܢܵܐ ܠܐܢܵܫܵܐ ܠܹܐ ܝܘܸܢ ܒܸܕܝܵܢܵܐ. ");
INSERT INTO aii_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","”ܐܘܼܦ ܐܸܢ ܕܐܵܢܵܐ ܕܵܝܢܹܢ، ܕܝܵܢܬ‌ܝܼ ܫܲܪܝܼܪܬܵ‌ܐ ܝܠܵܗ̇، ܣܵܒܵܒ ܐܵܢܵܐ ܠܹܐ ܝܘܸܢ ܒܢܲܦ̮ܫܝܼ، ܐܸܠܵܐ ܒܵܒܵܐ ܕܫܘܼܕܸܪܹܗ ܐܸܠܝܼ ܥܲܡܝܼ ܝܠܹܗ. ");
INSERT INTO aii_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","”ܟܬܝܼܒ݂ܵܐ ܝܠܹܗ ܒܢܵܡܘܿܣܵܘܟ݂ܘܿܢ، ܣܵܗܕܘܼܬܵ‌ܐ ܕܬܪܹܝ ܐܢܵ